﻿USE sofia;
DROP TABLE IF EXISTS sofia.fra_fob_vpl;
CREATE TABLE fra_fob_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES fra_fob_vpl WRITE;
INSERT INTO fra_fob_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Au commencement, Dieu créa les cieux et la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Or la terre était informe et vide, et les ténèbres étaient à la surface de l'abîme, et l'Esprit de Dieu se mouvait sur les eaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Et Dieu dit: Que la lumière soit; et la lumière fut. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Et Dieu vit que la lumière était bonne; et Dieu sépara la lumière d'avec les ténèbres. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Et Dieu nomma la lumière, jour; et il nomma les ténèbres, nuit. Et il y eut un soir, et il y eut un matin; ce fut le premier jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Puis Dieu dit: Qu'il y ait une étendue entre les eaux; et qu'elle sépare les eaux d'avec les eaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Et Dieu fit l'étendue, et sépara les eaux qui sont au-dessous de l'étendue, d'avec les eaux qui sont au-dessus de l'étendue; et cela fut ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Et Dieu nomma l'étendue, cieux. Et il y eut un soir, et il y eut un matin; ce fut le second jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Puis Dieu dit: Que les eaux qui sont au-dessous des cieux se rassemblent en un seul lieu, et que le sec paraisse; et cela fut ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Et Dieu nomma le sec, terre; et il nomma l'amas des eaux, mers; et Dieu vit que cela était bon. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Puis Dieu dit: Que la terre pousse de la végétation, des herbes portant semence, des arbres fruitiers portant du fruit selon leur espèce, qui aient leur semence en eux-mêmes sur la terre; et cela fut ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Et la terre produisit de la végétation, des herbes portant semence selon leur espèce, et des arbres portant du fruit, qui avaient leur semence en eux-mêmes, selon leur espèce; et Dieu vit que cela était bon. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Et il y eut un soir, et il y eut un matin; ce fut le troisième jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Puis Dieu dit: Qu'il y ait des luminaires dans l'étendue des cieux, pour séparer le jour d'avec la nuit, et qu'ils servent de signes, et pour les saisons, et pour les jours, et pour les années; ");
INSERT INTO fra_fob_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Et qu'ils servent de luminaires dans l'étendue des cieux, pour éclairer la terre; et cela fut ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Et Dieu fit les deux grands luminaires; le grand luminaire, pour dominer sur le jour, et le petit luminaire, pour dominer sur la nuit; il fit aussi les étoiles. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Et Dieu les mit dans l'étendue des cieux, pour éclairer la terre; ");
INSERT INTO fra_fob_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Et pour dominer sur le jour et sur la nuit, et pour séparer la lumière d'avec les ténèbres; et Dieu vit que cela était bon. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Et il y eut un soir, et il y eut un matin; ce fut le quatrième jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Puis Dieu dit: Que les eaux produisent en abondance des êtres vivants; et que des oiseaux volent sur la terre devant l'étendue des cieux. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Et Dieu créa les grands poissons, et tous les êtres vivants qui se meuvent, dont les eaux foisonnèrent, selon leurs espèces, et tout oiseau ailé, selon son espèce; et Dieu vit que cela était bon. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Et Dieu les bénit, en disant: Croissez et multipliez, et remplissez les eaux dans les mers; et que les oiseaux multiplient sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Et il y eut un soir, et il y eut un matin; ce fut le cinquième jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Puis Dieu dit: Que la terre produise des êtres vivants selon leur espèce, bétail, reptiles et animaux de la terre selon leur espèce; et cela fut ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Et Dieu fit les animaux de la terre selon leur espèce, le bétail selon son espèce, et tous les reptiles du sol selon leur espèce; et Dieu vit que cela était bon. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Puis Dieu dit: Faisons l'homme à notre image, selon notre ressemblance, et qu'il domine sur les poissons de la mer, et sur les oiseaux des cieux, et sur le bétail, et sur toute la terre, et sur tous les reptiles qui rampent sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Et Dieu créa l'homme à son image; il le créa à l'image de Dieu; il les créa mâle et femelle. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Et Dieu les bénit; et Dieu leur dit: Croissez et multipliez, et remplissez la terre, et l'assujettissez, et dominez sur les poissons de la mer et sur les oiseaux des cieux, et sur tout animal qui se meut sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Et Dieu dit: Voici je vous ai donné toute herbe portant semence, qui est à la surface de toute la terre, et tout arbre qui a en soi du fruit d'arbre portant semence; ce sera votre nourriture. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Et à tous les animaux des champs, et à tous les oiseaux des cieux, et à tout ce qui se meut sur la terre, qui a en soi une âme vivante, j'ai donné toute herbe verte pour nourriture; et cela fut ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Et Dieu vit tout ce qu'il avait fait, et voici, c'était très bon. Et il y eut un soir, et il y eut un matin; ce fut le sixième jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ainsi furent achevés les cieux et la terre, et toute leur armée. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Et Dieu eut achevé au septième jour son œuvre qu'il avait faite; et il se reposa au septième jour de toute son œuvre qu'il avait faite. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Et Dieu bénit le septième jour, et le sanctifia, parce qu'en ce jour-là il se reposa de toute son œuvre, pour l'accomplissement de laquelle Dieu avait créé. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Telles sont les origines des cieux et de la terre, quand ils furent créés, lorsque l'Éternel Dieu fit la terre et les cieux. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Or aucun arbrisseau des champs n'était encore sur la terre, et aucune herbe des champs ne germait encore; car l'Éternel Dieu n'avait point fait pleuvoir sur la terre, et il n'y avait point d'homme pour cultiver le sol; ");
INSERT INTO fra_fob_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mais une vapeur montait de la terre, et arrosait toute la surface du sol. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Et l'Éternel Dieu forma l'homme de la poussière de la terre, et souffla dans ses narines une respiration de vie; et l'homme devint une âme vivante. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Et l'Éternel Dieu planta un jardin en Éden du côté de l'Orient, et y mit l'homme qu'il avait formé. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Et l'Éternel Dieu fit germer du sol toute sorte d'arbres agréables à la vue, et bons à manger, et l'arbre de vie au milieu du jardin, et l'arbre de la connaissance du bien et du mal. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Et un fleuve sortait d'Éden pour arroser le jardin; et de là il se divisait et formait quatre bras. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Le nom du premier est Pishon; c'est celui qui entoure le pays de Havila, où se trouve l'or. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Et l'or de ce pays est bon; là se trouve le bdellion, et la pierre d'onyx. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Le nom du second fleuve est Guihon; c'est celui qui entoure tout le pays de Cush. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Le nom du troisième fleuve est Hiddékel; c'est celui qui coule à l'orient de l'Assyrie. Et le quatrième fleuve, c'est l'Euphrate. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","L'Éternel Dieu prit donc l'homme et le plaça dans le jardin d'Éden, pour le cultiver et pour le garder. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Et l'Éternel Dieu commanda à l'homme, en disant: Tu peux manger librement de tout arbre du jardin. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Mais, quant à l'arbre de la connaissance du bien et du mal, tu n'en mangeras point; car au jour où tu en mangeras, certainement tu mourras. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Et l'Éternel Dieu dit: Il n'est pas bon que l'homme soit seul; je lui ferai une aide semblable à lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Et l'Éternel Dieu forma de la terre tous les animaux des champs, et tous les oiseaux des cieux; et il les fit venir vers Adam, pour voir comment il les nommerait, et que tout nom qu'Adam donnerait à chacun des êtres vivants, fût son nom. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Et Adam donna des noms à toutes les bêtes, et aux oiseaux des cieux, et à tous les animaux des champs; mais, pour l'homme, il ne trouva point d'aide semblable à lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Et l'Éternel Dieu fit tomber un profond sommeil sur Adam, qui s'endormit; et il prit une de ses côtes, et resserra la chair à sa place. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Et l'Éternel Dieu forma une femme de la côte qu'il avait prise d'Adam, et la fit venir vers Adam. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Et Adam dit: Celle-ci enfin est os de mes os, et chair de ma chair. Celle-ci sera nommée femme (en hébreu Isha), car elle a été prise de l'homme (en hébreu Ish). ");
INSERT INTO fra_fob_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","C'est pourquoi l'homme laissera son père et sa mère, et s'attachera à sa femme, et ils seront une seule chair. ");
INSERT INTO fra_fob_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Or Adam et sa femme étaient tous deux nus, et ils n'en avaient point honte. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Or, le serpent était le plus fin de tous les animaux des champs, que l'Éternel Dieu avait faits; et il dit à la femme: Quoi! Dieu aurait dit: Vous ne mangerez point de tout arbre du jardin! ");
INSERT INTO fra_fob_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Et la femme répondit au serpent: Nous mangeons du fruit des arbres du jardin; ");
INSERT INTO fra_fob_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mais quant au fruit de l'arbre qui est au milieu du jardin, Dieu a dit: Vous n'en mangerez point, et vous n'y toucherez point, de peur que vous ne mouriez. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Alors le serpent dit à la femme: Vous ne mourrez nullement; ");
INSERT INTO fra_fob_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mais Dieu sait qu'au jour où vous en mangerez, vos yeux s'ouvriront, et vous serez comme des dieux, connaissant le bien et le mal. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Et la femme vit que le fruit de l'arbre était bon à manger, et qu'il était agréable à la vue, et que l'arbre était désirable pour devenir intelligent; et elle prit de son fruit et en mangea, et en donna aussi à son mari auprès d'elle, et il en mangea. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Et les yeux de tous deux s'ouvrirent; et ils connurent qu'ils étaient nus; et ils cousirent des feuilles de figuier, et se firent des ceintures. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Et ils entendirent la voix de l'Éternel Dieu, qui se promenait dans le jardin, au vent du jour. Et Adam et sa femme se cachèrent de devant la face de l'Éternel Dieu, au milieu des arbres du jardin. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Et l'Éternel Dieu appela Adam, et lui dit: Où es-tu? ");
INSERT INTO fra_fob_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Et il répondit: J'ai entendu ta voix dans le jardin, et j'ai craint, parce que je suis nu; et je me suis caché. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Et Dieu dit: Qui t'a montré que tu es nu? As-tu mangé de l'arbre dont je t'avais ordonné de ne pas manger? ");
INSERT INTO fra_fob_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Et Adam répondit: La femme que tu as mise auprès de moi, m'a donné du fruit de l'arbre, et j'en ai mangé. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Et l'Éternel Dieu dit à la femme: Pourquoi as-tu fait cela? Et la femme répondit: Le serpent m'a séduite, et j'en ai mangé. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Alors l'Éternel Dieu dit au serpent: Puisque tu as fait cela, tu seras maudit entre toutes les bêtes et entre tous les animaux des champs; tu marcheras sur ton ventre, et tu mangeras la poussière tous les jours de ta vie. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Et je mettrai inimitié entre toi et la femme, entre ta postérité et sa postérité: celle-ci t'écrasera la tête, et toi tu la blesseras au talon. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Il dit à la femme: J'augmenterai beaucoup ta peine et ta grossesse; tu enfanteras des enfants avec douleur, et tes désirs se tourneront vers ton mari, et il dominera sur toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Et il dit à Adam: Puisque tu as obéi à la voix de ta femme, et que tu as mangé de l'arbre au sujet duquel je t'avais donné cet ordre: Tu n'en mangeras point! le sol sera maudit à cause de toi; tu en mangeras les fruits avec peine tous les jours de ta vie. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Et il te produira des épines et des chardons; et tu mangeras l'herbe des champs. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tu mangeras le pain à la sueur de ton visage, jusqu'à ce que tu retournes dans la terre, d'où tu as été pris; car tu es poussière, et tu retourneras dans la poussière. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Or, Adam appela sa femme, Eve (vie), parce qu'elle fut la mère de tous les vivants. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Et l'Éternel Dieu fit à Adam et à sa femme des robes de peau, et les en revêtit. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Et l'Éternel Dieu dit: Voici, l'homme est devenu comme l'un de nous, pour la connaissance du bien et du mal. Et maintenant prenons garde qu'il n'avance sa main, et ne prenne aussi de l'arbre de vie, et qu'il n'en mange, et ne vive à toujours. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Et l'Éternel Dieu le fit sortir du jardin d'Éden, pour cultiver la terre d'où il avait été pris. ");
INSERT INTO fra_fob_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Il chassa donc l'homme; et il plaça à l'orient du jardin d'Éden les chérubins et la lame d'épée flamboyante, pour garder le chemin de l'arbre de vie. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Or, Adam connut Eve sa femme, et elle conçut, et enfanta Caïn (acquisition), et elle dit: J'ai acquis un homme avec l'aide de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Elle enfanta encore son frère Abel; et Abel fut berger, et Caïn fut laboureur. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Or, au bout de quelque temps, Caïn offrit des fruits de la terre une oblation à l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Et Abel offrit, lui aussi, des premiers-nés de son troupeau, et de leurs graisses. Et l'Éternel eut égard à Abel, et à son oblation; ");
INSERT INTO fra_fob_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Mais il n'eut point égard à Caïn, ni à son oblation; et Caïn fut fort irrité, et son visage fut abattu. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Et l'Éternel dit à Caïn: Pourquoi es-tu irrité, et pourquoi ton visage est-il abattu? ");
INSERT INTO fra_fob_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Si tu fais bien, ne relèveras-tu pas ton visage? Mais, si tu ne fais pas bien, le péché est couché à la porte, et son désir est tourné vers toi; mais toi, tu dois dominer sur lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Et Caïn parla à Abel, son frère. Et comme ils étaient aux champs, Caïn s'éleva contre Abel son frère, et le tua. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Et l'Éternel dit à Caïn: Où est Abel ton frère? Et il répondit: Je ne sais; suis-je le gardien de mon frère, moi? ");
INSERT INTO fra_fob_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Et l'Éternel dit: Qu'as-tu fait? La voix du sang de ton frère crie de la terre jusqu'à moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Et maintenant tu seras maudit de la terre, qui a ouvert sa bouche pour recevoir de ta main le sang de ton frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Quand tu cultiveras la terre, elle ne te rendra plus son fruit; tu seras vagabond et fugitif sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Et Caïn dit à l'Éternel: Ma peine est trop grande pour être supportée. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Voici, tu m'as chassé aujourd'hui de cette terre, et je serai caché de devant ta face, et je serai vagabond et fugitif sur la terre; et il arrrivera que quiconque me trouvera, me tuera. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Et l'Éternel lui dit: C'est pourquoi, si quelqu'un tue Caïn, Caïn sera vengé sept fois. Et l'Éternel mit à Caïn un signe, afin que quiconque le trouverait ne le tuât point. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Alors Caïn sortit de devant l'Éternel, et habita au pays de Nod (exil), à l'orient d'Éden. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Puis Caïn connut sa femme, qui conçut et enfanta Hénoc; or il construisit une ville, qu'il appela Hénoc, du nom de son fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Puis Irad naquit à Hénoc, et Irad engendra Mehujaël, et Mehujaël engendra Methushaël, et Methushaël engendra Lémec. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Et Lémec prit deux femmes: le nom de l'une était Ada, le nom de l'autre Tsilla. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Et Ada enfanta Jabal; il fut père de ceux qui demeurent dans des tentes et près des troupeaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Et le nom de son frère était Jubal; il fut père de tous ceux qui jouent de la harpe et du chalumeau. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Et Tsilla, elle aussi, enfanta Tubal-Caïn, qui forgeait toute sorte d'instruments tranchants d'airain et de fer; et la sœur de Tubal-Caïn fut Naama. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Et Lémec dit à ses femmes: Ada et Tsilla, écoutez ma voix; femmes de Lémec, prêtez l'oreille à ma parole: Oui! j'ai tué un homme pour ma blessure, et un jeune homme pour ma meurtrissure. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Car si Caïn est vengé sept fois, Lémec le sera soixante-dix-sept fois. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Et Adam connut encore sa femme; et elle enfanta un fils et l'appela Seth (remplaçant); car Dieu, dit-elle, m'a donné un autre fils au lieu d'Abel, que Caïn a tué. ");
INSERT INTO fra_fob_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Et un fils naquit aussi à Seth, et il l'appela Énosh. Alors on commença à invoquer le nom de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Voici le livre de la postérité d'Adam. Au jour où Dieu créa l'homme, il le fit à la ressemblance de Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Il les créa mâle et femelle, et il les bénit, et leur donna le nom d'Homme, au jour qu'ils furent créés. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Or, Adam vécut cent trente ans, et engendra un fils à sa ressemblance, selon son image, et il lui donna le nom de Seth. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Et les jours d'Adam, après qu'il eut engendré Seth, furent de huit cents ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tout le temps qu'Adam vécut, fut donc de neuf cent trente ans; puis il mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth vécut cent cinq ans, et engendra Énosh. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Et Seth vécut, après qu'il eut engendré Énosh, huit cent sept ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tout le temps que Seth vécut, fut donc de neuf cent douze ans; puis il mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Et Énosh vécut quatre-vingt-dix ans, et engendra Kénan. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Et Énosh, après qu'il eut engendré Kénan, vécut huit cent quinze ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tout le temps qu'Énosh vécut, fut donc de neuf cent cinq ans; puis il mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Et Kénan vécut soixante et dix ans, et engendra Mahalaleel. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Et Kénan, après qu'il eut engendré Mahalaleel, vécut huit cent quarante ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tout le temps que Kénan vécut, fut donc de neuf cent dix ans; puis il mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Et Mahalaleel vécut soixante-cinq ans, et engendra Jéred. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Et Mahalaleel, après qu'il eut engendré Jéred, vécut huit cent trente ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tout le temps que Mahalaleel vécut, fut donc de huit cent quatre-vingt-quinze ans; puis il mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Et Jéred vécut cent soixante-deux ans, et engendra Hénoc. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Et Jéred, après qu'il eut engendré Hénoc, vécut huit cent ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tout le temps que Jéred vécut, fut donc de neuf cent soixante-deux ans; puis il mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hénoc vécut soixante-cinq ans, et engendra Méthushélah. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Et Hénoc marcha avec Dieu, après qu'il eut engendré Méthushélah, trois cents ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Tout le temps qu'Hénoc vécut, fut donc de trois cent soixante-cinq ans. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hénoc marcha donc avec Dieu, puis il disparut, car Dieu le prit. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Et Méthushélah vécut cent quatre-vingt-sept ans, et engendra Lémec. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Et Méthushélah, après qu'il eut engendré Lémec, vécut sept cent quatre-vingt-deux ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tout le temps que Méthushélah vécut, fut donc de neuf cent soixante-neuf ans; puis il mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Et Lémec vécut cent quatre-vingt-deux ans, et engendra un fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Et il l'appela Noé (repos), en disant: Celui-ci nous consolera de notre œuvre, et de la peine qu'impose à nos mains la terre que l'Éternel a maudite. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Et Lémec, après qu'il eut engendré Noé, vécut cinq cent quatre-vingt-quinze ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tout le temps que Lémec vécut, fut donc de sept cent soixante-dix-sept ans; puis il mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Et Noé, âgé de cinq cents ans, engendra Sem, Cham et Japhet. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Or, quand les hommes eurent commencé à se multiplier sur la face de la terre et que des filles leur furent nées, ");
INSERT INTO fra_fob_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Les fils de Dieu virent que les filles des hommes étaient belles, et ils prirent des femmes d'entre toutes celles qui leur plurent. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Et l'Éternel dit: Mon esprit ne contestera point dans l'homme à toujours; dans son égarement il n'est que chair; ses jours seront de cent vingt ans. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Les géants étaient sur la terre, en ce temps-là, et aussi dans la suite, parce que les fils de Dieu venaient vers les filles des hommes, et elles leur donnaient des enfants: ce sont ces hommes puissants qui, dès les temps anciens, furent des gens de renom. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Et l'Éternel vit que la malice de l'homme était grande sur la terre, et que toute l'imagination des pensées de son cœur n'était que mauvaise en tout temps. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Et l'Éternel se repentit d'avoir fait l'homme sur la terre, et il en fut affligé dans son cœur. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Et l'Éternel dit: J'exterminerai de dessus la terre l'homme que j'ai créé; depuis l'homme jusqu'au bétail, jusqu'au reptile, et jusqu'à l'oiseau des cieux; car je me repens de les avoir faits. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mais Noé trouva grâce aux yeux de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Voici les descendants de Noé. Noé fut un homme juste, intègre, dans son temps; Noé marcha avec Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Et Noé engendra trois fils, Sem, Cham et Japhet. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Et la terre était corrompue devant Dieu, et la terre était remplie de violence. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Et Dieu regarda la terre, et, voici, elle était corrompue; car toute chair avait corrompu sa voie sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Et Dieu dit à Noé: La fin de toute chair est venue devant moi; car la terre a été remplie de violence par eux; et voici, je vais les détruire avec la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fais-toi une arche de bois de gopher; tu feras l'arche par loges, et tu l'enduiras de bitume par dedans et par dehors. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Et voici comment tu la feras: La longueur de l'arche sera de trois cents coudées, sa largeur de cinquante coudées, et sa hauteur de trente coudées. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tu feras une fenêtre à l'arche, et tu l'achèveras à une coudée par en haut; et tu mettras la porte de l'arche sur son côté; tu la feras avec un étage inférieur, un second, et un troisième. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Et moi, voici, je vais amener le déluge d'eaux sur la terre, pour détruire toute chair qui a souffle de vie, de dessous les cieux; tout ce qui est sur la terre, expirera. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mais j'établirai mon alliance avec toi; et tu entreras dans l'arche, toi, tes fils, ta femme, et les femmes de tes fils avec toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Et de tout ce qui vit d'entre toute chair, tu en feras entrer deux de chaque espèce dans l'arche pour les conserver en vie avec toi; ils seront mâle et femelle; ");
INSERT INTO fra_fob_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Des oiseaux, selon leur espèce, et des bêtes selon leur espèce, de tout reptile du sol selon son espèce, deux de chaque espèce viendront vers toi pour que tu les conserves en vie. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Et toi, prends de tout aliment qui se mange, et fais-en provision par-devers toi, afin que cela te serve de nourriture ainsi qu'à eux. ");
INSERT INTO fra_fob_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Et Noé le fit; il fit tout ce que Dieu lui avait commandé. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Et l'Éternel dit à Noé: Entre, toi et toute ta maison, dans l'arche; car je t'ai vu juste devant moi dans cette génération. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tu prendras avec toi de tous les animaux purs, sept paires de chaque espèce, le mâle et sa femelle; mais des bêtes qui ne sont pas pures, deux, le mâle et sa femelle. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Tu prendras aussi des oiseaux des cieux, sept paires, mâle et femelle, pour en conserver la race sur la face de toute la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Car dans sept jours je ferai pleuvoir sur la terre, pendant quarante jours et quarante nuits; et j'exterminerai de dessus la terre tous les êtres que j'ai faits. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Et Noé fit tout ce que l'Éternel lui avait commandé. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Or, Noé était âgé de six cents ans, quand le déluge eut lieu, et que les eaux vinrent sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noé entra donc dans l'arche, et ses fils, sa femme, et les femmes de ses fils avec lui, à cause des eaux du déluge. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Des animaux purs et des animaux qui ne sont pas purs, et des oiseaux, et de tout ce qui rampe sur la terre, ");
INSERT INTO fra_fob_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Deux par deux, mâle et femelle, entrèrent vers Noé dans l'arche, comme Dieu l'avait commandé à Noé. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Et il arriva, au bout des sept jours, que les eaux du déluge furent sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","En l'an six cent de la vie de Noé, au second mois, au dix-septième jour du mois, en ce jour-là, toutes les sources du grand abîme éclatèrent, et les bondes des cieux s'ouvrirent. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Et la pluie tomba sur la terre quarante jours et quarante nuits. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","En ce même jour-là, Noé, Sem, Cham et Japhet, fils de Noé, et la femme de Noé, et les trois femmes de ses fils avec eux, entrèrent dans l'arche, ");
INSERT INTO fra_fob_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Eux, et tous les animaux selon leur espèce, et tout le bétail selon son espèce, et tous les reptiles qui rampent sur la terre selon leur espèce, et tous les oiseaux selon leur espèce, tout petit oiseau, tout ce qui a des ailes; ");
INSERT INTO fra_fob_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ils entrèrent donc vers Noé dans l'arche; deux par deux, de toute chair qui a souffle de vie. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Et ceux qui vinrent, vinrent mâle et femelle de toute chair, comme Dieu le lui avait commandé; et l'Éternel ferma l'arche sur lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Et le déluge fut quarante jours sur la terre; et les eaux crûrent, et soulevèrent l'arche, et elle s'éleva de dessus la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Et les eaux grossirent et crûrent fort sur la terre; et l'arche flottait à la surface des eaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Et les eaux grossirent prodigieusement sur la terre; et toutes les hautes montagnes qui sont sous tous les cieux, furent couvertes. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Les eaux s'élevèrent de quinze coudées au-dessus; et les montagnes furent couvertes. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Et toute chair qui se mouvait sur la terre, expira, tant des oiseaux que du bétail, des animaux et de tous les reptiles qui se traînent sur la terre, et tous les hommes. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tout ce qui avait souffle de vie dans ses narines, et tout ce qui était sur la terre ferme, mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tous les êtres qui étaient sur la face de la terre furent exterminés, depuis les hommes jusqu'aux bêtes, jusqu'aux reptiles, et jusqu'aux oiseaux des cieux, et ils furent exterminés de dessus la terre. Il ne resta que Noé, et ce qui était avec lui dans l'arche. ");
INSERT INTO fra_fob_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Et les eaux furent grosses sur la terre pendant cent cinquante jours. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Or, Dieu se souvint de Noé, et de tous les animaux et de tout le bétail qui étaient avec lui dans l'arche. Et Dieu fit passer un vent sur la terre, et les eaux s'arrêtèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Et les sources de l'abîme et les bondes des cieux se fermèrent; et la pluie fut retenue des cieux. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Et les eaux se retirèrent de dessus la terre; elles allèrent se retirant; et les eaux diminuèrent au bout de cent cinquante jours. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Et au septième mois, au dix-septième jour du mois, l'arche s'arrêta sur les montagnes d'Ararat. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Et les eaux allèrent diminuant, jusqu'au dixième mois. Au dixième mois, au premier jour du mois, ap-parurent les sommets des montagnes. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Et il arriva qu'au bout de quarante jours Noé ouvrit la fenêtre qu'il avait faite à l'arche. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Et il lâcha le corbeau, qui sortit, allant et revenant, jusqu'à ce que les eaux eussent séché de dessus la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Puis il lâcha la colombe d'avec lui, pour voir si les eaux avaient fort diminué à la surface de la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mais la colombe ne trouva pas où poser la plante de son pied, et elle retourna vers lui dans l'arche; car il y avait de l'eau à la surface de toute la terre. Et Noé avança sa main, la prit, et la ramena vers lui dans l'arche. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Et il attendit encore sept autres jours, puis il lâcha de nouveau la colombe hors de l'arche. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Et la colombe revint à lui vers le soir; et voici, une feuille d'olivier fraîche était à son bec; et Noé comprit que les eaux avaient fort diminué sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Et il attendit encore sept autres jours; puis il lâcha la colombe; mais elle ne retourna plus à lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Et il arriva en l'an six cent un de la vie de Noé, au premier mois, au premier jour du mois, que les eaux avaient séché sur la terre; et Noé ôta la couverture de l'arche, et regarda; et voici, la surface du sol avait séché. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Au second mois, au vingt-septième jour du mois, la terre fut sèche. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Alors Dieu parla à Noé, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Sors de l'arche, toi, ta femme, tes fils, et les femmes de tes fils avec toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fais sortir avec toi tous les animaux qui sont avec toi, de toute chair, tant des oiseaux que des bêtes, et de tous les reptiles qui rampent sur la terre; et qu'ils peuplent en abondance la terre, et qu'ils croissent et multiplient sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Et Noé sortit, et ses fils, sa femme, et les femmes de ses fils avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tous les animaux, tous les reptiles et tous les oiseaux, tout ce qui rampe sur la terre, selon leurs familles, sortirent de l'arche. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Et Noé bâtit un autel à l'Éternel; et il prit de toute bête pure, et de tout oiseau pur, et il offrit des holocaustes sur l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Et l'Éternel respira l'agréable odeur, et l'Éternel dit en son cœur: Je ne maudirai plus la terre, à cause de l'homme; car la nature du cœur de l'homme est mauvaise dès sa jeunesse; et je ne frapperai plus tout ce qui vit, comme je l'ai fait. ");
INSERT INTO fra_fob_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tant que la terre durera, les semailles et la moisson, le froid et le chaud, l'été et l'hiver, et le jour et la nuit, ne cesseront point. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Et Dieu bénit Noé, et ses fils, et leur dit: Croissez et multipliez, et remplissez la terre; ");
INSERT INTO fra_fob_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Et vous serez craints et redoutés de tous les animaux de la terre, et de tous les oiseaux des cieux; avec tout ce qui se meut sur le sol et tous les poissons de la mer, ils sont remis entre vos mains. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tout ce qui se meut et qui a vie, vous servira de nourriture; je vous donne tout cela comme l'herbe verte. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Seulement, vous ne mangerez point de chair avec son âme, c'est à dire son sang. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Et certainement je redemanderai votre sang, le sang de vos âmes; je le redemanderai de tout animal. Et je redemanderai l'âme de l'homme, de la main de l'homme, de la main de son frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Celui qui répandra le sang de l'homme, par l'homme son sang sera répandu; car Dieu a fait l'homme à son image. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Vous donc, croissez et multipliez; peuplez en abondance la terre, et multipliez sur elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Dieu parla aussi à Noé, et à ses fils avec lui, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Quant à moi, voici, j'établis mon alliance avec vous, et avec votre postérité après vous; ");
INSERT INTO fra_fob_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Et avec tous les êtres vivants qui sont avec vous, tant les oiseaux que le bétail, et tous les animaux de la terre avec vous, tous ceux qui sont sortis de l'arche jusqu'à tous les animaux de la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","J'établis donc mon alliance avec vous, et nulle chair ne sera plus exterminée par les eaux du déluge, et il n'y aura plus de déluge pour détruire la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Et Dieu dit: Voici le signe de l'alliance que je mets entre moi et vous, et tous les êtres vivants qui sont avec vous, pour les générations à toujours: ");
INSERT INTO fra_fob_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Je mets mon arc dans les nuées, et il servira de signe d'alliance entre moi et la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Et il arrivera que, lorsque j'amasserai des nuées sur la terre, et que l'arc paraîtra dans les nuées, ");
INSERT INTO fra_fob_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Je me souviendrai de mon alliance, qui existe entre moi et vous et tout être vivant, de toute chair; et les eaux ne deviendront plus un déluge pour détruire toute chair. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","L'arc sera donc dans les nuées, et je le regarderai, pour me souvenir de l'alliance éternelle entre Dieu et tout être vivant, de toute chair qui est sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Et Dieu dit à Noé: C'est là le signe de l'alliance que j'ai établie entre moi et toute chair qui est sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Et les fils de Noé, qui sortirent de l'arche, furent Sem, Cham et Japhet. Or, Cham est le père de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ce sont là les trois fils de Noé, et c'est par eux que fut peuplée toute la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Or, Noé commença à cultiver la terre et planta de la vigne. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Et il but du vin, et s'enivra, et se découvrit au milieu de sa tente. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Et Cham, père de Canaan, ayant vu la nudité de son père, le rapporta dehors à ses deux frères. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Mais Sem et Japhet prirent le manteau, le mirent tous deux sur leurs épaules, et marchant en arrière, ils couvrirent la nudité de leur père; et comme leurs visages étaient tournés, ils ne virent point la nudité de leur père. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Et Noé, réveillé de son vin, apprit ce que son fils cadet lui avait fait. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Et il dit: Maudit soit Canaan! il sera serviteur des serviteurs de ses frères. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Puis il dit: Béni soit l'Éternel, Dieu de Sem, et que Canaan soit leur serviteur! ");
INSERT INTO fra_fob_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Que Dieu étende Japhet et qu'il habite dans les tentes de Sem; et que Canaan soit leur serviteur! ");
INSERT INTO fra_fob_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Et Noé vécut, après le déluge, trois cent cinquante ans. ");
INSERT INTO fra_fob_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Tout le temps que Noé vécut fut donc de neuf cent cinquante ans; puis il mourut. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Voici les descendants des fils de Noé: Sem, Cham et Japhet, auxquels naquirent des enfants après le déluge. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Les fils de Japhet sont Gomer, Magog, Madaï, Javan, Tubal, Méshec, et Tiras. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Et les fils de Gomer, Ashkénas, Riphath, et Togarma. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Et les fils de Javan, Elisha et Tarsis, Kittim et Dodanim. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Par eux furent peuplées les îles des nations, dans leurs terres, chacun selon sa langue, selon leurs familles, selon leurs nations. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Et les fils de Cham, sont Cush, Mitsraïm, Put et Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Et les fils de Cush, Seba, Havila, Sabta, Raema et Sabteca. Et les fils de Raema, Sheba et Dedan. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Et Cush engendra Nimrod, qui commença à être puissant sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Il fut un puissant chasseur devant l'Éternel. C'est pour cela qu'on dit: Comme Nimrod, puissant chasseur devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Et le commencement de son royaume fut Babel, Érec, Accad et Calné, dans le pays de Shinear. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","De ce pays-là il sortit en Assyrie, et il bâtit Ninive, Rehoboth-Ir, Calach, ");
INSERT INTO fra_fob_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Et Résen, entre Ninive et Calach; c'est la grande ville. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Et Mitsraïm engendra les Ludim, les Anamim, les Lehabim, les Naphtuhim, ");
INSERT INTO fra_fob_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Les Pathrusim, les Casluhim (d'où sont sortis les Philistins) et les Caphtorim. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Et Canaan engendra Sidon, son premier-né, et Heth; ");
INSERT INTO fra_fob_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Les Jébusiens, les Amoréens, les Guirgasiens; ");
INSERT INTO fra_fob_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Les Héviens, les Arkiens, les Siniens; ");
INSERT INTO fra_fob_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Les Arvadiens, les Tsemariens, les Hamathiens. Ensuite les familles des Cananéens se dispersèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Et la limite des Cananéens fut depuis Sidon, en venant vers Guérar, jusqu'à Gaza, en venant vers Sodome, Gomorrhe, Adma, et Tseboïm, jusqu'à Lésha. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ce sont là les fils de Cham, selon leurs familles, selon leurs langues, dans leurs terres, dans leurs nations. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Il naquit aussi des fils à Sem, père de tous les fils d'Héber, et frère aîné de Japhet. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Les fils de Sem sont Élam, Assur, Arpacshad, Lud et Aram. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Et les fils d'Aram, Uts, Hul, Guéther et Mash. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Et Arpacshad engendra Shélach, et Shélach engendra Héber. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Et à Héber il naquit deux fils: le nom de l'un est Péleg (partage), car en son temps la terre fut partagée; et le nom de son frère, Jockthan. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Et Jockthan engendra Almodad, Sheleph, Hatsarmaveth, et Jérach; ");
INSERT INTO fra_fob_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO fra_fob_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimaël, Sheba, ");
INSERT INTO fra_fob_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havila, et Jobab. Tous ceux-là sont fils de Jockthan. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Et leur demeure était depuis Mésha, en venant vers Sephar, vers la montagne d'Orient. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ce sont là les fils de Sem, selon leurs familles, selon leurs langues, selon leurs terres, selon leurs nations. ");
INSERT INTO fra_fob_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Telles sont les familles des fils de Noé, selon leurs générations, dans leurs nations; et c'est d'eux que sont sorties les nations de la terre après le déluge. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Or toute la terre avait le même langage et les mêmes mots. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mais il arriva qu'étant partis du côté de l'Orient, ils trouvèrent une plaine dans le pays de Shinear, et ils y demeurèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Et ils se dirent l'un à l'autre: Allons, faisons des briques, et cuisons-les au feu. Et la brique leur tint lieu de pierre, et le bitume leur tint lieu de mortier. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Et ils dirent: Allons, bâtissons-nous une ville et une tour, dont le sommet soit dans les cieux, et faisons-nous un nom, de peur que nous ne soyons dispersés sur la face de toute la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Et l'Éternel descendit pour voir la ville et la tour qu'avaient bâties les fils des hommes. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Et l'Éternel dit: Voici, c'est un seul peuple, et ils ont tous le même langage, et voilà ce qu'ils commencent à faire; et maintenant rien ne les empêchera d'exécuter tout ce qu'ils ont projeté. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Allons, descendons, et confondons là leur langage, en sorte qu'ils n'entendent point le langage l'un de l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Et l'Éternel les dispersa de là sur la face de toute la terre, et ils cessèrent de bâtir la ville. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","C'est pourquoi son nom fut appelé Babel (confusion); car l'Éternel y confondit le langage de toute la terre, et de là l'Éternel les dispersa sur toute la face de la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Voici les descendants de Sem: Sem, âgé de cent ans, engendra Arpacshad, deux ans après le déluge. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Et Sem, après qu'il eut engendré Arpacshad, vécut cinq cents ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Et Arpacshad vécut trente-cinq ans, et engendra Shélach. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Et Arpacshad, après qu'il eut engendré Shélach, vécut quatre cent trois ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Et Shélach vécut trente ans, et engendra Héber. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Et Shélach, après qu'il eut engendré Héber, vécut quatre cent trois ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Et Héber vécut trente-quatre ans, et engendra Péleg. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Et Héber, après qu'il eut engendré Péleg, vécut quatre cent trente ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Et Péleg vécut trente ans, et engendra Rehu. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Et Péleg, après qu'il eut engendré Rehu, vécut deux cent neuf ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Et Rehu vécut trente-deux ans, et engendra Serug. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Et Rehu, après qu'il eut engendré Serug, vécut deux cent sept ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Et Serug vécut trente ans, et engendra Nachor. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Et Serug, après qu'il eut engendré Nachor, vécut deux cents ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Et Nachor vécut vingt-neuf ans, et engendra Tharé. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Et Nachor, après qu'il eut engendré Tharé, vécut cent dix-neuf ans; et il engendra des fils et des filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Et Tharé vécut soixante et dix ans, et engendra Abram, Nachor et Haran. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Voici les descendants de Tharé: Tharé engendra Abram, Nachor et Haran; et Haran engendra Lot. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Et Haran mourut en présence de Tharé son père, au pays de sa naissance, à Ur des Caldéens. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Et Abram et Nachor prirent des femmes. Le nom de la femme d'Abram était Saraï, et le nom de la femme de Nachor, Milca, fille de Haran, père de Milca et père de Jisca. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Mais Saraï était stérile; elle n'avait point d'enfant. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Et Tharé prit Abram son fils, et Lot fils de Haran, son petit-fils, et Saraï sa belle-fille, femme d'Abram son fils, et ils sortirent ensemble d'Ur des Caldéens, pour aller au pays de Canaan. Et ils vinrent jusqu'à Charan, et ils y demeurèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Et les jours de Tharé furent de deux cent cinq ans; puis Tharé mourut à Charan. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Et l'Éternel avait dit à Abram: Va-t'en hors de ton pays, et de ta parenté, et de la maison de ton père, vers le pays que je te montrerai. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Et je te ferai devenir une grande nation, et je te bénirai, et je rendrai ton nom grand, et tu seras une bénédiction. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Et je bénirai ceux qui te béniront, et je maudirai ceux qui te maudiront; et toutes les familles de la terre seront bénies en toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Et Abram s'en alla, comme l'Éternel le lui avait dit, et Lot alla avec lui. Et Abram était âgé de soixante et quinze ans quand il sortit de Charan. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Et Abram prit Saraï sa femme, et Lot, fils de son frère, et tout le bien qu'ils avaient gagné, et les personnes qu'ils avaient acquises à Charan; et ils sortirent pour aller au pays de Canaan; et ils arrivèrent au pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Et Abram traversa le pays jusqu'au lieu de Sichem, jusqu'au chêne de Moré. Or, les Cananéens étaient alors dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Et l'Éternel apparut à Abram, et lui dit: Je donnerai ce pays à ta postérité! Et il bâtit là un autel à l'Éternel, qui lui était apparu. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Et il passa de là vers la montagne, à l'orient de Béthel, et il tendit ses tentes, ayant Béthel à l'Occident, et Aï à l'Orient. Et il bâtit là un autel à l'Éternel, et invoqua le nom de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Puis Abram partit, marchant de campement en campement, vers le Midi. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Or il y eut une famine dans le pays, et Abram descendit en Égypte pour y séjourner; car la famine était grande dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Et comme il était près d'entrer en Égypte, il dit à Saraï sa femme: Voici, je sais que tu es une belle femme; ");
INSERT INTO fra_fob_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Et il arrivera que lorsque les Égyptiens t'auront vue, ils diront: C'est sa femme; et ils me tueront; mais ils te laisseront vivre. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Dis, je te prie, que tu es ma sœur, afin que je sois bien traité à cause de toi, et que j'aie la vie sauve grâce à toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Et dès qu'Abram fut arrivé en Égypte, les Égyptiens virent que cette femme était fort belle. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Et les princes de la cour de Pharaon la virent, et la louèrent devant Pharaon, et la femme fut emmenée dans la maison de Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Et il fit du bien à Abram, à cause d'elle; et il eut des brebis et des bœufs et des ânes, des serviteurs et des servantes, des ânesses et des chameaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mais l'Éternel frappa de grandes plaies Pharaon et sa maison, à cause de Saraï, femme d'Abram. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Alors Pharaon appela Abram, et lui dit: Qu'est-ce que tu m'as fait? Pourquoi ne m'as-tu pas déclaré que c'était ta femme? ");
INSERT INTO fra_fob_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Pourquoi as-tu dit: C'est ma sœur; en sorte que je l'ai prise pour femme? Maintenant, voici ta femme, prends-la et va-t'en. ");
INSERT INTO fra_fob_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Et Pharaon donna ordre pour lui à des gens qui le reconduisirent, lui et sa femme, et tout ce qui lui appartenait. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Et Abram monta d'Égypte vers le Midi, lui et sa femme, et tout ce qui lui appartenait, et Lot avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Or Abram était très riche en bétail, en argent et en or. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Puis il s'en retourna, par ses campements, du Midi jusqu'à Béthel, jusqu'au lieu où avait été sa tente au commencement, entre Béthel et Aï; ");
INSERT INTO fra_fob_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Au lieu où était l'autel qu'il y avait fait auparavant, et Abram y invoqua le nom de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Or Lot, qui marchait avec Abram, avait aussi des brebis, des bœufs et des tentes. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Et le pays ne leur suffit pas pour demeurer ensemble; car leur bien était si grand, qu'ils ne purent demeurer ensemble. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Et il y eut une querelle entre les bergers du bétail d'Abram, et les bergers du bétail de Lot. Or les Cananéens et les Phéréziens demeuraient alors dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Et Abram dit à Lot: Qu'il n'y ait point, je te prie, de dispute entre moi et toi, ni entre mes bergers et tes bergers; car nous sommes frères. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tout le pays n'est-il pas devant toi? Sépare-toi donc de moi; si tu prends la gauche, j'irai à droite; et si tu prends la droite, j'irai à gauche. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Alors Lot, levant les yeux, vit toute la plaine du Jourdain, qui (avant que l'Éternel eût détruit Sodome et Gomorrhe) était arrosée partout, en allant vers Tsoar, comme le jardin de l'Éternel, comme le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Et Lot choisit pour lui toute la plaine du Jourdain, et il partit du côté de l'Orient; et ils se séparèrent l'un de l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram habita dans le pays de Canaan, et Lot habita dans les villes de la plaine, et dressa ses tentes jusqu'à Sodome. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Or les gens de Sodome étaient méchants, et de grands pécheurs contre l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Et l'Éternel dit à Abram, après que Lot se fut séparé de lui: Lève donc les yeux, et regarde du lieu où tu es, vers le Nord, vers le Midi, vers l'Orient et vers l'Occident. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Car, tout le pays que tu vois, je te le donnerai, à toi et à ta postérité pour toujours. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Et je ferai que ta postérité sera comme la poussière de la terre; que si quelqu'un peut compter la poussière de la terre, ta postérité aussi sera comptée. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lève-toi, parcours le pays dans sa longueur et dans sa largeur; car je te le donnerai. ");
INSERT INTO fra_fob_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Alors Abram transporta ses tentes, et vint demeurer aux chênes de Mamré, qui sont à Hébron, et il bâtit là un autel à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Or, il arriva, au temps d'Amraphel, roi de Shinear, d'Arjoc, roi d'Ellasar, de Kedor-Loamer, roi d'Élam, et de Tideal, roi des nations, ");
INSERT INTO fra_fob_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Qu'ils firent la guerre à Béra, roi de Sodome, à Birsha, roi de Gomorrhe, à Shineab, roi d'Adma, à Shéméber, roi de Tseboïm, et au roi de Béla, qui est Tsoar. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Tous ceux-ci se rassemblèrent dans la vallée de Siddim, qui est la mer salée. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Douze ans ils avaient été assujettis à Kedor-Laomer; mais la treizième année, ils se révoltèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Et la quatorzième année, Kedor-Laomer et les rois qui étaient avec lui, vinrent et battirent les Rephaïm à Ashteroth-Karnaïm, les Zuzim à Ham, les Emim dans la plaine de Kirjathaïm, ");
INSERT INTO fra_fob_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Et les Horiens dans leur montagne de Séir, jusqu'à El-Paran, qui est près du désert. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Puis ils retournèrent et vinrent à la Fontaine du Jugement, qui est Kadès, et battirent tout le pays des Amalécites, et aussi les Amoréens, qui habitaient à Hatsatson-Thamar. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Alors le roi de Sodome, le roi de Gomorrhe, le roi d'Adma, le roi de Tseboïm, et le roi de Béla, qui est Tsoar, sortirent, et rangèrent leurs troupes en bataille contre eux dans la vallée de Siddim, ");
INSERT INTO fra_fob_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Contre Kedor-Laomer, roi d'Élam, Tideal, roi des nations, Amraphel, roi de Shinear, et Arjoc, roi d'Ellasar; quatre rois contre cinq. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Or, il y avait dans la vallée de Siddim beaucoup de puits de bitume. Et le roi de Sodome et celui de Gomorrhe s'enfuirent, et y tombèrent; et ceux qui échappèrent, s'enfuirent vers la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Alors ils prirent toutes les richesses de Sodome et de Gomorrhe et tous leurs vivres, et s'en allèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ils prirent aussi Lot, fils du frère d'Abram, qui demeurait dans Sodome, et tout son bien, et ils s'en allèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Et un fugitif vint l'annoncer à Abram, l'Hébreu. Or il demeurait aux chênes de Mamré l'Amoréen, frère d'Eshcol, et frère d'Aner, qui avaient fait alliance avec Abram. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Et quand Abram eut appris que son frère avait été fait prisonnier, il arma trois cent dix-huit de ses fidèles, nés dans sa maison, et poursuivit ces rois jusqu'à Dan. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Puis, ayant partagé ses troupes, il se jeta sur eux de nuit, lui et ses serviteurs; et il les battit, et les poursuivit jusqu'à Hoba, qui est à gauche de Damas. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Et il ramena toutes les richesses qu'on avait prises; il ramena aussi Lot son frère, ses biens et les femmes aussi, et le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Et le roi de Sodome sortit au-devant de lui, après qu'il fut revenu de battre Kedor-Laomer et les rois qui étaient avec lui, dans la vallée de la Plaine, qui est la vallée du Roi. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Et Melchisédec, roi de Salem, fit apporter du pain et du vin. Or, il était sacrificateur du Dieu Très-Haut. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Et il bénit Abram, et dit: Béni soit Abram par le Dieu Très-Haut, fondateur des cieux et de la terre! ");
INSERT INTO fra_fob_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Et béni soit le Dieu Très-Haut, qui a livré tes ennemis entre tes mains! Et Abram lui donna la dîme de tout. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Et le roi de Sodome dit à Abram: Donne-moi les personnes, et prends les richesses pour toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Et Abram dit au roi de Sodome: Je lève ma main vers l'Éternel, le Dieu Très-Haut, fondateur des cieux et de la terre, ");
INSERT INTO fra_fob_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Que je ne prendrai pas même un fil ou une courroie de soulier, rien qui t'appartienne, en sorte que tu ne dises pas: C'est moi qui ai enrichi Abram. ");
INSERT INTO fra_fob_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Rien pour moi! Seulement ce que les jeunes gens ont mangé, et la part des hommes qui sont venus avec moi, Aner, Eshcol et Mamré: pour eux, qu'ils prennent leur part. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Après ces choses, la parole de l'Éternel fut adressée à Abram dans une vision, en disant: Ne crains point, Abram, je suis ton bouclier, et ta très grande récompense. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Et Abram répondit: Seigneur Éternel, que me donneras-tu? Je m'en vais sans enfants, et celui qui possédera ma maison est Eliézer de Damas. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Et Abram dit: Voici, tu ne m'as pas donné de postérité, et voilà qu'un serviteur né dans ma maison sera mon héritier. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Et voici, la parole de l'Éternel lui fut adressée, en disant: Celui-ci ne sera point ton héritier; mais celui qui sortira de tes entrailles, sera ton héritier. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Puis il le mena dehors et lui dit: Regarde vers le ciel, et compte les étoiles, si tu peux les compter. Et il lui dit: Ainsi sera ta postérité. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Et Abram crut à l'Éternel, qui lui imputa cela à justice. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Et il lui dit: Je suis l'Éternel, qui t'a fait sortir d'Ur des Caldéens, afin de te donner ce pays pour le posséder. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Et il dit: Seigneur Éternel, à quoi connaîtrai-je que je le posséderai? ");
INSERT INTO fra_fob_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Et il lui répondit: Prends pour moi une génisse de trois ans, une chèvre de trois ans, un bélier de trois ans, une tourterelle et un pigeonneau. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Et il prit toutes ces choses, et les partagea par le milieu, et il mit chaque moitié vis-à-vis de l'autre; mais il ne partagea point les oiseaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Et les oiseaux de proie fondirent sur ces bêtes mortes; mais Abram les chassa. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Et comme le soleil allait se coucher, un profond sommeil tomba sur Abram; et voici, une terreur, une obscurité profonde tomba sur lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Et l'Éternel dit à Abram: Sache que ta postérité sera étrangère dans un pays qui ne lui appartiendra point, et qu'elle en servira les habitants, et qu'ils l'opprimeront pendant quatre cents ans. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mais je jugerai aussi la nation à laquelle tes descendants seront asservis; et ensuite ils sortiront avec de grandes richesses. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Et toi, tu t'en iras en paix vers tes pères, tu seras enseveli dans une heureuse vieillesse. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Et à la quatrième génération ils reviendront ici; car l'iniquité de l'Amoréen n'est pas encore à son comble. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Et lorsque le soleil fut couché, il y eut une obscurité épaisse; et voici, il y eut une fournaise fumante, et une flamme de feu qui passa entre les chairs partagées. ");
INSERT INTO fra_fob_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","En ce jour-là, l'Éternel traita alliance avec Abram, en disant: Je donne ce pays à ta postérité, depuis le fleuve d'Égypte jusqu'au grand fleuve, au fleuve d'Euphrate; ");
INSERT INTO fra_fob_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Les Kéniens, les Kéniziens, les Kadmoniens, ");
INSERT INTO fra_fob_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Les Héthiens, les Phéréziens, les Rephaïms, ");
INSERT INTO fra_fob_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Les Amoréens, les Cananéens, les Guirgasiens et les Jébusiens. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Or, Saraï, femme d'Abram, ne lui avait point donné d'enfant; et elle avait une servante égyptienne, nommée Agar. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Et Saraï dit à Abram: Voici, l'Éternel m'a rendue stérile; viens, je te prie, vers ma servante; peut-être aurai-je des enfants par elle. Et Abram obéit à la voix de Saraï. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Et Saraï, femme d'Abram, prit Agar, l'Égyptienne, sa servante, et la donna pour femme à Abram son mari, après qu'il eut demeuré dix ans au pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Il vint donc vers Agar, et elle conçut. Et quand elle vit qu'elle avait conçu, elle méprisa sa maîtresse. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Alors Saraï dit à Abram: L'outrage qui m'est fait retombe sur toi. J'ai mis ma servante dans ton sein; et depuis qu'elle a vu qu'elle est enceinte, elle me méprise. Que l'Éternel juge entre moi et toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Et Abram répondit à Saraï: Voici, ta servante est entre tes mains, traite-la comme il te plaira. Et Saraï la maltraita, et elle s'enfuit de devant elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Mais l'ange de l'Éternel la trouva près d'une source d'eau dans le désert, près de la source qui est sur le chemin de Shur. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Et il lui dit: Agar, servante de Saraï, d'où viens-tu? et où vas-tu? Et elle répondit: Je fuis de devant Saraï ma maîtresse. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Et l'ange de l'Éternel lui dit: Retourne vers ta maîtresse et humilie-toi sous sa main. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Et l'ange de l'Éternel lui dit: Je multiplierai tellement ta postérité qu'on ne pourra la compter, tant elle sera nombreuse. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Et l'ange de l'Éternel lui dit: Voici, tu es enceinte; et tu enfanteras un fils, et tu le nommeras Ismaël (Dieu entend); car l'Éternel t'a entendue dans ton affliction. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Il sera semblable à un âne sauvage; sa main sera contre tous, et la main de tous contre lui; et il habitera en face de tous ses frères. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Et elle appela le nom de l'Éternel qui lui avait parlé Atta-El-Roï (tu es un Dieu qui voit). Car elle dit: N'ai-je pas même, ici, vu celui qui me voyait? ");
INSERT INTO fra_fob_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","C'est pourquoi on appela ce puits, le puits de Lachaï-Roï (du Vivant qui me voit). Voici, il est entre Kadès et Béred. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Et Agar enfanta un fils à Abram. Et Abram appela son fils, qu'Agar lui avait enfanté, Ismaël. ");
INSERT INTO fra_fob_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Or, Abram était âgé de quatre-vingt-six ans, quand Agar enfanta Ismaël à Abram. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Puis, Abram étant parvenu à l'âge de quatre-vingt-dix-neuf ans, l'Éternel apparut à Abram, et lui dit: Je suis le Dieu Tout-Puissant; marche devant ma face, et sois intègre. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Et j'établirai mon alliance entre moi et toi, et je te multiplierai très abondamment. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Alors Abram tomba sur sa face; et Dieu lui parla, et lui dit: ");
INSERT INTO fra_fob_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Pour moi, voici, mon alliance est avec toi et tu deviendras père d'une multitude de nations. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Et l'on ne t'appellera plus Abram (père élevé), mais ton nom sera Abraham (père d'une multitude); car je t'établis père d'une multitude de nations. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Et je te ferai croître très abondamment, et je ferai de toi des nations; et des rois sortiront de toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Et j'établirai mon alliance entre moi et toi, et ta postérité après toi, d'âge en âge, pour être une alliance éternelle; afin que je sois ton Dieu, et celui de ta postérité après toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Et je donnerai, à toi et à ta postérité après toi, le pays où tu séjournes, tout le pays de Canaan, en possession perpétuelle; et je serai leur Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Puis Dieu dit à Abraham: Mais toi, tu garderas mon alliance, toi et ta postérité après toi, d'âge en âge. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Voici mon alliance que vous garderez, et qui sera entre moi et vous, et ta postérité après toi: c'est que tout mâle parmi vous sera circoncis. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Et vous circoncirez votre chair, et ce sera un signe d'alliance entre moi et vous. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","A l'âge de huit jours tout mâle sera circoncis parmi vous, dans vos générations, tant celui qui est né dans la maison que celui qui, acheté à prix d'argent de quelque étranger que ce soit, n'est point de ta race; ");
INSERT INTO fra_fob_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","On ne manquera pas de circoncire celui qui est né dans ta maison, et celui qui a été acheté de ton argent; et mon alliance sera dans votre chair une alliance éternelle. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","L'incirconcis, le mâle qui ne se circoncira pas dans sa chair, sera retranché d'entre ses peuples: il a violé mon alliance. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dieu dit à Abraham: Quant à Saraï ta femme, tu ne l'appelleras plus Saraï, mais Sara (princesse) est son nom. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Et je la bénirai; et même je te donnerai d'elle un fils. Je la bénirai et elle deviendra des nations; des rois de peuples sortiront d'elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Alors Abraham tomba sur sa face; et il rit, et dit en son cœur: Naîtrait-il un enfant à un homme âgé de cent ans? et Sara, âgée de quatre-vingt-dix ans, enfanterait-elle? ");
INSERT INTO fra_fob_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Et Abraham dit à Dieu: Puisse Ismaël vivre devant toi! ");
INSERT INTO fra_fob_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Et Dieu dit: Certainement, Sara ta femme va t'enfanter un fils, et tu l'appelleras Isaac (rire), et j'établirai mon alliance avec lui, en alliance éternelle pour sa postérité après lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Je t'exauce aussi touchant Ismaël: Voici, je le bénis, et je le ferai croître et multiplier très abondamment. Il sera père de douze princes; et je ferai de lui une grande nation. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Mais j'établirai mon alliance avec Isaac, que Sara t'enfantera à cette époque, l'année prochaine. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Et quand il eut achevé de parler avec lui, Dieu remonta d'auprès d'Abraham. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Et Abraham prit Ismaël son fils et tous ceux qui étaient nés dans sa maison, et tous ceux qu'il avait achetés de son argent, tous les mâles parmi les gens de la maison d'Abraham; et il circoncit leur chair en ce même jour-là, comme Dieu le lui avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Or Abraham était âgé de quatre-vingt-dix-neuf ans, quand il se circoncit. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Et Ismaël son fils avait treize ans, lorsqu'il fut circoncis. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abraham et Ismaël son fils furent circoncis en ce même jour-là. ");
INSERT INTO fra_fob_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Et toutes les personnes de sa maison, ceux qui étaient nés dans la maison, et ceux qui avaient été achetés des étrangers à prix d'argent, furent circoncis avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Puis l'Éternel apparut à Abraham aux chênes de Mamré, comme il était assis à la porte de la tente, pendant la chaleur du jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Il leva les yeux, et regarda; et voici, trois hommes étaient debout devant lui; et dès qu'il les vit, il courut au-devant d'eux, de la porte de la tente, et se prosterna en terre; ");
INSERT INTO fra_fob_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Et il dit: Mon Seigneur, je te prie, si j'ai trouvé grâce à tes yeux, ne passe point outre, je te prie, devant ton serviteur. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Qu'on prenne, je vous prie, un peu d'eau, et lavez vos pieds; et reposez-vous sous cet arbre. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Et j'apporterai un morceau de pain, et vous fortifierez votre cœur, ensuite vous passerez outre; car c'est pour cela que vous êtes passés près de votre serviteur. Et ils dirent: Fais comme tu as dit. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Alors Abraham alla en hâte dans la tente, vers Sara, et dit: Apporte vite trois mesures de fleur de farine, pétris-les et fais des gâteaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Puis Abraham courut vers le troupeau, prit un veau tendre et bon, et le donna au serviteur, qui se hâta de l'apprêter. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ensuite il prit du beurre et du lait, et le veau qu'il avait apprêté, et les mit devant eux; et lui se tenait devant eux sous l'arbre; et ils mangèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Et ils lui dirent: Où est Sara ta femme? Et il répondit: La voilà dans la tente. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Et il dit: Je ne manquerai pas de revenir vers toi dans un an; et voici, Sara ta femme aura un fils. Et Sara écoutait à la porte de la tente, qui était derrière lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Or Abraham et Sara étaient vieux, avancés en âge; Sara n'avait plus ce que les femmes ont coutume d'avoir. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Et Sara rit en elle-même, en disant: Quand je suis vieille, aurais-je ce plaisir! mon seigneur aussi est vieux. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Et l'Éternel dit à Abraham: Pour-quoi donc Sara a-t-elle ri, en disant: Est-ce que vraiment j'enfanterais, vieille comme je suis? ");
INSERT INTO fra_fob_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Est-il rien d'impossible à l'Éternel? A l'époque fixée je reviendrai vers toi, dans un an, et Sara aura un fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Et Sara nia, en disant: Je n'ai point ri; car elle eut peur. Mais il dit: Non, car tu as ri. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Et ces hommes se levèrent de là, et regardèrent vers Sodome; et Abraham allait avec eux, pour les reconduire. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Et l'Éternel dit: Cacherai-je à Abraham ce que je vais faire, ");
INSERT INTO fra_fob_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Quand Abraham doit devenir une nation grande et puissante, et que toutes les nations de la terre seront bénies en lui? ");
INSERT INTO fra_fob_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Car je l'ai connu, afin qu'il commande à ses enfants, et à sa maison après lui, de garder la voie de l'Éternel, pour faire ce qui est juste et droit; afin que l'Éternel fasse venir sur Abraham ce qu'il a dit de lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Et l'Éternel dit: Le cri contre Sodome et Gomorrhe est vraiment grand, et leur péché est vraiment très grave. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Je veux descendre et voir s'ils ont agi entièrement selon le cri qui en est venu jusqu'à moi; et si cela n'est pas, je le saurai. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Alors ces hommes, partant de là, allèrent vers Sodome; mais Abraham se tint encore devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Et Abraham s'approcha et dit: Feras-tu périr aussi le juste avec le méchant? ");
INSERT INTO fra_fob_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Peut-être y a-t-il cinquante justes dans la ville; les feras-tu périr aussi, et ne pardonneras-tu point à ce lieu, à cause des cinquante justes, s'ils y sont? ");
INSERT INTO fra_fob_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Il n'arrivera pas que tu fasses une telle chose, que tu fasses mourir le juste avec le méchant, en sorte que le juste soit traité comme le méchant. Non, tu ne le feras point. Celui qui juge toute la terre, ne fera-t-il point justice? ");
INSERT INTO fra_fob_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Et l'Éternel dit: Si je trouve à Sodome cinquante justes dans la ville, je pardonnerai à toute la ville pour l'amour d'eux. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Et Abraham reprit et dit: Voici, je m'enhardis à parler au Seigneur, bien que je ne sois que poussière et cendre. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Peut-être des cinquante justes en manquera-t-il cinq: détruiras-tu, pour cinq, toute la ville? Et il répondit: Je ne la détruirai point, si j'y trouve quarante-cinq justes. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Et Abraham continua de lui parler, et dit: Peut-être s'y en trouvera-t-il quarante? Et il dit: Je ne le ferai point, pour l'amour de ces quarante. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Et Abraham dit: Je prie le Seigneur de ne pas s'irriter, et je parlerai: Peut-être s'y en trouvera-t-il trente? Et il dit: Je ne le ferai point, si j'y en trouve trente. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Et Abraham dit: Voici, je m'enhardis à parler au Seigneur: Peut-être s'en trouvera-t-il vingt? Et il dit: Je ne la détruirai point, pour l'amour de ces vingt. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Et Abraham dit: Je prie le Seigneur de ne pas s'irriter, et je parlerai, seulement cette fois. Peut-être s'y en trouvera-t-il dix? Et il dit: Je ne la détruirai point, pour l'amour de ces dix. ");
INSERT INTO fra_fob_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Et l'Éternel s'en alla, quand il eut achevé de parler à Abraham. Et Abraham retourna en sa demeure. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Or, sur le soir les deux anges arrivèrent à Sodome; et Lot était assis à la porte de Sodome. Et Lot les vit, et il se leva pour aller au-devant d'eux, et se prosterna le visage contre terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Et il dit: Voici, je vous prie, mes seigneurs, venez loger dans la maison de votre serviteur, et passez-y la nuit et lavez vos pieds; et demain matin vous vous lèverez, et vous continuerez votre chemin. Mais ils dirent: Non, nous passerons la nuit dans la rue. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mais il les pressa tellement qu'ils allèrent loger chez lui et entrèrent dans sa maison. Et il leur fit un festin, et fit cuire des pains sans levain, et ils mangèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ils n'étaient pas encore couchés, que les hommes de la ville, les hommes de Sodome, environnèrent la maison, depuis le jeune homme jusqu'au vieillard, tout le peuple ensemble. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Et appelant Lot, ils lui dirent: Où sont les hommes qui sont venus chez toi cette nuit? Fais-les sortir, que nous les connaissions. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Alors Lot sortit vers eux à l'entrée de la maison, et il ferma la porte après lui, ");
INSERT INTO fra_fob_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Et il leur dit: Je vous prie, mes frères, ne faites point le mal! ");
INSERT INTO fra_fob_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Voici, j'ai deux filles, qui n'ont point connu d'homme; je vous les amènerai, et vous leur ferez ce qu'il vous plaira; seulement ne faites rien à ces hommes, puisqu'ils sont venus à l'ombre de mon toit. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Mais ils lui dirent: Retire-toi de là! Puis ils dirent: Cet homme-là est venu ici comme étranger, et il se mêle de juger! Eh bien, nous te traiterons plus mal qu'eux. Et, pressant Lot violemment, ils s'approchèrent pour enfoncer la porte. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Mais ces hommes, avançant leurs mains, firent rentrer Lot vers eux dans la maison, et fermèrent la porte. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Puis ils frappèrent d'éblouissement les hommes qui étaient à l'entrée de la maison, depuis le plus petit jusqu'au plus grand; de sorte qu'ils se lassèrent à chercher la porte. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Alors ces hommes dirent à Lot: Qui as-tu encore ici? Gendre, fils, filles, et tout ce qui est à toi dans la ville, fais tout sortir de ce lieu. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Car nous allons détruire ce lieu, parce que le cri contre ses habitants est grand devant l'Éternel, et l'Éternel nous a envoyés pour le détruire. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Alors Lot sortit et parla à ses gendres, qui avaient pris ses filles, et leur dit: Levez-vous, sortez de ce lieu; car l'Éternel va détruire la ville. Mais ses gendres crurent qu'il se moquait. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Et dès que l'aurore se leva, les anges pressèrent Lot, en disant: Lève-toi, prends ta femme et tes deux filles qui se trouvent ici, de peur que tu ne périsses dans le châtiment de la ville. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Et comme il tardait, ces hommes le prirent par la main; ils prirent aussi par la main sa femme et ses deux filles, parce que l'Éternel voulait l'épargner; et ils l'emmenèrent, et le mirent hors de la ville. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Or, dès qu'ils les eurent fait sortir, l'un d'eux dit: Sauve ta vie; ne regarde point derrière toi, et ne t'arrête en aucun endroit de la plaine; sauve-toi vers la montagne, de peur que tu ne périsses. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Et Lot leur répondit: Non, Seigneur, je te prie; ");
INSERT INTO fra_fob_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Voici, ton serviteur a trouvé grâce devant tes yeux, et tu as signalé ta miséricorde envers moi, en me sauvant la vie. Mais moi, je ne puis me sauver vers la montagne, que le mal ne m'atteigne, et que je ne meure. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Voici, je te prie, cette ville est assez proche pour s'y enfuir, et elle est petite; que je m'y sauve, je te prie, - n'est-elle pas petite? - et que mon âme vive. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Et il lui dit: Voici, je t'accorde encore cette grâce, de ne point détruire la ville dont tu as parlé. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Hâte-toi de t'y sauver; car je ne puis rien faire jusqu'à ce que tu y sois entré. C'est pour cela qu'on appela cette ville Tsoar (petite). ");
INSERT INTO fra_fob_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Comme le soleil se levait sur la terre, Lot entra dans Tsoar. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Alors l'Éternel fit pleuvoir sur Sodome et sur Gomorrhe du soufre et du feu, de la part de l'Éternel, du haut des cieux. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Et il détruisit ces villes et toute la plaine, et tous les habitants des villes, et les germes de la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Mais la femme de Lot regarda derrière elle, et elle devint une statue de sel. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Et Abraham se leva de bon matin, et vint au lieu où il s'était tenu devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Et il regarda vers Sodome et Gomorrhe, et sur toute la surface du pays de la plaine, et il vit monter de la terre une fumée comme la fumée d'une fournaise. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Or, lorsque Dieu détruisit les villes de la plaine, Dieu se souvint d'Abraham, et il fit partir Lot du milieu de la ruine, quand il renversa les villes où Lot avait habité. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Et Lot monta de Tsoar, et habita dans la montagne avec ses deux filles, car il craignait de demeurer dans Tsoar; et il demeura dans une caverne, lui et ses deux filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Et l'aînée dit à la plus jeune: Notre père est vieux, et il n'y a personne sur la terre pour venir vers nous, selon la coutume de tous les pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Viens, faisons boire du vin à notre père, et couchons avec lui, afin que nous conservions la race de notre père. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Elles firent donc boire du vin à leur père cette nuit-là. Et l'aînée vint, et coucha avec son père; mais il ne s'aperçut ni quand elle se coucha, ni quand elle se leva. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Et le lendemain, l'aînée dit à la plus jeune: Voici, j'ai couché la nuit passée avec mon père; faisons-lui boire du vin encore cette nuit; puis va, couche avec lui, et nous conserverons la race de notre père. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Elles firent donc, encore cette nuit-là, boire du vin à leur père. Et la plus jeune se leva et coucha avec lui; mais il ne s'aperçut ni quand elle se coucha, ni quand elle se leva. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Et les deux filles de Lot conçurent de leur père. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Et l'aînée enfanta un fils, et l'appela du nom de Moab (issu d'un père); c'est le père des Moabites jusqu'à ce jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Et la plus jeune aussi enfanta un fils, et l'appela du nom de Ben-Ammi (fils de mon peuple). C'est le père des enfants d'Ammon jusqu'à ce jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham partit de là pour le pays du Midi, et il demeura entre Kadès et Shur, et il séjourna à Guérar. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Et Abraham dit de Sara sa femme: C'est ma sœur. Et Abimélec, roi de Guérar, envoya enlever Sara. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Mais Dieu vint vers Abimélec, en songe, pendant la nuit, et lui dit: Voici, tu es mort, à cause de la femme que tu as prise; car elle a un mari. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Or, Abimélec ne s'était point approché d'elle. Et il répondit: Seigneur, feras-tu périr même une nation juste? ");
INSERT INTO fra_fob_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ne m'a-t-il pas dit: C'est ma sœur? Et elle, elle aussi, n'a-t-elle pas dit: C'est mon frère? C'est dans l'intégrité de mon cœur, et dans l'innocence de mes mains que j'ai fait cela. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Et Dieu lui dit en songe: Moi aussi je sais que tu l'as fait dans l'intégrité de ton cœur; aussi t'ai-je empêché de pécher contre moi; c'est pour cela que je n'ai point permis que tu la touchasses. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Mais maintenant rends la femme de cet homme, car il est prophète; et il priera pour toi, et tu vivras. Mais si tu ne la rends pas, sache que tu mourras certainement, toi et tout ce qui est à toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Et Abimélec se leva de bon matin, et appela tous ses serviteurs, et leur fit entendre toutes ces paroles; et ces gens furent saisis de crainte. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Puis Abimélec appela Abraham et lui dit: Que nous as-tu fait? Et en quoi t'ai-je offensé, que tu aies fait venir sur moi et sur mon royaume un si grand péché? Tu as fait à mon égard des choses qui ne se font pas. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Puis Abimélec dit à Abraham: Qu'avais-tu en vue, pour en agir ainsi? ");
INSERT INTO fra_fob_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Et Abraham répondit: C'est que je me suis dit: Il n'y a sûrement aucune crainte de Dieu dans ce lieu, et ils me tueront à cause de ma femme. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Mais aussi, en vérité, elle est ma sœur, fille de mon père; seulement, elle n'est point fille de ma mère; et elle est devenue ma femme. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Or, lorsque Dieu me fit errer loin de la maison de mon père, je lui dis: Voici la faveur que tu me feras: Dans tous les lieux où nous irons, dis de moi: C'est mon frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Alors Abimélec prit des brebis et des bœufs, des serviteurs et des servantes, et les donna à Abraham, et il lui rendit Sara sa femme. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Et Abimélec dit: Voici, mon pays est à ta disposition; habite où il te plaira. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Et il dit à Sara: Voici, j'ai donné à ton frère mille pièces d'argent; voici, ce sera pour toi un voile sur les yeux, devant tous ceux qui sont avec toi; et auprès de tous tu seras justifiée. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Et Abraham pria Dieu; et Dieu guérit Abimélec, sa femme et ses servantes, et elles enfantèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Car l'Éternel avait entièrement rendu stérile toute la maison d'Abimélec, à cause de Sara, femme d'Abraham. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Et l'Éternel visita Sara, comme il l'avait dit; et l'Éternel fit à Sara comme il en avait parlé. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Et Sara conçut, et enfanta un fils à Abraham dans sa vieillesse, à l'époque que Dieu lui avait dite. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Et Abraham appela son fils, qui lui était né, et que Sara lui avait enfanté, Isaac. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Et Abraham circoncit Isaac son fils à l'âge de huit jours, comme Dieu le lui avait commandé. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Or, Abrabam était âgé de cent ans, quand Isaac, son fils, lui naquit. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Et Sara dit: Dieu m'a fait une chose qui fera rire; tous ceux qui l'apprendront, riront à mon sujet. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Puis elle dit: Qui eût dit à Abraham que Sara allaiterait des enfants? car je lui ai enfanté un fils dans sa vieillesse. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Et l'enfant grandit, et fut sevré. Et Abraham fit un grand festin le jour où Isaac fut sevré. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Et Sara vit le fils d'Agar l'Égyptienne qu'elle avait enfanté à Abraham, qui riait. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Et elle dit à Abraham: Chasse cette servante et son fils, car le fils de cette servante n'héritera point avec mon fils, avec Isaac. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Et cette parole déplut fort à Abraham, à cause de son fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mais Dieu dit à Abraham: Que cela ne te déplaise pas à cause de l'enfant et de ta servante. Quoi que te dise Sara, obéis à sa voix: car c'est en Isaac que ta postérité sera appelée de ton nom. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Mais je ferai aussi du fils de la servante une nation, parce qu'il est ta race. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Et Abraham se leva de bon matin, prit du pain et une outre d'eau, et les donna à Agar; il les mit sur son épaule; il lui donna aussi l'enfant et la renvoya. Et elle s'en alla et erra dans le désert de Béer-Shéba. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Quand l'eau de l'outre fut épuisée, elle laissa l'enfant sous un des arbrisseaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Et elle s'en alla, et s'assit vis-à-vis, environ à la distance d'une portée d'arc; car elle dit: Que je ne voie pas mourir l'enfant. Et elle s'assit vis-à-vis, éleva la voix, et pleura. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Et Dieu entendit la voix du jeune garçon, et l'ange de Dieu appela des cieux Agar, et lui dit: Qu'as-tu, Agar? Ne crains point, car Dieu a entendu la voix du jeune garçon, là où il est. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lève-toi, prends le jeune garçon, et tiens-le par la main; car je ferai de lui une grande nation. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Et Dieu lui ouvrit les yeux, et elle vit un puits d'eau, et elle alla et remplit l'outre d'eau, et donna à boire au jeune garçon. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Et Dieu fut avec le jeune garçon, qui devint grand, et habita dans le désert; et il fut tireur d'arc. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Et il habita dans le désert de Paran. Et sa mère lui prit une femme du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Et il arriva qu'en ce temps-là Abimélec, accompagné de Picol, chef de son armée, parla à Abraham, en disant: Dieu est avec toi dans tout ce que tu fais. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Maintenant donc, jure-moi ici par le nom de Dieu, que tu ne tromperas ni moi, ni mes enfants, ni ma race. Tu agiras envers moi et envers le pays où tu as séjourné, avec la même bonté avec laquelle j'ai agi envers toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Et Abraham répondit: Je le jurerai. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mais Abraham se plaignit à Abimélec à cause d'un puits d'eau, dont les serviteurs d'Abimélec s'étaient emparés. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Et Abimélec dit: Je ne sais qui a fait cela; toi-même tu ne m'en as point averti, et moi je n'en ai entendu parler qu'aujourd'hui. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Alors Abraham prit des brebis et des bœufs, et les donna à Abimélec, et ils firent alliance ensemble. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Et Abraham mit à part sept jeunes brebis du troupeau. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Et Abimélec dit à Abraham: Qu'est-ce que ces sept jeunes brebis que tu as mises à part? ");
INSERT INTO fra_fob_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Et il répondit: C'est que tu accepteras ces sept jeunes brebis de ma main, afin que ce me soit un témoignage que j'ai creusé ce puits. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","C'est pourquoi on appela ce lieu-là Béer-Shéba (puits du serment); car ils y jurèrent tous deux. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ils traitèrent donc alliance à Béer-Shéba. Puis Abimélec se leva avec Picol, chef de son armée, et ils retournèrent au pays des Philistins. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Et Abraham planta un tamarin à Béer-Shéba, et il invoqua là le nom de l'Éternel, le Dieu d'éternité. ");
INSERT INTO fra_fob_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Et Abraham séjourna longtemps au pays des Philistins. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Il arriva, après ces choses, que Dieu éprouva Abraham, et il lui dit: Abraham! et il répondit: Me voici. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Et il dit: Prends ton fils, ton unique, celui que tu aimes, Isaac, et va-t'en au pays de Morija, et là offre-le en holocauste, sur une des montagnes que je te dirai. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Et Abraham se leva de bon matin, bâta son âne, prit deux de ses serviteurs avec lui, et Isaac son fils; il fendit du bois pour l'holocauste; puis il partit et s'en alla vers le lieu que Dieu lui avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Le troisième jour, Abraham, levant les yeux, vit le lieu de loin. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Et Abraham dit à ses serviteurs: Demeurez ici avec l'âne. Moi et l'enfant nous irons jusque-là, et nous adorerons; puis nous reviendrons vers vous. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Et Abraham prit le bois de l'holocauste, et le mit sur Isaac son fils; puis il prit dans sa main le feu et le couteau, et ils s'en allèrent tous d'eux ensemble. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Alors Isaac parla à Abraham son père, et dit: Mon père! Abraham répondit: Me voici, mon fils. Et il dit: Voici le feu et le bois; mais où est l'agneau pour l'holocauste? ");
INSERT INTO fra_fob_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Et Abraham répondit: Mon fils, Dieu se pourvoira lui-même de l'agneau pour l'holocauste. Et ils marchèrent tous deux ensemble. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Et ils vinrent au lieu que Dieu lui avait dit, et Abraham y bâtit l'autel, et rangea le bois; et il lia Isaac son fils, et le mit sur l'autel, par-dessus le bois. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Puis Abraham étendit la main, et prit le couteau pour égorger son fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Mais l'ange de l'Éternel lui cria des cieux, et dit: Abraham, Abraham! Et il répondit: Me voici. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Et il dit: Ne porte pas ta main sur l'enfant, et ne lui fais rien. Car maintenant je sais que tu crains Dieu, puisque tu ne m'as pas refusé ton fils, ton unique. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Et Abraham leva les yeux et regarda, et voici derrière lui un bélier, retenu dans un buisson par les cornes. Alors Abraham alla prendre le bélier, et l'offrit en holocauste à la place de son fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Et Abraham appela ce lieu-là, Jéhova-jiré (l'Éternel y pourvoira). De sorte qu'on dit aujourd'hui: Sur la montagne de l'Éternel il y sera pourvu. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Et l'ange de l'Éternel cria des cieux à Abraham pour la seconde fois, ");
INSERT INTO fra_fob_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Et dit: Je jure par moi-même, dit l'Éternel, que, puisque tu as fait cela, et que tu n'as point refusé ton fils, ton unique, ");
INSERT INTO fra_fob_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Je te bénirai certainement, et je multiplierai ta postérité comme les étoiles des cieux, et comme le sable qui est sur le bord de la mer; et ta postérité possédera la porte de ses ennemis. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Et toutes les nations de la terre seront bénies en ta postérité, parce que tu as obéi à ma voix. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Alors Abraham retourna vers ses serviteurs; et ils se levèrent et s'en allèrent ensemble à Béer-Shéba; et Abraham demeura à Béer-Shéba. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Or, après ces choses, on fit rapport à Abraham, en disant: Voici, Milca a enfanté, elle aussi, des enfants à Nachor ton frère: ");
INSERT INTO fra_fob_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uts son premier-né, Buz son frère, Kémuël, père d'Aram; ");
INSERT INTO fra_fob_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Késed, Hazo, Pildash, Jidlaph et Béthuël. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Et Béthuël a engendré Rébecca. Milca enfanta ces huit à Nachor, frère d'Abraham. ");
INSERT INTO fra_fob_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Et sa concubine, nommée Réuma, enfanta, elle aussi, Thébah, Gaham, Tahash et Maaca. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Or, Sara vécut cent vingt-sept ans; ce sont là les années de la vie de Sara. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Et Sara mourut à Kirjath-Arba, qui est Hébron, dans le pays de Canaan. Et Abraham vint pour mener deuil sur Sara, et pour la pleurer. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Puis Abraham se leva de devant son mort et parla aux enfants de Heth, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Je suis un étranger et un hôte chez vous; donnez-moi la propriété d'une sépulture chez vous, afin que j'enterre mon mort et que je l'ôte de devant moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Et les enfants de Heth répondirent à Abraham, en lui disant: ");
INSERT INTO fra_fob_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Écoute-nous, mon seigneur; tu es un prince de Dieu au milieu de nous; enterre ton mort dans le meilleur de nos tombeaux. Nul de nous ne te refusera son tombeau pour enterrer ton mort. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Alors Abraham se leva et se prosterna devant le peuple du pays, devant les enfants de Heth. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Et il leur dit: S'il vous plaît que j'enterre mon mort et que je l'ôte de devant moi, écoutez-moi, et intercédez pour moi auprès d'Ephron, fils de Tsohar, ");
INSERT INTO fra_fob_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Afin qu'il me donne sa caverne de Macpéla, qui est à l'extrémité de son champ; qu'il me la cède pour sa pleine valeur, en propriété sépulcrale au milieu de vous. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Or Ephron était assis parmi les enfants de Heth. Et Ephron, le Héthien, répondit à Abraham devant les enfants de Heth qui écoutaient, devant tous ceux qui entraient par la porte de sa ville, et dit: ");
INSERT INTO fra_fob_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Non, mon seigneur, écoute-moi: Je te donne le champ, je te donne aussi la caverne qui y est; je te la donne en présence des enfants de mon peuple; enterre ton mort. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Et Abraham se prosterna devant le peuple du pays; ");
INSERT INTO fra_fob_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Et il parla à Ephron, devant le peuple du pays qui écoutait, et dit: Cependant, écoute-moi, je te prie; je donne l'argent du champ; reçois-le de moi et j'y enterrerai mon mort. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Et Ephron répondit à Abraham, en lui disant: ");
INSERT INTO fra_fob_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Mon seigneur, écoute-moi: une terre de quatre cents sicles d'argent, entre moi et toi, qu'est-ce que cela? Enterre donc ton mort. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Et Abraham entendit Ephron, et Abraham pesa à Ephron l'argent qu'il avait dit, en présence des enfants de Heth, quatre cents sicles d'argent ayant cours chez le marchand. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Et le champ d'Ephron, qui était à Macpéla, devant Mamré, le champ, la caverne qui y était, et tous les arbres qui étaient dans le champ et dans tous ses confins tout autour, ");
INSERT INTO fra_fob_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Furent assurés en propriété à Abraham, en présence des enfants de Heth, devant tous ceux qui entraient par la porte de sa ville. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Et, après cela, Abraham enterra Sara sa femme dans la caverne du champ de Macpéla, en face de Mamré, qui est Hébron, au pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Et le champ, et la caverne qui y est, furent assurés par les Héthiens à Abraham en propriété sépulcrale. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Or Abraham était vieux, avancé en âge; et l'Éternel avait béni Abraham en toutes choses. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Et Abraham dit à son serviteur, le plus ancien de sa maison, qui avait le gouvernement de tout ce qui lui appartenait: Mets, je te prie, ta main sous ma cuisse, ");
INSERT INTO fra_fob_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Et je te ferai jurer par l'Éternel, le Dieu des cieux et le Dieu de la terre, que tu ne prendras point de femme pour mon fils, d'entre les filles des Cananéens, parmi lesquels j'habite. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mais tu iras dans mon pays et vers ma parenté, et tu y prendras une femme pour mon fils, pour Isaac. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Et le serviteur lui répondit: Peut-être que la femme ne voudra point me suivre en ce pays. Me faudra-t-il ramener ton fils au pays d'où tu es sorti? ");
INSERT INTO fra_fob_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham lui dit: Garde-toi bien d'y ramener mon fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","L'Éternel, le Dieu des cieux, qui m'a pris de la maison de mon père et du pays de ma naissance, et qui m'a parlé, et qui m'a juré, en disant: Je donnerai à ta postérité ce pays, enverra lui-même son ange devant toi, et tu prendras de là une femme pour mon fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Que si la femme ne veut pas te suivre, tu seras quitte de ce serment que je te fais faire. Quoi qu'il en soit, n'y ramène point mon fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Alors le serviteur mit sa main sous la cuisse d'Abraham son maître, et s'engagea par serment à faire ce qu'il avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Puis le serviteur prit dix chameaux d'entre les chameaux de son maître, et partit, avec toute sorte de biens de son maître en ses mains. Il se leva donc, et s'en alla en Mésopotamie, à la ville de Nachor. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Et il fit reposer les chameaux sur leurs genoux hors de la ville, près d'un puits d'eau, vers le soir, à l'heure où sortent celles qui vont puiser de l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Et il dit: Éternel, Dieu de mon maître Abraham, fais-moi, je te prie, rencontrer aujourd'hui ce que je cherche et sois favorable à mon seigneur Abraham. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Voici, je me tiens près de la source, et les filles des gens de la ville sortent pour puiser de l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Que la jeune fille à qui je dirai: Penche, je te prie, ta cruche, afin que je boive, et qui répondra: Bois, et j'abreuverai aussi tes chameaux, soit celle que tu as destinée à ton serviteur Isaac; et je connaîtrai par là que tu as été favorable à mon seigneur. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Et avant qu'il eût achevé de parler, voici, Rébecca, fille de Béthuël, fils de Milca, femme de Nachor, frère d'Abraham, sortait, avec sa cruche sur l'épaule. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Et la jeune fille était très belle; elle était vierge, et nul homme ne l'avait connue. Elle descendit à la source, remplit sa cruche et remonta. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Alors le serviteur courut au-devant d'elle, et dit: Fais-moi boire, je te prie, un peu de l'eau de ta cruche. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Et elle dit: Bois, mon seigneur. Et elle se hâta d'abaisser sa cruche sur sa main, et lui donna à boire. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Quand elle eut achevé de lui donner à boire, elle dit: J'en puiserai aussi pour tes chameaux, jusqu'à ce qu'ils aient achevé de boire. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Et elle se hâta de vider sa cruche dans l'abreuvoir, courut encore au puits pour en puiser, et en puisa pour tous ses chameaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Et cet homme la contemplait en silence, pour savoir si l'Éternel avait fait réussir son voyage ou non. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Et, dès que les chameaux eurent achevé de boire, cet homme prit un anneau d'or, pesant un demi-sicle, et deux bracelets pour ses mains, pesant dix sicles d'or. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Et il dit: De qui es-tu fille? apprends-le-moi, je te prie. Y a-t-il dans la maison de ton père de la place pour nous, pour y passer la nuit? ");
INSERT INTO fra_fob_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Et elle lui dit: Je suis fille de Béthuël, le fils de Milca, qu'elle enfanta à Nachor. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Puis elle lui dit: Il y a chez nous beaucoup de paille et de fourrage, et aussi de la place pour y passer la nuit. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Et cet homme s'inclina et se prosterna devant l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Et il dit: Béni soit l'Éternel, le Dieu d'Abraham, mon maître, qui n'a pas cessé d'être miséricordieux et fidèle envers mon seigneur! Quand j'étais en chemin, l'Éternel m'a conduit dans la maison des frères de mon seigneur. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Et la jeune fille courut et rapporta ces choses à la maison de sa mère. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Or, Rébecca avait un frère nommé Laban. Et Laban courut dehors vers cet homme, près de la source. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Aussitôt qu'il eut vu l'anneau et les bracelets aux mains de sa sœur, et qu'il eut entendu les paroles de Rébecca sa sœur, qui disait: Cet homme m'a parlé ainsi, il vint vers cet homme; et voici, il se tenait près des chameaux, vers la source. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Et il dit: Entre, béni de l'Éternel, pourquoi te tiens-tu dehors, quand j'ai préparé la maison, et un lieu pour les chameaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","L'homme entra donc dans la maison, et Laban déharnacha les chameaux, et donna de la paille et du fourrage aux chameaux, et de l'eau, pour laver ses pieds et les pieds des gens qui étaient avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Et on lui présenta à manger. Mais il dit: Je ne mangerai point, que je n'aie dit ce que j'ai à dire. Et Laban dit: Parle. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Alors il dit: Je suis serviteur d'Abraham. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Or, l'Éternel a comblé de bénédictions mon seigneur, et il est devenu grand; et il lui a donné des brebis et des bœufs, de l'argent et de l'or, des serviteurs et des servantes, des chameaux et des ânes. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Et Sara, femme de mon seigneur, a enfanté un fils à mon seigneur, après être devenue vieille, et il lui a donné tout ce qu'il a. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Et mon seigneur m'a fait jurer, en disant: Tu ne prendras point de femme pour mon fils, parmi les filles des Cananéens, dans le pays desquels j'habite. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mais tu iras vers la maison de mon père, et vers ma parenté, et tu y prendras une femme pour mon fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Et je dis à mon seigneur: Peut-être que la femme ne me suivra pas. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Et il me répondit: L'Éternel, devant la face de qui je marche, enverra son ange avec toi, et fera réussir ton voyage, et tu prendras une femme pour mon fils, de ma parenté et de la maison de mon père. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tu seras quitte du serment solennel que tu me fais, quand tu seras allé vers ma parenté; et si on ne te la donne pas, tu seras quitte du serment solennel que tu me fais. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Et quand je suis venu aujourd'hui à la source, j'ai dit: Éternel, Dieu de mon seigneur Abraham! si tu daignes faire réussir le voyage que j'ai entrepris, ");
INSERT INTO fra_fob_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Voici, je me tiens près de la source: que la jeune fille qui sortira pour puiser, et à qui je dirai: Donne-moi, je te prie, à boire un peu de l'eau de ta cruche, ");
INSERT INTO fra_fob_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Et qui me répondra: Bois toi-même, et j'en puiserai aussi pour tes chameaux, soit la femme que l'Éternel a destinée au fils de mon seigneur. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Avant que j'eusse achevé de parler en mon cœur, voici, Rébecca sortait avec sa cruche sur son épaule; et elle est descendue à la source et a puisé de l'eau. Et je lui ai dit: Donne-moi à boire, je te prie; ");
INSERT INTO fra_fob_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Et elle s'est hâtée d'abaisser sa cruche de dessus son épaule, et elle m'a dit: Bois, et j'abreuverai aussi tes chameaux. J'ai donc bu, et elle a aussi abreuvé les chameaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Et je l'ai interrogée, et j'ai dit: De qui es-tu fille? Elle a répondu: Je suis fille de Béthuël, fils de Nachor, que Milca lui enfanta. Alors j'ai mis l'anneau à son visage et les bracelets à ses mains. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ensuite je me suis incliné et prosterné devant l'Éternel, et j'ai béni l'Éternel, le Dieu de mon maître Abraham, qui m'a conduit dans le droit chemin, pour prendre la fille du frère de mon seigneur pour son fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Et maintenant, si vous voulez être favorables et fidèles à mon seigneur, déclarez-le-moi; sinon déclarez-le-moi aussi, et je me tournerai à droite ou à gauche. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Et Laban et Béthuël répondirent, et dirent: La chose procède de l'Éternel; nous ne pouvons te dire ni mal ni bien. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Voici, Rébecca est devant toi, prends-la et pars, et qu'elle soit la femme du fils de ton seigneur, comme l'Éternel l'a dit. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Et dès que le serviteur d'Abraham eut entendu leurs paroles, il se prosterna en terre devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Le serviteur tira ensuite des objets d'argent et des objets d'or, et des vêtements, et les donna à Rébecca; il donna aussi des choses précieuses à son frère et à sa mère. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Et ils mangèrent et burent, lui et les gens qui étaient avec lui, et ils y passèrent la nuit. Et ils se levèrent le lendemain, et le serviteur dit: Renvoyez-moi à mon seigneur. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Et son frère et sa mère dirent: Que la jeune fille demeure avec nous quelques jours, une dizaine; puis elle s'en ira. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Et il leur dit: Ne me retardez point, puisque l'Éternel a fait réussir mon voyage. Renvoyez-moi, que je m'en aille à mon seigneur. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Alors ils dirent: Appelons la jeune fille et demandons-lui son avis. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ils appelèrent donc Rébecca et lui dirent: Veux-tu aller avec cet homme? Et elle répondit: J'irai. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Alors ils laissèrent aller Rébecca leur sœur, et sa nourrice, et le serviteur d'Abraham, et ses gens. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Et ils bénirent Rébecca et lui dirent: O notre sœur, sois la mère de milliers de myriades, et que ta postérité possède la porte de ses ennemis! ");
INSERT INTO fra_fob_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Et Rébecca et ses servantes se levèrent et montèrent sur les chameaux, et suivirent cet homme. Le serviteur prit donc Rébecca et s'en alla. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Or, Isaac revenait du puits du Vivant-qui-me-voit; et il demeurait au pays du Midi. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Et Isaac était sorti pour méditer dans les champs, vers le soir; et levant les yeux, il regarda, et voici que des chameaux arrivaient. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rébecca leva aussi les yeux, vit Isaac, et se jeta à bas du chameau. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Car elle dit au serviteur: Qui est cet homme-là qui vient dans les champs au-devant de nous? Et le serviteur répondit: C'est mon seigneur. Et elle prit son voile et s'en couvrit. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Et le serviteur raconta à Isaac toutes les choses qu'il avait faites. ");
INSERT INTO fra_fob_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Alors Isaac mena Rébecca dans la tente de Sara sa mère; et il prit Rébecca, et elle fut sa femme, et il l'aima. Et Isaac se consola, après la mort de sa mère. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Or, Abraham prit une autre femme, nommée Kétura, ");
INSERT INTO fra_fob_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Qui lui enfanta Zimran, Jokshan, Médan, Madian, Jishbak, et Shuach. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Et Jokshan engendra Sheba et Dedan. Et les enfants de Dedan furent: les Asshurim, les Letushim et les Leümmim. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Et les fils de Madian furent: Epha, Epher, Hanoc, Abida, Eldaa. Tous ceux-là sont enfants de Kétura. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Et Abraham donna tout ce qui lui appartenait à Isaac. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mais il fit des présents aux fils de ses concubines, et les envoya, durant sa vie, loin de son fils Isaac, vers le Levant, au pays d'Orient. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Et tout le temps qu'Abraham vécut fut de cent soixante et quinze ans. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Puis Abraham expira et mourut dans une belle vieillesse, âgé et rassasié de jours; et il fut recueilli vers ses peuples. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Et Isaac et Ismaël, ses fils, l'enterrèrent dans la caverne de Macpéla, dans le champ d'Ephron, fils de Tsohar, le Héthien, qui est en face de Mamré; ");
INSERT INTO fra_fob_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Le champ qu'Abraham avait acheté des enfants de Heth. C'est là que fut enterré Abraham, avec Sara sa femme. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Or, après la mort d'Abraham, Dieu bénit Isaac son fils. Et Isaac habita près du puits du Vivant-qui-me-voit. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Et voici les descendants d'Ismaël, fils d'Abraham, qu'Agar, l'Égyptienne, servante de Sara, avait enfanté à Abraham. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Et voici les noms des fils d'Ismaël, leurs noms selon leur ordre de naissance: le premier-né d'Ismaël, Nebajoth; puis Kédar, Abdéel, Mibsam, ");
INSERT INTO fra_fob_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma, Duma, Massa, ");
INSERT INTO fra_fob_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Théma, Jéthur, Naphish et Kedma. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ce sont là les fils d'Ismaël, et ce sont là leurs noms, selon leurs villages, et selon leurs bourgs: ce furent les douze princes de leurs peuples. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Et le temps de la vie d'Ismaël fut de cent trente-sept ans. Puis il expira et mourut, et fut recueilli vers ses peuples. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Et ses enfants habitèrent depuis Havila jusqu'à Shur, qui est en face de l'Égypte, quand on va vers l'Assyrie. Il s'établit en face de tous ses frères. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Et voici les descendants d'Isaac, fils d'Abraham: Abraham engendra Isaac. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Et Isaac était âgé de quarante ans quand il épousa Rébecca, fille de Béthuël, l'Araméen, de Paddan-Aram, sœur de Laban, l'Araméen. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Et Isaac pria instamment l'Éternel pour sa femme, car elle était stérile. Et l'Éternel fut fléchi par ses prières; et Rébecca sa femme conçut. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Mais les enfants se heurtaient dans son sein, et elle dit: S'il en est ainsi, pourquoi suis-je? Et elle alla consulter l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Et l'Éternel lui dit: Deux nations sont dans ton ventre, et deux peuples se sépareront au sortir de tes entrailles. Un de ces peuples sera plus fort que l'autre; et le plus grand servira le plus petit. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Et le temps où elle devait accoucher arriva, et voici, il y avait deux jumeaux dans son ventre. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Celui qui sortit le premier était roux, tout velu comme un manteau de poil; et ils l'appelèrent Ésaü (velu). ");
INSERT INTO fra_fob_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Et après cela sortit son frère, et sa main tenait le talon d'Ésaü; et on l'appela Jacob (supplanteur). Et Isaac était âgé de soixante ans quand ils naquirent. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Et les enfants grandirent, et Ésaü devint un habile chasseur, un homme des champs; mais Jacob était un homme paisible, se tenant dans les tentes. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Et Isaac aimait Ésaü; car la venaison était de son goût; mais Rébecca aimait Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Or, comme Jacob cuisait du potage, Ésaü vint des champs, et il était las. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Et Ésaü dit à Jacob: Donne-moi donc à manger de ce roux, de ce roux-là; car je suis très fatigué. C'est pour cela qu'on l'appela Édom (roux). ");
INSERT INTO fra_fob_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Mais Jacob dit: Vends-moi d'abord ton droit d'aînesse. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Et Ésaü dit: Voici, je m'en vais mourir; à quoi me sert le droit d'aînesse? ");
INSERT INTO fra_fob_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Et Jacob dit: Jure-moi d'abord. Et il lui jura; ainsi il vendit son droit d'aînesse à Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Et Jacob donna à Ésaü du pain et du potage de lentilles; et il mangea, et but; puis il se leva et s'en alla. Ainsi Ésaü méprisa le droit d'aînesse. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Or, il y eut une famine au pays, outre la première famine qui avait eu lieu du temps d'Abraham. Et Isaac s'en alla vers Abimélec, roi des Philistins, à Guérar. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Et l'Éternel lui apparut, et lui dit: Ne descends point en Égypte; demeure au pays que je te dirai. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Séjourne dans ce pays, et je serai avec toi, et je te bénirai. Car je donnerai, à toi et à ta postérité, tous ces pays-ci, et je mettrai à exécution le serment que j'ai fait à Abraham, ton père. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Et je multiplierai ta postérité comme les étoiles des cieux, et je donnerai à ta postérité tous ces pays-ci; et toutes les nations de la terre seront bénies en ta postérité, ");
INSERT INTO fra_fob_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Parce qu'Abraham a obéi à ma voix, et a gardé ce que je lui avais ordonné, mes commandements, mes statuts et mes lois. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Isaac demeura donc à Guérar. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Et quand les gens du lieu s'informèrent de sa femme, il répondit: C'est ma sœur; car il craignait de dire: C'est ma femme; de peur, disait-il, que les habitants du lieu ne me tuent à cause de Rébecca; car elle était belle de figure. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Or, il arriva, quand il y eut passé un assez long temps, qu'Abimélec, roi des Philistins, regarda par la fenêtre, et il vit Isaac qui se jouait avec Rébecca, sa femme. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Alors Abimélec appela Isaac, et lui dit: Certainement, voici, c'est ta femme; et comment as-tu dit: C'est ma sœur? Et Isaac lui répondit: C'est que j'ai dit: Il ne faut pas que je meure à cause d'elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Et Abimélec dit: Que nous as-tu fait? Peu s'en est fallu que quelqu'un du peuple n'ait abusé de ta femme, et que tu ne nous aies rendus coupables. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Et Abimélec donna cet ordre à tout le peuple: Celui qui touchera à cet homme ou à sa femme, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Et Isaac sema dans cette terre-là, et il recueillit cette année le centuple; car l'Éternel le bénit. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Et cet homme devint grand, et il allait toujours s'accroissant, jusqu'à ce qu'il devînt fort riche. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Et il eut des troupeaux de brebis et des troupeaux de bœufs, et un grand nombre de serviteurs; et les Philistins lui portèrent envie; ");
INSERT INTO fra_fob_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Et tous les puits que les serviteurs de son père avaient creusés, du temps de son père Abraham, les Philistins les bouchèrent, et les remplirent de terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Et Abimélec dit à Isaac: Va-t'en de chez nous; car tu es devenu beaucoup plus puissant que nous. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaac partit donc de là, et campa dans la vallée de Guérar et y habita. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Et Isaac creusa de nouveau les puits d'eau qu'on avait creusés du temps d'Abraham, son père, et que les Philistins avaient bouchés après la mort d'Abraham; et il leur donna les mêmes noms que leur avait donnés son père. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Et les serviteurs d'Isaac creusèrent dans la vallée, et y trouvèrent un puits d'eau vive. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Mais les bergers de Guérar se querellèrent avec les bergers d'Isaac, en disant: L'eau est à nous; et il appela le puits: Esek (contestation), parce qu'ils avaient contesté avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ensuite ils creusèrent un autre puits, pour lequel ils se querellèrent encore; et il l'appela: Sitna (opposition). ");
INSERT INTO fra_fob_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Alors il partit de là et creusa un autre puits, pour lequel ils ne disputèrent point; et il l'appela: Rehoboth (largeurs), et dit: C'est que l'Éternel nous a maintenant mis au large, et nous fructifierons dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Et de là il monta à Béer-Shéba. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Et l'Éternel lui apparut cette nuit-là, et lui dit: Je suis le Dieu d'Abraham, ton père; ne crains point, car je suis avec toi; et je te bénirai, et je multiplierai ta postérité, à cause d'Abraham, mon serviteur. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Alors il bâtit là un autel, et invoqua le nom de l'Éternel, et dressa là sa tente; et les serviteurs d'Isaac y creusèrent un puits. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Et Abimélec vint vers lui, de Guérar, avec Ahuzath son ami, et Picol, chef de son armée. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Mais Isaac leur dit: Pourquoi venez-vous vers moi, quand vous me haïssez, et que vous m'avez renvoyé d'avec vous? ");
INSERT INTO fra_fob_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Et ils répondirent: Nous voyons clairement que l'Éternel est avec toi, et nous disons: Qu'il y ait donc un serment solennel entre nous, entre nous et toi; et que nous traitions alliance avec toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Jure que tu ne nous feras aucun mal, de même que nous ne t'avons point touché, et que nous ne t'avons fait que du bien, et t'avons laissé aller en paix. Tu es maintenant béni de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Et il leur fit un festin, et ils mangèrent et burent. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Et ils se levèrent de bon matin, et s'engagèrent l'un l'autre par serment. Puis Isaac les renvoya, et ils s'en allèrent d'avec lui en paix. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Il arriva, en ce même jour, que les serviteurs d'Isaac vinrent lui donner des nouvelles du puits qu'ils avaient creusé, et lui dirent: Nous avons trouvé de l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Et il l'appela Shiba (serment). C'est pour cela que la ville se nomme Béer-Shéba (puits du serment) jusqu'à ce jour. ");
INSERT INTO fra_fob_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Or, Ésaü, âgé de quarante ans, prit pour femmes Judith, fille de Béeri, le Héthien, et Basmath, fille d'Elon, le Héthien; ");
INSERT INTO fra_fob_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Qui furent une amertume d'esprit pour Isaac et pour Rébecca. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Et il arriva, quand Isaac fut devenu vieux et que ses yeux furent trop faibles pour voir, qu'il appela Ésaü, son fils aîné, et lui dit: Mon fils! et il lui répondit: Me voici! ");
INSERT INTO fra_fob_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Et il dit: Voici je suis vieux, et je ne sais point le jour de ma mort. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Maintenant donc, prends, je te prie, tes armes, ton carquois et ton arc, et va-t'en aux champs, et prends-moi du gibier. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Et apprête-moi un mets appétissant, comme je les aime; et apporte-le-moi, que je le mange, afin que mon âme te bénisse avant que je meure. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Or, Rébecca écoutait, pendant qu'Isaac parlait à Ésaü, son fils. Ésaü s'en alla donc aux champs pour prendre du gibier et l'apporter. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Et Rébecca parla à Jacob, son fils, et lui dit: Voici, j'ai entendu ton père, qui parlait à Ésaü, ton frère, et lui disait: ");
INSERT INTO fra_fob_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Apporte-moi du gibier, et apprête-moi un mets appétissant, que je le mange, et que je te bénisse devant l'Éternel, avant de mourir. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Maintenant donc, mon fils, obéis à ma voix, pour ce que je vais te commander. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Va me prendre au troupeau deux bons chevreaux, et j'en apprêterai pour ton père un mets appétissant, comme il les aime. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Et tu le porteras à ton père, pour qu'il le mange, afin qu'il te bénisse avant sa mort. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Et Jacob répondit à Rébecca sa mère: Voici, Ésaü, mon frère, est velu, et je ne le suis pas. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Peut-être que mon père me tâtera, et il me regardera comme un trompeur, et j'attirerai sur moi la malédiction, et non la bénédiction. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Et sa mère lui dit: Que ta malédiction soit sur moi, mon fils; obéis seulement à ma voix, et va me chercher ces chevreaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Il alla donc les chercher et les apporta à sa mère, et sa mère en apprêta un mets appétissant, comme son père les aimait. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Puis Rébecca prit les plus riches habits d'Ésaü, son fils aîné, qu'elle avait auprès d'elle dans la maison, et elle en revêtit Jacob, son fils cadet. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Et elle couvrit des peaux de chevreaux ses mains et son cou, qui était sans poil. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ensuite elle mit le mets appétissant et le pain qu'elle avait apprêtés, dans la main de Jacob, son fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Et il vint vers son père, et dit: Mon père! Et il répondit: Me voici; qui es-tu, mon fils? ");
INSERT INTO fra_fob_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Et Jacob dit à son père: Je suis Ésaü, ton fils aîné; j'ai fait ce que tu m'as commandé. Lève-toi, je te prie, assieds-toi, et mange de ma chasse, afin que ton âme me bénisse. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Et Isaac dit à son fils: Comment donc en as-tu trouvé si tôt mon fils? Et il dit: C'est que l'Éternel ton Dieu me l'a fait rencontrer. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Et Isaac dit à Jacob: Approche, que je te tâte, mon fils, pour savoir si tu es mon fils Ésaü, ou non. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob s'approcha donc d'Isaac, son père, qui le tâta, et dit: La voix est la voix de Jacob; mais les mains sont les mains d'Ésaü. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Il ne le reconnut pas; car ses mains étaient velues, comme les mains d'Ésaü, son frère; et il le bénit. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Et il dit: C'est toi qui es mon fils Ésaü? Et il répondit: C'est moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Alors il dit: Sers-moi, que je mange de la chasse de mon fils, pour que mon âme te bénisse. Et il le servit, et il mangea. Il lui apporta aussi du vin, et il but. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Puis Isaac, son père, lui dit: Approche, et baise-moi, mon fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Et il s'approcha, et le baisa. Et Isaac sentit l'odeur de ses habits, et il le bénit, et dit: Voici, l'odeur de mon fils est comme l'odeur d'un champ que l'Éternel a béni. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Que Dieu te donne de la rosée des cieux et de la graisse de la terre, et une abondance de froment et de moût! ");
INSERT INTO fra_fob_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Que des peuples te servent, et que des nations se prosternent devant toi! Sois le maître de tes frères, et que les fils de ta mère se prosternent devant toi! Quiconque te maudira, soit maudit, et quiconque te bénira, soit béni! ");
INSERT INTO fra_fob_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Et il arriva, aussitôt qu'Isaac eut achevé de bénir Jacob, et comme Jacob était à peine sorti de devant Isaac, son père, qu'Ésaü, son frère, revint de la chasse. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Il apprêta, lui aussi, un mets appétissant, et l'apporta à son père, et il lui dit: Que mon père se lève, et mange de la chasse de son fils, afin que ton âme me bénisse. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Et Isaac, son père, lui dit: Qui es-tu? Et il dit: Je suis ton fils, ton premier-né, Ésaü. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Et Isaac fut saisi d'une émotion extraordinaire; et il dit: Qui est donc celui qui a pris du gibier, et m'en a apporté? et j'ai mangé de tout, avant que tu vinsses, et je l'ai béni, et aussi sera-t-il béni. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Dès qu'Ésaü eut entendu les paroles de son père, il jeta un cri très grand et très amer. Et il dit à son père: Bénis-moi, moi aussi, mon père! ");
INSERT INTO fra_fob_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Mais il dit: Ton frère est venu avec ruse, et il a pris ta bénédiction. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Et Ésaü dit: Est-ce parce qu'on l'a appelé Jacob, qu'il m'a déjà supplanté deux fois? Il a pris mon droit d'aînesse, et voici, maintenant il a pris ma bénédiction. Ensuite il dit: N'as-tu point réservé de bénédiction pour moi? ");
INSERT INTO fra_fob_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Et Isaac répondit et dit à Ésaü: Voici, je l'ai établi ton maître et je lui ai donné tous ses frères pour serviteurs; et je l'ai pourvu de froment et de moût. Et que ferais-je donc pour toi, mon fils? ");
INSERT INTO fra_fob_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Et Ésaü dit à son père: N'as-tu que cette bénédiction, mon père? bénis-moi, moi aussi, mon père! Et Ésaü éleva la voix, et pleura. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Et Isaac son père répondit, et lui dit: Voici, ta demeure sera de la graisse de la terre, de la rosée des cieux d'en haut. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Et tu vivras de ton épée, et tu serviras ton frère; mais il arrivera, comme tu seras errant, que tu briseras son joug de dessus ton cou. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Et Ésaü prit Jacob en aversion à cause de la bénédiction que son père lui avait donnée; et Ésaü dit en son cœur: Les jours du deuil de mon père approchent; et je tuerai Jacob, mon frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Et l'on rapporta à Rébecca les paroles d'Ésaü, son fils aîné; et elle envoya appeler Jacob, son second fils, et lui dit: Voici, Ésaü ton frère va se venger de toi en te tuant. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Maintenant donc, mon fils, obéis à ma voix: lève-toi, enfuis-toi vers Laban, mon frère, à Charan. ");
INSERT INTO fra_fob_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Et tu demeureras avec lui quelque temps, jusqu'à ce que la fureur de ton frère soit passée, ");
INSERT INTO fra_fob_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Jusqu'à ce que la colère de ton frère se détourne de toi, et qu'il ait oublié ce que tu lui as fait. Alors je t'enverrai chercher de là. Pourquoi serais-je privée de vous deux en un même jour? ");
INSERT INTO fra_fob_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Et Rébecca dit à Isaac: Je suis dégoûtée de la vie, à cause des filles de Heth. Si Jacob prend parmi les filles de Heth, parmi les filles du pays, une femme comme celles-là, à quoi me sert la vie? ");
INSERT INTO fra_fob_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Alors Isaac appela Jacob, et le bénit, et lui commanda et lui dit: Tu ne prendras point une femme parmi les filles de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Lève-toi, va à Paddan-Aram, à la maison de Béthuël, père de ta mère, et prends-toi une femme de là, parmi les filles de Laban, frère de ta mère. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Et que le Dieu Tout-Puissant te bénisse, te fasse croître, et te multiplie, et que tu deviennes une assemblée de peuples! ");
INSERT INTO fra_fob_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Et qu'il te donne la bénédiction d'Abraham, à toi et à ta postérité avec toi, afin que tu possèdes le pays où tu as séjourné, que Dieu a donné à Abraham! ");
INSERT INTO fra_fob_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Puis Isaac fit partir Jacob, qui s'en alla à Paddan-Aram, vers Laban, fils de Béthuël, l'Araméen, frère de Rébecca, mère de Jacob et d'Ésaü. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Et Ésaü vit qu'Isaac avait béni Jacob, et l'avait envoyé à Paddan-Aram pour y prendre une femme, en le bénissant, et qu'il lui avait commandé, et dit: Tu ne prendras point une femme parmi les filles de Canaan; ");
INSERT INTO fra_fob_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Et que Jacob avait obéi à son père et à sa mère, et s'en était allé à Paddan-Aram. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ésaü, voyant donc que les filles de Canaan déplaisaient à Isaac, son père, ");
INSERT INTO fra_fob_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","S'en alla vers Ismaël, et prit pour femme (outre les femmes qu'il avait) Mahalath, fille d'Ismaël, fils d'Abraham, sœur de Nébajoth. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Mais Jacob partit de Béer-Shéba, et s'en alla à Charan. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Et il arriva en un lieu où il passa la nuit, parce que le soleil était couché. Il prit donc une des pierres du lieu, en fit son chevet, et se coucha en ce lieu-là. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Alors il eut un songe; et voici, une échelle était dressée sur la terre, et son sommet touchait aux cieux; et voici les anges de Dieu montaient et descendaient par elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Et voici, l'Éternel se tenait au-dessus d'elle, et il dit: Je suis l'Éternel, le Dieu d'Abraham, ton père, et le Dieu d'Isaac; la terre sur laquelle tu es couché, je la donnerai à toi et à ta postérité. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Et ta postérité sera comme la poussière de la terre; et tu te répandras à l'Occident et à l'Orient, au Nord et au Midi; et toutes les familles de la terre seront bénies en toi et en ta postérité. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Et voici, je suis avec toi, et je te garderai partout où tu iras; et je te ramènerai en ce pays; car je ne t'abandonnerai point, que je n'aie fait ce que je t'ai dit. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Et Jacob s'éveilla de son sommeil, et dit: Certainement, l'Éternel est en ce lieu-ci, et je n'en savais rien! ");
INSERT INTO fra_fob_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Et il eut peur, et dit: Que ce lieu est redoutable! C'est ici la maison de Dieu, et c'est ici la porte des cieux! ");
INSERT INTO fra_fob_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Et Jacob se leva de bon matin, et prit la pierre dont il avait fait son chevet, et la dressa en monument, et il versa de l'huile sur son sommet. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Et il appela ce lieu-là Béthel (maison de Dieu), tandis qu'auparavant la ville s'appelait Luz. ");
INSERT INTO fra_fob_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Et Jacob fit un vœu, en disant: Si Dieu est avec moi, et me garde dans ce voyage que je fais, et me donne du pain pour manger, et des habits pour me vêtir, ");
INSERT INTO fra_fob_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Et que je retourne en paix à la maison de mon père, l'Éternel sera mon Dieu; ");
INSERT INTO fra_fob_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Et cette pierre, que j'ai dressée en monument, sera la maison de Dieu; et tout ce que tu m'accorderas, je t'en donnerai fidèlement la dîme. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Puis Jacob se mit en chemin, et s'en alla au pays des Orientaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Et il regarda; et voici, il vit un puits dans les champs, et là même trois troupeaux de brebis couchés auprès; car on y abreuvait les troupeaux. Et la pierre qui couvrait l'ouverture du puits était grande. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tous les troupeaux se rassemblaient là; alors on roulait la pierre de dessus l'ouverture du puits, et on abreuvait les troupeaux; ensuite on remettait la pierre à sa place, sur l'ouverture du puits. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Et Jacob dit aux bergers: Mes frères, d'où êtes-vous? Et ils répondirent: Nous sommes de Charan. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Et il leur dit: Connaissez-vous Laban, fils de Nachor? Et ils répondirent: Nous le connaissons. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Il leur dit: Se porte-t-il bien? Ils lui répondirent: Il se porte bien; et voici Rachel, sa fille, qui vient avec le troupeau. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Et il dit: Voici, il est encore grand jour; il n'est pas temps de rassembler le bétail; abreuvez les brebis, et allez les paître. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ils répondirent: Nous ne pouvons pas, jusqu'à ce que tous les troupeaux soient rassemblés; alors on roule la pierre de dessus l'ouverture du puits, et nous abreuvons les troupeaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Comme il parlait encore avec eux, Rachel arriva avec le troupeau de son père; car elle était bergère. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Et dès que Jacob vit Rachel, fille de Laban, frère de sa mère, et le troupeau de Laban, frère de sa mère, il s'approcha, roula la pierre de dessus l'ouverture du puits, et abreuva le troupeau de Laban, frère de sa mère. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Et Jacob baisa Rachel; et, élevant la voix, il pleura. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Et Jacob apprit à Rachel qu'il était parent de son père, et qu'il était fils de Rébecca; et elle courut le rapporter à son père. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Et aussitôt que Laban entendit parler de Jacob, fils de sa sœur, il courut au-devant de lui, l'embrassa, et le baisa, et le fit venir dans sa maison; et il raconta à Laban toutes ces choses. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Et Laban lui dit: Certainement, tu es mon os et ma chair; et il demeura avec lui un mois de temps. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Puis Laban dit à Jacob: Parce que tu es mon frère, me serviras-tu pour rien? Dis-moi quel sera ton salaire. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Or, Laban avait deux filles, dont l'aînée s'appelait Léa, et la plus jeune Rachel. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Mais Léa avait les yeux délicats, et Rachel était belle de taille, et belle de visage. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Et Jacob aimait Rachel; et il dit: Je te servirai sept ans pour Rachel, ta plus jeune fille. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Et Laban répondit: Il vaut mieux que je te la donne que si je la donnais à un autre; demeure avec moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Jacob servit donc sept ans pour Rachel; et ils ne lui semblèrent que quelques jours, parce qu'il l'aimait. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Et Jacob dit à Laban: Donne-moi ma femme; car mon temps est accompli, et je viendrai vers elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Alors Laban rassembla tous les gens du lieu, et fit un festin. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Et le soir il prit Léa, sa fille, et l'amena à Jacob, qui vint vers elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Et Laban donna sa servante Zilpa pour servante à Léa, sa fille. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Et le matin, voici, c'était Léa; et Jacob dit à Laban: Qu'est-ce que tu m'as fait? N'est-ce pas pour Rachel que j'ai servi chez toi? Et pourquoi m'as-tu trompé? ");
INSERT INTO fra_fob_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban répondit: On ne fait pas ainsi dans ce lieu, de donner la plus jeune avant l'aînée. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Achève la semaine de celle-ci, et nous te donnerons aussi l'autre, pour le service que tu feras encore chez moi sept autres années. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Et Jacob fit ainsi, il acheva la semaine de celle-ci; puis Laban lui donna pour femme Rachel, sa fille. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Et Laban donna sa servante Bilha pour servante à Rachel, sa fille. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Il vint donc aussi vers Rachel, et il aima Rachel plus que Léa, et il servit chez Laban encore sept autres années. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Et l'Éternel, voyant que Léa était haïe, la rendit féconde; mais Rachel était stérile. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Et Léa conçut et enfanta un fils, qu'elle appela Ruben (voyez un fils! ). Car elle dit: L'Éternel a regardé mon affliction; maintenant mon mari m'aimera. ");
INSERT INTO fra_fob_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Elle conçut encore, et enfanta un fils, et dit: L'Éternel a entendu que j'étais haïe, et il m'a encore donné celui-ci; et elle l'appela Siméon (exaucement). ");
INSERT INTO fra_fob_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Elle conçut encore, et enfanta un fils, et dit: Pour cette fois, mon mari s'attachera à moi; car je lui ai enfanté trois fils; c'est pourquoi on l'appela Lévi (attachement). ");
INSERT INTO fra_fob_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Elle conçut encore et enfanta un fils, et dit: Cette fois je louerai l'Éternel; c'est pourquoi elle l'appela Juda (louange). Et elle cessa d'avoir des enfants. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Alors Rachel, voyant qu'elle ne donnait point d'enfant à Jacob, fut jalouse de sa sœur, et dit à Jacob: Donne-moi des enfants; sinon je suis morte. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Et la colère de Jacob s'enflamma contre Rachel, et il dit: Suis-je à la place de Dieu, qui t'a refusé la fécondité ");
INSERT INTO fra_fob_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Et elle dit: Voici ma servante Bilha; viens vers elle, et elle enfantera sur mes genoux, et j'aurai, moi aussi, des enfants par elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Elle lui donna donc pour femme Bilha, sa servante; et Jacob vint vers elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Et Bilha conçut, et enfanta un fils à Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Et Rachel dit: Dieu m'a rendu justice, et il a aussi exaucé ma voix, et m'a donné un fils; c'est pourquoi elle l'appela Dan (juge). ");
INSERT INTO fra_fob_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Et Bilha, servante de Rachel, conçut encore et enfanta un second fils à Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Et Rachel dit: J'ai soutenu contre ma sœur des luttes de Dieu; j'ai même eu la victoire; et elle lui donna le nom de Nephthali (ma lutte). ");
INSERT INTO fra_fob_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Alors Léa, voyant qu'elle avait cessé d'avoir des enfants, prit Zilpa, sa servante, et la donna pour femme à Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Et Zilpa, servante de Léa, enfanta un fils à Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Et Léa dit: Quel bonheur! Et elle l'appela Gad (bonheur). ");
INSERT INTO fra_fob_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Et Zilpa, servante de Léa, enfanta un second fils à Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Et Léa dit: Que je suis heureuse! car les filles me diront heureuse; et elle l'appela Asser (heureux). ");
INSERT INTO fra_fob_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Et Ruben s'en alla au temps de la moisson des blés, et trouva des mandragores dans les champs, et les apporta à Léa, sa mère. Et Rachel dit à Léa: Donne-moi, je te prie, des mandragores de ton fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Et elle lui répondit: Est-ce peu d'avoir pris mon mari, que tu veuilles encore prendre les mandragores de mon fils? Et Rachel dit: Eh bien! qu'il couche avec toi cette nuit en échange des mandragores de ton fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Et lorsque Jacob revint des champs le soir, Léa alla au-devant de lui, et dit: Tu viendras vers moi; car je t'ai loué pour les mandragores de mon fils; et il coucha avec elle cette nuit-là. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Et Dieu exauça Léa, et elle conçut, et enfanta à Jacob un cinquième fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Et elle dit: Dieu m'a donné mon salaire, pour avoir donné ma servante à mon mari; et elle l'appela Issacar (il y a salaire). ");
INSERT INTO fra_fob_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Et Léa conçut encore, et enfanta un sixième fils à Jacob, ");
INSERT INTO fra_fob_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Et Léa dit: Dieu m'a donné un bon douaire; cette fois mon mari habitera avec moi; car je lui ai enfanté six fils. Et elle l'appela Zabulon (habitation). ");
INSERT INTO fra_fob_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ensuite elle enfanta une fille, et elle l'appela Dina. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Et Dieu se souvint de Rachel, et Dieu l'exauça et la rendit féconde. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Et elle conçut, et enfanta un fils, et dit: Dieu a ôté mon opprobre; ");
INSERT INTO fra_fob_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Et elle l'appela Joseph (il ôte ou il ajoute), en disant: Que l'Éternel m'ajoute encore un autre fils! ");
INSERT INTO fra_fob_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Et lorsque Rachel eut enfanté Joseph, Jacob dit à Laban: Donne-moi mon congé, que je m'en aille en mon lieu, dans mon pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Donne-moi mes femmes et mes enfants, pour lesquels je t'ai servi, et que je m'en aille; car tu sais le service que j'ai fait pour toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Et Laban lui répondit: Puissé-je avoir trouvé grâce à tes yeux; car j'ai deviné que l'Éternel m'a béni à cause de toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Puis il dit: Fixe-moi ton salaire, et je te le donnerai. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Et il lui répondit: Tu sais comment je t'ai servi, et ce qu'est devenu ton bétail avec moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Car ce que tu avais avant moi était peu de chose; mais depuis il s'est fort accru, et l'Éternel t'a béni depuis que j'ai mis le pied chez toi; et maintenant, quand travaillerai-je aussi pour ma maison? ");
INSERT INTO fra_fob_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Et Laban lui dit: Que te donnerai-je? Et Jacob répondit: Tu ne me donneras rien. Je paîtrai encore tes troupeaux, et je les garderai, si tu fais ceci pour moi: ");
INSERT INTO fra_fob_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Je passerai aujourd'hui parmi tous tes troupeaux; ôtes-en toute bête picotée et tachetée, et toute bête noire parmi les agneaux, et ce qui est tacheté et picoté parmi les chèvres; et ce sera mon salaire. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Et ma justice me rendra témoignage à l'avenir devant toi, quand tu viendras reconnaître mon salaire. Tout ce qui ne sera point picoté ou tacheté parmi les chèvres, et noir parmi les agneaux, aura été volé, s'il est trouvé chez moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Alors Laban dit: Eh bien! qu'il en soit comme tu dis. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Et le jour même il sépara les boucs rayés et tachetés, et toutes les chèvres picotées et tachetées, tout ce qui avait du blanc, et tout ce qui était noir parmi les agneaux; et il les confia à ses fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Et il mit l'espace de trois jours de chemin entre lui et Jacob. Et Jacob paissait le reste des troupeaux de Laban. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Alors Jacob prit des branches vertes de peuplier, d'amandier et de platane, et y fit des raies blanches, en découvrant le blanc qui était aux branches. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Et il mit les branches qu'il avait pelées, dans les auges, dans les abreuvoirs où les brebis venaient boire, en face des brebis; et elles entraient en chaleur, quand elles venaient boire. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Les brebis entraient donc en chaleur à la vue des branches, et elles faisaient des agneaux rayés, picotés et tachetés. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Et Jacob partageait les agneaux, et mettait les brebis du troupeau de Laban en face de ce qui était rayé, et de tout ce qui était noir; et il mit ses troupeaux à part, et ne les mit point auprès des troupeaux de Laban. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Et il arrivait que toutes les fois que les brebis vigoureuses entraient en chaleur, Jacob mettait les branches sous les yeux du troupeau dans les auges, afin qu'elles entrassent en chaleur auprès des branches. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Mais quand les brebis étaient chétives, il ne les mettait point. En sorte que les agneaux chétifs étaient pour Laban, et les vigoureux pour Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Et cet homme devint extrêmement riche, et il eut de nombreux troupeaux, des servantes et des serviteurs, des chameaux et des ânes. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Or Jacob entendit les discours des enfants de Laban, qui disaient: Jacob a pris tout ce qui appartenait à notre père; et c'est de ce qui était à notre père, qu'il s'est acquis toute cette richesse. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Et Jacob remarqua le visage de Laban; et voici, il n'était plus à son égard comme auparavant. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Et l'Éternel dit à Jacob: Retourne au pays de tes pères, et vers ta parenté, et je serai avec toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Alors Jacob envoya dire à Rachel et à Léa, de venir aux champs vers son troupeau. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Et il leur dit: Je vois que le visage de votre père n'est plus envers moi comme auparavant; mais le Dieu de mon père a été avec moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Et vous savez vous-mêmes que j'ai servi votre père de toutes mes forces. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Et votre père s'est moqué de moi, et a changé dix fois mon salaire; mais Dieu ne lui a point permis de me faire du mal. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Quand il disait ainsi: Les picotés seront ton salaire, toutes les brebis faisaient des agneaux picotés. Et s'il disait ainsi: Les rayés seront ton salaire, toutes les brebis faisaient des agneaux rayés. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Dieu a donc pris le bétail de votre père, et me l'a donné. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Car il arriva, au temps où les brebis entrent en chaleur, que je levai les yeux et vis en songe que les béliers qui couvraient les brebis étaient rayés, picotés et marquetés. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Et l'ange de Dieu me dit en songe: Jacob! Et je répondis: Me voici! ");
INSERT INTO fra_fob_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Et il dit: Lève les yeux, et regarde: tous les béliers, qui couvrent les brebis, sont rayés, picotés et marquetés. Car j'ai vu ce que te fait Laban. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Je suis le Dieu de Béthel, où tu oignis un monument, où tu me fis un vœu. Maintenant, lève-toi, sors de ce pays, et retourne au pays de ta parenté. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Alors Rachel et Léa répondirent et lui dirent: Avons-nous encore une part ou un héritage dans la maison de notre père? ");
INSERT INTO fra_fob_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ne nous a-t-il pas traitées comme des étrangères, puisqu'il nous a vendues, et qu'il a même mangé notre argent? ");
INSERT INTO fra_fob_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Car toutes les richesses que Dieu a ôtées à notre père, sont à nous et à nos enfants. Maintenant donc, fais tout ce que Dieu t'a dit. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Alors Jacob se leva, et fit monter ses enfants et ses femmes sur les chameaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Et il emmena tout son bétail et tout le bien qu'il avait acquis, son bétail particulier, qu'il avait acquis à Paddan-Aram, pour venir vers Isaac, son père, au pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Or Laban était allé tondre ses brebis; et Rachel déroba les théraphim de son père. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Et Jacob trompa Laban l'Araméen, en ne lui disant point qu'il voulait s'enfuir. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Il s'enfuit donc, lui et tout ce qui lui appartenait; et il se leva, et passa le fleuve, et s'avança vers la montagne de Galaad. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Et le troisième jour on rapporta à Laban que Jacob s'était enfui. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Alors il prit ses frères avec lui, et le poursuivit sept journées de marche, et le rejoignit à la montagne de Galaad. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mais Dieu vint vers Laban, l'Araméen, dans un songe de la nuit, et lui dit: Garde-toi de rien dire à Jacob, ni en bien, ni en mal. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban atteignit donc Jacob. Et Jacob avait planté sa tente sur la montagne. Et Laban tendit la sienne avec ses frères sur la montagne de Galaad. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Et Laban dit à Jacob: Qu'as-tu fait? Tu m'as trompé, et tu as emmené mes filles comme des prisonnières de guerre. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Pourquoi t'es-tu enfui secrètement, et m'as-tu trompé, et ne m'en as-tu pas donné avis? et je t'eusse reconduit avec joie et avec des chants, au son du tambourin et de la harpe. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Et tu ne m'as pas laissé baiser mes fils et mes filles! Tu as agi follement. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","J'ai en main le pouvoir de vous faire du mal; mais le Dieu de votre père m'a parlé la nuit passée, en disant: Garde-toi de rien dire à Jacob, ni en bien, ni en mal. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Et maintenant, tu es parti, parce que tu languissais après la maison de ton père; mais pourquoi as-tu dérobé mes dieux? ");
INSERT INTO fra_fob_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Et Jacob répondit, et dit à Laban: C'est que je craignais en moi-même que tu ne me ravisses tes filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mais celui chez qui tu trouveras tes dieux, ne vivra point; en présence de nos frères, examine ce qui est chez moi, et prends-les. Or Jacob ignorait que Rachel les eût dérobés. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Alors Laban entra dans la tente de Jacob, et dans la tente de Léa, et dans la tente des deux servantes, et il ne les trouva point. Puis il sortit de la tente de Léa, et entra dans la tente de Rachel. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Mais Rachel avait pris les théraphim, les avait mis dans le bât du chameau, et s'était assise dessus. Et Laban fouilla toute la tente, et ne les trouva point. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Et elle dit à son père: Que mon seigneur ne se fâche point de ce que je ne puis me lever devant lui; car j'ai ce que les femmes ont coutume d'avoir. Et il chercha; mais il ne trouva point les théraphim. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Alors Jacob se mit en colère, et querella Laban; et Jacob prit la parole et dit: Quel est mon crime? Quel est mon péché, pour que tu m'aies poursuivi avec tant d'ardeur? ");
INSERT INTO fra_fob_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Pour que tu aies fouillé tous mes bagages? Qu'as-tu trouvé de tous les objets de ta maison? Mets-le ici devant mes frères et tes frères, et qu'ils soient juges entre nous deux. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Voici vingt ans que j'ai été avec toi; tes brebis et tes chèvres n'ont point avorté; et je n'ai point mangé les béliers de tes troupeaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Je ne t'ai point rapporté de bêtes déchirées; j'en ai moi-même subi la perte. Tu me réclamais ce qui avait été dérobé de jour, et ce qui avait été dérobé de nuit. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Le hâle me consumait pendant le jour, et le froid pendant la nuit; et le sommeil fuyait de mes yeux. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Voici vingt ans que je suis dans ta maison; je t'ai servi quatorze ans pour tes deux filles, et six ans pour tes troupeaux, et tu as changé dix fois mon salaire. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Si le Dieu de mon père, le Dieu d'Abraham, et Celui que craint Isaac, n'eût été pour moi, sans doute tu m'eusses maintenant renvoyé à vide. Dieu a regardé mon affliction et le travail de mes mains; et il a rendu justice la nuit passée. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Et Laban répondit et dit à Jacob: Ces filles sont mes filles, ces enfants sont mes enfants, et ces troupeaux sont mes troupeaux, et tout ce que tu vois est à moi. Et que ferais-je aujourd'hui à mes filles, ou aux enfants qu'elles ont enfantés? ");
INSERT INTO fra_fob_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Maintenant donc, viens, traitons ensemble une alliance, et qu'elle serve de témoignage entre moi et toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Et Jacob prit une pierre, et la dressa en monument. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Et Jacob dit à ses frères: Amassez des pierres. Et ils prirent des pierres, et en firent un monceau, et ils mangèrent là sur le monceau. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Et Laban l'appela Iegar Sahadutha; et Jacob l'appela Galed (monceau du témoignage). ");
INSERT INTO fra_fob_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Et Laban dit: Ce monceau est témoin entre moi et toi aujourd'hui. C'est pourquoi on l'appela Galed, ");
INSERT INTO fra_fob_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Et aussi Mitspa (poste d'observation), parce que Laban dit: Que l'Éternel veille sur moi et sur toi, quand nous nous serons retirés l'un d'avec l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Si tu maltraites mes filles, et si tu prends d'autres femmes que mes filles, ce n'est pas un homme qui sera témoin entre nous. Vois! c'est Dieu qui sera témoin entre moi et toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Et Laban dit à Jacob: Voici ce monceau de pierres; et voici le monument que j'ai dressé entre moi et toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ce monceau est témoin, et ce monument est témoin, que je ne passerai point ce monceau, en allant vers toi, et que tu ne passeras point ce monceau et ce monument, en venant vers moi, pour nous nuire l'un à l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Que le Dieu d'Abraham et le Dieu de Nachor, le Dieu de leur père, juge entre nous! Et Jacob jura par Celui que craignait Isaac, son père. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Et Jacob offrit un sacrifice sur la montagne; et il invita ses frères à manger le pain. Ils mangèrent donc le pain, et passèrent la nuit sur la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Et Laban se leva de bon matin, baisa ses fils et ses filles, et les bénit, et s'en alla. Ainsi Laban retourna chez lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Et Jacob continua son chemin, et des anges de Dieu le rencontrèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Et Jacob dit, quand il les eut vus: C'est le camp de Dieu! Et il appela ce lieu-là, Mahanaïm (les deux camps). ");
INSERT INTO fra_fob_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Et Jacob envoya des messagers devant lui vers Ésaü, son frère, au pays de Séir, aux champs d'Édom. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Et il leur commanda en disant: Vous parlerez ainsi à Ésaü mon seigneur: Ainsi a dit ton serviteur Jacob: J'ai séjourné chez Laban, et j'y ai demeuré jusqu'à présent. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Et j'ai des bœufs et des ânes, des brebis, des serviteurs et des servantes; et j'envoie l'annoncer à mon seigneur, afin de trouver grâce devant tes yeux. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Et les messagers revinrent auprès de Jacob, en disant: Nous sommes allés vers ton frère Ésaü; et il marche aussi à ta rencontre, avec quatre cents hommes. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Alors Jacob fut très effrayé et rempli d'angoisse; et il partagea le peuple qui était avec lui, et les brebis, et les bœufs, et les chameaux, en deux camps, et il dit: ");
INSERT INTO fra_fob_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Si Ésaü attaque l'un des camps et le frappe, le camp qui restera, pourra échapper. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Puis Jacob dit: Dieu de mon père Abraham, et Dieu de mon père Isaac! Éternel, qui m'as dit: Retourne en ton pays, et vers ta parenté, et je te ferai du bien; ");
INSERT INTO fra_fob_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Je suis trop petit pour toutes les faveurs et pour toute la fidélité dont tu as usé envers ton serviteur; car j'ai passé le Jourdain avec mon bâton, et maintenant je forme deux camps. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Délivre-moi, je te prie, de la main de mon frère, de la main d'Ésaü; car je crains qu'il ne vienne, et qu'il ne me frappe, et la mère avec les enfants. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Cependant, tu as dit: Certaine-ment, je te ferai du bien, et je ferai devenir ta postérité comme le sable de la mer, qu'on ne saurait compter à cause de son grand nombre. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Et il passa la nuit en ce lieu-là, et il prit de ce qui lui vint en la main, pour en faire un présent à Ésaü, son frère ");
INSERT INTO fra_fob_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Deux cents chèvres et vingt boucs, deux cents brebis et vingt béliers, ");
INSERT INTO fra_fob_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Trente chamelles qui allaitaient, avec leurs petits, quarante vaches et dix taureaux, vingt ânesses et dix jeunes ânes. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Et il mit entre les mains de ses serviteurs chaque troupeau à part, et dit à ses serviteurs: Passez devant moi, et mettez de la distance entre un troupeau et l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Et il donna ordre au premier, en disant: Quand Ésaü mon frère, te rencontrera, et te demandera: A qui es-tu, où vas-tu, et à qui sont ces bêtes devant toi? ");
INSERT INTO fra_fob_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Tu diras: A ton serviteur Jacob; c'est un présent qu'il envoie à Ésaü mon seigneur; et le voici qui vient lui-même après nous. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Il donna le même ordre au second, et au troisième, et à tous ceux qui allaient après les troupeaux, en disant: Vous tiendrez ce langage à Ésaü, quand vous le rencontrerez; ");
INSERT INTO fra_fob_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Et vous direz: Voici même ton serviteur Jacob qui vient derrière nous. Car il se disait: Je l'apaiserai par ce présent qui va devant moi, et après cela, je verrai sa face; peut-être qu'il m'accueillera favorablement. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Le présent marcha donc devant lui; mais lui, il passa cette nuit-là dans le camp. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Et il se leva cette nuit, prit ses deux femmes, et ses deux servantes, et ses onze enfants, et passa le gué de Jabbok. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Il les prit donc, et leur fit passer le torrent. Il fit aussi passer ce qu'il avait. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Or Jacob demeura seul; et un homme lutta avec lui, jusqu'au lever de l'aurore. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Et quand cet homme vit qu'il ne pouvait le vaincre, il toucha l'emboîture de sa hanche; et l'emboîture de la hanche de Jacob fut démise, pendant qu'il luttait avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Et cet homme lui dit: Laisse-moi aller, car l'aurore est levée. Mais il dit: Je ne te laisserai point aller, que tu ne m'aies béni. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Et il lui dit: Quel est ton nom? et il répondit: Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Alors il dit: Ton nom ne sera plus Jacob, mais Israël (qui lutte avec Dieu); car tu as lutté avec Dieu et avec les hommes, et tu as vaincu. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Et Jacob l'interrogea, et dit: Apprends-moi ton nom, je te prie. Et il répondit: Pourquoi demandes-tu mon nom? Et il le bénit là. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Et Jacob nomma le lieu, Péniel (face de Dieu); car, dit-il, j'ai vu Dieu face à face et mon âme a été délivrée. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Et le soleil se leva pour lui, dés qu'il eut passé Péniel; et il boitait de la hanche. ");
INSERT INTO fra_fob_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","C'est pourquoi, jusqu'à ce jour, les enfants d'Israël ne mangent point le muscle de la cuisse, qui est à l'emboîture de la hanche, parce que cet homme toucha l'emboîture de la hanche de Jacob, au muscle de la cuisse. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Et Jacob leva les yeux et regarda. Et voici, Ésaü venait, et quatre cents hommes avec lui. Alors il répartit les enfants entre Léa, Rachel, et les deux servantes. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Et il plaça en tête les servantes et leurs enfants; Léa et ses enfants ensuite, et Rachel et Joseph au dernier rang. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Quant à lui, il passa devant eux, et se prosterna en terre sept fois, jusqu'à ce qu'il se fût approché de son frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Mais Ésaü courut au-devant de lui, et l'embrassa, et se jeta à son cou, et le baisa, et ils pleurèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Puis il leva les yeux, et vit les femmes et les enfants, et il dit: Qui as-tu là? Et il répondit: Ce sont les enfants que Dieu a accordés à ton serviteur. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Et les servantes s'approchèrent, elles et leurs enfants, et se prosternèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Léa aussi s'approcha, et ses enfants, et ils se prosternèrent. Et ensuite Joseph et Rachel s'approchèrent, et ils se prosternèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Et Ésaü dit: Que veux-tu faire avec tout ce camp que j'ai rencontré? Et il répondit: C'est pour trouver grâce aux yeux de mon seigneur. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Et Ésaü dit: Je suis dans l'abondance, mon frère. Garde ce qui est à toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Et Jacob répondit: Non, je te prie, si j'ai trouvé grâce à tes yeux, tu accepteras mon offrande de ma main, puisque j'ai vu ta face comme on voit la face de Dieu, et que tu m'as accueilli favorablement. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Accepte, je te prie, mon présent qui t'a été offert; car Dieu m'a comblé de grâces, et j'ai de tout. Il le pressa donc tant, qu'il l'accepta. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Et Ésaü dit: Partons, et marchons; et je marcherai devant toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Et Jacob lui dit: Mon seigneur sait que les enfants sont délicats; et je suis chargé de brebis et de vaches qui allaitent; si on les presse un seul jour, tout le troupeau mourra. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Que mon seigneur passe, je te prie, devant son serviteur; et moi, je m'avancerai tout doucement, au pas du bétail qui est devant moi, et au pas des enfants, jusqu'à ce que j'arrive chez mon seigneur, à Séir. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Et Ésaü dit: Je te prie, que je fasse demeurer avec toi quelques-uns des gens qui sont avec moi. Et il répondit: Pourquoi cela? Que je trouve grâce aux yeux de mon seigneur! ");
INSERT INTO fra_fob_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Et Ésaü retourna ce jour-là par son chemin, à Séir. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Mais Jacob partit pour Succoth; et il bâtit une maison pour lui, et fit des cabanes pour son bétail; c'est pourquoi, il nomma le lieu Succoth (cabanes). ");
INSERT INTO fra_fob_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Et Jacob, venant de Paddan-Aram, arriva sain et sauf à la ville de Sichem, au pays de Canaan; et il campa devant la ville. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Et il acheta, de la main des fils de Hémor, père de Sichem, pour cent pièces d'argent, la portion de champ où il avait dressé sa tente. ");
INSERT INTO fra_fob_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Et il dressa là un autel, et il l'appela El-Elohé-Israël (Dieu est le Dieu d'Israël). ");
INSERT INTO fra_fob_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Or, Dina, la fille que Léa avait enfantée à Jacob, sortit pour voir les filles du pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Et Sichem, fils de Hémor, le Hévien, prince du pays, la vit, et l'enleva, et coucha avec elle, et lui fit violence. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Et son âme s'attacha à Dina, fille de Jacob, et il aima la jeune fille, et parla au cœur de la jeune fille. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Et Sichem parla à Hémor, son père, et lui dit: Donne-moi cette jeune fille pour femme. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Or, Jacob apprit qu'il avait déshonoré Dina sa fille; mais ses fils étaient aux champs avec son bétail, et Jacob se tut jusqu'à leur retour. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Cependant Hémor, père de Sichem, sortit vers Jacob pour lui parler. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Et les fils de Jacob revinrent des champs dès qu'ils apprirent la chose; et ces hommes furent affligés et fort irrités de l'infamie que Sichem avait commise en Israël, en couchant avec la fille de Jacob, ce qui ne devait point se faire. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Et Hémor leur parla, en disant: L'âme de Sichem, mon fils, s'est attachée à votre fille; donnez-la-lui, je vous prie, pour femme. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Et alliez-vous avec nous; vous nous donnerez vos filles, et vous prendrez nos filles pour vous. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Et vous habiterez avec nous; et le pays sera à votre disposition: demeurez-y et y trafiquez, et acquérez-y des propriétés. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Et Sichem dit au père et aux frères de la jeune fille: Que je trouve grâce à vos yeux; et je donnerai ce que vous me direz. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Imposez-moi un grand douaire, et de grands présents, et je les donnerai comme vous me direz; mais donnez-moi la jeune fille pour femme. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Alors les fils de Jacob répondirent avec ruse à Sichem et à Hémor, son père; ils parlèrent ainsi, parce qu'il avait déshonoré Dina leur sœur. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ils leur dirent: C'est une chose que nous ne pouvons faire que de donner notre sœur à un homme incirconcis; car ce nous serait un opprobre. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nous ne consentirons à ce que vous demandez que si vous devenez semblables à nous, en circoncisant tous les mâles parmi vous. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Alors nous vous donnerons nos filles, et nous prendrons vos filles pour nous; et nous habiterons avec vous, et nous ne serons plus qu'un peuple. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mais, si vous ne voulez pas nous écouter et vous circoncire, nous prendrons notre fille, et nous nous en irons. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Et leurs discours plurent à Hémor et à Sichem, fils de Hémor. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Et le jeune homme ne différa point de faire la chose; car la fille de Jacob lui plaisait. Or il était le plus considéré de toute la maison de son père. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hémor et Sichem, son fils, vinrent donc à la porte de leur ville, et parlèrent aux gens de leur ville, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ces gens-ci sont paisibles à notre égard; qu'ils habitent au pays, et qu'ils y trafiquent. Et voici, le pays est assez étendu pour eux; nous prendrons leurs filles pour femmes, et nous leur donnerons nos filles. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mais ils ne consentiront à habiter avec nous, pour n'être qu'un seul peuple, que si tout mâle parmi nous est circoncis, comme ils sont eux-mêmes circoncis. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Leur bétail, et leurs biens, et toutes leurs bêtes, ne seront-ils pas à nous? Accordons-leur seulement cela, et qu'ils demeurent avec nous. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Et tous ceux qui sortaient par la porte de leur ville, obéirent à Hémor et à Sichem son fils, et tout mâle qui sortait par la porte de leur ville, fut circoncis. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Et il arriva au troisième jour, lorsqu'ils étaient souffrants, que deux des fils de Jacob, Siméon et Lévi, frères de Dina, prirent chacun leur épée, se jetèrent sur la ville en sécurité, et tuèrent tous les mâles. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ils passèrent au tranchant de l'épée Hémor et Sichem, son fils; et ils prirent Dina de la maison de Sichem, et ils sortirent. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Les fils de Jacob se jetèrent sur les blessés et pillèrent la ville, parce qu'on avait déshonoré leur sœur. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Et ils prirent leurs troupeaux, leurs bœufs et leurs ânes, ce qui était dans la ville et aux champs; ");
INSERT INTO fra_fob_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Ils emmenèrent et pillèrent tous leurs biens, et tous leurs petits enfants, et leurs femmes, et tout ce qui était dans les maisons. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Alors Jacob dit à Siméon et à Lévi: Vous m'avez troublé, en me mettant en mauvaise odeur parmi les habitants du pays, parmi les Cananéens et les Phéréziens. Et moi, je n'ai qu'un petit nombre d'hommes; ils s'assembleront contre moi, et me frapperont, et je serai détruit, moi et ma maison. ");
INSERT INTO fra_fob_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Et ils répondirent: Doit-on traiter notre sœur comme une prostituée? ");
INSERT INTO fra_fob_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Et Dieu dit à Jacob: Lève-toi, monte à Béthel, et demeures-y, et fais-y un autel au Dieu qui t'apparut lorsque tu fuyais de devant Ésaü, ton frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Alors Jacob dit à sa famille, et à tous ceux qui étaient avec lui: Otez les dieux étrangers qui sont au milieu de vous, et purifiez-vous, et changez de vêtements; ");
INSERT INTO fra_fob_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Et levons-nous, et montons à Béthel, et j'y ferai un autel au Dieu qui m'a répondu au jour de ma détresse, et qui a été avec moi pendant mon voyage. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Alors ils donnèrent à Jacob tous les dieux étrangers qu'ils avaient, et les anneaux qui étaient à leurs oreilles; et Jacob les enterra sous le chêne qui était près de Sichem. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ensuite ils partirent. Et Dieu frappa de terreur les villes qui étaient autour d'eux; et ils ne poursuivirent point les fils de Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Et Jacob vint à Luz, qui est au pays de Canaan (c'est Béthel), lui et tout le peuple qui était avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Et il y bâtit un autel, et il appela ce lieu: El-Béthel (Dieu de Béthel); car c'est là que Dieu lui était apparu, lorsqu'il fuyait de devant son frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Et Débora, nourrice de Rébecca, mourut; et elle fut ensevelie au-dessous de Béthel, sous le chêne, qu'on appela Allon-Bacuth (chêne des pleurs). ");
INSERT INTO fra_fob_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Et Dieu apparut encore à Jacob, lorsqu'il venait de Paddan-Aram; et il le bénit. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Et Dieu lui dit: Ton nom est Jacob; tu ne seras plus appelé Jacob, mais Israël sera ton nom. Et il lui donna le nom d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Et Dieu lui dit: Je suis le Dieu Tout-Puissant: augmente et multiplie. Une nation, même une multitude de nations naîtront de toi; des rois sortiront de tes reins. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Et je te donnerai le pays que j'ai donné à Abraham et à Isaac, et je donnerai ce pays à ta postérité après toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Et Dieu remonta d'avec lui, du lieu où il lui avait parlé. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Et Jacob dressa un monument au lieu où il lui avait parlé, un monument de pierre, et il fit dessus une aspersion, et y versa de l'huile. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Et Jacob appela le lieu où Dieu lui avait parlé, Béthel (maison de Dieu). ");
INSERT INTO fra_fob_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Et ils partirent de Béthel, et il y avait encore un espace de pays pour arriver à Éphrath, lorsque Rachel enfanta; et elle eut beaucoup de peine à accoucher. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Et comme elle avait beaucoup de peine à accoucher, la sage-femme lui dit: Ne crains point, car tu as encore un fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Et comme elle rendait l'âme, car elle mourut, elle le nomma Bénoni (fils de ma douleur); mais son père l'appela Benjamin (fils de la droite). ");
INSERT INTO fra_fob_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel mourut donc, et fut ensevelie au chemin d'Éphrath, qui est Bethléhem. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Et Jacob dressa un monument sur sa tombe; c'est le monument de la tombe de Rachel, qui subsiste encore aujourd'hui. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Puis Israël partit, et il dressa sa tente au delà de Migdal-Eder (tour du troupeau). ");
INSERT INTO fra_fob_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Et il arriva, pendant qu'Israël demeurait dans ce pays-là, que Ruben vint et coucha avec Bilha, concubine de son père; et Israël l'apprit. Or, Jacob avait douze fils. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Les fils de Léa: Ruben, premier-né de Jacob, Siméon, Lévi, Juda, Issacar et Zabulon. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Les fils de Rachel: Joseph et Benjamin. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Les fils de Bilha, servante de Rachel: Dan et Nephthali. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Et les fils de Zilpa, servante de Léa: Gad et Asser. Ce sont là les fils de Jacob, qui lui naquirent à Paddan-Aram. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Et Jacob vint vers Isaac son père, à Mamré, à Kirjath-Arba, qui est Hébron, où avaient séjourné Abraham et Isaac. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Et les jours d'Isaac furent de cent quatre-vingts ans. ");
INSERT INTO fra_fob_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Et Isaac expira et mourut, et fut recueilli vers ses peuples, âgé et rassasié de jours; et Ésaü et Jacob, ses fils, l'ensevelirent. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Or, voici les descendants d'Ésaü, qui est Édom. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ésaü prit ses femmes parmi les filles de Canaan: Ada, fille d'Élon, le Héthien, et Oholibama, fille d'Ana, fille de Tsibeon, le Hévien. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Il prit aussi Basmath, fille d'Ismaël, sœur de Nébajoth. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada enfanta à Ésaü Éliphaz, et Basmath enfanta Réuël. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Et Oholibama enfanta Jéush, Jaelam et Korah. Voilà les fils d'Ésaü, qui lui naquirent au pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Et Ésaü prit ses femmes, et ses fils et ses filles, et toutes les personnes de sa maison, et ses troupeaux, et tout son bétail, et tout le bien qu'il avait acquis au pays de Canaan; et il s'en alla dans un autre pays, loin de Jacob, son frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Car leurs biens étaient trop grands pour qu'ils pussent demeurer ensemble, et le pays où ils séjournaient ne pouvait pas les contenir, à cause de leurs troupeaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Et Ésaü habita sur la montagne de Séir. Ésaü est Édom. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Et voici les descendants d'Ésaü, père des Iduméens, sur la montagne de Séir. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Voici les noms des fils d'Ésaü: Éliphaz, fils d'Ada, femme d'Ésaü; Réuël, fils de Basmath, femme d'Ésaü. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Et les fils d'Éliphaz furent Théman, Omar, Tsépho et Gaetham et Kénaz. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Et Thimna fut concubine d'Éliphaz, fils d'Ésaü, et enfanta Amalek à Éliphaz. Voilà les fils d'Ada, femme d'Ésaü. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Et voici les fils de Réuël: Nahath et Zérach, Shamma et Mizza. Ce furent là les fils de Basmath, femme d'Ésaü. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Et ceux-ci furent les fils d'Oholibama, fille d'Ana, fille de Tsibeon, et femme d'Ésaü: elle enfanta à Ésaü Jéush, Jaelam et Korah. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Voici les chefs des fils d'Ésaü: Fils d'Éliphaz, premier-né d'Ésaü: le chef Théman, le chef Omar, le chef Tsépho, le chef Kénaz, ");
INSERT INTO fra_fob_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Le chef Korah, le chef Gaetham, le chef Amalek. Voilà les chefs issus d'Éliphaz au pays d'Édom; voilà les fils d'Ada. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Et voici les fils de Réuël, fils d'Ésaü: le chef Nahath, le chef Zérach, le chef Shamma, le chef Mizza. Voilà les chefs issus de Réuël au pays d'Édom, voilà les fils de Basmath, femme d'Ésaü. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Et voici les fils d'Oholibama, femme d'Ésaü: le chef Jéush, le chef Jaelam, le chef Korah. Voilà les chefs issus d'Oholibama, fille d'Ana, femme d'Ésaü. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Voilà les fils d'Ésaü, qui est Édom, et voilà leurs chefs. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Voici les fils de Séir, le Horien, qui habitaient le pays: Lothan, Shobal, Tsibeon, Ana, Dishon, Etser et Dishan. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Voilà les chefs des Horiens, fils de Séir, au pays d'Édom. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Et les fils de Lothan furent: Hori et Héman; et Thimna était sœur de Lothan. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Et voici les fils de Shobal: Alvan, Manahath, Ébal, Shépho et Onam. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Et voici les fils de Tsibeon: Ajja et Ana. C'est Ana qui trouva les sources chaudes dans le désert, pendant qu'il paissait les ânes de Tsibeon, son père. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Et voici les enfants d'Ana: Dishon et Oholibama, fille d'Ana. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Et voici les fils de Dishon: Hemdan, Eshban, Jithran et Kéran. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Voici les fils d'Etser: Bilhan, Zaavan et Akan. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Voici les fils de Dishan: Uts et Aran. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Voici les chefs des Horiens: le chef Lothan, le chef Shobal, le chef Tsibeon, le chef Ana, ");
INSERT INTO fra_fob_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Le chef Dishon, le chef Etser, le chef Dishan. Voilà les chefs des Horiens, les chefs qu'ils eurent dans le pays de Séir. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Et voici les rois qui régnèrent au pays d'Édom, avant qu'un roi régnât sur les enfants d'Israël: ");
INSERT INTO fra_fob_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Béla, fils de Béor, régna en Édom, et le nom de sa ville était Dinhaba. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Et Béla mourut; et Jobab, fils de Zérach, de Botsra, régna à sa place. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Et Jobab mourut; et Husham, du pays des Thémanites, régna à sa place. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Et Husham mourut; et Hadad, fils de Bedad, régna à sa place; il défit Madian, aux champs de Moab; et le nom de sa ville était Avith. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Et Hadad mourut; et Samla, de Masréka, régna à sa place. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Et Samla mourut; et Saül, de Rehoboth, sur le fleuve, régna à sa place. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Et Saül mourut; et Baal-Hanan, fils d'Acbor, régna à sa place. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Et Baal-Hanan, fils d'Acbor, mourut, et Hadar régna à sa place; et le nom de sa ville était Paü, et le nom de sa femme Méhétabeel, fille de Matred, fille de Mézahab. ");
INSERT INTO fra_fob_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Et voici les noms des chefs d'Ésaü, selon leurs familles, selon leurs lieux, par leurs noms: le chef Thimna, le chef Alva, le chef Jetheth, ");
INSERT INTO fra_fob_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Le chef Oholibama, le chef Éla, le chef Pinon, ");
INSERT INTO fra_fob_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Le chef Kénaz, le chef Théman, le chef Mibtsar, ");
INSERT INTO fra_fob_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Le chef Magdiel, le chef Iram. Voilà les chefs d'Édom, selon leurs demeures au pays de leur possession. C'est là Ésaü, le père des Iduméens. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Or, Jacob demeura au pays où son père avait séjourné, au pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Voici l'histoire des descendants de Jacob. Joseph, âgé de dix-sept ans, paissait les troupeaux avec ses frères; et il était jeune berger auprès des fils de Bilha, et auprès des fils de Zilpa, femmes de son père. Et Joseph rapporta à leur père leurs mauvais discours. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Or, Israël aimait Joseph plus que tous ses autres fils, car c'était le fils de sa vieillesse; et il lui fit une robe de diverses couleurs. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Mais ses frères, voyant que leur père l'aimait plus que tous ses frères, le haïssaient, et ne pouvaient lui parler sans aigreur. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Et Joseph eut un songe, et le fit connaître à ses frères, et ils le haïrent encore plus. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Il leur dit donc: Écoutez, je vous prie, ce songe que j'ai eu. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Voici, nous étions à lier des gerbes au milieu des champs. Et voici, ma gerbe se leva et se tint debout. Et voici, vos gerbes l'environnèrent et se prosternèrent devant ma gerbe. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Alors ses frères lui dirent: Régnerais-tu donc sur nous? ou nous gouvernerais-tu? Et ils le haïrent encore plus pour ses songes et pour ses paroles. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Il eut encore un autre songe et le raconta à ses frères, et il dit: Voici, j'ai eu encore un songe. Et voici, le soleil, et la lune, et onze étoiles se prosternaient devant moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Et il le raconta à son père, et à ses frères; mais son père le reprit, et lui dit: Que veut dire ce songe que tu as eu? Faudra-t-il que nous venions, moi et ta mère et tes frères, nous prosterner en terre devant toi? ");
INSERT INTO fra_fob_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Et ses frères furent jaloux de lui; mais son père retint ces choses. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Or, ses frères allèrent paître les troupeaux de leur père à Sichem. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Et Israël dit à Joseph: Tes frères ne paissent-ils pas les troupeaux à Sichem? Viens, que je t'envoie vers eux. Et il lui répondit: Me voici. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Et il lui dit: Va donc; vois comment vont tes frères et comment vont les troupeaux, et rapporte-m'en des nouvelles. Il l'envoya ainsi de la vallée d'Hébron, et il vint à Sichem. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Et un homme le trouva errant par les champs; et cet homme l'interrogea, et lui dit: Que cherches-tu? ");
INSERT INTO fra_fob_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Et il répondit: Je cherche mes frères; enseigne-moi, je te prie, où ils paissent. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Et l'homme dit: Ils sont partis d'ici; car je les ai entendus dire: Allons à Dothaïn. Joseph alla donc après ses frères, et il les trouva à Dothaïn. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Et ils le virent de loin. Et avant qu'il fût près d'eux, ils complotèrent contre lui de le mettre à mort. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Et ils se dirent l'un à l'autre: Voici ce songeur qui vient. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Maintenant donc, venez, tuons-le, et le jetons dans quelque fosse, et nous dirons qu'une bête féroce l'a dévoré; et nous verrons ce que deviendront ses songes. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Mais Ruben entendit cela, et le délivra de leurs mains, et dit: Ne lui ôtons point la vie. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Puis Ruben leur dit: Ne répandez point le sang; jetez-le dans cette fosse, qui est au désert, et ne mettez point la main sur lui. C'était pour le délivrer de leurs mains, pour le rendre à son père. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Et dès que Joseph fut arrivé auprès de ses frères, ils le dépouillèrent de sa robe, de la robe de diverses couleurs qui était sur lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Et ils le saisirent, et le jetèrent dans la fosse. Or la fosse était vide; il n'y avait point d'eau. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ensuite ils s'assirent pour manger le pain. Et, levant les yeux, ils regardèrent, et voici une caravane d'Ismaélites qui venait de Galaad; et leurs chameaux, chargés d'aromates, de baume, et de myrrhe, allaient les porter en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Et Juda dit à ses frères: A quoi nous servira de tuer notre frère et de cacher son sang? ");
INSERT INTO fra_fob_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Venez, et vendons-le aux Ismaélites, et que notre main ne soit point sur lui; car il est notre frère, notre chair. Et ses frères lui obéirent. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Et comme les marchands Madianites passaient, ils tirèrent et firent remonter Joseph de la fosse; et ils vendirent Joseph pour vingt pièces d'argent aux Ismaélites, qui l'emmenèrent en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Et Ruben retourna à la fosse, et voici, Joseph n'était plus dans la fosse. Alors il déchira ses vêtements; ");
INSERT INTO fra_fob_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Et il retourna vers ses frères, et dit: L'enfant n'y est plus; et moi, moi, où irai-je? ");
INSERT INTO fra_fob_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Et ils prirent la robe de Joseph, tuèrent un bouc, et trempèrent la robe dans le sang. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ensuite ils envoyèrent et firent parvenir à leur père la robe de diverses couleurs, en lui faisant dire: Nous avons trouvé ceci; reconnais si c'est la robe de ton fils, ou non. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Et il la reconnut, et dit: C'est la robe de mon fils; une bête féroce l'a dévoré; certainement Joseph a été mis en pièces. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Et Jacob déchira ses vêtements, et mit un sac sur ses reins, et mena deuil sur son fils pendant longtemps. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Et tous ses fils, et toutes ses filles vinrent pour le consoler; mais il refusa d'être consolé, et il dit: Je descendrai en deuil vers mon fils au Sépulcre! C'est ainsi que son père le pleura. ");
INSERT INTO fra_fob_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Et les Madianites le vendirent en Égypte à Potiphar, officier de Pharaon, chef des gardes. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Il arriva qu'en ce temps-là Juda descendit d'avec ses frères, et se retira vers un homme d'Adullam, nommé Hira. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Et Juda y vit la fille d'un Cananéen, nommé Shua; et il la prit, et vint vers elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Et elle conçut et enfanta un fils; et il le nomma Er. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Et elle conçut encore, et enfanta un fils, et elle le nomma Onan. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Elle enfanta encore un fils, et elle le nomma Shéla. Et Juda était à Kezib, quand elle l'enfanta. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Et Juda prit une femme pour Er, son premier-né; elle s'appelait Tamar. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Mais Er, premier-né de Juda, fut méchant aux yeux de l'Éternel, et l'Éternel le fit mourir. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Alors Juda dit à Onan: Viens vers la femme de ton frère; prends-la, comme beau-frère, et suscite une postérité à ton frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Mais Onan savait que cette postérité ne serait pas à lui, et quand il venait vers la femme de son frère, il se souillait afin de ne point donner de postérité à son frère. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Et ce qu'il faisait déplut à l'Éternel; et il le fit mourir aussi. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Et Juda dit à Tamar, sa belle-fille: Demeure veuve dans la maison de ton père, jusqu'à ce que Shéla, mon fils, soit devenu grand. Car il disait: Prenons garde qu'il ne meure, lui aussi, comme ses frères. Et Tamar s'en alla, et demeura dans la maison de son père. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Et les jours s'écoulèrent, et la fille de Shua, femme de Juda, mourut. Lorsque Juda se fut consolé, il monta vers les tondeurs de ses brebis, à Thimna, avec Hira son ami, l'Adullamite. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Et on le fit savoir à Tamar, en disant: Voici, ton beau-père monte à Thimna, pour tondre ses brebis. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Alors elle quitta ses habits de veuve, et se couvrit d'un voile, et s'en enveloppa, et s'assit à l'entrée d'Énaïm, qui est sur le chemin de Thimna; car elle voyait que Shéla était devenu grand, et qu'elle ne lui avait point été donnée pour femme. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Et Juda la vit et la prit pour une prostituée; car elle avait couvert son visage. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Et il se détourna vers elle sur le chemin, et il dit: Allons, je te prie, que je vienne vers toi; car il ne savait pas que ce fût sa belle-fille. Et elle répondit: Que me donneras-tu, pour venir vers moi? ");
INSERT INTO fra_fob_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Et il dit: J'enverrai un chevreau du troupeau. Et elle répondit: Me donneras-tu un gage jusqu'à ce que tu l'envoies? ");
INSERT INTO fra_fob_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Et il dit: Quel est le gage que je te donnerai? Et elle répondit: Ton cachet, ton cordon, et ton bâton, que tu as à la main. Et il les lui donna, et il vint vers elle; et elle conçut de lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Ensuite elle se leva et s'en alla. Et elle quitta son voile, et se revêtit de ses habits de veuve. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Et Juda envoya le chevreau par son ami l'Adullamite, pour retirer le gage des mains de cette femme; mais il ne la trouva point. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Et il interrogea les hommes du lieu où elle était, en disant: Où est cette courtisane qui était à Énaïm, sur le chemin? Et ils répondirent: Il n'y a point eu ici de courtisane. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Et il retourna vers Juda, et dit: Je ne l'ai point trouvée, et même les gens du lieu ont dit: Il n'y a point eu ici de courtisane. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Et Juda dit: Qu'elle garde le gage! Il ne faut pas nous faire mépriser. Voici, j'ai envoyé ce chevreau; et tu ne l'as point trouvée. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Or, il arriva qu'environ trois mois après on fit rapport à Juda, en disant: Tamar, ta belle-fille, s'est prostituée, et même la voilà enceinte par suite de sa prostitution. Et Juda dit: Faites-la sortir, et qu'elle soit brûlée. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Comme on la faisait sortir, elle envoya dire à son beau-père: Je suis enceinte de l'homme à qui ces choses appartiennent. Et elle dit: Reconnais, je te prie, à qui sont ce cachet, ces cordons et ce bâton. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Alors Juda les reconnut, et dit: Elle est plus juste que moi, parce que je ne l'ai point donnée à Shéla mon fils. Et il ne la connut plus. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Et à l'époque où elle devait accoucher, il se trouva qu'il y avait des jumeaux dans son sein; ");
INSERT INTO fra_fob_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Et pendant qu'elle enfantait, l'un d'eux donna la main, et la sage-femme la prit et y lia un fil écarlate, en disant: Celui-ci est sorti le premier. ");
INSERT INTO fra_fob_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mais comme il retira sa main, voici, son frère sortit. Et elle dit: Quelle brèche tu as faite! La brèche soit sur toi! Et on le nomma Pharets (brèche). ");
INSERT INTO fra_fob_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ensuite son frère sortit, qui avait à sa main le fil écarlate, et on le nomma Zarach. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Or, Joseph fut emmené en Égypte, et Potiphar, officier de Pharaon, chef des gardes, homme égyptien, l'acheta des Ismaélites, qui l'y avaient amené. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Et l'Éternel fut avec Joseph; et il prospérait. Et il était dans la maison de son maître l'Égyptien. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Et son maître vit que l'Éternel était avec lui, et que l'Éternel faisait prospérer entre ses mains tout ce qu'il faisait. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph trouva donc grâce à ses yeux, et il le servait; et son maître l'établit sur sa maison, et remit entre ses mains tout ce qu'il avait. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Or, depuis qu'il l'eut établi dans sa maison et sur tout ce qu'il avait, l'Éternel bénit la maison de l'Égyptien, à cause de Joseph. Et la bénédiction de l'Éternel fut sur tout ce qu'il avait, dans la maison et aux champs. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Et il laissa entre les mains de Joseph tout ce qui était à lui, et il ne prenait connaissance de rien avec lui, si ce n'est du pain qu'il mangeait. Or, Joseph était beau de taille, et beau de visage. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Et il arriva, après ces choses, que la femme de son maître jeta les yeux sur Joseph, et dit: Couche avec moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Mais il refusa, et il dit à la femme de son maître: Voici, mon maître ne prend connaissance avec moi de rien dans la maison, et il a remis entre mes mains tout ce qui lui appartient. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Nul n'est plus grand dans cette maison que moi, et il ne m'a rien interdit que toi, parce que tu es sa femme. Comment ferais-je un si grand mal, et pécherais-je contre Dieu? ");
INSERT INTO fra_fob_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Et bien qu'elle en parlât tous les jours à Joseph, il ne voulut point l'écouter pour coucher auprès d'elle, ni pour être avec elle. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Mais il arriva, un jour, qu'il vint à la maison pour faire son ouvrage, et il n'y avait là aucun des gens de la maison; ");
INSERT INTO fra_fob_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Et elle le prit par son vêtement, en disant: Couche avec moi; mais il laissa son vêtement entre ses mains, et s'enfuit et sortit dehors. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Et dès qu'elle vit qu'il avait laissé son vêtement entre ses mains, et qu'il s'était enfui dehors, ");
INSERT INTO fra_fob_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Elle appela les gens de sa maison, et leur parla, en disant: Voyez, on nous a amené un homme hébreu pour se jouer de nous; il est venu vers moi pour coucher avec moi; mais j'ai crié à haute voix. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Et dès qu'il a entendu que j'élevais la voix et que je criais, il a laissé son vêtement près de moi, et s'est enfui, et est sorti dehors. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Et elle mit le vêtement de Joseph auprès d'elle, jusqu'à ce que son maître vînt à la maison. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Alors elle lui parla dans les mêmes termes, en disant: L'esclave hébreu, que tu nous as amené, est venu vers moi, pour se jouer de moi. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Mais comme j'ai élevé la voix, et que j'ai crié, il a laissé son vêtement près de moi, et s'est enfui dehors. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Et dès que le maître de Joseph eut entendu les paroles de sa femme, qui lui disait: Voilà ce que m'a fait ton esclave, sa colère s'enflamma. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Et le maître de Joseph le prit, et le mit dans la forteresse, lieu où les prisonniers du roi étaient enfermés. Il fut donc là dans la forteresse. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mais l'Éternel fut avec Joseph, et il étendit sa bonté sur lui, et lui fit trouver grâce aux yeux du commandant de la forteresse. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Et le commandant de la forteresse remit entre les mains de Joseph tous les prisonniers qui étaient dans la forteresse; et tout ce qui s'y faisait, c'était lui qui le faisait. ");
INSERT INTO fra_fob_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Le commandant de la forteresse ne revoyait rien de tout ce que Joseph avait entre les mains, parce que l'Éternel était avec lui, et que l'Éternel faisait prospérer ce qu'il faisait. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Après ces choses, il arriva que l'échanson du roi d'Égypte et le panetier offensèrent leur seigneur, le roi d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Et Pharaon se mit en colère contre ses deux officiers, contre le grand échanson et le grand panetier; ");
INSERT INTO fra_fob_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Et il les fit mettre en prison dans la maison du chef des gardes, dans la forteresse, lieu où Joseph était enfermé. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Et le chef des gardes établit Joseph auprès d'eux, et il les servait; et ils furent quelque temps en prison. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Et tous les deux eurent un songe, chacun le sien, dans une même nuit, chacun un songe d'une signification particulière, tant l'échanson que le panetier du roi d'Égypte qui étaient enfermés dans la forteresse. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Et Joseph, venant vers eux le matin, les regarda, et voici, ils étaient tristes. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Et il interrogea ces officiers de Pharaon, qui étaient avec lui en prison dans la maison de son maître, et leur dit: Pourquoi avez-vous mauvais visage aujourd'hui? ");
INSERT INTO fra_fob_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Et ils lui répondirent: Nous avons fait un songe, et il n'y a personne qui l'interprète. Et Joseph leur dit: Les interprétations n'appartiennent-elles pas à Dieu? Racontez-moi vos songes, je vous prie. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Et le grand échanson raconta son songe à Joseph, et lui dit: Je songeais, et voici, un cep était devant moi; ");
INSERT INTO fra_fob_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Et ce cep avait trois sarments. Or, il semblait qu'il poussait; sa fleur sortit, et ses grappes donnèrent des raisins mûrs. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Et la coupe de Pharaon était dans ma main; et je pris les raisins, et je les pressai dans la coupe de Pharaon, et je mis la coupe dans la main de Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Et Joseph lui dit: En voici l'interprétation: Les trois sarments sont trois jours. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Dans trois jours, Pharaon élèvera ta tête, et te rétablira dans ta charge, et tu mettras la coupe de Pharaon dans sa main, comme tu le faisais auparavant, lorsque tu étais son échanson. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mais souviens-toi de moi, quand tu seras heureux, et use de bonté envers moi, je te prie; fais mention de moi à Pharaon, et fais-moi sortir de cette maison. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Car, certainement, j'ai été dérobé du pays des Hébreux, et ici non plus je n'ai rien fait pour qu'on me mît dans cette fosse. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Alors le grand panetier, voyant que Joseph avait interprété en bien, lui dit: Moi aussi je songeais, et voici, j'avais trois corbeilles de pain blanc sur la tête; ");
INSERT INTO fra_fob_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Et dans la plus haute corbeille il y avait pour Pharaon de toutes sortes de mets faits par le boulanger; et les oiseaux les mangeaient dans la corbeille qui était sur ma tête. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Et Joseph répondit, et dit: En voici l'interprétation: Les trois corbeilles sont trois jours. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Dans trois jours, Pharaon élèvera ta tête de dessus toi, et te fera pendre à un bois, et les oiseaux mangeront ta chair sur toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Et le troisième jour, jour de la naissance de Pharaon, il fit un festin à tous ses serviteurs, et il éleva la tête du grand échanson et du grand panetier, au milieu de ses serviteurs: ");
INSERT INTO fra_fob_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Il rétablit le grand échanson dans son office d'échanson, afin qu'il mît la coupe dans la main de Pharaon; ");
INSERT INTO fra_fob_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Mais il fit pendre le grand panetier; comme Joseph le leur avait déclaré. ");
INSERT INTO fra_fob_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Or, le grand échanson ne se souvint point de Joseph; mais il l'oublia. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Et il arriva, au bout de deux ans, que Pharaon eut un songe; et voici, il se tenait près du fleuve. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Et voici que du fleuve montaient sept vaches belles et grasses, et elles paissaient dans le marécage. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Et voici, sept autres vaches laides et maigres, montaient du fleuve après elles, et elles se tinrent auprès des autres vaches sur le bord du fleuve. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Et les vaches laides et maigres dévorèrent les sept vaches belles et grasses. Et Pharaon s'éveilla. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Et il s'endormit et songea une seconde fois. Et voici sept épis gras et beaux poussaient sur une même tige. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Puis, voici, sept épis maigres et brûlés par le vent d'Orient germaient après ceux-là. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Et les épis maigres engloutirent les sept épis gras et pleins; et Pharaon s'éveilla, et voici, c'était un songe. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Et sur le matin son esprit était agité; et il envoya appeler tous les magiciens et tous les sages d'Égypte, et Pharaon leur raconta ses songes; mais il n'y eut personne qui les lui interpréta. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Alors le grand échanson parla à Pharaon, en disant: Je vais rappeler aujourd'hui mes fautes. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaon se mit en colère contre ses serviteurs, et me fit mettre en prison, dans la maison du chef des gardes, moi et le grand panetier. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Alors nous fîmes, lui et moi, un songe dans une même nuit; nous songeâmes, chacun selon la signification de son songe. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Or, il y avait là avec nous un jeune homme hébreu, serviteur du chef des gardes; et nous lui racontâmes nos songes, et il nous les interpréta; il donna à chacun une interprétation d'après son songe. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Et la chose arriva comme il nous l'avait interprétée: le roi me rétablit dans ma place, et fit pendre l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Alors Pharaon envoya appeler Joseph, et on le fit sortir en hâte de la prison; on le rasa, on le fit changer de vêtements, et il vint vers Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Et Pharaon dit à Joseph: J'ai fait un songe, et il n'y a personne qui l'interprète. Or, j'ai entendu dire que tu n'as qu'à entendre un songe pour l'interpréter. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Et Joseph répondit à Pharaon, en disant: Ce n'est pas moi, c'est Dieu qui répondra touchant la prospérité de Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Et Pharaon dit à Joseph: Dans mon songe, voici, je me tenais sur le bord du fleuve. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Et voici que du fleuve montaient sept vaches grasses et belles, et elles paissaient dans le marécage. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Et voici, sept autres vaches montaient après elles, chétives, et très laides, et décharnées; je n'en ai jamais vu de semblables en laideur dans tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Et les vaches décharnées et laides dévorèrent les sept premières vaches grasses, ");
INSERT INTO fra_fob_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Qui entrèrent dans leur ventre sans qu'il parût qu'elles y fussent entrées, et elles étaient aussi laides qu'au commencement. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Alors je me réveillai. Je vis encore en songeant, et sept épis pleins et beaux poussaient sur une même tige. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Puis, voici, sept épis stériles, maigres et brûlés par le vent d'Orient, germaient après ceux-là. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Et les épis maigres engloutirent les sept beaux épis. Et je l'ai dit aux magiciens; mais nul ne me l'explique. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Et Joseph répondit à Pharaon: Ce qu'a songé Pharaon est une seule chose; Dieu a déclaré à Pharaon ce qu'il va faire. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Les sept belles vaches sont sept ans; et les sept beaux épis sont sept ans; c'est un même songe. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Et les sept vaches décharnées et laides, qui montaient après celles-là sont sept ans, et les sept épis vides, brûlés par le vent d'Orient, seront sept ans de famine. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","C'est ce que j'ai dit à Pharaon: Dieu a fait voir à Pharaon ce qu'il va faire. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Voici, il va venir sept années de grande abondance dans tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Mais elles seront suivies de sept ans de famine; et toute cette abondance sera oubliée dans le pays d'Égypte, et la famine consumera le pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Et l'abondance ne paraîtra plus dans le pays, à cause de cette famine qui viendra après; car elle sera très grande. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Et quant à ce que le songe s'est reproduit deux fois pour Pharaon, c'est que la chose est arrêtée de Dieu, et que Dieu se hâte de l'accomplir. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Or, maintenant, que Pharaon choisisse un homme entendu et sage, et qu'il l'établisse sur le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Que Pharaon établisse et institue des commissaires sur le pays, et qu'il prenne le cinquième du revenu du pays d'Égypte, durant les sept années d'abondance. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Et qu'ils rassemblent tous les vivres de ces bonnes années qui viennent, et qu'ils amassent du froment sous la main de Pharaon, des vivres dans les villes, et qu'ils les gardent. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Et ces vivres seront en réserve pour le pays, pour les sept années de famine qui seront au pays d'Égypte, afin que le pays ne soit pas consumé par la famine. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Et ce discours plut à Pharaon, et à tous ses serviteurs. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Et Pharaon dit à ses serviteurs: Trouverions-nous un homme comme celui-ci, qui a l'esprit de Dieu? ");
INSERT INTO fra_fob_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Et Pharaon dit à Joseph: Puisque Dieu t'a fait connaître tout ceci, nul n'est entendu, ni sage autant que toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","C'est toi qui seras sur ma maison, et tout mon peuple obéira à ta bouche. Je serai seulement plus grand que toi par le trône. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Puis Pharaon dit à Joseph: Regarde, je t'établis sur tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Alors Pharaon ôta son anneau de sa main, et le mit à la main de Joseph; et il le fit revêtir d'habits de fin lin, et lui mit un collier d'or au cou. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Et il le fit monter sur son second char; et l'on criait devant lui: A genoux! Et il l'établit sur tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Et Pharaon dit à Joseph: Je suis Pharaon! et sans toi nul ne lèvera la main ni le pied dans tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Et Pharaon appela Joseph du nom de Tsophnath-Panéach (soutien de la vie), et il lui donna pour femme Asnath, fille de Potiphéra, prêtre d'On (Héliopolis). Et Joseph alla visiter le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Or, Joseph était âgé de trente ans, quand il se présenta devant Pharaon, roi d'Égypte. Joseph sortit donc de devant Pharaon, et parcourut tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Et la terre rapporta à pleines mains durant les sept années d'abondance. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Et Joseph rassembla tous les vivres des sept années, qu'il y eut au pays d'Égypte; et il mit les vivres dans les villes; il mit dans l'intérieur de chaque ville les vivres du territoire qui l'environnait. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Et Joseph amassa une grande quantité de froment, comme le sable de la mer; tellement qu'on cessa de le compter, parce qu'il était sans nombre. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Or, avant qu'arrivât l'année de famine, il naquit à Joseph deux fils, qu'Asnath, fille de Potiphéra, prêtre d'On, lui enfanta. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Et Joseph nomma le premier-né Manassé (celui qui fait oublier); car Dieu, dit-il, m'a fait oublier toute ma peine, et toute la maison de mon père. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Et il nomma le second Éphraïm (double fécondité); car Dieu, dit-il, m'a rendu fécond dans le pays de mon affliction. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Alors finirent les sept années de l'abondance qu'il y eut au pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Et les sept années de famine commencèrent à venir, comme Joseph l'avait dit. Et la famine fut dans tous les pays; mais dans tout le pays d'Égypte il y avait du pain. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ensuite tout le pays d'Égypte fut affamé; et le peuple cria à Pharaon pour avoir du pain. Et Pharaon répondit à tous les Égyptiens: Allez à Joseph; faites ce qu'il vous dira. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","La famine fut donc sur toute la surface du pays, et Joseph ouvrit tous les greniers et vendit du blé aux Égyptiens. Et la famine fut grande au pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Et de tous les pays on venait en Égypte, pour acheter du blé à Joseph; car la famine était grande par toute la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Et Jacob, voyant qu'il y avait du blé à vendre en Égypte, dit à ses fils: Pourquoi vous regardez-vous les uns les autres? ");
INSERT INTO fra_fob_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Et il dit: Voici, j'ai appris qu'il y a du blé à vendre en Égypte; descendez-y, et achetez-nous-y du blé, afin que nous vivions, et ne mourions point. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Alors dix frères de Joseph descendirent, pour acheter du blé en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Mais Jacob n'envoya point Benjamin, frère de Joseph, avec ses frères; car il dit: Prenons garde qu'il ne lui arrive malheur! ");
INSERT INTO fra_fob_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Et les fils d'Israël vinrent pour acheter du blé, au milieu de ceux qui venaient aussi; car la famine était au pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Or, c'était Joseph qui commandait dans le pays, c'était lui qui vendait le blé à tout le peuple du pays. Les frères de Joseph vinrent donc et se prosternèrent devant lui, la face contre terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Et Joseph vit ses frères, et les reconnut; mais il fit l'étranger avec eux, et leur parla rudement, et leur dit: D'où venez-vous? Et ils répondirent: Du pays de Canaan, pour acheter des vivres. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph reconnut donc ses frères; mais eux ne le reconnurent point. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Et Joseph se souvint des songes qu'il avait eus à leur sujet. Et il leur dit: Vous êtes des espions; vous êtes venus pour observer les lieux faibles du pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Et ils lui répondirent: Non, mon seigneur, mais tes serviteurs sont venus pour acheter des vivres. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nous sommes tous fils d'un même homme; nous sommes gens de bien; tes serviteurs ne sont point des espions. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Et il leur dit: Non! mais vous êtes venus pour observer les lieux faibles du pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Et ils répondirent: Nous, tes serviteurs, sommes douze frères, fils d'un même homme, au pays de Canaan. Et voici, le plus jeune est aujourd'hui avec notre père; et l'un n'est plus. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Et Joseph leur dit: C'est ce que je vous ai dit: Vous êtes des espions. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Voici comment vous serez éprouvés: Par la vie de Pharaon, vous ne sortirez point d'ici, que votre jeune frère n'y soit venu. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Envoyez l'un de vous et qu'il amène votre frère; et vous, demeurez prisonniers; et que vos paroles soient éprouvées, pour voir si la vérité est avec vous. Autrement, par la vie de Pharaon, vous êtes des espions. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Et il les fit mettre ensemble en prison pour trois jours. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Et, au troisième jour, Joseph leur dit: Faites ceci, et vous vivrez; je crains Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si vous êtes gens de bien, que l'un de vous, votre frère, reste lié dans votre prison, et vous, allez, emportez du blé, pour subvenir à la famine de vos maisons. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Et amenez-moi votre jeune frère; et vos paroles seront reconnues véritables, et vous ne mourrez point. Et ils firent ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Et ils se disaient l'un à l'autre: Vraiment, nous sommes coupables à l'égard de notre frère; car nous avons vu l'angoisse de son âme, quand il nous demandait grâce, et nous ne l'avons point écouté; voilà pourquoi cette angoisse nous est arrivée. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Et Ruben leur répondit, en disant: Ne vous disais-je pas bien: Ne commettez point ce péché contre cet enfant? Mais vous n'écoutâtes point; et voici que son sang nous est redemandé. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Or, ils ne savaient pas que Joseph comprenait, parce qu'il leur parlait par le moyen d'un interprète. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Et il se détourna d'eux pour pleurer. Puis il retourna vers eux, et leur parla; et il prit d'entre eux Siméon, et le fit lier devant leurs yeux. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Et Joseph commanda qu'on remplît leurs sacs de froment, et qu'on remît l'argent de chacun d'eux dans son sac, et qu'on leur donnât des provisions pour le chemin. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ce qui fut fait. Puis ils chargèrent leur blé sur leurs ânes, et s'en allèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Et l'un d'eux ouvrit son sac pour donner du fourrage à son âne dans l'hôtellerie; et il vit son argent; et voici, il était à l'entrée de son sac. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Et il dit à ses frères: Mon argent m'a été rendu; et en effet, le voici dans mon sac. Et le cœur leur manqua, et ils se dirent en tremblant l'un à l'autre: Qu'est-ce que Dieu nous a fait? ");
INSERT INTO fra_fob_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Et ils vinrent vers Jacob, leur père, au pays de Canaan, et lui racontèrent toutes les choses qui leur étaient arrivées, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","L'homme qui est le seigneur du pays, nous a parlé rudement, et nous a pris pour des espions. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mais nous lui avons répondu: Nous sommes des gens de bien, nous ne sommes point des espions. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nous sommes douze frères, fils de notre père; l'un n'est plus, et le plus jeune est aujourd'hui avec notre père au pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Et l'homme qui est le seigneur du pays, nous a dit: A ceci je connaîtrai que vous êtes des gens de bien: Laissez avec moi l'un de vos frères, prenez ce qu'il faut pour la famine de vos maisons, et partez; ");
INSERT INTO fra_fob_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Et amenez-moi votre jeune frère. Alors je connaîtrai que vous n'êtes point des espions, mais des gens de bien; je vous rendrai votre frère, et vous trafiquerez dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Et comme ils vidaient leurs sacs, voici, le paquet d'argent de chacun était dans son sac; et ils virent, eux et leur père, leurs paquets d'argent, et ils eurent peur. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Alors Jacob, leur père, leur dit: Vous m'avez privé d'enfants: Joseph n'est plus, et Siméon n'est plus, et vous emmèneriez Benjamin! C'est sur moi que toutes ces choses sont tombées! ");
INSERT INTO fra_fob_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Et Ruben parla à son père, et lui dit: Tu feras mourir mes deux fils, si je ne te le ramène; confie-le-moi et je te le rendrai. ");
INSERT INTO fra_fob_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Et il répondit: Mon fils ne descendra point avec vous; car son frère est mort, et celui-ci est resté seul. Et s'il lui arrivait malheur dans le chemin par où vous irez, vous feriez descendre mes cheveux blancs avec douleur au Sépulcre. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Or, la famine était fort grande dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Et quand ils eurent achevé de manger le blé qu'ils avaient apporté d'Égypte, leur père leur dit: Retournez nous acheter un peu de vivres. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Et Juda lui répondit: Cet homme nous a expressément protesté et dit: Vous ne verrez point ma face, que votre frère ne soit avec vous. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si tu envoies notre frère avec nous, nous descendrons en Égypte, et nous t'achèterons des vivres. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mais si tu ne l'envoies pas, nous n'y descendrons point; car cet homme nous a dit: Vous ne verrez point ma face, que votre frère ne soit avec vous. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Et Israël dit: Pourquoi m'avez-vous fait ce tort, de déclarer à cet homme que vous aviez encore un frère? ");
INSERT INTO fra_fob_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Et ils répondirent: Cet homme s'est enquis avec soin de nous et de notre parenté, en disant: Votre père vit-il encore? Avez-vous encore un frère? Et nous le lui avons déclaré, d'après ces questions. Pouvions-nous savoir qu'il dirait: Faites descendre votre frère? ");
INSERT INTO fra_fob_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Et Juda dit à Israël, son père: Envoie l'enfant avec moi, et nous nous lèverons, et partirons; et nous vivrons et ne mourrons point, ni nous, ni toi, ni nos petits enfants. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Je réponds de lui; tu me le redemanderas. Si je ne te le ramène et ne le présente devant ta face, je serai coupable envers toi à toujours. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Car si nous n'avions pas différé, nous serions maintenant deux fois de retour. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Alors Israël, leur père, leur dit: S'il en est ainsi, faites donc ceci: Prenez dans vos bagages des produits les plus renommés du pays, et portez à cet homme un présent, un peu de baume et un peu de miel, des aromates et de la myrrhe, des pistaches et des amandes; ");
INSERT INTO fra_fob_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Et prenez d'autre argent dans vos mains, et reportez dans vos mains l'argent qui a été remis à l'entrée de vos sacs. Peut-être est-ce une erreur. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Prenez aussi votre frère, et levez-vous, retournez vers cet homme. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Et que le Dieu Tout-Puissant vous fasse trouver grâce devant cet homme, qu'il vous relâche votre autre frère, et Benjamin! Et s'il faut que je sois privé d'enfants, que j'en sois privé! ");
INSERT INTO fra_fob_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ils prirent donc le présent, et le double d'argent dans leurs mains, et Benjamin. Puis, se levant, ils descendirent en Égypte, et se présentèrent devant Joseph. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Et Joseph vit Benjamin avec eux, et il dit à l'intendant de sa maison: Mène ces hommes à la maison, tue quelque bête et apprête-la; car ils mangeront avec moi à midi. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Et l'homme fit comme Joseph avait dit, et il amena ces hommes à la maison de Joseph. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Et ces hommes eurent peur de ce qu'on les menait à la maison de Joseph; et ils dirent: C'est à cause de l'argent qui fut remis dans nos sacs la première fois, qu'on nous emmène; c'est pour se jeter, se précipiter sur nous et nous prendre pour esclaves, et se saisir de nos ânes. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Alors ils s'approchèrent de l'intendant de la maison de Joseph, et lui parlèrent à la porte de la maison, et dirent: ");
INSERT INTO fra_fob_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Pardon, mon seigneur! nous sommes descendus une première fois pour acheter des vivres; ");
INSERT INTO fra_fob_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Et lorsque nous arrivâmes à l'hôtellerie, et que nous ouvrîmes nos sacs, voici, l'argent de chacun était à l'entrée de son sac, notre argent selon son poids; et nous l'avons rapporté en nos mains. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Et nous avons apporté d'autre argent en nos mains, pour acheter des vivres; nous ne savons qui avait remis notre argent dans nos sacs. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Et il dit: Tout va bien pour vous! Ne craignez point: C'est votre Dieu, le Dieu de votre père qui vous a donné un trésor dans vos sacs; votre argent m'est parvenu. Et il leur amena Siméon. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Et cet homme les fit entrer dans la maison de Joseph; il leur donna de l'eau, et ils lavèrent leurs pieds; il donna aussi du fourrage à leurs ânes. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Et ils préparèrent le présent, en attendant que Joseph vînt à midi; car ils avaient appris qu'ils mangeraient là le pain. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Joseph revint à la maison. Alors ils lui offrirent dans la maison le présent qu'ils avaient en leurs mains; et ils se prosternèrent en terre devant lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Et il leur demanda comment ils se portaient, et il leur dit: Votre vieux père, dont vous m'avez parlé, se porte-t-il bien? Vit-il encore? ");
INSERT INTO fra_fob_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Et ils répondirent: Ton serviteur notre père se porte bien; il vit encore. Et ils s'inclinèrent, et se prosternèrent. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Et, levant les yeux, il vit Benjamin son frère, fils de sa mère, et dit: Est-ce là votre jeune frère, dont vous m'avez parlé? Et il lui dit: Dieu te fasse miséricorde, mon fils! ");
INSERT INTO fra_fob_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Et Joseph se hâta, car ses entrailles étaient émues pour son frère, et il chercha un lieu pour pleurer; et il entra dans la chambre intérieure et y pleura. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Puis il se lava le visage et sortit; et, se faisant violence, il dit: Servez le pain. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Et on le servit à part, et eux à part; et les Égyptiens qui mangeaient avec lui furent aussi servis à part, parce que les Égyptiens ne peuvent manger le pain avec les Hébreux; car c'est une abomination pour les Égyptiens. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ils s'assirent donc en sa présence, l'aîné selon son droit d'aînesse, et le plus jeune selon son âge. Et ces hommes se regardaient l'un l'autre avec étonnement. ");
INSERT INTO fra_fob_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Et il leur fit porter des mets de devant lui; mais la portion de Benjamin était cinq fois plus grosse que les portions de tous les autres; et ils burent et firent bonne chère avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Puis il commanda à l'intendant de sa maison, en disant: Remplis les sacs de ces gens d'autant de vivres qu'ils en pourront porter, et mets l'argent de chacun à l'entrée de son sac. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Et tu mettras ma coupe, la coupe d'argent à l'entrée du sac du plus jeune, avec l'argent de son blé. Et il fit comme Joseph lui avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Le matin, dès qu'il fit jour, on renvoya ces hommes, avec leurs ânes. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Lorsqu'ils furent sortis de la ville, avant qu'ils fussent loin, Joseph dit à l'intendant de sa maison: Lève-toi, poursuis ces hommes, et quand tu les auras atteints, tu leur diras: Pourquoi avez-vous rendu le mal pour le bien? ");
INSERT INTO fra_fob_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","N'est-ce pas la coupe dont mon seigneur se sert pour boire et pour deviner? Vous avez fait une méchante action. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Et il les atteignit, et leur dit ces paroles. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Et ils lui répondirent: Pourquoi mon seigneur parle-t-il ainsi? Loin de tes serviteurs la pensée de faire pareille chose! ");
INSERT INTO fra_fob_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Voici, nous t'avons rapporté du pays de Canaan l'argent que nous avions trouvé à l'entrée de nos sacs; comment déroberions-nous de la maison de ton maître de l'argent ou de l'or? ");
INSERT INTO fra_fob_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Que celui de tes serviteurs chez qui on trouvera la coupe, meure, et nous serons nous-mêmes esclaves de mon seigneur. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Et il dit: Eh bien! qu'il soit fait selon vos paroles: celui chez qui on la trouvera, sera mon esclave, et vous, vous serez innocents. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Et ils se hâtèrent de déposer chacun leur sac à terre, et ils ouvrirent chacun leur sac. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Et il les fouilla, en commençant par le plus grand et finissant par le plus jeune. Et la coupe se trouva dans le sac de Benjamin. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Alors ils déchirèrent leurs habits, et chacun rechargea son âne, et ils retournèrent à la ville. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Et Juda, avec ses frères, vint à la maison de Joseph, qui était encore là, et ils se jetèrent à terre devant lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Et Joseph leur dit: Quelle action avez-vous faite? Ne savez-vous pas qu'un homme tel que moi sait deviner? ");
INSERT INTO fra_fob_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Et Juda répondit: Que dirons-nous à mon seigneur? comment parlerons-nous? et comment nous justifierons-nous? Dieu a trouvé l'iniquité de tes serviteurs. Nous voici esclaves de mon seigneur, tant nous que celui entre les mains de qui la coupe s'est trouvée. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Mais il dit: Loin de moi la pensée d'agir ainsi! L'homme entre les mains de qui la coupe a été trouvée, sera mon esclave; mais vous, remontez en paix vers votre père. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Alors Juda s'approcha de lui, et dit: Pardon, mon seigneur! Que ton serviteur dise un mot, je te prie, aux oreilles de mon seigneur, et que ta colère ne s'enflamme point contre ton serviteur; car tu es comme Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mon seigneur interrogea ses serviteurs, en disant: Avez-vous père ou frère? ");
INSERT INTO fra_fob_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Et nous répondîmes à mon seigneur: Nous avons un père âgé, et un jeune enfant qui lui est né en sa vieillesse. Or, son frère est mort, et celui-ci est resté seul de sa mère, et son père l'aime. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Et tu dis à tes serviteurs: Faites-le descendre vers moi, et que je le voie de mes yeux. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Et nous dîmes à mon seigneur: L'enfant ne peut quitter son père; et s'il le quitte, son père mourra. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Alors tu dis à tes serviteurs: Si votre jeune frère ne descend avec vous, vous ne verrez plus ma face. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Et lorsque nous fûmes remontés vers ton serviteur mon père, nous lui rapportâmes les paroles de mon seigneur. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Ensuite notre père dit: Retournez nous acheter un peu de vivres. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Et nous dîmes: Nous ne pouvons descendre; mais si notre jeune frère est avec nous, nous descendrons; car nous ne pouvons pas voir la face de cet homme, que notre jeune frère ne soit avec nous. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Et ton serviteur mon père nous répondit: Vous savez que ma femme m'a enfanté deux fils; ");
INSERT INTO fra_fob_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","L'un s'en est allé d'auprès de moi; et j'ai dit: Certainement, il a été déchiré; et je ne l'ai point revu jusqu'à présent. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Si vous ôtez aussi celui-ci de ma présence, et qu'il lui arrive malheur, vous ferez descendre mes cheveux blancs avec douleur au Sépulcre. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Et maintenant, quand je viendrai vers ton serviteur mon père, si le jeune homme, dont l'âme est liée à son âme, n'est pas avec nous, ");
INSERT INTO fra_fob_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Il arrivera que, dès qu'il verra que le jeune homme n'y est point, il mourra. Et tes serviteurs feront descendre avec douleur les cheveux blancs de ton serviteur notre père au Sépulcre. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Car ton serviteur a répondu du jeune homme, en le prenant à mon père; et il a dit: Si je ne te le ramène, je serai coupable envers mon père à toujours. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Maintenant donc, que ton serviteur demeure, je te prie, esclave de mon seigneur au lieu du jeune homme, et que celui-ci remonte avec ses frères. ");
INSERT INTO fra_fob_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Car comment remonterais-je vers mon père, si le jeune homme n'est avec moi? Ah! que je ne voie point l'affliction de mon père! ");
INSERT INTO fra_fob_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Alors Joseph ne put plus se retenir devant tous ceux qui étaient là présents, et il cria: Faites sortir tout le monde. Et nul ne demeura avec Joseph, quand il se fit connaître à ses frères. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Et il éleva la voix en pleurant, et les Égyptiens l'entendirent, et la maison de Pharaon l'entendit. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Et Joseph dit à ses frères: Je suis Joseph! Mon père vit-il encore? Mais ses frères ne pouvaient lui répondre; car ils étaient troublés de sa présence. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Et Joseph dit à ses frères: Approchez donc de moi. Et ils s'approchèrent, et il dit: Je suis Joseph votre frère, que vous avez vendu pour être mené en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Et maintenant, ne vous affligez pas, et n'ayez point de regret de ce que vous m'avez vendu pour être amené ici; car c'est pour la conservation de votre vie que Dieu m'a envoyé devant vous. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Car voici deux ans que la famine est sur la terre, et pendant cinq ans encore il n'y aura ni labour, ni moisson. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Mais Dieu m'a envoyé devant vous, pour vous faire subsister sur la terre, et pour vous faire vivre par une grande délivrance. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Et maintenant, ce n'est pas vous qui m'avez envoyé ici, mais c'est Dieu; et il m'a établi pour père à Pharaon, et pour seigneur sur toute sa maison, et gouverneur dans tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hâtez-vous de monter vers mon père, et dites-lui: Ainsi a dit ton fils Joseph: Dieu m'a établi seigneur sur toute l'Égypte; descends vers moi, ne t'arrête point. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tu habiteras au pays de Gossen, et tu seras près de moi, toi, tes enfants, et les enfants de tes enfants, tes brebis et tes bœufs, et tout ce qui est à toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Et je t'y entretiendrai (car il y a encore cinq ans de famine), de peur que tu ne périsses de pauvreté, toi et ta maison, et tout ce qui est à toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Et voici, vous voyez de vos yeux, et Benjamin mon frère voit aussi de ses yeux, que c'est moi qui vous parle de ma propre bouche. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Racontez donc à mon père toute ma gloire en Égypte, et tout ce que vous avez vu; et hâtez-vous de faire descendre ici mon père. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Alors il se jeta au cou de Benjamin son frère, et pleura. Et Benjamin pleura sur son cou. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Et il baisa tous ses frères, en pleurant. Après quoi, ses frères s'entretinrent avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Et ce bruit se répandit dans la maison de Pharaon: Les frères de Joseph sont venus. Ce qui plut à Pharaon et à ses serviteurs. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaon dit à Joseph: Dis à tes frères: Faites ceci; chargez vos bêtes, et allez, retournez au pays de Canaan; ");
INSERT INTO fra_fob_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Et prenez votre père et vos familles, et venez vers moi, et je vous donnerai le meilleur du pays d'Égypte; et vous mangerez la graisse de la terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Or tu reçois l'ordre de leur dire: Faites ceci; prenez pour vous, du pays d'Égypte, des chariots pour vos petits enfants et pour vos femmes, et vous amènerez votre père, et vous viendrez. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Et ne regrettez point vos meubles; car le meilleur de tout le pays d'Égypte sera à vous. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Les fils d'Israël firent ainsi; et Joseph leur donna des chariots, selon l'ordre de Pharaon; et il leur donna des provisions pour le chemin. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Il leur donna à tous des robes de rechange, et à Benjamin il donna trois cents pièces d'argent, et cinq robes de rechange. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Il envoya aussi à son père dix ânes chargés de ce qu'il y avait de meilleur en Égypte, et dix ânesses chargées de blé, de pain, et de nourriture pour son père pendant le voyage. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Il renvoya donc ses frères, et ils partirent, et il leur dit: Ne vous querellez point en chemin. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Et ils remontèrent d'Égypte, et vinrent au pays de Canaan vers Jacob, leur père. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Et ils lui firent ce rapport et dirent: Joseph vit encore, et même c'est lui qui gouverne tout le pays d'Égypte. Mais son cœur resta froid, car il ne les crut point. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Et ils lui dirent toutes les paroles que Joseph leur avait dites. Et il vit les chariots que Joseph avait envoyés pour le porter. Et l'esprit de Jacob, leur père, se ranima. ");
INSERT INTO fra_fob_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Et Israël dit: C'est assez; Joseph mon fils vit encore; j'irai, et je le verrai avant que je meure. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Et Israël partit, avec tout ce qui lui appartenait, et vint à Béer-Shéba, et offrit des sacrifices au Dieu de son père Isaac. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Et Dieu parla à Israël dans les visions de la nuit, et il dit: Jacob, Jacob! Et il répondit: Me voici. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Puis il dit: Je suis Dieu, le Dieu de ton père. Ne crains point de descendre en Égypte; car je t'y ferai devenir une grande nation. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Je descendrai avec toi en Égypte, et je t'en ferai aussi infailliblement remonter; et Joseph mettra sa main sur tes yeux. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Alors Jacob partit de Béer-Shéba, et les fils d'Israël mirent Jacob leur père, et leurs petits enfants, et leurs femmes, sur les chariots que Pharaon avait envoyés pour le porter. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ils emmenèrent aussi leur bétail et le bien qu'ils avaient acquis au pays de Canaan. Et Jacob et toute sa famille avec lui vinrent en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Il amena avec lui en Égypte ses fils et les fils de ses fils, ses filles et les filles de ses fils, et toute sa famille. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Et voici les noms des fils d'Israël qui vinrent en Égypte: Jacob et ses fils. Le premier-né de Jacob, Ruben. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Les fils de Ruben: Hénoc, Pallu, Hetsron et Carmi. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Les fils de Siméon: Jémuël, Jamin, Ohad, Jakin, Tsohar, et Saül, fils de la Cananéenne. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Les fils de Lévi: Guershon, Kéhath et Mérari. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Les fils de Juda: Er, Onan, Shéla, Pharets et Zarach. Mais Er et Onan moururent au pays de Canaan. Et les fils de Pharets furent Hetsron et Hamul. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Les fils d'Issacar: Thola, Puva, Job et Shimron. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Les fils de Zabulon: Séred, Élon et Jahléel. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Voilà les fils de Léa, qu'elle enfanta à Jacob, à Paddan-Aram, avec Dina sa fille; ses fils et ses filles étaient en tout trente-trois personnes. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Les fils de Gad: Tsiphjon et Haggi, Shuni et Etsbon, Eri, Arodi et Aréli. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Les fils d'Asser: Jimna, Jishva, Jishvi, Béria, et Sérach leur sœur. Et les enfants de Béria: Héber et Malkiel. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Voilà les fils de Zilpa, que Laban avait donnée à Léa, sa fille; et elle les enfanta à Jacob: seize personnes. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Les fils de Rachel, femme de Jacob: Joseph et Benjamin. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Et Joseph eut des fils au pays d'Égypte: Manassé et Éphraïm qu'Asnath, fille de Potiphéra, prêtre d'On, lui enfanta. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Les fils de Benjamin: Béla, Béker et Ashbel, Guéra et Naaman, Ehi et Rosh, Muppim et Huppim, et Ard. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Voilà les fils de Rachel, qui naquirent à Jacob; en tout quatorze personnes. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Les fils de Dan: Hushim. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Les fils de Nephthali: Jahtséel, Guni, Jetser et Shillem. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Voilà les fils de Bilha, que Laban avait donnée à Rachel, sa fille, et elle les enfanta à Jacob; en tout sept personnes. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Toutes les personnes appartenant à Jacob et nées de lui, qui vinrent en Égypte (sans les femmes des fils de Jacob), étaient en tout soixante-six. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Et les fils de Joseph, qui lui étaient nés en Égypte, étaient deux personnes. Toutes les personnes de la maison de Jacob, qui vinrent en Égypte, étaient soixante et dix. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Or, Jacob envoya Juda devant lui vers Joseph, pour qu'il lui montrât la route de Gossen. Ils vinrent donc au pays de Gossen. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Et Joseph attela son chariot, et monta à la rencontre d'Israël son père vers Gossen; et il se fit voir à lui, et se jeta à son cou, et pleura longtemps sur son cou. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Et Israël dit à Joseph: Que je meure à présent, puisque j'ai vu ton visage, et que tu vis encore. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Puis Joseph dit à ses frères et à la famille de son père: Je monterai, pour informer Pharaon, et je lui dirai: Mes frères et la famille de mon père, qui étaient au pays du Canaan, sont venus vers moi; ");
INSERT INTO fra_fob_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Et ces hommes sont bergers, car ils se sont toujours occupés de bétail; et ils ont amené leurs brebis et leurs bœufs, et tout ce qui est à eux. ");
INSERT INTO fra_fob_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Et quand Pharaon vous fera appeler, et dira: Quel est votre métier? ");
INSERT INTO fra_fob_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Vous direz: Tes serviteurs se sont toujours occupés de bétail, depuis notre jeunesse et jusqu'à maintenant, et nous et nos pères; afin que vous demeuriez dans le pays de Gossen; car les Égyptiens ont en abomination tous les bergers. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Et Joseph vint et fit savoir cela à Pharaon, et lui dit: Mon père et mes frères, avec leurs brebis et leurs bœufs, et tout ce qui est à eux, sont venus du pays de Canaan; et voici, ils sont dans le pays de Gossen. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Et il prit cinq hommes d'entre ses frères et les présenta à Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Et Pharaon dit à ses frères: Quel est votre métier? Et ils répondirent à Pharaon: Tes serviteurs sont bergers, comme l'ont été nos pères. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Puis ils dirent à Pharaon: C'est pour séjourner dans le pays que nous sommes venus; car il n'y a plus de pâturage pour les troupeaux de tes serviteurs; car la famine est grande au pays de Canaan. Permets donc à tes serviteurs d'habiter au pays de Gossen. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Et Pharaon parla ainsi à Joseph: Ton père et tes frères sont venus vers toi; ");
INSERT INTO fra_fob_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Le pays d'Égypte est à ta disposition; fais habiter ton père et tes frères dans le meilleur endroit du pays; qu'ils demeurent dans le pays de Gossen. Et si tu connais qu'il y ait parmi eux des hommes capables, tu les établiras chefs de troupeaux sur ce qui m'appartient. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Alors Joseph amena Jacob son père, et le présenta à Pharaon. Et Jacob bénit Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Et Pharaon dit à Jacob: A combien s'élèvent les jours des années de ta vie? ");
INSERT INTO fra_fob_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Et Jacob répondit à Pharaon: Les jours des années de mes pèlerinages sont de cent trente ans; les jours des années de ma vie ont été courts et mauvais, et ils n'ont point atteint les jours des années de la vie de mes pères, du temps de leurs pèlerinages. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Et Jacob bénit Pharaon, puis il sortit de devant Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Et Joseph assigna une demeure à son père et à ses frères, et il leur donna une possession au pays d'Égypte, dans le meilleur endroit du pays, dans le pays de Ramsès, comme l'avait ordonné Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Et Joseph fournit de pain son père, ses frères, et toute la maison de son père, selon le nombre des enfants. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Or, il n'y avait point de pain dans tout le pays, car la famine était très grande; et le pays d'Égypte et le pays de Canaan étaient épuisés par la famine. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Et Joseph amassa tout l'argent qui se trouvait dans le pays d'Égypte et dans le pays de Canaan, en échange du blé qu'on achetait; et Joseph fit entrer cet argent dans la maison de Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Et quand l'argent manqua au pays d'Égypte et au pays de Canaan, tous les Égyptiens vinrent à Joseph, en disant: Donne-nous du pain; et pourquoi mourrions-nous devant toi, parce qu'il n'y a plus d'argent? ");
INSERT INTO fra_fob_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Et Joseph répondit: Donnez votre bétail, et je vous donnerai du pain en échange de votre bétail, s'il n'y a plus d'argent. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Alors ils amenèrent leur bétail à Joseph, et Joseph leur donna du pain, en échange des chevaux, des troupeaux de brebis, des troupeaux de bœufs et des ânes. Il leur fournit du pain en échange de tous leurs troupeaux cette année-là. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Cette année écoulée, ils revinrent l'année suivante, et lui dirent: Nous ne cacherons point à mon seigneur que l'argent est épuisé, et que les troupeaux de bétail ont passé à mon seigneur; il ne reste rien devant mon seigneur que nos corps et nos terres. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pourquoi péririons-nous sous tes yeux, nous et nos terres? Achète-nous, nous et nos terres, pour du pain, et nous serons, avec nos terres, esclaves de Pharaon. Et donne-nous de quoi semer, afin que nous vivions et ne mourions pas, et que le sol ne soit point désolé. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Et Joseph acquit tout le sol de l'Égypte à Pharaon; car les Égyptiens vendirent chacun leur champ, parce que la famine les y força; et la terre fut à Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Quant au peuple, il le fit passer dans les villes, depuis une extrémité du territoire de l'Égypte jusqu'à l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Les terres des prêtres furent les seules qu'il n'acquit point; car les prêtres recevaient de Pharaon une portion fixée, et ils mangeaient la portion que Pharaon leur avait donnée. C'est pourquoi, ils ne vendirent point leurs terres. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Et Joseph dit au peuple: Je vous ai acquis aujourd'hui, vous et vos terres, à Pharaon. Voici pour vous de la semence, afin que vous ensemenciez le sol. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Et au temps des récoltes, vous donnerez le cinquième à Pharaon, et les quatre autres parties seront à vous, pour semer les champs, et pour votre nourriture, et pour celle des gens qui sont dans vos maisons, et pour la nourriture de vos petits enfants. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Et ils dirent: Tu nous as sauvé la vie! Que nous trouvions grâce aux yeux de mon seigneur, et nous serons esclaves de Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Et Joseph en fit une loi, qui dure jusqu'à ce jour, sur les terres d'Égypte: Le cinquième à Pharaon. Il n'y eut que les terres des prêtres qui ne furent point à Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israël habita donc au pays d'Égypte, au pays de Gossen; et ils y acquirent des propriétés, et ils s'accrurent, et multiplièrent beaucoup. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Et Jacob vécut au pays d'Égypte dix-sept ans. Et les jours de Jacob, les années de sa vie, furent de cent quarante-sept ans. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Et quand le jour de la mort d'Israël approcha, il appela son fils Joseph, et lui dit: Si j'ai trouvé grâce à tes y eux, mets, je te prie, ta main sous ma cuisse, et use envers moi de bonté et de fidélité: je te prie, ne m'enterre point en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Quand je serai couché avec mes pères, emporte-moi d'Égypte, et enterre-moi dans leur tombeau. Et il répondit: Je ferai selon ta parole. ");
INSERT INTO fra_fob_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Il dit: Jure-le-moi. Et il le lui jura. Et Israël se prosterna sur le chevet du lit. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Or, il arriva après ces choses, qu'on dit à Joseph: Voici, ton père est malade. Alors il prit ses deux fils avec lui, Manassé et Éphraïm. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","On le fit savoir à Jacob, et on lui dit: Voici ton fils Joseph qui vient vers toi. Alors Israël rassembla ses forces, et s'assit sur son lit. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Et Jacob dit à Joseph: Le Dieu Tout-Puissant m'apparut à Luz, au pays de Canaan, et me bénit; ");
INSERT INTO fra_fob_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Et il me dit: Voici, je te ferai croître et multiplier, je te ferai devenir une assemblée de peuples, et je donnerai ce pays à ta postérité après toi, en possession perpétuelle. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Et maintenant tes deux fils qui te sont nés au pays d'Égypte, avant que je vinsse vers toi en Égypte, sont à moi. Éphraïm et Manassé seront à moi comme Ruben et Siméon. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mais les enfants que tu auras engendrés après eux, seront à toi; ils seront appelés du nom de leurs frères dans leur héritage. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Pour moi, quand je revenais de Paddan, Rachel mourut auprès de moi, au pays de Canaan, en chemin, lorsqu'il y avait encore quelque distance pour arriver à Éphrath, et je l'enterrai là sur le chemin d'Éphrath (qui est Béthléem). ");
INSERT INTO fra_fob_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Et Israël vit les fils de Joseph, et dit: Qui sont ceux-ci? ");
INSERT INTO fra_fob_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Et Joseph répondit à son père: Ce sont mes fils, que Dieu m'a donnés ici. Alors il dit: Amène-les-moi, je te prie, afin que je les bénisse. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Or, les yeux d'Israël étaient appesantis de vieillesse; il ne pouvait plus voir. Il les fit approcher de lui, et il les baisa et les embrassa. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Et Israël dit à Joseph: Je ne croyais plus voir ton visage, et voici, Dieu m'a fait voir même ta postérité. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Et Joseph les retira d'entre les genoux de son père, et il se prosterna le visage contre terre. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Puis Joseph les prit tous deux, Éphraïm de sa main droite, à la gauche d'Israël, et Manassé de sa main gauche, à la droite d'Israël, et il les fit approcher de lui. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Et Israël avança sa main droite, et la mit sur la tête d'Éphraïm, qui était le cadet, et sa main gauche sur la tête de Manassé. Il posa ainsi ses mains de propos délibéré, car Manassé était l'aîné. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Et il bénit Joseph, et dit: Que le Dieu, devant la face duquel ont marché mes pères, Abraham et Isaac, le Dieu qui a été mon berger depuis que j'existe jusqu'à ce jour, ");
INSERT INTO fra_fob_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Que l'ange qui m'a délivré de tout mal, bénisse ces enfants, et qu'ils portent mon nom et le nom de mes pères Abraham et Isaac, et qu'ils multiplient très abondamment sur la terre! ");
INSERT INTO fra_fob_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Mais Joseph vit que son père mettait sa main droite sur la tête d'Éphraïm, et il en eut du déplaisir; il saisit la main de son père pour la détourner de la tête d'Éphraïm, sur la tête de Manassé. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Et Joseph dit à son père: Pas ainsi, mon père; car celui-ci est l'aîné, mets ta main droite sur sa tête. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Mais son père refusa, et dit: Je le sais, mon fils, je le sais. Lui aussi deviendra un peuple, lui aussi sera grand; toutefois son frère, le cadet, sera plus grand que lui, et sa postérité sera une multitude de nations. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Et en ce jour-là il les bénit et dit: Israël bénira par toi, en disant: Dieu te rende tel qu'Éphraïm et Manassé! Il mit donc Éphraïm avant Manassé. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Et Israël dit à Joseph: Voici, je vais mourir, mais Dieu sera avec vous, et vous fera retourner au pays de vos pères. ");
INSERT INTO fra_fob_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Et je te donne une portion de plus qu'à tes frères, celle que j'ai prise de la main de l'Amoréen, avec mon épée et mon arc. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Et Jacob appela ses fils, et dit: Assemblez-vous, et je vous déclarerai ce qui vous arrivera dans la suite des jours. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Assemblez-vous et écoutez, fils de Jacob, écoutez Israël, votre père. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, tu es mon premier-né, ma force, et les prémices de ma vigueur, prééminence de dignité et prééminence de puissance. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Bouillonnant comme l'eau, tu n'auras point la prééminence, car tu es monté sur la couche de ton père. Tu as souillé mon lit en y montant. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Siméon et Lévi sont frères. Leurs glaives sont des instruments de violence. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Que mon âme n'entre point dans leur conseil; que ma gloire ne se joigne point à leur assemblée; car dans leur colère ils ont tué des hommes, et dans leur caprice ils ont coupé les jarrets des taureaux. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maudite soit leur colère, car elle fut violente; et leur fureur, car elle fut cruelle! Je les diviserai en Jacob, et les disperserai en Israël. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Toi, Juda, tes frères te loueront; ta main sera sur le cou de tes ennemis; les fils de ton père se prosterneront devant toi. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda est un jeune lion. Tu es revenu du butin, mon fils! Il s'est courbé, il s'est couché comme un lion, comme un vieux lion; qui le fera lever? ");
INSERT INTO fra_fob_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Le sceptre ne s'écartera point de Juda, ni le bâton de législateur d'entre ses pieds, jusqu'à ce que vienne le Silo (repos, pacificateur); à lui, l'obéissance des peuples! ");
INSERT INTO fra_fob_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Il attache à la vigne son ânon, et au cep choisi le petit de son ânesse; il lavera son vêtement dans le vin, et son manteau dans le sang des raisins. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Il a les yeux brillants de vin, et les dents blanches de lait. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulon habitera au rivage des mers; il sera au rivage des navires, et sa côte s'étendra vers Sidon. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issacar est un âne robuste couché entre les barres des étables. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Il a vu que le repos était bon, et que le pays était délicieux; et il a baissé son épaule pour porter, et s'est assujetti au tribut. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan jugera son peuple, comme l'une des tribus d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Que Dan soit un serpent sur le chemin, un céraste dans le sentier, mordant les pâturons du cheval, et celui qui le monte tombe à la renverse. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","J'ai attendu ton salut, ô Éternel! ");
INSERT INTO fra_fob_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad! des troupes l'attaqueront; mais lui, il attaquera leur arrière-garde. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","D'Asser viendra le pain savoureux, et il fournira les délices royales. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nephthali est une biche élancée; il prononce d'élégantes paroles. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph est le rameau d'un arbre fertile, le rameau d'un arbre fertile près d'une source; ses branches ont couvert la muraille. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Des archers l'ont harcelé, lui ont lancé des traits et l'ont attaqué. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mais son arc est demeuré ferme, et ses bras et ses mains ont été renforcés par les mains du Puissant de Jacob, du lieu où réside le Berger, le Rocher d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","C'est l'ouvrage du Dieu de ton père, qui t'aidera, et du Tout-Puissant qui te bénira, des bénédictions des cieux en haut, des bénédictions de l'abîme qui repose en bas, des bénédictions des mamelles et du sein maternel. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Les bénédictions de ton père surpassent les bénédictions de ceux qui m'ont engendré. Jusqu'au terme des collines éternelles, elles seront sur la tête de Joseph, sur le front du prince de ses frères. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin est un loup qui déchire; au matin il dévore la proie, et sur le soir il partage le butin. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Tous ceux-là sont les chefs des douze tribus d'Israël, et c'est ce que leur dit leur père en les bénissant; il bénit chacun d'eux de la bénédiction qui lui était propre. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Et il commanda, et leur dit: Je vais être recueilli vers mon peuple; enterrez-moi auprès de mes pères dans la caverne qui est au champ d'Éphron le Héthien, ");
INSERT INTO fra_fob_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Dans la caverne qui est au champ de Macpéla, qui est en face de Mamré, au pays de Canaan, laquelle Abraham acquit d'Éphron Héthien, avec le champ, en propriété sépulcrale. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","C'est là qu'on a enterré Abraham et Sara, sa femme; c'est là qu'on a enterré Isaac et Rébecca, sa femme; et c'est là que j'ai enterré Léa. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","L'acquisition du champ et de la caverne qui y est, a été faite des enfants de Heth. ");
INSERT INTO fra_fob_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Et quand Jacob eut achevé de donner ses ordres à ses fils, il retira ses pieds dans le lit, et expira, et fut recueilli vers ses peuples. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Alors Joseph se jeta sur le visage de son père, et pleura sur lui, et le baisa. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Et Joseph commanda à ses serviteurs, aux médecins, d'embaumer son père; et les médecins embaumèrent Israël. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Et quarante jours y furent employés; car c'est le nombre de jours qu'on met à embaumer. Et les Égyptiens le pleurèrent soixante et dix jours. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Quand les jours de son deuil furent passés, Joseph parla à ceux de la maison de Pharaon, en disant: Si j'ai trouvé grâce à vos yeux, faites entendre, je vous prie, à Pharaon, ces paroles: ");
INSERT INTO fra_fob_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mon père m'a fait jurer, en disant: Voici, je vais mourir; tu m'enseveliras dans mon tombeau que je me suis acquis au pays de Canaan. Maintenant donc, que j'y monte, je te prie, et que j'ensevelisse mon père; et je reviendrai. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Et Pharaon répondit: Monte, et ensevelis ton père, comme il te l'a fait jurer. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Alors Joseph monta pour ensevelir son père; avec lui montèrent tous les serviteurs de Pharaon, anciens de sa maison, et tous les anciens du pays d'Égypte, ");
INSERT INTO fra_fob_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Et toute la maison de Joseph, ses frères, et la maison de son père; ils ne laissèrent dans le pays de Gossen que leurs petits enfants, leurs brebis et leurs bœufs, ");
INSERT INTO fra_fob_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Il monta aussi avec lui des chars et des cavaliers, et le camp fut très considérable. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ils vinrent jusqu'à l'aire d'Atad, qui est au delà du Jourdain, et ils y firent de très grandes et extraordinaires lamentations; et Joseph fit à son père un deuil de sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Et les Cananéens, habitants du pays, voyant ce deuil dans l'aire d'Atad, dirent: Voilà un grand deuil parmi les Égyptiens. C'est pourquoi on l'a nommée Abel-Mitsraïm (deuil des Égyptiens); elle est au delà du Jourdain. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Les fils de Jacob firent donc ainsi à son égard, comme il leur avait commandé. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ils le transportèrent au pays de Canaan, et l'ensevelirent dans la caverne du champ de Macpéla, qu'Abraham avait acquise d'Éphron le Héthien, avec le champ, en propriété sépulcrale, en face de Mamré. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Et après que Joseph eut enseveli son père, il retourna en Égypte avec ses frères et tous ceux qui étaient montés avec lui pour ensevelir son père. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Mais les frères de Joseph, voyant que leur père était mort, se dirent: Peut-être que Joseph nous prendra en aversion, et nous rendra tout le mal que nous lui avons fait. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Alors ils envoyèrent dire à Joseph: Ton père a donné cet ordre avant de mourir: ");
INSERT INTO fra_fob_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Vous parlerez ainsi à Joseph: Oh! pardonne, je te prie, le crime de tes frères et leur péché; car ils t'ont fait du mal; mais maintenant, pardonne, je te prie, le crime des serviteurs du Dieu de ton père. Et Joseph pleura pendant qu'on lui parlait. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Et ses frères vinrent eux-mêmes, se jetèrent à ses pieds, et dirent: Voici, nous sommes tes serviteurs. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Et Joseph leur dit: Ne craignez point; car suis-je à la place de Dieu? ");
INSERT INTO fra_fob_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Vous aviez pensé à me faire du mal; mais Dieu l'a pensé en bien, pour faire ce qui arrive aujourd'hui, pour conserver la vie à un peuple nombreux. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Soyez donc sans crainte; je vous entretiendrai, vous et vos enfants. Et il les consola, et parla à leur cœur. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph demeura donc en Égypte, lui et la maison de son père, et il vécut cent dix ans. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Et Joseph vit les enfants d'Éphraïm jusqu'à la troisième génération. Les enfants de Makir, fils de Manassé, naquirent aussi sur les genoux de Joseph. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Puis Joseph dit à ses frères: Je vais mourir; mais Dieu ne manquera pas de vous visiter, et il vous fera remonter de ce pays, au pays qu'il a promis par serment à Abraham, à Isaac et à Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Et Joseph fit jurer les enfants d'Israël, en disant: Certainement Dieu vous visitera; et vous transporterez mes os d'ici. ");
INSERT INTO fra_fob_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Puis Joseph mourut, âgé de cent dix ans; et on l'embauma, et on le mit dans un cercueil en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Or, voici les noms des fils d'Israël qui vinrent en Égypte avec Jacob. Ils y vinrent chacun avec sa famille. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Siméon, Lévi et Juda, ");
INSERT INTO fra_fob_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issacar, Zabulon et Benjamin, ");
INSERT INTO fra_fob_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan et Nephtali, Gad et Asser. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Toutes les personnes issues de Jacob étaient soixante et dix; et Joseph était en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Or Joseph mourut, ainsi que tous ses frères, et toute cette génération. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Et les enfants d'Israël s'accrurent et foisonnèrent, et se multiplièrent et devinrent très puissants; et le pays en fut rempli. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Mais il s'éleva sur l'Égypte un nouveau roi, qui n'avait point connu Joseph. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Et il dit à son peuple: Voici, le peuple des enfants d'Israël est plus grand et plus puissant que nous; ");
INSERT INTO fra_fob_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Allons! agissons prudemment avec lui, de peur qu'il ne s'accroisse, et que s'il arrive quelque guerre, il ne se joigne aussi à nos ennemis, ne combatte contre nous, et ne monte hors du pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ils établirent donc sur lui des chefs de corvées, pour l'accabler par leurs travaux; et il bâtit pour Pharaon des villes de munitions, Pithom et Ramsès. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mais plus ils l'accablaient, plus il multipliait et se répandait; et ils prirent peur des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Et les Égyptiens firent servir les enfants d'Israël avec rigueur; ");
INSERT INTO fra_fob_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Et ils leur rendirent la vie amère, par un rude travail à l'argile et aux briques, et par toutes sortes de travaux des champs, ainsi que tous les services qu'ils leur imposaient avec rigueur. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Le roi d'Égypte parla aussi aux sages-femmes des Hébreux, dont l'une s'appelait Shiphra, et l'autre Pua, ");
INSERT INTO fra_fob_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Et il dit: Quand vous accoucherez les femmes des Hébreux, et que vous les verrez sur les sièges, si c'est un fils, vous le ferez mourir; mais si c'est une fille, qu'elle vive. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mais les sages-femmes craignirent Dieu, et ne firent pas ce que le roi d'Égypte leur avait dit; et elles laissèrent vivre les garçons. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Alors le roi d'Égypte appela les sages-femmes, et leur dit: Pourquoi avez-vous fait ainsi, et avez-vous laissé vivre les garçons? ");
INSERT INTO fra_fob_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Et les sages-femmes répondirent à Pharaon: C'est que les femmes des Hébreux ne sont point comme les Égyptiennes, car elles sont vigoureuses; avant que la sage-femme arrive auprès d'elles, elles ont accouché. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Et Dieu fit du bien aux sages-femmes; et le peuple se multiplia et devint très nombreux. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Et parce que les sages-femmes craignirent Dieu, il fit prospérer leurs maisons. ");
INSERT INTO fra_fob_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Alors Pharaon donna cet ordre à tout son peuple: Jetez dans le fleuve tous les fils qui naîtront, mais laissez vivre toutes les filles. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Or, un homme de la maison de Lévi alla prendre pour femme une fille de Lévi. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Et cette femme conçut, et enfanta un fils; et, voyant qu'il était beau, elle le cacha trois mois. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Mais, ne pouvant le tenir caché plus longtemps, elle prit un coffret de joncs, et l'enduisit de bitume et de poix; ensuite elle y mit l'enfant, et le posa dans les roseaux sur la rive du fleuve. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Et sa sœur se tint là, à distance, pour savoir ce qui lui arriverait. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Or, la fille de Pharaon descendit au fleuve pour se baigner; et ses femmes se promenaient sur le bord du fleuve; et elle vit le coffret au milieu des roseaux, et envoya sa servante pour le prendre. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Et elle l'ouvrit et vit l'enfant; et voici, c'était un petit garçon, qui pleurait. Elle en fut touchée de compassion, et dit: C'est un des enfants des Hébreux. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Alors la sœur de l'enfant dit à la fille de Pharaon: Irai-je t'appeler une nourrice d'entre les femmes des Hébreux, et elle t'allaitera cet enfant? ");
INSERT INTO fra_fob_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Et la fille de Pharaon lui répondit: Va. Et la jeune fille s'en alla, et appela la mère de l'enfant. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","La fille de Pharaon lui dit: Emporte cet enfant et allaite-le-moi, et je te donnerai ton salaire. Et la femme prit l'enfant, et l'allaita. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Et quand l'enfant eut grandi, elle l'amena à la fille de Pharaon, qui l'adopta pour son fils; et elle le nomma Moïse (sauvé des eaux), parce que, dit-elle, je l'ai retiré des eaux. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Or il arriva, en ces jours-là, lorsque Moïse fut devenu grand, qu'il sortit vers ses frères, et vit leurs durs travaux. Il vit aussi un Égyptien qui frappait un Hébreu d'entre ses frères; ");
INSERT INTO fra_fob_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Alors il regarda çà et là, et voyant qu'il n'y avait personne, il tua l'Égyptien, et le cacha dans le sable. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Et il sortit le second jour, et voici, deux hommes hébreux se querellaient, et il dit à celui qui avait tort: Pourquoi frappes-tu ton prochain? ");
INSERT INTO fra_fob_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mais il répondit: Qui t'a établi prince et juge sur nous? Est-ce que tu veux me tuer, comme tu as tué l'Égyptien? Et Moïse craignit, et il dit: Certainement, le fait est connu. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Or, Pharaon, ayant appris ce fait, chercha à faire mourir Moïse. Mais Moïse s'enfuit de devant Pharaon, et s'arrêta au pays de Madian, et il s'assit auprès d'un puits. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Or, le sacrificateur de Madian avait sept filles, qui vinrent puiser de l'eau et remplir les auges, pour abreuver le troupeau de leur père. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mais les bergers vinrent, et les chassèrent. Alors Moïse se leva et les secourut, et abreuva leur troupeau. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Et quand elles furent revenues chez Réuël leur père, il leur dit: Pourquoi êtes-vous revenues sitôt aujourd'hui? ");
INSERT INTO fra_fob_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Elles répondirent: Un homme égyptien nous a délivrées de la main des bergers, et même il nous a puisé de l'eau abondamment, et a abreuvé le troupeau. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Alors il dit à ses filles: Et où est-il? Pourquoi avez-vous laissé cet homme? Appelez-le, et qu'il mange du pain. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Et Moïse consentit à demeurer avec cet homme, qui donna Séphora, sa fille, à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Et elle enfanta un fils, et il le nomma Guershom (étranger là), car, dit-il, j'ai séjourné dans un pays étranger. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Or, il arriva, longtemps après, que le roi d'Égypte mourut; et les enfants d'Israël, qui gémissaient à cause de la servitude, crièrent, et le cri de leur servitude monta vers Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Et Dieu entendit leurs gémissements; et Dieu se souvint de son alliance avec Abraham, avec Isaac, et avec Jacob. ");
INSERT INTO fra_fob_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Et Dieu regarda les enfants d'Israël, et Dieu connut leur état. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Or, Moïse paissait le troupeau de Jéthro, son beau-père, sacrificateur de Madian; et il mena le troupeau derrière le désert, et vint à la montagne de Dieu, à Horeb. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Et l'ange de l'Éternel lui apparut dans une flamme de feu, du milieu d'un buisson; et il regarda, et voici, le buisson était tout en feu; mais le buisson ne se consumait point. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Alors Moïse dit: Je me détournerai, et je verrai cette grande vision, et pourquoi le buisson ne se consume point. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Et l'Éternel vit qu'il se détournait pour regarder; et Dieu l'appela du milieu du buisson, et dit: Moïse, Moïse! ");
INSERT INTO fra_fob_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Et il répondit: Me voici! Et Dieu dit: N'approche point d'ici. Ote tes souliers de tes pieds; car le lieu où tu te tiens, est une terre sainte. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Puis il dit: Je suis le Dieu de ton père, le Dieu d'Abraham, le Dieu d'Isaac, et le Dieu de Jacob. Et Moïse cacha son visage, car il craignait de regarder vers Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Et l'Éternel dit: J'ai bien vu l'affliction de mon peuple qui est en Égypte, et j'ai entendu le cri qu'il jette à cause de ses exacteurs; car je connais ses douleurs. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Et je suis descendu pour le délivrer de la main des Égyptiens, et pour le faire monter de ce pays-là dans un pays bon et spacieux, dans un pays où coulent le lait et le miel, au lieu où sont les Cananéens, les Héthiens, les Amoréens, les Phéréziens, les Héviens et les Jébusiens. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Et maintenant, voici, le cri des enfants d'Israël est venu jusqu'à moi, et j'ai vu aussi l'oppression dont les Égyptiens les accablent. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Maintenant donc, viens, que je t'envoie vers Pharaon, et fais sortir mon peuple, les enfants d'Israël, hors d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Alors Moïse répondit à Dieu: Qui suis-je, pour aller vers Pharaon, et pour faire sortir d'Égypte les enfants d'Israël? ");
INSERT INTO fra_fob_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Et Dieu dit: Je serai avec toi. Et voici pour toi le signe que c'est moi qui t'envoie: Quand tu auras fait sortir d'Égypte le peuple, vous servirez Dieu sur cette montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Et Moïse dit à Dieu: Voici, j'irai vers les enfants d'Israël, et je leur dirai: Le Dieu de vos pères m'a envoyé vers vous; mais s'ils me disent: Quel est son nom? que leur dirais-je? ");
INSERT INTO fra_fob_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Alors Dieu dit à Moïse: JE SUIS CELUI QUI SUIS. Puis il dit: Tu diras ainsi aux enfants d'Israël: Celui qui s'appelle JE SUIS, m'a envoyé vers vous. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Dieu dit encore à Moïse: Tu diras ainsi aux enfants d'Israël: L'ÉTERNEL, le Dieu de vos pères, le Dieu d'Abraham, le Dieu d'Isaac, et le Dieu de Jacob m'a envoyé vers vous. C'est là mon nom éternellement; c'est là ma commémoration dans tous les âges. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Va, et assemble les anciens d'Israël, et dis-leur: L'Éternel, le Dieu de vos pères m'est apparu, le Dieu d'Abraham, d'Isaac, et de Jacob, et m'a dit: Certainement, je vous ai visités, et j'ai vu ce qu'on vous fait en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Et j'ai dit: Je vous ferai remonter de l'affliction de l'Égypte, au pays des Cananéens, des Héthiens, des Amoréens, des Phéréziens, des Héviens et des Jébusiens, dans un pays où coulent le lait et le miel. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Et ils obéiront à ta voix; et tu iras, toi et les anciens d'Israël, vers le roi d'Égypte, et vous lui direz: L'Éternel, le Dieu des Hébreux, est venu au-devant de nous. Maintenant donc laisse-nous aller le chemin de trois jours au désert, et sacrifier à l'Éternel notre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Or, je sais que le roi d'Égypte ne vous permettra point de vous en aller, pas même contraint par une main forte. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Mais j'étendrai ma main, et je frapperai l'Égypte par toutes mes merveilles que je ferai au milieu d'elle; et après cela, il vous laissera aller. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Et je ferai trouver grâce à ce peuple aux yeux des Égyptiens, et il arrivera, quand vous partirez, que vous ne vous en irez point à vide. ");
INSERT INTO fra_fob_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Mais chaque femme demandera à sa voisine, et à l'hôtesse de sa maison, des objets d'argent et d'or, et des vêtements; vous les mettrez sur vos fils et sur vos filles, et vous dépouillerez ainsi les Égyptiens. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Et Moïse répondit, et dit: Mais voici, ils ne me croiront point, et ils n'obéiront point à ma voix; car ils diront: L'Éternel ne t'est point apparu. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Et l'Éternel lui dit: Qu'as-tu à la main? Il répondit: Une verge. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Et il dit: Jette-la par terre; et il la jeta par terre, et elle devint un serpent; et Moïse s'enfuit devant lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Alors l'Éternel dit à Moïse: Étends ta main et saisis-le par la queue. Il étendit la main, et le saisit, et il redevint une verge dans sa main. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","C'est afin, dit l'Éternel, qu'ils croient que l'Éternel, le Dieu de leurs pères, le Dieu d'Abraham, le Dieu d'Isaac, et le Dieu de Jacob t'est apparu. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","L'Éternel lui dit encore: Mets ta main dans ton sein. Et il mit sa main dans son sein; puis il la retira, et, voici, sa main était blanche de lèpre comme la neige. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Puis Dieu dit: Remets ta main dans ton sein. Et il remit sa main dans son sein; puis il la retira de son sein, et voici, elle était redevenue comme son autre chair. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Et il arrivera, s'ils ne te croient point, et n'obéissent point à la voix du premier signe, qu'ils croiront à la voix du signe suivant. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Et s'ils ne croient pas même à ces deux signes et n'obéissent pas à ta voix, tu prendras de l'eau du fleuve et la répandras sur la terre, et l'eau que tu auras prise du fleuve, deviendra du sang sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Et Moïse dit à l'Éternel: Ah! Seigneur, je ne suis point un homme qui ait la parole aisée, ni d'hier, ni d'avant-hier, ni depuis que tu parles à ton serviteur; car j'ai la bouche et la langue pesantes. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Et l'Éternel lui dit: Qui a fait la bouche de l'homme? Ou qui rend muet, ou sourd, ou voyant, ou aveugle? N'est-ce pas moi, l'Éternel? ");
INSERT INTO fra_fob_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Maintenant donc, va et je serai avec ta bouche, et je t'enseignerai ce que tu devras dire. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Et Moïse répondit: Ah! Seigneur, envoie qui tu voudras envoyer. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Et la colère de l'Éternel s'embrasa contre Moïse, et il dit: Aaron, le Lévite, n'est-il pas ton frère? Je sais qu'il parlera très bien. Et même, le voici qui sort à ta rencontre, et quand il te verra, il se réjouira dans son cœur. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tu lui parleras donc, et tu mettras les paroles dans sa bouche; et je serai avec ta bouche et avec la sienne, et je vous enseignerai ce que vous devrez faire. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","C'est lui qui parlera pour toi au peuple; il sera ta bouche, et tu lui seras Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Et tu prendras dans ta main cette verge, par laquelle tu feras les signes. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Alors Moïse s'en alla, et retourna vers Jéthro son beau-père, et lui dit: Que je m'en aille, je te prie, et que je retourne vers mes frères qui sont en Égypte, pour voir s'ils sont encore vivants. Et Jéthro dit à Moïse: Va en paix! ");
INSERT INTO fra_fob_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Or, l'Éternel dit à Moïse, en Madian: Va, retourne en Égypte; car tous ceux qui en voulaient à ta vie, sont morts. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Alors Moïse prit sa femme et ses fils, les fit monter sur un âne, et retourna au pays d'Égypte. Et Moïse prit la verge de Dieu dans sa main. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Et l'Éternel dit à Moïse: En t'en allant pour retourner en Égypte, considère tous les miracles que j'ai mis dans ta main, et tu les feras devant Pharaon; mais j'endurcirai son cœur, et il ne laissera point aller le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Et tu diras à Pharaon: Ainsi a dit l'Éternel: Israël est mon fils, mon premier-né; ");
INSERT INTO fra_fob_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Et je t'ai dit: Laisse aller mon fils, afin qu'il me serve; et tu as refusé de le laisser aller. Voici, je vais faire mourir ton fils, ton premier-né. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Or, il arriva qu'en chemin, dans l'hôtellerie, l'Éternel rencontra Moïse, et chercha à le faire mourir. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Et Séphora prit un couteau de pierre, et coupa le prépuce de son fils, et le jeta à ses pieds, et dit: Certes, tu m'es un époux de sang! ");
INSERT INTO fra_fob_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Et l'Éternel le laissa. Elle dit alors: Époux de sang! à cause de la circoncision. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Et l'Éternel dit à Aaron: Va au-devant de Moïse, au désert. Il alla donc et le rencontra à la montagne de Dieu, et il le baisa. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Et Moïse rapporta à Aaron toutes les paroles avec lesquelles l'Éternel l'avait envoyé, et tous les prodiges qu'il lui avait commandé de faire. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moïse s'en alla donc avec Aaron; et ils assemblèrent tous les anciens des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Et Aaron dit toutes les paroles que l'Éternel avait dites à Moïse, et il fit les prodiges aux yeux du peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Et le peuple crut; et ils apprirent que l'Éternel avait visité les enfants d'Israël, et qu'il avait vu leur affliction; et ils s'inclinèrent et adorèrent. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Après cela, Moïse et Aaron vinrent et dirent à Pharaon: Ainsi a dit l'Éternel, le Dieu d'Israël: Laisse aller mon peuple, afin qu'il me célèbre une fête au désert. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mais Pharaon dit: Qui est l'Éternel, pour que j'obéisse à sa voix en laissant aller Israël? Je ne connais point l'Éternel, et je ne laisserai pas non plus aller Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Et ils dirent: Le Dieu des Hébreux est venu au-devant de nous; permets-nous d'aller le chemin de trois jours dans le désert, pour que nous sacrifiions à l'Éternel notre Dieu, de peur qu'il ne nous frappe par la peste ou par l'épée. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Et le roi d'Égypte leur dit: Moïse et Aaron, pourquoi détournez-vous le peuple de son ouvrage? Allez à vos travaux. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Et Pharaon dit: Voici, le peuple du pays est maintenant en grand nombre, et vous les faites chômer de leur travail ");
INSERT INTO fra_fob_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Pharaon donna ordre ce jour-là aux exacteurs établis sur le peuple, et à ses commissaires, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Vous ne donnerez plus de paille au peuple pour faire les briques, comme auparavant; qu'ils aillent eux-mêmes, et qu'ils s'amassent de la paille. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Mais vous leur imposerez la quantité de briques qu'ils faisaient auparavant; vous n'en retrancherez rien, car ils sont paresseux; c'est pour cela qu'ils crient, en disant: Allons sacrifier à notre Dieu! ");
INSERT INTO fra_fob_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Qu'on accable ces gens de travail, et qu'ils s'y occupent, et ne regardent point à des paroles de mensonge. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Alors les exacteurs du peuple et ses commissaires sortirent, et dirent au peuple: Ainsi a dit Pharaon: Je ne vous donne plus de paille. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Allez vous-mêmes, prenez de la paille où vous en trouverez, car on ne retranchera rien de votre travail. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Alors le peuple se répandit par tout le pays d'Égypte, afin d'amasser du chaume pour tenir lieu de paille. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Et les exacteurs les pressaient, en disant: Achevez votre ouvrage, chaque jour la quantité fixée, comme quand il y avait de la paille. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Et les commissaires des enfants d'Israël, que les exacteurs de Pharaon avaient établis sur eux, furent battus, et on leur disait: Pourquoi n'avez-vous point achevé votre tâche, en faisant des briques, hier et aujourd'hui, comme auparavant? ");
INSERT INTO fra_fob_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Alors les commissaires des enfants d'Israël vinrent et crièrent à Pharaon, en disant: Pourquoi agis-tu ainsi à l'égard de tes serviteurs? ");
INSERT INTO fra_fob_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","On ne donne point de paille à tes serviteurs, et l'on nous dit: Faites des briques! Et voici, tes serviteurs sont battus et ton peuple est en faute. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Et il répondit: Vous êtes des paresseux, des paresseux! C'est pour cela que vous dites: Allons sacrifier à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Or, maintenant, allez, travaillez; et l'on ne vous donnera point de paille; et vous fournirez la même quantité de briques. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Les commissaires des enfants d'Israël se virent donc dans la peine, parce qu'on leur dit: Vous ne retrancherez rien de vos briques; chaque jour, la quantité fixée. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Et ils rencontrèrent Moïse et Aaron qui les attendaient, à leur sortie d'auprès de Pharaon; ");
INSERT INTO fra_fob_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Et ils leur dirent: Que l'Éternel vous regarde, et qu'il juge! vous nous avez mis en mauvaise odeur devant Pharaon et devant ses serviteurs, en leur mettant une épée à la main pour nous tuer. ");
INSERT INTO fra_fob_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Alors Moïse se tourna vers l'Éternel, et dit: Seigneur, pourquoi as-tu fait du mal à ce peuple? Pourquoi donc m'as-tu envoyé, ");
INSERT INTO fra_fob_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Puisque depuis que je suis venu vers Pharaon, pour parler en ton nom, il a maltraité ce peuple, et tu n'as point délivré ton peuple? ");
INSERT INTO fra_fob_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Et l'Éternel dit à Moïse: Maintenant tu verras ce que je ferai à Pharaon; car il les laissera aller, contraint par une main forte; et, contraint par une main forte, il les chassera de son pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Et Dieu parla à Moïse, et lui dit: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Je suis apparu à Abraham, à Isaac, et à Jacob, comme le Dieu Tout-Puissant; mais sous mon nom, l'Éternel, je n'ai point été connu d'eux. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Et j'ai aussi établi mon alliance avec eux, pour leur donner le pays de Canaan, le pays dans lequel ils ont séjourné comme étrangers. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","J'ai aussi entendu les gémissements des enfants d'Israël, que les Égyptiens tiennent esclaves; et je me suis souvenu de mon alliance. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","C'est pourquoi, dis aux enfants d'Israël: Je suis l'Éternel, je vous retirerai de dessous les fardeaux d'Égypte; je vous délivrerai de leur servitude, et je vous rachèterai à bras étendu, et par de grands jugements. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Je vous prendrai pour mon peuple, et je vous serai Dieu, et vous connaîtrez que je suis l'Éternel votre Dieu, qui vous retire de dessous les fardeaux de l'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Et je vous ferai entrer au pays au sujet duquel j'ai levé ma main que je le donnerais à Abraham, à Isaac, et à Jacob; et je vous le donnerai en héritage: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Moïse parla donc ainsi aux enfants d'Israël; mais ils n'écoutèrent point Moïse, par impatience et à cause de leur dure servitude. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Va, parle à Pharaon, roi d'Égypte, et qu'il laisse sortir les enfants d'Israël de son pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Alors Moïse parla devant l'Éternel, et dit: Voici, les enfants d'Israël ne m'ont pas écouté; et comment Pharaon m'écoutera-t-il, moi qui suis incirconcis de lèvres? ");
INSERT INTO fra_fob_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","L'Éternel parla donc à Moïse et à Aaron, et leur ordonna d'aller trouver les enfants d'Israël, et Pharaon, roi d'Égypte, pour retirer les enfants d'Israël du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Voici les chefs des maisons de leurs pères. Les fils de Ruben, premier-né d'Israël: Hénoc et Pallu, Hetsron et Carmi. Voilà les familles de Ruben. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Les fils de Siméon: Jémuël, Jamin, Ohad, Jakin, Tsochar et Saül, fils de la Cananéenne. Voilà les familles de Siméon. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Et voici les noms des fils de Lévi, selon leurs générations: Guershon, Kéhath et Mérari. Et les années de la vie de Lévi furent de cent trente-sept ans. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Les fils de Guershon: Libni et Shimei, selon leurs familles. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Les fils de Kéhath: Amram, Jitsehar, Hébron et Uziel. Et les années de la vie de Kéhath furent de cent trente-trois ans. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Les fils de Mérari: Machli et Mushi. Voilà les familles de Lévi, selon leurs générations. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Or, Amram prit pour femme Jokébed, sa tante, et elle lui enfanta Aaron et Moïse. Et les années de la vie d'Amram furent de cent trente-sept ans. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Les fils de Jitsehar: Coré, Népheg et Zicri. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Les fils d'Uziel: Mishaël, Eltsaphan et Sithri. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Et Aaron épousa Elishéba, fille d'Amminadab, sœur de Nahashon, et elle lui enfanta Nadab, Abihu, Éléazar et Ithamar. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Les fils de Coré: Assir, Elkana et Abiasaph. Voilà les familles des Corites. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Or, Éléazar, fils d'Aaron, prit pour sa femme une des filles de Puthiel, et elle lui enfanta Phinées. Tels sont les chefs des maisons des pères des Lévites, selon leurs familles. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","C'est cet Aaron et ce Moïse, à qui l'Éternel dit: Retirez les enfants d'Israël du pays d'Égypte, selon leurs armées. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ce sont eux qui parlèrent à Pharaon, roi d'Égypte, pour retirer d'Égypte les enfants d'Israël. C'est ce Moïse et cet Aaron. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Il arriva donc qu'au jour où l'Éternel parla à Moïse, dans le pays d'Égypte, ");
INSERT INTO fra_fob_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","L'Éternel parla à Moïse, en disant: Je suis l'Éternel; dis à Pharaon, roi d'Égypte, tout ce que je te dirai. ");
INSERT INTO fra_fob_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Alors Moïse dit devant l'Éternel: Voici, je suis incirconcis de lèvres; comment Pharaon m'écouterait-il? ");
INSERT INTO fra_fob_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Et l'Éternel dit à Moïse: Vois, je t'ai établi Dieu pour Pharaon, et Aaron, ton frère, sera ton prophète. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Tu diras tout ce que je te commanderai, et Aaron ton frère parlera à Pharaon, pour qu'il laisse aller les enfants d'Israël hors de son pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Mais j'endurcirai le cœur de Pharaon, et je multiplierai mes signes et mes miracles dans le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Et Pharaon ne vous écoutera point; et je mettrai ma main sur l'Égypte, et je retirerai du pays d'Égypte mes armées, mon peuple, les enfants d'Israël, par de grands jugements. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Les Égyptiens sauront que je suis l'Éternel, quand j'étendrai ma main sur l'Égypte, et que je retirerai du milieu d'eux les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moïse et Aaron firent donc comme l'Éternel leur avait commandé; ils firent ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Or, Moïse était âgé de quatre-vingts ans, et Aaron de quatre-vingt-trois ans, quand ils parlèrent à Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Et l'Éternel parla à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Quand Pharaon vous parlera, et dira: Faites un miracle; alors tu diras à Aaron: Prends ta verge et jette-la devant Pharaon; et elle deviendra un serpent. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moïse et Aaron vinrent donc vers Pharaon, et firent ainsi, comme l'Éternel l'avait commandé. Et Aaron jeta sa verge devant Pharaon et devant ses serviteurs, et elle devint un serpent. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mais Pharaon appela aussi les sages et les enchanteurs; et les magiciens d'Égypte firent, eux aussi, la même chose par leurs enchantements. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ils jetèrent donc chacun leur verge, et elles devinrent des serpents; mais la verge d'Aaron engloutit leurs verges. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Et le cœur de Pharaon s'endurcit, et il ne les écouta point, comme l'Éternel l'avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Et l'Éternel dit à Moïse: Le cœur de Pharaon est appesanti; il a refusé de laisser aller le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Va vers Pharaon dès le matin; voici, il sortira vers l'eau; tu te présenteras donc devant lui sur la rive du fleuve, et tu prendras à ta main la verge qui a été changée en serpent. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Et tu lui diras: L'Éternel, le Dieu des Hébreux, m'a envoyé vers toi, en disant: Laisse aller mon peuple, afin qu'il me serve dans le désert; et voici, tu n'as point écouté jusqu'ici. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ainsi a dit l'Éternel: A ceci tu sauras que je suis l'Éternel: Voici, je vais frapper de la verge qui est dans ma main, les eaux qui sont dans le fleuve, et elles seront changées en sang. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Et le poisson qui est dans le fleuve, mourra, et le fleuve se corrompra, et les Égyptiens éprouveront du dégoût à boire des eaux du fleuve. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Puis l'Éternel dit à Moïse: Dis à Aaron: Prends ta verge, et étends ta main sur les eaux des Égyptiens, sur leurs rivières, sur leurs fleuves, et sur leurs étangs, et sur tous leurs amas d'eaux, et qu'elles deviennent du sang; et il y aura du sang par tout le pays d'Égypte, et dans les vases de bois et dans les vases de pierre. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moïse et Aaron firent donc ainsi, comme l'Éternel l'avait commandé. Et Aaron leva la verge, et frappa les eaux qui étaient dans le fleuve, aux yeux de Pharaon et aux yeux de ses serviteurs; et toutes les eaux qui étaient dans le fleuve furent changées en sang. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Et le poisson qui était dans le fleuve mourut, et le fleuve se corrompit, et les Égyptiens ne purent boire des eaux du fleuve; et le sang fut par tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mais les magiciens d'Égypte firent la même chose par leurs enchantements. Et le cœur de Pharaon s'endurcit, et il n'écouta point Moïse et Aaron, comme l'Éternel l'avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Et Pharaon s'en retourna et vint en sa maison, et ne rendit pas même son cœur attentif à tout cela. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Or, tous les Égyptiens creusèrent autour du fleuve pour trouver de l'eau à boire, car ils ne pouvaient pas boire de l'eau du fleuve. ");
INSERT INTO fra_fob_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Et il se passa sept jours, après que l'Éternel eut frappé le fleuve. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Puis l'Éternel dit à Moïse: Va vers Pharaon, et dis-lui: Ainsi a dit l'Éternel: Laisse aller mon peuple, afin qu'il me serve. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Si tu refuses de le laisser aller, voici, je vais frapper du fléau des grenouilles tout ton territoire. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Et le fleuve foisonnera de grenouilles, qui monteront et entreront dans ta maison, et dans la chambre où tu couches, et sur ton lit, et dans la maison de tes serviteurs, et parmi ton peuple, et dans tes fours, et dans tes huches. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Et les grenouilles monteront sur toi, sur ton peuple, et sur tous tes serviteurs. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","L'Éternel dit donc à Moïse: Dis à Aaron: Étends ta main avec ta verge sur les rivières, sur les fleuves, et sur les marais, et fais monter les grenouilles sur le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Et Aaron étendit sa main sur les eaux de l'Égypte; et les grenouilles montèrent, et couvrirent le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Et les magiciens firent la même chose par leurs enchantements, pour faire monter des grenouilles sur le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Alors Pharaon appela Moïse et Aaron, et dit: Intercédez auprès de l'Éternel, pour qu'il éloigne les grenouilles de moi et de mon peuple; et je laisserai aller le peuple, afin qu'il sacrifie à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Et Moïse dit à Pharaon: Glorifie-toi sur moi: Pour quand je dois intercéder en ta faveur, en faveur de tes serviteurs, et de ton peuple, afin d'exterminer les grenouilles loin de toi et de tes maisons, et qu'il n'en reste que dans le fleuve. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Et il répondit: Pour demain. Et Moïse dit: Il sera fait selon ta parole, afin que tu saches que nul n'est semblable à l'Éternel notre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Les grenouilles donc s'éloigneront de toi, et de tes maisons, et de tes serviteurs, et de ton peuple; il n'en restera que dans le fleuve. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Alors Moïse et Aaron sortirent d'auprès de Pharaon. Et Moïse cria à l'Éternel, au sujet des grenouilles qu'il avait fait venir sur Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Et l'Éternel fit selon la parole de Moïse, et les grenouilles périrent dans les maisons, dans les villages et dans les champs. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","On les amassa par monceaux, et la terre en fut infectée. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mais Pharaon, voyant qu'il y avait du relâche, appesantit son cœur, et ne les écouta point, comme l'Éternel l'avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Et l'Éternel dit à Moïse: Dis à Aaron: Étends ta verge et frappe la poussière de la terre, et elle deviendra des poux par tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Et ils firent ainsi: Aaron étendit sa main avec sa verge, et frappa la poussière de la terre, et elle devint des poux sur les hommes et sur les bêtes; toute la poussière du pays devint des poux dans tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Et les magiciens firent la même chose par leurs enchantements pour produire les poux, mais ils ne purent pas. Les poux furent donc sur les hommes et sur les bêtes. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Alors les magiciens dirent à Pharaon: C'est le doigt de Dieu. Mais le cœur de Pharaon s'endurcit, et il ne les écouta point, comme l'Éternel l'avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Puis, l'Éternel dit à Moïse: Lève-toi de bon matin, et présente-toi devant Pharaon. Voici, il sortira vers l'eau; et tu lui diras: Ainsi a dit l'Éternel: Laisse aller mon peuple, afin qu'il me serve. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Car si tu ne laisses pas aller mon peuple, voici, je vais envoyer les insectes sur toi, sur tes serviteurs, sur ton peuple et sur tes maisons; et les maisons des Égyptiens seront remplies d'insectes, et même le sol sur lequel ils sont. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Mais je distinguerai en ce jour-là le pays de Gossen, où se tient mon peuple, pour qu'il n'y ait point là d'insectes, afin que tu saches que moi, l'Éternel, je suis au milieu du pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Et je mettrai une séparation entre mon peuple et ton peuple. Demain ce prodige se fera. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Et l'Éternel fit ainsi; et il vint des insectes en grand nombre dans la maison de Pharaon, et dans la maison de ses serviteurs; et, dans tout le pays d'Égypte, la terre fut dévastée par les insectes. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Alors Pharaon appela Moïse et Aaron, et dit: Allez, sacrifiez à votre Dieu dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mais Moïse dit: Il n'est pas convenable de faire ainsi; car ce que nous sacrifierions à l'Éternel notre Dieu, serait en abomination aux Égyptiens. Voici, si nous offrions, sous leurs yeux, des sacrifices qui sont en abomination aux Égyptiens, ne nous lapideraient-ils pas? ");
INSERT INTO fra_fob_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Nous irons le chemin de trois jours dans le désert, et nous sacrifierons à l'Éternel notre Dieu, comme il nous dira. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Alors Pharaon dit: Je vous laisserai aller pour sacrifier à l'Éternel votre Dieu dans le désert, seulement vous n'irez pas plus loin. Intercédez pour moi. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Et Moïse dit: Voici, je sors d'auprès de toi, et j'intercéderai auprès de l'Éternel; et demain les insectes s'éloigneront de Pharaon, de ses serviteurs, et de son peuple. Seulement que Pharaon ne continue point à tromper, en ne laissant point aller le peuple pour sacrifier à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Alors Moïse sortit d'auprès de Pharaon, et intercéda auprès de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Et l'Éternel fit selon la parole de Moïse, et les insectes s'éloignèrent de Pharaon, de ses serviteurs, et de son peuple; il n'en resta pas un seul. ");
INSERT INTO fra_fob_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mais Pharaon appesantit son cœur encore cette fois, et ne laissa point aller le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Alors l'Éternel dit à Moïse: Va vers Pharaon, et dis-lui: Ainsi a dit l'Éternel, le Dieu des Hébreux: Laisse aller mon peuple, afin qu'il me serve; ");
INSERT INTO fra_fob_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Car si tu refuses de les laisser aller, et si tu les retiens encore, ");
INSERT INTO fra_fob_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Voici, la main de l'Éternel sera sur ton bétail qui est aux champs, sur les chevaux, sur les ânes, sur les chameaux, sur les bœufs et sur les brebis: il y aura une très grande mortalité. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Et l'Éternel distinguera entre le bétail d'Israël et le bétail des Égyptiens, et rien de tout ce qui est aux enfants d'Israël ne mourra. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Et l'Éternel fixa le terme, en disant: Demain l'Éternel fera cela dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","L'Éternel fit donc cela dès le lendemain, et tout le bétail des Égyptiens mourut; mais du bétail des enfants d'Israël il ne mourut pas une seule bête. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Et Pharaon envoya voir, et voici, il n'était pas mort une seule bête du bétail d'Israël. Mais le cœur de Pharaon s'appesantit, et il ne laissa point aller le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Alors l'Éternel dit à Moïse et à Aaron: Prenez plein vos mains de cendre de fournaise, et que Moïse la répande vers les cieux, sous les yeux de Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Et elle deviendra de la poussière sur tout le pays d'Égypte, et elle deviendra, sur les hommes et sur les bêtes, des ulcères bourgeonnant en pustules, dans tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ils prirent donc de la cendre de fournaise, et se tinrent devant Pharaon; et Moïse la répandit vers les cieux, et elle devint, sur les hommes et sur les bêtes, des ulcères bourgeonnant en pustules. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Et les magiciens ne purent se tenir devant Moïse, à cause des ulcères; car les ulcères étaient sur les magiciens comme sur tous les Égyptiens. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Et l'Éternel endurcit le cœur de Pharaon, et il ne les écouta point, comme l'Éternel l'avait dit à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Puis, l'Éternel dit à Moïse: Lève-toi de bon matin, présente-toi devant Pharaon, et dis-lui: Ainsi a dit l'Éternel, le Dieu des Hébreux: Laisse aller mon peuple, afin qu'il me serve; ");
INSERT INTO fra_fob_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Car cette fois, je vais envoyer toutes mes plaies contre ton cœur, et sur tes serviteurs et sur ton peuple, afin que tu saches que nul n'est semblable à moi sur toute la terre. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Car maintenant, si j'avais étendu ma main, et si je t'avais frappé par la mortalité, toi et ton peuple, tu serais effacé de la terre. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mais voici pourquoi je t'ai fait subsister: c'est afin que tu fasses voir ma puissance, et pour que mon nom soit célébré par toute la terre. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Si tu t'élèves encore contre mon peuple, pour ne point le laisser aller, ");
INSERT INTO fra_fob_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Voici je vais faire pleuvoir demain, à cette heure, une si forte grêle, qu'il n'y en a point eu de semblable en Égypte, depuis le jour où elle fut fondée jusqu'à présent. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Maintenant donc, envoie mettre en sûreté ton bétail, et tout ce que tu as aux champs. La grêle tombera sur tous les hommes et les bêtes qui se trouveront aux champs, et qui ne se retireront pas dans les maisons, et ils mourront. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Celui des serviteurs de Pharaon qui craignit la parole de l'Éternel, fit promptement retirer dans les maisons ses serviteurs et son bétail. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mais celui qui ne fit point attention à la parole de l'Éternel, laissa ses serviteurs et son bétail aux champs. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Alors l'Éternel dit à Moïse: Étends ta main vers les cieux, et qu'il y ait de la grêle sur tout le pays d'Égypte, sur les hommes, et sur les bêtes, et sur toute herbe des champs dans le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moïse étendit donc sa verge vers les cieux, et l'Éternel fit tonner et grêler, et le feu se promenait sur la terre. Et l'Éternel fit pleuvoir de la grêle sur le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Et il y eut de la grêle, et un feu continu au milieu de la grêle, qui était si prodigieuse, qu'il n'y en avait point eu de semblable dans tout le pays d'Égypte, depuis qu'il était devenu une nation. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Et la grêle frappa dans tout le pays d'Égypte tout ce qui était aux champs, depuis les hommes jusqu'aux bêtes. La grêle frappa aussi toutes les herbes des champs et brisa tous les arbres des champs. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Le pays de Gossen, où étaient les enfants d'Israël, fut le seul où il n'y eut point de grêle. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Alors Pharaon envoya appeler Moïse et Aaron, et leur dit: J'ai péché cette fois; l'Éternel est le juste, et moi et mon peuple nous sommes les coupables. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Intercédez auprès de l'Éternel; et qu'il n'y ait plus de tonnerres ni de grêle; et je vous laisserai aller, et vous ne resterez pas plus longtemps. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Alors Moïse lui dit: Dès que je serai sorti de la ville, j'étendrai mes mains vers l'Éternel, les tonnerres cesseront, et il n'y aura plus de grêle, afin que tu saches que la terre est à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mais, pour toi et tes serviteurs, je sais que vous ne craindrez pas encore l'Éternel Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Or, le lin et l'orge furent frappés; car l'orge était en épis, et le lin en fleur. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Mais le blé et l'épeautre ne furent point frappés, parce qu'ils sont tardifs. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moïse quitta donc Pharaon, sortit de la ville, et étendit ses mains vers l'Éternel; et les tonnerres et la grêle cessèrent, et la pluie ne se répandit plus sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Et Pharaon, voyant que la pluie, la grêle et les tonnerres avaient cessé, continua encore de pécher; et il appesantit son cœur, lui et ses serviteurs. ");
INSERT INTO fra_fob_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Le cœur de Pharaon s'endurcit donc, et il ne laissa point aller les enfants d'Israël, comme l'Éternel l'avait dit par l'organe de Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Et l'Éternel dit à Moïse: Va vers Pharaon, car j'ai appesanti son cœur et le cœur de ses serviteurs, afin de mettre au milieu d'eux mes prodiges, ");
INSERT INTO fra_fob_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Et afin que tu racontes à ton fils et au fils de ton fils, les exploits que j'aurai accomplis sur les Égyptiens et les prodiges que j'aurai faits au milieu d'eux, et que vous sachiez que je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moïse et Aaron vinrent donc vers Pharaon, et lui dirent: Ainsi a dit l'Éternel, le Dieu des Hébreux: Jusqu'à quand refuseras-tu de t'humilier devant moi? Laisse aller mon peuple, afin qu'il me serve. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Car si tu refuses de laisser aller mon peuple, voici, je ferai venir demain des sauterelles dans ton territoire. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Et elles couvriront la face de la terre, et l'on ne pourra plus voir la terre; et elles dévoreront le reste de ce qui est échappé, ce que la grêle vous a laissé; et elles dévoreront tous les arbres qui poussent dans vos champs; ");
INSERT INTO fra_fob_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Et elles rempliront tes maisons, et les maisons de tous tes serviteurs, et les maisons de tous les Égyptiens; ce que tes pères n'ont point vu, ni les pères de tes pères, depuis le jour qu'ils ont été sur la terre, jusqu'à ce jour. Puis il se tourna et sortit de chez Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Et les serviteurs de Pharaon lui dirent: Jusqu'à quand celui-ci nous sera-t-il en piège? Laisse aller ces gens, et qu'ils servent l'Éternel leur Dieu. Ne vois-tu pas encore que l'Égypte est perdue? ");
INSERT INTO fra_fob_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Alors on fit revenir Moïse et Aaron vers Pharaon, et il leur dit: Allez, servez l'Éternel votre Dieu. Quels sont tous ceux qui iront? ");
INSERT INTO fra_fob_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Et Moïse répondit: Nous irons avec nos jeunes gens et nos vieillards, avec nos fils et nos filles; nous irons avec nos brebis et nos bœufs; car c'est pour nous une fête de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Alors il leur dit: Que l'Éternel soit avec vous, comme je vous laisserai aller, vous et vos petits enfants! Prenez garde, car le mal est devant vous! ");
INSERT INTO fra_fob_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Il n'en sera pas ainsi; allez, vous les hommes, et servez l'Éternel; car c'est ce que vous demandiez. Et on les chassa de devant Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Alors l'Éternel dit à Moïse: Étends ta main sur le pays d'Égypte, pour faire venir les sauterelles, et qu'elles montent sur le pays d'Égypte, et dévorent toute l'herbe de la terre, tout ce que la grêle a laissé. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moïse étendit donc sa verge sur le pays d'Égypte; et l'Éternel amena sur le pays, tout ce jour-là et toute la nuit, un vent d'Orient; le matin vint, et le vent d'Orient avait apporté les sauterelles. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Et les sauterelles montèrent sur tout le pays d'Égypte, et s'abattirent dans tout le territoire de l'Égypte, en très grand nombre. Il n'y en avait point eu avant elles de semblables, et il n'y en aura point de semblables après elles. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Elles couvrirent la face de tout le pays, et le pays en fut obscurci; et elles dévorèrent toute l'herbe de la terre, et tout le fruit des arbres, que la grêle avait laissé; et il ne resta aucune verdure aux arbres, ni aux herbes des champs, dans tout le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Alors Pharaon se hâta d'appeler Moïse et Aaron, et dit: J'ai péché contre l'Éternel votre Dieu, et contre vous. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Mais, maintenant, pardonne, je te prie, mon péché, pour cette fois seulement; et intercédez auprès de l'Éternel votre Dieu, pour qu'il éloigne de moi seulement cette mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Il sortit donc de chez Pharaon, et intercéda auprès de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Et l'Éternel ramena un vent d'Occident très fort, qui emporta les sauterelles, et les précipita dans la mer Rouge. Il ne resta pas une seule sauterelle dans tout le territoire de l'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mais l'Éternel endurcit le cœur de Pharaon, et il ne laissa point aller les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Alors l'Éternel dit à Moïse: Étends ta main vers les cieux, et qu'il y ait des ténèbres sur le pays d'Égypte, telles qu'on puisse les toucher. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moïse étendit donc sa main vers les cieux, et il y eut d'épaisses ténèbres dans tout le pays d'Égypte, pendant trois jours; ");
INSERT INTO fra_fob_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","On ne se voyait pas l'un l'autre, et nul ne se leva de sa place, pendant trois jours. Mais pour tous les enfants d'Israël il y eut de la lumière dans le lieu de leurs demeures. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Alors Pharaon appela Moïse et dit: Allez, servez l'Éternel; que vos brebis et vos bœufs seuls demeurent; vos petits enfants iront aussi avec vous. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mais Moïse répondit: Tu mettras toi-même entre nos mains de quoi faire des sacrifices et des holocaustes, que nous offrirons à l'Éternel notre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Et nos troupeaux iront aussi avec nous; il n'en restera pas un ongle. Car nous en prendrons pour servir l'Éternel notre Dieu; et nous ne saurons avec quoi nous devrons servir l'Éternel, que nous ne soyons arrivés là. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mais l'Éternel endurcit le cœur de Pharaon, et il ne voulut point les laisser aller. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Et Pharaon lui dit: Va-t'en de devant moi! Garde-toi de revoir ma face, car le jour où tu verras ma face, tu mourras. ");
INSERT INTO fra_fob_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Alors Moïse répondit: Tu as bien dit; je ne reverrai plus ta face. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Or l'Éternel avait dit à Moïse: Je ferai venir encore une plaie sur Pharaon et sur l'Égypte; après cela, il vous laissera partir d'ici. Quand il vous laissera aller tout à fait, il vous chassera d'ici. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Parle donc au peuple, et dis-leur qu'ils demandent, chacun à son voisin et chacune à sa voisine, des objets d'argent et d'or. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Et l'Éternel fit trouver grâce au peuple devant les Égyptiens; et même Moïse était un fort grand homme dans le pays d'Égypte, aux yeux des serviteurs de Pharaon et aux yeux du peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Et Moïse dit: Ainsi a dit l'Éternel: Sur le minuit, je passerai au milieu de l'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Et tout premier-né mourra au pays d'Égypte, depuis le premier-né de Pharaon, qui est assis sur son trône, jusqu'au premier-né de la servante qui est derrière la meule, ainsi que tout premier-né des bêtes. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Et il y aura un si grand cri dans tout le pays d'Égypte, qu'il n'y en eut jamais et qu'il n'y en aura plus de semblable. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mais, parmi tous les enfants d'Israël, pas même un chien ne remuera sa langue, depuis l'homme jusqu'aux bêtes; afin que vous sachiez quelle différence l'Éternel met entre les Égyptiens et Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Et tous tes serviteurs que voici descendront vers moi, et se prosterneront devant moi, en disant: Sors, toi, et tout le peuple qui te suit! Et, après cela, je sortirai. Et Moïse sortit d'auprès de Pharaon dans une ardente colère. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Or l'Éternel avait dit à Moïse: Pharaon ne vous écoutera point, afin que mes miracles se multiplient dans le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Et Moïse et Aaron firent tous ces miracles devant Pharaon. Mais l'Éternel endurcit le cœur de Pharaon, et il ne laissa point aller les enfants d'Israël hors de son pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Or l'Éternel parla à Moïse et à Aaron, au pays d'Égypte, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Ce mois sera pour vous le commencement des mois; il sera pour vous le premier des mois de l'année. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Parlez à toute l'assemblée d'Israël et dites: Qu'au dixième jour de ce mois ils prennent chacun un agneau ou un chevreau par maison de leurs pères, un agneau ou un chevreau par maison. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Et si la maison est trop petite pour le manger, qu'on le prenne avec son voisin le plus rapproché de sa maison, d'après le nombre des personnes; vous compterez pour l'agneau selon ce que chacun peut manger. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Vous aurez un agneau ou chevreau sans défaut, mâle, âgé d'un an; vous le prendrez d'entre les brebis ou d'entre les chèvres. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Et vous le garderez jusqu'au quatorzième jour de ce mois, et toute la communauté d'Israël assemblée l'égorgera entre les deux soirs. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Et ils prendront de son sang, et le mettront sur les deux poteaux, et sur le linteau de la porte des maisons où ils le mangeront. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Et cette nuit-là, ils en mangeront la chair rôtie au feu; ils la mangeront avec des pains sans levain et des herbes amères. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","N'en mangez rien à demi cuit, ni qui ait été bouilli dans l'eau; mais qu'il soit rôti au feu, sa tête ainsi que ses jambes et ses entrailles. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Vous n'en laisserez rien de reste jusqu'au matin; et ce qui en restera au matin, vous le brûlerez au feu. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Et voici comment vous le mangerez: vos reins ceints, vos souliers aux pieds, et votre bâton à la main; et vous le mangerez à la hâte; c'est la Pâque (passage) de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Cette nuit-là je passerai dans le pays d'Égypte, et je frapperai tout premier-né dans le pays d'Égypte, depuis les hommes jusqu'aux bêtes; et j'exercerai des jugements sur tous les dieux de l'Égypte. Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Et le sang vous servira de signe sur les maisons où vous serez; je verrai le sang et je passerai par-dessus vous, et il n'y aura point parmi vous de plaie de destruction, lorsque je frapperai le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Et ce jour-là vous sera en mémorial; et vous le célébrerez comme une fête à l'Éternel, d'âge en âge; vous le célébrerez comme une ordonnance perpétuelle. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Pendant sept jours vous mangerez des pains sans levain; et dès le premier jour vous ôterez le levain de vos maisons. Car toute personne qui mangera du pain levé, depuis le premier jour jusqu'au septième, sera retranchée d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Au premier jour, il y aura une sainte convocation; vous en aurez aussi une au septième jour. Il ne se fera aucune œuvre en ces jours-là; on vous apprêtera seulement ce que chaque personne doit manger. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Vous observerez donc la fête des pains sans levain; car en ce même jour j'aurai retiré vos armées du pays d'Égypte. Vous observerez ce jour-là d'âge en âge comme une ordonnance perpétuelle. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Au premier mois, au quatorzième jour du mois, vous mangerez, le soir, des pains sans levain, jusqu'au vingt et unième jour du mois, au soir. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Pendant sept jours, il ne se trouvera point de levain dans vos maisons; car toute personne qui mangera du pain levé, sera retranchée de l'assemblée d'Israël, que ce soit un étranger ou quelqu'un né dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Vous ne mangerez point de pain levé; dans toutes vos demeures, vous mangerez des pains sans levain. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moïse appela donc tous les anciens d'Israël, et leur dit: Allez et prenez du menu bétail pour vos familles, et immolez la Pâque. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Et vous prendrez un bouquet d'hysope; vous le tremperez dans le sang qui sera dans le bassin, et vous aspergerez, du sang qui sera dans le bassin, le linteau et les deux poteaux; et nul de vous ne sortira de la porte de sa maison, jusqu'au matin. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Et l'Éternel passera pour frapper l'Égypte, et il verra le sang sur le linteau, et sur les deux poteaux; et l'Éternel passera par-dessus la porte, et ne permettra point au destructeur d'entrer dans vos maisons pour frapper. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Vous garderez ceci comme une ordonnance perpétuelle, pour vous et pour vos enfants. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Et quand vous serez entrés au pays que l'Éternel vous donnera, comme il l'a dit, vous observerez cette cérémonie. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Et quand vos enfants vous diront: Que signifie pour vous cette cérémonie? ");
INSERT INTO fra_fob_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Alors vous répondrez: C'est le sacrifice de la Pâque à l'Éternel, qui passa par-dessus les maisons des enfants d'Israël en Égypte, quand il frappa l'Égypte et qu'il préserva nos maisons. Alors le peuple s'inclina et se prosterna. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Et les enfants d'Israël s'en allèrent, et firent comme l'Éternel l'avait commandé à Moïse et à Aaron; ils firent ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Et il arriva qu'à minuit l'Éternel frappa tout premier-né dans le pays d'Égypte, depuis le premier-né de Pharaon, assis sur son trône, jusqu'aux premiers-nés des captifs qui étaient dans la prison, et tous les premiers-nés des bêtes. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Et Pharaon se leva de nuit, lui et tous ses serviteurs, et tous les Égyptiens; et il y eut un grand cri en Égypte, car il n'y avait point de maison où il n'y eût un mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Il appela donc Moïse et Aaron, de nuit, et leur dit: Levez-vous; sortez du milieu de mon peuple, vous et les enfants d'Israël; allez, servez l'Éternel, comme vous l'avez dit. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Prenez aussi vos brebis et vos bœufs, comme vous l'avez dit; allez, et bénissez-moi aussi. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Et les Égyptiens pressèrent le peuple, pour le faire vite sortir du pays; car ils disaient: Nous sommes tous morts! ");
INSERT INTO fra_fob_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Le peuple prit donc sa pâte, avant qu'elle fût levée, avec leurs huches liées dans leurs vêtements sur leurs épaules. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Or, les enfants d'Israël avaient fait selon la parole de Moïse, et avaient demandé aux Égyptiens des objets d'argent et d'or, et des vêtements. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Et l'Éternel avait fait trouver grâce au peuple aux yeux des Égyptiens, qui les leur avaient prêtés; et ils dépouillèrent les Égyptiens. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Et les enfants d'Israël partirent de Ramsès pour Succoth, au nombre d'environ six cent mille hommes de pied, sans les petits enfants. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Un grand nombre d'étrangers montèrent aussi avec eux, ainsi que des brebis et des bœufs, un bétail très considérable. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Et ils firent cuire en gâteaux sans levain la pâte qu'ils avaient emportée d'Égypte, car elle n'était pas levée; car ils avaient été chassés d'Égypte, sans pouvoir s'attarder, et ils ne s'étaient même préparé aucune provision. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Or, le séjour que les enfants d'Israël firent en Égypte, fut de quatre cent trente ans. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Il arriva donc, au bout de quatre cent trente ans, il arriva, en ce même jour, que toutes les armées de l'Éternel sortirent du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","C'est une nuit qu'on doit observer en l'honneur de l'Éternel, pour les avoir retirés du pays d'Égypte. Cette nuit-là doit être observée, en l'honneur de l'Éternel, par tous les enfants d'Israël, d'âge en âge. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Et l'Éternel dit à Moïse et à Aaron: Voici l'ordonnance de la Pâque: Nul étranger n'en mangera. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Quant à tout esclave, homme acquis à prix d'argent, tu le circonciras, et alors il en mangera. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","L'habitant étranger et le mercenaire n'en mangeront point. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Elle sera mangée dans une même maison; tu n'emporteras point de la chair hors de la maison, et vous n'en briserez aucun os. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Toute l'assemblée d'Israël fera la Pâque. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Et quand un étranger séjournera chez toi, et voudra faire la Pâque à l'Éternel, que tout mâle qui lui appartient, soit circoncis; et alors il s'approchera pour la faire, et il sera comme celui qui est né au pays; mais nul incirconcis n'en mangera. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Il y aura une même loi pour celui qui est né dans le pays et pour l'étranger séjournant au milieu de vous. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Et tous les enfants d'Israël firent comme l'Éternel avait commandé à Moïse et à Aaron; ils firent ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Il arriva donc, en ce même jour-là, que l'Éternel retira du pays d'Égypte les enfants d'Israël selon leurs armées. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Consacre-moi tout premier-né, tout ce qui naît le premier parmi les enfants d'Israël, parmi les hommes et parmi les bêtes; il est à moi. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Et Moïse dit au peuple: Souvenez-vous de ce jour où vous êtes sortis d'Égypte, de la maison de servitude, car l'Éternel vous en a retirés à main forte; et qu'on ne mange point de pain levé. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Vous sortez aujourd'hui, au mois des épis. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Quand donc l'Éternel t'aura introduit au pays des Cananéens, des Héthiens, des Amoréens, des Héviens, et des Jébusiens, qu'il a juré à tes pères de te donner, pays où coulent le lait et le miel, alors tu t'acquitteras, dans ce mois, de ce service. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Pendant sept jours tu mangeras des pains sans levain, et au septième jour il y aura une fête à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","On mangera des pains sans levain pendant sept jours; et l'on ne verra point chez toi de pain levé, et l'on ne verra point chez toi de levain dans tout ton territoire. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Et tu l'expliqueras à ton fils en ce jour-là, en disant: C'est à cause de ce que l'Éternel fit pour moi, lorsque je sortis d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Et cela te sera comme un signe sur ta main, et comme un mémorial entre tes yeux, afin que la loi de l'Éternel soit dans ta bouche, car l'Éternel t'a retiré d'Égypte à main forte. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tu garderas donc cette ordonnance, en sa saison, tous les ans. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Et quand l'Éternel t'aura introduit au pays des Cananéens, comme il l'a juré à toi et à tes pères, et qu'il te l'aura donné; ");
INSERT INTO fra_fob_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Alors tu présenteras à l'Éternel tout ce qui naît le premier, et tous les premiers-nés des bêtes que tu auras; les mâles seront à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Mais tu rachèteras avec un agneau ou chevreau tout premier-né de l'âne; et si tu ne le rachètes pas, tu lui rompras la nuque. Tu rachèteras aussi tout premier-né des hommes parmi tes enfants. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Et quand ton fils t'interrogera un jour, en disant: Que signifie cela? tu lui diras: Par sa main forte l'Éternel nous a retirés d'Égypte, de la maison de servitude. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Et il arriva, quand Pharaon s'obstina à ne point nous laisser aller, que l'Éternel tua tout premier-né dans le pays d'Égypte, depuis le premier-né de l'homme jusqu'au premier-né du bétail; c'est pourquoi, je sacrifie à l'Éternel tous les mâles qui naissent les premiers, et je rachète tout premier-né de mes fils. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Et cela sera comme un signe sur ta main, et des fronteaux entre tes yeux, que l'Éternel nous a retirés d'Égypte à main forte. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Or, quand Pharaon eut laissé aller le peuple, Dieu ne les conduisit point par le chemin du pays des Philistins, qui est le plus proche; car Dieu dit: Il est à craindre que le peuple ne se repente, quand il verra la guerre, et qu'il ne retourne en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Mais Dieu fit faire au peuple un détour par le chemin du désert, vers la mer Rouge. Et les enfants d'Israël montèrent en armes du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Et Moïse prit avec lui les os de Joseph; car Joseph avait fait expressément jurer les enfants en disant: Dieu vous visitera certainement; et vous transporterez mes os d'ici avec vous. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Or, ils partirent de Succoth, et campèrent à Étham, au bout du désert. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Et l'Éternel allait devant eux, le jour dans une colonne de nuée, pour les conduire par le chemin, et la nuit dans une colonne de feu, pour les éclairer, afin qu'ils marchassent jour et nuit. ");
INSERT INTO fra_fob_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","La colonne de nuée ne se retirait point de devant le peuple pendant le jour, ni la colonne de feu pendant la nuit. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Parle aux enfants d'Israël; et qu'ils retournent et campent devant Pi-Hahiroth, entre Migdol et la mer, devant Baal-Tsephon; vous camperez vis-à-vis de ce lieu, près de la mer. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Et Pharaon dira des enfants d'Israël: Ils sont égarés dans le pays; le désert les a enfermés. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Et j'endurcirai le cœur de Pharaon, et il les poursuivra; mais je serai glorifié en Pharaon et dans toute son armée, et les Égyptiens sauront que je suis l'Éternel. Et ils firent ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Or, on rapporta au roi d'Égypte que le peuple s'était enfui. Et le cœur de Pharaon et de ses serviteurs fut changé à l'égard du peuple, et ils dirent: Qu'est-ce que nous avons fait, que nous ayons laissé aller Israël, en sorte qu'il ne nous serve plus? ");
INSERT INTO fra_fob_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Alors il attela son char et il prit son peuple avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Il prit six cents chars d'élite et tous les chars d'Égypte, et des combattants sur chacun d'eux. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Et l'Éternel endurcit le cœur de Pharaon, roi d'Égypte, et il poursuivit les enfants d'Israël. Or les enfants d'Israël étaient sortis à main levée. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Les Égyptiens les poursuivirent; et tous les chevaux des chars de Pharaon, ses cavaliers et son armée les atteignirent, comme ils étaient campés près de la mer, près de Pi-Hahiroth, vis-à-vis de Baal-Tsephon. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Et comme Pharaon approchait, les enfants d'Israël levèrent les yeux, et voici, les Égyptiens marchaient après eux. Alors les enfants d'Israël eurent une fort grande peur, et crièrent à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Et ils dirent à Moïse: Est-ce qu'il n'y avait pas de tombeaux en Égypte, que tu nous aies emmenés pour mourir au désert? Qu'est-ce que tu nous a fait, de nous faire sortir d'Égypte? ");
INSERT INTO fra_fob_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","N'est-ce pas ce que nous te disions en Égypte: Laisse-nous servir les Égyptiens; car il nous vaut mieux servir les Égyptiens, que de mourir au désert? ");
INSERT INTO fra_fob_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Et Moïse dit au peuple: Ne craignez point; tenez-vous là, et voyez la délivrance de l'Éternel, qu'il vous accordera aujourd'hui; car les Égyptiens que vous avez vus aujourd'hui, vous ne les reverrez jamais plus. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","L'Éternel combattra pour vous, et vous, vous resterez tranquilles. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Et l'Éternel dit à Moïse: Pourquoi cries-tu à moi? Parle aux enfants d'Israël, et qu'ils marchent. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Et toi, élève ta verge, et étends ta main sur la mer, et fends-la; et que les enfants d'Israël entrent au milieu de la mer, à sec. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Et moi, voici, je vais endurcir le cœur des Égyptiens, et ils y entreront après eux; et je serai glorifié en Pharaon et en toute son armée, en ses chars et en ses cavaliers. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Et les Égyptiens sauront que je suis l'Éternel, quand je serai glorifié en Pharaon, en ses chars et en ses cavaliers. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Et l'ange de Dieu, qui allait devant le camp d'Israël, partit et alla derrière eux; et la colonne de nuée partit de devant eux, et se tint derrière eux; ");
INSERT INTO fra_fob_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Et elle vint entre le camp des Égyptiens et le camp d'Israël. Et elle fut d'un côté une nuée obscure; mais, de l'autre, elle éclairait la nuit; et ils ne s'approchèrent point les uns des autres de toute la nuit. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Or, Moïse étendit la main sur la mer, et l'Éternel refoula la mer, toute la nuit, par un fort vent d'Orient; et il mit la mer à sec, et les eaux se fendirent. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Et les enfants d'Israël entrèrent au milieu de la mer à sec; et les eaux leur formaient une muraille à leur droite et à leur gauche. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Et les Égyptiens les poursuivirent; et tous les chevaux de Pharaon, ses chars et ses cavaliers, entrèrent après eux au milieu de la mer. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Mais il arriva, sur la veille du matin, que l'Éternel, étant dans la colonne de feu et de nuée, regarda le camp des Égyptiens, et le mit en déroute. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Et il ôta les roues de leurs chars, et fit qu'on les menait pesamment. Alors les Égyptiens dirent: Fuyons de devant les Israélites, car l'Éternel combat pour eux contre les Égyptiens. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Et l'Éternel dit à Moïse: Étends ta main sur la mer, et les eaux retourneront sur les Égyptiens, sur leurs chars et sur leurs cavaliers. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moïse étendit donc sa main sur la mer, et la mer retourna vers le matin dans son lit; et les Égyptiens s'enfuyant la rencontrèrent, et l'Éternel jeta les Égyptiens au milieu de la mer. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Les eaux retournèrent donc et couvrirent les chars et les cavaliers de toute l'armée de Pharaon, qui étaient entrés après les Israélites dans la mer; il n'en resta pas un seul. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mais les enfants d'Israël marchèrent à sec au milieu de la mer; et les eaux leur formaient une muraille à leur droite et à leur gauche. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","En ce jour-là l'Éternel délivra Israël de la main des Égyptiens; et Israël vit les Égyptiens morts, sur le rivage de la mer. ");
INSERT INTO fra_fob_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Ainsi Israël vit la grande puissance que l'Éternel avait déployée contre les Égyptiens; et le peuple craignit l'Éternel, et ils crurent en l'Éternel et en Moïse, son serviteur. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Alors Moïse et les enfants d'Israël chantèrent ce cantique à l'Éternel, et ils dirent: Je chanterai à l'Éternel, car il s'est hautement élevé. Il a jeté dans la mer le cheval et son cavalier. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","L'Éternel est ma force et ma louange: il a été mon libérateur. Il est mon Dieu, je le glorifierai; il est le Dieu de mon père, je l'exalterai. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","L'Éternel est un vaillant guerrier; son nom est l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Il a jeté dans la mer les chars de Pharaon et son armée; et l'élite de ses combattants a été plongée dans la mer Rouge. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Les flots les ont couverts; ils sont descendus au fond des eaux, comme une pierre. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ta droite, ô Éternel, est magnifique en force. Ta droite, ô Éternel, écrase l'ennemi. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Par la grandeur de ta majesté, tu renverses tes adversaires. Tu envoies ta colère, elle les consume comme le chaume. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Au souffle de tes narines les eaux se sont amoncelées; les courants se sont arrêtés comme une digue; les flots ont gelé au cœur de la mer. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","L'ennemi avait dit: Je poursuivrai, j'atteindrai, je partagerai le butin; mon âme s'assouvira sur eux, je tirerai l'épée, ma main les détruira. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tu as soufflé de ton haleine: la mer les a couverts; ils ont roulé comme le plomb, au fond des eaux puissantes. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Qui est comme toi, parmi les dieux, ô Éternel? Qui est comme toi magnifique en sainteté, redoutable dans les louanges, opérant des merveilles? ");
INSERT INTO fra_fob_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tu as étendu ta droite; la terre les engloutit. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Tu as conduit par ta miséricorde ce peuple que tu as racheté; tu l'as dirigé par ta force vers ta sainte demeure. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Les peuples l'entendent, et ils tremblent; l'effroi saisit les habitants de la Palestine. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Alors les princes d'Édom sont troublés; le tremblement saisit les puissants de Moab; tous les habitants de Canaan désespèrent. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","La frayeur et l'épouvante tomberont sur eux; par la grandeur de ton bras, ils deviendront muets comme la pierre, jusqu'à ce que ton peuple, ô Éternel, ait passé; jusqu'à ce qu'il ait passé, le peuple que tu as acquis. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tu les introduiras et tu les planteras sur la montagne de ton héritage, au lieu que tu as préparé pour ta demeure, ô Éternel, au sanctuaire, Seigneur, que tes mains ont établi. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","L'Éternel régnera éternellement et à toujours. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Car les chevaux de Pharaon, avec ses chars et ses cavaliers, sont entrés dans la mer; et l'Éternel a fait retourner sur eux les eaux de la mer; mais les enfants d'Israël ont marché à sec au milieu de la mer. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Et Marie, la prophétesse, sœur d'Aaron, prit dans sa main le tambourin, et toutes les femmes sortirent après elle, avec des tambourins et en dansant. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Et Marie répondait à ceux qui chantaient: Chantez à l'Éternel, car il s'est hautement élevé; il a jeté dans la mer le cheval et son cavalier. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Puis, Moïse fit partir les Israélites de la mer Rouge, et ils tirèrent vers le désert de Shur; et ils marchèrent trois jours dans le désert, et ne trouvèrent point d'eau. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Puis ils vinrent à Mara, mais ils ne purent boire des eaux de Mara, car elles étaient amères; c'est pour cela que ce lieu fut appelé Mara (amertume). ");
INSERT INTO fra_fob_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Alors le peuple murmura contre Moïse, en disant: Que boirons-nous? ");
INSERT INTO fra_fob_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Et Moïse cria à l'Éternel; et l'Éternel lui indiqua un bois, qu'il jeta dans les eaux, et les eaux devinrent douces. C'est là qu'il lui imposa une ordonnance et un statut, et c'est là qu'il l'éprouva. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Et il dit: Si tu écoutes attentivement la voix de l'Éternel ton Dieu, si tu fais ce qui est droit à ses yeux, si tu prêtes l'oreille à ses commandements et si tu gardes toutes ses ordonnances, je ne t'infligerai aucune des maladies que j'ai infligées à l'Égypte; car je suis l'Éternel qui te guérit. ");
INSERT INTO fra_fob_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Puis ils vinrent à Élim; et là il y avait douze sources d'eau et soixante et dix palmiers; et ils campèrent là, près des eaux. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Toute l'assemblée des enfants d'Israël, étant partie d'Élim, vint au désert de Sin, qui est entre Élim et Sinaï, au quinzième jour du second mois, après leur sortie du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Et toute l'assemblée des enfants d'Israël murmura dans ce désert contre Moïse et contre Aaron. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Et les enfants d'Israël leur dirent: Ah! que ne sommes-nous morts par la main de l'Éternel au pays d'Égypte, quand nous étions assis près des potées de viande, quand nous mangions du pain à satiété! Car vous nous avez amenés dans ce désert, pour faire mourir de faim toute cette assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Alors l'Éternel dit à Moïse: Voici, je vais vous faire pleuvoir des cieux du pain, et le peuple sortira, et ils en recueilleront chaque jour ce qu'il faut pour la journée, afin que je l'éprouve, pour voir s'il marchera, ou non, dans ma loi. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Mais, le sixième jour, ils apprêteront ce qu'ils auront apporté, et il y en aura le double de ce qu'ils recueilleront chaque jour. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moïse et Aaron dirent donc à tous les enfants d'Israël: Ce soir vous saurez que c'est l'Éternel qui vous a retirés du pays d'Égypte; ");
INSERT INTO fra_fob_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Et au matin vous verrez la gloire de l'Éternel, parce qu'il a entendu vos murmures contre l'Éternel. Que sommes-nous, en effet, pour que vous murmuriez contre nous? ");
INSERT INTO fra_fob_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Et Moïse dit: Ce sera quand l'Éternel vous donnera ce soir de la chair à manger, et au matin du pain en abondance; parce que l'Éternel a entendu vos murmures, que vous élevez contre lui. Que sommes-nous en effet? Vos murmures ne sont pas contre nous, mais contre l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Et Moïse dit à Aaron: Dis à toute l'assemblée des enfants d'Israël: Approchez-vous devant l'Éternel, car il a entendu vos murmures. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Et comme Aaron parlait à toute l'assemblée des enfants d'Israël, ils se tournèrent vers le désert, et voici, la gloire de l'Éternel se montra dans la nuée; ");
INSERT INTO fra_fob_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","J'ai entendu les murmures des enfants d'Israël. Parle-leur, et leur dis: Entre les deux soirs vous mangerez de la chair, et au matin vous vous rassasierez de pain, et vous saurez que je suis l'Éternel votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Le soir donc les cailles montèrent et couvrirent le camp, et au matin il y eut une couche de rosée à l'entour du camp. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Et la couche de rosée s'évanouit, et voici il y avait sur la surface du désert une chose menue, perlée, menue comme le givre sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Quand les enfants d'Israël la virent, ils se dirent l'un à l'autre: Qu'est cela? car ils ne savaient ce que c'était. Et Moïse leur dit: C'est le pain que l'Éternel vous a donné à manger. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Voici ce que l'Éternel a commandé: Recueillez-en chacun en proportion de ce qu'il mange, un homer par tête, selon le nombre de vos personnes; vous en prendrez chacun pour ceux qui sont dans sa tente. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Les enfants d'Israël firent donc ainsi; et ils recueillirent, l'un plus et l'autre moins. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Et ils le mesurèrent par homer; et celui qui en recueillait beaucoup, n'en eut pas trop, et celui qui en recueillait peu, n'en manqua pas; ils en recueillirent chacun en proportion de ce qu'il mangeait. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Et Moïse leur dit: Que personne n'en laisse de reste jusqu'au matin. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Mais ils n'obéirent point à Moïse, et quelques-uns en laissèrent jusqu'au matin, et il s'y engendra des vers et une mauvaise odeur; et Moïse se mit en colère contre eux. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ils en recueillirent donc tous les matins, chacun en proportion de ce qu'il mangeait; et lorsque le soleil était chaud, cela fondait. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Et le sixième jour, ils recueillirent du pain au double, deux homers pour chacun. Et tous les principaux de l'assemblée vinrent le rapporter à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Et il leur répondit: C'est ce que l'Éternel a dit: Demain est le repos, le sabbat consacré à l'Éternel; faites cuire ce que vous avez à cuire, et faites bouillir ce que vous avez à bouillir, et serrez tout le surplus, pour le garder jusqu'au matin. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ils le serrèrent donc jusqu'au matin, comme Moïse l'avait commandé, et il ne sentit point mauvais, et il n'y eut point de vers. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Alors Moïse dit: Mangez-le aujourd'hui; car c'est aujourd'hui le sabbat de l'Éternel; aujourd'hui vous n'en trouverez point dans les champs. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Pendant six jours vous le recueillerez, mais au septième jour, qui est le sabbat, il n'y en aura point. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Et le septième jour, quelques-uns du peuple sortirent pour en recueillir; mais ils n'en trouvèrent point. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Alors l'Éternel dit à Moïse: Jusqu'à quand refuserez-vous de garder mes commandements et mes lois? ");
INSERT INTO fra_fob_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Considérez que l'Éternel vous a donné le sabbat, c'est pourquoi il vous donne au sixième jour du pain pour deux jours; que chacun demeure à sa place, et que personne ne sorte de son lieu le septième jour. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Le peuple se reposa donc le septième jour. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Et la maison d'Israël nomma cette nourriture, manne; elle était comme de la semence de coriandre, blanche, et avait le goût de beignets au miel. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Et Moïse dit: Voici ce que l'Éternel a commandé: Qu'on en remplisse un homer, pour le garder d'âge en âge, afin qu'on voie le pain que je vous ai fait manger au désert, quand je vous ai retirés du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Et Moïse dit à Aaron: Prends une cruche, et mets-y un plein homer de manne, et dépose-le devant l'Éternel, pour être gardé d'âge en âge. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Comme le Seigneur l'avait commandé à Moïse, Aaron le déposa devant le Témoignage, pour qu'il fût gardé. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Et les enfants d'Israël mangèrent la manne quarante ans, jusqu'à ce qu'ils fussent venus dans un pays habité; ils mangèrent la manne, jusqu'à ce qu'ils fussent venus à la frontière du pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Or, le homer est la dixième partie de l'épha. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Et toute l'assemblée des enfants d'Israël partit du désert de Sin, suivant leurs étapes, d'après le commandement de l'Éternel. Et ils campèrent à Réphidim; et il n'y avait point d'eau à boire pour le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Et le peuple contesta avec Moïse; et ils dirent: Donnez-nous de l'eau; que nous buvions. Et Moïse leur dit: Pourquoi me querellez-vous? Pourquoi tentez-vous l'Éternel? ");
INSERT INTO fra_fob_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Le peuple eut donc soif dans ce lieu, faute d'eau; et le peuple murmura contre Moïse, et dit: Pourquoi donc nous as-tu fait monter hors d'Égypte, pour nous faire mourir de soif, moi et mes enfants, et mes troupeaux? ");
INSERT INTO fra_fob_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Et Moïse cria à l'Éternel, en disant: Que ferai-je à ce peuple? Encore un peu et ils me lapideront. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Et l'Éternel répondit à Moïse: Passe devant le peuple, et prends avec toi des anciens d'Israël, et prends en ta main la verge dont tu frappas le fleuve, et marche. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Voici, je me tiendrai devant toi, là, sur le rocher, en Horeb, et tu frapperas le rocher; et il en sortira de l'eau, et le peuple boira. Moïse fit donc ainsi aux yeux des anciens d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Et on nomma le lieu Massa et Mériba (tentation et querelle), à cause de la contestation des enfants d'Israël, et parce qu'ils avaient tenté l'Éternel, en disant: L'Éternel est-il au milieu de nous, ou n'y est-il pas? ");
INSERT INTO fra_fob_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Alors Amalek vint et livra bataille à Israël à Réphidim. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Et Moïse dit à Josué: Choisis-nous des hommes; sors, et combats contre Amalek; demain je me tiendrai au sommet de la colline, avec la verge de Dieu dans ma main. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Et Josué fit comme Moïse lui avait dit, pour combattre contre Amalek. Moïse, Aaron et Hur montèrent au sommet de la colline. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Et il arrivait, lorsque Moïse élevait sa main, qu'Israël était le plus fort, mais quand il reposait sa main, Amalek était le plus fort. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Et les mains de Moïse étant devenues pesantes, ils prirent une pierre et la mirent sous lui, et il s'assit dessus; et Aaron et Hur soutinrent ses mains, l'un d'un côté et l'autre de l'autre; et ses mains furent fermes jusqu'au coucher du soleil. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Et Josué défit Amalek et son peuple par le tranchant de l'épée. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Alors l'Éternel dit à Moïse: Écris ceci pour mémoire dans le livre, et fais entendre à Josué que j'effacerai entièrement la mémoire d'Amalek de dessous les cieux. ");
INSERT INTO fra_fob_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Et Moïse bâtit un autel, et le nomma: l'Éternel mon étendard (Jéhovah-nissi). ");
INSERT INTO fra_fob_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Et il dit: Parce qu'il a levé la main sur le trône de l'Éternel, l'Éternel a guerre avec Amalek d'âge en âge. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Or, Jéthro, sacrificateur de Madian, beau-père de Moïse, apprit tout ce que Dieu avait fait à Moïse et à Israël, son peuple, et que l'Éternel avait retiré Israël de l'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Et Jéthro, beau-père de Moïse, prit Séphora, femme de Moïse, après son renvoi, ");
INSERT INTO fra_fob_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Et ses deux fils, dont l'un s'appelait Guershom (étranger là), car, dit-il, j'ai séjourné dans un pays étranger; ");
INSERT INTO fra_fob_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Et l'autre Éliézer (Dieu aide), car le Dieu de mon père, dit-il, m'a été en aide, et m'a délivré de l'épée de Pharaon. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jéthro, beau-père de Moïse, vint donc vers Moïse, avec ses enfants et sa femme, au désert où il était campé, près de la montagne de Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Et il fit dire à Moïse: Moi, Jéthro ton beau-père, je viens vers toi, avec ta femme et ses deux fils avec elle. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Et Moïse sortit au-devant de son beau-père; et il se prosterna, et le baisa; et ils s'informèrent mutuellement de leur bien-être; puis ils entrèrent dans la tente. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Et Moïse raconta à son beau-père tout ce que l'Éternel avait fait à Pharaon et aux Égyptiens en faveur d'Israël, toute la peine qui leur était survenue par le chemin, et comment l'Éternel les avait délivrés. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Et Jéthro se réjouit de tout le bien que l'Éternel avait fait à Israël, de ce qu'il l'avait délivré de la main des Égyptiens. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Et Jéthro dit: Béni soit l'Éternel qui vous a délivrés de la main des Égyptiens et de la main de Pharaon; qui a délivré le peuple de la puissance des Égyptiens! ");
INSERT INTO fra_fob_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Maintenant je connais que l'Éternel est plus grand que tous les dieux; car lorsqu'ils se sont élevés avec orgueil, il l'a emporté sur eux. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Et Jéthro, beau-père de Moïse, prit un holocauste et des sacrifices pour les offrir à Dieu; et Aaron et tous les anciens d'Israël vinrent manger le pain avec le beau-père de Moïse, en la présence de Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Il arriva, le lendemain, que Moïse s'assit pour juger le peuple, et le peuple se tint devant Moïse depuis le matin jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Et le beau-père de Moïse, voyant tout ce qu'il faisait pour le peuple, lui dit: Qu'est-ce que tu fais à l'égard de ce peuple? Pourquoi sièges-tu seul, et tout le peuple se tient-il devant toi, depuis le matin jusqu'au soir? ");
INSERT INTO fra_fob_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Et Moïse répondit à son beau-père: C'est que le peuple vient à moi pour consulter Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Quand ils ont quelque cause, ils viennent à moi; je juge entre l'un et l'autre, et je fais connaître les ordonnances de Dieu et ses lois. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mais le beau-père de Moïse lui dit: Ce que tu fais n'est pas bien. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Certainement, tu succomberas, et toi et ce peuple qui est avec toi; car cela est trop pesant pour toi, tu ne peux le faire toi seul. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Maintenant écoute ma voix; je te conseillerai, et que Dieu soit avec toi! Sois pour le peuple devant Dieu; et rapporte les causes à Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Instruis-les des ordonnances et des lois, et fais-leur connaître la voie dans laquelle ils doivent marcher, et ce qu'ils doivent faire. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Et choisis-toi d'entre tout le peuple des hommes capables, craignant Dieu, des hommes fidèles, haïssant le gain déshonnête, et établis-les sur eux comme chefs de milliers, chefs de centaines, chefs de cinquantaines, et chefs de dizaines; ");
INSERT INTO fra_fob_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Et qu'ils jugent le peuple en tout temps; s'il y a de grandes affaires, qu'ils te les rapportent; mais qu'ils jugent eux-mêmes toutes les petites causes. Allège ton fardeau, et qu'ils le portent avec toi. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si tu fais cela, et que Dieu te le commande, tu pourras subsister, et tout ce peuple arrivera heureusement en son lieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Et Moïse obéit à la voix de son beau-père, et fit tout ce qu'il avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moïse choisit donc de tout Israël des hommes capables, et les établit chefs sur le peuple, chefs de milliers, chefs de centaines, chefs de cinquantaines, et chefs de dizaines, ");
INSERT INTO fra_fob_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Qui devaient juger le peuple en tout temps; ils devaient rapporter à Moïse les affaires difficiles, et juger eux-mêmes toutes les petites affaires. ");
INSERT INTO fra_fob_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Puis Moïse laissa aller son beau-père, qui s'en retourna en son pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Au troisième mois, après que les enfants d'Israël furent sortis du pays d'Égypte, ils vinrent, en ce jour-là, au désert de Sinaï. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Étant partis de Réphidim, ils vinrent au désert de Sinaï, et ils campèrent dans le désert; et Israël campa là, vis-à-vis de la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Et Moïse monta vers Dieu, et l'Éternel l'appela de la montagne, en disant: Tu parleras ainsi à la maison de Jacob, et tu déclareras ceci aux enfants d'Israël: ");
INSERT INTO fra_fob_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Vous avez vu ce que j'ai fait aux Égyptiens, et que je vous ai portés sur des ailes d'aigle, et que je vous ai fait venir vers moi. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Maintenant donc, si vous obéissez à ma voix et si vous gardez mon alliance, vous serez aussi, d'entre tous les peuples, mon plus précieux joyau, car toute la terre est à moi. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Et vous me serez un royaume de sacrificateurs, et une nation sainte. Voilà les paroles que tu diras aux enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Et Moïse vint et appela les anciens du peuple, et mit devant eux toutes ces paroles que l'Éternel lui avait commandées. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Et tout le peuple ensemble répondit et dit: Nous ferons tout ce que l'Éternel a dit. Et Moïse rapporta à l'Éternel les paroles du peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Et l'Éternel dit à Moïse: Voici, je vais venir à toi dans l'épaisseur de la nuée, afin que le peuple entende quand je te parlerai, et qu'il te croie aussi toujours. Et Moïse rapporta à l'Éternel les paroles du peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Et l'Éternel dit à Moïse: Va vers le peuple, sanctifie-les aujourd'hui et demain, et qu'ils lavent leurs vêtements. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Et qu'ils soient prêts pour le troisième jour; car, le troisième jour, l'Éternel descendra, à la vue de tout le peuple, sur la montagne de Sinaï. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Or, tu prescriras des bornes au peuple tout à l'entour, en disant: Gardez-vous de monter sur la montagne, et d'en toucher le bord. Quiconque touchera la montagne, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","On ne mettra pas la main sur lui, mais il sera lapidé ou percé de flèches; bête ou homme, il ne vivra point. Quand le cor sonnera, ils monteront sur la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Et Moïse descendit de la montagne vers le peuple; il sanctifia le peuple, et ils lavèrent leurs vêtements. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Et il dit au peuple: Soyez prêts dans trois jours; ne vous approchez point de vos femmes. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Et le troisième jour, au matin, il y eut des tonnerres, des éclairs et une épaisse nuée sur la montagne, et un son de trompette très fort; et tout le peuple qui était au camp, trembla. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Alors Moïse fit sortir le peuple du camp, au-devant de Dieu; et ils s'arrêtèrent au pied de la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Or, le mont Sinaï était tout en fumée, parce que l'Éternel y était descendu dans le feu; et sa fumée montait comme la fumée d'une fournaise, et toute la montagne tremblait fort. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Et le son de la trompette allait se renforçant de plus en plus; Moïse parlait, et Dieu lui répondait par une voix. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","L'Éternel descendit donc sur le mont Sinaï, au sommet de la montagne; et l'Éternel appela Moïse au sommet de la montagne, et Moïse y monta. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Et l'Éternel dit à Moïse: Descends, somme le peuple de ne point faire irruption vers l'Éternel, pour voir; de peur qu'un grand nombre d'entre eux ne périsse. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Et même, que les sacrificateurs qui s'approchent de l'Éternel, se sanctifient, de peur que l'Éternel ne les frappe. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Et Moïse dit à l'Éternel: Le peuple ne peut monter vers le mont Sinaï, car tu nous en as fait sommation, en disant: Fixe des limites autour de la montagne, et sanctifie-la. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Et l'Éternel lui dit: Va, descends; puis tu monteras, toi et Aaron avec toi; mais que les sacrificateurs et le peuple ne fassent pas irruption pour monter vers l'Éternel, de peur qu'il ne les frappe. ");
INSERT INTO fra_fob_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moïse donc descendit vers le peuple, et il le leur dit. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Alors Dieu prononça toutes ces paroles, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Je suis l'Éternel ton Dieu, qui t'ai retiré du pays d'Égypte, de la maison de servitude. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Tu n'auras point d'autres dieux devant ma face. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Tu ne te feras point d'image taillée, ni aucune ressemblance des choses qui sont là-haut dans les cieux, ni ici-bas sur la terre, ni dans les eaux sous la terre; ");
INSERT INTO fra_fob_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tu ne te prosterneras point devant elles, et tu ne les serviras point; car je suis l'Éternel ton Dieu, un Dieu jaloux, qui punis l'iniquité des pères sur les enfants, jusqu'à la troisième et à la quatrième génération de ceux qui me haïssent, ");
INSERT INTO fra_fob_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Et qui fais miséricorde jusqu'à mille générations à ceux qui m'aiment et qui gardent mes commandements. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Tu ne prendras point le nom de l'Éternel ton Dieu en vain; car l'Éternel ne tiendra point pour innocent celui qui aura pris son nom en vain. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Souviens-toi du jour du repos pour le sanctifier; ");
INSERT INTO fra_fob_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tu travailleras six jours, et tu feras toute ton œuvre; ");
INSERT INTO fra_fob_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mais le septième jour est le repos de l'Éternel ton Dieu; tu ne feras aucune œuvre en ce jour-là, ni toi, ni ton fils, ni ta fille, ni ton serviteur, ni ta servante, ni ton bétail, ni l'étranger qui est dans tes portes; ");
INSERT INTO fra_fob_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Car l'Éternel a fait en six jours les cieux et la terre, la mer et tout ce qui est en eux, et il s'est reposé le septième jour; c'est pourquoi l'Éternel a béni le jour du repos et l'a sanctifié. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honore ton père et ta mère, afin que tes jours soient prolongés sur la terre que l'Éternel ton Dieu te donne. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Tu ne tueras point. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Tu ne commettras point adultère. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Tu ne déroberas point. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Tu ne diras point de faux témoignage contre ton prochain. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Tu ne convoiteras point la maison de ton prochain; tu ne convoiteras point la femme de ton prochain, ni son serviteur, ni sa servante, ni son bœuf, ni son âne, ni aucune chose qui soit à ton prochain. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Or, tout le peuple entendait les tonnerres et le son de la trompette, et voyait les éclairs et la montagne fumante. Le peuple donc, voyant cela, tremblait et se tenait loin. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Et ils dirent à Moïse: Parle-nous toi-même, et nous écouterons; mais que Dieu ne parle point avec nous, de peur que nous ne mourions. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Et Moïse dit au peuple: Ne craignez point, car Dieu est venu pour vous éprouver, et afin que sa crainte soit devant vous, en sorte que vous ne péchiez point. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Le peuple donc se tint loin; et Moïse s'approcha de l'obscurité où était Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Et l'Éternel dit à Moïse: Tu diras ainsi aux enfants d'Israël: Vous avez vu que je vous ai parlé des cieux. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Vous ne ferez point, à côté de moi, des dieux d'argent, et vous ne ferez point des dieux d'or. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Tu me feras un autel de terre, sur lequel tu sacrifieras tes holocaustes et tes sacrifices de prospérité, tes brebis et tes taureaux. En tout lieu où je ferai célébrer mon nom, je viendrai à toi et je te bénirai. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Que si tu me fais un autel de pierres, tu ne les emploieras point taillées; car si tu levais sur elles ton fer, tu les souillerais. ");
INSERT INTO fra_fob_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Et tu ne monteras point à mon autel par des degrés, afin que ta nudité n'y soit pas découverte. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Ce sont ici les lois que tu leur présenteras: ");
INSERT INTO fra_fob_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Si tu achètes un esclave hébreu, il servira six années, mais la septième il sortira libre, sans rien payer. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","S'il est venu seul, il sortira seul; s'il avait une femme, sa femme sortira avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Si son maître lui donne une femme, et qu'elle lui enfante des fils ou des filles, la femme et ses enfants seront au maître, et il sortira seul. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Que si l'esclave dit: J'aime mon maître, ma femme et mes enfants; je ne veux pas sortir pour être libre; ");
INSERT INTO fra_fob_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Alors son maître l'amènera devant Dieu et le fera approcher de la porte ou du poteau, et son maître lui percera l'oreille avec un poinçon, et il le servira toujours. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Si quelqu'un vend sa fille pour être esclave, elle ne sortira point comme sortent les esclaves. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si elle déplaît à son maître, qui se l'était destinée, il la fera racheter; il n'aura point le pouvoir de la vendre à un peuple étranger, après l'avoir trompée. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Mais s'il la destine à son fils, il fera pour elle selon le droit des filles. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","S'il en prend une autre, il ne retranchera rien pour la première à la nourriture, au vêtement, ni à la cohabitation. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Et s'il ne lui fait pas ces trois choses, elle sortira gratuitement, sans argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Celui qui frappe un homme à mort, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Que s'il ne lui a point dressé d'embûches, mais que Dieu l'ait fait se rencontrer sous sa main, je t'établirai un lieu où il se réfugiera. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Mais si quelqu'un s'est élevé contre son prochain, pour le tuer par ruse, tu le prendras même d'auprès de mon autel, afin qu'il meure. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Celui qui frappe son père ou sa mère, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Celui qui dérobe un homme et le vend, et celui entre les mains duquel il est trouvé, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Celui qui maudit son père ou sa mère, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Quand des hommes se querelleront, et que l'un frappera l'autre d'une pierre, ou du poing, de telle sorte qu'il n'en meure pas, mais qu'il soit obligé de se mettre au lit; ");
INSERT INTO fra_fob_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","S'il se lève, et marche dehors, appuyé sur son bâton, celui qui l'aura frappé sera absous; seulement il paiera son chômage, et le fera guérir entièrement. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Quand un homme frappera son serviteur, ou sa servante, avec le bâton, et qu'ils mourront sous sa main, il ne manquera pas d'être puni. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mais s'ils survivent un jour ou deux, il ne sera pas puni, car c'est son argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Si des hommes se battent, et frappent une femme enceinte, et qu'elle en accouche, sans qu'il arrive malheur, celui qui l'aura frappée sera condamné à l'amende que le mari de la femme lui imposera; et il la donnera devant des juges. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mais s'il arrive malheur, tu donneras vie pour vie, ");
INSERT INTO fra_fob_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Œil pour œil, dent pour dent, main pour main, pied pour pied, ");
INSERT INTO fra_fob_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Brûlure pour brûlure, plaie pour plaie, meurtrissure pour meurtrissure. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Et si quelqu'un frappe l'œil de son serviteur ou l'œil de sa servante, et le leur gâte, il les laissera aller libres pour leur œil. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Que s'il fait tomber une dent à son serviteur ou à sa servante, il les laissera aller libres pour leur dent. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Si un bœuf heurte de sa corne un homme ou une femme, qui en meure, le bœuf sera lapidé, et l'on ne mangera point sa chair, et le maître du bœuf sera absous. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mais si auparavant le bœuf avait accoutumé de heurter de sa corne, et que son maître en ait été averti, et qu'il ne l'ait point surveillé, et qu'il tue un homme ou une femme, le bœuf sera lapidé, et son maître aussi sera mis à mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Si on lui impose un prix pour se racheter, il donnera en rançon de sa vie tout ce qui lui sera imposé. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Si le bœuf heurte de sa corne un fils ou une fille, on le traitera selon cette même loi. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Si le bœuf heurte de sa corne un esclave, soit homme, soit femme, le possesseur du bœuf donnera trente sicles d'argent à son maître, et le bœuf sera lapidé. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Si quelqu'un ouvre une fosse ou si quelqu'un creuse une fosse, et ne la couvre point, et qu'il y tombe un bœuf ou un âne, ");
INSERT INTO fra_fob_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Le maître de la fosse fera restitution; il rendra de l'argent à leur maître; mais ce qui est mort sera à lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Et si le bœuf de quelqu'un blesse le bœuf de son prochain, et qu'il en meure, ils vendront le bœuf vivant et en partageront l'argent, et ils partageront aussi le bœuf mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","S'il est notoire qu'auparavant le bœuf avait accoutumé de heurter de sa corne, et que son maître ne l'ait point gardé, il devra rendre bœuf pour bœuf; mais le bœuf mort sera à lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Si un homme dérobe un bœuf, ou un agneau, et le tue ou le vend, il restituera cinq bœufs pour le bœuf, et quatre agneaux pour l'agneau. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Si le larron est trouvé faisant effraction, et est frappé à mort, celui qui l'aura frappé ne sera point coupable de meurtre. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Mais si le soleil était levé sur lui, il sera coupable de meurtre. Le voleur fera donc restitution; s'il n'a pas de quoi, il sera vendu pour son vol. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Si ce qui a été dérobé est trouvé vivant entre ses mains, soit bœuf, soit âne, soit agneau, il rendra le double. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Si quelqu'un fait du dégât dans un champ, ou dans une vigne, et lâche son bétail, qui paisse dans le champ d'autrui, il rendra le meilleur de son champ et le meilleur de sa vigne. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Si le feu sort et trouve des épines, et que du blé en gerbes, ou la moisson, ou le champ, soit consumé, celui qui aura allumé le feu rendra entièrement ce qui aura été brûlé. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Si un homme donne à son prochain de l'argent ou des objets à garder, et qu'on les dérobe de sa maison; si le larron est découvert, il rendra le double. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Si le larron ne se trouve point, le maître de la maison sera amené devant Dieu, pour jurer s'il n'a point mis la main sur le bien de son prochain. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Dans toute affaire où il y a prévarication, pour un bœuf, pour un âne, pour un agneau, pour un vêtement, pour tout objet perdu, dont on dira: c'est cela, la cause des deux parties viendra devant Dieu; celui que Dieu condamnera, rendra le double à son prochain. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Si quelqu'un donne à garder à son prochain un âne ou un bœuf, ou un agneau, ou quelque bête que ce soit, et qu'elle meure, ou se casse quelque membre, ou soit emmenée sans que personne le voie, ");
INSERT INTO fra_fob_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Le serment de l'Éternel interviendra entre les deux parties, pour savoir s'il n'a point mis la main sur le bien de son prochain; le maître de la bête acceptera le serment, et l'autre ne fera pas restitution. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mais si elle lui a été dérobée, il la rendra à son maître. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Si elle a été déchirée par les bêtes sauvages, il l'apportera en preuve; il ne rendra point ce qui a été déchiré. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Si quelqu'un emprunte de son prochain une bête, et qu'elle se casse quelque membre, ou qu'elle meure, son maître n'étant point avec elle, il en fera la restitution. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Si son maître est avec elle, il n'y aura pas de restitution; si elle a été louée, elle est venue pour son salaire. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Si quelqu'un suborne une vierge qui n'était point fiancée, et couche avec elle, il faudra qu'il paie sa dot et la prenne pour femme. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Si le père de la fille refuse absolument de la lui donner, il lui paiera l'argent qu'on donne pour la dot des vierges. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Tu ne laisseras point vivre la sorcière. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Quiconque couchera avec une bête, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Celui qui sacrifie à d'autres dieux qu'à l'Éternel seul, sera voué à l'extermination. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Tu ne maltraiteras point l'étranger, et tu ne l'opprimeras point; car vous avez été étrangers dans le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Vous n'affligerez aucune veuve ni aucun orphelin. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Si tu les affliges, et qu'ils crient à moi, certainement j'entendrai leur cri; ");
INSERT INTO fra_fob_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Et ma colère s'enflammera, et je vous tuerai par l'épée, et vos femmes seront veuves, et vos enfants orphelins. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Si tu prêtes de l'argent à mon peuple, au malheureux qui est avec toi, tu n'agiras point avec lui comme un usurier; vous ne lui imposerez point d'intérêt. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si tu prends en gage le vêtement de ton prochain, tu le lui rendras avant que le soleil soit couché; ");
INSERT INTO fra_fob_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Car c'est sa seule couverture, c'est son vêtement pour couvrir sa peau. Dans quoi coucherait-il? Et s'il arrive qu'il crie à moi, je l'entendrai, car je suis miséricordieux. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Tu ne blasphémeras point Dieu, et tu ne maudiras point le prince de ton peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Tu ne différeras point le tribut de ce qui remplit ton grenier et de ce qui découle de ton pressoir. Tu me donneras le premier-né de tes fils. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Tu en feras de même de ton bœuf, de tes brebis; leur premier-né sera sept jours avec sa mère, au huitième jour tu me le donneras. ");
INSERT INTO fra_fob_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Vous me serez des hommes saints, et vous ne mangerez point de chair déchirée aux champs par les bêtes sauvages, vous la jetterez aux chiens. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Tu ne sèmeras point de faux bruit; ne prête point la main au méchant pour être faux témoin. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Tu ne suivras point la multitude pour faire le mal; et lorsque tu témoigneras dans un procès, tu ne te détourneras point pour suivre le plus grand nombre et pervertir le droit. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tu ne favoriseras point le pauvre en son procès. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Si tu rencontres le bœuf de ton ennemi, ou son âne, égaré, tu ne manqueras point de le lui ramener. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si tu vois l'âne de celui qui te hait abattu sous son fardeau, tu te garderas de l'abandonner; tu devras le dégager avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Tu ne pervertiras point dans son procès le droit de l'indigent qui est au milieu de toi. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Tu t'éloigneras de toute parole fausse; et tu ne feras point mourir l'innocent et le juste, car je ne justifierai point le méchant. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Tu n'accepteras point de présent, car le présent aveugle les plus éclairés et perd les causes des justes. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Tu n'opprimeras point l'étranger; vous savez vous-mêmes ce qu'éprouve l'étranger, car vous avez été étrangers dans le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Pendant six années tu sèmeras la terre, et tu en recueilleras le produit; ");
INSERT INTO fra_fob_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mais la septième, tu la mettras en jachère et la laisseras reposer; et les pauvres de ton peuple en mangeront les fruits, et les animaux des champs mangeront ce qui restera. Tu en feras de même de ta vigne, de tes oliviers. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Six jours durant tu feras ton ouvrage, mais au septième jour tu te reposeras, afin que ton bœuf et ton âne se reposent, et que le fils de ta servante et l'étranger reprennent des forces. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Vous prendrez garde à tout ce que je vous ai dit. Vous ne ferez point mention du nom des dieux étrangers; on ne l'entendra point sortir de ta bouche. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Trois fois l'année tu me célébreras une fête. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Tu observeras la fête des pains sans levain (tu mangeras des pains sans levain pendant sept jours, comme je te l'ai commandé, à l'époque du mois des épis, car en ce mois-là tu es sorti d'Égypte; et l'on ne se présentera point à vide devant ma face); ");
INSERT INTO fra_fob_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Et la fête de la moisson, des premiers fruits de ton travail, de ce que tu auras semé aux champs; et la fête de la récolte, à la fin de l'année, quand tu auras recueilli des champs les fruits de ton travail. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Trois fois l'an tous les mâles se présenteront devant le Seigneur, l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Tu n'offriras point avec du pain levé le sang de mon sacrifice; et la graisse de ma fête ne passera point la nuit jusqu'au matin. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Tu apporteras les prémices des premiers fruits de la terre à la maison de l'Éternel ton Dieu. Tu ne feras point cuire le chevreau dans le lait de sa mère. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Voici, j'envoie un ange devant toi, pour te garder dans le chemin, et pour t'introduire au lieu que j'ai préparé. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Prends garde à toi en sa présence, et écoute sa voix, ne lui sois point rebelle; car il ne pardonnera point votre péché, parce que mon nom est en lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mais si tu écoutes attentivement sa voix, et si tu fais tout ce que je dirai, je serai l'ennemi de tes ennemis et l'adversaire de tes adversaires; ");
INSERT INTO fra_fob_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Car mon ange marchera devant toi, et t'introduira au pays des Amoréens, des Héthiens, des Phéréziens, des Cananéens, des Héviens, et des Jébusiens, et je les exterminerai. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tu ne te prosterneras point devant leurs dieux, et tu ne les serviras point, et tu n'imiteras point leurs œuvres; mais tu les détruiras complètement, et tu briseras entièrement leurs statues. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Vous servirez l'Éternel votre Dieu, et il bénira ton pain et tes eaux, et j'ôterai la maladie du milieu de toi. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Il n'y aura point en ton pays de femelle qui avorte, ou qui soit stérile. J'accomplirai le nombre de tes jours. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","J'enverrai ma frayeur devant toi, et je mettrai en déroute tout peuple chez lequel tu arriveras, et je ferai tourner le dos à tous tes ennemis devant toi. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Et j'enverrai les frelons devant toi, et ils chasseront les Héviens, les Cananéens, et les Héthiens de devant ta face. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Je ne les chasserai point de devant toi dans une année, de peur que le pays ne devienne un désert, et que les bêtes des champs ne se multiplient contre toi; ");
INSERT INTO fra_fob_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Je les chasserai peu à peu de devant toi, jusqu'à ce que tu croisses en nombre, et que tu te mettes en possession du pays. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Et je poserai tes limites depuis la mer Rouge jusqu'à la mer des Philistins, et depuis le désert jusqu'au fleuve; car je livrerai entre vos mains les habitants du pays, et tu les chasseras devant toi. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tu ne traiteras point alliance avec eux, ni avec leurs dieux. ");
INSERT INTO fra_fob_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ils n'habiteront point dans ton pays, de peur qu'ils ne te fassent pécher contre moi; car tu servirais leurs dieux, et cela te serait un piège. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Et Dieu dit à Moïse: Monte vers l'Éternel, toi et Aaron, Nadab et Abihu, et soixante et dix des anciens d'Israël, et vous vous prosternerez de loin. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Et Moïse s'approchera seul de l'Éternel; mais eux ne s'en approcheront point, et le peuple ne montera point avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Alors Moïse vint, et rapporta au peuple toutes les paroles de l'Éternel et toutes les lois. Et tout le peuple répondit d'une seule voix, et dit: Nous ferons toutes les choses que l'Éternel a dites. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Et Moïse écrivit toutes les paroles de l'Éternel, et il se leva de bon matin, et bâtit un autel au bas de la montagne, et dressa douze colonnes pour les douze tribus d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Et il envoya les jeunes gens des enfants d'Israël, qui offrirent des holocaustes, et sacrifièrent des sacrifices de prospérité à l'Éternel, savoir de jeunes taureaux. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Et Moïse prit la moitié du sang, et le mit dans les bassins, et il répandit l'autre moitié sur l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Puis il prit le livre de l'alliance, et il le lut au peuple qui l'écoutait et qui dit: Nous ferons tout ce que l'Éternel a dit, et nous obéirons. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moïse prit donc le sang, et le répandit sur le peuple, et dit: Voici le sang de l'alliance que l'Éternel a traitée avec vous selon toutes ces paroles. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Et Moïse et Aaron, Nadab et Abihu, et soixante et dix des anciens d'Israël montèrent, ");
INSERT INTO fra_fob_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Et ils virent le Dieu d'Israël; et sous ses pieds il y avait comme un ouvrage de saphir transparent, pareil aux cieux mêmes en éclat. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Et il n'étendit point sa main sur ceux qui avaient été choisis d'entre les enfants d'Israël; mais ils virent Dieu, et ils mangèrent et burent. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Et l'Éternel dit à Moïse: Monte vers moi sur la montagne, et demeure là, et je te donnerai des tables de pierre, et la loi et les commandements que j'ai écrits pour les instruire. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Alors Moïse se leva avec Josué qui le servait; et Moïse monta sur la montagne de Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Et il dit aux anciens: Attendez-nous ici jusqu'à ce que nous revenions vers vous; et voici, Aaron et Hur sont avec vous; quiconque aura quelque affaire, s'adressera à eux. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moïse monta donc sur la montagne, et la nuée couvrit la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Et la gloire de l'Éternel demeura sur le mont Sinaï, et la nuée le couvrit pendant six jours, et au septième jour il appela Moïse du milieu de la nuée. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Et l'aspect de la gloire de l'Éternel était comme un feu dévorant, au sommet de la montagne, aux yeux des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Et Moïse entra au milieu de la nuée et monta sur la montagne; et Moïse fut sur la montagne quarante jours et quarante nuits. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Parle aux enfants d'Israël, et qu'ils prennent une offrande pour moi. Vous recevrez mon offrande de tout homme que son cœur y disposera. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Et voici l'offrande que vous recevrez d'eux: de l'or, de l'argent et de l'airain, ");
INSERT INTO fra_fob_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","De la pourpre, de l'écarlate, du cramoisi, du fin lin, du poil de chèvre, ");
INSERT INTO fra_fob_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Des peaux de bélier teintes en rouge, et des peaux de couleur d'hyacinthe, du bois de Sittim, ");
INSERT INTO fra_fob_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","De l'huile pour le luminaire, des aromates pour l'huile de l'onction, et pour le parfum aromatique, ");
INSERT INTO fra_fob_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Des pierres d'onyx et des pierres d'enchâssure pour l'éphod et pour le pectoral. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Et ils me feront un sanctuaire, et j'habiterai au milieu d'eux; ");
INSERT INTO fra_fob_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Vous le ferez exactement semblable au modèle de la Demeure et au modèle de tous ses ustensiles, que je vais te montrer. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ils feront donc une arche de bois de Sittim; sa longueur sera de deux coudées et demie, sa largeur d'une coudée et demie, et sa hauteur d'une coudée et demie. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Tu la couvriras d'or pur; tu la couvriras par dedans et par dehors, et tu mettras dessus un couronnement d'or tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Et tu fondras quatre anneaux d'or que tu mettras à ses quatre coins: deux anneaux d'un côté, et deux anneaux de l'autre côté. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Tu feras aussi des barres de bois de Sittim, et tu les couvriras d'or. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Et tu feras entrer les barres dans les anneaux, aux côtés de l'arche, pour porter l'arche au moyen des barres. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Les barres seront dans les anneaux de l'arche; on ne les en retirera point. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Et tu mettras dans l'arche le Témoignage que je te donnerai. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Tu feras aussi un propitiatoire d'or pur, dont la longueur sera de deux coudées et demie, et la largeur d'une coudée et demie. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Et tu feras deux chérubins d'or; tu les feras au marteau, aux deux bouts du propitiatoire. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Fais donc un chérubin à ce bout, et un chérubin à l'autre bout. Vous ferez les chérubins sortant du propitiatoire à ses deux bouts. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Et les chérubins étendront les ailes en haut, couvrant de leurs ailes le propitiatoire, et leurs faces seront vis-à-vis l'une de l'autre. La face des chérubins sera dirigée vers le propitiatoire. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Et tu poseras le propitiatoire en haut sur l'arche, et tu mettras dans l'arche le Témoignage que je te donnerai. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Et je me rencontrerai là avec toi, et je te dirai, de dessus le propitiatoire, d'entre les deux chérubins qui seront sur l'arche du Témoignage, tout ce que je te commanderai pour les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Tu feras aussi une table de bois de Sittim; sa longueur sera de deux coudées, sa largeur d'une coudée, et sa hauteur d'une coudée et demie. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tu la couvriras d'or pur, et tu lui feras un couronnement d'or tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Tu lui feras aussi, à l'entour, un rebord de quatre doigts, et tu feras à ce rebord un couronnement d'or tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tu lui feras aussi quatre anneaux d'or, et tu mettras les anneaux aux quatre coins qui seront à ses quatre pieds. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Les anneaux seront près du rebord, afin d'y mettre des barres, pour porter la table. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tu feras les barres de bois de Sittim, et tu les couvriras d'or, et on portera la table avec elles. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tu feras aussi ses plats, ses tasses, ses vases et ses coupes, avec lesquels on fera les libations; tu les feras d'or pur. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Et tu mettras sur la table du pain de proposition qui sera continuellement devant moi. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Tu feras aussi un chandelier d'or pur. Le chandelier, son pied et sa tige seront faits au marteau; ses calices, ses pommes et ses fleurs en seront tirés. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Il sortira six branches de ses côtés: trois branches du chandelier d'un côté, et trois branches du chandelier de l'autre côté. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Il y aura trois calices en forme d'amande, à une branche, avec pomme et fleur; et trois calices en forme d'amande à l'autre branche, avec pomme et fleur. Il en sera de même pour les six branches sortant du chandelier. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Il y aura au chandelier même quatre calices en forme d'amande, et ses pommes et ses fleurs: ");
INSERT INTO fra_fob_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Une pomme sous les deux branches qui en sortent, une autre pomme sous les deux autres branches, et encore une pomme sous les deux autres branches qui en sortent, pour les six branches sortant du chandelier. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ses pommes et ses branches en seront tirées; il sera tout entier d'une seule pièce au marteau, en or pur. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Tu feras aussi ses sept lampes; et l'on allumera ses lampes, de manière qu'elles éclairent en avant du chandelier. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Et ses mouchettes, et ses porte-mouchettes seront d'or pur. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","On fera ce chandelier, avec tous ses ustensiles, d'un talent d'or pur. ");
INSERT INTO fra_fob_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Regarde donc, et fais-les d'après leur modèle, qui t'a été montré sur la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Et tu feras la Demeure de dix tentures de fin lin retors, de pourpre, d'écarlate, et de cramoisi, avec des chérubins que tu feras en ouvrage d'art. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","La longueur d'une tenture sera de vingt-huit coudées, et la largeur de la même tenture de quatre coudées; toutes les tentures auront une même mesure. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cinq tentures seront jointes l'une à l'autre, et les cinq autres tentures seront aussi jointes l'une à l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tu feras aussi des lacets de pourpre sur le bord de la première tenture, au bout de l'assemblage; et tu feras de même au bord de la dernière tenture, dans le second assemblage. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Tu feras cinquante lacets à la première tenture, et tu feras cinquante lacets au bout de la tenture qui sera dans le second assemblage. Les lacets seront en face l'un de l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Tu feras cinquante crochets d'or, et tu joindras les tentures l'une à l'autre avec les crochets, pour que la Demeure forme un seul tout. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Tu feras aussi des tentures de poil de chèvre, pour servir de tabernacle sur la Demeure. Tu feras onze de ces tentures. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","La longueur d'une tenture sera de trente coudées, et la largeur de la même tenture de quatre coudées; les onze tentures auront une même mesure. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Et tu joindras cinq de ces tentures à part, et les six autres tentures à part; mais tu redoubleras la sixième tenture sur le devant du tabernacle. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Tu feras aussi cinquante lacets sur le bord de la première tenture, la dernière de l'assemblage, et cinquante lacets sur le bord de la tenture du second assemblage. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tu feras aussi cinquante crochets d'airain, et tu feras entrer les crochets dans les lacets, et tu assembleras ainsi le tabernacle, pour qu'il forme un seul tout. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Mais le surplus qui flottera des tentures du tabernacle, savoir la moitié de la tenture qui sera de reste, flottera sur le derrière de la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Et la coudée d'un côté, et la coudée de l'autre, de ce qui sera de reste dans la longueur des tentures du tabernacle, sera flottant sur les flancs de la Demeure, d'un côté et de l'autre, pour la couvrir. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tu feras aussi pour le tabernacle une couverture de peaux de bélier teintes en rouge, et une couverture de peaux de couleur d'hyacinthe par-dessus. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Et tu feras pour la Demeure des planches en bois de Sittim, qu'on fera tenir debout. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","La longueur d'une planche sera de dix coudées, et la largeur de la même planche d'une coudée et demie. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Il y aura deux tenons à chaque planche, parallèles l'un à l'autre; tu feras de même pour toutes les planches de la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Tu feras donc les planches pour la Demeure: vingt planches du côté du Sud, vers le Midi. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Et sous les vingt planches tu feras quarante soubassements d'argent: deux soubassements sous une planche, pour ses deux tenons, et deux soubassements sous une autre planche, pour ses deux tenons. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Et tu feras vingt planches pour l'autre côté de la Demeure, du côté du Nord, ");
INSERT INTO fra_fob_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Et leurs quarante soubassements d'argent; deux soubassements sous une planche, et deux soubassements sous une autre planche. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Tu feras six planches pour le fond de la Demeure vers l'Occident. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Tu feras aussi deux planches pour les angles de la Demeure, au fond. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Elles seront doubles par le bas, mais en même temps elles seront pleines par le haut jusqu'au premier anneau; il en sera ainsi pour toutes les deux; elles seront pour les deux angles. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Il y aura donc huit planches et leurs seize soubassements d'argent; deux soubassements sous une planche, et deux soubassements sous une autre planche. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Tu feras aussi cinq traverses de bois de Sittim, pour les planches d'un côté de la Demeure; ");
INSERT INTO fra_fob_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Et cinq traverses pour les planches de l'autre côté de la Demeure; et cinq autres traverses pour les planches du côté de la Demeure formant le fond, vers l'Occident. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Et la traverse du milieu, qui sera au milieu des planches, ira d'un bout à l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tu couvriras d'or les planches et tu feras leurs anneaux d'or, pour y mettre les traverses; et tu couvriras d'or les traverses. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tu dresseras donc la Demeure selon la forme qui t'en a été montrée sur la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Et tu feras un voile de pourpre, d'écarlate, de cramoisi et de fin lin retors; on le fera en ouvrage d'art, avec des chérubins. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Et tu le mettras sur quatre colonnes de bois de Sittim couvertes d'or; leurs clous seront en or; elles reposeront sur quatre soubassements d'argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Et tu mettras le voile sous les crochets des tentures; et là, en dedans du voile, tu feras entrer l'arche du Témoignage; et le voile séparera pour vous le lieu saint d'avec le lieu très-saint. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Et tu poseras le propitiatoire sur l'arche du Témoignage dans le lieu très-saint. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Et tu mettras la table en dehors du voile, et le chandelier vis-à-vis de la table, du côté de la Demeure qui sera vers le Midi; et tu placeras la table du côté du Nord. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Et pour l'entrée du tabernacle tu feras une tapisserie de pourpre, d'écarlate, de cramoisi et de fin lin retors, en ouvrage de broderie. ");
INSERT INTO fra_fob_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Et tu feras pour cette tapisserie cinq colonnes de bois de Sittim, que tu couvriras d'or; leurs clous seront en or; et tu leur fondras cinq soubassements d'airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Tu feras aussi l'autel en bois de Sittim, cinq coudées de long, et cinq coudées de large; l'autel sera carré, et sa hauteur sera de trois coudées. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Et tu feras à ses quatre coins des cornes qui sortiront de l'autel; et tu le couvriras d'airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Tu feras ses chaudrons pour ôter ses cendres, et ses pelles, et ses coupes, et ses fourchettes, et ses encensoirs; et tu feras tous ses ustensiles en airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Tu lui feras une grille en treillis d'airain, et tu feras au treillis quatre anneaux d'airain, à ses quatre coins. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Et tu le mettras sous la corniche de l'autel, depuis le bas, et le treillis s'élèvera jusqu'au milieu de l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Tu feras aussi des barres pour l'autel, des barres de bois de Sittim, et tu les couvriras d'airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Et on fera entrer les barres dans les anneaux; et les barres seront aux deux côtés de l'autel, quand on le portera. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tu le feras creux, en planches; on le fera tel qu'il t'a été montré sur la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Tu feras aussi le parvis de la Demeure. Pour le côté du Sud, vers le Midi, il y aura pour le parvis des tentures en fin lin retors, de cent coudées de long pour un côté; ");
INSERT INTO fra_fob_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Et vingt colonnes et leurs vingt soubassements d'airain; les clous des colonnes et leurs tringles, en argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Et de même, pour le côté du Nord, il y aura dans la longueur, cent coudées de tentures, et vingt colonnes et leurs vingt soubassements d'airain; les clous des colonnes et leurs tringles, en argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","La largeur du parvis, du côté de l'Occident, sera de cinquante coudées de tentures, qui auront dix colonnes et leurs dix soubassements. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Et la largeur du parvis, du côté de devant, vers l'Orient, sera de cinquante coudées: ");
INSERT INTO fra_fob_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","A l'un des côtés, il y aura quinze coudées de tentures, avec leurs trois colonnes et leurs trois soubassements; ");
INSERT INTO fra_fob_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Et à l'autre côté, quinze coudées de tentures, leurs trois colonnes et leurs trois soubassements. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Il y aura aussi, pour la porte du parvis, une tapisserie de vingt coudées, en pourpre, écarlate, cramoisi et fin lin retors, en ouvrage de broderie, leurs quatre colonnes et leurs quatre soubassements. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Toutes les colonnes autour du parvis seront jointes par des tringles d'argent; leurs clous seront d'argent, et leurs soubassements d'airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","La longueur du parvis sera de cent coudées; la largeur, de cinquante de chaque côté, et la hauteur, de cinq coudées; il sera de fin lin retors, et les soubassements seront d'airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Quant à tous les ustensiles de la Demeure, pour tout son service, et tous ses pieux, et tous les pieux du parvis, ils seront d'airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Et tu commanderas aux enfants d'Israël qu'ils t'apportent de l'huile pure d'olives broyées, pour le luminaire, afin de tenir la lampe continuellement allumée. ");
INSERT INTO fra_fob_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Dans le tabernacle d'assignation, en dehors du voile qui est devant le Témoignage, Aaron avec ses fils l'arrangera, pour luire en la présence de l'Éternel, depuis le soir jusqu'au matin. Ce sera pour leurs générations une ordonnance perpétuelle, qui sera observée par les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Fais aussi approcher de toi, d'entre les enfants d'Israël, Aaron ton frère, avec ses fils, pour exercer devant moi la sacrificature: Aaron, Nadab et Abihu, Éléazar et Ithamar, fils d'Aaron. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Et tu feras à Aaron, ton frère, des vêtements sacrés, pour sa gloire et pour son ornement. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Et tu parleras à tous ceux qui sont intelligents, que j'ai remplis d'un esprit de sagesse, et ils feront les vêtements d'Aaron pour le consacrer, pour qu'il exerce la sacrificature devant moi. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Et voici les vêtements qu'ils feront: Le pectoral, l'éphod, la robe, la tunique brodée, la tiare et la ceinture. Ils feront donc des vêtements sacrés à Aaron, ton frère, et à ses fils, pour qu'ils exercent devant moi la sacrificature. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Et ils prendront de l'or, de la pourpre, de l'écarlate, du cramoisi et du fin lin. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Et ils feront l'éphod d'or, de pourpre, d'écarlate, de cramoisi et de fin lin retors, en ouvrage d'art. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Il y aura à ses deux extrémités deux épaulettes qui se joindront; et c'est ainsi qu'il sera joint. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","La ceinture pour l'attacher, qui se mettra par-dessus, sera du même ouvrage et de la même pièce; elle sera d'or, de pourpre, d'écarlate et de fin lin retors. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Et tu prendras deux pierres d'onyx, et tu graveras sur elles les noms des enfants d'Israël: ");
INSERT INTO fra_fob_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Six de leurs noms sur une pierre, et les six autres noms sur la seconde pierre, d'après l'ordre de leurs naissances. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Tu graveras sur les deux pierres, en travail de lapidaire, en gravure de cachet, les noms des enfants d'Israël; tu les enchâsseras dans des chatons d'or. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Et tu mettras les deux pierres sur les épaulettes de l'éphod, comme des pierres de mémorial pour les enfants d'Israël; et Aaron portera leurs noms devant l'Éternel, sur ses deux épaules, en mémorial. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Tu feras aussi des agrafes d'or, ");
INSERT INTO fra_fob_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Et deux chaînettes d'or pur, que tu tresseras en forme de cordons, et tu mettras dans les agrafes les chaînettes ainsi tressées. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Tu feras aussi le pectoral du jugement en ouvrage d'art; tu le feras comme l'ouvrage de l'éphod; tu le feras d'or, de pourpre, d'écarlate, de cramoisi et de fin lin retors. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Il sera carré et double; sa longueur sera d'un empan, et sa largeur d'un empan. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Et tu le garniras d'une garniture de pierreries à quatre rangs de pierres: au premier rang, une sardoine, une topaze et une émeraude; ");
INSERT INTO fra_fob_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Au second rang une escarboucle, un saphir et une calcédoine; ");
INSERT INTO fra_fob_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Au troisième rang, une opale, une agate et une améthyste; ");
INSERT INTO fra_fob_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Et au quatrième rang, un chrysolithe, un onyx et un jaspe. Ces pierres seront enchâssées dans de l'or, dans leurs garnitures. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Et les pierres, selon les noms des enfants d'Israël, seront au nombre de douze, d'après leurs noms; elles seront pour les douze tribus, chacune d'après son nom, en gravure de cachet. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Tu feras aussi, sur le pectoral, des chaînettes, tressées en forme de cordons, en or pur. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Puis tu feras sur le pectoral deux anneaux d'or; et tu mettras les deux anneaux aux deux extrémités du pectoral. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Et tu mettras les deux cordons d'or aux deux anneaux, aux extrémités du pectoral. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Et tu mettras les deux bouts des deux cordons aux deux agrafes; et tu les mettras sur les épaulettes de l'éphod sur le devant. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Tu feras aussi deux autres anneaux d'or, et tu les mettras sur les deux autres extrémités du pectoral, sur le bord qui sera du côté de l'éphod, en dedans. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Et tu feras deux autres anneaux d'or, et tu les mettras aux deux épaulettes de l'éphod par le bas, sur le devant, à côté de l'endroit où il se joint, au-dessus de la ceinture de l'éphod. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Et on attachera le pectoral par ses anneaux aux anneaux de l'éphod, avec un cordon de pourpre, afin qu'il tienne sur la ceinture de l'éphod, et que le pectoral ne se détache pas de l'éphod. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ainsi Aaron portera les noms des enfants d'Israël, au pectoral du jugement, sur son cœur, quand il entrera dans le lieu saint, pour servir continuellement de mémorial devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Et tu mettras sur le pectoral du jugement l'Urim et le Thummim, et ils seront sur le cœur d'Aaron quand il entrera devant l'Éternel; et Aaron portera le jugement des enfants d'Israël sur son cœur, devant l'Éternel, continuellement. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Tu feras aussi la robe de l'éphod, entièrement de pourpre. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Et l'ouverture pour passer la tête sera au milieu; il y aura une bordure à son ouverture tout autour, d'ouvrage tissé, comme l'ouverture d'une cotte d'armes, afin qu'elle ne se déchire pas. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Et tu mettras à ses bords des grenades de pourpre, d'écarlate, et de cramoisi, à ses bords, tout autour; et des clochettes d'or entremêlées, tout autour: ");
INSERT INTO fra_fob_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Une clochette d'or et une grenade, une clochette d'or et une grenade, aux bords de la robe, tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Or, Aaron en sera revêtu pour faire le service; et on en entendra le son, quand il entrera dans le lieu saint devant l'Éternel, et quand il en sortira; et il ne mourra point. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Tu feras aussi une lame d'or pur, sur laquelle tu graveras, en gravure de cachet: SAINTETÉ A L'ÉTERNEL. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Tu la mettras sur un cordon de pourpre; elle sera sur la tiare, sur le devant de la tiare; ");
INSERT INTO fra_fob_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Et elle sera sur le front d'Aaron; et Aaron portera les iniquités que les enfants d'Israël auront commises dans les saintes oblations qu'ils offriront, dans toutes leurs saintes offrandes; et elle sera sur son front continuellement, pour les rendre agréables devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Tu feras aussi la tunique en tissu de fin lin, et tu feras une tiare de fin lin; mais tu feras la ceinture en ouvrage de broderie. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Tu feras aussi pour les fils d'Aaron des tuniques, des ceintures et des mitres pour leur gloire et pour leur ornement. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Et tu en revêtiras Aaron, ton frère, et ses fils avec lui; tu les oindras, tu les installeras, et tu les consacreras, afin qu'ils exercent la sacrificature devant moi. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Fais-leur aussi des caleçons de lin, pour couvrir leur nudité; qu'ils tiennent depuis les reins jusqu'aux cuisses. ");
INSERT INTO fra_fob_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Et Aaron et ses fils en seront revêtus quand ils entreront dans le tabernacle d'assignation, ou quand ils approcheront de l'autel, pour faire le service dans le lieu saint, et ils ne seront point coupables, et ne mourront point. C'est une ordonnance perpétuelle pour lui et pour sa postérité après lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Et voici ce que tu leur feras pour les consacrer, pour qu'ils exercent devant moi la sacrificature. Prends un jeune taureau, et deux béliers sans défaut, ");
INSERT INTO fra_fob_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Et des pains sans levain, et des gâteaux sans levain pétris à l'huile, et des beignets sans levain, oints d'huile; tu les feras de fine farine de froment. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Tu les mettras sur une corbeille, et tu les présenteras dans la corbeille; tu présenteras aussi le jeune taureau et les deux béliers. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Alors tu feras approcher Aaron et ses fils à l'entrée du tabernacle d'assignation, et tu les laveras avec de l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Puis tu prendras les vêtements, et tu revêtiras Aaron de la tunique, de la robe de l'éphod, de l'éphod et du pectoral, et tu le ceindras de la ceinture de l'éphod. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Et tu mettras la tiare sur sa tête, et tu placeras la couronne de sainteté sur la tiare. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Et tu prendras l'huile de l'onction; tu la répandras sur sa tête, et tu l'oindras. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Tu feras approcher ses fils, et tu les revêtiras de tuniques. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Et tu ceindras de ceintures Aaron et ses fils, et tu leur attacheras des mitres, et la sacrificature leur appartiendra par ordonnance perpétuelle. C'est ainsi que tu installeras Aaron et ses fils. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Ensuite tu feras approcher le jeune taureau devant le tabernacle d'assignation, et Aaron et ses fils appuieront leurs mains sur la tête de ce taureau. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Et tu égorgeras le taureau devant l'Éternel, à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Puis tu prendras du sang du taureau, et tu en mettras avec ton doigt sur les cornes de l'autel; et tu répandras tout le sang au pied de l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tu prendras aussi toute la graisse qui couvre les entrailles, la membrane qui recouvre le foie, les deux rognons et la graisse qui est dessus, et tu les feras fumer sur l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mais tu brûleras au feu la chair du taureau, sa peau et ses excréments, hors du camp; c'est un sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Tu prendras aussi l'un des béliers, et Aaron et ses fils appuieront leurs mains sur la tête du bélier. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Et tu égorgeras le bélier, et tu prendras son sang, et tu le répandras sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Puis tu couperas le bélier en morceaux, et tu laveras ses entrailles et ses jambes, et tu les mettras sur ses morceaux et sur sa tête; ");
INSERT INTO fra_fob_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Et tu feras fumer tout le bélier sur l'autel; c'est un holocauste à l'Éternel, c'est une agréable odeur, un sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Puis tu prendras le second bélier, et Aaron et ses fils appuieront leurs mains sur la tête du bélier, ");
INSERT INTO fra_fob_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Et tu égorgeras le bélier, et tu prendras de son sang; tu en mettras sur le bout de l'oreille droite d'Aaron, sur le bout de l'oreille droite de ses fils, sur le pouce de leur main droite et sur le gros orteil de leur pied droit, et tu répandras le reste du sang sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Et tu prendras du sang qui sera sur l'autel, et de l'huile de l'onction, et tu en feras aspersion sur Aaron et sur ses vêtements, sur ses fils et sur les vêtements de ses fils avec lui. Ainsi il sera consacré, lui et ses vêtements, et ses fils, et les vêtements de ses fils avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Tu prendras aussi la graisse du bélier, la queue, la graisse qui couvre les entrailles, la membrane qui recouvre le foie, les deux rognons, la graisse qui est dessus, et la jambe droite, car c'est un bélier d'installation. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Tu prendras aussi une miche de pain, un gâteau de pain à l'huile, et un beignet, de la corbeille des pains sans levain, qui sera devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Et tu mettras toutes ces choses sur les paumes des mains d'Aaron, et sur les paumes des mains de ses fils, et tu les agiteras en offrande devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Puis tu les prendras de leurs mains, et tu les feras fumer sur l'autel, sur l'holocauste, en agréable odeur devant l'Éternel; c'est un sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Tu prendras aussi la poitrine du bélier de l'installation, qui est pour Aaron, et tu l'agiteras en offrande devant l'Éternel, et ce sera ta part. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Tu consacreras donc la poitrine de l'offrande agitée, et la jambe de l'offrande élevée, tout ce qui aura été agité et ce qui aura été élevé du bélier de l'installation, de ce qui est pour Aaron, et de ce qui est pour ses fils. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Et ce sera pour Aaron et pour ses fils, par ordonnance perpétuelle, de la part des enfants d'Israël; car c'est une offrande élevée. Ce sera une offrande élevée, de la part des enfants d'Israël, dans leurs sacrifices de prospérités; leur offrande élevée sera à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Et les vêtements sacrés d'Aaron seront à ses enfants après lui, afin qu'ils soient oints et installés dans ces vêtements. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Celui de ses fils qui sera sacrificateur à sa place, et qui viendra au tabernacle d'assignation pour faire le service dans le lieu saint, en sera revêtu pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Puis tu prendras le bélier de l'installation, et tu feras bouillir sa chair dans un lieu saint. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Et Aaron et ses fils mangeront, à l'entrée du tabernacle d'assignation, la chair du bélier, et le pain qui sera dans la corbeille. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ils mangeront donc ces choses, par lesquelles l'expiation aura été faite pour les installer, pour les consacrer; mais un étranger n'en mangera point, car elles sont consacrées. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","S'il reste de la chair de l'installation et du pain jusqu'au lendemain, tu brûleras ce reste au feu. On n'en mangera point; c'est une chose consacrée. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Tu feras donc ainsi pour Aaron et pour ses fils, selon tout ce que je t'ai commandé; tu les installeras pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Tu sacrifieras pour le péché, chaque jour, un jeune taureau, pour faire l'expiation; et tu offriras pour l'autel un sacrifice pour le péché, en faisant expiation pour lui, et tu l'oindras pour le consacrer. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Pendant sept jours tu feras expiation pour l'autel, et tu le consacreras, et l'autel sera une chose très sainte; tout ce qui touchera l'autel sera consacré. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Et voici ce que tu offriras sur l'autel: deux agneaux d'un an, chaque jour, continuellement. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Tu offriras l'un des agneaux le matin; et le second, tu l'offriras entre les deux soirs, ");
INSERT INTO fra_fob_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Avec un dixième de fine farine, pétri dans le quart d'un hin d'huile vierge, et une libation d'un quart de hin de vin, pour le premier agneau. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Et tu offriras le second agneau entre les deux soirs; tu y feras la même oblation que le matin, et la même libation, en agréable odeur, en sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","C'est un holocauste que vous offrirez continuellement, dans vos générations, à l'entrée du tabernacle d'assignation devant l'Éternel, où je me trouverai avec vous pour te parler. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Je me trouverai donc là avec les enfants d'Israël, et ce lieu sera consacré par ma gloire. Je consacrerai donc le tabernacle d'assignation et l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Je consacrerai aussi Aaron et ses fils, pour exercer la sacrificature devant moi. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Et je demeurerai au milieu des enfants d'Israël, et je serai leur Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Et ils sauront que je suis l'Éternel leur Dieu, qui les ai fait sortir du pays d'Égypte, pour demeurer au milieu d'eux. Je suis l'Éternel, leur Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Tu feras aussi un autel pour y faire fumer le parfum, tu le feras de bois de Sittim. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Sa longueur sera d'une coudée, sa largeur d'une coudée; il sera carré; mais sa hauteur sera de deux coudées. L'autel aura des cornes qui en sortiront. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Tu le couvriras d'or pur, le dessus, les côtés tout autour et les cornes; et tu lui feras un couronnement d'or tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tu lui feras aussi deux anneaux d'or au-dessous de son couronnement, à ses deux côtés. Tu les mettras aux deux côtés, et ce sera pour recevoir les barres qui serviront à le porter. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tu feras les barres de bois de Sittim, et tu les couvriras d'or. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Et tu mettras l'autel au-devant du voile, qui est devant l'arche du Témoignage, en face du propitiatoire qui est sur le Témoignage, où je me trouverai avec toi. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Et Aaron y fera fumer un parfum d'aromates; chaque matin, quand il préparera les lampes, il fera fumer le parfum. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Et quand Aaron allumera les lampes, entre les deux soirs, il le fera aussi fumer; c'est un parfum qu'on brûlera continuellement devant l'Éternel dans vos générations. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Vous n'offrirez sur cet autel aucun parfum étranger, ni holocauste, ni offrande, et vous n'y ferez aucune libation. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Mais Aaron fera expiation sur les cornes de cet autel, une fois l'an. Avec le sang du sacrifice expiatoire pour le péché, il y fera expiation, une fois l'an, dans vos générations. Ce sera une chose très sainte et consacrée à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Quand tu feras le compte des enfants d'Israël, selon leurs recensements, chacun d'eux fera un don à l'Éternel, pour racheter sa personne, lorsqu'on en fera le dénombrement; et ils ne seront frappés d'aucune plaie lorsqu'on les dénombrera. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Tous ceux qui passeront par le dénombrement, donneront un demi-sicle, selon le sicle du sanctuaire, qui est de vingt oboles; un demi-sicle sera donc l'offrande à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Tous ceux qui passeront par le dénombrement, depuis vingt ans et au-dessus, donneront l'offrande de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Le riche n'augmentera rien, et le pauvre ne diminuera rien du demi-sicle, en donnant l'offrande de l'Éternel, pour faire la propitiation pour vos personnes. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tu prendras donc des enfants d'Israël l'argent des propitiations, et tu l'appliqueras au service du tabernacle d'assignation; et il sera pour les enfants d'Israël en mémorial devant l'Éternel, pour faire la propitiation de vos personnes. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Tu feras aussi une cuve d'airain, avec sa base d'airain, pour s'y laver; tu la mettras entre le tabernacle d'assignation et l'autel, et tu y mettras de l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Et Aaron et ses fils en laveront leurs mains et leurs pieds. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Quand ils entreront au tabernacle d'assignation, ils se laveront avec de l'eau, afin qu'ils ne meurent pas, ou quand ils approcheront de l'autel pour faire le service, pour faire fumer le sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ils laveront donc leurs mains et leurs pieds, afin qu'ils ne meurent pas. Ce leur sera une ordonnance perpétuelle, pour Aaron et pour sa postérité dans leurs générations. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Prends des aromates exquis, de la myrrhe liquide, cinq cents sicles; du cinnamome odoriférant, la moitié, c'est-à-dire, deux cent cinquante; du roseau aromatique, deux cent cinquante; ");
INSERT INTO fra_fob_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","De la casse, cinq cents, selon le sicle du sanctuaire; et un hin d'huile d'olive; ");
INSERT INTO fra_fob_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Et tu en feras une huile pour l'onction sainte, un mélange odoriférant composé selon l'art du parfumeur; ce sera l'huile de l'onction sainte. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Et tu en oindras le tabernacle d'assignation et l'arche du Témoignage, ");
INSERT INTO fra_fob_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","La table et tous ses ustensiles, le chandelier et ses ustensiles, ");
INSERT INTO fra_fob_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","L'autel du parfum, l'autel des holocaustes et tous ses ustensiles, et la cuve et sa base. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ainsi tu les consacreras, et ils seront une chose très sainte; tout ce qui les touchera sera sacré. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Tu oindras aussi Aaron et ses fils, et tu les consacreras pour exercer devant moi la sacrificature. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Et tu parleras aux enfants d'Israël, en disant: Ceci me sera une huile d'onction sacrée dans toutes vos générations. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","On ne la versera point sur la chair de l'homme, et vous n'en ferez point d'autre de même composition; elle est sainte, elle vous sera sainte. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Celui qui fera une composition semblable, et qui en mettra sur un étranger, sera retranché d'entre ses peuples. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","L'Éternel dit aussi à Moïse: Prends des aromates, du stacte, de l'onyx et du galbanum, des aromates et de l'encens pur, en parties égales; ");
INSERT INTO fra_fob_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Et tu en feras un parfum, un mélange selon l'art du parfumeur, salé, pur, saint; ");
INSERT INTO fra_fob_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tu en pileras bien menu une partie, et tu en mettras devant le Témoignage, dans le tabernacle d'assignation, où je me trouverai avec toi; ce vous sera une chose très sainte. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Quant au parfum que tu feras, vous ne vous en ferez point de même composition; ce sera pour toi une chose consacrée à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Celui qui en fera de semblable pour en sentir l'odeur, sera retranché d'entre ses peuples. ");
INSERT INTO fra_fob_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Vois, j'ai appelé par son nom Betsaléel, fils d'Uri, fils de Hur, de la tribu de Juda; ");
INSERT INTO fra_fob_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Et je l'ai rempli de l'esprit de Dieu, en intelligence, en industrie et en science, et pour toutes sortes d'ouvrages; ");
INSERT INTO fra_fob_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Pour faire des inventions, pour travailler l'or, l'argent et l'airain, ");
INSERT INTO fra_fob_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Pour tailler et enchâsser des pierreries, pour tailler le bois et exécuter toutes sortes d'ouvrages. ");
INSERT INTO fra_fob_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Et voici, je lui ai donné pour compagnon Oholiab, fils d'Ahisamac, de la tribu de Dan; et j'ai mis de l'industrie dans le cœur de tout homme intelligent, afin qu'ils fassent tout ce que je t'ai commandé de faire: ");
INSERT INTO fra_fob_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Le tabernacle d'assignation, l'arche pour le Témoignage et le propitiatoire qui sera dessus, et tous les ustensiles du tabernacle; ");
INSERT INTO fra_fob_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","La table et ses ustensiles, le chandelier d'or pur et tous ses ustensiles, l'autel du parfum, ");
INSERT INTO fra_fob_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","L'autel de l'holocauste et tous ses ustensiles, la cuve et sa base; ");
INSERT INTO fra_fob_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Les vêtements du service, les vêtements sacrés pour Aaron le sacrificateur, et les vêtements de ses fils pour exercer la sacrificature; ");
INSERT INTO fra_fob_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","L'huile de l'onction, et le parfum d'aromates pour le sanctuaire. Ils feront selon tout ce que je t'ai commandé. ");
INSERT INTO fra_fob_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Et toi, parle aux enfants d'Israël, et dis: Seulement, vous observerez mes sabbats. Car c'est un signe entre moi et vous, dans toutes vos générations, afin qu'on sache que c'est moi, l'Éternel, qui vous sanctifie. ");
INSERT INTO fra_fob_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Observez donc le sabbat; car c'est pour vous un jour saint. Ceux qui le profaneront seront punis de mort; si quelqu'un fait une œuvre en ce jour, cette personne-là sera retranchée du milieu de ses peuples. ");
INSERT INTO fra_fob_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","On travaillera pendant six jours; mais, au septième jour, ce sera le sabbat du repos, consacré à l'Éternel; quiconque fera une œuvre le jour du sabbat, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ainsi les enfants d'Israël observeront le sabbat, pour célébrer le sabbat dans toutes leurs générations, comme une alliance perpétuelle. ");
INSERT INTO fra_fob_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","C'est un signe entre moi et les enfants d'Israël à perpétuité; car l'Éternel a fait en six jours les cieux et la terre, mais au septième jour il a cessé et s'est reposé. ");
INSERT INTO fra_fob_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Et quand Dieu eut achevé de parler avec Moïse, sur la montagne du Sinaï, il lui donna les deux tables du Témoignage, tables de pierre, écrites du doigt de Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mais le peuple, voyant que Moïse tardait à descendre de la montagne, s'assembla vers Aaron et lui dit: Viens, fais-nous des dieux qui marchent devant nous; car pour ce Moïse, cet homme qui nous a fait monter du pays d'Égypte, nous ne savons ce qui lui est arrivé. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Et Aaron leur répondit: En-levez les anneaux d'or qui sont aux oreilles de vos femmes, de vos fils et de vos filles, et apportez-les-moi. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Et tous enlevèrent les anneaux d'or qui étaient à leurs oreilles; et ils les apportèrent à Aaron, ");
INSERT INTO fra_fob_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Qui les prit de leur main, les travailla au ciseau, et en fit un veau de fonte. Alors ils dirent: Voici tes dieux, ô Israël, qui t'ont fait monter du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron, voyant cela, bâtit un autel devant lui. Puis, Aaron cria et dit: Demain il y aura fête en l'honneur de l'Éternel! ");
INSERT INTO fra_fob_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Ils se levèrent donc de bon matin, le lendemain, et ils offrirent des holocaustes, et ils présentèrent des sacrifices de prospérité, et le peuple s'assit pour manger et boire; puis ils se levèrent pour se divertir. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Alors l'Éternel dit à Moïse: Va, descends, car ton peuple, que tu as fait monter du pays d'Égypte, s'est corrompu; ");
INSERT INTO fra_fob_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ils se sont bientôt détournés de la voie que je leur avais prescrite; ils se sont fait un veau de fonte, se sont prosternés devant lui, lui ont sacrifié, et ont dit: Voici tes dieux, ô Israël, qui t'ont fait monter du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","L'Éternel dit aussi à Moïse: J'ai regardé ce peuple, et voici, c'est un peuple au cou roide. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Or maintenant, laisse-moi faire; que ma colère s'enflamme contre eux, et que je les consume; mais je ferai de toi une grande nation. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Alors Moïse supplia l'Éternel son Dieu, et dit: Pourquoi, ô Éternel! ta colère s'enflammerait-elle contre ton peuple, que tu as fait sortir du pays d'Égypte avec une grande puissance et par une main forte? ");
INSERT INTO fra_fob_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Pourquoi les Égyptiens diraient-ils: Il les a fait sortir pour leur malheur, pour les tuer dans les montagnes, et pour les consumer de dessus la terre? Reviens de l'ardeur de ta colère, et te repens du mal que tu veux faire à ton peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Souviens-toi d'Abraham, d'Isaac et d'Israël, tes serviteurs, auxquels tu as juré par toi-même, en leur disant: Je multiplierai votre postérité comme les étoiles des cieux, et je donnerai à votre postérité tout ce pays dont j'ai parlé, et ils le posséderont à jamais. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Et l'Éternel se repentit du mal qu'il avait dit qu'il ferait à son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Alors Moïse retourna et descendit de la montagne, les deux tables du Témoignage en sa main, les tables écrites des deux côtés; elles étaient écrites sur l'une et l'autre face. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Et les tables étaient l'ouvrage de Dieu; l'écriture aussi était l'écriture de Dieu, gravée sur les tables. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Or Josué entendit la voix du peuple qui poussait des cris, et il dit à Moïse: Il y a un bruit de bataille dans le camp. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Et Moïse dit: Ce n'est ni un bruit de cris de victoire, ni un bruit de cris de défaite; j'entends un bruit de chants. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Et lorsqu'il fut près du camp, il vit le veau et les danses. Alors la colère de Moïse s'enflamma, et il jeta de ses mains les tables, et les brisa au pied de la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Puis, il prit le veau qu'ils avaient fait, le brûla au feu, et le broya jusqu'à ce qu'il fût réduit en poudre, qu'il répandit sur l'eau, et il en fit boire aux enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Et Moïse dit à Aaron: Que t'a fait ce peuple, que tu aies attiré sur lui un si grand péché? ");
INSERT INTO fra_fob_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Et Aaron répondit: Que la colère de mon seigneur ne s'enflamme point; tu sais que ce peuple est porté au mal; ");
INSERT INTO fra_fob_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ils m'ont dit: Fais-nous des dieux qui marchent devant nous; car pour ce Moïse, cet homme qui nous a fait monter du pays d'Égypte, nous ne savons ce qui lui est arrivé. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Alors je leur ai dit: Que ceux qui ont de l'or s'en dépouillent; et ils me l'ont donné, et je l'ai jeté au feu, et il en est sorti ce veau. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Or, Moïse vit que le peuple était sans frein; car Aaron l'avait laissé sans frein, objet d'opprobre parmi leurs ennemis. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Alors Moïse se tint à la porte du camp, et dit: A moi quiconque est pour l'Éternel! Et tous les enfants de Lévi s'assemblèrent vers lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Et il leur dit: Ainsi a dit l'Éternel, le Dieu d'Israël: Que chacun de vous mette son épée au côté. Passez et repassez, de porte en porte, dans le camp; et tuez chacun son frère, chacun son ami, et chacun son voisin. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Et les enfants de Lévi firent selon la parole de Moïse; et il y eut en ce jour-là environ trois mille hommes du peuple qui périrent. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Or Moïse avait dit: Consacrez aujourd'hui vos mains à l'Éternel, chacun de vous, même au prix de son fils ou de son frère, pour attirer aujourd'hui sur vous la bénédiction. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Et le lendemain Moïse dit au peuple: Vous avez commis un grand péché; mais maintenant je monterai vers l'Éternel; peut-être obtiendrai-je le pardon de votre péché. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moïse retourna donc vers l'Éternel, et dit: Hélas! ce peuple a commis un grand péché, en se faisant des dieux d'or; ");
INSERT INTO fra_fob_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Mais maintenant, pardonne leur péché! Sinon, efface-moi de ton livre que tu as écrit. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Et l'Éternel répondit à Moïse: Celui qui aura péché contre moi, je l'effacerai de mon livre. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Et maintenant, va, conduis le peuple où je t'ai dit. Voici, mon ange ira devant toi; mais, au jour où j'exercerai la punition, je punirai sur eux leur péché. ");
INSERT INTO fra_fob_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ainsi l'Éternel frappa le peuple, parce qu'il avait été l'auteur du veau qu'avait fait Aaron. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Et l'Éternel dit à Moïse: Va, monte d'ici, toi et le peuple que tu as fait monter du pays d'Égypte, vers le pays que j'ai juré de donner à Abraham, à Isaac, et à Jacob, en disant: Je le donnerai à ta postérité. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Et j'enverrai un ange devant toi, et je chasserai les Cananéens, les Amoréens, les Héthiens, les Phéréziens, les Héviens, et les Jébusiens, ");
INSERT INTO fra_fob_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Pour vous conduire vers ce pays où coulent le lait et le miel; car je ne monterai point au milieu de toi, parce que tu es un peuple de cou roide; de peur que je ne te consume en chemin. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Quand le peuple entendit cette parole funeste, il mena deuil, et personne ne mit ses ornements sur soi. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Car l'Éternel avait dit à Moïse: Dis aux enfants d'Israël: Vous êtes un peuple de cou roide. Si je montais un seul moment au milieu de toi, je te consumerais; maintenant donc ôte tes ornements de dessus toi, et je verrai ce que je te ferai. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ainsi les enfants d'Israël se dépouillèrent de leurs ornements, depuis le mont Horeb. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Et Moïse prit le tabernacle, et se le dressa hors du camp, loin du camp, et il l'appela le Tabernacle d'assignation; et tous ceux qui cherchaient l'Éternel, sortaient vers le tabernacle d'assignation, qui était hors du camp. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Et dès que Moïse sortait vers le tabernacle, tout le peuple se levait, et chacun se tenait à l'entrée de sa tente et suivait Moïse des yeux, jusqu'à ce qu'il entrât dans le tabernacle. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Et dès que Moïse était entré dans le tabernacle, la colonne de nuée descendait et se tenait à l'entrée du tabernacle, et l'Éternel parlait avec Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tout le peuple alors, voyant la colonne de nuée qui se tenait à l'entrée du tabernacle, se levait, et chacun se prosternait à l'entrée de sa tente. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Et l'Éternel parlait à Moïse face à face, comme un homme parle avec son semblable; puis Moïse retournait au camp; mais son serviteur Josué, jeune homme, fils de Nun, ne quittait point le tabernacle. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Et Moïse dit à l'Éternel: Regarde, tu me dis: Fais monter ce peuple! Et tu ne m'as point fait connaître celui que tu dois envoyer avec moi. Cependant tu as dit: Je te connais par ton nom, et tu as trouvé grâce à mes yeux. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Maintenant donc, je te prie, si j'ai trouvé grâce à tes yeux, fais-moi connaître tes voies; que je te connaisse, afin que je trouve grâce à tes yeux; considère aussi que cette nation est ton peuple. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Et l'Éternel dit: Ma face ira, et je te donnerai du repos. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Et Moïse lui dit: Si ta face ne vient, ne nous fais point monter d'ici. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Et à quoi connaîtra-t-on que j'ai trouvé grâce à tes yeux, moi et ton peuple? Ne sera-ce pas quand tu marcheras avec nous? Alors, moi et ton peuple, nous serons distingués entre tous les peuples qui sont sur la face de la terre. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Et l'Éternel dit à Moïse: Je ferai aussi ce que tu dis; car tu as trouvé grâce à mes yeux, et je te connais par ton nom. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Et Moïse dit: Je te prie, fais-moi voir ta gloire! ");
INSERT INTO fra_fob_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Et l'Éternel répondit: Je ferai passer toute ma bonté devant ta face; et je crierai devant toi le nom de l'Éternel; je ferai grâce à qui je ferai grâce, et j'aurai compassion de qui j'aurai compassion. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Et il dit: Tu ne pourras pas voir ma face; car l'homme ne peut me voir, et vivre. ");
INSERT INTO fra_fob_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","L'Éternel dit aussi: Voici un lieu près de moi; tu te tiendras sur le rocher; ");
INSERT INTO fra_fob_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Et il arrivera que quand ma gloire passera, je te mettrai dans le creux du rocher, et je te couvrirai de ma main jusqu'à ce que j'aie passé; ");
INSERT INTO fra_fob_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Et je retirerai ma main, et tu me verras par-derrière; mais ma face ne se voit point. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Et l'Éternel dit à Moïse: Taille-toi deux tables de pierre comme les premières; et j'écrirai sur ces tables les paroles qui étaient sur les premières tables que tu as brisées. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Et sois prêt au matin; et monte, dès le matin, sur le mont Sinaï; tiens-toi là devant moi, sur le sommet de la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mais que personne ne monte avec toi, et même que personne ne paraisse sur toute la montagne; que ni brebis, ni bœufs ne paissent même près de cette montagne. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moïse donc tailla deux tables de pierre comme les premières, et se leva de bon matin, et monta sur le mont Sinaï, comme l'Éternel le lui avait commandé; et il prit en sa main deux tables de pierre. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Et l'Éternel descendit dans la nuée, et se tint là avec lui, et cria le nom de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Et l'Éternel passa devant lui, et cria: L'Éternel, l'Éternel! le Dieu miséricordieux et compatissant, lent à la colère, abondant en grâce et en fidélité, ");
INSERT INTO fra_fob_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Qui conserve sa grâce jusqu'à mille générations, qui pardonne l'iniquité, le crime et le péché, mais ne tient point le coupable pour innocent; qui punit l'iniquité des pères sur les enfants et sur les enfants des enfants, jusqu'à la troisième et à la quatrième génération. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Et Moïse s'inclina aussitôt vers la terre et se prosterna; ");
INSERT INTO fra_fob_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Et il dit: Seigneur, je te prie, si j'ai trouvé grâce à tes yeux, que le Seigneur marche au milieu de nous; car c'est un peuple de cou roide; et pardonne notre iniquité et notre péché, et possède-nous comme ton héritage. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Et l'Éternel répondit: Voici, je traite une alliance. Je ferai, devant tout ton peuple, des merveilles qui n'ont point été faites sur toute la terre, ni chez aucune nation; et tout le peuple au milieu duquel tu te trouves, verra l'œuvre de l'Éternel; car ce que je vais faire avec toi, sera une chose terrible. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Prends garde à ce que je te commande aujourd'hui. Voici, je vais chasser de devant toi les Amoréens, les Cananéens, les Héthiens, les Phéréziens, les Héviens, et les Jébusiens. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Garde-toi de traiter alliance avec les habitants du pays dans lequel tu vas entrer, de peur qu'ils ne soient en piège au milieu de toi. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Mais vous démolirez leurs autels, vous briserez leurs statues, et vous couperez leurs emblèmes d'Ashéra. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Car tu ne te prosterneras point devant un autre dieu, parce que l'Éternel se nomme le Dieu jaloux; c'est un Dieu jaloux. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Garde-toi de traiter alliance avec les habitants du pays, de peur que lorsqu'ils se prostitueront après leurs dieux, et sacrifieront à leurs dieux, quelqu'un ne t'invite, et que tu ne manges de son sacrifice; ");
INSERT INTO fra_fob_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Et que tu ne prennes de ses filles pour tes fils; et que ses filles, se prostituant à leurs dieux, ne fassent aussi prostituer tes fils à leurs dieux. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Tu ne te feras point de dieu de fonte. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Tu observeras la fête des pains sans levain. Tu mangeras pendant sept jours les pains sans levain, comme je te l'ai commandé, à l'époque du mois des épis; car au mois des épis tu es sorti d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Tout ce qui naît le premier est à moi, et tout ton bétail mâle, premier-né de taureau et de brebis. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Mais tu rachèteras avec un agneau ou un chevreau le premier-né d'un âne. Et si tu ne le rachètes pas, tu lui rompras le cou. Tu rachèteras tout premier-né de tes fils; et l'on ne se présentera point à vide devant ma face. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Tu travailleras six jours; mais au septième jour tu te reposeras; tu te reposeras, même au temps du labourage et de la moisson. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Tu célébreras la fête des semaines au temps des premiers fruits de la moisson du froment; et la fête de la récolte, à la fin de l'année. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Trois fois l'an tous les mâles d'entre vous se présenteront devant le Seigneur, l'Éternel, Dieu d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Car je déposséderai les nations devant toi, et j'étendrai tes frontières; et nul ne convoitera ton pays, lorsque tu monteras pour te présenter, trois fois l'an, devant l'Éternel ton Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Tu n'offriras point avec du pain levé le sang de mon sacrifice; et le sacrifice de la fête de la Pâque ne passera point la nuit jusqu'au matin. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Tu apporteras les prémices des premiers fruits de ta terre à la maison de l'Éternel ton Dieu. Tu ne feras point cuire le chevreau dans le lait de sa mère. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","L'Éternel dit aussi à Moïse: Écris ces paroles; car c'est suivant la teneur de ces paroles que j'ai traité alliance avec toi et avec Israël. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Et Moïse fut là avec l'Éternel quarante jours et quarante nuits; il ne mangea point de pain et ne but point d'eau; et l'Éternel écrivit sur les tables les paroles de l'alliance, les dix paroles. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Or, lorsque Moïse descendit de la montagne de Sinaï, les deux tables du Témoignage étant dans la main de Moïse, qui descendait de la montagne, Moïse ne savait point que la peau de son visage était devenue rayonnante, pendant qu'il parlait avec Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Mais Aaron et tous les enfants d'Israël virent Moïse, et voici, la peau de son visage rayonnait, et ils craignirent d'approcher de lui. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Alors Moïse les appela, et Aaron et tous les principaux de l'assemblée revinrent vers lui, et Moïse leur parla. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Après cela, tous les enfants d'Israël s'approchèrent, et il leur commanda tout ce que l'Éternel lui avait dit sur le mont Sinaï. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Moïse acheva de parler avec eux; et il mit un voile sur sa face. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Et quand Moïse entrait devant l'Éternel pour parler avec lui, il ôtait le voile jusqu'à ce qu'il sortît; puis il sortait et disait aux enfants d'Israël ce qui lui avait été commandé. ");
INSERT INTO fra_fob_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Et les enfants d'Israël voyaient que le visage de Moïse, la peau du visage de Moïse, rayonnait; et Moïse remettait le voile sur son visage, jusqu'à ce qu'il entrât, pour parler avec l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moïse convoqua toute l'assemblée des enfants d'Israël, et leur dit: Voici les choses que l'Éternel a commandé de faire: ");
INSERT INTO fra_fob_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","On travaillera pendant six jours, mais le septième jour sera pour vous une chose sainte, le sabbat du repos consacré à l'Éternel. Quiconque travaillera en ce jour-là sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Vous n'allumerez point de feu, dans aucune de vos demeures, le jour du sabbat. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Et Moïse parla à toute l'assemblée des enfants d'Israël, et leur dit: Voici ce que l'Éternel a commandé, en ces termes: ");
INSERT INTO fra_fob_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Prenez de chez vous une offrande pour l'Éternel. Tout homme dont le cœur est bien disposé apportera l'offrande de l'Éternel: de l'or, de l'argent et de l'airain, ");
INSERT INTO fra_fob_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","De la pourpre, de l'écarlate, du cramoisi, du fin lin, du poil de chèvre, ");
INSERT INTO fra_fob_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Des peaux de béliers teintes en rouge, et des peaux de couleur d'hyacinthe, du bois de Sittim, ");
INSERT INTO fra_fob_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","De l'huile pour le luminaire, des aromates pour l'huile de l'onction et pour le parfum aromatique, ");
INSERT INTO fra_fob_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Des pierres d'onyx et des pierres d'enchâssure pour l'éphod et pour le pectoral. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Et tous les hommes intelligents parmi vous viendront, et feront tout ce que l'Éternel a commandé: ");
INSERT INTO fra_fob_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","La Demeure, son tabernacle et sa couverture, ses crochets, ses planches, ses traverses, ses colonnes et ses soubassements, ");
INSERT INTO fra_fob_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","L'arche et ses barres, le propitiatoire, et le voile pour couvrir le lieu très-saint; ");
INSERT INTO fra_fob_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","La table et ses barres, et tous ses ustensiles, et le pain de proposition; ");
INSERT INTO fra_fob_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Le chandelier du luminaire, ses ustensiles, ses lampes, et l'huile du luminaire; ");
INSERT INTO fra_fob_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","L'autel du parfum et ses barres, l'huile de l'onction, le parfum d'aromates, et la tapisserie de l'entrée, pour l'entrée de la Demeure; ");
INSERT INTO fra_fob_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","L'autel de l'holocauste et sa grille d'airain, ses barres et tous ses ustensiles; la cuve et sa base; ");
INSERT INTO fra_fob_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Les tentures du parvis, ses colonnes, ses soubassements, et la tapisserie de la porte du parvis, ");
INSERT INTO fra_fob_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Et les pieux de la Demeure, et les pieux du parvis, et leurs cordes; ");
INSERT INTO fra_fob_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Les vêtements du service, pour faire le service dans le sanctuaire, les vêtements sacrés, pour Aaron le sacrificateur, et les vêtements de ses fils pour exercer la sacrificature. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Alors toute l'assemblée des enfants d'Israël sortit de devant Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Et tous ceux que leur cœur y porta, vinrent; et tous ceux que leur esprit disposa à la générosité, apportèrent l'offrande de l'Éternel, pour l'œuvre du tabernacle d'assignation, et pour tout son service, et pour les vêtements sacrés. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Et les hommes vinrent avec les femmes; tous ceux qui furent de bonne volonté, apportèrent des boucles, des bagues, des anneaux, des colliers, toute sorte de joyaux d'or, et tous offrirent quelque offrande d'or à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Et tous ceux qui avaient chez eux de la pourpre, de l'écarlate, du cramoisi, du fin lin, du poil de chèvre, des peaux de béliers teintes en rouge, et des peaux de couleur d'hyacinthe, les apportèrent. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Tous ceux qui avaient de quoi faire une offrande d'argent ou d'airain, l'apportèrent pour l'offrande de l'Éternel; et tous ceux qui avaient chez eux du bois de Sittim, pour tout l'ouvrage du service, l'apportèrent. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Et toutes les femmes habiles filèrent de leurs mains, et apportèrent ce qu'elles avaient filé, la pourpre, l'écarlate, le cramoisi et le fin lin. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Et toutes les femmes que leur cœur y porta et qui avaient de l'habileté filèrent du poil de chèvre. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Et les principaux du peuple apportèrent les pierres d'onyx et les pierres d'enchâssure, pour l'éphod et pour le pectoral; ");
INSERT INTO fra_fob_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Et les aromates et l'huile, pour le luminaire, pour l'huile de l'onction et pour le parfum aromatique. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Tous les enfants d'Israël, hommes et femmes, que leur cœur disposa à contribuer à tout l'ouvrage que l'Éternel avait commandé par l'organe de Moïse, apportèrent à l'Éternel des présents volontaires. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Et Moïse dit aux enfants d'Israël: Voyez, l'Éternel a appelé par son nom Betsaléel, fils d'Uri, fils de Hur, de la tribu de Juda, ");
INSERT INTO fra_fob_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Et il l'a rempli de l'esprit de Dieu, d'intelligence, d'industrie et de science, pour toute sorte d'ouvrage; ");
INSERT INTO fra_fob_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Et pour faire des inventions, pour travailler l'or, l'argent et l'airain, ");
INSERT INTO fra_fob_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Pour tailler et enchâsser des pierreries, et pour tailler le bois et exécuter toutes sortes d'ouvrage d'art. ");
INSERT INTO fra_fob_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Il lui a aussi donné le talent d'enseigner, à lui et à Oholiab, fils d'Ahisamac, de la tribu de Dan; ");
INSERT INTO fra_fob_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Il les a remplis d'intelligence pour faire toute sorte de travail d'ouvrier, de brodeur et de tisseur en couleurs variées, en pourpre, en écarlate, en cramoisi et en fin lin, et de tisserand; ils font toute sorte d'ouvrage, et sont habiles en inventions. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Betsaléel, et Oholiab, et tous les hommes habiles, en qui l'Éternel avait mis intelligence et industrie pour savoir faire tout l'ouvrage pour le service du sanctuaire, firent tout ce que l'Éternel avait commandé. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moïse appela donc Betsaléel, et Oholiab, et tous les hommes habiles dans le cœur desquels l'Éternel avait mis de l'intelligence, tous ceux que leur cœur porta à s'approcher pour faire l'ouvrage; ");
INSERT INTO fra_fob_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Et ils emportèrent de devant Moïse toutes les offrandes que les enfants d'Israël avaient apportées pour faire l'ouvrage du service du sanctuaire. Mais ceux-ci lui apportaient encore, chaque matin, des offrandes volontaires. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Alors tous les hommes intelligents qui faisaient tout l'ouvrage du sanctuaire, quittèrent chacun l'ouvrage qu'ils faisaient, ");
INSERT INTO fra_fob_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Et vinrent dire à Moïse: Le peuple apporte beaucoup plus qu'il ne faut, pour le service de l'ouvrage que l'Éternel a commandé de faire. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Alors, sur l'ordre de Moïse, on fit crier par le camp: Que ni homme ni femme ne fasse plus d'ouvrage pour l'offrande du sanctuaire. Ainsi l'on empêcha le peuple de plus rien apporter. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Et il y eut assez d'objets pour faire tout l'ouvrage; il y en eut même de reste. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Tous les hommes habiles, parmi ceux qui faisaient l'ouvrage, firent donc la Demeure, de dix tentures de fin lin retors, de pourpre, d'écarlate et de cramoisi, avec des chérubins qu'on fit en ouvrage d'art. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","La longueur d'une tenture était de vingt-huit coudées; et la largeur de la même tenture, de quatre coudées; toutes les tentures avaient une même mesure. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Et l'on joignit cinq tentures l'une à l'autre, et l'on joignit les cinq autres tentures l'une à l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Et l'on fit des lacets de pourpre sur le bord de la première tenture, au bout de l'assemblage; de même au bord de la dernière tenture, dans le second assemblage. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","On fit cinquante lacets à la première tenture, et l'on fit cinquante lacets au bout de la tenture qui était dans le second assemblage. Les lacets étaient en face l'un de l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Puis on fit cinquante crochets d'or, et l'on joignit les tentures l'une à l'autre avec les crochets, pour que la Demeure formât un seul tout. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Puis on fit des tentures de poil de chèvre, pour servir de tabernacle sur la Demeure; on fit onze de ces tentures. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","La longueur d'une tenture était de trente coudées, et la largeur de la même tenture de quatre coudées; les onze tentures avaient une même mesure. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Et on assembla cinq de ces tentures à part, et les six autres tentures à part. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","On fit aussi cinquante lacets sur le bord de la dernière tenture de l'assemblage, et cinquante lacets sur le bord de la tenture du second assemblage. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","On fit aussi cinquante crochets d'airain, pour assembler le tabernacle, afin qu'il formât un seul tout. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Et l'on fit pour le tabernacle une couverture de peaux de béliers teintes en rouge, et une couverture de peaux de couleur d'hyacinthe par-dessus. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Et l'on fit pour la Demeure des planches de bois de Sittim, qu'on fit tenir debout. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","La longueur d'une planche était de dix coudées, et la largeur de la même planche d'une coudée et demie. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Il y avait deux tenons à chaque planche, parallèles l'un à l'autre; on fit de même pour toutes les planches de la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","On fit donc les planches pour la Demeure: vingt planches du côté du Sud, vers le Midi. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Et sous les vingt planches on fit quarante soubassements d'argent; deux soubassements sous une planche, pour ses deux tenons, et deux soubassements sous une autre planche, pour ses deux tenons. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","On fit aussi vingt planches pour l'autre côté de la Demeure, du côté du Nord. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Et leurs quarante soubassements étaient d'argent; deux soubassements sous une planche, et deux soubassements sous une autre planche. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Et pour le fond de la Demeure vers l'Occident, on fit six planches. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Et on fit deux planches pour les angles de la Demeure au fond. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Elles étaient doubles par le bas, mais en même temps elles étaient pleines vers le haut jusqu'au premier anneau; on fit ainsi pour toutes les deux, pour les deux angles. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Il y avait donc huit planches et leurs seize soubassements d'argent; deux soubassements sous chaque planche. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Et l'on fit cinq traverses de bois de Sittim, pour les planches d'un côté de la Demeure; ");
INSERT INTO fra_fob_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Et cinq traverses pour les planches de l'autre côté de la Demeure, et cinq autres traverses pour les planches de la Demeure formant le fond, vers l'Occident. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Et l'on fit la traverse du milieu, pour traverser, par le milieu des planches, d'un bout à l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Et l'on couvrit d'or les planches, et l'on fit leurs anneaux d'or, pour y mettre les traverses, et l'on couvrit d'or les traverses. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","On fit aussi le voile de pourpre, d'écarlate, de cramoisi et de fin lin retors; on le fit en ouvrage d'art, avec des chérubins. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Et on lui fit quatre colonnes de bois de Sittim, qu'on couvrit d'or, avec leurs clous en or; et on leur fondit quatre soubassements d'argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","On fit aussi pour l'entrée du tabernacle une tapisserie de pourpre, d'écarlate, de cramoisi et de fin lin retors, en ouvrage de broderie; ");
INSERT INTO fra_fob_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Et ses cinq colonnes et leurs clous; et on couvrit d'or leurs chapiteaux, et leurs tringles; mais leurs cinq soubassements étaient d'airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Puis Betsaléel fit l'arche, de bois de Sittim. Sa longueur était de deux coudées et demie; sa largeur, d'une coudée et demie; et sa hauteur, d'une coudée et demie. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Et il la couvrit d'or pur par dedans et par dehors, et il lui fit un couronnement d'or tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Et il fondit pour elle quatre anneaux d'or, pour mettre à ses quatre coins: deux anneaux d'un côté, et deux anneaux de l'autre côté. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Il fit aussi des barres de bois de Sittim, et les couvrit d'or. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Et il fit entrer les barres dans les anneaux, aux côtés de l'arche, pour porter l'arche. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Il fit aussi un propitiatoire d'or pur; sa longueur était de deux coudées et demie, et sa largeur d'une coudée et demie. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Et il fit deux chérubins d'or; il les fit au marteau, aux deux bouts du propitiatoire. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Un chérubin à ce bout, et un chérubin à l'autre bout. Il fit les chérubins sortant du propitiatoire, à ses deux bouts. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Et les chérubins étendaient les ailes en haut, couvrant de leurs ailes le propitiatoire, et leurs faces étaient vis-à-vis l'une de l'autre. La face des chérubins était dirigée vers le propitiatoire. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Il fit aussi la table, de bois de Sittim; sa longueur était de deux coudées, sa largeur d'une coudée, et sa hauteur d'une coudée et demie. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Et il la couvrit d'or pur, et il lui fit un couronnement d'or tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Il lui fit aussi, à l'entour, un rebord de quatre doigts; et il fit à ce rebord un couronnement d'or tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Et il lui fondit quatre anneaux d'or, et il mit les anneaux aux quatre coins, qui étaient à ses quatre pieds. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Les anneaux étaient près du rebord, afin d'y mettre les barres pour porter la table. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Et il fit les barres, de bois de Sittim, et il les couvrit d'or, pour porter la table. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Il fit aussi d'or pur les ustensiles qui devaient être sur la table, ses plats, ses tasses, ses coupes et ses vases, avec lesquels on devait faire les libations. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Il fit aussi le chandelier d'or pur; il fit au marteau le chandelier, son pied et sa tige; ses calices, ses pommes et ses fleurs en étaient tirés. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Et six branches sortaient de ses côtés: trois branches du chandelier d'un côté, et trois branches du chandelier de l'autre côté. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Il y avait trois calices en forme d'amande, à une branche, avec pomme et fleur, et trois calices en forme d'amande à l'autre branche, avec pomme et fleur. De même pour les six branches sortant du chandelier. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Et il y avait au chandelier même quatre calices en forme d'amande, avec ses pommes et ses fleurs; ");
INSERT INTO fra_fob_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Et une pomme sous les deux branches qui en sortaient, une autre pomme sous deux autres branches qui en sortaient, et encore une pomme sous les deux autres branches qui en sortaient, pour les six branches sortant du chandelier. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ses pommes et ses branches en étaient tirées; il était tout entier d'une seule pièce faite au marteau, en or pur. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Il fit aussi ses sept lampes, ses mouchettes et ses porte-mouchettes, en or pur. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Il le fit, avec tous ses ustensiles, d'un talent d'or pur. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Et il fit l'autel du parfum, de bois de Sittim; sa longueur était d'une coudée, et sa largeur d'une coudée; il était carré; et sa hauteur était de deux coudées. L'autel avait des cornes qui en sortaient. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Et il le couvrit d'or pur, le dessus et ses côtés tout autour, et ses cornes; et il lui fit un couronnement d'or tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Il lui fit aussi, au-dessous de son couronnement, deux anneaux d'or à ses deux côtés, à ses deux coins, pour y mettre les barres qui serviraient à le porter. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Et il fit les barres de bois de Sittim, et il les couvrit d'or. ");
INSERT INTO fra_fob_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Il fit aussi l'huile sainte de l'onction, et le parfum pur, d'aromates, selon l'art du parfumeur. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Il fit aussi l'autel de l'holocauste en bois de Sittim; sa longueur était de cinq coudées, et sa largeur de cinq coudées; il était carré, et sa hauteur était de trois coudées. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Et il fit à ses quatre coins des cornes, qui sortaient de l'autel; et il le couvrit d'airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Il fit aussi tous les ustensiles de l'autel, les chaudrons, les pelles et les coupes, les fourchettes et les encensoirs; il fit tous ses ustensiles en airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Et il fit pour l'autel une grille en treillis d'airain, sous sa corniche, depuis le bas jusqu'au milieu. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Et il fondit quatre anneaux aux quatre coins de la grille d'airain, pour y mettre les barres. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Et il fit les barres en bois de Sittim, et les couvrit d'airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Et il fit entrer les barres dans les anneaux, aux côtés de l'autel, pour le porter avec elles. Il le fit creux, en planches. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Il fit aussi la cuve en airain et sa base en airain, avec les miroirs des femmes qui servaient, qui faisaient le service à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Il fit aussi le parvis: pour le côté du Sud, vers le Midi, les tentures du parvis en fin lin retors, cent coudées, ");
INSERT INTO fra_fob_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Leurs vingt colonnes et leurs vingt soubassements d'airain; les clous des colonnes et leurs tringles en argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Et pour le côté du Nord, cent coudées de tentures, leurs vingt colonnes et leurs vingt soubassements d'airain; les clous des colonnes et leurs tringles en argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Et pour le côté de l'Occident, cinquante coudées de tentures, leurs dix colonnes et leurs dix soubassements; les clous des colonnes et les tringles en argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Et pour le côté de devant, vers l'Orient, cinquante coudées: ");
INSERT INTO fra_fob_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","A savoir quinze coudées de tentures, d'une part, avec leurs trois colonnes et leurs trois soubassements; ");
INSERT INTO fra_fob_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Et d'autre part (d'un côté, comme de l'autre, de la porte du parvis), quinze coudées de tentures, leurs trois colonnes et leurs trois soubassements. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Toutes les tentures du parvis, tout autour, étaient de fin lin retors; ");
INSERT INTO fra_fob_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Et les soubassements des colonnes en airain, les clous des colonnes et leurs tringles en argent, et la couverture de leurs chapiteaux en argent; et toutes les colonnes du parvis furent jointes par des tringles d'argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Et la tapisserie de la porte du parvis était en ouvrage de broderie, en pourpre, écarlate, cramoisi, et fin lin retors, de la longueur de vingt coudées; et la hauteur (formée de la largeur du tissu) était de cinq coudées, correspondant aux tentures du parvis. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Et leurs quatre colonnes et leurs quatre soubassements étaient d'airain; leurs clous étaient d'argent, et la couverture de leurs chapiteaux et leurs tringles, en argent. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Et tous les pieux pour le tabernacle et pour le parvis à l'entour étaient en airain. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Voici les comptes de la Demeure, la Demeure du Témoignage, qui furent faits sur l'ordre de Moïse, par le moyen des Lévites, sous la conduite d'Ithamar, fils d'Aaron le sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Betsaléel, fils d'Uri, fils de Hur, de la tribu de Juda, fit tout ce que l'Éternel avait commandé à Moïse; ");
INSERT INTO fra_fob_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Et avec lui Oholiab, fils d'Ahisamac, de la tribu de Dan, sculpteur, inventeur, et brodeur en pourpre, en écarlate, en cramoisi et en fin lin. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Tout l'or qui fut employé pour l'ouvrage, dans tout l'ouvrage du sanctuaire (et c'était l'or de l'offrande), fut de vingt-neuf talents, et sept cent trente sicles, selon le sicle du sanctuaire. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Et l'argent de ceux de l'assemblée qui furent dénombrés, fut de cent talents et mille sept cent soixante et quinze sicles, selon le sicle du sanctuaire; ");
INSERT INTO fra_fob_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Un demi-sicle par tête, la moitié du sicle, selon le sicle du sanctuaire, pour tous ceux qui passèrent par le dénombrement, depuis l'âge de vingt ans et au-dessus, savoir, pour six cent trois mille cinq cent cinquante hommes. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Il y eut donc cent talents d'argent pour fondre les soubassements du sanctuaire, et les soubassements du voile, cent soubassements pour les cent talents; un talent par soubassement. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Et des mille sept cent soixante et quinze sicles restants, on fit des clous pour les colonnes, on couvrit leurs chapiteaux, et on les joignit par des tringles. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Et l'airain de l'offrande fut de soixante et dix talents, et deux mille quatre cents sicles. ");
INSERT INTO fra_fob_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","On en fit les soubassements de l'entrée du tabernacle d'assignation, et l'autel d'airain, et sa grille d'airain, et tous les ustensiles de l'autel, ");
INSERT INTO fra_fob_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Et les soubassements du parvis, tout autour, et les soubassements de la porte du parvis, et tous les pieux de la Demeure, et tous les pieux du parvis tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Avec la pourpre, l'écarlate et le cramoisi ils firent les vêtements du service, pour faire le service dans le sanctuaire, et ils firent les vêtements sacrés qui étaient pour Aaron, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","On fit donc l'éphod d'or, de pourpre, d'écarlate, de cramoisi et de fin lin retors. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","On étendit des lames d'or, et on les coupa en fils pour les mêler à la pourpre, à l'écarlate, au cramoisi et au fin lin, en ouvrage d'art. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","On fit à l'éphod des épaulettes qui se joignaient; il se joignait ainsi par ses deux extrémités. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Et la ceinture pour l'attacher, qui se trouvait par-dessus, était de la même pièce et du même ouvrage: d'or, de pourpre, d'écarlate, de cramoisi et de fin lin retors, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Et l'on enchâssa dans des chatons d'or, les pierres d'onyx, portant les noms des enfants d'Israël gravés en gravure de cachet. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Et on les mit sur les épaulettes de l'éphod, pour être des pierres de mémorial pour les enfants d'Israël, comme l' Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","On fit aussi le pectoral en ouvrage d'art, comme l'ouvrage de l'éphod: or, pourpre, écarlate, cramoisi et fin lin retors. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Il était carré. L'on fit le pectoral double; sa longueur était d'un empan, et sa largeur d'un empan, en double. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Et on le garnit de quatre rangs de pierres: au premier rang, une sardoine, une topaze et une émeraude; ");
INSERT INTO fra_fob_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Au second rang, une escarboucle, un saphir et une calcédoine; ");
INSERT INTO fra_fob_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Au troisième rang, une opale, une agate et une améthyste; ");
INSERT INTO fra_fob_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Au quatrième rang, un chrysolithe, un onyx et un jaspe. Ces pierres furent entourées de chatons d'or dans leurs montures. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Et les pierres, selon les noms des enfants d'Israël, étaient au nombre de douze, d'après leurs noms; elles portaient, en gravure de cachet, chacune le nom d'une des douze tribus. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Puis l'on fit sur le pectoral des chaînettes tordues en façon de cordons en or pur. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","On fit aussi deux agrafes d'or et deux anneaux d'or, et on mit les deux anneaux aux deux extrémités du pectoral. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Et l'on mit les deux cordons aux deux anneaux, aux extrémités du pectoral. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Et l'on mit les deux extrémités des deux cordons aux deux agrafes, sur les épaulettes de l'éphod, sur le devant. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","On fit aussi deux autres anneaux d'or, et on les mit aux deux autres extrémités du pectoral sur le bord, qui était du côté de l'éphod, en dedans. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","On fit encore deux autres anneaux d'or, et on les mit aux deux épaulettes de l'éphod par le bas, sur le devant, à côté de l'endroit où il se joint, au-dessus de la ceinture de l'éphod. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Et on attacha le pectoral par ses anneaux aux anneaux de l'éphod, avec un cordon de pourpre, afin qu'il tînt sur la ceinture de l'éphod, et que le pectoral ne se détachât pas de l'éphod, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","On fit aussi la robe de l'éphod en tissu simple, entièrement de pourpre. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Et l'ouverture pour passer la tête, au milieu de la robe, était comme l'ouverture d'une cotte d'armes; il y avait une bordure à son ouverture, tout autour, afin qu'elle ne se déchirât point. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Et l'on mit aux bords de la robe des grenades de pourpre, d'écarlate et de cramoisi, en fil retors. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","On fit aussi des clochettes d'or pur; et l'on mit les clochettes entre les grenades aux bords de la robe, tout autour, entre les grenades: ");
INSERT INTO fra_fob_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Une clochette et une grenade, une clochette et une grenade, aux bords de la robe, tout autour, pour faire le service, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","On fit aussi les tuniques de fin lin, en tissu simple, pour Aaron et pour ses fils. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Et la tiare de fin lin, et les ornements des mitres de fin lin, et les caleçons de lin, de fin lin retors; ");
INSERT INTO fra_fob_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Et la ceinture de fin lin retors, de pourpre, d'écarlate et de cramoisi, en tissu de broderie, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","On fit aussi d'or pur la lame, la couronne sainte, et l'on y écrivit, d'une écriture en gravure de cachet: SAINTETÉ A L'ÉTERNEL. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Et on y mit un cordon de pourpre, pour la mettre sur la tiare, en haut, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ainsi fut achevé tout l'ouvrage de la Demeure, du tabernacle d'assignation; et les enfants d'Israël firent selon tout ce que l'Éternel avait commandé à Moïse; ils firent ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Et ils apportèrent la Demeure à Moïse, le tabernacle, et tous ses ustensiles, ses crochets, ses planches, ses traverses, ses colonnes et ses soubassements; ");
INSERT INTO fra_fob_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","La couverture de peaux de béliers teintes en rouge, et la couverture de peaux de couleur d'hyacinthe, et le voile de tenture; ");
INSERT INTO fra_fob_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","L'arche du Témoignage et ses barres, et le propitiatoire; ");
INSERT INTO fra_fob_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","La table avec tous ses ustensiles, et le pain de proposition, ");
INSERT INTO fra_fob_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Le chandelier pur, avec les lampes, les lampes arrangées, et tous ses ustensiles, et l'huile du luminaire; ");
INSERT INTO fra_fob_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","L'autel d'or, l'huile de l'onction, le parfum d'aromates, et la tapisserie de l'entrée du tabernacle, ");
INSERT INTO fra_fob_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","L'autel d'airain et sa grille d'airain, avec ses barres, et tous ses ustensiles, la cuve et sa base, ");
INSERT INTO fra_fob_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Les tentures du parvis, ses colonnes, ses soubassements, la tapisserie pour la porte du parvis, ses cordes, ses pieux, et tous les ustensiles du service de la Demeure, pour le tabernacle d'assignation; ");
INSERT INTO fra_fob_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Les vêtements du service, pour faire le service dans le sanctuaire, les vêtements sacrés pour Aaron le sacrificateur, et les vêtements de ses fils pour exercer la sacrificature. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Les enfants d'Israël avaient fait toute la tâche, suivant tout ce que l'Éternel avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Et Moïse vit tout l'ouvrage, et voici, ils l'avaient fait tel que l'Éternel l'avait commandé; ils l'avaient fait ainsi; et Moïse les bénit. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Au premier jour du premier mois, tu dresseras la Demeure du tabernacle d'assignation; ");
INSERT INTO fra_fob_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Et tu y mettras l'arche du Témoignage, et tu couvriras l'arche avec le voile. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Tu apporteras aussi la table, et tu y arrangeras ce qui doit y être arrangé; tu apporteras aussi le chandelier, et tu allumeras ses lampes. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Et tu mettras l'autel d'or pour le parfum devant l'arche du Témoignage, et tu poseras la tapisserie de l'entrée de la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Et tu mettras l'autel de l'holocauste devant l'entrée de la Demeure du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Et tu mettras la cuve entre le tabernacle d'assignation et l'autel, et tu y mettras de l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Et tu placeras le parvis tout autour, et tu mettras la tapisserie à la porte du parvis. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Puis tu prendras l'huile de l'onction, et tu oindras la Demeure et tout ce qui y est, et tu la consacreras, avec tous ses ustensiles; et elle sera sainte. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tu oindras aussi l'autel de l'holocauste et tous ses ustensiles, et tu consacreras l'autel; et l'autel sera très saint. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Tu oindras aussi la cuve et sa base, et tu la consacreras. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Puis tu feras avancer Aaron et ses fils à l'entrée du tabernacle d'assignation, et tu les laveras dans l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Et tu revêtiras Aaron des vêtements sacrés, et tu l'oindras, et tu le consacreras, et il exercera devant moi la sacrificature. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Et tu feras avancer ses fils, et tu les revêtiras de tuniques; ");
INSERT INTO fra_fob_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Et tu les oindras, comme tu auras oint leur père, et ils exerceront devant moi la sacrificature; et leur onction leur conférera une sacrificature perpétuelle, d'âge en âge. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Et Moïse fit selon tout ce que l'Éternel lui avait commandé; il fit ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Et au premier jour du premier mois, dans la seconde année, la Demeure fut dressée. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Et Moïse dressa la Demeure, et mit ses soubassements, et posa ses planches, et mit ses traverses, et dressa ses colonnes. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Et il étendit le tabernacle sur la Demeure, et il posa la couverture du tabernacle par-dessus, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Puis il prit aussi et mit le Témoignage dans l'arche, et il plaça les barres à l'arche, et il mit le propitiatoire sur l'arche, par-dessus. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Et il porta l'arche dans la Demeure, et posa le voile destiné à cacher le lieu très-saint, et couvrit l'arche du Témoignage, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Il mit aussi la table dans le tabernacle d'assignation, au côté Nord de la Demeure, en dehors du voile; ");
INSERT INTO fra_fob_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Et il arrangea sur elle une rangée de pains, devant l'Éternel, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Il plaça aussi le chandelier dans le tabernacle d'assignation, vis-à-vis de la table, au côté Sud de la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Et il alluma les lampes devant l'Éternel, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Il plaça aussi l'autel d'or dans le tabernacle d'assignation, devant le voile; ");
INSERT INTO fra_fob_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Et il y fit fumer le parfum d'aromates, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Il posa aussi la tapisserie de l'entrée de la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Puis il plaça l'autel de l'holocauste à l'entrée de la Demeure du tabernacle d'assignation, et il y offrit l'holocauste et l'oblation, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Il plaça aussi la cuve entre le tabernacle d'assignation et l'autel, et il y mit de l'eau pour laver; ");
INSERT INTO fra_fob_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Et Moïse et Aaron et ses fils en lavaient leurs mains et leurs pieds. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Quand ils entraient au tabernacle d'assignation, et qu'ils s'avançaient vers l'autel, ils se lavaient, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Il dressa aussi le parvis tout autour de la Demeure et de l'autel, et il mit la tapisserie à la porte du parvis. Ainsi Moïse acheva l'ouvrage. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Et la nuée couvrit le tabernacle d'assignation, et la gloire de l'Éternel remplit la Demeure; ");
INSERT INTO fra_fob_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","De sorte que Moïse ne put entrer dans le tabernacle d'assignation, car la nuée se tenait dessus, et la gloire de l'Éternel remplissait la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Or, pendant toutes leurs marches, quand la nuée s'élevait de dessus la Demeure, les enfants d'Israël partaient; ");
INSERT INTO fra_fob_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Mais si la nuée ne s'élevait point, ils ne partaient point, jusqu'au jour où elle s'élevait. ");
INSERT INTO fra_fob_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Car la nuée de l'Éternel était sur la Demeure pendant le jour, et le feu y était la nuit, aux yeux de toute la maison d'Israël, pendant toutes leurs marches. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Or l'Éternel appela Moïse, et lui parla du tabernacle d'assignation, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Parle aux enfants d'Israël, et dis-leur: Quand quelqu'un d'entre vous fera une offrande à l'Éternel, il fera son offrande de bétail, de gros ou de menu bétail. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Si son offrande est un holocauste de gros bétail, il offrira un mâle sans défaut; il l'offrira à l'entrée du tabernacle d'assignation, devant l'Éternel, pour obtenir sa faveur. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Et il appuiera sa main sur la tête de l'holocauste, et il sera agréé en sa faveur, pour faire expiation pour lui. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Puis il égorgera le veau devant l'Éternel; et les fils d'Aaron, les sacrificateurs, offriront le sang, et le répandront tout autour sur l'autel, qui est à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ensuite, il dépouillera l'holocauste, et le coupera suivant ses parties. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Alors les fils d'Aaron, le sacrificateur, mettront du feu sur l'autel, et arrangeront du bois sur le feu; ");
INSERT INTO fra_fob_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Et les fils d'Aaron, les sacrificateurs, arrangeront les morceaux, la tête et la graisse, sur le bois, qu'on aura mis au feu sur l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Il lavera dans l'eau les entrailles et les jambes, et le sacrificateur fera fumer le tout sur l'autel, en holocauste, en sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Si son offrande est de menu bétail, d'agneaux ou de chèvres pour holocauste, ");
INSERT INTO fra_fob_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Il offrira un mâle sans défaut; et il l'égorgera au côté Nord de l'autel, devant l'Éternel; et les fils d'Aaron, les sacrificateurs, en répandront le sang sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Il le coupera suivant ses parties, séparant sa tête et sa graisse; et le sacrificateur les arrangera sur le bois qu'on aura mis au feu sur l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Il lavera dans l'eau les entrailles et les jambes; et le sacrificateur offrira le tout, et le fera fumer sur l'autel; c'est un holocauste, un sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Si son offrande à l'Éternel est un holocauste d'oiseaux, il fera son offrande de tourterelles ou de pigeonneaux. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Le sacrificateur l'approchera de l'autel, lui brisera la tête, et fera fumer l'oiseau sur l'autel, et son sang sera exprimé contre la paroi de l'autel; ");
INSERT INTO fra_fob_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Il ôtera son jabot avec ses plumes, et le jettera près de l'autel, vers l'Orient, au lieu où sera la cendre. ");
INSERT INTO fra_fob_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Puis il le déchirera par les ailes, sans les séparer, et le sacrificateur le fera fumer sur l'autel, sur le bois mis au feu; c'est un holocauste, un sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Quand quelqu'un fera à l'Éternel une offrande en don, son offrande sera de fleur de farine, sur laquelle il versera de l'huile, et mettra de l'encens. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Il l'apportera aux fils d'Aaron, les sacrificateurs; et le sacrificateur prendra une poignée de la fleur de farine arrosée d'huile, avec tout l'encens, et il fera fumer son mémorial sur l'autel. C'est un sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ce qui restera de l'offrande sera pour Aaron et pour ses fils; c'est une chose très sainte parmi les sacrifices faits par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Et quand tu feras une offrande en don de ce qui est cuit au four, ce sera des gâteaux sans levain, de fine farine, pétris à l'huile, et des galettes sans levain, ointes d'huile. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Et si ton offrande est une oblation cuite sur la plaque, elle sera de fine farine, pétrie à l'huile, sans levain. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Tu la rompras en morceaux, et tu verseras de l'huile dessus; c'est une oblation. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Et si ton offrande est une oblation cuite à la poêle, elle sera faite de fine farine avec de l'huile. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Tu apporteras l'oblation qui sera faite de ces choses à l'Éternel, et on la présentera au sacrificateur, qui l'apportera à l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Et le sacrificateur prélèvera de l'oblation son mémorial, et le fera fumer sur l'autel. C'est un sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ce qui restera de l'oblation sera pour Aaron et pour ses fils; c'est une chose très sainte, parmi les sacrifices faits par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Quelque oblation que vous offriez à l'Éternel, elle ne sera point faite avec du levain; car vous ne ferez fumer ni levain ni miel en sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Vous pourrez les offrir à l'Éternel comme offrande des prémices; mais ils ne seront point mis sur l'autel comme offrande d'agréable odeur. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Tu saleras de sel toutes tes oblations; et tu ne laisseras point ton offrande manquer du sel, signe de l'alliance de ton Dieu; sur toutes tes offrandes tu offriras du sel. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Et si tu offres une oblation des premiers fruits à l'Éternel, tu offriras, comme oblation de tes premiers fruits, des épis rôtis au feu, du grain nouveau, broyé. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Tu y mettras de l'huile, et tu y ajouteras de l'encens; c'est une oblation. ");
INSERT INTO fra_fob_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Et le sacrificateur fera fumer son mémorial, une partie du grain broyé et de l'huile, avec tout l'encens. C'est un sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Si quelqu'un offre un sacrifice de prospérités, s'il offre du gros bétail, mâle ou femelle, il l'offrira sans défaut, devant l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Il appuiera sa main sur la tête de son offrande et l'égorgera à l'entrée du tabernacle d'assignation; et les fils d'Aaron, les sacrificateurs, répandront le sang sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Il offrira, du sacrifice de prospérités, en sacrifice fait par le feu à l'Éternel: la graisse qui couvre les entrailles, et toute la graisse qui est sur les entrailles; ");
INSERT INTO fra_fob_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Et les deux rognons, et la graisse qui est dessus, ce qui est sur les lombes, et la membrane qui recouvre le foie; il la détachera près des rognons. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Et les fils d'Aaron feront fumer cela sur l'autel, par-dessus l'holocauste placé sur le bois qu'on aura mis au feu. C'est un sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Si son offrande pour le sacrifice de prospérités à l'Éternel est du menu bétail, mâle ou femelle, il l'offrira sans défaut. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","S'il offre un agneau pour son offrande, il l'offrira devant l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Et il appuiera sa main sur la tête de son offrande, et l'égorgera devant le tabernacle d'assignation; et les fils d'Aaron en répandront le sang sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Il offrira, du sacrifice de prospérités, en sacrifice fait par le feu à l'Éternel: sa graisse, la queue entière, qu'il séparera près de l'échine, et la graisse qui couvre les entrailles, et toute la graisse qui est sur les entrailles, ");
INSERT INTO fra_fob_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Et les deux rognons avec la graisse qui est sur eux, ce qui est sur les lombes, et la membrane qui recouvre le foie; il la détachera près des rognons. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Le sacrificateur fera fumer cela sur l'autel, comme aliment d'un sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Et si son offrande est une chèvre, il l'offrira devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Il appuiera la main sur sa tête, et l'égorgera devant le tabernacle d'assignation; et les fils d'Aaron en répandront le sang sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Et il en offrira son offrande, en sacrifice fait par le feu à l'Éternel: la graisse qui couvre les entrailles, et toute la graisse qui est sur les entrailles, ");
INSERT INTO fra_fob_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Et les deux rognons avec la graisse qui est sur eux, ce qui est sur les lombes, et la membrane qui recouvre le foie; il la détachera près des rognons. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Le sacrificateur les fera fumer sur l'autel, comme aliment d'un sacrifice fait par le feu, d'agréable odeur. Toute graisse appartient à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","C'est une ordonnance perpétuelle pour vos descendants, dans tous les lieux de votre habitation: vous ne mangerez ni graisse ni sang. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Parle aux enfants d'Israël, en disant: Lorsque quelqu'un aura péché par erreur contre l'un des commandements de l'Éternel, sur ce qui ne doit pas être fait, et qu'il aura fait quelqu'une de ces choses; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Si c'est le sacrificateur ayant reçu l'onction qui a péché, rendant par là le peuple coupable, il offrira à l'Éternel, pour le péché qu'il aura commis, un jeune taureau sans défaut, en sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Il amènera le taureau à l'entrée du tabernacle d'assignation devant l'Éternel; il appuiera sa main sur la tête du taureau, et il égorgera le taureau devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Le sacrificateur ayant reçu l'onction prendra du sang du taureau et l'apportera dans le tabernacle d'assignation; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Et le sacrificateur trempera son doigt dans le sang, et fera sept fois aspersion du sang devant l'Éternel, en face du voile du sanctuaire. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Puis le sacrificateur mettra du sang sur les cornes de l'autel des parfums d'aromates, qui est devant l'Éternel, dans le tabernacle d'assignation; et il répandra tout le sang du taureau au pied de l'autel de l'holocauste, qui est à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Et il enlèvera toute la graisse du taureau du sacrifice pour le péché, la graisse qui couvre les entrailles, et toute la graisse qui tient aux entrailles, ");
INSERT INTO fra_fob_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","Et les deux rognons, la graisse qui est dessus, ce qui est sur les lombes, et la membrane qui recouvre le foie, et qu'il détachera près des rognons, ");
INSERT INTO fra_fob_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Comme on enlève ces parties du taureau du sacrifice de prospérités; et le sacrificateur les fera fumer sur l'autel de l'holocauste. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mais la peau du taureau, toute sa chair, avec sa tête, ses jambes, ses entrailles et ses excréments, ");
INSERT INTO fra_fob_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","Le taureau entier, il l'emportera hors du camp, dans un lieu pur, où l'on jette la cendre, et il le brûlera sur du bois, au feu; il sera brûlé sur le tas de cendres. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Et si c'est toute l'assemblée d'Israël qui a péché par erreur, et que la chose soit ignorée de l'assemblée; s'ils ont fait contre l'un des commandements de l'Éternel des choses qui ne doivent point se faire, et qu'ils se soient rendus coupables, ");
INSERT INTO fra_fob_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Et que le péché qu'ils ont commis soit connu, l'assemblée offrira un jeune taureau en sacrifice pour le péché, et on l'amènera devant le tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Les anciens de l'assemblée appuieront leurs mains sur la tête du taureau devant l'Éternel, et on égorgera le taureau devant l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Le sacrificateur ayant reçu l'onction portera du sang du taureau dans le tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Puis le sacrificateur trempera son doigt dans le sang, et en fera sept fois aspersion devant l'Éternel, en face du voile. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Il mettra du sang sur les cornes de l'autel, qui est devant l'Éternel, dans le tabernacle d'assignation; et il répandra tout le sang au pied de l'autel de l'holocauste, qui est à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Il enlèvera aussi toute la graisse, et la fera fumer sur l'autel; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Et il fera de ce taureau comme il a fait du taureau expiatoire; il en fera de même. Ainsi le sacrificateur fera expiation pour eux, et il leur sera pardonné. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Puis il emportera le taureau hors du camp, et le brûlera, comme il a brûlé le premier taureau; c'est le sacrifice pour le péché de l'assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Si c'est un des principaux du peuple qui a péché, en faisant par erreur contre l'un des commandements de l'Éternel, son Dieu, ce qui ne doit pas être fait, et s'est rendu coupable; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Quand on lui aura fait connaître le péché qu'il a commis, il amènera pour son offrande un bouc mâle, sans défaut; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Il appuiera sa main sur la tête du bouc, et l'égorgera au lieu où l'on égorge l'holocauste devant l'Éternel; c'est un sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Le sacrificateur prendra avec son doigt du sang du sacrifice pour le péché, et le mettra sur les cornes de l'autel de l'holocauste; et il répandra le sang au pied de l'autel de l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Et il fera fumer toute la graisse sur l'autel, comme la graisse du sacrifice de prospérités. Ainsi le sacrificateur fera pour lui l'expiation de son péché, et il lui sera pardonné. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Si c'est quelqu'un du peuple qui a péché par erreur, en faisant contre l'un des commandements de l'Éternel, ce qui ne doit pas se faire, et qu'il se rende coupable; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Lorsqu'on lui aura fait connaître le péché qu'il a commis, il amènera pour son offrande une chèvre, une femelle sans défaut, pour le péché qu'il a commis; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Il appuiera sa main sur la tête du sacrifice pour le péché, et il égorgera le sacrifice pour le péché au même lieu que l'holocauste. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Puis le sacrificateur prendra avec son doigt du sang de la victime, et le mettra sur les cornes de l'autel de l'holocauste; et il répandra tout le sang au pied de l'autel; ");
INSERT INTO fra_fob_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Le sacrificateur ôtera toute la graisse, comme on ôte la graisse du sacrifice de prospérités; et il la fera fumer sur l'autel, en agréable odeur à l'Éternel. Ainsi le sacrificateur fera expiation pour cet homme, et il lui sera pardonné. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","S'il amène un agneau comme son offrande pour le péché, il amènera une femelle sans défaut. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Il appuiera sa main sur la tête du sacrifice pour le péché, et l'égorgera pour le péché, au lieu où l'on égorge l'holocauste. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Puis le sacrificateur prendra avec son doigt du sang de la victime pour le péché, et le mettra sur les cornes de l'autel de l'holocauste, et il répandra tout le sang au pied de l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Le sacrificateur ôtera toute la graisse, comme on ôte la graisse de l'agneau du sacrifice de prospérités, et il les fera fumer sur l'autel, à la manière des sacrifices de l'Éternel faits par le feu. Ainsi le sacrificateur fera l'expiation pour cet homme, pour le péché qu'il a commis, et il lui sera pardonné. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Lorsque quelqu'un étant témoin, après avoir entendu la parole du serment, aura péché en ne déclarant pas ce qu'il a vu ou ce qu'il sait, il portera son iniquité. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Ou lorsque quelqu'un, à son insu, aura touché une chose souillée, soit le cadavre d'un animal impur, soit le cadavre d'une bête sauvage impure, soit le cadavre d'un reptile impur, il sera souillé et coupable. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ou lorsque, ne le sachant pas ou le sachant, il touchera une souillure humaine, de quelque manière qu'il se soit souillé, il sera coupable. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Ou lorsque quelqu'un, parlant légèrement des lèvres, aura juré de faire du mal ou du bien, selon tout ce que l'homme peut jurer à la légère, qu'il ne s'en aperçoive pas ou qu'il le sache, il sera coupable sur l'un de ces cas. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Quand donc quelqu'un sera coupable de l'une de ces choses, il confessera ce en quoi il a péché, ");
INSERT INTO fra_fob_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Et il amènera à l'Éternel son sacrifice pour le délit, pour le péché qu'il a commis, une femelle de menu bétail, une brebis ou une chèvre, en sacrifice pour le péché; et le sacrificateur fera pour lui l'expiation de son péché. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Et s'il n'a pas le moyen de se procurer une brebis ou une chèvre, il apportera à l'Éternel, en sacrifice de délit, pour son péché, deux tourterelles, ou deux pigeonneaux; l'un en sacrifice pour le péché, et l'autre en holocauste. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Il les apportera au sacrificateur, qui offrira premièrement celui qui est pour le sacrifice de péché; il lui brisera la tête près de la nuque, sans la séparer; ");
INSERT INTO fra_fob_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Ensuite il fera aspersion, sur un côté de l'autel, du sang du sacrifice pour le péché, et le reste du sang sera exprimé au pied de l'autel; c'est un sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Il fera de l'autre oiseau un holocauste, selon l'ordonnance. Et ainsi le sacrificateur fera pour cet homme l'expiation du péché qu'il a commis, et il lui sera pardonné. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","S'il n'a pas les moyens de se procurer deux tourterelles ou deux pigeonneaux, il apportera pour son offrande, pour le péché qu'il a commis, le dixième d'un épha de fine farine, comme sacrifice pour le péché; il ne mettra pas de l'huile dessus, il n'y ajoutera point d'encens; car c'est un sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Il l'apportera au sacrificateur, et le sacrificateur en prendra une poignée en mémorial, et la fera fumer sur l'autel, à la manière des sacrifices faits par le feu à l'Éternel; c'est un sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ainsi le sacrificateur fera expiation pour cet homme, pour le péché qu'il aura commis à l'égard de l'une de ces choses, et il lui sera pardonné; et le reste sera pour le sacrificateur, comme dans le cas de l'oblation. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Lorsque quelqu'un commettra une prévarication et péchera par erreur, en retenant des choses consacrées à l'Éternel, il amènera à l'Éternel en sacrifice pour le délit, un bélier sans défaut, pris du troupeau, selon ton estimation en sicles d'argent, selon le sicle du sanctuaire, en sacrifice pour le délit. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Il restituera ce en quoi il aura péché à l'égard du sanctuaire, en y ajoutant le cinquième de sa valeur; et il le donnera au sacrificateur. Et le sacrificateur fera expiation pour cet homme avec le bélier du sacrifice pour le délit, et il lui sera pardonné. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Et lorsque quelqu'un péchera, en faisant, sans le savoir, contre l'un des commandements de l'Éternel, ce qui ne doit pas se faire, il sera coupable et portera son iniquité. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Il amènera donc au sacrificateur, en sacrifice pour le délit, un bélier sans défaut, pris du troupeau, d'après ton estimation; et le sacrificateur fera pour lui expiation de la faute qu'il a commise par erreur, et sans le savoir, et il lui sera pardonné. ");
INSERT INTO fra_fob_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","C'est un sacrifice pour le délit: il s'est rendu coupable envers l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Lorsque quelqu'un péchera et commettra une prévarication envers l'Éternel, en mentant à son prochain au sujet d'un dépôt, d'une chose qu'on lui a confiée, d'un vol, ou en agissant injustement envers son prochain; ");
INSERT INTO fra_fob_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Ou s'il a trouvé une chose perdue, et qu'il mente à ce sujet; ou s'il jure faussement, concernant quelqu'une des choses dans lesquelles l'homme pèche en les faisant; ");
INSERT INTO fra_fob_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Quand il aura ainsi péché et se sera rendu coupable, il rendra la chose qu'il a dérobée, ou ce qu'il a usurpé par fraude, ou le dépôt qui lui a été confié, ou la chose perdue qu'il a trouvée, ");
INSERT INTO fra_fob_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Ou toute chose au sujet de laquelle il a juré faussement; il la restituera en son entier, et il y ajoutera un cinquième, et la remettra à celui à qui elle appartient, au jour où il fera un sacrifice pour le délit. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Et il amènera au sacrificateur en sacrifice pour le délit à l'Éternel, pour son péché, un bélier sans défaut, pris du troupeau d'après ton estimation; ");
INSERT INTO fra_fob_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Et le sacrificateur fera expiation pour lui devant l'Éternel, et il lui sera pardonné, quelque chose qu'il ait commise en se rendant coupable. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Donne cet ordre à Aaron et à ses fils, en disant: Voici la loi de l'holocauste: L'holocauste restera sur le foyer de l'autel toute la nuit jusqu'au matin, et le feu de l'autel y sera tenu allumé. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Le sacrificateur revêtira sa tunique de lin, et mettra des caleçons de lin sur sa chair; et il enlèvera la cendre provenant du feu qui aura consumé l'holocauste sur l'autel, et la mettra près de l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Puis il quittera ses vêtements et en revêtira d'autres, et transportera la cendre hors du camp, dans un lieu pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Et quant au feu qui est sur l'autel, on l'y tiendra allumé; il ne s'éteindra pas. Le sacrificateur y allumera du bois tous les matins; il arrangera l'holocauste sur le feu, et y fera fumer les graisses des sacrifices de prospérités. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Le feu brûlera continuellement sur l'autel; il ne s'éteindra pas. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Voici la loi de l'oblation: Les fils d'Aaron la présenteront devant l'Éternel, devant l'autel; ");
INSERT INTO fra_fob_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","On prélèvera de l'oblation une poignée de fleur de farine, et de son huile, et tout l'encens qui est sur l'oblation, et l'on fera fumer cela sur l'autel en agréable odeur, en mémorial à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aaron et ses fils mangeront ce qui restera de l'offrande. On le mangera sans levain, dans un lieu saint; ils le mangeront dans le parvis du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","On ne le cuira point avec du levain. C'est leur part, que je leur ai donnée de mes sacrifices faits par le feu. C'est une chose très sainte, comme le sacrifice pour le péché et comme le sacrifice pour le délit. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Tout mâle d'entre les fils d'Aaron en mangera; c'est une ordonnance perpétuelle dans vos générations, au sujet des sacrifices faits par le feu à l'Éternel; quiconque y touchera sera sanctifié. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Voici l'offrande d'Aaron et de ses fils, qu'ils offriront à l'Éternel, au jour où ils seront oints: Un dixième d'épha de fine farine comme offrande perpétuelle, moitié le matin, et moitié le soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Elle sera apprêtée sur une plaque avec de l'huile; tu l'apporteras mélangée; tu offriras les pièces cuites de l'offrande divisée en morceaux, en agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Et celui de ses fils qui sera oint sacrificateur à sa place, fera cette offrande; c'est une ordonnance perpétuelle devant l'Éternel: on la fera fumer tout entière. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Et toute offrande de sacrificateur sera consumée entièrement; on n'en mangera pas. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Parle à Aaron et à ses fils, en disant: Voici la loi du sacrifice pour le péché: Le sacrifice pour le péché sera égorgé devant l'Éternel dans le lieu où l'on égorge l'holocauste; c'est une chose très sainte. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Le sacrificateur qui offrira le sacrifice pour le péché, le mangera; il sera mangé dans un lieu saint, dans le parvis du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Quiconque en touchera la chair, sera sanctifié, et s'il en rejaillit du sang sur un vêtement, tu laveras dans un lieu saint ce vêtement sur lequel il aura rejailli. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Le vase de terre dans lequel il aura cuit sera brisé; mais s'il a cuit dans un vase d'airain, il sera écuré et lavé dans l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Tout mâle parmi les sacrificateurs en mangera: ");
INSERT INTO fra_fob_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","C'est une chose très sainte. Mais nul sacrifice pour le péché, dont il sera porté du sang dans le tabernacle d'assignation, pour faire expiation dans le sanctuaire, ne sera mangé: il sera brûlé au feu. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Voici la loi du sacrifice pour le délit; c'est une chose très sainte. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Dans le lieu où l'on égorge l'holocauste, on égorgera la victime du sacrifice pour le délit; et l'on en répandra le sang sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Puis on en offrira toute la graisse, la queue, la graisse qui couvre les entrailles, ");
INSERT INTO fra_fob_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Les deux rognons et la graisse qui est dessus, ce qui est sur les lombes, et la membrane qui recouvre le foie; on la détachera près des rognons. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Et le sacrificateur les fera fumer sur l'autel, en sacrifice fait par le feu à l'Éternel: c'est un sacrifice pour le délit. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Tout mâle parmi les sacrificateurs en mangera; il sera mangé dans un lieu saint; c'est une chose très sainte. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Il en est du sacrifice pour le délit comme du sacrifice pour le péché; ils ont une même loi; la victime appartiendra au sacrificateur qui fera expiation par son moyen. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Le sacrificateur qui offre l'holocauste pour quelqu'un, aura la peau de l'holocauste qu'il a offert; elle sera pour lui. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Et toute offrande qui sera cuite au four, et tout ce qui sera apprêté dans la poêle, et sur la plaque, appartient au sacrificateur qui l'offre; ce sera pour lui. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Et toute offrande arrosée d'huile, ou sèche, sera pour tous les fils d'Aaron, pour l'un comme pour l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Et voici la loi du sacrifice de prospérités, qu'on offrira à l'Éternel: ");
INSERT INTO fra_fob_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Si on l'offre pour rendre grâces, on offrira, avec le sacrifice de prospérités, des gâteaux sans levain arrosés d'huile, des galettes sans levain ointes d'huile, et de la fleur de farine mélangée en gâteaux arrosés d'huile; ");
INSERT INTO fra_fob_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","On offrira son offrande avec des gâteaux de pain levé, avec son sacrifice d'actions de grâces et de prospérités. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","On présentera une portion de chaque offrande, en oblation élevée à l'Éternel; elle sera pour le sacrificateur qui aura répandu le sang du sacrifice de prospérités. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Et la chair du sacrifice d'actions de grâces et de prospérités, sera mangée le jour qu'elle sera offerte; on n'en laissera rien jusqu'au matin. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Si le sacrifice d'une offrande est présenté pour un vœu ou comme offrande volontaire, le sacrifice sera mangé le jour où on l'aura offert, et le lendemain on en mangera le reste. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Mais ce qui restera de la chair du sacrifice, sera brûlé au feu le troisième jour. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Si quelqu'un mange de la chair de son sacrifice de prospérités au troisième jour, celui qui l'aura offert ne sera point agréé; il ne lui sera point imputé; ce sera une abomination, et la personne qui en aura mangé, portera son iniquité. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Et la chair qui aura touché quelque chose de souillé, ne sera point mangée: elle sera brûlée au feu. Quant à la chair qui se mange, quiconque sera pur en mangera. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Mais la personne qui mangera de la chair du sacrifice de prospérités qui appartient à l'Éternel, et qui sera souillée, cette personne sera retranchée de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Et si quelqu'un touche quelque chose de souillé, souillure d'homme, ou bête immonde, ou quelque abomination immonde, et qu'il mange de la chair du sacrifice de prospérités qui appartient à l'Éternel, celui-là sera retranché de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Parle aux enfants d'Israël, en disant: Vous ne mangerez aucune graisse de bœuf, ni d'agneau, ni de chèvre; ");
INSERT INTO fra_fob_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","La graisse d'une bête morte et la graisse d'une bête déchirée pourra servir à tout usage; mais vous n'en mangerez point; ");
INSERT INTO fra_fob_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Car quiconque mangera de la graisse des bêtes dont on offre un sacrifice fait par le feu à l'Éternel, celui qui en aura mangé, sera retranché de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Et dans tous les lieux où vous habiterez vous ne mangerez point de sang, ni d'oiseaux, ni de bétail. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Toute personne qui mangera d'un sang quelconque, sera retranchée de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Parle aux enfants d'Israël, et dis-leur: Celui qui offrira à l'Éternel son sacrifice de prospérités, apportera à l'Éternel son offrande, prise de son sacrifice de prospérités. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Il apportera de ses propres mains ce qui doit être offert par le feu à l'Éternel; il apportera la graisse avec la poitrine, la poitrine pour l'agiter en offrande devant l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Et le sacrificateur fera fumer la graisse sur l'autel; et la poitrine sera pour Aaron et pour ses fils. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Vous donnerez aussi au sacrificateur, en offrande élevée, la jambe droite de vos sacrifices de prospérités. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Celui des fils d'Aaron qui offrira le sang et la graisse des sacrifices de prospérités, aura la jambe droite pour sa part. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Car je prends, sur les sacrifices de prospérités des enfants d'Israël, la poitrine qu'on agite devant moi et la jambe qu'on présente par élévation, et je les donne à Aaron le sacrificateur et à ses fils, par une ordonnance perpétuelle de la part des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","C'est là le droit que l'onction conférera à Aaron et à ses fils, sur les sacrifices faits par le feu à l'Éternel, au jour où on les présentera pour exercer la sacrificature à l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","C'est ce que l'Éternel a commandé aux enfants d'Israël de leur donner, depuis le jour de leur onction. C'est une ordonnance perpétuelle dans tous les âges. ");
INSERT INTO fra_fob_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Telle est la loi de l'holocauste, de l'offrande, du sacrifice pour le péché, du sacrifice pour le délit, de l'installation, et du sacrifice de prospérités, ");
INSERT INTO fra_fob_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Que l'Éternel commanda à Moïse au mont Sinaï, lorsqu'il ordonna aux enfants d'Israël de présenter leurs offrandes à l'Éternel dans le désert de Sinaï. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","L'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Prends Aaron et ses fils avec lui, les vêtements, l'huile d'onction, le taureau du sacrifice pour le péché, les deux béliers, et la corbeille de pains sans levain; ");
INSERT INTO fra_fob_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Et convoque toute l'assemblée à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moïse fit donc comme l'Éternel lui avait commandé; et l'assemblée fut convoquée à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Et Moïse dit à l'assemblée: Voici ce que l'Éternel a commandé de faire. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Puis Moïse fit approcher Aaron et ses fils, et les lava avec de l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Et il mit à Aaron la tunique, le ceignit de la ceinture, et le revêtit de la robe; il lui mit l'éphod, et le ceignit de la ceinture de l'éphod, dont il le revêtit. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Il lui mit aussi le pectoral, et mit au pectoral l'Urim et le Thummim. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Il posa la tiare sur sa tête, et sur le devant de la tiare, la lame d'or, la couronne sainte, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ensuite Moïse prit l'huile d'onction; il oignit la Demeure, et toutes les choses qui y étaient, et les consacra. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Il en fit aspersion sur l'autel par sept fois, et il oignit l'autel et tous ses ustensiles, et la cuve avec son soubassement, pour les consacrer. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Il versa aussi de l'huile d'onction sur la tête d'Aaron, et l'oignit pour le consacrer. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Puis Moïse fit approcher les fils d'Aaron, et les revêtit de tuniques, les ceignit de ceintures, et leur attacha des mitres, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Il fit approcher le taureau du sacrifice pour le péché, et Aaron et ses fils appuyèrent leurs mains sur la tête du taureau du sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Et Moïse l'égorgea, prit le sang, et en mit avec son doigt sur les cornes de l'autel tout autour, et purifia l'autel; puis il répandit le sang au pied de l'autel, et le consacra ainsi pour y faire l'expiation. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Et il prit toute la graisse qui était sur les entrailles, la membrane qui recouvre le foie, et les deux rognons avec leur graisse, et Moïse les fit fumer sur l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mais il brûla au feu hors du camp le taureau, sa peau, sa chair et ses excréments, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Il fit aussi approcher le bélier de l'holocauste, et Aaron et ses fils appuyèrent leurs mains sur la tête du bélier; ");
INSERT INTO fra_fob_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Et Moïse l'égorgea, et répandit le sang sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Puis il coupa le bélier en morceaux; et Moïse fit fumer la tête, les morceaux, et la graisse. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Et il lava dans l'eau les entrailles et les jambes, et Moïse fit fumer tout le bélier sur l'autel; ce fut l'holocauste d'agréable odeur; ce fut un sacrifice fait par le feu à l'Éternel, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Il fit aussi approcher le second bélier, le bélier d'installation; et Aaron et ses fils appuyèrent leurs mains sur la tête du bélier. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moïse l'égorgea, prit de son sang et en mit sur le bout de l'oreille droite d'Aaron, et sur le pouce de sa main droite, et sur le gros orteil de son pied droit. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Moise fit aussi approcher les fils d'Aaron, mit du sang sur le bout de leur oreille droite, sur le pouce de leur main droite, et sur le gros orteil de leur pied droit, et Moïse répandit le sang sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Ensuite il prit la graisse, la queue, toute la graisse qui était sur les entrailles, la membrane qui recouvre le foie, les deux rognons avec leur graisse, et la jambe droite; ");
INSERT INTO fra_fob_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Il prit aussi de la corbeille des pains sans levain, qui était devant l'Éternel, un gâteau sans levain, un gâteau de pain à l'huile, et une galette; et il les mit sur les graisses et sur la jambe droite. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Puis il plaça le tout dans les mains d'Aaron, et dans les mains de ses fils, et il les agita en offrande devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Puis Moïse les prit de leurs mains, et les fit fumer à l'autel, sur l'holocauste; ce fut le sacrifice d'installation, d'agréable odeur, un sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moïse prit aussi la poitrine du bélier d'installation, et l'agita en offrande devant l'Éternel; ce fut la portion de Moïse, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Et Moïse prit de l'huile d'onction et du sang qui était sur l'autel; il en fit aspersion sur Aaron et sur ses vêtements, sur ses fils, et sur les vêtements de ses fils avec lui; et il consacra Aaron et ses vêtements, ses fils, et les vêtements de ses fils avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Puis Moïse dit à Aaron et à ses fils: Faites cuire la chair à l'entrée du tabernacle d'assignation et vous la mangerez là, avec le pain qui est dans la corbeille d'installation, comme je l'ai commandé, en disant: Aaron et ses fils la mangeront. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Mais vous brûlerez au feu ce qui restera de la chair et du pain. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Et pendant sept jours, vous ne sortirez pas de l'entrée du tabernacle d'assignation, jusqu'à ce que les jours de votre installation soient accomplis; car on vous installera pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","L'Éternel a commandé de faire comme on a fait aujourd'hui, pour faire expiation pour vous. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Vous resterez donc sept jours à l'entrée du tabernacle d'assignation, jour et nuit, et vous observerez le commandement de l'Éternel, afin que vous ne mouriez pas; car il m'a été ainsi commandé. ");
INSERT INTO fra_fob_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Et Aaron et ses fils firent toutes les choses que l'Éternel avait commandées par Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Le huitième jour, Moïse appela Aaron et ses fils, et les anciens d'Israël; ");
INSERT INTO fra_fob_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Et il dit à Aaron: Prends un jeune veau pour le sacrifice pour le péché, et un bélier pour l'holocauste, l'un et l'autre sans défaut, et offre-les devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Et tu parleras aux enfants d'Israël, en disant: Prenez un bouc pour le sacrifice pour le péché; un veau et un agneau sans défaut, âgés d'un an, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Un taureau et un bélier pour le sacrifice de prospérités, pour sacrifier devant l'Éternel, et une offrande arrosée d'huile; car aujourd'hui l'Éternel vous apparaîtra. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ils amenèrent donc devant le tabernacle d'assignation ce que Moïse avait commandé; et toute l'assemblée s'approcha, et se tint devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Et Moïse dit: Voici ce que l'Éternel a commandé, faites-le, et la gloire de l'Éternel vous apparaîtra. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Puis Moïse dit à Aaron: Approche-toi de l'autel; fais ton sacrifice pour le péché et ton holocauste, et fais l'expiation pour toi et pour le peuple; présente aussi l'offrande du peuple, et fais l'expiation pour lui, comme l'Éternel l'a commandé. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Alors Aaron s'approcha de l'autel, et égorgea le veau de son sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Et les fils d'Aaron lui présentèrent le sang; il trempa son doigt dans le sang, en mit sur les cornes de l'autel, et répandit le sang au pied de l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Et il fit fumer sur l'autel la graisse, les rognons, et la membrane qui recouvre le foie de la victime pour le péché, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mais il brûla au feu, hors du camp, la chair et la peau. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ensuite il égorgea l'holocauste. Les fils d'Aaron lui présentèrent le sang, et il le répandit sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ils lui présentèrent aussi l'holocauste, coupé par morceaux, et la tête, et il les fit fumer sur l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Puis il lava les entrailles et les jambes, et il les fit fumer sur l'holocauste à l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Il offrit aussi l'offrande du peuple. Il prit le bouc du sacrifice pour le péché qui était pour le peuple; il l'égorgea, et l'offrit pour le péché, comme le premier sacrifice; ");
INSERT INTO fra_fob_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Et il offrit l'holocauste, et le fit selon l'ordonnance. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Ensuite il présenta l'offrande; il en remplit la paume de sa main, et la fit fumer sur l'autel, outre l'holocauste du matin. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Il égorgea aussi le taureau et le bélier en sacrifice de prospérités pour le peuple. Les fils d'Aaron lui présentèrent le sang, et il le répandit sur l'autel tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ils lui présentèrent aussi la graisse du taureau et du bélier, la queue, ce qui couvre les entrailles, les rognons, et la membrane qui recouvre le foie; ");
INSERT INTO fra_fob_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Et ils mirent les graisses sur les poitrines, et il fit fumer les graisses sur l'autel; ");
INSERT INTO fra_fob_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Puis Aaron agita devant l'Éternel, en offrande, les poitrines et la jambe droite, comme Moïse l'avait commandé. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Et Aaron éleva ses mains vers le peuple, et le bénit; et il descendit, après avoir offert le sacrifice pour le péché, l'holocauste et le sacrifice de prospérités. ");
INSERT INTO fra_fob_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Alors Moïse et Aaron entrèrent dans le tabernacle d'assignation, puis ils sortirent et bénirent le peuple; et la gloire de l'Éternel apparut à tout le peuple: ");
INSERT INTO fra_fob_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Un feu sortit de devant l'Éternel, et consuma sur l'autel l'holocauste et les graisses; et tout le peuple le vit, et ils poussèrent des cris de joie, et se jetèrent sur leurs faces. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Or les fils d'Aaron, Nadab et Abihu, prirent chacun leur encensoir, y mirent du feu, posèrent du parfum dessus, et offrirent devant l'Éternel un feu étranger; ce qu'il ne leur avait point commandé. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Et un feu sortit de devant l'Éternel, et les dévora, et ils moururent devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Alors Moïse dit à Aaron: C'est ce dont l'Éternel a parlé, en disant: Je serai sanctifié par ceux qui s'approchent de moi, et je serai glorifié en présence de tout le peuple. Et Aaron se tut. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Et Moïse appela Mishaël et Eltsaphan, fils d'Uziel, oncle d'Aaron, et leur dit: Approchez-vous, emportez vos frères de devant le sanctuaire, hors du camp. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ils s'approchèrent donc, et les emportèrent dans leurs tuniques hors du camp, comme Moïse l'avait dit. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Puis Moïse dit à Aaron, et à Éléazar et à Ithamar, ses fils: Ne découvrez point vos têtes, et ne déchirez point vos vêtements, de peur que vous ne mouriez, et que l'Éternel ne se courrouce contre toute l'assemblée; mais que vos frères, toute la maison d'Israël, pleurent à cause de l'embrasement que l'Éternel a allumé. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Et ne sortez pas de l'entrée du tabernacle d'assignation, de peur que vous ne mouriez; car l'huile de l'onction de l'Éternel est sur vous. Et ils firent selon la parole de Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Puis l'Éternel parla à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Tu ne boiras ni vin ni boisson enivrante, toi et tes fils avec toi, quand vous entrerez dans le tabernacle d'assignation, de peur que vous ne mouriez; c'est une ordonnance perpétuelle dans vos générations, ");
INSERT INTO fra_fob_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Afin que vous puissiez discerner entre ce qui est saint et ce qui est profane, entre ce qui est souillé et ce qui est pur, ");
INSERT INTO fra_fob_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Et enseigner aux enfants d'Israël toutes les ordonnances que l'Éternel leur a prescrites par Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Et Moïse dit à Aaron, et à Éléazar et à Ithamar, les fils qui lui restaient: Prenez le reste de l'offrande des sacrifices faits par le feu à l'Éternel, et mangez-le sans levain près de l'autel; car c'est une chose très sainte. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Vous le mangerez dans un lieu saint, car c'est ton droit et le droit de tes fils, sur les sacrifices faits par le feu à l'Éternel; car cela m'a été ainsi commandé. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Quant à la poitrine offerte par agitation et à la jambe présentée par élévation, vous les mangerez dans un lieu pur, toi, tes fils, et tes filles avec toi; car elles vous sont données comme ton droit et le droit de tes fils, dans les sacrifices de prospérités des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","On apportera avec les sacrifices des graisses faits par le feu, la jambe présentée par élévation et la poitrine offerte par agitation, pour les agiter en offrande devant l'Éternel; et cela t'appartiendra, et à tes fils avec toi, par une loi perpétuelle, comme l'Éternel l'a commandé. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Or Moïse cherchait le bouc du sacrifice pour le péché; et voici, il avait été brûlé. Alors il se courrouça contre Éléazar et Ithamar, les fils qui restaient à Aaron, et leur dit: ");
INSERT INTO fra_fob_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Pourquoi n'avez-vous pas mangé le sacrifice pour le péché dans le lieu saint? car c'est une chose très sainte, et l'Éternel vous l'a donné pour porter l'iniquité de l'assemblée, pour faire l'expiation pour elle devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Voici, son sang n'a point été porté dans l'intérieur du sanctuaire; vous deviez manger le sacrifice dans le sanctuaire, comme je l'ai commandé. ");
INSERT INTO fra_fob_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Mais Aaron dit à Moïse: Voici, ils ont offert aujourd'hui leur sacrifice pour le péché, et leur holocauste devant l' Éternel; et après ce qui m'est arrivé, si j'eusse mangé aujourd'hui le sacrifice pour le péché, cela eût-il plu à l'Éternel ");
INSERT INTO fra_fob_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Et Moïse, l'ayant entendu, approuva. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","L'Éternel parla à Moïse et à Aaron, en leur disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Parlez aux enfants d'Israël, et dites: Voici les animaux que vous mangerez, d'entre toutes les bêtes qui sont sur la terre: ");
INSERT INTO fra_fob_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Vous mangerez parmi le bétail tout ce qui a l'ongle divisé et le pied fourché, et qui rumine; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Mais vous ne mangerez point d'entre celles qui ruminent, et d'entre celles qui ont l'ongle divisé: le chameau, car il rumine, mais il n'a point l'ongle divisé; il vous sera souillé; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Le lapin, car il rumine, mais il n'a point l'ongle divisé; il vous sera souillé; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Le lièvre, car il rumine, mais il n'a point l'ongle divisé; il vous sera souillé; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Le porc, car il a l'ongle divisé et le pied fourché, mais il ne rumine pas; il vous sera souillé; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Vous ne mangerez point de leur chair, vous ne toucherez point leur cadavre; ils vous seront souillés. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Voici ce que vous mangerez de tout ce qui est dans les eaux: Vous mangerez tout ce qui a des nageoires et des écailles, dans les eaux, dans les mers, et dans les rivières; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Mais tout ce qui n'a point de nageoires ni d'écailles, dans les mers et dans les rivières, parmi tout ce qui fourmille dans les eaux, et parmi tout être vivant dans les eaux, vous sera en abomination. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Ils vous seront en abomination; vous ne mangerez point de leur chair, et vous tiendrez pour abominable leur cadavre. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tout ce qui n'a pas de nageoires et d'écailles dans les eaux, vous sera en abomination. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Et voici parmi les oiseaux ceux que vous tiendrez pour abominables; on ne les mangera pas, c'est une abomination: l'aigle, l'orfraie, et le vautour; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Le milan et le faucon, selon leur espèce; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Toute espèce de corbeau; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Le chat-huant, le coucou, la mouette, l'épervier et ce qui est de son espèce; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","La chouette, le plongeon, et le hibou; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Le cygne, le pélican, le cormoran; ");
INSERT INTO fra_fob_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","La cigogne, le héron, et ce qui est de son espèce; la huppe et la chauve-souris. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Tout reptile qui vole et qui marche sur quatre pieds vous sera en abomination. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mais de tout reptile qui vole et qui marche sur quatre pieds, vous mangerez ceux qui ont des jambes au-dessus de leurs pieds, pour sauter sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Voici ceux que vous mangerez: la sauterelle selon son espèce, le solam selon son espèce, le hargol selon son espèce, et le hagab selon son espèce. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Tout autre reptile qui vole et qui a quatre pieds, vous sera en abomination. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Vous serez souillés à cause d'eux; quiconque touchera leur cadavre, sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Et quiconque portera leur corps mort, lavera ses vêtements, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Toute bête qui a l'ongle divisé, et qui n'a point le pied fourché, et ne rumine pas, vous sera souillée; quiconque la touchera, sera souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Et tout ce qui marche sur ses pattes, entre tous les animaux qui marchent sur quatre pieds, vous sera souillé; quiconque en touchera le corps mort, sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Et quiconque portera leur corps mort, lavera ses vêtements, et sera souillé jusqu'au soir; ces animaux vous seront souillés. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Et voici ce qui sera souillé pour vous parmi les animaux qui rampent sur la terre: la taupe, la souris et le lézard, selon leur espèce, ");
INSERT INTO fra_fob_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","La musaraigne, la grenouille, la tortue, la limace et le caméléon. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ceux-là sont souillés pour vous entre tous les reptiles; quiconque les touchera morts, sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Tout objet sur lequel il en tombera quand ils seront morts, sera souillé, ustensile de bois, vêtement, peau, sac, tout objet dont on fait usage; il sera mis dans l'eau, et sera souillé jusqu'au soir, puis il sera pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Et s'il en tombe quelque chose dans un vase de terre, tout ce qui se trouvera dedans sera souillé, et vous briserez le vase. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Tout aliment qu'on mange, sur lequel il sera tombé de cette eau, sera souillé; et tout breuvage qu'on boit, dans quelque vase que ce soit, en sera souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Tout objet sur lequel tombera quelque chose de leur corps mort, sera souillé; le four et le foyer seront détruits; ils sont souillés, et ils vous seront souillés. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Toutefois une source ou une citerne, formant amas d'eau, seront pures; mais qui touchera leur corps mort sera souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Et s'il tombe quelque chose de leur corps mort sur quelque semence que l'on sème, elle sera pure. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Mais si l'on a mis de l'eau sur la semence, et qu'il y tombe quelque chose de leur corps mort, elle vous sera souillée. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Et quand une des bêtes qui vous sert de nourriture mourra, celui qui en touchera le cadavre, sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Celui qui mangera de son corps mort lavera ses vêtements, et sera souillé jusqu'au soir; et celui qui portera son corps mort, lavera ses vêtements, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Tout reptile qui rampe sur la terre est une abomination; on n'en mangera point. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Vous ne mangerez point, parmi les reptiles qui rampent sur la terre, ceux qui marchent sur le ventre, ni ceux qui marchent sur quatre pieds, ou sur un grand nombre de pieds; car ils sont une abomination. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ne rendez point vos personnes abominables par aucun reptile qui rampe, ne vous rendez point impurs par eux, ne vous souillez point par eux. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Car je suis l'Éternel, votre Dieu; vous vous sanctifierez, et vous serez saints; car je suis saint. Et vous ne souillerez point vos personnes par aucun de ces reptiles qui rampent sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Car je suis l'Éternel, qui vous ai fait monter du pays d'Égypte, pour être votre Dieu; vous serez saints, car je suis saint. ");
INSERT INTO fra_fob_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Telle est la loi touchant le bétail, les oiseaux, tout être vivant qui se meut dans les eaux, et pour tout être qui rampe sur la terre, ");
INSERT INTO fra_fob_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Afin de discerner entre ce qui est souillé et ce qui est pur, entre l'animal qui se mange et celui qui ne se mange pas. ");
INSERT INTO fra_fob_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","L'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Parle aux enfants d'Israël, et dis: Quand une femme deviendra enceinte et enfantera un mâle, elle sera souillée sept jours; elle sera souillée comme au temps de l'impureté de son indisposition. ");
INSERT INTO fra_fob_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Et le huitième jour on circoncira la chair du prépuce de l'enfant. ");
INSERT INTO fra_fob_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Elle restera pendant trente-trois jours, à se purifier de son sang; elle ne touchera aucune chose sainte, et n'ira point au sanctuaire, jusqu'à ce que les jours de sa purification soient accomplis. ");
INSERT INTO fra_fob_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Et si elle enfante une fille, elle sera souillée deux semaines, comme pour son impureté, et elle restera soixante-six jours à se purifier de son sang. ");
INSERT INTO fra_fob_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Et quand les jours de sa purification seront accomplis, pour un fils ou pour une fille, elle présentera au sacrificateur un agneau de l'année, en holocauste, et un pigeonneau ou une tourterelle, en sacrifice pour le péché, à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Le sacrificateur l'offrira devant l'Éternel, et fera l'expiation pour elle, et elle sera purifiée du flux de son sang. Telle est la loi touchant celle qui enfante un mâle ou une fille. ");
INSERT INTO fra_fob_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Mais si elle n'a pas le moyen de se procurer un agneau, elle prendra deux tourterelles ou deux pigeonneaux, l'un pour l'holocauste et l'autre pour le sacrifice pour le péché; et le sacrificateur fera l'expiation pour elle, et elle sera purifiée. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","L'Éternel parla aussi à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Quand un homme aura sur la peau de son corps une tumeur, une éruption, ou une tache blanche, qui sera devenue sur la peau de son corps une plaie de lèpre, on l'amènera à Aaron, le sacrificateur, ou à l'un de ses fils, les sacrificateurs. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Le sacrificateur regardera la plaie qui est sur la peau du corps. Si le poil de la plaie est devenu blanc, et si l'apparence de la plaie est plus enfoncée que la peau du corps, c'est une plaie de lèpre: le sacrificateur le verra et déclarera cet homme souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Mais s'il y a une tache blanche sur la peau du corps, et que son apparence ne soit pas plus enfoncée que la peau, et si son poil n'est pas devenu blanc, le sacrificateur enfermera pendant sept jours celui qui a la plaie. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Le sacrificateur l'examinera au septième jour; et si la plaie lui paraît s'être arrêtée, si la plaie ne s'est pas étendue sur la peau, le sacrificateur l'enfermera une seconde fois pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Et le sacrificateur l'examinera une seconde fois au septième jour. Si la plaie est devenue pâle, et ne s'est pas étendue sur la peau, le sacrificateur déclarera cet homme pur; c'est une éruption. Il lavera ses vêtements et sera pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mais si l'éruption s'étend sur la peau, après qu'il aura paru devant le sacrificateur pour être déclaré pur, il se montrera une seconde fois au sacrificateur, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Le sacrificateur l'examinera; et si l'éruption s'est étendue sur la peau, le sacrificateur le déclarera souillé; c'est la lèpre. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Quand il y aura une plaie de lèpre sur un homme, on l'amènera au sacrificateur. Et le sacrificateur l'examinera. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","S'il y a une tumeur blanche sur la peau, et qu'elle ait rendu le poil blanc, et qu'il y ait trace de chair vive dans la tumeur, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","C'est une lèpre invétérée dans la peau de son corps, et le sacrificateur le déclarera souillé; il ne l'enfermera pas, car il est souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Mais si la lèpre fait une éruption sur la peau, et que la lèpre couvre toute la peau de celui qui a la plaie, de la tête aux pieds, partout où peut voir le sacrificateur, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Le sacrificateur l'examinera, et si la lèpre a couvert toute sa chair, il déclarera pur celui qui a la plaie; il est devenu tout blanc; il est pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mais le jour où il y paraîtra de la chair vive, il sera souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Quand le sacrificateur aura vu la chair vive, il le déclarera souillé; la chair vive est souillée, c'est la lèpre. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Mais si la chair vive change et devient blanche, il ira vers le sacrificateur; ");
INSERT INTO fra_fob_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Et le sacrificateur l'examinera; et si la plaie est devenue blanche, le sacrificateur déclarera pur celui qui a la plaie: il est pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Quand quelqu'un aura eu sur la peau de son corps un ulcère qui aura été guéri, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Et qu'à la place où était l'ulcère, il y aura une tumeur blanche, ou une tache blanche rougeâtre, cet homme se montrera au sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Le sacrificateur l'examinera. Si la tache paraît plus enfoncée que la peau, et que le poil soit devenu blanc, alors le sacrificateur le déclarera souillé; c'est une plaie de lèpre, qui a fait éruption dans l'ulcère. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Mais si le sacrificateur voit qu'il n'y a point de poil blanc dans la tache, et qu'elle n'est pas plus enfoncée que la peau, et qu'elle est devenue pâle, le sacrificateur enfermera cet homme pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Et si elle s'étend sur la peau, le sacrificateur le déclarera souillé: c'est une plaie de lèpre. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mais si la tache est restée à la même place, et ne s'est pas étendue, c'est une cicatrice d'ulcère; le sacrificateur le déclarera pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Lorsqu'un homme aura sur la peau une brûlure faite par le feu, et que la marque de la brûlure sera une tache d'un blanc rougeâtre ou blanche, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Le sacrificateur l'examinera; et si le poil est devenu blanc dans la tache, et que son apparence soit plus enfoncée que la peau, c'est la lèpre; elle a fait éruption dans la brûlure. Le sacrificateur déclarera cet homme souillé: c'est une plaie de lèpre. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Mais si le sacrificateur voit qu'il n'y a point de poil blanc dans la tache, qu'elle n'est pas plus enfoncée que la peau, et qu'elle est devenue pâle, le sacrificateur enfermera cet homme pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Le sacrificateur l'examinera au septième jour; si la tache s'est étendue sur la peau, le sacrificateur le déclarera souillé: c'est une plaie de lèpre. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mais si la tache est restée à la même place, ne s'est pas étendue sur la peau, et est devenue pâle, c'est la tumeur de la brûlure. Le sacrificateur le déclarera pur, car c'est la cicatrice de la brûlure. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Lorsqu'un homme ou une femme aura une plaie à la tête, ou à la barbe, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Le sacrificateur examinera la plaie. Si son apparence est plus profonde que la peau, et qu'elle contienne du poil jaunâtre et grêle, le sacrificateur le déclarera souillé: c'est de la teigne, c'est la lèpre de la tête ou de la barbe. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Mais si le sacrificateur, regardant la plaie de la teigne, voit que son apparence n'est pas plus profonde que la peau, et qu'il n'y a point de poil noir, le sacrificateur enfermera pendant sept jours celui qui a la plaie de la teigne. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Le septième jour le sacrificateur examinera la plaie. Si la teigne ne s'est pas étendue, s'il n'y a point de poil jaunâtre, et que l'apparence de la teigne ne soit pas plus profonde que la peau, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","L'homme se rasera, mais il ne rasera pas l'endroit de la teigne; et le sacrificateur enfermera une seconde fois, pendant sept jours, celui qui a la teigne. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Puis, le sacrificateur examinera la teigne au septième jour. Si la teigne ne s'est pas étendue sur la peau, et que son apparence ne soit pas plus profonde que la peau, le sacrificateur le déclarera pur; il lavera ses vêtements et il sera pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mais si la teigne s'est étendue sur la peau, après qu'il aura été déclaré pur, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Le sacrificateur l'examinera. Et si la teigne s'est étendue sur la peau, le sacrificateur ne cherchera point de poil jaunâtre: il est souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Mais si la teigne lui paraît s'être arrêtée, et qu'il y ait poussé du poil noir, la teigne est guérie: il est pur, et le sacrificateur le déclarera pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Lorsqu'un homme ou une femme aura sur la peau de son corps des taches, des taches blanches, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Le sacrificateur l'examinera. S'il y a sur la peau de son corps des taches d'un blanc pâle, c'est une tache blanche qui a fait éruption sur la peau: il est pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Lorsqu'un homme aura la tête dépouillée de cheveux, c'est un chauve: il est pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Et si sa tête est dépouillée de cheveux du côté de la face, c'est un front chauve: il est pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mais s'il y a dans la partie chauve de derrière ou de devant, une plaie d'un blanc rougeâtre, c'est une lèpre qui a fait éruption dans la partie chauve de derrière ou de devant. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Le sacrificateur l'examinera; et si la tumeur de la plaie est d'un blanc rougeâtre, dans la partie chauve de derrière ou de devant, semblable à la lèpre de la peau du corps, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Cet homme est lépreux, il est souillé; le sacrificateur le déclarera souillé; sa plaie est à la tête. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Or le lépreux qui sera atteint de la plaie aura ses vêtements déchirés, et la tête nue; il se couvrira la barbe et criera: Souillé! souillé! ");
INSERT INTO fra_fob_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Tout le temps qu'il aura la plaie, il sera souillé; il est souillé; il demeurera seul, son habitation sera hors du camp. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Quand il y aura une plaie de lèpre sur un vêtement, sur un vêtement de laine, ou sur un vêtement de lin, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Sur un feutre ou sur un tissu de lin ou de laine, sur une peau ou sur quelque ouvrage fait de peau, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Et que la plaie sera verdâtre ou rougeâtre sur le vêtement ou sur la peau, sur le feutre ou sur le tissu, ou sur un objet quelconque de peau, c'est une plaie de lèpre; elle sera montrée au sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Le sacrificateur examinera la plaie, et il en enfermera pendant sept jours ce qui a la plaie. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Et le septième jour il examinera la plaie. Si la plaie s'est étendue sur le vêtement, sur le feutre ou sur le tissu, sur la peau, ou sur l'ouvrage quelconque fait de peau, c'est une plaie de lèpre rongeante, l'objet est souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Il brûlera donc le vêtement, le feutre ou le tissu de laine ou de lin, ou tout objet fait de peau, sur lequel sera la plaie, car c'est une lèpre rongeante: il sera brûlé au feu. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Mais si le sacrificateur voit que la plaie ne s'est pas étendue sur le vêtement, sur le feutre ou sur le tissu, ou sur l'objet quelconque fait de peau, ");
INSERT INTO fra_fob_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Le sacrificateur commandera qu'on lave ce qui a la plaie, et il l'enfermera pendant sept jours, une seconde fois. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Et le sacrificateur examinera la plaie après qu'elle aura été lavée. Si la plaie n'a point changé d'aspect et ne s'est pas étendue, l'objet est souillé; tu le brûleras au feu; c'est une corrosion à l'envers ou à l'endroit de la partie dénudée. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mais si le sacrificateur voit que la plaie est devenue pâle après avoir été lavée, il l'arrachera du vêtement, ou de la peau, du feutre ou du tissu. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Si elle paraît encore sur le vêtement, sur le feutre ou sur le tissu, ou sur tout objet fait de peau, c'est une éruption de lèpre; tu brûleras au feu l'objet où est la plaie. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Mais le vêtement, le feutre ou le tissu, l'objet quelconque fait de peau, que tu auras lavé, et dont la plaie aura disparu, sera lavé une seconde fois, et il sera pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Telle est la loi concernant la plaie de la lèpre sur un vêtement de laine ou de lin, sur un feutre ou sur un tissu, ou sur un objet quelconque fait de peau, pour le déclarer pur ou souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","L'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Voici la loi touchant le lépreux, pour le jour de sa purification: on l'amènera au sacrificateur; ");
INSERT INTO fra_fob_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Le sacrificateur sortira du camp et l'examinera. Si la plaie de la lèpre du lépreux est guérie, ");
INSERT INTO fra_fob_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Le sacrificateur ordonnera de prendre pour celui qui doit être purifié, deux oiseaux vivants et purs, du bois de cèdre, du cramoisi et de l'hysope. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Et le sacrificateur commandera qu'on égorge l'un des oiseaux sur un vase de terre, sur de l'eau vive. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Quant à l'oiseau vivant, il le prendra, avec le bois de cèdre, le cramoisi et l'hysope, et il les trempera, avec l'oiseau vivant, dans le sang de l'oiseau égorgé sur l'eau vive; ");
INSERT INTO fra_fob_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Il en fera aspersion sept fois sur celui qui se purifie de la lèpre, il le déclarera pur, et il lâchera dans les champs l'oiseau vivant. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Et celui qui se purifie lavera ses vêtements, rasera tout son poil, se lavera dans l'eau et il sera pur. Ensuite il entrera dans le camp, mais il demeurera hors de sa tente pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Et au septième jour, il rasera tout son poil, sa tête, sa barbe, ses sourcils, il rasera tout son poil. Il lavera ses vêtements et baignera son corps dans l'eau, et il sera pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Le huitième jour, il prendra deux agneaux sans défaut, et une brebis de l'année sans défaut, trois dixièmes d'épha de fine farine en offrande, arrosée d'huile, et un log d'huile; ");
INSERT INTO fra_fob_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Et le sacrificateur qui fait la purification, présentera l'homme qui se purifie et ces choses devant l'Éternel, à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Ensuite le sacrificateur prendra l'un des agneaux, et l'offrira en sacrifice pour le délit, avec le log d'huile, et il les agitera en oblation devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Puis il égorgera l'agneau, au lieu où l'on égorge le sacrifice pour le péché et l'holocauste, dans le lieu saint; car le sacrifice pour le délit appartient au sacrificateur, comme le sacrifice pour le péché; c'est une chose très sainte. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Et le sacrificateur prendra du sang du sacrifice pour le délit; il en mettra sur le bout de l'oreille droite de celui qui se purifie, sur le pouce de sa main droite, et sur le gros orteil de son pied droit. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Le sacrificateur prendra du log d'huile et en versera dans sa main gauche; ");
INSERT INTO fra_fob_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Ensuite le sacrificateur trempera le doigt de sa main droite dans l'huile qui sera dans sa main gauche, et fera aspersion de l'huile avec son doigt sept fois devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Et du reste de l'huile qui sera dans sa main, le sacrificateur en mettra sur le bout de l'oreille droite de celui qui se purifie, sur le pouce de sa main droite, et sur le gros orteil de son pied droit, par-dessus le sang du sacrifice pour le délit. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ce qui restera de l'huile qui sera dans sa main, le sacrificateur le mettra sur la tête de celui qui se purifie; et le sacrificateur fera pour lui l'expiation devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Puis le sacrificateur offrira le sacrifice pour le péché, et fera l'expiation pour celui qui se purifie de sa souillure; ensuite il égorgera l'holocauste. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Le sacrificateur offrira l'holocauste et l'offrande sur l'autel; et il fera l'expiation pour cet homme, et il sera pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Mais s'il est pauvre et que ses moyens n'y suffisent pas, il prendra un agneau comme sacrifice pour le délit en offrande agitée pour faire l'expiation pour lui, et un dixième de fine farine arrosée d'huile pour l'offrande, et un log d'huile, ");
INSERT INTO fra_fob_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Et deux tourterelles ou deux pigeonneaux, selon ses moyens, l'un pour le sacrifice pour le péché, l'autre pour l'holocauste. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Il apportera ces choses le huitième jour au sacrificateur, pour sa purification, à l'entrée du tabernacle d'assignation, devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Le sacrificateur prendra l'agneau pour le sacrifice pour le délit, et le log d'huile; et le sacrificateur les agitera en offrande devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Puis il égorgera l'agneau du sacrifice pour le délit. Le sacrificateur prendra du sang du sacrifice pour le délit et en mettra sur le bout de l'oreille droite de celui qui se purifie, sur le pouce de sa main droite, et sur le gros orteil de son pied droit. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Ensuite le sacrificateur se versera de l'huile dans la paume de sa main gauche. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Et de l'huile qui sera dans sa main gauche, le sacrificateur fera aspersion avec le doigt de sa main droite, sept fois devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Et le sacrificateur mettra de l'huile qui sera dans sa main sur le bout de l'oreille droite de celui qui se purifie, sur le pouce de sa main droite, et sur le gros orteil de son pied droit, à l'endroit où il a mis du sang du sacrifice pour le délit. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ce qui restera de l'huile qui sera dans sa main, le sacrificateur le mettra sur la tête de celui qui se purifie, pour faire l'expiation pour lui, devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Puis, il sacrifiera l'une des tourterelles ou l'un des pigeonneaux, suivant ce qu'il pourra présenter, ");
INSERT INTO fra_fob_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Selon ses moyens, l'un en sacrifice pour le péché, l'autre en holocauste, avec l'offrande. Et le sacrificateur fera l'expiation devant l'Éternel pour celui qui se purifie. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Telle est la loi concernant celui qui a une plaie de lèpre, et dont les ressources sont insuffisantes quant à sa purification. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","L'Éternel parla encore à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Quand vous serez entrés au pays de Canaan, dont je vous donne la possession, si je mets une plaie de lèpre dans une maison du pays que vous posséderez, ");
INSERT INTO fra_fob_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Celui à qui la maison appartient viendra et le déclarera au sacrificateur, en disant: J'aperçois comme une plaie dans la maison. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Alors le sacrificateur commandera qu'on vide la maison, avant qu'il y entre pour voir la plaie, afin que tout ce qui est dans la maison ne soit pas souillé; après cela, le sacrificateur entrera pour voir la maison. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Et il examinera la plaie; et si la plaie qui est aux parois de la maison a des cavités verdâtres ou rougeâtres, paraissant plus enfoncées que la paroi, ");
INSERT INTO fra_fob_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Le sacrificateur sortira de la maison; et à la porte, il fermera la maison pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Le septième jour, le sacrificateur y retournera; et s'il voit que la plaie s'est étendue sur les parois de la maison, ");
INSERT INTO fra_fob_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Le sacrificateur commandera d'arracher les pierres infectées de la plaie, et de les jeter hors de la ville, dans un lieu souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Il fera racler la maison à l'intérieur, tout autour, et l'on jettera la poussière qu'on aura raclée, hors de la ville, dans un lieu souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","On prendra d'autres pierres et on les mettra à la place des premières, et l'on prendra d'autre enduit pour recrépir la maison. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Mais si la plaie revient et fait éruption dans la maison après qu'on aura arraché les pierres, après qu'on aura raclé la maison et après qu'on l'aura recrépie, ");
INSERT INTO fra_fob_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Le sacrificateur reviendra. S'il voit que la plaie s'est étendue dans la maison, c'est une lèpre rongeante dans la maison; elle est souillée. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","On abattra donc la maison, ses pierres, ses bois, et tous les enduits de la maison, et on transportera le tout hors de la ville, dans un lieu souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Celui qui sera entré dans la maison pendant tout le temps qu'elle était fermée sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Celui qui aura couché dans la maison, lavera ses vêtements. Celui qui aura mangé dans la maison, lavera ses vêtements. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Mais si le sacrificateur vient et voit que la plaie ne s'est pas étendue dans la maison, après que la maison a été recrépie, le sacrificateur déclarera la maison pure; car la plaie est guérie. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Il prendra, pour purifier la maison, deux oiseaux, du bois de cèdre, du cramoisi et de l'hysope; ");
INSERT INTO fra_fob_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Il égorgera l'un des oiseaux sur un vase de terre, sur de l'eau vive; ");
INSERT INTO fra_fob_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Il prendra le bois de cèdre, l'hysope, le cramoisi et l'oiseau vivant; il les trempera dans le sang de l'oiseau égorgé, et dans l'eau vive, et il en fera aspersion sur la maison, sept fois. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Il purifiera ainsi la maison avec le sang de l'oiseau, avec l'eau vive, avec l'oiseau vivant, le bois de cèdre, l'hysope et le cramoisi. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Puis il lâchera l'oiseau vivant hors de la ville dans les champs; et il fera l'expiation pour la maison, et elle sera pure. ");
INSERT INTO fra_fob_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Telle est la loi concernant toute plaie de lèpre et la teigne, ");
INSERT INTO fra_fob_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Pour la lèpre du vêtement et de la maison; ");
INSERT INTO fra_fob_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Pour la tumeur, l'éruption et les taches; ");
INSERT INTO fra_fob_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Afin d'enseigner quand il y a souillure, et quand il y a pureté. Telle est la loi concernant la lèpre. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","L'Éternel parla aussi à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Parlez aux enfants d'Israël, et dites-leur: Tout homme qui a un flux en sa chair, son flux le rend souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","C'est dans son flux que consiste sa souillure: que sa chair laisse couler son flux ou qu'elle le retienne, il est souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Tout lit sur lequel couchera celui qui est atteint d'un flux sera souillé, et tout objet sur lequel il s'assiéra sera souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Celui qui touchera son lit, lavera ses vêtements, se lavera dans l'eau, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Celui qui s'assiéra sur l'objet sur lequel celui qui est atteint d'un flux se sera assis, lavera ses vêtements, se lavera dans l'eau, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Celui qui touchera la chair d'un homme atteint d'un flux, lavera ses vêtements, se lavera dans l'eau, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Et si l'homme atteint d'un flux crache sur celui qui est pur, celui-ci lavera ses vêtements, se lavera dans l'eau, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Et tout char sur lequel celui qui est atteint d'un flux aura monté sera souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Quiconque touchera quoi que ce soit qui aura été sous lui, sera souillé jusqu'au soir. Et qui portera ces choses lavera ses vêtements, se lavera dans l'eau, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Quiconque sera touché par celui qui est atteint d'un flux, et qui ne se sera pas lavé les mains dans l'eau, lavera ses vêtements, se lavera dans l'eau, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Le vase de terre que celui qui est atteint d'un flux touchera sera brisé, et tout vase de bois sera lavé dans l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Or, quand celui qui est atteint d'un flux en sera purifié, il comptera sept jours pour sa purification; il lavera ses vêtements, lavera sa chair avec de l'eau vive, et il sera pur. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Et au huitième jour il prendra pour lui deux tourterelles ou deux pigeonneaux, et il viendra devant l'Éternel à l'entrée du tabernacle d'assignation, et il les donnera au sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Et le sacrificateur les offrira, l'un en sacrifice pour le péché, et l'autre en holocauste; et le sacrificateur fera l'expiation pour lui devant l'Éternel, à cause de son flux. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","L'homme qui aura une pollution lavera dans l'eau toute sa chair, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Et tout vêtement, et toute peau, qui en seront atteints, seront lavés dans l'eau, et seront souillés jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Et quand une femme et un homme coucheront et auront commerce ensemble, ils se laveront dans l'eau, et seront souillés jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Et quand une femme aura un flux, un flux de sang en sa chair, elle sera dans son impureté pendant sept jours; quiconque la touchera sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Tout objet sur lequel elle aura couché pendant son impureté sera souillé; et toute chose sur laquelle elle se sera assise sera souillée. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Quiconque touchera son lit lavera ses vêtements, se lavera dans l'eau, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Et quiconque touchera un objet quelconque sur lequel elle se sera assise lavera ses vêtements, se lavera dans l'eau, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Et s'il y a quelque chose sur le lit ou sur l'objet sur lequel elle s'est assise, celui qui y touchera sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Si un homme couche avec elle, et que son impureté le touche, il sera souillé sept jours, et tout lit sur lequel il couchera sera souillé. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Et quand une femme aura un flux de sang pendant plusieurs jours, hors du temps de son impureté, ou quand elle perdra au-delà du temps de son impureté, elle sera souillée tout le temps de son flux, comme au temps de son impureté. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Tout lit sur lequel elle couchera, pendant tout le temps de son flux, sera pour elle comme le lit de son impureté; et tout objet sur lequel elle s'assiéra sera souillé, comme pour la souillure de son impureté. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Et quiconque les touchera sera souillé; il lavera ses vêtements, se lavera dans l'eau, et sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Lorsqu'elle sera purifiée de son flux, elle comptera sept jours, et après elle sera pure. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Et au huitième jour, elle prendra deux tourterelles ou deux pigeonneaux, et les apportera au sacrificateur, à l'entrée du tabernacle d'assignation; ");
INSERT INTO fra_fob_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Le sacrificateur offrira l'un en sacrifice pour le péché, et l'autre en holocauste; et le sacrificateur fera pour elle l'expiation devant l'Éternel, à cause du flux qui la souillait. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Ainsi vous séparerez les enfants d'Israël de leur souillure, afin qu'ils ne meurent point à cause de leur souillure, en souillant ma Demeure qui est au milieu d'eux. ");
INSERT INTO fra_fob_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Telle est la loi concernant celui qui est atteint d'un flux ou qui est souillé par une pollution, ");
INSERT INTO fra_fob_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Et concernant celle qui est indisposée pour son impureté, et toute personne atteinte d'un flux, soit homme, soit femme, et l'homme qui couche avec une femme souillée. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","L'Éternel parla à Moïse, après la mort des deux fils d'Aaron, lorsqu'ils s'approchèrent devant l'Éternel et moururent; ");
INSERT INTO fra_fob_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","L'Éternel dit donc à Moïse: Parle à Aaron ton frère, afin qu'il n'entre point en tout temps dans le sanctuaire, au-dedans du voile, devant le propitiatoire qui est sur l'arche, de peur qu'il ne meure; car j'apparaîtrai dans la nuée sur le propitiatoire. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Voici avec quoi Aaron entrera dans le sanctuaire: avec un jeune taureau pour le sacrifice pour le péché, et un bélier pour l'holocauste. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Il se revêtira de la tunique sacrée de lin, et portera sur sa chair des caleçons de lin; il se ceindra d'une ceinture de lin, et il se couvrira la tête d'une tiare de lin; ce sont des vêtements sacrés; il lavera son corps dans l'eau, et s'en revêtira. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Et il prendra de l'assemblée des enfants d'Israël deux boucs pour le sacrifice pour le péché, et un bélier pour l'holocauste. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Puis Aaron offrira son taureau en sacrifice pour le péché, et il fera l'expiation pour lui et pour sa maison. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Et il prendra les deux boucs, et les placera devant l'Éternel, à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Puis Aaron jettera le sort sur les deux boucs; un sort pour l'Éternel, et un sort pour Azazel. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Et Aaron fera approcher le bouc sur lequel le sort sera tombé pour l'Éternel, et l'offrira en sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Mais le bouc sur lequel le sort sera tombé pour Azazel, sera placé vivant devant l'Éternel, afin de faire sur lui l'expiation, et de l'envoyer au désert pour Azazel. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaron offrira donc pour lui le taureau du sacrifice pour le péché, et il fera l'expiation pour lui et pour sa maison; il égorgera son taureau, qui est le sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Puis il prendra un encensoir plein de charbons ardents de dessus l'autel devant l'Éternel, et plein ses deux mains de parfum d'aromates en poudre, et il portera ces choses en dedans du voile; ");
INSERT INTO fra_fob_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Et il mettra le parfum sur le feu devant l'Éternel, afin que la nuée du parfum couvre le propitiatoire qui est sur le Témoignage, et il ne mourra point. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Il prendra aussi du sang du taureau, et en fera aspersion avec son doigt sur le devant du propitiatoire vers l'Orient; et devant le propitiatoire il fera aspersion du sang sept fois avec son doigt. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Puis il égorgera le bouc du sacrifice pour le péché, qui est pour le peuple, et il en portera le sang en dedans du voile. Il fera de son sang comme il a fait du sang du taureau, il en fera l'aspersion sur le propitiatoire et devant le propitiatoire. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Et il fera l'expiation pour le sanctuaire, à cause des souillures des enfants d'Israël, et de leurs rébellions en tous leurs péchés. Il fera de même pour le tabernacle d'assignation qui demeure avec eux au milieu de leurs souillures. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Et personne ne sera dans le tabernacle d'assignation quand il entrera pour faire l'expiation dans le sanctuaire, jusqu'à ce qu'il en sorte; et il fera l'expiation pour lui et pour sa maison, et pour toute l'assemblée d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Puis il sortira vers l'autel qui est devant l'Éternel, et fera l'expiation pour lui; il prendra du sang du taureau, et du sang du bouc, et il en mettra sur les cornes de l'autel, tout autour. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Et il fera aspersion du sang, avec son doigt, sept fois sur l'autel; il le purifiera et le sanctifiera, à cause des souillures des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Et quand il aura achevé de faire l'expiation pour le sanctuaire, pour le tabernacle d'assignation et pour l'autel, il offrira le bouc vivant. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaron appuiera ses deux mains sur la tête du bouc vivant, et confessera sur lui toutes les iniquités des enfants d'Israël, et toutes leurs rébellions en tous leurs péchés; il les mettra sur la tête du bouc, et l'enverra au désert par un homme exprès. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Et le bouc emportera sur lui toutes leurs iniquités dans une terre déserte, et l'homme lâchera le bouc dans le désert. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Et Aaron entrera dans le tabernacle d'assignation, et il quittera les vêtements de lin dont il s'était revêtu pour entrer dans le sanctuaire, et il les déposera là. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Puis il lavera son corps avec de l'eau dans un lieu saint, et reprendra ses vêtements; puis il sortira et offrira son holocauste et l'holocauste du peuple, et il fera l'expiation pour lui et pour le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Il fera aussi fumer sur l'autel la graisse du sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Et celui qui aura conduit le bouc pour Azazel, lavera ses vêtements, et lavera son corps dans l'eau; après cela, il rentrera au camp. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Mais on emportera hors du camp le taureau et le bouc offerts en sacrifice pour le péché, et dont le sang aura été porté dans le sanctuaire pour faire l'expiation, et l'on brûlera au feu leurs peaux, leur chair et leurs excréments. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Et celui qui les aura brûlés lavera ses vêtements, et lavera son corps dans l'eau; après cela, il rentrera au camp. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Et ceci sera pour vous une ordonnance perpétuelle: au septième mois, le dixième jour du mois, vous humilierez vos âmes, et vous ne ferez aucune œuvre, ni celui qui est du pays, ni l'étranger qui séjourne au milieu de vous; ");
INSERT INTO fra_fob_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Car en ce jour on fera l'expiation pour vous, afin de vous purifier; vous serez purifiés de tous vos péchés devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ce sera pour vous un sabbat, un jour de repos, et vous humilierez vos âmes; c'est une ordonnance perpétuelle. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Et le sacrificateur qu'on aura oint, et qu'on aura installé pour exercer la sacrificature à la place de son père, fera l'expiation; il se revêtira des vêtements de lin, des vêtements sacrés. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Et il fera l'expiation pour le saint sanctuaire, il fera l'expiation pour le tabernacle d'assignation, et pour l'autel; il fera l'expiation pour les sacrificateurs, et pour tout le peuple de l'assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ceci sera donc pour vous une ordonnance perpétuelle, afin qu'une fois l'an il soit fait, pour les enfants d'Israël, l'expiation à cause de tous leurs péchés. Et l'on fit comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Parle à Aaron et à ses fils, et à tous les enfants d'Israël, et dis-leur: Voici ce que l'Éternel a commandé: ");
INSERT INTO fra_fob_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Quiconque de la maison d'Israël égorge un bœuf, un agneau, ou une chèvre, dans le camp, ou hors du camp, ");
INSERT INTO fra_fob_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Et ne l'amène pas à l'entrée du tabernacle d'assignation, pour l'offrir à l'Éternel, devant la Demeure de l'Éternel, le sang sera imputé à cet homme; il a répandu le sang; cet homme-là sera retranché du milieu de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","C'est afin que les enfants d'Israël amènent leurs sacrifices qu'ils immolent dans les champs, qu'ils les amènent au sacrificateur devant l'Éternel, à l'entrée du tabernacle d'assignation, et qu'ils les offrent en sacrifices de prospérités à l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Et que le sacrificateur en répande le sang sur l'autel de l'Éternel, à l'entrée du tabernacle d'assignation, et fasse fumer la graisse en agréable odeur à l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Et qu'ils n'offrent plus leurs sacrifices aux démons, avec lesquels ils se prostituent. Ceci leur sera une ordonnance perpétuelle dans leurs générations. ");
INSERT INTO fra_fob_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Tu leur diras donc: Quiconque des enfants d'Israël ou des étrangers qui séjournent parmi eux, offrira un holocauste ou un sacrifice, ");
INSERT INTO fra_fob_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Et ne l'amènera pas à l'entrée du tabernacle d'assignation pour le sacrifier à l'Éternel, cet homme-là sera retranché d'entre ses peuples. ");
INSERT INTO fra_fob_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Quiconque de la maison d'Israël, ou des étrangers séjournant parmi eux, mangera de quelque sang que ce soit, je tournerai ma face contre celui qui aura mangé le sang, et je le retrancherai du milieu de son peuple; ");
INSERT INTO fra_fob_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Car l'âme de la chair est dans le sang; je vous l'ai donné sur l'autel, pour faire l'expiation pour vos âmes; car c'est pour l'âme que le sang fait l'expiation. ");
INSERT INTO fra_fob_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","C'est pourquoi j'ai dit aux enfants d'Israël: Personne d'entre vous ne mangera du sang, et l'étranger qui séjourne parmi vous, ne mangera pas de sang. ");
INSERT INTO fra_fob_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Et si quelqu'un des enfants d'Israël, ou des étrangers séjournant parmi eux, prend à la chasse un animal ou un oiseau qui se mange, il en répandra le sang, et le couvrira de poussière; ");
INSERT INTO fra_fob_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Car, quant à l'âme de toute chair, c'est son sang; il lui tient lieu d'âme. C'est pourquoi j'ai dit aux enfants d'Israël: Vous ne mangerez le sang d'aucune chair; car l'âme de toute chair est son sang; quiconque en mangera, sera retranché. ");
INSERT INTO fra_fob_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Et toute personne, née au pays ou étrangère, qui mangera d'une bête morte ou déchirée, lavera ses vêtements, se lavera dans l'eau, et sera souillée jusqu'au soir; puis elle sera pure. ");
INSERT INTO fra_fob_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Mais si elle ne lave pas ses vêtements et ne lave pas son corps, elle portera son iniquité. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Parle aux enfants d'Israël, et dis-leur: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Vous ne ferez point ce qui se fait dans le pays d'Égypte, où vous avez habité, ni ce qui se fait au pays de Canaan où je vous mène: vous ne marcherez point selon leurs lois. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Vous pratiquerez mes ordonnances, et vous garderez mes lois pour les suivre: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Vous garderez donc mes lois et mes ordonnances; l'homme qui les pratiquera vivra par elles: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nul de vous ne s'approchera de sa proche parente, pour découvrir sa nudité: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Tu ne découvriras point la nudité de ton père, ni la nudité de ta mère; c'est ta mère: tu ne découvriras point sa nudité. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Tu ne découvriras point la nudité de la femme de ton père; c'est la nudité de ton père. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Tu ne découvriras point la nudité de ta sœur, fille de ton père ou fille de ta mère, née dans la maison ou née hors de la maison. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Tu ne découvriras point la nudité de la fille de ton fils ou de la fille de ta fille, car c'est ta nudité. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Tu ne découvriras point la nudité de la fille de la femme de ton père, née de ton père; c'est ta sœur. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Tu ne découvriras point la nudité de la sœur de ton père; elle est la chair de ton père. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Tu ne découvriras point la nudité de la sœur de ta mère; car elle est la chair de ta mère. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Tu ne découvriras point la nudité du frère de ton père, tu ne t'approcheras point de sa femme; c'est ta tante. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Tu ne découvriras point la nudité de ta belle-fille; c'est la femme de ton fils; tu ne découvriras point sa nudité. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Tu ne découvriras point la nudité de la femme de ton frère; c'est la nudité de ton frère. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Tu ne découvriras point la nudité d'une femme et de sa fille; tu ne prendras point la fille de son fils, ni la fille de sa fille, pour découvrir leur nudité; elles sont tes proches parentes; c'est un crime. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Tu ne prendras point une femme avec sa sœur, pour exciter une rivalité, en découvrant sa nudité à côté de ta femme pendant sa vie. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Tu ne t'approcheras pas d'une femme pendant son impureté pour découvrir sa nudité. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Tu n'auras point commerce avec la femme de ton prochain, pour te souiller avec elle. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Tu ne donneras point de tes enfants pour les faire passer par le feu à Moloc; et tu ne profaneras point le nom de ton Dieu: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Tu ne coucheras point avec un homme, comme on couche avec une femme; c'est une abomination. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Tu n'auras commerce avec aucune bête pour te souiller avec elle; une femme ne se prostituera point à une bête; c'est une abomination. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ne vous souillez par aucune de ces choses; car c'est par toutes ces choses que se sont souillées les nations que je vais chasser de devant vous. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","La terre en a été souillée; et je punirai sur elle son iniquité, et la terre vomira ses habitants. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Mais vous, vous garderez mes lois et mes ordonnances, et vous ne ferez aucune de ces abominations, ni celui qui est né au pays, ni l'étranger qui séjourne au milieu de vous. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Car toutes ces abominations, les hommes du pays, qui y ont été avant vous, les ont faites et la terre en a été souillée. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Et la terre ne vous vomira pas, pour l'avoir souillée, comme elle a vomi la nation qui y était avant vous. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Car tous ceux qui feront quelqu'une de toutes ces abominations, seront retranchés du milieu de leur peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Vous observerez donc ce que j'ordonne, afin de ne pratiquer aucune des coutumes abominables qui ont été pratiquées avant vous, et vous ne vous souillerez point par elles. Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Parle à toute l'assemblée des enfants d'Israël, et dis-leur: Soyez saints, car je suis saint, moi, l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Que chacun révère sa mère et son père, et observez mes sabbats: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ne vous tournez point vers les idoles, et ne vous faites point de dieux de fonte: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Quand vous sacrifierez un sacrifice de prospérités à l'Éternel, vous le sacrifierez de manière à être agréés. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","On le mangera au jour du sacrifice, et le lendemain; ce qui restera jusqu'au troisième jour sera brûlé au feu. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Si on en mange le troisième jour, c'est une abomination, il ne sera point agréé. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Celui qui en mangera portera son iniquité; car il aura profané ce qui est consacré à l'Éternel: cette personne-là sera retranchée de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Et quand vous ferez la moisson dans votre pays, tu n'achèveras point de moissonner le bout de ton champ, et tu ne ramasseras point la glanure de ta moisson; ");
INSERT INTO fra_fob_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Tu ne grappilleras point ta vigne, et tu n'en recueilleras pas les grains tombés; tu les laisseras au pauvre et à l'étranger: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Vous ne déroberez point, et vous ne mentirez point, ni ne vous tromperez les uns les autres. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Vous ne jurerez point faussement par mon nom; car tu profanerais le nom de ton Dieu: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Tu n'opprimeras point ton prochain, et tu ne le pilleras point. Le salaire du mercenaire ne demeurera point chez toi jusqu'au lendemain. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Tu ne maudiras point un sourd, et tu ne mettras devant un aveugle rien qui puisse le faire tomber; mais tu craindras ton Dieu: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Vous ne ferez point d'iniquité dans le jugement; tu ne favoriseras point le pauvre, et n'honoreras point la personne du grand; tu jugeras ton prochain selon la justice. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Tu ne répandras point de calomnies parmi ton peuple; tu ne t'élèveras point contre le sang de ton prochain: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Tu ne haïras point ton frère dans ton cœur. Tu reprendras ton prochain, et tu ne te chargeras pas d'un péché à cause de lui. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Tu ne te vengeras point, et tu ne garderas point de ressentiment contre les enfants de ton peuple; mais tu aimeras ton prochain comme toi-même: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Vous garderez mes ordonnances. Tu n'accoupleras point des bêtes de différentes espèces. Tu ne sèmeras point ton champ de diverses sortes de graines, et tu ne mettras point sur toi un vêtement de diverses sortes de fils, un tissu mélangé. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Si un homme couche et a commerce avec une femme, et que ce soit une servante, promise à un homme, mais qui n'a pas été rachetée, ou à qui la liberté n'a point été donnée, ils seront châtiés; ils ne seront pas mis à mort, car elle n'était pas affranchie. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Et l'homme amènera à l'Éternel son sacrifice pour le délit, à l'entrée du tabernacle d'assignation, un bélier en sacrifice pour le délit. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Et le sacrificateur fera l'expiation pour lui, avec le bélier du sacrifice pour le délit, devant l'Éternel, pour le péché qu'il a commis; et le péché qu'il a commis lui sera pardonné. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Et quand vous serez entrés au pays, et que vous aurez planté toutes sortes d'arbres fruitiers, vous considérerez leurs premiers fruits comme incirconcis; ils vous seront incirconcis pendant trois ans; on n'en mangera point; ");
INSERT INTO fra_fob_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Mais la quatrième année, tous leurs fruits seront consacrés en sacrifices de louanges à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Et la cinquième année, vous en mangerez le fruit, afin qu'il vous multiplie son produit: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Vous ne mangerez rien avec le sang. Vous n'userez point de divinations et ne pratiquerez point de magie. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Vous ne couperez point en rond les coins de votre chevelure, et tu ne détruiras point les coins de ta barbe. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Vous ne ferez point d'incision dans votre chair pour un mort, et vous n'imprimerez point de caractères sur vous: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ne profane point ta fille en la prostituant; afin que le pays ne se prostitue pas et ne se remplisse pas de crimes. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Vous observerez mes sabbats, et vous révérerez mon sanctuaire: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ne vous adressez point à ceux qui évoquent les esprits, ni aux devins; ne les consultez pas pour vous souiller avec eux: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Lève-toi devant les cheveux blancs, honore la personne du vieillard, et crains ton Dieu: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Quand un étranger séjournera parmi vous, dans votre pays, vous ne l'opprimerez pas. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","L'étranger qui séjourne parmi vous, vous sera comme celui qui est né parmi vous, et tu l'aimeras comme toi-même; car vous avez été étrangers dans le pays d'Égypte: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Vous ne commettrez point d'iniquité dans le jugement, ni dans la mesure, ni dans le poids, ni dans la contenance. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Vous aurez des balances justes, des pierres à peser justes, un épha juste, et un hin juste: Je suis l'Éternel, votre Dieu, qui vous ai fait sortir du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Vous garderez donc toutes mes lois et toutes mes ordonnances, et vous les pratiquerez: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Tu diras aux enfants d'Israël: Quiconque des enfants d'Israël, ou des étrangers séjournant en Israël, donnera de ses enfants à Moloc, sera puni de mort: le peuple du pays le lapidera. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Et moi, je tournerai ma face contre cet homme, et je le retrancherai du milieu de son peuple, parce qu'il aura livré ses enfants à Moloc, pour souiller mon sanctuaire et profaner le nom de ma sainteté. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Et si le peuple du pays ferme les yeux sur cet homme, quand il donnera de ses enfants à Moloc, et ne le fait pas mourir, ");
INSERT INTO fra_fob_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Moi, je tournerai ma face contre cet homme et contre sa famille, et je le retrancherai du milieu de son peuple avec tous ceux qui se prostituent à son exemple, en se prostituant à Moloc. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Si quelqu'un se tourne vers ceux qui évoquent les esprits et vers les devins, pour se prostituer après eux, je tournerai ma face contre cette personne, et je la retrancherai du milieu de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Vous vous sanctifierez et vous serez saints; car je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Vous observerez mes lois et vous les pratiquerez: Je suis l'Éternel qui vous sanctifie. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Quand un homme quelconque maudira son père ou sa mère, il sera puni de mort; il a maudit son père ou sa mère; son sang sera sur lui. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Si un homme commet adultère avec la femme d'un autre, s'il commet adultère avec la femme de son prochain, l'homme et la femme adultères seront punis de mort. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Si un homme couche avec la femme de son père, il découvre la nudité de son père; ils seront tous deux punis de mort; leur sang sera sur eux. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Si un homme couche avec sa belle-fille, ils seront tous deux punis de mort; ils ont commis une abomination; leur sang sera sur eux. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Si un homme couche avec un homme, comme on couche avec une femme, ils ont fait tous deux une chose abominable; ils seront punis de mort; leur sang sera sur eux. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Si un homme prend une femme et sa mère, c'est un crime; on les brûlera au feu, lui et elles, afin que ce crime n'existe pas parmi vous. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Si un homme a commerce avec une bête, il sera puni de mort; et vous tuerez la bête. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Si une femme s'approche de quelque bête pour se prostituer à elle, tu tueras la femme et la bête; elles seront mises à mort; leur sang sera sur elles. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Si un homme prend sa sœur, fille de son père ou fille de sa mère, s'il voit sa nudité, et qu'elle voie la sienne, c'est une infamie; ils seront retranchés sous les yeux des enfants de leur peuple; il a découvert la nudité de sa sœur; il portera son iniquité. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Si un homme couche avec une femme pendant son indisposition, et découvre sa nudité, s'il met à nu la source de son sang et qu'elle découvre elle-même la source de son sang, ils seront tous deux retranchés du milieu de leur peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Tu ne découvriras point la nudité de la sœur de ta mère, ni de la sœur de ton père; car c'est découvrir sa proche parente; ils porteront leur iniquité. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Si un homme couche avec sa tante, il découvre la nudité de son oncle; ils porteront la peine de leur péché, ils mourront sans enfants. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Si un homme prend la femme de son frère, c'est une impureté; il a découvert la nudité de son frère, ils seront sans enfants. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Vous observerez toutes mes lois et toutes mes ordonnances, et vous les pratiquerez; afin que le pays où je vous mène pour y habiter ne vous vomisse point. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Vous ne marcherez point selon les lois de la nation que je vais chasser de devant vous; car ils ont fait toutes ces choses, et je les ai en abomination. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Et je vous ai dit: C'est vous qui posséderez leur pays; je vous le donnerai pour le posséder, c'est un pays où coulent le lait et le miel: Je suis l'Éternel, votre Dieu, qui vous ai séparés des peuples. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Séparez donc la bête pure de celle qui est souillée, l'oiseau souillé de celui qui est pur; et ne rendez pas vos personnes abominables par des animaux, par des oiseaux, par tout ce qui rampe sur la terre, que je vous ai fait séparer comme impurs. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Vous serez saints pour moi, car je suis saint, moi, l'Éternel; et je vous ai séparés des peuples, afin que vous soyez à moi. ");
INSERT INTO fra_fob_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Lorsqu'il se trouvera un homme ou une femme évoquant les esprits ou se livrant à la divination, ils seront punis de mort; on les lapidera: leur sang sera sur eux. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","L'Éternel dit encore à Moïse: Parle aux sacrificateurs, fils d'Aaron, et dis-leur: Un sacrificateur ne se rendra pas impur parmi son peuple pour un mort, ");
INSERT INTO fra_fob_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Excepté pour son proche parent, qui le touche de près, pour sa mère, pour son père, pour son fils, pour sa fille, et pour son frère, ");
INSERT INTO fra_fob_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Et pour sa sœur vierge qui le touche de près, et qui n'a point de mari; il se rendra impur pour elle. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Chef parmi son peuple, il ne se rendra point impur pour se profaner. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Les sacrificateurs ne se feront point de place chauve sur la tête; ils ne raseront pas les coins de leur barbe, et ils ne feront point d'incision dans leur chair. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ils seront consacrés à leur Dieu, et ne profaneront point le nom de leur Dieu; car ils offrent à l'Éternel les sacrifices faits par le feu, l'aliment de leur Dieu: ils seront saints. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ils ne prendront point une femme prostituée ou déshonorée; ils ne prendront point une femme répudiée par son mari; car ils sont consacrés à leur Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Tu regarderas donc le sacrificateur comme saint, car il offre le pain de ton Dieu; il te sera saint, car je suis saint, moi, l'Éternel, qui vous sanctifie. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Si une fille de sacrificateur se déshonore en se prostituant, elle déshonore son père; elle sera brûlée au feu. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Le sacrificateur qui a la prééminence sur ses frères, sur la tête duquel l'huile de l'onction a été répandue, qui a été installé pour se revêtir de vêtements sacrés, ne découvrira pas sa tête et ne déchirera pas ses vêtements. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Il n'ira vers aucun mort; il ne se rendra point impur ni pour son père, ni pour sa mère. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Il ne sortira point du sanctuaire, et ne profanera point le sanctuaire de son Dieu, car la consécration de l'huile de l'onction de son Dieu est sur lui: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Il prendra pour femme une vierge. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Il ne prendra ni une veuve, ni une répudiée, ni une femme déshonorée ou prostituée; mais il prendra pour femme une vierge d'entre ses peuples. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Il ne déshonorera point sa race parmi son peuple; car je suis l'Éternel, qui le sanctifie. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Parle à Aaron, et dis-lui: L'homme de ta race, dans vos générations, qui aura un défaut corporel, ne s'approchera point pour offrir le pain de son Dieu; ");
INSERT INTO fra_fob_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Car tout homme qui aura un défaut n'approchera pas: un homme aveugle, ou boiteux, ou camus, ou qui aura quelque membre disproportionné; ");
INSERT INTO fra_fob_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Ou un homme qui aura une fracture au pied ou à la main; ");
INSERT INTO fra_fob_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Ou qui sera bossu ou grêlé, ou qui aura une tache à l'œil, ou qui aura la gale ou une dartre ou les testicules écrasés. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Tout homme, de la postérité d'Aaron le sacrificateur, qui aura un défaut, ne s'approchera point pour offrir les sacrifices faits par le feu à l'Éternel; il y a un défaut en lui; il ne s'approchera point pour offrir le pain de son Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Il pourra bien manger le pain de son Dieu, des choses très saintes, et des choses consacrées; ");
INSERT INTO fra_fob_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Mais il n'ira point vers le voile, et ne s'approchera point de l'autel, car il y a un défaut en lui; il ne profanera point mes sanctuaires, car je suis l'Éternel qui les sanctifie. ");
INSERT INTO fra_fob_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Moïse parla ainsi à Aaron et à ses fils, et à tous les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","L'Éternel parla encore à Moise, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Parle à Aaron et à ses fils afin qu'ils s'abstiennent des choses saintes des enfants d'Israël, et qu'ils ne profanent point le nom de ma sainteté dans les choses qu'ils me consacrent: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Dis-leur: Tout homme, dans toute votre postérité et vos générations, qui, étant souillé, s'approchera des choses saintes que les enfants d'Israël auront consacrées à l'Éternel, cet homme-là sera retranché de devant moi: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Quiconque de la postérité d'Aaron sera lépreux ou aura un flux, ne mangera point des choses consacrées jusqu'à ce qu'il soit purifié. De même celui qui aura touché une personne souillée par le contact d'un cadavre, ou l'homme qui aura une perte séminale; ");
INSERT INTO fra_fob_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Ou celui qui aura touché quelque reptile qui l'ait rendu souillé, ou un homme qui l'ait rendu souillé, quelle que soit cette souillure. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Celui qui touchera ces choses sera souillé jusqu'au soir; il ne mangera point des choses consacrées, mais il lavera son corps dans l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Et après le coucher du soleil il sera pur, et ensuite il pourra manger des choses saintes, car c'est sa nourriture. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Il ne mangera point d'une bête morte d'elle-même, ou déchirée, afin de ne pas en être souillé: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Qu'ils observent donc ce que j'ai ordonné, de peur qu'ils ne portent leur péché, et qu'ils ne meurent pour avoir profané les choses saintes: Je suis l'Éternel qui les sanctifie. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Or nul étranger ne mangera des choses consacrées; celui qui demeure chez un sacrificateur, et le mercenaire, ne mangeront point des choses saintes. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mais la personne que le sacrificateur aura achetée de son argent, en mangera; de même que celui qui sera né dans sa maison; ceux-là mangeront de sa nourriture. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Si une fille de sacrificateur est mariée à un étranger, elle ne mangera point des choses consacrées, offertes par élévation. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mais si une fille de sacrificateur, étant veuve, ou répudiée, et sans enfants, retourne à la maison de son père, comme dans sa jeunesse, elle mangera de la nourriture de son père; mais nul étranger n'en mangera. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Si quelqu'un mange par erreur d'une chose consacrée, il y ajoutera un cinquième, et donnera au sacrificateur la chose consacrée. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Les sacrificateurs ne profaneront point les choses consacrées des enfants d'Israël, ce qu'ils offrent par élévation à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Ils leur feraient porter l'iniquité de leur culpabilité en mangeant ainsi leurs choses consacrées; car je suis l'Éternel, qui les sanctifie. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Parle à Aaron et à ses fils, et à tous les enfants d'Israël, et dis-leur: Quiconque de la maison d'Israël, ou des étrangers en Israël, offrira son offrande, soit pour un vœu, soit comme offrande volontaire qu'on offre en holocauste à l'Éternel, pour que vous soyez agréés, ");
INSERT INTO fra_fob_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Qu'il offre un mâle sans défaut, d'entre le gros bétail, les agneaux ou les chèvres. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Vous n'offrirez rien qui ait un défaut; car ce ne serait point agréé pour vous. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Et quand un homme offrira à l'Éternel un sacrifice de prospérités, de gros ou de menu bétail, pour s'acquitter d'un vœu, ou en offrande volontaire, pour être agréée la victime sera sans défaut; qu'il n'y ait en elle aucun défaut. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Vous n'en offrirez point à l'Éternel qui soit aveugle, ou estropiée, ou mutilée, ou affectée d'ulcères, de la gale ou d'une dartre; et vous n'en ferez point sur l'autel un sacrifice par le feu, à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Tu pourras sacrifier comme offrande volontaire un bœuf ou un agneau ayant quelque membre trop long ou trop court; mais il ne sera point agréé pour un vœu. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Vous n'offrirez point à l'Éternel, et vous ne sacrifierez point dans votre pays un animal dont les testicules ont été froissés, écrasés, arrachés ou coupés. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Vous n'accepterez de la main d'un étranger aucune de ces victimes pour l'offrir comme aliment de votre Dieu; car leur mutilation est un défaut en elles; elles ne seront point agréées en votre faveur. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Quand un veau, un agneau ou un chevreau naîtra, il sera sept jours avec sa mère; et à partir du huitième jour et les suivants, il sera agréé en offrande de sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Soit gros soit menu bétail, vous n'égorgerez pas un animal et son petit le même jour. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Et quand vous offrirez un sacrifice d'actions de grâces à l'Éternel, vous le sacrifierez de manière qu'il soit agréé en votre faveur. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Il sera mangé le jour même, vous n'en laisserez rien jusqu'au matin: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Gardez donc mes commandements, et accomplissez-les: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Et ne profanez point mon saint nom, et je serai sanctifié au milieu des enfants d'Israël: Je suis l'Éternel, qui vous sanctifie, ");
INSERT INTO fra_fob_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Qui vous ai fait sortir du pays d'Égypte pour être votre Dieu. Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Parle aux enfants d'Israël, et dis-leur: Les fêtes de l'Éternel, que vous publierez comme de saintes convocations, ce sont là mes fêtes. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","On travaillera six jours; mais le septième jour est le sabbat, le jour du repos; il y aura une sainte convocation; vous ne ferez aucune œuvre; c'est le sabbat de l'Éternel dans toutes vos demeures. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Voici les fêtes de l'Éternel, les saintes convocations, que vous publierez à leurs temps fixés. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Le premier mois, le quatorzième jour du mois, entre les deux soirs, sera la Pâque de l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Et le quinzième jour de ce mois, sera la fête des pains sans levain à l'Éternel; vous mangerez des pains sans levain pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Le premier jour vous aurez une sainte convocation; vous ne ferez aucune œuvre servile. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Vous offrirez à l'Éternel, pendant sept jours, des sacrifices faits par le feu. Le septième jour il y aura une sainte convocation; vous ne ferez aucune œuvre servile. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Parle aux enfants d'Israël, et dis-leur: Quand vous serez entrés au pays que je vous donne, et que vous en ferez la moisson, vous apporterez au sacrificateur une gerbe, prémices de votre moisson. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Et il agitera la gerbe devant l'Éternel, afin qu'elle soit agréée pour vous; le sacrificateur l'agitera le lendemain du sabbat. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Vous sacrifierez aussi, le jour où vous agiterez la gerbe, un agneau d'un an, sans défaut, en holocauste à l'Éternel; ");
INSERT INTO fra_fob_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Et son offrande sera de deux dixièmes de fine farine arrosée d'huile, en sacrifice fait par le feu, d'agréable odeur à l'Éternel, et sa libation sera du vin, le quart d'un hin. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Vous ne mangerez ni pain, ni grain rôti, ni grain en épi, jusqu'à ce même jour-là, jusqu'à ce que vous ayez apporté l'offrande à votre Dieu; c'est une ordonnance perpétuelle pour vos générations, dans toutes vos demeures. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Vous compterez aussi, à partir du lendemain du sabbat, dès le jour où vous aurez apporté la gerbe qui doit être agitée, sept semaines entières. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Vous compterez cinquante jours jusqu'au lendemain du septième sabbat; et vous offrirez une nouvelle offrande à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Vous apporterez de vos demeures deux pains, pour une offrande agitée; ils seront de deux dixièmes de fleur de farine, cuits avec du levain: ce sont les prémices à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Vous offrirez aussi avec le pain, sept agneaux d'un an sans défaut, et un jeune taureau, et deux béliers, qui seront en holocauste à l'Éternel, avec leur offrande et leurs libations, en sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Vous offrirez aussi un bouc pour le péché, et deux agneaux d'un an en sacrifice de prospérités. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Et le sacrificateur les agitera avec le pain des prémices, en offrande agitée devant l'Éternel, avec les deux agneaux; ils seront consacrés à l'Éternel, pour le sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Vous publierez la fête ce jour même; vous aurez une sainte convocation; vous ne ferez aucune œuvre servile. C'est une ordonnance perpétuelle dans toutes vos demeures, d'âge en âge. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Et quand vous ferez la moisson dans votre pays, tu n'achèveras point de moissonner le bout de ton champ, et tu ne ramasseras point les restes de ta moisson; tu les laisseras pour le pauvre et pour l'étranger: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Parle aux enfants d'Israël, et dis: Au septième mois, au premier jour du mois, il y aura pour vous un jour de repos, une commémoration publiée au son des trompettes, une sainte convocation; ");
INSERT INTO fra_fob_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Vous ne ferez aucune œuvre servile; et vous offrirez à l'Éternel des sacrifices faits par le feu. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Le dixième jour de ce septième mois sera le jour des expiations; vous aurez une sainte convocation, vous humilierez vos âmes, et vous offrirez à l'Éternel des sacrifices faits par le feu. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Vous ne ferez aucune œuvre ce jour-là; car c'est le jour des expiations, où doit être faite pour vous l'expiation devant l'Éternel votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Car toute personne qui ne s'humiliera pas ce jour-là, sera retranchée du milieu de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Et toute personne qui fera ce jour-là une œuvre quelconque, je la détruirai du milieu de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Vous ne ferez aucune œuvre; c'est une ordonnance perpétuelle pour vos générations, dans toutes vos demeures. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ce sera pour vous un sabbat, un jour de repos, et vous humilierez vos âmes. Le neuvième jour du mois, au soir, d'un soir à l'autre soir, vous célébrerez votre sabbat. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Parle aux enfants d'Israël, et dis: Le quinzième jour de ce septième mois, ce sera la fête des tabernacles pendant sept jours, à l'honneur de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Le premier jour il y aura une sainte convocation; vous ne ferez aucune œuvre servile. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Pendant sept jours vous offrirez à l'Éternel des sacrifices faits par le feu. Le huitième jour vous aurez une sainte convocation, et vous offrirez à l'Éternel des sacrifices faits par le feu; ce sera une assemblée solennelle; vous ne ferez aucune œuvre servile. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Telles sont les fêtes solennelles de l'Éternel, que vous publierez comme de saintes convocations, pour offrir à l'Éternel des sacrifices faits par le feu, des holocaustes, des offrandes, des sacrifices et des libations, chaque chose à son jour; ");
INSERT INTO fra_fob_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Outre les sabbats de l'Éternel, et outre vos dons, et outre tous vos vœux, et outre toutes vos offrandes volontaires que vous présenterez à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Mais le quinzième jour du septième mois, quand vous aurez recueilli le produit de la terre, vous célébrerez une fête à l'Éternel pendant sept jours. Le premier jour sera un jour de repos, et le huitième sera aussi un jour de repos. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Et le premier jour vous prendrez du fruit des beaux arbres, des branches de palmiers, des rameaux d'arbres touffus et des saules de rivière; et vous vous réjouirez pendant sept jours devant l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Vous célébrerez ainsi cette fête à l'Éternel pendant sept jours dans l'année. C'est une ordonnance perpétuelle pour vos générations; vous la célébrerez le septième mois. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Vous demeurerez pendant sept jours sous des tentes; tous ceux qui seront nés en Israël demeureront sous des tentes, ");
INSERT INTO fra_fob_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Afin que votre postérité sache que j'ai fait habiter les enfants d'Israël sous des tentes, lorsque je les ai fait sortir du pays d'Égypte: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ainsi Moïse déclara aux enfants d'Israël les fêtes de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Ordonne aux enfants d'Israël qu'ils t'apportent de l'huile pure, d'olives broyées, pour le luminaire, afin de tenir les lampes continuellement allumées. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aaron les arrangera, en dehors du voile du Témoignage, dans le tabernacle d'assignation, afin qu'elles brûlent du soir au matin, devant l'Éternel, continuellement; c'est une ordonnance perpétuelle dans vos générations. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Il arrangera les lampes sur le chandelier d'or pur, devant l'Éternel, continuellement. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Tu prendras aussi de la fleur de farine, et tu la cuiras en douze gâteaux; chaque gâteau sera de deux dixièmes; ");
INSERT INTO fra_fob_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Et tu les placeras en deux rangées, six par rangée, sur la table d'or pur devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Et tu mettras de l'encens pur sur chaque rangée, et il sera un mémorial pour le pain, comme un sacrifice fait par le feu à l'Éternel: ");
INSERT INTO fra_fob_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chaque jour de sabbat on rangera ces pains devant l'Éternel continuellement de la part des enfants d'Israël; c'est une alliance perpétuelle. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Et ils appartiendront à Aaron et à ses fils, qui les mangeront dans un lieu saint; car ce sera pour eux une chose très sainte, provenant des sacrifices de l'Éternel faits par le feu; c'est une ordonnance perpétuelle. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Or, le fils d'une femme israélite, qui était fils d'un homme égyptien, sortit au milieu des enfants d'Israël; et ce fils d'une femme israélite se querella dans le camp avec un homme israélite. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Et le fils de la femme israélite blasphéma le nom de l'Éternel, et le maudit; et on l'amena à Moïse. Or sa mère s'appelait Shelomith, fille de Dibri, de la tribu de Dan. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Et on le mit en prison, jusqu'à ce qu'il y eût décision, selon l'ordre de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Or l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Fais sortir du camp celui qui a maudit, et que tous ceux qui l'ont entendu posent leurs mains sur sa tête, et toute l'assemblée le lapidera. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Et parle aux enfants d'Israël, et dis-leur: Quiconque maudira son Dieu portera la peine de son péché; ");
INSERT INTO fra_fob_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Et celui qui blasphémera le nom de l'Éternel sera puni de mort; toute l'assemblée le lapidera; aussi bien l'étranger que celui qui est né au pays, quand il blasphémera le nom de l'Éternel, il sera mis à mort. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Celui qui frappera mortellement un homme, quel qu'il soit, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Celui qui frappera une bête mortellement, la remplacera; vie pour vie. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Et quand un homme aura fait une blessure à son prochain, on lui fera comme il a fait; ");
INSERT INTO fra_fob_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Fracture pour fracture, œil pour œil, dent pour dent; il lui sera fait le même mal qu'il aura fait à un autre homme. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Celui qui aura tué une bête, la remplacera; mais celui qui aura tué un homme, sera mis à mort. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Vous n'aurez qu'une même loi; l'étranger sera comme celui qui est né au pays; car je suis l'Éternel votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moïse parla donc aux enfants d'Israël, et ils firent sortir du camp celui qui avait maudit, et ils le lapidèrent. Ainsi les enfants d'Israël firent comme l'Éternel avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","L'Éternel parla aussi à Moïse sur la montagne de Sinaï, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Parle aux enfants d'Israël, et dis-leur: Quand vous serez entrés au pays que je vous donne, la terre se reposera; ce sera un sabbat à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Pendant six ans tu sèmeras ton champ, et pendant six ans tu tailleras ta vigne, et tu en recueilleras le produit. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Mais la septième année sera un sabbat de repos pour la terre, un sabbat à l'Éternel; tu ne sèmeras point ton champ, et tu ne tailleras point ta vigne, ");
INSERT INTO fra_fob_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Tu ne moissonneras point ce qui de ta moisson repoussera de soi-même, et tu ne vendangeras point les raisins de ta vigne non taillée; ce sera une année de repos pour la terre. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Mais ce que la terre produira l'année du sabbat, vous servira de nourriture, à toi, à ton serviteur, à ta servante, à ton mercenaire et à l'étranger qui séjourne avec toi, ");
INSERT INTO fra_fob_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","A ton bétail, et aux animaux qui sont dans ton pays; tout son produit servira de nourriture. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Tu compteras aussi sept semaines d'années, sept fois sept ans; et les jours de ces sept semaines d'années feront quarante-neuf ans; ");
INSERT INTO fra_fob_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Puis tu feras sonner la trompette d'un son éclatant, le dixième jour du septième mois; au jour des expiations, vous ferez sonner la trompette par tout votre pays. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Et vous sanctifierez la cinquantième année, et vous publierez la liberté dans le pays pour tous ses habitants. Ce sera pour vous le jubilé, et vous rentrerez chacun de vous dans sa possession et vous retournerez chacun dans sa famille. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","La cinquantième année sera pour vous le jubilé; vous ne sèmerez point, et ne moissonnerez point ce que la terre rapportera d'elle-même, et vous ne vendangerez point la vigne non taillée; ");
INSERT INTO fra_fob_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Car c'est le jubilé: il vous sera sacré; vous mangerez le produit des champs. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","En cette année du jubilé, chacun de vous retournera dans sa possession. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Or, si vous faites une vente à votre prochain, ou si vous achetez quelque chose de votre prochain, que nul de vous ne fasse tort à son frère. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Tu achèteras de ton prochain d'après le nombre des années écoulées depuis le jubilé; et il te vendra d'après le nombre des années de rapport. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Selon qu'il y aura plus d'années, tu augmenteras le prix, et selon qu'il y aura moins d'années, tu diminueras le prix; car c'est le nombre des récoltes qu'il te vend. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Que nul de vous ne fasse tort à son prochain; mais crains ton Dieu; car je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Exécutez mes ordonnances, observez mes lois et pratiquez-les; et vous habiterez en sécurité dans le pays. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Et la terre vous donnera ses fruits, vous mangerez à satiété, et vous y habiterez en sécurité. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Si vous dites: Que mangerons-nous la septième année, si nous ne semons point, et si nous ne recueillons pas notre récolte? ");
INSERT INTO fra_fob_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Je vous enverrai ma bénédiction la sixième année, et elle donnera une récolte pour les trois ans. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Et vous sèmerez la huitième année, et vous mangerez de l'ancienne récolte; jusqu'à la neuvième année, jusqu'à ce que sa récolte soit venue, vous mangerez de l'ancienne. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","La terre ne sera point vendue à perpétuité; car la terre est à moi, car vous êtes chez moi comme étrangers et comme habitants. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Dans tout le pays que vous posséderez, vous accorderez le droit de rachat pour la terre. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Si ton frère devient pauvre, et vend une partie de ce qu'il possède, celui qui a le droit de rachat, son proche parent, viendra et rachètera ce que son frère a vendu. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Si un homme n'a personne qui ait le droit de rachat, et qu'il se procure lui-même de quoi faire un rachat, ");
INSERT INTO fra_fob_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Il comptera les années depuis la vente faite et restituera le surplus à l'homme à qui il a vendu, et il rentrera dans sa possession. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Mais s'il ne trouve point ce qu'il faut pour le lui rendre, la chose vendue sera entre les mains de celui qui aura acheté, jusqu'à l'année du jubilé; alors celui-ci en sortira au jubilé, et le vendeur rentrera dans sa possession. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Si un homme vend une maison d'habitation, dans une ville fermée de murailles, il aura le droit de la racheter jusqu'à la fin de l'année après la vente; son droit de rachat sera d'une année. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Mais si elle n'est point rachetée avant la fin d'une année entière, la maison qui est dans la ville fermée de murailles demeurera à perpétuité à l'acquéreur et à ses descendants, il n'en sortira point au jubilé. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Toutefois les maisons des villages non entourés de murs, seront réputées comme un fonds de terre; le vendeur pourra les racheter, et l'acheteur sortira au jubilé. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Quant aux villes des Lévites et aux maisons des villes qu'ils auront en propriété, le droit de rachat sera perpétuel pour les Lévites. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Et celui qui aura acheté des Lévites, sortira au jubilé de la maison vendue et de la ville de sa possession; car les maisons des villes des Lévites sont leur possession parmi les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Les champs des faubourgs de leurs villes ne seront point vendus; car c'est leur propriété perpétuelle. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Si ton frère, qui est près de toi, devient pauvre et que sa main devienne tremblante, tu le soutiendras, étranger ou hôte, afin qu'il vive auprès de toi. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Tu ne tireras de lui ni intérêt ni profit; mais tu craindras ton Dieu, et ton frère vivra auprès de toi. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Tu ne lui donneras point ton argent à intérêt, et tu ne lui donneras point de tes vivres pour un profit. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Je suis l'Éternel, votre Dieu, qui vous ai fait sortir du pays d'Égypte, pour vous donner le pays de Canaan, pour être votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Si ton frère, qui est près de toi, devient pauvre et se vend à toi, tu ne te serviras point de lui pour un service d'esclave; ");
INSERT INTO fra_fob_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Il sera chez toi comme un mercenaire, comme un hôte; il servira chez toi jusqu'à l'année du jubilé; ");
INSERT INTO fra_fob_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Alors il sortira de chez toi, lui et ses enfants avec lui; il retournera dans sa famille, et rentrera dans la possession de ses pères. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Car ce sont mes serviteurs, que j'ai fait sortir du pays d'Égypte; ils ne seront point vendus comme on vend un esclave. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Tu ne domineras point sur lui avec rigueur; mais tu craindras ton Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Quant à ton esclave et à ta servante qui t'appartiendront, ils viendront des nations qui sont autour de vous; c'est d'elles que vous achèterez l'esclave et la servante. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Vous pourrez aussi en acheter des enfants des étrangers qui séjourneront avec vous, et de leurs familles qui seront parmi vous, qu'ils engendreront dans votre pays; et ils seront votre propriété. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Vous les laisserez en héritage à vos enfants après vous, pour les posséder en propriété; vous vous servirez d'eux à perpétuité; mais quant à vos frères, les enfants d'Israël, nul de vous ne dominera avec rigueur sur son frère. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Et lorsque un étranger ou un homme habitant chez toi, deviendra riche, et que ton frère deviendra pauvre près de lui et se vendra à l'étranger domicilié chez toi, ou à un rejeton de la famille de l'étranger, ");
INSERT INTO fra_fob_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Après s'être vendu, il y aura droit de rachat pour lui: un de ses frères pourra le racheter; ");
INSERT INTO fra_fob_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Ou son oncle, ou le fils de son oncle, pourra le racheter, ou l'un de ses proches parents de sa famille pourra le racheter; ou s'il en a les moyens, il se rachètera lui-même. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Or il comptera avec celui qui l'a acheté, depuis l'année où il s'est vendu à lui jusqu'à l'année du jubilé, et son prix de vente se comptera d'après le nombre des années; il en sera avec lui comme des journées d'un mercenaire. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","S'il y a encore beaucoup d'années, il paiera son rachat à raison de ces années, en proportion du prix pour lequel il aura été acheté; ");
INSERT INTO fra_fob_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Et s'il reste peu d'années jusqu'à l'an du jubilé, il comptera avec lui, et restituera le prix de son achat à raison de ces années. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Il sera avec lui comme un mercenaire à l'année; et son maître ne dominera point sur lui avec rigueur sous tes y eux. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","S'il n'est racheté d'aucune de ces manières, il sortira l'année du jubilé, lui et ses fils avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Car c'est de moi que les enfants d'Israël sont esclaves; ce sont mes esclaves, que j'ai fait sortir du pays d'Égypte: Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Vous ne vous ferez point d'idoles, et vous ne vous dresserez ni image taillée, ni statue, et vous ne mettrez pas de pierre ornée de figures dans votre pays, pour vous prosterner devant elle; car je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Vous observerez mes sabbats, et vous révérerez mon sanctuaire: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Si vous marchez dans mes statuts, si vous gardez mes commandements, et si vous les pratiquez, ");
INSERT INTO fra_fob_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Je vous donnerai les pluies dans leur saison; la terre donnera ses produits, et les arbres des champs donneront leurs fruits. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Le foulage des grains atteindra chez vous la vendange; et la vendange atteindra les semailles; vous mangerez votre pain à satiété, et vous habiterez en sécurité dans votre pays. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Je mettrai la paix dans le pays; vous dormirez sans que personne vous épouvante; je ferai disparaître du pays les mauvaises bêtes, et l'épée ne passera point par votre pays. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mais vous poursuivrez vos ennemis, et ils tomberont devant vous par l'épée. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinq d'entre vous en poursuivront cent, et cent d'entre vous en poursuivront dix mille, et vos ennemis tomberont devant vous par l'épée. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Et je me tournerai vers vous, je vous ferai croître et multiplier, et j'établirai mon alliance avec vous. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Vous mangerez aussi des anciennes récoltes, et vous sortirez les vieilles pour loger les nouvelles. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Et je mettrai ma demeure au milieu de vous, et mon âme ne vous aura point en aversion. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Et je marcherai au milieu de vous; je serai votre Dieu, et vous serez mon peuple. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Je suis l'Éternel, votre Dieu qui vous ai fait sortir du pays d'Égypte, afin que vous n'y fussiez plus esclaves. J'ai brisé les barres de votre joug, et je vous ai fait marcher la tête levée. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Mais si vous ne m'écoutez pas, et si vous ne pratiquez pas tous ces commandements, ");
INSERT INTO fra_fob_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Si vous méprisez mes ordonnances, et si votre âme a mes lois en aversion, pour ne pas pratiquer tous mes commandements, et pour enfreindre mon alliance, ");
INSERT INTO fra_fob_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Voici alors ce que je vous ferai: Je ferai venir sur vous la terreur, la consomption et la fièvre, qui consumeront vos yeux et accableront votre âme; vous sèmerez en vain votre semence: vos ennemis la mangeront. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Et je tournerai ma face contre vous; vous serez battus devant vos ennemis; ceux qui vous haïssent domineront sur vous, et vous fuirez sans que personne vous poursuive. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Que si, malgré cela, vous ne m'écoutez pas, j'en ajouterai sept fois autant pour vous châtier, à cause de vos péchés; ");
INSERT INTO fra_fob_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Et je briserai l'orgueil de votre force. Je rendrai votre ciel comme du fer, et votre terre comme de l'airain. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Votre force se consumera en vain; votre terre ne donnera pas ses produits, et les arbres de la terre ne donneront pas leurs fruits. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Que si vous marchez en opposition avec moi, et si vous ne voulez pas m'écouter, je vous frapperai sept fois plus, selon vos péchés. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","J'enverrai contre vous les animaux des champs, qui vous priveront de vos enfants, qui détruiront votre bétail, et qui vous réduiront à un petit nombre; et vos chemins seront déserts. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Si, malgré ces choses, vous ne recevez pas ma correction, et que vous marchiez en opposition avec moi, ");
INSERT INTO fra_fob_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Je marcherai, moi aussi, en opposition avec vous, et je vous frapperai sept fois plus, à cause de vos péchés. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Et je ferai venir sur vous l'épée, qui vengera mon alliance; quand vous vous rassemblerez dans vos villes, j'enverrai la peste au milieu de vous, et vous serez livrés aux mains de l'ennemi. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Quand je vous briserai le bâton du pain, dix femmes cuiront votre pain dans un seul four, et vous rendront votre pain au poids; vous mangerez, et vous ne serez point rassasiés. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Et si, malgré cela, vous ne m'écoutez point, et que vous marchiez contre moi, ");
INSERT INTO fra_fob_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Je marcherai aussi contre vous avec fureur, et je vous châtierai sept fois plus, à cause de vos péchés; ");
INSERT INTO fra_fob_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Vous mangerez la chair de vos fils, et vous mangerez la chair de vos filles; ");
INSERT INTO fra_fob_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Je détruirai vos hauts lieux, et j'abattrai vos colonnes solaires, et je mettrai vos cadavres sur les cadavres de vos idoles, et mon âme vous aura en aversion. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Je réduirai aussi vos villes en déserts, je désolerai vos sanctuaires, et je ne respirerai plus l'agréable odeur de vos sacrifices. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Et je désolerai le pays tellement que vos ennemis qui y habiteront en seront étonnés. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Et je vous disperserai parmi les nations, et je tirerai l'épée après vous; et votre pays sera désolé, et vos villes désertes. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Alors la terre s'acquittera de ses sabbats, tout le temps qu'elle sera désolée, et que vous serez dans le pays de vos ennemis; alors la terre se reposera et s'acquittera de ses sabbats. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Tout le temps qu'elle sera désolée, elle se reposera, parce qu'elle ne s'était pas reposée dans vos sabbats, pendant que vous l'habitiez. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Quant à ceux d'entre vous qui survivront, je rendrai leur cœur lâche dans les pays de leurs ennemis; le bruit d'une feuille agitée les poursuivra; ils fuiront comme on fuit devant l'épée, et ils tomberont sans qu'on les poursuive; ");
INSERT INTO fra_fob_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Et ils trébucheront l'un sur l'autre comme devant l'épée, sans que personne les poursuive; et vous ne pourrez subsister devant vos ennemis. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Vous périrez parmi les nations, et la terre de vos ennemis vous dévorera. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Et ceux d'entre vous qui survivront, se consumeront à cause de leur iniquité, dans les pays de vos ennemis, et aussi à cause des iniquités de leurs pères, ils se consumeront comme eux. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Alors ils confesseront leur iniquité et l'iniquité de leurs pères selon les transgressions qu'ils auront commises contre moi, et aussi parce qu'ils auront marché en opposition avec moi. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Moi aussi je leur résisterai, et les mènerai dans le pays de leurs ennemis, et alors leur cœur incirconcis s'humiliera, et ils subiront la peine de leur iniquité. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Alors je me souviendrai de mon alliance avec Jacob, je me souviendrai de mon alliance avec Isaac, et de mon alliance avec Abraham, et je me souviendrai de ce pays. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Car le pays sera abandonné par eux, et il jouira de ses sabbats, tant qu'il sera dévasté loin d'eux; et ils subiront la peine de leur iniquité, parce qu'ils auront méprisé mes ordonnances et que leur âme a eu mes lois en aversion. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Malgré cela, lorsqu'ils seront dans le pays de leurs ennemis, je ne les rejetterai point, et je ne les aurai point en aversion, pour les consumer entièrement et pour rompre mon alliance avec eux; car je suis l'Éternel, leur Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Et je me souviendrai en leur faveur de l'alliance faite avec leurs ancêtres, que j'ai fait sortir du pays d'Égypte, aux yeux des nations, pour être leur Dieu: Je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Tels sont les statuts, les ordonnances et les lois que l'Éternel établit entre lui et les enfants d'Israël, sur la montagne de Sinaï, par Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","L'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Parle aux enfants d'Israël, et dis-leur: Lorsque quelqu'un consacre un vœu, s'il s'agit de personnes, elles appartiendront à l'Éternel, d'après ton estimation. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Telle sera ton estimation: si c'est un homme de vingt à soixante ans, ton estimation sera de cinquante sicles d'argent, selon le sicle du sanctuaire. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Si c'est une femme, ton estimation sera de trente sicles. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Si c'est quelqu'un de l'âge de cinq ans jusqu'à l'âge de vingt ans, ton estimation sera de vingt sicles pour le mâle, et de dix sicles pour la femme. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Et si c'est quelqu'un de l'âge d'un mois jusqu'à l'âge de cinq ans, ton estimation sera de cinq sicles d'argent pour le mâle, et de trois sicles d'argent pour une fille. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Et si c'est quelqu'un qui soit âgé de soixante ans et au-dessus, si c'est un mâle, ton estimation sera de quinze sicles, et pour la femme de dix sicles. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Si celui qui a fait le vœu est trop pauvre pour payer ton estimation, on le présentera devant le sacrificateur, qui fixera son prix; le sacrificateur fixera un prix selon les moyens de celui qui a fait le vœu. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","S'il s'agit d'animaux dont on fait offrande à l'Éternel, tout ce qu'on en donnera à l'Éternel, sera chose sacrée. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","On ne le changera point, et on ne le remplacera point, un bon pour un mauvais, ou un mauvais pour un bon. Si l'on remplace un animal par un autre, celui-ci ainsi que l'animal mis à sa place, seront choses sacrées. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Et s'il s'agit de quelque animal impur, dont on ne fait point offrande à l'Éternel, on présentera l'animal devant le sacrificateur; ");
INSERT INTO fra_fob_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Et le sacrificateur en fera l'estimation, selon que l'animal sera bon ou mauvais. Il en sera selon ton estimation, sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Mais si on veut le racheter, on ajoutera un cinquième à ton estimation. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Et quand quelqu'un consacrera à l'Éternel sa maison pour être sacrée, le sacrificateur en fera l'estimation selon qu'elle sera bonne ou mauvaise; on s'en tiendra à l'estimation que le sacrificateur en aura faite. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Mais si celui qui a consacré sa maison veut la racheter, il ajoutera un cinquième au prix de ton estimation, et elle lui appartiendra. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Et si quelqu'un consacre à l'Éternel une partie du champ de sa propriété, ton estimation sera selon ce qu'on y sème; le homer de semence d'orge à cinquante sicles d'argent. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","S'il consacre son champ dès l'année du jubilé, on s'en tiendra à ton estimation. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Mais s'il consacre son champ après le jubilé, le sacrificateur en estimera le prix à raison des années qui restent jusqu'à l'année du jubilé, et il sera fait une réduction sur ton estimation. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Et si celui qui a consacré son champ, veut le racheter, il ajoutera un cinquième au prix de ton estimation, et le champ lui restera. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Mais s'il ne rachète point le champ, et qu'on vende le champ à un autre homme, il ne pourra plus être racheté. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Et ce champ, quand l'acquéreur en sortira au jubilé, sera consacré à l'Éternel comme un champ d'interdit: la possession en sera au sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Si quelqu'un consacre à l'Éternel un champ qu'il ait acheté et qui ne soit pas des champs de sa possession, ");
INSERT INTO fra_fob_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Le sacrificateur en évaluera le prix d'après ton estimation jusqu'à l'année du jubilé, et cet homme paiera, le jour même, ton estimation, comme une chose consacrée à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","En l'année du jubilé, le champ retournera à celui duquel il l'avait acheté, à celui à qui appartient la propriété de la terre. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Et toutes tes estimations seront, d'après le sicle du sanctuaire; le sicle est de vingt oboles. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Toutefois, nul ne consacrera le premier-né de son bétail, lequel appartient déjà à l'Éternel comme primogéniture; soit bœuf, soit agneau, il est à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Mais s'il s'agit d'un animal impur, on le rachètera selon ton estimation, en y ajoutant un cinquième; s'il n'est pas racheté, il sera vendu d'après ton estimation. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Mais tout interdit, tout ce que quelqu'un aura dévoué à l'Éternel, de ce qui lui appartient, tout, soit un homme, un animal ou un champ de sa propriété, ne pourra ni se vendre ni se racheter; tout interdit est entièrement consacré à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Aucune personne dévouée par interdit ne pourra être rachetée; elle sera mise à mort. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Toute dîme de la terre, tant des semences de la terre que des fruits des arbres, appartient à l'Éternel; c'est une chose consacrée à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Et si quelqu'un veut racheter quelque chose de sa dîme, il y ajoutera le cinquième en sus. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Mais pour toute dîme de gros et de menu bétail, pour tout ce qui passe sous la verge, le dixième en sera consacré à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","On ne distinguera pas entre le bon et le mauvais, et on ne le changera pas; si on le change, l'animal remplacé et celui qui le remplace seront l'un et l'autre consacrés: ils ne pourront être rachetés. ");
INSERT INTO fra_fob_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Tels sont les commandements que l'Éternel prescrivit à Moïse pour les enfants d'Israël, sur la montagne de Sinaï. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","L'Éternel parla à Moïse, au désert de Sinaï, dans le tabernacle d'assignation, au premier jour du second mois, la seconde année de leur sortie du pays d'Égypte, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Faites le compte de toute l'assemblée des enfants d'Israël, selon leurs familles, selon les maisons de leurs pères, en comptant par tête les noms de tous les mâles, ");
INSERT INTO fra_fob_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Depuis l'âge de vingt ans et au-dessus, tous ceux d'Israël qui peuvent aller à la guerre; vous les dénombrerez selon leurs armées, toi et Aaron. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Et il y aura avec vous un homme par tribu, le chef de la maison de ses pères. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Et voici les noms des hommes qui vous assisteront: Pour la tribu de Ruben, Elitsur, fils de Shedéur; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Pour celle de Siméon, Shelumiel, fils de Tsurishaddaï; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Pour celle de Juda, Nahasshon, fils d'Amminadab; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Pour celle d'Issacar, Nathanaël, fils de Tsuar; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Pour celle de Zabulon, Eliab, fils de Hélon; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Pour les enfants de Joseph, pour la tribu d'Éphraïm, Elishama, fils d'Ammihud; pour celle de Manassé, Gamaliel, fils de Pédahtsur; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Pour la tribu de Benjamin, Abidan, fils de Guideoni; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Pour celle de Dan, Ahiézer, fils d'Ammishaddaï; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Pour celle d'Asser, Paguiel, fils d'Ocran; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Pour celle de Gad, Eliasaph, fils de Déhuël; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Pour celle de Nephthali, Ahira, fils d'Enan. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","C'étaient là ceux qu'on appelait pour tenir l'assemblée, les princes des tribus de leurs pères, les chefs des milliers d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moïse et Aaron prirent donc ces hommes qui avaient été désignés par leurs noms; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Et ils convoquèrent toute l'assemblée, le premier jour du second mois, et on les enregistra d'après leurs familles, selon la maison de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, et par têtes; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Comme l'Éternel l'avait commandé à Moïse, il les dénombra au désert de Sinaï. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Les fils de Ruben, premier-né d'Israël, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms et par tête, tous les mâles depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ceux de la tribu de Ruben, qui furent dénombrés, furent quarante-six mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Les fils de Siméon, enregistrés selon leurs familles, selon les maisons de leurs pères, ceux qui furent dénombrés, en les comptant par leurs noms et par tête, tous les mâles depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ceux de la tribu de Siméon, qui furent dénombrés, furent cinquante-neuf mille trois cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Les fils de Gad, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Ceux de la tribu de Gad, qui furent dénombrés, furent quarante-cinq mille six cent cinquante. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Les fils de Juda, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ceux de la tribu de Juda, qui furent dénombrés, furent soixante-quatorze mille six cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Les fils d'Issacar, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ceux de la tribu d'Issacar, qui furent dénombrés, furent cinquante-quatre mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Les fils de Zabulon, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ceux de la tribu de Zabulon, qui furent dénombrés, furent cinquante-sept mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Quant aux fils de Joseph: les fils d'Éphraïm, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ceux de la tribu d'Éphraïm, qui furent dénombrés, furent quarante mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Les fils de Manassé, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ceux de la tribu de Manassé, qui furent dénombrés, furent trente-deux mille deux cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Les fils de Benjamin, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ceux de la tribu de Benjamin, qui furent dénombrés, furent trente-cinq mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Les fils de Dan, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ceux de la tribu de Dan, qui furent dénombrés, furent soixante-deux mille sept cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Les fils d'Asser, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ceux de la tribu d'Asser, qui furent dénombrés, furent quarante et un mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Les fils de Nephthali, enregistrés selon leurs familles, selon les maisons de leurs pères, en les comptant par leurs noms, depuis l'âge de vingt ans et au-dessus, tous ceux qui pouvaient aller à la guerre: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ceux de la tribu de Nephthali, qui furent dénombrés, furent cinquante-trois mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Tel est le dénombrement que firent Moïse et Aaron, et les douze princes d'Israël; il y avait un homme pour chaque maison des pères. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Ainsi tous ceux des enfants d'Israël qui furent dénombrés, selon les maisons de leurs pères, depuis l'âge de vingt ans et au-dessus, tous les Israélites qui pouvaient aller à la guerre, ");
INSERT INTO fra_fob_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Tous ceux qui furent dénombrés, furent six cent trois mille cinq cent cinquante. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Mais les Lévites, selon la tribu de leurs pères, ne furent point dénombrés avec eux. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Car l'Éternel avait parlé à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Tu ne dénombreras point la tribu de Lévi seulement, et tu n'en feras point le compte au milieu des enfants d'Israël; ");
INSERT INTO fra_fob_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Mais donne aux Lévites la charge de la Demeure du Témoignage, et de tous ses ustensiles, et de tout ce qui lui appartient. Ce sont eux qui porteront la Demeure et tous ses ustensiles, et qui en feront le service; et ils camperont autour de la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Et quand la Demeure partira, les Lévites la démonteront; et quand la Demeure campera, les Lévites la dresseront; et l'étranger qui en approchera sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Or, les enfants d'Israël camperont chacun dans son camp, et chacun près de sa bannière, selon leurs armées. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mais les Lévites camperont autour de la Demeure du Témoignage, afin qu'il n'y ait point d'indignation contre l'assemblée des enfants d'Israël; et les Lévites auront la garde de la Demeure du Témoignage. ");
INSERT INTO fra_fob_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Et les enfants d'Israël firent tout ce que l'Éternel avait commandé à Moïse; ils firent ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","L'Éternel parla aussi à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Les enfants d'Israël camperont chacun sous sa bannière, près des enseignes des maisons de leurs pères; ils camperont vis-à-vis et tout autour du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ceux qui camperont en avant, vers l'Orient, ce sera la bannière du camp de Juda, selon ses armées, et le chef des enfants de Juda, Nahasshon, fils d'Amminadab, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Et son armée, ses dénombrés: soixante-quatorze mille six cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Et la tribu d'Issacar campera auprès de lui; et le chef des enfants d'Issacar, Nathanaël, fils de Tsuar, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Et son armée, ses dénombrés: cinquante-quatre mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Puis la tribu de Zabulon, et le chef des enfants de Zabulon, Eliab, fils de Hélon, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Et son armée, ses dénombrés: cinquante-sept mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Tous les hommes dénombrés pour le camp de Juda sont cent quatre-vingt-six mille quatre cents, selon leurs armées. Ils partiront les premiers. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","La bannière du camp de Ruben, selon ses armées, sera vers le Midi, avec le chef des enfants de Ruben, Elitsur, fils de Shedéur, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Et son armée, et ses dénombrés: quarante-six mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Et la tribu de Siméon campera auprès de lui, et le chef des enfants de Siméon, Shelumiel, fils de Tsurishaddaï, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Et son armée, ses dénombrés: cinquante-neuf mille trois cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Puis la tribu de Gad, et le chef des enfants de Gad, Eliasaph, fils de Réhuel, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Et son armée, ses dénombrés: quarante-cinq mille six cent cinquante. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Tous les hommes dénombrés pour le camp de Ruben sont cent cinquante et un mille quatre cent cinquante, selon leurs armées. Ils partiront les seconds. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ensuite partira le tabernacle d'assignation, le camp des Lévites, au milieu des autres camps; ils partiront, comme ils auront campé, chacun à son rang, selon leurs bannières. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","La bannière du camp d'Éphraïm, selon ses armées, sera vers l'Occident, avec le chef des enfants d'Éphraïm, Elishama, fils d'Ammihud, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Et son armée, ses dénombrés: quarante mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Et auprès de lui, la tribu de Manassé, et le chef des enfants de Manassé, Gamaliel, fils de Pedahtsur, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Et son armée, ses dénombrés: trente-deux mille deux cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Puis la tribu de Benjamin, et le chef des enfants de Benjamin, Abidan, fils de Guideoni, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Et son armée, ses dénombrés: trente-cinq mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Tous les hommes dénombrés pour le camp d'Éphraïm sont cent huit mille et cent, selon leurs armées. Ils partiront les troisièmes. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","La bannière du camp de Dan sera vers le Nord, selon ses armées, avec le chef des enfants de Dan, Ahiézer, fils d'Ammishaddaï, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Et son armée, ses dénombrés: soixante-deux mille sept cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Et la tribu d'Asser campera auprès de lui, et le chef des enfants d'Asser, Paguiel, fils d'Ocran, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Et son armée, ses dénombrés: quarante et un mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Puis la tribu de Nephthali, et le chef des enfants de Nephthali, Ahira, fils d'Enan, ");
INSERT INTO fra_fob_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Et son armée, ses dénombrés: cinquante-trois mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Tous les hommes dénombrés pour le camp de Dan sont cent cinquante-sept mille six cents. Ils partiront les derniers, selon leurs bannières. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Ce sont là ceux des enfants d'Israël, dont on fit le dénombrement, selon les maisons de leurs pères. Tous les hommes dénombrés, formant les camps, selon leurs armées, furent six cent trois mille cinq cent cinquante. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Mais les Lévites ne furent point dénombrés au milieu des enfants d'Israël, d'après l'ordre que l'Éternel avait donné à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Et les enfants d'Israël firent selon tout ce que l'Éternel avait commandé à Moïse; ils campèrent ainsi, selon leurs bannières, et partirent ainsi, chacun selon sa famille, selon la maison de ses pères. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Voici les descendants d'Aaron et de Moïse, au jour où l'Éternel parla à Moïse au mont Sinaï; ");
INSERT INTO fra_fob_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Voici les noms des fils d'Aaron: Nadab, le premier-né, Abihu, Éléazar et Ithamar. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ce sont là les noms des fils d'Aaron, des sacrificateurs qui furent oints, qu'on institua pour exercer le sacerdoce. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Or, Nadab et Abihu moururent devant l'Éternel, lorsqu'ils offrirent un feu étranger devant l'Éternel, au désert de Sinaï. Et ils n'avaient point d'enfants. Mais Éléazar et Ithamar exercèrent la sacrificature, en présence d'Aaron, leur père. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Alors l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Fais approcher la tribu de Lévi, et fais-la tenir devant Aaron, le sacrificateur, afin qu'ils le servent; ");
INSERT INTO fra_fob_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Et qu'ils soignent tout ce qui est commis à ses soins et aux soins de toute l'assemblée, devant le tabernacle d'assignation, en faisant le service de la Demeure; ");
INSERT INTO fra_fob_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Et qu'ils soignent tous les ustensiles du tabernacle d'assignation, et ce qui leur sera confié par les enfants d'Israël, pour faire le service de la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Ainsi tu donneras les Lévites à Aaron et à ses fils; ils lui sont complètement donnés d'entre les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Tu établiras donc Aaron et ses fils, afin qu'ils gardent leur sacerdoce; et l'étranger qui en approchera sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Voici, j'ai pris les Lévites, d'entre les enfants d'Israël, à la place de tous les premiers-nés des enfants d'Israël, et les Lévites seront à moi. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Car tout premier-né m'appartient; au jour où je frappai tout premier-né dans le pays d'Égypte, je me suis consacré tout premier-né en Israël, depuis les hommes jusqu'aux bêtes; ils seront à moi: je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","L'Éternel parla aussi à Moïse, au désert de Sinaï, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Dénombre les enfants de Lévi, selon les maisons de leurs pères, selon leurs familles, en comptant tous les mâles depuis l'âge d'un mois et au-dessus. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Et Moïse les dénombra, selon le commandement de l'Éternel, ainsi qu'il lui avait été ordonné. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Voici quels sont les fils de Lévi, par leurs noms: Guershon, Kéhath et Mérari. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Et voici les noms des fils de Guershon, selon leurs familles: Libni et Shimeï. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Et les fils de Kéhath, selon leurs familles: Amram, Jitshar, Hébron et Uziel. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Et les fils de Mérari, selon leurs familles: Machli et Mushi. Telles sont les familles de Lévi, selon les maisons de leurs pères. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","A Guershon appartient la famille des Libnites, et la famille des Simhites. Telles sont les familles des Guershonites. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ceux d'entre eux qui furent dénombrés, en comptant tous les mâles, depuis l'âge d'un mois et au-dessus, étaient sept mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Les familles des Guershonites campaient derrière la Demeure, vers l'Occident; ");
INSERT INTO fra_fob_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Et le chef de la maison des pères des Guershonites était Eliasaph, fils de Laël. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Et la charge des enfants de Guershon, quant au tabernacle d'assignation, était la Demeure et le tabernacle, sa couverture, et la tapisserie de l'entrée du tabernacle d'assignation, ");
INSERT INTO fra_fob_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Et les tentures du parvis, et la tapisserie de l'entrée du parvis, qui couvrent la Demeure et l'autel tout autour, et ses cordages pour tout son service. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","A Kéhath appartient la famille des Amramites, la famille des Jitseharites, la famille des Hébronites, et la famille des Uziélites. Telles sont les familles des Kéhathites. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","En comptant tous les mâles, depuis l'âge d'un mois et au-dessus, ils étaient huit mille six cents, chargés des soins du sanctuaire. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Les familles des enfants de Kéhath campaient sur le côté de la Demeure, vers le Midi; ");
INSERT INTO fra_fob_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Et Elitsaphan, fils d'Uziel, était le chef de la maison des pères des familles des Kéhathites. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ils avaient en garde l'arche, la table, le chandelier, les autels et les ustensiles du sanctuaire avec lesquels on fait le service, et la tapisserie, et tout son service. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Et le chef des chefs des Lévites étaient Éléazar, fils d'Aaron, le sacrificateur, qui était préposé à ceux qui étaient chargés des soins du sanctuaire. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","A Mérari appartient la famille des Mahlites, et la famille des Mushites. Telles sont les familles de Mérari. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ceux d'entre eux qui furent dénombrés, en comptant tous les mâles, depuis l'âge d'un mois et au-dessus, étaient six mille deux cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Et Tsuriel, fils d'Abihaïl, était le chef de la maison des pères des familles des Mérarites; ils campaient sur le côté de la Demeure, vers le Nord. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Et les enfants de Mérari avaient la surveillance et le soin des planches de la Demeure, de ses traverses, de ses colonnes, de ses soubassements, de tous ses ustensiles, et de tout son service, ");
INSERT INTO fra_fob_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Des colonnes du parvis tout autour, avec leurs soubassements, leurs pieux et leurs cordages. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Ceux qui campaient devant la Demeure, vers l'Orient, devant le tabernacle d'assignation, c'était Moïse, et Aaron, et ses fils, chargés du soin du sanctuaire pour les enfants d'Israël; et l'étranger qui en approcherait devait être puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Tous les Lévites qui furent dénombrés, que Moïse et Aaron dénombrèrent, selon leurs familles, suivant le commandement de l'Éternel, tous les mâles, depuis l'âge d'un mois et au-dessus, étaient vingt-deux mille. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Puis l'Éternel dit à Moïse: Fais le dénombrement de tous les premiers-nés mâles des enfants d'Israël, depuis l'âge d'un mois et au-dessus, et fais le compte de leurs noms. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Tu prendras les Lévites pour moi, l'Éternel, à la place de tous les premiers-nés parmi les enfants d'Israël; et le bétail des Lévites, à la place de tous les premiers-nés du bétail des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moïse dénombra donc, comme l'Éternel le lui avait commandé, tous les premiers-nés parmi les enfants d'Israël; ");
INSERT INTO fra_fob_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Et tous les premiers-nés mâles, en comptant par les noms depuis l'âge d'un mois et au-dessus, selon leur dénombrement, furent vingt-deux mille deux cent soixante et treize. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Prends les Lévites à la place de tous les premiers-nés des enfants d'Israël, et le bétail des Lévites à la place de leur bétail; et les Lévites seront à moi: je suis l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Quant au rachat des premiers-nés des enfants d'Israël, savoir deux cent soixante et treize qui dépassent le nombre des Lévites, ");
INSERT INTO fra_fob_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Tu prendras cinq sicles par tête; tu les prendras selon le sicle du sanctuaire; le sicle est de vingt oboles. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Et tu donneras l'argent à Aaron et à ses fils; c'est le rachat de ceux qu'il y avait en plus. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moïse prit donc l'argent du rachat de ceux qu'il y avait en plus, outre les rachetés par les Lévites. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","L'argent qu'il prit des premiers-nés des enfants d'Israël, fut de mille trois cent soixante-cinq sicles, selon le sicle du sanctuaire. ");
INSERT INTO fra_fob_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Et Moïse donna l'argent du rachat à Aaron et à ses fils, sur l'ordre de l'Éternel, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","L'Éternel parla encore à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Faites le compte des fils de Kéhath, d'entre les enfants de Lévi, selon leurs familles, selon les maisons de leurs pères, ");
INSERT INTO fra_fob_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Depuis l'âge de trente ans et au-dessus, jusqu'à l'âge de cinquante ans, tous ceux qui entrent en rang pour s'employer au tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Voici le service des fils de Kéhath dans le tabernacle d'assignation, le soin du lieu très-saint. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Quand le camp partira, Aaron et ses fils viendront, et ils descendront le voile de tapisserie, et ils en couvriront l'arche du Témoignage. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Puis ils mettront sur elle une couverture de peaux de couleur d'hyacinthe; ils étendront par-dessus un drap entièrement de pourpre, et ils y mettront les barres. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Et ils étendront un drap de pourpre sur la table des pains de proposition, et ils mettront dessus les plats, les tasses, les coupes et les vases pour les libations; et le pain perpétuel sera dessus; ");
INSERT INTO fra_fob_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Et ils étendront sur ces choses un drap cramoisi, et ils le couvriront d'une couverture de peaux de couleur d'hyacinthe; et ils mettront les barres de la table. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Et ils prendront un drap de pourpre, et ils en couvriront le chandelier du luminaire, ses lampes, ses mouchettes, ses porte-mouchettes, et tous ses vases à huile, dont on se sert pour le chandelier. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Et ils le mettront, avec tous ses ustensiles, dans une couverture de peaux de couleur d'hyacinthe, et le placeront sur le brancard. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ils étendront sur l'autel d'or un drap de pourpre, et ils le couvriront d'une couverture de peaux de couleur d'hyacinthe, et ils y mettront ses barres. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ils prendront aussi tous les ustensiles du service, dont on se sert dans le sanctuaire, et ils les mettront dans un drap de pourpre, et ils les couvriront d'une couverture de peaux de couleur d'hyacinthe, et les mettront sur le brancard. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ils ôteront les cendres de l'autel, et ils étendront sur lui un drap écarlate; ");
INSERT INTO fra_fob_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Et ils mettront dessus tous les ustensiles employés pour y faire le service, les encensoirs, les fourchettes, les racloirs, les coupes, tous les ustensiles de l'autel; et ils étendront par-dessus une couverture de peaux de couleur d'hyacinthe, et ils y mettront ses barres. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Après qu'Aaron et ses fils auront achevé de couvrir le sanctuaire et tous les ustensiles sacrés, quand le camp partira, alors les enfants de Kéhath viendront pour les porter; et ils ne toucheront point les choses saintes, de peur qu'ils ne meurent. Voilà ce qu'auront à porter les enfants de Kéhath dans le tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Éléazar, fils d'Aaron, le sacrificateur, aura la surveillance de l'huile du luminaire, du parfum d'aromates, de l'oblation continuelle et de l'huile d'onction, la surveillance de toute la Demeure, et de tout ce qu'elle contient, le sanctuaire et ses ustensiles. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","L'Éternel parla encore à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Faites en sorte que la tribu des familles de Kéhath ne soit point retranchée d'entre les Lévites; ");
INSERT INTO fra_fob_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Et faites ceci pour eux, afin qu'ils vivent et ne meurent point, quand ils approcheront du lieu très-saint: qu'Aaron et ses fils viennent, et prescrivent à chacun son service et ce qu'il doit porter. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Et ils n'entreront point pour regarder, quand on enveloppera les choses saintes, de peur qu'ils ne meurent. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Fais aussi le compte des enfants de Guershon, selon les maisons de leurs pères, selon leurs familles. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Depuis l'âge de trente ans et au-dessus, jusqu'à l'âge de cinquante ans, tu les dénombreras, tous ceux qui viennent prendre rang pour faire le service dans le tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Voici le service des familles des Guershonites, ce qu'ils doivent faire, et ce qu'ils doivent porter; ");
INSERT INTO fra_fob_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ils porteront les tentures de la Demeure, et le tabernacle d'assignation, sa couverture, la couverture de peaux de couleur d'hyacinthe qui est par-dessus, et la tapisserie de l'entrée du tabernacle d'assignation; ");
INSERT INTO fra_fob_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Les tentures du parvis, et la tapisserie de l'entrée de la porte du parvis, qui cachent la Demeure et l'autel tout autour, leurs cordages, et tous les ustensiles de leur service. Ils feront tout le service qui s'y rapporte. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tout le service des enfants de Guershon, en tout ce qu'ils doivent porter, et en tout ce qu'ils doivent faire, sera réglé par l'ordre d'Aaron et de ses fils, et vous confierez à leur garde tout ce qu'ils doivent porter. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Tel est le service des familles des enfants des Guershonites dans le tabernacle d'assignation; et leur charge sera exercée sous la conduite d'Ithamar, fils d'Aaron, le sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Tu dénombreras les enfants de Mérari, selon leurs familles, selon les maisons de leurs pères; ");
INSERT INTO fra_fob_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Tu les dénombreras depuis l'âge de trente ans et au-dessus, jusqu'à l'âge de cinquante ans, tous ceux qui prennent rang pour s'employer au service du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Et voici ce qu'ils auront à garder et à porter, pour tout leur service dans le tabernacle d'assignation: les planches de la Demeure, ses traverses, ses colonnes, ses soubassements, ");
INSERT INTO fra_fob_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Les colonnes du parvis tout autour, leurs soubassements, leurs pieux, leurs cordages, avec tous les objets et tout ce qui se rattache à leur service; et vous dénombrerez par leurs noms les objets qu'ils auront à garder et à porter. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tel est le service des familles des enfants de Mérari, pour tout leur service dans le tabernacle d'assignation, sous la conduite d'Ithamar, fils d'Aaron, le sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moïse, Aaron et les principaux de l'assemblée, dénombrèrent donc les enfants des Kéhathites, selon leurs familles et selon les maisons de leurs pères, ");
INSERT INTO fra_fob_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Depuis l'âge de trente ans et au-dessus, jusqu'à l'âge de cinquante ans, tous ceux qui prenaient rang pour servir au tabernacle d'assignation; ");
INSERT INTO fra_fob_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Et ceux qui furent dénombrés selon leurs familles, étaient deux mille sept cent cinquante. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Tels sont ceux des familles des Kéhathites dont on fit le dénombrement, tous ceux qui servaient dans le tabernacle d'assignation, que Moïse et Aaron passèrent en revue sur l'ordre que l'Éternel en avait donné par l'organe de Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Quant aux enfants de Guershon qui furent dénombrés, selon leurs familles et selon les maisons de leurs pères, ");
INSERT INTO fra_fob_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Depuis l'âge de trente ans et au-dessus, jusqu'à l'âge de cinquante ans, tous ceux qui vinrent prendre rang pour servir au tabernacle d'assignation, ");
INSERT INTO fra_fob_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Ceux qui furent dénombrés, selon leurs familles, selon les maisons de leurs pères, étaient deux mille six cent trente. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Tels sont ceux des familles des enfants de Guershon qui furent dénombrés, tous ceux qui servaient dans le tabernacle d'assignation, que Moïse et Aaron dénombrèrent, sur l'ordre de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Quant à ceux des familles des enfants de Mérari, qui furent dénombrés, selon leurs familles, selon les maisons de leurs pères, ");
INSERT INTO fra_fob_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Depuis l'âge de trente ans et au-dessus, jusqu'à l'âge de cinquante ans, tous ceux qui venaient prendre rang pour faire le service dans le tabernacle d'assignation, ");
INSERT INTO fra_fob_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Ceux qui furent dénombrés, selon leurs familles, étaient trois mille deux cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Tels sont ceux des familles des enfants de Mérari, que Moïse et Aaron dénombrèrent sur l'ordre que l'Éternel en avait donné par l'organe de Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Tous ceux que Moïse et Aaron et les principaux d'Israël dénombrèrent d'entre les Lévites, selon leurs familles, et selon les maisons de leurs pères, ");
INSERT INTO fra_fob_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Depuis l'âge de trente ans et au-dessus, jusqu'à l'âge de cinquante ans; tous ceux qui entraient pour remplir l'office de serviteurs et l'office de porteurs dans le tabernacle d'assignation, ");
INSERT INTO fra_fob_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Tous ceux qui furent dénombrés étaient huit mille cinq cent quatre-vingts. ");
INSERT INTO fra_fob_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","On en fit le dénombrement selon l'ordre que l'Éternel en avait donné par l'organe de Moïse, chacun pour son service et pour ce qu'il avait à porter; on en fit le dénombrement selon ce que l'Éternel avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Puis l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Ordonne aux enfants d'Israël de renvoyer hors du camp tout lépreux, tout homme qui a un écoulement et tout homme souillé pour un mort. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Vous les renverrez, tant l'homme que la femme; vous les renverrez hors du camp, afin qu'ils ne souillent pas leurs camps, au milieu desquels je demeure. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Et les enfants d'Israël firent ainsi, et ils les renvoyèrent hors du camp; comme l'Éternel avait parlé à Moïse, ainsi firent les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Parle aux enfants d'Israël: Quand un homme ou une femme aura commis quelqu'un des péchés par lesquels l'homme commet une prévarication contre l'Éternel, et que cette personne se sera ainsi rendue coupable, ");
INSERT INTO fra_fob_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ils confesseront le péché qu'ils auront commis, et le coupable restituera la somme totale de ce dont il est coupable; et il y ajoutera un cinquième, et le donnera à celui à l'égard duquel il s'est rendu coupable. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Que si cet homme n'a personne à qui l'on puisse restituer l'objet du délit, celui-ci reviendra à l'Éternel, au sacrificateur, outre le bélier des expiations, avec lequel il fera expiation pour le coupable. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Et toute offrande de toutes les choses consacrées que les enfants d'Israël présentent au sacrificateur, lui appartiendra. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Les choses consacrées que chacun offrira, lui appartiendront; ce que chacun donnera au sacrificateur, lui appartiendra. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Parle aux enfants d'Israël, et dis-leur: Si la femme de quelqu'un s'est détournée et a commis une infidélité contre lui, ");
INSERT INTO fra_fob_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","Et qu'un homme ait eu commerce avec elle, et que la chose soit cachée aux yeux de son mari; qu'elle se soit souillée en secret, et qu'il n'y ait point de témoin contre elle, et qu'elle n'ait point été surprise; ");
INSERT INTO fra_fob_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Si un esprit de jalousie passe sur lui, et qu'il soit jaloux de sa femme qui s'est souillée, ou si un esprit de jalousie passe sur lui, et qu'il soit jaloux de sa femme, sans qu'elle se soit souillée, ");
INSERT INTO fra_fob_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Cet homme amènera sa femme devant le sacrificateur, et apportera pour elle son offrande, un dixième d'épha de farine d'orge; il n'y répandra point d'huile, et n'y mettra point d'encens, car c'est une oblation de jalousie, une oblation de mémorial, pour rappeler l'iniquité. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Et le sacrificateur la fera approcher, et la fera tenir debout devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ensuite le sacrificateur prendra de l'eau sacrée, dans un vase de terre; le sacrificateur prendra aussi de la poussière qui sera sur le sol du Tabernacle, et la mettra dans l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Puis le sacrificateur fera tenir la femme debout devant l'Éternel; il découvrira la tête de la femme, et il mettra sur les paumes de ses mains l'oblation de mémorial, c'est-à-dire l'offrande de jalousie; et le sacrificateur aura dans sa main les eaux amères qui portent la malédiction. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Alors le sacrificateur fera jurer la femme, et lui dira: Si aucun homme n'a couché avec toi, et si, étant sous la puissance de ton mari, tu ne t'es point détournée et souillée, ne reçois aucun mal de ces eaux amères qui portent la malédiction. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mais si, étant sous la puissance de ton mari, tu t'es détournée, et que tu te sois souillée, et qu'un autre que ton mari ait couché avec toi, ");
INSERT INTO fra_fob_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Alors le sacrificateur fera jurer la femme par un serment d'imprécation, et lui dira: Que l'Éternel te livre à la malédiction et à l'exécration au milieu de ton peuple, en faisant flétrir ta cuisse et enfler ton ventre, ");
INSERT INTO fra_fob_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Et que ces eaux qui portent la malédiction, entrent dans tes entrailles, pour te faire enfler le ventre et flétrir la cuisse. Et la femme dira: Amen, amen! ");
INSERT INTO fra_fob_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Ensuite le sacrificateur écrira ces imprécations dans un livre, et les effacera dans les eaux amères. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Et il fera boire à la femme les eaux amères qui portent la malédiction; et les eaux qui portent la malédiction entreront en elle et lui seront amères. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Le sacrificateur prendra de la main de la femme l'offrande de jalousie, l'agitera devant l'Éternel, et l'offrira sur l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Et le sacrificateur prendra une poignée de l'offrande, en mémorial, et la fera fumer sur l'autel; ensuite il fera boire les eaux à la femme. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Or, quand il lui aura fait boire les eaux, s'il est vrai qu'elle se soit souillée et qu'elle ait commis une infidélité contre son mari, les eaux qui portent la malédiction entreront en elle et lui seront amères; et son ventre enflera, et sa cuisse se flétrira, et cette femme sera en malédiction au milieu de son peuple. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mais si la femme ne s'est point souillée, et qu'elle soit pure, elle ne recevra aucun mal, et elle aura des enfants. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Telle est la loi sur la jalousie, lorsqu'une femme, sous la puissance de son mari, se sera détournée et souillée; ");
INSERT INTO fra_fob_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Ou lorsqu'un esprit de jalousie passera sur le mari, et qu'il sera jaloux de sa femme; il la fera venir devant l'Éternel, et le sacrificateur fera pour elle tout ce qui est ordonné par cette loi. ");
INSERT INTO fra_fob_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Et le mari sera exempt de faute; mais cette femme-là portera son iniquité. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Parle aux enfants d'Israël, et dis-leur: Lorsqu'un homme ou une femme se sera mis à part en faisant vœu de Nazaréat (séparation) pour se consacrer à l'Éternel, ");
INSERT INTO fra_fob_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Il s'abstiendra de vin et de boisson enivrante; il ne boira point de vinaigre de vin, ni de vinaigre de boisson enivrante; il ne boira aucune liqueur de raisins, et ne mangera point de raisins frais ni secs. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Pendant tout le temps de son Nazaréat, il ne mangera rien de tout ce que la vigne produit, depuis les pépins jusqu'à la peau. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Pendant tout le temps de son vœu de Nazaréat, le rasoir ne passera point sur sa tête; jusqu'à ce que les jours, pour lesquels il s'est voué à l'Éternel, soient accomplis, il sera consacré, il laissera croître les cheveux de sa tête. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Pendant tout le temps pour lequel il s'est voué à l'Éternel, il ne s'approchera point d'une personne morte. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Il ne se souillera point pour son père, ni pour sa mère, pour son frère, ni pour sa sœur, quand ils mourront, car la consécration de son Dieu est sur sa tête. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Pendant tout le temps de son Nazaréat, il est consacré à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Que si quelqu'un vient à mourir auprès de lui subitement, et souille sa tête consacrée, il rasera sa tête au jour de sa purification, il la rasera au septième jour; ");
INSERT INTO fra_fob_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Et au huitième jour il apportera deux tourterelles ou deux pigeonneaux au sacrificateur, à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Et le sacrificateur en offrira un en sacrifice pour le péché, et l'autre en holocauste, et il fera propitiation pour lui, du péché qu'il a commis à l'occasion du mort. Il consacrera ainsi sa tête en ce jour-là. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Et il consacrera de nouveau à l'Éternel les jours de son Nazaréat, et il offrira un agneau de l'année en sacrifice pour le délit, et les jours précédents ne compteront point, parce que son Nazaréat a été souillé. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Or voici la loi du Nazaréat: lorsque les jours de son Nazaréat seront accomplis, on le fera venir à l'entrée du tabernacle d'assignation; ");
INSERT INTO fra_fob_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Et il présentera son offrande à l'Éternel, un agneau de l'année, sans défaut, en holocauste, une brebis de l'année, sans défaut, en sacrifice pour le péché, et un bélier sans défaut en sacrifice de prospérités; ");
INSERT INTO fra_fob_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Une corbeille de pains sans levain de fine farine, des gâteaux arrosés d'huile, et des galettes sans levain, ointes d'huile, avec leur offrande et leurs libations. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Le sacrificateur les présentera devant l'Éternel, et il offrira son sacrifice pour le péché et son holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Et il offrira le bélier en sacrifice de prospérités à l'Éternel, outre la corbeille de pains sans levain. Le sacrificateur présentera aussi son offrande et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Et le Nazaréen rasera, à l'entrée du tabernacle d'assignation, sa tête consacrée, et il prendra les cheveux de sa tête consacrée et les mettra sur le feu qui est sous le sacrifice de prospérités. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Et le sacrificateur prendra l'épaule cuite du bélier, et un gâteau sans levain de la corbeille, et une galette sans levain, et les mettra sur les paumes des mains du Nazaréen, après qu'il aura rasé sa tête consacrée; ");
INSERT INTO fra_fob_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Le sacrificateur les agitera en offrande devant l'Éternel; c'est une chose sainte qui appartient au sacrificateur, avec la poitrine agitée et la jambe élevée en offrande. Ensuite le Nazaréen pourra boire du vin. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Telle est la loi du Nazaréen, qui aura voué son offrande à l'Éternel pour son Nazaréat, outre ce qu'il pourra encore offrir. Il fera selon le vœu qu'il aura prononcé, d'après la loi de son Nazaréat. ");
INSERT INTO fra_fob_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Parle à Aaron et à ses fils, en disant: Vous bénirez ainsi les enfants d'Israël; dites-leur: ");
INSERT INTO fra_fob_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","L'Éternel te bénisse et te garde! ");
INSERT INTO fra_fob_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","L'Éternel fasse luire sa face sur toi et te fasse grâce! ");
INSERT INTO fra_fob_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","L'Éternel tourne sa face vers toi et te donne la paix! ");
INSERT INTO fra_fob_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ils mettront ainsi mon nom sur les enfants d'Israël, et moi, je les bénirai. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Lorsque Moïse eut achevé de dresser la Demeure, et qu'il l'eut ointe et consacrée avec tous ses ustensiles, lorsqu'il eut aussi oint et consacré l'autel et tous ses ustensiles, ");
INSERT INTO fra_fob_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Les principaux d'Israël, chefs des familles de leurs pères, c'est-à-dire les princes des tribus, ceux qui avaient présidé au dénombrement, firent leur offrande. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ils amenèrent donc leur offrande devant l'Éternel: six chariots en forme de litières, et douze taureaux; un chariot pour deux princes, et un taureau pour chacun, et ils les offrirent devant la Demeure. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Alors l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Prends d'eux ces choses, et qu'elles soient employées au service du tabernacle d'assignation; et donne-les aux Lévites, à chacun selon son service. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moïse prit donc les chariots et les taureaux, et les donna aux Lévites. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Il donna aux enfants de Guershon deux chariots et quatre taureaux, selon leur service. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Et il donna aux enfants de Mérari quatre chariots et huit taureaux, selon leur service, sous la conduite d'Ithamar, fils d'Aaron, le sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mais il n'en donna point aux enfants de Kéhath parce qu'ils étaient chargés du service des choses saintes; ils les portaient sur leurs épaules. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Et les princes firent une offrande pour la dédicace de l'autel, au jour qu'il fut oint; les princes apportèrent leur offrande devant l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Et l'Éternel dit à Moïse: Qu'un prince apporte son offrande un jour, et un autre, un autre jour, pour la dédicace de l'autel. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Et celui qui offrit son offrande le premier jour fut Nahasshon, fils d'Amminadab, de la tribu de Juda. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Une coupe d'or de dix sicles pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande de Nahasshon, fils d'Amminadab. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Le second jour, Nathanaël, fils de Tsuar, prince d'Issacar, fit son offrande; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Il offrit: un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande de Nathanaël, fils de Tsuar. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Le troisième jour, ce fut le prince des enfants de Zabulon, Éliab, fils de Hélon. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande d'Éliab, fils de Hélon. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Le quatrième jour, ce fut le prince des enfants de Ruben, Elitsur, fils de Shedéur. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande d'Elitsur, fils de Shedéur. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Le cinquième jour, ce fut le prince des enfants de Siméon, Shelumiel, fils de Tsurishaddaï. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande de Shelumiel, fils de Tsurishaddaï. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Le sixième jour, ce fut le prince des enfants de Gad, Eliasaph, fils de Déhuël. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande d'Eliasaph, fils de Déhuël. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Le septième jour, ce fut le prince des enfants d'Éphraïm, Elishama, fils d'Ammihud. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande d'Elishama, fils d'Ammihud. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Le huitième jour, ce fut le prince des enfants de Manassé, Gamaliel, fils de Pedahtsur. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Une coupe d'or de dix sicles, pleine de parfum, ");
INSERT INTO fra_fob_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande de Gamaliel, fils de Pedahtsur. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Le neuvième jour, ce fut le prince des enfants de Benjamin, Abidan, fils de Guideoni. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","Un jeune taureau, un bélier, un agneau de l'année pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande d'Abidan, fils de Guideoni. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Le dixième jour, ce fut le prince des enfants de Dan, Ahiézer, fils d'Ammishaddaï. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande d'Ahiézer, fils d'Ammishaddaï. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Le onzième jour, ce fut le prince des enfants d'Asser, Paguiel, fils d'Ocran. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande de Paguiel, fils d'Ocran. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Le douzième jour, ce fut le prince des enfants de Nephthali, Ahira, fils d'Enan. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Son offrande fut un plat d'argent, du poids de cent trente sicles, un bassin d'argent de soixante et dix sicles, selon le sicle du sanctuaire, tous deux pleins de fine farine pétrie à l'huile, pour l'oblation; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Une coupe d'or de dix sicles, pleine de parfum; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Un jeune taureau, un bélier, un agneau de l'année, pour l'holocauste; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","Un bouc pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Et pour le sacrifice de prospérités, deux taureaux, cinq béliers, cinq jeunes boucs, cinq agneaux d'un an. Telle fut l'offrande d'Ahira, fils d'Enan. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Voilà ce qu'on reçut des princes d'Israël pour la dédicace de l'autel, lorsqu'il fut oint: Douze plats d'argent, douze bassins d'argent, douze coupes d'or; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Chaque plat d'argent était de cent trente sicles, et chaque bassin de soixante et dix. Tout l'argent des vases fut de deux mille quatre cents sicles selon le sicle du sanctuaire. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Douze coupes d'or, pleines de parfum, chacune de dix sicles, selon le sicle du sanctuaire. Tout l'or des coupes fut de cent vingt sicles. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Tous les taureaux pour l'holocauste, furent douze jeunes taureaux, avec douze béliers, douze agneaux d'un an, avec leurs oblations, et douze boucs, pour le sacrifice pour le péché; ");
INSERT INTO fra_fob_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Tous les taureaux du sacrifice de prospérités furent vingt-quatre jeunes taureaux, avec soixante béliers, soixante jeunes boucs, soixante agneaux d'un an. Telle fut la dédicace de l'autel, après qu'il eut été oint. ");
INSERT INTO fra_fob_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Or quand Moïse entrait au tabernacle d'assignation, pour parler avec Dieu, il entendait la voix lui parlant de dessus le propitiatoire, qui était sur l'arche du Témoignage, d'entre les deux chérubins; et il lui parlait. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Parle à Aaron, et dis-lui: Quand tu allumeras les lampes, les sept lampes éclaireront sur le devant du chandelier. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Et Aaron fit ainsi, il alluma les lampes sur le devant du chandelier, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Or, voici comment était fait le chandelier: il était d'or, fait au marteau; jusqu'à son pied, jusqu'à ses fleurs, il était fait au marteau. On fit ainsi le chandelier selon le modèle que l'Éternel avait fait voir à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Puis l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Prends les Lévites d'entre les enfants d'Israël, et purifie-les. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Tu leur feras ainsi pour les purifier: Fais sur eux aspersion de l'eau de purification pour le péché; ils feront passer le rasoir sur toute leur chair, laveront leurs vêtements, et se purifieront. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Puis ils prendront un jeune taureau, avec son offrande de fine farine pétrie à l'huile; et tu prendras un second jeune taureau, pour le sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Alors tu feras approcher les Lévites devant le tabernacle d'assignation, et tu convoqueras toute l'assemblée des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Tu feras donc approcher les Lévites devant l'Éternel, et les enfants d'Israël appuieront leurs mains sur les Lévites, ");
INSERT INTO fra_fob_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Et Aaron présentera les Lévites en offrande devant l'Éternel, de la part des enfants d'Israël, et ils seront employés à faire le service de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Puis les Lévites appuieront leurs mains sur la tête des jeunes taureaux; et tu offriras l'un en sacrifice pour le péché, et l'autre en holocauste à l'Éternel, pour faire expiation pour les Lévites. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ensuite tu feras tenir les Lévites debout devant Aaron et devant ses fils, et tu les présenteras en offrande à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Ainsi tu sépareras les Lévites d'entre les enfants d'Israël, et les Lévites seront à moi. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Après cela, les Lévites viendront pour faire le service du tabernacle d'assignation. Tu les purifieras donc, et tu les présenteras en offrande. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Car ils me sont entièrement donnés d'entre les enfants d'Israël; je les ai pris pour moi, à la place de tous ceux qui naissent les premiers, de tous les premiers-nés d'entre les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Car tout premier-né parmi les enfants d'Israël est à moi, parmi les hommes et parmi les bêtes; je me les suis consacrés au jour où je frappai tous les premiers-nés dans le pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Et j'ai pris les Lévites à la place de tous les premiers-nés des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Et j'ai donné les Lévites entièrement à Aaron et à ses fils, d'entre les enfants d'Israël, pour faire le service des enfants d'Israël dans le tabernacle d'assignation, et pour faire expiation pour les enfants d'Israël, afin qu'il n'y ait point de plaie parmi les enfants d'Israël, quand ils s'approcheront du sanctuaire. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moïse, Aaron et toute l'assemblée des enfants d'Israël firent donc, à l'égard des Lévites, selon tout ce que l' Éternel avait commandé à Moïse touchant les Lévites; les enfants d'Israël firent ainsi à leur égard. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Les Lévites se purifièrent donc, et lavèrent leurs vêtements; et Aaron les présenta en offrande devant l'Éternel, et il fit expiation pour eux afin de les purifier. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Après cela, les Lévites vinrent pour faire leur service dans le tabernacle d'assignation devant Aaron et devant ses fils. On fit à l'égard des Lévites comme l'Éternel avait commandé à Moïse à leur sujet. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Puis l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Voici ce qui concerne les Lévites: Depuis l'âge de vingt-cinq ans et au-dessus, le Lévite viendra prendre rang dans les services du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Mais depuis l'âge de cinquante ans, il sortira du service et ne servira plus; ");
INSERT INTO fra_fob_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Il assistera ses frères dans le tabernacle d'assignation, en gardant ce qui leur est confié; mais il ne fera plus de service. Tu feras ainsi à l'égard des Lévites, pour ce qui concerne leurs fonctions. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","L'Éternel parla aussi à Moïse, au désert de Sinaï, au premier mois de la seconde année après leur sortie du pays d'Égypte, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Que les enfants d'Israël fassent la Pâque au temps fixé. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Vous la ferez au temps fixé, le quatorzième jour de ce mois, entre les deux soirs; vous la ferez selon toutes ses ordonnances et selon toutes ses lois. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moïse parla donc aux enfants d'Israël, ");
INSERT INTO fra_fob_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Pour qu'ils fissent la Pâque. Et ils firent la Pâque au premier mois, au quatorzième jour du mois, entre les deux soirs, au désert de Sinaï; les enfants d'Israël firent selon tout ce que l'Éternel avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Or il y eut des hommes qui, étant souillés pour un mort, ne pouvaient faire la Pâque ce jour-là; et ils se présentèrent ce même jour devant Moïse et devant Aaron; ");
INSERT INTO fra_fob_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Et ces hommes lui dirent: Nous sommes souillés pour un mort; pourquoi serions-nous privés d'offrir l'offrande de l'Éternel, au temps marqué, parmi les enfants d'Israël? ");
INSERT INTO fra_fob_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Et Moïse leur dit: Attendez, et j'écouterai ce que l'Éternel ordonnera pour vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Parle aux enfants d'Israël, en disant: Quand quelqu'un d'entre vous, ou de votre postérité, sera souillé pour un mort, ou sera en voyage, au loin, il ne laissera pas de célébrer la Pâque à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Ils la feront le quatorzième jour du second mois, entre les deux soirs; ils la mangeront avec du pain sans levain et des herbes amères. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ils n'en laisseront rien jusqu'au matin, et ils n'en rompront point les os; ils la feront selon toute l'ordonnance de la Pâque. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Mais quant à l'homme qui est pur, et n'est pas en voyage, et s'abstient de faire la Pâque, cette personne-là sera retranchée d'entre ses peuples; parce qu'il n'a point offert l'offrande de l'Éternel au temps fixé, cet homme portera la peine de son péché. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Et lorsqu'un étranger séjournera parmi vous et fera la Pâque à l'Éternel, il la fera selon la loi et l'ordonnance de la Pâque. Il y aura une même ordonnance pour vous, pour l'étranger et pour celui qui est né au pays. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Or au jour où l'on dressa la Demeure, la nuée couvrit la Demeure, le tabernacle du Témoignage; et le soir il y eut sur la Demeure comme une apparence de feu, jusqu'au matin. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Il en était ainsi continuellement; la nuée le couvrait, et il y avait la nuit une apparence de feu. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Or, selon que la nuée se levait de dessus le tabernacle, les enfants d'Israël partaient; et au lieu où la nuée s'arrêtait, là campaient les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Les enfants d'Israël partaient au commandement de l'Éternel, et au commandement de l'Éternel ils campaient. Pendant tout le temps que la nuée restait sur la Demeure, ils restaient campés. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Et lorsque la nuée restait longtemps sur la Demeure, les enfants d'Israël observaient l'ordre de l'Éternel, et ne partaient point. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Mais dans le cas où la nuée était peu de jours sur la Demeure, ils campaient au commandement de l'Éternel, et au commandement de l'Éternel ils partaient. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Et dans le cas où la nuée y était depuis le soir jusqu'au matin, et que la nuée se levât le matin, ils partaient; de jour ou de nuit, quand la nuée se levait, ils partaient. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Soit deux jours, soit un mois, ou plus longtemps, tant que la nuée prolongeait son séjour sur la Demeure, les enfants d'Israël restaient campés, et ne partaient point; mais quand elle se levait, ils partaient. ");
INSERT INTO fra_fob_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ils campaient au commandement de l'Éternel, et ils partaient au commandement de l'Éternel; ils observaient l'ordre de l'Éternel, suivant le commandement de l'Éternel, donné par Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Fais-toi deux trompettes d'argent; tu les feras façonnées au marteau; elles te serviront pour convoquer l'assemblée, et pour le départ des camps. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Quand on en sonnera, toute l'assemblée se réunira vers toi, à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Si l'on sonne d'une seule, les princes, les chefs des milliers d'Israël, se réuniront vers toi. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Quand vous sonnerez d'un son éclatant, les camps qui sont à l'orient partiront. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Et quand vous sonnerez une seconde fois d'un son éclatant, les camps qui sont au midi partiront; on sonnera d'un son éclatant lorsqu'ils devront partir. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Quand on convoquera l'assemblée, vous sonnerez, mais non d'un son éclatant. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Or les fils d'Aaron, les sacrificateurs, sonneront des trompettes; et elles seront pour vous une ordonnance perpétuelle, d'âge en âge. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Et quand vous irez à la guerre dans votre pays, contre l'ennemi qui vous attaquera, vous sonnerez des trompettes avec un son éclatant, et vous serez remis en mémoire devant l'Éternel votre Dieu, et vous serez délivrés de vos ennemis. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Et dans vos jours de joie, dans vos solennités, et au commencement de vos mois, vous sonnerez des trompettes sur vos holocaustes, et sur vos sacrifices de prospérités, et elles vous serviront de mémorial devant votre Dieu. Je suis l'Éternel, votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Or il arriva, le vingtième jour du second mois de la seconde année, que la nuée se leva de dessus la Demeure du Témoignage. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Et les enfants d'Israël partirent, selon leur ordre de marche, du désert de Sinaï; et la nuée s'arrêta au désert de Paran. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ils partirent donc, pour la première fois, sur l'ordre de l'Éternel, donné par le moyen de Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","La bannière du camp des enfants de Juda partit la première, selon leurs armées; Nahasshon, fils d'Amminadab, commandait l'armée de Juda. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Nathanaël, fils de Tsuar, commandait l'armée de la tribu des enfants d'Issacar. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Éliab, fils de Hélon, commandait l'armée de la tribu des enfants de Zabulon. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","La Demeure fut démontée et les enfants de Guershon et les enfants de Mérari, qui portaient la Demeure, partirent. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Puis la bannière du camp de Ruben partit, selon leurs armées; et Elitsur, fils de Shedéur, commandait l'armée de Ruben. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Et Shelumiel, fils de Tsurishaddaï, commandait l'armée de la tribu des enfants de Siméon. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Et Eliasaph, fils de Déhuël, commandait l'armée de la tribu des enfants de Gad. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Alors les Kéhathites, qui portaient le sanctuaire, partirent; or, on dressait la Demeure, en attendant leur arrivée. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Puis la bannière du camp des enfants d'Éphraïm partit, selon leurs armées; et Elishama, fils d'Ammihud, commandait l'armée d'Éphraïm. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Et Gamaliel, fils de Pédahtsur, commandait l'armée de la tribu des enfants de Manassé. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Et Abidan, fils de Guideoni, commandait l'armée de la tribu des enfants de Benjamin. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Enfin la bannière du camp des enfants de Dan, qui formait l'arrière-garde de tous les camps, partit, selon leurs armées; et Ahiézer, fils d'Ammishaddaï, commandait l'armée de Dan. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Et Paguiel, fils d'Ocran, commandait l'armée de la tribu des enfants d'Asser. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Et Ahira, fils d'Enan, commandait l'armée de la tribu des enfants de Nephthali. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Tel était l'ordre de marche des enfants d'Israël, selon leurs armées; et ils partirent. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Or, Moïse dit à Hobab, fils de Réuel, le Madianite, beau-père de Moïse: Nous partons pour le lieu dont l'Éternel a dit: Je vous le donnerai; viens avec nous, et nous te ferons du bien; car l'Éternel a promis de faire du bien à Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Et Hobab lui répondit: Je n'irai point, mais j'irai dans mon pays, et dans le lieu de ma naissance. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Et Moïse lui dit: Je te prie, ne nous laisse point; puisque tu connais les lieux où nous pouvons camper dans le désert, tu nous serviras de guide. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Et il arrivera, si tu viens avec nous et que ce bien que l'Éternel doit nous faire arrive, que nous te ferons aussi du bien. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ils partirent donc de la montagne de l'Éternel, et marchèrent pendant trois jours; et l'arche de l'alliance de l'Éternel allait devant eux, faisant trois journées de chemin, pour leur chercher un lieu de repos. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Et la nuée de l'Éternel était sur eux pendant le jour, quand ils partaient du camp. ");
INSERT INTO fra_fob_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Et quand l'arche partait, Moïse disait: Lève-toi, Éternel, et que tes ennemis soient dispersés, et que ceux qui te haïssent s'enfuient devant ta face! ");
INSERT INTO fra_fob_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Et quand on la posait, il disait: Reviens, Éternel, aux dix mille milliers d'Israël! ");
INSERT INTO fra_fob_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Or le peuple fut comme des gens qui se plaignent d'un malheur, aux oreilles de l'Éternel; et l'Éternel l'entendit, et sa colère s'embrasa, et le feu de l'Éternel s'alluma parmi eux et dévora à l'extrémité du camp. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Alors le peuple cria à Moïse, et Moïse pria l'Éternel, et le feu s'arrêta. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Et l'on nomma ce lieu Thabéera (incendie), parce que le feu de l'Éternel s'était allumé parmi eux. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Et le ramassis d'étrangers qui était parmi eux se livra à la convoitise; et même les enfants d'Israël se mirent de nouveau à pleurer, et dirent: Qui nous fera manger de la chair? ");
INSERT INTO fra_fob_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Il nous souvient des poissons que nous mangions en Égypte, pour rien; des concombres, des melons, des poireaux, des oignons et des aulx. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Et maintenant, notre âme est desséchée; il n'y a rien du tout! Nos yeux ne voient que la manne. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Or la manne était comme de la semence de coriandre, et sa couleur, comme celle du bdellion. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Le peuple se dispersait et la ramassait; puis il la broyait avec les meules, ou la pilait dans un mortier, et la faisait cuire dans un chaudron, et en faisait des gâteaux; et le goût en était semblable à celui d'un gâteau à l'huile. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Et quand la rosée tombait la nuit sur le camp, la manne descendait dessus. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moïse entendit donc le peuple qui pleurait dans ses familles, chacun à l'entrée de sa tente; et la colère de l'Éternel s'embrasa fortement, et Moïse en fut affligé. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Et Moïse dit à l'Éternel: Pourquoi as-tu affligé ton serviteur; et pourquoi n'ai-je pas trouvé grâce devant tes y eux, que tu aies mis sur moi la charge de tout ce peuple? ");
INSERT INTO fra_fob_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Est-ce moi qui ai conçu tout ce peuple, ou l'ai-je engendré, que tu me dises: Porte-le dans ton sein, comme le nourricier porte l'enfant qui tète, jusqu'au pays que tu as promis par serment à ses pères? ");
INSERT INTO fra_fob_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","D'où aurais-je de la chair pour en donner à tout ce peuple? Car il pleure après moi, en disant: Donne-nous de la chair, que nous mangions. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Je ne puis, moi seul, porter tout ce peuple; car il est trop pesant pour moi. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Que si tu agis ainsi à mon égard, tue-moi, je te prie, si j'ai trouvé grâce à tes yeux; et que je ne voie point mon malheur. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Alors l'Éternel dit à Moïse: Assemble-moi soixante et dix hommes, d'entre les anciens d'Israël, que tu connais pour être les anciens du peuple, et préposés sur lui; amène-les au tabernacle d'assignation, et qu'ils se tiennent là avec toi. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Puis je descendrai, et là je parlerai avec toi; je mettrai à part de l'esprit qui est sur toi, et je le mettrai sur eux, afin qu'ils portent avec toi la charge du peuple, et que tu ne la portes pas toi seul. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Et tu diras au peuple: Sanctifiez-vous pour demain et vous mangerez de la chair. Parce que vous avez pleuré aux oreilles de l'Éternel, en disant: Qui nous fera manger de la chair? car nous étions bien en Égypte; l'Éternel vous donnera de la chair et vous en mangerez. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Vous n'en mangerez pas un jour, ni deux jours, ni cinq jours, ni dix jours, ni vingt jours; ");
INSERT INTO fra_fob_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Mais jusqu'à un mois entier, jusqu'à ce qu'elle vous sorte par les narines, et que vous en soyez dégoûtés, parce que vous avez rejeté l'Éternel qui est au milieu de vous, et que vous avez pleuré devant lui, en disant: Pourquoi donc sommes-nous sortis d'Égypte? ");
INSERT INTO fra_fob_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Et Moïse dit: Il y a six cent mille hommes de pied dans ce peuple, au milieu duquel je suis; et tu as dit: Je leur donnerai de la chair, et ils en mangeront un mois entier. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Leur égorgera-t-on des brebis et des bœufs, en sorte qu'il y en ait assez pour eux? ou leur assemblera-t-on tous les poissons de la mer, en sorte qu'il y en ait assez pour eux? ");
INSERT INTO fra_fob_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Et l'Éternel répondit à Moïse: La main de l'Éternel est-elle raccourcie? Tu verras maintenant si ce que je t'ai dit, arrivera ou non. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moïse sortit donc et rapporta au peuple les paroles de l'Éternel; et il assembla soixante et dix hommes d'entre les anciens du peuple, et les plaça tout autour du tabernacle. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Alors l'Éternel descendit dans la nuée, et lui parla, et il mit à part de l'esprit qui était sur lui, et le mit sur les soixante et dix anciens. Et dès que l'esprit reposa sur eux, ils prophétisèrent; mais ils ne continuèrent pas. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Or il en était demeuré deux au camp, dont l'un s'appelait Eldad, et l'autre Médad, et l'esprit reposa sur eux; or ils étaient de ceux qui avaient été inscrits, mais ils n'étaient point sortis vers le tabernacle; et ils prophétisèrent dans le camp. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Et un jeune garçon courut le rapporter à Moïse, et dit: Eldad et Médad prophétisent dans le camp. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Et Josué, fils de Nun, serviteur de Moïse, dès sa jeunesse, répondit, et dit: Moïse, mon seigneur, empêche-les! ");
INSERT INTO fra_fob_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Et Moïse lui répondit: Es-tu jaloux pour moi? Plût à Dieu de tout, que le peuple de l'Éternel fût prophète, et que l'Éternel mît son esprit sur eux! ");
INSERT INTO fra_fob_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Et Moïse se retira au camp, lui et les anciens d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Alors l'Éternel fit lever un vent, qui enleva des cailles de la mer, et les répandit sur le camp, environ le chemin d'une journée, d'un côté et de l'autre, tout autour du camp, et presque deux coudées de haut sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Et le peuple se leva, tout ce jour-là, et toute la nuit, et tout le jour suivant, et ils amassèrent les cailles; celui qui en amassa le moins, en avait dix homers, et ils les étendirent pour eux, tout autour du camp. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","La chair était encore entre leurs dents, elle n'était pas encore mâchée, que la colère de l'Éternel s'embrasa contre le peuple, et l'Éternel frappa le peuple d'une très grande plaie. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Et l'on nomma ce lieu-là Kibroth-Hatthaava (tombeaux de la convoitise); car on ensevelit là le peuple qui avait convoité. ");
INSERT INTO fra_fob_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","De Kibroth-Hatthaava le peuple partit pour Hatséroth; et ils s'arrêtèrent à Hatséroth. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Or Marie et Aaron parlèrent contre Moïse, au sujet de la femme éthiopienne qu'il avait prise; car il avait pris une femme éthiopienne. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Et ils dirent: L'Éternel n'a-t-il parlé que par Moïse seul? N'a-t-il point aussi parlé par nous? Et l'Éternel l'entendit. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Or, Moïse était un homme fort doux, plus qu'aucun homme qui soit sur la terre. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Et l'Éternel dit soudain à Moïse, à Aaron et à Marie: Sortez, vous trois, vers le tabernacle d'assignation. Et ils y allèrent tous trois. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Et l'Éternel descendit dans la colonne de nuée, et se tint à l'entrée du tabernacle; puis il appela Aaron et Marie; et ils vinrent tous deux. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Et il dit: Écoutez bien mes paroles. S'il y a parmi vous un prophète, moi, l'Éternel, je me fais connaître à lui en vision, je lui parle en songe. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Il n'en est pas ainsi de mon serviteur Moïse, qui est fidèle dans toute ma maison; ");
INSERT INTO fra_fob_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Je parle avec lui bouche à bouche, et en apparition, et non en énigmes, et il contemple l'image de l'Éternel. Pourquoi donc n'avez-vous pas craint de parler contre mon serviteur, contre Moïse? ");
INSERT INTO fra_fob_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Ainsi la colère de l'Éternel s'embrasa contre eux; et il s'en alla, ");
INSERT INTO fra_fob_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Et la nuée se retira de dessus le tabernacle. Et voici, Marie était frappée de lèpre, et blanche comme la neige; Aaron se tourna vers Marie, et voici, elle était lépreuse. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Alors Aaron dit à Moïse: Ah! mon seigneur, je te prie, ne mets point sur nous le péché que nous avons follement commis, et par lequel nous avons péché. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Je te prie, qu'elle ne soit point comme l'enfant mort, dont la chair est à demi-consumée, quand il sort du sein de sa mère. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Alors Moïse cria à l'Éternel, en disant: O Dieu, je te prie, guéris-la, je te prie! ");
INSERT INTO fra_fob_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Et l'Éternel répondit à Moïse: Si son père lui avait craché au visage, ne serait-elle pas couverte de honte pendant sept jours? Qu'elle demeure enfermée sept jours, hors du camp, et après cela elle y sera reçue. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ainsi Marie fut enfermée sept jours hors du camp; et le peuple ne partit point, jusqu'à ce que Marie y eût été reçue. ");
INSERT INTO fra_fob_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Après cela, le peuple partit de Hatséroth, et ils campèrent au désert de Paran. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Envoie des hommes pour explorer le pays de Canaan, que je donne aux enfants d'Israël. Vous enverrez un homme pour chacune des tribus de leurs pères, tous des principaux d'entre eux. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moïse les envoya donc du désert de Paran, selon le commandement de l'Éternel; tous ces hommes étaient chefs des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Et voici leurs noms: Pour la tribu de Ruben, Shammua, fils de Zaccur; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Pour la tribu de Siméon, Shaphath, fils de Hori; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Pour la tribu de Juda, Caleb, fils de Jephunné; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Pour la tribu d'Issacar, Jigal, fils de Joseph; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Pour la tribu d'Éphraïm, Hosée, fils de Nun; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Pour la tribu de Benjamin, Palthi, fils de Raphu; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Pour la tribu de Zabulon, Gaddiel, fils de Sodi; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Pour la tribu de Joseph, c'est-à-dire, pour la tribu de Manassé, Gaddi, fils de Susi; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Pour la tribu de Dan, Ammiel, fils de Guemalli; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Pour la tribu d'Asser, Sethur, fils de Micaël; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Pour la tribu de Nephthali, Nachbi, fils de Vophsi; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Pour la tribu de Gad, Gueuel, fils de Maki. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Tels sont les noms des hommes que Moïse envoya pour explorer le pays. Or Moïse nomma Hosée, fils de Nun, Josué. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moïse les envoya donc pour explorer le pays de Canaan, et il leur dit: Montez ici par le Midi, et vous monterez sur la montagne, ");
INSERT INTO fra_fob_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Et vous verrez le pays, quel il est, le peuple qui y habite, s'il est fort ou faible, s'il est en petit ou en grand nombre; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Et ce qu'est le pays où il habite, s'il est bon ou mauvais; ce que sont les villes dans lesquelles il habite, si c'est dans des camps ou dans des forteresses; ");
INSERT INTO fra_fob_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Ce qu'est la terre, si elle est grasse ou maigre; s'il y a des arbres ou non. Et ayez bon courage, et prenez du fruit du pays. C'était alors le temps des premiers raisins. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ils montèrent donc et explorèrent le pays, depuis le désert de Tsin jusqu'à Rehob, en allant vers Hamath. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ils montèrent par le Midi, et vinrent jusqu'à Hébron, où étaient Ahiman, Sheshaï, et Talmaï, enfants d'Anak. Or Hébron avait été bâtie sept ans avant Tsoan d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Et ils vinrent jusqu'au torrent d'Eshcol, et y coupèrent un sarment avec une grappe de raisins, et ils la portèrent à deux avec une perche, ainsi que des grenades et des figues. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","On appela ce lieu Torrent d'Eshcol (Torrent de la grappe), à cause de la grappe que les enfants d'Israël y coupèrent. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Or ils revinrent d'explorer le pays au bout de quarante jours. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Et étant arrivés, ils vinrent vers Moïse et vers Aaron, et vers toute l'assemblée des enfants d'Israël, au désert de Paran, à Kadès, et ils leur rendirent compte, ainsi qu'à toute l'assemblée, et leur montrèrent du fruit du pays. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Ils lui firent donc leur rapport, et dirent: Nous sommes allés au pays où tu nous avais envoyés; et vraiment c'est un pays où coulent le lait et le miel, et voici de son fruit. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Seulement le peuple qui habite dans ce pays est robuste, et les villes sont closes et très grandes; nous y avons vu aussi des enfants d'Anak. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Les Amalécites habitent la contrée du Midi; et les Héthiens, les Jébusiens et les Amoréens habitent dans la montagne; et les Cananéens habitent près de la mer et le long du Jourdain. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Alors Caleb fit taire le peuple devant Moïse, et dit: Montons, et emparons-nous-en; car nous pouvons les vaincre. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mais les hommes qui étaient montés avec lui, dirent: Nous ne pourrons monter contre ce peuple, car il est plus fort que nous. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Et ils décrièrent devant les enfants d'Israël le pays qu'ils avaient exploré, en disant: Le pays que nous avons parcouru pour l'explorer, est un pays qui dévore ses habitants, et tous ceux que nous y avons vus, sont des gens de haute stature. ");
INSERT INTO fra_fob_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Et nous y avons vu les géants, enfants d'Anak, de la race des géants; et nous étions à nos yeux comme des sauterelles, et nous l'étions aussi à leurs yeux. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Alors toute l'assemblée éleva la voix, et se mit à jeter des cris, et le peuple pleura cette nuit-là. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Et tous les enfants d'Israël murmurèrent contre Moïse et contre Aaron, et toute l'assemblée leur dit: Que ne sommes-nous morts dans le pays d'Égypte ou dans ce désert! Que ne sommes-nous morts! ");
INSERT INTO fra_fob_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Et pourquoi l'Éternel nous conduit-il vers ce pays, pour y tomber par l'épée? Nos femmes et nos petits enfants y seront une proie. Ne vaudrait-il pas mieux pour nous, de retourner en Égypte? ");
INSERT INTO fra_fob_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Et ils se dirent l'un à l'autre: Établissons un chef, et retournons en Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Alors Moïse et Aaron tombèrent sur leurs visages, devant toute l'assemblée des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Et Josué, fils de Nun, et Caleb, fils de Jephunné, d'entre ceux qui avaient exploré le pays, déchirèrent leurs vêtements. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Et ils parlèrent à toute l'assemblée des enfants d'Israël, en disant: Le pays que nous avons parcouru pour l'explorer, est un fort bon pays. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si l'Éternel nous est favorable, il nous fera entrer dans ce pays, et nous le donnera; c'est un pays où coulent le lait et le miel. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Seulement, ne vous révoltez point contre l'Éternel, et ne craignez point le peuple du pays; car ils seront notre pain; leur protection s'est retirée de dessus eux, et l'Éternel est avec nous; ne les craignez point. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Alors toute l'assemblée parla de les lapider; mais la gloire de l'Éternel apparut à tous les enfants d'Israël, sur le tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Et l'Éternel dit à Moïse: Jusqu'à quand ce peuple me méprisera-t-il, et jusqu'à quand ne croiront-ils point en moi, malgré tous les signes que j'ai faits au milieu d'eux? ");
INSERT INTO fra_fob_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Je le frapperai de mortalité, et je le détruirai; mais je te ferai devenir un peuple plus grand et plus fort qu'il n'est. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Et Moïse dit à l'Éternel: Mais les Égyptiens l'apprendront, car tu as fait monter ce peuple par ta force du milieu d'eux; ");
INSERT INTO fra_fob_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Et ils le diront aux habitants de ce pays. Ils ont entendu dire que tu es, ô Éternel, au milieu de ce peuple, et que tu apparais, ô Éternel, visiblement, que ta nuée se tient au-dessus d'eux, et que tu marches devant eux, le jour dans une colonne de nuée et la nuit dans une colonne de feu. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Et si tu fais mourir ce peuple, comme un seul homme, les nations qui ont entendu ta renommée, diront: ");
INSERT INTO fra_fob_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Parce que l'Éternel ne pouvait faire entrer ce peuple au pays qu'il avait juré de leur donner, il les a immolés dans le désert. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Or, maintenant, je te prie, que la puissance du Seigneur se montre dans sa grandeur, comme tu l'as déclaré, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","L'Éternel est lent à la colère et abondant en grâce; il pardonne l'iniquité et le forfait; mais il ne tient point le coupable pour innocent; il punit l'iniquité des pères sur les enfants, jusqu'à la troisième et à la quatrième génération. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Pardonne, je te prie, l'iniquité de ce peuple, selon la grandeur de ta grâce, et comme tu as pardonné à ce peuple depuis l'Égypte jusqu'ici. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Et l'Éternel dit: J'ai pardonné, selon ta parole. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mais aussi vrai que je suis vivant, et que la gloire de l'Éternel remplit toute la terre, ");
INSERT INTO fra_fob_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Tous les hommes qui ont vu ma gloire et les signes que j'ai faits en Égypte et au désert, et qui m'ont déjà tenté dix fois, et qui n'ont point écouté ma voix, ");
INSERT INTO fra_fob_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Ne verront point le pays que j'ai promis par serment à leurs pères. Et tous ceux qui m'ont méprisé, ne le verront point. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Mais parce que mon serviteur Caleb a été animé d'un autre esprit, et m'a pleinement suivi, je le ferai entrer au pays où il est allé, et sa postérité le possédera. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Or les Amalécites et les Cananéens habitent dans la vallée; retournez demain en arrière, et partez pour le désert dans la direction de la mer Rouge. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","L'Éternel parla aussi à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Jusqu'à quand supporterai-je cette assemblée méchante, qui murmure contre moi? J'ai entendu les murmures que les enfants d'Israël murmurent contre moi. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Dis-leur: Aussi vrai que je suis vivant, dit l'Éternel, je vous ferai ce que j'ai entendu que vous avez dit; ");
INSERT INTO fra_fob_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Vos cadavres tomberont dans ce désert; et tous ceux d'entre vous qui ont été dénombrés, selon tout votre nombre, depuis l'âge de vingt ans et au-dessus, vous tous qui avez murmuré contre moi, ");
INSERT INTO fra_fob_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Vous n'entrerez pas au pays au sujet duquel j'ai levé ma main, jurant de vous y faire habiter; excepté Caleb, fils de Jephunné, et Josué, fils de Nun. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Mais j'y ferai entrer vos petits enfants, dont vous avez dit qu'ils y seraient une proie; et ils connaîtront le pays que vous avez méprisé. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mais vos cadavres, à vous, tomberont dans ce désert. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Et vos enfants iront paissant dans le désert quarante ans, et ils porteront la peine de vos prostitutions, jusqu'à ce que vos cadavres soient consumés dans le désert. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","D'après le nombre des jours pendant lesquels vous avez exploré le pays, savoir quarante jours, vous porterez la peine de vos iniquités pendant quarante ans, une année pour chaque jour, et vous connaîtrez l'effet de mon éloignement. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Moi, l'Éternel, je l'ai dit: Je ferai ceci à toute cette méchante assemblée, qui s'est réunie contre moi; ils seront consumés dans ce désert, et ils y mourront. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Et les hommes que Moïse avait envoyés pour explorer le pays, et qui étaient revenus et avaient fait murmurer contre lui toute l'assemblée, en décriant le pays; ");
INSERT INTO fra_fob_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Ces hommes, qui avaient décrié le pays, moururent frappés d'une plaie devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mais Josué, fils de Nun, et Caleb, fils de Jephunné, survécurent, d'entre ces hommes qui étaient allés pour explorer le pays. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Or Moïse dit ces paroles à tous les enfants d'Israël; et il y eut un grand deuil parmi le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Puis ils se levèrent de bon matin, et montèrent vers le sommet de la montagne, en disant: Nous voici, et nous monterons au lieu dont l'Éternel a parlé; car nous avons péché. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Mais Moïse dit: Pourquoi transgressez-vous le commandement de l'Éternel? Cela ne réussira point. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","N'y montez pas, de peur que vous ne soyez battus devant vos ennemis, car l'Éternel n'est point au milieu de vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Car les Amalécites et les Cananéens sont là devant vous, et vous tomberez par l'épée, parce que vous vous êtes détournés de l'Éternel; et l'Éternel ne sera point avec vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Toutefois, ils s'obstinèrent à monter vers le sommet de la montagne; mais l'arche de l'alliance de l'Éternel et Moïse ne sortirent pas du milieu du camp. ");
INSERT INTO fra_fob_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Et les Amalécites et les Cananéens, qui habitaient dans cette montagne, descendirent, et les battirent et les taillèrent en pièces jusqu'à Horma. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Puis l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Parle aux enfants d'Israël, et dis-leur: Quand vous serez entrés au pays où vous devez demeurer, et que je vous donne, ");
INSERT INTO fra_fob_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Et que vous ferez un sacrifice par le feu à l'Éternel, un holocauste, ou un sacrifice pour vous acquitter d'un vœu, ou un sacrifice volontaire, ou, dans vos solennités, pour faire à l'Éternel une offrande d'agréable odeur de gros ou de menu bétail; ");
INSERT INTO fra_fob_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Celui qui offrira son offrande présentera à l'Éternel une oblation d'un dixième de fleur de farine pétrie avec le quart d'un hin d'huile. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Et tu feras une libation d'un quart de hin de vin sur l'holocauste, ou le sacrifice, pour chaque agneau. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Si c'est pour un bélier, tu feras une offrande de deux dixièmes de fleur de farine pétrie avec le tiers d'un hin d'huile, ");
INSERT INTO fra_fob_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Et le tiers d'un hin de vin pour la libation; tu l'offriras en agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Et quand tu sacrifieras un veau en holocauste, ou en sacrifice pour t'acquitter d'un vœu, ou en sacrifice de prospérités à l'Éternel, ");
INSERT INTO fra_fob_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","On offrira, avec le veau, une oblation de trois dixièmes de fleur de farine, pétrie avec la moitié d'un hin d'huile; ");
INSERT INTO fra_fob_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Et tu offriras la moitié d'un hin de vin pour la libation; c'est un sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","On fera de même pour chaque bœuf, chaque bélier, chaque agneau ou chevreau; ");
INSERT INTO fra_fob_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Selon le nombre que vous en sacrifierez, vous ferez ainsi pour chacun, selon leur nombre. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Tous ceux qui sont nés au pays feront ces choses ainsi, quand ils offriront un sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Si un étranger séjournant avec vous, ou une personne demeurant au milieu de vous, dans vos générations, offre un sacrifice par le feu en agréable odeur à l'Éternel, il fera comme vous ferez. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Il y aura une même ordonnance pour vous, assemblée, et pour l'étranger séjournant parmi vous; ce sera une ordonnance perpétuelle pour vos générations; il en sera de l'étranger comme de vous devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Il y aura une même loi et une même règle pour vous et pour l'étranger séjournant avec vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Parle aux enfants d'Israël, et dis leur: Quand vous serez entrés au pays où je vais vous faire entrer, ");
INSERT INTO fra_fob_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Et que vous mangerez du pain de ce pays, vous prélèverez une offrande pour l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Vous prélèverez en offrande un gâteau, les prémices de votre pâte; vous le prélèverez de la même manière que l'offrande de l'aire. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Vous donnerez, d'âge en âge, à l'Éternel une offrande des prémices de votre pâte. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Et lorsque vous aurez péché par erreur, et que vous n'aurez pas fait tous ces commandements que l'Éternel a donnés à Moïse, ");
INSERT INTO fra_fob_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Tout ce que l'Éternel vous a commandé par l'organe de Moïse, depuis le jour où l'Éternel vous a donné ses commandements, et dans la suite, dans vos générations; ");
INSERT INTO fra_fob_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Si la chose a été faite par erreur, sans que l'assemblée l'ait su, toute l'assemblée sacrifiera en holocauste, en agréable odeur à l'Éternel, un jeune taureau avec son oblation et sa libation, selon l'ordonnance, et un bouc en sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Et le sacrificateur fera l'expiation pour toute l'assemblée des enfants d'Israël, et il leur sera pardonné, parce que c'est un péché commis par erreur, et qu'ils ont apporté devant l'Éternel leur offrande, un sacrifice fait par le feu à l'Éternel et leur sacrifice pour le péché, à cause de leur erreur. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Il sera pardonné à toute l'assemblée des enfants d'Israël, et à l'étranger séjournant parmi eux, parce que cela est arrivé à tout le peuple par erreur. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Que si une seule personne pèche par erreur, elle offrira une chèvre d'un an en sacrifice pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Et le sacrificateur fera l'expiation pour la personne qui a péché par erreur, pour le péché qu'elle a commis par erreur, devant l'Éternel, afin de faire l'expiation pour elle; et il lui sera pardonné. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Il y aura pour vous une même loi, quant à celui qui fait quelque chose par erreur, pour celui qui est né parmi les enfants d'Israël et pour l'étranger séjournant parmi eux. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Mais pour celui qui agira à main levée, qu'il soit né au pays ou étranger, il outrage l'Éternel; cette personne sera retranchée du milieu de son peuple; ");
INSERT INTO fra_fob_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Car elle a méprisé la parole de l'Éternel, et elle a enfreint son commandement: cette personne doit être retranchée; son iniquité sera sur elle. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Or, les enfants d'Israël, étant au désert, trouvèrent un homme qui ramassait du bois, le jour du sabbat. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Et ceux qui le trouvèrent ramassant du bois, l'amenèrent à Moïse et à Aaron, et à toute l'assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Et ils le mirent en prison; car ce qu'on devait lui faire n'avait pas été déclaré. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Alors l'Éternel dit à Moïse: Cet homme sera puni de mort; que toute l'assemblée le lapide hors du camp. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Toute l'assemblée le fit donc sortir du camp, et le lapida, et il mourut, comme l'Éternel l'avait commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Parle aux enfants d'Israël, et dis-leur qu'ils se fassent, d'âge en âge, une frange aux pans de leurs vêtements, et qu'ils mettent sur cette frange de leurs pans un cordon de pourpre. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ce sera votre frange; et, en la voyant, vous vous souviendrez de tous les commandements de l'Éternel, et vous les ferez, et vous ne suivrez point les désirs de votre cœur et de vos yeux, que vous suivez pour tomber dans l'infidélité; ");
INSERT INTO fra_fob_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Afin que vous vous souveniez de tous mes commandements, et que vous les pratiquiez, et que vous soyez saints à votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Je suis l'Éternel votre Dieu, qui vous ai fait sortir du pays d'Égypte pour être votre Dieu. Je suis l'Éternel votre Dieu. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Or, Coré, fils de Jitsehar, fils de Kehath, fils de Lévi, fit une entreprise avec Dathan et Abiram, fils d'Éliab, et On, fils de Péleth, enfants de Ruben; ");
INSERT INTO fra_fob_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Et ils s'élevèrent contre Moïse, avec deux cent cinquante hommes des enfants d'Israël, des principaux de l'assemblée, qu'on appelait au conseil, des hommes de renom. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ils s'assemblèrent donc contre Moïse et contre Aaron, et leur dirent: Que cela vous suffise! car tous ceux de l'assemblée sont consacrés, et l'Éternel est au milieu d'eux; pourquoi donc vous élevez-vous au-dessus de l'assemblée de l'Éternel? ");
INSERT INTO fra_fob_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Moïse, entendant cela, se jeta sur son visage. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Et il parla à Coré et à tous ceux qui étaient assemblés avec lui, en disant: Demain matin, l'Éternel fera connaître qui est à lui, et qui est consacré, et il le fera approcher de lui; il fera approcher de lui celui qu'il aura choisi. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Faites ceci: Prenez des encensoirs, Coré, et tous ceux qui sont assemblés avec lui; ");
INSERT INTO fra_fob_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Et demain mettez-y du feu, et déposez-y du parfum devant l'Éternel; et l'homme que l'Éternel choisira, c'est celui-là qui lui est consacré. Que cela vous suffise, enfants de Lévi! ");
INSERT INTO fra_fob_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Et Moïse dit à Coré: Écoutez maintenant, enfants de Lévi. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Est-ce trop peu pour vous, que le Dieu d'Israël vous ait séparés de l'assemblée d'Israël, pour vous faire approcher de lui, afin de faire le service de la Demeure de l'Éternel, et pour assister devant l'assemblée, afin de la servir; ");
INSERT INTO fra_fob_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Et qu'il t'ait fait approcher, ainsi que tous tes frères, les enfants de Lévi avec toi, que vous recherchiez encore le sacerdoce? ");
INSERT INTO fra_fob_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","C'est pourquoi, toi et tous ceux qui sont assemblés avec toi, vous vous êtes assemblés contre l'Éternel! Car qui est Aaron, que vous murmuriez contre lui? ");
INSERT INTO fra_fob_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Et Moïse envoya appeler Dathan et Abiram, fils d'Éliab; mais ils répondirent: Nous ne monterons pas. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Est-ce peu de chose que tu nous aies fait monter hors d'un pays où coulent le lait et le miel, pour nous faire mourir dans le désert, que tu veuilles aussi dominer sur nous? ");
INSERT INTO fra_fob_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Certes, tu ne nous as pas fait venir dans un pays où coulent le lait et le miel! Et tu ne nous as pas donné un héritage de champs ni de vignes! Veux-tu crever les yeux de ces gens? Nous ne monterons pas. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Et Moïse fut fort irrité, et il dit à l'Éternel: Ne regarde point à leur offrande; je n'ai pas pris d'eux un seul âne, et je n'ai point fait de mal à un seul d'entre eux. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Puis Moïse dit à Coré: Toi et tous ceux qui sont assemblés avec toi, trouvez-vous demain devant l'Éternel, toi et eux, avec Aaron. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Et prenez chacun votre encensoir, mettez-y du parfum, et présentez devant l'Éternel chacun votre encensoir, deux cent cinquante encensoirs; toi et Aaron, ayez aussi chacun votre encensoir. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ils prirent donc chacun leur encensoir, ils y mirent du feu, et y déposèrent du parfum, et ils se tinrent à l'entrée du tabernacle d'assignation, ainsi que Moïse et Aaron. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Et Coré réunit contre eux toute l'assemblée, à l'entrée du tabernacle d'assignation, et la gloire de l'Éternel apparut à toute l'assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Puis l'Éternel parla à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Séparez-vous du milieu de cette assemblée, et je les consumerai en un moment. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Et ils se jetèrent sur leur visage, et dirent: O Dieu, Dieu des esprits de toute chair, un seul homme a péché, et tu t'indignerais contre toute l'assemblée! ");
INSERT INTO fra_fob_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Parle à l'assemblée, et dis-lui: Retirez-vous d'autour de la demeure de Coré, de Dathan et d'Abiram. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Et Moïse se leva et alla vers Dathan et Abiram; et les anciens d'Israël le suivirent. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Et il parla à l'assemblée, en disant: Éloignez-vous maintenant des tentes de ces hommes méchants, et ne touchez à rien qui leur appartienne, de peur que vous ne périssiez pour tous leurs péchés. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ils se retirèrent donc d'autour de la demeure de Coré, de Dathan et d'Abiram. Et Dathan et Abiram sortirent, et se tinrent debout à l'entrée de leurs tentes, avec leurs femmes, leurs fils et leurs petits enfants. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Et Moïse dit: A ceci vous connaîtrez que l'Éternel m'a envoyé pour faire toutes ces choses, et que je n'ai rien fait de moi-même: ");
INSERT INTO fra_fob_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si ces gens-là meurent comme tous les hommes meurent, et s'ils sont punis comme tous les hommes le sont, l'Éternel ne m'a point envoyé; ");
INSERT INTO fra_fob_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Mais si l'Éternel crée une chose toute nouvelle, et que la terre ouvre sa bouche, et les engloutisse avec tout ce qui leur appartient, et qu'ils descendent vivants au Sépulcre, vous saurez que ces hommes ont méprisé l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Et dès qu'il eut achevé de prononcer toutes ces paroles, le sol qui était sous eux, se fendit; ");
INSERT INTO fra_fob_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Et la terre ouvrit sa bouche, et les engloutit avec leurs familles, et tous les hommes qui étaient à Coré, et tout leur bien. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ils descendirent, eux et tout ce qui leur appartenait, vivants au Sépulcre, et la terre les couvrit; et ils périrent du milieu de l'assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Et tout Israël, qui était autour d'eux, s'enfuit à leur cri; car ils disaient: Prenons garde que la terre ne nous engloutisse! ");
INSERT INTO fra_fob_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Et un feu sortit, de la part de l'Éternel, et dévora les deux cent cinquante hommes qui offraient le parfum. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Puis l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Dis à Éléazar, fils d'Aaron, le sacrificateur, qu'il ramasse les encensoirs du milieu de l'embrasement, et répands-en le feu au loin; car ils ont été consacrés. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Quant aux encensoirs de ceux qui ont péché contre leurs âmes, qu'on en fasse de larges plaques pour couvrir l'autel. Puisqu'ils les ont présentés devant l'Éternel, ils ont été consacrés; et ils serviront de signe aux enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Éléazar, le sacrificateur, prit donc les encensoirs d'airain qu'avaient présentés ceux qui avaient été brûlés, et l'on en fit des plaques pour couvrir l'autel, ");
INSERT INTO fra_fob_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","En mémorial aux enfants d'Israël, afin qu'un étranger, qui n'est point de la race d'Aaron, ne s'approche point pour faire fumer le parfum devant l'Éternel, et qu'il ne soit comme Coré et comme ceux qui s'assemblèrent avec lui, ainsi que l'Éternel le lui avait dit par Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Or le lendemain, toute l'assemblée des enfants d'Israël murmura contre Moïse et contre Aaron, en disant: Vous avez fait mourir le peuple de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Et il arriva, comme l'assemblée se formait contre Moïse et contre Aaron, qu'ils regardèrent vers le tabernacle d'assignation, et voici, la nuée le couvrit, et la gloire de l'Éternel apparut. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Et Moïse et Aaron vinrent devant le tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Otez-vous du milieu de cette assemblée, et je les consumerai en un moment. Mais ils tombèrent sur leurs visages, ");
INSERT INTO fra_fob_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Et Moïse dit à Aaron: Prends l'encensoir, mets-y du feu de dessus l'autel et déposes-y du parfum, et va promptement vers l'assemblée, et fais l'expiation pour eux; car l'indignation est sortie de devant l'Éternel; la plaie a commencé. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Et Aaron prit l'encensoir, comme Moïse le lui avait dit, et il courut au milieu de l'assemblée; et voici, la plaie avait déjà commencé parmi le peuple. Alors il mit le parfum, et fit l'expiation pour le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Et il se tint entre les morts et les vivants, et la plaie fut arrêtée. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Et il y en eut quatorze mille sept cents qui moururent de la plaie, outre ceux qui étaient morts à cause de Coré. ");
INSERT INTO fra_fob_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Puis Aaron retourna vers Moïse, à l'entrée du tabernacle d'assignation, et la plaie fut arrêtée. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Puis l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Parle aux enfants d'Israël, et prends d'eux une verge selon les maisons de leurs pères, c'est-à-dire douze verges, de tous leurs princes, selon les maisons de leurs pères; tu écriras le nom de chacun sur sa verge. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Et tu écriras le nom d'Aaron sur la verge de Lévi; car il y aura une verge pour chaque chef des maisons de leurs pères. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Et tu les déposeras dans le tabernacle d'assignation, devant le Témoignage, où je me réunis à vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Et il arrivera que la verge de l'homme que je choisirai, fleurira; et je ferai cesser devant moi les murmures que les enfants d'Israël murmurent contre vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moïse parla aux enfants d'Israël, et tous leurs princes lui donnèrent, selon les maisons de leurs pères, chacun une verge, c'est-à-dire douze verges. Et la verge d'Aaron était au milieu de leurs verges. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Et Moïse déposa les verges devant l'Éternel, dans le tabernacle du Témoignage. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Et il arriva, le lendemain, que Moïse entra au tabernacle du Témoignage, et voici la verge d'Aaron, pour la maison de Lévi, avait fleuri: elle avait poussé des boutons, produit des fleurs, et mûri des amandes. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Alors Moïse retira de devant l'Éternel toutes les verges, et les présenta à tous les enfants d'Israël; et ils les virent, et ils reprirent chacun leur verge. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Et l'Éternel dit à Moïse: Reporte la verge d'Aaron devant le Témoignage, pour être gardée comme un signe pour les enfants de rébellion; et tu feras cesser devant moi leurs murmures, et ils ne mourront point. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Et Moïse le fit; il fit comme l'Éternel le lui avait commandé. ");
INSERT INTO fra_fob_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Et les enfants d'Israël dirent à Moïse: Voici, nous expirons, nous sommes perdus, nous sommes tous perdus! ");
INSERT INTO fra_fob_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Quiconque s'approche de la Demeure de l'Éternel, meurt. Expirerons-nous donc entièrement? ");
INSERT INTO fra_fob_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Alors l'Éternel dit à Aaron: Toi et tes fils, et la maison de ton père avec toi, vous porterez l'iniquité du sanctuaire; et toi, et tes fils avec toi, vous porterez l'iniquité de votre sacerdoce. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Fais aussi approcher avec toi tes frères, la tribu de Lévi, la tribu de ton père, qu'ils se joignent à toi et qu'ils te servent; et toi et tes fils avec toi, vous serez devant le tabernacle du Témoignage. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ils observeront ce que tu leur ordonneras, et ce qui concerne tout le tabernacle; seulement ils n'approcheront point des objets sacrés, ni de l'autel, de peur qu'ils ne meurent et vous avec eux. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ils te seront donc adjoints, et ils observeront ce qui concerne le tabernacle d'assignation, pour tout le service du tabernacle, et nul étranger n'approchera de vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Et vous observerez ce qui concerne le sanctuaire et l'autel, afin qu'il n'y ait plus d'indignation contre les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Quant à moi, voici, j'ai pris vos frères les Lévites, du milieu des enfants d'Israël; ils vous sont donnés en don pour l'Éternel, pour faire le service du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Mais toi, et tes fils avec toi, vous vous acquitterez avec soin de votre sacerdoce, en tout ce qui concerne l'autel et ce qui est en dedans du voile; et vous y ferez le service. Je vous donne le sacerdoce en office de pur don; et l'étranger qui en approchera, sera puni de mort. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","L'Éternel dit encore à Aaron: Voici, je t'ai donné la garde de mes offrandes prélevées sur toutes les choses consacrées par les enfants d'Israël; je te les ai données, et à tes enfants, par ordonnance perpétuelle, comme droit conféré par l'onction. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ceci t'appartiendra, d'entre les choses très saintes qui ne sont pas consumées: toutes leurs offrandes, dans toutes leurs oblations, dans tous leurs sacrifices pour le péché, et dans tous leurs sacrifices pour le délit, qu'ils m'apporteront; ces choses très saintes seront pour toi et pour tes enfants. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Tu les mangeras dans le lieu très-saint; tout mâle en mangera; ce sera pour toi une chose sacrée. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ceci aussi t'appartiendra: l'offrande prélevée de leurs dons, sur toutes les offrandes agitées des enfants d'Israël; je te les ai données, à toi, à tes fils et à tes filles avec toi, par ordonnance perpétuelle. Quiconque sera pur dans ta maison en mangera. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Je t'ai donné aussi leurs prémices qu'ils offriront à l'Éternel, tout le meilleur de l'huile, et tout le meilleur du moût et du froment. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Les premiers fruits de tout ce que leur terre produira, et qu'ils apporteront à l'Éternel, t'appartiendront; quiconque sera pur dans ta maison en mangera. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Tout ce qui sera dévoué par interdit en Israël t'appartiendra. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Tout premier-né, de toute chair, qu'ils offriront à l'Éternel, soit des hommes soit des bêtes, t'appartiendra; seulement, tu rachèteras le premier-né de l'homme; tu rachèteras aussi le premier-né d'une bête impure. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Quant à son rachat, tu le rachèteras depuis l'âge d'un mois, d'après ton estimation, au prix de cinq sicles d'argent, selon le sicle du sanctuaire, qui est de vingt oboles. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mais tu ne rachèteras point le premier-né de la vache, ni le premier-né de la brebis, ni le premier-né de la chèvre; ce sont des choses sacrées. Tu répandras leur sang sur l'autel, et tu feras fumer leur graisse en sacrifice fait par le feu, d'agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Et leur chair t'appartiendra; elle t'appartiendra comme la poitrine qu'on agite, et comme la jambe droite. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Je t'ai donné toutes les offrandes prélevées sur les choses sacrées que les enfants d'Israël offriront à l'Éternel, à toi, à tes fils, et à tes filles avec toi, par ordonnance perpétuelle; c'est une alliance incorruptible, perpétuelle devant l'Éternel, pour toi et pour ta postérité avec toi. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Puis l'Éternel dit à Aaron: Tu n'auras point d'héritage en leur pays; tu n'auras point de portion au milieu d'eux; je suis ta portion et ton héritage au milieu des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Et quant aux enfants de Lévi, voici, je leur ai donné pour héritage toutes les dîmes d'Israël, en échange du service qu'ils font, le service du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Et les enfants d'Israël n'approcheront plus du tabernacle d'assignation, de peur qu'ils ne se chargent d'un péché et qu'ils ne meurent. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Mais ce sont les Lévites qui feront le service du tabernacle d'assignation, et ce sont eux qui porteront leur iniquité; ce sera une ordonnance perpétuelle dans vos générations; et ils ne posséderont point d'héritage au milieu des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Car j'ai donné pour héritage aux Lévites les dîmes des enfants d'Israël, qu'ils prélèveront pour l'Éternel en offrande; c'est pourquoi, j'ai dit d'eux: Ils ne posséderont point d'héritage au milieu des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Puis l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Tu parleras aussi aux Lévites, et tu leur diras: Quand vous aurez reçu des enfants d'Israël la dîme que je vous ai donnée sur eux pour votre héritage, vous en prélèverez l'offrande de l'Éternel, la dîme de la dîme. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Et votre offrande prélevée vous sera comptée comme le froment de l'aire et comme l'abondance de la cuve. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ainsi, vous prélèverez, vous aussi, l'offrande de l'Éternel sur toutes vos dîmes, que vous recevrez des enfants d'Israël; et vous en donnerez l'offrande de l'Éternel à Aaron, le sacrificateur. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Vous prélèverez toute l'offrande de l'Éternel, sur toutes les choses qui vous seront données; sur tout ce qu'il y aura de meilleur, vous prélèverez la portion consacrée. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Et tu leur diras: Quand vous aurez prélevé le meilleur de la dîme, elle sera comptée aux Lévites comme le revenu de l'aire et comme le revenu de la cuve. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Et vous la mangerez en un lieu quelconque, vous et votre famille; car c'est votre salaire, en échange de votre service dans le tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Et par là vous ne vous chargerez d'aucun péché, quand vous en aurez prélevé ce qu'il y a de meilleur, et vous ne profanerez point les choses sacrées des enfants d'Israël, et vous ne mourrez point. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","L'Éternel parla encore à Moïse et à Aaron, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Voici l'ordonnance de la loi que l'Éternel a commandée, en disant: Parle aux enfants d'Israël, et qu'ils t'amènent une vache rousse, intacte, qui n'ait point de défaut et qui n'ait point porté le joug. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Puis vous la donnerez à Éléazar, le sacrificateur, qui la mènera hors du camp, et on l'égorgera en sa présence. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ensuite Éléazar, le sacrificateur, prendra de son sang avec son doigt, et il fera sept fois aspersion de son sang, sur le devant du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Et on brûlera la vache devant ses yeux; on brûlera sa peau, sa chair et son sang, avec ses excréments. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Et le sacrificateur prendra du bois de cèdre, de l'hysope et du cramoisi, et les jettera au milieu du feu où brûlera la vache. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Puis le sacrificateur lavera ses vêtements et sa chair dans l'eau, et après cela il rentrera au camp; et le sacrificateur sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Et celui qui l'aura brûlée lavera ses vêtements dans l'eau et baignera sa chair dans l'eau, et il sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Et un homme pur ramassera la cendre de la vache, et la déposera hors du camp dans un lieu pur; et on la gardera pour l'assemblée des enfants d'Israël, pour en faire l'eau de purification. C'est une purification pour le péché. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Et celui qui aura ramassé la cendre de la vache lavera ses vêtements, et il sera souillé jusqu'au soir; et ce sera une ordonnance perpétuelle pour les enfants d'Israël et pour l'étranger séjournant au milieu d'eux. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Celui qui touchera un corps mort, de quelque personne que ce soit, sera souillé sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Il se purifiera avec cette eau le troisième jour, et au septième jour il sera pur; que s'il ne se purifie pas au troisième jour ni au septième jour, il ne sera pas pur. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Quiconque aura touché un mort, une personne qui sera morte, et ne se sera point purifié, a souillé la Demeure de l'Éternel; cette personne sera retranchée d'Israël; puisque l'eau de purification n'a pas été répandue sur lui, il est souillé; sa souillure est encore sur lui. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Voici la loi: Quand un homme mourra dans une tente, quiconque entrera dans la tente, et tout ce qui sera dans la tente, sera souillé sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Et tout vase découvert, sur lequel il n'y a point de couvercle attaché, sera souillé. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Et quiconque touchera, dans les champs, un homme tué par l'épée, ou un mort, ou des ossements humains, ou un tombeau, sera souillé sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Et on prendra, pour celui qui sera souillé, de la cendre de ce qui a été brûlé pour le péché, et on mettra dessus, dans un vase, de l'eau vive; ");
INSERT INTO fra_fob_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Et un homme pur prendra de l'hysope, et la trempera dans l'eau et en fera aspersion sur la tente, sur tous les vases et sur les personnes qui y sont, et sur celui qui a touché des ossements, ou un homme tué, ou un mort, ou un tombeau. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","L'homme pur fera aspersion sur celui qui sera souillé, au troisième jour et au septième, et le purifiera le septième. Il lavera ses vêtements, et se lavera dans l'eau; et le soir il sera pur. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Mais quant à l'homme qui sera souillé et ne se purifiera point, cette personne sera retranchée du milieu de l'assemblée, car elle a souillé le sanctuaire de l'Éternel. L'eau de purification n'a pas été répandue sur lui, il est souillé. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Et ce sera pour eux une ordonnance perpétuelle. Celui qui aura fait aspersion de l'eau de purification lavera ses vêtements; et celui qui touchera l'eau de purification sera souillé jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Et tout ce que l'homme souillé touchera, sera souillé; et la personne qui le touchera, sera souillée jusqu'au soir. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Or, les enfants d'Israël, toute l'assemblée, arrivèrent au désert de Tsin, au premier mois, et le peuple s'arrêta à Kadès; et Marie mourut là, et y fut ensevelie. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Et il n'y avait point d'eau pour le peuple, et ils s'assemblèrent contre Moïse et contre Aaron. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Et le peuple contesta avec Moïse, et ils dirent: Plût à Dieu que nous fussions morts, quand nos frères moururent devant l'Éternel! ");
INSERT INTO fra_fob_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Pourquoi avez-vous fait venir l'assemblée de l'Éternel dans ce désert, pour que nous y mourions, nous et notre bétail? ");
INSERT INTO fra_fob_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Pourquoi nous avez-vous fait monter hors d'Égypte, pour nous amener en ce méchant lieu, qui n'est point un lieu pour semer, ni pour des figuiers, ni pour la vigne, ni pour les grenadiers, et où il n'y a point d'eau à boire? ");
INSERT INTO fra_fob_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Alors Moïse et Aaron se retirèrent de devant l'assemblée, à l'entrée du tabernacle d'assignation; et ils tombèrent sur leur visage, et la gloire de l'Éternel leur apparut. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Prends la verge, et convoque l'assemblée, toi et Aaron, ton frère, et parlez au rocher en leur présence, et il donnera ses eaux; tu leur feras sortir de l'eau du rocher, et tu abreuveras l'assemblée et leur bétail. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moïse prit donc la verge de devant l'Éternel, comme il le lui avait commandé. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moïse et Aaron convoquèrent l'assemblée devant le rocher; et il leur dit: Écoutez donc, rebelles! Vous ferons-nous sortir de l'eau de ce rocher? ");
INSERT INTO fra_fob_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Et Moïse leva la main, et frappa le rocher avec sa verge, par deux fois; alors des eaux sortirent en abondance, et l'assemblée but, et leur bétail aussi. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Puis l'Éternel dit à Moïse et à Aaron: Parce que vous n'avez pas cru en moi, pour me sanctifier devant les enfants d'Israël, à cause de cela vous n'introduirez point cette assemblée dans le pays que je leur ai donné. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ce sont là les eaux de Mériba (contestation), où les enfants d'Israël contestèrent avec l'Éternel; et il se sanctifia en eux. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Puis Moïse envoya, de Kadès, des messagers au roi d'Édom, pour lui dire: Ainsi a dit ton frère Israël: Tu sais tous les maux qui nous sont survenus; ");
INSERT INTO fra_fob_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Comment nos pères descendirent en Égypte; et nous avons demeuré longtemps en Égypte, et les Égyptiens nous ont maltraités, nous et nos pères; ");
INSERT INTO fra_fob_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Et nous avons crié à l'Éternel, et il a entendu notre voix. Il a envoyé un ange, et nous a fait sortir d'Égypte. Et voici, nous sommes à Kadès, ville qui est à l'extrémité de ta frontière; ");
INSERT INTO fra_fob_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Permets que nous passions par ton pays; nous ne passerons ni par les champs, ni par les vignes, et nous ne boirons pas l'eau des puits; nous marcherons par le chemin royal, nous ne nous détournerons ni à droite ni à gauche, jusqu'à ce que nous ayons passé ta frontière. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mais Édom lui dit: Tu ne passeras point chez moi, de peur que je ne sorte à ta rencontre avec l'épée. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Les enfants d'Israël lui répondirent: Nous monterons par le grand chemin; et si nous buvons tes eaux, moi et mes troupeaux, je les paierai. Seulement que j'y passe de mes pieds; pas autre chose. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mais il dit: Tu ne passeras point. Et Édom sortit à sa rencontre avec une grande multitude et à main armée. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ainsi Édom refusa à Israël la permission de passer par sa frontière; et Israël se détourna de lui. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Et les enfants d'Israël, toute l'assemblée, partirent de Kadès et vinrent à la montagne de Hor. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Et l'Éternel parla à Moïse et à Aaron, dans la montagne de Hor, sur la frontière du pays d'Édom, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron sera recueilli vers ses peuples; car il n'entrera point au pays que j'ai donné aux enfants d'Israël, parce que vous avez été rebelles à mon commandement, aux eaux de Mériba. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Prends Aaron et Éléazar, son fils, et fais-les monter sur la montagne de Hor; ");
INSERT INTO fra_fob_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Puis dépouille Aaron de ses vêtements, et revêts-en Éléazar son fils; et Aaron sera recueilli, et mourra là. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moïse fit donc comme l'Éternel avait commandé; et ils montèrent sur la montagne de Hor, à la vue de toute l'assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Et Moïse dépouilla Aaron de ses vêtements, et en revêtit Éléazar son fils. Or Aaron mourut là, au sommet de la montagne; et Moïse et Éléazar descendirent de la montagne. ");
INSERT INTO fra_fob_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Et toute l'assemblée vit qu'Aaron avait expiré; et toute la maison d'Israël pleura Aaron pendant trente jours. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Quand le Cananéen, roi d'Arad, qui habitait le Midi, apprit qu'Israël venait par le chemin des espions, il combattit contre Israël, et il en emmena des prisonniers. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Alors Israël fit un vœu à l'Éternel, et dit: Si tu livres ce peuple entre mes mains, je vouerai ses villes à l'interdit. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Et l'Éternel exauça la voix d'Israël et livra les Cananéens. On les voua à l'interdit, eux et leurs villes; et on nomma le lieu Horma (extermination). ");
INSERT INTO fra_fob_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Puis ils partirent de la montagne de Hor, dans la direction de la mer Rouge, pour faire le tour du pays d'Édom; et le peuple perdit courage en chemin. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Le peuple parla donc contre Dieu et contre Moïse, et dit: Pourquoi nous avez-vous fait monter hors d'Égypte, pour mourir dans le désert? car il n'y a point de pain, ni d'eau, et notre âme est dégoûtée de ce pain misérable. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Et l'Éternel envoya parmi le peuple des serpents brûlants, qui mordirent le peuple, en sorte qu'un grand nombre d'Israélites moururent. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Alors le peuple vint vers Moïse, et ils dirent: Nous avons péché, car nous avons parlé contre l'Éternel et contre toi. Prie l'Éternel, pour qu'il éloigne de nous les serpents. Et Moïse pria pour le peuple. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Et l'Éternel dit à Moïse: Fais-toi un serpent brûlant, et mets-le sur une perche; et il arrivera que quiconque sera mordu et le regardera, sera guéri. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moïse fit donc un serpent d'airain, et il le mit sur une perche; et il arriva que quand le serpent avait mordu un homme, il regardait le serpent d'airain, et il était guéri. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Puis les enfants d'Israël partirent et campèrent à Oboth. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Et ils partirent d'Oboth, et campèrent à Ijjé-Abarim, au désert qui est vis-à-vis de Moab, vers le soleil levant. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","De là ils partirent et campèrent au torrent de Zéred. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","De là ils partirent et campèrent au delà de l'Arnon, qui est dans le désert, au sortir de la frontière des Amoréens; car l'Arnon est la frontière de Moab, entre les Moabites et les Amoréens. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","C'est pourquoi il est dit, au livre des batailles de l'Éternel: Vaheb en Supha, et les torrents de l'Arnon, ");
INSERT INTO fra_fob_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","Et le cours des torrents qui tend vers le lieu où Ar est située, et qui s'appuie à la frontière de Moab. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Et de là ils vinrent à Beer (puits), c'est là le puits dont l'Éternel dit à Moïse: Assemble le peuple, et je leur donnerai de l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Alors Israël chanta ce cantique: Monte, puits! Chantez-lui en vous répondant. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Puits que les seigneurs ont creusé, que les principaux du peuple ont creusé, avec le sceptre, avec leurs bâtons! Ensuite, du désert ils vinrent à Matthana; ");
INSERT INTO fra_fob_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Et de Matthana à Nahaliel; Et de Nahaliel à Bamoth; ");
INSERT INTO fra_fob_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Et de Bamoth à la vallée qui est au territoire de Moab, au sommet du Pisga, en regard de la plaine du désert. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Or, Israël envoya des ambassadeurs à Sihon, roi des Amoréens, pour lui dire: ");
INSERT INTO fra_fob_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Permets que je passe par ton pays; nous ne nous détournerons point dans les champs, ni dans les vignes, et nous ne boirons point l'eau des puits; nous marcherons par le chemin royal jusqu'à ce que nous ayons passé ta frontière. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mais Sihon ne permit point à Israël de passer par sa frontière; et Sihon assembla tout son peuple, et sortit à la rencontre d'Israël vers le désert, et il vint à Jahats, et combattit contre Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Mais Israël le frappa du tranchant de l'épée, et conquit son pays, depuis l'Arnon jusqu'au Jabbok, jusqu'aux enfants d'Ammon; car la frontière des enfants d'Ammon était forte. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Et Israël prit toutes ces villes, et Israël habita dans toutes les villes des Amoréens, à Hesbon, et dans toutes les villes de son ressort. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Car Hesbon était la ville de Sihon, roi des Amoréens, qui avait fait la guerre au roi précédent de Moab, et lui avait pris tout son pays jusqu'à l'Arnon. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","C'est pourquoi les poètes disent: Venez à Hesbon; que la ville de Sihon soit bâtie et rétablie! ");
INSERT INTO fra_fob_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Car un feu est sorti de Hesbon, une flamme de la ville de Sihon; elle a dévoré Ar de Moab, les maîtres des hauteurs de l'Arnon. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Malheur à toi, Moab! tu es perdu, peuple de Kemosh! Il a laissé ses fils fugitifs, et ses filles en captivité à Sihon, roi des Amoréens. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Et nous les avons transpercés. Hesbon a péri, jusqu'à Dibon. Nous avons ravagé jusqu'à Nophach par le feu, jusqu'à Médeba. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Israël habita donc dans le pays des Amoréens. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Puis Moïse envoya reconnaître Jaezer, et ils prirent les villes de son ressort, et dépossédèrent les Amoréens qui y étaient. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Puis ils tournèrent et montèrent dans la direction de Bassan; et Og, roi de Bassan, sortit à leur rencontre, lui et tout son peuple, pour combattre à Édréi. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Mais l'Éternel dit à Moïse: Ne le crains point; car je l'ai livré entre tes mains, et tout son peuple, et son pays; et tu lui feras comme tu as fait à Sihon, roi des Amoréens, qui habitait à Hesbon. ");
INSERT INTO fra_fob_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ils le battirent donc, lui et ses fils, et tout son peuple, au point qu'il ne lui resta personne; et ils possédèrent son pays. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Puis, les enfants d'Israël partirent, et campèrent dans les plaines de Moab, au delà du Jourdain de Jérico. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Or Balak, fils de Tsippor, vit tout ce qu'Israël avait fait à l'Amoréen. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Et Moab eut une grande peur de ce peuple, parce qu'il était nombreux; et Moab fut effrayé en face des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moab dit donc aux anciens de Madian: Maintenant cette multitude va tout dévorer autour de nous, comme le bœuf broute l'herbe des champs. Or, en ce temps-là, Balak, fils de Tsippor, était roi de Moab. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Et il envoya des messagers à Balaam, fils de Béor, à Pethor, située sur le fleuve, au pays des enfants de son peuple, pour l'appeler, en disant: Voici, un peuple est sorti d'Égypte; voici, il couvre la face de la terre, et il s'est établi vis-à-vis de moi. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Viens donc maintenant, je te prie; maudis-moi ce peuple, car il est plus puissant que moi. Peut-être que je pourrai le battre, et que je le chasserai du pays; car je sais que celui que tu bénis est béni, et que celui que tu maudis est maudit. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Les anciens de Moab s'en allèrent donc, avec les anciens de Madian, ayant en leur main des présents pour le devin; et ils vinrent à Balaam, et lui rapportèrent les paroles de Balak. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Et il leur répondit: Demeurez ici cette nuit, et je vous rendrai réponse, selon que l'Éternel me parlera. Et les seigneurs de Moab demeurèrent chez Balaam. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Or, Dieu vint à Balaam, et lui dit: Qui sont ces hommes que tu as chez toi? ");
INSERT INTO fra_fob_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Et Balaam répondit à Dieu: Balak, fils de Tsippor, roi de Moab, a envoyé vers moi, pour me dire: ");
INSERT INTO fra_fob_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Voici un peuple est sorti d'Égypte, et il couvre la face de la terre; viens maintenant, maudis-le-moi; peut-être que je pourrai le combattre, et que je le chasserai. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Et Dieu dit à Balaam: Tu n'iras point avec eux, tu ne maudiras point ce peuple, car il est béni. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Et Balaam se leva au matin, et dit aux seigneurs envoyés par Balak: Retournez en votre pays; car l'Éternel a refusé de me laisser aller avec vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Les seigneurs de Moab se levèrent donc, et revinrent auprès de Balak, et dirent: Balaam a refusé de venir avec nous. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Et Balak lui envoya encore des seigneurs en plus grand nombre et plus considérables que les premiers; ");
INSERT INTO fra_fob_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Et ils vinrent à Balaam, et lui dirent: Ainsi a dit Balak, fils de Tsippor: Ne te refuse pas, je te prie, à venir vers moi; ");
INSERT INTO fra_fob_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Car je te rendrai beaucoup d'honneurs, et je ferai tout ce que tu me diras; viens, je te prie, maudis-moi ce peuple. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Mais Balaam répondit aux serviteurs de Balak: Quand Balak me donnerait sa maison pleine d'argent et d'or, je ne pourrais pas transgresser l'ordre de l'Éternel, mon Dieu, pour faire une chose petite ou grande. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Toutefois, demeurez ici, je vous prie, vous aussi cette nuit, que je sache ce que l'Éternel continuera de me dire. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Et Dieu vint à Balaam la nuit, et lui dit: Si ces hommes sont venus pour t'appeler, lève-toi, va avec eux; mais tu ne feras que ce que je te dirai. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam se leva donc le matin, sella son ânesse, et s'en alla avec les seigneurs de Moab. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Mais la colère de Dieu s'embrasa parce qu'il s'en allait; et un ange de l'Éternel se tint dans le chemin pour s'opposer à lui. Or, il était monté sur son ânesse, et ses deux serviteurs étaient avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Et l'ânesse vit l'ange de l'Éternel qui se tenait dans le chemin, son épée nue dans la main; et l'ânesse se dé-tourna du chemin et s'en alla dans les champs, et Balaam frappa l'ânesse pour la ramener dans le chemin. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Mais l'ange de l'Éternel se tint dans un sentier de vignes, qui avait un mur d'un côté et un mur de l'autre. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Et l'ânesse vit l'ange de l'Éternel, et se serra contre la muraille, et elle serra contre la muraille le pied de Balaam, qui continua à la frapper. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Et l'ange de l'Éternel passa plus avant, et s'arrêta dans un lieu étroit où il n'y avait pas de chemin pour se détourner à droite ni à gauche. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Et l'ânesse vit l'ange de l'Éternel, et se coucha sous Balaam. Mais la colère de Balaam s'enflamma, et il frappa l'ânesse avec un bâton. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Alors l'Éternel ouvrit la bouche de l'ânesse, et elle dit à Balaam: Que t'ai-je fait, que tu m'aies déjà frappée trois fois? ");
INSERT INTO fra_fob_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Et Balaam répondit à l'ânesse: C'est que tu t'es moquée de moi. Que n'ai-je une épée en ma main! je t'aurais déjà tuée. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Et l'ânesse dit à Balaam: Ne suis-je pas ton ânesse, que tu as montée depuis que tu existes jusqu'à ce jour? Ai-je l'habitude d'agir ainsi à ton égard? Et il répondit: Non. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Alors l'Éternel ouvrit les yeux de Balaam, et il vit l'ange de l'Éternel qui se tenait dans le chemin, son épée nue dans la main; et il s'inclina et se prosterna sur son visage. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Et l'ange de l'Éternel lui dit: Pourquoi as-tu frappé ton ânesse déjà trois fois? Voici, je suis sorti pour m'opposer à toi, car tu suis un chemin pernicieux devant moi. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Or l'ânesse m'a vu, et s'est détournée devant moi déjà trois fois; et si elle ne se fût détournée de devant moi, je t'aurais même déjà tué et je l'aurais laissée en vie. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Alors Balaam dit à l'ange de l'Éternel: J'ai péché; car je ne savais point que tu te tinsses dans le chemin contre moi; et maintenant, si cela te déplaît, je m'en retournerai. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Et l'ange de l'Éternel dit à Balaam: Va avec ces hommes; mais tu ne diras que ce que je te dirai. Et Balaam s'en alla avec les seigneurs de Balak. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Quand Balak apprit que Balaam venait, il sortit à sa rencontre, vers la ville de Moab, qui est sur la frontière de l'Arnon, à l'extrémité de la frontière. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Et Balak dit à Balaam: N'ai-je pas envoyé vers toi, pour t'appeler? Pourquoi n'es-tu pas venu vers moi? Ne puis-je pas vraiment te traiter avec honneur? ");
INSERT INTO fra_fob_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Et Balaam répondit à Balak: Voici, je suis venu vers toi; mais pourrais-je maintenant prononcer quelque chose? Je dirai ce que Dieu me mettra dans la bouche. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Et Balaam s'en alla avec Balak, et ils vinrent à la ville de Hutsoth. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Et Balak sacrifia des bœufs et des brebis, et en envoya à Balaam et aux seigneurs qui étaient avec lui. ");
INSERT INTO fra_fob_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Et quand le matin fut venu, il prit Balaam, et le fit monter aux hauts lieux de Baal, et de là il vit l'extrémité du peuple. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Or Balaam dit à Balak: Construis-moi ici sept autels, et prépare-moi ici sept taureaux et sept béliers. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Et Balak fit comme Balaam avait dit; et Balak et Balaam offrirent un taureau et un bélier sur chaque autel. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Puis Balaam dit à Balak: Tiens-toi près de ton holocauste, et je m'en irai; peut-être que l'Éternel se présentera à moi, et je te rapporterai ce qu'il m'aura fait voir. Et il alla en un lieu découvert. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Et Dieu vint au-devant de Balaam, et Balaam lui dit: J'ai dressé les sept autels, et j'ai sacrifié un taureau et un bélier sur chaque autel. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Et l'Éternel mit des paroles dans la bouche de Balaam et dit: Retourne vers Balak, et parle ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Il retourna donc vers lui; et voici, il se tenait près de son holocauste, lui et tous les seigneurs de Moab. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Alors Balaam prononça son discours sentencieux, et dit: Balak, roi de Moab, m'a fait venir d'Aram, des montagnes d'Orient. Viens, dit-il, maudis-moi Jacob; viens, voue Israël à l'exécration. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Comment le maudirais-je? Dieu ne l'a point maudit. Comment vouerais-je à l'exécration? L'Éternel n'a point voué à l'exécration. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Car je le vois du sommet des rochers, et je le contemple du haut des coteaux. Voici un peuple qui habitera à part, et ne sera point mis au nombre des nations. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Qui compterait la poussière de Jacob, et dénombrerait le quart d'Israël? Que je meure de la mort des hommes droits, et que ma fin soit semblable à la leur! ");
INSERT INTO fra_fob_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Alors Balak dit à Balaam: Que m'as-tu fait? Je t'ai pris pour maudire mes ennemis; et voici, tu les bénis. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Et il répondit, et dit: Ne dois-je pas prendre garde de dire ce que l'Éternel met dans ma bouche? ");
INSERT INTO fra_fob_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Alors Balak lui dit: Viens donc avec moi en un autre lieu d'où tu verras ce peuple, car tu n'en voyais que l'extrémité, et tu ne le voyais pas tout entier; et de là maudis-le-moi. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Il le conduisit donc au champ de Tsophim, au sommet du Pisga, construisit sept autels, et offrit un taureau et un bélier sur chaque autel. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Alors Balaam dit à Balak: Tiens-toi ici près de ton holocauste, et moi j'irai là à la rencontre de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Et l'Éternel se présenta à Balaam, et mit des paroles en sa bouche, et dit: Retourne vers Balak, et parle ainsi. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Et il vint vers lui; et voici, il se tenait près de son holocauste, et les seigneurs de Moab avec lui. Et Balak lui dit: Qu'a dit l'Éternel? ");
INSERT INTO fra_fob_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Alors il prononça son discours sentencieux, et dit: Lève-toi, Balak, et écoute; prête-moi l'oreille, fils de Tsippor. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dieu n'est point homme pour mentir, ni fils d'homme pour se repentir. Il a dit; ne le fera-t-il point? Il a parlé; ne le réalisera-t-il pas? ");
INSERT INTO fra_fob_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Voici, j'ai reçu l'ordre de bénir; il a béni, je ne le révoquerai point. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Il n'a point aperçu d'iniquité en Jacob, et n'a point vu de perversité en Israël; l'Éternel son Dieu est avec lui, et l'on y entend des acclamations comme pour un roi. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","C'est Dieu qui les a tirés d'Égypte; il est pour eux comme la vigueur du buffle. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Car il n'y a point d'enchantement contre Jacob, ni de divination contre Israël. Bientôt on dira de Jacob et d'Israël: Qu'est-ce que Dieu a fait! ");
INSERT INTO fra_fob_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Voici un peuple qui se lèvera comme une lionne, et qui se dressera comme un lion; il ne se couchera point qu'il n'ait dévoré la proie et bu le sang des blessés. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Alors Balak dit à Balaam: Ne le maudis point, mais ne le bénis pas non plus! ");
INSERT INTO fra_fob_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Et Balaam répondit et dit à Balak: Ne t'ai-je pas dit: Je ferai tout ce que l'Éternel dira? ");
INSERT INTO fra_fob_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak dit encore à Balaam: Viens donc, je te conduirai en un autre lieu; peut-être que Dieu trouvera bon que tu me le maudisses de là. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Et Balak conduisit Balaam au sommet du Peor, qui regarde en face du désert. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Et Balaam dit à Balak: Construis-moi ici sept autels, et prépare-moi ici sept taureaux et sept béliers. ");
INSERT INTO fra_fob_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak fit donc comme Balaam avait dit; et il offrit un taureau et un bélier sur chaque autel. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Or, Balaam, voyant que l'Éternel trouvait bon de bénir Israël, n'alla point, comme les autres fois, chercher des enchantements; mais il tourna son visage vers le désert. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Et Balaam, levant les yeux, vit Israël campé selon ses tribus; et l'esprit de Dieu fut sur lui. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Et il prononça son discours sentencieux, et dit: Oracle de Balaam, fils de Béor, oracle de l'homme qui a l'œil ouvert: ");
INSERT INTO fra_fob_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Oracle de celui qui entend les paroles de Dieu, qui voit la vision du Tout-Puissant, qui se prosterne et dont les y eux sont ouverts: ");
INSERT INTO fra_fob_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Que tes tentes sont belles, ô Jacob! et tes demeures, ô Israël! ");
INSERT INTO fra_fob_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Elles s'étendent comme des vallées, comme des jardins près d'un fleuve, comme des aloès que l'Éternel a plantés, comme des cèdres auprès des eaux. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","L'eau coulera de ses seaux, et sa postérité sera comme de grandes eaux; son roi s'élèvera au-dessus d'Agag, et son royaume sera exalté. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dieu l'a fait sortir d'Égypte; il est pour lui comme la vigueur du buffle; il dévorera les nations, ses ennemies; il brisera leurs os, et les frappera de ses flèches. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Il s'est courbé, il s'est couché comme le lion, comme la lionne: qui le fera lever? Ceux qui te bénissent seront bénis, et ceux qui te maudissent seront maudits! ");
INSERT INTO fra_fob_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Alors la colère de Balak s'enflamma contre Balaam, et il frappa des mains; puis Balak dit à Balaam: Je t'ai appelé pour maudire mes ennemis, et voici, tu les as bénis déjà trois fois! ");
INSERT INTO fra_fob_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Et maintenant, fuis dans ton pays! J'avais dit que je te ferais beaucoup d'honneurs; mais voici, l'Éternel t'a empêché d'être honoré. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Et Balaam répondit à Balak: N'avais-je pas dit aussi aux messagers que tu avais envoyés vers moi: ");
INSERT INTO fra_fob_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Quand Balak me donnerait sa maison pleine d'argent et d'or, je ne pourrais pas transgresser l'ordre de l'Éternel, pour faire du bien ou du mal de moi-même; je dirai ce que l'Éternel dira? ");
INSERT INTO fra_fob_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Et maintenant, voici, je m'en vais vers mon peuple. Viens, que je te déclare ce que ce peuple fera à ton peuple dans la suite des temps. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Alors il prononça son discours sentencieux, et dit: Oracle de Balaam, fils de Béor, oracle de l'homme qui a l'œil ouvert; ");
INSERT INTO fra_fob_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Oracle de celui qui entend les paroles de Dieu, qui connaît la science du Très-Haut, qui voit la vision du Tout-Puissant, qui se prosterne et dont les yeux sont ouverts. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Je le vois, mais non maintenant; je le contemple, mais non de près; une étoile est sortie de Jacob, et un sceptre s'est élevé d'Israël; il frappera les deux régions de Moab, il détruira tous les enfants du tumulte. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Édom sera possédé, Séir sera possédé par ses ennemis, et Israël agira vaillamment. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Et celui qui vient de Jacob dominera, et extirpera les réchappés des villes. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Il vit aussi Amalek. Et il prononça son discours sentencieux, et dit: Amalek est la première des nations; mais son avenir est la perdition. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Puis il vit les Kéniens. Et il prononça son discours sentencieux, et dit: Ta demeure est solide, et ton nid placé dans le rocher. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Toutefois, Kaïn sera ravagé, jusqu'à ce qu'Assur t'emmène en captivité. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Et il prononça encore son discours sentencieux, et dit: Malheur à qui vivra, après que Dieu l'aura établi! ");
INSERT INTO fra_fob_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Mais des navires viendront du côté de Kittim, et ils humilieront Assur, ils humilieront Héber, et lui aussi sera détruit. ");
INSERT INTO fra_fob_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Puis Balaam se leva, et s'en alla, et retourna en son pays. Et Balak aussi s'en alla son chemin. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Or, Israël demeurait à Sittim; et le peuple commença à se livrer à la fornication avec les filles de Moab. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Elles convièrent le peuple aux sacrifices de leurs dieux; et le peuple mangea, et se prosterna devant leurs dieux. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Et Israël s'attacha à Baal-Peor; et la colère de l'Éternel s'enflamma contre Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Et l'Éternel dit à Moïse: Prends tous les chefs du peuple, et fais pendre les coupables devant l'Éternel, en face du soleil, afin que l'ardeur de la colère de l'Éternel se détourne d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moïse dit donc aux juges d'Israël: Que chacun de vous fasse mourir ceux de ses hommes qui se sont attachés à Baal-Peor. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Et voici, un homme des enfants d'Israël vint et amena à ses frères une Madianite, sous les yeux de Moïse et de toute l'assemblée des enfants d'Israël, comme ils pleuraient à l'entrée du tabernacle d'assignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Et Phinées, fils d'Éléazar, fils d'Aaron, le sacrificateur, le vit, et il se leva du milieu de l'assemblée, et prit une javeline en sa main; ");
INSERT INTO fra_fob_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Et il entra après l'homme israélite dans la tente, et les transperça tous deux, l'homme israélite et la femme, par le bas-ventre; et la plaie fut arrêtée de dessus les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Or, il y en eut vingt-quatre mille qui moururent de cette plaie. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Phinées, fils d'Éléazar, fils d'Aaron, le sacrificateur, a détourné mon courroux de dessus les enfants d'Israël, parce qu'il a été animé de mon zèle au milieu d'eux; et je n'ai point consumé les enfants d'Israël dans mon indignation. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","C'est pourquoi, déclare-lui que je lui donne mon alliance de paix; ");
INSERT INTO fra_fob_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Et ce sera pour lui et pour sa postérité après lui, l'alliance d'un sacerdoce perpétuel, parce qu'il a été zélé pour son Dieu, et qu'il a fait l'expiation pour les enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Or l'homme israélite tué, qui fut tué avec la Madianite, s'appelait Zimri, fils de Salu, chef d'une maison de père des Siméonites. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Et le nom de la femme madianite tuée, était Cozbi, fille de Tsur, qui était chef de peuplades d'une maison de père en Madian. ");
INSERT INTO fra_fob_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","L'Éternel parla aussi à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Traitez en ennemis les Madianites, et tuez-les; ");
INSERT INTO fra_fob_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Car ils vous ont traités en ennemis par les ruses qu'ils ont employées contre vous dans l'affaire de Peor, et dans l'affaire de Cozbi, fille d'un chef de Madian, leur sœur, qui a été tuée au jour de la plaie causée par l'affaire de Peor. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Or il arriva, après cette plaie, que l'Éternel dit à Moïse et à Éléazar, fils d'Aaron, le sacrificateur: ");
INSERT INTO fra_fob_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Faites le compte de toute l'assemblée des enfants d'Israël, depuis l'âge de vingt ans et au-dessus, selon les maisons de leurs pères, tous ceux d'Israël qui peuvent aller à la guerre. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moïse et Éléazar, le sacrificateur, leur parlèrent donc dans les plaines de Moab, près du Jourdain de Jérico, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Qu'on fasse le dénombrement depuis l'âge de vingt ans et au-dessus, comme l'Éternel l'a commandé à Moïse et aux enfants d'Israël, sortis du pays d'Égypte. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, premier-né d'Israël. Fils de Ruben: Hénoc; de lui sort la famille des Hénokites; de Pallu, la famille des Palluites; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","De Hetsron, la famille des Hetsronites; de Carmi, la famille des Carmites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Telles sont les familles des Rubénites; et ceux dont on fit le dénombrement furent quarante-trois mille sept cent trente. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Et les fils de Pallu: Éliab. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Et les fils d'Éliab: Némuël, Dathan et Abiram. C'est ce Dathan et cet Abiram, convoqués à l'assemblée, qui se soulevèrent contre Moïse et contre Aaron, dans l'assemblée de Coré, quand ils se soulevèrent contre l'Éternel, ");
INSERT INTO fra_fob_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Et que la terre ouvrit sa bouche et les engloutit, avec Coré, alors que ceux qui s'étaient assemblés moururent, quand le feu dévora les deux cent cinquante hommes et qu'ils servirent d'exemple. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Mais les fils de Coré ne moururent point. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Fils de Siméon, selon leurs familles: de Némuël, la famille des Némuélites; de Jamin, la famille des Jaminites; de Jakin, la famille des Jakinites; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","De Zérach, la famille des Zérachites; de Saül, la famille des Saülites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Telles sont les familles des Siméonites: vingt-deux mille deux cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Fils de Gad, selon leurs familles: de Tséphon, la famille des Tséphonites; de Haggi, la famille des Haggites; de Shuni, la famille des Shunites; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","D'Ozni, la famille des Oznites; d'Éri, la famille des Érites; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","D'Arod, la famille des Arodites; d'Aréli, la famille des Arélites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Telles sont les familles des fils de Gad, selon leur dénombrement: quarante mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Fils de Juda: Er et Onan; mais Er et Onan moururent au pays de Canaan. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Les fils de Juda, selon leurs familles, furent: de Shéla, la famille des Shélanites; de Pharets, la famille des Phartsites; de Zérach, la famille des Zérachites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Et les fils de Pharets furent: de Hetsron, la famille des Hetsronites; et de Hamul, la famille des Hamulites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Telles sont les familles de Juda, selon leur dénombrement: soixante et seize mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Fils d'Issacar, selon leurs familles: de Thola, la famille des Tholaïtes; de Puva, la famille des Puvites; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","De Jashub, la famille des Jashubites; de Shimron, la famille des Shimronites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Telles sont les familles d'Issacar, selon leur dénombrement: soixante-quatre mille trois cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Fils de Zabulon, selon leurs familles: de Séred, la famille des Sardites; d'Élon, la famille des Élonites; de Jahléel, la famille des Jahléélites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Telles sont les familles des Zabulonites, selon leur dénombrement: soixante mille cinq cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Fils de Joseph, selon leurs familles: Manassé et Éphraïm. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Fils de Manassé: de Makir, la famille des Makirites; et Makir engendra Galaad; de Galaad, la famille des Galaadites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Voici les fils de Galaad: de Jézer, la famille des Jézerites; de Hélek, la famille des Helkites; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","D'Asriel, la famille des Asriélites; de Sichem, la famille des Sichémites; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","De Shémida, la famille des Shémidaïtes; de Hépher, la famille des Héphrites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Or, Tselophcad, fils de Hépher, n'eut point de fils, mais des filles. Et les noms des filles de Tselophcad étaient: Machla, Noa, Hogla, Milca et Thirtsa. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Telles sont les familles de Manassé, et leur dénombrement fut de cinquante-deux mille sept cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Voici les fils d'Éphraïm, selon leurs familles: de Shuthélach, la famille des Shuthélachites; de Béker, la famille des Bakrites; de Thachan, la famille des Thachanites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Et voici les fils de Shuthélach: d'Éran, la famille des Éranites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Telles sont les familles des fils d'Éphraïm, selon leur dénombrement: trente-deux mille cinq cents. Ce sont là les fils de Joseph, selon leurs familles. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Fils de Benjamin, selon leurs familles: de Béla, la famille des Balites; d'Ashbel, la famille des Ashbélites; d'Achiram, la famille des Achiramites; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","De Shéphupham, la famille des Shuphamites; de Hupham, la famille des Huphamites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Les fils de Béla furent Ard et Naaman; d'Ard, la famille des Ardites; de Naaman, la famille des Naamites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Tels sont les fils de Benjamin, selon leurs familles; et leur dénombrement fut de quarante-cinq mille six cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Voici les fils de Dan, selon leurs familles: de Shucham, la famille des Shuchamites. Ce sont là les familles de Dan, selon leurs familles; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Toutes les familles des Shuchamites, selon leur dénombrement, furent soixante-quatre mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Fils d'Asser, selon leurs familles: de Jimma, la famille des Jimmites; de Jishvi, la famille des Jishvites; de Beria, la famille des Beriites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Des fils de Beria: de Héber, la famille des Hébrites; de Malkiel, la famille des Malkiélites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Et le nom de la fille d'Asser, était Sérach. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Telles sont les familles des fils d'Asser, selon leur dénombrement: cinquante-trois mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Fils de Nephthali, selon leurs familles: de Jahtseel, la famille des Jahtséelites; de Guni, la famille des Gunites; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","De Jetser, la famille des Jitsrites; de Shillem, la famille des Shillémites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Telles sont les familles de Nephthali, selon leurs familles; et leur dénombrement fut de quarante-cinq mille quatre cents. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Tels sont ceux des enfants d'Israël dont on fit le dénombrement: six cent un mille sept cent trente. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Le pays sera partagé entre ceux-ci en héritage, selon le nombre des noms; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","A ceux qui sont en grand nombre, tu donneras plus d'héritage, et à ceux qui sont en petit nombre, tu donneras moins d'héritage; on donnera à chacun son héritage en proportion de son recensement. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Mais le pays sera partagé par le sort; ils recevront leur héritage selon les noms des tribus de leurs pères. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","L'héritage de chacun sera déterminé par le sort, en ayant égard au grand nombre ou au petit nombre. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Voici les Lévites dont on fit le dénombrement, selon leurs familles: de Guershon, la famille des Guershonites; de Kéhath, la famille des Kéhathites; de Mérari, la famille des Mérarites. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Voici les familles de Lévi: la famille des Libnites, la famille des Hébronites, la famille des Machlites, la famille des Mushites, la famille des Corhites. Or Kéhath engendra Amram. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Et le nom de la femme d'Amram était Jokébed, fille de Lévi, qui naquit à Lévi en Égypte; elle enfanta à Amram, Aaron, Moïse et Marie leur sœur. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Et à Aaron, naquirent Nadab et Abihu, Éléazar et Ithamar. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Mais Nadab et Abihu moururent en offrant un feu étranger devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Or ceux des Lévites qu'on dénombra furent vingt-trois mille, tous mâles, depuis l'âge d'un mois et au-dessus; car ils ne furent point dénombrés avec les enfants d'Israël, parce qu'il ne leur fut point donné d'héritage au milieu des enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Tel est le dénombrement fait par Moïse et Éléazar; le sacrificateur, qui dénombrèrent les enfants d'Israël dans les campagnes de Moab, près du Jourdain de Jérico; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Et parmi ceux-ci il n'y avait aucun de ceux qui avaient été dénombrés par Moïse et Aaron, le sacrificateur, quand ils firent le dénombrement des enfants d'Israël au désert de Sinaï; ");
INSERT INTO fra_fob_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Car l'Éternel avait dit d'eux: Ils mourront dans le désert; et il n'en resta pas un, excepté Caleb, fils de Jephunné, et Josué, fils de Nun. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Les filles de Tsélophcad, fils de Hépher, fils de Galaad, fils de Makir, fils de Manassé, des familles de Manassé, fils de Joseph, s'approchèrent; et voici les noms de ses filles: Machla, Noa, Hogla, Milca, et Thirtsa. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Elles se présentèrent donc devant Moïse, devant Éléazar, le sacrificateur, et devant les principaux et toute l'assemblée, à l'entrée du tabernacle d'assignation, et elles dirent: ");
INSERT INTO fra_fob_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Notre père est mort dans le désert; mais il n'était point dans l'assemblée de ceux qui se réunirent contre l'Éternel, dans l'assemblée de Coré; mais il est mort pour son péché, et il n'avait point de fils. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Pourquoi le nom de notre père serait-il retranché du milieu de sa famille, parce qu'il n'a point eu de fils? Donne-nous une possession parmi les frères de notre père. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Alors Moïse porta leur cause devant l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Et l'Éternel parla à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Les filles de Tsélophcad ont raison. Tu leur donneras la possession d'un héritage au milieu des frères de leur père, et c'est à elles que tu feras passer l'héritage de leur père. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Tu parleras aussi aux enfants d'Israël, en disant: Lorsqu'un homme mourra, sans avoir de fils, vous ferez passer son héritage à sa fille. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Que s'il n'a point de fille, vous donnerez son héritage à ses frères. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Et s'il n'a point de frères, vous donnerez son héritage aux frères de son père. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Que si son père n'a point de frères, vous donnerez son héritage à son parent, le plus proche de sa famille, et il le possédera; et ce sera pour les enfants d'Israël une ordonnance de droit, comme l'Éternel l'a commandé à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Puis l'Éternel dit à Moïse: Monte sur cette montagne d'Abarim, et regarde le pays que j'ai donné aux enfants d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Tu le regarderas; puis tu seras, toi aussi, recueilli vers tes peuples, comme a été recueilli Aaron, ton frère. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Parce que vous avez été rebelles à mon commandement au désert de Tsin, lors de la contestation de l'assemblée, et que vous ne m'avez point sanctifié au sujet des eaux, devant eux. Ce sont les eaux de la contestation de Kadès, au désert de Tsin. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Or Moïse parla à l'Éternel, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Que l'Éternel, le Dieu des esprits de toute chair, établisse sur l'assemblée un homme qui sorte et entre devant eux, ");
INSERT INTO fra_fob_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Et qui les fasse sortir et entrer, afin que l'assemblée de l'Éternel ne soit pas comme des brebis qui n'ont point de berger. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Alors l'Éternel dit à Moïse: Prends Josué, fils de Nun, homme en qui l'Esprit réside; et tu poseras ta main sur lui; ");
INSERT INTO fra_fob_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Et tu le présenteras devant Éléazar, le sacrificateur, et devant toute l'assemblée; et tu lui donneras des instructions en leur présence; ");
INSERT INTO fra_fob_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Et tu lui feras part de ton autorité, afin que toute l'assemblée des enfants d'Israël l'écoute. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Et il se présentera devant Éléazar, le sacrificateur, qui consultera pour lui par le jugement de l'Urim devant l'Éternel; et sur le commandement d'Éléazar, ils sortiront, et sur son commandement ils entreront, lui et tous les enfants d'Israël avec lui, et toute l'assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moïse fit donc comme l'Éternel lui avait commandé; il prit Josué, et le plaça devant Éléazar, le sacrificateur, et devant toute l'assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Puis il lui imposa les mains et lui donna ses instructions, comme l'Éternel l'avait dit par Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Commande aux enfants d'Israël, et dis-leur: Vous aurez soin de m'offrir, en son temps, mon offrande, ma nourriture, pour mes sacrifices faits par le feu, qui me sont d'une agréable odeur. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Tu leur diras donc: Voici le sacrifice fait par le feu, que vous offrirez à l'Éternel: Deux agneaux d'un an, sans défaut, tous les jours, en holocauste continuel. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Tu sacrifieras l'un des agneaux le matin, et l'autre agneau entre les deux soirs; ");
INSERT INTO fra_fob_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Avec le dixième d'un épha de fine farine pour l'oblation, pétrie avec le quart d'un hin d'huile d'olives broyées. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","C'est l'holocauste continuel établi au mont Sinaï, en agréable odeur; c'est un sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Et la libation sera d'un quart de hin pour chaque agneau. Et tu feras dans le lieu saint la libation de vin à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Et tu sacrifieras l'autre agneau entre les deux soirs; tu feras la même oblation que le matin, et la même libation; c'est un sacrifice fait par le feu, en agréable odeur à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Mais le jour du sabbat vous offrirez deux agneaux d'un an, sans défaut, et deux dixièmes de fine farine pétrie à l'huile, pour l'offrande avec sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","C'est l'holocauste du sabbat, pour chaque sabbat, outre l'holocauste continuel et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Au commencement de vos mois, vous offrirez en holocauste à l'Éternel deux jeunes taureaux, un bélier, et sept agneaux d'un an sans défaut; ");
INSERT INTO fra_fob_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Et trois dixièmes de fine farine pétrie à l'huile, pour l'offrande, pour chaque taureau; et deux dixièmes de fine farine pétrie à l'huile pour l'offrande, pour le bélier; ");
INSERT INTO fra_fob_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Et un dixième de fine farine pétrie à l'huile, pour l'offrande, pour chaque agneau. C'est un holocauste d'agréable odeur, un sacrifice fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Et leurs libations seront de la moitié d'un hin de vin par taureau, d'un tiers de hin pour un bélier, et d'un quart de hin par agneau. C'est l'holocauste du commencement du mois, pour tous les mois de l'année. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","On offrira aussi à l'Éternel un bouc en sacrifice pour le péché, outre l'holocauste continuel, et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Et au quatorzième jour du premier mois, on célébrera la Pâque à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Et au quinzième jour du même mois, il y aura une fête; pendant sept jours on mangera des pains sans levain. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Au premier jour, il y aura une sainte convocation; vous ne ferez aucune œuvre servile; ");
INSERT INTO fra_fob_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Et vous offrirez en sacrifice fait par le feu, en holocauste à l'Éternel, deux jeunes taureaux, un bélier, et sept agneaux d'un an, qui seront sans défaut; ");
INSERT INTO fra_fob_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Leur oblation sera de fine farine pétrie à l'huile; vous en offrirez trois dixièmes pour un taureau; et deux dixièmes pour le bélier. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Tu en offriras un dixième pour chacun des sept agneaux; ");
INSERT INTO fra_fob_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Et un bouc en sacrifice pour le péché, afin de faire l'expiation pour vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Vous offrirez ces choses outre l'holocauste du matin, qui est un holocauste continuel. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Vous en offrirez autant chaque jour, pendant sept jours, comme aliment d'un sacrifice fait par le feu, d'agréable odeur à l'Éternel. On l'offrira, outre l'holocauste continuel, avec son aspersion. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Et au septième jour vous aurez une sainte convocation; vous ne ferez aucune œuvre servile. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Et au jour des premiers fruits, quand vous offrirez l'oblation nouvelle à l'Éternel, dans votre fête des semaines, vous aurez une sainte convocation; vous ne ferez aucune œuvre servile; ");
INSERT INTO fra_fob_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Et vous offrirez en holocauste, en agréable odeur à l'Éternel, deux jeunes taureaux, un bélier et sept agneaux d'un an; ");
INSERT INTO fra_fob_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Et leur oblation sera de fine farine pétrie à l'huile, trois dixièmes pour chaque taureau, deux dixièmes pour chaque bélier, ");
INSERT INTO fra_fob_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Un dixième pour chacun des sept agneaux; ");
INSERT INTO fra_fob_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Vous offrirez aussi un bouc afin de faire l'expiation pour vous. ");
INSERT INTO fra_fob_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Vous les offrirez, outre l'holocauste continuel et son offrande; ils seront sans défaut, avec leurs libations. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Et le premier jour du septième mois, vous aurez une sainte convocation; vous ne ferez aucune œuvre servile; ce sera pour vous un jour où l'on sonnera de la trompette. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Et vous offrirez en holocauste, en agréable odeur à l'Éternel, un jeune taureau, un bélier, et sept agneaux d'un an sans défaut, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Et leur oblation de fine farine pétrie à l'huile, trois dixièmes pour le taureau, deux dixièmes pour le bélier; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Et un dixième pour chacun des sept agneaux; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Et un bouc en sacrifice pour le péché, afin de faire l'expiation pour vous; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Outre l'holocauste du commencement du mois, et son oblation, l'holocauste continuel et son offrande, et leurs libations, selon l'ordonnance. Vous les offrirez en sacrifice d'agréable odeur, fait par le feu à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Et au dixième jour de ce septième mois, vous aurez une sainte convocation, et vous humilierez vos âmes; vous ne ferez aucune œuvre. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Et vous offrirez en holocauste d'agréable odeur à l'Éternel, un jeune taureau, un bélier et sept agneaux d'un an, qui seront sans défaut; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Et leur oblation sera de fine farine pétrie à l'huile, trois dixièmes pour le taureau, deux dixièmes pour le bélier, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Un dixième pour chacun des sept agneaux. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Vous offrirez aussi un bouc en sacrifice pour le péché; outre le sacrifice pour le péché, qu'on offre le jour des expiations, et l'holocauste continuel et son oblation, et leurs libations. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Et au quinzième jour du septième mois, vous aurez une sainte convocation; vous ne ferez aucune œuvre servile; mais vous célébrerez une fête à l'Éternel pendant sept jours. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Et vous offrirez en holocauste, en sacrifice fait par le feu, en agréable odeur à l'Éternel, treize jeunes taureaux, deux béliers, et quatorze agneaux d'un an, qui seront sans défaut; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Et leur oblation sera de fine farine pétrie à l'huile, trois dixièmes pour chacun des treize taureaux, deux dixièmes pour chacun des deux béliers, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Et un dixième pour chacun des quatorze agneaux; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Vous offrirez aussi un bouc en sacrifice pour le péché; outre l'holocauste continuel, son oblation et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Et au second jour, vous offrirez douze jeunes taureaux, deux béliers, quatorze agneaux d'un an, sans défaut, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Avec l'oblation et les libations pour les taureaux, pour les béliers et pour les agneaux, d'après leur nombre, selon les prescriptions; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Et un bouc en sacrifice pour le péché, outre l'holocauste continuel, et son oblation, et leurs libations. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Et au troisième jour, vous offrirez onze taureaux, deux béliers, quatorze agneaux d'un an, sans défaut, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Avec l'oblation et les libations pour les taureaux, pour les béliers et pour les agneaux, d'après leur nombre, selon les prescriptions; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Et un bouc en sacrifice pour le péché; outre l'holocauste continuel, son oblation et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Et au quatrième jour, vous offrirez dix taureaux, deux béliers, quatorze agneaux d'un an, sans défaut, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","L'oblation et les libations pour les taureaux, pour les béliers et pour les agneaux, d'après leur nombre, selon les prescriptions; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Et un bouc en sacrifice pour le péché; outre l'holocauste continuel, son oblation et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Et au cinquième jour, vous offrirez neuf taureaux, deux béliers, quatorze agneaux d'un an, sans défaut, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Avec l'oblation et les libations pour les taureaux, pour les béliers et pour les agneaux, d'après leur nombre, selon les prescriptions; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Et un bouc en sacrifice pour le péché; outre l'holocauste continuel, son oblation et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Et au sixième jour, vous offrirez huit taureaux, deux béliers, quatorze agneaux d'un an, sans défaut, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Avec l'oblation et les libations pour les taureaux, pour les béliers et pour les agneaux, d'après leur nombre, selon les prescriptions; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Et un bouc en sacrifice pour le péché; outre l'holocauste continuel, son oblation et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Et au septième jour, vous offrirez sept taureaux, deux béliers, quatorze agneaux sans défaut, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Avec l'oblation et les libations, pour les taureaux, pour les béliers et pour les agneaux, d'après leur nombre, selon les prescriptions qui les concernent; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Et un bouc en sacrifice pour le péché; outre l'holocauste continuel, son oblation et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Le huitième jour, vous aurez une assemblée solennelle; vous ne ferez aucune œuvre servile; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Et vous offrirez en holocauste, en sacrifice fait par le feu, d'agréable odeur à l'Éternel, un taureau, un bélier, sept agneaux d'un an, sans défaut, ");
INSERT INTO fra_fob_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Avec l'oblation et les libations pour le taureau, pour le bélier et pour les agneaux, d'après leur nombre, selon les prescriptions; ");
INSERT INTO fra_fob_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Et un bouc en sacrifice pour le péché; outre l'holocauste continuel, son oblation et sa libation. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Tels sont les sacrifices que vous offrirez à l'Éternel, dans vos solennités, outre vos vœux et vos offrandes volontaires, pour vos holocaustes, vos oblations, vos libations, et pour vos sacrifices de prospérités. ");
INSERT INTO fra_fob_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Or Moïse dit aux enfants d'Israël tout ce que l'Éternel lui avait commandé. ");
INSERT INTO fra_fob_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moïse parla aussi aux chefs des tribus des enfants d'Israël, en disant: Voici ce que l'Éternel a commandé: ");
INSERT INTO fra_fob_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Quand un homme aura fait un vœu à l'Éternel, ou se sera par serment imposé une obligation à lui-même, il ne violera point sa parole; il fera selon tout ce qui est sorti de sa bouche. ");
INSERT INTO fra_fob_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Mais quand une femme aura fait un vœu à l'Éternel, et qu'elle se sera imposé une obligation, en sa jeunesse, dans la maison de son père; ");
INSERT INTO fra_fob_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Et que son père aura entendu son vœu et l'obligation qu'elle s'est imposée à elle-même, et ne lui aura rien dit, tous ses vœux seront valables, et toute obligation qu'elle se sera imposée sera valable; ");
INSERT INTO fra_fob_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Mais si son père la désavoue le jour où il l'a entendue, tous ses vœux et toutes les obligations qu'elle s'est imposés à elle-même, seront nuls, et l'Éternel lui pardonnera; car son père l'a désavouée. ");
INSERT INTO fra_fob_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Si elle est mariée, et qu'elle soit engagée par des vœux ou par quelque parole échappée de ses lèvres, par laquelle elle se soit imposé une obligation à elle-même, ");
INSERT INTO fra_fob_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Si son mari l'a entendue, et que le jour où il l'a entendue, il ne lui en dise rien, ses vœux seront valables, et les obligations qu'elle se sera imposées à elle-même seront valables; ");
INSERT INTO fra_fob_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Mais si, au jour que son mari l'apprend, il la désavoue, il annulera le vœu par lequel elle s'était engagée et la parole échappée de ses lèvres, par laquelle elle s'était imposé une obligation à elle-même; et l'Éternel lui pardonnera. ");
INSERT INTO fra_fob_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Mais le vœu d'une veuve ou d'une répudiée, tout ce à quoi elle se sera obligée, sera valable pour elle. ");
INSERT INTO fra_fob_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Si c'est donc dans la maison de son mari qu'une femme a fait un vœu, ou qu'elle s'est imposé une obligation par serment, ");
INSERT INTO fra_fob_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Et que son mari l'ait entendue, et ne lui en ait rien dit, et ne l'ait point désavouée, tous ses vœux seront valables, et tout ce à quoi elle se sera obligée sera valable; ");
INSERT INTO fra_fob_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Mais si son mari les annule le jour qu'il les a entendus, tout ce qui est sorti de ses lèvres relativement à ses vœux et à l'obligation dont elle s'était liée, sera nul; son mari les a annulés, et l'Éternel lui pardonnera. ");
INSERT INTO fra_fob_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Son mari pourra ratifier et son mari pourra annuler tout vœu et tout serment par lequel elle se sera obligée à affliger son âme. ");
INSERT INTO fra_fob_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Si son mari ne lui en a rien dit, d'un jour à l'autre, il aura ratifié tous ses vœux ou toutes ses obligations; il les aura ratifiés, parce qu'il ne lui en a rien dit au jour qu'il les a entendus. ");
INSERT INTO fra_fob_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Mais s'il les annule quelque temps après les avoir entendus, il portera la peine du péché de sa femme. ");
INSERT INTO fra_fob_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Telles sont les ordonnances que l'Éternel commanda à Moïse, entre un mari et sa femme, entre un père et sa fille, quand elle est encore dans la maison de son père, en sa jeunesse. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Venge les enfants d'Israël des Madianites; puis tu seras recueilli vers tes peuples. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moïse parla donc au peuple, en disant: Équipez d'entre vous des hommes pour la guerre; et qu'ils attaquent Madian, pour exécuter la vengeance de l'Éternel sur Madian. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Vous enverrez à la guerre mille hommes par tribu, de toutes les tribus d'Israël. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","On leva donc, d'entre les milliers d'Israël, mille hommes par tribu, douze mille hommes équipés pour la guerre. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Et Moïse les envoya à la guerre, mille par tribu, avec Phinées, fils d'Éléazar, le sacrificateur, qui avait les instruments sacrés, les trompettes éclatantes en sa main. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ils firent donc la guerre contre Madian, comme l'Éternel l'avait commandé à Moïse, et ils tuèrent tous les mâles. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ils tuèrent aussi les rois de Madian, outre les autres qui furent tués: Évi, Rékem, Tsur, Hur et Réba, cinq rois de Madian; ils tuèrent aussi par l'épée Balaam, fils de Béor. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Et les enfants d'Israël emmenèrent prisonnières les femmes de Madian et leurs petits enfants; et ils pillèrent tout leur bétail, tous leurs troupeaux, et tous leurs biens. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Et ils brûlèrent toutes leurs villes, avec leurs habitations, et tous leurs bourgs; ");
INSERT INTO fra_fob_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Et ils prirent toutes les dépouilles, et tout le butin, en hommes et en bétail; ");
INSERT INTO fra_fob_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Et ils amenèrent les prisonniers, les dépouilles et le butin, à Moïse, à Éléazar, le sacrificateur, et à l'assemblée des enfants d'Israël, au camp, dans les plaines de Moab, qui sont près du Jourdain de Jérico. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Alors Moïse, Éléazar, le sacrificateur, et tous les principaux de l'assemblée, sortirent à leur rencontre hors du camp. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Et Moïse s'irrita contre les capitaines de l'armée, les chefs de milliers, et les chefs de centaines qui revenaient de cette expédition guerrière. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Et Moïse leur dit: Vous avez laissé la vie à toutes les femmes? ");
INSERT INTO fra_fob_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Voici, ce sont elles qui, d'après la parole de Balaam, ont donné occasion aux enfants d'Israël de commettre un crime contre l'Éternel dans l'affaire de Peor, ce qui attira la plaie sur l'assemblée de l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Maintenant donc tuez tout mâle parmi les petits enfants, et tuez toute femme qui aura eu compagnie d'homme; ");
INSERT INTO fra_fob_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mais laissez vivre, pour vous, toutes les jeunes filles qui n'ont point eu compagnie d'homme. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Quant à vous, campez sept jours hors du camp. Quiconque a tué quelqu'un, et quiconque a touché quelqu'un de tué, qu'il se purifie le troisième jour et le septième jour, lui et ses prisonniers. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Vous purifierez aussi tout vêtement, tout objet de peau, tout ouvrage en poil de chèvre, et tout ustensile de bois. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Et Éléazar, le sacrificateur, dit aux hommes de l'armée qui étaient allés à la guerre: Voici l'ordonnance de la loi que l'Éternel a commandée à Moïse. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","L'or, l'argent, l'airain, le fer, l'étain, et le plomb, tout ce qui peut aller au feu, ");
INSERT INTO fra_fob_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","Vous le ferez passer par le feu, et il sera pur; toutefois on le purifiera avec l'eau de purification. Mais tout ce qui ne va pas au feu, vous le ferez passer dans l'eau. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Vous laverez aussi vos vêtements le septième jour, et vous serez purs; ensuite, vous entrerez au camp. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","L'Éternel parla encore à Moïse, en disant: ");
INSERT INTO fra_fob_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Fais le compte du butin qu'on a emmené, en personnes et en bétail, toi, Éléazar le sacrificateur, et les chefs des maisons des pères de l'assemblée; ");
INSERT INTO fra_fob_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Et partage le butin entre les combattants qui sont allés à la guerre et toute l'assemblée. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Et tu prélèveras sur les gens de guerre qui sont allés à la bataille, un tribut pour l'Éternel, un sur cinq cents, tant des personnes, que des bœufs, des ânes et des brebis. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Vous le prendrez sur leur moitié, et tu le donneras à Éléazar, le sacrificateur, en offrande à l'Éternel. ");
INSERT INTO fra_fob_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Et de la moitié échue aux en