﻿USE sofia;
DROP TABLE IF EXISTS sofia.fraLSG_vpl;
CREATE TABLE fraLSG_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES fraLSG_vpl WRITE;
INSERT INTO fraLSG_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Au commencement, Dieu créa les cieux et la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","La terre était informe et vide: il y avait des ténèbres à la surface de l’abîme, et l’esprit de Dieu se mouvait au-dessus des eaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Dieu dit: Que la lumière soit! Et la lumière fut. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Dieu vit que la lumière était bonne; et Dieu sépara la lumière d’avec les ténèbres. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Dieu appela la lumière jour, et il appela les ténèbres nuit. Ainsi, il y eut un soir, et il y eut un matin: ce fut le premier jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Dieu dit: Qu’il y ait une étendue entre les eaux, et qu’elle sépare les eaux d’avec les eaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Et Dieu fit l’étendue, et il sépara les eaux qui sont au-dessous de l’étendue d’avec les eaux qui sont au-dessus de l’étendue. Et cela fut ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Dieu appela l’étendue ciel. Ainsi, il y eut un soir, et il y eut un matin: ce fut le second jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Dieu dit: Que les eaux qui sont au-dessous du ciel se rassemblent en un seul lieu, et que le sec paraisse. Et cela fut ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Dieu appela le sec terre, et il appela l’amas des eaux mers. Dieu vit que cela était bon. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Puis Dieu dit: Que la terre produise de la verdure, de l’herbe portant de la semence, des arbres fruitiers donnant du fruit selon leur espèce et ayant en eux leur semence sur la terre. Et cela fut ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","La terre produisit de la verdure, de l’herbe portant de la semence selon son espèce, et des arbres donnant du fruit et ayant en eux leur semence selon leur espèce. Dieu vit que cela était bon. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ainsi, il y eut un soir, et il y eut un matin: ce fut le troisième jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Dieu dit: Qu’il y ait des luminaires dans l’étendue du ciel, pour séparer le jour d’avec la nuit; que ce soient des signes pour marquer les époques, les jours et les années; ");
INSERT INTO fraLSG_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","et qu’ils servent de luminaires dans l’étendue du ciel, pour éclairer la terre. Et cela fut ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Dieu fit les deux grands luminaires, le plus grand luminaire pour présider au jour, et le plus petit luminaire pour présider à la nuit; il fit aussi les étoiles. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Dieu les plaça dans l’étendue du ciel, pour éclairer la terre, ");
INSERT INTO fraLSG_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","pour présider au jour et à la nuit, et pour séparer la lumière d’avec les ténèbres. Dieu vit que cela était bon. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ainsi, il y eut un soir, et il y eut un matin: ce fut le quatrième jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Dieu dit: Que les eaux produisent en abondance des animaux vivants, et que des oiseaux volent sur la terre vers l’étendue du ciel. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Dieu créa les grands poissons et tous les animaux vivants qui se meuvent, et que les eaux produisirent en abondance selon leur espèce; il créa aussi tout oiseau ailé selon son espèce. Dieu vit que cela était bon. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Dieu les bénit, en disant: Soyez féconds, multipliez, et remplissez les eaux des mers; et que les oiseaux multiplient sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ainsi, il y eut un soir, et il y eut un matin: ce fut le cinquième jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Dieu dit: Que la terre produise des animaux vivants selon leur espèce, du bétail, des reptiles et des animaux terrestres, selon leur espèce. Et cela fut ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Dieu fit les animaux de la terre selon leur espèce, le bétail selon son espèce, et tous les reptiles de la terre selon leur espèce. Dieu vit que cela était bon. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Puis Dieu dit: Faisons l’homme à notre image, selon notre ressemblance, et qu’il domine sur les poissons de la mer, sur les oiseaux du ciel, sur le bétail, sur toute la terre, et sur tous les reptiles qui rampent sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Dieu créa l’homme à son image, il le créa à l’image de Dieu, il créa l’homme et la femme. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Dieu les bénit, et Dieu leur dit: Soyez féconds, multipliez, remplissez la terre, et l’assujettissez; et dominez sur les poissons de la mer, sur les oiseaux du ciel, et sur tout animal qui se meut sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Et Dieu dit: Voici, je vous donne toute herbe portant de la semence et qui est à la surface de toute la terre, et tout arbre ayant en lui du fruit d’arbre et portant de la semence: ce sera votre nourriture. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Et à tout animal de la terre, à tout oiseau du ciel, et à tout ce qui se meut sur la terre, ayant en soi un souffle de vie, je donne toute herbe verte pour nourriture. Et cela fut ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Dieu vit tout ce qu’il avait fait et voici, cela était très bon. Ainsi, il y eut un soir, et il y eut un matin: ce fut le sixième jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ainsi furent achevés les cieux et la terre, et toute leur armée. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Dieu acheva au septième jour son œuvre, qu’il avait faite: et il se reposa au septième jour de toute son œuvre, qu’il avait faite. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Dieu bénit le septième jour, et il le sanctifia, parce qu’en ce jour il se reposa de toute son œuvre qu’il avait créée en la faisant. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Voici les origines des cieux et de la terre, quand ils furent créés. Lorsque l’Éternel Dieu fit une terre et des cieux, ");
INSERT INTO fraLSG_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","aucun arbuste des champs n’était encore sur la terre, et aucune herbe des champs ne germait encore: car l’Éternel Dieu n’avait pas fait pleuvoir sur la terre, et il n’y avait point d’homme pour cultiver le sol. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mais une vapeur s’éleva de la terre, et arrosa toute la surface du sol. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","L’Éternel Dieu forma l’homme de la poussière de la terre, il souffla dans ses narines un souffle de vie et l’homme devint un être vivant. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Puis l’Éternel Dieu planta un jardin en Éden, du côté de l’orient, et il y mit l’homme qu’il avait formé. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","L’Éternel Dieu fit pousser du sol des arbres de toute espèce, agréables à voir et bons à manger, et l’arbre de la vie au milieu du jardin, et l’arbre de la connaissance du bien et du mal. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Un fleuve sortait d’Éden pour arroser le jardin, et de là il se divisait en quatre bras. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Le nom du premier est Pischon; c’est celui qui entoure tout le pays de Havila, où se trouve l’or. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","L’or de ce pays est pur; on y trouve aussi le bdellium et la pierre d’onyx. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Le nom du second fleuve est Guihon; c’est celui qui entoure tout le pays de Cusch. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Le nom du troisième est Hiddékel; c’est celui qui coule à l’orient de l’Assyrie. Le quatrième fleuve, c’est l’Euphrate. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","L’Éternel Dieu prit l’homme, et le plaça dans le jardin d’Éden pour le cultiver et pour le garder. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","L’Éternel Dieu donna cet ordre à l’homme: Tu pourras manger de tous les arbres du jardin; ");
INSERT INTO fraLSG_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","mais tu ne mangeras pas de l’arbre de la connaissance du bien et du mal, car le jour où tu en mangeras, tu mourras. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","L’Éternel Dieu dit: Il n’est pas bon que l’homme soit seul; je lui ferai une aide semblable à lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","L’Éternel Dieu forma de la terre tous les animaux des champs et tous les oiseaux du ciel, et il les fit venir vers l’homme, pour voir comment il les appellerait, et afin que tout être vivant portât le nom que lui donnerait l’homme. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Et l’homme donna des noms à tout le bétail, aux oiseaux du ciel et à tous les animaux des champs; mais, pour l’homme, il ne trouva point d’aide semblable à lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Alors l’Éternel Dieu fit tomber un profond sommeil sur l’homme, qui s’endormit; il prit une de ses côtes, et referma la chair à sa place. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","L’Éternel Dieu forma une femme de la côte qu’il avait prise de l’homme, et il l’amena vers l’homme. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Et l’homme dit: Voici cette fois celle qui est os de mes os et chair de ma chair! On l’appellera femme, parce qu’elle a été prise de l’homme. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","C’est pourquoi l’homme quittera son père et sa mère, et s’attachera à sa femme, et ils deviendront une seule chair. ");
INSERT INTO fraLSG_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","L’homme et sa femme étaient tous deux nus, et ils n’en avaient point honte. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Le serpent était le plus rusé de tous les animaux des champs, que l’Éternel Dieu avait faits. Il dit à la femme: Dieu a-t-il réellement dit: Vous ne mangerez pas de tous les arbres du jardin? ");
INSERT INTO fraLSG_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","La femme répondit au serpent: Nous mangeons du fruit des arbres du jardin. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mais quant au fruit de l’arbre qui est au milieu du jardin, Dieu a dit: Vous n’en mangerez point et vous n’y toucherez point, de peur que vous ne mouriez. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Alors le serpent dit à la femme: Vous ne mourrez point; ");
INSERT INTO fraLSG_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","mais Dieu sait que, le jour où vous en mangerez, vos yeux s’ouvriront, et que vous serez comme des dieux, connaissant le bien et le mal. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","La femme vit que l’arbre était bon à manger et agréable à la vue, et qu’il était précieux pour ouvrir l’intelligence; elle prit de son fruit, et en mangea; elle en donna aussi à son mari, qui était auprès d’elle, et il en mangea. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Les yeux de l’un et de l’autre s’ouvrirent, ils connurent qu’ils étaient nus, et ayant cousu des feuilles de figuier, ils s’en firent des ceintures. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Alors ils entendirent la voix de l’Éternel Dieu, qui parcourait le jardin vers le soir, et l’homme et sa femme se cachèrent loin de la face de l’Éternel Dieu, au milieu des arbres du jardin. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mais l’Éternel Dieu appela l’homme, et lui dit: Où es-tu? ");
INSERT INTO fraLSG_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Il répondit: J’ai entendu ta voix dans le jardin, et j’ai eu peur, parce que je suis nu, et je me suis caché. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Et l’Éternel Dieu dit: Qui t’a appris que tu es nu? Est-ce que tu as mangé de l’arbre dont je t’avais défendu de manger? ");
INSERT INTO fraLSG_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","L’homme répondit: La femme que tu as mise auprès de moi m’a donné de l’arbre, et j’en ai mangé. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Et l’Éternel Dieu dit à la femme: Pourquoi as-tu fait cela? La femme répondit: Le serpent m’a séduite, et j’en ai mangé. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","L’Éternel Dieu dit au serpent: Puisque tu as fait cela, tu seras maudit entre tout le bétail et entre tous les animaux des champs, tu marcheras sur ton ventre, et tu mangeras de la poussière tous les jours de ta vie. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Je mettrai inimitié entre toi et la femme, entre ta postérité et sa postérité: celle-ci t’écrasera la tête, et tu lui blesseras le talon. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Il dit à la femme: J’augmenterai la souffrance de tes grossesses, tu enfanteras avec douleur, et tes désirs se porteront vers ton mari, mais il dominera sur toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Il dit à l’homme: Puisque tu as écouté la voix de ta femme, et que tu as mangé de l’arbre au sujet duquel je t’avais donné cet ordre: Tu n’en mangeras point! Le sol sera maudit à cause de toi. C’est à force de peine que tu en tireras ta nourriture tous les jours de ta vie, ");
INSERT INTO fraLSG_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","il te produira des épines et des ronces, et tu mangeras de l’herbe des champs. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","C’est à la sueur de ton visage que tu mangeras du pain, jusqu’à ce que tu retournes dans la terre, d’où tu as été pris; car tu es poussière, et tu retourneras dans la poussière. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam donna à sa femme le nom d’Ève: car elle a été la mère de tous les vivants. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","L’Éternel Dieu fit à Adam et à sa femme des habits de peau, et il les en revêtit. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","L’Éternel Dieu dit: Voici, l’homme est devenu comme l’un de nous, pour la connaissance du bien et du mal. Empêchons-le maintenant d’avancer sa main, de prendre de l’arbre de vie, d’en manger, et de vivre éternellement. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Et l’Éternel Dieu le chassa du jardin d’Éden, pour qu’il cultivât la terre, d’où il avait été pris. ");
INSERT INTO fraLSG_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","C’est ainsi qu’il chassa Adam; et il mit à l’orient du jardin d’Éden les chérubins qui agitent une épée flamboyante, pour garder le chemin de l’arbre de vie. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam connut Ève, sa femme; elle conçut, et enfanta Caïn et elle dit: J’ai formé un homme avec l’aide de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Elle enfanta encore son frère Abel. Abel fut berger, et Caïn fut laboureur. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Au bout de quelque temps, Caïn fit à l’Éternel une offrande des fruits de la terre; ");
INSERT INTO fraLSG_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","et Abel, de son côté, en fit une des premiers-nés de son troupeau et de leur graisse. L’Éternel porta un regard favorable sur Abel et sur son offrande; ");
INSERT INTO fraLSG_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","mais il ne porta pas un regard favorable sur Caïn et sur son offrande. Caïn fut très irrité, et son visage fut abattu. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Et l’Éternel dit à Caïn: Pourquoi es-tu irrité, et pourquoi ton visage est-il abattu? ");
INSERT INTO fraLSG_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Certainement, si tu agis bien, tu relèveras ton visage, et si tu agis mal, le péché se couche à la porte, et ses désirs se portent vers toi: mais toi, domine sur lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Cependant, Caïn adressa la parole à son frère Abel; mais, comme ils étaient dans les champs, Caïn se jeta sur son frère Abel, et le tua. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","L’Éternel dit à Caïn: Où est ton frère Abel? Il répondit: Je ne sais pas; suis-je le gardien de mon frère? ");
INSERT INTO fraLSG_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Et Dieu dit: Qu’as-tu fait? La voix du sang de ton frère crie de la terre jusqu’à moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Maintenant, tu seras maudit de la terre qui a ouvert sa bouche pour recevoir de ta main le sang de ton frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Quand tu cultiveras le sol, il ne te donnera plus sa richesse. Tu seras errant et vagabond sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Caïn dit à l’Éternel: Mon châtiment est trop grand pour être supporté. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Voici, tu me chasses aujourd’hui de cette terre; je serai caché loin de ta face, je serai errant et vagabond sur la terre, et quiconque me trouvera me tuera. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","L’Éternel lui dit: Si quelqu’un tuait Caïn, Caïn serait vengé sept fois. Et l’Éternel mit un signe sur Caïn pour que quiconque le trouverait ne le tuât point. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Puis, Caïn s’éloigna de la face de l’Éternel, et habita dans la terre de Nod, à l’orient d’Éden. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caïn connut sa femme; elle conçut, et enfanta Hénoc. Il bâtit ensuite une ville, et il donna à cette ville le nom de son fils Hénoc. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hénoc engendra Irad, Irad engendra Mehujaël, Mehujaël engendra Metuschaël, et Metuschaël engendra Lémec. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lémec prit deux femmes: le nom de l’une était Ada, et le nom de l’autre Tsilla. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada enfanta Jabal: il fut le père de ceux qui habitent sous des tentes et près des troupeaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Le nom de son frère était Jubal: il fut le père de tous ceux qui jouent de la harpe et du chalumeau. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Tsilla, de son côté, enfanta Tubal-Caïn, qui forgeait tous les instruments d’airain et de fer. La sœur de Tubal-Caïn était Naama. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lémec dit à ses femmes: Ada et Tsilla, écoutez ma voix! Femmes de Lémec, écoutez ma parole! J’ai tué un homme pour ma blessure, Et un jeune homme pour ma meurtrissure. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Caïn sera vengé sept fois, Et Lémec soixante-dix-sept fois. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam connut encore sa femme; elle enfanta un fils, et l’appela du nom de Seth, car, dit-elle, Dieu m’a donné un autre fils à la place d’Abel, que Caïn a tué. ");
INSERT INTO fraLSG_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth eut aussi un fils, et il l’appela du nom d’Énosch. C’est alors que l’on commença à invoquer le nom de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Voici le livre de la postérité d’Adam. Lorsque Dieu créa l’homme, il le fit à la ressemblance de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Il créa l’homme et la femme, il les bénit, et il les appela du nom d’homme, lorsqu’ils furent créés. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam, âgé de cent trente ans, engendra un fils à sa ressemblance, selon son image, et il lui donna le nom de Seth. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Les jours d’Adam, après la naissance de Seth, furent de huit cents ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tous les jours qu’Adam vécut furent de neuf cent trente ans; puis il mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth, âgé de cent cinq ans, engendra Énosch. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Seth vécut, après la naissance d’Énosch, huit cent sept ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Tous les jours de Seth furent de neuf cent douze ans; puis il mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Énosch, âgé de quatre-vingt-dix ans, engendra Kénan. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Énosch vécut, après la naissance de Kénan, huit cent quinze ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Tous les jours d’Énosch furent de neuf cent cinq ans; puis il mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kénan, âgé de soixante-dix ans, engendra Mahalaleel. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kénan vécut, après la naissance de Mahalaleel, huit cent quarante ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Tous les jours de Kénan furent de neuf cent dix ans; puis il mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel, âgé de soixante-cinq ans, engendra Jéred. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mahalaleel vécut, après la naissance de Jéred, huit cent trente ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Tous les jours de Mahalaleel furent de huit cent quatre-vingt-quinze ans; puis il mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jéred, âgé de cent soixante-deux ans, engendra Hénoc. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Jéred vécut, après la naissance d’Hénoc, huit cents ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Tous les jours de Jéred furent de neuf cent soixante-deux ans; puis il mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Hénoc, âgé de soixante-cinq ans, engendra Metuschélah. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Hénoc, après la naissance de Metuschélah, marcha avec Dieu trois cents ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Tous les jours d’Hénoc furent de trois cent soixante-cinq ans. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hénoc marcha avec Dieu; puis il ne fut plus, parce que Dieu le prit. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metuschélah, âgé de cent quatre-vingt-sept ans, engendra Lémec. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metuschélah vécut, après la naissance de Lémec, sept cent quatre-vingt-deux ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tous les jours de Metuschélah furent de neuf cent soixante-neuf ans; puis il mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lémec, âgé de cent quatre-vingt-deux ans, engendra un fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Il lui donna le nom de Noé, en disant: Celui-ci nous consolera de nos fatigues et du travail pénible de nos mains, provenant de cette terre que l’Éternel a maudite. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lémec vécut, après la naissance de Noé, cinq cent quatre-vingt-quinze ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tous les jours de Lémec furent de sept cent soixante-dix sept ans; puis il mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé, âgé de cinq cents ans, engendra Sem, Cham et Japhet. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Lorsque les hommes eurent commencé à se multiplier sur la face de la terre, et que des filles leur furent nées, ");
INSERT INTO fraLSG_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","les fils de Dieu virent que les filles des hommes étaient belles, et ils en prirent pour femmes parmi toutes celles qu’ils choisirent. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Alors l’Éternel dit: Mon esprit ne restera pas à toujours dans l’homme, car l’homme n’est que chair, et ses jours seront de cent vingt ans. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Les géants étaient sur la terre en ces temps-là, après que les fils de Dieu furent venus vers les filles des hommes, et qu’elles leur eurent donné des enfants: ce sont ces héros qui furent fameux dans l’antiquité. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","L’Éternel vit que la méchanceté des hommes était grande sur la terre, et que toutes les pensées de leur cœur se portaient chaque jour uniquement vers le mal. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","L’Éternel se repentit d’avoir fait l’homme sur la terre, et il fut affligé en son cœur. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Et l’Éternel dit: J’exterminerai de la face de la terre l’homme que j’ai créé, depuis l’homme jusqu’au bétail, aux reptiles, et aux oiseaux du ciel; car je me repens de les avoir faits. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Mais Noé trouva grâce aux yeux de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Voici la postérité de Noé. Noé était un homme juste et intègre dans son temps; Noé marchait avec Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé engendra trois fils: Sem, Cham et Japhet. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","La terre était corrompue devant Dieu, la terre était pleine de violence. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Dieu regarda la terre, et voici, elle était corrompue; car toute chair avait corrompu sa voie sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Alors Dieu dit à Noé: La fin de toute chair est arrêtée par devers moi; car ils ont rempli la terre de violence; voici, je vais les détruire avec la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Fais-toi une arche de bois de gopher; tu disposeras cette arche en cellules, et tu l’enduiras de poix en dedans et en dehors. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Voici comment tu la feras: l’arche aura trois cents coudées de longueur, cinquante coudées de largeur et trente coudées de hauteur. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tu feras à l’arche une fenêtre, que tu réduiras à une coudée en haut; tu établiras une porte sur le côté de l’arche; et tu construiras un étage inférieur, un second et un troisième. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Et moi, je vais faire venir le déluge d’eaux sur la terre, pour détruire toute chair ayant souffle de vie sous le ciel; tout ce qui est sur la terre périra. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Mais j’établis mon alliance avec toi; tu entreras dans l’arche, toi et tes fils, ta femme et les femmes de tes fils avec toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","De tout ce qui vit, de toute chair, tu feras entrer dans l’arche deux de chaque espèce, pour les conserver en vie avec toi: il y aura un mâle et une femelle. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Des oiseaux selon leur espèce, du bétail selon son espèce, et de tous les reptiles de la terre selon leur espèce, deux de chaque espèce viendront vers toi, pour que tu leur conserves la vie. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Et toi, prends de tous les aliments que l’on mange, et fais-en une provision auprès de toi, afin qu’ils te servent de nourriture ainsi qu’à eux. ");
INSERT INTO fraLSG_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","C’est ce que fit Noé: il exécuta tout ce que Dieu lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","L’Éternel dit à Noé: Entre dans l’arche, toi et toute ta maison; car je t’ai vu juste devant moi parmi cette génération. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tu prendras auprès de toi sept couples de tous les animaux purs, le mâle et sa femelle; une paire des animaux qui ne sont pas purs, le mâle et sa femelle; ");
INSERT INTO fraLSG_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","sept couples aussi des oiseaux du ciel, mâle et femelle, afin de conserver leur race en vie sur la face de toute la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Car, encore sept jours, et je ferai pleuvoir sur la terre quarante jours et quarante nuits, et j’exterminerai de la face de la terre tous les êtres que j’ai faits. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noé exécuta tout ce que l’Éternel lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noé avait six cents ans, lorsque le déluge d’eaux fut sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Et Noé entra dans l’arche avec ses fils, sa femme et les femmes de ses fils, pour échapper aux eaux du déluge. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","D’entre les animaux purs et les animaux qui ne sont pas purs, les oiseaux et tout ce qui se meut sur la terre, ");
INSERT INTO fraLSG_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","il entra dans l’arche auprès de Noé, deux à deux, un mâle et une femelle, comme Dieu l’avait ordonné à Noé. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Sept jours après, les eaux du déluge furent sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","L’an six cent de la vie de Noé, le second mois, le dix-septième jour du mois, en ce jour-là toutes les sources du grand abîme jaillirent, et les écluses des cieux s’ouvrirent. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","La pluie tomba sur la terre quarante jours et quarante nuits. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ce même jour entrèrent dans l’arche Noé, Sem, Cham et Japhet, fils de Noé, la femme de Noé et les trois femmes de ses fils avec eux: ");
INSERT INTO fraLSG_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","eux, et tous les animaux selon leur espèce, tout le bétail selon son espèce, tous les reptiles qui rampent sur la terre selon leur espèce, tous les oiseaux selon leur espèce, tous les petits oiseaux, tout ce qui a des ailes. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ils entrèrent dans l’arche auprès de Noé, deux à deux, de toute chair ayant souffle de vie. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Il en entra, mâle et femelle, de toute chair, comme Dieu l’avait ordonné à Noé. Puis l’Éternel ferma la porte sur lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Le déluge fut quarante jours sur la terre. Les eaux crûrent et soulevèrent l’arche, et elle s’éleva au-dessus de la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Les eaux grossirent et s’accrurent beaucoup sur la terre, et l’arche flotta sur la surface des eaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Les eaux grossirent de plus en plus, et toutes les hautes montagnes qui sont sous le ciel entier furent couvertes. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Les eaux s’élevèrent de quinze coudées au-dessus des montagnes, qui furent couvertes. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Tout ce qui se mouvait sur la terre périt, tant les oiseaux que le bétail et les animaux, tout ce qui rampait sur la terre, et tous les hommes. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Tout ce qui avait respiration, souffle de vie dans ses narines, et qui était sur la terre sèche, mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tous les êtres qui étaient sur la face de la terre furent exterminés, depuis l’homme jusqu’au bétail, aux reptiles et aux oiseaux du ciel: ils furent exterminés de la terre. Il ne resta que Noé, et ce qui était avec lui dans l’arche. ");
INSERT INTO fraLSG_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Les eaux furent grosses sur la terre pendant cent cinquante jours. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Dieu se souvint de Noé, de tous les animaux et de tout le bétail qui étaient avec lui dans l’arche; et Dieu fit passer un vent sur la terre, et les eaux s’apaisèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Les sources de l’abîme et les écluses des cieux furent fermées, et la pluie ne tomba plus du ciel. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Les eaux se retirèrent de dessus la terre, s’en allant et s’éloignant, et les eaux diminuèrent au bout de cent cinquante jours. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Le septième mois, le dix-septième jour du mois, l’arche s’arrêta sur les montagnes d’Ararat. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Les eaux allèrent en diminuant jusqu’au dixième mois. Le dixième mois, le premier jour du mois, apparurent les sommets des montagnes. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Au bout de quarante jours, Noé ouvrit la fenêtre qu’il avait faite à l’arche. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Il lâcha le corbeau, qui sortit, partant et revenant, jusqu’à ce que les eaux eussent séché sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Il lâcha aussi la colombe, pour voir si les eaux avaient diminué à la surface de la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Mais la colombe ne trouva aucun lieu pour poser la plante de son pied, et elle revint à lui dans l’arche, car il y avait des eaux à la surface de toute la terre. Il avança la main, la prit, et la fit rentrer auprès de lui dans l’arche. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Il attendit encore sept autres jours, et il lâcha de nouveau la colombe hors de l’arche. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","La colombe revint à lui sur le soir; et voici, une feuille d’olivier arrachée était dans son bec. Noé connut ainsi que les eaux avaient diminué sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Il attendit encore sept autres jours; et il lâcha la colombe. Mais elle ne revint plus à lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","L’an six cent un, le premier mois, le premier jour du mois, les eaux avaient séché sur la terre. Noé ôta la couverture de l’arche: il regarda, et voici, la surface de la terre avait séché. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Le second mois, le vingt-septième jour du mois, la terre fut sèche. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Alors Dieu parla à Noé, en disant: ");
INSERT INTO fraLSG_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Sors de l’arche, toi et ta femme, tes fils et les femmes de tes fils avec toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Fais sortir avec toi tous les animaux de toute chair qui sont avec toi, tant les oiseaux que le bétail et tous les reptiles qui rampent sur la terre: qu’ils se répandent sur la terre, qu’ils soient féconds et multiplient sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Et Noé sortit, avec ses fils, sa femme, et les femmes de ses fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tous les animaux, tous les reptiles, tous les oiseaux, tout ce qui se meut sur la terre, selon leurs espèces, sortirent de l’arche. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noé bâtit un autel à l’Éternel; il prit de toutes les bêtes pures et de tous les oiseaux purs, et il offrit des holocaustes sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","L’Éternel sentit une odeur agréable, et l’Éternel dit en son cœur: Je ne maudirai plus la terre, à cause de l’homme, parce que les pensées du cœur de l’homme sont mauvaises dès sa jeunesse; et je ne frapperai plus tout ce qui est vivant, comme je l’ai fait. ");
INSERT INTO fraLSG_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tant que la terre subsistera, les semailles et la moisson, le froid et la chaleur, l’été et l’hiver, le jour et la nuit ne cesseront point. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Dieu bénit Noé et ses fils, et leur dit: Soyez féconds, multipliez, et remplissez la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Vous serez un sujet de crainte et d’effroi pour tout animal de la terre, pour tout oiseau du ciel, pour tout ce qui se meut sur la terre, et pour tous les poissons de la mer: ils sont livrés entre vos mains. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tout ce qui se meut et qui a vie vous servira de nourriture: je vous donne tout cela comme l’herbe verte. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Seulement, vous ne mangerez point de chair avec son âme, avec son sang. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Sachez-le aussi, je redemanderai le sang de vos âmes, je le redemanderai à tout animal; et je redemanderai l’âme de l’homme à l’homme, à l’homme qui est son frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Si quelqu’un verse le sang de l’homme, par l’homme son sang sera versé; car Dieu a fait l’homme à son image. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Et vous, soyez féconds et multipliez, répandez-vous sur la terre et multipliez sur elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Dieu parla encore à Noé et à ses fils avec lui, en disant: ");
INSERT INTO fraLSG_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Voici, j’établis mon alliance avec vous et avec votre postérité après vous; ");
INSERT INTO fraLSG_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","avec tous les êtres vivants qui sont avec vous, tant les oiseaux que le bétail et tous les animaux de la terre, soit avec tous ceux qui sont sortis de l’arche, soit avec tous les animaux de la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","J’établis mon alliance avec vous: aucune chair ne sera plus exterminée par les eaux du déluge, et il n’y aura plus de déluge pour détruire la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Et Dieu dit: C’est ici le signe de l’alliance que j’établis entre moi et vous, et tous les êtres vivants qui sont avec vous, pour les générations à toujours: ");
INSERT INTO fraLSG_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","j’ai placé mon arc dans la nue, et il servira de signe d’alliance entre moi et la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Quand j’aurai rassemblé des nuages au-dessus de la terre, l’arc paraîtra dans la nue; ");
INSERT INTO fraLSG_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","et je me souviendrai de mon alliance entre moi et vous, et tous les êtres vivants, de toute chair, et les eaux ne deviendront plus un déluge pour détruire toute chair. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","L’arc sera dans la nue; et je le regarderai, pour me souvenir de l’alliance perpétuelle entre Dieu et tous les êtres vivants, de toute chair qui est sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Et Dieu dit à Noé: Tel est le signe de l’alliance que j’établis entre moi et toute chair qui est sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Les fils de Noé, qui sortirent de l’arche, étaient Sem, Cham et Japhet. Cham fut le père de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ce sont là les trois fils de Noé, et c’est leur postérité qui peupla toute la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noé commença à cultiver la terre, et planta de la vigne. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Il but du vin, s’enivra, et se découvrit au milieu de sa tente. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Cham, père de Canaan, vit la nudité de son père, et il le rapporta dehors à ses deux frères. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Alors Sem et Japhet prirent le manteau, le mirent sur leurs épaules, marchèrent à reculons, et couvrirent la nudité de leur père; comme leur visage était détourné, ils ne virent point la nudité de leur père. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Lorsque Noé se réveilla de son vin, il apprit ce que lui avait fait son fils cadet. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Et il dit: Maudit soit Canaan! Qu’il soit l’esclave des esclaves de ses frères! ");
INSERT INTO fraLSG_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Il dit encore: Béni soit l’Éternel, Dieu de Sem, et que Canaan soit leur esclave! ");
INSERT INTO fraLSG_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Que Dieu étende les possessions de Japhet, qu’il habite dans les tentes de Sem, et que Canaan soit leur esclave! ");
INSERT INTO fraLSG_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noé vécut, après le déluge, trois cent cinquante ans. ");
INSERT INTO fraLSG_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Tous les jours de Noé furent de neuf cent cinquante ans; puis il mourut. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Voici la postérité des fils de Noé, Sem, Cham et Japhet. Il leur naquit des fils après le déluge. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Les fils de Japhet furent: Gomer, Magog, Madaï, Javan, Tubal, Méschec et Tiras. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Les fils de Gomer: Aschkenaz, Riphat et Togarma. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Les fils de Javan: Élischa, Tarsis, Kittim et Dodanim. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","C’est par eux qu’ont été peuplées les îles des nations selon leurs terres, selon la langue de chacun, selon leurs familles, selon leurs nations. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Les fils de Cham furent: Cusch, Mitsraïm, Puth et Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Les fils de Cusch: Saba, Havila, Sabta, Raema et Sabteca. Les fils de Raema: Séba et Dedan. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cusch engendra aussi Nimrod; c’est lui qui commença à être puissant sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Il fut un vaillant chasseur devant l’Éternel; c’est pourquoi l’on dit: Comme Nimrod, vaillant chasseur devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Il régna d’abord sur Babel, Érec, Accad et Calné, au pays de Schinear. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","De ce pays-là sortit Assur; il bâtit Ninive, Rehoboth Hir, Calach, ");
INSERT INTO fraLSG_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","et Résen entre Ninive et Calach; c’est la grande ville. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mitsraïm engendra les Ludim, les Anamim, les Lehabim, les Naphtuhim, ");
INSERT INTO fraLSG_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","les Patrusim, les Casluhim, d’où sont sortis les Philistins, et les Caphtorim. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan engendra Sidon, son premier-né, et Heth; ");
INSERT INTO fraLSG_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","et les Jébusiens, les Amoréens, les Guirgasiens, ");
INSERT INTO fraLSG_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","les Héviens, les Arkiens, les Siniens, ");
INSERT INTO fraLSG_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","les Arvadiens, les Tsemariens, les Hamathiens. Ensuite, les familles des Cananéens se dispersèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Les limites des Cananéens allèrent depuis Sidon, du côté de Guérar, jusqu’à Gaza, et du côté de Sodome, de Gomorrhe, d’Adma et de Tseboïm, jusqu’à Léscha. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ce sont là les fils de Cham, selon leurs familles, selon leurs langues, selon leurs pays, selon leurs nations. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Il naquit aussi des fils à Sem, père de tous les fils d’Héber, et frère de Japhet l’aîné. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Les fils de Sem furent: Élam, Assur, Arpacschad, Lud et Aram. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Les fils d’Aram: Uts, Hul, Guéter et Masch. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpacschad engendra Schélach; et Schélach engendra Héber. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Il naquit à Héber deux fils: le nom de l’un était Péleg, parce que de son temps la terre fut partagée, et le nom de son frère était Jokthan. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Jokthan engendra Almodad, Schéleph, Hatsarmaveth, Jérach, ");
INSERT INTO fraLSG_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO fraLSG_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimaël, Séba, ");
INSERT INTO fraLSG_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir, Havila et Jobab. Tous ceux-là furent fils de Jokthan. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ils habitèrent depuis Méscha, du côté de Sephar, jusqu’à la montagne de l’orient. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ce sont là les fils de Sem, selon leurs familles, selon leurs langues, selon leurs pays, selon leurs nations. ");
INSERT INTO fraLSG_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Telles sont les familles des fils de Noé, selon leurs générations, selon leurs nations. Et c’est d’eux que sont sorties les nations qui se sont répandues sur la terre après le déluge. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Toute la terre avait une seule langue et les mêmes mots. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Comme ils étaient partis de l’orient, ils trouvèrent une plaine au pays de Schinear, et ils y habitèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Ils se dirent l’un à l’autre: Allons! Faisons des briques, et cuisons-les au feu. Et la brique leur servit de pierre, et le bitume leur servit de ciment. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ils dirent encore: Allons! Bâtissons-nous une ville et une tour dont le sommet touche au ciel, et faisons-nous un nom, afin que nous ne soyons pas dispersés sur la face de toute la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","L’Éternel descendit pour voir la ville et la tour que bâtissaient les fils des hommes. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Et l’Éternel dit: Voici, ils forment un seul peuple et ont tous une même langue, et c’est là ce qu’ils ont entrepris; maintenant rien ne les empêcherait de faire tout ce qu’ils auraient projeté. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Allons! Descendons, et là confondons leur langage, afin qu’ils n’entendent plus la langue, les uns des autres. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Et l’Éternel les dispersa loin de là sur la face de toute la terre; et ils cessèrent de bâtir la ville. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","C’est pourquoi on l’appela du nom de Babel, car c’est là que l’Éternel confondit le langage de toute la terre, et c’est de là que l’Éternel les dispersa sur la face de toute la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Voici la postérité de Sem. Sem, âgé de cent ans, engendra Arpacschad, deux ans après le déluge. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Sem vécut, après la naissance d’Arpacschad, cinq cents ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpacschad, âgé de trente-cinq ans, engendra Schélach. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpacschad vécut, après la naissance de Schélach, quatre cent trois ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Schélach, âgé de trente ans, engendra Héber. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Schélach vécut, après la naissance d’Héber, quatre cent trois ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Héber, âgé de trente-quatre ans, engendra Péleg. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Héber vécut, après la naissance de Péleg, quatre cent trente ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Péleg, âgé de trente ans, engendra Rehu. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Péleg vécut, après la naissance de Rehu, deux cent neuf ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu, âgé de trente-deux ans, engendra Serug. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Rehu vécut, après la naissance de Serug, deux cent sept ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug, âgé de trente ans, engendra Nachor. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Serug vécut, après la naissance de Nachor, deux cents ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nachor, âgé de vingt-neuf ans, engendra Térach. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nachor vécut, après la naissance de Térach, cent dix-neuf ans; et il engendra des fils et des filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Térach, âgé de soixante-dix ans, engendra Abram, Nachor et Haran. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Voici la postérité de Térach. Térach engendra Abram, Nachor et Haran. Haran engendra Lot. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Et Haran mourut en présence de Térach, son père, au pays de sa naissance, à Ur en Chaldée. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram et Nachor prirent des femmes: le nom de la femme d’Abram était Saraï, et le nom de la femme de Nachor était Milca, fille d’Haran, père de Milca et père de Jisca. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraï était stérile: elle n’avait point d’enfants. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Térach prit Abram, son fils, et Lot, fils d’Haran, fils de son fils, et Saraï, sa belle-fille, femme d’Abram, son fils. Ils sortirent ensemble d’Ur en Chaldée, pour aller au pays de Canaan. Ils vinrent jusqu’à Charan, et ils y habitèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Les jours de Térach furent de deux cent cinq ans; et Térach mourut à Charan. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","L’Éternel dit à Abram: Vat’en de ton pays, de ta patrie, et de la maison de ton père, dans le pays que je te montrerai. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Je ferai de toi une grande nation, et je te bénirai; je rendrai ton nom grand, et tu seras une source de bénédiction. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Je bénirai ceux qui te béniront, et je maudirai ceux qui te maudiront; et toutes les familles de la terre seront bénies en toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Abram partit, comme l’Éternel le lui avait dit, et Lot partit avec lui. Abram était âgé de soixante-quinze ans, lorsqu’il sortit de Charan. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram prit Saraï, sa femme, et Lot, fils de son frère, avec tous les biens qu’ils possédaient et les serviteurs qu’ils avaient acquis à Charan. Ils partirent pour aller dans le pays de Canaan, et ils arrivèrent au pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram parcourut le pays jusqu’au lieu nommé Sichem, jusqu’aux chênes de Moré. Les Cananéens étaient alors dans le pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","L’Éternel apparut à Abram, et dit: Je donnerai ce pays à ta postérité. Et Abram bâtit là un autel à l’Éternel, qui lui était apparu. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Il se transporta de là vers la montagne, à l’orient de Béthel, et il dressa ses tentes, ayant Béthel à l’occident et Aï à l’orient. Il bâtit encore là un autel à l’Éternel, et il invoqua le nom de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abram continua ses marches, en s’avançant vers le midi. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Il y eut une famine dans le pays; et Abram descendit en Égypte pour y séjourner, car la famine était grande dans le pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Comme il était près d’entrer en Égypte, il dit à Saraï, sa femme: Voici, je sais que tu es une femme belle de figure. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Quand les Égyptiens te verront, ils diront: C’est sa femme! Et ils me tueront, et te laisseront la vie. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Dis, je te prie, que tu es ma sœur, afin que je sois bien traité à cause de toi, et que mon âme vive grâce à toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Lorsque Abram fut arrivé en Égypte, les Égyptiens virent que la femme était fort belle. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Les grands de Pharaon la virent aussi et la vantèrent à Pharaon; et la femme fut emmenée dans la maison de Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Il traita bien Abram à cause d’elle; et Abram reçut des brebis, des bœufs, des ânes, des serviteurs et des servantes, des ânesses, et des chameaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Mais l’Éternel frappa de grandes plaies Pharaon et sa maison, au sujet de Saraï, femme d’Abram. ");
INSERT INTO fraLSG_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Alors Pharaon appela Abram, et dit: Qu’est-ce que tu m’as fait? Pourquoi ne m’as-tu pas déclaré que c’est ta femme? ");
INSERT INTO fraLSG_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Pourquoi as-tu dit: C’est ma sœur? Aussi l’ai-je prise pour ma femme. Maintenant, voici ta femme, prends-la, et va-t’en! ");
INSERT INTO fraLSG_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Et Pharaon donna ordre à ses gens de le renvoyer, lui et sa femme, avec tout ce qui lui appartenait. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram remonta d’Égypte vers le midi, lui, sa femme, et tout ce qui lui appartenait, et Lot avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram était très riche en troupeaux, en argent et en or. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Il dirigea ses marches du midi jusqu’à Béthel, jusqu’au lieu où était sa tente au commencement, entre Béthel et Aï, ");
INSERT INTO fraLSG_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","au lieu où était l’autel qu’il avait fait précédemment. Et là, Abram invoqua le nom de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, qui voyageait avec Abram, avait aussi des brebis, des bœufs et des tentes. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Et la contrée était insuffisante pour qu’ils demeurassent ensemble, car leurs biens étaient si considérables qu’ils ne pouvaient demeurer ensemble. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Il y eut querelle entre les bergers des troupeaux d’Abram et les bergers des troupeaux de Lot. Les Cananéens et les Phérésiens habitaient alors dans le pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abram dit à Lot: Qu’il n’y ait point, je te prie, de dispute entre moi et toi, ni entre mes bergers et tes bergers; car nous sommes frères. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tout le pays n’est-il pas devant toi? Sépare-toi donc de moi: si tu vas à gauche, j’irai à droite; si tu vas à droite, j’irai à gauche. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot leva les yeux, et vit toute la plaine du Jourdain, qui était entièrement arrosée. Avant que l’Éternel eût détruit Sodome et Gomorrhe, c’était, jusqu’à Tsoar, comme un jardin de l’Éternel, comme le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot choisit pour lui toute la plaine du Jourdain, et il s’avança vers l’orient. C’est ainsi qu’ils se séparèrent l’un de l’autre. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram habita dans le pays de Canaan; et Lot habita dans les villes de la plaine, et dressa ses tentes jusqu’à Sodome. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Les gens de Sodome étaient méchants, et de grands pécheurs contre l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","L’Éternel dit à Abram, après que Lot se fut séparé de lui: Lève les yeux, et, du lieu où tu es, regarde vers le nord et le midi, vers l’orient et l’occident; ");
INSERT INTO fraLSG_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","car tout le pays que tu vois, je le donnerai à toi et à ta postérité pour toujours. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Je rendrai ta postérité comme la poussière de la terre, en sorte que, si quelqu’un peut compter la poussière de la terre, ta postérité aussi sera comptée. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Lève-toi, parcours le pays dans sa longueur et dans sa largeur; car je te le donnerai. ");
INSERT INTO fraLSG_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram leva ses tentes, et vint habiter parmi les chênes de Mamré, qui sont près d’Hébron. Et il bâtit là un autel à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Dans le temps d’Amraphel, roi de Schinear, d’Arjoc, roi d’Ellasar, de Kedorlaomer, roi d’Élam, et de Tideal, roi de Gojim, ");
INSERT INTO fraLSG_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","il arriva qu’ils firent la guerre à Béra, roi de Sodome, à Birscha, roi de Gomorrhe, à Schineab, roi d’Adma, à Schémeéber, roi de Tseboïm, et au roi de Béla, qui est Tsoar. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ces derniers s’assemblèrent tous dans la vallée de Siddim, qui est la mer Salée. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Pendant douze ans, ils avaient été soumis à Kedorlaomer; et la treizième année, ils s’étaient révoltés. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mais, la quatorzième année, Kedorlaomer et les rois qui étaient avec lui se mirent en marche, et ils battirent les Rephaïm à Aschteroth-Karnaïm, les Zuzim à Ham, les Émim à Schavé-Kirjathaïm, ");
INSERT INTO fraLSG_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","et les Horiens dans leur montagne de Séir, jusqu’au chêne de Paran, qui est près du désert. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Puis ils s’en retournèrent, vinrent à En-Mischpath, qui est Kadès, et battirent les Amalécites sur tout leur territoire, ainsi que les Amoréens établis à Hatsatson-Thamar. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Alors s’avancèrent le roi de Sodome, le roi de Gomorrhe, le roi d’Adma, le roi de Tseboïm, et le roi de Béla, qui est Tsoar; et ils se rangèrent en bataille contre eux, dans la vallée de Siddim, ");
INSERT INTO fraLSG_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","contre Kedorlaomer, roi d’Élam, Tideal, roi de Gojim, Amraphel, roi de Schinear, et Arjoc, roi d’Ellasar: quatre rois contre cinq. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","La vallée de Siddim était couverte de puits de bitume; le roi de Sodome et celui de Gomorrhe prirent la fuite, et y tombèrent; le reste s’enfuit vers la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Les vainqueurs enlevèrent toutes les richesses de Sodome et de Gomorrhe, et toutes leurs provisions; et ils s’en allèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ils enlevèrent aussi, avec ses biens, Lot, fils du frère d’Abram, qui demeurait à Sodome; et ils s’en allèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Un fuyard vint l’annoncer à Abram, l’Hébreu; celui-ci habitait parmi les chênes de Mamré, l’Amoréen, frère d’Eschcol et frère d’Aner, qui avaient fait alliance avec Abram. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Dès qu’Abram eut appris que son frère avait été fait prisonnier, il arma trois cent dix-huit de ses plus braves serviteurs, nés dans sa maison, et il poursuivit les rois jusqu’à Dan. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Il divisa sa troupe, pour les attaquer de nuit, lui et ses serviteurs; il les battit, et les poursuivit jusqu’à Choba, qui est à la gauche de Damas. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Il ramena toutes les richesses; il ramena aussi Lot, son frère, avec ses biens, ainsi que les femmes et le peuple. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Après qu’Abram fut revenu vainqueur de Kedorlaomer et des rois qui étaient avec lui, le roi de Sodome sortit à sa rencontre dans la vallée de Schavé, qui est la vallée du roi. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Melchisédek, roi de Salem, fit apporter du pain et du vin: il était sacrificateur du Dieu Très-Haut. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Il bénit Abram, et dit: Béni soit Abram par le Dieu Très-Haut, maître du ciel et de la terre! ");
INSERT INTO fraLSG_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Béni soit le Dieu Très-Haut, qui a livré tes ennemis entre tes mains! Et Abram lui donna la dîme de tout. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Le roi de Sodome dit à Abram: Donne-moi les personnes, et prends pour toi les richesses. ");
INSERT INTO fraLSG_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram répondit au roi de Sodome: Je lève la main vers l’Éternel, le Dieu Très-Haut, maître du ciel et de la terre: ");
INSERT INTO fraLSG_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","je ne prendrai rien de tout ce qui est à toi, pas même un fil, ni un cordon de soulier, afin que tu ne dises pas: J’ai enrichi Abram. Rien pour moi! ");
INSERT INTO fraLSG_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Seulement, ce qu’ont mangé les jeunes gens, et la part des hommes qui ont marché avec moi, Aner, Eschcol et Mamré: eux, ils prendront leur part. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Après ces événements, la parole de l’Éternel fut adressée à Abram dans une vision, et il dit: Abram, ne crains point; je suis ton bouclier, et ta récompense sera très grande. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram répondit: Seigneur Éternel, que me donneras-tu? Je m’en vais sans enfants; et l’héritier de ma maison, c’est Éliézer de Damas. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Et Abram dit: Voici, tu ne m’as pas donné de postérité, et celui qui est né dans ma maison sera mon héritier. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Alors la parole de l’Éternel lui fut adressée ainsi: Ce n’est pas lui qui sera ton héritier, mais c’est celui qui sortira de tes entrailles qui sera ton héritier. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Et après l’avoir conduit dehors, il dit: Regarde vers le ciel, et compte les étoiles, si tu peux les compter. Et il lui dit: Telle sera ta postérité. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram eut confiance en l’Éternel, qui le lui imputa à justice. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","L’Éternel lui dit encore: Je suis l’Éternel, qui t’ai fait sortir d’Ur en Chaldée, pour te donner en possession ce pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram répondit: Seigneur Éternel, à quoi connaîtrai-je que je le posséderai? ");
INSERT INTO fraLSG_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Et l’Éternel lui dit: Prends une génisse de trois ans, une chèvre de trois ans, un bélier de trois ans, une tourterelle et une jeune colombe. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram prit tous ces animaux, les coupa par le milieu, et mit chaque morceau l’un vis-à-vis de l’autre; mais il ne partagea point les oiseaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Les oiseaux de proie s’abattirent sur les cadavres; et Abram les chassa. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Au coucher du soleil, un profond sommeil tomba sur Abram; et voici, une frayeur et une grande obscurité vinrent l’assaillir. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Et l’Éternel dit à Abram: Sache que tes descendants seront étrangers dans un pays qui ne sera point à eux; ils y seront asservis, et on les opprimera pendant quatre cents ans. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Mais je jugerai la nation à laquelle ils seront asservis, et ils sortiront ensuite avec de grandes richesses. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Toi, tu iras en paix vers tes pères, tu seras enterré après une heureuse vieillesse. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A la quatrième génération, ils reviendront ici; car l’iniquité des Amoréens n’est pas encore à son comble. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Quand le soleil fut couché, il y eut une obscurité profonde; et voici, ce fut une fournaise fumante, et des flammes passèrent entre les animaux partagés. ");
INSERT INTO fraLSG_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","En ce jour-là, l’Éternel fit alliance avec Abram, et dit: Je donne ce pays à ta postérité, depuis le fleuve d’Égypte jusqu’au grand fleuve, au fleuve d’Euphrate, ");
INSERT INTO fraLSG_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","le pays des Kéniens, des Keniziens, des Kadmoniens, ");
INSERT INTO fraLSG_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","des Héthiens, des Phéréziens, des Rephaïm, ");
INSERT INTO fraLSG_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","des Amoréens, des Cananéens, des Guirgasiens et des Jébusiens. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saraï, femme d’Abram, ne lui avait point donné d’enfants. Elle avait une servante égyptienne, nommée Agar. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Et Saraï dit à Abram: Voici, l’Éternel m’a rendue stérile; viens, je te prie, vers ma servante; peut-être aurai-je par elle des enfants. Abram écouta la voix de Saraï. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Alors Saraï, femme d’Abram, prit Agar, l’Égyptienne, sa servante, et la donna pour femme à Abram, son mari, après qu’Abram eut habité dix années dans le pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Il alla vers Agar, et elle devint enceinte. Quand elle se vit enceinte, elle regarda sa maîtresse avec mépris. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Et Saraï dit à Abram: L’outrage qui m’est fait retombe sur toi. J’ai mis ma servante dans ton sein; et, quand elle a vu qu’elle était enceinte, elle m’a regardée avec mépris. Que l’Éternel soit juge entre moi et toi! ");
INSERT INTO fraLSG_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram répondit à Saraï: Voici, ta servante est en ton pouvoir, agis à son égard comme tu le trouveras bon. Alors Saraï la maltraita; et Agar s’enfuit loin d’elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","L’ange de l’Éternel la trouva près d’une source d’eau dans le désert, près de la source qui est sur le chemin de Schur. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Il dit: Agar, servante de Saraï, d’où viens-tu, et où vas-tu? Elle répondit: Je fuis loin de Saraï, ma maîtresse. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","L’ange de l’Éternel lui dit: Retourne vers ta maîtresse, et humilie-toi sous sa main. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","L’ange de l’Éternel lui dit: Je multiplierai ta postérité, et elle sera si nombreuse qu’on ne pourra la compter. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","L’ange de l’Éternel lui dit: Voici, tu es enceinte, et tu enfanteras un fils, à qui tu donneras le nom d’Ismaël; car l’Éternel t’a entendue dans ton affliction. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Il sera comme un âne sauvage; sa main sera contre tous, et la main de tous sera contre lui; et il habitera en face de tous ses frères. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Elle appela Atta-El-roï le nom de l’Éternel qui lui avait parlé; car elle dit: Ai-je rien vu ici, après qu’il m’a vue? ");
INSERT INTO fraLSG_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","C’est pourquoi l’on a appelé ce puits le puits de Lachaï-roï; il est entre Kadès et Bared. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Agar enfanta un fils à Abram; et Abram donna le nom d’Ismaël au fils qu’Agar lui enfanta. ");
INSERT INTO fraLSG_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram était âgé de quatre-vingt-six ans lorsqu’Agar enfanta Ismaël à Abram. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Lorsque Abram fut âgé de quatre-vingt-dix-neuf ans, l’Éternel apparut à Abram, et lui dit: Je suis le Dieu tout-puissant. Marche devant ma face, et sois intègre. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","J’établirai mon alliance entre moi et toi, et je te multiplierai à l’infini. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram tomba sur sa face; et Dieu lui parla, en disant: ");
INSERT INTO fraLSG_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Voici mon alliance, que je fais avec toi. Tu deviendras père d’une multitude de nations. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","On ne t’appellera plus Abram; mais ton nom sera Abraham, car je te rends père d’une multitude de nations. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Je te rendrai fécond à l’infini, je ferai de toi des nations; et des rois sortiront de toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","J’établirai mon alliance entre moi et toi, et tes descendants après toi, selon leurs générations: ce sera une alliance perpétuelle, en vertu de laquelle je serai ton Dieu et celui de ta postérité après toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Je te donnerai, et à tes descendants après toi, le pays que tu habites comme étranger, tout le pays de Canaan, en possession perpétuelle, et je serai leur Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Dieu dit à Abraham: Toi, tu garderas mon alliance, toi et tes descendants après toi, selon leurs générations. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","C’est ici mon alliance, que vous garderez entre moi et vous, et ta postérité après toi: tout mâle parmi vous sera circoncis. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Vous vous circoncirez; et ce sera un signe d’alliance entre moi et vous. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","A l’âge de huit jours, tout mâle parmi vous sera circoncis, selon vos générations, qu’il soit né dans la maison, ou qu’il soit acquis à prix d’argent de tout fils d’étranger, sans appartenir à ta race. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","On devra circoncire celui qui est né dans la maison et celui qui est acquis à prix d’argent; et mon alliance sera dans votre chair une alliance perpétuelle. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Un mâle incirconcis, qui n’aura pas été circoncis dans sa chair, sera exterminé du milieu de son peuple: il aura violé mon alliance. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Dieu dit à Abraham: Tu ne donneras plus à Saraï, ta femme, le nom de Saraï; mais son nom sera Sara. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Je la bénirai, et je te donnerai d’elle un fils; je la bénirai, et elle deviendra des nations; des rois de peuples sortiront d’elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraham tomba sur sa face; il rit, et dit en son cœur: Naîtrait-il un fils à un homme de cent ans? Et Sara, âgée de quatre-vingt-dix ans, enfanterait-elle? ");
INSERT INTO fraLSG_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Et Abraham dit à Dieu: Oh! Qu’Ismaël vive devant ta face! ");
INSERT INTO fraLSG_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Dieu dit: Certainement Sara, ta femme, t’enfantera un fils; et tu l’appelleras du nom d’Isaac. J’établirai mon alliance avec lui comme une alliance perpétuelle pour sa postérité après lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","A l’égard d’Ismaël, je t’ai exaucé. Voici, je le bénirai, je le rendrai fécond, et je le multiplierai à l’infini; il engendrera douze princes, et je ferai de lui une grande nation. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","J’établirai mon alliance avec Isaac, que Sara t’enfantera à cette époque-ci de l’année prochaine. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Lorsqu’il eut achevé de lui parler, Dieu s’éleva au-dessus d’Abraham. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abraham prit Ismaël, son fils, tous ceux qui étaient nés dans sa maison et tous ceux qu’il avait acquis à prix d’argent, tous les mâles parmi les gens de la maison d’Abraham; et il les circoncit ce même jour, selon l’ordre que Dieu lui avait donné. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham était âgé de quatre-vingt-dix-neuf ans, lorsqu’il fut circoncis. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ismaël, son fils, était âgé de treize ans lorsqu’il fut circoncis. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ce même jour, Abraham fut circoncis, ainsi qu’Ismaël, son fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Et tous les gens de sa maison, nés dans sa maison, ou acquis à prix d’argent des étrangers, furent circoncis avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","L’Éternel lui apparut parmi les chênes de Mamré, comme il était assis à l’entrée de sa tente, pendant la chaleur du jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Il leva les yeux, et regarda: et voici, trois hommes étaient debout près de lui. Quand il les vit, il courut au-devant d’eux, depuis l’entrée de sa tente, et se prosterna en terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Et il dit: Seigneur, si j’ai trouvé grâce à tes yeux, ne passe point, je te prie, loin de ton serviteur. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Permettez qu’on apporte un peu d’eau, pour vous laver les pieds; et reposez-vous sous cet arbre. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","J’irai prendre un morceau de pain, pour fortifier votre cœur; après quoi, vous continuerez votre route; car c’est pour cela que vous passez près de votre serviteur. Ils répondirent: Fais comme tu l’as dit. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham alla promptement dans sa tente vers Sara, et il dit: Vite, trois mesures de fleur de farine, pétris, et fais des gâteaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Et Abraham courut à son troupeau, prit un veau tendre et bon, et le donna à un serviteur, qui se hâta de l’apprêter. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Il prit encore de la crème et du lait, avec le veau qu’on avait apprêté, et il les mit devant eux. Il se tint lui-même à leurs côtés, sous l’arbre. Et ils mangèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Alors ils lui dirent: Où est Sara, ta femme? Il répondit: Elle est là, dans la tente. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","L’un d’entre eux dit: Je reviendrai vers toi à cette même époque; et voici, Sara, ta femme, aura un fils. Sara écoutait à l’entrée de la tente, qui était derrière lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham et Sara étaient vieux, avancés en âge: et Sara ne pouvait plus espérer avoir des enfants. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Elle rit en elle-même, en disant: Maintenant que je suis vieille, aurais-je encore des désirs? Mon seigneur aussi est vieux. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","L’Éternel dit à Abraham: Pourquoi donc Sara a-t-elle ri, en disant: Est-ce que vraiment j’aurais un enfant, moi qui suis vieille? ");
INSERT INTO fraLSG_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Y a-t-il rien qui soit étonnant de la part de l’Éternel? Au temps fixé je reviendrai vers toi, à cette même époque; et Sara aura un fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sara mentit, en disant: Je n’ai pas ri. Car elle eut peur. Mais il dit: Au contraire, tu as ri. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ces hommes se levèrent pour partir, et ils regardèrent du côté de Sodome. Abraham alla avec eux, pour les accompagner. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Alors l’Éternel dit: Cacherai-je à Abraham ce que je vais faire?… ");
INSERT INTO fraLSG_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abraham deviendra certainement une nation grande et puissante, et en lui seront bénies toutes les nations de la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Car je l’ai choisi, afin qu’il ordonne à ses fils et à sa maison après lui de garder la voie de l’Éternel, en pratiquant la droiture et la justice, et qu’ainsi l’Éternel accomplisse en faveur d’Abraham les promesses qu’il lui a faites… ");
INSERT INTO fraLSG_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Et l’Éternel dit: Le cri contre Sodome et Gomorrhe s’est accru, et leur péché est énorme. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","C’est pourquoi je vais descendre, et je verrai s’ils ont agi entièrement selon le bruit venu jusqu’à moi; et si cela n’est pas, je le saurai. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Les hommes s’éloignèrent, et allèrent vers Sodome. Mais Abraham se tint encore en présence de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham s’approcha, et dit: Feras-tu aussi périr le juste avec le méchant? ");
INSERT INTO fraLSG_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Peut-être y a-t-il cinquante justes au milieu de la ville: les feras-tu périr aussi, et ne pardonneras-tu pas à la ville à cause des cinquante justes qui sont au milieu d’elle? ");
INSERT INTO fraLSG_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Faire mourir le juste avec le méchant, en sorte qu’il en soit du juste comme du méchant, loin de toi cette manière d’agir! Loin de toi! Celui qui juge toute la terre n’exercera-t-il pas la justice? ");
INSERT INTO fraLSG_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Et l’Éternel dit: Si je trouve dans Sodome cinquante justes au milieu de la ville, je pardonnerai à toute la ville, à cause d’eux. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham reprit, et dit: Voici, j’ai osé parler au Seigneur, moi qui ne suis que poudre et cendre. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Peut-être des cinquante justes en manquera-t-il cinq: pour cinq, détruiras-tu toute la ville? Et l’Éternel dit: Je ne la détruirai point, si j’y trouve quarante-cinq justes. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abraham continua de lui parler, et dit: Peut-être s’y trouvera-t-il quarante justes. Et l’Éternel dit: Je ne ferai rien, à cause de ces quarante. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham dit: Que le Seigneur ne s’irrite point, et je parlerai. Peut-être s’y trouvera-t-il trente justes. Et l’Éternel dit: Je ne ferai rien, si j’y trouve trente justes. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham dit: Voici, j’ai osé parler au Seigneur. Peut-être s’y trouvera-t-il vingt justes. Et l’Éternel dit: Je ne la détruirai point, à cause de ces vingt. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham dit: Que le Seigneur ne s’irrite point, et je ne parlerai plus que cette fois. Peut-être s’y trouvera-t-il dix justes. Et l’Éternel dit: Je ne la détruirai point, à cause de ces dix justes. ");
INSERT INTO fraLSG_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","L’Éternel s’en alla lorsqu’il eut achevé de parler à Abraham. Et Abraham retourna dans sa demeure. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Les deux anges arrivèrent à Sodome sur le soir; et Lot était assis à la porte de Sodome. Quand Lot les vit, il se leva pour aller au-devant d’eux, et se prosterna la face contre terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Puis il dit: Voici, mes seigneurs, entrez, je vous prie, dans la maison de votre serviteur, et passez-y la nuit; lavez-vous les pieds; vous vous lèverez de bon matin, et vous poursuivrez votre route. Non, répondirent-ils, nous passerons la nuit dans la rue. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Mais Lot les pressa tellement qu’ils vinrent chez lui et entrèrent dans sa maison. Il leur donna un festin, et fit cuire des pains sans levain. Et ils mangèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Ils n’étaient pas encore couchés que les gens de la ville, les gens de Sodome, entourèrent la maison, depuis les enfants jusqu’aux vieillards; toute la population était accourue. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ils appelèrent Lot, et lui dirent: Où sont les hommes qui sont entrés chez toi cette nuit? Fais-les sortir vers nous, pour que nous les connaissions. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot sortit vers eux à l’entrée de la maison, et ferma la porte derrière lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Et il dit: Mes frères, je vous prie, ne faites pas le mal! ");
INSERT INTO fraLSG_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Voici, j’ai deux filles qui n’ont point connu d’homme; je vous les amènerai dehors, et vous leur ferez ce qu’il vous plaira. Seulement, ne faites rien à ces hommes puisqu’ils sont venus à l’ombre de mon toit. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ils dirent: Retire-toi! Ils dirent encore: Celui-ci est venu comme étranger, et il veut faire le juge! Eh bien, nous te ferons pis qu’à eux. Et, pressant Lot avec violence, ils s’avancèrent pour briser la porte. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Les hommes étendirent la main, firent rentrer Lot vers eux dans la maison, et fermèrent la porte. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Et ils frappèrent d’aveuglement les gens qui étaient à l’entrée de la maison, depuis le plus petit jusqu’au plus grand, de sorte qu’ils se donnèrent une peine inutile pour trouver la porte. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Les hommes dirent à Lot: Qui as-tu encore ici? Gendres, fils et filles, et tout ce qui t’appartient dans la ville, fais-les sortir de ce lieu. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Car nous allons détruire ce lieu, parce que le cri contre ses habitants est grand devant l’Éternel. L’Éternel nous a envoyés pour le détruire. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot sortit, et parla à ses gendres qui avaient pris ses filles: Levez-vous, dit-il, sortez de ce lieu; car l’Éternel va détruire la ville. Mais, aux yeux de ses gendres, il parut plaisanter. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Dès l’aube du jour, les anges insistèrent auprès de Lot, en disant: Lève-toi, prends ta femme et tes deux filles qui se trouvent ici, de peur que tu ne périsses dans la ruine de la ville. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Et comme il tardait, les hommes le saisirent par la main, lui, sa femme et ses deux filles, car l’Éternel voulait l’épargner; ils l’emmenèrent, et le laissèrent hors de la ville. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Après les avoir fait sortir, l’un d’eux dit: Sauve-toi, pour ta vie; ne regarde pas derrière toi, et ne t’arrête pas dans toute la plaine; sauve-toi vers la montagne, de peur que tu ne périsses. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot leur dit: Oh! Non, Seigneur! ");
INSERT INTO fraLSG_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Voici, j’ai trouvé grâce à tes yeux, et tu as montré la grandeur de ta miséricorde à mon égard, en me conservant la vie; mais je ne puis me sauver à la montagne, avant que le désastre m’atteigne, et je périrai. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Voici, cette ville est assez proche pour que je m’y réfugie, et elle est petite. Oh! Que je puisse m’y sauver,… n’est-elle pas petite?… et que mon âme vive! ");
INSERT INTO fraLSG_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Et il lui dit: Voici, je t’accorde encore cette grâce, et je ne détruirai pas la ville dont tu parles. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Hâte-toi de t’y réfugier, car je ne puis rien faire jusqu’à ce que tu y sois arrivé. C’est pour cela que l’on a donné à cette ville le nom de Tsoar. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Le soleil se levait sur la terre, lorsque Lot entra dans Tsoar. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Alors l’Éternel fit pleuvoir du ciel sur Sodome et sur Gomorrhe du soufre et du feu, de par l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Il détruisit ces villes, toute la plaine et tous les habitants des villes, et les plantes de la terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","La femme de Lot regarda en arrière, et elle devint une statue de sel. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abraham se leva de bon matin, pour aller au lieu où il s’était tenu en présence de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Il porta ses regards du côté de Sodome et de Gomorrhe, et sur tout le territoire de la plaine; et voici, il vit s’élever de la terre une fumée, comme la fumée d’une fournaise. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Lorsque Dieu détruisit les villes de la plaine, il se souvint d’Abraham; et il fit échapper Lot du milieu du désastre, par lequel il bouleversa les villes où Lot avait établi sa demeure. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lot quitta Tsoar pour la hauteur, et se fixa sur la montagne, avec ses deux filles, car il craignait de rester à Tsoar. Il habita dans une caverne, lui et ses deux filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","L’aînée dit à la plus jeune: Notre père est vieux; et il n’y a point d’homme dans la contrée, pour venir vers nous, selon l’usage de tous les pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Viens, faisons boire du vin à notre père, et couchons avec lui, afin que nous conservions la race de notre père. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Elles firent donc boire du vin à leur père cette nuit-là; et l’aînée alla coucher avec son père: il ne s’aperçut ni quand elle se coucha, ni quand elle se leva. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Le lendemain, l’aînée dit à la plus jeune: Voici, j’ai couché la nuit dernière avec mon père; faisons-lui boire du vin encore cette nuit, et va coucher avec lui, afin que nous conservions la race de notre père. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Elles firent boire du vin à leur père encore cette nuit-là; et la cadette alla coucher avec lui: il ne s’aperçut ni quand elle se coucha, ni quand elle se leva. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Les deux filles de Lot devinrent enceintes de leur père. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","L’aînée enfanta un fils, qu’elle appela du nom de Moab: c’est le père des Moabites, jusqu’à ce jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","La plus jeune enfanta aussi un fils, qu’elle appela du nom de Ben-Ammi: c’est le père des Ammonites, jusqu’à ce jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham partit de là pour la contrée du midi; il s’établit entre Kadès et Schur, et fit un séjour à Guérar. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham disait de Sara, sa femme: C’est ma sœur. Abimélec, roi de Guérar, fit enlever Sara. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Alors Dieu apparut en songe à Abimélec pendant la nuit, et lui dit: Voici, tu vas mourir à cause de la femme que tu as enlevée, car elle a un mari. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimélec, qui ne s’était point approché d’elle, répondit: Seigneur, ferais-tu périr même une nation juste? ");
INSERT INTO fraLSG_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ne m’a-t-il pas dit: C’est ma sœur? Et elle-même n’a-t-elle pas dit: C’est mon frère? J’ai agi avec un cœur pur et avec des mains innocentes. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Dieu lui dit en songe: Je sais que tu as agi avec un cœur pur; aussi t’ai-je empêché de pécher contre moi. C’est pourquoi je n’ai pas permis que tu la touchasses. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Maintenant, rends la femme de cet homme; car il est prophète, il priera pour toi, et tu vivras. Mais, si tu ne la rends pas, sache que tu mourras, toi et tout ce qui t’appartient. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimélec se leva de bon matin, il appela tous ses serviteurs, et leur rapporta toutes ces choses; et ces gens furent saisis d’une grande frayeur. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimélec appela aussi Abraham, et lui dit: Qu’est-ce que tu nous as fait? Et en quoi t’ai-je offensé, que tu aies fait venir sur moi et sur mon royaume un si grand péché? Tu as commis à mon égard des actes qui ne doivent pas se commettre. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Et Abimélec dit à Abraham: Quelle intention avais-tu pour agir de la sorte? ");
INSERT INTO fraLSG_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham répondit: Je me disais qu’il n’y avait sans doute aucune crainte de Dieu dans ce pays, et que l’on me tuerait à cause de ma femme. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","De plus, il est vrai qu’elle est ma sœur, fille de mon père; seulement, elle n’est pas fille de ma mère; et elle est devenue ma femme. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Lorsque Dieu me fit errer loin de la maison de mon père, je dis à Sara: Voici la grâce que tu me feras; dans tous les lieux où nous irons, dis de moi: C’est mon frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimélec prit des brebis et des bœufs, des serviteurs et des servantes, et les donna à Abraham; et il lui rendit Sara, sa femme. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimélec dit: Voici, mon pays est devant toi; demeure où il te plaira. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Et il dit à Sara: Voici, je donne à ton frère mille pièces d’argent; cela te sera un voile sur les yeux pour tous ceux qui sont avec toi, et auprès de tous tu seras justifiée. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham pria Dieu, et Dieu guérit Abimélec, sa femme et ses servantes; et elles purent enfanter. ");
INSERT INTO fraLSG_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Car l’Éternel avait frappé de stérilité toute la maison d’Abimélec, à cause de Sara, femme d’Abraham. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","L’Éternel se souvint de ce qu’il avait dit à Sara, et l’Éternel accomplit pour Sara ce qu’il avait promis. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara devint enceinte, et elle enfanta un fils à Abraham dans sa vieillesse, au temps fixé dont Dieu lui avait parlé. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham donna le nom d’Isaac au fils qui lui était né, que Sara lui avait enfanté. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abraham circoncit son fils Isaac, âgé de huit jours, comme Dieu le lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham était âgé de cent ans, à la naissance d’Isaac, son fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Et Sara dit: Dieu m’a fait un sujet de rire; quiconque l’apprendra rira de moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Elle ajouta: Qui aurait dit à Abraham: Sara allaitera des enfants? Cependant je lui ai enfanté un fils dans sa vieillesse. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","L’enfant grandit, et fut sevré; et Abraham fit un grand festin le jour où Isaac fut sevré. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Sara vit rire le fils qu’Agar, l’Égyptienne, avait enfanté à Abraham; ");
INSERT INTO fraLSG_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","et elle dit à Abraham: Chasse cette servante et son fils, car le fils de cette servante n’héritera pas avec mon fils, avec Isaac. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Cette parole déplut fort aux yeux d’Abraham, à cause de son fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Mais Dieu dit à Abraham: Que cela ne déplaise pas à tes yeux, à cause de l’enfant et de ta servante. Accorde à Sara tout ce qu’elle te demandera; car c’est d’Isaac que sortira une postérité qui te sera propre. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Je ferai aussi une nation du fils de ta servante; car il est ta postérité. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abraham se leva de bon matin; il prit du pain et une outre d’eau, qu’il donna à Agar et plaça sur son épaule; il lui remit aussi l’enfant, et la renvoya. Elle s’en alla, et s’égara dans le désert de Beer-Schéba. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Quand l’eau de l’outre fut épuisée, elle laissa l’enfant sous un des arbrisseaux, ");
INSERT INTO fraLSG_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","et alla s’asseoir vis-à-vis, à une portée d’arc; car elle disait: Que je ne voie pas mourir mon enfant! Elle s’assit donc vis-à-vis de lui, éleva la voix et pleura. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Dieu entendit la voix de l’enfant; et l’ange de Dieu appela du ciel Agar, et lui dit: Qu’as-tu, Agar? Ne crains point, car Dieu a entendu la voix de l’enfant dans le lieu où il est. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Lève-toi, prends l’enfant, saisis-le de ta main; car je ferai de lui une grande nation. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Et Dieu lui ouvrit les yeux, et elle vit un puits d’eau; elle alla remplir d’eau l’outre, et donna à boire à l’enfant. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Dieu fut avec l’enfant, qui grandit, habita dans le désert, et devint tireur d’arc. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Il habita dans le désert de Paran, et sa mère lui prit une femme du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","En ce temps-là, Abimélec, accompagné de Picol, chef de son armée, parla ainsi à Abraham: Dieu est avec toi dans tout ce que tu fais. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Jure-moi maintenant ici, par le nom de Dieu, que tu ne tromperas ni moi, ni mes enfants, ni mes petits-enfants, et que tu auras pour moi et le pays où tu séjournes la même bienveillance que j’ai eue pour toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham dit: Je le jurerai. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Mais Abraham fit des reproches à Abimélec, au sujet d’un puits d’eau, dont s’étaient emparés de force les serviteurs d’Abimélec. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimélec répondit: J’ignore qui a fait cette chose-là; tu ne m’en as point informé, et moi, je ne l’apprends qu’aujourd’hui. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Et Abraham prit des brebis et des bœufs, qu’il donna à Abimélec; et ils firent tous deux alliance. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham mit à part sept jeunes brebis. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Et Abimélec dit à Abraham: Qu’est-ce que ces sept jeunes brebis, que tu as mises à part? ");
INSERT INTO fraLSG_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Il répondit: Tu accepteras de ma main ces sept brebis, afin que cela me serve de témoignage que j’ai creusé ce puits. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","C’est pourquoi on appelle ce lieu Beer-Schéba; car c’est là qu’ils jurèrent l’un et l’autre. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ils firent donc alliance à Beer-Schéba. Après quoi, Abimélec se leva, avec Picol, chef de son armée; et ils retournèrent au pays des Philistins. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham planta des tamaris à Beer-Schéba; et là il invoqua le nom de l’Éternel, Dieu de l’éternité. ");
INSERT INTO fraLSG_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abraham séjourna longtemps dans le pays des Philistins. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Après ces choses, Dieu mit Abraham à l’épreuve, et lui dit: Abraham! Et il répondit: Me voici! ");
INSERT INTO fraLSG_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Dieu dit: Prends ton fils, ton unique, celui que tu aimes, Isaac; va-t’en au pays de Morija, et là offre-le en holocauste sur l’une des montagnes que je te dirai. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abraham se leva de bon matin, sella son âne, et prit avec lui deux serviteurs et son fils Isaac. Il fendit du bois pour l’holocauste, et partit pour aller au lieu que Dieu lui avait dit. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Le troisième jour, Abraham, levant les yeux, vit le lieu de loin. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Et Abraham dit à ses serviteurs: Restez ici avec l’âne; moi et le jeune homme, nous irons jusque-là pour adorer, et nous reviendrons auprès de vous. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham prit le bois pour l’holocauste, le chargea sur son fils Isaac, et porta dans sa main le feu et le couteau. Et ils marchèrent tous deux ensemble. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Alors Isaac, parlant à Abraham, son père, dit: Mon père! Et il répondit: Me voici, mon fils! Isaac reprit: Voici le feu et le bois; mais où est l’agneau pour l’holocauste? ");
INSERT INTO fraLSG_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham répondit: Mon fils, Dieu se pourvoira lui-même de l’agneau pour l’holocauste. Et ils marchèrent tous deux ensemble. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Lorsqu’ils furent arrivés au lieu que Dieu lui avait dit, Abraham y éleva un autel, et rangea le bois. Il lia son fils Isaac, et le mit sur l’autel, par-dessus le bois. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Puis Abraham étendit la main, et prit le couteau, pour égorger son fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Alors l’ange de l’Éternel l’appela des cieux, et dit: Abraham! Abraham! Et il répondit: Me voici! ");
INSERT INTO fraLSG_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","L’ange dit: N’avance pas ta main sur l’enfant, et ne lui fais rien; car je sais maintenant que tu crains Dieu, et que tu ne m’as pas refusé ton fils, ton unique. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abraham leva les yeux, et vit derrière lui un bélier retenu dans un buisson par les cornes; et Abraham alla prendre le bélier, et l’offrit en holocauste à la place de son fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham donna à ce lieu le nom de Jehova-Jiré. C’est pourquoi l’on dit aujourd’hui: A la montagne de l’Éternel il sera pourvu. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","L’ange de l’Éternel appela une seconde fois Abraham des cieux, ");
INSERT INTO fraLSG_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","et dit: Je le jure par moi-même, parole de l’Éternel! Parce que tu as fait cela, et que tu n’as pas refusé ton fils, ton unique, ");
INSERT INTO fraLSG_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","je te bénirai et je multiplierai ta postérité, comme les étoiles du ciel et comme le sable qui est sur le bord de la mer; et ta postérité possédera la porte de ses ennemis. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Toutes les nations de la terre seront bénies en ta postérité, parce que tu as obéi à ma voix. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Abraham étant retourné vers ses serviteurs, ils se levèrent et s’en allèrent ensemble à Beer-Schéba; car Abraham demeurait à Beer-Schéba. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Après ces choses, on fit à Abraham un rapport, en disant: Voici, Milca a aussi enfanté des fils à Nachor, ton frère: ");
INSERT INTO fraLSG_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uts, son premier-né, Buz, son frère, Kemuel, père d’Aram, ");
INSERT INTO fraLSG_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Késed, Hazo, Pildasch, Jidlaph et Bethuel. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel a engendré Rebecca. Ce sont là les huit fils que Milca a enfantés à Nachor, frère d’Abraham. ");
INSERT INTO fraLSG_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Sa concubine, nommée Réuma, a aussi enfanté Thébach, Gaham, Tahasch et Maaca. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","La vie de Sara fut de cent vingt-sept ans: telles sont les années de la vie de Sara. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sara mourut à Kirjath-Arba, qui est Hébron, dans le pays de Canaan; et Abraham vint pour mener deuil sur Sara et pour la pleurer. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abraham se leva de devant son mort, et parla ainsi aux fils de Heth: ");
INSERT INTO fraLSG_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Je suis étranger et habitant parmi vous; donnez-moi la possession d’un sépulcre chez vous, pour enterrer mon mort et l’ôter de devant moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Les fils de Heth répondirent à Abraham, en lui disant: ");
INSERT INTO fraLSG_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Écoute-nous, mon seigneur! Tu es un prince de Dieu au milieu de nous; enterre ton mort dans celui de nos sépulcres que tu choisiras; aucun de nous ne te refusera son sépulcre pour enterrer ton mort. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham se leva, et se prosterna devant le peuple du pays, devant les fils de Heth. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Et il leur parla ainsi: Si vous permettez que j’enterre mon mort et que je l’ôte de devant mes yeux, écoutez-moi, et priez pour moi Éphron, fils de Tsochar, ");
INSERT INTO fraLSG_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","de me céder la caverne de Macpéla, qui lui appartient, à l’extrémité de son champ, de me la céder contre sa valeur en argent, afin qu’elle me serve de possession sépulcrale au milieu de vous. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Éphron était assis parmi les fils de Heth. Et Éphron, le Héthien, répondit à Abraham, en présence des fils de Heth et de tous ceux qui entraient par la porte de sa ville: ");
INSERT INTO fraLSG_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Non, mon seigneur, écoute-moi! Je te donne le champ, et je te donne la caverne qui y est. Je te les donne, aux yeux des fils de mon peuple: enterre ton mort. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham se prosterna devant le peuple du pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Et il parla ainsi à Éphron, en présence du peuple du pays: Écoute-moi, je te prie! Je donne le prix du champ: accepte-le de moi; et j’y enterrerai mon mort. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Et Éphron répondit à Abraham, en lui disant: ");
INSERT INTO fraLSG_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Mon seigneur, écoute-moi! Une terre de quatre cents sicles d’argent, qu’est-ce que cela entre moi et toi? Enterre ton mort. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham comprit Éphron; et Abraham pesa à Éphron l’argent qu’il avait dit, en présence des fils de Heth, quatre cents sicles d’argent ayant cours chez le marchand. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Le champ d’Éphron à Macpéla, vis-à-vis de Mamré, le champ et la caverne qui y est, et tous les arbres qui sont dans le champ et dans toutes ses limites alentour, ");
INSERT INTO fraLSG_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","devinrent ainsi la propriété d’Abraham, aux yeux des fils de Heth et de tous ceux qui entraient par la porte de sa ville. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Après cela, Abraham enterra Sara, sa femme, dans la caverne du champ de Macpéla, vis-à-vis de Mamré, qui est Hébron, dans le pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Le champ et la caverne qui y est demeurèrent à Abraham comme possession sépulcrale, acquise des fils de Heth. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham était vieux, avancé en âge; et l’Éternel avait béni Abraham en toute chose. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abraham dit à son serviteur, le plus ancien de sa maison, l’intendant de tous ses biens: Mets, je te prie, ta main sous ma cuisse; ");
INSERT INTO fraLSG_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","et je te ferai jurer par l’Éternel, le Dieu du ciel et le Dieu de la terre, de ne pas prendre pour mon fils une femme parmi les filles des Cananéens au milieu desquels j’habite, ");
INSERT INTO fraLSG_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","mais d’aller dans mon pays et dans ma patrie prendre une femme pour mon fils Isaac. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Le serviteur lui répondit: Peut-être la femme ne voudra-t-elle pas me suivre dans ce pays-ci; devrai-je mener ton fils dans le pays d’où tu es sorti? ");
INSERT INTO fraLSG_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham lui dit: Garde-toi d’y mener mon fils! ");
INSERT INTO fraLSG_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","L’Éternel, le Dieu du ciel, qui m’a fait sortir de la maison de mon père et de ma patrie, qui m’a parlé et qui m’a juré, en disant: Je donnerai ce pays à ta postérité, lui-même enverra son ange devant toi; et c’est de là que tu prendras une femme pour mon fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Si la femme ne veut pas te suivre, tu seras dégagé de ce serment que je te fais faire. Seulement, tu n’y mèneras pas mon fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Le serviteur mit sa main sous la cuisse d’Abraham, son seigneur, et lui jura d’observer ces choses. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Le serviteur prit dix chameaux parmi les chameaux de son seigneur, et il partit, ayant à sa disposition tous les biens de son seigneur. Il se leva, et alla en Mésopotamie, à la ville de Nachor. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Il fit reposer les chameaux sur leurs genoux hors de la ville, près d’un puits, au temps du soir, au temps où sortent celles qui vont puiser de l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Et il dit: Éternel, Dieu de mon seigneur Abraham, fais-moi, je te prie, rencontrer aujourd’hui ce que je désire, et use de bonté envers mon seigneur Abraham! ");
INSERT INTO fraLSG_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Voici, je me tiens près de la source d’eau, et les filles des gens de la ville vont sortir pour puiser de l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Que la jeune fille à laquelle je dirai: Penche ta cruche, je te prie, pour que je boive, et qui répondra: Bois, et je donnerai aussi à boire à tes chameaux, soit celle que tu as destinée à ton serviteur Isaac! Et par là je connaîtrai que tu uses de bonté envers mon seigneur. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Il n’avait pas encore fini de parler que sortit, sa cruche sur l’épaule, Rebecca, née de Bethuel, fils de Milca, femme de Nachor, frère d’Abraham. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","C’était une jeune fille très belle de figure; elle était vierge, et aucun homme ne l’avait connue. Elle descendit à la source, remplit sa cruche, et remonta. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Le serviteur courut au-devant d’elle, et dit: Laisse-moi boire, je te prie, un peu d’eau de ta cruche. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Elle répondit: Bois, mon seigneur. Et elle s’empressa d’abaisser sa cruche sur sa main, et de lui donner à boire. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Quand elle eut achevé de lui donner à boire, elle dit: Je puiserai aussi pour tes chameaux, jusqu’à ce qu’ils aient assez bu. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Et elle s’empressa de vider sa cruche dans l’abreuvoir, et courut encore au puits pour puiser; et elle puisa pour tous les chameaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","L’homme la regardait avec étonnement et sans rien dire, pour voir si l’Éternel faisait réussir son voyage, ou non. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Quand les chameaux eurent fini de boire, l’homme prit un anneau d’or, du poids d’un demi-sicle, et deux bracelets, du poids de dix sicles d’or. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Et il dit: De qui es-tu fille? Dis-le moi, je te prie. Y a-t-il dans la maison de ton père de la place pour passer la nuit? ");
INSERT INTO fraLSG_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Elle répondit: Je suis fille de Bethuel, fils de Milca et de Nachor. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Elle lui dit encore: Il y a chez nous de la paille et du fourrage en abondance, et aussi de la place pour passer la nuit. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Alors l’homme s’inclina et se prosterna devant l’Éternel, ");
INSERT INTO fraLSG_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","en disant: Béni soit l’Éternel, le Dieu de mon seigneur Abraham, qui n’a pas renoncé à sa miséricorde et à sa fidélité envers mon seigneur! Moi-même, l’Éternel m’a conduit à la maison des frères de mon seigneur. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","La jeune fille courut raconter ces choses à la maison de sa mère. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebecca avait un frère, nommé Laban. Et Laban courut dehors vers l’homme, près de la source. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Il avait vu l’anneau et les bracelets aux mains de sa sœur, et il avait entendu les paroles de Rebecca, sa sœur, disant: Ainsi m’a parlé l’homme. Il vint donc à cet homme qui se tenait auprès des chameaux, vers la source, ");
INSERT INTO fraLSG_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","et il dit: Viens, béni de l’Éternel! Pourquoi resterais-tu dehors? J’ai préparé la maison, et une place pour les chameaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","L’homme arriva à la maison. Laban fit décharger les chameaux, et il donna de la paille et du fourrage aux chameaux, et de l’eau pour laver les pieds de l’homme et les pieds des gens qui étaient avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Puis, il lui servit à manger. Mais il dit: Je ne mangerai point, avant d’avoir dit ce que j’ai à dire. Parle! Dit Laban. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Alors il dit: Je suis serviteur d’Abraham. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","L’Éternel a comblé de bénédictions mon seigneur, qui est devenu puissant. Il lui a donné des brebis et des bœufs, de l’argent et de l’or, des serviteurs et des servantes, des chameaux et des ânes. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Sara, la femme de mon seigneur, a enfanté dans sa vieillesse un fils à mon seigneur; et il lui a donné tout ce qu’il possède. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mon seigneur m’a fait jurer, en disant: Tu ne prendras pas pour mon fils une femme parmi les filles des Cananéens, dans le pays desquels j’habite; ");
INSERT INTO fraLSG_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","mais tu iras dans la maison de mon père et de ma famille prendre une femme pour mon fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","J’ai dit à mon seigneur: Peut-être la femme ne voudra-t-elle pas me suivre. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Et il m’a répondu: L’Éternel, devant qui j’ai marché, enverra son ange avec toi, et fera réussir ton voyage; et tu prendras pour mon fils une femme de la famille et de la maison de mon père. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Tu seras dégagé du serment que tu me fais, quand tu auras été vers ma famille; si on ne te l’accorde pas, tu seras dégagé du serment que tu me fais. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Je suis arrivé aujourd’hui à la source, et j’ai dit: Éternel, Dieu de mon seigneur Abraham, si tu daignes faire réussir le voyage que j’accomplis, ");
INSERT INTO fraLSG_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","voici, je me tiens près de la source d’eau, et que la jeune fille qui sortira pour puiser, à qui je dirai: Laisse-moi boire, je te prie, un peu d’eau de ta cruche, et qui me répondra: ");
INSERT INTO fraLSG_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Bois toi-même, et je puiserai aussi pour tes chameaux, que cette jeune fille soit la femme que l’Éternel a destinée au fils de mon seigneur! ");
INSERT INTO fraLSG_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Avant que j’eusse fini de parler en mon cœur, voici, Rebecca est sortie, sa cruche sur l’épaule; elle est descendue à la source, et a puisé. Je lui ai dit: Donne-moi à boire, je te prie. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Elle s’est empressée d’abaisser sa cruche de dessus son épaule, et elle a dit: Bois, et je donnerai aussi à boire à tes chameaux. J’ai bu, et elle a aussi donné à boire à mes chameaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Je l’ai interrogée, et j’ai dit: De qui es-tu fille? Elle a répondu: Je suis fille de Bethuel, fils de Nachor et de Milca. J’ai mis l’anneau à son nez, et les bracelets à ses mains. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Puis je me suis incliné et prosterné devant l’Éternel, et j’ai béni l’Éternel, le Dieu de mon seigneur Abraham, qui m’a conduit fidèlement, afin que je prisse la fille du frère de mon seigneur pour son fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Maintenant, si vous voulez user de bienveillance et de fidélité envers mon seigneur, déclarez-le-moi; sinon, déclarez-le-moi, et je me tournerai à droite ou à gauche. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban et Bethuel répondirent, et dirent: C’est de l’Éternel que la chose vient; nous ne pouvons te parler ni en mal ni en bien. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Voici Rebecca devant toi; prends et va, et qu’elle soit la femme du fils de ton seigneur, comme l’Éternel l’a dit. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Lorsque le serviteur d’Abraham eut entendu leurs paroles, il se prosterna en terre devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Et le serviteur sortit des objets d’argent, des objets d’or, et des vêtements, qu’il donna à Rebecca; il fit aussi de riches présents à son frère et à sa mère. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Après quoi, ils mangèrent et burent, lui et les gens qui étaient avec lui, et ils passèrent la nuit. Le matin, quand ils furent levés, le serviteur dit: Laissez-moi retourner vers mon seigneur. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Le frère et la mère dirent: Que la jeune fille reste avec nous quelque temps encore, une dizaine de jours; ensuite, tu partiras. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Il leur répondit: Ne me retardez pas, puisque l’Éternel a fait réussir mon voyage; laissez-moi partir, et que j’aille vers mon seigneur. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Alors ils répondirent: Appelons la jeune fille et consultons-la. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ils appelèrent donc Rebecca, et lui dirent: Veux-tu aller avec cet homme? Elle répondit: J’irai. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Et ils laissèrent partir Rebecca, leur sœur, et sa nourrice, avec le serviteur d’Abraham et ses gens. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ils bénirent Rebecca, et lui dirent: O notre sœur, puisses-tu devenir des milliers de myriades, et que ta postérité possède la porte de ses ennemis! ");
INSERT INTO fraLSG_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebecca se leva, avec ses servantes; elles montèrent sur les chameaux, et suivirent l’homme. Et le serviteur emmena Rebecca, et partit. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Cependant Isaac était revenu du puits de Lachaï-roï, et il habitait dans le pays du midi. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Un soir qu’Isaac était sorti pour méditer dans les champs, il leva les yeux, et regarda; et voici, des chameaux arrivaient. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebecca leva aussi les yeux, vit Isaac, et descendit de son chameau. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Elle dit au serviteur: Qui est cet homme, qui vient dans les champs à notre rencontre? Et le serviteur répondit: C’est mon seigneur. Alors elle prit son voile, et se couvrit. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Le serviteur raconta à Isaac toutes les choses qu’il avait faites. ");
INSERT INTO fraLSG_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isaac conduisit Rebecca dans la tente de Sara, sa mère; il prit Rebecca, qui devint sa femme, et il l’aima. Ainsi fut consolé Isaac, après avoir perdu sa mère. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham prit encore une femme, nommée Ketura. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Elle lui enfanta Zimran, Jokschan, Medan, Madian, Jischbak et Schuach. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokschan engendra Séba et Dedan. Les fils de Dedan furent les Aschurim, les Letuschim et les Leummim. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Les fils de Madian furent Épha, Épher, Hénoc, Abida et Eldaa. Ce sont là tous les fils de Ketura. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham donna tous ses biens à Isaac. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Il fit des dons aux fils de ses concubines; et, tandis qu’il vivait encore, il les envoya loin de son fils Isaac du côté de l’orient, dans le pays d’Orient. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Voici les jours des années de la vie d’Abraham: il vécut cent soixante quinze ans. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham expira et mourut, après une heureuse vieillesse, âgé et rassasié de jours, et il fut recueilli auprès de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Isaac et Ismaël, ses fils, l’enterrèrent dans la caverne de Macpéla, dans le champ d’Éphron, fils de Tsochar, le Héthien, vis-à-vis de Mamré. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","C’est le champ qu’Abraham avait acquis des fils de Heth. Là furent enterrés Abraham et Sara, sa femme. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Après la mort d’Abraham, Dieu bénit Isaac, son fils. Il habitait près du puits de Lachaï-roï. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Voici la postérité d’Ismaël, fils d’Abraham, qu’Agar, l’Égyptienne, servante de Sara, avait enfanté à Abraham. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Voici les noms des fils d’Ismaël, par leurs noms, selon leurs générations: Nebajoth, premier-né d’Ismaël, Kédar, Adbeel, Mibsam, ");
INSERT INTO fraLSG_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mischma, Duma, Massa, ");
INSERT INTO fraLSG_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Théma, Jethur, Naphisch et Kedma. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ce sont là les fils d’Ismaël; ce sont là leurs noms, selon leurs parcs et leurs enclos. Ils furent les douze chefs de leurs peuples. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Et voici les années de la vie d’Ismaël: cent trente-sept ans. Il expira et mourut, et il fut recueilli auprès de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ses fils habitèrent depuis Havila jusqu’à Schur, qui est en face de l’Égypte, en allant vers l’Assyrie. Il s’établit en présence de tous ses frères. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Voici la postérité d’Isaac, fils d’Abraham. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Abraham engendra Isaac. Isaac était âgé de quarante ans, quand il prit pour femme Rebecca, fille de Bethuel, l’Araméen, de Paddan-Aram, et sœur de Laban, l’Araméen. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac implora l’Éternel pour sa femme, car elle était stérile, et l’Éternel l’exauça: Rebecca, sa femme, devint enceinte. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Les enfants se heurtaient dans son sein; et elle dit: S’il en est ainsi, pourquoi suis-je enceinte? Elle alla consulter l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Et l’Éternel lui dit: Deux nations sont dans ton ventre, et deux peuples se sépareront au sortir de tes entrailles; un de ces peuples sera plus fort que l’autre, et le plus grand sera assujetti au plus petit. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Les jours où elle devait accoucher s’accomplirent; et voici, il y avait deux jumeaux dans son ventre. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Le premier sortit entièrement roux, comme un manteau de poil; et on lui donna le nom d’Ésaü. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ensuite sortit son frère, dont la main tenait le talon d’Ésaü; et on lui donna le nom de Jacob. Isaac était âgé de soixante ans, lorsqu’ils naquirent. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ces enfants grandirent. Ésaü devint un habile chasseur, un homme des champs; mais Jacob fut un homme tranquille, qui restait sous les tentes. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac aimait Ésaü, parce qu’il mangeait du gibier; et Rebecca aimait Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Comme Jacob faisait cuire un potage, Ésaü revint des champs, accablé de fatigue. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Et Ésaü dit à Jacob: Laisse-moi, je te prie, manger de ce roux, de ce roux-là, car je suis fatigué. C’est pour cela qu’on a donné à Ésaü le nom d’Édom. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob dit: Vends-moi aujourd’hui ton droit d’aînesse. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ésaü répondit: Voici, je m’en vais mourir; à quoi me sert ce droit d’aînesse? ");
INSERT INTO fraLSG_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Et Jacob dit: Jure-le moi d’abord. Il le lui jura, et il vendit son droit d’aînesse à Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Alors Jacob donna à Ésaü du pain et du potage de lentilles. Il mangea et but, puis se leva et s’en alla. C’est ainsi qu’Ésaü méprisa le droit d’aînesse. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Il y eut une famine dans le pays, outre la première famine qui eut lieu du temps d’Abraham; et Isaac alla vers Abimélec, roi des Philistins, à Guérar. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","L’Éternel lui apparut, et dit: Ne descends pas en Égypte, demeure dans le pays que je te dirai. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Séjourne dans ce pays-ci: je serai avec toi, et je te bénirai, car je donnerai toutes ces contrées à toi et à ta postérité, et je tiendrai le serment que j’ai fait à Abraham, ton père. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Je multiplierai ta postérité comme les étoiles du ciel; je donnerai à ta postérité toutes ces contrées; et toutes les nations de la terre seront bénies en ta postérité, ");
INSERT INTO fraLSG_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","parce qu’Abraham a obéi à ma voix, et qu’il a observé mes ordres, mes commandements, mes statuts et mes lois. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Et Isaac resta à Guérar. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Lorsque les gens du lieu faisaient des questions sur sa femme, il disait: C’est ma sœur; car il craignait, en disant ma femme, que les gens du lieu ne le tuassent, parce que Rebecca était belle de figure. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Comme son séjour se prolongeait, il arriva qu’Abimélec, roi des Philistins, regardant par la fenêtre, vit Isaac qui plaisantait avec Rebecca, sa femme. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimélec fit appeler Isaac, et dit: Certainement, c’est ta femme. Comment as-tu pu dire: C’est ma sœur? Isaac lui répondit: J’ai parlé ainsi, de peur de mourir à cause d’elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Et Abimélec dit: Qu’est-ce que tu nous as fait? Peu s’en est fallu que quelqu’un du peuple n’ait couché avec ta femme, et tu nous aurais rendus coupables. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Alors Abimélec fit cette ordonnance pour tout le peuple: Celui qui touchera à cet homme ou à sa femme sera mis à mort. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Isaac sema dans ce pays, et il recueillit cette année le centuple; car l’Éternel le bénit. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Cet homme devint riche, et il alla s’enrichissant de plus en plus, jusqu’à ce qu’il devint fort riche. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Il avait des troupeaux de menu bétail et des troupeaux de gros bétail, et un grand nombre de serviteurs: aussi les Philistins lui portèrent envie. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tous les puits qu’avaient creusés les serviteurs de son père, du temps d’Abraham, son père, les Philistins les comblèrent et les remplirent de poussière. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Et Abimélec dit à Isaac: Va-t’en de chez nous, car tu es beaucoup plus puissant que nous. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Isaac partit de là, et campa dans la vallée de Guérar, où il s’établit. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isaac creusa de nouveau les puits d’eau qu’on avait creusés du temps d’Abraham, son père, et qu’avaient comblés les Philistins après la mort d’Abraham; et il leur donna les mêmes noms que son père leur avait donnés. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Les serviteurs d’Isaac creusèrent encore dans la vallée, et y trouvèrent un puits d’eau vive. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Les bergers de Guérar querellèrent les bergers d’Isaac, en disant: L’eau est à nous. Et il donna au puits le nom d’Ések, parce qu’ils s’étaient disputés avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ses serviteurs creusèrent un autre puits, au sujet duquel on chercha aussi une querelle; et il l’appela Sitna. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Il se transporta de là, et creusa un autre puits, pour lequel on ne chercha pas querelle; et il l’appela Rehoboth, car, dit-il, l’Éternel nous a maintenant mis au large, et nous prospérerons dans le pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Il remonta de là à Beer-Schéba. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","L’Éternel lui apparut dans la nuit, et dit: Je suis le Dieu d’Abraham, ton père; ne crains point, car je suis avec toi; je te bénirai, et je multiplierai ta postérité, à cause d’Abraham, mon serviteur. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Il bâtit là un autel, invoqua le nom de l’Éternel, et y dressa sa tente. Et les serviteurs d’Isaac y creusèrent un puits. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimélec vint de Guérar auprès de lui, avec Ahuzath, son ami, et Picol, chef de son armée. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac leur dit: Pourquoi venez-vous vers moi, puisque vous me haïssez et que vous m’avez renvoyé de chez vous? ");
INSERT INTO fraLSG_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ils répondirent: Nous voyons que l’Éternel est avec toi. C’est pourquoi nous disons: Qu’il y ait un serment entre nous, entre nous et toi, et que nous fassions alliance avec toi! ");
INSERT INTO fraLSG_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Jure que tu ne nous feras aucun mal, de même que nous ne t’avons point maltraité, que nous t’avons fait seulement du bien, et que nous t’avons laissé partir en paix. Tu es maintenant béni de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Isaac leur fit un festin, et ils mangèrent et burent. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ils se levèrent de bon matin, et se lièrent l’un à l’autre par un serment. Isaac les laissa partir, et ils le quittèrent en paix. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Ce même jour, des serviteurs d’Isaac vinrent lui parler du puits qu’ils creusaient, et lui dirent: Nous avons trouvé de l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Et il l’appela Schiba. C’est pourquoi on a donné à la ville le nom de Beer-Schéba, jusqu’à ce jour. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ésaü, âgé de quarante ans, prit pour femmes Judith, fille de Beéri, le Héthien, et Basmath, fille d’Élon, le Héthien. ");
INSERT INTO fraLSG_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Elles furent un sujet d’amertume pour le cœur d’Isaac et de Rebecca. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac devenait vieux, et ses yeux s’étaient affaiblis au point qu’il ne voyait plus. Alors il appela Ésaü, son fils aîné, et lui dit: Mon fils! Et il lui répondit: Me voici! ");
INSERT INTO fraLSG_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isaac dit: Voici donc, je suis vieux, je ne connais pas le jour de ma mort. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Maintenant donc, je te prie, prends tes armes, ton carquois et ton arc, va dans les champs, et chasse-moi du gibier. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Fais-moi un mets comme j’aime, et apporte-le-moi à manger, afin que mon âme te bénisse avant que je meure. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Rebecca écouta ce qu’Isaac disait à Ésaü, son fils. Et Ésaü s’en alla dans les champs, pour chasser du gibier et pour le rapporter. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Puis Rebecca dit à Jacob, son fils: Voici, j’ai entendu ton père qui parlait ainsi à Ésaü, ton frère: ");
INSERT INTO fraLSG_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Apporte-moi du gibier et fais-moi un mets que je mangerai; et je te bénirai devant l’Éternel avant ma mort. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Maintenant, mon fils, écoute ma voix à l’égard de ce que je te commande. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Va me prendre au troupeau deux bons chevreaux; j’en ferai pour ton père un mets comme il aime; ");
INSERT INTO fraLSG_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","et tu le porteras à manger à ton père, afin qu’il te bénisse avant sa mort. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Jacob répondit à sa mère: Voici, Ésaü, mon frère, est velu, et je n’ai point de poil. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Peut-être mon père me touchera-t-il, et je passerai à ses yeux pour un menteur, et je ferai venir sur moi la malédiction, et non la bénédiction. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Sa mère lui dit: Que cette malédiction, mon fils, retombe sur moi! Écoute seulement ma voix, et va me les prendre. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Jacob alla les prendre, et les apporta à sa mère, qui fit un mets comme son père aimait. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ensuite, Rebecca prit les vêtements d’Ésaü, son fils aîné, les plus beaux qui se trouvaient à la maison, et elle les fit mettre à Jacob, son fils cadet. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Elle couvrit ses mains de la peau des chevreaux, et son cou qui était sans poil. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Et elle plaça dans la main de Jacob, son fils, le mets et le pain qu’elle avait préparés. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Il vint vers son père, et dit: Mon père! Et Isaac dit: Me voici! Qui es-tu, mon fils? ");
INSERT INTO fraLSG_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob répondit à son père: Je suis Ésaü, ton fils aîné; j’ai fait ce que tu m’as dit. Lève-toi, je te prie, assieds-toi, et mange de mon gibier, afin que ton âme me bénisse. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Isaac dit à son fils: Eh quoi! Tu en as déjà trouvé, mon fils! Et Jacob répondit: C’est que l’Éternel, ton Dieu, l’a fait venir devant moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isaac dit à Jacob: Approche donc, et que je te touche, mon fils, pour savoir si tu es mon fils Ésaü, ou non. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Jacob s’approcha d’Isaac, son père, qui le toucha, et dit: La voix est la voix de Jacob, mais les mains sont les mains d’Ésaü. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Il ne le reconnut pas, parce que ses mains étaient velues, comme les mains d’Ésaü, son frère; et il le bénit. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Il dit: C’est toi qui es mon fils Ésaü? Et Jacob répondit: C’est moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isaac dit: Sers-moi, et que je mange du gibier de mon fils, afin que mon âme te bénisse. Jacob le servit, et il mangea; il lui apporta aussi du vin, et il but. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Alors Isaac, son père, lui dit: Approche donc, et baise-moi, mon fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jacob s’approcha, et le baisa. Isaac sentit l’odeur de ses vêtements; puis il le bénit, et dit: Voici, l’odeur de mon fils est comme l’odeur d’un champ que l’Éternel a béni. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Que Dieu te donne de la rosée du ciel Et de la graisse de la terre, Du blé et du vin en abondance! ");
INSERT INTO fraLSG_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Que des peuples te soient soumis, Et que des nations se prosternent devant toi! Sois le maître de tes frères, Et que les fils de ta mère se prosternent devant toi! Maudit soit quiconque te maudira, Et béni soit quiconque te bénira. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac avait fini de bénir Jacob, et Jacob avait à peine quitté son père Isaac, qu’Ésaü, son frère, revint de la chasse. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Il fit aussi un mets, qu’il porta à son père; et il dit à son père: Que mon père se lève et mange du gibier de son fils, afin que ton âme me bénisse! ");
INSERT INTO fraLSG_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isaac, son père, lui dit: Qui es-tu? Et il répondit: Je suis ton fils aîné, Ésaü. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac fut saisi d’une grande, d’une violente émotion, et il dit: Qui est donc celui qui a chassé du gibier, et me l’a apporté? J’ai mangé de tout avant que tu vinsses, et je l’ai béni. Aussi sera-t-il béni. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Lorsque Ésaü entendit les paroles de son père, il poussa de forts cris, pleins d’amertume, et il dit à son père: Bénis-moi aussi, mon père! ");
INSERT INTO fraLSG_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isaac dit: Ton frère est venu avec ruse, et il a enlevé ta bénédiction. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ésaü dit: Est-ce parce qu’on l’a appelé du nom de Jacob qu’il m’a supplanté deux fois? Il a enlevé mon droit d’aînesse, et voici maintenant qu’il vient d’enlever ma bénédiction. Et il dit: N’as-tu point réservé de bénédiction pour moi? ");
INSERT INTO fraLSG_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac répondit, et dit à Ésaü: Voici, je l’ai établi ton maître, et je lui ai donné tous ses frères pour serviteurs, je l’ai pourvu de blé et de vin: que puis-je donc faire pour toi, mon fils? ");
INSERT INTO fraLSG_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ésaü dit à son père: N’as-tu que cette seule bénédiction, mon père? Bénis-moi aussi, mon père! Et Ésaü éleva la voix, et pleura. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Isaac, son père, répondit, et lui dit: Voici! Ta demeure sera privée de la graisse de la terre Et de la rosée du ciel, d’en haut. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Tu vivras de ton épée, Et tu seras asservi à ton frère; Mais en errant librement çà et là, Tu briseras son joug de dessus ton cou. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ésaü conçut de la haine contre Jacob, à cause de la bénédiction dont son père l’avait béni; et Ésaü disait en son cœur: Les jours du deuil de mon père vont approcher, et je tuerai Jacob, mon frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","On rapporta à Rebecca les paroles d’Ésaü, son fils aîné. Elle fit alors appeler Jacob, son fils cadet, et elle lui dit: Voici, Ésaü, ton frère, veut tirer vengeance de toi, en te tuant. ");
INSERT INTO fraLSG_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Maintenant, mon fils, écoute ma voix! Lève-toi, fuis chez Laban, mon frère, à Charan; ");
INSERT INTO fraLSG_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","et reste auprès de lui quelque temps, jusqu’à ce que la fureur de ton frère s’apaise, ");
INSERT INTO fraLSG_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","jusqu’à ce que la colère de ton frère se détourne de toi, et qu’il oublie ce que tu lui as fait. Alors je te ferai revenir. Pourquoi serais-je privée de vous deux en un même jour? ");
INSERT INTO fraLSG_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Rebecca dit à Isaac: Je suis dégoûtée de la vie, à cause des filles de Heth. Si Jacob prend une femme, comme celles-ci, parmi les filles de Heth, parmi les filles du pays, à quoi me sert la vie? ");
INSERT INTO fraLSG_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isaac appela Jacob, le bénit, et lui donna cet ordre: Tu ne prendras pas une femme parmi les filles de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Lève-toi, va à Paddan-Aram, à la maison de Bethuel, père de ta mère, et prends-y une femme d’entre les filles de Laban, frère de ta mère. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Que le Dieu tout-puissant te bénisse, te rende fécond et te multiplie, afin que tu deviennes une multitude de peuples! ");
INSERT INTO fraLSG_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Qu’il te donne la bénédiction d’Abraham, à toi et à ta postérité avec toi, afin que tu possèdes le pays où tu habites comme étranger, et qu’il a donné à Abraham! ");
INSERT INTO fraLSG_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Et Isaac fit partir Jacob, qui s’en alla à Paddan-Aram, auprès de Laban, fils de Bethuel, l’Araméen, frère de Rebecca, mère de Jacob et d’Ésaü. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ésaü vit qu’Isaac avait béni Jacob, et qu’il l’avait envoyé à Paddan-Aram pour y prendre une femme, et qu’en le bénissant il lui avait donné cet ordre: Tu ne prendras pas une femme parmi les filles de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Il vit que Jacob avait obéi à son père et à sa mère, et qu’il était parti pour Paddan-Aram. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Ésaü comprit ainsi que les filles de Canaan déplaisaient à Isaac, son père. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Et Ésaü s’en alla vers Ismaël. Il prit pour femme, outre les femmes qu’il avait, Mahalath, fille d’Ismaël, fils d’Abraham, et sœur de Nebajoth. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob partit de Beer-Schéba, et s’en alla à Charan. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Il arriva dans un lieu où il passa la nuit; car le soleil était couché. Il y prit une pierre, dont il fit son chevet, et il se coucha dans ce lieu-là. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Il eut un songe. Et voici, une échelle était appuyée sur la terre, et son sommet touchait au ciel. Et voici, les anges de Dieu montaient et descendaient par cette échelle. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Et voici, l’Éternel se tenait au-dessus d’elle; et il dit: Je suis l’Éternel, le Dieu d’Abraham, ton père, et le Dieu d’Isaac. La terre sur laquelle tu es couché, je la donnerai à toi et à ta postérité. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ta postérité sera comme la poussière de la terre; tu t’étendras à l’occident et à l’orient, au septentrion et au midi; et toutes les familles de la terre seront bénies en toi et en ta postérité. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Voici, je suis avec toi, je te garderai partout où tu iras, et je te ramènerai dans ce pays; car je ne t’abandonnerai point, que je n’aie exécuté ce que je te dis. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Jacob s’éveilla de son sommeil et il dit: Certainement, l’Éternel est en ce lieu, et moi, je ne le savais pas! ");
INSERT INTO fraLSG_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Il eut peur, et dit: Que ce lieu est redoutable! C’est ici la maison de Dieu, c’est ici la porte des cieux! ");
INSERT INTO fraLSG_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Et Jacob se leva de bon matin; il prit la pierre dont il avait fait son chevet, il la dressa pour monument, et il versa de l’huile sur son sommet. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Il donna à ce lieu le nom de Béthel; mais la ville s’appelait auparavant Luz. ");
INSERT INTO fraLSG_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Jacob fit un vœu, en disant: Si Dieu est avec moi et me garde pendant ce voyage que je fais, s’il me donne du pain à manger et des habits pour me vêtir, ");
INSERT INTO fraLSG_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","et si je retourne en paix à la maison de mon père, alors l’Éternel sera mon Dieu; ");
INSERT INTO fraLSG_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","cette pierre, que j’ai dressée pour monument, sera la maison de Dieu; et je te donnerai la dîme de tout ce que tu me donneras. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Jacob se mit en marche, et s’en alla au pays des fils de l’Orient. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Il regarda. Et voici, il y avait un puits dans les champs; et voici, il y avait à côté trois troupeaux de brebis qui se reposaient, car c’était à ce puits qu’on abreuvait les troupeaux. Et la pierre sur l’ouverture du puits était grande. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tous les troupeaux se rassemblaient là; on roulait la pierre de dessus l’ouverture du puits, on abreuvait les troupeaux, et l’on remettait la pierre à sa place sur l’ouverture du puits. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob dit aux bergers: Mes frères, d’où êtes-vous? Ils répondirent: Nous sommes de Charan. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Il leur dit: Connaissez-vous Laban, fils de Nachor? Ils répondirent: Nous le connaissons. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Il leur dit: Est-il en bonne santé? Ils répondirent: Il est en bonne santé; et voici Rachel, sa fille, qui vient avec le troupeau. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Il dit: Voici, il est encore grand jour, et il n’est pas temps de rassembler les troupeaux; abreuvez les brebis, puis allez, et faites-les paître. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ils répondirent: Nous ne le pouvons pas, jusqu’à ce que tous les troupeaux soient rassemblés; c’est alors qu’on roule la pierre de dessus l’ouverture du puits, et qu’on abreuve les brebis. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Comme il leur parlait encore, survint Rachel avec le troupeau de son père; car elle était bergère. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Lorsque Jacob vit Rachel, fille de Laban, frère de sa mère, et le troupeau de Laban, frère de sa mère, il s’approcha, roula la pierre de dessus l’ouverture du puits, et abreuva le troupeau de Laban, frère de sa mère. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Et Jacob baisa Rachel, il éleva la voix et pleura. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob apprit à Rachel qu’il était parent de son père, qu’il était fils de Rebecca. Et elle courut l’annoncer à son père. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Dès que Laban eut entendu parler de Jacob, fils de sa sœur, il courut au-devant de lui, il l’embrassa et le baisa, et il le fit venir dans sa maison. Jacob raconta à Laban toutes ces choses. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Et Laban lui dit: Certainement, tu es mon os et ma chair. Jacob demeura un mois chez Laban. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Puis Laban dit à Jacob: Parce que tu es mon parent, me serviras-tu pour rien? Dis-moi quel sera ton salaire. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Or, Laban avait deux filles: l’aînée s’appelait Léa, et la cadette Rachel. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Léa avait les yeux délicats; mais Rachel était belle de taille et belle de figure. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob aimait Rachel, et il dit: Je te servirai sept ans pour Rachel, ta fille cadette. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Et Laban dit: J’aime mieux te la donner que de la donner à un autre homme. Reste chez moi! ");
INSERT INTO fraLSG_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ainsi Jacob servit sept années pour Rachel: et elles furent à ses yeux comme quelques jours, parce qu’il l’aimait. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ensuite Jacob dit à Laban: Donne-moi ma femme, car mon temps est accompli: et j’irai vers elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Laban réunit tous les gens du lieu, et fit un festin. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Le soir, il prit Léa, sa fille, et l’amena vers Jacob, qui s’approcha d’elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Et Laban donna pour servante à Léa, sa fille, Zilpa, sa servante. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Le lendemain matin, voilà que c’était Léa. Alors Jacob dit à Laban: Qu’est-ce que tu m’as fait? N’est-ce pas pour Rachel que j’ai servi chez toi? Pourquoi m’as-tu trompé? ");
INSERT INTO fraLSG_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban dit: Ce n’est point la coutume dans ce lieu de donner la cadette avant l’aînée. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Achève la semaine avec celle-ci, et nous te donnerons aussi l’autre pour le service que tu feras encore chez moi pendant sept nouvelles années. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Jacob fit ainsi, et il acheva la semaine avec Léa; puis Laban lui donna pour femme Rachel, sa fille. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Et Laban donna pour servante à Rachel, sa fille, Bilha, sa servante. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Jacob alla aussi vers Rachel, qu’il aimait plus que Léa; et il servit encore chez Laban pendant sept nouvelles années. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","L’Éternel vit que Léa n’était pas aimée; et il la rendit féconde, tandis que Rachel était stérile. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Léa devint enceinte, et enfanta un fils, à qui elle donna le nom de Ruben; car elle dit: L’Éternel a vu mon humiliation, et maintenant mon mari m’aimera. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Elle devint encore enceinte, et enfanta un fils, et elle dit: L’Éternel a entendu que je n’étais pas aimée, et il m’a aussi accordé celui-ci. Et elle lui donna le nom de Siméon. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Elle devint encore enceinte, et enfanta un fils, et elle dit: Pour cette fois, mon mari s’attachera à moi; car je lui ai enfanté trois fils. C’est pourquoi on lui donna le nom de Lévi. ");
INSERT INTO fraLSG_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Elle devint encore enceinte, et enfanta un fils, et elle dit: Cette fois, je louerai l’Éternel. C’est pourquoi elle lui donna le nom de Juda. Et elle cessa d’enfanter. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lorsque Rachel vit qu’elle ne donnait point d’enfants à Jacob, elle porta envie à sa sœur, et elle dit à Jacob: Donne-moi des enfants, ou je meurs! ");
INSERT INTO fraLSG_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","La colère de Jacob s’enflamma contre Rachel, et il dit: Suis-je à la place de Dieu, qui t’empêche d’être féconde? ");
INSERT INTO fraLSG_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Elle dit: Voici ma servante Bilha; va vers elle; qu’elle enfante sur mes genoux, et que par elle j’aie aussi des fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Et elle lui donna pour femme Bilha, sa servante; et Jacob alla vers elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilha devint enceinte, et enfanta un fils à Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rachel dit: Dieu m’a rendu justice, il a entendu ma voix, et il m’a donné un fils. C’est pourquoi elle l’appela du nom de Dan. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha, servante de Rachel, devint encore enceinte, et enfanta un second fils à Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel dit: J’ai lutté divinement contre ma sœur, et j’ai vaincu. Et elle l’appela du nom de Nephthali. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Léa voyant qu’elle avait cessé d’enfanter, prit Zilpa, sa servante, et la donna pour femme à Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa, servante de Léa, enfanta un fils à Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Léa dit: Quel bonheur! Et elle l’appela du nom de Gad. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa, servante de Léa, enfanta un second fils à Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Léa dit: Que je suis heureuse! Car les filles me diront heureuse. Et elle l’appela du nom d’Aser. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ruben sortit au temps de la moisson des blés, et trouva des mandragores dans les champs. Il les apporta à Léa, sa mère. Alors Rachel dit à Léa: Donne-moi, je te prie, des mandragores de ton fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Elle lui répondit: Est-ce peu que tu aies pris mon mari, pour que tu prennes aussi les mandragores de mon fils? Et Rachel dit: Eh bien! Il couchera avec toi cette nuit pour les mandragores de ton fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Le soir, comme Jacob revenait des champs, Léa sortit à sa rencontre, et dit: C’est vers moi que tu viendras, car je t’ai acheté pour les mandragores de mon fils. Et il coucha avec elle cette nuit. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Dieu exauça Léa, qui devint enceinte, et enfanta un cinquième fils à Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Léa dit: Dieu m’a donné mon salaire parce que j’ai donné ma servante à mon mari. Et elle l’appela du nom d’Issacar. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Léa devint encore enceinte, et enfanta un sixième fils à Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Léa dit: Dieu m’a fait un beau don; cette fois, mon mari habitera avec moi, car je lui ai enfanté six fils. Et elle l’appela du nom de Zabulon. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ensuite, elle enfanta une fille, qu’elle appela du nom de Dina. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Dieu se souvint de Rachel, il l’exauça, et il la rendit féconde. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Elle devint enceinte, et enfanta un fils, et elle dit: Dieu a enlevé mon opprobre. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Et elle lui donna le nom de Joseph, en disant: Que l’Éternel m’ajoute un autre fils! ");
INSERT INTO fraLSG_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Lorsque Rachel eut enfanté Joseph, Jacob dit à Laban: Laisse-moi partir, pour que je m’en aille chez moi, dans mon pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Donne-moi mes femmes et mes enfants, pour lesquels je t’ai servi, et je m’en irai; car tu sais quel service j’ai fait pour toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban lui dit: Puissé-je trouver grâce à tes yeux! Je vois bien que l’Éternel m’a béni à cause de toi; ");
INSERT INTO fraLSG_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","fixe-moi ton salaire, et je te le donnerai. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Jacob lui dit: Tu sais comment je t’ai servi, et ce qu’est devenu ton troupeau avec moi; ");
INSERT INTO fraLSG_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","car le peu que tu avais avant moi s’est beaucoup accru, et l’Éternel t’a béni sur mes pas. Maintenant, quand travaillerai-je aussi pour ma maison? ");
INSERT INTO fraLSG_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban dit: Que te donnerai-je? Et Jacob répondit: Tu ne me donneras rien. Si tu consens à ce que je vais te dire, je ferai paître encore ton troupeau, et je le garderai. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Je parcourrai aujourd’hui tout ton troupeau; mets à part parmi les brebis tout agneau tacheté et marqueté et tout agneau noir, et parmi les chèvres tout ce qui est marqueté et tacheté. Ce sera mon salaire. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ma droiture répondra pour moi demain, quand tu viendras voir mon salaire; tout ce qui ne sera pas tacheté et marqueté parmi les chèvres, et noir parmi les agneaux, ce sera de ma part un vol. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban dit: Eh bien! Qu’il en soit selon ta parole. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Ce même jour, il mit à part les boucs rayés et marquetés, toutes les chèvres tachetées et marquetées, toutes celles où il y avait du blanc, et tout ce qui était noir parmi les brebis. Il les remit entre les mains de ses fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Puis il mit l’espace de trois journées de chemin entre lui et Jacob; et Jacob fit paître le reste du troupeau de Laban. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob prit des branches vertes de peuplier, d’amandier et de platane; il y pela des bandes blanches, mettant à nu le blanc qui était sur les branches. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Puis il plaça les branches, qu’il avait pelées, dans les auges, dans les abreuvoirs, sous les yeux des brebis qui venaient boire, pour qu’elles entrassent en chaleur en venant boire. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Les brebis entraient en chaleur près des branches, et elles faisaient des petits rayés, tachetés et marquetés. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob séparait les agneaux, et il mettait ensemble ce qui était rayé et tout ce qui était noir dans le troupeau de Laban. Il se fit ainsi des troupeaux à part, qu’il ne réunit point au troupeau de Laban. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Toutes les fois que les brebis vigoureuses entraient en chaleur, Jacob plaçait les branches dans les auges, sous les yeux des brebis, pour qu’elles entrassent en chaleur près des branches. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Quand les brebis étaient chétives, il ne les plaçait point; de sorte que les chétives étaient pour Laban, et les vigoureuses pour Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Cet homme devint de plus en plus riche; il eut du menu bétail en abondance, des servantes et des serviteurs, des chameaux et des ânes. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob entendit les propos des fils de Laban, qui disaient: Jacob a pris tout ce qui était à notre père, et c’est avec le bien de notre père qu’il s’est acquis toute cette richesse. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Jacob remarqua aussi le visage de Laban; et voici, il n’était plus envers lui comme auparavant. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Alors l’Éternel dit à Jacob: Retourne au pays de tes pères et dans ton lieu de naissance, et je serai avec toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Jacob fit appeler Rachel et Léa, qui étaient aux champs vers son troupeau. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Il leur dit: Je vois, au visage de votre père, qu’il n’est plus envers moi comme auparavant; mais le Dieu de mon père a été avec moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Vous savez vous-mêmes que j’ai servi votre père de tout mon pouvoir. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Et votre père s’est joué de moi, et a changé dix fois mon salaire; mais Dieu ne lui a pas permis de me faire du mal. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Quand il disait: Les tachetées seront ton salaire, toutes les brebis faisaient des petits tachetés. Et quand il disait: Les rayées seront ton salaire, toutes les brebis faisaient des petits rayés. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Dieu a pris à votre père son troupeau, et me l’a donné. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Au temps où les brebis entraient en chaleur, je levai les yeux, et je vis en songe que les boucs qui couvraient les brebis étaient rayés, tachetés et marquetés. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Et l’ange de Dieu me dit en songe: Jacob! Je répondis: Me voici! ");
INSERT INTO fraLSG_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Il dit: Lève les yeux, et regarde: tous les boucs qui couvrent les brebis sont rayés, tachetés et marquetés; car j’ai vu tout ce que te fait Laban. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Je suis le Dieu de Béthel, où tu as oint un monument, où tu m’as fait un vœu. Maintenant, lève-toi, sors de ce pays, et retourne au pays de ta naissance. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rachel et Léa répondirent, et lui dirent: Avons-nous encore une part et un héritage dans la maison de notre père? ");
INSERT INTO fraLSG_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ne sommes-nous pas regardées par lui comme des étrangères, puisqu’il nous a vendues, et qu’il a mangé notre argent? ");
INSERT INTO fraLSG_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Toute la richesse que Dieu a ôtée à notre père appartient à nous et à nos enfants. Fais maintenant tout ce que Dieu t’a dit. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Jacob se leva, et il fit monter ses enfants et ses femmes sur les chameaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Il emmena tout son troupeau et tous les biens qu’il possédait, le troupeau qui lui appartenait, qu’il avait acquis à Paddan-Aram; et il s’en alla vers Isaac, son père, au pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Tandis que Laban était allé tondre ses brebis, Rachel déroba les théraphim de son père; ");
INSERT INTO fraLSG_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","et Jacob trompa Laban, l’Araméen, en ne l’avertissant pas de sa fuite. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Il s’enfuit, avec tout ce qui lui appartenait; il se leva, traversa le fleuve, et se dirigea vers la montagne de Galaad. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Le troisième jour, on annonça à Laban que Jacob s’était enfui. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Il prit avec lui ses frères, le poursuivit sept journées de marche, et l’atteignit à la montagne de Galaad. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Mais Dieu apparut la nuit en songe à Laban, l’Araméen, et lui dit: Garde-toi de parler à Jacob ni en bien ni en mal! ");
INSERT INTO fraLSG_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban atteignit donc Jacob. Jacob avait dressé sa tente sur la montagne; Laban dressa aussi la sienne, avec ses frères, sur la montagne de Galaad. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Alors Laban dit à Jacob: Qu’as-tu fait? Pourquoi m’as-tu trompé, et emmènes-tu mes filles comme des captives par l’épée? ");
INSERT INTO fraLSG_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Pourquoi as-tu pris la fuite en cachette, m’as-tu trompé, et ne m’as-tu point averti? Je t’aurais laissé partir au milieu des réjouissances et des chants, au son du tambourin et de la harpe. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tu ne m’as pas permis d’embrasser mes fils et mes filles! C’est en insensé que tu as agi. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ma main est assez forte pour vous faire du mal; mais le Dieu de votre père m’a dit hier: Garde-toi de parler à Jacob ni en bien ni en mal! ");
INSERT INTO fraLSG_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Maintenant que tu es parti, parce que tu languissais après la maison de ton père, pourquoi as-tu dérobé mes dieux? ");
INSERT INTO fraLSG_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob répondit, et dit à Laban: J’avais de la crainte à la pensée que tu m’enlèverais peut-être tes filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Mais périsse celui auprès duquel tu trouveras tes dieux! En présence de nos frères, examine ce qui t’appartient chez moi, et prends-le. Jacob ne savait pas que Rachel les eût dérobés. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban entra dans la tente de Jacob, dans la tente de Léa, dans la tente des deux servantes, et il ne trouva rien. Il sortit de la tente de Léa, et entra dans la tente de Rachel. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel avait pris les théraphim, les avait mis sous le bât du chameau, et s’était assise dessus. Laban fouilla toute la tente, et ne trouva rien. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Elle dit à son père: Que mon seigneur ne se fâche point, si je ne puis me lever devant toi, car j’ai ce qui est ordinaire aux femmes. Il chercha, et ne trouva point les théraphim. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob s’irrita, et querella Laban. Il reprit la parole, et lui dit: Quel est mon crime, quel est mon péché, que tu me poursuives avec tant d’ardeur? ");
INSERT INTO fraLSG_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Quand tu as fouillé tous mes effets, qu’as-tu trouvé des effets de ta maison? Produis-le ici devant mes frères et tes frères, et qu’ils prononcent entre nous deux. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Voilà vingt ans que j’ai passés chez toi; tes brebis et tes chèvres n’ont point avorté, et je n’ai point mangé les béliers de ton troupeau. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Je ne t’ai point rapporté de bêtes déchirées, j’en ai payé le dommage; tu me redemandais ce qu’on me volait de jour et ce qu’on me volait de nuit. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","La chaleur me dévorait pendant le jour, et le froid pendant la nuit, et le sommeil fuyait de mes yeux. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Voilà vingt ans que j’ai passés dans ta maison; je t’ai servi quatorze ans pour tes deux filles, et six ans pour ton troupeau, et tu as changé dix fois mon salaire. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Si je n’eusse pas eu pour moi le Dieu de mon père, le Dieu d’Abraham, celui que craint Isaac, tu m’aurais maintenant renvoyé à vide. Dieu a vu ma souffrance et le travail de mes mains, et hier il a prononcé son jugement. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban répondit, et dit à Jacob: Ces filles sont mes filles, ces enfants sont mes enfants, ce troupeau est mon troupeau, et tout ce que tu vois est à moi. Et que puis-je faire aujourd’hui pour mes filles, ou pour leurs enfants qu’elles ont mis au monde? ");
INSERT INTO fraLSG_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Viens, faisons alliance, moi et toi, et que cela serve de témoignage entre moi et toi! ");
INSERT INTO fraLSG_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Jacob prit une pierre, et il la dressa pour monument. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jacob dit à ses frères: Ramassez des pierres. Ils prirent des pierres, et firent un monceau; et ils mangèrent là sur le monceau. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban l’appela Jegar-Sahadutha, et Jacob l’appela Galed. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban dit: Que ce monceau serve aujourd’hui de témoignage entre moi et toi! C’est pourquoi on lui a donné le nom de Galed. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","On l’appelle aussi Mitspa, parce que Laban dit: Que l’Éternel veille sur toi et sur moi, quand nous nous serons l’un et l’autre perdus de vue. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Si tu maltraites mes filles, et si tu prends encore d’autres femmes, ce n’est pas un homme qui sera avec nous, prends-y garde, c’est Dieu qui sera témoin entre moi et toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban dit à Jacob: Voici ce monceau, et voici ce monument que j’ai élevé entre moi et toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Que ce monceau soit témoin et que ce monument soit témoin que je n’irai point vers toi au-delà de ce monceau, et que tu ne viendras point vers moi au-delà de ce monceau et de ce monument, pour agir méchamment. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Que le Dieu d’Abraham et de Nachor, que le Dieu de leur père soit juge entre nous. Jacob jura par celui que craignait Isaac. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Jacob offrit un sacrifice sur la montagne, et il invita ses frères à manger; ils mangèrent donc, et passèrent la nuit sur la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban se leva de bon matin, baisa ses fils et ses filles, et les bénit. Ensuite il partit pour retourner dans sa demeure. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob poursuivit son chemin; et des anges de Dieu le rencontrèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","En les voyant, Jacob dit: C’est le camp de Dieu! Et il donna à ce lieu le nom de Mahanaïm. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Jacob envoya devant lui des messagers à Ésaü, son frère, au pays de Séir, dans le territoire d’Édom. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Il leur donna cet ordre: Voici ce que vous direz à mon seigneur Ésaü: Ainsi parle ton serviteur Jacob: J’ai séjourné chez Laban, et j’y suis resté jusqu’à présent; ");
INSERT INTO fraLSG_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","j’ai des bœufs, des ânes, des brebis, des serviteurs et des servantes, et j’envoie l’annoncer à mon seigneur, pour trouver grâce à tes yeux. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Les messagers revinrent auprès de Jacob, en disant: Nous sommes allés vers ton frère Ésaü; et il marche à ta rencontre, avec quatre cents hommes. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob fut très effrayé, et saisi d’angoisse. Il partagea en deux camps les gens qui étaient avec lui, les brebis, les bœufs et les chameaux; ");
INSERT INTO fraLSG_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","et il dit: Si Ésaü vient contre l’un des camps et le bat, le camp qui restera pourra se sauver. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Jacob dit: Dieu de mon père Abraham, Dieu de mon père Isaac, Éternel, qui m’as dit: Retourne dans ton pays et dans ton lieu de naissance, et je te ferai du bien! ");
INSERT INTO fraLSG_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Je suis trop petit pour toutes les grâces et pour toute la fidélité dont tu as usé envers ton serviteur; car j’ai passé ce Jourdain avec mon bâton, et maintenant je forme deux camps. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Délivre-moi, je te prie, de la main de mon frère, de la main d’Ésaü! Car je crains qu’il ne vienne, et qu’il ne me frappe, avec la mère et les enfants. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Et toi, tu as dit: Je te ferai du bien, et je rendrai ta postérité comme le sable de la mer, si abondant qu’on ne saurait le compter. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","C’est dans ce lieu-là que Jacob passa la nuit. Il prit de ce qu’il avait sous la main, pour faire un présent à Ésaü, son frère: ");
INSERT INTO fraLSG_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","deux cents chèvres et vingt boucs, deux cents brebis et vingt béliers, ");
INSERT INTO fraLSG_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","trente femelles de chameaux avec leurs petits qu’elles allaitaient, quarante vaches et dix taureaux, vingt ânesses et dix ânes. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Il les remit à ses serviteurs, troupeau par troupeau séparément, et il dit à ses serviteurs: Passez devant moi, et mettez un intervalle entre chaque troupeau. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Il donna cet ordre au premier: Quand Ésaü, mon frère, te rencontrera, et te demandera: A qui es-tu? Où vas-tu? Et à qui appartient ce troupeau devant toi? ");
INSERT INTO fraLSG_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","tu répondras: A ton serviteur Jacob; c’est un présent envoyé à mon seigneur Ésaü; et voici, il vient lui-même derrière nous. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Il donna le même ordre au second, au troisième, et à tous ceux qui suivaient les troupeaux: C’est ainsi que vous parlerez à mon seigneur Ésaü, quand vous le rencontrerez. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Vous direz: Voici, ton serviteur Jacob vient aussi derrière nous. Car il se disait: Je l’apaiserai par ce présent qui va devant moi; ensuite je le verrai en face, et peut-être m’accueillera-t-il favorablement. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Le présent passa devant lui; et il resta cette nuit-là dans le camp. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Il se leva la même nuit, prit ses deux femmes, ses deux servantes, et ses onze enfants, et passa le gué de Jabbok. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Il les prit, leur fit passer le torrent, et le fit passer à tout ce qui lui appartenait. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Jacob demeura seul. Alors un homme lutta avec lui jusqu’au lever de l’aurore. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Voyant qu’il ne pouvait le vaincre, cet homme le frappa à l’emboîture de la hanche; et l’emboîture de la hanche de Jacob se démit pendant qu’il luttait avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Il dit: Laisse-moi aller, car l’aurore se lève. Et Jacob répondit: Je ne te laisserai point aller, que tu ne m’aies béni. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Il lui dit: Quel est ton nom? Et il répondit: Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Il dit encore: Ton nom ne sera plus Jacob, mais tu seras appelé Israël; car tu as lutté avec Dieu et avec des hommes, et tu as été vainqueur. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob l’interrogea, en disant: Fais-moi je te prie, connaître ton nom. Il répondit: Pourquoi demandes-tu mon nom? Et il le bénit là. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Jacob appela ce lieu du nom de Peniel: car, dit-il, j’ai vu Dieu face à face, et mon âme a été sauvée. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Le soleil se levait, lorsqu’il passa Peniel. Jacob boitait de la hanche. ");
INSERT INTO fraLSG_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","C’est pourquoi jusqu’à ce jour, les enfants d’Israël ne mangent point le tendon qui est à l’emboîture de la hanche; car Dieu frappa Jacob à l’emboîture de la hanche, au tendon. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Jacob leva les yeux, et regarda; et voici, Ésaü arrivait, avec quatre cents hommes. Il répartit les enfants entre Léa, Rachel, et les deux servantes. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Il plaça en tête les servantes avec leurs enfants, puis Léa avec ses enfants, et enfin Rachel avec Joseph. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Lui-même passa devant eux; et il se prosterna en terre sept fois, jusqu’à ce qu’il fût près de son frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Ésaü courut à sa rencontre; il l’embrassa, se jeta à son cou, et le baisa. Et ils pleurèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ésaü, levant les yeux, vit les femmes et les enfants, et il dit: Qui sont ceux que tu as là? Et Jacob répondit: Ce sont les enfants que Dieu a accordés à ton serviteur. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Les servantes s’approchèrent, elles et leurs enfants, et se prosternèrent; ");
INSERT INTO fraLSG_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Léa et ses enfants s’approchèrent aussi, et se prosternèrent; ensuite Joseph et Rachel s’approchèrent, et se prosternèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ésaü dit: A quoi destines-tu tout ce camp que j’ai rencontré? Et Jacob répondit: A trouver grâce aux yeux de mon seigneur. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ésaü dit: Je suis dans l’abondance, mon frère; garde ce qui est à toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Et Jacob répondit: Non, je te prie, si j’ai trouvé grâce à tes yeux, accepte de ma main mon présent; car c’est pour cela que j’ai regardé ta face comme on regarde la face de Dieu, et tu m’as accueilli favorablement. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Accepte donc mon présent qui t’a été offert, puisque Dieu m’a comblé de grâces, et que je ne manque de rien. Il insista auprès de lui, et Ésaü accepta. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ésaü dit: Partons, mettons-nous en route; j’irai devant toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob lui répondit: Mon seigneur sait que les enfants sont délicats, et que j’ai des brebis et des vaches qui allaitent; si l’on forçait leur marche un seul jour, tout le troupeau périrait. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Que mon seigneur prenne les devants sur son serviteur; et moi, je suivrai lentement, au pas du troupeau qui me précédera, et au pas des enfants, jusqu’à ce que j’arrive chez mon seigneur, à Séir. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ésaü dit: Je veux au moins laisser avec toi une partie de mes gens. Et Jacob répondit: Pourquoi cela? Que je trouve seulement grâce aux yeux de mon seigneur! ");
INSERT INTO fraLSG_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Le même jour, Ésaü reprit le chemin de Séir. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob partit pour Succoth. Il bâtit une maison pour lui, et il fit des cabanes pour ses troupeaux. C’est pourquoi l’on a appelé ce lieu du nom de Succoth. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","A son retour de Paddan-Aram, Jacob arriva heureusement à la ville de Sichem, dans le pays de Canaan, et il campa devant la ville. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Il acheta la portion du champ où il avait dressé sa tente, des fils d’Hamor, père de Sichem, pour cent kesita. ");
INSERT INTO fraLSG_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Et là, il éleva un autel, qu’il appela El-Élohé-Israël. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dina, la fille que Léa avait enfantée à Jacob, sortit pour voir les filles du pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Elle fut aperçue de Sichem, fils de Hamor, prince du pays. Il l’enleva, coucha avec elle, et la déshonora. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Son cœur s’attacha à Dina, fille de Jacob; il aima la jeune fille, et sut parler à son cœur. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Et Sichem dit à Hamor, son père: Donne-moi cette jeune fille pour femme. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jacob apprit qu’il avait déshonoré Dina, sa fille; et, comme ses fils étaient aux champs avec son troupeau, Jacob garda le silence jusqu’à leur retour. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor, père de Sichem, se rendit auprès de Jacob pour lui parler. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Et les fils de Jacob revenaient des champs, lorsqu’ils apprirent la chose; ces hommes furent irrités et se mirent dans une grande colère, parce que Sichem avait commis une infamie en Israël, en couchant avec la fille de Jacob, ce qui n’aurait pas dû se faire. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor leur adressa ainsi la parole: Le cœur de Sichem, mon fils, s’est attaché à votre fille; donnez-la-lui pour femme, je vous prie. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Alliez-vous avec nous; vous nous donnerez vos filles, et vous prendrez pour vous les nôtres. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Vous habiterez avec nous, et le pays sera à votre disposition; restez, pour y trafiquer et y acquérir des propriétés. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sichem dit au père et aux frères de Dina: Que je trouve grâce à vos yeux, et je donnerai ce que vous me direz. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Exigez de moi une forte dot et beaucoup de présents, et je donnerai ce que vous me direz; mais accordez-moi pour femme la jeune fille. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Les fils de Jacob répondirent et parlèrent avec ruse à Sichem et à Hamor, son père, parce que Sichem avait déshonoré Dina, leur sœur. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ils leur dirent: C’est une chose que nous ne pouvons pas faire, que de donner notre sœur à un homme incirconcis; car ce serait un opprobre pour nous. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nous ne consentirons à votre désir qu’à la condition que vous deveniez comme nous, et que tout mâle parmi vous soit circoncis. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Nous vous donnerons alors nos filles, et nous prendrons pour nous les vôtres; nous habiterons avec vous, et nous formerons un seul peuple. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Mais si vous ne voulez pas nous écouter et vous faire circoncire, nous prendrons notre fille, et nous nous en irons. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Leurs paroles eurent l’assentiment de Hamor et de Sichem, fils de Hamor. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Le jeune homme ne tarda pas à faire la chose, car il aimait la fille de Jacob. Il était considéré de tous dans la maison de son père. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamor et Sichem, son fils, se rendirent à la porte de leur ville, et ils parlèrent ainsi aux gens de leur ville: ");
INSERT INTO fraLSG_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ces hommes sont paisibles à notre égard; qu’ils restent dans le pays, et qu’ils y trafiquent; le pays est assez vaste pour eux. Nous prendrons pour femmes leurs filles, et nous leur donnerons nos filles. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mais ces hommes ne consentiront à habiter avec nous, pour former un seul peuple, qu’à la condition que tout mâle parmi nous soit circoncis, comme ils sont eux-mêmes circoncis. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Leurs troupeaux, leurs biens et tout leur bétail, ne seront-ils pas à nous? Acceptons seulement leur condition, pour qu’ils restent avec nous. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tous ceux qui étaient venus à la porte de la ville écoutèrent Hamor et Sichem, son fils; et tous les mâles se firent circoncire, tous ceux qui étaient venus à la porte de la ville. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Le troisième jour, pendant qu’ils étaient souffrants, les deux fils de Jacob, Siméon et Lévi, frères de Dina, prirent chacun leur épée, tombèrent sur la ville qui se croyait en sécurité, et tuèrent tous les mâles. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ils passèrent aussi au fil de l’épée Hamor et Sichem, son fils; ils enlevèrent Dina de la maison de Sichem, et sortirent. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Les fils de Jacob se jetèrent sur les morts, et pillèrent la ville, parce qu’on avait déshonoré leur sœur. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ils prirent leurs troupeaux, leurs bœufs et leurs ânes, ce qui était dans la ville et ce qui était dans les champs; ");
INSERT INTO fraLSG_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ils emmenèrent comme butin toutes leurs richesses, leurs enfants et leurs femmes, et tout ce qui se trouvait dans les maisons. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Alors Jacob dit à Siméon et à Lévi: Vous me troublez, en me rendant odieux aux habitants du pays, aux Cananéens et aux Phérésiens. Je n’ai qu’un petit nombre d’hommes; et ils se rassembleront contre moi, ils me frapperont, et je serai détruit, moi et ma maison. ");
INSERT INTO fraLSG_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ils répondirent: Traitera-t-on notre sœur comme une prostituée? ");
INSERT INTO fraLSG_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Dieu dit à Jacob: Lève-toi, monte à Béthel, et demeures-y; là, tu dresseras un autel au Dieu qui t’apparut, lorsque tu fuyais Ésaü, ton frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Jacob dit à sa maison et à tous ceux qui étaient avec lui: Otez les dieux étrangers qui sont au milieu de vous, purifiez-vous, et changez de vêtements. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Nous nous lèverons, et nous monterons à Béthel; là, je dresserai un autel au Dieu qui m’a exaucé dans le jour de ma détresse, et qui a été avec moi pendant le voyage que j’ai fait. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ils donnèrent à Jacob tous les dieux étrangers qui étaient entre leurs mains, et les anneaux qui étaient à leurs oreilles. Jacob les enfouit sous le térébinthe qui est près de Sichem. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ensuite ils partirent. La terreur de Dieu se répandit sur les villes qui les entouraient, et l’on ne poursuivit point les fils de Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob arriva, lui et tous ceux qui étaient avec lui, à Luz, qui est Béthel, dans le pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Il bâtit là un autel, et il appela ce lieu El-Béthel; car c’est là que Dieu s’était révélé à lui lorsqu’il fuyait son frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Débora, nourrice de Rebecca, mourut; et elle fut enterrée au-dessous de Béthel, sous le chêne auquel on a donné le nom de chêne des pleurs. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Dieu apparut encore à Jacob, après son retour de Paddan-Aram, et il le bénit. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Dieu lui dit: Ton nom est Jacob; tu ne seras plus appelé Jacob, mais ton nom sera Israël. Et il lui donna le nom d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Dieu lui dit: Je suis le Dieu tout-puissant. Sois fécond, et multiplie: une nation et une multitude de nations naîtront de toi, et des rois sortiront de tes reins. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Je te donnerai le pays que j’ai donné à Abraham et à Isaac, et je donnerai ce pays à ta postérité après toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Dieu s’éleva au-dessus de lui, dans le lieu où il lui avait parlé. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Et Jacob dressa un monument dans le lieu où Dieu lui avait parlé, un monument de pierres, sur lequel il fit une libation et versa de l’huile. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Jacob donna le nom de Béthel au lieu où Dieu lui avait parlé. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ils partirent de Béthel; et il y avait encore une certaine distance jusqu’à Éphrata, lorsque Rachel accoucha. Elle eut un accouchement pénible; ");
INSERT INTO fraLSG_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","et pendant les douleurs de l’enfantement, la sage-femme lui dit: Ne crains point, car tu as encore un fils! ");
INSERT INTO fraLSG_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Et comme elle allait rendre l’âme, car elle était mourante, elle lui donna le nom de Ben-Oni; mais le père l’appela Benjamin. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel mourut, et elle fut enterrée sur le chemin d’Éphrata, qui est Bethléhem. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob éleva un monument sur son sépulcre; c’est le monument du sépulcre de Rachel, qui existe encore aujourd’hui. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israël partit; et il dressa sa tente au-delà de Migdal-Éder. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Pendant qu’Israël habitait cette contrée, Ruben alla coucher avec Bilha, concubine de son père. Et Israël l’apprit. Les fils de Jacob étaient au nombre de douze. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Fils de Léa: Ruben, premier-né de Jacob, Siméon, Lévi, Juda, Issacar et Zabulon. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Fils de Rachel: Joseph et Benjamin. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Fils de Bilha, servante de Rachel: Dan et Nephthali. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Fils de Zilpa, servante de Léa: Gad et Aser. Ce sont là les fils de Jacob, qui lui naquirent à Paddan-Aram. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Jacob arriva auprès d’Isaac, son père, à Mamré, à Kirjath-Arba, qui est Hébron, où avaient séjourné Abraham et Isaac. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Les jours d’Isaac furent de cent quatre-vingts ans. ");
INSERT INTO fraLSG_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Il expira et mourut, et il fut recueilli auprès de son peuple, âgé et rassasié de jours, et Ésaü et Jacob, ses fils, l’enterrèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Voici la postérité d’Ésaü, qui est Édom. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ésaü prit ses femmes parmi les filles de Canaan: Ada, fille d’Élon, le Héthien; Oholibama, fille d’Ana, fille de Tsibeon, le Hévien; ");
INSERT INTO fraLSG_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","et Basmath, fille d’Ismaël, sœur de Nebajoth. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada enfanta à Ésaü Éliphaz; Basmath enfanta Réuel; ");
INSERT INTO fraLSG_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","et Oholibama enfanta Jéusch, Jaelam et Koré. Ce sont là les fils d’Ésaü, qui lui naquirent dans le pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ésaü prit ses femmes, ses fils et ses filles, toutes les personnes de sa maison, ses troupeaux, tout son bétail, et tout le bien qu’il avait acquis au pays de Canaan, et il s’en alla dans un autre pays, loin de Jacob, son frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Car leurs richesses étaient trop considérables pour qu’ils demeurassent ensemble, et la contrée où ils séjournaient ne pouvait plus leur suffire à cause de leurs troupeaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ésaü s’établit dans la montagne de Séir. Ésaü, c’est Édom. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Voici la postérité d’Ésaü, père d’Édom, dans la montagne de Séir. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Voici les noms des fils d’Ésaü: Éliphaz, fils d’Ada, femme d’Ésaü; Réuel, fils de Basmath, femme d’Ésaü. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Les fils d’Éliphaz furent: Théman, Omar, Tsepho, Gaetham et Kenaz. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Et Thimna était la concubine d’Éliphaz, fils d’Ésaü: elle enfanta à Éliphaz Amalek. Ce sont là les fils d’Ada, femme d’Ésaü. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Voici les fils de Réuel: Nahath, Zérach, Schamma et Mizza. Ce sont là les fils de Basmath, femme d’Ésaü. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Voici les fils d’Oholibama, fille d’Ana, fille de Tsibeon, femme d’Ésaü: elle enfanta à Ésaü Jéusch, Jaelam et Koré. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Voici les chefs de tribus issues des fils d’Ésaü. Voici les fils d’Éliphaz, premier-né d’Ésaü: le chef Théman, le chef Omar, le chef Tsepho, le chef Kenaz, ");
INSERT INTO fraLSG_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","le chef Koré, le chef Gaetham, le chef Amalek. Ce sont là les chefs issus d’Éliphaz, dans le pays d’Édom. Ce sont les fils d’Ada. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Voici les fils de Réuel, fils d’Ésaü: le chef Nahath, le chef Zérach, le chef Schamma, le chef Mizza. Ce sont là les chefs issus de Réuel, dans le pays d’Édom. Ce sont là les fils de Basmath, femme d’Ésaü. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Voici les fils d’Oholibama, femme d’Ésaü: le chef Jéusch, le chef Jaelam, le chef Koré. Ce sont là les chefs issus d’Oholibama, fille d’Ana, femme d’Ésaü. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ce sont là les fils d’Ésaü, et ce sont là leurs chefs de tribus. Ésaü, c’est Édom. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Voici les fils de Séir, le Horien, anciens habitants du pays: Lothan, Schobal, Tsibeon, Ana, ");
INSERT INTO fraLSG_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dischon, Étser, et Dischan. Ce sont là les chefs des Horiens, fils de Séir, dans le pays d’Édom. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Les fils de Lothan furent: Hori et Hémam. La sœur de Lothan fut Thimna. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Voici les fils de Schobal: Alvan, Manahath, Ébal, Schepho et Onam. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Voici les fils de Tsibeon: Ajja et Ana. C’est cet Ana qui trouva les sources chaudes dans le désert, quand il faisait paître les ânes de Tsibeon, son père. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Voici les enfants d’Ana: Dischon, et Oholibama, fille d’Ana. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Voici les fils de Dischon: Hemdan, Eschban, Jithran et Karen. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Voici les fils d’Étser: Bilhan, Zaavan et Akan. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Voici les fils de Dischan: Uts et Aran. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Voici les chefs des Horiens: le chef Lothan, le chef Schobal, le chef Tsibeon, le chef Ana, ");
INSERT INTO fraLSG_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","le chef Dischon, le chef Étser, le chef Dischan. Ce sont là les chefs des Horiens, les chefs qu’ils eurent dans le pays de Séir. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Voici les rois qui ont régné dans le pays d’Édom, avant qu’un roi régnât sur les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Béla, fils de Béor, régna sur Édom; et le nom de sa ville était Dinhaba. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Béla mourut; et Jobab, fils de Zérach, de Botsra, régna à sa place. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab mourut; et Huscham, du pays des Thémanites, régna à sa place. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Huscham mourut; et Hadad, fils de Bedad, régna à sa place. C’est lui qui frappa Madian dans les champs de Moab. Le nom de sa ville était Avith. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad mourut; et Samla, de Masréka, régna à sa place. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla mourut; et Saül, de Rehoboth sur le fleuve, régna à sa place. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Saül mourut; et Baal-Hanan, fils d’Acbor, régna à sa place. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baal-Hanan, fils d’Acbor, mourut; et Hadar régna à sa place. Le nom de sa ville était Pau; et le nom de sa femme Mehéthabeel, fille de Mathred, fille de Mézahab. ");
INSERT INTO fraLSG_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Voici les noms des chefs issus d’Ésaü, selon leurs tribus, selon leurs territoires, et d’après leurs noms: le chef Thimna, le chef Alva, le chef Jetheth, ");
INSERT INTO fraLSG_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","le chef Oholibama, le chef Éla, le chef Pinon, ");
INSERT INTO fraLSG_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","le chef Kenaz, le chef Théman, le chef Mibtsar, ");
INSERT INTO fraLSG_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","le chef Magdiel, le chef Iram. Ce sont là les chefs d’Édom, selon leurs habitations dans le pays qu’ils possédaient. C’est là Ésaü, père d’Édom. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacob demeura dans le pays de Canaan, où avait séjourné son père. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Voici la postérité de Jacob. Joseph, âgé de dix-sept ans, faisait paître le troupeau avec ses frères; cet enfant était auprès des fils de Bilha et des fils de Zilpa, femmes de son père. Et Joseph rapportait à leur père leurs mauvais propos. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israël aimait Joseph plus que tous ses autres fils, parce qu’il l’avait eu dans sa vieillesse; et il lui fit une tunique de plusieurs couleurs. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ses frères virent que leur père l’aimait plus qu’eux tous, et ils le prirent en haine. Ils ne pouvaient lui parler avec amitié. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph eut un songe, et il le raconta à ses frères, qui le haïrent encore davantage. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Il leur dit: Écoutez donc ce songe que j’ai eu! ");
INSERT INTO fraLSG_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nous étions à lier des gerbes au milieu des champs; et voici, ma gerbe se leva et se tint debout, et vos gerbes l’entourèrent et se prosternèrent devant elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Ses frères lui dirent: Est-ce que tu régneras sur nous? Est-ce que tu nous gouverneras? Et ils le haïrent encore davantage, à cause de ses songes et à cause de ses paroles. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Il eut encore un autre songe, et il le raconta à ses frères. Il dit: J’ai eu encore un songe! Et voici, le soleil, la lune et onze étoiles se prosternaient devant moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Il le raconta à son père et à ses frères. Son père le réprimanda, et lui dit: Que signifie ce songe que tu as eu? Faut-il que nous venions, moi, ta mère et tes frères, nous prosterner en terre devant toi? ");
INSERT INTO fraLSG_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ses frères eurent de l’envie contre lui, mais son père garda le souvenir de ces choses. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Les frères de Joseph étant allés à Sichem, pour faire paître le troupeau de leur père, ");
INSERT INTO fraLSG_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israël dit à Joseph: Tes frères ne font-ils pas paître le troupeau à Sichem? Viens, je veux t’envoyer vers eux. Et il répondit: Me voici! ");
INSERT INTO fraLSG_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israël lui dit: Va, je te prie, et vois si tes frères sont en bonne santé et si le troupeau est en bon état; et tu m’en rapporteras des nouvelles. Il l’envoya ainsi de la vallée d’Hébron; et Joseph alla à Sichem. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Un homme le rencontra, comme il errait dans les champs. Il le questionna, en disant: Que cherches-tu? ");
INSERT INTO fraLSG_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseph répondit: Je cherche mes frères; dis-moi, je te prie, où ils font paître leur troupeau. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Et l’homme dit: Ils sont partis d’ici; car je les ai entendus dire: Allons à Dothan. Joseph alla après ses frères, et il les trouva à Dothan. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ils le virent de loin; et, avant qu’il fût près d’eux, ils complotèrent de le faire mourir. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ils se dirent l’un à l’autre: Voici le faiseur de songes qui arrive. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Venez maintenant, tuons-le, et jetons-le dans une des citernes; nous dirons qu’une bête féroce l’a dévoré, et nous verrons ce que deviendront ses songes. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruben entendit cela, et il le délivra de leurs mains. Il dit: Ne lui ôtons pas la vie. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruben leur dit: Ne répandez point de sang; jetez-le dans cette citerne qui est au désert, et ne mettez pas la main sur lui. Il avait dessein de le délivrer de leurs mains pour le faire retourner vers son père. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Lorsque Joseph fut arrivé auprès de ses frères, ils le dépouillèrent de sa tunique, de la tunique de plusieurs couleurs, qu’il avait sur lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ils le prirent, et le jetèrent dans la citerne. Cette citerne était vide; il n’y avait point d’eau. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ils s’assirent ensuite pour manger. Ayant levé les yeux, ils virent une caravane d’Ismaélites venant de Galaad; leurs chameaux étaient chargés d’aromates, de baume et de myrrhe, qu’ils transportaient en Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Alors Juda dit à ses frères: Que gagnerons-nous à tuer notre frère et à cacher son sang? ");
INSERT INTO fraLSG_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Venez, vendons-le aux Ismaélites, et ne mettons pas la main sur lui, car il est notre frère, notre chair. Et ses frères l’écoutèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Au passage des marchands madianites, ils tirèrent et firent remonter Joseph hors de la citerne; et ils le vendirent pour vingt sicles d’argent aux Ismaélites, qui l’emmenèrent en Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben revint à la citerne; et voici, Joseph n’était plus dans la citerne. Il déchira ses vêtements, ");
INSERT INTO fraLSG_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","retourna vers ses frères, et dit: L’enfant n’y est plus! Et moi, où irai-je? ");
INSERT INTO fraLSG_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ils prirent alors la tunique de Joseph; et, ayant tué un bouc, ils plongèrent la tunique dans le sang. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ils envoyèrent à leur père la tunique de plusieurs couleurs, en lui faisant dire: Voici ce que nous avons trouvé! Reconnais si c’est la tunique de ton fils, ou non. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacob la reconnut, et dit: C’est la tunique de mon fils! une bête féroce l’a dévoré! Joseph a été mis en pièces! ");
INSERT INTO fraLSG_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Et il déchira ses vêtements, il mit un sac sur ses reins, et il porta longtemps le deuil de son fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Tous ses fils et toutes ses filles vinrent pour le consoler; mais il ne voulut recevoir aucune consolation. Il disait: C’est en pleurant que je descendrai vers mon fils au séjour des morts! Et il pleurait son fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Les Madianites le vendirent en Égypte à Potiphar, officier de Pharaon, chef des gardes. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","En ce temps-là, Juda s’éloigna de ses frères, et se retira vers un homme d’Adullam, nommé Hira. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Là, Juda vit la fille d’un Cananéen, nommé Schua; il la prit pour femme, et alla vers elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Elle devint enceinte, et enfanta un fils, qu’elle appela Er. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Elle devint encore enceinte, et enfanta un fils, qu’elle appela Onan. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Elle enfanta de nouveau un fils, qu’elle appela Schéla; Juda était à Czib quand elle l’enfanta. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Juda prit pour Er, son premier-né, une femme nommée Tamar. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Er, premier-né de Juda, était méchant aux yeux de l’Éternel; et l’Éternel le fit mourir. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Alors Juda dit à Onan: Va vers la femme de ton frère, prends-la, comme beau-frère, et suscite une postérité à ton frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onan, sachant que cette postérité ne serait pas à lui, se souillait à terre lorsqu’il allait vers la femme de son frère, afin de ne pas donner de postérité à son frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ce qu’il faisait déplut à l’Éternel, qui le fit aussi mourir. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Alors Juda dit à Tamar, sa belle-fille: Demeure veuve dans la maison de ton père, jusqu’à ce que Schéla, mon fils, soit grand. Il parlait ainsi dans la crainte que Schéla ne mourût comme ses frères. Tamar s’en alla, et elle habita dans la maison de son père. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Les jours s’écoulèrent, et la fille de Schua, femme de Juda, mourut. Lorsque Juda fut consolé, il monta à Thimna, vers ceux qui tondaient ses brebis, lui et son ami Hira, l’Adullamite. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","On en informa Tamar, et on lui dit: Voici ton beau-père qui monte à Thimna, pour tondre ses brebis. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Alors elle ôta ses habits de veuve, elle se couvrit d’un voile et s’enveloppa, et elle s’assit à l’entrée d’Énaïm, sur le chemin de Thimna; car elle voyait que Schéla était devenu grand, et qu’elle ne lui était point donnée pour femme. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Juda la vit, et la prit pour une prostituée, parce qu’elle avait couvert son visage. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Il l’aborda sur le chemin, et dit: Laisse-moi aller vers toi. Car il ne connut pas que c’était sa belle-fille. Elle dit: Que me donneras-tu pour venir vers moi? ");
INSERT INTO fraLSG_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Il répondit: Je t’enverrai un chevreau de mon troupeau. Elle dit: Me donneras-tu un gage, jusqu’à ce que tu l’envoies? ");
INSERT INTO fraLSG_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Il répondit: Quel gage te donnerai-je? Elle dit: Ton cachet, ton cordon, et le bâton que tu as à la main. Il les lui donna. Puis il alla vers elle; et elle devint enceinte de lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Elle se leva, et s’en alla; elle ôta son voile, et remit ses habits de veuve. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Juda envoya le chevreau par son ami l’Adullamite, pour retirer le gage des mains de la femme. Mais il ne la trouva point. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Il interrogea les gens du lieu, en disant: Où est cette prostituée qui se tenait à Énaïm, sur le chemin? Ils répondirent: Il n’y a point eu ici de prostituée. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Il retourna auprès de Juda, et dit: Je ne l’ai pas trouvée, et même les gens du lieu ont dit: Il n’y a point eu ici de prostituée. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Juda dit: Qu’elle garde ce qu’elle a! Ne nous exposons pas au mépris. Voici, j’ai envoyé ce chevreau, et tu ne l’as pas trouvée. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Environ trois mois après, on vint dire à Juda: Tamar, ta belle-fille, s’est prostituée, et même la voilà enceinte à la suite de sa prostitution. Et Juda dit: Faites-la sortir, et qu’elle soit brûlée. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Comme on l’amenait dehors, elle fit dire à son beau-père: C’est de l’homme à qui ces choses appartiennent que je suis enceinte; reconnais, je te prie, à qui sont ce cachet, ces cordons et ce bâton. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Juda les reconnut, et dit: Elle est moins coupable que moi, puisque je ne l’ai pas donnée à Schéla, mon fils. Et il ne la connut plus. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Quand elle fut au moment d’accoucher, voici, il y avait deux jumeaux dans son ventre. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Et pendant l’accouchement il y en eut un qui présenta la main; la sage-femme la prit, et y attacha un fil cramoisi, en disant: Celui-ci sort le premier. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Mais il retira la main, et son frère sortit. Alors la sage-femme dit: Quelle brèche tu as faite! Et elle lui donna le nom de Pérets. ");
INSERT INTO fraLSG_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ensuite sortit son frère, qui avait à la main le fil cramoisi; et on lui donna le nom de Zérach. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","On fit descendre Joseph en Égypte; et Potiphar, officier de Pharaon, chef des gardes, Égyptien, l’acheta des Ismaélites qui l’y avaient fait descendre. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","L’Éternel fut avec lui, et la prospérité l’accompagna; il habitait dans la maison de son maître, l’Égyptien. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Son maître vit que l’Éternel était avec lui, et que l’Éternel faisait prospérer entre ses mains tout ce qu’il entreprenait. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Joseph trouva grâce aux yeux de son maître, qui l’employa à son service, l’établit sur sa maison, et lui confia tout ce qu’il possédait. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Dès que Potiphar l’eut établi sur sa maison et sur tout ce qu’il possédait, l’Éternel bénit la maison de l’Égyptien, à cause de Joseph; et la bénédiction de l’Éternel fut sur tout ce qui lui appartenait, soit à la maison, soit aux champs. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Il abandonna aux mains de Joseph tout ce qui lui appartenait, et il n’avait avec lui d’autre soin que celui de prendre sa nourriture. Or, Joseph était beau de taille et beau de figure. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Après ces choses, il arriva que la femme de son maître porta les yeux sur Joseph, et dit: Couche avec moi! ");
INSERT INTO fraLSG_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Il refusa, et dit à la femme de son maître: Voici, mon maître ne prend avec moi connaissance de rien dans la maison, et il a remis entre mes mains tout ce qui lui appartient. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Il n’est pas plus grand que moi dans cette maison, et il ne m’a rien interdit, excepté toi, parce que tu es sa femme. Comment ferais-je un aussi grand mal et pécherais-je contre Dieu? ");
INSERT INTO fraLSG_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Quoiqu’elle parlât tous les jours à Joseph, il refusa de coucher auprès d’elle, d’être avec elle. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Un jour qu’il était entré dans la maison pour faire son ouvrage, et qu’il n’y avait là aucun des gens de la maison, ");
INSERT INTO fraLSG_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","elle le saisit par son vêtement, en disant: Couche avec moi! Il lui laissa son vêtement dans la main, et s’enfuit au dehors. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Lorsqu’elle vit qu’il lui avait laissé son vêtement dans la main, et qu’il s’était enfui dehors, ");
INSERT INTO fraLSG_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","elle appela les gens de sa maison, et leur dit: Voyez, il nous a amené un Hébreu pour se jouer de nous. Cet homme est venu vers moi pour coucher avec moi; mais j’ai crié à haute voix. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Et quand il a entendu que j’élevais la voix et que je criais, il a laissé son vêtement à côté de moi et s’est enfui dehors. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Et elle posa le vêtement de Joseph à côté d’elle, jusqu’à ce que son maître rentrât à la maison. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Alors elle lui parla ainsi: L’esclave hébreu que tu nous as amené est venu vers moi pour se jouer de moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Et comme j’ai élevé la voix et que j’ai crié, il a laissé son vêtement à côté de moi et s’est enfui dehors. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Après avoir entendu les paroles de sa femme, qui lui disait: Voilà ce que m’a fait ton esclave! Le maître de Joseph fut enflammé de colère. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Il prit Joseph, et le mit dans la prison, dans le lieu où les prisonniers du roi étaient enfermés: il fut là, en prison. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","L’Éternel fut avec Joseph, et il étendit sur lui sa bonté. Il le mit en faveur aux yeux du chef de la prison. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Et le chef de la prison plaça sous sa surveillance tous les prisonniers qui étaient dans la prison; et rien ne s’y faisait que par lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Le chef de la prison ne prenait aucune connaissance de ce que Joseph avait en main, parce que l’Éternel était avec lui. Et l’Éternel donnait de la réussite à ce qu’il faisait. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Après ces choses, il arriva que l’échanson et le panetier du roi d’Égypte, offensèrent leur maître, le roi d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Pharaon fut irrité contre ses deux officiers, le chef des échansons et le chef des panetiers. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Et il les fit mettre dans la maison du chef des gardes, dans la prison, dans le lieu où Joseph était enfermé. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Le chef des gardes les plaça sous la surveillance de Joseph, qui faisait le service auprès d’eux; et ils passèrent un certain temps en prison. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Pendant une même nuit, l’échanson et le panetier du roi d’Égypte, qui étaient enfermés dans la prison, eurent tous les deux un songe, chacun le sien, pouvant recevoir une explication distincte. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Joseph, étant venu le matin vers eux, les regarda; et voici, ils étaient tristes. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Alors il questionna les officiers de Pharaon, qui étaient avec lui dans la prison de son maître, et il leur dit: Pourquoi avez-vous mauvais visage aujourd’hui? ");
INSERT INTO fraLSG_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ils lui répondirent: Nous avons eu un songe, et il n’y a personne pour l’expliquer. Joseph leur dit: N’est-ce pas à Dieu qu’appartiennent les explications? Racontez-moi donc votre songe. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Le chef des échansons raconta son songe à Joseph, et lui dit: Dans mon songe, voici, il y avait un cep devant moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Ce cep avait trois sarments. Quand il eut poussé, sa fleur se développa et ses grappes donnèrent des raisins mûrs. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","La coupe de Pharaon était dans ma main. Je pris les raisins, je les pressai dans la coupe de Pharaon, et je mis la coupe dans la main de Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph lui dit: En voici l’explication. Les trois sarments sont trois jours. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Encore trois jours, et Pharaon relèvera ta tête et te rétablira dans ta charge; tu mettras la coupe dans la main de Pharaon, comme tu en avais l’habitude lorsque tu étais son échanson. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Mais souviens-toi de moi, quand tu seras heureux, et montre, je te prie, de la bonté à mon égard; parle en ma faveur à Pharaon, et fais-moi sortir de cette maison. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Car j’ai été enlevé du pays des Hébreux, et ici même je n’ai rien fait pour être mis en prison. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Le chef des panetiers, voyant que Joseph avait donné une explication favorable, dit: Voici, il y avait aussi, dans mon songe, trois corbeilles de pain blanc sur ma tête. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Dans la corbeille la plus élevée il y avait pour Pharaon des mets de toute espèce, cuits au four; et les oiseaux les mangeaient dans la corbeille au-dessus de ma tête. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph répondit, et dit: En voici l’explication. Les trois corbeilles sont trois jours. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Encore trois jours, et Pharaon enlèvera ta tête de dessus toi, te fera pendre à un bois, et les oiseaux mangeront ta chair. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Le troisième jour, jour de la naissance de Pharaon, il fit un festin à tous ses serviteurs; et il éleva la tête du chef des échansons et la tête du chef des panetiers, au milieu de ses serviteurs: ");
INSERT INTO fraLSG_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","il rétablit le chef des échansons dans sa charge d’échanson, pour qu’il mît la coupe dans la main de Pharaon; ");
INSERT INTO fraLSG_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","mais il fit pendre le chef des panetiers, selon l’explication que Joseph leur avait donnée. ");
INSERT INTO fraLSG_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Le chef des échansons ne pensa plus à Joseph. Il l’oublia. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Au bout de deux ans, Pharaon eut un songe. Voici, il se tenait près du fleuve. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Et voici, sept vaches belles à voir et grasses de chair montèrent hors du fleuve, et se mirent à paître dans la prairie. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Sept autres vaches laides à voir et maigres de chair montèrent derrière elles hors du fleuve, et se tinrent à leurs côtés sur le bord du fleuve. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Les vaches laides à voir et maigres de chair mangèrent les sept vaches belles à voir et grasses de chair. Et Pharaon s’éveilla. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Il se rendormit, et il eut un second songe. Voici, sept épis gras et beaux montèrent sur une même tige. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Et sept épis maigres et brûlés par le vent d’orient poussèrent après eux. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Les épis maigres engloutirent les sept épis gras et pleins. Et Pharaon s’éveilla. Voilà le songe. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Le matin, Pharaon eut l’esprit agité, et il fit appeler tous les magiciens et tous les sages de l’Égypte. Il leur raconta ses songes. Mais personne ne put les expliquer à Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Alors le chef des échansons prit la parole, et dit à Pharaon: Je vais rappeler aujourd’hui le souvenir de ma faute. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Pharaon s’était irrité contre ses serviteurs; et il m’avait fait mettre en prison dans la maison du chef des gardes, moi et le chef des panetiers. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nous eûmes l’un et l’autre un songe dans une même nuit; et chacun de nous reçut une explication en rapport avec le songe qu’il avait eu. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Il y avait là avec nous un jeune Hébreu, esclave du chef des gardes. Nous lui racontâmes nos songes, et il nous les expliqua. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Les choses sont arrivées selon l’explication qu’il nous avait donnée. Pharaon me rétablit dans ma charge, et il fit pendre le chef des panetiers. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pharaon fit appeler Joseph. On le fit sortir en hâte de prison. Il se rasa, changea de vêtements, et se rendit vers Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaon dit à Joseph: J’ai eu un songe. Personne ne peut l’expliquer; et j’ai appris que tu expliques un songe, après l’avoir entendu. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph répondit à Pharaon, en disant: Ce n’est pas moi! C’est Dieu qui donnera une réponse favorable à Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Pharaon dit alors à Joseph: Dans mon songe, voici, je me tenais sur le bord du fleuve. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Et voici, sept vaches grasses de chair et belles d’apparence montèrent hors du fleuve, et se mirent à paître dans la prairie. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Sept autres vaches montèrent derrière elles, maigres, fort laides d’apparence, et décharnées: je n’en ai point vu d’aussi laides dans tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Les vaches décharnées et laides mangèrent les sept premières vaches qui étaient grasses. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Elles les engloutirent dans leur ventre, sans qu’on s’aperçût qu’elles y fussent entrées; et leur apparence était laide comme auparavant. Et je m’éveillai. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Je vis encore en songe sept épis pleins et beaux, qui montèrent sur une même tige. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Et sept épis vides, maigres, brûlés par le vent d’orient, poussèrent après eux. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Les épis maigres engloutirent les sept beaux épis. Je l’ai dit aux magiciens, mais personne ne m’a donné l’explication. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph dit à Pharaon: Ce qu’a songé Pharaon est une seule chose; Dieu a fait connaître à Pharaon ce qu’il va faire. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Les sept vaches belles sont sept années: et les sept épis beaux sont sept années: c’est un seul songe. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Les sept vaches décharnées et laides, qui montaient derrière les premières, sont sept années; et les sept épis vides, brûlés par le vent d’orient, seront sept années de famine. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ainsi, comme je viens de le dire à Pharaon, Dieu a fait connaître à Pharaon ce qu’il va faire. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Voici, il y aura sept années de grande abondance dans tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Sept années de famine viendront après elles; et l’on oubliera toute cette abondance au pays d’Égypte, et la famine consumera le pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Cette famine qui suivra sera si forte qu’on ne s’apercevra plus de l’abondance dans le pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Si Pharaon a vu le songe se répéter une seconde fois, c’est que la chose est arrêtée de la part de Dieu, et que Dieu se hâtera de l’exécuter. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Maintenant, que Pharaon choisisse un homme intelligent et sage, et qu’il le mette à la tête du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Que Pharaon établisse des commissaires sur le pays, pour lever un cinquième des récoltes de l’Égypte pendant les sept années d’abondance. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Qu’ils rassemblent tous les produits de ces bonnes années qui vont venir; qu’ils fassent, sous l’autorité de Pharaon, des amas de blé, des approvisionnements dans les villes, et qu’ils en aient la garde. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ces provisions seront en réserve pour le pays, pour les sept années de famine qui arriveront dans le pays d’Égypte, afin que le pays ne soit pas consumé par la famine. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ces paroles plurent à Pharaon et à tous ses serviteurs. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Et Pharaon dit à ses serviteurs: Trouverions-nous un homme comme celui-ci, ayant en lui l’esprit de Dieu? ");
INSERT INTO fraLSG_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Et Pharaon dit à Joseph: Puisque Dieu t’a fait connaître toutes ces choses, il n’y a personne qui soit aussi intelligent et aussi sage que toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Je t’établis sur ma maison, et tout mon peuple obéira à tes ordres. Le trône seul m’élèvera au-dessus de toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pharaon dit à Joseph: Vois, je te donne le commandement de tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Pharaon ôta son anneau de la main, et le mit à la main de Joseph; il le revêtit d’habits de fin lin, et lui mit un collier d’or au cou. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Il le fit monter sur le char qui suivait le sien; et l’on criait devant lui: A genoux! C’est ainsi que Pharaon lui donna le commandement de tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Il dit encore à Joseph: Je suis Pharaon! Et sans toi personne ne lèvera la main ni le pied dans tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Pharaon appela Joseph du nom de Tsaphnath-Paenéach; et il lui donna pour femme Asnath, fille de Poti-Phéra, prêtre d’On. Et Joseph partit pour visiter le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseph était âgé de trente ans lorsqu’il se présenta devant Pharaon, roi d’Égypte; et il quitta Pharaon, et parcourut tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Pendant les sept années de fertilité, la terre rapporta abondamment. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Joseph rassembla tous les produits de ces sept années dans le pays d’Égypte; il fit des approvisionnements dans les villes, mettant dans l’intérieur de chaque ville les productions des champs d’alentour. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Joseph amassa du blé, comme le sable de la mer, en quantité si considérable que l’on cessa de compter, parce qu’il n’y avait plus de nombre. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Avant les années de famine, il naquit à Joseph deux fils, que lui enfanta Asnath, fille de Poti-Phéra, prêtre d’On. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph donna au premier-né le nom de Manassé, car, dit-il, Dieu m’a fait oublier toutes mes peines et toute la maison de mon père. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Et il donna au second le nom d’Éphraïm, car, dit-il, Dieu m’a rendu fécond dans le pays de mon affliction. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Les sept années d’abondance qu’il y eut au pays d’Égypte s’écoulèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Et les sept années de famine commencèrent à venir, ainsi que Joseph l’avait annoncé. Il y eut famine dans tous les pays; mais dans tout le pays d’Égypte il y avait du pain. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Quand tout le pays d’Égypte fut aussi affamé, le peuple cria à Pharaon pour avoir du pain. Pharaon dit à tous les Égyptiens: Allez vers Joseph, et faites ce qu’il vous dira. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","La famine régnait dans tout le pays. Joseph ouvrit tous les lieux d’approvisionnements, et vendit du blé aux Égyptiens. La famine augmentait dans le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Et de tous les pays on arrivait en Égypte, pour acheter du blé auprès de Joseph; car la famine était forte dans tous les pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacob, voyant qu’il y avait du blé en Égypte, dit à ses fils: Pourquoi vous regardez-vous les uns les autres? ");
INSERT INTO fraLSG_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Il dit: Voici, j’apprends qu’il y a du blé en Égypte; descendez-y, pour nous en acheter là, afin que nous vivions et que nous ne mourions pas. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Dix frères de Joseph descendirent en Égypte, pour acheter du blé. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Jacob n’envoya point avec eux Benjamin, frère de Joseph, dans la crainte qu’il ne lui arrivât quelque malheur. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Les fils d’Israël vinrent pour acheter du blé, au milieu de ceux qui venaient aussi; car la famine était dans le pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Joseph commandait dans le pays; c’est lui qui vendait du blé à tout le peuple du pays. Les frères de Joseph vinrent, et se prosternèrent devant lui la face contre terre. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph vit ses frères et les reconnut; mais il feignit d’être un étranger pour eux, il leur parla durement, et leur dit: D’où venez-vous? Ils répondirent: Du pays de Canaan, pour acheter des vivres. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph reconnut ses frères, mais eux ne le reconnurent pas. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Joseph se souvint des songes qu’il avait eus à leur sujet, et il leur dit: Vous êtes des espions; c’est pour observer les lieux faibles du pays que vous êtes venus. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ils lui répondirent: Non, mon seigneur, tes serviteurs sont venus pour acheter du blé. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nous sommes tous fils d’un même homme; nous sommes sincères, tes serviteurs ne sont pas des espions. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Il leur dit: Nullement; c’est pour observer les lieux faibles du pays que vous êtes venus. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ils répondirent: Nous, tes serviteurs, sommes douze frères, fils d’un même homme au pays de Canaan; et voici, le plus jeune est aujourd’hui avec notre père, et il y en a un qui n’est plus. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph leur dit: Je viens de vous le dire, vous êtes des espions. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Voici comment vous serez éprouvés. Par la vie de Pharaon! Vous ne sortirez point d’ici que votre jeune frère ne soit venu. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Envoyez l’un de vous pour chercher votre frère; et vous, restez prisonniers. Vos paroles seront éprouvées, et je saurai si la vérité est chez vous; sinon, par la vie de Pharaon! Vous êtes des espions. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Et il les mit ensemble trois jours en prison. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Le troisième jour, Joseph leur dit: Faites ceci, et vous vivrez. Je crains Dieu! ");
INSERT INTO fraLSG_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Si vous êtes sincères, que l’un de vos frères reste enfermé dans votre prison; et vous, partez, emportez du blé pour nourrir vos familles, ");
INSERT INTO fraLSG_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","et amenez-moi votre jeune frère, afin que vos paroles soient éprouvées et que vous ne mouriez point. Et ils firent ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ils se dirent alors l’un à l’autre: Oui, nous avons été coupables envers notre frère, car nous avons vu l’angoisse de son âme, quand il nous demandait grâce, et nous ne l’avons point écouté! C’est pour cela que cette affliction nous arrive. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben, prenant la parole, leur dit: Ne vous disais-je pas: Ne commettez point un crime envers cet enfant? Mais vous n’avez point écouté. Et voici, son sang est redemandé. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ils ne savaient pas que Joseph comprenait, car il se servait avec eux d’un interprète. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Il s’éloigna d’eux, pour pleurer. Il revint, et leur parla; puis il prit parmi eux Siméon, et le fit enchaîner sous leurs yeux. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Joseph ordonna qu’on remplît de blé leurs sacs, qu’on remît l’argent de chacun dans son sac, et qu’on leur donnât des provisions pour la route. Et l’on fit ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ils chargèrent le blé sur leurs ânes, et partirent. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","L’un d’eux ouvrit son sac pour donner du fourrage à son âne, dans le lieu où ils passèrent la nuit, et il vit l’argent qui était à l’entrée du sac. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Il dit à ses frères: Mon argent a été rendu, et le voici dans mon sac. Alors leur cœur fut en défaillance; et ils se dirent l’un à l’autre, en tremblant: Qu’est-ce que Dieu nous a fait? ");
INSERT INTO fraLSG_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ils revinrent auprès de Jacob, leur père, dans le pays de Canaan, et ils lui racontèrent tout ce qui leur était arrivé. Ils dirent: ");
INSERT INTO fraLSG_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","L’homme, qui est le seigneur du pays, nous a parlé durement, et il nous a pris pour des espions. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nous lui avons dit: Nous sommes sincères, nous ne sommes pas des espions. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nous sommes douze frères, fils de notre père; l’un n’est plus, et le plus jeune est aujourd’hui avec notre père au pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Et l’homme, qui est le seigneur du pays, nous a dit: Voici comment je saurai si vous êtes sincères. Laissez auprès de moi l’un de vos frères, prenez de quoi nourrir vos familles, partez, et amenez-moi votre jeune frère. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Je saurai ainsi que vous n’êtes pas des espions, que vous êtes sincères; je vous rendrai votre frère, et vous pourrez librement parcourir le pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Lorsqu’ils vidèrent leurs sacs, voici, le paquet d’argent de chacun était dans son sac. Ils virent, eux et leur père, leurs paquets d’argent, et ils eurent peur. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob, leur père, leur dit: Vous me privez de mes enfants! Joseph n’est plus, Siméon n’est plus, et vous prendriez Benjamin! C’est sur moi que tout cela retombe. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben dit à son père: Tu feras mourir mes deux fils si je ne te ramène pas Benjamin; remets-le entre mes mains, et je te le ramènerai. ");
INSERT INTO fraLSG_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Jacob dit: Mon fils ne descendra point avec vous; car son frère est mort, et il reste seul; s’il lui arrivait un malheur dans le voyage que vous allez faire, vous feriez descendre mes cheveux blancs avec douleur dans le séjour des morts. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","La famine s’appesantissait sur le pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Quand ils eurent fini de manger le blé qu’ils avaient apporté d’Égypte, Jacob dit à ses fils: Retournez, achetez-nous un peu de vivres. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Juda lui répondit: Cet homme nous a fait cette déclaration formelle: Vous ne verrez pas ma face, à moins que votre frère ne soit avec vous. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Si donc tu veux envoyer notre frère avec nous, nous descendrons, et nous t’achèterons des vivres. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Mais si tu ne veux pas l’envoyer, nous ne descendrons point, car cet homme nous a dit: Vous ne verrez pas ma face, à moins que votre frère ne soit avec vous. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israël dit alors: Pourquoi avez-vous mal agi à mon égard, en disant à cet homme que vous aviez encore un frère? ");
INSERT INTO fraLSG_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ils répondirent: Cet homme nous a interrogés sur nous et sur notre famille, en disant: Votre père vit-il encore? Avez-vous un frère? Et nous avons répondu à ces questions. Pouvions-nous savoir qu’il dirait: Faites descendre votre frère? ");
INSERT INTO fraLSG_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Juda dit à Israël, son père: Laisse venir l’enfant avec moi, afin que nous nous levions et que nous partions; et nous vivrons et ne mourrons pas, nous, toi, et nos enfants. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Je réponds de lui; tu le redemanderas de ma main. Si je ne le ramène pas auprès de toi et si je ne le remets pas devant ta face, je serai pour toujours coupable envers toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Car si nous n’eussions pas tardé, nous serions maintenant deux fois de retour. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Israël, leur père, leur dit: Puisqu’il le faut, faites ceci. Prenez dans vos sacs des meilleures productions du pays, pour en porter un présent à cet homme, un peu de baume et un peu de miel, des aromates, de la myrrhe, des pistaches et des amandes. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Prenez avec vous de l’argent au double, et remportez l’argent qu’on avait mis à l’entrée de vos sacs: peut-être était-ce une erreur. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Prenez votre frère, et levez-vous; retournez vers cet homme. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Que le Dieu tout-puissant vous fasse trouver grâce devant cet homme, et qu’il laisse revenir avec vous votre autre frère et Benjamin! Et moi, si je dois être privé de mes enfants, que j’en sois privé! ");
INSERT INTO fraLSG_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ils prirent le présent; ils prirent avec eux de l’argent au double, ainsi que Benjamin; ils se levèrent, descendirent en Égypte, et se présentèrent devant Joseph. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Dès que Joseph vit avec eux Benjamin, il dit à son intendant: Fais entrer ces gens dans la maison, tue et apprête; car ces gens mangeront avec moi à midi. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Cet homme fit ce que Joseph avait ordonné, et il conduisit ces gens dans la maison de Joseph. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ils eurent peur lorsqu’ils furent conduits à la maison de Joseph, et ils dirent: C’est à cause de l’argent remis l’autre fois dans nos sacs qu’on nous emmène; c’est pour se jeter sur nous, se précipiter sur nous; c’est pour nous prendre comme esclaves, et s’emparer de nos ânes. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Ils s’approchèrent de l’intendant de la maison de Joseph, et lui adressèrent la parole, à l’entrée de la maison. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ils dirent: Pardon! Mon seigneur, nous sommes déjà descendus une fois pour acheter des vivres. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Puis, quand nous arrivâmes, au lieu où nous devions passer la nuit, nous avons ouvert nos sacs; et voici, l’argent de chacun était à l’entrée de son sac, notre argent selon son poids: nous le rapportons avec nous. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Nous avons aussi apporté d’autre argent, pour acheter des vivres. Nous ne savons pas qui avait mis notre argent dans nos sacs. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","L’intendant répondit: Que la paix soit avec vous! Ne craignez rien. C’est votre Dieu, le Dieu de votre père, qui vous a donné un trésor dans vos sacs. Votre argent m’est parvenu. Et il leur amena Siméon. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Cet homme les fit entrer dans la maison de Joseph; il leur donna de l’eau et ils se lavèrent les pieds; il donna aussi du fourrage à leurs ânes. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ils préparèrent leur présent, en attendant que Joseph vienne à midi; car on les avait informés qu’ils mangeraient chez lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Quand Joseph fut arrivé à la maison, ils lui offrirent le présent qu’ils avaient apporté, et ils se prosternèrent en terre devant lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Il leur demanda comment ils se portaient; et il dit: Votre vieux père, dont vous avez parlé, est-il en bonne santé? Vit-il encore? ");
INSERT INTO fraLSG_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ils répondirent: Ton serviteur, notre père, est en bonne santé; il vit encore. Et ils s’inclinèrent et se prosternèrent. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Joseph leva les yeux; et, jetant un regard sur Benjamin, son frère, fils de sa mère, il dit: Est-ce là votre jeune frère, dont vous m’avez parlé? Et il ajouta: Dieu te fasse miséricorde, mon fils! ");
INSERT INTO fraLSG_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Ses entrailles étaient émues pour son frère, et il avait besoin de pleurer; il entra précipitamment dans une chambre, et il y pleura. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Après s’être lavé le visage, il en sortit; et, faisant des efforts pour se contenir, il dit: Servez à manger. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","On servit Joseph à part, et ses frères à part; les Égyptiens qui mangeaient avec lui furent aussi servis à part, car les Égyptiens ne pouvaient pas manger avec les Hébreux, parce que c’est à leurs yeux une abomination. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Les frères de Joseph s’assirent en sa présence, le premier-né selon son droit d’aînesse, et le plus jeune selon son âge; et ils se regardaient les uns les autres avec étonnement. ");
INSERT INTO fraLSG_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Joseph leur fit porter des mets qui étaient devant lui, et Benjamin en eut cinq fois plus que les autres. Ils burent, et s’égayèrent avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph donna cet ordre à l’intendant de sa maison: Remplis de vivres les sacs de ces gens, autant qu’ils en pourront porter, et mets l’argent de chacun à l’entrée de son sac. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Tu mettras aussi ma coupe, la coupe d’argent, à l’entrée du sac du plus jeune, avec l’argent de son blé. L’intendant fit ce que Joseph lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Le matin, dès qu’il fit jour, on renvoya ces gens avec leurs ânes. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ils étaient sortis de la ville, et ils n’en étaient guère éloignés, lorsque Joseph dit à son intendant: Lève-toi, poursuis ces gens; et, quand tu les auras atteints, tu leur diras: Pourquoi avez-vous rendu le mal pour le bien? ");
INSERT INTO fraLSG_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","N’avez-vous pas la coupe dans laquelle boit mon seigneur, et dont il se sert pour deviner? Vous avez mal fait d’agir ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","L’intendant les atteignit, et leur dit ces mêmes paroles. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ils lui répondirent: Pourquoi mon seigneur parle-t-il de la sorte? Dieu préserve tes serviteurs d’avoir commis une telle action! ");
INSERT INTO fraLSG_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Voici, nous t’avons rapporté du pays de Canaan l’argent que nous avons trouvé à l’entrée de nos sacs; comment aurions-nous dérobé de l’argent ou de l’or dans la maison de ton seigneur? ");
INSERT INTO fraLSG_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Que celui de tes serviteurs sur qui se trouvera la coupe meure, et que nous soyons nous-mêmes esclaves de mon seigneur! ");
INSERT INTO fraLSG_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Il dit: Qu’il en soit donc selon vos paroles! Celui sur qui se trouvera la coupe sera mon esclave; et vous, vous serez innocents. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Aussitôt, chacun descendit son sac à terre, et chacun ouvrit son sac. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","L’intendant les fouilla, commençant par le plus âgé et finissant par le plus jeune; et la coupe fut trouvée dans le sac de Benjamin. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ils déchirèrent leurs vêtements, chacun rechargea son âne, et ils retournèrent à la ville. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Juda et ses frères arrivèrent à la maison de Joseph, où il était encore, et ils se prosternèrent en terre devant lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph leur dit: Quelle action avez-vous faite? Ne savez-vous pas qu’un homme comme moi a le pouvoir de deviner? ");
INSERT INTO fraLSG_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda répondit: Que dirons-nous à mon seigneur? Comment parlerons-nous? Comment nous justifierons-nous? Dieu a trouvé l’iniquité de tes serviteurs. Nous voici esclaves de mon seigneur, nous, et celui sur qui s’est trouvée la coupe. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Et Joseph dit: Dieu me garde de faire cela! L’homme sur qui la coupe a été trouvée sera mon esclave; mais vous, remontez en paix vers votre père. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Alors Juda s’approcha de Joseph, et dit: De grâce, mon seigneur, que ton serviteur puisse faire entendre une parole à mon seigneur, et que sa colère ne s’enflamme point contre ton serviteur! Car tu es comme Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mon seigneur a interrogé ses serviteurs, en disant: Avez-vous un père, ou un frère? ");
INSERT INTO fraLSG_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nous avons répondu: Nous avons un vieux père, et un jeune frère, enfant de sa vieillesse; cet enfant avait un frère qui est mort, et qui était de la même mère; il reste seul, et son père l’aime. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Tu as dit à tes serviteurs: Faites-le descendre vers moi, et que je le voie de mes propres yeux. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nous avons répondu à mon seigneur: L’enfant ne peut pas quitter son père; s’il le quitte, son père mourra. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Tu as dit à tes serviteurs: Si votre jeune frère ne descend pas avec vous, vous ne reverrez pas ma face. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Lorsque nous sommes remontés auprès de ton serviteur, mon père, nous lui avons rapporté les paroles de mon seigneur. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Notre père a dit: Retournez, achetez-nous un peu de vivres. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nous avons répondu: Nous ne pouvons pas descendre; mais, si notre jeune frère est avec nous, nous descendrons, car nous ne pouvons pas voir la face de cet homme, à moins que notre jeune frère ne soit avec nous. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Ton serviteur, notre père, nous a dit: Vous savez que ma femme m’a enfanté deux fils. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","L’un étant sorti de chez moi, je pense qu’il a été sans doute déchiré, car je ne l’ai pas revu jusqu’à présent. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Si vous me prenez encore celui-ci, et qu’il lui arrive un malheur, vous ferez descendre mes cheveux blancs avec douleur dans le séjour des morts. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Maintenant, si je retourne auprès de ton serviteur, mon père, sans avoir avec nous l’enfant à l’âme duquel son âme est attachée, ");
INSERT INTO fraLSG_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","il mourra, en voyant que l’enfant n’y est pas; et tes serviteurs feront descendre avec douleur dans le séjour des morts les cheveux blancs de ton serviteur, notre père. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Car ton serviteur a répondu pour l’enfant, en disant à mon père: Si je ne le ramène pas auprès de toi, je serai pour toujours coupable envers mon père. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Permets donc, je te prie, à ton serviteur de rester à la place de l’enfant, comme esclave de mon seigneur; et que l’enfant remonte avec ses frères. ");
INSERT INTO fraLSG_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Comment pourrai-je remonter vers mon père, si l’enfant n’est pas avec moi? Ah! Que je ne voie point l’affliction de mon père! ");
INSERT INTO fraLSG_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Joseph ne pouvait plus se contenir devant tous ceux qui l’entouraient. Il s’écria: Faites sortir tout le monde. Et il ne resta personne avec Joseph, quand il se fit connaître à ses frères. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Il éleva la voix, en pleurant. Les Égyptiens l’entendirent, et la maison de Pharaon l’entendit. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph dit à ses frères: Je suis Joseph! Mon père vit-il encore? Mais ses frères ne purent lui répondre, car ils étaient troublés en sa présence. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Joseph dit à ses frères: Approchez-vous de moi. Et ils s’approchèrent. Il dit: Je suis Joseph, votre frère, que vous avez vendu pour être mené en Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Maintenant, ne vous affligez pas, et ne soyez pas fâchés de m’avoir vendu pour être conduit ici, car c’est pour vous sauver la vie que Dieu m’a envoyé devant vous. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Voilà deux ans que la famine est dans le pays; et pendant cinq années encore, il n’y aura ni labour, ni moisson. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Dieu m’a envoyé devant vous pour vous faire subsister dans le pays, et pour vous faire vivre par une grande délivrance. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ce n’est donc pas vous qui m’avez envoyé ici, mais c’est Dieu; il m’a établi père de Pharaon, maître de toute sa maison, et gouverneur de tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Hâtez-vous de remonter auprès de mon père, et vous lui direz: Ainsi a parlé ton fils Joseph: Dieu m’a établi seigneur de toute l’Égypte; descends vers moi, ne tarde pas! ");
INSERT INTO fraLSG_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tu habiteras dans le pays de Gosen, et tu seras près de moi, toi, tes fils, et les fils de tes fils, tes brebis et tes bœufs, et tout ce qui est à toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Là, je te nourrirai, car il y aura encore cinq années de famine; et ainsi tu ne périras point, toi, ta maison, et tout ce qui est à toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Vous voyez de vos yeux, et mon frère Benjamin voit de ses yeux que c’est moi-même qui vous parle. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Racontez à mon père toute ma gloire en Égypte, et tout ce que vous avez vu; et vous ferez descendre ici mon père au plus tôt. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Il se jeta au cou de Benjamin, son frère, et pleura; et Benjamin pleura sur son cou. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Il embrassa aussi tous ses frères, en pleurant. Après quoi, ses frères s’entretinrent avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Le bruit se répandit dans la maison de Pharaon que les frères de Joseph étaient arrivés: ce qui fut agréable à Pharaon et à ses serviteurs. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaon dit à Joseph: Dis à tes frères: Faites ceci. Chargez vos bêtes, et partez pour le pays de Canaan; ");
INSERT INTO fraLSG_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","prenez votre père et vos familles, et venez auprès de moi. Je vous donnerai ce qu’il y a de meilleur au pays d’Égypte, et vous mangerez la graisse du pays. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tu as ordre de leur dire: Faites ceci. Prenez dans le pays d’Égypte des chars pour vos enfants et pour vos femmes; amenez votre père, et venez. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ne regrettez point ce que vous laisserez, car ce qu’il y a de meilleur dans tout le pays d’Égypte sera pour vous. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Les fils d’Israël firent ainsi. Joseph leur donna des chars, selon l’ordre de Pharaon; il leur donna aussi des provisions pour la route. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Il leur donna à tous des vêtements de rechange, et il donna à Benjamin trois cents sicles d’argent et cinq vêtements de rechange. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Il envoya à son père dix ânes chargés de ce qu’il y avait de meilleur en Égypte, et dix ânesses chargées de blé, de pain et de vivres, pour son père pendant le voyage. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Puis il congédia ses frères, qui partirent; et il leur dit: Ne vous querellez pas en chemin. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ils remontèrent de l’Égypte, et ils arrivèrent dans le pays de Canaan, auprès de Jacob, leur père. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ils lui dirent: Joseph vit encore, et même c’est lui qui gouverne tout le pays d’Égypte. Mais le cœur de Jacob resta froid, parce qu’il ne les croyait pas. ");
INSERT INTO fraLSG_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ils lui rapportèrent toutes les paroles que Joseph leur avait dites. Il vit les chars que Joseph avait envoyés pour le transporter. C’est alors que l’esprit de Jacob, leur père, se ranima; ");
INSERT INTO fraLSG_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","et Israël dit: C’est assez! Joseph, mon fils, vit encore! J’irai, et je le verrai avant que je meure. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israël partit, avec tout ce qui lui appartenait. Il arriva à Beer-Schéba, et il offrit des sacrifices au Dieu de son père Isaac. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Dieu parla à Israël dans une vision pendant la nuit, et il dit: Jacob! Jacob! Israël répondit: Me voici! ");
INSERT INTO fraLSG_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Et Dieu dit: Je suis le Dieu, le Dieu de ton père. Ne crains point de descendre en Égypte, car là je te ferai devenir une grande nation. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Moi-même je descendrai avec toi en Égypte, et moi-même je t’en ferai remonter; et Joseph te fermera les yeux. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Jacob quitta Beer-Schéba; et les fils d’Israël mirent Jacob, leur père, avec leurs enfants et leurs femmes, sur les chars que Pharaon avait envoyés pour les transporter. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ils prirent aussi leurs troupeaux et les biens qu’ils avaient acquis dans le pays de Canaan. Et Jacob se rendit en Égypte, avec toute sa famille. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Il emmena avec lui en Égypte ses fils et les fils de ses fils, ses filles et les filles de ses fils, et toute sa famille. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Voici les noms des fils d’Israël, qui vinrent en Égypte. Jacob et ses fils. Premier-né de Jacob: Ruben. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Fils de Ruben: Hénoc, Pallu, Hetsron et Carmi. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Fils de Siméon: Jemuel, Jamin, Ohad, Jakin et Tsochar; et Saul, fils de la Cananéenne. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Fils de Lévi: Guerschon, Kehath et Merari. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Fils de Juda: Er, Onan, Schéla, Pérets et Zarach; mais Er et Onan moururent au pays de Canaan. Les fils de Pérets furent Hetsron et Hamul. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Fils d’Issacar: Thola, Puva, Job et Schimron. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Fils de Zabulon: Séred, Élon et Jahleel. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ce sont là les fils que Léa enfanta à Jacob à Paddan-Aram, avec sa fille Dina. Ses fils et ses filles formaient en tout trente-trois personnes. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Fils de Gad: Tsiphjon, Haggi, Schuni, Etsbon, Éri, Arodi et Areéli. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Fils d’Aser: Jimna, Jischva, Jischvi et Beria; et Sérach, leur sœur. Et les fils de Beria: Héber et Malkiel. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ce sont là les fils de Zilpa, que Laban avait donnée à Léa, sa fille; et elle les enfanta à Jacob. En tout, seize personnes. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Fils de Rachel, femme de Jacob: Joseph et Benjamin. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Il naquit à Joseph, au pays d’Égypte, Manassé et Éphraïm, que lui enfanta Asnath, fille de Poti-Phéra, prêtre d’On. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Fils de Benjamin: Béla, Béker, Aschbel, Guéra, Naaman, Éhi, Rosch, Muppim, Huppim et Ard. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ce sont là les fils de Rachel, qui naquirent à Jacob. En tout, quatorze personnes. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Fils de Dan: Huschim. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Fils de Nephthali: Jathtseel, Guni, Jetser et Schillem. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ce sont là les fils de Bilha, que Laban avait donnée à Rachel, sa fille; et elle les enfanta à Jacob. En tout, sept personnes. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Les personnes qui vinrent avec Jacob en Égypte, et qui étaient issues de lui, étaient au nombre de soixante-six en tout, sans compter les femmes des fils de Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Et Joseph avait deux fils qui lui étaient nés en Égypte. Le total des personnes de la famille de Jacob qui vinrent en Égypte était de soixante-dix. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob envoya Juda devant lui vers Joseph, pour l’informer qu’il se rendait en Gosen. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph attela son char et y monta, pour aller en Gosen, à la rencontre d’Israël, son père. Dès qu’il le vit, il se jeta à son cou, et pleura longtemps sur son cou. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israël dit à Joseph: Que je meure maintenant, puisque j’ai vu ton visage et que tu vis encore! ");
INSERT INTO fraLSG_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Joseph dit à ses frères et à la famille de son père: Je vais avertir Pharaon, et je lui dirai: Mes frères et la famille de mon père, qui étaient au pays de Canaan, sont arrivés auprès de moi. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ces hommes sont bergers, car ils élèvent des troupeaux; ils ont amené leurs brebis et leurs bœufs, et tout ce qui leur appartient. ");
INSERT INTO fraLSG_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Et quand Pharaon vous appellera, et dira: ");
INSERT INTO fraLSG_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Quelle est votre occupation? Vous répondrez: Tes serviteurs ont élevé des troupeaux, depuis notre jeunesse jusqu’à présent, nous et nos pères. De cette manière, vous habiterez dans le pays de Gosen, car tous les bergers sont en abomination aux Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph alla avertir Pharaon, et lui dit: Mes frères et mon père sont arrivés du pays de Canaan, avec leurs brebis et leurs bœufs, et tout ce qui leur appartient; et les voici dans le pays de Gosen. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Il prit cinq de ses frères, et les présenta à Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Pharaon leur dit: Quelle est votre occupation? Ils répondirent à Pharaon: Tes serviteurs sont bergers, comme l’étaient nos pères. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ils dirent encore à Pharaon: Nous sommes venus pour séjourner dans le pays, parce qu’il n’y a plus de pâturage pour les brebis de tes serviteurs, car la famine s’appesantit sur le pays de Canaan; permets donc à tes serviteurs d’habiter au pays de Gosen. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharaon dit à Joseph: Ton père et tes frères sont venus auprès de toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Le pays d’Égypte est devant toi; établis ton père et tes frères dans la meilleure partie du pays. Qu’ils habitent dans le pays de Gosen; et, si tu trouves parmi eux des hommes capables, mets-les à la tête de mes troupeaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Joseph fit venir Jacob, son père, et le présenta à Pharaon. Et Jacob bénit Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Pharaon dit à Jacob: Quel est le nombre de jours des années de ta vie? ");
INSERT INTO fraLSG_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob répondit à Pharaon: Les jours des années de mon pèlerinage sont de cent trente ans. Les jours des années de ma vie ont été peu nombreux et mauvais, et ils n’ont point atteint les jours des années de la vie de mes pères durant leur pèlerinage. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacob bénit encore Pharaon, et se retira de devant Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joseph établit son père et ses frères, et leur donna une propriété dans le pays d’Égypte, dans la meilleure partie du pays, dans la contrée de Ramsès, comme Pharaon l’avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Joseph fournit du pain à son père et à ses frères, et à toute la famille de son père, selon le nombre des enfants. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Il n’y avait plus de pain dans tout le pays, car la famine était très grande; le pays d’Égypte et le pays de Canaan languissaient, à cause de la famine. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph recueillit tout l’argent qui se trouvait dans le pays d’Égypte et dans le pays de Canaan, contre le blé qu’on achetait; et il fit entrer cet argent dans la maison de Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Quand l’argent du pays d’Égypte et du pays de Canaan fut épuisé, tous les Égyptiens vinrent à Joseph, en disant: Donne-nous du pain! Pourquoi mourrions-nous en ta présence? Car l’argent manque. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph dit: Donnez vos troupeaux, et je vous donnerai du pain contre vos troupeaux, si l’argent manque. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ils amenèrent leurs troupeaux à Joseph, et Joseph leur donna du pain contre les chevaux, contre les troupeaux de brebis et de bœufs, et contre les ânes. Il leur fournit ainsi du pain cette année-là contre tous leurs troupeaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Lorsque cette année fut écoulée, ils vinrent à Joseph l’année suivante, et lui dirent: Nous ne cacherons point à mon seigneur que l’argent est épuisé, et que les troupeaux de bétail ont été amenés à mon seigneur; il ne reste devant mon seigneur que nos corps et nos terres. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Pourquoi mourrions-nous sous tes yeux, nous et nos terres? Achète-nous avec nos terres contre du pain, et nous appartiendrons à mon seigneur, nous et nos terres. Donne-nous de quoi semer, afin que nous vivions et que nous ne mourions pas, et que nos terres ne soient pas désolées. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Joseph acheta toutes les terres de l’Égypte pour Pharaon; car les Égyptiens vendirent chacun leur champ, parce que la famine les pressait. Et le pays devint la propriété de Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Il fit passer le peuple dans les villes, d’un bout à l’autre des frontières de l’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Seulement, il n’acheta point les terres des prêtres, parce qu’il y avait une loi de Pharaon en faveur des prêtres, qui vivaient du revenu que leur assurait Pharaon: c’est pourquoi ils ne vendirent point leurs terres. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph dit au peuple: Je vous ai achetés aujourd’hui avec vos terres, pour Pharaon; voici pour vous de la semence, et vous pourrez ensemencer le sol. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","A la récolte, vous donnerez un cinquième à Pharaon, et vous aurez les quatre autres parties, pour ensemencer les champs, et pour vous nourrir avec vos enfants et ceux qui sont dans vos maisons. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ils dirent: Tu nous sauves la vie! Que nous trouvions grâce aux yeux de mon seigneur, et nous serons esclaves de Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Joseph fit de cela une loi, qui a subsisté jusqu’à ce jour, et d’après laquelle un cinquième du revenu des terres de l’Égypte appartient à Pharaon; il n’y a que les terres des prêtres qui ne soient point à Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israël habita dans le pays d’Égypte, dans le pays de Gosen. Ils eurent des possessions, ils furent féconds et multiplièrent beaucoup. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Jacob vécut dix-sept ans dans le pays d’Égypte; et les jours des années de la vie de Jacob furent de cent quarante-sept ans. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Lorsqu’Israël approcha du moment de sa mort, il appela son fils Joseph, et lui dit: Si j’ai trouvé grâce à tes yeux, mets, je te prie, ta main sous ma cuisse, et use envers moi de bonté et de fidélité: ne m’enterre pas en Égypte! ");
INSERT INTO fraLSG_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Quand je serai couché avec mes pères, tu me transporteras hors de l’Égypte, et tu m’enterreras dans leur sépulcre. Joseph répondit: Je ferai selon ta parole. ");
INSERT INTO fraLSG_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Jacob dit: Jure-le-moi. Et Joseph le lui jura. Puis Israël se prosterna sur le chevet de son lit. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Après ces choses, l’on vint dire à Joseph: Voici, ton père est malade. Et il prit avec lui ses deux fils, Manassé et Éphraïm. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","On avertit Jacob, et on lui dit: Voici ton fils Joseph qui vient vers toi. Et Israël rassembla ses forces, et s’assit sur son lit. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Jacob dit à Joseph: Le Dieu tout-puissant m’est apparu à Luz, dans le pays de Canaan, et il m’a béni. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Il m’a dit: Je te rendrai fécond, je te multiplierai, et je ferai de toi une multitude de peuples; je donnerai ce pays à ta postérité après toi, pour qu’elle le possède à toujours. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Maintenant, les deux fils qui te sont nés au pays d’Égypte, avant mon arrivée vers toi en Égypte, seront à moi; Éphraïm et Manassé seront à moi, comme Ruben et Siméon. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Mais les enfants que tu as engendrés après eux seront à toi; ils seront appelés du nom de leurs frères dans leur héritage. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","A mon retour de Paddan, Rachel mourut en route auprès de moi, dans le pays de Canaan, à quelque distance d’Éphrata; et c’est là que je l’ai enterrée, sur le chemin d’Éphrata, qui est Bethléhem. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israël regarda les fils de Joseph, et dit: Qui sont ceux-ci? ");
INSERT INTO fraLSG_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph répondit à son père: Ce sont mes fils, que Dieu m’a donnés ici. Israël dit: Fais-les, je te prie, approcher de moi, pour que je les bénisse. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Les yeux d’Israël étaient appesantis par la vieillesse; il ne pouvait plus voir. Joseph les fit approcher de lui; et Israël leur donna un baiser, et les embrassa. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israël dit à Joseph: Je ne pensais pas revoir ton visage, et voici que Dieu me fait voir même ta postérité. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Joseph les retira des genoux de son père, et il se prosterna en terre devant lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Puis Joseph les prit tous deux, Éphraïm de sa main droite à la gauche d’Israël, et Manassé de sa main gauche à la droite d’Israël, et il les fit approcher de lui. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israël étendit sa main droite et la posa sur la tête d’Éphraïm qui était le plus jeune, et il posa sa main gauche sur la tête de Manassé: ce fut avec intention qu’il posa ses mains ainsi, car Manassé était le premier-né. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Il bénit Joseph, et dit: Que le Dieu en présence duquel ont marché mes pères, Abraham et Isaac, que le Dieu qui m’a conduit depuis que j’existe jusqu’à ce jour, ");
INSERT INTO fraLSG_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","que l’ange qui m’a délivré de tout mal, bénisse ces enfants! Qu’ils soient appelés de mon nom et du nom de mes pères, Abraham et Isaac, et qu’ils multiplient en abondance au milieu du pays! ");
INSERT INTO fraLSG_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Joseph vit avec déplaisir que son père posait sa main droite sur la tête d’Éphraïm; il saisit la main de son père, pour la détourner de dessus la tête d’Éphraïm, et la diriger sur celle de Manassé. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Et Joseph dit à son père: Pas ainsi, mon père, car celui-ci est le premier-né; pose ta main droite sur sa tête. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Son père refusa, et dit: Je le sais, mon fils, je le sais; lui aussi deviendra un peuple, lui aussi sera grand; mais son frère cadet sera plus grand que lui, et sa postérité deviendra une multitude de nations. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Il les bénit ce jour-là, et dit: C’est par toi qu’Israël bénira, en disant: Que Dieu te traite comme Éphraïm et comme Manassé! Et il mit Éphraïm avant Manassé. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israël dit à Joseph: Voici, je vais mourir! Mais Dieu sera avec vous, et il vous fera retourner dans le pays de vos pères. ");
INSERT INTO fraLSG_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Je te donne, de plus qu’à tes frères, une part que j’ai prise de la main des Amoréens avec mon épée et avec mon arc. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Jacob appela ses fils, et dit: Assemblez-vous, et je vous annoncerai ce qui vous arrivera dans la suite des temps. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Rassemblez-vous, et écoutez, fils de Jacob! Écoutez Israël, votre père! ");
INSERT INTO fraLSG_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ruben, toi, mon premier-né, Ma force et les prémices de ma vigueur, Supérieur en dignité et supérieur en puissance, ");
INSERT INTO fraLSG_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Impétueux comme les eaux, tu n’auras pas la prééminence! Car tu es monté sur la couche de ton père, Tu as souillé ma couche en y montant. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Siméon et Lévi sont frères; Leurs glaives sont des instruments de violence. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Que mon âme n’entre point dans leur conciliabule, Que mon esprit ne s’unisse point à leur assemblée! Car, dans leur colère, ils ont tué des hommes, Et, dans leur méchanceté, ils ont coupé les jarrets des taureaux. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Maudite soit leur colère, car elle est violente, Et leur fureur, car elle est cruelle! Je les séparerai dans Jacob, Et je les disperserai dans Israël. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Juda, tu recevras les hommages de tes frères; Ta main sera sur la nuque de tes ennemis. Les fils de ton père se prosterneront devant toi. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Juda est un jeune lion. Tu reviens du carnage, mon fils! Il ploie les genoux, il se couche comme un lion, Comme une lionne: qui le fera lever? ");
INSERT INTO fraLSG_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Le sceptre ne s’éloignera point de Juda, Ni le bâton souverain d’entre ses pieds, Jusqu’à ce que vienne le Schilo, Et que les peuples lui obéissent. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Il attache à la vigne son âne, Et au meilleur cep le petit de son ânesse; Il lave dans le vin son vêtement, Et dans le sang des raisins son manteau. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Il a les yeux rouges de vin, Et les dents blanches de lait. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zabulon habitera sur la côte des mers, Il sera sur la côte des navires, Et sa limite s’étendra du côté de Sidon. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issacar est un âne robuste, Qui se couche dans les étables. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Il voit que le lieu où il repose est agréable, Et que la contrée est magnifique; Et il courbe son épaule sous le fardeau, Il s’assujettit à un tribut. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dan jugera son peuple, Comme l’une des tribus d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan sera un serpent sur le chemin, Une vipère sur le sentier, Mordant les talons du cheval, Pour que le cavalier tombe à la renverse. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","J’espère en ton secours, ô Éternel! ");
INSERT INTO fraLSG_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Gad sera assailli par des bandes armées, Mais il les assaillira et les poursuivra. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Aser produit une nourriture excellente; Il fournira les mets délicats des rois. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nephthali est une biche en liberté; Il profère de belles paroles. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Joseph est le rejeton d’un arbre fertile, Le rejeton d’un arbre fertile près d’une source; Les branches s’élèvent au-dessus de la muraille. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ils l’ont provoqué, ils ont lancé des traits; Les archers l’ont poursuivi de leur haine. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Mais son arc est demeuré ferme, Et ses mains ont été fortifiées Par les mains du Puissant de Jacob: Il est ainsi devenu le berger, le rocher d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","C’est l’œuvre du Dieu de ton père, qui t’aidera; C’est l’œuvre du Tout-Puissant, qui te bénira Des bénédictions des cieux en haut, Des bénédictions des eaux en bas, Des bénédictions des mamelles et du sein maternel. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Les bénédictions de ton père s’élèvent Au-dessus des bénédictions de mes pères Jusqu’à la cime des collines éternelles: Qu’elles soient sur la tête de Joseph, Sur le sommet de la tête du prince de ses frères! ");
INSERT INTO fraLSG_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benjamin est un loup qui déchire; Le matin, il dévore la proie, Et le soir, il partage le butin. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ce sont là tous ceux qui forment les douze tribus d’Israël. Et c’est là ce que leur dit leur père, en les bénissant. Il les bénit, chacun selon sa bénédiction. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Puis il leur donna cet ordre: Je vais être recueilli auprès de mon peuple; enterrez-moi avec mes pères, dans la caverne qui est au champ d’Éphron, le Héthien, ");
INSERT INTO fraLSG_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","dans la caverne du champ de Macpéla, vis-à-vis de Mamré, dans le pays de Canaan. C’est le champ qu’Abraham a acheté d’Éphron, le Héthien, comme propriété sépulcrale. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Là on a enterré Abraham et Sara, sa femme; là on a enterré Isaac et Rebecca, sa femme; et là j’ai enterré Léa. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Le champ et la caverne qui s’y trouve ont été achetés des fils de Heth. ");
INSERT INTO fraLSG_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Lorsque Jacob eut achevé de donner ses ordres à ses fils, il retira ses pieds dans le lit, il expira, et fut recueilli auprès de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph se jeta sur le visage de son père, pleura sur lui, et le baisa. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Il ordonna aux médecins à son service d’embaumer son père, et les médecins embaumèrent Israël. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Quarante jours s’écoulèrent ainsi, et furent employés à l’embaumer. Et les Égyptiens le pleurèrent soixante-dix jours. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Quand les jours du deuil furent passés, Joseph s’adressa aux gens de la maison de Pharaon, et leur dit: Si j’ai trouvé grâce à vos yeux, rapportez, je vous prie, à Pharaon ce que je vous dis. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Mon père m’a fait jurer, en disant: Voici, je vais mourir! Tu m’enterreras dans le sépulcre que je me suis acheté au pays de Canaan. Je voudrais donc y monter, pour enterrer mon père; et je reviendrai. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaon répondit: Monte, et enterre ton père, comme il te l’a fait jurer. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Joseph monta, pour enterrer son père. Avec lui montèrent tous les serviteurs de Pharaon, anciens de sa maison, tous les anciens du pays d’Égypte, ");
INSERT INTO fraLSG_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","toute la maison de Joseph, ses frères, et la maison de son père: on ne laissa dans le pays de Gosen que les enfants, les brebis et les bœufs. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Il y avait encore avec Joseph des chars et des cavaliers, en sorte que le cortège était très nombreux. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Arrivés à l’aire d’Athad, qui est audelà du Jourdain, ils firent entendre de grandes et profondes lamentations; et Joseph fit en l’honneur de son père un deuil de sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Les habitants du pays, les Cananéens, furent témoins de ce deuil dans l’aire d’Athad, et ils dirent: Voilà un grand deuil parmi les Égyptiens! C’est pourquoi l’on a donné le nom d’Abel-Mitsraïm à cette aire qui est au-delà du Jourdain. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","C’est ainsi que les fils de Jacob exécutèrent les ordres de leur père. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ils le transportèrent au pays de Canaan, et l’enterrèrent dans la caverne du champ de Macpéla, qu’Abraham avait achetée d’Éphron, le Héthien, comme propriété sépulcrale, et qui est vis-à-vis de Mamré. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Joseph, après avoir enterré son père, retourna en Égypte, avec ses frères et tous ceux qui étaient montés avec lui pour enterrer son père. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Quand les frères de Joseph virent que leur père était mort, ils dirent: Si Joseph nous prenait en haine, et nous rendait tout le mal que nous lui avons fait! ");
INSERT INTO fraLSG_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Et ils firent dire à Joseph: Ton père a donné cet ordre avant de mourir: ");
INSERT INTO fraLSG_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Vous parlerez ainsi à Joseph: Oh! Pardonne le crime de tes frères et leur péché, car ils t’ont fait du mal! Pardonne maintenant le péché des serviteurs du Dieu de ton père! Joseph pleura, en entendant ces paroles. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ses frères vinrent eux-mêmes se prosterner devant lui, et ils dirent: Nous sommes tes serviteurs. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph leur dit: Soyez sans crainte; car suis-je à la place de Dieu? ");
INSERT INTO fraLSG_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Vous aviez médité de me faire du mal: Dieu l’a changé en bien, pour accomplir ce qui arrive aujourd’hui, pour sauver la vie à un peuple nombreux. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Soyez donc sans crainte; je vous entretiendrai, vous et vos enfants. Et il les consola, en parlant à leur cœur. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Joseph demeura en Égypte, lui et la maison de son père. Il vécut cent dix ans. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Joseph vit les fils d’Éphraïm jusqu’à la troisième génération; et les fils de Makir, fils de Manassé, naquirent sur ses genoux. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Joseph dit à ses frères: Je vais mourir! Mais Dieu vous visitera, et il vous fera remonter de ce pays-ci dans le pays qu’il a juré de donner à Abraham, à Isaac et à Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Joseph fit jurer les fils d’Israël, en disant: Dieu vous visitera; et vous ferez remonter mes os loin d’ici. ");
INSERT INTO fraLSG_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Joseph mourut, âgé de cent dix ans. On l’embauma, et on le mit dans un cercueil en Égypte.");
INSERT INTO fraLSG_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Voici les noms des fils d’Israël, venus en Égypte avec Jacob et la famille de chacun d’eux: ");
INSERT INTO fraLSG_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Siméon, Lévi, Juda, ");
INSERT INTO fraLSG_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issacar, Zabulon, Benjamin, ");
INSERT INTO fraLSG_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Nephthali, Gad et Aser. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Les personnes issues de Jacob étaient au nombre de soixante-dix en tout. Joseph était alors en Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Joseph mourut, ainsi que tous ses frères et toute cette génération-là. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Les enfants d’Israël furent féconds et multiplièrent, ils s’accrurent et devinrent de plus en plus puissants. Et le pays en fut rempli. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Il s’éleva sur l’Égypte un nouveau roi, qui n’avait point connu Joseph. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Il dit à son peuple: Voilà les enfants d’Israël qui forment un peuple plus nombreux et plus puissant que nous. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Allons! Montrons-nous habiles à son égard; empêchons qu’il ne s’accroisse, et que, s’il survient une guerre, il ne se joigne à nos ennemis, pour nous combattre et sortir ensuite du pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Et l’on établit sur lui des chefs de corvées, afin de l’accabler de travaux pénibles. C’est ainsi qu’il bâtit les villes de Pithom et de Ramsès, pour servir de magasins à Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mais plus on l’accablait, plus il multipliait et s’accroissait; et l’on prit en aversion les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Alors les Égyptiens réduisirent les enfants d’Israël à une dure servitude. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ils leur rendirent la vie amère par de rudes travaux en argile et en briques, et par tous les ouvrages des champs: et c’était avec cruauté qu’ils leur imposaient toutes ces charges. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Le roi d’Égypte parla aussi aux sages-femmes des Hébreux, nommées l’une Schiphra, et l’autre Pua. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Il leur dit: Quand vous accoucherez les femmes des Hébreux et que vous les verrez sur les sièges, si c’est un garçon, faites-le mourir; si c’est une fille, laissez-la vivre. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Mais les sages-femmes craignirent Dieu, et ne firent point ce que leur avait dit le roi d’Égypte; elles laissèrent vivre les enfants. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Le roi d’Égypte appela les sages-femmes, et leur dit: Pourquoi avez-vous agi ainsi, et avez-vous laissé vivre les enfants? ");
INSERT INTO fraLSG_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Les sages-femmes répondirent à Pharaon: C’est que les femmes des Hébreux ne sont pas comme les Égyptiennes; elles sont vigoureuses et elles accouchent avant l’arrivée de la sage-femme. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Dieu fit du bien aux sages-femmes; et le peuple multiplia et devint très nombreux. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Parce que les sages-femmes avaient eu la crainte de Dieu, Dieu fit prospérer leurs maisons. ");
INSERT INTO fraLSG_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Alors Pharaon donna cet ordre à tout son peuple: Vous jetterez dans le fleuve tout garçon qui naîtra, et vous laisserez vivre toutes les filles. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Un homme de la maison de Lévi avait pris pour femme une fille de Lévi. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Cette femme devint enceinte et enfanta un fils. Elle vit qu’il était beau, et elle le cacha pendant trois mois. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ne pouvant plus le cacher, elle prit une caisse de jonc, qu’elle enduisit de bitume et de poix; elle y mit l’enfant, et le déposa parmi les roseaux, sur le bord du fleuve. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","La sœur de l’enfant se tint à quelque distance, pour savoir ce qui lui arriverait. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","La fille de Pharaon descendit au fleuve pour se baigner, et ses compagnes se promenèrent le long du fleuve. Elle aperçut la caisse au milieu des roseaux, et elle envoya sa servante pour la prendre. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Elle l’ouvrit, et vit l’enfant: c’était un petit garçon qui pleurait. Elle en eut pitié, et elle dit: C’est un enfant des Hébreux! ");
INSERT INTO fraLSG_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Alors la sœur de l’enfant dit à la fille de Pharaon: Veux-tu que j’aille te chercher une nourrice parmi les femmes des Hébreux, pour allaiter cet enfant? ");
INSERT INTO fraLSG_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Va, lui répondit la fille de Pharaon. Et la jeune fille alla chercher la mère de l’enfant. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","La fille de Pharaon lui dit: Emporte cet enfant, et allaite-le-moi; je te donnerai ton salaire. La femme prit l’enfant, et l’allaita. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Quand il eut grandi, elle l’amena à la fille de Pharaon, et il fut pour elle comme un fils. Elle lui donna le nom de Moïse, car, dit-elle, je l’ai retiré des eaux. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","En ce temps-là, Moïse, devenu grand, se rendit vers ses frères, et fut témoin de leurs pénibles travaux. Il vit un Égyptien qui frappait un Hébreu d’entre ses frères. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Il regarda de côté et d’autre, et, voyant qu’il n’y avait personne, il tua l’Égyptien, et le cacha dans le sable. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Il sortit le jour suivant; et voici, deux Hébreux se querellaient. Il dit à celui qui avait tort: Pourquoi frappes-tu ton prochain? ");
INSERT INTO fraLSG_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Et cet homme répondit: Qui t’a établi chef et juge sur nous? Penses-tu me tuer, comme tu as tué l’Égyptien? Moïse eut peur, et dit: Certainement la chose est connue. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Pharaon apprit ce qui s’était passé, et il cherchait à faire mourir Moïse. Mais Moïse s’enfuit de devant Pharaon, et il se retira dans le pays de Madian, où il s’arrêta près d’un puits. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Le sacrificateur de Madian avait sept filles. Elles vinrent puiser de l’eau, et elles remplirent les auges pour abreuver le troupeau de leur père. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Les bergers arrivèrent, et les chassèrent. Alors Moïse se leva, prit leur défense, et fit boire leur troupeau. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Quand elles furent de retour auprès de Réuel, leur père, il dit: Pourquoi revenez-vous si tôt aujourd’hui? ");
INSERT INTO fraLSG_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Elles répondirent: Un Égyptien nous a délivrées de la main des bergers, et même il nous a puisé de l’eau, et a fait boire le troupeau. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Et il dit à ses filles: Où est-il? Pourquoi avez-vous laissé cet homme? Appelez-le, pour qu’il prenne quelque nourriture. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Moïse se décida à demeurer chez cet homme, qui lui donna pour femme Séphora, sa fille. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Elle enfanta un fils, qu’il appela du nom de Guerschom, car, dit-il, j’habite un pays étranger. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Longtemps après, le roi d’Égypte mourut, et les enfants d’Israël gémissaient encore sous la servitude, et poussaient des cris. Ces cris, que leur arrachait la servitude, montèrent jusqu’à Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Dieu entendit leurs gémissements, et se souvint de son alliance avec Abraham, Isaac et Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Dieu regarda les enfants d’Israël, et il en eut compassion. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moïse faisait paître le troupeau de Jéthro, son beau-père, sacrificateur de Madian; et il mena le troupeau derrière le désert, et vint à la montagne de Dieu, à Horeb. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","L’ange de l’Éternel lui apparut dans une flamme de feu, au milieu d’un buisson. Moïse regarda; et voici, le buisson était tout en feu, et le buisson ne se consumait point. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moïse dit: Je veux me détourner pour voir quelle est cette grande vision, et pourquoi le buisson ne se consume point. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","L’Éternel vit qu’il se détournait pour voir; et Dieu l’appela du milieu du buisson, et dit: Moïse! Moïse! Et il répondit: Me voici! ");
INSERT INTO fraLSG_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Dieu dit: N’approche pas d’ici, ôte tes souliers de tes pieds, car le lieu sur lequel tu te tiens est une terre sainte. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Et il ajouta: Je suis le Dieu de ton père, le Dieu d’Abraham, le Dieu d’Isaac et le Dieu de Jacob. Moïse se cacha le visage, car il craignait de regarder Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","L’Éternel dit: J’ai vu la souffrance de mon peuple qui est en Égypte, et j’ai entendu les cris que lui font pousser ses oppresseurs, car je connais ses douleurs. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Je suis descendu pour le délivrer de la main des Égyptiens, et pour le faire monter de ce pays dans un bon et vaste pays, dans un pays où coulent le lait et le miel, dans les lieux qu’habitent les Cananéens, les Héthiens, les Amoréens, les Phéréziens, les Héviens et les Jébusiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Voici, les cris d’Israël sont venus jusqu’à moi, et j’ai vu l’oppression que leur font souffrir les Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Maintenant, va, je t’enverrai auprès de Pharaon, et tu feras sortir d’Égypte mon peuple, les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Moïse dit à Dieu: Qui suis-je, pour aller vers Pharaon, et pour faire sortir d’Égypte les enfants d’Israël? ");
INSERT INTO fraLSG_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Dieu dit: Je serai avec toi; et ceci sera pour toi le signe que c’est moi qui t’envoie: quand tu auras fait sortir d’Égypte le peuple, vous servirez Dieu sur cette montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Moïse dit à Dieu: J’irai donc vers les enfants d’Israël, et je leur dirai: Le Dieu de vos pères m’envoie vers vous. Mais, s’ils me demandent quel est son nom, que leur répondrai-je? ");
INSERT INTO fraLSG_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Dieu dit à Moïse: Je suis celui qui suis. Et il ajouta: C’est ainsi que tu répondras aux enfants d’Israël: Celui qui s’appelle “je suis” m’a envoyé vers vous. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Dieu dit encore à Moïse: Tu parleras ainsi aux enfants d’Israël: L’Éternel, le Dieu de vos pères, le Dieu d’Abraham, le Dieu d’Isaac et le Dieu de Jacob, m’envoie vers vous. Voilà mon nom pour l’éternité, voilà mon nom de génération en génération. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Va, rassemble les anciens d’Israël, et dis-leur: L’Éternel, le Dieu de vos pères, m’est apparu, le Dieu d’Abraham, d’Isaac et de Jacob. Il a dit: Je vous ai vus, et j’ai vu ce qu’on vous fait en Égypte, ");
INSERT INTO fraLSG_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","et j’ai dit: Je vous ferai monter de l’Égypte, où vous souffrez, dans le pays des Cananéens, des Héthiens, des Amoréens, des Phéréziens, des Héviens et des Jébusiens, dans un pays où coulent le lait et le miel. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ils écouteront ta voix; et tu iras, toi et les anciens d’Israël, auprès du roi d’Égypte, et vous lui direz: L’Éternel, le Dieu des Hébreux, nous est apparu. Permets-nous de faire trois journées de marche dans le désert, pour offrir des sacrifices à l’Éternel, notre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Je sais que le roi d’Égypte ne vous laissera point aller, si ce n’est par une main puissante. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","J’étendrai ma main, et je frapperai l’Égypte par toutes sortes de prodiges que je ferai au milieu d’elle. Après quoi, il vous laissera aller. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Je ferai même trouver grâce à ce peuple aux yeux des Égyptiens, et quand vous partirez, vous ne partirez point à vide. ");
INSERT INTO fraLSG_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Chaque femme demandera à sa voisine et à celle qui demeure dans sa maison des vases d’argent, des vases d’or, et des vêtements, que vous mettrez sur vos fils et vos filles. Et vous dépouillerez les Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Moïse répondit, et dit: Voici, ils ne me croiront point, et ils n’écouteront point ma voix. Mais ils diront: L’Éternel ne t’est point apparu. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","L’Éternel lui dit: Qu’y a-t-il dans ta main? Il répondit: Une verge. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","L’Éternel dit: Jette-la par terre. Il la jeta par terre, et elle devint un serpent. Moïse fuyait devant lui. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","L’Éternel dit à Moïse: Étends ta main, et saisis-le par la queue. Il étendit la main et le saisit et le serpent redevint une verge dans sa main. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","C’est là, dit l’Éternel, ce que tu feras, afin qu’ils croient que l’Éternel, le Dieu de leurs pères, t’est apparu, le Dieu d’Abraham, le Dieu d’Isaac et le Dieu de Jacob. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","L’Éternel lui dit encore: Mets ta main dans ton sein. Il mit sa main dans son sein; puis il la retira, et voici, sa main était couverte de lèpre, blanche comme la neige. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","L’Éternel dit: Remets ta main dans ton sein. Il remit sa main dans son sein; puis il la retira de son sein, et voici, elle était redevenue comme sa chair. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","S’ils ne te croient pas, dit l’Éternel, et n’écoutent pas la voix du premier signe, ils croiront à la voix du dernier signe. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","S’ils ne croient pas même à ces deux signes, et n’écoutent pas ta voix, tu prendras de l’eau du fleuve, tu la répandras sur la terre, et l’eau que tu auras prise du fleuve deviendra du sang sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Moïse dit à l’Éternel: Ah! Seigneur, je ne suis pas un homme qui ait la parole facile, et ce n’est ni d’hier ni d’avant-hier, ni même depuis que tu parles à ton serviteur; car j’ai la bouche et la langue embarrassées. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","L’Éternel lui dit: Qui a fait la bouche de l’homme? Et qui rend muet ou sourd, voyant ou aveugle? N’est-ce pas moi, l’Éternel? ");
INSERT INTO fraLSG_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Va donc, je serai avec ta bouche, et je t’enseignerai ce que tu auras à dire. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Moïse dit: Ah! Seigneur, envoie qui tu voudras envoyer. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Alors la colère de l’Éternel s’enflamma contre Moïse, et il dit: N’y a t-il pas ton frère Aaron, le Lévite? Je sais qu’il parlera facilement. Le voici lui-même, qui vient au-devant de toi; et, quand il te verra, il se réjouira dans son cœur. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Tu lui parleras, et tu mettras les paroles dans sa bouche; et moi, je serai avec ta bouche et avec sa bouche, et je vous enseignerai ce que vous aurez à faire. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Il parlera pour toi au peuple; il te servira de bouche, et tu tiendras pour lui la place de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Prends dans ta main cette verge, avec laquelle tu feras les signes. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moïse s’en alla; et de retour auprès de Jéthro, son beau-père, il lui dit: Laisse-moi, je te prie, aller rejoindre mes frères qui sont en Égypte, afin que je voie s’ils sont encore vivants. Jéthro dit à Moïse: Va en paix. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","L’Éternel dit à Moïse, en Madian: Va, retourne en Égypte, car tous ceux qui en voulaient à ta vie sont morts. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moïse prit sa femme et ses fils, les fit monter sur des ânes, et retourna dans le pays d’Égypte. Il prit dans sa main la verge de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","L’Éternel dit à Moïse: En partant pour retourner en Égypte, vois tous les prodiges que je mets en ta main: tu les feras devant Pharaon. Et moi, j’endurcirai son cœur, et il ne laissera point aller le peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Tu diras à Pharaon: Ainsi parle l’Éternel: Israël est mon fils, mon premier-né. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Je te dis: Laisse aller mon fils, pour qu’il me serve; si tu refuses de le laisser aller, voici, je ferai périr ton fils, ton premier-né. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Pendant le voyage, en un lieu où Moïse passa la nuit, l’Éternel l’attaqua et voulut le faire mourir. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Séphora prit une pierre aiguë, coupa le prépuce de son fils, et le jeta aux pieds de Moïse, en disant: Tu es pour moi un époux de sang! ");
INSERT INTO fraLSG_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Et l’Éternel le laissa. C’est alors qu’elle dit: Époux de sang! À cause de la circoncision. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","L’Éternel dit à Aaron: Va dans le désert au-devant de Moïse. Aaron partit; il rencontra Moïse à la montagne de Dieu, et il le baisa. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moïse fit connaître à Aaron toutes les paroles de l’Éternel qui l’avait envoyé, et tous les signes qu’il lui avait ordonné de faire. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Moïse et Aaron poursuivirent leur chemin, et ils assemblèrent tous les anciens des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron rapporta toutes les paroles que l’Éternel avait dites à Moïse, et il exécuta les signes aux yeux du peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Et le peuple crut. Ils apprirent que l’Éternel avait visité les enfants d’Israël, qu’il avait vu leur souffrance; et ils s’inclinèrent et se prosternèrent. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Moïse et Aaron se rendirent ensuite auprès de Pharaon, et lui dirent: Ainsi parle l’Éternel, le Dieu d’Israël: Laisse aller mon peuple, pour qu’il célèbre au désert une fête en mon honneur. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pharaon répondit: Qui est l’Éternel, pour que j’obéisse à sa voix, en laissant aller Israël? Je ne connais point l’Éternel, et je ne laisserai point aller Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ils dirent: Le Dieu des Hébreux nous est apparu. Permets-nous de faire trois journées de marche dans le désert, pour offrir des sacrifices à l’Éternel, afin qu’il ne nous frappe pas de la peste ou de l’épée. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Et le roi d’Égypte leur dit: Moïse et Aaron, pourquoi détournez-vous le peuple de son ouvrage? Allez à vos travaux. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Pharaon dit: Voici, ce peuple est maintenant nombreux dans le pays, et vous lui feriez interrompre ses travaux! ");
INSERT INTO fraLSG_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Et ce jour même, Pharaon donna cet ordre aux inspecteurs du peuple et aux commissaires: ");
INSERT INTO fraLSG_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Vous ne donnerez plus comme auparavant de la paille au peuple pour faire des briques; qu’ils aillent eux-mêmes se ramasser de la paille. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Vous leur imposerez néanmoins la quantité de briques qu’ils faisaient auparavant, vous n’en retrancherez rien; car ce sont des paresseux; voilà pourquoi ils crient, en disant: Allons offrir des sacrifices à notre Dieu! ");
INSERT INTO fraLSG_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Que l’on charge de travail ces gens, qu’ils s’en occupent, et ils ne prendront plus garde à des paroles de mensonge. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Les inspecteurs du peuple et les commissaires vinrent dire au peuple: Ainsi parle Pharaon: Je ne vous donne plus de paille; ");
INSERT INTO fraLSG_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","allez vous-mêmes vous procurer de la paille où vous en trouverez, car l’on ne retranche rien de votre travail. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Le peuple se répandit dans tout le pays d’Égypte, pour ramasser du chaume au lieu de paille. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Les inspecteurs les pressaient, en disant: Achevez votre tâche, jour par jour, comme quand il y avait de la paille. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","On battit même les commissaires des enfants d’Israël, établis sur eux par les inspecteurs de Pharaon: Pourquoi, disait-on, n’avez-vous pas achevé hier et aujourd’hui, comme auparavant, la quantité de briques qui vous avait été fixée? ");
INSERT INTO fraLSG_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Les commissaires des enfants d’Israël allèrent se plaindre à Pharaon, et lui dirent: Pourquoi traites-tu ainsi tes serviteurs? ");
INSERT INTO fraLSG_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","On ne donne point de paille à tes serviteurs, et l’on nous dit: Faites des briques! Et voici, tes serviteurs sont battus, comme si ton peuple était coupable. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pharaon répondit: Vous êtes des paresseux, des paresseux! Voilà pourquoi vous dites: Allons offrir des sacrifices à l’Éternel! ");
INSERT INTO fraLSG_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Maintenant, allez travailler; on ne vous donnera point de paille, et vous livrerez la même quantité de briques. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Les commissaires des enfants d’Israël virent qu’on les rendait malheureux, en disant: Vous ne retrancherez rien de vos briques; chaque jour la tâche du jour. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","En sortant de chez Pharaon, ils rencontrèrent Moïse et Aaron qui les attendaient. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ils leur dirent: Que l’Éternel vous regarde, et qu’il juge! Vous nous avez rendus odieux à Pharaon et à ses serviteurs, vous avez mis une épée dans leurs mains pour nous faire périr. ");
INSERT INTO fraLSG_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Moïse retourna vers l’Éternel, et dit: Seigneur, pourquoi as-tu fait du mal à ce peuple? Pourquoi m’as-tu envoyé? ");
INSERT INTO fraLSG_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Depuis que je suis allé vers Pharaon pour parler en ton nom, il fait du mal à ce peuple, et tu n’as point délivré ton peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","L’Éternel dit à Moïse: Tu verras maintenant ce que je ferai à Pharaon; une main puissante le forcera à les laisser aller, une main puissante le forcera à les chasser de son pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Dieu parla encore à Moïse, et lui dit: Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Je suis apparu à Abraham, à Isaac et à Jacob, comme le Dieu tout-puissant; mais je n’ai pas été connu d’eux sous mon nom, l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","J’ai aussi établi mon alliance avec eux, pour leur donner le pays de Canaan, le pays de leurs pèlerinages, dans lequel ils ont séjourné. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","J’ai entendu les gémissements des enfants d’Israël, que les Égyptiens tiennent dans la servitude, et je me suis souvenu de mon alliance. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","C’est pourquoi dis aux enfants d’Israël: Je suis l’Éternel, je vous affranchirai des travaux dont vous chargent les Égyptiens, je vous délivrerai de leur servitude, et je vous sauverai à bras étendu et par de grands jugements. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Je vous prendrai pour mon peuple, je serai votre Dieu, et vous saurez que c’est moi, l’Éternel, votre Dieu, qui vous affranchis des travaux dont vous chargent les Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Je vous ferai entrer dans le pays que j’ai juré de donner à Abraham, à Isaac et à Jacob; je vous le donnerai en possession, moi l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ainsi parla Moïse aux enfants d’Israël. Mais l’angoisse et la dure servitude les empêchèrent d’écouter Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Va, parle à Pharaon, roi d’Égypte, pour qu’il laisse aller les enfants d’Israël hors de son pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moïse répondit en présence de l’Éternel: Voici, les enfants d’Israël ne m’ont point écouté; comment Pharaon m’écouterait-il, moi qui n’ai pas la parole facile? ");
INSERT INTO fraLSG_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","L’Éternel parla à Moïse et à Aaron, et leur donna des ordres au sujet des enfants d’Israël et au sujet de Pharaon, roi d’Égypte, pour faire sortir du pays d’Égypte les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Voici les chefs de leurs familles. Fils de Ruben, premier-né d’Israël: Hénoc, Pallu, Hetsron et Carmi. Ce sont là les familles de Ruben. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Fils de Siméon: Jemuel, Jamin, Ohad, Jakin et Tsochar; et Saül, fils de la Cananéenne. Ce sont là les familles de Siméon. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Voici les noms des fils de Lévi, avec leur postérité: Guerschon, Kehath et Merari. Les années de la vie de Lévi furent de cent trente-sept ans. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Fils de Guerschon: Libni et Schimeï, et leurs familles. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Fils de Kehath: Amram, Jitsehar, Hébron et Uziel. Les années de la vie de Kehath furent de cent trente-trois ans. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Fils de Merari: Machli et Muschi. Ce sont là les familles de Lévi, avec leur postérité. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram prit pour femme Jokébed, sa tante; et elle lui enfanta Aaron, et Moïse. Les années de la vie d’Amram furent de cent trente-sept ans. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Fils de Jitsehar: Koré, Népheg et Zicri. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Fils d’Uziel: Mischaël, Eltsaphan et Sithri. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron prit pour femme Élischéba, fille d’Amminadab, sœur de Nachschon; et elle lui enfanta Nadab, Abihu, Éléazar et Ithamar. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Fils de Koré: Assir, Elkana et Abiasaph. Ce sont là les familles des Korites. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Éléazar, fils d’Aaron, prit pour femme une des filles de Puthiel; et elle lui enfanta Phinées. Tels sont les chefs de famille des Lévites, avec leurs familles. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ce sont là cet Aaron et ce Moïse, à qui l’Éternel dit: Faites sortir du pays d’Égypte les enfants d’Israël, selon leurs armées. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ce sont eux qui parlèrent à Pharaon, roi d’Égypte, pour faire sortir d’Égypte les enfants d’Israël. Ce sont là ce Moïse et cet Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Lorsque l’Éternel parla à Moïse dans le pays d’Égypte, ");
INSERT INTO fraLSG_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","l’Éternel dit à Moïse: Je suis l’Éternel. Dis à Pharaon, roi d’Égypte, tout ce que je te dis. ");
INSERT INTO fraLSG_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Et Moïse répondit en présence de l’Éternel: Voici, je n’ai pas la parole facile; comment Pharaon m’écouterait-il? ");
INSERT INTO fraLSG_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","L’Éternel dit à Moïse: Vois, je te fais Dieu pour Pharaon: et Aaron, ton frère, sera ton prophète. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Toi, tu diras tout ce que je t’ordonnerai; et Aaron, ton frère, parlera à Pharaon, pour qu’il laisse aller les enfants d’Israël hors de son pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Et moi, j’endurcirai le cœur de Pharaon, et je multiplierai mes signes et mes miracles dans le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Pharaon ne vous écoutera point. Je mettrai ma main sur l’Égypte, et je ferai sortir du pays d’Égypte mes armées, mon peuple, les enfants d’Israël, par de grands jugements. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Les Égyptiens connaîtront que je suis l’Éternel, lorsque j’étendrai ma main sur l’Égypte, et que je ferai sortir du milieu d’eux les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Moïse et Aaron firent ce que l’Éternel leur avait ordonné; ils firent ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Moïse était âgé de quatre-vingts ans, et Aaron de quatre-vingt-trois ans, lorsqu’ils parlèrent à Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","L’Éternel dit à Moïse et à Aaron: ");
INSERT INTO fraLSG_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Si Pharaon vous parle, et vous dit: Faites un miracle! Tu diras à Aaron: Prends ta verge, et jette-la devant Pharaon. Elle deviendra un serpent. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Moïse et Aaron allèrent auprès de Pharaon, et ils firent ce que l’Éternel avait ordonné. Aaron jeta sa verge devant Pharaon et devant ses serviteurs; et elle devint un serpent. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Mais Pharaon appela des sages et des enchanteurs; et les magiciens d’Égypte, eux aussi, en firent autant par leurs enchantements. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ils jetèrent tous leurs verges, et elles devinrent des serpents. Et la verge d’Aaron engloutit leurs verges. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Le cœur de Pharaon s’endurcit, et il n’écouta point Moïse et Aaron selon ce que l’Éternel avait dit. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","L’Éternel dit à Moïse: Pharaon a le cœur endurci; il refuse de laisser aller le peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Va vers Pharaon dès le matin; il sortira pour aller près de l’eau, et tu te présenteras devant lui au bord du fleuve. Tu prendras à ta main la verge qui a été changée en serpent, ");
INSERT INTO fraLSG_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","et tu diras à Pharaon: L’Éternel, le Dieu des Hébreux, m’a envoyé auprès de toi, pour te dire: Laisse aller mon peuple, afin qu’il me serve dans le désert. Et voici, jusqu’à présent tu n’as point écouté. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ainsi parle l’Éternel: A ceci tu connaîtras que je suis l’Éternel. Je vais frapper les eaux du fleuve avec la verge qui est dans ma main; et elles seront changées en sang. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Les poissons qui sont dans le fleuve périront, le fleuve se corrompra, et les Égyptiens s’efforceront en vain de boire l’eau du fleuve. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","L’Éternel dit à Moïse: Dis à Aaron: Prends ta verge, et étends ta main sur les eaux des Égyptiens, sur leurs rivières, sur leurs ruisseaux, sur leurs étangs, et sur tous leurs amas d’eaux. Elles deviendront du sang: et il y aura du sang dans tout le pays d’Égypte, dans les vases de bois et dans les vases de pierre. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Moïse et Aaron firent ce que l’Éternel avait ordonné. Aaron leva la verge, et il frappa les eaux qui étaient dans le fleuve, sous les yeux de Pharaon et sous les yeux de ses serviteurs; et toutes les eaux du fleuve furent changées en sang. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Les poissons qui étaient dans le fleuve périrent, le fleuve se corrompit, les Égyptiens ne pouvaient plus boire l’eau du fleuve, et il y eut du sang dans tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Mais les magiciens d’Égypte en firent autant par leurs enchantements. Le cœur de Pharaon s’endurcit, et il n’écouta point Moïse et Aaron, selon ce que l’Éternel avait dit. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaon s’en retourna, et alla dans sa maison; et il ne prit pas même à cœur ces choses. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Tous les Égyptiens creusèrent aux environs du fleuve, pour trouver de l’eau à boire; car ils ne pouvaient boire de l’eau du fleuve. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Il s’écoula sept jours, après que l’Éternel eut frappé le fleuve. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","L’Éternel dit à Moïse: Va vers Pharaon, et tu lui diras: Ainsi parle l’Éternel: Laisse aller mon peuple, afin qu’il me serve. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Si tu refuses de le laisser aller, je vais frapper par des grenouilles toute l’étendue de ton pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Le fleuve fourmillera de grenouilles; elles monteront, et elles entreront dans ta maison, dans ta chambre à coucher et dans ton lit, dans la maison de tes serviteurs et dans celles de ton peuple, dans tes fours et dans tes pétrins. ");
INSERT INTO fraLSG_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Les grenouilles monteront sur toi, sur ton peuple, et sur tous tes serviteurs. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","L’Éternel dit à Moïse: Dis à Aaron: Étends ta main avec ta verge sur les rivières, sur les ruisseaux et sur les étangs, et fais monter les grenouilles sur le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aaron étendit sa main sur les eaux de l’Égypte; et les grenouilles montèrent et couvrirent le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Mais les magiciens en firent autant par leurs enchantements. Ils firent monter les grenouilles sur le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Pharaon appela Moïse et Aaron, et dit: Priez l’Éternel, afin qu’il éloigne les grenouilles de moi et de mon peuple; et je laisserai aller le peuple, pour qu’il offre des sacrifices à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Moïse dit à Pharaon: Glorifie-toi sur moi! Pour quand prierai-je l’Éternel en ta faveur, en faveur de tes serviteurs et de ton peuple, afin qu’il retire les grenouilles loin de toi et de tes maisons? Il n’en restera que dans le fleuve. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Il répondit: Pour demain. Et Moïse dit: Il en sera ainsi, afin que tu saches que nul n’est semblable à l’Éternel, notre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Les grenouilles s’éloigneront de toi et de tes maisons, de tes serviteurs et de ton peuple; il n’en restera que dans le fleuve. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Moïse et Aaron sortirent de chez Pharaon. Et Moïse cria à l’Éternel au sujet des grenouilles dont il avait frappé Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","L’Éternel fit ce que demandait Moïse; et les grenouilles périrent dans les maisons, dans les cours et dans les champs. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","On les entassa par monceaux, et le pays fut infecté. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Pharaon, voyant qu’il y avait du relâche, endurcit son cœur, et il n’écouta point Moïse et Aaron, selon ce que l’Éternel avait dit. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","L’Éternel dit à Moïse: Dis à Aaron: Étends ta verge, et frappe la poussière de la terre. Elle se changera en poux, dans tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Ils firent ainsi. Aaron étendit sa main, avec sa verge, et il frappa la poussière de la terre; et elle fut changée en poux sur les hommes et sur les animaux. Toute la poussière de la terre fut changée en poux, dans tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Les magiciens employèrent leurs enchantements pour produire les poux; mais ils ne purent pas. Les poux étaient sur les hommes et sur les animaux. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Et les magiciens dirent à Pharaon: C’est le doigt de Dieu! Le cœur de Pharaon s’endurcit, et il n’écouta point Moïse et Aaron, selon ce que l’Éternel avait dit. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","L’Éternel dit à Moïse: Lève-toi de bon matin, et présente-toi devant Pharaon; il sortira pour aller près de l’eau. Tu lui diras: Ainsi parle l’Éternel: Laisse aller mon peuple, afin qu’il me serve. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Si tu ne laisses pas aller mon peuple, je vais envoyer les mouches venimeuses contre toi, contre tes serviteurs, contre ton peuple et contre tes maisons; les maisons des Égyptiens seront remplies de mouches, et le sol en sera couvert. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Mais, en ce jour-là, je distinguerai le pays de Gosen où habite mon peuple, et là il n’y aura point de mouches, afin que tu saches que moi, l’Éternel, je suis au milieu de ce pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","J’établirai une distinction entre mon peuple et ton peuple. Ce signe sera pour demain. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","L’Éternel fit ainsi. Il vint une quantité de mouches venimeuses dans la maison de Pharaon et de ses serviteurs, et tout le pays d’Égypte fut dévasté par les mouches. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Pharaon appela Moïse et Aaron et dit: Allez, offrez des sacrifices à votre Dieu dans le pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Moïse répondit: Il n’est point convenable de faire ainsi; car nous offririons à l’Éternel, notre Dieu, des sacrifices qui sont en abomination aux Égyptiens. Et si nous offrons, sous leurs yeux, des sacrifices qui sont en abomination aux Égyptiens, ne nous lapideront-ils pas? ");
INSERT INTO fraLSG_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Nous ferons trois journées de marche dans le désert, et nous offrirons des sacrifices à l’Éternel, notre Dieu, selon ce qu’il nous dira. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Pharaon dit: Je vous laisserai aller, pour offrir à l’Éternel, votre Dieu, des sacrifices dans le désert: seulement, vous ne vous éloignerez pas, en y allant. Priez pour moi. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Moïse répondit: Je vais sortir de chez toi, et je prierai l’Éternel. Demain, les mouches s’éloigneront de Pharaon, de ses serviteurs et de son peuple. Mais, que Pharaon ne trompe plus, en refusant de laisser aller le peuple, pour offrir des sacrifices à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moïse sortit de chez Pharaon, et il pria l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","L’Éternel fit ce que demandait Moïse; et les mouches s’éloignèrent de Pharaon, de ses serviteurs et de son peuple. Il n’en resta pas une. ");
INSERT INTO fraLSG_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Mais Pharaon, cette fois encore, endurcit son cœur, et il ne laissa point aller le peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","L’Éternel dit à Moïse: Va vers Pharaon, et tu lui diras: Ainsi parle l’Éternel, le Dieu des Hébreux: Laisse aller mon peuple, afin qu’il me serve. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Si tu refuses de le laisser aller, et si tu le retiens encore, ");
INSERT INTO fraLSG_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","voici, la main de l’Éternel sera sur tes troupeaux qui sont dans les champs, sur les chevaux, sur les ânes, sur les chameaux, sur les bœufs et sur les brebis; il y aura une mortalité très grande. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","L’Éternel distinguera entre les troupeaux d’Israël et les troupeaux des Égyptiens, et il ne périra rien de tout ce qui est aux enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","L’Éternel fixa le temps, et dit: Demain, l’Éternel fera cela dans le pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Et l’Éternel fit ainsi, dès le lendemain. Tous les troupeaux des Égyptiens périrent, et il ne périt pas une bête des troupeaux des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Pharaon s’informa de ce qui était arrivé; et voici, pas une bête des troupeaux d’Israël n’avait péri. Mais le cœur de Pharaon s’endurcit, et il ne laissa point aller le peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","L’Éternel dit à Moïse et à Aaron: Remplissez vos mains de cendre de fournaise, et que Moïse la jette vers le ciel, sous les yeux de Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Elle deviendra une poussière qui couvrira tout le pays d’Égypte; et elle produira, dans tout le pays d’Égypte, sur les hommes et sur les animaux, des ulcères formés par une éruption de pustules. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ils prirent de la cendre de fournaise, et se présentèrent devant Pharaon; Moïse la jeta vers le ciel, et elle produisit sur les hommes et sur les animaux des ulcères formés par une éruption de pustules. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Les magiciens ne purent paraître devant Moïse, à cause des ulcères; car les ulcères étaient sur les magiciens, comme sur tous les Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","L’Éternel endurcit le cœur de Pharaon, et Pharaon n’écouta point Moïse et Aaron, selon ce que l’Éternel avait dit à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","L’Éternel dit à Moïse: Lève-toi de bon matin, et présente-toi devant Pharaon. Tu lui diras: Ainsi parle l’Éternel, le Dieu des Hébreux: Laisse aller mon peuple, afin qu’il me serve. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Car, cette fois, je vais envoyer toutes mes plaies contre ton cœur, contre tes serviteurs et contre ton peuple, afin que tu saches que nul n’est semblable à moi sur toute la terre. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Si j’avais étendu ma main, et que je t’eusse frappé par la mortalité, toi et ton peuple, tu aurais disparu de la terre. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Mais, je t’ai laissé subsister, afin que tu voies ma puissance, et que l’on publie mon nom par toute la terre. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Si tu t’élèves encore contre mon peuple, et si tu ne le laisses point aller, ");
INSERT INTO fraLSG_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","voici, je ferai pleuvoir demain, à cette heure, une grêle tellement forte, qu’il n’y en a point eu de semblable en Égypte depuis le jour où elle a été fondée jusqu’à présent. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Fais donc mettre en sûreté tes troupeaux et tout ce qui est à toi dans les champs. La grêle tombera sur tous les hommes et sur tous les animaux qui se trouveront dans les champs et qui n’auront pas été recueillis dans les maisons, et ils périront. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ceux des serviteurs de Pharaon qui craignirent la parole de l’Éternel firent retirer dans les maisons leurs serviteurs et leurs troupeaux. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Mais ceux qui ne prirent point à cœur la parole de l’Éternel laissèrent leurs serviteurs et leurs troupeaux dans les champs. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","L’Éternel dit à Moïse: Étends ta main vers le ciel; et qu’il tombe de la grêle dans tout le pays d’Égypte sur les hommes, sur les animaux, et sur toutes les herbes des champs, dans le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Moïse étendit sa verge vers le ciel; et l’Éternel envoya des tonnerres et de la grêle, et le feu se promenait sur la terre. L’Éternel fit pleuvoir de la grêle sur le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Il tomba de la grêle, et le feu se mêlait avec la grêle; elle était tellement forte qu’il n’y en avait point eu de semblable dans tout le pays d’Égypte depuis qu’il existe comme nation. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","La grêle frappa, dans tout le pays d’Égypte, tout ce qui était dans les champs, depuis les hommes jusqu’aux animaux; la grêle frappa aussi toutes les herbes des champs, et brisa tous les arbres des champs. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ce fut seulement dans le pays de Gosen, où étaient les enfants d’Israël, qu’il n’y eut point de grêle. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pharaon fit appeler Moïse et Aaron, et leur dit: Cette fois, j’ai péché; c’est l’Éternel qui est le juste, et moi et mon peuple nous sommes les coupables. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Priez l’Éternel, pour qu’il n’y ait plus de tonnerres et de grêle; et je vous laisserai aller, et l’on ne vous retiendra plus. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Moïse lui dit: Quand je sortirai de la ville, je lèverai mes mains vers l’Éternel, les tonnerres cesseront et il n’y aura plus de grêle, afin que tu saches que la terre est à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Mais je sais que toi et tes serviteurs, vous ne craindrez pas encore l’Éternel Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Le lin et l’orge avaient été frappés, parce que l’orge était en épis et que c’était la floraison du lin; ");
INSERT INTO fraLSG_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","le froment et l’épeautre n’avaient point été frappés, parce qu’ils sont tardifs. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Moïse sortit de chez Pharaon, pour aller hors de la ville; il leva ses mains vers l’Éternel, les tonnerres et la grêle cessèrent, et la pluie ne tomba plus sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pharaon, voyant que la pluie, la grêle et les tonnerres avaient cessé, continua de pécher, et il endurcit son cœur, lui et ses serviteurs. ");
INSERT INTO fraLSG_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Le cœur de Pharaon s’endurcit, et il ne laissa point aller les enfants d’Israël, selon ce que l’Éternel avait dit par l’intermédiaire de Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","L’Éternel dit à Moïse: Va vers Pharaon, car j’ai endurci son cœur et le cœur de ses serviteurs, pour faire éclater mes signes au milieu d’eux. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","C’est aussi pour que tu racontes à ton fils et au fils de ton fils comment j’ai traité les Égyptiens, et quels signes j’ai fait éclater au milieu d’eux. Et vous saurez que je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Moïse et Aaron allèrent vers Pharaon, et lui dirent: Ainsi parle l’Éternel, le Dieu des Hébreux: Jusqu’à quand refuseras-tu de t’humilier devant moi? Laisse aller mon peuple, afin qu’il me serve. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Si tu refuses de laisser aller mon peuple, voici, je ferai venir demain des sauterelles dans toute l’étendue de ton pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Elles couvriront la surface de la terre, et l’on ne pourra plus voir la terre; elles dévoreront le reste de ce qui est échappé, ce que vous a laissé la grêle, elles dévoreront tous les arbres qui croissent dans vos champs; ");
INSERT INTO fraLSG_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","elles rempliront tes maisons, les maisons de tous tes serviteurs et les maisons de tous les Égyptiens. Tes pères et les pères de tes pères n’auront rien vu de pareil depuis qu’ils existent sur la terre jusqu’à ce jour. Moïse se retira, et sortit de chez Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Les serviteurs de Pharaon lui dirent: Jusqu’à quand cet homme sera-t-il pour nous un piège? Laisse aller ces gens, et qu’ils servent l’Éternel, leur Dieu. Ne vois-tu pas encore que l’Égypte périt? ");
INSERT INTO fraLSG_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","On fit revenir vers Pharaon Moïse et Aaron: Allez, leur dit-il, servez l’Éternel, votre Dieu. Qui sont ceux qui iront? ");
INSERT INTO fraLSG_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moïse répondit: Nous irons avec nos enfants et nos vieillards, avec nos fils et nos filles, avec nos brebis et nos bœufs; car c’est pour nous une fête en l’honneur de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pharaon leur dit: Que l’Éternel soit avec vous, tout comme je vais vous laisser aller, vous et vos enfants! Prenez garde, car le malheur est devant vous! ");
INSERT INTO fraLSG_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Non, non: allez, vous les hommes, et servez l’Éternel, car c’est là ce que vous avez demandé. Et on les chassa de la présence de Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","L’Éternel dit à Moïse: Étends ta main sur le pays d’Égypte, et que les sauterelles montent sur le pays d’Égypte; qu’elles dévorent toute l’herbe de la terre, tout ce que la grêle a laissé. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moïse étendit sa verge sur le pays d’Égypte; et l’Éternel fit souffler un vent d’orient sur le pays toute cette journée et toute la nuit. Quand ce fut le matin, le vent d’orient avait apporté les sauterelles. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Les sauterelles montèrent sur le pays d’Égypte, et se posèrent dans toute l’étendue de l’Égypte; elles étaient en si grande quantité qu’il n’y avait jamais eu et qu’il n’y aura jamais rien de semblable. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Elles couvrirent la surface de toute la terre, et la terre fut dans l’obscurité; elles dévorèrent toute l’herbe de la terre et tout le fruit des arbres, tout ce que la grêle avait laissé; et il ne resta aucune verdure aux arbres ni à l’herbe des champs, dans tout le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Aussitôt Pharaon appela Moïse et Aaron, et dit: J’ai péché contre l’Éternel, votre Dieu, et contre vous. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Mais pardonne mon péché pour cette fois seulement; et priez l’Éternel, votre Dieu, afin qu’il éloigne de moi encore cette plaie mortelle. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Moïse sortit de chez Pharaon, et il pria l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","L’Éternel fit souffler un vent d’occident très fort, qui emporta les sauterelles, et les précipita dans la mer Rouge; il ne resta pas une seule sauterelle dans toute l’étendue de l’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","L’Éternel endurcit le cœur de Pharaon, et Pharaon ne laissa point aller les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","L’Éternel dit à Moïse: Étends ta main vers le ciel, et qu’il y ait des ténèbres sur le pays d’Égypte, et que l’on puisse les toucher. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moïse étendit sa main vers le ciel; et il y eut d’épaisses ténèbres dans tout le pays d’Égypte, pendant trois jours. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","On ne se voyait pas les uns les autres, et personne ne se leva de sa place pendant trois jours. Mais il y avait de la lumière dans les lieux où habitaient tous les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pharaon appela Moïse, et dit: Allez, servez l’Éternel. Il n’y aura que vos brebis et vos bœufs qui resteront, et vos enfants pourront aller avec vous. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Moïse répondit: Tu mettras toi-même entre nos mains de quoi faire les sacrifices et les holocaustes que nous offrirons à l’Éternel, notre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Nos troupeaux iront avec nous, et il ne restera pas un ongle; car c’est là ce que nous prendrons pour servir l’Éternel, notre Dieu; et jusqu’à ce que nous soyons arrivés, nous ne savons pas ce que nous choisirons pour offrir à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","L’Éternel endurcit le cœur de Pharaon, et Pharaon ne voulut point les laisser aller. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaon dit à Moïse: Sors de chez moi! Garde-toi de paraître encore en ma présence, car le jour où tu paraîtras en ma présence, tu mourras. ");
INSERT INTO fraLSG_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Tu l’as dit! Répliqua Moïse, je ne paraîtrai plus en ta présence. ");
INSERT INTO fraLSG_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","L’Éternel dit à Moïse: Je ferai venir encore une plaie sur Pharaon et sur l’Égypte. Après cela, il vous laissera partir d’ici. Lorsqu’il vous laissera tout à fait aller, il vous chassera même d’ici. ");
INSERT INTO fraLSG_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Parle au peuple, pour que chacun demande à son voisin et chacune à sa voisine des vases d’argent et des vases d’or. ");
INSERT INTO fraLSG_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","L’Éternel fit trouver grâce au peuple aux yeux des Égyptiens; Moïse lui-même était très considéré dans le pays d’Égypte, aux yeux des serviteurs de Pharaon et aux yeux du peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Moïse dit: Ainsi parle l’Éternel: Vers le milieu de la nuit, je passerai au travers de l’Égypte; ");
INSERT INTO fraLSG_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","et tous les premiers-nés mourront dans le pays d’Égypte, depuis le premier-né de Pharaon assis sur son trône, jusqu’au premier-né de la servante qui est derrière la meule, et jusqu’à tous les premiers-nés des animaux. ");
INSERT INTO fraLSG_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Il y aura dans tout le pays d’Égypte de grands cris, tels qu’il n’y en a point eu et qu’il n’y en aura plus de semblables. ");
INSERT INTO fraLSG_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Mais parmi tous les enfants d’Israël, depuis les hommes jusqu’aux animaux, pas même un chien ne remuera sa langue, afin que vous sachiez quelle différence l’Éternel fait entre l’Égypte et Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Alors tous tes serviteurs que voici descendront vers moi et se prosterneront devant moi, en disant: Sors, toi et tout le peuple qui s’attache à tes pas! Après cela, je sortirai. Moïse sortit de chez Pharaon, dans une ardente colère. ");
INSERT INTO fraLSG_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","L’Éternel dit à Moïse: Pharaon ne vous écoutera point, afin que mes miracles se multiplient dans le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Moïse et Aaron firent tous ces miracles devant Pharaon, l’Éternel endurcit le cœur de Pharaon, et Pharaon ne laissa point aller les enfants d’Israël hors de son pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","L’Éternel dit à Moïse et à Aaron dans le pays d’Égypte: ");
INSERT INTO fraLSG_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Ce mois-ci sera pour vous le premier des mois; il sera pour vous le premier des mois de l’année. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Parlez à toute l’assemblée d’Israël, et dites: Le dixième jour de ce mois, on prendra un agneau pour chaque famille, un agneau pour chaque maison. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Si la maison est trop peu nombreuse pour un agneau, on le prendra avec son plus proche voisin, selon le nombre des personnes; vous compterez pour cet agneau d’après ce que chacun peut manger. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ce sera un agneau sans défaut, mâle, âgé d’un an; vous pourrez prendre un agneau ou un chevreau. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Vous le garderez jusqu’au quatorzième jour de ce mois; et toute l’assemblée d’Israël l’immolera entre les deux soirs. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","On prendra de son sang, et on en mettra sur les deux poteaux et sur le linteau de la porte des maisons où on le mangera. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Cette même nuit, on en mangera la chair, rôtie au feu; on la mangera avec des pains sans levain et des herbes amères. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Vous ne le mangerez point à demi cuit et bouilli dans l’eau; mais il sera rôti au feu, avec la tête, les jambes et l’intérieur. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Vous n’en laisserez rien jusqu’au matin; et, s’il en reste quelque chose le matin, vous le brûlerez au feu. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Quand vous le mangerez, vous aurez vos reins ceints, vos souliers aux pieds, et votre bâton à la main; et vous le mangerez à la hâte. C’est la Pâque de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Cette nuit-là, je passerai dans le pays d’Égypte, et je frapperai tous les premiers-nés du pays d’Égypte, depuis les hommes jusqu’aux animaux, et j’exercerai des jugements contre tous les dieux de l’Égypte. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Le sang vous servira de signe sur les maisons où vous serez; je verrai le sang, et je passerai par-dessus vous, et il n’y aura point de plaie qui vous détruise, quand je frapperai le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Vous conserverez le souvenir de ce jour, et vous le célébrerez par une fête en l’honneur de l’Éternel; vous le célébrerez comme une loi perpétuelle pour vos descendants. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Pendant sept jours, vous mangerez des pains sans levain. Dès le premier jour, il n’y aura plus de levain dans vos maisons; car toute personne qui mangera du pain levé, du premier jour au septième jour, sera retranchée d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Le premier jour, vous aurez une sainte convocation; et le septième jour, vous aurez une sainte convocation. On ne fera aucun travail ces jours-là; vous pourrez seulement préparer la nourriture de chaque personne. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Vous observerez la fête des pains sans levain, car c’est en ce jour même que j’aurai fait sortir vos armées du pays d’Égypte; vous observerez ce jour comme une loi perpétuelle pour vos descendants. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Le premier mois, le quatorzième jour du mois, au soir, vous mangerez des pains sans levain jusqu’au soir du vingt et unième jour. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Pendant sept jours, il ne se trouvera point de levain dans vos maisons; car toute personne qui mangera du pain levé sera retranchée de l’assemblée d’Israël, que ce soit un étranger ou un indigène. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Vous ne mangerez point de pain levé; dans toutes vos demeures, vous mangerez des pains sans levain. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Moïse appela tous les anciens d’Israël, et leur dit: Allez prendre du bétail pour vos familles, et immolez la Pâque. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Vous prendrez ensuite un bouquet d’hysope, vous le tremperez dans le sang qui sera dans le bassin, et vous toucherez le linteau et les deux poteaux de la porte avec le sang qui sera dans le bassin. Nul de vous ne sortira de sa maison jusqu’au matin. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Quand l’Éternel passera pour frapper l’Égypte, et verra le sang sur le linteau et sur les deux poteaux, l’Éternel passera par-dessus la porte, et il ne permettra pas au destructeur d’entrer dans vos maisons pour frapper. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Vous observerez cela comme une loi pour vous et pour vos enfants à perpétuité. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Quand vous serez entrés dans le pays que l’Éternel vous donnera, selon sa promesse, vous observerez cet usage sacré. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Et lorsque vos enfants vous diront: Que signifie pour vous cet usage? ");
INSERT INTO fraLSG_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","vous répondrez: C’est le sacrifice de Pâque en l’honneur de l’Éternel, qui a passé par-dessus les maisons des enfants d’Israël en Égypte, lorsqu’il frappa l’Égypte et qu’il sauva nos maisons. Le peuple s’inclina et se prosterna. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Et les enfants d’Israël s’en allèrent, et firent ce que l’Éternel avait ordonné à Moïse et à Aaron; ils firent ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Au milieu de la nuit, l’Éternel frappa tous les premiers-nés dans le pays d’Égypte, depuis le premier-né de Pharaon assis sur son trône, jusqu’au premier-né du captif dans sa prison, et jusqu’à tous les premiers-nés des animaux. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Pharaon se leva de nuit, lui et tous ses serviteurs, et tous les Égyptiens; et il y eut de grands cris en Égypte, car il n’y avait point de maison où il n’y eût un mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Dans la nuit même, Pharaon appela Moïse et Aaron, et leur dit: Levez-vous, sortez du milieu de mon peuple, vous et les enfants d’Israël. Allez, servez l’Éternel, comme vous l’avez dit. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Prenez vos brebis et vos bœufs, comme vous l’avez dit; allez, et bénissez-moi. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Les Égyptiens pressaient le peuple, et avaient hâte de le renvoyer du pays, car ils disaient: Nous périrons tous. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Le peuple emporta sa pâte avant qu’elle fût levée. Ils enveloppèrent les pétrins dans leurs vêtements, et les mirent sur leurs épaules. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Les enfants d’Israël firent ce que Moïse avait dit, et ils demandèrent aux Égyptiens des vases d’argent, des vases d’or et des vêtements. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","L’Éternel fit trouver grâce au peuple aux yeux des Égyptiens, qui se rendirent à leur demande. Et ils dépouillèrent les Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Les enfants d’Israël partirent de Ramsès pour Succoth au nombre d’environ six cent mille hommes de pied, sans les enfants. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Une multitude de gens de toute espèce montèrent avec eux; ils avaient aussi des troupeaux considérables de brebis et de bœufs. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ils firent des gâteaux cuits sans levain avec la pâte qu’ils avaient emportée d’Égypte, et qui n’était pas levée; car ils avaient été chassés d’Égypte, sans pouvoir tarder, et sans prendre des provisions avec eux. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Le séjour des enfants d’Israël en Égypte fut de quatre cent trente ans. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Et au bout de quatre cent trente ans, le jour même, toutes les armées de l’Éternel sortirent du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Cette nuit sera célébrée en l’honneur de l’Éternel, parce qu’il les fit sortir du pays d’Égypte; cette nuit sera célébrée en l’honneur de l’Éternel par tous les enfants d’Israël et par leurs descendants. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","L’Éternel dit à Moïse et à Aaron: Voici une ordonnance au sujet de la Pâque: Aucun étranger n’en mangera. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Tu circonciras tout esclave acquis à prix d’argent; alors il en mangera. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","L’habitant et le mercenaire n’en mangeront point. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","On ne la mangera que dans la maison; vous n’emporterez point de chair hors de la maison, et vous ne briserez aucun os. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Toute l’assemblée d’Israël fera la Pâque. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Si un étranger en séjour chez toi veut faire la Pâque de l’Éternel, tout mâle de sa maison devra être circoncis; alors il s’approchera pour la faire, et il sera comme l’indigène; mais aucun incirconcis n’en mangera. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","La même loi existera pour l’indigène comme pour l’étranger en séjour au milieu de vous. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Tous les enfants d’Israël firent ce que l’Éternel avait ordonné à Moïse et à Aaron; ils firent ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Et ce même jour l’Éternel fit sortir du pays d’Égypte les enfants d’Israël, selon leurs armées. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Consacre-moi tout premier-né, tout premier-né parmi les enfants d’Israël, tant des hommes que des animaux: il m’appartient. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moïse dit au peuple: Souvenez-vous de ce jour, où vous êtes sortis d’Égypte, de la maison de servitude; car c’est par sa main puissante que l’Éternel vous en a fait sortir. On ne mangera point de pain levé. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Vous sortez aujourd’hui, dans le mois des épis. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Quand l’Éternel t’aura fait entrer dans le pays des Cananéens, des Héthiens, des Amoréens, des Héviens et des Jébusiens, qu’il a juré à tes pères de te donner, pays où coulent le lait et le miel, tu rendras ce culte à l’Éternel dans ce même mois. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Pendant sept jours, tu mangeras des pains sans levain; et le septième jour, il y aura une fête en l’honneur de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","On mangera des pains sans levain pendant les sept jours; on ne verra point chez toi de pain levé, et l’on ne verra point chez toi de levain, dans toute l’étendue de ton pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Tu diras alors à ton fils: C’est en mémoire de ce que l’Éternel a fait pour moi, lorsque je suis sorti d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ce sera pour toi comme un signe sur ta main et comme un souvenir entre tes yeux, afin que la loi de l’Éternel soit dans ta bouche; car c’est par sa main puissante que l’Éternel t’a fait sortir d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Tu observeras cette ordonnance au temps fixé d’année en année. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Quand l’Éternel t’aura fait entrer dans le pays des Cananéens, comme il l’a juré à toi et à tes pères, et qu’il te l’aura donné, ");
INSERT INTO fraLSG_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","tu consacreras à l’Éternel tout premier-né, même tout premier-né des animaux que tu auras: les mâles appartiennent à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Tu rachèteras avec un agneau tout premier-né de l’âne; et, si tu ne le rachètes pas, tu lui briseras la nuque. Tu rachèteras aussi tout premier-né de l’homme parmi tes fils. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Et lorsque ton fils te demandera un jour: Que signifie cela? Tu lui répondras: Par sa main puissante, l’Éternel nous a fait sortir d’Égypte, de la maison de servitude; ");
INSERT INTO fraLSG_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","et, comme Pharaon s’obstinait à ne point nous laisser aller, l’Éternel fit mourir tous les premiers-nés dans le pays d’Égypte, depuis les premiers-nés des hommes jusqu’aux premiers-nés des animaux. Voilà pourquoi j’offre en sacrifice à l’Éternel tout premier-né des mâles, et je rachète tout premier-né de mes fils. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ce sera comme un signe sur ta main et comme des fronteaux entre tes yeux; car c’est par sa main puissante que l’Éternel nous a fait sortir d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Lorsque Pharaon laissa aller le peuple, Dieu ne le conduisit point par le chemin du pays des Philistins, quoique le plus proche; car Dieu dit: Le peuple pourrait se repentir en voyant la guerre, et retourner en Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Mais Dieu fit faire au peuple un détour par le chemin du désert, vers la mer Rouge. Les enfants d’Israël montèrent en armes hors du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Moïse prit avec lui les os de Joseph; car Joseph avait fait jurer les fils d’Israël, en disant: Dieu vous visitera, et vous ferez remonter avec vous mes os loin d’ici. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ils partirent de Succoth, et ils campèrent à Étham, à l’extrémité du désert. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","L’Éternel allait devant eux, le jour dans une colonne de nuée pour les guider dans leur chemin, et la nuit dans une colonne de feu pour les éclairer, afin qu’ils marchassent jour et nuit. ");
INSERT INTO fraLSG_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","La colonne de nuée ne se retirait point de devant le peuple pendant le jour, ni la colonne de feu pendant la nuit. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Parle aux enfants d’Israël; qu’ils se détournent, et qu’ils campent devant Pi-Hahiroth, entre Migdol et la mer, vis-à-vis de Baal-Tsephon; c’est en face de ce lieu que vous camperez, près de la mer. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaon dira des enfants d’Israël: Ils sont égarés dans le pays; le désert les enferme. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","J’endurcirai le cœur de Pharaon, et il les poursuivra; mais Pharaon et toute son armée serviront à faire éclater ma gloire, et les Égyptiens sauront que je suis l’Éternel. Et les enfants d’Israël firent ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","On annonça au roi d’Égypte que le peuple avait pris la fuite. Alors le cœur de Pharaon et celui de ses serviteurs furent changés à l’égard du peuple. Ils dirent: Qu’avons-nous fait, en laissant aller Israël, dont nous n’aurons plus les services? ");
INSERT INTO fraLSG_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Et Pharaon attela son char, et il prit son peuple avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Il prit six cents chars d’élite, et tous les chars de l’Égypte; il y avait sur tous des combattants. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","L’Éternel endurcit le cœur de Pharaon, roi d’Égypte, et Pharaon poursuivit les enfants d’Israël. Les enfants d’Israël étaient sortis la main levée. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Les Égyptiens les poursuivirent; et tous les chevaux, les chars de Pharaon, ses cavaliers et son armée, les atteignirent campés près de la mer, vers Pi-Hahiroth, vis-à-vis de Baal-Tsephon. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Pharaon approchait. Les enfants d’Israël levèrent les yeux, et voici, les Égyptiens étaient en marche derrière eux. Et les enfants d’Israël eurent une grande frayeur, et crièrent à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ils dirent à Moïse: N’y avait-il pas des sépulcres en Égypte, sans qu’il fût besoin de nous mener mourir au désert? Que nous as-tu fait en nous faisant sortir d’Égypte? ");
INSERT INTO fraLSG_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","N’est-ce pas là ce que nous te disions en Égypte: Laisse-nous servir les Égyptiens, car nous aimons mieux servir les Égyptiens que de mourir au désert? ");
INSERT INTO fraLSG_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moïse répondit au peuple: Ne craignez rien, restez en place, et regardez la délivrance que l’Éternel va vous accorder en ce jour; car les Égyptiens que vous voyez aujourd’hui, vous ne les verrez plus jamais. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","L’Éternel combattra pour vous; et vous, gardez le silence. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","L’Éternel dit à Moïse: Pourquoi ces cris? Parle aux enfants d’Israël, et qu’ils marchent. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Toi, lève ta verge, étends ta main sur la mer, et fends-la; et les enfants d’Israël entreront au milieu de la mer à sec. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Et moi, je vais endurcir le cœur des Égyptiens, pour qu’ils y entrent après eux: et Pharaon et toute son armée, ses chars et ses cavaliers, feront éclater ma gloire. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Et les Égyptiens sauront que je suis l’Éternel, quand Pharaon, ses chars et ses cavaliers, auront fait éclater ma gloire. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","L’ange de Dieu, qui allait devant le camp d’Israël, partit et alla derrière eux; et la colonne de nuée qui les précédait, partit et se tint derrière eux. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Elle se plaça entre le camp des Égyptiens et le camp d’Israël. Cette nuée était ténébreuse d’un côté, et de l’autre elle éclairait la nuit. Et les deux camps n’approchèrent point l’un de l’autre pendant toute la nuit. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moïse étendit sa main sur la mer. Et l’Éternel refoula la mer par un vent d’orient, qui souffla avec impétuosité toute la nuit; il mit la mer à sec, et les eaux se fendirent. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Les enfants d’Israël entrèrent au milieu de la mer à sec, et les eaux formaient comme une muraille à leur droite et à leur gauche. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Les Égyptiens les poursuivirent; et tous les chevaux de Pharaon, ses chars et ses cavaliers, entrèrent après eux au milieu de la mer. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","A la veille du matin, l’Éternel, de la colonne de feu et de nuée, regarda le camp des Égyptiens, et mit en désordre le camp des Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Il ôta les roues de leurs chars et en rendit la marche difficile. Les Égyptiens dirent alors: Fuyons devant Israël, car l’Éternel combat pour lui contre les Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","L’Éternel dit à Moïse: Étends ta main sur la mer; et les eaux reviendront sur les Égyptiens, sur leurs chars et sur leurs cavaliers. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moïse étendit sa main sur la mer. Et vers le matin, la mer reprit son impétuosité, et les Égyptiens s’enfuirent à son approche; mais l’Éternel précipita les Égyptiens au milieu de la mer. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Les eaux revinrent, et couvrirent les chars, les cavaliers et toute l’armée de Pharaon, qui étaient entrés dans la mer après les enfants d’Israël; et il n’en échappa pas un seul. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mais les enfants d’Israël marchèrent à sec au milieu de la mer, et les eaux formaient comme une muraille à leur droite et à leur gauche. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","En ce jour, l’Éternel délivra Israël de la main des Égyptiens; et Israël vit sur le rivage de la mer les Égyptiens qui étaient morts. ");
INSERT INTO fraLSG_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israël vit la main puissante que l’Éternel avait dirigée contre les Égyptiens. Et le peuple craignit l’Éternel, et il crut en l’Éternel et en Moïse, son serviteur. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Alors Moïse et les enfants d’Israël chantèrent ce cantique à l’Éternel. Ils dirent: Je chanterai à l’Éternel, car il a fait éclater sa gloire; Il a précipité dans la mer le cheval et son cavalier. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","L’Éternel est ma force et le sujet de mes louanges; C’est lui qui m’a sauvé. Il est mon Dieu: je le célèbrerai; Il est le Dieu de mon père: je l’exalterai. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","L’Éternel est un vaillant guerrier; L’Éternel est son nom. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Il a lancé dans la mer les chars de Pharaon et son armée; Ses combattants d’élite ont été engloutis dans la mer Rouge. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Les flots les ont couverts: Ils sont descendus au fond des eaux, comme une pierre. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ta droite, ô Éternel! A signalé sa force; Ta droite, ô Éternel! A écrasé l’ennemi. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Par la grandeur de ta majesté Tu renverses tes adversaires; Tu déchaînes ta colère: Elle les consume comme du chaume. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Au souffle de tes narines, les eaux se sont amoncelées, Les courants se sont dressés comme une muraille, Les flots se sont durcis au milieu de la mer. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","L’ennemi disait: Je poursuivrai, j’atteindrai, Je partagerai le butin; Ma vengeance sera assouvie, Je tirerai l’épée, ma main les détruira. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Tu as soufflé de ton haleine: La mer les a couverts; Ils se sont enfoncés comme du plomb, Dans la profondeur des eaux. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Qui est comme toi parmi les dieux, ô Éternel? Qui est comme toi magnifique en sainteté, Digne de louanges, Opérant des prodiges? ");
INSERT INTO fraLSG_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Tu as étendu ta droite: La terre les a engloutis. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Par ta miséricorde tu as conduit, Tu as délivré ce peuple; Par ta puissance tu le diriges Vers la demeure de ta sainteté. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Les peuples l’apprennent, et ils tremblent: La terreur s’empare des Philistins; ");
INSERT INTO fraLSG_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Les chefs d’Édom s’épouvantent; Un tremblement saisit les guerriers de Moab; Tous les habitants de Canaan tombent en défaillance. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","La crainte et la frayeur les surprendront; Par la grandeur de ton bras Ils deviendront muets comme une pierre, Jusqu’à ce que ton peuple soit passé, ô Éternel! Jusqu’à ce qu’il soit passé, Le peuple que tu as acquis. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Tu les amèneras et tu les établiras sur la montagne de ton héritage, Au lieu que tu as préparé pour ta demeure, ô Éternel! Au sanctuaire, Seigneur! Que tes mains ont fondé. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","L’Éternel régnera éternellement et à toujours. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Car les chevaux de Pharaon, ses chars et ses cavaliers sont entrés dans la mer, Et l’Éternel a ramené sur eux les eaux de la mer; Mais les enfants d’Israël ont marché à sec au milieu de la mer. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Marie, la prophétesse, sœur d’Aaron, prit à sa main un tambourin, et toutes les femmes vinrent après elle, avec des tambourins et en dansant. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Marie répondait aux enfants d’Israël: Chantez à l’Éternel, car il a fait éclater sa gloire; Il a précipité dans la mer le cheval et son cavalier. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moïse fit partir Israël de la mer Rouge. Ils prirent la direction du désert de Schur; et, après trois journées de marche dans le désert, ils ne trouvèrent point d’eau. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ils arrivèrent à Mara; mais ils ne purent pas boire l’eau de Mara parce qu’elle était amère. C’est pourquoi ce lieu fut appelé Mara. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Le peuple murmura contre Moïse, en disant: Que boirons-nous? ");
INSERT INTO fraLSG_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Moïse cria à l’Éternel; et l’Éternel lui indiqua un bois, qu’il jeta dans l’eau. Et l’eau devint douce. Ce fut là que l’Éternel donna au peuple des lois et des ordonnances, et ce fut là qu’il le mit à l’épreuve. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Il dit: Si tu écoutes attentivement la voix de l’Éternel, ton Dieu, si tu fais ce qui est droit à ses yeux, si tu prêtes l’oreille à ses commandements, et si tu observes toutes ses lois, je ne te frapperai d’aucune des maladies dont j’ai frappé les Égyptiens; car je suis l’Éternel, qui te guérit. ");
INSERT INTO fraLSG_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ils arrivèrent à Élim, où il y avait douze sources d’eau et soixante-dix palmiers. Ils campèrent là, près de l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Toute l’assemblée des enfants d’Israël partit d’Élim, et ils arrivèrent au désert de Sin, qui est entre Élim et Sinaï, le quinzième jour du second mois après leur sortie du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Et toute l’assemblée des enfants d’Israël murmura dans le désert contre Moïse et Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Les enfants d’Israël leur dirent: Que ne sommes-nous morts par la main de l’Éternel dans le pays d’Égypte, quand nous étions assis près des pots de viande, quand nous mangions du pain à satiété? Car vous nous avez menés dans ce désert pour faire mourir de faim toute cette multitude. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","L’Éternel dit à Moïse: Voici, je ferai pleuvoir pour vous du pain, du haut des cieux. Le peuple sortira, et en ramassera, jour par jour, la quantité nécessaire, afin que je le mette à l’épreuve, et que je voie s’il marchera, ou non, selon ma loi. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Le sixième jour, lorsqu’ils prépareront ce qu’ils auront apporté, il s’en trouvera le double de ce qu’ils ramasseront jour par jour. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Moïse et Aaron dirent à tous les enfants d’Israël: Ce soir, vous comprendrez que c’est l’Éternel qui vous a fait sortir du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Et, au matin, vous verrez la gloire de l’Éternel, parce qu’il a entendu vos murmures contre l’Éternel; car que sommes-nous, pour que vous murmuriez contre nous? ");
INSERT INTO fraLSG_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Moïse dit: L’Éternel vous donnera ce soir de la viande à manger, et au matin du pain à satiété, parce que l’Éternel a entendu les murmures que vous avez proférés contre lui; car que sommes-nous? Ce n’est pas contre nous que sont vos murmures, c’est contre l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Moïse dit à Aaron: Dis à toute l’assemblée des enfants d’Israël: Approchez-vous devant l’Éternel, car il a entendu vos murmures. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Et tandis qu’Aaron parlait à toute l’assemblée des enfants d’Israël, ils se tournèrent du côté du désert, et voici, la gloire de l’Éternel parut dans la nuée. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","L’Éternel, s’adressant à Moïse, dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","J’ai entendu les murmures des enfants d’Israël. Dis-leur: Entre les deux soirs vous mangerez de la viande, et au matin vous vous rassasierez de pain; et vous saurez que je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Le soir, il survint des cailles qui couvrirent le camp; et, au matin, il y eut une couche de rosée autour du camp. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Quand cette rosée fut dissipée, il y avait à la surface du désert quelque chose de menu comme des grains, quelque chose de menu comme la gelée blanche sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Les enfants d’Israël regardèrent et ils se dirent l’un à l’autre: Qu’est-ce que cela? Car ils ne savaient pas ce que c’était. Moïse leur dit: C’est le pain que L’Éternel vous donne pour nourriture. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Voici ce que l’Éternel a ordonné: Que chacun de vous en ramasse ce qu’il faut pour sa nourriture, un omer par tête, suivant le nombre de vos personnes; chacun en prendra pour ceux qui sont dans sa tente. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Les Israélites firent ainsi; et ils en ramassèrent les uns plus, les autres moins. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","On mesurait ensuite avec l’omer; celui qui avait ramassé plus n’avait rien de trop, et celui qui avait ramassé moins n’en manquait pas. Chacun ramassait ce qu’il fallait pour sa nourriture. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Moïse leur dit: Que personne n’en laisse jusqu’au matin. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ils n’écoutèrent pas Moïse, et il y eut des gens qui en laissèrent jusqu’au matin; mais il s’y mit des vers, et cela devint infect. Moïse fut irrité contre ces gens. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tous les matins, chacun ramassait ce qu’il fallait pour sa nourriture; et quand venait la chaleur du soleil, cela fondait. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Le sixième jour, ils ramassèrent une quantité double de nourriture, deux omers pour chacun. Tous les principaux de l’assemblée vinrent le rapporter à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Et Moïse leur dit: C’est ce que l’Éternel a ordonné. Demain est le jour du repos, le sabbat consacré à l’Éternel; faites cuire ce que vous avez à faire cuire, faites bouillir ce que vous avez à faire bouillir, et mettez en réserve jusqu’au matin tout ce qui restera. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Ils le laissèrent jusqu’au matin, comme Moïse l’avait ordonné; et cela ne devint point infect, et il ne s’y mit point de vers. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Moïse dit: Mangez-le aujourd’hui, car c’est le jour du sabbat; aujourd’hui vous n’en trouverez point dans la campagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Pendant six jours vous en ramasserez; mais le septième jour, qui est le sabbat, il n’y en aura point. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Le septième jour, quelques-uns du peuple sortirent pour en ramasser, et ils n’en trouvèrent point. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Alors l’Éternel dit à Moïse: Jusques à quand refuserez-vous d’observer mes commandements et mes lois? ");
INSERT INTO fraLSG_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Considérez que l’Éternel vous a donné le sabbat; c’est pourquoi il vous donne au sixième jour de la nourriture pour deux jours. Que chacun reste à sa place, et que personne ne sorte du lieu où il est au septième jour. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Et le peuple se reposa le septième jour. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","La maison d’Israël donna à cette nourriture le nom de manne. Elle ressemblait à de la graine de coriandre; elle était blanche, et avait le goût d’un gâteau au miel. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moïse dit: Voici ce que l’Éternel a ordonné: Qu’un omer rempli de manne soit conservé pour vos descendants, afin qu’ils voient le pain que je vous ai fait manger dans le désert, après vous avoir fait sortir du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Et Moïse dit à Aaron: Prends un vase, mets-y de la manne plein un omer, et dépose-le devant l’Éternel, afin qu’il soit conservé pour vos descendants. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Suivant l’ordre donné par l’Éternel à Moïse, Aaron le déposa devant le témoignage, afin qu’il fût conservé. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Les enfants d’Israël mangèrent la manne pendant quarante ans, jusqu’à leur arrivée dans un pays habité; ils mangèrent la manne jusqu’à leur arrivée aux frontières du pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","L’omer est la dixième partie de l’épha. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Toute l’assemblée des enfants d’Israël partit du désert de Sin, selon les marches que l’Éternel leur avait ordonnées; et ils campèrent à Rephidim, où le peuple ne trouva point d’eau à boire. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Alors le peuple chercha querelle à Moïse. Ils dirent: Donnez-nous de l’eau à boire. Moïse leur répondit: Pourquoi me cherchez-vous querelle? Pourquoi tentez-vous l’Éternel? ");
INSERT INTO fraLSG_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Le peuple était là, pressé par la soif, et murmurait contre Moïse. Il disait: Pourquoi nous as-tu fait monter hors d’Égypte, pour me faire mourir de soif avec mes enfants et mes troupeaux? ");
INSERT INTO fraLSG_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moïse cria à l’Éternel, en disant: Que ferai-je à ce peuple? Encore un peu, et ils me lapideront. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","L’Éternel dit à Moïse: Passe devant le peuple, et prends avec toi des anciens d’Israël; prends aussi dans ta main ta verge avec laquelle tu as frappé le fleuve, et marche! ");
INSERT INTO fraLSG_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Voici, je me tiendrai devant toi sur le rocher d’Horeb; tu frapperas le rocher, et il en sortira de l’eau, et le peuple boira. Et Moïse fit ainsi, aux yeux des anciens d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Il donna à ce lieu le nom de Massa et Meriba, parce que les enfants d’Israël avaient contesté, et parce qu’ils avaient tenté l’Éternel, en disant: L’Éternel est-il au milieu de nous, ou n’y est-il pas? ");
INSERT INTO fraLSG_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amalek vint combattre Israël à Rephidim. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Alors Moïse dit à Josué: Choisis-nous des hommes, sors, et combats Amalek; demain je me tiendrai sur le sommet de la colline, la verge de Dieu dans ma main. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Josué fit ce que lui avait dit Moïse, pour combattre Amalek. Et Moïse, Aaron et Hur montèrent au sommet de la colline. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Lorsque Moïse élevait sa main, Israël était le plus fort; et lorsqu’il baissait sa main, Amalek était le plus fort. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Les mains de Moïse étant fatiguées, ils prirent une pierre qu’ils placèrent sous lui, et il s’assit dessus. Aaron et Hur soutenaient ses mains, l’un d’un côté, l’autre de l’autre; et ses mains restèrent fermes jusqu’au coucher du soleil. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Et Josué vainquit Amalek et son peuple, au tranchant de l’épée. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","L’Éternel dit à Moïse: Écris cela dans le livre, pour que le souvenir s’en conserve, et déclare à Josué que j’effacerai la mémoire d’Amalek de dessous les cieux. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Moïse bâtit un autel, et lui donna pour nom: l’Éternel ma bannière. ");
INSERT INTO fraLSG_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Il dit: Parce que la main a été levée sur le trône de l’Éternel, il y aura guerre de l’Éternel contre Amalek, de génération en génération. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Jéthro, sacrificateur de Madian, beau-père de Moïse, apprit tout ce que Dieu avait fait en faveur de Moïse et d’Israël, son peuple; il apprit que l’Éternel avait fait sortir Israël d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Jéthro, beau-père de Moïse, prit Séphora, femme de Moïse, qui avait été renvoyée. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Il prit aussi les deux fils de Séphora; l’un se nommait Guerschom, car Moïse avait dit: J’habite un pays étranger; ");
INSERT INTO fraLSG_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","l’autre se nommait Éliézer, car il avait dit: Le Dieu de mon père m’a secouru, et il m’a délivré de l’épée de Pharaon. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Jéthro, beau-père de Moïse, avec les fils et la femme de Moïse, vint au désert où il campait, à la montagne de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Il fit dire à Moïse: Moi, ton beau-père Jéthro, je viens vers toi, avec ta femme et ses deux fils. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moïse sortit au-devant de son beau-père, il se prosterna, et il le baisa. Ils s’informèrent réciproquement de leur santé, et ils entrèrent dans la tente de Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Moïse raconta à son beau-père tout ce que l’Éternel avait fait à Pharaon et à l’Égypte à cause d’Israël, toutes les souffrances qui leur étaient survenues en chemin, et comment l’Éternel les avait délivrés. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Jéthro se réjouit de tout le bien que l’Éternel avait fait à Israël, et de ce qu’il l’avait délivré de la main des Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Et Jéthro dit: Béni soit l’Éternel, qui vous a délivrés de la main des Égyptiens et de la main de Pharaon; qui a délivré le peuple de la main des Égyptiens! ");
INSERT INTO fraLSG_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Je reconnais maintenant que l’Éternel est plus grand que tous les dieux; car la méchanceté des Égyptiens est retombée sur eux. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jéthro, beau-père de Moïse, offrit à Dieu un holocauste et des sacrifices. Aaron et tous les anciens d’Israël vinrent participer au repas avec le beau-père de Moïse, en présence de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Le lendemain, Moïse s’assit pour juger le peuple, et le peuple se tint devant lui depuis le matin jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Le beau-père de Moïse vit tout ce qu’il faisait pour le peuple, et il dit: Que fais-tu là avec ce peuple? Pourquoi sièges-tu seul, et tout le peuple se tient-il devant toi, depuis le matin jusqu’au soir? ");
INSERT INTO fraLSG_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Moïse répondit à son beau-père: C’est que le peuple vient à moi pour consulter Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Quand ils ont quelque affaire, ils viennent à moi; je prononce entre eux, et je fais connaître les ordonnances de Dieu et ses lois. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Le beau-père de Moïse lui dit: Ce que tu fais n’est pas bien. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Tu t’épuiseras toi-même, et tu épuiseras ce peuple qui est avec toi; car la chose est au-dessus de tes forces, tu ne pourras pas y suffire seul. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Maintenant écoute ma voix; je vais te donner un conseil, et que Dieu soit avec toi! Sois l’interprète du peuple auprès de Dieu, et porte les affaires devant Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Enseigne-leur les ordonnances et les lois; et fais-leur connaître le chemin qu’ils doivent suivre, et ce qu’ils doivent faire. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Choisis parmi tout le peuple des hommes capables, craignant Dieu, des hommes intègres, ennemis de la cupidité; établis-les sur eux comme chefs de mille, chefs de cent, chefs de cinquante et chefs de dix. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Qu’ils jugent le peuple en tout temps; qu’ils portent devant toi toutes les affaires importantes, et qu’ils prononcent eux-mêmes sur les petites causes. Allège ta charge, et qu’ils la portent avec toi. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Si tu fais cela, et que Dieu te donne des ordres, tu pourras y suffire, et tout ce peuple parviendra heureusement à sa destination. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Moïse écouta la voix de son beau-père, et fit tout ce qu’il avait dit. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Moïse choisit des hommes capables parmi tout Israël, et il les établit chefs du peuple, chefs de mille, chefs de cent, chefs de cinquante et chefs de dix. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Ils jugeaient le peuple en tout temps; ils portaient devant Moïse les affaires difficiles, et ils prononçaient eux-mêmes sur toutes les petites causes. ");
INSERT INTO fraLSG_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Moïse laissa partir son beau-père, et Jéthro s’en alla dans son pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Le troisième mois après leur sortie du pays d’Égypte, les enfants d’Israël arrivèrent ce jour-là au désert de Sinaï. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Étant partis de Rephidim, ils arrivèrent au désert de Sinaï, et ils campèrent dans le désert; Israël campa là, vis-à-vis de la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moïse monta vers Dieu: et l’Éternel l’appela du haut de la montagne, en disant: Tu parleras ainsi à la maison de Jacob, et tu diras aux enfants d’Israël: ");
INSERT INTO fraLSG_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Vous avez vu ce que j’ai fait à l’Égypte, et comment je vous ai portés sur des ailes d’aigle et amenés vers moi. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Maintenant, si vous écoutez ma voix, et si vous gardez mon alliance, vous m’appartiendrez entre tous les peuples, car toute la terre est à moi; ");
INSERT INTO fraLSG_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","vous serez pour moi un royaume de sacrificateurs et une nation sainte. Voilà les paroles que tu diras aux enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moïse vint appeler les anciens du peuple, et il mit devant eux toutes ces paroles, comme l’Éternel le lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Le peuple tout entier répondit: Nous ferons tout ce que l’Éternel a dit. Moïse rapporta les paroles du peuple à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Et l’Éternel dit à Moïse: Voici, je viendrai vers toi dans une épaisse nuée, afin que le peuple entende quand je te parlerai, et qu’il ait toujours confiance en toi. Moïse rapporta les paroles du peuple à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Et l’Éternel dit à Moïse: Va vers le peuple; sanctifie-les aujourd’hui et demain, qu’ils lavent leurs vêtements. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Qu’ils soient prêts pour le troisième jour; car le troisième jour l’Éternel descendra, aux yeux de tout le peuple, sur la montagne de Sinaï. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Tu fixeras au peuple des limites tout à l’entour, et tu diras: Gardez-vous de monter sur la montagne, ou d’en toucher le bord. Quiconque touchera la montagne sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","On ne mettra pas la main sur lui, mais on le lapidera, ou on le percera de flèches: animal ou homme, il ne vivra point. Quand la trompette sonnera, ils s’avanceront près de la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Moïse descendit de la montagne vers le peuple; il sanctifia le peuple, et ils lavèrent leurs vêtements. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Et il dit au peuple: Soyez prêts dans trois jours; ne vous approchez d’aucune femme. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Le troisième jour au matin, il y eut des tonnerres, des éclairs, et une épaisse nuée sur la montagne; le son de la trompette retentit fortement; et tout le peuple qui était dans le camp fut saisi d’épouvante. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moïse fit sortir le peuple du camp, à la rencontre de Dieu; et ils se placèrent au bas de la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","La montagne de Sinaï était toute en fumée, parce que l’Éternel y était descendu au milieu du feu; cette fumée s’élevait comme la fumée d’une fournaise, et toute la montagne tremblait avec violence. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Le son de la trompette retentissait de plus en plus fortement. Moïse parlait, et Dieu lui répondait à haute voix. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ainsi l’Éternel descendit sur la montagne de Sinaï, sur le sommet de la montagne; l’Éternel appela Moïse sur le sommet de la montagne. Et Moïse monta. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","L’Éternel dit à Moïse: Descends, fais au peuple la défense expresse de se précipiter vers l’Éternel, pour regarder, de peur qu’un grand nombre d’entre eux ne périssent. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Que les sacrificateurs, qui s’approchent de l’Éternel, se sanctifient aussi, de peur que l’Éternel ne les frappe de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moïse dit à l’Éternel: Le peuple ne pourra pas monter sur la montagne de Sinaï, car tu nous en as fait la défense expresse, en disant: Fixe des limites autour de la montagne, et sanctifie-la. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","L’Éternel lui dit: Va, descends; tu monteras ensuite avec Aaron; mais que les sacrificateurs et le peuple ne se précipitent point pour monter vers l’Éternel, de peur qu’il ne les frappe de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Moïse descendit vers le peuple, et lui dit ces choses. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Alors Dieu prononça toutes ces paroles, en disant: ");
INSERT INTO fraLSG_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Je suis l’Éternel, ton Dieu, qui t’ai fait sortir du pays d’Égypte, de la maison de servitude. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Tu n’auras pas d’autres dieux devant ma face. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Tu ne te feras point d’image taillée, ni de représentation quelconque des choses qui sont en haut dans les cieux, qui sont en bas sur la terre, et qui sont dans les eaux plus bas que la terre. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Tu ne te prosterneras point devant elles, et tu ne les serviras point; car moi, l’Éternel, ton Dieu, je suis un Dieu jaloux, qui punis l’iniquité des pères sur les enfants jusqu’à la troisième et la quatrième génération de ceux qui me haïssent, ");
INSERT INTO fraLSG_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","et qui fais miséricorde jusqu’en mille générations à ceux qui m’aiment et qui gardent mes commandements. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Tu ne prendras point le nom de l’Éternel, ton Dieu, en vain; car l’Éternel ne laissera point impuni celui qui prendra son nom en vain. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Souviens-toi du jour du repos, pour le sanctifier. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Tu travailleras six jours, et tu feras tout ton ouvrage. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Mais le septième jour est le jour du repos de l’Éternel, ton Dieu: tu ne feras aucun ouvrage, ni toi, ni ton fils, ni ta fille, ni ton serviteur, ni ta servante, ni ton bétail, ni l’étranger qui est dans tes portes. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Car en six jours l’Éternel a fait les cieux, la terre et la mer, et tout ce qui y est contenu, et il s’est reposé le septième jour: c’est pourquoi l’Éternel a béni le jour du repos et l’a sanctifié. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Honore ton père et ta mère, afin que tes jours se prolongent dans le pays que l’Éternel, ton Dieu, te donne. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Tu ne tueras point. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Tu ne commettras point d’adultère. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Tu ne déroberas point. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Tu ne porteras point de faux témoignage contre ton prochain. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Tu ne convoiteras point la maison de ton prochain; tu ne convoiteras point la femme de ton prochain, ni son serviteur, ni sa servante, ni son bœuf, ni son âne, ni aucune chose qui appartienne à ton prochain. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Tout le peuple entendait les tonnerres et le son de la trompette; il voyait les flammes de la montagne fumante. A ce spectacle, le peuple tremblait, et se tenait dans l’éloignement. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Ils dirent à Moïse: Parle-nous toi-même, et nous écouterons; mais que Dieu ne nous parle point, de peur que nous ne mourions. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Moïse dit au peuple: Ne vous effrayez pas; car c’est pour vous mettre à l’épreuve que Dieu est venu, et c’est pour que vous ayez sa crainte devant les yeux, afin que vous ne péchiez point. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Le peuple restait dans l’éloignement; mais Moïse s’approcha de la nuée où était Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","L’Éternel dit à Moïse: Tu parleras ainsi aux enfants d’Israël: Vous avez vu que je vous ai parlé depuis les cieux. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Vous ne ferez point des dieux d’argent et des dieux d’or, pour me les associer; vous ne vous en ferez point. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Tu m’élèveras un autel de terre, sur lequel tu offriras tes holocaustes et tes sacrifices d’actions de grâces, tes brebis et tes bœufs. Partout où je rappellerai mon nom, je viendrai à toi, et je te bénirai. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Si tu m’élèves un autel de pierre, tu ne le bâtiras point en pierres taillées; car en passant ton ciseau sur la pierre, tu la profanerais. ");
INSERT INTO fraLSG_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Tu ne monteras point à mon autel par des degrés, afin que ta nudité ne soit pas découverte. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Voici les lois que tu leur présenteras. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Si tu achètes un esclave hébreu, il servira six années; mais la septième, il sortira libre, sans rien payer. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","S’il est entré seul, il sortira seul; s’il avait une femme, sa femme sortira avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Si c’est son maître qui lui a donné une femme, et qu’il en ait eu des fils ou des filles, la femme et ses enfants seront à son maître, et il sortira seul. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Si l’esclave dit: J’aime mon maître, ma femme et mes enfants, je ne veux pas sortir libre, ");
INSERT INTO fraLSG_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","alors son maître le conduira devant Dieu, et le fera approcher de la porte ou du poteau, et son maître lui percera l’oreille avec un poinçon, et l’esclave sera pour toujours à son service. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Si un homme vend sa fille pour être esclave, elle ne sortira point comme sortent les esclaves. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Si elle déplaît à son maître, qui s’était proposé de la prendre pour femme, il facilitera son rachat; mais il n’aura pas le pouvoir de la vendre à des étrangers, après lui avoir été infidèle. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","S’il la destine à son fils, il agira envers elle selon le droit des filles. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","S’il prend une autre femme, il ne retranchera rien pour la première à la nourriture, au vêtement, et au droit conjugal. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Et s’il ne fait pas pour elle ces trois choses, elle pourra sortir sans rien payer, sans donner de l’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Celui qui frappera un homme mortellement sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","S’il ne lui a point dressé d’embûches, et que Dieu l’ait fait tomber sous sa main, je t’établirai un lieu où il pourra se réfugier. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Mais si quelqu’un agit méchamment contre son prochain, en employant la ruse pour le tuer, tu l’arracheras même de mon autel, pour le faire mourir. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Celui qui frappera son père ou sa mère sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Celui qui dérobera un homme, et qui l’aura vendu ou retenu entre ses mains, sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Celui qui maudira son père ou sa mère sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Si des hommes se querellent, et que l’un d’eux frappe l’autre avec une pierre ou avec le poing, sans causer sa mort, mais en l’obligeant à garder le lit, ");
INSERT INTO fraLSG_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","celui qui aura frappé ne sera point puni, dans le cas où l’autre viendrait à se lever et à se promener dehors avec son bâton. Seulement, il le dédommagera de son interruption de travail, et il le fera soigner jusqu’à sa guérison. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Si un homme frappe du bâton son esclave, homme ou femme, et que l’esclave meure sous sa main, le maître sera puni. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Mais s’il survit un jour ou deux, le maître ne sera point puni; car c’est son argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Si des hommes se querellent, et qu’ils heurtent une femme enceinte, et la fassent accoucher, sans autre accident, ils seront punis d’une amende imposée par le mari de la femme, et qu’ils paieront devant les juges. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Mais s’il y a un accident, tu donneras vie pour vie, ");
INSERT INTO fraLSG_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","œil pour œil, dent pour dent, main pour main, pied pour pied, ");
INSERT INTO fraLSG_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","brûlure pour brûlure, blessure pour blessure, meurtrissure pour meurtrissure. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Si un homme frappe l’œil de son esclave, homme ou femme, et qu’il lui fasse perdre l’œil, il le mettra en liberté, pour prix de son œil. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Et s’il fait tomber une dent à son esclave, homme ou femme, il le mettra en liberté, pour prix de sa dent. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Si un bœuf frappe de ses cornes un homme ou une femme, et que la mort en soit la suite, le bœuf sera lapidé, sa chair ne sera point mangée, et le maître du bœuf ne sera point puni. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Mais si le bœuf était auparavant sujet à frapper, et qu’on en ait averti le maître, qui ne l’a point surveillé, le bœuf sera lapidé, dans le cas où il tuerait un homme ou une femme, et son maître sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Si on impose au maître un prix pour le rachat de sa vie, il paiera tout ce qui lui sera imposé. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Lorsque le bœuf frappera un fils ou une fille, cette loi recevra son application; ");
INSERT INTO fraLSG_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","mais si le bœuf frappe un esclave, homme ou femme, on donnera trente sicles d’argent au maître de l’esclave, et le bœuf sera lapidé. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Si un homme met à découvert une citerne, ou si un homme en creuse une et ne la couvre pas, et qu’il y tombe un bœuf ou un âne, ");
INSERT INTO fraLSG_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","le possesseur de la citerne paiera au maître la valeur de l’animal en argent, et aura pour lui l’animal mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Si le bœuf d’un homme frappe de ses cornes le bœuf d’un autre homme, et que la mort en soit la suite, ils vendront le bœuf vivant et en partageront le prix; ils partageront aussi le bœuf mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Mais s’il est connu que le bœuf était auparavant sujet à frapper, et que son maître ne l’ait point surveillé, ce maître rendra bœuf pour bœuf, et aura pour lui le bœuf mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Si un homme dérobe un bœuf ou un agneau, et qu’il l’égorge ou le vende, il restituera cinq bœufs pour le bœuf et quatre agneaux pour l’agneau. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Si le voleur est surpris dérobant avec effraction, et qu’il soit frappé et meure, on ne sera point coupable de meurtre envers lui; ");
INSERT INTO fraLSG_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","mais si le soleil est levé, on sera coupable de meurtre envers lui. Il fera restitution; s’il n’a rien, il sera vendu pour son vol; ");
INSERT INTO fraLSG_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","si ce qu’il a dérobé, bœuf, âne, ou agneau, se trouve encore vivant entre ses mains, il fera une restitution au double. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Si un homme fait du dégât dans un champ ou dans une vigne, et qu’il laisse son bétail paître dans le champ d’autrui, il donnera en dédommagement le meilleur produit de son champ et de sa vigne. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Si un feu éclate et rencontre des épines, et que du blé en gerbes ou sur pied, ou bien le champ, soit consumé, celui qui a causé l’incendie sera tenu à un dédommagement. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Si un homme donne à un autre de l’argent ou des objets à garder, et qu’on les vole dans la maison de ce dernier, le voleur fera une restitution au double, dans le cas où il serait trouvé. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Si le voleur ne se trouve pas, le maître de la maison se présentera devant Dieu, pour déclarer qu’il n’a pas mis la main sur le bien de son prochain. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Dans toute affaire frauduleuse concernant un bœuf, un âne, un agneau, un vêtement, ou un objet perdu, au sujet duquel on dira: C’est cela! — la cause des deux parties ira jusqu’à Dieu; celui que Dieu condamnera fera à son prochain une restitution au double. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Si un homme donne à un autre un âne, un bœuf, un agneau, ou un animal quelconque à garder, et que l’animal meure, se casse un membre, ou soit enlevé, sans que personne l’ait vu, ");
INSERT INTO fraLSG_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","le serment au nom de l’Éternel interviendra entre les deux parties, et celui qui a gardé l’animal déclarera qu’il n’a pas mis la main sur le bien de son prochain; le maître de l’animal acceptera ce serment, et l’autre ne sera point tenu à une restitution. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Mais si l’animal a été dérobé chez lui, il sera tenu vis-à-vis de son maître à une restitution. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Si l’animal a été déchiré, il le produira en témoignage, et il ne sera point tenu à une restitution pour ce qui a été déchiré. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Si un homme emprunte à un autre un animal, et que l’animal se casse un membre ou qu’il meure, en l’absence de son maître, il y aura lieu à restitution. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Si le maître est présent, il n’y aura pas lieu à restitution. Si l’animal a été loué, le prix du louage suffira. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Si un homme séduit une vierge qui n’est point fiancée, et qu’il couche avec elle, il paiera sa dot et la prendra pour femme. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Si le père refuse de la lui accorder, il paiera en argent la valeur de la dot des vierges. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Tu ne laisseras point vivre la magicienne. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Quiconque couche avec une bête sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Celui qui offre des sacrifices à d’autres dieux qu’à l’Éternel seul sera voué à l’extermination. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Tu ne maltraiteras point l’étranger, et tu ne l’opprimeras point; car vous avez été étrangers dans le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Tu n’affligeras point la veuve, ni l’orphelin. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Si tu les affliges, et qu’ils viennent à moi, j’entendrai leurs cris; ");
INSERT INTO fraLSG_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ma colère s’enflammera, et je vous détruirai par l’épée; vos femmes deviendront veuves, et vos enfants orphelins. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Si tu prêtes de l’argent à mon peuple, au pauvre qui est avec toi, tu ne seras point à son égard comme un créancier, tu n’exigeras de lui point d’intérêt. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si tu prends en gage le vêtement de ton prochain, tu le lui rendras avant le coucher du soleil; ");
INSERT INTO fraLSG_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","car c’est sa seule couverture, c’est le vêtement dont il s’enveloppe le corps: dans quoi coucherait-il? S’il crie à moi, je l’entendrai, car je suis miséricordieux. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Tu ne maudiras point Dieu, et tu ne maudiras point le prince de ton peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Tu ne différeras point de m’offrir les prémices de ta moisson et de ta vendange. Tu me donneras le premier-né de tes fils. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Tu me donneras aussi le premier-né de ta vache et de ta brebis; il restera sept jours avec sa mère; le huitième jour, tu me le donneras. ");
INSERT INTO fraLSG_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Vous serez pour moi des hommes saints. Vous ne mangerez point de chair déchirée dans les champs: vous la jetterez aux chiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Tu ne répandras point de faux bruit. Tu ne te joindras point au méchant pour faire un faux témoignage. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Tu ne suivras point la multitude pour faire le mal; et tu ne déposeras point dans un procès en te mettant du côté du grand nombre, pour violer la justice. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Tu ne favoriseras point le pauvre dans son procès. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Si tu rencontres le bœuf de ton ennemi ou son âne égaré, tu le lui ramèneras. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Si tu vois l’âne de ton ennemi succombant sous sa charge, et que tu hésites à le décharger, tu l’aideras à le décharger. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Tu ne porteras point atteinte au droit du pauvre dans son procès. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Tu ne prononceras point de sentence inique, et tu ne feras point mourir l’innocent et le juste; car je n’absoudrai point le coupable. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Tu ne recevras point de présent; car les présents aveuglent ceux qui ont les yeux ouverts et corrompent les paroles des justes. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Tu n’opprimeras point l’étranger; vous savez ce qu’éprouve l’étranger, car vous avez été étrangers dans le pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Pendant six années, tu ensemenceras la terre, et tu en recueilleras le produit. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Mais la septième, tu lui donneras du relâche et tu la laisseras en repos; les pauvres de ton peuple en jouiront, et les bêtes des champs mangeront ce qui restera. Tu feras de même pour ta vigne et pour tes oliviers. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Pendant six jours, tu feras ton ouvrage. Mais le septième jour, tu te reposeras, afin que ton bœuf et ton âne aient du repos, afin que le fils de ton esclave et l’étranger aient du relâche. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Vous observerez tout ce que je vous ai dit, et vous ne prononcerez point le nom d’autres dieux: qu’on ne l’entende point sortir de votre bouche. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Trois fois par année, tu célébreras des fêtes en mon honneur. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Tu observeras la fête des pains sans levain; pendant sept jours, au temps fixé dans le mois des épis, tu mangeras des pains sans levain, comme je t’en ai donné l’ordre, car c’est dans ce mois que tu es sorti d’Égypte; et l’on ne se présentera point à vide devant ma face. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Tu observeras la fête de la moisson, des prémices de ton travail, de ce que tu auras semé dans les champs; et la fête de la récolte, à la fin de l’année, quand tu recueilleras des champs le fruit de ton travail. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Trois fois par année, tous les mâles se présenteront devant le Seigneur, l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Tu n’offriras point avec du pain levé le sang de la victime sacrifiée en mon honneur; et sa graisse ne sera point gardée pendant la nuit jusqu’au matin. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Tu apporteras à la maison de l’Éternel, ton Dieu, les prémices des premiers fruits de la terre. Tu ne feras point cuire un chevreau dans le lait de sa mère. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Voici, j’envoie un ange devant toi, pour te protéger en chemin, et pour te faire arriver au lieu que j’ai préparé. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Tiens-toi sur tes gardes en sa présence, et écoute sa voix; ne lui résiste point, parce qu’il ne pardonnera pas vos péchés, car mon nom est en lui. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Mais si tu écoutes sa voix, et si tu fais tout ce que je te dirai, je serai l’ennemi de tes ennemis et l’adversaire de tes adversaires. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mon ange marchera devant toi, et te conduira chez les Amoréens, les Héthiens, les Phéréziens, les Cananéens, les Héviens et les Jébusiens, et je les exterminerai. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Tu ne te prosterneras point devant leurs dieux, et tu ne les serviras point; tu n’imiteras point ces peuples dans leur conduite, mais tu les détruiras, et tu briseras leurs statues. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Vous servirez l’Éternel, votre Dieu, et il bénira votre pain et vos eaux, et j’éloignerai la maladie du milieu de toi. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Il n’y aura dans ton pays ni femme qui avorte, ni femme stérile. Je remplirai le nombre de tes jours. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","J’enverrai ma terreur devant toi, je mettrai en déroute tous les peuples chez lesquels tu arriveras, et je ferai tourner le dos devant toi à tous tes ennemis. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","J’enverrai les frelons devant toi, et ils chasseront loin de ta face les Héviens, les Cananéens et les Héthiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Je ne les chasserai pas en une seule année loin de ta face, de peur que le pays ne devienne un désert et que les bêtes des champs ne se multiplient contre toi. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Je les chasserai peu à peu loin de ta face, jusqu’à ce que tu augmentes en nombre et que tu puisses prendre possession du pays. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","J’établirai tes limites depuis la mer Rouge jusqu’à la mer des Philistins, et depuis le désert jusqu’au fleuve; car je livrerai entre vos mains les habitants du pays, et tu les chasseras devant toi. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tu ne feras point d’alliance avec eux, ni avec leurs dieux. ");
INSERT INTO fraLSG_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ils n’habiteront point dans ton pays, de peur qu’ils ne te fassent pécher contre moi; car tu servirais leurs dieux, et ce serait un piège pour toi. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Dieu dit à Moïse: Monte vers l’Éternel, toi et Aaron, Nadab et Abihu, et soixante-dix des anciens d’Israël, et vous vous prosternerez de loin. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moïse s’approchera seul de l’Éternel; les autres ne s’approcheront pas, et le peuple ne montera point avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moïse vint rapporter au peuple toutes les paroles de l’Éternel et toutes les lois. Le peuple entier répondit d’une même voix: Nous ferons tout ce que l’Éternel a dit. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moïse écrivit toutes les paroles de l’Éternel. Puis il se leva de bon matin; il bâtit un autel au pied de la montagne, et dressa douze pierres pour les douze tribus d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Il envoya des jeunes hommes, enfants d’Israël, pour offrir à l’Éternel des holocaustes, et immoler des taureaux en sacrifices d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Moïse prit la moitié du sang, qu’il mit dans des bassins, et il répandit l’autre moitié sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Il prit le livre de l’alliance, et le lut en présence du peuple; ils dirent: Nous ferons tout ce que l’Éternel a dit, et nous obéirons. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moïse prit le sang, et il le répandit sur le peuple, en disant: Voici le sang de l’alliance que l’Éternel a faite avec vous selon toutes ces paroles. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moïse monta avec Aaron, Nadab et Abihu, et soixante-dix anciens d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Ils virent le Dieu d’Israël; sous ses pieds, c’était comme un ouvrage de saphir transparent, comme le ciel lui-même dans sa pureté. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Il n’étendit point sa main sur l’élite des enfants d’Israël. Ils virent Dieu, et ils mangèrent et burent. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","L’Éternel dit à Moïse: Monte vers moi sur la montagne, et reste là; je te donnerai des tables de pierre, la loi et les ordonnances que j’ai écrites pour leur instruction. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Moïse se leva, avec Josué qui le servait, et Moïse monta sur la montagne de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Il dit aux anciens: Attendez-nous ici, jusqu’à ce que nous revenions auprès de vous. Voici, Aaron et Hur resteront avec vous; si quelqu’un a un différend, c’est à eux qu’il s’adressera. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moïse monta sur la montagne, et la nuée couvrit la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","La gloire de l’Éternel reposa sur la montagne de Sinaï, et la nuée la couvrit pendant six jours. Le septième jour, l’Éternel appela Moïse du milieu de la nuée. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","L’aspect de la gloire de l’Éternel était comme un feu dévorant sur le sommet de la montagne, aux yeux des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Moïse entra au milieu de la nuée, et il monta sur la montagne. Moïse demeura sur la montagne quarante jours et quarante nuits. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Parle aux enfants d’Israël. Qu’ils m’apportent une offrande; vous la recevrez pour moi de tout homme qui la fera de bon cœur. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Voici ce que vous recevrez d’eux en offrande: de l’or, de l’argent et de l’airain; ");
INSERT INTO fraLSG_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","des étoffes teintes en bleu, en pourpre, en cramoisi, du fin lin et du poil de chèvre; ");
INSERT INTO fraLSG_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","des peaux de béliers teintes en rouge et des peaux de dauphins; du bois d’acacia; ");
INSERT INTO fraLSG_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","de l’huile pour le chandelier, des aromates pour l’huile d’onction et pour le parfum odoriférant; ");
INSERT INTO fraLSG_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","des pierres d’onyx et d’autres pierres pour la garniture de l’éphod et du pectoral. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ils me feront un sanctuaire, et j’habiterai au milieu d’eux. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Vous ferez le tabernacle et tous ses ustensiles d’après le modèle que je vais te montrer. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ils feront une arche de bois d’acacia, sa longueur sera de deux coudées et demie, sa largeur d’une coudée et demie, et sa hauteur d’une coudée et demie. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Tu la couvriras d’or pur, tu la couvriras en dedans et en dehors, et tu y feras une bordure d’or tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Tu fondras pour elle quatre anneaux d’or, et tu les mettras à ses quatre coins, deux anneaux d’un côté et deux anneaux de l’autre côté. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Tu feras des barres de bois d’acacia, et tu les couvriras d’or. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Tu passeras les barres dans les anneaux sur les côtés de l’arche, pour qu’elles servent à porter l’arche; ");
INSERT INTO fraLSG_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","les barres resteront dans les anneaux de l’arche, et n’en seront point retirées. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Tu mettras dans l’arche le témoignage, que je te donnerai. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Tu feras un propitiatoire d’or pur; sa longueur sera de deux coudées et demie, et sa largeur d’une coudée et demie. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tu feras deux chérubins d’or, tu les feras d’or battu, aux deux extrémités du propitiatoire; ");
INSERT INTO fraLSG_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","fais un chérubin à l’une des extrémités et un chérubin à l’autre extrémité; vous ferez les chérubins sortant du propitiatoire à ses deux extrémités. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Les chérubins étendront les ailes par-dessus, couvrant de leurs ailes le propitiatoire, et se faisant face l’un à l’autre; les chérubins auront la face tournée vers le propitiatoire. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tu mettras le propitiatoire sur l’arche, et tu mettras dans l’arche le témoignage, que je te donnerai. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","C’est là que je me rencontrerai avec toi; du haut du propitiatoire, entre les deux chérubins placés sur l’arche du témoignage, je te donnerai tous mes ordres pour les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Tu feras une table de bois d’acacia; sa longueur sera de deux coudées, sa largeur d’une coudée, et sa hauteur d’une coudée et demie. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Tu la couvriras d’or pur, et tu y feras une bordure d’or tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Tu y feras à l’entour un rebord de quatre doigts, sur lequel tu mettras une bordure d’or tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Tu feras pour la table quatre anneaux d’or, et tu mettras les anneaux aux quatre coins, qui seront à ses quatre pieds. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Les anneaux seront près du rebord, et recevront les barres pour porter la table. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tu feras les barres de bois d’acacia, et tu les couvriras d’or; et elles serviront à porter la table. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Tu feras ses plats, ses coupes, ses calices et ses tasses, pour servir aux libations; tu les feras d’or pur. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Tu mettras sur la table les pains de proposition continuellement devant ma face. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Tu feras un chandelier d’or pur; ce chandelier sera fait d’or battu; son pied, sa tige, ses calices, ses pommes et ses fleurs seront d’une même pièce. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Six branches sortiront de ses côtés, trois branches du chandelier de l’un des côtés, et trois branches du chandelier de l’autre côté. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Il y aura sur une branche trois calices en forme d’amande, avec pommes et fleurs, et sur une autre branche trois calices en forme d’amande, avec pommes et fleurs; il en sera de même pour les six branches sortant du chandelier. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","A la tige du chandelier, il y aura quatre calices en forme d’amande, avec leurs pommes et leurs fleurs. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Il y aura une pomme sous deux des branches sortant de la tige du chandelier, une pomme sous deux autres branches, et une pomme sous deux autres branches; il en sera de même pour les six branches sortant du chandelier. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Les pommes et les branches du chandelier seront d’une même pièce: il sera tout entier d’or battu, d’or pur. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Tu feras ses sept lampes, qui seront placées dessus, de manière à éclairer en face. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ses mouchettes et ses vases à cendre seront d’or pur. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","On emploiera un talent d’or pur pour faire le chandelier avec tous ses ustensiles. ");
INSERT INTO fraLSG_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Regarde, et fais d’après le modèle qui t’est montré sur la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Tu feras le tabernacle de dix tapis de fin lin retors, et d’étoffes teintes en bleu, en pourpre et en cramoisi; tu y représenteras des chérubins artistement travaillés. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","La longueur d’un tapis sera de vingt-huit coudées, et la largeur d’un tapis sera de quatre coudées; la mesure sera la même pour tous les tapis. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Cinq de ces tapis seront joints ensemble; les cinq autres seront aussi joints ensemble. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tu feras des lacets bleus au bord du tapis terminant le premier assemblage; et tu feras de même au bord du tapis terminant le second assemblage. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Tu mettras cinquante lacets au premier tapis, et tu mettras cinquante lacets au bord du tapis terminant le second assemblage; ces lacets se correspondront les uns aux autres. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Tu feras cinquante agrafes d’or, et tu joindras les tapis l’un à l’autre avec les agrafes. Et le tabernacle formera un tout. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Tu feras des tapis de poil de chèvre, pour servir de tente sur le tabernacle; tu feras onze de ces tapis. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","La longueur d’un tapis sera de trente coudées, et la largeur d’un tapis sera de quatre coudées; la mesure sera la même pour les onze tapis. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tu joindras séparément cinq de ces tapis, et les six autres séparément, et tu redoubleras le sixième tapis sur le devant de la tente. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Tu mettras cinquante lacets au bord du tapis terminant le premier assemblage, et cinquante lacets au bord du tapis du second assemblage. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tu feras cinquante agrafes d’airain, et tu feras entrer les agrafes dans les lacets. Tu assembleras ainsi la tente, qui fera un tout. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Comme il y aura du surplus dans les tapis de la tente, la moitié du tapis de reste retombera sur le derrière du tabernacle; ");
INSERT INTO fraLSG_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","la coudée d’une part, et la coudée d’autre part, qui seront de reste sur la longueur des tapis de la tente, retomberont sur les deux côtés du tabernacle, pour le couvrir. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tu feras pour la tente une couverture de peaux de béliers teintes en rouge, et une couverture de peaux de dauphins par-dessus. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Tu feras des planches pour le tabernacle; elles seront de bois d’acacia, placées debout. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","La longueur d’une planche sera de dix coudées, et la largeur d’une planche sera d’une coudée et demie. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Il y aura à chaque planche deux tenons joints l’un à l’autre; tu feras de même pour toutes les planches du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Tu feras vingt planches pour le tabernacle, du côté du midi. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Tu mettras quarante bases d’argent sous les vingt planches, deux bases sous chaque planche pour ses deux tenons. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Tu feras vingt planches pour le second côté du tabernacle, le côté du nord, ");
INSERT INTO fraLSG_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","et leurs quarante bases d’argent, deux bases sous chaque planche. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Tu feras six planches pour le fond du tabernacle, du côté de l’occident. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Tu feras deux planches pour les angles du tabernacle, dans le fond; ");
INSERT INTO fraLSG_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","elles seront doubles depuis le bas, et bien liées à leur sommet par un anneau; il en sera de même pour toutes les deux, placées aux deux angles. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Il y aura ainsi huit planches, avec leurs bases d’argent, soit seize bases, deux bases sous chaque planche. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Tu feras cinq barres de bois d’acacia pour les planches de l’un des côtés du tabernacle, ");
INSERT INTO fraLSG_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","cinq barres pour les planches du second côté du tabernacle, et cinq barres pour les planches du côté du tabernacle formant le fond vers l’occident. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","La barre du milieu traversera les planches d’une extrémité à l’autre. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tu couvriras d’or les planches, et tu feras d’or leurs anneaux qui recevront les barres, et tu couvriras d’or les barres. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tu dresseras le tabernacle d’après le modèle qui t’est montré sur la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Tu feras un voile bleu, pourpre et cramoisi, et de fin lin retors; il sera artistement travaillé, et l’on y représentera des chérubins. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Tu le mettras sur quatre colonnes d’acacia, couvertes d’or; ces colonnes auront des crochets d’or, et poseront sur quatre bases d’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Tu mettras le voile au-dessous des agrafes, et c’est là, en dedans du voile, que tu feras entrer l’arche du témoignage; le voile vous servira de séparation entre le lieu saint et le lieu très saint. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Tu mettras le propitiatoire sur l’arche du témoignage dans le lieu très saint. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Tu mettras la table en dehors du voile, et le chandelier en face de la table, au côté méridional du tabernacle; et tu mettras la table au côté septentrional. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Tu feras pour l’entrée de la tente un rideau bleu, pourpre et cramoisi, et de fin lin retors; ce sera un ouvrage de broderie. ");
INSERT INTO fraLSG_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tu feras pour le rideau cinq colonnes d’acacia, et tu les couvriras d’or; elles auront des crochets d’or, et tu fondras pour elles cinq bases d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Tu feras l’autel de bois d’acacia; sa longueur sera de cinq coudées, et sa largeur de cinq coudées. L’autel sera carré, et sa hauteur sera de trois coudées. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Tu feras, aux quatre coins, des cornes qui sortiront de l’autel; et tu le couvriras d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Tu feras pour l’autel des cendriers, des pelles, des bassins, des fourchettes et des brasiers; tu feras d’airain tous ses ustensiles. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Tu feras à l’autel une grille d’airain, en forme de treillis, et tu mettras quatre anneaux d’airain aux quatre coins du treillis. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Tu le placeras au-dessous du rebord de l’autel, à partir du bas, jusqu’à la moitié de la hauteur de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Tu feras des barres pour l’autel, des barres de bois d’acacia, et tu les couvriras d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","On passera les barres dans les anneaux; et les barres seront aux deux côtés de l’autel, quand on le portera. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tu le feras creux, avec des planches; il sera fait tel qu’il t’est montré sur la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Tu feras le parvis du tabernacle. Du côté du midi, il y aura, pour former le parvis, des toiles de fin lin retors, sur une longueur de cent coudées pour ce premier côté, ");
INSERT INTO fraLSG_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","avec vingt colonnes posant sur vingt bases d’airain; les crochets des colonnes et leurs tringles seront d’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Du côté du nord, il y aura également des toiles sur une longueur de cent coudées, avec vingt colonnes et leurs vingt bases d’airain; les crochets des colonnes et leurs tringles seront d’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Du côté de l’occident, il y aura pour la largeur du parvis cinquante coudées de toiles, avec dix colonnes et leurs dix bases. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Du côté de l’orient, sur les cinquante coudées de largeur du parvis, ");
INSERT INTO fraLSG_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","il y aura quinze coudées de toiles pour une aile, avec trois colonnes et leurs trois bases, ");
INSERT INTO fraLSG_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","et quinze coudées de toiles pour la seconde aile, avec trois colonnes et leurs trois bases. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Pour la porte du parvis il y aura un rideau de vingt coudées, bleu, pourpre et cramoisi, et de fin lin retors, en ouvrage de broderie, avec quatre colonnes et leurs quatre bases. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Toutes les colonnes formant l’enceinte du parvis auront des tringles d’argent, des crochets d’argent, et des bases d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","La longueur du parvis sera de cent coudées, sa largeur de cinquante de chaque côté, et sa hauteur de cinq coudées; les toiles seront de fin lin retors, et les bases d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tous les ustensiles destinés au service du tabernacle, tous ses pieux, et tous les pieux du parvis, seront d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Tu ordonneras aux enfants d’Israël de t’apporter pour le chandelier de l’huile pure d’olives concassées, afin d’entretenir les lampes continuellement. ");
INSERT INTO fraLSG_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","C’est dans la tente d’assignation, en dehors du voile qui est devant le témoignage, qu’Aaron et ses fils la prépareront, pour que les lampes brûlent du soir au matin en présence de l’Éternel. C’est une loi perpétuelle pour leurs descendants, et que devront observer les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Fais approcher de toi Aaron, ton frère, et ses fils, et prends-les parmi les enfants d’Israël pour les consacrer à mon service dans le sacerdoce: Aaron et les fils d’Aaron, Nadab, Abihu, Éléazar et Ithamar. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Tu feras à Aaron, ton frère, des vêtements sacrés, pour marquer sa dignité et pour lui servir de parure. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Tu parleras à tous ceux qui sont habiles, à qui j’ai donné un esprit plein d’intelligence; et ils feront les vêtements d’Aaron, afin qu’il soit consacré et qu’il exerce mon sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Voici les vêtements qu’ils feront: un pectoral, un éphod, une robe, une tunique brodée, une tiare, et une ceinture. Ils feront des vêtements sacrés à Aaron, ton frère, et à ses fils, afin qu’ils exercent mon sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ils emploieront de l’or, des étoffes teintes en bleu, en pourpre, en cramoisi, et de fin lin. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ils feront l’éphod d’or, de fil bleu, pourpre et cramoisi, et de fin lin retors; il sera artistement travaillé. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","On y fera deux épaulettes, qui le joindront par ses deux extrémités; et c’est ainsi qu’il sera joint. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","La ceinture sera du même travail que l’éphod et fixée sur lui; elle sera d’or, de fil bleu, pourpre et cramoisi, et de fin lin retors. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Tu prendras deux pierres d’onyx, et tu y graveras les noms des fils d’Israël, ");
INSERT INTO fraLSG_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","six de leurs noms sur une pierre, et les six autres sur la seconde pierre, d’après l’ordre des naissances. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Tu graveras sur les deux pierres les noms des fils d’Israël, comme on grave les pierres et les cachets; tu les entoureras de montures d’or. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Tu mettras les deux pierres sur les épaulettes de l’éphod, en souvenir des fils d’Israël; et c’est comme souvenir qu’Aaron portera leurs noms devant l’Éternel sur ses deux épaules. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Tu feras des montures d’or, ");
INSERT INTO fraLSG_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","et deux chaînettes d’or pur, que tu tresseras en forme de cordons; et tu fixeras aux montures les chaînettes ainsi tressées. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Tu feras le pectoral du jugement, artistement travaillé; tu le feras du même travail que l’éphod, tu le feras d’or, de fil bleu, pourpre et cramoisi, et de fin lin retors. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Il sera carré et double; sa longueur sera d’un empan, et sa largeur d’un empan. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Tu y enchâsseras une garniture de pierres, quatre rangées de pierres: première rangée, une sardoine, une topaze, une émeraude; ");
INSERT INTO fraLSG_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","seconde rangée, une escarboucle, un saphir, un diamant; ");
INSERT INTO fraLSG_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","troisième rangée, une opale, une agate, une améthyste; ");
INSERT INTO fraLSG_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","quatrième rangée, une chrysolithe, un onyx, un jaspe. Ces pierres seront enchâssées dans leurs montures d’or. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Il y en aura douze, d’après les noms des fils d’Israël; elles seront gravées comme des cachets, chacune avec le nom de l’une des douze tribus. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Tu feras sur le pectoral des chaînettes d’or pur, tressées en forme de cordons. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Tu feras sur le pectoral deux anneaux d’or, et tu mettras ces deux anneaux aux deux extrémités du pectoral. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Tu passeras les deux cordons d’or dans les deux anneaux aux deux extrémités du pectoral; ");
INSERT INTO fraLSG_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","et tu arrêteras par devant les bouts des deux cordons aux deux montures placées sur les épaulettes de l’éphod. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Tu feras encore deux anneaux d’or, que tu mettras aux deux extrémités du pectoral, sur le bord intérieur appliqué contre l’éphod. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Et tu feras deux autres anneaux d’or, que tu mettras au bas des deux épaulettes de l’éphod, sur le devant, près de la jointure, au-dessus de la ceinture de l’éphod. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","On attachera le pectoral par ses anneaux aux anneaux de l’éphod avec un cordon bleu, afin que le pectoral soit au-dessus de la ceinture de l’éphod et qu’il ne puisse pas se séparer de l’éphod. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Lorsque Aaron entrera dans le sanctuaire, il portera sur son cœur les noms des fils d’Israël, gravés sur le pectoral du jugement, pour en conserver à toujours le souvenir devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tu joindras au pectoral du jugement l’urim et le thummim, et ils seront sur le cœur d’Aaron, lorsqu’il se présentera devant l’Éternel. Ainsi, Aaron portera constamment sur son cœur le jugement des enfants d’Israël, lorsqu’il se présentera devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Tu feras la robe de l’éphod entièrement d’étoffe bleue. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Il y aura, au milieu, une ouverture pour la tête; et cette ouverture aura tout autour un bord tissé, comme l’ouverture d’une cotte de mailles, afin que la robe ne se déchire pas. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Tu mettras autour de la bordure, en bas, des grenades de couleur bleue, pourpre et cramoisi, entremêlées de clochettes d’or: ");
INSERT INTO fraLSG_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","une clochette d’or et une grenade, une clochette d’or et une grenade, sur tout le tour de la bordure de la robe. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron s’en revêtira pour faire le service; quand il entrera dans le sanctuaire devant l’Éternel, et quand il en sortira, on entendra le son des clochettes, et il ne mourra point. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Tu feras une lame d’or pur, et tu y graveras, comme on grave un cachet: Sainteté à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Tu l’attacheras avec un cordon bleu sur la tiare, sur le devant de la tiare. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Elle sera sur le front d’Aaron; et Aaron sera chargé des iniquités commises par les enfants d’Israël en faisant toutes leurs saintes offrandes; elle sera constamment sur son front devant l’Éternel, pour qu’il leur soit favorable. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Tu feras la tunique de fin lin; tu feras une tiare de fin lin, et tu feras une ceinture brodée. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Pour les fils d’Aaron tu feras des tuniques, tu leur feras des ceintures, et tu leur feras des bonnets, pour marquer leur dignité et pour leur servir de parure. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Tu en revêtiras Aaron, ton frère, et ses fils avec lui. Tu les oindras, tu les consacreras, tu les sanctifieras, et ils seront à mon service dans le sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Fais-leur des caleçons de lin, pour couvrir leur nudité; ils iront depuis les reins jusqu’aux cuisses. ");
INSERT INTO fraLSG_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron et ses fils les porteront, quand ils entreront dans la tente d’assignation, ou quand ils s’approcheront de l’autel, pour faire le service dans le sanctuaire; ainsi ils ne se rendront point coupables, et ne mourront point. C’est une loi perpétuelle pour Aaron et pour ses descendants après lui. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Voici ce que tu feras pour les sanctifier, afin qu’ils soient à mon service dans le sacerdoce. Prends un jeune taureau et deux béliers sans défaut. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Fais, avec de la fleur de farine de froment, des pains sans levain, des gâteaux sans levain pétris à l’huile, et des galettes sans levain arrosées d’huile. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Tu les mettras dans une corbeille, en offrant le jeune taureau et les deux béliers. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Tu feras avancer Aaron et ses fils vers l’entrée de la tente d’assignation, et tu les laveras avec de l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Tu prendras les vêtements; tu revêtiras Aaron de la tunique, de la robe de l’éphod, de l’éphod et du pectoral, et tu mettras sur lui la ceinture de l’éphod. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Tu poseras la tiare sur sa tête, et tu placeras le diadème de sainteté sur la tiare. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tu prendras l’huile d’onction, tu en répandras sur sa tête, et tu l’oindras. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Tu feras approcher ses fils, et tu les revêtiras des tuniques. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Tu mettras une ceinture à Aaron et à ses fils, et tu attacheras des bonnets aux fils d’Aaron. Le sacerdoce leur appartiendra par une loi perpétuelle. Tu consacreras donc Aaron et ses fils. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Tu amèneras le taureau devant la tente d’assignation, et Aaron et ses fils poseront leurs mains sur la tête du taureau. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Tu égorgeras le taureau devant l’Éternel, à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Tu prendras du sang du taureau, tu en mettras avec ton doigt sur les cornes de l’autel, et tu répandras tout le sang au pied de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Tu prendras toute la graisse qui couvre les entrailles, le grand lobe du foie, les deux rognons et la graisse qui les entoure, et tu brûleras cela sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Mais tu brûleras au feu hors du camp la chair du taureau, sa peau et ses excréments: c’est un sacrifice pour le péché. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Tu prendras l’un des béliers, et Aaron et ses fils poseront leurs mains sur la tête du bélier. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Tu égorgeras le bélier; tu en prendras le sang, et tu le répandras sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Tu couperas le bélier par morceaux, et tu laveras les entrailles et les jambes, que tu mettras sur les morceaux et sur sa tête. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Tu brûleras tout le bélier sur l’autel; c’est un holocauste à l’Éternel, c’est un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Tu prendras l’autre bélier, et Aaron et ses fils poseront leurs mains sur la tête du bélier. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Tu égorgeras le bélier; tu prendras de son sang, tu en mettras sur le lobe de l’oreille droite d’Aaron et sur le lobe de l’oreille droite de ses fils, sur le pouce de leur main droite et sur le gros orteil de leur pied droit, et tu répandras le sang sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Tu prendras du sang qui sera sur l’autel et de l’huile d’onction, et tu en feras l’aspersion sur Aaron et sur ses vêtements, sur ses fils et sur leurs vêtements. Ainsi seront consacrés Aaron et ses vêtements, ses fils et leurs vêtements. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Tu prendras la graisse du bélier, la queue, la graisse qui couvre les entrailles, le grand lobe du foie, les deux rognons et la graisse qui les entoure, et l’épaule droite, car c’est un bélier de consécration; ");
INSERT INTO fraLSG_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","tu prendras aussi dans la corbeille de pains sans levain, placée devant l’Éternel, un gâteau de pain, un gâteau à l’huile et une galette. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Tu mettras toutes ces choses sur les mains d’Aaron et sur les mains de ses fils, et tu les agiteras de côté et d’autre devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Tu les ôteras ensuite de leurs mains, et tu les brûleras sur l’autel, par-dessus l’holocauste; c’est un sacrifice consumé par le feu devant l’Éternel, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Tu prendras la poitrine du bélier qui aura servi à la consécration d’Aaron, et tu l’agiteras de côté et d’autre devant l’Éternel: ce sera ta portion. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Tu sanctifieras la poitrine et l’épaule du bélier qui aura servi à la consécration d’Aaron et de ses fils, la poitrine en l’agitant de côté et d’autre, l’épaule en la présentant par élévation. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Elles appartiendront à Aaron et à ses fils, par une loi perpétuelle qu’observeront les enfants d’Israël, car c’est une offrande par élévation; et, dans les sacrifices d’actions de grâces des enfants d’Israël, l’offrande par élévation sera pour l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Les vêtements sacrés d’Aaron seront après lui pour ses fils, qui les mettront lorsqu’on les oindra et qu’on les consacrera. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ils seront portés pendant sept jours par celui de ses fils qui lui succédera dans le sacerdoce, et qui entrera dans la tente d’assignation, pour faire le service dans le sanctuaire. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Tu prendras le bélier de consécration, et tu en feras cuire la chair dans un lieu saint. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaron et ses fils mangeront, à l’entrée de la tente d’assignation, la chair du bélier et le pain qui sera dans la corbeille. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ils mangeront ainsi ce qui aura servi d’expiation afin qu’ils fussent consacrés et sanctifiés; nul étranger n’en mangera, car ce sont des choses saintes. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","S’il reste de la chair de consécration et du pain jusqu’au matin, tu brûleras dans le feu ce qui restera; on ne le mangera point, car c’est une chose sainte. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Tu suivras à l’égard d’Aaron et de ses fils tous les ordres que je t’ai donnés. Tu emploieras sept jours à les consacrer. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Tu offriras chaque jour un taureau en sacrifice pour le péché, pour l’expiation; tu purifieras l’autel par cette expiation, et tu l’oindras pour le sanctifier. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Pendant sept jours, tu feras des expiations sur l’autel, et tu le sanctifieras; et l’autel sera très saint, et tout ce qui touchera l’autel sera sanctifié. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Voici ce que tu offriras sur l’autel: deux agneaux d’un an, chaque jour, à perpétuité. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Tu offriras l’un des agneaux le matin, et l’autre agneau entre les deux soirs. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tu offriras, avec le premier agneau, un dixième d’épha de fleur de farine pétrie dans un quart de hin d’huile d’olives concassées, et une libation d’un quart de hin de vin. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tu offriras le second agneau entre les deux soirs, avec une offrande et une libation semblables à celles du matin; c’est un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Voilà l’holocauste perpétuel qui sera offert par vos descendants, à l’entrée de la tente d’assignation, devant l’Éternel: c’est là que je me rencontrerai avec vous, et que je te parlerai. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Je me rencontrerai là avec les enfants d’Israël, et ce lieu sera sanctifié par ma gloire. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Je sanctifierai la tente d’assignation et l’autel; je sanctifierai Aaron et ses fils, pour qu’ils soient à mon service dans le sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","J’habiterai au milieu des enfants d’Israël, et je serai leur Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Ils connaîtront que je suis l’Éternel, leur Dieu, qui les ai fait sortir du pays d’Égypte, pour habiter au milieu d’eux. Je suis l’Éternel, leur Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Tu feras un autel pour brûler des parfums, tu le feras de bois d’acacia; ");
INSERT INTO fraLSG_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","sa longueur sera d’une coudée, et sa largeur d’une coudée; il sera carré, et sa hauteur sera de deux coudées. Tu feras des cornes qui sortiront de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Tu le couvriras d’or pur, le dessus, les côtés tout autour et les cornes, et tu y feras une bordure d’or tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Tu feras au-dessous de la bordure deux anneaux d’or aux deux côtés; tu en mettras aux deux côtés, pour recevoir les barres qui serviront à le porter. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Tu feras les barres de bois d’acacia, et tu les couvriras d’or. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Tu placeras l’autel en face du voile qui est devant l’arche du témoignage, en face du propitiatoire qui est sur le témoignage, et où je me rencontrerai avec toi. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron y fera brûler du parfum odoriférant; il en fera brûler chaque matin, lorsqu’il préparera les lampes; ");
INSERT INTO fraLSG_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","il en fera brûler aussi entre les deux soirs, lorsqu’il arrangera les lampes. C’est ainsi que l’on brûlera à perpétuité du parfum devant l’Éternel parmi vos descendants. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Vous n’offrirez sur l’autel ni parfum étranger, ni holocauste, ni offrande, et vous n’y répandrez aucune libation. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Une fois chaque année, Aaron fera des expiations sur les cornes de l’autel; avec le sang de la victime expiatoire, il y sera fait des expiations une fois chaque année parmi vos descendants. Ce sera une chose très sainte devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Lorsque tu compteras les enfants d’Israël pour en faire le dénombrement, chacun d’eux paiera à l’Éternel le rachat de sa personne, afin qu’ils ne soient frappés d’aucune plaie lors de ce dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Voici ce que donneront tous ceux qui seront compris dans le dénombrement: un demi-sicle, selon le sicle du sanctuaire, qui est de vingt guéras; un demi-sicle sera le don prélevé pour l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Tout homme compris dans le dénombrement, depuis l’âge de vingt ans et au-dessus, paiera le don prélevé pour l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Le riche ne paiera pas plus, et le pauvre ne paiera pas moins d’un demi-sicle, comme don prélevé pour l’Éternel, afin de racheter leurs personnes. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Tu recevras des enfants d’Israël l’argent du rachat, et tu l’appliqueras au travail de la tente d’assignation; ce sera pour les enfants d’Israël un souvenir devant l’Éternel pour le rachat de leurs personnes. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Tu feras une cuve d’airain, avec sa base d’airain, pour les ablutions; tu la placeras entre la tente d’assignation et l’autel, et tu y mettras de l’eau, ");
INSERT INTO fraLSG_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","avec laquelle Aaron et ses fils se laveront les mains et les pieds. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Lorsqu’ils entreront dans la tente d’assignation, ils se laveront avec cette eau, afin qu’ils ne meurent point; et aussi lorsqu’ils s’approcheront de l’autel, pour faire le service et pour offrir des sacrifices à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ils se laveront les mains et les pieds, afin qu’ils ne meurent point. Ce sera une loi perpétuelle pour Aaron, pour ses fils et pour leurs descendants. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Prends des meilleurs aromates, cinq cents sicles de myrrhe, de celle qui coule d’elle-même; la moitié, soit deux cent cinquante sicles, de cinnamome aromatique, deux cent cinquante sicles de roseau aromatique, ");
INSERT INTO fraLSG_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","cinq cents sicles de casse, selon le sicle du sanctuaire, et un hin d’huile d’olive. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Tu feras avec cela une huile pour l’onction sainte, composition de parfums selon l’art du parfumeur; ce sera l’huile pour l’onction sainte. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Tu en oindras la tente d’assignation et l’arche du témoignage, ");
INSERT INTO fraLSG_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","la table et tous ses ustensiles, le chandelier et ses ustensiles, l’autel des parfums, ");
INSERT INTO fraLSG_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","l’autel des holocaustes et tous ses ustensiles, la cuve avec sa base. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Tu sanctifieras ces choses, et elles seront très saintes, tout ce qui les touchera sera sanctifié. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Tu oindras Aaron et ses fils, et tu les sanctifieras, pour qu’ils soient à mon service dans le sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Tu parleras aux enfants d’Israël, et tu diras: Ce sera pour moi l’huile de l’onction sainte, parmi vos descendants. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","On n’en répandra point sur le corps d’un homme, et vous n’en ferez point de semblable, dans les mêmes proportions; elle est sainte, et vous la regarderez comme sainte. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Quiconque en composera de semblable, ou en mettra sur un étranger, sera retranché de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","L’Éternel dit à Moïse: Prends des aromates, du stacté, de l’ongle odorant, du galbanum, et de l’encens pur, en parties égales. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Tu feras avec cela un parfum composé selon l’art du parfumeur; il sera salé, pur et saint. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tu le réduiras en poudre, et tu le mettras devant le témoignage, dans la tente d’assignation, où je me rencontrerai avec toi. Ce sera pour vous une chose très sainte. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Vous ne ferez point pour vous de parfum semblable, dans les mêmes proportions; vous le regarderez comme saint, et réservé pour l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Quiconque en fera de semblable, pour le sentir, sera retranché de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Sache que j’ai choisi Betsaleel, fils d’Uri, fils de Hur, de la tribu de Juda. ");
INSERT INTO fraLSG_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Je l’ai rempli de l’Esprit de Dieu, de sagesse, d’intelligence, et de savoir pour toutes sortes d’ouvrages, ");
INSERT INTO fraLSG_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","je l’ai rendu capable de faire des inventions, de travailler l’or, l’argent et l’airain, ");
INSERT INTO fraLSG_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","de graver les pierres à enchâsser, de travailler le bois, et d’exécuter toutes sortes d’ouvrages. ");
INSERT INTO fraLSG_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Et voici, je lui ai donné pour aide Oholiab, fils d’Ahisamac, de la tribu de Dan. J’ai mis de l’intelligence dans l’esprit de tous ceux qui sont habiles, pour qu’ils fassent tout ce que je t’ai ordonné: ");
INSERT INTO fraLSG_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","la tente d’assignation, l’arche du témoignage, le propitiatoire qui sera dessus, et tous les ustensiles de la tente; ");
INSERT INTO fraLSG_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","la table et ses ustensiles, le chandelier d’or pur et tous ses ustensiles, ");
INSERT INTO fraLSG_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","l’autel des parfums; l’autel des holocaustes et tous ses ustensiles, la cuve avec sa base; ");
INSERT INTO fraLSG_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","les vêtements d’office, les vêtements sacrés pour le sacrificateur Aaron, les vêtements de ses fils pour les fonctions du sacerdoce; ");
INSERT INTO fraLSG_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","l’huile d’onction, et le parfum odoriférant pour le sanctuaire. Ils se conformeront à tous les ordres que j’ai donnés. ");
INSERT INTO fraLSG_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Parle aux enfants d’Israël, et dis-leur: Vous ne manquerez pas d’observer mes sabbats, car ce sera entre moi et vous, et parmi vos descendants, un signe auquel on connaîtra que je suis l’Éternel qui vous sanctifie. ");
INSERT INTO fraLSG_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Vous observerez le sabbat, car il sera pour vous une chose sainte. Celui qui le profanera, sera puni de mort; celui qui fera quelque ouvrage ce jour-là, sera retranché du milieu de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","On travaillera six jours; mais le septième jour est le sabbat, le jour du repos, consacré à l’Éternel. Celui qui fera quelque ouvrage le jour du sabbat, sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Les enfants d’Israël observeront le sabbat, en le célébrant, eux et leurs descendants, comme une alliance perpétuelle. ");
INSERT INTO fraLSG_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ce sera entre moi et les enfants d’Israël un signe qui devra durer à perpétuité; car en six jours l’Éternel a fait les cieux et la terre, et le septième jour il a cessé son œuvre et il s’est reposé. ");
INSERT INTO fraLSG_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Lorsque l’Éternel eut achevé de parler à Moïse sur la montagne de Sinaï, il lui donna les deux tables du témoignage, tables de pierre, écrites du doigt de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Le peuple, voyant que Moïse tardait à descendre de la montagne, s’assembla autour d’Aaron, et lui dit: Allons! fais-nous un dieu qui marche devant nous, car ce Moïse, cet homme qui nous a fait sortir du pays d’Égypte, nous ne savons ce qu’il est devenu. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron leur dit: Otez les anneaux d’or qui sont aux oreilles de vos femmes, de vos fils et de vos filles, et apportez-les-moi. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Et tous ôtèrent les anneaux d’or qui étaient à leurs oreilles, et ils les apportèrent à Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Il les reçut de leurs mains, jeta l’or dans un moule, et fit un veau en fonte. Et ils dirent: Israël! Voici ton dieu, qui t’a fait sortir du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Lorsqu’Aaron vit cela, il bâtit un autel devant lui, et il s’écria: Demain, il y aura fête en l’honneur de l’Éternel! ");
INSERT INTO fraLSG_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Le lendemain, ils se levèrent de bon matin, et ils offrirent des holocaustes et des sacrifices d’actions de grâces. Le peuple s’assit pour manger et pour boire; puis ils se levèrent pour se divertir. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","L’Éternel dit à Moïse: Va, descends; car ton peuple, que tu as fait sortir du pays d’Égypte, s’est corrompu. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Ils se sont promptement écartés de la voie que je leur avais prescrite; ils se sont fait un veau en fonte, ils se sont prosternés devant lui, ils lui ont offert des sacrifices, et ils ont dit: Israël! voici ton dieu, qui t’a fait sortir du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","L’Éternel dit à Moïse: Je vois que ce peuple est un peuple au cou roide. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Maintenant laisse-moi; ma colère va s’enflammer contre eux, et je les consumerai; mais je ferai de toi une grande nation. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moïse implora l’Éternel, son Dieu, et dit: Pourquoi, ô Éternel! Ta colère s’enflammerait-elle contre ton peuple, que tu as fait sortir du pays d’Égypte par une grande puissance et par une main forte? ");
INSERT INTO fraLSG_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Pourquoi les Égyptiens diraient-ils: C’est pour leur malheur qu’il les a fait sortir, c’est pour les tuer dans les montagnes, et pour les exterminer de dessus la terre? Reviens de l’ardeur de ta colère, et repens-toi du mal que tu veux faire à ton peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Souviens-toi d’Abraham, d’Isaac et d’Israël, tes serviteurs, auxquels tu as dit, en jurant par toi-même: Je multiplierai votre postérité comme les étoiles du ciel, je donnerai à vos descendants tout ce pays dont j’ai parlé, et ils le posséderont à jamais. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Et l’Éternel se repentit du mal qu’il avait déclaré vouloir faire à son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Moïse retourna et descendit de la montagne, les deux tables du témoignage dans sa main; les tables étaient écrites des deux côtés, elles étaient écrites de l’un et de l’autre côté. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Les tables étaient l’ouvrage de Dieu, et l’écriture était l’écriture de Dieu, gravée sur les tables. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Josué entendit la voix du peuple, qui poussait des cris, et il dit à Moïse: Il y a un cri de guerre dans le camp. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moïse répondit: Ce n’est ni un cri de vainqueurs, ni un cri de vaincus; ce que j’entends, c’est la voix de gens qui chantent. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Et, comme il approchait du camp, il vit le veau et les danses. La colère de Moïse s’enflamma; il jeta de ses mains les tables, et les brisa au pied de la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Il prit le veau qu’ils avaient fait, et le brûla au feu; il le réduisit en poudre, répandit cette poudre à la surface de l’eau, et fit boire les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moïse dit à Aaron: Que t’a fait ce peuple, pour que tu l’aies laissé commettre un si grand péché? ");
INSERT INTO fraLSG_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron répondit: Que la colère de mon seigneur ne s’enflamme point! Tu sais toi-même que ce peuple est porté au mal. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ils m’ont dit: Fais-nous un dieu qui marche devant nous; car ce Moïse, cet homme qui nous a fait sortir du pays d’Égypte, nous ne savons ce qu’il est devenu. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Je leur ai dit: Que ceux qui ont de l’or, s’en dépouillent! Et ils me l’ont donné; je l’ai jeté au feu, et il en est sorti ce veau. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moïse vit que le peuple était livré au désordre, et qu’Aaron l’avait laissé dans ce désordre, exposé à l’opprobre parmi ses ennemis. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moïse se plaça à la porte du camp, et dit: A moi ceux qui sont pour l’Éternel! Et tous les enfants de Lévi s’assemblèrent auprès de lui. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Il leur dit: Ainsi parle l’Éternel, le Dieu d’Israël: Que chacun de vous mette son épée au côté; traversez et parcourez le camp d’une porte à l’autre, et que chacun tue son frère, son parent. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Les enfants de Lévi firent ce qu’ordonnait Moïse; et environ trois mille hommes parmi le peuple périrent en cette journée. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moïse dit: Consacrez-vous aujourd’hui à l’Éternel, même en sacrifiant votre fils et votre frère, afin qu’il vous accorde aujourd’hui une bénédiction. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Le lendemain, Moïse dit au peuple: Vous avez commis un grand péché. Je vais maintenant monter vers l’Éternel: j’obtiendrai peut-être le pardon de votre péché. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moïse retourna vers l’Éternel et dit: Ah! Ce peuple a commis un grand péché. Ils se sont fait un dieu d’or. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Pardonne maintenant leur péché! Sinon, efface-moi de ton livre que tu as écrit. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","L’Éternel dit à Moïse: C’est celui qui a péché contre moi que j’effacerai de mon livre. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Va donc, conduis le peuple où je t’ai dit. Voici, mon ange marchera devant toi, mais au jour de ma vengeance, je les punirai de leur péché. ");
INSERT INTO fraLSG_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","L’Éternel frappa le peuple, parce qu’il avait fait le veau, fabriqué par Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","L’Éternel dit à Moïse: Va, pars d’ici, toi et le peuple que tu as fait sortir du pays d’Égypte; monte vers le pays que j’ai juré de donner à Abraham, à Isaac et à Jacob, en disant: Je le donnerai à ta postérité. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","J’enverrai devant toi un ange, et je chasserai les Cananéens, les Amoréens, les Héthiens, les Phéréziens, les Héviens et les Jébusiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Monte vers ce pays où coulent le lait et le miel. Mais je ne monterai point au milieu de toi, de peur que je ne te consume en chemin, car tu es un peuple au cou roide. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Lorsque le peuple eut entendu ces sinistres paroles, il fut dans la désolation, et personne ne mit ses ornements. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Et l’Éternel dit à Moïse: Dis aux enfants d’Israël: Vous êtes un peuple au cou roide; si je montais un seul instant au milieu de toi, je te consumerais. Ote maintenant tes ornements de dessus toi, et je verrai ce que je te ferai. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Les enfants d’Israël se dépouillèrent de leurs ornements, en s’éloignant du mont Horeb. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moïse prit la tente et la dressa hors du camp, à quelque distance; il l’appela tente d’assignation; et tous ceux qui consultaient l’Éternel allaient vers la tente d’assignation, qui était hors du camp. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Lorsque Moïse se rendait à la tente, tout le peuple se levait; chacun se tenait à l’entrée de sa tente, et suivait des yeux Moïse, jusqu’à ce qu’il fût entré dans la tente. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Et lorsque Moïse était entré dans la tente, la colonne de nuée descendait et s’arrêtait à l’entrée de la tente, et l’Éternel parlait avec Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tout le peuple voyait la colonne de nuée qui s’arrêtait à l’entrée de la tente, tout le peuple se levait et se prosternait à l’entrée de sa tente. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","L’Éternel parlait avec Moïse face à face, comme un homme parle à son ami. Puis Moïse retournait au camp; mais son jeune serviteur, Josué, fils de Nun, ne sortait pas du milieu de la tente. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Moïse dit à l’Éternel: Voici, tu me dis: Fais monter ce peuple! Et tu ne me fais pas connaître qui tu enverras avec moi. Cependant, tu as dit: Je te connais par ton nom, et tu as trouvé grâce à mes yeux. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Maintenant, si j’ai trouvé grâce à tes yeux, fais-moi connaître tes voies; alors je te connaîtrai, et je trouverai encore grâce à tes yeux. Considère que cette nation est ton peuple. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","L’Éternel répondit: Je marcherai moi-même avec toi, et je te donnerai du repos. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moïse lui dit: Si tu ne marches pas toi-même avec nous, ne nous fais point partir d’ici. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Comment sera-t-il donc certain que j’ai trouvé grâce à tes yeux, moi et ton peuple? Ne sera-ce pas quand tu marcheras avec nous, et quand nous serons distingués, moi et ton peuple, de tous les peuples qui sont sur la face de la terre? ");
INSERT INTO fraLSG_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","L’Éternel dit à Moïse: Je ferai ce que tu me demandes, car tu as trouvé grâce à mes yeux, et je te connais par ton nom. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moïse dit: Fais-moi voir ta gloire! ");
INSERT INTO fraLSG_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","L’Éternel répondit: Je ferai passer devant toi toute ma bonté, et je proclamerai devant toi le nom de l’Éternel; je fais grâce à qui je fais grâce, et miséricorde à qui je fais miséricorde. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","L’Éternel dit: Tu ne pourras pas voir ma face, car l’homme ne peut me voir et vivre. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","L’Éternel dit: Voici un lieu près de moi; tu te tiendras sur le rocher. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Quand ma gloire passera, je te mettrai dans un creux du rocher, et je te couvrirai de ma main jusqu’à ce que j’aie passé. ");
INSERT INTO fraLSG_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Et lorsque je retournerai ma main, tu me verras par derrière, mais ma face ne pourra pas être vue. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","L’Éternel dit à Moïse: Taille deux tables de pierre comme les premières, et j’y écrirai les paroles qui étaient sur les premières tables que tu as brisées. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Sois prêt de bonne heure, et tu monteras dès le matin sur la montagne de Sinaï; tu te tiendras là devant moi, sur le sommet de la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Que personne ne monte avec toi, et que personne ne paraisse sur toute la montagne; et même que ni brebis ni bœufs ne paissent près de cette montagne. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Moïse tailla deux tables de pierre comme les premières; il se leva de bon matin, et monta sur la montagne de Sinaï, selon l’ordre que l’Éternel lui avait donné, et il prit dans sa main les deux tables de pierre. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","L’Éternel descendit dans une nuée, se tint là auprès de lui, et proclama le nom de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Et l’Éternel passa devant lui, et s’écria: L’Éternel, l’Éternel, Dieu miséricordieux et compatissant, lent à la colère, riche en bonté et en fidélité, ");
INSERT INTO fraLSG_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","qui conserve son amour jusqu’à mille générations, qui pardonne l’iniquité, la rébellion et le péché, mais qui ne tient point le coupable pour innocent, et qui punit l’iniquité des pères sur les enfants et sur les enfants des enfants jusqu’à la troisième et à la quatrième génération! ");
INSERT INTO fraLSG_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Aussitôt Moïse s’inclina à terre et se prosterna. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Il dit: Seigneur, si j’ai trouvé grâce à tes yeux, que le Seigneur marche au milieu de nous, car c’est un peuple au cou roide; pardonne nos iniquités et nos péchés, et prends-nous pour ta possession. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","L’Éternel répondit: Voici, je traite une alliance. Je ferai, en présence de tout ton peuple, des prodiges qui n’ont eu lieu dans aucun pays et chez aucune nation; tout le peuple qui t’environne verra l’œuvre de l’Éternel, et c’est par toi que j’accomplirai des choses terribles. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Prends garde à ce que je t’ordonne aujourd’hui. Voici, je chasserai devant toi les Amoréens, les Cananéens, les Héthiens, les Phéréziens, les Héviens et les Jébusiens. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Garde-toi de faire alliance avec les habitants du pays où tu dois entrer, de peur qu’ils ne soient un piège pour toi. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Au contraire, vous renverserez leurs autels, vous briserez leurs statues, et vous abattrez leurs idoles. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Tu ne te prosterneras point devant un autre dieu; car l’Éternel porte le nom de jaloux, il est un Dieu jaloux. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Garde-toi de faire alliance avec les habitants du pays, de peur que, se prostituant à leurs dieux et leur offrant des sacrifices, ils ne t’invitent, et que tu ne manges de leurs victimes; ");
INSERT INTO fraLSG_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","de peur que tu ne prennes de leurs filles pour tes fils, et que leurs filles, se prostituant à leurs dieux, n’entraînent tes fils à se prostituer à leurs dieux. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Tu ne te feras point de dieu en fonte. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Tu observeras la fête des pains sans levain; pendant sept jours, au temps fixé dans le mois des épis, tu mangeras des pains sans levain, comme je t’en ai donné l’ordre, car c’est dans le mois des épis que tu es sorti d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Tout premier-né m’appartient, même tout mâle premier-né dans les troupeaux de gros et de menu bétail. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Tu rachèteras avec un agneau le premier-né de l’âne; et si tu ne le rachètes pas, tu lui briseras la nuque. Tu rachèteras tout premier-né de tes fils; et l’on ne se présentera point à vide devant ma face. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Tu travailleras six jours, et tu te reposeras le septième jour; tu te reposeras, même au temps du labourage et de la moisson. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Tu célébreras la fête des semaines, des prémices de la moisson du froment, et la fête de la récolte, à la fin de l’année. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Trois fois par an, tous les mâles se présenteront devant le Seigneur, l’Éternel, Dieu d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Car je chasserai les nations devant toi, et j’étendrai tes frontières; et personne ne convoitera ton pays, pendant que tu monteras pour te présenter devant l’Éternel, ton Dieu, trois fois par an. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Tu n’offriras point avec du pain levé le sang de la victime immolée en mon honneur; et le sacrifice de la fête de Pâque ne sera point gardé pendant la nuit jusqu’au matin. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Tu apporteras à la maison de L’Éternel, ton Dieu, les prémices des premiers fruits de la terre. Tu ne feras point cuire un chevreau dans le lait de sa mère. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","L’Éternel dit à Moïse: Écris ces paroles; car c’est conformément à ces paroles que je traite alliance avec toi et avec Israël. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Moïse fut là avec l’Éternel quarante jours et quarante nuits. Il ne mangea point de pain, et il ne but point d’eau. Et l’Éternel écrivit sur les tables les paroles de l’alliance, les dix paroles. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Moïse descendit de la montagne de Sinaï, ayant les deux tables du témoignage dans sa main, en descendant de la montagne; et il ne savait pas que la peau de son visage rayonnait, parce qu’il avait parlé avec l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaron et tous les enfants d’Israël regardèrent Moïse, et voici la peau de son visage rayonnait; et ils craignaient de s’approcher de lui. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moïse les appela; Aaron et tous les principaux de l’assemblée vinrent auprès de lui, et il leur parla. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Après cela, tous les enfants d’Israël s’approchèrent, et il leur donna tous les ordres qu’il avait reçus de l’Éternel, sur la montagne de Sinaï. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Lorsque Moïse eut achevé de leur parler, il mit un voile sur son visage. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Quand Moïse entrait devant l’Éternel, pour lui parler, il ôtait le voile, jusqu’à ce qu’il sortît; et quand il sortait, il disait aux enfants d’Israël ce qui lui avait été ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Les enfants d’Israël regardaient le visage de Moïse, et voyaient que la peau de son visage rayonnait; et Moïse remettait le voile sur son visage jusqu’à ce qu’il entrât, pour parler avec l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Moïse convoqua toute l’assemblée des enfants d’Israël, et leur dit: Voici les choses que l’Éternel ordonne de faire. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","On travaillera six jours; mais le septième jour sera pour vous une chose sainte; c’est le sabbat, le jour du repos, consacré à l’Éternel. Celui qui fera quelque ouvrage ce jour-là, sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Vous n’allumerez point de feu, dans aucune de vos demeures, le jour du sabbat. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Moïse parla à toute l’assemblée des enfants d’Israël, et dit: Voici ce que l’Éternel a ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Prenez sur ce qui vous appartient une offrande pour l’Éternel. Tout homme dont le cœur est bien disposé apportera en offrande à l’Éternel: de l’or, de l’argent et de l’airain; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","des étoffes teintes en bleu, en pourpre, en cramoisi, du fin lin et du poil de chèvre; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","des peaux de béliers teintes en rouge et des peaux de dauphins; du bois d’acacia; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","de l’huile pour le chandelier, des aromates pour l’huile d’onction et pour le parfum odoriférant; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","des pierres d’onyx et d’autres pierres pour la garniture de l’éphod et du pectoral. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Que tous ceux d’entre vous qui ont de l’habileté viennent et exécutent tout ce que l’Éternel a ordonné: ");
INSERT INTO fraLSG_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","le tabernacle, sa tente et sa couverture, ses agrafes, ses planches, ses barres, ses colonnes et ses bases; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","l’arche et ses barres, le propitiatoire, et le voile pour couvrir l’arche; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","la table et ses barres, et tous ses ustensiles, et les pains de proposition; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","le chandelier et ses ustensiles, ses lampes, et l’huile pour le chandelier; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","l’autel des parfums et ses barres, l’huile d’onction et le parfum odoriférant, et le rideau de la porte pour l’entrée du tabernacle; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","l’autel des holocaustes, sa grille d’airain, ses barres, et tous ses ustensiles; la cuve avec sa base; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","les toiles du parvis, ses colonnes, ses bases, et le rideau de la porte du parvis; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","les pieux du tabernacle, les pieux du parvis, et leurs cordages; les vêtements d’office pour le service dans le sanctuaire, ");
INSERT INTO fraLSG_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","les vêtements sacrés pour le sacrificateur Aaron, et les vêtements de ses fils pour les fonctions du sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Toute l’assemblée des enfants d’Israël sortit de la présence de Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Tous ceux qui furent entraînés par le cœur et animés de bonne volonté vinrent et apportèrent une offrande à l’Éternel pour l’œuvre de la tente d’assignation, pour tout son service, et pour les vêtements sacrés. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Les hommes vinrent aussi bien que les femmes; tous ceux dont le cœur était bien disposé apportèrent des boucles, des anneaux, des bagues, des bracelets, toutes sortes d’objets d’or; chacun présenta l’offrande d’or qu’il avait consacrée à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Tous ceux qui avaient des étoffes teintes en bleu, en pourpre, en cramoisi, du fin lin et du poil de chèvre, des peaux de béliers teintes en rouge et des peaux de dauphins, les apportèrent. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Tous ceux qui présentèrent par élévation une offrande d’argent et d’airain apportèrent l’offrande à l’Éternel. Tous ceux qui avaient du bois d’acacia pour les ouvrages destinés au service, l’apportèrent. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Toutes les femmes qui avaient de l’habileté filèrent de leurs mains, et elles apportèrent leur ouvrage, des fils teints en bleu, en pourpre, en cramoisi, et du fin lin. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Toutes les femmes dont le cœur était bien disposé, et qui avaient de l’habileté, filèrent du poil de chèvre. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Les principaux du peuple apportèrent des pierres d’onyx et d’autres pierres pour la garniture de l’éphod et du pectoral; ");
INSERT INTO fraLSG_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","des aromates et de l’huile pour le chandelier, pour l’huile d’onction et pour le parfum odoriférant. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Tous les enfants d’Israël, hommes et femmes, dont le cœur était disposé à contribuer pour l’œuvre que l’Éternel avait ordonnée par Moïse, apportèrent des offrandes volontaires à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Moïse dit aux enfants d’Israël: Sachez que l’Éternel a choisi Betsaleel, fils d’Uri, fils de Hur, de la tribu de Juda. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Il l’a rempli de l’Esprit de Dieu, de sagesse, d’intelligence, et de savoir pour toutes sortes d’ouvrages. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Il l’a rendu capable de faire des inventions, de travailler l’or, l’argent et l’airain, ");
INSERT INTO fraLSG_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","de graver les pierres à enchâsser, de travailler le bois, et d’exécuter toutes sortes d’ouvrages d’art. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Il lui a accordé aussi le don d’enseigner, de même qu’à Oholiab, fils d’Ahisamac, de la tribu de Dan. ");
INSERT INTO fraLSG_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Il les a remplis d’intelligence, pour exécuter tous les ouvrages de sculpture et d’art, pour broder et tisser les étoffes teintes en bleu, en pourpre, en cramoisi, et le fin lin, pour faire toute espèce de travaux et d’inventions. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Betsaleel, Oholiab, et tous les hommes habiles, en qui l’Éternel avait mis de la sagesse et de l’intelligence pour savoir et pour faire, exécutèrent les ouvrages destinés au service du sanctuaire, selon tout ce que l’Éternel avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Moïse appela Betsaleel, Oholiab, et tous les hommes habiles dans l’esprit desquels l’Éternel avait mis de l’intelligence, tous ceux dont le cœur était disposé à s’appliquer à l’œuvre pour l’exécuter. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Ils prirent devant Moïse toutes les offrandes qu’avaient apportées les enfants d’Israël pour faire les ouvrages destinés au service du sanctuaire. Chaque matin, on apportait encore à Moïse des offrandes volontaires. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Alors tous les hommes habiles, occupés à tous les travaux du sanctuaire, quittèrent chacun l’ouvrage qu’ils faisaient, ");
INSERT INTO fraLSG_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","et vinrent dire à Moïse: Le peuple apporte beaucoup plus qu’il ne faut pour exécuter les ouvrages que l’Éternel a ordonné de faire. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Moïse fit publier dans le camp que personne, homme ou femme, ne s’occupât plus d’offrandes pour le sanctuaire. On empêcha ainsi le peuple d’en apporter. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Les objets préparés suffisaient, et au-delà, pour tous les ouvrages à faire. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Tous les hommes habiles, qui travaillèrent à l’œuvre, firent le tabernacle avec dix tapis de fin lin retors et de fil bleu, pourpre et cramoisi; on y représenta des chérubins artistement travaillés. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","La longueur d’un tapis était de vingt-huit coudées; et la largeur d’un tapis était de quatre coudées; la mesure était la même pour tous les tapis. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Cinq de ces tapis furent joints ensemble; les cinq autres furent aussi joints ensemble. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","On fit des lacets bleus au bord du tapis terminant le premier assemblage; on fit de même au bord du tapis terminant le second assemblage. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","On mit cinquante lacets au premier tapis, et l’on mit cinquante lacets au bord du tapis terminant le second assemblage; ces lacets se correspondaient les uns aux autres. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","On fit cinquante agrafes d’or, et l’on joignit les tapis l’un à l’autre avec les agrafes. Et le tabernacle forma un tout. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","On fit des tapis de poil de chèvre, pour servir de tente sur le tabernacle; on fit onze de ces tapis. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","La longueur d’un tapis était de trente coudées, et la largeur d’un tapis était de quatre coudées; la mesure était la même pour les onze tapis. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","On joignit séparément cinq de ces tapis, et les six autres séparément. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","On mit cinquante lacets au bord du tapis terminant un assemblage, et l’on mit cinquante lacets au bord du tapis du second assemblage. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","On fit cinquante agrafes d’airain, pour assembler la tente, afin qu’elle formât un tout. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","On fit pour la tente une couverture de peaux de béliers teintes en rouge, et une couverture de peaux de dauphins, qui devait être mise par-dessus. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","On fit les planches pour le tabernacle; elles étaient de bois d’acacia, placées debout. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","La longueur d’une planche était de dix coudées, et la largeur d’une planche était d’une coudée et demie. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Il y avait pour chaque planche deux tenons, joints l’un à l’autre; l’on fit de même pour toutes les planches du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","On fit vingt planches pour le tabernacle, du côté du midi. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","On mit quarante bases d’argent sous les vingt planches, deux bases sous chaque planche pour ses deux tenons. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","On fit vingt planches pour le second côté du tabernacle, le côté du nord, ");
INSERT INTO fraLSG_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","et leurs quarante bases d’argent, deux bases sous chaque planche. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","On fit six planches pour le fond du tabernacle, du côté de l’occident. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","On fit deux planches pour les angles du tabernacle dans le fond; ");
INSERT INTO fraLSG_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","elles étaient doubles depuis le bas et bien liées à leur sommet par un anneau; on fit de même pour toutes aux deux angles. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Il y avait ainsi huit planches, avec leurs bases d’argent, soit seize bases, deux bases sous chaque planche. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","On fit cinq barres de bois d’acacia pour les planches de l’un des côtés du tabernacle, ");
INSERT INTO fraLSG_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","cinq barres pour les planches du second côté du tabernacle, et cinq barres pour les planches du côté du tabernacle formant le fond vers l’occident; ");
INSERT INTO fraLSG_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","on fit la barre du milieu pour traverser les planches d’une extrémité à l’autre. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","On couvrit d’or les planches, et l’on fit d’or leurs anneaux pour recevoir les barres, et l’on couvrit d’or les barres. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","On fit le voile de fil bleu, pourpre et cramoisi, et de fin lin retors; on le fit artistement travaillé, et l’on y représenta des chérubins. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","On fit pour lui quatre colonnes d’acacia, et on les couvrit d’or; elles avaient des crochets d’or, et l’on fondit pour elles quatre bases d’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","On fit pour l’entrée de la tente un rideau de fil bleu, pourpre et cramoisi, et de fin lin retors; c’était un ouvrage de broderie. ");
INSERT INTO fraLSG_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","On fit ses cinq colonnes et leurs crochets, et l’on couvrit d’or leurs chapiteaux et leurs tringles; leurs cinq bases étaient d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Betsaleel fit l’arche de bois d’acacia; sa longueur était de deux coudées et demie, sa largeur d’une coudée et demie, et sa hauteur d’une coudée et demie. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Il la couvrit d’or pur en dedans et en dehors, et il y fit une bordure d’or tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Il fondit pour elle quatre anneaux d’or, qu’il mit à ses quatre coins, deux anneaux d’un côté et deux anneaux de l’autre côté. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Il fit des barres de bois d’acacia, et les couvrit d’or. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Il passa les barres dans les anneaux sur les côtés de l’arche, pour porter l’arche. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Il fit un propitiatoire d’or pur; sa longueur était de deux coudées et demie, et sa largeur d’une coudée et demie. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Il fit deux chérubins d’or; il les fit d’or battu, aux deux extrémités du propitiatoire, ");
INSERT INTO fraLSG_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","un chérubin à l’une des extrémités, et un chérubin à l’autre extrémité; il fit les chérubins sortant du propitiatoire à ses deux extrémités. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Les chérubins étendaient les ailes par-dessus, couvrant de leurs ailes le propitiatoire, et se regardant l’un l’autre; les chérubins avaient la face tournée vers le propitiatoire. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Il fit la table de bois d’acacia, sa longueur était de deux coudées, sa largeur d’une coudée, et sa hauteur d’une coudée et demie. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Il la couvrit d’or pur, et il y fit une bordure d’or tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Il y fit à l’entour un rebord de quatre doigts, sur lequel il mit une bordure d’or tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Il fondit pour la table quatre anneaux d’or, et mit les anneaux aux quatre coins, qui étaient à ses quatre pieds. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Les anneaux étaient près du rebord, et recevaient les barres pour porter la table. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Il fit les barres de bois d’acacia, et les couvrit d’or; et elles servaient à porter la table. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Il fit les ustensiles qu’on devait mettre sur la table, ses plats, ses coupes, ses calices et ses tasses pour servir aux libations; il les fit d’or pur. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Il fit le chandelier d’or pur; il fit le chandelier d’or battu; son pied, sa tige, ses calices, ses pommes et ses fleurs, étaient d’une même pièce. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Six branches sortaient de ses côtés, trois branches du chandelier de l’un des côtés, et trois branches du chandelier de l’autre côté. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Il y avait sur une branche trois calices en forme d’amande, avec pommes et fleurs, et sur une autre branche trois calices en forme d’amande, avec pommes et fleurs; il en était de même pour les six branches sortant du chandelier. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","A la tige du chandelier il y avait quatre calices en forme d’amande, avec leurs pommes et leurs fleurs. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Il y avait une pomme sous deux des branches sortant du chandelier, une pomme sous deux autres branches, et une pomme sous deux autres branches; il en était de même pour les six branches sortant du chandelier. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Les pommes et les branches du chandelier étaient d’une même pièce; il était tout entier d’or battu, d’or pur. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Il fit ses sept lampes, ses mouchettes et ses vases à cendre d’or pur. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Il employa un talent d’or pur, pour faire le chandelier avec tous ses ustensiles. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Il fit l’autel des parfums de bois d’acacia; sa longueur était d’une coudée et sa largeur d’une coudée; il était carré, et sa hauteur était de deux coudées. Des cornes sortaient de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Il le couvrit d’or pur, le dessus, les côtés tout autour et les cornes, et il y fit une bordure d’or tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Il fit au-dessous de la bordure deux anneaux d’or aux deux côtés; il en mit aux deux côtés, pour recevoir les barres qui servaient à le porter. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Il fit des barres de bois d’acacia, et les couvrit d’or. ");
INSERT INTO fraLSG_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Il fit l’huile pour l’onction sainte, et le parfum odoriférant, pur, composé selon l’art du parfumeur. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Il fit l’autel des holocaustes de bois d’acacia; sa longueur était de cinq coudées, et sa largeur de cinq coudées; il était carré, et sa hauteur était de trois coudées. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Il fit, aux quatre coins, des cornes qui sortaient de l’autel, et il le couvrit d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Il fit tous les ustensiles de l’autel, les cendriers, les pelles, les bassins, les fourchettes et les brasiers; il fit d’airain tous ces ustensiles. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Il fit pour l’autel une grille d’airain, en forme de treillis, qu’il plaça au-dessous du rebord de l’autel, à partir du bas, jusqu’à la moitié de la hauteur de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Il fondit quatre anneaux, qu’il mit aux quatre coins de la grille d’airain, pour recevoir les barres. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Il fit les barres de bois d’acacia, et les couvrit d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Il passa dans les anneaux aux côtés de l’autel les barres qui servaient à le porter. Il le fit creux, avec des planches. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Il fit la cuve d’airain, avec sa base d’airain, en employant les miroirs des femmes qui s’assemblaient à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Il fit le parvis. Du côté du midi, il y avait, pour former le parvis, des toiles de fin lin retors, sur une longueur de cent coudées, ");
INSERT INTO fraLSG_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","avec vingt colonnes posant sur vingt bases d’airain; les crochets des colonnes et leurs tringles étaient d’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Du côté du nord, il y avait cent coudées de toiles, avec vingt colonnes et leurs vingt bases d’airain; les crochets des colonnes et leurs tringles étaient d’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Du côté de l’occident, il y avait cinquante coudées de toiles, avec dix colonnes et leurs dix bases; les crochets des colonnes et leurs tringles étaient d’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Du côté de l’orient, sur les cinquante coudées de largeur, ");
INSERT INTO fraLSG_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","il y avait, pour une aile, quinze coudées de toiles, avec trois colonnes et leurs trois bases, ");
INSERT INTO fraLSG_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","et, pour la seconde aile, qui lui correspondait de l’autre côté de la porte du parvis, quinze coudées de toiles, avec trois colonnes et leurs trois bases. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Toutes les toiles formant l’enceinte du parvis étaient de fin lin retors. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Les bases pour les colonnes étaient d’airain, les crochets des colonnes et leurs tringles étaient d’argent, et leurs chapiteaux étaient couverts d’argent. Toutes les colonnes du parvis étaient jointes par des tringles d’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Le rideau de la porte du parvis était un ouvrage de broderie en fil bleu, pourpre et cramoisi, et en fin lin retors; il avait une longueur de vingt coudées, et sa hauteur était de cinq coudées, comme la largeur des toiles du parvis; ");
INSERT INTO fraLSG_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ses quatre colonnes et leurs quatre bases étaient d’airain, les crochets et leurs tringles étaient d’argent, et leurs chapiteaux étaient couverts d’argent. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tous les pieux de l’enceinte du tabernacle et du parvis étaient d’airain. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Voici les comptes du tabernacle, du tabernacle d’assignation, révisés, d’après l’ordre de Moïse, par les soins des Lévites, sous la direction d’Ithamar, fils du sacrificateur Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Betsaleel, fils d’Uri, fils de Hur, de la tribu de Juda, fit tout ce que l’Éternel avait ordonné à Moïse; ");
INSERT INTO fraLSG_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","il eut pour aide Oholiab, fils d’Ahisamac, de la tribu de Dan, habile à graver, à inventer, et à broder sur les étoffes teintes en bleu, en pourpre, en cramoisi, et sur le fin lin. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Le total de l’or employé à l’œuvre pour tous les travaux du sanctuaire, or qui fut le produit des offrandes, montait à vingt-neuf talents et sept cent trente sicles, selon le sicle du sanctuaire. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","L’argent de ceux de l’assemblée dont on fit le dénombrement montait à cent talents et mille sept cent soixante-quinze sicles, selon le sicle du sanctuaire. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","C’était un demi-sicle par tête, la moitié d’un sicle, selon le sicle du sanctuaire, pour chaque homme compris dans le dénombrement, depuis l’âge de vingt ans et au-dessus, soit pour six cent trois mille cinq cent cinquante hommes. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Les cent talents d’argent servirent à fondre les bases du sanctuaire et les bases du voile, cent bases pour les cent talents, un talent par base. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Et avec les mille sept cent soixante-quinze sicles on fit les crochets et les tringles pour les colonnes, et on couvrit les chapiteaux. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","L’airain des offrandes montait à soixante-dix talents et deux mille quatre cents sicles. ");
INSERT INTO fraLSG_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","On en fit les bases de l’entrée de la tente d’assignation; l’autel d’airain avec sa grille, et tous les ustensiles de l’autel; ");
INSERT INTO fraLSG_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","les bases du parvis, tout autour, et les bases de la porte du parvis; et tous les pieux de l’enceinte du tabernacle et du parvis. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Avec les étoffes teintes en bleu, en pourpre et en cramoisi, on fit les vêtements d’office pour le service dans le sanctuaire, et on fit les vêtements sacrés pour Aaron, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","On fit l’éphod d’or, de fil bleu, pourpre et cramoisi, et de fin lin retors. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","On étendit des lames d’or, et on les coupa en fils, que l’on entrelaça dans les étoffes teintes en bleu, en pourpre et en cramoisi, et dans le fin lin; il était artistement travaillé. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","On y fit des épaulettes qui le joignaient, et c’est ainsi qu’il était joint par ses deux extrémités. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","La ceinture était du même travail que l’éphod et fixée sur lui; elle était d’or, de fil bleu, pourpre et cramoisi, et de fin lin retors, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","On entoura de montures d’or des pierres d’onyx, sur lesquelles on grava les noms des fils d’Israël, comme on grave les cachets. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","On les mit sur les épaulettes de l’éphod, en souvenir des fils d’Israël, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","On fit le pectoral, artistement travaillé, du même travail que l’éphod, d’or, de fil bleu, pourpre et cramoisi, et de fin lin retors. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Il était carré; on fit le pectoral double: sa longueur était d’un empan, et sa largeur d’un empan; il était double. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","On le garnit de quatre rangées de pierres: première rangée, une sardoine, une topaze, une émeraude; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","seconde rangée, une escarboucle, un saphir, un diamant; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","troisième rangée, une opale, une agate, une améthyste; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","quatrième rangée, une chrysolithe, un onyx, un jaspe. Ces pierres étaient enchâssées dans leurs montures d’or. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Il y en avait douze, d’après les noms des fils d’Israël; elles étaient gravées comme des cachets, chacune avec le nom de l’une des douze tribus. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","On fit sur le pectoral des chaînettes d’or pur, tressées en forme de cordons. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","On fit deux montures d’or et deux anneaux d’or, et on mit les deux anneaux aux deux extrémités du pectoral. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","On passa les deux cordons d’or dans les deux anneaux aux deux extrémités du pectoral; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","on arrêta par devant les bouts des deux cordons aux deux montures placées sur les épaulettes de l’éphod. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","On fit encore deux anneaux d’or, que l’on mit aux deux extrémités du pectoral, sur le bord intérieur appliqué contre l’éphod. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","On fit deux autres anneaux d’or, que l’on mit au bas des deux épaulettes de l’éphod, sur le devant, près de la jointure, au-dessus de la ceinture de l’éphod. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","On attacha le pectoral par ses anneaux aux anneaux de l’éphod avec un cordon bleu, afin que le pectoral fût au-dessus de la ceinture de l’éphod et qu’il ne pût pas se séparer de l’éphod, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","On fit la robe de l’éphod, tissée entièrement d’étoffe bleue. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Il y avait, au milieu de la robe, une ouverture comme l’ouverture d’une cotte de mailles, et cette ouverture était bordée tout autour, afin que la robe ne se déchirât pas. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","On mit sur la bordure de la robe des grenades de couleur bleue, pourpre et cramoisi, en fil retors; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","on fit des clochettes d’or pur, et on mit les clochettes entre les grenades, sur tout le tour de la bordure de la robe, entre les grenades: ");
INSERT INTO fraLSG_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","une clochette et une grenade, une clochette et une grenade, sur tout le tour de la bordure de la robe, pour le service, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","On fit les tuniques de fin lin, tissées, pour Aaron et pour ses fils; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","la tiare de fin lin, et les bonnets de fin lin servant de parure; les caleçons de lin, de fin lin retors; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","la ceinture de fin lin retors, brodée, et de couleur bleue, pourpre et cramoisi, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","On fit d’or pur la lame, diadème sacré, et l’on y écrivit, comme on grave un cachet: Sainteté à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","On l’attacha avec un cordon bleu à la tiare, en haut, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Ainsi furent achevés tous les ouvrages du tabernacle, de la tente d’assignation. Les enfants d’Israël firent tout ce que l’Éternel avait ordonné à Moïse; ils firent ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","On amena le tabernacle à Moïse: la tente et tout ce qui en dépendait, les agrafes, les planches, les barres, les colonnes et les bases; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","la couverture de peaux de béliers teintes en rouge, la couverture de peaux de dauphins, et le voile de séparation; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","l’arche du témoignage et ses barres, et le propitiatoire; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","la table, tous ses ustensiles, et les pains de proposition; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","le chandelier d’or pur, ses lampes, les lampes préparées, tous ses ustensiles, et l’huile pour le chandelier; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","l’autel d’or, l’huile d’onction et le parfum odoriférant, et le rideau de l’entrée de la tente; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","l’autel d’airain, sa grille d’airain, ses barres, et tous ses ustensiles; la cuve avec sa base; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","les toiles du parvis, ses colonnes, ses bases, et le rideau de la porte du parvis, ses cordages, ses pieux, et tous les ustensiles pour le service du tabernacle, pour la tente d’assignation; ");
INSERT INTO fraLSG_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","les vêtements d’office pour le sanctuaire, les vêtements sacrés pour le sacrificateur Aaron, et les vêtements de ses fils pour les fonctions du sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Les enfants d’Israël firent tous ces ouvrages, en se conformant à tous les ordres que l’Éternel avait donnés à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Moïse examina tout le travail; et voici, ils l’avaient fait comme l’Éternel l’avait ordonné, ils l’avaient fait ainsi. Et Moïse les bénit. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Le premier jour du premier mois, tu dresseras le tabernacle, la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tu y placeras l’arche du témoignage, et tu couvriras l’arche avec le voile. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Tu apporteras la table, et tu la disposeras en ordre. Tu apporteras le chandelier, et tu en arrangeras les lampes. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Tu placeras l’autel d’or pour le parfum devant l’arche du témoignage, et tu mettras le rideau à l’entrée du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Tu placeras l’autel des holocaustes devant l’entrée du tabernacle, de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Tu placeras la cuve entre la tente d’assignation et l’autel, et tu y mettras de l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Tu placeras le parvis à l’entour, et tu mettras le rideau à la porte du parvis. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Tu prendras l’huile d’onction, tu en oindras le tabernacle et tout ce qu’il renferme, et tu le sanctifieras, avec tous ses ustensiles; et il sera saint. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Tu oindras l’autel des holocaustes et tous ses ustensiles, et tu sanctifieras l’autel; et l’autel sera très saint. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Tu oindras la cuve avec sa base, et tu la sanctifieras. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Tu feras avancer Aaron et ses fils vers l’entrée de la tente d’assignation, et tu les laveras avec de l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Tu revêtiras Aaron des vêtements sacrés, tu l’oindras, et tu le sanctifieras, pour qu’il soit à mon service dans le sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Tu feras approcher ses fils, tu les revêtiras des tuniques, ");
INSERT INTO fraLSG_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","et tu les oindras comme tu auras oint leur père, pour qu’ils soient à mon service dans le sacerdoce. Cette onction leur assurera à perpétuité le sacerdoce parmi leurs descendants. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Moïse fit tout ce que l’Éternel lui avait ordonné; il fit ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Le premier jour du premier mois de la seconde année, le tabernacle fut dressé. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Moïse dressa le tabernacle; il en posa les bases, plaça les planches et les barres, et éleva les colonnes. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Il étendit la tente sur le tabernacle, et il mit la couverture de la tente par-dessus, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Il prit le témoignage, et le plaça dans l’arche; il mit les barres à l’arche, et il posa le propitiatoire au-dessus de l’arche. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Il apporta l’arche dans le tabernacle; il mit le voile de séparation, et il en couvrit l’arche du témoignage, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Il plaça la table dans la tente d’assignation, au côté septentrional du tabernacle, en dehors du voile; ");
INSERT INTO fraLSG_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","et il y déposa en ordre les pains, devant l’Éternel, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Il plaça le chandelier dans la tente d’assignation, en face de la table, au côté méridional du tabernacle; ");
INSERT INTO fraLSG_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","et il en arrangea les lampes, devant l’Éternel, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Il plaça l’autel d’or dans la tente d’assignation, devant le voile; ");
INSERT INTO fraLSG_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","et il y fit brûler le parfum odoriférant, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Il plaça le rideau à l’entrée du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Il plaça l’autel des holocaustes à l’entrée du tabernacle, de la tente d’assignation; et il y offrit l’holocauste et l’offrande, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Il plaça la cuve entre la tente d’assignation et l’autel, et il y mit de l’eau pour les ablutions; ");
INSERT INTO fraLSG_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Moïse, Aaron et ses fils, s’y lavèrent les mains et les pieds; ");
INSERT INTO fraLSG_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","lorsqu’ils entrèrent dans la tente d’assignation et qu’ils s’approchèrent de l’autel, ils se lavèrent, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Il dressa le parvis autour du tabernacle et de l’autel, et il mit le rideau à la porte du parvis. Ce fut ainsi que Moïse acheva l’ouvrage. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Alors la nuée couvrit la tente d’assignation, et la gloire de l’Éternel remplit le tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Moïse ne pouvait pas entrer dans la tente d’assignation, parce que la nuée restait dessus, et que la gloire de l’Éternel remplissait le tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Aussi longtemps que durèrent leurs marches, les enfants d’Israël partaient, quand la nuée s’élevait de dessus le tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Et quand la nuée ne s’élevait pas, ils ne partaient pas, jusqu’à ce qu’elle s’élevât. ");
INSERT INTO fraLSG_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","La nuée de l’Éternel était de jour sur le tabernacle; et de nuit, il y avait un feu, aux yeux de toute la maison d’Israël, pendant toutes leurs marches.");
INSERT INTO fraLSG_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","L’Éternel appela Moïse; de la tente d’assignation, il lui parla et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Parle aux enfants d’Israël, et dis-leur: Lorsque quelqu’un d’entre vous fera une offrande à l’Éternel, il offrira du bétail, du gros ou du menu bétail. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Si son offrande est un holocauste de gros bétail, il offrira un mâle sans défaut; il l’offrira à l’entrée de la tente d’assignation, devant l’Éternel, pour obtenir sa faveur. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Il posera sa main sur la tête de l’holocauste, qui sera agréé de l’Éternel, pour lui servir d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Il égorgera le veau devant l’Éternel; et les sacrificateurs, fils d’Aaron, offriront le sang, et le répandront tout autour sur l’autel qui est à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Il dépouillera l’holocauste, et le coupera par morceaux. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Les fils du sacrificateur Aaron mettront du feu sur l’autel, et arrangeront du bois sur le feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Les sacrificateurs, fils d’Aaron, poseront les morceaux, la tête et la graisse, sur le bois mis au feu sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Il lavera avec de l’eau les entrailles et les jambes; et le sacrificateur brûlera le tout sur l’autel. C’est un holocauste, un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Si son offrande est un holocauste de menu bétail, d’agneaux ou de chèvres, il offrira un mâle sans défaut. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Il l’égorgera au côté septentrional de l’autel, devant l’Éternel; et les sacrificateurs, fils d’Aaron, en répandront le sang sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Il le coupera par morceaux; et le sacrificateur les posera, avec la tête et la graisse, sur le bois mis au feu sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Il lavera avec de l’eau les entrailles et les jambes; et le sacrificateur sacrifiera le tout, et le brûlera sur l’autel. C’est un holocauste, un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Si son offrande à l’Éternel est un holocauste d’oiseaux, il offrira des tourterelles ou de jeunes pigeons. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Le sacrificateur sacrifiera l’oiseau sur l’autel; il lui ouvrira la tête avec l’ongle, et la brûlera sur l’autel, et il exprimera le sang contre un côté de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Il ôtera le jabot avec ses plumes, et le jettera près de l’autel, vers l’orient, dans le lieu où l’on met les cendres. ");
INSERT INTO fraLSG_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Il déchirera les ailes, sans les détacher; et le sacrificateur brûlera l’oiseau sur l’autel, sur le bois mis au feu. C’est un holocauste, un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Lorsque quelqu’un fera à l’Éternel une offrande en don, son offrande sera de fleur de farine; il versera de l’huile dessus, et il y ajoutera de l’encens. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Il l’apportera aux sacrificateurs, fils d’Aaron; le sacrificateur prendra une poignée de cette fleur de farine, arrosée d’huile, avec tout l’encens, et il brûlera cela sur l’autel comme souvenir. C’est une offrande d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ce qui restera de l’offrande sera pour Aaron et pour ses fils; c’est une chose très sainte parmi les offrandes consumées par le feu devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Si tu fais une offrande de ce qui est cuit au four, qu’on se serve de fleur de farine, et que ce soient des gâteaux sans levain pétris à l’huile et des galettes sans levain arrosées d’huile. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Si ton offrande est un gâteau cuit à la poêle, il sera de fleur de farine pétrie à l’huile, sans levain. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Tu le rompras en morceaux, et tu verseras de l’huile dessus; c’est une offrande. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Si ton offrande est un gâteau cuit sur le gril, il sera fait de fleur de farine pétrie à l’huile. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Tu apporteras l’offrande qui sera faite à l’Éternel avec ces choses-là; elle sera remise au sacrificateur, qui la présentera sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Le sacrificateur en prélèvera ce qui doit être offert comme souvenir, et le brûlera sur l’autel. C’est une offrande d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ce qui restera de l’offrande sera pour Aaron et pour ses fils; c’est une chose très sainte parmi les offrandes consumées par le feu devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Aucune des offrandes que vous présenterez à l’Éternel ne sera faite avec du levain; car vous ne brûlerez rien qui contienne du levain ou du miel parmi les offrandes consumées par le feu devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Vous pourrez en offrir à l’Éternel comme offrande des prémices; mais il n’en sera point présenté sur l’autel comme offrande d’une agréable odeur. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Tu mettras du sel sur toutes tes offrandes; tu ne laisseras point ton offrande manquer de sel, signe de l’alliance de ton Dieu; sur toutes tes offrandes tu mettras du sel. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Si tu fais à l’Éternel une offrande des prémices, tu présenteras des épis nouveaux, rôtis au feu et broyés, comme offrande de tes prémices. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Tu verseras de l’huile dessus, et tu y ajouteras de l’encens; c’est une offrande. ");
INSERT INTO fraLSG_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Le sacrificateur brûlera comme souvenir une portion des épis broyés et de l’huile, avec tout l’encens. C’est une offrande consumée par le feu devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Lorsque quelqu’un offrira à l’Éternel un sacrifice d’actions de grâces: S’il offre du gros bétail, mâle ou femelle, il l’offrira sans défaut, devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Il posera sa main sur la tête de la victime, qu’il égorgera à l’entrée de la tente d’assignation; et les sacrificateurs, fils d’Aaron, répandront le sang sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","De ce sacrifice d’actions de grâces, il offrira en sacrifice consumé par le feu devant l’Éternel: la graisse qui couvre les entrailles et toute celle qui y est attachée; ");
INSERT INTO fraLSG_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","les deux rognons, et la graisse qui les entoure, qui couvre les flancs, et le grand lobe du foie, qu’il détachera près des rognons. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Les fils d’Aaron brûleront cela sur l’autel, par-dessus l’holocauste qui sera sur le bois mis au feu. C’est un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","S’il offre du menu bétail, mâle ou femelle, en sacrifice d’actions de grâces à l’Éternel, il l’offrira sans défaut. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","S’il offre en sacrifice un agneau, il le présentera devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Il posera sa main sur la tête de la victime, qu’il égorgera devant la tente d’assignation; et les fils d’Aaron en répandront le sang sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","De ce sacrifice d’actions de grâces, il offrira en sacrifice consumé par le feu devant l’Éternel: la graisse, la queue entière, qu’il séparera près de l’échine, la graisse qui couvre les entrailles et toute celle qui y est attachée, ");
INSERT INTO fraLSG_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","les deux rognons, et la graisse qui les entoure, qui couvre les flancs, et le grand lobe du foie, qu’il détachera près des rognons. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Le sacrificateur brûlera cela sur l’autel. C’est l’aliment d’un sacrifice consumé par le feu devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Si son offrande est une chèvre, il la présentera devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Il posera sa main sur la tête de sa victime, qu’il égorgera devant la tente d’assignation; et les fils d’Aaron en répandront le sang sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","De la victime, il offrira en sacrifice consumé par le feu devant l’Éternel: la graisse qui couvre les entrailles et toute celle qui y est attachée, ");
INSERT INTO fraLSG_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","les deux rognons, et la graisse qui les entoure, qui couvre les flancs, et le grand lobe du foie, qu’il détachera près des rognons. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Le sacrificateur brûlera cela sur l’autel. Toute la graisse est l’aliment d’un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","C’est ici une loi perpétuelle pour vos descendants, dans tous les lieux où vous habiterez: vous ne mangerez ni graisse ni sang. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Parle aux enfants d’Israël, et dis: Lorsque quelqu’un péchera involontairement contre l’un des commandements de l’Éternel, en faisant des choses qui ne doivent point se faire; ");
INSERT INTO fraLSG_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Si c’est le sacrificateur ayant reçu l’onction qui a péché et a rendu par là le peuple coupable, il offrira à l’Éternel, pour le péché qu’il a commis, un jeune taureau sans défaut, en sacrifice d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Il amènera le taureau à l’entrée de la tente d’assignation, devant l’Éternel; et il posera sa main sur la tête du taureau, qu’il égorgera devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Le sacrificateur ayant reçu l’onction prendra du sang du taureau, et l’apportera dans la tente d’assignation; ");
INSERT INTO fraLSG_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","il trempera son doigt dans le sang, et il en fera sept fois l’aspersion devant l’Éternel, en face du voile du sanctuaire. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Le sacrificateur mettra du sang sur les cornes de l’autel des parfums odoriférants, qui est devant l’Éternel dans la tente d’assignation; et il répandra tout le sang du taureau au pied de l’autel des holocaustes, qui est à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Il enlèvera toute la graisse du taureau expiatoire, la graisse qui couvre les entrailles et toute celle qui y est attachée, ");
INSERT INTO fraLSG_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","les deux rognons, et la graisse qui les entoure, qui couvre les flancs, et le grand lobe du foie, qu’il détachera près des rognons. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Le sacrificateur enlèvera ces parties comme on les enlève du taureau dans le sacrifice d’actions de grâces, et il les brûlera sur l’autel des holocaustes. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Mais la peau du taureau, toute sa chair, avec sa tête, ses jambes, ses entrailles et ses excréments, ");
INSERT INTO fraLSG_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","le taureau entier, il l’emportera hors du camp, dans un lieu pur, où l’on jette les cendres, et il le brûlera au feu sur du bois: c’est sur le tas de cendres qu’il sera brûlé. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Si c’est toute l’assemblée d’Israël qui a péché involontairement et sans s’en apercevoir, en faisant contre l’un des commandements de l’Éternel des choses qui ne doivent point se faire et en se rendant ainsi coupable, ");
INSERT INTO fraLSG_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","et que le péché qu’on a commis vienne à être découvert, l’assemblée offrira un jeune taureau en sacrifice d’expiation, et on l’amènera devant la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Les anciens d’Israël poseront leurs mains sur la tête du taureau devant l’Éternel, et on égorgera le taureau devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Le sacrificateur ayant reçu l’onction apportera du sang du taureau dans la tente d’assignation; ");
INSERT INTO fraLSG_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","il trempera son doigt dans le sang, et il en fera sept fois l’aspersion devant l’Éternel, en face du voile. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Il mettra du sang sur les cornes de l’autel qui est devant l’Éternel dans la tente d’assignation; et il répandra tout le sang au pied de l’autel des holocaustes, qui est à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Il enlèvera toute la graisse du taureau, et il la brûlera sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Il fera de ce taureau comme du taureau expiatoire; il fera de même. C’est ainsi que le sacrificateur fera pour eux l’expiation, et il leur sera pardonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Il emportera le taureau hors du camp, et il le brûlera comme le premier taureau. C’est un sacrifice d’expiation pour l’assemblée. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Si c’est un chef qui a péché, en faisant involontairement contre l’un des commandements de l’Éternel, son Dieu, des choses qui ne doivent point se faire et en se rendant ainsi coupable, ");
INSERT INTO fraLSG_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","et qu’il vienne à découvrir le péché qu’il a commis, il offrira en sacrifice un bouc mâle sans défaut. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Il posera sa main sur la tête du bouc, qu’il égorgera dans le lieu où l’on égorge les holocaustes devant l’Éternel. C’est un sacrifice d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Le sacrificateur prendra avec son doigt du sang de la victime expiatoire, il en mettra sur les cornes de l’autel des holocaustes, et il répandra le sang au pied de l’autel des holocaustes. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Il brûlera toute la graisse sur l’autel, comme la graisse du sacrifice d’actions de grâces. C’est ainsi que le sacrificateur fera pour ce chef l’expiation de son péché, et il lui sera pardonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Si c’est quelqu’un du peuple qui a péché involontairement, en faisant contre l’un des commandements de l’Éternel des choses qui ne doivent point se faire et en se rendant ainsi coupable, ");
INSERT INTO fraLSG_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","et qu’il vienne à découvrir le péché qu’il a commis, il offrira en sacrifice une chèvre, une femelle sans défaut, pour le péché qu’il a commis. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Il posera sa main sur la tête de la victime expiatoire, qu’il égorgera dans le lieu où l’on égorge les holocaustes. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Le sacrificateur prendra avec son doigt du sang de la victime, il en mettra sur les cornes de l’autel des holocaustes, et il répandra tout le sang au pied de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Le sacrificateur ôtera toute la graisse, comme on ôte la graisse du sacrifice d’actions de grâces, et il la brûlera sur l’autel, et elle sera d’une agréable odeur à l’Éternel. C’est ainsi que le sacrificateur fera pour cet homme l’expiation, et il lui sera pardonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","S’il offre un agneau en sacrifice d’expiation, il offrira une femelle sans défaut. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Il posera sa main sur la tête de la victime, qu’il égorgera en sacrifice d’expiation dans le lieu où l’on égorge les holocaustes. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Le sacrificateur prendra avec son doigt du sang de la victime, il en mettra sur les cornes de l’autel des holocaustes, et il répandra tout le sang au pied de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Le sacrificateur ôtera toute la graisse, comme on ôte la graisse de l’agneau dans le sacrifice d’actions de grâces, et il la brûlera sur l’autel, comme un sacrifice consumé par le feu devant l’Éternel. C’est ainsi que le sacrificateur fera pour cet homme l’expiation du péché qu’il a commis, et il lui sera pardonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Lorsque quelqu’un, après avoir été mis sous serment comme témoin, péchera en ne déclarant pas ce qu’il a vu ou ce qu’il sait, il restera chargé de sa faute. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Lorsque quelqu’un, sans s’en apercevoir, touchera une chose souillée, comme le cadavre d’un animal impur, que ce soit d’une bête sauvage ou domestique, ou bien d’un reptile, il deviendra lui-même impur et il se rendra coupable. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Lorsque, sans y prendre garde, il touchera une souillure humaine quelconque, et qu’il s’en aperçoive plus tard, il en sera coupable. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Lorsque quelqu’un, parlant à la légère, jure de faire du mal ou du bien, et que, ne l’ayant pas remarqué d’abord, il s’en aperçoive plus tard, il en sera coupable. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Celui donc qui se rendra coupable de l’une de ces choses, fera l’aveu de son péché. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Puis il offrira en sacrifice de culpabilité à l’Éternel, pour le péché qu’il a commis, une femelle de menu bétail, une brebis ou une chèvre, comme victime expiatoire. Et le sacrificateur fera pour lui l’expiation de son péché. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","S’il n’a pas de quoi se procurer une brebis ou une chèvre, il offrira en sacrifice de culpabilité à l’Éternel pour son péché deux tourterelles ou deux jeunes pigeons, l’un comme victime expiatoire, l’autre comme holocauste. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Il les apportera au sacrificateur, qui sacrifiera d’abord celui qui doit servir de victime expiatoire. Le sacrificateur lui ouvrira la tête avec l’ongle près de la nuque, sans la séparer; ");
INSERT INTO fraLSG_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","il fera sur un côté de l’autel l’aspersion du sang de la victime expiatoire, et le reste du sang sera exprimé au pied de l’autel: c’est un sacrifice d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Il fera de l’autre oiseau un holocauste, d’après les règles établies. C’est ainsi que le sacrificateur fera pour cet homme l’expiation du péché qu’il a commis, et il lui sera pardonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","S’il n’a pas de quoi se procurer deux tourterelles ou deux jeunes pigeons, il apportera en offrande pour son péché un dixième d’épha de fleur de farine, comme offrande d’expiation; il ne mettra point d’huile dessus, et il n’y ajoutera point d’encens, car c’est une offrande d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Il l’apportera au sacrificateur, et le sacrificateur en prendra une poignée comme souvenir, et il la brûlera sur l’autel, comme les offrandes consumées par le feu devant l’Éternel: c’est une offrande d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","C’est ainsi que le sacrificateur fera pour cet homme l’expiation du péché qu’il a commis à l’égard de l’une de ces choses, et il lui sera pardonné. Ce qui restera de l’offrande sera pour le sacrificateur, comme dans l’offrande en don. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Lorsque quelqu’un commettra une infidélité et péchera involontairement à l’égard des choses consacrées à l’Éternel, il offrira en sacrifice de culpabilité à l’Éternel pour son péché un bélier sans défaut, pris du troupeau d’après ton estimation en sicles d’argent, selon le sicle du sanctuaire. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Il donnera, en y ajoutant un cinquième, la valeur de la chose dont il a frustré le sanctuaire, et il la remettra au sacrificateur. Et le sacrificateur fera pour lui l’expiation avec le bélier offert en sacrifice de culpabilité, et il lui sera pardonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Lorsque quelqu’un péchera en faisant, sans le savoir, contre l’un des commandements de l’Éternel, des choses qui ne doivent point se faire, il se rendra coupable et sera chargé de sa faute. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Il présentera au sacrificateur en sacrifice de culpabilité un bélier sans défaut, pris du troupeau d’après ton estimation. Et le sacrificateur fera pour lui l’expiation de la faute qu’il a commise sans le savoir, et il lui sera pardonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","C’est un sacrifice de culpabilité. Cet homme s’était rendu coupable envers l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","Lorsque quelqu’un péchera et commettra une infidélité envers l’Éternel, en mentant à son prochain au sujet d’un dépôt, d’un objet confié à sa garde, d’une chose volée ou soustraite par fraude, ");
INSERT INTO fraLSG_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","en niant d’avoir trouvé une chose perdue, ou en faisant un faux serment sur une chose quelconque de nature à constituer un péché; ");
INSERT INTO fraLSG_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","lorsqu’il péchera ainsi et se rendra coupable, il restituera la chose qu’il a volée ou soustraite par fraude, la chose qui lui avait été confiée en dépôt, la chose perdue qu’il a trouvée, ");
INSERT INTO fraLSG_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ou la chose quelconque sur laquelle il a fait un faux serment. Il la restituera en son entier, y ajoutera un cinquième, et la remettra à son propriétaire, le jour même où il offrira son sacrifice de culpabilité. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Il présentera au sacrificateur en sacrifice de culpabilité à l’Éternel pour son péché un bélier sans défaut, pris du troupeau d’après ton estimation. ");
INSERT INTO fraLSG_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Et le sacrificateur fera pour lui l’expiation devant l’Éternel, et il lui sera pardonné, quelle que soit la faute dont il se sera rendu coupable. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Donne cet ordre à Aaron et à ses fils, et dis: Voici la loi de l’holocauste. L’holocauste restera sur le foyer de l’autel toute la nuit jusqu’au matin, et le feu brûlera sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Le sacrificateur revêtira sa tunique de lin, et mettra des caleçons sur sa chair, il enlèvera la cendre faite par le feu qui aura consumé l’holocauste sur l’autel, et il la déposera près de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Puis il quittera ses vêtements et en mettra d’autres, pour porter la cendre hors du camp, dans un lieu pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Le feu brûlera sur l’autel, il ne s’éteindra point; chaque matin, le sacrificateur y allumera du bois, arrangera l’holocauste, et brûlera la graisse des sacrifices d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Le feu brûlera continuellement sur l’autel, il ne s’éteindra point. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Voici la loi de l’offrande. Les fils d’Aaron la présenteront devant l’Éternel, devant l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Le sacrificateur prélèvera une poignée de la fleur de farine et de l’huile, avec tout l’encens ajouté à l’offrande, et il brûlera cela sur l’autel comme souvenir d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Aaron et ses fils mangeront ce qui restera de l’offrande; ils le mangeront sans levain, dans un lieu saint, dans le parvis de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","On ne le cuira pas avec du levain. C’est la part que je leur ai donnée de mes offrandes consumées par le feu. C’est une chose très sainte, comme le sacrifice d’expiation et comme le sacrifice de culpabilité. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Tout mâle d’entre les enfants d’Aaron en mangera. C’est une loi perpétuelle pour vos descendants, au sujet des offrandes consumées par le feu devant l’Éternel: quiconque y touchera sera sanctifié. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Voici l’offrande qu’Aaron et ses fils feront à l’Éternel, le jour où ils recevront l’onction: un dixième d’épha de fleur de farine, comme offrande perpétuelle, moitié le matin et moitié le soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Elle sera préparée à la poêle avec de l’huile, et tu l’apporteras frite; tu la présenteras aussi cuite et en morceaux comme une offrande d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Le sacrificateur qui, parmi les fils d’Aaron, sera oint pour lui succéder, fera aussi cette offrande. C’est une loi perpétuelle devant l’Éternel: elle sera brûlée en entier. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Toute offrande d’un sacrificateur sera brûlée en entier; elle ne sera point mangée. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Parle à Aaron et à ses fils, et dis: Voici la loi du sacrifice d’expiation. C’est dans le lieu où l’on égorge l’holocauste que sera égorgée devant l’Éternel la victime pour le sacrifice d’expiation: c’est une chose très sainte. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Le sacrificateur qui offrira la victime expiatoire la mangera; elle sera mangée dans un lieu saint, dans le parvis de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Quiconque en touchera la chair sera sanctifié. S’il en rejaillit du sang sur un vêtement, la place sur laquelle il aura rejailli sera lavée dans un lieu saint. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Le vase de terre dans lequel elle aura cuit sera brisé; si c’est dans un vase d’airain qu’elle a cuit, il sera nettoyé et lavé dans l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Tout mâle parmi les sacrificateurs en mangera: c’est une chose très sainte. ");
INSERT INTO fraLSG_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Mais on ne mangera aucune victime expiatoire dont on apportera du sang dans la tente d’assignation, pour faire l’expiation dans le sanctuaire: elle sera brûlée au feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Voici la loi du sacrifice de culpabilité: c’est une chose très sainte. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","C’est dans le lieu où l’on égorge l’holocauste que sera égorgée la victime pour le sacrifice de culpabilité. On en répandra le sang sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","On en offrira toute la graisse, la queue, la graisse qui couvre les entrailles, ");
INSERT INTO fraLSG_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","les deux rognons, et la graisse qui les entoure, qui couvre les flancs, et le grand lobe du foie, qu’on détachera près des rognons. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Le sacrificateur brûlera cela sur l’autel en sacrifice consumé devant l’Éternel. C’est un sacrifice de culpabilité. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Tout mâle parmi les sacrificateurs en mangera; il le mangera dans un lieu saint: c’est une chose très sainte. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Il en est du sacrifice de culpabilité comme du sacrifice d’expiation; la loi est la même pour ces deux sacrifices: la victime sera pour le sacrificateur qui fera l’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Le sacrificateur qui offrira l’holocauste de quelqu’un aura pour lui la peau de l’holocauste qu’il a offert. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Toute offrande cuite au four, préparée sur le gril ou à la poêle, sera pour le sacrificateur qui l’a offerte. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Toute offrande pétrie à l’huile et sèche sera pour tous les fils d’Aaron, pour l’un comme pour l’autre. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Voici la loi du sacrifice d’actions de grâces, qu’on offrira à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Si quelqu’un l’offre par reconnaissance, il offrira, avec le sacrifice d’actions de grâces, des gâteaux sans levain pétris à l’huile, des galettes sans levain arrosées d’huile, et des gâteaux de fleur de farine frite et pétris à l’huile. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","A ces gâteaux il ajoutera du pain levé pour son offrande, avec son sacrifice de reconnaissance et d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","On présentera par élévation à l’Éternel une portion de chaque offrande; elle sera pour le sacrificateur qui a répandu le sang de la victime d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","La chair du sacrifice de reconnaissance et d’actions de grâces sera mangée le jour où il est offert; on n’en laissera rien jusqu’au matin. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Si quelqu’un offre un sacrifice pour l’accomplissement d’un vœu ou comme offrande volontaire, la victime sera mangée le jour où il l’offrira, et ce qui en restera sera mangé le lendemain. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Ce qui restera de la chair de la victime sera brûlé au feu le troisième jour. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Dans le cas où l’on mangerait de la chair de son sacrifice d’actions de grâces le troisième jour, le sacrifice ne sera point agréé; il n’en sera pas tenu compte à celui qui l’a offert; ce sera une chose infecte, et quiconque en mangera restera chargé de sa faute. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","La chair qui a touché quelque chose d’impur ne sera point mangée: elle sera brûlée au feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Tout homme pur peut manger de la chair; mais celui qui, se trouvant en état d’impureté, mangera de la chair du sacrifice d’actions de grâces qui appartient à l’Éternel, celui-là sera retranché de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Et celui qui touchera quelque chose d’impur, une souillure humaine, un animal impur, ou quoi que ce soit d’impur, et qui mangera de la chair du sacrifice d’actions de grâces qui appartient à l’Éternel, celui-là sera retranché de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Parle aux enfants d’Israël, et dis: Vous ne mangerez point de graisse de bœuf, d’agneau ni de chèvre. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","La graisse d’une bête morte ou déchirée pourra servir à un usage quelconque; mais vous ne la mangerez point. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Car celui qui mangera de la graisse des animaux dont on offre à l’Éternel des sacrifices consumés par le feu, celui-là sera retranché de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Vous ne mangerez point de sang, ni d’oiseau, ni de bétail, dans tous les lieux où vous habiterez. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Celui qui mangera du sang d’une espèce quelconque, celui-là sera retranché de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Parle aux enfants d’Israël, et dis: Celui qui offrira à l’Éternel son sacrifice d’actions de grâces apportera son offrande à l’Éternel, prise sur son sacrifice d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Il apportera de ses propres mains ce qui doit être consumé par le feu devant l’Éternel; il apportera la graisse avec la poitrine, la poitrine pour l’agiter de côté et d’autre devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Le sacrificateur brûlera la graisse sur l’autel, et la poitrine sera pour Aaron et pour ses fils. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Dans vos sacrifices d’actions de grâces, vous donnerez au sacrificateur l’épaule droite, en la présentant par élévation. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Celui des fils d’Aaron qui offrira le sang et la graisse du sacrifice d’actions de grâces aura l’épaule droite pour sa part. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Car je prends sur les sacrifices d’actions de grâces offerts par les enfants d’Israël la poitrine qu’on agitera de côté et d’autre et l’épaule qu’on présentera par élévation, et je les donne au sacrificateur Aaron et à ses fils, par une loi perpétuelle qu’observeront les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","C’est là le droit que l’onction d’Aaron et de ses fils leur donnera sur les sacrifices consumés par le feu devant l’Éternel, depuis le jour où ils seront présentés pour être à mon service dans le sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","C’est ce que l’Éternel ordonne aux enfants d’Israël de leur donner depuis le jour de leur onction; ce sera une loi perpétuelle parmi leurs descendants. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Telle est la loi de l’holocauste, de l’offrande, du sacrifice d’expiation, du sacrifice de culpabilité, de la consécration, et du sacrifice d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","L’Éternel la prescrivit à Moïse sur la montagne de Sinaï, le jour où il ordonna aux enfants d’Israël de présenter leurs offrandes à l’Éternel dans le désert du Sinaï. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Prends Aaron et ses fils avec lui, les vêtements, l’huile d’onction, le taureau expiatoire, les deux béliers et la corbeille de pains sans levain; ");
INSERT INTO fraLSG_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","et convoque toute l’assemblée à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Moïse fit ce que l’Éternel lui avait ordonné; et l’assemblée se réunit à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Moïse dit à l’assemblée: Voici ce que l’Éternel a ordonné de faire. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Moïse fit approcher Aaron et ses fils, et il les lava avec de l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Il mit à Aaron la tunique, il le ceignit de la ceinture, il le revêtit de la robe, et il plaça sur lui l’éphod, qu’il serra avec la ceinture de l’éphod dont il le revêtit. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Il lui mit le pectoral, et il joignit au pectoral l’urim et le thummim. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Il posa la tiare sur sa tête, et il plaça sur le devant de la tiare la lame d’or, diadème sacré, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Moïse prit l’huile d’onction, il oignit le sanctuaire et toutes les choses qui y étaient, et le sanctifia. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Il en fit sept fois l’aspersion sur l’autel, et il oignit l’autel et tous ses ustensiles, et la cuve avec sa base, afin de les sanctifier. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Il répandit de l’huile d’onction sur la tête d’Aaron, et l’oignit, afin de la sanctifier. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Moïse fit aussi approcher les fils d’Aaron; il les revêtit de tuniques, les ceignit de ceintures, et leur attacha des bonnets, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Il fit approcher le taureau expiatoire, et Aaron et ses fils posèrent leurs mains sur la tête du taureau expiatoire. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Moïse l’égorgea, prit du sang, et en mit avec son doigt sur les cornes de l’autel tout autour, et purifia l’autel; il répandit le sang au pied de l’autel, et le sanctifia pour y faire l’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Il prit toute la graisse qui couvre les entrailles, le grand lobe du foie, et les deux rognons avec leur graisse, et il brûla cela sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Mais il brûla au feu hors du camp le taureau, sa peau, sa chair et ses excréments, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Il fit approcher le bélier de l’holocauste, et Aaron et ses fils posèrent leurs mains sur la tête du bélier. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Moïse l’égorgea, et répandit le sang sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Il coupa le bélier par morceaux, et il brûla la tête, les morceaux et la graisse. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Il lava avec de l’eau les entrailles et les jambes, et il brûla tout le bélier sur l’autel: ce fut l’holocauste, ce fut un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Il fit approcher l’autre bélier, le bélier de consécration, et Aaron et ses fils posèrent leurs mains sur la tête du bélier. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Moïse égorgea le bélier, prit de son sang, et en mit sur le lobe de l’oreille droite d’Aaron, sur le pouce de sa main droite et sur le gros orteil de son pied droit. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Il fit approcher les fils d’Aaron, mit du sang sur le lobe de leur oreille droite, sur le pouce de leur main droite et sur le gros orteil de leur pied droit, et il répandit le sang sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Il prit la graisse, la queue, toute la graisse qui couvre les entrailles, le grand lobe du foie, les deux rognons avec leur graisse, et l’épaule droite; ");
INSERT INTO fraLSG_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","il prit aussi dans la corbeille de pains sans levain, placée devant l’Éternel, un gâteau sans levain, un gâteau de pain à l’huile et une galette, et il les posa sur les graisses et sur l’épaule droite. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Il mit toutes ces choses sur les mains d’Aaron et sur les mains de ses fils, et il les agita de côté et d’autre devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Puis Moïse les ôta de leurs mains, et il les brûla sur l’autel, par-dessus l’holocauste: ce fut le sacrifice de consécration, ce fut un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Moïse prit la poitrine du bélier de consécration, et il l’agita de côté et d’autre devant l’Éternel: ce fut la portion de Moïse, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Moïse prit de l’huile d’onction et du sang qui était sur l’autel; il en fit l’aspersion sur Aaron et sur ses vêtements, sur les fils d’Aaron et sur leurs vêtements; et il sanctifia Aaron et ses vêtements, les fils d’Aaron et leurs vêtements avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Moïse dit à Aaron et à ses fils: Faites cuire la chair à l’entrée de la tente d’assignation; c’est là que vous la mangerez, avec le pain qui est dans la corbeille de consécration, comme je l’ai ordonné, en disant: Aaron et ses fils la mangeront. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Vous brûlerez dans le feu ce qui restera de la chair et du pain. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Pendant sept jours, vous ne sortirez point de l’entrée de la tente d’assignation, jusqu’à ce que les jours de votre consécration soient accomplis; car sept jours seront employés à vous consacrer. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ce qui s’est fait aujourd’hui, l’Éternel a ordonné de le faire comme expiation pour vous. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Vous resterez donc sept jours à l’entrée de la tente d’assignation, jour et nuit, et vous observerez les commandements de l’Éternel, afin que vous ne mouriez pas; car c’est là ce qui m’a été ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aaron et ses fils firent toutes les choses que l’Éternel avait ordonnées par Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Le huitième jour, Moïse appela Aaron et ses fils, et les anciens d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Il dit à Aaron: Prends un jeune veau pour le sacrifice d’expiation, et un bélier pour l’holocauste, l’un et l’autre sans défaut, et sacrifie-les devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Tu parleras aux enfants d’Israël, et tu diras: Prenez un bouc, pour le sacrifice d’expiation, un veau et un agneau, âgés d’un an et sans défaut, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","un bœuf et un bélier, pour le sacrifice d’actions de grâces, afin de les sacrifier devant l’Éternel; et une offrande pétrie à l’huile. Car aujourd’hui l’Éternel vous apparaîtra. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ils amenèrent devant la tente d’assignation ce que Moïse avait ordonné; et toute l’assemblée s’approcha, et se tint devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Moïse dit: Vous ferez ce que l’Éternel a ordonné; et la gloire de l’Éternel vous apparaîtra. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Moïse dit à Aaron: Approche-toi de l’autel; offre ton sacrifice d’expiation et ton holocauste, et fais l’expiation pour toi et pour le peuple; offre aussi le sacrifice du peuple, et fais l’expiation pour lui, comme l’Éternel l’a ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaron s’approcha de l’autel, et il égorgea le veau pour son sacrifice d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Les fils d’Aaron lui présentèrent le sang; il trempa son doigt dans le sang, en mit sur les cornes de l’autel, et répandit le sang au pied de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Il brûla sur l’autel la graisse, les rognons, et le grand lobe du foie de la victime expiatoire, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Mais il brûla au feu hors du camp la chair et la peau. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Il égorgea l’holocauste. Les fils d’Aaron lui présentèrent le sang, et il le répandit sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ils lui présentèrent l’holocauste coupé par morceaux, avec la tête, et il les brûla sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Il lava les entrailles et les jambes, et il les brûla sur l’autel, par dessus l’holocauste. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ensuite, il offrit le sacrifice du peuple. Il prit le bouc pour le sacrifice expiatoire du peuple, il l’égorgea, et l’offrit en expiation, comme la première victime. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Il offrit l’holocauste, et le sacrifia, d’après les règles établies. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Il présenta l’offrande, en prit une poignée, et la brûla sur l’autel, outre l’holocauste du matin. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Il égorgea le bœuf et le bélier, en sacrifice d’actions de grâces pour le peuple. Les fils d’Aaron lui présentèrent le sang, et il le répandit sur l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ils lui présentèrent la graisse du bœuf et du bélier, la queue, la graisse qui couvre les entrailles, les rognons, et le grand lobe du foie; ");
INSERT INTO fraLSG_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ils mirent les graisses sur les poitrines, et il brûla les graisses sur l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aaron agita de côté et d’autre devant l’Éternel les poitrines et l’épaule droite, comme Moïse l’avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aaron leva ses mains vers le peuple, et il le bénit. Puis il descendit, après avoir offert le sacrifice d’expiation, l’holocauste et le sacrifice d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Moïse et Aaron entrèrent dans la tente d’assignation. Lorsqu’ils en sortirent, ils bénirent le peuple. Et la gloire de l’Éternel apparut à tout le peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Le feu sortit de devant l’Éternel, et consuma sur l’autel l’holocauste et les graisses. Tout le peuple le vit; et ils poussèrent des cris de joie, et se jetèrent sur leur face. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Les fils d’Aaron, Nadab et Abihu, prirent chacun un brasier, y mirent du feu, et posèrent du parfum dessus; ils apportèrent devant l’Éternel du feu étranger, ce qu’il ne leur avait point ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Alors le feu sortit de devant l’Éternel, et les consuma: ils moururent devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Moïse dit à Aaron: C’est ce que l’Éternel a déclaré, lorsqu’il a dit: Je serai sanctifié par ceux qui s’approchent de moi, et je serai glorifié en présence de tout le peuple. Aaron garda le silence. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Et Moïse appela Mischaël et Eltsaphan, fils d’Uziel, oncle d’Aaron, et il leur dit: Approchez-vous, emportez vos frères loin du sanctuaire, hors du camp. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Ils s’approchèrent, et ils les emportèrent dans leurs tuniques hors du camp, comme Moïse l’avait dit. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Moïse dit à Aaron, à Éléazar et à Ithamar, fils d’Aaron: Vous ne découvrirez point vos têtes, et vous ne déchirerez point vos vêtements, de peur que vous ne mouriez, et que l’Éternel ne s’irrite contre toute l’assemblée. Laissez vos frères, toute la maison d’Israël, pleurer sur l’embrasement que l’Éternel a allumé. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Vous ne sortirez point de l’entrée de la tente d’assignation, de peur que vous ne mouriez; car l’huile de l’onction de l’Éternel est sur vous. Ils firent ce que Moïse avait dit. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","L’Éternel parla à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Tu ne boiras ni vin, ni boisson enivrante, toi et tes fils avec toi, lorsque vous entrerez dans la tente d’assignation, de peur que vous ne mouriez: ce sera une loi perpétuelle parmi vos descendants, ");
INSERT INTO fraLSG_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","afin que vous puissiez distinguer ce qui est saint de ce qui est profane, ce qui est impur de ce qui est pur, ");
INSERT INTO fraLSG_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","et enseigner aux enfants d’Israël toutes les lois que l’Éternel leur a données par Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Moïse dit à Aaron, à Éléazar et à Ithamar, les deux fils qui restaient à Aaron: Prenez ce qui reste de l’offrande parmi les sacrifices consumés par le feu devant l’Éternel, et mangez-le sans levain près de l’autel: car c’est une chose très sainte. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Vous le mangerez dans un lieu saint; c’est ton droit et le droit de tes fils sur les offrandes consumées par le feu devant l’Éternel; car c’est là ce qui m’a été ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Vous mangerez aussi dans un lieu pur, toi, tes fils et tes filles avec toi, la poitrine qu’on a agitée de côté et d’autre et l’épaule qui a été présentée par élévation; car elles vous sont données, comme ton droit et le droit de tes fils, dans les sacrifices d’actions de grâces des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Ils apporteront, avec les graisses destinées à être consumées par le feu, l’épaule que l’on présente par élévation et la poitrine que l’on agite de côté et d’autre devant l’Éternel: elles seront pour toi et pour tes fils avec toi, par une loi perpétuelle, comme l’Éternel l’a ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Moïse chercha le bouc expiatoire; et voici, il avait été brûlé. Alors il s’irrita contre Éléazar et Ithamar, les fils qui restaient à Aaron, et il dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Pourquoi n’avez-vous pas mangé la victime expiatoire dans le lieu saint? C’est une chose très sainte; et l’Éternel vous l’a donnée, afin que vous portiez l’iniquité de l’assemblée, afin que vous fassiez pour elle l’expiation devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Voici, le sang de la victime n’a point été porté dans l’intérieur du sanctuaire; vous deviez la manger dans le sanctuaire, comme cela m’avait été ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron dit à Moïse: Voici, ils ont offert aujourd’hui leur sacrifice d’expiation et leur holocauste devant l’Éternel; et, après ce qui m’est arrivé, si j’eusse mangé aujourd’hui la victime expiatoire, cela aurait-il été bien aux yeux de l’Éternel? ");
INSERT INTO fraLSG_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Moïse entendit et approuva ces paroles. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","L’Éternel parla à Moïse et à Aaron, et leur dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Parlez aux enfants d’Israël, et dites: Voici les animaux dont vous mangerez parmi toutes les bêtes qui sont sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Vous mangerez de tout animal qui a la corne fendue, le pied fourchu, et qui rumine. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Mais vous ne mangerez pas de ceux qui ruminent seulement, ou qui ont la corne fendue seulement. Ainsi, vous ne mangerez pas le chameau, qui rumine, mais qui n’a pas la corne fendue: vous le regarderez comme impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Vous ne mangerez pas le daman, qui rumine, mais qui n’a pas la corne fendue: vous le regarderez comme impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Vous ne mangerez pas le lièvre, qui rumine, mais qui n’a pas la corne fendue: vous le regarderez comme impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Vous ne mangerez pas le porc, qui a la corne fendue et le pied fourchu, mais qui ne rumine pas: vous le regarderez comme impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Vous ne mangerez pas de leur chair, et vous ne toucherez pas leurs corps morts: vous les regarderez comme impurs. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Voici les animaux dont vous mangerez parmi tous ceux qui sont dans les eaux. Vous mangerez de tous ceux qui ont des nageoires et des écailles, et qui sont dans les eaux, soit dans les mers, soit dans les rivières. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Mais vous aurez en abomination tous ceux qui n’ont pas des nageoires et des écailles, parmi tout ce qui se meut dans les eaux et tout ce qui est vivant dans les eaux, soit dans les mers, soit dans les rivières. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Vous les aurez en abomination, vous ne mangerez pas de leur chair, et vous aurez en abomination leurs corps morts. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Vous aurez en abomination tous ceux qui, dans les eaux, n’ont pas des nageoires et des écailles. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Voici, parmi les oiseaux, ceux que vous aurez en abomination, et dont on ne mangera pas: l’aigle, l’orfraie et l’aigle de mer; ");
INSERT INTO fraLSG_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","le milan, l’autour et ce qui est de son espèce; ");
INSERT INTO fraLSG_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","le corbeau et toutes ses espèces; ");
INSERT INTO fraLSG_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","l’autruche, le hibou, la mouette, l’épervier et ce qui est de son espèce; ");
INSERT INTO fraLSG_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","le chat-huant, le plongeon et la chouette; ");
INSERT INTO fraLSG_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","le cygne, le pélican et le cormoran; ");
INSERT INTO fraLSG_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","la cigogne, le héron et ce qui est de son espèce, la huppe et la chauve-souris. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Vous aurez en abomination tout reptile qui vole et qui marche sur quatre pieds. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Mais, parmi tous les reptiles qui volent et qui marchent sur quatre pieds, vous mangerez ceux qui ont des jambes au-dessus de leurs pieds, pour sauter sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Voici ceux que vous mangerez: la sauterelle, le solam, le hargol et le hagab, selon leurs espèces. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Vous aurez en abomination tous les autres reptiles qui volent et qui ont quatre pieds. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Ils vous rendront impurs: quiconque touchera leurs corps morts sera impur jusqu’au soir, ");
INSERT INTO fraLSG_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","et quiconque portera leurs corps morts lavera ses vêtements et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Vous regarderez comme impur tout animal qui a la corne fendue, mais qui n’a pas le pied fourchu et qui ne rumine pas: quiconque le touchera sera impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Vous regarderez comme impurs tous ceux des animaux à quatre pieds qui marchent sur leurs pattes: quiconque touchera leurs corps morts sera impur jusqu’au soir, ");
INSERT INTO fraLSG_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","et quiconque portera leurs corps morts lavera ses vêtements et sera impur jusqu’au soir. Vous les regarderez comme impurs. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Voici, parmi les animaux qui rampent sur la terre, ceux que vous regarderez comme impurs: la taupe, la souris et le lézard, selon leurs espèces; ");
INSERT INTO fraLSG_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","le hérisson, la grenouille, la tortue, le limaçon et le caméléon. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Vous les regarderez comme impurs parmi tous les reptiles: quiconque les touchera morts sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Tout objet sur lequel tombera quelque chose de leurs corps morts sera souillé, ustensile de bois, vêtement, peau, sac, tout objet dont on fait usage; il sera mis dans l’eau, et restera souillé jusqu’au soir; après quoi, il sera pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Tout ce qui se trouvera dans un vase de terre où il en tombera quelque chose, sera souillé, et vous briserez le vase. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Tout aliment qui sert à la nourriture, et sur lequel il sera tombé de cette eau, sera souillé; et toute boisson dont on fait usage, quel que soit le vase qui la contienne, sera souillée. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Tout objet sur lequel tombera quelque chose de leurs corps morts sera souillé; le four et le foyer seront détruits: ils seront souillés, et vous les regarderez comme souillés. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Il n’y aura que les sources et les citernes, formant des amas d’eaux, qui resteront pures; mais celui qui y touchera de leurs corps morts sera impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","S’il tombe quelque chose de leurs corps morts sur une semence qui doit être semée, elle restera pure; ");
INSERT INTO fraLSG_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","mais si l’on a mis de l’eau sur la semence, et qu’il y tombe quelque chose de leurs corps morts, vous la regarderez comme souillée. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","S’il meurt un des animaux qui vous servent de nourriture, celui qui touchera son corps mort sera impur jusqu’au soir; ");
INSERT INTO fraLSG_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","celui qui mangera de son corps mort lavera ses vêtements et sera impur jusqu’au soir, et celui qui portera son corps mort lavera ses vêtements et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Vous aurez en abomination tout reptile qui rampe sur la terre: on n’en mangera point. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Vous ne mangerez point, parmi tous les reptiles qui rampent sur la terre, de tous ceux qui se traînent sur le ventre, ni de tous ceux qui marchent sur quatre pieds ou sur un grand nombre de pieds; car vous les aurez en abomination. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ne rendez point vos personnes abominables par tous ces reptiles qui rampent; ne vous rendez point impurs par eux, ne vous souillez point par eux. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Car je suis l’Éternel, votre Dieu; vous vous sanctifierez, et vous serez saints, car je suis saint; et vous ne vous rendrez point impurs par tous ces reptiles qui rampent sur la terre. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Car je suis l’Éternel, qui vous ai fait monter du pays d’Égypte, pour être votre Dieu, et pour que vous soyez saints; car je suis saint. ");
INSERT INTO fraLSG_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Telle est la loi touchant les animaux, les oiseaux, tous les êtres vivants qui se meuvent dans les eaux, et tous les êtres qui rampent sur la terre, ");
INSERT INTO fraLSG_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","afin que vous distinguiez ce qui est impur et ce qui est pur, l’animal qui se mange et l’animal qui ne se mange pas. ");
INSERT INTO fraLSG_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Parle aux enfants d’Israël, et dis: Lorsqu’une femme deviendra enceinte, et qu’elle enfantera un mâle, elle sera impure pendant sept jours; elle sera impure comme au temps de son indisposition menstruelle. ");
INSERT INTO fraLSG_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Le huitième jour, l’enfant sera circoncis. ");
INSERT INTO fraLSG_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Elle restera encore trente-trois jours à se purifier de son sang; elle ne touchera aucune chose sainte, et elle n’ira point au sanctuaire, jusqu’à ce que les jours de sa purification soient accomplis. ");
INSERT INTO fraLSG_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Si elle enfante une fille, elle sera impure pendant deux semaines, comme au temps de son indisposition menstruelle; elle restera soixante-six jours à se purifier de son sang. ");
INSERT INTO fraLSG_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Lorsque les jours de sa purification seront accomplis, pour un fils ou pour une fille, elle apportera au sacrificateur, à l’entrée de la tente d’assignation, un agneau d’un an pour l’holocauste, et un jeune pigeon ou une tourterelle pour le sacrifice d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Le sacrificateur les sacrifiera devant l’Éternel, et fera pour elle l’expiation; et elle sera purifiée du flux de son sang. Telle est la loi pour la femme qui enfante un fils ou une fille. ");
INSERT INTO fraLSG_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Si elle n’a pas de quoi se procurer un agneau, elle prendra deux tourterelles ou deux jeunes pigeons, l’un pour l’holocauste, l’autre pour le sacrifice d’expiation. Le sacrificateur fera pour elle l’expiation, et elle sera pure. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","L’Éternel parla à Moïse et à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Lorsqu’un homme aura sur la peau de son corps une tumeur, une dartre, ou une tache blanche, qui ressemblera à une plaie de lèpre sur la peau de son corps, on l’amènera au sacrificateur Aaron, ou à l’un de ses fils qui sont sacrificateurs. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Le sacrificateur examinera la plaie qui est sur la peau du corps. Si le poil de la plaie est devenu blanc, et que la plaie paraisse plus profonde que la peau du corps, c’est une plaie de lèpre: le sacrificateur qui aura fait l’examen déclarera cet homme impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","S’il y a sur la peau du corps une tache blanche qui ne paraisse pas plus profonde que la peau, et que le poil ne soit pas devenu blanc, le sacrificateur enfermera pendant sept jours celui qui a la plaie. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Le sacrificateur l’examinera le septième jour. Si la plaie lui paraît ne pas avoir fait de progrès et ne pas s’être étendue sur la peau, le sacrificateur l’enfermera une seconde fois pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Le sacrificateur l’examinera une seconde fois le septième jour. Si la plaie est devenue pâle et ne s’est pas étendue sur la peau, le sacrificateur déclarera cet homme pur: c’est une dartre; il lavera ses vêtements, et il sera pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Mais si la dartre s’est étendue sur la peau, après qu’il s’est montré au sacrificateur pour être déclaré pur, il se fera examiner une seconde fois par le sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Le sacrificateur l’examinera. Si la dartre s’est étendue sur la peau, le sacrificateur le déclarera impur; c’est la lèpre. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Lorsqu’il y aura sur un homme une plaie de lèpre, on l’amènera au sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Le sacrificateur l’examinera. S’il y a sur la peau une tumeur blanche, si cette tumeur a fait blanchir le poil, et qu’il y ait une trace de chair vive dans la tumeur, ");
INSERT INTO fraLSG_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","c’est une lèpre invétérée dans la peau du corps de cet homme: le sacrificateur le déclarera impur; il ne l’enfermera pas, car il est impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Si la lèpre fait une éruption sur la peau et couvre toute la peau de celui qui a la plaie, depuis la tête jusqu’aux pieds, partout où le sacrificateur portera ses regards, le sacrificateur l’examinera; ");
INSERT INTO fraLSG_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","et quand il aura vu que la lèpre couvre tout le corps, il déclarera pur celui qui a la plaie: comme il est entièrement devenu blanc, il est pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Mais le jour où l’on apercevra en lui de la chair vive, il sera impur; ");
INSERT INTO fraLSG_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","quand le sacrificateur aura vu la chair vive, il le déclarera impur: la chair vive est impure, c’est la lèpre. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Si la chair vive change et devient blanche, il ira vers le sacrificateur; ");
INSERT INTO fraLSG_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","le sacrificateur l’examinera, et si la plaie est devenue blanche, le sacrificateur déclarera pur celui qui a la plaie: il est pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Lorsqu’un homme aura eu sur la peau de son corps un ulcère qui a été guéri, ");
INSERT INTO fraLSG_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","et qu’il se manifestera, à la place où était l’ulcère, une tumeur blanche ou une tache d’un blanc rougeâtre, cet homme se montrera au sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Le sacrificateur l’examinera. Si la tache paraît plus enfoncée que la peau, et que le poil soit devenu blanc, le sacrificateur le déclarera impur: c’est une plaie de lèpre, qui a fait éruption dans l’ulcère. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Si le sacrificateur voit qu’il n’y a point de poil blanc dans la tache, qu’elle n’est pas plus enfoncée que la peau, et qu’elle est devenue pâle, il enfermera cet homme pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Si la tache s’est étendue sur la peau, le sacrificateur le déclarera impur: c’est une plaie de lèpre. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Mais si la tache est restée à la même place et ne s’est pas étendue, c’est une cicatrice de l’ulcère: le sacrificateur le déclarera pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Lorsqu’un homme aura eu sur la peau de son corps une brûlure par le feu, et qu’il se manifestera sur la trace de la brûlure une tache blanche ou d’un blanc rougeâtre, le sacrificateur l’examinera. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Si le poil est devenu blanc dans la tache, et qu’elle paraisse plus profonde que la peau, c’est la lèpre, qui a fait éruption dans la brûlure; le sacrificateur déclarera cet homme impur: c’est une plaie de lèpre. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Si le sacrificateur voit qu’il n’y a point de poil blanc dans la tache, qu’elle n’est pas plus enfoncée que la peau, et qu’elle est devenue pâle, il enfermera cet homme pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Le sacrificateur l’examinera le septième jour. Si la tache s’est étendue sur la peau, le sacrificateur le déclarera impur: c’est une plaie de lèpre. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Mais si la tache est restée à la même place, ne s’est pas étendue sur la peau, et est devenue pâle, c’est la tumeur de la brûlure; le sacrificateur le déclarera pur, car c’est la cicatrice de la brûlure. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Lorsqu’un homme ou une femme aura une plaie à la tête ou à la barbe, ");
INSERT INTO fraLSG_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","le sacrificateur examinera la plaie. Si elle paraît plus profonde que la peau, et qu’il y ait du poil jaunâtre et mince, le sacrificateur déclarera cet homme impur: c’est la teigne, c’est la lèpre de la tête ou de la barbe. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Si le sacrificateur voit que la plaie de la teigne ne paraît pas plus profonde que la peau, et qu’il n’y a point de poil noir, il enfermera pendant sept jours celui qui a la plaie de la teigne. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Le sacrificateur examinera la plaie le septième jour. Si la teigne ne s’est pas étendue, s’il n’y a point de poil jaunâtre, et si elle ne paraît pas plus profonde que la peau, ");
INSERT INTO fraLSG_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","celui qui a la teigne se rasera, mais il ne rasera point la place où est la teigne; et le sacrificateur l’enfermera une seconde fois pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Le sacrificateur examinera la teigne le septième jour. Si la teigne ne s’est pas étendue sur la peau, et si elle ne paraît pas plus profonde que la peau, le sacrificateur le déclarera pur; il lavera ses vêtements, et il sera pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Mais si la teigne s’est étendue sur la peau, après qu’il a été déclaré pur, le sacrificateur l’examinera. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Et si la teigne s’est étendue sur la peau, le sacrificateur n’aura pas à rechercher s’il y a du poil jaunâtre: il est impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Si la teigne lui paraît ne pas avoir fait de progrès, et qu’il y ait crû du poil noir, la teigne est guérie: il est pur, et le sacrificateur le déclarera pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Lorsqu’un homme ou une femme aura sur la peau de son corps des taches, des taches blanches, ");
INSERT INTO fraLSG_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","le sacrificateur l’examinera. S’il y a sur la peau de son corps des taches d’un blanc pâle, ce ne sont que des taches qui ont fait éruption sur la peau: il est pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Lorsqu’un homme aura la tête dépouillée de cheveux, c’est un chauve: il est pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","S’il a la tête dépouillée de cheveux du côté de la face, c’est un chauve par-devant: il est pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Mais s’il y a dans la partie chauve de devant ou de derrière une plaie d’un blanc rougeâtre, c’est la lèpre qui a fait éruption dans la partie chauve de derrière ou de devant. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Le sacrificateur l’examinera. S’il y a une tumeur de plaie d’un blanc rougeâtre dans la partie chauve de derrière ou de devant, semblable à la lèpre sur la peau du corps, ");
INSERT INTO fraLSG_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","c’est un homme lépreux, il est impur: le sacrificateur le déclarera impur; c’est à la tête qu’est sa plaie. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Le lépreux, atteint de la plaie, portera ses vêtements déchirés, et aura la tête nue; il se couvrira la barbe, et criera: Impur! Impur! ");
INSERT INTO fraLSG_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Aussi longtemps qu’il aura la plaie, il sera impur: il est impur. Il habitera seul; sa demeure sera hors du camp. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Lorsqu’il y aura sur un vêtement une plaie de lèpre, sur un vêtement de laine ou sur un vêtement de lin, ");
INSERT INTO fraLSG_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","à la chaîne ou à la trame de lin, ou de laine, sur une peau ou sur quelque ouvrage de peau, ");
INSERT INTO fraLSG_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","et que la plaie sera verdâtre ou rougeâtre sur le vêtement ou sur la peau, à la chaîne ou à la trame, ou sur un objet quelconque de peau, c’est une plaie de lèpre, et elle sera montrée au sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Le sacrificateur examinera la plaie, et il enfermera pendant sept jours ce qui en est attaqué. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Il examinera la plaie le septième jour. Si la plaie s’est étendue sur le vêtement, à la chaîne ou à la trame, sur la peau ou sur l’ouvrage quelconque fait de peau, c’est une plaie de lèpre invétérée: l’objet est impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Il brûlera le vêtement, la chaîne ou la trame de laine ou de lin, l’objet quelconque de peau sur lequel se trouve la plaie, car c’est une lèpre invétérée: il sera brûlé au feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Mais si le sacrificateur voit que la plaie ne s’est pas étendue sur le vêtement, sur la chaîne ou sur la trame, sur l’objet quelconque de peau, ");
INSERT INTO fraLSG_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","il ordonnera qu’on lave ce qui est attaqué de la plaie, et il l’enfermera une seconde fois pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Le sacrificateur examinera la plaie, après qu’elle aura été lavée. Si la plaie n’a pas changé d’aspect et ne s’est pas étendue, l’objet est impur: il sera brûlé au feu; c’est une partie de l’endroit ou de l’envers qui a été rongée. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Si le sacrificateur voit que la plaie est devenue pâle, après avoir été lavée, il l’arrachera du vêtement ou de la peau, de la chaîne ou de la trame. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Si elle paraît encore sur le vêtement, à la chaîne ou à la trame, ou sur l’objet quelconque de peau, c’est une éruption de lèpre: ce qui est attaqué de la plaie sera brûlé au feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Le vêtement, la chaîne ou la trame, l’objet quelconque de peau, qui a été lavé, et d’où la plaie a disparu, sera lavé une seconde fois, et il sera pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Telle est la loi sur la plaie de la lèpre, lorsqu’elle attaque les vêtements de laine ou de lin, la chaîne ou la trame, ou un objet quelconque de peau, et d’après laquelle ils seront déclarés purs ou impurs. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Voici quelle sera la loi sur le lépreux, pour le jour de sa purification. On l’amènera devant le sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Le sacrificateur sortira du camp, et il examinera le lépreux. Si le lépreux est guéri de la plaie de la lèpre, ");
INSERT INTO fraLSG_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","le sacrificateur ordonnera que l’on prenne, pour celui qui doit être purifié, deux oiseaux vivants et purs, du bois de cèdre, du cramoisi et de l’hysope. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Le sacrificateur ordonnera qu’on égorge l’un des oiseaux sur un vase de terre, sur de l’eau vive. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Il prendra l’oiseau vivant, le bois de cèdre, le cramoisi et l’hysope; et il les trempera, avec l’oiseau vivant, dans le sang de l’oiseau égorgé sur l’eau vive. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Il en fera sept fois l’aspersion sur celui qui doit être purifié de la lèpre. Puis il le déclarera pur, et il lâchera dans les champs l’oiseau vivant. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Celui qui se purifie lavera ses vêtements, rasera tout son poil, et se baignera dans l’eau; et il sera pur. Ensuite il pourra entrer dans le camp, mais il restera sept jours hors de sa tente. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Le septième jour, il rasera tout son poil, sa tête, sa barbe, ses sourcils, il rasera tout son poil; il lavera ses vêtements, et baignera son corps dans l’eau, et il sera pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Le huitième jour, il prendra deux agneaux sans défaut et une brebis d’un an sans défaut, trois dixièmes d’un épha de fleur de farine en offrande pétrie à l’huile, et un log d’huile. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Le sacrificateur qui fait la purification présentera l’homme qui se purifie et toutes ces choses devant l’Éternel, à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Le sacrificateur prendra l’un des agneaux, et il l’offrira en sacrifice de culpabilité, avec le log d’huile; il les agitera de côté et d’autre devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Il égorgera l’agneau dans le lieu où l’on égorge les victimes expiatoires et les holocaustes, dans le lieu saint; car, dans le sacrifice de culpabilité, comme dans le sacrifice d’expiation, la victime est pour le sacrificateur; c’est une chose très sainte. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Le sacrificateur prendra du sang de la victime de culpabilité; il en mettra sur le lobe de l’oreille droite de celui qui se purifie, sur le pouce de sa main droite et sur le gros orteil de son pied droit. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Le sacrificateur prendra du log d’huile, et il en versera dans le creux de sa main gauche. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Le sacrificateur trempera le doigt de sa main droite dans l’huile qui est dans le creux de sa main gauche, et il fera avec le doigt sept fois l’aspersion de l’huile devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Le sacrificateur mettra de l’huile qui lui reste dans la main sur le lobe de l’oreille droite de celui qui se purifie, sur le pouce de sa main droite et sur le gros orteil de son pied droit, par-dessus le sang de la victime de culpabilité. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Le sacrificateur mettra ce qui lui reste d’huile dans la main sur la tête de celui qui se purifie; et le sacrificateur fera pour lui l’expiation devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Puis le sacrificateur offrira le sacrifice d’expiation; et il fera l’expiation pour celui qui se purifie de sa souillure. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Ensuite il égorgera l’holocauste. Le sacrificateur offrira sur l’autel l’holocauste et l’offrande; et il fera pour cet homme l’expiation, et il sera pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","S’il est pauvre et que ses ressources soient insuffisantes, il prendra un seul agneau, qui sera offert en sacrifice de culpabilité, après avoir été agité de côté et d’autre, et avec lequel on fera pour lui l’expiation. Il prendra un seul dixième de fleur de farine pétrie à l’huile pour l’offrande, et un log d’huile. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Il prendra aussi deux tourterelles ou deux jeunes pigeons, selon ses ressources, l’un pour le sacrifice d’expiation, l’autre pour l’holocauste. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Le huitième jour, il apportera pour sa purification toutes ces choses au sacrificateur, à l’entrée de la tente d’assignation, devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Le sacrificateur prendra l’agneau pour le sacrifice de culpabilité, et le log d’huile; et il les agitera de côté et d’autre devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Il égorgera l’agneau du sacrifice de culpabilité. Le sacrificateur prendra du sang de la victime de culpabilité; il en mettra sur le lobe de l’oreille droite de celui qui se purifie, sur le pouce de sa main droite et sur le gros orteil de son pied droit. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Le sacrificateur versera de l’huile dans le creux de sa main gauche. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Le sacrificateur fera avec le doigt de sa main droite sept fois l’aspersion de l’huile qui est dans sa main gauche, devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Le sacrificateur mettra de l’huile qui est dans sa main sur le lobe de l’oreille droite de celui qui se purifie, sur le pouce de sa main droite et sur le gros orteil de son pied droit, à la place où il a mis du sang de la victime de culpabilité. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Le sacrificateur mettra ce qui lui reste d’huile dans la main sur la tête de celui qui se purifie, afin de faire pour lui l’expiation devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Puis il offrira l’une des tourterelles ou l’un des jeunes pigeons qu’il a pu se procurer, ");
INSERT INTO fraLSG_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","l’un en sacrifice d’expiation, l’autre en holocauste, avec l’offrande; et le sacrificateur fera pour celui qui se purifie l’expiation devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Telle est la loi pour la purification de celui qui a une plaie de lèpre, et dont les ressources sont insuffisantes. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","L’Éternel parla à Moïse et à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Lorsque vous serez entrés dans le pays de Canaan, dont je vous donne la possession; si je mets une plaie de lèpre sur une maison du pays que vous posséderez, ");
INSERT INTO fraLSG_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","celui à qui appartiendra la maison ira le déclarer au sacrificateur, et dira: J’aperçois comme une plaie dans ma maison. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Le sacrificateur, avant d’y entrer pour examiner la plaie, ordonnera qu’on vide la maison, afin que tout ce qui y est ne devienne pas impur. Après cela, le sacrificateur entrera pour examiner la maison. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Le sacrificateur examinera la plaie. S’il voit qu’elle offre sur les murs de la maison des cavités verdâtres ou rougeâtres, paraissant plus enfoncées que le mur, ");
INSERT INTO fraLSG_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","il sortira de la maison, et, quand il sera à la porte, il fera fermer la maison pour sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Le sacrificateur y retournera le septième jour. S’il voit que la plaie s’est étendue sur les murs de la maison, ");
INSERT INTO fraLSG_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","il ordonnera qu’on ôte les pierres attaquées de la plaie, et qu’on les jette hors de la ville, dans un lieu impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Il fera râcler tout l’intérieur de la maison; et l’on jettera hors de la ville, dans un lieu impur, la poussière qu’on aura râclée. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","On prendra d’autres pierres, que l’on mettra à la place des premières; et l’on prendra d’autre mortier, pour recrépir la maison. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Si la plaie revient et fait éruption dans la maison, après qu’on a ôté les pierres, râclé et recrépi la maison, ");
INSERT INTO fraLSG_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","le sacrificateur y retournera. S’il voit que la plaie s’est étendue dans la maison, c’est une lèpre invétérée dans la maison: elle est impure. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","On abattra la maison, les pierres, le bois, et tout le mortier de la maison; et l’on portera ces choses hors de la ville dans un lieu impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Celui qui sera entré dans la maison pendant tout le temps qu’elle était fermée sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Celui qui aura couché dans la maison lavera ses vêtements. Celui qui aura mangé dans la maison lavera aussi ses vêtements. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Si le sacrificateur, qui est retourné dans la maison, voit que la plaie ne s’est pas étendue, après que la maison a été recrépie, il déclarera la maison pure, car la plaie est guérie. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Il prendra, pour purifier la maison, deux oiseaux, du bois de cèdre, du cramoisi et de l’hysope. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Il égorgera l’un des oiseaux sur un vase de terre, sur de l’eau vive. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Il prendra le bois de cèdre, l’hysope, le cramoisi et l’oiseau vivant; il les trempera dans le sang de l’oiseau égorgé et dans l’eau vive, et il en fera sept fois l’aspersion sur la maison. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Il purifiera la maison avec le sang de l’oiseau, avec de l’eau vive, avec l’oiseau vivant, avec le bois de cèdre, l’hysope et le cramoisi. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Il lâchera l’oiseau vivant hors de la ville, dans les champs. C’est ainsi qu’il fera pour la maison l’expiation, et elle sera pure. ");
INSERT INTO fraLSG_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Telle est la loi pour toute plaie de lèpre et pour la teigne, ");
INSERT INTO fraLSG_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","pour la lèpre des vêtements et des maisons, ");
INSERT INTO fraLSG_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","pour les tumeurs, les dartres et les taches: ");
INSERT INTO fraLSG_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","elle enseigne quand une chose est impure, et quand elle est pure. Telle est la loi sur la lèpre. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","L’Éternel parla à Moïse et à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Parlez aux enfants d’Israël, et dites-leur: Tout homme qui a une gonorrhée est par là même impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","C’est à cause de sa gonorrhée qu’il est impur: que sa chair laisse couler son flux, ou qu’elle le retienne, il est impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Tout lit sur lequel il couchera sera impur, et tout objet sur lequel il s’assiéra sera impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Celui qui touchera son lit lavera ses vêtements, se lavera dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Celui qui s’assiéra sur l’objet sur lequel il s’est assis lavera ses vêtements, se lavera dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Celui qui touchera sa chair lavera ses vêtements, se lavera dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","S’il crache sur un homme pur, cet homme lavera ses vêtements, se lavera dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Toute monture sur laquelle il s’assiéra sera impure. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Celui qui touchera une chose quelconque qui a été sous lui sera impur jusqu’au soir; et celui qui la portera lavera ses vêtements, se lavera dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Celui qui sera touché par lui, et qui ne se sera pas lavé les mains dans l’eau, lavera ses vêtements, se lavera dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Tout vase de terre qui sera touché par lui sera brisé, et tout vase de bois sera lavé dans l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Lorsqu’il sera purifié de son flux, il comptera sept jours pour sa purification; il lavera ses vêtements, il lavera sa chair avec de l’eau vive, et il sera pur. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Le huitième jour, il prendra deux tourterelles ou deux jeunes pigeons, il ira devant l’Éternel, à l’entrée de la tente d’assignation, et il les donnera au sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Le sacrificateur les offrira, l’un en sacrifice d’expiation, et l’autre en holocauste; et le sacrificateur fera pour lui l’expiation devant l’Éternel, à cause de son flux. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","L’homme qui aura une pollution lavera tout son corps dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Tout vêtement et toute peau qui en seront atteints seront lavés dans l’eau, et seront impurs jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Si une femme a couché avec un tel homme, ils se laveront l’un et l’autre, et seront impurs jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","La femme qui aura un flux, un flux de sang en sa chair, restera sept jours dans son impureté. Quiconque la touchera sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Tout lit sur lequel elle couchera pendant son impureté sera impur, et tout objet sur lequel elle s’assiéra sera impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Quiconque touchera son lit lavera ses vêtements, se lavera dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Quiconque touchera un objet sur lequel elle s’est assise lavera ses vêtements, se lavera dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","S’il y a quelque chose sur le lit ou sur l’objet sur lequel elle s’est assise, celui qui la touchera sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Si un homme couche avec elle et que l’impureté de cette femme vienne sur lui, il sera impur pendant sept jours, et tout lit sur lequel il couchera sera impur. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","La femme qui aura un flux de sang pendant plusieurs jours hors de ses époques régulières, ou dont le flux durera plus qu’à l’ordinaire, sera impure tout le temps de son flux, comme au temps de son indisposition menstruelle. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Tout lit sur lequel elle couchera pendant la durée de ce flux sera comme le lit de son flux menstruel, et tout objet sur lequel elle s’assiéra sera impur comme lors de son flux menstruel. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Quiconque les touchera sera souillé; il lavera ses vêtements, se lavera dans l’eau, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Lorsqu’elle sera purifiée de son flux, elle comptera sept jours, après lesquels elle sera pure. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Le huitième jour, elle prendra deux tourterelles ou deux jeunes pigeons, et elle les apportera au sacrificateur, à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Le sacrificateur offrira l’un en sacrifice d’expiation, et l’autre en holocauste; et le sacrificateur fera pour elle l’expiation devant l’Éternel, à cause du flux qui la rendait impure. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Vous éloignerez les enfants d’Israël de leurs impuretés, de peur qu’ils ne meurent à cause de leurs impuretés, s’ils souillent mon tabernacle qui est au milieu d’eux. ");
INSERT INTO fraLSG_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Telle est la loi pour celui qui a une gonorrhée ou qui est souillé par une pollution, ");
INSERT INTO fraLSG_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","pour celle qui a son flux menstruel, pour l’homme ou la femme qui a un flux, et pour l’homme qui couche avec une femme impure. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","L’Éternel parla à Moïse, après la mort des deux fils d’Aaron, qui moururent en se présentant devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","L’Éternel dit à Moïse: Parle à ton frère Aaron, afin qu’il n’entre pas en tout temps dans le sanctuaire, au dedans du voile, devant le propitiatoire qui est sur l’arche, de peur qu’il ne meure; car j’apparaîtrai dans la nuée sur le propitiatoire. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Voici de quelle manière Aaron entrera dans le sanctuaire. Il prendra un jeune taureau pour le sacrifice d’expiation et un bélier pour l’holocauste. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Il se revêtira de la tunique sacrée de lin, et portera sur son corps des caleçons de lin; il se ceindra d’une ceinture de lin, et il se couvrira la tête d’une tiare de lin: ce sont les vêtements sacrés, dont il se revêtira après avoir lavé son corps dans l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Il recevra de l’assemblée des enfants d’Israël deux boucs pour le sacrifice d’expiation et un bélier pour l’holocauste. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaron offrira son taureau expiatoire, et il fera l’expiation pour lui et pour sa maison. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Il prendra les deux boucs, et il les placera devant l’Éternel, à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaron jettera le sort sur les deux boucs, un sort pour l’Éternel et un sort pour Azazel. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aaron fera approcher le bouc sur lequel est tombé le sort pour l’Éternel, et il l’offrira en sacrifice d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Et le bouc sur lequel est tombé le sort pour Azazel sera placé vivant devant l’Éternel, afin qu’il serve à faire l’expiation et qu’il soit lâché dans le désert pour Azazel. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaron offrira son taureau expiatoire, et il fera l’expiation pour lui et pour sa maison. Il égorgera son taureau expiatoire. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Il prendra un brasier plein de charbons ardents ôtés de dessus l’autel devant l’Éternel, et de deux poignées de parfum odoriférant en poudre; il portera ces choses au-delà du voile; ");
INSERT INTO fraLSG_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","il mettra le parfum sur le feu devant l’Éternel, afin que la nuée du parfum couvre le propitiatoire qui est sur le témoignage, et il ne mourra point. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Il prendra du sang du taureau, et il fera l’aspersion avec son doigt sur le devant du propitiatoire vers l’orient; il fera avec son doigt sept fois l’aspersion du sang devant le propitiatoire. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Il égorgera le bouc expiatoire pour le peuple, et il en portera le sang au-delà du voile. Il fera avec ce sang comme il a fait avec le sang du taureau, il en fera l’aspersion sur le propitiatoire et devant le propitiatoire. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","C’est ainsi qu’il fera l’expiation pour le sanctuaire à cause des impuretés des enfants d’Israël et de toutes les transgressions par lesquelles ils ont péché. Il fera de même pour la tente d’assignation, qui est avec eux au milieu de leurs impuretés. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Il n’y aura personne dans la tente d’assignation lorsqu’il entrera pour faire l’expiation dans le sanctuaire, jusqu’à ce qu’il en sorte. Il fera l’expiation pour lui et pour sa maison, et pour toute l’assemblée d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","En sortant, il ira vers l’autel qui est devant l’Éternel, et il fera l’expiation pour l’autel; il prendra du sang du taureau et du bouc, et il en mettra sur les cornes de l’autel tout autour. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Il fera avec son doigt sept fois l’aspersion du sang sur l’autel; il le purifiera et le sanctifiera, à cause des impuretés des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Lorsqu’il aura achevé de faire l’expiation pour le sanctuaire, pour la tente d’assignation et pour l’autel, il fera approcher le bouc vivant. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aaron posera ses deux mains sur la tête du bouc vivant, et il confessera sur lui toutes les iniquités des enfants d’Israël et toutes les transgressions par lesquelles ils ont péché; il les mettra sur la tête du bouc, puis il le chassera dans le désert, à l’aide d’un homme qui aura cette charge. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Le bouc emportera sur lui toutes leurs iniquités dans une terre désolée; il sera chassé dans le désert. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Aaron entrera dans la tente d’assignation; il quittera les vêtements de lin qu’il avait mis en entrant dans le sanctuaire, et il les déposera là. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Il lavera son corps avec de l’eau dans un lieu saint, et reprendra ses vêtements. Puis il sortira, offrira son holocauste et l’holocauste du peuple, et fera l’expiation pour lui et pour le peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Il brûlera sur l’autel la graisse de la victime expiatoire. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Celui qui aura chassé le bouc pour Azazel lavera ses vêtements, et lavera son corps dans l’eau; après cela, il rentrera dans le camp. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","On emportera hors du camp le taureau expiatoire et le bouc expiatoire dont on a porté le sang dans le sanctuaire pour faire l’expiation, et l’on brûlera au feu leurs peaux, leur chair et leurs excréments. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Celui qui les brûlera lavera ses vêtements, et lavera son corps dans l’eau; après cela, il rentrera dans le camp. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","C’est ici pour vous une loi perpétuelle: au septième mois, le dixième jour du mois, vous humilierez vos âmes, vous ne ferez aucun ouvrage, ni l’indigène, ni l’étranger qui séjourne au milieu de vous. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Car en ce jour on fera l’expiation pour vous, afin de vous purifier: vous serez purifiés de tous vos péchés devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ce sera pour vous un sabbat, un jour de repos, et vous humilierez vos âmes. C’est une loi perpétuelle. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","L’expiation sera faite par le sacrificateur qui a reçu l’onction et qui a été consacré pour succéder à son père dans le sacerdoce; il se revêtira des vêtements de lin, des vêtements sacrés. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Il fera l’expiation pour le sanctuaire de sainteté, il fera l’expiation pour la tente d’assignation et pour l’autel, et il fera l’expiation pour les sacrificateurs et pour tout le peuple de l’assemblée. ");
INSERT INTO fraLSG_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ce sera pour vous une loi perpétuelle: il se fera une fois chaque année l’expiation pour les enfants d’Israël, à cause de leurs péchés. On fit ce que l’Éternel avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Parle à Aaron et à ses fils, et à tous les enfants d’Israël, et tu leur diras: Voici ce que l’Éternel a ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Si un homme de la maison d’Israël égorge dans le camp ou hors du camp un bœuf, un agneau ou une chèvre, ");
INSERT INTO fraLSG_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","et ne l’amène pas à l’entrée de la tente d’assignation, pour en faire une offrande à l’Éternel devant le tabernacle de l’Éternel, le sang sera imputé à cet homme; il a répandu le sang, cet homme-là sera retranché du milieu de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","C’est afin que les enfants d’Israël, au lieu de sacrifier leurs victimes dans les champs, les amènent au sacrificateur, devant l’Éternel, à l’entrée de la tente d’assignation, et qu’ils les offrent à l’Éternel en sacrifices d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Le sacrificateur en répandra le sang sur l’autel de l’Éternel, à l’entrée de la tente d’assignation; et il brûlera la graisse, qui sera d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Ils n’offriront plus leurs sacrifices aux boucs, avec lesquels ils se prostituent. Ce sera une loi perpétuelle pour eux et pour leurs descendants. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Tu leur diras donc: Si un homme de la maison d’Israël ou des étrangers qui séjournent au milieu d’eux offre un holocauste ou une victime, ");
INSERT INTO fraLSG_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","et ne l’amène pas à l’entrée de la tente d’assignation, pour l’offrir en sacrifice à l’Éternel, cet homme-là sera retranché de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Si un homme de la maison d’Israël ou des étrangers qui séjournent au milieu d’eux mange du sang d’une espèce quelconque, je tournerai ma face contre celui qui mange le sang, et je le retrancherai du milieu de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Car l’âme de la chair est dans le sang. Je vous l’ai donné sur l’autel, afin qu’il servît d’expiation pour vos âmes, car c’est par l’âme que le sang fait l’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","C’est pourquoi j’ai dit aux enfants d’Israël: Personne d’entre vous ne mangera du sang, et l’étranger qui séjourne au milieu de vous ne mangera pas du sang. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Si quelqu’un des enfants d’Israël ou des étrangers qui séjournent au milieu d’eux prend à la chasse un animal ou un oiseau qui se mange, il en versera le sang et le couvrira de poussière. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Car l’âme de toute chair, c’est son sang, qui est en elle. C’est pourquoi j’ai dit aux enfants d’Israël: Vous ne mangerez le sang d’aucune chair; car l’âme de toute chair, c’est son sang: quiconque en mangera sera retranché. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Toute personne, indigène ou étrangère, qui mangera d’une bête morte ou déchirée, lavera ses vêtements, se lavera dans l’eau, et sera impure jusqu’au soir; puis elle sera pure. ");
INSERT INTO fraLSG_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Si elle ne lave pas ses vêtements, et ne lave pas son corps, elle portera la peine de sa faute. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Parle aux enfants d’Israël, et tu leur diras: Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Vous ne ferez point ce qui se fait dans le pays d’Égypte où vous avez habité, et vous ne ferez point ce qui se fait dans le pays de Canaan où je vous mène: vous ne suivrez point leurs usages. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Vous pratiquerez mes ordonnances, et vous observerez mes lois: vous les suivrez. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Vous observerez mes lois et mes ordonnances: l’homme qui les mettra en pratique vivra par elles. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nul de vous ne s’approchera de sa parente, pour découvrir sa nudité. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Tu ne découvriras point la nudité de ton père, ni la nudité de ta mère. C’est ta mère: tu ne découvriras point sa nudité. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Tu ne découvriras point la nudité de la femme de ton père. C’est la nudité de ton père. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Tu ne découvriras point la nudité de ta sœur, fille de ton père ou fille de ta mère, née dans la maison ou née hors de la maison. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Tu ne découvriras point la nudité de la fille de ton fils ou de la fille de ta fille. Car c’est ta nudité. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Tu ne découvriras point la nudité de la fille de la femme de ton père, née de ton père. C’est ta sœur. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Tu ne découvriras point la nudité de la sœur de ton père. C’est la proche parente de ton père. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Tu ne découvriras point la nudité de la sœur de ta mère. Car c’est la proche parente de ta mère. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Tu ne découvriras point la nudité du frère de ton père. Tu ne t’approcheras point de sa femme. C’est ta tante. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Tu ne découvriras point la nudité de ta belle-fille. C’est la femme de ton fils: tu ne découvriras point sa nudité. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Tu ne découvriras point la nudité de la femme de ton frère. C’est la nudité de ton frère. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Tu ne découvriras point la nudité d’une femme et de sa fille. Tu ne prendras point la fille de son fils, ni la fille de sa fille, pour découvrir leur nudité. Ce sont tes proches parentes: c’est un crime. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Tu ne prendras point la sœur de ta femme, pour exciter une rivalité, en découvrant sa nudité à côté de ta femme pendant sa vie. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Tu ne t’approcheras point d’une femme pendant son impureté menstruelle, pour découvrir sa nudité. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Tu n’auras point commerce avec la femme de ton prochain, pour te souiller avec elle. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Tu ne livreras aucun de tes enfants pour le faire passer à Moloc, et tu ne profaneras point le nom de ton Dieu. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Tu ne coucheras point avec un homme comme on couche avec une femme. C’est une abomination. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Tu ne coucheras point avec une bête, pour te souiller avec elle. La femme ne s’approchera point d’une bête, pour se prostituer à elle. C’est une confusion. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ne vous souillez par aucune de ces choses, car c’est par toutes ces choses que se sont souillées les nations que je vais chasser devant vous. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Le pays en a été souillé; je punirai son iniquité, et le pays vomira ses habitants. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Vous observerez donc mes lois et mes ordonnances, et vous ne commettrez aucune de ces abominations, ni l’indigène, ni l’étranger qui séjourne au milieu de vous. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Car ce sont là toutes les abominations qu’ont commises les hommes du pays, qui y ont été avant vous; et le pays en a été souillé. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Prenez garde que le pays ne vous vomisse, si vous le souillez, comme il aura vomi les nations qui y étaient avant vous. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Car tous ceux qui commettront quelqu’une de ces abominations seront retranchés du milieu de leur peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Vous observerez mes commandements, et vous ne pratiquerez aucun des usages abominables qui se pratiquaient avant vous, vous ne vous en souillerez pas. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Parle à toute l’assemblée des enfants d’Israël, et tu leur diras: Soyez saints, car je suis saint, moi, l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Chacun de vous respectera sa mère et son père, et observera mes sabbats. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Vous ne vous tournerez point vers les idoles, et vous ne vous ferez point des dieux de fonte. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Quand vous offrirez à l’Éternel un sacrifice d’actions de grâces, vous l’offrirez en sorte qu’il soit agréé. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","La victime sera mangée le jour où vous la sacrifierez, ou le lendemain; ce qui restera jusqu’au troisième jour sera brûlé au feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Si l’on en mange le troisième jour, ce sera une chose infecte: le sacrifice ne sera point agréé. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Celui qui en mangera portera la peine de son péché, car il profane ce qui est consacré à l’Éternel: cette personne-là sera retranchée de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Quand vous ferez la moisson dans votre pays, tu laisseras un coin de ton champ sans le moissonner, et tu ne ramasseras pas ce qui reste à glaner. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Tu ne cueilleras pas non plus les grappes restées dans ta vigne, et tu ne ramasseras pas les grains qui en seront tombés. Tu abandonneras cela au pauvre et à l’étranger. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Vous ne déroberez point, et vous n’userez ni de mensonge ni de tromperie les uns envers les autres. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Vous ne jurerez point faussement par mon nom, car tu profanerais le nom de ton Dieu. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Tu n’opprimeras point ton prochain, et tu ne raviras rien par violence. Tu ne retiendras point jusqu’au lendemain le salaire du mercenaire. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Tu ne maudiras point un sourd, et tu ne mettras devant un aveugle rien qui puisse le faire tomber; car tu auras la crainte de ton Dieu. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Tu ne commettras point d’iniquité dans tes jugements: tu n’auras point égard à la personne du pauvre, et tu ne favoriseras point la personne du grand, mais tu jugeras ton prochain selon la justice. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Tu ne répandras point de calomnies parmi ton peuple. Tu ne t’élèveras point contre le sang de ton prochain. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Tu ne haïras point ton frère dans ton cœur; tu auras soin de reprendre ton prochain, mais tu ne te chargeras point d’un péché à cause de lui. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Tu ne te vengeras point, et tu ne garderas point de rancune contre les enfants de ton peuple. Tu aimeras ton prochain comme toi-même. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Vous observerez mes lois. Tu n’accoupleras point des bestiaux de deux espèces différentes; tu n’ensemenceras point ton champ de deux espèces de semences; et tu ne porteras pas un vêtement tissé de deux espèces de fils. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Lorsqu’un homme couchera et aura commerce avec une femme, si c’est une esclave fiancée à un autre homme, et qui n’a pas été rachetée ou affranchie, ils seront châtiés, mais non punis de mort, parce qu’elle n’a pas été affranchie. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","L’homme amènera pour sa faute à l’Éternel, à l’entrée de la tente d’assignation, un bélier en sacrifice de culpabilité. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Le sacrificateur fera pour lui l’expiation devant l’Éternel, pour le péché qu’il a commis, avec le bélier offert en sacrifice de culpabilité, et le péché qu’il a commis lui sera pardonné. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Quand vous serez entrés dans le pays, et que vous y aurez planté toutes sortes d’arbres fruitiers, vous en regarderez les fruits comme incirconcis; pendant trois ans, ils seront pour vous incirconcis; on n’en mangera point. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","La quatrième année, tous leurs fruits seront consacrés à l’Éternel au milieu des réjouissances. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","La cinquième année, vous en mangerez les fruits, et vous continuerez à les récolter. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Vous ne mangerez rien avec du sang. Vous n’observerez ni les serpents ni les nuages pour en tirer des pronostics. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Vous ne couperez point en rond les coins de votre chevelure, et tu ne raseras point les coins de ta barbe. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Vous ne ferez point d’incisions dans votre chair pour un mort, et vous n’imprimerez point de figures sur vous. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Tu ne profaneras point ta fille en la livrant à la prostitution, de peur que le pays ne se prostitue et ne se remplisse de crimes. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Vous observerez mes sabbats, et vous révérerez mon sanctuaire. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ne vous tournez point vers ceux qui évoquent les esprits, ni vers les devins; ne les recherchez point, de peur de vous souiller avec eux. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Tu te lèveras devant les cheveux blancs, et tu honoreras la personne du vieillard. Tu craindras ton Dieu. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Si un étranger vient séjourner avec vous dans votre pays, vous ne l’opprimerez point. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Vous traiterez l’étranger en séjour parmi vous comme un indigène du milieu de vous; vous l’aimerez comme vous-mêmes, car vous avez été étrangers dans le pays d’Égypte. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Vous ne commettrez point d’iniquité ni dans les jugements, ni dans les mesures de dimension, ni dans les poids, ni dans les mesures de capacité. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Vous aurez des balances justes, des poids justes, des épha justes et des hin justes. Je suis l’Éternel, votre Dieu, qui vous ai fait sortir du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Vous observerez toutes mes lois et toutes mes ordonnances, et vous les mettrez en pratique. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Tu diras aux enfants d’Israël: Si un homme des enfants d’Israël ou des étrangers qui séjournent en Israël livre à Moloc l’un de ses enfants, il sera puni de mort: le peuple du pays le lapidera. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Et moi, je tournerai ma face contre cet homme, et je le retrancherai du milieu de son peuple, parce qu’il a livré de ses enfants à Moloc, souillé mon sanctuaire et profané mon saint nom. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Si le peuple du pays détourne ses regards de cet homme, qui livre de ses enfants à Moloc, et s’il ne le fait pas mourir, ");
INSERT INTO fraLSG_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","je tournerai, moi, ma face contre cet homme et contre sa famille, et je le retrancherai du milieu de son peuple, avec tous ceux qui se prostituent comme lui en se prostituant à Moloc. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Si quelqu’un s’adresse aux morts et aux esprits, pour se prostituer après eux, je tournerai ma face contre cet homme, je le retrancherai du milieu de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Vous vous sanctifierez et vous serez saints, car je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Vous observerez mes lois, et vous les mettrez en pratique. Je suis l’Éternel, qui vous sanctifie. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Si un homme quelconque maudit son père ou sa mère, il sera puni de mort; il a maudit son père ou sa mère: son sang retombera sur lui. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Si un homme commet un adultère avec une femme mariée, s’il commet un adultère avec la femme de son prochain, l’homme et la femme adultères seront punis de mort. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Si un homme couche avec la femme de son père, et découvre ainsi la nudité de son père, cet homme et cette femme seront punis de mort: leur sang retombera sur eux. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Si un homme couche avec sa belle-fille, ils seront tous deux punis de mort; ils ont fait une confusion: leur sang retombera sur eux. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Si un homme couche avec un homme comme on couche avec une femme, ils ont fait tous deux une chose abominable; ils seront punis de mort: leur sang retombera sur eux. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Si un homme prend pour femmes la fille et la mère, c’est un crime: on les brûlera au feu, lui et elles, afin que ce crime n’existe pas au milieu de vous. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Si un homme couche avec une bête, il sera puni de mort; et vous tuerez la bête. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Si une femme s’approche d’une bête, pour se prostituer à elle, tu tueras la femme et la bête; elles seront mises à mort: leur sang retombera sur elles. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Si un homme prend sa sœur, fille de son père ou fille de sa mère, s’il voit sa nudité et qu’elle voie la sienne, c’est une infamie; ils seront retranchés sous les yeux des enfants de leur peuple: il a découvert la nudité de sa sœur, il portera la peine de son péché. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Si un homme couche avec une femme qui a son indisposition, et découvre sa nudité, s’il découvre son flux, et qu’elle découvre le flux de son sang, ils seront tous deux retranchés du milieu de leur peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Tu ne découvriras point la nudité de la sœur de ta mère, ni de la sœur de ton père, car c’est découvrir sa proche parente: ils porteront la peine de leur péché. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Si un homme couche avec sa tante, il a découvert la nudité de son oncle; ils porteront la peine de leur péché, ils mourront sans enfant. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Si un homme prend la femme de son frère, c’est une impureté; il a découvert la nudité de son frère: ils seront sans enfant. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Vous observerez toutes mes lois et toutes mes ordonnances, et vous les mettrez en pratique, afin que le pays où je vous mène pour vous y établir ne vous vomisse point. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Vous ne suivrez point les usages des nations que je vais chasser devant vous; car elles ont fait toutes ces choses, et je les ai en abomination. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Je vous ai dit: C’est vous qui posséderez leur pays; je vous en donnerai la possession: c’est un pays où coulent le lait et le miel. Je suis l’Éternel, votre Dieu, qui vous ai séparés des peuples. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Vous observerez la distinction entre les animaux purs et impurs, entre les oiseaux purs et impurs, afin de ne pas rendre vos personnes abominables par des animaux, par des oiseaux, par tous les reptiles de la terre, que je vous ai appris à distinguer comme impurs. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Vous serez saints pour moi, car je suis saint, moi, l’Éternel; je vous ai séparés des peuples, afin que vous soyez à moi. ");
INSERT INTO fraLSG_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Si un homme ou une femme ont en eux l’esprit d’un mort ou un esprit de divination, ils seront punis de mort; on les lapidera: leur sang retombera sur eux. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","L’Éternel dit à Moïse: Parle aux sacrificateurs, fils d’Aaron, et tu leur diras: Un sacrificateur ne se rendra point impur parmi son peuple pour un mort, ");
INSERT INTO fraLSG_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","excepté pour ses plus proches parents, pour sa mère, pour son père, pour son fils, pour son frère, ");
INSERT INTO fraLSG_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","et aussi pour sa sœur encore vierge, qui le touche de près lorsqu’elle n’est pas mariée. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Chef parmi son peuple, il ne se rendra point impur en se profanant. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Les sacrificateurs ne se feront point de place chauve sur la tête, ils ne raseront point les coins de leur barbe, et ils ne feront point d’incisions dans leur chair. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ils seront saints pour leur Dieu, et ils ne profaneront pas le nom de leur Dieu; car ils offrent à l’Éternel les sacrifices consumés par le feu, l’aliment de leur Dieu: ils seront saints. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Ils ne prendront point une femme prostituée ou déshonorée, ils ne prendront point une femme répudiée par son mari, car ils sont saints pour leur Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Tu regarderas un sacrificateur comme saint, car il offre l’aliment de ton Dieu; il sera saint pour toi, car je suis saint, moi, l’Éternel, qui vous sanctifie. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Si la fille d’un sacrificateur se déshonore en se prostituant, elle déshonore son père: elle sera brûlée au feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Le sacrificateur qui a la supériorité sur ses frères, sur la tête duquel a été répandue l’huile d’onction, et qui a été consacré et revêtu des vêtements sacrés, ne découvrira point sa tête et ne déchirera point ses vêtements. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Il n’ira vers aucun mort, il ne se rendra point impur, ni pour son père, ni pour sa mère. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Il ne sortira point du sanctuaire, et ne profanera point le sanctuaire de son Dieu; car l’huile d’onction de son Dieu est une couronne sur lui. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Il prendra pour femme une vierge. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Il ne prendra ni une veuve, ni une femme répudiée, ni une femme déshonorée ou prostituée; mais il prendra pour femme une vierge parmi son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Il ne déshonorera point sa postérité parmi son peuple; car je suis l’Éternel, qui le sanctifie. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Parle à Aaron, et dis: Tout homme de ta race et parmi tes descendants, qui aura un défaut corporel, ne s’approchera point pour offrir l’aliment de son Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Tout homme qui aura un défaut corporel ne pourra s’approcher: un homme aveugle, boiteux, ayant le nez camus ou un membre allongé; ");
INSERT INTO fraLSG_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","un homme ayant une fracture au pied ou à la main; ");
INSERT INTO fraLSG_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","un homme bossu ou grêle, ayant une tache à l’œil, la gale, une dartre, ou les testicules écrasés. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Tout homme de la race du sacrificateur Aaron, qui aura un défaut corporel, ne s’approchera point pour offrir à l’Éternel les sacrifices consumés par le feu; il a un défaut corporel: il ne s’approchera point pour offrir l’aliment de son Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Il pourra manger l’aliment de son Dieu, des choses très saintes et des choses saintes. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Mais il n’ira point vers le voile, et il ne s’approchera point de l’autel, car il a un défaut corporel; il ne profanera point mes sanctuaires, car je suis l’Éternel, qui les sanctifie. ");
INSERT INTO fraLSG_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","C’est ainsi que parla Moïse à Aaron et à ses fils, et à tous les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Parle à Aaron et à ses fils, afin qu’ils s’abstiennent des choses saintes qui me sont consacrées par les enfants d’Israël, et qu’ils ne profanent point mon saint nom. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Dis-leur: Tout homme parmi vos descendants et de votre race, qui s’approchera des choses saintes que consacrent à l’Éternel les enfants d’Israël, et qui aura sur lui quelque impureté, cet homme-là sera retranché de devant moi. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Tout homme de la race d’Aaron, qui aura la lèpre ou une gonorrhée, ne mangera point des choses saintes jusqu’à ce qu’il soit pur. Il en sera de même pour celui qui touchera une personne souillée par le contact d’un cadavre, pour celui qui aura une pollution, ");
INSERT INTO fraLSG_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","pour celui qui touchera un reptile et en aura été souillé, ou un homme atteint d’une impureté quelconque et en aura été souillé. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Celui qui touchera ces choses sera impur jusqu’au soir; il ne mangera pas des choses saintes, mais il lavera son corps dans l’eau; ");
INSERT INTO fraLSG_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","après le coucher du soleil, il sera pur, et il mangera ensuite des choses saintes, car c’est sa nourriture. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Il ne mangera point d’une bête morte ou déchirée, afin de ne pas se souiller par elle. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Ils observeront mes commandements, de peur qu’ils ne portent la peine de leur péché et qu’ils ne meurent, pour avoir profané les choses saintes. Je suis l’Éternel, qui les sanctifie. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Aucun étranger ne mangera des choses saintes; celui qui demeure chez un sacrificateur et le mercenaire ne mangeront point des choses saintes. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Mais un esclave acheté par le sacrificateur à prix d’argent pourra en manger, de même que celui qui est né dans sa maison; ils mangeront de sa nourriture. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","La fille d’un sacrificateur, mariée à un étranger, ne mangera point des choses saintes offertes par élévation. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Mais la fille d’un sacrificateur qui sera veuve ou répudiée, sans avoir d’enfants, et qui retournera dans la maison de son père comme dans sa jeunesse, pourra manger de la nourriture de son père. Aucun étranger n’en mangera. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Si un homme mange involontairement d’une chose sainte, il donnera au sacrificateur la valeur de la chose sainte, en y ajoutant un cinquième. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Les sacrificateurs ne profaneront point les choses saintes qui sont présentées par les enfants d’Israël, et qu’ils ont offertes par élévation à l’Éternel; ");
INSERT INTO fraLSG_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ils les chargeraient ainsi du péché dont ils se rendraient coupables en mangeant les choses saintes: car je suis l’Éternel, qui les sanctifie. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Parle à Aaron et à ses fils, et à tous les enfants d’Israël, et tu leur diras: Tout homme de la maison d’Israël ou des étrangers en Israël, qui offrira un holocauste à l’Éternel, soit pour l’accomplissement d’un vœu, soit comme offrande volontaire, ");
INSERT INTO fraLSG_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","prendra un mâle sans défaut parmi les bœufs, les agneaux ou les chèvres, afin que sa victime soit agréée. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Vous n’en offrirez aucune qui ait un défaut, car elle ne serait pas agréée. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Si un homme offre à l’Éternel du gros ou du menu bétail en sacrifice d’actions de grâces, soit pour l’accomplissement d’un vœu, soit comme offrande volontaire, la victime sera sans défaut, afin qu’elle soit agréée; il n’y aura en elle aucun défaut. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Vous n’en offrirez point qui soit aveugle, estropiée, ou mutilée, qui ait des ulcères, la gale ou une dartre; vous n’en ferez point sur l’autel un sacrifice consumé par le feu devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Tu pourras sacrifier comme offrande volontaire un bœuf ou un agneau ayant un membre trop long ou trop court, mais il ne sera point agréé pour l’accomplissement d’un vœu. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Vous n’offrirez point à l’Éternel un animal dont les testicules ont été froissés, écrasés, arrachés ou coupés; vous ne l’offrirez point en sacrifice dans votre pays. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Vous n’accepterez de l’étranger aucune de ces victimes, pour l’offrir comme aliment de votre Dieu; car elles sont mutilées, elles ont des défauts: elles ne seraient point agréées. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","L’Éternel dit à Moïse: ");
INSERT INTO fraLSG_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Un bœuf, un agneau ou une chèvre, quand il naîtra, restera sept jours avec sa mère; dès le huitième jour et les suivants, il sera agréé pour être offert à l’Éternel en sacrifice consumé par le feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Bœuf ou agneau, vous n’égorgerez pas un animal et son petit le même jour. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Quand vous offrirez à l’Éternel un sacrifice d’actions de grâces, vous ferez en sorte qu’il soit agréé. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","La victime sera mangée le jour même; vous n’en laisserez rien jusqu’au matin. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Vous observerez mes commandements, et vous les mettrez en pratique. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Vous ne profanerez point mon saint nom, afin que je sois sanctifié au milieu des enfants d’Israël. Je suis l’Éternel, qui vous sanctifie, ");
INSERT INTO fraLSG_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","et qui vous ai fait sortir du pays d’Égypte pour être votre Dieu. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Parle aux enfants d’Israël, et tu leur diras: Les fêtes de l’Éternel, que vous publierez, seront de saintes convocations. Voici quelles sont mes fêtes. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","On travaillera six jours; mais le septième jour est le sabbat, le jour du repos: il y aura une sainte convocation. Vous ne ferez aucun ouvrage: c’est le sabbat de l’Éternel, dans toutes vos demeures. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Voici les fêtes de l’Éternel, les saintes convocations, que vous publierez à leurs temps fixés. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Le premier mois, le quatorzième jour du mois, entre les deux soirs, ce sera la Pâque de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Et le quinzième jour de ce mois, ce sera la fête des pains sans levain en l’honneur de l’Éternel; vous mangerez pendant sept jours des pains sans levain. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Le premier jour, vous aurez une sainte convocation: vous ne ferez aucune œuvre servile. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Vous offrirez à l’Éternel, pendant sept jours, des sacrifices consumés par le feu. Le septième jour, il y aura une sainte convocation: vous ne ferez aucune œuvre servile. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Parle aux enfants d’Israël et tu leur diras: Quand vous serez entrés dans le pays que je vous donne, et que vous y ferez la moisson, vous apporterez au sacrificateur une gerbe, prémices de votre moisson. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Il agitera de côté et d’autre la gerbe devant l’Éternel, afin qu’elle soit agréée: le sacrificateur l’agitera de côté et d’autre, le lendemain du sabbat. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Le jour où vous agiterez la gerbe, vous offrirez en holocauste à l’Éternel un agneau d’un an sans défaut; ");
INSERT INTO fraLSG_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","vous y joindrez une offrande de deux dixièmes de fleur de farine pétrie à l’huile, comme offrande consumée par le feu, d’une agréable odeur à l’Éternel; et vous ferez une libation d’un quart de hin de vin. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Vous ne mangerez ni pain, ni épis rôtis ou broyés, jusqu’au jour même où vous apporterez l’offrande à votre Dieu. C’est une loi perpétuelle pour vos descendants, dans tous les lieux où vous habiterez. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Depuis le lendemain du sabbat, du jour où vous apporterez la gerbe pour être agitée de côté et d’autre, vous compterez sept semaines entières. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Vous compterez cinquante jours jusqu’au lendemain du septième sabbat; et vous ferez à l’Éternel une offrande nouvelle. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Vous apporterez de vos demeures deux pains, pour qu’ils soient agités de côté et d’autre; ils seront faits avec deux dixièmes de fleur de farine, et cuits avec du levain: ce sont les prémices à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Outre ces pains, vous offrirez en holocauste à l’Éternel sept agneaux d’un an sans défaut, un jeune taureau et deux béliers; vous y joindrez l’offrande et la libation ordinaires, comme offrande consumée par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Vous offrirez un bouc en sacrifice d’expiation, et deux agneaux d’un an en sacrifice d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Le sacrificateur agitera ces victimes de côté et d’autre devant l’Éternel, avec le pain des prémices et avec les deux agneaux: elles seront consacrées à l’Éternel, et appartiendront au sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Ce jour même, vous publierez la fête, et vous aurez une sainte convocation: vous ne ferez aucune œuvre servile. C’est une loi perpétuelle pour vos descendants, dans tous les lieux où vous habiterez. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Quand vous ferez la moisson dans votre pays, tu laisseras un coin de ton champ sans le moissonner, et tu ne ramasseras pas ce qui reste à glaner. Tu abandonneras cela au pauvre et à l’étranger. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Parle aux enfants d’Israël, et dis: Le septième mois, le premier jour du mois, vous aurez un jour de repos, publié au son des trompettes, et une sainte convocation. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Vous ne ferez aucune œuvre servile, et vous offrirez à l’Éternel des sacrifices consumés par le feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Le dixième jour de ce septième mois, ce sera le jour des expiations: vous aurez une sainte convocation, vous humilierez vos âmes, et vous offrirez à l’Éternel des sacrifices consumés par le feu. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Vous ne ferez aucun ouvrage ce jour-là, car c’est le jour des expiations, où doit être faite pour vous l’expiation devant l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Toute personne qui ne s’humiliera pas ce jour-là sera retranchée de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Toute personne qui fera ce jour-là un ouvrage quelconque, je la détruirai du milieu de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Vous ne ferez aucun ouvrage. C’est une loi perpétuelle pour vos descendants dans tous les lieux où vous habiterez. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ce sera pour vous un sabbat, un jour de repos, et vous humilierez vos âmes; dès le soir du neuvième jour jusqu’au soir suivant, vous célébrerez votre sabbat. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Parle aux enfants d’Israël, et dis: Le quinzième jour de ce septième mois, ce sera la fête des tabernacles en l’honneur de l’Éternel, pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Le premier jour, il y aura une sainte convocation: vous ne ferez aucune œuvre servile. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Pendant sept jours, vous offrirez à l’Éternel des sacrifices consumés par le feu. Le huitième jour, vous aurez une sainte convocation, et vous offrirez à l’Éternel des sacrifices consumés par le feu; ce sera une assemblée solennelle: vous ne ferez aucune œuvre servile. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Telles sont les fêtes de l’Éternel, les saintes convocations, que vous publierez, afin que l’on offre à l’Éternel des sacrifices consumés par le feu, des holocaustes, des offrandes, des victimes et des libations, chaque chose au jour fixé. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Vous observerez en outre les sabbats de l’Éternel, et vous continuerez à faire vos dons à l’Éternel, tous vos sacrifices pour l’accomplissement d’un vœu et toutes vos offrandes volontaires. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Le quinzième jour du septième mois, quand vous récolterez les produits du pays, vous célébrerez donc une fête à l’Éternel, pendant sept jours: le premier jour sera un jour de repos, et le huitième sera un jour de repos. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Vous prendrez, le premier jour, du fruit des beaux arbres, des branches de palmiers, des rameaux d’arbres touffus et des saules de rivière; et vous vous réjouirez devant l’Éternel, votre Dieu, pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Vous célébrerez chaque année cette fête à l’Éternel, pendant sept jours. C’est une loi perpétuelle pour vos descendants. Vous la célébrerez le septième mois. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Vous demeurerez pendant sept jours sous des tentes; tous les indigènes en Israël demeureront sous des tentes, ");
INSERT INTO fraLSG_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","afin que vos descendants sachent que j’ai fait habiter sous des tentes les enfants d’Israël, après les avoir fait sortir du pays d’Égypte. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","C’est ainsi que Moïse dit aux enfants d’Israël quelles sont les fêtes de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Ordonne aux enfants d’Israël de t’apporter pour le chandelier de l’huile pure d’olives concassées, afin d’entretenir les lampes continuellement. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","C’est en dehors du voile qui est devant le témoignage, dans la tente d’assignation, qu’Aaron la préparera, pour que les lampes brûlent continuellement du soir au matin en présence de l’Éternel. C’est une loi perpétuelle pour vos descendants. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Il arrangera les lampes sur le chandelier d’or pur, pour qu’elles brûlent continuellement devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Tu prendras de la fleur de farine, et tu en feras douze gâteaux; chaque gâteau sera de deux dixièmes. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Tu les placeras en deux piles, six par pile, sur la table d’or pur devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Tu mettras de l’encens pur sur chaque pile, et il sera sur le pain comme souvenir, comme une offrande consumée par le feu devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Chaque jour de sabbat, on rangera ces pains devant l’Éternel, continuellement: c’est une alliance perpétuelle qu’observeront les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ils appartiendront à Aaron et à ses fils, et ils les mangeront dans un lieu saint; car ce sera pour eux une chose très sainte, une part des offrandes consumées par le feu devant l’Éternel. C’est une loi perpétuelle. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Le fils d’une femme israélite et d’un homme égyptien, étant venu au milieu des enfants d’Israël, se querella dans le camp avec un homme israélite. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Le fils de la femme israélite blasphéma et maudit le nom de Dieu. On l’amena à Moïse. Sa mère s’appelait Schelomith, fille de Dibri, de la tribu de Dan. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","On le mit en prison, jusqu’à ce que Moïse eût déclaré ce que l’Éternel ordonnerait. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Fais sortir du camp le blasphémateur; tous ceux qui l’ont entendu poseront leurs mains sur sa tête, et toute l’assemblée le lapidera. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Tu parleras aux enfants d’Israël, et tu diras: Quiconque maudira son Dieu portera la peine de son péché. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Celui qui blasphémera le nom de l’Éternel sera puni de mort: toute l’assemblée le lapidera. Qu’il soit étranger ou indigène, il mourra, pour avoir blasphémé le nom de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Celui qui frappera un homme mortellement sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Celui qui frappera un animal mortellement le remplacera: vie pour vie. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Si quelqu’un blesse son prochain, il lui sera fait comme il a fait: ");
INSERT INTO fraLSG_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","fracture pour fracture, œil pour œil, dent pour dent; il lui sera fait la même blessure qu’il a faite à son prochain. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Celui qui tuera un animal le remplacera, mais celui qui tuera un homme sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Vous aurez la même loi, l’étranger comme l’indigène; car je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Moïse parla aux enfants d’Israël; ils firent sortir du camp le blasphémateur, et ils le lapidèrent. Les enfants d’Israël se conformèrent à l’ordre que l’Éternel avait donné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","L’Éternel parla à Moïse sur la montagne de Sinaï, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Parle aux enfants d’Israël, et tu leur diras: Quand vous serez entrés dans le pays que je vous donne, la terre se reposera: ce sera un sabbat en l’honneur de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Pendant six années tu ensemenceras ton champ, pendant six années tu tailleras ta vigne; et tu en recueilleras le produit. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Mais la septième année sera un sabbat, un temps de repos pour la terre, un sabbat en l’honneur de l’Éternel: tu n’ensemenceras point ton champ, et tu ne tailleras point ta vigne. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Tu ne moissonneras point ce qui proviendra des grains tombés de ta moisson, et tu ne vendangeras point les raisins de ta vigne non taillée: ce sera une année de repos pour la terre. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Ce que produira la terre pendant son sabbat vous servira de nourriture, à toi, à ton serviteur et à ta servante, à ton mercenaire et à l’étranger qui demeurent avec toi, ");
INSERT INTO fraLSG_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","à ton bétail et aux animaux qui sont dans ton pays; tout son produit servira de nourriture. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Tu compteras sept sabbats d’années, sept fois sept années, et les jours de ces sept sabbats d’années feront quarante-neuf ans. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Le dixième jour du septième mois, tu feras retentir les sons éclatants de la trompette; le jour des expiations, vous sonnerez de la trompette dans tout votre pays. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Et vous sanctifierez la cinquantième année, vous publierez la liberté dans le pays pour tous ses habitants: ce sera pour vous le jubilé; chacun de vous retournera dans sa propriété, et chacun de vous retournera dans sa famille. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","La cinquantième année sera pour vous le jubilé: vous ne sèmerez point, vous ne moissonnerez point ce que les champs produiront d’eux-mêmes, et vous ne vendangerez point la vigne non taillée. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Car c’est le jubilé: vous le regarderez comme une chose sainte. Vous mangerez le produit de vos champs. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Dans cette année de jubilé, chacun de vous retournera dans sa propriété. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Si vous vendez à votre prochain, ou si vous achetez de votre prochain, qu’aucun de vous ne trompe son frère. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Tu achèteras de ton prochain, en comptant les années depuis le jubilé; et il te vendra, en comptant les années de rapport. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Plus il y aura d’années, plus tu élèveras le prix; et moins il y aura d’années, plus tu le réduiras; car c’est le nombre des récoltes qu’il te vend. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Aucun de vous ne trompera son prochain, et tu craindras ton Dieu; car je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Mettez mes lois en pratique, observez mes ordonnances et mettez-les en pratique; et vous habiterez en sécurité dans le pays. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Le pays donnera ses fruits, vous mangerez à satiété, et vous y habiterez en sécurité. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Si vous dites: Que mangerons-nous la septième année, puisque nous ne sèmerons point et ne ferons point nos récoltes? ");
INSERT INTO fraLSG_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","je vous accorderai ma bénédiction la sixième année, et elle donnera des produits pour trois ans. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Vous sèmerez la huitième année, et vous mangerez de l’ancienne récolte; jusqu’à la neuvième année, jusqu’à la nouvelle récolte, vous mangerez de l’ancienne. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Les terres ne se vendront point à perpétuité; car le pays est à moi, car vous êtes chez moi comme étrangers et comme habitants. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Dans tout le pays dont vous aurez la possession, vous établirez le droit de rachat pour les terres. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Si ton frère devient pauvre et vend une portion de sa propriété, celui qui a le droit de rachat, son plus proche parent, viendra et rachètera ce qu’a vendu son frère. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Si un homme n’a personne qui ait le droit de rachat, et qu’il se procure lui-même de quoi faire son rachat, ");
INSERT INTO fraLSG_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","il comptera les années depuis la vente, restituera le surplus à l’acquéreur, et retournera dans sa propriété. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","S’il ne trouve pas de quoi lui faire cette restitution, ce qu’il a vendu restera entre les mains de l’acquéreur jusqu’à l’année du jubilé; au jubilé, il retournera dans sa propriété, et l’acquéreur en sortira. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Si un homme vend une maison d’habitation dans une ville entourée de murs, il aura le droit de rachat jusqu’à l’accomplissement d’une année depuis la vente; son droit de rachat durera un an. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Mais si cette maison située dans une ville entourée de murs n’est pas rachetée avant l’accomplissement d’une année entière, elle restera à perpétuité à l’acquéreur et à ses descendants; il n’en sortira point au jubilé. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Les maisons des villages non entourés de murs seront considérées comme des fonds de terre; elles pourront être rachetées, et l’acquéreur en sortira au jubilé. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Quant aux villes des Lévites et aux maisons qu’ils y posséderont, les Lévites auront droit perpétuel de rachat. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Celui qui achètera des Lévites une maison, sortira au jubilé de la maison vendue et de la ville où il la possédait; car les maisons des villes des Lévites sont leur propriété au milieu des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Les champs situés autour des villes des Lévites ne pourront point se vendre; car ils en ont à perpétuité la possession. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Si ton frère devient pauvre, et que sa main fléchisse près de toi, tu le soutiendras; tu feras de même pour celui qui est étranger et qui demeure dans le pays, afin qu’il vive avec toi. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Tu ne tireras de lui ni intérêt ni usure, tu craindras ton Dieu, et ton frère vivra avec toi. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Tu ne lui prêteras point ton argent à intérêt, et tu ne lui prêteras point tes vivres à usure. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Je suis l’Éternel, ton Dieu, qui vous ai fait sortir du pays d’Égypte, pour vous donner le pays de Canaan, pour être votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Si ton frère devient pauvre près de toi, et qu’il se vende à toi, tu ne lui imposeras point le travail d’un esclave. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Il sera chez toi comme un mercenaire, comme celui qui y demeure; il sera à ton service jusqu’à l’année du jubilé. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Il sortira alors de chez toi, lui et ses enfants avec lui, et il retournera dans sa famille, dans la propriété de ses pères. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Car ce sont mes serviteurs, que j’ai fait sortir du pays d’Égypte; ils ne seront point vendus comme on vend des esclaves. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Tu ne domineras point sur lui avec dureté, et tu craindras ton Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","C’est des nations qui vous entourent que tu prendras ton esclave et ta servante qui t’appartiendront, c’est d’elles que vous achèterez l’esclave et la servante. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Vous pourrez aussi en acheter des enfants des étrangers qui demeureront chez toi, et de leurs familles qu’ils engendreront dans votre pays; et ils seront votre propriété. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Vous les laisserez en héritage à vos enfants après vous, comme une propriété; vous les garderez comme esclaves à perpétuité. Mais à l’égard de vos frères, les enfants d’Israël, aucun de vous ne dominera avec dureté sur son frère. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Si un étranger, si celui qui demeure chez toi devient riche, et que ton frère devienne pauvre près de lui et se vende à l’étranger qui demeure chez toi ou à quelqu’un de la famille de l’étranger, ");
INSERT INTO fraLSG_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","il y aura pour lui le droit de rachat, après qu’il se sera vendu: un de ses frères pourra le racheter. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Son oncle, ou le fils de son oncle, ou l’un de ses proches parents, pourra le racheter; ou bien, s’il en a les ressources, il se rachètera lui-même. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Il comptera avec celui qui l’a acheté depuis l’année où il s’est vendu jusqu’à l’année du jubilé; et le prix à payer dépendra du nombre d’années, lesquelles seront évaluées comme celles d’un mercenaire. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","S’il y a encore beaucoup d’années, il paiera son rachat à raison du prix de ces années et pour lequel il a été acheté; ");
INSERT INTO fraLSG_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","s’il reste peu d’années jusqu’à celle du jubilé, il en fera le compte, et il paiera son rachat à raison de ces années. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Il sera comme un mercenaire à l’année, et celui chez qui il sera ne le traitera point avec dureté sous tes yeux. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","S’il n’est racheté d’aucune de ces manières, il sortira l’année du jubilé, lui et ses enfants avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Car c’est de moi que les enfants d’Israël sont esclaves; ce sont mes esclaves, que j’ai fait sortir du pays d’Égypte. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Vous ne vous ferez point d’idoles, vous ne vous élèverez ni image taillée ni statue, et vous ne placerez dans votre pays aucune pierre ornée de figures, pour vous prosterner devant elle; car je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Vous observerez mes sabbats, et vous révérerez mon sanctuaire. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Si vous suivez mes lois, si vous gardez mes commandements et les mettez en pratique, ");
INSERT INTO fraLSG_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","je vous enverrai des pluies en leur saison, la terre donnera ses produits, et les arbres des champs donneront leurs fruits. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","A peine aurez-vous battu le blé que vous toucherez à la vendange, et la vendange atteindra les semailles; vous mangerez votre pain à satiété, et vous habiterez en sécurité dans votre pays. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Je mettrai la paix dans le pays, et personne ne troublera votre sommeil; je ferai disparaître du pays les bêtes féroces, et l’épée ne passera point par votre pays. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Vous poursuivrez vos ennemis, et ils tomberont devant vous par l’épée. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Cinq d’entre vous en poursuivront cent, et cent d’entre vous en poursuivront dix mille, et vos ennemis tomberont devant vous par l’épée. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Je me tournerai vers vous, je vous rendrai féconds et je vous multiplierai, et je maintiendrai mon alliance avec vous. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Vous mangerez des anciennes récoltes, et vous sortirez les vieilles pour faire place aux nouvelles. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","J’établirai ma demeure au milieu de vous, et mon âme ne vous aura point en horreur. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Je marcherai au milieu de vous, je serai votre Dieu, et vous serez mon peuple. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Je suis l’Éternel, votre Dieu, qui vous ai fait sortir du pays d’Égypte, qui vous ai tirés de la servitude; j’ai brisé les liens de votre joug, et je vous ai fait marcher la tête levée. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Mais si vous ne m’écoutez point et ne mettez point en pratique tous ces commandements, ");
INSERT INTO fraLSG_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","si vous méprisez mes lois, et si votre âme a en horreur mes ordonnances, en sorte que vous ne pratiquiez point tous mes commandements et que vous rompiez mon alliance, ");
INSERT INTO fraLSG_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","voici alors ce que je vous ferai. J’enverrai sur vous la terreur, la consomption et la fièvre, qui rendront vos yeux languissants et votre âme souffrante; et vous sèmerez en vain vos semences: vos ennemis les dévoreront. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Je tournerai ma face contre vous, et vous serez battus devant vos ennemis; ceux qui vous haïssent domineront sur vous, et vous fuirez sans que l’on vous poursuive. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Si, malgré cela, vous ne m’écoutez point, je vous châtierai sept fois plus pour vos péchés. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Je briserai l’orgueil de votre force, je rendrai votre ciel comme du fer, et votre terre comme de l’airain. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Votre force s’épuisera inutilement, votre terre ne donnera pas ses produits, et les arbres de la terre ne donneront pas leurs fruits. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Si vous me résistez et ne voulez point m’écouter, je vous frapperai sept fois plus selon vos péchés. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","J’enverrai contre vous les animaux des champs, qui vous priveront de vos enfants, qui détruiront votre bétail, et qui vous réduiront à un petit nombre; et vos chemins seront déserts. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Si ces châtiments ne vous corrigent point et si vous me résistez, ");
INSERT INTO fraLSG_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","je vous résisterai aussi et je vous frapperai sept fois plus pour vos péchés. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Je ferai venir contre vous l’épée, qui vengera mon alliance; quand vous vous rassemblerez dans vos villes, j’enverrai la peste au milieu de vous, et vous serez livrés aux mains de l’ennemi. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Lorsque je vous briserai le bâton du pain, dix femmes cuiront votre pain dans un seul four et rapporteront votre pain au poids; vous mangerez, et vous ne serez point rassasiés. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Si, malgré cela, vous ne m’écoutez point et si vous me résistez, ");
INSERT INTO fraLSG_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","je vous résisterai aussi avec fureur et je vous châtierai sept fois plus pour vos péchés. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Vous mangerez la chair de vos fils, et vous mangerez la chair de vos filles. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Je détruirai vos hauts lieux, j’abattrai vos statues consacrées au soleil, je mettrai vos cadavres sur les cadavres de vos idoles, et mon âme vous aura en horreur. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Je réduirai vos villes en déserts, je ravagerai vos sanctuaires, et je ne respirerai plus l’odeur agréable de vos parfums. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Je dévasterai le pays, et vos ennemis qui l’habiteront en seront stupéfaits. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Je vous disperserai parmi les nations et je tirerai l’épée après vous. Votre pays sera dévasté, et vos villes seront désertes. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Alors le pays jouira de ses sabbats, tout le temps qu’il sera dévasté et que vous serez dans le pays de vos ennemis; alors le pays se reposera, et jouira de ses sabbats. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Tout le temps qu’il sera dévasté, il aura le repos qu’il n’avait pas eu dans vos sabbats, tandis que vous l’habitiez. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Je rendrai pusillanime le cœur de ceux d’entre vous qui survivront, dans les pays de leurs ennemis; le bruit d’une feuille agitée les poursuivra; ils fuiront comme on fuit devant l’épée, et ils tomberont sans qu’on les poursuive. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ils se renverseront les uns sur les autres comme devant l’épée, sans qu’on les poursuive. Vous ne subsisterez point en présence de vos ennemis; ");
INSERT INTO fraLSG_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","vous périrez parmi les nations, et le pays de vos ennemis vous dévorera. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ceux d’entre vous qui survivront seront frappés de langueur pour leurs iniquités, dans les pays de leurs ennemis; ils seront aussi frappés de langueur pour les iniquités de leurs pères. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Ils confesseront leurs iniquités et les iniquités de leurs pères, les transgressions qu’ils ont commises envers moi, et la résistance qu’ils m’ont opposée, ");
INSERT INTO fraLSG_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","péchés à cause desquels moi aussi je leur résisterai et les mènerai dans le pays de leurs ennemis. Et alors leur cœur incirconcis s’humiliera, et ils paieront la dette de leurs iniquités. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Je me souviendrai de mon alliance avec Jacob, je me souviendrai de mon alliance avec Isaac et de mon alliance avec Abraham, et je me souviendrai du pays. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Le pays sera abandonné par eux, et il jouira de ses sabbats pendant qu’il restera dévasté loin d’eux; et ils paieront la dette de leurs iniquités, parce qu’ils ont méprisé mes ordonnances et que leur âme a eu mes lois en horreur. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Mais, lorsqu’ils seront dans le pays de leurs ennemis, je ne les rejetterai pourtant point, et je ne les aurai point en horreur jusqu’à les exterminer, jusqu’à rompre mon alliance avec eux; car je suis l’Éternel, leur Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Je me souviendrai en leur faveur de l’ancienne alliance, par laquelle je les ai fait sortir du pays d’Égypte, aux yeux des nations, pour être leur Dieu. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Tels sont les statuts, les ordonnances et les lois, que l’Éternel établit entre lui et les enfants d’Israël, sur la montagne de Sinaï, par Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Parle aux enfants d’Israël, et tu leur diras: Lorsqu’on fera des vœux, s’il s’agit de personnes, elles seront à l’Éternel d’après ton estimation. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Si tu as à faire l’estimation d’un mâle de vingt à soixante ans, ton estimation sera de cinquante sicles d’argent, selon le sicle du sanctuaire; ");
INSERT INTO fraLSG_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","si c’est une femme, ton estimation sera de trente sicles. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","De cinq à vingt ans, ton estimation sera de vingt sicles pour un mâle, et de dix sicles pour une fille. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","D’un mois à cinq ans, ton estimation sera de cinq sicles d’argent pour un mâle, et de trois sicles d’argent pour une fille. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","De soixante ans et au-dessus, ton estimation sera de quinze sicles pour un mâle, et de dix sicles pour une femme. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Si celui qui a fait le vœu est trop pauvre pour payer ton estimation, on le présentera au sacrificateur, qui le taxera, et le sacrificateur fera une estimation en rapport avec les ressources de cet homme. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","S’il s’agit d’animaux qui peuvent être offerts en sacrifice à l’Éternel, tout animal qu’on donnera à l’Éternel sera chose sainte. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","On ne le changera point, et l’on n’en mettra point un mauvais à la place d’un bon ni un bon à la place d’un mauvais; si l’on remplace un animal par un autre, ils seront l’un et l’autre chose sainte. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","S’il s’agit d’animaux impurs, qui ne peuvent être offerts en sacrifice à l’Éternel, on présentera l’animal au sacrificateur, ");
INSERT INTO fraLSG_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","qui en fera l’estimation selon qu’il sera bon ou mauvais, et l’on s’en rapportera à l’estimation du sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Si on veut le racheter, on ajoutera un cinquième à son estimation. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Si quelqu’un sanctifie sa maison en la consacrant à l’Éternel, le sacrificateur en fera l’estimation selon qu’elle sera bonne ou mauvaise, et l’on s’en tiendra à l’estimation du sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Si celui qui a sanctifié sa maison veut la racheter, il ajoutera un cinquième au prix de son estimation, et elle sera à lui. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Si quelqu’un sanctifie à l’Éternel un champ de sa propriété, ton estimation sera en rapport avec la quantité de semence, cinquante sicles d’argent pour un homer de semence d’orge. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Si c’est dès l’année du jubilé qu’il sanctifie son champ, on s’en tiendra à ton estimation; ");
INSERT INTO fraLSG_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","si c’est après le jubilé qu’il sanctifie son champ, le sacrificateur en évaluera le prix à raison du nombre d’années qui restent jusqu’au jubilé, et il sera fait une réduction sur ton estimation. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Si celui qui a sanctifié son champ veut le racheter, il ajoutera un cinquième au prix de ton estimation, et le champ lui restera. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","S’il ne rachète point le champ, et qu’on le vende à un autre homme, il ne pourra plus être racheté. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Et quand l’acquéreur en sortira au jubilé, ce champ sera consacré à l’Éternel, comme un champ qui a été dévoué; il deviendra la propriété du sacrificateur. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Si quelqu’un sanctifie à l’Éternel un champ qu’il a acquis et qui ne fait point partie de sa propriété, ");
INSERT INTO fraLSG_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","le sacrificateur en évaluera le prix d’après ton estimation jusqu’à l’année du jubilé, et cet homme paiera le jour même le prix fixé, comme étant consacré à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","L’année du jubilé, le champ retournera à celui de qui il avait été acheté et de la propriété dont il faisait partie. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Toutes tes estimations se feront en sicles du sanctuaire: le sicle est de vingt guéras. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Nul ne pourra sanctifier le premier-né de son bétail, lequel appartient déjà à l’Éternel en sa qualité de premier-né; soit bœuf, soit agneau, il appartient à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","S’il s’agit d’un animal impur, on le rachètera au prix de ton estimation, en y ajoutant un cinquième; s’il n’est pas racheté, il sera vendu d’après ton estimation. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Tout ce qu’un homme dévouera par interdit à l’Éternel, dans ce qui lui appartient, ne pourra ni se vendre, ni se racheter, que ce soit une personne, un animal, ou un champ de sa propriété; tout ce qui sera dévoué par interdit sera entièrement consacré à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Aucune personne dévouée par interdit ne pourra être rachetée, elle sera mise à mort. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Toute dîme de la terre, soit des récoltes de la terre, soit du fruit des arbres, appartient à l’Éternel; c’est une chose consacrée à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Si quelqu’un veut racheter quelque chose de sa dîme, il y ajoutera un cinquième. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Toute dîme de gros et de menu bétail, de tout ce qui passe sous la houlette, sera une dîme consacrée à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","On n’examinera point si l’animal est bon ou mauvais, et l’on ne fera point d’échange; si l’on remplace un animal par un autre, ils seront l’un et l’autre chose sainte, et ne pourront être rachetés. ");
INSERT INTO fraLSG_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Tels sont les commandements que l’Éternel donna à Moïse pour les enfants d’Israël, sur la montagne de Sinaï.");
INSERT INTO fraLSG_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","L’Éternel parla à Moïse dans le désert de Sinaï, dans la tente d’assignation, le premier jour du second mois, la seconde année après leur sortie du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Il dit: Faites le dénombrement de toute l’assemblée des enfants d’Israël, selon leurs familles, selon les maisons de leurs pères, en comptant par tête les noms de tous les mâles, ");
INSERT INTO fraLSG_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","depuis l’âge de vingt ans et au-dessus, tous ceux d’Israël en état de porter les armes; vous en ferez le dénombrement selon leurs divisions, toi et Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Il y aura avec vous un homme par tribu, chef de la maison de ses pères. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Voici les noms des hommes qui se tiendront avec vous. Pour Ruben: Élitsur, fils de Schedéur; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","pour Siméon: Schelumiel, fils de Tsurischaddaï; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","pour Juda: Nachschon, fils d’Amminadab; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","pour Issacar: Nethaneel, fils de Tsuar; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","pour Zabulon: Éliab, fils de Hélon; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","pour les fils de Joseph, pour Éphraïm: Élischama, fils d’Ammihud; pour Manassé: Gamliel, fils de Pedahtsur; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","pour Benjamin: Abidan, fils de Guideoni; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","pour Dan: Ahiézer, fils d’Ammischaddaï; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","pour Aser: Paguiel, fils d’Ocran; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","pour Gad: Éliasaph, fils de Déuel; ");
INSERT INTO fraLSG_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","pour Nephthali: Ahira, fils d’Énan. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Tels sont ceux qui furent convoqués à l’assemblée, princes des tribus de leurs pères, chefs des milliers d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Moïse et Aaron prirent ces hommes, qui avaient été désignés par leurs noms, ");
INSERT INTO fraLSG_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","et ils convoquèrent toute l’assemblée, le premier jour du second mois. On les enregistra selon leurs familles, selon les maisons de leurs pères, en comptant par tête les noms depuis l’âge de vingt ans et au-dessus. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Moïse en fit le dénombrement dans le désert de Sinaï, comme l’Éternel le lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","On enregistra les fils de Ruben, premier-né d’Israël, selon leurs familles, selon les maisons de leurs pères, en comptant par tête les noms de tous les mâles, depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","les hommes de la tribu de Ruben dont on fit le dénombrement furent quarante-six mille cinq cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","On enregistra les fils de Siméon, selon leurs familles, selon les maisons de leurs pères; on en fit le dénombrement, en comptant par tête les noms de tous les mâles depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","les hommes de la tribu de Siméon dont on fit le dénombrement furent cinquante-neuf mille trois cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","On enregistra les fils de Gad, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","les hommes de la tribu de Gad dont on fit le dénombrement furent quarante-cinq mille six cent cinquante. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","On enregistra les fils de Juda, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","les hommes de la tribu de Juda dont on fit le dénombrement furent soixante-quatorze mille six cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","On enregistra les fils d’Issacar, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","les hommes de la tribu d’Issacar dont on fit le dénombrement furent cinquante-quatre mille quatre cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","On enregistra les fils de Zabulon, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","les hommes de la tribu de Zabulon dont on fit le dénombrement furent cinquante-sept mille quatre cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","On enregistra, d’entre les fils de Joseph, les fils d’Éphraïm, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","les hommes de la tribu d’Éphraïm dont on fit le dénombrement furent quarante mille cinq cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","On enregistra les fils de Manassé, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","les hommes de la tribu de Manassé dont on fit le dénombrement furent trente-deux mille deux cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","On enregistra les fils de Benjamin, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","les hommes de la tribu de Benjamin dont on fit le dénombrement furent trente-cinq mille quatre cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","On enregistra les fils de Dan, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","les hommes de la tribu de Dan dont on fit le dénombrement furent soixante-deux mille sept cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","On enregistra les fils d’Aser, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","les hommes de la tribu d’Aser dont on fit le dénombrement furent quarante et un mille cinq cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","On enregistra les fils de Nephthali, selon leurs familles, selon les maisons de leurs pères, en comptant les noms depuis l’âge de vingt ans et au-dessus, tous ceux en état de porter les armes: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","les hommes de la tribu de Nephthali dont on fit le dénombrement furent cinquante-trois mille quatre cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Tels sont ceux dont le dénombrement fut fait par Moïse et Aaron, et par les douze hommes, princes d’Israël; il y avait un homme pour chacune des maisons de leurs pères. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Tous ceux des enfants d’Israël dont on fit le dénombrement, selon les maisons de leurs pères, depuis l’âge de vingt ans et au-dessus, tous ceux d’Israël en état de porter les armes, ");
INSERT INTO fraLSG_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","tous ceux dont on fit le dénombrement furent six cent trois mille cinq cent cinquante. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Les Lévites, selon la tribu de leurs pères, ne firent point partie de ce dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Tu ne feras point le dénombrement de la tribu de Lévi, et tu n’en compteras point les têtes au milieu des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Remets aux soins des Lévites le tabernacle du témoignage, tous ses ustensiles et tout ce qui lui appartient. Ils porteront le tabernacle et tous ses ustensiles, ils en feront le service, et ils camperont autour du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Quand le tabernacle partira, les Lévites le démonteront; quand le tabernacle campera, les Lévites le dresseront; et l’étranger qui en approchera sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Les enfants d’Israël camperont chacun dans son camp, chacun près de sa bannière, selon leurs divisions. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Mais les Lévites camperont autour du tabernacle du témoignage, afin que ma colère n’éclate point sur l’assemblée des enfants d’Israël; et les Lévites auront la garde du tabernacle du témoignage. ");
INSERT INTO fraLSG_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Les enfants d’Israël se conformèrent à tous les ordres que l’Éternel avait donnés à Moïse; ils firent ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","L’Éternel parla à Moïse et à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Les enfants d’Israël camperont chacun près de sa bannière, sous les enseignes de la maison de ses pères; ils camperont vis-à-vis et tout autour de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","A l’orient, le camp de Juda, avec sa bannière, et avec ses corps d’armée. Là camperont le prince des fils de Juda, Nachschon, fils d’Amminadab, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","et son corps d’armée composé de soixante-quatorze mille six cents hommes, d’après le dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","A ses côtés camperont la tribu d’Issacar, le prince des fils d’Issacar, Nethaneel, fils de Tsuar, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","et son corps d’armée composé de cinquante-quatre mille quatre cents hommes, d’après le dénombrement; ");
INSERT INTO fraLSG_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","puis la tribu de Zabulon, le prince des fils de Zabulon, Éliab, fils de Hélon, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","et son corps d’armée composé de cinquante-sept mille quatre cents hommes, d’après le dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Total pour le camp de Juda, d’après le dénombrement: cent quatre-vingt six mille quatre cents hommes, selon leurs corps d’armée. Ils seront les premiers dans la marche. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Au midi, le camp de Ruben, avec sa bannière, et avec ses corps d’armée. Là camperont le prince des fils de Ruben, Élitsur, fils de Schedéur, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","et son corps d’armée composé de quarante-six mille cinq cents hommes, d’après le dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","A ses côtés camperont la tribu de Siméon, le prince des fils de Siméon, Schelumiel, fils de Tsurischaddaï, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","et son corps d’armée composé de cinquante-neuf mille trois cents hommes, d’après le dénombrement; ");
INSERT INTO fraLSG_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","puis la tribu de Gad, le prince des fils de Gad, Éliasaph, fils de Déuel, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","et son corps d’armée composé de quarante-cinq mille six cent cinquante hommes, d’après le dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Total pour le camp de Ruben, d’après le dénombrement: cent cinquante et un mille quatre cent cinquante hommes, selon leurs corps d’armée. Ils seront les seconds dans la marche. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ensuite partira la tente d’assignation, avec le camp des Lévites placé au milieu des autres camps: Ils suivront dans la marche l’ordre dans lequel ils auront campé, chacun dans son rang, selon sa bannière. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","A l’occident, le camp d’Éphraïm, avec sa bannière, et avec ses corps d’armée. Là camperont le prince des fils d’Éphraïm, Élischama, fils d’Ammihud, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","et son corps d’armée composé de quarante mille cinq cents hommes, d’après le dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","A ses côtés camperont la tribu de Manassé, le prince des fils de Manassé, Gamliel, fils de Pedahtsur, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","et son corps d’armée composé de trente-deux mille deux cents hommes, d’après le dénombrement; ");
INSERT INTO fraLSG_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","puis la tribu de Benjamin, le prince des fils de Benjamin, Abidan, fils de Guideoni, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","et son corps d’armée composé de trente-cinq mille quatre cents hommes, d’après le dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Total pour le camp d’Éphraïm, d’après le dénombrement: cent huit mille et cent hommes, selon leurs corps d’armée. Ils seront les troisièmes dans la marche. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Au nord, le camp de Dan, avec sa bannière, et avec ses corps d’armée. Là camperont le prince des fils de Dan, Ahiézer, fils d’Ammischaddaï, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","et son corps d’armée composé de soixante-deux mille sept cents hommes, d’après le dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","A ses côtés camperont la tribu d’Aser, le prince des fils d’Aser, Paguiel, fils d’Ocran, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","et son corps d’armée composé de quarante et un mille cinq cents hommes, d’après le dénombrement; ");
INSERT INTO fraLSG_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","puis la tribu de Nephthali, le prince des fils de Nephthali, Ahira, fils d’Énan, ");
INSERT INTO fraLSG_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","et son corps d’armée composé de cinquante-trois mille quatre cents hommes, d’après le dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Total pour le camp de Dan, d’après le dénombrement: cent cinquante-sept mille six cents hommes. Ils seront les derniers dans la marche, selon leur bannière. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Tels sont ceux des enfants d’Israël dont on fit le dénombrement, selon les maisons de leurs pères. Tous ceux dont on fit le dénombrement, et qui formèrent les camps, selon leurs corps d’armée, furent six cent trois mille cinq cent cinquante. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Les Lévites, suivant l’ordre que l’Éternel avait donné à Moïse, ne firent point partie du dénombrement au milieu des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Et les enfants d’Israël se conformèrent à tous les ordres que l’Éternel avait donnés à Moïse. C’est ainsi qu’ils campaient, selon leurs bannières; et c’est ainsi qu’ils se mettaient en marche, chacun selon sa famille, selon la maison de ses pères. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Voici la postérité d’Aaron et de Moïse, au temps où l’Éternel parla à Moïse, sur la montagne de Sinaï. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Voici les noms des fils d’Aaron: Nadab, le premier-né, Abihu, Éléazar et Ithamar. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ce sont là les noms des fils d’Aaron, qui reçurent l’onction comme sacrificateurs, et qui furent consacrés pour l’exercice du sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nadab et Abihu moururent devant l’Éternel, lorsqu’ils apportèrent devant l’Éternel du feu étranger, dans le désert de Sinaï; ils n’avaient point de fils. Éléazar et Ithamar exercèrent le sacerdoce, en présence d’Aaron, leur père. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Fais approcher la tribu de Lévi, et tu la placeras devant le sacrificateur Aaron, pour qu’elle soit à son service. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ils auront le soin de ce qui est remis à sa garde et à la garde de toute l’assemblée, devant la tente d’assignation: ils feront le service du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ils auront le soin de tous les ustensiles de la tente d’assignation, et de ce qui est remis à la garde des enfants d’Israël: ils feront le service du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Tu donneras les Lévites à Aaron et à ses fils; ils lui seront entièrement donnés, de la part des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Tu établiras Aaron et ses fils pour qu’ils observent les fonctions de leur sacerdoce; et l’étranger qui approchera sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Voici, j’ai pris les Lévites du milieu des enfants d’Israël, à la place de tous les premiers-nés, des premiers-nés des enfants d’Israël; et les Lévites m’appartiendront. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Car tout premier-né m’appartient; le jour où j’ai frappé tous les premiers-nés dans le pays d’Égypte, je me suis consacré tous les premiers-nés en Israël, tant des hommes que des animaux: ils m’appartiendront. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","L’Éternel parla à Moïse, dans le désert de Sinaï, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Fais le dénombrement des enfants de Lévi, selon les maisons de leurs pères, selon leurs familles; tu feras le dénombrement de tous les mâles, depuis l’âge d’un mois et au-dessus. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Moïse en fit le dénombrement sur l’ordre de l’Éternel, en se conformant à l’ordre qui lui fut donné. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ce sont ici les fils de Lévi, d’après leurs noms: Guerschon, Kehath et Merari. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Voici les noms des fils de Guerschon, selon leurs familles: Libni et Schimeï. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Voici les fils de Kehath, selon leurs familles: Amram, Jitsehar, Hébron et Uziel; ");
INSERT INTO fraLSG_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","et les fils de Merari, selon leurs familles: Machli et Muschi. Ce sont là les familles de Lévi, selon les maisons de leurs pères. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","De Guerschon descendent la famille de Libni et la famille de Schimeï, formant les familles des Guerschonites. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ceux dont on fit le dénombrement, en comptant tous les mâles depuis l’âge d’un mois et au-dessus, furent sept mille cinq cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Les familles des Guerschonites campaient derrière le tabernacle à l’occident. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Le chef de la maison paternelle des Guerschonites était Éliasaph, fils de Laël. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Pour ce qui concerne la tente d’assignation, on remit aux soins des fils de Guerschon le tabernacle et la tente, la couverture, le rideau qui est à l’entrée de la tente d’assignation; ");
INSERT INTO fraLSG_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","les toiles du parvis et le rideau de l’entrée du parvis, tout autour du tabernacle et de l’autel, et tous les cordages pour le service du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","De Kehath descendent la famille des Amramites, la famille des Jitseharites, la famille des Hébronites et la famille des Uziélites, formant les familles des Kehathites. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","En comptant tous les mâles depuis l’âge d’un mois et au-dessus, il y en eut huit mille six cents, qui furent chargés des soins du sanctuaire. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Les familles des fils de Kehath campaient au côté méridional du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Le chef de la maison paternelle des familles des Kehathites était Élitsaphan, fils d’Uziel. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","On remit à leurs soins l’arche, la table, le chandelier, les autels, les ustensiles du sanctuaire, avec lesquels on fait le service, le voile et tout ce qui en dépend. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Le chef des chefs des Lévites était Éléazar, fils du sacrificateur Aaron; il avait la surveillance de ceux qui étaient chargés des soins du sanctuaire. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","De Merari descendent la famille de Machli et la famille de Muschi, formant les familles des Merarites. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ceux dont on fit le dénombrement, en comptant tous les mâles depuis l’âge d’un mois et au-dessus, furent six mille deux cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Le chef de la maison paternelle des familles de Merari était Tsuriel, fils d’Abihaïl. Ils campaient du côté septentrional du tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","On remit à la garde et aux soins des fils de Merari les planches du tabernacle, ses barres, ses colonnes et leurs bases, tous ses ustensiles et tout ce qui en dépend; ");
INSERT INTO fraLSG_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","les colonnes du parvis tout autour, leurs bases, leurs pieux et leurs cordages. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Moïse, Aaron et ses fils campaient devant le tabernacle, à l’orient, devant la tente d’assignation, au levant; ils avaient la garde et le soin du sanctuaire, remis à la garde des enfants d’Israël; et l’étranger qui s’approchera sera puni de mort. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Tous les Lévites dont Moïse et Aaron firent le dénombrement sur l’ordre de l’Éternel, selon leurs familles, tous les mâles depuis l’âge d’un mois et au-dessus, furent vingt-deux mille. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","L’Éternel dit à Moïse: Fais le dénombrement de tous les premiers-nés mâles parmi les enfants d’Israël, depuis l’âge d’un mois et au-dessus, et compte-les d’après leurs noms. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Tu prendras les Lévites pour moi, l’Éternel, à la place de tous les premiers-nés des enfants d’Israël, et le bétail des Lévites à la place de tous les premiers-nés du bétail des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Moïse fit le dénombrement de tous les premiers-nés parmi les enfants d’Israël, selon l’ordre que l’Éternel lui avait donné. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Tous les premiers-nés mâles, dont on fit le dénombrement, en comptant les noms, depuis l’âge d’un mois et au-dessus, furent vingt-deux mille deux cent soixante-treize. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Prends les Lévites à la place de tous les premiers-nés des enfants d’Israël, et le bétail des Lévites à la place de leur bétail; et les Lévites m’appartiendront. Je suis l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Pour le rachat des deux cent soixante-treize qui dépassent le nombre des Lévites, parmi les premiers-nés des enfants d’Israël, ");
INSERT INTO fraLSG_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","tu prendras cinq sicles par tête; tu les prendras selon le sicle du sanctuaire, qui est de vingt guéras. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Tu donneras l’argent à Aaron et à ses fils, pour le rachat de ceux qui dépassent le nombre des Lévites. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Moïse prit l’argent pour le rachat de ceux qui dépassaient le nombre des rachetés par les Lévites; ");
INSERT INTO fraLSG_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","il prit l’argent des premiers-nés des enfants d’Israël: mille trois cent soixante-cinq sicles, selon le sicle du sanctuaire. ");
INSERT INTO fraLSG_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Et Moïse donna l’argent du rachat à Aaron et à ses fils, sur l’ordre de l’Éternel, en se conformant à l’ordre que l’Éternel avait donné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","L’Éternel parla à Moïse et à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Compte les fils de Kehath parmi les enfants de Lévi, selon leurs familles, selon les maisons de leurs pères, ");
INSERT INTO fraLSG_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui sont propres à exercer quelque fonction dans la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Voici les fonctions des fils de Kehath, dans la tente d’assignation: elles concernent le lieu très saint. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Au départ du camp, Aaron et ses fils viendront démonter le voile, et ils en couvriront l’arche du témoignage; ");
INSERT INTO fraLSG_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ils mettront dessus une couverture de peaux de dauphins, et ils étendront par-dessus un drap entièrement d’étoffe bleue; puis ils placeront les barres de l’arche. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ils étendront un drap bleu sur la table des pains de proposition, et ils mettront dessus les plats, les coupes, les tasses et les calices pour les libations; le pain y sera toujours; ");
INSERT INTO fraLSG_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ils étendront sur ces choses un drap de cramoisi, et ils l’envelopperont d’une couverture de peaux de dauphins; puis ils placeront les barres de la table. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ils prendront un drap bleu, et ils couvriront le chandelier, ses lampes, ses mouchettes, ses vases à cendre et tous ses vases à huile, destinés à son service; ");
INSERT INTO fraLSG_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ils le mettront, avec tous ses ustensiles, dans une couverture de peaux de dauphins; puis ils le placeront sur le brancard. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ils étendront un drap bleu sur l’autel d’or, et ils l’envelopperont d’une couverture de peaux de dauphins; puis ils placeront les barres de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ils prendront tous les ustensiles dont on se sert pour le service dans le sanctuaire, et ils les mettront dans un drap bleu, et ils les envelopperont d’une couverture de peaux de dauphins; puis ils les placeront sur le brancard. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Ils ôteront les cendres de l’autel, et ils étendront sur l’autel un drap de pourpre; ");
INSERT INTO fraLSG_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ils mettront dessus tous les ustensiles destinés à son service, les brasiers, les fourchettes, les pelles, les bassins, tous les ustensiles de l’autel, et ils étendront par-dessus une couverture de peaux de dauphins; puis ils placeront les barres de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Après qu’Aaron et ses fils auront achevé de couvrir le sanctuaire et tous les ustensiles du sanctuaire, les fils de Kehath viendront, au départ du camp, pour les porter; mais ils ne toucheront point les choses saintes, de peur qu’ils ne meurent. Telles sont les fonctions de porteurs, imposées aux fils de Kehath dans la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Éléazar, fils du sacrificateur Aaron, aura sous sa surveillance l’huile du chandelier, le parfum odoriférant, l’offrande perpétuelle et l’huile d’onction; il aura sous sa surveillance tout le tabernacle et tout ce qu’il contient, le sanctuaire et ses ustensiles. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","L’Éternel parla à Moïse et à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","N’exposez point la race des familles des Kehathites à être retranchée du milieu des Lévites. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Faites ceci pour eux, afin qu’ils vivent et qu’ils ne meurent point, quand ils s’approcheront du lieu très saint: Aaron et ses fils viendront, et ils placeront chacun d’eux à son service et à sa charge. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ils n’entreront point pour voir envelopper les choses saintes, de peur qu’ils ne meurent. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Compte aussi les fils de Guerschon, selon les maisons de leurs pères, selon leurs familles; ");
INSERT INTO fraLSG_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","tu feras le dénombrement, depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, de tous ceux qui sont propres à exercer quelque fonction dans la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Voici les fonctions des familles des Guerschonites, le service qu’ils devront faire et ce qu’ils devront porter. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Ils porteront les tapis du tabernacle et la tente d’assignation, sa couverture et la couverture de peaux de dauphins qui se met par-dessus, le rideau qui est à l’entrée de la tente d’assignation; ");
INSERT INTO fraLSG_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","les toiles du parvis et le rideau de l’entrée de la porte du parvis, tout autour du tabernacle et de l’autel, leurs cordages et tous les ustensiles qui en dépendent. Et ils feront tout le service qui s’y rapporte. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Dans leurs fonctions, les fils des Guerschonites seront sous les ordres d’Aaron et de ses fils, pour tout ce qu’ils porteront et pour tout le service qu’ils devront faire; vous remettrez à leurs soins tout ce qu’ils ont à porter. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Telles sont les fonctions des familles des fils des Guerschonites dans la tente d’assignation, et ce qu’ils ont à garder sous la direction d’Ithamar, fils du sacrificateur Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Tu feras le dénombrement des fils de Merari, selon leurs familles, selon les maisons de leurs pères; ");
INSERT INTO fraLSG_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","tu feras le dénombrement, depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, de tous ceux qui sont propres à exercer quelque fonction dans la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Voici ce qui est remis à leurs soins et ce qu’ils ont à porter, pour toutes leurs fonctions dans la tente d’assignation: les planches du tabernacle, ses barres, ses colonnes, ses bases, ");
INSERT INTO fraLSG_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","les colonnes du parvis formant l’enceinte, leurs bases, leurs pieux, leurs cordages, tous les ustensiles qui en dépendent et tout ce qui est destiné à leur service. Vous désignerez par leurs noms les objets qui sont remis à leurs soins et qu’ils ont à porter. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Telles sont les fonctions des familles des fils de Merari, toutes leurs fonctions dans la tente d’assignation, sous la direction d’Ithamar, fils du sacrificateur Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Moïse, Aaron et les princes de l’assemblée firent le dénombrement des fils des Kehathites, selon leurs familles et selon les maisons de leurs pères, ");
INSERT INTO fraLSG_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","de tous ceux qui, depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, étaient propres à exercer quelque fonction dans la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Ceux dont ils firent le dénombrement, selon leurs familles, furent deux mille sept cent cinquante. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Tels sont ceux des familles des Kehathites dont on fit le dénombrement, tous ceux qui exerçaient des fonctions dans la tente d’assignation; Moïse et Aaron en firent le dénombrement sur l’ordre de l’Éternel par Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Les fils de Guerschon dont on fit le dénombrement, selon leurs familles et selon les maisons de leurs pères, ");
INSERT INTO fraLSG_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui étaient propres à exercer quelque fonction dans la tente d’assignation, ");
INSERT INTO fraLSG_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","ceux dont on fit le dénombrement, selon leurs familles, selon les maisons de leurs pères, furent deux mille six cent trente. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Tels sont ceux des familles des fils de Guerschon dont on fit le dénombrement, tous ceux qui exerçaient des fonctions dans la tente d’assignation; Moïse et Aaron en firent le dénombrement sur l’ordre de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Ceux des familles des fils de Merari dont on fit le dénombrement, selon leurs familles, selon les maisons de leurs pères, ");
INSERT INTO fraLSG_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui étaient propres à exercer quelque fonction dans la tente d’assignation, ");
INSERT INTO fraLSG_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","ceux dont on fit le dénombrement, selon leurs familles, furent trois mille deux cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Tels sont ceux des familles des fils de Merari dont on fit le dénombrement; Moïse et Aaron en firent le dénombrement sur l’ordre de l’Éternel par Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Tous ceux des Lévites dont Moïse, Aaron et les princes d’Israël firent le dénombrement, selon leurs familles et selon les maisons de leurs pères, ");
INSERT INTO fraLSG_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","depuis l’âge de trente ans et au-dessus jusqu’à l’âge de cinquante ans, tous ceux qui étaient propres à exercer quelque fonction et à servir de porteurs dans la tente d’assignation, ");
INSERT INTO fraLSG_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","tous ceux dont on fit le dénombrement furent huit mille cinq cent quatre-vingts. ");
INSERT INTO fraLSG_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","On en fit le dénombrement sur l’ordre de l’Éternel par Moïse, en indiquant à chacun le service qu’il devait faire et ce qu’il devait porter; on en fit le dénombrement selon l’ordre que l’Éternel avait donné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Ordonne aux enfants d’Israël de renvoyer du camp tout lépreux, et quiconque a une gonorrhée ou est souillé par un mort. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Hommes ou femmes, vous les renverrez, vous les renverrez hors du camp, afin qu’ils ne souillent pas le camp au milieu duquel j’ai ma demeure. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Les enfants d’Israël firent ainsi, et ils les renvoyèrent hors du camp; comme l’Éternel l’avait ordonné à Moïse, ainsi firent les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Parle aux enfants d’Israël: Lorsqu’un homme ou une femme péchera contre son prochain en commettant une infidélité à l’égard de l’Éternel, et qu’il se rendra ainsi coupable, ");
INSERT INTO fraLSG_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","il confessera son péché, et il restituera dans son entier l’objet mal acquis, en y ajoutant un cinquième; il le remettra à celui envers qui il s’est rendu coupable. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","S’il n’y a personne qui ait droit à la restitution de l’objet mal acquis, cet objet revient à l’Éternel, au sacrificateur, outre le bélier expiatoire avec lequel on fera l’expiation pour le coupable. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Toute offrande de choses consacrées par les enfants d’Israël appartiendra au sacrificateur à qui elles seront présentées. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Les choses qu’on aura consacrées lui appartiendront, ce qu’on lui aura remis lui appartiendra. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Parle aux enfants d’Israël, et tu leur diras: Si une femme se détourne de son mari, et lui devient infidèle; ");
INSERT INTO fraLSG_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","si un autre a commerce avec elle, et que la chose soit cachée aux yeux de son mari; si elle s’est souillée en secret, sans qu’il y ait de témoin contre elle, et sans qu’elle ait été prise sur le fait; ");
INSERT INTO fraLSG_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","et si le mari est saisi d’un esprit de jalousie et a des soupçons sur sa femme, qui s’est souillée, ou bien s’il est saisi d’un esprit de jalousie et a des soupçons sur sa femme, qui ne s’est point souillée; ");
INSERT INTO fraLSG_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","cet homme amènera sa femme au sacrificateur, et apportera en offrande pour elle un dixième d’épha de farine d’orge; il n’y répandra point d’huile, et n’y mettra point d’encens, car c’est une offrande de jalousie, une offrande de souvenir, qui rappelle une iniquité. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Le sacrificateur la fera approcher, et la fera tenir debout devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Le sacrificateur prendra de l’eau sainte dans un vase de terre; il prendra de la poussière sur le sol du tabernacle, et la mettra dans l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Le sacrificateur fera tenir la femme debout devant l’Éternel; il découvrira la tête de la femme, et lui posera sur les mains l’offrande de souvenir, l’offrande de jalousie; le sacrificateur aura dans sa main les eaux amères qui apportent la malédiction. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Le sacrificateur fera jurer la femme, et lui dira: Si aucun homme n’a couché avec toi, et si, étant sous la puissance de ton mari, tu ne t’en es point détournée pour te souiller, ces eaux amères qui apportent la malédiction ne te seront point funestes. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Mais si, étant sous la puissance de ton mari, tu t’en es détournée et que tu te sois souillée, et si un autre homme que ton mari a couché avec toi, ");
INSERT INTO fraLSG_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","et le sacrificateur fera jurer la femme avec un serment d’imprécation, et lui dira: Que l’Éternel te livre à la malédiction et à l’exécration au milieu de ton peuple, en faisant dessécher ta cuisse et enfler ton ventre, ");
INSERT INTO fraLSG_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","et que ces eaux qui apportent la malédiction entrent dans tes entrailles pour te faire enfler le ventre et dessécher la cuisse! Et la femme dira: Amen! Amen! ");
INSERT INTO fraLSG_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Le sacrificateur écrira ces imprécations dans un livre, puis les effacera avec les eaux amères. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Et il fera boire à la femme les eaux amères qui apportent la malédiction, et les eaux qui apportent la malédiction entreront en elle pour produire l’amertume. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Le sacrificateur prendra des mains de la femme l’offrande de jalousie, il agitera l’offrande de côté et d’autre devant l’Éternel, et il l’offrira sur l’autel; ");
INSERT INTO fraLSG_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","le sacrificateur prendra une poignée de cette offrande comme souvenir, et il la brûlera sur l’autel. C’est après cela qu’il fera boire les eaux à la femme. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Quand il aura fait boire les eaux, il arrivera, si elle s’est souillée et a été infidèle à son mari, que les eaux qui apportent la malédiction entreront en elle pour produire l’amertume; son ventre s’enflera, sa cuisse se desséchera, et cette femme sera en malédiction au milieu de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Mais si la femme ne s’est point souillée et qu’elle soit pure, elle sera reconnue innocente et aura des enfants. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Telle est la loi sur la jalousie, pour le cas où une femme sous la puissance de son mari se détourne et se souille, ");
INSERT INTO fraLSG_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","et pour le cas où un mari saisi d’un esprit de jalousie a des soupçons sur sa femme: le sacrificateur la fera tenir debout devant l’Éternel, et lui appliquera cette loi dans son entier. ");
INSERT INTO fraLSG_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Le mari sera exempt de faute, mais la femme portera la peine de son iniquité. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Parle aux enfants d’Israël, et tu leur diras: Lorsqu’un homme ou une femme se séparera des autres en faisant vœu de naziréat, pour se consacrer à l’Éternel, ");
INSERT INTO fraLSG_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","il s’abstiendra de vin et de boisson enivrante; il ne boira ni vinaigre fait avec du vin, ni vinaigre fait avec une boisson enivrante; il ne boira d’aucune liqueur tirée des raisins, et il ne mangera point de raisins frais ni de raisins secs. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Pendant tout le temps de son naziréat, il ne mangera rien de ce qui provient de la vigne, depuis les pépins jusqu’à la peau du raisin. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Pendant tout le temps de son naziréat, le rasoir ne passera point sur sa tête; jusqu’à l’accomplissement des jours pour lesquels il s’est consacré à l’Éternel, il sera saint, il laissera croître librement ses cheveux. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Pendant tout le temps qu’il a voué à l’Éternel, il ne s’approchera point d’une personne morte; ");
INSERT INTO fraLSG_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","il ne se souillera point à la mort de son père, de sa mère, de son frère ou de sa sœur, car il porte sur sa tête la consécration de son Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Pendant tout le temps de son naziréat, il sera consacré à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Si quelqu’un meurt subitement près de lui, et que sa tête consacrée devienne ainsi souillée, il se rasera la tête le jour de sa purification, il se la rasera le septième jour. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Le huitième jour, il apportera au sacrificateur deux tourterelles ou deux jeunes pigeons, à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Le sacrificateur sacrifiera l’un comme victime expiatoire, et l’autre comme holocauste, et il fera pour lui l’expiation de son péché à l’occasion du mort. Le naziréen sanctifiera ainsi sa tête ce jour-là ");
INSERT INTO fraLSG_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Il consacrera de nouveau à l’Éternel les jours de son naziréat, et il offrira un agneau d’un an en sacrifice de culpabilité; les jours précédents ne seront point comptés, parce que son naziréat a été souillé. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Voici la loi du naziréen. Le jour où il aura accompli le temps de son naziréat, on le fera venir à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Il présentera son offrande à l’Éternel: un agneau d’un an et sans défaut pour l’holocauste, une brebis d’un an et sans défaut pour le sacrifice d’expiation, et un bélier sans défaut pour le sacrifice d’actions de grâces; ");
INSERT INTO fraLSG_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","une corbeille de pains sans levain, de gâteaux de fleur de farine pétris à l’huile, et de galettes sans levain arrosées d’huile, avec l’offrande et la libation ordinaires. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Le sacrificateur présentera ces choses devant l’Éternel, et il offrira sa victime expiatoire et son holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","il offrira le bélier en sacrifice d’actions de grâces à l’Éternel, outre la corbeille de pains sans levain, avec l’offrande et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Le naziréen rasera, à l’entrée de la tente d’assignation, sa tête consacrée; il prendra les cheveux de sa tête consacrée, et il les mettra sur le feu qui est sous le sacrifice d’actions de grâces. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Le sacrificateur prendra l’épaule cuite du bélier, un gâteau sans levain de la corbeille, et une galette sans levain; et il les posera sur les mains du naziréen, après qu’il aura rasé sa tête consacrée. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Le sacrificateur les agitera de côté et d’autre devant l’Éternel: c’est une chose sainte, qui appartient au sacrificateur, avec la poitrine agitée et l’épaule offerte par élévation. Ensuite, le naziréen pourra boire du vin. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Telle est la loi pour celui qui fait vœu de naziréat; telle est son offrande à l’Éternel pour son naziréat, outre ce que lui permettront ses ressources. Il accomplira ce qui est ordonné pour le vœu qu’il a fait, selon la loi de son naziréat. ");
INSERT INTO fraLSG_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Parle à Aaron et à ses fils, et dis: Vous bénirez ainsi les enfants d’Israël, vous leur direz: ");
INSERT INTO fraLSG_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Que l’Éternel te bénisse, et qu’il te garde! ");
INSERT INTO fraLSG_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Que l’Éternel fasse luire sa face sur toi, et qu’il t’accorde sa grâce! ");
INSERT INTO fraLSG_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Que l’Éternel tourne sa face vers toi, et qu’il te donne la paix! ");
INSERT INTO fraLSG_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","C’est ainsi qu’ils mettront mon nom sur les enfants d’Israël, et je les bénirai. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Lorsque Moïse eut achevé de dresser le tabernacle, il l’oignit et le sanctifia avec tous ses ustensiles, de même que l’autel avec tous ses ustensiles; il les oignit et les sanctifia. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Alors les princes d’Israël, chefs des maisons de leurs pères, présentèrent leur offrande: c’étaient les princes des tribus, ceux qui avaient présidé au dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ils amenèrent leur offrande devant l’Éternel: six chars en forme de litières et douze bœufs, soit un char pour deux princes et un bœuf pour chaque prince; et ils les offrirent devant le tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Prends d’eux ces choses, afin de les employer pour le service de la tente d’assignation; tu les donneras aux Lévites, à chacun selon ses fonctions. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Moïse prit les chars et les bœufs, et il les remit aux Lévites. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Il donna deux chars et quatre bœufs aux fils de Guerschon, selon leurs fonctions; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","il donna quatre chars et huit bœufs aux fils de Merari, selon leurs fonctions, sous la conduite d’Ithamar, fils du sacrificateur Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Mais il n’en donna point aux fils de Kehath, parce que, selon leurs fonctions, ils devaient porter les choses saintes sur les épaules. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Les princes présentèrent leur offrande pour la dédicace de l’autel, le jour où on l’oignit; les princes présentèrent leur offrande devant l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","L’Éternel dit à Moïse: Les princes viendront un à un, et à des jours différents, présenter leur offrande pour la dédicace de l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Celui qui présenta son offrande le premier jour fut Nachschon, fils d’Amminadab, de la tribu de Juda. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Il offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande de Nachschon, fils d’Amminadab. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Le second jour, Nethaneel, fils de Tsuar, prince d’Issacar, présenta son offrande. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Il offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande de Nethaneel, fils de Tsuar. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Le troisième jour, le prince des fils de Zabulon, Éliab, fils de Hélon, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande d’Éliab, fils de Hélon. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Le quatrième jour, le prince des fils de Ruben, Élitsur, fils de Schedéur, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande d’Élitsur, fils de Schedéur. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Le cinquième jour, le prince des fils de Siméon, Schelumiel, fils de Tsurischaddaï, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande de Schelumiel, fils de Tsurischaddaï. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Le sixième jour, le prince des fils de Gad, Éliasaph, fils de Déuel, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande d’Éliasaph, fils de Déuel. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Le septième jour, le prince des fils d’Éphraïm, Élischama, fils d’Ammihud, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande d’Élischama, fils d’Ammihud. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Le huitième jour, le prince des fils de Manassé, Gamliel, fils de Pedahtsur, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande de Gamliel, fils de Pedahtsur. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Le neuvième jour, le prince des fils de Benjamin, Abidan, fils de Guideoni, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande d’Abidan, fils de Guideoni. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Le dixième jour, le prince des fils de Dan, Ahiézer, fils d’Ammischaddaï, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande d’Ahiézer, fils d’Ammischaddaï. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Le onzième jour, le prince des fils d’Aser, Paguiel fils d’Ocran, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles, selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande de Paguiel, fils d’Ocran. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Le douzième jour, le prince des fils de Nephthali, Ahira, fils d’Énan, ");
INSERT INTO fraLSG_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","offrit: un plat d’argent du poids de cent trente sicles, un bassin d’argent de soixante-dix sicles selon le sicle du sanctuaire, tous deux pleins de fleur de farine pétrie à l’huile, pour l’offrande; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","une coupe d’or de dix sicles, pleine de parfum; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","un jeune taureau, un bélier, un agneau d’un an, pour l’holocauste; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","un bouc, pour le sacrifice d’expiation; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","et, pour le sacrifice d’actions de grâces, deux bœufs, cinq béliers, cinq boucs, cinq agneaux d’un an. Telle fut l’offrande d’Ahira, fils d’Énan. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Tels furent les dons des princes d’Israël pour la dédicace de l’autel, le jour où on l’oignit. Douze plats d’argent, douze bassins d’argent, douze coupes d’or; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","chaque plat d’argent pesait cent trente sicles, et chaque bassin soixante-dix, ce qui fit pour l’argent de ces ustensiles un total de deux mille quatre cents sicles, selon le sicle du sanctuaire; ");
INSERT INTO fraLSG_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","les douze coupes d’or pleines de parfum, à dix sicles la coupe, selon le sicle du sanctuaire, firent pour l’or des coupes un total de cent vingt sicles. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Total des animaux pour l’holocauste: douze taureaux, douze béliers, douze agneaux d’un an, avec les offrandes ordinaires. Douze boucs, pour le sacrifice d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Total des animaux pour le sacrifice d’actions de grâces: vingt-quatre bœufs, soixante béliers, soixante boucs, soixante agneaux d’un an. Tels furent les dons pour la dédicace de l’autel, après qu’on l’eut oint. ");
INSERT INTO fraLSG_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Lorsque Moïse entrait dans la tente d’assignation pour parler avec l’Éternel, il entendait la voix qui lui parlait du haut du propitiatoire placé sur l’arche du témoignage, entre les deux chérubins. Et il parlait avec l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Parle à Aaron, et tu lui diras: Lorsque tu placeras les lampes sur le chandelier, les sept lampes devront éclairer en face. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaron fit ainsi; il plaça les lampes sur le devant du chandelier, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Le chandelier était d’or battu; jusqu’à son pied, jusqu’à ses fleurs, il était d’or battu; Moïse avait fait le chandelier d’après le modèle que l’Éternel lui avait montré. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Prends les Lévites du milieu des enfants d’Israël, et purifie-les. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Voici comment tu les purifieras. Fais sur eux une aspersion d’eau expiatoire; qu’ils fassent passer le rasoir sur tout leur corps, qu’ils lavent leurs vêtements, et qu’ils se purifient. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Ils prendront ensuite un jeune taureau, avec l’offrande ordinaire de fleur de farine pétrie à l’huile; et tu prendras un autre jeune taureau pour le sacrifice d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Tu feras approcher les Lévites devant la tente d’assignation, et tu convoqueras toute l’assemblée des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Tu feras approcher les Lévites devant l’Éternel; et les enfants d’Israël poseront leurs mains sur les Lévites. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaron fera tourner de côté et d’autre les Lévites devant l’Éternel, comme une offrande de la part des enfants d’Israël; et ils seront consacrés au service de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Les Lévites poseront leurs mains sur la tête des taureaux; et tu offriras l’un en sacrifice d’expiation, et l’autre en holocauste, afin de faire l’expiation pour les Lévites. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Tu feras tenir les Lévites debout devant Aaron et devant ses fils, et tu les feras tourner de côté et d’autre comme une offrande à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Tu sépareras les Lévites du milieu des enfants d’Israël; et les Lévites m’appartiendront. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Après cela, les Lévites viendront faire le service dans la tente d’assignation. C’est ainsi que tu les purifieras, et que tu les feras tourner de côté et d’autre comme une offrande. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Car ils me sont entièrement donnés du milieu des enfants d’Israël: je les ai pris pour moi à la place des premiers-nés, de tous les premiers-nés des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Car tout premier-né des enfants d’Israël m’appartient, tant des hommes que des animaux; le jour où j’ai frappé tous les premiers-nés dans le pays d’Égypte, je me les suis consacrés. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Et j’ai pris les Lévites à la place de tous les premiers-nés des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","J’ai donné les Lévites entièrement à Aaron et à ses fils, du milieu des enfants d’Israël, pour qu’ils fassent le service des enfants d’Israël dans la tente d’assignation, pour qu’ils fassent l’expiation pour les enfants d’Israël, et pour que les enfants d’Israël ne soient frappés d’aucune plaie, en s’approchant du sanctuaire. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Moïse, Aaron et toute l’assemblée des enfants d’Israël, firent à l’égard des Lévites tout ce que l’Éternel avait ordonné à Moïse touchant les Lévites; ainsi firent à leur égard les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Les Lévites se purifièrent, et lavèrent leurs vêtements; Aaron les fit tourner de côté et d’autre comme une offrande devant l’Éternel, et il fit l’expiation pour eux, afin de les purifier. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Après cela, les Lévites vinrent faire leur service dans la tente d’assignation, en présence d’Aaron et de ses fils, selon ce que l’Éternel avait ordonné à Moïse touchant les Lévites; ainsi fut-il fait à leur égard. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Voici ce qui concerne les Lévites. Depuis l’âge de vingt-cinq ans et au-dessus, tout Lévite entrera au service de la tente d’assignation pour y exercer une fonction. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Depuis l’âge de cinquante ans, il sortira de fonction, et ne servira plus. ");
INSERT INTO fraLSG_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Il aidera ses frères dans la tente d’assignation, pour garder ce qui est remis à leurs soins; mais il ne fera plus de service. Tu agiras ainsi à l’égard des Lévites pour ce qui concerne leurs fonctions. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","L’Éternel parla à Moïse, dans le désert de Sinaï, le premier mois de la seconde année après leur sortie du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Il dit: Que les enfants d’Israël célèbrent la Pâque au temps fixé. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Vous la célébrerez au temps fixé, le quatorzième jour de ce mois, entre les deux soirs; vous la célébrerez selon toutes les lois et toutes les ordonnances qui s’y rapportent. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Moïse parla aux enfants d’Israël, afin qu’ils célébrassent la Pâque. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Et ils célébrèrent la Pâque le quatorzième jour du premier mois, entre les deux soirs, dans le désert de Sinaï; les enfants d’Israël se conformèrent à tous les ordres que l’Éternel avait donnés à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Il y eut des hommes qui, se trouvant impurs à cause d’un mort, ne pouvaient pas célébrer la Pâque ce jour-là. Ils se présentèrent le même jour devant Moïse et Aaron; ");
INSERT INTO fraLSG_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","et ces hommes dirent à Moïse: Nous sommes impurs à cause d’un mort; pourquoi serions-nous privés de présenter au temps fixé l’offrande de l’Éternel au milieu des enfants d’Israël? ");
INSERT INTO fraLSG_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Moïse leur dit: Attendez que je sache ce que l’Éternel vous ordonne. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Et l’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Parle aux enfants d’Israël, et dis-leur: Si quelqu’un d’entre vous ou de vos descendants est impur à cause d’un mort, ou est en voyage dans le lointain, il célébrera la Pâque en l’honneur de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","C’est au second mois qu’ils la célébreront, le quatorzième jour, entre les deux soirs; ils la mangeront avec des pains sans levain et des herbes amères. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ils n’en laisseront rien jusqu’au matin, et ils n’en briseront aucun os. Ils la célébreront selon toutes les ordonnances de la Pâque. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Si celui qui est pur et qui n’est pas en voyage s’abstient de célébrer la Pâque, celui-là sera retranché de son peuple; parce qu’il n’a pas présenté l’offrande de l’Éternel au temps fixé, cet homme-là portera la peine de son péché. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Si un étranger en séjour chez vous célèbre la Pâque de l’Éternel, il se conformera aux lois et aux ordonnances de la Pâque. Il y aura une même loi parmi vous, pour l’étranger comme pour l’indigène. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Le jour où le tabernacle fut dressé, la nuée couvrit le tabernacle, la tente d’assignation; et, depuis le soir jusqu’au matin, elle eut sur le tabernacle l’apparence d’un feu. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Il en fut continuellement ainsi: la nuée couvrait le tabernacle, et elle avait de nuit l’apparence d’un feu. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Quand la nuée s’élevait de dessus la tente, les enfants d’Israël partaient; et les enfants d’Israël campaient dans le lieu où s’arrêtait la nuée. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Les enfants d’Israël partaient sur l’ordre de l’Éternel, et ils campaient sur l’ordre de l’Éternel; ils campaient aussi longtemps que la nuée restait sur le tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Quand la nuée restait longtemps sur le tabernacle, les enfants d’Israël obéissaient au commandement de l’Éternel, et ne partaient point. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Quand la nuée restait peu de jours sur le tabernacle, ils campaient sur l’ordre de l’Éternel, et ils partaient sur l’ordre de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Si la nuée s’arrêtait du soir au matin, et s’élevait le matin, ils partaient. Si la nuée s’élevait après un jour et une nuit, ils partaient. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Si la nuée s’arrêtait sur le tabernacle deux jours, ou un mois, ou une année, les enfants d’Israël restaient campés, et ne partaient point; et quand elle s’élevait, ils partaient. ");
INSERT INTO fraLSG_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ils campaient sur l’ordre de l’Éternel, et ils partaient sur l’ordre de l’Éternel; ils obéissaient au commandement de l’Éternel, sur l’ordre de l’Éternel par Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Fais-toi deux trompettes d’argent; tu les feras d’argent battu. Elles te serviront pour la convocation de l’assemblée et pour le départ des camps. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Quand on en sonnera, toute l’assemblée se réunira auprès de toi, à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Si l’on ne sonne que d’une trompette, les princes, les chefs des milliers d’Israël, se réuniront auprès de toi. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Quand vous sonnerez avec éclat, ceux qui campent à l’orient partiront; ");
INSERT INTO fraLSG_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","quand vous sonnerez avec éclat pour la seconde fois, ceux qui campent au midi partiront: on sonnera avec éclat pour leur départ. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Vous sonnerez aussi pour convoquer l’assemblée, mais vous ne sonnerez pas avec éclat. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Les fils d’Aaron, les sacrificateurs, sonneront des trompettes. Ce sera une loi perpétuelle pour vous et pour vos descendants. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Lorsque, dans votre pays, vous irez à la guerre contre l’ennemi qui vous combattra, vous sonnerez des trompettes avec éclat, et vous serez présents au souvenir de l’Éternel, votre Dieu, et vous serez délivrés de vos ennemis. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Dans vos jours de joie, dans vos fêtes, et à vos nouvelles lunes, vous sonnerez des trompettes, en offrant vos holocaustes et vos sacrifices d’actions de grâces, et elles vous mettront en souvenir devant votre Dieu. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Le vingtième jour du second mois de la seconde année, la nuée s’éleva de dessus le tabernacle du témoignage. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Et les enfants d’Israël partirent du désert de Sinaï, selon l’ordre fixé pour leur marche. La nuée s’arrêta dans le désert de Paran. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Ils firent ce premier départ sur l’ordre de l’Éternel par Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","La bannière du camp des fils de Juda partit la première, avec ses corps d’armée. Le corps d’armée de Juda était commandé par Nachschon, fils d’Amminadab; ");
INSERT INTO fraLSG_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","le corps d’armée de la tribu des fils d’Issacar, par Nethaneel, fils de Tsuar; ");
INSERT INTO fraLSG_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","le corps d’armée de la tribu des fils de Zabulon, par Éliab, fils de Hélon. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Le tabernacle fut démonté; et les fils de Guerschon et les fils de Merari partirent, portant le tabernacle. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","La bannière du camp de Ruben partit, avec ses corps d’armée. Le corps d’armée de Ruben était commandé par Élitsur, fils de Schedéur; ");
INSERT INTO fraLSG_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","le corps d’armée de la tribu des fils de Siméon, par Schelumiel, fils de Tsurischaddaï; ");
INSERT INTO fraLSG_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","le corps d’armée de la tribu des fils de Gad, par Éliasaph, fils de Déuel. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Les Kehathites partirent, portant le sanctuaire; et l’on dressait le tabernacle en attendant leur arrivée. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","La bannière du camp des fils d’Éphraïm partit, avec ses corps d’armée. Le corps d’armée d’Éphraïm était commandé par Élischama, fils d’Ammihud; ");
INSERT INTO fraLSG_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","le corps d’armée de la tribu des fils de Manassé, par Gamliel, fils de Pedahtsur; ");
INSERT INTO fraLSG_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","le corps d’armée de la tribu des fils de Benjamin, par Abidan, fils de Guideoni. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","La bannière du camp des fils de Dan partit, avec ses corps d’armée: elle formait l’arrière-garde de tous les camps. Le corps d’armée de Dan était commandé par Ahiézer, fils d’Ammischaddaï; ");
INSERT INTO fraLSG_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","le corps d’armée de la tribu des fils d’Aser, par Paguiel, fils d’Ocran; ");
INSERT INTO fraLSG_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","le corps d’armée de la tribu des fils de Nephthali, par Ahira, fils d’Énan. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Tel fut l’ordre d’après lequel les enfants d’Israël se mirent en marche selon leurs corps d’armée; et c’est ainsi qu’ils partirent. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Moïse dit à Hobab, fils de Réuel, le Madianite, beau-père de Moïse: Nous partons pour le lieu dont l’Éternel a dit: Je vous le donnerai. Viens avec nous, et nous te ferons du bien, car l’Éternel a promis de faire du bien à Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobab lui répondit: Je n’irai point; mais j’irai dans mon pays et dans ma patrie. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Et Moïse dit: Ne nous quitte pas, je te prie; puisque tu connais les lieux où nous campons dans le désert, tu nous serviras de guide. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Et si tu viens avec nous, nous te ferons jouir du bien que l’Éternel nous fera. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Ils partirent de la montagne de l’Éternel, et marchèrent trois jours; l’arche de l’alliance de l’Éternel partit devant eux, et fit une marche de trois jours, pour leur chercher un lieu de repos. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","La nuée de l’Éternel était au-dessus d’eux pendant le jour, lorsqu’ils partaient du camp. ");
INSERT INTO fraLSG_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Quand l’arche partait, Moïse disait: Lève-toi, Éternel! Et que tes ennemis soient dispersés! Que ceux qui te haïssent fuient devant ta face! ");
INSERT INTO fraLSG_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Et quand on la posait, il disait: Reviens, Éternel, aux myriades des milliers d’Israël! ");
INSERT INTO fraLSG_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Le peuple murmura et cela déplut aux oreilles de l’Éternel. Lorsque l’Éternel l’entendit, sa colère s’enflamma; le feu de l’Éternel s’alluma parmi eux, et dévora l’extrémité du camp. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Le peuple cria à Moïse. Moïse pria l’Éternel, et le feu s’arrêta. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","On donna à ce lieu le nom de Tabeéra, parce que le feu de l’Éternel s’était allumé parmi eux. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Le ramassis de gens qui se trouvaient au milieu d’Israël fut saisi de convoitise; et même les enfants d’Israël recommencèrent à pleurer et dirent: Qui nous donnera de la viande à manger? ");
INSERT INTO fraLSG_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nous nous souvenons des poissons que nous mangions en Égypte, et qui ne nous coûtaient rien, des concombres, des melons, des poireaux, des oignons et des aulx. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Maintenant, notre âme est desséchée: plus rien! Nos yeux ne voient que de la manne. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","La manne ressemblait à de la graine de coriandre, et avait l’apparence du bdellium. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Le peuple se dispersait pour la ramasser; il la broyait avec des meules, ou la pilait dans un mortier; il la cuisait au pot, et en faisait des gâteaux. Elle avait le goût d’un gâteau à l’huile. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Quand la rosée descendait la nuit sur le camp, la manne y descendait aussi. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Moïse entendit le peuple qui pleurait, chacun dans sa famille et à l’entrée de sa tente. La colère de l’Éternel s’enflamma fortement. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Moïse fut attristé, et il dit à l’Éternel: Pourquoi affliges-tu ton serviteur, et pourquoi n’ai-je pas trouvé grâce à tes yeux, que tu aies mis sur moi la charge de tout ce peuple? ");
INSERT INTO fraLSG_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Est-ce moi qui ai conçu ce peuple? Est-ce moi qui l’ai enfanté, pour que tu me dises: Porte-le sur ton sein, comme le nourricier porte un enfant, jusqu’au pays que tu as juré à ses pères de lui donner? ");
INSERT INTO fraLSG_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Où prendrai-je de la viande pour donner à tout ce peuple? Car ils pleurent auprès de moi, en disant: Donne-nous de la viande à manger! ");
INSERT INTO fraLSG_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Je ne puis pas, à moi seul, porter tout ce peuple, car il est trop pesant pour moi. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Plutôt que de me traiter ainsi, tue-moi, je te prie, si j’ai trouvé grâce à tes yeux, et que je ne voie pas mon malheur. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","L’Éternel dit à Moïse: Assemble auprès de moi soixante-dix hommes des anciens d’Israël, de ceux que tu connais comme anciens du peuple et ayant autorité sur lui; amène-les à la tente d’assignation, et qu’ils s’y présentent avec toi. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Je descendrai, et là je te parlerai; je prendrai de l’esprit qui est sur toi, et je le mettrai sur eux, afin qu’ils portent avec toi la charge du peuple, et que tu ne la portes pas à toi seul. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Tu diras au peuple: Sanctifiez-vous pour demain, et vous mangerez de la viande, puisque vous avez pleuré aux oreilles de l’Éternel, en disant: Qui nous fera manger de la viande? Car nous étions bien en Égypte. L’Éternel vous donnera de la viande, et vous en mangerez. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Vous en mangerez non pas un jour, ni deux jours, ni cinq jours, ni dix jours, ni vingt jours, ");
INSERT INTO fraLSG_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","mais un mois entier, jusqu’à ce qu’elle vous sorte par les narines et que vous en ayez du dégoût, parce que vous avez rejeté l’Éternel qui est au milieu de vous, et parce que vous avez pleuré devant lui, en disant: Pourquoi donc sommes-nous sortis d’Égypte? ");
INSERT INTO fraLSG_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Moïse dit: Six cent mille hommes de pied forment le peuple au milieu duquel je suis, et tu dis: Je leur donnerai de la viande, et ils en mangeront un mois entier! ");
INSERT INTO fraLSG_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Égorgera-t-on pour eux des brebis et des bœufs, en sorte qu’ils en aient assez? Ou rassemblera-t-on pour eux tous les poissons de la mer, en sorte qu’ils en aient assez? ");
INSERT INTO fraLSG_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","L’Éternel répondit à Moïse: La main de l’Éternel serait-elle trop courte? Tu verras maintenant si ce que je t’ai dit arrivera ou non. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Moïse sortit, et rapporta au peuple les paroles de l’Éternel. Il assembla soixante-dix hommes des anciens du peuple, et les plaça autour de la tente. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","L’Éternel descendit dans la nuée, et parla à Moïse; il prit de l’esprit qui était sur lui, et le mit sur les soixante-dix anciens. Et dès que l’esprit reposa sur eux, ils prophétisèrent; mais ils ne continuèrent pas. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Il y eut deux hommes, l’un appelé Eldad, et l’autre Médad, qui étaient restés dans le camp, et sur lesquels l’esprit reposa; car ils étaient parmi les inscrits, quoiqu’ils ne fussent point allés à la tente; et ils prophétisèrent dans le camp. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Un jeune garçon courut l’annoncer à Moïse, et dit: Eldad et Médad prophétisent dans le camp. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Et Josué, fils de Nun, serviteur de Moïse depuis sa jeunesse, prit la parole et dit: Moïse, mon seigneur, empêche-les! ");
INSERT INTO fraLSG_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Moïse lui répondit: Es-tu jaloux pour moi? Puisse tout le peuple de l’Éternel être composé de prophètes; et veuille l’Éternel mettre son esprit sur eux! ");
INSERT INTO fraLSG_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Et Moïse se retira au camp, lui et les anciens d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","L’Éternel fit souffler de la mer un vent, qui amena des cailles, et les répandit sur le camp, environ une journée de chemin d’un côté et environ une journée de chemin de l’autre côté, autour du camp. Il y en avait près de deux coudées au-dessus de la surface de la terre. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Pendant tout ce jour et toute la nuit, et pendant toute la journée du lendemain, le peuple se leva et ramassa les cailles; celui qui en avait ramassé le moins en avait dix homers. Ils les étendirent pour eux autour du camp. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Comme la chair était encore entre leurs dents sans être mâchée, la colère de l’Éternel s’enflamma contre le peuple, et l’Éternel frappa le peuple d’une très grande plaie. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","On donna à ce lieu le nom de Kibroth-Hattaava, parce qu’on y enterra le peuple que la convoitise avait saisi. ");
INSERT INTO fraLSG_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","De Kibroth-Hattaava le peuple partit pour Hatséroth, et il s’arrêta à Hatséroth. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Marie et Aaron parlèrent contre Moïse au sujet de la femme éthiopienne qu’il avait prise, car il avait pris une femme éthiopienne. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Ils dirent: Est-ce seulement par Moïse que l’Éternel parle? N’est-ce pas aussi par nous qu’il parle? ");
INSERT INTO fraLSG_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Et l’Éternel l’entendit. Or, Moïse était un homme fort patient, plus qu’aucun homme sur la face de la terre. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Soudain l’Éternel dit à Moïse, à Aaron et à Marie: Allez, vous trois, à la tente d’assignation. Et ils y allèrent tous les trois. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","L’Éternel descendit dans la colonne de nuée, et il se tint à l’entrée de la tente. Il appela Aaron et Marie, qui s’avancèrent tous les deux. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Et il dit: Écoutez bien mes paroles! Lorsqu’il y aura parmi vous un prophète, c’est dans une vision que moi, l’Éternel, je me révélerai à lui, c’est dans un songe que je lui parlerai. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Il n’en est pas ainsi de mon serviteur Moïse. Il est fidèle dans toute ma maison. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Je lui parle bouche à bouche, je me révèle à lui sans énigmes, et il voit une représentation de l’Éternel. Pourquoi donc n’avez-vous pas craint de parler contre mon serviteur, contre Moïse? ");
INSERT INTO fraLSG_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","La colère de l’Éternel s’enflamma contre eux. Et il s’en alla. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","La nuée se retira de dessus la tente. Et voici, Marie était frappée d’une lèpre, blanche comme la neige. Aaron se tourna vers Marie; et voici, elle avait la lèpre. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Alors Aaron dit à Moïse: De grâce, mon seigneur, ne nous fais pas porter la peine du péché que nous avons commis en insensés, et dont nous nous sommes rendus coupables! ");
INSERT INTO fraLSG_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Oh! Qu’elle ne soit pas comme l’enfant mort-né, dont la chair est à moitié consumée quand il sort du sein de sa mère! ");
INSERT INTO fraLSG_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Moïse cria à l’Éternel, en disant: O Dieu, je te prie, guéris-la! ");
INSERT INTO fraLSG_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Et l’Éternel dit à Moïse: Si son père lui avait craché au visage, ne serait-elle pas pendant sept jours un objet de honte? Qu’elle soit enfermée sept jours en dehors du camp; après quoi, elle y sera reçue. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Marie fut enfermée sept jours en dehors du camp; et le peuple ne partit point, jusqu’à ce que Marie y fût rentrée. ");
INSERT INTO fraLSG_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Après cela, le peuple partit de Hatséroth, et il campa dans le désert de Paran. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Envoie des hommes pour explorer le pays de Canaan, que je donne aux enfants d’Israël. Tu enverras un homme de chacune des tribus de leurs pères; tous seront des principaux d’entre eux. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Moïse les envoya du désert de Paran, d’après l’ordre de l’Éternel; tous ces hommes étaient chefs des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Voici leurs noms. Pour la tribu de Ruben: Schammua, fils de Zaccur; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","pour la tribu de Siméon: Schaphath, fils de Hori; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","pour la tribu de Juda: Caleb, fils de Jephunné; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","pour la tribu d’Issacar: Jigual, fils de Joseph; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","pour la tribu d’Éphraïm: Hosée, fils de Nun; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","pour la tribu de Benjamin: Palthi, fils de Raphu; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","pour la tribu de Zabulon: Gaddiel, fils de Sodi; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","pour la tribu de Joseph, la tribu de Manassé: Gaddi, fils de Susi; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","pour la tribu de Dan: Ammiel, fils de Guemalli; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","pour la tribu d’Aser: Sethur, fils de Micaël; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","pour la tribu de Nephthali: Nachbi, fils de Vophsi; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","pour la tribu de Gad: Guéuel, fils de Maki. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Tels sont les noms des hommes que Moïse envoya pour explorer le pays. Moïse donna à Hosée, fils de Nun, le nom de Josué. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Moïse les envoya pour explorer le pays de Canaan. Il leur dit: Montez ici, par le midi; et vous monterez sur la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Vous verrez le pays, ce qu’il est, et le peuple qui l’habite, s’il est fort ou faible, s’il est en petit ou en grand nombre; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","ce qu’est le pays où il habite, s’il est bon ou mauvais; ce que sont les villes où il habite, si elles sont ouvertes ou fortifiées; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ce qu’est le terrain, s’il est gras ou maigre, s’il y a des arbres ou s’il n’y en a point. Ayez bon courage, et prenez des fruits du pays. C’était le temps des premiers raisins. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ils montèrent, et ils explorèrent le pays, depuis le désert de Tsin jusqu’à Rehob, sur le chemin de Hamath. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Ils montèrent, par le midi, et ils allèrent jusqu’à Hébron, où étaient Ahiman, Schéschaï et Talmaï, enfants d’Anak. Hébron avait été bâtie sept ans avant Tsoan en Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Ils arrivèrent jusqu’à la vallée d’Eschcol, où ils coupèrent une branche de vigne avec une grappe de raisin, qu’ils portèrent à deux au moyen d’une perche; ils prirent aussi des grenades et des figues. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","On donna à ce lieu le nom de vallée d’Eschcol, à cause de la grappe que les enfants d’Israël y coupèrent. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ils furent de retour de l’exploration du pays au bout de quarante jours. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","A leur arrivée, ils se rendirent auprès de Moïse et d’Aaron, et de toute l’assemblée des enfants d’Israël, à Kadès dans le désert de Paran. Ils leur firent un rapport, ainsi qu’à toute l’assemblée, et ils leur montrèrent les fruits du pays. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Voici ce qu’ils racontèrent à Moïse: Nous sommes allés dans le pays où tu nous as envoyés. A la vérité, c’est un pays où coulent le lait et le miel, et en voici les fruits. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Mais le peuple qui habite ce pays est puissant, les villes sont fortifiées, très grandes; nous y avons vu des enfants d’Anak. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Les Amalécites habitent la contrée du midi; les Héthiens, les Jébusiens et les Amoréens habitent la montagne; et les Cananéens habitent près de la mer et le long du Jourdain. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Caleb fit taire le peuple, qui murmurait contre Moïse. Il dit: Montons, emparons-nous du pays, nous y serons vainqueurs! ");
INSERT INTO fraLSG_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Mais les hommes qui y étaient allés avec lui dirent: Nous ne pouvons pas monter contre ce peuple, car il est plus fort que nous. ");
INSERT INTO fraLSG_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Et ils décrièrent devant les enfants d’Israël le pays qu’ils avaient exploré. Ils dirent: Le pays que nous avons parcouru, pour l’explorer, est un pays qui dévore ses habitants; tous ceux que nous y avons vus sont des hommes d’une haute taille; ");
INSERT INTO fraLSG_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","et nous y avons vu les géants, enfants d’Anak, de la race des géants: nous étions à nos yeux et aux leurs comme des sauterelles. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Toute l’assemblée éleva la voix et poussa des cris, et le peuple pleura pendant la nuit. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Tous les enfants d’Israël murmurèrent contre Moïse et Aaron, et toute l’assemblée leur dit: Que ne sommes-nous morts dans le pays d’Égypte, ou que ne sommes-nous morts dans ce désert! ");
INSERT INTO fraLSG_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Pourquoi l’Éternel nous fait-il aller dans ce pays, où nous tomberons par l’épée, où nos femmes et nos petits enfants deviendront une proie? Ne vaut-il pas mieux pour nous retourner en Égypte? ");
INSERT INTO fraLSG_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Et ils se dirent l’un à l’autre: Nommons un chef, et retournons en Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Moïse et Aaron tombèrent sur leur visage, en présence de toute l’assemblée réunie des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Et, parmi ceux qui avaient exploré le pays, Josué, fils de Nun, et Caleb, fils de Jephunné, déchirèrent leurs vêtements, ");
INSERT INTO fraLSG_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","et parlèrent ainsi à toute l’assemblée des enfants d’Israël: Le pays que nous avons parcouru, pour l’explorer, est un pays très bon, excellent. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Si l’Éternel nous est favorable, il nous mènera dans ce pays, et nous le donnera: c’est un pays où coulent le lait et le miel. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Seulement, ne soyez point rebelles contre l’Éternel, et ne craignez point les gens de ce pays, car ils nous serviront de pâture, ils n’ont plus d’ombrage pour les couvrir, l’Éternel est avec nous, ne les craignez point! ");
INSERT INTO fraLSG_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Toute l’assemblée parlait de les lapider, lorsque la gloire de l’Éternel apparut sur la tente d’assignation, devant tous les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Et l’Éternel dit à Moïse: Jusqu’à quand ce peuple me méprisera-t-il? Jusqu’à quand ne croira-t-il pas en moi, malgré tous les prodiges que j’ai faits au milieu de lui? ");
INSERT INTO fraLSG_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Je le frapperai par la peste, et je le détruirai; mais je ferai de toi une nation plus grande et plus puissante que lui. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Moïse dit à l’Éternel: Les Égyptiens l’apprendront, eux du milieu desquels tu as fait monter ce peuple par ta puissance, ");
INSERT INTO fraLSG_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","et ils le diront aux habitants de ce pays. Ils savaient que toi, l’Éternel, tu es au milieu de ce peuple; que tu apparais visiblement, toi, l’Éternel; que ta nuée se tient sur lui; que tu marches devant lui le jour dans une colonne de nuée, et la nuit dans une colonne de feu. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Si tu fais mourir ce peuple comme un seul homme, les nations qui ont entendu parler de toi diront: ");
INSERT INTO fraLSG_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","L’Éternel n’avait pas le pouvoir de mener ce peuple dans le pays qu’il avait juré de lui donner: c’est pour cela qu’il l’a égorgé dans le désert. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Maintenant, que la puissance du Seigneur se montre dans sa grandeur, comme tu l’as déclaré en disant: ");
INSERT INTO fraLSG_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","L’Éternel est lent à la colère et riche en bonté, il pardonne l’iniquité et la rébellion; mais il ne tient point le coupable pour innocent, et il punit l’iniquité des pères sur les enfants jusqu’à la troisième et la quatrième génération. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Pardonne l’iniquité de ce peuple, selon la grandeur de ta miséricorde, comme tu as pardonné à ce peuple depuis l’Égypte jusqu’ici. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Et l’Éternel dit: Je pardonne, comme tu l’as demandé. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mais, je suis vivant! Et la gloire de l’Éternel remplira toute la terre. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Tous ceux qui ont vu ma gloire, et les prodiges que j’ai faits en Égypte et dans le désert, qui m’ont tenté déjà dix fois, et qui n’ont point écouté ma voix, ");
INSERT INTO fraLSG_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","tous ceux-là ne verront point le pays que j’ai juré à leurs pères de leur donner, tous ceux qui m’ont méprisé ne le verront point. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Et parce que mon serviteur Caleb a été animé d’un autre esprit, et qu’il a pleinement suivi ma voie, je le ferai entrer dans le pays où il est allé, et ses descendants le posséderont. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Les Amalécites et les Cananéens habitent la vallée: demain, tournez-vous, et partez pour le désert, dans la direction de la mer Rouge. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","L’Éternel parla à Moïse et à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Jusqu’à quand laisserai-je cette méchante assemblée murmurer contre moi? J’ai entendu les murmures des enfants d’Israël qui murmuraient contre moi. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Dis-leur: Je suis vivant! Dit l’Éternel, je vous ferai ainsi que vous avez parlé à mes oreilles. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Vos cadavres tomberont dans ce désert. Vous tous, dont on a fait le dénombrement, en vous comptant depuis l’âge de vingt ans et au-dessus, et qui avez murmuré contre moi, ");
INSERT INTO fraLSG_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","vous n’entrerez point dans le pays que j’avais juré de vous faire habiter, excepté Caleb, fils de Jephunné, et Josué, fils de Nun. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Et vos petits enfants, dont vous avez dit: Ils deviendront une proie! Je les y ferai entrer, et ils connaîtront le pays que vous avez dédaigné. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Vos cadavres, à vous, tomberont dans le désert; ");
INSERT INTO fraLSG_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","et vos enfants paîtront quarante années dans le désert, et porteront la peine de vos infidélités, jusqu’à ce que vos cadavres soient tous tombés dans le désert. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","De même que vous avez mis quarante jours à explorer le pays, vous porterez la peine de vos iniquités quarante années, une année pour chaque jour; et vous saurez ce que c’est que d’être privé de ma présence. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Moi, l’Éternel, j’ai parlé! Et c’est ainsi que je traiterai cette méchante assemblée qui s’est réunie contre moi; ils seront consumés dans ce désert, ils y mourront. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Les hommes que Moïse avait envoyés pour explorer le pays, et qui, à leur retour, avaient fait murmurer contre lui toute l’assemblée, en décriant le pays; ");
INSERT INTO fraLSG_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ces hommes, qui avaient décrié le pays, moururent frappés d’une plaie devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Josué, fils de Nun, et Caleb, fils de Jephunné, restèrent seuls vivants parmi ces hommes qui étaient allés pour explorer le pays. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Moïse rapporta ces choses à tous les enfants d’Israël, et le peuple fut dans une grande désolation. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Ils se levèrent de bon matin, et montèrent au sommet de la montagne, en disant: Nous voici! Nous monterons au lieu dont a parlé l’Éternel, car nous avons péché. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Moïse dit: Pourquoi transgressez-vous l’ordre de l’Éternel? Cela ne réussira point. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ne montez pas! Car l’Éternel n’est pas au milieu de vous. Ne vous faites pas battre par vos ennemis. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Car les Amalécites et les Cananéens sont là devant vous, et vous tomberiez par l’épée. Parce que vous vous êtes détournés de l’Éternel, l’Éternel ne sera point avec vous. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ils s’obstinèrent à monter au sommet de la montagne; mais l’arche de l’alliance et Moïse ne sortirent point du milieu du camp. ");
INSERT INTO fraLSG_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Alors descendirent les Amalécites et les Cananéens qui habitaient cette montagne; ils les battirent, et les taillèrent en pièces jusqu’à Horma. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Parle aux enfants d’Israël, et dis-leur: Quand vous serez entrés dans le pays que je vous donne pour y établir vos demeures, ");
INSERT INTO fraLSG_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","et que vous offrirez à l’Éternel un sacrifice consumé par le feu, soit un holocauste, soit un sacrifice en accomplissement d’un vœu ou en offrande volontaire, ou bien dans vos fêtes, pour produire avec votre gros ou votre menu bétail une agréable odeur à l’Éternel, ");
INSERT INTO fraLSG_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","celui qui fera son offrande à l’Éternel présentera en offrande un dixième de fleur de farine pétrie dans un quart de hin d’huile, ");
INSERT INTO fraLSG_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","et tu feras une libation d’un quart de hin de vin, avec l’holocauste ou le sacrifice, pour chaque agneau. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Pour un bélier, tu présenteras en offrande deux dixièmes de fleur de farine pétrie dans un tiers de hin d’huile, ");
INSERT INTO fraLSG_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","et tu feras une libation d’un tiers de hin de vin, comme offrande d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Si tu offres un veau, soit comme holocauste, soit comme sacrifice en accomplissement d’un vœu, ou comme sacrifice d’actions de grâces à l’Éternel, ");
INSERT INTO fraLSG_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","on présentera en offrande, avec le veau, trois dixièmes de fleur de farine pétrie dans un demi-hin d’huile, ");
INSERT INTO fraLSG_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","et tu feras une libation d’un demi-hin de vin: c’est un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","On fera ainsi pour chaque bœuf, pour chaque bélier, pour chaque petit des brebis ou des chèvres. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Suivant le nombre des victimes, vous ferez ainsi pour chacune, d’après leur nombre. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Tout indigène fera ces choses ainsi, lorsqu’il offrira un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Si un étranger séjournant chez vous, ou se trouvant à l’avenir au milieu de vous, offre un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel, il l’offrira de la même manière que vous. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Il y aura une seule loi pour toute l’assemblée, pour vous et pour l’étranger en séjour au milieu de vous; ce sera une loi perpétuelle parmi vos descendants: il en sera de l’étranger comme de vous, devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Il y aura une seule loi et une seule ordonnance pour vous et pour l’étranger en séjour parmi vous. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Parle aux enfants d’Israël, et dis-leur: Quand vous serez arrivés dans le pays où je vous ferai entrer, ");
INSERT INTO fraLSG_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","et que vous mangerez du pain de ce pays, vous prélèverez une offrande pour l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Vous présenterez par élévation un gâteau, les prémices de votre pâte; vous le présenterez comme l’offrande qu’on prélève de l’aire. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Vous prélèverez pour l’Éternel une offrande des prémices de votre pâte, dans les temps à venir. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Si vous péchez involontairement, en n’observant pas tous ces commandements que l’Éternel a fait connaître à Moïse, ");
INSERT INTO fraLSG_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","tout ce que l’Éternel vous a ordonné par Moïse, depuis le jour où l’Éternel a donné des commandements et plus tard dans les temps à venir; ");
INSERT INTO fraLSG_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","si l’on a péché involontairement, sans que l’assemblée s’en soit aperçue, toute l’assemblée offrira un jeune taureau en holocauste d’une agréable odeur à l’Éternel, avec l’offrande et la libation, d’après les règles établies; elle offrira encore un bouc en sacrifice d’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Le sacrificateur fera l’expiation pour toute l’assemblée des enfants d’Israël, et il leur sera pardonné; car ils ont péché involontairement, et ils ont apporté leur offrande, un sacrifice consumé par le feu en l’honneur de l’Éternel et une victime expiatoire devant l’Éternel, à cause du péché qu’ils ont involontairement commis. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Il sera pardonné à toute l’assemblée des enfants d’Israël et à l’étranger en séjour au milieu d’eux, car c’est involontairement que tout le peuple a péché. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Si c’est une seule personne qui a péché involontairement, elle offrira une chèvre d’un an en sacrifice pour le péché. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Le sacrificateur fera l’expiation pour la personne qui a péché involontairement devant l’Éternel: quand il aura fait l’expiation pour elle, il lui sera pardonné. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Pour l’indigène parmi les enfants d’Israël et pour l’étranger en séjour au milieu d’eux, il y aura pour vous une même loi, quand on péchera involontairement. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Mais si quelqu’un, indigène ou étranger, agit la main levée, il outrage l’Éternel; celui-là sera retranché du milieu de son peuple. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Il a méprisé la parole de l’Éternel, et il a violé son commandement: celui-là sera retranché, il portera la peine de son iniquité. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Comme les enfants d’Israël étaient dans le désert, on trouva un homme qui ramassait du bois le jour du sabbat. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Ceux qui l’avaient trouvé ramassant du bois l’amenèrent à Moïse, à Aaron, et à toute l’assemblée. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","On le mit en prison, car ce qu’on devait lui faire n’avait pas été déclaré. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","L’Éternel dit à Moïse: Cet homme sera puni de mort, toute l’assemblée le lapidera hors du camp. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Toute l’assemblée le fit sortir du camp et le lapida, et il mourut, comme l’Éternel l’avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","L’Éternel dit à Moïse: ");
INSERT INTO fraLSG_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Parle aux enfants d’Israël, et dis-leur qu’ils se fassent, de génération en génération, une frange au bord de leurs vêtements, et qu’ils mettent un cordon bleu sur cette frange du bord de leurs vêtements. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Quand vous aurez cette frange, vous la regarderez, et vous vous souviendrez de tous les commandements de l’Éternel pour les mettre en pratique, et vous ne suivrez pas les désirs de vos cœurs et de vos yeux pour vous laisser entraîner à l’infidélité. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Vous vous souviendrez ainsi de mes commandements, vous les mettrez en pratique, et vous serez saints pour votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Je suis l’Éternel, votre Dieu, qui vous ai fait sortir du pays d’Égypte, pour être votre Dieu. Je suis l’Éternel, votre Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Koré, fils de Jitsehar, fils de Kehath, fils de Lévi, se révolta avec Dathan et Abiram, fils d’Éliab, et On, fils de Péleth, tous trois fils de Ruben. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Ils se soulevèrent contre Moïse, avec deux cent cinquante hommes des enfants d’Israël, des principaux de l’assemblée, de ceux que l’on convoquait à l’assemblée, et qui étaient des gens de renom. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Ils s’assemblèrent contre Moïse et Aaron, et leur dirent: C’en est assez! Car toute l’assemblée, tous sont saints, et l’Éternel est au milieu d’eux. Pourquoi vous élevez-vous au-dessus de l’assemblée de l’Éternel? ");
INSERT INTO fraLSG_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Quand Moïse eut entendu cela, il tomba sur son visage. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Il parla à Koré et à toute sa troupe, en disant: Demain, l’Éternel fera connaître qui est à lui et qui est saint, et il le fera approcher de lui; il fera approcher de lui celui qu’il choisira. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Faites ceci. Prenez des brasiers, Koré et toute sa troupe. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Demain, mettez-y du feu, et posez-y du parfum devant l’Éternel; celui que l’Éternel choisira, c’est celui-là qui sera saint. C’en est assez, enfants de Lévi! ");
INSERT INTO fraLSG_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Moïse dit à Koré: Écoutez donc, enfants de Lévi: ");
INSERT INTO fraLSG_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Est-ce trop peu pour vous que le Dieu d’Israël vous ait choisis dans l’assemblée d’Israël, en vous faisant approcher de lui, afin que vous soyez employés au service du tabernacle de l’Éternel, et que vous vous présentiez devant l’assemblée pour la servir? ");
INSERT INTO fraLSG_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Il vous a fait approcher de lui, toi, et tous tes frères, les enfants de Lévi, et vous voulez encore le sacerdoce! ");
INSERT INTO fraLSG_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","C’est à cause de cela que toi et toute ta troupe, vous vous assemblez contre l’Éternel! Car qui est Aaron, pour que vous murmuriez contre lui? ");
INSERT INTO fraLSG_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Moïse envoya appeler Dathan et Abiram, fils d’Éliab. Mais ils dirent: Nous ne monterons pas. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","N’est-ce pas assez que tu nous aies fait sortir d’un pays où coulent le lait et le miel pour nous faire mourir au désert, sans que tu continues à dominer sur nous? ");
INSERT INTO fraLSG_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Et ce n’est pas dans un pays où coulent le lait et le miel que tu nous as menés, ce ne sont pas des champs et des vignes que tu nous as donnés en possession. Penses-tu crever les yeux de ces gens? Nous ne monterons pas. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Moïse fut très irrité, et il dit à l’Éternel: N’aie point égard à leur offrande. Je ne leur ai pas même pris un âne, et je n’ai fait de mal à aucun d’eux. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Moïse dit à Koré: Toi et toute ta troupe, trouvez-vous demain devant l’Éternel, toi et eux, avec Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Prenez chacun votre brasier, mettez-y du parfum, et présentez devant l’Éternel chacun votre brasier: il y aura deux cent cinquante brasiers; toi et Aaron, vous prendrez aussi chacun votre brasier. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ils prirent chacun leur brasier, y mirent du feu et y posèrent du parfum, et ils se tinrent à l’entrée de la tente d’assignation, avec Moïse et Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Et Koré convoqua toute l’assemblée contre Moïse et Aaron, à l’entrée de la tente d’assignation. Alors la gloire de l’Éternel apparut à toute l’assemblée. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Et l’Éternel parla à Moïse et à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Séparez-vous du milieu de cette assemblée, et je les consumerai en un seul instant. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Ils tombèrent sur leur visage, et dirent: O Dieu, Dieu des esprits de toute chair! Un seul homme a péché, et tu t’irriterais contre toute l’assemblée? ");
INSERT INTO fraLSG_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Parle à l’assemblée, et dis: Retirez-vous de toutes parts loin de la demeure de Koré, de Dathan et d’Abiram. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Moïse se leva, et alla vers Dathan et Abiram; et les anciens d’Israël le suivirent. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Il parla à l’assemblée, et dit: Éloignez-vous des tentes de ces méchants hommes, et ne touchez à rien de ce qui leur appartient, de peur que vous ne périssiez en même temps qu’ils seront punis pour tous leurs péchés. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ils se retirèrent de toutes parts loin de la demeure de Koré, de Dathan et d’Abiram. Dathan et Abiram sortirent, et se tinrent à l’entrée de leurs tentes, avec leurs femmes, leurs fils et leurs petits-enfants. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Moïse dit: A ceci vous connaîtrez que l’Éternel m’a envoyé pour faire toutes ces choses, et que je n’agis pas de moi-même. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Si ces gens meurent comme tous les hommes meurent, s’ils subissent le sort commun à tous les hommes, ce n’est pas l’Éternel qui m’a envoyé; ");
INSERT INTO fraLSG_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","mais si l’Éternel fait une chose inouïe, si la terre ouvre sa bouche pour les engloutir avec tout ce qui leur appartient, et qu’ils descendent vivants dans le séjour des morts, vous saurez alors que ces gens ont méprisé l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Comme il achevait de prononcer toutes ces paroles, la terre qui était sous eux se fendit. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","La terre ouvrit sa bouche, et les engloutit, eux et leurs maisons, avec tous les gens de Koré et tous leurs biens. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ils descendirent vivants dans le séjour des morts, eux et tout ce qui leur appartenait; la terre les recouvrit, et ils disparurent au milieu de l’assemblée. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Tout Israël, qui était autour d’eux, s’enfuit à leur cri; car ils disaient: Fuyons, de peur que la terre ne nous engloutisse! ");
INSERT INTO fraLSG_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Un feu sortit d’auprès de l’Éternel, et consuma les deux cent cinquante hommes qui offraient le parfum. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Dis à Éléazar, fils du sacrificateur Aaron, de retirer de l’incendie les brasiers et d’en répandre au loin le feu, car ils sont sanctifiés. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Avec les brasiers de ces gens qui ont péché au péril de leur vie, que l’on fasse des lames étendues dont on couvrira l’autel. Puisqu’ils ont été présentés devant l’Éternel et qu’ils sont sanctifiés, ils serviront de souvenir aux enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Le sacrificateur Éléazar prit les brasiers d’airain qu’avaient présentés les victimes de l’incendie, et il en fit des lames pour couvrir l’autel. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","C’est un souvenir pour les enfants d’Israël, afin qu’aucun étranger à la race d’Aaron ne s’approche pour offrir du parfum devant l’Éternel et ne soit comme Koré et comme sa troupe, selon ce que l’Éternel avait déclaré par Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Dès le lendemain, toute l’assemblée des enfants d’Israël murmura contre Moïse et Aaron, en disant: Vous avez fait mourir le peuple de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Comme l’assemblée se formait contre Moïse et Aaron, et comme ils tournaient les regards vers la tente d’assignation, voici, la nuée la couvrit, et la gloire de l’Éternel apparut. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Moïse et Aaron arrivèrent devant la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Et l’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Retirez-vous du milieu de cette assemblée, et je les consumerai en un instant. Ils tombèrent sur leur visage; ");
INSERT INTO fraLSG_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","et Moïse dit à Aaron: Prends le brasier, mets-y du feu de dessus l’autel, poses-y du parfum, va promptement vers l’assemblée, et fais pour eux l’expiation; car la colère de l’Éternel a éclaté, la plaie a commencé. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aaron prit le brasier, comme Moïse avait dit, et courut au milieu de l’assemblée; et voici, la plaie avait commencé parmi le peuple. Il offrit le parfum, et il fit l’expiation pour le peuple. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Il se plaça entre les morts et les vivants, et la plaie fut arrêtée. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Il y eut quatorze mille sept cents personnes qui moururent de cette plaie, outre ceux qui étaient morts à cause de Koré. ");
INSERT INTO fraLSG_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aaron retourna auprès de Moïse, à l’entrée de la tente d’assignation. La plaie était arrêtée. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Parle aux enfants d’Israël, et prends d’eux une verge selon les maisons de leurs pères, soit douze verges de la part de tous leurs princes selon les maisons de leurs pères. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Tu écriras le nom de chacun sur sa verge, et tu écriras le nom d’Aaron sur la verge de Lévi; car il y aura une verge pour chaque chef des maisons de leurs pères. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Tu les déposeras dans la tente d’assignation, devant le témoignage, où je me rencontre avec vous. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","L’homme que je choisirai sera celui dont la verge fleurira, et je ferai cesser de devant moi les murmures que profèrent contre vous les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Moïse parla aux enfants d’Israël; et tous leurs princes lui donnèrent une verge, chaque prince une verge, selon les maisons de leurs pères, soit douze verges; la verge d’Aaron était au milieu des leurs. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Moïse déposa les verges devant l’Éternel, dans la tente du témoignage. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Le lendemain, lorsque Moïse entra dans la tente du témoignage, voici, la verge d’Aaron, pour la maison de Lévi, avait fleuri, elle avait poussé des boutons, produit des fleurs, et mûri des amandes. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Moïse ôta de devant l’Éternel toutes les verges, et les porta à tous les enfants d’Israël, afin qu’ils les vissent et qu’ils prissent chacun leur verge. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","L’Éternel dit à Moïse: Reporte la verge d’Aaron devant le témoignage, pour être conservée comme un signe pour les enfants de rébellion, afin que tu fasses cesser de devant moi leurs murmures et qu’ils ne meurent point. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Moïse fit ainsi; il se conforma à l’ordre que l’Éternel lui avait donné. ");
INSERT INTO fraLSG_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Les enfants d’Israël dirent à Moïse: Voici, nous expirons, nous périssons, nous périssons tous! ");
INSERT INTO fraLSG_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Quiconque s’approche du tabernacle de l’Éternel, meurt. Nous faudra-t-il tous expirer? ");
INSERT INTO fraLSG_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","L’Éternel dit à Aaron: Toi et tes fils, et la maison de ton père avec toi, vous porterez la peine des iniquités commises dans le sanctuaire; toi et tes fils avec toi, vous porterez la peine des iniquités commises dans l’exercice de votre sacerdoce. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Fais aussi approcher de toi tes frères, la tribu de Lévi, la tribu de ton père, afin qu’ils te soient attachés et qu’ils te servent, lorsque toi, et tes fils avec toi, vous serez devant la tente du témoignage. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ils observeront ce que tu leur ordonneras et ce qui concerne toute la tente; mais ils ne s’approcheront ni des ustensiles du sanctuaire, ni de l’autel, de peur que vous ne mouriez, eux et vous. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Ils te seront attachés, et ils observeront ce qui concerne la tente d’assignation pour tout le service de la tente. Aucun étranger n’approchera de vous. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Vous observerez ce qui concerne le sanctuaire et l’autel, afin qu’il n’y ait plus de colère contre les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Voici, j’ai pris vos frères les Lévites du milieu des enfants d’Israël: donnés à l’Éternel, ils vous sont remis en don pour faire le service de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Toi, et tes fils avec toi, vous observerez les fonctions de votre sacerdoce pour tout ce qui concerne l’autel et pour ce qui est en dedans du voile: c’est le service que vous ferez. Je vous accorde en pur don l’exercice du sacerdoce. L’étranger qui approchera sera mis à mort. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","L’Éternel dit à Aaron: Voici, de toutes les choses que consacrent les enfants d’Israël, je te donne celles qui me sont offertes par élévation; je te les donne, à toi et à tes fils, comme droit d’onction, par une loi perpétuelle. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Voici ce qui t’appartiendra parmi les choses très saintes qui ne sont pas consumées par le feu: toutes leurs offrandes, tous leurs dons, tous leurs sacrifices d’expiation, et tous les sacrifices de culpabilité qu’ils m’offriront; ces choses très saintes seront pour toi et pour tes fils. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Vous les mangerez dans un lieu très saint; tout mâle en mangera; vous les regarderez comme saintes. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Voici encore ce qui t’appartiendra: tous les dons que les enfants d’Israël présenteront par élévation et en les agitant de côté et d’autre, je te les donne à toi, à tes fils et à tes filles avec toi, par une loi perpétuelle. Quiconque sera pur dans ta maison en mangera. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Je te donne les prémices qu’ils offriront à l’Éternel: tout ce qu’il y aura de meilleur en huile, tout ce qu’il y aura de meilleur en moût et en blé. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Les premiers produits de leur terre, qu’ils apporteront à l’Éternel, seront pour toi. Quiconque sera pur dans ta maison en mangera. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Tout ce qui sera dévoué par interdit en Israël sera pour toi. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Tout premier-né de toute chair, qu’ils offriront à l’Éternel, tant des hommes que des animaux, sera pour toi. Seulement, tu feras racheter le premier-né de l’homme, et tu feras racheter le premier-né d’un animal impur. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Tu les feras racheter dès l’âge d’un mois, d’après ton estimation, au prix de cinq sicles d’argent, selon le sicle du sanctuaire, qui est de vingt guéras. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Mais tu ne feras point racheter le premier-né du bœuf, ni le premier-né de la brebis, ni le premier-né de la chèvre: ce sont des choses saintes. Tu répandras leur sang sur l’autel, et tu brûleras leur graisse: ce sera un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Leur chair sera pour toi, comme la poitrine qu’on agite de côté et d’autre et comme l’épaule droite. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Je te donne, à toi, à tes fils et à tes filles avec toi, par une loi perpétuelle, toutes les offrandes saintes que les enfants d’Israël présenteront à l’Éternel par élévation. C’est une alliance inviolable et à perpétuité devant l’Éternel, pour toi et pour ta postérité avec toi. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","L’Éternel dit à Aaron: Tu ne posséderas rien dans leur pays, et il n’y aura point de part pour toi au milieu d’eux; c’est moi qui suis ta part et ta possession, au milieu des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Je donne comme possession aux fils de Lévi toute dîme en Israël, pour le service qu’ils font, le service de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Les enfants d’Israël n’approcheront plus de la tente d’assignation, de peur qu’ils ne se chargent d’un péché et qu’ils ne meurent. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Les Lévites feront le service de la tente d’assignation, et ils resteront chargés de leurs iniquités. Ils n’auront point de possession au milieu des enfants d’Israël: ce sera une loi perpétuelle parmi vos descendants. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Je donne comme possession aux Lévites les dîmes que les enfants d’Israël présenteront à l’Éternel par élévation; c’est pourquoi je dis à leur égard: Ils n’auront point de possession au milieu des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Tu parleras aux Lévites, et tu leur diras: Lorsque vous recevrez des enfants d’Israël la dîme que je vous donne de leur part comme votre possession, vous en prélèverez une offrande pour l’Éternel, une dîme de la dîme; ");
INSERT INTO fraLSG_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","et votre offrande vous sera comptée comme le blé qu’on prélève de l’aire et comme le moût qu’on prélève de la cuve. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","C’est ainsi que vous prélèverez une offrande pour l’Éternel sur toutes les dîmes que vous recevrez des enfants d’Israël, et vous donnerez au sacrificateur Aaron l’offrande que vous en aurez prélevée pour l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Sur tous les dons qui vous seront faits, vous prélèverez toutes les offrandes pour l’Éternel; sur tout ce qu’il y aura de meilleur, vous prélèverez la portion consacrée. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Tu leur diras: Quand vous en aurez prélevé le meilleur, la dîme sera comptée aux Lévites comme le revenu de l’aire et comme le revenu de la cuve. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Vous la mangerez en un lieu quelconque, vous et votre maison; car c’est votre salaire pour le service que vous faites dans la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Vous ne serez chargés pour cela d’aucun péché, quand vous en aurez prélevé le meilleur, vous ne profanerez point les offrandes saintes des enfants d’Israël, et vous ne mourrez point. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","L’Éternel parla à Moïse et à Aaron, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Voici ce qui est ordonné par la loi que l’Éternel a prescrite, en disant: Parle aux enfants d’Israël, et qu’ils t’amènent une vache rousse, sans tache, sans défaut corporel, et qui n’ait point porté le joug. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Vous la remettrez au sacrificateur Éléazar, qui la fera sortir du camp, et on l’égorgera devant lui. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Le sacrificateur Éléazar prendra du sang de la vache avec le doigt, et il en fera sept fois l’aspersion sur le devant de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","On brûlera la vache sous ses yeux; on brûlera sa peau, sa chair et son sang, avec ses excréments. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Le sacrificateur prendra du bois de cèdre, de l’hysope et du cramoisi, et il les jettera au milieu des flammes qui consumeront la vache. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Le sacrificateur lavera ses vêtements, et lavera son corps dans l’eau; puis il rentrera dans le camp, et sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Celui qui aura brûlé la vache lavera ses vêtements dans l’eau, et lavera son corps dans l’eau; et il sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Un homme pur recueillera la cendre de la vache, et la déposera hors du camp, dans un lieu pur; on la conservera pour l’assemblée des enfants d’Israël, afin d’en faire l’eau de purification. C’est une eau expiatoire. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Celui qui aura recueilli la cendre de la vache lavera ses vêtements, et sera impur jusqu’au soir. Ce sera une loi perpétuelle pour les enfants d’Israël et pour l’étranger en séjour au milieu d’eux. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Celui qui touchera un mort, un corps humain quelconque, sera impur pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Il se purifiera avec cette eau le troisième jour et le septième jour, et il sera pur; mais, s’il ne se purifie pas le troisième jour et le septième jour, il ne sera pas pur. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Celui qui touchera un mort, le corps d’un homme qui sera mort, et qui ne se purifiera pas, souille le tabernacle de l’Éternel; celui-là sera retranché d’Israël. Comme l’eau de purification n’a pas été répandue sur lui, il est impur, et son impureté est encore sur lui. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Voici la loi. Lorsqu’un homme mourra dans une tente, quiconque entrera dans la tente, et quiconque se trouvera dans la tente, sera impur pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Tout vase découvert, sur lequel il n’y aura point de couvercle attaché, sera impur. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Quiconque touchera, dans les champs, un homme tué par l’épée, ou un mort, ou des ossements humains, ou un sépulcre, sera impur pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","On prendra, pour celui qui est impur, de la cendre de la victime expiatoire qui a été brûlée, et on mettra dessus de l’eau vive dans un vase. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Un homme pur prendra de l’hysope, et la trempera dans l’eau; puis il en fera l’aspersion sur la tente, sur tous les ustensiles, sur les personnes qui sont là, sur celui qui a touché des ossements, ou un homme tué, ou un mort, ou un sépulcre. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Celui qui est pur fera l’aspersion sur celui qui est impur, le troisième jour et le septième jour, et il le purifiera le septième jour. Il lavera ses vêtements, et se lavera dans l’eau; et le soir, il sera pur. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Un homme qui sera impur, et qui ne se purifiera pas, sera retranché du milieu de l’assemblée, car il a souillé le sanctuaire de l’Éternel; comme l’eau de purification n’a pas été répandue sur lui, il est impur. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Ce sera pour eux une loi perpétuelle. Celui qui fera l’aspersion de l’eau de purification lavera ses vêtements, et celui qui touchera l’eau de purification sera impur jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Tout ce que touchera celui qui est impur sera souillé, et la personne qui le touchera sera impure jusqu’au soir. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Toute l’assemblée des enfants d’Israël arriva dans le désert de Tsin le premier mois, et le peuple s’arrêta à Kadès. C’est là que mourut Marie, et qu’elle fut enterrée. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Il n’y avait point d’eau pour l’assemblée; et l’on se souleva contre Moïse et Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Le peuple chercha querelle à Moïse. Ils dirent: Que n’avons-nous expiré, quand nos frères expirèrent devant l’Éternel? ");
INSERT INTO fraLSG_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Pourquoi avez-vous fait venir l’assemblée de l’Éternel dans ce désert, pour que nous y mourions, nous et notre bétail? ");
INSERT INTO fraLSG_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Pourquoi nous avez-vous fait monter hors d’Égypte, pour nous amener dans ce méchant lieu? Ce n’est pas un lieu où l’on puisse semer, et il n’y a ni figuier, ni vigne, ni grenadier, ni d’eau à boire. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Moïse et Aaron s’éloignèrent de l’assemblée pour aller à l’entrée de la tente d’assignation. Ils tombèrent sur leur visage; et la gloire de l’Éternel leur apparut. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Prends la verge, et convoque l’assemblée, toi et ton frère Aaron. Vous parlerez en leur présence au rocher, et il donnera ses eaux; tu feras sortir pour eux de l’eau du rocher, et tu abreuveras l’assemblée et leur bétail. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Moïse prit la verge qui était devant l’Éternel, comme l’Éternel le lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Moïse et Aaron convoquèrent l’assemblée en face du rocher. Et Moïse leur dit: Écoutez donc, rebelles! Est-ce de ce rocher que nous vous ferons sortir de l’eau? ");
INSERT INTO fraLSG_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Puis Moïse leva la main et frappa deux fois le rocher avec sa verge. Il sortit de l’eau en abondance. L’assemblée but, et le bétail aussi. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Alors l’Éternel dit à Moïse et à Aaron: Parce que vous n’avez pas cru en moi, pour me sanctifier aux yeux des enfants d’Israël, vous ne ferez point entrer cette assemblée dans le pays que je lui donne. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ce sont les eaux de Meriba, où les enfants d’Israël contestèrent avec l’Éternel, qui fut sanctifié en eux. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","De Kadès, Moïse envoya des messagers au roi d’Édom, pour lui dire: Ainsi parle ton frère Israël: Tu sais toutes les souffrances que nous avons éprouvées. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Nos pères descendirent en Égypte, et nous y demeurâmes longtemps. Mais les Égyptiens nous ont maltraités, nous et nos pères. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Nous avons crié à l’Éternel, et il a entendu notre voix. Il a envoyé un ange, et nous a fait sortir de l’Égypte. Et voici, nous sommes à Kadès, ville à l’extrémité de ton territoire. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Laisse-nous passer par ton pays; nous ne traverserons ni les champs, ni les vignes, et nous ne boirons pas l’eau des puits; nous suivrons la route royale, sans nous détourner à droite ou à gauche, jusqu’à ce que nous ayons franchi ton territoire. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Édom lui dit: Tu ne passeras point chez moi, sinon je sortirai à ta rencontre avec l’épée. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Les enfants d’Israël lui dirent: Nous monterons par la grande route; et, si nous buvons de ton eau, moi et mes troupeaux, j’en paierai le prix; je ne ferai que passer avec mes pieds, pas autre chose. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Il répondit: Tu ne passeras pas! Et Édom sortit à sa rencontre avec un peuple nombreux et à main forte. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Ainsi Édom refusa de donner passage à Israël par son territoire. Et Israël se détourna de lui. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Toute l’assemblée des enfants d’Israël partit de Kadès, et arriva à la montagne de Hor. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","L’Éternel dit à Moïse et à Aaron, vers la montagne de Hor, sur la frontière du pays d’Édom: ");
INSERT INTO fraLSG_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Aaron va être recueilli auprès de son peuple; car il n’entrera point dans le pays que je donne aux enfants d’Israël, parce que vous avez été rebelles à mon ordre, aux eaux de Meriba. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Prends Aaron et son fils Éléazar, et fais-les monter sur la montagne de Hor. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Dépouille Aaron de ses vêtements, et fais-les revêtir à Éléazar, son fils. C’est là qu’Aaron sera recueilli et qu’il mourra. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Moïse fit ce que l’Éternel avait ordonné. Ils montèrent sur la montagne de Hor, aux yeux de toute l’assemblée. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Moïse dépouilla Aaron de ses vêtements, et les fit revêtir à Éléazar, son fils. Aaron mourut là, au sommet de la montagne. Moïse et Éléazar descendirent de la montagne. ");
INSERT INTO fraLSG_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Toute l’assemblée vit qu’Aaron avait expiré, et toute la maison d’Israël pleura Aaron pendant trente jours. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Le roi d’Arad, Cananéen, qui habitait le midi, apprit qu’Israël venait par le chemin d’Atharim. Il combattit Israël, et emmena des prisonniers. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Alors Israël fit un vœu à l’Éternel, et dit: Si tu livres ce peuple entre mes mains, je dévouerai ses villes par interdit. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","L’Éternel entendit la voix d’Israël, et livra les Cananéens. On les dévoua par interdit, eux et leurs villes; et l’on nomma ce lieu Horma. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Ils partirent de la montagne de Hor par le chemin de la mer Rouge, pour contourner le pays d’Édom. Le peuple s’impatienta en route, ");
INSERT INTO fraLSG_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","et parla contre Dieu et contre Moïse: Pourquoi nous avez-vous fait monter hors d’Égypte, pour que nous mourions dans le désert? Car il n’y a point de pain, et il n’y a point d’eau, et notre âme est dégoûtée de cette misérable nourriture. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Alors l’Éternel envoya contre le peuple des serpents brûlants; ils mordirent le peuple, et il mourut beaucoup de gens en Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Le peuple vint à Moïse, et dit: Nous avons péché, car nous avons parlé contre l’Éternel et contre toi. Prie l’Éternel, afin qu’il éloigne de nous ces serpents. Moïse pria pour le peuple. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","L’Éternel dit à Moïse: Fais-toi un serpent brûlant, et place-le sur une perche; quiconque aura été mordu, et le regardera, conservera la vie. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Moïse fit un serpent d’airain, et le plaça sur une perche; et quiconque avait été mordu par un serpent, et regardait le serpent d’airain, conservait la vie. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Les enfants d’Israël partirent, et ils campèrent à Oboth. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ils partirent d’Oboth et ils campèrent à Ijjé-Abarim, dans le désert qui est vis-à-vis de Moab, vers le soleil levant. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","De là ils partirent, et ils campèrent dans la vallée de Zéred. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","De là ils partirent, et ils campèrent de l’autre côté de l’Arnon, qui coule dans le désert en sortant du territoire des Amoréens; car l’Arnon est la frontière de Moab, entre Moab et les Amoréens. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","C’est pourquoi il est dit dans le livre des Guerres de l’Éternel: …Vaheb en Supha, et les torrents de l’Arnon, ");
INSERT INTO fraLSG_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","et le cours des torrents, qui s’étend du côté d’Ar et touche à la frontière de Moab. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","De là ils allèrent à Beer. C’est ce Beer, où l’Éternel dit à Moïse: Rassemble le peuple, et je leur donnerai de l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Alors Israël chanta ce cantique: Monte, puits! Chantez en son honneur! ");
INSERT INTO fraLSG_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Puits, que des princes ont creusé, Que les grands du peuple ont creusé, Avec le sceptre, avec leurs bâtons! ");
INSERT INTO fraLSG_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Du désert ils allèrent à Matthana; de Matthana, à Nahaliel; de Nahaliel, à Bamoth; ");
INSERT INTO fraLSG_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","de Bamoth, à la vallée qui est dans le territoire de Moab, au sommet du Pisga, en regard du désert. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israël envoya des messagers à Sihon, roi des Amoréens, pour lui dire: ");
INSERT INTO fraLSG_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Laisse-moi passer par ton pays; nous n’entrerons ni dans les champs, ni dans les vignes, et nous ne boirons pas l’eau des puits; nous suivrons la route royale, jusqu’à ce que nous ayons franchi ton territoire. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihon n’accorda point à Israël le passage sur son territoire; il rassembla tout son peuple, et sortit à la rencontre d’Israël, dans le désert; il vint à Jahats, et combattit Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israël le frappa du tranchant de l’épée et s’empara de son pays depuis l’Arnon jusqu’au Jabbok, jusqu’à la frontière des enfants d’Ammon; car la frontière des enfants d’Ammon était fortifiée. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israël prit toutes les villes, et s’établit dans toutes les villes des Amoréens, à Hesbon et dans toutes les villes de son ressort. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Car Hesbon était la ville de Sihon, roi des Amoréens; il avait fait la guerre au précédent roi de Moab, et lui avait enlevé tout son pays jusqu’à l’Arnon. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","C’est pourquoi les poètes disent: Venez à Hesbon! Que la ville de Sihon soit rebâtie et fortifiée! ");
INSERT INTO fraLSG_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Car il est sorti un feu de Hesbon, Une flamme de la ville de Sihon; Elle a dévoré Ar-Moab, les habitants des hauteurs de l’Arnon. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Malheur à toi, Moab! Tu es perdu, peuple de Kemosch! Il a fait de ses fils des fuyards, Et il a livré ses filles captives à Sihon, roi des Amoréens. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Nous avons lancé sur eux nos traits: De Hesbon à Dibon tout est détruit; Nous avons étendu nos ravages jusqu’à Nophach, Jusqu’à Médeba. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Israël s’établit dans le pays des Amoréens. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Moïse envoya reconnaître Jaezer; et ils prirent les villes de son ressort, et chassèrent les Amoréens qui y étaient. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Ils changèrent ensuite de direction, et montèrent par le chemin de Basan. Og, roi de Basan, sortit à leur rencontre, avec tout son peuple, pour les combattre à Édréï. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","L’Éternel dit à Moïse: Ne le crains point; car je le livre entre tes mains, lui et tout son peuple, et son pays; tu le traiteras comme tu as traité Sihon, roi des Amoréens, qui habitait à Hesbon. ");
INSERT INTO fraLSG_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Et ils le battirent, lui et ses fils, et tout son peuple, sans en laisser échapper un seul, et ils s’emparèrent de son pays. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Les enfants d’Israël partirent, et ils campèrent dans les plaines de Moab, au-delà du Jourdain, vis-à-vis de Jéricho. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Balak, fils de Tsippor, vit tout ce qu’Israël avait fait aux Amoréens. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Et Moab fut très effrayé en face d’un peuple aussi nombreux, il fut saisi de terreur en face des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Moab dit aux anciens de Madian: Cette multitude va dévorer tout ce qui nous entoure, comme le bœuf broute la verdure des champs. Balak, fils de Tsippor, était alors roi de Moab. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Il envoya des messagers auprès de Balaam, fils de Beor, à Pethor sur le fleuve, dans le pays des fils de son peuple, afin de l’appeler et de lui dire: Voici, un peuple est sorti d’Égypte, il couvre la surface de la terre, et il habite vis-à-vis de moi. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Viens, je te prie, maudis-moi ce peuple, car il est plus puissant que moi; peut-être ainsi pourrai-je le battre et le chasserai-je du pays, car je sais que celui que tu bénis est béni, et que celui que tu maudis est maudit. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Les anciens de Moab et les anciens de Madian partirent, ayant avec eux des présents pour le devin. Ils arrivèrent auprès de Balaam, et lui rapportèrent les paroles de Balak. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam leur dit: Passez ici la nuit, et je vous donnerai réponse, d’après ce que l’Éternel me dira. Et les chefs de Moab restèrent chez Balaam. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Dieu vint à Balaam, et dit: Qui sont ces hommes que tu as chez toi? ");
INSERT INTO fraLSG_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam répondit à Dieu: Balak, fils de Tsippor, roi de Moab, les a envoyés pour me dire: ");
INSERT INTO fraLSG_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Voici, un peuple est sorti d’Égypte, et il couvre la surface de la terre; viens donc, maudis-le; peut-être ainsi pourrai-je le combattre, et le chasserai-je. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Dieu dit à Balaam: Tu n’iras point avec eux; tu ne maudiras point ce peuple, car il est béni. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaam se leva le matin, et il dit aux chefs de Balak: Allez dans votre pays, car l’Éternel refuse de me laisser aller avec vous. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Et les princes de Moab se levèrent, retournèrent auprès de Balak, et dirent: Balaam a refusé de venir avec nous. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balak envoya de nouveau des chefs en plus grand nombre et plus considérés que les précédents. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Ils arrivèrent auprès de Balaam, et lui dirent: Ainsi parle Balak, fils de Tsippor: Que l’on ne t’empêche donc pas de venir vers moi; ");
INSERT INTO fraLSG_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","car je te rendrai beaucoup d’honneurs, et je ferai tout ce que tu me diras; viens, je te prie, maudis-moi ce peuple. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaam répondit et dit aux serviteurs de Balak: Quand Balak me donnerait sa maison pleine d’argent et d’or, je ne pourrais faire aucune chose, ni petite ni grande, contre l’ordre de l’Éternel, mon Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Maintenant, je vous prie, restez ici cette nuit, et je saurai ce que l’Éternel me dira encore. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Dieu vint à Balaam pendant la nuit, et lui dit: Puisque ces hommes sont venus pour t’appeler, lève-toi, va avec eux; mais tu feras ce que je te dirai. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaam se leva le matin, sella son ânesse, et partit avec les chefs de Moab. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","La colère de Dieu s’enflamma, parce qu’il était parti; et l’ange de l’Éternel se plaça sur le chemin, pour lui résister. Balaam était monté sur son ânesse, et ses deux serviteurs étaient avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","L’ânesse vit l’ange de l’Éternel qui se tenait sur le chemin, son épée nue dans la main; elle se détourna du chemin et alla dans les champs. Balaam frappa l’ânesse pour la ramener dans le chemin. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","L’ange de l’Éternel se plaça dans un sentier entre les vignes; il y avait un mur de chaque côté. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","L’ânesse vit l’ange de l’Éternel; elle se serra contre le mur, et pressa le pied de Balaam contre le mur. Balaam la frappa de nouveau. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","L’ange de l’Éternel passa plus loin, et se plaça dans un lieu où il n’y avait point d’espace pour se détourner à droite ou à gauche. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","L’ânesse vit l’ange de l’Éternel, et elle s’abattit sous Balaam. La colère de Balaam s’enflamma, et il frappa l’ânesse avec un bâton. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","L’Éternel ouvrit la bouche de l’ânesse, et elle dit à Balaam: Que t’ai-je fait, pour que tu m’aies frappée déjà trois fois? ");
INSERT INTO fraLSG_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam répondit à l’ânesse: C’est parce que tu t’es moquée de moi; si j’avais une épée dans la main, je te tuerais à l’instant. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","L’ânesse dit à Balaam: Ne suis-je pas ton ânesse, que tu as de tout temps montée jusqu’à ce jour? Ai-je l’habitude de te faire ainsi? Et il répondit: Non. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","L’Éternel ouvrit les yeux de Balaam, et Balaam vit l’ange de l’Éternel qui se tenait sur le chemin, son épée nue dans la main; et il s’inclina, et se prosterna sur son visage. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","L’ange de l’Éternel lui dit: Pourquoi as-tu frappé ton ânesse déjà trois fois? Voici, je suis sorti pour te résister, car c’est un chemin de perdition qui est devant moi. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","L’ânesse m’a vu, et elle s’est détournée devant moi déjà trois fois; si elle ne se fût pas détournée de moi, je t’aurais même tué, et je lui aurais laissé la vie. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam dit à l’ange de l’Éternel: J’ai péché, car je ne savais pas que tu te fusses placé au-devant de moi sur le chemin; et maintenant, si tu me désapprouves, je m’en retournerai. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","L’ange de l’Éternel dit à Balaam: Va avec ces hommes; mais tu ne feras que répéter les paroles que je te dirai. Et Balaam alla avec les chefs de Balak. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balak apprit que Balaam arrivait, et il sortit à sa rencontre jusqu’à la ville de Moab qui est sur la limite de l’Arnon, à l’extrême frontière. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak dit à Balaam: N’ai-je pas envoyé auprès de toi pour t’appeler? Pourquoi n’es-tu pas venu vers moi? Ne puis-je donc pas te traiter avec honneur? ");
INSERT INTO fraLSG_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam dit à Balak: Voici, je suis venu vers toi; maintenant, me sera-t-il permis de dire quoi que ce soit? Je dirai les paroles que Dieu mettra dans ma bouche. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam alla avec Balak, et ils arrivèrent à Kirjath-Hutsoth. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balak sacrifia des bœufs et des brebis, et il en envoya à Balaam et aux chefs qui étaient avec lui. ");
INSERT INTO fraLSG_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Le matin, Balak prit Balaam, et le fit monter à Bamoth-Baal, d’où Balaam vit une partie du peuple. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam dit à Balak: Bâtis-moi ici sept autels, et prépare-moi ici sept taureaux et sept béliers. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak fit ce que Balaam avait dit; et Balak et Balaam offrirent un taureau et un bélier sur chaque autel. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam dit à Balak: Tiens-toi près de ton holocauste, et je m’éloignerai; peut-être que l’Éternel viendra à ma rencontre, et je te dirai ce qu’il me révélera. Et il alla sur un lieu élevé. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Dieu vint au-devant de Balaam, et Balaam lui dit: J’ai dressé sept autels, et j’ai offert un taureau et un bélier sur chaque autel. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","L’Éternel mit des paroles dans la bouche de Balaam, et dit: Retourne vers Balak, et tu parleras ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Il retourna vers lui; et voici, Balak se tenait près de son holocauste, lui et tous les chefs de Moab. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaam prononça son oracle, et dit: Balak m’a fait descendre d’Aram, Le roi de Moab m’a fait descendre des montagnes de l’Orient. Viens, maudis-moi Jacob! Viens, sois irrité contre Israël! ");
INSERT INTO fraLSG_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Comment maudirais-je celui que Dieu n’a point maudit? Comment serais-je irrité quand l’Éternel n’est point irrité? ");
INSERT INTO fraLSG_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Je le vois du sommet des rochers, Je le contemple du haut des collines: C’est un peuple qui a sa demeure à part, Et qui ne fait point partie des nations. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Qui peut compter la poussière de Jacob, Et dire le nombre du quart d’Israël? Que je meure de la mort des justes, Et que ma fin soit semblable à la leur! ");
INSERT INTO fraLSG_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balak dit à Balaam: Que m’as-tu fait? Je t’ai pris pour maudire mon ennemi, et voici, tu le bénis! ");
INSERT INTO fraLSG_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Il répondit, et dit: N’aurai-je pas soin de dire ce que l’Éternel met dans ma bouche? ");
INSERT INTO fraLSG_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak lui dit: Viens donc avec moi dans un autre lieu, d’où tu le verras; tu n’en verras qu’une partie, tu n’en verras pas la totalité. Et de là maudis-le-moi. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Il le mena au champ de Tsophim, sur le sommet du Pisga; il bâtit sept autels, et offrit un taureau et un bélier sur chaque autel. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam dit à Balak: Tiens-toi ici, près de ton holocauste, et j’irai à la rencontre de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","L’Éternel vint au-devant de Balaam; il mit des paroles dans sa bouche, et dit: Retourne vers Balak, et tu parleras ainsi. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Il retourna vers lui; et voici, Balak se tenait près de son holocauste, avec les chefs de Moab. Balak lui dit: Qu’est-ce que l’Éternel a dit? ");
INSERT INTO fraLSG_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaam prononça son oracle, et dit: Lève-toi, Balak, écoute! Prête-moi l’oreille, fils de Tsippor! ");
INSERT INTO fraLSG_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Dieu n’est point un homme pour mentir, Ni fils d’un homme pour se repentir. Ce qu’il a dit, ne le fera-t-il pas? Ce qu’il a déclaré, ne l’exécutera-t-il pas? ");
INSERT INTO fraLSG_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Voici, j’ai reçu l’ordre de bénir: Il a béni, je ne le révoquerai point. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Il n’aperçoit point d’iniquité en Jacob, Il ne voit point d’injustice en Israël; L’Éternel, son Dieu, est avec lui, Il est son roi, l’objet de son allégresse. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Dieu les a fait sortir d’Égypte, Il est pour eux comme la vigueur du buffle. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","L’enchantement ne peut rien contre Jacob, Ni la divination contre Israël; Au temps marqué, il sera dit à Jacob et à Israël: Quelle est l’œuvre de Dieu. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","C’est un peuple qui se lève comme une lionne, Et qui se dresse comme un lion; Il ne se couche point jusqu’à ce qu’il ait dévoré la proie, Et qu’il ait bu le sang des blessés. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak dit à Balaam: Ne le maudis pas, mais du moins ne le bénis pas. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam répondit, et dit à Balak: Ne t’ai-je pas parlé ainsi: Je ferai tout ce que l’Éternel dira? ");
INSERT INTO fraLSG_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak dit à Balaam: Viens donc, je te mènerai dans un autre lieu; peut être Dieu trouvera-t-il bon que de là tu me maudisses ce peuple. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Balak mena Balaam sur le sommet du Peor, en regard du désert. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam dit à Balak: Bâtis-moi ici sept autels, et prépare-moi ici sept taureaux et sept béliers. ");
INSERT INTO fraLSG_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak fit ce que Balaam avait dit, et il offrit un taureau et un bélier sur chaque autel. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaam vit que l’Éternel trouvait bon de bénir Israël, et il n’alla point comme les autres fois, à la rencontre des enchantements; mais il tourna son visage du côté du désert. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Balaam leva les yeux, et vit Israël campé selon ses tribus. Alors l’esprit de Dieu fut sur lui. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Balaam prononça son oracle, et dit: Parole de Balaam, fils de Beor, Parole de l’homme qui a l’œil ouvert, ");
INSERT INTO fraLSG_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Parole de celui qui entend les paroles de Dieu, De celui qui voit la vision du Tout-Puissant, De celui qui se prosterne et dont les yeux s’ouvrent. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Qu’elles sont belles, tes tentes, ô Jacob! Tes demeures, ô Israël! ");
INSERT INTO fraLSG_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Elles s’étendent comme des vallées, Comme des jardins près d’un fleuve, Comme des aloès que l’Éternel a plantés, Comme des cèdres le long des eaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","L’eau coule de ses seaux, Et sa semence est fécondée par d’abondantes eaux. Son roi s’élève au-dessus d’Agag, Et son royaume devient puissant. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Dieu l’a fait sortir d’Égypte, Il est pour lui comme la vigueur du buffle. Il dévore les nations qui s’élèvent contre lui, Il brise leurs os, et les abat de ses flèches. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Il ploie les genoux, il se couche comme un lion, comme une lionne: Qui le fera lever? Béni soit quiconque te bénira, Et maudit soit quiconque te maudira! ");
INSERT INTO fraLSG_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","La colère de Balak s’enflamma contre Balaam; il frappa des mains, et dit à Balaam: C’est pour maudire mes ennemis que je t’ai appelé, et voici, tu les as bénis déjà trois fois. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Fuis maintenant, va-t’en chez toi! J’avais dit que je te rendrais des honneurs, mais l’Éternel t’empêche de les recevoir. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam répondit à Balak: Eh! N’ai-je pas dit aux messagers que tu m’as envoyés: ");
INSERT INTO fraLSG_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Quand Balak me donnerait sa maison pleine d’argent et d’or, je ne pourrais faire de moi-même ni bien ni mal contre l’ordre de l’Éternel; je répéterai ce que dira l’Éternel? ");
INSERT INTO fraLSG_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Et maintenant voici, je m’en vais vers mon peuple. Viens, je t’annoncerai ce que ce peuple fera à ton peuple dans la suite des temps. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Balaam prononça son oracle, et dit: Parole de Balaam, fils de Beor, Parole de l’homme qui a l’œil ouvert, ");
INSERT INTO fraLSG_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Parole de celui qui entend les paroles de Dieu, De celui qui connaît les desseins du Très-Haut, De celui qui voit la vision du Tout-Puissant, De celui qui se prosterne et dont les yeux s’ouvrent. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Je le vois, mais non maintenant, Je le contemple, mais non de près. Un astre sort de Jacob, Un sceptre s’élève d’Israël. Il perce les flancs de Moab, Et il abat tous les enfants de Seth. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Il se rend maître d’Édom, Il se rend maître de Séir, ses ennemis. Israël manifeste sa force. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Celui qui sort de Jacob règne en souverain, Il fait périr ceux qui s’échappent des villes. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balaam vit Amalek. Il prononça son oracle, et dit: Amalek est la première des nations, Mais un jour il sera détruit. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Balaam vit les Kéniens. Il prononça son oracle, et dit: Ta demeure est solide, Et ton nid posé sur le roc. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Mais le Kénien sera chassé, Quand l’Assyrien t’emmènera captif. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Balaam prononça son oracle, et dit: Hélas! Qui vivra après que Dieu l’aura établi? ");
INSERT INTO fraLSG_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Mais des navires viendront de Kittim, Ils humilieront l’Assyrien, ils humilieront l’Hébreu; Et lui aussi sera détruit. ");
INSERT INTO fraLSG_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Balaam se leva, partit, et retourna chez lui. Balak s’en alla aussi de son côté. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israël demeurait à Sittim; et le peuple commença à se livrer à la débauche avec les filles de Moab. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Elles invitèrent le peuple aux sacrifices de leurs dieux; et le peuple mangea, et se prosterna devant leurs dieux. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israël s’attacha à Baal-Peor, et la colère de l’Éternel s’enflamma contre Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","L’Éternel dit à Moïse: Assemble tous les chefs du peuple, et fais pendre les coupables devant l’Éternel en face du soleil, afin que la colère ardente de l’Éternel se détourne d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Moïse dit aux juges d’Israël: Que chacun de vous tue ceux de ses gens qui se sont attachés à Baal-Peor. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Et voici, un homme des enfants d’Israël vint et amena vers ses frères une Madianite, sous les yeux de Moïse et sous les yeux de toute l’assemblée des enfants d’Israël, tandis qu’ils pleuraient à l’entrée de la tente d’assignation. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","A cette vue, Phinées, fils d’Éléazar, fils du sacrificateur Aaron, se leva du milieu de l’assemblée, et prit une lance, dans sa main. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Il suivit l’homme d’Israël dans sa tente, et il les perça tous les deux, l’homme d’Israël, puis la femme, par le bas-ventre. Et la plaie s’arrêta parmi les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Il y en eut vingt-quatre mille qui moururent de la plaie. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Phinées, fils d’Éléazar, fils du sacrificateur Aaron, a détourné ma fureur de dessus les enfants d’Israël, parce qu’il a été animé de mon zèle au milieu d’eux; et je n’ai point, dans ma colère, consumé les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","C’est pourquoi tu diras que je traite avec lui une alliance de paix. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Ce sera pour lui et pour sa postérité après lui l’alliance d’un sacerdoce perpétuel, parce qu’il a été zélé pour son Dieu, et qu’il a fait l’expiation pour les enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","L’homme d’Israël, qui fut tué avec la Madianite, s’appelait Zimri, fils de Salu; il était chef d’une maison paternelle des Siméonites. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","La femme qui fut tuée, la Madianite, s’appelait Cozbi, fille de Tsur, chef des peuplades issues d’une maison paternelle en Madian. ");
INSERT INTO fraLSG_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Traite les Madianites en ennemis, et tuez-les; ");
INSERT INTO fraLSG_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","car ils se sont montrés vos ennemis, en vous séduisant par leurs ruses, dans l’affaire de Peor, et dans l’affaire de Cozbi, fille d’un chef de Madian, leur sœur, tuée le jour de la plaie qui eut lieu à l’occasion de Peor. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","A la suite de cette plaie, l’Éternel dit à Moïse et à Éléazar, fils du sacrificateur Aaron: ");
INSERT INTO fraLSG_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Faites le dénombrement de toute l’assemblée des enfants d’Israël, depuis l’âge de vingt ans et au-dessus, selon les maisons de leurs pères, de tous ceux d’Israël en état de porter les armes. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Moïse et le sacrificateur Éléazar leur parlèrent dans les plaines de Moab, près du Jourdain, vis-à-vis de Jéricho. Ils dirent: ");
INSERT INTO fraLSG_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","On fera le dénombrement, depuis l’âge de vingt ans et au-dessus, comme l’Éternel l’avait ordonné à Moïse et aux enfants d’Israël, quand ils furent sortis du pays d’Égypte. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben, premier-né d’Israël. Fils de Ruben: Hénoc de qui descend la famille des Hénokites; Pallu, de qui descend la famille des Palluites; ");
INSERT INTO fraLSG_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hetsron, de qui descend la famille des Hetsronites; Carmi, de qui descend la famille des Carmites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Ce sont là les familles des Rubénites: ceux dont on fit le dénombrement furent quarante-trois mille sept cent trente. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Fils de Pallu: Éliab. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Fils d’Éliab: Nemuel, Dathan et Abiram. C’est ce Dathan et cet Abiram, qui étaient de ceux que l’on convoquait à l’assemblée, et qui se soulevèrent contre Moïse et Aaron, dans l’assemblée de Koré, lors de leur révolte contre l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","La terre ouvrit sa bouche, et les engloutit avec Koré, quand moururent ceux qui s’étaient assemblés, et que le feu consuma les deux cent cinquante hommes: ils servirent au peuple d’avertissement. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Les fils de Koré ne moururent pas. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Fils de Siméon, selon leurs familles: de Nemuel descend la famille des Nemuélites; de Jamin, la famille des Jaminites; de Jakin, la famille des Jakinites; ");
INSERT INTO fraLSG_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","de Zérach, la famille des Zérachites; de Saül, la famille des Saülites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Ce sont là les familles des Siméonites; vingt-deux mille deux cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Fils de Gad, selon leurs familles: de Tsephon descend la famille des Tsephonites; de Haggi, la famille des Haggites; de Schuni, la famille des Schunites; ");
INSERT INTO fraLSG_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","d’Ozni, la famille des Oznites; d’Éri, la famille des Érites; ");
INSERT INTO fraLSG_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","d’Arod, la famille des Arodites; d’Areéli, la famille des Areélites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Ce sont là les familles des fils de Gad, d’après leur dénombrement: quarante mille cinq cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Fils de Juda: Er et Onan; mais Er et Onan moururent au pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Voici les fils de Juda, selon leurs familles: de Schéla descend la famille des Schélanites; de Pérets, la famille des Péretsites; de Zérach, la famille des Zérachites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Les fils de Pérets furent: Hetsron, de qui descend la famille des Hetsronites; Hamul, de qui descend la famille des Hamulites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ce sont là les familles de Juda, d’après leur dénombrement: soixante-seize mille cinq cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Fils d’Issacar, selon leurs familles: de Thola descend la famille des Tholaïtes; de Puva, la famille des Puvites; ");
INSERT INTO fraLSG_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","de Jaschub, la famille des Jaschubites; de Schimron, la famille des Schimronites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ce sont là les familles d’Issacar, d’après leur dénombrement: soixante quatre mille trois cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Fils de Zabulon, selon leurs familles: de Séred descend la famille des Sardites; d’Élon, la famille des Élonites; de Jahleel, la famille des Jahleélites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ce sont là les familles des Zabulonites, d’après leur dénombrement: soixante mille cinq cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Fils de Joseph, selon leurs familles: Manassé et Éphraïm. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Fils de Manassé: de Makir descend la famille des Makirites. Makir engendra Galaad. De Galaad descend la famille des Galaadites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Voici les fils de Galaad: Jézer, de qui descend la famille des Jézerites; Hélek, la famille des Hélekites; ");
INSERT INTO fraLSG_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, la famille des Asriélites; Sichem, la famille des Sichémites; ");
INSERT INTO fraLSG_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Schemida, la famille des Schemidaïtes; Hépher, la famille des Héphrites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Tselophchad, fils de Hépher, n’eut point de fils, mais il eut des filles. Voici les noms des filles de Tselophchad: Machla, Noa, Hogla, Milca et Thirtsa. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Ce sont là les familles de Manassé, d’après leur dénombrement: cinquante deux mille sept cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Voici les fils d’Éphraïm, selon leurs familles: de Schutélach descend la famille des Schutalchites; de Béker, la famille des Bakrites; de Thachan, la famille des Thachanites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Voici les fils de Schutélach: d’Éran est descendue la famille des Éranites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ce sont là les familles des fils d’Éphraïm, d’après leur dénombrement: trente-deux mille cinq cents. Ce sont là les fils de Joseph, selon leurs familles. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Fils de Benjamin, selon leurs familles: de Béla descend la famille des Balites; d’Aschbel, la famille des Aschbélites; d’Achiram, la famille des Achiramites; ");
INSERT INTO fraLSG_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","de Schupham, la famille des Schuphamites; de Hupham, la famille des Huphamites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Les fils de Béla furent: Ard et Naaman. D’Ard descend la famille des Ardites; de Naaman, la famille des Naamanites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Ce sont là les fils de Benjamin, selon leurs familles et d’après leur dénombrement; quarante-cinq mille six cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Voici les fils de Dan, selon leurs familles: de Schucham descend la famille des Schuchamites. Ce sont là les familles de Dan, selon leurs familles. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Total pour les familles des Schuchamites, d’après leur dénombrement: soixante-quatre mille quatre cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Fils d’Aser, selon leurs familles: de Jimna descend la famille des Jimnites; de Jischvi, la famille des Jischvites; de Beria, la famille des Beriites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Des fils de Beria descendent: de Héber, la famille des Hébrites; de Malkiel, la famille des Malkiélites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Le nom de la fille d’Aser était Sérach. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ce sont là les familles des fils d’Aser, d’après leur dénombrement: cinquante-trois mille quatre cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Fils de Nephthali, selon leurs familles: de Jahtseel descend la famille des Jahtseélites; de Guni, la famille des Gunites; ");
INSERT INTO fraLSG_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","de Jetser, la famille des Jitsrites; de Schillem, la famille des Schillémites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ce sont là les familles de Nephthali, selon leurs familles et d’après leur dénombrement: quarante-cinq mille quatre cents. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Tels sont ceux des enfants d’Israël dont on fit le dénombrement: six cent un mille sept cent trente. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Le pays sera partagé entre eux, pour être leur propriété, selon le nombre des noms. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","A ceux qui sont en plus grand nombre tu donneras une portion plus grande, et à ceux qui sont en plus petit nombre tu donneras une portion plus petite; on donnera à chacun sa portion d’après le dénombrement. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Mais le partage du pays aura lieu par le sort; ils le recevront en propriété selon les noms des tribus de leurs pères. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","C’est par le sort que le pays sera partagé entre ceux qui sont en grand nombre et ceux qui sont en petit nombre. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Voici les Lévites dont on fit le dénombrement, selon leurs familles: de Guerschon descend la famille des Guerschonites; de Kehath, la famille des Kehathites; de Merari, la famille des Merarites. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Voici les familles de Lévi: la famille des Libnites, la famille des Hébronites, la famille des Machlites, la famille des Muschites, la famille des Korites. Kehath engendra Amram. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Le nom de la femme d’Amram était Jokébed, fille de Lévi, laquelle naquit à Lévi, en Égypte; elle enfanta à Amram: Aaron, Moïse, et Marie, leur sœur. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Il naquit à Aaron: Nadab et Abihu, Éléazar et Ithamar. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab et Abihu moururent, lorsqu’ils apportèrent devant l’Éternel du feu étranger. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ceux dont on fit le dénombrement, tous les mâles depuis l’âge d’un mois et au-dessus, furent vingt-trois mille. Ils ne furent pas compris dans le dénombrement des enfants d’Israël, parce qu’il ne leur fut point donné de possession au milieu des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Tels sont ceux des enfants d’Israël dont Moïse et le sacrificateur Éléazar firent le dénombrement dans les plaines de Moab, près du Jourdain, vis-à-vis de Jéricho. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Parmi eux, il n’y avait aucun des enfants d’Israël dont Moïse et le sacrificateur Aaron avaient fait le dénombrement dans le désert de Sinaï. ");
INSERT INTO fraLSG_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Car l’Éternel avait dit: ils mourront dans le désert, et il n’en restera pas un, excepté Caleb, fils de Jephunné, et Josué, fils de Nun. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Les filles de Tselophchad, fils de Hépher, fils de Galaad, fils de Makir, fils de Manassé, des familles de Manassé, fils de Joseph, et dont les noms étaient Machla, Noa, Hogla, Milca et Thirtsa, ");
INSERT INTO fraLSG_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","s’approchèrent et se présentèrent devant Moïse, devant le sacrificateur Éléazar, et devant les princes et toute l’assemblée, à l’entrée de la tente d’assignation. Elles dirent: ");
INSERT INTO fraLSG_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Notre père est mort dans le désert; il n’était pas au milieu de l’assemblée de ceux qui se révoltèrent contre l’Éternel, de l’assemblée de Koré, mais il est mort pour son péché, et il n’avait point de fils. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Pourquoi le nom de notre père serait-il retranché du milieu de sa famille, parce qu’il n’avait point eu de fils? Donne-nous une possession parmi les frères de notre père. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Moïse porta la cause devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Et l’Éternel dit à Moïse: ");
INSERT INTO fraLSG_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Les filles de Tselophchad ont raison. Tu leur donneras en héritage une possession parmi les frères de leur père, et c’est à elles que tu feras passer l’héritage de leur père. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Tu parleras aux enfants d’Israël, et tu diras: Lorsqu’un homme mourra sans laisser de fils, vous ferez passer son héritage à sa fille. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","S’il n’a point de fille, vous donnerez son héritage à ses frères. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","S’il n’a point de frères, vous donnerez son héritage aux frères de son père. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","S’il n’y a point de frères de son père, vous donnerez son héritage au plus proche parent dans sa famille, et c’est lui qui le possédera. Ce sera pour les enfants d’Israël une loi et un droit, comme l’Éternel l’a ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","L’Éternel dit à Moïse: Monte sur cette montagne d’Abarim, et regarde le pays que je donne aux enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Tu le regarderas; mais toi aussi, tu seras recueilli auprès de ton peuple, comme Aaron, ton frère, a été recueilli; ");
INSERT INTO fraLSG_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","parce que vous avez été rebelles à mon ordre, dans le désert de Tsin, lors de la contestation de l’assemblée, et que vous ne m’avez point sanctifié à leurs yeux à l’occasion des eaux. Ce sont les eaux de contestation, à Kadès, dans le désert de Tsin. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Moïse parla à l’Éternel, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Que l’Éternel, le Dieu des esprits de toute chair, établisse sur l’assemblée un homme ");
INSERT INTO fraLSG_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","qui sorte devant eux et qui entre devant eux, qui les fasse sortir et qui les fasse entrer, afin que l’assemblée de l’Éternel ne soit pas comme des brebis qui n’ont point de berger. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","L’Éternel dit à Moïse: Prends Josué, fils de Nun, homme en qui réside l’esprit; et tu poseras ta main sur lui. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Tu le placeras devant le sacrificateur Éléazar et devant toute l’assemblée, et tu lui donneras des ordres sous leurs yeux. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Tu le rendras participant de ta dignité, afin que toute l’assemblée des enfants d’Israël l’écoute. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Il se présentera devant le sacrificateur Éléazar, qui consultera pour lui le jugement de l’urim devant l’Éternel; et Josué, tous les enfants d’Israël avec lui, et toute l’assemblée, sortiront sur l’ordre d’Éléazar et entreront sur son ordre. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Moïse fit ce que l’Éternel lui avait ordonné. Il prit Josué, et il le plaça devant le sacrificateur Éléazar et devant toute l’assemblée. ");
INSERT INTO fraLSG_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Il posa ses mains sur lui, et lui donna des ordres, comme l’Éternel l’avait dit par Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","L’Éternel parla à Moïse, et dit: Donne cet ordre aux enfants d’Israël, et dis-leur: ");
INSERT INTO fraLSG_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Vous aurez soin de me présenter, au temps fixé, mon offrande, l’aliment de mes sacrifices consumés par le feu, et qui me sont d’une agréable odeur. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Tu leur diras: Voici le sacrifice consumé par le feu que vous offrirez à l’Éternel: chaque jour, deux agneaux d’un an sans défaut, comme holocauste perpétuel. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Tu offriras l’un des agneaux le matin, et l’autre agneau entre les deux soirs, ");
INSERT INTO fraLSG_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","et, pour l’offrande, un dixième d’épha de fleur de farine pétrie dans un quart de hin d’huile d’olives concassées. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","C’est l’holocauste perpétuel, qui a été offert à la montagne de Sinaï; c’est un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","La libation sera d’un quart de hin pour chaque agneau: c’est dans le lieu saint que tu feras la libation de vin à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Tu offriras le second agneau entre les deux soirs, avec une offrande et une libation semblables à celles du matin; c’est un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Le jour du sabbat, vous offrirez deux agneaux d’un an sans défaut, et, pour l’offrande, deux dixièmes de fleur de farine pétrie à l’huile, avec la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","C’est l’holocauste du sabbat, pour chaque sabbat, outre l’holocauste perpétuel et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Au commencement de vos mois, vous offrirez en holocauste à l’Éternel deux jeunes taureaux, un bélier, et sept agneaux d’un an sans défaut; ");
INSERT INTO fraLSG_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","et, comme offrande pour chaque taureau, trois dixièmes de fleur de farine pétrie à l’huile; comme offrande pour le bélier, deux dixièmes de fleur de farine pétrie à l’huile; ");
INSERT INTO fraLSG_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","comme offrande pour chaque agneau, un dixième de fleur de farine pétrie à l’huile. C’est un holocauste, un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Les libations seront d’un demi-hin de vin pour un taureau, d’un tiers de hin pour un bélier, et d’un quart de hin pour un agneau. C’est l’holocauste du commencement du mois, pour chaque mois, pour tous les mois de l’année. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","On offrira à l’Éternel un bouc, en sacrifice d’expiation, outre l’holocauste perpétuel et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Le premier mois, le quatorzième jour du mois, ce sera la Pâque de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Le quinzième jour de ce mois sera un jour de fête. On mangera pendant sept jours des pains sans levain. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Le premier jour, il y aura une sainte convocation: vous ne ferez aucune œuvre servile. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Vous offrirez en holocauste à l’Éternel un sacrifice consumé par le feu: deux jeunes taureaux, un bélier, et sept agneaux d’un an sans défaut. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Vous y joindrez l’offrande de fleur de farine pétrie à l’huile, trois dixièmes pour un taureau, deux dixièmes pour un bélier, ");
INSERT INTO fraLSG_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","et un dixième pour chacun des sept agneaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Vous offrirez un bouc en sacrifice d’expiation, afin de faire pour vous l’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Vous offrirez ces sacrifices, outre l’holocauste du matin, qui est un holocauste perpétuel. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Vous les offrirez chaque jour, pendant sept jours, comme l’aliment d’un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel. On les offrira, outre l’holocauste perpétuel et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Le septième jour, vous aurez une sainte convocation: vous ne ferez aucune œuvre servile. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Le jour des prémices, où vous présenterez à l’Éternel une offrande, à votre fête des semaines, vous aurez une sainte convocation: vous ne ferez aucune œuvre servile. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Vous offrirez en holocauste, d’une agréable odeur à l’Éternel, deux jeunes taureaux, un bélier, et sept agneaux d’un an. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Vous y joindrez l’offrande de fleur de farine pétrie à l’huile, trois dixièmes pour chaque taureau, deux dixièmes pour le bélier, ");
INSERT INTO fraLSG_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","et un dixième pour chacun des sept agneaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Vous offrirez un bouc, afin de faire pour vous l’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Vous offrirez ces sacrifices, outre l’holocauste perpétuel et l’offrande. Vous aurez des agneaux sans défaut, et vous joindrez les libations. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Le septième mois, le premier jour du mois, vous aurez une sainte convocation: vous ne ferez aucune œuvre servile. Ce jour sera publié parmi vous au son des trompettes. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Vous offrirez en holocauste, d’une agréable odeur à l’Éternel, un jeune taureau, un bélier, et sept agneaux d’un an sans défaut. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Vous y joindrez l’offrande de fleur de farine pétrie à l’huile, trois dixièmes pour le taureau, deux dixièmes pour le bélier, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","et un dixième pour chacun des sept agneaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Vous offrirez un bouc en sacrifice d’expiation, afin de faire pour vous l’expiation. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Vous offrirez ces sacrifices, outre l’holocauste et l’offrande de chaque mois, l’holocauste perpétuel et l’offrande, et les libations qui s’y joignent, d’après les règles établies. Ce sont des sacrifices consumés par le feu, d’une agréable odeur à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Le dixième jour de ce septième mois, vous aurez une sainte convocation, et vous humilierez vos âmes: vous ne ferez aucun ouvrage. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Vous offrirez en holocauste, d’une agréable odeur à l’Éternel, un jeune taureau, un bélier, et sept agneaux d’un an sans défaut. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Vous y joindrez l’offrande de fleur de farine pétrie à l’huile, trois dixièmes pour le taureau, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","deux dixièmes pour le bélier, et un dixième pour chacun des sept agneaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Vous offrirez un bouc en sacrifice d’expiation, outre le sacrifice des expiations, l’holocauste perpétuel et l’offrande, et les libations ordinaires. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Le quinzième jour du septième mois, vous aurez une sainte convocation: vous ne ferez aucune œuvre servile. Vous célébrerez une fête en l’honneur de l’Éternel, pendant sept jours. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Vous offrirez en holocauste un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel: treize jeunes taureaux, deux béliers, et quatorze agneaux d’un an sans défaut. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Vous y joindrez l’offrande de fleur de farine pétrie à l’huile, trois dixièmes pour chacun des treize taureaux, deux dixièmes pour chacun des deux béliers, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","et un dixième pour chacun des quatorze agneaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Vous offrirez un bouc en sacrifice d’expiation, outre l’holocauste perpétuel, l’offrande et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Le second jour, vous offrirez douze jeunes taureaux, deux béliers, et quatorze agneaux d’un an sans défaut, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","avec l’offrande et les libations pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après les règles établies. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Vous offrirez un bouc en sacrifice d’expiation, outre l’holocauste perpétuel, l’offrande et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Le troisième jour, vous offrirez onze taureaux, deux béliers, et quatorze agneaux d’un an sans défaut, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","avec l’offrande et les libations pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après les règles établies. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Vous offrirez un bouc en sacrifice d’expiation, outre l’holocauste perpétuel, l’offrande et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Le quatrième jour, vous offrirez dix taureaux, deux béliers, et quatorze agneaux d’un an sans défaut, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","avec l’offrande et les libations pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après les règles établies. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Vous offrirez un bouc en sacrifice d’expiation, outre l’holocauste perpétuel, l’offrande et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Le cinquième jour, vous offrirez neuf taureaux, deux béliers, et quatorze agneaux d’un an sans défaut, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","avec l’offrande et les libations pour les taureaux, les béliers et les agneaux selon leur nombre, d’après les règles établies. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Vous offrirez un bouc en sacrifice d’expiation, outre l’holocauste perpétuel, l’offrande et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Le sixième jour, vous offrirez huit taureaux, deux béliers et quatorze agneaux d’un an sans défaut, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","avec l’offrande et les libations pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après les règles établies. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Vous offrirez un bouc en sacrifice d’expiation, outre l’holocauste perpétuel, l’offrande et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Le septième jour, vous offrirez sept taureaux, deux béliers, et quatorze agneaux d’un an sans défaut, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","avec l’offrande et les libations pour les taureaux, les béliers et les agneaux, selon leur nombre, d’après les règles établies. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Vous offrirez un bouc en sacrifice d’expiation, outre l’holocauste perpétuel, l’offrande et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Le huitième jour, vous aurez une assemblée solennelle: vous ne ferez aucune œuvre servile. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Vous offrirez en holocauste un sacrifice consumé par le feu, d’une agréable odeur à l’Éternel: un taureau, un bélier, et sept agneaux d’un an sans défaut, ");
INSERT INTO fraLSG_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","avec l’offrande et les libations pour le taureau, le bélier et les agneaux, selon leur nombre, d’après les règles établies. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Vous offrirez un bouc en sacrifice d’expiation, outre l’holocauste perpétuel, l’offrande et la libation. ");
INSERT INTO fraLSG_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Tels sont les sacrifices que vous offrirez à l’Éternel dans vos fêtes, outre vos holocaustes, vos offrandes et vos libations, et vos sacrifices de prospérité, en accomplissement d’un vœu ou en offrandes volontaires. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Moïse dit aux enfants d’Israël tout ce que l’Éternel lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Moïse parla aux chefs des tribus des enfants d’Israël, et dit: Voici ce que l’Éternel ordonne. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Lorsqu’un homme fera un vœu à l’Éternel, ou un serment pour se lier par un engagement, il ne violera point sa parole, il agira selon tout ce qui est sorti de sa bouche. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Lorsqu’une femme, dans sa jeunesse et à la maison de son père, fera un vœu à l’Éternel et se liera par un engagement, ");
INSERT INTO fraLSG_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","et que son père aura connaissance du vœu qu’elle a fait et de l’engagement par lequel elle s’est liée, si son père garde le silence envers elle, tout vœu qu’elle aura fait sera valable, et tout engagement par lequel elle se sera liée sera valable; ");
INSERT INTO fraLSG_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","mais si son père la désapprouve le jour où il en a connaissance, tous ses vœux et tous les engagements par lesquels elle se sera liée n’auront aucune valeur; et l’Éternel lui pardonnera, parce qu’elle a été désapprouvée de son père. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Lorsqu’elle sera mariée, après avoir fait des vœux, ou s’être liée par une parole échappée de ses lèvres, ");
INSERT INTO fraLSG_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","et que son mari en aura connaissance, s’il garde le silence envers elle le jour où il en a connaissance, ses vœux seront valables, et les engagements par lesquels elle se sera liée seront valables; ");
INSERT INTO fraLSG_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","mais si son mari la désapprouve le jour où il en a connaissance, il annulera le vœu qu’elle a fait et la parole échappée de ses lèvres, par laquelle elle s’est liée; et l’Éternel lui pardonnera. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Le vœu d’une femme veuve ou répudiée, l’engagement quelconque par lequel elle se sera liée, sera valable pour elle. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Lorsqu’une femme, dans la maison de son mari, fera des vœux ou se liera par un serment, ");
INSERT INTO fraLSG_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","et que son mari en aura connaissance, s’il garde le silence envers elle et ne la désapprouve pas, tous ses vœux seront valables, et tous les engagements par lesquels elle se sera liée seront valables; ");
INSERT INTO fraLSG_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","mais si son mari les annule le jour où il en a connaissance, tout vœu et tout engagement sortis de ses lèvres n’auront aucune valeur, son mari les a annulés; et l’Éternel lui pardonnera. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Son mari peut ratifier et son mari peut annuler tout vœu, tout serment par lequel elle s’engage à mortifier sa personne. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","S’il garde de jour en jour le silence envers elle, il ratifie ainsi tous les vœux ou tous les engagements par lesquels elle s’est liée; il les ratifie, parce qu’il a gardé le silence envers elle le jour où il en a eu connaissance. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Mais s’il les annule après le jour où il en a eu connaissance, il sera coupable du péché de sa femme. ");
INSERT INTO fraLSG_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Telles sont les lois que l’Éternel prescrivit à Moïse, entre un mari et sa femme, entre un père et sa fille, lorsqu’elle est dans sa jeunesse et à la maison de son père. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","L’Éternel parla à Moïse, et dit: ");
INSERT INTO fraLSG_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Venge les enfants d’Israël sur les Madianites; tu seras ensuite recueilli auprès de ton peuple. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Moïse parla au peuple, et dit: Équipez d’entre vous des hommes pour l’armée, et qu’ils marchent contre Madian, afin d’exécuter la vengeance de l’Éternel sur Madian. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Vous enverrez à l’armée mille hommes par tribu, de toutes les tribus d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","On leva d’entre les milliers d’Israël mille hommes par tribu, soit douze mille hommes équipés pour l’armée. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Moïse envoya à l’armée ces mille hommes par tribu, et avec eux le fils du sacrificateur Éléazar, Phinées, qui portait les instruments sacrés et les trompettes retentissantes. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Ils s’avancèrent contre Madian, selon l’ordre que l’Éternel avait donné à Moïse; et ils tuèrent tous les mâles. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Ils tuèrent les rois de Madian avec tous les autres, Évi, Rékem, Tsur, Hur et Réba, cinq rois de Madian; ils tuèrent aussi par l’épée Balaam, fils de Beor. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Les enfants d’Israël firent prisonnières les femmes des Madianites avec leurs petits enfants, et ils pillèrent tout leur bétail, tous leurs troupeaux et toutes leurs richesses. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Ils incendièrent toutes les villes qu’ils habitaient et tous leurs enclos. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Ils prirent toutes les dépouilles et tout le butin, personnes et bestiaux; ");
INSERT INTO fraLSG_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","et ils amenèrent les captifs, le butin et les dépouilles, à Moïse, au sacrificateur Éléazar, et à l’assemblée des enfants d’Israël, campés dans les plaines de Moab, près du Jourdain, vis-à-vis de Jéricho. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Moïse, le sacrificateur Éléazar, et tous les princes de l’assemblée, sortirent au-devant d’eux, hors du camp. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Et Moïse s’irrita contre les commandants de l’armée, les chefs de milliers et les chefs de centaines, qui revenaient de l’expédition. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Il leur dit: Avez-vous laissé la vie à toutes les femmes? ");
INSERT INTO fraLSG_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Voici, ce sont elles qui, sur la parole de Balaam, ont entraîné les enfants d’Israël à l’infidélité envers l’Éternel, dans l’affaire de Peor; et alors éclata la plaie dans l’assemblée de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Maintenant, tuez tout mâle parmi les petits enfants, et tuez toute femme qui a connu un homme en couchant avec lui; ");
INSERT INTO fraLSG_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","mais laissez en vie pour vous toutes les filles qui n’ont point connu la couche d’un homme. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Et vous, campez pendant sept jours hors du camp; tous ceux d’entre vous qui ont tué quelqu’un, et tous ceux qui ont touché un mort, se purifieront le troisième et le septième jour, eux et vos prisonniers. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Vous purifierez aussi tout vêtement, tout objet de peau, tout ouvrage de poil de chèvre et tout ustensile de bois. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Le sacrificateur Éléazar dit aux soldats qui étaient allés à la guerre: Voici ce qui est ordonné par la loi que l’Éternel a prescrite à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","L’or, l’argent, l’airain, le fer, l’étain et le plomb, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","tout objet qui peut aller au feu, vous le ferez passer par le feu pour le rendre pur. Mais c’est par l’eau de purification que sera purifié tout ce qui ne peut aller au feu; vous le ferez passer dans l’eau. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Vous laverez vos vêtements le septième jour, et vous serez purs; ensuite, vous pourrez entrer dans le camp. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","L’Éternel dit à Moïse: ");
INSERT INTO fraLSG_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Fais, avec le sacrificateur Éléazar et les chefs de maison de l’assemblée, le compte du butin, de ce qui a été pris, personnes et bestiaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Partage le butin entre les combattants qui sont allés à l’armée et toute l’assemblée. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Tu prélèveras sur la portion des soldats qui sont allés à l’armée un tribut pour l’Éternel, savoir: un sur cinq cents, tant des personnes que des bœufs, des ânes et des brebis. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Vous le prendrez sur leur moitié, et tu le donneras au sacrificateur Éléazar comme une offrande à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Et sur la moitié qui revient aux enfants d’Israël tu prendras un sur cinquante, tant des personnes que des bœufs, des ânes et des brebis, de tout animal; et tu le donneras aux Lévites, qui ont la garde du tabernacle de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Moïse et le sacrificateur Éléazar firent ce que l’Éternel avait ordonné à Moïse. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Le butin, reste du pillage de ceux qui avaient fait partie de l’armée, était de six cent soixante-quinze mille brebis, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","soixante-douze mille bœufs, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","soixante et un mille ânes, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","et trente-deux mille personnes ou femmes qui n’avaient point connu la couche d’un homme. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","La moitié, formant la part de ceux qui étaient allés à l’armée, fut de trois cent trente-sept mille cinq cents brebis, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","dont six cent soixante-quinze pour le tribut à l’Éternel; ");
INSERT INTO fraLSG_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","trente-six mille bœufs, dont soixante-douze pour le tribut à l’Éternel; ");
INSERT INTO fraLSG_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","trente mille cinq cents ânes, dont soixante et un pour le tribut à l’Éternel; ");
INSERT INTO fraLSG_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","et seize mille personnes, dont trente-deux pour le tribut à l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Moïse donna au sacrificateur Éléazar le tribut réservé comme offrande à l’Éternel, selon ce que l’Éternel lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","La moitié qui revenait aux enfants d’Israël, séparée par Moïse de celle des hommes de l’armée, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","et formant la part de l’assemblée, fut de trois cent trente-sept mille cinq cents brebis, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","trente-six mille bœufs, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","trente mille cinq cents ânes, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","et seize mille personnes. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Sur cette moitié qui revenait aux enfants d’Israël, Moïse prit un sur cinquante, tant des personnes que des animaux; et il le donna aux Lévites, qui ont la garde du tabernacle de l’Éternel, selon ce que l’Éternel lui avait ordonné. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Les commandants des milliers de l’armée, les chefs de milliers et les chefs de centaines, s’approchèrent de Moïse, ");
INSERT INTO fraLSG_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","et lui dirent: Tes serviteurs ont fait le compte des soldats qui étaient sous nos ordres, et il ne manque pas un homme d’entre nous. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Nous apportons, comme offrande à l’Éternel, chacun les objets d’or que nous avons trouvés, chaînettes, bracelets, anneaux, pendants d’oreilles, et colliers, afin de faire pour nos personnes l’expiation devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Moïse et le sacrificateur Éléazar reçurent d’eux tous ces objets travaillés en or. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Tout l’or, que les chefs de milliers et les chefs de centaines présentèrent à l’Éternel en offrande par élévation, pesait seize mille sept cent cinquante sicles. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Les hommes de l’armée gardèrent chacun le butin qu’ils avaient fait. ");
INSERT INTO fraLSG_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Moïse et le sacrificateur Éléazar prirent l’or des chefs de milliers et des chefs de centaines, et l’apportèrent à la tente d’assignation, comme souvenir pour les enfants d’Israël devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Les fils de Ruben et les fils de Gad avaient une quantité considérable de troupeaux, et ils virent que le pays de Jaezer et le pays de Galaad étaient un lieu propre pour des troupeaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Alors les fils de Gad et les fils de Ruben vinrent auprès de Moïse, du sacrificateur Éléazar et des princes de l’assemblée, et ils leur dirent: ");
INSERT INTO fraLSG_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","Atharoth, Dibon, Jaezer, Nimra, Hesbon, Élealé, Sebam, Nebo et Beon, ");
INSERT INTO fraLSG_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ce pays que l’Éternel a frappé devant l’assemblée d’Israël, est un lieu propre pour des troupeaux, et tes serviteurs ont des troupeaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ils ajoutèrent: Si nous avons trouvé grâce à tes yeux, que la possession de ce pays soit accordée à tes serviteurs, et ne nous fais point passer le Jourdain. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Moïse répondit aux fils de Gad et aux fils de Ruben: Vos frères iront-ils à la guerre, et vous, resterez-vous ici? ");
INSERT INTO fraLSG_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Pourquoi voulez-vous décourager les enfants d’Israël de passer dans le pays que l’Éternel leur donne? ");
INSERT INTO fraLSG_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ainsi firent vos pères, quand je les envoyai de Kadès-Barnéa pour examiner le pays. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Ils montèrent jusqu’à la vallée d’Eschcol, et, après avoir examiné le pays, ils découragèrent les enfants d’Israël d’aller dans le pays que l’Éternel leur donnait. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","La colère de l’Éternel s’enflamma ce jour-là, et il jura en disant: ");
INSERT INTO fraLSG_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Ces hommes qui sont montés d’Égypte, depuis l’âge de vingt ans et au-dessus, ne verront point le pays que j’ai juré de donner à Abraham, à Isaac et à Jacob, car ils n’ont pas suivi pleinement ma voie, ");
INSERT INTO fraLSG_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","excepté Caleb, fils de Jephunné, le Kenizien, et Josué, fils de Nun, qui ont pleinement suivi la voie de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","La colère de l’Éternel s’enflamma contre Israël, et il les fit errer dans le désert pendant quarante années, jusqu’à l’anéantissement de toute la génération qui avait fait le mal aux yeux de l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Et voici, vous prenez la place de vos pères comme des rejetons d’hommes pécheurs, pour rendre la colère de l’Éternel encore plus ardente contre Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Car, si vous vous détournez de lui, il continuera de laisser Israël au désert, et vous causerez la perte de tout ce peuple. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Ils s’approchèrent de Moïse, et ils dirent: Nous construirons ici des parcs pour nos troupeaux et des villes pour nos petits enfants; ");
INSERT INTO fraLSG_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","puis nous nous équiperons en hâte pour marcher devant les enfants d’Israël, jusqu’à ce que nous les ayons introduits dans le lieu qui leur est destiné; et nos petits enfants demeureront dans les villes fortes, à cause des habitants du pays. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Nous ne retournerons point dans nos maisons avant que les enfants d’Israël aient pris possession chacun de son héritage; ");
INSERT INTO fraLSG_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","et nous ne posséderons rien avec eux de l’autre côté du Jourdain, ni plus loin, puisque nous aurons notre héritage de ce côté-ci du Jourdain, à l’orient. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Moïse leur dit: Si vous faites cela, si vous vous armez pour combattre devant l’Éternel, ");
INSERT INTO fraLSG_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","si tous ceux de vous qui s’armeront passent le Jourdain devant l’Éternel jusqu’à ce qu’il ait chassé ses ennemis loin de sa face, ");
INSERT INTO fraLSG_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","et si vous revenez seulement après que le pays aura été soumis devant l’Éternel, vous serez alors sans reproche vis-à-vis de l’Éternel et vis-à-vis d’Israël, et cette contrée-ci sera votre propriété devant l’Éternel. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Mais si vous ne faites pas ainsi, vous péchez contre l’Éternel; sachez que votre péché vous atteindra. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Construisez des villes pour vos petits enfants et des parcs pour vos troupeaux, et faites ce que votre bouche a déclaré. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Les fils de Gad et les fils de Ruben dirent à Moïse: Tes serviteurs feront ce que mon seigneur ordonne. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Nos petits enfants, nos femmes, nos troupeaux et tout notre bétail, resteront dans les villes de Galaad; ");
INSERT INTO fraLSG_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","et tes serviteurs, tous armés pour la guerre, iront combattre devant l’Éternel, comme dit mon seigneur. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Moïse donna des ordres à leur sujet au sacrificateur Éléazar, à Josué, fils de Nun, et aux chefs de famille dans les tribus des enfants d’Israël. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Il leur dit: Si les fils de Gad et les fils de Ruben passent avec vous le Jourdain, tous armés pour combattre devant l’Éternel, et que le pays soit soumis devant vous, vous leur donnerez en propriété la contrée de Galaad. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Mais s’ils ne marchent point en armes avec vous, qu’ils s’établissent au milieu de vous dans le pays de Canaan. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Les fils de Gad et les fils de Ruben répondirent: Nous ferons ce que l’Éternel a dit à tes serviteurs. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Nous passerons en armes devant l’Éternel au pays de Canaan; mais que nous possédions notre héritage de ce côté-ci du Jourdain. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Moïse donna aux fils de Gad et aux fils de Ruben, et à la moitié de la tribu de Manassé, fils de Joseph, le royaume de Sihon, roi des Amoréens, et le royaume d’Og, roi de Basan, le pays avec ses villes, avec les territoires des villes du pays tout alentour. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Les fils de Gad bâtirent Dibon, Atharoth, Aroër, ");
INSERT INTO fraLSG_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Athroth-Schophan, Jaezer, Jogbeha, ");
INSERT INTO fraLSG_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Beth-Nimra et Beth-Haran, villes fortes, et ils firent des parcs pour les troupeaux. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Les fils de Ruben bâtirent Hesbon, Élealé et Kirjathaïm, ");
INSERT INTO fraLSG_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo et Baal-Meon, dont les noms furent changés, et Sibma, et ils donnèrent des noms aux villes qu’ils bâtirent. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Les fils de Makir, fils de Manassé, marchèrent contre Galaad, et s’en emparèrent; ils chassèrent les Amoréens qui y étaient. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Moïse donna Galaad à Makir, fils de Manassé, qui s’y établit. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Jaïr, fils de Manassé, se mit en marche, prit les bourgs, et les appela bourgs de Jaïr. ");
INSERT INTO fraLSG_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nobach se mit en marche, prit Kenath avec les villes de son ressort, et l’appela Nobach, d’après son nom. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Voici les stations des enfants d’Israël qui sortirent du pays d’Égypte, selon leurs corps d’armée, sous la conduite de Moïse et d’Aaron. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Moïse écrivit leurs marches de station en station, d’après l’ordre de l’Éternel. Et voici leurs stations, selon leurs marches. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Ils partirent de Ramsès le premier mois, le quinzième jour du premier mois. Le lendemain de la Pâque, les enfants d’Israël sortirent la main levée, à la vue de tous les Égyptiens. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Et les Égyptiens enterraient ceux que l’Éternel avait frappés parmi eux, tous les premiers-nés; l’Éternel exerçait aussi des jugements contre leurs dieux. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Les enfants d’Israël partirent de Ramsès, et campèrent à Succoth. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Ils partirent de Succoth, et campèrent à Étham, qui est à l’extrémité du désert. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Ils partirent d’Étham, se détournèrent vers Pi-Hahiroth, vis-à-vis de Baal-Tsephon, et campèrent devant Migdol. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Ils partirent de devant Pi-Hahiroth, et passèrent au milieu de la mer dans la direction du désert; ils firent trois journées de marche dans le désert d’Étham, et campèrent à Mara. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Ils partirent de Mara, et arrivèrent à Élim; il y avait à Élim douze sources d’eau et soixante-dix palmiers: ce fut là qu’ils campèrent. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Ils partirent d’Élim, et campèrent près de la mer Rouge. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Ils partirent de la mer Rouge, et campèrent dans le désert de Sin. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Ils partirent du désert de Sin, et campèrent à Dophka. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Ils partirent de Dophka, et campèrent à Alusch. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Ils partirent d’Alusch, et campèrent à Rephidim, où le peuple ne trouva point d’eau à boire. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Ils partirent de Rephidim, et campèrent dans le désert de Sinaï. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Ils partirent du désert du Sinaï, et campèrent à Kibroth-Hattaava. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Ils partirent de Kibroth-Hattaava, et campèrent à Hatséroth. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Ils partirent de Hatséroth, et campèrent à Rithma. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Ils partirent de Rithma, et campèrent à Rimmon-Pérets. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Ils partirent de Rimmon-Pérets, et campèrent à Libna. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Ils partirent de Libna, et campèrent à Rissa. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Ils partirent de Rissa, et campèrent à Kehélatha. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Ils partirent de Kehélatha, et campèrent à la montagne de Schapher. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Ils partirent de la montagne de Schapher, et campèrent à Harada. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Ils partirent de Harada, et campèrent à Makhéloth. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Ils partirent de Makhéloth, et campèrent à Tahath. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Ils partirent de Tahath, et campèrent à Tarach. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Ils partirent de Tarach, et campèrent à Mithka. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Ils partirent de Mithka, et campèrent à Haschmona. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Ils partirent de Haschmona, et campèrent à Moséroth. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Ils partirent de Moséroth, et campèrent à Bené-Jaakan. ");
INSERT INTO fraLSG_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Ils partirent de Bené-Jaakan, et campèrent à Hor-Guidgad. 