﻿USE sofia;
DROP TABLE IF EXISTS sofia.for_vpl;
CREATE TABLE for_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES for_vpl WRITE;
INSERT INTO for_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wasana ai'aru ai'aru aboraurite kanauguna, Isu Karaisiti aeba Abara'amuke, ae aga'nu Tebitike, isige tupisa aborantiye. ");
INSERT INTO for_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Pigoya, Abara'amu aepisa Aisaki aboraogana, Aisaki aepisa Yekobu aboraogana, Yekobu aepisa Yutabe to a'natabarabe aborantawe. ");
INSERT INTO for_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Pigoya, Yuta aepisa Peresebe Sarabe aborantase. Piya, Tema yakari puwaisitantiye. Pigoya, Perese aepisa Esoroni aboraogana, Esoroni aepisa Aramu aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramu aepisa Aminatapu aboraogana, Aminatapu aepisa Nasoni aboraogana, Nasoni aepisa Saramani aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saramani aepisa Powasi aborantiye. Piya, Areyabu yakari potantiye. Pigoya, Powasi aepisa Obeti aborantiye. Piya, Aruti yakari potantiye. Pigoya, Obeti aepisa Yesi aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yesi aepisa wa'ega Tebiti aborantiye. Pigoya Tebiti aepisa Soromoni aborantiye. Piya, Yuraya nkanarimpa yakari potantiye. ");
INSERT INTO for_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Pigoya, Soromoni aepisa Ariyabomu aboraogana, Ariyabomu aepisa Abaisa aboraogana, Abaisa aepisa Esa aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa aepisa Yiyosapati aboraogana, Yiyosapati aepisa Yoramu aboraogana, Yoramu aepisa Asaya aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaya aepisa Yotamu aboraogana, Yotamu aepisa Eyasi aboraogana, Eyasi aepisa Esekaya aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekaya aepisa Manasa aboraogana, Manasa aepisa Emosi aboraogana, Emosi aepisa Yosaya aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaya aepisa Yekonayabe a'natabarabe aborantawe. Piya puguni, Yuta kinapa Pebironi mari iraku'ma ibabute wanta, pi kanabi aborantawe. ");
INSERT INTO for_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Pigoya, igeba Pebironi umintuguna, pi'na aka'i Yekonaya aepisa Siyatiyeri aborantiye. Pigoya Siyatiyeri aepisa Serababeri aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababeri aepisa Abayati aboraogana, Abayati aepisa Erayakimu aboraogana, Erayakimu aepisa Eso aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Eso aepisa Seroki aboraogana, Seroki aepisa Ekimu aboraogana, Ekimu aepisa Eriyati aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriyati aepisa Eriyesa aboraogana, Eriyesa aepisa Matani aboraogana, Matani aepisa Yekobu aboraogana, ");
INSERT INTO for_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yekobu aepisa Yosepe aborantiye. Aeba Mariya awaentana puntiye. Aibogana, Mariyaba Isu yakari potaogini, ae ageba: Karaisiti, Koti utaratanta yagarawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aborantapa pipa mayamawe: Abara'amu aepisa agobima aborata kanauguna Tebiti aboranti, pi a'waipa 14 puntiye. Piya, Tebiti aepisa aboraurite kanauguna Yuta kina Pebironi mari ibabute wanta, pi a'waipa pabiyama 14 puntiye. Piya, pi kanabisa aboraurite kanauguna Karaisiti aboranti, pi a'waipa pabiyama 14 puntiye. ");
INSERT INTO for_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Isu Karaisiti aboranti, pi agowapa mayama waintiye: Mariyaba Yosepeka maekiyema utatauguna, kampa atokaema isiyota isiyota puma mintusuguna, Aota Awamusa'ama Mariyati tumima ao'maeyogana yagara aga'e pogini agantawe. ");
INSERT INTO for_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Piya pogana, kana utatanta yagara Yosepeba arupu yagara miyomeka mayama napintiye: Naeba kamana'wa pagusama otakana ani pusanaga uwa kakamagi kaikuwema, napintiye. ");
INSERT INTO for_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Piyama napima mintogana, Wa'egawamatisa enisore ka'waina amonta tumpa patama maya omintiye: Yosepe, kaeba Tebiti ntagaramaga, wayaka Mariya maekenagaba karuba a-po. Yagara aga'e pemipa, pipa Aota Awamusa'ama esegi potama aboramiye. ");
INSERT INTO for_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Pigoya, masinto yakari potakanaba, ae ageba: Isuwe, pipa kamanatepisa Tau'ikena yagarawe, omo. Piya, aeba aokina'wapa aguntaenawaipisa i'ima aogi puwaitakiye. ");
INSERT INTO for_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Pigoya a'ya'waemaena aborantikana, paipa poropete ka'waina Wa'egawama nkawamutasa maya kamana untiye: Abiyo. Age'aragawae ka'waina aga'e pumagina, masinto yakari pekiripa, agewapa Imanuweriwe ukibewe. Pipa kamanatepisa: Kotiba taege mintiye ukibewe, untiye. Poropete piya kamana unti, pi au'wa aborantiye. ");
INSERT INTO for_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pigoya, Yosepeba awaibintisa aogamagina, enisorewama kamana omome pi wasimagina, anarimpa kayone potama ababuntiye. ");
INSERT INTO for_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pigoya, waya'waenaba kampa puma mintusuguna yagaraba aborantiye. Piya pogana, Yosepeba ae ageba: Isuwe, omintiye. ");
INSERT INTO for_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Pigoya, Eroti pi mparasa wa'ega yagara mintogana, Isu aeba Petariyamu kumata Yutiya mara aborantiye. Pigoya pi kanabipa, pa nkirosa'mitisa to marisa nori aisuma aganta kina'mi Yerusaremi kumata ampa irosa'ma, ibigama maya untawe: ");
INSERT INTO for_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Yuta kina tige aoso Wa'ega ae kumata aboraye. Taeba maroti maretisa yakari potanti noriwa agategi, ampa ae agisabi parokaema ta'mu potakena kanaune, untawe. ");
INSERT INTO for_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Piya yuguna, wa'ega yagara Eroti abima pami pogini, a'ya'ma Yerusaremi kuma ago kina igebe pami puguna, ");
INSERT INTO for_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Eroti aeba a'ya'ma tabe mono kiye kinape mono tisa kinape igega'e yogini aki puguna: Karaisiti yagaraba, ae kumata aborakiyema untanema, ibigaogini, ");
INSERT INTO for_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","maya omintawe: Yutiya mari Petariyamu kumatane. Pika Kotitisa kamana abima uwaimikena poropete ka'waina mayama kaemarantiye: ");
INSERT INTO for_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Petariyamu kuma Yuta mari, kaeba Yuta kuma ai'ne tuminta kumapa kampaye, iye. Kaetisa kiya yagara ka aborama, Isureyo naokina kabiwaitakiyema, kaemarantiye untawe. ");
INSERT INTO for_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Piya yuguna abite, Erotiba nori aisunta kina ibira igega'e umagina, pi nori aborantika pasema ibigaogini omuguna: ");
INSERT INTO for_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Petariyamu kumati waiyema, uwaitama maya untiye: Tigeba wama esegima uma aguyosa'ma, kana yagaranto aboratate kanama unamigi, pabiyama naeba wama na'mu potamagi agisabi parokaekuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Kana wa'ega yagarama piya uwaimogini abite wantawe. Ke'i wantini maroti mawaitisa nori aganta, pipa pabiyama to kake aboraogini agaurite wauguna, kana yagaranto mintome ntamankama abobora esegima waintantiye. ");
INSERT INTO for_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Piya pogini, igeba nori agate tabera i'muntanaba puntawe. ");
INSERT INTO for_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Piya pumagini, namapinti ima yagarantobe anowampa Mariyape isigama, irakabima ae ageba asaga'yuma, kotawaipisa i'muntanaba maema aisa potamagini, kori yabape, aogi agunta kagupe, tusa masawaepe amintawe. ");
INSERT INTO for_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Piya puguna, Wa'egawama amonta paitama akayuwaitaogini, igeba Erotiti kampa a'wae puma wanta, to ki'i wama mawaiti wantawe. ");
INSERT INTO for_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pigoya igeba a'wae puma wauguna, Wa'egawamatisa enisore ka'waina Yosepe amonta patama, kamana maya untiye: Kaeba asima, yagarantobe anope isibabute Isipi mari tiyegaka wama, nae kamanaka agawa puma miyiyo. Abo. Eroti aeba yagaraga aguyosa'ma aegukena piya, ababute wagaso, omintiye. ");
INSERT INTO for_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Piya omogana, Yosepeba asima yagarantoke anoke isibabute aseka Isipi mari pai'ma wamagini, ");
INSERT INTO for_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","pita'i umintuguna Eroti purintiye. Piya, poropete ka'waina Wa'egawama nkawamupisa kamana maya untiye: Yagaranepa Isipi mari mintaka, kega'e yekana pita'isa kanakiye. Pi kamana'ama esegi puntiye. ");
INSERT INTO for_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pigoya, nori aisunta kina igeba Eroti ikabitate wauguna, agowa abite agobipa tabera puntiye. Piya pumagina irebu kina uwaitaogini, igeba wama Petariyamu kumatasabe awamori kuma'antontorasabe, masi yagara kabowaipa tara kampa punta yagara, igepa a'ya'ma iyeguntawe. Pipa nori aisunta kina ige iwamupisa kana yumesa puma, pabi kana yagara iyeguntawe. ");
INSERT INTO for_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Pigoya, pika poropete Yeremaya kamana maya unti, pi'na esegi puntiye: ");
INSERT INTO for_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Arama kumatasa ka kamana abogini, tabera intara'ena puma kube'ena puguni abewe, iye. Areseriba araga yagarawa aegugasumeka iguyosakate tabera kube'ena pekini, aurikena pugagate atakibewe, piya unti'na esegi puntiye. ");
INSERT INTO for_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pigoya, Eroti pu'waogana, Yosepe Isipi mari miyogana, Wa'egawamatisa enisore ka'waina amonta patama maya omintiye: ");
INSERT INTO for_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Yagara aegukena punta kinapa ago pu'wawe. Kaeba asima, yagarantobe anope isibabute Isureyo mari waiyoma, omintiye. ");
INSERT INTO for_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Piyama omogana, Yosepeba asima yagarantoke anoke isibabute Isureyo mari wantawe. ");
INSERT INTO for_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pigoya, Akereyasi aeba abawampa Eroti mparupa maema Yutiya mara kabinti, pi kamanapa Yosepe abitegina, pita'i wama umikenagaba karu puntiye. Piya pogana, Wa'egawama amonta ki'isa kamana uma aboramogana, pimpa atate Karariya mari wama, ");
INSERT INTO for_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ka kumapa, agewapa Nasareti, pita'i wama umintantiye. Piya, Karaisitika poropete kina'mi: Ae agewapa Nasareti yagarawe ikibewe, unta, pi'na esegi puntiye. ");
INSERT INTO for_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Pigoya pi kanabipa, Yoni wani pai'itanti ntagara, Yutiya mari aborama ka'me mpari umima, mono maya untiye: ");
INSERT INTO for_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Koti kabiratakenaena agarosaya, aguntaenaripa kaite tigu a'wae piyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Pigoya, pi ntagaraga poropete Aisaya maya unti, pipa aborantiye: Awaga kamana ikena yagara ka'me mpari mima, kega'e uma mayama aboraye: Wa'egawamanta ke i'ma arupu puma amuyena piyo, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pigoya, Yoniba kaiwapa kamoro yaga ayatasa pumaranta, pi ami u'magina, arirasa kante puma abamu kimagina, nanintawapa iroke tuke nama mintantiye. ");
INSERT INTO for_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pigoya, Yerusaremi kumatisabe Yutiya marisabe Yontani waninkama maroteri materi miyume kinape, a'ya'ma aeti wawaentawe. ");
INSERT INTO for_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Piya pumagini, aguntaena pume kamana'waipa uma aborauguna, Yontani anompapi pai'itantiye. ");
INSERT INTO for_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pigoya, uwoma Parasi kina'mibe Sarusi kina'mibe mono wanika irosauguna, Yoni igate maya uwaimintiye: Tigeba kuya awarorawe. Kotitisa amo'ena aborarimekiri kakagaisanaga kebaya urimegiri mata'i kanawe. ");
INSERT INTO for_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Tigeba aguntaenaripa kaitegiri tigu a'wae pigina, mono a'wapa aboraigiriba, wani kanara maekibewe. ");
INSERT INTO for_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pigoya, ti maete ikenaba a-puma: Taeba Abara'amu nkaga'nuraga aogima mikunemagiripa, a-siyo. Pabigo urimekiri abiyo: Kotiba ma ntabatasa Abara'amu nkaoso aga'nugi iba pikenaba agantiye. ");
INSERT INTO for_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Piya, ya agaiyukena tupa ya agobi atantiye. Pi ntawama a kampa aogima aeyakanapa agaiyuma yakupi kaekiye, Yoniba meto kamana piya untiye. ");
INSERT INTO for_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Piya untana to maya untiye: Naeba tigu a'wae piyoma wanitasa paititauwa, naka'i kanakibi ntagara, agewapa asunagasima waintika, naeba mayamanaba agisa anapa kampa arakae potakuwe. Pi ae Aota Awamusatasabe yakutasabe paititakiye. ");
INSERT INTO for_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aeba aka maete kanama, witi naninta ampa aigaga pumagina, anonkapa namapi atantana, ariwapa tayaba yakupi kaegaikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Aibogana, Isu aeba Karariya marisa Yontani waniti kanama, Yoniti aborama: Mono wani pai'natanema, omintiye. ");
INSERT INTO for_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pigoya, Yoniba abitegina kunta puma maya untiye: Ayamabaya kaeba naeti ampa piyama yene. Kaeba nae pai'natagana kanara pikiye, untiye. ");
INSERT INTO for_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Piya yogana, Isuba kamana mayama a'wae puma omintiye: A'a-o, ibaba pai'natao. Piya pekara, tasigeba Koti kamana aogima wasikuse, untiye. Piya yogana Yoniba abitegina pai'atantiye. ");
INSERT INTO for_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Pigoya, Isupa pai'ataogana aeba Yontani wanipintisa iyogana, manta kabi a'waiyogana, agaomepa Koti Nkawamusa'ama pupunta kanta purite aeti tumpintiye. ");
INSERT INTO for_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tumpintogana, mantabintisa kamana ka maya untiye: Mepa nabugai ntagaranene. Tabera na'mu potauwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pigoya, Awamusa'ama Isu ka'me mpari ababute wama, kewama amiyo potakenaga ababute wantiye. ");
INSERT INTO for_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pigoya, Isuba pita'i nanintaga a'a-o uma, 40 yaga uwa miyogana aga'ena abuntiye. ");
INSERT INTO for_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Piya pogana, amiyo pikena agowama aeti aborama maya omintiye: Kaeba Koti Ntagara mintanapa, yegana ma ntabankama paretiyena pekana nao, untiye. ");
INSERT INTO for_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Piya yogana, Isuba antota maya untiye: Mono isa'ama maya iye: Wasanama nanintarasa kampa a'ya'ma esegiyenawapa maekiye. Koti nkawamupisa mono pi abima esegiyenaba maekiye iye, untiye. ");
INSERT INTO for_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Piya yogana, kewamaba Isu Yerusaremi kumati ababute ima, tabe mono nama nkagari mesutama, ");
INSERT INTO for_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","maya omintiye: Kaeba Koti Ntagara mintanapa, pa'yo puma tumo. Piya, mono isa'ama maya iye: Koti aeba enisore kina'wa uwaitakini kabigatakibewe, iye. Piya, kaegukena pikibipa, iyatasa kababute tumigina, yabankamaba kagisaba kampa airisakiye iye, untiye. ");
INSERT INTO for_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Piya yogana Isu maya omintiye: Pigoya, mono isa'ama to ka maya iye: Wa'ega Kotigapa amiyo puma agakenaenaba a-po iye, untiye. ");
INSERT INTO for_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Piya yogana, kewama to ababuma e'ero nkamuti ima mesutamagina, a'ya'ma mampabisa kumape igaenabe ayakimagina, ");
INSERT INTO for_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","maya omintiye: Nae nagisabi ampa parokaema nageba asagayuyegapa, a'ya'waema waintintanaba kamiwaekuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Piya yogana Isu mayama omintiye: Satani, kaeba natate wagaso. Mono isa'ama maya iye: Wa'ega Kotigapa, ae age asagayuma, ae abiwa kayokaya'ena potao iyema, omintiye. ");
INSERT INTO for_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Piya omogana kewama atate waogini, enisore kina igeba irosa'ma aogima kabitantawe. ");
INSERT INTO for_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pigoya, Yoni araku'ma iga'na namapi atauguna mintogana, Isuba pi awaga kamana abitegina, pimpa atate Karariya mari wantiye. ");
INSERT INTO for_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Wamagina Nasareti kumapa agaite Kapaniyamu kumati umintantiye. Pi kana kumapa kotu awamori, Seburonige Napitaraige isiga'nu mpara umintantiye. ");
INSERT INTO for_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Piya pogana, pintanaga poropete Aisaya maya unti, pipa au'wa aborantiye: ");
INSERT INTO for_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Seburonige Napitaraige isige mari, kotu awamori, Yontani waninkama maroteri waintipa, To marisa kina'mi ampinta mpa, Karariyawa, ");
INSERT INTO for_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Pita minta kina'miba tununtanabi miye'nagiba tabe e'wasaena agawe, iye. Piya, purikena puma miye kina'miti e'wasa aboraye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pigoya, pi ntagaba Isuba agobima mono untana, maya uwaimintiye. Koti kabiratakenaenaba agarosaya, aguntaenaripa kaite tigu a'wae piyo, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pigoya, Isu aeba Karariya kotu awamori wama nasi nasi puntana, tara yagarara isigaomepa, kapa Saimoni to agiwapa Pitabe, a'nantowampa Enturube, isigeba inoyanta aebusume ntagararaginisi, kotupinti kuko aibarekima wanipinti motausuguna, uma isigantiye. ");
INSERT INTO for_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Piya uma isigate maya uwaisimintiye: Naegaraiso. Inoyanta aeyamesa puma wasana iba pikenaena tisiyakikuwe, uwaisimintiye. ");
INSERT INTO for_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Piya uwaisimoginisi, pabigo kuko'waisipa atate aegarantase. ");
INSERT INTO for_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Aubusuguna, Isu to nasi nasi puma to tara yagarara isigaomepa, Sepeti ntagara Yemisige a'nantowampa Yonige, isibawaisimpa Sepetige wanipisa karebi mima, kuko aogi puma mintuguna, ampa isigantiye. Pigoya, Isuba isigega'e yoginisi, ");
INSERT INTO for_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","isibawaisimpa pabi wanipisa karebi atate, Isu aegarantase. ");
INSERT INTO for_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pigoya, Isuba Karariya mari ainkima nasi nasi puma, ini namankaipinti ima mono kamana umagina, Koti kabiratakena kamanapa uwaimagina, yoni kinape i'ama kampa aogi punta kinape kaba itantana puwaentiye. ");
INSERT INTO for_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Piya pogana, awaga kamana'ama Siriya mari abae purite wagana pogini abite, yoni kinape, iki nakiyena ibome kinape, ke kina intabaipinti minta kinape, aonanta puma ware'naowa pume kinape, kebo kinape, aeti a'ya'ma ibabute wauguna aogima kaba itawaentiye. ");
INSERT INTO for_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Piya pogini, Karariya marisabe, Tekaporisi kumatisabe, Yerusaremi kumatisabe, Yutiya marisabe, Yontani maroteri materisa tabe uwoma kina aki puma aka'i wantawe. ");
INSERT INTO for_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pigoya, Isuba uwoma kina igate, amuti ima asu mintogini, abagi kina'wa agora wauguna, ");
INSERT INTO for_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","mono maya uma uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Igu'amaka abegana kusi miye kina, igepa Koti kabiwaitakini i'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Intara'enabi miye kina, igeba aintiba mantarasaena intawama asoyaena pekini, i'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Agoya puwaita kina, igeba aintiba aogi kumapa maema mimagini, i'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Iga'ena ibemi kina, igeba naninta wanika ibemisa puma Koti nkarupuyena ibemi kina, igeba aintiba iga'e pakini i'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","To kina'mika intara pe kina, igepa aintiba Koti antara puwaitama iyo'maeyakini, i'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Aguntaena kampa napiye kina, igeba aintiba Kotipa agamagini i'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","I'ima paru puwaita kina, igeka Kotiba: Yagara araganene uwaimekini, i'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Arupuyenaraka karana puwaitagini miye kina, igepa Koti kabiwaitakini i'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Pigoya, naeka wasanami kamparaga kamana uritama, karana puritama, agunta kamana uma kumpari uritagiripa, aintiba ti'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Piya, tigeba aintiba aogi ikantanaripa mantariba taberaka'yane. Pika ti'mu puma tinta asoya puma miyiyo. Paipa wasanami poropete mintanta kinapa pabiyama karana puwaitantawe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Tigeba wasana ikapi mimagiri, kayo kanta puma mintawe. Pigoya, kayo i'nisama kasigabekapa, aya pekana to kake asabama iga pikiye. Pipa kampaye. Piyaena pikenaba kampa waintiye. Uwa asunu kaegasagini, wasanami pita'i nasi nasi puma aeyese pewe. ");
INSERT INTO for_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Pigoya, tigeba wasana ikapi kane kanta puma mintawe. Piya, kuma ka amuta abora waintakanaba, asekapa e'wasaenawapa a'ya'ma wasanamiba agakibewe. ");
INSERT INTO for_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pigoya, ka'waina kane igi'magina kampa kankabe maema airari kaetantana, marunkata igi'ma atakana, nama nkantabaipinti e'wasaba a'ya'ma kina puwaitakiye. ");
INSERT INTO for_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tigeba etimpaba pabiyama wasana e'wasa puwaitano. Igeba aogima mikenaenari agaigina aogi pekini, mantari tibarimpa nkage asaga'yuyewo, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","We, paisa ago kamanape poropete kina'mi kamanape kaikena aborantiyeba, naekaba a-siyo. Naeba kaikenaba kampa aboramagi, naeba to wasima abae pikenaba aborauwe. ");
INSERT INTO for_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Naeba taga urimekiri abiyo: Mage mantage waiyemisa puma, Koti nkago kamanapa uwa waikiye. Ka awa'enaba kampa kakawakibikana, uwa waikiye. ");
INSERT INTO for_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pigoya, wasana ka'waina Koti unti kamana ago uwaenanto ka kasimagina to kinakaba: Piyama kasiyema uwaimikibi'naba, ae ageba uwaenanto Koti kabiratakibi ntagaba waikiye. Piya, ka'waina aeba a'ya'ma wasimagina to kinakaba: Piyama poma uwaimikibi'naba, aeba pabiyama Koti kabiratakibi ntagaba tabe yagara ima mikiye. ");
INSERT INTO for_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pika urimekiri abiyo: Arupuyenarimpa kampagina mono tisa kina'mige Parasi kina'mige arupuyenawaimpapa igaikibipa, aintiba tigeba Koti kabiratakenaenabipa kampa uma pasikibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Pigoya, tayabamagi kamana maya uwaimintiye: Kaeba wasanaba a-nkaeguma kaiyo. Ka'waina wasana aeguyekiripa, kamana abikena kina'miti ababute wama metaiyo, paisa kamanapa piyamagiri abewe. ");
INSERT INTO for_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Piya, naeba to urimekiri abiyo: Ka yagaramaba ao'yagaraga agobi potakanaba, pika kamana abikena kina'miti ababute wama kamana otakiye. Pipa kanarane. To waina aeba ao'yagaraga kamparaga kamana uma: Kani po omekiniba, ababute kanisore kina'mi akiyenabi metakibewe. Piya, to ka'waina aeba ao'yagaraga: Aibo yagaragawe omikibi'naba, a'abibintisa yakupi wao, omikiye. Pipa kanarane, piye untiye. ");
INSERT INTO for_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Pigoya, kaeba ka'muntana tabe mono namapinti maete ikena puntanapa: Nao'yagaramage kamanatesi waintiye, piyama napintanapa, ");
INSERT INTO for_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","pabigo ka'muntanaba arata agora atate tumima, wama kao'yagaramage kamanatisipa uma aogi pugaite, a'wae puma ima ka'muntanaba Kotiti aratarapa mesutagana aogi peno. ");
INSERT INTO for_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Pigoya, tigetisa ka'waina kamana ugatakanapa, kamana abikena kina'miti kampa uma irosanta ke'i wantirisi, pi ntagaramage kamanatisipa uma aogi piso. Piya kampa pikibempepa, ugatakibi ntagaramaba karu'ena abikena kina'miti wama agoga yekana, abikena yagarama irebu kina'wa uwaitakini, iga'na namapi katakibewe. ");
INSERT INTO for_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Naeba taga ugamukuwa, abo. Kaeba pi nkiga'na namapi mintanapa, uwaba kampa irosa wakibene. Aintiba iretaba amima a'ya kaite, wakibene, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Pigoya, kamana paipa maya uwaimintine: Kumiyenaba a-po. Pi kamanapa abintawe. ");
INSERT INTO for_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pigoya naeba urimukuwa, abiyo. Ka yagarama to wae ka'waina agama agabakibipa, ae aumawama Koti nkaobi ago ata puma kumiyenaba potaye. ");
INSERT INTO for_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pigoya, ka kaowama aguntaena pikena pekanapa, pi'ma maebugaso. Tarayaga kao waintakanapa kaeba a'abibinti tumisanaga, aogima kabiyo. ");
INSERT INTO for_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Kayatakantisa aguntaena pikena pekanapa, arisa'ma maebugaso. Aogi kiyenayaga waima kaeba a'abibinti tumisanaga, aogima kabiyo, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Pigoya, paipa to kamanapa mayama uwaimintiye: Ka'waina waya'wa kaikena puntanaba, kaikena awa'ena amimagina otano, untiye. ");
INSERT INTO for_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pigoya, naeba urimukuwa, abiyo. Ka'waina waya'wampaba kupiyonaba kampa puntakana uwa kaikibipa, aeba ata potakana, karu'ena kumiyenaba pikiye. Piya, to ka yagarama kainta wae maekibipa, aebe kumiyenaba pikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Pigoya, tayabamagi to ka maya uwaimintine: Kaeba Koti nkaobi atamaba kumpari kamanapa uma esegiba a-po. Piya, ae aobi uma esegi pumaba wasiyegana, au'wa aborano, untine. Pi paisa kamanapa piyamagiri abewe. ");
INSERT INTO for_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Naeba pika urimukuwa, abiyo. Koti nkaobi uma esegi pentanaba ataiyo. Piya, mantara uma esegiba pipa a-piyo. Mantaba pipa Koti nkaemu yabaewe. ");
INSERT INTO for_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Piya, mara uma esegiba pentanaba pipa a-piyo. Maba Koti nkagisa aema miyemi mpawe. Piya, Yerusaremi kumata uma esegiba a-piyo. Yerusaremiba tabe Wa'ega Yagarama kumane. ");
INSERT INTO for_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Piya, ti'no nkabiyata uma esegiba a-piyo. Tigeba antugu ti'nu nkabiyema ka omigina, tunu pikibera, to ka omigina wae'wae pikiyo. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pigoya, pika kamanatipa tagaka owe uma, pabiyama aegaraiyo. A'a uma, pabiyama aegaraiyo. To nara uma esegi pukibepa, pi kamanapa ke kinapisa aboraye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Pigoya, paipa kamana maya untine: Ka'waina kaoga airikakanapa, antota airikao, iye. Piya, kawa aibarara pekanapa, antota aepa pabiyama aibarara po, untine. Piya kamana abintawa, ");
INSERT INTO for_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","pika to kapa naeba urimukuwa, abiyo. Tiyeguma karana titakena pigiripa, antotapa a-nkataenaba puwaitaiyo. Pika ka'waina katamara kaeguyekanapa, to ka auka'i a'wae puma amo. ");
INSERT INTO for_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Piyamaba, to ka'waina kae kamana ugatamagina siyotiga maeyakanapa, mu'mu siyotigapa kaga amo. ");
INSERT INTO for_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Piyamaba, ka kiye yagara agaro ki'i nababute waoma ugamekanapa, kaeba e'ero ki'i ababute wama ao'maeyo. ");
INSERT INTO for_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Piyamaba, to ka'waina ka'enaga esugatakanapa, amo. Piya, a'yo ukatakena yekanapa, owe otao, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Paisa kamana ka mayama waintiye: Kaeba kaokina agu kao'ena potantana, kama kinakaba kagobi potao, untiye. Pi kamanapa abintawe. ");
INSERT INTO for_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pika naeba urimukuwa, abiyo: Kama kinatipa agu kao'ena puwaitantiri, karana purita kina igeka napima nunamu yiyo. ");
INSERT INTO for_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Piya puntiripa, mantarisa tibarimpa ntagaraena puma mikibewe. Piya, Koti aeba yegina, pankamaba agunta kinape aogi kinape kaga e'wasa puwaitaye. Pabiyama yegina, kaba arupu kinape antage kinape kaga kanara tiyeye. ");
INSERT INTO for_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tigeba agu kao'ena purita kina, ige'amana agu kao'ena puwaitaiginaba, aintiba aya iretaripa Kotiba timikiye. Pipa kampaye. We, takisi maenta ku kina'miba piyaba puwaitawe. ");
INSERT INTO for_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Piya, to marisa kina'miba iyokina aogi puwaitawe. Tigeba pabiyama tiyokinapa aogi puwaitantiripa, ayama igaikibewe. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Abiyo. Tigeba mantarisa tibarimpa aota miyemisa puma, pabi nkawameta miyiyo, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tigeba aogima kabiyiyo. Aogiyena puntiripa, tipa wasanami nkiyobipa a-mpaete iyiyo. Piya pukibepa, mantarisa tibarimpatisa ka ikantanaba kampa maekibewe. ");
INSERT INTO for_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tigeba wasana kao'ena puma awagaena puwaitantiripa: Ka'isa kina'mi tagama i'mu purataiyemaba, taberasaba a-kega'e yiyo. Piya, kumpari mono kina igeba ini namapipe uwa ke'ibe: Tage maete ima i'mu puratayema, wasana kao'ena puwaitawe. Naeba tagaka urimuwe. Piya kina'miba wasana i'mu puwaita nkikantanawaipa ago maerekana, aintiba toba kampaye. Ige pesa puma a-piyo. ");
INSERT INTO for_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pigoya, kusi kina kao'ena puwaitaganaba, ka kaentisa kina'ma pukibintanaba to kaentisa kina'miba a-nkabiyo. ");
INSERT INTO for_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Piya peganaba, kao'enagampaba kakama waigatagina, kabagampa a'ya'maena kakama waintintana agamagina, antotapa kamikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Pigoya, tigeba nunamu ukena puntiripa, kumpari kina'mi yesa pumaba a-siyo. Pi kina igeba ini namapipe ke'ibe nunamu yepa, pipa: Wasanami tagama i'mu purataiyema, piyaba pewe. We, naeba tagaka urimuwe: Piya kina'miba au'wapa ago maentaka, toba kampa maekibewe. ");
INSERT INTO for_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Piya, kaeba nunamu ukena puntanapa, namakapinti ima kabe kitama kabagampa kakama miyemi'na aeti nunamu yo. Piya pegana, kabagampa kakama agamagina, antotapa kamikiye. ");
INSERT INTO for_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Pigoya, tigeba nunamuba uwa tiwamutasa urite wagana pumaba a-siyo. Pipa to marisa kina'mintanawe. Pi kina igeba uwoma kamana aisurite wagana pekana: Koti abiramikiyema, yewe. We, pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tibarimpapa kampa esotantagana, aeba agoripa ago abiwaeyagiri, tigeba ige yesa puma a-siyo. ");
INSERT INTO for_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pigoya, tigeba maya uma nunamuba yiyo: Taba, mantabinti mintane. Kae kage aota waiyeno. ");
INSERT INTO for_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kae kabiratakenaenagapa aborawaeyano. Mantari kae kawamu aega'ma wasikenaena waintemisa puma, pabiyama mabi taeti aborano. ");
INSERT INTO for_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ibaba kaeba nanintarepa tae awameta tamo. ");
INSERT INTO for_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tao'mi kaintanawai nkatupa mae igasompe nkawameta kaintanare nkatupa maeragaso. ");
INSERT INTO for_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tamiyo pusanagaba aogima kabiratao. Kewama nkayapisa taba puratao, piya nunamu yiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Piya, tigeba wasanami nkaibo'enawaipa kasiginaba, mantarisa tibarimpaba pabiyama tige'enaba maerigaikiye. ");
INSERT INTO for_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Piya, tigeba wasanami nkaibo'enawaipa kampa igasiginaba, tibarimpaba aibo'enaripa pabiyama kaga kampa maerigaikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Pigoya, tigeba monoka naninta a'a-o uma mintiripa, tiyowa muruse puma a-mpiyiyo. Piya, kumpari mono kina'mi ige piya pegana, wasanamiba ige naninta a'a-o uma miyentanawai igabebe piyema, iyowawamaba ataena pegini miyewe. Pigoya, ige pesa a-piyo. Naeba tagaka urimuwe: Igeba ikantanawaipa ago maentane. ");
INSERT INTO for_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Piya, kaeba naninta a'a-o uma mintanapa, ka'noti masawae pai'ma kaowaena po. ");
INSERT INTO for_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Piya pegini, wasanamiba naninta a'a-o uma miyempentanama nkagogapa kampa agabebe pegana, kabagampa kakama miyemi, ae abintowa abeno. Piya pegana, kabagampa kakama agamagina antotapa kamikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Pigoya, tigeba mampabi a'ya'maena aogiyenaba a-mpaema aki piyo. Kampaye. Mampabipa umuwama narigagina kasipama ataena pegina, ku kina'mi agasaba'ma kuntana pewe. ");
INSERT INTO for_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Piya, tige'ena aogiyenaripa mantari aki piyo. Pita'iba umuwamaba kampa narigakanaba kasipama ataenaba kampa pekini, ku kina'miba agasaba'ma kuntanaba kampa pikibewe. ");
INSERT INTO for_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Piya, aogiyenaripa waintemi, pi kumakaba asi nasi napiyewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Pigoya, kau'ama kane'wapa kaowe. Kaogapa aogima waintanaba, kau'amapa kanara e'wasa potakiye. ");
INSERT INTO for_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kaoga tikaeyakanaba, kau'amaba pabiyama tunusu wakiye. We, kagu'ama kane'wa tu'ma wakanapa, tabera tununtanaba aboragamekana kaorika'ena puma mikibene, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Pigoya, ka yagarama tabe yagararamisi kayokaya'enaba kampa kanara pikiye. Aeba ka'wainapa kayone potantana to ka'wainapa agama aekita potakiye. Piya pumagina, aeba ka'wainati uma atokaentana to ka'wainapa akabitakiye. We, tigeba pabiyama Koti ntugabe mone kutankama ntugabe ka awameta kanara kampa maekibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Pigoya, naeba urimekiri abiyo: Tigeba mikenaenarikaba: Nana nanintabe wanipe maema nakune. Tau'amakaba: Nana tautasaena maema purukunema, uwoma tigiba a-ntapiyiyo. Piya, naninta wanane. Mikenaenarimpa au'wantaga'enawe. Titasaena wanane. Ti'ama au'wantaga'enawe. ");
INSERT INTO for_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Piya, tigeba inatisa kabara agaiyo. Igeba aintanaba kampa puma nanintaba kampa kubu'ma namankaipi kampa aki pewe. Kampaye. Mantarisa tibarimpa nanintaba uwa aborama imiye. We, tigeba kabarapa kampaye. Ae aobipa tigeba wasanarawe. ");
INSERT INTO for_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Pigoya, tigeba napiyenari waintakiripa mampara to kake amato puma to ka'isa yaga mirite wakibewa, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Piya pikenaena kampa waintegiripa, nana piyema kaigaba uma uwoma tigiba napiyewe, a. We, yaobisa ya aosa pamika agoba abiyo. Aeba aotasaenawampa ntugaba kampa piye. ");
INSERT INTO for_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pika urimukuwa, abiyo: Paipa tabe yagara Soromoni aeba konariyenawantaga yagaramaba aogiyenaba purintomepa ya aosawamapa kampa againtiye. Kampaye. ");
INSERT INTO for_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Piya, yaobintisa a'no ibanto pabiyama aogima mparamagina, aiba pabigo paribekini yakupi maema kaekibepa, pipa Koti yegina a'nopa aogiyena maraye. We, tigeba kampa agama napiyegana timatiti'enaba uwaenantowe. Piya, Kotiba titasaenarikaba kabiritaye. ");
INSERT INTO for_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pigoya, tigeba uwoma tigi a-ntapimagiri: Nana nanintabe wanipe maema nakune. Nana maema amirikuneba, taberapa a-siyo. ");
INSERT INTO for_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","We, to marisa kina'miba a'ya'maena yontanaga napi napi pewe. Piya, mantarisa tibarimpa pi a'ya'waemaenarikaba abintegiri, uwoma tigi a-ntapi piyo. ");
INSERT INTO for_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pigoya, tigeba Koti kabiratakena mono'ama nkau'wape arupuyenawape aborasanaga tigupa paitama ataigina waiyeno. Piya pigina, aeba mampara a'ya'maenaripa kaga aborarimikiye. ");
INSERT INTO for_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tigeba aisaenagaba uwoma tigiba a-ntapiyiyo. Aisa yagaba nana kuntuyenabaya aborakibi, pipa kampa abintawe. A'ya'ma yagaba kuntaenaba toma toma aboraurite wayema, pabinkanto uwa napiyegana waiyeno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Tigeba to wasanama aupi pima kamana a-nkuwaitaiyo. Kampa uwaitakibepa, tigeba pabiyama antota kamanapa kampa uritakiye. ");
INSERT INTO for_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Piya, tigeba wasana antota kamana uwaitakibe, pabi nkawameta Kotiba tigeba uritakiye. Piya, wasana pabi aborawaimikibe nkawameta Kotiba a'wae puma timikiye. ");
INSERT INTO for_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Pigoya, kao'yagarama nkaobipa i'nintana waintakanapa, ayama agantana, kaeka kaobi ya atu waintakanapa, nanaga ae aogi potakenaga napiyene. ");
INSERT INTO for_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","We, kaeka kaobi ya atu waintemipa, kaeba ayama kao'yagaragaba mayaba omegana aogi pikiye: Nao'yagara, kaeba abintaga, kaobi i'ni waintika maegagasanoma, aogi pikiye. ");
INSERT INTO for_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","We, kumpari kina, kaeka kaobi ya atu waintemi, pipa maru maegaite aogima agantana, kao'yagarama nkaobisa i'ni maegasagana aogi pikiye. ");
INSERT INTO for_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Pigoya, tigeba monotasaenaba kara kanta kinapa a-nkimiyo. Piya, aogi mono kutatipa yaga kanta kinapa a-nkimiyo. Igeba pintanaba uwa igisarasa aewarigaitegini pabigo a'wae puma tige tiba nasanaga, piyaba a-piyo, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Pigoya, tigeba Koti abigaiginaba timikiye. Aguyosagaiginaba au'wapa maema tigeti aborakiye. Kabera aiwakarusiginaba Kotiba aititakiye. ");
INSERT INTO for_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Piya, Kotiti esota kina'miba maeyawe. Aguyosaga kina'miba agawe. Kabera aiwakaruse kina'mitiba Kotiba ai'itaye. ");
INSERT INTO for_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","We, tigetisa ae ntagarama yagarawampa nanintaga yekanaba antotapa yabapa amikiye, a. ");
INSERT INTO for_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Inoyantaga yekanaba kuyaba amikiye, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","We, tigeba antage kina'mitaba yagara aragaripa aogiyena imewe. Piya, mantarisa tibarimpa aeba asugasima esota kina tigepa aogiyenaba tabera timikiye. ");
INSERT INTO for_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pigoya, tigeba wasanami purataiyema tibikibintanaba, pabi nkawameta igepa puwaitaiyo. Piya puwaitamagiri, tigeba Moseseke poropete kina'mike kamana'ama nkagoba aborakibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Pigoya, tigeba uwaena kabintori mantari ima uma pasiyo. Ataena pikena kuma'ama kabewapa pipa tabewe. Piya ke'wapa pabiyama tabe waiyegini, pita'iba uwoma kina'miba pasewe. ");
INSERT INTO for_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Piya, miyaba kuma'ama kabewapa uwaenanto waiyegina, ke'wapa wakenaba esegi puntiye. Pita'iba uwaena kina'antomi pasewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tigeba kumpari poropete kina'mika aogima kabiyiyo. Igeba i'amaba sipisipi kanta purite tigeti paebuma kanakibewe. We, intabaipintiba igeba kabu kara kanta puma tige tiba nakena kanakibewe. Pika aogima kabima miyiyo. ");
INSERT INTO for_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pigoya, mono au'waipa agamagiri agowaipa aogima agakibewe. Piya, wasanami waini a'wapa akenanaenabintisa kampa asikewe. Piki yawamapa asigi'ma nakenaba agaenabintisa kampa asikewe. Kampaye. ");
INSERT INTO for_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Piya, aogi yawamaba aogi yamanka aeyagiri asikewe. We, ata yawamaba ata yamanka aeye. ");
INSERT INTO for_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Piya, aogi yawama ata yamanka aekenaenaba kampa waintegina, ata yawama aogi yamanka aekenaenaba pabiyama kampa waintiye. ");
INSERT INTO for_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pigoya, a'ya'ma yawama aogi yamanka kampa aeyaginiba aga'yuma yakupi maebugasawe. ");
INSERT INTO for_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pika naeba maya yuwe: Pi kina'mi mono au'waimpa igama agowaika aogima abikibewe. ");
INSERT INTO for_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Pigoya: Wa'egane, Wa'egane, sumagini nagise kina igeba a'ya'maginiba Koti kabiratakena mantariba kampa ikibewe. Kampaye. Mantarisa nabanempa nkawamu wasiye kina igemana ikibewe. ");
INSERT INTO for_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Piya, pi kanabipa uwoma kina'mi maya unamikibewe: We, Wa'egare, Wa'egare, taeba kae kawamutapa wasanaba monopa uwaiminta, ke kinapa kae kawamutapa agaruba igainta, kae kawamutapa tabena aboranema puntompene. Kampa tagantano, ukibewe. ");
INSERT INTO for_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Piya unamigipa, naeba maya uwaimukuwe: Naeba ayantaga tigabebe puntone, a. Aguntaena pe kina tigeba ae'wama wawaegasiyo, piya uwaimukuwema, untiye. ");
INSERT INTO for_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Pigoya, wasana ka'waina ma kamana'ne abima wasikibipa, aeba napi napi yagara ae awametane. Pi ntagara aeba namankapa u takaitasa nama kintiye. ");
INSERT INTO for_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kimaraogana waintogana, tabe ka aema wani pa'ma iguguya pumagina akasabakena pugagate ataogana waintantiye. Piya, esegi yarasa kimaraomeka tonkiya puma waintantiye. ");
INSERT INTO for_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pigoya, wasana ka'waina ma kamana'ne abima kampa wasikibi, aeba aibo yagara ae awametane. Piya, aibo yagara ka'waina aeba namanka amunta yarasa kintiye. ");
INSERT INTO for_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kimaraogana, tabe ka aema wani pa'ma iguguya pumagina kana namapa akasakasu pa'wantiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Pigoya, Isu ma kamana uma a'ya ataogini abimagini pami puntawe. ");
INSERT INTO for_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Piya, aeba mono tisa kina'mi yesa kamana nane. Aeba kiye kina'mi yesa puma uwaimintiyema, untawe. ");
INSERT INTO for_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Pigoya, Isuba amutisa tumogini uwoma kina'miba aegarantawe. ");
INSERT INTO for_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Piya puguna, ka karu yagara aeti kanama ampa parokaema maya uma omintiye: Kae kabemika kaba nayakena puntanapa aogi punatao, untiye. ");
INSERT INTO for_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Piya yogana, Isu aya parosuma auta u'ma maya untiye: Piyaenaga nabiye. Pabigo kata wakana aogima miyo, untiye. Piya yogana, pabi ntaga kana karuyenawapa ata wantiye. ");
INSERT INTO for_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ata waogana Isu maya omintiye: Uwa kinapa a-nkuwaimima, kaeba marupa wama kaupa mono kiya yagara uma ayakegana agano. Piya, kaeba wama Mosese uramintintanaba Kotiti amegini, wasanamiba kagate: Aoso yagara miyema, napikibewe, piya omintiye. ");
INSERT INTO for_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Pigoya, Isuba piya potategina Kapeniyamu kumati a'wae puma wantiye. A'wae puma waogana, Aroma kina'mi irebu kiye yagara ka'waina aeti irosa'ma maya omintiye: ");
INSERT INTO for_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Wa'ega yagara, kayokaya yagarane yonintana abegina agisa ayapa ago pu'waewamagina tabera aukegina mintiye, omintiye. ");
INSERT INTO for_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Omogana, Isu abite: Naene ima kaba atakuwe, omintiye. ");
INSERT INTO for_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Piyama omogana, irebu kiye yagara aeba maya untiye: Wa'ega, naeba tumima minta kina mintogana, nana pegina namantepintiba ubasikibene. Kaeba pita'i uma mima kamana yegana kayokaya yagaranepa kabareno. ");
INSERT INTO for_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Piya, naeba ima minta kina'mi nkiwamu wasimagi, to ka'isa tumima minta irebu kina'nepa kabiyuwe. Piya, igetisa ka'wainapa: Wao, omekanaba wakiye. To kapa: Kanao, omekanaba kanakiye. Kayokaya yagarane: Pi ntuga po, yekanaba pikiye. Piya, kiya kina'mi yosa kamana yeganaba ata wano, untiye. ");
INSERT INTO for_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Piya yogana, Isu pi kamana abima napi napi puntana, aega'ma kanaume kina maya uwaimintiye: Taga urimekiri abiyo: Isureyo kina, tigetiba ma ntagarama nkamatiti'ena piya awametapa kampa agauwe. ");
INSERT INTO for_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Pika amato puma yekiri abiyo: Pankao irosamitisabe tupasemitisabe wasanaba uwoma namu'isa kina irosa'ma, Abara'amu, Aisaki, Yekobu, igege mantarisa kumati aki puma naninta kaga nama i'mu pikibewe. ");
INSERT INTO for_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Piya pigiri: Taeba Yuta kina, mono ago kina mintune, ye kina'mitaba, tigeba tununtanabi tumima tiwara upaba puma kube'ena puma mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Isu piya ute, irebu kina'mi kiye yagara maya omintiye: Kaeba wao. Kamatiti'enagampa au'wapa aboragamikiyema, omintiye. Pigoya, kana kayokaya yagarawapa pabi ntaga kaba'ma aogi puntiye. ");
INSERT INTO for_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pigoya, Isu Pita ntamapi iyomepa aentawampa nkau yaku taogana awaita mintogana agantiye. ");
INSERT INTO for_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Agate ayata urogana yoninkapa pabigo ata wantiye. Ata waogana, kana wae'maba asima naninta maema Isu amogana nantiye. ");
INSERT INTO for_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aibogini, asenamaita ke kina intabaipinti minta kinapa uwoma ibabute kanagana puntawe. Piya puguna, Isuba ke kina'waipa kamana'watasa igarubantana, a'ya'ma kina'mi nkinuntanawaipa kaba itantiye. ");
INSERT INTO for_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Piya pogana, poropete Aisaya kamana mayama kaemaranti, pi'na esegi puntiye: Aeba anuntanarepa taparintana yonintanarepa aesagabintiye, piyama kaentiye. ");
INSERT INTO for_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Pigoya, uwoma kina'miba aeti kanama ampa ainkiyuguna igate abagi kina'wa: Kotu maroteri wakunema, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Uwaimogini wakena puguna, mono tisa yagara ka'waina agora wama maya omintiye: Tisa, kaeba pita'i mata'i wakena yegapa naeba kaegarakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Piya yogana Isu maya a'wae pomintiye: Kabu kara igeba age'waintaga waintiye. Piya, inatisa kabara igeba ina'waintaga waintiye. We, Wasanama Ntagara naeba nawaikena maruntepa kampa waintiye, omintiye. ");
INSERT INTO for_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Piya omogini, abagi kina igetisa to ka'waina mayama omintiye: Wa'ega abintaga, marupa wama nabanempapa pu'waka uma kaitate kaegarano, untiye. ");
INSERT INTO for_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Piya yogana Isuba maya omintiye: Monota pu'wasu puma miye kina'miba igeba purikibe kinapa kanara kaiwaitakibewe. Kae'enagaka ampa naegaraoma, omintiye. ");
INSERT INTO for_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Isu piya ute wanipisa karebi iyogini, abagi kina'wa iyuguni wantawe. ");
INSERT INTO for_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wauguna, pabigo pontaba tabera puma kotupa aiga'yo'ya puma ataena puritegina wanipisa kare antabaipinti tumintiye. Aibogana, Isu aeba awaitamintantiye. ");
INSERT INTO for_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Piya pogini, igeba wama abage pumagini: Wa'ega, naisikena pune, untawe. ");
INSERT INTO for_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Piya yuguna maya uwaimintiye: Nanaga tiyekuruba pewe. Timatiti'enaripa uwaenantowa, a, untiye. Piya uwaimimagina, aeba asima pontabe wanipe tabe kamana uwaisimoginisi uwasuwa puntase. ");
INSERT INTO for_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Aibogini, pi kina'miba agate uwoma nkigi napima maya untawe: Aeba nana yagaragana, pontawamake waninkamakeba awamupa wasiyese, untawe. ");
INSERT INTO for_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pigoya, Isuba kotupa ta'ema maroti Katara kina'mi mpari wama uma irosantiye. Uma irosaoginisi tara yagarara ke kina'waisintaga kanama ampa abatantase. Isigeba wasana irubintisa kanamaginisi agasiya pusuguni iyekuru puma pita'iba wasanaba kampa nasi nasi puntawe. ");
INSERT INTO for_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Isigeba Isu agateginisi kega'e uma maya untase: Kaeba Koti Ntagaragawa, nana purasitakena kanane. Kanapa kampa agarosantegina kaeba ata purasitakenaga iyenoma, untase. ");
INSERT INTO for_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pigoya, pagasari uwoma ntaga naninta namagini mintantawe. ");
INSERT INTO for_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mintuguni, kana ke kina igeba Isuka maya uma esotantawe: Tagarubakena puntanapa, urataga pi ntagami nkintabaipinti tumpa paseno, untawe. ");
INSERT INTO for_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Piya yuguna Isu aeba: Karu'ena ae'waiyo, uwaimintiye. Piyama uwaimogini, kana yagara taramisi isintabaipintisa irosa'magini, yaga intabaipinti uma pasintawe. Pasuguni, kana yagami karu'ena kotu waintometa ausari tumima wanipinti naisuwaewantawe. ");
INSERT INTO for_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Piya puguni, igate kana yaga kiye kina igeba iyegaka kumati ima, pi a'ya'ma kamanape ke'waisintaga yagara taramisi kamanape kaga wasana a'ya'ma uwaimiwaentawe. ");
INSERT INTO for_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Uwaimuguni, wabe wayape a'ya'magini kumatisa tumimagini Isuti tumpa irosantawe. Aeti tumpa irosa'magini: Marepa atate to mari waomagini, esegima omintawe. ");
INSERT INTO for_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Pigoya, Isuba wanipisa karebi ima kotupa to kake ta'ema kanama kuma'wati to kakema irosantiye. ");
INSERT INTO for_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Irosaogini, agisa aya pu'wanta yagara ka wasara wasirite kanatawe. Piya puguna, Isuba imatiti'enawaimpa nkagoba igate agisa aya pu'wanta yagara maya omintiye: Yagarane, kaekuruba a-po. Naeba aguntaenagapa maegagasuwema, omintiye. ");
INSERT INTO for_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Piyama omogana, mono tisa kina ka'isamiba intabaipinti mayama napintawe: Ae'wa nkau maete ima Kotika akayasotayema, napintawe. ");
INSERT INTO for_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Piyama napiyuguna, Isuba napiyenawai igate maya uwaimintiye: Tigebipa nanaga agunta kamanapa napiyewe. ");
INSERT INTO for_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Piya, aguntaenawa mpaegasuwe, yopa, au'wapa kampa agawe. Asima wao ukubopa, kaba atama kasa au aborakenaenagaba tiyobi kunta piye. ");
INSERT INTO for_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pigoya, Wasanama Ntagara naepa mabi aguntaena asu'a pikena esegiyenaba naminti, pi'na nkagoba aogima agabebema agaiyo, piya ute, agisa aya pu'wanta yagaragaba maya omintiye: Asima wasagapa aesagabite wa'egati waoma, omintiye. ");
INSERT INTO for_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Piyama omogana, asima wa'ewati wantiye. ");
INSERT INTO for_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Piya pogini, a'ya'ma kina'miba agate iyekuru pumagini, Koti pi nkesegiyena wasana imomeka i'mu puntawe. ");
INSERT INTO for_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Pigoya, Isu aeba pitasa wama takisi maeyome ntagara ka agewapa Matiyu, aeba yogaeba pome ntamankapi mintogana uma abatama omima maya untiye: Kaeba kanama ampa naegaraoma, omogana, pabigo asima aegarantiye. ");
INSERT INTO for_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pigoya, Isu namankapinti naninta nanema agega'e yogana iyogini, takisi maeyume kinape to ka'isa aguntaena pume kinape uwoma irosauguni, Isube abagi kinape kaga nanintaba nantawe. ");
INSERT INTO for_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Piya puguni igate, Parasi kina igeba abagi kina'wa maya uwaimintawe: Tisaripa takisi maeya kina aguntaena pe kina'mikeba nana pikena kaga mima nanintaba nayema, ibigantawe. ");
INSERT INTO for_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pi kamana Isuba abite maya uwaimintiye: Tusa yagara aeba aogi kina'mitiba kampa yogaba piye. Yoni kina'miti mana piye. ");
INSERT INTO for_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Pigoya, tigeba wama paisa kamana mayama waintemi, pi nkagoba abibebe piyo: Naeba kaema agunta abasakenaenagaba kampa nabiye. Agu kao'enaga nabiye, iye. Piya, naeba: Aogi kinatawe, ye kinapa aogi puwaitakenaba kampa tumintone. Naeba agunta kina igu a'wae pikibeka tumone, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Pigoya, pi ntaga Yoni nkabagi kina igeba Isuti ampa irosa'ma maya uma abigantawe: Taebe Parasi kinape ka'isa yagaba monotaka nanintaba a'a-o uma uwa miyuna, pi kae kabagi kina'miba nana piyema nanintaba a'yuguba nawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Piya yuguna aeba maya uwaimintiye: Wasanami iba'ena pigina iba wae'ma nkawaeba uwa mintakiniba, ayama aokina'miba intara'ena puma nanintaba a'a-o uma mikibewe, a. Pipa kampaye. Ainti iba'wae'ma nkawae ampa arakurite ababute to mari wagasiginiba, aokina'miba intara puma kampa naninta nanta uwa mima aeka napikibewe. ");
INSERT INTO for_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Piya, ae ntagarama paisa kai atugekanaba aoso kairasaba pugunikiye, a. Pipa kampaye. Aoso kaiwama paisa kai tabera paibekana atu'ma atisasanaga piyaba a-po. ");
INSERT INTO for_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Piya, ke kasa wainiba paisa meme aribipa ari'atakiye, a. Kampaye. Kasa wainiwama paisa meme ariba atu'ma wainibe meme aribe ataena pusanaga piyaba a-po. Piya, kasa waini to kasa meme aribi ari'ataiginaba, isigeba kaga aogima waikibese, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Isu aeba pi kamana uwaimima mintogini, monota paitama miyome ntagara ka'waina aeti kanama agora ampa parokaema maya untiye: Aragane ibanto puriya, kaeba kanama auta ampa aukaya pegana aoganoma, omintiye. ");
INSERT INTO for_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Piyama omite waogini, Isu aeba asima abagi kina'wake aega'ma wantawe. ");
INSERT INTO for_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Wauguna, waya ka iyegari tumiyaba mima miyogana kaboba nagisarisa tara tumpaema a'ya punti, aeba Isu kai atunkata aukaya puntiye. ");
INSERT INTO for_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Piya puntana, antabaipintiba mayama napintiye: Kai manankata aukaya pumagi kabarikuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Piya ute, aukaya pogana Isuba a'wae puma kana wae'mati ao agama maya untiye: Araganepa, kantawamaba paru peno. Kaeba kamatiti punatampeka aogi kabiyema, omintiye. Omogana, pabigo kana waepa kaba'ma atawantiye. ");
INSERT INTO for_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pigoya, Isuba wama kiya yagarama ntamapi ima ini kubegabe kamana'waipa abite maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tigeba irosa'ma tumiwaegasiyo. Ma nkaraga aeba kampa purintiya, aeba uwa awaita mintiye, piya uwaimogini, kamana'wa abugunaba uwa anagi kamana kanta piyema napintawe. ");
INSERT INTO for_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Aibuguna uwaitaogini, abe'i irosa'ma tumiwaegasuguna, kana wasana wasa waintometi uma pai'ma kana aragama nkayata urogana, aogama asintiye. ");
INSERT INTO for_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Piya pogana, pi kamana'ama pi mpariba pabigo abae purite wagana puwaentiye. ");
INSERT INTO for_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Pigoya, Isuba pi mpaba atate waogini, isiyorika yagara taramisi aega'ma wantinisi kega'e uma maya untase: Kaeba Tebiti ntagaragawa, tasigeka kantara po, untase. ");
INSERT INTO for_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Piya yusuguna abite wama kumata uma irosaoginisi agora wausuguna isibigama maya untiye: Tisiyo aogi puritakena esegiyenaba wainatantiya, pipa abibebe pesoma, isibigantiye. Piyama isibigaoginisi isigeba maya untase: Pipa taga abibebe puse, untase. ");
INSERT INTO for_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Piya yusuguna isiyora aukaya puntana maya untiye: Tisimatiti'enarisimpa au'wapa aborarisimikiye, untiye. ");
INSERT INTO for_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Piya yogana, pabigo isiyo apina'ma agantase. Aibusuguna, Isuba esegi kamana uma maya uwaisimintiye: Abiso. Tisigeba ma kamanapa wasana a-nkuwaimisigini abiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Piyama uwaisimoginisi, pigo isigeba wamaginisi mare-u me-u pusuguna pi mpariba kana kamana'ama abae purite wagana puntiye. ");
INSERT INTO for_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Pigoya, isigeba wausuguni, igeba karu'ena ka yagara Isuti ababute kanantawe. Aeba ke kina ka'waina aigaraogana aibo'ena puma mintantiye. ");
INSERT INTO for_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Piya pome ntagara ke kina agaruba agasogana aeba kamana untiye. Piya pogini, uwoma kina mintume kina'miba i'mu pumagini maya untawe: Maretapa paipa piyaenaba kapa kampa aboragi agama miyompene, untawe. ");
INSERT INTO for_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Piya yuguni, Parasi kina igeba Isuka maya untawe: Ke kina'mi asu igasima minti ntagarama ao'maeyagina, ke kinapa agaruba igasaye, untawe. ");
INSERT INTO for_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pigoya, Isu aeba pabiyamagina a'ya'ma mari nasi nasi pumagina, tabe kumatibe uwaena kumantontoribe Koti kabiratakena kamana mono namapinti uwaimintana, yonintana iki nakiyena ibome kinapa kaba'ma paru puwaita waentiye. ");
INSERT INTO for_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Pigoya, uwoma kina igantana igeka antara puntiye. Igeba sipisipi kiye kampa kabiyegana ataenabi mpiyesa puma miyuguna, ");
INSERT INTO for_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","pika antara puma abagi kina maya uwaimintiye: Yogaba tabe waintegina, piya naninta a'na pukena kinapa tarantowe. ");
INSERT INTO for_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pika tigeba yoga agowamaka esotaigina naninta a'na pukena kinapa aboraigiri yogawatapa waiyo, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Isu aeba abagi kina nagisarisa tara tumpaema kina'wa igega'e yogini ampa irosauguna, ke kina igaruba igaikenabe yonintana iki nakiyena ibome kina kaba itakibeka esegiyena imintiye. ");
INSERT INTO for_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Pigoya, aposoro nagisarisa tara tumpaema kina'mi nkigeba mayamawe: Marusa yagara Saimoni aoso agiwapa Pitawa, ae a'nanto Enturuwa, Sepeti ntagara Yemisiwa, ae a'nanto Yoniwa, ");
INSERT INTO for_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Piripiwa, Patoromayowa, Tomasiwa, takisi maeyome ntagara Matiyuwa, Aopayesi ntagara Yemisiwa, Tariyesiwa, ");
INSERT INTO for_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","namu'isa kiya kina igarubakaikena abugai ntagara Saimoniwa, ainti Isu minaga'ena punti ntagara Yutasi Isikeriyotiwa sumagini, abagi puntawe. ");
INSERT INTO for_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pigoya, Isu abagi kina nagisarisa tara tumpaema kina'wa ige uwaitama igarubantana maya untiye: Tigeba to marisa kina'mitiba a-nkwaiyo. Sameriya kina'mi kumatiba a-nkubasiyo. ");
INSERT INTO for_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isureyo tu, sipisipi kabuba wantasa puma miye kina, igeti mana waiyo. ");
INSERT INTO for_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Wasanamiti uma irosantiripa maya uwaimiyo: Koti kabiratakena yagaba agarosaye, uwaimiyo. ");
INSERT INTO for_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Piya, tigeba yoni kina kaba itaiyo. Pu'wanta kinapa asiwaitaiyo. Karu kinapa aogi kaba itaiyo. Ke kinapa igaruba igasiyo. Piya, maeyantanaba ikantanarasa wanane. Uwa maeyasa puma tigeba ikantanaba a-mpaentiri uwa iyo'maema aogi puwaitaiyo. ");
INSERT INTO for_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Monebe tabebe uwaenantobe kapa a-nkira'ma maete waiyo. ");
INSERT INTO for_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kopa a-nkarakae piyo. Piya, tara kaibe tigisa anape pusu'ma ke'i nasikena wantape a-mpaete waiyo. Uwa tika nasiyo. Piya, yoga kinapa yogawaitasa nanintawaipa imegini maeyasa puma timigiri maeyiyo. ");
INSERT INTO for_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Pigoya, kuma pita'i mata'i uma irosantiripa wasana ago igaiyo. Ka'waina kayone puritama kao'ena puritakiripa, pabi ae namapi ima pabipi mima waimarate waiyo. ");
INSERT INTO for_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Namankaipinti uma pasintiripa: Mono tigeti waiyema, uwaimiyo. ");
INSERT INTO for_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Piya, kana namapisa kina aogima arupu puma miyiginaba, tigu paruyenamaba igeti wano. Piya, kampa aogima miyiginaba, pi paruyenaba tigetiti a'wae puma kanano. ");
INSERT INTO for_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Piya, ka yagarama namankapinti kampa tibabute wama kamanati kamana abekiripa, wakibe ntagaba tigisarisa i'ni aiwaka potate waiyo. ");
INSERT INTO for_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Naeba taga urimukuwa, abiyo: Aintisa kanabipa Sotomu Komora kina tumimaena puwaitantana, maya kumatasa kinapa tabe kuntuyena aborawaimikiye. ");
INSERT INTO for_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Abiyo. Sipisipi kabukarawama ige abakapintiba kampa uwaitakenaena naeba pi tigepa uritauwa, pika tigeba miyarinkama pemisa puma pasema aogimagiri napima nasiyo. Piya pupuntama pemisa puma aogima napima kamparagaena a-piyo. ");
INSERT INTO for_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tigeba wasanamika aogima kiya puma nasiyo. Igeba kamana uritakena namankaipinti tibabute wamagini, mono namankaipinti eru kasutasa tiyegukibewe. ");
INSERT INTO for_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pipa nanagawane. Tigeba nabagi kina mintaka uma tabe kiye kinatibe wa'ega kina igetibe tibaisusu purite wama kamana uritakibewe. Piya, tigeba ige iyobipe to marisa kina'mi nkiyobipe esegima mono uma araiyo. ");
INSERT INTO for_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Piya, igeba kamana uritakibepa: Aya kamana ukunemaba abima, tara taraba a-piyo. Pi ntagaba kamana ukena kamanapa Aota Awamusa'ama napi napiyenaripi ataritakiye. ");
INSERT INTO for_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Piya puritakiri, kamana yiginaba tige kamana kantaba kampa pikiye. Tibarimpatisa Aota Awamusa'ama tigupi mikibi, ae kamana'ena pikiye. ");
INSERT INTO for_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Pigoya, pi ntagaba aganto ka'wainaba a'nantopa minaga pekini aegukibewe. Aba ka'wainaba yagarawapa pabiyama minaga pekini aegukibewe. Piya, yagara aragawaimpiba inogi ibagipa kamana uwaitama minaga pigini iyegukibewe. ");
INSERT INTO for_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pigoya, nae nawaga kamanataka wasanamiba tigeka abima kama puritakibewe. Pigoya, ka'wainaba kampa natakibikana esegima mimagina kana'wa a'ya pekanaba, aintiba Koti ababikiye. ");
INSERT INTO for_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Pigoya, ka kumata uma irosa'ma mintigini tiyeguma tigarubaigiripa, to kumati pai'ma tiyegaka waiyo. Piya, naeba ubebema urimukuwa, abiyo: A'ya'ma Isureyo kumati yoga wairite wanti, pipa igiga puma mintigi, Wasanama Ntagara naeba tumpa irosakuwe. ");
INSERT INTO for_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Pigoya, abikena namapisa yagara ka'waina tisawampa asu agaikenaenaba pipa kampa waintiye. Piya, kayokaya yagara ka'waina pabiyama tabe yagarawa asu agaikenaenaba pipa kampa waintiye. ");
INSERT INTO for_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Piya, abikena namapisa yagara aeba tisawampa ae awameta pekanaba kanarasakiye. Kayokaya yagara aeba tabe yagarawampa ae awameta maema aborakanaba pabiyama aogi pikiye. Pigoya, tibatipa Piyesiburu, pipa ke kina'mi tabewaimpawe unamekini, naokina tigepa pabiyamagini tabera kamparaga kamana uritakibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pigoya, tigeba wasanamika a-tiyekuru piyo. Kakama waintintanaba pipa agorapa kampa kakama waikiye. Pipa aintiba aborakiye. Piya, airarikaegainta'ena waintipa, pipa agorapa kampa kakawakiye. Pabiyama aintiba apira puma aborakibewe. ");
INSERT INTO for_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pigoya, tununtanabinti urimo kamanapa tigeba ara uwaimiyo. Piya, obina kamana abepa tigeba nama nkagari asu mimagiri kega'e uma uwaimiyo. ");
INSERT INTO for_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Pigoya, ariri'ama aeguntini tigu ti'ama aegukena aguyosagakibe kina igekaba a-tiyekuruba piyo. Piya, tigutipe ariripe kaga isibanakinisi agagabinti tumikena esegiyenawantaga yagara Koti, aeka tiyekuru piyo. ");
INSERT INTO for_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Pigoya, kisabentonto uwaena monentorasa ika pewe. Piya tibarimpaba kampa owe untakanaba ayamagina mabipa tumikiye. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Piya, wasana tige ti'no nkabiyapa pipa a'ya'magina aisuma abiwaeye. ");
INSERT INTO for_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pika tigeba tiyekuruyenabipa a-mpiyiyo. Tigeba kisabepa kampaye. Tigeba wasanarawe. ");
INSERT INTO for_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Pigoya, ka'waina aeba nae nagene wasanami nkiyobi uma aborakapa, naeba pabiyamagi mantarisa nabanempa ae aobi uma aborakuwe. ");
INSERT INTO for_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","To ka'waina aeba wasanami nkiyobi kakanatakapa, aepa naeba pabiyamagi mantarisa nabanempa ae aobi kakatakuwe. ");
INSERT INTO for_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Pigoya, tigeba naekaba: Aeba paruyena maema aborakena tumintiyeba, a-siyo. Naeba paruyena wanane. Ma'ena pikena kasontentaga tumintone. ");
INSERT INTO for_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Piya, naeba wasana atatara puwaitakena tumintone. Pika abage yagarawampage isigeba atatara pisigina, anoge aragawampage isigeba atatara pisigina, aentawampage anatuge isigeba pabiyama atatara pikibese. ");
INSERT INTO for_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Pigoya, ka'waina aeba aokina igetisa yagarama kama potasanaga aborantone. ");
INSERT INTO for_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Piya, ka'waina aeba abake anoke agu kao'ena tabera puwaisitantana naepa uwaenanto punatakibi, aeba nae nao'yagaraba kampa mikiye. Piya, ka'waina aeba yagara aragawa agu kao'ena tabera puwaitantana naepa uwaenanto punatakibi, aeba pabiyama nae nao'yagaraba kampa mikiye. ");
INSERT INTO for_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Eya, ka'waina aeba maripowa, pipa wasanami igobi punatantanaba kampa aesagabinta naegarakibi'naba, aeba pabiyama nae nao'yagaraba kampa mikiye. ");
INSERT INTO for_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Piya, ka'waina aeba mikenaenawaka owe yekanaba, a'yugu potakiye. Piya, naeka napima mikenaenawaka a'a-o yekanaba, aboramikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Pigoya, wasana ka'waina aeba aogi puritai'naba pipa nae aogi punataye. Piya, nae aogi punatai'naba Koti aogi potaye. We, ae unataoga naeba kanantokanane. ");
INSERT INTO for_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pigoya, ka'waina poropete yagaraga: Koti nkao'yagarawe, otama aogi potakibi'naba, aeba poropete kina'mi ige awameta ikantanaba maekiye. Piya, ka'waina Koti aega'ma tagantana pe kina to ka'wainaka: Koti nkao'yagarawe, otama aogi potakibi'naba aeba tagantana pe kina'mi ige awameta ikantanaba maekiye. ");
INSERT INTO for_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ae abagi kinane, uwaitamagina, aogaso wani iru'ma imikibi'na ikantanawapa aintiba kampa kaikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Isuba nagisarisa tara tumpaema abagi kina'wa kamana piya uwaimiwaetate atate, to kumati mono uwaimirite wantiye. ");
INSERT INTO for_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Piya pogana, Yoni wani pai'itanti ntagara aeba iga'na namapi mintana, Karaisiti yoga pome pi awaga kamana abite abagi kina'wa uwaitaogini igeba wamagini, ");
INSERT INTO for_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Isu maya uma abigantawe: Kaeba utaratanti ntagara Karaisiti kanakiye, untapa, kaebera to ka yagaraga agawa puma misunema, abigantawe. ");
INSERT INTO for_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Piyama abigauguna, Isuba maya uwaimintiye: Tigeba a'wae puma wamagiri, agama abentanama kamana uma Yonipa omiyo. Pipa mayaenawe: ");
INSERT INTO for_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Iyorika kina'miba iyo agawema, igisa iya pu'wanta kina igeba ke'i nasi nasi pewema, karu kina'mi nki'amaba aogi piyema, purinta kina'mi iyo agawema, kusi kina'miba aogi kamana abewemagiri uma omintiri, to kapa mayama amato puma omiyo: ");
INSERT INTO for_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ka'waina aeba naeka abima aekita kampa pikibi'naba aeba a'mu pikiye, iyema omiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Piya uwaimogini, Yoni nkabagi kina igeba a'wae puma wauguna, Isu aeba wasana mintume kina Yonika maya uwaimintiye: Tigeba ka'me mpariba Yoniti wama, ayaena agakena wantawe. Misa ka ponta wama maete wate kanate pemisa pogiri agakena wantawa, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wasana kawaina kaiwapa aogi awa'ena purintogiri agakena wantawa, a. Pipa kampaye. We, wasana aogi kai pure kina'miba tabe kina'mi ntamapi mintini iwaiba waintini pewe. ");
INSERT INTO for_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Piya, poropete ka agakena wantawa, a. We, nae naeba urimukuwa, abiyo: Tigeba pi agama miye ntagara aeba poropete kaisa kina ige awametapa kampaye. Aeba to awametane. ");
INSERT INTO for_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Piya, aeka mono isapisa kamana ka mayama waintiye: Abo. Kamana'ne maenta yagara agarubakana paitama kaori wama, kekapa aogi pikiyema, Koti untiye, iye. ");
INSERT INTO for_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Pika naeba ubebema urimukuwa, abiyo: Waya'mapisa aboranta ka'wainaba Yoni wani pai'itanti ntagara aepa kampa againtikana, pigo Koti kabiratakena yaga aborakiniba nagora tumima miye kina'nempiba Yonipa asugaikibewe. ");
INSERT INTO for_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Pigoya, Yoni wani pai'itanti ntagara, ae yoga agobinti ntagaba Koti kabiratakenaenaba agobima agasiya puma aboranti'naba aboraye. Pika esegi pe kina'mi ige Koti kabiratakena kumapa maekena pewe. ");
INSERT INTO for_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Piya, a'ya'ma poropete kina'mi kamanape Mosese ominti ago kamanape ke nasompentanaga kaeta kanantagana, Yoni aboraogana kamana'waimpa au'wa aborakena kanapa aborantiye. ");
INSERT INTO for_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Pigoya: Iraiya a'wae puma kanakiyema unta, pipa tigeba Yonika: Iraiyawe, yiyo. ");
INSERT INTO for_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pigoya, ageyaga kina'maba ma kamanapa abibebe peno. ");
INSERT INTO for_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Pigoya, mampabisa ae kina'mita awame puritasuwe, a. Tigeba yagara araga ige awametane. Igeba kumati mima iyo kina maya uwaimewe: ");
INSERT INTO for_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ini yokiripa, nanaga wa'enaba kampa pewe. Tantara ena pokiripa, nanaga kube'enaba kampa pewe, piya yewe. ");
INSERT INTO for_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Piya omesa puma Yoniba yogawa agobintanaba monoka ka'isa nanintabe waini wanipe kampa nama a'a-o uma miyogini agantiniba maya untawe: Aeba aibo'ena piye, untawe. ");
INSERT INTO for_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","We, Wasanama Ntagara naeba tumima wanipe nanintabe naogiri, nagantiripa maya yewe: Aeba uwoma ntanintabe waini wanipe nayaba yagarawe. Aeba takisi maeya kinape aguntaena pe kinape ige iyo'yagarawema, naeka yewe. We, mono agowapa igu'ama kintarama miye kina'mi, ige aogima aegaragiri agawe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pigoya, Karariya ka'isa kumati Isuba uwoma ntuga puma esegiyenawampa ago maema aboraogini agantiniba igupa kampa a'wae puguna, ige'ma kamana maya uwaimima untiye: ");
INSERT INTO for_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","We Korasini, nantarane. We Petisaita, nantarane. Mebi, Tigeti kukantana tabera aboranti, pipa Taya Saironi kumata aborantisinta igeba intara puma karu'ena auga'magini igu a'wae puntasine. ");
INSERT INTO for_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pika urimukuwa abiyo: Aintisa kanabipa Taya Saironi kina tumimaena puwaitantana, maya kumatasa kinapa tabe kuntuyena aborawaikiye. ");
INSERT INTO for_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","We, Kapaniyamu kina, tigepa mantari tibabute ikibewa, a. Kampaye. Aintiba agagabinti tumikibewe. Piya, kukantana tige kumati aborantemisa puma Sotomu kumata aborantemisinta, ibabe aintibe Sotomuba uwa waiyesine. ");
INSERT INTO for_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pika urimekiri abiyo: Aintisa kanabipa Sotomu kumatasa kina tumimaena puwaitantana, maya kumatasa kinapa tabe kuntuyena aborawaikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pigoya, pi ntagaba Isuba abawampa a'mu potamagina maya untiye: We naba, kaeba mantage mage tabe agowe. Abikenaenawaika abegana tabe pe kinapa kaka waigasane. Piya, igu'amaka abegana inamu kanta pe kina'mipa iyakima imene, pika naeba na'mu pugataopa, ");
INSERT INTO for_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","kaeba piyama aboraurite wagana penema, pipa uma esegi puntampene. ");
INSERT INTO for_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Pigoya, a'ya'maena wainatantipa nabanempa nayapi atawaentine. Pika wasana ka'waina yagarawa naeka agoneka kampa abibebe piye. Nabanempa abiwa abibebe piye. Piya, nabanempa ae agowaka pabiyama wasana ka'waina kampa abibebe piye. Yagarawa nae nabinto abibebe puwe. Piya, yagarawa naeba wasana ka'waina nabanempa nkago uma aboramekanaba aege abibebe pikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Piya ute to maya untiye: Pigoya, kuntaena aesaga'ma tintara'enabi mpiye kina tigeba a'ya'ma naeti kanawaeyigi migarakenaena timekana paruribeno. ");
INSERT INTO for_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Piya, naeba nanta nagu paruyenanentaga mintoka, kanamagiri miminte tibota atama agonepa ampa abibebe piyo. Piya pigina tigu timankamaba migarano. ");
INSERT INTO for_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pi kuntuyenaba tibota aesagatitaopa pipa aogiyenawe. Piya, pi timontana aesagabikibepa kuntaba kampa tibikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pigoya, pi ntagaba Isuba abagi kina'wapa paita itaogini sabatira witi yugabinti wantawe. Wantini abagi kina igeba iga'ena ibogini witiba akima nantawe. ");
INSERT INTO for_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Piya puguni, Parasi kina'miba igate Isu omima maya untawe: Abo. Kabagi kina'miba sabatira akumparanta'ena peganaba ataena piye, untawe. ");
INSERT INTO for_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Piya omuguna maya uwaimintiye: Tebitibe aokina'mibe iga'ena ibogini punta, pi kamanapa tigeba kampa aisuma abewa, a. We, tige abintawe. ");
INSERT INTO for_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Igeba tabe mono namapinti iyogana pareti Koti nkamume pipa amigini maema nantane. Pipa aebe aokina'mibe a'yuguba kampa nakibewema, mono kiye kina'mi mana nakenawema, akumparantane. ");
INSERT INTO for_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Pigoya, a'muntana kaekena mono kina igeba yoga pumentanawaika Moseseba kamana kaenti, pipa aisuma kampa abewa, a. Pipa ago abintawe. Igeba sabatira yoga pumagini sabati ataena peweba asuwaitaiyo. ");
INSERT INTO for_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Piya, naeba pika urimekiri abiyo: Tiyora asima minti, aeba tabe mono namapa asugasima mintiye. ");
INSERT INTO for_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Pigoya kamana awa'ena ka mayama waintipa, pi kapa tigeba abisanawa, kampa abewo. We, naeba kaema agunta abasakenaenagaba kampa nabiye. Kao'ena waintaga misanaga nabiye, Koti untiye. Tigeba pi kamana abima yesinta, kaintanawai kampa wainta kinapa ma uwa kamanapa kampa uwaitasine. ");
INSERT INTO for_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pigoya, Wasanama Ntagara naeba pi sabatirapa kabima miyuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Isu piya ute, pitasaba atate wama mono namankaipinti intiye. ");
INSERT INTO for_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Pigoya, pita'i ka yagara mintantiye. Aeba ayapa tagarakiwanta, mintogini wasanamiba Isu abigama maya untawe: Ma ntagaraba sabatirapa kanara kaba atakibepera kampaye, untawe. Piya, igeba uwaba kampa untawe. Kamana'wa abite kamana otakena napimagini untawe. ");
INSERT INTO for_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pigoya, Isu aeba iwamu aibatenama maya untiye: Tigetisa ka'waina yagawa kabinti, sabatira tumekanaba sabatiraka uma kasakana uwa mikiyo. Pipa kampaye. Aeba ao'maekiye. ");
INSERT INTO for_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yaga uwaena kinane. Wasana tigeba pi amantaga kinane. Pika sabatirapa wasana kanara aogi puwaitakune untiye. ");
INSERT INTO for_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Piya ute kana yagarapa: Kayapa parosoma, omintiye. Piyama omogana, ayankasa pogana aibarutama aogi puma to ka auka'isa ayankama waintomesa puntiye. ");
INSERT INTO for_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Piya pogini, Parasi kina igeba pintana agate wawaemagini Isu nkaegukenaenaga nikintawe. ");
INSERT INTO for_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pigoya, Isuba pi kamana abite pimpa kumapa mintantipa atate tori wantiye. Waogini uwoma kina'mi aega'ma wauguna, yoni kinapa kaba'ma aogi puwaitantiye. ");
INSERT INTO for_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pigoya, igeba to ka'isa kinapa: Nawaga kamana a-nkuwaimiyoma, tonkiya kamana esegima uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Piya pogana, Koti nkawamupisa kamana poropete Aisaya meto kamana kaemaranti, pi'na au'wantaga'ena mayama puntiye: ");
INSERT INTO for_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Mapa kayokaya yagarane. Nae utamarantone, iye. Pigoya aewapa aogi yagaranene. Naeba aeka nabugaye, iye. ");
INSERT INTO for_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Naeba Aota Awamusa'ne aeta atakana ao'maeyakana kamana'ne a'ya'ma namu'isa kinapa uma aborawaima maema arupu pikiye, iye. Piya, aeba kaba kampa ibi'ma, taberasa kampa uwaitakiye, iye. Piya, tabe kamana'wapa ke'iba kampa aborakini abikibewe, iye. ");
INSERT INTO for_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Pigoya, uwaena misankanto aka'yuwaintipa, a'ya'ma kampa aka'yuwaisa pumagina ataenaba kampa puratakiye, iye. Piya ka'isa yagaba uwaena yakunkanto tamipa, kampa tu'ma waikana, magi magi kinapa kampa ataba puratakiye, iye. Piya puma, esegima yoga pekana Koti kamana'amaba aborama arupu puma aogi purite wagana pikiye, iye. ");
INSERT INTO for_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Piya pekini, to marisa kina'miba aeka napinapima agawa pikibewe, Koti untiyema, Aisaya Isuka piya kaentiye. ");
INSERT INTO for_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pigoya pi ntagaba ka yagara kewama aigaramagina aorikaema aibo'ena puntiye. Aibogini, Isuti ababute wantawe. Piya puguna, Isu kaba'ma aogi potaogana kamana uma ao agantiye. ");
INSERT INTO for_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Piya pogini, a'ya'ma uwoma kina mintume kina'miba agate tabera pami pumagini maya untawe: Taeba napiyompepa Isuba Tebiti ntagara utaratanta Karaisiti kanta piye, untawe. ");
INSERT INTO for_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Piya yuguni, Parasi kina igeba pi kamana abite maya untawe: Kumparine, ke kina'mi tabewai agewapa Piyesiburu, ae esegiyenawatasa ke kinapa agaruba igasaye, untawe. ");
INSERT INTO for_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Piya yuguni Isuba napi napiyenawai igate maya uwaimintiye: Ka marasa aokina'mige kamaena pumagini kamparagaena pigina ka'me mpa aborakiye. Piya, to kumatisa kina'mibe to namapisa kina'mibe pabiyama aokina'mige ma'ena puma ataena pigini nama kuma'waipa akasaba'magina ataena puwakiye. ");
INSERT INTO for_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Piya, Satani ke kinapa ayama agaruba'ma kama potama agarubakiye, a. Pipa kampaye. Piya pekana aege ma'ena puma ataraisigina a'ya'waemaenawampa kamparagaena pusanaga piyaba kampa pewe. ");
INSERT INTO for_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Piya, naekaba mayawe yewe: Aeba Piyesiburu ao'maeyagina ke kinapa agaruba igasaye, yepa: Pigoya, ka'isa tiyokina'mi igeba ke kinapa agaruba igasawe. Pipa ke iyo'maema esegi puwaitagini pi ntugaba pewe, a. Pi ke kina Piyesiburu ae esegiyenarasaba kampaye. Piya, tiyokina'miba agaruba agoba agamagini, aintisagaba tigepa utaritakibewe. ");
INSERT INTO for_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pigoya, naeba Koti Nkawamusa'ama nao'maeyagi ke kinapa agaruba igasoka, Koti kabiratakenaenaba tigetiba aboraye. ");
INSERT INTO for_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Pigoya, kewama esegi yagara kanta puma mintakanaba, ayamagina namankapintiba ima kotapa aparikiye, a. Pipa kampaye. Marupa pi esegi yagara araku'ma agisa aya kirokaetama pabigo kotankapa aisagakiye. ");
INSERT INTO for_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Pigoya, ka'waina aeba kayone kampa punatai'naba kama punataye. Piya, ka'waina aeba yagarunte kampa ibabuma aki pi'naba aeba igarubaye. ");
INSERT INTO for_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pika urimukuwa abiyo: Aintiba kotiba a'ya'ma aguntaenabe a'ya'ma kamparaga kamana wasanami yepe kanara mae igaikiye. Pigoya, Aota Awamusa'ama akayasotakibi'na, ae kaintanawapa Kotiba kampa maegaikiye. ");
INSERT INTO for_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Wasanama Ntagara nae uma kamparaga punatakibi'na, aepa aguntaenawapa uma asu'a pogaikuwe. Piya to ka'waina aeba Aota Awamusa'ama uma kamparaga potakibi'na, ae kaintanaba mabipe mantaribe kampa uma asu'a pogaikuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Isu piya untana to maya untiye: Pigoya tigeba ka yawama nka'wakaba: Aogiyenawe, untiri, kana yawaka kaga: Aogiyenawe, yewe. Piya, to ka yawama nka'wakaba: Kamparagawe, untiri, kana yawakaba kaga: Kamparaga yawe, yewe. Piya, yawama nkapa agamagiri, agowaka aogima napikibewe. ");
INSERT INTO for_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","We, kuyawama ntagara, tigeba agunta kina mintawa, aogi kamanapa kapa nanawe ukibewe, a. Pipa kampaye. Tigupi waintintanaba pabiyama tiwamupisa irosaye. ");
INSERT INTO for_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Pigoya, aogi agu'yaga yagaramaba aogiyena aborakiye. Kamparaga agu'yaga yagaramaba pabiyama kamparagaena aborakiye. ");
INSERT INTO for_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Naeba urimukuwa abiyo: Kamparaga kamana toma toma se, pi kamanapa Koti a'ya'ma kina pako pikibi ntaga ibigakini, kamana yigina uritakiye. ");
INSERT INTO for_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Piya, aintiba kaeka kamanataka kababikibe, pabi kaeka kamanatakabaya katakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Piya uma uwaimogini, mono tisa kinape Parasi kaisa kina'mibe maya kamana a'wae pumagini omintawe: Tisa, kaeba kukantana ka pega agano, untawe. ");
INSERT INTO for_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Piya yuguna maya uwaimintiye: Mono'wai kampa waima antage kina'mitaba, tigeba kukantanagaba yewo. Tigeba kukantanaba aoso'enaba kapa kampaye. Yonati aborantisa puma pabiyama aborakiri agakibewe. ");
INSERT INTO for_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona aeba kakaga yaga tabe inoyantawama nkantabaipinti mintantisa pumagi, Wasanama Ntagara naeba pabiyamagi ma antabaipinti kakaga yaga mikuwe. ");
INSERT INTO for_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ainti Koti a'ya'ma kina pako pikibi ntagaba Niniba kumatisa kina aborama mamparisa kina'mi kamparaga kamanati uma abora uritakibewe. Pipa uwaba kampaye. Niniba kumatasa kina igepa Yona aeba wasanaraka'yankama ige'ma kamana uwaimogini abima igu a'wae puntaka, piya ma minto naeba Yona ae awametapa kampaye. Pipa asugasima mintogiri, pabi ntaga tigeba kampa piyama a'wae pigina pi Niniba kina uritakibewe. ");
INSERT INTO for_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Piya, mare takaerisa tabe wae aeba pabiyamagina a'ya'ma kina pako pikena yagaba ma mpabisa kina'miti kamparaga kamanati abora uritakiye. Pigoya pipa uwaba kampaye. Pi kana waepa aeba atuti wama Soromoni aetisa mono abintiye. Piya, ma minto naeba Soromoni ae awametapa kampaye, pipa asugasima mintuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Piya untana, Isu to maya untiye: Kewamaba wasanaba atate wama ka'me mpari umima, maru kumakaba aguyosagakiye. Aguyosakate maya ikiye: ");
INSERT INTO for_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Namantepa atate kanantoka, pita'i to kake a'wae pumagi wakuwe. Piya ute a'wae pumagina agakibipa, kana namapa paga pumagini aogi pugaintane. ");
INSERT INTO for_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Piyaena agate wama ke aokina tonaentisa tara umaema kina to kake kamparagaena pe kina ibabekini kanama pabi ntamapi ampikibewe. Aibigina pi ntagara aeba paipa kampa aogi yagara mintanti'naba aintiba tabera kampa aogimagina ata puwakiye. Mamparasa kamparaga kina tigetiba pabiyaena aborakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Pigoya, Isu aeba wasana mono uwaimima mintogini, ika'i anobe a'natabarabe kamana omikena ampa agawa pumagini mintantawe. ");
INSERT INTO for_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Piya puguna, ka'waina igate maya omintiye: Kanobe ka'natabarabe kamana ugamikena taka'i kagawa pumagini mintawe, piyama omintiye. ");
INSERT INTO for_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Piyama omogana Isu maya omintiye: Nano na'natabaraga yewo, untiye. ");
INSERT INTO for_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Piya ute abagi kina'wa mintumeti aya nkasa pumagina maya untiye: Igaiyo. Nano na'natabaragi maye, untana: ");
INSERT INTO for_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mantarisa nabanempa nkawamu wasima aegara kina pi ige nano na'nanto namana'maba mintawe, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pigoya, pabi ntaga Isuba namapintisa irosa'ma wamagina kotu kepari umintantiye. ");
INSERT INTO for_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Umintogini, wawaya uwoma kina'mi ampa irosa'magini aki puguna, igate to ka wanipisa karebi intiye. Imagina aeba wanipisa karebi mintogini uwoma kina igeba kepari mintantawe. ");
INSERT INTO for_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Piya puguna, meto kamana toma toma uwaimintana, kapa maya untiye: Abewo. Ka yagarama aintana pikena wantiye. ");
INSERT INTO for_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wama uma aibarase pogana aowa ka'isaba kepi tumpa waintantiye. Aibogana, kabarankama irosa'ma ampa nawaegaintiye. ");
INSERT INTO for_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Piya aowa ka'isaba yabankama nkabobori uwaena manto waintometa tunkwaima, karu'ena irantiye. ");
INSERT INTO for_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Piya pogana abu'wapa tumomepa inata ara'waiyogana pa taogana asama pari puma pu'wantiye. ");
INSERT INTO for_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Piya ka'isa aowapa kabubinti tunkwaima iraogana kabuwama aibarusa pogana asa wantiye. ");
INSERT INTO for_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pigoya ka'isa aoba apa mabi tumpa waimagina anonkapa uwoma aborama aosa pama ka'isa 100-wa, to ka'isa 60-wa, to ka'isa 30-wa, suma aboraogana uwoma ntaninta waintantiye. ");
INSERT INTO for_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Piya, ageyaga kina'maba ma kamanapa abibebe peno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kamana piya umagina uwaimogini, abagi kina'wa igeba agora wamagini abigama maya untawe: Kaeba nanaga meto kamanapa uwaimene, untawe. ");
INSERT INTO for_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Piya yuguna, aeba maya uwaimintiye: Kakamagina Koti kabiratakena kamana waintemipa, pipa tigemana abikibewema untine. Pigoya, ka'isa uwoma kina'miba kampagini abikibewe, untine. ");
INSERT INTO for_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pigoya ka'waina aeba mono aminta'ena maemagina miyekanaba aintiba Kotiba to kake amekana uwomantana aboramikiye. Piya, to ka'waina mono aminta'ena kampa aogima maema miyekanaba apa'urekana uwa mikiye. ");
INSERT INTO for_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Igeba iyo ma'maginiba kampagini agabebe pewe. Igerasa abintiniba kampa aogima abibebe pewe. Piya, agowapa kampa abeka ma kamana meto kamanatasa uwaimuwe. ");
INSERT INTO for_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pigoya, igeka Aisaya meto kamana mayama kaenti, pi'na esegi piye: Igerasa uwa abintiniba igutasaba kampa aogima abibebe pikibewe, iye. Piya, iyorasaba agantiniba kampa aogimagini agabebe pikibewe, iye. ");
INSERT INTO for_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ma mparasa kina igepa igu'ama esegi puwama ige akumpagini, iyorika pewe, iye. Pika iyowamaba kampa aogimagina agabebe pikiye, iye. Igewamaba kampa aogima abibebe pikiye, iye. Piya, igu'amaba kampa aogima napikiye, iye. Piya pumagini igu'kampa a'wae pigipa ayamagi naeba aogima kaba itakuwe. Pipa kampaye, Koti unti kamana Aisaya piyama kaentiye. ");
INSERT INTO for_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pigoya tigeba tiyoyaga mintiri, tigeyaga mintawa, pika ti'muntanabi mpintawe. ");
INSERT INTO for_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Naeba ubebema urimukuwe: Poropete kina mono kina uwoma kina'mi igeba tige abima agantana pi agakenagaba ibugagate itaogini, uwa kampa agama abintane, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Piya untana, Isu to maya untiye: Pigoya, ma aintana asigikena kamana urimo kamana, pi'na nkagowa uma aborarimekiri abiyo: ");
INSERT INTO for_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","A'ya'ma kina koti kabiratakena kamana abimagini aogima kampa igupi napikibe kina igeti Satani irosa'ma aintana asigimarantapa maerite wagasaye. Pi ntagara aeba kepi aowa tumpa waintanti pi nkawametane. ");
INSERT INTO for_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Pigoya yabankama nkabobori tumpa waintantisa nkawameta piyamagini miye kina igeba mono abimagini pabigo iga ibegini napimagini miyewe. ");
INSERT INTO for_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Igupipa abupa kampa panta inata ara'ma miyewe. Piya pegana aogi kamana'neka ma'ena pumagini ataena piginaba ae abintemi kamana agaro kaikiye. ");
INSERT INTO for_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Pigoya, ka'isa aowa kabubinti tumpa waintanti, pi nkawameta miye kina'miba mono abimagini mintagana, mampabisa kuntaenagabe mone kutakabe napi napima miyekana, igaenama igu'ama maema a'yugu puwaigasakini pabigo mono'ama nkau'wapa kampa aboraye. ");
INSERT INTO for_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pigoya, apa mabi tumpa waintantisa pi nkawameta mikibe kina'miba mono abimagini igutasa maemagini miyewe. Piya pegana, ka'wainatiba au'wapa 100-wa, to wainatiba 60-wa, to ka'wainatiba 30-wa, suma aboraye, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Piya untana, Isuba meto kamana to ka maya uwaimintiye: Ka yagarama yogawati aogi aintana aowa asigitanti, aeta Koti kabiratakenaenaba awame pukuwe. ");
INSERT INTO for_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pigoya kana yagara aeba aintanaba asigitate waogana aseka kama yagarawampa kanamagina yoni nkaosa maemagina aibarase pugaite wagaintiye. ");
INSERT INTO for_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pigoya, kana aintana pumaraomepa i'magina nakena aborakena pogana yonipa kaga tarage uma irantiye: ");
INSERT INTO for_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Piya pogini, kayokaya yagara igeba agate yogawama nkabapa omima maya untawe: Tabe yagarare, kaeba yogagatiba aogi aintana asigimarantampepa, aetasabaya yonipa tagayema, abigantawe. ");
INSERT INTO for_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Piyamagini abigauguna maya untiye: Pipa kama kina ka'waina asigimarantegina tarage uma iraye, yogini, igeba abigama maya untawe: Abintaga, wama uma i'ma maebugasano, untawe. ");
INSERT INTO for_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Piyama yuguna maya uwaimintiye: Kampaye. Tigeba yoni igintiri kaga nakenaena igisanaga uwa ataiyo. ");
INSERT INTO for_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Nakenabe yonipe kaga waimaginisi aborakibese. Pigoya, nakena maekena yaga aborakapa, yoga kina uwaimekini igeba marupa yoni kibi'ma i'magini asaema yakupi kaentini, nakena aintanaba maemagini namantepinti ataigina waikiye, untiyema, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Pigoya, meto kamana ka maya uma uwaimintiye: Koti kabiratakenaenaba masiteti a'wanto piyamawe. Wasana ka'waina aowa yogawati metantiye. ");
INSERT INTO for_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kana yamankapa to ka'isa yamanka piyama wanane. Aeba uwaenantowe. Kana yaba i'maginaba ka'isa nakena yawamapa igasimagina tabe yaena piye. Piya pegina, kabarankamaba kanama amarapa ampa mima inapa kiyewe, untiye. ");
INSERT INTO for_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Piya untana, meto kamana to ka maya uwaimintiye: Koti kabiratakenaenaba yisitiba piyamawe. Ka wae'ma yisiti maemagini paretibinti paigu pekanaba, pi pareti anosama igaena tabera pukiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Pigoya, Isu aeba wasana kamana uwaimintintanaba pi meto kamana'amana uwaimintiye. Kamana au'wapa kampa aboramagina uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Piya pogana, poropete yagara ka'waina kamana abima mayama kaenti, pi'na esegi puntiye: Nawamupipa meto kamana'amana aboraka ukuwe. Piya, ma aborantemitasa kakanta kamana wairite kanama agowapa ampaema aborakuwema, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pigoya, Isuba pi a'ya'ma kina itaogini wauguna namapinti intiye. Ima mintogini abagi kina igeba aeti wamagini omima maya untawe: Witi yugabinti yoni taganti pi kamana ago kaeba yega abeno, untawe. ");
INSERT INTO for_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Piya umagini abigauguna maya uwaimintiye: Wasana aogi aintana asigiyemipa Wasanama Ntagara naewe. ");
INSERT INTO for_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yogaba pipa a'ya'ma marisa kinane. Aogi aintanaba pipa nae monota miye kinane. Yoni nkaosa asigintemi, pi kinapa kewama nkaokinane. ");
INSERT INTO for_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Pigoya, pi yoni nkaosa asigintemi ntagara, aeba Sataniwe. Piya, witi maekena yagaba pipa ainti tabe kanawe. Naninta maema akibikena kinapa enisore kina igewe. ");
INSERT INTO for_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Pigoya, yoni i'ma yakupi kaeyasa pumagina, ainti tabe kanabipa aborakiye. ");
INSERT INTO for_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Piya, aintiba Wasanama Ntagara naeba enisore kina'ne uwaitakini maga maga naokina'ne igetisa naegarakenaenawaipa ata puwaitakenaenabe agunta pe kinape kibi'ma, ");
INSERT INTO for_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","tayaba yakupi itakini tumpikibewe. Pita'i tumpimagini kube'ena pumagini iwarasa kaki aema mikibewe. ");
INSERT INTO for_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pigoya, pi ntagaba arupu kina igeba mantarisa ibawaimpa ae kumata pa nke'wasaena piyaenama e'wasa puwaitakiye. We, ageyaga kina'maba ma kamanapa abibebe peno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Pigoya, Isu toba maya untiye: Koti kabiratakenaenaba piyamawe: Mone pogisi yogari kakataogana waintantiye. Piya waintogana, ka'waina uma abatamagina to kakantiye. Piyamagina tabera a'mu pumagina a'ya'waemaenawapa to kina imogini mone amuguna wama yoga uma ika puntiye, Isu meto kamana piya untiye. ");
INSERT INTO for_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Pigoya Koti kabiratakenaenaba ka yagarama yoga pumagina pasesuga aguyosaganti, ae piyamawe. ");
INSERT INTO for_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Aeba aogi pasesu agategina, wama a'ya'waemaenawapa maema wasana imima mone maeritegina wama aogi pasesu uma ika puntiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Pigoya, Isu to ka meto kamana maya untiye: Koti kabiratakenaenaba kuko piyamawe. Wasanami kuko wanipinti motagana tumegini inoyantaba toma toma ampa pai'ma awaitaye. ");
INSERT INTO for_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Piya pegini, paibegana uwa mari iyegini kana inoyantaba pako pumagini nakenaba tu'napi atantini kampa nakena inoyantaba uwa kasagana waye. ");
INSERT INTO for_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pigoya, aintisa kana mampa a'ya pekanaba pabiyaena aborakiye. Piya pekini pi ntagaba enisore kina'mi maga maga nasi nasi pumagini, aogi kina'mi abakapintisa agunta kinapa kibi'magini, ");
INSERT INTO for_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","tayaba yakupinti ipasanaigini tumikibewe. Pita'i tumpima kube'ena pumagini iwarasa kaki aema mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Piya untana, Isuba abagi kina'wa ibigama maya untiye: Tigeba a'ya'ma ago abibebe pewa, a, untiye. Piya yogini, igeba: Ago abune, untawe. ");
INSERT INTO for_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Piya yuguna aeba maya uwaimintiye: Pigoya, mono tisa kina'mi Koti kabiratakenaenama nkagoba abinta kina, igeba mono abikenaena uwaena waintiye. Piya, wasanama aotasaenawatasa tonarona maema aboramisa puma, igeba mono abikenaenawaipisa tonarona aogi paisaenabe kasasaenabe maema napimagini aboraramewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pigoya, Isuba meto kamana toma toma uma a'ya atate, mawati wantiye. ");
INSERT INTO for_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Wama mono namapi imagina kamana yogini, wasanamiba abite pami pumagini maya untawe: Aetasabaya ma aogi napiyenabe awame'ena potakena esegiyenabe maeye. ");
INSERT INTO for_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Taeba agowapa abintune. Aeba kapenta yagarama ntagarawe. Anowampa ageba Mariyawe. Piya, a'natabarami nkigewaipa Yemisiwa, Yosepewa, Saimoniwa, Yutasiwa sumawe. ");
INSERT INTO for_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pigoya amana'natabaraba taege kaga mintawe. Pigoya aeba a'ya'waemaenaba aetasa maemagina aborantiye, untawe. ");
INSERT INTO for_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Piya umagini aeka abuguna kampa aogi puntiye. Aibogana, Isu maya uwaimintiye: Koti unti kamana yemi poropete yagarama kamana uwoma kina'mi ibugaye. Piya, mawatape agowatape namankapipe ageba kampa waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Piya, igeba aeka kampa aogima ntapiyumeka, Isuba kukantanaba uwomapa pi kumatapa kampa puntiye. ");
INSERT INTO for_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pigoya, pintaga Karariya kina'mi tabe yagara Eroti aeba Isu kamana abite, ");
INSERT INTO for_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","aokina'wa Isuka maya uwaimintiye: Pi Yoni mono wani pai'itanti ntagara aeba purintapisa aogamagina asima ma nkesegiyena puma miye, piyama napima uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Pi kamanapa uwa kampa untiye. Pai irebu kina'wa uwaitaogini Yoni agisa aya kirokaema iga'na namapi atantane. Pipa mayaenaraka piya potantawe: Eroti aeba a'nantowampa Piripi nkwae, agewapa Erotiyasi aparogana, ");
INSERT INTO for_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Yoniba tutusotama maya untiye: Kaeba kuntana pumagina aogiyena kampa penema, omintiye. Piyama omogana, Erotiyasiba pitaka agobi pogana, Eroti aeba yogini iga'na namapi ababotantawe. ");
INSERT INTO for_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pigoya, aegukena pomepa, uwa wasanamiba Yonikaba: Poropete yagarawe, yumeka aekuru puma atantiye. ");
INSERT INTO for_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Aibogana, Eroti yakari potanta yaga aboraogini, tabe kina igeba kanama aege ampa aki pumagini mintuguna, Erotiyasi nkaragawampa ige iyobi wa'ena pogana, Eroti agamagina a'mu potamagina maya omintiye: ");
INSERT INTO for_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Naeba Koti nkaobi uma esegi puwe. Kaeba piya mayaenaga yegapa kamukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Piya yogana, kana araga aeba anowampa uma agegaogana maya untiye: Kaeba Yoni mono wani pai'itanti ntagara, ae a'nonkayampu isigi'ma tu'napi atamagina pabigo namo, untiye. ");
INSERT INTO for_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Piya yogana tabe yagara abima pami puma kunta puntiye. Pigoya, Koti nkaobi uma esegi puntika, wasana ma minta kina'mi abigini kamana'ne tumisanagawema: ");
INSERT INTO for_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Owe otama, yogini, kayokaya kina'mi igeba wamagini Yonipa iga'na namapisa ana'mu uma isigima, ");
INSERT INTO for_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","anonkayampuba tu'napi atamagini maete kanama kana araga me nkamuguna aeba maemagina anowampa amintiye. ");
INSERT INTO for_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Piyama Yonipa aeguyuguna purogini, Yoni nkabagi kina'miba ampa irosa'ma au'wapa maete uma kaintawe. Kaitate Isuti wama pi awaga kamana uma omintawe. ");
INSERT INTO for_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pigoya, Isu aeba Yoni kamanapa abite, pi mpaba atate wanipisa karebi ima ka'me mpari abintowa umikena wantiye. Waogini, wasanamiba abite a'ya'ma kumatisa uwoma kina'mi aega'ma wamagini, pabita'i uma irosantawe. ");
INSERT INTO for_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Piya puguna, wanipisa karebintisa tumima a'ya'ma kina igamagina, antara puwaitama yoni kinapa kaba'ma paru puwaitantiye. ");
INSERT INTO for_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Piya pumagina mintogana, atamisaogini abagi kina'wampi igeba omima maya untawe: Mapa ka'me mpari mintokana atamisaya, pika wasana itagini a'ya'ma kumati wamagini naninta maema aboraiyoma, omintawe. ");
INSERT INTO for_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Piyama omuguna maya uwaimintiye: Nanaga waiyema uwaitawe, a. Tigeba naninta imiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Piya uwaimogini maya untawe: Taeba ma paretiba nayaka'muna, inoyantaba tarawa suma, pabinkawanto urintune, piya untawe. ");
INSERT INTO for_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Piya yuguna aeba: Pipa naeti maete kanaiyo, yogini maete kanantawe. ");
INSERT INTO for_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Maete kanauguna, wasana uwaitaogini kabu aebaru'ma mara'mintantawe. Piya puguna pi pareti nayaka'muna, inoyanta tarawa sumagina maema, mantari ao ma'magina Kotiti a'mu potamagina apako pumagina abagi kina imogini, igeba wasana pako pumagini imintawe. ");
INSERT INTO for_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Imuguni, igeba a'ya'magini namagini iga'e pantawe. Piya puntini, arita waiyomepa kibi'magini iraguguna nagisarisa tara tumpaema wa'nu ku awaitantiye. ");
INSERT INTO for_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pigoya, kana naninta nanta kinapa 5,000-wa kinane. Piya, waya yagara araga kampa aisuntane. ");
INSERT INTO for_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Piya pute, pabigo Isuba abagi kina'wa uwaitaogini, wanipisa karebi ibiwai imagini kotu maroteri a'wae pumagini wakena paitama wantawe. Piya puguna, aeba a'ya'ma kinapa itaogini wa'ewaiti wawaeyuguna, ");
INSERT INTO for_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","aeba abintowa amuti imagina nunamu untiye. Piyamagina mintogana ase yogana, ae abinto pabita'i mimagina mintantiye. ");
INSERT INTO for_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Piya pogana, kana wanipisa kareba wamagina koyu abakapi uma irosantiye. Piya pogana, pontaba waumetisa puritegina kanama wanipa tabera aiga'yo'ya pumagina wanipisa karebi apasanantiye. ");
INSERT INTO for_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aibogana, Isuba aseka aba mariki wani nkabobori wamagina, abagi kina'miti uma irosantiye. ");
INSERT INTO for_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Piyamagina waogini agategini iyekuru pumagini: Ke kina kanayemagini, A-e, a-e, untawe. ");
INSERT INTO for_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A-e, a-e, yuguna, Isuba karu'ena kega'e uma maya uwaimintiye: Tintawamaba paru peno. Naene kanauwa, tiyekuruba a-piyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piya yogana, Pitaba pabigo awamuta u'magina maya untiye: Wa'ega, kae kanantanapa yega, wani nkabobori kaeti wano, untiye. ");
INSERT INTO for_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Piya yogana, Isu: Kanao, omintiye. Piya omogana, Pitaba wanipisa karebintisa irosa'ma tumimagina wani nkabobori Isuti wantiye. ");
INSERT INTO for_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wantana tabe punta pogana agategina aekuru pumagina wanipinti tumikena puntana, Isu agisumagina: Wa'ega, kaeba nao'maeyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Piya yogana, pabigo Isuba ayata u'ma ao'maentana maya untiye: Kaeba kamatiti'enaba uwaenantowe. Kaeba nanaga kagu'ama tara taraba pene, untiye. ");
INSERT INTO for_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Piya utegina, ababoginisi wanipisa karebinti iyusuguna, pabigo pontaba asaba'wantiye. ");
INSERT INTO for_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Piya pogini, kana wanipisa karebi mintume a'ya'ma kina'miba Isu nkagora ampa parokaemagini maya untawe: Kaeba taga Koti Ntagaragawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Pigoya, kotupa ta'emagini Kenesareti kuma uwa mari iyuguni, ");
INSERT INTO for_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","wasanamiba Isupa agabebe pumagini yuguni, kana kuma'ama nkawamori mintanto kina igeba yonintana ibome kinapa ibabute kanauguni Isu maya omintawe: ");
INSERT INTO for_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Abintaga, kaigampa nkatuta aukaya pekana yonitepa tatawano, untawe. Piya ute, piya pume kina'miba kaba'ma aogi puwaentawe. ");
INSERT INTO for_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Pigoya, pi ntagaba Yerusaremi kumatisa Parasi kinape mono tisa kinape ka'isa Isuti ampa irosa'magini mayama abigama untawe: ");
INSERT INTO for_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Kabagi kina igeba nanaga tayabamagi meto kamana agoba aemita pewe. Piya puntini igeba naninta nakenaba, iyantanaba kampa punta uwa nawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Piya ute abigauguna, Isuba maya uwaimintiye: We, tigeba pipa nanaga tigeti mpeto kamana ago wasintiri, Koti ae'wa nkawamupisa kamanapa aemita pewe. ");
INSERT INTO for_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Piya, Kotiba mayama utantiye: Kaeba kano kaba kamana abimagina isi'waisipa asaga'yuyo, iye. Piya, ka'waina aeba anoke abakega kamparaga kamana uma ata puwaisitakibipa, aepa aeguma kaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pigoya, tigeba pipa aya pewe. Yagara araga igeba inogi ibagipa maya kamana uwaimewe: Nautasaenaba mapa tisigepa kampa tisiminta, tabe mono namapinti maete ima Kotiti a'muntana amukuwe, piya umagini, inogi ibagi kampa aogima iyo'maeyagiripa, tigeba abeganaba aogi piyo. ");
INSERT INTO for_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tigeba piya pumagiri Koti kamanapa aemita puntiri tigeti kamanapa maema wasima asaga'yuyewe. ");
INSERT INTO for_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","We, kumpari kina, tigeka Koti Aisaya omogana meto kamana ago mayama taga untiye: ");
INSERT INTO for_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ma kina'miba iwamutasaba nae nage asaga'yuntini, igu'amaba pagasara miyewe, iye. ");
INSERT INTO for_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Naeti mono'waipa kampa yewa, uwaba yewe, iye. Piya, nae kamana'nepa kampa unta, wasanami kamana yewema, Koti iyema, kaentiyema, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Pigoya, Isu aeba pi kamana uwaimite to ka'isa kina igega'e yogini kanauguna maya uwaimintiye: Naeba kamana urimekiripa aogima abima napiyiyo. ");
INSERT INTO for_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tintabaipinti tumemintana, pi'naba tigu'amapa i'nintanaba kampa potaye. Tiwamupintisa irosa'ma iyemintana, pi'na tigu'amapa i'nintanaba potaye, untiye. ");
INSERT INTO for_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Piya yogini, abagi kina igeba agora wamagini maya omima untawe: Kaeba kamana uwaimekini Parasi kina abimagini ata pepa abeno, untawe. ");
INSERT INTO for_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Piya yuguna, pi Parasi kinaka maya uwaimintiye: A'ya'ma yaba mantarisa nabanempaba kampa kurinti, pipa abu'yaga igima maebugaikiye. ");
INSERT INTO for_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Piya, tigeba igepa uwa itaiyo. Igeba iyorika kina'mi to ka'isa iyorika kina ke iyakikena kinane. Piya, ka aorika yagarama to ka aorika yagara ke ayakikibipa kaga agagabi tumikibese, untiye. ");
INSERT INTO for_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piya yogana Pitaba Isu maya omintiye: Meto kamana yempe'na nkagoba aborama yega taeba abeno, untiye. ");
INSERT INTO for_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Piya yogana Isu maya untiye: We, tigeba pabiyama tigu napi napiyena kampa wainta mintawa, a. ");
INSERT INTO for_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Agoba mayamagiripa kampa abewe: Tiwamupi nagana tintabaipinti tumimagina ayasaurite ke'wati to kake tumiye. ");
INSERT INTO for_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Piya, tintabaipinti waintana tiwamupisa irosai, pi'na tigu'amapa i'nintana pumagina kamparaga potaye. ");
INSERT INTO for_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Piya, wasana antabaipintisa aguntaena toma toma irosai, pipa mayamawe: Ata napiyenawa, wasana aegukenaenawa, kumiyenawa, kupiyonawa, kuntanawa, kumpari kamana otakenaenawa, akayasukenaenawa sumagina, ");
INSERT INTO for_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","pintanama tigu'amapa aegumagina i'nintanaba potaye. Piya, tiyantana kampa punta naninta nantanamaba tigu'amapa aeguma i'nintanaba kampa potaye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pigoya, Isu aeba Yuta kina ige maba atate to marisa kina'mi mpari Taya Saironi kuma waintusumeti wantiye: ");
INSERT INTO for_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wamagina umintogana, Kenani marisa wae, pi mara miyome nkwae'maba kanama Isuka kega'e uma agisumagina maya untiye: We, Wa'ega, kaeba Tebiti ntagaragawa, naeka kantara punatao. Araganepa kewama tabera aigarama amiyo piye, untiye. ");
INSERT INTO for_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Piya yogana abintanaba, Isuba kamanapa kapa kampa a'wae pomintiye. Piyama kampa a'wae pogini, abagi kina igeba omima maya untawe: Kaeba waya otagana wano. Aeba taka'i tabe kiga'e uta kanaye, untawe. ");
INSERT INTO for_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Piya yuguna aeba maya uwaimintiye: Naeba Isureyo aruyenabisa yaga kabubama miye kanta pe kina'amanamiti unatantine, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Piya yogana, kana wae aeba agora ampa irosa'ma parokaema esotamagina: Wa'ega, kaeba uwa nao'maeyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Piya yogana, Isureyo kina'mige uwa kina'mige mono abikibeka Isu meto kamanapisa maya omintiye: Yagarantomi ntaninta ipa'magi kara imekanaba kampa aogi pikiye, untiye. ");
INSERT INTO for_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Piya yogana, kamana mayama a'wae pumagina omintiye: Wa'ega, pipa kanara yene. Pigoya karantontomi ibawaimpigi naninta yabaera atamagini nagana aritawa tumeginiba pipa uwa nawe, untiye. ");
INSERT INTO for_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Piya yogana maya omimagina untiye: We waya, kamatiti'enaga imagina waintiye. Pi yempesa pugatano, untiye. Piya yogana pabigo aragawapa kaba'magina aogi puntiye. ");
INSERT INTO for_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Pigoya, Isu aeba pi mparasa to kake a'wae puma kanama Karariya kotuta ampa irosantiye. Irosa'ma amuti ima mintogini, ");
INSERT INTO for_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","uwoma kina kanagana pumagini aeti ampa irosantawe. Igeba igisa iya pu'wanta kinape, iyampu aigakayo'na'na kinape, iyorika kinape, aibo kinape, to ka'isa inuntana ibome kinape uwoma kina a'ya'ma ibabute kanama Isu agora ampa aki puwaitantawe. Aibuguna kaba'ma aogi puwaitawaentiye. ");
INSERT INTO for_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Piya pogini, aibo kina'miba kamana untawe. Igisa iya pu'wanta kina'miba ke nasintawe. Iyampu aigakayo'na'na kina'miba aogi puntawe. Iyorika kina'miba iyo agantawe. Piya puguni, wasanamiba pi agate Isureyo kina'mi Kotiwaipa tabera i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Pigoya, Isuba abagi kina igega'e uma maya uwaimintiye: Naeba a'ya'ma ma kina'mika nantara puwe. Igeba naege kakaga yaga mimagini iga'enaga purewe. Piya, naeba uwaitakini igeba naninta kampa nanta wamagini, ke'i uma iyonanta pumagini ware'nasanaga abimagi tara puwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Piya yogini, abagi kina'wampiba maya omintawe: Mapa ka'me mpariwa, tabe nanintaba aetasa aborama ma uwoma kinapa imekana naigina kanarasa waetakiyema, omintawe. ");
INSERT INTO for_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Piyama omuguna, Isu ibigama maya untiye: Tigeti ntanintaba ayaki waintiye, yogini, igeba maya untawe: Tonaentisa tara umaema paretiwa, uwaena inoyantantonto tarantowa sumagina waintiye, untawe. ");
INSERT INTO for_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Piya yuguna, abintana yogini kana a'ya'ma kinapa aki pumagini mara'mintantawe. ");
INSERT INTO for_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Piya puguna, kana paretibe inoyantabe maema Kotiti a'mu potamagina, apako pumagina abagi kina'wa imogini pako pumagini pi kinapa imintawe. ");
INSERT INTO for_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Imuguni, a'ya'ma kina namagini iga'e pantawe. Aibuguna, arita waiyomepa kibi'magini tonaentisa tara umaema wa'nu kupi iraguguna awaitantiye. ");
INSERT INTO for_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pigoya, naninta nanta waba 4,000 wa mintuguni, waya yagaraba kampa aisuntawe. ");
INSERT INTO for_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Piya potate, Isuba wasana uwaitaogini wauguna aeba wanipisa karebi imagina wama Magatani mari uma irosantiye. ");
INSERT INTO for_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Pigoya Parasibe Sarusi kinape igeba Isuti ampa irosa'magini amiyo pumagini maya untawe: Kaeba yegana mantarisa awame'ena aboraka agano, untawe. ");
INSERT INTO for_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Piya yuguna, aeba maya uwaimintiye: Tigeba ase ikena pegiripa maya yewe: Abayarere puwaewaikana aiba pa takiye, yewe. ");
INSERT INTO for_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Maregiripa maya yewe: Ibinapa tunusuma atami pikana ka aekiye, yewe. Tigeba ibinankama nkagoba abintawe. Pi ma kana'ama nkagoba nanaga kampa abewe. ");
INSERT INTO for_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Antage kina, mono kampa wainta kina, awame'ena ka agakenaga yewo. Tigeba tonaba kampaye. Yonati awame'ena aborantisa pumagina aborakiri agakibewe. Piya uwaimitegina itate wantiye. ");
INSERT INTO for_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pigoya, abagi kina igeba Isuge kotupa ta'emagini maroti uma irosantini, nanintaba igegu'ama kampa maenta wantawe. ");
INSERT INTO for_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Piya, Isu maya uwaimintiye: Pigoya, paretibi yisiti atagana anosamisa puma, Parasi Sarusi kina'mi ata kamana'wai anosasanaga kabiyiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Piya yogini, igeba mayama mare-u me-u puntawe: Pareti atate kanaompeka piyaba uramiye, untawe. ");
INSERT INTO for_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Piya kamana yuguna, pabigo kana kamana'ama agebi pasogana abite maya uwaimintiye: We, tigeba timatiti'enaba uwaenantowe. Tigeba nanaga naninta kampa maete kanakaba abima tara tara tigiba napiyewe. ");
INSERT INTO for_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Naeba ka'ena punto, pipa karu'ena tigegu'a pegiri kampa napiyewo. Naeba pareti nayakamutasa 5,000 kina'mi imuwagini namagini iga'e pauguni, aritapa kibi'ma wa'nu kupa ayaki iraguguna awaitantiye. ");
INSERT INTO for_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pareti tonaentisa tara umaema pabintantorasa 4,000 kina imuwagini namagini iga'e pantini, aritapa kibi'ma ayaki wa'nu ku iraguguna awaitantiye. ");
INSERT INTO for_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Pigoya, naeba nanintagaba kampa urimuwa, pipa aogimagiri abibebe pusanaga yuwe. Piya, naeba Parasi Sarusi kina'mi ata kamana'wai anosasanaga aogima kabiyiyo, yuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Piya kamana uwaimogini, ibaba abibebe pumagini maya untawe: We, paretiwama yisitigaba kampa iye. Parasi Sarusi kina'mi kamanaka aogima kabiyiyoma iye, piya untawe. ");
INSERT INTO for_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Pigoya, Isu aeba wamagina Sisariya kumata, Piripi kabinti kumata uma irosakena puntana, abagi kina'wa ibigama maya untiye: Wasanamiba Wasanama Ntagara naekaba kewe yewema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Piyama ibigaogini, igeba maya omima untawe: Igeba kae kageba toma toma sewe. Ka'isamiba Yoni mono wani pai'itanti ntagarawe yegini, ka'isamiba Iraiyawe yegini, ka'isamiba Yeremayawe yegini, to ka'isamiba to ka mintanti poropetewe, kaekaba piya yewe, piya untawe. ");
INSERT INTO for_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Piya uma omuguna, to kake ibigama maya untiye: Pigoya tigeripa pipa naekaba kewe, untiye. ");
INSERT INTO for_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Piya yogana Saimoni Pitaba maya untiye: Kaeba utaratanti ntagara Karaisiti, Koti miyaba ae yagaragawe, untiye. ");
INSERT INTO for_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Piya yogana Isu maya omintiye: Saimoni, Yona ntagara, kaeba ka'mu po. Ma kamanapa ka yagaramaba kampa ugamiye. Mantarisa nabanempa uma aboragamintiye. ");
INSERT INTO for_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pika naeba kamana ka ugamukuwa, abo: Pita kaeba yabakawe. Ma ntabata naokina'nepa itakini atokaemagini mintigina a'abiwama nkesegiyenamaba kampa ipasanakiye, untiye. ");
INSERT INTO for_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Piya untana to maya untiye: Naeba Koti kabiwaitakena kuma'ama kiwapa kamuwe. Pigoya mabi kabe ai'itaganaba, mantariba pabi nkawameta aborakiye. Piya, mabi kabe ki'itaganaba, mantariba pabi nkawameta pabiyamagina aborakiye, untiye. ");
INSERT INTO for_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Piya utegina, abagi kina'wapa kamana esegima uwaimima maya untiye: Naeka Karaisiti yagara mintiyemaba tigeba wasanaba ankuwaimiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pigoya pi ntaga Isuba agobima ainti a'ya'waemaena aborakibi, pi kamana aboramagina abagi kina'wa uwaimintiye. Aibuntana Yerusaremi kumati iyekini monota kabiyume kina'mibe, tabe mono kiye kina'mibe, mono tisa kina'mibe tabe kuntaenaba aboramimagini, aeguyigina pu'magina kakaga yaga mite to aogama asikibi, pi kamanapa a'ya'ma uwaimiwaentiye. ");
INSERT INTO for_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Piya uwaimogana Pitaba Isu abiri agega'e uma kabi'magina maya omintiye: Wa'ega, Kotiba kao'maeyakana pintanaba kampa aboragameno, untiye. ");
INSERT INTO for_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Piya yogana Isu aka'intaesi potama Pitapa maya omintiye: Satanigawa, kaeba natate wagaso. Kaeba antage ki nayakima Kotikaba kampa napiyene. Kaeba wasanama kamana'amana napiyene, untiye. ");
INSERT INTO for_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Pigoya, pabintaga Isu kamana ka mayama amato puma abagi kina'wapa maya uwaimintiye: Wasana ka'waina nae naegarakena puntanaba au'ama kamana akabitate wasanami igobi potakibikaba a-nkaekuru puma maripowa aesaga'uritegina naegarano. ");
INSERT INTO for_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pigoya ka'waina mikenaenawaka owe yekanaba, a'yugu potakiye. Piya, to ka'waina aeba naeka mikenaenawaka a'a-o yekanaba aboramikiye. ");
INSERT INTO for_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pigoya ka'waina aeba mabi a'ya'waemaena maemagina agu'amankapa aeguma kaiyekanaba, aya pukiye, a. Agupa ayamabaya to kakema ika pekana kanarasakiye, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","We, naeba yekiri abiyo: Wasanama Ntagara naeba, nabanempa mantarisa e'wasaenama naeti ampa e'wasa punataka, enisore kina'wapa ibabeka tumukune. Piya pumagi, a'ya'ma kina'miba mampabi pentana mana, pabi nkawameta antota'enaba imukuwe. ");
INSERT INTO for_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pigoya naeba taga urimukuwa abiyo: Tigetisa ma ka'isa minta kinapa kampa purintigi, Wasanama Ntagara naeba tumima wa'egaenanepa abora maema aborakini nagakibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pigoya, Isu aeba tonaentisa ka'umaema yaga a'ya puwaogana, Pitana, Yemisina, a'nanto Yonina, sumagina ibabute wasana kampa minta amuti intawe. ");
INSERT INTO for_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Pita'i iyora asima mima au'amaba to auga puntiye. Piya pogana, aowawamaba pankama nke'wasa pemisa puma e'wasa puwantiye. Aibogana kaiwampaba wae'wae pumagina tabera e'wasa puwantiye. ");
INSERT INTO for_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Piya pogana, Mosesege Iraiyage pabigo ampa aborama aege kamana uma abuguna igeba igantawe. ");
INSERT INTO for_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piya puguna, Pitaba Isu maya omintiye: Wa'ega, mata'i miyokana aogi piye. Pika abintaga kakaga ke nama kiyeno, kae'ena kana, Mosesenta kana, Iraiyanta kana sumagi, kiyeno, untiye. ");
INSERT INTO for_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piya yogana, pabigo wae ibinankama tumimagina itikaewantiye. Aibogana ibinankama antabaipintisa kamana ka mayama tumintiye: Mepa nabugai ntagaranene. Tabera na'mu potauwa, ae kamana abiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Piya kamana abite, abagi kina igeba iyowarisa aigarepa'magini tabaraba pumagini tabera iyekuru puntawe. ");
INSERT INTO for_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Piya puguna, Isuba igora wama aya ikaya puma maya untiye: Tigeba asima, karuba a-pumagiri miyiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Piya yogini igeba iyoma'magini agaumepa, Isu abiwa agantawe. ");
INSERT INTO for_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Pigoya, amutisa tumintini Isu maya uwaimintiye: Ma kasa'ena aga, pi kamana wasanaba a-nkuwaimima mintigi, Wasanama Ntagara naeba purintapisaba naogamagi asiyekiri uwaimiyoma, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Piyama uwaimogini, pi abagi kina'wa abigama maya untawe: Iraiya marupa irosakana ae aka'i utaratanti ntagara Karaisitiba irosakiyeba, mono tisa kina'miba nanaga yewema, abigantawe. ");
INSERT INTO for_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Piyama abigauguna maya uwaimintiye: Iraiya aeba taga kanama a'ya'waemaena ampa maemagina aogima arupu pikiyeba untane. ");
INSERT INTO for_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pika urimekiri abiyo: Iraiya mparu mpaenti ntagaramaba ago irosa'ma mintogiri, kampa napinta, tigeti ntapiyena aega'ma ataena potantane. Piya, Wasanama Ntagara naepa pabiyama ataena punatakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Piya yogini igeba mayama abintawe: Pipa Yoni mono wani pai'itanti ntagara aeka iye, untawe. ");
INSERT INTO for_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pigoya, amutisa tumimagini amuri wasana mintumeti tumpa irosauguna ka yagara Isuti kanama agora ampa parokaema maya omintiye: ");
INSERT INTO for_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Wa'ega, kaeba yagaraneka kantara potao. Aeba aonanta puma ware'naowa pumagina tapa wagite wanipintiba tumite piye. ");
INSERT INTO for_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Piya pegi abagi kinakampiti ababute kanaogini kaba'ma aogi potakena pugagate igiga pumagini uwa atawe, piye omintiye. ");
INSERT INTO for_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Piya omogana Isu maya omintiye: We, timatiti'ena kampa wainta amu kina tigeba, naeba ayaki yaga tigege mimagi kuntaenaripa aesaga'magi tiyo'maema mikuwe, a, untiye. Piya umagina: Kana yagaranto ababute kanaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Piya yogini igeba ababute kanauguna Isu kana ke kina kabiraogana kana yagaranto atate waogana aogi puntiye. ");
INSERT INTO for_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Aibogini, abagi kina igeba abiri abigama maya untawe: Taeba nanaga ke kina agarubakenaba pugagate ataune, untawe. ");
INSERT INTO for_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Piya yuguna, aeba: Timatiti'enaripa uwaenantowe, uwaimintiye. Piya untana to maya untiye: Taga timatiti'ena uwaena yamanka'anto kanta puma wairitantagiripa, maro nkamu'amaka: Tigabao, yiginaba tigabakiye. Pigoya, aintiba ka yuga kampa waintigiripa kanara kampa pikibewe. ");
INSERT INTO for_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","(Piya, ke kina pipa to ka'enarasaba kampaye, uwa nunamurasage monoka naninta a'a-o uma mikenaenarasage igarubakibewe, Isu piya untiye.) ");
INSERT INTO for_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Pigoya, ainti Isuba Karariya mari nasi nasi puntana, abagi kina maya uwaimintiye: Wasanama Ntagara naeba e'ero ntagaba kampa mintakana minaga'ena puma wasanami nkiyapi natakini, ");
INSERT INTO for_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","naeguyigi pu'magi, kakaga yaga miyekana to kake nabage pikiye, untiye. Piya yogini, abagi kina'miba abite ata inta paritantawe. ");
INSERT INTO for_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Pigoya, Kapaniyamu kumati a'wae puma kanauguni tabe mono namankama takisi mone maemagini mintantawe, piya pume kina'mi ige Pita abigamagini maya untawe: Tisarimpaba tabe mono namankama takisi atabera aya piye, untawe. ");
INSERT INTO for_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piya yuguna, Pita maya untiye: Owe. Aeba ataikaiwe, untiye. Piya ute Isu mintome ntamapinti imaginaba kana kamanapa kampa omintogana aewa abigama maya untiye: Pita kaeba nana kagi napiyene. Mabi to marisa tabe kina'miba igeba ketisa tabe takisi moneba maeyawe. Iyo'mitisabe uwa to ampa kabinta kina'mitisabaya maeyawema, abigantiye. ");
INSERT INTO for_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyama abigaogana: Pi ampa kabinta kina'mitisawe, untiye. Piya yogana Isuba to maya omintiye: Pipa kanara yena, pigoya pika iyokina igeba uwa miyewe. Pigoya, taeba Koti nkaokinatawe. ");
INSERT INTO for_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","We, igeba taeka abima a'yugu atabusanaga kotuti wama iga'na atagana tumokana inoyanta maru okabikibi, pi paibuma awamu atarama ka mone maema wama tasigekaba tabe mono namankama takisi menkimo, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Pigoya, pabi ntaga abagi kina igeba Isuti wamagini maya uma abigantawe: Koti kabiratakena yaga aborakanaba ke tabeba mikiye untawe. ");
INSERT INTO for_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Piya yuguna, Isu uwaena yagaranto ka kega'e yogana kanaogana abakankaipi asitamagina, ");
INSERT INTO for_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","maya untiye: Taga urimukuwa abiyo: Tigeba tigupa a'wae puma yagara araga ano aba aegaramisa puma mikibepa, Koti kabiratakenaenama nkagupi uma pasikibewe. Piya kampa pikibepa taga kampa uma pasikibewe. ");
INSERT INTO for_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Piya, ka'waina aeba ma ntagaranto ae awameta tumima mikibi'naba Koti kabiratakenaenama nkaguta kiya mikiye. ");
INSERT INTO for_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Pigoya, ka'waina naeka napimagina ma kana yagaranto ao'maekibi'naba pipa aeba nae nao'maekiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Pigoya, Isu to kamana maya untiye: Piya, maya yagaranto naegarakana, ka'waina ayakekana kamparagaena pukibemipa, kana ayakikibi ntagara araku'ma tabe yabantama ana'mubi ubu'atama tabe wanipinti apasanakasagana naisemisinta: Pipa kanara pewe, yesine. ");
INSERT INTO for_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aguntaena pukena amiyo'ena asi nasiba mara aboragita, ataenabi miyune. Aibegiba, aguntaena aborakibi ntagarama aintiba ataenabi mikiye. ");
INSERT INTO for_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pigoya, kayankamabera kagisawama kamparagaena pikena pekanapa, arisa'ma maebugaso. Kagisa kaya tararasa aguntaena pekanaba, ainti tayaba tayaba yakupi maebugatasanaga piya po. Kagisa kaya kampa wainta yagara mintana miyaba kumati uma irosakibempepa, pipa kanarane. ");
INSERT INTO for_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Pigoya, kao agama kamparagaena pikena pekanapa pi'ma maebugaso. Tara kaoyaga mintana ainti tayaba yakupi maebugatasanaga piya po. Kaorika mintana miyaba kumati uma irosakibempepa, pipa kanarane, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Pigoya, Isu to kamana maya untiye: Tigeba pasemagiri ma ntakarantonto igekaba abigina uwaena kantaba a-peno. Naeba pika urimukuwa abiyo: Enisore kina'wai igeba mantarisa nabanempa nkaobi asi nasi aborama miyewe. ");
INSERT INTO for_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","(Pigoya, Wasanama Ntagara naeba kabubama miye kina iguyosa'ma ibabikena tumintone.) ");
INSERT INTO for_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Piya, ka'waina sipisipiwa 100 igetisa ka'anto kabubawakanaba kaikibera, 99 igepa itate kabubinti wama kaka wai'naka uma aguyosakiye. Pika tigeba nanawe yewe. ");
INSERT INTO for_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Naeba tagaka urimukuwe. Aeba aogima aguyosagakiye. Aguyosa'ma aboratamaginaba, 99 minta igeka wanane. Kaka wai aeka a'mu pikiye. ");
INSERT INTO for_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Piya, ma ntakarantonto igetisaba pabiyama ka'wainaba kamparagaenabi misanaga mantarisa nabanempati kampa aogi piye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Piya untana Isu to maya untiye: Pigoya kao'yagara ka'waina kaeti aguntaena maema aborakanapa kaeba wama tisibiri aguntaenawapa aborama omo. Aeba kamanaka abima paruma kayone pekanapa abegana pabigo a'ya peno. ");
INSERT INTO for_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Piya, kamanaka a'a-o uma kampa abekanapa, ka yagarawo, tara yagarawo isiba peginisi isige agowapa kaga abima uma arupu potaiyo. ");
INSERT INTO for_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Piya, kapi kamanati a'a-o uma kampa abekiripa mono kiye kina'mi-nkakiyenabi ababotaiyo. Ige kamana a'a-o umagina kampa abekiripa: Aeba to kina, agunta kinane, otaiyo. ");
INSERT INTO for_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Pigoya, naeba taga urimukuwa abiyo: Tigeba mabi a'ya'waemaena aguntaenawai uwa ataigina waiyekanaba, mantariba pabiyama waikiye. Piya, mabi uma uwa kasiginaba, mantarisa pabiyama uwa kaikiye. ");
INSERT INTO for_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Pigoya abiyo: Tigetisa tara yagara taramisi ka'enaga isigu kata atokaemaginisi esotaisiginaba, mantarisa nabanempaba abiwaisimikiye. ");
INSERT INTO for_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Piya, wasana tarawo, naeka akibigipa, naeba ibakapi mikuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pigoya Isuba kamana piya yogana, Pitaba aeti uma mayama abigantiye. Wa'ega, nao'yagarama aguntaena punatakapa, aguntaenawapa asu'a pugasakana ayaki pekana kanarasakiye. Piya, asu'a pugasakana tonaentisa tara umaeyakana kanarasakiyoma, abigantiye. ");
INSERT INTO for_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Piyama abigaogana Isu maya omintiye: Tonaentisa tara umaemaba kampaye. Kampa aisuntaenaba uwa asu'a pugaso. ");
INSERT INTO for_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Pigoya, pika Koti kabiratakenaenaga, meto kamana yekiri abiyo: Ka marasa tabe yagara ka'waina kayokaya yakarakinunka: Iretane namikibewema, igega'e untiye. ");
INSERT INTO for_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pigoya, ka yagara ababute kananta aetiba iretawapa 10,000,000 tora waintantiye. ");
INSERT INTO for_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Aeba tabe irita pipa antota amikenagaba mone aguyosagantiye. Aibogana tabe yagara aeba pi ntagarama nkwaya yagarawape, aewape, yaga kotankape a'ya'magini wasanami ikantana maeyigina, kana monewamaba ae'enaena puwaewanema, untiye. ");
INSERT INTO for_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aiyogana, kayokaya yagara aeba tabe yagarama nkagisabi ampa parokaema maya uma agisuntiye: Tabe yagarane, kaeba uwa nataga naeba ainti iretagapa kamenoma agisuntiye. ");
INSERT INTO for_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Piyama agisogana tabe yagara aeba antara potama iga'na namapipa kampa ababotanta atunkapa uwa atatantiye. ");
INSERT INTO for_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Piya potaogana namapintisa irosa'ma tumima waomepa kana kayokaya yagara ao'yagara ka tumpa abatama, aeti atunkapa 100 tora waintogana, abatama araku'ma ana'mu kana u'ma tutusotama maya untiye: Atuntepa pabigo ma kanara namo, untiye. ");
INSERT INTO for_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Piya yogana, ao'yagara aeba agora uma parokaema agisuma maya untiye: Kaeba uwa nataga ainti naeba iretagapa kamukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Piya uma agisogana, kamana'wapa kampa abinta wama yogini ao'yagaraba maya uma iga'na namapi ababotantawe. Aibuntini maya omintawe: Iretagapa amiwaegaite irosakibene, untawe. ");
INSERT INTO for_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Piya pogini, aege atokaema yoga pume kina'miba agate igeba intara pumagini wama tabe yagara kana kamana uma omiwaentawe. ");
INSERT INTO for_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Piya yuguna aeba abite kayokaya yagara aepa to kake kega'e uma maya omintiye: Kaeba kamparaga yagaragawe. Nagiseka naeba nantara pugatama tabe iritanepa atagatauwe. ");
INSERT INTO for_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","We, kaeba kao'yagaraga pabiyama kantara potama au'isanawe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Piya uma tabera amo'ena pumagina irebu kina'miti atama maya untiye: Tigeba kamparagaena potama karana atamagiri miyigina tabe iritanepa a'ya wakiri ataiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pigoya, tigeba tinta ase'yonabisa aguntaena kampa mae igasiginaba mantarisa nabanempaba pabiyama kuntaena puritakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pigoya Isu aeba toma toma kamana uma a'ya atate, Karariya maba atate Yontani wani mparoteri ura'ema wama Yutiya irosantiye. ");
INSERT INTO for_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Irosaogini wasana uwoma kina'mi igeba aegarauguna yoni kina'wai kaba itantiye. ");
INSERT INTO for_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Aibuguni, ka'isa Parasi kina'miba aeti irosa'ma, amiyo potakena maya uma abigantawe: Ago kamanatepinti wasanama waya ka'maenaraka puma waya kaikenaba kanara payawa, uramoma abigantawe. ");
INSERT INTO for_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Piyama abigauguna maya uwaimintiye: Tigeba mono kamana mayama waintipa, pipa kampa aisuma abewa, a. A'ya'maena Koti maru maema aborantanaba, wabe wayape kaga aborawaigitantine. ");
INSERT INTO for_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Aborawaisitama, maya untine: Pika wamaba anope abape isitate waya'wampati uma atokaema, isigeba ka kina kanta puma miyese, untiye. ");
INSERT INTO for_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Piya, isigeba taraba kampa punta, ka'ena puma miyese. Koti atokae isitantika, wasanamaba a-nkatara isitano, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Piya uwaimogini igeba maya untawe: We, pipa Moseseba waya kaikena puntiripa esa amima otaiyoba, piyaba nanaga untiye, untawe. ");
INSERT INTO for_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Piya yuguna Isuba maya uwaimintiye: Monoka kampa karu'ena abima tige akuneka Mosese waya kaikenaenagaba abima owe puritantine. Piya, agobinti'naba piyaba kampa untine. ");
INSERT INTO for_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Pika naeba urimukuwa abiyo: Ka'waina waya'wampaba kumiyonaba kampa puntakana uwa kaite to wae maekibipa, aeba kumiyenaba pikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Piya yogini, abagi kina igeba maya omima untawe: Wawaya isige agoba piyama waintika, waya kampa maenta uwa mikenaenaba, pipa kanarane, untawe. ");
INSERT INTO for_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Piya yuguna Isu maya uwaimintiye: Pi ye kamana ukubopa, pipa uwa kina'mi wanane. Pi utawaitanta kina'mi mana ubikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wasana ka'isa kinapa inogi intabaipintisa waya kampa maekena kina aborawe. Piya, ka'isa kinapa wasanami i kasamagini waya kampa maekibewema, uwaitawe. Piya, to ka'isa kina'miba mantari kabiratakenaenaga napimagini waya kampa maenta uwa miyewe. Pigoya, ma kamanapa otawaitai kina'mi mana abima aegaraiyo, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Pigoya, igeba inamu ntakarantontowai Isuti ibabute kanauguna, ayapa i'nota atama nunamu ikiyema omintawe. ");
INSERT INTO for_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Aibuguni, abagi kina igeba karu kamana uwaitauguna, Isuba maya untiye: Tigeba itaigini yakarantonto igeba naeti kanaiyo. Tigeba a-nkakunkitaiyo. Piya miye kina'mi kaba Koti kabiratakenaenaba utawaitantine, untiye. ");
INSERT INTO for_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Piya ute ayapa inota atama kayone puwaitategina, kana maba atate tori wantiye. ");
INSERT INTO for_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Pigoya, ka yagarama Isuti ampa irosa'ma abigama maya untiye: Tisa, naeba aogiyenaba aya pukuboti, e'wasaena maemagi a'ya'ma yagaba miyaba mikuwoma, abigantiye. ");
INSERT INTO for_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Piyama abigaogana, maya omintiye: Pi aogiyenagaba nanaga nabigane. Aogiyenama nkagoba ka'anto mintiya, kaeba a'ya'ma yaga miyaba mikuwe untanapa, ae kamana ago abima wasiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Piya yogana, aeba: Ae kamana agowema, abigantiye. Abigaogana maya untiye: Paisa mono ago kamana'amaba maya iye: Kaeba wasanaba a-nkaeguma kaiyoma, kumiyenaba a-poma, kuntanaba a-poma, kumpari kamanapa to wainapa a-sotaoma, ");
INSERT INTO for_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kano kaba kamana wasiyo. Piya puntana kaekaka kabemisa puma kaokinakaba pabiyama kabeno, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Piya yogana kana yagara aeba maya omintiye: Pipa wasirite kanama mintantone. Pika kapa aya pusuwema abigantiye. ");
INSERT INTO for_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Abigaogana Isu maya omintiye: Kaeba arupu puma aogima mpikenaga untanapa, wama kotagapa to kina imima mone maemagina kusi kina imegana aogima miyepa, mantari aogiyenagapa aboragamekana kaeba kanama ampa naegarao, untiye. ");
INSERT INTO for_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Piya yogana kana yagara abima kamparaga potate wantiye. Kotapa taberaka'ya waitantogana, pika piya puntiye. ");
INSERT INTO for_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Piya pute waogana, Isuba abagi kina'wa maya uwaimintiye: Naeba taga urimukuwa abiyo: Tabe kutantaga kina'mi kabiratakena manta kumati ikenagaba pipa igiga puma tabe kuntuyenawe. ");
INSERT INTO for_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Naeba pabi kamana to kake urimukuwe. Tabe kamoro yagawama na'ama nkagepinti uma pasikenaenaba pipa esegiyenawe. Piya, tabe kutantaga yagaramaba Koti kabiratakena kumati ikenaba pipa to awameta, tabe kuntaenawe, untiye. ");
INSERT INTO for_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Piya yogini, abagi kina'miba pi kamana abite pami pumagini maya untawe: We, kebaya mantariba ikiye, untawe. ");
INSERT INTO for_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Piya yuguna Isuba igantana maya untiye: Pipa wasanama piya pikenaenaba kampa waintiye. Pipa Koti ka pikenaena waintiye, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piya uwaimogana Pitaba pabigo awamuta u'magina maya untiye: Abo, taeba a'ya'waemaenarepa takabiwaetate kaepa kaegaraune. Pigoya aintiba pi'na nkantotapa nanaena aboraramikiye, abigantiye. ");
INSERT INTO for_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Piyama abigaogana Isu maya uwaimintiye: Naeba taga urimekiri abiyo: Aintiba a'ya'waemaena aborama aogi pikena kanabipa, Wasanama Ntagara naeba e'wasa naemu yabaeneta miyekini, naegara kina tigeba pabiyama mampabisa tabe kina'mi nkimu yabae nagisarisa tara tumpaema pita'i mima, Isureyo aruyena to nagisarisa tara tumpaema kina'mi ige kamana uma a'ya itakibewe. ");
INSERT INTO for_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pigoya, ka'waina aeba naeka uma aganto, a'nanto, amana'ma, ano aba, araga yagarawa, kuma'wa, kiyanka, atate aeba naegarakibi'naba pi'na antotapa uwomantana maema mintana aintiba miyaba'ena maekiye. ");
INSERT INTO for_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Piya, iba ka'isa kiya kina'miba igeba kayokaya kina miyigini to iba kayokaya pe kina'miba igeba kiya kina uma mikibewe, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Pigoya, Isu to kamana maya untiye: Koti kabiratakenaenaba waini yugawama nkaba aeta meto kamana ukuwe. Piya, waini yugawama nkaba ka'waina abaya aseka ka'isa kayokaya yagara ibabikena wantiye. ");
INSERT INTO for_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Pigoya ka'isa ibabuma ka yagasa ikantanaba wantora piya uma aborawaimogini abuguna kanarasaogini yogawati uwaitaogini wantawe. ");
INSERT INTO for_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pigoya to pabi ntaga abaya to kake wama ka'isa kina maketi kumati uwa mintuguna, ");
INSERT INTO for_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","uma igama maya uwaimintiye: Waini yugane waintiya, wama uma pigi, ikantanaba kanara timukuwe, yogini, abite waini yugawati wantawe. ");
INSERT INTO for_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pigoya, kagi abebege atamaisakenage pogana, to kake wama pabiyama uma ibabuntiye. ");
INSERT INTO for_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Pigoya atamai to kake wama ka'isa kinapa yoga kampa punta uwa mintuguna uma ibatama maya uwaimintiye: Tigeba nanaga e'ero ntaga uwanama mintagana atamaisaye, untiye. ");
INSERT INTO for_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Piya yogini maya omintawe: Ka yagaramaba yoga kamanapa taepa kampa tababuma urataine, untawe. Piya yuguna maya uwaitama untiye: Waini yugane waintiya, wama piyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Piya, yogawama nkababa piya puma mintogana, aseyogana kiya yagarawa mayama omima untiye: Kaeba yoga kina igega'e uma mone imo. Ainti ibabo kina'mitisa agobima imirite wamagina maru ibabo kina'mitiba uma imima a'ya po, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Piya yogana abite ainti atamai ibabunta kina ige igega'e yogini kanauguna ka'wainanta ka'wainanta wantora imiwaentiye. ");
INSERT INTO for_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Piya imogini, maru kanaume kina'mi igeba agate: Taepa ikantanaba mesuba puma tamikiyema, napintawe. Aibuguna pabiyama wantora wantora imintiye. ");
INSERT INTO for_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Piya imogini agate, yogawama nkabapa kabi'ma maya untawe: ");
INSERT INTO for_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ainti kana kina igeba yogaenaba uwa anagi'ena ampa pewe. Piya taeba pipa pankaerugumpa taise pagapaga yugaena puma mintokana ase iya, pipa nanaga ainti kana kina igeke ka awametapa tamiye, untawe. ");
INSERT INTO for_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Piya yuguna, yogawama nkababa igetisa ka yagara maya omintiye: Nao'yagara, naeba ataenaba kampa pugatauwa, kaeba wantoraga ugamogana abima kanarane yempene. ");
INSERT INTO for_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pika monegapa maete wao. Naeba ainti kana kinapa kaeke ka awameta timukuwema napiyegana kanarasaine. ");
INSERT INTO for_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Pintanaba pipa nae'enawe, pika naeba agowama nae napimagi, piya mayaena pikena untapa pukuwe. Kaeba nanaga nanta aseyonaneka poganapa abima ataba pene, untiye. ");
INSERT INTO for_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pika kayokaya kina'miba kiya kina miyigini, kiya kina'miba kayokaya kina mikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Pigoya Yerusaremi kumati ikena puguna, Isu aeba abagi kina nagisarisa tara tumpaema ige'amana ibabogini ibiwai wantawe. Ke'i wantini maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Abewo, taeba Yerusaremi kumati iyune. Pita'i nabanempaba Wasanama Ntagara naepa tabe mono kiye kinape mono tisa kinape ige iyapi natakini igeba: Aeguyiyoma, unatamagini, ");
INSERT INTO for_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","namu'isa kina'miti unataigini igeba karana natama eru kasutasa naeguma maripora ita nataigi purukuwe. Pu'magi kakaga yaga miyekana nabanempaba to kake asinatakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Pigoya, pi ntaga isinowaisimpa Sebeti ntagara tara isibabute Isu nkagora ka'enaga esotakena uma parokaentiye. ");
INSERT INTO for_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Uma parokaeyogana abigama maya untiye: Kaeba nanaga kabiye, yogana, aeba maya untiye: Kaeba yega, yagarane tara ainti tabe Wa'ega aborakibempe ntagaba kayatakanti kayake'masima mikibese, untiye. ");
INSERT INTO for_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Piya yogana Isu maya omintiye: Tigeba aibo'enarika piyaba yewe. Nae nantara'enabi tisigeba kanara pasikibeso, untiye. Piya yoginisi isigeba: Owe, pabiya pukuse, untase. ");
INSERT INTO for_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Piya yusuguna maya uwaisimintiye: Nae nantara'enabi taga pasikibese. Pigoya, nayatakanti nayake'masi mikena kamana ukenaenaba pipa naetiba kampa waintiye. Nabanempa uwaitanti kina, ige pi yabaerapa mikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pigoya, to nayatara'mu abagi kina'miba pi kamana abite kana agantoke a'nantokeba ka isibirantawe. ");
INSERT INTO for_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Piya puguna Isuba igega'e uma maya uwaimintiye: Mampabisa tabe kina'miba esegima kabiwaitawe. Imagini miye kina igeba uwa kinapa igasimagini tabe kina'wai miwaetawe. Pipa abintawe. ");
INSERT INTO for_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pigoya tigeba itigiso atigiso piyo. Pika tigetisa ka'waina imagini kiya mikena puntanaba, aokina'mi kayokaya'ena pumagina miyeno. ");
INSERT INTO for_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Pigoya ka'waina aeba paitaritamagina kiyari mikena puntanaba, aokina'mi ige yoga kina miyeno. ");
INSERT INTO for_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Piya, Wasanama Ntagara naeba pabiyama tige nae kayokaya'ena punataiyomaba kampa tumintone. Naeba tige kayokaya pumagi, mikenaenanetasa uwoma kina ika puma a'watitakena tumintone, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Pigoya Isube abagi kina'wape igeba Yeriko kuma agaite wauguni, wasana uwoma kina'mi iyega'ma wantawe. ");
INSERT INTO for_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Piya pugunisi, isiyorika yagara tara ke awamori mintusuguni, Isu kanama ke'i waye, untawe. Yugunisi abite pabigo agasiya kiga'e uma maya untase: Wa'ega, kaeba Tebiti ntagara tasigeka kantara po, untase. ");
INSERT INTO for_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Piyama tabera kega'e yusuguni, a'ya'ma kina'miba: Paka pisoma, uwaisimumepa, isigeba kampa abintinisi to kake esegima kega'e umaginisi maya untase: Wa'ega, Tebiti ntagara, kaeba tasigeka kantara purasitao, untase. ");
INSERT INTO for_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Piya yusuguna, Isu aeba abite keta asimagina mintana yoginisi kanausuguna: Nana purasitaomagirisi yesema, isibigantiye. ");
INSERT INTO for_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Piyama isibigaoginisi maya omintase: Wa'ega, tasiyo agarasitaoma yuse, untase. ");
INSERT INTO for_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Piya yusuguna, isiyora aukaya pogana pabigo isiyo apina'ma agantase. Aibuntinisi Isu aega'ma wantase. ");
INSERT INTO for_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Pigoya, wamagini Yerusaremi kumata uma irosakena puntawe. Piya puntini, Oribesi amuta irosa'ma uwaena kuma'anto ka, agewapa Petipaesi pipa agaikena puntana Isuba abagi kina'wampitisa tara yagarara uwaisimima isigaruba'magina, ");
INSERT INTO for_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","maya untiye: Tisigeba mareta'i uwaena kuma'anto waintiti wamagirisi, tonki yaga anobe aikeribe iga'nara mintakibesa, uma iyoba'ma isibabute kanaiso. ");
INSERT INTO for_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Tisigeba piya pisigina ka'waina tisibigakirisiba maya omiso: Wa'ega aeba pikaba a'yo mpaekenaga iye, omiso. Piya yisiginaba owe urisitakiye, piyama uwaisitaoginisi wantase. ");
INSERT INTO for_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pigoya, pintanaba uwaba kampaye. Poropete ae meto kamana'ama esegi penema piya puntane. Aeba maya kamana kaentiye: ");
INSERT INTO for_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tigeba Saiyoni kumatasa kinapa maya uwaimiyo: Abewo. Wa'egari aeba aguparuyenawaka uma tonki yaga akabapi mima tigeti waye, iye. Pika aikeri yaga akabata mima waye, piyama kaentiye. ");
INSERT INTO for_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pigoya uwaisitaoginisi abagi yagara tara isigeba wamaginisi Isu nkawamu wasimaginisi, ");
INSERT INTO for_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","yaga anoke aikerige uma iyoba'urite kanausuguni, kaiwaipa atamagini abobori ama agutauguna ima mintantiye. ");
INSERT INTO for_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Piya pogini, uwoma kina'mi kaiwaipa atamagini ke'i ama aguta wauguni, ka'isa kina'miba yanta aerisa'ma agurite wantawe. ");
INSERT INTO for_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Aibuntini, uwoma kina'mi aoribe aka'ibe wama i'mu potama maya untawe: We, Tebiti ntagara taeti kanaye. Wa'egawama nkawamuta kanaika ta'mu potano. We, inatisa yagaraga ta'mu potano, uta wantine. ");
INSERT INTO for_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Pigoya Yerusaremi kumati iyogini, kuma ago kina'miba pami pumagini maya untawe: Pipa ke kanagini yewe, yuguni, ");
INSERT INTO for_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","maya uwaimintawe: Poropete Isu, aeba Karariya mari Nasareti kumatasa aboranti'na pimpaye, piya untawe. ");
INSERT INTO for_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Pigoya, Isuba pita'i tabe mono namapi iyomepa pita'i ikantana puma mintuguna, igarubantana mono ankami ankami pume kina'mi ntabaebe kabara ataume ntabaebe apasana'ma asunukaentana, ");
INSERT INTO for_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","maya uwaimintiye: Mono isa'ama maya iye: Mono namantepa nunamu ukena namantana peno, iye. We, tigeba piya kuntana pe kina'mi ntamantana piye, uma igarubantiye. ");
INSERT INTO for_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Piya utegina, pi tabe mono namapinti mintogini iyorika kinape iraena ibome kinape aeti kanauguna kaba itantiye. ");
INSERT INTO for_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Piya pogini, tabe mono kiye kina'mibe mono tisa kina'mibe igeba pi esegiyena ometana agantini yagara araga tabe mono namupi i'mu potamagini: Tebiti ntagara taeti kanagi ta'mu peno, piya yuguni abintini, igeba kamparaga potamagini, ");
INSERT INTO for_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Isu maya omintawe: Ma nkaraga yagarami i'mu pugatapa abeno, untawe. Piya yuguna Isu maya untiye: Naeba ago abuwe. Piya, mono kamana ka waintipa mayama kampa aisewo: Inamu kina nonotasa kina'mi inta maema ase'yo pegana iwamupi Kotiti i'muntana aogima aboraye, pipa kampa aisewoma, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aibumagina, akabiwaitate Yerusaremi kumatisa tumimagina Petani kumati ima ase yogana waintiye. ");
INSERT INTO for_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pigoya, abayara tabe kumati a'wae puma kanaogana aga'ena abuntiye. ");
INSERT INTO for_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Piya pogana ke awamora piki ya ka agategina wama agori a'waka uma aguyosagaomepa a'yenkamana waintogana agantiye. Agate kana ya maya omintiye: Kaeba apa toganaba kampa aekibene, yogana, pabigo kana yaba tamiri'ma asamagina pari puwantiye. ");
INSERT INTO for_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Piya pogini abagi kina igeba agategini pami puma maya untawe: We, ma ntaba nana pumagina agaropa asaye, untawe. ");
INSERT INTO for_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Piya yuguna Isu maya uwaimintiye: Naeba taga urimekiri abiyo: Tigeba tigu'ama tara tara kampa punta esegima timatiti pumagiri mikibepa, pipa yara kukantana aboramisa puma pipe to ka'isaena pikibewe. Piya, tigeba maro amu'amaka: Kaeba tigaba'ma wanipinti tumo, yesinta, pabi ikibesa pesine. ");
INSERT INTO for_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pigoya, aogima timatiti puma mintiri a'ya'waemaenaga esotaiginaba Koti aborarimikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Pigoya, wama tabe mono namapi ima mono untiye. Umagina mintogini, monotasa tabe kiye kinape Yuta kina'mi monota kabiyume kinape igeba aeti wamagini maya uma abigantawe: Kaeba mata'i a'ya'waemaena pempepa ke nkawamuta pene. Ke ugatagina pene, untawe. ");
INSERT INTO for_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Piya yuguna, Isu kamana maya uma a'wae pumagina uwaimintiye: Naeba ka kamana tibigakiri unamigi, naeba pabiyama ke nkawamutapaya a'ya'waemaenaba poka pipa antotapa urimukuwe: ");
INSERT INTO for_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yoni mono wani pai'itantintana aetasa aborantiye. Pipa mantarisaenabera wasanamintanawema, ibigantiye. Piyama ibigaogini igeba: Nana kamana omusune, ugate uwa asaba'wantawe. Aibuntini maya untawe: Taeba mantarisaenawe yekanaba, nanaga kamana'wapa kampa abintawe, ukiye. ");
INSERT INTO for_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Piya, wasanamantanawe yekiniba, wasanamiba Yonikaba tabe poropetewe umagini ataena puratakibewe, untawe. ");
INSERT INTO for_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Piya utegini igeba: Kampa abintune, untawe. Piya yuguna Isu kamana mayama a'wae puwaimintiye: Pi yepa kanarana, pipa naeba pabiyama ke awamutapaya a'ya'waemaena poka antotapa kampa urimukuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Piya untana to maya untiye: Kamana ka urimekiri abimagiri agaiyo. Ka yagarama ntagara tara mintantase. Aibusuguna aeba amaru yagarawa maya omintiye: Yagarane, ibaba kaeba wamagina waini yugaena uma po, omintiye. ");
INSERT INTO for_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Piya omogana kana yagara aeba maya untiye: Aerawane, kampa nabosagaye, untiye. Piya utegina ainti to uma a'wae puma napimagina uma puntiye. ");
INSERT INTO for_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Piya pogana isibaba aeba to aintisa yagara pabi yoga kamana omogana maya untiye: Naeba kanaraka uma pukuwe, untiye. Piya ute ainti antawama ata pogana atate wagaintiye. ");
INSERT INTO for_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pigoya, tigeba aentagaramaba abawampa nkawamu wasintiyeba yewe, untiye. Piya yogini igeba: Amaru yagarawampawe, untawe. Piya yuguna Isu maya uwaimintiye: Naeba tagaka urimukuwe. Ae pemisa puma takisi maeya ku kinape kupiyo waepe paitamagini Koti kabiratakenaenama nkagupi uma pasigiri, tigeba aintisaena pikibewe. ");
INSERT INTO for_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Piya, Yoni ampa irosa'ma arupu puma mikena ki tiyakogiripa, tigeba mono'wapa a'a-o yuguni takisi maeya ata kinape kupiyo waepe ige uwasuwama a'yugu mikenaenawaipa atategini wasintane. Igeba piya puguripa, tigeba igantiripa aintiba kampa tintara pumagiripa kampa a'wae pumagiri abintane, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Piya umagina, Isu to maya untiye: Naeba to ka kamana urimukuwa, abiyo. Wasana ka'waina mawata waini kurintiye. Ku'ma a'ya atamagina, ainkima kagisa kimagina waini anti airakenaena puntiye. Piya potama yoga kiye pikena nama kitama kiya kabiwaitate to mari wantiye. ");
INSERT INTO for_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Umintogana nakena aborakena kana aboraogana, kayokaya kina'wa: Waini nae'ena ka'isa maete kanaiyoma, uwaitaogini wamagini kiya kabima miyume kina'miti uma irosantawe. ");
INSERT INTO for_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Irosa'ma yuguni, kana yoga kiye kina igeba kayokaya kina iraku'ma kapa uwa aeguntini, kapa ara aeguntini, piya kapa yaba kasutasa ausa aeguntawe. ");
INSERT INTO for_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Piya puguna yogawama nkababa to kake uwoma ntagara uwaitaogini ampa irosauguni pabiyaena puwaitantawe. ");
INSERT INTO for_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Piya puguna ainti ae'wa ntagara mayama napimagina otantiye: Yagarane agarubakana wakiniba ae awamu wasikibewema, napintiye. ");
INSERT INTO for_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Piyama napima otagana ampa irosaogini agate, kana yoga kiye kina'miba maya mare-u me-u puntawe: Aintiba pi ae kana yuga maesanaga, taeba aepa aegugaite aintana pekana tae'enaena pikiye, untawe. ");
INSERT INTO for_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Piya yuguna pabigo ampa irosaogini, agaruba urite yoga awamori uma aegumagini kaintawe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Pi kamana uma a'ya atate, Isu wasana ibigama maya untiye: Yogawama nkabawampa aeba ampa irosantanaba, aintiba kana waini yuga kiye kinapa aya puwaitakiyema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Piyama ibigaogini igeba maya omintawe: Kamparagaena potantaka pabiyama kamparagaena puwaitama iyegukiye. Aibuntana waini yugawatapa aogi kiye kina ibabuwaitakini igeba a'ya'ma yagaba wainiwapa maema amimagini mikibewe, untawe. ");
INSERT INTO for_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Piya yuguna Isuba maya uma amato puma uwaimintiye: Mono isapi kamana ka waintipa, pipa tigeba kampa aisewa, a. Pipa mayamawe: Nama kikena kina'miba ka ya ago kainta ntawama iba wa'ega ya asima waintiye, iye. Pintanaba Wa'egawamaba ago pega taeba agantompeka ta'mu pune, untiye. ");
INSERT INTO for_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Pika urimukuwa abiyo: We Yuta kina, Koti kabiratakenaenaba tigetisa tipa'ma to aoso kina, mono au'wapa maema aborakibe kina imikiye. ");
INSERT INTO for_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","(Pigoya wasana ka'waina pi wa'ega yara aeguma au aerisa puma aikiye. Pipa pi wa'ega yawamaba pipa wasana to ka'waina abobora tumpa waima aeguma aigiseba'ma aerisa puwakiye, Isu piya untiye.) ");
INSERT INTO for_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Meto kamana piya yogini monotasa tabe kiye kina'mibe Parasi kina'mibe igeba abibebe pumagini: We, pipa taeka iye, untawe. ");
INSERT INTO for_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Piya ute araku'ma aegukena napiyumepa, wasanamiba Isukaba: Poropete yagarawe, yumeka iyekuru pumagini uwa atantawe. ");
INSERT INTO for_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Pigoya, Isuba meto kamana to ka amato puma maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Mantari kabiratakenaenaba mampabisa tabe yagara ka'wainata awame pukuwe, untiye. Piya, tabe yagara ka'waina yagarawampa nkwae iba'ena pomuguna tabe naninta maema kao puntiye. ");
INSERT INTO for_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Piya puntana kayokaya kina'wa uwaitaogini a'ya'ma uwaiminti kina'miti wama kega'e uma ibabikena wantawe. Wama uma uwaimuguni: A'a-o, untawe. ");
INSERT INTO for_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Piya yuguna tabe yagara aeba kayokaya kina'wa to ka'isa mayama uwaitama untiye: Tigeba wama naokinati wama maya uwaimiyo, untiye: Tabe yagara aeba ago naninta maema aki pugasima yegini uwoma apa purumaka ago aegumagini kao pugasawe. Aibumagini a'ya'ma nanintaba ago maema aogi pumagini tiyobi pewe. Pika tigeba kanaigi yagaranepa waya ababomima kana naninta namagi ta'mu potano, iyema uwaimiyoma uwaitaogini wantawe. ");
INSERT INTO for_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pigoya igeba wama uma uwaimuguni, kamana abima aekita potate, ka'waina aeba yogawati wantiye. Aibogana to ka'wainaba situwawata kabikena wantiye. ");
INSERT INTO for_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Piya pusuguni to ka'isa kina'miba kayokaya kina'wapa iraku'ma iyegumagini kaintawe. ");
INSERT INTO for_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Piya puguna tabe yagara aeba ata pumagina irebu kina uwaitaogini igeba uma iyegumagini namankaipa yaku nkigi'ma kaewaegaintawe. ");
INSERT INTO for_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Piya puguna tabe yagara aeba to kake kayokaya kina'wa maya uwaimintiye: Nanintaba ago kao pugasune, piya kega'e uwaimintompe kinapa igeba iyekita pumagini kampa kanapa aerana, kasiyo. ");
INSERT INTO for_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Piya, tigeba ke'i nasi nasi pumagiri wasana ibatakibepa ibabute kanaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Piya yogini kayokaya kina igeba ke'i nasi nasi pumagini uwa kamparaga kinape aogi kinape a'ya'magini ibabuguni irosa'ma namapa ampa pumaema mintantawe. ");
INSERT INTO for_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mintuguna tabe yagara aeba igakena iyomepa, ka yagara aogi kaiba kampa aminta uwa ima asu mintogana agate maya omintiye: ");
INSERT INTO for_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Nao'yagara, kaeba aya pegina kaigapa aogiyenaba kampa amirinta asumintane, yogana, aeba kamana asaba wantiye. ");
INSERT INTO for_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Aibogana, tabe yagara aeba kayokaya kina'wa uwaimima maya untiye: Tigeba agisa ayata kirokaema tununtanabinti apasanaigina tumima, pita'i tumpimagina awamu uparisa puma kube'ena pumagina miyeno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Piya untana to maya untiye: Pi puntisa puma igega'e unta kinapa uwomane. Piya, ibabuma kibi'itanta kinapa tarantowe, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Isu piya uwaimogini, Parasi kina igeba ka au'i wamagini kamana tobi tabi potama arakurikena kamana uma abintawe. ");
INSERT INTO for_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Piya puntini, ibagi kina'waipe Eroti nkaokina ka'isamipe: Kamana uma aborama, uwaimuguni igeba Isuti wama maya untawe: Tisa, taeba kae agoba abune. Kaeba taga ntagara mintane. Piya, ima tumima minta kinakaba kampa karu punta esegiyenawaika kampa kaekuruba puma Koti mpono'ama kipa kanara uramima tayakene. ");
INSERT INTO for_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Piya, ka kabigakuna, uramo: Mono kina'mita, taeba Aroma wa'ega yagara Sisa takisi mone amusupera kampaye, untawe. ");
INSERT INTO for_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Piya yuguna intabaipinti kumpari kamana'wai igate maya untiye: Kumpari kina, tigeba nanaga minaga punatakenaga yewe. ");
INSERT INTO for_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tigeba tabe yagara Sisa mone ame, pi ka nayakigi agano, untiye. Piya yogini mone ka maema ayakuguna ibigama maya untiye: ");
INSERT INTO for_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Amankape awa'enabe mapa kewema, ibigaogini ");
INSERT INTO for_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","igeba: Sisantawe, untawe. Piya yuguna maya uwaimintiye: Pigo yewa, Sisantanaba Sisa amiyo. Piya, Kotintanaba Koti amiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Piya umagina uwaimogini, igeba abima pami potategini atate wantawe. ");
INSERT INTO for_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pigoya igeba wauguni, pabintaga ka'isa Sarusi kina igeba Isuti ampa irosantawe. Pi kina igeba: Purintapisa asikenaenaba kampa waintiye, piya uma miyume kinane. ");
INSERT INTO for_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Pi ige Isu maya uma omintawe: We tisa-o, Moseseba kamana mayama kaentiye: Wasana ka'waina yagarawa kampa aboratanta purekanaba a'nanto kiyaba maetama aganto antotapa yagara aborano, untiye. ");
INSERT INTO for_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pigoya, abakatepi ka aga'na tonaentisa tara umaema mintantawe. Aibuntini marusa iganto waya maemagina yagara kampa aboranta mima pu'waogana, a'nanto kiya aetantiye. ");
INSERT INTO for_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Aeba pabiyama yagara kampa aboranta mima pu'waoganaba, a'nanto to ka'waina kiya waepa pabiyama taetantiye. ");
INSERT INTO for_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Piya pumagini tonaentisa tara umaema aga'naba a'ya'magini pu'waewauguna, kiya wae aeba ainti mima purintiye. ");
INSERT INTO for_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Piya, igeba ka wae'amana a'ya'magini maentaka, ainti asiratakena yagaba ke nkwae mikiyema abigantawe. ");
INSERT INTO for_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Piyama abigauguna Isu maya uwaimintiye: Tigeba mono kamanape Koti nkesegiyenagabe kampa napima kamanapa umagiri ata pewe. ");
INSERT INTO for_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Asikena yagaba wawayapa to kake kampa maekibewe. Igeba enisore miyesa puma asu mikibewe. ");
INSERT INTO for_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pigoya, tigeba asikenaenaga yepa urimukuwe. Koti aeba kamana urimintipa, pipa tigeba aisuma kampa abewa, a. ");
INSERT INTO for_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Maya urimintine: Naeba Abara'amu, Aisaki, Yekobu ige Koti mintuwe, untiye. Piya untika, aeba pu'wanta kina'nane. Aeba iyoganta kina'mi Koti mintiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kamana piya yogini, wa waya a'ya'ma kina igeba mono yomeka abima pami puntawe. ");
INSERT INTO for_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Pigoya, Isu kamana'ama Sarusi kina iraku'ma akunogini, Parasi kina igeba abite aki puntawe. ");
INSERT INTO for_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Aki pumagini kamana awa'ena abinta, iyo'yagara ka otauguna ago'ena pumagina maya untiye: ");
INSERT INTO for_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tisa, mono kamana ai'neba ae'na tabeba piye, untiye. ");
INSERT INTO for_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Piya yogana Isu maya omintiye: Kaeba a'ya'ma kagu kaumakape napiyenagape Wa'ega Kotigapa a'ya'ma amegana waiyeno. ");
INSERT INTO for_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Pi kamanapa mono ai'neba asugasimagina waintiye. ");
INSERT INTO for_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Pigoya to ka abae wainti, isigeba ka awametane. Pipa mayama: Kaekaka kabemisa puma pabi nkawameta kaokinaka kabeno. ");
INSERT INTO for_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pi kamana ai'ne taramisi Mosese nkago kamanape poropete kina ige kamanape agona pese, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pigoya, Parasi kina aki pumagini mintuguna Isuba ibigamagina maya untiye: ");
INSERT INTO for_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Tigeba Karaisitikaba nanawe yewe. Aeba ke ntagarawema, ibigaogini, igeba Tebiti ntagarawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Piya yuguna Isu maya uwaimintiye: Piya, Tebiti aeba Awamusa'ama otaogana ayaga utaratanta yagara Karaisitikaba Wa'eganeneba, omintiye. Aeba maya untine: ");
INSERT INTO for_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tabe yagara aeba nae Wa'egaba maya omintine: Kaeba nayatakanti ampintaga, kama kinakapa kagisabi ibabuma aki peno, untiye. ");
INSERT INTO for_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Pigoya, Tebiti aeba nanaga aga'nukaba: Wa'eganeneba, untiyema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Piya uma ibigaogini igeba kamana a'wae puma omikenaga napigate uwa atantini, pi ntaga aeka karu puntawe. Piya puntini, aintiba to kake kampa kamanapa abigantawe. ");
INSERT INTO for_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pigoya pi ntagaba Isuba ka'isa kinape abagi kina'wape maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Mosese marutapa mono tisa kinake Parasi kinake miyewe. ");
INSERT INTO for_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pika kamana aborama urimigiripa abimagiri wasiyiyo. Piya, igewai miyesa pumaba a-mpiyiyo. Igeba kamana iwamupisa untiniba agowapa kampa wasiyewe. ");
INSERT INTO for_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Igeba kuntaena asaema tibota aesagatitate, igewaipa uwa ika miyewe. ");
INSERT INTO for_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pi a'ya'waemaena pepa i'maete imaena mana pewe. Igeba mono nunamurasa tusantanawai puwaitagini pu u'ma, toma tomantana maema paentaenabi miyewe. ");
INSERT INTO for_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Piya pumagini, tabe naninta nakena yagabe mono namapi mikena yagabe marusa yabaera paitama asu misanaga ibugaye. ");
INSERT INTO for_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wa waya uwa kina'mi ke'ibe kumatibe i'mu purataiyema iyowa agasiya pumagini mintini, igewaipa tisawe uwaimisanaga ige atakae puma miyewe. ");
INSERT INTO for_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pigoya, tigeba pipa tisawe uramiyomaba a-siyo. Tisaripa Koti abintowe. Piya, tigeba uwa a'ya'magiri aganto a'nanto mintawe. ");
INSERT INTO for_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pigoya, mabi kawainaka tabaweba a-siyo. Mantari tibarimpaba ka'anto mintiye. ");
INSERT INTO for_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pigoya kiya kinateneba a-suritaiyo. Kiya yagararipa Karaisiti aeba ka'antowe. ");
INSERT INTO for_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Piya, tigeti kiya ima mikibi'naba tige kayokaya'ena peno. ");
INSERT INTO for_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Piya, ka'waina ae'wa nkaumarasa au maete ima miyekanaba, merunkaba potakiye. Piya to ka'waina au maete tumima miyekanaba ababuma mesuba potakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Piya yogana Isu amato puma maya untiye: We, mono tisa kinake Parasi kinake kumpari kina, tigeba ataenabi mikibewe. Nana pegiri wasanami igeba mantari kabiratakena kumati uma pasikena yegiripa ke akunkigasawe. Tigeripa kampa uma pasintiri ige uma pasikena yegiripa a'a-o uma aka'ya waitawe. ");
INSERT INTO for_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","We, mono tisa kinake Parasi kinake, kumpari kina, tigeba tara taraena puma, ataenabi mikibewe. Tigeba e'ero nunamurasa ago'ena pumagiri ainti abeya wae'mi mpone kutankai a'ya'ma aisaga, pi'na nkantotapa aintiba kamparaga ikantana maekibewe. ");
INSERT INTO for_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","We, mono tisa kinake Parasi kinake, kumpari kina, tigeba ataenabi mikibewe. Tigeba wanipe mabe agasigasima nasimagiri to marisa kina ababuma tibagi kinati me nkatakena wantiri, pigo tige kamparagaena pesa puma ayakigina aeba tigasimagina tabera kamparagaena puma a'abibi tumikiye. ");
INSERT INTO for_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","We, tiyorika kiye kina, tigeba ataenabi mikibewe. Nanaga mayaba yewe: Tabe mono namata aigima uma esegi pepa pipa kamparine. Pigo tabe mono namatasa aogi awa'enawata aigima esegi puma ukenagaba nanaga tagakaba yewe. ");
INSERT INTO for_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","We, tigeba aibo kina tiyorikane. Awa'ena pipa uwaenawe. Awa'ena wainta aota namankama asugasima aeba tonawe. ");
INSERT INTO for_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Pigoya, to kapa mayawe yewe: Aratara aigima uma esegi pepa pipa kumparine. Pi arata aboborisa a'muntanara aigima esegi puma ukenagaba, nanaga tagakaba yewe. ");
INSERT INTO for_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","We, tiyorika kina tigeba, a'muntana pipa uwaenawe. A'muntana wainta aratawama asugasima aeba tonawe. ");
INSERT INTO for_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pika ka'waina aeba aratara aigima uma esegi pekanaba arata ae'wape abobori waintintanabe kaga'ena pukiye. ");
INSERT INTO for_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Pigoya, ka'waina aeba tabe mono namata aigima uma esegi pekanaba, pipa mono nama ae'wape kana mono namapi miyi'nape kaga'ena pukiye. ");
INSERT INTO for_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Piya, ka'waina aeba mantari aigimagina uma esegi pikibipa, pipa Koti marunkape kana marunkama nkababe kaga'ena pukiye. ");
INSERT INTO for_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","We, mono tisa kinake Parasi kinake kumpari kina, tigeba ataenabi mikibewe. Yogarisaenabe to ka'isaena maema nayatara'mu aki puma'ma kapa Kotinta atakena kamana yewe. Piya puntiri ka auka'i au'wantaga'ena monota uma arupu puma, agama kao'ena puma kamana ago wasima aegarakenaenaba pipa kampa pewe. Ka wasintiri to kapa wasiyiyo. ");
INSERT INTO for_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","We, paitama miye tiyorika kiye kina, tigeba maeyaena pewe: Wanitipisa ki'nunkama agama maema maebugasagana, tabe yagawamaba kampa aganta pabigo asaga'yuma paga iyopotaye. ");
INSERT INTO for_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","We, mono tisa kinake Parasi kinake kumpari kina, tigeba, ataenabi mikibewe. Tigeba tu'natipe kankaberipe aririsaba wani nkaema wae'wae puntiri antabaipintisa kampa aeyobagana i'nintanabe aguntaenabe awaitama waintiye. ");
INSERT INTO for_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","We, Parasi kaorika kina kaeba, marupa tu'na kankabegapa antabaipintisa ka'ena waintipa, pipa waninkaema aogi pugaite ainti aririsaba waninkaema aeyobao. ");
INSERT INTO for_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","We mono tisa kinake Parasi kinake, kumpari kina, tigeba ataenabi mikibewe. Wasana aru piyama mintawe. Wasana aru aboboriba awa'ena puma aogi pugasawe. Piya, antabaipintiba pu'wanta kina'mi ayampube karebe kobabe waintiye. ");
INSERT INTO for_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Tigeba pabiyama tipa wasana iyora aogi tiwa maema miyewe. Piya tintabaipinti pipa kumparipe mono'ama aguya aikenaenabe awaitama waintiye. ");
INSERT INTO for_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","We, mono tisa kinake Parasi kinake, kumpari kina tigeba ataenabi mikibewe. Tigeba poropete kina'mi nkiru paga pumagiri aogi pewe. Piya puntiri paisa mono kina'mi nkiru yugaba awa'ena puntiri, ");
INSERT INTO for_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","maya yewe: Tayabamagi mintantata miyompesinta, igepa kampa iyo'maema poropete kinapa iyegumagi ataenaba kampa puwaitaompesine, yewe. ");
INSERT INTO for_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","We, tigeba piya kamana umagiri poropete iyegunta kina ige iga'nugi miyepa agoripa uma aborawe. ");
INSERT INTO for_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Piya, tiyabamagi kaintaba uwa inatasa atata kanantagiri, tigeba pabita amato pegana tabe kuntu piye. ");
INSERT INTO for_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Tigeba kuyarawe. Tigeba ma'ama nkawarorawe. Kaintanama nkantota a'abibinti tumikena yaga aborakiripa aeta pai'ma wama kakakibewe. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pigoya abiyo: Naeba tigeti poropetebe, aogi napiyena puma abinta kinape, mono tisa kinape, uwaitakini uma irosaigiripa, tigeba ka'isaba iyeguma kamparaga puwaitakibewe. Piya puntiri ka'isaba maripora iyeguntiri, ka'isaba mono namapinti eru kasutasa iyeguma a'ya'ma kumati igarubata nasikibewe. ");
INSERT INTO for_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Piya pugini, aogi kina'mi korankai uwaraka'ya airi'ma ataena purite kanama mintanta, pi'na nkantotapa tigeti ampa aborarimikiye. Pai Eboro, aetasa ma'ena aborama purite kanama Perekaya ntagara Sekaraya ae tabe mono namapi arata agora aeguma a'ya puntane. Pi'na nkantotapa tigeti ampa aborarimikiye. ");
INSERT INTO for_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pika taga urimukuwa, abiyo: Pi a'ya'ma kamaena purite kananta, pi kaintanaba ma kanabi mpiye kina tigeti ampa puma a'ya pikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Piya untana Isu to maya untiye: We, Yerusaremi kina, Yerusaremi kina'mitaba, tigeba nanaraka poropete kama puwaitama mono kina tigeti uwaitantapa yaba kasutasa iyeguma kaiyawe. Kokorewama awagi'nu agagatasa isamu puma agagapinti itamagina miyemisa pumagi, naeba tigepa agasiyama ibabumagi nagora aki puwaitakena yuwagini, a'a-o urite kanamagini mintantane. ");
INSERT INTO for_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pika nama kumatipa kasakana kabu isubumagina waikiye. ");
INSERT INTO for_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Piya yekiri abiyo: Naeba titakiri kampa naganta mirite wamagiri, asaba: Wa'egawama nkawamuta kanaika ae ta'mu potano, ukibepa, pi ntagaba tigeti to kake aborakuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pigoya Isu aeba tabe mono namapisa irosa'ma waogini, abagi kina igeba ainti wantini tabe mono nama aogima kimarantakini agama agabantini omuguna, ");
INSERT INTO for_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","maya uwaimintiye. Ma kanabipa waiyegiri agawe. Pigoya, naeba tagaka urimukuwa abiyo. Kama kina'mi irosa'ma nama kumatiba akasagasuba kasigina, ka yabankamaba to ka yabankama nkabobora ware'naigina nama tubo aborama waikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Piya ute Oribesi amuti ima mintogini, abagi kina ibiwai agora wamagini abigama maya untawe: Pi yempentanaba ae ntaga aborakiye. Pipa kaega ampa irosakena yagawo, mampa a'ya pikena yagawo aborakena pekanaba, nana kukantana kapa aborakiyema, abigantawe. ");
INSERT INTO for_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Piyama abigauguna Isu maya uwaimintiye: Ainti ka'waina kumpari urigasima tigu'ama maema a'yugu puritasanaga aogima kiya kabimagiri miyiyo. ");
INSERT INTO for_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Piya wasana uwoma kina irosa'ma nae nage umagini: Naeba Karaisiti nawe umagini, uwoma kina'mi nkigu'ama paibumagini kamparaga puwaitakibewe. ");
INSERT INTO for_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Pigoya, ma'ena pewe kamana abintiripe, esiba kamana abitegiri tiyekuruba a-puma: Kana a'ya piyeba, a-siyo. Pi ma'ena maru pikibepa, asa aka'i agogo yaga aborakiye. ");
INSERT INTO for_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Maga maga kina'miba kamaena pigini, to ka'isa kina'miba to ka marisa kina uma iyeguyigini kamaena purite wagana pikibewe. Kaboba tabera aborakana imimapa tabera purite wagana pikiye. ");
INSERT INTO for_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Pigoya pi ntagaba marusaena uwa tiki nakiyenaba tabera aborarimikiye. ");
INSERT INTO for_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Pigoya, pi ntagaba tibabute wamagini tiki nakiyena purintini tiyeguma kaikibewe. A'ya'ma marisa kina'miba naetaka kama puritamagini kamparaga puritakibewe. ");
INSERT INTO for_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Piyaena aborakiniba uwoma kina'mi monopa kaitegini iyokinaka minaga'ena pumagini igobi puma kamparaga uwaitakibewe. ");
INSERT INTO for_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Piya pigini, uwoma kumpari poropete kina ampa irosa'magini, napi napiyenari maema a'yugu purigaikibewe. ");
INSERT INTO for_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Pigoya mono aguya aikenaenama anosama abae pekana, agu kao'enaba uwoma kina'mitiba kaka wakiye. ");
INSERT INTO for_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pigoya ka'waina aeba monopa esegima aega'magina mintakana kana'wapa a'ya pekanaba, ababikiye. ");
INSERT INTO for_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pigoya Koti kabiratakena aogi awaga kamana'ama maga maga wagana pumagini, a'ya'ma marisa kina'mi ige agowaipa maema aborakana, kanapa a'ya puwakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Piya untana Isu to maya untiye: Poropete Taniyeri kamana kaenti, pipa pasema aisuma abiyo. Piya, ma nkisapi aisuma agakibe kina'miba aogima abiyo. Pi kamana'ama esegi pekanaba kamparagaenaba tabe mono namapi ataigiri tini'ena pikibewe. ");
INSERT INTO for_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Piya pumagiri igate, Yutiya mari mikibe kina'miba tiyegaka amu mari iyiyo. ");
INSERT INTO for_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Piya pigini, wasanami abe'i mintakibetisaba namatipinti a'wae pumagiri ima kotatipa a-mpaentiri uwa waiyo. ");
INSERT INTO for_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Piya, to wasanamiba yogari mintakibetisaba a'wae pumagiri wa'eri a-nkwama kai kabiripa a-mpaentiri uwa waiyo. ");
INSERT INTO for_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","We, pi kanabipa iga'entaga waepe inamuganto mono amikibe waepe kamparagama mikibewe. ");
INSERT INTO for_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Tigeba Wa'ega esotaigina abintakiri, tiyegaka pai'ma wakenaenaba esiba yagabe sabatirape a-nkaborano. ");
INSERT INTO for_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Piya, pi ntagaba tabe kuntuyena aborakiye. Pintanaba ma aborantitasaba kampa aborantine. Aintibe to kake kampa aborakiye. ");
INSERT INTO for_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Piya, Kotiba kanapa kasama arosakenaenagaba umarantine. Kampa piya untemisinta, wasana ka'waina mono maema mikenaenaba pipa kampa aboramisine. Piya, Koti ae'wa nkibabikena kinaka umagina kanapa kasama, arosakiye. ");
INSERT INTO for_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pigoya: Karaisitiba mata'i taeti aboraya, marota'i igeti aboraye, piya kamana'ama wagana pekiripa, a-nkabiyo. ");
INSERT INTO for_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Piya, pi ntagaba kumpari karaisitibe kumpari poropetebe ampa irosa'ma kukantanaba toma toma agasiyaena pumagini wasanami abikenaenawaipa maema a'yugu puwae igaikibewe. Piya puntini Koti ae'wa nkibabikena kina'mi nkabikenaenawai maema a'yugu puwaigaikenaba kasa'enabe awame'enabe tabera aborakibewe. ");
INSERT INTO for_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pigoya naeba maru urimoka, ainti aborakiripa aibopa a-piyo. ");
INSERT INTO for_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pigoya, pika ka'me mpari Karaisiti aboragi agaune yigiripa, a-nkwaiyo. Piya nama pita'i mata'i aboraye yigiripa, pipa a-nkabiyo. Kampaye. ");
INSERT INTO for_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Wasanama Ntagara naeba kakamaba kampa kanakuwe. Apayaena pegina a'ya'ma auka'i e'wasa puwamisa puma, naeba pabi nkawameta aborakuwe. ");
INSERT INTO for_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Eya, wasana purinta kina wainti mpari kegebankama kanama ampa aki pemisa puma, pabi nkawameta aborakiri nagakibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Piya untana Isu to maya untiye: Pigoya, tabe kuntuyena pikibi kanaba a'ya puwakana, papa tunusekana, opa kampa e'wasa pekana, noriba tutu pekana, mantaba kuru pekana esegiyenawapa iyoba'ma kareko pikiye. ");
INSERT INTO for_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Pigoya Wasanama Ntagara nae kukantanaba mantari aborakini a'ya'ma maga maga kina'miba pi agate kube'ena pumagini nagisigi naeba mantarisa ibinankama nkabobori e'wasaena esegiyenanentaga tumpa irosakuwe. ");
INSERT INTO for_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Piya, enisore kina'nepa uwaitakini tabe kiga'e uma ma maretibe metibe, atibe abetibe naokina'nepa kibi'magini ibabuma aki pikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Piya untana Isu to maya untiye: Pigoya, piki yawama kana aboragiripa agama abewe. A'no mpa'ma pari pegiripa agantiripa: Tabe pa tagiya wakena piye, yewe. ");
INSERT INTO for_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pabiyama urimontana aborawae wakiri, agantiripa, naeka: Aeba kabera ampa asintiye, yiyo. ");
INSERT INTO for_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Piya, kamana ka taga urimukuwa abiyo: Ma kanabi miye kinapa kampa purinta uwa mintigina pi a'ya'waemaenaba aborakiye. ");
INSERT INTO for_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pigoya mantabe mabe a'ya wakana, kamana'nepa waiyaba waima kampa kakakiye, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Isu piya untana to maya untiye: Pigoya, pintana aborakena yagaga wasana ka'waina kampagina abibebe puntiye. Piya, enisore kina igeba pabiyama kampa abintawe. Yagarawa naebe pabiyama kampa abintuwe. Nabanempa ae abintowa abintiye. ");
INSERT INTO for_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Piya Nowa mintanti kanabi wasanami a'ya'waemaena puntasa puma, Wasanama Ntagara nae ampa irosakena yaga agarosakiniba pikibewe. ");
INSERT INTO for_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Piya, paipa wani kampa pagintoginiba, nanintabe wanipe uwa nantini, iba'ena puntini, pumagini a'yuguma mintantawe. Mintuguna, Nowaba pabigo wanipisa karebi iyogana, ");
INSERT INTO for_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","tabe wani pa'ma ipirintantisa puma, Wasanama Ntagara nae ampa irosakena yagaba pabiya awame'ena pikibewe. ");
INSERT INTO for_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Pigoya, pi ntagaba tara yagarara yogari mintisiginaba, Kotiba ka'wainapa ababuntana to ka'wainapa a'a-o uma atakiye. ");
INSERT INTO for_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Piya, waya taramisi naninta kao'ena puma mintisiginaba, ka'wainapa ababuntana to ka'wainapa a'a-o uma atakiye. ");
INSERT INTO for_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Pika tigeba aogima kabiyiyo. Wa'egaripa kanakena kanapa kampa abintawe. ");
INSERT INTO for_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pigoya, tigeba agowapa mayama abiyo: Ka kumatasa kina ku kina ma aseka irosakiyema napiyisinta, iyogabama mima nama kuma'waipa kabiyiginaba kuntanaba kampa maeyisine. ");
INSERT INTO for_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pigoya, Wasanama Ntagara naekaba pabiyama kampa napikibe kanabi, kanakuboka aseyo puma miyiyo, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Piya untana amato puma maya untiye: Wa'ega ka'waina kayokaya kina'wampa ige kiyawaika otamagina maya omikiye: Naeba wama umintakanapa, kaeba kiya kabiwaitama asi nasiba naninta ka awameta imima miyo, ukiye. Pigoya, aeba ayama miyekanapa kiyaba mono wantaga awamu wasikenaena wantagane otaiyo. ");
INSERT INTO for_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Piya, aeba yoga otanta pipa aogima puma miyekanaba, wa'ega yagarawapa irosa'magina abekanaba a'mu potakiye. ");
INSERT INTO for_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Naeba taga taga'ya yekiri abiyo: Aeba pi ntagaraba pipa kiya tabe otama a'ya'maenawatapa kabiyenoma otakiye. ");
INSERT INTO for_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pigoya, pi kayokaya yagara aeba wa'eganepa agaropa kampa kanakiyema, antabaipintiba napimagina, ");
INSERT INTO for_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","karana itamagina, kayokaya kina iyegumagina, nanintabe esegi wanipe nama aibo abo'ena puma karana itakanaba, ");
INSERT INTO for_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","togana wa'ega yagarawa a'wae puma kanakena kanapa, pi kampa napinta mintakana, ");
INSERT INTO for_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","agaronkanto irosa'ma agaruba'ma kumpari kina ai'aruyenabi atakana ata maru mpikiye. Pi mparupi igeba iwara upaba puma kube'ena puma mikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Isu kamana ka maya untiye: Pigoya, pi kanabipa Koti kabiratakenaena nayataramu aratagawae igeta meto puma maya ukuwe, untiye. Piya, iba'wae ao'maekena puntini, igeba wama wasana ke'i kabima mimagini, ababikena kane'waipa maete wantawe. ");
INSERT INTO for_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pigoya, nayaka'mu aragawae igeba aibona, piya to nayaka'mu aragawae igeba napi napiyena waintagana sumawe. ");
INSERT INTO for_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Piya, aibo aragawae igeba kane'waipa uwa maete wama kampa napima waninkapa kampa awaitama tiginta wantawe. ");
INSERT INTO for_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pigoya, napi napiyena waintaga aragawae igeba wanipa awaitama ari atamagini kane'waipa maete wantawe. ");
INSERT INTO for_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Piya puguna wasana kampa karu'ena kanaogana, aobi puma mintuguna iwaiga ibogini waintawe. ");
INSERT INTO for_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Waintuguna, aseka nkabubu saogana, kega'e kamana ka mayama aborantiye: We, wasana ago kanaya, karu'ena asimagiri uma ababiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pigoya aratagawae igeba abite iyogama asimagini kane'wai maema tabe puguna tantiye. ");
INSERT INTO for_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Piya puntini, aibo aragawae'mipa napi napiyena waintaga aragawaepa maya uwaimintawe: Taeba kanete tabe pokana tu'makena piya, tigeba wanipa kapa ari'ma na tamiyo, untawe. ");
INSERT INTO for_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Piya yuguni, napi napiyena waintaga igeba maya uwaimintawe: Piya kampa pukune. Wanipa pipa kaga kampa kanarasaratakiye. Tigeba situwati wama ika piyo, untawe. ");
INSERT INTO for_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pigoya, igeba kane'waipika wani ika pikena wagasuguna aobi pume ntagara ampa irosa'ma aratagawae ase'yo puma kane'waintaga mintume ige ibabogini wantawe. Wamagini kumati uma irosa'ma namapinti ima kabe kitama naninta namagini mintantawe. ");
INSERT INTO for_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mintuguni aibo aratagawae igeba kanama kega'e umagini: Naba-o, naba-o, kabe aitatao, untawe. ");
INSERT INTO for_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Piyama kega'e yuguna maya uwaimintiye: Naeba taga urimekiri abiyo: Naeba kampa tigao kinatawa, wagasiyo, untiyema, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Piya, kanapa kampa abintaka, tigu'ama kiyeba aogima kabima miyiyo, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Piya untana, Isu to amato puma maya untiye: Aintiba tabe yagara ka'waina punti, pi nkawameta aborakiye, untiye. Pi tabe yagara ka'waina pagasa mari wakena puntana kiya kina'wa igega'e uma monewa kabitaiyema pako puma imintiye. ");
INSERT INTO for_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pigoya, ka kiye yagara mone asaba nayaka'mu ($5,000) amintiye. To ka'waina tara asa ($2,000) amintiye. To ka'wainapa ka asa ($1,000) amintiye. Piya potate wantiye. ");
INSERT INTO for_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Wagasogana pabigo 5,000 tora maeyome kiye yagaramaba agobima to kake aborakena yuga pogana to 5,000 tora aborantiye. ");
INSERT INTO for_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Piya, to ao'yagara 2,000 tora maeyome, aeba pabiyama yoga pogana to kake 2,000 tora aborantiye. ");
INSERT INTO for_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pigoya, 1,000 tora maenti, aeba tabe yagarawampa moneba maete wamagina uma ka ku'magina kaitaogana waintantiye. ");
INSERT INTO for_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pigoya, tabe yagarawai e'ero kana mintana, a'wae puma kanantiye. Kanama mone iminti kiye kina igega'e uma mone kamana abikena aki puntiye. ");
INSERT INTO for_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Piya pogana 5,000 tora aminti, aeba ampa irosa'ma to kasa 5,000 tora me nkatantana maya untiye: Tabe yagarane, kaeba mone asaba nayaka'mu asa namintampetasa naeba yoga pogana, to kake nayaka'mu asa mampa aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Piya yogana tabe yagarawampa maya omintiye: Kaeba aogi kayokaya yagaragawe. Kaeba aogiyena pene. Kaeba yogarapa aogima kabiyene. Kaeba uwaenarapa aogima kabiyempeka naeba ugatakana, to ka'isaenaba kabikibena, kaeba kanama tabe yagaragampa, naege ampima ka'mu po. ");
INSERT INTO for_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Piya yogana, 2,000 tora aminti kiye yagara aeba ampa irosa'ma maya untiye: Tabe yagarane, kaeba mone asaba tara asa namintampepa, pitasa naeba yoga puma maema aki pogana to kake tara asa mampa aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Piya yogana tabe yagarawampa maya omintiye: Kaeba aogi kayokaya yagaragawe. Kaeba aogiyena pene. Kaeba yogarapa aogima kabiyene. Kaeba uwaenarapa aogima kabiyempeka naeba ugatakana, to ka'isaenaba kabikibena, kaeba kanama tabe yagaragampa naege ampima ka'mu po. ");
INSERT INTO for_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Piya yogana, ainti mone 1,000 tora aminti, aeba ampa irosa'ma maya untiye: Tabe yagara, naeba agogapa mayama abintuwe. Kaeba agasiya yagaragawe. Kaeba to kina'mi yoga pumarapisaba naninta uwa maeyane. Piya, to kina'mi aintana asigimarapisaba uwa maeyane. ");
INSERT INTO for_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pigoya naeba pika naekuru pumagi, ka mono asa namintampepa maete wama mabinti kaitaogana waintika, mampa maete mekamuwa maeyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Piya yogana tabe yagarawampaba maya kamana a'wae pomintiye: Kaeba kayokaya yagara ata yagara kamparaga yagaragawe. Naeba yogaba kampa punta uwa mima to kina'mi pumarapisa maema nakena yuwe. Piya, aintanaba kampa maemagi uwa kupisa maema namigi nakena yuwe. ");
INSERT INTO for_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Naekaba piyama napimagina monenepa mone kiye kina'mi imekini yoga puma to ka'isa maemagini atantaga ampaeyosintawe, untiye. ");
INSERT INTO for_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Piya ute to maya untiye: Tigeba mone apa'ma nayatara'mu mone asa urinti ntagara ae amiyo. ");
INSERT INTO for_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Piya, ka'waina Kotitisa maentintanaba aogima maema miyekanaba, pipa uwomantana to kake aboramikiye. Piya, to ka'waina Kotitisa maentintana kampa aogima maema miyekiniba, apa'urigina pipa uwa mikiye. ");
INSERT INTO for_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Pi kamparaga kayokaya yagaraba araku'ma tununtanabinti apasanaigina tumeno. Pita'i tumpima awamu uparisa puma kube'ena pumagina miyeno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Piya untana Isu to maya untiye: Pigoya, ainti Wasanama Ntagara naeba mantarisa e'wasaena wantaga enisore kina'mi abakapi igege irosa'magi, awa'ena yabaeneta imagi mikuwe. ");
INSERT INTO for_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Piya punta, a'ya'ma maga maga kina igega'e yekini nae naora ampa aki puwaekibewe. Aibigi, kiya ka'waina sipisipibe memebe pako pemisa puma, pabiyama pako pumagi, ");
INSERT INTO for_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","sipisipiba nayatakanti aki puwaitanta, memeba nayake'masi aki puwaitakuwe. ");
INSERT INTO for_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Piya puwaitanta, naeba Wa'egawaimpana nayatakantisa kina maya uwaimukuwe: Nabanempatisa akayona maenta kina, tigeba kanama Koti kabiratakena kasa kumati ampaema miyiyo. Pipa paitaka'ya maba kampa aborantogana utaritantiye. ");
INSERT INTO for_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Piya, tigeba mayaena punatantaka: Naga'ena nabogiripa nanintaba namintane. Wanika nabogiripa namintane. Naeba to marisa namu kanaogiripa aogima nababuma natantane. ");
INSERT INTO for_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nauka miyuwagiripa tigeba nautasaenaba namintane. Yonintana naboga waitamintuwagiripa tigeba kao'ena punatantane. Piya iga'na namapi mintuwagiripa kanama ampa nagantane. Pigoya pika kasa kumati ampaema miyo, ukuwe. ");
INSERT INTO for_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Piya yekini, monota arupu puma asoya punta'nagiba maya kamana a'wae puma unamikibewe: Wa'ega, kaeba aeta kaga'enaba kaboga nanintaba kamintompene. Piya, aeta wanikaba kaboga kamintompene. ");
INSERT INTO for_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Piya, to marisa namupa aeta kanauku namapipa kababugatantompene. Piya, aeta kaukapa mintuku kautasaenaba kamintompene. ");
INSERT INTO for_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Piya, kapa aeta yonintanaba kaboganape iga'na namapipe mintuku uma kagama kao'maentompene, ukibewe. ");
INSERT INTO for_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Piya yigipa, naeba Wa'egawaimpa naba maya uwaimukuwe: Naeba taga urimukuwa, abiyo. Tumima uwaena kanta puma miye naokina kao'ena puwaitantapa, pipa nae punatantasu piye, ukuwe. ");
INSERT INTO for_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Piya utegi, nayake'masisa kina igepa maya uwaimukuwe: Kani'ena puritanta kina, tigeba nabanempaba Satanike aokina'wake tayaba yaku kaewaitanti, pita'i tumima miyiyo. ");
INSERT INTO for_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tigeba maya puntawe: Naeba naga'ena nabogiripa nanintaba kampa namintane. Piya, wanika nabogiripa kampa namintone. ");
INSERT INTO for_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Piya, to marisa namu kanauwagiripa kampa nababuma aogi punatantawe. Nauka mintuwagiripa nautasaenaba kampa namintane. Yonintana nabogiripe iga'na namapi mintuwagiripe kampa ampa nagantane. Pigoya, tigeba tayaba yakupi tumpiyiyo, uwaimukuwe. ");
INSERT INTO for_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Piya uwaimekini, nayake'masisa kina igeba maya ukibewe: Wa'ega, kaeba aeta naninta wanika kaga'enaba kabogana mintukupe, to marisa namu kanaukupe, kauka mintukupe, yonintana kabogana mintukupe, iga'na namapi mintukupe, aeta kagamagi taekitaba pugatantompene, ukibewe. ");
INSERT INTO for_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Piya yigipa maya uwaimukuwe: Naeba taga urimukuwa abiyo. Tumima uwaena kina kanta puma miye naokina kayone puma kao'ena kampa puwaitantapa, pipa nae kampa punatantasu piye, ukuwe. ");
INSERT INTO for_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pigoya, igeba iki naki puyaba kumati tumigini, pi aogima arupu puma miye kina igeba a'ya'ma yaga miyaba kumati ima asu mikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pigoya, Isu aeba pi kamana uma a'ya atate abagi kina'wa maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Tara yaga a'ya pekana Pasoba yagaba aborakiye. Pigoya, pi ntaga nabanempaba Wasanama Ntagara naepa wasanamiti unatakini maripora naegukibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Piya yogini, pabi ntaga tabe mono kiye kinape Isureyo kina'mi kiye kinape, igeba monota paitanta yagara Kayapasi, ae namapi aki puntawe. ");
INSERT INTO for_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Aibumagini pasema Isu araku'ma aegukena kamana uma abintawe. ");
INSERT INTO for_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Piya puntini maya untawe: Ma nkaota yagaba kampa piya pukune. A'yugu a'ya'ma kina'mi ma'ena puratasanagawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Pigoya, Isu aeba Petani kumati wama Saimoni, karu yagarama ntamapinti ima naninta nantiye. ");
INSERT INTO for_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Namagina mintogana, waya ka'waina aeti wamagina tabe ikantana wantaga aogi yaba kankabentobisa aogi agunta masawae a'noti pai'atantiye. ");
INSERT INTO for_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Piya pogini, abagi kina'miba agate uma iyekita pumagini maya untawe: Pi tabe ikantana wantaga'enaba nanaga uwa kasaye. ");
INSERT INTO for_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","We, pitasa mone uwoma maema kusi kina imekana kanarasakenawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Piya yuguna Isuba abite maya uwaimintiye. Tigeba nanaga ma kana waepa abima kunta potawe, a. Pi nkwaepa aeba naukaena punataye. ");
INSERT INTO for_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pigoya, kusi kinapa asi nasi tigege miyigiri aintiba iyo'maekibewe. Piya, naeba pipa tigegeba asi nasiba kampa mikuwe: ");
INSERT INTO for_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Naeba ago purekini kainatakibewe, pika masawaepa nau'ama pai'ma aogi potaye. ");
INSERT INTO for_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","We, naeba taga urimukuwa abiyo: Maga maga aogi mono kamana urite wantiniba, ma nkwaya'ma nau'ama aogi potai, pi nkawaga kamanapa kaga urite waigini abae pikiye, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Pigoya, nagisarisa tara tumpaema abagi kina'wapisa ka yagara, agewapa Yutasi Isikerioti, aeba tabe mono kiye kina'miti wama maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Naeba Isu minaga puritakiripa, tigeba moneba ayaki namikibewema ibigantiye. Piyama ibigaogini, pabigo 30-wa siriba mone aisuma amuguna maentiye. ");
INSERT INTO for_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Maeritegina Isu minaga pikena apasa puma mintantiye. ");
INSERT INTO for_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pigoya, yisiti kampa wainta pareti nakena yaga agarosaogini, abagi kina igeba Isu abigamagini maya untawe: Taeba ibaba Pasoba nanintaba ae ntamapi kao pugatasune, untawe. ");
INSERT INTO for_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Piya yuguna maya uwaimintiye: Tigeba kumati ima ka yagaramati wama maya omiyo: Tisarempaba kaeka maya iye: Kana'ne agarosagi kae namapi ima nabagi kina'mige Pasoba naninta nakenaga yuwe iyema, omiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pigoya, Isu yome kamanapa abagi kina'miba wasiwae u'magini wama Pasoba nanintaba maema kao puntawe. ");
INSERT INTO for_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Piya puguna ase yogana, Isuba nagisarisa tara tumpaema abagi kina'wapa ibabute pi ntamapi ima Pasoba naninta nantawe. ");
INSERT INTO for_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nantini Isuba maya uwaimintiye: Naeba taga urimukuwa abiyo: Tigetisa ka'waina nae minaga pikiye, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Piya yogini, abagi kina'mi intawamaba tabera kamparaga pogini ka ka abigaurite wama: Wa'ega, naeka iyepera kewe, untawe. ");
INSERT INTO for_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Piya yuguna aeba maya uwaimintiye: Ma ntagara tu'napi naege aya kaga atami ntagara, ae naepa minaga pikiye. ");
INSERT INTO for_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Piya, Wasanama Ntagara naeba mono kamanata unatanti ki'i wakuwe. We, Wasanama Ntagara naepa minaga punatakibi'naba ataenabi mikiye. Piya, pi ntagarapa wasanama kampa yakari potantesinta, kanara pesine, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Piya yogana Yutasi, minaga yagaramaba pabigo abigama maya untiye: Tisa, naeka kapa yeno, untiye. Piya yogana Isu: Pabigo yene, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Pigoya igeba naninta namagini mintuguna, Isuba pareti maema a'mu potama ako puma abagi kina'wa maya uma imintiye: Mapa nae nauna, maema naiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Piya utegina, waini kankabe pabiyama maema Koti a'mu potama maya uma imintiye: Tigeba a'ya'waemagiri naiyo. ");
INSERT INTO for_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mapa Kotiti aoso atokaekena korantene. A'ya'ma kina'miti aguntaenari a'sua penema ataritauwe. ");
INSERT INTO for_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pigoya, urimekiri abiyo: Mabipa waini wanipa ibanto ainkagogo namagi a'ya puwe. Pigoya to kake kampa nanta uwa mimagi ainti nabanempa kabiratakibi kumati tigege kasa waini nakune, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Pigoya, ini urite kumatisa wama tumima maro nkauka'i Oribesi amuti intawe. ");
INSERT INTO for_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Pigoya ke'i wantini Isu maya uwaimintiye: Mono isa'ama naeka mayama unti, pi'na esegi pikiye: Sipisipira kabima minti ntagara aeguyiginiba, kana sipisipi iyegaka aibarara puwakibewe, iye. Piya yemisa puma tigeba iba ma nkaseka a'ya'waema natate tiyegaka'ya puwakibewe. ");
INSERT INTO for_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Piya pigi purintapisa asinataka, Karariya mari wama paitaritakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piya yogana Pita maya omintiye: Ka'isa kina igeba a'ya'waemagi kaekaba abima katate ata pikibewa, pigoya naeba pipa kapa abimagi kampa katategi ataenaba kampa pukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Piya yogana Isu maya omintiye: Kampaye. Naeba taga ugamukuwa abo: Ma ibasa aseka kokorewama kampa aga untakana, kakaga yaga uwameka unatakibene, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piya yogana Pita maya untiye: Kaeka kaeguntini naepa pabiyama naegukena pigipa, uwamegaba kampa ugatakuwe, untiye. Piya yogini abagi kina'wampiba a'ya'ma pabiya uwaentawe. ");
INSERT INTO for_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pigoya, wama yogaba ka agewapa Kesemeni, pita'i uma irosa'magina Isuba abagi kina'wa maya uwaimintiye: Tigeba mata mintiginto, naeba marota'i wamagi nunamu ukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Piya ute, Pitake Sebeti ntagara tarage ibabute wantiye. Wantana pabigo napiyenawapa kunta puma kampa ayampu puma tabaraba puntiye. ");
INSERT INTO for_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Piya puntana maya uwaimima untiye: Nantawamaba tabera kunta puma puremantana nabiya, tigeba mata tiyogaba puma naege miyiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Piya uwaimite, uwaenantora wama mabi uma parokaema maya uma nunamu untiye: Nabanempa, abegana kanarasakana ma nauki nakiyenaba naparo. We, nae napiyenanepa a-nkaegaranta, kaeka ntapiyena mana aegarao, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Piyama nunama ugaite kakaga abagi kina'miti a'wae puma kanama iwaita mintuguna igate, Pitapa maya omintiye: Tigeba naege uwaenantoba tiyogamaba kanara kampa misiwa, a. ");
INSERT INTO for_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","We, timiyo'ena abekiri amu puma ware'nasanaga tiyogaba pumagiri nunamu yiyo. Tigu'amaba aseyo pegina ariti'amaba kunta piye, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Piya ute to kake wama kamana maya uma nunamu untiye: Nabanempa, nauki nakiyenama naparikena abegana kampa aogi pekanapa, uwa abiwaeyekana kae kamana'ama esegi peno, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Piya ute a'wae puma abagi kina'pa iwaita mintuguna ampa ibatantiye. Piya pogana iyowama kunta pogana igate ");
INSERT INTO for_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","itate to wama nunamu yogana kakaga puntiye. Kamana maru yome, pabi kamana uma untiye. ");
INSERT INTO for_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nunama a'ya atate a'wae puma abagi kina'miti kanama maya uwaimintiye: Tiwairabampa waikena untiripa, ainti piya piyo. Mapa Wasanama Ntagara nae agunta kina'miti unatakena kana'ne agarosaye. ");
INSERT INTO for_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pika asiyigi wano. Minaga punatakibi ntagara pabigo irosaye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Piya uwaimima mintogini, nagisarisa tara tumpaema abagi kina igetisa iyo'yagara Yutasi aeba uwoma kama kinapa paita itaogini pabigo ampa irosantawe. Tabe mono kiye kinape Isureyo kiye kinape uwaitauguni, irebube ma'ena kasupe maete ampa irosantawe. ");
INSERT INTO for_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pigoya, kana minaga yagaramaba marupa maya kamana uwaimintiye: Amo nakiri agantiripa, pimpayemagiri arakuriyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Piya uwaimite ampa irosa'ma Isuti wama: We, Tisane, untana pabigo amo nantiye. ");
INSERT INTO for_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Piya pogana Isuba maya omintiye: Nao'yagara, yoga pikena ute kanampepa karu'ena ibanto po, untiye. Piya yogini igeba pabigo kanama araku'ma ayatara kirokaentawe. ");
INSERT INTO for_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Piya puguna Isuge mintume kina igetisa ka'waina kasonkapa abamu kantibisa pabigo a'yu pumagina tabe kiye yagarama kayokaya yagara aegukena age arisa kaintiye. ");
INSERT INTO for_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Piya pogana Isu maya omintiye: Kasokapa maemo kabamu kantibinti paka puro. Ka'waina aeba ma'ena puntanaba antotapa ma'enamana a'ya'waema kinapa iyegukiye. ");
INSERT INTO for_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Pigoya, kaeba naekaba nanawe yene. Nabanempapa kanara kampa esotakana pabigo uwoma enisore kina uwaitakini tumima nao'maekibewema, kampa napiyewo. ");
INSERT INTO for_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pigoya tumima nao'maeyigina monota naeka meto kamana unta, pi'na nkau'wapa kampa aborasanaga, uwa pintanaba aboranamikiye, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Piya utegina uwoma kina arakurikena kanaume, igepa maya uwaimintiye: Tigeba naeka abeganaba kama yagara kanta pegiri irebu ma'ena kasutintaga kanama ampa nababewo. We, naeba asi nasi abora, tabe mono namapi mono urimima miyone. We, narakurikena untiripa pita narakurisanawe. ");
INSERT INTO for_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Piya, pipa uwaba kampaye. Pipa poropete kina'mi mono isapisa kamana'ama esegi puwaeyenema aborawaentiye, Isu untiye. Piya yogini abagi kina'miba Isu atate a'ya'magini iyegaka wawaegaintawe. ");
INSERT INTO for_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pigoya, irebu kina igeba Isu araku'urite monota paitanta kiye yagara Kayapasi aeti ababute wantawe. Pi ae namapi mono tisa kinape kabiyume kinape aki pumagini mintantawe. ");
INSERT INTO for_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pigoya Isu ababute wauguna, Pitaba igama maro ita maro ita putagina ainti wantiye. Wamagina uma irosa'magina tabe kiye yagarama kagisa kagopi uma pa'ima kayokaya kina'mi nkibakapi uma: Isupa ayabaya otakibeka agakuwe, ute uma mara'mintantiye. ");
INSERT INTO for_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pigoya tabe kiye kinape a'ya'ma monotasa kanisore kinape igeba Isu kumpari kamana maema aborama otamagini, aegukena kamana umagini abintawe. ");
INSERT INTO for_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Aibuntini kumpari kamanapa uwoma uma aboramagini abumepa aeguyema kamanapa kapa kampa aboraogini aguyosa'ma mintantawe. Piya puguni tara yagararamisi aborama, ");
INSERT INTO for_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Isuka maya untase: Ma ntagara aeba Koti tabe mono nama akasaba'ma kakaga yaga a'ya peka to kake kima a'ya pukuwe yogara abintomene, untase. ");
INSERT INTO for_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Piya yusuguna paitanta kiye yagara aeba asimagina Isu maya omintiye: Kae kamana yepa nanaraka ugatagana pipa ka auka'isaba ukena napiyepera kampaye, untawe. ");
INSERT INTO for_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Piya yogana, Isuba kamana kampa unta asaba'magina mintantiye. Piyama mintogana monota paitanta yagara aeba to kake abigama untiye: Koti miyaba yagara, ae aobi kabigakanapa umagina esegi po. Kaeba Karaisiti, Koti Ntagaragabera kampayema, abigantiye. ");
INSERT INTO for_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Abigaogana Isuba maya untiye: Pabigo yene. Pigoya, ka urimukuwa abiyo: Aintiba Wasanama Ntagara naeba esegiyenama nkagowama ae ayatakanti mimagi mantarisa ibinankama nkabobori tumpa irosakiri nagakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Piya yogana monota paitanta kiye yagara aeba pi kamana abima amo'ena puma kaiwa atutu puntana aokina maya uwaimintiye: Aeba Koti akayasotaya, pika nanaga to kake ukune. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Pi kamanapa tigeba abimagiri, ayama napiyewe, untiye. Piya yogini igeba: Aeba ataena piya, aeguma kaiyo, untawe. ");
INSERT INTO for_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Piya utegini, igeba Isu nkaowapi kaisa potama aeguyuguni, ka'isa kina'miba iya kasu atamara aeguntini, ");
INSERT INTO for_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","karana puma maya untawe: Kaeba Karaisiti yagara mintanapa, kaeguyemi ntagarama nkagewapa yo, untawe. ");
INSERT INTO for_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piya puma mintuguna, Pita aeba abe'isa kagisa kagopinti mintantiye. Mintogana, kayokaya araga ka'waina aeti wama maya untiye: Kaeba Isu, Karariya yagara, aege miyempene, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piya yogana, aeba wasana mintume kina ige iyobi uwame umagina: Nae kampa abinto kamana kaeba yene, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Piya ute kabebi tumikena pogana, kayokaya araga to ka'waina agate aeka wasana maya uwaimintiye: Ma ntagara Isu Nasareti kumatasa yagara aege miyine, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piya uwaimogana Pitaba to kake uwame uma waya untiye: Naeba kana yagara aepa kampa agantuwe. Pipa Koti nkaobi taga suwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Piya otate mintogini, wasanamiba Pitati wama maya untawe: Taeba kamanakapa ago abibebe pune. Kaeba taga ige aruyenabisawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piya yuguna, to kake Koti nkaobi uma esegima a'yugu kamana uma: Naeba kana yagaraba kampa agantuwe, uwaimintiye. Piya yogana pabigo kokore aga untiye. ");
INSERT INTO for_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Piya pogana, Isu kamana maya unti: Kokorewama kampa aga untakana kaeba kakagara uwame unatakibene unti, pi kamana napimagina abe'i wama tabera antara puma kube'ena puntiye. ");
INSERT INTO for_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Marogini tabe mono kiye kinape to ka'isa Isureyo kabiyume kinape a'ya'ma aki puma Isu aeguma kaikena kamana uma esegi puntawe. ");
INSERT INTO for_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Piya yuguni Isu ayatarara kirokaetama ababute tabe yagara Pairatiti metantawe. ");
INSERT INTO for_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pigoya purikiyema uma esegi puguna, Yutasi minaga yagara aeba agama abite: Nanaga piyaba puwe, ute, antawama kampa aogi pogana, kana 30-wa mone siriba amintapa maete kiya kina a'wae puma imintana uwaimima maya untiye: ");
INSERT INTO for_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Naeba kumpari sumagi, kaintanawa kampa wainta yagara minaga pogana ataena piye. Piya yogini igeba: Taetiba nanaga kanama yene. Pipa kae'enawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Piya ute moneba a'a-o yuguna, pi tabe mono namapinti uma maebugaite kaiwa amirite wama uma kobantiye. ");
INSERT INTO for_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Piya pogini, tabe mono kiye kina'miba kana moneba kita puntini maya untawe: Moneba wasana ikantanaga tabe mono namapisa monebisa atakanaba kampa aogi pikiye, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pigoya, kana monerasaba ayabusune, umagini mare-u me-u pumagini magabu pome ntagara ae ma, namu kina'mi ige iru yuga, pita'i aboranema ika puntawe. ");
INSERT INTO for_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pigoya, kana mawama nkageba: Kora mpawe, untawe. Piya kana agiba uwa waintiye. ");
INSERT INTO for_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Pigoya, paipa mono kamana Poropete Yeremaya nkawamupi aboranti, pi kamana'ama nkau'wapa aboranti, maya untiye: Isureyo kina igeba ikantanawa 30-wa mone siribawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Piya, kana monerasa magabu pome ntagara ae ma ika puntawe. Wa'egawama unamintisa puntawe, Yeremaya piyama kaentiye, untiye. ");
INSERT INTO for_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pigoya, igeba Isu tabe yagara Pairatiti ababute wauguna abigama maya untiye: Yuta kina'mi Wa'ega Yagaraba kaewo, untawe. Piya yogana Isuba: Pabigo yene, untiye. ");
INSERT INTO for_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pigoya, tabe mono kiye kina'mibe monota kabiyume kina'mibe kamana otaugunaba, antotapa kampa a'wae puma uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Piya pogana Pairatiba abigamagina maya untiye: Kamana ugataganapa, nanaga ka'iba kamanapa kapa kampa yene, untiye. ");
INSERT INTO for_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Piya yogana Isuba kamanapa kapa kampa a'wae pumagina yogana, kiya yagaramaba uwoma agi napintiye. ");
INSERT INTO for_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pigoya a'ya'ma kabu, Pasoba naninta nakena yagaba, pi mparisa kiya yagarama aeba Yuta kina'mi nkiga'na kina ka'wainaka age yugunaba au'ima iyoba imima mi pomekana piye. ");
INSERT INTO for_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pigoya, pi ntagaba ka kamparaga yagara iga'na namapi mintantiye. Agewapa Parabasiwe. ");
INSERT INTO for_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pigoya, wasana aki puma miwaentuguna Pairatiba mayama ibigantiye: Ke uwa ataoma yewe. Parabasipera Isu aeba Karaisiti yagarawe ye, ae uwa atasuwe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Piya Yuta kina igeba uwa Isupa igobi potama aeti metaume pi abintana piya untiye. ");
INSERT INTO for_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pigoya, Pairatiba kamana uma a'ya pikena yabaera mintogana, waya'wampa aeti maya kamana ataogana wantiye: We, naeba iba asekapa amonta agama aeka tabera nantara puwa, pi aogi asoya yagara uwa atao, untiye. ");
INSERT INTO for_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pigoya tabe mono kiye kinape kabiyume kinape igeba a'ya'ma kina'mi imo atikeba'magini maya untawe: Omigina Parabasi uwa atantana, Isupa aeguyenoma, omiyo, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Piya yuguna kiya yagaramaba to kake ibigama maya untiye: Aepera, ae uwa ataoma yewe, untiye. Piya yogini igeba: Parabasiwe, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Piya yuguna maya uwaimintiye: We, Karaisiti yagarawe ye ntagara, aepa aya pukuwema, ibigantiye. Piyama ibigaogini, a'ya'waemagini ka kamana umagini: Maripora pureno, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Piya yuguna Pairatiba to kake umagina: Nana kaintanarakawe, untiye. Piya yogini to kake tabe kamana uma: Maripora pureno, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Piya yuguna Pairatiba napiyomepa kamana'wampaba kampa aogi puntiye. Piya pogini, pabigo tabe ma'ena pikena puguna, yogini wani amuguna iyora ayapa wani nkaentana maya untiye: Ma ntagarama kaintanaba naetiba kampa tamakaeyano. Pipa tige a'wae puma timuwe, untiye: ");
INSERT INTO for_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Piya yogini igeba iwamu ka'i ka'i: Kanarane, untawe: Pi kaintanaba taebe taga'nugitibe taeti waikiye, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Piya yuguna, Pairatiba Parabasi uwa ataogana igeti waogana, Isupa eru kasutasa aegugasimagina, maripora aeguyiyema irebu kina ababuwaimintiye. ");
INSERT INTO for_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pigoya, pi tabe kiye yagarama irebu kina'wa ka'isamiba igeba Isu ababute namapintisa tumima, irebu kina'mi ntamapinti ababute ima, yuguni a'ya'ma irebu kinapa ampa aki puntawe. ");
INSERT INTO for_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Aki puwaeyuguni Isunta kaiwapa atagasima tabe yagaramanta tete kai potantawe. ");
INSERT INTO for_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Pigoya, ake wainta taminoku ka pugasimagini a'notapa taminonkitantawe. Piya potantini, wantapa ka amuguna ayatakanti u'magina tabe kina kanta puma mintantiye. Aibogini igeba wama agora uma irakabima akayasotama maya untawe: We, Yuta Wa'ega Yagara, kaeba aya pene, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Piya ute, igeba kaisa potama, wantawa apa'ma pabigo a'no nkaiwa'ma aeguntawe. ");
INSERT INTO for_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Piyama aegumugaitegini, pi tete kaiba atagasimagini to kake ae'wa kai maema amitamagini maripora aegukena ababute wantawe. ");
INSERT INTO for_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Pigoya, ababute wama ke'i ka yagara uma abatantawe. Agewapa Saimoni aeba Sairini kumatasa, ae tutusotauguna Isunta maripoba maema aesaga'u ataogini wantawe. ");
INSERT INTO for_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wamagini, maba ka agewapa Korikota, pipa kamanatepisa a'no nkayampu amuta, uma irosantawe. ");
INSERT INTO for_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Uma irosa'ma waini wanipi asa tusa wanipa paigu puma amikena yuguna, nabigategina a'a-o untiye. ");
INSERT INTO for_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Piya pogini pabigo maripora itagintawe. Piya puguna maripora mintogini, kaiwata tete'ena pumagini pako puntawe. ");
INSERT INTO for_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Piya puritegini mara'mimagini kiya kabitantawe. ");
INSERT INTO for_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pigoya, a'notapa agowapa mayama kaimaranta waintantiye: Mapa Isu, Yuta kina'mi Nkwa'ega kaema atantawe. ");
INSERT INTO for_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Pigoya, ma'ena kuntana yagara tara kaga maripora iyeguma to ayatari to ayatari pumagini isitantawe. ");
INSERT INTO for_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Pigoya pita'i wa waya wate kanate pume pi kina'miba Isu akaya kamana omima maya untawe: ");
INSERT INTO for_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","We, tabe mono nama akasaba'ma kakaga yaga kima a'ya pukuwe yempe ntagaragawa, kaeka kaupa ao'maeyowe. Kaeba Koti Ntagara mintanapa, mariporasa iyoba'ma tumowe, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pigoya, tabe mono kiye kinape kabiyume kinape igeba pabiyama akayasotama maya untawe: ");
INSERT INTO for_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Wasana ka'isa kina iyo'maentikana, ae'wa nkau'amampa ao'maekenagaba igiga pumagina kunta piye. Aeba Isureyo kina tae Wa'ega mintanaba, mariporasa iyoba'ma tumeka aeti uma atokaeyano. ");
INSERT INTO for_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Aeba: Naeba Koti Ntagara nawe, ute, amatiti'enawapa Kotiti atantegina waintika, pika Kotiba aeka abekanaba iyoba'atano, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Pigoya ma'ena kuntana yagara tara aeke kaga iyegunta, isigeba pabiyama akayasotama umaginisi kamparaga potantase. ");
INSERT INTO for_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Piya potama mintuguna, kagi abebe pogana ase uma maba kanarasama waintogana atamaisa puntiye. ");
INSERT INTO for_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Piya atamaisaogana Isuba pabigo kega'e uma maya untiye: Iro-i, Iro-i, arama sabatani, untiye. Pipa maya untiye: We Kotinempa, Kotinempa, nanaga natane, untiye. ");
INSERT INTO for_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Piya yogini, mintume kina igetisa ka'isa kina'mi abite maya untawe: Mae ntagara aeba Iraiyaka kega'e uma agisiye. ");
INSERT INTO for_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Piya yuguna, ka yagara aeba karu'ena wamagina kai atuta asa wanipi aemagina asara kitamagina Isu amikena pogini ka'isa kina'miba maya untawe: ");
INSERT INTO for_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kaeba uwa ataganao. Iraiyaba taga kanama iyoba'atakana tumeka agakune, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Piya yuguna, Isuba to kake tabera kega'e yogana aumaba iwaegaintiye. ");
INSERT INTO for_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Piya puroganaba, tabe mono namapi Koti nkauka'i akumparanta kaiba atisa aturite tumima abeti tumpa tasawaogana tara awatentana puntiye. Piya puntana imimapa tabera pogana tabe yabapa aibako pumagina kuya mpaentiye. ");
INSERT INTO for_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Pigoya, pita'i wasana iru wairite wanti, pipa a'waiyogini mono kina, pai purinta kina, igetisa ka'isa kinapa iyogama asintawe. ");
INSERT INTO for_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Piya, Isu ae'wa paitama asiyogini igeba irubintisa imagini aota mono kuma, Yerusaremi, ima uwoma kina'mi aborawaimintawe. ");
INSERT INTO for_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pigoya, irebu kina'mi kiye yagarabe aokinape Isuta kiya kabima mintume kinape, igeba pi imima pomepe to ka'isaenabe agamagini abite, iyekuru puma maya untawe: Ma ntagara aeba taga Koti Ntagarawe, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Pigoya, Isu aegunta pita'iba wayapa uwoma pagasari mimagini pi puntanaba agama abintawe. Igeba Isu Karariya marisa aega'ma kanama kayokaya'ena potanta'nagi, ");
INSERT INTO for_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","igeba Mariya Matara kumatasa wa, piya to auka Mariyawa, Yemisike Yoseke isinowa, pigoya to ka'waepa Sebeti ntagara tara isige isinowa, to ka'isa waena sumagini, igeba kaga mimagini agantawe. ");
INSERT INTO for_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Pigoya asenamaisaogana, Arimatiya kumatisa a'yo ampiyome tabe kutantaga yagara, agewapa Yosepe, Isu mpono abima abagi puma mintantiye. Pi ae kanantiye. ");
INSERT INTO for_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kanama Pairatiti wama, Isu yabaewaka omogana abite yogini irebu kina igeba amintawe. ");
INSERT INTO for_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Piya puguna Yosepeba wasana wasaba maema wae kairasa asagakokima maete wantiye. ");
INSERT INTO for_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Maete wama, yaba nkage, aewa nkaruwema kana kaba ku'maranta, pipi Isupa metama tabe yabantama ka a'warigasogana awaba aigunkaogana wantiye. ");
INSERT INTO for_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pigoya kana wasana aru awarapa Mariya Matara kumatasawa, to Mariya ao'waena suma isigeba mimaginisi agantase. ");
INSERT INTO for_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Marogana sabati aboraogini, tabe mono kiye kinape Parasi kinape igeba aki purite Pairatiti wamagini maya untawe: ");
INSERT INTO for_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Tabe yagarare, taeba kamana ka napiyompeka ugamukune. Aegutompe kumpari yagara aeba aogama mintana maya untiye: Pu'magi papa kakaga peka naogamagi asikuwe, untika asisanaga kabikibewe. ");
INSERT INTO for_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Piya abagi kina'wampi wamagini kuntana isu'urintini ago asiwayema, wasana kampari uwaigaisanaga yegini irebu kina igeba arura esegima kiya kabimagini mintigina, kakaga yaga a'ya peno. Paipa kumpari sumagina: Naeba Koti ntagara nawe untikana, aintisa kumpari kamana'ama abobori anosasanaga, uwoma tagi napima ugamune, untawe. ");
INSERT INTO for_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Piya yuguna Pairatiba maya uwaimintiye: Kanaraka irebu kina timekiri ibabute wama wasana aruba akumpa kiya kabiwaitaigini pasemagini mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Piya yogini igebe irebu kina'mige wama kana aruba akunkatamagini yabankama nkaboboriba ara'ena potama irebu kinapa itauguni kabima mintantawe. ");
INSERT INTO for_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pigoya, sabatiba a'ya puwaogini waintuguna marusa yaga aborantiye. Piya pogana marikena poginisi, Mariya Matara kumatasawa, to auka Mariyawa suma, isigeba aru agakena wantase. ");
INSERT INTO for_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wausuguna tabe imima pabigo pogana, Wa'egawamatisa enisore ka'waina mantarisa tumima yabapa aebasanakasogana a'waiwaogana abobora mintantiye. ");
INSERT INTO for_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Piya, apayaena kanta e'wasa pemisa aowarisaba puwaogana kaiwatisaba wae'wae puma ibina kanta puwantiye. ");
INSERT INTO for_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Pigoya, arura kabima mintume kina igeba agate iyekuru pumagini tabaraba puma purikena kanta puma mintantawe. ");
INSERT INTO for_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pigoya, tara wae tara uma irosausuguna enisorewama maya uwaisimintiye: Tisigeba a-tisiyekuruba piso. Naeba abintuwa, tisigeba Isu maripora aegunta agakena kanase. ");
INSERT INTO for_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Pigoya aeba mata'iba kampaye. Aeba maru urimintisa pumagina ago asiwaye. Tisigeba kanama marunkapa mampaye. Pipa agate, ");
INSERT INTO for_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","karu'ena wama abagi kina'wa maya uwaimiso: Isu aeba purintapisa ago asiwaye. Pigoya, Karariya mari wama paitaritakiya, tigeba pita'i wama agakibewema uwaimiso. Pigoya, ago urisimuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Piya uwaisimoginisi, isigeba karu'ena aruba irikabitate isiyekuru puma tabera isi'mu purite abagi kina uwaimikena karu'ena wantase. ");
INSERT INTO for_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Piya pusuguna ke'i Isuba pabuma: Aya pese, untiye. Piya yoginisi, isigeba agora uma parokaema agisara araku'ma ae age maema asaga'yuntase. ");
INSERT INTO for_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Piya pusuguna Isu maya uwaisimintiye: Tisigeba a-tisiyekuruba piso. Wama naokina uma uwaimisigini Karariya mari ima pita'i nagaiyo, piya uwaisimintiye. ");
INSERT INTO for_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Pigoya waya tara isigeba wausuguni, wasana aru kiye kina igetisa ka'isa kinapa karu'ena kumati ima, pi aborantintanama nkawaga kamana tabe mono kiye kina uwaimiwaentawe. ");
INSERT INTO for_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pigoya, kiya kina igeba monota kabiyume kina igega'e uma igege kamana uma abiritegini, igeba irebu kina mone uwoma imimagini maya uwaimintawe: ");
INSERT INTO for_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tigeba maya yiyo: Aseka tauwaitamintokini, abagi kina'wampi kanama Isu nkaupa kuntana iso'urewe, yiyo. ");
INSERT INTO for_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Piya kamana kiya yagaramaba abite ka'ena puritasanagaba a-tiyekuruba piyo. Taeba kanara uma kayone potakune, untawe. ");
INSERT INTO for_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Piya uma uwaimuguni, irebu kina igeba pi mpone maeritegini kamana uwaiminta, pi wasintawe. Pigoya pi kumpari kamana'amaba Yuta kina'mitiba anosama tabe wairite kanantiye. ");
INSERT INTO for_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pigoya, abagi kina nagisarisa ka tumpaema, igepa Karariya mari ka amuti Isu igega'e yogini intawe. ");
INSERT INTO for_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Imagini, ae'wa agate aeti uma parokaema agisuntawe. Piya puguni, ka'isa kina'miba igu'ama tara tara puntawe. ");
INSERT INTO for_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Piya puguna, Isuba igora wamagina maya uwaimintiye: Kotiba mantarisa mabisa esegiyenaba a'ya'ma nae namiwaentine. ");
INSERT INTO for_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pika tigeba maga maga wama toma toma nae nage awaga kamana uwaimigini naegaraigiri, Nabanempawa, Yagarawa nawa, Aota Awamusana suma, tae tageraka mono wani pai'itaiyo. ");
INSERT INTO for_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Aibumagiri kamana uriminto kamana uwaimigini wasiwaeyiyo. We, tigeba abiyo: Naeba a'ya'ma yagaba asi nasima tigege miyekana pi kanapa a'ya pikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Koti ntagara Isu Karasatikaba aogi kamana mayamawe: ");
INSERT INTO for_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pigoya, Koti kamana unti ntagara Aisaya esapi mayama kaentiye: Abo. Kamana'ne maenta yagara agarubakana paitama kaori wama, kekapa aogi pikiyema, Koti yeginaba, ");
INSERT INTO for_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","awaga kamana ukena yagara ka'me mpari mima kega'e uma mayama aboraye: Tabe Yagarama ki i'ma aogi piyoma, Aisaya piyama kaentiye. ");
INSERT INTO for_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Piyama kaeyogana, Yoni wani pai'itanti ntagara wama ka'me mpari umima maya uwaimintiye: Aguntaenaripa kaitegiripa a'wae puma wani pasigina, Kotiba aguntaenaripa maerigaikiye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Piya uwaimogini a'ya'ma Yutiya marisa kinape a'ya'ma Yerusaremi kumatasa kinape aeti wawabumagini, aguntaena pume kamana'waipa uma aborauguna, Yontani wanipi pai'itantiye. ");
INSERT INTO for_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Pigoya, Yoninta kaiwapa kamoro yaga ayatasa pomima, au'arirasa abamu kantiba kitama mima, iroke tuke nantiye. ");
INSERT INTO for_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Pigoya, Yoniba maya kamana untiye: Naka'i kanakibi ntagara agewapa asu nagasima waintika, naeba mayamanaba narakabima agisa anapa kampa akubo agaikuwe. ");
INSERT INTO for_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Piya, naeba wanitasa paititaogana, togana aeba Aota Awamusatasa paititakiye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pigoya, pi kanabipa Karariya mari Nasareti kumatasa Isu kanaogana, Yoni Yontani wanipa pai'atantiye. ");
INSERT INTO for_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Pai'ataogana wanipisa ima mayo agaopa, manta kabi a'waiyogana, Awamusa'ama pupunta kanta purite Isuti tumpitogana, ");
INSERT INTO for_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","mantabisa maya kamana tumintiye: Kaeba nabugami ntagaranekawe. Tabera na'mu pugatauwe, untiye. ");
INSERT INTO for_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Aiyogana, pabi ntaga Awamusa'ama Isupa ka'me mpari agarubaogana wantiye. ");
INSERT INTO for_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Wamagina 40-wa ntaga ka'me mpari mintogana, Satani amiyo potaogana, Isu kampa abintiye. Pigoya Isuba umugabage miyogana, enisore kina'mi aogima kabitantawe. ");
INSERT INTO for_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Pigoya, Yonipa araku'ma iga'na namapinti atauguna, Isuba Karariya-i wama Koti nkaogi kamana uma, ");
INSERT INTO for_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","maya untiye: Pigo agoya, Koti kabiratakenaenaba agarosaye, Isu piya ute: Aguntaenaripa kaite tigu a'wae puma aogi kamana abibebe puma aegaraiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Pigoya, Isu aeba Karariya kotu awamori waomepa Saimonige a'nantowampa Enturuge, isigeba yogawaisipa inoyanta aebusume ntagararaginisi, kuko aibarekima wanipinti motausuguna uma isigate, ");
INSERT INTO for_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Isu maya uwaisimintiye: Tisigeba ampa naegaraiso. Inoyanta aeyamesa puma wasana iba pikenaena tisiyakikuwe, uwaisimintiye. ");
INSERT INTO for_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Piya uwaisimoginisi, pabigo isigeba kuko'waisipa atate aegarantase. ");
INSERT INTO for_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Aibusuguna, Isuba to nasi nasi puma waomepa, Sepeti ntagara Yemisige a'nantowampa Yonige wanipisa karebi mima, kuko aogi puma mintusuguna uma isigantiye. ");
INSERT INTO for_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Isigategina pabigo isigega'e yoginisi, isigeba isibawaisimpa Sepetige yogawa pome kina'wake wanipisa karebi itate Isu aegarantase. ");
INSERT INTO for_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Pigoya igeba Kapaniyamu kumati wama, sabati yaga Yuta kina'mi mpono namapinti wama, Isu kamana uwa uwaimogini, ");
INSERT INTO for_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","kana kamana yomeka abite pami puntawe. Piya, Isuba mono tisa kina'mi kamana nane. Kiya kina'mi yumesa kamana uwaimogini, abite pami puntawe. ");
INSERT INTO for_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pigoya, pi mono namankaipinti ka yagara ke kina antabaipinti minta yagara ampimagina, mayama tabera kega'e uma maya untiye: ");
INSERT INTO for_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","We, Isugaba Nasaretirisa yagaragawe. Taegukena kanapaya, nana puratakena kanane. Piya, naeba ago abopa, kaeba Kotitisa aota yagaragawe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Piya yogana, Isu: Paka pumagina atate irosa'ma wagaso, omintiye. ");
INSERT INTO for_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Omogana, kana yagarama antabaipisa ke kina'mi apasara potama tabera kega'e otate irosa'ma wagaintiye. ");
INSERT INTO for_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Aibogana, a'ya'ma kina'miba agate pami pumagini, maya kamana mare-u me-u puntawe: Nana kamanapaya iye. Taeba kampa abintompe kamana umagina, Kiya kina'mi usu kamana uma uwaitagini kegina'miba kamana'wapa wasiyewe, untawe. ");
INSERT INTO for_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aibogini, a'ya'ma Karariya kina'miba Isu pomentanaga abite napintawe. ");
INSERT INTO for_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pigoya, Isuba mono namapisa iro'ma Isu Yemisike Yonike isibabute wamagini, Saimonike Enturuke isige namapinti wantawe. ");
INSERT INTO for_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Waumepa, Saimoni aentawampa nkau yaku taogana awaitamintogini, Isu omuguna, ");
INSERT INTO for_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","aeba wama uma ayata u'ma asitaogana, yonintanawapa ata waogana, kana wae'maba naninta maema imogini nantawe. ");
INSERT INTO for_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Pigoya, pi ntagaba asenamaita a'ya'ma yoni kinake ke kina intabaipinti minta kinake ibabute Isuti kanagana pumagini, ");
INSERT INTO for_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","a'ya'ma pi kumatasa kina'miba nama kabera ampintugana ");
INSERT INTO for_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","uwoma kina'mi tonarona inuntanawaipa kaba itamagina, uwoma keginapa igarubantiye. Pigoya, ke kina'miba ae'wa nkagoba agauguna, pipa mare-u me-u pusanaga akunkitantiye. ");
INSERT INTO for_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pigoya, abaya aseka Isu asima iro'ma wama, ka'me mpari wamagina uma nunamu yogini, ");
INSERT INTO for_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ainti Saimonige aokinaka aguyosagata wama ");
INSERT INTO for_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","uma agate: A'ya'ma kina'mi kae kagakena pewe, omintawe. ");
INSERT INTO for_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Piya omuguna, Isuba maya untiye: Pigoya, taeba to ka'isa kumati wano. Igepa mono uwaimikenaga kanauwe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Piya uwaimitegina, aeba wama a'ya'ma Karariya mari wama, mono namankaipinti kamana uma uwaimimagina, uwoma ke kinapa agarubantiye. ");
INSERT INTO for_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pigoya ka karu yagara aeti kanama ampa parokaema mima, esegima mayama abigantiye: Kaeba kabemika kaba natakena puntanapa aogi punatao, omintiye. ");
INSERT INTO for_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Piya omogana Isu antara potama, ayapa parosuma auta u'ma maya untiye. Piyaenaga nabiye. Pabigo kata wakana aogima miyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Piya yogana, pabi ntaga kana karuyenawapa ata wantiye. ");
INSERT INTO for_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ata waogana Isu esegima uma maya omintiye. Uwa kinapa a-nkuwaimima, kaeba marupa mono kiye yarara uma kaupa ayakegana agano. Piya, kata wamikaba pai Mosese uramintintanaba amegini wasanamiba kagate: Aoso yagara miyema napikibewe, piya omintiye. ");
INSERT INTO for_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Aibogana, kana yagara abe'i irosa'ma wama, mare-u me-u puma pi kamana uwaimogana, Isu to kumati uwa wakenaga kampa abogana, abe'i ka'me mpari mintogini, a'ya'ma auka'isa wasanamiba aeti wantawe. ");
INSERT INTO for_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Pigoya, to yagaba Isu a'wae puma Kapaniyamu kumati to kakema umintogini, wasanamiba: Isuba wa'eri ago ampintiye, untawe. ");
INSERT INTO for_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Piya yuguni uwoma kina'mi namapa ampa pumaewauguni, ka'isa kina'miba kaberi ampa aki puma mintuguna, Isu aogi kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Piya uwaimogini, wasanami agisa aya pu'wanta yagara ababute kanama, tarawa tarawa kina'mi wasirite kanantawe. ");
INSERT INTO for_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kanaumepa wasanaba pumaewauguni kampa Isu agora ababute inta, nama nkabobori imagini, asu akuritama, pita'isa kana yoni ntagaraba wasa yara waitama motauguna tumintiye. ");
INSERT INTO for_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tumogini: Aogi potakiyema napiyuguna, Isu ibite: Yagaranepa, aguntaenagapa iba maegagasuwe, omintiye. ");
INSERT INTO for_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Piya omogini, ka'isa mono tisa kina'miba pita mara'mima mayama ige napintawe: ");
INSERT INTO for_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Nanagabaya pi ntagaramaba maya kamanapa iye. Kotika akaya kasa iye. Kebaya aguntaenarepa maeragaikiye? Koti ae abinto maeragaikiyema napintawe. ");
INSERT INTO for_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Piyama napiyuguna age napima ibite Isu mayama uwaimintiye: Nanaga piyamaba tigebipa napiyewe. ");
INSERT INTO for_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nana kuntaenawema napiyewe? Yoni ntagara aguntaenagapa maegagasuwa, asima wasaga aesagabite wao yoka yewo, utegina: ");
INSERT INTO for_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tigeba abiyo. Wasanama Ntagara naeba ma mpabi esegiyenanetasa aguntaena maerigaikena esegiyenanepa waintiye. Naeba kuntaena pekiripa, agate napima yiyo uwaimintana, agisa aya pu'wanta yagaraba maya omintiye: ");
INSERT INTO for_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Naeba ugaminta, kaeba asima wasagapa aesagabite wa'egati waoma omintiye. ");
INSERT INTO for_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Omogana kana yagaramaba asima wasawa aesagabite waogini, agate a'ya'ma kina'mi tabera pami pumagini, igeba: Taeba kampa agantompentanawe. Koti aogi potayema, Koti i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pigoya, Isu iro'ma wama kotu awamori to umintogini, a'ya'ma kina aeti wabuguna, kamana'wapa uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Uwaimitegina to waomepa Aribai, Aopayesi ntagara, takisi opisiwapinti mintogana uma agate: Naegarao, omintiye. Omogana asima aegarantiye. ");
INSERT INTO for_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pigoya, uwoma takisi maeyume kinake kamparaga kinake aegarauguna, aeba Aribai ntamapinti umima, pi kinake Isuge abagi kinake mima naninta nauguni, ");
INSERT INTO for_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Parasi kina'mi nkarotu tisa kina kanama ampa igaumepa, pi kinake mima nama miyogini, agate abagi kina'waka mayama ampa ibigantawe: Nanagabaya takisi maenta kinake kamparaga kinake nanintaba nayema, ibigauguna, ");
INSERT INTO for_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Isuba abite maya uwaimintiye: Wasana kampa yoni nkibemi kina'miba tusa yagaramati kampa wawe. Yonintana ibemi kina'mi mana igeba wawe. Piya: Aogi kinatawe, ye kinapa aogi puwaitakenaba kampa tumintuwe. Naeba agunta kina igu a'wae pikibeka uwaimikena tumuwe, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pigoya, Yoni abagi kinake Parasi kinake ka'isa yagaba naninta atate uwa mintuguni, wasanami kanama Isupa mayama abigantawe: Nanaga Yoni abagi kinake Parasi abagi kinake ka'isa yagaba monoka nanintaba a'a-o uma uwa mintuguni, nana piyema kae kabagi kina'miba nanintaba a'yugu nawema, abigantawe. ");
INSERT INTO for_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Abigauguna Isu maya uwaimintiye: Pigoya, wasanami iba'ena puntiniba, a'ya'ma kina'miba nanintaba umaerite kampa menkatama miyewa, karu'ena ampa nawe, uwaimintana: Pi ibawae'ma nkawaewampa uwamintegini, ae aokinapa naninta imepa igeba kampa a'a-o unta maeyawe. ");
INSERT INTO for_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pigoya, ainti iba'wae'ma nkawaewampa ampa arakurite ababute to mari wagasiginiba, pi ntagaba ao'miba intara puma kampa nanintaba nanta, uwa mima aeka napikibewe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Piya uwaimintana to kamana maya untiye: Pigoya, paisa kai atugekanaba, wasanaba kampa aoso kaiba kasama pitapa atama pugunikiye. Kampaye. Piya pikibipa to paisa kaiwamaba to tabera atugekana, tabe age waikiye, untana, ");
INSERT INTO for_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","to ka kamana maya untiye: Piya, wasanama kasa yamanka antinkapa maema, kampa paisa yaga au'aribintiba ataye. Antipa piyama ataisinta, akapisa anosama, kana paisa yaga au'ariba kampa aibakentama, karu'ena muru'wagina wanipa pita'isa tumiwasine. Piya, kasa yamanka'ama nkantipa kasa yaga au'aribinti ataye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pigoya, ka sabatirapa Isuba witi yugabinti waogini, abagi kina'mi wamagini kana witi yugabisa maeyuguni, ");
INSERT INTO for_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parasi kina'miba maya untawe: A'yuguyena pewe. Tigeba sabatirapa akumparanta'enaba piyaba pewema, Isupa abigauguna, ");
INSERT INTO for_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","maya uwaimintiye: Tigeba tayabama Tebiti puntintanagaba kampa napiyewo. Abayata mono kiya yagara mintogana, Tebitige aokinake iga'ena ibogana, Koti mpono namapinti iyogana Abayata Koti nkamume ntaninta maema amogana nantana, aokinapa imogini nantawe. Pipa uwa kina'mi ntanintaba kampaye, mono kiye kina'mi ibiwai nakena nanintawe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Piya untana to maya uwaimintiye: Kotiba wasanaga migaranema napima sabatiba puntiye. Sabatigaba kampa napinta wasanaba maru puntiye. ");
INSERT INTO for_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Piya puma Wasanama Ntagara naeba sabatirapa kabima miyuwe uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Pigoya, Isu ini namapinti to waomepa, pita'i aya pu'wanta yagara mintogini, ");
INSERT INTO for_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pitasa kina'miba Isupa agategini, sabatira kana yagara aogi potakaba agate kamana otakunema napintawe. ");
INSERT INTO for_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pigoya, Isu aya pu'wanta yagaraga: Mati kanao, omintana, ");
INSERT INTO for_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","pi kinakaba mayama ibigantiye: Ago kamanatepa ayama napiyewe. Sabatirapa wasana aogi puwaitakunema napiyebaya, ata puwaitakunema napiyebaya, iyogaitakunema napiyebaya, iyegukunema napiyewema, ibigantiye. Ibigaogini kamana kampa unta, asaba wantawe. ");
INSERT INTO for_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Piya, igeba ige akuninta kina mintuguna igategina, antara pumagina, kampa a'mu puwaitanta ka ibirantiye. Piya puntana kana wasanagaba, Isu: Kaya paroso, omintiye. Omogana aeba aya parosogana atawantiye. ");
INSERT INTO for_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Piya pogini, Parasi kinapa iro'ma Eroti aokinake aki puma mintini: Aya pumabaya aegukunema napima, mare-u me-u puntawe. ");
INSERT INTO for_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pigoya, Isuge abagi kinake pi kinapa itate kotuta wauguni, uwoma Karariya kinake, Yuntiya kinake, ");
INSERT INTO for_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yerusaremi kinake, Intumiya kinake, Yontani wani aka'isa kinake, Taya kuma'ama agorasa kinake, Saironi kuma'ama agorasa kinake, a'ya'ma Isu pome kamana abima, uwoma kina aeti wantawe. ");
INSERT INTO for_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Piya, uwoma kina Isu aogi puwaitaogini, a'ya'ma yoni kinapa aibasana'ma mareta meta puta wama aeti wamagini: Auta uma arakurukunema, napintawe. Piyama napiyuguna, Isu: A'yugu napasa nakibewema, wanipisa kareba nagora ataiyoma, abagi kinaka uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Uwaimogini ke kina antabaipi minta kinapa agantiniba intagawarisa uma aigarepa'wama kega'e uma: Kaeba Koti Ntagaragawe, untawe. ");
INSERT INTO for_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Piya yuguna: Wasanaba piyaba a-nkuwaimiyo, Isu ke kinapa esegima uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Pigoya, Isu amuti ima aewa napiyome kinaka igega'e uma: Kanaiyo, kega'e yogini aeti kanantawe. ");
INSERT INTO for_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kanauguna nagisarisa tara tumpaema kina ibabuma: Tigeripa aposoro kinatawe uwaimite: Nae nabagi pumagiri, kamana'nepa uwaimikenaba wamagiri, ");
INSERT INTO for_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","esegiyenanepa maema ke kinapa agarubakibewe, piya uwaimima ibabuntiye. ");
INSERT INTO for_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Pigoya, abagi kina'mi nkigewaipa maya uwaimintiye: Saimoni aoso ominti nkagiwapa Pitawa, ");
INSERT INTO for_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sepeti ntagara Yemisiwa, Yemisi nka'nantowampa Yoniwa, isigewaisipa anagi isigi Powanagisiwe uwaisiminti, tae kamanapisa antaru yisa kina miyese uwaisiminti, ");
INSERT INTO for_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Enturuwa, Piripiwa, Patoromayowa, Matiyuwa, Tomasiwa, Aopayesi ntagara Yemisiwa, Tariyesiwa, namu'isa kiya kina igarubakaikena abugai ntagara Saimoniwa, ");
INSERT INTO for_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ainti Isu minaga'ena punti ntagara Yutasi Isikeriyotiwa, sumagini, abagi puntawe. ");
INSERT INTO for_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pigoya, Isu wa'eri tumogini, uwoma kina aeti ampa aki puguna kampa nanintaba nakena puntawe. ");
INSERT INTO for_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kampa nakena puguni, wa'ewatisa kina'mi piyama abitegini: Aeba aibo'enabaya piyema napimagini, Isu arakurikena kanauguni, ");
INSERT INTO for_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","mono tisa kina Yerusaremisa tumume kina'mi maya untawe: Piyesibu ababibayawe, untini: Ke kina'mi kana tabewaimpa nkesegiyenawatasa ka'isa ke kina igarubakasabayawe, untawe. ");
INSERT INTO for_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Piya yuguna, kega'e yogini aeti ampa aki puguna, imiyo kamana maya uwaimintiye: Kewama ae'wapa aya pumabaya agarubamisine. ");
INSERT INTO for_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Piya, ka marasa kina'mi ige igewai ma'ena pesinta, kampa aogimapa miyesine. ");
INSERT INTO for_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Pigoya, wasanama aokina'mage maka yesinta, kampa aogimapa miyesine. ");
INSERT INTO for_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Piya puma, kewama aokinaka ka ibiramisinta kampa uwa miyegina, esegiyenawaipa kampa waiyisine. ");
INSERT INTO for_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Piya, ka'wainaba to ka esegi yagarama ntamapinti wama ae'ena kuntana maekena puntanaba, marupa kana esegi yagaraka araku'ma iga'narasa kirokaetama, namankapisa kotapa kuntanaba piye. ");
INSERT INTO for_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Piya, taga kamana urimuwe. Wasanama aguntaenawape a'ya'ma ka abirakibintanawape maegaikenaenawe. ");
INSERT INTO for_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pigoya, wasanama Aogi Awamusaka ata kasa ikibipa, Kotiba kampa maegaikiye. Kana aguntaenawapa kampa maegasakana a'ya'ma yaga uwa waikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Piya: Aeba ke kina ababiye, yuguna, Isu kana kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Piya yogini, anobe a'natabarabe abe'i ampima, aeka kega'e untawe. ");
INSERT INTO for_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kega'e yuguni uwoma kina, agora mara'mintume kina'miba: Kanobe ka'natabarabe abe'i ampa mima kagakena pewe, omuguna: ");
INSERT INTO for_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nanobe na'natabarabe ayabayawema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Isu piyama ibigategina, agora mara'mintume kina igategina maya uwaimintiye: Nanobe na'natabarabe mampa tigege tige mintawe. ");
INSERT INTO for_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Wasanama Koti yemi kamana abe kinapa, pi kinapa nae na'natabarabe nanobe mintawe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Pigoya, kotu awamori Isu to kamana ukena pogini, uwoma kina'mi aeti kanama a'ya'ma ampa aki puguna, uwa marisa atate wanipisa karebi kotupi umintogini, a'ya'ma kina kotu awamori mintantawe. ");
INSERT INTO for_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Mintuguna aeba uwoma meto kamana uwaimintana, ka maya kamana uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Abiyo. Ka yagarama aintana pikena wantiye. ");
INSERT INTO for_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Aeba wamagina aintanawapa maema aibarase pogana, aowa ka'isaba kepi tumpa waiyogana, kabarankama irosa'ma ampa nawaegaintiye. ");
INSERT INTO for_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Pigoya aowa ka'isaba yabankama nkabobori uwaena manto waintometa tunkwaima, karu'ena irantiye. ");
INSERT INTO for_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Piya pogana, abu'wapa kampa mabintiba tuminta, yaba nkabobori ara'waiyogana, pa taogana aeba karu'ena asama pari puma pu'wantiye. ");
INSERT INTO for_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Pigoya, to ka'isa aowapa kabubinti tunkaima iraogana, pi yoninkama aibarusa pogana asa wantiye. ");
INSERT INTO for_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pigoya to ka'isaba apa mabi tumpa waima i'ma anosama aosa pama, ka'isa 30-wa, to ka'isa 60-wa, to ka'isa 100-wa suma aboraogana, uwoma ntaninta waintantiyema, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Uwaimintana: Ageyaga kina'maba ma kamana abibebe peno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Pigoya, pi a'ya'ma kina atate wagasuguni, nagisarisa tara tumpaema kina'wake to aokinake meto kamana yomeka abigauguna, ");
INSERT INTO for_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","maya uwaimintiye: Tigeba Koti kabiratakibintanagaba ago urimikenaba piye, uwaimite: Uwa kina'mikaba kana amiyo kamana naeba uwaimogini, ");
INSERT INTO for_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","pigoya Aisaya pai kaemarantisa puma iba mayaenaba pewe: Igeba abepa agowapa kampa abewe. Agapa agowapa kampa agawe. Piya, ago aogima abesinta aguntaenawai ataigina, Koti mae igasasine, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Piya uwaimintana, to kamana maya uwaimintiye: Tigeba ma meto kamanapa kampa abintawo. Aya pumabaya a'ya'ma meto kamana agowapa abikibewe. ");
INSERT INTO for_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pigoya, pi aintana punti ntagara aintana aibarase puntisa puma, aogi kamanapa aibarase piye. ");
INSERT INTO for_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Piya, kepi tumintisa puma aogi kamana ke'i aibarase pogini, pi ka'isa kina'mi abepa, kewama karu'ena kanamapa, intabaipintisa aintana kanta puma wainti kamanapa ampaeriye. ");
INSERT INTO for_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Piya, ka'isa yabata tumima abu'wa kampa pantaisa pumaba, ka'isa kina'miba pewe: Aogi kamana abima maru'ena i'mu puma, arontaganto aogima miyegina, aintiba kana kamanatakaba antara'ena aboraginabe ata potakenaena aboraginabe, karu'ena uwa ataye. ");
INSERT INTO for_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Pigoya, toba piya puma kabubinti tumintisa puma, ka'isa kina'maba maru'ena aogi kamana abima, ");
INSERT INTO for_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","aintiba mampabisaenaga napima, kotaka ibugagina tonarona maekenaga napiyegana, kana kamanapa agora kaka waye. ");
INSERT INTO for_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pigoya, to ka'isa aogi mabi tumima tabera irantisa puma, to ka'isa kina'miba kana aogi kamanapa abima aega'ma miyewe. Piya, aintanaba ka'isa 30-wa, ka'isa 60-wa, to ka'isa 100-wa suma, aborantisa puma, wasanaba tonarona aogiyenaba Kotiti potawe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Uwaimintana to mayama ibigantiye: Pigoya, wasanama kane yaku igi'maete namapinti wamaba, aeba kankabe maema aibarakitakibe, waikena sipa amentapinti metakibe, yara itagikibayawe, a. ");
INSERT INTO for_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","We, kampa agantintanaba agorapa kampa kaka wantiye. Toganaba kanewama e'wasa pisa puma meto kamana'ama nkagowapa aborakiye. Airari kaenta'enaba toganaba aborawaekiye. ");
INSERT INTO for_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ageyaga kina'maba abeno, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Uwaimintana to kamana maya uwaimintiye: Pi abe kamana aogima abima tigebi ataiyo. Abimagiri tigeba wasana pabi aborawaimikibe nkawameta Kotiba a'wae puma timikiye. ");
INSERT INTO for_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pigoya, wasanama ka'isa agowapa aogima napikibipa, uwoma to agoba Kotiba omikiye. Pigoya to yagarama kamana agowa kampa napikibipa, abikenaenawapa Koti maegaikiye, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Uwaimintana Isu to maya uwaimintiye: Pigoya, Kotiba mayama taepa kabirataye: Wasanama yogari wama, aintana pugaitegina, ");
INSERT INTO for_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","asi nasi asekapa waimarate, arapa asima uma agateginaba: Aya pumabaya kana aintanaba i'ma anosakiyema, napiye. ");
INSERT INTO for_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Piya, aewa mabintisa i'ma a'yenka aboraurite ima, aosaba pama anontana pegina, ");
INSERT INTO for_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","pi ntagaba yogari wama naninta umaeye. Pigoya nanintara kabiyisa puma Kotiba piyama tagutapa kabirataye, untiye. ");
INSERT INTO for_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Piya untana Isu to maya untiye: Pigoya, Koti kabiratamisa puma nanawe ukune. Pikaba ayama meto kamanapa ukunema, ibigantana: ");
INSERT INTO for_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pigoya, masiteti yawama nkaowapa uwaenantonto waintakana maema aintana pukibipa, ");
INSERT INTO for_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pipisa i'ma anosama tabe ya ima, amaba tabera wagana kana pegina, kabarankamaba amari inapa kiyewe. Pintana piya pemisa puma Kotiba piyamakabirataye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","34","Pigoya, uwoma meto kamanatasa aogi kamana'wapa uma ige abikena kamana uwaimogini abima napiyuguna, toma toma meto kamana a'ya'ma kina uwaimitegina, togana abagi kina'wa ibiwaipa meto kamana a'ya'ma agowapa uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Pigoya, pi ntaga ase yogana: Ta'ema maroteri wakune, uwaimitegina, ");
INSERT INTO for_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Isu wanipisa karebi mima, awamori mintume kinapa itaogini, abagi kina'mi wanipisa karebi ababute wauguni, to wanipisa karebi ka'isa kinapa aege wantawe. ");
INSERT INTO for_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Piya puguna, agasiya ponta kanama wanipa tabera aiga'yo'ya puma, ka'isa wanipa wanipisa karebinti iyogana, kunta puma ipirintakena puntiye. ");
INSERT INTO for_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Isu a'no aisagenawata waitamintogini, igeba aeti wama abage pumagini maya omintawe: Tisa yagara, kaeba taekaba kampa napiyeno. Taeba naisukena pune, omintawe. ");
INSERT INTO for_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Piya omuguna, aeba asimagina pontawamakaba tabe kamana umagina, waninkamaba: Pasebuma, uwa waiyo yogana, ponta a'ya waogana wanipa uwasuwa puntiye. ");
INSERT INTO for_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aibogana maya uwaimintiye: Nanaga tiyekuruba pewe. Timititi'enaba kampa waintiya, a, untiye. ");
INSERT INTO for_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Piya yogini, igeba pami pumagini: Aeba nana yagaragana, pontawamabe waninkamabe ae kamana wasiyesema, igeba mare-u me-u puntawe. ");
INSERT INTO for_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pigoya, igeba kotu maronkateri wama, Kerasa kina'mi mpari wama, ");
INSERT INTO for_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","wanipisa kare atate tumogana, wasana irubintisa ka yagara, ke kina antabaipinti minta yagarama, Isuti kanantiye. ");
INSERT INTO for_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kana yagaraba asi nasi wasana irubinti miyogini, wasanami kampa araku'ma esegi iga'narasa kampa ayapa kirokaentawe. ");
INSERT INTO for_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pigoya ka'isa kina'mi pai uwoma ntaga araku'ma, agisa ayatapa esegi iga'narasa kirokaetauguna, ayapisa atisa kaitegina agisabisa airisa pugasi pogini, wasanamiba esegiyenawapa kampa asugaintawe. ");
INSERT INTO for_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kana yagaraba a'ya'ma yaga arape asenabipe wasana irubinti mintana amuti mintana pumagina, ata kiga'e uma yaba kasu mpaema aupa airisa puntiye. ");
INSERT INTO for_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pigoya, aeba e'ero marisa Isupa agategina, karu'ena kanama aeti ampa arakabima mintogana, ");
INSERT INTO for_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Isuba: Ma ntagarama nkantabaipisa ke kinapa irosao, omintiye. Piya omogana, kana yagarama taberasa maya untiye: Isu, kaeba inatisa tabe Koti Ntagaragawe. Nana punatakena kanane. Koti nkaobi suwa, a-nkata punatao, untiye. ");
INSERT INTO for_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Piya yogana Isu aeba: Kagegapa kegawema, abigantiye. Abigaogana: Taeba uwoma mintompeka, piya puma nagenepa Uwomane unamewe omintiye. ");
INSERT INTO for_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Piya omima: Mamparisaba a-tagarubaoma, esegima abigantiye. ");
INSERT INTO for_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pigoya, uwoma ntaga amu ararabiri mima naninta nama miyuguni, ");
INSERT INTO for_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ke kina'miba: Tagarubaga yaga intabaipinti wanoma, abigantawe. ");
INSERT INTO for_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Piyama abigauguna aeba: Pigoya waiyo, uwaimintiye. Uwaimogini kana ke kinapa antabaipisa iro'ma intabinti ubasuguni, kana yaga, 2,000 yagagini igeba karu'ena ausari tumima, kotupinti tumpa naisuwaewantawe. ");
INSERT INTO for_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Naisuwaewauguni yaga kiye kina'miba karu'ena iyegaka wama, wa'eribe yogaribe wama uwaimuguni, wabe wayape kanagana puma, kana pomentana ampa agakena kanantawe. ");
INSERT INTO for_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Isuti kanamagini ampa agaomepa, kana pai ke kina antabaipinti minta yagara kaiwapa amitauguna mara'mima aogima mintogini, agate iyekuru puntawe. ");
INSERT INTO for_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aibuguni pomentana agaume kina'mi kana yagaragawa pi yagagawa suma uwaimintawe. ");
INSERT INTO for_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pigoya pi kina'mi: Mampa atate tori wao, ukena puguna, Isu atate tori wantiye. ");
INSERT INTO for_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tori wakena pumagina wanipisa karebi iyogana, kana yagara pai ke kina antabaipinti minta yagara kanama, Isuka: Nababo, yogana, ");
INSERT INTO for_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Isu: A'a-o, untana: Wa'egati wama, Koti antara pugatama aogi pugatami kamana kaokina uma uwaimo, omintiye. ");
INSERT INTO for_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Piya omogana aeba wama, pi naya tara'mu kuma'i wama, kana Isu pome kamamapa uwaimikena pogini, a'ya'ma kina'mi abite pami puntawe. ");
INSERT INTO for_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pigoya, Isu wanipisa karebi to wama maroteri wama awamori umintogini, uwoma kina aeti kanantawe. ");
INSERT INTO for_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Kanauguna ka mono namatasa kiya yagara, agewapa Yairasi kanama ampa agate Isu agisabi parokaema mima, ");
INSERT INTO for_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","maya uma abigantiye: Aragantonepa agaro ntaganto purikena piye. Kaeba kanama auta uma arakuregana, aeba atawakanaba aogima miyeno, yogana, aege wantase. ");
INSERT INTO for_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Piyama aege wausuguni uwoma kina aega'ma wama agora karare putanasuguna, ");
INSERT INTO for_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ka wae'ma aeti kanantiye. Kana waepa iyegaena abogana nagisarisa tara tumpaema kabuba miyomepa kampa ata waogana, ");
INSERT INTO for_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","tonarona tusa kinati waomepa, kampa aogi potauguna, a'yawaema yabankapa ige imiwaegasomepa, kana yoninkapa kampa ata waogana, to tabera ataena abuntiye. ");
INSERT INTO for_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Pigoya kana waepa Isu pome kamana abite, uwoma kina mintume ikapinti kanamagina, ampa napima: Kaiwata aukaya pukubopa nata wakiyema ageba napimagina, aka'i kanama kaiwata aukaya pogana, ");
INSERT INTO for_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","korankapa ago tabagobu waogana age napiyomepa: Yonintepa ago natawayema, napintiye. ");
INSERT INTO for_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Aibogana Isu: Ka'isa esegiyenane wayema, age napigategina: Kainetapa kebaya aukaya piyema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ibigaogini, abagi kina'mi maya omintawe: Uwoma kina'mi kagorapa mintagana agana, nanagaba: Kebaya naukaya piyeba yene yuguna, ");
INSERT INTO for_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Isu: Kebaya piyema, marega mega puntiye. ");
INSERT INTO for_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Piya pogana kana wae'maba potaomentanaga napima, aekuru puma tabaraba pumagina, ae agora ampa parokaema mima, a'ya'waemaena pome kamanapa omintiye. ");
INSERT INTO for_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Omogana, Isu maya omintiye: Araganepa, kamatiti punatampeka aogi kabiye. Pika wama aogima miyo, omintiye. ");
INSERT INTO for_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pigoya, pi kamana uma miyogana, ka'isa kina'mi kiya yagarama namapisa iro'ma kanama, kiya yagara maya omintiye: Aragagapa ago pu'waye. Nanagabaya tisa yagaraba to kamanapa omima miyene, omuguna, ");
INSERT INTO for_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Isu kana kamana kampa napinta, ini nama kiya yagarapa: A-kaekuru puma, naeka aogima napima miyo, omintiye. ");
INSERT INTO for_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Omigaite wasanaba: A-kanaiyoma, akunkitate, Pitawa Yemisiwa Yemisi a'nantowampa Yoniwa suma, ibiwai ibabute wama, ");
INSERT INTO for_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","mono nama kiya yagarama ntamapinti waumepa: A-e a-e, uma tabe kube'ena puma miyuguna, kana kamana abite, ");
INSERT INTO for_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","namapinti ima maya uwaimintiye: Nanagabaya tabe kamana uma kubenaba pewe. Kana aragaba kampa agorapa pu'waye. Uwa waitamintiye, uwaimogini, ");
INSERT INTO for_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","igeba kagi potantawe. Piya puguna a'ya'ma igarubaogini abe'i irosa'ma tumuguna, kana aragantoma anoke abake abagi kinake ibabute wama, araganto mintometiba intiye. ");
INSERT INTO for_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Imagina kana aragantoma ayata u'ma: Tarita kumi, omintiye. Kana kamanapa tae kamanapisaba: Araganto asiyo ugamuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Piya yogana kana araganto karu'ena asima nasi nasi puntiye. Pi nkaraga kabuwapa nagisarisa tara tumpaema kabu pome nkaragantowe. Asima nasogini igeba agasiyama pami puguna: ");
INSERT INTO for_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","To kinapa pontanaga a-nkuwaimiyo, untana: Kana araga naninta amigina nano, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Pigoya, Isu pitasa itate mawati waogini, abagi kina'wampiba aege wantawe. ");
INSERT INTO for_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Pigoya sabati yagaba mono namapinti wama kamana yogini, uwoma kina'mi abite pami puma maya untawe: Ma ntagara aetasabaya kana kamanapa maeye. Aetasabaya ma aogi napiyenaba maeye. Aya pumabaya kampa agaompentana aewapa esegima piye. ");
INSERT INTO for_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Taeba agowapa abintune. Aeba kapenta yagara, Meri ntagara mintiye. Yemisige Yosesege Yutasige Saimonige igantowaimpa mintegini, ae imanapa mata taege miyewe, piya umagini Isuka abuguna kampa aogi puntiye. ");
INSERT INTO for_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Aibogana, Isu maya uwaimintiye: Koti unti kamana yemi poropete yagarama kamanaka uwoma kina'mi ibugaye. Pigoya mawatape namankapipe ageba kampa waintiye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Piya, aeba kana mariba kampa tabe yuga puntamikana, yoni kinapa taranto ita u'ma aogi puwaitantiye. ");
INSERT INTO for_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Aibogini igeba aekaba kampa napiyuguna: Nanagabaya kampa abewe, untiye. Piya ute, pabi kumata uwaena kuma'antontori nasima kamana'wapa uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Isu abagi kina nagisarisa tara tumpaema kina'wa igega'e yogini menkaki puguna, ke kina agarubakena esegiyenaba imima tara tara puma to auka'i to auka'i igaruba'ma, ");
INSERT INTO for_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","maya uwaimintiye: Tigeba nasikibepa, kotapa a-mpaete wantiri nanintabe kope uwa atantiri, tibamukantisa ikantana pukena yabapa a-nkurite waigina, Koti kabiritakiye. Pigoya, pusu'ma nasikena asage, ");
INSERT INTO for_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","tigisa anage maentiri, kaiba ka'anto purite waiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Pigoya to kumati to kumati waigini, maru: Naege mikibewe ikibi ntagarama ntamapi wama, pi kumata a'ya'ma yaga aege umigategiri, to kumati waiyo. ");
INSERT INTO for_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pigoya to kumati waigini, kampa ti'ma'ma kamanati kampa abigiripa, tigisarisa i'ni asari puwaitate toriba waiyo. Piya piginaba: Kampa taekaba i'mupa pewema napikibewe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Isu uwaimogini, igeba nasima: Tigeba ataenaripa kasiyo uwaimintini, ");
INSERT INTO for_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","uwoma ke kinapa igarubantini, uwoma yoni kina'mipa i'noti masawae pai'itauguni ita wantiye. ");
INSERT INTO for_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pigoya, Isuka kamana mare-u me-u puguna, Eroti kiya yagara yome kamana abintiye. Piya, Isu esegi yuga pikana: Yoni wani pai'ita pome ntagara pu'watitisa asima mintibayawema, ka'isa kina'miba napiyuguni, ");
INSERT INTO for_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","to ka'isa kina'miba: Iraiyabayawema yuguni, to ka'isa kina'miba: Pai Koti kamana unti ntagara kanta pikana kana yagaraba poropete yagarabayawema, napintawe. ");
INSERT INTO for_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Piya yuguna, kana yagaraga Eroti maya untiye: Yoni wani pai'ita pome ntagarabayawe. Nae uwaimuwagini ana'mu arisata ntagarama asima mintiyema, napima untiye. ");
INSERT INTO for_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Pigoya, pai Eroti nka'nantowampa Piripi nkwae Erotiyasi maeyogana, wani pai'ita punti ntagara Yoni Erotipa maya omintiye: A'yuguma ka'nantogampa nkwae maeyane, omogana, abigategina pika Eroti wasana uwaimogini, Yonipa araku'ma iga'narasa kirokaetama, iga'na namapinti metantawe. ");
INSERT INTO for_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Aibuguna Erotiyasi Yonipa kabi'ma aegukena pogana, ");
INSERT INTO for_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Eroti, Kotiti Yoni aogima aegaranta yagaragana, agate aekuru pumagina, Yonitapa kabima mintantiye. Aibuntana Yoni kamana abisanaga abugaogana, asi nasi abite Eroti pami puma aekuru puntiye. ");
INSERT INTO for_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Piya pogana ka yaga Erotiyasi Yonika ataena potakena agi napintiye. Pi ntaga awaewampa yakari potanta yaga aboraogini, kamani kiya kinake ami kiya kinake Karariya kumatasa kiya kinake menkaki puguna, Eroti taena puwaitaogini nama i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Piya puguna, Erotiyasi nkaragawae'wampa wama wa'ena uma pogini, Erotige kiya kina'mige i'mu potamagini, Eroti mayama abigantiye: Aragawae, nanaga kabiye. Kabikibintanaga unamegapa kamukuwe. ");
INSERT INTO for_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Taga kauwe. Ka'isaenaneka kabikibintanaga unamegapa uwa kameno untiye. ");
INSERT INTO for_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Piya yogana, kana aragawae'ma abe'i iro'ma tumima anowampaka: Nana namoma abigasuwe yogana, anowampa maya omintiye: Yoni wani pai'ita pemi ntagarama nka'no arisa namoma abigao, omogana, ");
INSERT INTO for_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","karu'ena kana kiya yagarari wama maya omintiye: Ibanto Yoni wani pai'ita pemi ntagarama nka'nopa arisa'ma tu'napi atama namo, yogana, ");
INSERT INTO for_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","kana kiya yagaramaba antara pugantiye. Pigoya, aki puntume kina'miba: Taga kauwe yome kamanapa abuguna pika napintana: A'a-oba kampa unta, ");
INSERT INTO for_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","irebu yagaraga: Wama Yoni nka'no kasama menkamo, yogana, iga'na namapinti wama uma kasama, ");
INSERT INTO for_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tu'napi atama maete aragawae menkamogana maete anowampati memintiye. ");
INSERT INTO for_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Aibogini, Yoni abagi kina'miba abitegini, abamupa maema mabinti kaitantawe. ");
INSERT INTO for_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pigoya, Isu nkabagi kina'miba yogawaipa atate Isuti wama, a'ya'ma pume kamanape uwaimume kamanape ampa omintawe. ");
INSERT INTO for_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Piya puguni uwoma kina'mi pita'i kanagate wate puguni, Isuge abagi kina'wampige kampa nanintaba nauguna, pigoya abagi kina'waka mayama uwaimintiye: Tabire to auka'i wama, kampa wasana mima auka'i uma migarakune, uwaimogini, ");
INSERT INTO for_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","wanipisa karebi ibinto ka'me mpari wakena puntawe. ");
INSERT INTO for_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pigoya igeba wakena puguni, uwoma kina'mi igate, a'ya'ma kumatisa atate karu'ena awamori wama, umikena pome mpara maru umintuguna, ");
INSERT INTO for_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Isu pita wanipisa karebintisa irosa'ma, uwaena kina tumpa igaomepa, piyama yaga awaro ano kampa miyisa puma, igeba mintuguna, tumpa igate antara puwaitama, uwoma kamana uwaimikena agobintiye. ");
INSERT INTO for_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Piya, ase ikena pogini, abagi kina'miba Isuti kanama maya omintawe: Ibanto atamaisaya, mapa ka'me mpari mintuna, ");
INSERT INTO for_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","a'ya'ma kinaka: Kuma'ibe yogaribe wama nanintarika uma agama ika piyo, uwaimintana igarubaoma, omintawe. ");
INSERT INTO for_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Piyama omuguna Isuba: Tigeba naninta maema imiyo, untiye. Piya yogini igeba: Aya pusune. Moneba 200 torarasa nanintaba ika puma imisanagaba kabiyoma, abigantawe. ");
INSERT INTO for_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Abigauguna, Isu maya uwaimintiye: Ayaki nanintaba urintabayawa, wama agaiyo, untiye. Yogini, igeba wama ibiga ibiga pugate kanama: Nayaka'mu paretiwa, inoyanta tarawa suma waintiye, omintawe. ");
INSERT INTO for_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Piya omuguna, Isu abagi kinaka maya uwaimiyoma uwaimintiye: Tigeba apepati a'ya'ma kina ka umaki ampaki puma miyiyo uwaimiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Piya yogini, uwaimuguni maropi mopi ka umaki ampaki puma mara'mimagini, ka'isa au'i 100 kina mara'miyuguni, to ka'isa au'i 50 kina mara'mintantawe. ");
INSERT INTO for_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mara'mintuguna Isu kana naya ka'mu paretiwa, tara inoyantawa suma mae u'ma mantari ao ma'magina Kotiti a'mu potamagina, pareti apako puma abagi kina imogini maete nasima imintawe. Pabiya puma inoyanta tarage apako puma, a'ya'ma kina imogini, ");
INSERT INTO for_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","pigoyema a'ya'ma kina'mi naumepa iga'e pantiye. ");
INSERT INTO for_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Aibogini, abagi kina'mi nasima paretibe inoyantabe aritapa maema, nagisarisa tara tumpaema ku iragintawe. ");
INSERT INTO for_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pigoya, kana naninta naume kinapa waba 5,000 waba mintantawe. ");
INSERT INTO for_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pigoya, Isu abagi kina'waka: Naeba a'ya'ma kina igarubakiri, tigeba wanipisa karebi paitama maronkateri Petisaira kumati waiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Pigoya: Tigeba waiyo, uwaimitegina amuti nunamu ikena intiye. ");
INSERT INTO for_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Piya, abiwa mima nunamu untana asekapa abagi kina'wa wanipisa karebi kotu nkakapinti mintuguna, ");
INSERT INTO for_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","igaomepa tabe esiba kanama, wanipa aiga'yo'ya aiga'yo'ya pogini, wanipisa kareba kampa aogima pubasanantawe. Aibuguna, Isu igate tumima, aseka aba mariki wani nka'eti ige igora wamagina uwaigaite, ");
INSERT INTO for_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","wani nka'eti nasogini, agate: Pu'wanta kina'ma nkamapayawe, utegini, igeba a'ya'ma agate iyekuru puma: A-e, a-e, untawe. Piya yuguna, Isuba: Naene kanauwa, tiyekuruba a-piyo, utegina, ");
INSERT INTO for_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","wanipisa karebi igege asu miyogana, esiba to pomesapa kampa puntiye. Aibogini agasiya pami pumagini: Ayabaya piyema, napintawe. ");
INSERT INTO for_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pigoya, atamaita pareti apako puma imome'na nkagowapa kampa aogima napiyuguna, kunta ibuntiye. ");
INSERT INTO for_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Pigoya kotu maronkateri wama, Kenesareti mara iro'ma wanipisa kareba ubu'atate wantiye. ");
INSERT INTO for_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Piyama wauguni, wasanamiba Isu agate, ");
INSERT INTO for_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","a'ya'ma kumati karu'ena wama uwaimuguni, yoni kina wasirite Isu mintometi kanagana puntawe. ");
INSERT INTO for_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Piya, Isu tabe kumatibe uwaena kuma'antontoribe yogaribe nasima agaogini, yoni kinapa wasirite kuma akapi meta menkata puma mintini: Kaeba kanagini kautasaenama nkatuta urigina ita wano, yuguni, a'ya'ma kina autasaenara uruguna ita wantiye. ");
INSERT INTO for_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kai'isa Parasi kinake mono tisa kinake Yerusaremisa kanama Isuti ampa aki puguna, ");
INSERT INTO for_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ka'isa aokina'mi Parasi kina'mi uwaimumesa puma, kampa iyantana punta, uwa nanintawai nauguni igantawe. ");
INSERT INTO for_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Piya, Parasi kina'mige a'ya'ma to Yuta kina'mige iyabami yume kamana aega'ma: Kumite aebasanaunema napima, iyankaota asu ma'maema iyantana pugaitegini, nanintaba nantawe. ");
INSERT INTO for_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Pigoya, igeba maketibisa naninta maeyumepa, kampa wasimi punta, kana naninta kampa nantawe. Piya toma toma paisa kamana abintini, kankabebe tu'nape kao'ena punakena tinibe abumesa puma wasimi puntawe. ");
INSERT INTO for_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pigoya nanintawai uwa nauguni igate, Isuka Parasi kina'mige mono tisa kina'mige mayama abigantawe: Kabagi kinakampiba, nanagabaya tayabami untasa puma kampa iyapa wasimi punta, uwa nawe, untawe. ");
INSERT INTO for_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Piya yuguna Isu maya uwaimintiye: Tigeba kumpari kina'mitaba, pai Aisaya mayama tigeka Koti kamana taga kamana ago kaemarantine: Ma kina'miba iwamutasaba nae nage asaga'yuntini, igu'amaba pagasara miyewe, iye. ");
INSERT INTO for_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Naeti mono'waipa kampa yewa, uwa yewe, iye. Nae kamana'nepa kampa unta, wasanami kamana yewema, Koti iyema, kaentiye. ");
INSERT INTO for_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Piya, tigeba nanagabaya Koti kamana akayuma, wasanami kamanapa abewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Piya untana to maya uwaimintiye: Tigeba ayabaya Koti kamanapa akayuma wasanami kamanapa wasiyewe. Pipa kampa kanarasaye. ");
INSERT INTO for_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Piya, Mosese pai maya untiye: Kano kaba kamana abima wasiyo, untana: Wasanama anoke abakega kamparaga kamana ukibipa, aepa aeguma kaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pigoya tigeba piya yepa: Anoba isimikenaenaga: Mapa kobaniwe umagina, tae kamanapisa: Mapa Koti amikenaenawe, umagina, ");
INSERT INTO for_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ano aba kampa isimikibipa, Aerane yewe. ");
INSERT INTO for_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Piya puma tigeti kamana yepa, nanagabaya Koti kamanapa uwa atawe. Piya, tonarona piyaena pewe, Isu uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Pigoya, Isu pi kinaka kega'e yogini, menkaki puguna maya uwaimintiye: Kamana'nepa tigeba a'ya'ma abibebe puma abiyo. ");
INSERT INTO for_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Uwa marisaena wasanama maema nakibipa, agupa i'nintana kampa potakiye. Piya, wasanama atama napiyekanaba agupa i'nintana potakiye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Uwaimitegina wasanaba itate namapinti iyogini, abagi kina'wampi kana meto kamanaka abigauguna, ");
INSERT INTO for_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","maya uwaimintiye: Tigege kana kamana agowapa kampa abintawa, a. Wasanama uwa marisa naninta maema nakibipa kampa i'nintana potakiyema, kampa abintawa, a. ");
INSERT INTO for_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Pipa kampa agupipa waikiye. Aga'epa tunkwaiyekana uwa megaikiye, untiye. Piya, Isu kamana agowapa: A'ya'ma nanintaba aogi nakena naninta waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Pigoya to maya untiye: Wasanama age napikenaenawampa agupa kamparagaba pikiye, untana: ");
INSERT INTO for_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wasanama antabaipisa toma toma napima aguntaenaba piye. Pipa mayamawe: Ata napiyenawa, kupiyonawa, kuntanawa, wasana aegukenaenawa, kumiyenawa, ");
INSERT INTO for_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","to wainantana maekenaenawa, aguntaenawa, kumpari'enawa, i'nintanawa, to waina mparu maekenaenawa, akayasukenaenawa, agebigo'enawa, aibo'ena pikenaenawa sumawe. ");
INSERT INTO for_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Piyaenaba napiyenawatasa aborama agupa i'nintana potakiye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Piya puntana, Isu asima pi kuma atate, Taya kuma agora wama napintiba uma migarakena pogini, wasanamiba: Ago Isu ampintiyema, napiyuguna, ");
INSERT INTO for_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","ka wae'ma abite Isuti kanama, agisabi uma parokaentiye. Kana waepa namu'isa wae, mawapa Siriya Ponisiya kumatasa waepa mintomepa, aragawapa ke kina antabaipinti minta aragawae mintogana, Isuti wama mayama abigantiye: Araganepa ke kina antabaipinti mintiya, wama agarubao, untiye. ");
INSERT INTO for_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Piya yogana, Yuta kinake to kinakega Isu meto kamana maya omintiye: Maru yakarantontomi ntaninta imigaite, karawama naninta aintiba imikena pewe. A'yugu yakarantontomi ntaninta kara amisanagawe, omintiye. ");
INSERT INTO for_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Omogana: We naba-o, yakarantontomi naninta arita maema karantonto imegini nawe, untiye. ");
INSERT INTO for_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Aiyogana, Isu maya omintiye: Aogi kasa yena, wa'egati wama aragagapa uma agao. Antabaipisa ke kinapa ago wagasaye, untiye. ");
INSERT INTO for_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Piya yogana aeba wa'eri wama, aragawa sipara uwa waitamintogana uma agaomepa, kana ke kinapa ago wagaintiye. ");
INSERT INTO for_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Aibogana, Isu Taya maba atate Saironi kumapa agaite, nayatara'mu kuma waintome ki'i wama, Karariya kotuta wantiye. ");
INSERT INTO for_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wama umintogini, ka'isa kina'miba agekumpa kampa aogima kamana yome ntagara ababute Isuti kanamagini: Kaya aukaya pegana, ata wano, untawe. ");
INSERT INTO for_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Piya yuguna, Isu kana yagara abiri ababute wamagina, aya amarasa ageba purosa atate, kaisa puma antebura atama, ");
INSERT INTO for_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","mantari mayo agau'magina, antara potama: Epata, untiye. Piya, tae kamanapisa: Ageba a'waiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Piya yogana pabigo ageba a'waiwaogana, awamupa kampa kunta abogana kamanapa uwa untiye. ");
INSERT INTO for_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Piya pogana, Isu: Makaba wasanaba a-nkuwaimiyo, untiye. Piyama toma toma: A-nkuwaimiyo, yogini, igeba uwaimome kamana uwa atate, to kinati mare-u uwaimi me-u uwaimi puguni, ");
INSERT INTO for_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","a'ya'ma kina abite tabera pami pumagini: We, a'ya'waemaenaba aogiyena puntana, agekuninta kinake, mi'mi'ma'ma kinake aogi puwaitaye, untawe. ");
INSERT INTO for_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pigoya, pi ntaga waya'wa uwoma aki puntawe. Aki pumagini, nanintawaipa nawaegasuguna, Isu abagi kina'waka kega'e yogini kanauguna maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Ma kina naege kakaga yaga miyepa, ibanto naninta i'miyega nantara puwaitauwe. ");
INSERT INTO for_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ka'isa e'ero marisa kanata kina kampa naninta iminta wa'eri igarubakubopa ke'i iyonanta puma iyegukiye, untiye. ");
INSERT INTO for_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Piya yogini, abagi kinamiba: Mapa ka'me mpariwa, uwoma kina naninta imikenaba aetasabaya maema imukunema, abigantawe. ");
INSERT INTO for_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Piyama abigauguna: Paretiba ayaki urite kanawema, Isu ibigantiye. Ibigaogini: Tonaentisa tara umaema waintiye, untawe. ");
INSERT INTO for_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Piya yuguna, A'ya'ma kina mara'miyiyo, yogini, mara'miyuguna, kana tonaentisa tara umaema paretiba mae u'ma, Kotiti a'mu potama, apako puma abagi kinawaka: Maema imiyo, yogini, pabi yomesa puma maete nasima, a'ya'ma kina imintawe. ");
INSERT INTO for_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aibuguna to inoyanta taranto waintogana, pike maema a'mu potama imimagina: Maete wama imiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Piya yogini, imuguni maema nauguna iga'e pantiye. Pi kana kinapa 4,000 kina'mi nantawe. Pigoya igeba nagate, ka'isa arita ataumepa, abagi kina'mi nasima maema tonaentisa tara umaema ku iragintawe. Piya puguna, Isu a'ya'ma kinapa igarubantana, ");
INSERT INTO for_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","karu'ena abagi kina'wake wanipisa karebi mima, Tamanuta mari wantawe. ");
INSERT INTO for_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Umintuguni, ka'isa Parasi kina aeti kanamagini tonarona kamana uwa abigantini: Kaeba mantarisa awame'ena purayakega, agakubompepa Kotiba a'mu pugataye ukune, untawe. ");
INSERT INTO for_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Piya yuguna, Isu antara puma aemu maema maya uwaimintiye: Nanagabaya ibasa kina'miba: Awame'enaba tayako, yewe. We, taga kauwe. Kanaenaba naeba matasa kinapa kampa tiyakikuwe, uwaimitegina, ");
INSERT INTO for_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","itate wanipisa karebi asumima maroteri wantiye. ");
INSERT INTO for_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Waomepa abagi kina'miba nanintaba igegu'a puguna ka'anto wanipisa karebi waintogana, ");
INSERT INTO for_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Isu: Aogima napiyiyo, uwaimintana: Paretibi yisiti atagana anosamisa puma, kiya yagara Erotibe Parasi kina'miba ata kamana'wai anosasanaga kabiyiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Uwaimogini: Nanawebaya iyema, abagi kina'miba napimagini: Pareti tabe pukenaena kaite, tagegu'a puma kanaompekabaya napimaiye, untawe. ");
INSERT INTO for_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Piya yuguna, Isu abitegina mayama to ibigantiye: Nanagabaya pareti kampa waintemika yewe. Tige ibaba esegiyenanepa kampa agantawo. Kampa aogima napiyewo. ");
INSERT INTO for_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tigeba tiyoba waintiye. Kampa agawo. Tigeba tigeba waintiye. Kampa abewo. A'ya'waemaenagaba tigegu'a pewo. ");
INSERT INTO for_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nayaka'mu pareti apako puma, 5,000 kina imuwagini nagate, atunkapa ayaki ku iragintawema, ibigaogini: Nagisarisa tara tumpaemawe omintawe. ");
INSERT INTO for_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Piya omuguna, Isuba: Pigoya tonaentisa tara umaema pareti apako puma, 4,000 kina imuwagini nagate, atunkapa ayaki ku iragintawema, ibigaogini: Tonaentisa tara umaema kune, untawe. ");
INSERT INTO for_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Aiyuguna: Pigoya ibanto agowapa kampa napiyewoma, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Pigoya, igeba Petisaira kumati waumepa, ka'isa kina'mi aorikaenta yagara Isuti ababute kanamagini: Auta aukaya poma, abigantawe. ");
INSERT INTO for_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Piyama abigauguna, Isu kana aorikaenta yagara ayakana urite, kumatasa abe'i uwa mari wamagina, aobi kaisa potama, ayapa aora araku'ma: Ago aganoma abigantiye. ");
INSERT INTO for_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Abigaogana agategina: Wasana agaopa yawama nasisu piye untiye. ");
INSERT INTO for_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Piya yogana, Isuba aora to aya urogana aoba apina'ma agaogana ata waogana, a'ya'waemaenaba aogima agantiye. ");
INSERT INTO for_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Agaogana Isu: To ma kumatiba a-nkwamagina, wa'egati wao, omintiye. ");
INSERT INTO for_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Piya omite, Isuge abagi kina'wake Sisariya Piripai kumati wama, ke'i abagi kina'waka: Naekaba kebayawe yewema ibigaogini, ");
INSERT INTO for_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","igeba maya omintawe: Ka'isa kina'miba Yoni wani pai'itanti ntagarawe yegini, ka'isamiba Iraiyawe yegini, to ka'isamiba poropete yagarabayawe yewe, untawe. ");
INSERT INTO for_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pigoya tigeba naekaba kewema napiyewema ibigaogini: Kaeba Koti utaratanti ntagara Karaisitigawema, Pita omintiye. ");
INSERT INTO for_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Omogana: Pigoya naekaba wasanamipa mayaba a-nkuwaimiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Pigoya, Isu abagi kina'wampi kamana'wapa agobima maya uwaimintiye: Wasanama Ntagaranaga tabe kuntaenabi mpikuwe. Monota kabiyume kina'mige, mono kiya kina'mige, mono tisa kina'mige naepa uwa natakibewe. Pigoya, asa wasanami naeguyigi, kakaga yaga pu'ma mintakana asinatakiye, piyama pagusama untiye. ");
INSERT INTO for_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Piya yogana Pita abiwa ababurite wama kabi'magina: Pi kamanapa a-so, omogana, ");
INSERT INTO for_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Isu a'wae pumagina abagi kina'wa igate, to Pitati a'wae puma maya omintiye: Satanigawa, kaeba natate wagaso. Napiyenagapa Kotintaba kampa maeyane. Uwa wasanamanta maeyane omintiye. ");
INSERT INTO for_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Piya omitegina, Isu abagi kina'wakaba a'ya'ma to kinakabe: Mata'i kanaiyo, yogini, kanauguna maya kamana uwaimintiye: Ka'waina naegarakibipa, kae'enaenagapa atate naegaragana, wasanami igobi pugatakibikaba a-kaekuru puma maripogapa aesaga'uritegina naegarao omukuwe, uwaimintana: ");
INSERT INTO for_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pigoya, ka'waina mikenaenawaka owe yekanaba, a'yugu potakiye. Naeka aogi kamana'neka mikenaenawaka a'a-o yekanaba aboramikiye. To ka'waina ae'wa nkaguka napi napi pikibipa uwa purikiye. ");
INSERT INTO for_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pigoya, ka'waina mabi a'ya'waemaena maemagina agu'amankapa kaiyekanaba, aya pikiye, a. ");
INSERT INTO for_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Agupa ayamabaya to kakema ika pekana kanarasakiye. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Pigoya, ibasa yagaba wasanamiba Kotipa atate aguntaena pewe. Piya pekana, wasanama ibaba naeke kamananekega ani pikibipa, toganaba nabanempa nke'wasaena yaga enisore kinake tumukubopa, Wasanama Ntagaranaga, pi naeka ani pikibi kinapa uwa atakuwe untiye. ");
INSERT INTO for_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Piya untana to maya untiye: Tigeba abiyo. Ka'isa mata miye kinapa maru Koti esegima kabima mintintana agakibepa, aintiba purikibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pigoya, tonaentisa ka umaema yaga, Isuba Pitana, Yemisina, Yonina suma, ibiwai ibabute e'ero nkamuti asu mintogini, igeba agaumepa aupa to au maeyogana, ");
INSERT INTO for_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","autasaenawapa wae kanta puma agasiyaena puma e'wasa puwantiye. Piya mampabisa kina'ma kai wasimi pekanaba kampa piyaba pikiye. ");
INSERT INTO for_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Piya pogini Iraiyaga Mosesege aborama, Isuge kamana yuguni, pi kakaga abagi kina'miba agate, ");
INSERT INTO for_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","tabera iyekuru puma, Pita kampa aogima napinta Isupa uwa maya omintiye: Kiya yagarama-o, taeba aogima maba miyompeka, kakaga nama kikune. Kapa kae'enawa, to kapa Mosesentawa, to kapa Iraiyantawa sumagi, kikune, untiye. ");
INSERT INTO for_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Piya yogana, ibina pabita aborama amankama aerarikaeyogana, ibinapisa maya kamana tumintiye: Mapa nae nabugai ntagaranena, ae kamana abiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Piya yogini igeba to karu'ena mae'aebuma agaumepa, to kinapa kampa mintuguna, Isu abiwa igege mintantiye. ");
INSERT INTO for_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Aibogini, igeba amutisapa atate tumuguna, ke'i Isu maya uwaimintiye: Ibanto agantanagaba wasanaba a-nkuwaimiyo. Wasanama Ntagara naepa pu'wakubotisa asinatakibipa kanarana uwaimiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Piya yogini, pabi yomesa pumagini kampa wasanaba uwaimintini, igewai mare-u me-u puma: Ayagabaya pu'wakubotisa asinatakiyeba iye, untawe. ");
INSERT INTO for_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Piya untini Isu mayama abigantawe: Mono tisa kina'miba: Nanagabaya Iraiya maru kanakiyeba yewema, abigauguna, ");
INSERT INTO for_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","aeba maya uwaimintiye: Taga kaewe. Iraiya maru kanama a'ya'waemaena aogi puwaitakiye. Pigoya nanagabaya mono isapipa: Wasanama Ntagaraga ata potakenaenabe uwa atakenaenabe waikiye untiye. ");
INSERT INTO for_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Piya, naeba urimuwe: Iraiya ago kanaogana, esapinti aekaba kaemarantisa puma, wasanamiba napima ata potantawe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Pigoya, igeba to abagi kinati tumima, tumpa agaumepa uwoma kina aki puma mintuguni, ka'isa mono tisa kinake abagi kinake mima esegi kamana uma miyuguni, ");
INSERT INTO for_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","pi aki puntume kina'miba Isu agate pami puma, aeti wamagini: Aya pene, untawe. ");
INSERT INTO for_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yuguna Isu abagi kina'waka: Esegi kamanapa igege nanawebaya yewema ibigantiye. ");
INSERT INTO for_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ibigaogana, ka yagara wasana ikapinti mintometisa maya omintiye: Tisa yagarama-o, yagaranepa ababute kaeti kanauwe. Piya, yagaranepa ke kina antabaipinti mintegina, kamana kampa yegina, ");
INSERT INTO for_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","kana ke kina'ma ata potama, apasanakasagina mabi tumpa aeguyegina, akagawa tuwaruwa puma awara upababuma tagagaba'wagi, kabagi kinaka: Kana ke agarubaiyo, yopa, kampa pewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Aiyogana Isu maya uwaimintiye: We, tigeba kampa tigupa aogi pe kina mintawa, ayaki yaga tigegeba mikuwe. Ayaki yagabaya kamana'nepa kampa abikibewe. Pigoya, naeti ababute kanaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Piya yogini aeti ababute wantawe. Ababute wauguna kana ke kina'ma Isu agate, kana yagaranto aeguma aebasana kasogana, mabi tumpa wareware pogana, awamupintisa akagawe irintiye. ");
INSERT INTO for_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Aibogana Isu kana abawampapa: Ayaki yaga kanaenaba abuntinema, abigantiye. ");
INSERT INTO for_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Piya yogana aeba maya untiye: Uwoma ntaga aegukena pumagina, yakupipe wanipipe aesagayuma mae maebiye. Tasiyo'maekena napintanapa kantara purasitama tasiyo'maeyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Piya yogana Isuba: Kae napintana unamempeno. We, napiyenaga naeti atakibempepa, a'ya'maenaba Koti aogima kao'maekiye, omintiye. ");
INSERT INTO for_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Omogana, karu'ena kana yagarantoma nkabawampa kega'e uma: Naeba napiyenanepa uwaenanto kaeti atauwa, nao'maeyo untiye. ");
INSERT INTO for_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Piya yogini, uwoma kina Isu nkagora ampa aki puma, agakena puguna igate, Isu ke kinapa maya esegima omintiye: Kaeba agebe awamupe akumpa'ma miyempe ke kinakawa, kana yagaranto atate iro'ma wagasimagina, toba antabaipintiba a-kanaoma, nae ugamuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Piya yogana, kana ke kina'ma agasiya kega'e uma, kana yagarantoba aeguyogana, aukomentanaga maeti tagaga pa'waogana, atate iro'wantiye. Iro'waogana kana yagaranto pu'wasu puwaogini, uwoma kina'miba: Ago pu'wayema, napintawe. ");
INSERT INTO for_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pigoya, Isu yagarantoma nkayata u'ma asitakena ao'maeyogana asima mintantiye. ");
INSERT INTO for_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aibogana Isu namapinti iyogini, abagi kina'miba ibiwai aeti wama: Nanagabaya taeba ke kinapa kampa agarubaunema, abigantawe. ");
INSERT INTO for_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Abigauguna: Kana ke kina agarubakenaba uwaba kampaye. Nunamurasa ka agarubakenaenawe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Pigoya, pi kuma atategini Karariya mari wama, Isu: Nabagi kina ago kamana uwaimikena pekini, a'yugu uwa kina'mi nagate menkaki pusanagawema, napimagina, ibiri ibabute wama maya uwaimintiye: Wasanama Ntagaranagana, nababuma wasana imiginiba naeguyigi, pu'wakubopa togana kakaga yagaba asima mikuwe untiye. ");
INSERT INTO for_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Piya yogini, igeba yome kamanapa kampa aogima napintini, iyekuru puma kampa pikaba abigantawe. ");
INSERT INTO for_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pigoya, igeba Kapaniyamu kumati wama, namapinti ima Isu abagi kina'waka: Ke'iba nanawe yewema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ibigaogini: Taepisa kebaya maru kiya yagaraba miyema, ke'i marebiga mebiga puma napimagini, iyekuru puma kamanapa kampa omintawe. ");
INSERT INTO for_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Kampa omuguna, Isu mara'mima nagisarisa tara tumpaema abagi kinaka: Kanaiyo, yogini, kanauguna maya uwaimintiye: Wasanama kiya yagara misanaga abugakanaba: Pigo naeba uwa yagara mima, a'ya'ma kina'mi kayokaya yagara mikuwema napikibipa, pipa aogiyenawe, untiye. ");
INSERT INTO for_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Piya untana, ka yagaranto ababuma igora atama, ayatasa aepa u'ma maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Wasanama naeka napima pabiya yagaranto ababipa, naepa agupi nababiye. Pigoya naepa nababipa, nae unatanta yagarage agupi ababiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Piya yogana Yoni maya omintiye: Tisa yagaragama-o, ka yagarama taepa kampa taegaranta kaeka napima ke kina igarubagi agate: Uwa miyo omunema, untawe. ");
INSERT INTO for_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Piya yuguna Isu maya untiye: Tigeba uwa miyoba, a-siyo. Piya, wasanama naeka napima esegi yuga pikibipa, toganaba naekaba ata kasaba kampa karu'enaba ukiye. ");
INSERT INTO for_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Piya, wasanama yogare kampa aguya aikibi'napa tao'maeye. ");
INSERT INTO for_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pigoya abiyo. Wasanama: Karaisiti aegaranta kina mintawema, napima: Ma nkwani mpaema naiyo uma timikibipa, pi ntugabisa Koti taganaba ikantana amikiye, untiye. ");
INSERT INTO for_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Pigoya, Isu to kamana maya untiye: Piya maya yagaranto naegarakana, ka'waina ayakekana kamparagaena pukibemipa, kana ayakikibi ntagara araku'ma tabe yabantama ana'mubi ubu'atama, tabe wanipi apasanakasasinta: Pipa kanara pewe, yesine. ");
INSERT INTO for_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Pigoya, kayankama kamparagaena pikena pekanapa arisa'ma maebugaso. Piya, ka kaya kampa wainta yagara mintana miyaba kumati irosakibempepa, pipa kanarane. A'yugu kaya tararasa aguntaena pekanaba, maebugatakana kampa tu'makena yakupinti tumikibene. ");
INSERT INTO for_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","(Piya, pi kumatisa kabagina'ma iba nakanaba kampa ita wakana, tabatikenaena kampa tu'ma wakiye.) ");
INSERT INTO for_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pigoya, kagisawama kamparagaena pikena pekanapa maebugaso. Piya, ka kagisa kampa wainta yagara mima miyaba kumati irosakibempepa, pipa kanarane. A'yugu kagisa tararasa aguntaena pekanaba, kaepa a'abibinti maebugatakiye. ");
INSERT INTO for_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","(Piya, pi kumatisa kabagina'ma iba nakanaba kampa ita wakana, tabatikenaena kampa tu'ma wakiye.) ");
INSERT INTO for_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Pigoya, kaowama agama kamparagaena pikena pekanapa pi'ma maebugaso. Piya, togana ka kao wainta yagara mintana Koti kabiratakena kumati ikibempepa, pipa kanarane. A'yugu kao tararasa aguntaena pekanaba, kaepa a'abibinti maebugatakiye. ");
INSERT INTO for_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Piya, pi kumatisa kabagina'ma iba nakanaba kampa ita wakana, tabatikenaena kampa tu'ma wakiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Piya untana to maya untiye: Pigoya wasanama nanintabi kayo atama nagina, aogi igi pemisa puma, a'ya'ma kinapa yakutasa aogi puwaitakiye. ");
INSERT INTO for_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Piya, kayoba aogi igaenawe. Piya, i'nisama kasigabekapa, aya pekana to kake asabama iga pikiye. Pipa kampaye. Pigoya wasanama nanintabi kayo atakena aogima pemisa puma, to kina'mige aogima miyiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Pigoya, Isu pi mpa atate Yutiya mari wama Yontani wani mparoteri ura'ema waogini, to pumesa puma uwoma kina'mi aeti kana puguna, to yomesa puma kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Kamana uwaimogini, ka'isa Parasi kina'mi aeti irosa'ma amiyo potakena puma maya uma abigantawe: Ago kamanatepinti wasanama waya kaikenaenaba tagapayawema, uramoma abigantawe. ");
INSERT INTO for_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Piyama abigauguna Isu a'wae puma: Aya kamana Mosese urimintiyema, to ige ibigantiye. ");
INSERT INTO for_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ibigaogini igeba maya untawe: Waya kaikena puntiripa, esa amima otaiyoma, Mosese untiyema, omintawe. ");
INSERT INTO for_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Piyama omuguna Isu maya uwaimintiye: Tigeba monoka kampa karu'ena abima tige akuneka, Mosese pi uraminti kamana kaentine. ");
INSERT INTO for_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Piya, pai Koti maru a'ya'waemaena aborantanaba, wabe wayape kaga aborawaisitantine. ");
INSERT INTO for_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Pika napima, wamaba ano abapa isitate waya'wampati atokaema isigeba ka kina kanta puma miyese, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Piya, isigeba taraba kampa punta, ka'ena puma miyese. ");
INSERT INTO for_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pigoya, Koti atokae isitantika, wasanaba a-nkatara isitano, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Piya uwaimite namapinti waogini, abagi kina'mi pi kamana'ama nkagowaka abigauguna, ");
INSERT INTO for_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","maya uwaimintiye: Ka'waina waya'wampaba kaite to wae maekibipa, marusa wae'wa ataena potama kumiyenaba pikiye. ");
INSERT INTO for_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Piya puma, waya'ma marusa wawa agora atate, to wa maekibipa, awae ataena potakiye, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Pigoya, ka'isa kina'mi yakarantonto Isuti ibaburite: Ita ukaya penema napima, ibabute kanauguni, abagi kina'miba pi kinaka imo kasa untawe. ");
INSERT INTO for_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Piya yuguna, Isu pi kamana abite kampa a'mu puntana, abagi kina'waka maya uwaimintiye: Tigeba itaigini, yakarantonto igeba naeti kanaiyo. Tigeba a-nkakunkitaiyo. Piya miye kina'mikaba Koti kabiratakenaenaba utawaitantine. ");
INSERT INTO for_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pigoya tigeba urimikenaba abiyo. Wasanama kampa yagaranto miyisa puma Koti aegarakibipa, Kotiba kana kinatapa kampa kabima mikiye, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Piya untana, yakarantonto ibabuma aki puwaitama, ita ukaya puma: Aogima miyiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Pigoya, Isu asima wakena pogana, ka yagara karu'ena kanama agisabi ampa arakabima mima: Kaeba aogi tisa yagaragawa, naeba ayabaya pukubotisa e'wasaena maekuwema abigantiye. ");
INSERT INTO for_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Abigaogana Isu maya omintiye: We, nanagabaya: Aogi yagaragawema unamene. Ka Koti abiwa aogi yagaraba mintiya, toba kampaye. ");
INSERT INTO for_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Pigoya, nayatara'mu ago kamana mayama ago abintana: Wasanaba a-nkaeguyoma, kumiyenaba a-poma, kuntanaba a-poma, kampari kamanapa to wainapa a-sotaoma, to kina'ma ntanagaba a-kaukaba poma, kano kaba kamana wasiyo. Pipa ago abintane, omintiye. ");
INSERT INTO for_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Omogana: Tisa yagarama-o, naeba yagaranto mitatopa pi kamana abimagi, a'ya'ma yagaba pabiya putone, kana yagaramaba omintiye. ");
INSERT INTO for_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Piyama omogana Isuba: Nabugampe ntagaragawema napintana, mayama omintiye: Ka'enaba kampa aogima napiyene. Kaeba wama kotakapa umaema to kinati imima yaba maema, kusi kinapa imo. Piya pikibempepa mantabinti uwomantanaga waikiye. Pabi ugamosa pugaite ampa naegarao, omintiye. ");
INSERT INTO for_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Piya omogana abigate, uwoma kutankaka napima, antara puma amo pute wantiye. ");
INSERT INTO for_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Pigoya, Isu abagi kina'wa igate maya uwaimintiye: Ayamabaya tabe kutantaga kinapa Koti kumati ikiye, a, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Piya uwaimogini, pi kamanaka abagi kina'miba abite pami puguna, Isu to maya uwaimintiye: We, ma ntakaraki'nuntepa abiyo. Wasanama Koti kabiratakena kumati ikenaba esegiyenawe. ");
INSERT INTO for_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pigoya, kamoro yagamaba na'ama nkagepinti uma pasikenaba pipa esegiyenawe. Piya, tabe kutantaga kinapa Koti kabiratakena kumati ikenaba pipa to awameta, tabe kuntaenawe, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Piya uwaimogini, pi kamanaka abagi kina'miba tabera pami pumagini, mare-u me-u puma: Pigoya kebaya ao'maeyakana ikiyema napintawe. ");
INSERT INTO for_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Piyama napiyuguna, Isu igate maya uwaimintiye: Pika wasanama kunta abekana kampa pikenaenawe. Pigoya Kotipa kampa kuntaba abegina a'ya'waemaena pikenaenaba agantiye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Piya uwaimogana, Pita Isuka: Abo. Taeba a'ya'waemaenaba atate ago kaegaraune, omikena pogana, ");
INSERT INTO for_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Isu a'ya'ma abagi kinaka maya uwaimintiye: Owe tagane. Tigeba abiyo. Wasanama nae aogi kamana napima naeka, mawa, yogawa, anonanto aganto a'nanto ano aba yagarawa, atate naegarakibipa, ");
INSERT INTO for_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ibasa yagaba aogima mima, uwoma to namape yogabe maeyakini, uwoma to anonantoge agantoge a'nantoge anoge yagarawake aege ampiyigini, to kina'miba aepa ata potaigina, agogo yagaba aeba e'wasa yagara asu mikiye. ");
INSERT INTO for_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pigoya, pi ntaga ka'isa kiya kinapa kayokaya kina miyigini, kayokaya kinapa kiya kina mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pigoya, Isuge aokinake Yerusaremi kumati ikena ki'i imagina, Isuba paitama waogini, abagi kina'miba aka'i wama pami puguni, igege waume kina'miba iyekuru puntawe. Aibuguna, Isu nagisarisa tara tumpaema abagi kina'waka: Ka auka'i kanaiyo, yogini, kanauguna aeti ka'isaena aborakibi puma kamanapa ");
INSERT INTO for_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","maya uwaimintiye: Tigeba abiyo. Yerusaremi kumati iyekini, Wasanama Ntagara naepa naraku'ma, mono kiya kinake mono tisa kinake imigini, kamana unatama: Aeguyiyo ukibewe. Piya umagini, naepa namu'isa kina imigini, ");
INSERT INTO for_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","karana natamagini, kaisa punatama, iga'na kasu maema naebaru'magini naeguyigi pu'wakuwe. Aibumagi togana kakaga yagaba asima mikuwe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Aiyogini, Yemisige Yonige isigeba Sepeti ntagara taraginisi, Isuti kanamaginisi ampa mayama abigantase: Tisa yagarama-o, tae kabiratakenaenaga kabigakena puse, yusuguna: ");
INSERT INTO for_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ayama kabirisitakenaenaga tisibiyema, isibigaoginisi, ");
INSERT INTO for_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","maya omintase: Kaeba togana aogi kumakati mara'mima kabima mikenaenara mikibempepa, tasigeba kaege mima, ka'waina kayatakantisa auka'i miyekana, ka'waina kayake'masisa auka'i mima, kiya kina misanaga tasibiye, untase. ");
INSERT INTO for_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Aiyusuguna, Isu auki naki pukenaenaga meto kamana maya uwaisimintiye: Tisigeba nabigakenaenagaba kampa aogimaba napiyese. Nae nantara'enabi tisigeba kanara pasikibeso. Nae pai'natakibintanaba tisigepa paitisitasiyoma, isibigantiye. ");
INSERT INTO for_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Piyama isibigaoginisi: Owe, piya purasitakibepa kanarane, omintase. Piya omusuguna, Isu maya uwaisimintiye: Pigoya, nae nantara'enabi pasikibese. Nae pai'natakibintanaba tisigepa paitisitakiye. ");
INSERT INTO for_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pigoya, nae naya tararari mikena kinakaba kampa nae napiyokana, Koti ae abintana wasanaba ibabuma kana naya tararariba itakiye, uwaisimintiye. ");
INSERT INTO for_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Uwaisimogini, to pi nayatara'mu abagi kina'miba pi kamana abite, Yemisike Yonikegaba ka isibirauguna, ");
INSERT INTO for_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Isu kega'e uma, a'ya'ma aki puwaitama maya uwaimintiye: Tigeba ago abintawe. Wasanama uwa kinaka kiya mima pitasa kinata: Kabiyo yeginaba, aeba esegima kabiye. Kiya yagarama: Piya piyo yintanaba pewe. ");
INSERT INTO for_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pigoya, tigeba kana kiyaenaba kampa piyaba pumagiri, ka yagarama kiya mikena pipa, aokina'mi kayokaya'enaba pikiye. ");
INSERT INTO for_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pigoya tigeri ntapima: Nae kiya yagara mikuwema napikibepa, a'ya'ma to kina'mi kayokaya'enaba po. ");
INSERT INTO for_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Piya, Wasanama Ntagara naeba tige nae kayokaya'ena punataiyomaba kampa tumintone. Naeba tige kayokaya pukenaga tumpa pu'ma, uwoma kina ika puma a'watitakena tumintone, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Pigoya, igeba Yeriko kumati asu migategini, Isuge abagi kina'wake to uwoma kinape pitasa ikena puguna, ka aorika yagara, agewapa Patimesi, Timeyosi ntagara keta mara'mintometisa: Ma na namiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Piya uma mintogini igeba: Isu Nasareti kumatisa yagara iye, yuguna abite, aeba Isuka kega'e uma maya untiye: Isugaba, Tebiti ntagaragawa, naeka napima kantara punatao, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Piya yogini uwoma kina'mi: Paka puma miyo, omuguna to taberasa kega'e uma: Tebiti ntagaragawa, naeka napima kantara punatao, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Piya yogana, Isu pabita mima: Mati kanao omiyo, untiye. Yogini, igeba kana aorika yagaraga: Ka'mu puma asiyo. Ago kaeka kega'e iyema, omintawe. ");
INSERT INTO for_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Omuguna, kabiwa ka'urintometisa akubugaite, asima Isu asu aepantiye. ");
INSERT INTO for_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Aibogana: Kaepa nana pugatasanaga kabiyema, Isu abigaogana, kana aorika yagaramaba maya omintiye: Tisa yagaragawa, nao agasanaga nabugaye, untiye. ");
INSERT INTO for_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Piya yogana Isuba: Naeka aogima napiyekana, ago kata wagina uwa wao, Isu omintiye. Omogana, ago aogamagina pabi ki'i Isu aegarantiye. ");
INSERT INTO for_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Pigoya, Yerusaremi agora ikena puntini, Oribesi amu amentanti Petipaesi kumape Petani kumape waintogana, Isu abagi kina tara paitama isigaruba'ma, ");
INSERT INTO for_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","maya uwaisimintiye: Mo kumati tumima, tonki aikeri kampa wasanamiba nasinta ubu'atama mintigirisi, tumikibemepa pabigo aora tumpa agamagirisi, akariyoba'urite iyiso. ");
INSERT INTO for_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Piya pisigini, wasanami: Nanaga pese yigirisiba, maya uwaimiso: Tabe yagarama yegira maeyomekana, pabigo arontaganto me timikiye uwaimiso, untiye. ");
INSERT INTO for_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Piya yoginisi tumima tumpa agausumepa, kabe agora keta yara tonki aikeriba ubu'atama mintugunisi, wama uma akariyobantase. ");
INSERT INTO for_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Piya pusugana, kana pita mintume kinamiba: Nanaga yaga awaroba akariyobase, untawe. ");
INSERT INTO for_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Piya yugunisi, pabi uwaisimomesa puma uwaimusuguni: Kanarana, ababute waiso untawe. ");
INSERT INTO for_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Piya yugunisi, isigeba kana tonki aikeriba ababute Isuti imaginisi, isitasaenarasa kana yaga akabata amapa agutausuguna, pi abobora Isu mara'mintantiye. ");
INSERT INTO for_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Piya pogini, uwoma kina'miba itasaena akubuma ke'i aguyuguni, to ka'isa kina'miba yogarisa ya a'ye aegayuma ke'i aguyuguna, pi'na nkabobori wantiye. ");
INSERT INTO for_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Waogini, aori aka'i ogasi ankagasi puta wantini, taberasa maya untawe: We, Wa'egawama nkawamuta taeti kanaika ta'mu potano. ");
INSERT INTO for_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tayabama Tebiti kabima mintantisa puma kabikena piya, Kotika ta'mu potano. We, Inatisa Yagaraga ta'mu potano, untawe. ");
INSERT INTO for_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Piya yuguna, Isu Yerusaremi kumati ima, tabe mono namapinti asu pai'ma, pipintisaena a'ya'waemaena asu agaogana, ase ikena pogana, irosa'ma Petani kumati nagisarisa tara tumpaema kinake tumintiye. ");
INSERT INTO for_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tunkwaimarategina, Petani kumatasa ke'i iyogana, aga'ena abuntiye. ");
INSERT INTO for_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aibogana mogaomepa a'ye uwaena wainta ya, agewapa piki ya agate tumima tumpa aka aguyosagaomepa, kampa yoga yagawa aboraogana, apa kampa aentiye. Kampa aentogana a'yenkamana abi agate, ");
INSERT INTO for_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","pi ntaga maya omintiye: Toba apa a-nkaeyagini, wasanamiba to kampa asigi'ma nakibewe, omogini, abagi kina'miba pi kamanapa abintawe. ");
INSERT INTO for_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Pigoya igeba Yerusaremi kumati asu mima, Isuba tabe mono namapinti iyumepa, pita'i ikantana puma mintuguna igarubantana, mone antota ankami ankami pume kina'mi ntabaebe kabara ataume kina'mi ntabaebe apasana'ma asunukaentana, ");
INSERT INTO for_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","itasaena pi mpono kuma akapipa maete wakenaga akumpa'ma mintantiye. ");
INSERT INTO for_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Piya pumagina aeba maya esegima uwaimintiye: Mono isa'amaba maya iye: Mono namantepa a'ya'ma kina'mi nunamu ukena namantana peno, untiye. We, tigeba piya pegana kuntana pe kina'mi ntamantana piye, uma igarubantiye. ");
INSERT INTO for_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Uwaimogini, tabe mono kiye kina'mibe mono tisa kina'mibe kana pomentanaga abite, Isu aeguyigina purikibi kamana untawe. Piya, a'ya'ma kina'miba Isu kamana abite pami puma i'mu puguni, kana mono kiye kina'miba pika napima, Isuka iyekuru puntawe. ");
INSERT INTO for_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Aibuguna ase ikena pogini, Isuge abagi kina'wake pi kumatasaba atate wantawe. ");
INSERT INTO for_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wama waimarate, marogini abayara ke'i kanantini, kana piki ya agaumepa aubu yaga asawantiye. ");
INSERT INTO for_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Asa waogana, Pita wama uma agate ai kagi yome kamanaka napima, Isuka maya omintiye: Tisa yagarama-o, agao. Kaeba kamana kana piki ya omitampe ntaba ago asa waye, untiye. ");
INSERT INTO for_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Piya yogana Isu maya uwaimintiye: Pika napiyiyo. Tigeba Kotiti tigu atantiri, ");
INSERT INTO for_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","kampa tonaronaga napinta, ikibe kamanaka piya pikiyema napikibepa, piya pikiye. Piya, maro nkamu'amaka: Tigaba'ma wanipinti tumo yesinta, pabi yesa pesine. ");
INSERT INTO for_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Pigoya pika urimuwe. Tigeba nunamu uma abigantiripa, pikaba ago abima pikiyema napiyiyo. Piyama napima ikibepa, pintanaba ago tigeka pikiye. ");
INSERT INTO for_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Pigoya, tigeba asima nunamu untiripa, to kinaka timo'ena pikenaenaba kasiyo. Piyama kaikibepa, mantarisa tibarimpaba aibo'enaripa maerigaikiye. ");
INSERT INTO for_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Piya, tigeba wasanami nkaibo'enawaipa kampa mae igasiginaba, mantarisa tibarimpaba aibo'enaripa pabiyama kaga kampa maerigaikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Pigoya, igeba to ima Yerusaremi kumati asu mima, Isu tabe mono namapinti nasogini, mono kiya kinamige tisa kina'mige kabiyume kina'mige aeti ima, ");
INSERT INTO for_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","mayama abigantawe: Nanaga kaeba mantanaba pene. Ke po yemintana pene, untawe. ");
INSERT INTO for_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Piya yuguna Isu maya uwaimintiye: Pigoya naeba ka'enaga tibigakiri, ukubontanaga aogima unamikibepa, ke po yemintana pene ye kamanapa urimukuwe. ");
INSERT INTO for_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Piya, tigeba unamiyo. Yonikaba wani paititanemaba ke omintiye. Mantarisaenabera wasanamintanawema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Piyama ibigaogini, igeba mayama napintawe: Nanawe ukenema, mare ibiga me ibiga pumagini, Koti po omintiye yekanaba, aeba: Nanagabaya ae kamanapa kampa abewe ikiye. ");
INSERT INTO for_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Piya wasanami po omintawe yekanaba... Pigoya a'ya'ma kina'miba Yonikaba: Koti kamana unta yagarabayawe yepa, a'ya'ma kinaka mono kina'mi iyekuru puntawe. ");
INSERT INTO for_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Iyekuru puma: Taeba kampa abintune, omintawe. Isupa piyama omuguna, aeba maya untiye: Pigoya naeba: Ke po yemintana pene ye kamanapa kampa urimukuwe, Isu uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Pigoya, Isu meto kamana maya uwaimintiye: Pigoya ka yagara waini yamanka maekena yuga puma'ma, kagisa aenkima kima'ma, yamanka aerakena koma ma'ma, kabima mikena namapa kima'ma, kabinataiyema to kina kana yugaba imogini kabima mintuguna, aeba to mari wagaintiye. ");
INSERT INTO for_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wagasometisa yamankapa agutayagana, ka yuga kina'waka: Wama yogara kabima miye kina'mitisa yamankatasa maekibe nkape'ena umaema mentamoma, agarubaogana wantiye. ");
INSERT INTO for_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wa-mepa, pi ntugara kabima mintume kina'miba kana yuga yagarawapa araku'ma aeguma aegumugasima, kampa ape'enaba aminta, auka agarubauguna wa'eri wantiye. ");
INSERT INTO for_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Waogana to ka yuga kina'wa agarubaogana waomepa, to pi ntagara araku'ma a'no aiyeye pumutama, ataena potantawe. ");
INSERT INTO for_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Piya puguna kana yogama nkabawampaba to yuga yagarawa agarubaogana waogini, araku'ma aegutauguna purintiye. Aibuguna, to igarubaogini waumepa, iyeguyuguni ka'isa purintawe. ");
INSERT INTO for_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Aibuguna agagate ka yagara mintomepa, ae'wa ntagara abugaome ntagara mintogana: Yagarane agarubakana wakiniba, ae awamu wasikibewema, napintiye. Piyama napima, agarubaogana waomepa, ");
INSERT INTO for_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","kana yogara kabima miyume kina'miba mare-u me-u puma maya untawe: Ma ntagaraba kana yogama abawampa ntagarawa kanaigi aeguyeno. Aegukubompepa kana yogaba tae'enaena puwakiye, untawe. ");
INSERT INTO for_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Piya utegini, kana yagarawapa araku'ma aegutama, wasirite yoga awamo kabubinti me maebugaintawe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Piya uwaimintana, to maya untiye: Pigoya kana yugama nkabawampa kanama ampikibipa aya pikiye, a. Tige ago abintawe. Kana yagara kanakibipa pi kinapa ampa iyegugasima, to kinaka: Kana yogarapa kabiyiyo, uwaimikiye, untiye. ");
INSERT INTO for_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Piya, naeka mono isapisa kamana maya waintipa kampa aisewo. Pipa ago abintawe: Nama kikena kina'miba ka ya ago kainta ntawama iba wa'ega ya asima waintiye, iye. ");
INSERT INTO for_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Pintanaba Wa'egawamaba ago pega, taeba agantompeka, ta'mu pune, untiye, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Uwaimogini, kana Yuta kiye kina'miba: Taeka ma amiyo kasaba iyema, napima arakurikena pumepa, pi a'ya'ma kinaka iyema'ma, Isu uwa atate wantawe. ");
INSERT INTO for_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pigoya, ka'isa Parasi kinake ka'isa Eroti nkaokinake: Isuti wamagiri uma tonarona kamana abigaiyo, untawe. Ata kasa urimikibayawema uwaimite igarubauguni, ");
INSERT INTO for_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","aeti kanamagini mayama abigantawe: Tisa yagaragawa, taeba ago kagaune. Kaeba taga ntagara mintane. Piya, ima tumima minta kinakaba kampa karu punta, esegiyenawaika kampa kaekuruba puma, Koti mpono'ama kipa kanara uramima kayakene. Pigoya, mono kina'mite taeba Aroma wa'ega yagara Sisa takisi mone aya pusune. Tae ago kamanapa ayabaya iya uramoma, omintawe. ");
INSERT INTO for_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Piyama omuguna, Isu meto kamana'wai abite maya uwaimintiye: Nanagabaya ataena punatakena pewe, untana: Pigoya, yabapa maete kanama nayakiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Piya yogini, igeba maete kanama amuguna: Amankape awa'enabe mapa kewema, ibigaogini igeba: Sisantawe, untawe. ");
INSERT INTO for_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Piya yuguna, Isu maya uwaimintiye: Pigo yewa, Sisantanaba Sisa amiyo. Piya, Kotintanaba Koti amiyo, yogini aekaba pami puntawe. ");
INSERT INTO for_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pigoya, ka'isa Sarusi kina'mi Isuti kanantawe. Pi kinapa wasana pu'watisaba kampa asikibewema napiyume kina'miba, ");
INSERT INTO for_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","igeba Isuti kanama maya uma abigantawe: Tisa yagarama-o, Mosese kana kamana ago taeka mayama kaema uramintiye: Wasanama anarimpa yagaraena kampa pekana kana yagara pu'wakibipa, to a'nantowampa kana abeya waepa maema aege mimaginisi, agantowampaka yagaraenaba pikibese uramintiye, untawe. Piya untini amiyo kamana mayama abigantawe: ");
INSERT INTO for_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pigoya, tonaentisa tara umaema aga'nantonto mintumepa igantowaimpa wayapa maentiye. Maema'ma kampa yagaraena punta pu'wantiye. ");
INSERT INTO for_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Aibogana, to ae aka'isama kana waepa maeyomepa, aege kampa yagaraena punta pu'wantiye. Piya pogana to pi'na nkaka'isama maeyomepa, aege uwa pu'waogini, ");
INSERT INTO for_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","to pi'na aka'isami pabiya puma maema pu'wantawe. Pigoya tonaentisa tara umaema aga'nantonto kana wae maema'ma, a'ya'ma kampa yagaraena punta pu'waewauguna, kana waepa ika'i purintiye. ");
INSERT INTO for_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pigoya, tonaentisa tara umaema kina'mi nkwaena, asikibi ntagaba ke kana waepa maekiyema abigantawe. ");
INSERT INTO for_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Piyama abigauguna Isu maya uwaimintiye: Tigeba kampa abintawe. Ayamabaya kampa napiyewe, a. Tigeba mono kamanape Koti nkesegiyenagabe kampa napima agantawe. ");
INSERT INTO for_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Piya, pu'wantatisa asiwaitakini, wa wayapa to kake kampa maekibewe. Igeba enisore miyesa puma asu mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Piya, pu'wantapisa asikena kamanapa urimukuwe. Tigeba Mosese kaemaranti nkisapipa yabi yaku takena kamanapa ago abintawe. Piya, yabi yaku taogana uma agakena waogana, pita Koti Mosese maya omintiye: Naeba Abara'amu, Aisaki, Yekobu, ige Koti mintuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pipa untika, aeba pu'wanta kina'nane. Aeba iyoganta kina'mi Koti mintiye. Piya, tigeba kampari'ma napiyewe, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Piya uwaimogana, ka mono tisa yagara ampima, Sarusi kina pi yume kamana abite: Aogi kamana iyema napite, Isuti kanama mayama abigantiye: Nana taga ago kamana'ama asugasimaba waiyema, abigantiye. ");
INSERT INTO for_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Piyama abigaogana Isu maya omintiye: Pi kana asugainta kamanapa mayama waintiye: Isureyo kinapa abiyo. Tae Tabe Yagara Koti abiwa tabe miyegina, ");
INSERT INTO for_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","pigoya a'ya'ma kagu kaumakape, napiyenagape, esegiyenagape, Wa'ega Kotigapa a'ya'ma amegana waiyeno. ");
INSERT INTO for_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Pigoya ma kamana'ama nkaka'isaba ka maya kamana waintiye: Kaegaka napima kabiyempesa puma, kaokinakaba kabiyeno. Pigoya, ma tara kamana yo kamana'amaba to ka'isa ago kamana'amapa asu igaintiye, omintiye. ");
INSERT INTO for_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Piya omogana, kana mono tisa yagaramaba maya omintiye: Tisa yagara-o, kanara sene. Yempe kamanapa taga kamanane. Pi yempepa Tabe Yagara abiwa Kotiba miyegina, to kotiba kampa mintawe. ");
INSERT INTO for_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Pigoya, pintanaba wasanama a'ya'ma agutasabe napiyenawatasabe esegiyenawatasabe Kotika abugagina, aewaka napiyisa puma agorasa kinakaba napiyipa, pipa tagane. Pigoya wasanama monoka yaga ababute wama, uma aeguma ina yakuta Kotiti kaema, tona a'muntana amipa pipa tagane. Pigoya pi tara yempe kamana abima wasanama aegaraipa, Kotiba aekaba abugaye, kana yagarama untiye. ");
INSERT INTO for_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Piya yogana, Isu yome kamana abite, nauka kamana yenema napima, maya omintiye: Pigoya, kaeba agaro Koti aogima aegarakibene, omogini, wasanami abite, iyekuru puma to kamanapa kampa abigantawe. ");
INSERT INTO for_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Pigoya, Isu tabe mono namapi kamana uwaimima mayama ibigantiye: Mono tisa kina'mi Koti utaratanta yagaramaba Tebiti ntakaraki'nu mikiye, yepa ayabayawe, untiye. ");
INSERT INTO for_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Piya, Tebitika Aogi Awamusa'ama nkawamuta maya untiye: Kotiba Tabe Yagaraneka: Kaeba nayatakanti ampintaga kama kinakapa kagisabi ibabuma aki penoma, untiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Piya untana: Tebiti utaratanta yagaraga: Tabe Yagaranene yemipa, pigoya yakaragi'nunkapa mikena piya ayamabayawema, Isu ibigantiye. Piya, mintume uwoma kina'miba abite Isuka i'mu puntawe. ");
INSERT INTO for_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","39","Pigoya, Isu uwaimintana maya untiye: Ka'isa mono tisa kina'mi e'ero kai igisari paibotate, wama maketi kumata nasegini, wasanamiba: Aogi yagarawe, uwaitasanaga ibugagini, mono namapi paitama marusa aogi yabaera misanagega ibugagini, taena pepa tabe yagara mima, piya po piya po usanaga ibugaye. Piya pesapa a-piyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Piya, pi kina'miba abeyawae'mantana paibumagini, uwomantanawa uwa maerintini, e'ero nunamu uwa ago'ena kasa yewe. Piya pekana igepa toganaba Kotiba tabera kamparaga puwaitakiye, untiye. ");
INSERT INTO for_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Pigoya, Isu tabe mono namapinti Kotiti yaba atakena kankabema nkagora mara'miyogini, wasanami yaba pipi atauguna agantiye. Piya pogini, uwoma yaba wainta kina'miba tabe yaba maema kankabebi menta puguna, ");
INSERT INTO for_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ka wae awaewampa pu'wanta wae'ma ampa tara uwaena yabankanto tara, piya wanisenikana, mempaebotantiye. ");
INSERT INTO for_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Piya pogana Isu abagi kina'waka kega'e yogini, ampa aki puguna maya uwaimintiye: Tagaka urimuwe. Ma kotanka kampa wainta abeya wae'ma atami ntabankama a'ya'ma kina'mi mono namapisa kankabebi ata ntabankamapa, ae asu igasima ataye. ");
INSERT INTO for_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pigoya, igeba tabe yabankai waintipisa ka'isa maema atawe. Aeba kampa kotankapa waintegina, pabi waintinkawa a'ya'waemaenawapa maema kasagina, naninta ika puma nakenaba kampa uwa ataye, untiye. ");
INSERT INTO for_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Pigoya, Isu tabe mono namapisa iro'ma waogana, ka abagi yagarama maya omintiye: Tisa yagarama-o, agao. Nauka tabe yabatasa ma aogi mono nama kintawe, agao, yogana, ");
INSERT INTO for_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Isu maya omintiye: Pigoya ma agampe tabe namapa kama kina irosa'ma akasagasuba kasaigina, ka yabankamaba to ka yabankama nkabobora ware'naigina nama tubo aborama waikiye, untiye. ");
INSERT INTO for_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Piya utegina, Isuba wama Oribesi amuta asu mara'mima, pi amutisa kana tabe mono nama mo agaogana, Pitage Yemisige Yonige Enturuge pabi ibinto aeti imagini, ");
INSERT INTO for_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","maya untawe: Kae uramempentanaba ayantaga aborakiye. Nanabaya kanaka agakana, a'ya'ma uramempentanaba agarontaga aborakiyema uramo, untawe. ");
INSERT INTO for_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Piya yuguna, Isu maya kamana agobima uwaimintiye: Tigeba napiyiyo. A'yugu wasanami kampari kamana'wai abisiwe. ");
INSERT INTO for_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Piya, uwoma kina irosa'ma nae nage umagini: Naeba Karaisiti nawe, uma, uwoma kina'mi nkigu'ama paibumagini kamparaga puwaitakibewe. ");
INSERT INTO for_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pigoya, ma'ena pewe kamana abintiripe, esiba kamana abitegiri, tiyekuruba a-puma: Kana a'ya piyeba, a-siyo. Pi mpa'ena maru pikibepa asa agogo yaga aborakiye. ");
INSERT INTO for_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Piya, maga maga kina'miba kamaena pigini, to ka'isa kina'miba to ka marisa kina uma iyeguyigini kamaena purite wagana pikibewe. Piya, to mari to mari imima tabera pekini, ka'isa kinapa naninta i'mikibewe. Pigoya, waya'ma yagaraena pikena pegina maru agobima aukemisa puma, kana ataenaba maru pikiye. ");
INSERT INTO for_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pigoya, tigeba aogima napiyiyo. Wasanami kanama ampa tiraku'ma kotiyena puritama, mono namapi kasotasa tiyegukibewe. Pigo tigeba naegaraka, kanisore kinatige tabe kinatige tibabute waigiripa, tigeba pi kinapa aogi kamana'nepa uwaimiyo. ");
INSERT INTO for_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pigoya, a'ya'ma kinapa aogi kamana'ne maru uwaimigasigina, toganaba agogo yagaba aborano. ");
INSERT INTO for_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Piya, tiraku'urite kotira wakena pigiripa, kana uwaimikubo kamanakaba: Ayabaya uwaimukunema, a-ntapiyiyo. Pi ntaga kamanatipa ikena kampa napikibewe. Aogi Awamusa'ama urimikibi kamana uwaimiyo. ");
INSERT INTO for_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Pigoya, pi ntaga wasanami i'nanto iraku'ma to kina imigini iyeguyigini, piya pemisa puma, ibawaimpiba yagarawaipa ata puwaitauguni, to yagarawaimpa anoke abakepa ataena puma: Iyeguyiyo yigini, iyegukibewe. ");
INSERT INTO for_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pi ntagaba nae nageraka wasanamiba kama puritakibewe. Piya pigiri, a'ya'ma yaga naeka napima kampa natakibepa, toganaba aogima mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pigoya, ma esapi aisuma agakibe kina'miba aogima abiyo. Piya, pi agogo yagaba monota tabera kamparagaenaba a'yugu mikibi nkauka'i ataigiri tini'ena pikibewe. Piya, pi ntagaba Yutiya mari mikibe kinapa, tiyegaka wama amu mari iyiyo. ");
INSERT INTO for_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wasanami abe'i mikibe kina'miba a'yugu namapinti ima ka'isaenaba asu maete wasanagawe. ");
INSERT INTO for_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Pigo wasanami yogari mintakibetisaba a'yugu to wama namapintisaena ampaete wasanagawe. ");
INSERT INTO for_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pi kanabipa iga'entaga waepe, inamuganto nono amikibe nkwaepe kamparagama mikibewe. ");
INSERT INTO for_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pi ntagaba esiba yaga waisanaga Kotiti nunamu yiyo. ");
INSERT INTO for_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Pigoya, maru Koti pogana, aboranti ntaga toma toma ataena waita waita ima, ibantoba waintikana, togana pi ntagaba tabera asu igasima tabe kuntuyenaba waiyekana, to asaba ataenaba kampa waikiye. ");
INSERT INTO for_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pigoya, Wa'egawamaba: Naegarao uwaimi kinaka napintikana, pi ataenaba e'ero ntaga kampa waikiye. Pi ataena e'ero ntaga waiyisinta, a'ya'ma kina kampa uwa minta pu'waewasine. ");
INSERT INTO for_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pigoya wasanami: Agaiyo, Koti utaratanta yagara, Karaisiti yagara mata'i mintiye urimikibepa, a-nkabiyo. Agaiyo, marompa mintiye urimikibepa, a-nkabiyo. ");
INSERT INTO for_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Piya, ka'isa kina'mi aborama tonarona esegiyenawai puriyakintini, ka'isa kina'mi: Karaisiti yagara nawe, yigini, ka'isa kina'mi: Poropete yagara nawe, yigiripa, ige kamanapa a-nkabiyo. Igeba meto'ena puma, Koti: Naegarao uwaimi kina'mi ntapiyenawaipa maema ataena pikena pigiripa, ");
INSERT INTO for_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","pi kamanapa a-nkabiyo. A'ya'ma togana aborakibintanaga urimuwe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Uwaimintana to maya untiye: Pigoya, pi ata yaga aborakana, toganaba papa tunusekana, opa kampa e'wasa pekana, ");
INSERT INTO for_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","noriba tutubu pekana, mantaba kuru pekana esegiyenawapa iyoba'ma kareko pikiye. ");
INSERT INTO for_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Piyaena marupa aborawaka, togana Wasanama Ntagara naeba tumukubopa, tabe esegiyenanentaga mimigara tumekini nagakibewe. ");
INSERT INTO for_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Pi ntagaba enisore kina igarubakini, a'ya'ma mari wama, a'ya'ma matuka matukarisa kina Koti: Naegaraiyo, uwaimemi kinapa ibabuma, naeti me akibikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Piya untana, to maya untiye: Pigoya, pika ya agama aogima napiyiyo. Kana yawama nka'no mparagina: Pipa yoga yaga aborayema, napiyesa puma, ");
INSERT INTO for_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","urimontana aborakibipa, agogo yaga agaro aborakiyema, napiyiyo. ");
INSERT INTO for_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pigoya tagaka urimuwe. Ka'isa kina'mi kampa purikibepa, a'ya'ma urimontanaba aborakiye. ");
INSERT INTO for_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mantabe mabe a'ya wakana, kamana'nepa uwa waiyaba waima kampa kakakiye, untiye. ");
INSERT INTO for_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Piya untana to maya untiye: Pigoya, ayantagabaya urimontanaba aborakiye. Wasanamiba kampa abintawe Mantarisa enisore kina'miba kampa abintawe. Koti Ntagara naeba kampa abintokana, nabanempa abiwa abintikana, yekana aborakiye. ");
INSERT INTO for_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ayantagabaya aborakiyema kampa abepa, nae tumukubopa napima aogima miyiyo. ");
INSERT INTO for_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pika meto kamana ukuwa, abiyo. Piya, wasanama namanka atate to wa'eri wantana, yoga kina'waka: Piya po, piya po, omima: Na kiye kabiyo, omite wagasaginiba: Ayantagabaya kanakiyema, napi napi pesa puma, ");
INSERT INTO for_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","tige napiyiyo. Ayantagabaya namankama nkaba kanakiye: Atamaino, asenabintiwo, kokore aga yekanawo, abayawo, kanakibayawema, tigeba kampa abintawe. ");
INSERT INTO for_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Agaro kanama a'yugu waitamintigina, ampa tigakiye. ");
INSERT INTO for_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pigoya urimontanaba a'ya'ma kina uwaimuwa, pika napi napi piyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Piyama magaba Yuta kina'mi Pasoba naninta nakena yagabe yisiti kampa wainta pareti nakena yagabe aborakena pogini: Isupa aya pumabaya kakama araku'ma aegukunema, tabe mono kiya kina'mige mono tisa kina'mige napintawe. ");
INSERT INTO for_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Napintini: A'yugu naninta nakibe ntaga arakurekini wasanami ata ma'ena pusanagawe, untawe. ");
INSERT INTO for_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pigoya, Isu Petani kumata wama, Saimoni autanta'ena ago ata wanti ntagarama ntamapinti umima, naninta naogana, ka wae'ma marasa punta kabo kankabe aogi agunta masawae maete kanantiye. Kana masawaenkama nkagewapa natiwe, tabe yabatasa ika pumaranta, maete kanamagina, kana kankabe ampa a'wa puma, Isu nka'noti ti'ma pai'atantiye. ");
INSERT INTO for_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Piya pogini, ka'isa kina'miba agate ka abi'ma: Nanagabaya kana masawae kasayema, mare-u me-u puntawe. ");
INSERT INTO for_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Piya, kana masawae to kina imemisinta, 300 torapa maema, kusi kina imemisinema, ka abirantawe. ");
INSERT INTO for_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Piyama abirauguna Isu maya untiye: Uwa ataiyo. Nanagabaya kaba abirawe. Naukaena punataye. ");
INSERT INTO for_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Pigoya, kusi kina'mi asi nasi tigege miyekini, a'ya'ma yaga napima iyo'maekena pewe. Pigoya tigege naeba asi nasiba kampa mikuwe. ");
INSERT INTO for_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kana wae'ma aewa napima, masawae nauti yora punatama kainatakibika napima, ibantoba maema aogi piye. ");
INSERT INTO for_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pigoya naeba tagaka urimuwe. A'ya'ma mari nae aogi kamana uwaimikibepa, ma punatamintanaga aeka mare-u me-u pukibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Pigoya, nagisarisa tara tumpaema abagi kina mintumepa, ka abagi yagara, Yutasi Isikeriyoti, aeba tabe mono kiye kinati wama: Isupa araku'ma timukuwoma, uma ibigantiye. ");
INSERT INTO for_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Piyama ibigaogini, ae kamanaka i'mu pumagini: Piya yempeka yabapa kamukune yuguna, Yutasiba: Aenkauka'ibaya Isuba waka arakurukuwema, napintiye. ");
INSERT INTO for_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pigoya, yisiti kampa wainta pareti naume ntaga aboraogini, pi marusa yaga Pasoba nanintaraka sipisipi awaro aegukena puguni, abagi kina'mi Isuka mayama abigantawe: Pigoya taeba aenkauka'i wama, Pasoba nanintagapa maema kaeti aogi pukunema, abigantawe. ");
INSERT INTO for_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Abigauguna, Isu abagi kina tara isigaruba'ma maya uwaisimintiye: Tisigeba kuma'i waisigina, wani kankabe aesaga urinta yagarama tisigakirisiba, ae aega'urite waisigina, ");
INSERT INTO for_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","namapi wakirisi, kana namankama nkaba nkuma omiso: Tisa yagaramaba maya iye: Naege nabagi kinake mima Pasoba naninta kae namapi nakuna, aemparuta ampima nasune iyema, omiso. ");
INSERT INTO for_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Omisigina, aeba tisibabute inati aogi pumaranta tabe maru asu tisiyakekirisi, pita'i Pasoba naninta taeka napima aogi piso, uwaisimintiye. ");
INSERT INTO for_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Uwaisimoginisi pi abagi kina'misi itate kuma'i wamaginisi pi abagi kina'misi itate kuma'i wamaginisi, pabi uwaisimomesa puma wama agateginisi, Pasoba naninta aogi puntase. ");
INSERT INTO for_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Aibusuguna, ase ikena pogini, Isuge nagisarisa tara tumpaema kinake wama, ");
INSERT INTO for_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","uma teborira mima nantini, Isu maya untiye: Pigoya tagaka urimuwe. Tigepisa ka'waina minaga punatakiye. Ibanto naege naninta nami ntagarama piya pikiye, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Piya yogini igeba intara pumagini: Naeka yeno yenoma, abigauguna, ");
INSERT INTO for_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","aeba maya uwaimintiye: Nagisarisa tara tumpaema kina tigepisa, naege ka tu'napisa paretirasa antipi mo aema nami ntagaramaka yuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Piya, Wasanama Ntagara naeba mono kamanata unatanti ki'i wakuwe. We, Wasanama Ntagara naepa minaga punatakibi'naba ataenabi mikiye. Piya, pi ntagarapa wasanama kampa yakari potantesinta, kanara pesine, Isu untiye. ");
INSERT INTO for_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Pigoya, igeba naninta nantini, Isu paretiba maema, Koti a'mu potama, ako puma imintana: Mapa nae nauna maema naiyo, untana, ");
INSERT INTO for_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","waini kankabe maema a'mu potama, imogini pi a'ya'ma kina'mi nantawe. ");
INSERT INTO for_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Piyama imitana, Isu maya uwaimintiye: Uwoma kina Kotiti atokaekenaga ma korantepa ago pagikiye. Pipa ara'ena potauwe. ");
INSERT INTO for_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tagaka urimuwe. Toma naompe wainiba kampa nakubopa, toganaba Koti kabiratakibita kasa'ena nakuwe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Piya uwaimintana ini ugaitegini, iro'ma Oribesi amuti intawe. ");
INSERT INTO for_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Aibuntini, Isu maya uwaimintiye: Mono isa'amaba maya iye: Sipisipira kabima minti ntagara aeguyiginiba, kana sipisipiba iyegaka aibarara puwakibewe, iye. Piya yemisa puma, tigeba a'ya'ma natate tiyegaka'ya puwakibewe. ");
INSERT INTO for_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pigoya togana asinatakibipa, Karariya-i tigepa paitama wama aborakiri nagakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piya yogana: A'ya'ma kina'mi iyegaka'ya puwakibepa, naeba kampa katate wakuwema, Pita omintiye. ");
INSERT INTO for_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Piyama omogana Isu maya omintiye: Tagaka ugamuwe. Iba aseka kakagara naeka: Kampa aganto ntagarawe, yeganaba: Tarara kokorewama aga ukiyema, omintiye. ");
INSERT INTO for_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piyama omogana Pita esegima maya untiye: Wasanami naeke tasiyegukibepa: Naeba ae ao'yagara kampa mintuweba kampa ukuwe, omogini, a'ya'ma kina'miba pabi Pita yomesa suntawe. ");
INSERT INTO for_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pigoya igeba ka au'i wama, kana mawama nkagewapa Kesemeni, wamagini Isu abagi kinaka: Mata mara'miyigi nunamu yeno, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Piya, Pitana Yemisina Yonina suma, ibiri ibabute wamagina, agasiyama aekuru puma akawagawa pumagina, ");
INSERT INTO for_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","maya uwaimintiye: Naepa tabera naukima nanta waru waru nabiya, tigeba mata mima kabinataiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Piya umagina, aeba ka au'i wama auki nakiyena uwa atakenaga umagina, mara antagawarisa uma aigare pa'ma mima, nunamu maya untiye: ");
INSERT INTO for_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","We nabanempa-o, kaeba a'ya'waemaena pikena yagara mintana, nauki nakiyenaba naparo. Pigoya, nae napiyenagaba a-ntapima, kaeka napikibempentana wasima po, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Piya ute, kana pi kakaga kina'mi waitamintuguna, igate Pitaka maya omintiye: Saimoni waitamintano. ");
INSERT INTO for_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Kampa agarosama kaoganta wairabankano. We, tiyogama mima, kabinatama nunamu yiyo. Piya puntiripa kampa aguntaena pikibewe. Pigoya tigu'amaba tiyampu pegina ti'amaba kampaye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Piya uwaimitegina, to mare auka'i wama, pabi to yomesa nunamu untiye. ");
INSERT INTO for_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ugaitegina to ampa igaomepa, waite asite pugagategini waitamintuguna, kanama ampa igaogini, ae omikena kamanakaba kampa napintawe. ");
INSERT INTO for_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aibuguna to wagate kanaomepa maya uwaimintiye: Tigeba to migarakena waiyewo. Pabigoya, nae yaga aboraya, ibanto Wasanama Ntagaranagana, ataena punatakini, agunta kina'mi narakurikena pewe. ");
INSERT INTO for_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pigoya, asiyigi wano. Minaga punatakena yagaraba mompa iya, agaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Pigoya Yutasi, nagisarisa ka tumpaema abagi kina nasumepisa me nkigaite waogana, Isu kamana ugaka pogana, Yutasi uwoma kina uma ibabute kanantiye. Piyama tabe mono kiye kina'mige tisa kina'mige kabiyume kina'mige pi uwoma kina igarubauguni, igeba irebube ma'ena kasupe maeyuguna, ");
INSERT INTO for_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","minaga potakena pome ntagarama ibabute kanantiye. Aeba kanantana maya untiye: Uma agate, amo nakubo ntagaraba aewa, araku'ma kabirite waiyo, piya ute ibabute kanantiye. ");
INSERT INTO for_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yutasi ibabute kanama, karu'ena Isuti wama: Tisa yagarama-o, ute, uma aepa'ma amo naogini, ");
INSERT INTO for_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","uma aebasa'ma araku'urintawe. ");
INSERT INTO for_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Araku'uruguna, ka pi mintume ntagarama kasonka me a'yuburintana, mono paitanta yagarama ntuga yagarawapa uma aeguma, age aira kaentiye. ");
INSERT INTO for_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Aibogana Isu maya uwaimintiye: Tigeba nanaga naekaba ku kinanema napima, narakurikena irebube kasope maete kanawe. ");
INSERT INTO for_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Naeba asi nasi tabe mono namapinti wama kamana yogiripa, kampa pita'iba narakurewe. Pigoya, mono isa'ama yemisantana naraku'ma, karana natakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Piya yogini, abagi kina'wa a'ya'ma atate iyegaka'ya puwantawe. ");
INSERT INTO for_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Piya puguna, ka kai amirinta masimabima Isu aega'urite kanaogini, aeke arakuruguna, ");
INSERT INTO for_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kana yagaramaba aibarigo puma, kaiwapa atagaite auka aegaka wagaintiye. ");
INSERT INTO for_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pigoya, igeba Isupa ababute monota paitanta yagarari wauguni, pita'i a'ya'ma tabe mono kiye kina'mige kabiyume kina'mige tisa kina'mige me nkaki puntawe. ");
INSERT INTO for_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piya puguna, Pita aka'i aega'ma pasema wama, monota paitanta yagarama kumati ima, irebu kina mintume ntakuta asu tapintiye. ");
INSERT INTO for_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Asu tapiyogini, tabe mono kiye kina'mige a'ya'ma mono kanisore kina'mige mimagini, Isu kamana otamagini, Isu ataena pusanaga ige atakae puma, Isu aegukena pumagini, piya kamanapa kampa abintawe. ");
INSERT INTO for_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pigoya, uwoma kina'mi ampimagini, kampari kamana: Aeba piya pine, piya pine yuguna, ige yume kamana agoba kampa aogima abintawe. ");
INSERT INTO for_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Piya puguna ka'isa kina'miba asima kampari kamana Isuka maya untawe: ");
INSERT INTO for_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ma wasanami kimaranta mono nama akasaba'maba, wasanami kampa kiyesa ntama kakaga yaga kima a'ya kaikuwe, ubegi abibompene, untawe. ");
INSERT INTO for_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Piya umagini, igeba to ka'isami yumesa puma, kampa ka kamanapa unta, to kamana to kamana uwaimintawe. ");
INSERT INTO for_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Uwaimuguna, monota paitanta kiye yagarama ikapi asima mima, Isuka mayama abigantiye: Ma kina'mi kaeka yepa, kaeba ayawe uramikibenema, abigantiye. ");
INSERT INTO for_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Abigaogana, Isu kampa kamana unta asaba'waogana, paitanta yagaramaba to mayama abigantiye: Tabe ta'mu potaompe Ntagarama ntagara Karaisitigawoma, abigantiye. ");
INSERT INTO for_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Abigaogana Isu maya untiye: Pipa nae mintuwe. Tigeba Wasanama Ntagaranaga Esegiraka'ya Ntagarama nkayatakanti mara'miyekiri nagaigi, mimiga mantara tumekiri nagakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Piya yogana, tabe kiye yagaramaba kabi'ma autasaenaba aegaregaru pa'ma, maya untiye: Nanagabaya to kina'mi kamana yigi abukune. ");
INSERT INTO for_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ae'wa piyama Koti Ntagaranawe yipa, kampari kamana'wapa yegiri abewa, aya pisiwema, ibigantiye. Ibigaogini: Aeba ata yagarawa, aeguyiyoma uwaimo, untawe. ");
INSERT INTO for_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Piya untini, ka'isa kina'miba kaisa potamagini, aoba airarikae u'ma aegutategini: Kebaya kaeguya, uramoma, abigauguni, irebu kina'miba araku'ma iya kasutasa aeguntawe. ");
INSERT INTO for_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pigoya Pita kuma'i mintogana, monota paitanta yagarama ntuga potaome nkwaepa kanama, ");
INSERT INTO for_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","agaomepa Pita yakuta tapima mintogana ampa agate: Kaege Isu Nasaretirisa yagarageba naseka kagabone, untiye. ");
INSERT INTO for_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Piya yogana aeba: A'a-o. Naeba kampa abuwa, kamanakapa nanawe yewe, untiye. Utegina, ae kagisa kabera tumpintogana, kokore aga untiye. ");
INSERT INTO for_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tumpintogana to kana wae'maba agate, agora mintume kinaka: Mo ntagaraba ae aokinane, uwaimogana, ");
INSERT INTO for_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita to: A'a-o, untiye. Piya yogana uwaenanto togana to agora ampintume kina'mi Pitaka: Kaeba Karariya yagaragawa, nanaga: A'a-o yene. Kaeba ka aokinakawe, untawe. ");
INSERT INTO for_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Aiyuguna aeba: We, taga kauwe. Naeba pi yempe ntagaraba kampa aganto ntagarawe, ute amota atantiye. ");
INSERT INTO for_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Piya pogana kokorewama to ka aga yogana, Pitaba pai Isu omome kamanaka mayama napintiye: Kaeba naeka kakagara: Kampa aganto ntagarawe yeganaba, tarara kokorewamaba aga ukiye omomeka napima, tabera antara puma, kube'ena puntiye. ");
INSERT INTO for_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pigoya, abaya aseka tabe mono kiye kina'mige kabiyume kina'mige tisa kina'mige, a'ya'ma kanisore kina'mige aki puma: Piya pukunema, uritegini, Isupa iga'narasa kirokaetamagini ababute wama, Pairati memintawe. ");
INSERT INTO for_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Memuguna Pairati: Kaeba Yuta kina'mi Wa'ega yagaragawoma, abigantiye. Abigaogana Isuba: Kae piyaba yene, omintiye. ");
INSERT INTO for_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Piya yogini, tabe mono kiye kina'miba: Uwoma tonarona ataenaba pemi ntagarawe, Pairati omintawe. ");
INSERT INTO for_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Piyama omuguna, Pairati to ka mayama abigantiye: Igeba kaeka tonarona ataena pemi ntagarawe yepa, kaeba kampa kamanapa ikena penoma, abigantiye. ");
INSERT INTO for_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Aiyogana, Isuba to kampa unta asaba'waogana, Pairati piya pomeka pami puntiye. ");
INSERT INTO for_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Pigoya, ka yagaraba agewapa Parabasi, pi ntaga aege ao'mige ma'ena puma, kiya kina'mi nkaokina iyegute, karabusibi mintantiye. Mintuguna, a'ya'ma Pasoba naninta naume ntagaba Pairatiba uwa kinaka: Karabusibisaba ke uwaba atasuwema, ibiga puntiye. ");
INSERT INTO for_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Piya, pome ntaga uwoma kina ampa aki puma mima, Pairatika: To puntampesa puma ka'mu puratama, karabusibisa ka yagara uwa ataoma, abigantawe. ");
INSERT INTO for_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Piya yuguna Pairati mayama napintiye: Mono kiye kina'mi Isuka imo potamagini, araku'ma kotiyena potawema, napimagina: Tige yeka, Yuta kina'mi Nkwa'ega yagara uwa atasuwoma, ibigantiye. ");
INSERT INTO for_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ibigaogini tabe mono kiye kina'miba ampa aki puntume kinapa maya uwaimintiye: Parabasi uwa ataoma omiyo, untawe. ");
INSERT INTO for_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Piya yuguna, Pairati aki puntume kina to mayama ibigantiye: Yuta kina'mi Nkwa'ega yagarawe ye ntagara mintiya, aepa aya pusuwema untiye. ");
INSERT INTO for_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Piya yogini: Yara aeguma itagiyo, untawe. ");
INSERT INTO for_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Piya yuguna Pairati: Nana ataenaba pegiri yewema, ibigaogini, to taberasa: Yara aeguma itagiyo itagiyo, untawe. ");
INSERT INTO for_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Piya yuguna, Pairati aki puntume kina'mi i'mu punatakibewema, napima: Parabasi uwa wao, untiye. Piya yogana waogana, Isupa irebu kina imogini, igeba paga kasutasa agasiya kasu aeguyuguna: Ababute wama yara itagiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Piya uwaimogini, irebu kina'mi Isupa ababute tabe irebu kina'mi kumati wamagini, kana kuma'ama nkagewapa Paratoriyamu wamagini, to ka'isa irebu kinakaba uma kega'e yuguni, ampa aki puntawe. ");
INSERT INTO for_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Piya pumagini, kiya kina'ma tete kai maema Isupa amitamagini, ake wainta iga'narasa taminoku'ena potama, a'notapa taminonkitama, ");
INSERT INTO for_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","saroti amimagini: Kaeba Yuta kina'mi Nkwa'ega yagaragawa, e'ero ntaga aogima miyo, untawe. ");
INSERT INTO for_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aibuntini, igeba kasotasa a'no airapora puma aeguntini, kaisapa potantini, aeta parokaema karana kasa uma: Kaeba tabe yagaragawe, untawe. ");
INSERT INTO for_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Piya puma karana atagaitegini igeba tete kaiba atama maebugasimagini, to ae'wa kai amitamagini, abe'i iro'ma ababute, yara itagikena wantawe. ");
INSERT INTO for_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pigoya, ka Sairini marisa yagara agewapa Saimoni, Aresantake Arupasike isibawaisimpa, to auka'isa kanaometa keta pabumagini: Maripoba aesaga'urite wao, omuguna aesaga'urite wantiye. ");
INSERT INTO for_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Piya pogini, igeba Isupa ababute, Korikota wasana a'no nkayampu kanta mari wama umintuguni, pita'i aeguntawe. ");
INSERT INTO for_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Piya, ka'isamiba kampa aukikena tusa wani wainibi atama: Naoma amuguna: Kampa nakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Piya, irebu kina'mi uma yara itagitamagini, kaiwapa maemagini, tete'ena pumagini, kebaya tonarona kaiwapa maekiyema puntawe. ");
INSERT INTO for_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Piya pumagini, abayara yara itagitamagini, ");
INSERT INTO for_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","kotiyena potaume kamana maya uma kaentawe: Yuta kina'mi Nkwa'ega yagarawema, kaemagini, a'no nkabobori a'makaetantini, ");
INSERT INTO for_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","ku kina tarage, kapa ayatakantiwa, kapa ayake'masiwa suma, isigeke yara ita isitantawe. ");
INSERT INTO for_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Piya puguni ka'isa kina'mi agora wama, pumireri potama maya untawe: Kaeba ka yaga tabe mono nama akasabakaiteba, karu'ena kakaga yaga kikuwe ubempe ntagaragawe, ");
INSERT INTO for_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","kaega ntapima, yarasa kaupa aogi purite tumo, omintawe. ");
INSERT INTO for_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Piya omuguni, tabe mono kiye kina'mige mono tisa kina'mige pabiyama pumireri potamagini, igewai marebiga mebiga puntawe: Aeba to kinapa aogi puwaitantana, aewapa nanagabaya kampa au'wapa aogi piye, untawe. ");
INSERT INTO for_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Piya, Koti utaratanta, Isureyo kina'mi kiya yagaranawe untanapa, yaba pabigo ibanto atate tumegapa, kagate kae kaegarano, untawe. Piya yugunisi, pi tara aeke ita isitaume ntagararamisiba, isigege pumireri potamaginisi, aeka ata kamana otantase. ");
INSERT INTO for_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Piya puguna, kagita a'ya'ma maba ase uwaogini mintuguna, to atamaita mesu marintiye. ");
INSERT INTO for_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Pigoya, Isu atamaita mayama kega'e untiye: Iro-i, Iro-i, arama sabatani, untiye. Pi kamanapa tae kamanapisaba: Kotinempa-o, Kotinempa-o, nanagabaya kaeba uwa natane, untiye. ");
INSERT INTO for_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Piya yogini, ka'isa mintume kina'miba abitegini: Iraiyakabaya kega'e iye yuguna, ");
INSERT INTO for_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ka yagarama karu'ena wamagina kai atuta asa wanipi ae u'ma, asara kitama: Nao, ute mayo amintiye. Aibumagina mintume kina'mipa maya uwaimintiye: Pabita, abiyo. Iraiyaba tumpa akitama uwa atakibayaka agakune, untiye. ");
INSERT INTO for_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Aiyogana Isu tabera kega'e uma, purintiye. ");
INSERT INTO for_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Purogana, tabe mono nama nkantabintisa kai, Koti nkauka'i akunkataume kai akapisa aeru'ma torirari puwantiye. ");
INSERT INTO for_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Piyama Isu purogana, irebu kina'mi kiya yagarama agora mintumetisa agate, maya untiye: Tagane. Ma ntagaraba Koti Ntagarawe, untiye. ");
INSERT INTO for_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pigoya, pi ntaga waya'iyaba mare nkau'i mima apasa puntawe. Ka'isa kana wae'mi nkigewaipa: Mariya Matara kumatisa waena, to ka Mariya ae'wa nkamana Yemisike Yoseseke isinowaisimpawa, to ka wae'ma agewapa Saromiwa suma, ");
INSERT INTO for_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Karariya-i Isu mintoganaba, kana wae'mi aega'ma, ao'mae pome wae'iya mintuguni, to uwoma Yerusaremi ababute inta wae'iyamige ampima, agaba puma mintantawe. ");
INSERT INTO for_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Pigoya, aiba sabati aborakiyema, a'ya'waemaenaba aogi puma ntagagana ase ikena pogana, ");
INSERT INTO for_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Arimatiya kumatasa yagara Yosepe, aekuruyenagaba kampa napinta Pairatiti wama: Isu nkaupa maesuwoma, abigantiye. Pigoya kana yagara aogi mono kanisore yagara mimagina, Koti kabima mikenaenaga napi napi pome ntagaragana mintantiye. ");
INSERT INTO for_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Piya yogana, Pairati: Agobaya pu'wayema, napima, irebu kiya yagara kega'e uma abigaogana: ");
INSERT INTO for_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Owe ago pu'waye, kana irebu yagara omintiye. Omogana abite Yosepeka: Kanarana au'wapa umaeyo, omintiye. ");
INSERT INTO for_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Omogana Yosepeba aogi wae kai maerite wamagina, uma akitama, pi kaibi yoburite, yabapi ku'maranta kabi uma kaitamagina, kawarapa tabe yaba a'waremagina akunkatantiye. ");
INSERT INTO for_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Piya poginisi, Mariya Matara kumatisa waeke, to ka Mariya Yosese nkanowampage, kanama kaiyome aru ampa agantase. ");
INSERT INTO for_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Pigoya, sabati a'ya waogini, Mariya Matara kumatisa waena, to ka Mariya Yemisi nkanowampawa, to ka wae Saromiwa sumagini, aogi agunta yome tusaena ae auti yora potakena tusaena ika puritegini, ");
INSERT INTO for_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","sonta yagaba, abaya aseka asima aruri wantawe. ");
INSERT INTO for_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ke'i wantini tabe yabaka: Kebaya aru ka awarasa a'wareragasaka pai'atakunema, igewai uta wantini, ");
INSERT INTO for_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","pi yabapa tabe yabapa uma agaumepa, a'waima a'ware wantiye. ");
INSERT INTO for_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Aibogini, kabinti wama uma agaumepa, aogi wae kai amirinta masimabi yagara ayatakantisa auka'i asima mintogini, uma agategini pami puntawe. ");
INSERT INTO for_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pami puguna maya uwaimintiye: Tigeba a-pamiba piyo. Isu Nasaretirisa yagara, yara itaginta ntagaraba agusagapa, aeba matapa kampa minta, ago asima waye. Agaiyo, mata kaitatawe. ");
INSERT INTO for_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Piya, tigeba wamagiri Pitage abagi kinake: Paitama Karariya-i wakiri, urimintisa puma pita agakibewe, uma uwaimiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Uwaimogini, igeba iyekuru puma pami pute, arubintisa iro'ma iyegaka wamagini, iyekuru puma, kana kamana kampa to kinapa uwaimintawe. ");
INSERT INTO for_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","(Pigoya, abaya aseka sontara Isuba asima, Mariya Matara kumatisa wae'ma agora aboraogana, agantiye. Kana wae'mapa pai Isu tonaentisa tara umaema ke kina agaruba agasome waekana mintantiye. ");
INSERT INTO for_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Mintogini, Isu nkaokina'mi intara puma kube'ena puma miyuguna, aeba wama: Isu ago asima mintegi agauwe, uwaimogini abite: Kampari kamana yene, untawe.) ");
INSERT INTO for_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","(Togana to tara yagarara uwa mari ke'i wausuguna, Isu to kina kanta yagara aboraoginisi agateginisi, ");
INSERT INTO for_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","to kinati wama: Ago Isupa agause, yusuguni: Kampari kaese, untawe.) ");
INSERT INTO for_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","(Pigoya, togana nagisarisa ka tumpaema kina'mi naninta nauguna, pita Isuba aboramagina maya uwaimintiye: To kina'mi ago nagategini, asima mintiye kamana nagata kina'mi urimuguripa, nanaga tigeba akumpa'ma miyewema, ka ibirantiye. ");
INSERT INTO for_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Piya umagina aeba to amato puma maya uwaimintiye: Tigeba a'ya'ma auka'i nasima, aogi kamana'ne a'ya'ma kina uwaimiyo. ");
INSERT INTO for_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Wasanama nae kamana aega'ma wani maekibipa, ao'maeyakana ikiye. Pigoya wasanama kampa nae kamana aegarakibipa Koti ataena potakiye. ");
INSERT INTO for_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Pigoya nae kamana aegarakibe kinapa maya esegiyena pikibewe: Nae nageraka ke kina agarubakibewe. Kasa to kamana ikibewe. ");
INSERT INTO for_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kuya iyatasa maekibepe karaena nakibepe, kampa ata puwaitakiye. Pigoya igeba iyatasa yoni kina'mi ikaya pikibepa ita wakiye, piya uwaimintiye.) ");
INSERT INTO for_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","(Tabe Yagara Isu piya uwaimigasogana, ababogana mantari imagina, Koti nkayatakantisa auka'i asu mintogini, ");
INSERT INTO for_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","abagi kina'wampiba a'ya'ma auka'i wama, kamana'wa uwaimuguna, Wa'egawamaba iyo'maema, esegiyena tonarona pogini, agategini: Taga kaeyewe, untawe. Tagane.) ");
INSERT INTO for_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Teyopiro, tabe yagarare, abakatepi Koti kao'ena puratama mono yuga punti kamanapa uwoma kina'mi aogima arabama kaentawe. ");
INSERT INTO for_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Pi kamanapa Isu nkagora mintanta kina'mi agama abintini, piya mayaenama nkagowapa abinta kina'mi nkuraminta kamana kaentawe. ");
INSERT INTO for_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pigoya, naeba pabiyama nabegi, agorasa a'ya'waemaena aboraurite kananti, pika pasema aisuma a'ya uritegi, kau'nana kamana uma kaeyuwe. ");
INSERT INTO for_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Pigoya, pipa aisuma mayama abibebe po. Mono ugamintapa taga au'wantaga'ena, ka'isa kina'mi nkugaminta kamanapa kaeba aogima aisumagina, abibebe po. ");
INSERT INTO for_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Pigoya, Erotiba Yuta kina'mi nkwa'ega yagara mintome kanabi, mono kiye yagara ka mintantiye. Agewapa Sekaraya, aeba Abaisa ae mono yuga aruyenabisa yagarawe. Waya'wapa Eroni mpono yuga aruyenabisa pi nkatutasa, agewapa Erisabeti mintantiye. ");
INSERT INTO for_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Pigoya, isigeba Koti nkaobi isigupa aogima atamaginisi mima, a'ya'ma Wa'egawama unti kamanape arupu kamana'wape aogima wasima mintantase. ");
INSERT INTO for_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Piya, Erisabeti anamo wae mintika, isigeba yagarawaisi kampa minta mima, karena aenta tantase. ");
INSERT INTO for_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Pigoya, Sekarayage aokina'mige Koti mpono yugawai pikenagana aboraogini, ");
INSERT INTO for_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","irosa'magini Koti ntuga uwaitantemi ntuga iyota iyota puma maentini, Sekarayapa kunka aguntaena kaeyanema otauguna, Koti ntamankama nkagupinti uma pasintiye. ");
INSERT INTO for_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Piya pogini, wa waya uwa kinapa abe'i kumati aki puma mima, Wa'ega esotama mintuguna, ");
INSERT INTO for_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","kunka aguntaena kaeyogana, Wa'egawamatisa enisore aboramagina, kunka aguntaena kaekenaenara ayatakantisa auka'i asima mintantiye. ");
INSERT INTO for_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Asima mintogana, Sekaraya agate pami pumagina aekuru puntiye. ");
INSERT INTO for_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Piya pogana, enisorewama maya omintiye: Sekaraya, kaeba a-kaekuru po. Wa'egawamaba esotakanaba abintika, wayakampaba aga'e puma, yagara ka yakari pekanaba, kaeba ae ageba Yoniwe omo. ");
INSERT INTO for_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Pigoya, kae kantawamaba aogi puma, asoya pekana ka'mu pikibene. Piyama aborakiniba, uwoma kina'mi abigina iga pukiye. ");
INSERT INTO for_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pi ntagara Wa'egawama nkaobi tabe kina'ena puma mikiye. ");
INSERT INTO for_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Aeba esegi wanipa a'a-o uma miyekana, Aota Awamusa'amaba inamugantora agupi tumima pumaekiye. Pumaeyakana, Isureyo kina uwoma kina igu a'wae pekini, Wa'egawama, tabe Kotiwaimpa agorasaena pikibewe. ");
INSERT INTO for_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Piya, poropete yagara Iraiyati aumabe esegiyenabe waintanti, pabiyama waintantakana paitamagina, wama Wa'egawama nkawaga kamana ikena kina'ena puma mikiye. Pigoya, abawampabe yagarawampabe ige igu maema paru puma kayone puwaitakini, ka'masa puma mikiye. Piya, ikeri pakibe kinapa uwaitakini, to a'wae puma aegaranta kina'mi nkaruyenaba uma mikibewe. Piya pekini, wasanamiba a'ya'waema Wa'egawamaka aseyo puma mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Pigoya, enisorewama piya yogana abintana, Sekarayaba kamana mayama a'wae pomintiye: Naebe waya'nepe tasigeba ago karena aenta tause. Pikaga kamanakapa ayama abibebe pukuwe, yogana, ");
INSERT INTO for_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","enisorewama maya omintiye: Abeno. Nagenepa Kebariyo, naeba Koti nkaobi miyo'nana, nagarubagi kaeti tumima aogi awaga kamana ugamoganapa, ");
INSERT INTO for_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","kampa abibebe pene. Pi'na antotapa aibo'ena puma, kamana kampa unta kina'ena puma mintagana, kamana ugamo kamana'amaba au'wantaga'ena pikiye, piya omintiye. ");
INSERT INTO for_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pigoya, Sekaraya aeba tabe mono namapinti e'erota mintogini, wa wayapa igeba agawa puma mimagini, uwoma nkigi napintawe. ");
INSERT INTO for_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Piya puguna, ainti igeti tumimagina, kamana uwaimikena igiga puntiye. Aibogini igeba maya untawe: Aeba tabe mono namapinti to ka aoso'ena agai'nawe, yuguna, pigo aeba ayatasa awame puwaiyakintiye. Awamupisa kamanapa kampa untiye. ");
INSERT INTO for_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Piyama mintogana, yoga pikena kana'wapa a'ya pogana, atate kumati wantiye. ");
INSERT INTO for_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pigoya, ainti waya'wampa Erisabeti aga'e puntana, opa nayaka'mu kakama mintantiye. Piya puntana maya untiye: ");
INSERT INTO for_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Wa'egawama aeba kana atanti, pipa aborakanaba aogi punatamagina anamo nanintanaba asu'a punagaintiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pigoya, tonaentisa ka'umaema upa Erisabeti aga'e pogana, Koti nkenisore yagara Kebariyo agarubaogana, Karariya mari Nasareti kumati tumimagina, ");
INSERT INTO for_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","aragawae'mati tumintiye. Kana aragawae'ma nkagewapa Mariyawe. Pigoya, kiya yagara Tebiti nkayabama, agewapa Yosepe mintana, kana aragawaepa maekiyema ika potantiye. ");
INSERT INTO for_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aibuguna, kana enisorewama Mariyati wama maya omintiye: Aya pene. Wa'ega Yagara kagora mima, kaeka a'mu pugatama abegina aogi piye, yogana, ");
INSERT INTO for_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariya kana enisore yagarama yome kamana abite aekuru pumagina: Kamana agowapa ayabayawema, napintiye. ");
INSERT INTO for_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Piyama napiyogana, enisore yagarama maya omintiye: Mariya, kaeba a-kaekuruba po. Koti antawamaba kaeka abegina aogi piye. ");
INSERT INTO for_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kaeba kaga'e puma masinto yakari potamagina, agewapa Isuwe omo, untiye. ");
INSERT INTO for_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Piya untana to maya untiye: Aeba ae age Inatisa Wa'ega Yagarama Ntagarawe omikibewe. Piya puma, ayabama Tebiti kabintemisa puma tabe yagara mima, ");
INSERT INTO for_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","a'ya'ma yaga Yekobu nkaokinatapa kabiwaitama, a'ya'ma yaga Tabe Yagara miyaba miyaba mikiye, piya omintiye. ");
INSERT INTO for_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Piya yogana, Mariya enisore yagaraga maya omintiye: Naeba kampa nawaeba mintiye. Yempe kamanapa aya pikiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Piya yogana, enisore yagarama maya omintiye: Aota Awamusa'ama kantabaipinti tumekana, Inatisa Yagarama esegiyenawampa aogi pugatakana, yagaragampa aota yagara, age Koti Ntagarawe ukibewe. ");
INSERT INTO for_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kaeba abo. Kanogae Erisabetigaba, aeba anamo aentawe ye wae'ma aga'e pumagina, togana kakaga u migaitegina, masinto yakari potakiye. ");
INSERT INTO for_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Piya, Koti ka'ena pikenaba kampa igiga pukiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Piya yogana Mariya maya omintiye: Abo. Naeba Wa'ega Yagarama kayokaya araganagana, pabi yempesa punatakiye, untiye. Yogana, enisore yagaraba atate wagaintiye. ");
INSERT INTO for_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Enisorewama kamana omigaite wagasogana, pabi ntaga Mariya ka'isaenawapa aogi purite, Yutiya mari karu'ena wamagina, amu wainti mari ima, kuma ka waintiti imagina, ");
INSERT INTO for_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Sekaraya ntamapinti ima Erisabetika: Aya pene, asu untiye. ");
INSERT INTO for_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Aya pene asu yogana, Erisabeti ntagara antabaipinti patagi pogana, Aota Awamusa'ama Erisabeti nkantabinti pumaeyogana, ");
INSERT INTO for_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Erisabeti Mariyaka maya omintiye: Koti a'mu pugataye. Kaeba aogi waekagana, taberasa Kotiba aogi pugatakana, kantabaipinti aborama mintemi ntagara aogi yagara aborama miye. ");
INSERT INTO for_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","44","Pigoya abo. Kae kamana yeka aboganaba, nantabaipintisa yagaranempa ago a'mu puma patagi piye. Naeba na'mu pugatauwe. Kaeba nae Wa'ega Yagarama nkanogawe. Ayabaya naeti kanama ampa nagane. ");
INSERT INTO for_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Pipa Wa'ega Yagarama kamana ugaminta, kaeba abekana tagantana pemika, tabera ka'mu potane, piya omintiye. ");
INSERT INTO for_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Piya omogana, Mariyaba abite a'mu kamana maya untiye: Naeba nagu namankamaba Wa'egaga na'mu potauwe, iye. ");
INSERT INTO for_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Piya, naumawamaba Koti aogi punatakenaenanempa na'mu potauwe, iye. ");
INSERT INTO for_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Abo. Ae kayokaya araga nae uwa miyogana nababuma aogi punatakini, ibabe aintibe Koti a'mu punatami kamana a'ya'ma kina'mi abimagini, naeka i'mu punatakibewe, iye. ");
INSERT INTO for_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Piya, Koti tabera aogi punatami, esegi yagara miye, iye. Piya, agewapa aota puma waintiye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Aeka abemi kinapa igepa agu kao'ena puwaitamagina, ago paipe ibabe abemi kinapa igepa aogi puwaitaye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Aeba esegiyenawampa nkagowapa aboramagina, i maete iye kina igepa igarubantiye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Aeba kiya kinapa maema merunkaba puwaitaogini tumi wantawe, iye. Piya, tumima mintanta kina ababuma mesuba puwaitantiye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aeba kusi kina ige piyamaenaba asaema imintana, pi tabe kutantaga kinapa igasogini, imu kampa wainta kina'ena puma mintantawe, iye. ");
INSERT INTO for_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Piya, tayabamagi Abara'amupe aga'nugipe utawaitantiye. Pabi nkawameta piya purataika, kamana'wapa uwa waita ikiye, iye. Pi kamana'waka napimagina, Isureyo kina, Koti kayokaya kina'wa, agu kao'enaga uma tabaibuntiye, Mariya piya untiye. ");
INSERT INTO for_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Piya ugaite, Mariya aeba Erisabetige kakaga u migaitegina, kuma'wati a'wae puma wantiye. ");
INSERT INTO for_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pigoya, Erisabeti yakari pikena yaga aboraogana masinto yakari potantiye. ");
INSERT INTO for_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Piya, Erisabeti nkaotumpibe wa'ewatasa kina'mibe abite, Wa'egawama aogima ao'maeyogini ampa agate, igeba a'ya'ma i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Pigoya, Yoniba ka sonta migasogini, paisa mono kamanapi waintome kamana wasiyu'ma au kasantawe. Au kasagasimagini, agewapa abawampa aukantana Sekarayawe omikena puntini, ");
INSERT INTO for_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","abigauguna anowampa: Kampaye. Agewapa Yoniwe omiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Piya yogini: We, kae kaokina'mi piya igiba piyamaba kampa waintiya, aya pukune, ugategini, ");
INSERT INTO for_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","a'wae pumagini abawampaka iyatasa posenta pumagini: Agewapa kewe omusune, untawe. ");
INSERT INTO for_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Piya yuguna, Sekaraya esaka ibigaogini me nkamuguna: Agewapa Yoniwema, kaentiye. Piyama kaeyogini, wasanamiba agate pami pumagini: I-e, a-e, untawe. ");
INSERT INTO for_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Piya puguna, Sekarayaba pi ntaga kamana iro'ma untana, Kotigaba tabera a'mupa puntiye. ");
INSERT INTO for_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Piya pogini, wa'ewatasa kina'miba pintanaga agate iyekuru puntawe. Piya pumagini, Yutiya amu waintome mpari nasima mare-u me-u puta nasintawe. ");
INSERT INTO for_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Piya umagini, abume kina'mi: Aya yagarantobaya mikiyema, napimagini: Wa'egawama nkesegiyenawampa aepipa waintiye, uma: Ayabaya pukiye, untawe. ");
INSERT INTO for_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Piya yuguna, abawampa Sekaraya Aota Awamusa'ama pumaeyogana, maya untiye: ");
INSERT INTO for_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Isureyo kina, tae Wa'egare Kotika ta'mu potaune, iye. Ataenabisa aokina'wa ampa taba puma aogi purataye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Piya, kayokaya yagara'wa Tebiti nkayabamapisa ka esegi yagara asitakana aogi puratakiye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Pai poropete kina'wa uwaitaogini, waiyaba mikena kamana umarantapa, iba aboraye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Pigoya, kama kinatempi nkiyapisa tababumagina, aeba abima ata purata kina'mi nkiyapisa iyoba tatakiye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Piya, tayabamagi kao'ena puwaitama iyo'maekuwe, Koti piya untiye, iye. Pika maema ka aga'naena puratama, agu kao'ena ibaba purataye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Piyaba Koti tayabama Abara'amupa uma esegi potantika, ");
INSERT INTO for_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","kama kinatempi igetisa iyoba tataka, aogima mpima kayokaya kina'wa mpimagina, ");
INSERT INTO for_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","a'ya'ma yaga taeba ae aobi aota puma mima, aogi ki'i aegarakubompeka Kotiba ka esegi yagara asitakana aogi puratakiye, Sekaraya piya untiye. ");
INSERT INTO for_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Piya untana, Sekaraya a'wae puma yagarawaka maya omintiye: Pigoya, ma ntagaranto, kaeba Inatisa Wa'ega Yagarama poropete yagaragawe, ugamikibewe, iye. Piya, kaeba paitama Wa'egawama ki'i atakibene, iye. ");
INSERT INTO for_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Piya, kaeba aogi puratakena kamana uwaimegini, a'ya'ma aokinapa abikibewe, iye. Piya, aeba aru'enawaipa agaruba igasima ibabuntiye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Pigoya, tabe kao'ena Kotiba puratama, piya aogi puratamika, pi aeba mantarisa e'wasaena otakana taeti arakiye, iye. ");
INSERT INTO for_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tununtanabi purikena kanta puma miye kina e'wasaena tamima aogi puratakiye, iye. Piya, paruyenama ki aboraka agama, kanara tanta paruyenabisa aegarakune, Sekaraya Yonika piya untiye. ");
INSERT INTO for_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aiyogana, ainti kana yagarantoba anosama tabe pogana, aumawampaba esegi potantiye. Piya, aeba ka'me mpari umintogana, kana'wapa aboraogana, Isureyo kina'mi nkiyobipa aborantiye. ");
INSERT INTO for_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pigoya, Aroma tabe kiye yagara Ogasita aeba kamana ataogana wagana pogini, a'ya'ma kina'mi nkigewai kaemagini aogi pikena puguni, ");
INSERT INTO for_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","pi ntagaba igewai kaekena maru'ena puguna, Kariniyasi aeba Siriya kumata kiya yagara mintantiye. ");
INSERT INTO for_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mintogini, a'ya'ma kina mawaita ige kaekena umaki ampaki puntawe. ");
INSERT INTO for_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Piya puguna, Yosepeba Tebiti ayabamagana, Tebiti kumati wakena pumagina, Karariya-i Nasareti kumatasa atategina, Yutiya maru wama Petariyamu kumati wantiye. ");
INSERT INTO for_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Pigoya, Yosepeba wama, maekena pome nkaragawaepa Mariyapa aga'entaga, ababute Petariyamu wama mintusuguna, ");
INSERT INTO for_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","pi ntaga yakari potakenakana aboraogana, ");
INSERT INTO for_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","masinto amaru yagara yakari potantiye. Yakari potamagina, kairasa asagakokima, purumakankama ntamapi naninta amume tu'napi ataogana mintantiye. Pigoyema, kana wasana waikena namapa pumaewaogana, ae mikena maru kampa waintogana, piya puntiye. ");
INSERT INTO for_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Pigoya, pi nkauka'iba ka'isa sipisipi kabiyume kina pita'i mimagini, sipisipira aseka kaburi kabima mintuguna, ");
INSERT INTO for_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wa'egawama nkenisorewama igeti tumpa aboraogana, Wa'egawama nke'wasaenawampa ke i'ma iyakogini, agategini iyekuru puntawe. ");
INSERT INTO for_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Aibuguna, kana enisore yagarama maya uwaimintiye: Tigeba a-tiyekuru puma abiyo. Naeba aogi kamana maete tigeti tumuwe. Kana maete tumo kamana'amaba a'ya'ma kinati wakini, abima tabera i'mu pikibewe. ");
INSERT INTO for_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pigoya, Tebiti kumata iba asenabinti, ti'ima aogi puritakena yagara yakari potagina, Karaisiti, Wa'ega Yagara, aeba ago aboraye. ");
INSERT INTO for_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Piya, kana inamugantoba taberaberasa akarakimagini, purumakankama ntaninta tu'napi atama mintakiya, tigeba wama agantiripa urimo kamanapa napiyiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Piya yogana, mantabintisa uwoma enisore kina'mi aege aboramagini igeba inirasa Koti nkage maya uma asagayuntawe: ");
INSERT INTO for_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Inati mantari Koti ta'mu potano. Aeba mabisa kina a'mu puwaitamagina, paruyena aborama imiye, piya untawe. ");
INSERT INTO for_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Enisore kina'mi ini piya utegini, pabita itate mantari intawe. Igasuguni, kana sipisipira kabiyume kina'miba maya untawe: Karu'ena maeyigi, Petariyamu-i wama Wa'ega Yagarama nkuramemintana uma agano, untawe. ");
INSERT INTO for_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Piya utegini, igeba karu'ena wamagini, Mariyake Yosepeke uma isigaumepa, kana inamugantoba purumaka ntaninta tu'napi waita mintogini uma agantawe. ");
INSERT INTO for_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Uma agategini, igeba kana enisore yagarama yagarantoga yome kamanaka uwaisimuguni, ");
INSERT INTO for_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ka'isa kina'miba kabiyume kina'mi yume kamanaka abite, uwoma nkigi napintawe. ");
INSERT INTO for_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Napiyuguna, pigoyema Mariyaba kana kamana kampa agegu'a punta, aeba napi napi puntiye. ");
INSERT INTO for_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Piya pogini, sipisipira kabiyume kina'miba a'wae puma wamagini, a'ya'waemaena abima aganta kamana napimagini, Kotika i'mu potama age asagayuntawe. ");
INSERT INTO for_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pigoya, tonaentisa kakaga umaema yaga a'ya puwaogini, au kasagasima agewapa Isuwe omintawe. Kana agewapa, kampa aga'e puntogana enisore yagarama pai omome nkagi, omintawe. ");
INSERT INTO for_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pigoya, togana Isuke anoke isibabuma ma'ataome ntagaba aboraoginisi, Mosese kamana ago kamana wasiyu'maginisi, ano aba Isu ababute Yerusaremi kumati imaginisi Wa'egawama nkaora atakena puntase. ");
INSERT INTO for_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Piya, Wa'egawama nkawamupisa ago kamana mayama waintantiye: Pipa kamaru masi aborakanapa Wa'egawama nkaora atao, iye. Piya unti kamana abi u'ma piya puntase. ");
INSERT INTO for_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Piya pumaginisi, pi nkago kamana wasiyu'ma Wa'egawama mpono awa'ena, pipa tara pupunta tarawo, intanuma awararawo, kaema agunta abasa atakena maete wantase. ");
INSERT INTO for_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Pigoya, Yerusaremi kumata ka yagara mintantiye. Agewapa Simiyoni, aeba miyomentanawapa aogima mima Kotiti agupa amintiye. Piyama, Isureyo kina igeti aogi puwaitakenaena aborakibika, kana yagara aobi puma mintogana, Aota Awamusa'ama agupi pumaema mintantiye. ");
INSERT INTO for_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pigoya, ago pai Awamusa'ama maya omintiye: Kaeba toganaba Wa'egawamatisa Karaisiti aborakana, agate purikibene, piya omintiye. ");
INSERT INTO for_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Pigoya, pi ntaga Awamusa'ama Simiyoni: Tabe mono namapi iyo, omintiye. Omogana abite iyoginisi, anoge abage kamana ago wasiyu'ma Isupa ababurite kana namapinti ima Koti nkaora atakena pusuguna, ");
INSERT INTO for_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simiyoni Isu uma ababurintana, Koti nkage asagayuma a'mu puntiye. ");
INSERT INTO for_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","A'mu pumagina, aeba maya untiye: Wa'egawo, naeba kayokaya yagaragapa, naonepisa kaetisa aogi puratakena yagara agaogana, mampabi mikenaenanepa a'ya piye, iye. Pai utampe kamanakaga napima agaogana, nantawama paru piye, iye. ");
INSERT INTO for_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kaeba mono maga maga kina'mi ige'ena iba aborane, iye. ");
INSERT INTO for_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Isureyo kinakaba taetiba e'wasaena aboragi ta'mu pune, Simiyoni piya untiye. ");
INSERT INTO for_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Isuka piya yoginisi, anoge abage isigeba uwoma nkisigi napintase. ");
INSERT INTO for_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Piya, Simiyoniba igepa akayona puwaitamagina, kana yagarantowampaka Mariya mayama omintiye: Abeno. Ma ntagara aepisa Isureyo kina pako pikibeka Koti ago untine, iye. Uwoma Isureyo kinapa aetasa asesepa'ma ware'nakibewe, iye. Piya, ka'isa kina igeba aeti uma atokaema asikibewe, iye. Pi ntagaraba uwoma kina'mi ntapikenaenawaipa aborakiye, iye. Piya, aeba Kotipisa aboragini, aeka uwoma kina'miba imo kamana otaigina, pigo kaegapa tabera kantara pikibene, Simiyoni piya omintiye. ");
INSERT INTO for_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Pigoya, ka Koti kamana uwaimi punti nkwae, aeba Panuwero nkaraga, Asa pi nkiga'nabisa aboranta wae, agewapa Ana, ago aenta tantiye. Pigoya, aeba iba'ena kasatauguna, tonaentisa tara umaema kabo awaege mintogana pu'waogana, ");
INSERT INTO for_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","aeba uwa mimagina 84-wa kabu aentarama mimagina, a'ya'ma yaga tabe mono namapi ampima, asenabintibe arape nanintagaba kampa napinta, Kotiti napi napi puma mintantiye. ");
INSERT INTO for_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pigoya pabi ntaga mintogini, Yerusaremi aogi pukena yagaraga ka'isa kina'mi aobi puma mintantawe. Mintuguna, pabi ntaga kana aentaba ampimagina, Koti a'mu potama, aobi punta kinapa: Aobi pompe ntagaraba ago aboraye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Pigoya, Wa'ega Yagarama nkago kamanaka a'ya'ma pugaitegini, Karariya Nasareti kumati wa'ewaiti wantawe. ");
INSERT INTO for_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wama umiyuguna, kana yagarantoba pita anosama, esegi pogana, Koti a'muntana potamagina tabera aogi napiyena amintiye. ");
INSERT INTO for_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pigoya, a'ya'ma kabo yagaba anoge abage Yerusaremi wama, Isureyo kina iyo'maenti kana aboraoginisi wantase. Pi i'mu punta ntaga nkagewapa Pasoba naninta nakena yagawe. ");
INSERT INTO for_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Pigoya, Isuba nagisarisa tara tumpaema kabo miyomekana, kana i'mu pumeti ababute wantase. ");
INSERT INTO for_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wama mintusuguni, pigo i'mu taenaba iso'ma nagaitegini, wa'ewaiti wauguna kana yagaranto Isuba pabi Yerusaremi mintantiye. Aeba mintoginisi anoge abageba: Aokinake wagasayema, napima wantase. ");
INSERT INTO for_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Wausuguna, ka yaga a'ya waoginisi aguyosakate, to ka'isa aokina ibigausuguni: Kampaye, untawe. ");
INSERT INTO for_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Piya yugunisi to a'wae puma Yerusaremi kumati to wama aguyosagantase. ");
INSERT INTO for_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Aguyosagausuguna, kakaga yaga a'ya waoginisi mono namapinti asu agama abatantase. Pigoya, aeba ka'isa mono tisa kinake mintogini, ka'isa kamana abigauguna aeba yume kamanapa aogima a'wae puma uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Piya uwaimogini abite a'ya'ma pi kina'miba pami puntawe. ");
INSERT INTO for_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Piya pugunisi, anoge abageba kana kamana abite pami puntase. Pigoya, anowampa maya omintiye: Yagarawo, nanaga piya pekara tasigeba kaguyosa'ma tasu nkairaporuse, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Piya yogana Isu maya omintiye: Nanaga naguyosagase. A'yugu naeba nabanempa ntamapinti kampa misanaga mintuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Piya yogana, anoge abage kana yome kamanapa isigeba kampa aogima abintase. ");
INSERT INTO for_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pigoya, Isu aeba isigege irosa'ma Nasareti kumati wama isige kamana abibebe puntiye. Piya pogana, anowampaba kanaenaga napi napi puntiye. ");
INSERT INTO for_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Aibogana, Isuba aupe napiyenawape anosaogini, wasanamibe Kotibe agauguna aogi puntiye. ");
INSERT INTO for_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Pigoya, Aroma kina'mi kiye yagara, agewapa Taebiriyasi, aeba nagisa ka'amu kabu kabiwaitama miyogana, Pontiyasi Pairati Yutiya mara kabiyogana, Erotiba Karariya mara kabiyogana, a'nantowampa Piripiba Ituriya mabe Tarakonaitisi mabe kabiyogana, Arisaniyasiba Abirini mara kabima mintoginisi, ");
INSERT INTO for_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","pigo Anasige Kayapasigeba mono kiye yagarara mintantase. Pigoya, pi kanabi Koti kamanapa Yoniti tumintiye. Kana yagaraba Sekaraya ntagaragana ka'me mpari mima, pi kamana abintiye. ");
INSERT INTO for_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Abigaite, a'ya'ma Yontani waninkama maroteri materi nasima maya uwaimintiye: Aguntaenaripa kaitegiripa a'wae puma wani pasigina, Kotiba aguntaenaripa maerigaikiye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Pigoya, poropete Aisaya pika kamana agoba pai maya uma kaemarantiye: Awaga kamana ukena yagara ka'me mpari mima kega'e uma mayama aboraye: Wa'egawamanta ke i'ma, arupu puma amuyena piyo, iye. ");
INSERT INTO for_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Aigubunta'enaba ku'ma amuyena pumagiri, a'ya'ma tabe amupe amara nkamupe akusamagiri, antage nantage kipa maema asoya puma, arupu pumagiri, atumite asite punti kipa parakaba'magiri, a'ya'ma aogi piyo, iye. ");
INSERT INTO for_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Piya, a'ya'ma kinapa Koti tababuma aogi puratakena yugawapa agakibewe, piya uma kaemarantiye. ");
INSERT INTO for_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pigoya, uwoma kina Yoniti mono wani pasikena kanauguna maya uwaimintiye: Tigeba kuya awarorawe. Koti tisa amo'ena aborarimekiri kakagaisanaga kebaya urimegiri mata'iba kanawe. ");
INSERT INTO for_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Tigeba aguntaenaripa kaitegiri tigu a'wae pigina mono au'wapa aborakiripa, wani kanara maekibewe. We, tigeba: Abara'amu nkaga'nuraga aogima mikunemagiripa, a-ntapima yiyo. Pabigo urimekiri abiyo: Kotiba ma ntabatasa Abara'amu nkaoso aga'nugi iba pikenaba agantiye. ");
INSERT INTO for_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Piya, ya agayukena tupa ya agobi atantiye. Pi ntawama nka kampa aogima aekanaba, agaiyuma yakupi kaekiye, Yoniba meto kamana piya untiye. ");
INSERT INTO for_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Piya yogini, kana wasanamiba mayama abigantawe: Taeba aya pukunema, abigauguna, ");
INSERT INTO for_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","aeba maya untiye: Kai tara waintakanaba, ka yagara kaiba kampa waintakanaba ameno. Nanina waintakanaba, kampa waintakibi ntagara ka'isa ameno, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pigoya, ka'isa takisi maeyume kinapa kanama mono wani pasikenaga abigamagini maya untawe: Tisawo, taeba aya pusune, untawe. ");
INSERT INTO for_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Piya yuguna, aeba: Tigeba takisiba maekibe nkawa maeyiyo. Toba a-nkagasima maeyiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Piya uwaimogini irebu kinapa kanama: Taeba aya pusunema, abigantawe. Abigauguna, aeba maya uwaimintiye: Tigeba to kinapa imiyo'enaba a-puma, yabankaipa a-mpaemagiri, kampari kotiyenaba a-puma, yabankaipa a-mpaeyiyo. Pabi ikantanari maemagiri uwa miyiyo, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Piya yogini, kana wasanamiba Yoni yome kamanaka abimagini a'ya'ma pi kina'mi mayama napintawe: Aeba aobi pompe ntagara Karaisitiwema, Yonika untawe. ");
INSERT INTO for_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Piya yuguna, Yoni a'ya'ma kinapa maya uwaimintiye: Pigoya, ka yagara naka'i kanakibi ntagaramaba, agewapa asunagasima waintika, naeba mayamanaba agisa anapa kampa akubo agaikuwe. Piya, naeba wanitasa paititauwe. Aeba Aota Awamusatasage yakutasage paititakiye. ");
INSERT INTO for_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aeba aka maete kanama, witi naninta ampa aigaga pumagina anonkapa namapi atantana ariwapa tayaba yakupi kaegaikiye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Piya uwaimintana, Yoni to mono to mono aogi kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Pigoya, tabe kiye yagara Eroti, ae a'nantowampa nkwae Erotiyasi maeyogana, Yoniba: Mantanabe to ka'isa ataenagape a-po, omintiye. ");
INSERT INTO for_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Omogana aeba to tabera ata agi napintiye. Piya, piya yomeka Erotiba abitegina, Yonipa araku'magina iga'na namapi atantiye. ");
INSERT INTO for_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pigoya, a'ya'ma pi kina wani pai'itantana, Isuge pai'atantiye. Piya pogana aeba nunamu yogana, manta a'waiyogana, ");
INSERT INTO for_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Aota Awamusa'ama pupunta kanta purite aeti tumintiye. Tumogana pi mantabintisa maya kamana tumintiye: Kaeba nae nabugami ntagaranekawe. Tabera na'mu pugatauwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Pigoya, Isu 30 kabu mimagina, yogawapa agobintiye. Pigoya, wasanamiba aekaba abugunaba Yosepe ntagara kanta puntiye. Piya, Yosepe aeba Irai ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Piya, Irai aeba Matati ntagarawe. Matati aeba Aribai ntagarawe. Aribai aeba Merikai ntagarawe. Merikai aeba Yanai ntagarawe. Yanai aeba to Yosepe ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Piya, pi Yosepe aeba Matatayasi ntagarawe. Matatayasi aeba Emosi ntagarawe. Emosi aeba Neyamu ntagarawe. Neyamu aeba Esirai ntagarawe. Esirai aeba Nagai ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Piya, Nagai aeba Meyati ntagarawe. Meyati aeba to Matatayasi ntagarawe. Pi Matatayasi aeba Semeni ntagarawe. Semeni aeba Yoseki ntagarawe. Yoseki aeba Yota ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Piya, Yota aeba Yowanani ntagarawe. Yowanani aeba Aresa ntagarawe. Aresa aeba Serababeri ntagarawe. Serababeri aeba Siyatiyeri ntagarawe. Siyatiyeri aeba Nerai ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Piya, Nerai aeba to Merikai ntagarawe. Pi Merikai aeba Erai ntagarawe. Erai aeba Kosamu ntagarawe. Kosamu aeba Erimetamu ntagarawe. Erimetamu aeba Eya ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Piya, Eya aeba Yosuwa ntagarawe. Yosuwa aeba Eriyesa ntagarawe. Eriyesa aeba Yorimu ntagarawe. Yorimu aeba to Matati ntagarawe. Pi Matati aeba to Aribai ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Piya, pi Aribai aeba Simiyoni ntagarawe. Simiyoni aeba Yuta ntagarawe. Yuta aeba to ka Yosepe ntagarawe. Pi Yosepe aeba Yonamu ntagarawe. Yonamu aeba Eriyakimu ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Piya, Eriyakimu aeba Mereya ntagarawe. Mereya aeba Mena ntagarawe. Mena aeba Matata ntagarawe. Matata aeba Netani ntagarawe. Netani aeba Tebiti ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Piya, Tebiti aeba Yesi ntagarawe. Yesi aeba Obete ntagarawe. Obete aeba Powasi ntagarawe. Powasi aeba Samoni ntagarawe. Samoni aeba Nasoni ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Piya, Nasoni aeba Aminatabu ntagarawe. Aminatabu aeba Atimini ntagarawe. Atimini aeba Anai ntagarawe. Anai aeba Esironi ntagarawe. Esironi aeba Perese ntagarawe. Perese aeba to Yuta ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Piya, pi Yuta aeba Yekobu ntagarawe. Yekobu aeba Aisaki ntagarawe. Aisaki aeba Abara'amu ntagarawe. Abara'amu aeba Tera ntagarawe. Tera aeba Neyo ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Piya, Neyo aeba Seraki ntagarawe. Seraki aeba Ariyu ntagarawe. Ariyu aeba Pereki ntagarawe. Pereki aeba Iba ntagarawe. Iba aeba Sira ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Piya, Sira aeba Kenani ntagarawe. Kenani aeba Apakisati ntagarawe. Apakisati aeba Semi ntagarawe. Semi aeba Nowa ntagarawe. Nowa aeba Arameki ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Piya, Arameki aeba Metusara ntagarawe. Metusara aeba Inoku ntagarawe. Inoku aeba Yereti ntagarawe. Yereti aeba Ma'arariyo ntagarawe. Ma'arariyo aeba to Kenani ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Piya, pi Kenani aeba Inosi ntagarawe. Inosi aeba Seti ntagarawe. Seti aeba Antamu ntagarawe. Piya, Antamu aeba Koti ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Pigoya, Yontani wanipi Yoni Isu wani pai'ataogana, Awamusa'ama agupinti pumaewama, ka'me mpari ababute wantiye. ");
INSERT INTO for_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Wama 40 yagaba umintogana, kewama pi ntagaba amiyo potantiye. Aibogana, naninta kampa nanta i'mintogana, aga'ena abugaogana, ");
INSERT INTO for_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","kewama aeti aborama maya omintiye: Kaeba Koti Ntagara mintanapa, yegana ma ntabaka paretiyena pekana nao, untiye. ");
INSERT INTO for_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Piya yogana, Isu antota maya omintiye: Koti kamana'ama maya iye: Wasanamaba nanintarasaba kampa a'ya'ma esegiyenawapa maekiye, iyema, omintiye. ");
INSERT INTO for_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Piya omogana, kewamaba ababurite inati imagina, a'ya'ma mampabisa kinapa asu aro ntaganto ayakimagina, ");
INSERT INTO for_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","maya omintiye: A'ya'ma ma nkesegiyenabe igaenabe nae namiwaentine. Pigoya nae napima ka'waina amikenaba amukuwe. Piya, kaepa kamukuwe. ");
INSERT INTO for_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kaeba nae nageba asagayuyegapa pi a'ya'waemaena waintintanaba kae'enaena puwaewakiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Piya yogana, Isu antota uma maya omintiye: Koti kamana'ama maya iye: Wa'ega Kotigapa, ae age asagayuma, ae abiwa kayokaya'ena potao, iyema, omintiye. ");
INSERT INTO for_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Piya omogana, kewama Isu Yerusaremi kumati ababute ima, tabe mono nama nkagari mesutama maya omintiye: Kaeba Koti Ntagara mintanapa, matasa pa'yo puma tumo. ");
INSERT INTO for_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Piya, Koti kamana'ama mayama iye: Kotiba aeba enisore kina'wa uwaitakana kabigatama kao'maekibewe, iye. ");
INSERT INTO for_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Piya, kaegukena pukibipa, iyatasa kababute tumigina, yabankamaba kagisaba kampa arisakiye, iyema, untiye. ");
INSERT INTO for_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Piya yogana, Isu antota uma maya omintiye: Koti kamana'amaba to ka maya iye: Kaeba Wa'ega Kotigapa amiyo puma agakenaenaba a-po, iyema, untiye. ");
INSERT INTO for_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Piya yogana kana amiyo'ena a'ya waogana, kewama Isupa atate migarakena wantiye. ");
INSERT INTO for_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pigoya, Aota Awamusa'ama Isu esegiyena amogana, Karariya-i to wama yogawa pogini, a'ya'ma pi nkauka'isa kina'mi ae awaga kamanapa abintawe. ");
INSERT INTO for_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Aibuguna, aeba mono namapinti imagina, kamana uwaimogini i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Piya puguna, uwaena yagaranto Isu mima anosanti mpari Nasareti wantiye. Pita'i a'ya'ma sabati yaga mono namapi ibomeka, ka yagaba ima Koti kamana aisikena asiyogini, ");
INSERT INTO for_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","aepa poropete Aisaya kaemaranti nkisa amintawe. Amuguna maema aparotama, maya kamana waintogana uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Pigoya, Wa'egawamatisa Awamusa'ama nae nantabinti tumegina, aogi kamana uwa kina uwaimo unatantiye, iye. Piya, to wainaga araku'ma upebe punta kinapa atagana wanoma, iyorikaenta kinapa iyogawai taoma, atabi mpiye kinapa aogima mikibewe, uwaimomagina, naisagagi tumuwe, iye. ");
INSERT INTO for_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Piya, Wa'egawama aokina aogi puwaitakibe ntagagaba, awaga kamana yoma unatagi tumuwe, iyema, Isu esapisa kamana piya untiye. ");
INSERT INTO for_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Piya ugaitegina, aeba kana esa akarakima amome ntagara amite mara'miyogini, kana mono namapi mintume kina'miba: Ae kamana'wa ukena piye, utegina, iyoba araga aragama agauguna, ");
INSERT INTO for_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","aeba mayama agobima uwaimintiye: Ago uriminta kamanapa au'wapa ibanto aboragiri abewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Piya yogini, igeba awamupisa iga kamana'wapa abima pami pumagini: We, aeba Yosepe ntagarawe. Ayamabaya aogi kamanapa iye, untawe. ");
INSERT INTO for_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Piya yuguna, Isu maya uwaimintiye: Tigeba obisobi kamana naeka maya yepa: Tusa yagara kae kauka aogi pega kagano. Piya, Kapaniyamu kumata yoga puntampe nkawaga kamana abune. Pabiyama magata pega agano, piyama nabigakibewe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Piya uwaimintana Isu to maya untiye: Naeba taga kauwe. Koti unti kamana yemi poropete yagarama kamana'wapa mawatasa kina'miba kampa abima aegarakibewe. ");
INSERT INTO for_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pigoya, naeba tagaka urimuwe. Iraiya mintome kanabi, kaboba kakaga pumagina opa tonaentisa ka'umaema u, kampa ka aemagina, pa tawaogana kaboba tabera pumagina, a'ya'ma kina iga'enaba tabera ibuntiye. ");
INSERT INTO for_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ibogini, pi ntaga Isureyo abeya waepa uwoma mintuguna, igetiba Koti Iraiyapa kampa agarubantiye. Ae'wa nkaokinatiba kampa agarubantiye. Aepa Saironi mara Sarepata kumati ka namu'isa abeya waeti agarubaogana, wama naninta nantiye. ");
INSERT INTO for_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Piya Iraisa mintome kanabipa, Isureyo mara uwaena karu kina mintuguna, kampa ita wantiye. Piya, ka Siriya marisa yagara, agewapa Naemani, abiwapa Iraisati waogana kaba ataogana anamopa ata wantiye, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Piya uwaimogini, a'ya'ma mono namapinti mintume kina'mi ka abi'ma, ");
INSERT INTO for_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","pi kina'miba kumawaitisa agarubakena pumepa irosa'ma ige kumati amuti ababute ima au'yari apasanakaikena puguna, ");
INSERT INTO for_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","aeba abakapinti uwigasi ankigasi putagina wagaintiye. ");
INSERT INTO for_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Pigoya, Isu Karariya mari tumima, Kapaniyamu kumata wantiye. Wamagina sabati yagaba waya'wa kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kana kamana uwaimomepa kiya kina'mi yumesa kamana yogini abite pami puntawe. ");
INSERT INTO for_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Pigoya, pi mpono namapinti ka yagara, ke kina antabaipinti minta yagara, aege mintuguna, aeba tabera kega'e uma maya untiye: ");
INSERT INTO for_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","We Isugaba, Nasaretirisa yagaragawe. Taegukena kanapaya, nana puratakena kanane. Piya, naeba ago abopa, kaeba Kotitisa aota yagaragawe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Piya yogana, Isu ka abi'ma maya omintiye: Paka pumagina, atate irosa'ma wagaso, omintiye. Omogana, ke kina'maba kana yagara apasara pomepa, kampa aupa airisanta uwa irosa'ma wagaintiye. ");
INSERT INTO for_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Piya pogini, kana pi kumata mintume kina'miba pami pumagini, mare-u me-u puma maya untawe: We, aeba nana kamana iye. Aeba esegiyenawapisa kiya kina'mi usu kamana uma ke kina uwaitagini atate wagasawe, piya untawe. ");
INSERT INTO for_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Aibogini, pintana pome kamanapa urite, a'ya'ma pi mari wagana kana puntawe. ");
INSERT INTO for_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Piya puguna, mono namapisa iro'ma, Saimoni ntamapinti iyomepa Saimoni aentawampa nkau yaku taogana mintogana, Isu yoninkapa: Kaba ataoma, abigantawe. ");
INSERT INTO for_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Abigauguna, aeba agora ampagina yoninkapa: Ata wao, yogana ata wantiye. Ata waogana, kana wae'maba asima naninta maema imogini nantawe. ");
INSERT INTO for_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Pigo papa tupasikena pogana, ka'isa iyokina'miba tonarona inu ibome kinapa ibabute kanagana puguna, Isuba a'ya'ma i'nota ayapa ataogana, ita wantiye. ");
INSERT INTO for_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Piya pogana ke kina wasanami nkintabaipintisa igarubakasogini, igeba irosa'ma kega'e uma: Kaeba Koti Ntagaragawe, untawe. Pigoya igeba: Isu aeba Karaisiti yagarawema, napiyuguna, to mare-u me-u pusanaga akunkitantiye. ");
INSERT INTO for_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pigoya, Isu abayara itate ka'me mpari waogini, ka'isa kina'miba aguyosa'ma aeti wamagini: Taege mikibene, uma arakuruguna, ");
INSERT INTO for_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","aeba maya uwaimintiye: To ka'isa kumatiba naeba Koti kabiratakena aogi kamanapa uwaimoma unatagi kanauwe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Piya uwaimite Yutiya mari mima, a'ya'ma auka'i mono namapinti kamana uwaimita nasintiye. ");
INSERT INTO for_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pigoya, ka yagaba Isuba Kenesareti kotu nkawamori umima Koti kamana yogini, wasanamiba ampa aki puma airakiraki puma ampa abintawe. ");
INSERT INTO for_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Piya puguna Isu agaomepa, wanipisa kare tara kotu nkawamori waintusuguni, kana inoyanta aeyume kina'miba iro'ma tumima kuko wanipi aemiyuguna, ");
INSERT INTO for_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","aeba Saimonintana wanipisa karebi ima asu mintana, Saimoni maya omintiye: Awamorisaba paibumanto pubasa naigina wano, yogini pubasana'ma metauguna, aeba kana wanipisa karebi mara'mima pipisa a'ya'ma awamori mintume kinapa mono kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Piyama kamanapa uwaimitegina, Saimonika maya omintiye: Tigeba wani nkakanti wamagiri, kana kukotipa metama inoyanta aeyiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Piya yogana, Saimoni maya untiye: Tabe Yagaramawo, taeba asekapa tabe yuga pumiyompepa, kana inoyantaba kampagi aeyune. Piya pompeka, kae yempekaba kukopa atama agakune, untiye. ");
INSERT INTO for_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Utegina, kopa wanipinti motantawe. Piya pumepa, uwoma inoyanta ira'waiyogini, kana kupa kunta puma ae'mutikena pogana, ");
INSERT INTO for_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","igeba iyokinaka to ka wanipisa karebi mintuguna, kega'e yuguni, kanama ampa iyo'maema, tarayaga wanipisa karebi uwaena atauguna, kana wanipisa kareba kunta puma ipirintakena puntase. ");
INSERT INTO for_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Piya pogana, Saimoni Pitaba pintanaba agategina pami pumagina, Isu nkagisabi arakabima parokaema maya untiye: Naeba uwa agunta yagara mintuwe. Wa'ega Yagara, kaeba uwa natate wao, untiye. ");
INSERT INTO for_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Pipa nanagawanane. Inoyanta maeyumeka aekuru pogini, pi aokina'mibe pabiyama iyekuru puntawe. ");
INSERT INTO for_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Piya pogana, tara yagarara Yemisige Yonigeba, Sepeti ntagara tara, isigegeba isiyekuru pusuguna, Isu mayama Saimoni omintiye: Kaeba a-kaekuruba po. Aintiba inoyanta aeyempesa puma wasana iba pikibene, piya omintiye. ");
INSERT INTO for_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Piya omogini, igeba wanipisa kareba pubasanama kepiyati me nkatama, a'ya'waemaenawaipa kaite Isu nkaegarantawe. ");
INSERT INTO for_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Pigoya, Isuba ka kumata mintogana, ka yagaraba a'ya'ma aupintiba karuyena abome ntagarama Isu agate, aowarisa mabi parokaema maya untiye: Wa'egawo, kaeba kabemika kaba natakena puntanapa aogi punatao, untiye. ");
INSERT INTO for_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Piya yogana, Isu aya parosuma auta u'ma maya untiye: Piyaenaga nabiye, untiye. Piya umagina: Pabigo kata wakana aogima miyo, untiye. Piya yogana, pabi ntaga kana karuyenawapa atawantiye. ");
INSERT INTO for_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Atawaogana Isu esegima maya omintiye: Kaeba uwa kinapa a-nkuwaimima, marupa wama kaupa mono kiye yagara uma ayakegana agano. Piya, kata wamikaba pai Mosese uramintintanaba Kotiti amegini, wasanamiba kagate: Aoso yagara miyema napikibewe, piya omintiye. ");
INSERT INTO for_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Aibogini, a'ya'ma Isu pomentanaga wasanamiba mare-u me-u puta nasuguna, uwoma kina ampa kamana abekana yonintanaba kaba atagaikiye, piya uma aeti kanantawe. ");
INSERT INTO for_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Aibuguna, pabigo itategina ka'me mpari wama nunamu untiye. ");
INSERT INTO for_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Pigoya, ka yagaba Isu mono kamana uwaimima yogini, Karariya marisabe Yuta marisabe Yerusaremi kumatasabe, ka'isa Parasi kinake kamana ago abinta kinake, igeba pitisa kanama wasana abakapi ampintantawe. Ampintuguna, Wa'ega Yagaramapisa yoni kaba itakena esegiyenawapa Isu ago maentiye. ");
INSERT INTO for_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Piya maeyogana, ka yagaraba agisa aya pu'wanta yagara, ka'isa kina'mi wasa yara wasirite kanamagini, Isu nkagora me nkatakena kanaumepa, ");
INSERT INTO for_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","namapa pumaewauguni, kupa kampa tantiye. Aibogini, kana yagara wasirite nama nkabobori imagini, asu akuritama, pita'isa motauguna tumima Isu nkagora tumintiye. ");
INSERT INTO for_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tumogana, Isu imatiti'enawai aeti ataume igantana maya untiye: Nao'anto, naeba aguntaenagapa maegagasuwe, omintiye. ");
INSERT INTO for_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Omogini, ka'isa mono tisa kina'mibe Parasi kina'mibe pi kamana abintini, mare-u me-u puma maya untawe: Ma ntagaraba Kotika anagiyenaba usuyenaba, aeba nana yagarawe. Koti ae abi aguntaenarepa maeragaikiye, untawe. ");
INSERT INTO for_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Piya yuguna, Isu kana napiyenawai nkigate maya untiye: Tigeba nanaga tigebipa napiyewe. ");
INSERT INTO for_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nanaenama kunta piye. Pigoya, naeba: Aguntaenaga maegagasuwe, yokabera: Asima wao, yokawe. Asima wao, yekana, kampa asima nasekiripa kagi punatakibewe. ");
INSERT INTO for_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pigoya, tigeba abiyo. Wasanama Ntagara naeba ma mpabi aguntaena maerigaikena esegiyenanepa waintiye. Pi nkinuntana naeba agarubakiri agamagiri, aguntaena maerigaikena esegiyenanekaba napiyiyo, uwaimintiye. Piya uwaimintana, a'wae puma agisa aya pu'wanta yagaragaba maya omintiye: Naeba ugamota, kaeba asima wasagapa aesagabite wa'egati waoma, omintiye. ");
INSERT INTO for_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Piya omogana, karu'ena asima waitamiyome wasawapa aesagabite wa'ewati wantana, Kotiti a'mu potantiye. ");
INSERT INTO for_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Piya pogini, uwoma kina'miba agate pami puma, Koti nkage asagayuma: Ibasa yagaba nanabaya agaune, untawe. ");
INSERT INTO for_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Pigoya, pabi ntaga togana Isuba waomepa, takisi maeyome ntagara, agewapa Aribai, takisi opisibi mintogana, isu: Ampa naegarao, omintiye. ");
INSERT INTO for_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Piya omogana, asima a'ya'waemaenawapa atategina wama Isu nkaega'ma wantiye. ");
INSERT INTO for_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Aega'ma wama, Aribaiba namankapi tabe naninta Isupa kaema amintiye. Piya pogini, uwoma takisi maeyume kinape to uwa kinape isigege ampa mara'mima naninta nantawe. ");
INSERT INTO for_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Piya puguni, Parasi kina'mibe mono tisa kina'mibe Isu abagi kinaka uwoma kamana maya untawe: Nanaga takisi maeya kina'mige to aguntaena pe kina'migeba igebe nanintaba nawema, abigantawe. ");
INSERT INTO for_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Piyama abigauguna, Isu maya untiye: Wasanami kampa yoni nkibemi kina'miba tusa yagaramati kampa wawe. Yonintana ibemi kina'mi mana igeba wawe. ");
INSERT INTO for_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Piya pemisa puma: Aogi kinatawe, ye kinapa aogi puwaitakenaba kampa tumintuwe. Naeba agunta kina igu a'wae pikibeka uwaimikena tumuwe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Piya yogini, kana wasanamiba Isuka maya omintawe: Yoni nkabagi kina'miba uwoma ntaga nanintaba kampa nanta, a'a-o uma nunamu yewa, Parasi nkaokina'migeba pabiya pewe. Pigoya kae kabagi kina'miba nanintabe wanipe asi nasi a'yugu nawe, piya omintawe. ");
INSERT INTO for_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Omuguna, Isu maya uwaimintiye: Pigoya, wasanami iba'ena puntiniba, a'ya'ma kina'miba nanintaba kampa a'a-o ukibewe. Igeba naninta naiginaba, iba'wae'ma nkawaewampa uwa mikibipa, pipa kanarane. ");
INSERT INTO for_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pigoya, ainti iba'wae'ma nkawae ampa arakurite ababute to mari wagasiginiba, pi ntagaba ao'miba intara puma kampa naninta nanta uma mima aeka napikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Piya untana, Isu meto kamana pika maya uwaimintiye: Wasanama abara kai atugekanaba, to aoso kairasaba kampa kasama pitapa motama pugunikiye. Piya pukibipa pi abara kai to atu'wakanaba, ka aogi kai kampa waikiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Piya untana to maya untiye: Piya, wasanamaba kasa waini wanipa paisa yaga au'aribi kampa arigikiye. Piyama paisa yaga au'aribi arigikibemipa, namagima aiguriwakiye. ");
INSERT INTO for_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Piya, wasanamaba kasa wainina pabi kasa yaga au'aribi arigiye. ");
INSERT INTO for_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Pigoya, wasanama paisa waini nagaiteginaba, toba kasa wainigaba kampa abiye. Aeba: Paisaenarepa aogiyenawe, iyema, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pigoya, ka sabatirapa Isu witi yugabinti waogini, abagi kina'wampi kana witiba maema iyasama nantawe. ");
INSERT INTO for_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Piya puguna, ka'isa Parasi kina'miba igate maya untawe: Tigeba sabatirapa akumparanta'enaba nanaga piyaba pewe, untawe. ");
INSERT INTO for_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Piya yuguna Isu maya uwaimintiye: Tigeba kampa napiyewo. Tayabama Tebitige aege miyume kina'mige iga'ena ibogana puntikaba aisumagiri kampa abewo. ");
INSERT INTO for_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Aeba Koti mpono namapinti ima, Kotika napima ataume pareti asu maentiye. Pigoya, pi paretiba uwa kina'miba kampa nakenawe. Mono kiye kina'mi ibiwai nakena atanta pareti asu maema akobuma, a'ya'ma uwa aokinapa imogini nantapa kanarane, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Piya untana, Isu to maya untiye: Wasanama Ntagara naeba pabiyama sabatirapa kabima miyuwe, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pigoya, to ka sabatirapa Isu mono namapinti ima kamana uwaimogana, ka yagaraba ayatakantisa pu'wanta yagara mintogini, ");
INSERT INTO for_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ka'isa mono tisa kina'mige Parasi kina'mige, Isu sabatira yoni kina kaba itasanaga kamana otakena apasa puntawe. ");
INSERT INTO for_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Piya puguna, Isuba ago napiyenawaipi igategina, kana aya pu'wanta yagara: Asitaigina mata'i iyeno, yogana, aeba asima ikapi intiye. ");
INSERT INTO for_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Iyogana Isu maya uwaimintiye: Naeba tibigauwe. Sabatira ago kamanapa nanawe iye. Wasana sabatira aogi potakupera ataena potakune. Ao'maekupera aegukunema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Piya untana, a'ya'ma kinapa mare-iga me-iga puntana, kana yagaramaka maya omintiye: Kayapa aparotano, omogana, karu'ena kana ayapa aparotaogana atawantiye. ");
INSERT INTO for_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Piya pogini, kana kina'miba agate intabi ikimagini: Isupa nana potakunema, napintawe. ");
INSERT INTO for_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pigoya, pabi ntaga Isuba nunamu ukena amuti iyogana, ase yogana, pabi nkasenabinti Kotiti nunamu untiye. ");
INSERT INTO for_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Piya yogana marogana, aeba abagi kinaka igega'e yogini kanauguna, nagisarisa tara tumpaema aisuwaitama, igewaipa aposorowe uwaitantiye. ");
INSERT INTO for_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Piya, igewaipa mayamawe: Saimoni aoso ominti nkagiwapa Pitawa, ae a'nanto Enturuwa, Yemisiwa, Yoniwa, Piripiwa, Patoromayowa, ");
INSERT INTO for_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyuwa, Tomasiwa, Aopayesi ntagara Yemisiwa, namu'isa kiya kina igarubakaikena abugai ntagara Saimoniwa, ");
INSERT INTO for_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yemisa ntagara Yutasiwa, ainti Isu minaga'ena punti ntagara Yutasi Isikeriyotiwa, sumagini, abagi puntawe. ");
INSERT INTO for_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Pigoya, ibaburite igege amutisaba tumima, amura tumpa irosa'ma mintuguni, tabe uwoma abagi kinape tabe uwoma Yuta kinape Yerusaremi kinape, wani nkagorasa Taya kinape Saironi kinape, me nkaki puma kamana'wa abima yonintanawai mae igaikenaga uma aeti aki puntawe. ");
INSERT INTO for_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Aibuntini, ke kina intabinti mintome kinapa kanauguna, agaruba igaintiye. ");
INSERT INTO for_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Piyamaba esegiyenawampa iyo'maeyogini, a'ya'ma kina'miba: Yonintanarepa tatawakiyemanapimagini auta ukaya puntawe. ");
INSERT INTO for_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Piya puguna, Isu abagi kina'wa igau'ma maya uwaimintiye: We, kusi miye kina, tigeba Koti kabiritakiri, ti'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tigeba tiga'ena tibemi kina'mitaba, aintiba tiga'e pakiri, ti'muntanabi mikibewe. Tigeba ibaba kube'ena puma miye kina'mitaba, aintiba kagi pumagiri ti'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Piya, Wasanama Ntagara naeka wasanami kama puritama aruyenabisa tigaruba'magini karibi'ma agunta kamana tigeka uritaigiripa, tigeba ti'mu piyo. Ti'muntanabi mikibewe. ");
INSERT INTO for_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Piya, aintiba aogi ikantanaripa mantariba taberaka'yane. Pika pi ntagaba ti'mu puma tinta asoya puma miyiyo. Paipa iyabamagipa pabiyama poropete mintanta kinapa karana puwaitantawe. ");
INSERT INTO for_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mone tabe kuta ntaga kina, tigeba ikantanaripa ago maeyawe. Aintiba toba kampaye. Tigeba ataenabi mikibewe. Pika tintara piyo. ");
INSERT INTO for_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Pigoya, ibasa yaga tabe nakena nata nase kinapa, tigeba aintiba tiga'ena tibikiye. Tigeba ataenabi mikibewe. Pika tintara piyo. Pigoya, ibasa yaga kagi pe kinapa, aintiba tigeba kube'ena pigina tiyo'nu tumikiye. Tigeba ataenabi mikibewe. Pika tintara piyo. ");
INSERT INTO for_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Pigoya, tige maete ima i'mu puritaigiri, tigeba kampa aogima mikibewe. Paipa pi kina'mi nkiyabamagi kumpari poropete kinapa pabiyama i'mu puwaitantawe. ");
INSERT INTO for_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pigoya, naeba kamana'ne abe kina mayama urimuwa, abiyo: Tigeba kama kinatipa agu kao'ena puwaitantiri, imo purita kina aogi puwaitaiyo. ");
INSERT INTO for_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Karibi'ma ata purita kinapa ti'muntanaba puwaitaiyo. Karana purita kina igeka napima nunamu yiyo. ");
INSERT INTO for_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Pigoya, wasanama amo pugatama, ka katamara kaeguyekanapa, to ka auka'i a'wae puma amo. Piyamaba wasanama mu'mu kaiga maeyakanapa, a-kamopa puma, uwa atamagina to ka kai maekenaba a-nkakuno. ");
INSERT INTO for_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pigoya, wasanama ka'enaga esugatakanapa, amo. To wasanama ka'isaenaga maeyakanapa, to namomaba a-nkabigao. ");
INSERT INTO for_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pigoya, tigeba wasanami purataiyema tibikibintanaba, pabi nkawameta igepa puwaitaiyo. ");
INSERT INTO for_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Piya, tigeba agu kao'ena purita kina ige'amana agu kao'ena puwaitaiginaba, aintiba aya iretaripa Kotiba timikiye. Pipa kampaye. We, agunta kina'miba iyokinapa antota agu kao'ena puwaitawe. ");
INSERT INTO for_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Pigoya, wasanami aogi puritaigiripa, tigeba piyama aogi puwaitakibepa, nana ti'muntana maekibewe. Pipa kampaye. Pabi ata kina'mige pabiya puwaitawe. ");
INSERT INTO for_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Pigoya, iretari antota timikibe kinapa ireta imikibepa, ti'muntanaba nana maekibewe. Pipa kampaye. Piya pesa puma, ata kina'miba to a'wae puma ata kinapisa ireta maekena pewe. ");
INSERT INTO for_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","We, tigeba kama kinati kayone pumagiri, aogi puwaitamagiri, aogi puwaitakibentanabe imikibentanagabe antota maekenaba a-ntapiyiyo. Piya puntiripa, inatisa Tabe Yagarama ntagaraena piginaba, aintiba tabe ikantanaba timikiye. Piya, aeba wasanaba igama aekita kampa puwaitikana, uwa a'yugu kinape kampa i'mu pe kinape uwa iyo'maema, aogi puwaitaye. ");
INSERT INTO for_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pigoya, inatisa tibarimpaba antara puritamisa puma, wasanaga tintara puma iyo'maeyiyo, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Piya untana Isu to maya untiye: Tigeba to wasana aupi pima kamana a-nkuwaitaiyo. Kampa uwaitakibepa Koti tigepa pabiyama antota kamana kampa uritakiye. Pigoya, tigeba wasana aguntaenabipa a-nkitaiyo. Kampa itakibepa, Koti tigepa pabiyama aguntaenabipa kampa titakiye. Pigoya, tigeba aguntaenawai mae igasiginaba, pabiyama Koti aguntaenaripa maerigaikiye. ");
INSERT INTO for_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Pigoya, to kina ka'isaena imiginaba, Kotiba pabiyama aogiyenaba timikiye. Wasana kopa aigire pumagina awaitawamisa puma, Koti tabe puma agasiya timikiye. Piya, pabi imikibe nkawameta Kotiba a'wae puma timikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Piya untana, Isu amato puma meto kamana maya untiye: Aorikaenta yagaramaba to aorikaenta kinapa ayama kepa ayakikiye. Pipa kampaye. Kampa ayakekinisi, isigeba kaga a'abibintiba aesama isiyegukiye. ");
INSERT INTO for_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Piyama, abikena namapisa kina'miba kampa tisa kina'wapa asugasaye. Kampaye. Aeba urintanaba togana pabi tisawama pemisa pukiye. ");
INSERT INTO for_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Pigoya, kao'yagarama nkaobipa i'nintana waintakanapa, ayama agantana, kaeka kaobi ya atu waintakanapa, nanaga ae aogi potakenaga napiyene. ");
INSERT INTO for_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","We, kumpari kina, kaeka kaobi ya atu waintemipa, kaeba ayama kao'yagaragaba mayaba omegana aogi pikiye: Nao'yagara, kaeba abintaga, kaobisa i'nintanaba maegagasanoma, omegana aogi pikiye. We, kaeka kaobi ya atu waintemi, pipa marupa maegaite aogima agantana, kao'yagarama nkaobisa i'ni maegasagana aogi pikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Piya uwaimintana Isu to maya untiye: Aogi yawamaba kampa ata yamankapa aeye. Piya, ata yawamaba aogi yamankapa kampa aeye. ");
INSERT INTO for_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pigoya, a'ya'ma yamanka'ama aboragiripa, agowapa abewe. Piya, wasanamiba akenanaenabintisa kampa piki yamanka asikewe. Kabuyenarasaba kampa waini yamanka asikewe. ");
INSERT INTO for_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pabiyamaba aogi yagaramaba agupintiba aogi napiyenawapisa aogiyenaba piye. Piya, ata yagaramaba agupipa ata napiyenawapisa aeba ataenaba piye. Piya, agupi awaitanti'naba awamupisa irosaye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Pigoya, to kamana Isu maya uwaimintiye: Tigeba naeka: Wa'egarekawe, Wa'egarekawe, untiripa, nanaga nae yo kamanapa kampa abima wasiyewe. ");
INSERT INTO for_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Piya, naeti kanakibemi kina'maba kamana'ne abima wasikibipa, aepa nanara awame pusuwe. Mayama waintiye: ");
INSERT INTO for_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ka yagarama nama kikena puntanaba, maruntana puma, tako aema'ma mabinti aibirintama aegasima, u takaitasa nama kimaragina, wani pa'ma akasabakena pugagategina, esegi puwagina kuruyenaba kampa punta uwa waiye. Piya, aeba tonkiya puma kimarantiye. ");
INSERT INTO for_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pigoya, wasanama nae kamana abintana kampa wasiyemipa, aeba piyama wasanama amunta yarasa nama kimaraogana, wani pa'ma ata pogana karu'ena kana namapa akasakasu pa'wantiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Isu aeba wasana mono kamana a'ya uwaimitategina Kapaniyamu kumati wantiye. ");
INSERT INTO for_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Pita'i namu'isa irebu kina'mi kiya yagarama, ae kayokaya yagara purikena puma mintantiye. Pigoya, kana tabe yagara pi ntagaraka abogana aogi puntiye. ");
INSERT INTO for_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Piya pogana, kana irebu kiye yagara Isu nkawaga kamana abite, Yuta kina'mi paitakena kina'mi igaruba'magina: Isuti wama kayokaya yagarane yonintanawapa atawanema, uma omiyo, uwaimima igarubantiye. ");
INSERT INTO for_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pigoya igeba Isuti wama esegi kamana maya uma omintiye: Taeba kiya yagara aeka abokana aogi piye. Pika kamana'wapa abo. ");
INSERT INTO for_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Aeba agu'wapa Yuta kina taeti waiye. Pigoya, mono nama aboranemaba, aewa monepa ataogana kanarasaogana abora tamintiye, omintawe. ");
INSERT INTO for_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Piya uma omuguna Isu abite igege wantiye. Wama kiya yagarama ntamata irosakena pogana pita'isa aokina uwaitaogini, kanama Isu mayama omintawe: Wa'ega, naeba tumima mintakina mintogana, pegina kaeba a'yugu puma namantepintiba ubasikibene. ");
INSERT INTO for_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Piya, naene abogana kampa aogi pegi, kaeti ikenakaba kunta puwe. Piya, kaeba pita'i uwa mima kamana yegana kayokaya yagaranepa kabareno. ");
INSERT INTO for_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Piya, naeba ima minta kina'mi nkiwamu wasimagi, to ka'isa tumima minta irebu kina'nepa kabiyuwe. Piya, igetisa ka'wainapa: Wao uma omekanaba wakiye. To ka pa: Kanao, yekanaba kanakiye. Kayokaya yagarane: Pi ntuga po, yekanaba pikiye. Piya, kiya kina'mi yosa puma yeganaba atawano, untiye. ");
INSERT INTO for_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Piya yogana, Isu pi kamana abima kiya yagaraga napi napi puntana, a'wae pumagina a'ya'ma aega'ma kanaume kina'mipa mayama uwaimintiye: Naeba urimekiri abiyo. Isureyo kina, tigetiba ma ntagarama nkamatiti'ena piya awametapa kampagi agauwe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Piya uwaimogini, kiya yagarama aokina'miba a'wae purite namapinti ima, kayokaya yagara yoninka ata waogini agantawe. ");
INSERT INTO for_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pigoya, to ka yagaba Isu to ka kumapa agewapa Neni, pita'i waogini, abagi kina'wape wasana uwoma to kinape aege wantawe. ");
INSERT INTO for_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pigoya, wa'e ikibi kabera uma irosaogini, purinta kina ka wasi maete tumintawe. Kiya wae'ma ntagara ka'anto mima purintiye. Piya, ae kumatisa uwoma wa wayapa kaikena tumi puntawe. ");
INSERT INTO for_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tumi puguna Isuba pi kiya wae agama antara potama: A-kube'enaba po, omintiye. ");
INSERT INTO for_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Piya omogini, wasana wasaba wasi u'ma mintuguna, Isu wama wasa aukaya puma maya untiye: Masimabiwo, naeba ugamota kaogama asiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Piya yogana, purintapisa asimagina kamana untiye. Pigoya Isuba anowampage miyenema amintiye. ");
INSERT INTO for_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Piya pogini, wasanamiba agate iyekuru pumagini, Kotiti i'mu puma maya untawe: Poropete tabe yagara abakatepi aboranti mintiye, untawe. Pigoya ka'isamiba to maya untawe: Kotiba aokina tae tao'maekena kanaye, untawe. ");
INSERT INTO for_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Piya, awaga kamana Yutiya maribe to ka'isa maribe wagana kana puntiye. ");
INSERT INTO for_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Aibogana, Yoni mintogini, ae abagi kina'mi: Isu piya mayaena pome, pi kamana omintawe. ");
INSERT INTO for_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Pigoya pi kamana abite, tara yagara: Wa'ega maya uma abigaisema, isigarubantiye: Karaisitiba kanakiye untapa, kaebera, to ka'wainaka agawa pukupayawe, uwaisitaoginisi, ");
INSERT INTO for_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Isuti wamaginisi irosa'ma maya untase: Yoni mono wani paitakena yagarama maya uma tasigarubaye: Karaisitiba kanakiye untapa kaebera, to ka'wainaka agawa puma mikune, iyema, abigantase. ");
INSERT INTO for_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pigoya, Isu aeba pi ntaga to yoni kinapa kaba itantana, keba igaruba igaintana, iyorika kinapa iyo agaitantana puntiye. ");
INSERT INTO for_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Piya poginisi isigeba uma irosa'ma abigausuguna mayama uwaisimintiye: Tisigeba wamagirisi agama abeme kamana Yonipa maya omiso: Iyorika kina'miba iyo agawe. Ka miyaba kina'miba ke'i nasewe. Karu kina'miba kabarewe. Aibo kina'miba kamana abewe. Purinta kina'miba iyo agama asiyewe. Kota kampa wainta kina'miba aogi mono kamana abewe, omiso. ");
INSERT INTO for_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Piya, ka'waina naeka abima aekita kampa pikibi'naba, a'muntanabi mikiye, uwaisimite isigarubantiye. ");
INSERT INTO for_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Pigoya, Yoni nkao'yagara taraba a'wae puma wausuguna, Isu aeba wasana mintume kina'mi igepa Yonika maya uwaimintiye: Tigeba ka'me mpari nana agakena wantawe, a. Misa ka'waina pontawama maete wate kanate pogiri agakena wantawe, a. Piyaba kampaye. ");
INSERT INTO for_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Piya, ka yagara aotasaena aogiyena wantaga mintogiri agakena wantawa, a. Piyaba kampaye. Wasana aotasaena aogiyena maema miye kina'miba igeba kiye yagarama nkaogi namapi mima pita uwa miyewe. ");
INSERT INTO for_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pigoya, poropete ka agakena wantawe. Owe, piya naeba urimekiri abiyo. Wasana aganta, aeba poropete ka'isa kina'mi awametapa kampaye. Aeba to awametane. ");
INSERT INTO for_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Aeka kamana awa'ena Koti yagarawapa maya omintiye: Naeba kayokaya yagarane otagana, ae paitagatama ke i'ma aogi pugatakiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Pigoya, naeba urimukuwa, abiyo: Waya'matisa aboranti'na ka'wainaba Yonipa kampagina againtiye. Pigoya Koti kabiratakibi kanabipa tumima minta kina'nempiba Yonipa agaikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Piya, aeba piya yogini a'ya'ma uwa kina'mibe takisi maeyume kina'mibe abimagini: Koti pikibemintanaba aogiyenawe, untawe. Pigoya pi kina'mi Yoniti pai wamagini, mono wani maenta kina mintantawe. ");
INSERT INTO for_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Piya, Parasi kinake kamana ago abinta kinake igeba Koti uwaimomentanaba: A'a-o, untawe. Pigoya, pi kina'mi Yoniti wama, mono wani kampa pasume kina'miba igeba Koti kamanapa: A'a-o, otantawe. ");
INSERT INTO for_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Pigoya Isu to maya untiye: Mamparasa kina tigekaba kegita awame pusuwe. Nanarane. ");
INSERT INTO for_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tigeba yagara araga piyamawe. Igeba kumati mimagini iyo'mi mayama uwaimewe: Ini yokiripa, nana piyema kampa wa'enaba pewe. Tantara'ena puma kube'ena pokiripa, nana piyema kampa tao'maeyawe. Tigeba pi nkawametane. ");
INSERT INTO for_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yoniba mono wani pai itanti ntagara yogawa agobintanaba, ka'isa nanintabe waini wanipe kampa nanta, uwa a'a-o uma miyogiri agantiripa: Agu'ama a'yugu piye, tigeba untawe. ");
INSERT INTO for_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Pigoya, Wasanama Ntagara naeba kanama nanintabe wanipe naogiripa, nagantiri nanagabaya maya yewe: Aeba uwoma nanintabe wanipe nai ntagarawe. Takisi maeya kinake aru kinake ige iyo'yagarawe, tigeba naeka yewe. ");
INSERT INTO for_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pigoya abiyo. Mono agowapa igu'ama kintarama miye kina'mi, ige aogima aegaragiri agawe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pigoya, Parasi ka'waina Isu nanintaga agega'e yogana, nankapinti ima naninta nantiye. ");
INSERT INTO for_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Pigoya, pi kumatasa aru'wae ka'waina, Isu aeba Parasi ntamapi ima naninta naogana abitegina, aogi agunta masawae yaba kankabe wantaga ka maete, ");
INSERT INTO for_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","aka'i asima mimagina, kube'ena pogana, ao'nuwama agisari pasogana a'no nkabiyatasa aebago puntiye. Pumagina agisaba amo'nantana, agunta wanipa pai'atantiye. ");
INSERT INTO for_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Waya'ma piya pogana, Parasi yagara Isuka agega'e unti ntagara aeba antabaipinti mayama napintiye: Ma nkaepa ataena pemi waene. Piya, Isu aeba poropete miyemisinta, agowapa abibebe pemisinema, napintiye. ");
INSERT INTO for_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pigoya, napiyogana Isuba abite mayama omintiye: Saimoni, naeba kamana ka ugamekana abo, omogana: Tisa, yega abeno, omintiye. ");
INSERT INTO for_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Omogana Isu meto kamana maya untiye: Mone kina ka'waina tara yagara moneba uwa isimintiye. Ka'wainapa wanantareti tora amintiye. Pigoya to ka'waina nayatara'mu tora amintiye. ");
INSERT INTO for_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pigoya, isigeba antota amikena monega aguyosagantase. Aibusuguna, atunkisipa uwa aerawane utegina, isitantiye. Pigoya, isigetisa ka'waina mone isimintemi ntagaragaba a'mupa taberapa potakiye. Kaeba keka yenema, abigantiye. ");
INSERT INTO for_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Piyama abigaogana, Saimoni maya untiye: Mone uwoma a'a-o otantemi, aeka yuwe. Piya yogana Isuba: Kaeba kanara yenema, omintiye. ");
INSERT INTO for_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Piya ute, waya'mati a'waebuma Saimoni maya omintiye: Ma nkaepa agano. Naeba namakapinti iyoganapa, kaeba nagisari pasikena wanipa kampa atanatampene. Pigoya ma nkae aeba nagisaba ao'nurasa pai'natama a'no nkabiyatasa aebago punagasaye. ");
INSERT INTO for_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Kaeba kampa namo nampene. Piya, ma nkae aeba nagisanepa ebi ebima namo naye. ");
INSERT INTO for_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kaeba na'notiba uwa masawaepa kampa pai'natampene. Piya, ma nkae aeba nagisanepa aogi agunta masawaetasa pai'nataye. ");
INSERT INTO for_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pika ugamekana abo: Waya aeba kao'enaba uwoma punatamika, aru'enawapa uwoma asu'a pogasuwe. Pigoya, ka'waina aeba aru'enaba ise'anto asu'a potakibi naba, kao'enaba uwaenanto piye, omintiye. ");
INSERT INTO for_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Piya umagina, waya maya omintiye: Aru'enagapa asu'a pugagasuwe, omintiye. ");
INSERT INTO for_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Piya omogini, wasana naninta kaga nama mintanta kina igeba mayama mare-u me-u puntawe: Aeba nana yagara kana aru'enaba asu'a piye, untawe. ");
INSERT INTO for_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Piya yuguna, Isuba pi nkwaekaba maya omintiye: Kamatiti'enagampaba aogi pugataye. Kaeba wamagina paruyenabi miyo, omintiye. ");
INSERT INTO for_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pigoya, to ka'isa yagaba Isuba tabe kumatibe uwaena kuma'antontoribe nasi nasi puma mima, wasana aogi mono uwaimima Koti kabiratakena kamana uwaimintiye. Wama uwaimogini nagisarisa tara tumpaema abagi kina'wampibe wauguni, ");
INSERT INTO for_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","to ka'isa wayapa pai yoni kinape ke kina intabaipi minta kinape mintuguna, igetisa agaruba igasogini, igege wantawe. Igetisa kapa Mariya, Matara kumatasa waene, aepa keba tonaentisa tara umaema agaruba againti nkwaene. ");
INSERT INTO for_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Piya, to kapa agewapa Yowana, Eroti ntama kiye yagara Kusa, ae waene. Piya, to ka waepe, agewapa Susana, to ka'isa waepe igege wantawe. Pi wae'miba Isuge abagi kina'wake ige'wai kutatasa iyo'maema kao'ena puwaitantawe. ");
INSERT INTO for_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kumaka kumaka a'ya'waema kina Isuti kanagana puma pumaeyuguna, igantana meto kamana ka mayama uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Wasana ka'waina aeba aintana pikena wantiye. Wama aibarase pogana, ka'isa aowapa kepi tumpa waiyogana, wasanami igeba nasi nasi puma aerapauguni, kabarankama irosa'ma ampa nawaegaintiye. ");
INSERT INTO for_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","To ka'isa aowapa asigiyogana yabankama nkabobori tumpa waiyogini, pipa maba kampa waintomeka i'magina iyomepa asama pu'wantiye. ");
INSERT INTO for_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","To ka'isa aowapa kabubinti tunkwaima iraogana, kabuyenama pabiyama i'magina aibarusa pogana asa wantiye. ");
INSERT INTO for_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Piya to ka'isa aowapa apa mabi tumpa waima, anonkapa uwoma aborama aosa pama 100-wa aboraogana uwoma ntaninta waintantiye, untiye. Pi kamanapa uma a'ya atate, kega'e uma maya uwaimintiye: Ageyaga kina'maba ma kamanapa abibebe peno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pigoya, abagi kina'wampiba igeba pi kamana'ama nkagowaka abigauguna maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Koti kabiratakena kamana kakama waintipa, tigemana abiyoma untine. Ka'isa kina'miba igeba meto kamana agowa kampa abikibewe. Piya pumagini iyoma kagagate, ka'enaba kampagini agabebe pikibewe. Piya, igerasaba kamana abikena pugagate agowapa kampagini abibebe pikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Piya untana ago maya untiye: Meto kamana yopa, pi'na nkagowapa mayama waintiye: Aintanaba Koti kamanane. ");
INSERT INTO for_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Pigoya, kepi aintana tunkwaintogana, kabarankama ampaema nantisa puma miye kina'miba igeba mono kamana abigina iguta waiyekana, pabigo kewamaba irosa'ma maerite pai'wagini, mono'wai kampa wainta uwa mima ataenabi miyewe. ");
INSERT INTO for_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Pigoya, to ka'isa aintana yaba nkabobori tumpa tagantisa puma miye kina igeba maru'enaba mono abima iga pewe. Piya ibigakenaena aboraginiba anuntana pewe. ");
INSERT INTO for_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Pigoya, to kabubinti tumintisa puma miye kina igeba arirasaenama igu'amapa maema a'yugu puwaitakini, uwoma napiyenawampa mone kutankama nkigaenawampa mono'ama aeguyegina, au'wapa kampa waiye. ");
INSERT INTO for_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aintana aogi mabi tumintisa puma miye kina igeba mono kamana abima igu'amapa kiya kabima, pasema aogima miyewe. Piya pumagini au'wapa aborawe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Pigoya, Isu to maya untiye: Ae kina'ma kane igi'ma tusuparirasa atikaekiyebera, asipawama nkamentapinti atakana waikiye, a. Pipa kampaye. Kanepa igi'ma abora atagana waima, nama nkagupintiba e'wasa puma arakini wasanamiba ima agakibewe. ");
INSERT INTO for_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pigoya, a'ya'waemaena kakama waintintanaba, pipa waima kampa waikiye. Pipa mimaba ainti aborakiye. Piya, ka'isaena wasanama atikae kainta'ena wainti, pipa waimaba kampa waikiye. Pipa mimaba a'waitakiye. Piya pegana agowapa pita arakiye. ");
INSERT INTO for_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Pigoya, ka'waina aminta'ena kanara maema miyekanaba, to kake tabe puma amikiye. Piya, to ka'waina aminta'ena kampa aogima kabima miyekanaba, aparikiye. Pika tageba aogima abibebe puma napi napi puma miyiyo, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pigoya, uwoma kina Isu ainkima asima mintuguni, anobe a'natabarabe kanama wasanabi igiga puma pagasara mintantawe. ");
INSERT INTO for_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Piya puguna, ka yagarama igategina Isupa maya omintiye: Kanobe ka'natabarabe taka'i kagakena ampintawe, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Piya yogana Isu abite maya untiye: Koti kamana abima wasiye kina mampa nanobe na'natabarabe mintawe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Pigoya, ka yagaba Isube abagi kina'wape wanipisa karebi intana, maya uwaimintiye: Taeba kotupa ta'ema maroteri wane, yogini abuguni wantawe. ");
INSERT INTO for_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Waumepa Isupa awaiga abogana waintiye. Waitamintogana pontaba tabera puma, kotunkamaba ataena purite, waninkamaba wanipisa karewama nkantabaipinti tumima awaitama ipirintakena puntiye. ");
INSERT INTO for_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Aibogini, igeba wama Isu abage pumagini: Tabe yagara, tabe yagara, taeba naisukena pune, untawe. Piya yuguna, aeba asima pontawamake tabe waninkamake tabe kamana uwaisimoginisi uwasuwa puwantase. ");
INSERT INTO for_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aibusuguna Isu maya uwaimintiye: Tigeba timatiti'enaripa aeta waintegiri yewe, antiye. Piya yogini, igeba a'ya'ma iyekuru pumagini tabe igi napintawe: We, aeba nana yagaragana, pontawamake waninkamake kamana uwaisimeginisiba awamu wasiyese, uma mare-u me-u puntawe. ");
INSERT INTO for_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Pigoya, igeba kotupa ta'erite wama Kerasa kina'mi au'i irosantawe. Pigoya pi au'i Karari kotunkama maroteri irosantawe. ");
INSERT INTO for_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Pita'i uma irosa'ma wauguna, kumatisa ka yagara aeti kanantiye. Pi ntagara aeba antabaipinti ke kinapa uwoma miyuguna, e'ero ntagaba aotasaena kampa maema punta auka mimagina, piya namapinti kampa mima, aeba wasana irubintimana umi mpi puta nasintiye. ");
INSERT INTO for_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pigoya, aeba Isuti kanamagina agama, tabera kega'e uma mabi ware'nama agisabi mima tabe kamanatasa maya untiye: Isu, kaeba inatisa tabe Koti Ntagaragawe. Kaeba nana punatakena kanane. Kaeba a-nkata punatao, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Pigoya pai asi nasi kewama aeba e'ero ntagaba pi ntagaraba agu'amapa ataena potaogana, esegi puma miyogini, wasanamiba agisa ayatapa esegi iga'narasa kirokaetama kiya kabima mibuntawe. Aibuguna, iga'naba arisa narisa potate, pai'ma ka'me mpari uma mibuntiye. Pigoya, Isu kana yagarama nkantabaipisa ke agarubakena pogana, agama piyama: A-nkata punatao, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Piya yogana Isu: Kagegapa kegawema, abigaogana: Nagenepa Uwomane, untiye. Piya, keba uwoma pi ntagarama nkagupi pai'ma mintaka, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Piya, igeba Isu uwa uwaitakini, a'abibinti tumisanaga kampa ibogini agisuntawe. ");
INSERT INTO for_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pigoya, pi mpariba uwoma ntagamiba amu ararabinti mima naninta nama mintuguna, pika ke kina igeba abirataga yaga intabaipi tumeno, piyama abigauguna: Kanarane, owe, uwaitantiye. ");
INSERT INTO for_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Piya uwaitogini, igeba wasana antabaipisa irosa'magini, yaga intabaipinti ubasintawe. Ubasuguni, pi ntagamiba karu'ena ausari tumima, tumpa wani naisuwaewantawe. ");
INSERT INTO for_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Piya puguni, yaga kiye kina'miba agate karu'ena wama wasana wa'eribe yogaribe wama uwaimintawe. ");
INSERT INTO for_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Uwaimuguni igeba pintana aborantika agakena irosa'ma kanama, Isuti ampa agantawe. Pigoya, pi uwoma ke kina antabaipisa irosa'waume ntagaramaba aotasaena wantaga kamana wantaga Isu nkagora mintantiye. Piya pogini, wa waya'miba agate iyekuru puntawe. ");
INSERT INTO for_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Piyama mintuguni, pintana agama abinta kina'miba pi ntagara aogi potaome kamana uwaimintawe. ");
INSERT INTO for_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Piya, pi Kerasa marasa kina'miba tabera iyekuru pogini, Isu aeba mawaipa kaite wanema omintawe. Omuguna, a'wae puma itate wanipisa karebi iyogana, ");
INSERT INTO for_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ke wantaga miyome ntagaramaba aega'ma aege wakena esotantiye. Esotaogana Isuba agaruba'ma maya omintiye: ");
INSERT INTO for_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Kaeba wa'egati wama, Koti kaeti piyaena pugatami, pi awaga kamana uwaimo, untiye. Piya yogana, pi ntagara aeba a'wae puma, Isu maema aogi potanti pi awaga kamana kuma'watisa kina uwaimiwaentiye. ");
INSERT INTO for_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pigoya, wasanami igeba Isuka agawa puma mintuguna, irosaogini agama i'muntana potantawe. ");
INSERT INTO for_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Aibuguna, mono nama kiye yagara ka, agewapa Yairasi, aeba kanama Isu nkagisabi parokaema aragawaka abigantiye. ");
INSERT INTO for_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pigoya, aragawapa ka'anto kabowapa nagisarisa tara tumpaema kabu pugasomekana, purikena puma mintogana, Isuka: Nae namati kanao uma, agega'e untiye. Piya yogana Isuba abite waogini, uwoma kina'mi pumaewauguna, ");
INSERT INTO for_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","pi kina'mi nkabakapi waya ka mintanti, aeba iyegari tumiyaba miyogana, kabowapa nagisarisa tara tumpaema kabu pabiya mintantiye. Mintogini, tusa kina'miba ao'maekenaba pugagate uwa atantawe. ");
INSERT INTO for_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Piya, kana wae'maba aeba Isu aka'i wama kaiwampa atuta aukaya puntiye. Aukaya pogana, pabigo korankapa tabago puntiye. ");
INSERT INTO for_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Piya pogana, Isu: Ke naukaya piye yogini, wasanamiba uwamega yuguna, Pita maya untiye: We, Tabe Yagara, uwoma kina'mi kobe puma mintini kaukaya pewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Piya yogana, Isu maya untiye: Kampaya, ka'waina naukaya pegina esegiyenanepa wagi agauwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aibogana: Aeba agonepa pabigo aboraye, wayapa ute, tabaraba purite Isu nkagora uma parokaema, yoninkampa kamanape aukaya pogana koranka tabago punti kamanape, kaga uma aboraogini abiwaentawe. ");
INSERT INTO for_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pigoya, Isuba maya omintiye: Araganepa, kamatiti punatampeka aogi kabiye. Pika wama aogima miyo, omintiye. ");
INSERT INTO for_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Pigoya, Isu piya uma mono nama kiye yagarama ntamati wakena pogana, pi ntagarama ntamatisa ka yagara kanama maya ampa omintiye: Aragagapa ago puriye. Pika tisa yagaraba uwampapa a-nkotagana kanano, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Piya yogana, Isu pi kamanapa abima mono nama kiye yagarapa mayama omintiye: A-kaekuruba po. Kamatiti punataganaba, aragagapa aogama asikiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Piya ute, napinti ima ka'isaba waitaogini abe'i mintuguna, Pitake Yonike Yemisike kana aragama nkanoge abage isigege ige'mana ibabogini, wama napi uma pasintawe. ");
INSERT INTO for_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Uma pasuguni, wa waya igeba kube'ena puma mintuguna, Isu maya uwaimintiye: Kube'enaba a-piyo. Aragaba kampa purintiye. Aeba uwa awaitamintiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Piya yogini, igeba agora pu'wantika agaume kina'mi kagi potantawe. ");
INSERT INTO for_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Piya puguna Isuba kana aragama nkayata u'ma kega'ye uma: Araga, kaeba asiyo, omintiye. ");
INSERT INTO for_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Piya omogana, amankampaba a'wae puma kanaogana asintiye. Asiyogana: Naninta amigina nano, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Piya yoginisi, anoge abage isigeba tabera pami puntase. Aibusuguna Isuba: Pi kamana wasana a-nkuwaimiyo, uma akunkaitantiye. ");
INSERT INTO for_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Isu aeba nagisarisa tara tumpaema kina'wa igega'e yogini irosauguna, keba agaruba igaintana, yoni kinapa kaba itakibeka esegiyena imima yoga kamana uwaitantiye. ");
INSERT INTO for_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pigoya, wasana Koti kabiratakena kamana uwaimima, yoni kina kaba itakibeka maya uwaimima ");
INSERT INTO for_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","igarubantiye: Tigeba ke'iba wantape titasaena ampaete wantiri ira'na kupe, nanintabe monebe kai tarabe, a-nkurite waiyo. ");
INSERT INTO for_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Pigoya, ka kumata irosa'maba namapi pasikibepa, pabipi miyiyo. Mima irosa'ma waiyo. ");
INSERT INTO for_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Piya, tori uma irosaigini, a'a-o uma uritaigiripa, iro'ma tigisarisa i'ni pugaitegiri waigini, ataenabi miyentanaga abima napiyiyo, Isu piya uwaimima igarubantiye. ");
INSERT INTO for_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Piya uwaimima igarubaogini, igeba ase'yo puma wantawe. Piya puma kumaka kumaka nasi nasi puma, wasana aogi mono kamana uwaimintini, yonintanabe iki naki pomentanabe kaba itantawe. ");
INSERT INTO for_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wasana kiye yagara Eroti aeba Isu piya mayaena pome, pi nkawaga kamana aboganaba kunta abuntiye. Pipa ka'isa wasanamiba maya yumeka puntiye: Yoni aeba purintapisa asima mima, pintanaba piye, yuguna, ");
INSERT INTO for_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ka'isamiba akayotama maya untawe: Kampaye. Iraiya to kake aborama mintiye, yuguni, piya ka'isamiba maya untawe: Kampaye. Poropete tayabama ka'waina aogama mintiye, untawe. ");
INSERT INTO for_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Piya yuguna, abogana Eroti kunta abogana maya untiye: Yonipa naeba ago yuwagini aeguntawe. Pigoya, ke piya pemi nkawaga kamanapa abuwe. Piya uma, ka'enaga umaba Isu agakena puwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pigoya, aposoro kina igeba yogawaitisa a'wae purite kanama, pi punta kamana Isu omintawe. Omuguna Isuba ibabute Petisaita kuma mari ibiwai umikena wantiye. ");
INSERT INTO for_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Waogini, wasanami agate aega'ma wantawe. Piya Isuti irosauguna, ao'ena puwaitaogini mintuguna, Koti kabiratakena kamana uwaimimagina, yoni kinapa kaba itantiye. ");
INSERT INTO for_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Piya puma mintuguna, pankaoba pasikena pogini, nagisarisa tara tumpaema kina'wa aeti wama maya omintawe: Mapa kabubinti mintompeka, kaeba wasana itagini kuma wairite wanti, pita'i wama namape nanintabe aguyosa'ma aboraiyo, uwaimo untawe. ");
INSERT INTO for_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Piya yuguna Isu: Tigeri kapa nanintaba imiyo, uwaimintiye. Uwaimogini igeba maya omintawe: Amana paretintontoba nayaka'muna, inoyanta tarawa suma, piyaki'anto waintiye. Pika aya pukune. Kumati wama ma uwoma kina'minta ige nanintaba wama ika pukuno, untawe. ");
INSERT INTO for_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pigoya, pi waba 5,000 kina mintumeka, abagi kina'wampiba piya untawe. Yugana: Wasana uwaitaigini arabamagini, 50 kina aki puma mirite waiyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Piya uwaimimagini, igeba wasana uwaitauguni, arabama mara'mintantawe. ");
INSERT INTO for_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Aibuguna, pareti nayaka'mupe inoyanta tarape maema mantari ao ma'magina Kotiti a'mu potamagina, apako puma abagi kina'wa imogini igeba pako puma wasana imintawe. ");
INSERT INTO for_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pigoya, igeba a'ya'waema nama iga'e pantawe. Piya nauguna, aritapa kibi'magini, wa'nu kupa nagisarisa tara tumpaema ku iraguguna awaitantiye. ");
INSERT INTO for_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Pigoya, ka yaga Isu aeba abagi kina'wa ibabute tori umima, Isu aewa nunamu untiye. Piya puntana: Wasanami naekaba kewe yewema, ibigama untiye. ");
INSERT INTO for_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ibigaogini mayama omintawe: Ka'isa kina'miba Yoni mono wani pai'atakena yagarawe ugatawa, piya ka'isamiba Iraiyawe ugatawa, piya ka'isami igeba Poropete tayabama ka'waina aogama asima mintiye, piya ugatawe, omintawe. ");
INSERT INTO for_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Piya yuguna, igewai ibigama maya untiye: Piya, tige tigeripa napiyepa naekaba kewe yewema, ibigaogana, Pita: Kaeba Kotitisa utaratanti ntagara Karaisitigawe, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Piya yogana, wasana to kina kampa uma abora uwaimikibeka, uwame uma esegi puwaitantiye. ");
INSERT INTO for_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Piya mayama amato puma uwaimintiye: Wasanama Ntagaramantepa tabe kuntaenabi punataigini, mono kabiye kinape tabe mono kiye kinape kamana ago abinta kinape, igeba karana natama naeguyigi, papa kakaga mima purintapisa asikuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Piya untana, wasana a'ya'waema toba maya uwaimintiye: Ka'waina nae naegarakena puntanaba, au'wama kamana akabitate, wasanami igobi potakibikaba a-nkaekuru puma maripowa aesagabite naegarano, ute, ");
INSERT INTO for_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","piya, ka'waina mikenaenawaka owe yekanaba a'yugu potakiye. Naeka napima, mikenaenawaka a'a-o yekanaba, aboramikiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Piya untana maya untiye: Pigoya, ka'waina aeba mabi a'ya'waemaena maemagina, agu'amankapa aeguma kaiyekanaba, aya pikiye, a. ");
INSERT INTO for_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Piya, ka yagarama kamana'neka ani punatakibipa, Wasanama Ntagaramanageba pabiyama nani potakuwe. Pigoya, tumukubopa, nabanempa nke'wasaenabe enisore kina'mi nke'wasaenayaga naeba e'wasa puma tumukubopa, pi ntagaba ani potakuwe. ");
INSERT INTO for_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Naeba taga taga'ya urimekiri abiyo: Ma minta tigetisa ka'isamiba purikenaenaba kampa aborantigina, Koti kabiratakenaenaba aborakiri agakibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Isu aeba pi kamana uma mintogana, tonaentisa kakaga umaema yaga a'ya pogana, Pitake Yonike Yemisike ibabute amuti nunamu ukena intiye. ");
INSERT INTO for_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ima nunamu asu yogana, aowawamaba to auga pumagina, kaiwampaba waentana puma e'wasa puwantiye. ");
INSERT INTO for_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Piya poginisi, wasana tara aborama aege kamana untase. Pi isige isigewaisipa Mosesege Iraiyage, ");
INSERT INTO for_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","isigeba manta e'wasaenawaisintaga irosa'maginisi, Isu Yerusaremi kumati mampa atate ikena kamanapa tumpa Isuge untase. ");
INSERT INTO for_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piya pusuguni, Pitabe ao taramisibe iwaigaba tabera ibogini waintawe. Pigoya, ibegu pumiyumetisa agantapa, Isube e'wasaenawape tara yagararamisibe igantawe. ");
INSERT INTO for_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pigoya isigeba wakena pusuguna Pita maya omintiye: Kiya yagarama-o, taeba mata'i miyokanaba igabiye. Pika namapa kakaga kiyeno. Kae'ena kane. Mosesenta kane. Iraiyanta kane, untiye. Pigoya, aeba kamana kampa aogima napinta, uwa untiye. ");
INSERT INTO for_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piya yogana, ibina ka'waina tumima airari kae igaintiye. Ibina kima itikaewaogini, igeba iyekuru puma mintuguna, ");
INSERT INTO for_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ibinankama antabaipintisa kamana mayama aborantiye: Mepa utatanta yagaranene. Tigeba kamana'wapa abiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Piya kamana yogini abintini, agaumepa Isu abintowa mintogini agantawe. Piya, pi abagi kina'wapa pintana agantapa, pi kanabipa kampa wasanaba uwaiminta, uwa igupi napima mintantawe. ");
INSERT INTO for_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pigoya marogini, amutisa tumima wasana uwoma kina ibatantawe. ");
INSERT INTO for_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Piya puguna, ige abakapintisa ka'waina maya uma Isu agisuntiye: Tisa, kaeba kamana'nepa abima, yagaranepa ao'maeyo, aeba ka'antowe. ");
INSERT INTO for_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Abeno. Kewama aepagina pamintami puma, a-e a-e uma miye. Piya paisusu pegina akagawaba i'waegasaye. Piya, kewamaba kampa agarosamaba atatewaikana, tabera amiyo amayo puma anuntana potaye. ");
INSERT INTO for_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Pigoya, kabagi kinaka uwaimogini, igeba ke agarubakena pugagate atawe, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Piya yogana, Isu maya untiye: We, timatiti'ena kampa wainta, aibo kina mintigi, naeba ayaki yaga tigege mintakiri, napiyenaripa kaitegiri nae kamana abikibewe, untana: Pigoya, kana yagaraga ababute kanao, omintiye. ");
INSERT INTO for_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Piya omogana kana yagara ababute Isuti wakena pogana, kewamaba abai pogana, agisa ayapa paropara puwantiye. Piya pogana, Isu kewama kabiraogana, aegaka waogana, pi ntagaraba aogi potamagina abawampa amintiye. ");
INSERT INTO for_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Piya pogini, wasanami agamagini, Koti esegiyenawampa agowapa agamagini pami puntawe. Pigoya, wasanami a'ya'waemaena pomentanaga agaumeka pami puma mintuguna, Isu abagi kina'wa ibiwai mayama uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Pigoya, ma kamana urimekiri abibebe piyo. Wasanama Ntagara naepa to kina'mi iyapi natakena unatantemi kana'nepa ago agarosaye, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Piya uma uwaimogini, igeba kamana kampa aogima napima abuguna, kakawaogini kampa abima aogi puntawe. Pigoya abigakenaba iye kuru puma atantawe. ");
INSERT INTO for_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pigoya, abagi kina igeba: Taetisa ke tabeba mikiye, uma maka untawe. ");
INSERT INTO for_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Piya yuguna Isuba imabinti agowai abimagina, uwaena yagaranto ka ababuma, agora atama ");
INSERT INTO for_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","maya uwaimintiye: Ka'waina naeka napima, ma uwaena yagaranto ao'maekibipa, pipa nae nao'maekiye. Pigoya, nao'maekibipa nae Inatisa nagarubanti Ntagara ao'maekiye. Piya, tigetisa ka'waina aeba tumima mikibi'nakaba, aeba naobi tabeba mikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pigoya, Yoni maya omintiye: Tabe yagara, taeba wasana aogaso ka'waina kae kage uma, ke agarubagi agaompepa, aeba taepa kampa taegaramika akunka ataune, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Piya yogana, Isu maya omintiye: Tigeba a-nkakunka ataiyo. Piya, yogari kampa aguya aikibi'napa tiyo'ena potaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Pigoya, Isu aeba yogawapa a'ya kaite iyekana, Koti ababikenagana agarosakena pogana, Yerusaremi kumati wakena uma esegi puntiye. ");
INSERT INTO for_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Umagina, tonkiya potate apa igarubaogini paitama wantawe. Paitama wama, Sameriya kina'mi ka kumata irosa'ma Isunta uwaikena nama ka aboraiyema uwaimintawe. ");
INSERT INTO for_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pigoya Isu aeba Yerusaremi kumati wakena piye kamana abitegini, nama akunintawe. ");
INSERT INTO for_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Akunuguna, abagi yagarawa tara Yemisige Yonige isigeba abiteginisi, Isu abigama maya untase: Wa'ega, kaeba abegarao. Kae kabukibika, kega'e yekana, mantarisa yaku tumima ma kina irabateno, untase. ");
INSERT INTO for_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Piya yusuguna, a'wae puma ka isibi'atate, ");
INSERT INTO for_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","igeba to kumati wantawe. ");
INSERT INTO for_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Pigoya, igeba ke'i wauguna, wasana ka'waina ibatama Isu mayama omintiye: Kaeba pita'i mata'i wakena yegapa naeba kaegarakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Piya yogana, Isu maya omintiye: Kabu kara igeba age'waintaga waintiye. Piya, inatisa kabara igeba ina'waintaga waintiye. We, Wasanama Ntagara nawaikena maruntepa kampa waintiye, omintiye. ");
INSERT INTO for_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Pigoya Isu to wasana ka abatama: Kaeba kanama naegarao, omintiye. Omogana a'wae pomintiye: Wa'ega, abintaga marupa wama nabanempapa pu'waka uma kaitate kaegarano, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Piya yogana Isu maya omintiye: Monota pu'wasu puma miye kinapa purikibe kinapa kanara kaiwaitakibewe. Kaeba kanama naega'ma, Koti kabiratakena kamana aborawaimo, omintiye. ");
INSERT INTO for_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pigoya, to ka'waina maya omintiye: Wa'ega, nae kaegarasanaga nabiye. Piya abega, paitama a'wae puma wama, nao'mipa: Pigo miyiyoma, naya imite kaegarano, untiye. ");
INSERT INTO for_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yogana Isu maya omintiye: Ka'waina aeba ka'ena pubasanantana aka'i aomarakibi kina'maba pemisa puma, Koti kabiratakena yugaba kampa pikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Pigoya, Isuba to sebentiwa ntagara aki puwaitama, yoga kamana uwaitantiye. Piya, aewa wakena pome kumatiba tara tara uwaitama maya untiye: ");
INSERT INTO for_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yogaba tabe waintegina piya naninta a'na pukena kinapa tarantowe. Pika tigeba yoga agowamaka esotaigina naninta a'na pukena kinapa aboraigiri yogawatapa waiyo, Isu piya untana, ");
INSERT INTO for_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Tigeba wantiripa mayama abiyo: Tigeba sipisipi awarowama kabu yagama abakapinti wamisa puma, tigarubaogiri wawe. ");
INSERT INTO for_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pigoya, tigeba mone asabe ira'na kupe, to ka'isa tigisa anape a-mpaete waiyo. Ke'i waigini, wasanami tigigaigiripa uwoma kamana asiyo. ");
INSERT INTO for_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Pigoya, ka namapi uma pasikena puntiripa, pi namapi miye kinapa mayama uwaimiyo: Paruyenabi miyiyo uwaimigina, ");
INSERT INTO for_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","pigo pi ntamapi aogi paru yagara ka mintakiripa, paruyenaba aeti waiyeno. Kampa yekanaba pi paruyenaba tigetiti to a'waebuma kanano, untana, ");
INSERT INTO for_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","namapa pasikibe pabi ntamapi miyigini, nanintabe wanipe timigiri naiyo. Tigeba nama toyaba antasima, ka namapi mima naninta timigiri naiyo. Piya, yoga kinapa yogawaitasa ikantanaba imegini maeyasa puma timigiri maeyiyo. ");
INSERT INTO for_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pigoya, ka kumata irosaigini aogi puritama naninta timigiripa nantiripa, ");
INSERT INTO for_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","itantiripa maya uwaimiyo: Koti kabiratakenagana mampa agarosaye, uwaimiyo. ");
INSERT INTO for_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pigoya to ka kumata irosaigini nankaipi kampa tiba puritaigiripa, abe'i irosa'magiri maya uwaimiyo: ");
INSERT INTO for_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Matasa tagisarisa i'ni pugasokana tigetiti waye. Piya, kapa mayama napiyiyo: Koti kabiratakenagana agarosaye uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Isu pi kamanapa uma, kapa mayama amato puntiye: Naeba urimekiri abiyo. Aintisa kanabipa Sotomu kumatasa kinapa tumimaena aborawaimikibikana, maya kumatasa kinapa tabe kuntaenaba aborawaimikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Pigoya, Isu to kinaka maya kamana uwaimintiye: We, Korasini kina, nantarane. We, Pesaita kina, nantarane. Mebi tige mari kukantana tabera aboranti, pipa Taya Saironi kina'mi kumata mayaenaba aborantosinta, igeba intara puma karu'ena auga'magini igu a'wae puntasine. ");
INSERT INTO for_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Piya, aintisa Koti pakobikibi kanabipa, Taya Saironi kumatasa kinapa tumimaena aborawaimikibikana, tige kuntaenaripa mesuba puma aborarimikiye. ");
INSERT INTO for_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","We Kapaniyamu kina, tige mari uwomantana poka, mantari ikibewa, a. Kampaye. Aintiba a'abibinti tumikibewe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Uwaimintana igepa to maya uwaimintiye: Tige kamana abikibi'naba nae kamana abikiye. Piya, tige a'a-o uritakibi'naba pabiyama naepa a'a-o unatakiye. Piya, nae a'a-o unatakibi'naba pipa unatanti'na ae a'a-o otakiye, piya uwaimima yogawaiti igarubantiye. ");
INSERT INTO for_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Pigoya, pi sebentiwa ntagaramiba igeba a'wae puma kanama, i'mu purintini Isu awaga kamana maya omintawe: Wa'egare kae kage uma kegina igarubaokiniba, tawamupa wasiyewe, untawe. ");
INSERT INTO for_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Piya yuguna maya uwaimintiye: Pigoya pabiyama Sataniba aeba mantarisa amonta tumemisa puma ware'ware purite tumoga agantuwe. ");
INSERT INTO for_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Abeno. Esegiyenaba ago timintokana, piya pi kama kina'ma a'ya'waemaenawampaba ataenaba kampa puritakibewe. Tigeba kuyabe ontabenipe iyebasaiginiba kampa ataenaba puritakibewe. Esegiyenaba ago timintuwe. ");
INSERT INTO for_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pigoya, tigeba kewama tiwamu wasinta, pikaba ti'mupa piyo. Piya, tigeripa mantarisa esapi Koti kaemaranta wainti, pika tabera ti'mu piginiba aogi pikiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pigoya, pi ntaga Aota Awamusa'ama anta aseyo pogana, Isu a'mu kamana maya untiye: Naba, mantage mage agowane. Kaeba abikenaenawaika abegana tabe pe kinapa kakawaigasane. Piya, igu'amaka abegana inamu kanta pe kinapa uma aborawaimene. Piya, naeba pika na'mu pugatauwe. Naba, kaega napimagina piyama abora urite wanema uma esegi puntampene, untana, ");
INSERT INTO for_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pigoya, a'ya'maena wainatantipa nabanempa nayapi atawaentiye. Pika wasana ka'waina yagarawa naeka agoneka kampa abibebe piye. Nabanempa ae abiwapa abibebe piye. Piya, ka'waina nabanempa ae agowaka kampa abibebe pega, yagarawa nae nabinto abibebe pumagi, nae napima wasanaba uma aboramekana aegeba pabiyama abibebe pikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Piya umagina, a'waebuma abagi kina igewaipa maya uwaimintiye: Tigeba kasa'ena agaka ti'mupiyo. ");
INSERT INTO for_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Piya, naeba urimekiri abiyo. Pai a'ya'ma poropete kinape kiya kinape uwomampi igeba tige pi agama abentanaba, pipa agowa agama abikenagaba ibugagate itantiye. Igeba kampa agama abintawe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Pigoya, kamana ago abinta yagarama ka asima, Isu amiyo kamana mayama abigantiye: Tisa, naeba ayabuma e'wasaena maemagi asi nasi aogima mikuwema, abigaogana, ");
INSERT INTO for_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Isuba maya omintiye: Mono ago kamana awa'ena kamanapipa ayama waintegina aisene, omogana, ");
INSERT INTO for_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","kamana ago abinta yagarama maya untiye: Kaeba a'ya'ma kagu kaumakape esegiyenagape napiyenagape, Wa'ega Kotigapa a'ya'ma amegana waiyeno, piya kaegaka kabemisa puma, pabiyama kae kaokinaka kabeno. Kamanapa piyama waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Aiyogana, Isu maya omintiye: Kaeba kamanapa kanara yene. Pipa wasima mima aogima mikibene, omintiye. ");
INSERT INTO for_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pigoya, pi ntagara kamanapa abintanaba aewa age maema aogi puma to kake: Wasana naopa kewema, abigantiye. ");
INSERT INTO for_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Aiyogana pika Isu kamana kapa maya omintiye: Wasana ka'waina wa'ewapa Yerusaremi kumatisa Yeriko kumati tumikena tumogini, kama kina'mi minaena puma mintuguna, pipi uma pasintiye. Piya, igeba aegumagini, kaiwape kotankape apawaeritegini, atauguna purikena puma mintantiye. ");
INSERT INTO for_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mintogana, mono kiye yagara ka'waina pabi ki'i wama agamagina, au'akana naerite maroteri wama againtiye. ");
INSERT INTO for_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aeba waogana, Aribai yagara ka'waina irosa'magina pabiyama agama au'akana naerite maroteri wama againtiye. ");
INSERT INTO for_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Piya pusuguna, Sameriya marisa yagara ka'waina pabi ki'i wama uma abatantiye. Uma agamagina antara potama ");
INSERT INTO for_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","agora wama masawaetasabe waini wanitasabe anamopipa pai'atama asaetantiye. Piya potama, ababuma yagawampa akabata atama ababute wama, wami ntamapinti metama aogima kabitantiye. ");
INSERT INTO for_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pigoya, maroganaba wakena puntanaba, waba ntama kiye yagaraba tu tora amintana maya omintiye: Kaeba ma ntagara aogima kabiyo. Piya, to ka'isa ae auta kaikibempepatakaba, to kake kanamagi amato puma kamukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pigoya, wasana tarawa kanaki kina igetisaba ku kina'mi aegunta ntagaraba mapa ao'enaba ke potantiyema, napiyenema abigantiye. ");
INSERT INTO for_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Piyama abigaogana, kamana ago abinta yagara aeba maya untiye: Antara potama ao'maenti ntagara, aewe, yogana Isu abite: Kaeba wama pabiya puma miyo, omintiye. ");
INSERT INTO for_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Isube abagi kina'wampibe igeba wama to kumata uma irosaumepa, ka wae agewapa Mata aeba nankapi Isu ababotama maruntaki'ena potantiye. ");
INSERT INTO for_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pigoya, a'nantoba ka mintantiye, agewapa Mariya, aeba Wa'ega yagarama agisabi mima mono'wa abintiye. ");
INSERT INTO for_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Piya pogana Mata aeba naninta kao'ena puntana uwoma agi napima mima, kao'enaba pugategina Isuti wama maya untiye: Wa'ega, nana pegina na'nantoba natagi, nae nabi kao'enaba pumiyoganapa, kaeba agantanapa kampa napiyeno. Kaeba omegana nao'maeyano, omintiye. ");
INSERT INTO for_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Piya omogana Isu maya omintiye: Mata, Mata, kaeba uwomantanamaka abima, uwoma kagi napima kauki nakiyena puma miyene. ");
INSERT INTO for_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Abeno, ka'ena aogiyena tabera waintiye. Mariya aeba pi aogi au'wantaga'ena ago maeye. Pipa a-nkapareno, Isu omintiye. ");
INSERT INTO for_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pigoya, Isu aeba ka au'i ampima nunamu untiye. Nunamu a'ya pogana, abagi kina'watisa ka'waina maya untiye: Yoniba abagi kina'wapa nunamu ukena kamanapa uwaimintisa puma, kaeba kapa uramo, untiye. ");
INSERT INTO for_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Piya yogana Isu maya uwaimintiye: Tigeba nunamu ukena puntiripa, maya yiyo: Taba, kae kage aota waiyeno. Kabiratakenaenagapa aborawaeyano tabiye. ");
INSERT INTO for_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","A'ya'ma yagaba kaeba nanintarepa tamo. ");
INSERT INTO for_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kaintanarepa taeba kaintana purata kina'mi nkatupa mae igasompe nkawameta kaeba aguntaenarepa maeragaso. Tamiyo pusanagaba aogima kabiratao, yiyo untiye. ");
INSERT INTO for_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Piya yiyo uwaimitegina, to kapa mayama amato puma uwaimintiye: Tigetisa ka'waina aseka nkabubu e'ero mparisa kanakana, amikena nakenaba kampa waintakana irosakanaba, wama to ao'yagaramaka uma abage puma maya omikiye: Nao'yagara, ka nao kanamagina e'ero mparisa kanamipa, nakena kampa waintegi, kaoti kabigama nakena tarawa kanaki namega amenoma, abigakiye. ");
INSERT INTO for_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Piya yekana ao'yagaramaba napintisa maya ikiye: Kaeba nanaga ampa tabage pene. Na kabe akugasima, waya'yagara iwaigasapintiba, ayama asima maema kamusuwe, piya ukiye. ");
INSERT INTO for_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pigoya, naeba yekiri abiyo. Aeba nao'yagaraga ao'maekuwemaba kampa napikiye. Aeba ebi ebi kamana yekana, abima uwa asima ikibintanaba maema amikiye. ");
INSERT INTO for_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Piya, naeba pabiyama kapa urimekiri abiyo: Tigeba Koti abigaiginaba timikiye. Aguyosagaiginaba au'wapa maema tigeti aborakiye. Kabera aiwakarusiginaba Kotiba aititakiye. ");
INSERT INTO for_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Pigoya, a'ya'ma kina'miba Kotiti esota kina'miba maeyawe. Aguyosaga kina'miba agawe. Kabera aiwakaruse kina'mitiba Kotiba ai'itaye. ");
INSERT INTO for_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Pigoya, tigetisaba ae ntagarama yagarawampa inoyantaga yekanaba, antotapa kuya amikiya, a. ");
INSERT INTO for_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Kokore amuka yekana ontabeni amikiya, a. Aeba kampaye. ");
INSERT INTO for_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","We, tigeba antage kina'mitaba yagara aragaripa aogiyena imewe. Piya, mantarisa tibarimpa aeba asagasima esota kina tigepa Aota Awamusapa timikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pigoya wasana ka'waina kewama awamu akugasogana kamana kampa yogana, Isuba pi ntagara antabaipisa ke agaruba agasogana, to kake kamana untiye. Piya yogini, wasana igeba agate pami puntawe. ");
INSERT INTO for_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pigoya, ka'isamiba Isuka maya untawe: Ke kina'mi wa'egawai Piyesiburu, ae esegiyena amegina keba agaruba igasaye, yuguna, ");
INSERT INTO for_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","to ka'isa kina'miba amiyo kamana maya omintawe: Kaeba yegana, mantarisa awame'ena aboraka agano, untawe. ");
INSERT INTO for_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Piya yuguna, aeba napiyenawaimpa abibebe purintana, maya kamana uwaimintiye: Ka marisa kina igeba kamaena piginiba, a'ya'waemaenawaipa aguya ayigigasigini, igeba atama mikibewe. Pigoya, ka tunkama ma'ena pukibemipa, aokina'miba asorisari puma kampa aogima mikibewe. ");
INSERT INTO for_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Piya, Satani aokina'miba pako puma ma'ena pesinta, ayama esegima miyesine. Pigoya, tigeba naekaba Piyesiburu esegiyena amegina keba igarubaye ye kauwe. ");
INSERT INTO for_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pigoya, naeba kewama Piyesiburutisa esegiyena maema ke agarubaosinta, tiyokinapa aetasa esegiyenaba maema agarubasine. Pika abimagiri, tiyokina'mi kamanatipa eta'maema, piya kampaye ikibewe. ");
INSERT INTO for_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Piya, Koti esegiyena namegi keba agaruba igasoganaba Koti kabiratakenaenaba tigetiba ago aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Untana Isu to ka amato puma maya uwaimintiye: Ka akentana yagarama ireguwape wanta'wape pumagina, na kuma'wapa kabiyekana, a'ya'maenawapa aogima waikiye. ");
INSERT INTO for_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pigoya, tabera esegiyena waitantakibi ntagara irosa'maba, aepa'urintana iregu wanta'wapa apau'ma, yaga kotankapa pako purikiye. ");
INSERT INTO for_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Pigoya, ka'waina aeba kayone kampa punatai'naba, pipa kama punataye. Piya, ka'waina aeba yagarunte kampa ibabuma aki pi'naba, aeba igarubaye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Pigoya, Isu toba maya untiye: Kewamaba wasanama antabaipisa irosa'ma wama ka'me mpari maruka aguyosakate, kampa waintakana maya ukiye: Namantepa atate kanantoka, pita'i to kake a'wae pumagi wama umikuwe, ukiye. ");
INSERT INTO for_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Otate a'wae puma wama agaomepa, kana namapa paga puma aogi nama uma agakiye. ");
INSERT INTO for_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Piyaena agatategina aeba wama ke aokinapa tonaentisa tara umaema kina to kake kamparagaena pe kina ibabekini, kanama pi ntamapi ampikibewe. Aibigina, pi ntagaraba aeba paipa aogi yagara mintanti'naba aintiba kampa aogimagina tabera ata puwakiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kamana piya uma mintogana, wasana abakapintisa waya ka'waina kega'ye uma maya omintiye: Yakari pugatama nono kaminti waepa, aeba a'muntanabi miyeno, yogana, ");
INSERT INTO for_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Isu maya untiye: Pi yempepa, pipa Koti kamana abima maema miye kina ige i'muntanabi mikibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pigoya, wasana uwoma kina aeti kanama pumaeyuguna, agobima kamana maya untiye: Mamparasa antage kina tigeba kukantanaga ebi ebi punatawe. Pigoya, tigeba kukantanaba tonawanane. Yonati aboranti, pabintana aborakiri agakibewe. ");
INSERT INTO for_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pigoya, pai Ninibe kumatasa kina'mi igeba Yona puntintana agama napintasa puma, ibasa yaga mamparasa kina tigeba Wasanama Ntagaramana pukubontanaba agama napikibewe. ");
INSERT INTO for_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pigoya abiyo. Mare takaerisa tabe wae aeba pabiyamagina a'ya'ma kina pako pikena yagaba mampabisa kina'miti kamparaga kamanati abora uritakiye. Pipa uwaba kampaye. Pi kana waepa aeba e'ero mparisa kanama Soromoni aetisa mono abintiye. Piya, ma minto naeba Soromoni ae awametapa kampaye, pipa asugasima mintuwe. ");
INSERT INTO for_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Piya, toba abiyo. Ainti Koti a'ya'ma kina pako pikibi ntagaba Niniba kumatisa kina aborama mamparisa kina'mi kamparaga kamanati uma abora uritakibewe. Pipa uwaba kampaye. Niniba kumatasa kina igepa Yona aeba wasanaraka'yankama ige'ma kamana uwaimogini abima igu a'wae puntaka, piya ma minto naeba Yona ae awametapa kampaye. Pipa asugasima mintogiri, pabi ntaga tigeba kampa piyama a'wae pigina, pi Niniba kina uritakibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Pigoya, Isu to maya untiye: Tigeba kane igi'maba kampa kakantiri, kaborasaba kampa akunewe, pipa kampaye. Tigeba kanepa igi'ma marunkata atagana, na antabaipintiba e'wasa pekana wasanaba asu agakibewe. ");
INSERT INTO for_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Piya, kau'ama kane'wapa kaowe. Kaogapa aogima waintanaba, kau'amapa kanara e'wasa potakiye. Tikaeyakanaba kau'amaba pabiyama tunusu wakiye. ");
INSERT INTO for_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pigoya, kagu'ama kane'wa tu'makana tunususanaga aogima kiya kabima miyo. ");
INSERT INTO for_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kiya kabiyegana, kaetiba tununtanaba kapa kampa aborano. Kagu kau'amaba e'wasaenamana waikiye. Pigoya, kane uwaenama e'wasa pemisa puma, kagu kane'amaba e'wasa pugatakana mikibene, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pigoya, kamana uma miyogana, Parasi ka'waina Isu nanintaga nankapi agega'e untiye. Agega'e yogana, nankapinti ima pabi naninta asu nantiye. ");
INSERT INTO for_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Asu naomeka, ayapa kampa wani nkaema aeyobanta naogana, Parasi yagara agategina, uwoma agi napima: Nanabaya pemika monoka kampa napiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Piya yogana, Wa'ega aeba abite maya omintiye: We, Parasi kina tigeba, tu'natipa kankabepe aririsamana aeyobawe. Pigoya, tigupipa kuntanaripe ataenaripe pumaema waintiye. ");
INSERT INTO for_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","We, aibo kina tigeba, kampa napiyewo. Koti ariribe antabaipintibe pumarantine. ");
INSERT INTO for_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pika tigeba antabaipinti waintintana kusi kina imigina tigeti i'nintana kampa waikiye. ");
INSERT INTO for_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","We, Parasi kina tigeba atama mikibewe. Tigeba a'ya'waemaenaripa aisurite wagana, naya tara'mu pegiripa, agentoba Koti amintiri, kaipe marababe a'ya'waema anintabe pabiyama kampa tigegu'a pekiri amintiripa, Kotige atokaema mikenaenagaba nanaga kampa napiyekiri, aogima arupu puma mikenaenaba nanaga agasawe. Pi ariwape agu'wape tarayaga aogimakiri wasiyesinta, aogiyenabi miyesine. ");
INSERT INTO for_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","We, Parasi kina tigeba atama mikibewe. Nanagabaya mono namapi wa'ega kina'mi yabaera paitama mikenaga yewe. Piya ke'i wa waya uwa kina'mi tigamagini uma i'muntana puritasanaga pintanaga tigu'amaba waiye. ");
INSERT INTO for_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","We, tigeba atama mikibewe. Tigeba wasana iru kaigainta piyama, pita'i wasana igeba kampagini napinta abobori nasi nasi pewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Isu aeba kamana piya yogana, kamana ago abinta yagara ka'waina abima maya omintiye: Tisa, kaeba kamana piya yekanaba, kamana ago abinta kina tae uma tarakuriye, untiye. ");
INSERT INTO for_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yogana Isuba maya a'wae pomintiye: We, kamana ago abinta kina tigege tiyekuru piyo. Tigeba kuntaenaba wasana ibobori aesaga itategiri, tigeripa uwa mima, aesagabikena tigiba kampa napiyewe. ");
INSERT INTO for_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","We, atama mikibewe. Tiyabamagiba poropete kina iyeguma kaintakiri, tigeba ibaba iyeguma kaisubewe. ");
INSERT INTO for_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Piya puma, tiyabamagi iyo'maemagiri, ma'enawaika abegana aogi piye. Igeba iyeguma karana itantawe. Pigoya tigeba kamana agowai aeguma kaiyewe. ");
INSERT INTO for_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Pigoya, pika Kotiba aogima napima kapa maya untiye: Naeba igeti poropetebe aposorobe uwaitauwagini wauguripa, ka'isaba iyeguma ata puwaitakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pigoya, pipa pai wasana aboranta kanabi, agobima poropete kina iyeguma koranka airigita kananta, pi kaintanaba pipa tigeti kanakiri kamana maekibewe. ");
INSERT INTO for_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Pi ma'enaba pai Eboropisa agobima aboraurite kanama, Sekaraya aepa tabe mono nama antabaipinti aeguma a'ya puntane. Naeba taga yekiri abiyo. Pi kamaena pi'na kaintawapa mampa ago tigeti ampa aborakana kamana maekibewe. ");
INSERT INTO for_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","We, kamana ago abinta kina, tigeba atama mikibewe. Tigeba mono'ama agowapa kakatamagiri miyewe. Tigeripa kabe ai'ma kampa uma pai'ma abewe. Piya, wa waya pasikena yegiripa, kabeba akunkigasawe, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pigoya, Isu kamana piya uma a'ya atate abe'i irosaogini, kamana ago abinta kinape Parasi kinape Isuka ataena otama, igeba to kamana to kamana'wa abigategini, ige atakae puma mintantawe. Piya puma mintogini tabera uma abigantawe. ");
INSERT INTO for_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Pipa maya uma puntawe: Ka kamana awamupisa irugekapa abima kamana otakune, untawe. ");
INSERT INTO for_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Isu aeba kamana uwaimima mintogini, uwoma kina'mi aeti irosa'ma mimagini, kabokabo puma igisa aebabuma mintantawe. Piya puma mintuguna, a'waebuma abagi kina'wampiba maya uwaimintiye: Wasanama pareti kaintanaba isiti atakanaba anosamisa puma, Parasi kina'mi ata kamana'wai piyama anosasanaga kabiyiyo. Naeba pi kumpari kamana'waika uma, obina kamana urimuwe. ");
INSERT INTO for_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Pigoya, a'ya'ma airarikaenta'enaba a'waigaikiye. Kakama waintintanaba a'ya'ma aborakini abikibewe. ");
INSERT INTO for_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tigeba tununtanabinti ye kamanapa uma yepa, pipa nama nkaboborisa kega'e uma aborakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Isu piya untana to maya untiye: Nao'mitaba, maya urimuwe: Tau'ama aegukena pikibe kinakaba a-tiyekuruba piyo. Igeba aintiba tonaba kampa puritakibewe. ");
INSERT INTO for_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pigoya, to ka'enaga tiyekuruba peno. Pika urimekiri abiyo: Agagabinti tipasanakena esegiyenawa waitantemi ntagara, aeka taga tiyekuru pikibeka yuwe. Owe, piya urimuwe. Piya aeka tiyekuru piyo. ");
INSERT INTO for_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Piya, kisabentontoba wasana uwaena monentorasa ika pewe. Pigoya Kotiba igekaba kampa a'yuguba puwaitaye. ");
INSERT INTO for_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pigoya, wasana tige ti'no nkabiyapa aeba aisiye. Pikaga tiyekuruba apuntiri uwa miyiyo. Tigeba wasanarawe. Inati pa'ma nasi nasi pemi kabarankama ikantanaba tigeba agasawe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Isu untana to maya untiye: Pigoya, to ka urimekiri abiyo: Ka'waina aeba wasana iyobi uma aboranatakibipa, Wasanama Ntagara naeba pabiyama Koti enisorewampi ige iyobi aepa uma aboratakuwe. ");
INSERT INTO for_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pigoya, ka'waina wasanami ige iyobi kakanatakibi'naba, aepa Koti enisorewampi iyobi kakatakuwe. ");
INSERT INTO for_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pigoya, ka'waina aeba Wasanama Ntagaramanteka ata kasa unatakibipa, aepa aguntaenawapa asu'a pugaikenaena waintiye. Piya, ka'waina aeba Aota Awamusa'ama yogawaka uma ataena potakibipa, aepa aguntaenawapa kampa asu'a pugaikiye. ");
INSERT INTO for_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Pigoya, mima mono namapipera, kamanipe kanisorebe igeti tibabute waigiripa, aya kamana ukunemaba abima tara taraba a-piyo. ");
INSERT INTO for_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pi kanabipa kamana ikibepa, pi Aota Awamusa'ama uma abora timikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pigoya, wasana abakapisa ka yagarama Isupa maya omintiye: Tisa, nagantoba tasibaresimpa kutapa ae maema miye. Pika kaeba omegana pako buma ka'isaba nae nameno, untiye. ");
INSERT INTO for_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Piya yogana, Isu maya omintiye: Ma ntagara, naepa kiyabe kamana abikena yagarabe miyomaba kampa unatantawe, untiye. ");
INSERT INTO for_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Piya uma kamana ka amato puma maya uwaimintiye: Tigeba aogima napiyiyo. Mone kutankamaka tintawama napi napi pusanaga antapiyiyo, uma urimuwe. Mone kuta abuwakenaenama wasana mikenaenari araku'ma esegi pekiri kampa mikibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Piya uma awame kamana ka maya uwaimintiye: Wasana tabe kota wainta ka'waina aeba yogawapipa nanintaba uwomantana aborantiye. ");
INSERT INTO for_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Pigoya, aumabipa mayama napintiye: Aya pukuwe. Ago tabe namapa aeta waintaka aki pukuwema napintiye. ");
INSERT INTO for_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Piya uma maya untiye: Ibaba ago abuwe. Naeba aintana namapa akusaba'ma kasa nama tabe puma kikuwe. Kima aintananepe a'ya'waemaenanepe pipi atakana waikiye. ");
INSERT INTO for_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Pigoya piya pugaite maya ukuwe: Uwoma ntaninta wainatantika, migaramagi e'ero kanara uwa mimagi, nakenabe wanipe namagi na'muntanabi mikuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Piya yogana, Kotiba maya omintiye: Kaeba aibo yagaragawe. Ma nkase kaumagampa maegasakana pu'wakibene. Pigoya a'ya'maena maema aki pempentanagapa kebaya maekiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Isu piya untana to maya untiye: Pigoya, ma kina'miba arirasaenamana napi napi puma aki puntini, Koti nkaobi kusiyena pewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Isu aeba abagi kinapa maya uwaimintiye: Naeba urimekiri abiyo: Tigeba mikenaenarikaba: Nana maema nakune. Ti'amakaba: Nana tautasaenaba purukunema, uwoma tigiba a-ntapiyiyo. ");
INSERT INTO for_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Piya, naninta wanane. Mikenaenarimpa au'wantaga'enawe. Titasaena wanane. Ti'ama au'wantaga'enawe. ");
INSERT INTO for_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tigeba kabarakaba napiyiyo. Igeba aintanaba kampa puma nanintaba kampa kubewe. Ige'wai nkaintana namankaipa kampa wainteg'ina Koti nanintawaipa uwa aborama imiye. We, tigeba kabarapa kampaye. Ae aobipa tigeba wasanarawe. ");
INSERT INTO for_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Piya, tigeba napiyenaripa waintakiripa mampara to kake amato puma to ka'isa yaga mirite wakibewa, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Tigeba piyaenaga igiga puntiripa, nana piyema mikenaenagaba uwoma tigiba napiyewe. ");
INSERT INTO for_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","We, tigeba ya aosa pamika agoba abiyo. Aeba aotasaenawampa ntugaba kampa piye. Pika urimukuwa abiyo. Paipa tabe yagara Soromoni aeba konariyenawantaga yagaramaba aogiyenaba purintomepa, ya aosawamapa kampa againtiye. Kampaye. ");
INSERT INTO for_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Piya, yaobintisa a'no mparamintana ibanto piyama aogima aborama, aiba pari pekana yaku kaiyamipa, pipa Koti yegina a'nopa aogiyena maraye. We, tigeba kampa agama napiyegana timatiti'enaripa uwaenantowe. Piya, Kotiba titasaenarikaba kabiritaye. ");
INSERT INTO for_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pigoya, tigu'amaba naninta wani ntakenaenagaba taberapa a-ntapimagiri, tigeba uwoma tigi a-ntapiyiyo. ");
INSERT INTO for_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","We, a'ya'ma maga maga kina'miba nae yontanaga napi napi yewe. Piya, pintanarikaba tibarimpa abintegiri uwoma tigi a-ntapiyiyo. ");
INSERT INTO for_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pigoya, tigeba Koti kabiratakena mono'ama nkau'wa aborasanaga tigupa paitama ataigina waiyeno. Piya pigina aeba mampara tige'enaba kaga aborarimikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Pigoya Isu to maya untiye: Uwaena tunkantontoba, atiyekuruba puma miyiyo. Tibarimpa tabe a'mu puma kabiritakiye. ");
INSERT INTO for_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Pigoya tigeba aogimagiri piyaena waintemipa kusigina imiyo. Piya piginiba aogiyenaripa mantabinti uwa waiyekana kopa kampa abararamaba kukuri kampa pikiye. Piya, pita'i antota waima esegi pikena waikiye. Piya, ku kina'miba kampa kuntanaba puma maerigasiginaba, umuwamaba kampa narigaikiye. ");
INSERT INTO for_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Piya, aogiyenaripa waintemi, pi kumaka asi nasi napiyewe, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Isu to kamana maya untiye: Tigeba kairipa arosama amimagiri, e ikigina e'wasa peno. ");
INSERT INTO for_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Piya kayokaya yagaramiba wasana wa'ega iba'enarisa a'wae puma kanama uma kabera aiwakarusekini, karu'ena ai'atakena agawa pesa puma miyiyo. ");
INSERT INTO for_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pigoya, wasana wa'ega aeba a'wae puma kanama kayokaya yagara igeba iyogaba puma mintiginaba ampa igate a'mu puwaitakiye. Naeba taga taga'ya urimekiri abiyo. Aeba eri'ya kaiwapa amirintana naninta yabaera itama naninta imikena kayokaya'ena puwaitakiye. ");
INSERT INTO for_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pi aseka abubuno, marikiyo, kana yagaraba kanama ampa igakibipa iyogaba puma kabima mintigina ampa igategina, tabera a'mu puwaitakiye. ");
INSERT INTO for_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pigoya tigeba agowapa mayama abiyo: Ka kumatasa kina ku kina ma aseka irosakiyema napiyisinta, iyogabama mima nama kuma'waipa kabiyiginaba kuntanaba kampa maeyisine. ");
INSERT INTO for_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pigoya Wasanama Ntagara naekaba pabiyama kampa napikibe kanabi, kanakuboka aseyo puma miyiyo, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Isu aeba kamana piya yogana, Pita abigama maya untiye: Kaeba awame kamana mapa tae tabireka yepera, a'ya'maga yenema abigaogana, ");
INSERT INTO for_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Wa'ega kamana mayama amato puma untiye: Wa'ega ka'waina kayokaya kina'wampi ige kiyawaika otamagina maya omikiye: Naeba wama umintakanapa, kaeba kiya kabiwaitama asi nasiba naninta ka awameta imima miyo, ukiye. Pigoya, aeba ayama miyekanapa kayaba mono wantaga awamu wasikenaena wantagane otaiyo. ");
INSERT INTO for_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Piya, aeba yoga otanta pipa aogima puma miyekanaba, wa'ega yagarawapa irosa'magina abekanaba a'mu potakiye. ");
INSERT INTO for_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Naeba taga taga'ya yekiri abiyo: Aeba pi ntagaraba pipa kiya tabe otama a'ya'maenawatapa kabiyenoma otakiye. ");
INSERT INTO for_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pigoya, pi kayokaya yagara aeba wa'eganepa agaropa kampa kanakiyema, antabaipintiba napimagina, karana itamagina, kayokaya kina wabe wayape iyegumagina, nanintabe esegi wanipe nama aibo abo'ena puma, karana itakanaba, ");
INSERT INTO for_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","togana wa'ega yagarawa a'wae puma kanakena kanapa, pi kampa napinta mintakana, agaronkanto irosa'ma agaruba'ma a'yugu pikena kina ai'aruyenabi atakana ata maru mikiye. ");
INSERT INTO for_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Piya, kayokaya yagara ka'waina aeba wa'egawampa awamupisa kamana abintana akayukenaena aborakanaba, aepa tabera aegukiye. ");
INSERT INTO for_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pigoya ka'waina aeba tabe yagarawampa awamupisa kamana kampa aogima abinta, akayukenaena aborakibi, aepa ise'antora aegukiye. Pigoya, ka'waina aepa piya uwomantana antotapa maekibewe. Pigoya, ka'waina aeba tabe yuga otanta yagaramaba pipa esegi puma to kake aisuma maekiye, Isu uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Pigoya Isu to maya untiye: Naeba mabi esegi yaku kaekena tumintuwe. Piya, ago yakunkama aburama tasanaga nabiye. ");
INSERT INTO for_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Naeba ka pasoma unatantine. Pigoya ibaba abikenaenanempaba kunta nabiye. A'ya'ma paitikenaenaba aseyonaba kampa punataka asaba punatakibewe. ");
INSERT INTO for_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Tigeba naekaba ayama napiyewe. Aeba mampabi paruyena aborakena tumintiyema napiyewe. Kampaye, Abiyo: Naeba atataraena aborakena tumintuwe. ");
INSERT INTO for_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pika ma kanabipa mayama aborakiye: Ka namapi nayaka'mu kina mikibe'nagiba igeba ma'ena puma, atatara purite wagana pikibewe. Pita'i taramisi naegaraisiginiba kakagamiba imo kamana ukibewo, kakagami naegaraiginisiba taramisiba isimo kamana ukibeso. ");
INSERT INTO for_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pigoya atatara mikibewe. Abage yagarawampage isigeba ma'ena puma, atatara purite wagana pisigina, pabiyama anoge aragawampage isigeba ma'ena puma atatara purite wagana pikibese. Pigoya, aentawampage anatuge isigeba pabiyama ma'ena purite atatara pikibese, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Piya uma, wa wayaka maya untiye: Tigeba ma tunusegiripa agamaba yewe: Ka aekena piye yegana aeye. ");
INSERT INTO for_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma arawagiri agantiripa yewe: Esegi patakiye yegana pata waye. ");
INSERT INTO for_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","We, kumpari kina mintawe. Tigeba mawamake ibinankamake agowapa abewe. Pigoya ma kamana'ama agowapa nana piyema kampa abibebe pewema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tigeba nana piyema aogi kipe ata kipe kampa agabebe pewe. ");
INSERT INTO for_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Pigoya, tigetisa ka'waina kamana ugatakanaba, kamana abikena yagaramati kampa uma ke'i wantirisi, kamanatisipa uma aogi puma aebarota urite waiso. Piya kampa pikibemepa, pi ntagaramaba karu'ena abikena yagaramati uma kamanakapa yekana, irebu kina'wa otakana, kababuma iga'na namapi katakiye. ");
INSERT INTO for_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Naeba ugamukuwa, abo: Kaeba pi nkiga'na namapi mintanapa uwaba kampa irosa wakibene. Aintiba iretaba amima a'ya kaite wakibene, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pi kanabi, ka'isa Karariya marisa kina'mi wa'ega yagaramanta kao'ena puma, muta atakena yagaba ibabute kanama aeguyuguna, Pairati yogini, irebu kina'wampi kana kinapa iyeguyuguni, pi wasana kurape yaga kurape a'yugu puwantiye. Pigoya wasana igeba irosa'ma Isu pabiya awaga kamana omuguna, ");
INSERT INTO for_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","maya uwaimintiye: Tigeba Karariya kinakaba ayama napiyewe. Ige aguntaenamaba to a'ya'ma Karariya kinapa igaintomeka piya puwaitantawema napiyewa, a. ");
INSERT INTO for_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Piya wanane. Abiyo. Tigege ataenaripa kampa kaite tigu kampa a'wae pikibepa, pabiyama ata maru mpima pu'waewakibewe. ");
INSERT INTO for_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Piya, paipa Sairomu namapa e'ero namapa takumagina, tonagisarisa kakaga umaema kina iyeguntiye. Pigoya, igeka ayama napiyewe. Ige ataenawaipa to a'ya'ma Yerusaremi minta kinapa igaintomeka, piya puwaitantiyema napiyewa, a. ");
INSERT INTO for_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Piya wanane. Abiyo. Tigege ataenaripa kampa kaite tigu kampa a'wae pikibepa, pabiyama ata maru mpima pu'waewakibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Kamana piya uma, Isu meto kamana ka maya untiye: Wasana ka'waina yogawapi yamankapa ka ku'maraogana i'ma intiye. Pigoya to yaga wamagina agauka, uma agiyosa agaomepa kampa agantiye. ");
INSERT INTO for_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Piya puntana, kayokaya yagarawa maya omintiye: Naeba ma ntawama nka aesanaga kabimaete kanaogana, kaboba kakaga agasaye. Ya aeba nanaga nae yugabinti uwaba taberapa wairite wakiya, a. Aerawane agaiyugaso, omintiye. ");
INSERT INTO for_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Piya yogana maya omintiye: Naba, kaeba uwa atanto, ma kabuba miyeno. Piya, naeba agobintisa yonintana puma imupaena peno. ");
INSERT INTO for_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Pigoya, toganaba a aesanaga agaiyo. Aeyakaraba uwa atakuse. Kampa aeyakaraba agai'yugaikuse, untiye, piya kamana Isu untiye. ");
INSERT INTO for_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pigoya Isu aeba ka sabatira mono namapi ima mono uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Pigoya, pi ntamapi waya ka mintantiye. Aeba kewama ka'waina antabaipinti mintogana, kaboba tonagisarisa kakaga umaema kabuwa a'ya pogana mintantiye. Piya, ayamagina ituru puma misuwe, uma parokaema nasi nasi puntiye. ");
INSERT INTO for_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pigoya, Isuba waya pipa agamagina kega'e uma maya omintiye: Waya, kaeba ituru pogana, yonikapa kata wano, untiye. ");
INSERT INTO for_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Piya uma ayapa a'nota atama yogana, pabigo ituru pumagina Koti a'mu potantiye. ");
INSERT INTO for_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pigoya, Isu aeba waya pi sabatira aogi puma kaba atantika, pi mpono nama kiye yagarama agama abogana ataena abogana, wa waya maya kamana uwaimintiye: Yogaena pikena kanaba tonaentisa ka'umaema yaga waintiye. Pita kanaigina aogi puritano. Sabatirapa kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Piya yogana, Isu kamana mayama a'wae pomintiye: We, kumpari kina tigeba, sabatirapa purumakatino, osirino, namatipisaba iyoba urite wanitiba ibabute wawo. Ago pabiya pewe. ");
INSERT INTO for_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pigoya, waya mapa aeba Abara'amu nkaga'nuwe. Piya, Satani iga'na ubu atagina kaboba tonagisarisa kakaga umaema kabuwa mima mintantiye. Pigoya naeba ma sabatira ataogiripa aogi tigi napiyewo. Pipa kanarane, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Piya uwaimogini, igeba abima inintana ibogini, kamana kampa untawe. Piya, wa waya uwoma kina'miba pintana aogiyena pomeka i'mu puntawe. ");
INSERT INTO for_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Isu aeba kamana kapa mayama amato puma untiye: Koti kabiratakenaenaba ayaenabayaka, nanarapaya meto puma abukune. ");
INSERT INTO for_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Aeba masiteti a'wa piyamawe. Wasana ka'waina yogawati ainka asikitaogana, i'ma yaena peganaba, kabarankamaba kanama ayampuwatapa ampima anapa kiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Pigoya, to ka amato puma maya untiye: Koti kabiratakenaenaba ayama to meto puriyakikuwe. ");
INSERT INTO for_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Aeba paretibi atama kaekenaena agewapa yisiti piyamawe: Piya, waya ka'waina pi yisiti maemagina uwoma parawabinti atama, paegu potama ataogana, kana paretiba anosakiye. Aeba piyama waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Pigoya, Isu Yerusaremi kumati wakena tabe kumatibe uwaena kuma'antontoribe nasi nasi puma mono uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Pigoya wasana ka'waina mayama abigantiye: Wa'ega, wasanaba tarantomibaya iba pekini ikibebe, ayabaya pikibewema, abigaogana, Isuba maya omintiye: ");
INSERT INTO for_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Uwaena kabintori uma pasikenaba iyampuba pabi pabi puma uma pasiyo. Wasana uwomampi uma pasikena ikibepa, umaba uwa kampa pasikibewe. ");
INSERT INTO for_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Piyama na nkagowamaba aeba asima kabe akunkatama mintakiripa tigeba na komari uma, asima mima aiwakaru suma maya ikibewe: Wa'ega kabe a'wairatao, yiginaba maya urimikiye: Tigeba kegitawe. Kampa tigao kinatawe, urimikiye. ");
INSERT INTO for_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Urimekiripa, antotapa maya omikibewe: Taeba kaege kaga mima nanintabe wanipe nantompene. Pigoya kumatetiba monopa yuku abintompene, yiginaba, ");
INSERT INTO for_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","abintanaba maya urimikiye: Piya urimuwe. Tigeba kegitawe. Kampa tigao kinatawe. Tige aguntaena pe kinatawa natate waiyo, urimikiye. ");
INSERT INTO for_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Pigoya, Abara'amuwa, Aisakiwa, Yekobuwa, to a'ya'ma poropete kinana, suma, Koti kabiratakena kumati mintikiri igaigina, tigeba tigarubaigiripa mima, tiwara upaba puma, kube'ena puma mikibewe. ");
INSERT INTO for_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pigoya, pa nkirosamitisabe tupasemitisabe marenkau'isabe menkau'isabe, pita'isa wasanaba irosa'ma Koti kabiratakena kumati ima naninta nama i'mu pikibewe. ");
INSERT INTO for_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Piya, abiyo. Pita'i ka'isa kayokaya kina'mi kiya mikibewe. Piya, ka'isa kiya kina'miba kayokaya kina mikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pigoya, Isu aeba kamana piya yogana, pabi kanabi Parasi kina ka'isa irosa'ma maya uma omintawe: Eroti kaegukenaga iye. Pika ma mpaba kaite karu'ena wao, untawe. ");
INSERT INTO for_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Piya yuguna maya uwaimintiye: Tigeba a'wae puma wama, kana kabu karamapa maya omiyo: Abeno. Naeba ibabe aibe wasana ke kina agaruba igasima kaba itakuboka, magaba yoganepa a'ya wakuwe iye, omo. ");
INSERT INTO for_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pigoya ibabe aibe magabe naeba ke'i wakuwe. A'yugu uwa mari wakini poropete aegusanaga, Yerusaremi kumati wakini aeguyigina purikibipa kanarane, Isu ae'waka piya untiye. ");
INSERT INTO for_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Piya untana to maya untiye: We, Yerusaremi kinane, Yerusaremi kinane, tigeba nana pewema poropete kamaena puwaitama, mono kina tigeti uwaitanta kinapa yaba kasutasa iyeguyewe, a. We, kokorewama awa ki'nunka ibabuma agagapinti itama isamu pemisa puma, naeba tibabuma aki puritakena pogiri, a'a-o urite kanantawe. ");
INSERT INTO for_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Abiyo. Pika nama kumatipa atakana agamaena puma kabu isubikiye. Piya, naeba to yekiri abiyo. Naeba titakiri to kake kampa nagamagiri mirite wamagiri, ainti naeka: Wa'egawama nkagera kanaya, aeka ta'mu potano, ukibepa to kake nagakibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pigoya, to ka sabatira Parasi kina'mi kiye ka'waina Isu nanintaga kega'e yogana, namankapinti iyogini, Parasi kina'miba pabipi kaga mima kamana'waka kabima mintantawe. ");
INSERT INTO for_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Piya yamoruyena abome kina ka iyogana, Isu agantana, ");
INSERT INTO for_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","kamana ago abinta kinape Parasi kinape mayama ibigantiye: Tigeba yiyo. Sabatirapa ma ntagaraba aogi potakupera aya pukune, yogini, ");
INSERT INTO for_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","asaba'wantawe. Piya puguna, kana yagara ayata taku u'ma aogi potama agarubaogana wantiye. ");
INSERT INTO for_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Piya aogi potamagina, pi mintume kina igepa mayama ibigantiye: Yagaripe purumakatipera kabinti, sabati yaga tumekiripa uwa ataigina waikibera, pabi sabatira uwa paibigina ikiyema, ibigaogini, ");
INSERT INTO for_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","kamana a'wae puma omikenaga aguyosakate atantawe. ");
INSERT INTO for_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pigoya wasana ka'isa nanintaga kaga igega'e unta kina igeba napiyenawaipisa tabe yagarama yabaeba maema miyuguna igama maya meto kamana uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Kaeba ka'waina iba'ena pikena kagega'e yekanapa, napiyenagapisaba marusa yabaeba maemaba a-mpiyo. Piya pegana tigega'e untatisa ka'isa kina igetisa kae kagasima minta ka'waina irosakana, ");
INSERT INTO for_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","kao'ena agowamaba kaepa maya ampa ugamikiye: Pipa ae yabaewe. Ae'watao, yekanapa, kaeba a'wae puma aintisa yabaera tumpima kani pikibene. ");
INSERT INTO for_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Piya wanane. Ka'waina kagega'e yekanapa kaeba aintisa yabaera miyo. Mintagana kao'ena agowamaba kagama maya ugamikiye: Nao'anto, kaeba ima marusa yabaera paitama asu miyo, piya ugamekana, pi naninta nakibe kina'mi nkiyobi kantawamaba aogi pikiye. ");
INSERT INTO for_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pabiyama, ka'waina aeba au maete ikibi'napa tumikiye. Piya, ka'waina ae'wa nkau maete tumikibi'napa maema mesuba potakiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Piya untana, wasana igega'e yome ntagara aepa toba maya omintiye: Kaeba naninta kao'ena puntanapa, kao kinape kaganto ka'nantobe tigerupe, kumakatasa uwoma kuta wainta kinape, a-nkigega'eba yo. Piya, igeba nanintaga igega'e yeginiba, kaepa pabiyama antota kagega'e uma atukapa kamigina a'ya pikiye. ");
INSERT INTO for_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pibiya kampaye. Naninta kao'ena puntanapa, kusi kinape karaena nagainta kinape agisa antage miru kinape aorika kinape, piyama igega'e yegini naigina, ");
INSERT INTO for_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","antota kampa maenta uwa aogima mintagana, aintiba taga mono kina asikibe kanabi, Koti antota kamekana ka'mu pikibene, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Isu aeba piya kamana yogana naninta naume kina igetisa ka'waina abite maya omintiye: Koti kabiratakena kumapi naninta nakibe kina i'mu pikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Piya yogana, Isu kamana ka maya omintiye: Wasana ka'waina tabe nanintaena puma aki puntana, wasana uwoma kina igega'e untiye. ");
INSERT INTO for_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Piya puma yokege potate, wasana kana iminti kinati kayokaya yagarawa otaogana wama: Ago kao'enaba puma a'ya atauna kanaiyo, uma uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Uwaimogini, igeba a'ya'ma uwa a'yugu kamana uma: A'a-o untawe. Piya, ka'waina aeba maya untiye: Naeba kasa ma ika pumaratoka, pita'i wama yogaenane pukuwe. Pika kaeba tabe yagaragapa uma omegana abima ataba a-punatano, untiye. ");
INSERT INTO for_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Piya yogana to ka'waina maya untiye: Naeba purumaka nayatara'mu ika pumaratoka pita'i wama uma yoga pukuwe. Pika kaeba wama tabe yagaragapa uma omegana abima ataba a-punatano, untiye. ");
INSERT INTO for_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Pigoya to ka'waina maya untiye: Naeba waya maetoka, ayama wakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Piya yuguna, kayokaya yagara aeba abite a'wae puma kanama, tabe yagara pi kamana omogana abima ata puntiye. Ata potamagina kayokaya yagarawa maya omima agarubantiye: Kaeba karu'ena wa'ega wa'ega nasi nasi puma a'ya'ma ki'i wama kusi kinape karaena nanta kinape igisa antage miru kinape, ibaburite kanagini nanintanepa ampa naiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Piya yogana, kayokaya yagara wagaite kanamagina, aeba tabe yagarawa to maya omintiye: Tabe yagara, kaeba kamana yempesa puwe. Piya popa namapa marupa uwa waiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Piya yogana kana yagarama kayokaya yagarawa maya omintiye: Pigoya, kaeba to ki'i wama yogari mintakibe kinape kakama kumati wasana mintakibe kinape, tutusuwaitagini kanawaema namantepa ampa pumaeyiyoma uwaimo, untiye. ");
INSERT INTO for_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Piya, ka kamana yekiri abiyo. Paitama maru igega'e unta kina, igeba nanintanepa kampa nakibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pigoya, uwoma kina Isu aegarauguna a'wae puma maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Ka'waina aeba naege mikena puntanaba, ano abape waya yagarawape, aganto a'nanto amana'mape, igepa aekita puwaitantana, ae'wa nkau'wapa pabiyama aekita potakibi'na, aeba kayokaya yagarane mikiye. ");
INSERT INTO for_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ka'waina aeba kampa maripowa aesaga'urite, kampa naegarakibi'naba nae kayokaya yagaranepa kampa mikiye, Isu piyama meto kamana untiye. ");
INSERT INTO for_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Piya untana to maya untiye: Pigoya, tigetisa ka'waina tabe nama amato puma kirite ikena puntanaba, marupa ikantanamaka napima, yabankapa maema aisumagina kanara kikube kampabayawema, pi'na nkagowapa abima napikiye. ");
INSERT INTO for_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Piya kampa punta, namanka ku'ma kaitantanaba yabaka aguyosagate kasakini, wasanamiba kampa kimaranta namapa agama, kagi potama, ");
INSERT INTO for_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","maya ikibewe: Ma ntagaraba kampa napimagina aganta namapa ku'ma kaitate kasagina kasipama waintiye, piya ikibewe. ");
INSERT INTO for_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Pigoya, ka marisa wa'ega yagarama to ka marisa wa'ega yagarama aokina'mige kamaena pikena puntini, uwa a'yuguba kampa uma iyegukibekana, aeba paitama maya ikiye: Taeba 10,000 kina mintokini, igeba 20,000 kina mintawe. Pigoya igepaya igasima iyeguwaegaikupe, taepaya tagasima taeguwaegaikibewema, napigaitegini kana kamaena pikibewe. ");
INSERT INTO for_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kampa igaintini uwa atate, ayaki kuta timima uwa aiyekana uwa aema paru pukuwe. Piyama wasana agarubakana apa nkakiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Piya untana, amato puma maya untiye: Pigoya tigetisa ka'wainaba aeba ayama a'ya'waemaenawapa kampa kasiwaentapa, aya puma yagaranentanaba puma mikiye. Pipa kampaye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Pigoya to urimuwe: Kayoba aogi igaenawe. Piya, i'nisama kasigabekapa, aya pekana to kake asabama iga pikiye, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pipa piyaena pikenaba kampa waintegini, uwa mariba asunu kaekasawe. Ageyaga kina'maba ma kamanapa abibebe peno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pigoya, takisi mone maekena kinape kamparaga kinape Isuti monowa abikena tabera irosa'ma mintantawe. ");
INSERT INTO for_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Piya puguni, Parasi kinape mono tisa kinape igeba pika abimagini, Isu ata potama aeka maya untawe: Ma ntagaraba kamparaga kina ao'ena puma naninta kapisa naye, piya untawe. ");
INSERT INTO for_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pigoya, pika Isuba meto kamana maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Tigetisa ka'waina aeba 100-wa sipisipi atama mintakana, ka'anto kaka wakanaba uwa kaikiya, a. Kampaye. Aeba ka'isaba 99 kuma'waipinti itakini, kabuyena nama mintigina kakawai'naka aguyosagakiye. ");
INSERT INTO for_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aguyosama aboratama a'mu puma aesaga uritegina, ");
INSERT INTO for_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","kumati uma irosa'ma aokinaka kega'e uma maya ikiye: Sipisipine kabubi kaka wantipe ago abatamagi ababute kanauwe. Pika ta'mu peno, ukiye. ");
INSERT INTO for_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pabiyama naeba urimekiri abiyo. Wasana 99-wa monota mintiginaba, igekaba pi mantariba a'muntana waikiye. Pigoya, agunta yagara ka'waina agu a'wae pekanaba, aeka mantariba a'muntanaba ima tabera aborama to a'muntanaba igaikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Pigoya, Isu to meto kamana maya untiye: Waya ka'waina nayatara'mu mone u'ma mintakana, ka'anto tumiwakanaba kaikiya, a. Kampaye. Aeba kane igi'ma nama paga puma aogima aguyosagakiye. ");
INSERT INTO for_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Aguyosama aborama waya aokina kega'e uma maya uwaimikiye: Monene kaka'waipa pi ago abatama maeyuwe. Pika ta'mu peno, ukiye. ");
INSERT INTO for_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pabiyama yekiri abiyo: Mantari Koti nkenisori kina igeba pabiyama agunta yagara ka waina agu a'wae pekiniba i'mu pikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Pigoya, to meto kamana maya untiye: Ka yagarama ntagarawapa tara mintantase. ");
INSERT INTO for_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mintana aintisa yagarama abawampa mayama omintiye: Kaeba mone kuntaka pako puma naepa nameganto, yogana, pako puwaisitantiye. ");
INSERT INTO for_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Piya pogana, aintisa yagarawampaba ise yaganto mima kotanka a'ya'waemaena aisa'urite e'ero mpari maete wantiye. Pigoya pita'i kupiyona puta nasima mone kutankapa nanintari kasima pusiya puwaegaintiye. ");
INSERT INTO for_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pusiya puwaegaite mintogana, pi mpariba tabe kabu pogana aeba ka'enawapa kampa waintiye. ");
INSERT INTO for_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Aibogana, ma ago yagara ka'wainati wama uma atokaeyogana, aeba yogana kuma'wati yaga kiye kabintiye. ");
INSERT INTO for_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Piya puntana, aeba yagama ntaninta nakena poginiba a'a-o otantawe. ");
INSERT INTO for_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Piyama mintana maya aogima napintiye: Nabanempa kayokaya kina'mitiba uwoma ntaninta waiyegini nama iga'e pama miyega, naeba yagarawampanaba mata'i ampima naga'enaga purikena puwe. ");
INSERT INTO for_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Pika naeba kuma'neti wama nabanempati irosa'ma maya uma omukuwe: Naba, naeba aguntaena pogana kaintananempaba kaetibe Kotitibe kunta piya. ");
INSERT INTO for_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Pipa ayama to kake kagorasa yagaragapa mikuwe. Kaeba uwa kayokaya yagaraga nababega mikuwe ukuwema, napintiye. ");
INSERT INTO for_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Piyama napima, ase'yo puma abawampati kanantiye. Kanamagina kuma awamori uma irosaogana abawampa ago agate antara puma karu'ena uma aepama amo nantiye. ");
INSERT INTO for_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aibogana kana yagaramaba mayama omintiye: Naba, naeba aguntaena pogana kaintananempaba Koti nkaobipe kae kaobipe kunta piye. Pika kae'yagaranawe to kampa ukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Piya yogana, abawampa: Pigoya aerawane, otate, kayokaya maya uwaimintiye: Tigeba karu'ena wama aogi kai maete kanama ampa amitaiyo. Ayapipa tusapa potantiri, agisa anapa amintiri piyo. ");
INSERT INTO for_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Piya, purumaka nkawaroba apa yaga aeguma kaeyigi nama ta'mu potano. ");
INSERT INTO for_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yagaranepa aeba pu'wantitisa to kake aogaya, pigoya aeba kaka wantitisa to kake aboraya, pika ta'mu peno, untiye. Piya yogini kaema i'mu puntawe. ");
INSERT INTO for_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Pigoya, amaru yagara aeba yogari mintogini piya puntawe: Piya yogarisa a'wae puma nama nkaka'i ampima inibe wa'enabe abintiye. ");
INSERT INTO for_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Piyama abimagina kayokaya yagara ka kega'e uma: Maipa nana pewema, abigantiye. ");
INSERT INTO for_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Aeba maya a'wae pomintiye: Ka'nantogampa kanama irosa'ma, ataenaba kampa pikana aogima mintiye. Pigo irosagina tisibarisimpaba yegi purumaka nkawaro apa yaga aeguma kaeyunema, omintiye. ");
INSERT INTO for_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Piyama omogana, amaru yagara aeba amo'ena puma namapinti ikenagaba a'a-o untiye. Piya pogana abawampaba kuma awamori tumima aurintiye. ");
INSERT INTO for_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Piya pogana kampa abinta, abawampapa maya omintiye: Abeno. Naeba ayaki kabubaya mima kamanakapa kampa aka'yuma kayokaya'enaba pugatauwe. Pugataoganapa, pi kaeba uwa meme awaroba kapa kampa nameka aeguma yaga namaegigeba nama ta'muntanaba kampa pompene. ");
INSERT INTO for_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","We, aintisa yagaragapa kupiyona puta nasima mone kutankapa pusiya puma asorisari pugaite kanagina, yekini purumaka nkawaro apa yaga aeguma kaetawe, untiye. ");
INSERT INTO for_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Piya yogana, abawampa mayama omintiye: Yagarane, kaeba asi nasi miyempeka piya mayaenagaba kampa aguyosagane, a'ya'maenaba kapiyenaresi waintiye. ");
INSERT INTO for_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Piya ka'nantoba aeba pu'wantitisa to kake aogaye. Piya, aeba kaka wantitisa to kake aboraye. Pika tantawama aso'ya peka ta'mu potakana aogi pikiye, untiyema, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Isu abagi kina'wa kamana to ka maya uwaimintiye: Tabe kutantaga yagara ka'waina kiya yagarawa ababuntiye. Pigoya, ka'isa kina'mi aeka maya yuguna aba kari abintiye: Kiya aeba kota maema a'yugu piyema, yuguna abintiye. ");
INSERT INTO for_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Piya kamana abitegina kega'e uma maya omintiye: Kae kamana maya yega abuwe. Kae piyamagaba kiyeba to kake kampa mikibenema yuwa, esagapa maete kanagara mone kutankama nkagowa aogi peso, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Piya yogana, kana kiya aeba antabinti mayama napima untiye: Ma tabe yagaranempaba yogane nagarubakenaga iye. Aya pukuwe. Yogaena pusagaba naekita piye. Nau'ama iga tumiga peka, wasanamiti nanintaga esuwaitasanagaba nani piye. ");
INSERT INTO for_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Piya, tabe yagarama yogarasa nagarubakibi kanabipa, a'yugu wasanami ka nabi'ma, namankaipi kampa nababuntanagaba ka nagi napiyoka, pintana pukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Piya utegina, tabe yagarawampa nkireta wainta kinaka kega'e umagina, ka'waina mayama abigama untiye: Kaeba tabe yagaranempa ireta kaetiba ayaki waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Piya yogana aeba maya untiye: Apa tabe tiniba 100-we yogana, mayama omintiye: Pigoya, ma ireta esa maema mara'mima 100 aegugasima 50 kaeyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Piya untana to ka'waina ampa irosaogana: Tabe yagaranempa ireta kaetiba ayaki waintiyema abigantiye. Abigaogana, 100 witi kune, untiye. Piya yogana maya omintiye: Pigoya, ma ireta esa maema 100 aegugasima 80 kaeyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pigoya, piya pogana, tabe yagara ata kiya yagaramaka abimagina: Aogi napiyena napima piyema, abima aogi potantiye, Isu untiye. Piya untana pi kamanaka to maya untiye: Mampabisa kina'miba mampabisaenaga tabera napi napi pewe. Piya pumagini e'wasaena maenta kina'mipa igasima napi napi pewe. ");
INSERT INTO for_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Piya yekiri abiyo. Moneba mampabisaenawe. Tigeba pika aogima napima pitasa tiyo'enaba puma maema miyigina, mampabi mikena kanati a'ya pikibi ntagaba, a'ya'waema kutatipa kampa maete Kotiti ikibewe. Pabi ntagaba miyaba mikena kumati asu aogima mikibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Pigoya, Isu to maya untiye: Ka'waina aeba au'wa kampa wainta'ena aogima kanara kabibiki'naba, aeba pabiyama au'wantaga'enaba aogima kanara kabikiye. Piya ka'waina aeba au'wa kampa wainta'ena maema ataena pikibi'naba, aeba pabiyama au'wa wainta'enaba maema a'yugu pikiye. ");
INSERT INTO for_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pigoya tigeba mampabisa kuta aogima kanara kampa maema miyiginaba, mantarisa taga au'wantaga'enaba Koti kapa ayama timikiye, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pigoya, a'yo timinta'ena pi aogima kanara kampa u'ma miyiginaba, tige'enaripa pi Koti ayama timikiye, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Pigoya, ka yagarama tabe yagara taramisi kayokaya'ena kampa kanara pikiye. Aeba ka'wainapa kayone potantana, to ka'wainapa agama aekita potakiye. Piya pumagina aeba ka'wainati uma atokaentana to ka'wainapa akabitakiye. We tigeba pabiyama Koti ntugabe mone kutankama ntugabe ka awameta kanara kampa maekibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pigoya Isu aeba pi kamana yogini, Parasi kina igeba mone kutaka ibugai kina abima kamana'wa akayuma kagi potantawe. ");
INSERT INTO for_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Aibuguna maya uwaimintiye: Pi tige wasanami nkiyobi aogi tiyuwa kanta piye. Kotiba tigu'ama nkagoba agama abiye. Wasana ige iyobi i'maete ima mikenaenagaba pi Koti nkaobi ata aguntaena piya. ");
INSERT INTO for_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Piya, paipa Mosese ominti ago kamanape poropete kina'mi kamanape kaeta kanantagana Yoniba aborantiye. Aboramagina Koti kabiratakena aogi awaga kamana untika, ibaba aboraye. Piya ebi ebi pe'nagiba agasiya puma uma pasawe. ");
INSERT INTO for_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","We, mage mantage isigeba a'ya pikenaba untanaba a'ya pikiye. Piya, Koti kamana kapa kampa kakakibikana a'ya'ma uwa waiyaba mikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Pigoya, ka'waina waya'wa kaite to wae maekibi'naba, kupiyonaba pikiye. Piya, to ka'waina aeba pi kainta wae maekibi'naba, aeba pabiyama kupiyonaba pikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Pigoya Isu to ka kamana maya untiye: Tabe kutantaga yagara ka mintantiye. Aeba kaiwapa waepe teteba aogiyenamana pu'ma mintana, asi nasi aogi nanintamana namagina igaenabi mintantiye. ");
INSERT INTO for_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pigoya, kusi yagara ka mintantiye. Agewapa Arasarusiwe. Aeba autiba anamosura yagarawe. Pigoya, aeba tabe yagarama ntama kabera waibomekana, ");
INSERT INTO for_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","tabe yagarama ntamapintisa ariyena atuntana tumogana: Pabipa maema nakuwema, napintiye. Waitamintogana karamiba irosa'ma anamopa inteburasa ki'ma nantawe. ");
INSERT INTO for_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pigoya, mima pi kusi yagaraba purogini enisore kina igeba ababute ima abara'amu nkagora atauguna mintantiye. Pigoya ainti pi tabe yagara aeba purogini kaitauguna, ");
INSERT INTO for_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","aeba a'abibinti tumima tabera auki naki puma mintantiye. Piya puntana, inati aomaraomepa Abara'amu nkagora Arasarusi pa agantiye. ");
INSERT INTO for_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Agantana Abara'amu nkagisuma maya untiye: Abara'amu nabanempagawo, naeba mata'i yakupi nauki naki puma mintuwa, kaeba naeka kantara puma Arasarusi otagana aya nkawarasa wanipi aerite kanama nantebura atakana paru peno, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Piya yogana Abara'amu maya untiye: Yagarane, abeno. Kaeba mara igaenabinti mintanti pipa pabiyama a'ya puwantiye. Pigoya Arasarusi antara'enabinti mintanti, pipa pabiyama a'ya puwantiye. Pigoya pika aeba anta asoyaenabi mpintiya, piya kaeba kauki nakiyenabi mpiyene. ");
INSERT INTO for_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Pigoya abakatepi tabe a'abi waintiye. Pika matisamiba tigetiba ayama tumikibewe, a. Piya tigetisamiba matiba ayama ikibewe, a. Pipa kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Aiyogana, kana tabe yagarama maya untiye: Nabanempa kanarana, kamanakapa ago abuwe. Piya, ka yekana abo. Maroti nae kumati na'natabarantonto nayaka'mu mintawe. Igeba mata'i auki naki kumati tumisanaga Arasarusi otagana wama tonkiya kamana uwaimeno, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Piya yogana Abara'amuba maya untiye: Kampaye. Mosesebe poropete kina ige mono kamana wainti, pi igeba abiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Piya yogana aeba to maya untiye: Abara'amu nabanempa, pipa kampaye. Purinta kina ka'waina wama uwaimekini kanara igu a'wae pikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Piya yogana maya omintiye: Igeba Mosesebe poropete kina'mibe kamanapa a'a-o yekini, piya purinta kina ka'waina asima wama uwaimemisinta, pabiyama a'a-o iyesine, Abara'amu untiyema, Isu piya kamana untiye. ");
INSERT INTO for_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Pigoya, Isuba abagi kina'wa kamana maya uwaimintiye: Aguntaena pukena amiyo'ena asi nasi aborakiye. Aibekana aguntaena aborakibi ntagarama ataenabi mikiye. ");
INSERT INTO for_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Pipa aeba maya yagaranto ayakekana kamparagaena pukibemipa, kana ayakikibi ntagara araku'ma tabe yabantama ana'mubi uba'atama tabe wanipi apasanakasasinta: Pipa kanara pewe, yesine. ");
INSERT INTO for_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tigeba kiya kabima miyiyo. Kao'yagara ataena pekanapa ka abirao. Piya pegana aeba agu a'wae peno. Piya yegana antara kamana ugasakana asu'a pugaso. ");
INSERT INTO for_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Piya, ka yagaba tonaentisa tara umaema aguntaena pugatantana, to kake kaeti irosa'ma tonaentisa tara umaema yaga: Naeba nantara puma nagu a'wae puwe, ikibipa, kaeba aguntaenawapa uwa asu'a pugaso, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Pigoya, aposoro kina'mi igeba Wa'ega Yagara maya esotantawe: Kaeba tamatiti'enarepa maema tabe puratao, untawe. ");
INSERT INTO for_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Piya yuguna Wa'ega Yagarama maya uwaimintiye: Taga timatiti'ena uwaenanto waintesinta, maro ntawamaka: Kaeba igiritegina tabe wanipi tumpa waiyeno, yeganaba, tiwamu wasima pabiya pemisine, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Pigoya, Isu to maya untiye: Tabe yagara ka'waina aeba kayokaya yagarawa yogaenaba puntana yaga kiye kabintana puma mintakibitisa atamaita kanakanaba, mayaba kanara omikiyo: Kaeba namapinti iyega naninta kao'ena pugameno, omikiya, a. ");
INSERT INTO for_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pipa kampaye. Aeba maya omikiye: Piya, aogi kai maema amirintana asekasa naninta kaenataga nagasakana, ainti uma kae'enagapa kaema nao, ukiye. ");
INSERT INTO for_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pigoya kayokaya yagara aeba yoga otanta pipa pekana, tabe yagarawampaba uwa abekana aya pikiye. Pika kampa a'mupa potakiye. Kampaye. ");
INSERT INTO for_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Piya, tige agoba pabiyama waintiye. Tigeba uritanta'ena pi puwaegaitekiripa maya yiyo: Taeba uwa kayokaya yagararawe. Pintana pompepa tae yugare pune, to naumabisa napima to ka'isaenaba ae yugaba kampa pune, yiyo, Isu uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pigoya, Isu aeba Yerusaremi kumati wakena Karariya maba agaite Sameriya ma awamori uma irosantiye. ");
INSERT INTO for_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Irosa'ma ka kumati iyogini karu kina nayatara'mu igeba pagasari mima agategini, ");
INSERT INTO for_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","kega'e uma agisuma maya untawe: We, kiya yagara Isu, kaeba taeka kantara po, untawe. ");
INSERT INTO for_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Piya yuguna igama: Tigeba wama tipa mono kiye kina iyakiyo, uwaimintiye. Piya yogini, wauguna i'amaba aogi puwantiye. ");
INSERT INTO for_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Piya puwaogana agate igetisa ka'waina a'wae puma tabera uma Koti a'mu potama, ");
INSERT INTO for_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Isu nkagisabi parokaema a'mu potantiye. Piya, pi ntagaraba Sameriya marisa yagarawe. ");
INSERT INTO for_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pigoya Isuba maya untiye: Wasanaba nayatara'mu aogi pene. Ka'isa tonaentisa ka megasima kinapa aempaye. ");
INSERT INTO for_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Igeba a'wae puma Kotika: Ta'mu pugatauneba, kampa otanta uwa wagana, to marisa yagarama abinto kanamagina ampa a'mu potaya, a, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Piya umagina a'wae puma pi ntagarapa: Kamatiti'enagampa aogi pugataya, kaeba asima waoma, omintiye. ");
INSERT INTO for_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Pigoya Parasi kina'mi: Koti kabiratakena yaga ayantaga aborakiyema, Isu abigantawe. Abigauguna Isu maya uwaimintiye: Koti kabiratakena yaga aborapa kampagina aborakiye. ");
INSERT INTO for_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pintaga mayama kampa ukibewe: Agaiyo. Mata'i aboraye. We, marota'i aboraye, piyaba kampa ukibewe. Abiyo, Koti kabiratakenaenaba tigupi ago aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Piya umagina, abagi kina to maya uwaimintiye: Tigeba toganaba ka yagaba Wasanama Ntagara nagakenagaba tibugagate kampa nagakibewe. ");
INSERT INTO for_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pi kanabipa naekaba maya urimikibewe: Mata'i taeti aboraye. We, marota'i igeti aboraye, igiripa a-nkwaiyo. Piya abigiripa a-nkuma iyegaraiyo. ");
INSERT INTO for_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wasanama Ntagaraba naeba kakamaba kampa irosakuwe. Apayaenaba aeba manta ka auka'i apaya pegina to auka'i e'wasa purite wagana pemi, pabi nkawameta naeba aborakuwe. ");
INSERT INTO for_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Marupa mamparasa kina'miba ikabinataigini nauki nakiyena tabera punataigina, asaba pi yontana aborakiye. ");
INSERT INTO for_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Piya, Nowa mintanti kanabi wasana igeba puntasa puma Wasanama Ntagara nae irosakena kana'nepa aborakiniba, pabiya pikibewe. ");
INSERT INTO for_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Igeba nanintaba nantini, wanipa nantini, wayapa ika pumagini, iba'enaba puntini, puma kampa aogima napima mintuguna, Nowa aeba wanipisa karebi ima paiwaogana wanipa tabera pa'ma ipirinta waegasogini, wabe wayape a'ya'ma pu'waewantawe. ");
INSERT INTO for_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Pigoya to Aroti mintanti kanabipa pabiya puntawe. Nanintaba nantini, wanipa nantini, ikantanaba puntini, to kinapa ka'isaenaba imuguni, ika puntini, yoga aintanaba puntini, namapa kintini, puma kampa aogima napima mintuguna, ");
INSERT INTO for_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ka yaga Aroti aeba Sotomu kumapa akabitate waogana yakupe yakupisa kagupe mantarisa tumima a'ya'ma kinapa wabe wayape iyeguma a'ya kaintiye. ");
INSERT INTO for_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Piya pi ntaga igeba pika kampa napintasa puma, Wasanama Ntagara nae aborakena kana'nekaba kampa napikibewe. ");
INSERT INTO for_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pigoya, pi ntagaba ka'waina aeba namankampa nkabobori mintakibitisaba tumima nama nkantabaipintisaba kotankapa a-mpaeyano. Pigoya, to ka'wainaba pabiyama yogari mintakibitisaba a'wae puma namankatiba a-nkwano. ");
INSERT INTO for_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Piya, tigeba Aroti nkanarimpa yabantana puwantemika napima kabiyiyo. ");
INSERT INTO for_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ka'waina aeba mikenaenawa ka abugakibemi'naba pipa agu'amankapa kaikiye. Mikenaenawampa a'a-o otakanaba, agu'amaba aogima waikiye. ");
INSERT INTO for_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Naeba yekiri abiyo: Pi nkagogo yaga maruta tara yagara waitamintisiginaba Kotiba ka'wainapa ababurintana to ka'wainapa atakiye. ");
INSERT INTO for_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Piya, tara wae taramisi naninta kao'ena puma mintisiginaba ka'wainapa Kotiba ababurintana to ka'wainapa uwa atakiye. ");
INSERT INTO for_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Piya, yogari tara yagara taramisi mintisiginaba Kotiba ka'wainapa ababurintana to ka'wainapa uwa atakiye, Isu piya untiye.) ");
INSERT INTO for_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Piya yegini abagi kina'miba: Tabe yagara, pintanaba aeta aborakiyema, abigantawe. Piyama abigauguna Isu meto kamana maya uwaimintiye: Purinta kina'mi nkau waintiti kegeba aki pesa pumawe, untiye. ");
INSERT INTO for_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Pigoya, abagi kinapa iyekita kampa punta asi nasima igeba esotakibeka, Isu meto kamana ka maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Piya, ka kumata ka kamana abikena yagara mintantiye. Pi ntagara aeba Kotikaba kampa aekuruba puntana, a'ya'ma kinakaba kampa aogima napintiye. ");
INSERT INTO for_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Piya, pabi kumata kiya wae ka mintantiye. Aeba asi nasima pi kamana abikena yagaramati kanama: Kama kina'nempi ata punatasanaga, nao'maeyoma, ampa omi puntiye. ");
INSERT INTO for_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pigoya, marupa pi kamana abikena yagaramaba aekita potama kampa ao'maentana, aintiba aeba mayama antabintiba napima untiye: Naeba Kotikaba kampa naekuruba puma, wasanamikaba pabiyama kampa napiyuwe. ");
INSERT INTO for_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pigoya, ma nkawae pu'wanta waepa aeba asi nasi kanama ampa nabigayaba miyekanaba nau'amaba aekita pusanaga iba kamana'wa abima ao'maekuwe, untiyema, untiye. ");
INSERT INTO for_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Piya umagina, Tabe yagara amato puma maya untiye: Ata kamana abikena yagarama unti kamanapa ago abewo. Pipa ayabayawe. ");
INSERT INTO for_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Kotika kagipe asekape asi nasima aegarakibe kina'mi agisaiginaba Kotiba kanara kampa tiyo'maekiya, a. Aeba agawa puma miyaba'miyigina karu'enaba kampa iyo'maekiya, a. ");
INSERT INTO for_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","We, urimuwe: Pipa kampaye. Aeba agaro ntaganto tiyo'maekiye. Piya, aintiba Wasanama Ntagara naeba to kake aborama mabi tumukubopa, igeba imatiti'ena pe kinapa taranto aogima mikibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pigoya, ka'isa kina'miba ige'waikaba: Aogi kinatawema napintini, to kina'mikaba: Pipa ata kina taka'yanema napinta, pi igi napiye kinakaba Isuba mono kamana maya umintiye: ");
INSERT INTO for_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tara yagararamisi nunamu ikena tabe mono namapinti intase. Pigoya, kapa Parasiwa, to kapa takisi maekena yagarawa sumawe. ");
INSERT INTO for_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parasi yagara aeba asima mima ae'waka mayama napima nunamu untiye: Koti, wasana ka'isa kina'miba kuntana ma'enaba pewe. Kamana kampa aogima abewe. Waya'wa taramisiba atataraenaba puma ata aguntaena pewe. Naeba piya kinapa kampaye. Piya takisi maeyi ntagara mare, ae piyamaba kampa mintuwe. Pika naeba na'mu pugatauwe. ");
INSERT INTO for_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Piya, a'ya'ma sontarapa tara yagaba naeba monoka napima nanintaba a'a-o uma miyuwe. Piya, a'ya'waemaena maeyopa, naeba pipa pako puma nayatara'mupisa agento kamuwe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Aiyogana, takisi maenta yagara aeba pagasara asima mintana mantari aomarakenagaba ani puma kampa piya puntiye. Aeba aibira aima maya untiye: Koti, naeba agunta kina miyoka, kaeba kantara punatama nao'maeyo, untiyema, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Pigoya naeba urimekiri abiyo: Pi takisi maenta yagaragaba Kotiba aguntaena maegasogana wa'ewati uwa wantiye. Piya pi to ka yagaraba kampaye. Abiyo. Ka'wainaba ae'wa nkau maete iyekanaba, Kotiba merunkaba potakiye. Piya, to ka'waina ae'wa nkage au maete tumekanaba, Kotiba ababuma mesuba potakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Pigoya igeba inamu ntakarantontowai Isuti ibabute kanantawe. Igeba: Ayapa ita aukaya pikiyema, napima kanauguni abagi kinamiba igate ka ibirantawe. ");
INSERT INTO for_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Piya yuguna, Isuba igega'e uma igeka maya untiye: Tigeba uwa itaigini yakarantonto igeba naeti kanaiyo. Tigeba a-nkakunkitaiyo. Piya miye kina'mikaba Koti kabiratakenaenaba utawaitantine. ");
INSERT INTO for_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Naeba taga urimuwa abiyo. Ka'waina aeba yakarantonto miyesa nkawameta kampa Koti aegarakibi'naba Koti kabiratakenaenama nkagupi kampa uma pasikiye, Isu untiye. ");
INSERT INTO for_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Pigoya kiya ka'waina Isu mayama abigantiye: Aogi tisa, naeba aya pukubotisa Koti nke'wasaenaba maekuwema, abigantiye. ");
INSERT INTO for_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Abigaogana Isu piya omintiye: Nana piyema naeba aogi tisaweba yene. Aogiyenama nkagoba Koti ka'antowe. ");
INSERT INTO for_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Pigoya kaeba nayatara'mu kamana agoba mayama abene: Kumiyenaba a-poma, wasanaba a-nkaeguma kaiyoma, kuntanaba a-poma, kumpari kamanapa to wainapa a-sotaoma, kano kaba kamana wasiyo. Pipa abintanema, omintiye. ");
INSERT INTO for_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Piyama omogana kiya yagarama maya untiye: Pipa uwaena yagarantomana pi kamana agoba abima wasita kanantone, untiye. ");
INSERT INTO for_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Aiyogana Isuba pi kamana abintana, maya omintiye: Ka'enaba kampa puntana, pintanaba po. Kaeba wama kotakapa to kina imima mone maemagina kusi kina imegana, mantari aogiyena ainta abora kamikiye. Kaeba piya potate kanama ampa naegarao, piya omintiye. ");
INSERT INTO for_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pigoya, piya omogana kana kiye yagaraba tabe kutankapa uwoma waintomeka, pi kamana abogana kunta abuntiye. ");
INSERT INTO for_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Piya pogana Isu agantana pika maya untiye: Tabe kutantaga kina'miba Koti kabiratakena kumati ikenagaba igigaba tabera pewe. ");
INSERT INTO for_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Pigoya tabe kamoro yagamaba na'ama agepinti uma pasikenaba pipa esegiyenawe, piya tabe kutantaga kana'mi Koti kabiratena kumati ikenaenaba pipa to awameta, tabe kuntaenawe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Piya yogini abume kina'miba maya untawe: We, pipa kepaya Kotiba au'ima aba pikiye untawe. ");
INSERT INTO for_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Piya yuguna Isu maya uwaimintiye: Wasana piya pikenaba kampaye. Koti ka'waina piya pikenaenaba waintiye, piye untiye. ");
INSERT INTO for_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piya yogana Pita maya omintiye: Abo. Taeba wa'erepe a'ya'waemaenarepe kasima takabitate kaegaraune, untiye. ");
INSERT INTO for_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Piya yogana, Isu a'ya'ma kinapa maya uwaimintiye: Naeba taga urimekiri abiyo. A'ya'ma kina Koti kabiratakenaenaga aega'magini, pika wa'ewaipe, waya yagarawaipe, igagabagipe, ino ibagipe, uma itakibe'nagiba ");
INSERT INTO for_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","igeba pi'nakaba mamparasaenaba agasimagina antotapa mesuba puma Kotiba imikiye. Piya, aintiba mantarisa aogi e'wasaena asu maekiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Pigoya, Isu aeba nagisarisa tara tumpaema kina'wa igega'e uma ibabute wama maya uwaimintiye: Abiyo. Taeba iba Yerusaremi kumati ikune. Iyekana a'ya'waema kamana pai poropete kina'mi Wasanama Ntagara naeka uma mono isapi kaemaranta, pi kamana'ama nkau'wapa aborakiye. ");
INSERT INTO for_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nabanempaba namu'isa kina'miti unatakini, naeguma ata punatama, karana natama, kaisa punatakibewe. ");
INSERT INTO for_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Piya pumagini kasotasa naeguma naiburikibewe. Piya piginaba papa kakaga yaga a'ya peka, purintapisa to kake naogama asikuwe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aiyogini abagi kina igeba pi kamana kampa abintawe. Kana kamana'ama nkagobe kakawaogini igeba aogimaba pi yome kamanapa kampa napintawe. ");
INSERT INTO for_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pigoya Isu aeba Yeriko kuma agora waogana, ke awamori aorika yagara ka mima a'ya'ma kina wagana pugunaba mone kutaka esuwaitama mintantiye. ");
INSERT INTO for_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Piya, aeba abomepa uwoma kina kanagana puguna, aeba ka'isa kina ibigama: Maepa nana pewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Piya yogini igeba maya omintawe: Isu aeba Nasaretirisa yagara tagora kanama nasiyema, omintawe. ");
INSERT INTO for_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Piya omuguna aeba tabera kega'e uma maya untiye: Isu, kaeba Tebiti nkaga'nu, kaeba naeka kantara punatao, untiye. ");
INSERT INTO for_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Piya yogini paitanta kina'miba: Paka po, uma kabiraugunaba, aeba ige kamana kampa abinta ebi ebima kega'e uma: Kaeba Tebiti nkaga'nu, naeka kantara punatao, untiye. ");
INSERT INTO for_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Piya yogana Isuba abite, keta asima mintana: Tigeba naeti ababute kanaiyo, untiye. Yogini aorika yagara aeti ampa aboragana, Isu mayama abigantiye: ");
INSERT INTO for_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Naeba nana pugatasanaga kabiyema, abigantiye. Abigaogana, pigo aorika yagarama: Wa'ega, naeba nao agasanaga nabiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Piya yogana Isu maya omintiye: Kaoba agano. Kamatiti'enagampa aogi pugataye, omintiye. ");
INSERT INTO for_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Piya omogana aowamaba aogi pogana agate Isu aegarantana Koti a'mu potaogini, a'ya'ma kina'miba pintana agategini pabiyama Kotiti i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Pigoya, Isu aeba wama Yeriko kumati wama agaikena puntiye. ");
INSERT INTO for_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Pigoya, pi kumata ka yagara mintantiye. Agewapa Sakiyasi, aeba takisi maeyume kina'mi paitakena yagara, piya tabe mone kutantaga yagara mintantiye. ");
INSERT INTO for_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Pigoya, pi ntagara aeba Isu agakenagaba abugantiye. Piya aeba arogu yagaragana wasanami ainigasuguna Isupa kampa agantiye. ");
INSERT INTO for_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Aibuntana, karu'ena wasana igaite wamagina yabinti asu mima: Isuba ma ki'i atawaka agakuwema, napintiye. ");
INSERT INTO for_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Piya pogana, Isu aeba pita'i wantana, aomaraogana iyogana agate maya omintiye: Sakiyasi, kaeba karu'ena tumo. Naeba ibantoba namakapi ampikuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Piya yogana, karu'ena tumima a'mu purite Isu aba poginisi namankapinti wantase. ");
INSERT INTO for_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Piya pusuguni a'ya'ma kina'miba agate ka abi'ma mare-u me-u puma maya untawe: Aeba nanagabaya agunta yagarama ntamapintiba uma pasiye, untawe. ");
INSERT INTO for_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Piyoga, Sakiyasiba asima mintana tabe yagara maya omintiye: We Wa'ega abo, ka'isa mone kotantepa pako puma kusi kina imukuwe. Piya, ka'isa kina'mi mpone iparinto pi aisarapa to tarawa tarawaki kanabi mesuba puma imukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Piya yogana Isu maya omintiye: Ma ntagaraba Abara'amu nkaga'nuwe. Pika iba ae namapi Koti aogi potakenaena ago aboragina aogi piye. ");
INSERT INTO for_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pigoya, Wasanama Ntagara naeba atama kaka wanto kina iguyosaga'ma ibabuma aogi puwaitakena tumintone, untiye. ");
INSERT INTO for_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Pigoya, Isu aeba Yerusaremi kuma agora ampa irosaogini, kamana'wa abinta kina'mi igeba: Ibanto Koti kabiratakenagana aborakiyema, napintawe. Piyama napiyuguna, pika Isu meto kamana ka maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ka kiye yagarama to ka tabe yagaramati wama: Ma kiye asinataka a'wae puma kanakuwe, ute pagaso mari wantiye. ");
INSERT INTO for_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Wakena puntana, kayokaya kina'wa nayatara'mu igega'e uma mone asa ka ka puma imima maya uwaimintiye: Tigeba ma moneba maema yoga pugaka pigi, naeba aintiba a'wae puma kanano, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Piya uwaimite waogini, wa'ewatisa kina'miba aekaba iyekita potamagini wasana apa igarubauguni ainti wama tabe yagara mayama omintawe: Kaeba ma kiyerepa kampa miyenema napiyunema, omintawe. ");
INSERT INTO for_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Piya yuguniba, e'ero mparisa yagara kampa abitegina, kana yagaraba kiyaena asitantiye. Aibuguna, kana kiye yagara a'wae puma kanama otategina, kayokaya kina'wa mone iminti, igeka ampa igega'e uma maya untiye: Mone timintopa ago yoga pegana tabe pibera kampayema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Piyama ibigaogana, kayokaya yagara ka'waina aeti kanama maya untiye: We naba-o, mone asaba ka namintampetasa yoga pogana to nayatara'mu asa aborama waintiye. ");
INSERT INTO for_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Piya yogana aeba maya omintiye: Kanarane. Kaeba aogi kayokaya yagaragawe. Kaeba uwaenarapa aogima kabiyempeka ibanto naeba nayatara'mu kuma kiye ugatakana kabikibene, omintiye. ");
INSERT INTO for_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Pigoya, piya yogana kayokaya yagara to ka'waina kanama maya omintiye: We naba-o, kaeba ka asa namintampetasaba yoga pogana to nayaka'mu mone aborama waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Piya yogana aeba maya omintiye: Kanarana, nayaka'mu kumatasa kina'mi kiye mikibene, omintiye. ");
INSERT INTO for_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pigoya kayokaya yagara to ka'waina kanama maya untiye: Naba-o, mone asagapa maye, maeyo. Naeba kairasa asaema pasema ataogana waintiye. ");
INSERT INTO for_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Piyama, naeba kagaopa kaeba kamo yagaraga kana ka'isa kina'mi atantanaba kaeba uwa maeyane. To kina'mi ntugabisaba pipa uwa kubene. Piya pempeka naeba kaeka naekuru pumagi uwa atantogana waintiye, piya omintiye. ");
INSERT INTO for_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Piya omogana kiya yagarama maya untiye: Kaeba ata kayokaya yagarawe. Pi kaeka kamanakata koti pugatakuwe. Piya, kaeba taga ago abene, naeba namo yagaranaga, naenepa yoga pumaba kampa maeyoka, ka'isa kina'mi puma abora maraga maekena kaga yuwe. Piya naenepa yoga kampa punta uwa miyogini ka'isa pegana ano nkaboragi nakena kaga yuwe. ");
INSERT INTO for_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kaeba aya pemika monenepa pisinisi kinapa kampa imekini yoga puma a'mu mponenepa maenataga ampa maeyuwo, untiye. ");
INSERT INTO for_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Piya umagina, agorasa kinapa maya uwaimintiye: Tigeba mone asaba apama nayatara'mu urinti ntagara amiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Piya yogini igeba: We naba-o, aeba nayatara'mu asa ago urintiye, untawe. ");
INSERT INTO for_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pigoya naeba a'ya'ma kinaka urimekiri abiyo: Wasanama urintantana aogima maema mintigipa, to kake maekibewe. Piya, ka'isa kampa aogima maema mintigipa, ipa'ma kaikiye. ");
INSERT INTO for_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pigoya kama kina'nempiba kiyarepa ampiyoma unata kinapa ibabute kanama naora iyeguyigini pu'wae waiyo, untiye, Isu meto kamana piya untiye. ");
INSERT INTO for_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Pigoya, Isu aeba pi kamanapa uma a'ya potate, Yerusaremi kumati irosakena wantiye. ");
INSERT INTO for_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wama Oribesi amupa amentapinti wama Petipaesi kumake Petani kumake agora wantana, tara abagi yagararamisi uwaisitaoginisi paitama wantase. ");
INSERT INTO for_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Aeba mayama uwaisimoginisi wantase: Wamagirisi maro kumati wama, tonki aikeri wasanami kampa mima nasi nasi aogaso aikeri uma abatama, iyoba'urite kanaiso. ");
INSERT INTO for_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Iyobaisigina wasana ka'waina kamana uma: Nana pikena iyobase yekirisiba, maya omiso: Wa'ega yogawa waintegina yegira ampa ababuse yiso, uwaisimintiye. ");
INSERT INTO for_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Piya yoginisi kayokaya yagara tara isigeba wama yomesa puntase. ");
INSERT INTO for_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Pigoya, pi tonki yaga aikeri uma iyobausuguni, kana yagama nkababa: Nana pikena iyobase, untawe. ");
INSERT INTO for_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Piya yugunisi isigeba: Wa'ega yagarama yogawa waintegina yegira ababuse, untase. ");
INSERT INTO for_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Piya uteginisi ababurite Isuti wama, akabatiba kaiwaipa atama ama agutama Isu ababuma mayotauguna mima wantiye. ");
INSERT INTO for_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Piya pogini, a'ya'ma kina'miba kaiwaipa akubuma ke'i ama agurite wauguna pi'na nkabobori wantiye. ");
INSERT INTO for_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Aeba wamagina Oribesi amu ararabira kanama ke'i waogini, a'ya'ma aokina'miba i'mu puma, a'ya'waemaena aogiyena pogini agaumeka Koti tabera uma i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Piya tabera uma maya untawe: We, Wa'egare Koti nkawamuta taeti kanaika, aeka ta'mu potano. Mantari anta paruyena waiyekana, inatisa kumati asagayukenaena waiyeno, untawe. ");
INSERT INTO for_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Piya uma i'mu puguni, Parasi kina ka'isa igeba wasana abakapinti mintanta kina'miba maya omintawe: Tisa, kaeba kabagi kina uwaimegini kamanapa pakama miyiyo, untawe. ");
INSERT INTO for_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Piya yuguna ige kamana antota maya uwaimintiye: Naeba urimekiri abiyo. Igeba paka puma miyesinta, yabankamaba kamanapa piyama tabera yesine, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Pigoya, Isu aeba Yerusaremi kuma agora irosa'ma agate pi kinaka antara puma kube'ena puntana ");
INSERT INTO for_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","maya untiye: Tigeba ma kanabipa asoyama mikena ki'amapa aogima agasanawe. Tigeba pipa tiyorikatagiri a'ya'waemaenaba kampa aogima agawo. ");
INSERT INTO for_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pigoya tigeba abiyo. Aintiba kanaka a'ya pekini, kama kina'mi irosa'ma minaena puma ke akukasigiri igiga pikibewe. ");
INSERT INTO for_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Piya pigina, nama kumatipe a'ya'waemaenaripe, tigege yagararipe iyeguma karana titama aguya aema ataena puritaigiri Koti kanama tiyo'maentintanagaba kampa napiyigini ata puritakibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Pigoya, Isu aeba wama tabe mono namapinti iyomepa, kota ikantana puma mintuguna igaruba'magina, ");
INSERT INTO for_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","maya uwaimintiye: Mono isa'ama maya iye: Mono namantepa nunamu ukena namantana peno, iye. We, tigeba piya pegana kuntana pe kina'mi ntamantana piye, uma igarubantiye. ");
INSERT INTO for_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pigoya, pi ntagaba tabe mono namapi asi nasima mono kamana uwaimima mintantiye. Piya pogini, tabe mono kiye kina'mibe, mono tisa kina'mibe, to ka'isa kiye kina'mibe, igeba Isu aeguyigina purikibi kamana untawe. ");
INSERT INTO for_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Aiyuguna, kamana'wa yogini a'ya'ma uwa kina'miba abima aeka tabera ibuntika, aegukena kipa kapa kampa aborantawe. ");
INSERT INTO for_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Pigoya, ka yaga Isu tabe mono namapi ima wasana aogi mono kamana uwaimima mintogini, tabe mono kiye kinape mono tisa kinape kabiyume kinape aeti kanama, ");
INSERT INTO for_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mayama abigantiye: Kaeba uramo. Mata'i a'ya'waemaena pempepa, ke ugamegina esegiyenaba pene. Kebaya: Piya poma, ugatagina penema, abigantawe. ");
INSERT INTO for_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Piyama abigauguna maya uwaimintiye: Naegeba natantigi, ka kamana tibigakiri unamiyo: ");
INSERT INTO for_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yoni mono wanipa mantarisaenabera wasanamintanawema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Piyama ibigaogini, igeba: Ayawe ukune, untini: Mantarisaenawe yekanaba, aeba nana piyema kamana'wapa kampa abima napiyewe, ikiye. ");
INSERT INTO for_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Piya: Wasanamintanawe yekiniba, a'ya'ma kina'miba igeba Yonikaba ka taga poropete yagarawema napintaka, yaba kasutasa taegukibewema, napintawe. ");
INSERT INTO for_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aibumagini igeba maya kamana antotapa omintawe: Taeba kampa abintune. Yoni mono wanipa aetasabaya aborantiye, untawe. ");
INSERT INTO for_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Piya yuguna Isu maya uwaimintiye: Piya, naegeba antotapa kampa urimukuwe. Kenkawamutasa kamanapaya unamegi esegiyenaba puweba kampa urimukuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pigoya, Isu wa waya meto kamana ka maya uwaimintiye: Ka yagarama waini iga'na kurintiye. Ku'atate kana yuga wasanamiba: Kiye kabiyiyo, otate e'ero mpari wama e'ero kanabi umintantiye. ");
INSERT INTO for_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pigoya, kana waini agutaogana asikikena kana aboraogana, kayokaya yagara: Ka'isa asigi kamigina maete kanaoma, otantiye. Otaogana uma irosaogini, pi waini yuga kiye kina'miba aeguma agarubauguna, kana yogarisaena kampa maenta auka a'wae puma kanantiye. ");
INSERT INTO for_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Piya pogana, yoga ababa to ka kayokaya yagara otaugana waogini, pabiyama pi kina'mi aeguma ata potama agarubauguna, kana yogarisaena pabiyama kampa maenta uwa auka kanantiye. ");
INSERT INTO for_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pigoya, to kakagara ka kayokaya yagarawa otaogana waogini, tabera aeguma awamori maebugaintawe. ");
INSERT INTO for_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Piya puguna, kana waini yogawama nkababa abite maya untiye: Aya pusuwe, otantana: Piya ago napiyuwe, untiye. Ma nabugai ntagarane otakana wakiniba agama agoya potama awamu wasikibewema, napintiye. ");
INSERT INTO for_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Piyama napimagina otaogana waogini agate, kana yoga kiye kina'mi aegukena naga nikintini maya untawe: Ae ma ntuga maesanaga aegugasakana pu'waka, ma ntugaba tae'enaena puwakiye, untawe. ");
INSERT INTO for_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Piya ute apasana'urite kabubinti wama kana waini yuga awamori aeguma kaitantawe, untiye. Isu aeba piya untana pi kamanaka wasana mayama ibigantiye: Yoga agowamaba pi kiye kinapa aya puwaitakiye, a. ");
INSERT INTO for_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Abewo, aeba kanamaba piya kiye kinapa iyegugasima, yogawatapa aogi kiye kina ibabuma itakiye, piya untiye. Piya yogini, igeba: We, igeba kampa piya pikibewe, untawe. ");
INSERT INTO for_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Piya yuguna, Isuba igabebe puma maya untiye: Mono isapisa kamana kapa mayama waintiya, agowapa ayamawe, untiye: Nama kikena kina'miba ka ya ago kainta yawama iba wa'ega ya asima waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","To ka mayama amato puma untiye: Piya, wasana ka'waina pi wa'ega yara aeguma au airisa puma aikiye, iye. Piya, kana wa'ega yaba abobora takuma tumima aeguma ata puwaikiyema, untiye, Isu untiye. ");
INSERT INTO for_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Piya yogini, mono tisa kina'mibe tabe mono kiye kina'mibe, meto kawana'wapa igeka yomepa abibebe puguna intawamaba ata pogini, pabi ntaga arakurikena pumepa a'ya'ma kinaka iyogaru puma atantawe. ");
INSERT INTO for_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pigoya, Isu kamana abite imo'ena purite, pi mono kiye kina'miba Isuka kabintawe. Piya, pi kina'miba kampari otakena kina uwaitauguni wamagini, iyoga'wapa mono iga pumagini kabima mintuguna, awamupisa ka ata kamana aborakiniba abite arakurikena puma kamana abikena kina'mi nkiyapi ataigina kamana otaiyema, untawe. ");
INSERT INTO for_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pigoya, igeba ampa Isu mayama abigantawe: Tisa, kamanakampaba aogima parutu pegi abune. Kaeba a'ya'ma kinapa aogi kamana uwaimene. Piya, tabe igi wainta kina'mikaba kaekuruba kampa pempekana, taga Kotitisa aogi kamanapa uwaimene. ");
INSERT INTO for_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Piya, kaeba ayama napiye ne: Mono kina'mite taeba Aroma wa'ega yagara Sisa takisi mone amusupera kampaye, untawe. ");
INSERT INTO for_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Piya yuguna, Isuba pi meto kamana'waipa ago abite maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Mone ka nayakiyo. Amankape awa'enabe mapa kewema, ibigaogini igeba: Sisantawe, untawe. ");
INSERT INTO for_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Piya yuguna aeba maya uwaimintiye: Pigo yewa, Sisantanaba Sisa amiyo. Piya, Kotintanaba Koti amiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Piya yogini, wa waya'mi nkiyobipa kamana'watakaba kampa arakurinta uwa pami ntami puma asaba'wantawe. ");
INSERT INTO for_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Pigoya, ka'isa Sarusi kina'mi Isuti kanantawe. Pi kina igeba: Purintapisa asikenaenaba kampa waintiye, uma miyume kinakini, ");
INSERT INTO for_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","igeba Isuti irosa'ma kamana mayama abigantawe: Tisa, Moseseba kamana awa'ena taeka mayama ka kaentiye: Wasana ka'waina waya maema yagarawa kampa aboratanta pu'wakanaba, to a'nanto kiya maetama aganto antotapa yagara aborano, iye. ");
INSERT INTO for_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pigoya, ka meto kamana ugamukune. Piya, tonaentisa tara umaema aga'na mintantawe. Ige iganto waya maema yagara kampa aboranta, mima pu'wantiye. ");
INSERT INTO for_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Pu'waogana, ka a'nanto kiyawapa pabiyama maetate uwa pu'wantiye. ");
INSERT INTO for_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Pu'waogana, to a'nanto ka'waina pi kiyawapa pabiyama maetate pu'wantiye. Pigoya, pi nkaga'na a'ya'ma tonaentisa tara umaema kina'mi pabi ka wae maeta kanamagini, yagara kampa aboratanta pu'waewantawe. ");
INSERT INTO for_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Aitiba pi kiya wae'waipa pabiyama pu'wantiye. ");
INSERT INTO for_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pigoya, igeba a'ya'magini pabi ka wae'amana maentawe. Piya ainti asikena kanabipa ke nkwae'ena pikiyema, abigantawe. ");
INSERT INTO for_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Piya yuguna Isu maya uwaimintiye: Ma kanara mampabi wa wayapa maema miyewe. ");
INSERT INTO for_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Piya, ainti tabe kanabipa asikena kana aborakibipa, Koti kega'e yekini aborakibi kina'miba wa wayapa kampa maekibewe. Kampaye. ");
INSERT INTO for_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Igeba enisore kina miyesa puma mimagini, to kake kampa purikibewe. Piya, Kotiba irubintisa ibage pekini ae araga yagaraena puma mikibewe. ");
INSERT INTO for_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pigoya, paipa Mosese irubisa asima mikena kamana untiye. Aeba yabi yaku nkabusa aboranti, pi kamana kaentana Koti nkageba mayama kaentiye: Naeba Abara'amu, Aisaki, Yekobu ige Koti mintuwe, untiyema, kaentiye. ");
INSERT INTO for_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Piya, pu'wantatisa iyogama asikibewema, Mosese aeba pika napima Koti nkageba piyama kaentiye. Piya, Kotiba pu'wanta kina'nane. Aeba iyoganta kina'mi Koti mintegini, esegiyenarasa iyoganta kina uwa miyewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Piya uwaimogana, mono tisa kiye kina ka'isami pi kamana antota maya untawe: Tisa, kaeba aogi kamana yene, untini, ");
INSERT INTO for_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","igeba to kake abigakenaba iyekuru puma atantawe. ");
INSERT INTO for_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Pigoya, Isu maya uwaimintiye: Nana piyema Karaisitikaba aeba Tebiti nkaga'nuweba yewe. ");
INSERT INTO for_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Piya, mono isapi Samu isapipa Tebiti aewapa mayama kaentiye: Inatisa Tabe Yagaramaba Wa'ega yagaranepa: Kaeba nayatakanti miyo omintiye, iye. ");
INSERT INTO for_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Piya, aintiba kama kinakapa uwaitakini kae kagisa amentapinti wama mikibewe, omintiyema, piyama Tebiti kaemarantiye. ");
INSERT INTO for_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pigoya, Tebiti aewapa Wa'eganene otantiye. Aeba aya piyema aga'uwakaba: Wa'eganeneba, untiyemagina Isu ibigantiye. ");
INSERT INTO for_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pigoya, a'ya'ma wabe wayape mima Isu kamana abima mintuguna, abagi kina'wa maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Tigeba mono tisa kina miyesa nkawametapa a-mpima, uwa aogima miyiyo. Igeba e'ero kai amirite ke'i paebuta nasigini, wasana akiyenabinti wama wa waya igama i'mu puwaitasanaga igu'amaba tabera waiye. Piya puntini mono namapipe taenabikenabipe tabe kina'mi ntabae maema paitama mikenaga yewe. ");
INSERT INTO for_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Piya untini igeba kiya wae'mi namankaipe kotankaipe uwa paibuntini, kampari nunamuba e'erota yewe. Pigoya, pi kina'mipa aintiba Kotiba antota'enaba tabera ka ibi'ma kuntaenaba imikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Pigoya, Isu aeba tabe mono namapi ampima agaomepa mone kutantaga kina'miba Kotika i'mu mpone kankabebi atauguna, agantiye. ");
INSERT INTO for_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Piya, yaba kampa wainta abeya wae ka'waina irosa'ma tete monento tara kankabebi atantiye. ");
INSERT INTO for_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Piya pogana Isuba agate maya uwaimintiye: Naeba taga urimekiri abiyo, ma nkabeya kusi wae'maba ka'isa kina'mipa igasima moneba ataye. ");
INSERT INTO for_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ka'isa kina'miba uwoma mponewai waintegini Kotika i'mu moneba atagana, ma kusi abeya wae aeba monewapa naninta ika puma nakena kampa atanta, a'ya'ma kasiwaegaite uwaraka'ya mintiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Pigoya, ka'isa kina'miba tabe mono namankamaka maya untawe: Mono awa'enaba aogiyena potama tauka pugaye, untawe. Piya yuguna, pika Isu maya untiye: ");
INSERT INTO for_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Nama agama, ti'mu pentana aintiba kampa waikiye. Ka kana aborakiniba kama kina'mi irosa'ma nama kumatipa akasagasuba kasaigina ka yabankamaba to ka yabankama nkabobora ware'naigina nama tubo aborama waikiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Piya yogini, igeba mayama abigantawe: Tisa pintanaba ayantaga aborakiye. Nana kukantana aboraka agapa kana arosakena piyeba, ukune, untawe. ");
INSERT INTO for_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Piya yuguna Isu maya uwaimintiye, tigeba tigu'ama a'yugu purigaisanaga aogima kiya kabima miyiyo. Wasana uwoma aborama nae nage uma naeba Karaisiti nawe, yigini, to ka'isamiba kanapa ago arosawaye, ukibewe. Pigoya tigeba piya ukibe kina'mipa a-nkiyegaraiyo. ");
INSERT INTO for_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Piya, aintiba ma'ena puma esiba kamana abintiripa, a-pami puma tiyekuruba a-piyo. Pintanaba paitama aborawakana, aintisa kanaba agaropa kampa aborama ainti aborakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Piya untana Isu to maya uwaimintiye: Maga maga kina'miba kamaena pigini to ka'isa kina'miba to ka marisa kina uma iyeguyigini kamaena purite wagana pikibewe. ");
INSERT INTO for_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Pigoya, imimapa tabera pekana, ka'isa auka'i tabe kabu aborakana, yonintana tabera aboraurite wagana kana pikiye. Piya, mantariba ku kantanaba toma toma aborakiri agate tiyekuru puma tabaraba pikibewe. ");
INSERT INTO for_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pi a'ya'waemaenaba kampa aborantakini, igeba tiraku'ma karana titama ataena puritama, mono namapipe iga'na namapipe tibabuma kamana uritama ata puritakibewe. Pigoya nae nage uma ata punatamagini kiya kinake kamana abikena kinake ige iyobi tibaburite wama kamana uritakibewe. ");
INSERT INTO for_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Pigoya piya pigiri, pi ntaga aogi kamana'nepa uwaimikibewe. ");
INSERT INTO for_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pigoya ibaba aogima abiyo: Pi ntagaba tigeba ige iyobi uma asimaba: Ayama kamana antota ukunemaba, a-ntapiyiyo. ");
INSERT INTO for_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Naene tigu timabi tiwamupi kamana'nepa atakana aogi napi napiyenabe aborarimekiri ukibewe. Aibigini kama kinatimpiba kamanatipa kampa aeguma aka'yukibewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Pigoya, pabi ntaga tino tibakibe, tiganto ti'nanto, ka'kura tiyo'mibe kama puritama, iyekita puritama, ataena puritama, tige aruyenabisa ka'isaba tiyegukibewe. ");
INSERT INTO for_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pigoya, a'ya'ma kina'miba abima intabipa nae nageraka ata puma kama puritakibewe. ");
INSERT INTO for_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pigoya, ti'no nkabiyapa ka'antoba kampa kaka wakiye. ");
INSERT INTO for_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Piya, tigeba esegima mima tigu timapa to kake maekibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pigoya, aintiba tigeba agakibepa irebu kina kanama Yerusaremi kuma kobe pigiripa agamagiripa: Kuma ai'nere aguya aikena kana agarosaye, yiyo. ");
INSERT INTO for_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Pigoya Yutiya mari mikibe kina'miba tiyegaka wama amu mari iyiyo. Piya Yerusaremi kumati mikibe kina'miba pabiyama karu'ena pai'ma wakibewe. Piya uwaena kumati kampa wakibewe. ");
INSERT INTO for_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pigoya pi ataga Koti wasana a'yikiki pemi ntaga aborakiniba, mono kamanapa unta'enamaba esegi puma aborawaekiye. ");
INSERT INTO for_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","We, iga'entaga wae'mibe yagaranto nono a'mikibe wae'mibe kamparagama mikibewe. Mampara mikibe kina'miti kuntaena aborakanaba, Koti agobintanaba mampara a'ya'ma mikibe kina'mipa pabiyama aborawaimikiye. ");
INSERT INTO for_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Piya, kasotasa irisakibewe. Aibumagini, iga'na ubu'urite wama uwoma to kina'mi nkibakapi metaigini kayokaya'ena puwaitama mikibewe. Piya, namu'isa kina'miba Yerusaremi kumapa aguya aima mima ataena puyaba'miyigina, ainti namu'isa kina'mi ige'waipa a'ya puwaitakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Pigoya, pi ntagaba pape, ope, noribe awame'enawa tonarona aborakiye. Piya mabipa kayo waninkama aiga'yo'ya puma tapo uma agayemisa pekini, a'ya'ma mampabisa kina'miba karu puma iyekuru pikibewe. ");
INSERT INTO for_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pigoya, pi ntagaba mantaba kuru pekana esegiyenawapa iyoba'ma kareko pigini, mara a'ya'ma kina'miba uwoma nkigi napikibewe. Eya, ka'ena mabi aborakenaenaga napima karu puma iyekuru pigina iyonanta'ena pikiye. ");
INSERT INTO for_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pintana aborakapa, Wasanama Ntagara naeba ibinankama nkagupinti tabe esegiyenanentaga e'wasaenanentaga aborakini nagakibewe. ");
INSERT INTO for_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Piya, ainti pintana agobima aborakiri, asimagiri tiyowa aisesama agate: Koti tababikena kana agarosaye, yiyo. ");
INSERT INTO for_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Pigoya piya untana, Isu meto kamana ka amato puma maya uwaimintiye: Tigeba piki yage, to ka'isa yawamake agoga napiyiyo. ");
INSERT INTO for_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Piya, a'no mparagiri agantiripa: Kabo yagawe, yewe. ");
INSERT INTO for_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Piya yesa puma, pi yontana aborakiri agateba: Koti kabiratakena kana agarosaye, yiyo. ");
INSERT INTO for_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Naeba taga urimekiri abiyo: Mamparasa kinapa kampa purintigina pi yontanaba a'ya'ma aborakiye. ");
INSERT INTO for_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Pigoya mage mantageba a'ya wakana, kamana'nepa waiyaba waima kampa kakakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pigoya, Isu to maya untiye: Asi nasi esegi wani ntama aibo'ena puma mampabisaenaga napi napi puma Kotika tigegu'a pusanaga, tigeba aogima napima kabima miyiyo. A'yugu uwasuwa puma mintigina aborasanaga kabima miyiyo. ");
INSERT INTO for_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Piya, mampabisa kina a'ya'ma kinati pintanaba aborakiye. ");
INSERT INTO for_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Piya, asi nasi aogima kabima miyiyo. Asi nasi Koti esotaigina esegiyenaba timeno. Piya pigina, pi a'ya'ma ataenamaba uwa tigasakiri, Wasanama Ntagaramante naobi aogima asikibewe, Isu piye untiye. ");
INSERT INTO for_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pigoya Isu aeba a'ya'waema yagaba tabe mono namapi mima a'ya'ma kina Kotitisa aogi kamana uwaimima mintantiye. Pigoya, ase yoganaba Oribesi amuti ima waibutaye. ");
INSERT INTO for_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Piya pogini, abaya aseka a'ya'ma wabe wayape irosa'ma Isuti kanama tabe mono namapi ampima aetisa aogi kamana abi puntawe. ");
INSERT INTO for_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pigoya, yisiti kampa wainta pareti nakena yaga aborakina puntiye. Piya, nakenagana ataome ntagama nkagewapa Pasobawe. ");
INSERT INTO for_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Aborakena pogini tabe mono kiye kinake mono tisa kinake igeba a'ya'ma kinaka iyekuru pumagini: Isu ayama aegukune, untawe. ");
INSERT INTO for_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Piya umagini mintuguna, Sataniba Isu abagi yagara ka agewapa Yutasi Isikeriyoti, aeba nagisarisa tara tumpaema kina ige arayenabisa yagara, ae antabi pasintiye. ");
INSERT INTO for_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Piyama pasogana, tabe mono kiye kinake mono irebu kinake igeti aruyenabi wama Isu minaga pekini arakurikibe kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Piya uwaimogini igeba abimagini i'mu pumagini, Isu nkaegukena kutaru mone amikena kamana uma aogi puntawe. ");
INSERT INTO for_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Piya yuguna kamana'wai wasiyu'ma, wasanamiba kampa agama abuguna kakama minaga pikena apasa puma mintantiye. ");
INSERT INTO for_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pigoya, yisiti kampa wainta pareti nakena kana aborantiye. Pi ntaga sipisipi kaemagini Pasoba naninta nantawe. ");
INSERT INTO for_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pigoya, pi ntaga Isu Pitake Yonike maya uma uwaisitantiye: Tisigeba wamagirisi, Pasoba naninta maema ai'aru pisigi uma nano, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Piya yoginisi isigeba: Ae ntamapi nanintaba maema ai'aru pususe, yusuguna, maya uwaisimintiye: ");
INSERT INTO for_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Abiso. Tisigeba wa'eri ima wasana ka wani kankabe maete wakibi ntagara pabuma aega'urite wa'eri iyisigina, namapinti uma pasekirisiba pabi ntamapi tisigeba uma pasiso. ");
INSERT INTO for_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Piya, namapi ima pi namankama nkabapa mayama omiso: Tisa yagara kaeka maya iye: Ae mparunta nabagi kina'mige taeba Pasoba nanintaba nakune, iye, omiso. ");
INSERT INTO for_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Piya omisigina nama mparupa inati tabe maru ka ama agumagina aogi pumaranta tisiyakekirisi, pita'i maema asu ai'aru piso, uwaisimintiye. ");
INSERT INTO for_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Piya uwaisimoginisi, isigeba wama pi yomesa pumaginisi abatama Pasoba naninta maema ae'arubantase. ");
INSERT INTO for_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pigoya nakena kana aboraogini, Isuge abagi kina'wampige namapi ampima nantawe. ");
INSERT INTO for_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Piya nantini maya uwaimintiye: Naukikena kana'nepa agarosagi, Pasoba naninta ma tigege nakenagaba tabera nabiye. ");
INSERT INTO for_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Naeba yekiri abiyo. Naeba Pasoba nanintaba to kake kampa nanta Koti kabiratakenaena aborakini pi'na nkantota waikiye, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Piya umagina, aeba wani kankabe maema, Koti a'mu potama, maya uma imintiye: Tigeba maema marona mona puma naiyo. ");
INSERT INTO for_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Naeba yekiri abiyo: Waini wani to kake kampa nanta mintakana Koti kabiratakenaena aborakiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Pi kamana umagina pareti maema, a'mu potama, ako puma, maya uma imintiye: Mapa nauna, tigeka uma atauwe. (Naeka napima pipa nama miyiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Pi naninta nauguna waini kankabe maema pabiyama imima untiye: Ma kankabebipa Kotiti aogaso atokaekena kurante waintiye.) ");
INSERT INTO for_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Piya, abewo. Nae minaga pikibi'naba aeba naege ka yabaera mima naninta maema nama mintuse. ");
INSERT INTO for_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wasanama Ntagara naeba wasanami nkiwamuta purikenaenaba kampa waintiye. Naeba Koti ke'i namintemiti wakuwe. We, minaga punatakibi'naba aeba antotapa atama mikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kamana piya yogini, abagi kina'mi: Kebaya pikibe kina iyewa, marebiga mebiga puntawe. ");
INSERT INTO for_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pigoya, abagi kina igeba: Taetisa kebaya tabe yagararepa mintiye, umagini maka untawe. ");
INSERT INTO for_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Piya puguna Isu maya uwaimintiye: Mabisa wa'ega kina'miba ige esegi puma uwa wasanaba aogima kabiwaitagini, uwa kina'miba i'mu puma kayokaya'ena puwaitawe. ");
INSERT INTO for_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pigoya, tigetiba piyaenaba a-nkaborano. Tigetisa tabe kina'miba uwa kina miyesa, pi nkawameta miyeno. Piya, tabe yagara aeba kayokaya kina miyesa, pabi awameta miyeno. ");
INSERT INTO for_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pigoya tigeba napiyiyo. Ae'na asugainta'enawe. Wasanami nakibepa mara'mima naninta nakibi'na asugainta'enabera, kao'ena pikibi'na asugainta'enawe. Uwa mara'mimagina nakibi'na pipa asugainta'enawema, ago abintawe. Piya, naeba tige tibakapi kayokaya kina miyesa puma miyuwe. ");
INSERT INTO for_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pigoya, kuntaenama nkagupi miyogiri kampa natate wanta naega'ma nasima miyewe. ");
INSERT INTO for_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Pipa nabanempa naepa kabikenaenama nkagowampa unatagi, naeba pabiyama tigepa paitakena kina uritauwe. ");
INSERT INTO for_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Piya, tigeba aintiba kabiritakena kumata naege naninta wani ntantiri ti'mu pikibewe. Pigoya, pi ntaga kiya puma mikena yabaera mima Isureyo kina ige nagisarisa tara tumpaema kina'mi kamanata kabikibewe, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Piya uwaimintana toba Pitapa maya omintiye: Saimoni, Saimoni, witi ao asari pegina i'nintanawapa pa'wamisa puma, Sataniba tigepa maema timiyo'ena puritakenaga Kotipa abigaoga, ");
INSERT INTO for_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","pigo naeba kamatiti'enaga a'yugu pusanaga kaeka uma nunamu yuwe. Pika kaeba mono kita to kake a'wae puma aogi mimagina, kaokinapa iyo'maema esegi puwaitao, omintiye. ");
INSERT INTO for_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piya yogana Pita maya omintiye: Wa'ega, kaeba iga'na namapipera purikenaenaripera wagapa, kaega'ma wakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Piya yegana, Isu maya untiye: Pita, naeba ugamekana abo: Kokorewamaba iba asekapa kampa aga untakana, kaeba kakagara kampa agao ntagarawe unatagana aga ukiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Piya untana, abagi kina'wapa to ka maya uwaimintiye: Naeba monebe ira'na kutipe tigisanape kampa wainta urita wagiri, wama uma aguyosagantawoma, ibigantiye. Ibigaogini: Piyaba kampaye, untawe. ");
INSERT INTO for_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Piya yuguna, maya meto kamana amato puma untiye: Piya, ma kanabipa ibaba tigetisa ka'waina aeba mone waintakanaba, maemagina miyeno. Piya, to ka'waina aeba ira'na ku waintakanaba, arakae puma miyeno. Pigoya, ka'waina aeba ma'ena kasupa aguyosagantanaba, kaiwa ka kasakana, ika puma pi'naba ka kaso mae ameno. ");
INSERT INTO for_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Naeba yekiri abiyo: Naeka meto kamana ka mayama pai kaemarantine: Aeba antage kina'mi nkaruyenabi atakibewema, kaemarantiye. Pigoya pipa nae kamana untakana mampa aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Piya yegini abagi kina igeba maya omintawe: Wa'ega, agao, Mampa kasopa tara waintiyema, omuguna Isu: Pabigoye, otantiye. ");
INSERT INTO for_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Pigoya, Isu aeba asi nasi kumapa atategina Oribesi amuti ibomekini, pi nkaseba abagi kina aepa aega'ma intawe. ");
INSERT INTO for_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Umibometi uma irosa'ma abagi kina maya uwaimintiye: Tigeti timiyo'ena aborakiri ware'nasanaga nunamu uma esegi piyo, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Piya utegina, arompari umimagina uma arakabima maya uma nunamu untiye: ");
INSERT INTO for_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Naba, kaeba ukenaba kanara yegana ma nauki nakiyenaba naparo. Piya, nae napiyenakaba kampaye. Kaeka ntapiyena uma esegi penemawe, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","(Piya yegana mantabintisa enisore ka tumima tumpa esegi potantiye. ");
INSERT INTO for_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Piya, napiyenawapa to kunta puwaogana to kake esegima nunamu untiye. Piya pogana, tete aiseba pa'uritegina tipe puma mabi tumintiye.) ");
INSERT INTO for_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nunamu ugaite, asima abagi kina'miti wama igaomepa, igeba intara'ena puma iwaita mintantawe. ");
INSERT INTO for_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Iwaita mintuguna maya uwaimintiye: Tigeba nana piyema tiwaiba waitamintawe. We, tigeti timiyo'ena aborakiri ware'nasanaga asima tiyogama mima nunamu iyiyo, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Piya umagina mintogini kama kina igeba kanantawe. Pigoya, nagisarisa tara tumpaema kina ige aruyenabisa ka yagara, agewapa Yutasi, aeba paitama ibabute Isuti wama uma amo nantiye. ");
INSERT INTO for_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Amo naogana Isu maya omintiye: Yutasi, kaeba nana piyema Wasanama Ntagara naepa namo nama minaga pene, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pigoya, Isu nkaokina igeba pintana aborakena pogini agate, maya untawe: Wa'ega kaeba abega, kasotasa iyeguyeno, untawe. ");
INSERT INTO for_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Piya yuguna, igetisa ka'waina monota paitanta kiye yagarama kayokaya yagara kasotasa aegumagina ageba ayatakantisa arisakaentiye. ");
INSERT INTO for_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Piya pogana Isu agate: Uwa miyiyo, untiye. Aibumagina, pi ntagarama nkagiba maemagina mayo atama asu'a potantiye. ");
INSERT INTO for_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pigoya, mono namapisa tabe kiye kinape irebu kiye kinape kabiyume kinape, ae arakurikena kananta kina, igepa Isu maya uwaimintiye: Tigeba naeka abeganaba ku kina kanta pogiri, tigeba ma'ena pikena irebu kasutintaga kanama naegukena pewo. ");
INSERT INTO for_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","We, naeba asi nasi tabe mono namapi mima mono urimone. Piya, pi ntagaba nana piyema kampa narakurintane. We, ibaba tige kanapa aboragina, tununtanama nkesegiyenaba aboraye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pigoya, igeba Isu araku'ma ababute wama monota paitanta kiye yagarama ntamapi ababute intawe. Piya puguna, Pita aeba ainti ika'i wantiye. ");
INSERT INTO for_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pigoya, pi kama kina'mi kagisa kagopi uma pai'ma yaku kaima tapima mintantawe. Umintuguna Pita aeba pabiti wamagini ige ibakapi umintantiye. ");
INSERT INTO for_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Umintogana kayokaya araga ka'waina kanama yaku nkabura agabebe puma maya untiye: Ma ntagaraba aege miyemi ntagarawe, yogana, ");
INSERT INTO for_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita awamu abarisa'ma: Waya, naeba aepa kampa agantuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Piya otate mintogana, kampagina e'ero kanaba kampa mintogana, to ka'waina agate maya untiye: Pi kaeba ige aruyenabisawe, yogana, Pita: Ma ntagara, naeba kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Pigoya ainti to ka'waina irosa'ma uma esegi puma maya untiye: We, ma ntagara taga aege mibemine. Aeba Karariya marisawe, yogana, ");
INSERT INTO for_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pita maya untiye: Ma ntagara, kaeba kamana yempe kamanapa kampa abintuwe, untiye. Piya yogana kokore ka aga untiye: ");
INSERT INTO for_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pigoya, Wa'ega aeba a'wae pumagina Pitati aomaraogana, Pita aeba Wa'egama ominti kamana napintiye. Piya: Kokore aga kampa untakana, kaeba kakagara naeba aepa kampa agao ntagarawe ukibene ominti, ");
INSERT INTO for_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","pi kamana napimagina antara purite abe'i irosa'ma wama tabera kube'ena puntiye. ");
INSERT INTO for_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pigoya, Isuta kiya kabima minta kina igeba pumireri potama aegumagini, ");
INSERT INTO for_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","aowaba airari kaetama aeguntini: Kaeba poropete mintanapa ma kaeguyemi ntagarama nkagewapa yo, untawe. ");
INSERT INTO for_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pigoya, igeba to pumireri puma uwoma ata kamana otantawe. ");
INSERT INTO for_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Piya puguna marogini, tabe mono kiye kinape mono tisa kinape to kaisa kabiyume kinape a'ya'ma aki puma kamana otakena yuguni, Isu ige aruyenabi ababute wantawe. Piya puguni kamana mayama omintawe: ");
INSERT INTO for_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kaeba Koti utaratanta yagara Karaisiti mintanapa, uma aboraramo, untawe. Piya yuguna aeba maya uwaimintiye: We naeba urimosinta tigu kampa namesine. ");
INSERT INTO for_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Piya, tibigakiripa antotapa kampa unamikibewe. ");
INSERT INTO for_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","We, Wasanama Ntagara naeba ibasa yaga tabe esegi yagara Koti nkayatakanti mikuwe. Pi kana'ne ago aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Piya yogini, a'ya'ma abite: Kaeba Koti Ntagaragawoma, abigantawe. Abigauguma: Tigeba ago yewe. Pipa naewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Piya yogini maya untawe: Nana piyema to kake kamana ukune. Ae'wa nkawamupisa pabigo yegi abune, untawe. ");
INSERT INTO for_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pigoya, a'ya'ma pi kina'mi Isu Pairatiti ababute wantawe. ");
INSERT INTO for_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Aeti wamagini agobima kamana maya uma otantawe: Ma ntagarama nkagoba mayama waintiye. Aeba a'ya'waema mampabisa kina'mite kamana akayaratama: Wasana wa'ega yagara Sisa aepa mone a-nkamiyo untana, ae'wakaba: Naeba Karaisiti, wasana wa'ega yagara nawe iye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Piya yuguna Pairati: Kaeba Yuta kina'mi Nka'ega yagaragawoma, abigaogana: Pi pabigo yene, Isu untiye. ");
INSERT INTO for_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Piya yogana, Pairati tabe mono kiye kinape to uwoma uwa kinape maya uwaimintiye: Naeba ma ntagarama nkaguntaenawakaba aguyosagaopa kampa agauwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Piya yogana igeba esegimagini maya untawe: Aeba waya wa esegi kamana uwaimegini igeba pami ntami puma mare-u me-u pegana, kana ma'ena kamana'ama mampabi tabe puma anosawaye. Aeba Karariya marisa agobima pintana purite mata'i a'ya'ma Yutiya mari pabiyaena piye, piya otantawe. ");
INSERT INTO for_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pigoya piya yuguna Pairati abite: Ma ntagara aeba Karariya marisawoma, ibigantiye. ");
INSERT INTO for_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Piyama ibigaogini igeba owe yuguna: Pipa Eroti kabitemi mpawe, untiye. Piya umagini: Erotiti ababute waiyo, yogini ababute wantawe. Pigoya, Eroti aeba pi kanabipa Yerusaremi kumata a'yo umintantiye. ");
INSERT INTO for_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Piya ababute wauguna, Eroti aeba Isu agama antawamaba asoya puntiye. Aeba Isu nkawaga kamana abima e'ero ntaga aepa agakenagaba abuma mintomekanawe. Pigoya, aeba maya untiye: Naeba yekana awame'ena ka peka agakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Piya umagina Isupa to kamana to kamana abigaoganaba, antotapa kapa kampa a'wae puma omintiye. ");
INSERT INTO for_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Aibogini, tabe mono kiye kinape mono tisa kinape mima kamanapa aeka esegima otantawe. ");
INSERT INTO for_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Piya, Erotibe irebu kina'wape igeba Isu to kake karana atama ata kamana otamagini, wa'ega kai ka maema amitamagini, Pairatiti to kake a'wae puma agarubuguni ababute wantawe. ");
INSERT INTO for_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pigoya Pairatibe Erotibe isigeba paipa isimo'enabi mintantamekinisi, pi ntaga isiyo'ena puma paru puntase. ");
INSERT INTO for_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pigoya Pairatiba tabe mono kiye kinape to ka'isa kiye kinape wa wayape igega'e yogini kanama aki puntawe. ");
INSERT INTO for_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Piya puguna aeba maya uwaimintiye: Tigeba ma ntagaraba naeti ababute kanamagiri maya yewe: Aeba wa waya akayuma kamana uwaimiye, yega, naeba pi kamanaka tige tiyobi abigaopa, kapa tige ota nkaibo'enawapa kampagi aborauwe. ");
INSERT INTO for_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Piya, Eroti pabiyama aguyosakate, to kake umagina agarubagiri a'wae puma to naeti ababute kanawe. Abewo. Purikena awametapa ka'enaba kampa puntiye. ");
INSERT INTO for_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pika naeba yekini, irebu kina'mi eru kasutasa aeguma airisa kasaigina pi kamana'wapa a'ya wakiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Piya, pi ntaninta nakena yagaba aeba iga'nabisa ka yagara iyoba atami puntiye.) ");
INSERT INTO for_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Piya yogini, a'ya'ma pi kina igeba tabe kamana kaga umagini maya untawe: Aeguyegana pureno. Parabasi aepa iga'nabisa iyoba tamo untawe. ");
INSERT INTO for_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Pigoya, Parabasi aeba ka'isa kina'mige kamana akayuma ma'ena pumagina wasana ka aeguma kaiyogini iga'na namapi atantaka, piya untawe. ");
INSERT INTO for_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pigoya, Pairati aeba to kake maya uwaimintiye: Isu uwa atakana wasanaga nabiye untiye. ");
INSERT INTO for_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Piya yogini igeba to kake esegimagini: Maripora aeguyegana pureno. Aeguyegana pureno, untawe. ");
INSERT INTO for_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Piya yuguna Pairati kamana'wai aka'i yogana kakagaena pogana, maya uwaimintiye: Aeba nana kamparagaenaba pegiri aegukena pewe. Naeba aboganaba ataenawaka purikena awametapa kampa piye. Aibegi, yekini eru kasutasa aegugasigina uwa mikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pigoya, igeba esegima to kake tabe kamana umagini imo kamana uma maya untawe: Maripora aeguyegana pureno, untawe. Piya a'yugu kamana umagini kiya yagarama kamana aeguntawe. ");
INSERT INTO for_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Piya puguna pi kamana abiwaemima Isu purenema uma a'ya atantiye. ");
INSERT INTO for_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Piya, kamana'wai wasimagina wasana aeguma kaiyogini iga'na namapi atanta ntagara, aepa iyoba imintana, Isupa ige yumesa puma irebu kina imintiye. ");
INSERT INTO for_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pigoya, igeba Isu ababute ke'i wama wasana ka uma abatantawe. Kana yagarama nkagewapa Saimoni, aeba Sairini kumatasa yagarawe. Aeba torisa kanaogini araku'ma Isunta maripo maema aesaga atauguna aesagabite Isu nkaka'i wantiye. ");
INSERT INTO for_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Pigoya wasana wabe wayape uwoma kina kaga iyega'ma wantawe. Pigoya, uwoma wae'miba intara puma kube'ena puma potantawe. ");
INSERT INTO for_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Piya puguna, Isu a'wae puma maya uwaimintiye: Yerusaremi kumatasa wae, tigeba naeka kube'enaba a-piyo. Tigeba yagararike tigerikeka kube'enaba piyo. ");
INSERT INTO for_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Abewo. Ainti ka kana aborakiripa maya ukibewe: We, anamo waepe iba'waepe yagara nono kampa iminta waepe igeba i'mu piyo, ukibewe. ");
INSERT INTO for_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Piya, pi ata yagaba amu'wamakaba: Tigaba'ma tumima tatikaeyo, untiri, A'abiwamakaba kuya mpaema tapaso, ukibewe. ");
INSERT INTO for_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","We, aoso ya airakuyesa puma naepa naeguntiri, asa yaba aya puwaitakibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Pigoya ata pusume yagara tara aeke kaga iyegukena ibabute wantawe. ");
INSERT INTO for_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Piya wama, maba ka agawapa A'no nkayampu, pita'i irosa'ma Isu maripora aeguntawe. Pigoya ata pusume ntagara ayatakanti kapa aeguntini to kapa ayake'masi aeguntini puntawe. ");
INSERT INTO for_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Pigoya, Isu mayama nunamu untiye: Nabanempa, igeba nae agoga kampagini abintini maya pewe. Pika ataena punatantanawaipa mae igaso, untiye. Pigoya, irebu kina'mi kaiwapa atuguguna abakapisa ata'urite tete'ena puma amaeri ampaeri puntawe. ");
INSERT INTO for_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pigoya, wasanaba uwoma kina mimagini pintanaba agawaeyuguni, kiya kina igeba ka abi'ma ata potama maya untawe: Wasanami ka'isa kina iyo'maeyamisa puma ae'wa nkaupa ao'maeyano. Piya, aeba Karaisiti, Koti utaratanti ntagara mintanaba piya peno, untawe. ");
INSERT INTO for_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Piya yuguni, irebu kina igeba pabiyamagini aeguma, karana atamagini, asa wani amikena puntini maya untawe: ");
INSERT INTO for_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Kaeba Yutiya kina'mi Nkwa'ega yagara mintanapa, kaeka kaupa au'iyo, untawe. ");
INSERT INTO for_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Pigoya, a'notapa kamana awa'ena mayama kaentawe: Ma ntagara aeba Yutiya kina'mi Nkwa'ega yagarawema kaentawe. ");
INSERT INTO for_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pigoya, ataena punti agunta yagara ka'waina maripora mintana iyo'maemagina ka abi'ma maya untiye: Kaeba piyamagaba Karaisitigawo. Kaeka kaukapa iyoba'atantana tasigepa pabiyama kaga iyoba tasitao, untiye. ");
INSERT INTO for_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Piya yogana, to ka ataena punti ntagarama aepa ka abi'ma maya untiye. Kotigaba kampa kaekuru pegina piyaba yeno: Aege kuntaenaba ka awameta ago maeyune. ");
INSERT INTO for_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","We, tasigeba aguntaenaresika umagini kanara mantanaba purasitawe. Aepa aguntaenawa kampa wainta yagara uwa yagara aeguyewe, untiye. ");
INSERT INTO for_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Piya untana, to Isuka maya untiye: Isu, kaeba Wa'ega yagara aintiba irosa'ma naeka napiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Piya yogana Isu maya omintiye: Naeba taga ugamekana abo: Ibanto naege Paratisibi nauka yugabi ampikibene, untiye. ");
INSERT INTO for_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pigoya, kagi abebe papa ibimagina a'ya'ma maba tunusuma waintogana atamaisantiye. ");
INSERT INTO for_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Pigoya, tabe mono namapi Koti auka'i tabe kairasa akumparanta pipa abakapisa atu'wantiye. ");
INSERT INTO for_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Atu'waogana Isu aeba esegima kega'e umagina: Naba, naumanepa kae kayapi atauwe, untiye. Piya utegina purintiye. ");
INSERT INTO for_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pigoya, irebu kina'mi kiya ka'waina aeba pintana agama abitegina, Koti a'mu potama maya untiye: Ma ntagara aeba taga aguntaenawa kampa waima aogi yagarawe, untiye. ");
INSERT INTO for_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pigoya, wasana a'ya'ma pintana agakena kanama ampaki punta kina'miba agama abitegini, intara purite a'wae puma wa'ewaiti wantawe. ");
INSERT INTO for_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pigoya, a'ya'ma Isu nkaokinape Karariya marisa aega'ma kananta wayape igeba pagasara mimagini pintana pumepa agantawe. ");
INSERT INTO for_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Pigoya, Yutiya marasa Arimatiya kumatasa yagara ka mintantiye. Agewapa Yosepe, aeba mono kanisore akiyenabisa yagara mintanta, arupu agu yagara mintantiye. ");
INSERT INTO for_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Pigoya, aokina'mi igeba Isu kamana otama aeguyugunaba, aeba aboganaba kampa aogi puntiye. Kampaye. Pi ntagara aeba Koti kabiratakenaena aborakana agakena agawa puma mintantiye. ");
INSERT INTO for_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pi ntagara aeba Pairatiti wama Isu au maekena wantiye. ");
INSERT INTO for_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Pigoya aeba wama abigaogana, owe otaogana wama mariporasa uma akita urite wae kairasa asaentiye. Asaerite wama yaba mpabi wasana aru ka ku'maranta, pita'i Isu metantiye. Pi kana yaba nkaru kaba kasa'ena waintantiye. Pita'iba paipa wasanaba kampa kaintati uma kaintawe. ");
INSERT INTO for_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pigoya pi ntagaba sabatira nakena naninta maema ai'aru pikena kana a'ya wakena pemikana: Sabati aborakiye, utegini Isu karu'ena maema kaintawe. ");
INSERT INTO for_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Piya pogini ka'isa wae Isuge Karariya marisa kananta wae'mi Yosepe aega'ma wauguna Isu kabinti metaogini agantawe. ");
INSERT INTO for_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Pigoya pintanaba agategini, wa'eri a'wae puma kanama aogi agunta masawae Isu pai'atakena ampa maema yokege puntawe. Piya pumagini, pi sabati tonaentisa ka'umaema yagaba, mono ago kamana aega'ma abimagini uwa atate mintantawe. ");
INSERT INTO for_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pigoya, sontara abaya ase marogini, waya igeba aogi agunta masawae maerite wasana aruri wantawe. ");
INSERT INTO for_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wama irosa'ma agaomepa, yaba kabiba a'waewaogana uwa waintantiye. ");
INSERT INTO for_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Pigoya, pi kana wasana arubinti uma pai'magini Wa'egawama nkau'waka aguyosa'ma kampa agantawe. ");
INSERT INTO for_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Aguyosakategini pami puma mintuguna, tara yagarara kaiwaisipa waentana puwama pa kasa puwanta yagara tara igora ampa aborama mintantase. ");
INSERT INTO for_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Aibusuguni, waya igeba iyekuru puma parokaema mintugunisi pi ntagarara isigeba mayama uwaimintase: Tigeba nana piyemagiri aoganta kinakaba purinta kina'mitiba aguyosagawe. ");
INSERT INTO for_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Aeba mata'iba kampa mintiye. Ago aogama asiwaye. Karariya mari mintana kamana mayama urimintemi, pika napiyiyo: ");
INSERT INTO for_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nabanempaba Wasanama Ntagara naepa aru kina'miti unatakini maripora naeguyigi, papa kakaga peka naogama asikuwe, Isu untiye. Pika napiyiyo, uwaimintase. ");
INSERT INTO for_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Piya yusuguni, waya igeba pi kamanawapa napintini, ");
INSERT INTO for_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","wasana arurisa a'wae puma wa'eri wama abagi kina'wa nagisarisa ka tumpaema kinape to ka'isa wabe wayape kana kamana uwaimintawe. ");
INSERT INTO for_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pigoya, pi kana wae'mi nkigewaipa Mariya Matara kumatasa waena, Yowanawa, to Mariya aeba Yemisi anowampawa, to ka'isa igege kaga miyume waena sumagini, igeba aposoro awaga kamana uwaimintawe. ");
INSERT INTO for_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Uwaimuguna pi kamana abugunaba, kampari kamana kanta pogini kampa aogima abibebe puntawe. ");
INSERT INTO for_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pi kamana'ama yuguna, Pita aeba abitegina karu'ena wasana aruri wama ama irosa'magina kana ka awara ibikamagina agabinti agaumepa, kai ae amana pipi waintogana agategina uwoma agi napiritegina wa'eri a'wae puma kanantiye. ");
INSERT INTO for_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pigoya, pabi ntaga Isu nkaokina igetisa tara yagararamisi Emaosi kumati wakena wantase. Pi kumati Yerusaremi kumatasaba wamagini nayatara'mu kiromita uma irosa puntawe. ");
INSERT INTO for_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Pigoya isigeba ke'i wantinisi pintana aborantika kamana uma abigamaka puntase. ");
INSERT INTO for_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Piya utaginisi wausuguna, Isu aewapa isika'i aboraogini kaga wantawe. ");
INSERT INTO for_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pigoya isiyoba airari kaegasoginisi kampa aepa aogima agama napintase. ");
INSERT INTO for_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Piya pusuguna isibigama maya untiye: Tisigeba nana kamana uma abita kanase, untiye. Yoginisi, isintara pumaginisi isiyowawamaba murise puma mintantase. ");
INSERT INTO for_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Piya puntirisi isigetisa ka yagara agewapa Kiriyopasi aeba mayama Isu kamana antota a'wae puma maya omintiye: Kaeba kampa abeno. Yerusaremi kumati ibasa yaga uwoma kina irosa'magini kana kina'mi tabe kamana aboragini abiwaemagini mintagana, kae ka'wainaga ayama kampa abinta mintanema, abigantiye. ");
INSERT INTO for_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Piya yogana aeba: Nanaena aborayema, isibigaoginisi isigeba maya omintase: Pi Isu Nasareti kumatasa, ae kamanane. Aeba tabe poropete yagara mima Koti nkaobipe a'ya'ma wasanama nkiyobipe esegiyena puma miyi ntagarawe. ");
INSERT INTO for_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pigoya, tabe mono kiye kinatepe kabiye kinatempibe uma kiya yagarama nkayapi aegukena atagana, maripora aeguma kitauguna purintiye. ");
INSERT INTO for_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Piya, taeba aeka napi napi puma: Aeba Isureyo kina taeba ataenabisa tau'ima taba puratakiyema ago napintompene. Piyama napiyokini aeguyegana pu'wagi, mintokana kakaga yaga a'ya puwaye. Pipa ayabayawe. ");
INSERT INTO for_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pigoya, ibaba taetisa ka'isa wae igeba taekuru kamana uramewe. Igeba abaya aseka wasana aruri wama uma agapa, ");
INSERT INTO for_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Isu nkau'wa kampa waintegini uma aguyosakate a'wae puma kanama maya yewe: Enisore tara aboraramima: Isu aogama ago asiwaye, piyama uramese. ");
INSERT INTO for_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Piya, pi kamanapa abima taetisa ka'isa taokina igeba wama waya'mi yesa pumagini uma agapa, ae'wapa kampagini agawe, piya omintase. ");
INSERT INTO for_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Piya omusuguna aeba maya uwaisimintiye: We, tisigeba kampa abeso. Poropete kina'mi kamana kaemarantapa, tigeba nana piyema aibo'enaba puma kampa aogima abibebe pewe, a. ");
INSERT INTO for_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Piya, Karaisiti aeba ayamagina kampa puremisinta manta e'wasaenama nkagupipa uma pasisine. Pipa aeba tagane, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Piya umagina, Mosese kamanape poropete kina'mi kamanape a'ya'ma aeka uma kaemaranta kamana amato pumagina kana kamana agoba kaga uwaisimiwaentiye. ");
INSERT INTO for_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pigoya, igeba wama wakena pume kumati irosantawe. Pigoya, Isu aeba kumapa agaitegina wakena poginisi, ");
INSERT INTO for_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","isigeba araku'ma maya untase: Ago pankaoba pasikena puma ase ikena piye. Kaeba tasigege mata miyo, untase. Pigoya, isigege mikenaga owe yoginisi, namapinti kaga intawe. ");
INSERT INTO for_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Pigoya naninta nakena mara'mimagina pareti maema a'mu potama ako puma isimintiye. ");
INSERT INTO for_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Piya pogana, isiyowamaba araoginisi Isu agabebe pusuguna, pabigo Isu kaka wantiye. ");
INSERT INTO for_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Aiboginisi, isigeba pi kamanapa uma abigamaka puma maya untase: Ke'i kamana urasimintana mono ago urasimeginaba tasintama abarutama aogi pemi kamana iye. ");
INSERT INTO for_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Piya umaginisi, pabi ntaga asima to kake Yerusaremi kumati a'wae puma wantase. Wama uma irosa'ma ae'wa nkabagi kina nagisarisa ka tumpaema kinape to ka'isa iyokinape aki puma mintuguna uma ibatantase. ");
INSERT INTO for_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Piya pusugini igeba to kamana mayama uwaisimintawe: Wa'ega aeba taga asiwagina Saimoni agaye, untawe. ");
INSERT INTO for_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Piya yugunisi, isigeba: Pabiyama Wa'egawama ke'i aborarasimima wama namapinti pareti maema a'mu potama apako pegira tasigeba ago agause, piya uma uwaimintase. ");
INSERT INTO for_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Pigoya, abagi kina igeba pi kamana uma mintuguna, Isu aewa abakankaipi aborantiye. ");
INSERT INTO for_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Piyama aboraogini, igeba agamagini pami puma iyekura puma: Kewama aboraye, untawe. ");
INSERT INTO for_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Piya yuguna Isu maya uwaimintiye: Tigeba nanaga tiyekuru puma tigu'amaba tara tara piye, a. ");
INSERT INTO for_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","Mapa naene mintuwe. Tigeba nagisa nayapa agaiyo. Piya pumagiri kanama nauta aukaya puma nagaiyo. Nae'ne ntau'nentagane. Nae nagasa piyo. Piya, ke kina'ma awasebe ayampube kampa waintiye, umagina agisa ayapa uma iyakintiye. ");
INSERT INTO for_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Piya pogana, igeba intawama aogi pogini kamana'wapa kampa abinta, uwa napi napi puma i'mu puma mintuguna: Nanintaripa ka'isa waintiyo, untiye. ");
INSERT INTO for_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Piya yogini igeba inoyanta kaemaranta amuguna, ");
INSERT INTO for_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","aeba maema naogini agantawe. ");
INSERT INTO for_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pigoya, to ka maya uwaimintiye: Naeba tigege mima maya uma uwaimima mibuntone: Mosese kamanapipe poropete kina'mi kamanapipe Samu ini isapipe a'ya'ma naeka meto kamana kaemaranta, pipa tagantana puwaikiye, urimintone, untiye. ");
INSERT INTO for_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Piya uma pi mono agowapa uma aborawaimogini abintawe. ");
INSERT INTO for_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Aibuguna to maya uwaimintiye: Karaisiti naekaba mayama kaemarantane: Aeba auki nakiyena puma pu'ma, pu'wakibipisa papa kakaga pekana aogama asiwakiye. ");
INSERT INTO for_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Piya pekini aokina'mi awaga kamana uma a'ya'waema marisa kina mono uwaimima, igu a'wae puma aguntaenawaipa uma asu'a pikenaena aborano, uwaimikena wakibewe, mayama kaemarantane. Piya, pi kamana uwaimikena yugaba Yerusaremi kumatasa agobiritegiri wagana kana pubewe. ");
INSERT INTO for_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Piya tigeba aogi kamana'ne uwaimikena kina'nepa tigewe. ");
INSERT INTO for_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Pigoya abewo. Nabanempa ka'ena timikenaga untemika ota'kana tumikiye. Pika tigeba ma kumapa a-nkatantiri uwa agawa puma mintigina inatisa esegiyena tigeta tumekiri wama aogi piyo, piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Pigoya pi kamana ugaitegina, wa'erisa ibabute wama Petani kuma agora uma irosa'ma aya nkasabuma: Aogima miyiyo, uma a'mu puwaitantiye. ");
INSERT INTO for_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Piyama a'mu puwaitategina itate intiye. ");
INSERT INTO for_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Piya pogini, igeba tabera i'muntana purite Yerusaremi kumati a'wae puma wama, ");
INSERT INTO for_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","tabe mono namapi asi nasi uma mima Koti i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Pigoya, paitaka'ya kamana agoba mintantiye. Pi kamana agoba Kotige kaga mintantiye. Pi kamana agoba aewa Kotiwe. ");
INSERT INTO for_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Paitaka'ya aeba Kotige kaga mintantiye. ");
INSERT INTO for_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Pigoya Koti otaogana, aewa a'ya'waemaenaba aborawaentiye. Ka'enaba to ki'isa kampaye. A'ya'waemaena aborantipa, pipa aewa pogana aborantiye. ");
INSERT INTO for_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Pigoya, aeba miyaba'enama nkagoba mintantiye. Pi miyaba'enaba wasanamiti e'wasa puratantiye. ");
INSERT INTO for_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Pi e'wasaenama tununtanabi arawaogana, tununtanama nkagoba kampa airarikaentiye. ");
INSERT INTO for_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pigoya, Koti otaogana ka yagara ampa aborantiye. Agewapa Yoniwe. ");
INSERT INTO for_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Aeba Koti nkomintemi kamana uramikenaga ampa aborantiye. Piya, aeba pi kana e'wasaenama nkagowaka a'ya'ma kina urameka, abima tamatiti pukubompeka Koti otaogana ampa aborantiye. ");
INSERT INTO for_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pi Yoni aeba e'wasaenama nkagoba kampaye. Aeba kanama e'wasaenama nkagowaka awaga kamana ukenaga kanantiye. ");
INSERT INTO for_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kanaogana, ae aka'i pi e'wasaenama nkagowampa mabi aborantiye. Aborama a'ya'ma maga maga kina'mi kipa ara puratantiye. ");
INSERT INTO for_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pigoya, mabi ampiyogini, mabisa kina'miba pi mpaba aboranti ntagaraga kampa aogima abimagini agantawe. ");
INSERT INTO for_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Piya, aeba mawata aboraoginiba, pi Yuta aokina'miba aepa kampa agoya potantawe. ");
INSERT INTO for_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pigoya, a'ya'ma agoya pota kina igeba Koti ntagara aragaena pikena ki aborawaimintiye. Pipa ae agega napima aegara kina piya puwaitaye. ");
INSERT INTO for_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Piya, pi Koti ntagara araga wasanami kurapisabe napiyenabisabe kampagini aborawe. Wasana ka'wainatisaba kampaye. Pi Koti ntagara araga Koti aumawapa imegini aborawe. ");
INSERT INTO for_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pigoya, kamana agoba aeba wasana aboramagina, awagaenawape tagantanawape pumaema waitantogana mintoga, e'wasaenawapa agantompene. Piya, Koti ntagarawa ka'anto mintogana, otaogana tumpintoga e'wasaenawapa agantompene. ");
INSERT INTO for_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Pigoya, Yoniba ae kamana aborama kega'e uma aeka maya untiye: Naka'i ampa aborami ntagara maru mintantine. Aeba pabiyama asu nagasima mintiyema, pai urimintone, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Pigoya, a'ya'ma aogiyenaba pumaema aeti waintoga, awagaenawapa toma toma maemagi mintantompene. ");
INSERT INTO for_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kotiba Mosese ke i'ma, ago kamana'wapa omogana uramintiye. Piya, Isu Karaisitipa otaogana, aeba pi nkawagaenawape tagantanawape aboraramintiye. ");
INSERT INTO for_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Wasana ka'waina Kotipa kampa agantine. Pipa kampaye. Koti ntagara, abawampa nkagora miyemi'na, ae abiwapa agantana, awaga kamana'wapa uma aboraramintiye. ");
INSERT INTO for_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Pigoya, Yerusaremi kumatasa Yuta kina'mi ka'isa mono kiye kinape iyo'maeyume kinape uwaitauguni, Yoniti wamagini: Kaeba kegawema, abigauguna, agowapa uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Aeba agowapa kampa kakanta aborama: Naeba Koti utaratantegiri agawa pe ntagara Karaisitiba kampaye, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Piya uwaimogini, igeba to kake atesumagini mayama abigantawe: Aya yagaragawe. Kaeba Iraiyakawo, yuguna: Naeba aeba kampaye, yogini: Kaeba agawa pompe poropete yagaragawo, yuguna, aeba toba: Kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Piya yogini, igeba to mayama abigantawe: Kaeba kegawe. Urataga, kanaompe kinati wama uwaimikena pune. Kaekakaba nanawe yenema, abigantawe. ");
INSERT INTO for_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Piyama abigauguna maya uwaimintiye: Poropete Aisaya awa'ena uma kaentipa, pipa naeti esegi piye. Pipa mayamawe: Pigoya, naeba awaga kamana ikena yagara, ka'me mpari mima kega'e umagi, Wa'egawamanta ke'i arupu puma amuyena piyo, yuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pigoya, Yoniti ampa irosanta kina igeba Parasi kina'mi nkaruyenabisawe. ");
INSERT INTO for_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Pigoya, pika to kake abigama maya untawe: Kaeba Karaisiti yagaraba kampaye. Iraiyaba kampaye. Pi utaratanta poropeteba kampaye, piya yempene. Pipa nanaraka wasanaba mono wanipa pai'itane, untawe. ");
INSERT INTO for_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Piya yuguna, Yoniba maya uwaimintiye: Naeba wanitasa pai'itauwa, pigoya abakatipi ka aborama mintipa, tigeba aepa kampa aogima agabebe pewe. ");
INSERT INTO for_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Pi aeba naka'i kanaye. Agewapa asunagasima waintika, naeba mayamanaba agisa anapa kampa akubo agaikuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Pigoya, pintanaba Petani kumata Yontani waninkama maroteri aborantiye. Pigoya, pita'i Yoniba mima wasanaba mono wanipa pai'itantiye. ");
INSERT INTO for_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pigoya, marogana Isuba Yoniti kanaogana, agate wasana maya uwaimintiye: Agaiyo. Maropa Koti sipisipi awaro kanaye. Aeba a'ya'ma kina'mi nkaguntaenare maema asu'a puragaikibi ntagarawe. ");
INSERT INTO for_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Pigoya, pi aeka maya urimintone: Naka'i ampa aborami ntagara maru mintantine. Aeba pabiyama asu nagasima mintiyema, piya urimintone. ");
INSERT INTO for_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Naenepa paipa aepa kampa agabebe puntone. Isureyo kina tige ae awaga kamana urimekiri agowapa abintigi, ampa irosa'ma wanitasa paititauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Piya untana, Yoniba aeka to maya untiye: Aota Awamusa'ama mantarisa atate, pupunta kanta purite aeti tumpintoga agantone. ");
INSERT INTO for_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Pigoya, naenepa paipa kampa agabebe puntuwagana, wani pai'itao unatanti'na maya unamintiye: Awamusa a'nota tumpintakana agakibempe ntagara, aeba wasana Aota Awamusatasa pai'itakiyema, unamintiye. ");
INSERT INTO for_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Pigoya, naeba pi agantoka agowapa abima, aeba Koti ntagarawe, untone. ");
INSERT INTO for_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pigoya marogana, Yonibe abagi yagarawa tarabe pabi mpara asimagini mintantawe. ");
INSERT INTO for_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Mintuguna, Isuba pabita'i waogana Yoniba agate: Agaiyo. Koti sipisipi awaroba marompaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Piya yoginisi, isigeba abite Isu aega'ma aka'i wantase. ");
INSERT INTO for_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Aka'i wausuguna, Isuba a'wae pumagina isigate, maya untiye: Tisigeba nanaga aguyosagakena kanasema, isibigaoginisi isigeba maya untase: Arabai, kaeba aenkau'i mintane, untase. Pi Arabaiwe untame kamana tae kamanapisa Tisawe yune. ");
INSERT INTO for_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Piya yusuguna: Kanama ampa agaiso, untiye. Piya yoginisi, isigeba aege wamaginisi minti ntamanka agausuguna, ago atamaisaoginisi pi ntagaba pabi miyometa mintantase. ");
INSERT INTO for_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Pigoya, Yoni kamana abima Isu nkaegarantame, kapa agewapa Enturu, aeba Saimoni Pita nka'nanto, ");
INSERT INTO for_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","aeba marupa agantowampa Saimoni abatama maya omintiye: Tasigeba Mesaya yagara abatause, omintiye. Pigoya, Mesayawe unta kamana tae kamanapisa Utaratanta yagara Karaisitiwe yune. ");
INSERT INTO for_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Piya omima, Enturuba ababute Isuti wantiye. Piya pogana, Isuba agate maya untiye: Kaeba Saimoni, Yoni ntagaragawe. Kae kageba Sipawe ugamuwe, untiye. Pi kana agiba a'wae puma Pitawe, pipa yabane, yune. ");
INSERT INTO for_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Pigoya marogana, Isu aeba Karariya mari wakena aseyo puntana, Piripi abatama: Kaeba naegaraoma, omintiye. ");
INSERT INTO for_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pigoya, Piripi aeba Petisaita kumatasawe. Enturube Pitabe isigeba pabi kumatasawe. ");
INSERT INTO for_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pigoya, Piripiba Nataniyeri abatama maya omintiye: Mono isapi utaratanta yagaraka meto kamanapa Mosese ago kamana kaemaraogini, poropete kina'mi kaemaranta, aepa abataune. Aeba Yosepe ntagara Isu, Nasareti kumatasawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Piya yogana, Nataniyeriba mayama a'wae pomintiye: Nasareti kumatasaba ayabaya puma aogiyenaba aborakiye, yogana: Kanama ampa agao, Piripiba piya omintiye. ");
INSERT INTO for_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pigoya, Nataniyeriba Isuti wama uma irosaogana, agantana aeka maya untiye: Agaiyo. Taga Isureyo yagarawe. Antabaipintiba kumpariyenawapa kampa waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Piya yogana, Nataniyeriba: Kaeba aeta mintuwagana nagantampene, untiye. Piya yogana, Isu maya a'wae pomintiye: Piripiba kampa kagega'e untegina, piki ya agobi mintaka kagaone, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Piya yogana, Nataniyeriba abima to maya omintiye: Tisa, kaeba taga Koti ntagara, Isureyo kina'mi Nkwa'egarekawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Piya yogana, Isuba maya untiye: Piki ya agobi mintaka pi uma aboragamogana, abimagina naegarampepa abeno. Agama abempepa pipa agasawane. Pigoya, to tabenawapa agama abikibene, untiye. ");
INSERT INTO for_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Piya untana to maya untiye: Naeba tagaka urimukuwa, abiyo. Aintiba mantaba a'waiyekana, Koti nkenisore kina'miba Wasanama Ntagara naeti ite tumite pigiri igakibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Pigoya kakaga yaga a'ya puwaogana, Kena kumata Karariya mari waya iba'ena pikena nanintaena puma aki puntawe. Aibuntini, Isupe anowampape abagi kina'wape kaga igega'e yuguni ampa irosantawe. ");
INSERT INTO for_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Piyama a'ya'ma kina'mi aki puma nantini, wainiba nauguna tagankaogana, Isu nkanowampa: Wainiwaipa a'ya wayema, omintiye. ");
INSERT INTO for_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Piyama omogana Isuba maya omintiye: Ma nkwae, nanaga naepa unamene. Naekana aborakena yagaba ibaba kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Piya yogana, kana anowampaba kayokaya kinapa: Ka'enaga urimekiripa piyo, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Pigoya, pi ntamapipa wani kankabeba tonaentisa ka'umaema yaba kankabeba waintantiye. Piya, Yuta kina'miba monoka napimagini iyapa wani nkaema miyumekana, pi ntamapintiba waintantiye. Pi kana kankabeba uwaenantoba kampaye. Abaenaraka'yane. ");
INSERT INTO for_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Pigoya, Isuba kayokaya kinapa maya uwaimintiye: Tigeba wani iru'ma pi kankabebi tigiyo, yogini, igeba abite wanipa iru'ma kankabebi tiguguna awaitawaentiye. ");
INSERT INTO for_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Piya puguna maya uwaimintiye: Tigeba ibaba ka'isaba ari'urite nanintara kabiyome ntagaramati waiyo, untiye. Piya yogini igeba irurite wauguna, ");
INSERT INTO for_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","kana wainiba pi ntanintara kabiyome ntagara aeba nabigategina, aetasabaya irurite kanawemaba kampa napintiye. Piya pogini, kayokaya kina wani iru'ma tabe kankabebi tiginta kina, igemana wainiwama nkagoba abibebe puntawe. Pigoya, kana nanintara kabiyome ntagara aeba kana waya iba kasamume ntagarapa kega'e uma, ");
INSERT INTO for_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","maya omintiye: Maru iga wainiba imegini, namagini iga'e pagasigina ainti kampa aogi wainiba imisanawe. Kaeba ayagabaya iga wainiba kakatakana waintegina ainti imene, untiye. ");
INSERT INTO for_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Pigoya, Isu aeba Kena kumata Karariya mari awame'ena pikena esegiyenaba agobima aboraogana, e'wasaenawapa aborantiye. Aibogini, abagi kina'wampiba pintana agategini, aepa aega'magini imatiti puntawe. ");
INSERT INTO for_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Pigoya, pintanaba a'ya puwaogana, Isuba pi kumatisaba Kapaniyamu kumati tumogini, anobe a'natabarabe abagi kina'wape aege kaga tumiwaentawe. Pigoya, pitapa uwaena yaganto mintantawe. ");
INSERT INTO for_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pigoya, Yuta kina'mi Pasoba i'muntanawai agarosaogana, Isuba Yerusaremi kumati ima mintantiye. ");
INSERT INTO for_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Aibuntana, tabe mono namankama nkantabaipintiba asu agaomepa, ka'isa kina'mi purumakape sipisipibe kabarape maete wama ikantana puguni, to ka'isa kina'miba mone antota ankami ankami puma mintantawe. ");
INSERT INTO for_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Piya puguna Isuba igategina, iga'na maema kibaru'magina, a'ya'ma wasanabe sipisipibe purumakape iyeguma igarubaogini, pi ntamapisa iyegaka wauguna, kana mone yabaeba apasana'ma monewaipa asunukaentiye. ");
INSERT INTO for_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Piya puntana, kabara ikantana pume kinapa maya uwaimintiye: Mantanaba maete waiyo. A'yugu piya peganaba, nabanempa ntamankamaba ikantana namantana piye, untiye. ");
INSERT INTO for_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Isu piya pogini, abagi kina'wampiba mono isapi kamana awa'ena waintanti, pika napintawe: Kae namataka nantabaipintiba yaku nkabusa iye, piya kamanaka napintawe. ");
INSERT INTO for_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pigoya, Yuta kina'miba abigama maya untawe: Kaeba piya pempeka, esegiyenagampa nkagoba aborama awame'ena kapa tayakega agano, untawe. ");
INSERT INTO for_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Piya yuguna, iwamuta u'magina maya uwaimintiye: Tigeba ma tabe mono nama akasabaigipa naeba kakaga yaga a'ya peka, to kake kima a'ya pukuwe, piya untiye. ");
INSERT INTO for_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Piya yogini, pi Yuta kina'mi maya untawe: Anasa kinatempiba kaboba 46 kima a'ya puntawe. Pigo kaeba kakaga yaga kimagina a'ya pikenaga yeno, untawe. ");
INSERT INTO for_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pigoya, Isu mono namankamaka untipa, pipa ae'wa nkau'amaka meto kamana untiye. ");
INSERT INTO for_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Pigoya, ainti purintapisa asiyogini, abagi kina'miba pi kamana'wapa to ka napimagini, pipa mono isapisa, ae unti kamana, abugunaba tagantana puwaentiye. ");
INSERT INTO for_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pigoya, Isu aeba Pasoba nakena yagaba Yerusaremi kumata mimagina, awame'ena pogini, uwoma kina'miba agategini ae ageraka imatiti puntawe. ");
INSERT INTO for_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Piya puguna, Isu aeba wasanaba igabebe puwaentika, ige iyapipa ae'wantanaba kampa atantiye. ");
INSERT INTO for_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pigoya, aeba a'ya'ma wasanami nkago abikenaba wasanapa kampa ibigantiye. Uwaba aewa wasanami nkintabaipintiba igabebemagina agawaentiye. ");
INSERT INTO for_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pigoya, Parasi yagara ka mintantiye. Agewapa Nikotimasi, aeba Yuta kiye yagara mintantiye. ");
INSERT INTO for_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Pi ntagara aeba aseka Isuti wama maya omintiye: Tisa, taeba agogapa abune. Kaeba Kotitisa taga tisa yagara aborantane. Piya, wasana ka'waina Kotiba antabaipi kampa mintegina, awame'ena pempesapa kampa piye, untiye. ");
INSERT INTO for_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Piya yogana, Isu maya omintiye: Naeba tagaka ugamukuwa, abo. Ka'waina aeba to kake kampa yakari potakanaba, aeba Koti kabiratakenaenaba kampa asu agakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Piya yogana, Nikotimasiba to maya omintiye: Ka'waina aeba ago anasa puwanti'naba, ayamagina kasapa aborakiye. Ayamagina anowampa nkantabaipintiba uma pasekanaba to kake yakari potakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Piya yogana Isu maya omintiye: Tagaka ugamukuwa, abo. Ka'waina aeba wanitasabe Awamusatasabe kasa'ena kampa aboranti'naba, Koti kabiratakenaenabipa kampa asu mikiye. ");
INSERT INTO for_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Piya, wasanama aga'e puma yakari potaipa, pipa wasana aogane. Aota Awamusa'ama yakari potaipa, pipa Awamusa'ama nkaogane. ");
INSERT INTO for_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tigeba yakari pikenaena kasa aboraiyoma, yopa, kaeba abimaginapa kuntaba a-po. ");
INSERT INTO for_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pigoya, pontaba ae'wantanaba piye. Aetasabaya kanate wate piye. Pipa kampa abintane. Agasankapa abepa, pipa pontawe yewe. Piya yemisa puma, ka'waina aeba Awamusa'ama yakari potanti'na, agowapa pabiyama agawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Piya yogana, Nikotimasiba maya omintiye: Pipa ayamagina piyaba pikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Piya yogana, Isu mayama a'wae pomintiye: We, kaeba Isureyo tisa yagara mimagina, pipa kampa aogima abeno. ");
INSERT INTO for_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Naeba tagaka ugamukuwa, abo. Taeba agama abompentanaba aborama urimokiripa, pipa tigeba kamanatepa a'a-o yewe. ");
INSERT INTO for_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Pigoya, naeba mabisaenaga urimogiripa kampa napiyewa, pipa mantari kakama waintintanaga urimekiripa, ayama abimagiri napikibewe. ");
INSERT INTO for_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pigoya, wasana mantariba kampa ima uwa asu agaye. Kampaye. Wasanama Ntagara nae ka'anto mantara mintantotisa tumpa pika urimuwe. ");
INSERT INTO for_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Pigoya, Moseseba paipa ka'me mpari kuyapa yara itagintisa puma, Wasanama Ntagara naepa yara ita natakibewe. ");
INSERT INTO for_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Piya pigina, naeti imatiti pikibe'nagiba miyaba'ena aboramagini mikibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Pigoya, Koti aeba a'ya'ma kina'mikaba tabera abugaogana, yagarawapa ka'antowa mintogana, aepa taeti otantiye. Aepa aega'ma imatiti pikibe'nagiba ataenabipa kampa tumpintini, e'wasa maema miyaba mikibewe. ");
INSERT INTO for_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Piya, Kotiba yagarawapa mabisa kinapa kamana uma uratanemaba kampaye. Wasana i'ima iba piyoma otaogana tumintiye. ");
INSERT INTO for_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pigoya, ka'waina aeba aega'ma amatiti pikibi'naba, aguntaenama nkantota'enaba kampa maekiye. To ka'waina kampa aega'ma amatiti pikibi'naba aguntaenama nkantota'enawapa waitakiye. Piya, Koti Ntagara ka'antowa nkagegaba kampa napima amatiti pikibika aguntaenawapa waitakiye. ");
INSERT INTO for_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Pigoya, pi antota'enama nkagowapa mayamawe: Mabi e'wasaena maete tumintogini, mabisa kina'miba tununtanaga ibugantana, e'wasaenagaba kampa ibiye. Pigoya, pipa nanagawanane. Ataenawai waintika piya puntawe. ");
INSERT INTO for_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Pigoya, a'ya'ma kamparagaena pe kina'miba pipa e'wasaenama kama potawe. Igeba kamparagaenawai aborasanagaba kampa ibegini, e'wasaenariba kampa kanawe. ");
INSERT INTO for_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Piya, ka'waina tagantana pi'naba, aeba e'wasaenabi uma aboraye. Aeba yogawapa Koti nkesegiyenara puntika, uma aboramegini aogima agawe. ");
INSERT INTO for_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Pigoya, Isuba kamana uma a'ya atate, abagi kina'wa ibabogini, Yuta mari ka au'i wama umintantawe. Pita'i umimagina, Isuba mono wanipa pai'itantiye. ");
INSERT INTO for_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Pigoya, Yoni aeba Inoni kumata mima, Serimi agora mima, pabiyama wani pai'itantiye. Piya, pitapa wanipa tabe waintogini, pita'i wasanaba ampa irosauguna mono wani pai'itantiye. ");
INSERT INTO for_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Pi ntagaba Yonipa iga'na namapipa kampa aba potantawe. Pipa asawe. ");
INSERT INTO for_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pigoya, Yuta yagara ka'wainage Yoni nkabagi kina'wampige wani pasikenaenaga kamana umagini akayuntawe. ");
INSERT INTO for_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Piya pumagini, igeba Yoniti wamagini maya omintawe: Tisa, kaeba Yontani wani maroteri mintukuna, ka yagara ampa irosaogana, agowapa aboramagina uramintampepa, aeba ma kanabipa pabiyamagina wasana mono wani pai'itagini aeti wawaeyewe, untawe. ");
INSERT INTO for_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Piya yuguna, Yoniba maya uwaimintiye: Ka'waina Kotiba ka yugawaka kampa otakanaba, aewapa kampa uwaba maekiye. ");
INSERT INTO for_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Naeba Koti utaratanta yagara Karaisitiba kampaye. Naeba ae awaga kamana uma aborakena yagara Kotiba unatantegi, paitama kanantone. Piyama urimuwagiri tigeri abintawe. ");
INSERT INTO for_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Piya, iba'wae'ma nkawaewampa aewa maeyagina, ao'yagaramaba ao'maemagina aeka a'mu potaye. Piya, ao'yagaramaba a'mu potaisa puma, aneba na'mu potauwe, Isuka piya untiye. ");
INSERT INTO for_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Piya, ae agewamaba anosama tabe pekana, nae nagewamaba tumikiye, Yoni piya untiye. ");
INSERT INTO for_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Pigoya, inatisa tuminti'naba asuragasiwaeye. Mabisa aboranti'naba mabisaena puntana, mabisaenaga iye. Piya, mantarisa tuminti'naba pipa asuragasiwaeye. ");
INSERT INTO for_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Pi ntagarawama a'ya'waemaena agama abinti, pi awaga kamana yeginiba, wasanamiba iyekita puma kamana'wapa a'a-o yewe. ");
INSERT INTO for_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pigoya, wasanama pi kamanapa abemi'naba, Kotiba taga semi ntagaraga: Owe, iye. ");
INSERT INTO for_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Piya, Koti otami'naba, aeba Koti kamana'amana siye. Piya yagaraba aepa Kotiba Awamusapa atunkapa kampa amikana uwa amiyaba miye. ");
INSERT INTO for_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Piya, abawampaba pi yagarawakaba abugagina, a'ya'waemaenaba ae ayapi atawaentiye. ");
INSERT INTO for_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pika ka'waina aeba Koti ntagarawapa aega'ma amatiti'ena pemi'na, aepa miyaba'enaba ago aboramiye. Piya, to ka'waina aeba Koti ntagarawampa kamana kampa wasiyemi'naba, miyaba'enaba kampa aboramekana, Koti nkamo'enawapa aeti waiyaba mikiye. ");
INSERT INTO for_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Pigoya, Parasi kina igeba Isuka mayama abintawe: Aeba abagi kina uwoma ibabumagina wani pai'itamagina Yonipa asugasayema, abuguna Isu abintiye. ");
INSERT INTO for_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Piya, Isu aewapa kampa wanipa pai'itantiye, abagi kina'wampika yogini pai'itantawe. ");
INSERT INTO for_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Piya, Isuba Parasi kina'mi pi kamana abuguna abitegina, aeba Yutiya maba atate Karariya mari a'wae puma to kakema wantiye. ");
INSERT INTO for_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Wamagina, pi ki'i aega'urite wama Sameriya maba akata wantiye. ");
INSERT INTO for_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Pita'i wamagina Sameriya kumapa ka, agewapa Saika, pita'i uma irosantiye. Pi kumapa Yekobu yagarawa Yosepe aminti mpawama nkagora waintantiye. ");
INSERT INTO for_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pabita Yekobunta wani kaba waiyogana Isu aeba kagi abebe uma irosa'ma, ayampu kampa pogana wani ka awara mara'mimagina migarantiye. ");
INSERT INTO for_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Mintogana, pi kumatasa wae ka'waina wani itikena ampa irosantiye. Irosaogana Isuba: Kaeba wanipa namega nano, omintiye. ");
INSERT INTO for_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Piya, abagi kina'wapa igeba naninta ika pikena kumati igasuguna, Isuba abintowa mintana kana waepa wanikaba omintiye. ");
INSERT INTO for_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Omogana, kana Sameriya wae aeba maya untiye: Kaeba Yuta yagaramagaba nanaga Sameriya wae'mantekaba wanikaba nabigane, untiye. Piya, Yuta kinape Sameriya kinape atokaema kampa miyumekana kana wae aeba piya untiye. ");
INSERT INTO for_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Piya yogana Isuba maya omintiye: We, kaeba Koti kao'enama nkagobe pi wanika ugamo nkagonepe kaga kampa aogima abempesinta esunataka e'wasa maekena wanipa kamosine, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Piya yogana, kana wae'ma maya omintiye: Tabe yagara, wani kaba pipa e'erona, kaeba wani itikenaenagapa kampa waintiye, kaeba e'wasa maekena wanika yempepa aetasa itikibene. ");
INSERT INTO for_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Tayabama Yekobu ae ma nkwani kaba ku'magina, aewape yagara purumakawampibe igeba to wanitasa wanane. Pabi matasa namagini mintantane. We, kaeba ayamagina Yekobupa agasimagina wanipa kapa maema aborakibene, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Piya yogana Isuba maya omintiye: Piya, ma nkwanipa kampa agora tiga'e pakena wanikiri a'ya'ma yagaba nayaba'miyewe. ");
INSERT INTO for_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pi nae wanipa ka'waina amekana aeba pi nakibipa, aepa wanikaba to kakema kampa abekana uwa miyaba'mikiye. Naeba pi nkwani amekana agupi wani nkaru aboramekana miyaba'mikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Piya yogana, kana wae'ma maya untiye: Tabe yagara, kaeba pi kana wanipa namegana to kakema wanikaba kampa nabeka, mata'i asi nasi kanamagi itiyaba'miyopa kasano, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Piya yogana Isuba maya omintiye: Kaeba wamagina kawaegampa ababute kanaiso, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Piya yogana, kana wae aeba: Naeba nawaenempaba kampaye, untiye. Piya yogana Isu maya untiye: Kaeba kawaegampaba kampaye, pipa kanara sene. ");
INSERT INTO for_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Kaeba waba nayaka'mu maegate itate puntampekana, pigo ma mintemi nkwaba pipa aeba kae kawaeba kampaye. Pika kaeba taga kamana yene, omintiye. ");
INSERT INTO for_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Piya omogana, kana wae aeba maya omintiye: Yabe yagarane, naeba ibanto ago abuwe. Kaeba poropete yagaragawe. ");
INSERT INTO for_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Pika yega abeno: Tae tayabamagiba ma nkamuta Koti nkaobi aki puma kamana'wa abeno, yegiri, piya Yuta kina tigeba: Kampaya, Yerusaremi kumata aki puma Koti kamanapa abiyo, yewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Piya yogana Isu maya untiye: Waya, naeba ugamukuwa, abo. Nabanempa aeba ma nkamutapa kampaye. Yerusaremi kumatapa kampaye. Uwa a'ya'ma mari Koti nkawaga kamana ikena kana agarosakena piye. ");
INSERT INTO for_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Tigeba kampa abintiri kampa agantanama kamanapa yega, taeba pipa abibebe pumagi pune. Mono pipa Yuta kina taeti aboraye. ");
INSERT INTO for_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Pigoya kana ka aborakiya, pipa mampa ago aboraye. Pita'i taga mono kina'miba monota mima igu imawamaba naba nkawaga kamana taga sikibewe. Naba aeba piya mono kina'mika abiye. ");
INSERT INTO for_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Piya, Koti aeba amanine. Pika ae awaga kamana ikena monota mima tigu timarasaba tagaka yiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Piya yogana, kana wae aeba maya untiye: Naeba ago abuwa, utaratanta Mesaya aborakiye untapa, aboramagina kamana uma aogi puma arupu puramikiye, untiye. Piya, pi Mesayaba aeba Karaisitiwe. ");
INSERT INTO for_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Piya yogana Isu aeba maya untiye: Kamana ugamopa, pipa naewe, omintiye. ");
INSERT INTO for_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Pabigo piya yogini abagi kina'wa ampa irosantawe. Ampa irosa'magini kana wae'mage kamana yusumeka uwoma nkigi napintawe. Piya puntini, nana kamana nanaga omenema abigakena abumepa kunta pogini atantawe. ");
INSERT INTO for_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pigoya, kana wae aeba wani kankabewapa pabita atate kumati karu'ena wamagina wasana maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Tigeba kanamagiri ka yagara agaiyo. Aeba a'ya'waemaena punto, pi kamanapa aborama unamiwaeye. Aeba Karaisitibayawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pigoya, igeba pi kamana abite kumatisaba Isuti wawaentawe. ");
INSERT INTO for_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Pigoya, pi ntagaba abagi kina'wampiba: Tisa, kaeba naninta nao, untawe. ");
INSERT INTO for_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Piya yuguna maya uwaimintiye: Naeba ka'isa naninta waintipa tigeba kampa abintawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Piya yogini, abagi kina'wa igewai mare-u me-u pumagini maya untawe: Ke kapa nanintaba maetegina menkaiye, untawe. ");
INSERT INTO for_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Piya yuguna aeba maya untiye: Unatanti, ae awamu wasima yogawa puma a'ya pikenaena pi'na nanintanentana piye. ");
INSERT INTO for_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Tigeripa mayawe yewe: Opa tarawa tarawaki to a'ya puwakana mata'i nakenaba aborakiye, yewe. We, naeba urimekiri abiyo: Tigeba asaga'yuma tiyo ma'ma yoga agaiyo. Nakena aborakena kanapa mampa agarosaye. ");
INSERT INTO for_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Naninta nakena yogarisa maema miyaba'enabi aki pikibi'naba ikantana maekiye. Psya, aintana yoga punti'nabe kana nakena maenti'nabe isigeba kaga isi'mu pikibese. ");
INSERT INTO for_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Piya, ma kamanapa tagane: Ka'waina aintana pegina to ka'waina nakenaba maeye. Tara yaga isigeba ka yuga pese, pipa tagane. ");
INSERT INTO for_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Naeba tige aintana kampa puntati nakena aki punataiyoma, uritauwe. Yoga pipa ka'isa kina'mi pumarantagana aboranti, pipa tigeba uwa a'na puma maeyawe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Pigoya, Sameriya wae aeba: A'ya'waemaena punto kamanapa pipa aboramagina unamiwaeye, unti kamanaka uwoma pi kumatasa kina'mi abitegini, Isu aegarantawe. ");
INSERT INTO for_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pika Isuti ampa irosa'magini igege miyenema esotantawe. Piya puguna, aeba owe uma tara yaga ige kumata mintantiye. ");
INSERT INTO for_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Piya puntana, mono uwaimogini to uwoma kina'mi abibebe puma aegarantawe. ");
INSERT INTO for_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Piya puntini, kana waepa maya omintawe: Marupa kae yeka mono'wapa abune. Pigoya mapa taerepa agowapa agama abimagi maya yune: Aeba taga a'ya'ma marisa kina tau'ikena yagarawe, yune, untawe. ");
INSERT INTO for_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pigoya, Isu aeba igege tara yaga migaite Karariya mari wantiye. ");
INSERT INTO for_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Wantana aewaka mayamagina abintiye: Koti unti kamana yemi poropete yagarama ka'waina aeba aewa kuma agorapa ageba kampa waintiye, ute, ");
INSERT INTO for_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","pi mpaba atategina Karariya mari uma irosantiye. Piya, Karariya kina'miba kaga Yerusaremi kumati wama aota naninta nakena yagaba yoga pogini agantakini, a'wae pumagina uma irosaoginiba kayone potantawe. ");
INSERT INTO for_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Pigoya, Kena kumata Karariya mari paipa yogana waninkama wainiyena punti, pita'i to kake a'wae puma wantiye. Pi ntagaba Kapaniyamu kumata tabe yagara ka mintantiye. Pi ae yagara tabe inuntana abogana mintantiye. ");
INSERT INTO for_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pigoya, Isu aeba Yutiya maba atate a'wae puma Karariya mari to kake ampa irosaye, piya yuguna abite tabe yagara aeba Kena kumati Isuti wama yagarawa purikena pogana ampa kaba atanema, uma ababute kanakenaga omintiye. ");
INSERT INTO for_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Omogana, Isuba maya omintiye: Tigeba awame'enabe kasa'enabe agantiri kamana'nepa abima naegarasanaga napiyewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Piya yogana, kana yagara aeba: Wa'ega yagarane purisanagawa, karu'ena tumo, untiye. ");
INSERT INTO for_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Piya yogana, Isuba maya omintiye: Kaeba uwa tumo. Yagaragapa ago kabariye, omintiye. Piya omogana kana yagara aeba Isu kamana abibebe puritegina a'wae puma tumintiye. ");
INSERT INTO for_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tumogini kayokaya kina'wa ke'i kanamagini igeba: Yagaragapa ago kaba'ma mintiye, omintawe. ");
INSERT INTO for_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Piya yuguna, kabarome kanaka ibigaogini maya untawe: Aiba papa kagi abebe pogana pi kanabi yoninkapa atawaye, untawe. ");
INSERT INTO for_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Piya yuguna, kana yagara aeba agowapa mayama napintiye: Aiba pi kanabi Wa'ega aeba Yagaragapa ago kabariyeba unatama utamine, untiye. Piya yogini aewape aokinape Isuti aega'ma imatiti puntawe. ");
INSERT INTO for_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Piya puguna Isu aeba Yutiya marisa Karariya mari a'wae pumagina wama Kena kumata umima awame'ena puntita to kake uma pogana tara puntiye. ");
INSERT INTO for_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Pigoya, Yuta kina'mi aota naninta nakena yaga ka aboraogana, Isu aeba Yerusaremi kumati wamagina intiye. ");
INSERT INTO for_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Piya, Yerusaremi kuma agora sipisipiwama kabera kotupa ka waintantiye. Agewapa Yuta kina'mi kamanapisa: Petesitawe, yewe. Pi awamoriba ka kampa punta nama nayaka'mu kimaranta waintantiye. ");
INSERT INTO for_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Pi ntamapipa yoni kinape iyorika kinape igisa ataena punta kinape migugu kinape uwoma waintawe. ");
INSERT INTO for_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","(Piya puguna ka'isa yagaba Wa'egawamatisa enisore ka'waina kana kotupinti tumima airapa pogana kana waninkamaba aiga'yo'ya pogini agate, ka'waina karu'ena paitama tumpa pasomenapa yonintanawapa atawa puntiye.) ");
INSERT INTO for_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Pigoya, pita'i ka yagara nankitama miyogana kaboba 38 a'ya puwantiye. ");
INSERT INTO for_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Aibogana, Isu aeba uma agaomepa: Kana yagaraba e'ero kanabi waita miyaba'miye, yuguna abitegina, abigama: Kaeba kabarisanaga kabiyoma, abigantiye. ");
INSERT INTO for_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Piyama abigaogana, kana yoni ntagarama maya untiye: Wa'ega, waninkama aiga'yo'ya peginaba, ke naba pumagina mo nataka tumusuwe. Uwa naene uware ampa ware putagi, waogana pabigo ka'isa kina unagasima kotupintiba tumewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Piya yogana, Isuba maya omintiye: Kaeba asimagina wasagapa maerite wao, untiye. ");
INSERT INTO for_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Piya yogana, pabigo au'amaba aogi pogana asimagina wasa'wapa aesagabite wantiye. Aibogini, pi ntagaba Yuta kina'miba sabatira aogi potantawe. ");
INSERT INTO for_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Piya, aogi potaogini pi Yuta kina'mi kana yoni ntagara maya omintawe: Ibaba sabati akuninta yagawa, wasagapa a-mpaete wao, untawe. ");
INSERT INTO for_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Piya yuguna maya uwaimintiye: Kaba'ma aogi punatai ntagarama: Wasagapa aesagabite wao, unamima nagarubaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Piya yogini, igeba: Wasagapa aesagabite wao yemi ntagara, agewapa kewema, abigama untawe. ");
INSERT INTO for_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Piya yuguna, kana kabarome ntagaramaba kampa napintiye. Isu aeba a'ya'ma uwoma kina'mi nkibakapinti aigigipa'ma wagasogana, kampa aekaba napintiye. ");
INSERT INTO for_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pigoya, ainti Isuba tabe mono namapinti kana yagaraba abatamagina maya omintiye: Kaeba kaukapa aogi puwaya, pi to kake aguntaenaba a-po. Pegana tabe kuntuyena aboragamisanaga pasemagina miyo, omintiye. ");
INSERT INTO for_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Pigo kana yagara aeba Isupa agabebe potate wama Yuta kina maya uwaimintiye: Kaba natami ntagara agewapa Isuwe, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pigoya, Isu aeba sabatira piya yuga puntitaka Yuta kina'miba igobi pumagini kama potantawe. ");
INSERT INTO for_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Piya puguna, Isuba maya uwaimintiye: Nabanempaba yogaba a'ya'ma yagaba asi nasimagina piye. Piya, naeba pabiyamagi puwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pigoya, Isu aeba sabatiwai mpaema a'yugu puntana, Kotiti meto pumagina: Aeba nabanempawe, yomeka Yuta kina'miba abima kamparaga potamagini aegukena untawe. ");
INSERT INTO for_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Pigoya, Isuba maya kamana uwaimintiye: Naeba tagaka urimukuwa abiyo: Naeba yagarawa naene naumabisaba a'ya'waemaenaba kampa puwe. Nabanempa pegi yagarawampa naba agamagi ae pemisa pumagi puwe. ");
INSERT INTO for_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Naba aeba yagarawampanteka abugagina a'ya'waemaena pemintanaba nayakiwaeye. Piya, ibanto tabe yuga nayakeka pekiri, tigeba agama uwoma tigi napikibewe. ");
INSERT INTO for_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Naba aeba purinta kina ibage pumagina iyogawaitama miyaba'ena imika, yagarawa naene napima wasana miyaba'ena imuwe. ");
INSERT INTO for_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pigoya, naba aeba wasana antota kamanapa kampa uwaitaye. Pi ntugaba yagarawa nae unatantikini, ");
INSERT INTO for_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","wasanamiba nabanempa nkage maema asagayuyesa pumagini pabiyama yagarawa nae nageba maemagini asagayukibewe. Piya, ka'waina yagarawa nae nage maemagina kampa asagayukibi'naba aeba naba unatanti'na pabiyama age kampa asagayukiye. ");
INSERT INTO for_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Naeba tagaka urimukuwa abiyo: Ka'waina nae kamana wasintana, unatanti'naka amatiti pikibi ntagara, aepa miyaba'ena aboramekana kaintanama nkantotapa kampa maekiye. Piya yagaramaba purinta'enabisa aogamagina miyaba'ena ago maema amiye. ");
INSERT INTO for_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Naeba tagaka urimukuwa abiyo: Kanapa ka aborakiye. Pipa ibaba ago aboraye. Pi ntaga purinta kinapa Koti ntagara nae kamana abe kina iyogama asima miyaba'mikibewe. ");
INSERT INTO for_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Naba aeba miyaba'enama nkago ai'newane. Piya, yagarawa naepa pabiyama miyaba'enama nkago ai'newa unatantiye. ");
INSERT INTO for_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pigoya, Wasanama Ntagara mintoka, wasana antota kamana uwaitaoma unatantiye. ");
INSERT INTO for_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Pi kamana abiginaba kuntaba a-piyo. Kanapa ka atantipa waintiya, pi aborakiniba wasana irubinti waitamiye kinapa nae kiga'e abitegini irosa'ma ikibewe. ");
INSERT INTO for_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Piya puntini, aogima mintanta kina'miba miyaba'mikena iyogakibewe. Piya, kamparagama mintanta kina'miba kaintanama nkantota'ena maekena iyogamagini asikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Piya untana Isu to maya untiye: Nae'ne ntaumabisa yoga pikenaenaba kampa waintiye. Nabanempa nkawamuta antota kamanapa uma a'ya itauwe. Piya pumagi, antota yuga pekana ka awameta pikiye. Pipa nae'ne kamanapa kampaye. Unatanti'na ae kamana wasimagi tagaka uritauwe. ");
INSERT INTO for_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Piya, nae nabine agone umagi aborakanaba kampa aogi pikiye. ");
INSERT INTO for_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Nabanempa pi agonepa uma aborakiye. Piya, naeba abima pipa tagane. Aeba agonepa uma aborakini au'wapa agakibewe. ");
INSERT INTO for_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Tigeba Yoni abigauguna agonepa tagaka aborama urimintiye. ");
INSERT INTO for_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pigoya, wasanami agone uma aboraiyemaba pipa kampa yuwe. Ma kamana yopa abimagiri, miyaba kita aema miyigina Kotiba tibabenoma, yuwe. ");
INSERT INTO for_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Pi Yoni aeba kane kanta pumagina wasana e'wasa puwaitantiye. Pigoya, tintabaipintiba ti'muntanaba uwaenantora ae e'wasaenagaba puntawe. ");
INSERT INTO for_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pigoya, nae ago uma aborami, aeba Yoni piyamaba kampaye. Aeba to awametane. Naba yogara unatanti, pi ntugawama nkau'wa maema aboraoma, nabanempaba unatantegi tuminto, pi ntuga pogana unatanti agonepa aboraye. ");
INSERT INTO for_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Piya, naba unatanti'na pi aewa agonepa uma aborantiye. Tigeba pi ae'wa nkawamupisa kamanapa kampa abintiri, aowarapa kampa agantiri, ");
INSERT INTO for_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","unatanti'nante kamana a'a-o umagiri, kamana'wapa tigeba tigutapa kampa atagana waiye. ");
INSERT INTO for_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Piya, tigeba mono esapa aisumagiri: Miyaba'ena aboraramikenaga iyema, yewe. Pigoya pi paisa mono'amaba taga nae agoba uma aboraye. ");
INSERT INTO for_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Piya, tigeba naeti kanama miyaba'ena maeyiyoma, yogiripa uwa a'a-o yewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Piya, naeba wasanami i'muntana punataiyemaba kampa yuwe. ");
INSERT INTO for_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tige agoba pipa taga abuwe. Tigu'amaba Kotiti abemintanaba kampa waiye. ");
INSERT INTO for_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Naeba nabanempa nkawamuta tigetiba tumintogiripa, pipa tigeba uwa kayoneba kampa punatawe. Pigoya, ainti to kina'mi nkige'wai imabisa tigeti ampa irosaigiripa, pi kina igepa kayone puwaitakibewe. ");
INSERT INTO for_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tigeba ti'amaka ti'mu puma tabera maete iye kina'mitaba, ayama monotapa mikibewe. Pipa kampaye. Pigoya, Koti abiwa mpima a'ya'waemaenama tabe aeti a'muntana waintikaba pipa aeta tibiye, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tigeba naekaba: Aeba abawampati kamana uratakiyeba, a-siyo. Pipa kampaye. Tigeba tao'maekiyema napinta ntagara Mosese, ae kamanapa uritakiye. ");
INSERT INTO for_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mosese kamana kaentipa pipa naeka kaemarantine. Pigoya, tigeba ae kamana aogima abibebe pesinta, naekaba kaga abibebe pesine. ");
INSERT INTO for_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Piya, Mosese kamana awa'ena tigeba: A'a-o untiri, nae kamanapa ayama abibebe pikibewe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Isuba kamanapa uma a'ya atate, Karariya kotupa to ka agewapa Taibiriyasi ta'ema maroteri wamagina, ");
INSERT INTO for_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","3","abagi kina'wa iba purite wama amuti imagini mintantawe. Asu mintuguni uwoma kina yonintana kaba itaogini agantaka, aega'magini wantawe. ");
INSERT INTO for_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pigoya, pi ntagaba Yuta kina'mi Pasoba naninta nakena yagaba agarosantiye. ");
INSERT INTO for_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pigoya, Isuba ao ma'ma igaomepa pi wasana uwoma kina ampa irosauguna igate, Piripi mayama abigama untiye: Nanintaba aetasa ika pumagi pi kinapa imekana kanara sakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Aeba ka'ena pikenaga napimagina uwa amiyo kamana untiye. ");
INSERT INTO for_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Piya yogana Piripiba maya untiye: Taeba 200 torarasa naninta ika pumagi imekanaba kampa kanarasawaetakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Piya yogana, Saimoni Pita nka'nanto Enturu aeba maya untiye: ");
INSERT INTO for_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Mata'i ka yagarama aeba paretintoba nayaka'muna, inoyantaba tarawa sumagina urintiya, pipa ma uwoma kina'miba ayama kanarasawaetakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Piya yuguna Isuba maya untiye: Tigeba wasana uwaitaigini aki pumagini mara'miyiyo, untiye. Yogini, uwaimuguni, kabu aebaru'magini 5,000 waba mara'ya puma mintantawe. ");
INSERT INTO for_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mara'mintuguna, Isuba kana pareti maemagina Kotiti a'mu potama abagi kina imogini wasana pako pumagini a'ya'ma imintawe. Pigoya, inoyantaba pabiyama nakune igewai yume nkawameta imintiye. ");
INSERT INTO for_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Namagini iga'e pauguna Isuba abagi kina'wa maya uwaimintiye: Aritapa waima ataena pusanaga kitabiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Piya yogini igeba wa'nu kupa nagisarisa tara tumpaema ku kana naninta aritapa iraguguna awaitantiye. ");
INSERT INTO for_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Pigoya, wasanamiba pi awame'ena puwaiyakomentana agategini maya untawe: Tabe poropete yagara mabi aborakiyema untapa, mampaye, untawe. ");
INSERT INTO for_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Piya ute, igeba Isu kobe pumagini iyatasa araku'ma tabe yagarawai asitakena puguna, igabebe potategina itate ae abiwa amuti intiye. ");
INSERT INTO for_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Pigoya atamaisaogini abagi kina igeba kotu nkawamori tumimagini, ");
INSERT INTO for_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kapaniyamu kumati a'wae pumagini wakenaraka wanipisa karebi intawe. Pigoya ago ase yogana, Isuba pabita mintogini ibiwai wantawe. ");
INSERT INTO for_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Aibuguna, esegi punta pumagina tabera wanipa aiga'yo'ya pogini wantawe. ");
INSERT INTO for_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Piya, nayaka'muno, tonaentisa ka'umaema kiromita pubasanauguna, Isuba wani nka'eti aeta aeta wamagina kana wanipisa kare agora waogini agate pami puntawe. ");
INSERT INTO for_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Piya puguna igega'e umagina: Naene kanauwa, tiyekuruba a-piyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Piya yogini igeba i'mu pumagini, wanipisa karebi ababuguna iyogini wakena pume mpari agaro wantawe. ");
INSERT INTO for_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pigoya, marogini a'ya'ma kina kotu mparoteri mimagini maya untawe: Ai asekapa wanipisa kareba ka'waintoga agatompe, pipipa abagi kina'wapa Isupa atategini ibiwai imagini watawe, untawe. ");
INSERT INTO for_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Piya ute mintuguna, Taibiriyasi kumatisa wanipisa karebi kanama Wa'egawama naninta a'mu potama imintita ae aguyosagata ampa irosantawe. ");
INSERT INTO for_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pigoya, pi kina'miba Isu ae'wakabe abagi kina'wakabe iguyosakate wanipisa karebi ima Kapaniyamu kumati a'wae puma wama pita'i uma aguyosagantawe. ");
INSERT INTO for_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Pigoya, Kotu ma nkauka'i aguyosa'ma abatamagini: Tisa, kaeba ayantaga kanampenema, abigantawe. ");
INSERT INTO for_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Piyamagini abigauguna maya uwaimintiye: Naeba tagaka ukuwa, abiyo. Tigeba awame'ena pogiri agakaba pipa kampaye. Naninta timogiri namagiri tiga'e paka, naguyosagawe. ");
INSERT INTO for_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tigeba yogapepa, abararakena nanintawama ntuga wanane. Miyaba nanintawama ntuga piyo. Nabanempa Koti aeba Wasanama Ntagara naepa tigeti unatantika yigipa miyaba nanintaba timukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Piya yogini maya kamana a'wae pomintawe: Taeba ayamagi Koti ntugaba pusunema, abigauguna, ");
INSERT INTO for_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","maya uwaimintiye: Unatanti naeti timatiti puma naegaraigina, pi'na Koti ntugarintanaba peno, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Piya yogini maya kamana omintawe: Nana kukantana pega, agamagi kaega'ma tamatiti pugatakune. Nana aoso'enaba pikibene. ");
INSERT INTO for_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Piya, tayabamagiba ka'me mpari mana namagini mintantane. Pigoya pi kamana awa'enaba mayama waintiye: Mantabintisa naninta imogini namagini mintantawe, untawe. ");
INSERT INTO for_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Piya yuguna Isu maya uwaimintiye: Tagaka ukuwa abiyo. Moseseba mantarisa nanintaba kampa maema aborama imintiya, Koti imintiye. Piya, nabanempa mantarisa taga ntanintaba timiye. ");
INSERT INTO for_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Piya, Kotitisa tuminti'na taga ntanintaba mabisa kina'miti mikenaenaba maema aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Piya yogini: Wa'ega, kaeba yempe ntanintaba asi nasi pipa tamo, untawe. ");
INSERT INTO for_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Piya yuguna Isu maya uwaimintiye: E'wasa maekena nanintaba pipa naewe. Ka'waina aeba naeti ampa atokaekibi'naba, aepa nanintagaba aga'enaba kampa abukiye. Piya, ka'waina aeba naeti amatiti pikibi'naba wanikaba kampa abukiye. ");
INSERT INTO for_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Piya, naeba ago urimone. Awame'ena pogiripa agantiripa uwa kampa napimagiri aegarawe, ago yuwe. ");
INSERT INTO for_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pigoya, nabanempa namemi kina pi ige naetiba ampa irosakibewe. Pigoya, ka'waina aeba naeti ampa irosakapa aepa kampa agaikuwe. ");
INSERT INTO for_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Piya, mantarisa tumintopa pipa nae'ne nawamupisa kamana wasikenaba kampaye. Unatanti'na nkawamupisa kamana wasimagi aegarakena tumintone. ");
INSERT INTO for_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Piya, unatanti'na ae awamupisa kamanapa naeka mayamawe: Aeba naeti ibabuwaitanti kina'mi a'yugu pusanaga kabiwaitamagi, ainti tabe kanabipa ibage pekini iyogakibewe, unatanti'na ae awamupisa kamanapa piyama waintiye. ");
INSERT INTO for_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Pigoya ka'waina aeba yagarawa nae nagama amatiti punatakibipa, aeba a'ya'ma yagaba e'wasaenabi miyaba miyeka, ainti tabe kanabipa abage puma asitakuwe, nabanempa awamupisa kamanapa piyama waintegi wasiyuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pigoya Isu aeba: Mantarisa nanintaba naewe, yomeka, Yuta kina'miba abimagini ata potantawe. ");
INSERT INTO for_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Piya puntini maya untawe: Ma ntagaraba aeba Isu, Yosepe ntagarawe. Anoke abakeba pipa taeba isigaompene. Pipa nanaga: Naeba mantarisa tumintuweba, iye, untawe. ");
INSERT INTO for_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Piya yuguna Isuba maya uwaimima untiye: Tigeba uwoma kamanapa a-mpare-u me-u puta nasiyo. ");
INSERT INTO for_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Piya, wasana ka'waina ae'wa nkaumarasa naeti ampa irosakenaenaba pipa kampa waintiye. Naba unatantina paibekana ampa irosakenaenaga waintiye. Pigoya naeba piya yagara aepa ainti tabe kanabipa abage puma asitakuwe. ");
INSERT INTO for_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Pigoya, poropete kina'mi kamana awa'enaba mayama waintiye: Koti aewa wasana mono uwaimikiye, untawe. Pika ka'waina aepa nabanempa mono omima ayakekana abikibi'naba, aeba naeti ampa irosakiye. ");
INSERT INTO for_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pigoya, wasanama nkaobisa nabapa kampa agantipa, mantarisa tuminto, nae ka'wainana nabapa agama mintantone. ");
INSERT INTO for_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Naeba tagaka urimukuwa abiyo: Ka'waina aeba naeka amatiti puma naegarakibi'naba e'wasaena maema miyaba mikiye. ");
INSERT INTO for_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Pigoya miyaba nanintaba pipa naewe. ");
INSERT INTO for_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tiyabamagiba ka'me mpari mana namagini kampa miyaba mintantane. ");
INSERT INTO for_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pigoya, mantarisa naninta namagini kampa purikenaenaba pipa mampa naeti waintiye. ");
INSERT INTO for_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Piya, miyaba naninta mantarisa tumintipa pipa naenene. Pika ka'waina aeba naetisa naninta namaginaba asi nasi miyaba mikiye. Piya, nau'nempaba nanintarintana piye. Pipa mabisa kina tigeti miyaba mikena nau'nepa atakuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Piya yogini, Yuta kina'miba maka kamana umagini mare-u me-u puma maya untawe: Aeba ayamagina au'wapa tameka nakubompeka iye, untawe. ");
INSERT INTO for_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Piya yuguna Isuba maya uwaimintiye: Naeba tagaka urimukuwa, abiyo. Tigeba Wasanama Ntagara nae nauke korake kampa nakibepa, pipa tigupipa miyaba mikenaenaba kampa aborakiye. ");
INSERT INTO for_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ka'waina aeba nae nauke korake nakibi'naba asi nasi miyaba mikiye. Piya peka naeba aepa ainti tabe kanabipa abage puma asitakuwe. ");
INSERT INTO for_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Piya, nae naupa pipa taga ntanintawe. Piya, korantepa pipa taga wanine. ");
INSERT INTO for_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Pigoya nae nauke korake nakibi'naba aeba nae nagora atokaema miyeka naeba pabiyama aege atokaema mikuwe. ");
INSERT INTO for_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Naba aeba miyaba'enama nkagowampa unataoga tumintoka, aeka umagi miyaba miyokana aeba nae nakibi'naba pabiyamagina naeka uma miyaba mikiye. ");
INSERT INTO for_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Pigoya, tiyabamagi igeba mana nagaiteginiba ago purintasa puma wanane. We, nae naninta nakibi'naba pipa asi nasima esegima miyaba mikiye. Piya, mantarisa nanintawama nkagoba piyama mintuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Isu aeba pi kamanapa Kapaniyamu kumata mono namapi ampimagina uwaimiwaentiye. ");
INSERT INTO for_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pigoya, abagi kina igetisa uwoma kina'mi pi kamana abite maya untawe: Ma kamana abokanaba kunta piya, pipa kebaya abikiye, a, untawe. ");
INSERT INTO for_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Piya umagini, iyekita kamana yuguna antabaipinti Isuba abite maya uwaimintiye: Kamana pipa abeganaba nanaga kuntaba piye. ");
INSERT INTO for_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wasanama Ntagara naeba pai mintantoti a'wae pumagi iyekiripa agaiginaba a'ya pikiye. ");
INSERT INTO for_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pigoya, tau'ama wanane. Awamusa'ama mikenaenaba wasanaba aboromagina tamiye. Pi nae urimo kamanapa pipa auma wantaga miyaba'ena wantagane. ");
INSERT INTO for_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pigoya tigetisa ka'isa kina'miba pika kampa aogimagini abewe, untiye. Pigoya, Isu aeba monowa a'a-o ikibe kina igekaba ago pai abiwaentiye. Piya, kuna pikibi aepe kaga abibebe punti, pika uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pigoya, kamana ka mayama amato puma untiye: Naeba pika maya ago urimuwe: Ka'waina aeba nabanempa kampa ase'yo potantakana, naeti ampa irosa'ma mikenaenaba kampa waintiye, ago urimuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pigoya, pi ntaga abagi kina'wampitisa uwoma kina'miba Isupa iyekita puma atate a'wae puma wantini, to kake kampa nasi nasi puntawe. ");
INSERT INTO for_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Pigoya, Isuba agorasa nagisarisa tara tumpaema kina'wa ibigama maya untiye: Tigeba pabiyama tikabinatakenaga yewo, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Piya yogana Saimoni Pita maya omintiye: Wa'ega, kae katateba kapa keti wakune. Kae ka'wainaga a'ya'ma yaga miyaba kamana urintane. ");
INSERT INTO for_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Taeba kaeti tamatiti pumagi: Kaeba Kotitisa aota yagaragawema, abuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Piya yogana Isuba maya uwaimintiye: Naeba nagisarisa tara tumpaema kina tibabunto, tigetisa ka'wainaba nanaga ke kina'enaba piye, untiye. ");
INSERT INTO for_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Piya, aeba Yutasi, Saimoni ntagara Isikeriyoti kumatasa, aeka napimagina piya untiye: Aeba abagi kina, nagisarisa tara tumpaema kina, ige aruyenabisa mintana aintiba Isu kuna puntiye. ");
INSERT INTO for_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Pigoya, Yerusaremi kumatasa Yuta kina'miba Isu aegukena kamana yuguna Yutiya mawaipa atategina Karariya marimana nasi nasi puma mintantiye. ");
INSERT INTO for_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Piyama mintogana, Yuta kina'mi seri nama kima'ma naninta nanta aota yaga agarosantiye. ");
INSERT INTO for_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aibogini, a'natabaramiba maya omintawe: Kaeba ase'yo pumagina mampa atate Yutiya mari wama mata'i kukantana pempesa puma maroti uma pegini kaokina'miba agaiyo. ");
INSERT INTO for_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Piya, ka'waina aborakena untanaba aeba kampa kakama mima yogaba pikiye. Pipa kampaye. Kaeba piya yuga pikenaga yempeka wama a'ya'ma kina'mi nkaruyenabi aborama pegini agaiyo, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Piya, a'natabara igeba aetiba kampa abima imatiti puntini piya untawe. ");
INSERT INTO for_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Piya yuguna Isuba maya uwaimintiye: Tigeba a'ya'ma yaga pikena puntiripa kanara pikibewe. We, naeba pipa kana'nepa ibaba kampa aborantiye. ");
INSERT INTO for_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mampabisa kina'miba tigepa kampa karana puritakibekini, nae karana punatakibewe. Naeba pipa mikenaenawai kamparagaena wainti, pika uma aboraogini igobipa punatawe. ");
INSERT INTO for_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tigeba aota yagaba waiyo. Naeba pipa kana'nepa kampa aborantika, ma aota yagaba kampa wakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aeba piya ute, Karariya mariba mintantiye. ");
INSERT INTO for_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Pigoya, a'natabara igeba aota yaga uma agakena paitama wagasuguna, aeba ainti pasemagina wantiye. ");
INSERT INTO for_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pigoya, aota yaga aboraoginiba, Yuta kina paitawaitamagini miyume kina'miba aguyosagantini ibigama maya untawe: Pi ntagaraba aeba aeta mintiye, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Piya, a'ya'ma kina'miba aekaba uwoma kamana uma mare-u me-u puntawe. Piya puntini ka'isa kina'miba: Aeba aogi yagarawe, yuguni to ka'isa kina'miba akayuwaitamagini: Kampaye. Aeba wasanami nkimawama maema a'yugu puwaigasaye, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pigoya, pipa Yuta kina'mika iyekuru pumagini aboramaba kamanapa kampa untawe. ");
INSERT INTO for_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pigoya, aota yagaba abakapi Isuba tabe mono namapipa imagina wasanaba kamanapa uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mono yogini, Yuta kina'miba uwoma nkigi napimagini maya untawe: Ma ntagaraba ayamagina awa'ena aisiye: Aeba awa'ena namapipa kampa mintanti'nawe, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Piya yuguna Isuba maya uwaimintiye: Naeba mono urimopa, pipa nae'nentaba kampaye. Pipa unatanti'na, ae mono urimuwe. ");
INSERT INTO for_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Piya, ma yo mponopa Kotitisabe nae'netisabayaya, pipa Koti nkawamu wasikena ibugai kina'mi abibebe pikibewe. ");
INSERT INTO for_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Piya, ka'waina aeba aewaka napimagina ikibipa, aeba au maete ima kamana ikiye. Piya, ka'waina aeba yoga agowama nkage maete ima a'mu potakibi, pi aeba kampari yagaraba kampaye. Aeba taga ntagarawe, yiyo. ");
INSERT INTO for_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Pigoya, Mosese ago kamana uma aborarimintipa, pipa tigetisa ke kapa wasiwaeye. Kampaye. We, ayagabaya naepa naegukenaba yewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Piya yogini, uwa kina'miba maya untawe: Ke kina ka'waina kaege mintegina a'yugu kamana yena, kae kaegukena kinapa kapa kampa mintawe, piya untawe: ");
INSERT INTO for_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Piya yuguna Isuba maya uwaimintiye: Naeba mata'i kukantanaba ka'anto puntone. Pikaba tigeba nanaga urite taberapa wagana pewe, a. ");
INSERT INTO for_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Naeba yekiri abiyo: Moseseba: Yagarari ita ara'ena piyoma, uritantine. We, Moseseba pipa kampa agobintine. Tiyabamagi pai agobintane. Pigoya, i kasakena yuga yagaba sabatira aboragiripa pi ntagageba pewe. ");
INSERT INTO for_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Pigoya pimpa Mosese ago kamana aemita pigina, au'wa kampa aborasanaga yagararimpigi ipa kasakena yugaba pipa pewe. We, naeba pipa ka yagara aogima au'ama kaba atanto, pikaba nanaga abima ataba punatawe, a. ");
INSERT INTO for_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Tigeba nanaga agarompa kamana ariwapa yewe, a. Agowapa napibebe pumagiri kamana au'wapa yigina aogi pusanawe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Pigoya, Yerusaremi kuma ago kina ka'isa igeba Isuka maya untawe: Aegukena ye ntagaraba pipa mampaya, agaiyo. ");
INSERT INTO for_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aeba kamana aboraginiba igeba kamanapa kapa kampa otawe. Kiya kina'miba igeba ma kanabipa: Utaratanti ntagara Karaisitiwema, abintini uwa atawa, a. ");
INSERT INTO for_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","We, taeba kuma agowapa abintune. Pigoya pi ntaga Karaisiti ampa aborakibipa, pipa ka yagaramaba kuma agowapa kampa napikiye. Pipa ayabayawe, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pigoya, Isu aeba tabe mono namapi mono uma mintogini, piya yuguna kega'e uma maya untiye: We tigeba abibebe pumagiri aborantona, agonepa ago abewe. Tumintopa pipa napiyenanepisaba kampa tumintone. Unatanti ntagara aeba taga ntagaragana unataoga tumintone. Tigeba aekaba kampa napima abewe. ");
INSERT INTO for_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Piya, naeba ae agorasa unataoga tumintoka aeka abibebe puntuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Piya yogini, igana namapi ababotakena untawe. Pigoya kana'wapa kampa puntogini iyankamaba kunta pogini atantawe. ");
INSERT INTO for_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pigoya, wabe wayape uwoma kina'mi aega'ma imatiti puntini maya untawe: Karaisiti ampa aborakibi ntagaba, pipa uwoma kukantanaba pumagina ma ntagarama kukantanaba kampa asugasima pikibayawe. We, pi ntagaraba Karaisitibayawema, napiyune, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Pigoya, a'ya'ma kina'miba Isukaba toma toma kamana yuguni, Parasi kina'miba abitegini tabe mono kiye kina Parasi kina'miba ka'isa monota kabinta kina uwaitauguni kanama iga'na ampa utikena kanantawe. ");
INSERT INTO for_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Piya puguna Isuba maya uwaimintiye: Naeba uwaena yaganto tigege migaite, unataoga kananto ntagara aeti a'wae pumagi wakuwe. ");
INSERT INTO for_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Piya, tigeba naguyosakagate kampa nabatakibewe. Wama umikubotiba pipa kampa, wakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Piya yogini, Yuta kina'mi igeba maya uma mare-u me-u puntawe: Aeba aeta waka aguyosakubompeka iye. Yuta taokina to mari mirite wa kina, igeti wakenaga ibera, to marisa kina mono uwaimikena napintana iye. ");
INSERT INTO for_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","We: naguyosa'ma kampa nabatakibewe, piya uma umikubotiba, pita'iba kanara kampa wakibewe, piya kamanapa ayaga iye, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Pigoya, Yuta kina'mi aota naninta nakena yaga mima a'ya pikena puntini tabe aruyena pumagini mintuguna, Isuba asima mima kega'e uma maya uwaimintiye: Ka'waina wanika abekanaba naeti kanama ampa nano. ");
INSERT INTO for_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Piya: Ka'waina aeba naeti amatiti pumagina mikibipa, ae agupisaba wani nkaba aiyese pemisa puma e'wasa wani pagi kiye, mono isapapa piya kamana kaemarantane, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Pigoya, Awamusa'amaka Isuti imatiti punta kina'mi maekibeka Isu untiye: Piya, aeba pi ntagaba manta e'wasaenawampa agupintiba kampa intika, Awamusapa kampa tumintiye. ");
INSERT INTO for_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Pigoya, wasanamiba pi kamana abitegini Isuka maya untawe: Aeba taga tabe poropete yagararene, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Piya yuguni ka'isa kina'miba: Aeba taga Karaisitiwe, untawe. Piya yuguni to ka'isa kina'miba akayuma maya untawe: Pipa Karaisiti aeba ayama Karariya marisaba aborakiye. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mono isapipa kamana maya untane: Karaisiti aeba Tebiti kuma ago Petariyamu, pita'i ae aokina'mi ige abakapisa aborakiyema, iye, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Wasanamiba Isukaba piya umagini atatara puma tara aruyena puntawe. ");
INSERT INTO for_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Pigoya ka'isa kina'miba iga'na utikena pumepa iyankama kunta pogini atantawe. ");
INSERT INTO for_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pigoya, monota kabiyume kina'miba tabe mono kiye kina Parasi kina igeti a'wae puma wauguni ibiyama maya untawe: Tigeba nanaga kampa araku'ma ababute kanawema ibigauguni, ");
INSERT INTO for_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","irebu kina igeba: Aeba kamana yemipa, ka'isa kina'mi yesapa kampa iye, untawe. ");
INSERT INTO for_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Piya yuguni Parasi kina igeba maya uwaimintawe: Pi tigepa pabiyama timaba a'yugu purigasaye, a. ");
INSERT INTO for_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tabe Yuta kiye kina Parasi kina taetisaba ka'waina aega'ma atokaeya, a. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Uwa kina ago kamana kampa abima miye kina, pi ige Koti nkaobi ataenaba pewe untawe. ");
INSERT INTO for_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Piya yuguna, iyo'yagara ka, agewapa Nikotimasi, pai Isu uma aganti ntagara, aeba maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Tigeba yiyo, Ka yagarama nkagowa kampa abinta kaintanawa kampa aganta, antota kamana uma a'ya atakenaba, ago kamanatepipa kapa waintiya, a. Pipa kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Piya yogini, aokina'miba maya untawe: Pigoya kaeba uwa marisa, Karariya marisawa, a. Pipa kaeba ago kamanapa aisuma aogima agao. Karariya marisa poropete aborakenaena kampa waintiye, untawe. ");
INSERT INTO for_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","(Pigoya, igeba atate namankaiti wagana puwaeyuguna, Isu aeba Oribesi amuti intiye. ");
INSERT INTO for_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Marogana pita'isa a'wae pumagina tabe mono namapinti iyogini wasanaba uwoma kina'mi aeti tabera ampa aki puntawe. Piya puguna pita'i mara'mima mono uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Piya pogini mono tisa kinape Parasi kina'mibe igeba ka wae kupiyona pogini abatamagini Isuti ababute wama wasana ibakapi me atama, ");
INSERT INTO for_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Isupa maya omima untawe: Ma nkwaepa kupiyona pegi agama ababute kanaune. ");
INSERT INTO for_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Pigoya, Moseseba piya waepa yaba kasutasa aeguma kaiyiyoma, ago kamanapipa uratantiye. Kaeba aekaba ayama napiyene, untawe. ");
INSERT INTO for_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Pipa uwa amiyo pumagini ka kamana aborama yekiniba kamana otakena untawe. Pigoya, piya yuguna Isu aeba mabi parokaema ayatasa awa'ena kaentiye. ");
INSERT INTO for_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kaeyogini to abiga abiga puguna asagayuma maya uwaimintiye: Tigetisa ka'waina aguntaenawa kampa wainta miyemi'na agobimagina yaba kasupa aeguyekiri aeguyiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Piya utegina to kake parokaemagina mara kaentiye. ");
INSERT INTO for_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Piya pogini igeba kamana'wa abitegini kiya kina maru paitama wagasuguni to ka'isa kinapa wama wama a'ya wantawe. Piya puguna kana wae aeba abintowa mintantiye. ");
INSERT INTO for_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Aibogana, Isuba asagayuma agama abigama untiye: Kamana ugata kinapa igeba aetane. Igeba antota kamanapa kapa kampa ugatawa, a, untiye. Piya yogana kana wae'maba: Wa'ega pipa kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Piya yogana Isu maya omintiye: Pigoya, naegeba antota kamanapa kampa ugatauwa, kaeba uwa wama mimagina aguntaenaba to kake a-po, piyama omintiye.) ");
INSERT INTO for_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Pigoya, Isuba wasana kamana to kake amato pumagina maya uwaimintiye: Naeba a'ya'ma mabisa kina'miti e'wasaenawe. Piya, ka'waina aeba nae naegarakibi'naba tununtanabipa kampa wama mikiye. Aeba miyaba e'wasaenawa waitantakana mikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Piya yogini Parasi kina'mi maya omintawe: Mapa kaeka nkago umagina aborane. Pipa abokanaba tagantanaba kampa piye, untawe. ");
INSERT INTO for_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Piya yuguna Isuba maya uwaimintiye: We, nae'ne kamana, kanara suwe. Kamana'nepa pipa tagane. Piya, naeba asima kananto kumapa abinta, wakena kumapa abinta puntuwe. Pigoya tigeba kuma agonepa kampa abintawe. Aetapaya wakubo, pipa pabiyama tigeba kampa abintawe. ");
INSERT INTO for_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Tigeba a'yiginkitakena yuga pepa, uwa mampabisaenaga napima pewe. Naeba piya yugaba kampa puwe. ");
INSERT INTO for_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","We, a'yiginkitakena puntapa, naeba tagantanaba puwe. Naeba pi ntugaba nabintone pikenaenaba kampa waintiye. Naba unatanti'na ae nao'maeyaka pikenaenara waintiye. ");
INSERT INTO for_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Pigoya, ago kamanatipipa mayama waintiye: Tara yagararamisi ka kamana yisigiripa, tagane yiyo, iye. ");
INSERT INTO for_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pigoya naeba agone uma aboraoganaba, naba unatanti aebe pabiyama uma aboraye, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Kamana piya uwaimogini: Kabagampaba aempa mintiyema, abigauguna maya uwaimintiye: Tigeba naeka kampa abibebe puntiripa nabanempakaba pabiyama kampa abibebe pikibewe. Naekaba abima napibebe pesinta, nabanempakaba pabiyama napibebe pesine, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Pigoya Isu aeba tabe mono nama mone ataume ntabaewama nkagora mima kana kamanapa untiye. Pigoya kana'wapa kampa aborantogini kampa iga'na utintawe. ");
INSERT INTO for_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Pigoya Isuba to kake maya uwaimintiye: Titate wakiripa tigeba naguyosakate aguntaenarintaga mima purikibewe. Nae wama umikubotiba ayama wakibewe. Pipa kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Piya yogini Yuta kina'miba igeba maya untawe: Naeba wama umikubotiba ayamagiri wakibeweba, piyaba nanaga iye. Ae'wa aeguma kaikenaga yibera nanaga iye, untawe. ");
INSERT INTO for_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Piya yuguna Isuba maya uwaimintiye: Tigeba abetisawa naeba atisawe. Tigeba mabisawa, naeba mampabisaba kampaye. ");
INSERT INTO for_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pika naeba urimuwe: Tigeba aguntaenarintaga mima purikibewe. Nagawa pe ntagara naeka kampa napibebe puntiri, aguntaenarintaga mima purikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Piya yogini: Kaeba taga kegawema, abigantawe. Abigauguna. Isu maya uwaimintiye: Ma nae pabi ntagaramana, paipa urimintone. ");
INSERT INTO for_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Naeba tige aguntaena kaintana kamanatipa uwoma maema miyuwe. Unatanti'na aeba taga kamana siye, pigoya naeba awamupisa abintoka pabiyama mata'i mabipa uma aborauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Piya, abawampaka piya uwaimogini igeba kampa aogimagini abibebe puntawe. ");
INSERT INTO for_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Pika Isuba amato puma maya uwaimintiye: Ainti Wasanama Ntagara naepa naegumagiri nasagayukibe ntagaba abibebe pikibewe. Pigoya nae naumanepisaba a'ya'waemaenaba kampa puwe. Nabanempa unaminti, pabi kamana yuwe. ");
INSERT INTO for_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Unatanti'naba aeba naege miye. Naeba a'ya'ma yagaba a'ya'waemaena poganaba abegina aogi pegini naepa kampa nagasawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Piya yogini, uwoma kina'mi imatiti pumagini aegarantawe. ");
INSERT INTO for_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Pigoya aeti imatiti pumagini aegaranta Yuta kina maya uwaimintiye: Tigeba nae nawamu wasima mimagiri nabagi kina'nentana pikibewe. ");
INSERT INTO for_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Pigoya, nae taga kamana'ama nkiga'naba iyobatitakiri kanara uwa mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Piya yogini igeba maya kamana a'wae pomintawe: Taeba Abara'amu nkaga'nura mima uwa mintune. Ke kapa kayokaya kina'wapa tababuma iga'naba ubutatantika kaeba: Iga'nara kampa mikibeweba, yene, untawe. ");
INSERT INTO for_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Piya yuguna Isuba maya uwaimintiye: Naeba tagaka urimukuwa abiyo. Ka'waina aeba aguntaena pi'naba aguntaenama kayokaya'ena piye. ");
INSERT INTO for_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Piya, kayokaya yagaramaba tabe yagarawampa ntama kumatiba asi nasimaba kampa miye. Ae'wa ntagara tubama abawampa ntama kumatiba asi nasimaba uwa miyabapa miye. ");
INSERT INTO for_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pika tigepa Koti ntagara tuba nae kanara iga'na iyobatitakiri uwa mikibewe, yuwe. ");
INSERT INTO for_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Piya, Tigeba Abara'amu aga'nurawa, pipa naeba abintuwe. Pigoya, tigeba pipa kamana'nempaba tigetiba asesepagiri naegukenaga yewe. ");
INSERT INTO for_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Naeba nabanempatisa kamana abinto pabi suwe. Piya, tigeba tibarimpatisa abintasa suma yewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Piya yogini igeba: Tae tabarempaba Abara'amuwe, untawe. Piya yuguna Isuba maya uwaimintiye: Tigeba Abara'amu nkaga'nubara taga mintasinta, ae puntemisa pesine. ");
INSERT INTO for_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Piya, Kotitisa taga kamana abinto pi urimuwe. Piya yogiripa tigeba naegukenaga yewe. Pintanaba Abara'amuba kampa puntine. ");
INSERT INTO for_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Pika tigeba tibarimpa pemisantana pewe, untiye. Piya yogini igeba maya untawe: Taeba ke'isa kampa aborantompene. Koti aeba tabarempa ka'antowe, untawe. ");
INSERT INTO for_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Piya yuguna Isu maya uwaimintiye: Koti nkaga'nubara mintasinta naepa kayone punatasine. Naeba Kotitisa tumintone. We, nae'ne ntaumabisaba kampa tumintone. Ae unataoga tumintone. ");
INSERT INTO for_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ayamagiri miyegana kamana'nempaba tigutapa kampa waiye, a. Nae kamana yogiripa, nae kamanaka kampa tibegiri: Kampa abukune, yewe. ");
INSERT INTO for_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Tige tibarimpaba kewamawe. Piya, ae abugaintana tige pikenagaba napiyewe. Aeba pai wasana iyeguma ataena puwaitama mintanti'na mirite kanaye. Aeba taga kamanapa akabitantika agupipa taga kamanapa kapa kampa waintiye. Aeba kumpari kamana'wampaba nakenawantana piye. Aeba kumpari yagaragana kumpariyenama nkaba mintiye. ");
INSERT INTO for_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Piya, naeba kumpari kamana urimosinta abesine. We, taga kamana urimogiripa a'a-o uma kampa abewe. ");
INSERT INTO for_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tigeba nae kaintanaga ka unatakibewa, a. Pipa kampaye. Pigoya naeba pi nkawameta taga kamana ai'newa urimogiripa nanaga kampa abibebe pewe. ");
INSERT INTO for_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pigoya ka'waina aeba Kotitiga aboranti'naba kamana'wapa abiwaeye. Tigeba Koti ntagaraba kampa mintiri, kamana'wapa kampa abimagiri aegarawe, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Piya yogini, Yuta kina'miba maya kamana a'wae pomintawe: Taeba kaekaba mayawe yune: Kaeba Sameriya yagaragagana, ke kina kantabaipi mintiye. Pipa taeba napiyompepa tagane, untawe. ");
INSERT INTO for_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Piya yuguna Isu maya uwaimintiye: Ke kinapa nae nantabaipintiba kampa mintiye. Naeba nabanempa nkage maema asaga'yuyogiri, tigeba pipa nae nageba maemagiri meru nkaba pewe. ");
INSERT INTO for_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Naeba nagene maema asaga'yukena yugaba kampa puwe. Ka yagara mintikana ae nagenepa uma asaga'yuyi'na, pipa Koti, aeba antota'enaba pikiye. ");
INSERT INTO for_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Naeba tagaka urimukuwa abiyo: Ka'waina aeba nae kamana wasikibi'napa purikenaenaba kapa kampa aboramikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Piya yogini Yuta kina'miba maya untawe: We, ibaba abune. Ke kinapa kae kantabaipi mintiye. Piya, Abara'amuba pu'wantegini, poropete kina igeba kaga pu'wantane. Aibuntagana kaeba mayawe yene: Ka'waina aeba nae kamana maema mikibi'napa purikenaenaba kapa kampa aboramikiye, yene. ");
INSERT INTO for_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","We, tayabama Abara'amuba aeba tabe yagara pu'wanti, ae asugaikenaga yeno. Pigoya, poropete kinapa igeba pabiyama pu'wantana, kaeba ayama taberapa kaupa maete iyene, a, untawe. ");
INSERT INTO for_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Piya yuguna Isuba maya uwaimintiye: Naeba nau maete iyekanaba kampa kanarasakiye. Nabanempa minti aeba Kotirene omena, pi ae nagenepa maema asaga'yuye. ");
INSERT INTO for_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Tigeba aekaba kampa napimagiri aegarawe. Naeba pi napima abibebe puntuwe. Piya, naeba ayama: Kampa agama abintuweba, ukuwe. Piya ukubopa tige awameta kumpari yagara kanta pukuwe. Kampaya, naeba aepa agama abibebe pumagi kamana'wapa wasiyuwe. ");
INSERT INTO for_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tiyabama Abara'amu aeba kana'ne aborakana agakenagaba tabera a'mu puma mintogana, ainti aboraogana agama a'mu puntine, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Piya yogini, Yuta kina'miba maya omintawe: Kaeba kabogapa 50-ba kampa puntampe'nagaba, ayamagina Abara'amupa agampesine, untawe. ");
INSERT INTO for_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Piya yuguna Isuba maya uwaimintiye: Naeba tagaka urimuwa, abiyo: Abara'amuba kampa aborantoga mintantone, untiye. ");
INSERT INTO for_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Piya yogini yaba kasu mpaemagini aegukena puguna, Isu aeba iyora kakamagina tabe mono namapintisa iro'wantiye. ");
INSERT INTO for_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Pigoya, Isu aeba ke'i wantana ano nkantabaipintisa aorika yagara aboranta, ae uma abatanitye. ");
INSERT INTO for_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Piya pogini, abagi kina'miba igeba abigama maya untawe: Tisa, ke aguntaenaba pogana aorikapa aboranti, aewapera anoge abage isigewema, abigantawe. ");
INSERT INTO for_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Piyama abigauguna Isuba maya uwaimintiye: Pipa kampaye. Aewa kaintanarakabe anoke abake kaintanarakabe kampaye. Koti nkesegiyenama ago aeti aborakibika pabiya yagara aborantine. ");
INSERT INTO for_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Taeba unatanti'na ntugaba ara pumagi miyeno. Ase yekanaba pabigo a'ya puwakiye. ");
INSERT INTO for_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Naeba mabi miyo kanabipa naeba mampabi e'wasa puritauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Piya ute, mabi kaisa puma ma'magi pumagina, kana aorika yagarama nkaora pai'atantana, ");
INSERT INTO for_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","maya omima otantiye: Kaeba wamagina Sairomu kotupi uma kaukapa wani nkaeyo, untiye. Pigoya Sairomu pi nkageba kamanatepisaba: Otanti mpariwe, yune. Piyama omogana pigo kana yagara aebawamagina autisa uma wani nkaeyogana aoba apina'magina agantiye. Piya purite a'wae puma kanaogini, ");
INSERT INTO for_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","aokina'mibe nanintaga esuwaitama mintanti kina'mibe igeba kaga agategini maya untawe: Pipa mara'mima nanintaga esurata pemi ntagara aebayaye, untawe. ");
INSERT INTO for_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Piya yuguni, ka'isa kina'miba: Aeba pimpaye, yuguni, to ka'isa kina'miba: Kampaya, pipa ae kanta yagara yagarawe, untawe. Aiyuguna, aewapa: Mapa naewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Piya yogini igeba abigamagini maya untawe: Ayamagina kaoba aganema, abigauguna, ");
INSERT INTO for_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","aeba maya uwaimintiye: Ka yagara agewapa Isu, ae ma maemagina au akae'magina naora pai'natama maya unamintiye: Kaeba Sairomu kotuti wamagina paso, unamegi naeba wama uma pai'ma naoba agauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Piya yogini igeba: Kana yagara aeba aeta mintiye, untawe. Piya yuguna aeba: Naeba kampa abintuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Aiyogini, kana aorika yagara Parasi kina'miti ababute wantawe. ");
INSERT INTO for_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pigoya kana aorika yagara Isu au kae'magina aora pai'ataogana aogatantipa, sabatira puntiye. ");
INSERT INTO for_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Piya, Parasi kina igeba to kakema abigama maya untawe: Kaeba aya pumagina kaoba agane, yuguna, aeba: Naonepa marasa pai'atagi naeba wama wani pai'magi nao agauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Piya yogini Parasi kina'mitisa ka'isa kina'mi maya untawe: Kana yagara aeba Kotiba kampa otagina kanantana sabatiwamapa kampa aegaraye, untawe. Piya yuguni to ka'isa kina'miba maya untawe: Aeba agunta yagara mintanaba maya awame'enaba ayamagina pemisine, untawe. Piya utegini atatara pumagini tara aruyena puntawe. ");
INSERT INTO for_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Piya puntini kana aorika yagara to abigama maya untawe: Kao agagatami, aekaba kaeba ayawe yenema, abigauguna, maya untiye: Aeba poropete yagarawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pigoya: kana yagara aeba taga aorika mimagina aogaye, yuguni, ka'isa Yuta kina'miba igu'ama tara tara pumagini anoke abakega isigega'e umagini, ");
INSERT INTO for_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","mayama isibigama untawe: Yagararisi aorika aborantiye yemepa mampayo. Aeba ayamagina aoba agayema, isibigaugunisi, ");
INSERT INTO for_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","anoge abage isigeba maya untase: Aeba yagararesikara, pipa abintuse. Piya aorika aboranti, pikeba abintuse. ");
INSERT INTO for_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pipa ayamabaya aoba agaya, pigo kebaya aoba agataya, pipa kampa abintuse. Aeba anasa kinana, pi ae'wa abigaigina agowapa urimeno, untase. ");
INSERT INTO for_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Pipa Yuta kina'mika isiyekuru pumaginisi piya untase. Pigoya Yuta kina'miba maya kamana umagini nikintawe: Ka yagarama Isuka taga Karaisitiwe yekiripa mono namapisaba agarubaiyo, untawe. ");
INSERT INTO for_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pika anoge abageba isiyekuru pumaginisi: Aeba anasa kinana, ae'wa abigaiyo, untase. ");
INSERT INTO for_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Piya yusuguni kana aorika yagara to kake agega'e umagini maya omintawe: Kaeba Koti nkage maema asaga'yuma yo. Taeba yompepa, ma kana yagaraba aeba agunta yagarawa, ae age a-nkasaga'yuyo, untawe. ");
INSERT INTO for_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Piya yuguna aeba maya uwaimintiye: Aeba agunta yagarawo, pipa kampa abintuwe. Pigoya naeba naorika mintanto'nana nao agaopa, pipa abibebe puntuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Piya yogini to kake atesuma abigantawe: Nana pugataye. Aya pumagina kaoba agagatayema, abigantawe. ");
INSERT INTO for_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Piya yuguna aeba maya uwaimintiye: Naeba ago urimopa, tigeba pipa kampa abewe. Nanaga abara kamanapa urimekiri abikenaga yewe. Tigeba ae abagi kina'ena pikenaga yewa, a, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Piya yogini aomana sumagini maya untawe: Pi abagi yagaraba kaewe. Taeba Mosese nkabagi kinatawe. ");
INSERT INTO for_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mosese Koti kamana ominti, pi abune. Pigoya pi ntagaraba aetasabaya aborama kananti, pipa kampa abintune, untawe. ");
INSERT INTO for_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Piya yuguna kana yagaramaba maya kamana a'wae puwaimintiye: We, pipa pami puntanawe. Nao aganatai ntagaraga aeba aetasabaya aborantiye ye ntagarama naoba aganataye. ");
INSERT INTO for_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Taeba mayama abune, Kotiba agunta kina'mi kamanapa kampa abiye. Piya, ka'waina aeba Koti kamana abima aega'ma awamu wasiyi'na Kotiba abima ao'maeye. ");
INSERT INTO for_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","We, paipa ka yagarama aorika yagara aogatanti kamanapa, ma aborantistasaba kapa kampa abirite kanantompene. ");
INSERT INTO for_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Piya, ma kana yagara aeba Kotitisa kampa tumintemisinta, piya yugaba ayamagina pemisine, uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Piya uwaimogini kana aorika yagara maya omintawe: Kanogampaba taga agunta yagara yakari pugatanti'naga, tae mono uramikenaga yeno, ute apasana'ma agarubantawe. ");
INSERT INTO for_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pigoya, apasana'ma agarubauguna Isuba abintiye. Piya puntana kana yagara abatama mayama, abigama untiye: Kaeba Wasanama Ntagaraba aega'ma kamatiti penoma, abigantiye. ");
INSERT INTO for_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Abigaogana kana yagara aeba maya untiye: Wa'ega, kaeba yempepa aeba kewe. Nayakega agabebe pumagi aega'ma namatiti peno, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Piya yogana Isu maya omintiye: Pigoya kaeba agao. Kamana ugamopa, pipa naewe, omintiye. ");
INSERT INTO for_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Piya omogana kana yagarama maya untiye: Wa'ega, naeba kaega'magi namatiti pugatauwe, utegina agisabi uma parokaentiye. ");
INSERT INTO for_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Piya pogana Isuba maya omintiye: Naeba mabi wasana a'yiginkitakena tumintone. Pika iyorika kina'miba iyo agaigini, iyoyaga kina'mipa iyorikaekibe, pi ntuga pukena tumintone, untiye. ");
INSERT INTO for_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Piya yogini Parasi kina agora mintume kina'miba abitegini: We, taeba taorikano, untawe. ");
INSERT INTO for_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Piya yuguna Isuba maya uwaimintiye: Tigeba tiyorika mintasinta aguntaenaripa kampa tigeti waiyesine. We, tigeripa: Taeba taoyagane yeka, aguntaenaripa uwa wairitakiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Pigoya, Isuba kamana maya untiye: Naeba tagaka urimukuwa abiyo: Ka'waina aeba sipisipiwama kagisa kagopinti uma pasikena kabera kampa uma pasinta, tori kagisa aemita puma wakibi'nakaba, aeba ku ntagara mima, to'wainantana a'yugu maekena yagarawe, yewe. ");
INSERT INTO for_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pigoya, to ka'waina aeba kaberisa iyegiripa, aekaba pipa sipisipi ki'numpi nkibawaimpawe, yewe. ");
INSERT INTO for_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Aeba ampa irosaginaba kiya yagaramaba agate kabe ai'atagini sipisipiwampiba awamupisa kamana abewe. Piya pegina yaga ki'nunkapa ige uma igega'e yegini kagisa kagopintisa aeti kana pegana ibabute irosaye. ");
INSERT INTO for_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ibabute paitawaitama tumegini kamana'wapa ago abima aegarawe. ");
INSERT INTO for_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pigoya, to yagaraba kampa aegarakibewe. Piya, ae agaba kampa abintaka karu potama iyegaka wakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Pigoya, Isu aeba piya meto kamana uwaimogini igeba ayaga kamanapa iye umagini, kana kamana'ama nkagoba kampa abintawe. ");
INSERT INTO for_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pigoya, Isu aeba to kake uwaimintiye: Naeba tagaka urimukuwa abiyo. Sipisipi ige ikena pi kabeba naewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pigoya naeba kampa aborantuwagini, aboranta kina igeba pipa ku kina, to wainanta uwa a'yugu maekena kinakini, pika sipisipi igeba iwamupisa kamana'waipa kampa abintawe. ");
INSERT INTO for_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Pigoya, sipisipi kabewaipa pipa naewe. Piya, ka'waina aeba naeti kanamagina kagisa kagopinti uma pasekanaba, Koti ababikiye. Piya pekana, uma pasite irosate puma nanintaba maekiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Pigoya, ku kina kanaipa tonagaba kampa kanaye. Aeba sipisipi kuntana puma iyeguma ataena puwaitakena kanaye. We, nae pi kanaopa, miyaba e'wasaena aborama imekini aogima asoyaenabi pumaeyekini miyiyema, tumintone. ");
INSERT INTO for_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Naeba sipisipirape aogi kiyenawe. Aogi kiye yagaramaba ae'wa nkau'wakaba kampa napinta, kasima sipisipi igeka napima iyo'maeye, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pigoya ka'waina aeba ikantana yuga pikibi'naba, aeba taga yaga kiyeba kampaye. Piya, aeba kana sipisipi ki'numpi nkibaba kampaye. Aeba agakana kabu kara kanakanaba itate aegaka wagaikiye. Piya pekana kabu karama ampa sipisipi iba nama igarugarebakiye. ");
INSERT INTO for_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pigoya aeba uwa ikantana yuga pemika, aeba sipisipigaba abekana uwaena kanta pekana kampa igekaba napikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Naeba sipisipirapa aogi kiye nagini, naeba naopa igaogini igeba naekaba napiyewe. Piya, nababe naebe agama abima miyuse. Pi nkawameta naebe naokina'mibe agama abima miyune. Pika naeba sipisipi igeka napima iyo'maekenaga miyaba'enanepa kaikuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Pigoya, to au'i ka'isa sipisipinepa mintawe. Igeba ma kagisa kagopisaba kampaye. Piya naeba igepa ibabute kanakini kamana'nepa abikibewe. Pigoya sipisipi aruba kana kiyaba pabiyama kanasuma aborakiye. ");
INSERT INTO for_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Naeba mikenaenanepa to kake maekuboka kaekuwe. Pika nabanempapa naeka abiye. ");
INSERT INTO for_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mikenaenanepa ka'wainaba kampa naparikiye. Pipa nae'ne naumanepisa kaikuwe. Naeba mikenaenane kaikenagabe maekenabe pi esegiyenaba wainatantiye. Piya pukuboka nabanempa unatantiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Isu aeba kamana piya yogini, Yuta kina'miba igeba abite maka umagini atatara puma tara aruyena puntawe. ");
INSERT INTO for_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Piya puntini igetisa uwoma kina'mi maya untawe: Ke kina antabaipinti mintegina aibo'ena piya. Nanaga tigeba kamana'wapa abima miyewe, untawe. ");
INSERT INTO for_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Piya yuguni to ka'isa kina'miba maya untawe: Kewamaba piya kamanapa kampa untana, pi kewama ka'wainaba iyorika kina'mi nkiyoba kanara agawaitakiya, a. Pipa kampaye, untawe. ");
INSERT INTO for_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pigoya Yerusaremiba aota yaga aborantiye. Pipa pai tabe mono nama kabe aiginta kana aborantiye. ");
INSERT INTO for_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Pigoya, pi ntaga esiba yaga aboraogana, Isu aeba tabe mono namapinti ka maru agewapa Soromoninta, pita'i waogini, ");
INSERT INTO for_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yuta kina'miba ampa kobe pumagini maya omintawe: kaeba nanaga tagu'ama tara taraba puratane. Karaisiti yagara mintanapa agogapa aborama uramo, untawe. ");
INSERT INTO for_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Piya yuguna Isuba maya uwaimintiye: Naeba urimogiripa kampa abibebe pewe. Nabanempa nkawamuta yoga po'na nkagonepa uma aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pigoya tigeba pipa sipisipinentanaba kampa puntiri kamana'nepa kampa aega'ma napiyewe. ");
INSERT INTO for_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipisipinentana puma miye kina'miba kamana'nepa abewe. Piya, naeba igabebe puma abiwaemogini naegarawe. ");
INSERT INTO for_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Piya, miyaba'ena aborawaimekini kampa purinta, miyaba mikibewe. Igepa nae nayapisa ka'waina iyoba itakenaenaba kampa waintiye. ");
INSERT INTO for_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nabanempa naeti ibabuwaitanti kina igeka aboganaba a'ya'waema nkesegiyenapa igasaye. Eya, ka'wainaba nabanempa nkayapisaba kampa igarubakiye. ");
INSERT INTO for_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","We, naebe nababe tasigeba ka'antowe, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Piya yogini, Yuta kina'miba yaba kasu mpaema aegukena puntawe. ");
INSERT INTO for_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Piya puguna Isuba maya uwaimintiye: Aogi yugaba toma toma nabanempa nkayapisa puriyakogiripa, tigeba nana ata pogiri yaba kasupa maema naegukena pewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Piya yogini, Yuta kina'miba pabigo awamuta u'magini maya omintawe: Aogi yuga pempekaba kampaye. Kaeba wasanaraka miyempe'naga Koti akayasotama, kaegaka: Kotinawe, yempeka kaegukenagaba yune, untawe. ");
INSERT INTO for_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Piya yuguna Isu maya uwaimintiye: Ago kamanatipipa: Tigeba Koti kanta pewema, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Piya, Koti kamana maru aboranti kina igeka Koti kanta puma miyewe. Eya, mono'amaba kampa paga pakiye. ");
INSERT INTO for_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Pigoya, nabanempa utanatama, aewa unataoga mabi tuminto, pika naeba Koti Ntagaranawe, yuwe. Pipa tigeba nanaga: Koti akayasotaneba, naekaba yewe, a. ");
INSERT INTO for_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Piya, naeba yoga popa, pi agaigina nabanempa ae awameta kampa pekiripa, kamana'nepa a'a-o yigina kanarasaisine. ");
INSERT INTO for_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pigoya, naeba ae yuga puwe. Piya, tigeba kamana'ne kampa tibegiripa, kanara yoga poka napima aogima abibebe piyo. Piya puntiri tigeba mayaga aogima napibebe puma piyo: Nabanempaba naege miyegi, naeba pabiyamagi aege miyuwe yo kamanapa aogima abiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Piya yogini iga'na utukena puguna igaitegina wagaintiye. ");
INSERT INTO for_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aibuntana, Isu aeba Yontani wanipa ta'ema maroteri wama pai Yoni wani pai'itama mintanti, pita'i wama umintantiye. ");
INSERT INTO for_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pita'i umintogini, a'ya'ma uwoma kina aeti ampa irosa'ma mare-u me-u puma maya untawe: Yoniba awame'enaba pipa kampa puntine. We, a'ya'waema kamana ma ntagaraga Yoni untemipa, pipa tagane, untawe. ");
INSERT INTO for_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Piya utegini uwoma kina'miba Isu aega'ma imatiti puntawe. ");
INSERT INTO for_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pigoya Petani kumata ka yagara mintanti, agewapa Arasarusi, aeba yonintana abogana mintantiye. Pigoya, Mariyage Matage isigeba a'nantoge anonantoge pabi kumatasawe. ");
INSERT INTO for_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Piya, Mariya pi ae Wa'ega agunta wani pai'atama a'no nkabiyatasa agisaba aebago pogaintiye. Pi ae ao'manto Arasarusi yonintana abogana waitamintantiye. ");
INSERT INTO for_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Piya poginisi, anonantoge a'nantoge isigeba Isuti kamana maya uma atausuguna wantiye: Wa'ega, kaeba abo. Kao'yagara aeba yonintana abegini waitamintiye, uma atausuguna wantiye. ");
INSERT INTO for_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Piya pogana Isuba pi kamana abite maya untiye: Pi nkinuntana wasana uwa purikenaba kampaye. Koti a'muntana aborakiyema untine. Koti Ntagarawa nae i'mu punatakenaenaga pi yonintanaba aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Pigoya, Matakabe a'nantokabe Arasarusikabe Isupa igekaba tabera abuntiye. ");
INSERT INTO for_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Pigoya, yonintana abiye kamana abitegina, mintantita tara yaga to kake mintantiye. ");
INSERT INTO for_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Piyama mintana, abagi kina'wa maya uwaimintiye: Maeyigi, Yutiya mari a'wae pumagi wano, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Piya yogini abagi kina'wampiba maya omintawe: Tisa, Yuta kina'miba maganto yaba kasutasa kaegukena untana, pipa nanaga mapa igetiba to kake a'wae puma wakenaga yene, untawe. ");
INSERT INTO for_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Piya yuguna Isuba maya a'wae puwaimintiye: Aseba kampa unta, papa uwa tantiye. Piya, ka'waina aeba ara ke'i nasemipa kampa uma aesama aeguye. Aeba e'wasa pekana a'ya'waemaenaba kanara agakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Piya, ka'waina aeba aseka ke'i wagina uma aesama aegukiye. Aeba tununtanabinti wama ayama a'ya'waemaenaba agakiye, a. Pipa e'wasaenaba kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Piya untana kamana ka mayama amato puntiye: Abiyo, tao'yagara Arasarusiba awaitamintika, pi naeba wama uma abage pukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Piya yogini abagi kina'miba maya untawe: Wa'ega, awaitamitipisa to agama asikiye, untawe. ");
INSERT INTO for_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Isu aeba ago purome meto kamana yogini, igeba uwa awaitamintegina iyemagini kampa abibebe puntawe. ");
INSERT INTO for_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Piya puguna Isuba uma aborama uwaimintiye: Arasarusi ago pu'waye. ");
INSERT INTO for_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Naeba pita'i kampa wama umintogana pu'waika tigekaba nantawamaba aogi piye. Tigeba aogima timatiti pikibeka pintanaba aboraya, maeyigi aeti wano, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Piya yogana Tomasi, to ka agiwapa Agaiyawe unta, aeba abagi aokinapa maya uwaimintiye: Taeba wama tisage kaga uma purukune, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pigoya, Arasarusiba arubinti waintogana, tarawa tarawaki yaga a'ya puwaogana Isuba uma irosantiye. ");
INSERT INTO for_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pigoya, Petani kumapa pi Yerusaremi kuma'ama nkagora tumairira waintantiye. ");
INSERT INTO for_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Pitasa Yuta kinapa a'ya'ma Matake Mariyake isi'nanto pu'waomeka tugu nkisigakena wantawe. ");
INSERT INTO for_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Piya puguna, Mataba: Isu ampa irosaye yuguna, abitegina, Mariyaba namapinti mintogana, ke'i wama uma abatantiye. ");
INSERT INTO for_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Uma abatama maya omintiye: Wa'ega, kaeba mata'i mintampesinta, na'nantoba kampa puremisine. ");
INSERT INTO for_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Piya, ibantoba naeba kaekaba abuwe. Piya mayaenagaba Kotiti esotaganaba abigamikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Piya yogana Isuba: Ka'nantoba aogama asikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Piya yogana Mataba maya untiye: Ainti tabe kanabi aogama asikibi, pipa abintuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Piya yogana Isuba maya omintiye: Abage puma asitakena miyaba'enama nkagoba naewe. Pika ka'waina naeba naega'ma amatiti pikibi'naba purikibipa aumawapa awa waiyaba mikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Piya, ka'waina aeba aogama mintana amatiti puma naegararakibi'naba kampa purinta miyaba mima esegi pikiye. Kaeba pi kamanapa abibebe peno untiye. ");
INSERT INTO for_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Piya yogana Mataba maya untiye: Wa'ega, owe. Koti Ntagara, Karaisiti pai mabi aborakiye unta, pipa kaewema, nagutasa abibebe puwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Piya kamana untana a'nanto Mariyaka kega'e uma obina suma maya omintiye: Tisa kanantana kagega'e iyema, omintiye. ");
INSERT INTO for_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Omogana, Mariyaba abite pabigo asima Isuti wantiye. ");
INSERT INTO for_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pigoya, Isu aeba kuma awamori Mata kamana omometi mintantiye. ");
INSERT INTO for_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Piya pogana Mariya aeba karu'ena asima waogini, Yuta kina namankapi tugu nkampintume kina'miba: Wasana aruri kube'ena pikena waye, ute aega'magini wantawe. ");
INSERT INTO for_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Pigoya Mariyaba kuma awamori tumima Isu mintometi wama agama agisabi tumpa parokaema maya omintiye: Wa'ega, kaeba mata'i mintampesinta na'nantoba kampa puremisine, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Piya uma kube'ena pogini, Yuta kina aega'ma waume kina'miba ae ao'maemagini kaga kube'ena puguna, Isuba igate abima antarapa tabera puntiye. ");
INSERT INTO for_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Piya puntana: Aeta kaitawema ibigaogini igeba: Wa'ega, kanama ampa agao, untawe. ");
INSERT INTO for_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Piya yuguna Isu aeba kube'ena puntiye. ");
INSERT INTO for_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Piya pogini Yuta kina'miba agate maya untawe: Agaiyo. Agu'amaba tabera aeti waintiye, untawe. ");
INSERT INTO for_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Piya yuguni ka'isa kina'miba maya untawe: Aorika yagara ka aogatantikana Arasarusi kaba atakenaba igiga pegina puripera ayabiye, untawe. ");
INSERT INTO for_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Piya yuguna, Isu tabera antara pumagina kana arura uma irosantiye. Kana wasana yabaeba yaba nkagepinti waintogana awaba tabe yabantamatasa aigunkatauguna waintantiye. ");
INSERT INTO for_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Pika Isuba: Yabapa a'waiyiyo, yogana, kana pu'waome ntagarama nkamana'ma Mata aeba maya untiye: Wa'ega, ago tarawa tarawaki waimagina ago agunta iye, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Piya yogana Isu maya omintiye: Kamana ugamopa kampa abibebe pena, a. We, kaeba naega'ma kamatiti punatagana, Koti nkesegiyenawampa nke'wasaenaba aborakana agao, ugamone, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Piya yogini yabapa a'waiyuguna Isuba inati aoma urintana mayama nunamu untiye: Naba, kaeba nunamunepa abempeka na'mu pugatauwe. ");
INSERT INTO for_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Kaeba nunamunepa a'ya'waema yagaba abempepa pipa abintuwe. Naeba uwa ma wasana minta kina'mi kae unatauku tuminto, pi igutasa abibebe piyema kamana piya ugamuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Piya untana taberasa kega'e umagina: Arasarusi, kaeba irosa'ma iyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Piya yogana purinta yabaewama intiye. Agisa ayapa kairasa kibarugintini, aowaba pabiyama kairasa asaemaraume, pikaba Isuba maya uwaimintiye: Kaiba iyobakasigina wano, yogini piya puntawe. ");
INSERT INTO for_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pigoya Yuta kina, Mariya kananta kina, igetisa uwoma kina'miba Isu pintana pome agate: Aeba Karaisitiwe, uma imatiti puma aegarantawe. ");
INSERT INTO for_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Piya puguni, ka'isa kina'miba Parasi kina'miti wama Isu pome pi kamana uma uwaimintawe. ");
INSERT INTO for_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Piya puguni tabe mono kiye kina'mibe Parasi kina'mibe pi kamana abite mono kanisore kina igega'e uwaema maya untawe: Kana yagara aeba awame'enaba uwomantana piya, aya pusune. ");
INSERT INTO for_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Taeba uwasuwa potamagi mintakini a'ya'ma kina'miba ae kamana abima aegaraigini Aroma kina'miba kama puratama tabe mono namatepe wasanabe a'ya'ma tapawaerikibewe, untawe. ");
INSERT INTO for_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Piya yuguna, ige iyo'yagara ka, agewapa Kayapasi, aeba pi kabubipa monota paitanta kiye yagara mintantiye. Aeba maya untiye: Tigeba tigu napi napiyenari kampa wainta mintawe. ");
INSERT INTO for_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wasana ige ataena pusanaga, ae ka'wainanto a'ya'ma kina'mika uma pu'magina iyo'maeyakana a'ya penoma, kampa abintawa, a, untiye. ");
INSERT INTO for_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Pi kamanapa napiyenawapisaba kampa untiye. Koti otaogana meto kamana maya untiye: Aeba pi kabubipa monota paitanta kiye yagara mintomeka: Isu aeba a'ya'ma kina'mika purenema, taga otantika meto kamana untiye. ");
INSERT INTO for_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Piya, Yuta kina ige ibiba kampaye. Koti ntagara araga a'ya'ma maga maga mirite wa kina, ige a'ya'ma ibabuma aki puwaitakini ka aruyena puma miyiyema, otantika, piya untiye. ");
INSERT INTO for_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pigoya pintaga kiya kina'miba Isu aegukenaenagaba agobima nikintawe. ");
INSERT INTO for_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Pika Isuba Yuta kina'mi nkiyoriba to kake kampa nasintiye. Aeba ka'me mpari agora kumapa ka, agewapa Eparaimi, pita'i abagi kina'wapa ibabute wama umintantawe. ");
INSERT INTO for_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pigoya, Yuta kina'mi Pasoba yaga agarosaogini, a'ya'ma uwaena kuma'antontorisaba a'ya'ma uwoma kina agunta kamana'wai uma aogi pikena karu'ena paitama Yerusaremi kumati intawe. ");
INSERT INTO for_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Piya puntini tabe mono namapinti Isuka aguyosakate maya uma mare-u me-u puntawe: Tigeba ayawe yewe. Aeba aota yagaba kanakipera kampaye, untawe. ");
INSERT INTO for_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Piya, tabe mono kiye kina'mibe Parasi kina'mibe igeba maya kamana uma esegi puntawe: Ka'waina aeba mikibiti agantanaba kanama ampa urameka iga'na uteno, untawe. ");
INSERT INTO for_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pigoya, tonaentisa ka'umaema yaga waintogana, ainti Pasoba naninta nakena yaga aborantiye. Piya, pi ntaga Isuba Petani kumati uma irosantiye. Aeba pi kumata Arasarusi purintapisa aogatantita uma irosantiye. ");
INSERT INTO for_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Uma irosaogini, Isupa naninta kao'ena potauguna Mataba iso'ma imogini Arasarusige kaga mimagini nantawe. ");
INSERT INTO for_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Piyama mintuguna Mariyaba tabe masawae kankabe aogi agunta wani, agewapa nati, pi tabe ikantaga, pi maema Isu nkagisari pai'atama a'no nkabiyatasa aebago pogaintiye. Piya pogana kana namapintiba aogi agunta uwaentiye. ");
INSERT INTO for_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Pigoya, abagi yagara ka, Yutasi Isikeriyoti, aeba kuna yagara, ae maya untiye: ");
INSERT INTO for_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Agunta wani pitasa 300 tora maema kusi kina imekana aogi pusanawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aeba pi kamanapa kusi kina'mika napimaginaba kampa untiye. Aeba waba mponera kabimagina mima moneba maema kaka pome ku ntagaragana, pika untiye. ");
INSERT INTO for_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Piya yogana Isuba maya untiye: Tigeba ma kana waepa kaba a-nkabiraiyo. Aeba agunta wanipa nauti pai'ataka purekini kainatakena, pika utanatama maema atama miyine. ");
INSERT INTO for_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Piya, kusi kinapa tigege asi nasi miyaba mikibewe. Pigoya, naeba tigegeba e'erotapa kampa mikuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pigoya, Yuta kina'miba pi kumati mintiye kamana abite, a'ya'ma uwoma kina pabita'i uma irosantawe. Pigoya, Isu ae abintogaba kampaye. Arasarusi purintapisa aogatanti, aeke kaga agakena ampa irosantawe. ");
INSERT INTO for_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pigoya, pipa tabe mono kiye kina'miba Arasarusike kaga aegukena kamana untawe. ");
INSERT INTO for_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Piya, Yuta kina a'ya'ma uwoma kina'mi aeka uma wama Isuti uma atokaentaka piya puntawe. ");
INSERT INTO for_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pigoya, marogini uwoma kina aota yagagini karu'ena Yerusaremi kumati ampa irosanta kina, igeba Isu kanaye kamana abintawe. ");
INSERT INTO for_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Piya kamana abite yanta aerisa maete ke'isa uma kabima ababikena wantawe. Wama uma ababuntini maya uma i'mu potama untawe: We, Wa'egawama nkawamuta taeti kanaika ta'mu potano. Aeba Isureyo kina'mi tabe yagarawe, untawe. ");
INSERT INTO for_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Pigoya, Isu aeba tonki aikeri aborama amuguna akabata mara'mima wantiye. Pipa ago kamana mayama waintanti pabi nkawameta puntiye: ");
INSERT INTO for_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","We, Saiyoni kumatasa kina, tigeba a-tiyekuruba piyo. Agao. Tabe Wa'ega Yagarari tonki aikeri akabata mima tigeti kanaye, piya untiye. ");
INSERT INTO for_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pi kamanapa abagi kina'wampiba pi ntagaba kampa napima abibebe puntawe. Ainti Isuba inati e'wasaenawati a'wae puma iyogini, pi kamanakaba napima mayama abibebe puntawe: Pipa aeka mono isapi kaemaranta, pabinkawameta pintanaba potantawema, napintawe. ");
INSERT INTO for_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Piya, aeba Arasarusi kega'e yogana arubintisa irosa'ma iyogini aganta, pi uwoma kina'mi ige pi kamanapa uwaimintawe. ");
INSERT INTO for_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Pigoya, pi awame'ena punti nkawaga kamana abinta, uwoma kina'mi ke'i wama uma abatantawe. ");
INSERT INTO for_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Piya puguni, Parasi kina'miba maya uma igewai mayama mare-u me-u puntawe: Abewo. A'ya'ma kina'miba aeti wama pabigo aegaraka taeba ka'enaba kanara kampa potakune, untawe. ");
INSERT INTO for_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pigoya, Yuta kina Yerusaremi kumati aota yagaba Koti mpono abikena iyume kina'mi ige abakapintiba to marisa Kariki kina ka ka'miba kaga umima abintawe. ");
INSERT INTO for_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Piya puntini, igeba Piripi aeba Karariya marisa Petisaita kumatasa yagara, aeti wama maya omintawe: We naba-o, taeba Isu agakenaga yunema, omintawe. ");
INSERT INTO for_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Piya omuguna, Piripiba wama Enturu omoginisi, kaga Isuti wama pi kamanapa omintase. ");
INSERT INTO for_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Omusuguna Isu maya untiye: Wasanama Ntagara mana e'wasaena maekena yaga pabigo ampa agarosama aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Piya untana to maya untiye: Tagaka urimukuwa abiyo. Witi aipa mabi kampa antaganaba kampa iranta uwa waiyikana, mabi amaraganaba i'ma nakenaba toma toma uwoma aboraye. ");
INSERT INTO for_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Pabiyamagina, ka'waina aeba mikenaenawa abugakibipa a'yugu potakiye. Piya, to ka'waina aeba mabi mima mikenaenawa kampa abikibemi'naba esegima miyaba'ena aboramikiye. ");
INSERT INTO for_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ka'waina aeba nae kayokaya'ena pikena untanaba, naegarano. Piya, nae mikubo nagora kayokaya kina'nepa miyeno. Ka'waina aeba nae kayokaya'ena punatakanaba, aepa nabanempaba tabe agi omikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Pigoya Isu to maya untiye: Mapa nagu'nempaba pami puma tabaraba piye. Pika nanawe ukuwe. Naeba: Naba, pintana aboranamemipa nau'ima maenagaso, piyaba kampa ukuwe. Kampaye. Pi ntaga aboranamenema unatantampene. ");
INSERT INTO for_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Pika naba, kaeba yegana kagegapa tabe puma aborano, untiye. Piya yogana mantarisa maya kamana tumintiye: Pi nageba ago tabe puma aborantikana to kake pabiyama aboraurite wakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Pigoya, agora mintume kina'miba abite: Antaru iye, untawe. Piya yuguni, ka'isa kina'miba: Enisore ka'waina kamana omiye untawe. ");
INSERT INTO for_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Piya yuguna, Isuba pabigo iwamuta u'ma maya uwaimintiye: Kamana pipa nae nao'maekena kamanapa kampaye. Tige tiyo'maekena kamana uma aboraye, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Pigoya, mapa mabi atatara pikena kana aboramikana mampabisa tabe yagara aepa aebasanakiye. ");
INSERT INTO for_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ibaba mabi mintokini, aintiba igeba yara naeguma asaga'yunataigipa, pi ntagaba a'ya'ma kina igega'e uma ibaibekini naeti kanakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Pipa purikena meto kamana'wa piya untiye. ");
INSERT INTO for_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Piya yogini, wasana aki puma mintume kina'mi igeba maya omintawe: Taeba mono isapipa maya kamana aisuma abune: Karaisiti aeba kampa purinta uwa miyaba mikiyema abuna, kaeba nanaga: Wasanama Ntagara aepa aeguma asaga'yukibewe, yene. We, Wasanama Ntagara aeba kewe, untawe. ");
INSERT INTO for_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Piya yuguna, Isuba maya kamana a'wae puwaimintiye: Kane e'wasaena aeba abakatipipa uwaena yaganto e'wasa pikiye. Pika tununtanama titikaesanaga yaku e'wasaena wairitantakiri aeti aborama miyiyo. Ka'waina aeba tununtanabi wantanaba kepa kampa agabebe piye. ");
INSERT INTO for_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Pi kane e'wasaena wairitantika tigutasa pi e'wasaena aega'ma ae tuntana piyo, uwaimintiye. Isu aeba piya kamana uwaimite wama kakama umintantiye. ");
INSERT INTO for_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Pigoya Isu aeba awame'enaba toma toma uwomantana iyora pogini agantiniba, uwa aetiba kampa aega'ma imatiti potantawe. ");
INSERT INTO for_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Pipa poropete yagara Aisaya ae kamana'ama esegi penema piya puntawe: Aeba kamana mayama kaentiye: Wa'ega, kawaga kamanaka yokanaba, ke abibebeba piye, iye. Pipa Wa'egawamatisa esegiyena ke ayakegana napiyema, kaentiye. ");
INSERT INTO for_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Piya, igeba iyorika pumagini, Isu kamanapa kampa aogima abibebe puntawe. Pipa Aisaya kamana mono isapi ka waintomeka puntane. Pipa mayamawe: ");
INSERT INTO for_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Kotiba iyo atikaewaigasima igu'amapa akumpa yaba kanta puwaitantine, iye. Piya pogini, igeba a'ya'waemaenaba kampa agama napibebe puntane, iye. ");
INSERT INTO for_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Igupa a'wae pigi aogi pusanaga akumpa puwaitantine, untiye. Aisaya pi kamana Isuka untipa ae e'wasaenawa agantana untiye. ");
INSERT INTO for_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pigoya ka'isa monota paitanta kina'miba Isupa igu kayone potantini, pigo: Parasi kina'miba mono a'a-o uratama tagarubakibewe, uma iyekuru puma kakantawe. ");
INSERT INTO for_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Piya, Igeba Kotiba ige'wai maema asaga'yusanagaba kampa ibuntiye. Igeba wasanami ige'wai maema asaga'yuwaitasanaga tabera ibugaogini iyekuru puma kakantawe. ");
INSERT INTO for_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Pigoya, Isuba kega'e uma maya untiye: Ka'waina aeba naega'ma amatiti punatakibipa, aeba nae nabiba kampaye. Unatanti'na aeke kaga aega'ma amatiti potakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Piya, ka'waina aeba nae ka nagai'naba unatanti'na aepe kaga agaye. ");
INSERT INTO for_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Piya, e'wasaena naeba mampabi tumintone. Ka'waina aeba naega'ma amatiti pikibi'naba tununtanabipa kampa miyaba mikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","To ka'waina aeba kamana'ne abimagina a'a-o uma kasakapa, antota'enaba ibaba kampa amukuwe. Piya, naeba wasana antota'ena imikenaba kampaye. Naeba aogi puwaitakena mabi tumintone untiye. ");
INSERT INTO for_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Piya, ka'waina aeba nae a'a-o unatama kamana'ne kaikibi'na, kamana uma a'ya pikena kanapa aepa aboramikiye. Eya, kamana yopa pipa ainti tabe kanabi, kamana uma a'ya pikenaenaba aepa aboramikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Naeba kamana yopa nae'ne naumanepisaba kampa yuwa, naba unatanti'na a'ya'ma kamanapa piya yoma unamintegi uma aborauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Pigoya naeba abintuwe. Awamupisa kamana'ama a'ya'ma yaga aogima miyaba'enaba maema aboraye. A'ya'ma kamana uma aboraopa nabanempa yoma unamintisa puma yuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aota yaga Pasoba aboraogana, Isuba ae'waka mayama napima abintiye: Naeba maba atate nabati a'wae puma ikena kana agarosayema, napintiye. Piyama napintana, mabi a'ya'waema aokina'wa agu kao'ena puwaitata kanantiye: ");
INSERT INTO for_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pigoya, aseka naninta nakena aki puma mintuguna, ka mayaena aborantiye: Saimoni ntagara Yutasi Isikeriyoti aeba Isu kuna penema Sataniba ae antabaipinti napi napiyena atantiye. ");
INSERT INTO for_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Piya pogana Isuba aeba mayama abintiye: Naba aeba a'ya'waemaenaba nayapi atawaeye. Piya, naeba Kotitisa tumintoka to kake Kotiti a'wae puma ikuwema, napintiye. ");
INSERT INTO for_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Piyama napintana, naninta mintumetisa asima e'ero kaiwapa aboborasaba atagasima to ka kai maema amintiye. ");
INSERT INTO for_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Piya pu u'ma wani tu'napi ti'atama, pabigo agobima abagi kina'wa nkigisa pai'itantiye. Piya puwaitama, akapi kirintome kairasa aebago puwaigaintiye. ");
INSERT INTO for_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Piya puwaitata Saimoni Pitati uma irosaogana, maya omintiye: Kaeba Wa'egawamaga, nagisanepa wani nkaekenaga yeno, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Piya yogana Isuba maya omintiye: Ma pontanama, pi nkagoba ibaba kampa abempekana, mintana aintiba abikibene, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piya yogana Pitaba maya untiye: Ibabe asabe nagisanepa taga kampa pasikibene, untiye. Piya yogana Isu maya omintiye: Naeba kampa paikatakanapa, naegeba kampa atokaema mikibene, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Piya yogana Pitaba maya untiye: We, Wa'ega, piya untanapa nagisari manapa kampaye. Nayatipe na'notipe kaga paso, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Piya omogana Isuba maya ominitye: Ka'waina auti wani pasikibi'naba ainti agisa mana pasekanaba a'ya'ma autisa nare ntare puwaewakiye. Pigoya tigeba a'ya'waemaba kampa nare ntare puwaentawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Aeba kunaenawapa abibebe pu u'ma maya uwaimintiye: Tigeba a'ya'waemaba kampa nare ntare puwaentawe, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Igisaba waninkama a'ya itate, e'ero kaiwapa to kake maema pu u'ma mara'mima maya uwaimintiye: Naeba pi puritaontanama nkagoba abewo. ");
INSERT INTO for_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Tigeba: Tisa, Wa'egawe, unamewe. We, piya kinati mpintogiri pipa kanara unamewe untiye. ");
INSERT INTO for_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Piya, naeba Tisa, Wa'egarimpana tigisaba pai'titauwa, tige tigeri pabiyama tigisariba wani nkaeta wama kayokaya kina miyigina kanarasano. ");
INSERT INTO for_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Naeba pintanaba puriyakuwa, tigeba iba tiyakontanaba pabiyama puma miyiyo. ");
INSERT INTO for_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Naeba tagaka ukuwa abiyo: Kayokaya yagara ka'waina aeba tabe yagarawampa nkawameta agasimagina, mikenaenaba pipa kampa waintiye. Piya, yoga kina ka'waina yogawama nkabawampa ae awameta asugasima mikenaenaba pipa kampa waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Pigoya pi kamanapa aogima abibebe pumagiri pabi nkawameta miyiginaba aogi pikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Naeba a'ya'ma tigekaba kampa yuwe. Kibi'ma ibabuwaitanto igeka abibebe puntuwe. Pigoya, mono kamana awa'enama nkau'wapa mayama aborakiye: Naege naninta kaga nai ntagarama aeba agisa wanta naekiye unti, pi kamana'ama nkau'wapa aborakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Piya, pintanaba kampa aborantegi, ibaba pika urimuwe. Piya, ainti pintana aborakiripa, kanara tigeba abimagiri: Aeba pi aobi pompe ntagarawema, naega'ma timatiti punatakibewe. ");
INSERT INTO for_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Piya, naeba tagaka urimukuwa, abiyo. Ka'waina aeba yogara otanta'naba ababuma kayone potakibi'naba, yoga ago nae nababumagina aogi punatakiye. Piya, ka'waina aeba nae nababuma aogi punatakibi'naba, unatanti'na ae aogi potakiye, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Isu aeba pi kamana untana, aumawamaba tabera kunta abuntiye. Aibogana aborama maya uwaimintiye: Naeba tagaka ukuwa abiyo. Tigetisa ka'waina naepa kuna punatakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Piya yogini, abagi kina igeba ankaobi aobi puwaentini: Pipa kekabaya iye, uma kampa napintawe. ");
INSERT INTO for_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pigoya, abagi yagara ka Isu nkagora mintanto, aeba naekaba tabera abugaome ntagara, ");
INSERT INTO for_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","naeka Pitaba ayatasa awame puma maya untiye: Abigagana ugameno. Kekabaya iye, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Piya yoga naeba Isu nkagora parokaema maya untuwe: Wa'ega kaeba keka yene. Yuwagana, ");
INSERT INTO for_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isuba maya untiye: Pareti wanipi nkaema amekana maekibi ntagara, pi aeka yuwe, untiye. Piya ute pareti wanipi nkaema Saimoni ntagara Yutasi Isikeriyoti, ae amogana maentiye. ");
INSERT INTO for_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Piya maema naogana Sataniba antabaipinti uma pasintiye. Piya pogana Isuba maya omintiye: Pikena yempentanaba pipa karu'ena po, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Piya kamana omogini pi kaga mintume kina'miba pi kamana agoba kampa abibebe puntawe. ");
INSERT INTO for_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Piya puntini ka'isamiba maya untawe: Yutasi aeba mone pokisire maema kabima miyikana aota yagasaena ika penema otabera, kusi kina mone imenema iyema, napintawe. ");
INSERT INTO for_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Piyama napiyuguna, Yutasiba pareti nagaite pabigo irosa'ma aseka wagaintiye. ");
INSERT INTO for_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yutasiba wagasogana Isuba abagi kina'wa maya uwaimintiye: Mapa Wasanama Ntagara nae e'wasaenane aborakiye. Piya, naeka uma Kotitisa e'wasaenaba kaga aborakiye. ");
INSERT INTO for_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Naeba Kotitisa e'wasaena maema aborantoka Koti aewa nae e'wasaenaba pabiyama maema aborakiye. Pi kanapa agaro ntaganto pabigo aborakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Piya untana, to maya untiye: We, yakaraki'nuntepa, naeba agaro ntaganto tigege mikuwe. Piya, aintiba naguyosagakibewe. Yuta kina uwaimintosa puma, tigepa pabiyama urimukuwe: Nae wakuboti pabiyama kampa wakibewe. ");
INSERT INTO for_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pigoya, ma kasa ago kamana urimukuwe: Wasana agu kao'ena puwaitama kayone puwaitaiyoma, yuwe. Naeba agu kao'ena puma kayone puritama miyosa puma, pabiyama tigeba agu kao'ena puma kayone puwaitama miyiyo, yuwe. ");
INSERT INTO for_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Agu kao'ena puma kayone pigini, wasanamiba tigaiginaba nae naokina'ne kanta piyo, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Piya yogana, Saimoni Pita abigama maya untiye: Wa'ega, kaeba aeta wakibenema, abigaogana Isuba maya untiye: Nae wakubotiba pipa ma ntagaba kampa wakibene. Ainti mintana pita'iba wakibene, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piya yogana Pitaba maya untiye: Wa'ega, naeba nanaga kaka'iba kampa kaega'ma wakuwe. Naeba kaeka uma mikenaenanepa kanara kaikuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Piya yogana Isuba maya omintiye: Kaeba naeka uma mikenaenagapa kaikenaga yeno. We, naeba tagaka ugamukuwa abo: Kokorewamaba kampa aga untakana, kaeba kakagara uwame unatakibene, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Pigoya, Isu to kamana maya untiye: Tigeba tigu'amaba tabaraba puma pamiba a-piyo. Tigeba Koti aega'ma timatiti puntiri, naepa pabiyama naega'ma timatiti piyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nabanempa kumatiba namapa uwoma wairite wantiye. Pi kapa kampa waintemisinta kampa urimosine. Piya, naeba maruntaki'ena puritakena wakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Piya, wama maruntaki'enari puritate, to kake a'wae puma kanama tibabute wakiri, nae mikuboti kaga umikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Piya, wakubo pi kipa ago agawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Piya yogana Tomasi maya omintiye: Wa'ega, kaeba aeta wakibene. Pipa taeba kampa abintune. Pi kipa ayama agakune, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Piya yogana Isuba maya omintiye: Kepe taga ntanamape miyaba'enamape agowapa naewe. Nae nagaite nabati uma irosakenaenaba kampa waintiye. ");
INSERT INTO for_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Tigeba naepa nagabebe puma yesinta, nabanempapa pabiyama agabebe pesine. Pigoya mapa nabanempapa agobimagiri agantiri, naepa nagama aeka abibebe pewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Piya yogana Piripiba maya untiye: Wa'ega, kaeba kabapa tayakega agama abekana a'ya peno, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Piya yogana Isuba maya omintiye: Piripi, naeba e'ero ntaga tigege miyoganapa, kaeba kampa nagabebe pena, a. We, ka'waina aeba nae nagai'naba nabapa agaye. Piya, kaeba nanaga: Wa'ega, kaeba kabapa tayakega agano, yene, a. ");
INSERT INTO for_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Kaeba mayamaba kampa abeno: Nababa naege miyegi, naeba pabiyama nabanempage minta, kamana urimopa pipa nae'ne ntaumanepisaba kampa urimuwa, nabanempa nagupi mpima esegiyena aboranamegi, a'ya'ma yugaba puwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Naeba nabage miyogana, nababa pabiyama naege miyeba, abibebe piyo. Pi kamanapa abigina tagantana peno. Piya, kamana'nempa kampa kanarasaritakiripa, a'ya'waema yuga pontananempa abima timatiti pigina kanarasaritano, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Naeba tagake urimukuwa abiyo: Nae naega'ma amatiti pikibi'naba, yoga posa puma pabiyama pikiye. Pigoya pabinkantoba kampaye. Naepa asunagasima pikiye, untiye. Pipa nanagawe. We, naeba nabati ikuwe. ");
INSERT INTO for_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Iyekiri tigeba nae nagega'e uma esikibe nkawameta timukuwe. Pipa nabanempa e'wasaena yagarawa naeka uma aborakibika umagi piya pukuwe. ");
INSERT INTO for_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Pigoya, nae nagega'e uma esunataigipa, owe uma aborarimukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Pigoya, Isu to maya untiye: Tigu napi napiyenaripa naeti atama naegarantiripa, nawamu wasiyiyo. ");
INSERT INTO for_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Piya pigipa naba esotakana to tiyo'maema esegi puritakena otakana tumima tigege asi nasi mayaba'mikiye. ");
INSERT INTO for_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Pipa taga kamana'ama Nkawamusane. Mampabisa kina'miba igeba kampa agabebe puntini, kampa abibebe puntini pepa, kanara kampa maekibewe. Pipa tigeba aeka abintawe. Aeba tigege kaga mintiya, aintiba tintabaipinti ampikiye, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Pigoya, naeba titate wakiri, kintarama misanaga tigeti to kake a'wae puma kanakuwe. ");
INSERT INTO for_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Agaro ntaganto ka waintikana, pi a'ya pekiniba mampabisa kina'miba to kake kampa nagakibewe. We, tigeba nagakibewe. Naeba aososima miyaba miyekiri tigeba pabiyama aososima miyaba mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Pigoya, pi kanabipa nabanempaba naege kaga miyeka, naeba tigege kaga mikuwe. Pipa tigeba naege atokaema miyekiri agabebe pikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ka'waina aeba ago kamana'ne aogima mpaema mima aegarakibi'naba, aeba agu kao'ena punatakiye. Piya, ka'waina aeba nae agu kao'ena punatakanaba, aepa nabanempaba pabiyama agu kao'ena potakiye. Piya, nae'nepa agu kao'ena potamagi agonepa uma aborakana aeba nagakiye, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Piya yogana Isikeriyoti yagara wanane. To ka Yutasi, ae aukaba, abigama maya untiye: Kaeba ayama agogapa taetimanapa maema aborantana to ka'isa mampabisa kina'mipa kaka waitakenaga yenema, abigantiye. ");
INSERT INTO for_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Piyama abigaogana Isuba maya kamana a'wae pomintiye: Ka'waina aeba agu kao'ena punatakibi'naba, kamana'ne abima aega'ma wasikiye. Piya pekana nabanempaba aepa pabiyama agu kao'ena potakiye. Aibekara kaga aeti ampa irosa'ma miyaba'mikuse, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Piya, to ka'waina aeba agu kao'ena kampa punatakibi'naba, kamana'nepa ayabaya aeba abima aega'ma wasikiye. Pipa kampaye. Pigoya, ma kamana abepa nae'netisaba kampaye. Naba unatanti, aetisawe, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Pigoya naene tigege mintapa, piya kamanapa urimone, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pigoya ainti esegima asiritakena Aota Awamusa, aepa nabanempaba nae nawamuta otakana tumima a'ya'ma kamanapa urimikiye. Piya puntana, nae urimo kamana pipa uma to aososirimikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Naeba nanta paruyenane tigeti ataritauwe. Mampabisa kina'ma nkanta paruyena wanane. Nae'ne paruyena timuwe. Pika tigu'amaba tabaraba puma tiyekuruba a-peno. ");
INSERT INTO for_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Naeba wama uminta, ainti to kake a'wae puma kanakuwe, urimogiri ago abewe. Piya, Tigeba tigupa naeti atama yesinta, pipa nabati ikubo pi abimaba, tinta wamaba asoya pemisine. Nababa aeba naepa asunagasima mintika napima piya pusanawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Pintanaba kampa aborantegi, maru paitama urimuwe. Pintana aborakiripa maya yiyo: Kamana uraminti'na nkau'wapa aboraye, yiyo. ");
INSERT INTO for_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Naeba mapa uwoma kamanapa kampa amato puma urimukuwe. Mampabisa tabe kumpari yagara kanakena ase'yo pikana, kanama naeta ampa asesepa'urikiye. ");
INSERT INTO for_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Piya, naeba naba agu kao'ena potauwa, pika mampabisa a'ya'ma kina'mi agabebema abikibeka yoga unatanti puwe. Pigoya, tigeba asiyigi wano, Isu uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Pigoya, naeba taga waini iga'na agowe. Piya, nabanempaba waini yuga wama nkabawe. ");
INSERT INTO for_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Piya, ka amawama naeti a'wa kampa aentana uwa waiyeginaba, agayugasaye. Piya, to ka amawama a'wantaga wainteginaba, kasama arosagina anosama to uwoma a aeyanema kabitaye. ");
INSERT INTO for_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Piya pemisa puma naeba mono urimogiri abima asoya puma mintawe. ");
INSERT INTO for_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Piya puma, tigeba naege miyigi, naeba pabiyama tigege mikuwe. Waini amawamaba agowamati kampa atokaema waintakanaba a'wapa kampa aekiye. Kampa aeyemisa puma tigeba naetiba kampa atokaema mintiripa, au'wapa kampa maema aborakibewe. ");
INSERT INTO for_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Pigoya, waini iga'na agoba naewe. Amanepa tigewe. Ka'waina aeba naege atokaema miyekapa naeba aegeba pabiyama atokaema mikuwe. Pigoya, pi'naba anopa tabenama aborakiye. Tigeba naetiba kampa atokaema mintiri, a'ya'waemaena pikenaenaba kampa waikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Piya, ka'waina aeba naeti kampa atokaema miyekapa agaikuwe. Eya, waini amawamapa kasagana asaginiba, kibi'ma yakupi kasagana tamisa pabi nkawameta potakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pigoya, tigeba naeti atokaema mima kamana'nempa aega'magiri, esunatakibe nkawameta timukuwe untiye. ");
INSERT INTO for_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Tigeba au'wapa uwomantana maema aborama, nae naokina'nentana puma miyiginaba, nabanempaba tabe a'muntana aborakiye. ");
INSERT INTO for_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Pigoya, nababa naepa agu kao'ena punatagi, naeba pabiyama tigepa kao'ena puritauwe. Pika tigeba agu kao'enanapi miyiyo. ");
INSERT INTO for_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Naeba nabanempa nkawamupisa kamana wasiyu'ma, ae agu kao'enabi miyuwe. Tigeba pabiyama nawamupisa kamana'ne wasimagiripa, nae agu kao'enanepi mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Pigoya, na'muntananempaba tigeti ta'ema waiyenema, ma kamanapa urimiwaeyuwe, pika ti'muntanaripa aborama anosama abae peno, untiye. ");
INSERT INTO for_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Pigoya, nawamupisa kamanapa mayama urimuwe: Naeba agu kao'ena puritaosa puma, tigeba agu kao'ena puma miyiyo. ");
INSERT INTO for_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Pigoya, ka'waina aeba ao'mika uma mikenaenawa kasima iyo'maekibi'naba, pipa a'ya'ma to agu kao'ena pikenaenapa asugaikiye. ");
INSERT INTO for_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Piya, yoga uritao pipa pigipa, tigeba naokina'nene urimukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Naeba tigaopa kayokaya kina kantaba kampa pewe. Kayokaya yagaramaba tabe yagarawampa untabaipinti kamana waintipa, pipa kampa abiye. Naeba pipa nabanempatisa kamana abinto, pabi nkawameta uma aborama urimiwaentoka tigama naokina'nene urimuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Pigoya, tigeba naepa kampa naba punatantane. Naeba tige tiba puritantone. Pika tigeba wama yogara umima au'wa maema aboraiyema, uritantone. Pigoya, maema au'wa aboraigina waiyaba waiyeno. Piya puntiri nae nagera naba esotakibe nkawameta timikiye. ");
INSERT INTO for_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Piya, naeba ago kamanapa maya urimuwe: Tigeba tiyokina agu kao'ena puwaitaiyo, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Pigoya, mampabisa kina'mi igobi puritaigiripa, mayama abiyo: Wa'ega Yagara aepa paipa pabiyama agobima igobi potantakini pewe, yiyo. ");
INSERT INTO for_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Pigoya mampabisa kina'mi ige aruyenabi uma pasesinta, kayone puritasine. Naeba pipa ige aruyenabisa kibi'ma tiba puntogiri to awameta puma miyegini igobi puritawe. ");
INSERT INTO for_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Naeba kamana ka maya urimintona, pika napiyiyo: Kayokaya yagarama tabe yagarawa asugasima mikenaenaba kampa waintiye: Piya, igeba naepa igobi punatama ma'ena punatantakini, tigepa igobi puritama ma'ena puritakibewe. Igeba nae kamanapa a'a-o untakini, tigepa pabiyama a'a-o uritakibewe. ");
INSERT INTO for_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Naba unatanti'nama nkagegaba kampa napiyekini naeka uma pabiya igobi puritakibewe. ");
INSERT INTO for_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Naeba igetiba kampa tumima agoba kampa uwaimintosinta, aguntaena kampa wainta miyesine. Pigoya ago aborama awaimintone. Ibaba aguntaenawai kakakena kipa kampa waiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Piya, ka'waina aeba agobi punatakibi'naba, nabanempa pabiyama agobi potakiye. ");
INSERT INTO for_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Naeba abakawaipipa toma toma ntugaba ka'isa kina'miba pesa puma yogaba kampa asugasima puntosinta, aguntaenawai kampa wainta miyesine. Piya, mapa kana yugaba ago pogini agawaentiniba uwa naepa igobi punatantini, nabanempapa pabiyama kaga igobi potawe. ");
INSERT INTO for_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Piya pegana mono isapipa kamana ka mayama wainti, pi'na esegi piye: Igeba uwaraka'ya igobi punatantawe, iye. Pipa iba esegi piye, untiye. ");
INSERT INTO for_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pigoya, esegi puritakena taga kamana'ama Nkawamusa, nabati mintika, aepa otakana nabatisa tumima agonepa uma aborakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Piya, tigeba yoga agobintotasa naege mirite kanantasa puma, pabiyama agonepa uma aboraiyo, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Piya untana to maya untiye: Timatiti'enari kaisanagaba kampa nabegi, ma kamanapa urimuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Piya, mono namapisaba tigarubantini, agaro ntaganto tiyeguma kaintini puma: Kotinta aogi yuga pune, uma piya pikibewe. ");
INSERT INTO for_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nabake naeke agoresipa kampa abekini, tigepa pabiya puritakibewe. ");
INSERT INTO for_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Naeba kamana maru aborama urimopa, pi ainti aborakiripa: Aeba pika pai uramintine, yiyo. Piya, paipa tigege uwa minta, karu'enaba kampa urimintone. Titate wakena punta, piya urimuwe, piya untiye. ");
INSERT INTO for_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Piya untana Isu to maya untiye: Mapa unatanti'na aeti wakena poganaba, nana pegina tigepisa ka'wainaba: Kaeba aeta wakibenema, kampa nabigaye, a. ");
INSERT INTO for_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Piya kamana urimo'na, uwa tintabaipintiba tintara'enamaba pumaeyagiri kampa nabigawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Naeba taga kamana ukuwa abiyo: A'wae puma ikubopa, pipa tigeti au'wa aboranema ikuwe. Piya kampa iyosinta, pipa tige tiyo'maekenaenaba kampa tumisine. Imaba, naeba otakana tigetiba tumikiye. ");
INSERT INTO for_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tumekini, wasanami nkagowai maema mayama abikibewe: Aguntaena waintiya, arupuyena waintiya, a'ya'waemaenama nkagowa maema aborakenaena waintiye, ukibewe. ");
INSERT INTO for_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Aguntaenama nkagoba mayama waintiye: Nae kampa naega'ma imatiti pemi'naba aguntaenaba piye, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Arupuyenama nkagoba mayama waintiye: Naeba titate nabati arupu puritakenaga iyekiri, tigeba to kake kampa nagakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ago maema aborakenaenaba pipa mayama aborakiye: Mampabisa tabe yagara ae aebasanakana, pi'na nkagoba aborakiye, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Naeba uwoma kamana waintemipa, pipa ma kanabi urimekiripa ayama maewaekibewe. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Taga kamana'ama Nkawamusa'amaba, aeba pipa tumimagina asi nasi tagantanaba puriyakikiye. Piyama ae'wa nkaumabisaba kamanapa kampa urimikiye. Uma abintemisa suma aborama urimikiye. Piya, ainti pi aborakibintanagaba pipa uma aborarimikiye. ");
INSERT INTO for_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Pipa naetisa kamanapa mae u'ma aborama urimikiye. Pintanamaba nae tabe nagi aborakiye. ");
INSERT INTO for_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Nabati a'ya'waemaena waintemi, pi'na nkagoba naewe. Pika: Aeba nae kamana maema aborama urimikiyema, urimuwe, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Piya untana Isu to maya untiye: Uwaena yaganto waintika, pi a'ya peka wakiri naguyosagakibewe. Piya, pi'na nkaboboriba kanapa agaronkanto waintika, a'ya peka kanakiri nagakibewe untiye. ");
INSERT INTO for_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Piya yogini, ka'isa abagi kina'miba mare-u me-u puma maya untawe: Aya kamanaka mayaba iye: Uwaena yaganto wainti, pipa a'ya peka wakiri naguyosagakibewe, iye. Pi'na nkaboboriba kanapa uwaenanto waintika, pipa a'ya peka kanakiri nagakibewe, iye. Piya, to kapa: Nabati ikuwe, yipa, ayagabaya iye, untawe. ");
INSERT INTO for_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Piya untini to kake maya untawe: Kanapa agaro ntaganto wainti, pipa nanaga iye. Ae yemi kamana'ama nkagoba taeba kampa napiyune, untawe. ");
INSERT INTO for_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Piya untini abigakena puguna, Isuba igabebe puntana maya uwaimintiye: Kamana maya urimoka uma abewe: Agaro ntaganto waintika, pi a'ya peka wakiri naguyosagakibewe. Pigoya pi'na nkaboboriba pabiyama agaro ntaganto waintika, pipa a'ya pekapa kanakiri nagakibewe yo kamana mare-u me-uba pewe, a. ");
INSERT INTO for_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","We, naeba tagaka urimukuwa abiyo: Tigeba tabe kube'ena puma tintara'ena pigini, mampabisa kina'miba i'mu pikibewe. Piya pigina tige tintawamaba iba kunta pumagiri, aintiba a'wae puma tabera ti'muntana pikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Pigoya, waya ka'waina aeba yagara yakari pikena kana aboraginaba tabera aukiye. Pabigo yagara yakari potagina, aukemintanagaba toba kampa napiyikana, yagara aboramika anta asoya puma a'mu piye, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Piya pemisa puma tigeba ma kanabipa tintara'enabi mikibewe. Mintigi, to kake a'wae puma ampa tigakiripa, tinta asoyaena aborakiye. Pigoya, pi tinta asoyaenaba ka'wainaba kampa tipatikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Piya, pi ntagaba ka'enagaba kampa nabigakibewe. Kampaye. Naeba tagaka urimukuwa abiyo: Tigeba nae naba a'ya'waemaenaga esotaiginaba nae nageraka uma aborarimikiye. ");
INSERT INTO for_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Paipa tigeba nae nage umaba kampa aisuma maentane. Pigoya mapa nunamu uma maeyigina, tinta asoyaenarimpaba aborama abae peno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Pigoya, Isuba to maya untiye: Kamana urimita kanama mintantopa, pipa meto kamana urimintone. Piya, aintiba meto kamanapa to kake kampa urimukuwe. Naeba nabanempa nkago uwa aborama urimukuwe. ");
INSERT INTO for_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Pigoya, pi ntagaba tigekaba naene kampa nunamu yekiri, tigeba nae nageraka nunamu ukibepa nababa aewa napima tiyo'maekiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Naeba Kotitisa tuminto, pi kamanapa abibebe pu u'ma, agu kao'ena punataka naba aeba pabiyama agu kao'ena puritama tiyo'maekiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Pigoya, naeba nabapa atate mabi tumintone. Pika mampaba atate nabati to kake ikuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Piya yogini abagi kina'miba igeba maya omintawe: Mapa meto kamanapa kampa yempekana uwa aborama uramene, untawe. ");
INSERT INTO for_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Piya, kaekaba mayama abune: Wasanamiba kabigasanaga kampa iyobi pempene. Kaeba a'ya'waemaenaba abiwaeyene. Piya peka kaeba Kotige kaga miyempetisa kanantampenema abima kaega'ma tamatiti pune, untawe. ");
INSERT INTO for_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Piya yuguna Isuba maya uwaimintiye: Ibaba taga naega'ma timatiti punatawo. ");
INSERT INTO for_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Abiyo. Kanapa ka waintikana pi agaro aborakiniba, naepa natate aibarara puma kuma'waiti wagana puwaewakibewe. Pigoya, nataigipa nabinepa kampa mikubokana, nababa naege mikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tigeti paruyena waiyenema, pi kamanapa urimuwe. Piya, tigeba mabipa kuntaenabi mikibewe. Pigoya, naeba mampabisaenaba ago asugasuwe. Pika napima tigu'amaba esegi puma waiyeno, Isu piya untiye. ");
INSERT INTO for_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Pigoya, Isu aeba pi kamanapa uma a'ya atate, mantari aoma urintana, maya uma nunamu untiye: Naba, kana'nepa ago aborawaya, kaeba yagaraga nae nageba maema asaga'yuyega, naeba pabiyama kae kage maema asaga'yuyeno, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Piya, kaeba maga maga a'ya'ma kina'mi tabe agowai unatantampene. Piya puntana wasana naeti iba puwaitantampe nkawameta igepa miyaba'ena aborama imoma unatantampene, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Pigoya miyaba'enama nkagoba pipa maya ki waintiye: Wasanami Koti taga ka'antowema kaekaba napintini, piya naekaba unatantampe. Isu Karaisitiwema piyama napiyiginaba, miyaba'ena aborawaimeno, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yoga unatantampepa, pipa puma a'ya pumagi mabi kageba asaga'yuyuwe. ");
INSERT INTO for_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pigoya, maba kampa aborantoga, manta e'wasaenanentaga mintantona, pabiyama to kake a'wae puma namega maema kaora miyeno, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Piya untana to maya untiye: Mampabisa kina ibabuma namintampe kina'mi, kae agogapa aborama uwaimeno. Igeba kae kaokina mintuguna igepa nae namintampena. Pika igeba kae kamanapa aogima aegarantane. ");
INSERT INTO for_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Piya, a'ya'waemaena wainatantipa pipa kaetisaena manane. Igeba pipa abibebe pewe. ");
INSERT INTO for_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kaeba a'ya'ma kamana unamintampepa, pipa naeba ago uwaimintogini, igeba abima maentane. Piya, paipa kaege kaga minta kanantokaba igeba taga abibebe pewe. Piya, kae unataugu naeba kanantokaba igeba abima imatiti pugatawe. ");
INSERT INTO for_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Naeba igeku uma nunamu ugatauwe. Namu'isa kina'mika umaba kampa esugatauwa, namintampe kina'mika uma esugatauwe. Igeba kae kaokinane. ");
INSERT INTO for_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Piya, a'ya'ma kina'nepa pipa kae'enawe. Piya, a'ya'waema kinakapa pipa nae'enawe. Pika igeba nae nageba maema asaga'yukenaena aborama waintiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Pigoya, naeba mabi mikenaenane pabigo a'ya piye. Igeba pipa mabi amato puma mintigi, naeba kaeti ikena puwe. Aota naba, kaeba aogima kabiwaitagini, igeba kae kagera miyiyo. Pi kagiba ago nae namintampene. Piya tasigeba ka'ena pumagira miyomesa puma, kaeba kabiwaitagini, igeba ka awameta mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Pigoya, igege minta, kae kageraka kayone puwaitantone. Pi kagiba ago nae namintampene. Piya puma kiya kabiwaitauwagini kapa kampa itama ataenaba puntane. Piya, mono isa'ama nkau'wa aborasanaga, a'abibisa yagara, ka'wainanto ataena puntiye. ");
INSERT INTO for_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pigoya, ibaba kaeti ikena punta, mata'i kamana'ne piya uwaimekana nae na'muntananepa igeti ta'ema wama pumaewakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Piya, naeba kamanaka uwa'imogini maema miyeginiba, namu'isa kina'miba igobi puwaitawe. Naeba mampabisaba kampa mintuwe. Igeba pabiyama mampabisaba kampa mintagini piya igobi puwaitawe. ");
INSERT INTO for_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Piya, kaeba mabisa ibabomaba kampaye. Aguntaenaraka iyo'maeyoma ugamuwe, unti untiye. ");
INSERT INTO for_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Piya, nabupa mabipa kampa pantiye, piya pabiyama igepa mabipa ibupa kampa pantiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Pigoya, kae taga kamana agoba ige igupi aota atagana waiyeno. Kamanakapa pipa taga kamanane. ");
INSERT INTO for_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Paipa kaeba unatauku, kanama mampabisa kina'mi ige abakapi ampa mintantosa puma, pabiyama naeba uwaitakini igeba wama mampabisa kina'mi ibakapinti umikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Piya, naeba nagu'naumaba kaeti utawaitama igepa iyo'maeyuwe. Igeba tagantana puma igu'imaba kaeti ataiyema, piya puwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Pigoya, naeba ige'amanakaba kampa esugatauwe. Mono uwaimekini abima naega'ma imatiti punatakibe kina, igeka kaga esugatauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Piya, igeba igupa kata atama atokaema miyiyema, ugamuwe. Naba, kaeba naege miyeka, naeba pabiyama kaege miyuwe. Pabiyamagini igeba tasigege kaga misanaga nabiye. Piya pigini, mampabisa a'ya'ma kina'miba ige agowai igama, kae unatauku kananto, pipa abima kaega'ma imatiti piyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Tasigeba ka'anto mintuse. Pabiyama igeba igupa kata atamagini miyiyo. Piyama miyiyema e'wasaenaba namintampe, pipa imintone, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Naeba igege miyekana kaeba naege miyegini, igeba igutasa paibu'ma atokaema paga'ena puma miyiyo. Piyama miyigini, namu'isa kina'miba ige agowai igama, kae unatauku tuminto pipa abibebe piyo. Piya, naepa agu kao'ena punatantana, igepa kaga puwaitampe, pipe kaga abima esegi piyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Naba, namintampe kina igeba nae mikubota kaga misanaga nabegi, ugamuwe. Pigoya pai maba kampa aborantogana agu kao'ena punatamagina e'wasaena namintampe, pi naege mima agama i'mu piyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Naba, aogiyenama nkagogawe. Mampabisa kina'miba kaekaba kampa abibebe puntawe. Piya, naeba kaekaba abibebe pogini, naokina'miba kaega unatauku tuminto, pipa abima esegi pewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Naeba kage kawaga kamanaka uma aborawaimintosa puma, to kake aborama uwaimima mikuwe. Piya, agu kao'ena nae punatantampesa puma, pabiyama igeti waiyeka kata mikubompeka, kamanakapa to kake pabiyama uwaimima mikuwe, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Pigoya Isu aeba pi kamanapa uma a'ya atate abagi kina'wa ibabute kumatisa tumima, Kitoroni wani ta'ema, to mari yoga waintometi pita'i wantawe. ");
INSERT INTO for_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Pigoya Isube abagi kina'wape pita'iba asi nasi aki puma mimi pumekana, Yutasi kuna yagara, aeba pi kana yugaba agantiye. ");
INSERT INTO for_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Pigoya pita'i mintuguna, Yutasiba Parasi aruyenabisabe tabe mono kiye kina'mitisabe irebu kinape ibabogini kane'waipe ma'ena kasupe maete ampa irosantawe. ");
INSERT INTO for_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Irosauguna, Isu aeba pintana potakenaenaba pipa abintanaba, igori wama: Tigeba keka aguyosagawema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Piyama ibigaogini igeba: Isu Nasareti kumatasa yagaragawe, untawe. Piya yuguna: Naeba pipa maye, untiye. Pigoya, Yutasi kuna yagara aeba igege kanama ibakapinti ampintantiye. ");
INSERT INTO for_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Pigoya Isuba: Naeba pipa maye, uwaimoginiba igeba ika'isa wama ware'nantawe. ");
INSERT INTO for_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Piya puguna to kake: Tigeba keka aguyosagawema, ibigantiye. Piyama ibigaogini igeba: Isu Nasareti yagaragawe, untawe. ");
INSERT INTO for_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Piya yuguna Isuba maya uwaimintiye: Naeba ago urimuwe. Naeba maye. Naeka naguyosagantiripa ma kinapa itaigini waiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Piya yogana kamana maya unti, pi nkau'wa aborantiye: Namintampe kina igepa kapa kampa itakuwe unti, pi nkau'wa aborantiye. ");
INSERT INTO for_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pigoya, Saimoni Pita aeba kasopa urintome, pi abamu kantibisa a'yubumagina tabe mono kiye yagarama kayokaya yagarawapa aeguma ayatakantisa agiba arisakaintiye. Kana yagarama nkagewapa Maokasiwe. ");
INSERT INTO for_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Piya pogana Isuba maya omintiye: Kasokapa kabamu kantibinti maema paka puro. Nabanempa nauki nakiyena atanatantintanaba pipa a'a-oba kampa ukuwe, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Piya puntini, irebu kinape kiyawaipe Yuta kina'mi nkirebu kinape, igeba Isupa araku'ma iga'narasa kirokaemagini, ");
INSERT INTO for_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anasi ntamapinti ababute wantawe. Piya, pi kabubi Yuta kina'mi paitama mono kiyewaimpa, agewapa Kayapasi, aeba Anasi nkaraga maentiye. ");
INSERT INTO for_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Pigoya, Kayapasi aeba Yuta kina Isuka maru maya uwaimintiye: Ka yagarama pu'magina a'ya'ma kina iyo'maeyakana kanarasano, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pigoya Isu ababute waugunisi, Saimoni Pitabe to ao'yagara ka'wainage aega'ma ika'i wantase. Piya, ao'yagaramaba tabe mono kiye yagaraba agantika, aeba Isu aega'ma nama nkantabaipinti kaga uma pasintawe. ");
INSERT INTO for_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pigoya, Pita aewa pi kagisa awari asima mintantiye. Piya pogana, ao'yagaraba tabe mono kiye yagarama ntamapinti mintometisa tumima, kagisa kabe kiye araga aeba omogana, kabe ai'ataogana kagisa kagopinti ababogana. Pita uma pasintiye. ");
INSERT INTO for_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Piya pogana kabe kiye araga aeba Pita agama maya omintiye: Kaeba pipa mare ntagarama nkabagi kina'mi nkaruyenabisawe, untiye. Piya yogana aeba: Naeba kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Piya, kayokaya kinape irebu kinape igeba esiba ibogini, yaku kaema tapimagini mintuguna, Pita aeba ige ibakapinti wama pabiyama yakuta tapintiye. ");
INSERT INTO for_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pigoya, monota paitanta kiye yagaramaba Isupa abagi kina'wakabe kamana uwaimintana punti, pika abigantiye. ");
INSERT INTO for_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Abigaogana, Isuba maya kamana a'wae pomintiye: Naeba kamanapa a'ya'ma kinapa aborawaimone. Naeba kakamaba kampa yoka, Yuta kina'mi uwa mono namapipe tabe mono namapipe aki pumagini mintagapa kamanapa uwaimi puntuwe. ");
INSERT INTO for_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Pipa nanaga naepa nabigane. Kamana uwaimogini abe kina, igeka yegini yosa puma ugamigina abo. Igeba kamana'ne uwaimogini ago abintawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Piya yogini, irebu kina mintume igetisa ka'waina Isu nkgemiti aema maya untiye: Kaeba paitanta mono kiye yagaraba nanaga piya kamanapa omene, a, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Piya yogana Isuba maya kamana untiye: Antage kamana yekanapa agoba yega abeno. Piya, aogi kamana yoganapa nanaga naeguyene, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Piya yogana, Anasiba yogini Isupa aya kirokaetama monota paitanta kiye yagara Kayapasi aeti ababute wantawe. ");
INSERT INTO for_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pigoya, Saimoni Pitaba aeba pi ntakuta tapima mintogini, abigama maya untawe: Abagi kina'wampi ige aruyenabisa kapa kaewoma, abigantawe. ");
INSERT INTO for_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Abigauguna uwame uma: Naeba kampaye, untiye. Piya yogana, paitanta kiye yagarama kayokaya yagara ka, Pita age arisakainti ae agaya aeba maya untiye: We, kaeba yogabinti aege kaga mintaka kagaone, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piya yogana, Pitaba to kake a'a-o uma esegima uwame yogana, pabigo kokore aga untiye. ");
INSERT INTO for_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pigoya marogini, Isupa Kayapasi ntamapintisaba ababute paitanta kiye yagarama ntamapi intawe. Igeba Yuta kina'mi nkakumparanta'ena akayayekini Pasoba naninta a'a-o uragaisanagawemaba wasanami kiye Pairati ntamapintiba kampa intawe. ");
INSERT INTO for_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Piyamagini igeba abe'i mintuguna, Pairatiba irosa'ma igeti tumima ibigama maya untiye: Ma ntagaraba nana aguntaena pegiri ababute kanawema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ibigaogini igeba maya untawe: Aeba agunta yagara kampa mintemisinta, kaetiba kampa ababute kanaompesine, untawe. ");
INSERT INTO for_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Piya yuguna Pairatiba maya uwaimintiye: Tigeripa ababute wama ago kamanati wainti nkawameta kamanapa otaiyo, untiye. Piya yogini Yuta kina'miba maya omintawe: Pipa ka yagara aeguma kaikenaenaba taepa akutatantane, untawe. ");
INSERT INTO for_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Yuta kina igeba piya yuguna Isu aewa purikena kamana unti, pi ki'ama nkau'wapa aborantiye. ");
INSERT INTO for_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pigoya, Pairatiba nama nkantabaipinti ima Isu nkagega'e uma maya untiye: Kaeba taga Yuta kina'mi Nkwa'ega yagaragawoma, abigaogana, ");
INSERT INTO for_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Isuba maya untiye: Pi kamanapa kaega kaumagapisa yepera ka'isa kina'mi ugamegana unatane, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Piya yogana Pairatiba maya untiye: Pipa naeba Yuta yagaraba kampaye. Kaeka kaokampibe tabe mono kiye kinakampibe igeba kababute naeti mekatawa, kaeba nana pekiniwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Piya uma abigaogana Isuba maya untiye: Naeba mampabisa tabe yagaraba kampaye. Piya, mampabisa tabe yagara mintosinta irebu kina'nempiba akentana pumagini nao'maeyagini Yuta kina'miba ayamagini nayakuresine. Naeba mabisa tabe yagaraba kampaye. Naeba tonaraka kabiyone, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Piya yogana Pairatiba maya untiye: Pigoya kaeba aota Wa'ega yagaragawo, yogana, Isuba maya untiye: Pabigo yene. Naeba taga kamana mabi uma aborakena tumima Wa'ega yagara mikena aborantone. Piya, a'ya'ma kina'mi taga kamana wasiye kina'mi nawamupisa kamana'ne abewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Piya yogana Pairatiba maya untiye: Pipa nana taga kamanane, untiye. Piya utegina, Pairati abe'i irosa'ma to kake Yuta kina'miti tumima maya uwaimintiye: Naeba ma ntagarama kaintawakaba aguyosagauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pika ka yekiri abiyo: Tigeba Pasoba yaga yega, taeba iga'na kina kapa iyoba timi pompene. Piya, mapa abigini kanarasakapa Yuta kina'miti tabe yagararipa iyoba'atakana uwa miritanoma, ibigantiye. ");
INSERT INTO for_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Piyama ibigaogini, igeba tabe kamana uma maya untawe: Kampaye, ae'nane. Parabasi iyoba tamo, untawe. Pigoya Parabasi aeba to kina'mintanaba uwa a'yugu maentana pome kamparaga yagarawe. ");
INSERT INTO for_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pigoya Pairati piya yogini, irebu kina'miba Isu eru kasutasa aeguntini, ");
INSERT INTO for_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ake iga'na maema antarage ima a'nota taminoku'ena potantawe. Piya puntini, wa'ega kina'ma tete kai kaga maema potantawe. ");
INSERT INTO for_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Piya potamagini agora arabama mima amiyo puma: Yuta kina'mi Wa'ega, aya pene, untawe. Piya untini aowabi aeguntawe. ");
INSERT INTO for_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Piya puguna Pairatiba Yuta kina'miti to kake irosa'ma maya untiye: Naeba otaogana tigeti tumemipa, naeba kaintanawakaba aguyosagauwa, tigeri agowapa agaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pigoya, Isuba ake taminokupe tete kaibe potaumentaga irosa'ma abeta tumpintogana Pairatiba iyakima: Ma ntagaraga agama aogima napiyiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Pigoya tabe mono kiye kina'mibe irebu kina'mibe igeba agategini, esegi kamana uma: Maripora aeguyo, maripora aeguyo, untawe. Piya yuguna, Pairatiba iwamuta u'ma maya untiye: Naeba kaintanawakaba aguyosagauwa, tige tigeri ababuma mariporapa aeguyiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Piya yogini Yuta kina igeba maya untawe: Aewaka naeba Koti Ntagaranawe yemi'na, pipa piya kinapa pu'waiyoma, ago kamanatepipa untaka, purekana esegi peno, untawe. ");
INSERT INTO for_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Piya yuguna, Pairati aeba pi kamana abima to tabera aekuru puntiye. ");
INSERT INTO for_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Piya puntana, to kake nama nkantabaipinti ababute, abigama maya untiye: Kaeba aetasa aboratampene, untiye. Piya yogana Isuba kampa a'wae pomintiye. ");
INSERT INTO for_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Piya pogana Pairatiba maya omintiye: Kaeba kamanapa kampa unameno. We, naeba yekana mikenaenabe purikenaenabe esegiyenaba pipa namintapa, kaeba kampa abeno, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Piya yogana Isuba maya omintiye: Inatisa yagara Koti kampa owe ugatantemisinta, naepa ka'ena kampa punatampesine. Piya, kaeti unata kina'mi kaintanawaimpaba kaepa asugagasaye, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Piya yogana, Pairatiba pi kamana abite Isu uwa atakena yogini, Yuta kina'miba imo kamana umagini maya untawe: Kaeba kana yagara ae uwa atateginapa, to kake Sisa nkao'yagaraba kampa mikibene. We, aewaka tabe yagara mintuwe yemipa, tabe yagara Sisa agobi potaye, untawe. ");
INSERT INTO for_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pairatiba pi kamanapa abite karu pumagina, yogini Isupa ababute tumuguna kamana uma a'ya pikena yabaewata mara'mintantiye. Pi kana yabaeba yabatasa yarage pumarantane. Pi kana yaragewama nkageba Iburu kamanapipa Kabatawe, untawe. ");
INSERT INTO for_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pigoya, Yuta kina'miba igeba marekiniba Pasoba mikenagini ase'yo puma wantawe. Piya puguna kagi abebe pogana Pairatiba Yuta kina maya uwaimintiye: Tabe yagararipa mampaya agaiyo, untiye: ");
INSERT INTO for_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Piya yogini igeba tabe kamana uma maya untawe: Aeba kampa miyeno, kampa miyeno, maripora aepa aeguyo, untawe. Piya yuguna Pairatiba: We, tabe yagarari yekana maripora purenema yewo, untiye. Piya yogini, tabe kiye kina'mi igeba maya kamana a'wae pomintawe: Aeba tae tabe yagaraba kampaye. Aroma kumatasa Sisa ka'anto ae miratantiye, untawe. ");
INSERT INTO for_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Piya yuguna Pairatiba abima paru puwaitamagina, Isu maripora purenema owe uwaitantiye. ");
INSERT INTO for_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pigoya, irebu kina'miba igeba maripo maema Isu amuguna aesaga'urogini, maba ka agewapa A'no nkayampu, Iburu kamanapipa Korikota, pita'i ababute wantawe. ");
INSERT INTO for_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ababute wama maripora pita'i aeguntawe. Piya, agunta yagara taraba kaga isiyeguma to auka'i to auka'i puwaisitantini Isupa isibakapi atama arabawaitantawe. ");
INSERT INTO for_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pigoya, Pairati yogini Isu nka'nota maripora mayama awa'ena kaema atantawe: Isu Nasareti kumatasa, Yuta kina'mi Nkwa'ega Yagarawema, kaema atantawe. ");
INSERT INTO for_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pigoya, Isu aegunta mpaba pipa tabe kuma agora waintomeka Yuta uwoma kina'mi pita'i wagana puntiniba, pi kana awa'enaba aisuntawe. Pigoya kana awa'ena kaentapa Iburu kamanapisabe Aroma kamanapisabe Kariki kamanapisabe kaemarantawe. ");
INSERT INTO for_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Piya puguni, Yuta tabe mono kiye kina'miba igeba Pairati maya omintawe: Kaeba Yuta kina'mi Wa'ega yagarawemaba, a-kaeyo. Piyama: Naeba Yuta kina'mi Wa'ega Yagaranawe, ae'waka untineba, kaeyo, untawe. ");
INSERT INTO for_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Piya yuguna, Pairatiba: Ago kaegasoka uwa waikiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Pigoya, irebu kina'miba Isu maripora aeguntini, autasaena maema a'yigimpagini tarawa tarawaki'ena puma urintawe. Piya, tabe kaiwapa puguninta'enaba kampa waintogini, ");
INSERT INTO for_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","maya untawe: Pipa paga waintika atugekanaba ataena pusanaga, tete'ena puma ka yagarama maeyano, untawe. Piya puguna mono isapisa kamana ka mayama wainti, pi'na esegi puntiye: Igeba nautasaena pako purintini, kainetapa tete'ena pukibewema, unti, pipa esegi puntiye. ");
INSERT INTO for_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Piya, irebu kina'mi piya puntawe. Piya puguna, Isu maripo agobipa mayama mintantawe: Anowampawa, anowampa nka'nanto Mariya aeba Keropasi nkwaena, to Mariya Matara kumatasawa, sumagini mintantawe. ");
INSERT INTO for_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Pigoya Isu anobe abagi yagara abugaome naeba mintuwaguna tasigategina, anowampa maya omintiye: Waya, mapa yagaragane, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Piya untana, abagi yagaranapa maya unamintiye: Mapa kanogampawe, untiye. Piya unamoga naeba pi ntaga Isu nkanopa agamagi ababuma aogi potantuwe. ");
INSERT INTO for_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pigoya Isu aeba yogawapa a'ya pogana abite mono kamana'ama esegi penema maya untiye: Naeba wanika nabiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pigoya, kankabe ka asa wanipa awaitama waintogini, kai atuta maema ae u'magini asara kitama awamuta mayotauguna nantiye. ");
INSERT INTO for_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Pi asa wani nantana kega'e uma: Pabigo ibanto yoganepa a'ya waye, untiye. Piya yogana a'nopa kirosaogana aumawapa mesugaintiye. ");
INSERT INTO for_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pigoya, pipa Pasobarasaena maema aogi pikena yagagini, pi ntagaba tabe sabatigini, Yuta kina'mipa kana wasana maripora iyegunta kina sabatira waisanagaba kampa ibuntiye. Piya pogini, igeba Pairatiti wama igisaba aega'yuma akitama kaikenaga uma abigantawe. ");
INSERT INTO for_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Abigauguna, owe yogini, irebu kina igeba agunta yagara tara Isuke isiyegunta ka'waina ayampuba aega'yuntini, to ka'wainapa pabiyama aega'yuntini puntawe. ");
INSERT INTO for_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Piya puta Isuti ampa irosa'ma agaumepa: Aeba ago pu'wantiye, umagini agisaba kampa aega'yuntawe. ");
INSERT INTO for_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Piya puguna, irebu yagara ka'waina ayatabi irerasa aerasiba ataogana, pabigo korape antipe pagintiye. ");
INSERT INTO for_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Pigoya, naeba pipa naonepisa agabebe puntoka, ma kamanapa taga suwe. Eya, naeba abintuwe. Pi taga kamana yopa, pipa tigeba abibebe puma timatiti puma aegaraiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Piya, mono kamana ka mayama wainti, pi'na nkau'wapa aborama esegi penema pintanaba aborantiye: Igeba ayampuba kampa aega'yukibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Piya, mono kamana to kapa mayama waintiye: Igeba ayata aerasabantanati iyomarakibewe, pi unti kamana'ama nkau'wapa aborantiye. ");
INSERT INTO for_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pigoya, Yosepe Arimatiya kumatasa yagara aeba Isu ao'yagara mintantiye. Pigoya, Yuta kina'mika aekuru puma amatiti'enawapa kampa aborama kakama mintantiye. Pigoya, a'ya puwaogana pi ntagara aeba Pairatiti wama Isu ntabaewa akitakena uma aborama omintiye. Omogana, Pairatiba owe otaogana wama iyobantiye. ");
INSERT INTO for_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Pigoya Nikotimasi, aseka Isuti wanti ntagara, aeba aogi agunta masawaepa kuntaenawapa 50 kirogaramurasa maete wama uma ao'maema, ");
INSERT INTO for_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Isu nkauti pai'atama wae kairasa asagakokintase. Piya, Yuta kina'miba wasana yabaeba pabiya puwaitabuntawe. ");
INSERT INTO for_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Pigoya Isu, aegunta mpa nkawamoriba yogaba ka waintantiye. Pita'i yabapinti ka wasana aruwema ku'maranta waintantiye. Pita'iba wasanaba kampa kaiwaitantane. Pipa uwa kasa'ena waintantiye. ");
INSERT INTO for_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pigoya, Yuta kinapa Pasoba yaga agarosaogini, pikana wasana aruba agarota waintoginisi, isigeba, Isu nkaupa maete pita'i metantase. ");
INSERT INTO for_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pigoya, marusa yaga sontara, Mariya Matara kumatasa wae aeba aruri agakena abaya aseka irosa'ma wantiye. Wama uma irosa'ma agaomepa, yabapa a'waiwaogana uwa waintantiye. ");
INSERT INTO for_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Piya pogana, agate karu'ena wama Saimoni Pitape to ka Isu abugaome ntagara naepe uma urasimima maya untiye: Wa'ega yabaewapa ago isu'urewe. Piya pega taeba aguyosa'ma kunta pune, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piya yogira, Pitabe pi to ao'yagaranabe tasigeba wasana aruri wantuse. ");
INSERT INTO for_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ke'iba karu'ena wama naeba Pitapa ogaite karu'ena wama uma irosantuwe. ");
INSERT INTO for_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Uma irosa'maba agepintiba kampa uma pasinta uwa uma ibikama agauwapa, wae kai asagakokimaranta'enamana waintoga agantuwe. ");
INSERT INTO for_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Piya pogana, Pitaba ainti kanama uma irosama, antabaipinti uma pai'ma wae kai asagakokimaranta'ena mana agantiye. ");
INSERT INTO for_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pigoya, Isu nka'nota asaetaume kaiba to ka'isa kaigeba kampa waintogana, abiwa akarakima ataogana to ka auka'i waintogana agantiye. ");
INSERT INTO for_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Piya pogana ao'yagara naeba maru arura uma irosauwapa, uma pai'ma pabiyama agawaemagi abibebe puntuwe. ");
INSERT INTO for_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Pigoya, Isu purintapisa aogama asikiyema, mono isapisa kamana ka wainti, pipa kampa napintuse. ");
INSERT INTO for_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Piya pumagira, tasigeba to kake a'wae pumagira kumati wantuse. ");
INSERT INTO for_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pigoya, Mariya aeba wasana aru agora mima kube'ena puntiye. Kube'ena puntana wama awara uma ibikama agaomepa, ");
INSERT INTO for_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","enisore tara wae kaiwaisintaga mintusuguna isigantiye. Ka'wainaba Isu nka'no ataumeti miyogana, to ka'waina agisa ataumeti mintantiye. ");
INSERT INTO for_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Pigoya, isigeba mayama untase: Waya, kaeba nanaga kube'enaba penema, abigausuguna, aeba maya untiye: Wa'egane isu'urite tori wagasaga aguyosagauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Piya ute a'wae puma Isu aewa agantiye. Agantanaba Isu aowarapa aogimaba kampa agabebe puma agantiye. ");
INSERT INTO for_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Piya pogana, Isuba abigama maya untiye: Waya, kaeba keka aguyosa'ma kube'enaba pene, untiye. Piya yogana, aeba kana yogawama nkaba mintiyema, napima maya omintiye: Tabe yagara, kaeba wasana isu'ma tori maete metantanapa yega abite wama umaeyano, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Piya yogana Isuba: Mariya, untiye. Yogana aeba a'wae puma Yuta kamanapisa: Arabonai, untiye. Pipa tae kamanapisa: Tisawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Piya yogana Isuba maya omintiye: Nabanempatiba kampa intuwa, nautapa a-ntaukaya po. Kaeba wama naokina maya uwaimo: Nae nababa pipa tige tibawe. Piya, nae Kotiba pipa tige Kotiwe. Pika aeti ikuwe, iyema uwaimo, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Piya omogana, Mariya Matara kumatasa wae aeba a'wae puma wama, abagi kina'wa maya uwaimintiye: Naeba Wa'egapa agauwe, utegina kamana omome kamanapa uwaimintiye. ");
INSERT INTO for_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Pigoya sontara aseyogini, abagi kina igeba Yuta kina'mika iyekuru puma, aki puma nama kabe kitama mintantawe. Mintuguna Isuba ige ibakapi ampa aborama mima maya uwaimintiye: Paruyenaba tigeti waiyeno, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Piya ute ayatarabe ayatabe iyakintiye. Piya pogini, abagi kina'miba igeba Wa'ega agamagini intawamaba aogi puntiye. ");
INSERT INTO for_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Piya puguna to kake uwaimintiye: Paruyenaba tigeti waiyeno, untiye. Piya untana to maya untiye: Naba nae unatantemisa puma, pabiyama naeba tigepa uritauwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Piya untana pukawaitamagina: Tigeba Aota Awamusa maeyiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Piya untana to maya untiye: Tigeba wasanami nkaguntaenawai uma asu'a puwaigasiginaba asu'a puwakiye. Kampa uma asu'a piginaba waewaitakiye, Isu untiye. ");
INSERT INTO for_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pigoya, Isu abagi kina'wa aborawaiminti ntagaba, ka abagi yagara nagisarisa tara tumpaema ige aruyenabisa, kampa mintantiye. Ae agiwapa Tomasiwe. To ka agiwapa Agayawe, omintawe. ");
INSERT INTO for_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Piya, ka'isa abagi kina ao'miba igeba awaga kamana omima: Taeba Wa'ega agaune, untawe. Piya yuguna maya uwaimintiye: Naeba kamanatipa abogana taga kantaba kampa piya. Nae'ne ntaonepisa ayapi antotasa aegunta, pi abura agama nayatasa abura aukaya puma, nayatasa ayatara aukaya puntapa, tagane ukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Pigoya, to kake sonta aboraogini abagi kina igebe Tomasige kaga namapinti aki puma kabe kitama mintantawe. Mintuguna Isuba abakankaipi to kake ampa aborama mintana maya uwaimintiye: Paruyenaba tigeti waiyeno, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Piya untana a'wae puma Tomasi maya omintiye: Kaeba kaya nkamarasa nayata aukaya puma agao. Piya, kayakatasa nayatara aukaya puma agama to kake kagu'ama tara taraba a-puma, naega'ma kamatiti po, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Piya yogana Tomasi maya untiye: Kaeba Wa'egane, Kotinekawe, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Piya yogana Isuba maya omintiye: Kaeba nagamagina kamatiti puma naegarana, a. We, kampa nagama naega'ma imatiti pe kina, igeba i'muntanabi mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pigoya, Isuba to uwoma awame'enaba abagi kina'mi nkiyora punti, pipa ma nkisapipa kampa kaewaentuwe. ");
INSERT INTO for_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kaemaranto mapa pipa mayaga kaemarantone: Tigeba aisuma abima Isu aeba Karaisiti, aeba Koti Ntagara minti, pi kamana abibebe puma ae'wa aega'ma timatiti pikibepa, ae awamuta miyaba'ena maema mikibewe, untiye. ");
INSERT INTO for_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Pigoya, ainti Isu nkabagi kina'wa Taibiriyasi kotu nkawamora mintuguna aborawaimintiye: Aeba ampa aborawaimintipa pipa mayamawe: ");
INSERT INTO for_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimoni Pitawa, Tomasi to ka agiwapa Agaiyawa, Nataniyeri aeba Karariya mari Kena kumatasawa Sebeti ntagara tarawa, to Isu nkabagi yagara tarawa sumagini, piya kina'mi kaga mintantune. ");
INSERT INTO for_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Piya mimagi, Saimoni Pita ao'mipa maya wamintiye: Naeba inoyanta aekena wauwe, untiye. Piya yogi taeba: Taegeba kaga wakune, untune. Piya ute wanipisa karebi ima wantune. Wama umima pi nkasekapa inoyantaba kampa aentune. ");
INSERT INTO for_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Piya puma mintuwakana marogana, Isuba kepari ampintantiye. Ampintogira Isu nkaowarapa kampa aogima agabebema agantune. ");
INSERT INTO for_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Piya puwakana tabigama maya untiye: Yakaraki'nupa, inoyantaripa kapa waintiyoma, tabigantiye. Tabigaogira taeba: Kampaye, untune. ");
INSERT INTO for_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Piya yuwakana mayama kega'e uma uramintiye: Wanipisa karewama nkayatakanti kukopa motama inoyantaba aeyiyo, untiye. Yogi kukopa motauwakana inoyantaba uwoma ira'waiyogira, taeba kanara kampa paibu maete intune. ");
INSERT INTO for_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Piya pumagira, Isu nkabugaome nkabagi yagara naeba Pita maya omintuwe: Wa'egarepa piye, untuwe. Yuwagana Saimoni Pitaba kaiwapa akubotama inoyanta aeyometisa, pi Wa'egawe kamana abite autasaenaba maema purite wanipinti pa'yo puma tumima wantiye. ");
INSERT INTO for_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pigoya, abagi kina to ka'isa taeba pi kepari awamori mintumetisa wanipisa kareba pubasanaurite kukopa inoyantage paiburite wantune. ");
INSERT INTO for_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Pigoya, kepari ima uwa mari mayena agantune: Yaku e'nora inoyantabe paretibe kaemaranta tama miyogira agantune. ");
INSERT INTO for_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Wama uma irosa'ma Isu maya uramintiye: Inoyanta aeyepa ka ka maete kanaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Piya yogana, Saimoni Pita aeba wanipisa karebi ima kukopa uwa mari paibogana intiye. Piya pomepa kuko antabaipintiba tabe inoyantaba 153 waintantiye, piya pomepa kukopa kampa airisa'wantiye. ");
INSERT INTO for_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Piya pogana Isuba maya uramintiye: Tigeba ampa naninta nabisugaito yiyo, untiye. Yoginiba, a'ya'ma abagi kina'miba: Kaeba kegawemaba, kampa abigantune. Piya, taeba: Aeba Wa'ega yagarawema, ago napintune. ");
INSERT INTO for_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Pigoya, Isu ampima kana inoyantabe paretibe maema pako puma imintiye. ");
INSERT INTO for_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Piya, purintapisa aogama abagi kina'wa aborawaimogana kakaga puntiye. ");
INSERT INTO for_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Pigoya, taeba naninta nagasuwakana, Isuba Saimoni Pita maya omintiye: Saimoni, Yoni ntagara, kaeba ma kinapa asugasima tabera kagupa nameno, untiye. Piya yogana Pitaba maya omintiye. Owe, Wa'ega, kaeba abene. Naeba kaekaba nabiye, untiye. Piya yogana Isu maya omintiye: Kaeba sipisipi awaro kinunte kabiwaitama naninta imo, untiye. ");
INSERT INTO for_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Piya untana to kake maya omintiye: Saimoni, Yoni ntagara, kaeba kagupa nameno, untiye. Piya yogana Pita maya omintiye: Owe, Wa'ega, kaeba abintane. Naeba kaekaba nabiye untiye. Piya yogana Isu maya omintiye: Kaeba Sipisipi kinunteta kiya kabiyo untiye. ");
INSERT INTO for_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Piya untana to kake kakagara omima maya untiye: Saimoni, Yoni ntagara, kaeba naekaba taga kabiyoma, abigantiye. Abigaogana Pita: Naekaba taga kabiyoma yome kamana abite, antawamaba ata pogana maya untiye: Wa'ega, kaeba a'ya'waemaenaba abiwaentane. Naeba nagu kaeti atama paibutopa, pipa abintane, untiye. Piya yogana Isu maya omintiye: Kaeba sipisipi kinunteta kiya kabiyo, untiye. ");
INSERT INTO for_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Piya untana to maya untiye: Tagaka ugamukuwa abo: Kaeba aoso yagara mintanapa, kaega ira'na kukapa arakae pu u'ma, ke'iba pita'i mata'iba nasikenaga kabeginapa wama nasi nasi pene. Pigoya ainti karenarantanapa, kaya tara aebara pegana, to yagarama kaegapa maema amigatama, kampa wakena napikibempe ki'i kababute wakiye, untiye. ");
INSERT INTO for_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Piya, Isu aeba Pita ainti purikena ki aborama omintiye. Purikenaenawampaba Koti nkage asaga'yuyenema, untiye. Kamana piya untana Pitakaba: Ampa naegarao, omintiye. ");
INSERT INTO for_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piya yogana, Pitaba aeba a'wae puma Isu nkabugaome nkabagi yagara naeba aka'i wauwagana nagantiye. Piya, naeba paipa Pasoba naninta nanta ntagaba na'nopa Isu nkaibira aisage puma abigama maya untuwe: Wa'ega, kaepa ke kunapa pugatakiyema abiganto, ");
INSERT INTO for_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","pi ntagarana aka'i wauwagana Pitaba nagantana Isupa abigama maya untiye: Wa'ega, ma ntagaraba pipa aya pikiyema, abigantiye. ");
INSERT INTO for_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Abigaogana Isuba maya omintiye: Aeba uwa mintaka naeba a'wae puma kanakena abimogana wainteginapa, ae kaba nanaga yene. Kaega uwa kanama ampa naegarao, untiye. ");
INSERT INTO for_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Pigoya, ka'isa mono kina'miba igeba naekaba maya uma kamparaga puntawe: Ma nkabagi yagara aeba kampa purikiye, untawe. Pigoya, Isu aeba pipa naekaba: Kampa purikiye kamana kampa untine. Kampaye. Aeba maya kamana'amana untine: Aeba uwa mintaka naeba a'wae puma kanakena abimogana wainteginapa, ae kaba nanaga yene, untine. ");
INSERT INTO for_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Piya, abagi yagara mana nae ma kamanapa abibebe pumagi, ma esapa kaentuwe. Pigoya, mono kina'miba naekaba kamana'wapa taganema abune, untawe. ");
INSERT INTO for_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Pigoya, Isuba toma toma puntipa esa'nepinti kampa kaeyuwe. Pipa esa'amana waewaeyemisinta, naeba abopa wasanamiba kampa aisuma a'ya pesine, Yoniba piyama kaentine. ");
INSERT INTO for_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teyopiro, tabe yagarane, paipa ka esa kaema kamintopa, pi Isu a'ya'ma yoga punti, aogi kamana uwaiminti, pi kamana ugamintuwe. ");
INSERT INTO for_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Piya, aeba yogawapa agobima purite waogana, ikena kana'wapa aboraogana, Aota Awamusa'ama otaogana, Isu pai uwaitantemi aposoro kina to kake kamanapa uwaimogana, Koti ababogana mantari intiye. Pi kamanapa kaewaentuwe. ");
INSERT INTO for_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pigoya, aeba tabera aukima pu'magina, to kake aogama mima, pi aposoro igeba agowa agakibeka aeba 40 yaga mima kakate aborate puwaimima, Koti kabiratakenaenaga uwaiminti, pi kamanape kaga kaentuwe. ");
INSERT INTO for_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Piya, ainti igege ampima maya kamana uwaimintiye: Tigeba Yerusaremi kumapa a-kasiyo. Nabanempatisa aogi kamana, pai abinta kamana, to kake naeba urimintogiri abinta, pi au'wa aborasanaga pita agawa puma miyiyo. ");
INSERT INTO for_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoniba aeba uwa wanitaka'ya paititantiye. Piya, nae kanapa kampa e'ero puntaka, Aota Awamusatasa paititakuwe. Pita'i pika agawa puma miyiyo, Isu piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pigoya, aki punta kina'miba maya uma abigantawe: Pigoya, Isureyo kina pai mintantasa puma, kaeba kaga aki purataga tabe kina mikunoma, abigauguna, ");
INSERT INTO for_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Isu maya uwaimintiye: Pipa tige'enaba kampaye. Nabanempa, aewa napima kanapa atagina waintiye. ");
INSERT INTO for_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Piya, tigekaba maya urimuwe: Tigeti Aota Awamusa tumima esegiyena aborarimekiri, nae nawaga kamana ukena kina'ena pikibewe. Piya, Yerusaremi kumatibe, Yutiya maribe, Sameriya maribe, urite waigina ma nkatuti uma kanarasakiye, untiye. ");
INSERT INTO for_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Isu piya kamana ute, iyora ase'yo puma ikena pogana ababuntiye. Ababogana, ibinankama atikaewaogini aguyosagantawe. ");
INSERT INTO for_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Pigoya, igasoginiba mantari iyogini agagaite mintugunisi, tara yagarara wae kaiyaga, igeti ampa aborama mintinisi, ");
INSERT INTO for_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","maya uwaimintase: Karariya kina, tigeba nanaga mantariba tiyoma'ma miyewe. Isupa tigeba ago agantagana, titate iyegina ababute mantari iye. Pi aeba iyegiri, agasa puma, aintiba to kake a'wae puma tumekiri agakibewe, piya untase. ");
INSERT INTO for_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Pigoya, aposoro kina igeba ka amutisa, agewapa Oribesi, pi Yerusaremi agora amutisaba, a'wae puma tumima Yerusaremi kuma waintometi wantawe. Pi e'eropa Yuta kina'miba sabatirapa wabumekini, ");
INSERT INTO for_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","pita'i wama kumati ima, ige mibume ntamapi asu mintantawe. Pi yare puma, inata kimaranta namapi asu mintantapa, mayamawe: Pitawa, Yoniwa, Yemisiwa, Enturuwa, Piripiwa, Tomasiwa, Patoromayowa, Matiyuwa, Aopayesi ntagara Yemisiwa, namu'isa kiya kina igarubakaikena abugai ntagara Saimoniwa, to Yemisi ntagara Yutasiwa, suma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Pi kina'mi ka iyuma pumagini, Isu nkanowampa Mariyabe, to ka'isa waepe, Isu nka'natabaramibe, kaga mima nunamu uma mimi puntawe. ");
INSERT INTO for_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Pi kanabipa ka yaga, Isu nkaegaranta mono kina, 120 kina irosa'ma mintuguna, Pita asima maya kamana untiye: ");
INSERT INTO for_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Nao'mitaba, pai Aota Awamusa'ama Tebiti nkawamu aseyo potaogana, Koti nkesapi kaemaranti pi'na Yutasika au'wa aboraneme, untiye. Pi Yutasi aeba Isu arakurikena kina iyakinti ntagarawe. ");
INSERT INTO for_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Pi ntagara aeba taetisa, mono yugarapa aeke kaga otantine, Pita piya untiye. ");
INSERT INTO for_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Pigoya, pi ntagara aeba ataenawatasa mone maema kasuguna, maba maema aeti atauguna, pita aibagobama abararamagina, akapisa muru'magina antaba kurima unu kaewantiye. ");
INSERT INTO for_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Aibogini, Yerusaremi kumatasa a'ya'ma kina'miba abitegini, kana mawama nkageba Aketama, piya kamanatepipa Kora mpawe, untawe. ");
INSERT INTO for_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pigoya, Pita Yutasika maya untiye: Paisa mono ini Samu isapi, awa'ena mayama kaemaranta waintiye: Nama kuma'wapa uwa waiyeno. Piya to ka'waina a-mpiyeno, untiye. Pigoya Samu isa'amaba to ka maya untiye: To ka'waina aborama, ae antotapa yogawapa maeyano, untiye. ");
INSERT INTO for_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Pigoya, Yoni mono wani pai'ataogana, Isu yogawa agobinti, pi kanabipa aeti uma airokaema, aega'ma miyuwakana mantabinti intiye. Piya, Isuba abakatepi miyogini, ka'isa kina'miba taege nasinta kina'mipisa ka asitakana, taege kanarasakiye. Pai kaemaranta kamanaka napiyigi, ka aboratama miyeno. Piya yagaraba, ke aboramagina tao'maeyaka Isu purintapisa asintemi, pi awaga kamanapa yekana kanara pisiye, untiye. ");
INSERT INTO for_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita piyama yogini abite, tara yagarara isigama aborantawe. Ka'waina nkagewapa Yosepe Yasitasi, to agewapa Pasabasiwe. Piya to ka'waina nkagewapa Matayasiwe. ");
INSERT INTO for_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Isigama aborawaisitantiniba, maya uma nunamu untawe: Wa'ega, kaeba a'ya'ma kina'mi nkigu'ama agawaekena yagaragawe. Pika kaeba ma tara yagarara, isigetisa ka'waina tayakega otakana, ");
INSERT INTO for_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yutasi mono yugawape aposoro agibe atate purikena ki'wati tuminti, ae maruta miyeno, untawe. ");
INSERT INTO for_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Piya nunamu umagini, iya nkatauguna Matayasi aboraogini, aposoro nagisarisa ka tumpaema kina'mige mima yoga penema, otantawe. ");
INSERT INTO for_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Isu kaitate mintuguna, tonaentisa tara umaema sonta a'ya puwaogana, Pentikositi naninta nakena yaga aboraogini, Isu nkabagi kina igeba ka namapi aki puma a'ya'ma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mintuguna, pontaba aga yemisa puma, mantarisa tabera puma aga urite tumintiye. Tumimagina mintume ntamapi pai'magina pumaewantiye. ");
INSERT INTO for_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Piya pumagina, yaku nkantebugantaena aboraurite, wa waya nki'nota aibariyate purite wagana puntiye. ");
INSERT INTO for_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Piya pogana, Aota Awamusa'amaba igupi tumima pumaewamagina, intebuba a'wae puwaigasogini, to kamana to kamana urite wagana puntawe. ");
INSERT INTO for_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Pigoya, pi ntagaba Yerusaremi kumata a'ya'ma marisa Yuta kina, mono waintaga kina'mi, ampa mintantawe. ");
INSERT INTO for_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pigoya, igeba iwamupisa aga abite, tabera irosa'ma ampa aki puma pami puntawe. Piya puguni, pi a'ya'ma kina kamana'waipisa kamana yuguni abitegini, ");
INSERT INTO for_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","pami ntami puma uwoma nkigi napimagini maya untawe: Ma kamana ye kina, igeba Karariya kina amanane. ");
INSERT INTO for_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Igeba ayamagina to kamana to kamanapisaba yega kamana, agomitaba abune. ");
INSERT INTO for_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Taeba Patiya kinana, Mita kinana, Iramu kinana, Mesopotemiya marisa kinana, Yutiya marisa kinana, Kapatosiya marisa kinana, Pontasi marisa kinana, Esiya marisa kinana, ");
INSERT INTO for_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Pirisiya marisa kinana, Pampiriya marisa kinana, Isipi marisa kinana, Sairini ma agora Aribiya marisa kinana, a'yo ampintanta kina Aroma Yuta kinana, Aromapisa Yuta ibabunta kinana, ");
INSERT INTO for_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kariti kinana, Arebiya kinana, sumagi, taeba a'ya'ma mima, kamanatepisa Koti nkesegi puma aogi pumaranti kamana yega, abokanaba iga piye, untawe. ");
INSERT INTO for_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Piya, a'ya'ma kina'miba piya umagini, pami ntami puma uwoma nkigi napima, mare-u me-u puma maya untawe: We, mapa nanaenabaya aboraye, yuguni, ");
INSERT INTO for_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","pigo to ka'isa kina'miba pika akaya sumagini, maya untawe: Igeba waini wani kampa iga'e pasuma nagaitegini, aibo kamana yewe, untawe. ");
INSERT INTO for_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pigoya, Pitaba to aposoro kina nagisarisa ka tumpaema kina'mi abakapi asima mima, a'ya'ma kinapa tabe kamana maya uma aborama uwaimintiye: Yutiya kinape Yerusaremi a'ya'ma kina ampintapa, naeba urimekiri aogima abiyo: ");
INSERT INTO for_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Tigeba taekaba maya yewe: Igeba waini wani nagaitegini aibo'ena pewe, yepa, pipa ibanto kasa maregi, waini wanipa kampa nantune. ");
INSERT INTO for_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pigoya, poropete yagara Yoweri awa'ena mayama kaenti, pi'na esegi piye: ");
INSERT INTO for_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Koti aeba maya iye: Aintisa kana agarosakapa Aota Awamusa'nepa a'ya'ma wa wayapa ari'ma imekini, yagara aragarimpi ainti aborakena kamana, poropete kina'mi yesa puma ukibewe. Piya, aoso kina'miba kasa'enaba agaigini, anasa kina'miba aogi amunta agakibewe, iye. ");
INSERT INTO for_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Pigoya, pi kanabipa nae kayokaya kina, wa waya, Awamusa'nepa ari'ma kanarasama imekini, poropete kina'mi yesa kamana ukibewe, iye. ");
INSERT INTO for_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Pigoya, naeba yekana, inati mantariba tona kasa'ena aborakiye. Piya, abetisa mariba awame'ena aborakiye. Korape yakupe kunka ibinape tiye kuruyenamana aborakiye, iye. ");
INSERT INTO for_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pa nkaoba tu'ma wakiye. Piya, o'aowamaba kora ki wakana, pi ainti Wa'ega Yagarama kanaba agasiyaena aborakiye, iye. ");
INSERT INTO for_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Aibekini, Wa'egawama agisigina, pi kina'mi nki'ima aogi pikiye, poropete Yoweri piya untiyema, Pita piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Uwaimintana, Pita to maya untiye: Isureyo kina, naeba urimekiri abiyo: Isu, Nasareti kumatasa yagara aeba tiyobi Koti esegi potaogana, abakatipi esegiyenabe awame'enabe kasa'enamana Kotitisa ago pogana, pintana agoba aboraogiri agantawe. ");
INSERT INTO for_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pi aeka Kotiba paitaka'ya napiyogana waintantika, uma a'ya ataogiri, pabi nkawameta tigeba pintana potama, kama kina imuguni, maripora aeguyuguna purintiye. ");
INSERT INTO for_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pigoya, kana yagaraba Koti aeba purintapisa asitantiye. Piya, aukima purikenaena agaruba agasogana, pi purikenaenamaba aepa kampa to arakurikiye. ");
INSERT INTO for_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Pigoya, Tebitiba Koti nkomome kamanaka maya untiye: Naeba Wa'ega Yagara, kagabebe pumagi kampa natane. Kaeba naori asima mimagina nao'maeyakanaba, ka'enamaba kampa napasanakiye, iye. ");
INSERT INTO for_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Pigoya, pika nantawama aogi pegi, nawamupisa na'mu pugatauwe. Piya, nau'amaba aogiyenaneka napi napi puma miye, iye. ");
INSERT INTO for_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Kaeba naumanepa kampa atagana, purinta kina ige kumatiba waikiye. Piya, Aota Yagarapa kampa atagana abararakiye. Pika na'mu pugatauwe, iye. ");
INSERT INTO for_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kaeba aogima miyaba ki nayakima, naege kaga mikibempeka naeba na'mupa tabera puwe, Tebiti piya untiye. ");
INSERT INTO for_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piya, nao'mitaba, naeba tayabama Tebiti, aeka taga urimuwe. Aeba purogini, kaitanta aruwapa ma mpara agama abima miyune. ");
INSERT INTO for_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Aeba poropete mintana mayama napintiye: Ainti Koti aeba aintisa ayabama nae kabima mintanto mparuta mirite waiyemagina, uma esegi punatantiye. ");
INSERT INTO for_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Piya pipa napimagina, Koti ataogana, utaratanta yagara Karaisitika meto kamana maya untiye: Aeba purinta kina'mi kumatiba asayapa kampa atagana umikiye. Piya, au'wapa kampa abararakiye. Aeba to kake aogama asiwakiye, untiye. ");
INSERT INTO for_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Pigoya, Isupa Koti purintapisa asitaoga, taeba taorepisa agabebe puma agantompene. ");
INSERT INTO for_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Pigoya, abawampa nkayatakanti asitama tabe potaogana, Aota Awamusa'wapa abawampa utatantemipa amogana, ataogana tumintemintana, tabera ampa aboraogini agawe. ");
INSERT INTO for_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Pigoya, Tebiti aewapa mantabintiba kampa intipa, maya kamana ka untiye: Wa'ega Yagara aeba nae Wa'egane piyama omintiye: Kanama nayatakanti ampiyegina, ");
INSERT INTO for_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","kama kinakapa kagisabi aki puwaitakini, kagisara aebabiyo, piya omintiye. ");
INSERT INTO for_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Pika Isureyo kinapa a'ya'ma mayama abima esegi piyo: Isu maripora aegunta, Koti aepa Wa'ega, aepa Karaisiti, asitantegina mintiye, Pita piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pigoya, Pitaba inta paibu'ma kamana piyama uwaimogini, iyekuru puma, ae'wape to ka'isa aposoro kinape mayama ibigantawe: Nao'mitaba, taeba aya pekana aogi pikiye, untawe. ");
INSERT INTO for_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piya yuguna, Pita maya uwaimintiye: A'ya'ma tigeba tigu a'wae puma, Isu Karaisiti ae ageraka mono wani pasiginaba, aguntaenaripa asu'a puwakana, Koti Aota Awamusapa timikiye. ");
INSERT INTO for_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Tigetipe tiga'nugipe, a'ya'ma ainti aborakibe kinape, Wa'egare Kotiba aeti uma atokaekenaga tigega'e ukibi kina, pi tige Aota Awamusapa utaritantiye, Pita piya untiye. ");
INSERT INTO for_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piya umagina, Pita to ka'isa kamana amato puma, ige'ma kamana maya uwaimintiye: Iba ataena pe kina, ige aruyenabisa a'wae puma ataigina-o, tibabikiye, untiye. ");
INSERT INTO for_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pigoya, pabi ntaga 3,000 kina igeba Pita mono kamana yome abibebe puguni, mono wani pai'itauguni, Isu nkaokina'miti uma airokaentawe. ");
INSERT INTO for_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Pigoya, aposoro kina'miba mono abikenabe, Isu nkau nakenabe, nunamurape asi nasi aki puma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Piya, Koti nkawame'ena aposoro kina'mi pumeka, a'ya'ma uwa kina'miba iyekuru puguni, pi aposoro kina'miba kasa'enabe awame'enabe uwoma tonarona puntawe. ");
INSERT INTO for_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pigoya, a'ya'ma pi aegaranta kina'mi kaga mintini, a'ya'waemaenaba pipa wabantanarene, untawe. ");
INSERT INTO for_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Pigoya, ka'isa kina'miba ige'enawaipa to kina imimagini, mone maema, iyokina kusi puma miyume kina, pako puma imintawe. ");
INSERT INTO for_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pigoya, asi nasi tabe mono namapi aki puma, imaba kata atama mimagini, au nakenaba igewai ntamapi aki puma nama mintantawe. Pigoya, nanintagaba aogima pako puntini, intawama asoyaenabi nama mimagini, Koti nkage asaga'yuma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Piya puguni, ka'isa kina'miba igama i'mu puwaitantawe. Pigoya, Wa'ega aeba wasana imaba yoga pogini, monoka ibogini, asi nasi ae aruyenabi ibabuma atokae itantiye. ");
INSERT INTO for_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Pigoya, ka yagaba Pitage Yonige isigeba atamaita nunamu ukena kana aboraoginisi, tabe mono namapi intase. ");
INSERT INTO for_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Pigoya, pi tabe mono nama kabera ka yagara, ano nkantabaipintisa agisa pu'wanta yagara aboranti mintantiye. Pigoya, kana kabewama nkageba Nauka kabiwe, untawe. Pigoya, pi ntagarama nkaokina'mi asi nasi ababute wama, tabe mono namankama kabera metauguna mima, wasana mono nama pasikena ite tumite pugunaba, mone kutaka esuwaitama mintantiye. ");
INSERT INTO for_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pigoya, Pitage Yonigeba tabe mono namapi ikena iyusuguna, isigategina pabiyama esuwaisitantiye. ");
INSERT INTO for_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Esuwaisitaoginisi, isigeba aepa agabebe puntinisi, Pita maya omintiye: Kaeba tasige tasigao, untiye. ");
INSERT INTO for_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Piya yogana, pi agisa pu'wanta yagara aeba: Ka'ena namikenaga yese, uma esegima isigabebe puntiye. ");
INSERT INTO for_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piya pogana, Pita maya omintiye: Mone kuta naeba kampa wainatantiye. Piya, ka'ena wainatanti, pipa kamukuwa, maeyo. Isu Karaisiti, Nasareti kumatasa, ae awamuta ugamekana, asima ke nasi nasi po, untiye. ");
INSERT INTO for_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piya umagina, ayatakantisa u'ma asitantiye. Aibotaogana, pabigo agisa aga'naba aibarutaogana, pa'yo puma asintiye. ");
INSERT INTO for_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Piya pogana, ke nasikenaenawaka a'mu pumagina, pa'yo pa'yo pumagina, Koti nkage asaga'yuma isigege kaga tabe mono namapi intawe. ");
INSERT INTO for_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Piya puguni, a'ya'ma kina'miba agategini maya untawe: ");
INSERT INTO for_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Mono nama, Nauka kabera, mone kutaka esuratama miyemi ntagara pimpaye, untawe. Piya, aogi pomeka agawaemagini tabera pami ntami puntawe. ");
INSERT INTO for_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Piya puguni, Pitake Yonikeri kana yagara uma atokaeyogini, a'ya'ma kina tabe mono namankama nkawari, ka maruta agewapa Soromoni nkagu namantana pumaranta auka'i, pita'i isigeti karu'ena uma aki puma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piya puguna, Pitaba igantana wasana maya kamana uwaimintiye: Isureyo kina, tigeba nanaga ma ntagaraga pami puma, tabera tasigabebe puma miyewe. Mantanaba tasige monotesikabera, esegiyenaresimpa ke nasi nasi pikenaenaba aboramuse. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Piya, Abara'amu, Aisaki, Yekobu, tayabamage, ige Koti, aeba yagarawa Isu ae asu againtika, ma ntagarama nkauta aogi pegiri agawe. Tigeba pi aepa tigobi potama, kama kina'mi nkiyapi atauguna, Pairatiba uwa atakenaga yogiripa, tigeba asu againta ntagaraga: A'a-o, untawe. ");
INSERT INTO for_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Piya, aota arupuyena wantaga aogiyenama nkagowa, aepa kiyaba: A'a-o, otauguna, wasana aeguti ntagarari uwa atanema uma paru potantawe. ");
INSERT INTO for_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Piya puguna, mikenaenama nkagowapa aeguntawe. Aeguyuguna, Koti purintapisa asitaoga, taorepisa agabebe puma agantompene. ");
INSERT INTO for_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Pigoya, tigeba agama abiyo. Isu aega'magira agega napiyogana, ma ntagara Isu nkawamutaka esegiyena aboramegina kaba'ma mintiye. Piya, Isuti tasimatiti pogana, Koti abimagina tiyora aogi potaye. ");
INSERT INTO for_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Pigoya, nao'mitaba, naeba abintuwe. Tigebe kiya kinatimpibe kampa napinta, aibo'enarimpa ata potantawe. ");
INSERT INTO for_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Piyama ata potauguna, Kotiba utaratanta yagara auki naki puma purikibika, pi kamana poropete kina'mi nkiwamupi ataogini, uma kaemaranta, pi'na esegi puntiye. ");
INSERT INTO for_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Pika tigeba tigu a'wae pumagiri, paisa mikenaenaripa tikabitaiginaba, aguntaenaripa aebago purigasakanaba, Wa'egawamatisa aoso esegiyena tigupi aborakiye. ");
INSERT INTO for_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Pigoya, tigu a'wae piginaba, Kotiba Isu, utaritanta yagarawa Karaisiti, otakana tumimagina mikenaganapa aborarimikiye. ");
INSERT INTO for_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Piya, pi Isupa mantawama kakataogana mintogana, Koti aeba paitaka'ya a'ya'ma aota poropete kina'wampi nkiwamupi ataogini, untasa puma a'ya'waemaenaba aborakiye. ");
INSERT INTO for_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Pigoya, Moseseba kamana maya untiye: Wa'ega Kotiba, aeba tige aruyenabisa ka poropete nae piyama aborarimekana, kamana urimikibi abiyo. ");
INSERT INTO for_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pigoya, pi poropete kamana'wa kampa abikibe kinapa Kotiba kamana abikena kina'mi nkaruyenabisa igaruba'magina, iyeguma kaikiye, Mosese piya untiye. ");
INSERT INTO for_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Pigoya, poropete ka'isa Samuweri miyogini mirite kananta, igeba pabiyama ma kanabisa kamana uma kaentawe. ");
INSERT INTO for_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Pigoya, poropete mintanta, pi ige iga'nugita tigeba, piya Koti tiyabamagige paibu'ma atokaemaranti, pi paibutikenaenama nkagoba, pi tigewe. Koti aeba Abara'amuge paibu'ma atokaentana, maya omintiye: Naeba kaga'nugipa akayona puwaitakana, pi akayonamaba a'ya'ma maga maga kina kanarasa waitakiye. ");
INSERT INTO for_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Tigeka Kotiba yagarawapa asitama otaogana, maru Yuta kina tigeti ampa aborantiye. Piya, tigeba aguntaenaripa tikabitaiginaba, akayonaba puritakiye, Pita piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pigoya, Pitage Yonige isigeba wasana kamana uwaimima mintusuguni, mono kiye kinape, mono nama irebu kina'mi tabe yagarabe, Sarusi kina igebe, kaga isigeti irosantawe. ");
INSERT INTO for_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Piya, isigeba wasana mono kamana uwaimintinisiba: Isu aeba purintapisa aoganti kamana uwaimintase. Pi aogaome kamana uma aborausuguni, abugunaba ataena puntiye. ");
INSERT INTO for_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Igeba isiraku'magini, ago atamaisa waogini, iga'na namapi isitaugunisi waimarausuguna, piya aiba marekini kamana uwaisitakena puntawe. ");
INSERT INTO for_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pigoya, Pita mono yogini, abinta kina igetisa uwoma kina'mi abibebe puma, Isu ae aokina'miti uma atokaeyuguna, waba 5,000 puntiye. ");
INSERT INTO for_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","6","Piya maroginiba, Yuta monota kiye kinape, kabiyume kinape, tisa kinape, monota paitanta kiye yagara agewapa Anasibe, Kayapasibe, ka Yonibe, Aresantabe, to ka'isa tabe kiye yagarama nkaokinape, Yerusaremi kumata aki puma miyuguni, ");
INSERT INTO for_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","aposoro yagara taraba isibabute iyugunisi, iyobi asima mintusuguni, isibigama maya untawe: Nana esegiyenara, ke nkawamutasa kamanataka pi esegiyenaba pese, piya uma isibigantawe. ");
INSERT INTO for_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Piyama isibigauguna, Aota Awamusa'ama Pita nkagupipa pumaeyogana, kamana mayama uwaimintiye: Tigeba tabe Isureyo kinape, monota kabiye kinape, a'ya'ma yekiri abiyo. ");
INSERT INTO for_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Tasigeba ma nkagisa pu'wanta yagara ao'maema kaba ataogiripa, pika tigeba: Ayama kaba atasema, urasitawe. ");
INSERT INTO for_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pika naeba uma aborakiri, tigebe Isureyo kinape a'ya'ma abiyo: Isu Karaisiti, Nasareti kumatasa, tige maripora aeguyuguna purogana, Koti purinta kina igetisa abage puma aogatantegina asima mintiye. Ae esegiyenara ma ntagaraba kaba'ma au'amaba aogi pegina mintiye. ");
INSERT INTO for_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Pigoya, Wa'ega Isugaba paisa kamana maya waintiye: Nama kikena kina, tigeba mapa ata yabanema kaintagana, pi ntabankamaba ibaba aogi wa'ega yaba kanta esegi puma mintiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Piya, tau'ikenaenaba wasanamiti kapa kampa waintiye. Piya, ka yagarama nkageraka uma atokaema aogi pikenarapa, pipa mabipa kampa waintiye. Isu ae abiwa tau'ikena yagarawe, Pita piya untiye. ");
INSERT INTO for_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pigoya, Pitage Yonige isigeba abikena namapipa kampa wanta, uwa yagara taraginisi, igeka kampa karuba punta kamana esegima yusuguni, abima pami puntawe. Piya, isigeba Isuge mintantame, pipa ago isigabebe puntawe. ");
INSERT INTO for_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Pigoya, pi kaba atantame ntagara, aeba isigege kaga mintogini, aepe agamagini pi kamana a'wae puma uwaisimikena aguyosagantawe. ");
INSERT INTO for_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aguyosagategini uwaisitaugunisi abe'i irosa'ma tumpintusuguni, pi mono kanisore kina igewai maya uma, mare-u me-u puntawe: ");
INSERT INTO for_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Taeba ma ntagara taraba ayaena puwaisitakune. Isigeba awame'ena puma aboraginisi, Yerusaremi kumatasa kina'miba isiwaga kamanapa ago abiwaegasawe. Pika ayama airari kaekune. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pigoya, pi kamana'ama a'ya'ma kumati wagana puma abae pekini, wasanami abisanaga, kamana esegima uma isiyekuru pugasakinisi: Pi ntagaragaba to kake wasanaba a-nkuwaimiso uma akunkaisitakune, untawe. ");
INSERT INTO for_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Piya ute, isigega'e uma maya uwaisimintawe: Tisigeba Isu nkagebe wasanaba kamana'wape to kake a-nkuwaimiso, uma akunkaisitantawe. ");
INSERT INTO for_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Aiyugunisi, Pitage Yonige isigeba pi kamana antotapa mayama a'wae puma uwaimintase: Tige tigeri napimagiri abiyo. Tige kamana wasite Koti kamana a'a-o yiginaba, Koti nkaobi agowamaba abekanaba aogi pikiyo, piyama ibigantinisi, ");
INSERT INTO for_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","to maya untase: Piya, pi agama abintompentanaba kakatama mikenaenaba kampaye, untase. ");
INSERT INTO for_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Piya yugunisi, to kake isiyekuru kamana uwaisimima isitaugunisi wantase. Piya, pi kumatasa a'ya'ma uwa kina'miba, pi ntagara kaba atausume, pintana agama abite Koti i'mu potaomeka, igeti kunta puma, aposoro isigepa ka'enaba kampa puwaisitantawe. ");
INSERT INTO for_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Pigoya, pi nkagisa pu'wanta yagara aeba nankitama miyogana, kaboba 40 poginisi aogi potantase. Aibusuguni agantaka yewe, untawe. ");
INSERT INTO for_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pigoya, Pitake Yonike uwa isitaugunisi, isigeba wasana akiyenabisaba irosa'ma isiyo'miti wama, tabe mono kiye kinake monota kabiyume kinake kamana uwaisiminta, pi kamana uwaimiwaentase. ");
INSERT INTO for_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Piya, pi kamana igeba abite, kaga kamana uma, Kotiti nunamu uma maya untawe: Wa'ega, kaeba mantabe mabe wanipe a'ya'ma pipisa kinape atawaentampeka, ");
INSERT INTO for_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Aota Awamusa otaukuna, aeba tayabama Tebiti, kayokaya kinaka, awamu aseyo pogana, kae kamana maya untiye: To marisa kina'miba nanaga igobipa taberapa punatagini, nana pegina naekaba mamparasa kina'mi uwa kaba tabera kanabirawe, iye. ");
INSERT INTO for_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wa'ega Yagara naepe, Karaisitinepe, mabisa wa'ega kina igeba kama purasitakena iyakana urewe, iye. Piya, kiya kina igeba aki puma kama purasitakena'naga nikewe, kae kamanakapa Tebiti piya kaentiye. ");
INSERT INTO for_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Piya pika, ma kumatapa taga aota yagaraga Isu, Wa'ega asitampe, aepa kama potakena, Erotibe, Pontiyasi Pairatibe, to marisa kinape, Isureyo kina igege wanaga nikintawe. ");
INSERT INTO for_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Pigoya, pai kaega tonkiya kamana uma asaemarantampe, pi nkawameta pewe. ");
INSERT INTO for_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Pigoya, Wa'ega, ma iyekuru kamana'waipa asu'a pugasima, kayokaya yagaragapa esegiyenaga tamega, monokapa karu kampa punta uwaimeno. ");
INSERT INTO for_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Piya pekana, kayapa asabuma yoni kinapa kaba itama, tonarona awame'enabe kasa'enabe puwaiyakegini, aota yagaraga Isu, aeka uma aboraurite wano, nunamu piya untawe. ");
INSERT INTO for_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Piya nunamu yuguna, aki puma mintume ntamankama kurukuru puntiye. Aibogana, Aota Awamusa'amaba igupi pumaeyogini, kampa iyekuru punta, iwamu asoyaenabisa Koti kamana'wa wasanaba uwaimintawe. ");
INSERT INTO for_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pigoya, Isu nkaegaranta kina'miba igupa kata atama paibu'ma mintantawe. Piya, a'ya'waemaena waintomekaba: Kae'enawe, nae'enaweba, kampa untawe. Pipa kapi'enarene, uma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Pigoya, aposoro kina'miba Wa'ega Isu purintapisa asintemi, pi nkawaga kamanapa esegima uma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Piya, paruyena apaena aboraogini, pi kina aogimagini iyo'ena puntawe. Ige abakapipa ka'waina kusiba kampa mintantiye. Mawaipe iyotasaenawaipe to kina imima mone maemagini, ");
INSERT INTO for_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","aposoro kinati atantawe. Piya puguni, igeba ka'isaenaga aguyosagaume kina pakobuma imibuntawe. ");
INSERT INTO for_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pigoya, ka yagara, ka agewapa Yosepewema waintometa, aposoro kina igeba to ka agi Panabasiwe omintawe. Pi kana agiba tae kamanapisa Esegima aurikena yagarawe, omintawe. Pi ntagara aeba Aribai tupisa, Saiparasi marisa yagarawe. ");
INSERT INTO for_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aeba mawapa to kina imimagina, mone maema aposoro kina igeti a'ya'ma atawaentiye. ");
INSERT INTO for_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pigoya, to ka yagara agewapa Ananayasi, aeba waya'wa Sapaira, aege uma abiriteginisi, ma kuma'wapa wasana imima mone maema, ");
INSERT INTO for_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","pika napi napima, ka'isaba kakatantinisi, to ka'isaba maete wama aposoro kina igeti atamagina: A'ya'ma maete kanauwe, untiye. ");
INSERT INTO for_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piya yogana, Pita maya omintiye: Ananayasi, kaeba nanaga Sataniba kantabaipinti pumaewagina, napimagina Aota Awamusa amiyo kamanapa uma, kuma magampa ikantanaba ka'isaba maema kakane. ");
INSERT INTO for_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ma kumakapa uwa kae'enaga atagana waisanawe. Piya, uwa ikantana mone maema, piya mayaena pikenaba pipa piya pusanawe. Kaeba kantabaipintiba ayama napiyene. Kaeba amiyo'enaba pene, untiye. ");
INSERT INTO for_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Piya yogana, Ananayasiba pabigo abintana, ware'nama purintiye. Pigoya, agama abinta kina igepa iyekuruyenaba tabera aborawaintiye. ");
INSERT INTO for_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Piya pogini agate, masimabimiba asima, kairasa asagakokima wasirite uma kaintawe. ");
INSERT INTO for_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Piya, pi ntaga ainti anarimpa kampa abinti, uwa mintiyemagina, kanama ampa irosantiye. ");
INSERT INTO for_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ampa irosaogana, Pitaba mayama abigantiye: Ma kumatisimpa nkikantanaba pabi nkasa'anto kanayoma, abigaogana, pigo aeba: Pabiyaki antowe, untiye. ");
INSERT INTO for_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Piya yogana Pita maya omintiye: Tisigeba nana piyema ka'masa tisigiba Wa'egawama Nkawamusapa amiyo pikenagaba napiyese. Kawaepa ago kaiyewe. Pi kina igeba kabe akanti mintawe. Igeba kaepa pabiyama kaigatakibewe, untiye. ");
INSERT INTO for_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Piya yogana, kana waepa abite, pabigo agisabi ware'nama purintiye. Aibogini, masimabi igeba namapinti ima agaumepa pu'waintogini, wasirite wama awae kaitaumeti uma kaitantawe. ");
INSERT INTO for_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Pigoya, a'ya'ma Isu mponota ai'aru pume kina'miba a'ya'ma isiwaga kamana abinta kina'mige, igeba tabera iyekuruba puntawe. ");
INSERT INTO for_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Pigoya, aposoro kina'miba toma toma awame'enabe kasa'enabe wasanamiti uwoma puntawe. Piya puguni, Isu nkaegaranta kina igeba imaba kata atamagini, tabe mono nama marupa ka agewapa Soromoni, pita'i aki puma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Pigoya, a'ya'ma uwa kina'miba iyekuru pumagini, igegeba kampa ampa aki puntawe. Aibumagini, pi Isu nkaegaranta kina'mi nkige asaga'yuntawe. ");
INSERT INTO for_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pigoya, wabe wayape uwoma to kina'mi mono abima, Wa'egawamati uma amato puma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Piya, ka'isa iyokina yoninta ibome kinapa, wasabe ama'waipe wasirite, ke'i me-ita menkita puntini, maya untawe: Pita aeba nasi nasi pekana, amankapa ampa ama nkaiwaitakini kabarikibewe, ute piya puntawe. ");
INSERT INTO for_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Piya, Yerusaremi kuma'ama nkagora ka'isa kumatisaba uwoma kina'mi irosa'magini, yoni kinape kegina intabaipinti minta kinape ibabute kana kana puguni, a'ya'ma iyo'maema aogi puwaitantawe. ");
INSERT INTO for_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pigoya, pintana aboraogana, monota paitanta yagara aebe, a'ya'ma aege miyume Sarusi tupisa kinape, igeba igobipa tabera puntawe. ");
INSERT INTO for_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Aibumagini, aposoro kina ata puwaitamagini, iraku'ma ibabuma iga'na namapi itantawe. ");
INSERT INTO for_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Piya puguni, pita'i waita mintuguna, aseka Wa'egawamatisa enisorewama kabe ai'itama, ibaburite tumima maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Tigeba tabe mono namapi ima, a'ya'ma kina aogaso asima miyaba mikena kamana uwaimima miyiyo, uwaimogini, ");
INSERT INTO for_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","abitegini abayara tabe mono namapi ima mono untawe. Pigoya, monota paitanta yagarabe aege miyume kinape igeba aki pumagini, a'ya'ma Isureyo mono kanisorege kiye kinape igega'e yuguni irosantawe. Piya puntini: Kamana atauguna, iga'na namati wama aposoro kina ibabute kanaiyema, untawe. ");
INSERT INTO for_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Piya yuguni, irebu kina igeba iga'na namati waumepa, kana aposoro kinapa uma agaumepa, kampa mintuguni uma agagategini, igeba a'wae puma wama uma maya untawe: ");
INSERT INTO for_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Taeba wama uma irosa'ma agaompepa, kabeba tonkiya puma kimatanta'enayaga waintegini, kiya kabima mintaga uma igaune. Aibumagi, kana kabe aima ima iguyosagaompepa, kana kinape kampa igaune, untawe. ");
INSERT INTO for_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Piya kamana yuguni, mono irebu kina'mi tabe yagarabe, tabe mono kiye kinape, igeba kana kamanaka uwoma nkigi napimagini: Pipa nana aborakena piye, untawe. ");
INSERT INTO for_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Piya yuguna, ka yagara ampa irosa'ma maya uwaimintiye: Iga'na namapi itanta kinapa igeba tabe mono namapi wasana mono uwaimima mintawe, untiye. ");
INSERT INTO for_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Piya yogini, irebu tabe yagara aeba irebu kina ibaburite wama, aposoro kina paruyenabisa uma ibaburite kanantawe. Pigoya: Iyeguyekiniba, a'ya'ma kina'miba yaba kasutasa taegukibewe, umagini iyekuru puma, kampa kaso iyegunta uwa ibaburite kanantawe. ");
INSERT INTO for_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Pigoya, mono kanisore kina'mi nkakiyenabi me itauguni mintuguna, monota paitanta yagarama maya kamana uwaimintiye: ");
INSERT INTO for_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Taeba pi ntagarama nkageba wasanaba a-nkuwaimiyoma akunintompepa, kamanatimpaba Yerusaremi kumatiba to kake uma abae pegiri, nanagabaya tigeba kana yagarama kaintanaba tae taupi maema me nkatakena pewe, untiye. ");
INSERT INTO for_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piya yogini, Pitabe ka'isa aposoro kina'mibe igeba kamana mayama a'wae pomintawe: Wasanama kamana wasintini, Koti kamana a'a-o ukenaenaba, pipa kampa waintiye. ");
INSERT INTO for_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Tigeba Isu yara aeguma aibu atauguna, tayabamagi ige Koti, ae abage puma asintantiye. ");
INSERT INTO for_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Asitamagina, Koti aewa nkayatakanti ababute ima, tabe paitama yagara, tau'ikena yagara asitantiye. Pigoya, ma Isureyo kina, taeba tagu a'wae piginaba, aguntaenarepa asu'a puragaikenaga iye. ");
INSERT INTO for_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Pigoya, pi nkawaga kamanaka Aota Awamusa'amabe taebe: Owe, yune. Pi Aota Awamusa aepa Koti awamu wasiye kina'wa imiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Piya kamana uwaimogini, intawamaba asabama ata pogini, aposoro iyegukena untawe. ");
INSERT INTO for_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pigoya, kana akiyenabi Parasi yagara ka mintantiye, agewapa Kameriye, aeba mono tisa Yagara, a'ya'ma kina ae age mesu asagayuye. Aeba asima yogini, aposoro kina igeba abe'i tumima a'yo mintuguna, ");
INSERT INTO for_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","aeba aokinapa maya kamanapa uwaimintiye: Isureyo kina, nao'mitaba, tigeba ka'ena ma kina puwaitakena puntiripa, aogima napigate puwaitaiyo. ");
INSERT INTO for_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Paipa ka yagara agewapa Tiyutasi, aeba: Nae wasana wa'egari paitaritama miyuwe, piya yogini, 400 kina aeti uma atokaentawe. Pigoya, aewa aeguyuguniba, aokina'miba iyegaka aibarara pumagini, yogawaipa kaintawe. ");
INSERT INTO for_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Pigoya, ainti Karariya mari ka yagara agewapa Yutasi, aeba tage aisuratanta pi kanabi, wasana imo atikeba'ma paita itaogini, ma'ena agobima puntawe. Piya puguni, aewapa aeguntini, aokinapa iyeguma igarubantawe. ");
INSERT INTO for_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Pika ma kamana urimekiri abiyo: Tigeba ma kinapa uwa itaigini miyiyo. Igeba kamanape yogabe igewai igutasa napima piginaba, a'yugu puma kampa waikiye. ");
INSERT INTO for_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Piya, Koti nkesegiyenara kana yuga agobima pigiripa, uwa piya pugate itakibewe. Tigeba yogawai agu'ya aimagiri, Koti aewapa kama potasanaga tige'ma kamana urimuwe, untiye. ");
INSERT INTO for_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Piya uma uwaimogini, igeba abugunaba kanara pumagini, aposoro kina kega'e yuguni akiyenabi iyuguni, eru kasutasa iyeguntawe. Iyegumagini: Wasana Isu nkage awaga kamana a-nkuwaimiyoma, akunkitama uwaitauguni uwa wantawe. ");
INSERT INTO for_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Uwaitauguna, Wa'egawama nkageraka iyeguma ata puwaitaumeka, igeba intawamaba abima asoya puma i'mu puritegini, pi kanisore kina'mi nkakiyenabisa irosa'ma wantawe. ");
INSERT INTO for_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Piya, asi nasi tabe mono namapipe wasanami ntamapipe: Isu aeba utaratanta yagara Karaisitiwe, uwaimimagini, pi mpono kamana uwaimiyaba mima kampa kaintawe. ");
INSERT INTO for_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pigoya, pi kanabipa abagi kinapa uwoma puntini, asi nasi naninta pako puma imintiniba, Kariki kamana unta Yuta kina'mi nkabeya waepa kampa aogima iyo'maeyuguni, pika Yuta ma ago kina igeka abuguna, kampa aogi pogini kamana untawe. ");
INSERT INTO for_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Piya puguni, nagisarisa tara tumpaema aposoro kina, igeba a'ya'ma Isuti atokaenta kina ibabuma aki puwaitama maya uwaimintawe: A'yugu taeba naninta pako puma imikena yuga wasinta, Koti kamana ukena yuga kasakanaba kampa aogi pikiye. ");
INSERT INTO for_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Pika nao'mitaba, tigeba tonaentisa tara umaema kina tigeti abakapi, aogi napiyena waintaga kina, Awamusa'ama intabaipinti pumaenta kina, igaigina aogi pekiripa kibi'ma ibabiyo. Piya pigi, taeba arirasa yuga pi uwaitakini piyo. ");
INSERT INTO for_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Piya pigi, taeba nunamurape mono kamana ukenaenarape esegima peno, untawe. ");
INSERT INTO for_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kamana piya yuguni, a'ya'ma pi aki punta kina igeba abuguna kanarasa waentiye. Aibogini, wasana mayaki kibi'ma ibabuntawe: Sitibeni aeba agupipa amatiti'enabe Aota Awamusape awaitama wainta yagarawa, Piripiwa, Porokorasiwa, Nikanowa, Timoniwa, Pamenasiwa, Nikorasi aeba Antiyoki marisa paipa Yuta aruyenabi ampa pasinti ntagarawa, sumagini, ");
INSERT INTO for_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","pi kina igeba aposoro kina'mi igora asima arabama mintuguni, iyapa i'nota araku'ma, nunamu uma a'mu puwaitantawe. ");
INSERT INTO for_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Piya puguna, Koti kamana'amaba tabera anosaurite wagana puntiye. Aibogini, uwoma Yerusaremirisa kina aegaranta kina'miti irosa'ma to kake atokaema mintantawe. Pigoya, uwoma mono kiye kina'migeba aogi kamana abima, Isu aega'ma aogima mintantawe. ");
INSERT INTO for_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Pigoya, Kotiba awagaenabe esegiyenabe Sitibenipa uwoma amogana waitantogana, wasanamiti kasa'enabe awame'enabe toma toma esegima puntiye. ");
INSERT INTO for_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pigoya, to ka'isa Yuta kina'mi, ka mono agewapa: Kampa irakurinta kina uwa kina, ige aruyenabisa ka'isa kinape, Sairini kinape, Aresanteriya kinape, Sirisiya kinape, Esiya kinape, igeba aki puma Sitibeni ka abi'ma maka otantawe. ");
INSERT INTO for_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pigoya, Awamusa'ama aogi napiyena Sitibeni amogana, aogi kamana yogini, igeba ae kamanapa kampa akayuntawe. ");
INSERT INTO for_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Piyama igiga pugate wasana kumpari uwaigasuguni, igeba Sitibeni uwa kampari kamana otama, maya untawe: Ma kana yagara, aeba Mosesege Kotike isige kamana uma akayasotagi abompene, untawe. ");
INSERT INTO for_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Piya yuguni, uwa kinape, mono tisa kinape, monota kabiyume kinape, piya uma imo atikebakasuguni, mina'ma Sitibeni araku'urite mono kanisore kina'miti wantawe. ");
INSERT INTO for_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Piya, maru paitama iyokina igepa Sitibeni kampari kamana otakena kina kamana uma yokege puwaimuguni, pi kina igeba maya untawe: Ma ntagara aeba ago kamanatepe, ma tabe aota mono kumatepe, uma ataena potayaba miye. ");
INSERT INTO for_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Taeba maya yegi abompene: Isu, Nasareti kumatasa, aeba ma kumapa aguya aima, Mosese Koti nkago kamana uma aboraramintemi, pi kamanapa maema a'wae pukuwe, iye, piya kampari untawe. ");
INSERT INTO for_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Pigoya, pi mono kanisore kina igeba Sitibeni aobi nkara agaumepa, aowamaba enisorewama nkaoganta puwantiye. ");
INSERT INTO for_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pigoya igeba piya kampari yuguna, monota paitanta kiye aeba Sitibeni abigama maya untiye: Kamana yepa tagano, yogana, ");
INSERT INTO for_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitibeni maya untiye: Tabe kina'nepe, nao'mitabe, kamana yekiri abiyo: Tayabama Abara'amu, aeba Arani kumatiba kampa wanta Mesopotemiya mari mintogana, E'wasa Kotiwama aboramima, ");
INSERT INTO for_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","maya omintiye: Kaeba magape kaope itaga, naeba maba ka kayakekana, pita'i wama umiyo, untiye. ");
INSERT INTO for_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Piya yogana, aeba pi kamana abite Kaotiya mawapa atate, Arani kumati wama umintantiye. Pita'i umintogana, abawampa purogana, pi kumapa atategina, Kotiba ka ma ayakogana, mampa ma tige maema minta mari ababute kanantiye. ");
INSERT INTO for_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ababute kanama, maba kampa agorapa amima, uwa akitama toba kampa taka'ya amintiye. Aeba aga'nugibe ainti maekibeka uwa iwaga uma utawaitantiye. Pipa yagarawa kampa mintomeka, uwa piya otantiye. ");
INSERT INTO for_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Piya untana, Koti to ka kamana maya untiye: Kaga'nugiba kaboba 400, to kina'mi mpari a'yo umima kayokaya puma ataena mikibewe, pai untiye. ");
INSERT INTO for_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pigoya, to kamana ka mayama amato puma untiye: Kayokaya kina ibabikibe kina, igepa antota'ena imekini, kaga'nugipa itaigini ma mpari kanama naeti mono punatama mikibewe, piya pai untiye. ");
INSERT INTO for_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pigoya, Abara'amu pi kamana abite, abagi kina'wa ae utatantapa, i kasanema Koti otaogana, yagarawa Aisaki aborama mintogana, tonaentisa kakaga umaema yaga a'ya pogana piya puntiye. Pigoya Aisaki aeba Yekobu aboratantiye. Piya pogana, Yekobu aeba tayabamagi nagisarisa tara tumpaema kina aborawaitantiye. ");
INSERT INTO for_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Pigoya, tayabamagi igeba i'nanto Yosepe igobi potama, moneraka imuguni Isipi mari ababute wantawe. Piya puguna, pita'i wama umiyogana, Kotiba aege mima, ");
INSERT INTO for_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ataenabintisa ababumagina agu kao'ena potama mono aisa potaogana, Isipi wasana wa'ega yagara Parao, aeba agama aogi potamagina, ae'wa ntama kumatape aokina'mitape kaga kabima miyenema, tabe kiye yagara asitantiye. ");
INSERT INTO for_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Asitaogana mintogana, kaboba puma a'ya'ma Isipibe Kenani maribe tabe kabu puntawe. Piya pogini, tayabamagi igeba iga'enaga pu'ma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Piya puntini, Yekobu aeba: Isipi mari naninta waintiye, yuguna abite, tayabamagi uwaitaogini pita'i wantawe. ");
INSERT INTO for_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Pigoya, to kake a'wae puma wauguna, Yosepeba agabarami agowapa uma aborawaimogana, Paraoba aborantemi, agowapa abintiye. ");
INSERT INTO for_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Pigoya, Yosepe yogini abawampa Yekobupe a'ya'ma aokinape, to a'ya'ma wabe wayape 75 kina, ibabute wantawe. ");
INSERT INTO for_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Pigoya, Yekobu aeba Isipi mari wama umima purintiye. Piya, yakaraki'nunka tayabamagiba igeba pabi mpari pu'waewantawe. ");
INSERT INTO for_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Puruguni, kana wasana iyampuwaipa akitaurite kanamagini, Sikemu kumata, Emo ae yakaraki'nu igetisa maba ka wasana iru ma, Abara'amu monerase ika pumaranti, pita'i kaiwaitantawe. ");
INSERT INTO for_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Pigoya, Koti Abara'amu kamana ominti, pi kamana'ama aborama, esegi pikenagana agarosakena poganaba, igeba tabera Isipi mariba aborantawe. ");
INSERT INTO for_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Piya puma mintuguna, Isipi kina'mi tabe kiye yagara aoso ka aborantiye. Aeba Yosepe puntintanaba kampa napintiye. ");
INSERT INTO for_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Pigoya, pi tabe kiye yagara, aeba tayabamagi minaga pogini ataena puntawe. Piya puma yogini, yagarawaipa abe'i itauguni aeguwaewantawe. ");
INSERT INTO for_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Pi kanabi Mosese aborantiye. Pi kana yagaraba Koti nkaobi aogi e'wasa auwayaga yagarantowe. Pigoya, abawampa ntamapinti kakatama miyuguna, opa kakaga puntiye. ");
INSERT INTO for_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Aibogini, uwa mari kakatauguna, Parao nkaragama kana yagara abatama, ababuma ae'wa ntagaraganta puma kabitantiye. ");
INSERT INTO for_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Piya pogini, Parao nkaokina igeba kamana agoba omima ayakuguna, abima kamana'wape yoga pomentanabe esegima aogiyena'mana puntiye. ");
INSERT INTO for_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Piyama mintogana, kabowapa 40 pogana, aokina Isureyo kina igama abikenagaba agu'amaba aseyo pogana wantiye. ");
INSERT INTO for_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Wama Isipi yagara ka'waina Isureyo yagara ka aeguyogana agate, pi ao'yagara ao'maemagina, pi kana Isipi marisa yagaraba ara aeguntiye. ");
INSERT INTO for_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Piya puntana maya untiye: Naeba naokina Parao nkayapisa iyoba itaoma, Kotiwama unatantemi, pipa abibebe pikibebe ayabayawe, yogini, igeba pipa kampa abibebe puntawe. ");
INSERT INTO for_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pigoya, maroganaba to kake wama, Isureyo yagara taramisi ma'ena pusuguna uma isibatama, isi'aima ataraisitama maya uwaisimintiye: Ma ntagara tara, tisigerisibe ka kina mintasa, nanaraka ma'enaba pese, untiye. ");
INSERT INTO for_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Piya yogana, pi ma'ena agobima ao'yagara aegunti, aeba Mosese aebasana'ma kamana mayama a'wae pomintiye: Kaeba tasige kiyabe wa'egarepe kebaya ugatantiye. ");
INSERT INTO for_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Aiba Isipi yagara aeguma kaitampese puma, nae naegukenaga yeno, untiye. ");
INSERT INTO for_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Piya yogana, Mosese aeba pi kamana abite aegaka wama, Mitiya mari wama to kina'mige umintantiye. Pita'i umima, waya maeyogana yagarawapa tara aborantase. ");
INSERT INTO for_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Piya, kaboba 40 to kake migaite, ka'me mpari wama Sainai amu ararabiri umintogana, Wa'egawamatisa enisore ka'waina akiyaontobisa yaku nkabu antabaipinti aboramintiye. ");
INSERT INTO for_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Piya pogana, Mosese aeba nanaenamabaya piyema, agabebema agakena waogana, Wa'egawama kamana mayama aborantiye: ");
INSERT INTO for_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Naeba kayabamagi, Abara'amu, Aisaki, Yekobu, ige Kotinawe, yogana, Mosese aeba pi kamana abima tabaraba puma parokaema mintantiye. ");
INSERT INTO for_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mintogana, Wa'egawama maya omintiye: Mara aeyempepa, pipa aota mawe. Pika kagisa anapa akubo. ");
INSERT INTO for_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Naokina Isipi mari karana itama miyegini, nagisuma kube'ena purite kanaga, abirite kanaogana a'ya pegi, piya mampa iyoba itakena tumuwe. Pika kaepa Isipi mari ugatakana wama uma ibabikibene, Koti omintiye. ");
INSERT INTO for_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Pigoya, wasanami igeba: Mosese, kaepa kebaya kiyabe wa'egarepe miyoma ugatantiye, piya uma, a'a-o otauguna, Kotiba pi ntagara ae paitama iyoba itakiyema umagina, enisorewa otaogana, yaku nkabu antabaipinti aboramima yoga pipa otantiye. ");
INSERT INTO for_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Piya pumagina otaogana, wama uma ibabute kanantiye. Piya, awame'enabe kasa'enabe puma miyogana, Isipi maribe, pi tete wani ta'ema wanti mparibe, ka'me mparibe, kaboba 40 piya puma nasi nasi puma ibabuma kanantiye. ");
INSERT INTO for_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Pigoya, Mosese aewa tayabama Isureyo kina maya uwaimintiye: Koti aeba tiyokina'mi abakapisa poropete nae kanta yagara ka aborarimikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Piya, ka'me mpari aki puguna, Sainai amuti ima enisorewama nkawamupisa waiyaba kamanapa abima, uwaimogini abinta'nagi uramintawe. ");
INSERT INTO for_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Pigoya, tayabamagi igeba pi ntagarama kamanapa kaitegini, aewapa uma ata potate, Isipi mari a'wae puma wakenaga napimagini, ");
INSERT INTO for_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Eronipa maya omintawe: Kaeba kotintana puma tamegana, pi'na paitarataka a'wae puma wano. Mosese aeba Isipi marisa tababuta kananti'na, aetapaya wagasagi, kampa agaune, untawe. ");
INSERT INTO for_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Piya umagini, purumakankama iyapisa potamagini, muta atama iya nkaeguma, pintana i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Piya puguna, Kotiba akabiwaitaogini, igu'amaba a'yugu pogini, pa, nori, o'ama mpono untawe. Piya pika poropete kina'mi nkisapa kamana mayama waintiye: Isureyo agoba, tigeba kaboba 40 ka'me mpari mima, yagabe to ka'isaenabe aeguma kaema, naeti agunta kampa abasa'natantane, iye. ");
INSERT INTO for_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Tigeba amani Moroko ae mono nama kima wasintane, iye. Piya, to amani Arepanika, nori ae pumarantintanawe, utegini, ae kamana wasintane, iye. Pintanama wa'egarintana puritaogiri, nunamu otakena aogima kampa puntane, iye. Pi aguntaenaga naeba yekini, kama kina'miba tibabute Pebironi mari merigaikibewe, Koti unti kamana poropete kina'mi kaentawe. ");
INSERT INTO for_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Pigoya, tayabamagi igeba ka'me mpari kairasa Koti mpono nama kima'ma, aesagabite nasi nasi puntawe. Pipa Koti Mosese aowa ayakimagina uma aboraminti, pabi nkawameta kima'ma, aetisa mono wasintawe. ");
INSERT INTO for_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Pigoya, pi kai nama tayabamagi igeba piyama kirite kanauguna, Yosuwa paitawaitaogini, mata'i to marisa kinapa igaruba igasogini, tayabamagi igeba maema kairasa mono kima, pita mintuguna Tebiti aborantiye. ");
INSERT INTO for_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Piya, Yekobu ae Wa'ega Koti, aeba Tebitipa kao'ena potaogana, pi abimagina: Tabe mono nama kigatasuwoma, abigantiye. ");
INSERT INTO for_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Piya aewanane. Soromoni Wa'egawamanta tabe mono nama kitantiye. ");
INSERT INTO for_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pigoya, Inatisa Yagara aeba wasanami nkiyatasa kimaranta namapipa kampa miye. Pika poropete nkawamupi kamana mayama atantiye: ");
INSERT INTO for_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Mantaba naemu yabaewe. Piya, maba pipa nagisanepa ae abobora aema mimagi, a'ya'waemaenaba kabiyuwe, iye. Namapa, aya namapaya ka kinataigina kanarasakiye. Piya, marupa ayamabaya ka abora namigina aogi pikiye, iye. ");
INSERT INTO for_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Naeba nayantepisa mantabe mabe maema aborawaentuwe. Pipa kampa abewo, piya uma, Wa'egawamaba poropete kina'ma nkawamupi ataogana, piyama kaentiye. ");
INSERT INTO for_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Pigoya, kamana kampa abima aibo kina tigega, tigu tige kampa waintantikiri, tiyabamagi puma mintantasa pumagiri, Aota Awamusakaba: A'a-o, otamagiri ataena puma miyewe. ");
INSERT INTO for_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tiyabamagiba ae poropete yagara uwaba aogima atantawe. Pipa kampaye. Arupuyenama Nkagowa aborakibi, meto kamana unta, pi kina igeke kaga iyeguntawe. Piya, ainti aewa aboraogiripa, minaga puma aegukenaenaba pi tige puntawe. ");
INSERT INTO for_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kamana ago enisore nkawamupisa unti, pipa tigeba maema a'yugu potamagiri aeguntawe, Sitibeni piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Pigoya, Sitibeni kamana piyama uwaimogini, intawamaba ataena pogini igobipa tabera puntawe. ");
INSERT INTO for_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pigoya, Sitibeniba Aota Awamusa'amaba agupipa pumaewaogana, mantari aomaraogana iyogana, agaomepa Koti nke'wasaenabi Koti nkayatakanti Isu mintogana agantana, maya untiye: ");
INSERT INTO for_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","We, naeba manta a'waiyegi, Wasanama Ntagara Koti nkagora mintegi agauwe, untiye. ");
INSERT INTO for_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Piya yogini, imo kamana uma, ige akumpa aeguma apasana urite wama, ");
INSERT INTO for_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","kuma awamori uma irosa'ma, yaba kasutasa aeguntawe. Piya puntini, kamana otanta kina'miba igeba e'ero kaiwaipa atama, ka yagara, agewapa Soro, ae agisabi aki potama atamagini, Sitibeni aeguntawe. ");
INSERT INTO for_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Pigoya, Sitibeni yaba kasutasa aeguyuguna purintana, nunamu maya untiye: We, Wa'ega Isu, kaeba naumanepa maerega pureno, untiye. ");
INSERT INTO for_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Piya uma, araka pima to kake tabe kiga'e uma maya untiye: Wa'ega, kaeba ma aguntaenawaipa mae igaso, uma purintiye. Aeguyuguna purogana, ");
INSERT INTO for_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Soroba agategina antawamaba aogi puntiye. Pigoya, pi ntagaba Yerusaremi kumatasa, monota ai'aru pume kina tabera karana'ena agobima puwaitauguni, igeba iyegaka pai'ma aibarara puma, Yutiya, Sameriya mari wagana puwaewantawe. Aposoro kina ibiwai Yerusaremi kumatapa mintantawe. ");
INSERT INTO for_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Piya, mono kina ka'isa igeba Sitibeni kaitategini, kube'ena puma intara'ena potantawe. ");
INSERT INTO for_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Piya puguna, Soro aeba pi monota ai'aru pume kina karana itama, namaka namaka aigupama, wa waya ibaisusu puma iga'na namapi itama mintantiye. ");
INSERT INTO for_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Pigoya, mono pasinta kina igarubagainta kina igeba a'ya'ma kumati wagana puma, wasana mono kamana uwaimirite wantawe. ");
INSERT INTO for_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Piya puta, Piripiba Sameriya kina'mi kuma ai'nera irosa'ma, Karaisiti nkawaga kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Uwaimogini, a'ya'ma wabe wayape uwoma kina'mi kamana'waka ibogini abimagini, awame'enaba toma toma pogini agamagini, ka ima pumagini i'mu potantawe. ");
INSERT INTO for_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Piya, aeba keba uwoma igarubaogini, wasana intabaipintisa tabera: A-e, a-e, ute irosa'wauguna, nanki kinape igisa iya ataena ibunta kinape kaba itantiye. ");
INSERT INTO for_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Aibogini, pika kana kumatapa i'muntanaba tabera aborantiye. ");
INSERT INTO for_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pigoya, pi kumata kiyo'ena pome ntagara, agewapa Saimoni mintantiye. Aeba maya uma mibutaye: Naeba naona kina'nepa tagane, untiye. Piya uma, Sameriya marasa kinapa pami puwaigasogini, ");
INSERT INTO for_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ima minta kinake tumima minta kinake aeka abugunaba iyogini, maya uma mintantawe: Ma amani yagaraba Koti otanti ntagara esegiyena agowe, untawe. ");
INSERT INTO for_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Piya yuguna, aona kina'maba e'ero kanabi piya pogini, pami pumagini aeti uma airokaema mintantawe. ");
INSERT INTO for_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Miyuguna, Piripiba Koti kabiratakena aogi kamanape, Isu Karaisiti nkawaga kamanape uwaimogini abibebe puma, wabe wayape a'ya'ma mono wani pai'waentawe. ");
INSERT INTO for_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Piya puguna, Saimoni aebe pabiyama pi mono abima wani pai'ma, Piripige kabo puma nasi nasi pogana, awame'enabe tabe esegiyenabe pogana, agama uwoma nkagi napima mintantiye. ");
INSERT INTO for_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Pigoya, Sameriya kumatasa kina'mi Koti mpono abuguni, pi iwaga kamana Yerusaremi kumati aposoro kina'miti waogini abintawe. Piyama abitegini, Pitake Yonike uwaisitaugunisi tumintase. ");
INSERT INTO for_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tumpa irosa'maginisi: Aota Awamusa igeti tumenema, Wa'ega esotantase. ");
INSERT INTO for_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Piya, igeba Isu nkagera mono wanipa pasintaka, Aota Awamusapa igetiba kampa tumogini, uwa mintantawe. ");
INSERT INTO for_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Pigoya, aposoro tara isigeba isiya i'nota atausuguna, igetiba Aota Awamusa tumpintantiye. ");
INSERT INTO for_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pigoya, kana Saimoni agaomepa, aposoro isigeba wasanami nki'nota isiya atausuguna Aota Awamusa tumogana, isigategina mone maete isigeti uma irosa'ma, ikapukena puwema, mayama isibigantiye: ");
INSERT INTO for_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Tisigeba naepa pabiyama pi nkesegiyenaba namisigi, to ka'isa kina'mi nki'nota nayantepa atakana, Aota Awamusa'wapa tumpiyeno, umagina isibigantiye. ");
INSERT INTO for_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Piyama isibigaogana, Pita maya omintiye: Kaeba Koti nka'muntanaba monerasa ika pikena yempe'nagiba, monegantaga kaegapa ata puwakibese. ");
INSERT INTO for_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Piya, pipa kae'enaba kampaye. Kantawamaba Koti nkaobi kampa aogima parutu piye. ");
INSERT INTO for_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Kaeba maema pi ata pikenaenagapa kaite, kagu a'wae puma Wa'ega esotagana, kagupi egaenaga waintemipa asu'a pugagasano. ");
INSERT INTO for_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Naeba kagaopa, kaepa egaena ataena asaenagampa kagibe puntiye, Pita piya omintiye. ");
INSERT INTO for_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Omogana, Saimoni maya a'wae puma omintiye: Tisigeba naeka uma Wa'ega esotaisigina, nau'imagina pi yementanaba kampa abora nameno, untiye. ");
INSERT INTO for_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pigoya, aposoro isigeba a'ya'ma wabe wayape Wa'egawama kamana esegima uwaimiteginisi, Yerusaremi kumati a'wae puma wantase. A'wae puma wantinisi, Sameriya uwoma kumati aogi kamana uwaimita wantase. ");
INSERT INTO for_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Pigoya, Wa'egawamatisa enisore ka'waina Piripi maya uma omintiye: Kaeba aseyo puma kagi Yerusaremi kumatisa Kesa kumati tume ki'i tumo, piyama omintiye. Piya pi ki'i ka'me mpari waye. ");
INSERT INTO for_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Piyama omogana, Piripiba aseyo puma wantiye. Piya, Itiyopiya maba piya tabe wae ka mintanti, agewapa Kantesi, ae tabe yagaraba, mone kuta tabe kiye yagaraba aeba Yerusaremi kumati mono kamana wama intiye. ");
INSERT INTO for_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Piya, a'wae puma wakena osiwama paibute wakena karewapi wantana, poropete Aisaya ae kamana awa'ena aisuntiye. ");
INSERT INTO for_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Piya pogana, Awamusa'ama Piripi maya omintiye: Ke'i kaeba wama, maro kare uma abatao, untiye. ");
INSERT INTO for_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Piya yogana, Piripiba wama uma abatama, pi ntagara aeba poropete Aisaya ae kamana awa'ena aisogana, abima mayama abigantiye: Kamana aisempe'na, pi agowapa abeno, untiye. ");
INSERT INTO for_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Piya yogana, aeba maya untiye: Ka'waina kampa unamintakapa, naenepa ayamagi kanarapa abukuwe, untiye. Piya umagina, Piripi omogana karebi ima kabobuma mintantase. ");
INSERT INTO for_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kamana awa'ena aisunti, pipa mayamawe: Sipisipi aegukena ababesa pumagini, uma ababuma aegukibewe. Piya, to sipisipi aya kasa kina'mi nkigora: Kae-gae, kampa unta waiyisa puma, kamana kampa unta mikiye. ");
INSERT INTO for_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Igeba karana potama, parutu kamanapa kampa otakibewe. Mampabi aege mikibe kinapa kamana'wapa kampa abikibewe. Igeba mabi miyaba'enawapa ago maegasigina ikiye, pi nkisapisa kamana aisuntiye. ");
INSERT INTO for_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Piyama aisuntana, kana tabe yagara aeba Piripi maya uma abigantiye: Kaeba yega abeno. Poropete aeba kekabaya piyaba iya, aewakabe to ka'wainakabaya iye, untiye. ");
INSERT INTO for_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Piya yogana, Piripi abite, poropete yagarama kamanapi aigima Isu nkaogi kamana omintiye. ");
INSERT INTO for_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Piya uta wama, wanita uma irosantase. Piya puntana, tabe yagarama maya untiye: Agao. Wanipa mampa waintiye. Mono wanika yekanapa kanara pai'natakibeno, uma abigantiye. ");
INSERT INTO for_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","(Pigoya, Piripi maya untiye: Taga abima, kagupa aeti amegapa kanarane, yogana, antota maya omintiye: Isu Karaisiti aeba Koti Ntagarawe. Pipa abibebe puwe, omintiye.) ");
INSERT INTO for_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Pigoya, kareba pita atate, Piripibe kana tabe yagarabe waniti tumima, Piripiba kana yagara wani pai'atantiye. ");
INSERT INTO for_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Piya wanipisa iyusuguna, Wa'egawamatisa Awamusa'ama Piripi ababute waogana, tabe yagara aeba to kake kampa agantana, antawama asoyaenabisa ke'wati wantiye. ");
INSERT INTO for_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Pigoya, Piripi aeba Asito kumati irosaogini agantawe. Uma irosa'magina, pitasa agobima kumaka kumaka aogi kamana uwaimita wama, Sisariya kumata uma irosantiye. ");
INSERT INTO for_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Soro aeba Wa'egamati atokaenta kina kama puwaitama, karana itama iyegukena agi napintiye. Aibumagina, monota paitanta kiye yagaramati wama kamana yogana: ");
INSERT INTO for_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Soro ao'maeyiyema, esa kaema, Tamasiko kumata miyume Yuta kina'miti kaema amintiye. Amogana maete marota'i wama, Wa'egawamatisa kasa ki aega'ma miyume kina ibatama, wabe wayape iyakana u'ma ibabute Yerusaremi kumati kanakena wantiye. ");
INSERT INTO for_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Piya wama Tamasiko kuma nkagora uma irosakena pogana, mantarisa apayaena tumima tumpa e'wasa potantiye. ");
INSERT INTO for_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Aibogana, mabi ware'nama mima, kamana ka mayama abintiye: Soro, Soro, kaeba nanaga karana punatama naeguyene, yogana, ");
INSERT INTO for_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Soroba mayama abigama untiye: Wa'ega, kaeba kegawe, yogana, aeba maya untiye: Karana punatama naeguyempe, Isu naewe. ");
INSERT INTO for_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Pigoya, kaeba asima mare kumati wagini, pita'i piya pikena kamanapa ugamikibewe, omintiye. ");
INSERT INTO for_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Pigoya, wasana aege wanta kina igeba kamana kampa unta, uwa mintantawe. Piya, igeba kamana'amaba abintawe. Piya, to ka'enaba kampa agantawe. ");
INSERT INTO for_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Piya, Soroba asima agaomepa, aoba tunusuwaogana kampa agantiye. Aibogini, aokina'mi ayakana urite, Tamasiko kumati ababute wantawe. ");
INSERT INTO for_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Pigoya, pita'i kakaga yagaba uwa aorikaema mima nanintabe wanipe kampa nanta, uwa a'a-o uma mintantiye. ");
INSERT INTO for_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Pigoya, Tamasiko kumata Isuti atokaenta yagara ka mintantiye. Agewapa Ananayasiwe. Aepa Wa'egawama amonta patama: Ananayasi, piya agega'e yogana, abite: Wa'ega, naeba maye, untiye. ");
INSERT INTO for_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Piya yogana, Wa'egawamaba amato puma maya untiye: Kaeba parutu ki'i wama, Yutasi ntamapi ima, ka Tasasi kumatasa yagara, agewapa Soro, ae uma abatao. Aeba ibanto nunamu uma miye. ");
INSERT INTO for_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Aeba agu'amaba mayaena agantiye: Ka yagara, agewapa Ananayasi, aeti uma irosa'ma ao agakena ayapa a'nota ataye, piya agantiye, untiye. ");
INSERT INTO for_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Wa'ega aeba kamana piya uma omogana, Ananayasi maya untiye: Wa'ega, pi ntagaraba tabera yega abuwe. Aeba kaege atokaenta kinaka Yerusaremi kumatapa karana'enaba aseyonaba kampa puwaitaye. ");
INSERT INTO for_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Pigoya, mata'iba pabiyama kae kage kawaga kamana yompe kinapa iga'na taepa taubu'urite wanema, tabe mono kiye kina'mi igeba otawe, untiye. ");
INSERT INTO for_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Piya yogana, Wa'egawama maya omintiye: Kaeba uwa wao. Pi ntagaraba yoga kina'ne otauwe. Aeba nage nawaga kamana'ne namu kinape wasana wa'ega kinape Isureyo aruyena igeti, yogane purite wama mikiye. ");
INSERT INTO for_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Piya peka, naeba nage nawaga kamana'neka uma awaenama nkagupi miyenema, otakana abikiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Pigoya, Wa'ega aeba piya yogana, Ananayasi aeba wama namaka yome, pita'i ima Soro nka'nota ayapa atama, maya untiye: Soro, nao'yagara, Wa'ega Isu ke'i aboragamiti, ae unatagi kanauwe. Kaeba kao agagana, Aota Awamusa'amaba kae kagupi pumaeyanoma iye, untiye. ");
INSERT INTO for_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Piya uma omogana, pabigo aobi aobariyanta kinatomepa aigaga paogana, agamagina asima iyogana, mono wani pai'ataogana, ");
INSERT INTO for_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","naninta nama esegi puntiye. Pigoya, Soro aeba pi kumatasa Isuti atokaenta kina igege uwaenanto mima, ");
INSERT INTO for_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","pabigo karu'ena Tamasiko kumata Yuta kina'mi mpono namapi ima, Isu nkawaga kamana uma maya uwaimintiye: Isu aeba Koti Ntagarawe, untiye. ");
INSERT INTO for_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Piyama uwaimogini, abima pami pumagini maya untawe: Yerusaremi kumati pi nkagi yegana, pitaka karana itaurite, mata'iba pabiyama iga'na taubu'urite, tabe mono kiye kina'miti wakena kananti'naba, pipa ayama a'wae uyenaba piye, untawe. ");
INSERT INTO for_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pigoya, Soro aeba esegiyena maemagina: Isu aeba taga Karaisitiwe, uma, pi kamana agoba uma aborama aogi pogini, Tamasiko kumata Yuta kina mintanta uwaimogini, abima uwoma nkigi napintawe. ");
INSERT INTO for_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Piya, ka'isa yagaba pogini, Yuta kina'mi Soro aegukena naga'nikintawe. ");
INSERT INTO for_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Piyama wa naga'nigi'urite, kibira arape asekape minaena puma aegukena kabiyuguna abite, ");
INSERT INTO for_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","wakena pogini, aseka aokina'mi ababute wama, yabatasa kibi kimarantati imagini, wa'nu kupi ira'atama iga'na ubu'atama u'yobaso puguna, tumima wagaintiye. ");
INSERT INTO for_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Piya puguna, Soro wama Yerusaremi kumata uma irosa'ma, Isuti atokaenta kina igeti uma amato pikena yogini, a'ya'ma kina igeba iyekuru pumagini, atokaenti ntagarawemaba, kampa napintawe. ");
INSERT INTO for_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Piya puguna, Panabasi ao'ena potama, ababute aposoro kina'miti wama, Isu Soro ke'i aboramima kamana omogana, Tamasiko kumata Isu nkawaga kamana tabera uma aboranti, pi kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Piya uwaimogini abuguna, igege Yerusaremi kumati nasi nasi puma mintantiye. ");
INSERT INTO for_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mima, Wa'egama nkage awaga kamanapa kampa karu punta wasanaba uwaimintiye. Piya, Kariki kamana abinta Yuta kina'miba mono uma abigamaka puntiniba, kamana a'waebu puntawe. Pi kina'mi ige aegukena yuguni, ");
INSERT INTO for_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","aokina'miba abite Sisariya kumati ababute tumima metauguna, wama Tasasi kumata uma irosantiye. ");
INSERT INTO for_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Piya pomeka, a'ya'ma Yuta mari, Karariya mari, Sameriya mariba, igeti paruyena aboraogini, monota ai'aru pume kina'mi to kake esegi puma mintantawe. Igeba Wa'egawamati uma airokaeyuguna, Aota Awamusa'amaba intabaipintiba esegi puwaitantiye. Piya pogini, to wabe wayape uwoma kina'mi mono namapipa igege ampa pai'ma tabe puwantawe. ");
INSERT INTO for_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pigoya, Pita aeba a'ya'ma mari nasi nasi puta puta, Kotiti atokaenta kina Arita kumata mintume kina, igeti uma irosantiye. ");
INSERT INTO for_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Irosa'magina, pita'i ka yagara agantiye. Agewapa Iniyasi, aeba aga'na asawaogana nankitama miyogana, kaboba tonaentisa kakaga umaema puwantiye. ");
INSERT INTO for_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pigoya, Pita mayama omintiye: Iniyasi, Isu Karaisiti aogi pugatama kabakataye. Asima amakapa akubuma akarakiyo, omintiye. Piyama omogana, pabigo asiwantiye. ");
INSERT INTO for_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Piya pogini, a'ya'ma Arita Saroni kumatasa kina'miba agamagini, igu a'wae puma, Wa'egawama tuntana puma aegarantawe. ");
INSERT INTO for_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Pigoya, Yopa kumata Isuti atokaenti nkwaepa ka mintantiye. Agewapa Tabita, piya Kariki kamanapipa Tokasiwe. Kamanatepipa Esawe. Aeba asi nasi aogiyenamana pumagina, a'ya'ma wabe wayape ka'isaenaga aguyosagaume kinapa aogima iyo'maema mibutaye. ");
INSERT INTO for_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Pigoya, pabi ntagaba Tokasi aeba yonintana aboramogana purintiye. Purogini, autiba wani pai'atama nama ka marupi metauguna waintantiye. ");
INSERT INTO for_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pigoya, Arita kumapa pipa agarota waintomeka, atokaenta kina igeba Pita awaga kamana abite, wasana tara uwaisitaugunisi, aeti Yopa kumati wama maya omintase: Kae kababute, tae wa'eri karu'ena wanema kanause, untase. ");
INSERT INTO for_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piya yusuguna, Pitaba abima aseyo puma, isigege wama uma irosa'ma, wasana yabae waintometi ababute intawe. Iyogini, abeya wae'iya a'ya'magini kobe puma mimagini, intara'ena puma Tokasi aogama mintana kai pagumpa iminti, pipa ayakiwaentawe. ");
INSERT INTO for_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piya puguna, Pitaba uwaitaogini, abe'i irosa'ma tumiwaegasuguna, arakabima nunamu untiye. Nunamu uma a'ya atate, aowaba a'wae puma kana wasana yabae waintometi agau'ma maya omintiye: Tabita, kaeba asiyo, untiye. Piya yogana, ao apina'ma Pita agama asima mara'miyogana, ");
INSERT INTO for_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ayata u'ma asitantiye. Asitantana, Kotiti atokaenta kinape pi abeya waepe kega'e yogini, iyuguna Tokasi aogatama a'wae puma imintiye. ");
INSERT INTO for_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pigoya, pi awaga kamana Yopa kumatapa abae puma anosaogini, uwoma kina'mi Wa'egawama mpono aegarantawe. ");
INSERT INTO for_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pigoya, Pitaba uwoma ntaga Yopa kumata to ka Saimoni, purumaka ari pome ntagara, aege mintantiye. ");
INSERT INTO for_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pigoya, Sisariya kumata ka yagara, agewapa Koniriyasi, mintantiye. Aeba Itari marisa irebu kina'mi kiye yagara mintantiye. ");
INSERT INTO for_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Pigoya, aewape aege mintanta kinape a'ya'ma igeba Kotika karu pumagini, monotapa aogima mintantawe. Pigoya, Yuta kinapa monebe kotape imima aogima iyo'maentana, asi nasiba Kotiti esotama mintantiye. ");
INSERT INTO for_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pigoya, Koniriyasi piya pogana, ka yagaba atamaita Kotitisa enisore ka'waina ampa aboraogana, agega'e: Koniriyasi, untiye. ");
INSERT INTO for_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Piya yogana, aekuru puma: Wa'ega, nanagawe, untiye. Piya yogana, aeba maya untiye: Nunamube kao'enagape Kotiti iyegina, abima aogi pugataye. ");
INSERT INTO for_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Pika kaeba Yopa kumati wasana uwaitagini wama, ka yagara agewapa Saimoni, aoso agiba Pita, ae uma ababute kanaiyo, uwaitao. ");
INSERT INTO for_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Aeba auka Saimoni, purumaka ari pemi ntagara, ae namapi wani nkawamori a'yo umintakiya, uma ababute kanaiyo uwaitao, uma omintiye. ");
INSERT INTO for_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Enisorewamaba kamana piyama omite waogana, kayokaya yagara tarawa, irebu kina'wampitisa mono waintaga yagara kana, suma, igega'e uma, ");
INSERT INTO for_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","pi kamanapa uwaimiwaetama, Yopa kumati uwaitaogini wantawe. ");
INSERT INTO for_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Pigoya, pi kina igeba wama ke'i uma waimarategini, maroginiba to kake wama kuma agora uma irosakena puguna, kagi abebe pogana, Pitaba nama nkabobori ima nunamu asu untiye. ");
INSERT INTO for_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nunamu asu yogana, aga'ena abogana, yogini naninta kao'ena potauguna, aesaro'ena puma ayampuga kampa abogana, amonta mayaena agantiye: ");
INSERT INTO for_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Mantaba a'waiyogana, ka'ena kaiba taberaka'ya atunkatapa iga'na ubu'atama atauguna, mabi tumintiye. ");
INSERT INTO for_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Pigoya, kana antabaipintiba yaga kuya kabara uwoma toma toma kina atamagina pugasanaogana mintometa tumogana, ");
INSERT INTO for_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","maya kamana aborantiye: Pita, kaeba asima aeguma nao, yogana, ");
INSERT INTO for_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita maya untiye: Wa'ega, naeba uwa a'yugu kina'mi ntanintabe i'ni ntanintabe kampa naontanawe, untiye. ");
INSERT INTO for_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Piya yogana, to kake maya kamana aborantiye: Kotiba uma aogi piya, pi ntanintagaba kaeba uma ataba a-po, untiye. ");
INSERT INTO for_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Pintana kakagara aboraogana, pabigo pi kaiba mantari a'wae puma intiye. ");
INSERT INTO for_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pigoya, Pitaba pi kasa'ena agaomeka, uwoma nkagi napiyogini, pabigo kana Koniriyasi nkaokina igeba wa'eri uma irosa'ma, Saimoni ntamaka ibigata wama uma abatamagini, kabera uma asima mima, ");
INSERT INTO for_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","agega'e uma aguyosa'ma maya untawe: Saimoni, aoso agiwapa Pita, aeba ma ntamapi mintiyo, piya untawe. ");
INSERT INTO for_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pigoya, Pita pi kasa'ena agaomeka napi napima mintogana, Awamusa'ama maya omintiye: Kaeba abo. Kakaga kina kanama ampa kaguyosagawe. ");
INSERT INTO for_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Pika kaeba irosa'ma timimagina, igege wakenagaba a-kuntaba po. Pi kinapa nae uwaitaogini kanawe, omintiye. ");
INSERT INTO for_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piya omogana abite, Pitaba kana kina'miti irosa'ma tumima, maya untiye: Naguyosagapa naeba maye. Nanaga kanawe, yogini, ");
INSERT INTO for_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","pi kina igeba maya omintawe: Irebu kina'mi kiye yagara Koniriyasi uratagi kanaune. Aeba Kotika karu puma aogiyenabi miyegini, a'ya'ma Yuta kina'miba aeka abeganaba, aogi pemi, aeti aota enisore ka'waina aboramima, kaeka namankapi kanama ampa kamana ugamekana aboma, omegina, tagarubagi kanaune, untawe. ");
INSERT INTO for_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piya yuguna, Pitaba namankapi ibabuwaitama, pi nkaseka aogima kabiwaitaogini waimarantawe. Waimarauguna, maroginiba, aeba Yopa kumatasa ka'isa Isu mpono abinta kinape, kaga wantawe. ");
INSERT INTO for_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Pigoya, igeba ke'iba ka ase uma waitategini, wama Sisariya kumata uma irosantawe. Pigoya, pita Koniriyasi aeba ae tunkape to ka'isa aokinape igega'e uma, igawa pumagini mintuguni uma irosantawe. ");
INSERT INTO for_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Uma irosa'ma, Pitaba namapinti iyogana, Koniriyasiba kanama agisabi ampa parokaema, a'mu potantiye. ");
INSERT INTO for_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Aibogana, Pitaba ababuma asitama maya omintiye: Asiyo. Naeba wasananawe, omintiye. ");
INSERT INTO for_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piya kamana utaginisi, namapinti ima wasana aki puma mintuguna, asu igama maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Tigeba Yuta kina tae agoba abintawe. Taeba to marisa kina tigege tao'ena puma umisanagaba akutatantane. Pigoya, naeba tigekaba a'yugu kina i'ni kinaneba kampa uritakuwe. Kotiba agowapa unamima nayakintika, ");
INSERT INTO for_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","naeba kamanatipa kampa akayunta, uwa kamanati wasima kanauwe. Pika naeba ibaba tibigauwe: Tigeba nanaga nagega'e yega kanauwema, ibigantiye. ");
INSERT INTO for_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Piyama ibigaogana, Koniriyasiba maya omintiye: Naeba kasa'ena agategi mirite kanaogana, tarawa tarawaki yaga a'ya piye. Pi kamana ugamukuwe. Naeba atamaita nunamu yuwagana, ka yagara kaiwapa wae'wae puwanta naeti aborama, ");
INSERT INTO for_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","maya unamitaye: Koniriyasi, Kotiba nunamugapa abima, wasana mone kotatasa iyo'maeyampekaba abima aogi pugataye. ");
INSERT INTO for_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Pika kaeba Yopa kumati wasana uwaitagini, Saimoni, aoso agiba Pita, ababute kanaiyo. Aeba auka to Saimoni, purumaka ari pemi ntagara, ae namapi miyemi, kana namankapa wani nkawamori waintiye. Pi kana Pitaba mata'i kanama ka'isa kamana ugameno, yoga abituwe. ");
INSERT INTO for_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pigoya, naeba pika wasana uwaitaogini, kaetiba watagana, kaeba kamana'nepa abima, kanampeka nantawama aogi piye. Pigoya, mapa Wa'egawama kamana ugaminti, pi yega abenemagi Koti nkaobi aki puma mintune, piya untiye. ");
INSERT INTO for_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pigoya, Pitaba awamu aseyo puma maya uwaimintiye: Koti aeba wasana taukaba abeginaba iyegina tumeginaba kampa piye. Pipa abibebe puwe. ");
INSERT INTO for_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Piya, toma toma kina'mitisa ka'isa kina'miba aeka karu puma aega'ma, ae aobi aogima miyiginaba, igega'e ukiye. ");
INSERT INTO for_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kotiba Isureyo kina taeti kamana au'wapa maema aboranti, pi nkawaga kamana tigeba abewe. Aeba Isu Karaisiti, a'ya'waemaenama Nkwa'ega otaogana, paru aogi kamanapa uramiwaentiye. ");
INSERT INTO for_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Pigoya, Yuta mari aboranti, pi nkawaga kamanapa mayama abewe: Yoni aeba wasana mono waninkama kamana uwaimogini abuguna, Isu, Nasareti kumatasa, ae Koti Aota Awamusape esegiyenawape amogana, Karariya mari mono yugawapa agobintiye. Piya, a'ya'ma maba ainkima nasi nasi puma wasana iyo'maentiye. Aibumagina, a'ya'ma ke kina'ma intabaipinti minta kinapa aogi puwaitantiye. Kotiba ao'maema, wage aetaogana pi ntugaba puntiye. ");
INSERT INTO for_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Pigoya, Yuta kina tae maribe Yerusaremi kumatibe unti puntintanaba, pipa taeba agama abiwaentune. Pigoya, ainti maripora aeguyuguna purintiye. ");
INSERT INTO for_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pu'ma mintogana, kakaga yaga a'ya pogana, Koti abage puntiye. Abage puma asitaogana, aborate kakate puntiye. ");
INSERT INTO for_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Pigoya, a'ya'ma kina'mitiwanane. Wasana aogi kamana'wa ukena kina Koti pai ibabumaranti, taetimana aborantiye. Pi purintapisa asiyoga, aege naninta kaga nama, kamanapa uma abintompene. ");
INSERT INTO for_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Pigoya, Kotiba aepa aoso kina purinta kina tae tabe kiya yagara asitantiye. Pi nkawaga kamana a'ya'ma kina uma aborama uwaimiyoma, uratantiye. ");
INSERT INTO for_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Pigoya, aeka napima imatiti pikibe kina age awaga kamana'waka uma aguntaenawaipa Koti asu'a puwaigaikiye. Pipa a'ya'ma poropete kina ige uma aborantawe, Pita piya untiye. ");
INSERT INTO for_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pigoya, Pita piya yogini, a'ya'ma abima mintume kina igeti Aota Awamusa tumintiye. ");
INSERT INTO for_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pigoya, Koti to marisa kina'miti Aota Awamusapa ti'ma imogini, ka'isa Yuta kina, Isu nkaegaranta Pita abagi punta kina, igeba agate pami puntawe. ");
INSERT INTO for_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Piya, to marisa kina'miti Awamusa tumogini, to kamana to kamana umagini Koti uma tabe potauguni, abima pami puntawe. Piya puguna, Pita maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Taeti Aota Awamusa tuminti, pabiyama ma kina'miti tumemika, mono wanipa kampa akunkitakune, untiye. ");
INSERT INTO for_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Piya uma yogini, ao'miba ibabuwaitama Isu Karaisiti nkagera mono wani pai'itantawe. Piya puguni, igeba Pita arakuruguni, ka'isa yagaba igege mintantiye. ");
INSERT INTO for_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Pigoya, aposoro kinape Isu nkaegaranta kina Yutiya mari mintume kinape, igeba namu'isa kina'mi Koti kamana aegaranta, pi nkiwaga kamana abintawe. ");
INSERT INTO for_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Piyama abuguna, Pitaba Yerusaremi kumati a'wae puma iyoginiba, Isu nkaegaranta i kasanta kina'miba aeka abugunaba kunta ibogini, ");
INSERT INTO for_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","maya omintawe: Kaeba nana pikena to mari wama, i kampa kasanta kina'migeba nanintaba nane, untawe. ");
INSERT INTO for_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Piya yuguna, Pitaba pintana aboraminti, pi kamanapa agorasa agobimagina, maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Naeba Yopa kumata nunamu uma mintuwagana, napiyenanempa a'wae poga, amontagantaena agauwapa, mayaena aboranamoga agantuwe: Piya ka'ena tabe kaigantaena atupa maema kabobuma, iga'narasa ubu maranta, pi mantabintisa pubasanauguna tumima, nagora tumpa irosantiye. ");
INSERT INTO for_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Tumoga, agabebe puma igama pakobuma mayama agantuwe: Antabaipintiba tonarona kina, yagabe kabubintisa kina kuya kabara a'ya'ma kinapa pita agantuwe. ");
INSERT INTO for_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Pigoya, naeti kamana mayama aborantiye: Pita, kaeba asima aeguma nao, untiye. ");
INSERT INTO for_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Piya yoga naeba maya untuwe: Wa'ega, pipa kampaye. Naeba uwa a'yugu kina'mi ntanintabe i'ni ntanintabe kampa naontanawe. ");
INSERT INTO for_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Piya yuwagana, mantarisa ebi ebi kamana to kake maya untiye: Pipa Kotiba uma aogi pegina, kaeba uma ataba a-po, untiye. ");
INSERT INTO for_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Piyaena aboraoga, kakaga pogana, kana a'ya'waemaena mantari a'wae puma intiye. ");
INSERT INTO for_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Pigoya abiyo. Pintanaba kakawaogana, pabigo Sisariya kumatisa kakaga kina apa naeti wama nama mintuwampe, pita'i uma irosantawe. ");
INSERT INTO for_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Uma irosauguna Awamusa'ama maya unamintiye: Kaeba igege wakenaga ata kagiba a-ntapima wao, unamintiye. Piya yoga, wauwagini ma taokina tonaentisa ka'umaema kina'miba nabagi pugu, wama uma irosa'ma irebu kina'mi kiye yagarama ntamapi iyuwakana, ");
INSERT INTO for_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","maya kamana uramintiye: Nae namapi enisorewama aboranamima maya unamintiye: Kaeba Yopa kumati apa igarubagini, Saimoni, aoso agiba Pita, uma ababute kanaigina, ");
INSERT INTO for_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","kamana urimekiri kaebe kao'mibe tigeba abigina, Kotiba ti'ima aogi puritakiye, piya unamiyema, kana kiye yagara unamintiye. ");
INSERT INTO for_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Pigoya, naeba mono uwaimuwagana, pai taeti Aota Awamusa tumintisa puma, pabiyama igetiba tumintiye. ");
INSERT INTO for_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Piya poga, naeba pi agategi, Wa'egawama kamana maya unti, pipa napintuwe: Yoniba uwa wanitaka'ya paititantiye. Piya naeba Aota Awamusatasa paititakuwe untika, napintuwe. ");
INSERT INTO for_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Pigoya, taeba Wa'ega Isu Karaisitika napima tamatiti puwakana, pintanaba tae-isa puntiye. Pabiyama to marisa namu kinape i'muntanaba puwaitama, Aota Awamusa imintiye. Pipa naeba ayama Kotipa kepa akunkatakuwe. Pipa kampaye, Pita piya untiye. ");
INSERT INTO for_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Piyama uwaimogini, igeba abima intaba paru pogini, Koti i'mu potama maya untawe: We, Kotiba to marisa kina igu a'wae puma, miyaba mikenaenaga igegeba uwaitaye, piya untawe. ");
INSERT INTO for_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Paipa Sitibeni pu'waoganaba tabe kuntuyena aborantiye. Piya pogini, Isu nkaegaranta kinapa iyegaka pai'ma wama, Pinisiya, Saiparasi, Antiyoki mari umima, Yuta kina'amana mono kamanapa uwaimima mintantawe. ");
INSERT INTO for_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Pigoya, ige abakapisa Saiparasi kinape Sairini kinape Antiyoki kumati irosa'ma Kariki kina igege, pabiyama kamana uma abirite, Wa'ega Isu mpono kamana uwaimintawe. ");
INSERT INTO for_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Piya, Wa'egawamaba esegiyena imogini uwaimuguni, uwoma kina'mi abima igu a'wae puma Wa'egawama tuntana puntawe. ");
INSERT INTO for_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Pigoya, pi kamana Yerusaremi kumati waogini, monota ai'aru pume kina igeba abite, Panabasi otauguna Antiyoki kumati wantiye. ");
INSERT INTO for_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wama uma irosa'ma agaomepa, namu'isa uwoma kina'mi Isu aegarauguna uma igama, Kotitisa awagaena igeti aboraome, agama antawama aogi pogana, Wa'egawamati uma airokaema mikibeka ige'ma kamana esegima uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Piya, Panabasi aeba aogi yagarawe. Agupipa Aota Awamusape amatiti'enawape pumaema waitantogana, pi namu'isa kina igaogana antawama aogi puntiye. Piya, kana kumatapa uwoma kina'mi Wa'egawama tuntana puntawe. ");
INSERT INTO for_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Pigoya, Panabasi aeba Tasasi kumati wama, Soro uma abatakena wantiye. ");
INSERT INTO for_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wama uma ababoginisi, Antiyoki kumati kanantase. Kanama ampima monota ai'aru pume uwoma kina'mige mima, ka kaboba mono uwaimintase. Pigoya, Antiyoki kumatasa wasanamiba Isuti atokaenta kina ige igewaipa Karisiteni kina'nema uma aborantawe. ");
INSERT INTO for_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pi kanabipa, poropete kina Yerusaremi kumatisa Antiyoki kumati tumintawe. ");
INSERT INTO for_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Pigoya, igetisa ka, agewapa Agabasi, aeba Awamusa'ama otaogana a'ya'ma mari nanintaga tabe kabo pikibe, pi kamanapa untiye. Piya, pi kana kaboba Aroma kina'mi wa'ega yagara Korotiyasiba, aeba mintogana aborantiye. ");
INSERT INTO for_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Pigoya, Antiyoki kumatasa Isuti atokaenta kina igeba pi kamana abite, mone iyotasaenawai waintomepa aki puma, Yutiya mari iyo'miti ataigina wakibika, uma esegi puntawe. ");
INSERT INTO for_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Pigoya, mone maema aborama aki puntapa, Panabasike Soroke isimugunisi, maete wama aegaranta kinata kabiyume kina'wai me imintase. ");
INSERT INTO for_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Pi kanabipa, wasana wa'ega yagara Erotiba monota ai'aru pume kina ka'isa, karana itama agasiyaena puwaitantiye. ");
INSERT INTO for_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Piya puntana, yogini Yoni nkaganto Yemisipa kasotasa aegugasuguna purintiye. ");
INSERT INTO for_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Piya pogini, uwa Yuta kina'mipa iga ibogana igama, Pitapa pabiyama yogini, yisiti kampa wainta pareti nakena yaga arosaogini, araku'ma iga'na utintawe. ");
INSERT INTO for_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Pi Pasoba yaga, i'ikena yaga, a'ya pekanaba, Yuta kina iyakima aegukenaga napima yogini, iga'na namapi atama, irebu kinapa tonagisarisa ka'umaema kina'mi kiya kabintawe. ");
INSERT INTO for_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Pigoya, Pitaba iga'na namapi mintogini, monota ai'aru pume kina igeba asi nasi aeka napima Kotiti nunamu uma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Pigoya, Eroti aeba marekanaba wasana iyakikena yaga aboranti, pi nkasekapa irebu yagara taramisi isigeba isibakapi Pita iga'na tara ubu'atama waimarantiye. Piya, to irebu yagara taramisi nama kaberi kiya kabima mintantase. ");
INSERT INTO for_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Pigoya, Wa'egawamatisa enisore ka'waina pabigo aborama asiyogana, namapa e'wasa puwantiye. Piya pogana, enisorewamaba Pita abekintata aukayama abage puma: Ke karu'ena asiyo, yogana, Pita nkayapisa iga'naba iyobantiye. ");
INSERT INTO for_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Piya pogana, enisorewama maya omintiye: Kautasaenaba maema pu u'ma, kagisa anapa maema igiyo, untiye. Piya pogana, enisorewama to kake omintiye: Mu'mu kaigapa maema pu u'ma naegarao, yogana, ");
INSERT INTO for_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","aega'ma wantana, enisorewama pomentanaga aboganaba amonta ki'i pusuyena puntiye. ");
INSERT INTO for_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Pigoya isigeba to ka kabira piyama mintugunaba igasima uma pasite puta, kumati tabe kabi kimaranta, pita uma irosausuguna aewa uwa a'waiwaoginisi tumintase. Tumima ke'i wantinisi, karu'ena enisorewama Pita megaite wagaintiye. ");
INSERT INTO for_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Piya pogana, Pita age'magina maya untiye: Mapa napiyuwe. Wa'ega aeba enisorewa otagina, Eroti nkiga'nabisabe Yuta kina'mi nkigobintanabisabe iyoba nataye, piyama napintiye. ");
INSERT INTO for_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Pita aeba piyama napigaite age urite wantiye. Wama Yoni Maka ae ano, agewapa Mariya, ae namata uma irosantiye. Pita'i uwoma kina'mi aki puma nunamu uma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pigoya, Pitaba komari umima kabera aiwakarusogana, kayokaya araga ka, agewapa Arota, aeba: Kebaya aiwakarusiye, ute tumima, ");
INSERT INTO for_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Pita kamana'wata abite, kabe kampa aiginta uwa a'mu purite, nama nkantabaipinti ima: Pita kanama kabera ampintiye, uma uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Uwaimogini, igeba abite maya untawe: We, kaeba aibo kamana yene, yuguna, aeba a'no pako puma esegima untiye: Me, ae asima mintiye, untiye. Piya yogini igeba: Pipa amankapa pemintanaga yene, untawe. ");
INSERT INTO for_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pigoya, Pita aeba to kake aiwakarusuma miyogini, kabe ai'ma aewa nkagamagini pami puntawe. ");
INSERT INTO for_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Piya puguna Pitaba aya tugupa pumagina: Kamanapa pakama miyiyoma, uwaimintana, Wa'egawama iga'na namapisa iyoba atama ababunti, pi nkawaga kamanapa uwaimimagina, to ka maya untiye: Tigeba ma kamanapa Yemisipe to ka'isa taokinape uwaimiyo, untiye. Piya ute, aeba tori iro'ma wagaintiye. ");
INSERT INTO for_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Piya marogini, irebu kina igeba Pitaka aisakate: Nana puwaye, ute, iyekuru puma pami puntawe. ");
INSERT INTO for_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Piya puguna, Erotiba Pitaka aguyosakategina iga'na namapi kampa aganta, irebu kina uwaitaogini, aseka kabima mintume kinapa iyeguntawe. Piya pugaite, Eroti aeba Yutiya maba kaite Sisariya kumati tumima mintantiye. ");
INSERT INTO for_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Pigoya, pi kanabi, Taya Saironi kumatasa kinapa Eroti tabera ka ibirantiye. Piya, pi kuma ago kina igeba irosa'waema: Paru puratanema, wasana wa'ega yagarama kiya yagarawa, ka agewapa Parasitasi, ae omuguna, antawamaba aogi pogana, kana wasana wa'ega yagaramati wama kamana'waipa omintiye. Piya, igeba ka'isaenawai ankima ankimayena kampa puma mintantasinta, kamparagaenabi mpintantasine. Piya, ankami ankamiyenawaipa tisa'waogini, pi to kake kabo puma airokaekena irosantawe. ");
INSERT INTO for_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Pigoya, Eroti aeba kamana a'wae puma uwaimikena kana iminti, pi ntaga aboraogana, wasana wa'ega awa'ena pu u'ma, kamana ukena yabaera ima mima, pi kina'mi aki puma mintuguna kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Uwaimogini a'ya'ma kina'miba aomana suma maya untawe: Kamana pipa wasanama kamanapa kampaye. Pipa Koti kausu kamana yene, untawe. ");
INSERT INTO for_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pigoya, Erotiba pi kamanaka abima aogi puntana, Koti nkageba kampa maema asaga'yuyogana, Wa'egawama enisorewa otaogana aeguyogana, aupinti kimparaogana pu'wantiye. ");
INSERT INTO for_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Piya, pabi ntaga Wa'egawama mpono'amaba anosama abae purite wagana puntiye. ");
INSERT INTO for_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Pigoya, Panabasibe Sorobe isigeba Yerusaremi kumata pi uwaisitantasa puma pugaite, pabe nkawameta Antiyoki kumati a'wae puma wakenaba, Yoni Maka ababusuguni kaga wantawe. ");
INSERT INTO for_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Pigoya, Antiyoki kumata monota aruyenabi poropetebe tisabe mintantawe. Piyama: Panabasiwa, Simiyoni aeba to ka ominta nkagiwapa Tunu Ntagarawa, Arusiyasi aeba Sairini kumatasawa, Maneyeni aeba wasana wa'ega yagara Eroti aege kaga agayagaya puma mima anosantina, Sorowa, sumagini aruyenabi mintantawe. ");
INSERT INTO for_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Pigoya, ka yagaba Wa'egawama nkagisuma nakenaba a'a-o uma aki puma mintuguna, Aota Awamusa'ama kamana maya untiye: Panabasike Soroke yoga uwaisitantopa, pi pikibemeka maema aseyo puwaisitaiyo, untiye. ");
INSERT INTO for_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Piya yogini, pika nanintaba a'a-o uma nunamu uma mima, iyapa isi'nota atama akayona puwaisitama, mono yugara uwaisitaugunisi wantase. ");
INSERT INTO for_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Pigoya, Aota Awamusa'ama piyama uwaisitaoginisi, isigeba wama Serusiya kumata tumpa irosa'ma, wanipisa karebi ima wama Saiparasi uma irosantase. ");
INSERT INTO for_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Pigoya, pi mpari irosa'ma, Saramisi kumati uma pita'i Yuta kina'mi ige mono namapi ima Koti kamana uwaimintase. Yoni Maka aeba isigege kaga wama isiyo'maentiye. ");
INSERT INTO for_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pigoya, a'ya'ma pi mpari nasima, Peposi kumata uma irosantawe. Pita'i uma irosa'ma, Yuta yagara, ka kiyo'ena pikena yagara, kampari poropete mintanti, agewapa Pa-isu, ae uma abatantawe. ");
INSERT INTO for_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Pi ntagara aeba kiya ka, agewapa Sesiyasi Porasi, ae ao'yagara mintantiye. Pi kiya yagara aeba aogi napi napiyena wantaga yagara, aeba Koti kamana abikenaga abogana, Panabasike Soroke isigega'e yoginisi kanantase. ");
INSERT INTO for_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kanausuguna, pi kana kiyo'ena pome ntagara, Kariki kamanapipa agewapa Erimasi, aeba kiya yagarapa Isu mpono a'a-o otama akunkisitantiye. ");
INSERT INTO for_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Pigoya, pi ntaga Sorokaba, aoso agiba Poro, aepa Aota Awamusa'ama antabi pumaemagina aseyo pogana, Erimasi aragamagina maya omintiye: ");
INSERT INTO for_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Kaeba kewama ntagarawe. Kaeba arupuyenama kama potane. A'ya'ma kumpari'ena kamparagaenagampaba kagupipa pumaentiye. Kaeba Wa'egawama nkaogi ki maema a'yugu puma, ataena pumagina akunene. ");
INSERT INTO for_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Pika Wa'egawama nkesegiyenawampa nkagowapa agao. Kaeba kao karu karumpa'wakana, ka'isa yagaba arapa kampa agama mikibene, untiye. Piya yogana, pabigo ibinankama ata potaogana, aoba tikaeyogana aya nkurupa nkurupa pogini, ayata urikena puntawe. ");
INSERT INTO for_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Pintana aboraogana, kiya yagaraba Wa'egawama nkesegiyenawata agategina, monokaba pami puma abogana, aogi pogana aogima abibebe puntiye. ");
INSERT INTO for_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pigoya, Porobe aokinape igeba Peposi kumapa atate, wanipisa karebi ima to kake wama, Pampiriya mari Pega kumata uma irosantawe. Pitasa Yoni Maka aeba itate Yerusaremi kumati a'wae puma kanatiye. ");
INSERT INTO for_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Pigoya, igeba Pega kumatasaba wama, Pisiriya mari Antiyoki to auka pita uma irosantawe. Pita uma irosa'ma, Yuta kina'mi sabatiba kaga mono namankaipi ima mintantawe. ");
INSERT INTO for_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Pigoya, pi monota tabe kina igeba Mosese kamanake, poropete kina'mi kamana awa'enake, ka'isa aisuma a'ya atate, mayama uwaimintawe: Tao'mitaba, mono kamana ka napintiripa yigi abeno, untawe. ");
INSERT INTO for_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Piya yuguna, Poroba asima aya nkasa puma paru puwaitama, maya uwaimintiye: Isureyo nao'mitabe Kotika karu pe kinape, kamana urimekiri abiyo. ");
INSERT INTO for_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Isureyo kina taete Koti, aeba tayabamagi ibabuma kibi itama, Isipi mari mimagini tabe kina aborantawe. Piya puguna esegiyenawatasa pita'isa ibabute kanama, ");
INSERT INTO for_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ka'me mpari nanintaba imima iyo'maema miyogana, kaboba 40 puntiye. ");
INSERT INTO for_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Pigoya, Kenani mariba tonaentisa tara umaema kina igarubakasima yogini, tayabamagiba igeba pi mpaba pakobuma, iyota iyota puma maema mintantawe. Piya puguna, kaboba 450 a'ya puntiye. ");
INSERT INTO for_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Pigoya, Kenani mari mintuguna kiya aborawaimogini mirite wauguna, poropete Samuweri aborantiye. ");
INSERT INTO for_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Pigoya Samuweri mintogini, wasana wa'egawaika yuguna, Kotiba Penisameni nkaga'nubara igetisa Kisi ntagara Soro asitaogana, kaboba 40 kabiwaitama mintantiye. ");
INSERT INTO for_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Pigoya, aeba atate, Tebiti wasana wa'egawai asitantiye. Pigoya, aeka maya kamana uwaimintiye: Naeba Yesi ntagara Tebiti agama, aeka naumawamaba aogi pegi, aeka yekana nae yuga a'ya'ma wasikena yagarane mikiye, Koti piya untiye. ");
INSERT INTO for_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Pigoya, Tebiti nkaga'nubara igetisa Isureyo kina tae aogi tau'ikena yagara ka aborakibi, awaga kamana unti, pi'na au'wantaga'ena penema, Koti yogana, Isu aborantiye. ");
INSERT INTO for_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Pigoya, wasana abakapi aboranema, maru Yoniba a'ya'ma Isureyo kina'mi igu a'wae piyemagina, mono wanipa pai'itakena kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Pigoya, aeba ke otanta a'ya wakena puntipa, pita aeta wama wasana maya uwaimintiye: Aewa uma unatapa, pi ntagaraba aeba naeba kampaye. Aeba ainti kanakiye. Naeba uwa yagara kanaoka, agisa anapa akubotakena ayabaya pukuwe. Aeba Wa'ega yagarawe, Yoni piya untiyemagina, Poro uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Piya untana, to maya untiye: We, naokina'ne, Abara'amu nkaga'nu, tigebe to ka'isa Koti karu pota kina, yekiri abiyo: Tau'ikenaga aogi kamana pi taeti otantiye. ");
INSERT INTO for_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yerusaremi kina, ima minta tumima minta kina'miba Isupa kayoneba kampa potantawe. Piya kampa puguna, poropete kina'mi meto kamana a'ya'ma sabatirapa aisuma abompe, pipa esegi puntiye. Piya, aeka ata kamana otama uma a'ya atantawe. ");
INSERT INTO for_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Igeba Isu kaintanawakaba aguyosakate, Pairatika uwa yuguna aeguntiye. ");
INSERT INTO for_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pigoya, mono kamanapi umaranta, pabi nkawameta puma, mariporasa iyoba'ma aru kabi kaitantawe. ");
INSERT INTO for_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Piya puguna, Kotiba purintapisa asitantiye. ");
INSERT INTO for_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Aibogini, aege Karariya marisaba Yerusaremi kumati kaga kananta kinapa uwoma ntaga aborawaimintiye. Aborawaimogini, aganta kina igeba pi nkawaga kamana'wa uwaimikena kina'ena puma, mampa mintawe. ");
INSERT INTO for_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Pigoya, Koti tayabamagi pi utawaitanta, pipa Kotiba Isu asitaogana, iyabamagi taeti au'wa aboranti, pika tintawama asoya kamana urimuse. Pika mono ini Samu tara, Koti umaranti kamana mayama kaemarantiye: Yagaranekawe. Kaepa iba aboragatauwe, yogana, kaemarantiye. ");
INSERT INTO for_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Pigoya, Isu purintapisa asitantikana, aeba aintiba to kake pu'ma abararakenaenaba kampa maema aborakiye. Pika Kotiba kamana maya untiye: Naeba Tebiti aogiyenaba utatantokana, pi'na au'wapa waiyaba waiyaba'ena timukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Pika mono ini Samubi to ka mayama waintiye: Kaeba aota yagaragapa naepa a-ntataga abararano, piyama kaentiye. ");
INSERT INTO for_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Pigoya, Tebiti aekaba kampa kaentiye. Ae agowapa abintune. Aeba Koti yoga kamana otanti, pipa aokina igeti puma a'ya atate purintiye. Purogini, ayabamagi ige kabi kaitauguna, au'ariwapa abararantiye. ");
INSERT INTO for_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Pigoya, Koti asitanti ntagara, aeba kampa abararantiye. ");
INSERT INTO for_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Pigoya, naokina, naeba urimekiri abiyo. Aguntaenaripa Isu ka'waina maema asu'a purigaikenaga yune. ");
INSERT INTO for_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Mosese kamana ago kamana'amaba kaintanaripa asu'a purigaikenaba pugagate atantiye. Pika Isuti uma airokaeyiginaba, kanara maema a'ya'waemaenaripa asu'a purigaikiye. ");
INSERT INTO for_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Poropete ka'waina kamana unti, pi'na tigeti esegi pusanaga a'wae piyoma, tige'ma kamana urimuwe. Kamana mayamawe: ");
INSERT INTO for_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","We, mono'ama akaya se kina, tigeba agabebe puma uwoma tigi napiyigina ataena puritakiye, iye. Naeba tige kanabipa, ka aota yuga pukuwe, iye. Pigoya, ka yagarama pi ntuga kamana urimekiripa, pipa tigeba kampa aogima abima wasikibewemagina, poropete yagarama kaemarantiyema, Poro piya untiye. ");
INSERT INTO for_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Pigoya, Poroge Panabasige isigeba mono namapisa irosa'ma tumusuguni, wasanamiba to ka sabatira pabi kamana uwaimikibemeka untawe. ");
INSERT INTO for_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Pigoya aruyenabisa tumima, uwoma Yuta kinape to marisa kina Yuta kina iyegaranta ka'isa pi mpono kinape, Poroke Panabasike isiyegarauginisi, Koti awagaenabi pasema mikibeka, ige'ma esegima tabe kamana uwaimintase. ");
INSERT INTO for_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Pigoya to sabati aboraoginiba, pi kumatasa kina igeba Koti kamana abikenaba, a'ya'ma tabera irosantawe. ");
INSERT INTO for_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Irosauguni, Yuta kina'miba igate abima, igobipa tabera puwaisitama, Poro kamana akayuma karana potantawe. ");
INSERT INTO for_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Piya pugunisi, Poroge Panabasige isigeba esegi kamanapisa maya uwaimintase: Yuta kina, tigeba Koti kamana maru uwaimiyoma untapa, ma tigeri a'a-o uma miyaba'enamakaba kampa tabiyema, yegana, agoripa aboraika titate to marisa kina'miti wama pi aogi kamana igepa uwaimukuse. ");
INSERT INTO for_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Piya, Wa'ega aeba pika napima maya uramintiye: Naeba tigepa namu'isa kina'mi e'wasaena amikena uritantoka, i'ikena kamana mirite wama, ma tuti uma mima a'ya piyo, Wa'egawama untiye, isigeba piya untase. ");
INSERT INTO for_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Piya yusuguni, pi to marisa kina igeba abuguna intawamaba asoya pogini, Wa'egawama kamana'wapa aseyo puma i'muntanabisa abima maentawe. Pigoya, igeba miyaba'ena utawaitanta, pabi nkawameta igeba pi kamanapa wasintawe. ");
INSERT INTO for_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Aibuguna, kana marapa Wa'egawama kamana'amaba abae puma anosaurite wagana puntiye. ");
INSERT INTO for_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pi kumatasa kiya kina'mige ka'isa mono abume tabe waya'iyabe, igepa Yuta kina'mi kumpari kamana uma imo atikeba'magini, iyo'maema Poroke Panabasike ma'ena puwaisitama, nama kuma'waipa akunkisigasima isigarubaugunisi wantase. ");
INSERT INTO for_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Wantinisi, isigisarisa i'nipa aiwaka pusuguna tumoginisi: Aguntaenaripa wairitano, otate, Aikoniyamu kumati wantase. ");
INSERT INTO for_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Wausuguna, a'ya'ma Isuti atokaenta kina ige igupipa i'muntana Aota Awamusa pumaerite wagana puntiye. ");
INSERT INTO for_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pigoya, Poroge Panabasige isigeba Aikoniyamu kumata uma irosa'ma, pabiyama Yuta kina'mi mpono namapi ima mono yusuguna, au'wa aborantiye. Piya pogini, Yuta kinape Kariki kinape uwoma kina'mi Isu aegarantawe. ");
INSERT INTO for_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Aibuguni, Yuta kina ka'isa igeba pi mpono kamana a'a-o uma, pabi namu'isa kina imo atikebauguni, aposoro igobi puwaisitantawe. ");
INSERT INTO for_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Pigoya, isigeba uwoma ntaga pabi kumata mima, Wa'egawama mponowapa karu kampa punta uwaimima mintantase. Piya pusuguna, Wa'egawama kayone kamana'wapa aborawaisimima, esegiyena isimoginisi awame'enabe kasa'enabe toma toma puntase. ");
INSERT INTO for_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Pigoya, kana pi kumatasa kina'miba pakobuma, ka'isa Yuta kina'miti uma atokaeyuguni, ka'isa kina'miba aposoro yagara tara isigeti uma airokaentawe. ");
INSERT INTO for_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Pigoya, ainti ka'isa namu'isa kinape, Yuta kinape, kiya kina'wai igeba aposoro ata puwaisitama, yaba kasutasa isiyegukena pugunisi, ");
INSERT INTO for_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","abite isiyegaka pai'ma, Arikiyoniya mari wantase. Pigoya, pita'i Arisitera, Tebi, kuma tara waintusumetibe, to ka'isa isigorasa kumatibe, ");
INSERT INTO for_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","wama pita'i aogi kamana uwaimima mintantase. ");
INSERT INTO for_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Pigoya, Arisitera kumata agisa taraba pu'wanta yagara ka mintantiye. Aeba ano nkantabaipintisa pabiya yagara aboranta, ke nasi nasipa kampa puma uwa awaitami puntiye. ");
INSERT INTO for_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Pigoya, Poroba mono yogana abima mintogana, aeti agabebe puma, agowa mayama abintiye: Ma ntagara aeba aogi pikena amatiti'ena waintiyema, napintiye. ");
INSERT INTO for_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Piyama napimagina, obina kamanapisa maya omintiye: Kaeba kagisagapa aema asima turu puma miyo, omintiye. Piya yogana, kana yagara aeba pabigo asima nasi nasi puntiye. ");
INSERT INTO for_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Pigoya, a'ya'ma uwoma kina'miba Poro pomentana agate, kega'e uma Arikiyoniya kamana'waipisa maya untawe: Amani kina isigeba wasana i maerite, abakatepi aboranta mintase, untawe. ");
INSERT INTO for_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Piya untini, Panabasikaba aeba amani ka, agewapa Susi, ae aukantana puntawe. Piya, Poro aeba tabe kamana'yaga yagaragini, Emisiwe untawe. ");
INSERT INTO for_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pigoya, Susi ae mono namapa kana kuma'ama nkawamori waintantiye. Piya, pi mpono nama kiye yagara aeba yogini, pi kumatasa kina'mi nki'muntana isimimagini purumaka kaema muta isitama, agunta pasaisitakena puma, kana aposoro yagara tara puntawe. ");
INSERT INTO for_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Aibugunisi, Panabasibe Porobe isigeba pi abite, tabera pami puma isitasaenaba atutu puntinisi, wasana ipasara puta wama maya untase: ");
INSERT INTO for_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","We, ma kina, tigeba nana pewe. Tasigeba tige miyesa puma wasanawe. Tigeba kumpari monopa tikabitate, miyaba Koti aeti uma airokaekibeka, aogi kamana'wapa urimuse. Ae mantabe mabe wanipe a'ya'ma tonaronaba maema aborawaetantiye. ");
INSERT INTO for_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Pigoya, ago mirite kananta, pi kanabi namu'isa kina abiwaimogini, igu'ama miyaba kipa toma toma aborama mintantawe. ");
INSERT INTO for_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Pigoya, a'yuguba kampa puritaikana, agowa abiyema, agu kao'ena puritamagina, yegina kabe pape ka awameta aemagina, a'ya'ma nanintaba aboragiri, nama ti'mu puma miyewe, piya untase. ");
INSERT INTO for_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pigoya, aposoro isigeba e'ero ntaga esegi kamana piya uma, paru puwaitama aka'yuwaitausuguni, taena puma muta isitakena pumepa uwe atantawe. ");
INSERT INTO for_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Pigoya, pita'i mintusuguni, Yuta kina'mi Antiyoki kumatisabe Aikoniyamu kumatisabe irosa'magini, wasana imo atikebauguni, iyo'maema Poro yaba kasutasa aeguntawe. Aegumagini: Ago puriye, umagini kuma nkawamori paibumaete wantawe. ");
INSERT INTO for_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Piya puguna, pita'i waintogini, Isuti atokaenta kina irosa'ma, aeti uma karare puma agauguna, aogama asima kumati intiye. Pigoya maroganaba, Panabasige Tebi kumati wantase. ");
INSERT INTO for_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Wama pita'i aogi mono kamana yusuguni, wasanaba uwoma kina'mi abibebe pugunisi, Isu tu ibabuntase. Piya pumaginisi, to kake a'wae puma wama, Arisitera, Aikoniyamu, Antiyoki kumati ampa irosa irosa puta puta kanantase. ");
INSERT INTO for_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","A'ya'ma kumati irosa'ma kamana uwaimusuguni, Isuti atokaenta kina igeba abite esegima imatiti pugunisi, ige'ma Wa'egawama atokaema mikibeka kamana uwaimima maya untase: Taeba ataena puratama, tauki nakiyenama abobori mima, Koti kabiratakena kumati ikena ki uma aogi puratantine, untase. ");
INSERT INTO for_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Pigoya, a'ya'ma kumati monota ai'aru pume kina'mibisa kiya kina'wai ibabuma uwaitama aboramaginisi, naninta a'a-o uma mima nunamu uma akayona puwaitama, imatiti punta mono yugaga Wa'egawamati itantase. ");
INSERT INTO for_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Aibumaginisi, Pisiriya maba agaite wama, Pampiriya mara uma irosantase. ");
INSERT INTO for_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pita'i uma irosa'ma, Pega kumata mono uwaimite, Ateriya kumati tumintase. ");
INSERT INTO for_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Pita'i tumima, wanipisa karebi ima wama, to Antiyoki kumata uma irosantase. Pi kumatasa monota a'aru pume kina igeba Wa'egawama nkawagaenabi isitama, yoga uwaisitaugunisi agobima purite wantase. ");
INSERT INTO for_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Pabigo kanama irosa'ma, monota ai'aru pume kina igega'e uma aki puwaitama, Koti esegi puwaisitaoginisi yoga pusuguna, to marisa kina'mi mono'ama agupi uma pasinta, pi kamana uwaimiwaentase. ");
INSERT INTO for_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pigoya, isigeba pi kumata Isuti atokaenta kina ige abakapi uwoma ntagaba mintantase. ");
INSERT INTO for_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pigoya, Yuta marisa kina ka'isa Antiyoki kumati tumima, Isu mpono abinta kina maya uwaimintawe: Tigeba Mosese kamana uma tipa kampa kasaiginaba, Wa'egawamaba kanara kampa tibabikiye, untawe. ");
INSERT INTO for_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Piya yugunisi, Poroge Panabasige ka ibi'ma, tabera maka yusuguni, pi kumatasa mono kina'mi maya untawe: Porobe Panabasibe to ka'isa kina, tigeba aposorobe monota kabiyume kinape Yerusaremi kumati minta, igeti pi kamana maete wakibewe, piya uma uwaitantawe. ");
INSERT INTO for_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Pi kumatasa monota ai'aru pume kina'mi piya uma uwaitauguni wantini, wama Pinisiya, Sameriya ma againtiniba, pita'i Isu mpono abinta kinapa maya uwaimita wantawe: To marisa uwoma kina'mi mono abewe, uwaimuguni, abima tabera i'muntanaba igetiba aborantiye. ");
INSERT INTO for_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Aibogini, wama Yerusaremi kumata uma irosauguni, monota ai'aru pume kinape aposorobe monota kabiyume kinape, igepa ibabuma aogi puwaitauguni, igeba Wa'ega esegi puma iyo'maeyogini, to marisa kina'miti mono yuga puguna au'wa aboranti, pi nkawaga kamana uwaimintawe. ");
INSERT INTO for_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pi kamana uma a'ya puguni, ka'isa Isu nkaegaranta Parasi kina maya untawe: To marisa kina'miba mono abikena puntiniba, itapa a'aitama, Mosese kamana agoba wasiwaeyiginaba kanarasakiye, untawe. ");
INSERT INTO for_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Piya yuguni aposorobe monota kabiyume kinape pi kamana umagina, aogi pukena to aki puntawe. ");
INSERT INTO for_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Aki pumagini, uwoma kamana yuguna, Pita asima maya uwaimintiye: Nao'mitaba, to marisa kina'miti nasima aogi kamana uwaimikenaenaba, pipa Kotiba tige aruyenabisa nae naba punatantegi, pai agobima uwaimuwagini abima Isu nkaegarantawe. Pipa ago abintawe. ");
INSERT INTO for_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Pigoya, Koti aeba tagu'ama agabebe puma Yuta kina tae Aota Awamusa taminti, pabiyama to marisa kina imima agoba tayakiye. ");
INSERT INTO for_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Igeba aeka napima imatiti piginaba, igu'amaba wae'wae pekana, tae puratantisa puma, pabi nkawameta igepa puwaitantiye. ");
INSERT INTO for_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Pika tigeba nanaga Kotipa agasima, tigeba kuntuyenaba asaema, to marisa Isu nkaegaranta kina'mi ibotapa itakenagaba yewe. Pi kuntuyenaba taebe tayabamabe kampa abaebune. Pipa kampaye. ");
INSERT INTO for_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Taeba mayama abune: Aogi pikenaenaba pipa Yuta kina taebe, to marisa kinape, kaga Wa'ega Isu tau'ikena yagara, ae awagaenawaka uma aogi pune, Pita piya untiye. ");
INSERT INTO for_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pitaba kamana piya uwaimogini, a'ya'ma aki punta kina uwa pasema mintantawe. Mintuguna, Porobe Panabasibe isigeba Koti to marisa kina'miti awame'enabe kasa'enabe isiyakoginisi puntame, pi kamana uwaimintase. ");
INSERT INTO for_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Pigoya, uwaimima a'ya atausuguna, Yemisiba kamana maya uwaimintiye: Nao'mitaba, kamana yekiri abiyo: ");
INSERT INTO for_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Koti aeba to marisa ige aruyenabisa wasana ibabekini, aewa mpono abikena kina'ena pikena ki to mari aboranti, pi kamana Saimoni yegi abune. ");
INSERT INTO for_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Pigoya, ae kamana'amaba kamana ago kamanapi uma paibuntiye. Poropete ka'waina Wa'egawama yome kamana mayama kaentiye: ");
INSERT INTO for_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Naeba a'wae puma, Tebiti ae nama abararami, pi aoga aogasosima aogi pukuwe, iye. ");
INSERT INTO for_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Piya pekini, wasana igeba Wa'ega naeka kega'e uma naguyosa'magini nabatakibewe, iye. Pigoya, to marisa kina igeba nage nawaga kamana ukena kina'nentana pikibewe, iye. ");
INSERT INTO for_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Wa'ega naeba kamana piyama uma aboraurite ima mintanto'nana, pipa yuwe, poropete yagara piyama kaentiyema, Yemisi untiye. ");
INSERT INTO for_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Pigoya, Yemisiba poropete kamana napima mayama amato puma uwaimintiye: Taeba to marisa kina Kotiti a'wae puma igu ame kina'mipa, kuntuyenaba kampa imenema yuwe. ");
INSERT INTO for_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Igeka kampari kotintana a-mpaemagini, ankagaba ankagabaenaba a'a-o umagini, kobama kampa ima maema pu'wami kinape korape a'a-o umagini, a-ntaiyema esegi puma, pi kamana'anto esa kaema imukunema, uwaimintana, ");
INSERT INTO for_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","to ka maya untiye: Mosese kamana pi iyabamagibe iga'nugibe paitaka'ya agobima, a'ya'ma kumaka kumaka aisurite kanama mintantane. Piya, ibaba pabiyama a'ya'ma sabatirapa mono namapipa aisuma, a'ya'ma kina'miba abewe. Pika pi a'yugu pusanaga tagu'amaba tara taraba a-peno, Yemisi piya untiye. ");
INSERT INTO for_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Pigoya, uwaimogini aposorobe monota kabiyume kinape a'ya'ma pi monota ai'aru pume kinape, abuguna aogi puma asoya pogini, igetisa tara yagara uwaisitaugunisi, Poroke Panabasike isibabuntase. Ka yagarama, agewapa Yutasi, to ka agiwapa Pasabasiwa, Sairasiwa sumaginisi, monota paitakena yagara tara isibagi puma, kaga Antiyoki kumati waiyema, uwaitantawe. ");
INSERT INTO for_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Piya puntini, esa ka maya uma kaema imuguni maete wantawe: Aposorobe monota kabiyompe kinape, taeba taokina to marisa Antiyoki kumatasabe, Siriya marasabe, Sirisiya mari minta kinape, tige ta'mu puritama, ma nkisapa ataritaune. ");
INSERT INTO for_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Taeba kampa abintokini, mata'isa ka'isa kina'mi tigeti ima kamana urimima, tigu'ama a'yugu purigasuguri, tigeti atatara kamana aborantiye. ");
INSERT INTO for_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Pigoya, taeba pi abite aki puma, taetisa tara uwaisitaokinisi, tabugai ntagara tara, Panabasike Poroke, isibagi puma iyewe. ");
INSERT INTO for_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pi ntagara tara, Wa'ega Isu Karaisiti aeka uma isi'waisipa kaintase. ");
INSERT INTO for_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Pigoya, pi wasana isibabumaraumpe, Yutasige Sairasige isigeba ima isiwamupisa kamana urimisigiri, abiyo. ");
INSERT INTO for_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Aota Awamusa taeti waintegi, taeba maya kamana yune: Taeba to ka'isa kuntuyenaba kampa tige tikabapipa atakune. Pintanamana piyo: ");
INSERT INTO for_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Tigeba kampari kotintana amikenaenabe, yaga korape, kobama kampa imu maema pu'wami kinape, pi ntanintaga a-ntaiyoma ankagaba ankagabaenaba a'a-o uma kaitegiri, aogima miyiyo. Pintana tikabitakibepa, aogima mikibewema, esapa kaema imintawe. ");
INSERT INTO for_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Pigoya, pi nkisa isimima isigarubauguni, igeba pi nkisa maete tumima, Antiyoki kumata uma irosa'ma, monota ai'aru pume kina igega'e uma aki puwaitama, kana esapa imintawe. ");
INSERT INTO for_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Imuguni aisuma abite, paru kamana kaema imume, pika intawamaba asoya puntiye. ");
INSERT INTO for_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Pigoya, Yutasige Sairasige isigeba poropete puntase. Piya pumaginisi, uwoma aogi kamana Isu mpono abinta kinapa uwaimima esegi puwaitantase. ");
INSERT INTO for_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Pigoya, igege miyusume kanaba a'ya pogini, pi isiyokina'miba intawama paruyenabisa isitaugunisi, uwaisitaugunisi, wausume kina igeti a'wae puma kanantase. ");
INSERT INTO for_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","(Sairasiba aewa aumawampa aega'ma, Antiyoki kumata umintantiye.) ");
INSERT INTO for_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Aibusugunisi, Poroge Panabasige isigeba Antiyoki kumata to kake amato puma mima, Isu nkaegaranta ige iyo'maema, mono uma Wa'egawama kamana wasana uwaimima iyakintase. ");
INSERT INTO for_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Pigoya, aintiba Poroba Panabasi maya omintiye: Tasigeba mono kayokaya'enara wama yuwagini, a'ya'ma kumatisa tasiyokina aboranta, igeba ayamabaya miyewe. Pika wama abukuse, untiye. ");
INSERT INTO for_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Piya ute, Panabasiba Yoni Maka aege kaga wakenaga untiye. ");
INSERT INTO for_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Pigoya, Maka aeba paipa isigege wama Pampiriya mari kasa yugari uma irosa'ma, isitate a'wae puma kanantika, Poro aeba piya yagaraga aboganaba kampa aogi puntiye. ");
INSERT INTO for_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Piya pumaginisi, isimawamaba tabera tara tara puma pako puntase. Pako puma, Panabasiba Maka ababoginisi wama wanipisa karebi ima, Saiparasi mari wantase. ");
INSERT INTO for_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pigoya, Poro aeba ao'maeyanta kina'wapa Sairasi ababogini, pi Isu mpono abinta kina'miba: Waisiginaba, Wa'egawama kabirisitakiye, uma uwaisitaugunisi wantase. ");
INSERT INTO for_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Wamaginisi, Siriya mabe Sirisiya mabe againtinisiba, monota ai'aru pume kina iyo'maema esegi puwaitata wantase. ");
INSERT INTO for_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pigoya, Poroba Sairasi ababute wama, Tebi kumati wamaginisi, Arisitera kumata uma irosantase. Pigoya, Arisitera kuma pitapa Isuti atokaenta yagara ka uma abatantase. Agewapa Timoti, aeba anowampaba Isu nkaegaranta Yuta wae, piya abawampa Kariki yagarawe. ");
INSERT INTO for_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Piya, Arisitera'isa kinape, Aikoniyamu kumatisa kinape, pi Isu nkaegaranta kina igeba Timoti ae agoba aseyo puma, Poro omintawe. ");
INSERT INTO for_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Omuguna, Poro aeba aekaba abogana, aege kaga wanema, omintiye. Pigoya, pi mpariba Yuta kina mirite wanta, igeba kana yagarama nkabawampaba Kariki yagarakini abiwaentaka, pika Poroba igeka napima, kana yagarama nkau kasama, Wa'egawamatisa ara'enaba potantiye. ");
INSERT INTO for_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Pigoya, kumaka kumaka nasi nasi puma, aposorobe monota kabiyume kina'mibe, Yerusaremi kumata tonkiya kamana uma atantapa, monota ai'aru pume kina wasiyoma, uwaimite wantase. ");
INSERT INTO for_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Piyama yoga puguna, monota ai'aru pume kina'mi imatiti'enaba aborama esegi pigini, a'ya'ma yagaba to ka'isa kina abima igege atokaentawe. ");
INSERT INTO for_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pigoya, Pirisiya mabe Karesiya mabe agaite, Esiya manto abeti wama mono kamana ukena yuguna, Aota Awamusa'ama pi ki'i a-nkwaiyoma, akunkaitantiye. ");
INSERT INTO for_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Aibogini, wama Misiya ma awamori uma irosa'ma, ka auka'i aigigi pa'ma, Pitiniya mari wakena yuguna, Isu Nkawamusa'amaba pabiyama kampa owe uwaitantiye. ");
INSERT INTO for_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Piya pogini, Misiya maba agaite wama, kayo wani nkawamori Torowasi kumata uma irosantawe. ");
INSERT INTO for_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Pita'i uma irosa'ma, Poro aseka amonta mayaena agantiye: Masetoniya yagara ka'waina aeti aborama mima, agisuma maya omintiye: Kaeba Masetoniya mari ima tao'maeyo, omintiye. ");
INSERT INTO for_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pigoya, Poro pintana agaogapa, aege aokina'mitabe maya untune: Koti aeba: Masetoniya mari wama aogi mono kamana uwaimiyoma uramiye, untune. Piya ute, pabigo wakena aseyo puntune. ");
INSERT INTO for_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Pigoya, aseyo puma wanipisa karebi ima, Torowasi kumapa atate agasi agasima wama, Samotaresi uma irosantune. Pigoya marogapa, pitasa wama Niyaporisi kumata uma irosantune. ");
INSERT INTO for_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Pigoya, pitasa wanipisa karebisa tumima, wama Piripai kumata uma irosantune. Pipa Masetoniya mari tabe kuma ka, Aroma kina'mi kuma agona puma mintantawe. Pi kumata ka'isa yagaba mintuwakana, ");
INSERT INTO for_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","sabati aboraoga maya umagi, pi kuma nkagora waniti tumintune: Kuma nkawamori waniti tumima, Yuta kina'mi nunamu ye kuma ka waintika, tumpa agakune, untune. Piya ute, tumima waya aki puma mintugu, tumpa ibatama, mara'mima kamana uwaimintune. ");
INSERT INTO for_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Pigoya, ige aruyenabisa to marisa wae ka'waina, aeba Kotitisa aogi kamana abima mintantiye. Agewapa Aritiya, ae yuga aogi tete kai pome wae, Tiyatira kumatasa, pi kana wae Wa'egawama agu aumawamaba aseyo pogana, Poro kamana yoganaba aogima abintiye. ");
INSERT INTO for_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Pigoya, aewape aokinape mono wani pasintini, maya uramintiye: Tigeba nagantaga Wa'ega ae tuntana poka, nae namapi kanama miyiyo, ute, tonkiya poga, awamu wasima intune. ");
INSERT INTO for_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Pigoya, maroga nunamu ukena kumati tumuwakana, kayokaya araga ka'waina tabatantiye. Kana araga aeba kegina wantaga mima, kakanta'enaba uma abora putamagina, aeba igetisa ikantana uwoma maemagina, kabitaome kina'mipa imibutaye. ");
INSERT INTO for_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Pi ae tabatama, Porope taepe taega'magina, kega'e maya untiye: Ma kinapa Koti ima minti tabe yagara, ae kayokaya kina mima, tau'ikena ki'amaka urimima tiyakiyewe, untiye. ");
INSERT INTO for_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Piya kega'e asi nasima uyaba'miyogana, Poro aeba pika aekita puma, kana kegina a'wae puma maya omintiye: Naeba Isu Karaisiti ae awamuta ugamekana, aragawae'ma nkantabisa irosa'ma wao, yogana, pabigo irosa'ma wagaintiye. ");
INSERT INTO for_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Aibogini, kana aragawae'ma kabitaome kina'miba mone kuta aborama, imomentana pabigo kampa to kake aboraogini agate, Poroke Sairasike ka isibi'ma, isibabute kuma akanti kiya kina'mi nkau'i isibabute wama, ");
INSERT INTO for_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","kiya yagaramiti uma kamana uwaisitama, maya untawe: Isigeba Yuta yagara taramisi, ma kumateti kanama ataena puratase. ");
INSERT INTO for_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Piya pumaginisi, awame'enaba kasa'ena pese. Aroma kina'mitaba a'yugu pompentana, a'yugu maema miyompentana, piya ampa aborase, untawe. ");
INSERT INTO for_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Pigoya, uwoma kina mintume kina'miba igobipa tabera puwaisitama isiyegukena puguna, kiya yagara aeba kaiwaisipa atisa puwaisigasima, yogini eru kasutasa isiyeguntawe. ");
INSERT INTO for_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Eru kasutasa tabera isiyegumugasima, iga'na namapi isibabuwaisitama, kiya yagara aepa: Kabeba esegima kigasima pasema kabiwaisitanema, omintawe. ");
INSERT INTO for_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Omuguna, iga'na namapa abakapisa marupi isitama, isigisaba ya atuta kirokae isitama, isitaoginisi waintase. ");
INSERT INTO for_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pigoya, aseka nkabubu Poroge Sairasige isigeba ini nunamu uma Koti isi'mu potantase. Piya pusuguni, iga'na namapisa ka'isa kina'miba isiwamusa aga abintawe. ");
INSERT INTO for_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Piya pusuguna, pabigo imimapa tabera pogana, kana iga'na namankamaba kurukuru pogana, a'ya'ma kabeba a'waiwaogana, a'ya'ma kina'mi nkigisa iyapisa iga'naba iyoba wantiye. ");
INSERT INTO for_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Piya pogana, iga'na nama kiye yagara aeba awaibintisa pami puma asima, kabeba a'waiwaentogana agama: Iga'na kina ago pai'ma wawaegasawe, ute, yoginka abamu kantabintisa a'yubuma, aewa au'wa aerisakena puntiye. ");
INSERT INTO for_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Piya pikena pogana, Poro tabera maya kega'e uma untiye: Kaukapa a-nkaguya aiyo. Taeba a'ya'ma uwa kanara mintune, untiye. ");
INSERT INTO for_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Piya yuguna, kana kiya yagara aeba ao'mika eka yogini, igi'ma amuguna, nama nkantabaipinti karu'ena wama aekuru puma, tabaraba purite ima, Poroke Sairasike isigisabi asu parokaentiye. ");
INSERT INTO for_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Aibuntana, nama nkantabaipintisa isibabute tumima isibigama maya untiye: Tabe yagara tarane, nau'ikenaga ayama aogi puma misuwema, isibigaoginisi, ");
INSERT INTO for_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","isigeba maya omintase: Wa'ega Isuka kamatiti puma aegarakibempepa aogi pugatakini, kao'miba pabiyamagini aogima mpikibewe, untase. ");
INSERT INTO for_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Piya ute, aepe aokinape Wa'egawama mpono kamana uwaimintase. ");
INSERT INTO for_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Uwaimusuguna, kana kiya yagara aeba pabi aseka isibabuma, eru kasutasa isiyegunta'enaba wani pai'ma aeyoba isigasimagina, yoginisi ae'wape aokinape mono wani pai'itantase. ");
INSERT INTO for_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Piya pusuguna, ae'wa ntamapi isibabuwaisitama yogini, kao'ena puma isimintawe. Pigoya aewape aokina'miba Koti ae tuntana pumeka, intawamaba aogi puntiye. ");
INSERT INTO for_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Pigoya maroginiba, kamana umarisakena kina'mi igeba irebu kinapa ka'isa uwaitauguni, wama iga'na namatasa kiye yagara maya omintawe: Kaeba tara yagarara uwaisitaginisi waiso, yuguna, ");
INSERT INTO for_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","pi kana kiya yagarama Poro maya omintiye: Naeka uwaisitaginisi waisoma, kiya yagarama kamana atagina kanaya, pika tisigeba kanara wama umiyiso, yogana, ");
INSERT INTO for_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Poro irebu kinapa maya uwaimintiye: Igeba agoresipa kampa abinta wasana aruyenabi tasiyeguma, tasu airisa purasitama, iga'na namapi tasibaburasitawe. Tasigeba Aroma yagara tara mintuse. Pabiyama tasigepa kampa kotiyena purasitanta, tasiyeguma uwa ataena purasitawe. Pigoya mapa nanaga waisomaba, kakamaba urasitawe. Pipa kampaye. Igewai kanama ampa tasibabigiraba wakuse, untiye. ");
INSERT INTO for_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Poro kamana piya yogana, irebu kina'mi a'wae puma wama, kiya yagarape to tabe kinape uwaimuguni igeba kana yagara tara isigeba Aroma aruyenabi aborantame, pi kamana abite iyekuru puntawe. ");
INSERT INTO for_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Iyekuru pumagini, kana yagara taramisiti kanama intara kamana uwaisitama, iga'na namapisa isibabute tumima, kuma'waipa atate waisema, uwaisimintawe. ");
INSERT INTO for_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Piya pugunisi, isigeba iga'na namapisa irosa'ma tumima, Aritiya ntamati wama, Isu mpono abume kinapa igama i'nana kamana uwaimite wantase. ");
INSERT INTO for_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pigoya, Poroge Sairasige isigeba Ampiporisi kumape Aporoniya kumape isigaite, Tesaronaika kumata uma irosantase. Pita'i Yuta kina'mi mpono nama ka waintantiye. ");
INSERT INTO for_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pigoya, Poro aeba pubomesa puma kakaga sabatirapa mono namankaipi ima, igege paisa mono isapisa kamana uma abintawe. ");
INSERT INTO for_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Piya puntana, mono kamana awa'ena ka'isa pi'na agowapa aborama uwaimintana, maya untiye: Koti nkutaratanta yagara auki naki pumagina, pu'wantitisa asikiyema, mono kamanapi untane. Pigoya, Isu age awaga kamana urimuwe. Aeba taga Karaisitiwe, untiye. ");
INSERT INTO for_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Pigoya, ka'isa kina'miba pi kamana abibebe pumagini, Poroke Sairasikeri uma atokaentawe. Pigoya, Kariki kina igeba Kotika iyekuru puma aegaraume kina'miba uwoma igeti uma amato puntawe. Pigoya, tabe kina'mi ige waya'iyabe a'ya'ma ka'isaba kaga abintawe. ");
INSERT INTO for_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Pigoya, wasana uwoma kina'mi mono abuguni, Yuta kina igeba abima intawamapa ikimagini, ka'isa kama kina uwaitauguni, igeba a'ya'ma wabe wayape imo kamana yuguni, pi kumatasa kina'mi agasiya puguni, isiguyosa'ma, Yasoni ntamapinti karu'ena ima Poroke Sairasike isiguyosantawe. Aibuntini, kana yagarara isibabuma wasana iyobi isitakena untawe. ");
INSERT INTO for_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Pigoya, isiguyosa'ma Yasonibe Isu mpono abinta kina ka'isabe ibabute, kuma kiye kina'miti ibabute wantawe. Piya puntini, maya uta wantawe: Maga maga kina igu'ama maema kamparaga puwaitata kanama taeke ata puratakena ampintawe. ");
INSERT INTO for_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Aibegana, Yasoniba ibabuma aogi puwaitaye. Piya, igeba wasana wa'ega yagararempa Sisa kamana'wa maema a'yugu potama, aogaso wa'ega Isu ae awaga kamana yegana, anosama abae piye, untawe. ");
INSERT INTO for_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Kamana piya umagini, kana kumatasa kinape kiya kinape imo atikebauguni, ");
INSERT INTO for_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","pi kiya kina igeba Yasonibe aokinape uwaitauguni, i ikantanaba mone imuguni, uwa itauguni wantawe. ");
INSERT INTO for_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pigoya, Isu mpono abinta kina'miba Poroke Sairasikeba aseka uwaisitaugunisi, Periya kumati wantase. Pita'i uma irosa'ma, Yuta kina'mi mpono namapi ima mono untase. ");
INSERT INTO for_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Pigoya, pi kumatasa Yuta kina igeba paru kinane. Tesaronaika kumatasa kina ige kanta kinapa kampaye. Pika monopa igu aseyo puma abintawe. Piya puntini, kamana'waisi nkagowa abibebe pikenaba asi nasima iyekita kampa punta, mono esapa aisuma abintawe. ");
INSERT INTO for_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pigoya, igetisa uwoma kina'mi Isu aegarantawe. Piya, Kariki kiye kina'mi nkwayape to ka'isa kinake igeti uma amato puntawe. ");
INSERT INTO for_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Pigoya, Poro mono uwaimogini abuguna, pi awaga kamana'ama Tesaronaika kumati waogini, pika Yuta kina'mi abintawe. Abite, Periya kumati kanama kuma ago kina'mi imo atikeba'ma, igu'ama maema a'yugu puwaigaintawe. ");
INSERT INTO for_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Piya puguni, Isu mpono abinta kina igeba Poro otauguna, pi kumapa atate wama kayo wanita uma irosantiye. Sairasige Timotigeba isigeba pabita mintantase. ");
INSERT INTO for_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Pigoya, Poropa wasanami igeba mabi ababute wama, Atenisi kumata metauguna maya uwaimintiye: Tigeba a'wae puma wama ima yiginisi, Sairasige Timotigeba karu'ena kanaiso, uwaisimiyo, yogini igeba wama uma uwaisitantawe. ");
INSERT INTO for_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Pigoya, Poroba Atenisi kumata isigeka isiwaga puma mintana, kumpari kotiba tabera wairite waogana, agama agu'amaba tabera yaku tantiye. ");
INSERT INTO for_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Pigoya Yuta kina'mi mpono namapi ima, Yuta kina igewaipe Kariki kina ka'isa Yuta kina iyega'ma mintanta kina igege kaga mono kamana uma abintawe. Pigoya, asi nasi kumati wasana ibatamaba, pabiyama mono uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Pigoya, pi kumatasa mono kina igewaipa Epikuriyani kinape Sitowiki kinape, pi kina'mi ige Poroge maka untawe. Aibuntini, ka'isa kina'miba Poroka: Ma kamana yagara aeba nana kamanapaya uramiye, untawe. Pigoya, to ka'isa kina'miba: Aeba aoso amani'ama awaga kamana uramiye, untawe. Pigoya, Poro aeba Isu awaga aogi kamanape purintapisa asikena pi kamanape yoginiba piya untawe. ");
INSERT INTO for_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Piya umagini, maba ka agewapa Ariyopagasi, pita'i ababute ima, maya untawe: Kaeba aoso kamana yempepa, pipa nanawe yene. ");
INSERT INTO for_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Pipa aoso kamana abune. Pika agowa yega abeno, untawe. ");
INSERT INTO for_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pigoya, a'ya'ma Atenisi kumatasa kinape to marisa a'yo ampintume kinape, igeba asi nasi kasa kamana abite, pabi kamana mare-u me-u puntawe. ");
INSERT INTO for_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pigoya, Poroba aeba Ariyopagasi kanisore kina'mi nkiyobi asima mima, wasana maya uwaimintiye: Atenisi kumatasa kina, naeba agoripa mayama agauwe. Tigeba asi nasi amani'amaka napi napi puma miyewe. ");
INSERT INTO for_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Piya, naeba wa'eriti nasi nasi puma amani'enaripa agakena nasimagi, ima ka aratara pi awa'ena mayama waintegi aisuwe: Mapa kampa agantompe kasa wa'ega, ae'enawe, aisuwe. Pigoya, kana kasa wa'egaba kampagiri abinta, aeti mono'ena pota, ae ago urimekiri abiyo. ");
INSERT INTO for_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Koti ma aboratama pi'na abobori a'ya'waemaena toma tomantana atawaentiye. Pi ae mantawamage mawamage agoba mintiye. Pigoya, aeba wasana ayapisa kimaranta namapipa kampa miyabapa miye. ");
INSERT INTO for_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Piya, ka'enaga aguyosagagina wasanama aborama amikenaenaba kampa waintiye. Pipa kampaye. Aewa maga maga kina tae mikenaenabe taumabe a'ya'waemaenabe tamiwaeye. ");
INSERT INTO for_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Pigoya, wasana aipa ka'anto aboratama yogana, aepisa a'ya'ma marisa kinapa aboraurite wagana puntawe. Pigoya, aborama mirite wakubompeka, kanape ape aima aewa uratantiye. ");
INSERT INTO for_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Pigoya, pi tagutasa aguyosagate wama, aewa uma abatakubompeka napima, Wa'ega Koti piya puntiye. Pigoya, aeba pagasa'iba kampaye. Abakatepi wasana ai'niratama miye. ");
INSERT INTO for_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Piya pegi: Taeba miyemintanama nkai'niratatagi mima a'ya'maenaba pune. Tigetisa abinta kina ka'isamiba pabiyama: Taeba Wa'egawamapisa aborantompene, untawe. ");
INSERT INTO for_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Pigoya, wasana taeba Koti ntagara mintunemaba, a'yugu napima, korirasabe siribarasabe yabatasabe, Koti amankapa pumagini aogi awa'ena pewe. Pika Kotitisa aborantompe taeba Kotika abekanaba, pi nkawametapa a-peno. ");
INSERT INTO for_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Paipa abikenaena kampa abima mirite waugunaba, Koti tigama, ataba kampa puritanti, pi kanaba ago a'ya puwantiye. Pigoya ibaba a'ya'ma maga maga kina tigu a'wae piyomagina, urataye. ");
INSERT INTO for_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Pigoya, kana ka atantegina waintiye. Pi ntagaba maga maga kina agorepa maema aborama, tagu antotapa ka awameta tamikiye. Pigoya, wasana ka'waina pi ntuga penema, purintapisa abage puma, Wa'ega asitama, agowapa purayakintiye, Poro piya uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Pigoya, Poro aeba purintapisa asikena kamana yogini, ka'isa kina'miba uma ata potauguni, piya to ka'isamiba: Pi kamanapa to ka yagaba yega abeno, untawe. ");
INSERT INTO for_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Piya yuguna, Poroba itate wantiye. ");
INSERT INTO for_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Pigoya, tarantomi Poroti uma atokaema Isu aegarantawe. Igetisa ka Ariyopagasi kanisore yagara, agewapa Taiyonisiyasi, piya waya ka agewapa Tamarisibe, to ka'isabe kagane. ");
INSERT INTO for_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pigoya, Poro aeba Atenisi kumapa atate, Korinti kumati wantiye. ");
INSERT INTO for_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Pita'i Yuta yagara ka abatantiye. Agewapa Akura, aeba Pontasi mari aboranti, pigoya waya'wapa Pirisira, aege Itariya mari mintusuguna, wasana wa'ega yagara Korotiyasiba, Yuta kina Aroma kuma akunkitama igarubantiye. Pigoya, isigeba pi kumapa atate, aoso Korinti kumata wama mintusuguna, pita'i Poroba isige uma isibatantiye. ");
INSERT INTO for_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Pigoya, Poro aeba seri nama pome ntagaragana, Akura aeba pabiyama pabi ntuga pomeka, namankapi mima ao'maeyoginisi kaga puntase. ");
INSERT INTO for_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pigoya, Poroba a'ya'ma sabatirapa Yuta kina'mi mpono namapi ima, Yuta kinape mono uwaimima, aegarakena kamana uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Pigoya, Sairasige Timotigeba isigeba Masetoniya marisaba a'wae puma kanausuguna, Poroba mono yugaba esegima puntiye. Piya puntana, Isu aeba taga utaratanta yagara, pi agoba Yuta kina aborama uwaimintiye. ");
INSERT INTO for_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Piya uwaimogini, igeba kamana'wapa uma kamparaga puma, aeka ata potauguna kaiwatisa i'nipa asari pogana tumogana, Yuta kinapa maya uwaimintiye: Ataena pikibe, pi kaintanaba nae'enaba kampaye. Tige'enaenawe. Pika mampa nakabiritate to marisa kina'miti yoga pukuwe, untiye. ");
INSERT INTO for_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Piya ute, ka yagara agewapa Titiyasi Yasitasi, aeba Kariki yagarama Koti mpono aega'ma mintanti, ae namapi ima mintantiye. Kana yagarama ntamapa Yuta kina'mi mpono namankama agora waintantiye. ");
INSERT INTO for_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Pigoya, pi Yuta kina'mi mpono nama kiye yagara, agewapa Karisipasi, aeba aokinape igeba mono abima Wa'ega aegarantawe. Aibuguni, Korinti kina igetisa uwoma kina'mi mono abima mono wani pasintawe. ");
INSERT INTO for_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Pigoya, ka aseka Wa'egawama aboramima Poro maya omintiye: Kaeba karuba a-puntana, monopa umaba a-kaso. ");
INSERT INTO for_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Piya, ma kumatapa nae naokinapa uwoma kina mintaka, uma miyo. Naeba kaege kaga miyokini, wasanamiba ataenaba kampa pugatama kampa kaegukibewe, piya untiye. ");
INSERT INTO for_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Piya uma omogana, Poro aeba Korinti kumata Koti kamana uwaimima mintogana, opa tonagisarisa kakaga umaema a'ya puntiye. ");
INSERT INTO for_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Pigoya, ainti Kariyo aeba Akaiya mari tabe kiye yagara puma mintogini, Yuta kina igeba kaga asima Poro kama potamagini, ababute pi kiya yagaramati wama kamana otantawe. ");
INSERT INTO for_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ababute wama kampari uma maya untawe: Ma ntagara aeba a'ya'ma wa waya imiyo kamana uma, Kotitisa kasa mono wasiyoma uwaigasima miyema, kampari otantawe. Piya yuguna, ");
INSERT INTO for_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Poroba kamana ukena pogana, Kariyoba akayotama, Yuta kina maya uwaimintiye: We, Yuta kina, ma ntagara aeba kaintana kunta'ena aboramisinta, kamanatipa abosine. ");
INSERT INTO for_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Pigoya, tigeba uwa kamanatitake kamana agoritake monotitakeraka uma otawe. Pika tigeri kamana'wapa uma a'ya ataiyo. Pipa nae yugaba kampaye, untiye. ");
INSERT INTO for_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Piya uma otanti ntamatasa igarubaogini, ");
INSERT INTO for_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","wasana igeba to ka Yuta kina'mi nkini namatasa kiye yagarawai, agewapa Sositenisi, aepa araku'ma kiya yagarama ntama kabe awara tabera aeguma, ataena potantawe. Piya puguna, kiya yagaraba igama uwasuwa puwaitantiye. ");
INSERT INTO for_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pigoya, Poro aeba Korinti kumata mimagina, ainti a'wae puma wakena puntanaba, mono abinta kina igeka: Aogima miyiyo, uwaitate, wanipisa karebi ima, iyoginisi Pirisirabe Akurabe isigeba aega'ma kaga wantawe. Pigoya, Poro aeba Koti nkaobi uma esegi potama, Senkeriya kumata uma irosa'ma mima, a'nopa agabu pukaintiye. ");
INSERT INTO for_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Pigoya, igeba Siriya mari wakenaraka wanipisa karebi ima, pitasa kaga wama Epesasi kumata uma irosa'ma, aokina tara isitategina, Poroba Yuta kina'mi mpono namapi ima, Yuta kina'mige mono kamana uma abintawe. ");
INSERT INTO for_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Pigoya, Yuta kina'miba: Taege mikune, uma arakurikena yuguna, maya uwaimintiye: ");
INSERT INTO for_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","A'a, kampaya, Koti abi namekapa to kake tigeti a'wae puma kanakuwe, uwaitate, igeka: Aogima miyiyo, uwaitate, Epesasi kumati wanipisa karebi to kake ima wama, ");
INSERT INTO for_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sisariya kumata uma irosantiye. Pitasa wanipisa karebintisa tumima, Yerusaremi kumati ima, monota ai'aru pume kina'mi: Aogima miyiyo, uwaimite, Antiyoki kumati to kake a'wae puma wantiye. ");
INSERT INTO for_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pigoya, Poro aeba Antiyoki kumata uwaenanto migate, mono kayokaya'enara to kake wantiye. Piya puma, Karesiya, Pirisiya maba isigaite to kumati to kumati wantana, Isu nkaegaranta kina kamana uwaimima esegi puwaitantiye. ");
INSERT INTO for_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Piya pogana, Epesasi kumati Yuta yagara ka irosantiye. Agewapa Aporo, aeba Aresanteriya kumata aboranti, pi kana yagaraba tabe abikenaena wantaga, paisa mono isapi aisuma abibebe puwaentiye. ");
INSERT INTO for_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Piya pogini, Wa'egawama ominta monopa aogima abintiye. Pigoya, to ka'isa kina'mi Yoni mono wani pai'itanti awaga kamanape, Isu nkawaga kamanape, omuguna abimagina, Isu nkagogaba kampa napintiye. Pigoya, pi ntagara Karaisiti aborakibi kamanapa esegima aogima uwaimintana, aborantiyemaba kampa napintiye. ");
INSERT INTO for_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Pigoya, ka yagaba Yuta kina'mi ige mono namapi ima pabiyama monopa kampa aekuru punta, agowapa aogima untiye. Pita'i pi mpono yoginisi, Akurage Pirisira isigeba abite kayone puma agoya potamaginisi, Koti nkagoba aogi uma arupu pomintase. ");
INSERT INTO for_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Piya pusuguna, Akaiya mari wakena pomepa, Isu nkaegaranta kina igeba ae napiyenawapa esegi potamagini, marota'isa Isu nkaegaranta kina ige'ena esa mayama kaentawe: Ma ntagara aeba tigeti wakiripa, kayone potaiyoma, kaentawe. Esa piyama kaema amuguna, wama Korinti kumata uma irosa'ma, Koti kayonena puwaitantemi mono kinapa mono yugarapa tabera iyo'maentiye. ");
INSERT INTO for_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Pigoya, paisa mono kamana awa'ena agowapa ku'magina: Isu aeba taga utaratanta yagara Karaisitiwema, pi agowapa wasana iyobi uma aborama uwaimima, Yuta kina'mi kamanapa maema a'wa puma maba atantiye. ");
INSERT INTO for_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Pigoya, Aporo aeba Korinti kumata mono yuga piyama puma mintogana, Poro aeba ka'isa mari ainkima nasi nasi puta, Epesasi kumata uma irosa'ma Isu nkaegaranta kina ka'isa uma ibatama, ");
INSERT INTO for_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ibigama maya untiye: Tigeba mono abima, Aota Awamusa maentabe ayabayawe, yogini, igeba maya untawe: Kampaye. Aota Awamusa minti, pi awaga kamana'wapa kampa abintune, untawe. ");
INSERT INTO for_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Piya yuguna, to kake ibigantiye: Tigeba ke nkagera mono wanipa pasintawe, yogini, maya omintawe: Taeba Yoni mpono waninkamana pasintompene, untawe. ");
INSERT INTO for_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Piya yuguna Poroba maya uwaimintiye: Yoni aeba wasanami ige igu a'wae pikibeka wani pai'itama maya uwaimintiye: Naka'i kanama miyemi'na, aeka abima napima aegaraiyo, untiye. Pi kamana Isuka untiye, Poro piya untiye. ");
INSERT INTO for_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Piya yogini, wasanamiba kana kamana abite, mono wanika yuguna, Wa'ega Isu nkagera pai'itantawe. ");
INSERT INTO for_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Wani pasuguna, Poroba i'nota ayapa ataogana, Aota Awamusa'ama igeti tumpima, intebu a'wae pugasogini to kamana to kamana uma poropete kina'mi usuma agowapa untawe. ");
INSERT INTO for_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Pigoya pi kana wabe wayape a'ya'ma nagisarisa tara tumpaema puntawe. ");
INSERT INTO for_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pigoya, Poro aeba Yuta kina'mi mpono namapi asi nasi imagina, monopa karu kampa punta, opa kakaga mima uwaimima mintantiye. Piya puntana, Koti kabiratakena kamana'ama nkagoba uma aborawaimintiye. ");
INSERT INTO for_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Piya pogini, ka'isa kina'miba igu'ama esegi pumagini, Isu mpono ikabitama, monota akiyenabi kasa mono kika uma ata puguna, Poroba uwa itantiye. Piya pumagina, Isu nkaegaranta kina ibabuma aki puwaitama, asi nasima ka yagara Tiranasi ae awa'ena namapi mono uwaimima iyakima mintantiye. ");
INSERT INTO for_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Piya puma, kaboba tara mima pogini, ainkima Esiya mari Yuta kinape Kariki kinape mintume kina igeba a'ya'ma Wa'egawama mpono awaga kamanapa abiwaentawe. ");
INSERT INTO for_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Piya puguna, Kotiba Poropa esegi potaogana, awame'enaba agasiya toma tomantana ayapisa puntiye. ");
INSERT INTO for_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Pigoya pika wasanamiba Poronta autasaenaba maeritegini wama, yonintana ibome kina'mi ita u'ma aukaya puguni, yonintanawaipa itawaogini kaba'ma aogi puguna, intabaipintisa ke kina'miba irosa'ma iyegaka wantawe. ");
INSERT INTO for_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Pigoya, Yuta kina tonarona tusa kina a'ya'ma maba ainkima nasi nasi pumagini, ka'isa Wa'ega Isu nkagera atama ke kinaka maya uwaimintawe: Isu nkage awaga kamana Poro yemi, ae awamuta esegima ugamekana atate wao, untawe. ");
INSERT INTO for_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Pigoya, tabe mono kiye yagarama ntagara ka, agewapa Siwa, ae yakaraki'nu tonaentisa tara umaema kina'mi piya puntawe. ");
INSERT INTO for_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Piya puguna, ka kewama kamana mayama a'wae puwaimintiye: Isupa abibebe puntawe. Piya, Poro nkageba abintuwe. Tigeba aetasa kinatawe, untiye. ");
INSERT INTO for_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kewama piya umagina, kana yagara aisepaogana esegi puma, kana yakaraki'nu iyeguma kaiwaipa aerutu puwaigasima kora kasu iyeguyogini, ika namapintisa irosa'ma iyegaka wagaintawe. ");
INSERT INTO for_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Piya pogini, ainti Epesasi kumata mintanta kina, Yuta kina'mibe Kariki kina'mibe abite tabera iyekuru pumagini, Wa'ega Isu nkagega'eba asaga'yuntawe. ");
INSERT INTO for_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Pigoya, Isu nkaegaranta kina uwoma kina irosa'magini, pai ataena punta pi kamana intawama aseyonabisa uma aborawaentawe. ");
INSERT INTO for_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Pigoya, uwoma kina'mi kiyo'ena asebena puma esa u'ma miyume, pi isapa maete kanama wasanami nkiyobi ampa yaku kaentawe. Piya isa'ama nkikantanawapa maema aki puntasinta, 50,000 tora puntesine. ");
INSERT INTO for_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Pigoya, wasanamiba piya puguna, Wa'egawama mpono'amaba aborama anosaurite wagana puma esegi puntiye. ");
INSERT INTO for_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pigoya, Poro aeba piyama yoga puma a'ya ataogana, Awamusa otaogana Masetoniya mabe Akaiya mabe agaite, Yerusaremi kumati wakenaga untiye. Piya puntana maya untiye: Naeba Yerusaremi kumata uma irosa'magipa, to kake kanama wama Aroma kumata uma irosakuwe, untiye. ");
INSERT INTO for_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Pigoya, wakena puntanaba, abagi yagara tara Timotike Irasitasike uwaisitaoginisi, Masetoniya mari paitama wantase. Piya pusuguna, aewapa Esiya mara to kake amato puma uwaenanto mintantiye. ");
INSERT INTO for_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Pigoya, pi ntagaba Epesasi kumatapa mono'ama kama potama, kasa mono ki akunintawe. ");
INSERT INTO for_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Monerase konariyena pome ntagara ka mintantiye. Agewapa Timiteriyasi, aeba Atemisi amani wae'wampa amankapa aogiyena uwaenantontoba siribarasa puma ataogini, wasanamiba monerasa ika puguna, aewape aokina'mipe moneba uwoma aborawaimogini, a'ya wakiyemagini kama potantawe. ");
INSERT INTO for_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Pigoya, Timiteriyasi aeba aokina igega'e uma aki puwaitama maya uwaimintiye: Nao'mitaba, tigeba yogarepa pi'na moneba aborama tamemi, pipa abintawe. ");
INSERT INTO for_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Pigoya, ka yagara kanama ampintiye. Poro ae, tigeba ae agoba agama abewe. Aeba Epesasi kumatasabe Esiya marisa ka'isa kinapa tabera igu'amapa maema a'yugu puwaigasima maya uwaimiye: Wasana iyapisa pumaranta koti pipa kumpari'ena, au'wa kampa wainta'enawe, uma uwaimiye. ");
INSERT INTO for_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Aeba piya pekana, yogarempaba au'wapa kampa waikiye. Tabe kotire Atemisi ae wa'eba kasipama ataena pikiye. Piya, Atemisi ae'wa nkage awaga kamana'wapa tumima ataena pikiye. Piya pekini, Esiya marisabe to ka'isa marisa kina'mibe a'ya'ma ae kamana abima aegaraompe'na, age awaga kamanapa a'ya'ma kaka wakiye, piya untiye. ");
INSERT INTO for_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Pigoya, Timiteriyasi aeba aokina piya uwaimogini abite, igupipa igobintanamaba awaitaogini, kega'e uma maya untawe: Epesasi kumatasa Atemisi aeba amani tabewe, piya untawe. ");
INSERT INTO for_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Piya umagini, kana kumapipa tabe kiga'e umagini, tabe kamana a'ya'ma kina'mi untawe. Piya ute, a'ya'ma asima wama akiyena pubume kumati uma aki pikena wantini, igeba Kaiyasike Arisitakasikeba kaga isiraku'ma isibabute wantawe. Kana yagara taraba Masetoniya yagararaginisi, Poro aega'ma kaga nasi nasi puntawe. ");
INSERT INTO for_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pigoya, Poroba abite kana wasana aki pumeti wakena pogini, Isuti atokaenta kina'mi akayotantawe. ");
INSERT INTO for_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Piya, ka'isa Esiya marisa kamani kina Poro aokina'miba, Poroti kamana atauguna waogini, uma esegi puma kampa wasana aruyenabipa wanema akunkatantawe. ");
INSERT INTO for_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Pi kana kina'mipa napi napiyenawaipa a'yugu puwaogini, ka'isamiba ka kamana uma kega'e yuguna, to ka'isa kina'miba to kamana uma kega'e untawe. Piya yuguni, uwaena kina'miba kana aki pume kamana'ama agowapa kampa aogima abintawe. ");
INSERT INTO for_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Kana wasanamiba piya puguni, Yuta kina'miba Arekisanta abubasanauguna, kana kina'mi abakapi wantiye. Aibogini, ka'isa kina'miba kamana agoba omuguna, Arekisanta aeba aya tugupa puwaitama, kamana antotapa wa waya a'ya'ma uwaimikena puntiye. ");
INSERT INTO for_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Pigoya, wasanamiba kamana abima, aepa Yuta yagara agabebe pumagini, a'ya'ma kega'e umagini, maya untawe: Atemisi aeba Epesasi kumatasa wa'ega tabewe, piya uma e'erota tu awa kega'e untawe. ");
INSERT INTO for_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Piya yuguna, pi kumatasa kusikusi yagara aeba kamana'waipa uma paru puma, kayone puwaitama maya uwaimintiye: Ma kumatasa Epesasi kina, tigeba ago abintawe. Ma kumapa tae wa'ega Atemisi ae ago kumane. Piya, akuninta yabapa mantarisa tupuma mata'i tumintine. ");
INSERT INTO for_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Pigoya, wasanama kana kamanapa kampa akayukiye. Pika tigeba uwa paka puma, a'yuguyenaba a-piyo. ");
INSERT INTO for_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Tigeba tara yagarara isibabute kanantapa, pipa isigeba mono namapisa ka'ena maema a'yugu puma kuntana pikena kampa kanantase. Piya, wa'ega waete Atemisi, ae akayasotakenaba kampaye. ");
INSERT INTO for_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Pigoya, Timiteriyasibe yoga kina'wampibe kaga ka yagaramage kamana'wai waintakiniba, kamana ukena yaga aborakini, kiya kina mintati igeti uma yiyo. ");
INSERT INTO for_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tigeba ka'isa kamanati waintakiripa, kiya kina'mi akiyenabi maete waiyo. ");
INSERT INTO for_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Piya, taeba ibasa yagaba maka uma ma'ena puma ataena pikena pune. Piya pompekini, wasana wa'ega kina'mi abite tagega'e uma tabigaigipa, kamana antotapa nana kamana uwaimukune, untiye. ");
INSERT INTO for_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Kana kusikusi yagarama piya ute igarubaogini, kana akiyena pumepa atate wantawe. ");
INSERT INTO for_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Pigoya, kamana uma maka yumepa pabigo paka puwauguna, Poroba Isu nkaegaranta kina igega'e uma, i'nana kamana esegima uwaimite, Masetoniya mari wantiye. ");
INSERT INTO for_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Maba pi againtanaba, monota ai'aru pume kina mirite wanta, ige to kake ige'ma kamana uwaimita, wama Kariki mari uma irosantiye. ");
INSERT INTO for_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Irosa'magina, pita'i opa kakaga migaite, kayo waniti tumima, wanipisa karebi ima Siriya mari wakenaga yogini, Yuta kina igeba aegukena kamana yuguna abitegina, atate Masetoniya mari mabi wantiye. ");
INSERT INTO for_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Pigoya, mayaki kina'mi ke'iba abagi puntawe: Periya kumatasa Sopata, aeba Pirasi ntagarawa, Tesaronaika kumatasa Arisitakasige Sekantasigewa, Tebi kumatasaba Kaiyasige Timotigewa, Esiya marisaba Tikikasige Toropimasigewa sumagini, ");
INSERT INTO for_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","piyaki kina'mi paitamagini, Torowasi kumata tagawa puma mintantawe. ");
INSERT INTO for_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tau'ikena yaga, yisiti kampa wainta pareti nakena yagaba a'ya poga, Piripai kumati wanipisa karebi ima, nayaka'mu yaga wama Torowasi kumata uma irosantune. Pita'i irosa'ma, tonaentisa tara umaema yaga mintantune. ");
INSERT INTO for_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pigoya, taeba sontara ara naninta nakena aki puntune. Piya puwakana, Poro aeba marekanaba wakena uma mono kamana uma miyogana, aseka nkabubu puntiye. ");
INSERT INTO for_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Pigoya, kana mintuwampe aboborasa marupipa kanepa uwoma nkigi atauguna tantiye. ");
INSERT INTO for_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Piya puguna, ka yagara agewapa Yutikasi, aeba Poroba monopa e'erota yogana, abaku kabira mima awai pegu pumagina awaintiye. Awaita mintometisa abaku kabirisa ware'nama, mabi tumpa aeguwaiyogini, asitaumepa ago araginaka yogini, inatisa kakaga maru pumarantatisa tumima aeguyomeka ara aeguntiye. ");
INSERT INTO for_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Piya pogana, Poroba tumima aepa'ma asitama wasana maya uwaimintiye: Tigeba a'tiyekuruba piyo. Aumaba uwa waintegina aogaye, piya untiye. ");
INSERT INTO for_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Piya utegina, namapinti ima pareti akobuma imite nate puntiye. Nagaite, igege to e'erota mono uwaimogini abima mintuguna marintiye. Marogana itate wantiye. ");
INSERT INTO for_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Kana wasanamiba kana yagaraba aogaogini namankapinti ababute wamagini, intawamaba tabera paru puma aogima asoya puntawe. ");
INSERT INTO for_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pigoya Poro yoga, taeba wanipisa karebi ima Asosi kumati paitama, pitasa aba pikena wauwakana, aewapa uwa mari pi kumati wantiye. ");
INSERT INTO for_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Pigoya, Asosi kumati wama uma tabataoga, wanipisa karebi ima arupu puma wantune. Wama Mitirini kumata uma irosantune. ");
INSERT INTO for_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Pitasa wama marogapa Kayosi uma irosa'ma agaitegi, pabigo pitasa wama to ka yagaba Semosi uma irosa'magi, pitasa wama marogapa Mairitasi kumata uma irosantune. ");
INSERT INTO for_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Piyama, Poro aeba Pentikositi yagaba Yerusaremi kumata uma iro