﻿USE sofia;
DROP TABLE IF EXISTS sofia.flr_vpl;
CREATE TABLE flr_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES flr_vpl WRITE;
INSERT INTO flr_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Ku ndondeko, Rurema akabumba igulu neꞌkihugo. ");
INSERT INTO flr_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Ikihugo kyâli riiri kimaata, kitanâli riiri neꞌnjusho yoshi. Ikihulu namudidi kyâli yidisiri hiꞌgulu lyaꞌmabenga gaꞌmiiji. Noꞌmutima gwa Rurema gwâli kizi leera hiꞌgulu lyago. ");
INSERT INTO flr_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Rurema anakyula: «Umulengeerwe gube ho.» Kwokwo, umulengeerwe gwanayami ba ho. ");
INSERT INTO flr_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Rurema anabona kwo guli mwija, anaguhandula neꞌkihulu. ");
INSERT INTO flr_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Yugwo mulengeerwe, Rurema anaguyinika iziina Bukiiri. Neꞌkihulu, anakiyinika iziina Bushigi. Akabigingwe kanalenga, bwanakya shesheezi. Yulwo lwo lukaba lusiku lwa mbere. ");
INSERT INTO flr_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Rurema anashubi kyula: «Ha kati kaꞌmiiji, habe ikyanyaanya, gira kihandule amiiji ágali hiꞌgulu, na ágali haashi.» ");
INSERT INTO flr_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kwokwo, kirya kyanyaanya kyanaba ho. Yago miiji gombi, kyanagahandula. Maguma ganasigala hiꞌgulu mu kyanyaanya. Naꞌgandi ganabeera mwiꞌdako lyakyo. ");
INSERT INTO flr_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Yikyo kyanyaanya, Rurema anakiyinika iziina Igulu. Akabigingwe kanalenga, bwanakya shesheezi. Lwo lukaba lusiku lwa kabiri. ");
INSERT INTO flr_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Rurema anashubi kyula: «Amiiji ágali mwiꞌdako, gayigushe haguma, halinde haboneke áhayumiri.» Kwanaba kwo bigaaba. ");
INSERT INTO flr_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Áhayumiri, Rurema anahayinika iziina Idaho. Na haꞌmiiji gakayigusha, anahayinika iziina Nyaaja. Ikyanya Rurema akagira kwokwo, anabona kwo biri biija. ");
INSERT INTO flr_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Rurema anashubi kyula: «Idaho limeze imbuto za ngiisi mulala. Imbuto nguma zikizi ba neꞌndete. Habe neꞌbiti byoꞌkutongeka kweꞌbitumbwe íbiri mweꞌndete, halinde zikizi meza ibindi.» Kwanaba kwo bigaaba. ");
INSERT INTO flr_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Lirya idaho lyanameza ngiisi mulala gweꞌmbuto íziri neꞌndete. Lyanameza na ngiisi biti íbiri mu tongeka kweꞌbitumbwe íbiri mweꞌndete, halinde byanakizi meza ibindi. Yizo mbuto, na yibyo biti byoshi, iri Rurema akayusa ukubibumba, anabona kwo biri biija. ");
INSERT INTO flr_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Akabigingwe kanalenga, bwanakya shesheezi. Lwo lukaba lusiku lwa kashatu. ");
INSERT INTO flr_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Rurema anashubi kyula: «Kwiꞌgulu, kukizi ba imirengeerwe, gira ikizi handula ubukiiri noꞌbushigi. Iyo mirengeerwe ikizi ba kalangikizo koꞌkuyerekana ibyanya byeꞌsiku ngulu, na byeꞌmirege-rege, na byeꞌmyaka. ");
INSERT INTO flr_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Iyo mirengeerwe íri kwiꞌgulu, ikizi tanguulira ikihugo.» Kwanaba kwo bigaaba. ");
INSERT INTO flr_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Akatee gira imirengeerwe mihamu. Muguma guli mu kizi tanguula bweneene mu bukiiri. Ugwabo guli mu kizi moleka bushigi. Na kwakundi, anagira neꞌndonde. ");
INSERT INTO flr_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Iyo mirengeerwe yoshi, íbikatuma Rurema akagibiika kwiꞌgulu, gira ikizi tanguulira ikihugo. ");
INSERT INTO flr_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ee! Ikizi tanguula ubukiiri, ikizi moleka na bushigi. Kwokwo, ikizi handula umulengeerwe neꞌkihulu. Iyo mirengeerwe, iri Rurema akayusa ukugibumba, anabona kwo iri miija. ");
INSERT INTO flr_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Akabigingwe kanalenga, bwanakya shesheezi. Lwo lukaba lusiku lwa kana. ");
INSERT INTO flr_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Rurema anashubi kyula: «Mu nyaaja, muvubuke ngiisi mulala gweꞌfwi, kwo ziri ngumaana. Na mu kyanyaanya, mukizi purumuka utunyuni.» ");
INSERT INTO flr_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kwokwo, mu nyaaja, Rurema analema mwo babitaatalwe beꞌfwi. Analema na ngiisi bindi biremwa byoshi, byanakizi yoleka-yoleka mwo. Yibyo biremwa biri mu kizi vubuka mwo, ukukulikirana neꞌmilala yabyo. Analema neꞌmilala yoshi yoꞌtunyuni. Yibyo byoshi, ikyanya Rurema akayusa ukubibumba, anabona kwo biri biija. ");
INSERT INTO flr_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Yibyo byoshi, Rurema anabigashaanira, anabwira ifwi, ti: «Mukizi butana, halinde muyushuuke, munakwire mu nyaaja. Noꞌtunyuni natwo, tuluguuke mu kihugo.» ");
INSERT INTO flr_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Akabigingwe kanalenga, bwanakya shesheezi. Lwo lukaba lusiku lwa kataanu. ");
INSERT INTO flr_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Rurema anashubi kyula: «Ikihugo kiyijule mwo ngiisi mulala gweꞌbiremwa, binakizi butana, ngiisi mulala kwagwo-kwagwo. Haboneke ibitugwa, neꞌbizimu, na íbiri mu yibulula, kiri neꞌnyamiishwa.» Kwanaba kwo bigaaba. ");
INSERT INTO flr_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Iyo milala yoshi yeꞌnyamiishwa, na yeꞌbitugwa, na yeꞌbizimu, na ya íbiri mu yibulula, Rurema ye kabibumba. Neꞌri akayusa ukubibumba, anabona kwo biri biija. ");
INSERT INTO flr_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ha nyuma, Rurema anashubi kyula: «Tubumbage abandu, babe nga ngiisi kwo tuli, halinde batushushe. Babe batwali beꞌkihugo na íbikiri mwo byoshi, ngeꞌfwi, noꞌtunyuni, neꞌbitugwa, neꞌbizimu, na íbiri mu yibulula.» ");
INSERT INTO flr_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kwokwo, Rurema anabumba abandu ku njusho yage. Akababumba mushosi noꞌmukazi. Ku yeyo njusho yage, kwo akababumba. ");
INSERT INTO flr_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Yabo bandu, iri Rurema akayusa ukubabumba, anabagashaanira mu kubabwira: «Mukizi buta, munayushuuke, halinde mukwire mu mahanga gooshi. Munabe mwe batwali baago, naꞌbeꞌfwi, na boꞌtunyuni, naꞌba ngiisi kiremwa kyoshi íkiri mwoꞌbugumaana, kinabe kiri mu genda kwiꞌdaho.» ");
INSERT INTO flr_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Rurema anashubi deta: «Mu kihugo, ngiisi mbuto íri neꞌndete, na ngiisi kiti íkiri mu tongeka kweꞌbitumbwe, namùheereza byo. Yibyo byoshi, byo byokulya biinyu. ");
INSERT INTO flr_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","«Haliko inyamiishwa zooshi, neꞌbitugwa byoshi, byohe bigakizi liisa ibyasi. Kiri noꞌtunyuni, na íbiri mu yibulula, na ngiisi kindi kiremwa kyoshi kigumaana, nabyo bigakizi liisa ibyasi.» Kwanaba kwo bigaaba. ");
INSERT INTO flr_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yibyo byoshi, iri Rurema akayusa ukubibumba, anabona kwo biri biija. Akabigingwe kanalenga, bwanakya shesheezi. Lwo lukaba lusiku lwa kalindatu. ");
INSERT INTO flr_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Igulu neꞌkihugo, na byoshi íbiri mwo, kwokwo kwo Rurema akabirema. ");
INSERT INTO flr_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Neꞌri akayusagya ukulema byoshi, ku lusiku lwa kalinda analuhuuka. ");
INSERT INTO flr_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Mukuba, âli mali yusa ukulema byoshi, kyanatuma agataluula yulwo lusiku lwa kalinda mu zaabo, analugashaanira. ");
INSERT INTO flr_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Igulu neꞌkihugo, ikyanya bikalemwa, kwoku kwo bikaba. Ikyanya Nahano Rurema akabirema, ");
INSERT INTO flr_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","mu kihugo, ndaayo mbuto íyâli zaazi mera, ndaanakyo kindu kiri neꞌkiguma íkyâli zaazi ba ho. Mukuba, Nahano Rurema atâli zaazi niesa invula. Hatanâli riiri umundu woꞌkulima idaho. ");
INSERT INTO flr_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kundu kwokwo, mwiꞌdaho mwanakizi shyoka utudota, twanakizi linywisa lyoshi. ");
INSERT INTO flr_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Mu luvu, mwo Nahano Rurema akabumba umushosi, anamúfuuhira umuuka mu mazuulu. Uyo mushosi, anaba kiremwa kigumaana. ");
INSERT INTO flr_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ha nyuma, Nahano Rurema anabyala indalo i Hedeni, uluhande lweꞌsheere, anagibiika mwoꞌyo mundu. ");
INSERT INTO flr_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Rurema anamezagya ngiisi milala yeꞌbiti. Byâli buyahiri, byanâli hiiti ibitumbwe binunu. Mwomwo, mwâli riiri neꞌkiti kyoꞌkuleeta ubulamu, kiri neꞌkiti kyoꞌkumenyeesa abandu amiija naꞌmabi. ");
INSERT INTO flr_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Mwiꞌyo ndalo, mwâli riiri noꞌlwiji, lwanâli kizi ginywisa. Imunda lwâli kizi hingira, lwanabereka mweꞌnyiiji zina. ");
INSERT INTO flr_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Ulwiji lwa mbere luli mu buuzibwa Pishooni. Lwo luzungulusiri mu kihugo kyoshi kyeꞌHavila. Yikyo kihugo, kiri mweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Na kwakundi, muli noꞌmubadu úguli mu detwa bedola. Muli naꞌmabuye miija, ágali mu detwa honikisi. ");
INSERT INTO flr_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ulwiji lwa kabiri luli mu buuzibwa Gihooni. Luzungulusiri mu kihugo kyoshi kyeꞌKuushi. ");
INSERT INTO flr_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ulwiji lwa kashatu luli mu buuzibwa Tigire. Luli mu hingira uluhande lweꞌsheere lweꞌkihugo kyeꞌHasuriya. Ulwiji lwa kana luli mu buuzibwa Hefuraati. ");
INSERT INTO flr_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Na íbitumiri Nahano Rurema akabiika uyo mushosi mu ndalo yeꞌHedeni, gira akizi gilima, anakizi gilanga. ");
INSERT INTO flr_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Nahano Rurema anamúbwira kwokuno: «Mwiꞌyi ndalo, uhangwirwi ukukizi lya ibitumbwe byeꞌbiti byoshi. ");
INSERT INTO flr_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Si ibitumbwe byeꞌkiti kyoꞌkumenyeesa amiija naꞌmabi, utakolwagwa kwo wabilya. Ulusiku lwo ugabilya kwo, ku kasiisa ugaafwa.» ");
INSERT INTO flr_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Ha nyuma, Nahano Rurema anayidesa: «Uyu mushosi, butali bwija kwo atuulage yenyene. Ngamúgirira umutabaazi.» ");
INSERT INTO flr_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kwokwo, Nahano Rurema anayabiira uluvu, analema mwo ngiisi mulala gweꞌnyamiishwa, na gwoꞌtunyuni, útuli mu balala mu kyanyaanya. Anabileetera umushosi, gira alole ngiisi kwo agabiyinika amaziina. Yibyo biremwa byoshi, ngiisi maziina go akabiyinika, ganaba go maziina gaabyo. ");
INSERT INTO flr_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kwokwo, ibitugwa byoshi, neꞌnyamiishwa zooshi, noꞌtunyuni twoshi, uyo mushosi ye kabiyinika amaziina. Si ku luhande lwage, hatâli zaazi boneka umutabaazi úmukwiriiri. ");
INSERT INTO flr_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kwokwo, uyo mushosi, Nahano Rurema anamúbiika mwiꞌro lyaꞌkahondo-hondo. Neꞌri akaba aki huniiri, Nahano Rurema anamúlyosa mwoꞌlubavu luguma, anahashubaania neꞌminyofu. ");
INSERT INTO flr_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Lulya lubavu, Nahano Rurema analubumba mwoꞌmukazi. Neꞌkyanya akamúleeta imunda umushosi, ");
INSERT INTO flr_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","mbu amúbonage, ti: «Yonago! Uyu, ali ivuha lya mu mavuha gaani, anali munyofu gwa mu minyofu yani. Bwo alyosibwa mu mushosi, kyo kitumiri agakizi buuzibwa Mukazi.» ");
INSERT INTO flr_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ku yukwo, umushosi agaasiga yishe na nyina, anayibiike ku mukaage. Na bombi, banabe bakola magala maguma. ");
INSERT INTO flr_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Uyo mushosi bo na mukaage, bombi bâli riiri bukondwe, batanâli kizi gwatwa neꞌshoni. ");
INSERT INTO flr_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Mu nyamiishwa zooshi zo Nahano Rurema akabumba, umujoka gwo gwâli riiri mulyalya. Yugwo mujoka, gwanayiji bwira umukazi kwokuno: «Ewe! Ngiisi kiti íkiri mwiꞌno ndalo, ka Rurema akadeta kwo mutakizi lya ku bitumbwe byakyo?» ");
INSERT INTO flr_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Uyo mukazi, ti: «Ibitumbwe byeꞌbiti byoshi íbiri mwiꞌno ndalo, tuhangwirwi ukukizi bilya. ");
INSERT INTO flr_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Si akadeta naaho kweꞌbitumbwe byeꞌkiti íkiri ha kati kaayo, byoki tutakolwe kwo twabilya kwo. Kiri noꞌkukihuma kwo, tutahangwirwi. Mango twakihuma kwo, tugaafwa.» ");
INSERT INTO flr_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Gulya mujoka, ti: «Aahabi! Mutagaafwa. ");
INSERT INTO flr_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Íbitumiri Rurema akadeta kwokwo, bwo ayiji kwo mango mwalya ku bitumbwe byakyo, amasu giinyu gagahumuuka. Munabe nga Rurema, mu kukizi menya amiija naꞌmabi.» ");
INSERT INTO flr_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Uyo mukazi, anabona kweꞌbitumbwe bya kirya kiti bibuyahiri bweneene, anabona kwo byanganuna mu kanwa. Na kwakundi, byanganabaleetera ubumenyi. Nguye, ku yibyo bitumbwe, anadotola kiguma, anakilya kwo. Na bwo âli riiri na yiba, kyanatuma agamúfumbadika kyo, naye analya. ");
INSERT INTO flr_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Lyeryo yabo bombi, amasu gaabo ganayami humuuka, banayibona kwo bali bukondwe. Kyanatuma bagayihangira ibibabi byeꞌkiti kyoꞌmutiini, banabikenyera. ");
INSERT INTO flr_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Mwiꞌyo ndalo, iri hakaba kakola kabigingwe, uyo mushosi bo na mukaage banayuvwa ishwagala za Nahano Rurema. Iri bakayuvwa kwokwo, banayami gendi yifulika mu biti, gira atababone. ");
INSERT INTO flr_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kundu kwokwo, Nahano Rurema anamúhamagala, ti: «Ulyagagi hayi?» ");
INSERT INTO flr_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Na wa naye, ti: «Nayuvwa ishwagala zaawe hano mu ndalo, nanayoboha, bwo ngola bukondwe. Kwokwo, nanayibisha.» ");
INSERT INTO flr_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Rurema, ti: «Nyandagi keera úwakubwira kwo ukola bukondwe? Kirya kiti kyo nꞌgakulahiza kwo, ka keera walya ku bitumbwe byakyo?» ");
INSERT INTO flr_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Na wa naye, ti: «E waliha, ulya mukazi ye ukandeetera, ye wambeereza ikitumbwe, nanalya.» ");
INSERT INTO flr_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Nahano Rurema anabuuza umukazi: «Maki gano wagira?» Naye, ti: «Gulya mujoka gwo gwandeba, nanalya.» ");
INSERT INTO flr_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Gulya mujoka, Nahano Rurema anagubwira: «Bwo wagira kwoku, we koli daasirwi ukuhima ibitugwa byoshi, neꞌnyamiishwa zooshi. Ukola ugakizi gendeesa ibunda isiku zaawe zooshi, unakola ugakizi lya uluvu. ");
INSERT INTO flr_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Mwe noꞌyu mukazi, ngolaga ngabiika ubugoma ha kati kiinyu, kiri na ha kati keꞌkibusi kyawe neꞌkyeꞌmwage. Agakizi kufutira kwiꞌtwe. Naawe, unakizi múkomera ku kasiizira.» ");
INSERT INTO flr_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Uyo mukazi, Rurema anabuli múbwira: «Mu kubuta, ngakizi kuyushuulira umukero, unakizi buta abaana ku bulyanirwe. Ugakizi yifwija yibalo. Ye gaanaba mutwali wawe.» ");
INSERT INTO flr_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ha nyuma, Rurema anabwira Hadamu: «Nꞌgakulahiza kwo utalye ku yiki kiti. Kundu kwokwo, wasimbaha mukaawe, wanalya ku bitumbwe byakyo. Ku yukwo, idaho likoli daasirwi hiꞌgulu lyawe. Kwokwo, isiku zaawe zooshi ukola ugakizi yitubanula kwiꞌdaho, halinde ulonge ibyokulya. ");
INSERT INTO flr_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Hiꞌgulu lyawe, idaho likola ligakizi meza imigenge, neꞌmihanda-njovu. Kundu kwokwo, ugakizi yimbula, byo ugaalya. ");
INSERT INTO flr_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Mu kulonga ibyokulya, ugakizi shaha ikyuya, halinde ukuhisa ku kyanya ugagalukira mwiꞌdaho. Mukuba, mwiꞌdaho mwo ukalyosibwa, munali mwo ugashubi galukira.» ");
INSERT INTO flr_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Hadamu, (kuli kudeta: mundu), anayinika mukaage iziina Heeva, bwo ye nyina waꞌbandu booshi. ");
INSERT INTO flr_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Hadamu bo na mukaage, Nahano Rurema anabagirira ibyambalwa mu mbu, anabayambika byo. ");
INSERT INTO flr_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nahano Rurema anashubi deta: «Bwoꞌmundu akoli sobanukiirwi naꞌmiija naꞌmabi, akola nga muguma witu. Aahago! Tumúhangirire, atayiji kengeera alya ibitumbwe byeꞌkiti kyoꞌbulamu. Mukuba, mango akilya, lyo agaalama imyaka neꞌmyakuula.» ");
INSERT INTO flr_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kwokwo, Rurema anayami yimula Hadamu mu ndalo yeꞌHedeni, gira akizi gendi lima idaho. Lyo na lyeryo, akabumbwa mwo. ");
INSERT INTO flr_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ha nyuma, Rurema anabiika bamakerubi uluhande lweꞌsheere lweꞌndalo. Anabiika neꞌngooti íri mu kyemula nga mbigi zoꞌmuliro. Iyo ngooti, yâli kizi langa injira yoꞌkugenda iwa kirya kiti kyoꞌbulamu. ");
INSERT INTO flr_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Hadamu anamenyana na mukaage Heeva. Neꞌkyanya Heeva akaheeka inda, anabuta Kahini, anadeta: «Keera nabuta umwana woꞌbutabana ku butabaazi bwa Nahano.» ");
INSERT INTO flr_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ha nyuma, Heeva anashubi buta mulumuna wa Kahini, ye Habeeri. Uyo Habeeri, âli riiri mutuuzi weꞌbibuzi. Na Kahini, âli riiri mulimi. ");
INSERT INTO flr_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Isiku, iri zikalengerana, Kahini anatangira Nahano ku mimbu yage, libe ituulo. ");
INSERT INTO flr_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Habeeri naye, mu bibuzi byage, anayabiira mwo íbishishiri, íbikatangi butwa, anabitangira Nahano, libe ituulo. Nahano anasimiisibwa na Habeeri niꞌtuulo lyage. ");
INSERT INTO flr_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Si atanasimiisibwa na Kahini yehe, niꞌtuulo lyage. Ku yukwo, uyo Kahini, umutima gwage gwanakizi hiira. Kiri naꞌmalanga gaage, ganaba gakoli zizibiiri. ");
INSERT INTO flr_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Nahano anabuuzagya Kahini: «Kituma kiki umutima gwawe gwasiriira? Na kituma kiki ukoli zizibiiri? ");
INSERT INTO flr_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Aaho! Iri wangakizi kola amiija, ka utangayemeererwa? Halikago, iri wangalahira, ikyaha kikoli kuyiteziri ha mulyango, kinali mu kuyifwija. Kundu kwokwo, ukwaniini ukihime.» ");
INSERT INTO flr_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Lusiku luguma, Kahini anabwira mulumuna wage wa Habeeri, ti: «Ewe! Tugendi tanduula imbingiro.» Yabo bombi, iri bakaba keera bahikaga yo, lyeryo Kahini anabirigisha mulumuna wage, anayami múyita. ");
INSERT INTO flr_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ha nyuma, uyo Kahini, Nahano anamúbuuza: «E Kahini, mulumuna wawe wa Habeeri alyagagi hayi?» Na wa naye, ti: «Ndayiji! Ka nie mulaazi wage?» ");
INSERT INTO flr_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Nahano anashubi múbuuza: «E Kahini, makagi gano wagira? Umuko gwa mulumuna wawe, si nguyuvwiti ngiꞌzu lyoꞌmundu úgweti ugandakira ukulyoka mwiꞌdaho. ");
INSERT INTO flr_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","«Si keera wayiyitira mulumuna wawe! Niꞌdaho, keera lyayanuuka, mu kuyakiira umuko gwage. Buno, ukoli daasirwi, unakola ugayimulwa kwiꞌdaho. ");
INSERT INTO flr_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ikyanya ugakizi lirima, utagaki shubi yeza. Si ukola ugaaba mundu woꞌkukizi jeba-jeba mu kihugo, iri unakizi yangaara.» ");
INSERT INTO flr_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Uyo Kahini, mbu ayuvwagwe kwokwo, ti: «Yikyo kihano kyo wambeereza, ndangakihasha. Kinzidohiiri bweneene. ");
INSERT INTO flr_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lolaga! Buno keera wambavya kwiꞌdaho, ndaganaki boneka imbere lyawe. Ngola ngaaba naaho wa kukizi genda ngayangaara mu kihugo. Ngiisi mundu úwangambona, agayami nyita.» ");
INSERT INTO flr_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Nahano, ti: «Nanga! Ngiisi úgakuyita, agaahanwa ubugira kalinda.» Haaho, Nahano anabiika Kahini kwaꞌkalangikizo, gira ngiisi úgamúbona, atamúyite. ");
INSERT INTO flr_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kahini anashaaga imbere lya Nahano, anagendi tuula mu kihugo kyeꞌNoodi, uluhande lweꞌsheere lweꞌHedeni. ");
INSERT INTO flr_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kahini anamenyana na mukaage. Neꞌri akaheeka inda, anabuta Hinoki. Ha nyuma, Kahini anayubaka akaaya, anakayinika iziina lya mugala wage wa Hinoki. ");
INSERT INTO flr_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Hinoki naye, anabuta Hiraadi. Hiraadi naye, anabuta Mehuyaheeri. Mehuyaheeri naye, anabuta Metushaheeri. Metushaheeri naye, anabuta Laameke. ");
INSERT INTO flr_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Uyo Laameke, anayanga abakazi babiri. Muguma, ye Haada. Noꞌwabo ye Siila. ");
INSERT INTO flr_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Uyo Haada, anabuta Yabaali. Na Yabaali, ye yishe wa booshi ábatuuziri mu maheema, banali batuuzi. ");
INSERT INTO flr_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Mulumuna wage, ye Yubaali. Yubaali naye, ye yishe wa booshi ábali mu lasa imiteera-teera, kiri neꞌnzeeze. ");
INSERT INTO flr_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Siila naye, anabuta Tubaali-Kahini. Uyo Tubaali-Kahini, ye mutuzi weꞌbyugi byeꞌmiringa, na byeꞌbyuma. Na mwali wage, ye Nahama. ");
INSERT INTO flr_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Uyo Laameke, anabwira bakaage: «E Haada mwe na Siila, mundegage amatwiri. E bakazi baani, ngiisi byo ngamùbwira, mubiyuvwirize. Niehe, ikyanya umundu akangomeeresa, nanayami múyita. Ee! Ikyanya umusore gukandema, nanaguyita. ");
INSERT INTO flr_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Aahago! Iri Kahini agayihoolerwa ubugira kalinda, niehe Laameke ngayihoolerwa ubugira makumi galinda na bulinda.» ");
INSERT INTO flr_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Hadamu anashubi menyana na mukaage Heeva. Neꞌri akashubi heeka inda, anabuta umwana woꞌbutabana, anamúyinika iziina Seeti. Anadeta: «Rurema keera angashaanira, mu kushubi mbeereza ugundi mwana, abe kigombo kya Habeeri. Mukuba, Habeeri, Kahini keera akamúyita.» ");
INSERT INTO flr_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seeti naye, anabuta umwana woꞌbutabana, anamúyinika iziina Hinoshi. Ukulyokera ku yikyo kyanya, abandu banatondeera ukukizi shenga kwiꞌziina lya Nahano. ");
INSERT INTO flr_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Yuku, kwo kutondobolwa kwaꞌbandu ba mwiꞌkondo lya Hadamu. Ikyanya Rurema akabumba abandu, akababumba ku njusho yage. ");
INSERT INTO flr_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Akababumba mushosi noꞌmukazi, anabagashaanira. Ku kyanya akababumba, anabayinika iziina Bandu. ");
INSERT INTO flr_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Hadamu, iri akaba akola neꞌmyaka igana na makumi gashatu, anabuta umwana weꞌnjusho yage. Uyo mwana âli múshushiri, anamúyinika iziina Seeti. ");
INSERT INTO flr_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Ikyanya Hadamu akaba keera abuta Seeti, analama igindi myaka magana galimunaana. Mwiꞌyo myaka, anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Hadamu, iri akalama imyaka magana galimwenda na makumi gashatu, anafwa. ");
INSERT INTO flr_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Uyo Seeti, iri akaba akola neꞌmyaka igana niꞌtaanu, anabuta Hinoshi. ");
INSERT INTO flr_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ha nyuma lyoꞌkumúbuta, analama igindi myaka magana galimunaana niꞌrinda. Mwiꞌyo myaka, anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Seeti naye, iri akalama imyaka magana galimwenda niꞌkumi niꞌbiri, anafwa. ");
INSERT INTO flr_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Uyo Hinoshi, iri akaba akola neꞌmyaka makumi galimwenda, anabuta Kenaani. ");
INSERT INTO flr_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Ha nyuma lyoꞌkumúbuta, analama igindi myaka magana galimunaana niꞌkumi niꞌtaanu. Mwiꞌyo myaka, anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Hinoshi naye, iri akalama imyaka magana galimwenda niꞌtaanu, anafwa. ");
INSERT INTO flr_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Uyo Kenaani, iri akaba akola neꞌmyaka makumi galinda, anabuta Mahalaleeri. ");
INSERT INTO flr_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Ha nyuma lyoꞌkumúbuta, analama igindi myaka magana galimunaana na makumi gana. Mwiꞌyo myaka, anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenaani naye, iri akahisa imyaka magana galimwenda niꞌkumi, anafwa. ");
INSERT INTO flr_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Uyo Mahalaleeri, iri akaba akola neꞌmyaka makumi galindatu niꞌtaanu, anabuta Yareedi. ");
INSERT INTO flr_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ha nyuma lyoꞌkumúbuta, analama igindi myaka magana galimunaana na makumi gashatu. Mwiꞌyo myaka, anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalaleeri naye, iri akalama imyaka magana galimunaana na makumi galimwenda niꞌtaanu, anafwa. ");
INSERT INTO flr_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Uyo Yareedi, iri akaba akola neꞌmyaka igana na makumi galindatu niꞌbiri, anabuta Hinoki. ");
INSERT INTO flr_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ha nyuma lyoꞌkumúbuta, analama igindi myaka magana galimunaana. Mwiꞌyo myaka, anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yareedi naye, iri akalama imyaka magana galimwenda na makumi galindatu niꞌbiri, anafwa. ");
INSERT INTO flr_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Uyo Hinoki, iri akaba akola neꞌmyaka makumi galindatu niꞌtaanu, anabuta Metuseela. ");
INSERT INTO flr_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ha nyuma lyoꞌkumúbuta, analama igindi myaka magana gashatu. Mwiꞌyo myaka, Hinoki âli tuuziri neꞌngoome na Rurema. Anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hinoki, analama imyaka magana gashatu na makumi galindatu niꞌtaanu. ");
INSERT INTO flr_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Na bwo âli tuuziri neꞌngoome na Rurema, lusiku luguma Rurema anamútwala, atanakiboneka. ");
INSERT INTO flr_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Uyo Metuseela, iri akaba akola neꞌmyaka igana na makumi galimunaana niꞌrinda, anabuta Laameke. ");
INSERT INTO flr_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ha nyuma lyoꞌkumúbuta, analama igindi myaka magana galinda na makumi galimunaana niꞌbiri. Mwiꞌyo myaka, anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metuseela naye, iri akalama imyaka magana galimwenda na makumi galindatu na mwenda, anafwa. ");
INSERT INTO flr_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Uyo Laameke, iri akaba akola neꞌmyaka igana na makumi galimunaana niꞌbiri, anabuta umwana woꞌbutabana. ");
INSERT INTO flr_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Anamúyinika iziina Nuhu. Anadeta: «Nahano keera adaaka idaho, kyo kitumiri tukola mu liyitubanula kwo. Kundu kwokwo, uyu mwana, ye gakizi tuholeeza.» ");
INSERT INTO flr_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ha nyuma lyoꞌkubuta Nuhu, Laameke analama igindi myaka magana gataanu na makumi galimwenda niꞌtaanu. Mwiꞌyo myaka, anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Laameke naye, iri akalama imyaka magana galinda na makumi galinda niꞌrinda, anafwa. ");
INSERT INTO flr_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Uyo Nuhu, iri akaba akola neꞌmyaka magana gataanu, anabuta Sheemu, na Haamu, na Yafeti. ");
INSERT INTO flr_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Ikyanya abandu bakatondeera ukuyushuuka mu kihugo, banakizi buta abanyere. ");
INSERT INTO flr_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Yabo banyere, abaana ba Rurema banababona kwo banonosiri bweneene, banatoola mwo ngiisi bo basiimiri, banabayanga. ");
INSERT INTO flr_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kyanatuma Nahano agayidesa kwokuno: «Umutima gwani, gutagayama guli mu hagana naꞌbandu, banalyagagi ba kufwa. Buno, imyaka yabo yoꞌkulama, ikola igaaba igana na makumi gabiri naaho.» ");
INSERT INTO flr_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Mu yizo siku, kiri na ha nyuma lyazo, hâli riiri ibihagange byaꞌbandu mu kihugo. Yibyo bihagange, yabo baana ba Rurema, bâli kizi bibuta ku yabo banyere baꞌbandu. Yaho keera, yibyo bihagange byo byâli riiri ndwani, byo byanâli lumbuusiri bweneene. ");
INSERT INTO flr_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nahano anabona ngiisi kwaꞌbandu bakoli bihuusiri mu kihugo, na ngiisi kwo bâli kizi looza naaho ukugira ibikoleere. ");
INSERT INTO flr_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Kyanatuma agavunika umutima, anajengeerwa. Neꞌri hakatama, anayishuhiza mbu biki íbikatuma agabumba yaba bandu mu kihugo. ");
INSERT INTO flr_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kwokwo, Nahano anadeta: «Balya bandu, kundu nie kababumba, halikago ngola ngabaminika. Kiri neꞌnyamiishwa zooshi, nazo ngaziminika, kuguma neꞌbiremwa íbiri mu yibulula, noꞌtunyuni twa mu kyanyaanya. Mukuba, ngola mu yishuhiza, mbu biki íbikatuma ngabilema.» ");
INSERT INTO flr_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nuhu naaho, ye wâli kizi simiisa Nahano. ");
INSERT INTO flr_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Abandu ba mu mbaga ya Nuhu, umwazi gwabo gwo gwoguno: Ku kyanya kyage, yehe naaho, ye wâli kwaniini imbere lya Rurema, ndaanabwo buhube bwo âli hiiti. Âli tuuziri neꞌngoome nyiija na Rurema. ");
INSERT INTO flr_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuhu akabuta abaana boꞌbutabana bashatu: Sheemu, na Haamu, na Yafeti. ");
INSERT INTO flr_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Rurema anabona ngiisi kwaꞌbandu bakoli bihuusiri bweneene, na ngiisi kwo bakola mu yitana. ");
INSERT INTO flr_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Na bwo bâli koli bihuusiri, kyanatuma ngiisi mundu agakizi yifunda mu bikoleere nga kwo âli loziizi. ");
INSERT INTO flr_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kwokwo, Rurema anabwira Nuhu: «Lolaga! Bwaꞌbandu bakola mu yitana, keera natwa uluhango kwo ngola ngabaminika booshi. Ku kasiisa ngola ngabaminika, kuguma neꞌkihugo. ");
INSERT INTO flr_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","«Ku yukwo, ugendi kuba ibiti bikomu, unayubake mwo nangungubanga waꞌmashuba. Yago mashuba, ugabiike mweꞌbisiika, unagahembe ubulungu mu nda neꞌmugongo. ");
INSERT INTO flr_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ugayubake kwokuno: Mu bula-bula bwago, zibe meetere igana na makumi gashatu na zishatu. Na mu matambi, zibe meetere makumi gabiri na zibiri. Noꞌmujuuja, zibe meetere ikumi na zishatu. ");
INSERT INTO flr_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","«Yago mashuba, ugayubakage mwaꞌhandu hashatu áhashoneriini kwo. Mu butambi buguma, usige mwoꞌmulyango. Mwidako lyaꞌkatwe, hasigwe akaazo keꞌkitolo kyeꞌmeetere. ");
INSERT INTO flr_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","«Yuvwa! Nienyene, ngaleeta umwijulire gwaꞌmiiji mu kihugo. Kwokwo, lyo ngaminika ibiremwa byoshi íbiri mwiꞌdako liꞌzuuba. Byoshi íbiri mu kihugo, bigayami hera ngana. ");
INSERT INTO flr_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Si wehe, tuganywana ikihango. Kwokwo, ugayingira mu mashuba mwe na mukaawe, na bagala baawe, kiri na bali-kazi baawe. ");
INSERT INTO flr_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","«Uyingize na mweꞌbiremwa bibiri-bibiri, ikishosi neꞌkikazi, halinde mweshi mukire. ");
INSERT INTO flr_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Mu yibyo biremwa, mugaaba ngiisi mulala gwoꞌtunyuni, na gweꞌnyamiishwa, noꞌgwa íbiri mu yibulula. Yibyo byoshi, bigakuyijira bibiri-bibiri, ikishosi neꞌkikazi, gira ukabikize. ");
INSERT INTO flr_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Kwokwo, uyabiirage ngiisi mulala gweꞌbyokulya, kibe kihinda kiinyu, kiri neꞌkya yibyo biremwa.» ");
INSERT INTO flr_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Yibyo byoshi, Nuhu anabigira nga kwo Rurema akamúbwira. ");
INSERT INTO flr_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Ha nyuma, Nahano anashubi bwira Nuhu: «Bwobuno, uyingirage mu mashuba, neꞌmbaga yawe yoshi. Mukuba, mu bandu booshi ba kino kibusi, wehe naaho, we mbwini kwo ukwaniini imbere lyani. ");
INSERT INTO flr_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","«Uyingize mwo ngiisi mulala gweꞌbitugwa. Neꞌbitugwa íbyangatangwa ituulo, uyingize birinda-birinda, ibishosi neꞌbikazi. Na íbitangatangwa ituulo, neꞌnyamiishwa, uyingize kiguma-kiguma, ikishosi neꞌkikazi. ");
INSERT INTO flr_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","«Na mu ngiisi mulala gwoꞌtunyuni, uyabiire mwo tulinda-tulinda, ihihazi, neꞌhidaabwa, gira lyeꞌyo milala yoshi yeꞌbitugwa, na yeꞌnyamiishwa, na yoꞌtunyuni, ikasigale mu kihugo. ");
INSERT INTO flr_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","«Ha nyuma lyeꞌsiku zirinda, nganiesa invula mu kihugo. Iyo nvula, igaamala isiku makumi gana, ubushigi niꞌzuuba, iri mu nia. Leero, ngiisi kiremwa kyoshi kyo nꞌgalema, ngakiminika.» ");
INSERT INTO flr_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Yibyo byoshi byo Nahano akabwira Nuhu, Nuhu anabigira. ");
INSERT INTO flr_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Ikyanya umwijulire gukayija mu kihugo, Nuhu âli kola neꞌmyaka magana galindatu. ");
INSERT INTO flr_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Kwokwo, Nuhu anayingira mu mashuba na mukaage, na bagala baage, na bali-kazi baage, gira lyo bafuuka umwijulire. ");
INSERT INTO flr_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Birya biremwa byoshi, ibishosi neꞌbikazi, byanakizi yijira Nuhu ha mashuba, gira nabyo biyingire mwo, nga kwo Rurema âli mali gwanwa amúbwira. Hâli riiri ibitugwa íbyangatangwa ituulo, na íbitangalitangwa. Hâli riiri neꞌnyamiishwa, noꞌtunyuni, neꞌbindi biremwa byoshi. ");
INSERT INTO flr_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Zirya siku zirinda, iri zikaba keera zalenga, gulya mwijulire gwanayija mu kihugo. ");
INSERT INTO flr_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ikyanya Nuhu âli mali hisa imyaka magana galindatu, mu siku ikumi na zirinda zoꞌmwezi gwa kabiri, yugwo mwijulire gwanayija. Ku lwolwo lusiku, ishyoko zooshi za mu kuzimu, zanabira mwaꞌmiiji. Kiri na mwiꞌgulu, invula yanavwulumuka! ");
INSERT INTO flr_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Iyo nvula, yanamala isiku makumi gana, ubushigi niꞌzuuba, ítahumba. ");
INSERT INTO flr_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ikyanya Nuhu akayingira mu mashuba, âli riiri na mukaage, na bagala baage kwo bali bashatu, Sheemu, na Haamu, na Yafeti, na bali-kazi baage bashatu. ");
INSERT INTO flr_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Bakayingira mwo na ngiisi mulala gweꞌbitugwa, na gweꞌnyamiishwa, na gwoꞌtunyuni, na ngiisi mulala gweꞌbiremwa byoshi íbiri mu yibulula. ");
INSERT INTO flr_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Yibyo biremwa byoshi, bikayijira Nuhu, byanakizi yingira mu mashuba, bibiri-bibiri. ");
INSERT INTO flr_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Mu kati kaabyo, mu ngiisi mulala mwâli riiri, ikishosi neꞌkikazi, nga kwo Rurema âli mali gwanwa abwira Nuhu. Ha nyuma, Nahano yenyene anahamika ulwivi. ");
INSERT INTO flr_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Mu yizo siku makumi gana zeꞌnvula, amiiji gâli kizi genderera ukuheema, halinde ganakizi zamuula amashuba, ganatondeera ukuleremba. ");
INSERT INTO flr_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Galya miiji, ganagenderera ukukizi heema, ganayushuuka bweneene, halinde amashuba ganakizi leremba ku miiji. ");
INSERT INTO flr_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Ganashubi genderera ukuheema mu kihugo, halinde utunywangi-nywangi tweꞌmigazi twoshi twanabindikirwa. ");
INSERT INTO flr_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Neꞌkyanya ikabindikirwa, galya miiji ganagenderera ukuheema, halinde ukuhisa ingingwe yeꞌmeetere zirinda hiꞌgulu lyayo. ");
INSERT INTO flr_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Mu yizo siku, ngiisi biremwa íbiri mu genda kwiꞌdaho, byanayami fwa. Kuli kudeta, íbiri mu yibulula, noꞌtunyuni, neꞌbitugwa, neꞌnyamiishwa, kiri naꞌbandu booshi. ");
INSERT INTO flr_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ibiremwa íbituuziri i bulambo bikafwa byoshi-byoshi. ");
INSERT INTO flr_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Kwokwo, kwo Rurema akaminika ngiisi biremwa bya mu kihugo, ukutondeerera ku bandu, na ku nyamiishwa, na ku biremwa íbiri mu yibulula, halinde noꞌtunyuni. Nuhu naaho ye kakira, na ngiisi byo akayingirana mu mashuba. ");
INSERT INTO flr_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Yugwo mwijulire, gukamala isiku igana na makumi gataanu, gubindikiiri ikihugo. ");
INSERT INTO flr_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Gulya mwijulire, ikyanya gukahisa isiku igana na makumi gataanu, Rurema âli ki kengiiri Nuhu, neꞌbitugwa byoshi, neꞌnyamiishwa zooshi, nga kwo byâli riiri mu mashuba. Kyanatuma Rurema agalungika imbuusi, yanahuusa bweneene mu kihugo, halinde amiiji ganatondeera ukuyema. ");
INSERT INTO flr_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ku yikyo kyanya, ishyoko za mu kuzimu, zanayigalwa. Kiri niꞌgulu lyanashwekwa, halinde iyo invula yanahumba lwoshi. ");
INSERT INTO flr_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Amiiji ganakizi genda gali mu yema. Na ku mbeka ya yizo siku igana na makumi gataanu, ganayema ingingwe. ");
INSERT INTO flr_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Iri hakaba mu siku ikumi na zirinda zoꞌmwezi gwa kalinda, uyo nangungubanga waꞌmashuba anayikira ku mugazi muguma gwa mu kihugo kyeꞌHararaati. ");
INSERT INTO flr_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Yago miiji, ganagenderera ukukizi yema bwija-bwija, halinde ku mwezi gwiꞌkumi. Na ku lusiku lwa mbere lwa gwogwo mwezi, amarango ganashubi boneka. ");
INSERT INTO flr_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ha nyuma lyeꞌsiku makumi gana, Nuhu anayigula kalya kaazo ko akagira ku mashuba, ");
INSERT INTO flr_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","anatuma namujongo. Uyo namujongo, anabalala, anakizi yihunguula-hunguula, halinde ikyanya amiiji gakaba keera gakama mu kihugo. ");
INSERT INTO flr_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ha nyuma, Nuhu anatuma ingunde nayo, gira amenye iri amiiji keera gayema lwoshi kwiꞌdaho. ");
INSERT INTO flr_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Halikago, bwaꞌmiiji gâli ki riiri kwiꞌdaho, iyo ngunde yanabula ho igaatwa, yanagalukira imunda Nuhu. Nuhu anagitega ukuboko, anashubi giyingiza mu mashuba. ");
INSERT INTO flr_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Iyo ngunde, Nuhu analindirira izindi isiku zirinda, anashubi gituma. ");
INSERT INTO flr_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Iri hakaba kabigingwe, iyo ngunde yanagalukira imunda Nuhu. Yanayija ihiiti ihyasi hibishi hyoꞌmuzehituuni mu mulomo. Haaho, Nuhu anayami menya kwaꞌmiiji keera gakama. ");
INSERT INTO flr_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nuhu analindirira izindi isiku zirinda, anashubi tuma irya ngunde. Si leero, itanaki shubi múgalukira. ");
INSERT INTO flr_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ikyanya Nuhu akahisa imyaka magana galindatu na muguma, ku lusiku lwa mbere lwoꞌmwezi gwa mbere, yago miiji gâli mali kama mu kihugo kyoshi. Neꞌkyanya Nuhu akatumbuula akatwe kaꞌmashuba, anabona kwiꞌdaho lyoshi likoli kamuusiri. ");
INSERT INTO flr_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Na ku lusiku lwa makumi gabiri na zirinda lwoꞌmwezi gwa kabiri, idaho lyanaba keera lyakamuuka lwoshi. ");
INSERT INTO flr_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kwokwo, Rurema anabwira Nuhu: ");
INSERT INTO flr_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Uhulukage mu mashuba, mwe na mukaawe, na bagala baawe, na bali-kazi baawe. ");
INSERT INTO flr_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Uhuluse neꞌbiremwa byoshi byo muliriinwi: utunyuni, neꞌnyamiishwa, na íbiri mu yibulula byoshi. Birya byoshi, bikizi shubi butana, binaluguuke, halinde binakwire mu kihugo kyoshi.» ");
INSERT INTO flr_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kwokwo, Nuhu anahuluka mu mashuba, na mukaage, na bagala baage na bali-kazi baage. ");
INSERT INTO flr_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Birya biremwa byoshi nabyo, byanahuluka mwo, mulala muguma-muguma. Inyamiishwa zooshi, noꞌtunyuni twoshi, neꞌbiremwa byoshi íbiri mu yibulula, na ngiisi kindu íkiri mu genda kwiꞌdaho. ");
INSERT INTO flr_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Ha nyuma, Nuhu anayubakira Nahano akatanda. Anayabiira ku bizira kashembo mu bitugwa na mu tunyuni, anabitangira Rurema hiꞌgulu lyako, gabe matuulo goꞌkusiriiza. ");
INSERT INTO flr_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yago matuulo, ikyanya Nahano akayuvwa umushiiriri gwago, gwanamúsimiisa, anayidesa kwokuno: «Buno, ndâye ki daake idaho, mbu bwaꞌbandu bambubira. Na kundu imitono yabo ituula-tuula mibi ukulyokera ubwanuke bwabo, ndâye ki shereeze kandi ibiremwa byoshi, nga ngiisi kwo nꞌgagira. ");
INSERT INTO flr_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Ku kyanya kyoshi ikihugo kigaaba kikiri ho, hagayama hali ikyanya kyoꞌkubyala, na kyoꞌkuyimbula. Hanabe neꞌkyanya kyeꞌmbeho, na kiꞌduutu. Hanabe neꞌkyanya kyeꞌkikamo, na kyeꞌmbondo. Hanabe neꞌkyanya kyoꞌbushigi, na kiꞌzuuba.» ");
INSERT INTO flr_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Ha nyuma, Rurema anagashaanira Nuhu, bo na bagala baage, anababwira kwokuno: «Mukizi buta bayisho, na banyoko, halinde muyushuuke, munakwire mu mahanga gooshi. ");
INSERT INTO flr_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","«Ukulyokera buno, inyamiishwa zooshi za mu kihugo zikola zigakizi mùyoboha, kiri noꞌtunyuni twoshi twa mu kyanyaanya, neꞌbiremwa byoshi íbiri mu yibulula, neꞌfwi zooshi za mu nyaaja. Yibyo byoshi, mwe mugaaba noꞌbushobozi hiꞌgulu lyabyo. ");
INSERT INTO flr_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","«Ubwa mbere, nâli kizi mùheereza ishogo nzobeera naaho. Halikago buno, ngiisi biremwa byoshi íbiri mu genda, bikola bigaaba byokulya biinyu. ");
INSERT INTO flr_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","«Kundu kwokwo, mutakolwe kwo mwakizi lya inyama íkiri mwoꞌmuko. Mukuba, mu muko, mwo muli ubugumaana. ");
INSERT INTO flr_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ku kasiisa, ikyanya umuko gwinyu gugayoneka, ngagulihiisa. Ngagulihiisa neꞌmwa ngiisi nyamiishwa. Ngiisi mundu, ngamúlihiisa umuko gwoꞌwabo. ");
INSERT INTO flr_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ngiisi úgayona umuko, uyo naye, ugweꞌmwage gugayonwa. Mukuba, abandu booshi, nꞌgababumba ku njusho yani. ");
INSERT INTO flr_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","«Kwokwo, mukizi buta bayisho, na banyoko, halinde muyushuuke, munabe munakwire mu mahanga gooshi, munagayondoloke mwo.» ");
INSERT INTO flr_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ha nyuma, Rurema anashubi bwira Nuhu, na bagala baage kwokuno: ");
INSERT INTO flr_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Yuvwagwi! Nienyene ngola nganywana ikihango na niinyu. Yikyo kihango, ngakigira kiri naꞌbandu beꞌbibusi biinyu ábagaki butwa. ");
INSERT INTO flr_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Na bwo mukalyoka neꞌbiremwa mu mashuba, ngakigira twe nabyo kwakundi. Kuli kudeta utunyuni, neꞌbitugwa, neꞌnyamiishwa zooshi, na ngiisi kindi kiremwa íkiri mu kihugo. ");
INSERT INTO flr_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","«Yikyo kihango, kyo kyekino: Ndâye ki shereeze íkiyimbwa kiremwa ku njira yoꞌmwijulire. Hatanâye ki be ugundi mwijulire gwoꞌkushereeza ikihugo.» ");
INSERT INTO flr_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Rurema anashubi deta: «Kino kihango kyo ngola mu gira na niinyu, neꞌbiremwa byoshi byo muliriinwi, kigayama kiri ho ku bibusi byoshi íbyâye ki yije. Naꞌkalangikizo kaakyo, ko kaaka: ");
INSERT INTO flr_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ngola ngabiika umukuruzi mu bibungu. Yugwo mukuruzi, ko kagaaba kalangikizo keꞌkihango kyo ngaagira neꞌkihugo. ");
INSERT INTO flr_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","«Ngiisi kyanya ngaleeta ibibungu mu kyanyaanya, noꞌmukuruzi gunabiboneke mwo, ");
INSERT INTO flr_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","lyo ngakizi kengeera ikihango kyo nꞌganywana na niinyu na ngiisi milala yeꞌbiremwa. Ndanâye ki koleese amiiji, mbu gashubi shereeza ibiremwa byoshi. ");
INSERT INTO flr_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","«Keera nanywana ikihango kyeꞌmyaka neꞌmyakuula. Kwokwo, ikyanya umukuruzi gugakizi boneka mu bibungu, ngakizi gubona. Haaho kirya kihango, na nyami kikengeera. Mukuba, nꞌgakigira na ngiisi mulala gweꞌbiremwa íbiri mu kihugo.» ");
INSERT INTO flr_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Rurema anashubi bwira Nuhu: «Kaako, ko kalangikizo keꞌkihango kyo nꞌgagira neꞌbiremwa byoshi íbiri mu kihugo.» ");
INSERT INTO flr_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Bagala Nuhu, bâli Sheemu, na Haamu, na Yafeti. (Uyo Haamu, ye kayiji ba yishe wa Kaanani.) Yabo bashatu, bo bakalyoka mu mashuba, ");
INSERT INTO flr_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","bo banali bashokuluza baꞌbandu booshi ábakashabukira mu kihugo. ");
INSERT INTO flr_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhu âli riiri mulimi, anatondeera ukubyala ibiti byeꞌmizabibu. ");
INSERT INTO flr_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ha nyuma, ikyanya akanywa idivaayi, analaluka, anagwejera mwiꞌheema lyage, akola bukondwe. ");
INSERT INTO flr_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Mugala wage wa Haamu (yishe wa Kaanani), iri akabona ngiisi kwo yishe akola bukondwe, anayami gendi ganuulira beene wabo, Sheemu na Yafeti, bwo bâli ki riiri ha mbuga. ");
INSERT INTO flr_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Haliko, Sheemu na Yafeti boohe, banayabiira umulondo, banaguyitumbika mu bitugo. Banagenda kifudeete, iri banalola ulundi luhande, gira batabone ubukondwe bwa yishe, banamúbwika. ");
INSERT INTO flr_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nuhu, iri indalwe ikamúlyoka mwo, anayiji menya ngiisi kwo mugala wage woꞌmuzibo amúgirira, ");
INSERT INTO flr_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","anamúdaaka kwokuno: «Kaanani, adaakwe! Ye kola úgaaba muja waꞌbakulu baage. ");
INSERT INTO flr_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ee! Kaanani abaagage muja wa Sheemu. Haliko, Sheemu yehe, Nahano Rurema wage ahuuzibwe. ");
INSERT INTO flr_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yafeti naye, Rurema amúyushuulire ikihugo. Anakizi tuula mu shumbi za Sheemu. Si Kaanani yehe, ayamage ali muja wabo.» ");
INSERT INTO flr_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Yugwo mwijulire, iri gukaba keera gwalenga, Nuhu anashubi lama igindi myaka magana gashatu na makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Imyaka yoshi yo Nuhu akalama mu kihugo, yâli hisiri magana galimwenda na makumi gataanu. Ha nyuma, anafwa. ");
INSERT INTO flr_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Abandu ba mu mbaga ya Sheemu, na Yafeti, na Haamu, bagala Nuhu, umwazi gwabo gwo gwoguno. Ikyanya gulya mwijulire gukamala, nabo banakizi buta abaana. Abandu ba mu makondo gaabo, bo baaba: ");
INSERT INTO flr_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Bagala Yafeti, bâli Gomeeri, na Magoogi, na Madaayi, na Yavaani, na Tubaali, na Mesheki, na Tiraasi. ");
INSERT INTO flr_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Na bagala Gomeeri, bâli Hashikenaazi, na Rifaati, na Togarima. ");
INSERT INTO flr_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Na bagala Yavaani, bâli Herisha, na Tarasisi, na Kitimu, na Rodanimu. ");
INSERT INTO flr_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Mu yabo baana ba Yavaani, mwo mukalyoka abandu ábakashabukira mu tulira, ngiisi bandu mu kihugo kyabo, ukukulikirana naꞌmakondo gaabo, neꞌndeto zaabo, neꞌmilala yabo. ");
INSERT INTO flr_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Bagala Haamu, nabo bâli Kuushi, na Misirayimu, na Puuti, na Kaanani. ");
INSERT INTO flr_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Na bagala Kuushi, bâli Seeba, na Havila, na Sabuta, na Rama, na Sabuteka. Rama naye, anabuta Sheeba, na Dedaani. ");
INSERT INTO flr_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Uyo Kuushi, ye kabuta na Nimuroodi. Uyo Nimuroodi, ye wâli kikalage bweneene mu ndwani za mu kihugo. ");
INSERT INTO flr_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Kyâli kikalage kiri na mu kuhiiva. Kyo kitumiri biri mu detwa kwokuno: «Ukizi ba nga Nimuroodi. Mukuba, mu bashosi booshi, ye wâli kikalage mu kuhiiva imbere lya Nahano.» ");
INSERT INTO flr_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Mu kihugo kyeꞌShinaari, utwaya two akatee twala, tuli i Babeeri, neꞌHereki, neꞌHakaadi, neꞌKaline. ");
INSERT INTO flr_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Neꞌri akalyoka yaho, anabungira mu poroveesi yeꞌHasuriya, anayubaka yaꞌkaaya keꞌNinaawi, naꞌkeꞌRehobooti-Hiri, naꞌkeꞌKaala, ");
INSERT INTO flr_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","naꞌkeꞌReseeni, ko kali ha kati keꞌNinaawi naꞌkaaya kahamu keꞌKaala. ");
INSERT INTO flr_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misirayimu ye shokuluza waꞌBaluudi, naꞌBahanami, naꞌBalehabi, naꞌBanafutuhi, ");
INSERT INTO flr_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","naꞌBapaturushi, naꞌBakafutori, naꞌBakasiluhi. (Mu yabo Bakasiluhi, mwaꞌBafirisiti bakalyoka.) ");
INSERT INTO flr_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kaanani ye kabuta Sidooni, ifula yage, anabuta na Heeti. ");
INSERT INTO flr_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ye na shokuluza waꞌBayebuusi, naꞌBahamoori, naꞌBagirigaashi, ");
INSERT INTO flr_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","naꞌBahivi, naꞌBahariki, naꞌBasiini, ");
INSERT INTO flr_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","naꞌBaharwadi, naꞌBazemaari, naꞌBahamaati. Ha nyuma, yabo bandu boꞌmulala gwaꞌBakaanani banashaabuka. ");
INSERT INTO flr_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Imbibi zeꞌkihugo kyabo, zâli lyokiiri i Sidooni, uluhande lweꞌGeraari, halinde i Gaza. Kyanashubi tondeerera uluhande lweꞌSoodoma, neꞌGomora, neꞌHadima, neꞌSeboyimu, halinde ukuhisa i Lasha. ");
INSERT INTO flr_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Yabo booshi, bo ba mu kibusi kya Haamu, ngiisi bandu mu bihugo byabo, ukukulikirana naꞌmakondo gaabo, neꞌndeto zaabo, neꞌmilala yabo. ");
INSERT INTO flr_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sheemu, mukulu wa Yafeti, ye shokuluza waꞌBahebeeri booshi. ");
INSERT INTO flr_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Bagala Sheemu, bâli Helamu, na Hashuuri, na Haripakisadi, na Luudi, na Haraamu. ");
INSERT INTO flr_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Bagala Haraamu nabo, bâli Huuzi, na Huuli, na Geteeri, na Mashi. ");
INSERT INTO flr_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Haripakisadi naye, anabuta Sheela. Na Sheela anabuta Hebeeri. ");
INSERT INTO flr_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Hebeeri naye, anabuta abaana babiri. Ifula, anagiyinika iziina Peregi, (kuli kudeta: kuyihandulana kwo). Mukuba, ku kyanya kyage, abandu bakashaabuka mu kihugo. Mulumuna wage, ye wâli Yokitaani. ");
INSERT INTO flr_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Uyo Yokitaani, akabuta Halimodadi, na Sherefu, na Hazarimaweti, na Yera, ");
INSERT INTO flr_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","na Hadoramu, na Huzaali, na Dikira, ");
INSERT INTO flr_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","na Hobaali, na Habimaheeri, na Sheeba, ");
INSERT INTO flr_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","na Hofiiri, na Havila, na Yobaabu. Yabo booshi, bâli bagala Yokitaani. ");
INSERT INTO flr_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ikihugo kyabo, kyâli tonderiiri i Mesha, uluhande lweꞌSefara, halinde ukuhisa mu migazi yeꞌsheere. ");
INSERT INTO flr_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Yabo booshi, kyo kibusi kya Sheemu, ngiisi bandu mu bihugo byabo, ukukulikirana naꞌmakondo gaabo, neꞌndeto zaabo, neꞌmilala yabo. ");
INSERT INTO flr_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Yabo bandu booshi, yo milala íkalyoka mu kibusi kyaꞌbaana ba Nuhu, ukukulikirana naꞌmakondo gaabo, ngiisi bandu mu kihugo kyabo. Ha nyuma lyoꞌmwijulire, abandu banakwira mu mahanga gooshi, ku njira ya bagala Nuhu. ");
INSERT INTO flr_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Mu mahanga gooshi, abandu bâli kizi deta indeto nguma naaho. Kwokwo, amagambo gaabo gooshi, gâli riiri go maguma. ");
INSERT INTO flr_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Yabo bandu, iri bakasheguukira uluhande lweꞌsheere, banabona indekeera ya mu kihugo kyeꞌShinaari, banagendi gituula mwo. ");
INSERT INTO flr_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Iri hakatama, yabo bandu banasalizania, ti: «Mugire tukizi bumba amatafaari, tunagayokye, halinde gahye bwija.» (Mu yizo siku, amatafaari go bâli kizi koleesa ahandu haꞌmabuye. Naꞌkabulimbo, kâli kizi kola ngeꞌshima.) ");
INSERT INTO flr_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ha nyuma, banashubi ganuuzania, ti: «Mugirage tuyubake akaaya, kanabe kali noꞌlwingo úlugaahika halinde kwiꞌgulu. Kwokwo, lyo nyiitu tukizi menyeekana, tutanaki shaabukire mu mahanga gooshi.» ");
INSERT INTO flr_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yako kaaya, ikyanya yabo bandu bâli kizi kayubaka, kuguma noꞌlwingo, Nahano anamanuka, gira ayiji bilola. ");
INSERT INTO flr_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Neꞌri akabibona, anadeta: «Bano bandu, bali mulala muguma, banali mu deta indeto nguma, kyo kitumiri keera batondeera ukugira kwoku. Kiri na ngiisi bindi byo bagalooza ukugira, ndaabyo íbigaki bahangirira. ");
INSERT INTO flr_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Aaho! Mugirage tumanuke, gira tugendi shobania indeto yabo, halinde batakizi ki yuvwanwa.» ");
INSERT INTO flr_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Iri Nahano akagira kwokwo, balya bandu banaleka ukukayubaka, anayami bashabulira mu mahanga gooshi. ");
INSERT INTO flr_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Kyo kikatuma yako kaaya kakabuuzibwa Babeeri. Mukuba, haaho ho Nahano akashobaniza indeto yaꞌbandu booshi, anabashabulira hooshi mu mahanga. ");
INSERT INTO flr_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Abandu ba mu mbaga ya Sheemu, umwazi gwabo gwoguno: Gulya mwijulire, iri gukahisa imyaka ibiri gukamiri, Sheemu anaba akola neꞌmyaka igana, anabuta Haripakisadi. ");
INSERT INTO flr_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Neꞌri akamúbuta, anashubi lama igindi myaka magana gataanu. Anashubi buta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Haripakisadi, iri akaba akola neꞌmyaka makumi gashatu niꞌtaanu, anabuta Sheela. ");
INSERT INTO flr_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Neꞌri akamúbuta, anashubi lama igindi myaka magana gana niꞌshatu. Anashubi buta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sheela, iri akaba akola neꞌmyaka makumi gashatu, anabuta Hebeeri. ");
INSERT INTO flr_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Neꞌri akamúbuta, analama igindi myaka magana gana niꞌshatu. Anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Hebeeri, iri akaba akola neꞌmyaka makumi gashatu niꞌna, anabuta Peregi. ");
INSERT INTO flr_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Neꞌri akamúbuta, anashubi lama igindi myaka magana gana na makumi gashatu. Anabuta abandi baana boꞌbutabana, na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peregi, iri akaba akola neꞌmyaka makumi gashatu, anabuta Reehu. ");
INSERT INTO flr_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Neꞌri akamúbuta, anashubi lama igindi myaka magana gabiri na mwenda. Anabuta abandi baana boꞌbutabana na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reehu, iri akaba akola neꞌmyaka makumi gashatu niꞌbiri, anabuta Serugi. ");
INSERT INTO flr_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Neꞌri akamúbuta, anashubi lama igindi myaka magana gabiri niꞌrinda. Anabuta abandi baana boꞌbutabana na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugi, iri akaba akola neꞌmyaka makumi gashatu, anabuta Nahoori. ");
INSERT INTO flr_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Neꞌri akamúbuta, anashubi lama igindi myaka magana gabiri. Anabuta abandi baana boꞌbutabana na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahoori, iri akaba akola neꞌmyaka makumi gabiri na mwenda, anabuta Teera. ");
INSERT INTO flr_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Neꞌri akamúbuta, anashubi lama igindi myaka igana niꞌkumi na mwenda. Anabuta abandi baana boꞌbutabana na boꞌbunyere. ");
INSERT INTO flr_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Teera, iri akaba akola neꞌmyaka makumi galinda, anabuta Hiburamu, na Nahoori, na Harani. ");
INSERT INTO flr_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Abandu ba mu mbaga ya Teera, umwazi gwabo gwoguno: Teera ye kabuta Hiburamu, na Nahoori, na Harani. Harani naye, anabuta Luutu. ");
INSERT INTO flr_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Uyo Harani, akafwira i Huuri, mu kihugo kyaꞌBakalidaayo, munali mwo akabutirwa. Ku yikyo kyanya, yishe Teera âli ki riiri ho. ");
INSERT INTO flr_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Uyo Harani, akasiga abanyere babiri, Mirika na Hisika. Nahoori na Hiburamu, bombi banayanga. Nahoori anayanga uyo Mirika munyere wa mwene wabo. Hiburamu naye, anayanga Sarayi. ");
INSERT INTO flr_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Halikago, Sarayi atanabuta, bwo âli gumbiri. ");
INSERT INTO flr_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Teera anayabiira mugala wage wa Hiburamu, na mwali-kazi wage wa Sarayi, muka Hiburamu, na mwijukulu wage wa Luutu mugala Harani. Kwo bali booshi, banalyoka i Huuri, mu kihugo kyaꞌBakalidaayo, banashokola injira, halinde mu kihugo kyeꞌKaanani. Haliko, iri bakahika mu poroveesi yeꞌHarani, banatee beera mwo. ");
INSERT INTO flr_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ikyanya bâli ki riiri i Harani, Teera anaba akoli hiiti imyaka magana gabiri niꞌtaanu, anafwira yo. ");
INSERT INTO flr_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Nahano anabwira Hiburamu kwokuno: «Ushaagage mu kino kihugo kyawe. Usige mwaꞌbandu bo muyimbanwa umulala, naꞌba mu mbaga ya yisho, unagende mu kihugo kyo ngakuyereka. ");
INSERT INTO flr_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ngakugira ubaagage mulala úguhimbiri, na ngizi kugashaanira. Iziina lyawe, ngakizi lilumbuusa. Hiꞌgulu lyawe, ngakizi gashaanira kiri naꞌbandi. ");
INSERT INTO flr_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ngiisi ábagakizi kugashaanira, naani ngakizi bagashaanira. Haliko, ngiisi ábagakizi kudaaka, naani ngakizi badaaka. Hiꞌgulu lyawe, imilala yoshi mu kihugo igagashaanirwa.» ");
INSERT INTO flr_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ikyanya Nahano akabwira Hiburamu kwokwo, analyoka i Harani, na Luutu anamúyibiika kwo. Ku yikyo kyanya, Hiburamu âli kola neꞌmyaka makumi galinda niꞌtaanu. ");
INSERT INTO flr_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Kwokwo, Hiburamu anayabiira mukaage Sarayi, na Luutu mugala wa mwene wabo Harani. Anayabiira naꞌbaja baage bo akagula iyo munda i Harani, neꞌbindu byoshi byo akalonga yo. Yibyo byoshi, anabigendana mu kihugo kyeꞌKaanani. Iri Hiburamu neꞌyo mbaga yage bakahika i Kaanani, ");
INSERT INTO flr_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","banakizi lenga mwo, halinde banahika ha ngaaja-malungu yeꞌkiti kyeꞌMoore, hoofi naꞌkaaya keꞌShekemu. Ku yikyo kyanya, Abakaanani bo bâli riiri beene ikihugo. ");
INSERT INTO flr_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Iri Hiburamu akaba akolaga yaho, Nahano anamúhulukira kwo, anamúbwira: «Kino kihugo, ngakiheereza abandu ba mwiꞌkondo lyawe.» Uyo Hiburamu, mbu ayuvwe kwokwo, anayami yubakira Nahano akatanda koꞌkusiriigiza kwaꞌmatuulo. ");
INSERT INTO flr_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ha nyuma, Hiburamu analyoka yaho, anateramira mu mbande za mu migazi, uluhande lweꞌsheere lweꞌBeteeri. Anashinga iheema lyage ha kati kaꞌkaaya Beteeri, ákali uluhande lweꞌmuga, naꞌkeꞌHayi, ákali ulweꞌsheere. Iyo munda nayo, anashubi yubakira Nahano yaꞌkandi katanda koꞌkusiriigiza kwaꞌmatuulo, iri anamúyivuga. ");
INSERT INTO flr_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Iri hakatama, Hiburamu anashubi shokola injira yoꞌkumanukira mu mbande zeꞌNegebu. ");
INSERT INTO flr_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ku yikyo kyanya, mu kihugo kyeꞌKaanani, mwanagunuuza umwena mukayu. Kyanatuma Hiburamu agashokola injira yoꞌkumanukira mu kihugo kyeꞌMiisiri, gira atee gendi shumbika yo. ");
INSERT INTO flr_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Neꞌri akaba akola bu yegeera i Miisiri, anabwira mukaage Sarayi, ti: «E mukaanie, mbwinagi kwo unonosiri bweneene. ");
INSERT INTO flr_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Aaho! Mango Abamiisiri bakubona, bagaadeta: “Mukaage uyu.” Banayami nyita. Si wehe, banakuleke. ");
INSERT INTO flr_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ku yukwo, ukababwire kwo uli mwali wani, gira lyo bakangirire amiija hiꞌgulu lyawe, na mbe nalonga ukukira.» ");
INSERT INTO flr_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Hiburamu, ikyanya akahika i Miisiri, abatuulaga baayo banabona kwo Sarayi anonosiri ngana. ");
INSERT INTO flr_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Abambali ba Faraho nabo, mbu bamúbonage, banayami gendi múhuuza imunda Faraho, anatuma kwo bagendi múleetera ye. Ikyanya Sarayi akatwalwa i bwami, ");
INSERT INTO flr_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","mwami weꞌMiisiri anagirira Hiburamu amiija hiꞌgulu lya mukaage. Anamúheereza ibibuzi, neꞌmbene, neꞌngaavu, na bapunda, inviizi naꞌmabuguma, neꞌngamiya, kiri naꞌbaja, naꞌbaja-kazi. ");
INSERT INTO flr_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kundu kwokwo, Sarayi âli ki riiri muka Hiburamu. Neꞌkyanya akatwalwa imunda Faraho, yayebe! Nahano anayami lwaza Faraho, naꞌbandu booshi ba mu kajumiro. ");
INSERT INTO flr_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kyanatuma Faraho agatumira Hiburamu. Neꞌri akahika, anamúbuuza: «Makagi gano wagira? Kituma kiki utakambwira kwo Sarayi ali mukaawe? ");
INSERT INTO flr_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Si ukandeba, mbu ali mwali wawe! Kyanatuma ndaloozi múyanga. Lola, mukaawe uyu! Muyami njagiraga yaha.» ");
INSERT INTO flr_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Faraho anayami kyula kwaꞌbandu baage bashendekeze Hiburamu, bo na mukaage, kiri neꞌbindu byoshi byo âli hiiti. ");
INSERT INTO flr_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hiburamu anashaaga i Miisiri, bo na mukaage, neꞌbindu byabo byoshi, banashubi galukira i Negebu. Na Luutu, anagenderera ukumúyibiika kwo. ");
INSERT INTO flr_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Hiburamu âli kola neꞌbitugwa bingi bweneene, kiri neꞌnooro nyingi, neꞌharija. Âli kola mugale bweneene. ");
INSERT INTO flr_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Hiburamu analyoka yaho i Negebu, anakizi genda ali mu sheguula, halinde mu kaaya keꞌBeteeri. Anahika haahalya ho âli shiiziri iheema lyage, ha kati keꞌBeteeri neꞌHayi. ");
INSERT INTO flr_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Hanali hâli mali gwanwa ayubakira Nahano akatanda koꞌkusiriigiza kwaꞌmatuulo, iri anamúyikumba. ");
INSERT INTO flr_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Luutu na Hiburamu, bâli kizi gendanwa. Uyo Luutu naye, âli koli hiiti inguuli zeꞌbibuzi, na zeꞌmbene, na zeꞌngaavu. Anâli koli hiiti naꞌmaheema mingi. ");
INSERT INTO flr_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Emwe! Ibindu byabo, kâli kola kandaharuurwa, halinde bitanaki ziga kwo bashumbike kuguma. Kiri neꞌndagiriro zâli mali niiha. ");
INSERT INTO flr_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Iri hakatama, imbamba zanavyuka ha kati kaꞌbangere ba Hiburamu naꞌba Luutu. (Ku yikyo kyanya, Abakaanani naꞌBapereesi, bo bâli riiri batuulaga ba mu yikyo kihugo.) ");
INSERT INTO flr_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Iyo mbamba, yanatuma Hiburamu agabwira Luutu: «Si twembi twe baguma! Bitanakwiriiri kwo habe imbamba ha kati kiitu, kandi iri ha kati kaꞌbangere biitu. ");
INSERT INTO flr_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Langiiza imbere lyawe, kweꞌkihugo kiyajabusiri. Aahago! Leka tuyihandulane kwo. Iri wangagenda ilumosho, niehe ngagenda ilulyo. Kandi iri wagenda ilulyo, niehe ngagenda ilumosho.» ");
INSERT INTO flr_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Luutu, analangiiza-langiiza yizo mbande zooshi. Neꞌri akalangiiza indekeera yoshi ya ku lwiji Yorodaani, anabona kwo yâli kizi nywisibwa, nga kwokulya kweꞌndalo ya Nahano. Yanâli riiri ngeꞌkihugo kyeꞌMiisiri, mu mbande za mu kaaya keꞌSowari. (Yibyo, bikakoleka ku kyanya Nahano atâli zaazi shereeza akaaya keꞌSoodoma naꞌkeꞌGomora.) ");
INSERT INTO flr_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kwokwo, Luutu anayitoolera indekeera yoshi ya ku lwiji Yorodaani, uluhande lweꞌsheere, hanaba ho agagendi shumbika. Ikyanya yabo bombi bakayihandulana kwo, ");
INSERT INTO flr_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Hiburamu anasigala mu kihugo kyeꞌKaanani. Haliko, Luutu yehe, anagendi tuula hoofi noꞌtwaya twa mwiꞌyo ndekeera, anashinga iheema lyage ha butambi lyaꞌkaaya keꞌSoodoma. ");
INSERT INTO flr_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Neꞌyo munda i Soodoma, abandu baayo bâli riiri banangora-mabi, banâli koli bihuusiri bweneene imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Iri Luutu akaba keera ayishaaza ku Hiburamu, Nahano anayiji bwira Hiburamu kwokuno: «Yinamula amasu, unalangiize imbande zooshi. ");
INSERT INTO flr_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Yaga malambo gooshi go ubwinagi, ngamùheereza go lwoshi-lwoshi. Ngagaheereza kiri neꞌkibusi kyawe íkigaki yija. ");
INSERT INTO flr_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Aba mu kibusi kyawe, ngabaluza, babe kandaharuurwa nga luvu kwiꞌdaho. Nga kwoꞌlukungu kwiꞌdaho lutangaharuurwa, kwo nabo bâye be kandaharuurwa. ");
INSERT INTO flr_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ku yukwo, uyimukage! Ugende ugalenga-lenga mu mbande zooshi za mu kino kihugo, bwo kyo ngakuheereza.» ");
INSERT INTO flr_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kwokwo, Hiburamu anashinguula amaheema gaage, anagendi tuula i Heburooni, hoofi neꞌngaaja-malungu zeꞌbiti byeꞌMamure. Neꞌri akahika ho, anahayubakira Nahano akatanda koꞌkusiriigiza kwaꞌmatuulo. ");
INSERT INTO flr_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ku kyekyo kyanya, mwami Hamuraferi weꞌShinaari, na mwami Haryoki weꞌHelasaari, na mwami Kedorilahomeeri weꞌHelamu, na mwami Tidaali weꞌGohimu, ");
INSERT INTO flr_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","yabo baami kwo bali bana, bakagendi lwisa Beera mwami weꞌSoodoma, na Birisha mwami weꞌGomora, na Shinaabu mwami weꞌHadima, na Shemebeeri mwami weꞌSeboyimu, na mwami weꞌBeela (kuli kudeta: Sowari). ");
INSERT INTO flr_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Yabo baami booshi kwo bali bataanu, bakabiika abasirikaani baabo kuguma, banayiji balunda mu ndekeera yeꞌSidimu (kuli kudeta: Nyaaja yoꞌMuunyu). ");
INSERT INTO flr_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Yabo baami, mwami Kedorilahomeeri âli bakandamiiri, halinde ukuhisa ku myaka ikumi niꞌbiri. Haliko, ku mwaka úgugira ikumi niꞌshatu, banamúyihindulira. ");
INSERT INTO flr_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Mu mwaka gwiꞌkumi niꞌna, uyo mwami Kedorilahomeeri, naꞌbaabo ábakamútabaala, banagendi teera Abarefahimu iyo munda i Hashitereeti-Karinahimu, naꞌBazuuzi i Haamu, naꞌBahemi i Sawe-Kiryatayimu, banabahima booshi. ");
INSERT INTO flr_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Banahima kwakundi naꞌBahoori, ku migazi yeꞌSeyiri, halinde i Heriparaani, ku lubibi lwiꞌshamba. ");
INSERT INTO flr_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ha nyuma, banagaluka, banahika i Henimishipati (kuli kudeta: i Kadeeshi). Banagwata ikihugo kyoshi kyaꞌBahamareki, neꞌkyaꞌBahamoori, ábâli tuuziri i Hasasoni-Tamaari. ");
INSERT INTO flr_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Haaho, ulya mwami weꞌSoodoma, na weꞌGomora, na weꞌHadima, na weꞌSeboyimu, na weꞌBeela (kuli kudeta: Sowari), banayitundira mu ndekeera yeꞌSidimu, ");
INSERT INTO flr_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","banalwisa Kedorilahomeeri mwami weꞌHelamu, na Tidaali mwami weꞌGohimu, na Hamuraferi mwami weꞌShinaari, na Haryoki mwami weꞌHelasaari. Yabo baami kwo bali bana, bo bakateerwa na yabo baabo bataanu. ");
INSERT INTO flr_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Iyo ndekeera yeꞌSidimu, yâli yijwiri mwaꞌmahya ágâli mwaꞌkabulimbo. Kwokwo, ikyanya mwami weꞌSoodoma na weꞌGomora bakapuumuka, baguma baabo, banagayilasha mwo. Abandi banapuumukira mu migazi. ");
INSERT INTO flr_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Lyeryo, balya baami bana ábakahima, banashahula ibindu byoshi bya mu kaaya keꞌSoodoma na mu keꞌGomora, banatwala neꞌbihinda byeꞌbyokulya. ");
INSERT INTO flr_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Banatwala kiri na Luutu, mugala wa mwene wabo Hiburamu, na birya bindu byage byoshi, bwo naye âli tuuziri yaho i Soodoma. ");
INSERT INTO flr_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Mu yiryo izibo, mundu muguma naaho ye kafuuka, anagendi menyeesa Hiburamu umwazi. (Ku yikyo kyanya, Umuheburaniya Hiburamu âli koli tuuziri hoofi neꞌngaaja-malungu zeꞌbiti bya Mamure, Umuhamoori. Mamure âli riiri mwene wabo na Heshikooli, na Haneeri. Yabo kwo bali bashatu, bâli yibiisiri ku Hiburamu.) ");
INSERT INTO flr_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ikyanya Hiburamu akayuvwa kwoꞌmwana wa mwene wabo atwalwa imbohe, anayimuka naꞌbashosi ba mu nyumba yage. Bâli hisiri magana gashatu niꞌkumi na munaana, na booshi bâli riiri ndwani. Banagenda balandiriziizi yabo bagoma, halinde banahika mu kaaya keꞌDaani. ");
INSERT INTO flr_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Neꞌri bakayirirwa, Hiburamu anagabura abandu baage mweꞌbiso-biso. Lyeryo, banayami teera abagoma, mu kubatubiira, anabahima. Anabapuumuka kwo, halinde i Hoba, uluhande lweꞌmbembe lweꞌDamasiki. ");
INSERT INTO flr_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Irya minyago yoshi, Hiburamu anagifuusa. Anafuusa noꞌyo Luutu, umwana wa mwene wabo, neꞌbindu byage byoshi, kiri naꞌbakazi, naꞌbandi bandu. ");
INSERT INTO flr_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ikyanya Hiburamu akaba keera ahima umwami Kedorilahomeeri, naꞌbaabo baami ábakamútabaala, anagaluka. Mwami weꞌSoodoma anagendi músanganira mu ndekeera yeꞌSawe (kuli kudeta: mu ndekeera ya Mwami). ");
INSERT INTO flr_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Haaho, hanayija Merikisedeeki, mwami weꞌSaleemu, âli mugingi wa Rurema úli hiꞌgulu lya byoshi. Uyo Merikisedeeki, analeeta umukate neꞌdivaayi, ");
INSERT INTO flr_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","anagashaanira Hiburamu kwokuno: «Rurema úli hiꞌgulu lya byoshi, ye kalema igulu neꞌkihugo. Kwokwo, akizi kugashaanira. ");
INSERT INTO flr_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Na bwo ali hiꞌgulu lya byoshi, akizi huuzibwa. Mukuba, ye wabiika abagoma baawe mu maboko gaawe.» Hiburamu anayabiira ku bindu byo akafuusa, anaheereza Merikisedeeki ikihande kiꞌkumi kyabyo. ");
INSERT INTO flr_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mwami weꞌSoodoma, anabwira Hiburamu: «Yibi bindu byoshi, ubibeerane. Yaba bandu baani, babe bo ugambeereza naaho.» ");
INSERT INTO flr_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Halikago, Hiburamu anamúshuvya: «Keera nabiika indahiro imbere lya Nahano Rurema, ulya úkalema igulu neꞌkihugo, anali hiꞌgulu lya byoshi. ");
INSERT INTO flr_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Kwokwo, ndaakyo kindu kyawe kyo ngayabiira, kundu yangaba nuzi naaho, kandi iri higozi hyoꞌkushweka ibiraato. Mukuba ndaloziizi kwo ulongage ukukizi yihaya kwo we kangaza. ");
INSERT INTO flr_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kwokwo, ndaakyo kindu kyo ngayabiira. Ngeeka naaho, ngiisi byeꞌyi misore yani ikalya, noꞌmutuli gwa yaba bo tushubanwa: Haneeri, na Heshikooli, na Mamure. Baabo naaho, bo bagahaabwa ngiisi íbibakwaniini.» ");
INSERT INTO flr_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Ha nyuma, Nahano anayijira Hiburamu mu mabone, anamúbwira kwokuno: «E Hiburamu, utakizi yoboha. Nie siribo yawe. Na byo ngakuhemba, biri tiita.» ");
INSERT INTO flr_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kundu Rurema akadeta kwokwo, haliko Hiburamu anamúbuuza: «E Rurema Nahamwitu, iyo mbembo yawe, bikagi byo igangirira, ndanagweti mwana? Si Heryezeeri ye gayiji mbyana, anali kinyamahanga kyeꞌDamasiki. ");
INSERT INTO flr_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Bwo ndaalyo ibuta lyo ukambeereza, byaboneka kwoꞌmukozi úwabutirwa mu nyumba yani, ye kola úgayiji mbyana.» ");
INSERT INTO flr_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Nahano, ti: «Nanga! Uyo mundu, atali ye gakuhyana. Si umwana ye ugayibutira, yeki ye gayiji kuhyana.» ");
INSERT INTO flr_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Rurema anahulukiza Hiburamu ha mbuga, anamúbwira: «Legamira kwiꞌgulu. Uharuure indonde íziri kwo, iri wangahasha. Kwoku kwaꞌbandu beꞌkibusi kyawe bagaaba kandaharuurwa.» ");
INSERT INTO flr_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Birya byo Rurema akabwira Hiburamu, Hiburamu anabiyemeera, kyanatuma Nahano agamúharuura kwo akoli kwaniini imbere lyage. ");
INSERT INTO flr_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Rurema anashubi múbwira: «Niehe, nie Nahano. Nie kakulyosa i Huuri, mu kihugo kyaꞌBakalidaayo, gira nguheereze kino kihugo, bube buhyane bwawe.» ");
INSERT INTO flr_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Hiburamu, ti: «E Nahano Rurema, kino kihugo, kutagi kwo ngaamenya akasiisa kwo nie gayiji kihyana?» ");
INSERT INTO flr_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Nahano anamúshuvya: «Undeeterage inyana, neꞌshaashi yeꞌmbene, neꞌkipanga. Byoshi, bibe byeꞌmyaka ishatu-ishatu. Undeetere niꞌhumba, neꞌkyana kyeꞌngunde.» ");
INSERT INTO flr_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Yibyo byoshi, Hiburamu anamúleetera byo. Ngiisi kiguma, anakizi kibunduula mwo kubiri. Anabitengeka mweꞌmiziizi ibiri, halinde byanakizi lolana. Haliko, utunyuni twohe, atakatubera mwo kubiri. ");
INSERT INTO flr_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Iyo mitumba yoshi, banyunda banakizi yiji gira mbu bagiyivwime kwo, haliko, Hiburamu anakizi bayimula. ");
INSERT INTO flr_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Izuuba, iri likaba likola ligasooka, Hiburamu ngana, iro lyanamúlemba. Ikihulu kya namudidi, kyanamúyizingira kwo, anatondeera ukuyoboha. ");
INSERT INTO flr_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Nahano anamúbwira: «Umenyage ku kasiisa, kwaꞌbandu beꞌkibusi kyawe bagagendi shumbika mu kihugo kyeꞌmahanga. Banabe baja, banahise yeꞌmyaka magana gana bagweti bagalibuzibwa bweneene. ");
INSERT INTO flr_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Na kundu basheebuja baabo bangabakoleesa ku kahaati, haliko ku mbeka ngabahana. Ha nyuma, abandu baawe banalyoke mwo, bakola naꞌkanyamwala keꞌbindu. ");
INSERT INTO flr_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","«Wehe, ugaalama imyaka mingi, ukabuli gwana bashokuluza baawe mu kati koꞌmutuula, unaziikwe. ");
INSERT INTO flr_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Abandu ba mwiꞌkondo lyawe, ngayiji bagalulira mu kino kihugo, ku kibusi kyabo kya kana. Mukuba, amabi gaꞌBahamoori gatazi leeza ulugero. Ndangalunguli bayimula mwo.» ");
INSERT INTO flr_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Izuuba, iri likaba keera lyasooka, neꞌkihulu kyanaba kikoli yidisiri, hanaboneka ikirugu íkiri mwoꞌmuliro, neꞌkimole. Yibyo byombi, byanakizi shashaata-shashaata ha kati ka yizo nyama. ");
INSERT INTO flr_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ku lwolwo lusiku, Nahano ananywana ikihango bo na Hiburamu, anamúbwira: «Kino kihugo, ngakiheereza abandu ba mwiꞌkondo lyawe. Kigatondeerera ku lwiji úluli uluhande lweꞌsheere lweꞌkihugo kyeꞌMiisiri, halinde ukuhisa ku lwiji luhamu Hefuraati. ");
INSERT INTO flr_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Ngabaheereza kiri neꞌkihugo kyaꞌBakeeni, neꞌkyaꞌBakenezi, neꞌkyaꞌBakadimooni, ");
INSERT INTO flr_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","neꞌkyaꞌBahiti, neꞌkyaꞌBapereesi, neꞌkyaꞌBarefahimu, ");
INSERT INTO flr_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","neꞌkyaꞌBahamoori, neꞌkyaꞌBakaanani, neꞌkyaꞌBagirigaashi, neꞌkyaꞌBayebuusi.» ");
INSERT INTO flr_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ku yikyo kyanya, Sarayi, muka Hiburamu, atâli busiri. Anâli hiiti umuja-kazi weꞌMiisiri, iziina lyage Hagaari. ");
INSERT INTO flr_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Lusiku luguma, Sarayi anabwira Hiburamu: «E yibanie, ubwinagi kwo Nahano anyimiri ibuta. Aaho! Nakuyinginga we kongwa, ugendi laala imwoꞌyu muja-kazi Hagaari. Ngeeka nangakoli yubaka imbaga ku njira yage.» Lirya idoli lya Sarayi, Hiburamu analiyemeera. ");
INSERT INTO flr_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kwokwo Hiburamu, Sarayi anamúheereza umuja-kazi Hagaari, abe mukaage. Ku yikyo kyanya, Hiburamu âli mali hisa imyaka ikumi atuuziri mu kihugo kyeꞌKaanani. ");
INSERT INTO flr_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ikyanya Hiburamu akalaala imwoꞌyo Hagaari, Hagaari anaheeka inda. Neꞌri akamenya kwo akoli giheesiri, anatondeera ukukizi gayiriza nabuja. ");
INSERT INTO flr_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kyanatuma Sarayi agabwira Hiburamu: «Uyu muja-kazi, si nie kakuheereza ye. Halikago, bwo akoli heesiri inda, atakiri mu mbona kwo nie nabuja. Ngiisi mabi gooshi go ali mu ngirira, we koli gabetwiri. Kwokwo, twembi, Nahano ye gatuhambuula.» ");
INSERT INTO flr_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Hiburamu naye, ti: «Uyu muja-kazi, alyagagi mu maboko gaawe. Aaho! Ngiisi byo utoniri hiꞌgulu lyage, ubigire.» Ukushaagira ku lwolwo lusiku, Sarayi anakizi libuza Hagaari bweneene, halinde Hagaari anamútibita. ");
INSERT INTO flr_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Iri Hagaari akaba akola mwiꞌshamba, ha butambi lyaꞌkadota, umuganda wa Nahano anamúhulukira kwo. (Yako kadota, kâli riiri ku njira yoꞌkugenda i Shuuri.) ");
INSERT INTO flr_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Uyo muganda anamúbuuza: «E Hagaari, si ulyagagi muja-kazi wa Sarayi! Aaho! Hayi ho ulyosiri? Na hayi ho uli mu genda?» Hagaari, ti: «E nahamwitu, ngola mu tibita nyaama-buja Sarayi.» ");
INSERT INTO flr_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ulya muganda wa Nahano, ti: «Nanga! Galukira imunda nyoko-buja, unakizi músimbaha. ");
INSERT INTO flr_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Abandu ba mwiꞌkondo lyawe, ngabaluza bweneene, halinde babe kandaharuurwa.» ");
INSERT INTO flr_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ha nyuma, uyo muganda wa Nahano anashubi múbwira: «Lolaga! Iyo nda yo uhiiti, ugagibuta mwoꞌmwana woꞌbutabana. Uyo mwana, ugamúyinika iziina Hishimaheeri. Na bwo ukola mu lira hiꞌgulu lyaꞌmalibu, Nahano keera akakuyuvwa. ");
INSERT INTO flr_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Uyo Hishimaheeri, agaaba nga punda wa mu kishuka, halinde analwise ngiisi mundu. Na ngiisi mundu naye, agakizi múlwisa. Agayihandula ku beene wabo booshi, anagendi tuula yenyene.» ");
INSERT INTO flr_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Uyo Hagaari, ikyanya Nahano akamúganuuza kwokwo, anayidesa: «Si keera nabonaga Rurema, na ngiri ho.» Kyanatuma agamúyinika iziina: «Wehe, we mbwini.» ");
INSERT INTO flr_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Kwokwo, ha kati keꞌKadeeshi neꞌBereedi hatuula ikirigo íkiri mu buuzibwa Lahayi-Rohi, (kuli kudeta: kirigo kyoꞌlya útuula ho, anali mu mbona). ");
INSERT INTO flr_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Iri hakatama, Hagaari anabutira Hiburamu umwana woꞌbutabana. Hiburamu anamúyinika iziina Hishimaheeri. ");
INSERT INTO flr_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Neꞌkyanya Hagaari akabuta, Hiburamu âli kola neꞌmyaka makumi galimunaana na ndatu. ");
INSERT INTO flr_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Hiburamu, ikyanya akahisagya imyaka makumi galimwenda na mwenda, Nahano anashubi múhulukira kwo, anamúbwira: «E Hiburamu, nie Rurema woꞌbushobozi bwoshi. Aaho! Ukizi nzimbaha, iri unakizi yama utungiini imbere lyani. ");
INSERT INTO flr_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Naani, nganywana ikihango na naawe, ninaluze abandu ba mwiꞌkondo lyawe.» ");
INSERT INTO flr_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Ikyanya Hiburamu akayuvwa kwokwo, anayami fukama, anahisa amalanga haashi, mu kusimbaha Rurema. Rurema anashubi múbwira: ");
INSERT INTO flr_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Yikyo kihango kyo nanywana na naawe, kyo kyekino: Ukola ugaaba yishe weꞌmilala mingi. ");
INSERT INTO flr_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Na bwo ugaaba yishe wayo, ukulyokera zeene, utagaki buuzibwa Hiburamu, (kuli kudeta: daata woꞌkuhuuzibwa). Si ukola ugakizi buuzibwa Hiburahimu, (kuli kudeta: yishe weꞌmilala mingi). ");
INSERT INTO flr_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kwokwo, ngakuheereza ibuta, mwiꞌkondo lyawe, munalyoke imilala mingi, kiri naꞌbaami. ");
INSERT INTO flr_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","«Yiki kihango kyo ngola mu nywana na naawe, ngakinywana kiri naꞌbandu ba mwiꞌkondo lyawe, halinde ku bibusi byabo byoshi íbyâye ki yije, halinde imyaka neꞌmyakuula. Ngaaba Rurema wawe wenyene, kiri na waꞌbandu ba mwiꞌkondo lyawe. ");
INSERT INTO flr_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","«Kino kihugo kyeꞌKaanani, kundu ukituuziri mwo nga kinyamahanga, ngamùheereza kyo, mwe naꞌbandu ba mwiꞌkondo lyawe. Kino kihugo kyoshi kigaaba kyeꞌmwinyu, halinde imyaka neꞌmyakuula, na nyame ndi Rurema winyu.» ");
INSERT INTO flr_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ha nyuma, Rurema anashubi bwira Hiburahimu: «Kino kihango kyani, ukizi kisimbaha. Kiri naꞌbandu ba mwiꞌkondo lyawe, nabo bakizi kisimbaha, halinde ku bibusi byabo byoshi. ");
INSERT INTO flr_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Mwehe mweshi, kwokuno kwo mukwaniini mukizi nzimbaha: Ngiisi úyimbwa mushosi mu kati kiinyu, akwiriiri akizi tenguulwa. ");
INSERT INTO flr_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kwokwo, mu kukerwa ikikoba, lyo mugakizi yerekana ikihango kyo twanywana. ");
INSERT INTO flr_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","«Kwokwo, ngiisi mwana mwanuke woꞌbutabana, ikyanya agaaba ahisagya isiku munaana, mukizi mútenguula. Munakizi tenguula na ngiisi batabana baꞌbaja ábakabutirwa mu nyumba ziinyu. Kiri naꞌbaja bo mukagula i mahanga, nabo mubatenguule. Yako kalangikizo ko mugaagira ku myego yinyu, kagayerekana ikihango kyani kyeꞌmyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ngiisi mushosi úgalahira ukutenguulwa, agaaba keera ahongola ikihango kyani. Umundu mwene uyo, akwaniini atwibwe mu kati kiinyu.» ");
INSERT INTO flr_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Rurema anashubi bwira Hiburahimu, ti: «Ku luhande lwa mukaawe Sarayi, ukulyokera zeene, naye atagaki detwa Sarayi. Si akola agakizi detwa Saara. ");
INSERT INTO flr_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Uyo Saara, ngamúgashaanira, anakubutire umwana woꞌbutabana. Kwokwo, lyo agaaba nyina weꞌmilala mingi. Mu nda yage, mwo mugalyoka kiri naꞌbaami beꞌmahanga.» ");
INSERT INTO flr_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Lyeryo, Hiburahimu anafukama, anahisa amalanga haashi, anayidesa, ti: «Ka naani nangaki buta, nie mushaaja weꞌmyaka igana? Kiri na Saara naye, ka angaki hisa umwana haashi? Si akola mugiikulu weꞌmyaka makumi galimwenda!» ");
INSERT INTO flr_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Anadeta: «E Nahano, nga byangaziga, Hishimaheeri abe ye yamiri agashaniirwi.» ");
INSERT INTO flr_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Na wa Rurema, ti: «Nanga! Mukaawe Saara agaki kubutira umwana woꞌbutabana. Niꞌziina lyage, ye gaaba Hisake, (kuli kudeta: ayishesa). Uyo Hisake, ye gayiji kwiza ikihango kyani, imwaꞌbandu ba mwiꞌkondo lyage. Na yikyo kihango, kigaaba kyeꞌmyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","«Na ku luhande lwa Hishimaheeri, keera nayuvwa amahuuno gaawe hiꞌgulu lyage. Naye kwakundi, ngamúgashaanira, anabute abaana bingi. Yabo baana, ngabaluza. Hishimaheeri ye gayiji ba yishe waꞌbatwali ikumi na babiri, anayiji ba shokuluza woꞌmulala úguhimbiri. ");
INSERT INTO flr_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","«Si ikihango kyani kyohe, kigaaba ku Hisake naaho. Noꞌyo Hisake, Saara agakubutira ye, mu kyanya íkiri nga kyekino, ku gundi mwaka.» ");
INSERT INTO flr_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ikyanya Rurema akayusa ukuganuuza Hiburahimu, anamúsiga yaho. ");
INSERT INTO flr_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Hiburahimu anayami gendi yabiira mugala wage wa Hishimaheeri, naꞌbaja booshi ábakabutirwa mu nyumba yage, kiri na ngiisi bo akagula i mahanga. Yabo booshi, anabatenguula ku lwolwo lusiku, nga kwo Rurema akamúbwira. ");
INSERT INTO flr_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Hiburahimu, ikyanya akatenguulwa, âli kola neꞌmyaka makumi galimwenda na mwenda. ");
INSERT INTO flr_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Hishimaheeri naye, âli kola neꞌmyaka ikumi niꞌshatu. ");
INSERT INTO flr_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Hiburahimu, bo na mugala wage wa Hishimaheeri, bakatenguulwa ku lwolwo lusiku, ");
INSERT INTO flr_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","naꞌbashosi booshi ábakabutirwa mu nyumba yage, na ngiisi bo akagula i mahanga. ");
INSERT INTO flr_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Nahano anahulukira ku Hiburahimu, hoofi neꞌngaaja-malungu zeꞌbiti i Mamure. Ku kyanya kyaꞌkalenge-renge, Hiburahimu âli bwatiiri ha mulyango gwiꞌheema lyage. ");
INSERT INTO flr_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Masaasa atabukwa, iri akayinamula amasu, anabona abandu bashatu, bakoli yimaaziri yaho. Kyanatuma agayimuka, anakwabadukira imunda bali, gira agendi basanganira. Neꞌri akahika ho, anayinama ku lushaagwa, ");
INSERT INTO flr_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","anadeta: «E Banahamwitu, nie mukozi winyu, namùyinginga, mutambambale. ");
INSERT INTO flr_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ngatee mùkaraba ku magulu, mukabuli luhuuka mwiꞌdako lyeꞌkiti. ");
INSERT INTO flr_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Si ndi mukozi winyu! Na bwo mwalenga hoofi na ha mwani, mwangatee luhuuka. Muleke ndee mùkolera ibyokulya, gira mushaluuke, halinde lyo mulonga imisi yoꞌkugenderera noꞌlugeezi lwinyu.» Nabo, ti: «Bwija! Ngiisi byo wadeta, tee bigirage.» ");
INSERT INTO flr_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Hiburahimu anakwabadukira mwiꞌheema, anabwira mukaage: «E Saara, banguka, uyabiire indaala zishatu zoꞌmushyano mwija, ugukande, unaguyokye mweꞌbitumbula.» ");
INSERT INTO flr_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Anashubi kwabadukira áhali ingaavu zaage, anatoola mweꞌnyana ídehiri. Anagisikiiriza umukozi wage muguma. Uyo mukozi duba-duba ngana, anagibaaga, anagideeka. ");
INSERT INTO flr_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Iri ikahya, Hiburahimu anayabiira amakaavwe, naꞌmata, na zirya nyama, anabizimaana abageezi. Ku kyanya bakaba bakola mu lya, Hiburahimu anayimanga ha butambi lyabo, mwiꞌdako lyeꞌkiti. ");
INSERT INTO flr_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Yabo bageezi, banabuuza Hiburahimu: «E Hiburahimu, mukaawe Saara ali hayagi?» Hiburahimu, ti: «Ali yumu mwiꞌheema.» ");
INSERT INTO flr_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Muguma wabo, ti: «Ku kasiisa, ku kyanya íkiri nga kyekino, ku gundi mwaka, ngagwana mukaawe wa Saara akoli hiiti umwana woꞌbutabana.» Ku yikyo kyanya, Saara âli yimaaziri mwiꞌheema ha nyuma lyoꞌlwivi, ali mu bayuvwiriza. ");
INSERT INTO flr_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Hiburahimu bo na Saara, bâli kola bashaaja bweneene. Na Saara atâli kizi ki genda mu lwaꞌbakazi. ");
INSERT INTO flr_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kyanatuma Saara agayishesa, ti: «Si ngola mugiikulu! Kiri na yibanie, keera ashaaja. Aahago! Ka ngiri naꞌmarara ga mushosi?» ");
INSERT INTO flr_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Nahano anabuuza Hiburahimu: «Kituma kikagi Saara asheka, iri anayibuuza: “Kaꞌkasiisa, kwo nangaki buta mu buno bugiikulu bwani?”» ");
INSERT INTO flr_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Nahano anashubi deta: «Aahago! Ka hali igambo íritashobokiini imwa Nahano? Si ndaalyo! Kwokwo, ikyanya ngagaluka ku kyanya íkiri nga kino, ku gundi mwaka, Saara agaaba akoli hiiti umwana woꞌbutabana.» ");
INSERT INTO flr_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Uyo Saara, anayoboha, kyanatuma agabeesha, ti: «E waliha, ndasheka.» Nahano anamúbeshuuza, ti: «Kundu walahira, si washeka.» ");
INSERT INTO flr_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Yabo bandu, ikyanya bâli kola bagalyoka yaho, Hiburahimu anabaherekeza. Neꞌri bakahika ho bâli kola mu langiiza akaaya keꞌSoodoma, ");
INSERT INTO flr_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nahano anayisaliza, ti: «Ka mbishe Hiburahimu byo njungisiri? ");
INSERT INTO flr_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Si ye gaaba yishe woꞌmulala úguhimbiri, gunasikamiri. Hiꞌgulu lyage, imilala yoshi mu kihugo igagashaanirwa. ");
INSERT INTO flr_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nꞌgamútoola, gira akizi yigiriza abaana baage, naꞌba mwiꞌkondo lyage, bakizi simbaha imaaja zaani. Kwokwo, lyo baba bandu bemeera, banabe bali mu ngira íbikwaniini imbere lyani. Naani, na mbakwigize imihango yani.» ");
INSERT INTO flr_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Haaho, Nahano anadeta: «Nyuvwiti ikimombo mu kaaya keꞌSoodoma, na mu keꞌGomora. Mukuba, ibyaha byabo keera byaleeza ulugero bweneene. ");
INSERT INTO flr_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Na buno, ngola ngamanukira yo, gira ngendi yibonera iri yaga malira gakulikiriini neꞌmikolezi yabo. Kwokwo, lyo ngalonga ukumenya bwija.» ");
INSERT INTO flr_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kwokwo, mu yabo bageezi, babiri banashokola injira yoꞌkugenda i Soodoma. Haliko, Nahano, anasigala ayimaaziri bo na Hiburahimu. ");
INSERT INTO flr_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Iri hakatama, Hiburahimu anayegeera Nahano, anamúbuuza: «Mu bandu ábakwaniini na ábatakwaniini, ka biri ukuli, kwo ugayami basiviza haguma? ");
INSERT INTO flr_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","«Tudete nga mu kaaya mwangaboneka nga bandu makumi gataanu ábakwaniini. Hiꞌgulu lyabo, ka utagakejeerera akaaya kooshi, unaleke ukukashereeza? ");
INSERT INTO flr_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nanga! Utangayita ábakwaniini, na ábatakwaniini. Bitanganaziga kwo ábayimaaziri mu kuli, bahanirwe kuguma na banangora-mabi. Si we mutwi weꞌmaaja wa mu kihugo kyoshi, unali mu zitwa mu kati koꞌkuli.» ");
INSERT INTO flr_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Nahano anamúshuvya: «Mu kaaya keꞌSoodoma, iri nangagwana mwaꞌbandu makumi gataanu ábakwaniini, ngakejeerera akaaya kooshi hiꞌgulu lyabo.» ");
INSERT INTO flr_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Hiburahimu anashubi deta: «Ndi lukungu, na ndi munyota-kiiko. Kundu kwokwo, nayihangaana ukuganuuza Nahamwitu. ");
INSERT INTO flr_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","E Nahano, iri batangaki hika makumi gataanu, haliko munabonekage abandu makumi gana na bataanu ábakwaniini, ka ugashereeza yako kaaya, mbu bwo babula abandu bataanu?» Nahano naye, ti: «Nanga! Yako kaaya, iri mwangaboneka abandu makumi gana na bataanu ábakwaniini, ndangaki kashereeza.» ");
INSERT INTO flr_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Hiburahimu, ti: «Ngeeka mwangaboneka abandu makumi gana.» Nahano naye, ti: «Hiꞌgulu lya yabo bandu makumi gana ábakwaniini, ndangaki kashereeza.» ");
INSERT INTO flr_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Hiburahimu anamúyinginga, ti: «E Nahamwitu, utayagalwe. Namu shubi deta. Ngeeka mwangaboneka abandu makumi gashatu ábakwaniini.» Nahano, ti: «Mu yako kaaya, iri mwangaboneka abandu makumi gashatu ábakwaniini, ndangaki kashereeza.» ");
INSERT INTO flr_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Hiburahimu anashubi deta: «Ngiri mu yihangaana ukuganuuza Nahamwitu. Ngeeka mwangaboneka abandu makumi gabiri ábakwaniini?» Nahano, ti: «Mu yako kaaya, iri mwangaboneka abandu makumi gabiri ábakwaniini, ndangaki kashereeza.» ");
INSERT INTO flr_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Mu kuheza, Hiburahimu anadeta: «E Nahamwitu, nakuyinginga bweneene, utayagalwe. Ngola ngaadeta lindi liguma naaho. Ngeeka mwangaboneka abandu ikumi ábakwaniini. Aahago! Kuti kwo wangagira?» Nahano, ti: «Mu yako kaaya, iri mwangaboneka abandu ikumi ábakwaniini, ndangaki kashereeza.» ");
INSERT INTO flr_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Iri Nahano akayusa ukuganuuza Hiburahimu, anayigendera. Hiburahimu naye, anagalukira i kaaya. ");
INSERT INTO flr_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Iri hakaba kabigingwe, balya baganda babiri banayingira mu kaaya keꞌSoodoma, banagwana Luutu abwatiiri kwiꞌrembo lyako. Iri akabalangiiza, anayimuka, anagendi basanganira, anayinama mu kubalamusa ku lushaagwa. ");
INSERT INTO flr_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Anadeta: «E banahamwitu, nie mukozi winyu, muyegerere mu nyumba yani. Mutee leeza amiiji ku magulu, munalaale mwo. Shesheezi, munagendererage noꞌlugeezi.» Kundu Luutu akabayegereza, haliko banatee lahira, ti: «Tugalaala ha mbuga, ha kati ka kano kaaya.» ");
INSERT INTO flr_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Luutu anakizi bayinginga bweneene. Neꞌri hakatama, banayemeera, banayingira mu mwage. Luutu anabakolera ibyokulya, anayokya imikate mizira saama, anabazimaana, banasheega. ");
INSERT INTO flr_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Halikago, ku kyanya kyaꞌmiiza, abashosi booshi ba mu mbande zooshi zeꞌSoodoma, banasokanana inyumba ya Luutu, kutondeerera ku misore, halinde ku bashaaja. ");
INSERT INTO flr_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Yabo bashosi, banahamagala, ti: «E Luutu, balya bashosi ábayingira mu mwawe, balyagagi hayi? Ubahuluse! Tuloziizi tubashulehe.» ");
INSERT INTO flr_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Luutu anahuluka, anayami hamika ulwivi, ");
INSERT INTO flr_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","anababwira: «E badaata, mwe mukongwa! Yaba bandu, mutakolwe mbu mubakolere kweꞌbihigo. ");
INSERT INTO flr_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Lolagi! Mbiitagi banyere baani babiri hano, batazindi menyana naꞌbashosi. Aaho! Mumbanguule nimùheereze bo, mubagirire ngiisi kwo muloziizi. Haliko bano bashosi ábali muno, hatagirage ibala lyo mwangabahigulira kwo. Si nie bazatiiri!» ");
INSERT INTO flr_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Na wa nabo, ti: «Hafe, tuhinjuse! Si ulyagagi kinyamahanga. Aahago! Ka akola mu yigira mutwi weꞌmaaja? Bwobunago wehe, twamu kukolera kweꞌbikoleere, ukuhima ngiisi kwo tushuba tugaagira yabo bageezi baawe.» Lyeryo, banasindikira Luutu, banagira mbu bahambiri hongola ulwivi. ");
INSERT INTO flr_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Lyeryo ngana, balya bageezi banagolola amaboko, banayami bululira Luutu mu nyumba, banahamika ulwivi. ");
INSERT INTO flr_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Balya bashosi booshi, abakulu naꞌbaanuke, yabo baganda banabahumaaza, batanaki bone umulyango. ");
INSERT INTO flr_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Balya bandu babiri banabuuza: «E Luutu, ka uhiitagi ugundi mundu mu kano kaaya? Ngeeka muli bagala baawe, kandi iri banyere baawe, kandi iri bakwi baawe, kandi iri bandi bandu bo muyimbanwa kwo. Iri bangaba bali mwo, uvwaruke, ubahuluse duba. ");
INSERT INTO flr_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Si abandu ba mu kano kaaya, keera balegwa bweneene imbere lya Nahano. Yukwo kulegwa, akoli kuyuvwiti. Na buno, atutuma, mbu tuyiji kashereeza.» ");
INSERT INTO flr_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Uyo Luutu, âli naꞌbakwi, ábâli koli fundisiri banyere baage, anagendi bakengula, ti: «Nahano akola agashereeza kano kaaya. Mugire mukalyokage mwo duba.» Yikyo kitambira kya Luutu, iri bakakiyuvwa banakibona naaho nga kyaꞌmalyogo. ");
INSERT INTO flr_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Iri hakaba shesheezi kare-kare, balya baganda banashubi yinginga Luutu, ti: «Kano kaaya, si kagayiji hanwa. Aahago! Vwaruka, uyabiire mukaawe, na banyere baawe bombi, gira mutayiji shereezibwa.» ");
INSERT INTO flr_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kundu Luutu akavwebeeba, haliko Nahano anamúyuvwirwa indengeerwa. Balya baganda, banagwatira Luutu na mukaage ku maboko, na banyere baage bombi, banabatwala inyuma lyaꞌkaaya. ");
INSERT INTO flr_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Neꞌri bakaba bakola inyuma lyako, muganda muguma anababwira: «Mutibitage muyikize. Mutakebagane, hatanagire ho mugayimanga mwiꞌyi ndekeera. Si mutibitire mu migazi, mutayiji kengeera mwashereera.» ");
INSERT INTO flr_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Luutu, ti: «E Nahamwitu, we kongwa! ");
INSERT INTO flr_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ndi mukozi wawe. Keera nanalonga ulukogo imbere lyawe, halinde wangejeerera, wanangiza. Kundu kwokwo, imigazi iri hala bweneene. Hali ikyanya nangakengeera nashereezibwa mu njira, na nvwire mwo. ");
INSERT INTO flr_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Lolaga! Haliira, hali ihyaya hiniini, hyoꞌmundu angakirira mwo. Mumbanguule hibe hyo ngatibitira mwo.» ");
INSERT INTO flr_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Uyo muganda, ti: «Ee! Nayemeera. Yihyo hyaya hyo wadeta, ndagaki hishereeza. ");
INSERT INTO flr_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Haliko, uvwarukage, uhitibitire mwo. Ndangalunguli gira igambo lyoshi, índazi bona kwo wahihika mwo.» Kyanatuma yako kaaya kagabuuzibwa Sowari. ");
INSERT INTO flr_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ikyanya izuuba likaba keera lyahuluka, Luutu naye anaba keera ahika mu kaaya keꞌSowari. ");
INSERT INTO flr_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Lyeryo ngana mwiꞌgulu, Nahano anatibulira imbigi zoꞌmuliro mu kaaya keꞌSoodoma na mu keꞌGomora. ");
INSERT INTO flr_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Yutwo twaya twombi, anatujigiivya, neꞌndekeera yoshi, naꞌbatuulaga baamwo booshi, kiri neꞌmbuto zooshi. ");
INSERT INTO flr_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ku kyekyo kyanya, muka Luutu anakebagana, anayami hinduka mugina gwoꞌmuunyu. ");
INSERT INTO flr_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Iri bukakya shesheezi kare-kare, Hiburahimu anashubi gendi yimanga haahalya ho bâli yimaaziri na Nahano. ");
INSERT INTO flr_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Analangiiza uluhande lweꞌSoodoma neꞌGomora, na mu ndekeera yoshi. Anabona ikyusi kingi, kiri nga kya kiberekaana, kiri mu tuuma ku bwingi. ");
INSERT INTO flr_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Rurema, ikyanya akajigiivya yutwo twaya twa mu ndekeera, akakengeera Hiburahimu. Kiri na Luutu kwakundi, kundu âli tuuziri i Soodoma, haliko atanafwa. ");
INSERT INTO flr_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Luutu, âli yobohiri ukutuula mu kaaya keꞌSowari, kyanatuma agalyoka mwo, na banyere baage bombi, anagendi tuula mu migazi, mu lwala. ");
INSERT INTO flr_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Lusiku luguma, munyere wage woꞌlubere anabwira umuzibo: «Si daata keera ashaaja! Neꞌno munda twayiji tuula, ndaaye mushosi woꞌkutuyanga, nga kwo bali mu kizi gira ahandi hooshi. ");
INSERT INTO flr_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Aaho! Tulaluse daata, gira atugwejere. Kwokwo, lyo tulonga abaana, halinde ikibusi kiitu kilonge ukugenderera.» ");
INSERT INTO flr_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Mu bwobwo bushigi, ikyanya bakalalusagya yishe, ulya woꞌlubere anamenyana na yishe. Kundu kwokwo, yishe atakamenya ikyanya munyere wage akayiji gwejera, kandi iri ikyanya akahuluka. ");
INSERT INTO flr_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Neꞌri bukakya, uyo munyere woꞌlubere anashubi bwira mulumuna wage: «Bigingo bushigi, namenyana na daata. Aahago! Zeene tushubi múlalusa, gira naawe ugende akugwejere. Kwokwo, lyo tugalonga abaana. Na ku njira yage, ikibusi kiitu kinalonge ukugenderera.» ");
INSERT INTO flr_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mu bwobwo bushigi, ikyanya bakashubi lalusa yishe, ulya munyere woꞌmuzibo naye anagendi menyana na yishe. Kundu kwokwo, yishe atakamenya ikyanya uyo munyere wage akayiji gwejera, kandi iri ikyanya akahuluka. ");
INSERT INTO flr_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Balya banyere Luutu, bombi banaheeka inda. ");
INSERT INTO flr_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Ulya munyere wage woꞌlubere, anabuta umwana woꞌbutabana, anamúyinika iziina Mohabu (kuli kudeta: ye abuta na yishe). Yoyo, ye shokuluza waꞌBamohabu, halinde zeene. ");
INSERT INTO flr_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Munyere wage woꞌmuzibo, naye anabuta umwana woꞌbutabana, anamúyinika iziina Beni-Hami, (kuli kudeta: mwana weꞌmbaga yani). Yoyo naye, ye shokuluza waꞌBahamooni, halinde zeene. ");
INSERT INTO flr_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Hiburahimu analyoka yaho i Mamure, anagenderera imbande zeꞌkisaka. Anashumbika ha kati keꞌKadeeshi, neꞌShuuri. Ha nyuma, anagendi bwatala siku ngerwa i Geraari. ");
INSERT INTO flr_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Neꞌri akaba akola iyo munda, anashubi beesha, mbu mukaage Saara alyagagi mwali wage. Kyanatuma mwami Habimereki weꞌGeraari agaatuma kwo bagendi múleetera Saara. Neꞌri bakamúleeta, anamúnyaga. ");
INSERT INTO flr_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kundu kwokwo, Rurema anayijira Habimereki bushigi mu birooto, anamúbwira: «E Habimereki, leero ulwawe lwahikaga. Uyu mukazi wayanga, si ahiiti yiba!» ");
INSERT INTO flr_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Habimereki atâli zaazi menyana na Saara. Kyanatuma agashuvya: «E Nahamwitu, twe naꞌbandu baani, ka ugatuyita, ndaanago mahube go twagira? ");
INSERT INTO flr_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Si Hiburahimu yenyene ye wadeta kwoꞌyu mukazi alyagagi mwali wage! Saara naye, anandeba kwo Hiburahimu ali mushija wage. Ngiisi byo nagira, ndabigiriirira. E waliha, amaboko gaani, gali shululu.» ");
INSERT INTO flr_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Rurema anashubi múbwira: «Yikyo kyaha, nyiji kwo utakigiriirira. Nienyene, nie wakubuza kwo utagire ikyaha imbere lyani, kyanatuma ndakuhanguula kwo umúyegeere. ");
INSERT INTO flr_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","«Kwokwo buno, umúgalulirage imunda yiba. Yiba ali muleevi. Kwokwo, agakuhuunira, halinde unalonge ukulama. Si iri wangayumya umutima, ku kasiisa ugaafwa, mwe naꞌbandu ba mu nyumba yawe booshi.» ");
INSERT INTO flr_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Shesheezi kare-kare, Habimereki anavyuka, anakuumania abakulu booshi ba mu bwami bwage. Neꞌri akabalotololera ngiisi byo akabona, nabo banayami gwatwa neꞌkyoba bweneene. ");
INSERT INTO flr_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Haaho, Habimereki anatumira Hiburahimu. Neꞌri akahika, anamúbuuza: «E Hiburahimu, makagi gano watugirira? Nꞌgakuhubira biki, halinde ungirire yiri ibala, twe naꞌbandu ba mu bwami bwani? Yibyo bitalaalwe wagira, ");
INSERT INTO flr_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","nyandagi úwakushimya kwo ubigire?» ");
INSERT INTO flr_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Hiburahimu, ti: «Ibyatuma nagira kwokwo, bwo nꞌgatona kwo mu kano kaaya, ku kasiisa ndaaye úsimbahiri Rurema. Nanayoboha kwo muganyita, lyo mulonga ukuyanga mukaanie. ");
INSERT INTO flr_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","«Kuguma na yibyo, ku kasiisa alyagagi mwali wani, bwo yishe, ye na daata. Si bamaawe, bo babiri. Kwokwo, nꞌgamúyanga abe mukaanie. ");
INSERT INTO flr_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ikyanya Rurema akambwira kwo njaage imwitu, na ngendi tuula i mahanga, nanayinginga mukaanie kwo ngiisi ho tugakizi lenga hooshi, akizi nyereka kwo anguuziri, mu kukizi deta kwo ndi mushija wage.» ");
INSERT INTO flr_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Haaho, Habimereki anagalulira Hiburahimu mukaage Saara. Anamúbiika kweꞌbibuzi, neꞌmbene, neꞌngaavu, naꞌbaja, naꞌbaja-kazi. ");
INSERT INTO flr_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Anashubi bwira Hiburahimu: «Kino kihugo kyoshi, kiri kyeꞌmwani. Aaho! Utoolage ngiisi ho uloziizi, habe ho ugatuula.» ");
INSERT INTO flr_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Ha nyuma, Habimereki anabwira Saara: «Lolaga! Bwobuno, naheereza mushija wawe ibingorongoro kihumbi, mu kuyereka yutu tumasi twoshi kwo utahiiti ubuhube. Kwokwo, ndaabyo wangaki shembwa kwo.» ");
INSERT INTO flr_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Mukuba, uyo Saara, ikyanya akatwalwa imwa Habimereki, kyanatuma Nahano agayami hangika ibuta lyaꞌbakazi booshi ba mu nyumba yage, bwo Saara âli kola muka Hiburahimu. Haliko, Hiburahimu akahuuna Rurema, anakiza Habimereki, na mukaage, kiri naꞌbaja-kazi baage, halinde banashubi longa ukubuta. ");
INSERT INTO flr_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Nahano anakengeera Saara, anamúgirira nga ngiisi kwo akamúlagaania. ");
INSERT INTO flr_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kundu Hiburahimu âli kola mushaaja wa bweneene, halikago, mukaage Saara anaheeka inda, anamúbutira umwana woꞌbutabana. Bikakoleka ku kyekirya kyanya Rurema âli mali gwanwa amúbwira. ");
INSERT INTO flr_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Uyo mwana, Hiburahimu anamúyinika iziina Hisake. ");
INSERT INTO flr_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Neꞌkyanya Hisake akahisa isiku munaana abusirwi, Hiburahimu anamútenguula, nga kwo Rurema akamúbwira. ");
INSERT INTO flr_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Ku yikyo kyanya, Hiburahimu âli kola neꞌmyaka igana. ");
INSERT INTO flr_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saara anadeta: «Rurema anjambaaza ngana. Na ngiisi úgayuvwa yugu mwazi, naye tugashambaalira kuguma. ");
INSERT INTO flr_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Nyandagi úwangaki bwiziri Hiburahimu kwo naani ngaki yoza? Kundu kwokwo buno, keera namúbutira umwana woꞌbutabana wa mu bushaaja bwage.» ");
INSERT INTO flr_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Hisake anagenderera ukukula. Noꞌlusiku akalyosibwa kwiꞌbeere, Hiburahimu anamúgirira ulusiku lukulu bweneene. ");
INSERT INTO flr_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Lusiku luguma, Saara anabona kwo Hishimaheeri ali mu honyoleza Hisake. (Uyo Hishimaheeri, ye Hiburahimu akabuta ku Hagaari, Umumiisiri-kazi.) ");
INSERT INTO flr_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Kyanatuma Saara agayiji bwira Hiburahimu: «Uyu muja-kazi, umúyimulage, noꞌmwana wage. Si uyu mwana, atâye hyane kuguma na mugala wani wa Hisake.» ");
INSERT INTO flr_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Hiburahimu, mbu ayuvwe kwokwo, anajengeerwa, bwo Hishimaheeri naye âli riiri mugala wage. ");
INSERT INTO flr_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ku yikyo kyanya, Rurema anamúbwira: «E Hiburahimu, utajengeerwe hiꞌgulu lyoꞌyu mwana, kandi iri hiꞌgulu lyoꞌyu muja-kazi. Ngiisi byo Saara agakubwira, ubiyuvwe. Mukuba, mwiꞌkondo lya Hisake, mwo mugalyoka abandu beꞌkibusi kyawe. ");
INSERT INTO flr_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Si ku biloziri uyo mwana, bwo ali gundi mugala wawe, ngamúgira abe yishe woꞌmulala úguhimbiri.» ");
INSERT INTO flr_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Iri hakaba shesheezi kare-kare, Hiburahimu anaboha indanda, anafukumulira naꞌmagoloovi mu ludaha úlukahangwa mu luhu, anabibetuza Hagaari ku bitugo. Neꞌri akamúheerezagya umwana wage, anamúyimula. Hagaari anagenda akola mu jeba-jeba mwiꞌshamba lyeꞌBeeri-Sheba. ");
INSERT INTO flr_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ikyanya galya magoloovi gakamala, Hagaari anasiga ajanda mugala wage mwiꞌdako lyeꞌkishungu-shungu. ");
INSERT INTO flr_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Anagendi yisunga nga ku meetere igana, iri anayidesa: «Yayewe! Uyu mwana wani, ndaloziizi ukubona kwo agaafwa.» Ikyanya âli koli jondamiri yaho, anatulikira mu malira. ");
INSERT INTO flr_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Uyo mwana naye, anatondeera ukulira. Iri Rurema akayuvwa kwokwo, umuganda wage analyoka mwiꞌgulu, anamúbuuza: «E Hagaari, biki íbyaba? Utayobohe! Rurema keera ayuvwa izu lyoꞌmwana haliira ali. ");
INSERT INTO flr_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Aaho! Yimuka, ugendi yabiira umwana, unamútengetere. Ngaki múgira abe yishe woꞌmulala úguhimbiri.» ");
INSERT INTO flr_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Lyeryo, Rurema anayigula Hagaari amasu, anabona ikirigo kyaꞌmiiji. Kwokwo, anayabiira lulya ludaha, anagendi vwoma mwaꞌmagoloovi, anayiji gaheereza mugala wage. ");
INSERT INTO flr_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Uyo mwana, Rurema anagenderera ukumúlanga. Neꞌkyanya akakula, anagendi tuula mwiꞌshamba, anaba kikalage mu kufwora umuheto. ");
INSERT INTO flr_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Neꞌri akaba akoli tuuziri mwiꞌshamba lyeꞌParaani, nyina anamúyangira umunyere woꞌMumiisiri. ");
INSERT INTO flr_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ku yikyo kyanya, Habimereki anagendera Hiburahimu, ali na Fikooli, umukulu waꞌbasirikaani baage, banamúbwira: «E Hiburahimu, mu byoshi byo uli mu kola, Rurema muyamiinwi. ");
INSERT INTO flr_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Aaho! Zeene hano, ubiikage indahiro kwiꞌziina lya Rurema, kwo utâye ndebe, utanâye tebe naꞌbaana baani, kandi iri abandu ba mwiꞌkondo lyani. Nga kwokulya nꞌgakugirira amiija, na naawe kwakundi ukizi gangirira, mwe naꞌbandu ba kino kihugo kyo utuuziri mwo nga kinyamahanga.» ");
INSERT INTO flr_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Hiburahimu naye, ti: «Ee! Iyo ndahiro, nagibiika.» ");
INSERT INTO flr_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ku kyekyo kyanya, Hiburahimu anayerekeza Habimereki, hiꞌgulu lyeꞌkirigo kyaꞌbakozi ba Habimereki bakamúnyaga. ");
INSERT INTO flr_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Haliko, Habimereki anamúshuvya: «Ngiisi úkagira kwokwo, ndamúyiji. Si wenyene utazindi mbwira hiꞌgulu lyabyo! Zeene kwo kukiri kuyuvwa.» ");
INSERT INTO flr_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Haaho, Hiburahimu anayabiira ibibuzi, neꞌngaavu, anabiheereza Habimereki, bananywana ikihango. ");
INSERT INTO flr_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Hiburahimu anahandula ibishaashi birinda byeꞌbibuzi. ");
INSERT INTO flr_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Habimereki anamúbuuza: «Kituma kikagi wahandula yibi bishaashi kwoku?» ");
INSERT INTO flr_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Hiburahimu, ti: «Yibi bishaashi, nakuheereza byo naꞌmaboko gaani nienyene, bube bumasi, kwo nie kahumba kino kirigo.» ");
INSERT INTO flr_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kyanatuma kigabuuzibwa Beeri-Sheba. Mukuba, ho bakabikirana indahiro. ");
INSERT INTO flr_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ikyanya bakaba keera banywanana ikihango yaho i Beeri-Sheba, Habimereki anagalukira mu kihugo kyeꞌBufirisiti, bo na Fikooli, umukulu waꞌbasirikaani baage. ");
INSERT INTO flr_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Haaho i Beeri-Sheba, Hiburahimu anabyala heꞌkivumu. Anahuuna kwiꞌziina lya Nahano, anali ye Rurema weꞌmyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Hiburahimu anahisa imyaka mingi, ashumbisiri mu kihugo kyeꞌBufirisiti nga kinyamahanga. ");
INSERT INTO flr_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Iri hakalenga isiku, Rurema anayiji lola ngiisi kwo Hiburahimu amúlangaliiri, anamúbwira: «E Hiburahimu!» Anamúyakula, ti: «E waliha, nguteziri amatwiri.» ");
INSERT INTO flr_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Rurema anamúbwira: «Yabiira mugala wawe wa Hisake, kundu ali kininga, unamúkuuziri. Mugendanwe mu poroveesi yeꞌMoriya. Neꞌyo munda, ugendi mútanga ituulo lyoꞌkusiriiza. Yukwo kumútanga, kube ku mugazi gwo ngakuyereka.» ");
INSERT INTO flr_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Hiburahimu, mbu bukye shesheezi kare-kare, anayami vyuka, analingikania punda wage. Mu bakozi baage, anayabiira mwo babiri, anayabiira na mugala wage wa Hisake. Neꞌri akasheenya ishaali hiꞌgulu lyoꞌkugendi tanga ituulo lyoꞌkusiriiza, anashokola injira yoꞌkugenda imunda Rurema akamúyereka. ");
INSERT INTO flr_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ku lusiku úlugira izishatu, Hiburahimu analegamira, analangiiza halya handu ku hala, ");
INSERT INTO flr_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","anabwira abakozi baage: «Musigalage hano noꞌyu punda. Twe na mugala wani, twamu genda iriira munda, gira tugendi yikumba Rurema, tukabuli galukira hano.» ");
INSERT INTO flr_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Hiburahimu anayabiira ishaali zoꞌkusiriigiza kwiꞌtuulo, anazibetuza mugala wage wa Hisake. Yehe, anafumbata umuliro naꞌkahamba. Kwokwo, bombi, banagenderera noꞌlugeezi. ");
INSERT INTO flr_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Iri bakaba bakiri mu njira, Hisake anabuuzagya yishe: «E daata!» Naye, ti: «E mwana wani, nguteziri amatwiri.» Hisake, ti: «Maki gano? Ishaali noꞌmuliro, byebino tuhiiti. Aahago! Ikyanabuzi kyoꞌkutanga ituulo, kiri hayi?» ");
INSERT INTO flr_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Hiburahimu, ti: «Rurema yenyene ye gayiheereza ikyanabuzi kyoꞌkutanga ituulo.» Yabo bombi, banagenderera noꞌlugeezi. ");
INSERT INTO flr_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Iri bakahika ho Rurema akayereka Hiburahimu, Hiburahimu anayubaka haꞌkatanda, anakashasha kwo zirya shaali. Ha nyuma, anabuli kona mugala wage wa Hisake, anamúgwejeza ku katanda, hiꞌgulu lyeꞌshaali, ");
INSERT INTO flr_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","anayomolaga akahamba, gira amútongeere. ");
INSERT INTO flr_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Lyeryo-lyeryo mwiꞌgulu, umuganda wa Nahano anamúhamagala kwiꞌzu lihamu kwokuno: «E Hiburahimu, Hiburahimu!» Anayitaba, ti: «E waliha, nguteziri amatwiri.» ");
INSERT INTO flr_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Uyo muganda, ti: «Utaki kolwe kwo wakolera umwana kwiꞌbala. Buno, keera nabona kwo usimbahiri Rurema. Mukuba, uyu mwana wawe weꞌkininga, utashiginya ukumútanga, libe ituulo.» ");
INSERT INTO flr_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Hiburahimu, mbu ayinamulage amalanga, anayami bona ikipanga. Amahembe gaakyo, gâli hangatiiri mu kizigi-zigi. Kwokwo, anakwabaduka, anakireeta, anakitanga ituulo lyoꞌkusiriiza, kyanagomboola mugala wage. ");
INSERT INTO flr_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Yaho handu, Hiburahimu anahayinika iziina «Nahano agayiheereza». Kyo kitumiri halinde zeene, hali mu detwa: «Nahano yenyene agayiheereza ku mugazi gwage.» ");
INSERT INTO flr_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ulya muganda wa Nahano, anashubi hamagala Hiburahimu ukulyoka mwiꞌgulu, ti: ");
INSERT INTO flr_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«Nahano adeta kwokuno: “Utanyima mugala wawe, kundu alyagagi kininga, haliko keera wamúndangira. Ku yukwo, nabiika indahiro kwiꞌziina lyani, ");
INSERT INTO flr_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","kwo ngakugashaanira bweneene. Ngakizi luza abaana baawe, babaagage katundu nga ndonde kwiꞌgulu, na nga mushenyu úguli ku nyaaja. Yabo bandu ba mwiꞌkondo lyawe, bagagaaza utwaya twaꞌbagoma baabo. ");
INSERT INTO flr_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Bwo wanzimbaha, imilala yoshi mu kihugo igakizi gashaanirwa ku njira yabo.”» ");
INSERT INTO flr_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Uyo Hiburahimu, anagalukira ho akasiga abakozi baage. Booshi, banataahira i Beeri-Sheba, imunda âli tuuziri. ");
INSERT INTO flr_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Iri hakalenga isiku, Hiburahimu anayiji bwirwa, ti: «Mirika naye keera abutira mwene winyu wa Nahoori abaana boꞌbutabana. ");
INSERT INTO flr_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Ifula, ye Huuzi. Na úgamúlonda, ye Buuzi. Hanakulikire Kemweri, yishe wa Haraamu, ");
INSERT INTO flr_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","na Kesedi, na Haazo, na Piridaashi, na Yidirafu, na Betweri.» ");
INSERT INTO flr_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Uyo Betweri, ye kabuta Rebeka. Yabo baana munaana, bo Mirika akabutira Nahoori, mwene wabo Hiburahimu. ");
INSERT INTO flr_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Rehuma, muka Nahoori weꞌmbuga, naye akamúbutira abandi baana: Teba, na Gahamu, na Tahashi, na Maka. ");
INSERT INTO flr_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saara akahisa imyaka igana na makumi gabiri niꞌrinda alamiri. ");
INSERT INTO flr_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ha nyuma, anafwira i Kiryati-Hariba (kuli kudeta: i Heburooni) mu kihugo kyeꞌKaanani. Hiburahimu anamúlirira ku kimombo, anamúgandaara. ");
INSERT INTO flr_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ha nyuma, Hiburahimu anatee siga ikirunda, anagendi ganuuza Abahiti, ti: ");
INSERT INTO flr_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Bwo nimùtuuziri mwo nga kinyamahanga, munguliikize ahandu ho ngaziika mukaanie.» ");
INSERT INTO flr_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Yabo Bahiti, ti: ");
INSERT INTO flr_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«E nahamwitu, ututegage amatwiri. Mu kati kiitu, we musholezi kikalage kya Rurema. Uyisebere! Ngiisi shinda yo ugasiima, mube mwo ugaziika mukaawe. Mu kati kiitu, ndaaye mundu úwangakuyima ho ugamúziika.» ");
INSERT INTO flr_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Hiburahimu anayimuka, anayinama ku lushaagwa imbere lyaꞌBahiti booshi, ");
INSERT INTO flr_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","anababwira: «Iri mwangambanguula kwo nziikage mukaanie, namùyinginga, mumbwirire Hefurooni mugala Shohaari ");
INSERT INTO flr_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kwo anguliikize lirya itongo lyage lyeꞌMakepela. Liri mweꞌshinda íkabaajwa mu lwala, ku lubibi lweꞌndalo yage. Mumúyinginge alinguliikize ku kishingo íkikwaniini imbere liinyu, gira habaagage ho ngakizi ziikira beꞌmbaga yani.» ");
INSERT INTO flr_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Uyo Hefurooni yenyene, âli bwatiiragi naꞌbaabo Bahiti. Na bwo booshi bâli kuumaniri kwiꞌrembo lyaꞌkaaya, anashuvya Hiburahimu imbere lyabo, ti: ");
INSERT INTO flr_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Nanga, e nahamwitu! Nakuyinginga, undege amatwiri. Kwokwo, tuli imbere lya bano biitu, nakuheereza itongo, kiri neꞌshinda íri mwo, gira ugendi ziika mwoꞌmugoli.» ");
INSERT INTO flr_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Hiburahimu anashubi yinama ku lushaagwa imbere lya yabo beene akaaya. ");
INSERT INTO flr_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Iri booshi bakaba baki múteziri amatwiri, anabwira Hefurooni, ti: «Nakuyinginga, unyuvwirize! Itongo lyawe, ngaligula ku kishingo íkikwaniini. Yibi bindu, we kongwa, ubinyabiirire, gira ndonge ukuliziikira mwo mukaanie.» ");
INSERT INTO flr_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Hefurooni, ti: «E nahamwitu, ");
INSERT INTO flr_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","yiri itongo lyangagula ishekeri magana gana naaho. Haliko ha kati kiitu, bikagi byo zangatugirira? Ugendage naaho, uziike umugoli.» ");
INSERT INTO flr_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ikyanya Hiburahimu na Hefurooni bakayemerezania ku yizo shekeri magana gana imbere lya balya Bahiti, Hiburahimu anamúharuurira zo. (Yizo shekeri, kyo kyâli riiri kigero kyaꞌbadandaza bâli kizi koleesa mu zirya siku.) ");
INSERT INTO flr_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Kwokwo, banasikiiriza Hiburahimu itongo lya Hefurooni iyo munda i Makepela, hoofi neꞌMamure, kuguma neꞌshinda ya mu lwala, kiri neꞌbiti byoshi. ");
INSERT INTO flr_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Yabo Bahiti booshi, banaba tumasi, bwo bâli kuumaniri kwiꞌrembo lyaꞌkaaya. ");
INSERT INTO flr_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kwokwo, Hiburahimu anaziika mukaage Saara mu shinda ya mwiꞌtongo lyeꞌMakepela, hoofi neꞌMamure (kuli kudeta: i Heburooni) mu kihugo kyeꞌKaanani. ");
INSERT INTO flr_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Lirya itongo, kuguma neꞌshinda íyâli riiri mwo, Abahiti bo bakabiguliikiza Hiburahimu, habe ho agakizi ziikira abandu baage. ");
INSERT INTO flr_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Hiburahimu âli kola mushaaja bweneene. Na Nahano âli múgashaniiri bweneene, mu kati ka byoshi. ");
INSERT INTO flr_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Anâli riiri noꞌmukozi wage muguma, úwâli kuliiri abaabo booshi, anali ye wâli yimangiiri ibindu byage. Uyo mukozi, lusiku luguma Hiburahimu anamúbwira: «Ubiikage ukuboko mwiꞌdako lyeꞌkibero kyani. ");
INSERT INTO flr_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Na kwiꞌziina lya Nahano Rurema, ulya úkalema igulu neꞌkihugo, ushiikize kwo utâye loogeze mugala wani wa Hisake umukazi mu banyere ba mu kino kihugo kyeꞌKaanani. Kundu ngoli tuuziri hano, ");
INSERT INTO flr_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","haliko, ugendi múloogeza ye mu kihugo kyo nꞌgakomooka mwo. Kinabe kya mu bandu biꞌkondo lyani.» ");
INSERT INTO flr_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Uyo mukozi, ti: «E waliha, hali ikyanya umunyere angalahira kwo atagayisunga hala neꞌmwabo. Aahago! Iri angalahira kwokwo, ka ngwaniini ngalulire mugala wawe mu kihugo kyo ukakomooka mwo?» ");
INSERT INTO flr_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Hiburahimu, ti: «Nanga! Utakolwe kwo wamúgalulira mwo. ");
INSERT INTO flr_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Si Nahano Rurema, ulya úkalema igulu, keera akandyosa mu kihugo kyo nꞌgakomooka mwo, na mu bandu ba mwiꞌkondo lyani. Anambwira mu kushiikiza, ti: “Kino kihugo, ngakiheereza abandu ba mu kibusi kyawe.” Ye na yoyo Rurema, ye gakutumira umuganda wage akurongoore, halinde ulongere mugala wani umukazi iyo munda. ");
INSERT INTO flr_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Noꞌyo mukazi, iri angayami shiikiza kwo mutayijanwe, lyoki indahiro yo ugambiikira, ugaaba wagiyifwongooza mwo. Si utakolwe kwo wagalulira mugala wani iyo munda!» ");
INSERT INTO flr_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Uyo mukozi, iri akayuvwa kwokwo, anabiika ukuboko kwage mwiꞌdako lyeꞌkibero kya nahamwabo, mu kushiikiza kwo agamúsimbaha. ");
INSERT INTO flr_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Lyeryo, uyo mukozi analola mu ngamiya za nahamwabo, anayabiira mwiꞌkumi. Anayabiira neꞌbindi bindu bingi byeꞌkishingo bya nahamwabo. Ha nyuma, anashokola injira yoꞌkugenda i Haraamu, mu kihugo kyeꞌMezopotamiya, ho Nahoori âli ki tuuziri. ");
INSERT INTO flr_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Uyo mukozi, mbu ahikage kwiꞌhulukiro lyaꞌkaaya, anabona heꞌkirigo, anahavyagiza ingamiya. Kâli kola kabigingwe, kyo kyanya abakazi bâli kizi yiji vwoma. ");
INSERT INTO flr_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Lyeryo, anahuuna, ti: «E Nahano Rurema wa nahamwitu Hiburahimu! Nakuyinginga, ukolerage umukozi wawe Hiburahimu amiija, mu kundabaala zeene, halinde ngendukirwe mu luno lugeezi. ");
INSERT INTO flr_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Buno ngola ha kino kirigo. Naꞌbanyere ba mu kano kaaya bakola mu yiji vwoma. ");
INSERT INTO flr_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Aahago! Mu kati kaabo, ngiisi ye ngabwira kwo atuule akabindi kaage, ninywe amiiji, ananjuvye, ti: “Gaagano, unywe kwo.” Anashubi deta, ti: “Kiri neꞌngamiya zaawe, ngazinywesa”, yoyo, abe ye mukazi ye watoolera umukozi wawe Hisake. Kwiꞌyo njira, lyo ngaaba naꞌkasiisa kwo wakolera nahamwitu Hiburahimu amiija.» ");
INSERT INTO flr_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Iri akaba atazi yusa ukuhuuna Rurema, haaho-haaho, hanahulukira munyere muguma, iziina lyage ye Rebeka, abetwiri akabindi. Uyo Rebeka, âli riiri munyere Betweri, anâli riiri mwijukulu Nahoori na Mirika. Na Nahoori âli riiri mwene wabo Hiburahimu. ");
INSERT INTO flr_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Uyo Rebeka, âli nonosiri ngana, atanâli zaazi menyana noꞌmushosi. Kwokwo, anamanukira iwa kirya kirigo, anavwoma. Ha nyuma, anabuli betula akabindi kaage, anashokola injira. ");
INSERT INTO flr_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Mbu abe akola mu taaha, ulya mukozi wa Hiburahimu anamúyitanga, ti: «We kongwa, umbeereze ku miiji, ngutuule nga miguuti inga.» ");
INSERT INTO flr_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Na wa naye: «E waliha, gaagano, unywe.» Yako kabindi, anakashonoola ku kitugo, anakahengeka mu kumúnywesa. ");
INSERT INTO flr_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ulya munyere, iri akayusa ukumúnywesa, anashubi deta: «Kiri na yizi ngamiya zaawe, ngazivwomera, halinde nazo zishoolage.» ");
INSERT INTO flr_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ha butambi lyeꞌkirigo, hâli riiri umuvuli. Uyo munyere anagufukumulira mwo ágâli sigiiri mu kabindi. Haaho-haaho, anashubi lindimukira yo, anakizi vwomera yizo ngamiya, halinde zooshi zanashoola. ");
INSERT INTO flr_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ikyanya akaba akiri mu kita-kita, ulya mukozi anakizi múyitegeereza, buzira kudeta kiri niꞌgambo, iri anayibuuza, ti: «Ka Nahano keera ashuvya amahuuno gaani, kandi iri nanga?» ");
INSERT INTO flr_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Iri ingamiya zaage zikaba keera zayusa ukushoola, anayami fumbadika umunyere imbete yeꞌnooro. Yâli hiiti ubuzito nga bwa garama ndatu. Anashubi múfumbadika neꞌbikomo bibiri byeꞌnooro. Na ngiisi kiguma, kyâli hiiti ubuzito ingingwe ye garama igana. ");
INSERT INTO flr_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Anamúbuuza: «Ewe! Ulyagagi munyere nyandi? Twe na bano, ka tugalonga ahandu ho tugalaala mu mwinyu?» ");
INSERT INTO flr_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebeka, ti: «Ndi munyere Betweri. Na shokulu, ye Nahoori. Na mugaaka, ye Mirika. ");
INSERT INTO flr_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ha mwitu, halyagagi ikyaliri kingi kyoꞌkuyajira yizi ngamiya zaawe. Hali na byoꞌkuziyahirira. Kiri na niinyu, hali ho mugalaala.» ");
INSERT INTO flr_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Ulya mukozi anafukama, anayikumba Nahano, ti: ");
INSERT INTO flr_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","«E Nahano Rurema wa nahamwitu Hiburahimu, kongwa bweneene, bwo ukayami yereka Hiburahimu ubwija bwawe. Ikyanya ukamúlagaania igambo, wanamúyereka kwo utali mu hinduka hiꞌgulu lyalyo. E Nahano, mu luno lugeezi lwani, wayami ndongoora, halinde mu bandu ba mu nyumba ya nahamwitu.» ");
INSERT INTO flr_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebeka, anayami kwabadukira imunda nyina. Birya byoshi íbyakoleka, anagendi múganuulira byo. ");
INSERT INTO flr_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebeka âli hiiti mushija wage, iziina lyage ye Labaani. Uyo Labaani, anayami tibitira iwa kirya kirigo, gira abone uyo mushosi. ");
INSERT INTO flr_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Mukuba, âli mali bona imbete neꞌbikomo ku maboko ga mwali wage, akanayuvwa amagambo gaage, nga kwo Rebeka âli mali baganuulira. Lyeryo, Labaani anakwabadukira imunda uyo mushosi, anamúgwanana aki yimaaziri yaho ha kirigo, kuguma neꞌngamiya zaage. ");
INSERT INTO flr_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Anayami múbwira: «Nahano keera akugashaanira. Aaho! Utaki shubi yisunga. Si uyegererage imwitu. Keera nalingikania inyumba yo ugahanda mwo, kiri na ho yizi ngamiya zaawe zigalaala.» ");
INSERT INTO flr_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Uyo mukozi, anagendi yingira mu nyumba. Imiteekerwa yoshi íyâli ku ngamiya, banagishonoola, banaziyahirira. Uyo mukozi, naꞌbaabo bo bâli yijiinwi, banabaheereza amiiji goꞌkuleeza ku magulu. ");
INSERT INTO flr_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ha nyuma, banabazimaana. Haliko, uyo mukozi anadeta: «Niehe, ndaahyo nangabiika ku kanwa, índazi deta íbyandeeta.» Na wa Labaani, ti: «Bidete!» ");
INSERT INTO flr_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ulya mushosi, ti: «Ndi mukozi wa Hiburahimu. ");
INSERT INTO flr_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Noꞌyo Hiburahimu, Rurema keera akamúgashaanira, anakola mugale bweneene. Keera Nahano akamúheereza inguuli zeꞌbibuzi, na zeꞌmbene, na zeꞌngaavu, kiri neꞌnguuli zeꞌngamiya, neꞌza bapunda. Na kwakundi, keera akalonga inooro nyingi, neꞌharija, kuguma naꞌbakozi, abashosi naꞌbakazi. ");
INSERT INTO flr_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","«Muka nahamwitu, iziina lyage ye wâli Saara. Mu bugiikulu bwage, akamúbutira umwana woꞌbutabana, ye Hisake. Noꞌyo mwana, ye nahamwitu akasikiiriza ibindu byage byoshi. ");
INSERT INTO flr_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nahamwitu, kundu atuuziri mu kihugo kyeꞌKaanani, haliko akambikiisa indahiro kwo ndaloogeze Hisake umukazi mu banyere beꞌyo munda. ");
INSERT INTO flr_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Akangomeereza kwo ngendi múloogeza ye mu mulala gwage, anabe wa mwiꞌkondo lyage. ");
INSERT INTO flr_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","«Nanamúbuuza: “Uyo munyere, iri angalahira kwo tutayijanwe, kuti ngaagira?” ");
INSERT INTO flr_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","«Naye, ti: “Nahano ayamiri ali mu ndongoora. Na buno, agakulungikira umuganda wage, halinde ugenduukirwe mu lugeezi lwawe. Uloogeze mugala wani umukazi, mu mulala gwani, na mwiꞌkondo lyani, unamúndeetere hano. ");
INSERT INTO flr_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Haliko, mango wahika yo, batanakuheereze ye, ino ndahiro yo ugambiikira, ugaaba wagiyifwongooza mwo. Unabe wayikiza niꞌdaaki lyani.” ");
INSERT INTO flr_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«Zeene, iri naaba ngola ha kirigo, nanahuuna Rurema, ti: “E Nahano Rurema wa nahamwitu Hiburahimu, mu luno lugeezi, nakuyinginga undabaalage, gira ngenduukirwe. ");
INSERT INTO flr_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Buno, ngola hano. Ngiisi munyere úgayiji vwoma, ninamúbwire: ‘We kongwa, umbeereze ku miiji ágali mu kabindi, ngutiire nga miguuti inga’, ");
INSERT INTO flr_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","naye ananjuvye, ti: ‘Gaagano, unywe. Kiri neꞌngamiya zaawe, ngazivwomera’, yoyo abe ye mukazi watoolera mugala nahamwitu.” ");
INSERT INTO flr_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","«Iri naaba ndaziyusa ukuhuuna Rurema, haaho-haaho Rebeka anambulukira kwo, abetwiri akabindi. Anayami yikira ha kirigo, anavwoma. Nanamúbwira: “We kongwa! Mbeereza amagoloovi ninywe.” ");
INSERT INTO flr_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Lyeryo, anayami tuula kalya kabindi kaage haashi, anambwira: “E nahamwitu, gaagano, unywe. Kiri na yizi ngamiya zaawe, nazo ngazivwomera.” Kwokwo, nananywa, ananywesa neꞌngamiya. ");
INSERT INTO flr_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","«Neꞌri namúbuuza kwo alyagagi munyere nyandi, ananjuvya kwo ali munyere Betweri, mwijukulu Nahoori bo na Mirika. Haaho-haaho, nanamúyambika imbete kwiꞌzuulu, nanamúyambika neꞌbikomo ku maboko. ");
INSERT INTO flr_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","«Nanafukama mu kuyikumba Nahano Rurema wa nahamwitu Hiburahimu. Na íbitumiri nꞌgamúyivuga, bwo akandongoora mu luno lugeezi lwani, anandungaania imwoꞌmunyere wa mwiꞌkondo lya nahamwitu Hiburahimu. ");
INSERT INTO flr_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","«Aahago! Mumbwirage, iri muloziizi ukutwanira nahamwitu. Kandi iri nanga, mumbwire ku bweranyange.» ");
INSERT INTO flr_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labaani, bo na Betweri banadeta: «Lino igambo, keera twabona kwo lyashaaga imwa Nahano yenyene. Ndaalyo lindi twangaki deta. ");
INSERT INTO flr_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebeka, yoyo yaho, ha mbere lyawe. Umúyabiire, mugendanwe. Abaagage mwali-kazi wa nahamwinyu, nga kwo Nahano keera akyula.» ");
INSERT INTO flr_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Umukozi wa Hiburahimu, mbu ayuvwage kwokwo, anafukama mu kuyikumba Nahano. ");
INSERT INTO flr_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Anahambuula ibindu íbikatulwa mu harija, na mu nooro, kuguma neꞌbyambalwa. Yibyo byoshi, anabifumbadika Rebeka. Mushija wa Rebeka, bo na nyina, nabo anabaheereza ibindi bindu byeꞌkishingo. ");
INSERT INTO flr_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Ha nyuma, uyo mukozi, kuguma na ábâli múherekeziizi, banazimaanwa. Neꞌri bakayusa ukulya, banagendi gwejera. Shesheezi kare-kare, ulya mukozi, mbu avyuke, ti: «Mumbanguulage, ngalukire imwa nahamwitu.» ");
INSERT INTO flr_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Haliko, mushija wa Rebeka, bo na nyina, ti: «Ulekage Rebeka, tutee múyalika nga siku ikumi, mukabuli gendanwa.» ");
INSERT INTO flr_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Uyo mukozi, ti: «Nahano keera agashaanira ulugeezi lwani. Aahago! Mutaki njibirize. Mundeke, ngalukire imwa nahamwitu.» ");
INSERT INTO flr_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Na wa nabo, ti: «Tuhamagale munyere witu yenyene, gira tumúbuuze.» ");
INSERT INTO flr_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Neꞌri bakamúhamagala, banamúbuuza: «E Rebeka, ka ugagenda noꞌyu mushosi?» Naye, ti: «Ee, ngagenda.» ");
INSERT INTO flr_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kwokwo, Rebeka, kuguma noꞌmukazi úwâli kizi múlera, noꞌlya mukozi, kiri na ábâli múherekeziizi, booshi banahanguulwa kwo bagendage. ");
INSERT INTO flr_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bashija ba Rebeka, banamúfuuhira amate, ti: «E mwali witu, Rurema akugire ubaagage nyina weꞌbinoono neꞌbinoono, halinde abandu ba mwiꞌkondo lyawe, bagaaze utwaya twaꞌbagoma baabo.» ");
INSERT INTO flr_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Uyo Rebeka anayilingikania, kuguma noꞌtushooshole twage, banashona ku ngamiya, banakulikira umukozi. Booshi banashokola injira. ");
INSERT INTO flr_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ku kyekyo kyanya, Hisake âli mali shaaga ha kirigo Lahayi-Rohi, anagendi shumbika i Negebu. ");
INSERT INTO flr_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Lusiku luguma kabigingwe, anagenda mu ndagiriro, ali mu yitoneesa. Lyeryo, analangiiza ingamiya zikola mu yija imunda ali. ");
INSERT INTO flr_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka naye, mbu alangiize, anabona Hisake. Kyanatuma agayami shonooka ku ngamiya, ");
INSERT INTO flr_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","anabuuza uyo mukozi: «Uliira mushosi mu ndagiriro úli mu yiji tusanganira, ye nyandi?» Naye, ti: «Uliira, ye nahamwitu Hisake.» Lyeryo, Rebeka anayami yabiira ikitambala kyage, anakiyibwika ku malanga. ");
INSERT INTO flr_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Iri bakahika áhali Hisake, umukozi anatondeera ukumútondobolera ngiisi byo akagira. ");
INSERT INTO flr_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Hisake, mbu ayuvwagwe kwokwo, anahisa Rebeka mwiꞌheema, lirya lyeꞌmwa nyina Saara. Rebeka anaba mukaage. Hisake anaba amúkuuziri bweneene. Kwokwo, kwo akaholeera mu bufuuvi bwoꞌkusigwa na nyina. ");
INSERT INTO flr_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Hiburahimu anashubi yanga ugundi mukazi, ye Ketura. ");
INSERT INTO flr_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ketura, anamúbutira Zimuraani, na Yokishaani, na Medaani, na Midyani, na Hishibaaki, na Shuwa. ");
INSERT INTO flr_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokishaani naye, anabuta Sheeba, na Dedaani. Dedaani naye anabuta Abahashuuri, naꞌBaletuushi, naꞌBalehumi. ");
INSERT INTO flr_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midyani naye, anabuta Hefa, na Hefeeri, na Hinoki, na Habida, na Herida. Yabo booshi, bâli ba mwiꞌkondo lya Ketura. ");
INSERT INTO flr_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Hiburahimu anasikiiriza Hisake ibindu byage byoshi, gira akabihyane. ");
INSERT INTO flr_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Si abaana baꞌbandi bakaage, ku kyanya âli ki riiri ho, anatee bagabira ibyeꞌmwabo, abuli bahandula ku mugala wage wa Hisake, anabatuma hala mu mahanga goꞌluhande lweꞌsheere. ");
INSERT INTO flr_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Hiburahimu akalama imyaka igana na makumi galinda niꞌtaanu. ");
INSERT INTO flr_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Iyo myaka yoshi, âli kizi gashaanirwa. Ha nyuma, anafwa, anagwana bashokuluza baage. ");
INSERT INTO flr_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Bagala baage, Hisake na Hishimaheeri, banamúziika mu shinda yeꞌMakepela, uluhande lweꞌsheere lweꞌMamure, mwiꞌtongo lyeꞌmwa Hefurooni mugala Shohaari, Umuhiti. ");
INSERT INTO flr_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Yiryo itongo, Hiburahimu âli mali gwanwa aligula imwaꞌBahiti. Haaho ho Hiburahimu na mukaage Saara bakaziikwa. ");
INSERT INTO flr_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ikyanya Hiburahimu akaba keera afwa, Hisake anatuula ha butambi lyeꞌKirigo Lahayi-Rohi, Rurema anakizi múgashaanira. ");
INSERT INTO flr_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Abandu ba mu mbaga ya Hishimaheeri mugala Hiburahimu, umwazi gwabo gwo gwogu: Hiburahimu, akabuta Hishimaheeri ku Hagaari, Umumiisiri-kazi. Âli riiri muja-kazi wa Saara. ");
INSERT INTO flr_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Naꞌmaziina gaꞌbaana ba Hishimaheeri, ukukulikirana na kwo bakabutwa, go gaaga: Ifula, Nebayoti. Hanakulikira Kedaari, na Hadibeeri, na Mibusamu, ");
INSERT INTO flr_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","na Mishima, na Duma, na Masa, ");
INSERT INTO flr_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","na Hadaadi, na Tema, na Yeturi, na Nafisi, na Kedema. ");
INSERT INTO flr_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Baabo, bo bagala Hishimaheeri ikumi na babiri. Ngiisi muguma wabo, âli riiri mutwali woꞌmulala gwage. Utwaya twabo, tuhamu noꞌtuniini, twâli kizi detwa ku maziina gaabo. ");
INSERT INTO flr_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Hishimaheeri akalama imyaka igana na makumi gashatu niꞌrinda. Iri lukalamuka, anagwana bashokuluza baage. ");
INSERT INTO flr_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Beene Hishimaheeri, bâli tuuziri ha kati keꞌHavila neꞌShuuri. Yako kaaya keꞌShuuri, kali hoofi neꞌMiisiri, uluhande lweꞌHasuriya. Yabo booshi, bâli yihandwiri ku beene wabo, beene Hiburahimu. ");
INSERT INTO flr_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abandu ba mu mbaga ya Hisake mugala Hiburahimu, umwazi gwabo gwo gwogu: ");
INSERT INTO flr_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Hisake, iri akaba akola neꞌmyaka makumi gana, anayanga Rebeka, mwali wa Labaani, anâli munyere Betweri waꞌBaharaamu. Bâli tuuziri mu kihugo kyeꞌMezopotamiya. ");
INSERT INTO flr_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Na bwo Rebeka âli gumbiragi, kyanatuma Hisake agamúhuunira imwa Nahano. Galya mahuuno gaage, Nahano anagashuvya, Rebeka anaheeka inda. ");
INSERT INTO flr_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Iyo nda, yâli riiri ya mahasha. Na mu kati kaayo, abaana bombi banakizi shomborozania, kyanatuma Rebeka agatondeera ukuzimula, ti: «Maki gano ágamba kwo?» Anahuuna Nahano. ");
INSERT INTO flr_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Naye, anamúshuvya: «Mu nda yawe, mulyagagi imilala ibiri. Iyo milala yombi, igayiji yihandulana kwo. Mulala muguma, gugayiji ba neꞌmisi bweneene ukuhima ugwabo. Ngulwe, ye gakizi kolera Butooto.» ");
INSERT INTO flr_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Rebeka, ikyanya akabuta, anabuta amahasha. ");
INSERT INTO flr_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ngulwe akabutwa ali mudukula. Amagala gaage gooshi, gâli yijwiri ibikarakara, kyanatuma bagamúyinika Hesahu. ");
INSERT INTO flr_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Butooto, ikyanya akabutwa, anayija agwasiri Hesahu ku kasiizira, kyanatuma bagamúyinika Yakobo. Ikyanya Hesahu na Yakobo bakabutwa, yishe Hisake âli kola neꞌmyaka makumi galindatu. ");
INSERT INTO flr_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Yabo batabana bombi, banakula. Hesahu âli komiiri ukugenda mu kishuka, anayiji ba kikalage mu kuhiiva. Si Yakobo yehe, âli riiri mutuudu, anâli kombiiri imikolwa ya ha kaaya. ");
INSERT INTO flr_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Hisake âli kuuziri inyama zeꞌnyamiishwa, kyanatuma agakizi kundirira Hesahu. Si Rebeka yehe, anakunda Yakobo. ");
INSERT INTO flr_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Lusiku luguma, iri Yakobo akaba akola mu deeka ingoole, Hesahu analyoka i ruhiiviro, akoli jagabusiri niꞌshali. ");
INSERT INTO flr_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Anadeta: «E Yakobo, we kongwa! Ishali likola bu nyita. Aaho! Umbanguulage ndye ku yibi byokulya byawe íbidukumbusiri, gira bimbembuule.» (Kyo kikatuma bagamúyinika iziina Hedoomu, kuli kudeta: mudukula). ");
INSERT INTO flr_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakobo anamúshuvya: «Utee mbekuulira ubungulwe bwawe.» ");
INSERT INTO flr_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Naye, ti: «Si ishali likola bu nyita! Aahago! Ubungulwe bwani, biki bwangaki ngirira?» ");
INSERT INTO flr_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakobo, ti: «Tee biikage indahiro.» Iyo ndahiro, Hesahu anamúbiikira yo. Kwokwo, kwo Hesahu akaguliisa ubungulwe bwage. ");
INSERT INTO flr_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ha nyuma, Yakobo anaheereza Hesahu ku mukate, na ku zirya ngoole. Neꞌri Hesahu akayusa ukubilya noꞌkunywa, anayigendera. Kwokwo, kwo âli gayiriziizi ubungulwe bwage. ");
INSERT INTO flr_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Iri hakalenga isiku, mu kihugo mwanashubi teera umwena. (Gutali gulya úgukateera abandu ku kyanya kya Hiburahimu.) Yugwo mwena, gwanatuma Hisake agabungira i Geraari, mu kihugo kya Habimereki, mwami waꞌBafirisiti. ");
INSERT INTO flr_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yaho i Geraari, Nahano anahulukira ku Hisake, anamúbwira: «Ulekage ukugenda i Miisiri. Si utuule mu kihugo kyo ngakubwira. ");
INSERT INTO flr_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Kyekino kihugo, kyo ugakizi tuula mwo. Tugayamanwa, na ngizi kugashaanira. «Na gulya muhango gwo nꞌgaheereza yisho Hiburahimu, gwo na naawe ngakukwigiza. Kwokwo, yibi bihugo byoshi, ngamùheereza byo, mwe naꞌbandu ba mwiꞌkondo lyawe. ");
INSERT INTO flr_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Aba mwiꞌkondo lyawe, bagaluguuka nga ndonde kwiꞌgulu, na mbaheereze yibi bihugo byoshi. Na ku njira yabo, imilala yoshi igakizi gashaanirwa. ");
INSERT INTO flr_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Mukuba, Hiburahimu akasimbaha imaaja zaani, nga ngiisi kwo nꞌgakyula.» ");
INSERT INTO flr_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Iri Hisake akayuvwa kwokwo, anatee beera haaho i Geraari. ");
INSERT INTO flr_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Abandu ba mu kihugo kyeꞌGeraari, iri bakabuuza Hisake hiꞌgulu lya mukaage, anabashuvya: «Uyu, ali mwali wani.» Akayoboha ukudeta kwo ali mukaage, bwo Rebeka âli nonosiri bweneene. Âli yobohiri kwaꞌbatuulaga beꞌyo munda bagakengeera bamúyita. ");
INSERT INTO flr_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ulya Habimereki, mwami waꞌBafirisiti, ikyanya âli mali tuula yaho siku nyingi, analingulira mu kaazo, anabona Hisake na Rebeka bagweti bagahoberana. ");
INSERT INTO flr_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kyanatuma agatumira Hisake, anamúbuuza: «Si ukambwira kwo Rebeka ali mwali wawe? Kiziga ali mukaawe!» Hisake, ti: «Nꞌgayoboha kwo hiꞌgulu lyage, nangakengeera nayitwa.» ");
INSERT INTO flr_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Uyo Habimereki, anamúbwira: «Maki gano watugirira? Si mu bano bandu baani, hali úwangashulehiri mukaawe buzira kuyoboha, unakengeere watuyingiza mu buhube bweneene.» ");
INSERT INTO flr_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Uyo Habimereki anayerekeza abandu baage, ti: «Ngiisi úgaahuma ku Hisake, kandi iri ku mukaage, agayami yitwa.» ");
INSERT INTO flr_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nahano anakizi gashaanira Hisake. Yugwo mwaka, iri akabyala imbuto zaage mu kihugo, anabeerwa, anayimbula ubugira kali igana. ");
INSERT INTO flr_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ibindu byage byanayushuuka ingingwe, anaba mugale bweneene. ");
INSERT INTO flr_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Âli riiri mutuuzi weꞌngaavu, na weꞌbibuzi bingi. Âli hiiti naꞌbaja bingi, halinde Abafirisiti banakizi múyuvwirwa uluugi. ");
INSERT INTO flr_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ku kyanya Hiburahimu âli ki riiri ho, abakozi baage bakahumba ibirigo. Haliko, ku kyanya kya Hisake, yabo Bafirisiti banakizi yiji bifulira. ");
INSERT INTO flr_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kwokwo, Habimereki anabwira Hisake: «Lola ngiisi kwo ukola neꞌmisi ukutuhima. Aaho! Utulyokerage mu kino kihugo kiitu.» ");
INSERT INTO flr_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kwokwo, Hisake analyoka yaho, anagendi shumbika mu ndekeera yeꞌGeraari. ");
INSERT INTO flr_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Birya birigo byaꞌbakozi ba Hiburahimu bakahumba ku kyanya âli ki riiri ho, ikyanya Abafirisiti bakabifulira, Hisake anakizi shubi bitoboolola. Ngiisi kwo yishe akabiyinika amaziina, anakizi bibuuza gaago-gaago. ");
INSERT INTO flr_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Lusiku luguma, mwiꞌyo ndekeera yeꞌGeraari, abakozi ba Hisake banahumba mweꞌkirigo, banabona kwo kyazununuka mwaꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Haliko, abangere ba mwiꞌyo ndekeera, naꞌbeꞌmwa Hisake, banakizi kihambanwa, ti: «Si miiji giitu, yaga!» Yikyo kirigo, Hisake anakiyinika iziina Heseki, (kuli kudeta: milongwe). Mukuba, abangere beꞌGeraari naꞌbeꞌmwage bakakihambanwa. ");
INSERT INTO flr_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ha nyuma, yabo bakozi ba Hisake banagendi humba ikindi kirigo. Nakyo kwakundi, banashubi kihambirira. Hisake anakiyinika iziina Sitina, (kuli kudeta: bushombani). ");
INSERT INTO flr_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Hisake anashubi lyoka yaho, anagendi humba ikindi kirigo. Si kyohe, batanaki kihambirira. Yikyo kirigo, anakiyinika iziina Rehobooti, (kuli kudeta: ndaraara). Anadeta: «Nahano leero atuheereza ino ndaraara, hanali ho twamu gangaaza.» ");
INSERT INTO flr_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ha nyuma, Hisake analyoka yaho, anagenda i Beeri-Sheba. ");
INSERT INTO flr_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mu bwobwo bushigi, Nahano anamúhulukira kwo, anamúbwira: «Niehe, nie Rurema wa yisho Hiburahimu. Kwokwo, tuyamiinwi, utayobohe. Bwo Hiburahimu âli riiri mukozi wani, kyo kitumiri naawe ngakizi kugashaanira. Na ngizi luza abandu ba mwiꞌkondo lyawe.» ");
INSERT INTO flr_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Iyo munda i Beeri-Sheba, Hisake anayubaka yaꞌkatanda koꞌkusiriigiza kwaꞌmatuulo, anayikumba Nahano, anahashinga amaheema gaage. Abakozi baage, banahumba heꞌkindi kirigo. ");
INSERT INTO flr_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Habimereki analyoka i Geraari, ali kuguma noꞌmuhanuuzi wage Ahuzaati, na Fikooli, umukulu waꞌbasirikaani. Banayijira Hisake. ");
INSERT INTO flr_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Hisake anababuuza: «E bagoma baani, bikagi mwayiji gira leero? Si keera mukanyimula imwinyu!» ");
INSERT INTO flr_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Nabo, ti: «Keera tukabona ku bweranyange kwo Nahano muyamiinwi. Tukoli bwini kwo buli bwija tubeeranwe mu kati koꞌmutuula. Aahago! Tubikirane indahiro, tunanywane ikihango. ");
INSERT INTO flr_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ubiikage indahiro kwo utâye tugirire buligo, bwo nyiitu, ndaabwo twakugirira. Tukakukolera amiija, mu kukuleka ugendage noꞌmutuula. Na buno, Nahano akugashaniiri.» ");
INSERT INTO flr_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kwokwo, Hisake anabagirira ulusiku lukulu, banalya, bananywa. ");
INSERT INTO flr_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Neꞌri bukakya shesheezi kare-kare, banabikirana indahiro. Ha nyuma, Hisake anabaherekeza, banasezerana mu kati koꞌmutuula. ");
INSERT INTO flr_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Lwolwo lusiku, abakozi ba Hisake, banayiji múmenyeesa kwo kirya kirigo kyo bashuba mu toboolola, kyayija mwaꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kirya kirigo, Hisake anakiyinika iziina Shiiba, (kuli kudeta: ndahiro). Halinde zeene, yako kaaya kali mu buuzibwa Beeri-Sheba. ");
INSERT INTO flr_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Hesahu, iri akahisa imyaka makumi gana, anayanga abanyere babiri baꞌBahiti, Yoditi munyere Beeri, na Basemati munyere Helooni. ");
INSERT INTO flr_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Yabo bakazi bombi, banakizi jengeeza bweneene Hisake na Rebeka. ");
INSERT INTO flr_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ikyanya Hisake âli kola mushaaja, amasu gaage gâli mali humaala, atanakizi ki bona. Lusiku luguma, anahamagala Hesahu, ifula yage, anamúbwira: «E mwana wani!» Naye, ti: «E waliha, nguteziri amatwiri.» ");
INSERT INTO flr_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Na wa Hisake, ti: «Ubwinagi kwo buno keera nashaaja. Noꞌlusiku lwo ngafwira kwo, ndaluyiji. ");
INSERT INTO flr_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Aaho! Uyabiirage ibyugi byawe, umuheto, neꞌmyambi, unagende mu kishuka, gira ugendi mbiivira inyamiishwa. Neꞌkyanya ugataahana inyama, ");
INSERT INTO flr_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","uyiji ngolera kweꞌbyokulya íbiheshiri. Undeekere ngiisi byo ndi mu siima, gira mbilye, mbuli kugashaanira, índazi fwa.» ");
INSERT INTO flr_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Haaho, Hesahu anagenda iwa kuhiiva. Si ikyanya Hisake âli kiri mu ganuulira mugala wage wa Hesahu, kiziga Rebeka abayuvwa. ");
INSERT INTO flr_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Uyo Rebeka anasigali hamagala mugala wage wa Yakobo, anamúbwira: «Mukulu wawe wa Hesahu, nayuvwa kwo yisho ashuba mu múbwira: ");
INSERT INTO flr_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Ugendi mbiivira. Neꞌnyamiishwa yo ugayita, uyiji gingolera kweꞌbyokulya, gira ngugashaanire imbere lya Nahano, índazi fwa.” ");
INSERT INTO flr_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","«E mwana wani, undegage amatwiri. Ngiisi byo ngakubwira, ubigire. ");
INSERT INTO flr_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Bwobuno, ugende mu lulya lukuuli lweꞌmbene, undeetere mweꞌbyanahene bibiri íbishishiri. Ngayiji kolera yisho ibyokulya, ngiisi byo ali mu siima. ");
INSERT INTO flr_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ha nyuma, wenyene ukamútwalire byo, gira abilye, anakugashaanire, átazi fwa.» ");
INSERT INTO flr_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yakobo, ti: «E maashi maawe, mukulu wani wa Hesahu, si amagala gooshi gayijwiri kweꞌbikarakara. Si niehe, ndaabyo ngweti! ");
INSERT INTO flr_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Hali ikyanya daata angakengeera ammamaata kwo, anayiji bona kwo ndi mu múlyogooza. Na ho nangagashaniirwi, na mbe nayikululira idaaki.» ");
INSERT INTO flr_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Nyina naye, ti: «E mwana wani, yiri idaaki, leka lingwe kwo. Ngiisi kwo bigaaba kwoshi, unyuvwe. Ugendi ndeetera birya byanahene naaho.» ");
INSERT INTO flr_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Yakobo anakwabaduka, anabileetera nyina. Neꞌri akabibaaga, anabigira mweꞌbyokulya íbiheshiri, nga kwo Hisake asiimiri. ");
INSERT INTO flr_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebeka, mbu ayuse, anayingira mu nyumba, anayabiira mweꞌbyambalwa byoꞌmulimbo byeꞌmwa mugala wage umukulu Hesahu. Yibyo byambalwa, anabiyambika Yakobo mugala wage umuto. ");
INSERT INTO flr_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Zirya mbu zeꞌbyanahene nazo, anaziyabiira, anaziyambika Yakobo ku maboko, na mwiꞌgosi. ");
INSERT INTO flr_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ha nyuma, anayabiira yibyo byokulya íbiheshiri, anayabiira noꞌmukate gwo akagira, anabiheereza Yakobo. ");
INSERT INTO flr_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Uyo Yakobo, anayingira úmuli yishe, anamúbwira: «E daata!» Na wa yishe, ti: «E mwana wani, ndyagagi hano. Wehe we nyandi?» ");
INSERT INTO flr_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakobo, anabeesha, ti: «Nie Hesahu, ifula yawe. Keera nakola nga kwo wambwira. Uvyukage, utee lya ku nyamiishwa yo nayita, unabuli ngashaanira.» ");
INSERT INTO flr_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Hisake, ti: «E mwana, kutagi kwo byaba leero, halinde kino kyanya keera wayita inyamiishwa?» Na wa Yakobo, ti: «Nahano Rurema wawe, angashaanira.» ");
INSERT INTO flr_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Hisake anamúbwira: «E mwana wani, yegeera hano. Ngumamaate, lyo nimenya ku kasiisa, iri we mwana wani Hesahu, kandi iri nanga.» ");
INSERT INTO flr_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakobo anayegeera yishe. Neꞌri yishe akamúmamaata, anadeta: «Izu, liri lya Yakobo, haliko, amaboko gali geꞌmwa Hesahu.» ");
INSERT INTO flr_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Uyo Yakobo, âli koli yambiiti imbu ku maboko. Na bwo âli kola nga mukulu wage wa Hesahu, kyanatuma yishe agamúgashaanira. ");
INSERT INTO flr_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Yishe anashubi múbuuza: «Ka biri ukuli kwo we mugala wani Hesahu?» Naye, ti: «Ee! Nie yehe.» ");
INSERT INTO flr_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yishe anamúbwira: «E mwana wani, njumbirizagya ibyokulya, mbilye, gira ngugashaanire.» Lyeryo, Yakobo anamúshumbiriza byo, analya. Anamúheereza neꞌdivaayi, ananywa. ");
INSERT INTO flr_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Haaho, Hisake anamúbwira: «E mwana wani, nyegeera, umboobere.» ");
INSERT INTO flr_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakobo anayegeera, anahoobera yishe. Ikyanya Hisake akayuvwa ubwehe úbuli ku mirondo yage, anamúgashaanira, ti: «Ubwehe bwoꞌmwana wani, bulyagagi nga muhongolo gweꞌndalo, yo Nahano agashaniiri. ");
INSERT INTO flr_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Aaho! Rurema akizi kumanulira ikimi kya mwiꞌgulu, anakuheereze idaho íriri mweꞌnagiira. Ukizi yeza ingano neꞌdivaayi ku bwingi. ");
INSERT INTO flr_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Abandu beꞌgindi milala, bakizi kukolera. Neꞌbibusi byoshi, bikizi kufukamira ku lushaagwa. Ube mutwali wa beene winyu, naꞌbalumuna baawe, bakizi kufukamira. Ngiisi úgakudaaka, naye akizi daakwa. Na ngiisi úgakugashaanira, naye akizi gashaanirwa.» ");
INSERT INTO flr_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Hisake, mbu ayuse ukugashaanira Yakobo, Yakobo anayami lyoka yaho ali. Lyeryo, Hesahu naye anaba keera alyoka iwa kuhiiva, ");
INSERT INTO flr_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","anabaza ibyokulya binunu, anabitundira yishe, ti: «E daata, uvyukage, utee lya inyama zeꞌnyamiishwa, gira ungashaanire.» ");
INSERT INTO flr_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Yishe anamúbuuza: «Wehe we nyandagi?» Anamúshuvya: «Nie Hesahu, ifula yawe.» ");
INSERT INTO flr_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Uyo Hisake, anatondeera ukulenga mwoꞌmusisi bweneene, anadeta: «Aahago! Nyandi ulya úwandeetera inyama zeꞌnyamiishwa ku kyanya utazi yija? Si keera nazilya! Na buno, keera nayusa ukumúgashaanira. Ee! Agashaanirwa ngana-ngana!» ");
INSERT INTO flr_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Hesahu, mbu ayuvwagwe kwo yishe adeta, anajengeerwa, anatulikira mu luhanga, anabwira yishe: «E maashi daata, nakuyinginga, we kongwa, naani ungashaanirage!» ");
INSERT INTO flr_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Haliko, Hisake anamúshuvya: «Mulumuna wawe, anyijira ku bulyalya. Ye keera nagashaanira ahandu haawe.» ");
INSERT INTO flr_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Hesahu, ti: «Yayewe! Kyo kikatuma agayinikwa iziina Yakobo. Keera akayabiira ubukulu bwani ubugira kabiri, ku njira yoꞌkubeesha. Ubwa mbere, akayabiira ubungulwe bwani. Na buno kandi, keera ayabiira neꞌmigashani yani.» Ha nyuma, anabuuza yishe: «E daata, ka ndaagwo mugashani gwo wanzigira?» ");
INSERT INTO flr_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yishe, ti: «Ulya Yakobo, keera namúgira abe mutwali wawe. Na beene wabo booshi, keera namúsikiiriza bo, babe bakozi baage. Namúheereza ingano neꞌdivaayi. E mwana wani, bikagi kandi byo ngaki kugirira?» ");
INSERT INTO flr_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Hesahu naye, ti: «E daata, ka utangambeereza kiri noꞌmugashani muguma naaho? Maashi, naani, ungashaanire!» Haaho, Hesahu anashubi tulikira mu malira. ");
INSERT INTO flr_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Hisake anamúbwira: «Akaaya kaawe, kagaaba hala niꞌdaho íriri neꞌnagiira, kanabe hala neꞌkimi kya mwiꞌgulu. ");
INSERT INTO flr_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Na kundu ugakizi ramba ku ngooti, haliko ugakizi kolera mulumuna wawe. Kundu kwokwo, ikyanya ugamúyihindulira, lyoki ugaaba wayishwekuula mu butwali bwage.» ");
INSERT INTO flr_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Bwo Hisake akagashaanira Yakobo, kyanatuma Hesahu agabiikira Yakobo inziikira, anahiga, ti: «Daata, kukola kufwa yuku. Ikyanya tugayusa ikigandaaro kyage, lyo ngayita mulumuna wani.» ");
INSERT INTO flr_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Yizo shungi za Hesahu, Rebeka anazimenya. Kwokwo, anahamagala Yakobo, anamúbwira: «E mwana wani, uyiyeke! Mukulu wawe wa Hesahu keera ahiga kwo agakuyita. ");
INSERT INTO flr_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","«Aahago, e mwana wani! Ugirage ngiisi kwo ngakubwira. Yimuka, utibitire i Harani, imwa mwizo wawe wa Labaani. ");
INSERT INTO flr_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ubeere yeyo, halinde uburaakari bwa mukulu wawe buhoohe. ");
INSERT INTO flr_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","«Ikyanya yubwo buraakari bwage bugahooha, agayibagira amahube go ukamúkolera. Haaho, nangutumire umundu, ayiji kuyabiira. Mukuba, ndaloziizi nimùteere mwembi ku mulege-rege muguma.» ");
INSERT INTO flr_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Uyo Rebeka, anagendi bwira Hisake: «Ewe! Yaba bali-kazi baawe baꞌBahiti, keera bakambahaza bweneene. Aahago! Iri Yakobo naye angayiji yangira mu Bahiti, nangakengeera navunika umutima lwoshi.» ");
INSERT INTO flr_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hisake anahamagala Yakobo, gira amúlage, anamúkomeereza: «E mwana wani, utakolwe kwo wayanga mu banyere ba mu kino kihugo kyeꞌKaanani. ");
INSERT INTO flr_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Si ugendage mu nyumba ya shokulu wawe wa Betweri, ulya úkabuta nyoko. Atuuziri mu kihugo kyeꞌMezopotamiya. Neꞌyo munda, mu banyere ba mwizo wawe wa Labaani, uyangage mwo muguma. ");
INSERT INTO flr_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","«Rurema woꞌbushobozi bwoshi, akizi kugashaanira. Ubute yisho, ubute nyoko! Uyushuukage, halinde ube shokuluza waꞌbandu beꞌmilala mingi. ");
INSERT INTO flr_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","«Kino kihugo, Rurema keera akakiheereza Hiburahimu. Na ngiisi kwo âli kizi gashaanira Hiburahimu, na naawe kube kwo agakizi kugashaanira, mwe naꞌbandu beꞌkibusi kyawe. Kundu utuuziri mu kino kihugo nga kinyamahanga, ukalongage ukukigaaza.» ");
INSERT INTO flr_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kwokwo, kwo Hisake akatuma Yakobo mu kihugo kyeꞌMezopotamiya, gira agendi tuula imwa mwizo wage wa Labaani mugala Betweri, Umuharaamu. (Uyo Labaani, ye wâli riiri mushija wa Rebeka. Rebeka naye, ye wâli riiri nyina wa Hesahu na Yakobo.) ");
INSERT INTO flr_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Hesahu âli koli yiji kwo Hisake keera akagashaanira Yakobo, na kwo keera akamútuma mu kihugo kyeꞌMezopotamiya, kwo agendi loogeza yoꞌmukazi. Âli yiji na kweꞌkyanya Hisake akagashaanira Yakobo, anamúkomeereza kwo atakolwe kwo ayanga mu banyere ba mu kihugo kyeꞌKaanani. ");
INSERT INTO flr_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Anamenya na ngiisi kwo Yakobo akasimbaha yishe na nyina, anagenda mu kihugo kyeꞌMezopotamiya. ");
INSERT INTO flr_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Lyeryo, Hesahu anayami sobanukirwa kwo yabo banyere beꞌKaanani batasimisiizi yishe. ");
INSERT INTO flr_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Anayami genda imwa Hishimaheeri mugala Hiburahimu, anayanga munyere wage wa Mahalati, mwali wa Nebayoti woꞌmuzibo. Anamúbiika ku yabo bandi bakaage. ");
INSERT INTO flr_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Kwokwo, Yakobo analyoka i Beeri-Sheba, gira agende i Harani. ");
INSERT INTO flr_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Iri akahika mu njira, anayirirwa, kyanatuma agatoola ibuye, analishegama. ");
INSERT INTO flr_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Neꞌkyanya âli koli huniiri, anabona mu birooto kwoꞌlwingo luyimaaziri kwiꞌdaho. Niꞌtwe lyalwo, lihumiri kwiꞌgulu. Ku lulya lwingo, anabona abaganda ba Rurema, bagweti bagalumanuka kwo, iri banashubi luterama kwo. ");
INSERT INTO flr_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Nahano anayimanga ha butambi lya Yakobo, anamúbwira kwokuno: «Niehe, nie Nahano Rurema wa shokulu wawe Hiburahimu. Nie na Rurema wa yisho Hisake. Lino idaho lyo ugwejiiri kwo, ngakuheereza lyo, mwe naꞌbandu beꞌkibusi kyawe. ");
INSERT INTO flr_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Yabo bandu, banaluguuke, banabaagage kandaharuurwa nga mushenyu, halinde banakwire imbande zooshi zeꞌkihugo. Hiꞌgulu lyawe, na hiꞌgulu lyaꞌbandu ba mu kibusi kyawe, imilala yoshi ya mu kihugo igagashaanirwa. ");
INSERT INTO flr_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","«Yuvwagwa! Tuyamiinwi. Ngiisi ho ugagenda, ngakizi kushuutira. Ha nyuma, na njubi kugalulira mu kino kihugo. Ndâye kujandirire. Neꞌmihango yoshi yo nꞌgakulagaania, ngagikwiza.» ");
INSERT INTO flr_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yakobo mbu asisimuke, anadeta: «Ku kasiisa, Nahano alyagagi hano, ndanashubi yiji.» ");
INSERT INTO flr_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Anashubi deta: «Hano handu, keera handeera ikyoba bweneene. Ku kasiisa, hano iri nyumba ya Rurema. Gunalyagagi nga mulyango gwoꞌkugenda mwiꞌgulu.» ");
INSERT INTO flr_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Shesheezi kare-kare, Yakobo anavyuka, anayabiira lirya ibuye lyo atáshegamiri kwo, analishinga, analitaluula, mu kuliyonera kwaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Yaho handu, anahayinika iziina Beteeri (kuli kudeta: nyumba ya Rurema). Haliko, mu siku ízikalenga, yako kaaya kâli kizi buuzibwa Luuzi. ");
INSERT INTO flr_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Uyo Yakobo, anabiika indahiro, analagaania Rurema kwokuno: «E Rurema, kwoku ngola mu luno lugeezi. Aaho! Tukizi yamanwa. Ukizi ndanga, unakizi mbeereza byo ngaalya, unakizi na nyambika. ");
INSERT INTO flr_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","«E Nahano, iri wangangirira kwokwo, halinde na ngalukire imwa daata ku mutuula, kwokwo lyo ugaaba Rurema wani. ");
INSERT INTO flr_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Yiri ibuye lyo nashinga yaha nga nguliro, ligaaba nyumba yawe. Na ku bindu byoshi byo ugangashaanira, ngakizi kutangira kweꞌkihande kiguma kiꞌkumi.» ");
INSERT INTO flr_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakobo, anagenderera noꞌlugeezi, anahulukira mu bihugo íbiri uluhande lweꞌsheere. ");
INSERT INTO flr_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Neꞌri akalangiiza, anabona ikirigo mu ndagiriro. Haaho haꞌbangere bâli kizi leeta ibibuzi biyiji shyola. Na ku yikyo kyanya, ha butambi lyakyo, hâli vyagiiri inguuli zishatu zeꞌbibuzi. Haliko, kyâli koli tumbikiirwi niꞌbuye lihamu. ");
INSERT INTO flr_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ikyanya yibyo bitugwa byoshi byâli kizi ba keera byakuumana ha kirigo, abangere banakizi kitumbuula kwiꞌbuye, babuli bivwomera, halinde bishyolage. Ha nyuma, banashubi kitumbikira. ");
INSERT INTO flr_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yabo bangere, Yakobo anababuuza: «E beene witu, hayi mwalyoka?» Nabo, ti: «Twalyoka i Harani.» ");
INSERT INTO flr_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Anashubi babuuza: «Ka muyijagi Labaani, mwijukulu Nahoori?» Nabo, ti: «Ee! Tumúyiji.» ");
INSERT INTO flr_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yakobo, ti: «Ka ali mugumaana?» Na wa nabo, ti: «Ee! Langiiza kiri na munyere wage wa Laheeri. Yoliira asholiiri ibibuzi.» ");
INSERT INTO flr_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakobo, ti: «Lolagi! Kakiri kalenge-renge, kitazi ba kyanya kyoꞌkubiika ibibuzi mu lugo. Aaho! Mubiheereze amiiji bishyole, munashubi bigalulira mu ndagiriro.» ");
INSERT INTO flr_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Nabo, ti: «Tutangabiheereza amiiji, neꞌbindi byoshi tutazi bikuumania. Niꞌbuye íritumbikiiri ikirigo, tukwaniini tutee litumbuula.» ");
INSERT INTO flr_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Yakobo, mbu abe akiri mu ganuula na yabo bangere, Laheeri anahikira ho, ali neꞌbibuzi bya yishe, bwo ye wâli riiri mungere wabyo. ");
INSERT INTO flr_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yakobo, mbu abonage muvyala wage wa Laheeri munyere Labaani, kuguma neꞌbibuzi byoꞌyo mwizo wage, anayami genda ha kirigo. Anatumbuula lirya ibuye, anavwomera ibitugwa amiiji. ");
INSERT INTO flr_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ha nyuma, ananyunyuguta Laheeri, anayami yitulikania mu malira. ");
INSERT INTO flr_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakobo anamenyeesa Laheeri kwo alyagagi wa mu mbaga ya yishe, kwo anali mugala Rebeka. Lyeryo, Laheeri anayami tibitira i kaaya, anagendi ganuulira yishe. ");
INSERT INTO flr_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Labaani, mbu ayuvwagwe imyazi hiꞌgulu lya mwihwa wage wa Yakobo, anayami gendi músanganira, anamúhoobera iri anamúnyunyuguta, anamúyegereza mu mwage. Yakobo anatondeera ukuganuulira mwizo wage amagambo gooshi ágakakoleka. ");
INSERT INTO flr_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ha nyuma, Labaani anamúbwira: «Ku kasiisa, uli wa mu mbaga yani, tunali muko muguma.» Kwokwo, Yakobo anamala umwezi gwoshi, ashumbisiri ha mwa mwizo wage. ");
INSERT INTO flr_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Lusiku luguma, Labaani anabwira Yakobo: «E mwihwa wani, kundu ulyagagi wa mu mbaga yani, utangakizi ngolera ku busha. Aaho! Umbwire ngiisi byo ngakizi kuhemba.» ");
INSERT INTO flr_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labaani âli hiiti banyere baage babiri. Umukulu ye Leya. Noꞌmuto ye Laheeri. ");
INSERT INTO flr_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Uyo Leya, âli riiri wa miryezi. Si Laheeri yehe, âli nonosiri. Neꞌkikebe kyage kyâli mu simiisania. ");
INSERT INTO flr_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yakobo anamúvunikira, kyanatuma agabwira Labaani: «Ngakukolera imyaka irinda, gira lyo nyanga Laheeri, munyere wawe umuto.» ");
INSERT INTO flr_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Na wa Labaani, ti: «Uyu Laheeri, ho nangamúgondeesa noꞌmuhalashongo, bulyagagi bwija ube we gamúgonda, tunatuulanwe.» ");
INSERT INTO flr_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kwokwo, Yakobo anakolera Labaani iyo myaka irinda, gira lyo ayanga Laheeri. Halikago, bwoꞌyo Yakobo âli vunikiiri Laheeri bweneene, anabona kweꞌyo myaka irinda, iri nga siku ngerwa naaho. ");
INSERT INTO flr_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ha nyuma, Yakobo anabwira Labaani: «Irya myaka yo ukambwira kwo ngole, keera nꞌgagikwiza. Aaho! Umbeerezagye mukaanie.» ");
INSERT INTO flr_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kwokwo, Labaani, analaalika abandu booshi, anagira ubugeni. ");
INSERT INTO flr_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Iri hikaba hikola hihuuna-huuna, ulya Labaani analungika munyere wage umukulu Leya, imwa Yakobo. Yakobo anamúhisa. ");
INSERT INTO flr_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Uyo Leya, Labaani anamúheereza umuja-kazi Ziripa, gira akizi gendi múkolera. ");
INSERT INTO flr_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Iri bukakya, Yakobo anakanguka, mu kubona kwo ahisa Leya. Kyanatuma agayami gendi buuza Labaani: «E mwizo, makagi gano? Ka ndakakukolera, gira lyo nyanga Laheeri? Aaho! Kituma kikagi wambindurania umukazi?» ");
INSERT INTO flr_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Na wa Labaani, ti: «Invuukira yitu, itatuhangwiri kwo tugondeese umuto, noꞌmukulu akiri ho. ");
INSERT INTO flr_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Utee mala isiku zirinda umúyalisiri. Ha nyuma, tukabuli kuheereza mulumuna wage wa Laheeri. Halikago, ugashubi ngolera igindi myaka irinda.» ");
INSERT INTO flr_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yiryo igambo, Yakobo analiyemeera. Iri akahisagya yizo siku zirinda ayalisiri Leya, Labaani anamúlungikira na Laheeri munyere wage umuto. ");
INSERT INTO flr_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Uyo Laheeri, Labaani anamúheereza umuja-kazi Biriha, gira akizi gendi múkolera. ");
INSERT INTO flr_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Kwokwo, Yakobo anahisa Laheeri naye, anashubi kolera mwizo wage wa Labaani igindi myaka irinda. Ulya Laheeri, anaba ye nakiriri. ");
INSERT INTO flr_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Nahano, iri akabona kwo Leya akorora, anamúheereza ibuta. Si Laheeri yehe, anagumba. ");
INSERT INTO flr_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ikyanya Leya akaheeka inda, anabuta umwana woꞌbutabana, anamúyinika iziina Rubeni, (kuli kudeta: langiiza umwana). Anadeta: «Keera Nahano abona amalibu gaani. Leero, yibanie akola agangunda.» ");
INSERT INTO flr_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Uyo Leya, anashubi heeka inda, anabuta ugundi mwana woꞌbutabana. Uyo mwana, anamúyinika iziina Simyoni, anadeta: «Nahano akayuvwa ngiisi kwo nꞌgakorora, anambeereza kandi ugundi mwana woꞌbutabana.» ");
INSERT INTO flr_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Uyo Leya, anashubi heeka igindi nda, anabuta ugundi mwana woꞌbutabana. Uyo mwana, anamúyinika iziina Laawi, ti: «Leero buno, ngaaba nakiriri. Si keera namúbutira abaana bashatu boꞌbutabana.» ");
INSERT INTO flr_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Yolya Leya kandi, anashubi heeka igindi nda, anabuta ugundi mwana woꞌbutabana. Uyo mwana, anamúyinika iziina Yuda, ti: «Leero, ngola ngayivuga Nahano.» Ha nyuma, Leya, ibuta lyanatee yimanga. ");
INSERT INTO flr_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Laheeri, iri akabona kwo atabuta na Yakobo, anatondeera ukuyuvwirwa mukulu wage wa Leya uluugi. Kyanatuma agabwira Yakobo: «Ewe! Naani, umbutage kwo. Kútali kwokwo, ngaafwa.» ");
INSERT INTO flr_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakobo anamúrakarira, ti: «Ka nie Rurema? Si ye kakuyima ibuta!» ");
INSERT INTO flr_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Laheeri, ti: «Aaho! Umuja-kazi wani Biriha, yoyu. Umúyangage, gira akizi mbutira abaana. Na ku njira yage, naani ngalonge abaana.» ");
INSERT INTO flr_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kwokwo, Laheeri anasikiiriza Yakobo umuja-kazi wage Biriha, abaagage mukaage. Neꞌri Yakobo akamúyanga, ");
INSERT INTO flr_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Biriha anaheeka inda, anamúbutira umwana woꞌbutabana. ");
INSERT INTO flr_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ulya Laheeri, ti: «Leero, Rurema ayuvwa amalira gaani. Keera andwira ulubaaja, mu kumbeereza naani umwana woꞌbutabana.» Kyanatuma agamúyinika iziina Daani, (kuli kudeta: atwa ulubaaja). ");
INSERT INTO flr_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Uyo Biriha, anashubi heeka inda, anabutira Yakobo umwana wa kabiri woꞌbutabana. ");
INSERT INTO flr_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Laheeri anadeta: «Twakukurana na mukulu wani, nanamúhima.» Uyo mwana, anamúyinika iziina Nafutaali, (kuli kudeta: twakubana imihuku). ");
INSERT INTO flr_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Uyo Leya, iri akabona kwo atakiri mu buta, anayabiira Ziripa, umuja-kazi wage, anamúheereza Yakobo, gira amúyange. ");
INSERT INTO flr_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Uyo Ziripa, anabutira Yakobo umwana woꞌbutabana. ");
INSERT INTO flr_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leya anadeta: «Maana zino!» Kyanatuma agayinika uyo mwana iziina Gaadi, (kuli kudeta: maana nyiija). ");
INSERT INTO flr_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Uyo Ziripa, umuja-kazi wa Leya, anashubi butira Yakobo umwana wa kabiri woꞌbutabana. ");
INSERT INTO flr_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leya anashubi deta: «Emwe, buhiirwa! Buno, abiitu bakazi bakola bagakizi deta kwo ndi muhiirwa.» Kyanatuma agamúyinika iziina Hasheeri. ");
INSERT INTO flr_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ikyanya kyoꞌkugesha ingano iri kikahika, Rubeni anagenda iwa ndalo, analeeta yoꞌruvuto, analuheereza nyina, Leya. Haliko, Laheeri anabwira Leya: «We kongwa! Umbeereze ku yulu ruvuto lwa mugala wawe.» ");
INSERT INTO flr_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ulya Leya, ti: «Ewe! Ka utazi sirwa, ukunnyaga yibanie? Aahago! Ka ukoli loziizi kwo nguheereze kiri noꞌruvuto lwa mugala wani?» Laheeri, ti: «Iri wangambeereza ku yulu ruvuto lwa mugala wawe, zeene Yakobo agalaala mu mwawe.» ");
INSERT INTO flr_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kabigingwe, iri Yakobo akafuluka, Leya anagendi múyitanga, anamúbwira: «Zeene, ukwaniini ulaale mu mwani, bwo nakulonga mu kutanga uruvuto lwa mugala wani.» Bwobwo bushigi, Yakobo analaala mwo. ");
INSERT INTO flr_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Amahuuno ga Leya, Rurema anagayuvwa. Leya anashubi heeka inda, anabutira Yakobo umwana wa kataanu woꞌbutabana. ");
INSERT INTO flr_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Leya anadeta: «Bwo nꞌgaheereza yibanie umuja-kazi wani, Rurema keera kandi ambemba.» Kyanatuma uyo mwana, agamúyinika iziina Hisakaari. ");
INSERT INTO flr_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Uyo Leya anashubi heeka inda, anabutira Yakobo umwana wa kalindatu woꞌbutabana, ");
INSERT INTO flr_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","anadeta: «Keera Rurema ambemba bwija. Na buno, yibanie akola agakizi nzimbaha, bwo keera namúbutira abaana balindatu boꞌbutabana.» Uyo mwana, anamúyinika iziina Zabulooni. ");
INSERT INTO flr_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Na mu kuheza, anabuta umwana woꞌbunyere, anamúyinika iziina Dina. ");
INSERT INTO flr_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ha nyuma, Laheeri naye, Rurema anamúkengeera. Anashuvya amahuuno gaage, mu kumúheereza ibuta. ");
INSERT INTO flr_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ikyanya uyo Laheeri akaheeka inda, anabuta umwana woꞌbutabana, anadeta: «Leero, Rurema andyosa ishoni.» ");
INSERT INTO flr_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Uyo mwana, anamúyinika iziina Yusefu, ti: «Nahano anyushuulage ugundi mwana woꞌbutabana.» ");
INSERT INTO flr_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Laheeri, iri akaba keera abuta Yusefu, Yakobo anabwira Labaani: «E mwizo, umbanguulage ngalukire i kaaya, mu kihugo kiitu. ");
INSERT INTO flr_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Umbeereze bakaanie, naꞌbaana baani. Si keera nꞌgabalonga mu kukukolera. Wenyene uyiji-yiji ngiisi byo ukalonga mu mukolwa gwani. Kwokwo, umbanguulage, mbataahane.» ");
INSERT INTO flr_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Haliko Labaani anashuvya: «Nakuyinginga, we kongwa, utee bwatala. Imbuko zambwira kwo hiꞌgulu lyawe, kyo kitumiri Nahano akangashaanira. ");
INSERT INTO flr_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Umbwirage ngiisi byo ngakuhemba, na ngizi kuheereza byo.» ");
INSERT INTO flr_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakobo, ti: «Wenyene uyiji ngiisi kwo nâli kizi kukolera. Ikyanya nâli kizi langa ibitugwa byawe, uyiji-yiji ngiisi kwo bikayolola. ");
INSERT INTO flr_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Si ikyanya ndâli zaazi yija, ibindu byawe byâli keehiri. Halikago, ukulyokera ho nꞌgayingirira mu mwawe, Nahano anakugashaanira, byanaluguuka. Aaho! Kyanya kikagi kyo ngakolera iyani mbaga?» ");
INSERT INTO flr_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Na wa Labaani, ti: «Bikagi byo namu kuheereza?» Yakobo, ti: «Ndaabyo byo ugambeereza. Haliko, iri wangangirira byo ngakubwira, ngashubi kuragirira, na njubi kuya-kuya ibitugwa byawe. ");
INSERT INTO flr_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","«Aahago! Zeene, umbanguule nyingire mu bitugwa byawe, nyobore mwo ngiisi kibuzi kyeꞌbikeba-bikeba, na ngiisi kyoꞌmukara, kuguma na ngiisi mbene yoꞌmuyezi, kandi iri yeꞌbihuuga. Byebyo, byo bigaaba bihembo byani. ");
INSERT INTO flr_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","«Ha nyuma, yibyo bihembo byani, ikyanya ugayiji bitanduula, lyo ugaamenya ku kasiisa kwo ndi mu deta ukuli. Mu bitugwa byani, ngiisi mbene ítagaaba yoꞌmuyezi, kandi iri bihuuga, na ngiisi kibuzi íkitagaaba kyoꞌmukara, lyo ugaamenya kwo nakizimba.» ");
INSERT INTO flr_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Uyo Labaani, ti: «Bwija! Ngiisi byo wadeta, nabiyemeera.» ");
INSERT INTO flr_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Gwogwo mulege-rege, ulya Labaani yenyene anayilala mu bitugwa, anayobora mweꞌbihebe byoshi byeꞌbihuuga, kandi iri byeꞌmiyezi, naꞌmabuguma gooshi geꞌbihuuga kandi iri geꞌmiyezi, neꞌbibuzi byoshi byoꞌmukara. Yibyo byoshi, anabisikiiriza bagala baage. ");
INSERT INTO flr_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ha nyuma, uyo Labaani na bagala baage, banabitwala hala na Yakobo, ahandu hoꞌlugeezi lweꞌsiku zishatu. Ibitugwa bya Labaani íbikasigala, Yakobo anasigala ali mu bilanga. ");
INSERT INTO flr_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Uyo Yakobo, anatema ingoni mbishi, ku matavi geꞌkiti kyoꞌmulubuna, na ku kiti kyeꞌloozi, na ku kiti kyoꞌmwaramooni. Anaziyubula bikeba-bikeba, zanakizi ba neꞌbilabike byeru. ");
INSERT INTO flr_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ku kyanya ibitugwa byâli kizi yiji shyola mu muvuli, Yakobo âli kizi yabiira zirya ngoni zo akayubula, anazilambike mu miiji ágali mu muvuli, imbere lyeꞌbitugwa. Mukuba, ikyanya ibitugwa byâli kizi yiji shyola, byâli kizi yami linda. ");
INSERT INTO flr_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ikyanya byâli kizi ba imbere lya yizo ngoni, lyo byanâli kizi yami yima. Kwokwo, yibyo bitugwa byanakizi buta ibyanahene byeꞌbihuuga, kandi iri byoꞌmuyezi, neꞌbyanabuzi byeꞌbikeba-bikeba. ");
INSERT INTO flr_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yakobo anayobora ibibuzi mu mbene. Neꞌkyanya kyoꞌkuyima, Yakobo âli kizi yimiisa ibitugwa bya Labaani ku bipanga byeꞌbikeba-bikeba, na byoꞌmukara. Kwiꞌyo njira, byâli kizi buta ibyanabuzi byeꞌbikeba-bikeba, na byoꞌmukara. Kwokwo, ibitugwa byage byanagenderera ukuyushuuka, anakizi bihandula ku bitugwa bya Labaani. ");
INSERT INTO flr_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ibitugwa íbishishiri, ikyanya byâli kizi linda, uyo Yakobo anabiikage zirya ngoni mu muvuli gwo byâli kizi shyolera mwo, gira biyimire imbere lyazo. ");
INSERT INTO flr_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Haliko, ku bitugwa byeꞌmijambiira, atâli kizi zibiika. Kwokwo, Labaani anaba ye gakizi ba neꞌbitugwa byoꞌmujambiira, na Yakobo anakizi ba na íbishishiri. ");
INSERT INTO flr_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Iri hakatama, Yakobo anayiji ba mugale bweneene. Âli riiri neꞌnguuli zeꞌbibuzi, na zeꞌmbene, neꞌza bapunda, na zeꞌngamiya, kuguma naꞌbaja, kiri naꞌbaja-kazi. ");
INSERT INTO flr_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakobo anayuvwa umwazi, kwo bagala Labaani bagweti bagayidodomba: «Si ibindu byoshi bya daata, muvyala witu wa Yakobo keera abigaaza! Na buno, akola mugale bweneene.» ");
INSERT INTO flr_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakobo anabona kwo Labaani atakiri mu múshagalukira nga kwo âli kizi gira ubwa mbere. ");
INSERT INTO flr_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Ha nyuma, Nahano anabwira Yakobo kwokuno: «Ugalukirage mu kihugo kya bashokuluza baawe, na mu mbaga yawe, bwo tuyamiinwi.» ");
INSERT INTO flr_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kwokwo, Yakobo anatumira bakaage, Laheeri na Leya, kwo bamúgwane mu ndagiriro, ho âli gishiri. ");
INSERT INTO flr_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Neꞌri bakahika, anababwira: «Nabona kwo mwizo wani atakiri mu njagalukira nga kwo âli kizi gira. Kundu kwokwo, Rurema wa daata, tuyamiinwi. ");
INSERT INTO flr_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Muyiji kwo mwizo wani, nꞌgamúkolera neꞌmisi yani yoshi. ");
INSERT INTO flr_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Halikago, keera andeba mu kuhindurania ikihembo kyani ubugira kali ikumi. Kundu kwokwo, Rurema atakamúhanguula kwo angomeerese. ");
INSERT INTO flr_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","«Mwizo, iri angadesiri: “Ibitugwa byoꞌmuyezi, byo bigaaba kihembo kyawe”, kwokwo ibitugwa byoshi, binayami buta imiyezi. Neꞌri angadesiri: “Ibitugwa byeꞌbihuuga, byo bigaaba kihembo kyawe”, haaho ibitugwa byoshi, binayami buta ibihuuga. ");
INSERT INTO flr_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kwokwo, kwo Rurema akayabiira ibitugwa bya mwizo, anabimbeereza. ");
INSERT INTO flr_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Ikyanya ibitugwa byâli kizi linda, nanaloota. Mu yibyo birooto, nanabona kweꞌkyanya ibihebe biri mu yimya, byoshi biri byeꞌbihuuga, na byeꞌmiyezi, neꞌbipanga byeꞌbikeba-bikeba. ");
INSERT INTO flr_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Na mu byebyo birooto, umuganda wa Rurema anambamagala: “E Yakobo!” Nanamúyitaba: “E waliha, nguteziri amatwiri.” ");
INSERT INTO flr_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","«Anambwira: “Langiiza! Ibihebe bikola mu yimya byeꞌbihuuga, na byeꞌmiyezi, neꞌbipanga byeꞌbikeba-bikeba. Na íbyatuma nagira kwoku, bwo nabona ngiisi byo Labaani ali mu kugirira. ");
INSERT INTO flr_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Niehe, nie Rurema úkakuhulukira kwo i Beteeri, halya ukashinga lirya ibuye, wanaliyonera kwaꞌmavuta, mu kulitaluula. Ho ukanambiikira indahiro. Na buno, uyami yimuka mu kino kihugo, unagalukire mu kihugo kyo ukabutirwa mwo.”» ");
INSERT INTO flr_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Uyo Laheeri, bo na Leya, banashuvya Yakobo: «Twehe, mu nyumba ya daata, ndaahyo twangaki hyana mwo. ");
INSERT INTO flr_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Keera akatugondeesa, analya bindu byoshi. Kyo kitumiri akoli tubwinagi naaho nga binyamahanga. ");
INSERT INTO flr_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ibindu byoshi byo Rurema akayabiira daata, bishuba bindu biitu, twe naꞌbaana biitu. Aaho! Ngiisi byo Rurema akubwira, ubigirage.» ");
INSERT INTO flr_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Kwokwo, Yakobo anayilingikania, anashonia bagala baage na bakaage ku ngamiya. ");
INSERT INTO flr_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Anayabiira ibitugwa byage byoshi, kuguma neꞌbindi byoshi byo akalonga i Mezopotamiya, anabitwala. Anashokola injira yoꞌkugalukira mu kihugo kyeꞌKaanani, imunda yishe Hisake. ");
INSERT INTO flr_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Neꞌkyanya Labaani akagendi kema ibibuzi byage ubwoya, Laheeri analonga ubulyo bwoꞌkumúzimba imigisi yage. ");
INSERT INTO flr_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Kwokwo, kwoꞌyo Yakobo akateba Labaani, anayami yongoloka, buzira kumúseezera, ");
INSERT INTO flr_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","anapuumukana ibindu byage byoshi, anajabuka ulwiji Hefuraati, anashonga iwa migazi yeꞌGiryadi. ");
INSERT INTO flr_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Yakobo, iri akaba keera agira isiku zishatu akoli geeziri, Labaani anabwirwa kwo Yakobo apuumuka. ");
INSERT INTO flr_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kwokwo, Labaani anakuumania beene wabo, banalandiriza Yakobo. Ha nyuma lyeꞌsiku zirinda, banamúhumaanana mu migazi yeꞌGiryadi. ");
INSERT INTO flr_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Halikago mu bushigi, Rurema anayijira Labaani, Umuharaamu, mu birooto, anamúbwira: «Uloleekeze bwija. Utakolwe kwo wabwira Yakobo igambo kiri neꞌliguma, liba libi, kandi iri liija.» ");
INSERT INTO flr_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Kwokwo, Labaani anahumaanana Yakobo mu migazi yeꞌGiryadi, ho Yakobo âli mali gwanwa ashinga iheema. Labaani naye, bo na beene wabo, nabo banashinga mwaꞌmaheema gaabo. ");
INSERT INTO flr_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Uyo Labaani anabwira Yakobo: «Ewe! Maki gano wangirira? Si wandeba, wanaleeta banyere baani nga ábagwatwa imbira mwiꞌzibo! ");
INSERT INTO flr_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Kituma kikagi ukanyongoloka, wanandeba? Si utakammenyeesa, gira nguseezere mu kati koꞌbushambaale, mu kukulakiza ingoma, neꞌnanga. ");
INSERT INTO flr_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Utakambeereza ikyanya kyoꞌkuseezera banyere baani, kandi iri bijukulu baani, mbu mbanyunyugute. Mu kugira kwokwo, ukahwijikala ngana-ngana! ");
INSERT INTO flr_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","«Mbiitagi ubushobozi bwoꞌkukugira buligo. Haliko, mu bushigi bwa bigingo, Rurema wa yisho Hisake ambwira: “Uloleekeze bwija, utakolwe kwo wabwira Yakobo igambo kiri neꞌliguma, liba libi, kandi iri liija.” ");
INSERT INTO flr_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nyiji kwo ukoli kumbwiri yisho bweneene, kyo kikatuma ukayongoloka. Kundu kwokwo, kituma kikagi ukagenda wazimba imigisi yani?» ");
INSERT INTO flr_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakobo, ti: «Nꞌgatona kwo wanganyaga bakaanie. ");
INSERT INTO flr_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Halikago, ku biloziri imigisi yawe, ngiisi ye ugagwana úgihiiti, ayami yitwa ngana. Imbere lya bano beene winyu, ulolage bwija mwiꞌyi miteekerwa, iri hangaba halyagagi kindu kyawe kyo ngweti. Neꞌri wangakibona ukiyabiire, we nakyo.» (Ku yikyo kyanya, Yakobo atâli yiji kwo Laheeri akayija azimba imigisi ya Labaani.) ");
INSERT INTO flr_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kwokwo, Labaani analooza imigisi yage mwiꞌheema lya Yakobo, na mwiꞌheema lya Leya, na mu lya balya baja-kazi bombi, atanagibona. Iri akahuluka mwiꞌheema lya Leya, anagendi yingira mu lya Laheeri. ");
INSERT INTO flr_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Uyo Laheeri, ye kanyomboola iyo migisi. Âli gibishiri iꞌdako lyeꞌbyajo byo bali mu bwatala kwo ku ngamiya. Iyo migisi, anagibwatala kwo. Labaani, anagilooza-looza mwiꞌheema lyoshi, atanagibona. ");
INSERT INTO flr_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Uyo Laheeri, anabwira yishe: «E daata, ungejeerere! Utayagalwe, ndaakwo nangayimanga imbere lyawe, bwo ndi mu lwaꞌbakazi.» Kwokwo, kwo Labaani âli kizi looza iyo migisi yage, atanagibona. ");
INSERT INTO flr_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Haaho, Yakobo anaraakara, analongooza Labaani, ti: «Aaho! Buhube bukagi nagira, halinde uyije undambiriziizi kwo mwene yuku? ");
INSERT INTO flr_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Buno, bwo keera wagukumula imiteekerwa yani yoshi, kindu kiki kyeꞌmwawe kyo wagigwana mwo? Ukiyerekanage imbere lya beene witu na beene winyu, gira batuhambuule. ");
INSERT INTO flr_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","«Si tukahisa imyaka makumi gabiri, tutuliinwi. Na mwiꞌyo myaka yoshi, ndaayo mbene yawe, kandi iri kibuzi, íkikasholola. Na mu buso bwawe, ndaalwo lusiku lwo nꞌgakulyalyania mweꞌkipanga. ");
INSERT INTO flr_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ndaanalwo lusiku kiri noꞌluguma, lwo nꞌgakuleetera ibitetereza byeꞌbitugwa byawe, mbu byaliibwa neꞌnyamiishwa. Haliko, nienyene nâli kizi kuliha byo. Ikitugwa íkyâli kizi zimbwa mu bushigi, kandi iri mwiꞌzuuba, wâli kizi kindihiisa. ");
INSERT INTO flr_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","«Mwiꞌzuuba, nâli kizi yitubanula. Na mu bushigi, nâli kizi kayuula, halinde na mbule iro. ");
INSERT INTO flr_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nꞌgahisa imyaka makumi gabiri nduuziri mu mwawe. Nꞌgatee kukolera imyaka ikumi niꞌna, mu kugonda banyere baawe bombi. Neꞌmyaka ndatu, ndi mungere weꞌbitugwa byawe. Kundu kwokwo, ukahindurania ibihembo byani ubugira kali ikumi. ");
INSERT INTO flr_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","«Rurema, ye Rurema wa shokulu Hiburahimu. Kiri na daata Hisake, âli kizi múyoboha. Aahago! Átaki nyuvwirwe indengeerwa, ku kasiisa wâli ugandeka ndaahe maboko mamaata. Haliko, anabona amalibu gaani, neꞌmikolwa yo nâli kizi kola naꞌmaboko gaani. Kyo kyatuma mu bushigi bwa bigingo, akukambira.» ");
INSERT INTO flr_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Labaani, ti: «Yaba bakaawe, balyagagi baana baani. Na yaba baana baabo, nabo bali beꞌmwani. Kiri na yibi bitugwa, biri byeꞌmwani. Yibi byoshi byo ubwini, biri byeꞌmwani. Haliko, ukulyokera zeene, ku yaba banyere baani, na ku yaba bijukulu baani, ndaalyo ngi shobwiri ukugira. ");
INSERT INTO flr_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Buno, ugirage tunywane ikihango. Yikyo kihango, bube bumasi ha kati kiitu twembi.» ");
INSERT INTO flr_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kwokwo, Yakobo analengeza ibuye liguma, analishinga nga nguliro yoꞌbukengeeze. ");
INSERT INTO flr_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Anabwira beene wabo: «Mukuumanie agandi mabuye.» Neꞌri bakagakuumania, banagalunda yaho. Gaago mabuye, go bakanaliira kweꞌbyokulya. ");
INSERT INTO flr_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Yikyo kilundo, Labaani anakiyinika iziina Yegaari-Sahaduta (kuli kudeta: kilundo kyoꞌkukengeezania). Yakobo anakiyinika iziina Galeedi. ");
INSERT INTO flr_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Uyo Labaani anabwira Yakobo: «Kino kilundo kyaꞌmabuye, zeene bulyagagi bumasi ha kati kiitu.» Kwokwo, banakiyinika iziina Galeedi. ");
INSERT INTO flr_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Banakiyinika niꞌziina Misipa, (kuli kudeta: kalaliizi). Mukuba, Labaani akadeta: «Amasu ga Nahano gakizi tuyama kwo, kiri na ku kyanya tutakiri kuguma. ");
INSERT INTO flr_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Banyere baani, iri wangabalibuza, kandi iri ubahalika, kwokwo umenyage kwo mu kati kiitu, ndaako kandi kamasi, átali Rurema yenyene.» ");
INSERT INTO flr_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Uyo Labaani anashubi bwira Yakobo: «Lolaga kino kilundo kyaꞌmabuye, neꞌyi nguliro nashinga. Nabishinga ha kati kiitu. ");
INSERT INTO flr_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kino kilundo, neꞌyi nguliro, bulyagagi bumasi, keera nanabibiika kweꞌndahiro, kwo ndâye ki gibalale, mbu nyiji kuteera. Na naawe kwakundi, utâye ki gibalale, mbu uyiji ndeera. ");
INSERT INTO flr_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kwokwo, Rurema wa Hiburahimu, na wa Nahoori, bakizi tuhambuula.» Kwokwo, uyo Yakobo anabiika indahiro kwiꞌziina lya Rurema. Anali ye yishe Hisake âli kizi yoboha. ");
INSERT INTO flr_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ha nyuma, Yakobo anahatangira ituulo, anahamagala beene wabo, kwo bayiji shangiira ibyokulya. Neꞌri bakaba keera bayusa ukulya, banalaala ho. ");
INSERT INTO flr_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Shesheezi kare-kare, Labaani anavyuka, anagenda áhali abijukulu, na banyere baage. Neꞌri akabanyunyuguta, anabaseezera, abuli taaha. ");
INSERT INTO flr_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yakobo naye, anashokola injira yoꞌkugenda mu kihugo kyo akabutirwa mwo. Neꞌri akaba akola mu lugeezi, anahulukirwa kwo naꞌbaganda ba Rurema. ");
INSERT INTO flr_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Mbu ababonage, anadeta: «Ku kasiisa, hano iri ishumbi ya Rurema.» Kyanatuma yaho handu, agahayinika iziina Mahanayimu, (kuli kudeta: ishumbi zibiri). ");
INSERT INTO flr_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yakobo anatee tuma abandu imwa mukulu wage wa Hesahu, mu kaaya keꞌSeyiri, mu kihugo kyeꞌHedoomu. ");
INSERT INTO flr_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Yabo bandu, anagenda abakomeereza, ti: «Mugendi bwira nahamwitu Hesahu kwokuno: “Umukozi wawe Yakobo, atutuma ti: Nꞌgatibitira imwa mwizo witu wa Labaani, nanatuula yo isiku nyingi. Na buno, ngola mu galuka. ");
INSERT INTO flr_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ngoli hiitagi ubuso bweꞌngaavu, na úbwa bapunda, neꞌnguuli zeꞌbibuzi, na zeꞌmbene. Mbiiti naꞌbaja, kiri naꞌbaja-kazi. E nahamwitu, íbyatuma nakutumira yabo bandu, gira bagwanwe bakumenyeesa kwo ngola mu njira, halinde ukanyegereze bwija.”» ");
INSERT INTO flr_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ikyanya Yakobo akabatuma, banagenda. Neꞌri bakagaluka, banabwira Yakobo: «Twahika imwa mukulu wawe wa Hesahu. Naye buno, akoli hiiti abashosi magana gana boꞌkuyiji kusanganira.» ");
INSERT INTO flr_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yakobo, mbu ayuvwagwe kwokwo, anatondeera ukujuguma. Abandu bo bâli ririinwi, anababera mwo biso bibiri. Anahandula neꞌbibuzi, neꞌbindi bitugwa, kiri neꞌngamiya. ");
INSERT INTO flr_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Mukuba, akatona, ti: «Hesahu, iri angayiji teera ikiso kiguma, anakisivye, ikindi kikafuuke.» ");
INSERT INTO flr_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ha nyuma, Yakobo anahuuna, ti: «E Rurema wa shokulu Hiburahimu, we na Rurema wa daata Hisake! E Nahano, we kambwira: “Galukira mu kihugo kyawe, na mu beene winyu. Ngakizi kutabaala.” ");
INSERT INTO flr_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","«Kwokwo, ndi mukozi wawe. Keera ukanyereka amiija mu kuyemeerana. Yibyo byoshi, ndabikwaniini, kiri neꞌhiniini. Ikyanya nꞌgajabuka ulwiji Yorodaani, ndaakyo kindu nâli fumbiiti, ha nyuma lyeꞌngoni naaho. Si mu kugaluka, ngoli hiiti ibiso bibiri. ");
INSERT INTO flr_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","«Ku yukwo nakuyinginga, ungizagye mu maboko ga mukulu wani Hesahu. Mukuba, ngoli yobohiri kwo agayiji ndeera, ananyite na bakaanie, kiri naꞌbaana. ");
INSERT INTO flr_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Kundu kwokwo, ukandagaania kwo ugakizi ndabaala. Wanadeta kwaꞌbandu ba mwiꞌkondo lyani, bagaaba kandaharuurwa, nga mushenyu úguli ku nyaaja.» ");
INSERT INTO flr_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yubwo bushigi, Yakobo analaala yaho. Na mu bitugwa byage, anahandula mwo byo agatengula mukulu wage wa Hesahu. ");
INSERT INTO flr_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Mu mbene, anayabiira mwaꞌmabuguma magana gabiri, neꞌbihebe makumi gabiri. Na mu bibuzi, anayabiira mwaꞌmabuguma magana gabiri, neꞌbipanga makumi gabiri. ");
INSERT INTO flr_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Mu ngamiya, anayabiira mwaꞌmabuguma makumi gashatu, ágali mu yoza. Na mu ngaavu, anayabiira mwaꞌmabuguma makumi gana, neꞌshuuli ikumi. Na mu bapunda, anayabiira mwaꞌmabuguma makumi gabiri, neꞌfiizi ikumi. ");
INSERT INTO flr_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yibyo byoshi, anabisikiiriza abakozi baage, ngiisi muguma neꞌkiso kyage, anababwira: «Mugwanwe imbere lyani, munakizi genda ndambulira.» ");
INSERT INTO flr_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Umukozi úwâli sholiiri ubuso bwa mbere, Yakobo anamúkomeereza, ti: «Ikyanya mugagwanana na mukulu wani wa Hesahu, anakubuuze: “Ulyagagi mukozi wa nyandi? Unali mu genda hayi? Na yibi bitugwa byo usholiiri, biri byeꞌmwa nyandi?” ");
INSERT INTO flr_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Unamúshuvye: “E nahamwitu Hesahu, bino bitugwa byo njoliiri, biryagagi byoꞌmukozi wawe Yakobo, binali byo akutengula. Na yenyene atushalagiiri.”» ");
INSERT INTO flr_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Anakomeereza kandi ábâli sholiiri ubuso bwa kabiri, noꞌbwa kashatu, kuguma naꞌbandi booshi ábâli sholiiri. Anababwira: «Ikyanya mugagwanana na nahamwitu Hesahu, mukamúbwire gaago-gaago magambo. ");
INSERT INTO flr_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Neꞌngingwe ya byoshi, mugamúbwira: “Umukozi wawe Yakobo, atushalagiiri.”» Mukuba, Yakobo âli toniri, ti: «Nga nangatee mútumira ulutengu, lwangagwanwa lwamúhoohya. Kwokwo, ikyanya tugabonaana amasu ku gandi, ngeeka anganyakiira.» ");
INSERT INTO flr_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kwokwo, birya bindu byoshi byanagwanwa imbere. Haliko Yakobo yenyene, analaala haaho mu shumbi lyage. ");
INSERT INTO flr_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","24","Bwobwo bushigi, Yakobo anavyuka, anayabiira bakaage bombi, na balya baja-kazi bombi, naꞌbaana baage ikumi na muguma, kuguma neꞌbindu byage byoshi, anabajabula mu kyambu kyeꞌYaboki. ");
INSERT INTO flr_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Si yehe, anasigala. Yaho i kajabo, hanayija mundu muguma. Uyo mundu, anakizi kukurana na Yakobo, halinde ku lukula. ");
INSERT INTO flr_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Mbu abonage kwo ayabirwa ukumúkuba, anamúhuma kwiꞌhigi, lyanahiguka. ");
INSERT INTO flr_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Iri hakatama, uyo mundu anamúbwira: «Keera bwatejuukana. Undiikage, maashi, gira ngende.» Haliko, Yakobo, ti: «Nanga! Ndagakuliika, útazi ngashaanira.» ");
INSERT INTO flr_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Uyo mundu, ti: «Iziina lyawe we nyandi?» Yakobo, ti: «Nie Yakobo!» ");
INSERT INTO flr_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Uyo mundu, ti: «Utagakizi ki buuzibwa Yakobo. Si we kola Hisiraheeri, (kuli kudeta: akukurana na Rurema). Mukuba keera wakukurana na Rurema, kiri naꞌbandu, wanabahima.» ");
INSERT INTO flr_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Uyo Yakobo, ti: «E Nahamwitu, nakuyinginga, umbwirage iziina lyawe.» Haliko, uyo mundu, ti: «Kituma kiki wambuuza iziina lyani?» Ha nyuma, uyo mundu anagashaanira Yakobo. ");
INSERT INTO flr_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yaho handu, Yakobo anahayinika iziina Penweri, (kuli kudeta: malanga ga Rurema), iri anadeta: «Nabona Rurema masu ku gandi, ndanafwa.» ");
INSERT INTO flr_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Uyo Yakobo, ikyanya akaba akola mu lyoka yaho i Penweri, izuuba lyanatunduuka. Anakizi genda akola mu kunira, bwiꞌhigi likahiguka. ");
INSERT INTO flr_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Kyo kitumiri halinde zeene, Abahisiraheeri batali mu lya inyama yiꞌkunyu, bwoꞌlya mundu akahuma Yakobo kwiꞌhigi. ");
INSERT INTO flr_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Iri Yakobo akayinamula amasu, anabona Hesahu agweti agayija, alyagagi na balya bashosi baage magana gana. Lyeryo, anayami sikiiriza Leya abaana baage, na Laheeri abeꞌmwage. Naꞌbaja-kazi bombi, babeere haabo. ");
INSERT INTO flr_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Yabo baja-kazi bombi, naꞌbaana baabo, anababiika imbere. Anakulikiza kwo Leya, naꞌbaana baage. Noꞌbuzinda, anakulikiza kwo Laheeri, na mugala wage wa Yusefu. ");
INSERT INTO flr_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Haliko Yakobo yenyene, anagenda imbere lyabo. Neꞌri akaba akola bu hika hoofi lyoꞌlya mukulu wage, anafukama ubugira kalinda, iri anahisa amalanga haashi. Kwokwo, kwo akamúheereza ulushaagwa. ");
INSERT INTO flr_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Halikago, Hesahu anakwabaduka, anagendi músanganira. Neꞌri akahika ho ali, anamúhoobera, anamúnyunyuguta. Bombi, banayami tulikira mu malira. ");
INSERT INTO flr_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Uyo Hesahu, iri akayinamula amasu, anabona abakazi naꞌbaana, anabuuza Yakobo: «Banyandi yaba muliriinwi?» Yakobo, ti: «Yaba, bali baana bo Rurema akambeereza ku lukogo lwage.» ");
INSERT INTO flr_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Ha nyuma, balya baja-kazi bo naꞌbaana baabo, banayegeera Hesahu, banayinama mu kumúheereza ulushaagwa. ");
INSERT INTO flr_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leya naꞌbaana baage, nabo banayegeera, banayinama imbere lyage. Buzinda, Laheeri na mugala wage wa Yusefu, banayija. Nabo, banayinama imbere lyage. ");
INSERT INTO flr_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Lyeryo, Hesahu anabuuza: «Aaho! Bulya buso bwoshi bwo nagwana mu njira, bulyagagi bwa biki?» Yakobo, ti: «E mukulu wani, yibyo, nakuheereza byo, lyo unyakiira bwija.» ");
INSERT INTO flr_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Hesahu, ti: «E mulumuna wani, si ngoli hiiti ibindu bingi. Ubeerane ibindu byawe.» ");
INSERT INTO flr_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakobo, ti: «Iri wangaba wangejeerera mu kati koꞌkuli, nakuyinginga, unyabiirirage yulwo lutengu. Ee! Bwo wanyakiira ku mutima úgushenguusiri, ukubona amalanga gaawe naaho, kuli ngoꞌkubona amalanga ga Rurema yenyene. ");
INSERT INTO flr_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","E mukulu wani, bino nakuleetera, nakuyinginga, we kongwa, ubinyabiirire. Si kiri na naani kwakundi, Rurema keera akangashaanira, na ngoli hiiti ibindu bingi.» Kwokwo, kwo Yakobo akalembereza Hesahu, halinde anabiyabiira. ");
INSERT INTO flr_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Ha nyuma, Hesahu anabwira Yakobo: «E yaga, tutaahage, ndagaki kusiga.» ");
INSERT INTO flr_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yakobo naye, ti: «E nahamwitu, ubwinagi kwo yaba baana bo mbiiti, tukiri tuboojo. Neꞌbitugwa byo njoliiri, bikiri mu yoza. Ngwaniini ngizi bilanga. Yibi bitugwa, iri nangabitwala kangubi-ngubi, byangakengeera byayami mala ku lusiku luguma. ");
INSERT INTO flr_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Nakuyinginga, we kongwa, ugwanwe. Niehe ngayija ndi mu yitonda, ukukulikirana noꞌlugeezi lweꞌbitugwa naꞌbaana, halinde ku kyanya ngaahika iyo munda imwawe, mu kihugo kyeꞌSeyiri.» ");
INSERT INTO flr_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Hesahu, ti: «Bwangabiiri buhiirwa ngusigire ku bano bandu baani.» Haliko Yakobo, ti: «E nahamwitu, nanga, ndaalyo igoorwa. Bwo wanyakiira bwija, keera umutima gwayika mu nda.» ");
INSERT INTO flr_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Uyo Hesahu, ku gwogwo mulege-rege, anagalukira i Seyiri. ");
INSERT INTO flr_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Haliko Yakobo yehe, anagenda i Sukooti, anayubaka yeꞌnyumba neꞌbiraaro. Kyo kitumiri yaho handu, Yakobo akahayinika iziina Sukooti, (kuli kudeta: biraaro). ");
INSERT INTO flr_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ikyanya Yakobo akalyoka mu kihugo kyeꞌMezopotamiya, anahika i Kaanani mu kati koꞌmutuula. Anashumbika hoofi naꞌkaaya keꞌShekemu. ");
INSERT INTO flr_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Yaho handu ho akashumbika, akahagula imwa beene Hamoori, yishe wa Shekemu, ku bingorongoro byeꞌharija igana. ");
INSERT INTO flr_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Anahayubaka akatanda koꞌkusiriigiza kwaꞌmatuulo, anahayinika iziina «El, Rurema wa Hisiraheeri». ");
INSERT INTO flr_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Lusiku luguma, Dina munyere Yakobo na Leya, anazaatira abakazi balebe, ba mu kihugo kyeꞌKaanani. ");
INSERT INTO flr_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Umutwali wa yikyo kihugo, ye wâli Hamoori, Umuhivi. Na mugala wage, ye wâli Shekemu. Uyo Shekemu, iri akabona ngiisi kwo Dina anonosiri bweneene, anayami múbimbiira, anamúshuleha ku misi. ");
INSERT INTO flr_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Na bwoꞌyo Shekemu âli múvunikiiri bweneene, kyanatuma agatondeera ukumúlevya. ");
INSERT INTO flr_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Iri hakatama, anagendi ganuuza Hamoori, ti: «E daata, maashi! Uyu munyere, nakuyinginga, ugendi múngondera.» ");
INSERT INTO flr_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yakobo analonga umwazi, kwo Shekemu keera amúshereegeza munyere wage wa Dina. Kundu kwokwo, anahulika, halinde ku kyanya abagala bakataaha. Mukuba, bâli ki riiri i bungere. ");
INSERT INTO flr_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Uyo Hamoori, yishe wa Shekemu, anagendi ganuuza Yakobo. ");
INSERT INTO flr_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ku kyekyo kyanya, yabo bagala Yakobo banaba keera bafuluka, bakola ha kaaya. Balya bagala baage, mbu bayuvwe ngiisi íbyakoleka, imitima yanasiriira, banaraakara bweneene. Mukuba, ngiisi kwo Shekemu akagira, mu kushuleha munyere Yakobo, mu Bahisiraheeri byâli teeziri ishoni. Kyâli riiri kizira bweneene. ");
INSERT INTO flr_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Uyo Hamoori anayiji babwira: «Mugala wani wa Shekemu avunikiiri munyere winyu. Namùyinginga, mumúyemeerere amúyange. ");
INSERT INTO flr_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mulekage tukizi yangirana. Tukizi yanga banyere biinyu. Niinyu, munakizi yanga abeꞌmwitu. ");
INSERT INTO flr_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kino kihugo, kikola kyeꞌmwinyu. Mukituulage mwo, iri munakidandaliza mwo. Munabe naꞌgiinyu matongo.» ");
INSERT INTO flr_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ha nyuma, uyo Shekemu yenyene anayiji bwira yishe wa Dina, na bashija baage: «Namùyinginga munyakiire bwija. Ngiisi byo mugambuuna, ngabitanga. ");
INSERT INTO flr_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Mumbwire ngiisi ngondo yo muloziizi kuꞌyu munyere. Ngagitanga, gira nimúyange.» ");
INSERT INTO flr_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Bwoꞌyo Shekemu âli mali teerera mwali wabo wa Dina ulushaagwa, balya baana ba Yakobo banabashuvya ku bulyalya, ti: ");
INSERT INTO flr_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","«Igambo mwene yiri, tutangaligira. Munyere witu, tutangamúyangiisa noꞌmushosi útakatenguulwa. Ukugira kwoku, bituteeziri ishoni. ");
INSERT INTO flr_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","«Aahago! Twangayuvwanwa naaho, iri ngiisi úyimbwa mushosi mu kati kiinyu, angaba nga twehe mu kutenguulwa. ");
INSERT INTO flr_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Lyoki, twangayemeera mukizi yanga banyere biitu. Na nyiitu, tunakizi yanga banyere biinyu, tunatuulanwe, tunabe twe baguma. ");
INSERT INTO flr_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Halikago, iri mutangayemeera kwo mutenguulwe, tugahulusa mwali witu, tunamútaahane.» ");
INSERT INTO flr_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Uyo Hamoori na mugala wage wa Shekemu, ikyanya bakayuvwa kwokwo, banasiima. ");
INSERT INTO flr_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shekemu, âli kizi simbahwa bweneene mu mwabo. Kwokwo, batanatinda, banagira nga ngiisi kwo bakababwira, bwo âli vunikiiri bweneene munyere Yakobo. ");
INSERT INTO flr_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Uyo Hamoori na mugala wage wa Shekemu, banagenda kwiꞌrembo lyaꞌkaaya kaabo, banabwira abaabo booshi: ");
INSERT INTO flr_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Uyu Yakobo, naꞌbaana baage, bali biira biitu. Bweꞌkihugo kiitu kiyajabusiri, tubaleke tutuulanwe, batuule mwo ku butoge, halinde tunakizi yangirana. ");
INSERT INTO flr_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","«Haliko, tutangatuulanwa, tunabe twe baguma, tútazi yemeera kwo ngiisi úyimbwa mushosi mu kati kiitu atee tenguulwa, nga kwo nabo bakola batenguule. ");
INSERT INTO flr_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Aahago! Iri twayemeera, birya bitugwa byabo bigaaba byeꞌmwitu, kuguma neꞌbindi byabo byoshi.» ");
INSERT INTO flr_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Yabo bashosi booshi ábâli kuumaniri yaho kwiꞌrembo, banayemerezania na Hamoori na Shekemu, booshi banatenguulwa. ");
INSERT INTO flr_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Iri hakalenga isiku zishatu, balya bashosi booshi bâli ki yuvwiti ubulyanirwe. Haaho, bashija ba Dina babiri, Simyoni na Laawi, bagala Yakobo, banagwa ku byugi, banayingira mu yako kaaya luto-luto. Neꞌkyanya bâli riiri mwo, banayami yita abashosi booshi. ");
INSERT INTO flr_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Kiri Hamoori na mugala wage wa Shekemu, nabo banabayita. Ha nyuma, banayingira mu nyumba ya Shekemu, banahulusa mwo mwali wabo wa Dina, banamútaahana. ");
INSERT INTO flr_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Abandi bagala Yakobo, iri bakayingira i Shekemu, banagwana ibirunda. Banagenda bagazunguluka mu kaaya, mu kushahula ibindu. Mukuba, mu yako kaaya, mwo mwali wabo akashereegezibwa. ");
INSERT INTO flr_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Banasholera ibibuzi, neꞌmbene, neꞌngaavu, na bapunda, na ngiisi kindu kyoshi íkyâli riiri mwo. Kiri na byoshi íbyâli riiri mu mbingiro, nabyo banagendi bishamba. ");
INSERT INTO flr_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Byoshi, banabitaahana. Kiri naꞌbakazi booshi, naꞌbaana, banabatwala imbohe, kuguma neꞌbindi byoshi bya mu nyumba. ");
INSERT INTO flr_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakobo, mbu abonage kwokwo, anabwira Simyoni na Laawi: «Lolagi! Keera mwangululira umwama. Keera mwayagaza abatuulaga ba mu kino kihugo, Abakaanani naꞌBapereesi. Yaba bandu, hali ikyanya bangakoli yibiika kuguma, banayiji ndeera. Na bwo ndahiiti abandu bingi, na ngengeere naminikirwa kuguma neꞌmbaga yani.» ");
INSERT INTO flr_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Yabo bagala baage, ti: «Ewe! Ulya mutabana, ka ahangwirwi ukugira mwali witu nga mushule?» ");
INSERT INTO flr_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Lusiku luguma, Rurema anabwira Yakobo kwokuno: «Nie Rurema úkakuhulukira kwo, ikyanya wâli kizi tibita mukulu wawe wa Hesahu. Aaho! Uyibiikage ibiringiini, gira ugendi tuula i Beteeri, unanyubakire yaꞌkatanda koꞌkusiriigiza kwaꞌmatuulo.» ");
INSERT INTO flr_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Uyo Yakobo, anabwira abandu beꞌmbaga yage, na ngiisi bo bâli ririinwi: «Ngiisi migisi yeꞌmahanga yo muhiiti, mugikabulire. Muyiyeruusagye, munahogole ibyambalwa biinyu, munayambale ibindi. ");
INSERT INTO flr_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kwokwo, tugendage i Beteeri, gira ngendi yubakira Rurema akatanda koꞌkusiriigiza kwaꞌmatuulo. Mukuba, Rurema ye wâli kizi ndabaala mu siku zaꞌmakuba gaani. Ye wanâli kizi ndongoora ngiisi ho nâli kizi genda.» ");
INSERT INTO flr_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kwokwo, yabo bandu banakuumania ngiisi migisi yeꞌmahanga yo bâli hiiti, kuguma naꞌmahereeni go bâli yambiiti ku matwiri. Yibyo byoshi, iri bakabiheereza Yakobo, anabiziika mwiꞌdako lyeꞌkiti kyoꞌmwalooni, íkyâli riiri hoofi naꞌkaaya keꞌShekemu. ");
INSERT INTO flr_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yakobo na bagala baage, iri bakaba bakola mu lugeezi, Rurema anakizi yobohya abatuulaga ba mu twaya tweꞌbutambi, halinde banaleka ukukizi balandiriza. ");
INSERT INTO flr_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Uyo Yakobo, naꞌbandu baage booshi, banahika i Luuzi, (kuli kudeta: i Beteeri), mu kihugo kyeꞌKaanani. ");
INSERT INTO flr_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Iri bakahika yo, anayubaka akatanda koꞌkusiriigiza kwaꞌmatuulo, anahayinika iziina, Rurema weꞌBeteeri. Mukuba, haaho ho Rurema akayiyerekana imwage, ikyanya âli kizi tibita mukulu wage wa Hesahu. ");
INSERT INTO flr_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Ikyanya bâli koli tuuziri yaho, umulezi wa Rebeka, iziina lyage ye Deboora, anafwa. Anaziikwa mwiꞌdako lyeꞌkiti kyoꞌmwalooni, uluhande lweꞌkisaka lweꞌBeteeri. Kyanatuma yaho handu, Yakobo agahayinika iziina Mwalooni gweꞌKimombo. ");
INSERT INTO flr_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yakobo, iri akaba akoli lyosiri mu kihugo kyeꞌMezopotamiya, Rurema anashubi múhulukira kwo, anamúgashaanira, ti: ");
INSERT INTO flr_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","«Iziina lyawe, we Yakobo. Haliko, utagakizi ki buuzibwa kandi mu yiryo iziina. Si buno, iziina lyawe, we kola Hisiraheeri.» Kwokwo, kwo Rurema akamúyinika iziina lihyahya. ");
INSERT INTO flr_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Rurema anashubi múbwira: «Nie Rurema woꞌbushobozi bwoshi. Kwokwo, ubute yisho, ubute nyoko, munayushuuke. Mukuba, mwiꞌkondo lyawe, mwo mugalyoka umulala úguhimbiri, kuguma neꞌgindi milala mingi, kiri naꞌbaami. ");
INSERT INTO flr_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ikihugo kyo nꞌgaheereza Hiburahimu, bo na Hisake, kyo na naawe nakuheereza, mwe naꞌbandu ba mu kibusi kyawe.» ");
INSERT INTO flr_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ikyanya Rurema akayusa ukuganuuza Yakobo, anamúsiga yaho. ");
INSERT INTO flr_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaho handu, Yakobo anahashinga ibuye lyoꞌbukengeeze. Mukuba, ho Rurema akamúganuuliza. Analitaluula, mu kuliyonera kweꞌdivaayi naꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Kwokwo, yaho handu, Yakobo anahayinika iziina Beteeri. ");
INSERT INTO flr_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ha nyuma, Yakobo neꞌmbaga yage banalyoka i Beteeri. Neꞌri bakaba batazi hika i Hefurata, uyo Laheeri, inda yanamúkoma, anayuvwa umukero, analyanirwa bweneene. ");
INSERT INTO flr_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Neꞌkyanya akaba akola mu buta, umuhumbwa wage anamúbwira: «Uyihe ikise. Wabuta kandi umwana woꞌbutabana.» ");
INSERT INTO flr_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Laheeri, iri akaba akola mu hamba, anayinika uyo mwana iziina Benooni, (kuli kudeta: umwana ye nabuta ku malibu). Haliko yishe, anamúyinika iziina Binyamiini, (kuli kudeta: umwana woꞌkuboko kwani kweꞌlulyo.) ");
INSERT INTO flr_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Iri hakatama, ulya Laheeri, umutima gwanaderuuka, anaziikwa ku njira íri mu genda i Hefurata (yo Betereheemu ku zeene). ");
INSERT INTO flr_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Na ku shinda yage, Yakobo anashinga kwiꞌbuye. Kiri na zeene, yiryo ibuye likiri mu yerekana ho Laheeri akaziikwa. ");
INSERT INTO flr_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Uyo Yakobo anagenderera kandi noꞌlugeezi. Neꞌri akaba keera atambuka i Megidaari-Hedeeri, anashumbika. ");
INSERT INTO flr_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ikyanya Hisiraheeri akaba akoli tuuziri yaho, mugala wage wa Rubeni anamenyana na nyina wage Biriha, anâli muja-kazi wa Laheeri. Yugwo mwazi, ikyanya Hisiraheeri akagumenya, anabona buligo bweneene. Yakobo âli hiiti abaana boꞌbutabana ikumi na babiri. ");
INSERT INTO flr_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Bagala Leya, amaziina gaabo go gaaga: Ifula ya Yakobo, ye Rubeni. Na úgamúlonda, ali Simyoni, na Laawi, na Yuda, na Hisakaari, na Zabulooni. ");
INSERT INTO flr_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Bagala Laheeri, nabo amaziina gaabo go gaaga: Yusefu na Binyamiini. ");
INSERT INTO flr_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bagala Biriha, umuja-kazi wa Laheeri, nabo amaziina gaabo go gaaga: Daani na Nafutaali. ");
INSERT INTO flr_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Bagala Ziripa, umuja-kazi wa Leya, nabo amaziina gaabo go gaaga: Gaadi na Hasheeri. Yaba baana booshi, Yakobo akababutira mu kihugo kyeꞌMezopotamiya. ");
INSERT INTO flr_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yakobo anagalukira imunda yishe Hisake, i Mamure, hoofi naꞌkaaya keꞌKiryati-Hariba (kanali mu buuzibwa Heburooni). Haaho, ho Hiburahimu na Hisake bâli tuuziri nga binyamahanga. ");
INSERT INTO flr_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Uyo Hisake, âli kola mushaaja bweneene. Neꞌri akahisa imyaka igana na makumi galimunaana, anafwa, anagwana bashokulu baage. Bagala baage, Hesahu na Yakobo, banamúziika. ");
INSERT INTO flr_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Abandu ba mu mbaga ya Hesahu (ye nali mu buuzibwa Hedoomu), umwazi gwabo gwo gwogu: ");
INSERT INTO flr_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","3","Hesahu akayanga abakazi ba mu kihugo kyeꞌKaanani, hâli Haada, na Oholibama, na Basemati. Haada âli riiri munyere Helooni, Umuhiti. Oholibama naye, âli riiri munyere Hana, anâli riiri mwijukulu Sibyoni, Umuhivi. Basemati naye, âli riiri munyere Hishimaheeri, mwali wa Nebayoti. ");
INSERT INTO flr_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Hesahu, anabuta Herifaazi ku Haada. Anabuta na Rehuweri ku Basemati. ");
INSERT INTO flr_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Na ku Oholibama, anabuta Yehushi, na Yalamu, na Koora. Yabo, bo baana bo Hesahu akabutira mu kihugo kyeꞌKaanani. ");
INSERT INTO flr_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Ha nyuma, Hesahu anayabiira bakaage, na bagala baage, na banyere baage, naꞌbandi booshi ba mu nyumba yage. Anayabiira neꞌngaavu zaage, neꞌbindi bitugwa byage byoshi, na ngiisi bindi byo akatwira mu kihugo kyeꞌKaanani. Anabungira mwiꞌhanga íriri hala na mulumuna wage wa Yakobo. ");
INSERT INTO flr_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Na íbikatuma Hesahu agaagira kwokwo, bweꞌbitugwa byabo byâli mali luguuka bweneene, kuguma neꞌbindi bindu byabo. Kwokwo, ikihugo kyo bâli tuuziri mwo, kyanabaniihira, halinde batanaki shobola ukutuulanwa. ");
INSERT INTO flr_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kwokwo, Hesahu (irindi iziina lyage Hedoomu) anagendi tuula mu migazi ya mu kihugo kyeꞌSeyiri. ");
INSERT INTO flr_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Abandu ba mu mbaga ya Hesahu, umwazi gwabo gwo gwogu: Hesahu, ye shokuluza waꞌBahedoomu, abatuulaga ba mu migazi yeꞌkihugo kyeꞌSeyiri. Guno gwo muharuuro gwaꞌbandu ba mu kibusi kyage: ");
INSERT INTO flr_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Akabuta Herifaazi ku mukaage Haada. Anabuta na Rehuweri, ku mukaage Basemati. ");
INSERT INTO flr_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Uyo Herifaazi, bagala baage naye, bâli Temaani, na Homaari, na Sefo, na Gatamu, na Kenaazi. ");
INSERT INTO flr_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Uyo Herifaazi, âli hiiti ugundi mukazi weꞌmbuga, iziina lyage Timuna. Anamúbuta kwoꞌmwana woꞌbutabana, iziina lyage Hamareki. Yabo booshi, bali bijukulu Hesahu ku mukaage Haada. ");
INSERT INTO flr_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Rehuweri naye, bagala baage, bâli Nahati, na Zeera, na Shaama, na Miiza. Yabo booshi, bali bijukulu Hesahu ku mukaage Basemati. ");
INSERT INTO flr_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholibama munyere Hana, mwijukulu Sibyoni, akabutira Hesahu abatabana bashatu. Hali Yehushi, na Yalamu, na Koora. ");
INSERT INTO flr_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Abaana ba Hesahu, kiri na bijukulu baage, banayiji ba batwali beꞌmilala yage. Hâli Herifaazi, ifula ya Hesahu. Naꞌba mwiꞌkondo lyage, hali Temaani, na Homaari, na Sefo, na Kenaazi, ");
INSERT INTO flr_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","na Koora, na Gatamu, na Hamareki. Ngiisi muguma wabo, ye wâli riiri mutwali woꞌmulala gwage, nga ngiisi kwo bâli tuuziri mu kihugo kyeꞌHedoomu. ");
INSERT INTO flr_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Aba mwiꞌkondo lya Rehuweri mugala Hesahu, bijukulu Basemati, hali Nahati, na Zeera, na Shaama, na Miiza. Ngiisi muguma wabo, ye wâli riiri mutwali woꞌmulala gwage, nga ngiisi kwo bâli tuuziri mu kihugo kyeꞌHedoomu. ");
INSERT INTO flr_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Naꞌba mwiꞌkondo lya Oholibama munyere Hana, muka Hesahu, hali Yehushi, na Yalamu, na Koora. Ngiisi muguma wabo, ye wâli riiri mutwali woꞌmulala gwage. Yabo, bâli riiri bagala Oholibama munyere Hana. ");
INSERT INTO flr_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Yabo booshi, bo bandu ba mu kibusi kya Hesahu. Neꞌrindi iziina lyage, Hedoomu. Ngiisi muguma wabo, ye wâli riiri mutwali woꞌmulala gwage. ");
INSERT INTO flr_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Abatuulaga ba mbere ba mu kihugo kyeꞌHedoomu, bâli riiri bandu beꞌkibusi kya Seyiri, wa mu mulala gwaꞌBahoori. Abatwali baabo, hâli Lotaani, na Shobaali, na Sibyoni, na Hana, na Dishooni, na Hezeeri, na Dishaani. ");
INSERT INTO flr_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Bagala Lotaani, hali Hoori, na Hemani. Mwali wa Lotaani, ye Timuna. ");
INSERT INTO flr_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Bagala Shobaali nabo, bâli Halwani, na Manahati, na Hebaali, na Sefo, na Honamu. ");
INSERT INTO flr_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Bagala Sibyoni nabo, bâli Haya, na Hana. Uyo Hana, ikyanya âli ragiiri bapunda ba yishe Sibyoni mwiꞌshamba, anahulukira ku masuuza. ");
INSERT INTO flr_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Abaana ba Hana nabo, bâli Dishooni, na mwali wage wa Oholibama. ");
INSERT INTO flr_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Bagala Dishooni nabo, bâli Hemudaani, na Heshibaani, na Hitirani, na Keraani. ");
INSERT INTO flr_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Bagala Hezeeri nabo, bâli Birihaani, na Zawani, na Hakani. ");
INSERT INTO flr_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Bagala Dishaani nabo, bâli Huuzi, na Harani. ");
INSERT INTO flr_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Bano bo batwali ba mu mulala gwaꞌBahoori. Lotaani, na Shobaali, na Sibyoni, na Hana, ");
INSERT INTO flr_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","na Dishooni, na Hezeeri, na Dishaani. Yaho mu kihugo kyeꞌSeyiri, ngiisi muguma wabo, ye wâli riiri mutwali woꞌmulala gwabo. ");
INSERT INTO flr_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ikyanya abaami batâli zaazi twala mu Bahisiraheeri, mu kihugo kyeꞌHedoomu mwohe, bâli kola mu twala. ");
INSERT INTO flr_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Mu yabo baami, muli Beela mugala Behoori, ye wâli twaziri mwo. Uyo Beela âli tuuziri mu kaaya kahamu Dinihaba. ");
INSERT INTO flr_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Beela, iri akashaaja, Yobaabu mugala Zeera, wa mu kaaya keꞌBosira, anayima ahandu haage. ");
INSERT INTO flr_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobaabu naye, iri akashaaja, Hushamu wa mu kihugo kyaꞌBatemaani, anayima ahandu haage. ");
INSERT INTO flr_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushamu naye, iri akashaaja, Hadaadi mugala Bedaadi, anayima ahandu haage. Uyo Hadaadi âli tuuziri mu kaaya kahamu Haviti. Uyo Hadaadi, ye kalwisa Abamidyani mu kihugo kyaꞌBamohabu, anabasinda. ");
INSERT INTO flr_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaadi naye, iri akashaaja, Samula wa mu kaaya keꞌMasireka, anayima ahandu haage. ");
INSERT INTO flr_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samula naye, iri akashaaja, Sahuli wa mu kaaya keꞌRehobooti, ákali hoofi noꞌlwiji, anayima ahandu haage. ");
INSERT INTO flr_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sahuli naye, iri akashaaja, Baali-Hanaani mugala Hakiboori, anayima ahandu haage. ");
INSERT INTO flr_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baali-Hanaani mugala Hakiboori naye, iri akashaaja, Hadaari anayima ahandu haage. Uyo Baali-Hanaani âli tuuziri mu kaaya kahamu keꞌPahu. Mukaage, âli kizi buuzibwa Mehetabeeri munyere Matireedi. Uyo Matireedi, âli riiri munyere Mezahaba. ");
INSERT INTO flr_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Yaga maziina gooshi, gali gaꞌbatwali ba mu kibusi kya Hesahu, ukukulikirana neꞌmilala yabo, noꞌtwaya twabo. Hâli riiri Timuna, na Haliva, na Yeteti, ");
INSERT INTO flr_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","na Oholibama, na Hela, na Pinooni, ");
INSERT INTO flr_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","na Kenaazi, na Temaani, na Mibusaari, ");
INSERT INTO flr_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","na Magidyeri, na Hiraamu. Yabo, bo batwali beꞌmilala íkalyoka mwiꞌkondo lya shokuluza Hedoomu, (kuli kudeta: Hesahu). Yabo booshi, bakatondobolwa kwokwo, ukukulikirana noꞌtwaya two bâli tuuziri mwo. Noꞌyo Hesahu, ye shokuluza waꞌBahedoomu booshi. ");
INSERT INTO flr_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yakobo anagenderera ukutuula mu kihugo kyeꞌKaanani. Munali mwo yishe naye âli tuuziri. ");
INSERT INTO flr_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Abandu ba mu mbaga ya Yakobo, umwazi gwabo gwo gwogu: Yusefu, iri akaba akola musore weꞌmyaka ikumi niꞌrinda, anakizi gendi ragira ibitugwa kuguma na bakulu baage, bagala Biriha na Ziripa, bamuka yishe. Balya bakulu baage, ikyanya bâli kizi gira amahimba mabi, Yusefu anakizi yiji gaganuulira yishe. ");
INSERT INTO flr_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Bwo Yakobo akabuta Yusefu mu bushaaja bwage, âli múkuuziri bweneene, ukuhima abandi baana baage booshi, kyanatuma agahangira Yusefu ikooti lyoꞌmulimbo. ");
INSERT INTO flr_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yabo bakulu baage, iri bakabona ngiisi kwo yishe akuuziri Yusefu ukubahima, banatondeera ukumúshomba, halinde batanakizi ki múdesa bwija. ");
INSERT INTO flr_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Bushigi buguma, Yusefu analoota. Yibyo birooto, anagendi bilotoloolera yabo bakulu baage. Mbu babiyuvwe, banakaviiriza ukumúshomba. ");
INSERT INTO flr_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Mukuba, akababwira: «E balya, ngiisi byo naloota, muleke nimùlotololere byo. ");
INSERT INTO flr_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nabona kwo tweshi tushuba mu gesha mu ndalo, twanakizi shweka ibiiro. Lyeryo, ikiiro kyeꞌmwani kyanayinamuka, kyanajingirira. Ibiiro byeꞌmwinyu byohe, byanayiji kizunguluka, byanakizi kiyinamira.» ");
INSERT INTO flr_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Balya bakulu baage, banamúbuuza: «Ka mwangayuvwa ibala? Ka uloziizi ukutubwira kwo we gaaba mwami witu?» Yusefu, ikyanya âli kizi loota, anakizi deta byo aloota, kyanatuma yabo bakulu baage bagakaviiriza ukumúshomba. ");
INSERT INTO flr_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Uyo Yusefu, anashubi loota kandi, anashubi balotololera, ti: «Yuvwi! Keera kandi naloota. Leero nabona izuuba, noꞌmwezi, neꞌndonde ikumi na nguma, bigweti bigayinama imbere lyani.» ");
INSERT INTO flr_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yibyo birooto bizinda, Yusefu anabibwira kiri na yishe, na bakulu baage. Yishe anamúmamira, ti: «E maashi uyu mwana, birooto biki yibyo waloota? Aahago! Niehe na nyoko, kiri na bakulu baawe, ka tugayiji kufukamira?» ");
INSERT INTO flr_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Balya bakulu baage, banamúyuvwirwa uluugi. Kundu kwokwo, yishe yehe anakizi biyitoneesa kwo. ");
INSERT INTO flr_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Lusiku luguma, yabo bakulu ba Yusefu, banagendi gisha neꞌbitugwa bya yishe, hoofi neꞌShekemu. ");
INSERT INTO flr_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Neꞌri hakalenga isiku, Yakobo anabwira Yusefu: «Nga kwo uyiji, bakulu baawe bakagendi gisha i Shekemu. Na buno, ngola ngakutuma yo, ugendi batanduula.» Yusefu naye, ti: «E daata, ngagenda.» ");
INSERT INTO flr_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Yishe anamúbwira: «Ikyanya ugagendi lola bakulu baawe neꞌbitugwa, umenye iri bangaba bali bagumaana. Ha nyuma, ukabuli galuka, uyiji mbwira.» Ikyanya Yakobo akatuma Yusefu, Yusefu anashaaga mu ndekeera yeꞌHeburooni. Uyo Yusefu, iri akayegeera i Shekemu, ");
INSERT INTO flr_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","mundu muguma anamúhulukira kwo, anabona kwo akola mu zumba-zumba mu ndagiriro, anamúbuuza: «Ewe! Biki byo uli mu looza?» ");
INSERT INTO flr_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yusefu, ti: «Ndi mu looza bakulu baani. Nakuyinginga, umbwirage ho baragiiri.» ");
INSERT INTO flr_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Uyo mundu, ti: «Keera bakalyoka hano. Nꞌgayuvwa bali mu deta kwo bagagendi gisha i Dotaani.» Kyanatuma Yusefu agakulikira yabo bakulu baage, anabagwanana iyo munda i Dotaani. ");
INSERT INTO flr_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ikyanya Yusefu âli ki riiri hala, yabo bakulu baage banamúlangiiza, ali hwiti-hwiti! Neꞌri akaba atazi bayegeera, banagira igambi lyoꞌkumúyita. ");
INSERT INTO flr_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Banabwirana: «Langiizi, she-birooto ayija! ");
INSERT INTO flr_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Aahago! Mugire tumúyite. Neꞌkirunda kyage, tukilashe mu kirimbi-rimbi. Tugagendi bwira yishe kweꞌnyamiishwa ndangi yamújanganula. Leero birya birooto byage, tukalolage ngiisi kwo bigaaba.» ");
INSERT INTO flr_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Yago magambo, iri mukulu wabo wa Rubeni akagayuvwa, analooza ubulyo bwoꞌkufuusa Yusefu mu maboko gaabo, anabwira yabo balumuna baage: «Nanga, maashi! Mutakolwe kwo mwamúyita, ");
INSERT INTO flr_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","mutayiji kengeera mwayona umuko gwage. Ho mwangamúkomeeresa, lubi-lubi munamútibulire mu kino kirimbi-rimbi íkiri hano mwiꞌshamba.» Na íbikatuma Rubeni agaadeta kwokwo, bwo âli loziizi ukukiza Yusefu mu maboko gaabo, gira akashubi longa ubulyo bwoꞌkumúgalulira imunda yishe. ");
INSERT INTO flr_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Uyo Yusefu, mbu ahikage áhali balya bakulu baage, banayami múhogola lirya kooti lyage lyoꞌmulimbo, ");
INSERT INTO flr_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","banamúbirigisha, biri! Banayami mútibulira mu kirimbi-rimbi, kizira miiji. ");
INSERT INTO flr_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Yabo bakulu ba Yusefu, iri bakaba bakoli bwatiiri ha byokulya, mbu bayinamule amasu, banabona ikiso kyaꞌBahishimaheeri ábalyosiri i Giryadi, bali mu balamira i Miisiri. Ingamiya zaabo, zâli heesiri umubadu, neꞌzeeri, naꞌmanemane. ");
INSERT INTO flr_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Lyeryo, Yuda anabwira beene wabo: «E balya, mango twayita mulumuna witu, tunafulire umuko gwage, bikagi tugaaba twayunguka? ");
INSERT INTO flr_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Ho twangamúyita, giri tumúguliise imwa bano Bahishimaheeri. E maashi, si ali mulumuna witu, tunali ba muko muguma.» Ikyanya Yuda akadeta kwokwo, beene wabo banayemeera. ");
INSERT INTO flr_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Yabo badandaza beꞌMidyani, iri bakahikaga yaho, yabo bakulu ba Yusefu banamúlyosa mu kirimbi-rimbi, banamúguliisa ku kishingo kyeꞌbingorongoro makumi gabiri. Kwokwo, banatwala Yusefu i Miisiri. ");
INSERT INTO flr_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Uyo Rubeni, ikyanya akagalukira iwa kirya kirimbi-rimbi, anagwana Yusefu atakiri mwo, kyanatuma agayami daatula ibyambalwa byage ku mwizingeerwe. ");
INSERT INTO flr_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Anagalukira imunda balumuna baage, iri anayamiza, ti: «Ala nie! Mulumuna witu Yusefu atakiri mu kirimbi-rimbi. Hayagi niehe ngataahira?» ");
INSERT INTO flr_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Yabo bakulu baage, banatongeera ikihebe, banadabika ikooti lyage mu muko. ");
INSERT INTO flr_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Neꞌri bakalitwala imunda yishe, banadeta: «E daata, lino ikooti, twalitoola. Uliyitegeereze bwija, ulole iri lyangaba lya mugala wawe.» ");
INSERT INTO flr_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Yishe, mbu alihenandule, anayami limenya, anayamiza: «Yoo! Lino ikooti liri lyeꞌmwa mugala wani. Inyamiishwa keera yamúlya. Ku kasiisa, Yusefu aliibwa.» ");
INSERT INTO flr_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Uyo Yakobo anayami daatula ibyambalwa byage ku mwizingeerwe. Anayambala ibyambalwa byeꞌkigandaaro, anamala isiku nyingi ali mu mushiibo gwoꞌyo mugala wage. ");
INSERT INTO flr_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Uyo Yakobo, bagala baage booshi, kiri na banyere baage, banakizi yiji gira mbu bamúholeeze. Haliko, analahira ukuholeera, anadeta: «Ndeki maashi! Ngagenderera ukugandaara mugala wani, halinde ku kyanya ngamúgwana i kuzimu.» Kwokwo, kwo yishe âli kizi múlirira. ");
INSERT INTO flr_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Balya Bamidyani, iri bakahika i Miisiri, banaguliisa Yusefu imwoꞌmukulu muguma, iziina lyage Potifaari. Potifaari, âli riiri muguma wa mu batwali ba Faraho, anâli mukulu waꞌbasirikaani ábâli kizi múlanga. ");
INSERT INTO flr_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ku yikyo kyanya, Yuda anayihandula ku beene wabo, anagendi tuula bo na mundu muguma wa mu kaaya keꞌHadulaamu, iziina lyage Hiira. ");
INSERT INTO flr_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ikyanya Yuda âli koli tuuziri iyo munda, anabona munyere Shuwa, wa mu mulala gwaꞌBakaanani, anamúyanga. ");
INSERT INTO flr_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Uyo mukaage anaheeka inda, anabuta umwana woꞌbutabana. Yuda anamúyinika iziina Heeri. ");
INSERT INTO flr_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Mukaage anashubi heeka inda, anabuta ugundi mwana woꞌbutabana, anamúyinika iziina Honani. ");
INSERT INTO flr_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ha nyuma, anashubi buta kandi umwana woꞌbutabana, anamúyinika iziina Sheela. Uyo Sheela, ikyanya akabutwa, Yuda âli koli tuuziri i Kezibu. ");
INSERT INTO flr_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Uyo Heeri, ifula ya Yuda, iri akaviruuka, Yuda anamúgondera munyere muguma, iziina lyage Tamaari. ");
INSERT INTO flr_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Haliko, Heeri âli riiri naꞌmahimba mabi imbere lya Nahano, kyanatuma Nahano agamúyita. ");
INSERT INTO flr_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kwokwo, Yuda anabwira Honani: «Umukazi úwasiga mukulu wawe, umúhyanage, gira ukizi múbutira abaana, nga kwo bikwaniini.» ");
INSERT INTO flr_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Uyo mukazi, Honani anamúhyana. Kundu kwokwo, âli yiji-yiji kwaꞌbaana batagaaba beꞌmwage, kyanatuma ikyanya âli kizi múgwejera, anakizi yonera haashi, gira atabutire umuhisi abaana. ");
INSERT INTO flr_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Yibyo bihigo byage, byanayagaza Nahano, kyanatuma naye, agamúyita. ");
INSERT INTO flr_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yuda anabwira mwali-kazi wage wa Tamaari: «E maawe, bwo ndaaye úgakuyanga, ugendi beera ha mwinyu, halinde ukuhisa ku kyanya mugala wani wa Sheela agaviruuka.» Na íbikatuma Yuda agaadeta kwokwo, bwo âli toniri kwo ngeeka Sheela naye, angakoli yiji fwa, nga kwo bakulu baage bakafwa. Kwokwo, uyo Tamaari anagalukira imwa yishe. ");
INSERT INTO flr_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Isiku iri zikalenga, muka Yuda, ulya munyere Shuwa, naye anafwa. Yuda, iri akaba keera alyoka mu kigandaaro, anamanukira i Timuna, imwa ábâli kizi kema ibibuzi byage ubwoya. Ku yikyo kyanya, âli riiri kuguma na mwira wage wa Hiira, wa mu kaaya keꞌHadulaamu. ");
INSERT INTO flr_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Uyo Tamaari, anabwirwa kwo shevyala akola mu njira yoꞌkugenda i Timuna, gira agendi kema ibibuzi byage ubwoya. ");
INSERT INTO flr_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Kwokwo, anahogola ibyambalwa byoꞌbunamufwiri, anayambala ibindi-bindi, anayitumbika ikitambala, gira ayibishe. Haaho, anagendi bwatala kwiꞌrembo lyaꞌkaaya keꞌHenayimu. (Yako kaaya kali ku njira yoꞌkugenda i Timuna.) Na íbikatuma agaagira kwokwo, bwo akabona kwo kundu Sheela âli mali viruuka, haliko Yuda atakaki múyemeerera kwo Sheela amúhyane. ");
INSERT INTO flr_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Uyo Tamaari, âli ki yitumbisiri ikitambala ku malanga. Kwokwo, Yuda, mbu amúbonage, anatona kwo ali mukazi mushule. ");
INSERT INTO flr_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Kwokwo, buzira kumenya kwo ali mwali-kazi wage, anamúyegeera, anamúbwira: «Ewe! Ndoziizi tugendi laalanwa.» Tamaari anamúbuuza: «Aahago! Iri nangayemeera, biki byo ugambeereza?» ");
INSERT INTO flr_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda, ti: «Mu bitugwa byani, ngakuheereza ikyanahene kiguma.» Tamaari, ti: «Utee mbeereza ingwati íganyemeeza kwo ugandeetera kyo.» ");
INSERT INTO flr_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda, ti: «Ngwati nyiki yo usiimiri nguheereze?» Naye, ti: «Umbeerezagye iyo imbete, kuguma noꞌmugozi gwayo, kiri neꞌyo ngoni yo ufumbiiti.» Lyeryo, Yuda anamúfumbadika byo. Neꞌkyanya akagendi bakamenyana, anamúheesa inda. ");
INSERT INTO flr_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Uyo Tamaari, iri akagalukira i kaaya, anahogola yikyo kitambala kyo âli yitumbisiri i malanga, anashubi yambala irya mirondo yoꞌbunamufwiri. ");
INSERT INTO flr_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda anatuma ulya mwira wage wa Hiira, mbu atwalire ulya mukazi ikyanahene, gira amúgalulire irya ngwati yo akamúsigira. Haliko, iri Hiira akamúloozagya, atanamúbona. ");
INSERT INTO flr_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Kyanatuma agabuuza abatuulaga beꞌyo munda i Henayimu: «Ulya mukazi mushule úshuba ku njira, ali hayi?» Nabo, ti: «Ewe! Mu kano kaaya, ndaaye mukazi mushule útuula mwo.» ");
INSERT INTO flr_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kwokwo, Hiira anagalukira imunda Yuda, anamúbwira: «Ndaaye nabona. Kiri naꞌbatuulaga baamwo, bambwira kwo mu yako kaaya kaabo, mutazindi ba umukazi mushule.» ");
INSERT INTO flr_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda anadeta: «Wenyene wabona ngiisi kwo namútumira ikyanahene, haliko, utaki múbona. Aaho! Lekaga abeerane yibyo bindu, gira atayiji kengeera atubonia ishoni.» ");
INSERT INTO flr_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Iri hakalenga nga myezi ishatu, uyo Yuda anayiji bwirwa kwo mwali-kazi wage wa Tamaari akola mushule. Na kwo mu bulya bushule bwage, keera aheeka inda. Yuda anayami twa uluhango, ti: «Ulya Tamaari, mumúhulukize imbuga, munamúyokye, afwe!» ");
INSERT INTO flr_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Iri bakaba bakola mu múhalamulira imbuga, Tamaari anatuma indumwa imunda shevyala, ti: «Mwene bino bindu, ye kambeesa inda. Aaho! Nakuyinginga, ugirage ubulyo bwoshi, umenye mwene iyi mbete, kuguma noꞌmugozi gwayo, neꞌyi ngoni.» ");
INSERT INTO flr_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yibyo bindu, Yuda anayami bimenya, anadeta: «Ala nie! Ku kasiisa, Tamaari ye riiri noꞌkuli ukumbima. Mukuba, ndakaki yemeera kwo ahyanwe na mugala wani Sheela.» Ukulyokera yulwo lusiku, Yuda atanaki menyana na Tamaari. ");
INSERT INTO flr_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamaari, iri ikihe kyoꞌkubuta kikahika, banayiji bona kweꞌnda yage iri mwaꞌmahasha. ");
INSERT INTO flr_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Neꞌri akaba akola mu buta, umwana muguma anahulusa ukuboko. Umuhumbwa anakushwekera kweꞌhigozi hidukula, anadeta: «Uyu, ye ngulwe.» ");
INSERT INTO flr_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Haliko, uyo mwana anashubi galulira ukuboko mu nda. Haaho-haaho, butooto anaba ye gatee butwa. Ulya muhumbwa, ti: «Maki gano? Si wayiberera injira ku misi!» Kyanatuma uyo mwana, agayinikwa iziina Pereesi. ");
INSERT INTO flr_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ha nyuma, ulya mulumuna wage úwâli koli hiiti hirya higozi hidukula ku kuboko, naye anabutwa, banamúyinika iziina Zeera. ");
INSERT INTO flr_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Balya Bahishimaheeri, banatwala Yusefu mu kihugo kyeꞌMiisiri, banamúguliisa imwoꞌmutwali muguma woꞌMumiisiri, iziina lyage Potifaari. Potifaari, âli riiri muguma wa mu batwali ba Faraho. Ye wanâli riiri mukulu waꞌbalaliizi baage. ");
INSERT INTO flr_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yaho i Miisiri, Yusefu anatuula mu nyumba ya nahamwabo, Potifaari. Nahano bâli yamiinwi, anakizi múgenduusa. ");
INSERT INTO flr_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Uyo Potifaari, naye âli bwini ngiisi kwo Nahano bâli yamiinwi, na ngiisi kwo âli kizi múgenduusa mu kati ka byoshi. ");
INSERT INTO flr_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Iri hakatama, Potifaari anamúshambaalira bweneene, anamúkoleesa nga mulemberezi wage. Anamúkuza, halinde Yusefu anayimangira inyumba yage yoshi, kiri na byoshi byo âli hiiti. ");
INSERT INTO flr_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ukulyokera ku kyanya uyo Potifaari akagira Yusefu abe mwimangizi weꞌnyumba yage, na weꞌbindu byage byoshi, Nahano anakizi gigashaanira bweneene. Imigashani yage, yanaboneka yumwo mu nyumba, kiri na mu ndalo. ");
INSERT INTO flr_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kyanatuma ulya Potifaari, agabiika Yusefu abe mutwali wa ngiisi byoshi byo âli hiiti. Ndaabyo byo âli kizi lola, ha nyuma lyoꞌkutoola ngiisi byo agaalya naaho. Yugwo musore Yusefu, gwâli nonosiri bweneene, anâli kizi simiisa mu masu. ");
INSERT INTO flr_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Iri hakalenga isiku, muka nahamwabo anatondeera ukukizi múyeruza, anakizi múbwira kwo amúgwejere. ");
INSERT INTO flr_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kundu kwokwo, Yusefu analahira: «Nanga, maashi! Mwiꞌno nyumba, nahamwitu keera akambiika nyimangire ibindu byage byoshi, atanakiri mu yilibuza hiꞌgulu lyabyo. ");
INSERT INTO flr_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Muno mu mwage, ndaaye gundi únguliiri. Ndaanakyo kindu kyo ambuziizi kwo, útali wehe, naaho, bwo uli mukaage. Aaho! Kutagi byanganzigira kwo ngire ibikoleere mwene yibi? Si nangaba nahubira kiri na Rurema yenyene.» ");
INSERT INTO flr_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ulya mukazi, ngiisi lusiku anakizi múlyeryega-lyeryega kwo amúshulehe. Si Yusefu anakizi lahira kwo bitangaziga. Kiri noꞌkumúyegeera, âli kizi lahira. ");
INSERT INTO flr_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Lusiku luguma, Yusefu anayingira mu nyumba, gira akolage umukolwa gwage, nga kwo âli komiiri. Yikyo kyanya, ndaaye gundi mukozi úwâli riiri mwo. ");
INSERT INTO flr_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kwokwo, ulya kokobola woꞌmukazi anamúgwatira ku kyambalwa kyage, anamúbwira: «E Yusefu, leero haahano, ungwejerage.» Ulya Yusefu, anayami yifuushula mu maboko gaage, anapumukira imbuga. Uyo mukazi anasigalana ikooti lyage mu maboko. ");
INSERT INTO flr_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Mbu abonage kwokwo, ");
INSERT INTO flr_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","anayami hamagala abandi bakozi ba mu mwage, ti: «Lolagi! Si uyu muja Muheburaniya ye tukaleeterwa, keera anyeruza, ananyijira mbu angwejere. Kundu kwokwo, nayami banda akaluulu. ");
INSERT INTO flr_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Neꞌri ayuvwa kwokwo, anayami siga anjandira yiki kyambalwa kyage, anapuumukira imbuga.» ");
INSERT INTO flr_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Uyo mukazi, anasingula kirya kyambalwa, halinde ku kyanya yiba akataahira kwo. ");
INSERT INTO flr_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Ulya yiba, mbu ahikage, mukaage anayami múhikiza kwoꞌmwazi, ti: «E mushosi wani, uyu muja Muheburaniya ye ukatuleetera, leero ayiji nyeruza. ");
INSERT INTO flr_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Halikago, nayamiza, nanayami múnyugutula guno mulondo, anapumukira imbuga.» ");
INSERT INTO flr_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Potifaari, mbu ayuvwagwe kwokwo, ti: «Gahembwa ulwibo!» Anayami raakara, ");
INSERT INTO flr_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","anagwatiisa Yusefu, anakyula kwo bamúlashe mu nyumba yeꞌmbohe, ngiisi mwaꞌbandi bashwekwa ba mwami bâli riiri. Yusefu, ikyanya âli kola mu nyumba yeꞌmbohe, ");
INSERT INTO flr_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Nahano, bâli yamiinwi, anakizi múgashaanira. Iri hakatama, anamúgira abe mutoni imunda umukulu weꞌyo nyumba. ");
INSERT INTO flr_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ulya mukulu anabiika Yusefu akizi yimangira abaabo bashwekwa booshi. Ngiisi íbyâli kizi koleka mwo, Yusefu ye wâli kizi bihanguula. ");
INSERT INTO flr_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Uyo mukulu, bwo âli mali sikiiriza Yusefu imikolwa yoshi, ndaabyo byo âli kizi ki yilibuza kwo. Mukuba, Nahano âli yamiri na Yusefu, anakizi múgenduusa mu kati ka byoshi. ");
INSERT INTO flr_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Iri hakalenga isiku, bakulu babiri boꞌkukizi kolera mwami weꞌMiisiri, banamúhubira. Muguma, ye wâli yimangiiri abakozi boꞌkukizi heereza mwami ibinywebwa. Noꞌwabo, âli yimangiiri boꞌkukizi múyokera imikate. ");
INSERT INTO flr_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Uyo mwami, iri akabona ngiisi kwo bamúhubira, anabona buligo, ");
INSERT INTO flr_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","anabalasha bombi mu nyumba yeꞌmbohe. Munali mwo Yusefu naye âli koli shwekiirwi. ");
INSERT INTO flr_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ulya mukulu woꞌkukizi langa mwami, anatoola Yusefu, kwo ye gakizi batanduula. Yabo bashwekwa bombi, banabeera mwomwo. Iri hakashubi lenga isiku, ");
INSERT INTO flr_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","bushigi buguma, mwiꞌyo nyumba yeꞌmbohe, uyo woꞌkuheereza mwami ibinywebwa, noꞌlya woꞌkukizi múyokera imikate, ngiisi muguma analoota ibyage-byage birooto. ");
INSERT INTO flr_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Shesheezi, ikyanya Yusefu akazindukiri gendi batanduula, anagwana bombi bashengusiri, ");
INSERT INTO flr_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","anababwira: «Biki ibyaba zeene? Si amalanga giinyu gakoli zizibiiri!» ");
INSERT INTO flr_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Nabo, ti: «Twe noꞌwitu, twaloota ibirooto. Si ndaaye woꞌkutusobanulira byo.» Uyo Yusefu, ti: «Ukusobaanura ibirooto, gulyagagi mukolwa gwa Rurema. Aaho! Mubindotoloolere.» ");
INSERT INTO flr_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ulya woꞌkuheereza mwami ibinywebwa, analotoloolera Yusefu ibirooto byage, ti: «Mu birooto byani, nabona umuzabibu imbere lyani, ");
INSERT INTO flr_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","gushuba naꞌmatavi gashatu. Mbu gutondeerage ukushoga, lyeryo gwanayami yasa akaaso, halinde gwanaleeta imihuli íhiiri. ");
INSERT INTO flr_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Na bwo njubi fumbiiti urusoozo lwa Faraho, nanayabiira irya mizabibu, nanakizi gikamatulira mu rusoozo, nanamúfumbasa lwo.» ");
INSERT INTO flr_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yusefu, ti: «Isobaanuro lyeꞌbirooto byawe, lyo lyeri: Yago matavi gashatu, ziryagagi siku zishatu. ");
INSERT INTO flr_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Mu yizo siku, Faraho agakushwekuula, anashubi kugalulira ku mukolwa gwawe. Ugakizi shubi múheereza urusoozo, nga ngiisi kwo wâli tuula umúheereza lwo, ku kyanya wâli ki riiri mukozi wage. ");
INSERT INTO flr_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","«Aaho! Nakuyinginga, we kongwa, ikyanya ugagenduukirwa, naani ukangengeere. Ubwirage Faraho ngiisi kwo ngola, halinde naani ndonge ukuhuluka mwiꞌno nyumba. ");
INSERT INTO flr_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Si nꞌgashaazibwa ku misi mu kihugo kyaꞌBaheburaniya. Kiri na hano i Miisiri, ndaabyo nꞌgagira, íbyangatuma ngashwekwa.» ");
INSERT INTO flr_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ulya mukulu woꞌkukizi yokera mwami imikate, anabona ngiisi kweꞌsobaanuro lyo babwira uwabo lyamúshambaaza. Kyanatuma naye, agabwira Yusefu: «Kiri na naani, halyagagi ibirooto byo naloota. Nabona kwo njubi betwiri ibitiri bishatu byeꞌmikate ");
INSERT INTO flr_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","kwiꞌtwe lyani. Mu kitiri íkishuba hiꞌgulu lyeꞌbyabo, mushuba imikate ya kwingi-kwingi yoꞌkuheereza mwami. Haliko, utunyuni twanakizi yiji gijojomola.» ");
INSERT INTO flr_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yusefu, ti: «Isobaanuro lyeꞌbirooto byawe, lyo lyeri: Birya bitiri bishatu, ziryagagi siku zishatu. ");
INSERT INTO flr_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Mu yizo siku, Faraho agakutola itwe, unamanikwe ku kiti. Utunyuni, tunakizi yiji jojomola amagala gaawe.» ");
INSERT INTO flr_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ulusiku úlugira izishatu, lwo lwâli riiri lusiku lukulu lwoꞌkukengeera ukubutwa kwa Faraho. Kwokwo, Faraho anagirira abatwali baage booshi ulusiku lukulu. Mwiꞌrya nyumba yeꞌmbohe, anahulusa ulya mwimangizi woꞌkukizi heereza mwami ibinywebwa, kuguma noꞌlya woꞌkukizi yokera mwami imikate. Anabayimangika imbere lyaꞌbatwali. ");
INSERT INTO flr_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ulya mwimangizi woꞌkukizi múfumbasa ikinywebwa, anamúgalulira mu mukolwa, gira akizi shubi múheereza urusoozo. ");
INSERT INTO flr_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Halikago, uyo uwabo yehe, anamúmanika ku kiti, nga kwokulya Yusefu âli mali gwanwa amúsobaanulira. ");
INSERT INTO flr_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kundu kwokwo, uyo mwimangizi woꞌkukizi heereza mwami ibinywebwa, atanaki kengeera Yusefu, si anayami múyibagira lwoshi. ");
INSERT INTO flr_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Iri hakalenga imyaka ibiri, Faraho naye analoota, anabona kwo ayimaaziri ku ngombe yoꞌlwiji Niire. ");
INSERT INTO flr_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Mu kati kaalwo, anabona kwo mwayogoroka ingaavu zirinda nyiija, zinashishiri. Yizo ngaavu, zanatondeera ukuliisa mu lujaga. ");
INSERT INTO flr_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ha nyuma lyazo, mwanashubi yogoroka izindi ngaavu zirinda, zoꞌmujambiira. Yizo zindi, zanayimanga ku ngombe yoꞌlwiji, ha butambi lya zirya zaabo nyiija. ");
INSERT INTO flr_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Zirya ngaavu zirinda zoꞌmujambiira, zanayami mirangusa zirya zaabo. Lyeryo, Faraho anasisimuka mwiꞌro. ");
INSERT INTO flr_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Iri akashubi hunira, anashubi loota. Anabona imihuli irinda miija íjoojesiri, iri kwiꞌsina liguma. ");
INSERT INTO flr_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ha nyuma, anashubi bona igindi mihuli irinda, ífumiri. Iyo mihuli, imbuusi ngayu yanahuusa mwiꞌshamba, uluhande lweꞌsheere, yanayumaguka. ");
INSERT INTO flr_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Irya mihuli íyâli fumiri, yanayami mirangusa irya íjoojesiri. Faraho anashubi sisimuka, anayami menya kwo bishuba birooto. ");
INSERT INTO flr_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Iri bukakya shesheezi kare-kare, mwami anagwatwa neꞌndaania, kyanatuma agatumira abanamaleere booshi ba mu kihugo kyeꞌMiisiri, kuguma naꞌbanabwitegeereze booshi. Birya birooto, ikyanya akabalotololera byo, ndaaye kiri noꞌmuguma wabo úkashobola ukumúbwira umugeeza gwabyo. ");
INSERT INTO flr_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Lyeryo, ulya mwimangizi woꞌkukizi heereza Faraho ibinywebwa, anamúbwira: «E nahamwitu, zeene, lyo nakengeera amahube gaani. ");
INSERT INTO flr_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Niehe noꞌlya mwimangizi woꞌkukizi kuyokera imikate, ku kyanya ukaturakarira, ukayami tulasha mu nyumba yeꞌmbohe. Ku kyekyo kyanya, ulya mukulu waꞌbasirikaani âli kizi tulaliira. ");
INSERT INTO flr_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","«Bushigi buguma, tukaloota. Ngiisi muguma witu akaloota byage-byage. ");
INSERT INTO flr_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Mwomwo, mwâli riiri musore muguma Muheburaniya. Âli riiri mukozi woꞌmukulu waꞌbasirikaani boꞌkukulaliira. Naye, twâli ririinwi mwiꞌyo nyumba yeꞌmbohe. E nahamwitu, iri tukamúlotololera byo, anayami tusobaanulira byo, ngiisi muguma witu ukukulikirana na kwo aloota. ");
INSERT INTO flr_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Na ngiisi kwo akabisobaanura, kwokwo kwo bikanaba. Niehe, nanagalulirwa mu mukolwa gwani. Si uwitu, yehe anamanikwa ku kiti.» ");
INSERT INTO flr_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Buzira kutindirira, mwami anayami kyula kwo Yusefu aleetwe. Kyanatuma bagayami múhulusa mu nyumba yeꞌmbohe, banamúbega, banamúyambika ibyambalwa byoꞌmulimbo. Ha nyuma, analeetwa imbere lya Faraho. ");
INSERT INTO flr_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Iri Faraho akamúbona, anamúbwira: «Naloota ibirooto. Si ndaaye úwahasha ukubinzobaanulira. Keera nayuvwa ngiisi kwo bagweti bagakuhuuza, kweꞌkyanya bali mu kulotololera, uli mu yami bisobaanura.» ");
INSERT INTO flr_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Uyo Yusefu anashuvya mwami: «Nienyene ndangahasha. Haliko Rurema ashobwiri. Ye gakulimbulira ibirooto byawe.» ");
INSERT INTO flr_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Lyeryo, uyo mwami anamúbwira: «Mu birooto byani, nâli yimaaziri ku ngombe yoꞌlwiji Niire. ");
INSERT INTO flr_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Nanabona ingaavu zirinda nyiija, ízishishiri, zayogoroka mu lwiji, zanatondeera ukuliisa mu lujaga. ");
INSERT INTO flr_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ha nyuma, nanashubi bona izindi ngaavu zirinda, zoꞌmujambiira. Nazo zanayogoroka mu lwolwo lwiji. Emwe! Mu kino kihugo kyeꞌMiisiri, ndazindi bona ingaavu mbi mwene yizo. ");
INSERT INTO flr_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","«Yizo ngaavu zirinda zoꞌmujambiira, zanayami mirangusa zirya zaabo ízishishiri. ");
INSERT INTO flr_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Na kundu zikazimirangusa, ndaaye mundu úwangamenyiri. Si zikayama naaho zijambiri. Lyeryo, nanayami sisimuka. ");
INSERT INTO flr_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","«Ha nyuma, nanashubi loota, nanabona imihuli irinda yeꞌngano miija, inajoojesiri, iri kwiꞌsina liguma. ");
INSERT INTO flr_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ha nyuma lyayo, nanashubi bona igindi mihuli irinda yeꞌngano ífumiri. Iyo mihuli, imbuusi ngayu yanashaaga mwiꞌshamba, uluhande lweꞌsheere, yanagiyumagusa. ");
INSERT INTO flr_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","«Lyeryo ngana, iyo mihuli ífumiri, yanayami mirangusa irya yabo miija. Kundu nꞌgabilotoloolera abanamaleere, si ndaaye kiri noꞌmuguma úkahasha ukubinzobaanulira.» ");
INSERT INTO flr_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Uyo Yusefu, anabwira Faraho: «E mwami, yibi birooto byawe kwo biryagagi byombi, biri noꞌmugeeza muguma naaho. Rurema, aloziizi ukukuyigulira amagambo go akola agaagira buno. ");
INSERT INTO flr_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","«E waliha, zirya ngaavu zirinda ízishishiri, iryagagi myaka irinda. Neꞌrya mihuli irinda miija, iri yeyo myaka irinda. Yibi birooto, umugeeza gwabyo guli muguma naaho. ");
INSERT INTO flr_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Zirya ngaavu zirinda zoꞌmujambiira, iryagagi myaka irinda yoꞌmwena. Neꞌrya mihuli irinda ífumiri, nayo idesiri hiꞌgulu lya yeyo myaka. ");
INSERT INTO flr_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","«E mwami, nga kwo keera nakubwira, Rurema keera akuyigulira amagambo go akola agaagira buno. ");
INSERT INTO flr_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Mu kino kihugo kyoshi kyeꞌMiisiri, mukola mugaahisa imyaka irinda muli mu yeza bweneene. ");
INSERT INTO flr_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ha nyuma, hanayijage imyaka irinda yoꞌmwena, gunagunuuze mu kihugo kyoshi. Kwiꞌrya myaka mizinda, irya mimbu mingi igayibagirwa lwoshi. ");
INSERT INTO flr_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","E waliha, haaho, irya myaka irinda yeꞌbyokulya bingi itagaki kengeerwa. ");
INSERT INTO flr_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","«Yibyo birooto, bwo bikagalukirwa mwo ubugira kabiri, biyerekiini kwo Rurema keera atwa uluhango, ataganaki tindiriza, mu kubikwiza. ");
INSERT INTO flr_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«Ku yukwo, e mwami! Ukwaniini utoolage umundu úli noꞌbumenyi, anali mwitegeereza. Uyo mundu, umúheereze umukolwa gwoꞌkurongoora kino kihugo kyoshi kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","«Na kwakundi, e mwami! Mu kino kihugo, mwiꞌyi myaka irinda yeꞌmimbu, utoolage abimangizi, unababwire kwo bakizi kuumania ikihande kiguma kya kataanu kyeꞌmimbu yoshi. ");
INSERT INTO flr_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","«Yabo bimangizi, ubabwirage kwo mwiꞌyo myaka irinda yeꞌmimbu, mu ngiisi kaaya bakuumanie ibihinda byeꞌngano ku bwingi, banabilange. E mwami, iyo ngano, wenyene ube we gagiyimangira. ");
INSERT INTO flr_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Yibyo byokulya, kibaagage kihinda kyoꞌkukizi langa ikihugo kyeꞌMiisiri, gira gulya mwena gweꞌgindi myaka irinda, gutakisivye.» ");
INSERT INTO flr_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yiri ihano, ikyanya akalitanga, Faraho analisiima bweneene, kuguma naꞌbatwali booshi ba mu bwami bwage. ");
INSERT INTO flr_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Anayami deta: «E bagingi, uyu mundu, ali mwoꞌmutima gwa Rurema. Aahago! Ka twangaki longa ugundi úli nga ye?» ");
INSERT INTO flr_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Uyo mwami, analola ku Yusefu, anamúbwira: «Ewe! Yaga gooshi, Rurema ye wakuyigulira go. Tutaki bwini ugundi úli noꞌbumenyi, anali mwitegeereza, nga we. ");
INSERT INTO flr_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Aahago! Bwobuno, we kola úgayimangira ikihugo kyani. Abandu baani booshi, bagaaba mwiꞌdako lyoꞌbutwali bwawe. Niehe naaho, nie gakukulira, bwo nie bwatiiri ku kitumbi kyoꞌbwami. ");
INSERT INTO flr_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mu kihugo kyoshi kyeꞌMiisiri, nakuyimika ube mutwali wakyo.» ");
INSERT INTO flr_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Haaho, Faraho anahogola imbete yage yaꞌkamangu ku munwe, anagiyambika Yusefu. Anamúyambika neꞌbyambalwa byoꞌmulimbo byeꞌkitaani, kuguma noꞌmugufu gweꞌnooro mwiꞌgosi. ");
INSERT INTO flr_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Anamúshonia mwiꞌgaare lyage liꞌzibo, lirya lyeꞌmwa ikirindirizi kyage. Abalemberezi banagenda imbere lyage, iri banabanda akabuuli, ti: «Heerezi Yusefu injira, alenge! Heerezi Yusefu injira, alenge.» Kwokwo, kwo Faraho akayimika Yusefu, abe mutwali mu kihugo kyoshi kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Faraho anashubi bwira Yusefu kwokuno: «Bwo nie Faraho, buno nakyula: Mu kino kihugo kyoshi kyeꞌMiisiri, hatagire umundu úgaagira igambo lyoshi, buzira buhanguule bwawe.» ");
INSERT INTO flr_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Uyo Faraho, anayinika Yusefu iziina lyeꞌkimiisiri Safenati-Paneya. Anamúgondera Hasinaati munyere Potifeera, umugingi weꞌHoni. Kwokwo, Yusefu anatondeera ukukizi genda agatanduula ikihugo kyoshi kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ikyanya akatondeera ukukolera mwami weꞌMiisiri, âli kola neꞌmyaka makumi gashatu. Kwokwo, analyoka imwa mwami, anagenda agatanduula ikihugo kyoshi. ");
INSERT INTO flr_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Mwiꞌrya myaka irinda yeꞌmimbu mingi, yizo ndalo zeꞌMiisiri zanahemba bweneene. ");
INSERT INTO flr_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kwokwo, Yusefu analunda ibyokulya ku bwingi. Mu twaya twoshi, anabiika mweꞌbihinda byabyo. Yibyo bihinda, byâli riiri mu ndalo ízâli riiri hoofi na ngiisi kaaya. ");
INSERT INTO flr_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yibyo bihinda byeꞌngano, anabiyubasa ku bwingi, yanaluguuka nga mushenyu ku nyaaja, halinde abandu batanahasha ukuharuura ulugero lwayo. ");
INSERT INTO flr_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Yugwo mwena, ikyanya gutazi teera, Yusefu âli koli busiri abaana babiri ku mukaage Hasinaati. ");
INSERT INTO flr_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Mugala wage weꞌfula, anamúyinika iziina Manaasi, ti: «Rurema keera anyibagiza amalibu gaani gooshi, anyibagiza kiri neꞌmbaga ya daata.» ");
INSERT INTO flr_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mugala wage wa kabiri, anamúyinika iziina Hifurahimu, ti: «Rurema keera ambeereza ibuta mu kihugo kyo nalibuukira mwo.» ");
INSERT INTO flr_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Yumwo mu Miisiri, irya myaka irinda yeꞌmimbu yanahinjuka. ");
INSERT INTO flr_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Imyaka irinda yoꞌmwena yanatondeera, nga kwokulya Yusefu âli mali gwanwa adeta. Yugwo mwena, gwanateera kiri naꞌgandi mahanga gooshi. Haliko mu kihugo kyeꞌMiisiri, mwohe mwâli ki riiri ibyokulya. ");
INSERT INTO flr_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Abatuulaga beꞌMiisiri, ikyanya bakatondeera ukushalika, banakizi tibitira imunda Faraho, kwo abaheereze ibyokulya. Haliko, Faraho anakizi babwira: «Mugendage imwa Yusefu. Na ngiisi kwo agamùbwira, kunabe kwo mugaagira.» ");
INSERT INTO flr_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Hooshi mu kihugo, gulya mwena gwanagunuuza ngana, kyanatuma Yusefu agahanguula kweꞌbihinda byoshi bya mu twaya biyigulwe, anakizi guliikiza Abamiisiri ibyokulya. ");
INSERT INTO flr_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Na bwoꞌmwena gukagunuuza mu mahanga gooshi, abandu ukulyoka mu ngiisi mahanga, banakizi yija i Miisiri, gira bagule ingano imunda Yusefu. ");
INSERT INTO flr_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yakobo anayuvwa kwo mu kihugo kyeꞌMiisiri mukiri ingano, anabwira bagala baage: «E baana baani, kituma kiki mubwatiiri, munali mu lolana-lolana kwo? ");
INSERT INTO flr_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Si keera nayuvwa kwo mu kihugo kyeꞌMiisiri muli ingano. Aahago! Niinyu mugendi tusumira yo, tutayiji kengeera twafwa noꞌmwena.» ");
INSERT INTO flr_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Yabo bakulu ba Yusefu kwo bâli ikumi, booshi banagenda i Miisiri, gira bagendi gula yeꞌngano. ");
INSERT INTO flr_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Si Binyamiini yehe, yishe atanasiima kwo amútume yo. Mukuba, âli mulumuna wa Yusefu, na yishe âli yobohiri kwo angakoli gendi komeereka. ");
INSERT INTO flr_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Yabo bagala Yakobo, banayiji suma ingano i Miisiri, kuguma naꞌbandi booshi. Mukuba, mu kihugo kyeꞌKaanani, yugwo mwena gwâli kola mu gunuuza ngana-ngana. ");
INSERT INTO flr_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Mu kihugo kyeꞌMiisiri, Yusefu ye wâli kola mutwali mwiꞌdako lya Faraho. Ye wanâli kizi guliisa mweꞌngano ku bandu booshi. Kwokwo, yabo beene wabo, iri bakahika, banafukama imbere lyage, banahisa amalanga haashi. ");
INSERT INTO flr_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yusefu, mbu ababonage, anayami bamenya. Haliko, anayigira nga útabayiji, anatondeera ukubamamira, ti: «Mwehe, hayagi mwalyoka?» Nabo, ti: «E waliha, twalyoka mu kihugo kyeꞌKaanani, gira tuyiji suma.» ");
INSERT INTO flr_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yusefu, kundu akamenya bakulu baage, haliko boohe, batâli ki múyiji. ");
INSERT INTO flr_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Birya birooto byo akaloota hiꞌgulu lyabo, anayami bikengeera, kyanatuma agababwira: «Nanga! Mweshi muli bagahirizi. Mwayiji gahiriza kino kihugo kiitu, gira mulonge ukumenya ubukaholwe bwakyo.» ");
INSERT INTO flr_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yabo bakulu baage, ti: «Nanga, e nahamwitu! Twehe, tuli bakozi baawe. Twayiji suma naaho. ");
INSERT INTO flr_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Kwo utubwini tweshi, tuli twe baguma. Tutalyagagi bagahirizi, si tuli bandu boꞌkuli.» ");
INSERT INTO flr_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yusefu anakaviiriza ukubabwira: «Nanga, mwabeesha. Mukola mu yija mu kino kihugo kiitu, gira mukigandiize, mumenye ubukaholwe bwakyo.» ");
INSERT INTO flr_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Nabo, ti: «Nanga, e waliha! Kundu tulyosiri i Kaanani, haliko tuli bakozi baawe. Tweshi, tukabutwa na daata muguma. Twâli riiri misore ikumi niꞌbiri, haliko umuzibo gwitu, gwasigala na daata. Noꞌgundi mulumuna witu, keera akafwa.» ");
INSERT INTO flr_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Uyo Yusefu anashubi bamamira, ti: «Biri nga kwo keera nadeta. Muli bagahirizi. ");
INSERT INTO flr_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Buno, ngola ngamùgera. Nashiikiza kwiꞌziina lya Faraho, mwami weꞌMiisiri. Uyo gundi mulumuna winyu, mútazi múleeta hano, mutagahalyoka. ");
INSERT INTO flr_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Muguma winyu, ayami gendi múleeta. Naꞌbandi booshi basigale hano, bashwesirwi. Lyoki yibyo mwadeta, lyo tugalonga ukumenya akasiisa kaabyo. Neꞌri byangaboneka kwo mwabeesha, nashiikiza kwiꞌziina lya Faraho, mwami weꞌMiisiri, kwo muli bagahirizi.» ");
INSERT INTO flr_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Lyeryo ngana, uyo Yusefu anayami balasha mu nyumba yeꞌmbohe, banabeera mwo isiku zishatu. ");
INSERT INTO flr_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ku lusiku úlugira izishatu, Yusefu anashubi babwira: «Niehe, nyamiri nzimbahiri Rurema. Aaho! Yuvwagwi ngiisi kwo mwangagira, lyo mulonga ukutuula ho. ");
INSERT INTO flr_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Iri mwangaba muli bandu boꞌkuli, muguma winyu asigalage hano ali mushweke. Abandi batwalire imbaga ziinyu ingano, bwo zikoli shalisiri. ");
INSERT INTO flr_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Si ulya mulumuna winyu, mukamúndeetere, halinde lyo nimenya kwaꞌmagambo giinyu gali goꞌkuli. Iri mwangagira kwokwo, mutagaki yitwa.» Yabo bakulu baage, banagira nga kwo akababwira. ");
INSERT INTO flr_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Ha nyuma, banabwirizania: «Ku kasiisa, tukahubira mulumuna witu. E balya, si tukabona kwo âli koli shengusiri mu mutima gwage, anakizi tuyigonga. Kundu kwokwo, tutanamútwaza. Buno nyiitu tukola mu zeezirya ndaanya.» ");
INSERT INTO flr_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubeni anababwira: «Ka ndakamùhanuula kwo tutagire mulumuna witu buligo? Halikago mutakanyuvwa. Na buno, tukola mu hanwa hiꞌgulu lyoꞌmuko gwage.» ");
INSERT INTO flr_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yabo bakulu ba Yusefu, batâli yiji kwo abayuvwiti. Mukuba, ikyanya âli kizi baganuuza, ha kati kaabo, hâli kizi biikwa woꞌkukizi basobanulira. ");
INSERT INTO flr_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Haaho, Yusefu anabayihandula kwo, anagendi lira. Iri akayusa ukulira, anagalukira ho bali. Lyeryo, anayabiira Simyoni mu kati kaabo, anayami múfunda mu nyumba yeꞌmbohe, mu masu gaabo. ");
INSERT INTO flr_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Uyo Yusefu, anakyula kwo ngiisi muguma wabo, ubusuuzu bwage buyijuzibwe mweꞌngano. Na zirya fwaranga za ngiisi muguma, zibiikwe mu busuuzu bwage. Anashubi kyula kwo babahambirage neꞌndanda. Yibyo byoshi, banabagirira byo. ");
INSERT INTO flr_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Yago masuuzu gaabo kwo gâli kola mweꞌngano, banagashoneza ku bapunda baabo, banataaha. ");
INSERT INTO flr_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Iri bakahika ho bâli kizi handa, muguma wabo anashwekuula ubusuuzu, gira aheereze punda wage ibyokulya. Yehee! Anagwana ifwaranga zaage ziri mbiike ha kanwa koꞌbusuuzu bwage. ");
INSERT INTO flr_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Anabwira abaabo: «E balya, niehe, izaani fwaranga bazingalulira. Zeezino, nazigwana ha kanwa koꞌbusuuzu.» Yabo baabo, mbu bayuvwagwe kwokwo, banashenguka. Banakizi lolana-lolana kwo, iri banalenga mwoꞌmusisi, banabuuzania: «Maki gano Rurema atugirira?» ");
INSERT INTO flr_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Iri bakaba keera bahika mu kihugo kyeꞌKaanani, áhali yishe Yakobo, banamúganuulira ngiisi íbyabakoleka kwo, ti: ");
INSERT INTO flr_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","«E daata, umutwali wa mu kihugo kyeꞌMiisiri akatumamira bweneene, anatukeeka kwo ngeeka twagendi gahiriza ikihugo kyabo. ");
INSERT INTO flr_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","«Haliko twanamúshuvya: “E waliha, twehe tutali bagahirizi. Si tuli bandu boꞌkuli! ");
INSERT INTO flr_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Tuli baana ba daata muguma. Tukabutwa misore ikumi niꞌbiri. Mulumuna witu muguma, keera akafwa. Na woꞌmuzibo, ye sigiiri na daata mu kihugo kyeꞌKaanani.” ");
INSERT INTO flr_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","«Lyeryo, ulya mutwali anatubwira: “Íbiganyereka kwo muli bandu boꞌkuli, muguma winyu asigalage hano, na mwe bandi mweshi mugalukire i kaaya. Bweꞌmbaga ziinyu zikoli shalisiri, mubatwalire ingano. ");
INSERT INTO flr_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","«“Si ulya mulumuna winyu, mukamúndeetere. Kwokwo, lyo ngaamenya kwo mutali bagahirizi, si muli bandu boꞌkuli. Mango mwamúhisa, lyo ngashwekuula uno, munahanguulwe kwo mukizi yiji dandaliza hano.”» ");
INSERT INTO flr_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Yabo bakulu ba Yusefu, iri bakaba bakola mu fukumula ingano mu masuuzu, yee! Ngiisi muguma wabo anagwanana izaage fwaranga zagalukira mu busuuzu bwage. Iri bakazibona, kwo bali booshi na yishe, banatondeera ukuyoboha. ");
INSERT INTO flr_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Haaho, Yakobo anabwira bagala baage kwokuno: «Ka muloziizi ukummalira abaana? Yusefu na Simyoni batakiri ho. Na buno mukoli loziizi ukutwala Binyamiini naye. Ala nie! Si yaga malibu gooshi, galyagagi kwiꞌtwe lyani!» ");
INSERT INTO flr_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Lyeryo, Rubeni anabwira yishe: «E daata, uyu Binyamiini, iri ndangamúgalukana, unayami yita yaba bagala baani bombi. Nakuyinginga, we kongwa, unyemeere kwo ngamúgalukana.» ");
INSERT INTO flr_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Haliko Yakobo, ti: «Umwana wani, mutangamúndwala. Mukulu wage keera akafwa. Na buno, uno ye koli sigiiri yenyene naaho. Aahago! Si mubwini kwo ngola mushaaja bweneene! Uyu mwana wani, iri angakoli gendi komeerekera mu njira, umukuume guganyita, kunabaagage hiꞌgulu liinyu.» ");
INSERT INTO flr_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Mu kihugo kyeꞌKaanani, yugwo mwena gwanagenderera ukugunuuza. ");
INSERT INTO flr_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Irya ngano yo bagala Yakobo bakagula i Miisiri, yâli kola bu mala. Kwokwo, Yakobo anababwira: «E baana baani, mushubi galukira i Miisiri, gira mugendi looza byo tugaalya.» ");
INSERT INTO flr_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Haliko, Yuda anashuvya yishe: «E daata, ulya mutwali akatubwira ku bweranyange: “Mulumuna winyu, iri mutangamúleeta, mutakolwe kwo mwaboneka mu masu gaani.” ");
INSERT INTO flr_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","«Aaho! Iri wangahanguula kwo tugendage na Binyamiini, lyoki tugagendi kugulira ibyokulya. ");
INSERT INTO flr_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Haliko, iri wanganana, nyiitu, ndaaho tugagenda. Ulya mutwali, akatubwiririra: “Mulumuna winyu, iri mutangamúleeta, mutakolwe kwo mwaboneka mu masu gaani.”» ");
INSERT INTO flr_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Hisiraheeri, ti: «Aahago! Kuti kuno mugandibuza, mu kuyami bwira ulya mutwali kwo muki hiiti ugundi mulumuna winyu?» ");
INSERT INTO flr_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Na wa nabo, ti: «Akatugaaha bweneene, gira alonge ukumenya ngiisi kwo tuli, kiri neꞌmbaga yitu. Anatubuuza: “Ka yisho akiri ho? Ka hakiri ugundi mulumuna winyu ye muki gweti?” Yibyo bibuuzo byage, twanabishuvya. Aaho! Ka twâli yiji kwo agatubwira kwo tutwalage mulumuna witu?» ");
INSERT INTO flr_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Lyeryo, Yuda anashubi múbwira: «E daata, uyu mulumuna witu, uleke nimútwale. Ee maashi, ayimukage, tugendanwe. Iri tutangamútwala, ishali ligatulambuula tweshi, kiri na yaba baana biitu. ");
INSERT INTO flr_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Kwoku nienyene, nayitanga mbe ngwati yoꞌyu mugala wawe. E waliha, niehe, nie ugamúbuuza. Iri ndangakugalukirana ye, halinde ushubi múbona, wangakizi deta halinde imyaka neꞌmyakuula kwo nie wakuhubira. ");
INSERT INTO flr_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Aahago! Tútakibe ngana twatinda, nga keera twagalukira yo ubugira kabiri.» ");
INSERT INTO flr_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Lyeryo, yishe anababwira: «Bwo biri kwokwo, muyabiirage ku bindu biija bya mu kino kihugo kiitu, munabihambe mu ndaha ziinyu, munabitwalire uyo mutwali, lube lutengu. Mumútwalire ku buuki, naꞌmavuta maniini goꞌmushishi, noꞌmubadu, naꞌmanemane, neꞌkungu, neꞌloozi. ");
INSERT INTO flr_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","«Na ku fwaranga zo mwâli twaziri, muyushuule kweꞌzindi íziri nga zo. Zirya fwaranga ízikagalulwa mu masuuzu giinyu, mukwaniini muzigalulage. Hali ikyanya angaba akatagalwa mu kumùgalulira zo. ");
INSERT INTO flr_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","«Uyu mulumuna winyu, mugendanwe imwoꞌyo mutwali. ");
INSERT INTO flr_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Rurema woꞌbushobozi bwoshi amùtabaalage, gira amùyuvwirwe indengeerwa. Amùshwekuulire mwene winyu wa Simyoni, munagalukage mweshi kuguma na Binyamiini. Neꞌri abaana baani booshi bagamberera, bibaagage kwokwo.» ");
INSERT INTO flr_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Yabo bagala Yakobo, banayabiira yulwo lutengu, kuguma na zirya fwaranga za mbere, banayushuula na kweꞌzindi íziri nga zo, banatwala na mulumuna wabo wa Binyamiini, banagenda i Miisiri. Neꞌri bakahika yo, banayiyerekana imunda Yusefu. ");
INSERT INTO flr_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yusefu, mbu abonage Binyamiini ali kuguma na bakulu baage, anabwira umukozi wage: «Yaba bageezi, ubatwale i kaaya. Ugendi yabiira ikitugwa kiguma, unakibaage, unakideeke. Ku kyanya kyaꞌkalenge-renge, tugayiji shangiira ibyokulya twe nabo.» ");
INSERT INTO flr_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Uyo mukozi, anagendi gira nga ngiisi kwo abwirwa, anatwala yabo bakulu ba Yusefu imwage. ");
INSERT INTO flr_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Neꞌri bakaba bakola mu twalwa, imitima yabo yanajajuka, banatondeera ukubuuzania: «E balya, zirya fwaranga ízikagalulwa mu masuuzu giitu, ziryagagi nga zo zatuma twatwalwa imwage. Buno akoli loziizi ukutushweka, gira alonge ubulyo bwoꞌkutunyaga bapunda biitu, anatugire tube baja baage.» ");
INSERT INTO flr_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Iri bakahika ha kisimba-lyango kyeꞌnyumba ya Yusefu, banayegeera umukozi wage, banamúbwira: ");
INSERT INTO flr_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«E nahamwitu, twakuyinginga utukejeerere. Ku lulya lugeezi lwitu lwa mbere, ikyanya tukayiji gula ibyokulya hano, ");
INSERT INTO flr_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","tukahika haꞌbageezi bali mu handa. Neꞌri tukashwekuula amasuuzu giitu, twanakanguka ngana mu kubona ngiisi muguma witu, izaage fwaranga ziri mbiike ha kanwa koꞌbusuuzu bwage, buzira kuhala mwo. Aaho! Buno, twazireeta. ");
INSERT INTO flr_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Yizo fwaranga, tutayiji nyandagi úkazibiika mu masuuzu giitu. Na kwakundi, twaleeta neꞌzindi zoꞌkugula mweꞌbindi byokulya.» ");
INSERT INTO flr_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ulya mukozi anababwira: «Mutuuzagye, mutanayobohe. Rurema winyu, ye na Rurema wa yisho. Yehe Rurema, ye kazibiika mu masuuzu giinyu. Zirya fwaranga ziinyu zeꞌbyokulya, keera nꞌgaziyakiira.» Lyeryo, anashwekuula mwene wabo wa Simyoni. ");
INSERT INTO flr_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Uyo mukozi, anabatwala mu mwa Yusefu, anabaheereza amiiji goꞌkuleeza ku magulu, anayahirira na bapunda baabo. ");
INSERT INTO flr_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Na bwo bâli mali gwanwa babwirwa kwo bagayiji shangiira ibyokulya na Yusefu, kyanatuma bagagwanwa balingikania ulutengu, gira bamúheereze lwo. Mukuba, âli agaahika ku kyanya kyaꞌkalenge-renge. ");
INSERT INTO flr_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Uyo Yusefu, iri akataaha, banamúheereza yulwo lutengu. Lyeryo, booshi banafukama imbere lyage, banahisa amalanga haashi. ");
INSERT INTO flr_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yusefu anababuuza: «Ka mukiri bagumaana? Mukadeta kwo muki hiiti yisho. Aahago! Ka naye akiri mugumaana? Ka anakiri ho?» ");
INSERT INTO flr_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Na wa nabo, ti: «Daata alyagagi mukozi wawe. Akiri mugumaana, anakiri ho.» Banashubi yinama kandi mu kumúheereza ulushaagwa. ");
INSERT INTO flr_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Uyo Yusefu, mbu alambuulage amasu, anabona mulumuna wage wa Binyamiini, ye babutanwa, anabuuza: «Uyu, ka ye mulumuna winyu ye mukambwira?» Anabwira uyo mulumuna wage: «E mwana wani, Rurema akizi kugashaanira.» ");
INSERT INTO flr_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Lyeryo Yusefu, anayami gwatwa neꞌngumbu nyingi hiꞌgulu lyoꞌyo mulumuna wage. Na bwo âli kola neꞌkifufu, kyanatuma agayimuka, anayingira mu kindi kisiika, anatondeera ukulira. ");
INSERT INTO flr_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Iri akayusa ukulira, analeeza amiiji i malanga, anayiyungumania. Anahuluka mu kisiika, anadeta: «Muleetage ibyokulya.» ");
INSERT INTO flr_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Iri bakabireeta, banamúbiikira haage-haage. Na beene wabo nabo, banababiikira haabo-haabo. Kiri naꞌBamiisiri ábâli laalisirwi na Yusefu, nabo banabiikirwa haabo-haabo. Mukuba, Abamiisiri, bâli kizi neena ukushangiira naꞌBaheburaniya, mbu bwo bâli riiri kizira. ");
INSERT INTO flr_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yabo bakulu ba Yusefu, banababwataza imbere lyage, ukukulikirana na kwo bâli londiini mu kubutwa, ukutondeerera ku weꞌfula, halinde ku woꞌmuzibo. Ikyanya bakabona kwokwo, banakizi lolana-lolana kwo, banasoomwerwa bweneene. ");
INSERT INTO flr_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Yusefu, anakyula kwaꞌbakozi baage bakizi lyosa ku byokulya íbyâli ku kashasha kaage, bakizi bitwala áhali bakulu baage. Si Binyamiini yehe, bakamúheereza ibyokulya ubugira kataanu, ukuhima abaabo. Yabo booshi, bananywa idivaayi, banashagaluka. ");
INSERT INTO flr_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Ha nyuma, Yusefu anabwira umwimangizi weꞌnyumba yage: «Yaba bandu, mu masuuzu gaabo, uhambage mweꞌngano yo ngiisi mundu angagala. Neꞌfwaranga za ngiisi muguma wabo, unakizi zibiika ha kanwa koꞌbusuuzu bwage. ");
INSERT INTO flr_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mu busuuzu bwoꞌlya woꞌmuzibo, uhambe mweꞌfwaranga zaage, uhambage na mwoꞌrukuzo lwani, lulya úlukatulwa mu harija.» Uyo mwimangizi, mbu ayuvwe ngiisi kwo nahamwabo amúbwira, anagendi bigira. ");
INSERT INTO flr_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Iri bukatejuukana, bakulu ba Yusefu banahanguulwa kwo bataahage na bapunda baabo. ");
INSERT INTO flr_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Neꞌri bakaba batazi hika hala naꞌkaaya, Yusefu anabwira ulya mwimangizi: «Vwaruka, ukulikire baliira bandu. Mango wabaduuka, unababuuze: “Si nahamwitu amùgirira amiija. Aahago! Kituma kiki mwamúgalulira ubuligo? ");
INSERT INTO flr_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Makagi gano? Si mwayija mwazimba urusoozo lwage, lunali lwo ali mu nywera kwo. Anali mu kizi lukoleesa mu kulagula. Ibala lino mwagira.”» ");
INSERT INTO flr_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Uyo mwimangizi anayami genda abalandiriziizi. Neꞌri akabaduuka, anabakanukira ku gaago-gaago magambo. ");
INSERT INTO flr_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Nabo, ti: «E nahamwitu, ikyanya watubwira yaga magambo, wakuura ku biki? Si tulyagagi bakozi baawe! Ibala mwene yiryo, bitangaziga kwo tuligire. ");
INSERT INTO flr_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","«Zirya fwaranga, ikyanya tukazigwana ziri njwekere mu tunwa twaꞌmasuuzu giitu, ka utaki kengiiri kwo tukagira? Si ikyanya tukalyoka mu kihugo kyeꞌKaanani, tukakugalulira zo. Aaho! Ka ubwinagi kwo twangashubi zimba iharija, kandi iri inooro, mu nyumba ya nahamwinyu? ");
INSERT INTO flr_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Yulwo rukuzo, iri wangalulonga mu busuuzu bwa muguma witu, unayami múyita. Na twe bandi tweshi, tunabaagage baja baawe.» ");
INSERT INTO flr_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Uyo mwimangizi, ti: «Bwija! Bibaagage nga kwo mwadeta. Buno, ngiisi ye ngagwana ahiiti yulwo rukuzo, yoyo ye gaaba muja wani. Si mwe bandi mweshi, munasigale bazira buhube.» ");
INSERT INTO flr_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Lyeryo, ngiisi muguma wabo anashonoola ubusuuzu bwage ku mulindi, anabushwekuula. ");
INSERT INTO flr_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Uyo mukozi anatondeera ukukwabula mu masuuzu gooshi, mu kutondeerera ku bweꞌfula, halinde ku bwoꞌmuzibo. Neꞌri akahikaga ku busuuzu bwa Binyamiini, lulya rukuzo lwanaboneka mwo. ");
INSERT INTO flr_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Lyeryo, yabo bakulu baage banatibaalirwa, banayami daatula ibyambalwa byabo. Ngiisi muguma wabo, anashubi shoneza ubusuuzu bwage ku punda wage, banashubi galukira mu kaaya. ");
INSERT INTO flr_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Ku kyanya Yuda na beene wabo bakagalukira imwa Yusefu, Yusefu âli ki riiri mu nyumba yage. Neꞌri bakamúgwana mwo, banamúfukamira mu kuhisa amalanga haashi. ");
INSERT INTO flr_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yusefu anabamamira: «Makagi gano mwagira? Ka mutashubi yiji kwoꞌmundu úli nga niehe ashobwiri ukulagula?» ");
INSERT INTO flr_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda anamúshuvya: «E nahamwitu, ndaalyo igambo lyo twangaki deta imbere lyawe. Si Rurema keera ayerekana amahube giitu ku bweranyange. Aahago! Bwoꞌyu ye wagwanwa ali na yulu rukuzo lwawe, tweshi tukola tugaaba baja baawe.» ");
INSERT INTO flr_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Na wa naye, ti: «Ukugira kwokwo, kutagaaziga. Ndangayami mùgira mweshi mube baja baani. Si yoyu naaho ye wagwanwa ali noꞌrukuzo lwani. Ku yukwo, yehe ye gaanaba muja wani. Mwe bandi mweshi, mugalukirage imunda yisho mu kati koꞌmutuula.» ");
INSERT INTO flr_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yuda anayegeera Yusefu, anamúbwira: «E nahamwitu, ungejeerere bweneene. Nakuyinginga, we kongwa, umbanguulage, nguganuuze ku magambo magerwa. Kundu we kola nga Faraho yenyene, haliko utambone ubuligo. ");
INSERT INTO flr_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Tuli bakozi baawe. Neꞌkyanya twâli riiri hano, ukatubuuza: “Ka muki hiiti yisho, kandi iri ugundi mulumuna winyu?” ");
INSERT INTO flr_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","«Twanayemeera, ti: “Daata akiri ho, si akola mushaaja bweneene. Tunaki hiiti ugundi mulumuna witu woꞌmuzibo, ye daata akabuta mu bushaaja bwage. Uyo mulumuna witu, âli riiri na mukulu wage ye bakabutanwa ku nyina muguma. Haliko, uyo mukulu wage, keera akafwa. Ku yukwo, uyu mulumuna wage naaho, ye koli sigiiri mu mwabo, ye na daata akoli biisiri kwoꞌmutima.” ");
INSERT INTO flr_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","«Ku kirya kihe, ukatubwira kwo tugendi kuleetera ye, gira uyiji múyibonera. ");
INSERT INTO flr_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Twanakubwira: “Uyo, atangalyoka áhali yishe. Neꞌri angahalyoka, hali ikyanya yishe angayami fwa.” ");
INSERT INTO flr_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","«Naawe wanatubwira: “Uyo mulumuna winyu, iri mutangayijanwa, mutatami boneka imbere lyani.” ");
INSERT INTO flr_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kwokwo, ikyanya tukagalukira imunda daata, umukozi wawe, tukamúganuulira byoshi byo ukatubwira. ");
INSERT INTO flr_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","«Ha nyuma, anatubwira: “Mushubi galuka, mugendi gula ibindi byokulya.” ");
INSERT INTO flr_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Haliko twanamúshuvya: “Bitagaaziga kwo tugende yo, buzira kugenda na mulumuna witu. Si ulya mutwali akayami shiikiza kweꞌri tutangamúleeta, tutatami boneka imbere lyage.” ");
INSERT INTO flr_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","«Daata, umukozi wawe, akatubwira: “Muyiji kwo mukaanie wa Laheeri, nꞌgamúbuta kwaꞌbaana babiri naaho. ");
INSERT INTO flr_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Na mu yabo bombi, muguma atakiri ho. Nyiji ku kasiisa kwo akajanganulwa neꞌnyamiishwa. Noꞌkulyokera ku yikyo kyanya, ndakaki shubi múbona. ");
INSERT INTO flr_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Uyu gundi, iri mwangamútwala, anakengeere agendi longa yeꞌmaana mbi, mugaaba mwanyingiza mu kati koꞌmwizingeerwe, na ngufwane, bwo ngola mushaaja.” ");
INSERT INTO flr_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Ku yukwo, e nahamwitu! Iri nangagalukira imunda daata, umukozi wawe, buzira uyu mutabana, bwangaba buhanya ngana. Si ubugumaana bwa daata, bukoli yegamiiri ku yugu musore. ");
INSERT INTO flr_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","E nahamwitu, iri tutangamúgalukana, daata agayami fwa, tunabe twe twamúyita noꞌmukuume, bwo akola mushaaja. ");
INSERT INTO flr_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","«Neꞌngingwe, nienyene nꞌgayitanga mbe ngwati imunda daata, hiꞌgulu lya yugu musore. Nꞌgamúbwira: “Iri ndangakugalukirana ye, halinde ushubi múbona, wangakizi ndya umulizi halinde imyaka neꞌmyakuula kwo nie wakuhubira.” ");
INSERT INTO flr_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","«E nahamwitu, nakuyinginga, ulekage mbe nie gasigala ahandu hoꞌyu mutabana. Mbe nie gaaba muja wawe. Si uyu mutabana, umúhanguule agaluke na bakulu baage. ");
INSERT INTO flr_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Buzira yugu musore, ndashobwiri ukugalukira imunda daata. Ndanaloziizi mbone ngiisi kwo daata agalibuuka noꞌmukuume.» ");
INSERT INTO flr_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yusefu atanaki bona ubulyo bwoꞌkuyihangirira imbere lyaꞌBamiisiri, kyanatuma agayami bahamuliza booshi, ti: «Hulukagi, mweshi!» Neꞌri bakahuluka, ndaaye muhalashongo úwâli ki sigiiri mwo. Haahago, Yusefu anayimenyeesa imunda bakulu baage. ");
INSERT INTO flr_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Anatondeera ukubululuka bweneene. Kyanatuma Abamiisiri kwo bâli imbuga bagamúyuvwa. Umwazi gwanamenyeekana kiri neꞌbwami. ");
INSERT INTO flr_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ulya Yusefu anabwira bakulu baage: «Nie Yusefu! Ka daata akiri ho?» Yabo bakulu baage, iri bakayuvwa kwokwo, yoo, banahinyanyala, banabula byo bagamúshuvya. ");
INSERT INTO flr_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yusefu anashubi babwira: «Namùyinginga, munyegeerage.» Neꞌri bakamúyegeera, anababwira: «Nie yolya mulumuna winyu wa Yusefu. Ikyanya mukanguliisa, nanaleetwa hano i Miisiri. ");
INSERT INTO flr_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Halikago buno, mutaki jengeerwe, mbu bwo mukanguliisa. Mutanaki be noꞌluhahalizi. Si Rurema yenyene ye kalooza kwo munguliise, gira ngwanwe hano, halinde na nyiji mùkiza. ");
INSERT INTO flr_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","«Mu kino kihugo, tuki ryagagi mu mwaka gwa kabiri naaho gwoꞌmwena. Haki sigiiri igindi myaka itaanu. Na mwiꞌyo myaka, ndaaye úgaki lima mbu ayeze. ");
INSERT INTO flr_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Rurema yenyene ye kagwanwa andeeta mu kino kihugo, bwo âli loziizi ukumùkiza ku njira yeꞌkisoomeza, halinde lyo mwe neꞌmbaga ziinyu mukalongage ukuba ho. ");
INSERT INTO flr_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","«Mutali mwe mukandeeta ino munda. Si Rurema yenyene ye kandeeta yo. Ye kanangira mbe mukulu imunda mwami weꞌMiisiri. Uyo mwami, akambiika mbe mwimangizi weꞌbindu bya mu nyumba yage, na mbe mutwali kiri na mu kihugo kyoshi kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«Kwokwo, muvwarukage. Mugendi bwira daata kwo mugala wage wa Yusefu adeta kwokuno: “Rurema keera akanyimika mbe mutwali weꞌkihugo kyoshi kyeꞌMiisiri. Mutaki tinde. Muvwaruke, muyije duba. ");
INSERT INTO flr_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ugayiji beera hoofi lyani, mu kihugo kyeꞌGosheni. Tuganabeera na bagala baawe, na bijukulu baawe. Uleetage neꞌbitugwa byawe, kiri neꞌbindi bindu byoshi byo uhiiti. ");
INSERT INTO flr_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","«“Yaho i Gosheni, ngakutunga, mwe neꞌmbaga yawe, kiri neꞌbitugwa byawe, mutayiji kengeera mwakekerera. Hatanagirage ikindu kyawe kyoshi íkigaahala. Mukuba, haki sigiiri igindi myaka itaanu yoꞌmwena.”» ");
INSERT INTO flr_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Yusefu anashubi babwira: «Bwo ngweti ngamùganuuza, mwenyene keera mwanyibonera. Kiri na mulumuna wani wa Binyamiini, naye keera ambona kwo nie Yusefu. ");
INSERT INTO flr_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Aahago! Mugendi ganuulira daata kwo ndi mutwali mu kihugo kyeꞌMiisiri. Mumúganuulire na ngiisi kwo mwenyene mwayibonera. Munavwarukage, mumúndeetere.» ");
INSERT INTO flr_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Lyeryo, Yusefu anayimuka, anahoobera mulumuna wage wa Binyamiini. Bombi banayami tulikira mu malira. ");
INSERT INTO flr_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ha nyuma, anakizi hooberana na bakulu baage, iri analira. Yabo bakulu baage, banabuli tondeera ukumúganuuza. ");
INSERT INTO flr_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yugwo mwazi gwaꞌbakulu ba Yusefu, iri gukahikira mwami Faraho mu kajumiro, gwanamúshambaaza ngana, kuguma naꞌbatwali booshi ba mu bwami bwage. ");
INSERT INTO flr_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kyanatuma mwami agabwira Yusefu: «Ubwirage bakulu baawe, kwo ngiisi muguma aheese punda wage umuteekerwa, banagalukire i Kaanani. ");
INSERT INTO flr_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Bagendi ndeetera yisho, kuguma neꞌmbaga zaabo. Mu kino kihugo kyeꞌMiisiri, ngayiji babiika ahandu hiija, halinde batuule bwija mu kihugo kyani. ");
INSERT INTO flr_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","«Unababwire kwakundi, kwo batwalage naꞌmagaare goꞌkubululwa, gira bakaleete mwo yishe, na bakaabo, kiri naꞌbaana baabo baanuke. ");
INSERT INTO flr_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Mubabwire, kwo batayishuhize hiꞌgulu lyeꞌbindu byabo. Si ngiisi biija mu kihugo kyeꞌMiisiri, ngakizi baheereza byo.» ");
INSERT INTO flr_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ikyanya bagala Yakobo bakayuvwa kwokwo, banasimbaha. Yusefu anabaheereza amagaare goꞌkubululwa, nga kwo mwami akakyula. Anakyula kwo babatekerere neꞌndanda. ");
INSERT INTO flr_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Ngiisi muguma wabo, Yusefu akamúheereza ikyambalwa kihyahya. Haliko Binyamiini yehe, anamúheereza ibyambalwa bihyahya bitaanu, kuguma neꞌfwaranga magana gashatu. ");
INSERT INTO flr_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Anatumira na yishe ngiisi íbyangamútabaala mu lugeezi. Akamútumira bapunda ikumi ábâli heesiri ibindu biija bya mu kihugo kyeꞌMiisiri, naꞌmabuguma ikumi ga bapunda ágâli heesiri ingano neꞌmikate, neꞌzindi ndanda. ");
INSERT INTO flr_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kwokwo, Yusefu anasezerana na yabo bakulu baage. Neꞌri bakaba bakola bagayimuka, anabahanuula kwokuno: «E beene witu, leero, mutagende mugalongoola.» ");
INSERT INTO flr_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Yabo bakulu baage, banalyoka yaho i Miisiri, banagalukira mu kihugo kyabo kyeꞌKaanani, imwa yishe Yakobo. ");
INSERT INTO flr_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Neꞌri bakahika áhali yishe, banamúbwira: «E daata, ka uli noꞌmwazi? Yusefu aki ba ho. Ye na koli ba mutwali mu kihugo kyoshi kyeꞌMiisiri.» Yishe mbu ayuvwagwe kwokwo, atanabayemeera. Ibiswasi byanatumuuka mwiꞌtwe. ");
INSERT INTO flr_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kundu kwokwo, banatondeera ukumúganuulira amagambo gooshi go Yusefu akabatuma. Neꞌkyanya akabona amagaare go Yusefu akamútumira, mbu gayiji múyabiira, haaho umutima gwage gwanayika mu nda. ");
INSERT INTO flr_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Anadeta: «Bwoꞌmwana wani Yusefu aki ba ho, ndaakikwo kundi. Namuyami genda yo ngana, gira ngendi múbona, índazi fwa.» ");
INSERT INTO flr_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yakobo anahamba indundu neꞌngegere, anashokola injira yoꞌkugenda i Miisiri. Neꞌri akahika i Beeri-Sheba, anatanga amatuulo imwa Rurema wa yishe Hisake. ");
INSERT INTO flr_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Iri hakaba bushigi, Rurema anamúganuuza ku njira yaꞌmabone, ti: «E Yakobo, e Yakobo!» Na wa naye, ti: «E waliha, ndi hano!» ");
INSERT INTO flr_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Rurema anamúbwira: «Nie Rurema wawe, kiri na wa yisho. Aaho! Utayobohage ukugenda i Miisiri. Si iyo munda, ngakugira ube mulala úguhimbiri. ");
INSERT INTO flr_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ikyanya ugagenda yo, tugagendanwa. Na ha nyuma kandi, tunashubi galukanwa. Neꞌkyanya ugaafwa, Yusefu ye gakufuba.» ");
INSERT INTO flr_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kwokwo, Yakobo analyoka yaho i Beeri-Sheba. Bagala baage, banamúshoneza mu galya magaare ga mwami weꞌMiisiri. Anatwalwa naꞌbali-kazi, naꞌbaana baabo. ");
INSERT INTO flr_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Banatwala neꞌbitugwa byabo, kuguma neꞌbindi byoshi byo bakatwa mu kihugo kyeꞌKaanani. Ku yikyo kyanya, akagendanwa naꞌba mwiꞌkondo lyage booshi, ");
INSERT INTO flr_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","(kuli kudeta: bagala baage, na banyere baage, kiri na bijukulu baage, abanyere naꞌbatabana). ");
INSERT INTO flr_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Yabo bagala Hisiraheeri, bo bakagendanwa i Miisiri, kiri naꞌbaana baabo, amaziina gaabo, go gaaga: Rubeni ye wâli riiri fula. ");
INSERT INTO flr_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Bagala Rubeni, bâli Hinoki, na Paalu, na Hesirooni, na Karimi. ");
INSERT INTO flr_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simyoni naye, bagala baage bâli Yemweri, na Yamini, na Ohadi, na Yakiini, na Shohaari, na Sahuli. Uyo Sahuli, akamúbuta ku Mukaanani-kazi. ");
INSERT INTO flr_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Laawi naye, bagala baage bâli Girishooni, na Kohaati, na Meraari. ");
INSERT INTO flr_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda naye, bagala baage bâli Heeri, na Honani, na Sheela, na Pereesi, na Zeera. Si Heeri na Honani bakafwira mu kihugo kyeꞌKaanani. Bagala Pereesi naye, bâli Hesirooni na Hamuli. ");
INSERT INTO flr_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Hisakaari naye, bagala baage bâli Toola, na Puuva, na Yashubu, na Shimurooni. ");
INSERT INTO flr_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulooni naye, bagala baage bâli Sereedi, na Helooni, na Yahireeri. ");
INSERT INTO flr_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Yabo booshi, bo baana Yakobo akabuta ku Leya, mu kihugo kyeꞌMezopotamiya. Akabuta na munyere wage wa Dina. Yabo baana, booshi bâli hisiri bandu makumi gashatu na bashatu. ");
INSERT INTO flr_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gaadi naye, bagala baage bâli Zifyoni, na Haagi, na Shuuni, na Hezibooni, na Heeri, na Haroodi, na Hareeri. ");
INSERT INTO flr_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Hasheeri naye, bagala baage bâli Himuna, na Hishiva, na Hishivi, na Beriya, na mwali wabo wa Seera. Bagala Beriya nabo, Hebeeri, na Malikyeri. ");
INSERT INTO flr_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Yabo, bo baana Yakobo akabuta ku Ziripa, ulya muja-kazi ye Labaani akaheereza munyere wage wa Leya. Abandu booshi bo Ziripa akabutira Yakobo, bâli riiri ikumi na ndatu. ");
INSERT INTO flr_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yakobo, akabuta abatabana babiri ku mukaage Laheeri. Yusefu na Binyamiini. ");
INSERT INTO flr_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yusefu naye, ikyanya âli kola mu kihugo kyeꞌMiisiri, akabuta abatabana babiri, Manaasi na Hifurahimu. Yabo batabana, akababuta ku Hasinaati munyere Potifeera. Noꞌyo Potifeera, âli riiri mugingi waꞌkaaya keꞌHoni. ");
INSERT INTO flr_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Binyamiini naye, bagala baage, bâli Beela, na Bekeeri, na Hashibeeri, na Gera, na Namaani, na Hehi, na Roshi, na Mupimu, na Hupimu, na Haridi. ");
INSERT INTO flr_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Yabo bo baana ikumi na bana, bo Yakobo akabuta ku Laheeri. ");
INSERT INTO flr_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Daani naye, mugala wage ye Hushimu. ");
INSERT INTO flr_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nafutaali naye, bagala baage, bâli Yahizeeri, na Guuni, na Yezeeri, na Shireemu. ");
INSERT INTO flr_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Yabo, bo baana balinda, bo Yakobo akabuta ku Biriha, ulya muja-kazi ye Labaani akaheereza munyere wage wa Laheeri. ");
INSERT INTO flr_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Abandu ba mwiꞌkondo lya Yakobo, ngiisi bo akabungana mu kihugo kyeꞌMiisiri, booshi bâli hisiri makumi galindatu na ndatu, buzira kuharuura abali-kazi. ");
INSERT INTO flr_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Neꞌyo munda i Miisiri, Yusefu âli mali gwanwa abutira yaꞌbatabana babiri. Kwokwo, ikyanya abandu booshi beꞌmbaga ya Yakobo bakagenda i Miisiri, bâli hisiri bandu makumi galinda. ");
INSERT INTO flr_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Uyo Yakobo, anatee tuma Yuda imunda Yusefu, kwo agwanwe amenya injira yoꞌkugenda i Gosheni. Neꞌkyanya Yakobo neꞌmbaga yage bakahika yo, ");
INSERT INTO flr_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yusefu analingikania igaare lyage lyoꞌkubululwa neꞌfwarasi, anagenda yo, gira agendi sanganira yishe. Yusefu, mbu amúbonage, anamúhoobera. Yusefu, anamala ikyanya kingi amúhobiiri, iri analira. ");
INSERT INTO flr_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Uyo Yakobo, anamúbwira: «E mwana wani, keera nakuyibonera. Buno, lyo ngi yemeera kwo ukiri ho. Kundu nangakoli fwa zeene, umutima gwani gukoli yisiri mu nda.» ");
INSERT INTO flr_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Uyo Yusefu, anabwira bakulu baage, naꞌbandu ba mu mbaga ya yishe: «E beene witu, ngola ngagendi menyeesa Faraho, kwo keera mwalyoka mu kihugo kyeꞌKaanani. Na buno mukola hano. ");
INSERT INTO flr_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Na njubi múmenyeesa kwo mutuula batuuzi. Mwayija neꞌmbene, neꞌbibuzi, neꞌngaavu, neꞌndundu, neꞌngegere. ");
INSERT INTO flr_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","«Ku yukwo, iri mwami angamùhamagala, anamùbuuze mbu bikagi byo mukizi kola, ");
INSERT INTO flr_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","munamúshuvye: “E nahamwitu, tuli bakozi baawe! Ukulyokera ubwanuke bwitu halinde zeene, umukolwa gwitu, gutuula gwa butuuzi. E waliha, yubwo butuuzi bwitu, bulyokiiri mu bashokuluza biitu.” «Ikyanya mugashuvya kwokwo, lyo agamùhanguula kwo mutuule haahano i Gosheni. Na íbyatuma namùbwira kwokwo, bwo nyiji kwaꞌBamiisiri bali mu kizi neena abangere bweneene.» ");
INSERT INTO flr_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yusefu, anagendi bwira Faraho: «E mwami! Daata, na beene witu, keera balyoka mu kihugo kyeꞌKaanani, bali kuguma neꞌbibuzi byabo, neꞌmbene, neꞌngaavu, neꞌndundu, neꞌngegere. Na buno, bakoli tuuziri i Gosheni.» ");
INSERT INTO flr_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ha nyuma, mu yabo bakulu baage, Yusefu anayabiira mwo bataanu, anagendi bayerekana imunda mwami. ");
INSERT INTO flr_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Mwami, mbu ababonage, anababuuza: «Biki byo mukizi kola?» Nabo, ti: «E waliha, tulyagagi bakozi baawe. Umukolwa gwitu, guba gwa kuragira ibitugwa. Yugwo mukolwa, gwo na bashokuluza biitu nabo bâli kizi gira. ");
INSERT INTO flr_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Tuli bakozi baawe. Twayija, gira tutuule hano mu kino kihugo kyawe nga babunga. Mukuba, mu kihugo kyeꞌKaanani, ndaakizo ndagiriro ízikiri mwo. Si umwena gukola mu gunuuza. Kwokwo, e nahamwitu, utuhanguulage, we kongwa, tutuule i Gosheni.» ");
INSERT INTO flr_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faraho anabwira Yusefu: «Yisho na bakulu baawe, we gabayubasa. ");
INSERT INTO flr_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Mu kino kihugo kyoshi kyeꞌMiisiri, we kola mutwali mwo. Aahago! Utoole ahandu hiija ho ugababiika. Wangabalekiiri kiri na haaho i Gosheni. Mu kati kaabo, iri wangabona mweꞌbikalage byaꞌbashosi, banabe bayiji umukolwa gwoꞌkuragira, ubabiike babe bimangizi beꞌbitugwa byani.» ");
INSERT INTO flr_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ha nyuma, Yusefu anayerekana yishe Yakobo imunda mwami. Yakobo, iri akahika, anamúgashaanira. ");
INSERT INTO flr_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Haaho, mwami anamúbuuza: «Ewe! Ukoli hiiti imyaka inga?» ");
INSERT INTO flr_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakobo, ti: «Imyaka yo ngoli hiiti mu kuno kujeba-jeba kwani, ikola myaka igana na makumi gashatu. Iyo myaka, iryagagi migerwa naaho, inayijwiri mwaꞌmalibu. Na kwakundi, ndazi hika ku myaka ya bashokuluza baani, kundu nabo bâli kizi jeba-jeba.» ");
INSERT INTO flr_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Haaho, Yakobo anashubi múgashaanira, anamúsiga yaho. ");
INSERT INTO flr_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Mu yikyo kihugo kyeꞌMiisiri, Yusefu anayubasa mwo yishe, kiri na bakulu baage. Anabaheereza ahandu hiija hoꞌkutuula, hoofi naꞌkaaya, nga kwokulya mwami âli mali gwanwa akyula. ");
INSERT INTO flr_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Na yaho i Rameseesi, Yusefu anakizi lungikira yishe ibyokulya, anakizi bilungikira kiri na bakulu baage, naꞌbandi booshi ba mu nyumba ya yishe, ukukulikirana naꞌmagoorwa ga ngiisi mbaga. ");
INSERT INTO flr_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Mu yikyo kihugo kyoshi kyeꞌMiisiri, ibyokulya byâli ki bulisiri, halinde umwena gwanagenderera ukugunuuza mwo. Abandu baamwo, kiri naꞌbandu beꞌKaanani, banatondeera ukujamba. ");
INSERT INTO flr_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yusefu, ikyanya akaguliisa irya ngano, anakuumania ifwaranga zooshi zaꞌbandu beꞌMiisiri, neꞌzaꞌbandu beꞌKaanani. Yizo fwaranga, anakizi zitwala imwa Faraho. ");
INSERT INTO flr_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Abandu beꞌMiisiri kuguma naꞌbeꞌKaanani, iri fwaranga zikabamalira, Abamiisiri booshi banagendi bwira Yusefu: «Kwokuno, tutaki hiiti kiri noꞌlusumuuni. Utuheereze byo tugaalya, e waliha! Neꞌri wangatuyima byo, tugayiji lambuukira mu masu gaawe.» ");
INSERT INTO flr_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yusefu, ti: «Bweꞌfwaranga ziinyu keera zamala, mundeeterage ibitugwa biinyu, gira tukizi bikaburania neꞌbyokulya.» ");
INSERT INTO flr_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kwokwo, yabo bandu banakizi mútwalira ifwarasi, neꞌngaavu, neꞌbibuzi, neꞌmbene, na bapunda. Ikyanya âli kizi biyabiira, anabaheereze byo bagaalya. Yibyo byokulya, umwaka gwoshi gwanamala Yusefu ali mu bikaburania neꞌbitugwa. ");
INSERT INTO flr_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Yugwo mwaka, iri gukamala, banashubi múyijira, ti: «E nahamwitu, ndaahyo twangakubisha. Tutaki hiiti kiri na íhiteerwa ku shinda. Ifwaranga ziitu, neꞌbitugwa biitu byoshi, we koli bihiiti. Si byo tukoli sigiriini naaho, galyagagi magala giitu, neꞌndalo ziitu. ");
INSERT INTO flr_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","«E nahamwitu, ka buli bwija kweꞌndalo ziitu zisibage, tunalambuukire mu masu gaawe? Kwokwo buno, ugulage amatongo giitu. Kiri na twenyene, utugulage, halinde tugendi ba baja ba mwami weꞌMiisiri. Kizima tulonge byo tugaalya. Byo ugatuheereza naaho, ziri imbuto zo tugabyala, gira tutayiji fwa. Kiri niꞌdaho liitu nalyo, litayiji kengeera lyaginiinuka.» ");
INSERT INTO flr_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Hiꞌgulu lya yugwo mwena, kyanatuma ngiisi Mumiisiri agaguliisa indalo yage. Yusefu anakizi zigulira mwami weꞌMiisiri, halinde ikihugo kyoshi kyeꞌMiisiri kyanaba bikola bindu bya mwami. ");
INSERT INTO flr_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Abandu beꞌmbande zooshi zeꞌMiisiri, Yusefu anabagira babe baja ba mwami wayo. ");
INSERT INTO flr_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Halikago, amatongo gaꞌbagingi boohe, atanagahuma kwo. Mukuba, yabo bagingi, mwami âli biisiri ulubaaja hiꞌgulu lyabo, kwo bakizi longa umusheego. Kwokwo, bwo bâli rambiri ku musheego, kyanatuma amatongo gaabo, batakagaguliisa. ");
INSERT INTO flr_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yusefu anabwira abandu: «Mwehe neꞌndalo ziinyu, keera namùgula, mube baja ba mwami. Aahago! Imbuto zino, mugendi byala. ");
INSERT INTO flr_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Haliko, ikyanya mugayimbula, mugaagira imituli itaanu. Umutuli muguma, munaguleete i bwami. Neꞌgindi mituli ina, mugagisingula nga mbuto ziinyu, na nga byokulya biinyu, mwe naꞌbaana biinyu.» ");
INSERT INTO flr_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Banamúshuvya: «E nahamwitu, watukiza ngana-ngana! Bwo watugirira amiija, tukola tugaaba baja ba Faraho.» ");
INSERT INTO flr_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yusefu anabiika ulubaaja mu kihugo kyeꞌMiisiri, kwo ngiisi Mumiisiri yeshi, ku mwimbu gwage, akwaniini akizi tangira Faraho umutuli muguma gwa kataanu. Yulwo lubaaja, lunakiri ho, halinde zeene. Si amatongo gaꞌbagingi naaho, go gatakaba bindu bya Faraho. ");
INSERT INTO flr_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Abahisiraheeri banatuula yaho i Gosheni, mu kihugo kyeꞌMiisiri. Banakizi butira mwo, halinde banayushuuka bweneene, banatwira na mweꞌbindu bingi. ");
INSERT INTO flr_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakobo akahisa imyaka ikumi niꞌrinda atuuziri mu kihugo kyeꞌMiisiri. Neꞌmyaka yage yoshi yo akalama, yâli riiri igana na makumi gana niꞌrinda. ");
INSERT INTO flr_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Uyo Yakobo, iri akaba akola agaafwa, anatumira mugala wage wa Yusefu, anamúbwira: «Iri wangaba unguuziri, nakuyinginga ubiikage ukuboko kwawe hano mwiꞌdako lyeꞌkibero kyani, unandagaanie kwo utaganziika mu kino kihugo kyeꞌMiisiri. We kongwa! Yiri igambo, ulingirire mu kati koꞌlushaagwa. ");
INSERT INTO flr_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ikyanya ngaafwa, unjaaze hano i Miisiri, unagendi nziika ha butambi lya bashokuluza baani.» Yusefu naye, ti: «E daata, yibyo wambwira, ngabigira.» ");
INSERT INTO flr_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yakobo anashubi deta: «Umbiikirage indahiro.» Kwokwo, Yusefu anamúbiikira yo. Hisiraheeri anayinika itwe iwa mushego. ");
INSERT INTO flr_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Iri hakalenga isiku, Yusefu anabwirwa kwo yishe, ubulwazi bwamúkayira. Lyeryo, anayami yabiira bagala baage bombi, Manaasi na Hifurahimu, banagendi mútanduula. ");
INSERT INTO flr_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Neꞌri bakahika, Yakobo anabwirwa, ti: «Mugala wawe wa Yusefu, ayiji kutanduula.» Kwokwo, Yakobo anayihangaana, anavyuka, anabwatala ku miino geꞌngingo. ");
INSERT INTO flr_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Uyo Yakobo, anabwira mugala wage wa Yusefu: «Rurema woꞌbushobozi bwoshi, akambulukira kwo i Luuzi, mu kihugo kyeꞌKaanani, anangashaanira, ti: ");
INSERT INTO flr_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","“Ngola ngakuheereza ibuta, na nguluze, halinde unabe shokuluza waꞌbandu boꞌmulala úguhimbiri. Abandu ba mwiꞌkondo lyawe, bagahyana kino kihugo, halinde imyaka neꞌmyakuula.” ");
INSERT INTO flr_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«Ku kyanya ndâli zaazi yija hano i Miisiri, yaba bagala baawe bombi, Hifurahimu na Manaasi, ukagwanwa wababutira hano. Kwokwo, ngabaharuura nga baana baani, nga kwo Rubeni na Simyoni nabo, bali beꞌmwani. ");
INSERT INTO flr_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ngiisi bandi baana bo ugaabuta ha nyuma, booki bagaaba beꞌmwawe. Neꞌkyanya bakulu baabo bagahyana mu kihugo, lyo nabo bagalonga ubwabo buhyane. ");
INSERT INTO flr_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","«Ikyanya nâli kizi lyoka i Mezopotamiya, nꞌgajengeerwa bweneene, bwo nyoko Laheeri akafwira mu njira, mu kihugo kyeꞌKaanani. Ku yikyo kyanya, twâli kola hoofi neꞌHefurata. Nanamúziikira ku butambi bweꞌnjira yoꞌkugenda i Hefurata (yo Betereheemu ku zeene).» ");
INSERT INTO flr_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Hisiraheeri, mbu abonage abaana ba Yusefu, anabuuza: «Banyandi yaba?» ");
INSERT INTO flr_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Na wa Yusefu, ti: «E daata, bagala baani, yaba. Rurema akabambeereza ino munda.» Yishe, ti: «Bayegeze hano, we kongwa, gira mbagashaanire.» ");
INSERT INTO flr_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Hisiraheeri, amasu gaage gâli kola mwoꞌlundanda hiꞌgulu lyoꞌbushaaja, atanâli kizi ki bona bwija. Kwokwo, Yusefu anayegeza bagala baage áhali yishe. Yishe anabahoobera, anabanyunyuguta. ");
INSERT INTO flr_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Anabwira Yusefu: «E mwana wani, yaho kare, ndâli ki hiiti umulangaaliro gwoshi, kwo nangaki shubi kubanda kwiꞌsu. Kundu kwokwo, Rurema akoli ngashaaniri bweneene. Keera nanabona kiri naꞌbaana baawe.» ");
INSERT INTO flr_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ha nyuma, uyo Yusefu analyosa bagala baage ku madwi ga shokulu wabo, anayinama, anahisa amalanga haashi. ");
INSERT INTO flr_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yusefu anashubi yabiira yabo bagala baage bombi, anagwata Hifurahimu noꞌkuboko kwage kweꞌlulyo, anamúbiika uluhande lwoꞌlumosho lwa Hisiraheeri. Naye Manaasi, anamúgwata noꞌkuboko kwoꞌlumosho, anamúbiika uluhande lweꞌlulyo lwa Hisiraheeri. Ha nyuma, anabatundira yishe Hisiraheeri. ");
INSERT INTO flr_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Haliko, Yakobo anashobeka amaboko gaage. Ukuboko kweꞌlulyo, anakugololera kwiꞌtwe lya Hifurahimu, anali ye wâli riiri muto. Noꞌkuboko kwoꞌlumosho, anakugololera kwiꞌtwe lya Manaasi, ye wâli riiri fula. ");
INSERT INTO flr_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Yakobo, anagashaanira Yusefu, ti: «Bashokulu baani, Hiburahimu na Hisake, bâli tuuziri neꞌngoome nyiija na Rurema. Uyo Rurema, ye na yoyo úyamiragi ali mu ndongoora halinde zeene. ");
INSERT INTO flr_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Umuganda wage, anakizi ngiza mu mabi gooshi. Kwokwo, iyi misore nayo, akizi gigashaanira. Bakizi buuzibwa kwiꞌziina lyani, na ku maziina ga bashokulu baani, Hiburahimu na Hisake. Banakizi yushuuka bweneene mu kihugo.» ");
INSERT INTO flr_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Uyo Yusefu, mbu abonage kwo yishe abiika ukuboko kweꞌlulyo kwiꞌtwe lya Hifurahimu, atanasiima. Anagira mbu akulyose ku lya Hifurahimu, gira akubiike ku lyeꞌmwa Manaasi. ");
INSERT INTO flr_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Anabwira yishe: «E daata, utagire kwokwo. Ifula yani, yo yeyi hano. Nakuyinginga, ubiike ukuboko kwawe kweꞌlulyo kwiꞌtwe lyage.» ");
INSERT INTO flr_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Haliko, yishe analahira: «E mwana wani, nanga, ngoli yiji kwokwo. Abaana ba Manaasi nabo, bagaaba mulala úguhimbiri. Si mulumuna wage ye gamúkulira. Naꞌba mwiꞌkondo lyage, bo bagakomooka mweꞌmilala mingi.» ");
INSERT INTO flr_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ku lwolwo lusiku, Yakobo anabagashaanira, ti: «Amaziina giinyu, Abahisiraheeri bagakizi gakoleesa mu kugashaanirana. Bagakizi deta: “Rurema akizi kugirira amiija, nga kwo akagirira Hifurahimu na Manaasi.”» Kwokwo, kwo Yakobo akasimbahiisa Hifurahimu ukuhima Manaasi. ");
INSERT INTO flr_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ha nyuma, Yakobo anabwira Yusefu: «Lolaga, e mwana wani! Ngola ngaafwa. Kundu kwokwo, Rurema, mugayamanwa, anashubi mùgalulira mu kihugo kya bashokuluza biinyu. ");
INSERT INTO flr_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Si wehe, nga mutwali waꞌbakulu baawe, nakugabira ikihugo kyeꞌShekemu, kirya kihugo kyo nꞌganyaga Abahamoori ku ngooti, na ku muheto.» ");
INSERT INTO flr_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ha nyuma, Yakobo anatumira bagala baage booshi, anababwira: «Mweshi mukumanage. Ngamùmenyeesa íbigamùkoleka kwo, mu siku ízigayija. ");
INSERT INTO flr_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","E baana baani, mukumanage, mundege amatwiri. Munyuvwirize, nie yisho Hisiraheeri. ");
INSERT INTO flr_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","E Rubeni, we fula yani. We na misi yani, bwo we katangi butwa. Kwokwo, balumuna baawe booshi, we basumbiri ulushaagwa neꞌmisi. ");
INSERT INTO flr_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kundu kwokwo, ulyagagi nga migezi mikayu íri mu golomba. Si mu kushonera ku ngingo yani na muguma mu bakanie, ukambonia ishoni. Ku yukwo, utagaki kulira abiinyu. ");
INSERT INTO flr_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Simyoni bo na Laawi, bali kikulu neꞌkilumuna. Bakakoleesa ibyugi byabo mu kuyitana. ");
INSERT INTO flr_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ku yukwo, ndâye ki yibiike mu magambi gaabo. Kiri neꞌmihumaanano yabo, ndâye ki giyingire mwo. Si bakaminika abandu ku buraakari bwabo, banatema ishuuli ikisi, mu kuyishesa naaho. ");
INSERT INTO flr_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Yubwo buraakari bwabo, bwâli leeziragi ulugero. Kwokwo, mbudaasiri. Ee! Ubute bwabo, nabudaaka ngana-ngana, bwo butali mweꞌndengeerwa. Aba mu bibusi byabo, ngabashabulira mu kihugo kya Hisiraheeri, babe mijande-mijande. ");
INSERT INTO flr_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«E Yuda, beene winyu bagakizi kuhuuza, banakizi kufukamira. Abagoma baawe nabo, ugakizi bakandamira. ");
INSERT INTO flr_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","E mugala wani wa Yuda, ulyagagi nga mwana weꞌndare, keera úwavwajagira byo alonga i ruhiiviro, anashubi galukira mwiꞌbundo. Ulyagagi nga ndare íshubi jujamiri, inakoli gwejiiri. Aahago! Nyandi úwangaki givyula? ");
INSERT INTO flr_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Abayuda bayamiragi bali neꞌngoni yeꞌkyami. Itaganalyoka mu magulu ga mwami wabo, halinde ukuhisa ku kyanya ulya úgikwaniini agaahika. Yehe, ibinyamahanga byoshi bigakizi músimbaha. ");
INSERT INTO flr_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Agakizi shwekera punda wage ku mulandira gwoꞌmuzabibu. Umwana woꞌyo punda, agakizi múshwekera ku kitombo kyagwo. Aganakizi fula ibyambalwa byage mu divaayi. Neꞌkooti lyage, agalifuliisa umuko gweꞌmizabibu, ");
INSERT INTO flr_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","halinde amasu gaage ganadukumbuke bweneene. Amiino gaage nago, gagakizi ba meeru pepeepe ukuhima amata. ");
INSERT INTO flr_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Zabulooni, agatuula ku butambi bweꞌnyaaja. Amashuba, ganakizi yezeka ho. Ulubibi lweꞌkihugo kyage, lugahekera ku kyeꞌSidooni. ");
INSERT INTO flr_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Hisakaari, ali nga kihagange kya punda, úkoli gwejiiragi ha kati keꞌmiteekerwa ibiri. ");
INSERT INTO flr_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Abwinagi kwo yaho ho ali mu luhuukira, hali hiija, na kweꞌkihugo kisimisiizi. Kyanatuma agaagoka, gira iyo miteekerwa, agiheekage. Na mu kugiheeka, anabe muja woꞌkukola ku kahaati. ");
INSERT INTO flr_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Daani agakizi twala abandu baage, nga kweꞌgindi milala ituula igira. ");
INSERT INTO flr_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Uyo Daani, agaaba nga mujoka úguli ku njira, na nga kihoma íkiteziri ku butambi bweꞌnjira. Kinakizi komera ifwarasi ku birenge, halinde úgishoniiri kwo, anadeedeke umugongo haashi. ");
INSERT INTO flr_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«E Nahano, ndangaliiri kwo we gangiza. ");
INSERT INTO flr_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«Gaadi, kundu agateerwa naꞌbiitani, haliko ye gabahima, anabashindibuke kwo. ");
INSERT INTO flr_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«Hasheeri, ikihugo kyage kigayera bweneene. Yibyo byokulya byage, bigakizi liibwa naꞌbaami. ");
INSERT INTO flr_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«Nafutaali, alyagagi nga kasa ákali noꞌbutoge, kanali mu buta abaana ábanonosiri. ");
INSERT INTO flr_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«Yusefu alyagagi nga kitombo íkiri ha butambi lyeꞌshyoko, kinajoojesiri bweneene. Amatavi gaakyo, gali mu yajabuka, halinde ganasooke ikyogo. ");
INSERT INTO flr_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Abagoma baage, kundu bagweti bagamùlwisa neꞌmiheto, iri banamúshomboroza mu kumúlasha imyambi, ");
INSERT INTO flr_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","haliko, akayama afumbiiti umuheto gwage. Naꞌmaboko gaage ganayama gayanguhiri. Ali mu longa ubushobozi imwa Rurema wa Yakobo. Mukuba Rurema, ye kikalage kyoꞌmungere, ye na Lwala lwaꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Rurema wa yisho, ye gakizi kutabaala. Ye Rurema woꞌbushobozi bwoshi, ye ganakizi kugashaanira. Kwokwo, ugakizi longa invula ukulyoka mwiꞌgulu. Noꞌtudota, tunakizi bira mu kuzimu. Ugakizi buta abaana bingi. Kiri neꞌbitugwa, binayolole. ");
INSERT INTO flr_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Imigashani yo wahaabwa na yisho, ihimiri imigashani yeꞌmigazi íyamiri ho. Inahimiri na byoshi íbigiri kwo. Iyo migashani yoshi, ikizi beera kwiꞌtwe lya Yusefu, na ku kashanga-mutwe kaage. Mukuba, akuliiri bakulu baage booshi. ");
INSERT INTO flr_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Binyamiini, alyagagi nga mulunga mulangi. Shesheezi, guli mu zindukiri vwajagira ngiisi byo gwalonga i ruhiiviro. Naꞌkabigingwe, gunagabure imisigala.» ");
INSERT INTO flr_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Yabo booshi, yo milala ikumi niꞌbiri yaꞌBahisiraheeri. Neꞌkyanya yishe Yakobo akabagashaanira, gaago go magambo go âli kizi babwira. Akagashaanira ngiisi muguma, nga kwo bimúkwaniini. ");
INSERT INTO flr_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ha nyuma, Yakobo anakomeereza yabo bagala baage kwokuno: «E baana baani, ngola ngagwana bashokulu. Aaho! Mukanziikage ngiisi ho bashokulu bakaziikwa, mu shinda íri mu lwala, mu ndalo ya Hefurooni, Umuhiti. ");
INSERT INTO flr_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","«Iyo shinda, iri mu ndalo yeꞌMakepela, hoofi neꞌMamure, mu kihugo kyeꞌKaanani. Hiburahimu ye kahagula imwa Hefurooni, Umuhiti, gira habe ho agakizi ziikira beene wage. ");
INSERT INTO flr_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","«Haaho, ho Hiburahimu na mukaage Saara nabo bakaziikirwa. Kiri na Hisake na mukaage Rebeka, nabo ho bakaziikirwa. Kiri na Leya naye, haaho ho nꞌgamúziikira. ");
INSERT INTO flr_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Iyo ndalo, neꞌyo shinda íri mwo, akabigula imwaꞌBahiti.» ");
INSERT INTO flr_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yakobo, mbu ayusagye ukulaga bagala baage, anashubi yilambika ku ngingo, anayami fwa, anagwana bashokulu. ");
INSERT INTO flr_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Uyo Yusefu, ikyanya yishe akafwa, anayami yilambika ku kirunda kyage. Anakizi múlirira, iri anamúnyunyuguta. ");
INSERT INTO flr_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","Ha nyuma, Yusefu anabwira abafumu ábâli kizi múkolera, kwo bayiji shiiga ikirunda kya yishe umuti, gira kitabole. Yabo bafumu, banamala isiku makumi gana bagweti bagakishiiga kwoꞌmuti, nga kweꞌmigeeza yabo yâli riiri. Balya Bamiisiri, banahisa isiku makumi galinda bajondamiri, bali mu kigandaaro kya Yakobo. ");
INSERT INTO flr_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yizo siku zeꞌkigandaaro, iri zikamala, Yusefu anabwira abandu ba mu mbaga ya Faraho: «Mwe bakongwa! Namùyinginga, mugendi mbwirira Faraho ");
INSERT INTO flr_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","kwo daata akasiga ambikiisa indahiro, ti: “Ngola bu fwa. Kwokwo, ukagendi nziika mu shinda yo nꞌgahumba, mu kihugo kyeꞌKaanani.” Ukukulikirana niꞌragi, nayinginga mwami ambanguule kwo ngendi ziika daata, na njubi galuka.» ");
INSERT INTO flr_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraho, anatuma ishuvyo imunda Yusefu, ti: «Ugendi ziika yisho, nga kwo akasiga akubikiisa indahiro.» ");
INSERT INTO flr_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kwokwo, Yusefu anagendi ziika yishe. Abakozi booshi ba Faraho, naꞌbalemberezi baage, naꞌbashaaja ba mu yikyo kihugo, banagenda bamúherekeziizi. ");
INSERT INTO flr_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Na kwakundi, anagenda neꞌmbaga yage, na beene wabo, naꞌbandi bandu ba mu mbaga ya yishe. Ábakasigala yaho i Gosheni, bali baana naaho, kuguma neꞌbitugwa. ");
INSERT INTO flr_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Mu Miisiri, mwâli riiri abasirikaani ba mwami. Bâli kizi gendera mu magaare goꞌkukizi bululwa neꞌfwarasi. Nabo banagenda babaherekeziizi. Yabo booshi, bâli riiri katundu. ");
INSERT INTO flr_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ikyanya bakalyoka i Miisiri, banahika ha kajabo koꞌlwiji Yorodaani. Na yaho, hâli riiri ikiyeluuliro kyeꞌngano, kyâli kizi buuzibwa Hataadi. Yaho, banajongama, iri banalira ku mwizingeerwe. Yusefu anamala heꞌsiku zirinda, ali mu kigandaaro kya yishe. ");
INSERT INTO flr_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Abakaanani, kwo bâli riiri batuulaga ba yaho, iri bakabona ngiisi kwaꞌbandu babiika ikigandaaro ha yikyo kiyeluuliro, banakizi yibuuza: «E balya, kino kigandaaro kyaꞌBamiisiri, si kiryagagi kya kahebuuza!» Kyanatuma yaho ha kajabo koꞌlwiji Yorodaani, hagayinikwa iziina Habeeri-Miisiri, (kuli kudeta: kigandaaro kyaꞌBamiisiri). ");
INSERT INTO flr_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Yabo bagala Yakobo, kwokwo kwo bakagirira yishe, nga kwo âli mali gwanwa abakomeereza. ");
INSERT INTO flr_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Banatwala ikirunda kyage mu kihugo kyeꞌKaanani, banagendi múziika mu shinda ya mu ndalo yeꞌMakepela, hoofi neꞌMamure. Iyo shinda, Hiburahimu ye kagigula imwa Hefurooni, Umuhiti, gira habe ho agakizi ziikira beene wage. ");
INSERT INTO flr_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yusefu, iri akaba keera aziika yishe, anashubi galukira i Miisiri, na bakulu baage, naꞌbandu booshi kwo bâli múherekeziizi. ");
INSERT INTO flr_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Balya beene wabo Yusefu, iri bakabona kwo yishe keera afwa, banahanuusania, ti: «Ala twe! Kwokuno daata afwa, ka Yusefu atakola agatuyihindulira? Bulya buligo bwoshi bwo tukamúgirira, ka atagaki yihoola hiꞌgulu lyabwo?» ");
INSERT INTO flr_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kyanatuma bagatumira Yusefu indumwa ídesiri kwokuno: «E nahamwitu, ku kyanya yisho âli kola mu laga, akasiga adeta: ");
INSERT INTO flr_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","“Mubwirage Yusefu kwo namúyinginga maashi, akejeerere beene wabo ku mahube gooshi go bakamúgirira.” Aaho! Nyiitu, tulyagagi bakozi ba Rurema wa yisho. Ku yukwo, twakuyinginga bweneene, utukejeerere ku mahube go tukakugirira.» Iyo ndumwa, iri ikahikira Yusefu, anagwatwa neꞌkifufu, anatondeera ukulira. ");
INSERT INTO flr_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ha nyuma, yabo beene wabo boonyene banamúgendera, banafukama imbere lyage, banadeta: «E Nahamwitu, tukola baja baawe.» ");
INSERT INTO flr_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Haliko Yusefu anabashuvya: «Nanga, mutayobohe! Ka nie Rurema, mbu nimùhane? ");
INSERT INTO flr_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Mwâli shungisiri ukungira buligo. Kundu kwokwo, yubwo buligo, Rurema âli shungisiri ukubuyerekana mwaꞌmiija. Âli loziizi ukukiza abandu bingi, nga kwo mukoli bwinagi. ");
INSERT INTO flr_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Kwokwo, mutakizi ki yoboha. Mwehe naꞌbaana biinyu, ngakizi mùheereza ibyokulya.» Yabo beene wabo, iri bakayuvwa kwokwo, banaholeera. ");
INSERT INTO flr_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yusefu neꞌmbaga ya yishe, banagenderera ukutuula iyo munda i Miisiri. Yusefu akalama imyaka igana niꞌkumi. ");
INSERT INTO flr_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Anagashaanirwa ukubona abaana beꞌmwa Hifurahimu, halinde ku bajukuluza. Na kwakundi, abaana ba mwijukulu wage wa Makiiri mugala Manaasi, ye kabalera. ");
INSERT INTO flr_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Iri hakatama, Yusefu anabwira beene wabo: «Ngola bu fwa. Kundu kwokwo, Rurema agakizi mùtabaala. Yehe, ye gamùlyosa mu kino kihugo, anamùtwale mu kihugo kyo akalagaania Hiburahimu, na Hisake, na Yakobo. ");
INSERT INTO flr_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Aahago! Mumbiikire indahiro, kweꞌkyanya Rurema agayiji mùguluula, mukataahane imigongolo yani.» ");
INSERT INTO flr_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Kwokwo, iri Yusefu akaba akola neꞌmyaka igana niꞌkumi, anashaaja. Ikirunda kyage, banakishiiga kwoꞌmuti, gira kitabole. Banakilambika mu kajumba, iyo munda i Miisiri.");
INSERT INTO flr_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ikyanya Yakobo akagendi tuula i Miisiri, anagenda na bagala baage. Naꞌmaziina gaabo, go gaaga: ");
INSERT INTO flr_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Rubeni, na Simyoni, na Laawi, na Yuda, ");
INSERT INTO flr_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","na Hisakaari, na Zabulooni, na Binyamiini, ");
INSERT INTO flr_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","na Daani, na Nafutaali, na Gaadi, na Hasheeri. Yabo bagala baage, ngiisi muguma wabo âli riiri neꞌmbaga yage. ");
INSERT INTO flr_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Abandu beꞌkibusi kya Yakobo, booshi bâli hisiri bandu makumi galinda. Yusefu yehe, âli koli tuuziri mu kihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Iri hakatama, uyo Yusefu anafwa. Beene wabo booshi ba mu yikyo kibusi, nabo banafwa. ");
INSERT INTO flr_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Kundu kwokwo, Abahisiraheeri banagenderera ukukizi buta, banaluguuka bweneene, halinde banakwira hooshi mu kihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Yaho i Miisiri, iri hakalenga imyaka mingi, ugundi mwami anayima, atanâli yiji umwazi gwa Yusefu. ");
INSERT INTO flr_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Uyo gundi mwami anabwiraga abandu baage: «Lolagi ngiisi kwaꞌBahisiraheeri bakola kanyegete. Hali ikyanya tutangaki bahasha. ");
INSERT INTO flr_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Aaho! Tuyengehe! Mukuba, iri hangayimuka izibo, hali ikyanya yaba bandu bangayibiika ku bagoma biitu, banakengeere batulwisa. Noꞌbuzinda, banayiji tibita ikihugo kiitu. Ku yukwo, tuloozagye ubulyo bwoꞌkubahangirira, halinde bataki yushuuke.» ");
INSERT INTO flr_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Balya Bamiisiri, bâli kizi libuza Abahisiraheeri bweneene. Banababiikira abimangizi balangi, gira bakizi bakoleesa ku kahaati. Mwami weꞌMiisiri, anabayubakiisa utwaya twoꞌkukizi biikira mweꞌbihinda, (kuli kudeta: i Pitomu neꞌRameseesi). ");
INSERT INTO flr_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Balya Bahisiraheeri, kundu bâli kandamiirwi bweneene, si bâli genderiiri naaho ukubuta, iri banayushuuka, halinde banakwira mu kihugo. Kyanatuma balya Bamiisiri bagakizi bayoboha bweneene, ");
INSERT INTO flr_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","banagenderera ukukizi bavindagaza. ");
INSERT INTO flr_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Banakizi bakoleesa ngana, buzira kubakejeerera. Neꞌri hakazindaga, yabo Bahisiraheeri banakizi humba ibumba lyoꞌkukizi bumba amatafaari. Banakizi gira neꞌgindi mikolwa mingi ya mu ndalo. Bâli koli tuuziri mu makuba ngana-ngana, iri banakizi yitubanula bweneene. ");
INSERT INTO flr_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mu yabo Baheburaniya, mwâli riiri abahumbwa babiri, Shifira na Puwa. Yabo bombi, bo bâli kizi butiisa. Lusiku luguma, mwami anababwira: ");
INSERT INTO flr_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«Ikyanya abakazi baꞌBaheburaniya bagakizi yiji buta, mukakizi loleekeza bwija umwana úwabutwa. Iri angaba ali wa bunyere, munamúleke. Halikago, iri angaba ali wa butabana, munayami múfumba umuuka.» ");
INSERT INTO flr_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kundu mwami akadeta kwokwo, haliko balya bahumbwa bâli simbahiri Rurema, batanamútwaza. Kiri naꞌbaana batabana, banakizi baleka. ");
INSERT INTO flr_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Iri hakatama, uyo mwami anabatumira, anababuuza: «E bahumbwa, makagi gano mwagira? Kituma kiki mwalekeerera abaana boꞌbutabana?» ");
INSERT INTO flr_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Nabo, ti: «E mwami, balya Baheburaniya-kazi, biri bihagarusi bweneene. Ikyanya umuhumbwa ali mu ba atazi hika, bali mu gwanwa keera bayibutiisa boonyene. Boohe, batali mu tinda ngaꞌBamiisiri-kazi.» ");
INSERT INTO flr_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Yabo bahumbwa, Rurema anakizi bagashaanira. NaꞌBahisiraheeri banakaviiriza ukuyushuuka, halinde banaba neꞌmisi bweneene. ");
INSERT INTO flr_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Yabo bahumbwa, bwo bâli simbahiri Rurema, kyanatuma nabo, agabayushuulira imbaga zaabo. ");
INSERT INTO flr_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Iri hakazinda, uyo mwami anakyula, ti: «Abaheburaniya, ikyanya bagabutaga abaana boꞌbutabana, ndaakwo kundi. Muyami balasha mu lwiji Niire. Si abaana boꞌbunyere boohe, mukizi baleka.» ");
INSERT INTO flr_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Hâli riiri Mulaawi muguma úkahisa umukazi wa mu mulala gwage. ");
INSERT INTO flr_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Uyo mukazi anaheeka inda, anabuta umwana woꞌbutabana. Na bwoꞌyo mwana âli riiri mwija bweneene, kyanatuma agaamala imyezi ishatu ali mu múbishiiriza. ");
INSERT INTO flr_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Iri hakazinda, anabula ubulyo bwoꞌkushubi múbisha. Kyanatuma agayabiira ikitiri íkikalukwa mu kaliri, anakihembeza kwoꞌbulungu. Iri akayusagya, anakigwejeza mwoꞌyo mwana, anagendi kitereka mu masanga, mu lwiji Niire. ");
INSERT INTO flr_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Uyo mwana, mwali wage âli bishamiri hoofi lyage, gira abone ngiisi íbigamúkoleka kwo. ");
INSERT INTO flr_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Masaasa atabukwa, umuluzi-nyere wa Faraho anamanukira ku lwiji Niire, gira agendi yikaraba. Âli geeziri naꞌbalemberezi baage. Ikyanya bakalenga ku ngombe yoꞌlwiji, uyo muluzi-nyere anabona ikitiri kibishirwi mu byasi, anabwira umulemberezi muguma kwo agendi kireeta. ");
INSERT INTO flr_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Uyo muluzi-nyere, mbu akitumbuule, anagwana muli umwana waꞌkalenge, agweti agaalira. Anamúyuvwirwa indengeerwa, anadeta: «Uyu mwana, ali Muheburaniya.» ");
INSERT INTO flr_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Haaho-haaho, ulya mwali woꞌyo mwana anahulukira ho, anayami bwira uyo muluzi-nyere: «E waliha, uyu mwana, ka ngendi kuloogeza umulezi mu Baheburaniya-kazi, gira akizi kuyogeza ye?» ");
INSERT INTO flr_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Naye, ti: «Genda!» Kwokwo, anayami gendi leeta nyina woꞌyo mwana. ");
INSERT INTO flr_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ulya muluzi-nyere anamúbwira: «Uyabiirage uyu mwana, ukizi múyoza. Ngakuhemba.» Kwokwo, uyo nyaama anatwala umwana imwage, anagendi múlera. ");
INSERT INTO flr_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Uyo nyaama, iri akabona kwoꞌmwana keera akula, anamútwala imwoꞌyo muluzi-nyere. Neꞌri akamúyabiira, anaba mwana wage, anamúyinika iziina Musa, mu kudeta: «Nꞌgamútoola mu lwiji.» ");
INSERT INTO flr_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Iri hakalenga imyaka, Musa anaba akola mushosi. Lusiku luguma, anagendi tanduula beene wabo Abaheburaniya, anabona ngiisi kwaꞌBamiisiri bali mu bakoleesa ku kahaati. Anabona mwene wabo muguma, agweti agashulikwa noꞌMumiisiri. ");
INSERT INTO flr_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Musa anatee lola uluhande noꞌlundi. Neꞌri akabona kwo ndaaye umúbwini, anayami yita ulya Mumiisiri, anamúfulika mu mushenyu. ");
INSERT INTO flr_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Iri bukakya, Musa anashubi hulukira ku Baheburaniya babiri ábali mu lwa. Ikyanya akabona kwo muguma wabo ye wahubira uwabo, anamúbwira: «Maki gano! Si mwe baguma! Kituma kiki uli mu shulika uwinyu?» ");
INSERT INTO flr_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Na wa naye, ti: «Shaaga! Nyandagi úkakubiika kwo ube mutwali witu, unabe mutwi weꞌmaaja ziitu? Ka naani, uloziizi ukunyita, nga kwo wayita ulya Mumiisiri?» Lyeryo, Musa anatondeera ukuyoboha, anayitoneesa, ti: «Ehee! Ngiisi byo nagira, kiziga keera byamenyeekana.» ");
INSERT INTO flr_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Mwami weꞌMiisiri, iri akayuvwa ngiisi kwo Musa agira, anagira mbu amúyite. Kyanatuma Musa agapumukira mu kihugo kyeꞌMidyani, gira agendi tuula mwo. Neꞌri akahika yo, anabwatala ha kirigo. ");
INSERT INTO flr_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Iyo munda i Midyani, yâli riiri umugingi muguma úwâli hiiti abanyere balinda. Ikyanya Musa âli kola ha kirigo, yabo banyere banayiji vwomera ibitugwa bya yishe, banayijuza amiiji mu mivuli, gira bishyole. ");
INSERT INTO flr_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Haaho, hanayija abandi bangere, banagira mbu babayimule yaho. Musa anayami yimuka, anabahaliza, anabatabaala mu kubashyoleekeza ibitugwa. ");
INSERT INTO flr_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Yabo banyere, iri bakataaha, yishe Rehuweri anababuuza: «E baana, si leero mwataaha buki bwini!» ");
INSERT INTO flr_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Na wa nabo, ti: «Ikyanya tutákola mu vwomera ibitugwa, hanayija Mumiisiri muguma, anatukiza mu maboko gaꞌbiitu bangere. Na kwakundi, anatushyoleekeza ibitugwa.» ");
INSERT INTO flr_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Yishe, ti: «Hayi ali? Kituma kiki mwamúsiga? Mugendi múhamagala, gira naye ayiji lya ibyokulya.» ");
INSERT INTO flr_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Iri Musa akahika mu nyumba yoꞌyo mushosi, anayemeera ukutuula mwo. Ha nyuma, uyo mushosi anayabiira munyere wage wa Zipoora, anamúheereza ye, abe mukaage. ");
INSERT INTO flr_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Uyo Zipoora, ikyanya akabuta umwana woꞌbutabana, Musa anamúyinika iziina Girishoomu, (kuli kudeta: úkatibitira hala). Anadeta: «Ngola mubunga mu kihugo kyeꞌmahanga.» ");
INSERT INTO flr_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Isiku, iri zikalengerana, uyo mwami weꞌMiisiri anashaaja. Yabo Bahisiraheeri, banagenderera ukukizi libuuka mu buja bwabo, banakizi gongeera bweneene. Iri hakatama, yago malira gaabo ganahika mwiꞌgulu imwa Rurema. ");
INSERT INTO flr_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Neꞌri akagayuvwa, anakengeera kirya kihango kyo akagira na bashokuluza baabo, Hiburahimu, na Hisake, na Yakobo. ");
INSERT INTO flr_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ikyanya akabona ngiisi kwo bagweti bagalibuuka bweneene, anabayuvwirwa indengeerwa. ");
INSERT INTO flr_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Lusiku luguma, Musa âli ragiiri imbene neꞌbibuzi byeꞌmwa Yeturo shevyala, umugingi weꞌMidyani. Neꞌri akabitambusa ubuterere, anahika i Horebu (kuli kudeta: mugazi gwa Rurema). ");
INSERT INTO flr_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Uyo Musa, ikyanya âli kola yaho, anayami hulukirwa kwo noꞌmuganda wa Nahano. Uyo muganda âli riiri mu kishungu-shungu íkyâli kizi gulumira kweꞌmbigi. Yikyo kishungu-shungu, kundu kyâli genderiiri ukukizi gulumira, si kitanasingooka. Iri Musa akabona kwokwo, ");
INSERT INTO flr_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","anayidesa, ti: «Kitangaaza yiki! Leka ndee gendi kiyitegeereza bwija, mbone íbitumiri kitali mu singooka.» ");
INSERT INTO flr_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Iri Nahano akabona kwo Musa akola mu yegeera yikyo kishungu-shungu, izu lyage lyanakilyoka mwo, ti: «E Musa, e Musa!» Musa, ti: «E waliha, ndi hano.» ");
INSERT INTO flr_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Nahano anamúbwira kwokuno: «Utayegeere hano. Uhogolage ibiraato byawe, bwo yaho uyimaaziri, hali handu hataluule. ");
INSERT INTO flr_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Nie Rurema wa bashokuluza baawe, Hiburahimu, na Hisake, na Yakobo.» Musa, mbu ayuvwe kwokwo, anayami bwikira amalanga gaage, bwo akayoboha ukulola ku Rurema. ");
INSERT INTO flr_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Nahano anashubi múbwira: «Abandu baani, bakola mu libuuka bweneene mu kihugo kyeꞌMiisiri. Basheebuja baabo, bali mu balibuza ku kahaati. Yago malibu gaabo gooshi, ngabwini, na nyuvwiti na ngiisi kwo bagweti bagaalira. Na buno, ngweti ngabahahalira. ");
INSERT INTO flr_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","«Kwokwo, ngolaga ngabalyosa mu maboko gaꞌBamiisiri, na mu kihugo kyabo, halinde na mbatwale mu kihugo kiija. Kirya kindi kihugo, kiri kihamu, kinayeziri mwaꞌmata noꞌbuuki. Si buno, kikiri mwaꞌBakaanani, naꞌBahiti, naꞌBahamoori, naꞌBapereesi, naꞌBahivi, naꞌBayebuusi. ");
INSERT INTO flr_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","«Yago malibu gaꞌBahisiraheeri, keera gayuvwikana mu matwiri gaani, nanabona ngiisi kwaꞌBamiisiri bagweti bagabavindagaza bweneene. ");
INSERT INTO flr_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kwokwo buno, namu kutuma imunda Faraho, gira ugendi ndyokeza abandu baani mu kihugo kyeꞌMiisiri. Mukuba, yabo Bahisiraheeri, bo bali bandu baani.» ");
INSERT INTO flr_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Musa anabuuza Rurema: «Aaho! Niehe, ndi nga nyandi? Na kuti kwo nangagenda imwa mwami weꞌMiisiri, ninayami lyosa Abahisiraheeri mu kihugo kyage?» ");
INSERT INTO flr_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Rurema anamúshuvya: «Tugayamanwa! Na íbigakuyemeeza kwo nie wakutuma, byo byebi: Ugalyosa Abahisiraheeri mu kihugo kyeꞌMiisiri, unabaleete ku gwoguno mugazi, gira bayiji nyikumbira kwo.» ");
INSERT INTO flr_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Musa anashubi múbuuza: «E Nahamwitu, iri nangagenda imunda Abahisiraheeri, na mbabwire mbu: “Rurema wa bashokuluza biinyu anduma imwinyu”, hali ikyanya bagambuuza: “Uyo Rurema wawe, iziina lyage ye nyandi?” Aaho! Kuti kwo ngabashuvya?» ");
INSERT INTO flr_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Rurema, ti: «Iziina lyani, “Niehe Nie Yamiri ho.” Ku yukwo, ubwire Abahisiraheeri kwokuno: “Ulya Úyamiri ho, ye wanduma, ");
INSERT INTO flr_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","anali ye Nahano Rurema wa bashokuluza biinyu, Hiburahimu, na Hisake, na Yakobo.” Mu bibusi biinyu byoshi, lyeryo iziina, lyo ngakizi kengeerwa mwo. Liyamiri liri lyeꞌmwani, halinde imyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","«Kwokwo, ugendi kuumania abashaaja baꞌBahisiraheeri, unababwire: “Nahano Rurema wa bashokuluza biinyu, Hiburahimu, na Hisake, na Yakobo, keera ambulukira kwo, anambwira: Nabona ngiisi kwo mugweti mugalibuuka mu kino kihugo kyeꞌMiisiri. Na buno, ngola ngayiji mùtabaala. ");
INSERT INTO flr_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Keera nꞌgamùlagaania kwo ngamùlyosa mu malibu giinyu, halinde na mmùtwale mu kihugo íkiyeziri mwaꞌmata noꞌbuuki. Kundu kwokwo buno, yikyo kihugo kikiri kyaꞌBakaanani, naꞌBahiti, naꞌBahamoori, naꞌBapereesi, naꞌBahivi, naꞌBayebuusi.” ");
INSERT INTO flr_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Yabo bashaaja baꞌBahisiraheeri, mango wababwira kwokwo, bagakuyuvwiriza. Ha nyuma, munagendanwe imwa mwami weꞌMiisiri, munamúbwire: “Buno, Nahano Rurema waꞌBaheburaniya, atuhulukira kwo. Ku yukwo, utuhanguulage tugire ulugeezi lweꞌsiku zishatu mwiꞌshamba, gira tugendi tanga ituulo imwa Rurema witu.” ");
INSERT INTO flr_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","«Uyo mwami weꞌMiisiri, nyiji kwo atagamùhanguula kwo mugende, índazi múlambuulira kwoꞌkuboko kwani kwoꞌbushobozi. ");
INSERT INTO flr_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ikyanya ngahaniiriza ikihugo kyage, ngakoleesa ukuboko kwani kwoꞌbushobozi, mu kukizi gira ibitangaaza bya kwingi-kwingi mu kati kaabo. Ha nyuma, uyo mwami akabuli mùleka mugendage. ");
INSERT INTO flr_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","«Kiri naꞌBamiisiri nabo, ngamùsimiisa imwabo. Kwokwo, ngiisi Muheburaniya-kazi, ikyanya agalyoka mwo, atagalyoka maboko mamaata. ");
INSERT INTO flr_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Si ngiisi mukazi, akwaniini ahuune umutuulani wage woꞌMumiisiri, kandi iri Mumiisiri-kazi útuuziri mu nyumba yage, kwo amúheereze ibirugu íbikatulwa mu harija, na mu nooro, amúhuune neꞌbyambalwa. Kwokwo, kwo mugayambika abaana biinyu, abanyere naꞌbatabana. Kwiꞌyo njira, kwo mugalonga ibindu byaꞌBamiisiri.» ");
INSERT INTO flr_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Musa anashubi bwira Nahano: «Hali ikyanya Abahisiraheeri batagandwaza, batananyuvwe, banadetage: “Nanga! Nahano atakakuhulukira kwo.” Aaho! Kuti kwo ngababwira?» ");
INSERT INTO flr_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Nahano anamúshuvya: «Biki byo ufumbiiti?» Musa, ti: «Ngoni.» ");
INSERT INTO flr_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Rurema, ti: «Ugikabule haashi.» Musa, mbu agikabulage ho, lyeryo irya ngoni yanayami hinduka mujoka. Musa anakanguka, anayami galuka kifudeete. ");
INSERT INTO flr_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Nahano anashubi múbwira: «Lambuula ukuboko kwawe. Yugu mujoka, ugugwatire ku mukira.» Musa analambuula ukuboko, anaguzezeera. Haaho-haaho, gwanashubi hinduka ngoni. ");
INSERT INTO flr_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Nahano anashubi deta: «Ugire yiki kitangaaza, halinde Abahisiraheeri bayemeere kwo nie wakuhulukira kwo. Nie Rurema wa bashokuluza baabo, Hiburahimu, na Hisake, na Yakobo.» ");
INSERT INTO flr_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Nahano anashubi múbwira: «Buno, ubiike ukuboko kwawe mu kwaha.» Musa anakubiika mwo. Neꞌri akagira mbu akulyose mwo, anabona kwo kukola noꞌmubembe, kunakola kweru, pepeepe! ");
INSERT INTO flr_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Rurema anashubi múbwira: «Yukwo kuboko kwawe, ukushubize mu kwaha.» Musa anakushubiza mwo. Neꞌri akashubi kulyosa mwo, anabona kwoꞌmubembe keera gwanyogoka. Amagala gaage, ganashubi ba nga kwo gâli tuuziri. ");
INSERT INTO flr_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Nahano anadeta: «Yabo Bahisiraheeri, iri wangagira yikyo kisoomeza imbere lyabo, haliko batanakuyemeere, umenye kweꞌkyanya ugaboneesa ikya kabiri, lyoki lyo bagakuyemeera. ");
INSERT INTO flr_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kundu kwokwo, yibi bisoomeza byombi, hali ikyanya batangabiyemeera, batanatwaze amagambo gaawe. Lyeryo, ushamate amiiji mu lwiji Niire, unagafuke áhayumiri. Yago miiji, gagayami hinduka muko.» ");
INSERT INTO flr_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Kundu Nahano akadeta kwokwo, haliko Musa anashubi múbwira: «E Nahamwitu, ungejeerere! Uyiji-yiji kwoꞌkulyokera keera, ululimi lwani luli luzito, na ndi mu kizi kukumiza.» ");
INSERT INTO flr_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Nahano anamúshuvya: «Nyandi úkabumba akanwa koꞌmundu? Na nyandagi úli mu gira umundu abe kimeme, kandi iri bitwitwi? Na kandi, nyandi úli mu múgira akizi bona, kandi iri abe mbumi? Yibyo byoshi, ka ndali nie ndi mu bigira? ");
INSERT INTO flr_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Aaho! Genda naaho. Yikyo kikukumizi, ngakilyosa mu kanwa kaawe, na nguyigirize ngiisi byo ugaadeta.» ");
INSERT INTO flr_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Uyo Musa anashubi deta: «E Nahano, nakuyinginga, maashi, ungejeerere. Ulungike yoꞌgundi.» ");
INSERT INTO flr_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Iri Musa akadetaga kwokwo, Nahano anamúrakarira: «Mwene winyu wa Harooni, kutagi? Si nyiji kwo ali mu rongorora mu kudeta, anali Mulaawi. Na buno, akola agayiji kusanganira. Ikyanya agakubona, umutima gwage gugashambaala. ");
INSERT INTO flr_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ugatee kizi ganuula na Harooni, unakizi múbwira ngiisi byo agaadeta. Ngakizi mùrongoora mwembi. Na ngizi mùyigiriza byo mugakizi gira, na byo mugakizi deta. ");
INSERT INTO flr_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Harooni ye gakizi deta ahandu haawe, mu kukizi ganuula naꞌBahisiraheeri. Naawe, we gaaba nga Rurema wage. ");
INSERT INTO flr_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ku yukwo, iyo ingoni yo ufumbiiti, ukizi gigendana, ikabe yo ugakizi koleesa mu kugira ibisoomeza.» ");
INSERT INTO flr_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Iri Rurema akayusa ukuganuuza Musa, Musa anagalukira imwa Yeturo, shevyala, anamúbwira: «Nakuyinginga, we kongwa, umbanguule ngalukire i Miisiri, gira ngendi lola, iri beene witu bakiba ho.» Na wa shevyala, ti: «E mwana wani, ugendage noꞌmutuula.» ");
INSERT INTO flr_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Ikyanya Musa atazi lyoka mu kihugo kyeꞌMidyani, Nahano anamúbwira: «E Musa, ugalukirage mu kihugo kyeꞌMiisiri. Mukuba, balya booshi ábâli kizi looza kwo bakuyite, keera bakafwa.» ");
INSERT INTO flr_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kwokwo, Musa anayabiira mukaage, na bagala baage bombi, anabashoneza ku bapunda. Anashokola injira yoꞌkugalukira i Miisiri, akoli fumbiiti irya ngoni ya Rurema. ");
INSERT INTO flr_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Nahano anashubi bwira Musa: «Lola! Ikyanya ugagalukira mu kihugo kyeꞌMiisiri, ugendage imwa mwami wabo. Na ngiisi bitangaaza byo keera nakushoboleesa, ukizi bigira imbere lyage. Kundu kwokwo, ngakizi kayisa umutima gwage, atanamùhanguule kwo mugende. ");
INSERT INTO flr_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","«Kwokwo, ukamúbwire, ti: “Nahano, akyula kwokuno: Hisiraheeri ye mwana wani, anali ye fula yani. ");
INSERT INTO flr_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Keera nanakubwira kwo umúhanguule, gira agendi nyikumba. Halikago, walahira kwo atagende. Kwokwo buno, ngayita mugala wawe weꞌfula.”» ");
INSERT INTO flr_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Iri Musa akaba akiri mwiꞌyo njira yoꞌkugenda i Miisiri, anahika haꞌbageezi bali mu handa. Haaho, Nahano anamúhulukira kwo, anagira mbu amúyite. ");
INSERT INTO flr_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Mukaage Zipoora, mbu abonage kwokwo, anakwabaduka, anatoola ibuye lyugi, anayami tenguula mwo mugala wage. Ha nyuma, anayabiira ikikoba, anagendi kileeza ku magulu ga yiba, anamúbwira: «Uli yibanie, unakoli shiizirwi umuko.» ");
INSERT INTO flr_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Iri Rurema akabona kwokwo, analeka Musa, atanaki múyita. (Mukuba, ikyanya Zipoora akadeta: «Uli yibanie, unakoli shiizirwi umuko», kuli kudeta hiꞌgulu lyoꞌkutenguulwa.) ");
INSERT INTO flr_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Ku yikyo kyanya, Nahano âli mali gwanwa ahulukira ku Harooni, anamúbwira: «Ugende mwiꞌshamba, ugendi gwanana na Musa.» Kwokwo, Harooni anagenda mwo, anagwanana na Musa ku mugazi gwa Rurema, anamúhoobera. ");
INSERT INTO flr_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Musa, anamúganuulira ngiisi kwo Nahano akamúbwira, anamúmenyeesa kwakundi neꞌbisoomeza byoshi byo agakizi kola. ");
INSERT INTO flr_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Yabo bombi, banagendi kuumania abashaaja booshi baꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Harooni anabaganuulira amagambo gooshi go Nahano atuma Musa. Ikyanya Musa âli riiri imbere lyaꞌBahisiraheeri booshi, anagira birya bisoomeza. ");
INSERT INTO flr_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Yabo Bahisiraheeri, iri bakabibona, banayemeera. Neꞌri bakayuvwa ngiisi kwo Nahano keera abahahalira mu makuba gaabo, booshi banayinika amatwe gaabo haashi, banamúyikumba. ");
INSERT INTO flr_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ha nyuma, Musa na Harooni banagendaga imwa Faraho, banamúbwira: «E mwami, Nahano Rurema waꞌBahisiraheeri, akyula kwokuno: “Uleke abandu baani bagendi ngirira ulusiku lukulu mwiꞌshamba.”» ");
INSERT INTO flr_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mwami naye, ti: «Uyo Nahano winyu, ali nga nyandi? Na kituma kiki nangamúyuvwiriza? Nanga, ndamúyiji. Ndanganahanguula Abahisiraheeri kwo bagende.» ");
INSERT INTO flr_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Musa na Harooni, ti: «Rurema waꞌBaheburaniya, keera akatuhulukira kwo. Ku yukwo, twakuyinginga maashi, utuleke tugire ulugeezi lweꞌsiku zishatu mwiꞌshamba, gira tugendi tanga ituulo imwa Rurema Nahamwitu. Iri tutangagira kwokwo, hali ikyanya angatuyita ku kiija, kandi iri ku ngooti.» ");
INSERT INTO flr_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Uyo mwami, ti: «E Musa mwe na Harooni, kituma kiki mugweti mugalooza ukuyolohya abandu mu mikolwa yabo? Mugigalukire mwo. ");
INSERT INTO flr_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Yabo biinyu, si bali bingi bweneene. Na buno, mukola mu looza kwo bajande imikolwa.» ");
INSERT INTO flr_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ku lwolwo lusiku, Faraho anakyula, mu kubwira basheebuja, naꞌbandi bimangizi, ti: ");
INSERT INTO flr_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Yabo bandu, ukulyokera zeene, mutakizi ki baleetera ubukere bwoꞌkubumba mwaꞌmatafaari. Haliko, mubabwire kwo bakizi gendi buyitemera boonyene. ");
INSERT INTO flr_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Si balyagagi boolo! Kyo kitumiri bagweti bagaalira, ti: “Utuleke tugendi tanga ituulo imwa Rurema witu.” Nanga! Umuharuuro gwaꞌmatafaari, guyame gwogulya-gwogulya. Hatanagire kiri niꞌtafaari írigaahala. ");
INSERT INTO flr_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Yaba bandu, mugendi bayushuulira imikolwa. Bakizi koleereza, halinde batwikire ku yaga magambo goꞌkuhenderezania.» ");
INSERT INTO flr_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Kwokwo, yabo basheebuja, kiri naꞌbandi ábâli yimangiiri yabo Baheburaniya, banagendi babwira: «Yuvwagwi! Mwami akyula kwo atagakizi ki mùheereza ubukere. ");
INSERT INTO flr_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Si mukizi genda mugabuyiloogeza mwenyene. Haliko, umuharuuro gwaꞌmatafaari, gugayama guli gwogulya-gwogulya.» ");
INSERT INTO flr_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Yabo Baheburaniya, iri bakayuvwa kwokwo, banayami yilagala mu bukere, gira balonge ukubumba mwaꞌmatafaari. ");
INSERT INTO flr_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Balya bimangizi, banakizi bahidika, ti: «Ngiisi lusiku, mukwiriiri mukizi hisa gwogulya-gwogulya muharuuro gwaꞌmatafaari, nga kwo mwâli kizi gira ku kyanya mushuba mu leeterwa ubukere.» ");
INSERT INTO flr_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Yabo bimangizi baꞌBamiisiri banakizi himbula abaabo bimangizi baꞌBahisiraheeri, iri banababwira: «Kituma kiki mutakiri mu gira umukolwa gwinyu bwija? Umuharuuro gwo mukabwirwa, mukizi guhisa.» ");
INSERT INTO flr_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Iri hakatama, yabo bakulu baꞌBahisiraheeri, banagendera mwami, banamútakira: «Si tuli bakozi baawe! Aaho! Kituma kiki uki gweti ugatulibuza? ");
INSERT INTO flr_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","E mwami, kundu tuli mu bumba amatafaari, haliko tutakiri mu longa ubukere. Na badaata-buja, kundu bo bagweti bagatuhimbula, haliko boonyene bo batuhubiiri.» ");
INSERT INTO flr_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mwami naye, ti: «Huliki! Si mweshi mulyagagi boolo! Kyo kitumiri mugweti mugadaada, mbu: “Utuleke tugendi tangira Nahano witu ituulo.” ");
INSERT INTO flr_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kwokwo buno, mugalukirage mu mukolwa. Mukizi bumba amatafaari, gaagalya-gaagalya go mukabwirwa. Na mwenyene mukizi yitemera ubukere.» ");
INSERT INTO flr_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Balya bimangizi baꞌBahisiraheeri banabona kwo keera bayingira mu makuba. Mukuba, bakabwirwa: «Ngiisi lusiku, umuharuuro gwaꞌmatafaari gutahale.» ");
INSERT INTO flr_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Neꞌri bakalyoka imwoꞌyo mwami, banagwanana Musa na Harooni, bagweti bagabalindirira, ");
INSERT INTO flr_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","banababwira: «Kwo muli mwembi, Nahano amùhaniirize. Si mwe mwatuma tukola kyagaza i bwami, kiri na mu bakulu baayo. Mwe mwamúfumbasa ingooti, gira atuminike.» ");
INSERT INTO flr_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Ikyanya Musa akayuvwa kwokwo, anagalukira imunda Nahano, anamúbwira: «E Nahano, kituma kiki wagirira balya bandu buligo? Aaho! Ka kyo kyatuma wanduma? ");
INSERT INTO flr_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Lolaga! Keera nagenda imwa mwami weꞌMiisiri kwiꞌziina lyawe, twanaganuula twe naye. Noꞌkulyokera lulya lusiku, akoli gweti agalibuza abandu baawe ingingwe. Si utazi baguluula, kiri neꞌhiniini!» ");
INSERT INTO flr_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Nahano anabwira Musa: «Uyo mwami weꞌMiisiri, ugaki bona ngiisi kwo ngamúgirira. Mukuba, ngakoleesa ubushobozi bwani bwaꞌkahebuuza, halinde amùhanguule mugende. Bulya bushobozi bwani, ikyanya agabubona, agayami mùyimula mu kihugo kyage.» ");
INSERT INTO flr_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Rurema anashubi deta: «E Musa, niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nie wâli kizi hulukira ku Hiburahimu, na ku Hisake, na ku Yakobo, mu kuyiyerekana kwo ndi Rurema woꞌbushobozi bwoshi. Kundu kwokwo, yiryo iziina lyani lya Nahano, ndakabamenyeesa lyo. ");
INSERT INTO flr_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Neꞌkyanya bâli tuuziri mu kihugo kyeꞌKaanani nga binyamahanga, twananywana ikihango, nanababwira kwo ngabaheereza kyo. ");
INSERT INTO flr_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Na buno, kundu Abamiisiri bagweti bagabakoleesa mu buja, haliko keera nayuvwa ngiisi kwo bagweti bagagongeera bweneene. Na buno, ngi kengiiri kirya kihango kyo tukanywana. ");
INSERT INTO flr_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","«Ku yukwo, ubwirage Abahisiraheeri kwokuno: “Niehe, nie Nahano! Ngamùlyosa mu buja bwaꞌBamiisiri, mutaganaki bakolera. Ngamùguluula noꞌkuboko kwani kwoꞌbushobozi. Neꞌkyanya ngakizi bahana, ngakizi bagira mweꞌbitangaaza bya kahebuuza. ");
INSERT INTO flr_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kwokwo, mugayama muli bandu baani. Naani, na mbe Rurema winyu. Haaho lyo mugaamenya kwo nie Nahano, Rurema winyu, na kwo nie kamùlyosa mu buja i Miisiri. ");
INSERT INTO flr_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Yikyo kihugo, nꞌgakilagaania Hiburahimu, na Hisake, na Yakobo, mu kubabiikira indahiro. Na niinyu, ngaki mùheereza kyo, kibe na kyeꞌmwinyu. Niehe, nie Nahano.”» ");
INSERT INTO flr_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Yago magambo gooshi, Musa anagendi gaganuulira Abahisiraheeri. Kundu kwokwo, batanamútwaza. Mukuba, imitima yabo yâli koli hanamiri, bwo bâli kandamiirwi bweneene mu buja bukayu. ");
INSERT INTO flr_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ha nyuma, Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Ugendage imwa Faraho, unagendi múbwira kwo ahanguule Abahisiraheeri balyoke mu kihugo kyage.» ");
INSERT INTO flr_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Haliko Musa anashuvya: «E maashi, Nahano, yabo Bahisiraheeri batakiri mu ndwaza. Kutagi kwo Faraho agaki nyuvwiriza? Na kwakundi, ndali mu twisa mu kudeta.» ");
INSERT INTO flr_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Kundu kwokwo, Nahano anabwira Musa na Harooni kwo bagendage naaho imwa Faraho, mwami weꞌMiisiri, anababwira kwo bagendi lyosa Abahisiraheeri mu kihugo kyage. ");
INSERT INTO flr_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Yabo Bahisiraheeri, bashokuluza beꞌmbaga zaabo, bo baaba: Rubeni, ye wâli riiri fula yaꞌBahisiraheeri. Na bagala baage, Hinoki, na Paalu, na Hesirooni, na Karimi. Yabo, bo bâli riiri bashokuluza baꞌmakondo ga Rubeni. ");
INSERT INTO flr_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Bagala Simyoni nabo, Yemweri, na Yamini, na Ohadi, na Yakiini, na Shohaari, na Sahuli. Uyo Sahuli, akabutwa ku Mukaanani-kazi. Yabo nabo, bo bâli riiri bashokuluza baꞌmakondo ga Simyoni. ");
INSERT INTO flr_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Bagala Laawi, nga kwo bâli yandisirwi mu kitaabo: Girishooni, na Kohaati, na Meraari. Uyo Laawi, akalama imyaka igana na makumi gashatu niꞌrinda. ");
INSERT INTO flr_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Uyo Girishooni naye, ye yishe wa Libuuni na Shimeyi. Yabo bombi, bo bashokuluza baꞌmakondo gaabo. ");
INSERT INTO flr_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Uyo Kohaati, bagala baage bo baaba: Hamuramu, na Hishaari, na Heburooni, na Huzyeri. Uyo Kohaati, akalama imyaka igana na makumi gashatu niꞌshatu. ");
INSERT INTO flr_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Uyo Meraari naye, bagala baage bo baaba: Maali, na Muushi. Yabo booshi, bo bashokuluza baꞌmakondo gaꞌBalaawi. ");
INSERT INTO flr_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Uyo Hamuramu anayanga nashengi Yokebeedi. Uyo Yokebeedi anamúbutira Harooni na Musa. Uyo Hamuramu akalama imyaka igana na makumi gashatu niꞌrinda. ");
INSERT INTO flr_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Uyo Hishaari, bagala baage bo baaba: Koora, na Nefegi, na Zikiri. ");
INSERT INTO flr_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Na Huzyeri naye, bagala baage bo baaba: Mishaheeri, na Herizafaani, na Sitiri. ");
INSERT INTO flr_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Uyo Harooni anayanga Herisheeba munyere Haminadabu, anali ye mwali wa Nasooni. Uyo Herisheeba anamúbutira Nadabu, na Habihu, na Heryazaari, na Hitamaari. ");
INSERT INTO flr_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Uyo Koora naye, bagala baage, Hasiri, na Herikana, na Habyasafu. Yabo, bo bashokuluza baꞌmakondo geꞌmwa Koora. ");
INSERT INTO flr_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Heryazaari mugala Harooni, anayanga mu banyere Putyeri. Anamúbuta kwoꞌmwana woꞌbutabana Finehaasi. Yabo, bo bashokuluza baꞌmakondo gaꞌBalaawi. ");
INSERT INTO flr_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Harooni na Musa, baabo bo Nahano akabwira: «Mulyose Abahisiraheeri mu kihugo kyeꞌMiisiri. Neꞌkyanya mugabalyosa mwo, bakizi genda ndeeko-ndeeko.» ");
INSERT INTO flr_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Musa na Harooni, bo banâli kizi ganuuza Faraho, mwami weꞌMiisiri, kwo bahanguulwe ukulyosa Abahisiraheeri mu kihugo kyage. ");
INSERT INTO flr_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ku lwolwo lusiku Nahano akaganuula na Musa mu kihugo kyeꞌMiisiri, ");
INSERT INTO flr_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","anamúbwira: «Niehe, nie Nahano. Ngiisi magambo go nakubwira, ugendi gaganuulira Faraho, mwami weꞌMiisiri.» ");
INSERT INTO flr_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Uyo Musa ye kanabwira Nahano: «Niehe, ndali mu twisa mu kudeta. Aaho! Kutagi kwo mwami weꞌMiisiri anganyuvwiriza?» ");
INSERT INTO flr_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Iri hakatama, Nahano anabwira Musa: «Yuvwagwa! Namu kugira ube nga Rurema imwa mwami weꞌMiisiri. Na mukulu wawe wa Harooni, agakizi deta ahandu haawe. ");
INSERT INTO flr_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ngiisi go ngakubwira, gabe go agakizi deta. Mukulu wawe wa Harooni, akwaniini abwire Faraho kwo ahanguule Abahisiraheeri balyoke mu kihugo kyage. ");
INSERT INTO flr_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Na kundu ngakizi yushuula ibyereso byeꞌbitangaaza i Miisiri, si umutima gwoꞌyo mwami, ngagenderera ukuguyumuusa. ");
INSERT INTO flr_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Na kundu atagakutwaza, haliko ngalyosa abandu baani Abahisiraheeri, mu kihugo kyage. ");
INSERT INTO flr_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Neꞌkyanya yabo Bamiisiri bagaabona ngiisi kwo nalyosa Abahisiraheeri mu kihugo kyabo, lyeryo lyo bagaamenya kwo nie Nahano.» ");
INSERT INTO flr_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Ngiisi kwo Nahano akabwira Musa na Harooni, kwo na kwokwo bakanagira. ");
INSERT INTO flr_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ku kyanya bakaganuuza Faraho, Musa âli kola neꞌmyaka makumi galimunaana. Mukulu wage wa Harooni, naye âli kola neꞌmyaka makumi galimunaana niꞌshatu. ");
INSERT INTO flr_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Nahano anabwira Musa na Harooni kwokuno: ");
INSERT INTO flr_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Faraho agamùbwira kwo mumúyereke ikitangaaza. Haaho, ubwire Harooni kwo akabule ingoni haashi imbere lyage, inayami hinduka mujoka.» ");
INSERT INTO flr_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kwokwo, Musa na Harooni banagenda imwa Faraho, banagira nga ngiisi kwo Nahano akababwira. Neꞌri Harooni akakabulaga ingoni yage haashi imbere lya Faraho naꞌbatwali baage, irya ngoni yanayami hinduka mujoka. ");
INSERT INTO flr_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Lyeryo, Faraho anatumira abitegeereza baage, naꞌbanamaleere. Yabo banamaleere, banagira nga kwokulya Musa na Harooni bagira. Si boohe, bakabigira ku njira yaꞌmaleere gaabo. ");
INSERT INTO flr_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Ngiisi muguma wabo, anakizi kabula ingoni yage haashi, inayami hinduka mujoka. Kundu kwokwo, yizo ngoni zaabo, ingoni ya Harooni yanakizi zimirangusa. ");
INSERT INTO flr_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Ulya mwami, anagenderera ukuyumuusa umutima gwage, atanabatwaza, nga kwo Nahano âli mali gwanwa adeta. ");
INSERT INTO flr_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ha nyuma, Nahano anabwira Musa: «Faraho keera ayumuusa umutima gwage, mu kulahira kwaꞌBahisiraheeri batalyoke mu kihugo kyage. ");
INSERT INTO flr_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Aaho! Uzindukage ha lwiji Niire, gira ulindirire Faraho ku kyanya naye agazinduka ho. Ikyanya ugaaba umúlindiriiri, ube ufumbiiti irya ngoni íkahinduka mujoka. ");
INSERT INTO flr_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","«Neꞌri wangamúgwana ho, unamúbwire: “Nahano Rurema waꞌBaheburaniya, ye wanduma, ti: Ulekage abandu baani, bagendi nyikumbira mwiꞌshamba.” Si halinde buno, utandwaziizi. ");
INSERT INTO flr_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ku yukwo, Nahano adeta kwo ukola ugamúmenya kwo ye Nahano kwiꞌno njira: Ino ngoni yo nvumbiiti, ikyanya ngagishulika mu lwiji Niire, amiiji gaalwo gagayami hinduka muko. ");
INSERT INTO flr_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ifwi zooshi íziri mwo, zigayami fwa. Naꞌmiiji gaalwo, ganabe niꞌsiko libi, halinde bitanaki zige kwaꞌBamiisiri bakizi ganywa.» ");
INSERT INTO flr_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Nahano anashubi bwira Musa: «Iyo ngoni ya Harooni, umúbwire kwo agigolole ku miiji gooshi ágali mu Miisiri: ku nyiiji, na ku migenda, na ku birigo, na ku gandi miiji gooshi. Yago miiji gooshi, gagayami hinduka muko naaho-naaho, kiri na ágali mu birugu bibaaje mu biti, na mu mabuye. Yugwo muko gugayami kwira mu kihugo kyoshi.» ");
INSERT INTO flr_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Ikyanya Nahano akabwira Musa na Harooni kwokwo, banagendi bigira. Harooni anabangula ingoni yage imbere lya Faraho, neꞌmbere lyaꞌbatwali baage, anagishulika mu lwiji Niire. Lyeryo, galya miiji gooshi ganayami hinduka muko. ");
INSERT INTO flr_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kyanatuma ifwi zooshi za mu lwiji zigaafwa. Yago miiji ganakizi baya isiko libi. Abamiisiri batanashobola ukuganywa. Yugwo muko, gwanayijula hooshi mu kihugo. ");
INSERT INTO flr_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Yabo banamaleere beꞌMiisiri, banashubi koleesa amaleere gaabo. Nabo banahindula amiiji gabe muko. Kyanatuma mwami agayumya umutima gwage, atanaki yuvwiriza Musa na Harooni, nga kwo Nahano âli mali gwanwa adeta. ");
INSERT INTO flr_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Mwami anagalukira mu kajumiro. Yibyo byoshi, kundu bikakoleka, atanabitwaza. ");
INSERT INTO flr_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Yago miiji goꞌlwiji, Abamiisiri batâli kizi ki ganywa. Kyanatuma bagakizi fuluula ku butambi bwalwo, mu kukizi looza amagoloovi. ");
INSERT INTO flr_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Yulwo lwiji Niire, iri Nahano akaba keera alushereeza, hanatee lenga isiku zirinda. ");
INSERT INTO flr_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Ha nyuma, Nahano anabwira Musa: «Ugendi bwira Faraho kwo nakyula kwokuno: “Uhanguulage abandu baani, bagendi nyikumba. ");
INSERT INTO flr_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Neꞌri wangabalahirira, ngayijuza ikihugo kyawe kyoshi mwo bakere. ");
INSERT INTO flr_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Yabo bakere, bagayijula mu lwiji Niire, banakizi yihandalika kiri na mu kajumiro kaawe. Banakizi bodokera mu bisiika byawe, halinde na ku ngingo. Banayihandalike na mu nyumba zaꞌbatwali baawe. Banakizi simbukira ku bandu baawe booshi, banayifunde kiri na mu bideekero biinyu, na ku njyo zo muli mu shyera kwo. ");
INSERT INTO flr_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Kiri na wenyene, yabo bakere bagakizi kubodokera kwo. Banakizi bodokera na ku batwali baawe, na ku bindi byoshi mu kihugo.”» ");
INSERT INTO flr_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nahano anashubi bwira Musa: «Ubwire Harooni kwo abangulire ingoni yage iwa nyiji, neꞌwa ngera, neꞌwa birigo. Mu yago miiji gooshi, mugayulubuka bakere, banakwire hooshi mu kihugo.» ");
INSERT INTO flr_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Uyo Harooni, iri akabangulira ingoni yage iwa miiji, bakere banayami yulubuka mwo, banakwira mu kihugo kyoshi, nywe! ");
INSERT INTO flr_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kundu kwokwo, yabo banamaleere beꞌMiisiri banakoleesa amaleere gaabo, mu kugira kyekyo-kyekyo kitangaaza, banayulubula abandi bakere. ");
INSERT INTO flr_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kwokwo, Faraho anatumira Musa na Harooni, anababwira: «Muyingingage Nahano maashi, anjaagize yaba bakere mu mwani, kiri na mu bandu baani. Leero, ngola ngamùhanguula, mugendi mútangira ituulo.» ");
INSERT INTO flr_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Musa, ti: «E mwami, umbwire ulusiku lwo nangakuhuunira imwa Rurema, we naꞌbatwali baawe, naꞌbandi bandu baawe. Ngamúhuuna asivye bakere booshi ba mu nyumba ziinyu. Si ábali mu lwiji Niire boohe, agabasiga.» ");
INSERT INTO flr_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Faraho, ti: «Umúhuune kusheezi.» Musa, ti: «Bigaaba nga kwo wadeta, halinde lyo ulonga ukumenya kwo ndaaye gundi úyumiini na Rurema Nahamwitu. ");
INSERT INTO flr_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Yabo bakere, bagalyoka mu mwawe, neꞌmwa batwali baawe, kiri neꞌmwaꞌbandi bandu baawe. Bagasigala naaho mu lwiji Niire.» ");
INSERT INTO flr_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Iri Musa na Harooni bakalyoka imunda Faraho, Musa anagendi takira Nahano kwo yabo bakere, abalyosagye. ");
INSERT INTO flr_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ikyanya Musa akahuuna kwokwo, Nahano anashaaza balya bakere booshi, halinde banayami fwa mu nyumba, neꞌmbuga, kiri na mu ndalo. ");
INSERT INTO flr_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Yabo bakere, banalundwa, halinde ikihugo kyoshi kyanabaya isiko libi. ");
INSERT INTO flr_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Iri Faraho akabona kweꞌkihugo kyage kyaluhuuka, anashubi yumuusa umutima gwage, atanaki twaza Musa na Harooni. Bikakoleka nga kwokulya Nahano âli mali gwanwa adeta. ");
INSERT INTO flr_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ha nyuma, Nahano anashubi bwira Musa: «Ubwirage Harooni kwo abangule ingoni, anagishulike haashi. Haaho, ulukungu lwa mu kihugo kyoshi kyeꞌMiisiri lugayami hinduka nda.» ");
INSERT INTO flr_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Kwokwo, kwo bakanagira. Ikyanya Harooni akashulika ingoni haashi, ulukungu lwanayami hinduka nda. Yizo nda, zanakizi nyegeeta ku bandu, kiri na ku bitugwa. Lulya lukungu lwoshi lwa mu kihugo kyeꞌMiisiri, lukahinduka nda naaho-naaho. ");
INSERT INTO flr_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Abanamaleere beꞌMiisiri, iri bakagira mbu nabo bahindule ulukungu lube nda, batanashobola. Yizo nda, zanakaviiriza ukukizi nyegeeta ku bandu, kiri na ku bitugwa. ");
INSERT INTO flr_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Yabo banamaleere banabwira Faraho: «Yibi leero, Rurema ye wabikola.» Kundu kwokwo, ulya mwami anagenderera ukuyumuusa umutima gwage, atanatwaza Musa na Harooni. Bikaba nga kwokulya Nahano âli mali gwanwa adeta. ");
INSERT INTO flr_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ha nyuma, Nahano anabwira Musa: «Uzinduke ha lwiji Niire, gira ulindirire Faraho ku kyanya naye agazinduka ho. Umúbwire kwo Nahano akyula kwokuno: “Uhanguule abandu baani, bagendi nyikumba.” ");
INSERT INTO flr_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Neꞌri wangalahira, ngaatuma ulumamo lweꞌsaazi mu nyumba yawe, na mu nyumba zaꞌbatwali baawe, kiri na mu zaꞌbandi bandu baawe booshi. Inyumba ziinyu, zigayijula mweꞌsaazi. Yizo saazi, zigakizi nyegeeta, kiri na haashi. ");
INSERT INTO flr_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","«Si ku lwolwo lusiku, abandu baani ábatuuziri i Gosheni boohe, ngabagirira kwabo-kwabo, ndaanazo saazi ízigaafina yo. Kwokwo, lyo ugaamenya kwo nie Nahano, na kwo ngoli tuuziri mu kino kihugo. ");
INSERT INTO flr_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ku yukwo, abandu baani, ngabakolera ku yabo-yabo njira, naꞌBamiisiri ku gindi-gindi. Yikyo kitangaaza, kigakoleka kusheezi.» ");
INSERT INTO flr_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kwokwo, kwo Nahano akagira. Lulya lumamo lweꞌsaazi, lwanakizi guumuka mu kihugo kyoshi kyeꞌMiisiri, halinde lwanakizi yihandalika mu kajumiro, na mu nyumba zaꞌbatwali, kiri naꞌhandi hooshi mu kihugo. Yizo saazi, zanashereeza ngana-ngana. ");
INSERT INTO flr_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Uyo Faraho, anashubi tumira Musa na Harooni, anababwira: «Gendagi! Mwangakoli tangira Rurema winyu ituulo. Si mukizi litangira mwomuno mu kihugo kyeꞌMiisiri.» ");
INSERT INTO flr_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Musa, ti: «Yibyo wadeta, bitagaaziga. Ikyanya tugakizi gendi tangira Rurema Nahamwitu amatuulo, gatagakizi simiisa Abamiisiri. Neꞌri twangabayagaza kwokwo, hali ikyanya bangakengeera batulasha amabuye. ");
INSERT INTO flr_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ku yukwo, tukwaniini tugire ulugeezi lweꞌsiku zishatu mwiꞌshamba, gira tugendi tangira Rurema Nahamwitu ituulo, nga kwo akatuhamuliza.» ");
INSERT INTO flr_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Iri hakatama, uyo Faraho anadeta: «Leero, ngola ngamùhanguula mugendi tangira Rurema Nahamwinyu amatuulo mwiꞌshamba. Si mutayikondeere bweneene! Na buno naani, mumbuunire imwage.» ");
INSERT INTO flr_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Musa, ti: «Ikyanya ngalyoka hano, ngayami gendi huuna Nahano. Na kusheezi, yulu lumamo lweꞌsaazi úluli mu nyumba yawe lugaguumuka, kiri na úluli mu batwali baawe, na mu bandi bandu baawe. Si leero utaki shubi tuteba, mbu unashubi hangirira Abahisiraheeri batagendi tangira Nahano amatuulo.» ");
INSERT INTO flr_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Musa, iri akahulukaga mwiꞌyo nyumba ya Faraho, anagendi huuna Nahano. ");
INSERT INTO flr_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Neꞌkyanya akahuuna, Nahano anamúshuvya. Kwokwo, zirya saazi zooshi zanashaaga mu kajumiro, na mu nyumba zaꞌbatwali, kiri na mu nyumba zaꞌbandi bandu. Ndaalwo kiri noꞌluguma úlukasigala. ");
INSERT INTO flr_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kundu kwokwo, ulya Faraho anashubi yumuusa umutima gwage, atanaki hanguula Abahisiraheeri kwo bagende. ");
INSERT INTO flr_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Ha nyuma, Nahano anashubi bwira Musa: «Nakutuma, ugendi bwira Faraho kwo Nahano Rurema waꞌBahisiraheeri, akyula kwokuno: “Uhanguule abandu baani bagendi nyikumba.” ");
INSERT INTO flr_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Neꞌri wangabalahirira kwo batagende, unagenderere ukubahangirira, ");
INSERT INTO flr_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ngamùhana. Ibitugwa biinyu mu biraaro, ngabiyingiza mwaꞌkafunya, kiri na mu fwarasi, na bapunda, neꞌngamiya, neꞌngaavu, neꞌmbene, neꞌbibuzi. ");
INSERT INTO flr_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","«Si ngabiika ulubibi ha kati keꞌbitugwa byaꞌBahisiraheeri, neꞌbyaꞌBamiisiri. Mukuba, mu bitugwa byaꞌBahisiraheeri boohe, ndaakyo kiri neꞌkiguma íkigakinduka.» ");
INSERT INTO flr_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yikyo kihano, Nahano anashungika ulusiku lwo agakikoleesa kwo, anadeta: «Yiri igambo lyo nashungika hiꞌgulu lyeꞌkihugo kyeꞌMiisiri, kusheezi lyo ngaligira.» ");
INSERT INTO flr_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Iri bukakya, Nahano anagira nga kwo ashungika. Birya bitugwa byoshi byaꞌBamiisiri, byanayami kinduka. Haliko ibitugwa byaꞌBahisiraheeri byohe, ndaakyo kiri neꞌkiguma íkikafwa. ");
INSERT INTO flr_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Mwami anatuma abandu, bagendi buuza hiꞌgulu lyeꞌbitugwa byaꞌBahisiraheeri. Neꞌri bakagaluka, banadeta: «Imwabo, ndaakyo kitugwa, kiri neꞌkiguma, íkyafwa.» Kundu kwokwo, ulya mwami anakaviiriza ukuyumuusa umutima, atanaki hanguula Abahisiraheeri kwo bagende. ");
INSERT INTO flr_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ha nyuma, Nahano anashubi bwira Musa na Harooni: «Mugendage ha kiiko, munashamate umunyota-kiiko. Yugwo munyota-kiiko, Musa agugendane imbere lya Faraho, agutumuulire hiꞌgulu. ");
INSERT INTO flr_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ikyanya agaagira kwokwo, gugakwira mu kihugo kyoshi kyeꞌMiisiri, gunameze ibirole ku bandu, kiri na ku bitugwa. Yibyo birole, bigakizi dunduuka mweꞌbihando.» ");
INSERT INTO flr_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Kwokwo, Musa na Harooni banagenda ha kiiko, banayabiira umunyota-kiiko, banagugendana imwa Faraho. Neꞌri bakahika imbere lyage, Musa anagutumuulira hiꞌgulu. Lyeryo, abandu banayami gwatwa neꞌbirole. Kiri neꞌbitugwa, byanalibuuka bweneene. ");
INSERT INTO flr_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Balya banamaleere, leero batanahasha kiri noꞌkuyimanga imbere lya Musa. Mukuba, nabo bâli gwasirwi neꞌbirole, bo naꞌbaabo Bamiisiri booshi. ");
INSERT INTO flr_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kundu kwokwo, Nahano anagenderera ukuyumuusa umutima gwa Faraho. Kyanatuma ikyanya Musa na Harooni bakagendi ganuuza Faraho, atanabatwaza, nga kwo Nahano âli mali gwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Nahano anashubi bwira Musa: «Kusheezi, uzindukage imwa mwami weꞌMiisiri, umúbwire kwo nie Nahano Rurema waꞌBaheburaniya, na ngweti ngakyula kwokuno: “Uleke abandu baani bagendi nyikumba. ");
INSERT INTO flr_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Buzira kwokwo, ngola ngakuhaniiriza, mwe naꞌbatwali baawe, naꞌbandi bandu baawe, lyo umenya kwo hano mu kihugo, ndaaye gundi Rurema úli ho. Ndaanaye ye twangageranwa. ");
INSERT INTO flr_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Wehe naꞌbandu baawe, njuba ngamùbiika mweꞌkiija, halinde ninamùsivye mu kihugo. ");
INSERT INTO flr_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Na íbikatuma nꞌgakuyimika, gira lyo nyerekana ubushobozi bwani, halinde liꞌziina lyani likizi lumbuuka mu mahanga gooshi. ");
INSERT INTO flr_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","«“Si uki genderiiri ukuhangirira abandu baani, utanabahanguula kwo bagende. ");
INSERT INTO flr_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Kwokwo, kusheezi, ku kihe nga kino, nganiesa ulugungu lwaꞌkahebuuza mu kino kihugo kyawe kyeꞌMiisiri. Yulwo lugungu, ukulyokera ho kino kihugo kyawe kikabumbirwa halinde zeene, lutazindi nia mwene kwokwo. ");
INSERT INTO flr_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ku yukwo, ibitugwa byawe, na ngiisi kindu kyawe íkiri mu mbingiro, ubitumire biyije i kaaya. Yulwo lugungu, luganiera ku ngiisi mundu úli mu mbingiro, na ku ngiisi kitugwa íkiri mu kishuka, kiri na ku ngiisi mundu úgaaba úkiri imbuga. Yibyo byoshi, bigayami fwa.”» ");
INSERT INTO flr_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Yago magambo ga Nahano, abatwali baguma ba Faraho banatondeera ukugayoboha, banayami gendi leeta abaja baabo, neꞌbitugwa byabo, banabayingiza mu nyumba. ");
INSERT INTO flr_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Haliko abandi, kundu Nahano akabakengula, batanamútwaza. Boohe, bakalekera ibitugwa mu mbingiro, kuguma naꞌbaja baabo. ");
INSERT INTO flr_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ha nyuma, Nahano anabwira Musa: «Ugololage ukuboko kwawe mu kyanyaanya, halinde ulugungu lunie hooshi mu Miisiri. Yulwo lugungu, luganiera ku ngiisi mundu, na ku ngiisi kitugwa, kiri na ku mbuto íziri mu ndalo.» ");
INSERT INTO flr_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ikyanya Musa akashongaga ingoni yage hiꞌgulu, lyeryo mu kihugo kyoshi kyeꞌMiisiri, Nahano ananiesa mwoꞌlugungu bweneene. Mwanakizi yuvwikana neꞌmikungulo. Mu kihugo, imilavyo yanakizi lavya hooshi. Kwokwo, kwo Nahano akaniesa ulukungu mu kihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Ikyanya yulwo lugungu lukania, mwâli kizi lavya imilavyo mikayu. Ulugungu mwene yulwo, heꞌkihugo kyeꞌMiisiri kikatondeerera, ndaaye Mumiisiri úwâli zindi lubona. ");
INSERT INTO flr_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mu kihugo kyoshi kyeꞌMiisiri, iyo nvula yoꞌlugungu yanahooja-hooja ngiisi kindu mu ndalo, halinde imbuto zooshi yanazikoonera haashi. Kiri neꞌbiti, yanabikunyula. Yanania ku bandu, kiri na ku bitugwa. ");
INSERT INTO flr_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Haliko, mu kihugo kyeꞌGosheni kyohe, itakania. Mukuba, yaho haꞌBahisiraheeri bâli tuuziri. ");
INSERT INTO flr_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Uyo Faraho anayami tumira Musa na Harooni, anababwira: «Buno leero nagira ikyaha. Nahano ye mwene ukuli. Si niehe naꞌbandu baani, twe twahuba. ");
INSERT INTO flr_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Kwokwo, muhuunage Nahano, ayimangike iyi nvula yoꞌlugungu, neꞌyi mikungulo. Si keera byaleeza ulugero! Leero, ngamùleka mulyoke mu kino kihugo, ndagaki mùhangirira kwo muyame mwo.» ");
INSERT INTO flr_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Musa naye, ti: «Ikyanya ngaahika inyuma lyaꞌkaaya, ngagolola amaboko gaani hiꞌgulu, mu kuhuuna Nahano. Haaho, lyeꞌmikungulo igayami yimanga. Kiri noꞌlugungu nalwo, lugaaba ndaakilwo. Kwokwo, lyo ugalonga ukumenya kweꞌkihugo kiri kya Nahano. ");
INSERT INTO flr_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Kundu kwokwo, ngi yiji kwo mwe naꞌbatwali baawe, mutatwaziizi Nahano Rurema.» ");
INSERT INTO flr_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Ikitaani noꞌbulo, byoshi byâli mali shereera, bwoꞌbulo bwâli kola mu sanura, neꞌkitaani kyâli kola kaaso. ");
INSERT INTO flr_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Haliko, ingano neꞌzindi mbuto íziri nga byo, byohe bitakashereezibwa, bwo biri mu sanura makeereza.) ");
INSERT INTO flr_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Musa analyoka yumwo mu kajumiro. Neꞌri akahika inyuma lyaꞌkaaya, anabiika amaboko hiꞌgulu mu kuhuuna Nahano. Lyeryo, irya mikungulo na lulya lugungu byanamala, shee! Kiri neꞌnvula, yanahumba. ");
INSERT INTO flr_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ulya Faraho, iri akabonaga kweꞌyo mikungulo neꞌyo nvula yoꞌlugungu keera byalenga, anashubi gira ikyaha, bo naꞌbatwali baage, banashubi yumuusa imitima yabo. ");
INSERT INTO flr_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Bikaba kwokwo, bwo Faraho âli riiri munakisiitu, anashubi lahira kwaꞌBahisiraheeri batagende. Bikaba nga kwokulya Nahano âli mali gwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Ha nyuma, Nahano anabwira Musa: «Ugendage imunda Faraho. Mukuba, umutima gwage, neꞌyaꞌbatwali baage, nie kagiyumuusa, halinde lyo ndonga ukuyerekana yibi byereso byeꞌkitangaaza mu kati kaabo. ");
INSERT INTO flr_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Kwokwo, lyo mugayiji ganuulira abaana biinyu, kiri na bijukulu biinyu, ngiisi kwo nâli kizi shekeereza Abamiisiri. Ee! Nâli kizi yerekana ibyereso byeꞌkitangaaza mu kati kaabo. Kwokwo, lyo mugaamenya kwo nie Nahano.» ");
INSERT INTO flr_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kwokwo, Musa na Harooni banagenda imwa Faraho, banamúbwira: «E mwami, Nahano Rurema waꞌBaheburaniya, akyula kwokuno: “Ugaahisa halinde mangoki, ugweti ugalahira ukuyibiika haashi imbere lyani? Uleke abandu baani bagendage, gira bagendi nyikumba. ");
INSERT INTO flr_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Neꞌri wangalahira mbu batagende, kusheezi ngaatuma inzige mu kino kihugo kyawe. ");
INSERT INTO flr_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Yizo nzige, ikyanya zigazuuka mwiꞌdaho, litagaki boneka. Zigakizi lya ngiisi íbikasigwa neꞌrya nvula yoꞌlugungu. Kiri neꞌbiti íbikola mu mina, hatagasigala kiri neꞌkitombo. ");
INSERT INTO flr_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Yizo nzige, zigayihandalika mu tujumiro, na mu nyumba zaꞌbatwali baawe, na mu zaꞌbandi Bamiisiri booshi. Ukulyokera ho bashokuluza biinyu bakabutirwa halinde zeene, inzige mwene yizo, zitazindi boneka.”» Musa, iri akaba keera alyoka imwa mwami, ");
INSERT INTO flr_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","yabo bagingi banahanuusa mwami: «E maashi, mwami, uyu mundu agagenderera ukutulibuza halinde mangoki? Ka utabwini kwo kino kihugo kiitu keera kyasherebera? Aaho! Uhanguule yaba bandu, bagendi yikumba Rurema Nahamwabo.» ");
INSERT INTO flr_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kyanatuma mwami weꞌMiisiri agatumira Musa na Harooni, anababwira: «Mugendi kolera Rurema Nahamwinyu. Si namu tee mùbuuza: Banyandi bo mugagendanwa?» ");
INSERT INTO flr_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Musa anamúshuvya: «Tugagenda tweshi, imisore naꞌbashaaja, naꞌbaana biitu, abanyere naꞌbatabana. Tunagende neꞌbitugwa biitu, imbene, neꞌngaavu. Mukuba, tukwaniini tugirire Nahano ulusiku lukulu.» ");
INSERT INTO flr_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Uyo Faraho naye, ti: «Iri nangamùleka kwo mugende na bakiinyu, kiri naꞌbaana, ka lyo Nahano agamùgashaanira? Nanga, maashi! Ngoli bwini kwo yizi shungi ziinyu, ziri mwoꞌbulyalya. ");
INSERT INTO flr_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Yibyo byoshi, bitagaaziga. Abashosi naaho, babe bo bagagendi yikumba Nahano. Si byebyo byo mushuba mu mbuuna.» Lyeryo, Musa na Harooni banayami halamulirwa imbuga, mu kuyimulwa imbere lya mwami. ");
INSERT INTO flr_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Nahano anashubi bwira Musa: «Ulambuule ukuboko kwawe ku kihugo kyeꞌMiisiri, gira inzige ziyije, zinakizi lya imbuto zooshi íziri mu ndalo. Zikizi lya ngiisi íbikasigwa neꞌrya nvula yoꞌlugungu.» ");
INSERT INTO flr_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kwokwo, Musa anashubi lengeza ingoni yage, anagishonga hiꞌgulu lyeꞌkihugo kyeꞌMiisiri. Lyeryo, Nahano analeeta ikihuhuuta ukulyoka uluhande lweꞌsheere, kyanahuusa ubushigi niꞌzuuba. Iri bukakya, yikyo kihugo kyoshi kyanateerwa neꞌnzige. ");
INSERT INTO flr_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Yizo nzige, zanashabukira mu kihugo kyoshi kyeꞌMiisiri, zanatwa ngiisi handu. Ukulyokera heꞌkihugo kikabumbirwa, inzige mwene yizo zitazindi boneka. Na kwakundi, zitanâye ki boneke. ");
INSERT INTO flr_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Yizo nzige, bwo zâli riiri kanyegete, kyanatuma idaho lyoshi ligayidika mweꞌkihulu. Ibyasi byoshi, neꞌbitumbwe byoshi íbikasigwa neꞌrya nvula yoꞌlugungu, zirya nzige zanabilya. Mu yikyo kihugo kyoshi, ndaakyo kitumbwe, kiri neꞌhyasi hibishi, íhikasigala mwo. ");
INSERT INTO flr_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Uyo Faraho, iri akabonaga kwokwo, anayami tumira Musa na Harooni, anababwira: «Keera nagira ikyaha bweneene imbere lya Rurema Nahamwinyu, kiri neꞌmbere liinyu. ");
INSERT INTO flr_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ku yukwo, namùyinginga, mungejereere irindi liguma, maashi! Mumbuunire ulukogo imwa Rurema Nahamwinyu, gira andyokeze yiri ibala.» ");
INSERT INTO flr_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Musa, iri akahuluka imwa Faraho, anagendi huuna Nahano. ");
INSERT INTO flr_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Lyeryo, Nahano anahulusa ikihuhuuta kikayu uluhande lweꞌmuga, kyanabalaza zirya nzige zooshi, kyanagendi zifuka mu Nyaaja Ndukula. Mu kihugo kyoshi, ndaalwo kiri noꞌluguma úlukasigala. ");
INSERT INTO flr_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Kundu kwokwo, Nahano anagenderera ukuyumuusa umutima gwa Faraho, atanaki shubi bahanguula kwo bagende. ");
INSERT INTO flr_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Nahano anashubi bwira Musa: «Ugolole ukuboko kwawe mu kyanyaanya, halinde ikihulu kya namudidi kiyidike mu Miisiri. Na yikyo kihulu, ndaaye mundu úwangashobola kiri noꞌkukibubuuta mwo.» ");
INSERT INTO flr_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Musa, mbu ashonge ukuboko kwage hiꞌgulu, lyeryo ngana ikihulu kya namudidi kyanayami yidika mu kihugo kyoshi kyeꞌMiisiri, kyanamala mweꞌsiku zishatu. ");
INSERT INTO flr_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Mu yizo siku zishatu, ndaaye mundu úwâli kizi bona uwabo, ndaanaye úkalyoka ho âli. Haliko Abahisiraheeri boohe, ngiisi ho bâli tuuziri, bâli riiri mu mulengeerwe. ");
INSERT INTO flr_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Uyo Faraho anahamagala Musa, anamúbwira: «Mugendage, maashi! Mugendi yikumba Nahano. Kiri na bakiinyu, naꞌbaana biinyu, mwangagendanwa. Si musige naaho ibitugwa biinyu.» ");
INSERT INTO flr_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Musa anamúshuvya: «Nanga! Ukwaniini utuhanguule, tugende neꞌbitugwa biitu, halinde tulonge ukugendi tangira Rurema Nahamwitu amatuulo goꞌkusiriiza, naꞌgandi matuulo. ");
INSERT INTO flr_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ee! Ibitugwa biitu byoshi, tukwiriiri tubitwale, tutanganasiga kiri neꞌkiguma. Mukuba, tukwiriiri tutange biguma, bisiriizibwe mu kuyikumba Rurema Nahamwitu. Ikyanya tutazi hika yo, tutangamenya kitugwa kihi kyo tugamútangira ituulo.» ");
INSERT INTO flr_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ulya Faraho, Nahano anakaviiriza ukumúyumuusa umutima, atanaki hanguula Abahisiraheeri kwo bagende. ");
INSERT INTO flr_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Lyeryo, Faraho anayimula Musa, mu kumúnaakira: «Njaaga mu masu! Utakolwe mbu ushubi galukira hano imbere lyani. Mango washubi yiji bona amalanga gaani, ngakuyita.» ");
INSERT INTO flr_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Musa naye, ti: «Ee! Biri nga kwo wadeta. Naani, utagaki shubi mbona hano ha mwawe.» ");
INSERT INTO flr_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Ha nyuma, Nahano anabwira Musa: «Uyu Faraho, kuguma neꞌkihugo kyage kyeꞌMiisiri, haki sigiiri ikindi kihano kiguma naaho. Ha nyuma lyakyo, agamùhanguula kwo mugendage. Neꞌkyanya agamùhanguula, leero kugaaba kwa lwoshi. ");
INSERT INTO flr_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ku yukwo, ubwire Abahisiraheeri kwo ngiisi muguma wabo, abashosi naꞌbakazi, bahuune abatuulani baabo ibirugu íbikatulwa mu harija, na mu nooro.» ");
INSERT INTO flr_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Kwokwo, mu yikyo kihugo kyeꞌMiisiri, Nahano anadundula mwaꞌBahisiraheeri bweneene, halinde kiri naꞌbatwali ba mu bwami bwa Faraho, naꞌbandi bandu, booshi banatondeera ukukizi kunda Musa. ");
INSERT INTO flr_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Musa anagendi bwira Faraho kwo Nahano akyula kwokuno: «Zeene, nga ku kahola-masiga, ngalenga mu kihugo kyoshi kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ku yikyo kyanya, ifula zooshi zeꞌMiisiri, zigaafwa. Yukwo kuyitwa, kugatondeerera ku fula yawe, we mwami, halinde ukuhisa ku fula yoꞌmuja-kazi úli mu shya ku lushyo. Kiri neꞌbitugwa íbikatangi butwa, nabyo bigaafwa. ");
INSERT INTO flr_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Mu kihugo kyoshi kyeꞌMiisiri, mugaaba ikimombo. Neꞌkimombo mwene yikyo, kitazindi ba ho, kitanâye ki be ho. ");
INSERT INTO flr_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","«Haliko, Abahisiraheeri boohe, ndaako kiri naꞌkabwa ákagabamokera, kandi iri kamokera ikitugwa kyabo. Kwokwo, lyo mugaamenya kwo nie Nahano, na kwo mbiisiri ulubibi ha kati kiinyu naꞌBahisiraheeri.» ");
INSERT INTO flr_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Musa anashubiza, ti: «Abatwali baawe booshi, bagayija imbere lyani, bananvukamire, iri banadeta: “Ugendage, maashi! Ugende na booshi bo muliriinwi.” Lyeryo, lyo ngalyoka mwo.» Musa anayami kuuduka imbere lya Faraho, akoli rakiiri bweneene. ");
INSERT INTO flr_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Nahano âli mali gwanwa abwira Musa: «Uyo Faraho, atagakutwaza, kinatume ibitangaaza byani bigakizi yushuuka i Miisiri.» ");
INSERT INTO flr_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Yibyo bitangaaza byoshi, kundu Musa na Harooni bâli kizi bigira imbere lya Faraho, haliko Nahano anakizi yumuusa umutima gwage. Uyo Faraho, atanahanguula Abahisiraheeri kwo balyoke mu kihugo kyage. ");
INSERT INTO flr_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Musa na Harooni, ikyanya bakaba bakiri mu kihugo kyeꞌMiisiri, Nahano anababwira: ");
INSERT INTO flr_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Imwinyu, guno mwezi, gwo gugaaba mwezi gwa mbere gwoꞌmwaka. ");
INSERT INTO flr_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","«Mubwire Abahisiraheeri booshi, kwo mu siku ikumi za guno mwezi, ngiisi mbaga iyabiire ikyanabuzi kiguma-kiguma. ");
INSERT INTO flr_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Iyo mbaga, iri yangaba itagakimala, iyibiike kuguma neꞌmbaga yoꞌmutuulani. Mukizi haruura abandu, munagere inyama zeꞌkyanabuzi, ukukulikirana na ngiisi kwoꞌmundu angalya. ");
INSERT INTO flr_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ikitugwa kyo mugatoola, kibe kipanga kyoꞌmwaka muguma, kinabe kizira kashembo. Yikyo kitugwa, kyangaba kiri kyanabuzi, kandi iri kyanahene. ");
INSERT INTO flr_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","«Yibyo bitugwa, mukizi bilanga, halinde ku siku ikumi na zina zoꞌmwezi. Ku lwolwo lusiku, Abahisiraheeri bakwiriiri babibaage, ku kyanya kyaꞌkabigingwe. ");
INSERT INTO flr_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ikyanya bagabibaaga, bakayabiire ku muko gwabyo, banaguhembeze ku mitondo yeꞌmiryango yeꞌnyumba zo bagabiliira mwo, banagubiike, na ku bihamambiro. ");
INSERT INTO flr_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","«Yizo nyama, baziyokye mu bwobwo bushigi, banaziliire imikate mizira saama, banalye naꞌkalaaja. ");
INSERT INTO flr_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Si mutazilye mbishi, mutanazideeke. Haliko, muziyokye. Muyokye itwe, neꞌbya mu nda, neꞌbirenge. ");
INSERT INTO flr_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Hatagirage inyama yo mugaasiga halinde shesheezi. Iri hali íyasigala, mugijigiivye. ");
INSERT INTO flr_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","«Ikyanya mugaazilya, mube mukoli kenyiiri, nga mukola mugagenda. Munabe mukoli yambiiti ibiraato, munafumbiiti neꞌngoni. Yizo nyama, mugazishulula-shulula, bwo iri Pasaka ya Nahano. ");
INSERT INTO flr_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«Mu bwobwo bushigi, ngalenga mu kihugo kyeꞌMiisiri, na nyite mweꞌfula zooshi, ziba za bandu, kandi iri zeꞌbitugwa. Nie Nahano, ngaahana imizimu yoshi yeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Yugwo muko, gugaaba kalangikizo koꞌkuyerekana kwo muli mu nyumba. Neꞌkyanya ngagubona, na nyami bambala. Mwehe, ikyanya ngaahana i Miisiri, ndaakyo kihano íkigamùhuma kwo. ");
INSERT INTO flr_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Yulwo lusiku, lugayami ba lwoꞌbukengeeze imwinyu, luganakizi ba lusiku lukulu lwa Nahano. Mugakizi lusimbaha imyaka neꞌmyakuula, halinde ku bibusi biinyu byoshi íbigaki yija. ");
INSERT INTO flr_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«Muhisagye isiku zirinda mugweti mugaalya imikate mizira saama. Noꞌlusiku lwa mbere lwa yizo zirinda, muhulusagye isaama yoshi mu nyumba ziinyu. Mu yizo siku, ngiisi yeshi úgaalya umukate úguli mweꞌsaama, akwiriiri atwibwe mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ku lusiku lwa mbere, mube noꞌmuhumaanano mutaluule. Na ku lusiku lwa kalinda, mube noꞌgundi. Mu yizo siku zombi, hatagirage umukolwa gwo mugaagira, gútali gwoꞌkulingaania ibyokulya naaho. ");
INSERT INTO flr_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Yulu lusiku lukulu lweꞌmikate mizira saama, mugakizi lusimbaha. Mukuba, lwolwo lusiku, lwo nꞌgamùshaaza kwo i Miisiri, ndeeko-ndeeko. Yulwo lusiku, abandu beꞌbibusi biinyu byoshi, bagakizi lusimbaha, halinde imyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","«Iyo mikate mizira saama, mugatondeera ukugilya mu kabigingwe koꞌlusiku lwiꞌkumi na zina zoꞌmwezi gwa mbere, halinde ukuhisa ku kabigingwe keꞌsiku makumi gabiri na luguma za gwogwo mwezi. ");
INSERT INTO flr_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mu yizo siku zirinda, hatagire mundu úgaki ba neꞌsaama mu nyumba yage, kundu angaba mwene akaaya, kandi iri kinyamahanga. Ngiisi úgaalya ibyokulya íbiri mweꞌsaama, akwiriiri atwibwe mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Iri mwangalya ibyokulya íbiri mweꞌsaama, mugaaba mwalya umuziro, kundu mwangaba mutuuziri hayi. Kwokwo, mu yizo siku, imikate yo mugakizi lya, ibe mizira saama.» ");
INSERT INTO flr_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Haaho, Musa anakuumania abashaaja booshi baꞌBahisiraheeri, anababwira: «Ngiisi muguma winyu, ukukulikirana neꞌmbaga yage, atoolage ikyanabuzi, anakibaage ku lusiku lukulu lweꞌPasaka. ");
INSERT INTO flr_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Umuko gwakyo, munagubiike mu mutanga. Munayabiire ibyasi byeꞌhisopo, munakizi bijabika mwo. Gulya muko, munagushangire ku mitondo na ku bihamambiro byeꞌmiryango yeꞌnyumba ziinyu. Bushigi bwa yulwo lusiku, hatagire mundu úgahulukira imbuga, bútazi kya. ");
INSERT INTO flr_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","«Nahano agakizi lenga mu kino kihugo, mu kuyita Abamiisiri. Haliko mwehe, agaabona imiko ku mitondo yeꞌnyumba ziinyu, na ku bihamambiro byazo, anakizi mùhinjuka. Hiꞌgulu lyeꞌyo miko, atagahanguula umuganda wage woꞌkuminika kwo ayingire mu nyumba ziinyu, mbu amùyite. ");
INSERT INTO flr_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","«Yago magambo go namùbwira, mukizi gasimbaha. Yulwo lubaaja, lugaaba lweꞌmwinyu, na lwaꞌbandu beꞌbibusi biinyu, halinde imyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Yulwo lusiku, ikyanya mugayingira mu kihugo kyo Nahano agamùheereza ku muhango, mukwiriiri mukizi lukulikira. ");
INSERT INTO flr_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","«Neꞌkyanya abaana biinyu bâye mùbuuze: “Yulu lusiku lukulu, umugeeza gwalwo biri biki?” ");
INSERT INTO flr_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Mugakizi bashuvya: “Yiki kitugwa, liri ituulo lyeꞌPasaka, lyo tuli mu tanga imwa Nahano. Mukuba, ikyanya Nahano akayita Abamiisiri mu kihugo kyabo, anahinjuka ku nyumba ziitu twe Bahisiraheeri.”» Ikyanya Musa akayusa ukudeta, lyeryo Abahisiraheeri banayinika amatwe halinde haashi, banayikumba Nahano. ");
INSERT INTO flr_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Yibyo byoshi byo Nahano akabwira Musa na Harooni, Abahisiraheeri banagendi bigira. ");
INSERT INTO flr_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Iri kakaba kahola-masiga, Nahano anayita ifula zooshi za mu kirya kihugo kyeꞌMiisiri. Zirya fula zo akayita, zikatondeerera ku fula ya mwami, kundu âli kizi bwatala ku kitumbi kyeꞌkyami. Zanahisa na ku fula za ábâli lashirwi mu nyumba zeꞌmbohe. Kiri neꞌbitugwa, akayita ibyana byabyo bya mbere. ");
INSERT INTO flr_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Mu bwobwo bushigi, uyo mwami naꞌbatwali baage booshi, kiri naꞌbandi bandu baage, banavyuka. Ndaayo kiri neꞌnyumba nguma ítakafwa mwoꞌmundu. Kyanatuma mu kirya kihugo kyoshi kyeꞌMiisiri, mugayijula ikimombo kya kahebuuza. ");
INSERT INTO flr_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Mu bwobwo bushigi, uyo Faraho anahamagala Musa na Harooni, anababwira: «Yimukagi! Mwe naꞌbiinyu Bahisiraheeri, mulyokage mu bandu baani. Mugendi yikumba Nahano, nga ngiisi kwo mukambuuna. ");
INSERT INTO flr_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Neꞌkyanya mugagenda, mutwale kiri neꞌbitugwa biinyu. Kiri na naani, mukakizi mbuunira, halinde Rurema angashaanire.» ");
INSERT INTO flr_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Balya Bamiisiri, banatondeera ukukunguula Abahisiraheeri kwo balyokage yaho duba, banakizi deta: «Iri mutangashaaga hano, tweshi tugaahera.» ");
INSERT INTO flr_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Yabo Bahisiraheeri, banayabiira amalobe gaabo go bakalingaania buzira saama, kuguma neꞌbirugu byabo byoꞌkulingaaniza mweꞌmikate. Yibyo byoshi, banabiboha, banabibiika ha lutugo. ");
INSERT INTO flr_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Banagira nga kwo Musa âli mali gwanwa ababwira, mu kuhuuna Abamiisiri ibirugu íbikatulwa mu harija, na mu nooro. Banabahuuna kiri neꞌbyambalwa. ");
INSERT INTO flr_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Nahano anagira Abamiisiri bakunde Abahisiraheeri. Neꞌkyanya bakahuuna Abamiisiri yibyo bindu, banakizi baheereza byo. Kwokwo, kwaꞌBahisiraheeri bakalonga ibindu byabo. ");
INSERT INTO flr_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Lyeryo, Abahisiraheeri banalyokaga i Rameseesi, banagenda halinde i Sukooti. Bâli hisiri nga bashosi bihumbi magana galindatu, buzira kuharuura abakazi naꞌbaana. ");
INSERT INTO flr_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Bâli riiri kuguma naꞌbandi bandu bingi ábakagenda babakulikiiri. Bâli sholiiri inguuli zeꞌbitugwa, ibibuzi neꞌngaavu. ");
INSERT INTO flr_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ikyanya Abahisiraheeri bakalyoka i Miisiri, bâli kola neꞌngungu, kyanatuma bataki teekera indanda. Si bakatwala naaho galya malobe mazira saama, gira bakizi galingaania mweꞌbitumbula bizira saama. ");
INSERT INTO flr_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Imyaka yoshi yaꞌBahisiraheeri bakabeera mu kihugo kyeꞌMiisiri, yâli hisiri myaka magana gana na makumi gashatu. ");
INSERT INTO flr_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ku lwolwo lusiku lwoꞌkuhisa imyaka magana gana na makumi gashatu, abandu booshi ba Nahano bakalyoka mu kihugo kyeꞌMiisiri, ngiisi bandu mu ndeeko yabo. ");
INSERT INTO flr_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mu bwobwo bushigi, Nahano akalaliira, mu kulyosa Abahisiraheeri mu kihugo kyeꞌMiisiri. Kyo kitumiri Abahisiraheeri booshi bakwaniini bakizi bukengeera, banakizi simbaha Nahano, halinde ukuhisa mu bibusi byoshi. ");
INSERT INTO flr_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Nahano anabwira Musa na Harooni: «Ikyanya mugakizi lya ibyokulya byeꞌPasaka, imaaja zoꞌkukulikira zo zeezi: Ngiisi útali Muhisiraheeri, atakolwe kwo akizi bilya. ");
INSERT INTO flr_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Haliko umuja ye mukagula, anabe keera mwamútenguula, yeki ahangwirwi ukukizi bilya kwo. ");
INSERT INTO flr_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Si ikinyamahanga, na úli mu kolerana hiꞌgulu lyoꞌkuhembwa boohe, batakwiriiri ukukizi bilya kwo. ");
INSERT INTO flr_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","«Ikyanabuzi kyeꞌPasaka, kigakizi liibirwa mu nyumba nguma. Inyama zaakyo, zigaliibirwa mwomwo. Hatanagire kiri neꞌnyama nguma ígahulusibwa, mbu itwalwe imbuga. Naꞌmavuha gaayo, hatagire kiri neꞌliguma lyago írigavunwa. ");
INSERT INTO flr_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Yulwo lusiku lukulu, Abahisiraheeri booshi bakwiriiri bakizi lushambaalira. ");
INSERT INTO flr_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","«Ngiisi yeshi útali Muhisiraheeri ye mutuliinwi, iri angasiima kwo naye mushambaalire kuguma ku lusiku lukulu lweꞌPasaka ya Nahano, akwiriiri atee tenguula abashosi booshi ba mu nyumba yage. Lyoki uyo mundu akabuli haruurwa kwo naye akola mutuulaga, anahanguulwe kwo naye alye mwiꞌyo ngoome. Si ngiisi útazi tenguulwa, yehe atakolwe mbu abilye kwo. ");
INSERT INTO flr_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Yulwo lubaaja, luloziri booshi, aba Muhisiraheeri nirizina, kandi iri binyamahanga íbituuziri mu kati kiinyu.» ");
INSERT INTO flr_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Yulwo lubaaja, ikyanya Nahano akalubwira Musa na Harooni, Abahisiraheeri booshi banakizi lusimbaha. ");
INSERT INTO flr_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ku lwolwo lusiku, Nahano akalyosa Abahisiraheeri mu kihugo kyeꞌMiisiri, ndeeko-ndeeko. ");
INSERT INTO flr_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nahano anashubi bwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Undaluulire ifula zooshi zaꞌBahisiraheeri. Mukuba, ngiisi fula yoꞌMuhisiraheeri, kiri neꞌbitugwa íbyabutwa ubwa mbere, byoshi biri bindu byani.» ");
INSERT INTO flr_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Musa anabwira Abahisiraheeri: «Yulu lusiku lukulu, mukizi lukengeera. Mukuba, ku lwolwo lusiku, lyo mukashaaga mu buja, mwanalyoka mu kihugo kyeꞌMiisiri. Nahano akamùlyosa i Miisiri ku bushobozi bwage. (Mukengeere, kwo íbiri mweꞌsaama, mutakolwe kwo mwabilya.) ");
INSERT INTO flr_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","«Ulusiku lwa zeene, mu mwezi úguli mu detwa Habibu, lyo mugweti mugalyoka i Miisiri. ");
INSERT INTO flr_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ku yukwo, lwolu lusiku, mu mwezi nga gwoguno, mukwiriiri mukizi lukengeera. Mukizi lukengeera ku kyanya Nahano agamùhisa mu kihugo kyo akalagaania bashokuluza biinyu, ikihugo íkiyeziri mwaꞌmata, noꞌbuuki. Yikyo kihugo, kikiri kyaꞌBakaanani, naꞌBahiti, naꞌBahamoori, naꞌBahivi, naꞌBayebuusi. ");
INSERT INTO flr_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Mugaamala isiku zirinda mugweti mugaalya imikate mizira saama. Na ku lusiku lwa kalinda, mugaagira ulusiku lukulu hiꞌgulu lyoꞌkushambaalira Nahano. ");
INSERT INTO flr_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","«Mu yizo siku zirinda, mugakizi lya imikate mizira saama. Si mikate íri mweꞌsaama yohe, hatagire igaboneka mu kati kiinyu, kiri na mu kihugo kiinyu kyoshi. ");
INSERT INTO flr_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","«Ku lwolwo lusiku, mugakizi ganuulira abaana biinyu ngiisi kwo Nahano akamùgirira mu kumùlyosa mu kihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Yulwo lusiku, kigaaba kimenyeeso kyoꞌkukizi mùkengeeza. Yikyo kimenyeeso, kigaaba nga kibiisirwi ku maboko giinyu, na ku malanga giinyu. Kwokwo, mukizi kengeera ukudeta amigirizo ga Nahano. Mukuba, akamùlyosa mu kihugo kyeꞌMiisiri ku bushobozi bwage bwaꞌkahebuuza. ");
INSERT INTO flr_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Kwokwo, yulwo lusiku, mukwiriiri mukizi lusimbaha ngiisi mwaka, ku gwogwo mwezi.» ");
INSERT INTO flr_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","12","Musa anagenderera ukubwira abandu: «Ikyanya Nahano agamùhisa mu kihugo kyeꞌKaanani, anamùheereze kyo, mukwiriiri mukizi mútangira abaana biinyu beꞌfula boꞌbutabana. Biri nga kwo keera akabiika indahiro imbere lya bashokuluza biinyu. Kiri neꞌbyana bya mbere byeꞌbitugwa biinyu, bigaaba biri bindu byage. ");
INSERT INTO flr_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Haliko umwana wa mbere wa punda, ugamúguluula neꞌkyanabuzi. Neꞌri utangamúguluula, umúyite, mu kumúnyoola igosi. Na mu bagala baawe, ngiisi fula, ugiguluule. ");
INSERT INTO flr_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","«Mu siku ízigayija, iri umwana wawe angakubuuza hiꞌgulu lya yiri igambo, unamúshuvye: “Nahano akakoleesa ubushobozi bwage bwaꞌkahebuuza, mu kutulyosa mu buja bweꞌkihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Mukuba, ikyanya Faraho akatuhangirira ku bukayu, mbu tutalyokage mu kihugo kyage, Nahano anayita ifula zooshi za mu Miisiri, ziba zaꞌbandu kandi iri zeꞌbitugwa. Kyo kitumiri ngweti ngatangira Nahano ituulo lyeꞌbyana bya mbere byeꞌbitugwa byani. Si ifula ya mu mbaga yani, ndi mu giguluula.” ");
INSERT INTO flr_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","«Yiri igambo, ligakizi ba nga kimenyeeso ku maboko gaawe, kiri na ku malanga gaawe. Ligaaba nga kihunika kyoꞌkukengeeza kwo Nahano akatulyosa mu kihugo kyeꞌMiisiri ku bushobozi bwage bwaꞌkahebuuza.» ");
INSERT INTO flr_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ikyanya Faraho akahanguula Abahisiraheeri kwo bagende, Rurema atanabaleeza mu njira ya mu kihugo kyeꞌBufirisiti, kundu yo yâli nyoofi. Mukuba, Rurema akadeta: «Yaba bandu, iri izibo lyangabakayira, hali ikyanya bangahindula imitono yabo, banagalukire i Miisiri.» ");
INSERT INTO flr_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ku yukwo, anabaleeza mu njira yoꞌkusooka mwiꞌshamba, irya íleeziri iwa Nyaaja Ndukula. Kundu kwokwo, ikyanya bakalyoka mu kihugo kyeꞌMiisiri, bâli kola ibiringiini ukugira izibo. ");
INSERT INTO flr_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ku yikyo kyanya, Musa anatwala neꞌmigongolo ya Yusefu. Mukuba, Yusefu âli mali gwanwa abikiisa Abahisiraheeri indahiro, ti: «Ku kyanya Rurema agamùtabaala, anamùlyose mu kino kihugo, mukwiriiri mutwale neꞌmigongolo yani.» ");
INSERT INTO flr_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Kwokwo, iri Abahisiraheeri bakalyoka i Sukooti, banashumbika i Hetamu, ha butambi liꞌshamba. ");
INSERT INTO flr_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ku kyanya kya mwiꞌzuuba, Nahano âli kizi shokola injira, ali mu nguliro yeꞌkibungu. Neꞌkyanya kya bushigi, âli kizi ba mu nguliro yoꞌmuliro, gira ikizi bamolekera. Kwokwo, banalonga ukugenderera noꞌlugeezi lwabo, muba mwiꞌzuuba, kandi iri mu bushigi. ");
INSERT INTO flr_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Iyo nguliro yoꞌmuliro, na yikyo kibungu, byâli yamiri bibasholiiri mwiꞌzuuba, na mu bushigi. ");
INSERT INTO flr_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Iri hakatama, Nahano anadeta: ");
INSERT INTO flr_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«E Musa, ubwire Abahisiraheeri kwo bagalukire inyuma, bashumbike hoofi lyeꞌPi-Hahirooti, iwa Nyaaja Ndukula. (Yaho, hali ha kati kaꞌkaaya Migidoli neꞌyo nyaaja, ha mbere lyaꞌBaali-Sefooni.) ");
INSERT INTO flr_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","«Kwokwo, lyo Faraho ayihenda, mbu: “Ishamba likoli bahamiiri, kyo kitumiri bagweti bagalidalamba-dalamba mwo”. ");
INSERT INTO flr_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ngashubi yumuusa umutima gwa Faraho, halinde anamùbingirize. Kundu kwokwo, ngamúshereeza, kuguma naꞌbasirikaani baage, halinde lyo ndonga ubulangashane. Kwokwo, lyaꞌBamiisiri bagaamenya kwo nie Nahano.» Rurema, mbu ayuse ukudeta kwokwo, Abahisiraheeri banagakulikira inyuma. ");
INSERT INTO flr_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Uyo mwami weꞌMiisiri, iri akayuvwa kwaꞌBahisiraheeri bamútibita, anayishuhiza, kuguma naꞌbatwali baage, banadeta: «E balya, makagi gano twagira? Si twaleka Abahisiraheeri bagendage, bataganaki tukolera!» ");
INSERT INTO flr_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Lyeryo, analingikania igaare lyage liꞌzibo, kuguma naꞌbasirikaani baage. ");
INSERT INTO flr_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Anatwala naꞌgandi magaare miija magana galindatu, ágali mu kunguza izibo. Anatwala naꞌgandi magaare mingi giꞌzibo, kuguma naꞌbasirikaani boꞌkukizi garongoora. ");
INSERT INTO flr_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yabo Bahisiraheeri bakalyoka i Miisiri, bagweti bagayikangaata. Na bwo Nahano âli mali yumuusa umutima gwa Faraho, anamúgira kwo abakulikire. ");
INSERT INTO flr_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Abamiisiri banagendaga bakulikiiri Abahisiraheeri, bali neꞌfwarasi zaabo, kuguma na ábâli kizi zigendera kwo. Bâli riiri naꞌmagaare giꞌzibo, kiri na ábali mu gendera ku fwarasi. Banababingiriza, banabahumaana ho bâli shumbisiri ku butambi bweꞌnyaaja, hoofi neꞌPi-Hahirooti, mu kulola i Baali-Sefooni. ");
INSERT INTO flr_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Yabo Bahisiraheeri, mbu bayinamulage amasu, banalangiiza ulya mwami weꞌMiisiri, naꞌbasirikaani baage, keera babayegeera. Banashenguka bweneene, banatondeeza ukulirira Nahano kwiꞌzu lihamu. ");
INSERT INTO flr_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Balya Bahisiraheeri, banatondeera ukulongooza Musa: «Ewe! Kituma kiki watuleeta hano? Ka mbu bwo mu Miisiri, ndaazo shinda ízâli riiri mwo? Aaho! Maki gano watugirira, mu kutuleeta hano? Si tugayiji herera mwiꞌshamba! ");
INSERT INTO flr_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ikyanya twâli ki riiri i Miisiri, ka tutakakubwira-bwira kwo utusige yo, gira tugenderere ukukizi kolera Abamiisiri? Ee! Kulya twâli kizi bakolera, kwo kukulu ukuhima kuno twamu yiji herera mwiꞌshamba.» ");
INSERT INTO flr_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Musa anabashuvya: «Mutayobohe, si mutuuze. Zeene lyo na zeene, mugaabona ngiisi kwo Nahano agamùkiza. Yaba Bamiisiri bo mubwini buno, mutâye ki babone. ");
INSERT INTO flr_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Nahano yenyene agamùlwira. Kwokwo, mukwiriiri mutuuze naaho.» ");
INSERT INTO flr_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Lyeryo, Nahano anabwira Musa: «Kituma kikagi Abahisiraheeri bagweti bagandirira? Ubabwire kwo bagenderere noꞌlugeezi. ");
INSERT INTO flr_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Iyo ngoni yo ufumbiiti, ugishonge ku nyaaja, gira ibunduuke mwo kubiri. Kwokwo, lyaꞌBahisiraheeri bagalonga ubulyo bwoꞌkulenga áhakamiri. ");
INSERT INTO flr_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","«Yaba Bamiisiri, ngagenderera ukuyumuusa imitima yabo, halinde bamùkulikire mwiꞌyi nyaaja. Haaho, ngashereeza uyu mwami, naꞌbasirikaani baage, na ábali mu gendera ku fwarasi, kiri naꞌmagaare gaabo giꞌzibo. Kwokwo, lyo ngahuuzibwa. ");
INSERT INTO flr_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ee! Ikyanya ngashereeza uyu mwami weꞌMiisiri kuguma naꞌmagaare gaage giꞌzibo, kiri na ábali mu gendera ku fwarasi, lyo ngalonga ukuhuuzibwa bweneene. Lyeryo, lyaꞌBamiisiri bagaamenya kwo nie Nahano.» ");
INSERT INTO flr_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Haaho, umuganda wa Rurema úwâli kizi rongoora Abahisiraheeri, anagalukira inyuma lyabo. Kiri neꞌrya nguliro yeꞌkibungu nayo, yanashaaga imbere lyabo, yanagendi beera inyuma. ");
INSERT INTO flr_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Kirya kibungu kyanakizi siika Abamiisiri naꞌBahisiraheeri. Mu bushigi bwoshi, kyanakizi molekera Abahisiraheeri. Si Abamiisiri boohe, kyanakizi bateera ikihulu. Yibyo biso byombi, bitanayegeerana. ");
INSERT INTO flr_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ha nyuma, Musa anagololera ukuboko kwage ku nyaaja. Nahano analeeta ikihuhuuta ukulyoka uluhande lweꞌsheere, kyanakizi huusa bukayu, halinde shesheezi. Irya nyaaja yanabunduuka mwo kubiri, halinde haashi hanakama. ");
INSERT INTO flr_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Neꞌkyanya Abahisiraheeri bakayingira áhashuba amiiji, banahajabuka hakoli kamiri, banakizi lenga ha kati keꞌbikombo bibiri byaꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Balya Bamiisiri, iri bakabona kwokwo, banayami genda babakulikiiri mu nyaaja. Bâli riiri kuguma neꞌfwarasi zaabo, naꞌmagaare gaabo giꞌzibo, na balya booshi ábali mu gendera ku fwarasi. ");
INSERT INTO flr_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Nahano âli ki riiri mwiꞌrya nguliro yoꞌmuliro, na mu yikyo kibungu. Iri hakaba ku mutwezi, Nahano anabonaga abasirikaani booshi baꞌBamiisiri, anayami babuligania. ");
INSERT INTO flr_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Yago magaare, Nahano anakizi hangatiiza amapine gaago. Kyanatuma gagakizi genda ku makayu, banatondeeza ukuyamiza: «E balya, yaba Bahisiraheeri, tubatibite. Si Nahano yenyene agweti agabalwira!» ");
INSERT INTO flr_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Nahano anabwira Musa: «Ushubi gololera ukuboko kwawe kwiꞌyi nyaaja, halinde amiiji gashubi shubaana. Kwokwo, lyo gagayami bindikira Abamiisiri, kuguma naꞌmagaare gaabo, kiri na ábali mu gendera ku fwarasi.» ");
INSERT INTO flr_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kwokwo, Musa anagololera ukuboko kwage kwiꞌyo nyaaja. Neꞌri hakaba shesheezi kare-kare, yanashubi shubaana, nga kwo yâli tuula. Balya Bamiisiri, banakizi gira mbu batibite mu nyaaja. Haliko Nahano anakizi shubi batundira mwo. ");
INSERT INTO flr_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Galya miiji, ganayami bindikira amagaare gaabo giꞌzibo, kuguma na ábâli kizi gendera ku fwarasi. Kundu abasirikaani ba Faraho bâli kulikiiri Abahisiraheeri, haliko balya booshi banakamira mwomwo mu nyaaja. Ndaanaye kiri noꞌmuguma wabo úkafuuka. ");
INSERT INTO flr_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Haliko Abahisiraheeri boohe, bâli mali jabuka áhakamiri mu kati keꞌnyaaja, ha kati keꞌbikombo bibiri byaꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Yulwo lusiku, lyo Nahano akakiza Abahisiraheeri mu maboko gaꞌBamiisiri. Ubuzinda, balya Bahisiraheeri banayiji bona ibirunda byaꞌBamiisiri bilambamiri ku butambi bweꞌnyaaja. ");
INSERT INTO flr_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Balya Bahisiraheeri, iri bakabona ngiisi kwo Nahano akakoleesa ubushobozi bwage, mu kubindikira Abamiisiri, banamúyoboha, banamúbiika kwoꞌmulangaaliro. Kiri na Musa, umukozi wage, naye kwakundi, banamúbiika kwoꞌmulangaaliro. ");
INSERT INTO flr_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Lyeryo Musa, naꞌbaabo Bahisiraheeri booshi, banayimbira Nahano yulu lwimbo: «Ngayimbira Nahano, bwo ye kwaniini ukuhuuzibwa bweneene. Ifwarasi na ábali mu zigendera kwo, keera abakamiza mu nyaaja. ");
INSERT INTO flr_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","«Nahano ye misi yani. Ye nganakizi yimbira inyimbo zoꞌbwivuge. Yehe ye Rurema wani, ye na Rurema wa daata. Kwokwo, ngakizi múyivuga, na ngizi múhuuza. ");
INSERT INTO flr_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Nahano ye ndwani. Ee! Iziina lyage, ye Nahano. ");
INSERT INTO flr_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","«Nahano keera abindikira abasirikaani ba Faraho mu Nyaaja Ndukula. Booshi naꞌbakulu baabo bakamira mwo, kuguma naꞌmagaare. ");
INSERT INTO flr_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ee! Amabenga gaꞌmiiji keera gababindikira, banaholobera ngiꞌbuye, halinde banakamira mu nyaaja. ");
INSERT INTO flr_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«E Nahano, ukuboko kwawe kweꞌlulyo, keera kwakola ku misi ya kahebuuza. Na ku njira yakwo, keera wasivya abagoma baawe. ");
INSERT INTO flr_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ku bushobozi bwawe bwaꞌkahebuuza, watindimaza abagoma baawe. Na ku buraakari bwawe, uli mu bajigiivya nga byula. ");
INSERT INTO flr_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Umuuka gukalyoka mu mazuulu gaawe, amiiji ganayihonga haguma. Imidunda, yanayimanga nga bikombo. Amabenga ga mu nyaaja, ganayuma. ");
INSERT INTO flr_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Uyo mugoma ashuba mu yihaya, ti: “Ngabakulikira, halinde mbabindike. Na ngabe neꞌbindu byabo, halinde inyoota imale. Ee! Tugayomola ingooti ziitu, halinde tunabaminike naꞌmaboko giitu.” ");
INSERT INTO flr_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kundu bakadeta kwokwo, wanafuuha umuuka, inyaaja yanababwikira. Banaholobera mwo nga kyuma kyoꞌrusasi, amiiji ganababindikira. ");
INSERT INTO flr_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","«E Nahano, mu biri mu yikumbwa, nyandi úli nga wehe? Nyandi úli mwoꞌbweru bwaꞌkahebuuza? Nyandi úli mu yobohwa mu bulangashane? Nyandi úli mu gira ibitangaaza mwene yibi? ");
INSERT INTO flr_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ikyanya ukagolola ukuboko kwawe kweꞌlulyo, ikihugo kyanamira abagoma biitu. ");
INSERT INTO flr_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","«Urukundo lwawe, lutahiiti imbeka. Na ku njira yalwo, ugarongoora abandu baawe. Keera wabaguluula. Na ku bushobozi bwawe, ugabahisa ahandu haawe heeru. ");
INSERT INTO flr_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ikyanya ibinyamahanga bigayuvwa, bigajuguma, binafololokwe. Abafirisiti bagagwatwa noꞌlushunguti. ");
INSERT INTO flr_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Abatwali beꞌHedoomu, bagayoboha bweneene. Abatungwa beꞌMohabu, bagalenga mweꞌkinyukura. Abatuulaga booshi beꞌKaanani, imitima yabo igashenguka. ");
INSERT INTO flr_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bagagwatwa neꞌkyoba, noꞌlushunguti. Yabo bandu, ikyanya bagaabona ubushobozi bwawe, bagaaba munyerere ngiꞌbuye, halinde abandu baawe balenge. Mukuba, keera wabaguluula. ");
INSERT INTO flr_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","E Nahano, ugabaleeta, bayiji tuula ku mugazi gwawe. Yaho handu, ho wenyene ugatuula. Haaho, ho ukabiika inyumba yawe nyeeru. Ukanagiyubaka naꞌmaboko gaawe. ");
INSERT INTO flr_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","E Nahano, uyamiri uli mu twala, halinde imyaka neꞌmyakuula.» ");
INSERT INTO flr_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Kwokwo, iri abasirikaani ba Faraho bakayitundira mu nyaaja, bali naꞌmagaare giꞌzibo goꞌkukululwa neꞌfwarasi, na ábâli kizi zigendera kwo, haaho-haaho Nahano anashubaania inyaaja, yanababindikira booshi. Si Abahisiraheeri boohe, bâli mali lenga mu nyaaja, áhakamiri. ");
INSERT INTO flr_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Lyeryo, umuleevi Miryamu, mwali wa Harooni, anayabiira iminjegere. Abaabo bakazi, nabo banamúgombera neꞌgindi, banatondeera ukukina. ");
INSERT INTO flr_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miryamu anatondeera ukubayimbira: «Muyimbire Nahano, úli mu kizi huuzibwa bweneene. Ifwarasi na ábâli kizi zigendera kwo, abakamiza mu nyaaja.» ");
INSERT INTO flr_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Ikyanya Musa akalyosa Abahisiraheeri heꞌyo Nyaaja Ndukula, anabarongoora halinde mwiꞌshamba lyeꞌShuuri. Banahisa isiku zishatu, bali mu lyeryo ishamba, ndaanago miiji go bakalonga. ");
INSERT INTO flr_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Neꞌri bakahika áhali mu buuzibwa Mara, banagwana haꞌmiiji. Haliko, gâli riiri malulu, kyanatuma batagaganywa. (Kyo kikatuma yaho handu hali mu buuzibwa Mara, kuli kudeta: bululu.) ");
INSERT INTO flr_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Balya bandu, ikyanya bakabulirwa naꞌmiiji, booshi kuguma banatondeera ukuyidodombera Musa, ti: «Ewe! Bikagi leero byo tugaanywa?» ");
INSERT INTO flr_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Ikyanya Musa akatabaaza Nahano, anamúyereka itavi lyeꞌkiti. Lirya itavi, Musa analiyabiira. Neꞌri akalitibulira mu miiji, ganayami luluuka. Iri Abahisiraheeri bakaba bakiri i Mara, Nahano anabaheereza imaaja, bamenye ngiisi kwo akakyula. ");
INSERT INTO flr_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Anadeta: «Niehe nie Nahano, Rurema winyu. Na ndi nie mu mùkiza. Kwokwo, iri mwangakizi yuvwiriza izu lyani ku bwitonde, ndagamùleetera ikiija, kundu nꞌgakireetera Abamiisiri. Ku yukwo, ikyanya ngakizi mùbwira igambo, mukwiriiri mukizi ndega amatwiri, munakizi gira íbikwaniini imbere lyani. Imaaja zaani, mukizi zisimbaha, nga ngiisi kwo nakyula.» ");
INSERT INTO flr_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ha nyuma, Abahisiraheeri banahika i Herimu. Na yaho, hâli riiri utudota ikumi na tubiri, kuguma neꞌbigazi makumi galinda, banashumbika hoofi naꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ha nyuma, Abahisiraheeri booshi banalyoka yaho i Herimu, banagenderera bwija-bwija, halinde banahika mwiꞌshamba lyeꞌSiini, ha kati keꞌHerimu, noꞌmugazi Sinaayi. Kuli kudeta kwo bakamala umwezi gwoshi, ukushaagira ku lusiku lwo bakayimuka kwo mu kihugo kyeꞌMiisiri, halinde ukuhika i Siini. ");
INSERT INTO flr_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Yabo Bahisiraheeri, ikyanya bâli riiri mwiꞌshamba, booshi banakizi yidodombera Musa na Harooni, ti: ");
INSERT INTO flr_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","«Bwangabiiri bwija, Nahano atuyitire mu kihugo kyeꞌMiisiri. Iyo munda, twâli riiri neꞌbirugu íbiyijwiri inyama, twanâli kizi lya ngiisi byo tuloziizi. Si buno, mukatuleeta mu yiri ishamba, gira tweshi tuyiji herera mwo niꞌshali.» ");
INSERT INTO flr_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Kwokwo, Nahano anabwira Musa: «Yaba bandu, ngabatibulira imikate ukulyoka mwiꞌgulu. Ngiisi shesheezi, bagakizi toola imikate yo bagaalya ku lwolwo lusiku. Kwokwo, lyo ngabagera, ndonge ukumenya iri bangakulikira imaaja zaani, kandi iri nanga. ");
INSERT INTO flr_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Haliko, ku lusiku lwa kalindatu, bakizi kuumania ibyokulya byo bagaalya ku siku zibiri.» ");
INSERT INTO flr_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","7","Musa na Harooni, banabwira Abahisiraheeri booshi: «Nahano, akoli yuvwiti ngiisi kwo mugweti mugamúyidodombera. Aaho! Kabigingwe, lyo mugaamenya kwo yenyene ye kamùlyosa mu kihugo kyeꞌMiisiri. Na kusheezi shesheezi, mugaabona ubulangashane bwage. Si twehe tuli nga banyandi, halinde mwangakizi tuyidodombera? ");
INSERT INTO flr_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","«Mu kabigingwe, Nahano agamùheereza inyama, munazilye. Na shesheezi, anamùheereze neꞌmikate, halinde mukizi lya, munahaagage. Mukuba, akoli yuvwiti ngiisi kwo mugweti mugamúyidodombera. Ee! Tutali twe mugweti mugayidodombera. Si twenyene tutali kindu. Haliko, mugweti mugayidodombera Nahano yenyene.» ");
INSERT INTO flr_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ha nyuma, Musa anabwira Harooni: «Balya Bahisiraheeri, ubabwirage booshi kwo bakuumane imbere lya Nahano. Irya midodombo yabo, keera agiyuvwa.» ");
INSERT INTO flr_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Balya Bahisiraheeri booshi, iri Harooni akaba aki gweti agabaganuulira, banalangiiza mwiꞌshamba, banabona ubulangashane bwa Nahano mu bibungu. ");
INSERT INTO flr_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nahano anabwira Musa: ");
INSERT INTO flr_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Keera nayuvwa ngiisi kwo bagweti bagayidodomba. Ku yukwo, ubabwire kwo kabigingwe, bagaalya inyama. Na shesheezi bagaalya imikate, halinde banahaage. Haaho, lyo mugaamenya kwo nie Nahano, Rurema winyu.» ");
INSERT INTO flr_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Iri kakaba kakola kabigingwe, yaho bâli shumbisiri, hanayija inguuli zeꞌngware. Yizo ngware, zanabwikira hooshi ho bâli shumbisiri. Neꞌri hakaba shesheezi, indara yanagwa yaho hooshi. ");
INSERT INTO flr_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Irya ndara, iri ikatamuruka yaho mwiꞌshamba, hanaboneka ibindu byeru bihwahwatule, biri nga mikate. ");
INSERT INTO flr_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Abahisiraheeri, mbu babone kwokwo, banasoomerwa, banabuuzania: «Biki yibi?» Mukuba, batâli biyiji. Musa anababwira: «Yugu, guli mukate gwo Nahano amùheereza, gira mukizi longa byo mugaalya.» ");
INSERT INTO flr_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Nahano akahamuliza, ti: «Ngiisi muguma winyu akizi kuumania ibyokulya nga kwo aloziizi. Ngiisi muguma mu mbaga yinyu, mukizi kuumania ibilo bibiri-bibiri.» ");
INSERT INTO flr_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Yabo Bahisiraheeri, ngiisi byo bakabwirwa, banabikulikira. Baguma baabo, banakizi kuumania bingi. Naꞌbandi, banakizi kuumania biniini. ");
INSERT INTO flr_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Kundu kwokwo, ikyanya bakabibiika ku lugero, ngiisi úkakuumania bingi, bitakataluka ulugero. Na ngiisi úkakuumania biniini naye, ndaabyo byo akaniihirwa kwo. Mukuba, ngiisi mundu âli kizi kuumania íbimúkwiriiri. ");
INSERT INTO flr_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kwokwo, Musa anababwira: «Birya byokulya, hatagire mundu úgabilaaza kwo.» ");
INSERT INTO flr_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kundu Musa akabakengula kwokwo, haliko baguma baabo batanamútwaza. Yabo bandu, banabilaaza kwo, banayiji gwana keera byabola, binakola mu shaaga mweꞌmivuuzi. Yabo bandu, Musa anabarakarira bweneene. ");
INSERT INTO flr_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kwokwo, ngiisi shesheezi, ngiisi mundu âli kizi kuumania ibyokulya, ukukulikirana niꞌgoorwa lyage. Neꞌkyanya izuuba lyâli kizi ba keera lyadaruula, binajongoloke. ");
INSERT INTO flr_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Ku ngiisi lusiku lwa kalindatu, yabo Bahisiraheeri bâli kizi kuumania ubugira kabiri. Kuli kudeta kwo ngiisi mundu âli kizi kuumania ibilo bina-bina. Yibyo byoshi byo bâli kizi gira, abashaaja baꞌBahisiraheeri banagendere Musa, banamúganuulire byo. ");
INSERT INTO flr_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Musa anabashuvya: «Ulubaaja lwa Nahano lwo lwolu: Kusheezi, luli lusiku lwoꞌkuluhuuka. Mukuba, iri Sabaato, lunatalwirwi imwa Nahano. Ku yukwo, ibyokulya biinyu, mugendi bideeka, kandi iri kubihyusa. Na íbigasigala, mubibiike, mukabilye kusheezi.» ");
INSERT INTO flr_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kwokwo, yibyo byokulya, banabisiga halinde shesheezi, nga kwo Musa akababwira. Neꞌri bukakya, banabigwana bitazi gaga, bitanazi ba mweꞌmivuuzi. ");
INSERT INTO flr_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Musa anashubi babwira: «Yibyo byokulya íbyalaala, mubilye. Mukuba, zeene, iri Sabaato ya Nahano, ndaanabyo byokulya byo mugalonga imbuga. ");
INSERT INTO flr_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Yibi byokulya, mugakizi bikuumania mu siku ndatu. Haliko ulusiku lwa kalinda, mutagakizi bilonga, bwo luli Sabaato ya Nahano.» ");
INSERT INTO flr_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kundu Musa akadeta kwokwo, haliko ku lusiku lwa kalinda, bandu baguma banahuluka, gira bagendi looza ibyokulya, batanabilonga. ");
INSERT INTO flr_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Haaho, Nahano anabwira Musa: «Zirya maaja zaani, naꞌmategeko gaazo, mugakizi bihaasa-haasa kwo halinde mangoki? ");
INSERT INTO flr_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Aaho! Mumenye bwija, kwo nie Nahano. Nie kamùheereza ulusiku lweꞌSabaato. Kyo kitumiri ngiisi lusiku lwa kalindatu ndi mu mùheereza ibyokulya byeꞌsiku zibiri. Ngiisi mundu akwiriiri akizi beera mu nyumba yage, atakizi huluka mwo.» ");
INSERT INTO flr_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kwokwo, ku ngiisi lusiku lwa kalinda, abandu banakizi luhuuka. ");
INSERT INTO flr_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Yibyo byokulya, Abahisiraheeri banabiyinika iziina Mana, (kuli kudeta: biki yibi?) Byâli riiri nga mbuto zaꞌmahemba meeru. Byanâli kizi moteera nga mukate muhembeze kwoꞌbuuki. ");
INSERT INTO flr_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Musa anashubi babwira: «Ulubaaja lwo Nahano amùheereza, lwo lwolu: Iyo mana, muyabiire ibilo bibiri, munabisingule, bukizi ba bukengeeze imwaꞌbandu beꞌbibusi biinyu íbigaki yija. Kwokwo, abaana ba mu makondo giinyu, bakizi bona ibyokulya byo nâli kizi mùyigusa mwo mwiꞌshamba, ku kyanya nâli mali mùlyosa mu kihugo kyeꞌMiisiri.» ");
INSERT INTO flr_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ha nyuma, Musa anabwira Harooni: «Uyabiire urukuzo, unabiike mweꞌbilo bibiri byeꞌmana. Yulwo rukuzo lweꞌmana, unalubiike imbere lya Nahano, lunasingulwe, hiꞌgulu lyoꞌkukengeeza abaana biinyu ábagaki yija.» ");
INSERT INTO flr_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Yago magambo go Nahano akabwira Musa, Harooni, anagagira. Anabiika imana mu Kajumba keꞌKihango, gira ikizi langwa mwo. ");
INSERT INTO flr_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Abahisiraheeri, bakamala imyaka makumi gana bagweti bagaalya imana, halinde ukuhisa ku kyanya bakahika mu kihugo kyeꞌKaanani. Mukuba, mu Kaanani, mwo bakashubi gwana ibindi byokulya. ");
INSERT INTO flr_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ulugero lwo bâli kizi koleesa mu kugera imana, lwâli kizi yingira nga mweꞌbilo bibiri.) ");
INSERT INTO flr_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Abahisiraheeri booshi, banalyoka yaho mwiꞌshamba lyeꞌSiini, banakizi genda bagalenga handi-handi, nga kwo Nahano âli kizi barongoora. Neꞌri bakahika i Refidimu, banatee shumbika yo. Yaho i Refidimu, ndaago magoloovi go bakagwana ho, ");
INSERT INTO flr_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","kyanatuma bagashubi yidodombera Musa, ti: «Utuheereze amagoloovi.» Musa naye, ti: «Biki twafwana? Si mugweti mugaageza Nahano yenyene.» ");
INSERT INTO flr_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Yabo booshi bâli koli nyotiirwi bweneene, kyanatuma bagagenderera ukuyidodombera Musa: «Si ukatulyosa mu kihugo kyeꞌMiisiri, lyo uyiji tuyitira ino munda neꞌnyoota. Kiri naꞌbaana biitu, neꞌbitugwa biitu, byoshi bigaafwa ngana.» ");
INSERT INTO flr_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Musa anatakira Nahano: «Yaba bandu, kuti kwo ngabagira? Si bakola baganyita mu kundasha amabuye!» ");
INSERT INTO flr_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Nahano, ti: «Uyabiire yerya ngoni yo ukashulika ku lwiji Niire. Unashokole injira naꞌbashaaja baguma, naꞌbandu banakushalagire. ");
INSERT INTO flr_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Lolaga! Nienyene ngagwanwa ngoli yimaaziri imbere lyawe, ku lwala lweꞌHorebu. Mango wahika ku yulwo lwala, unalushulike kweꞌngoni. Haaho, lunashyoke mwaꞌmiiji, halinde abandu booshi bananywe.» Ngiisi kwo Rurema akadeta, Musa anakugira, imbere lyaꞌbashaaja baꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Yaho handu, Musa anahayinika iziina i Masa neꞌMeriba, (kuli kudeta: magezo neꞌmilongwe). Mukuba, yabo Bahisiraheeri bakahambanwa, banageza Nahano, ti: «Ka Nahano tuyamiinwi, kandi iri nanga?» ");
INSERT INTO flr_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Yaho i Refidimu, Abahisiraheeri banayiji teerwa naꞌBahamareki. ");
INSERT INTO flr_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Kwokwo, Musa anabwira Yoshwa: «Mu bano bandu bo tugweti, utoole mwo bashosi baguma, gira ugendi lwisa Abahamareki. Naani kusheezi, ngagendi yimanga kwiꞌrango lyeꞌhigangazi, na mbe nvumbiiti irya ngoni ya Rurema.» ");
INSERT INTO flr_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ikyanya Musa akabwira Yoshwa kwokwo, Yoshwa anagendi kugira, anagendi lwisa Abahamareki. Ku kyekyo kyanya, Musa, na Harooni, na Huuri, banazamuukira kwiꞌrango lyeꞌhigangazi. ");
INSERT INTO flr_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ulya Musa, ikyanya âli kizi biika amaboko hiꞌgulu, yabo Bahisiraheeri banakizi hima Abahamareki. Haliko, ikyanya âli kizi gayisa haashi, yabo Bahamareki bo bâli kizi hima. ");
INSERT INTO flr_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Iri Musa akamala ikyanya abiisiri amaboko gaage hiꞌgulu, anakanga. Kyanatuma Harooni na Huuri bagatoola ibuye, banalireeta ngiisi ho ali, analibwatala kwo. Ha nyuma, yabo bombi banalengeza amaboko gaage. Muguma anashiga kweꞌlulyo, noꞌgundi kweꞌlumosho. Musa anayama abiisiri amaboko gaage hiꞌgulu, halinde ikyanya izuuba likasooka. ");
INSERT INTO flr_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kwokwo, kwo Yoshwa naꞌbasirikaani baage, bakalonga ukuhooja-hooja Abahamareki neꞌngooti. ");
INSERT INTO flr_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ha nyuma, Nahano anabwira Musa: «Yiri igambo, uliyandike mu kitaabo, gira Abahisiraheeri bakizi likengeera. Unabwire Yoshwa kwo yabo Bahamareki, nâye baminike lwoshi.» ");
INSERT INTO flr_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Kwokwo, Musa anayubaka akatanda koꞌkusiriigiza kwaꞌmatuulo, anakayinika iziina «Nahano, yiꞌRembera Lyani». ");
INSERT INTO flr_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Anadeta: «Amaboko gakagololwa ku kitumbi kya Nahano. Na buno, Nahano agakizi yama ali mu lwisa Abahamareki mu bibusi byoshi.» ");
INSERT INTO flr_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Shevyala Musa, iziina lyage Yeturo, umugingi weꞌMidyani, anayuvwa ngiisi kwo Rurema akatabaala Musa, naꞌBahisiraheeri booshi, mu kubalyosa mu kihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Ku yikyo kyanya, Musa âli mali gwanwa atuma mukaage wa Zipoora, naꞌbagala bombi, kwo bagendi tuula ha mwoꞌyo Yeturo. ");
INSERT INTO flr_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Ifula, yâli kizi buuzibwa Girishoomu, bwo Musa akadeta: «Nꞌgatibitira mu kihugo kyeꞌmahanga.» ");
INSERT INTO flr_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Na úgamúlonda, âli kizi buuzibwa Heryezeeri, bwo Musa akadeta: «Rurema wa bashokuluza baani ye kandabaala, anangiza mu maboko ga Faraho.» ");
INSERT INTO flr_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Uyo Yeturo, banayijanwa na munyere wage, muka Musa, na bagala baabo bombi, halinde mwiꞌshamba, ho Musa âli shumbisiri, hanâli hoofi noꞌmugazi gwa Rurema. ");
INSERT INTO flr_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Kwokwo, Yeturo anatuma indumwa imunda Musa, ti: «Nie shovyala, ngweti ngayija iyo munda uli. Tuli kuguma na mukaawe, na bagala biinyu bombi.» ");
INSERT INTO flr_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kwokwo, Musa anayimuka, gira agendi músanganira. Neꞌri akahikaga ho ali, anayinama, mu kumúheereza ulushaagwa, anamúnyunyuguta. Iri bakayusa ukulamusania, banayingira mwiꞌheema. ");
INSERT INTO flr_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Musa anaganuulira shevyala ngiisi kwo Nahano akagira, mu kukiza Abahisiraheeri mu maboko ga Faraho, kiri naꞌbandi Bamiisiri booshi. Anamúlibuukira na galya makuba gooshi go bakalonga mu lugeezi, na ngiisi kwo Rurema akabakiza mwo. ");
INSERT INTO flr_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Uyo Yeturo, iri akayuvwa ngiisi kwo Nahano akatabaala Abahisiraheeri, mu kubakiza mu maboko gaꞌBamiisiri, anashambaala ngana. ");
INSERT INTO flr_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Anadeta: «Nahano ahuuzibwe! Keera akamùkiza mu maboko goꞌyo mwami Faraho, na mu gaꞌbandi Bamiisiri booshi. ");
INSERT INTO flr_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Buno ngoli yiji kwo Nahano ye sumbiri íbiri mu yikumbwa byoshi. Mukuba, kundu yabo Bamiisiri bâli kizi libuza Abahisiraheeri bweneene ku kanyaaro, haliko ubuzinda akabaguluula mu maboko gaabo.» ");
INSERT INTO flr_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Lyeryo, uyo Yeturo anatangira Rurema ituulo lyoꞌkusiriiza, kuguma naꞌgandi matuulo. Harooni, kuguma naꞌbashaaja baꞌBahisiraheeri, banayiji shangiira ibyokulya bo na Yeturo, bali imbere lya Rurema. ");
INSERT INTO flr_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Iri bukakya, Musa anabwatala ku kitumbi kyoꞌkutwira kweꞌmaaja. Abandu banakizi múzunguluka, ukulyokera shesheezi halinde kabigingwe, gira bayuvwe ngiisi kwo agabatwira imaaja. ");
INSERT INTO flr_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Uyo Yeturo, iri akabonaga ngiisi kwo Musa agirira Abahisiraheeri, anamúbuuza: «Ewe! Kituma kikagi uli mu twa imaaja zaꞌbandu kwoku? Si ubwatiiri wenyene, naꞌbandu bakuzungulusiri, ukulyokera shesheezi halinde kabigingwe.» ");
INSERT INTO flr_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Musa, ti: «Yabo bandu, íbitumiri bagweti baganyijira, gira bamenye ngiisi byo Rurema aloziizi. ");
INSERT INTO flr_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ikyanya bali mu hambanwa, bali mu kizi nyijira, gira ngizi bahambuula. Na ndi mu kizi bayigiriza imaaja za Rurema, bamenye ngiisi kwo akakyula.» ");
INSERT INTO flr_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Ulya Yeturo anahanuula mukwi wage, ti: «E mwana wani, yibi byo ugweti ugaagira, bitali biija. ");
INSERT INTO flr_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Yugu mukolwa gwoꞌkurongoora abandu, guli muzito bweneene, utanganagugira wenyene. Kwoku ugweti ugayiyumya, iri unayumya kiri na yaba bandu. ");
INSERT INTO flr_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Leka nguhanuule, halinde Rurema yenyene mukizi yamanwa. «Wehe, umukolwa gwawe gubaagage gwa kukizi yimangira abandu imbere lya Rurema, noꞌkukizi múleetera amagoorwa gaabo. ");
INSERT INTO flr_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Unakizi bayigiriza imaaja zaage, bamenye ngiisi kwo akakyula. Unakizi bayerekeza na ngiisi kwo bangatuula, na ngiisi kwo bangakizi gira. ");
INSERT INTO flr_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","«Haliko ku gindi mikolwa, mu yaba bandu booshi, utoolage mwo ábakwaniini, banabe basimbahiri Rurema, batanabe boꞌkutulirwa. Yabo bandu, uheereze baguma ubutwali bwoꞌkuyimangira abandu kihumbi-kihumbi, naꞌbandi abandu igana-igana, kandi iri bandu makumi gataanu-gataanu, kandi iri bandu ikumi-kumi. ");
INSERT INTO flr_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Yabo, babe bo bagakizi twira abandu imaaja. Ngiisi maaja ízigakizi bavwarukira, babe bo bagakizi zitwa. Haliko, ízangabakayira, banakuleetere zo. «Kwokwo, lyo naawe imikolwa ígakuyanguhira, bwo mugaaba mukola mu tabaalanwa. ");
INSERT INTO flr_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Iri wangagira kwokwo, nga kwo Rurema yenyene aloziizi, lyo utagayiluhya. Na yaba bandu nabo, lyo bangakizi taaha imitima ikoli yisiri mu nda.» ");
INSERT INTO flr_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Musa, yiryo ihano lya shevyala, analiyuvwa bwija, analisimbaha. ");
INSERT INTO flr_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mu Bahisiraheeri, anatoola mwaꞌbandu ábakwaniini. Baguma, anabaheereza ubutwali bwoꞌkukizi rongoora abandu kihumbi-kihumbi. Naꞌbandi, igana-igana. Naꞌbandi, makumi gataanu-gataanu. Naꞌbandi, ikumi-kumi. ");
INSERT INTO flr_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Yabo bandu, banaba bo bagakizi twa imaaja zaꞌbandu ngiisi kyanya. Ikyanya zâli kizi bakayira, banazitwalire Musa. Haliko, ikyanya zabavwarukira, banazitwe boonyene. ");
INSERT INTO flr_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ha nyuma, Musa anasezerana na shevyala. Shevyala, anataaha. ");
INSERT INTO flr_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Abahisiraheeri banayimuka yaho i Refidimu. Neꞌri bakahisa imyezi ibiri bashaaziri mu kihugo kyeꞌMiisiri, banahika mwiꞌshamba lyeꞌSinaayi, banashumbika mwiꞌdako lyoꞌmugazi. ");
INSERT INTO flr_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Haaho, Musa anateramira ku mugazi, gira ahuumanane na Rurema. Nahano anamúbwira: «Yabo Bahisiraheeri, kwo bali ba mwiꞌkondo lya Yakobo, ugendi babwira kwokuno: ");
INSERT INTO flr_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","“Mwenyene, keera mukabona ngiisi kwo nꞌgagirira Abamiisiri. Neꞌkyanya nꞌgamùleeta hano, nâli kizi mùleeta nga kwo nyunda ali mu twala abaana baage ku byubi. ");
INSERT INTO flr_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","«“Na buno, iri mwangakizi nzimbaha lwoshi, munabe musimbahiri neꞌkihango kyani, lyo mugaaba bandu baani. Mukuba mu mahanga gooshi, mwe nꞌgatoola. Yago mahanga gooshi, kundu gali geꞌmwani, ");
INSERT INTO flr_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","haliko mwehe mwe mugaaba mulala mutaluule, munabe muli bagingi mu bwami bwani.” Byebyo, byo ugagendi bwira Abahisiraheeri.» ");
INSERT INTO flr_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Iri Musa akashubi manuka, anatumira abashaaja baꞌBahisiraheeri, anabaganuulira ngiisi byo Nahano amúbwira. ");
INSERT INTO flr_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Yabo bandu, banadumeereza kinaliguma, ti: «Yibyo byoshi byo Nahano adeta, tugakizi bigira.» Yiryo ishuvyo lyabo, Musa analitwalira Nahano. ");
INSERT INTO flr_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Nahano anashubi bwira Musa: «Ngakuyijira mu kibungu íkiyidisiri bweneene, gira lyaꞌbandu bakizi yuvwa ngiisi kwo nakubwira. Kwokwo, lyo bagakizi kubiika kwoꞌmulangaaliro isiku zooshi.» Ha nyuma, ngiisi byaꞌbandu bakadeta, Musa anabiganuulira Nahano. ");
INSERT INTO flr_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Nahano anashubi múbwira: «Zeene na kusheezi, ugendi yeruusa abandu, unakizi fuliisa ibyambalwa byabo. ");
INSERT INTO flr_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Na úbugaakya, bayibiikage ibiringiini. Mukuba, ku lwolwo lusiku lweꞌzishatu, ngamanukira ku guno mugazi Sinaayi, imbere lya booshi. ");
INSERT INTO flr_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","«Ku yugu mugazi, ushingire abandu imbibi, unababwire kwo bakizi yilanga. Hatagirage mundu úgaguterama kwo, kandi iri aguhuma kwo. Ngiisi úgaguhuma kwo, agayami yitwa. ");
INSERT INTO flr_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ikyanya agaguhuma kwo, mukamúyitiise naꞌmabuye, kandi iri neꞌmyambi. Kundu angaba mundu, kandi iri kitugwa, agaaba ataki kwiriiri ukuba ho. Kiri noꞌkuguyegeera, abandu baguyegeere naaho, ku kyanya ikibuga kigaaba keera kyadihirizibwa.» ");
INSERT INTO flr_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kwokwo, ikyanya Musa akaba keera amanuka ku mugazi, anagenda imunda yabo bandu, anabayeruusa, banafula neꞌbyambalwa byabo. ");
INSERT INTO flr_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ha nyuma, anababwira: «Mweshi muyilingikanie, halinde mube ibiringiini ku lusiku úlugira izishatu. Hatanagire mushosi úgayegeera mukaage.» ");
INSERT INTO flr_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ku lusiku úlugira izishatu shesheezi, ku gwogwo mugazi, kwanayidika ikibungu, nywe! Imikungulo neꞌmilavyo byanakungula bweneene. Neꞌkibuga kyanadihiriza. Yiryo izu, ikyanya likadeta, lyanaleeza abandu booshi mweꞌkinyukura. ");
INSERT INTO flr_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Haaho, Musa anagenda arongwiri abandu booshi ho bagayimanga mwiꞌdako lyoꞌmugazi, gira bagwanane na Rurema. ");
INSERT INTO flr_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Gulya mugazi Sinaayi, Nahano anagumanukira kwo, ali mu kati koꞌmuliro. Gwanakizi zinga kweꞌkyusi, kyananungeera hiꞌgulu, nga kya kiberekaana. Umugazi gwoshi, gwanakizi jugumba bweneene. ");
INSERT INTO flr_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Izu lyeꞌkibuga, iri likakaviiriza ukulongeera, Musa anaganuuza Rurema. Rurema anakizi múshuvya niꞌzu íriri nga lya mikungulo. ");
INSERT INTO flr_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Nahano anayikira ku mugazi Sinaayi, anahamagala Musa yaho kwiꞌrango lyagwo. Kwokwo, Musa anaterama. ");
INSERT INTO flr_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Nahano anabwira Musa: «Manuka, ugendagi yerekeza yaba bandu, batayiji mbona. Mukuba, iri bangayihalangira, mbu bayiji mbona, haaho, lyaꞌbingi baabo bagayami fwa. ");
INSERT INTO flr_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","«Kiri naꞌbagingi, kundu bo bali mu nyegeera, haliko bakwiriiri bayiyeruuse. Neꞌri batangayiyeruusa, ngabahana.» ");
INSERT INTO flr_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Musa naye, ti: «E Nahano, yaba bandu batangaterama ku guno mugazi, bwo guli mweru. Si wenyene keera watukengula kwo tugusoose kweꞌmbibi.» ");
INSERT INTO flr_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Nahano anamúshuvya: «Manukaga! Neꞌkyanya ugashubi galuka, uyije na Harooni. Haliko abagingi naꞌbandi booshi boohe, utabahanguule kwo bajabuke ulubibi mbu bayije ino munda ndi. Iri bangagira kwokwo, ngabahana.» ");
INSERT INTO flr_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kwokwo, Musa analindimuka ku mugazi, anagendi ganuulira Abahisiraheeri ngiisi kwo Nahano amútuma. ");
INSERT INTO flr_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Rurema anadeta kwokuno: ");
INSERT INTO flr_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Niehe, nie Nahano Rurema wawe. Nie kakulyosa mu buja, mu kihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Kwokwo, hatagire ibindi byo ugakizi yikumba. Si mbe nie ugakizi yikumba naaho. ");
INSERT INTO flr_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Utakizi yigirira imigisi, iba ya njusho ya íbiri kwiꞌgulu, kandi iri ya íbiri hano mu kihugo, kandi iri ya íbiri mu miiji. ");
INSERT INTO flr_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Iyo migisi, utakizi kolwa mbu ugifukamire, kandi iri ugiyikumbe. Mukuba, niehe nie Nahano Rurema wawe, na ndi munaluugi. Iri abandu banganjomba, banakizi gira ibyaha, ndi mu haniiriza abaana baabo, halinde ku kibusi kya kashatu, kiri na ku kya kana. ");
INSERT INTO flr_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kundu kwokwo, ikyanya abandu bali mu ba banguuziri, banabe banzimbahiri, ndi mu kizi bagirira amiija, halinde ku bibusi bihumbi neꞌbihumbi. ");
INSERT INTO flr_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Iziina lya Nahano, Rurema wawe, utakizi lilyogooza. Mukuba, ngiisi úgakizi lilyogooza, agaharuurwa kwo ali munamahube. ");
INSERT INTO flr_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Utakizi yibagira ukutaluula ulusiku lweꞌSabaato. ");
INSERT INTO flr_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Imikolwa yawe yoshi, ukizi gikola mu siku ndatu. ");
INSERT INTO flr_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Si ulusiku lwa kalinda lwohe, iri Sabaato ya Nahano Rurema wawe. Ku yulwo lusiku, hatagire hyo ugaakola, aba wenyene, kandi iri mugala wawe, kandi iri munyere wawe, kandi iri muja wawe, kandi iri muja-kazi wawe, kandi iri kitugwa kyawe, kandi iri kinyamahanga íkiri mu mwawe. ");
INSERT INTO flr_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Mu yizo siku ndatu, mwo Nahano akabumba igulu, neꞌkihugo, neꞌnyaaja, na byoshi íbibiri mwo. Si ulusiku lwa kalinda, iri lukahika, analuhuuka. Ku yukwo, analugashaanira, analutaluula. ");
INSERT INTO flr_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Ukizi simbaha yisho na nyoko, lyo ulonga ukuramba isiku nyingi hano mu kihugo kyo Nahano Rurema wawe akuhiiri. ");
INSERT INTO flr_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Utakizi yitana. ");
INSERT INTO flr_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Utakizi shuleha. ");
INSERT INTO flr_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Utakizi zimba. ");
INSERT INTO flr_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Utakizi bangaaniza umutuulani wawe. ");
INSERT INTO flr_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Utakizi yifwija inyumba yoꞌmutuulani wawe. Utanakizi yifwija mukaage, kandi iri muja wage, kandi iri muja-kazi wage, kandi iri ngaavu yage, kandi iri punda wage. Hatagirage ikindi kindu kyage kyoshi kyo ugakizi yifwija.» ");
INSERT INTO flr_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ku yugwo mugazi, abandu banakizi yuvwa imikungulo, banayuvwa neꞌkibuga. Neꞌkyanya bakakizi bona ibiryamu neꞌkyusi kiguziiziri kwo, booshi banatondeera ukukwanga hiꞌgulu lyeꞌkyoba. Kyanatuma yabo bandu bagagendi yisunga hala. ");
INSERT INTO flr_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Banabwira Musa: «Ube we gakizi tuganuulira. Nyiitu, tugakizi kutega amatwiri. Si Rurema atakizi ba ye gatuganuuza. Mukuba, iri Rurema angakizi tuganuuza, hali ikyanya twangayami fwa.» ");
INSERT INTO flr_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Musa anabashuvya: «Mutakizi yoboha. Íbitumiri Rurema akayija, gira ayiji mùgera. Kwokwo, muyame muli mu músimbaha isiku zooshi, halinde mutakizi ki kola ibyaha.» ");
INSERT INTO flr_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Lyeryo, Musa anayegeera kirya kibungu kyo Rurema âli riiri mwo. Haliko abandi booshi, banayisunga hala. ");
INSERT INTO flr_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Nahano anabwira Musa: «Ubwire Abahisiraheeri kwokuno: “Keera mwayibonera mwenyene ngiisi kwo namùganuuza ukulyoka mwiꞌgulu. ");
INSERT INTO flr_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Kwokwo, hataki gire ibindi byoꞌkuyikumbwa byo mugakizi simbaha. Mutanakizi yitulira imigisi mu nooro, kandi iri mu harija. ");
INSERT INTO flr_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","«“Munyubakire akatanda neꞌbidaka, munakizi kandangira kwiꞌtuulo lyeꞌbibuzi, na lyeꞌmbene, na lyeꞌngaavu. Yago matuulo, gakizi ba goꞌkusiriiza lwoshi, na goꞌkuyerekana ingoome. Na ngiisi ho ngakizi yiyerekana, ho na haaho, ngakizi yiji mùgashaanirira. ");
INSERT INTO flr_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","«“Neꞌri mwanganyubakira akatanda naꞌmabuye, mutakolwe kwo mwagabaaja. Mukuba, iri mwangagabaaja, iri mwakayulubaza. ");
INSERT INTO flr_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Yako katanda kaani, mutakizi kabiika kwoꞌbushonero, abandu batayiji kengeera babona ubukondwe bwo úkashoniiri kwo.”» ");
INSERT INTO flr_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","«Imaaja zaꞌBahisiraheeri bagakizi kulikira zo zeezi: ");
INSERT INTO flr_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Iri wangagula umuja Muheburaniya, akwaniini ahise imyaka ndatu, agweti agakukolera. Haliko ku mwaka gwa kalinda, unamúhanguule ataahe. Ndaabyo bindu byo agakuheereza. ");
INSERT INTO flr_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","«Iri wangaba ukamúgula akiri mushumba, umúleke agende yenyene. Haliko, iri akayija akoli yaziri, umúleke agende na mukaage. ");
INSERT INTO flr_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","«Sheebuja, iri akamúgondera umukazi, uyo mukazi anamúbutira abaana banyere kandi iri batabana, uyo mukazi, naꞌbaana baage, bagaaba bindu byoꞌyo sheebuja. Kwokwo, uyo muja anagende ali yenyene. ");
INSERT INTO flr_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","«Haliko, hali ikyanya umuja angadeta kwo asiimiri sheebuja, asiimiri na mukaage naꞌbaana baage. Anadete kwo ataloziizi ukulyoka mu buja. ");
INSERT INTO flr_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Kwokwo, sheebuja atee mútwala imbere lya Rurema, banagende ha mulyango, kandi iri ha kisimba-lyango. Anakoleese ikyuma kishongole, mu kutula umuja wage ukutwiri. Lyoki, ulya muja agayama ali mu kolera uyo sheebuja isiku zooshi. ");
INSERT INTO flr_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Umundu, iri angaguliisa munyere wage abe muja, uyo munyere atangashubi shwekuulwa, nga kwaꞌbaja bashosi bali mu shwekuulwa. ");
INSERT INTO flr_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","«Iri sheebuja angamúgula kwo agaaba mukaage, haliko atanaki músimiise, uyo sheebuja atangamúguliisa mu binyamahanga. Si akwiriiri aleke mwene ye amúguluule. Buzira kwokwo, agaaba ahongola ikihango. ");
INSERT INTO flr_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","«Neꞌri sheebuja angagondera mugala wage umuja-kazi, akwiriiri akizi múgirira nga munyere wage. ");
INSERT INTO flr_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Uyo mushosi, iri angayanga umukazi wa kabiri, akwiriiri akizi sumira uyo mukaage wa mbere, anakizi múyambika, iri banakizi menyana bo naye. ");
INSERT INTO flr_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Yago magambo gashatu, iri uyo mushosi atangamúgirira go, umukazi anayigendere, atakwaniini ukutangisibwa kindu kyoshi. ");
INSERT INTO flr_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Iri umundu angashulika uwabo, anamúyite, akwiriiri naye ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","«Haliko, hali ikyanya angayita uwabo buzira kugiriirira. Si Rurema anabe ye kabilooza. Haaho, uyo mundu akwiriiri atibitire mu kaaya ko ngatoola. ");
INSERT INTO flr_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","«Haliko, iri umundu angashomba uwabo, anamúyite mu kugiriirira, uyo nakuyitana, kundu angatibitira ha katanda kaani, mugendi múlyosa ho, munayami múyita. ");
INSERT INTO flr_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Umundu, iri angashulika yishe, kandi iri nyina, akwiriiri ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Umundu, iri angabirigisha uwabo, mbu lyo agendi múguliisa, kandi iri amúgire muja wage, naye akwiriiri ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Umundu, iri angadaaka yishe, kandi iri nyina, naye akwiriiri ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«Abandu babiri, hali ikyanya bangalongoola. Muguma analashe uwabo ibuye, kandi iri amúshulika ikifune, haliko atanamúyite. Uyo úwashulikwa anagendi lwala. ");
INSERT INTO flr_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Na mu kutandaluka, anakizi gendera ku ngoni. Kwokwo, uyo wabo úkamúshulika, akwiriiri akogwe. Haliko, agamúliha yizo siku zo amala alwaziri, anagenderere ukumúbukiisa, halinde akire lwoshi. ");
INSERT INTO flr_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Umundu, iri angatoola ingoni, anashulike umuja wage, kandi iri muja-kazi wage, anayami múyita, uyo akwiriiri ahanwe. ");
INSERT INTO flr_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Haliko uyo muja, kandi iri muja-kazi, iri angahisa ulusiku luguma kandi iri zibiri akiri mugumaana, uyo nahamwabo atangaki hanwa, bwoꞌyo muja, ali bindu byage. ");
INSERT INTO flr_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Iri abashosi bangalwa, banakengeere bakomeeresa umukazi úli neꞌnda, iyo nda inashalamuke buzira kumúleetera agandi magoorwa, uyo úwamúkomeresa akwiriiri ukuliha ngiisi bindu byo yiba woꞌyo mukazi agahuuna, nga kwaꞌbatungwa bagakyula. ");
INSERT INTO flr_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Haliko iri angafwa, akwaniini naye ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ee! Mugalihiisa isu ku lindi, neꞌliino ku lindi, noꞌkuboko ku kundi, noꞌkugulu ku kundi. ");
INSERT INTO flr_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Úwayokania, naye ayokibwe. Mugalihiisa uluguma ku lundi, neꞌkifune ku kindi. ");
INSERT INTO flr_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Umuja kandi iri muja-kazi, iri nahamwabo angamúshulika, anamúbere isu, uyo nahamwabo akwiriiri ukumúhanguula agende lwoshi. Atagashubi kolera nahamwabo, bwo keera amúbera isu. ");
INSERT INTO flr_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Neꞌri angamúshulika, anamúkuule iriino, akwiriiri kwakundi amúhanguule agende lwoshi, hiꞌgulu lya yiryo liino lyage. ");
INSERT INTO flr_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Ishuuli, iri yangatumita umundu, inamúyite, iyo ngaavu ikwiriiri iyitwe ku mabuye. Neꞌnyama yayo, italiibwe. Mwene iyo ngaavu atagahanwa. ");
INSERT INTO flr_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","«Haliko iyo ngaavu, hali ikyanya yangaba iri mu tumitana, naꞌbandu banayiji yerekeza mwene yo. Kundu kwokwo, atanagishweke, inakengeere yatumita umushosi kandi iri mukazi, anafwe. Kwokwo, iyo ngaavu iyitwe mu kulashwa amabuye. Kiri na mwene yo, naye ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kundu kwokwo, iri uyo mundu angahuunwa ibindu hiꞌgulu lyoꞌkuguluula ubulamu bwage, akwiriiri atange ngiisi byo agahuunwa. ");
INSERT INTO flr_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","«Ishuuli, iri yangatumita umwana, yulwo lubaaja lutwibwe nga kwo yulwo lundi lwatwibwa. ");
INSERT INTO flr_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","«Ishuuli, iri yangatumita umuja, kandi iri muja-kazi, uyo mwene ishuuli akwiriiri ukuliha mwene uyo muja ibingorongoro makumi gashatu. Neꞌyo ngaavu, inayitwe mu kulashwa amabuye. ");
INSERT INTO flr_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Hali ikyanya umundu angahumba ikishimo atanakifulire, munayiji tibukira punda, kandi iri ngaavu. ");
INSERT INTO flr_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","Kwokwo, uyo mwene kishimo akwiriiri alihe mwene ngaavu, kandi iri punda. Leero yugwo mutumba, anabe ye gagusigalana. ");
INSERT INTO flr_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","«Ishuuli, iri yangatumita ishuuli yoꞌgundi, inagiyite, iyo shuuli íyayita iyabo iguliisibwe. Na yizo fwaranga, bazigabaane na mwene yo íyayitwa. Neꞌfwaranga zo balonga kwiꞌyo íyafwa, bashubi zigabaana. ");
INSERT INTO flr_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Haliko iyo shuuli, iri yangaba ishuba mu tumita-tumita izaabo, na mwene yo atanagishweke, akwiriiri alihe ingaavu ku gindi. Leero, yugwo mutumba, gugaaba guli gweꞌmwage. ");
INSERT INTO flr_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","«Umuzimba, iri angazimba ingaavu, kandi iri ikibuzi, anakibaage, kandi iri akiguliisa, uyo akwiriiri agalulire mwene ingaavu izindi zitaanu, kandi iri mwene kibuzi ibindi bina. ");
INSERT INTO flr_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Umuzimba, iri angagwatwa agweti agaabera inyumba, anayitwe, úwamúyita, ndaakyo kyaha kyo agaaba agira. ");
INSERT INTO flr_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Haliko, iri agwatwa mwiꞌzuuba, anayitwe, uyo nakuyitana, agaaba keera ayona umuko. Umuzimba akwiriiri alihe byo azimba. Neꞌri angaba ndaabyo ahiiti, akwiriiri aguliisibwe abe muja. ");
INSERT INTO flr_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","«Umuzimba, iri bangagwana ahiiti ingaavu yo azimba, kandi iri punda, kandi iri kibuzi, binabe bikiri bigumaana, akwiriiri alihe ibitugwa bibiri. ");
INSERT INTO flr_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","«Umundu, iri angayoneekeza uwabo indalo yeꞌmizabibu, akwiriiri alihe umwimbu gwage mwija, kandi iri indalo yage yeꞌmizabibu. ");
INSERT INTO flr_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«Umundu, iri angayokya ikishuka, umuliro gunalande, gunagendi boyola ibiiro byeꞌngano, kandi iri ingano yoꞌgundi mundu ítazi yimbulwa, halinde gunajigiivye iyo ndalo yoshi, uyo mundu akwiriiri abirihe. ");
INSERT INTO flr_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«Hali ikyanya umundu angabikiisa uwabo ifwaranga kandi iri ibindi bindu. Yibyo bindu, iri byangayiji zimbwa, banagwate nakubizimba, akwiriiri abirihe ubugira kabiri. ");
INSERT INTO flr_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Haliko, iri atangagwatwa, uyo úkabibikiisibwa akwiriiri agende imbere lya Rurema, mu kuyerekana akasiisa kwo atabibisha uwabo. ");
INSERT INTO flr_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","«Hali ikyanya abandu bangahambanwa hiꞌgulu lyeꞌngaavu, kandi iri punda, kandi iri kibuzi, kandi iri kyambalwa, kandi iri kindi kindu kyoshi íkikateereka. Ngiisi muguma anadete kwo kiri kyeꞌmwage. Yabo ábahambanwa bombi, baleetwe imbere lya Rurema. Kwokwo, ngiisi ye Rurema agayerekana kwo kirya kindu kitali kyeꞌmwage, akwiriiri akilihe ubugira kabiri. ");
INSERT INTO flr_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«Hali ikyanya umundu angabiisa uwabo punda, kandi iri ngaavu, kandi iri kibuzi, kandi iri kindi kitugwa kyoshi. Yikyo kitugwa, iri kyangafwa, kandi iri kivunika, kandi iri kizimbwa buzira bumasi, ");
INSERT INTO flr_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","yabo bombi bagabiika indahiro zaabo imbere lya Nahano. Yizo ndahiro zinabatwire ulubaaja. Kwokwo, uyo nakubiisania agayemeera iyo ndahiro, atanalihiise uwabo. ");
INSERT INTO flr_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Haliko, iri kyangazimbirwa ha mwage, akwiriiri akilihe uyo nakumúbiisa. ");
INSERT INTO flr_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Yikyo kitugwa, iri kyangaliibwa neꞌnyamiishwa, atwale ibitetereza byakyo imwa mwene kyo, bube bumasi. Ndaahyo hyoshi hyo angaliha uyo wabo ku kitugwa íkyaliibwa neꞌnyamiishwa. ");
INSERT INTO flr_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","«Hali ikyanya umundu angagendi tiiza ikitugwa kyoꞌwabo, kinamúkomerekere kwo, kandi iri kimúfwira kwo. Uyo mwene kyo, anabe atali ho. Uyo úwakitiiza, buli bwija akilihe. ");
INSERT INTO flr_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Haliko iri kyangafwa, anabe ali ho, uyo úkagendi kitiiza, iri ndaahyo hyoshi hyo agaaliha. Neꞌri kyangaba kya kutiiza, mwene kyo agayemeera naaho ngiisi kwo bakalagaana noꞌwabo. ");
INSERT INTO flr_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","«Umuhyakazi útazi yangwa, iri umundu angamútiza, anamúshulehe, akwiriiri amúgonde. ");
INSERT INTO flr_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Neꞌri yishe woꞌyo munyere angalahira kwoꞌyo mundu atamúgonde, uyo úwamúshuleha akwiriiri alihe uyo munyere ifwaranga ízikwiriiri, bwo keera amúshereeza. ");
INSERT INTO flr_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","«Umukazi mulozi, mutamúleke kwo atuule ho. ");
INSERT INTO flr_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«Umundu, iri angashuleha ikitugwa, akwiriiri ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«Umundu, iri angatangira imigisi ituulo, iri agayiriza Nahano. Uyo mundu, akwiriiri ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«Mutakizi libuza ikinyamahanga, kandi iri kumúvindagaza. Si na niinyu mwâli riiri binyamahanga mu kihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Na kwakundi, mutakizi libuza namufwiri, kandi iri ifuuvi. ");
INSERT INTO flr_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Iri mwangabalibuza, banandakire, ku kasiisa ngayuvwa amalira gaabo, ");
INSERT INTO flr_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ninamùrakarire, ninamùyitiise ku ngooti. Yabo bakiinyu, bagaaba bakola banamufwiri. Naꞌbaana biinyu, banabe zikola fuuvi. ");
INSERT INTO flr_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","«Umundu wani umukeni, iri wangamúkaaba ifwaranga, utakizi ba nga umúkaabiri, utanakizi múhuuna ubunguke. ");
INSERT INTO flr_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Iri wangatwala umulondo gwoꞌwinyu, mbu gube ngwati, ukwiriiri umúgalulire gwo, izuuba lítazi sooka. ");
INSERT INTO flr_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Si ndaagwo gundi ahiiti gwoꞌkuyibwika. Aaho! Biki bindi byo utoniri kwo agayibwika bushigi? Neꞌri angandirira, ngamúyuvwa, bwo ndi munalukogo. ");
INSERT INTO flr_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","«Utatuke Rurema. Utanadaake útwaziri abandu baawe. ");
INSERT INTO flr_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«Ikyanya muhiiti ikihande kiꞌkumi kyeꞌmimbu yinyu, na kyeꞌdivaayi yinyu, utatindirize ukubitanga. Kiri neꞌfula ziinyu zoꞌbutabana, mugazimbeereza. ");
INSERT INTO flr_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Mukizi gira kwokwo na ku ngaavu ya mbere ukubutwa, kiri na ku byanabuzi biinyu. «Yabo baana beꞌbitugwa, muleke batee mala isiku zirinda bali ku banyina. Haliko, ku lusiku úlugira umunaana, munabandangire. ");
INSERT INTO flr_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","«Bwo muli mu ba bandu baani bataluule, mutakizi lya inyama yeꞌkitugwa íkyayitwa neꞌnyamiishwa. Si yizo nyama, mukizi zitobera utubwa. ");
INSERT INTO flr_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Utakizi beesha. Utanakizi tabaala umunabyaha, mu kukizi mútangira ubumasi bweꞌbibeesha. ");
INSERT INTO flr_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","«Kundu abandu bingi bangakizi yifunda mu mabi, utabakulikire mu go. Neꞌkyanya mugakizi tanga ubumasi imbere lyaꞌbandu, mutakizi shovya ukuli, mu kukulikira ibibeesha byaꞌbandu bingi. ");
INSERT INTO flr_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","«Ikyanya abakeni bagakizi kuleetera ulubaaja, utakizi bakundirira, mbu bwo bali bakeni. ");
INSERT INTO flr_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Umugoma wawe, iri angateera ingaavu yage, kandi iri punda, unagitoole, uyami múleetera yo. ");
INSERT INTO flr_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Hali ikyanya umundu angaba akushombiri, anabetuze punda wage umuteekerwa muzito. Uyo punda, iri wangamúgwana keera agwa mwiꞌdako lyagwo, utamúlekere ye, mbu uyigendere. Haliko, umútabaale mu kumúvyula. ");
INSERT INTO flr_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Umukeni, iri angalegwa, anabe ali noꞌkuli, utamúhengekere ulubaaja lwage. ");
INSERT INTO flr_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","«Umundu, iri angabeesha mu kulegana, utakolwe mbu umúyibiike kwo. Utayite umuzira buhube, anabe akwaniini. Iri wangagira kwokwo, niehe ndagaki kukoga. ");
INSERT INTO flr_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","«Utayemeere ukutulirwa. Si ikitulire, kiri mu humaaza amasu, kinatume amagambo goꞌmundu úkwaniini gagahengekwa. ");
INSERT INTO flr_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Mutakizi libuza ikinyamahanga. Si muyiji-yiji amagoorwa gaakyo, bwo niinyu mwâli riiri binyamahanga mu kihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Ukizi hisa imyaka ndatu uli mu lima, unayimbule imimbu yawe. ");
INSERT INTO flr_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Si mu mwaka gwa kalinda, ulekage ukuhinga. Kwokwo, lyaꞌbakeni biinyu balonga byo bagaalya, kiri neꞌnyamiishwa kwakundi. ");
INSERT INTO flr_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«Ukizi hisa siku ndatu uli mu kola. Haliko, ulusiku lwa kalinda, unaluhuuke. Kwokwo, lyeꞌngaavu yawe na punda wawe bikizi luhuuka, kiri noꞌmuja úkabutwa mu mwawe, neꞌkinyamahanga. Yabo booshi, banabe bali mu longa imisi mihyahya. ");
INSERT INTO flr_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Yaga magambo gooshi go nakubwira, ukizi gira umwete gwoꞌkugasimbaha. Utakolwe mbu utabaaze imizimu. Kiri naꞌmaziina gaayo, gatahuluke mu kanwa kaawe. ");
INSERT INTO flr_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Mukizi ngirira isiku ngulu zishatu ku mwaka, hiꞌgulu lyoꞌkunyereka ulushaagwa. ");
INSERT INTO flr_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ubwa mbere, mukizi shambaalira ulusiku lukulu lweꞌmikate mizira saama, nga kwo keera nꞌgamùbwira. Muhise isiku zirinda, muli mu lya imikate mizira saama. Yizo siku, zigaaba mu mwezi gwa Habibu. Mukuba, mu gwogwo mwezi, lyo mukalyoka i Miisiri. Mu yizo siku, hatagire mundu úgayija imbere lyani maboko mamaata. ");
INSERT INTO flr_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«Mukizi shambaalira noꞌlusiku lukulu lwoꞌkutomola imimbu yinyu. Ubuzinda, munashambaalire noꞌlusiku lukulu lwoꞌkukuumania imimbu, ku kyanya mugaaba keera mwagiyimbula. ");
INSERT INTO flr_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kwokwo, abashosi booshi bakizi kuumana imbere lya Nahano woꞌBushobozi ubugira kashatu ku mwaka. ");
INSERT INTO flr_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Ikyanya ugakizi ndangira ituulo lyeꞌkitugwa, utakizi litanga kuguma neꞌmikate íri mweꞌsaama. Naꞌmajuji gaakyo, mutakizi galaaza halinde shesheezi. ");
INSERT INTO flr_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","«Ikyanya muli mu yimbula, mutangage itomola imwa Nahano, Rurema winyu. «Na kwakundi, mutadeekere ikyanabuzi, kandi iri kyanahene, mu mata ga nyina. ");
INSERT INTO flr_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Lolaga! Ngweti ngaatuma umuganda imbere liinyu, gira akizi mùlanga mu njira, halinde amùhise ho nꞌgamùlingaaniza. ");
INSERT INTO flr_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ikyanya agamùbwira amagambo, mukizi múyuvwiriza, munamúsimbahe. Mutakizi huna imbere lyage. Mukuba, iri mwangahuna, atagamùkejeerera. Si namútuma kwiꞌziina lyani. ");
INSERT INTO flr_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Uyo muganda, iri mwangamúyuvwa ku bwigenderezi, munagire ngiisi byo ngamùbwira, lyo ngayigira mbe mugoma waꞌbagoma biinyu. Na ngiisi ábagweti bagamùgaya, naani, ngakizi bagaya. ");
INSERT INTO flr_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","«Uyo muganda wani agakizi mùrongoora, halinde anamùhise mu kihugo kyaꞌBahamoori, naꞌBahiti, naꞌBapereesi, naꞌBakaanani, naꞌBahivi, naꞌBayebuusi. Yabo booshi, ngabaminika. ");
INSERT INTO flr_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Mutafukame imbere lyeꞌmigisi yabo, mbu mugiyikumbe. Mutanakizi gikolera. Mutanakolwe mbu muyige byo bali mu gira. Haliko mubaminike lwoshi. Naꞌmabuye gaabo go bataluula, mugavungule-vungule. ");
INSERT INTO flr_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","«Mukizi ngolera naaho, bwo nie Nahano, Rurema winyu. Kwokwo, lyo ngakizi gashaanira indalo ziinyu, kiri naꞌmiiji giinyu. Na ndyose amalwazi mu kati kiinyu. ");
INSERT INTO flr_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Mu kihugo kiinyu, ndaaye mukazi úgaki shalamukwa. Ndaanaye úgakizi gumba. Muganalama isiku nyingi. ");
INSERT INTO flr_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«Ngakizi gwanwa nabiika ikihuume kyani imbere liinyu, halinde kikizi jaajula imitima yaꞌbandu bo mugagwana yo. Ngabiika abagoma biinyu mweꞌkyoba, halinde banamùtibite. ");
INSERT INTO flr_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Nganagwanwa natuma injuki imbere liinyu, gira ziyimule Abahivi, naꞌBakaanani, naꞌBahiti. ");
INSERT INTO flr_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Yabo booshi, ndagabayimula ku mwaka muguma, gira lyeꞌkihugo kitasigale kimaata. Iri nangayami bayimula, lyeꞌnyamiishwa zigaluguuka, zinayiji mùhima imisi. ");
INSERT INTO flr_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Kwokwo, ngakizi balyosa bwija-bwija, halinde ku kyanya mugaaba keera mwaluguuka mu kihugo, munakihyane. ");
INSERT INTO flr_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","«Ulubibi lweꞌkihugo kiinyu, lugatondeerera ku Nyaaja Ndukula, halinde ukuhisa ku Nyaaja Mediterane. Na kandi, lugalyokera mwiꞌshamba, halinde ukuhisa ku lwiji Hefuraati. Ngabiika beene ikihugo mu maboko giinyu, munabayimule mwo. ");
INSERT INTO flr_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","«Mutakolwe kwo mwanywana ikihango mwe nabo, kandi iri neꞌmizimu yabo. ");
INSERT INTO flr_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Yabo bandu, mutanaleke kwo mutuulanwe mu kihugo kiinyu. Iri mwangatuulanwa, bagaatuma mugakizi gira ibyaha imbere lyani. Neꞌri mwangayikumba imigisi yabo, igaaba mitego yoꞌkumùgwasa.» ");
INSERT INTO flr_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Nahano anabwira Musa: «Uyijage imunda ndi ku mugazi, mwe na Harooni, na Nadabu, na Habihu, kiri naꞌbashaaja makumi galinda baꞌBahisiraheeri. Yabo booshi, bagayisunga hala, mu kunyikumba. ");
INSERT INTO flr_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Wehe naaho we ganyegeera. Si yabo bandi batanyegeere. Kiri naꞌbandi Bahisiraheeri, hatagire úgaashona ku mugazi, mbu akukulikire.» ");
INSERT INTO flr_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Yago magambo, ikyanya Nahano akagabwira Musa, naye anagendi gabwira abandu booshi, anababwira neꞌmaaja zooshi. Iri bakayuvwa, banamúshuvya kinaliguma, ti: «Ngiisi byo Nahano adeta, byo tuganakizi gira.» ");
INSERT INTO flr_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kwokwo, ikyanya Nahano akabwira Musa yibyo byoshi, anabiyandika. Iri bukakya shesheezi, anavyuka, anayubaka akatanda mwiꞌdako lyoꞌmugazi. Anashinga inguliro ikumi na zibiri, ízikabaajwa mu mabuye, ukukulikirana neꞌmilala ikumi niꞌbiri yaꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Ha nyuma, anatuma imisore yaꞌBahisiraheeri, kwo bagendi tangira Nahano ituulo lyoꞌkusiriiza, kuguma neꞌshuuli mbaage, gira libe ituulo lyoꞌkuyerekana ingoome. ");
INSERT INTO flr_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Yibyo bitugwa, ikyanya bakabitongeera, Musa anayabiira ku muko gwabyo, anagubiika mu mitanga. Ugundi, anagushangira ku yako katanda. ");
INSERT INTO flr_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ha nyuma, anayabiira Ikitaabo kyeꞌKihango kya Nahano, anakisoma imbere lyaꞌbandu. Neꞌri bakayuvwa, banadeta: «E waliha, ngiisi byo Nahano adeta, tugakizi bigira. Tuganakizi bisimbaha.» ");
INSERT INTO flr_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Yugwo muko, Musa anaguyabiira, anagushangira-shangira ku yabo bandu, anababwira: «Yugu muko, guli gweꞌkihango kyo mwanywana na Nahano, ukukulikirana na yaga magambo gooshi.» ");
INSERT INTO flr_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Ha nyuma, Musa na Harooni, na Nadabu, na Habihu, naꞌbashaaja makumi galinda baꞌBahisiraheeri, banateramira ku mugazi, ");
INSERT INTO flr_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","banagendi bona Rurema waꞌBahisiraheeri. Mwidako lyaꞌmagulu ga Rurema, mukaboneka íkiri nga njira íkagirwa naꞌmabuye geꞌkishingo ga namukungumo. Yikyo kindu, kyâli kizi keyengana nga kyanyaanya. ");
INSERT INTO flr_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Kundu yabo bimangizi baꞌBahisiraheeri bakabona Rurema, ndaaye ye akashereeza. Kwokwo, banalya imbere lyage, iri bananywa. ");
INSERT INTO flr_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Nahano anabwira Musa: «Uzamuukire ino munda ku mugazi, unabeere haahano, halinde nguheereze amabuye mabaaje, ámayandike kweꞌMaaja naꞌmategeko. Ha nyuma, lyo ugabiyigiriza Abahisiraheeri.» ");
INSERT INTO flr_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Kwokwo Musa, kuguma noꞌmukozi wage Yoshwa, bombi banazamuukira ku mugazi gwa Rurema. ");
INSERT INTO flr_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Musa anabwira yabo bashaaja: «Mutulindirire hano, halinde ikyanya tugagaluka. Neꞌri mwangaba muhiiti igoorwa lyoꞌkuhambuulwa, twamùsigira Harooni na Huuri.» ");
INSERT INTO flr_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Ikyanya Musa akazamuukira ku mugazi Sinaayi, ikibungu kyanayami guzinga kwo. ");
INSERT INTO flr_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ubulangashane bwa Nahano bwanagushonookera kwo. Yikyo kibungu, kyanahisa isiku ndatu kiguyidisiri kwo. Ku lusiku úlugira izirinda, Nahano anahamagala Musa mu kibungu. ");
INSERT INTO flr_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Abahisiraheeri, ikyanya bâli kizi langiiza bulya bulangashane kwiꞌrango lyoꞌmugazi, bwanaboneka nga muliro gwoꞌkusingoola bweneene. ");
INSERT INTO flr_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Lyeryo, Musa anateramira ku mugazi, anayingira mu kirya kibungu, anamala mweꞌsiku makumi gana, ubushigi niꞌzuuba. ");
INSERT INTO flr_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Ubwire Abahisiraheeri kwo bangumanize amatuulo, gakizi tangwa ku mutima úgushenguusiri. ");
INSERT INTO flr_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Yago matuulo, go gaagano: inooro, neꞌharija, neꞌmiringa. ");
INSERT INTO flr_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","Uyakiire neꞌnuzi ziꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. Uyakiire neꞌmirondo yeꞌkitaani, kiri noꞌbwoya bweꞌmbene, ");
INSERT INTO flr_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","neꞌmbu zeꞌbipanga ízikashiigwa ibara lidukula. Uyakiire neꞌmbu ngomu, neꞌbiti byaꞌkasiya. ");
INSERT INTO flr_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Uyakiire neꞌbitoro byoꞌkubiika mu matara, naꞌmalaasi goꞌkufusha mu mavuta goꞌkushiiga ku byataluulwa, noꞌmubadu gwoꞌmuhongolo mwija. ");
INSERT INTO flr_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Uyakiire naꞌmabuye geꞌhonikisi, naꞌgandi goꞌkulimbiisa ikangaata lyoꞌmugingi, neꞌshaho yo agakizi yambala ha kifuba. ");
INSERT INTO flr_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","«Na kwakundi, Abahisiraheeri bangirire Ahandu Heeru, gira tutuulanwe. ");
INSERT INTO flr_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Yaho handu kuguma neꞌbirugu byaho, ugabigira nga ngiisi kwo ngakuyereka. ");
INSERT INTO flr_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Ubwire Abahisiraheeri kwo bangirire akajumba mu biti byaꞌkasiya. Yako kajumba, kabe keꞌsendimeetere igana niꞌkumi, ku sendimeetere makumi galindatu na ndatu. Neꞌkimango kyako, zibe sendimeetere makumi galindatu na ndatu. ");
INSERT INTO flr_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","«Yako kajumba, ukabugiirize kweꞌnooro muguuhya, mu nda neꞌmugongo, unakasoose kweꞌmihiro yeꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ukagirire imbete zina. Na ngiisi kigingi, ukihogeke kweꞌmbete, zibiri-zibiri ku ngiisi luhande. ");
INSERT INTO flr_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Mugire ibiti bibiri bila byaꞌkasiya, unabishiige kweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Yibyo biti, ubihogeke mu yizo mbete, hiꞌgulu lyoꞌkukizi betulira kwo kalya kajumba. ");
INSERT INTO flr_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Yibyo biti, biyame mwomwo, bitanakizi lyosibwa. ");
INSERT INTO flr_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ikyanya mugayusa yako kajumba, mukabiike mwo galya mabuye mabaaje geꞌkihango go ngakuheereza. ");
INSERT INTO flr_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Na mwiꞌrya nooro muguuhya, utule mwoꞌmutumbikizo gwoꞌlukogo. Yugwo mutumbikizo, gube gweꞌsendimeetere igana niꞌkumi, ku sendimeetere makumi galindatu na ndatu. ");
INSERT INTO flr_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","«Na kwakundi, uyabiire inooro, unatule mweꞌbindu bibiri íbiri nga makerubi, unabibiike ku mbeka zombi za yugwo mutumbikizo. ");
INSERT INTO flr_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Makerubi muguma, umúbiike ku mbeka nguma, noꞌgundi ku gindi. Yabo bombi, ubananike ku mutumbikizo, kibe kindu kiguma. ");
INSERT INTO flr_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Yabo bamakerubi, bagayajuula ibyubi byabo, halinde binasokanane yugwo mutumbikizo. Amalanga gaabo, gakizi gulola kwo. ");
INSERT INTO flr_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Mu yako kajumba, ubiike mwo yago mabuye mabaaje geꞌkihango go ngakuheereza, mukabuli katereka kwo yugwo mutumbikizo. ");
INSERT INTO flr_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Yaho ha kati ka bamakerubi ábakangariiri ku mutumbikizo gwoꞌlukogo, ho tugakizi gwanana. Tunaganuule, na nguheereze amategeko gooshi hiꞌgulu lyaꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Uyabiire ibiti byaꞌkasiya, unalingaanie mwaꞌkashasha. Yako kashasha, kabe neꞌsendimeetere makumi galimunaana na munaana, ku sendimeetere makumi gana na zina. Neꞌkimango, kibe kyeꞌsendimeetere makumi galindatu na ndatu. ");
INSERT INTO flr_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Yako kashasha, ukabugiirize kweꞌnooro muguuhya. Kiri na ku mihiro yako, ukubugiirize inooro. ");
INSERT INTO flr_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Ha nyuma, unakasoose kwoꞌlupahwa lweꞌsendimeetere munaana. Nalwo, unalubugiirize kweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","«Yako kashasha, unakagirire imbete zina zeꞌnooro. Na ngiisi mbete, ugibiike ku ngiisi kagongo kaꞌmagulu kwo gali gana. ");
INSERT INTO flr_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Yizo mbete, zibiikwe hoofi na lulya lupahwa úluli mu kingira akajumba, gira zikabe zo bagakizi hogeka mweꞌbiti byoꞌkukabetulira kwo. ");
INSERT INTO flr_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ubaaje ibiti bibiri bila byaꞌkasiya, unabibugiirize kweꞌnooro. Binabe byo mugakizi betulira kwaꞌkashasha. ");
INSERT INTO flr_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Na ku íbiloziri ibikolanwa bya ku yako kashasha, ubilingaanie mu nooro muguuhya: ngaꞌmasahaani, neꞌbikombe, neꞌkarabo, neꞌbirembe byoꞌkukizi fukira mwaꞌmatuulo geꞌdivaayi. ");
INSERT INTO flr_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Yako kashasha, ukizi kabiika kweꞌmikate. Neꞌyo mikate, igakizi yama iri imbere lyani. ");
INSERT INTO flr_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Ulingaanie neꞌkiterekero kyaꞌmatara, mu nooro muguuhya. Byoshi bibe binanisirwi, binabe nga kindu kiguma, kuli kudeta ikigingi kyakyo, naꞌmatavi gaakyo, neꞌbikombe byakyo, noꞌtufundo twakyo, noꞌtwaso twakyo. ");
INSERT INTO flr_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","«Yikyo kiterekero, kigabiikwa kwaꞌmatavi galindatu. Luhande luguma, kinanikwe kwaꞌmatavi gashatu. Noꞌlundi, kinanikwe kwaꞌgandi gashatu. ");
INSERT INTO flr_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ngiisi itavi ligakizi hogekwa kweꞌbikombe bishatu íbiri nga twaso tweꞌloozi. Ngiisi kiguma kigakizi hogekwa mu tufundo twakyo, na mu twaso twakyo. ");
INSERT INTO flr_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Yikyo kiterekero, kigabiikwa kweꞌbikombe bina íbiri nga loozi, kuguma noꞌtufundo twabyo noꞌtwaso twabyo. ");
INSERT INTO flr_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","«Ngiisi haꞌmatavi gabiri gagakizi gwanana ku kiterekero, habiikwe akafundo. ");
INSERT INTO flr_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Yutwo tufundo, na yago matavi, byoshi bibe kindu kiguma. Yikyo kiterekero kitulwe mu nooro muguuhya. ");
INSERT INTO flr_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«Na kwakundi, ugaatula itara liguma-liguma, unalibiike ku ngiisi itavi kwo gali galinda, gira gakizi mùmolekera. ");
INSERT INTO flr_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Imbaazi zaalyo, neꞌbirugu byalyo, ubitule mu nooro muguuhya. ");
INSERT INTO flr_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","«Ikyanya ugaatula yikyo kiterekero neꞌbirugu byakyo, ugakoleesa ibilo makumi gashatu na bitaanu byeꞌnooro muguuhya. ");
INSERT INTO flr_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Kwokwo, usise bwija, halinde ulingaanie byoshi, ukukulikirana na ngiisi kwo nagwanwa nakuyereka ku mugazi. ");
INSERT INTO flr_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Ikyanya ugalingaania iheema lyeꞌmihumaanano, ukoleese imirondo ikumi yeꞌnuzi zeꞌkitaani, na yoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. Unagilimbiise neꞌbishushanio bya bamakerubi. ");
INSERT INTO flr_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ngiisi mulondo, gube gweꞌmeetere ikumi na zibiri, ku meetere zibiri. Iyo mirondo yoshi, ibe noꞌlugero luguma. ");
INSERT INTO flr_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","«Uhangire imirondo itaanu kuguma, halinde ibe mulondo muguma. Neꞌkihande kya kabiri, uhangire igindi taanu kuguma. ");
INSERT INTO flr_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Kwiꞌkano lya ngiisi mulondo gweꞌmbeka, uhangire kweꞌminaganizo yiꞌbara lya namukungumo. ");
INSERT INTO flr_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Ushweke iminaganizo makumi gataanu ku mbeka yeꞌkihande kiguma, unashweke igindi makumi gataanu ku kyabo. Iyo migozi yoshi, ikizi lolana. ");
INSERT INTO flr_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","«Uyabiire inooro, unatule mweꞌndoboro makumi gataanu zoꞌkunanika iyo mirondo ibiri kuguma, halinde iheema lyeꞌmihumaanano, kibe kindu kiguma naaho. ");
INSERT INTO flr_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«Muyabiire ubwoya bweꞌmbene, unaluke mweꞌmirondo ikumi na muguma yoꞌkubwikira kwiꞌheema. ");
INSERT INTO flr_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ngiisi mulondo, gube neꞌmeetere ikumi na zishatu, ku zibiri. Iyo mirondo yoshi kwo iri ikumi na muguma, igaaba na lwolwo lugero luguma. ");
INSERT INTO flr_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Uhangire imirondo itaanu kuguma. Neꞌmirondo ndatu ísigiiri, nayo ugihangire kuguma. Yugu mulondo gwa kalindatu, gwohe, ugugonye mwo kubiri imbere liꞌheema. ");
INSERT INTO flr_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","«Ha nyuma, kwiꞌrya mirondo itaanu, ushwekere iminaganizo makumi gataanu kwiꞌkano lyoꞌmulondo gweꞌmbeka. Na kwiꞌrya gindi ndatu, ushwekere igindi minaganizo makumi gataanu kwiꞌkano lyoꞌmulondo gwa mbere. ");
INSERT INTO flr_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Uyabiire imiringa, unatule mweꞌndoboro makumi gataanu, unazikoleese mu kushwekera kweꞌminaganizo yeꞌyo mirondo ibiri, gira iyo mirondo yombi kibe kindu kiguma. ");
INSERT INTO flr_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","«Yugwo mulondo gwoꞌkubwikira kwiꞌheema, ugunaganie mu kuguyajuulira inyuma lyalyo. ");
INSERT INTO flr_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ibihande byeꞌmirondo íbigalembeera mu matambi giꞌheema, ubigonye-gonye, unabileke bikizi lembeera imbande zooshi ziꞌheema, hiꞌgulu lyoꞌkukizi libwikira. ");
INSERT INTO flr_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","«Ulingaanie neꞌkihunika mu mbu zeꞌbipanga, zinabe njiige ibara lidukula, neꞌkindi mu mbu ngomu, unabiyajuulire hiꞌgulu. ");
INSERT INTO flr_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«Uyabiire ibiti byaꞌkasiya, unalingaanie mweꞌmiganda yoꞌkuyimangika iheema. ");
INSERT INTO flr_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ngiisi muganda, gugakizi ba neꞌmeetere zina, ku sendimeetere makumi galindatu na ndatu. ");
INSERT INTO flr_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Iyo miganda yoshi, igaaba neꞌmishigo ibiri-ibiri, yoꞌkukizi gisikamya. ");
INSERT INTO flr_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","«Iyo miganda yiꞌheema lyeꞌmihumaanano, ugilingaanie kwokuno: Ku luhande lweꞌkisaka, ulingaanie imiganda makumi gabiri. ");
INSERT INTO flr_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ulingaanie neꞌbiterekero byayo makumi gana byeꞌharija. Ukizi biika ibiterekero bibiri mwiꞌdako lya ngiisi muganda, bikizi gwata imishigo yagwo yombi. ");
INSERT INTO flr_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Uluhande lweꞌmbembe lwiꞌheema nalwo, ululingaanize igindi miganda makumi gabiri. ");
INSERT INTO flr_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Ulingaanie neꞌbiterekero makumi gana byeꞌharija. Ku ngiisi muganda, ukizi tereka bibiri-bibiri. ");
INSERT INTO flr_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","«Imuga (yo neꞌnyuma liꞌheema), ulingaanie yeꞌgindi miganda ndatu. ");
INSERT INTO flr_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Unalingaanie neꞌgindi ibiri ku ngiisi kagongo keꞌnyuma. ");
INSERT INTO flr_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Iyo miganda yombi iliikane mwiꞌdako. Si hiꞌgulu ishwekerwe kuguma, mu kukoleesa imbete. Bibe kwokwo, ku ngiisi kagongo. ");
INSERT INTO flr_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kwokwo, ku mbeka yiꞌheema, kugabeera imiganda munaana. Ibiterekero byayo, bigaaba ikumi na ndatu, binabe bikatulwa mu harija. Mwidako lya ngiisi muganda, hakizi biikwa ibiterekero bibiri-bibiri. ");
INSERT INTO flr_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«Ulingaanie neꞌnzizi mu biti byaꞌkasiya. Ngiisi luhande lube inzizi zitaanu, zikizi sikamya imiganda yiꞌheema. Uluhande luguma lugakizi yabiira inzizi zitaanu. ");
INSERT INTO flr_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Noꞌlundi zindi zitaanu. Noꞌluhande lweꞌmuga (yo neꞌnyuma liꞌheema), nalwo lugayabiira inzizi zitaanu. ");
INSERT INTO flr_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Uluzizi lwa ha kati keꞌmiganda, luhulukaane uluhande noꞌlundi lwiꞌheema. ");
INSERT INTO flr_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Iyo miganda yoshi, ugibugiirize kweꞌnooro, unatule neꞌmbete zeꞌnooro, ízigaginaniiza ku nzizi. Yizo nzizi nazo, uzibugiirize kweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Kwokwo, keera nakuyereka hano ku mugazi ngiisi kwo ugayubaka iheema lyeꞌmihumaanano. Aaho! Kubaagage kwo ugakizi kulikira. ");
INSERT INTO flr_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Ulingaanie ugundi mulondo mu nuzi zeꞌkitaani, na zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, gunamanikwe mu kati kiꞌheema. Unagulimbiise neꞌbishushanio bya bamakerubi. ");
INSERT INTO flr_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Yugwo mulondo, ugushweke ku nguliro zina zeꞌbiti byaꞌkasiya. Ukoleese indoboro ízikatulwa mu nooro. Yizo nguliro, uzibugiirize kweꞌnooro, unazitereke ku biterekero bina, íbikatulwa mu harija. ");
INSERT INTO flr_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Yizo ndoboro, zibe zo ugashwekera kwoꞌmulondo. Unasingulage Akajumba keꞌKihango ha nyuma lya yugwo mulondo. Yugwo mulondo, gwo gugahandula Ahandu Heeru naꞌHandu Heeru bweneene. ");
INSERT INTO flr_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","«Lyeryo, utumbike gulya mutumbikizo ku Kajumba keꞌKihango, hanali handu hoꞌkulonga ulukogo. ");
INSERT INTO flr_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ha nyuma, uyabiire kalya kashasha keꞌmikate, unakabiike halya Handu Heeru, uluhande lweꞌmbembe. Kirya kiterekero kyaꞌmatara nakyo, kinabiikwe ulweꞌkisaka, ikajabo kaako. ");
INSERT INTO flr_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Ha nyuma, ulingaanie ugundi mulondo mukomu mu nuzi zeꞌkitaani, na zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, gunamanikwe ha mulyango gwiꞌheema. Yugwo mulondo, ugulimbiise bwija, ");
INSERT INTO flr_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","unagumanike ku nguliro zitaanu, mu biti byaꞌkasiya. Unazibugiirize kweꞌnooro. Yizo nguliro, uzibiike kweꞌbiterekero bitaanu, binabe bikatulwa mu miringa. ");
INSERT INTO flr_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Uyabiire ibiti byaꞌkasiya, unalingaanie mwaꞌkatanda koꞌkusiriigiza kwaꞌmatuulo. Yako katanda, kabe neꞌmbande zina íziyumiini. Kwokwo, ngiisi luhande lube neꞌmeetere zibiri neꞌkitolo. Ikimango nakyo, ibe meetere nguma neꞌkitolo. ");
INSERT INTO flr_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ku ngiisi kagongo, ukuneneke íkiri ngiꞌhembe. Ha nyuma, kooshi unakabugiirize kweꞌmiringa. ");
INSERT INTO flr_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","«Ulingaanie neꞌbirugu bya kwingi-kwingi mu miringa. Ulingaanie neꞌbirugu byoꞌkubiikira umunyota-kiiko, neꞌmbahwa zoꞌkushamata, neꞌnzoozo zoꞌkubiikira umuko, neꞌkanya, neꞌsheetezo. ");
INSERT INTO flr_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","«Ha nyuma, mu yeyo miringa, unalingaanie akayungiro. Na ku ngiisi kagongo kaako, unanike kweꞌmbete, ízikatulwa mu miringa. ");
INSERT INTO flr_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Yako kayungiro, ukabiike mu kati kaꞌkatanda, kanagwate ku matambi gaako. Kahikire mu kati-kati keꞌkimango kyaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","«Ha nyuma, unayabiirage ibiti bibiri bila byaꞌkasiya, unabibugiirize kweꞌmiringa. ");
INSERT INTO flr_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Yibyo biti, byo bagakizi betulira kwaꞌkatanda. Ubishogeke mu mbete íziri mu matambi gaako. ");
INSERT INTO flr_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Yako katanda kagirwe mu biti, na mu nda yako, mube ubukunda. Ngiisi kwo nakuyereka hano ku mugazi, kube kwo ugakalingaania. ");
INSERT INTO flr_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Yiryo iheema lyeꞌmihumaanano, ulisoose ulubuga, lunazitirwe neꞌmirondo yeꞌkitaani. Imirondo yoꞌluhande lweꞌkisaka, igaaba neꞌmeetere makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Inashwekerwe ku nguliro makumi gabiri, ízikatulwa mu miringa. Ngiisi nguliro, inaterekwe ku biterekero byeꞌmiringa. Si indoboro neꞌnzuuma byoꞌkushwekerwa ku nguliro, byohe bitulwe mu harija. ");
INSERT INTO flr_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","«Imbembe yiꞌheema, izitirwe na mwene gwogwo mulondo gweꞌmeetere makumi gataanu. Yugwo mulondo gunashwekerwe ku nguliro makumi gabiri, na ku biterekero byeꞌmiringa. Si indoboro, neꞌnzuuma, byoꞌkushwekerwa ku nguliro, byohe bitulwe mu harija. ");
INSERT INTO flr_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","«Imuga yalyo, ibiikwe mwene gwogwo mulondo. Si gwohe, gube neꞌmeetere makumi gabiri na zibiri, gunashwekerwe ku nguliro ikumi. Yizo nguliro, ziterekwe ku biterekero ikumi. ");
INSERT INTO flr_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","«Isheere, ulubuga lube neꞌmeetere makumi gabiri na zitaanu. Yulwo luhande, lwo mugabiika umulyango. ");
INSERT INTO flr_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Yugwo mulondo gwoꞌluhande lweꞌmulyango, gube neꞌmeetere zirinda, neꞌsendimeetere makumi gataanu. Hanabe inguliro zishatu, neꞌbiterekero byazo bishatu. ");
INSERT INTO flr_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","«Noꞌlundi luhande lweꞌmulyango nalwo, umulondo gube neꞌmeetere zirinda, neꞌsendimeetere makumi gataanu. Hanabe inguliro zishatu, neꞌbiterekero byazo bishatu. ");
INSERT INTO flr_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Umulyango gwoꞌkuyingira mu lubuga, gubiikwe kwoꞌmulondo gweꞌnuzi zeꞌkitaani, na zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. Yugwo mulondo, gugaaba gweꞌmeetere mwenda, gunalimbiisibwe bwija, gunashwekerwe ku nguliro zina, ndereke ku biterekero byazo bina. ");
INSERT INTO flr_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","«Yizo nguliro zooshi za mu lubuga, zinanirizibwe neꞌnzuuma kuguma neꞌndoboro, íbikatulwa mu harija. Zinajingirizibwe ku biterekero, íbikatulwa mu miringa. ");
INSERT INTO flr_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","«Yulwo lubuga, lube neꞌmeetere makumi gana na zina, ku meetere makumi gabiri na zibiri. Neꞌkimango, zibe meetere zibiri neꞌkitolo. Imirondo yoshi mishwekere kwo, ihangwe mu nuzi ngomu zeꞌkitaani. Neꞌbiterekero bitulwe mu miringa. ");
INSERT INTO flr_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","«Ku yiryo iheema lyeꞌmihumaanano, ngiisi kindi kindu íkigakoleesibwa kwo, kiri neꞌmbambo, bitulwe mu miringa. Bibe kwokwo, kiri na mu lubuga. ");
INSERT INTO flr_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Ubwire Abahisiraheeri kwo bakizi leeta amavuta miija geꞌmizehituuni, gira amatara gakizi yama gayasiri. ");
INSERT INTO flr_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Yago matara gabiikwe mwiꞌheema lyeꞌmihumaanano, imbere lyoꞌmulondo gwoꞌkusiika Akajumba keꞌKihango. Harooni naꞌbagala bakizi gayasa imbere lyani, ukulyokera kabigingwe halinde shesheezi. Yulwo lubaaja, Abahisiraheeri bagayama balusimbahiri halinde ku bibusi byabo byoshi. ");
INSERT INTO flr_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«E Musa, mu kati kaꞌBahisiraheeri booshi, uhandulage mwene winyu wa Harooni, gira akuyegeere. Akizi ngolera umukolwa gwoꞌbugingi, kuguma naꞌbagala: Nadabu, na Habihu, na Heryazaari, na Hitamaari. ");
INSERT INTO flr_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","«Uyo Harooni, umúhangire imirondo mitaluule, inakizi yerekana kwo ali munalushaagwa. ");
INSERT INTO flr_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Iyo mirondo, ubwire banaluganda ábali noꞌbuhinga, kwo bo bagagihanga. Yoyo Harooni, ye gayimikwa angolere nga mugingi. ");
INSERT INTO flr_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","«Imirondo yo bagamúhangira, yo yeyi: ishaho nzonere ha kifuba, niꞌkangaata, niꞌkooti, niꞌkanju, noꞌmulondo gwoꞌkusoosa kwiꞌtwe, noꞌmukaba. Iyo mirondo mitaluule, mwene winyu wa Harooni, kiri na bagala baage, babe bo bagakizi giyambala, gira lyo bakizi ngolera umukolwa gwoꞌbugingi. ");
INSERT INTO flr_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Iyo mirondo, banaluganda bagiluke mu nuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, na mu nuzi zeꞌkitaani, na mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Ikangaata, lilukwe mu nuzi zeꞌkitaani, na mu nuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, na mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Hakizi ba neꞌbihogo bibiri, byoꞌkukizi lishwekera ha kitugo. ");
INSERT INTO flr_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Umukaba gwalyo, bagulingaanie kwakundi mu nuzi zeꞌkitaani, na mu zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, na mu nooro. Banaguhangire kwiꞌkangaata, halinde kibe kindu kiguma naaho. ");
INSERT INTO flr_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","«Ha nyuma, unayabiire amabuye gabiri miija geꞌhonikisi, unagahokoorore, mu kugayandika kwaꞌmaziina ga bagala Hisiraheeri. ");
INSERT INTO flr_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Kwiꞌbuye lya mbere, uyandike kwaꞌmaziina ndatu. Na ku lya kabiri, uyandike kwaꞌgandi ndatu. Yago maziina, gayandikwe ukukulikirana na kwo balondiini ku mabutwa. ");
INSERT INTO flr_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Mu kugayandika, ukizi gahokoorora nga kwokulya bali mu hokoorora akamangu. Ha nyuma, unananike kweꞌmigwaso yeꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Yago mabuye kwo gali gombi, unagahogeke mu birya bihogo biꞌkangaata. Ko kagaaba kalangikizo koꞌkukengeeza irya milala ikumi niꞌbiri yaꞌBahisiraheeri. Yago maziina, Harooni akizi gayambala ku bitugo byage, mu kuyija imbere lyani. ");
INSERT INTO flr_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","«Iyo migwaso, ikizi tulwa mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Ha nyuma, unaluke imigufu ibiri mu nooro muguuhya, ibe nga mugozi. Kwokwo, iyo migufu neꞌrya migwaso, ubinanike kuguma. ");
INSERT INTO flr_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Ha nyuma, ulingaanie ishaho yoꞌkuhambuulana mwo. Iyo shaho, ihangwe nga kwo bakahanga ikangaata, mu nuzi zeꞌkitaani, na mu nuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, na mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Iyo shaho, ugigonye mwo kubiri. Ngiisi luhande lube neꞌsendimeetere makumi gabiri na zibiri. ");
INSERT INTO flr_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","«Iyo ishaho, unagilimbiise neꞌmiziizi ina yaꞌmabuye ágabuyahiri. Mu muziizi gwa mbere, mubiikwe ibuye lyeꞌsaridwane, na lyeꞌtopaazi, na lyeꞌhemeroode. ");
INSERT INTO flr_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Mu muziizi gwa kabiri munabiikwe ibuye lyeꞌsikaribukile, na lyeꞌsafiiri, na lyeꞌdyama. ");
INSERT INTO flr_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Mu muziizi gwa kashatu, munagende ibuye lyeꞌyasito, na lyeꞌkarinaline, na lyeꞌhametisito. ");
INSERT INTO flr_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Mu muziizi gwa kana munagende ibuye lyeꞌkirisolite, na lyeꞌhonikisi, na lyeꞌyasipi. Yago gooshi, gananikwe kweꞌmigwaso íkatulwa mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","«Yago mabuye gooshi, umuharuuro gwago, gabe ikumi na gabiri. Ganahokoororwe kwaꞌmaziina geꞌmilala ikumi niꞌbiri yaꞌBahisiraheeri. Ngiisi ibuye, libe kwaꞌkamangu koꞌmulala muguma-muguma. ");
INSERT INTO flr_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Iyo shaho, ugilukire imigufu ibiri mu nooro muguuhya. ");
INSERT INTO flr_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Unagitulire neꞌmbete zibiri mu nooro. Yizo mbete, unazishwekere ku tusongo-songo twombi tweꞌlugulu tweꞌrya shaho. ");
INSERT INTO flr_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Iyo migufu, ugihogeke mu zirya mbete zombi. ");
INSERT INTO flr_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Amatwe gombi geꞌmigufu, ugananike kwiꞌrya migwaso yombi íri kweꞌbihogo, halinde ishaho ikizi ba ku kikaraza. ");
INSERT INTO flr_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","«Ha nyuma, unashubi tula izindi mbete zibiri mu nooro, unazinanike imbande zombi ziꞌdako ku shaho. Zinanikirwe mu nda, ahandu áhaloziri kwiꞌkangaata. ");
INSERT INTO flr_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Unashubi tula izindi mbete zibiri mu nooro, unazinanike ku tusongo-songo twiꞌdako tweꞌbihogo byombi íbiri kwiꞌkangaata, ngiisi hoꞌmukaba guleeziri. ");
INSERT INTO flr_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Iyo shaho uginanike kwiꞌkangaata, mu kugishwekera ku mbete neꞌmigozi íkalukwa mu nuzi ziꞌbara lya namukungumo. Kwokwo, lyo itatere, si iyame igwatiriiri umugozi gwiꞌkangaata. ");
INSERT INTO flr_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«Iyo shaho yoꞌkuhambuulana mwo, inayandisirwi kwaꞌmaziina geꞌmilala ikumi niꞌbiri yaꞌBahisiraheeri, ikyanya Harooni agakizi giyambala ha kifuba, anayingire Ahandu Heeru, ngakizi kengeera abandu baani. ");
INSERT INTO flr_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Iyo shaho, ku kyanya Harooni agakizi yija imbere lyani, amabuye goꞌkuhambuulana mwo, gakizi ginagana kwo ha kifuba. Kwiꞌyo njira, agakizi yami sobanukirwa neꞌshungi zaani, ku luhande lwaꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Ha nyuma, uhange ikooti liꞌbara lya namukungumo. Yiryo ikooti, umugingi agakizi liyambalira iꞌdako liꞌkangaata. ");
INSERT INTO flr_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ulisige kwoꞌbutule ha kati, gira akizi leeza mwiꞌtwe. Yubwo butule, ububiike kweꞌkindi kitubiko, lyo butabereke. ");
INSERT INTO flr_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","«Unayabiire inuzi ziꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, unagire mwo íbishushiri ibitumbwe byaꞌmakomamanga. Yiryo ikooti, ikano lyalyo liꞌdako, ulilimbiise neꞌminaganizo. Neꞌyo minaganizo, ugishwekere kwo birya íbiri nga bitumbwe byaꞌmakomamanga. Ha kati ka ngiisi makomamanga, uhabiike imbegere ízikatulwa mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Yizo mbegere, na yago makomamanga, ubibiike-biike kwokwo, halinde usoose ikano lyoshi. ");
INSERT INTO flr_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","«Yiryo ikooti, Harooni akizi liyambala mu kugira umukolwa gwage gwoꞌbugingi. Ikyanya agakizi yingira Ahandu Heeru, imbere lya Nahano, kiri na mu kuhuluka, yizo mbegere zigakizi laka. Kwokwo, lyo atakengeere afwira yo. ");
INSERT INTO flr_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Ha nyuma, unalingaanie ubungeni-ngeni mu nooro muguuhya, unabuhokoorore nga kwo bangagira akamangu, mu kuyandika kwo gano magambo: “Biri bitaluule imwa Nahano.” ");
INSERT INTO flr_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Yubwo bungeni-ngeni, ubushwekere kweꞌhirondo hiꞌbara lya namukungumo, unahishwekere ku mulondo gwoꞌkusoosa kwiꞌtwe, uluhande lweꞌmbere. ");
INSERT INTO flr_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Harooni akizi buyambala ha malanga gaage. Kwokwo, kwo agakizi ba abetwiri amahube gaꞌBahisiraheeri, anayiji ndangira ituulo mu kubahuunira ulukogo. Na kwiꞌyo njira, nie Nahano na ndonge ukukoga amahube gaabo. ");
INSERT INTO flr_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Uyo Harooni, umúhangire ikanju noꞌmulondo gwoꞌkusoosa kwiꞌtwe mu kitaani, unamúlukire na mwoꞌmukaba gwoꞌmulimbo. ");
INSERT INTO flr_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«Bagala baage nabo, ubahangire amakanju, neꞌmikaba, neꞌngofeera. Ikyanya bagakizi biyambala, lyaꞌbandu bagakizi baheereza ulushaagwa, banakizi basiima. ");
INSERT INTO flr_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Yibyo byambalwa, ubiyambike mwene winyu wa Harooni, kiri na bagala baage. Ha nyuma, unabanjiigire amavuta mu kubayimika, gira bakizi ngolera umukolwa gwoꞌbugingi. ");
INSERT INTO flr_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","«Ubahangire kwakundi noꞌtubutura mu nuzi zeꞌkitaani. Yutwo, two bagakizi bisha mwoꞌbukondwe bwabo. ");
INSERT INTO flr_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ngiisi kyanya bagakizi yingira mwiꞌheema lyeꞌmihumaanano, kandi iri kuyegeera akatanda gira bagire imikolwa yoꞌbugingi Ahandu Heeru, bakizi biyambala byoshi. Kwokwo, lyo batayiji kengeera bayifunda mu bitali nga byo, banafwe. Yulwo lubaaja, lugayama ho imwa Harooni, kiri na imweꞌbibusi byage, halinde imyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Ikyanya mugakizi yimika abagingi, mukizi gira kwokuno: Ukizi yabiira ishuuli, neꞌbipanga bibiri bizira kashembo. ");
INSERT INTO flr_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Uyabiire noꞌmushyano mulembu gweꞌngano, unaguyokye mweꞌmikate mizira saama, neꞌbitumbula neꞌgaleeti bizira saama, bifushe mwaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Iyo mikate yoshi, unagibiike mu kitiri kiguma, unagindangire, kuguma neꞌyo shuuli, na yibyo bipanga byombi. ");
INSERT INTO flr_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","«Lyeryo, Harooni naꞌbagala, ubahise ha mulyango gwiꞌheema lyeꞌmihumaanano, unabashukire ho. ");
INSERT INTO flr_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Wámali yusa, uyabiire birya byambalwa byoꞌbugingi, unabiyambike Harooni. Umúyambike ikanju, niꞌkooti, niꞌkangaata, neꞌshaho. Umúshweke na gulya mukaba úguli kwiꞌkangaata. ");
INSERT INTO flr_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Umúsoose na gulya mulondo kwiꞌtwe, ukabuli gunanika kwaꞌkalangikizo i malanga, koꞌkubonesa kwo akola mutaluule. ");
INSERT INTO flr_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","«Ha nyuma, uyabiire galya mavuta goꞌkushiiga ku byataluulwa, unagashiige Harooni mwiꞌtwe. ");
INSERT INTO flr_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Abagala nabo, ubayegeze, unabayambike amakanju. ");
INSERT INTO flr_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Unabashweke imikaba mu bibuno, unabasoose imirondo ya kwiꞌtwe. Kwokwo, kwo Harooni naꞌbagala, bagayimikwa babe bagingi. Na yubwo bugingi bwabo, bugaaba bweꞌmyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«Lyeryo, ha mulyango gwiꞌheema lyeꞌmihumaanano, uleete heꞌrya shuuli. Harooni naꞌbagala, banagibiike amaboko mu ruhanga. ");
INSERT INTO flr_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Unagitongeerere ho, imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Umuko gwayo, unakizi guleeza mwoꞌmunwe, iri unaguhembeza ku tugongo twaꞌkatanda koꞌkusiriigiza kwaꞌmatuulo. Na ngiisi úgugasigala, uguyoonere mwiꞌdako lyeꞌbiterekero byaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","«Yaho ku katanda, usiriigize kwoꞌlusha úlubwisiri ibijogombe, niꞌrembe lyoꞌbudiku, neꞌfiko zombi, kiri neꞌbinyule byazo. ");
INSERT INTO flr_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Si inyama ígasigala kwiꞌyo shuuli, ugiyabiire, unagendi giyokera imbuga lyeꞌshumbi, kuguma noꞌluhu lwayo, kiri naꞌmashe gaayo. Yiryo, lyo ligaaba ituulo lyoꞌkukogwa ibyaha biinyu. ");
INSERT INTO flr_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«Ha nyuma, mu yibyo bipanga byombi, muyabiire kiguma. Unabwire Harooni naꞌbagala kwo bakibiike kwaꞌmaboko mu ruhanga, ");
INSERT INTO flr_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","unakitongeere. Noꞌmuko gwakyo, ugushangire ku mbande zooshi zaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Yikyo kipanga, ukitenge mihoole-mihoole, unashuke ibya mu nda byakyo, neꞌbirenge, unabifushe kuguma niꞌtwe, neꞌbindi bitondola. ");
INSERT INTO flr_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ha nyuma, yikyo kipanga kyoshi, ukiyokere Nahano ku katanda. Yiryo ituulo, umushiiriri gwalyo guganjambaaza ngana-ngana! Niehe nie Nahano. ");
INSERT INTO flr_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«Uyabiire kirya kindi kipanga. Harooni naꞌbagala banakibiike kwaꞌmaboko mu ruhanga. ");
INSERT INTO flr_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Naawe unakitongeere. Umuko gwakyo, unaguyabiire kwo, unagushiige Harooni naꞌbagala ku kutwiri kweꞌlulyo, na ku kingumwe-ngumwe kyoꞌkuboko kweꞌlulyo, na kwiꞌno lihamu lyoꞌkugulu kweꞌlulyo. Umuko úgugasigala, unagushangire imbande zooshi zaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","«Ha nyuma, uyabiire ku muko úguli ku katanda, unayabiire na ku mavuta goꞌkushiiga ku byataluulwa, unabishangire ku byambalwa bya Harooni, na ku byaꞌbagala. Kwokwo, lyo Harooni agaaba keera ataluulwa imwani, naꞌbagala, kiri neꞌbyambalwa byabo. ");
INSERT INTO flr_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«Ha nyuma, ku kirya kipanga, uyabiire ibinyule, noꞌmukira, neꞌndambalalo, niꞌrembe, neꞌfiko zombi, kuguma neꞌbinyule íbiziri kwo, neꞌkisingiira kyeꞌlulyo. (Yikyo kipanga, kinabe kyo kitaluule.) ");
INSERT INTO flr_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","«Mu kirya kitiri kyeꞌmikate mizira saama íkyatangwa imbere lyani, uyabiire mwoꞌmukate muguma, neꞌkitumbula kiguma mu bikakalangwa naꞌmavuta, neꞌgaleeti. ");
INSERT INTO flr_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Yibyo byoshi, unabifumbase Harooni naꞌbagala. Unababwire kwo babilengeze imbere lyani mu kubindangira. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Yibyo byoshi, unashubi biyabiira, unabisiriigize ku katanda, ku lirya lindi ituulo lyoꞌkusiriiza lwoshi. Niehe, nie Nahano. Yago matuulo, umushiiriri gwago gunanjambaaze bweneene. ");
INSERT INTO flr_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","«Ha nyuma, yikyo kipanga kyo wayimika mwo Harooni, uyabiire umushaya gwakyo, unagulengeze imbere lyani. Yiryo ituulo, gwo gugaaba mutuli gwawe. ");
INSERT INTO flr_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«Ikyanya Harooni naꞌbagala bagayimikwa, uyabiire gulya mushaya gweꞌkipanga íkyâli mali tangwa, kiri neꞌnyama yeꞌkisingiira kyeꞌlulyo, unabilengeze imbere lyani mu kubindangira. ");
INSERT INTO flr_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Yibyo bitondola, ngiisi kyanya Abahisiraheeri bagakizi ndangira amatuulo goꞌkuyerekana ingoome, bagakizi bilyosa, banabiheereze Harooni naꞌbagala. Yago, go matuulo go bagakizi ndangira. ");
INSERT INTO flr_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Ikyanya umugingi Harooni agashaaja, ibyambalwa byage bitaluule bihaabwe bagala baage, babe bo bagakizi biyambala mu kuyimikwa. ");
INSERT INTO flr_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ngiisi úgakizi yimikwa mu bagala baage, kwo ye mugingi ahandu ha yishe, agakizi biyambikwa ku siku zirinda. Anakizi biyingirana mwiꞌheema lyeꞌmihumaanano, anangolere Ahandu Heeru. ");
INSERT INTO flr_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Inyama za kirya kipanga kitaluule, uzideekere Ahandu Heeru. ");
INSERT INTO flr_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ha nyuma, unaheereze Harooni naꞌbagala, baziliire ha mulyango gwiꞌheema lyeꞌmihumaanano, kuguma neꞌrya mikate íkasigala mu kitiri. ");
INSERT INTO flr_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ikyanya bagayimikwa, yibyo íbikatangwa hiꞌgulu lyoꞌkukogwa ibyaha, boohe naaho bo bagaabilya. Si ndaaye gundi úhangwirwi ukubilya kwo. Bigaaba bikola bitaluule. ");
INSERT INTO flr_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ngiisi inyama íyangalaala, kandi iri mikate, bikola bitaluule. Ku yukwo, bitaki liibwe, si bisiriizibwe mu muliro. ");
INSERT INTO flr_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«Kwokwo, kwo ugakizi girira Harooni, naꞌbagala, ukukulikirana na ngiisi byo nakutegeka. Bagaahisa isiku zirinda, bagweti bagataluulwa. ");
INSERT INTO flr_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ngiisi lusiku, hakizi tangwa ishuuli, libe ituulo lyoꞌkukogwa ibyaha. Kwokwo, lyo ugakizi yeruusa akatanda, unakataluule, mu kukashiiga kwaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Muhise isiku zirinda, mugweti mugakayeruusa. Ha nyuma, yako katanda kagaaba kakola kataluule. Kiri na ngiisi íkigakahika kwo, nakyo kigaaba kikola kitaluule. ");
INSERT INTO flr_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Yako katanda, mukizi katangira-tangira kwaꞌmatuulo goꞌkusiriiza lwoshi ngiisi lusiku. Mukizi tanga ibyana-buzi bibiri byoꞌmwaka muguma. ");
INSERT INTO flr_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kiguma kikizi tangwa ku mukyo. Neꞌkyabo kinatangwe kabigingwe. ");
INSERT INTO flr_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Yikyo kyanabuzi kya mbere, ikyanya ugakizi kitanga, ukizi tanga neꞌbilo bishatu byoꞌmushyano mulembu, gunabe mufushe mweꞌlitiri nguma neꞌkitolo yaꞌmavuta mayunguule bwija. Munatange niꞌrengo liguma lyeꞌdivaayi. Yago go gagakizi ba matuulo geꞌdivaayi. ");
INSERT INTO flr_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","«Neꞌkyanya mugakizi tanga kirya kibuzi kyaꞌkabigingwe, ukizi tanga niꞌtuulo lyoꞌmushyano, na lyeꞌkinywebwa, nga byebirya íbyatangwa ku mukyo. Umushiiriri gwa yago matuulo, gugakizi njambaaza. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Yago matuulo goꞌkusiriiza, gakizi tangwa imbere lyani, halinde ku bibusi biinyu byoshi. Gagakizi tangirwa imbere lyoꞌmulyango gwiꞌheema lyeꞌmihumaanano. Haaho, ho nienyene ngakizi mùgwana, ninamùganuulize ho. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","«Haaho ho ngakizi gwanana Abahisiraheeri. Ubulangashane bwani, bunahayeruuse, hakizi ba heeru. ");
INSERT INTO flr_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Emwe! Iheema lyeꞌmihumaanano, kiri naꞌkatanda koꞌkusiriigiza kwaꞌmatuulo, ngabiyeruusa, bikizi ba byeru. Kiri Harooni naꞌbagala, ngabataluula, gira bakizi ngolera umukolwa gwoꞌbugingi. ");
INSERT INTO flr_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ngola ngatuula mu Bahisiraheeri, na mbe ndi Rurema wabo. ");
INSERT INTO flr_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Kwokwo, lyo bagaamenya kwo nie Nahano, Rurema wabo. Niehe, nie kabalyosa mu kihugo kyeꞌMiisiri, gira nyiji tuula mu kati kaabo. Niehe, nie Nahano, Rurema wabo. ");
INSERT INTO flr_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Ulingaanie akatanda koꞌkuyokera kwoꞌmubadu. Yako katanda, ukagire mu biti byaꞌkasiya. ");
INSERT INTO flr_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Neꞌmbande zaako kwo ziri zina ziyumaane, sendimeetere makumi gataanu ku makumi gataanu. Neꞌkimango, kigaaba kyeꞌmeetere nguma. Utugongo twako, tukwiriiri tunaniirane naꞌkatanda koonyene, kinabe kindu kiguma. ");
INSERT INTO flr_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","«Yako katanda kooshi, ukabugiirize kweꞌnooro muguuhya. Ugibugiirize ku luhande lwa hiꞌgulu, na mu mbande zooshi, na ku tugongo, unasoose na ku mihiro. ");
INSERT INTO flr_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Yako katanda, ukalingaanize neꞌmbete zibiri mu nooro. Uzinanike imbande zombi, zinabe ziri mu lolana. Yizo mbete, zinanikwe mwiꞌdako lyeꞌmihiro, bwo zo zigakizi koleesibwa mu kushogeka mweꞌbiti byoꞌkukabetulira kwo. ");
INSERT INTO flr_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Yibyo biti, bikwaniini bibaajwe mu kiti kyaꞌkasiya, binabugirizibwe kweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","«Yako katanda, kakizi biikwa imbere lyoꞌmulondo úguhandwiri Akajumba keꞌKihango. Kuli kudeta imbere lyoꞌmutumbikizo gwoꞌkuleeta ulukogo. Haaho, ho ngakizi kugwanana. ");
INSERT INTO flr_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Yaho ku katanda, ikyanya Harooni agakizi gendi tanduula amatara ngiisi lusiku, akizi yokera kwoꞌmubadu gwoꞌmuhongolo mwija. ");
INSERT INTO flr_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Neꞌkyanya agakizi gendi yasa amatara kabigingwe, ashubi guyokera kwo. Yago matuulo, mukizi gayokya ngiisi lusiku, buzira kuluha, halinde ku bibusi biinyu byoshi. ");
INSERT INTO flr_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Yako katanda, hatagire ulusiku lwo mugayokera kwoꞌgundi-gundi mubadu, kandi iri mutangira kwaꞌmatuulo goꞌkusiriiza lwoshi, kandi iri geꞌngano. Mutanakolwe mbu muyonere kwaꞌmatuulo geꞌdivaayi. ");
INSERT INTO flr_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Harooni agakizi kayeruusa liguma naaho ku mwaka, mu kuyonera umuko ku tugongo twako, libe ituulo lyoꞌkukogwa ibyaha. Yukwo kukayeruusa, kugakizi koleka liguma naaho ku mwaka, halinde ku bibusi biinyu byoshi. Kali kataluule bweneene imwani. Niehe, nie Nahano.» ");
INSERT INTO flr_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ha nyuma, Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Ikyanya ugaharuura Abahisiraheeri booshi, ngiisi muguma wabo akwiriiri andangire ituulo. Kwokwo, ikyanya mugakizi baharuura, mutakengeere mwalonga ikiija. ");
INSERT INTO flr_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","«Ngiisi Muhisiraheeri úgaharuurwa, akwiriiri atange ikingorongoro kyeꞌgarama zitaanu zeꞌharija, ukukulikirana neꞌkigero kyo bali mu koleesa mwiꞌheema lyeꞌmihumaanano. Yiryo, liri ituulo lyo agaaba andangira. ");
INSERT INTO flr_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Yiryo ituulo, likizi tangwa na ngiisi muguma winyu, ukulyokera ku mundu weꞌmyaka makumi gabiri. ");
INSERT INTO flr_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Neꞌkyanya mugakizi lindangira, umugale atagire mbu asumburuse ku yizo garama zitaanu zeꞌharija. Noꞌmukeni atazinihye kwo. Yiryo, liri ituulo, liri lya kukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Yibyo bindu, ukizi biyakiira mu Bahisiraheeri. Unabikoleese ku mikolwa ya mwiꞌheema lyeꞌmihumaanano. Kwokwo, lyo mugakizi yikengeeza imwa Nahano, halinde mulonge ukuguluulwa.» ");
INSERT INTO flr_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Ulingaanie umutanga gwoꞌkuyikarabira mwo. Yugwo mutanga, gutulwe mu miringa, kuguma neꞌkiterekero kyagwo. Ha nyuma, unagubiike ha kati kiꞌheema lyeꞌmihumaanano, naꞌkatanda koꞌkusiriigiza kwaꞌmatuulo. Unagudugumulire mwaꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Yago miiji, Harooni na bagala baage bakizi gakoleesa, mu kuyikaraba amaboko naꞌmagulu. ");
INSERT INTO flr_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ikyanya bagakizi yingira mwiꞌheema lyeꞌmihumaanano, bakizi gayikaraba, kiri neꞌkyanya bagakizi yegeera ha katanda, mu kundangira amatuulo goꞌkusiriiza. Bakizi gira kwokwo, gira batayiji kengeera bafwa. ");
INSERT INTO flr_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Bakwiriiri bakizi tee yikaraba amaboko naꞌmagulu, batayiji kengeera bafwa. Yulwo lubaaja luyame ho, ukulyokera ku Harooni, halinde ku bibusi byabo byoshi.» ");
INSERT INTO flr_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ha nyuma, Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Ukizi yabiira amavuta goꞌmuhongolo mwija, ngeꞌbilo ndatu bya manemane, neꞌbilo bishatu byoꞌmudalasiini, neꞌbilo bishatu byoꞌlusheke, ");
INSERT INTO flr_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","neꞌbilo bitaanu byeꞌgindi mbiriri yoꞌmudalasiini. Yibyo bigero byoshi, bikizi hwanwa noꞌmuharuuro gweꞌkigero kyo bali mu koleesa mwiꞌheema lyeꞌmihumaanano. Ukizi yabiira neꞌlitiri zina zaꞌmavuta goꞌmuzehituuni. ");
INSERT INTO flr_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Yibyo byoshi, ukizi bifusha, gabe mavuta goꞌkushiiga ku byataluulwa, ganakizi ba noꞌmuhongolo mwija. ");
INSERT INTO flr_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Yago mavuta, ukizi gashiiga kwiꞌheema lyeꞌmihumaanano, na ku Kajumba keꞌKihango, mu kubitaluula. ");
INSERT INTO flr_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Ukizi gashiiga na ku kashasha, na ku birugu byako, kiri na ku kiterekero kyaꞌmatara, na ku birugu byakyo, na ku katanda koꞌkuyokera kwoꞌmubadu. ");
INSERT INTO flr_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Ukizi gashiiga na ku katanda koꞌkusiriigiza kwaꞌmatuulo, na ku birugu byako byoshi, kiri na ku mutanga kuguma neꞌkiterekero kyagwo. ");
INSERT INTO flr_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Yibyo byoshi, bikizi taluulwa, halinde binabe byeru bweneene. Kwokwo, na ngiisi íkigakizi bihika kwo, nakyo kigaaba kikola kitaluule. ");
INSERT INTO flr_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","«Yago mavuta, unagashiige Harooni kuguma naꞌbagala, gira bakizi ngolera umukolwa gwoꞌbugingi. ");
INSERT INTO flr_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Ubwire Abahisiraheeri: “Yago mavuta, gayame ga kukizi shiigwa ku byataluulwa, halinde ku bibusi byoshi. ");
INSERT INTO flr_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Haliko, hatagire úgagashiiga ku magala goꞌgundi mundu yeshi. Mutanâye gayenge, mbu mugakoleese mu mikolwa yinyu mwenyene. Mukuba, yaga mavuta gagayama-yama gali mataluule. Kiri na niinyu, mukizi gaharuura kwokwo. ");
INSERT INTO flr_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Amavuta mwene yago, ngiisi úgagalingaania, kandi iri agashiiga ugundi-gundi mundu útali mugingi, uyo akwiriiri atwibwe mu Bahisiraheeri.”» ");
INSERT INTO flr_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Nahano anashubi bwira Musa: «Ugire ibigero íbiyumiini bya bino bindu: amakama geꞌnatafi, na geꞌshekereeti, na geꞌkeribena, noꞌmubadu. ");
INSERT INTO flr_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Yibyo byoshi, ukizi bilingaania mwoꞌmubadu, nga kwokulya bali mu lingaania amalaasi. Unalunge mwoꞌmuunyu, gira kikabe kindu kyeru, íkyataluulwa. ");
INSERT INTO flr_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Yibyo byoshi, binashyebwe, bibe mushyano mulembu. Kwokwo, bigakizi koleesibwa mwiꞌheema lyeꞌmihumaanano. Bikizi koleesibwa imbere lyaꞌKajumba keꞌKihango. Mukuba, ho ngakizi kugwanana. Yugwo mubadu, gugaaba mutaluule bweneene imwinyu. ");
INSERT INTO flr_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Mutakolwe mbu muguyenge hiꞌgulu liinyu mwenyene. Si gugakizi taluulwa imwani. ");
INSERT INTO flr_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ngiisi úgaakolwa kwo alingaania umubadu mwene yugwo, mbu lyo gukizi músimiisa, uyo akwaniini atwibwe mu Bahisiraheeri.» ");
INSERT INTO flr_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Yuvwiriza! Keera natoola Bezaleeri mugala Uri, mwijukulu Huuri woꞌmulala gwaꞌBayuda. ");
INSERT INTO flr_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Namúyijuza mwoꞌMutima gwani, gira abe naluganda, anabe noꞌbwenge bwoꞌkukizi gira imikolwa ya kwingi-kwingi. ");
INSERT INTO flr_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Âli kizi yerekana íbisimisiizi amasu, mu kubitula mu nooro, na mu harija, na mu miringa. ");
INSERT INTO flr_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Agaahasha ukukizi baaja amabuye goꞌkukizi limbiisa, anakizi na baaja ibiti. Emwe! Agaaba naluganda ku ngiisi njira. ");
INSERT INTO flr_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","«Keera nabiika na Oholyabu mugala Ahisamaki woꞌmulala gwa Daani. Uyo ye gakizi mútabaala. Natoola naꞌbandi banaluganda. Kwokwo, ngiisi kwo nakuhuuna ibikolanwa, bo bagakizi bilingaania. ");
INSERT INTO flr_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","«Bagalingaania iheema lyeꞌmihumaanano, naꞌKajumba keꞌKihango, kuguma noꞌmutumbikizo gwako, kiri neꞌbindi birugu byoshi bya mu yiryo iheema. ");
INSERT INTO flr_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Banalingaanie naꞌkashasha, neꞌbirugu byako, neꞌkiterekero kyaꞌmatara íkyatulwa mu nooro, neꞌbirugu byakyo, naꞌkatanda koꞌkuyokera kwoꞌmubadu. ");
INSERT INTO flr_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Banalingaanie naꞌkatanda koꞌkusiriigiza kwaꞌmatuulo, kuguma neꞌbirugu byako. Banalingaanie noꞌmutanga, neꞌkiterekero kyagwo. ");
INSERT INTO flr_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Banalingaanie neꞌbyambalwa bitaluule byoꞌmugingiHarooni, kiri neꞌbya bagala baage. Yibyo byambalwa, byo bagakizi yambala, mu kukola imikolwa yoꞌbugingi. ");
INSERT INTO flr_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Bagakizi yenga naꞌmavuta, kuguma noꞌmubadu gwoꞌmuhongolo mwija. Yugwo mubadu gugakizi koleesibwa Ahandu Heeru. Biganalingaanibwa nga ngiisi kwo keera nakuyereka.» ");
INSERT INTO flr_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Ubwire Abahisiraheeri kwokuno: “Ulusiku lwani lweꞌSabaato, mukizi lusimbaha. Yulwo lusiku, kali kalangikizo ha kati kaani na niinyu, halinde ukuhisa ku bibusi byoshi. Ikyanya mugalusimbaha, lyo mugayerekana kwo nie Nahano, na kwo ngweti ngamùyeruusa. ");
INSERT INTO flr_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Kwokwo, mukizi lusimbaha, bwo luli lutaluule. Umundu, iri angalugayiriza, akwiriiri ayitwe. Na ngiisi úgalukola kwo, akwiriiri atwibwe mu bandu baage. ");
INSERT INTO flr_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Mukizi hisa isiku ndatu, mugweti mugaakola. Si ulusiku lwa kalinda lwohe, luli lutaluule imwa Nahano. Kwokwo, mukizi luluhuuka kwo. Ngiisi úgalukola kwo, akwiriiri ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Yulwo lusiku lweꞌSabaato, Abahisiraheeri bakwiriiri bakizi lusimbaha, halinde imyaka neꞌmyakuula. Kwokwo, kwo bagakizi simbahiisa Ikihango. ");
INSERT INTO flr_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Yulwo lusiku, kagaaba kalangikizo mu kati kaani naꞌBahisiraheeri, halinde imyakuula. Nie Nahano, nꞌgahisa isiku ndatu ngweti ngabumba igulu neꞌkihugo. Si ku lusiku lwa kalinda lwohe, nꞌgaleka umukolwa, nanaluhuuka.”» ");
INSERT INTO flr_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Nahano, iri akayusa ukuganuuza Musa yaho ku mugazi Sinaayi, anamúheereza galya mabuye gabiri mabaaje. Yago mabuye, go Rurema akayandika kwo zirya maaja noꞌkuboko kwage yenyene. ");
INSERT INTO flr_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Ikyanya Abahisiraheeri bakabona kwo Musa atinda bweneene ku mugazi, banakuumanira Harooni, banamúbwira: «Ewe! Kundu Musa akatushaaza i Miisiri, si tutaki yiji íbyamúkoleka kwo. Aaho! Utugirire ngana imigisi, gira ikizi turongoora.» ");
INSERT INTO flr_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Harooni, ti: «Aaho! Mushaaze amahereeni geꞌnooro ágali ku matwiri ga bakiinyu. Mushaaze kiri na ágali ku ga bagala biinyu, na ku ga banyere biinyu. Yibyo byoshi, munabindeetere.» ");
INSERT INTO flr_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kwokwo yago mahereeni, yabo bandu booshi banagashaaza, banagaheereza Harooni. ");
INSERT INTO flr_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Anagayakiira, anagajongolola, anagatula mwoꞌmugisi gweꞌnyana. Lyeryo, balya Bahisiraheeri booshi banayamiza kiranga, ti: «E balya, lolagi Rurema witu! Yoyu, ye katulyosa mu kihugo kyeꞌMiisiri.» ");
INSERT INTO flr_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Uyo Harooni, mbu abonage kwokwo, anayubaka akatanda imbere lyayo, anadeta kwiꞌzu lihamu: «Kusheezi, tugashambaalira ulusiku lukulu lwa Nahano.» ");
INSERT INTO flr_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kwokwo, iri bukakya shesheezi kare-kare, balya bandu banazindukiri tanga amatuulo goꞌkusiriiza, na goꞌkuyerekana ingoome. Balya booshi banabwatala, banatondeera ukuvwajagira, iri bananywa bweneene. Ha nyuma, banayimuka, banatondeera ukukina bwalaafwe, mu kugira íbitali nga byo. ");
INSERT INTO flr_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Haaho, Nahano anabwira Musa: «Manuka duba! Si yabo bandu baawe, balya ukalyosa i Miisiri, nabona kwo keera babihuuka bweneene. ");
INSERT INTO flr_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Kundu nꞌgabayerekeza injira yoꞌkutuula, halikago keera bagihusha. Keera bajongolola inooro, banagitula mwoꞌmugisi gweꞌnyana. Yugwo mugisi, bakola mu gufukamira, iri banagutangira amatuulo. Bagweti bagaadeta: “E balya, lolagi Rurema witu! Yoyu, ye katulyosa mu kihugo kyeꞌMiisiri.” ");
INSERT INTO flr_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","«Yaba bandu, mbayiji-yiji kwo bali mindagabika. ");
INSERT INTO flr_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Aaho! Keera bandaakaza. Undeke mbaminike ngana, nꞌgabuli gira ikibusi kyawe kikizi ba mulala úguhimbiri.» ");
INSERT INTO flr_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ulya Musa, kundu Nahano Rurema wage akadeta kwokwo, haliko anamúyinginga kwo aholeere, anadeta: «E Nahamwitu, yaba bandu baawe, si wenyene we kabalyosa i Miisiri ku bukalage bwawe, mu kati koꞌbushobozi bwingi. Aaho! Kituma kiki ukoli gweti ugabarakarira? ");
INSERT INTO flr_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","«Si hali ikyanya Abamiisiri bangadeta: “Ehee! Ikyanya Rurema akabahulusa mu kihugo kiitu, kwâli riiri mu mujina naaho. Na íbikatuma agabalyosa mwo, gira agendi baminikira mu migazi, banahere.” «E Nahamwitu, utakolwe mbu ubarakarire. Yubwo buhanya bwo ushungisiri hiꞌgulu lyabo, ubuleke. ");
INSERT INTO flr_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ukengeere abakozi baawe, Hiburahimu, na Hisake, na Yakobo. Si keera mukanywana ikihango! Na wenyene ukashiikiza, ti: “Abandu ba mu kibusi kyawe, ngabaluza, halinde babe bingi nga ndonde kwiꞌgulu. Kino kihugo kyoshi, ngabaheereza kyo, kinayame buhyane bwabo, halinde imyakuula.”» ");
INSERT INTO flr_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Kwokwo yubwo buhanya, kundu Nahano âli mali bushungikira abandu baage, haliko atanaki bukoleesa. ");
INSERT INTO flr_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ha nyuma, Musa anamanuka ku mugazi, atengetiiri galya mabuye gabiri mabaaje geꞌkihango. Gâli yandisirwi kweꞌmaaja za Rurema uluhande noꞌlundi. ");
INSERT INTO flr_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Anali Rurema yenyene ye kaziyandika kwo. ");
INSERT INTO flr_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Iri Yoshwa akayuvwa ngiisi kwaꞌbandu bagweti bagaagira akalugi, anabwira Musa: «Si mu shumbi, muli ulubi bweneene. Nyuvwiti nga luli lubi lwiꞌzibo.» ");
INSERT INTO flr_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Na wa Musa, ti: «Yiri izu, litali nga lyaꞌbandu ábahima, litanali nga lyaꞌbandu ábahimwa. Si nyuvwiti ngaꞌmazu gaꞌbandu ábagweti bagayimba.» ");
INSERT INTO flr_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Iri bakayegeera ishumbi, Musa anabonaga gulya mugisi gweꞌnyana, anabona ngiisi kwaꞌbandu bagweti bagagukinira bwalaafwe. Lyeryo, anayami raakara bweneene. Galya mabuye mabaaje gombi, anagashangula haashi, ganavungukira mwiꞌdako lyoꞌmugazi. ");
INSERT INTO flr_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Lyeryo, anayabiira gulya mugisi, anaguduulika kwoꞌmuliro, anagujigiivya, halinde gwanaba lukungu. Yulwo lukungu, analufusha mwaꞌmagoloovi, anaganywesa Abahisiraheeri ku misi. ");
INSERT INTO flr_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Lyeryo, Musa anabwira Harooni: «Ewe! Kuti kwo yaba bandu bakakugira, halinde ubayingize mu kino kihuume kyeꞌkyaha?» ");
INSERT INTO flr_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Harooni, ti: «E nahamwitu, nakuyinginga, utambone buligo. Yaba bandu, wenyene uyiji ngiisi kwo bali mu yami vujuuka mu byaha. ");
INSERT INTO flr_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bakayiji mbwira: “Ulya mushosi Musa, kundu ye katulyosa i Miisiri, haliko buno, tutayiji íbyamúkoleka kwo. Aaho! Leka, utugirire byoꞌkuyikumbwa, bikizi ba byo bigaturongoora.” ");
INSERT INTO flr_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","«Nanababwira: “Ngiisi úgweti imbete zeꞌnooro, azihogole.” Yabo bandu, banazindeetera, nanabikabulira mu muliro. Haaho mu muliro, mwanayami huluka yugu mugisi.» ");
INSERT INTO flr_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Musa anabona ngiisi kwo yabo bandu bakoli yidulumbisiri mu bitalaalwe. Mukuba, Harooni akabaleka bakizi gira ngiisi kwo baloziizi. Kyo kitumiri abagoma bâli koli gweti bagabahonyoleza. ");
INSERT INTO flr_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Uyo Musa anagenda kwiꞌrembo lyeꞌshumbi, anateera umulaga, ti: «Ngiisi yeshi úli uluhande lwa Nahano, anyegeere.» Lyeryo, beene Laawi booshi, banamúkumanira. ");
INSERT INTO flr_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Haaho, Musa anababwira: «Nahano, Rurema waꞌBahisiraheeri akyula kwokuno: “Ngiisi muguma winyu, ayambale ingooti yage mu kibuno, munayilale mu shumbi. Muyingirire mu mulyango muguma, munahulukaane mu gundi. Ngiisi muguma winyu atondeere ukuyitana, kundu nakuyitwa angaba ali mwene wabo, kandi iri mwira wage, kandi iri mutuulani wage.”» ");
INSERT INTO flr_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Ulya Musa, mbu akyulage kwokwo, yabo beene Laawi, banamúsimbaha. Ku lwolwo lusiku, banayita abandu nga bihumbi bishatu. ");
INSERT INTO flr_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ha nyuma, Musa anababwira: «Zeene mutashiginia ukuyiyitira abaana biinyu, kiri na beene winyu. Kwokwo buno, mukola bataluule ku mikolwa ya Nahano. Zeene, keera Nahano amùgashaanira.» ");
INSERT INTO flr_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Iri bukashubi kya, Musa anabwira abandu: «Si keera mwagira ikyaha bweneene. Kwokwo buno, namu zamuukira ku mugazi, imunda Nahano. Hali ikyanya angakoli mùkejeerera.» ");
INSERT INTO flr_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Kwokwo, Musa anagalukira imunda Nahano, anamúbwira: «Yoho wee! Balya bandu, keera bagira ikyaha bweneene mu kuyitulira imigisi mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Kundu kwokwo, ubakejeerere maashi! Neꞌri wangalahira ukubakoga, nakuyinginga, uhotole iziina lyani mu kitaabo kyawe kyoꞌbulamu.» ");
INSERT INTO flr_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Nahano anamúshuvya: «Nanga, ma! Ngiisi úgaaba keera akola ikyaha, yeki yiꞌziina lyage ligahotolwa mu kitaabo kyani. ");
INSERT INTO flr_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Bwobuno, ugendi rongoora abandu ngiisi ho nꞌgakuyereka. Umuganda wani, agakizi kurongoora. Kundu kwokwo, nabonaga kwo yaba bandu keera bagira ikyaha bweneene. Kwokwo, hakiri ulusiku lwo nâye ki bahaniirize.» ");
INSERT INTO flr_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Ha nyuma, Nahano anahana yabo bandu, mu kubabiika mweꞌkiija. Mukuba, ikyanya bakayikumba irya nyana, lyo bakayifunda mu kyaha bweneene. ");
INSERT INTO flr_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Nahano anabwira Musa: «Yimukaga yaha, mwe na yaba bandu bo mwalyokanwa i Miisiri, munayingire mu kihugo kyo nꞌgalagaania Hiburahimu, na Hisake, na Yakobo. Mukuba, yikyo kihugo, nꞌgababwira kwo ngakiheereza abandu beꞌkibusi kyabo. ");
INSERT INTO flr_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","«Ngalungika umuganda imbere liinyu, anamùyimulire Abakaanani, naꞌBahamoori, naꞌBahiti, naꞌBapereesi, naꞌBahivi, naꞌBayebuusi. ");
INSERT INTO flr_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Mugendi yingira mu kihugo, kwo kiyeziri mwaꞌmata noꞌbuuki. Kundu kwokwo, niehe tutagagendanwa, bwo muli mindagabika. Iri twangagendanwa, hali ikyanya nangakengeera namùminikira mu njira.» ");
INSERT INTO flr_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Yago magambo malangi, iri yabo bandu bakagayuvwa, banatondeera ukulira ku kimombo. Ndaanaye úkayilimbiisa neꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Na íbitumiri bakagira kwokwo, bwo Nahano âli mali gwanwa abwira Musa, ti: «Yabo Bahisiraheeri, ubabwire kwo bali mindagabika, banali banduuvwa. Neꞌri twangagendanwa, hali ikyanya nangayami baminika kinaliguma. Ku yukwo, ngiisi byo muyirimbisiizi mwo, mubihogole. Ha nyuma, lyo ngaamenya ngiisi kwo ngamùgirira.» ");
INSERT INTO flr_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kwokwo, yabo Bahisiraheeri banashaaza inooro zoꞌkuyilimbiisa mwo, batanaki ziyambala. ");
INSERT INTO flr_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Musa âli kizi yabiira iheema lyeꞌmihumaanano, analishinge inyuma lyeꞌshumbi yaꞌBahisiraheeri, hala hiniini. Banaliyinika iziina heema lyeꞌmihumaanano. Ngiisi úwâli kizi looza ukuhanuusa Nahano, âli kizi genda inyuma lyaꞌkaaya, mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ngiisi kyanya Musa âli kizi genda mu lirya heema, abandu booshi bâli kizi yimanga ha miryango yeꞌshumbi zaabo. Banakizi langiiza Musa, halinde ku kyanya agaaba keera aliyingira mwo. ");
INSERT INTO flr_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ikyanya Musa âli kizi yingira yumwo mwiꞌheema, inguliro yeꞌkibungu yâli kizi shonooka, inabeere ha mulyango. Lyeryo, Nahano anatondeere ukumúganuuza. ");
INSERT INTO flr_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Irya nguliro yeꞌkibungu, ikyanya abandu bâli kizi gibona ha mulyango gwiꞌheema, bâli kizi yimanga, ngiisi mundu ha mulyango gwiꞌshumbi lyage, bagweti bagayikumba Nahano. ");
INSERT INTO flr_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Nahano âli kizi ganuuza Musa masu ku gandi, nga kwoꞌmundu ali mu ganuula noꞌwabo. Ha nyuma, Musa anakizi galukira mu shumbi. Si umusore Yoshwa mugala Nuuni, yehe atâli lyosiri mu lirya heema. ");
INSERT INTO flr_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Musa anabwira Nahano: «Lolaga! Uli mu mbwira kwo ngizi rongoora yaba bandu. Haliko utazi nyereka umundu ye watuma kwo andabaale. Wanadeta kwo uyiji-yiji iziina lyani, na kwo unyemeriiri. ");
INSERT INTO flr_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Aaho! Iri wangaba unyemeriiri, ummenyeese injira zaawe, gira ndonge ukukumenya, na ngusimiise. E waliha, ukengeere kwo yaba bandu bali beꞌmwawe.» ");
INSERT INTO flr_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Nahano anamúshuvya: «Nienyene, tugakizi gendanwa, na nguluhuuse.» ");
INSERT INTO flr_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Musa, ti: «Iri utangayemeera kwo tugendanwe, utakolwe kwo watuyimusa hano. ");
INSERT INTO flr_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ee! Iri utangayemeera kwo tugendanwe, kutagi kwaꞌbandu bagaamenya kwo ngusimisiizi? Na kuti kwo bangamenya kwo tutali ngaꞌbandi bandu booshi ba mu mahanga?» ");
INSERT INTO flr_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Nahano, ti: «Nyiji iziina lyawe, unali mu nzimiisa. Ku yukwo, ngiisi byo wambuuna, ngabigira.» ");
INSERT INTO flr_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Na wa Musa, ti: «Nakuyinginga, unyereke ubulangashane bwawe.» ");
INSERT INTO flr_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Nahano, ti: «Ubwija bwani bwoshi, ngola ngabuyerekana imwawe. Na ngumenyeese iziina lyani, kwo nie Nahano. Ngiisi ye ndoziizi ukukejeerera, ndi mu múkejeerera. Na ngiisi ye ndoziizi ukuyuvwirwa indengeerwa, ndi mu múyuvwirwa zo. ");
INSERT INTO flr_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Si amalanga gaani, utâye gabone. Ndaaye úwangambona amalanga, mbu anashubi ba ho.» ");
INSERT INTO flr_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Nahano anashubi deta: «Lolaga! Hano ha butambi lyani, hali ulwala. Uyimange ha butambi lyalwo. ");
INSERT INTO flr_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ikyanya ubulangashane bwani bugalenga, ngakubisha mu kati kaalwo. Ukuboko kwani, kunakubwikire, halinde ukuhisa ku kyanya ngaaba keera nalenga. ");
INSERT INTO flr_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kwokwo, ugaabona umugongo gwani naaho, si amalanga gaani goohe, gatâye boneke.» ");
INSERT INTO flr_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Nahano anabwira Musa: «Ewe! Ulingaanie amabuye gabiri mabaaje, nga gaagalya ga mbere, gira ngayandike kwo gaagalya magambo. Mukuba, galya ga mbere, keera wagashangula haashi. ");
INSERT INTO flr_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Kusheezi shesheezi, uyibiike ibiringiini. Uzindukiri zamuukira ku mugazi Sinaayi, unandindirire ho. ");
INSERT INTO flr_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Hatanagire umundu úgakushalagira ku mugazi, hatanabe úgagulabuka kwo. Hatagirage kiri neꞌkitugwa kiguma íkigaragira hoofi lyagwo, kiba kibuzi, kandi iri mbene, kandi iri ngaavu.» ");
INSERT INTO flr_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ikyanya Nahano akabwira Musa kwokwo, Musa anasimbaha. Analingaania amabuye gabiri mabaaje, nga gaagalya ga mbere, anazindukiri gazamuukana ku mugazi Sinaayi. ");
INSERT INTO flr_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yaho ku mugazi, Nahano anashonooka mu kibungu, anayimanga hoofi na Musa, anayideta iziina lyage, ti: «Nahano.» ");
INSERT INTO flr_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Lyeryo, analenga imbere lya Musa, anashubi deta: «Niehe, nie Nahano, na ndi nie Rurema. Nyijwiri ulukogo neꞌndengeerwa. Ndi mwigenderezi, na ndi mu kizi gira amiija, na ndi mwemeera. ");
INSERT INTO flr_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Ndi mu kundana halinde ukuhisa ku bibusi binoono neꞌbinoono. Na ndi mu koga ubuligo, noꞌbuhuni, neꞌbyaha. Kundu kwokwo, ndangaleka ukuhana banangora-mabi. Ngiisi úgaakolwa mbu agire ikyaha, ngakiyihoola, halinde ukuhisa ku baana baage, na ku bijukulu, na mbise kiri na ku kibusi kya kashatu, kandi iri kya kana.» ");
INSERT INTO flr_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Lyeryo, Musa anayami yinama, anahisa amalanga haashi, mu kuyikumba Nahano, ");
INSERT INTO flr_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","anadeta: «E Nahano, iri nangaba keera nalonga ulukogo imbere lyawe, nakuyinginga, uyije tugendanwe. Kundu yabo bandu balyagagi banduuvwa, haliko ukoge ubuligo bwabo, kiri neꞌbyaha byabo. Unatuyakiirage nga bandu baawe.» ");
INSERT INTO flr_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Nahano anashubi bwira Musa: «Twembi, tukola tuganywana ikihango, na ngizi gira ibisoomeza imbere liinyu mweshi. Yibyo bisoomeza, ndaago gandi mahanga go byâli kizi koleka mwo. Niehe, nie Nahano. Ibisoomeza byo ngamùkolera mweshi, yabo bandi bagabibona kwo biri bya kahebuuza. ");
INSERT INTO flr_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","«Kwokwo, ngiisi byo nakukomeereza zeene, ukizi bisimbaha. Ngakuyimulira Abahamoori, naꞌBakaanani, naꞌBahiti, naꞌBapereesi, naꞌBahivi, naꞌBayebuusi. ");
INSERT INTO flr_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kirya kihugo kyo mukola mugayingira mwo, mulole bwija. Mutakolwe kwo mwanywana ikihango naꞌbandu baamwo. Mukuba, yabo bandu, hali ikyanya bangayiji mùgwasa nga mutego. ");
INSERT INTO flr_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ngiisi kwo mugaagira naaho, muhongolage ututanda twabo. Naꞌmabuye gaabo mataluule, mugavungule-vungule. Kiri neꞌnguliro zo bamanisiri hiꞌgulu lyoꞌmugisi gwabo Hasheera, muyami zihooja-hooja. ");
INSERT INTO flr_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","«Hatagirage ibindi byo mugakizi yikumba. Mukuba, niehe nie Nahano, na ndi mu buuzibwa Munaluugi. Ndi Rurema woꞌluugi. ");
INSERT INTO flr_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Kwokwo, ngiisi ábatuuziri mu kirya kihugo kyabo, hatagire kihango kyo muganywana mwe nabo. Mukuba, imigisi yabo, ikyanya bali mu giyikumba, banagitangire amatuulo, niinyu bangamùlaalika. Munakengeere mwalya ku yago matuulo gaabo. ");
INSERT INTO flr_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","«Yabo bagala biinyu, hali ikyanya bangabayangira. Neꞌkyanya bakaabo bagakizi yikumba imigisi yabo, nabo iri baganakizi giyikumba. ");
INSERT INTO flr_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Mutakolwe kwo mwayitulira imigisi mu byuma. ");
INSERT INTO flr_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Ulusiku lukulu lweꞌmikate mizira saama, mukizi lusimbaha. Mukizi hisa isiku zirinda, mugweti mugaalya imikate mizira saama, nga kwo nꞌgamùkomeereza. Mukizi gira kwokwo mu mwezi gwa Habibu. Mukuba, mu gwogwo mwezi, lyo mukalyoka i Miisiri. ");
INSERT INTO flr_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Ifula ziinyu zooshi, zigaaba zeꞌmwani. Kiri neꞌbitugwa biinyu, íbyabutwa ubwa mbere bigaaba byeꞌmwani, iba shuuli, kandi iri kipanga, kandi iri kihebe. ");
INSERT INTO flr_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Si mu bapunda, byohe bikizi guluulwa neꞌkyanabuzi. Kutáli kwokwo, munamútongeerage. Ku biloziri ifula ziinyu mwenyene, mukwiriiri mukizi ziguluula kwakundi. «Hatagirage umundu mu kati kiinyu, úgakizi yija imbere lyani, ali maboko mamaata. ");
INSERT INTO flr_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Mukizi hisa isiku ndatu mugweti mugaakola. Si ulusiku lwa kalinda lwohe, mukizi luhuuka, kundu kyangaba kiri kyanya kyoꞌkulima, kandi iri kyoꞌkuyimbula. ");
INSERT INTO flr_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Ku ndondeko yoꞌkugesha ingano, mukizi shambaalira ulusiku lukulu lwaꞌmayinga. Na ku mbeka yoꞌmwaka, mukizi shambaalira ulusiku lukulu lweꞌmimbu. ");
INSERT INTO flr_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","«Niehe, nie Nahano woꞌbushobozi bwoshi, Rurema waꞌBahisiraheeri. Kwokwo, ku ngiisi mwaka, abashosi booshi bakwiriiri bakizi kuumana ubugira kashatu imbere lyani. ");
INSERT INTO flr_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Neꞌri mwangakuumana imbere lyani ubugira kashatu ku mwaka, ngamùyimulira ibinyamahanga, ndaakyo kinyamahanga íkigakizi yifwija ikihugo kiinyu. Kiri neꞌmbibi ziinyu, ngazihamya. ");
INSERT INTO flr_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Ikyanya mugakizi ndangira ituulo lyeꞌkitugwa, mutakizi litanga kuguma neꞌmikate íri mweꞌsaama. Kiri niꞌtuulo lyoꞌlusiku lukulu lweꞌPasaka, mutakizi lilaaza halinde shesheezi. ");
INSERT INTO flr_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«Niehe nie Nahano, Rurema winyu. Kwokwo, mukizi yija mu nyumba yani, muli niꞌtomola lyeꞌmimbu yinyu. «Mutakolwe kwo mwakizi deekera inyama yeꞌkyanahene mu mata ga nyina.» ");
INSERT INTO flr_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Nahano anashubi bwira Musa: «Keera twanywana ikihango twembi, naꞌBahisiraheeri kwakundi. Kwokwo yago magambo, mugayandikage.» ");
INSERT INTO flr_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Musa akahisa isiku makumi gana ali kuguma na Nahano, atali mu lya, atanali mu nywa. Ku yikyo kyanya, anayabiira galya mabuye gabiri mabaaje, anagayandika kweꞌmaaja ikumi. Yizo maaja, zâli kizi yerekana ikihango. Niꞌziina lyazo, Imaaja Ikumi. ");
INSERT INTO flr_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Galya mabuye, Musa anagamanukana ku mugazi Sinaayi. Ku yikyo kyanya, amalanga gaage gâli gweti gagakeyengana bweneene, bwo akalyoki ganuula na Rurema. Haliko yenyene, atâli yiji kwo gakeyengiini. ");
INSERT INTO flr_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Na bwaꞌmalanga gaage gâli keyengiini, kyanatuma Harooni naꞌBahisiraheeri booshi, bagakanguka, batanaki múyegeera. ");
INSERT INTO flr_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Kundu kwokwo, Musa anabahamagala. Kwokwo, Harooni, naꞌbatwali baabo booshi, banamúyegeera, anabaganuuza. ");
INSERT INTO flr_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Ha nyuma, Abahisiraheeri booshi babuli guumukira ho âli. Na ngiisi maaja zo Nahano akayija amútekerera ku mugazi Sinaayi, anabaganuulira zo. ");
INSERT INTO flr_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ikyanya Musa akayusa ukubaganuulira, anayabiira ikitambala, anakiyibwika i malanga. ");
INSERT INTO flr_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Haliko ikyanya âli kizi gendi ganuuza Nahano mwiꞌheema, âli kizi kishaaza, halinde ukuhisa ku kyanya agashubi huluka. Neꞌri âli kizi huluka, anakizi ganuulira Abahisiraheeri ngiisi byo akabwirwa. ");
INSERT INTO flr_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ku yikyo kyanya, Abahisiraheeri bâli kizi bona kwaꞌmalanga gaage gakeyengiini. Kyanatuma Musa agashubi gatumbikira neꞌkitambala, halinde ku kyanya agashubi gendi ganuuza Rurema. ");
INSERT INTO flr_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Ikyanya Musa akakuumania Abahisiraheeri booshi, anababwira: «Imaaja zo Nahano amùbwira kwo mukizi simbaha, zo zeezi: ");
INSERT INTO flr_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Mu ngiisi iyinga, muli isiku ndatu zo mukwiriiri mukizi kola mwo. Si ulusiku lwa kalinda lwohe, lukola lusiku lweꞌSabaato. Yulwo lusiku, luli lutaluule imwa Nahano. Ngiisi mundu úgalukola kwo, akwiriiri ayitwe. ");
INSERT INTO flr_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Yulwo lusiku lweꞌSabaato, mutakwiriiri kiri noꞌkutwana umuliro mu nyumba ziinyu.» ");
INSERT INTO flr_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Yabo Bahisiraheeri booshi, Musa anagenderera ukubabwira ngiisi igambo lyo Nahano abahamuliziizi ukugira: ");
INSERT INTO flr_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","«Mu bindu biinyu, mukuumanie byo mugaheereza Nahano. Ngiisi mundu, amútangire ku mutima úgushenguusiri. Amútangire inooro, neꞌharija, neꞌmiringa. ");
INSERT INTO flr_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Amútangire neꞌnuzi ziꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, neꞌmirondo yeꞌkitaani, noꞌbwoya bweꞌmbene. ");
INSERT INTO flr_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Amútangire neꞌmbu zeꞌbipanga ízikashiigwa ibara lidukula, neꞌzindi mbu ngomu, neꞌbiti byaꞌkasiya. ");
INSERT INTO flr_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Amútangire neꞌbitoro byoꞌkubiika mu matara, naꞌmalaasi goꞌkufusha mu mavuta goꞌkushiiga ku byataluulwa, noꞌmubadu gwoꞌmuhongolo mwija. ");
INSERT INTO flr_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Amútangire naꞌmabuye geꞌhonikisi, naꞌgandi goꞌkulimbiisa ikangaata lyoꞌmugingi, galimbiise neꞌshaho yo agakizi yambala ha kifuba. ");
INSERT INTO flr_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«Ngiisi banaluganda bo muliriinwi, bayiji lingaaniza Nahano ngiisi byo akatukomeereza. ");
INSERT INTO flr_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Balingaanie iheema lyeꞌmihumaanano, na byoꞌkulibwikira, neꞌndoboro, neꞌmiganda, neꞌbiti byeꞌnzizi, neꞌnguliro zooshi zoꞌkuliyimangika, kuguma neꞌbiterekero byazo. ");
INSERT INTO flr_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","«Balingaanie naꞌKajumba lyeꞌKihango, neꞌbiti byoꞌkukabetulira kwo, noꞌmutumbikizo gwoꞌlukogo noꞌmulondo gwoꞌkusiika Ahandu Heeru bweneene. ");
INSERT INTO flr_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","«Banalingaanie naꞌkashasha, kuguma neꞌbiti byoꞌkukabetulira kwo, neꞌbirugu byako byoshi, neꞌmikate yoꞌkutangwa imwa Nahano. ");
INSERT INTO flr_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","«Banalingaanie neꞌkiterekero kyaꞌmatara, kuguma neꞌbirugu byalyo byoshi, ngaꞌmatara goonyene, neꞌbitoro byago. ");
INSERT INTO flr_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","«Banalingaanie naꞌkatanda koꞌkuyokera kwoꞌmubadu, neꞌbiti byako, naꞌmavuta goꞌkuyishiiga, noꞌmubadu, noꞌmulondo gwoꞌkusiika ha mulyango gwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","«Banalingaanie naꞌkatanda koꞌkusiriigiza kwaꞌmatuulo, kuguma naꞌkayungiro koꞌmulinga, kiri neꞌbiti byako, kuguma neꞌbindi birugu byako byoshi, noꞌmutanga, neꞌkiterekero kyagwo. ");
INSERT INTO flr_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","«Banalingaanie neꞌmirondo yoꞌkuzungulusa ulubuga, neꞌnguliro, neꞌbiterekero byazo, noꞌmulondo gwa ha mulyango gwoꞌlubuga. ");
INSERT INTO flr_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","«Banalingaanie neꞌmbambo ziꞌheema lyeꞌmihumaanano, kiri na yoꞌlubuga, kuguma neꞌmigozi yalyo. ");
INSERT INTO flr_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","«Banalingaanie neꞌmirondo íkahangwa bwija yoꞌkukoleesa Ahandu Heeru. Kuli kudeta imirondo mitaluule yoꞌmugingiHarooni, kiri na yo bagala baage bagakizi yambala ikyanya bagakizi kola.» ");
INSERT INTO flr_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Yabo Bahisiraheeri banalyoka imbere lya Musa. ");
INSERT INTO flr_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ngiisi muguma anatangira Nahano ulushangi, nga kwo akasiima mu mutima gwage. Bakatanga hiꞌgulu lyoꞌkumúyubakira iheema lyeꞌmihumaanano, na hiꞌgulu lyeꞌgindi mikolwa yage yoshi. Banatanga na hiꞌgulu lyeꞌmirondo mitaluule. ");
INSERT INTO flr_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Kwokwo, ngiisi ábâli noꞌmutima mwija, abashosi naꞌbakazi, banayiji tanga imbete za ku matwiri, neꞌza ku minwe. Banatanga neꞌbikomo, na ngiisi bindi byoꞌkuyilimbiisa mwo. Ngiisi mundu anatangira Nahano ikindu íkikatulwa mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ngiisi muguma akatanga nga kwo âli hiiti, ngeꞌnuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, neꞌnuzi zeꞌkitaani, noꞌbwoya bweꞌmbene, neꞌmbu ndukula zeꞌbibuzi, neꞌzindi mbu. ");
INSERT INTO flr_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ngiisi úwâli shobwiri, akatangira Nahano iharija, kandi iri miringa. Na ngiisi úwâli hiiti ibiti byaꞌkasiya, naye akazitanga. ");
INSERT INTO flr_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ngiisi mukazi úwâli yiji ukuluka, analeeta byo akaluka mu nuzi zeꞌkitaani, na zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. ");
INSERT INTO flr_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Ngiisi mukazi úwâli hiiti umutima mwija, anabe ayiji ukuzinga ubwoya bweꞌmbene, banagira kwokwo. ");
INSERT INTO flr_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Abatwali banaleeta amabuye geꞌhonikisi, naꞌgandi goꞌkulimbiisa mwiꞌkangaata lyoꞌmugingi, kiri neꞌshaho nzonere kwo ha kifuba. ");
INSERT INTO flr_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Banaleeta naꞌmavuta geꞌmizehituuni, gira bakizi gakoleesa mu matara, na mu kukizi yishiiga. Banaleeta noꞌmubadu goꞌmuhongolo mwija. ");
INSERT INTO flr_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Kwokwo, Abahisiraheeri bâli gweti bagashenguukira ukutanga hiꞌgulu lyeꞌmikolwa ya Nahano, nga kwo Nahano âli mali gwanwa abwira Musa. Mu bashosi na mu bakazi, ngiisi kwo bâli loziizi, kwo bakanatangira Nahano amatuulo. ");
INSERT INTO flr_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Musa anabwira Abahisiraheeri: «Yuvwirizi! Keera Nahano akatoola Bezaleeri mugala Uri, mwijukulu Huuri, woꞌmulala gwaꞌBayuda. ");
INSERT INTO flr_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Anamúyijuza mwoꞌMutima gwage, halinde anaba naluganda, woꞌbwenge noꞌbumenyi. Bezaleeri akolaga muhinga weꞌmikolwa ya kwingi-kwingi. ");
INSERT INTO flr_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Agakizi yerekana íbisimisiizi amasu, mu kubitula mu nooro, na mu harija, na mu miringa. ");
INSERT INTO flr_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Anakizi baaja amabuye goꞌkukizi limbiisa, kiri neꞌbiti. Ye gakizi yerekana ubulenga bwa ngiisi mukolwa. ");
INSERT INTO flr_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","«Nahano, anamúbiika kwo Oholyabu mugala Ahisamaki woꞌmulala gwa Daani. Uyo Oholyabu naye, keera akamúheereza ikigabi kyoꞌkukizi yigiriza abandi banaluganda. ");
INSERT INTO flr_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Anababiika mwoꞌbulenga bwoꞌkukizi kola imikolwa ya kwingi-kwingi, nga yoꞌkubaaja amabuye miija, na yoꞌkulaba, na yoꞌkuluka imirondo mu nuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, na yoꞌkulimbiisa imirondo mu nuzi zeꞌkitaani. Emwe! Bâli noꞌbulenga bwa kwingi-kwingi. ");
INSERT INTO flr_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Kwokwo, kwo Bezaleeri na Oholyabu bahaabirwi imikolwa yoꞌkuyubaka iheema lyeꞌmihumaanano, ukukulikirana na kwo Nahano akadeta kwo batondeerage ukukola. Bagatabaalanwa na ngiisi yeshi ye Nahano akaheereza ubuhinga noꞌbwenge bwoꞌkukola mwo.» ");
INSERT INTO flr_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Kwokwo, Musa anahamagala Bezaleeri, na Oholyabu, na ngiisi úkagashaanirwa ubuhinga na Nahano, anabe keera akayemeera ukuyiji kola. ");
INSERT INTO flr_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Yabo booshi, Musa anabaheereza birya byoshi byaꞌBahisiraheeri bakatanga ku bulooze bwabo, hiꞌgulu lyoꞌkulingaania iheema lyeꞌmihumaanano. Ngiisi lusiku, abandu bâli kizi genderera ukutanga ulushangi lwabo ku mutima úgushenguusiri. ");
INSERT INTO flr_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Iri hakaba, abahinga booshi ábâli kizi kola imikolwa ya kwingi-kwingi hiꞌgulu liꞌheema lyeꞌmihumaanano, banatee siga imikolwa yabo, banagendera Musa, ");
INSERT INTO flr_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","banamúmenyeesa kwokuno: «Ukukulikirana na ngiisi kwo Nahano akatubwira, ibindu keera íbyatangwa, bikola katundu bweneene. Bikoli leeziri ulugero.» ");
INSERT INTO flr_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kyanatuma Musa agakyula: «Hataki gire mundu yeshi, aba mushosi kandi iri mukazi, úgaki tanga ibindu hiꞌgulu liꞌheema lyeꞌmihumaanano.» Yago magambo gaage, ganakwira mu shumbi. Kwokwo, kwaꞌbandu bakabuzibwa, batanakizi ki bitanga. ");
INSERT INTO flr_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Mukuba, ngiisi byo bâli mali tanga, byâli koli shobwiri. Neꞌbindi, byanasigala kwo. ");
INSERT INTO flr_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Abahinga banalingaania iheema lyeꞌmihumaanano mu mirondo ikumi yeꞌnuzi zeꞌkitaani, na yoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. Iyo mirondo, banagilimbiisa neꞌbishushanio bya bamakerubi. ");
INSERT INTO flr_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Kwo iri yoshi, yâli noꞌlugero luguma, lweꞌmeetere ikumi na zibiri, ku meetere zibiri-zibiri. ");
INSERT INTO flr_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Bakatee nanika imirondo itaanu kuguma, mu kugira ikihande kiguma. Banagira kwokwo-kwokwo na kwiꞌrya gindi itaanu. ");
INSERT INTO flr_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Kwiꞌkano lya ngiisi mulondo gweꞌmbeka, kwâli hangiirwi iminaganizo yiꞌbara lya namukungumo. ");
INSERT INTO flr_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ku mulondo gwa mbere, na ku gwa kabiri, banashwekera kweꞌminaganizo makumi gataanu-gataanu. Iyo minaganizo yoshi, yanakizi lolana. ");
INSERT INTO flr_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ha nyuma, banayabiira inooro, banazitula mweꞌndoboro makumi gataanu, banazishwekera kweꞌmigozi yoꞌkuhumaanania iyo mirondo ibiri. Kwokwo, yiryo iheema, lyanaba kikola kindu kiguma naaho. ");
INSERT INTO flr_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ha nyuma, banayabiira ubwoya bweꞌmbene, banaluka mweꞌmirondo ikumi na muguma yoꞌkubwikira kwiꞌheema lyeꞌmihumaano. ");
INSERT INTO flr_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Iyo mirondo kwo iri ikumi na muguma, yâli riiri noꞌlugero luguma, lweꞌmeetere ikumi na zishatu, ku zibiri. ");
INSERT INTO flr_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Kwokwo mwiꞌyo mirondo, anahangira itaanu kuguma, neꞌgindi ndatu nayo kuguma. ");
INSERT INTO flr_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ha nyuma, kwiꞌrya mirondo itaanu, anashwekera iminaganizo makumi gataanu kwiꞌkano lyoꞌmulondo gweꞌmbeka. Na kwiꞌrya gindi ndatu, anashwekera igindi minaganizo makumi gataanu kwiꞌkano lyoꞌmulondo gwa mbere. ");
INSERT INTO flr_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Banalingaania neꞌndoboro zeꞌmiringa makumi gataanu, banananika yibyo bihande bibiri byeꞌmirondo, halinde byanaba kikola kindu kiguma. ");
INSERT INTO flr_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Na kwakundi, banalingaania ikihunika mu mbu zeꞌbipanga, njiige ibara lidukula, neꞌkindi mu mbu ngomu, banabiyajuulira hiꞌgulu. ");
INSERT INTO flr_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Banakoleesa ibiti byaꞌkasiya, mu kulingaania imiganda yoꞌkuyimangika iheema. ");
INSERT INTO flr_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Ngiisi muganda gwâli noꞌbula bweꞌmeetere zina, ku sendimeetere makumi galindatu na ndatu, ");
INSERT INTO flr_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","gwanâli hiiti imishigo ibiri yoꞌkugusikamya mu biterekero. ");
INSERT INTO flr_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Iyo miganda, banashinga makumi gabiri uluhande lweꞌkisaka lwiꞌheema. ");
INSERT INTO flr_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Banagitereka ku biterekero makumi gana byeꞌharija. Ngiisi muganda, banagutereka ku biterekero bibiri, bikizi gwata imishigo yagwo yombi. ");
INSERT INTO flr_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Noꞌluhande lweꞌmbembe, banalingaania yeꞌgindi miganda makumi gabiri. ");
INSERT INTO flr_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Banagitereka ku biterekero byayo makumi gana byeꞌharija. Ngiisi muganda, banagutereka ku biterekero bibiri, mu kugujingiriza neꞌrya mishigo. ");
INSERT INTO flr_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Uluhande lweꞌmuga lwiꞌheema, banalingaania imiganda ndatu. ");
INSERT INTO flr_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Banalingaania kwakundi neꞌmiganda ibiri yeꞌbutambi liꞌheema, mu tugongo tweꞌnyuma. ");
INSERT INTO flr_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Idako, iyo miganda yombi yâli likiini. Haliko hiꞌgulu, yanashwekerwa kuguma mu kukoleesa imbete. Kwokwo, kwo bakalingaania iyo miganda ibiri yoꞌtugongo twoꞌluhande lweꞌmuga. ");
INSERT INTO flr_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kwokwo, imuga, yanaba neꞌmiganda munaana, neꞌbiterekero byayo byâli riiri ikumi na ndatu. Yibyo biterekero, bikatulwa mu harija. Mwidako lya ngiisi muganda, mwâli kizi biikwa ibiterekero bibiri-bibiri. ");
INSERT INTO flr_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Banayabiira ibiti byaꞌkasiya, banabibaaja mweꞌnzizi, gira zikizi gwata imiganda yiꞌheema. Uluhande luguma lwâli kizi yabiira inzizi zitaanu, ");
INSERT INTO flr_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","noꞌlundi zindi zitaanu. Kiri noꞌluhande lweꞌnyuma liꞌheema, (uluhande lweꞌmuga), nalwo lwâli riiri izindi zitaanu. ");
INSERT INTO flr_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Uluzizi lwa ha kati keꞌnguliro zooshi, banaluhulukaania uluhande noꞌlundi lwiꞌheema. ");
INSERT INTO flr_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Iyo miganda yoshi, kiri neꞌnzizi zooshi, banazibugiiriza kweꞌnooro. Banatula neꞌmbete zeꞌnooro, banazinanika neꞌnzizi. Yizo nzizi kwakundi, banazibugiiriza kweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Banagira umulondo gwa ha kati-kati kiꞌheema, mu nuzi zeꞌkitaani, na mu zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. Anagulimbiisa neꞌbishushanio bya bamakerubi. ");
INSERT INTO flr_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Yugwo mulondo, banagushwekera ku nguliro zina zeꞌbiti byaꞌkasiya, banazibugiiriza kweꞌnooro. Banazitereka ku biterekero bina, íbikatulwa mu harija. ");
INSERT INTO flr_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Umulyango gwiꞌheema, banagulingaaniza umulondo mu nuzi zeꞌkitaani, na mu nuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. ");
INSERT INTO flr_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Yugwo mulondo gwanashwekerwa ku nguliro zitaanu mbugiirize kweꞌnooro. Banazibiika kweꞌndoboro, banatula neꞌbiterekero bitaanu byeꞌmiringa. ");
INSERT INTO flr_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaleeri analingaania Akajumba keꞌKihango mu biti byaꞌkasiya. Yako Kajumba, kâli neꞌmeetere nguma neꞌsendimeetere ikumi, ku sendimeetere makumi galindatu na ndatu. Neꞌkimango, nakyo zâli sendimeetere makumi galindatu na ndatu. ");
INSERT INTO flr_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Yako Kajumba, anakabugiiriza kweꞌnooro muguuhya, i mugongo, kiri na munda. Anakazungulusa neꞌmihiro yeꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ha nyuma, analingaania imbete zina zeꞌnooro, anazibiika ku tugongo twako. Luhande luguma akabiika yeꞌmbete zibiri, noꞌlundi izindi zibiri. ");
INSERT INTO flr_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Analingaania neꞌbiti bila byaꞌkasiya, anabibugiiriza kweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Yibyo biti, anabishogeka mu yizo imbete zeꞌmbande zombi zaꞌKajumba, hiꞌgulu lyoꞌkukizi kabetulira kwo. ");
INSERT INTO flr_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Yako Kajumba, anakalingaaniza umutumbikizo gwoꞌlukogo, mu nooro muguuhya. Yugwo mutumbikizo, gwâli neꞌmeetere nguma neꞌsendimeetere ikumi, ku sendimeetere makumi galindatu na ndatu. ");
INSERT INTO flr_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Yugwo mutumbikizo, ku mihiro yagwo, anakulingaania bamakerubi babiri. Yabo bamakerubi, bakatulwa mu nooro muguuhya. ");
INSERT INTO flr_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Anabiika makerubi muguma ku mbeka nguma, noꞌgundi ku gindi. Yabo bombi, kyanaba kiri kindu kiguma noꞌmutumbikizo. ");
INSERT INTO flr_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Yabo bamakerubi, bâli kizi lolana kwo, banakizi lola na ku mutumbikizo. Ibyubi byabo, byâli yajabusiri, byanabwikira umutumbikizo. ");
INSERT INTO flr_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Bezaleeri analingaania naꞌkashasha mu biti byaꞌkasiya. Yako kashasha, kâli neꞌsendimeetere makumi galimunaana na munaana, ku sendimeetere makumi gana na zina. Neꞌkimango kyâli neꞌsendimeetere makumi galindatu na ndatu. ");
INSERT INTO flr_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Yako kashasha, anakabugiiriza kweꞌnooro muguuhya, anakazungulusa neꞌmihiro yeꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Mu matambi, anazungulusa na mwoꞌlupahwa lweꞌsendimeetere munaana, analubugiiriza kweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Anatula neꞌmbete zina mu nooro, anazinanika ku ngiisi kagongo kwo tuli tuna, hoofi naꞌmagulu gaako. ");
INSERT INTO flr_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Yizo mbete zâli biisirwi hoofi na yulwo lupahwa lwa mu matambi. Zo zâli kizi gwatiriza yibyo biti bila byoꞌkukabetulira kwo. ");
INSERT INTO flr_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Analingaania ibindi biti bibiri mu kasiya, byoꞌkukabetulira kwo, anabibugiiriza kweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Analingaania neꞌbirugu byaꞌkashasha mu nooro muguuhya. Akalingaania amasahaani, neꞌbikombe, neꞌbirembe, neꞌkarabo zoꞌkubiikira mwaꞌmatuulo geꞌdivaayi. ");
INSERT INTO flr_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Analingaania ikiterekero kyaꞌmatara mu nooro muguuhya. Akatula amagulu gaakyo, kiri neꞌbikombe byakyo, noꞌtufundo twakyo, noꞌtwaso twakyo. Yibyo byoshi byanaba kindu kiguma. ");
INSERT INTO flr_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Yikyo kiterekero, kyâli hiiti amatavi galindatu. Matavi gashatu gâli yajabusiri luhande luguma. Naꞌgandi gashatu, gâli yajabusiri ulundi. ");
INSERT INTO flr_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Mu ngiisi itavi, mwâli kizi hogekwa ibikombe bishatu íbiri nga twaso tweꞌloozi. Na ngiisi kikombe kyâli kizi hogekwa mu tufundo twakyo, na mu twaso twakyo. ");
INSERT INTO flr_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Na ku kiterekero kyonyene, kwâli biisirwi ibikombe bina íbiri nga loozi, kuguma noꞌtufundo twabyo, noꞌtwaso twabyo. ");
INSERT INTO flr_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Ngiisi haꞌmatavi gabiri gâli kizi gwanana ku kiterekero, hâli kizi ba akafundo. Kwokwo, utufundo twoshi twâli riiri tushatu. ");
INSERT INTO flr_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Utufundo naꞌmatavi, byâli riiri kindu kiguma na yikyo kiterekero, bikanatulwa mu nooro muguuhya. ");
INSERT INTO flr_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Anakoleesa inooro muguuhya, mu kulingaania amatara galinda, neꞌmbaazi zaago, neꞌbirugu byago. ");
INSERT INTO flr_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Kwokwo, yikyo kiterekero kyaꞌmatara, kuguma neꞌbirugu byakyo, byoshi bikatulwa mu bilo makumi gashatu na bitaanu byeꞌnooro muguuhya. ");
INSERT INTO flr_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bezaleeri anayabiira ibiti byaꞌkasiya, anazilingaania mwaꞌkatanda koꞌkuyokera kwoꞌmubadu. Yako katanda, imbande zaako kwo ziri zina zâli yumiini, sendimeetere makumi gataanu, ku sendimeetere makumi gataanu. Neꞌkimango kyâli kyeꞌmeetere nguma. Utugongo twako tweꞌlugulu, twâli naniriini naꞌkatanda koonyene, kyanaba kindu kiguma. ");
INSERT INTO flr_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Yako katanda kooshi, anakabugiiriza kweꞌnooro muguuhya. Akabugiiriza ku luhande lwa hiꞌgulu, na mu mbande zooshi, na ku tugongo twako, anazungulusa na ku mihiro. ");
INSERT INTO flr_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Mwidako lyeꞌyo mihiro, analingaania mweꞌmbete zibiri-zibiri zeꞌnooro, uluhande noꞌlundi. Yizo mbete, zo bâli kizi shogeka mweꞌbiti byoꞌkukabetulira kwo. ");
INSERT INTO flr_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Analingaania ibiti bila bibiri byaꞌkasiya, anabibugiiriza kweꞌnooro. ");
INSERT INTO flr_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Analingaaniza naꞌbagingi amavuta goꞌkushiiga ku byataluulwa, kiri noꞌmubadu mutaluule gwoꞌmuhongolo mwija. Yago mavuta, gakayengwa na naluganda. ");
INSERT INTO flr_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezaleeri anayabiira ibiti byaꞌkasiya, analingaania mwaꞌkatanda koꞌkusiriigiza kwaꞌmatuulo. Yako katanda, imbande zaako zooshi zâli yumiini. Kwokwo, ngiisi luhande lwâli neꞌmeetere zibiri neꞌkitolo. Ikimango nakyo, yâli meetere nguma neꞌkitolo. ");
INSERT INTO flr_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Ku ngiisi kagongo kwo twâli tuna, kwâli nenesirwi íkiri ngiꞌhembe. Yago mahembe, anagananika ku katanda, halinde kyanaba kindu kiguma naaho. Yako katanda, anakabugiiriza kwoꞌmulinga. ");
INSERT INTO flr_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Anayabiira imiringa, anagitula mweꞌbirugu byoshi byaꞌkatanda, ngeꞌshefuriya, neꞌmbahwa zoꞌkushamata, neꞌnzoozo zoꞌkubiikira umuko, neꞌkanya, neꞌsheetezo. ");
INSERT INTO flr_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Mu yeyo miringa, analingaania akayungiro, anakabiika mwiꞌdako lyeꞌmihiro, mu kati-kati kaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Mu yeyo miringa, anatula mweꞌmbete zina, anazinanika ku matambi gaꞌkayungiro, gira bakizi hogeka mweꞌbiti byoꞌkukabetulira kwo. ");
INSERT INTO flr_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Anabaaja ibiti bila mu kasiya, anabibugiiriza kwoꞌmulinga. ");
INSERT INTO flr_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Yibyo biti, anabishogeka mu yizo imbete, gira bakizi kabetulira kwo. Yako katanda kakagirwa mu biti, na mu nda yako, mwâli muhokole. ");
INSERT INTO flr_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Hâli riiri abakazi ábâli kizi kola ha mulyango gwiꞌheema lyeꞌmihumaanano. Anayabiira ibilolero byabo íbikatulwa mu miringa, anabijongolola, anabitula mwoꞌmutanga muhamu, kiri neꞌkiterekero kyagwo. ");
INSERT INTO flr_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Yiryo iheema lyeꞌmihumaanano, analizungulusa ulubuga, mu kukoleesa imirondo yeꞌkitaani. Umulondo gweꞌkisaka, gwâli neꞌmeetere makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Yugwo mulondo, anagushwekera ku nguliro makumi gabiri. Ngiisi nguliro yâli teresirwi ku kiterekero kyoꞌmulinga. Si indoboro zaazo neꞌnzuuma, byohe bikatulwa mu harija. ");
INSERT INTO flr_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Umulondo gweꞌmbembe, gwâli neꞌmeetere makumi gataanu. Nagwo, gukashwekerwa ku nguliro zaagwo makumi gabiri zeꞌmiringa. Indoboro zaazo, kiri neꞌnzuuma, byohe bikatulwa mu harija. ");
INSERT INTO flr_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Umulondo gweꞌmuga, gwâli neꞌmeetere makumi gabiri na zibiri. Nagwo, gukashwekerwa ku nguliro ikumi, neꞌbiterekero ikumi. Indoboro zaazo, kiri neꞌnzuuma, byohe bikatulwa mu harija. ");
INSERT INTO flr_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Umulondo gweꞌsheere, gwâli neꞌmeetere makumi gabiri na zitaanu. ");
INSERT INTO flr_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Umulyango gwoꞌluzitiro, gwâli biisirwi uluhande lweꞌsheere, gwanâli neꞌmeetere zirinda, neꞌsendimeetere makumi gataanu. Umulondo gwagwo, gwâli kizi biikwa ku nguliro zishatu, neꞌbiterekero byazo bishatu. ");
INSERT INTO flr_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Umulondo gweꞌzindi mbande, nagwo gwâli neꞌmeetere zirinda, neꞌsendimeetere makumi gataanu. Yugwo mulondo, gwâli manisirwi ku nguliro zishatu, neꞌbiterekero byazo bishatu. ");
INSERT INTO flr_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Ulubuga lwoshi lwiꞌheema lukagirwa mu mirondo íkalukwa mu nuzi zeꞌkitaani. ");
INSERT INTO flr_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Ngiisi nguliro yâli neꞌkiterekero kyayo íkikatulwa mu miringa. Indoboro zaazo, neꞌnzuuma, byohe bikatulwa mu harija. Kiri neꞌmisumaari yoꞌkumanika imirondo, nayo ikatulwa mu harija. ");
INSERT INTO flr_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Umulondo ya ha mulyango, gukalukwa mu nuzi zeꞌkitaani na mu nuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. Yugwo mulondo, gwâli neꞌmeetere mwenda. Neꞌkimango, zâli meetere zibiri, ngeꞌmirondo yoꞌlubuga. ");
INSERT INTO flr_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Yugwo mulondo gwa ha mulyango, gwâli manisirwi ku nguliro zina neꞌbiterekero byazo bina íbikatulwa mu miringa. Indoboro zaagwo, neꞌnzuuma, kiri neꞌmisumaari, bikatulwa mu harija. ");
INSERT INTO flr_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Imbambo ziꞌheema, kiri na zeꞌmirondo yoꞌlubuga, zooshi zikatulwa mu miringa. ");
INSERT INTO flr_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Kuno kwo kutondobolwa kweꞌbirugu byoshi íbikakoleesibwa mu kuyubaka iheema lyeꞌmihumaanano, lyo bakabiika mwaꞌMabuye geꞌKihango. Yibyo birugu byoshi, Musa akabwira Abalaawi kwo babiyandike, ku njira ya Hitamaari mugala woꞌmugingiHarooni. ");
INSERT INTO flr_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaleeri (mugala Uri, ye na mwijukulu Huuri, woꞌmulala gwaꞌBayuda) ye wâli yimangiiri umukolwa gwoshi, nga kwo Nahano akabwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Âli kizi tabaalwa na Oholyabu (mugala Ahisamaki, woꞌmulala gwa Daani.) Uyo Oholyabu, âli riiri muhinga woꞌkukizi limbiisa, na woꞌkugira ibishushanio, na woꞌkulaba. Kiri noꞌmulondo úgukalukwa mu nuzi zeꞌkitaani, ye wâli riiri naluganda woꞌkukizi gulimbiisa neꞌnuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. ");
INSERT INTO flr_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Ikyanya Abahisiraheeri bakayubaka iheema lyeꞌmihumaanano, inooro zooshi zo bakatangira Nahano, zâli neꞌbilo magana galimunaana na makumi galinda na birinda, neꞌgarama magana gashatu. ");
INSERT INTO flr_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Neꞌharija zo bakakoleesa, zâli neꞌbilo bihumbi bishatu niꞌkumi na birinda, neꞌgarama magana galinda na makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ikyanya bakaharuura ngiisi mushosi ukulyokera ku myaka makumi gabiri, banahisa abandu bihumbi magana galindatu na bishatu, na magana gataanu na makumi gataanu. Ngiisi muguma wabo, anatanga ulwage lushangi lweꞌgarama zitaanu zeꞌharija. ");
INSERT INTO flr_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Yibyo biterekero igana, byo bâli kizi biika mwo yizo nguliro. Na yizo nguliro zo bâli kizi naganikira kweꞌmirondo yiꞌheema lyonyene, kiri na yoꞌluzitiro lwalyo. Kwokwo, yibyo biterekero, bakabitula mu bilo bihumbi bishatu byeꞌharija. Kuli kudeta ku ngiisi kiterekero, bâli kizi koleesa ibilo makumi gashatu. ");
INSERT INTO flr_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Mu bilo ikumi na birinda, neꞌgarama magana galinda na makumi gataanu bya yeyo harija, banatula mweꞌndoboro, banagibugiiriza na ku njembe zeꞌnguliro, banagilingaania na mweꞌmigozi. ");
INSERT INTO flr_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Imiringa yaꞌBahisiraheeri bakatangira Nahano, yâli neꞌbilo bihumbi bibiri na magana gana na makumi gabiri na bitaanu. ");
INSERT INTO flr_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Iyo miringa, bakagikoleesa mu kutula ibiterekero byoꞌmulyango gwiꞌheema lyeꞌmihumaanano. Banagikoleesa na mu kulingaania akatanda, kuguma naꞌkayungiro kaako, neꞌbindi birugu byako byoshi. ");
INSERT INTO flr_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Banalingaania na mweꞌbiterekero byoꞌluzitiro lwoꞌlubuga, na byoꞌlwivi lwa ha mulyango gwalwo, kiri na mweꞌmbambo zooshi ziꞌheema lyeꞌmihumaanano, na zoꞌluzitiro. ");
INSERT INTO flr_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Ukukulikirana na kwo Nahano âli mali gwanwa abwira Musa, bakahangira Harooni imirondo mitaluule, anakizi giyambala mu kukola Ahandu Heeru. Iyo mirondo ikahangwa mu nuzi za namukungumo, na zeꞌkituku-tuku, neꞌndukula. ");
INSERT INTO flr_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bakahangira Harooni ikangaata mu nuzi zeꞌkitaani, na mu nuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, na mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Iyo nooro, naluganda ye kagijongolola, anagihwahwatula mu kugira mweꞌnuzi. Ha nyuma, analilimbiisa neꞌnuzi zeꞌkitaani, na zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. ");
INSERT INTO flr_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Yiryo ikangaata, lyâli kweꞌbihogo bibiri byoꞌkushwekera kweꞌrya mikaba ha bitugo. ");
INSERT INTO flr_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Iyo mikaba ikalukwa mu nuzi zeꞌkitaani, na zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, na mu nooro. Ikanahangirwa kwiꞌkangaata, nga kwo Nahano âli mali gwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ha nyuma, banalingikania amabuye geꞌhonikisi, banagananika ku migwaso yeꞌnooro. Banagahokoorora kwaꞌmaziina ikumi na gabiri ga bagala Hisiraheeri, nga kwokulya umundu angahokoorora ku kamangu. ");
INSERT INTO flr_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Banagira nga kwo Nahano âli mali gwanwa abwira Musa, mu kugashwekera ku bihogo biꞌkangaata, gira Nahano akizi kengeerera kweꞌmilala ikumi niꞌbiri yaꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Yabo banaluganda, bakakoleesa ubuhinga, mu kulingaania ishaho ya ha kifuba, nga kwo bakalingaania ikangaata. Iyo shaho, banagihanga mu nuzi zeꞌkitaani, na mu nuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula, na mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Iyo shaho, imbande zaayo zooshi ziyumiini, zeꞌsendimeetere makumi gabiri na zibiri. Yanâli ngonye mwo kubiri. ");
INSERT INTO flr_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Iyo shaho, yâli leeziri mweꞌmiziizi ina yaꞌmabuye ágakeyengiini. Umuziizi gwa mbere gwâli riiri mwiꞌbuye lyeꞌsaridwane, na lyeꞌtopaazi, na lyeꞌhemeroode. ");
INSERT INTO flr_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Umuziizi gwa kabiri gwâli riiri mwiꞌbuye lyeꞌsikaribukile, na lyeꞌsafiiri, na lyeꞌdyama. ");
INSERT INTO flr_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Umuziizi gwa kashatu, gwâli riiri mwiꞌbuye lyeꞌyasito, na lyeꞌkarinaline, na lyeꞌhametisito. ");
INSERT INTO flr_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Umuziizi gwa kana, gwâli riiri mwiꞌbuye lyeꞌkirisolite, na lyeꞌhonikisi, na lyeꞌyasipi. Yago mabuye gooshi, gakananikwa ku migwaso íkatulwa mu nooro. ");
INSERT INTO flr_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Yago mabuye, kwo gâli riiri ikumi na gabiri, ngiisi liguma lyâli yandisirwi kwiꞌziina lya ngiisi mugala Hisiraheeri. Gâli mahokoorore nga kwo bali mu hokoorora akamangu. ");
INSERT INTO flr_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kwiꞌyo shaho, banahangira kweꞌmigufu yeꞌnooro muguuhya. ");
INSERT INTO flr_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Banatula neꞌmbete zibiri, babuli zibiika ku tusongo-songo twiꞌkano lyeꞌshaho. ");
INSERT INTO flr_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Iyo migufu yombi yeꞌnooro, banagihogeka mu yizo mbete zeꞌshaho ya ha kifuba. ");
INSERT INTO flr_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Amatwe gombi geꞌmigufu, banagashwekera kwiꞌrya migwaso yombi íri kweꞌbihogo, halinde ishaho yanakizi ba ku kikaraza. ");
INSERT INTO flr_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Banatula neꞌmbete zibiri mu nooro, banazinanika imbande zombi ziꞌdako ku shaho. Zanananikirwa mu nda, ahandu áhaloziri kwiꞌkangaata. ");
INSERT INTO flr_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Banatula izindi mbete zibiri mu nooro, banazibiika imbere ku tusongo-songo twiꞌdako tweꞌbihogo byombi íbiri kwiꞌkangaata, ngiisi hoꞌmukaba guleeziri. ");
INSERT INTO flr_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Iyo shaho, banaginanika kwiꞌkangaata mu kugishwekera ku mbete neꞌrya migozi íkalukwa mu nuzi ziꞌbara lya namukungumo. Kwokwo, lyo itatere, si iyame igwatiriiri umugozi gwiꞌkangaata. Byoshi bikagirwa, nga kwo Nahano akagwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Yiryo ikangaata, naluganda anahanga ikooti liꞌbara lya namukungumo, gira Harooni akizi liyambalira kwo. ");
INSERT INTO flr_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Yiryo ikooti, lyâli kizi siga ubutule bwoꞌkuleeza mwiꞌtwe. Yubwo butule, bâli buzungulusiizi kweꞌkindi kitubiko, lyo butabereke. ");
INSERT INTO flr_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ikano liꞌdako lyâli lilimbiise neꞌbishushanio byaꞌmakomamanga. Bikanagirwa mu nuzi zeꞌkitaani, na mu zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. ");
INSERT INTO flr_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Ha nyuma, banalingaania imbegere mu nooro. Yizo mbegere zanakizi biikwa ha kati-kati kaꞌmakomamanga. ");
INSERT INTO flr_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Kwokwo, yizo mbegere na yago makomamanga, byanakizi londana. Banabizungulusa kwiꞌkano lyoshi lya yiryo ikooti, nga kwo Nahano akagwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Banahangira Harooni na bagala baage ibyambalwa mu nuzi zeꞌkitaani. ");
INSERT INTO flr_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Mu gwogwo mulondo gweꞌkitaani, banalingaania mwoꞌmulondo gwoꞌkusoosa kwiꞌtwe, neꞌngofeera, noꞌtubutura. ");
INSERT INTO flr_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Kiri noꞌmukaba, gukalukwa mu nuzi zeꞌkitaani, na mu nuzi zoꞌbwoya bwiꞌbara lya namukungumo, na lyeꞌkituku-tuku, neꞌlidukula. Kwokwo, kwo bakagira byoshi, nga kwo Nahano akagwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ha nyuma, banamúgirira ulushembe mu nooro muguuhya. Banaluyandika kwo kwokuno: «Biri bitaluule imwa Nahano.» Bakayandika, nga kwo bali mu hokoorora akamangu. ");
INSERT INTO flr_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Yulwo lushembe, banakoleesa umugozi gwa namukungumo, mu kulushwekera ku mirondo ya kwiꞌtwe. Bikagirwa nga kwo Nahano âli mali gwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Imikolwa yoshi yiꞌheema lyeꞌmihumaanano, kwokwo, kwo ikayuta. Abahisiraheeri bakagira byoshi nga ngiisi kwo Nahano akagwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Kwokwo, banaleetera Musa iheema lyeꞌmihumaanano, kuguma neꞌbirugu byalyo byoshi, ngeꞌndoboro, neꞌmiganda, neꞌbiti byeꞌnzizi, neꞌnguliro, neꞌbiterekero byalyo. ");
INSERT INTO flr_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Banamúleetera noꞌmutumbikizo úgukagirwa mu mbu zeꞌbipanga, zinashiizirwi ibara lidukula. Hâli riiri neꞌzindi mbu ngomu. Hâli riiri noꞌmulondo gwoꞌkusiika Ahandu Heeru Bweneene. ");
INSERT INTO flr_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Hâli riiri naꞌKajumba keꞌKihango, neꞌbiti byoꞌkukabetulira kwo, noꞌmutumbikizo gwoꞌlukogo. ");
INSERT INTO flr_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Hâli riiri naꞌkashasha, kuguma neꞌbirugu byako byoshi, kiri neꞌmikate iyâli kizi tangwa imwa Rurema. ");
INSERT INTO flr_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Hâli riiri neꞌkiterekero kyaꞌmatara íkikatulwa mu nooro muguuhya. Hâli riiri naꞌmatara gaakyo, kiri neꞌbindi birugu byago, neꞌbitoro. ");
INSERT INTO flr_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Hâli riiri naꞌkatanda keꞌnooro muguuhya, naꞌmavuta goꞌkuyishiiga, noꞌmubadu gwoꞌmuhongolo mwija, noꞌmulondo gwoꞌkusiika ha mulyango gwiꞌheema. ");
INSERT INTO flr_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Hâli riiri naꞌkatanda ákakatulwa mu miringa, kuguma naꞌkayungiro kaako keꞌmiringa, neꞌbiti byako, neꞌbindi birugu byako. Hâli riiri noꞌmutanga, neꞌkiterekero kyagwo. ");
INSERT INTO flr_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Hâli riiri neꞌmirondo yoꞌkuzungulusa ulubuga, kuguma neꞌnguliro zaalwo, neꞌbiterekero byazo, noꞌmulondo gwa ha mulyango gwalwo. Hâli riiri neꞌmigozi yalwo kuguma neꞌmbambo zaalwo. Hâli riiri neꞌbindi birugu biꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Hâli riiri neꞌmirondo íkahangwa bwija, hiꞌgulu lyeꞌmikolwa yaꞌHandu Heeru. Kuli kudeta imirondo mitaluule yoꞌmugingiHarooni, kiri neꞌmirondo yo bagala baage bagakizi yambala ku kyanya bagaagira imikolwa yoꞌbugingi. ");
INSERT INTO flr_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Abahisiraheeri bakagira byoshi, nga ngiisi kwo Nahano âli mali gwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Musa anatanduula ngiisi mukolwa, anabona kwaꞌbandu keera bagira byoshi, nga kwo Nahano akagwanwa adeta. Kwokwo, Musa anabagashaanira. ");
INSERT INTO flr_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Ha nyuma, Nahano anabwira Musa: ");
INSERT INTO flr_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Lirya iheema lyeꞌmihumaanano, ulishingage umwezi gwa mbere, mu lusiku lwa mbere. ");
INSERT INTO flr_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Ikyanya mugaagira kwokwo, mulibiike mwo kalya Kajumba keꞌKihango. Ha nyuma, unakasiike, mu kumanika umulondo. ");
INSERT INTO flr_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Mu yiryo iheema, utereke mwaꞌkashasha, kuguma neꞌbirugu byako. Ukabuli yingiza mwo kirya kiterekero, unakinanike kwaꞌmatara. ");
INSERT INTO flr_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Unabuli biika mwo kalya katanda koꞌkuyokera kwoꞌmubadu, kalya ákakatulwa mu nooro. Kakizi beera imbere lyaꞌKajumba keꞌKihango. Ha nyuma, ha mulyango gwiꞌheema lyeꞌmihumaanano, uhabiike gulya mulondo. ");
INSERT INTO flr_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«Imbere lyoꞌmulyango gwoꞌkuyingira mwiꞌheema lyeꞌmihumaanano, ubiike mwo kalya katanda koꞌkusiriigiza kwaꞌmatuulo. ");
INSERT INTO flr_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ha kati kiꞌheema lyeꞌmihumaanano, naꞌkatanda koꞌkusiriigiza kwaꞌmatuulo, ubiike hoꞌmutanga gwoꞌkuyikarabira mwo, unaguyijuze mwaꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","«Yiryo iheema, ulubuga lwalyo luzitire, unabiike neꞌmirondo ha mulyango. ");
INSERT INTO flr_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Ha nyuma, yiryo iheema kuguma neꞌbirugu byalyo byoshi, ubishiige kwaꞌmavuta. Kwokwo, lyo ugaaba wabitaluula imwani, halinde bikizi yama biri bitaluule. ");
INSERT INTO flr_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","«Ha nyuma kandi, ukataluule akatanda koꞌkusiriigiza kwaꞌmatuulo, kuguma neꞌbirugu byako byoshi. Ubishiige kwaꞌmavuta, halinde bibe bikola bitaluule lwoshi-lwoshi. ");
INSERT INTO flr_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kiri noꞌmutanga gwoꞌkuyikarabira mwo, neꞌkiterekero kyagwo, nabyo ubitaluule. ");
INSERT INTO flr_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Ha nyuma, uleetage Harooni na bagala baage, bayije ha mulyango gwiꞌheema lyeꞌmihumaanano, unabakarabe naꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ubuli yambika Harooni birya byambalwa bitaluule. Unamúshiige amavuta mu kumútaluula, halinde abe mugingi woꞌkukizi ngolera. ");
INSERT INTO flr_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","«Uhamagale na bagala baage. Nabo, unabayambike galya makanju gaabo. ");
INSERT INTO flr_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Nabo, unabashiige amavuta, nga ngiisi kwo wagashiiga yishe, gira lyo bakizi ngolera mu bugingi. Yukwo kubashiiga amavuta, kwo kugababiika mu mukolwa gwoꞌbugingi bweꞌmyaka neꞌmyakuula, halinde mu bibusi byabo byoshi.» ");
INSERT INTO flr_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Yibyo byoshi, Musa anabigira, nga ngiisi kwo Nahano akamútegeka. ");
INSERT INTO flr_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Iri bakahisagya umwaka muguma bakoli lyosiri i Miisiri, mu lusiku lwa mbere lwoꞌmwezi gwa mbere, banataluula yiryo iheema. ");
INSERT INTO flr_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Ikyanya Musa akatondeera ukulishinga, anatereka ibiterekero byalyo, anashinga ibiti, anabiika inzizi, anashinga neꞌnguliro. ");
INSERT INTO flr_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ha nyuma, Musa anayajuulira gulya mulondo kwiꞌheema, gwanalibwikira, nga kwo Nahano akagwanwa amúbwira. ");
INSERT INTO flr_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Anatwala galya mabuye gabiri mabaaje ágakahokoororwa kweꞌmaaja, anagabiika mu Kajumba Kataluule. Anayabiira birya biti byoꞌkubetulira kwaꞌKajumba, anabifunda mu zirya mbete zaako, anakatumbikira kwoꞌmutumbikizo gwoꞌlukogo. ");
INSERT INTO flr_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ha nyuma, yako Kajumba keꞌKihango, Musa anakayingiza mwiꞌheema, anamanika gulya mulondo gwoꞌkukasiika, nga ngiisi kwo Nahano akagwanwa amúbwira. ");
INSERT INTO flr_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mu kati kiꞌheema, uluhande lweꞌmbembe, anabiika akatanda imbuga lyoꞌmulondo. ");
INSERT INTO flr_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Anakatereka kweꞌmikate iyâli kizi tangwa imwa Nahano, nga ngiisi kwo Nahano âli mali gwanwa amúbwira. ");
INSERT INTO flr_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Mwomwo mu lirya iheema, anabiika mweꞌkiterekero kyaꞌmatara. Kikabiikwa i kajabo kaꞌkashasha, uluhande lweꞌkisaka lwiꞌheema. ");
INSERT INTO flr_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Anabuli yasa amatara imbere lya Nahano, nga ngiisi kwo Nahano akagwanwa amúbwira. ");
INSERT INTO flr_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mwomwo mwiꞌheema, imbere lyoꞌmulondo, anabiika mwo kalya katanda keꞌnooro koꞌkuyokera kwoꞌmubadu. ");
INSERT INTO flr_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Anakayokera kwoꞌmubadu gwoꞌmuhongolo mwija, nga ngiisi kwo Nahano âli mali gwanwa amúbwira. ");
INSERT INTO flr_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ha mulyango gwoꞌkuyingira mwiꞌheema, anahamanika umulondo. ");
INSERT INTO flr_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Haaho ha mulyango, anahatereka akatanda koꞌkusiriigiza kwaꞌmatuulo, anakatangira kwiꞌtuulo lyoꞌkusiriiza lwoshi, kiri naꞌmatuulo goꞌmushyano, nga ngiisi kwo Nahano âli mali gwanwa amúbwira. ");
INSERT INTO flr_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ha kati ka lirya iheema naꞌkatanda koꞌkusiriigiza kwaꞌmatuulo, anahatereka umutanga gwoꞌkuyikarabira mwo. Anabuli biika mwaꞌmiiji goꞌkuyikaraba. ");
INSERT INTO flr_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Kwokwo, Musa na Harooni, kiri na bagala baage, booshi banakizi gukoleesa, mu kuyikarabira mwaꞌmaboko naꞌmagulu. ");
INSERT INTO flr_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ngiisi kyanya bâli kizi yingira mwiꞌheema, kandi iri bayegeera kalya katanda, bâli kizi yikaraba, nga ngiisi kwo Nahano âli mali gwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Iri hakazinda, Musa anazungulusa yiryo iheema, kiri naꞌkatanda, uluzitiro. Anabuli biika umulondo ha mulyango gwalwo. Kwokwo, kwo Musa akakwiza imikolwa yoshi. ");
INSERT INTO flr_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Lyeryo, yiryo iheema lyeꞌmihumaanano lyanayijula mwoꞌbulangashane bwa Nahano. ");
INSERT INTO flr_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Musa, atanashobola ukuliyingira mwo, bweꞌkibungu kyâli mali shonookera kwiꞌheema, noꞌbulangashane bwa Nahano, bwanaliyijula mwo. ");
INSERT INTO flr_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Yabo Bahisiraheeri, ikyanya bâli kizi balama, ikibungu kyâli kizi tee nunga, banabuli shokola injira. ");
INSERT INTO flr_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Haliko yikyo kibungu, ikyanya kitazi nunga, bâli kizi lindirira haaho, halinde ku kyanya kiganunga. ");
INSERT INTO flr_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Ikyanya kya mwiꞌzuuba, ngiisi ho bâli kizi genda, yikyo kibungu kya Nahano kyâli kizi beera hiꞌgulu liꞌheema. Na mu bushigi, kyâli kizi boneka nga muliro.");
INSERT INTO flr_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ikyanya Nahano âli riiri mwiꞌheema lyeꞌmihumaanano, anahamagala Musa, anamútuma ");
INSERT INTO flr_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","kwo agendi menyeesa Abahisiraheeri kwokuno: «Mu kati kiinyu, iri hangaba umundu úloziizi ukutangira Nahano ikitugwa libe ituulo lyoꞌkusiriiza, angakitoola mu ngaavu, kandi iri mu bibuzi, kandi iri mu mbene. ");
INSERT INTO flr_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","«Yiryo ituulo lyoꞌkusiriiza lwoshi, iri yangaba ngaavu, ikwaniini ibe shuuli, inabe nzira kashembo. Anagisholere halinde ha mulyango gwiꞌheema lyeꞌmihumaanano. Kwokwo, lyo Nahano amúyemeera. ");
INSERT INTO flr_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","«Mu kutanga yiryo ituulo lyeꞌkitugwa, uyo mundu alambike ukuboko mu ruhanga lwakyo. Mango agira kwokwo, Nahano agayemeera kwo kyafwa hiꞌgulu lyage, anamúkoge ibyaha byage. ");
INSERT INTO flr_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Haaho, akitongeerere imbere liꞌheema lyeꞌmihumaanano. Umuko gwakyo, abagingi bagala Harooni, bagaguyabiira, banagushangire imbande zooshi zaꞌkatanda ákali ha mulyango gwiꞌheema. ");
INSERT INTO flr_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Haaho, akihonie uluhu, abuli kitenga bitolo-bitolo. ");
INSERT INTO flr_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","«Yabo bagingi bagashasha ishaali, banayase umuliro. ");
INSERT INTO flr_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Banayabiirage irya mihoole, kuguma niꞌtwe, noꞌlusha, banabilambike ku zirya shaali. ");
INSERT INTO flr_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Halikago, ubula neꞌbirenge, byohe bigatee shukwa. Yibyo byoshi, umugingi anabisiriigize ku katanda, libe ituulo lyoꞌkusiriiza lwoshi. Kwokwo, umushiiriri gwalyo, gunasimiise Nahano. ");
INSERT INTO flr_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Yiryo ituulo lyoꞌkusiriiza lwoshi, iri lyangaba kiri kibuzi kandi iri mbene, kikwaniini kibe kipanga, kandi iri kihebe, kinabe kizira kashembo. ");
INSERT INTO flr_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Yikyo kitugwa, uyo mundu akitongeerere imbere liꞌheema lyeꞌmihumaanano, uluhande lweꞌmbembe lwaꞌkatanda. Noꞌmuko gwakyo, abagingi, bagala Harooni, bagushangire ku katanda, imbande zaako zooshi. ");
INSERT INTO flr_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Haaho yikyo kitugwa, akitole-tole, anashaaze itwe, noꞌlusha. Yibyo byoshi, umugingi muguma anabibiike ku shaali ízikoli yasiri. ");
INSERT INTO flr_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Halikago, ubula neꞌbirenge, byohe bikwaniini bitee shukwa. Yibyo byoshi, umugingi agabisiriiza, libe ituulo lyoꞌkusiriiza lwoshi. Kwokwo, umushiiriri gwalyo gunasimiise Nahano. ");
INSERT INTO flr_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Yiryo ituulo lyoꞌkusiriiza lwoshi, iri lyangaba kali kanyuni, likwaniini libe ihumba, kandi iri mutungulu gweꞌngunde. ");
INSERT INTO flr_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Yako kanyuni, umugingi agakaleeta ku katanda, anakanyole itwe. Agatee yona umuko gwako, guhingire mu matambi gaꞌkatanda, akabuli kasiriiza. ");
INSERT INTO flr_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Yako kanyuni, agagwanwa akaduutula akafooge, anakakabule isheere yaꞌkatanda, ngiisi hoꞌmunyota-kiiko guli mu biikwa. ");
INSERT INTO flr_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Anabuli kagwatira ku byubi, anakagabaanule. Haliko, atagayami kalungulula. Ha nyuma, anakasirigiize ku katanda, libe ituulo lyoꞌkusiriiza lwoshi. Kwokwo, umushiiriri gwalyo, gunasimiise Nahano. ");
INSERT INTO flr_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Ikyanya ugatangira Nahano ituulo lyoꞌmushyano, gube mulembu. Uguyoonere mwaꞌmavuta, unagufushe mwoꞌmubadu. ");
INSERT INTO flr_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Haaho, uguleetere abagingi, beene Harooni. Yugwo mushyano, mugingi muguma agushamate kweꞌfune nguma, anagusiriigize ku katanda. Yiryo ituulo, liri lyoꞌbukengeeze, liganasiriizibwa lwoshi. Ikyanya Nahano agayuvwa umushiiriri gwalyo, agasiima. ");
INSERT INTO flr_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","«Yiryo ituulo lyoꞌmushyano, umutuli úgugasigala, guli gweꞌmwa Harooni na bagala baage. Mu matuulo goꞌkusiriiza gooshi ágali mu tangwa imwa Nahano, yiryo lyo litaluule bweneene. ");
INSERT INTO flr_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«Ituulo lyawe lyoꞌmushyano, iri lyangaba lya kuyokera mu kiyokero, libe lya bitumbula kandi iri galeeti, bikaate mu mushyano mulembu na muzira saama, gunabe gubushirwi mwaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","«Yiryo ituulo, iri lyangaba lya kukalangirwa ku mibangala, likwiriiri libe lya mushyano mulembu, mufushe mwaꞌmavuta, haliko muzira saama. ");
INSERT INTO flr_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Bagalikoojola-koojola, banashubi liyonera kwaꞌmavuta. Yiryo ituulo, liri lya mushyano. ");
INSERT INTO flr_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","«Yiryo ituulo lyoꞌmushyano, iri lyangaba lya kukalangira mu nyungu, likwiriiri libe lya mushyano mulembu, mufushe mwaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ulileete imwa Nahano, unalisikiirize umugingi, gira alitwale ku katanda. ");
INSERT INTO flr_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Uyo mugingi agayabiira umutuli gwoꞌkukengeezania, anagusiriize, libe ituulo lyoꞌkusiriiza. Ikyanya ligasiriizibwa, umushiiriri gwalyo gugasimiisa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","«Yiryo ituulo, umutuli úgugasigala, gugahaabwa Harooni na bagala baage. Mu matuulo goꞌkusiriiza gooshi ágali mu tangwa imwa Nahano, yiryo lyo litaluule bweneene. ");
INSERT INTO flr_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«Ikyanya ugatangira Nahano amatuulo goꞌmushyano, utakolwe kwo wagufusha mweꞌsaama. Bwo guli gwiꞌtuulo lyoꞌkusiriiza, bitahangwirwi ukugufusha mweꞌsaama kandi iri buuki. ");
INSERT INTO flr_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","«Ikyanya ugaleetera Nahano itomola, utagaliyokera ku katanda, mbu lyo liba noꞌmushiiriri mwija imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","«Ikyanya ugatanga ituulo lyoꞌmushyano, ukizi lilunga mwoꞌmuunyu. Utakolwe kwo wayibagira ukulilunga. Mukuba, yugwo muunyu, guli mu kengeeza ikihango kyo Rurema akanywana na niinyu. ");
INSERT INTO flr_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«Iri wangatangira Nahano itomola lyoꞌmushyano, ukizi tee kalanga imihuli, ukabuli gijiga. ");
INSERT INTO flr_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Yiryo ituulo lyoꞌmushyano, ukizi tee lifuka mwaꞌmavuta, unabiike kwoꞌmubadu. ");
INSERT INTO flr_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Umugingi agayabiira mwo umutuli gwoꞌkukengeezania, anagusiriize kuguma na yugwo mubadu gwoshi, gutangirwe Nahano libe ituulo lyoꞌkusiriiza. ");
INSERT INTO flr_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Hali ikyanya umundu angatanga ingaavu, libe ituulo lyoꞌkuyerekana ingoome. Iyo ngaavu, yangaba shuuli kandi iri nyana, haliko, ikwaniini ibe nzira kashembo. ");
INSERT INTO flr_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Yikyo kitugwa, akilambike ukuboko mu ruhanga, anakitongeerere ha mulyango gwiꞌheema lyeꞌmihumaanano. Umuko gwakyo, abagingi, bagala Harooni, bagaguyonera imbande zooshi zaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","«Umugingi muguma, anasikiirize ikitolo kyakyo imwa Nahano, kibe kitaluule. Mu kati kaabyo, muli ulusha lwoshi úlubwisiri ibijogombe, ");
INSERT INTO flr_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","neꞌfiko zombi, neꞌbinyule byazo, kuguma niꞌrembe lyoꞌbudiku. ");
INSERT INTO flr_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Yibyo byoshi, abagingi banabibiike ku katanda, ku zirya zindi nyama ízibiisirwi ku shaali. Yiryo, liri ituulo lyoꞌkusiriiza lwoshi. Ikyanya Nahano agayuvwa umushiiriri gwalyo, agasiima. ");
INSERT INTO flr_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Yiryo ituulo lyoꞌkuyerekana ingoome, iri wangalilyosa mu bibuzi byawe, kandi iri mu mbene, igaaba shaashi, kandi iri kipanga, kandi iri kihebe. Haliko, kikwaniini kibe kizira kashembo. ");
INSERT INTO flr_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","8","«Yiryo ituulo, iri lyangaba kyanabuzi, ukitwale imbere liꞌheema lyeꞌmihumaanano, unakilambike ukuboko mu ruhanga, unakitongeere. Umuko gwakyo, bagala Harooni bagagushangira imbande zooshi zaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Umugingi, agayabiira ibinyule byakyo, anabiyegeze imbere lya Nahano, anamúsikiirize byo. Mu yibyo binyule, muli umukira gwoshi, ukutolerwa hoofi niꞌvuha lyoꞌmugongo, kuguma noꞌlusha lwoshi úlubwisiri ibijogombe noꞌlutoolero, ");
INSERT INTO flr_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","na zirya fiko zombi neꞌbinyule byazo, kuguma niꞌrembe lyoꞌbudiku. Yibyo byoshi agabibiika kuguma neꞌfiko, ");
INSERT INTO flr_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","anabisiriigize ku katanda, gira bitangwe imwa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Yiryo ituulo, iri lyangaba iri mbene, ugitwale imbere liꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Ulambike ukuboko mu ruhanga lwayo, unagitongeere. Abagingi, bagala Harooni, bagashangira umuko gwayo imbande zooshi zaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","«Iyo mituli, umugingi agagishegeza imbere lya Nahano, iri anagisiriiza. Luli lusha lwoshi úlubwisiri ibijogombe noꞌlutoolero, ");
INSERT INTO flr_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","na zirya fiko zombi, neꞌbinyule byazo, niꞌrembe lyoꞌbudiku. ");
INSERT INTO flr_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Yibyo byoshi, bishaazibwe kuguma neꞌfiko. Umugingi, agabisiriigiza ku katanda. Yiryo ituulo, biri byokulya bitaluule. Yibyo binyule byoshi, biri bitaluule imwa Nahano. Umushiiriri gwabyo gugamúsimiisa. ");
INSERT INTO flr_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","«Kwokwo, mutahangwirwi ukukizi lya ulusha, kandi iri ukulya umuko. Yulu lubaaja, luli lweꞌmyaka neꞌmyakuula. Mukwaniini mukizi lusimbaha ku bibusi byoshi, ngiisi ho mugakizi tuula.» ");
INSERT INTO flr_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","kwo amenyeese Abahisiraheeri kwokuno: «Hali ikyanya umundu angakengeera agira ikyaha mu kutagalwa. Yikyo kyaha, kinabe kilahiziibwi neꞌmaaja za Nahano. Lolagi ngiisi kwoꞌmundu akwiriiri ukugira: ");
INSERT INTO flr_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","«Ku mugani, umugingi mukulu, iri angaba ye wakola ibyaha, iri ahubiisa abandu booshi. Ku yukwo, akwiriiri atangire Nahano ishuuli nzira kashembo, libe ituulo lyoꞌkukogwa ibyaha byage. Yiryo ituulo, likwaniini. ");
INSERT INTO flr_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Iyo shuuli, agisholere halinde ha mulyango gwiꞌheema lyeꞌmihumaanano. Agagilambika kwoꞌkuboko kwage mu ruhanga, anagitongeerere yaho imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","«Uyo mugingi, ayabiire umuko, anagutwale mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Ha nyuma, anagudobeke mwoꞌmunwe, anagushangire ku mulondo úgusiisiri Ikisiika Kyeru Bweneene, ku luhande lwagwo úlubonesiri. Akizi gira kwokwo imbere lya Nahano, ubugira kalinda. ");
INSERT INTO flr_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","«Ugundi muko, anagubuge ku tugongo twaꞌkatanda ka mwiꞌheema lyeꞌmihumaanano, kalya koꞌkuyokera kwoꞌmubadu. Na úgugasigala, anaguyonere ku biterekero byaꞌkatanda ka ha mulyango gwiꞌheema, kalya koꞌkusiriigiza kwaꞌmatuulo. ");
INSERT INTO flr_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","«Ha nyuma, anayabiire birya binyule, kuli kudeta ulusha, ");
INSERT INTO flr_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","neꞌfiko zombi, neꞌbinyule byazo, niꞌrembe lyoꞌbudiku. Yibyo byoshi, banabilyokeze kuguma. ");
INSERT INTO flr_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ikyanya bali mu tanga ishuuli kwo libe ituulo lyoꞌkuyerekana ingoome, yibyo binyule, bali mu kizi bishaaza, lyoꞌmugingi mukulu abiyokere ku katanda koꞌkusiriigiza kwaꞌmatuulo. ");
INSERT INTO flr_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","«Halikago, íbyasigala kwiꞌyo shuuli, akwaniini abihulukane imbuga lyeꞌshumbi. Kuli kudeta uluhu, neꞌminyofu, na purungu, neꞌbirenge, neꞌbijogombe, naꞌmashe. Agagendi bibiika áhayerusiibwi, ngiisi hoꞌmunyota-kiiko guli mu yonerwa, anabiyokere ku shaali. Byoshi, abisiriigize ku ndundo yoꞌmunyota-kiiko. ");
INSERT INTO flr_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","«Ku mugani Abahisiraheeri booshi, iri bangaba bahubira ulubaaja lwa Nahano, buzira kugiriirira. Kundu kwokwo, bagaaba baki luhubiiri. ");
INSERT INTO flr_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ikyanya bagasobanukirwa kwo bahuba, bakwiriiri batangire Rurema ishuuli, libe ituulo lyoꞌkukogwa ibyaha. Iyo shuuli, bagisholere halinde hiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Abashaaja baabo, bakwaniini bagilambike kwaꞌmaboko mu ruhanga, banagitongeerere imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","«Umuko gweꞌyo shuuli, ulya mugingi mukulu, atee twala muniini mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Anagudobeke mwoꞌmunwe, anagushangire ku mulondo úgusiisiri Ikisiika Kyeru Bweneene, ku luhande lwagwo úlubonesiri. Akizi gira kwokwo imbere lya Nahano, ubugira kalinda. ");
INSERT INTO flr_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","«Ugundi muko, anagubuge ku tugongo twaꞌkatanda ka mwiꞌheema lyeꞌmihumaanano, kalya koꞌkuyokera kwoꞌmubadu. Na úgugasigala, aguyonere ku biterekero byaꞌkatanda ka ha mulyango gwiꞌheema, kalya koꞌkusiriigiza kwaꞌmatuulo. ");
INSERT INTO flr_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","«Ha nyuma, anayabiire birya binyule, anabiyokere ku katanda. ");
INSERT INTO flr_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","«Iyo shuuli, agigire nga kwokulya akagira irya yabo, mu kukogwa ibyaha byage. Kwokwo, kwoꞌyo mugingi mukulu agayeruusa Abahisiraheeri booshi, halinde banakogwe ibyaha, banashubi kwanana imbere lya Rurema. ");
INSERT INTO flr_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","«Íbyasigala kwiꞌyo shuuli, uyo mugingi akwiriiri abihulukane imbuga lyeꞌshumbi, anagendi biduulika kwoꞌmuliro, nga kwo akagira irya yabo yo akatanga ituulo lyoꞌkukogwa ibyaha byage. Kwokwo, yiryo ituulo ligakizi tangwa, gira lyaꞌBahisiraheeri booshi balonga ukukogwa. ");
INSERT INTO flr_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","«Ku mugani, umushaaja waꞌkaaya, iri angaba ahubira ulubaaja luguma lwa Rurema Nahamwabo, buzira kugiriirira. Kundu kwokwo, agaaba aki luhubiiri. ");
INSERT INTO flr_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","«Ikyanya agasobanukirwa neꞌkyaha kyage, akwaniini atange ituulo lyeꞌkihebe, kinabe kizira kashembo. ");
INSERT INTO flr_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Agakilambika kwoꞌkuboko mu ruhanga, anakitongeerere ho bali mu tongeerera amatuulo goꞌkusiriiza imbere lya Nahano. Yiryo, liri ituulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","«Umuko gwa yikyo kihebe, umugingi agagudobeka mwoꞌmunwe, anagushangire ku katanda koꞌkusiriigiza kwaꞌmatuulo. Na úgugasigala, anaguyonere ku biterekero byako. ");
INSERT INTO flr_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Ibinyule, anabiyokere ku katanda, nga kwokulya bali mu gira ituulo lyoꞌkukogwa ibyaha. Mu kugira kwokwo, umugingi agaaba ayeruusa ikyaha kyoꞌyo mutwali, halinde akogwe ibyaha byage, anashubi kwanana imbere lya Rurema. ");
INSERT INTO flr_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","«Ku mugani, abagunda iri bangaba bahubira ulubaaja luguma lwa Nahano, buzira kugiriirira. Kundu kwokwo, bagaaba baki luhubiiri. ");
INSERT INTO flr_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","«Ikyanya bagasobanukirwa kwo bagira ikyaha, bagaleeta imbene nzira kashembo, ibe ituulo lyoꞌkukogwa ibyaha byabo. ");
INSERT INTO flr_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Bagagilambika kwaꞌmaboko mu ruhanga, banagitongeerere ho bali mu tongeerera ibitugwa íbyatangwa ituulo. ");
INSERT INTO flr_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","«Umuko gweꞌyo mbene, umugingi agagudobeka mwoꞌmunwe, anagubuge ku tugongo twaꞌkatanda. Na úgugasigala, aguyonere ku biterekero byako. ");
INSERT INTO flr_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","«Ibinyule bigashaazibwa nga kwokulya bali mu gira kwiꞌtuulo lyoꞌkuyerekana ingoome. Umugingi anabiyokye, lyoꞌmushiiriri gwabyo gusimiisa Nahano. Mu kugira kwokwo, umugingi agaaba ayeruusa yabo bandu, halinde bakogwe, banashubi kwanana imbere lya Rurema. ");
INSERT INTO flr_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","«Yabo bandu, iri bangasiima ukutanga ikibuzi, bakwiriiri baleete ikishaashi kizira kashembo, libe ituulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Banakilambike kwaꞌmaboko mu ruhanga, banakitongeerere ngiisi ho bali mu tongeerera ibitugwa íbyatangwa imwa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","«Yikyo kishaashi, umuko gwakyo, umugingi agagudobeka mwoꞌmunwe, anagubuge ku tugongo twaꞌkatanda. Na úgugasigala, akwaniini aguyonere ku biterekero byako. ");
INSERT INTO flr_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Ibinyule byoshi, bakwiriiri babishaaze, nga kwokulya bali mu gira ku kibuzi kyoꞌkutangwa hiꞌgulu lyoꞌkuyerekana ingoome. Umugingi agabiyokera ku katanda kuguma naꞌgandi matuulo ágali mu tangwa imwa Nahano. Kwokwo, kwo agaaba ayeruusa yabo bandu, halinde bakogwe ibyaha byabo, banashubi kwanana imbere lya Rurema. ");
INSERT INTO flr_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","«Ku mugani, umundu angahamagalwa naꞌbatwi beꞌmaaja kwo ayiji tanga ubumasi bwiꞌgambo lyo akabona, kandi iri lyo akayuvwa. Iri angalahira kwo atagagendi budeta, yayewe imwage. Agaharuurwa kwo ye wagira ikyaha, anayiji hanwa hiꞌgulu lyakyo. ");
INSERT INTO flr_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","«Kandi iri tudete kwo umundu angahuma ku kindu kyoꞌmuziro, nga mutumba gweꞌkitugwa, kandi iri gweꞌnyamiishwa, kandi iri gwa íbiri mu yibulula. Yikyo kyaha, kundu angaba atakigiriirira, haliko agaaba ayiyulubaza, anahanwe. ");
INSERT INTO flr_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","«Kandi iri, hali ikyanya angakengeera ahuma ku kindu kyoꞌmuziro, anabe atayiji kwo akihuma kwo. Kundu kwokwo, iri angayiji menyaga, akwaniini ayami yemeera kwo akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","«Hali neꞌkyanya angahwijikala, mu kubiika indahiro kwo agaagira igambo lirebe. Iyo ndahiro, yangalola kwiꞌgambo liija, kandi iri libi. Yiryo igambo, kundu agayiji liyibagira, haliko agaki hanwa hiꞌgulu lyalyo. ");
INSERT INTO flr_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","«Amagambo mwene yago gooshi, ikyanya umundu agayiji menya kwo agahuba kwo, akwiriiri ayemeere ikyaha kyage. ");
INSERT INTO flr_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Yikyo kyaha, mu kugira kwo akikogwe, akwiriiri aleete ishaashi yeꞌkibuzi, kandi iri yeꞌmbene. Umugingi anagitange imbere lya Nahano, libe ituulo lyoꞌkukogwa ibyaha byage, halinde anashubi kwanana imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","«Umundu, iri angaba aloziizi ukutanga ituulo lyoꞌkukogwa ibyaha byage, anabe atahiiti ubulyo bwoꞌkutanga ikibuzi, kandi iri mbene, ahangwirwi ukuleetera Nahano amahumba gabiri, kandi iri mitungulu ibiri yeꞌngunde. Akanyuni kaguma kagatangwa, libe ituulo lyoꞌkukogwa ibyaha byage. Akaabo, libe ituulo lyoꞌkusiriiza lwoshi. ");
INSERT INTO flr_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","«Yutwo tunyuni, atutwalire umugingi. Uyo mugingi naye, agatee tanga kalya kanyuni ka mbere, hiꞌgulu lyoꞌkukogwa ibyaha. Agakanyola igosi, haliko, atagayami kasingula itwe lwoshi. ");
INSERT INTO flr_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","«Yako kanyuni, umuko gwako, agaguyabiira kwo, anagubuge mu matambi gaꞌkatanda. Úgugasigala, aguyonere ku biterekero byako. Kwokwo yiryo, liꞌtuulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","«Ha nyuma, uyo mundu abuli tangaga kalya kandi kanyuni, libe ituulo lyoꞌkusiriiza lwoshi, nga kwo keera byayandikwa hano. Kwokwo, kwoꞌmugingi agamúyeruusa mu kulyosa ikyaha kyo akagira. Rurema anamúkoge, halinde anashubi kwanana imbere lyage. ");
INSERT INTO flr_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","«Neꞌri umundu angaba atahiiti ubulyo bwoꞌkugula yago mahumba gombi, kandi iri iyo mitungulu yombi yeꞌngunde, aleetage ikilo kiguma kyoꞌmushyano mwija, libe ituulo lyoꞌkukogwa ibyaha byage. Yugwo mushyano, bwo liri ituulo lyoꞌkukogwa ibyaha, atakolwe kwo agufusha mwaꞌmavuta, kandi iri agubiika mwoꞌmubadu. ");
INSERT INTO flr_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","«Yugwo mushyano, agutwalire umugingi. Ulya mugingi agagushamata kweꞌfune nguma, ibe yoꞌkukengeezania, anaguyokere ku katanda, kuguma naꞌgandi matuulo ágali mu siriizibwa hiꞌgulu lya Nahano. Yiryo, liri ituulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","«Yibyo byoshi, ikyanya umugingi agakizi bigira, iri ayeruusa ngiisi úli mu ba agira ikyaha. Uyo mundu, Rurema anamúkoge, anashubi kwanana imbere lyage. Umushyano úgwasigala, gugaaba gwoꞌmugingi, nga kwokulya biri mu ba ku matuulo goꞌmushyano.» ");
INSERT INTO flr_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Nahano anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Hali ikyanya umundu angakengeera ahubira Nahano, mu kuleka ukumútangira íbimúkwaniini. Akwaniini alole mu bibuzi byage, analeetere Nahano ikipanga kiguma, kinabe kizira kashembo. Kandi iri aleete iharija ízangaatwa ikipanga, ukukulikirana noꞌlugero úluli mu koleesibwa Ahandu Heeru. Yikyo kitugwa, akitangage, libe ituulo lyoꞌkuhyula. ");
INSERT INTO flr_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","«Uyo mundu, bwo ataki tanga ngiisi byo ashuba agatanga, akwaniini abitangage, anayushuule kweꞌkihande kiguma kya kataanu. Yibyo byoshi, anabisikiirize umugingi. Haaho, umugingi anamúyeruuse, mu kutanga kirya kipanga, libe ituulo lyoꞌkuhyula. Kwokwo, kwo uyo mundu agaakogwa ibyaha byage, anashubi kwanana imbere lya Rurema. ");
INSERT INTO flr_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Hali ikyanya umundu angahubira ulubaaja lwa Nahano. Na kundu atashubi yiji kwo aluhubiiri, haliko agaki hanwa hiꞌgulu lyalwo. ");
INSERT INTO flr_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","«Iri byangaba kwokwo, akwaniini alole mu bibuzi byage, analeetere umugingi ikipanga, kinabe kizira kashembo. Kandi iri agula íkiri neꞌkishingo kyakyo. Haaho, lyoꞌmugingi agamúyeruusa, halinde anakogwe ibyaha byage, anashubi kwanana imbere lya Rurema. ");
INSERT INTO flr_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Yiryo, liri ituulo lyoꞌkuhyula, bwo ashuba munamahube imbere lya Nahano.» ");
INSERT INTO flr_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","«Hali ikyanya umundu angasikirizibwa ikindu, mbu akilange. Haliko anayiji beesha hiꞌgulu lyakyo, kandi iri angaba akizimba, kandi iri akiyitiiza, kandi iri akilyalyania. Haaho agaaba keera ahuba imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","Kandi iri angamútoolera ikindu, analahire kwo atakibona. Kandi iri angabiika indahiro yeꞌbibeesha. Kandi iri angagira ikindi kyaha íkishushiri na yibyo byabo. ");
INSERT INTO flr_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","«Iri angaba agira ikyaha mwene yibyo, akwaniini ukuhanwa. Haaho, yikyo kindu, akwiriiri akigalulire ulya mutuulani, kiba akakizimba, kandi iri akamúgunga kyo ku misi, kandi iri akakibikiisibwa, kandi iri akakitoola. ");
INSERT INTO flr_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","Ngiisi kindu kyo akabiikira kweꞌndahiro yeꞌbibeesha, akwiriiri akigalule. Na kwakundi, akiyushuule kweꞌkihande kiguma kya kataanu kyeꞌkishingo kyakyo. Ku lwolwo lusiku, akwaniini aleete ikitugwa kyoꞌkutangwa ituulo lyoꞌkuhyula. ");
INSERT INTO flr_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Yikyo kitugwa, kibe kipanga, kinabe kizira kashembo, kinabe kandi neꞌkishingo íkikwaniini. ");
INSERT INTO flr_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","«Mango agira kwokwo, umugingi agamúyeruusa imbere lya Nahano. Ngiisi kyaha kyo agaaba agira, agakikogwa, anabe akoli kwaniini imbere lya Rurema.» ");
INSERT INTO flr_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Nahano anashubi bwira Musa kwo amenyeese ");
INSERT INTO flr_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Harooni na bagala baage kwokuno, hiꞌgulu liꞌtuulo lyoꞌkusiriiza lwoshi: «Yiryo ituulo, likwaniini lilaale yaho ku katanda, halinde shesheezi. Noꞌmuliro, guyame guyasiri. ");
INSERT INTO flr_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Umugingi akwaniini ayambale imirondo yage yoꞌbugingi mihange mu nuzi zeꞌkitaani, analyose umunyota-kiiko ku katanda, anagubiike ha butambi lyako. ");
INSERT INTO flr_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","«Ha nyuma, anashubi hogola imirondo yage yoꞌbugingi, anashubi yambala imirondo ya ngiisi lusiku, akabuli hulukiza umunyota-kiiko inyuma lyeꞌshumbi, áhayerusiibwi. ");
INSERT INTO flr_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","«Umuliro gukwaniini gukizi yama guyasiri ku katanda. Ngiisi shesheezi, umugingi akwaniini akizi shuuvya ishaali, anabiike ikitugwa kiꞌtuulo lyoꞌkusiriiza lwoshi hiꞌgulu lyazo. Abuli yokya ibinyule byaꞌmatuulo goꞌkuyerekana ingoome. ");
INSERT INTO flr_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Yugwo muliro, gukwaniini gukizi yaka ku katanda, utanakolwe kwo waguleka guzime. ");
INSERT INTO flr_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","«Imaaja íziloziri ituulo lyoꞌmushyano zo zeezino: Yiryo ituulo, bagala Harooni bo bakwaniini ukukizi litwala ku katanda, imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yiryo ituulo, umugingi muguma agalishamata kweꞌfune nguma yoꞌmushyano mufushe mwaꞌmavuta, kuguma noꞌmubadu gwalyo gwoshi. Yugwo mutuli gwiꞌtuulo, agaguyokera ku katanda, gube gwoꞌkukengeezania. Ikyanya Nahano agayuvwa umushiiriri gwalyo, agasiima. ");
INSERT INTO flr_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«Umushyano úgugasigala, Harooni naꞌbagala, bagaagulya. Kundu kwokwo, gukwaniini guyokibwe buzira kugufusha mweꞌsaama. Yiryo ituulo, bakwaniini baliliire mu lubuga lwiꞌheema lyeꞌmihumaanano, ngiisi áhatalwirwi. ");
INSERT INTO flr_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","«Yugwo mushyano, batakolwe mbu baguyokere kuguma neꞌsaama. Yugwo mutuli, Nahano akagutaluulira abagingi, ku matuulo go bali mu mútangira ku muliro. Kwokwo, yugwo mutuli gukoli talwirwi bweneene imwa Nahano, ngiꞌtuulo lyoꞌkukogwa ibyaha, kandi iri lyoꞌkuhyula. Yago matuulo, go gali mu tangwa imwa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Kwokwo, abashosi beꞌkibusi kya Harooni naaho, bo bahangwirwi ukugalya kwo. Gaganayama gali geꞌmwabo, halinde imyaka neꞌmyakuula. Ku yukwo, ngiisi úgagahuma kwo, naye agaaba atalwirwi imwa Nahano.» ");
INSERT INTO flr_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","«Harooni na bagala baage, ulusiku lwo bagataluulwa kwo, bakwiriiri batangire Nahano ikilo kiguma kyoꞌmushyano mulembu. Batange ikihande kiguma shesheezi, neꞌkindi kiguma kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Yugwo mushyano, gugakandirwa kuguma naꞌmavuta, niꞌrobe linayokerwe ku mubangala. Ha nyuma, likwaniini litengwe-tengwe, likabuli tangwa imwa Nahano. Ikyanya Nahano agayuvwa umushiiriri gwalyo, agasiima. ");
INSERT INTO flr_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","«Mu bagingi ba mu kibusi kya Harooni, ikyanya muguma wabo agayimikwa abe mugingi mukulu, akwaniini akizi tanga lyeryo-lyeryo ituulo. Yiryo ituulo, liri lyeꞌmwa Nahano, linakwaniini likizi siriizibwa lwoshi. Yulu lubaaja, lugayama ho imyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ngiisi matuulo geꞌmushyano, gakwaniini gasiriizibwe lwoshi. Ndaahyo kiri na hino íhigagaliibwa kwo.» ");
INSERT INTO flr_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","18","Ku biloziri amatuulo goꞌkukogwa ibyaha, Nahano anabwira Musa kwo amenyeese Harooni na bagala baage kwokuno: «Ikitugwa íkiri mu tangwa, kwo libe ituulo lyoꞌkukogwa ibyaha, kiri mu ba kitaluule bweneene imwa Nahano. Kwokwo, kigatongeererwa imbere lyage, haahalya ho bali mu tongeerera ibindi bitugwa byoꞌkutangwa ituulo. ");
INSERT INTO flr_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","«Yiryo ituulo, ikyanya umugingi agalitanga, agaliriira Ahandu Heeru, mu lubuga lwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Yiryo ituulo, ngiisi úgalihuma kwo, aba mundu kandi iri kindu, iri naye akola mutaluule. Umuko gwakyo, iri gwangatonyera ku mulondo, yugwo mulondo gugaaba gukoli yulubiiri, gukwaniini gufulirwe Ahandu Heeru. ");
INSERT INTO flr_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","«Iyo nyama, iri yangadeekerwa mu kibya, kikwaniini kiyami vungulwa. Haliko, iri yangadeekerwa mu nyungu yoꞌmulinga, bagiseene, banagileeze mwaꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Iyo nyama, igaaba ikola ndaluule bweneene imwa Rurema. Kyo kitumiri, ngiisi mushosi wa mu kibusi kya Harooni, ahangwirwi kwo agilye kwo. ");
INSERT INTO flr_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","«Halikago, yiryo ituulo, iri umuko gwalyo gwangaleetwa mwiꞌheema lyeꞌmihumaanano, gunakoleesibwe mu kuyeruusa Ahandu Heeru, litangaliibwa. Si likwaniini liyami lashwa mu muliro, linasingooke. ");
INSERT INTO flr_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","«Ituulo lyoꞌkuhyula, liri litaluule bweneene imwa Rurema. Imaaja zaalyo, zo zeezino: ");
INSERT INTO flr_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Ikitugwa, iri kyangatangwa ituulo lyoꞌkuhyula, kikwaniini kitongeererwe haꞌgandi matuulo gali mu tongeererwa. Umuko gwakyo, umugingi anagushangire imbande zooshi zaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","«Ibitondola byoshi byeꞌbinyule, anabitange ku katanda. Kuli kudeta ulusha úlubwisiri umukira, noꞌlusha úlubwisiri ibya mu nda, ");
INSERT INTO flr_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","neꞌfiko zombi, kuguma neꞌkinyule íkizibwisiri, niꞌrembe lyoꞌbudiku. Yibyo byoshi, bigayami lyosibwa kuguma neꞌfiko. ");
INSERT INTO flr_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Umugingianabisiriigize Nahano ku katanda. Yiryo, liri ituulo lyoꞌkuhyula. ");
INSERT INTO flr_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","«Yiryo ituulo, inyama zaalyo, ngiisi mushosi wa mwiꞌkondo lyaꞌbagingi angazilya kwo. Bakwaniini baziliire áhataluule mu handu heeru ha Nahano. Mukuba, yizo nyama ziri ndaluule bweneene imwage. ");
INSERT INTO flr_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","«Imaaja íziloziri ituulo lyoꞌkuhyula, zo nguma neꞌmaaja íziloziri ituulo lyoꞌkukogwa ibyaha. Yiryo ituulo, umugingi ali mu litanga hiꞌgulu lyoꞌkuyeruusa abandu. Yehe naaho, ye hangwirwi kwo azilye kwo. ");
INSERT INTO flr_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","«Ikyanya umugingi ali mu tanga ikitugwa kyoꞌkusiriiza lwoshi, ahangwirwi ayabiire uluhu lwakyo. ");
INSERT INTO flr_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Na ngiisi ituulo lyoshi lyoꞌmushyano, ikyanya baliyokera ku makala, kandi iri ku mubangala, kandi iri ku kikalangiro, ligakizi ba lyoꞌmugingi úwalitanga. ");
INSERT INTO flr_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Agandi matuulo goꞌmushyano, ngiisi mugingi akwaniini alonge kwo ugwage mutuli. Muhangwirwi mukizi gagira mu mushyano muumu, kandi iri mufushe mwaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","«Hali naꞌmatuulo goꞌkuyerekana ingoome. Yago matuulo, gali mu tangwa imwa Nahano. Imaaja zaago, zo zeezino: ");
INSERT INTO flr_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Yiryo ituulo, iri wangalitanga mu kudeta kongwa, wangatanga ikitugwa kyoꞌkusiriiza, unakiyushuule kweꞌkitumbula kizira saama, kinabe kifushe mwaꞌmavuta, kandi iri igaleeti nvushe mwaꞌmavuta, kuguma neꞌbindi bitumbula íbyagirwa mu mushyano mulembu, gunabe mubushe naaho mwaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","«Yiryo ituulo lyoꞌkutanga kongwa, bali mu lileeta kuguma niꞌtuulo lyeꞌbitumbula íbiri mweꞌsaama. ");
INSERT INTO flr_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Ku ngiisi ituulo, mumbeereze ikitumbula, kiguma-kiguma. Ibindi, umugingi agabiyabiira, bibe byeꞌmwage. Uyo mugingi, ye na yolya úkashangira umuko ku mbande zaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","«Yiryo ituulo lyoꞌkuyerekana ingoome, ikyanya liri mu tangwa hiꞌgulu lyoꞌkudeta kongwa imwa Rurema, inyama zaalyo zikwaniini ziliibwe lwolwo lusiku. Emwe! Ndaahyo kiri na íhiteerwa ku shinda hyo bagalaaza. ");
INSERT INTO flr_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","«Hali ikyanya ituulo lyangatangwa, nga kwoꞌmundu aloziizi, kandi iri hiꞌgulu lyoꞌkukwiza byo akalagaania. Haaho, umutuli muguma gugaliibwa lwolwo lusiku. Haliko íbigasigala, byangaliibwa úbugaakya. ");
INSERT INTO flr_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Iyo nyama, nga yangashubi hisa ku lusiku úlugira izishatu, lyoki bakwiriiri bagilashe ku muliro. ");
INSERT INTO flr_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","«Aahago! Yiryo ituulo, hanabaagage umundu úwalya ku nyama zaalyo ku yulwo lusiku úlugira izishatu, Nahano atagaki múkoga. Niꞌtuulo lyage, litagaki ba naꞌkamaro. Mukuba, iyo nyama, igaaba ikola kizira. Neꞌri wangagilya, ugaahanwa ngana. ");
INSERT INTO flr_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Na kwakundi, inyama iri zangakengeera zayileeza ku kindu íkiri noꞌmuziro, iri zitagaki liibwa. Muyami zilasha mu muliro. «Yizo nyama ziꞌtuulo, mu kuzilya, ukwiriiri utee yiyeruusa. ");
INSERT INTO flr_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Iri wangaba utazi yiyeruusa, unakengeere walya ku nyama ziꞌtuulo lyoꞌkuyerekana ingoome, zinabe zatangwa imwa Nahano, ugayami twibwa mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ugatwibwa mwo kwakundi, iri wangalya iyo nyama yoꞌkuyerekana ingoome, unabe keera wahuma ku mundu úyulubiiri, kandi iri ku kitugwa íkiri naꞌkashembo, kandi iri ku kindi kyagaza kyoshi.» ");
INSERT INTO flr_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","kwo amenyeese Abahisiraheeri kwokuno: «Mutakolwe kwo mwalya ibinyule byeꞌbitugwa, biba bya ngaavu, kandi iri bya bibuzi, kandi iri bya mbene. ");
INSERT INTO flr_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Mutanakizi lya ulusha lweꞌkitugwa íkyatumba, kandi iri íkyaliibwa neꞌnyamiishwa. Yulwo lusha, mwangalukoleesa ku gindi-gindi mikolwa. ");
INSERT INTO flr_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Umundu mulebe, iri angalya ulusha lweꞌkitugwa kyoꞌkusiriigiza Nahano, akwiriiri ayami twibwa mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","«Ngiisi ho mugagendi tuula, hatagire úgakizi lya umuko gwaꞌkanyuni, kandi iri gweꞌkitugwa. ");
INSERT INTO flr_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ngiisi úgakizi gulya, agayami twibwa mu Bahisiraheeri.» ");
INSERT INTO flr_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","kwo amenyeese Abahisiraheeri kwokuno: «Iri wangatanga ituulo lyoꞌkuyerekana ingoome, utee heereza Nahano umutuli úgumúkwaniini. ");
INSERT INTO flr_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Yibyo íbiri mu ba bitaluule imwa Nahano, kuli kudeta ulusha kuguma noꞌmushaya, ubileete wenyene imwoꞌmugingi. Gulya mushaya, ugulengeze imbere lya Nahano mu kugutanga. ");
INSERT INTO flr_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Yulwo lusha, umugingi agalusiriigiza ku katanda. Halikago, umushaya gwohe, guli gweꞌmwa Harooni, naꞌbandu beꞌkibusi kyage. ");
INSERT INTO flr_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","«Yikyo kitugwa, muyabiire ikisingiira kyakyo kyeꞌlulyo, munakisikiirize umugingi, kibe kyeꞌmwage. ");
INSERT INTO flr_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Agakizi kihaabwa, bwo ye mu twala umuko ku katanda, ye nali mu siriiza ibitondola byakyo byeꞌbinyule. ");
INSERT INTO flr_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","E Bahisiraheeri, mu yago matuulo goꞌkuyerekana ingoome, keera nakyula kwoꞌmushaya neꞌkisingiira kyeꞌlulyo, mukizi biheereza umugingi Harooni naꞌbandu beꞌkibusi kyage, bwo biyamiri bitalwirwi imwabo.» ");
INSERT INTO flr_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Iyo mituli, igakizi komoolwa ku yago matuulo goꞌkusiriiza nga kwo gatangwa imwa Nahano. Iyamiri iri yeꞌmwa Harooni naꞌbandu beꞌkibusi kyage, ukulyokera ku kyanya bakahandulwa, kwo babe bagingi boꞌkukolera Nahano. ");
INSERT INTO flr_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Iyo mituli, ukulyokera ku lusiku bakayimikwa kwo, Nahano akayami komeereza Abahisiraheeri, kwo bakizi baheereza yo. Yulwo lubaaja, luganayama ho imyaka neꞌmyakuula. ");
INSERT INTO flr_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Yizo maaja zooshi, ziloziri amatuulo goꞌkusiriiza, na goꞌmushyano, na goꞌkukogwa ibyaha, na goꞌkuhyula, na ágali mu tangwa mu kuyimika abagingi, na goꞌkuyerekana ingoome. ");
INSERT INTO flr_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Yizo maaja, Nahano akaziheereza Musa ku mugazi Sinaayi, mwiꞌshamba, ku kyanya akakomeereza Abahisiraheeri kwo bamútangire amatuulo. ");
INSERT INTO flr_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Nahano anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Undeetere Harooni na bagala baage, unatumire imirondo yabo mitaluule, naꞌmavuta goꞌkuyimika. Uleete neꞌshuuli, ibe ituulo lyoꞌkukogwa ibyaha. Unaleete neꞌbipanga bibiri, neꞌkitiri kyeꞌmikate mizira saama. ");
INSERT INTO flr_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Unakuumanie Abahisiraheeri booshi, bakuumanire ha mulyango gwiꞌheema lyeꞌmihumaanano.» ");
INSERT INTO flr_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Musa anasimbaha Nahano, anakuumania Abahisiraheeri booshi imbere lyoꞌmulyango gwalyo, ");
INSERT INTO flr_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","anababwira: «Tuli hano, gira tukoleese ngiisi byo Nahano atukomeereza.» ");
INSERT INTO flr_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Kwokwo, Musa anayabiira Harooni na bagala baage, anabakaraba. ");
INSERT INTO flr_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Anayambika Harooni ikanju, analishweka noꞌmukaba. Anamúyambika niꞌkooti, abuli múyambika ikangaata hiꞌgulu, analishwekera mu kibuno noꞌmukaba gwalyo mulimbiise. ");
INSERT INTO flr_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Anamúhagasa ishaho ha kifuba, muli amabuye gabiri: ibuye lyeꞌHurimu na lyeꞌTumimu. ");
INSERT INTO flr_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Anamúyambika noꞌmulondo gwoꞌkusoosa kwiꞌtwe, gunali kwaꞌkalangikizo keꞌnooro i malanga, koꞌkubonesa kwo akola mutaluule. Kwokwo, kwo akagira nga kwo Nahano akamúkomereza. ");
INSERT INTO flr_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ha nyuma, Musa anayabiira amavuta goꞌkushiiga ku byataluulwa, anagashiiga ku lirya iheema lyeꞌmihumaanano, kuguma na byoshi íbyâli riiri mwo. ");
INSERT INTO flr_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Yago mavuta, anakizi gashiiga ku katanda neꞌbigingi byako ubugira kalinda mu kukataluula. Anakizi gashiiga na ku birugu byoshi bya mwiꞌheema lyeꞌmihumaanano, kiri na ku mutanga gwoꞌkubishukira mwo, neꞌkiterekero kyagwo. ");
INSERT INTO flr_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Yago mavuta, Musa anagashiiga na mwiꞌtwe lya Harooni, gira amútaluule imwa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Ha nyuma, Musa anabwira bagala Harooni kwo bamúyegeere. Nabo, anabayambika imirondo yabo, anabashweka imikaba mu bibuno, anabasoosa neꞌmirondo ya kwiꞌtwe, nga kwo Nahano akamúkomereza. ");
INSERT INTO flr_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Haaho, Musa analeeta irya ngaavu yoꞌkutanga ituulo lyoꞌkukogwa ibyaha. Harooni na bagala baage, banagibiika kwaꞌmaboko mu ruhanga. ");
INSERT INTO flr_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Ikyanya Musa akaba keera agitongeera, anakizi leeza umunwe mu muko, iri anaguhembeza ku tugongo twaꞌkatanda koꞌkusiriigiza kwaꞌmatuulo, gira akayeruuse. Na úgukasigala, anaguyonera mwiꞌdako lyeꞌbiterekero byaꞌkatanda. Mu kugira kwokwo, lyo akakataluula, gira kakizi tangirwa kwaꞌmatuulo goꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Ulusha úlubwisiri ibijogombe, Musa analuyabiira. Anayabiira kiri niꞌrembe lyoꞌbudiku, neꞌfiko zombi, kiri neꞌbinyule byazo. Yibyo byoshi, anabisiriigiza ku katanda. ");
INSERT INTO flr_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Inyama íkasigala kwiꞌyo shuuli: uluhu, neꞌminyofu, naꞌmashe, anabitwala inyuma lyeꞌshumbi, anabiduulika kwoꞌmuliro, nga kwo Nahano akamúkomereza. ");
INSERT INTO flr_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Haaho, Musa anashubi leeta ikipanga, gira kitangwe libe ituulo lyoꞌkusiriiza lwoshi. Harooni na bagala baage, banakibiika kwaꞌmaboko mu ruhanga. ");
INSERT INTO flr_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Neꞌri Musa akakitongeera, anashangira umuko gwakyo ku katanda, imbande zaako zooshi. ");
INSERT INTO flr_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Yikyo kipanga, anakitenga mihoole-mihoole, abuli siriiza itwe lyakyo, neꞌbinyule byakyo. ");
INSERT INTO flr_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Neꞌri akashuka ibya mu nda, neꞌbirenge, anabisiriigiza nabyo ku katanda kuguma neꞌgindi mihoole, libe ituulo lyoꞌkusiriiza lwoshi, nga kwo Nahano akamúkomereza. Yiryo ituulo, umushiiriri gwalyo gwanasimiisa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Mu kuheza, Musa analeeta kirya kyabo kipanga, íkigayerekana kwoꞌmugingi akola agayingira mu mukolwa. Yikyo nakyo, Harooni na bagala baage, banakibiika kwaꞌmaboko mu ruhanga. ");
INSERT INTO flr_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Neꞌri Musa akakitongeera, anashiiga Harooni umuko gwakyo, ku rusongo lwoꞌkutwiri kweꞌlulyo, na ku kingumwe-ngumwe kyoꞌkuboko kweꞌlulyo, na kwiꞌno lihamu lyeꞌlulyo. ");
INSERT INTO flr_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Haaho, Musa anahamagala bagala Harooni. Ngiisi muguma wabo, anamúshiiga yugwo muko ku rusongo lwoꞌkutwiri kweꞌlulyo, na ku kingumwe-ngumwe kyoꞌkuboko kweꞌlulyo, na kwiꞌno lihamu lyeꞌlulyo. Úgukasigala, anagushangira ku katanda kooshi. ");
INSERT INTO flr_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Yikyo kipanga, Musa anayabiira ibinyule byakyo, kuguma noꞌlusha úlubwikiiri umukira, noꞌlusha úlubwikiiri ibijogombe, niꞌrembe lyoꞌbudiku, neꞌfiko zombi kuguma neꞌbinyule íbiziri kwo, neꞌkisingiira kyeꞌlulyo. ");
INSERT INTO flr_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Na mu kitiri kyeꞌmikate mizira saama, kwo kyâli kizi biikwa imbere lya Nahano, anayabiira mweꞌkitumbula kizira saama, neꞌkindi kitumbula kibushe mwaꞌmavuta, neꞌgaleeti. Yibyo byoshi anabiyushuula kwo birya binyule neꞌkisingiira kyeꞌlulyo. ");
INSERT INTO flr_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Yibyo byoshi, Musa anabifumbasa Harooni na bagala baage, banabiyabiira, banabishagania hiꞌgulu mu kubitangira Nahano. ");
INSERT INTO flr_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Yago matuulo gooshi, Musa anashubi gayabiira mu maboko gaabo, anagasiriigiza ku katanda, libe ituulo lyoꞌkusiriiza lwoshi. Yiryo ituulo, likayerekana kwoꞌmugingi keera ayingira mu mukolwa. Umushiiriri gwalyo, gwanasimiisa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Gulya mushaya, Musa anagulengeza imbere lya Nahano, mu kuyerekana kwo guli gweꞌmwage. Kwokwo, kwo Nahano akamúkomereza. ");
INSERT INTO flr_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ha nyuma, Musa anayabiira amavuta goꞌkuyimika, kuguma noꞌmuko úgwâli ku katanda, anabishangira ku Harooni, na ku byambalwa byage. Anashubi bishangira na ku bagala baage, na ku byambalwa byabo. Kwokwo, kwo Musa akataluula Harooni, na bagala baage, kiri neꞌbyambalwa byabo, bibe bya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Musa anabwiraga Harooni na bagala baage kwokuno: «Zirya nyama zaꞌmatuulo, muzideekere ha mulyango gwiꞌheema lyeꞌmihumaanano. Munaziliire haaho ha mulyango, kuguma neꞌmikate íkagirwa hiꞌgulu lya yulu lusiku lukulu. Mugire nga kwo nꞌgamùkomeereza. ");
INSERT INTO flr_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Ngiisi nyama kandi iri imikate íyasigala, bikwiriiri bijigivibwe. ");
INSERT INTO flr_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","«Mukwaniini muhise isiku zirinda, muli haaho ha mulyango gwiꞌheema lyeꞌmihumaanano. Mutagahalyoka, yizo siku zirinda zo mugayimikwa kwo zítazi mala. ");
INSERT INTO flr_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Yibi twagira zeene, Nahano ye katukomeereza byo, gira lyo mukizi yeruusibwa, munabe mukoli tungiini imbere lyage. ");
INSERT INTO flr_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ee! Muhisagye zeezo siku zirinda, ubushigi niꞌzuuba, muli haaho ha mulyango gwa yiryo iheema. Neꞌri mwangalahira, mbu mutagaagira kwokwo, ukufwa, mugaafwa. Kwokwo, kwo Nahano akangomeereza.» ");
INSERT INTO flr_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Yibyo byoshi byo Nahano akakomeereza Harooni na bagala baage ku njira ya Musa, banakizi bisimbaha. ");
INSERT INTO flr_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ku lusiku úlugira umunaana, Musa anahamagala Harooni, na bagala baage, naꞌbashaaja baꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Anabwira Harooni: «Uyabiirage ishuuli, libe ituulo lyoꞌkukogwa ibyaha. Uyabiire neꞌkipanga, libe ituulo lyoꞌkusiriiza lwoshi. Yibyo bitugwa byombi, bibe bizira kashembo. Kwokwo, ubitange ituulo imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","«Ha nyuma, unabwire Abahisiraheeri kwo bayabiire ikihebe, libe ituulo lyoꞌkukogwa ibyaha. Bayabiire neꞌnyana nguma, neꞌkyanabuzi kiguma, gabe matuulo goꞌkusiriiza lwoshi. Yibyo byombi, bibe bikoli hisiizi umwaka, binabe bizira kashembo. ");
INSERT INTO flr_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","«Ubwire Abahisiraheeri, na kwo bayabiire ishuuli nguma neꞌkipanga kiguma, banabitangire Nahano ituulo lyoꞌkuyerekana ingoome. Yiryo ituulo, ligatangwa kuguma niꞌtuulo lyoꞌmushyano mukandire mwaꞌmavuta. Kwokwo zeene, lyo Nahano agamùhulukira kwo.» ");
INSERT INTO flr_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Yibyo byoshi, Abahisiraheeri banabireeta imbere liꞌheema lyeꞌmihumaanano, nga kwo Musa akababwira. Booshi banayiji yimanga imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Musa anababwira: «Yibi byoshi, Nahano ye kamùbwira kwo mubigirage, gira lyoꞌbulangashane bwage bumùboneka mwo.» ");
INSERT INTO flr_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Musa anabwira Harooni: «Yijaga ha katanda, utange ituulo lyoꞌkukogwa ibyaha byawe, neꞌbyaꞌBahisiraheeri booshi. Mu kugira kwokwo, lyo ugayiyeruusa, unabe wabayeruusa booshi. Ha nyuma, unatangage ituulo lyeꞌmwawe lyoꞌkusiriiza lwoshi, naꞌmatuulo gaabo gooshi, nga kwo Nahano akakukomeereza.» ");
INSERT INTO flr_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Kwokwo, Harooni anayegeera akatanda, anatongeera irya nyana, libe ituulo lyoꞌkukogwa ibyaha byage. ");
INSERT INTO flr_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Umuko gwayo, abagala banamúleetera gwo, anagudobeka mwoꞌmunwe, anagutonyeza ku tugongo twaꞌkatanda. Na úgukasigala, anaguyonera ku biterekero byako. ");
INSERT INTO flr_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Yiryo ituulo lyoꞌkukogwa ibyaha, anayabiira ibinyule, neꞌfiko, niꞌrembe lyoꞌbudiku. Yibyo byoshi, anabisiriigiza ku katanda, nga kwo Nahano akakomeereza Musa. ");
INSERT INTO flr_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Haliko, inyama noꞌluhu, anagendi biduulika ku muliro, inyuma lyeꞌshumbi. ");
INSERT INTO flr_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Ha nyuma, Harooni anatongeera kirya kipanga, libe ituulo lyoꞌkusiriiza lwoshi. Umuko gwakyo, bagala baage banamúleetera gwo, anagushangira ku katanda, imbande zooshi. ");
INSERT INTO flr_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Banabuli múleetera purungu, neꞌmihoole. Yibyo byoshi, anabiyokera ku katanda. ");
INSERT INTO flr_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ibya mu nda neꞌbirenge, anatee bishuka, abuli bisiriigiza kuguma neꞌyo mihoole. ");
INSERT INTO flr_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ha nyuma, Harooni analeeta irya mbene yaꞌbandu. Iri akagitongeera, anagitanga libe ituulo lyoꞌkukogwa ibyaha byabo, nga kwo akagira kwiꞌrya nyana, mu kukogwa ibyaha byage. ");
INSERT INTO flr_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Abuli leeta yiryo ituulo lyoꞌkusiriiza lwoshi, analitanga ukukulikirana noꞌlubaaja. ");
INSERT INTO flr_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Anatanga naꞌmatuulo goꞌmushyano, mu kushamata ifune nguma, anagusiriigiza ku katanda, kuguma niꞌtuulo íriri mu tangwa ngiisi shesheezi. ");
INSERT INTO flr_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Na kwakundi, anashubi tongeera ishuuli neꞌkipanga byaꞌbandu bakatanga ituulo lyoꞌkuyerekana ingoome. Umuko gwabyo, bagala baage banamúleetera gwo, anagushangira ku katanda, imbande zaako zooshi. ");
INSERT INTO flr_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Anayabiira ibinyule byeꞌyo shuuli, neꞌbya yikyo kipanga, kuli kudeta ibinyule íbiri ku mukira, noꞌlusha úlubwikiiri ibijogombe, neꞌfiko, niꞌrembe lyoꞌbudiku. ");
INSERT INTO flr_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Yibyo byoshi, Harooni anabilambika ku mishaya, anabisiriigiza ku katanda. ");
INSERT INTO flr_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Haaho, Harooni analengeza imishaya yombi, neꞌkisingiira kyeꞌlulyo anabishagania hiꞌgulu mu kubitangira Nahano. Kwokwo, kwo Musa akabakomeereza. ");
INSERT INTO flr_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Ha nyuma, Harooni anagololera yabo bandu kwaꞌmaboko, mu kubagashaanira. Mukuba, âli mali yusa ukutanga amatuulo goꞌkukogwa ibyaha, na goꞌkusiriiza, na goꞌkuyerekana ingoome. Kwokwo, analyoka ha katanda. ");
INSERT INTO flr_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musa na Harooni banayingiraga mu lirya iheema lyeꞌmihumaanano. Neꞌri bakahuluka mwo, banashubi gashaanira abandu. Haaho-haaho, ubulangashane bwa Nahano bwanayami tanguula imbere lyaꞌbandu booshi. ");
INSERT INTO flr_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Yaho Rurema âli riiri, hanayami huluka umuliro, gwi! Gwanayami jigiivya lirya ituulo lyoꞌkusiriiza, gwanajigiivya neꞌbinyule íbyâli riiri ku katanda. Balya bandu booshi, iri bakabona kwokwo, banabanda akabuuli ku bushambaale, awi yiyi yiyi! Banagwa buubi imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Nadabu bo na Habihu, bagala Harooni, bakayabiira isheetezo zaabo, banazibiika kwaꞌmakala ágayasiri, banagafuka kwoꞌmubadu, gira batangire Nahano ituulo. Haliko yibyo bakagira, batâli hangwirwi ukubigira, nga kwo Musa âli mali babwira. ");
INSERT INTO flr_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Lyeryo, ku kyanya baki gweti bagaagira mbu batangire Nahano ituulo, anayami batibulira kwoꞌmuliro, gwanabajigiivya. ");
INSERT INTO flr_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Iri Musa akabona kwokwo, anabwira Harooni: «Yiri igambo, Nahano keera akagwanwa atumenyeesa lyo, ikyanya akadeta kwokuno: “Ngiisi ábagakizi nyegeera, bakwaniini bamenye kwo nie Rurema mutaluule. Na ndi nie gakizi gingikwa imbere lyaꞌbandu booshi.”» Harooni, iri akayuvwa kwokwo, anaba shee! ");
INSERT INTO flr_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Musa anatumira Mishaheeri, na Herizafaani, bagala Huzyeri, yishe wage Harooni, anababwira kwo bayabiire ibirunda bya beene wabo, babishaaze Ahandu Heeru, banabitwale inyuma lyeꞌshumbi. ");
INSERT INTO flr_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Na yibyo birunda, byâli ki yambiiti imirondo yoꞌbugingi. Yabo bombi, banabitwala inyuma lyeꞌshumbi, nga kwo Musa akabakomeereza. ");
INSERT INTO flr_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Musa anashubi bwira Harooni naꞌbagala bombi, Heryazaari na Hitamaari kwokuno: «Mutashovye imishaku yinyu mu kugandaara, mutanadaatule imirondo yinyu. Iri mwangagira kwokwo, mugaraakaza Nahano, na niinyu kwakundi mugayami fwa, mwe naꞌBahisiraheeri booshi. Bwo Nahano ayita yabo bombi ku muliro, mulekere abiinyu Bahisiraheeri, babe bo bangabagandaara. ");
INSERT INTO flr_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Mutakolwe kwo mwabalala umulyango gwiꞌheema lyeꞌmihumaanano. Iri mwangalyoka ho, mugayami fwa. Mukuba, keera mukataluulwa ku mukolwa gwa Nahano, mu kushiigwa amavuta.» Yago magambo ga Musa, Harooni na bagala baage, banagasimbaha. ");
INSERT INTO flr_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Nahano anashubi bwira Harooni, kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Mwe naꞌbandu beꞌkibusi kyawe, ikyanya mugakizi yingira mwiꞌheema lyeꞌmihumaanano, mutakizi genda mwanywa idivaayi, kandi iri kindi kilalusa kyoshi. Iri mwangagira kwokwo, mugaafwa. Yulu lubaaja, mukizi yama mulusimbahiri, mwe naꞌbandu beꞌbibusi biinyu. ");
INSERT INTO flr_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Mukuba mukwaniini mukizi sobanukirwa na íbitaluule, neꞌbyeꞌkyeye. Musobanukirwe kwakundi na íbiyulubiiri, na íbiri byeru. ");
INSERT INTO flr_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Na kwakundi, mukwaniini mukizi yigiriza Abahisiraheeri imaaja zooshi zo nꞌgabaheereza ku njira ya Musa.» ");
INSERT INTO flr_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Musa anashubi bwira Harooni, naꞌbagala bombi ábâli sigiiri, Heryazaari na Hitamaari, kwokuno: «Ikyanya amatuulo goꞌmushyano gagaaba keera gatangwa imwa Nahano, mwangayabiira umushyano úgusigiiri, muguliire haaho ha katanda. Haliko iyo mikate, usise kwo ndaayo saama ígiri mwo. Iyo mikate, iri mu ba ikola mitaluule bweneene imwa Rurema. ");
INSERT INTO flr_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kwokwo, mukwaniini mukizi giliira ahandu hataluule. E Harooni, yugwo mutuli gwa íbyatangwa imwa Nahano, guli gweꞌmwinyu, mwe naꞌbashosi beꞌkibusi kyawe. Kwokwo, kwo Rurema akambwira. ");
INSERT INTO flr_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","«Ku yukwo, mwe naꞌbaana baawe boꞌbutabana na boꞌbunyere, muhangwirwi ukukizi lya umushaya, neꞌkisingiira, bwo bitálengezibwa imbere lya Nahano. Haliko, mukizi biliira áhataluule. Abahisiraheeri bo bakabitanga, libe ituulo lyoꞌkuyerekana ingoome. Ku yukwo mwe mubihaabirwi. ");
INSERT INTO flr_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Yugwo mushaya na yikyo kisingiira, mukwaniini mukizi bishagania hiꞌgulu mu kubitangira Nahano, kiri neꞌbinyule íbigasiriizibwa ku katanda. Yibyo bigaaba byeꞌmwinyu, mwe naꞌbandu beꞌkibusi kyawe, nga kwo Nahano keera akakyula.» ");
INSERT INTO flr_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Musa anabuuza ngiisi kwo bakoleesa kirya kihebe íkyatangwa hiꞌgulu lyoꞌkukogwa ibyaha byaꞌbandu. Neꞌri akabwirwa kwo kikasiriizibwa, anayami rakarira Heryazaari na Hitamaari, balya bagala Harooni ábâli sigiiri, anabakanukira, ti: ");
INSERT INTO flr_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Iyo mbene, kituma kiki mutakagiliira Ahandu Heeru? Si bikola byokulya bitaluule imwa Rurema. Yikyo kitugwa, mwe mukakihaabwa, gira Abahisiraheeri bakogwe ibyaha byabo, banayeruusibwe, halinde banashubi kwanana imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Halikago mwehe, umuko gwakyo, mutakagutwala halya handu heeru. Iyo mbene, mushubi kwaniini mugiliire áhataluule, nga kwo nꞌgamùbwira.» ");
INSERT INTO flr_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Harooni, ti: «Zeene, yaba bagala baani batanga ituulo lyoꞌkukogwa ibyaha, niꞌtuulo lyoꞌkusiriiza lwoshi. Kundu kwokwo, niehe nꞌgayiji hulukirwa neꞌkihuume kyeꞌnguuke. Aahago! Ulusiku mwene luno, iri nangalya inyama yeꞌkitugwa íkyatangwa ituulo lyoꞌkukogwa ibyaha, ka Nahano angasiima?» ");
INSERT INTO flr_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Musa mbu ayuvwagwe kwokwo, umutima gwage gwanayika mu nda. ");
INSERT INTO flr_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Nahano anashubi bwira Musa bo na Harooni, ");
INSERT INTO flr_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","kwo bamenyeese Abahisiraheeri kwokuno: «Mu bitugwa íbiri mu kihugo, mwangalya naaho ");
INSERT INTO flr_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","íbiri neꞌbinogosho, na íbiri neꞌngaranoobe, binabe biri mu shubi galula mu kunoza. ");
INSERT INTO flr_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Haliko, ibitugwa byeꞌbinogosho biyigabwiri mwo kubiri naaho, bitanali mu shubi galula mu kunoza, mutakolwe kwo mwakizi bilya. Kwakundi, mutakolwe kwo mwakizi lya íbiri mu galula naaho, si ibinogosho bitayigabwiri mwo kubiri. Ngeꞌngamiya, iri mu galula, si itahiiti ibinogosho. ");
INSERT INTO flr_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Mukumbi naye, ali mu galula, si atahiiti ibinogosho. ");
INSERT INTO flr_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Ulukwavu nalwo, luli mu galula, si lutahiiti ibinogosho. ");
INSERT INTO flr_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ingulube nayo, ibinogosho byayo biyigabwiri mwo kubiri, si itali mu shubi galula. ");
INSERT INTO flr_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Yibyo bitugwa byoshi, kiri kizira imwinyu. Ibitugwa mwene yibyo, mutakizi lya inyama zaabyo. Mutanakolwe kwo mwakizi huma ku mitumba yabyo. ");
INSERT INTO flr_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","«Mu biremwa byoshi íbituuziri mu miiji, gaba ga nyaaja kandi iri nyiiji, muhangwirwi ukukizi lya naaho íbihiiti imigaara, naꞌmagamba. ");
INSERT INTO flr_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Haliko, iri byangaba bibuziri imigaara, kandi iri amagamba, mutakolwe kwo mwakizi bilya. ");
INSERT INTO flr_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Yibyo biremwa, bikizi ba kizira imwinyu. Mutakolwe kwo mwalya iminyofu yabyo, kandi iri ukuhuma ku mitumba yabyo. ");
INSERT INTO flr_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ngiisi íkituuziri mu miiji, kinabe kibuziri imigaara kandi iri amagamba, kiri kizira ngana-ngana. ");
INSERT INTO flr_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","«Na kwakundi, utunyuni twingi kiri kizira imwinyu. Ku yukwo, mutakolwe kwo mwalya ingukuma, neꞌfurukombe, na nyunda, ");
INSERT INTO flr_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","nakasare, neꞌmilala yeꞌbikozi, ");
INSERT INTO flr_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","neꞌmilala ya bajongo, ");
INSERT INTO flr_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","neꞌhotirishe, na nabiribiri, naꞌkamanda, neꞌmilala yoshi yoꞌtushuuta, ");
INSERT INTO flr_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","na nafufulu, neꞌkyugu, naꞌmashiiji, ");
INSERT INTO flr_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","neꞌgindi milala ya nafufulu, na mwari, na muderi, ");
INSERT INTO flr_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","naꞌkabangarara, neꞌmilala yoshi yeꞌkoyi-koyi, neꞌhudi-hudi, na najoojo. ");
INSERT INTO flr_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","«Ibizimu byoshi íbigweti amashala, binabe biri mu gendera ku migende ndatu, kiri kizira imwinyu. ");
INSERT INTO flr_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Haliko, hali ibindi bizimu íbigweti amashala, biri mu gendera ku migere mila-mila iri binasimbuka-simbuka kwiꞌdaho. Yibyo byoki, mwangabilya. ");
INSERT INTO flr_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Ee! Byebyo, byo muhangwirwi ukukizi lya, na ngiisi milala yeꞌnzige, na yeꞌseenene, neꞌyaꞌmahaazi. ");
INSERT INTO flr_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Si ibindi byoshi íbiri mu yibulula, imwinyu kiri kizira. ");
INSERT INTO flr_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","«Ibitugwa biguma, iri mwangahuma ku mitumba yabyo, mugaaba mukoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Iyo mitumba, iri mwangagibetula, mukwiriiri mufule imirondo yinyu. Mukuba, mugaaba mukoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","«Aahago! Ibitugwa íbiri mu yulubazania byo byebi: Hali ibitugwa íbihiiti ibinogosho, haliko bitagabulikiini mwo kubiri. Kandi iri kyangaba kitali mu kizi galula. Ikitugwa mwene yikyo, ngiisi úgakihuma kwo, agaaba akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","«Hali neꞌbitugwa íbiri naꞌmagulu gana, haliko binabe biri mu kizi finiisa ibigasha. Imitumba yabyo, ngiisi úgagihuma kwo, agaaba ayulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Iyo mitumba, iri umundu angagibetula, akwaniini afule imirondo yage. Mukuba, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","«Mu biri mu yibulula, íbiyulubiiri byo byebi: Ifukwe, neꞌmbeba, na ngiisi milala yeꞌmishalabira, ");
INSERT INTO flr_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","neꞌbibulubulu, neꞌmishalabira yeꞌbikeba-bikeba, neꞌmishalabira yeꞌbyasi bibishi, neꞌmbulu, noꞌtuvutaale. ");
INSERT INTO flr_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Yibyo byoshi, biyulubiiri imwinyu. Neꞌmitumba yabyo, ngiisi ugagihuma kwo, agaaba akoli yulubiiri, halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","«Mu biri mu yibulula, hali ikyanya umutumba gwakyo gwangatibukira ku kindu kirebe, kiba kirugu íkikabaajwa mu kiti, kandi iri ku mulondo, kandi iri ku luhu, kandi iri ku busuuzu. Yikyo kirugu, kundu kyangaba kiri mu kizi koleesibwa kuti, kikwiriiri kishukwe. Kigaaba kikoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","«Mu biri mu yibulula, iri umutumba gwakyo gwangatibukira ku kirugu kiꞌbumba, iri byoshi íbikiri mwo, bikoli yulubiiri. Neꞌkirugu kyonyene, kikwiriiri kihoojwe-hoojwe. ");
INSERT INTO flr_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Yikyo kirugu, iri bangakifukumula mwaꞌmagoloovi, banagayonere ku byokulya, yibyo byokulya, bigayami ba bikoli yulubiiri. Kiri na ngiisi kinywebwa íkiri mwo, nakyo kigayami yulubala. ");
INSERT INTO flr_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","«Mu biri mu yibulula, iri umutumba gwabyo gwangatibukira ku kindu kirebe, iri kikoli yulubiiri. Kundu kyangaba kiyokero, kandi iri masiga, muyami kihooja-hooja, bwo kikoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","«Haliko, yugwo mutumba, iri gwangatibukira mu shyoko, kandi iri mu kirigo, amiiji gagaaba gakiri meeru. Si umutumba gwonyene, ngiisi úgaguhuma kwo, agaaba akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","«Yugwo mutumba, iri gwangatibukira mu mbuto mubyaziri, zigaaba zikiri nyeeru. ");
INSERT INTO flr_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Haliko, iri gwangatibukira ku mbuto njabike, yizo mbuto zigaaba zikoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","«Ikitugwa, kundu wangahanguulwa kwo ukilye, haliko kinatumbe, umutumba gwakyo, ngiisi úgaguhuma kwo, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Inyama zaakyo, ngiisi úgaazilya kwo, kandi iri azibetula, akwiriiri afule imirondo yage. Agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","«Ngiisi kiremwa íkiri mu yibulula, mutakolwe mbu mukilye, bwo kiri kizira. ");
INSERT INTO flr_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Kwokwo, muleke ukukizi kilya, kundu kyangaba kiri mu genda naꞌmagulu gana, kandi iri geꞌngingwe. ");
INSERT INTO flr_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ngiisi íbiri mu yibulula, mutakolwe kwo mwayiyulubaza hiꞌgulu lyabyo. Mutaleke kwo bimùdwakaze. ");
INSERT INTO flr_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","«Nie Nahano, Rurema winyu. Kwokwo, muyitaluule, munabe beeru, nga kwo naani ndi mweru. Mutakolwe kwo mwayiyulubaza hiꞌgulu lya ngiisi íkiri mu yibulula. ");
INSERT INTO flr_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Nie Nahamwinyu! Nie kamùlyosa mu kihugo kyeꞌMiisiri, gira lyo mba Rurema winyu. Ku yukwo, mukizi ba beeru, nga kwo naani ndi mweru. ");
INSERT INTO flr_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","«Yago mategeko gooshi, galoziri ibitugwa, noꞌtunyuni, neꞌbiremwa íbituuziri mu miiji, na íbiri mu yibulula. ");
INSERT INTO flr_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Ku njira yago, mugakizi sobanukirwa na íbiyulubiiri, na íbiri byeru. Munabe mukoli yiji bwija íbyangaliibwa, na íbitangaliibwa.» ");
INSERT INTO flr_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","kwo amenyeese Abahisiraheeri kwokuno: «Umukazi, iri angaheeka inda, anagibute mwoꞌmwana woꞌbutabana, agaaba akoli yulubiiri, halinde ku siku zirinda, nga kwo ali mu ba ayulubiiri ku kyanya ahonerwa. ");
INSERT INTO flr_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Noꞌyo mwana, mu lusiku úlugira umunaana, atenguulwe. ");
INSERT INTO flr_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","«Uyo maawe, agaaba akoli yulubiiri hiꞌgulu lyoꞌkuhonerwa. Kwokwo, agashubi leeza izindi siku makumi gashatu na zishatu, abuli yeruusibwa. Yizo siku zítazi lenga, atagaahuma ku kindu kyoshi kitaluule. Na kandi, atayingire Ahandu Heeru. ");
INSERT INTO flr_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","«Uyo maawe, iri angaba abuta umwana woꞌbunyere, agaahisa amayinga gabiri akoli yulubiiri, nga kwo ali mu ba ayulubiiri ku kyanya ahonerwa. Uyo maawe, agashubi leeza izindi siku makumi galindatu na ndatu, abuli yeruusibwa. ");
INSERT INTO flr_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","«Uyo maawe, ikyanya ali mu ba keera abuta umwana mutabana kandi iri munyere, neꞌsiku zaage zoꞌkuyeruusibwa zinabe keera zamala, agagendi bona umugingi ha mulyango gwiꞌheema lyeꞌmihumaanano. Agatwala ikyanabuzi kyoꞌmwaka muguma, gira kitangwe libe ituulo lyoꞌkusiriiza. Anatwale noꞌmutungulu gweꞌngunde, kandi iri ihumba liguma, libe ituulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","«Yago matuulo, umugingi agagatanga imbere lya Nahano, gira uyo maawe alonge ukuyeruusibwa. Lyeryo, agaaba akoli yerusiibwi ukukulikirana noꞌmuko úgukahuluka mu kubuta kwage. Gaago go mategeko ágaloziri umukazi úwabuta umwana mutabana, kandi iri munyere. ");
INSERT INTO flr_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","«Ulya maawe, iri atangashobola ukutanga ikyanabuzi, akwaniini aleete amahumba gabiri, kandi iri mitungulu ibiri yeꞌngunde. Kanyuni kaguma, kagatangwa libe ituulo lyoꞌkusiriiza lwoshi. Akaabo, umugingi agakatanga libe ituulo lyoꞌkukogwa ibyaha. Uyo maawe, ikyanya agagirirwa kwokwo, lyo agashubi ba mweru.» ");
INSERT INTO flr_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Nahano anashubi bwira Musa bo na Harooni kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Hali ikyanya umundu angaba ali neꞌkivimba, kandi iri luhere, kandi iri bishekera. Neꞌri byangaboneka nga mubembe, kwokwo, uyo mundu akwaniini aleetwe imwoꞌmugingi Harooni, kandi iri imwa muguma wa mu baana baage. ");
INSERT INTO flr_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","«Amagala goꞌyo mundu, umugingi agagaloleekeza. Ikyanya umushaku keera gwahinduka nvwi, noꞌbulwazi bunaboneke kwo bukoli tonderiiri ku kikoba kyaꞌmagala gaage, kwokwo, iri guli mubembe. Haaho, umugingi akwaniini amenyeesanie kwoꞌyo mundu akola kizira. ");
INSERT INTO flr_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","«Halikago kirya kihute, iri kyangaba kiri kyeru naaho, kinabe kitayingiiri bweneene mu kikoba, noꞌmushaku gunabe gutazi hinduka nvwi, umugingi agabwira uyo mulwazi kwo atee hisa isiku zirinda ali haage-haage. ");
INSERT INTO flr_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","«Yago magala gaage, ku lusiku úlugira izirinda, umugingi agashubi galoleekeza. Neꞌri angabona kwo gatahindusiri, noꞌbulwazi butazi yajabuka, agashubi bwira umulwazi kwo abeere haage-haage, halinde kwiꞌyinga lya kabiri. ");
INSERT INTO flr_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","«Ha nyuma lya yiryo lindi iyinga, umugingi agashubi múloleekeza buhyahya. Yikyo kilabike, iri kyanganyota, kinabe kitaki yajabusiri ku magala, umugingi anadete kwoꞌyo mundu akoli yeruusiri, na kwo lushuba luhere naaho. Uyo mundu, agafula imirondo yage, anabe akoli yeruusiri. ");
INSERT INTO flr_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","«Halikago yikyo kilabike, iri uyo mundu angakiyerekana imwoꞌmugingi, anadetwe kwo akoli yeruusiri, haliko ha nyuma kinayajabuke ku magala gooshi, uyo mundu, agashubi galukira imwoꞌmugingi. ");
INSERT INTO flr_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","«Umugingi agashubi múloleekeza. Neꞌri angabona kwo lulya luhere keera lwakwira amagala gooshi, lyoki umugingi agamúbwira kwo akoli yulubiiri, bwo akola noꞌmubembe. ");
INSERT INTO flr_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Umundu, iri angagwatwa noꞌbulwazi bukayu ku magala, akwiriiri agendi lolwa noꞌmugingi. ");
INSERT INTO flr_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Umugingi anamúloleekeze. Ngeeka angabona kwo ku magala kuli ikivimba kyeru, neꞌbikarakara byaho binabe keera byayeluluka, kinabe kihando kibishi. ");
INSERT INTO flr_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Kuli kudeta kwoꞌyo mundu, amagala gaage gayamiri galwaziri. Uyo mundu, umugingi agamenyeesania kwo akoli yulubiiri. Na bwo akoli bonesiri kwo akoli yulubiiri, atagaki múhandula kwo abeere haage-haage. ");
INSERT INTO flr_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","«Yugwo mubembe, umugingi angabona kwo keera gwadunduula amagala gooshi, ukutondeerera kwiꞌtwe halinde ku magulu. ");
INSERT INTO flr_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Kwokwo, agamenyeesania kwoꞌyo mundu akoli yeruusiri, bwaꞌmagala gaage gahinduka meeru-meeru. ");
INSERT INTO flr_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","«Halikago uyo mundu, ikyanya amagala gaage gangaboneka kweꞌkihando kibishi, iri akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Uyo mugingi, iri angabona yikyo kihando kwo kiri kibishi, akwaniini ayami menyeesania kwoꞌyo mundu akoli yulubiiri. Mukuba, ikihando kibishi kiri mu yulubazania, binaboneke kwo akola noꞌmubembe. ");
INSERT INTO flr_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","«Yikyo kihando, iri kyangashubi yuma, kinahinduke kyeru-kyeru, nga kwaꞌmagala gali, uyo mundu akwaniini ashubi galukira imwoꞌmugingi. ");
INSERT INTO flr_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Uyo mugingi, agashubi múloleekeza. Neꞌri angabona kwo yikyo kihando kyahinduka kyeru-kyeru, kwokwo, agamenyeesania kwoꞌyo mundu akoli yeruusiri. ");
INSERT INTO flr_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Umundu, iri angaba akagwatwa niꞌhute, linabe keera likakira, ");
INSERT INTO flr_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","haliko, áhashuba ihute hanahinduke kivimba kyeru, kandi iri kishekera kidukula, akwiriiri agendi hayereka umugingi. ");
INSERT INTO flr_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","«Uyo mugingi, ikyanya keera ahaloleekeza, ngeeka angabona kwo hahobosiri, neꞌbikarakara byaho keera byayeluluka. Kwokwo, agamenyeesania kwoꞌyo mundu akoli yulubiiri. Yiryo ihute, linabe keera lyahinduka mubembe. ");
INSERT INTO flr_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","«Haliko, iri umugingi angaloleekeza uyo mundu, anabonage kweꞌbikarakara bitazi yeluluka, hatanahobosiri, hanabe havuvubiiri, kwokwo, umugingi agatee múhandula ukuhisa ku siku zirinda. ");
INSERT INTO flr_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Yugwo mubembe, iri gwangakwira amagala gooshi, kwokwo, umugingi agamenyeesania kwoꞌyo mundu akoli yulubiiri. Bigaboneka kwo akola noꞌmubembe. ");
INSERT INTO flr_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","«Halikago, iri yaho handu hangaba hatazi yajabuka, kwokwo, igaaba nvigo naaho. Umugingi, anamenyeesanie kwoꞌyo mundu akoli yeruusiri. ");
INSERT INTO flr_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Iri umundu angakengeera ahiira ku magala hanadukule, kandi iri hayeruuka, ");
INSERT INTO flr_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","haaho, umugingi akwaniini ahaloleekeze. Mango abona kweꞌbikarakara byaho keera byayeluluka, hanahobosiri, lyo agaamenya kwoꞌyo mundu ahiiti umubembe. Uyo mugingi, akwaniini amenyeesanie kwoꞌyo mundu akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","«Haliko, iri umugingi angabona kweꞌbikarakara bitazi yeluluka, hanabe hatahobosiri, haliko hanabe havuvubiiri, kwokwo, agatee handula uyo mundu ukuhisa ku siku zirinda ali haage-haage. ");
INSERT INTO flr_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","«Ku lusiku lwa kalinda, umugingi agashubi múloleekeza. Neꞌri angabona kwo keera hayajabuka, agamenyeesania kwoꞌyo mundu akoli yulubiiri. Bigaboneka kwo akola noꞌmubembe. ");
INSERT INTO flr_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","«Haliko, iri yaho akahiira hangaba hatazi yajabuka, iri yikyo kivimba kyaleetwa naaho na yukwo kuhiira. Kwokwo, umugingi agamenyeesania kwo ali mugumaana. ");
INSERT INTO flr_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Umundu, aba mushosi kandi iri mukazi, iri angaba neꞌkihando mwiꞌtwe, kandi iri ku kaledu, ");
INSERT INTO flr_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","umugingi akwaniini akilole. Iri angabona kwo hahobosiri, na kwoꞌmushaku gwaho guyariiri, gunahumbatiiri, agamenyeesania kwoꞌyo mundu akoli yulubiiri. Mukuba, akola noꞌmubembe mwiꞌtwe, kandi iri ku kaledu. ");
INSERT INTO flr_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","«Umugingi, iri angabona kwo hatahobosiri, noꞌmushaku gunabe gutayariiri, kwokwo, akwaniini ahandule uyo mundu ukuhisa ku siku zirinda. ");
INSERT INTO flr_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","«Kirya kihando, ku lusiku úlugira izirinda, umugingi akwaniini ashubi kiloleekeza. Iri angagwana kitazi yenguula, noꞌmushaku gunabe gutazi yarara, hatanahobosiri, ");
INSERT INTO flr_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","lyoki uyo mundu akwaniini abegwe umushaku gwage gwoshi. Haliko, áhali yibyo bihere, hatagamwebwa. Uyo mugingi, anashubi múhandula ukuhisa isiku zirinda. ");
INSERT INTO flr_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","«Ku lusiku úlugira izirinda, umugingi agashubi loleekeza kirya kihere. Neꞌri angabona kwo kitazi yajabuka, kinabe kitayisiri mu magala, agamenyeesania kwoꞌyo mundu akoli yeruusiri. Uyo mundu, akwaniini afule ibyambalwa byage, bwo ali mugumaana. ");
INSERT INTO flr_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","«Uyo mundu, ikyanya ayeruusibwa, iri yibyo bihere byangatondeera ukuyajabuka, ");
INSERT INTO flr_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","umugingi agamúloleekeza. Neꞌri angabona kwo byayajabuka, bitagaki huuna kwoꞌmugingi ashubi lola iri umushaku guyariiri. Uyo mundu, agaaba akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","«Haliko, iri umugingi angabona kwo birya bihere bitagaluka, naꞌhandu haabyo, umushaku mwiru gunahamere, kwokwo, ibihando bigaaba keera byakira. Umugingi anamenyeesanie kwoꞌyo mundu akola mugumaana. ");
INSERT INTO flr_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Umundu yeshi, aba mushosi kandi iri mukazi, iri angaboneka kwo ali neꞌbikwishi ku magala gaage, ");
INSERT INTO flr_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","umugingi agamúloleekeza. Neꞌri angabona kwo lyo bikiri mu tondeera, yibyo bigaaba luhere naaho. Noꞌyo mundu anabe akiri mugumaana. ");
INSERT INTO flr_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Umushosi, iri angaba akola noꞌluhala, ali mweru, bwo ali noꞌluhala naaho. ");
INSERT INTO flr_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Yulwo luhala, lwangaba keera lwasooka itwe lyoshi. Kundu kwokwo, agaaba akiri mweru. ");
INSERT INTO flr_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","«Halikago, iri lwangaboneka mweꞌhilabike hidukula, haba ha kashanga-mutwe, kandi iri ha ngoto, yihyo hilabike, hiyerekiini ubulwazi bwoꞌmubembe. ");
INSERT INTO flr_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Umugingi agamúloleekeza mu luhala lwoshi. Ngeeka angabona kwo yihyo hilabike hikoli heemiri, binaboneke nga mubembe úguyajabusiri. ");
INSERT INTO flr_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Kwokwo, ulya mundu agaaba akoli hiiti ubulwazi bwoꞌmubembe, anabe akoli yulubiiri. Umugingi, akwaniini amenyeesanie kwoꞌyo mundu akoli yulubiiri, bwo ahiiti ubulwazi mwiꞌtwe lyage. ");
INSERT INTO flr_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Ngiisi úkoli lwaziri umubembe, akwiriiri akizi yambala ubusanganira, atanakizi shanuza umushaku. Anakizi bwikira naꞌkanwa kaage, anakizi genda agabanda akashiba kwokuno: “Ngoli yulubiiri, ngoli yulubiiri.” ");
INSERT INTO flr_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Abandu mwene yabo, ikyanya bagaaba bali na yugwo mubembe, bagaaba bakoli yulubiiri. Na bwo bayulubiiri, bagatuula naꞌbaabo balwazi inyuma lyeꞌshumbi. ");
INSERT INTO flr_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Hali ikyanya umubembe gwangayulubaza ikyambalwa kihange mu nuzi zoꞌbwoya, kandi iri mu zeꞌkitaani. ");
INSERT INTO flr_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","(Yikyo kyambalwa, kyangaba kikahangwa, kandi iri kikalukwa). Gwangayulubaza kiri noꞌluhu, kandi iri ngiisi kindu íkikahangwa mu lwo. ");
INSERT INTO flr_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Yikyo kyambalwa, iri kyangaboneka kweꞌhilabike íhiri niꞌbara lyeꞌbyasi bibishi, kandi iri lidukula, iri kigaaba kikola noꞌmuziro. Mukwaniini mugendi kiyereka umugingi. ");
INSERT INTO flr_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","«Umugingi, ikyanya agaaba keera aloleekeza yihyo hilabike, agatee biika yikyo kyambalwa ha butambi ukuhisa isiku zirinda. ");
INSERT INTO flr_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","«Yikyo kyambalwa, ku lusiku úlugira izirinda, agashubi kiloleekeza. Iri yihyo hilabike hyangayajabuka, yikyo kyambalwa, kandi iri yulwo luhu, bigaaba bikoli yulubiiri, binakola noꞌmuziro. ");
INSERT INTO flr_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Kwokwo, bwo kikola muziro, umugingi akwaniini akiyokye, halinde kisingooke lwoshi. ");
INSERT INTO flr_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","«Haliko, iri uyo mugingi angakiloleekeza, anabone kwo hirya hilabike hitayajabuka ku kyambalwa, ");
INSERT INTO flr_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","agahanguula kwo kifulwe, kinashubi hisa izindi isiku zirinda, kibiisirwi ha butambi. ");
INSERT INTO flr_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","«Yizo siku, iri zangamala, yikyo kyambalwa, agashubi kiloleekeza. Neꞌri angagwana hirya hilabike, kundu hitayajabuka, haliko hikihiiti lyeryo ibara, muba munda, kandi iri i mugongo, iri yikyo kyambalwa kiki yulubiiri, kinakwiriiri kisingoolwe lwoshi. ");
INSERT INTO flr_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","«Yikyo kyambalwa, bwo bagaaba keera bakifula, noꞌyo mugingi anabonage kwo lirya ibara lyafwifwitira, agaakera halya handu áhali hirya hilabike. ");
INSERT INTO flr_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","«Na kwakundi, yihyo hilabike, iri hyangashubi yiji boneka mu kyambalwa íkyalukwa, kandi iri mu mirondo, kandi iri mu kindi kindu íkigizirwi mu luhu, kwokwo, yugwo mubembe gugaaba keera gwakiyahukira. Haaho, yikyo kyambalwa kikwiriiri kisingoolwe. ");
INSERT INTO flr_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","«Haliko, yikyo kyambalwa, ha nyuma lyoꞌkukifula, yihyo hilabike hinanyote, kishubi fulwa ubwa kabiri kikabuli ba kikoli yeruusiri. ");
INSERT INTO flr_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","«Yizo maaja, zo ziyerekiini ngiisi kwo mugaagira hiꞌgulu lyeꞌmiziro. Mukuba, hali ikyanya imiziro yangayingira mu kyambalwa kihange mu nuzi zoꞌbwoya, kandi iri zeꞌkitaani, kandi iri mu ngiisi íbiri mu girwa mu luhu. Kwokwo, lyo mugalonga ukumenya, iri bikoli yulubiiri, kandi iri biki yeruusiri.» ");
INSERT INTO flr_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Umundu, iri angaba ashubi lwaziri umubembe, anabe keera akira, akwiriiri atee twalwa imwoꞌmugingi, halinde alonge ukuyeruusibwa. ");
INSERT INTO flr_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","«Uyo mugingi, anagendi múlolera inyuma lyeꞌshumbi. Neꞌri angabona kwoꞌmubembe keera gwakira, ");
INSERT INTO flr_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","anamúyeruuse. Mu kugira kwokwo, agatumira utunyuni tubiri tuzira kashembo, tunabe tukiri tugumaana. Banaleete neꞌkitolo kyeꞌkiti kyoꞌmwerezi, noꞌbwoya budukula, niꞌtavi lyeꞌhisopo. ");
INSERT INTO flr_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Anababwire kwo babaagire kanyuni kaguma mu nyungu yiꞌbumba íri mwaꞌmagoloovi, ganabe gavwomerwa ha shyoko. ");
INSERT INTO flr_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Mu muko gwako, anatibulire mwo akaabo kagumaana, kuguma na kirya kitolo kyoꞌmwerezi, na bulya bwoya budukula, na lirya itavi lyeꞌhisopo. ");
INSERT INTO flr_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Yugwo muko, anagushangire ubugira kalinda kuꞌlya mundu úgayeruusibwa umubembe, abuli deta kwo akoli yerusiibwi. Kalya kanyuni kagumaana nako, anabuli kalikuula kapurumukire mu kishuka. ");
INSERT INTO flr_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«Ha nyuma, uyo mundu anafulage ibyambalwa byage, anamwese noꞌmushaku, anayikarabe. Lyeryo lyo agaaba akoli yeruusiri, anabe ahangwirwi ukugalukira mu shumbi, haliko agatee hisa isiku zirinda akiri inyuma liꞌheema lyage. ");
INSERT INTO flr_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","«Ku lusiku úlugira izirinda, anashubi begwa umushaku, noꞌlwanwa, kiri neꞌbisike byage. Na kwakundi, anafule ibyambalwa, anayikarabe. Lyeryo lyo agaaba akoli yeruusiri. ");
INSERT INTO flr_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«Ku lusiku lwoꞌmunaana, uyo mundu agaleeta ibipanga bibiri bizira kashembo, neꞌkishaashi kyoꞌmwaka. Yibyo byoshi, bikwaniini bibe bizira kashembo, analeete niꞌtuulo lyeꞌbilo bishatu byoꞌmushyano mulembu, gunabe mufushe mwaꞌmavuta, kuguma neꞌkitolo kiguma kyeꞌlitiri yaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","«Uyo mundu, umugingi anamúleete imbere lya Nahano, kuguma naꞌmatuulo go aleeta, hoofi noꞌmulyango gwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","«Uyo mugingi, agayabiira ikipanga kiguma, kuguma na galya mavuta, anamútangire byo, libe ituulo lyoꞌkuhyula. Anabilengeze imbere lya Nahano, mu kuyerekana kwo biri byeꞌmwage. ");
INSERT INTO flr_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","«Yikyo kyanabuzi, anakitongeerere áhataluule, ngiisi ho bali mu kizi tongeerera ibitugwa íbyatangwa ituulo lyoꞌkuhyula, kandi iri lyoꞌkusiriiza lwoshi. Yiryo ituulo lyoꞌkuhyula, na lyoꞌkukogwa ibyaha, byombi bigaaba bitalwirwi imwa Rurema. Kwokwo, bigaaba byoꞌmugingi. ");
INSERT INTO flr_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","«Yikyo kitugwa, umuko gwakyo, umugingi agaguyabiira kwo, anagulabe ulya mundu ku rusongo lwoꞌkutwiri kweꞌlulyo, na ku kingumwe-ngumwe kyoꞌkuboko kweꞌlulyo, na kwiꞌno lihamu lyoꞌkugulu kweꞌlulyo, gira alonge ukuyeruusibwa. ");
INSERT INTO flr_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Anayabiire amavuta maniini, anayitoonyeze go mu kigasha kyoꞌlumosho. ");
INSERT INTO flr_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Yago mavuta, agagadobeka mwoꞌmunwe muguma gwoꞌkuboko kweꞌlulyo, anagashangire ubugira kalinda, imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","«Amavuta ágasigala mu kigasha, agaalaba maniini ku rusongo lwoꞌkutwiri kwage kweꞌlulyo, na ku kingumwe-ngumwe kyoꞌkuboko kwage kweꞌlulyo, na kwiꞌno lihamu lyoꞌkugulu kwage kweꞌlulyo, halya ho atámali gwanwa alaba gulya muko gweꞌkibuzi. ");
INSERT INTO flr_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Ngiisi mavuta ágagaaba gasigala mu kigasha, anamúshiige go mwiꞌtwe. Kwokwo, kwo agamúyeruusa imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","«Ha nyuma, umugingi agamútangira ituulo lyoꞌkukogwa ibyaha byage, anamúyeruuse, halinde anashubi ba mweru imbere lyage. Ha nyuma, akabuli tongeera kirya kindi kyanabuzi kyoꞌkusiriiza lwoshi. ");
INSERT INTO flr_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Yikyo kyanabuzi agakitanga ku katanda, kuguma na lirya ituulo lyoꞌmushyano. Kwokwo, kwo agamúyeruusa, mu kuyerekana kwo keera akira. Uyo mundu, anabe akoli yeruusiri ngana-ngana. ");
INSERT INTO flr_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Umundu, iri angaba ali mukeni, anabe atashobwiri ukutanga yibyo bindu byoshi, ahangwirwi ukuleeta ikipanga kiguma naaho, libe ituulo lyoꞌkuhyula. Agakilengeza imbere lya Nahano, gira alonge ukuyeruusibwa. Na kwakundi, analeete neꞌkilo kiguma kyoꞌmushyano mulembu, gunabe mufushe mwaꞌmavuta, kuguma neꞌkitolo kyeꞌlitiri yaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Anashubi yabiira naꞌmahumba gabiri, kandi iri mitungulu ibiri yeꞌngunde ukukulikirana na kwo ashobwiri. Ihumba liguma, ligaaba ituulo lyoꞌkukogwa ibyaha. Neꞌlyabo, linabe ituulo lyoꞌkusiriiza lwoshi. ");
INSERT INTO flr_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","«Yibyo bindu, ku lusiku lwoꞌmunaana, agabitwalira umugingi ha mulyango gwiꞌheema lyeꞌmihumaanano, gira lyo alonga ukuyeruusibwa imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","«Kirya kipanga, umugingi agakiyabiira, kuguma na galya mavuta, anabilengeze imbere lya Nahano, mu kuyerekana kwo biri byeꞌmwage. ");
INSERT INTO flr_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ha nyuma, anakitongeere. Umuko gwakyo, anaguyabiire kwo, anagulabe ulya mundu ku rusongo lwoꞌkutwiri kweꞌlulyo, na ku kingumwe-ngumwe kyoꞌkuboko kweꞌlulyo, na kwiꞌno lihamu lyoꞌkugulu kwage kweꞌlulyo. ");
INSERT INTO flr_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","«Yago mavuta, anagafuke mu kigasha kyage kyoꞌlumusho. ");
INSERT INTO flr_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Anakizi galeeza mwoꞌmunwe gwoꞌkuboko kweꞌlulyo, anagashangire ubugira kalinda, imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Amavuta ágasigala mu kigasha, agaalaba maniini ku rusongo lyoꞌkutwiri kweꞌlulyo, na ku kingumwe-ngumwe kyoꞌkuboko kweꞌlulyo, na kwiꞌno lihamu lyoꞌkugulu kweꞌlulyo, halya ho âli mali gwanwa alaba gulya muko gweꞌkibuzi. ");
INSERT INTO flr_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Ngiisi mavuta ágagaaba gasigala mu kigasha, anamúshiige go mwiꞌtwe. Mu kugira kwokwo, agaaba amúyeruusa imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","«Ha nyuma, uyo mugingi anatange yago mahumba gombi, kandi iri iyo mitungulu yombi yeꞌngunde, ukukulikirana na kwo ashobwiri. ");
INSERT INTO flr_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Ihumba liguma, ligatangwa, libe ituulo lyoꞌkukogwa ibyaha. Neꞌlyabo, ligasiriizibwa. Yutwo tunyuni, tugatangwa kuguma niꞌtuulo lyoꞌmushyano. Mu kugira kwokwo, lyo agaaba amúyeruusa imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","«Uyo úshuba noꞌmubembe, iri angaba atashobwiri ukutanga amatuulo goꞌkumúyeruusa, kwokwo kwo bagamúyeruusa.» ");
INSERT INTO flr_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Nahano anabwira Musa na Harooni kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Ngolaga ngamùheereza ikihugo kyeꞌKaanani. Neꞌkyanya mugakiyingira mwo, gira mukihyane, hali ikyanya nangabiika umubembe ku kibambaazi kyeꞌnyumba ndebe. ");
INSERT INTO flr_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Haaho, mwene inyumba, akwiriiri agendi bwira umugingi: “Mu nyumba, nꞌgabona mwo íhiri nga mubembe.” ");
INSERT INTO flr_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Iyo nyumba, umugingi átazi giloleekeza mwo, agahulusa ibindu byoshi íbiri mwo, gira bitayiji detwa kwo bikoli yulubiiri. Ha nyuma, anayingire mwo, gira agitanduule. ");
INSERT INTO flr_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","«Yihyo íhiri nga mubembe, umugingi agahiloleekeza bwija. Neꞌri hyangabonesa ibara lyeꞌbyasi bibishi, kandi iri lidukula, hinaboneke kwo hinywengeriiri mu kibambaazi, ");
INSERT INTO flr_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","lyeryo, agayami huluka, anagihamike ukuhisa ku siku zirinda. ");
INSERT INTO flr_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","«Ku lusiku úlugira izirinda, agashubi galuka, ayiji loleekeza buhyahya. Yihyo íhiri nga mubembe, iri hyangayenguula ikibambaazi kyoshi, ");
INSERT INTO flr_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","agakyula kwaꞌmabuye go hyahika kwo, gashaazibwe, ganalashwe inyuma lyaꞌkaaya. ");
INSERT INTO flr_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","«Mwiꞌyo nyumba, bagahwalula ho bakaseemania. Yibyo bahwalula, banabikuumanie, banagendi biyonera inyuma lyaꞌkaaya, ngiisi áhali ijolera. ");
INSERT INTO flr_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Galya mabuye go bahongola, banashubi gagomboola naꞌgandi. Neꞌnyumba yoshi, inashubi semanibwa. ");
INSERT INTO flr_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Ikyanya bagaaba keera bayusa ukushaaza galya mabuye, banabe keera bashubi haseemania, hali ikyanya yihyo íhiri nga mubembe hyangashubi boneka. ");
INSERT INTO flr_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Kinatume umugingi agashubi yiji hiloleekeza. Neꞌri kwangaba hyashubi kwira iyo nyumba, kuli kudeta kwo yugwo mubembe gutakamala. Iyo nyumba, igaaba ikoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ikwiriiri ihongolwe. Amabuye gaayo, neꞌbiti, noꞌbulongo, byoshi bikumbululwe, binagendi yonerwa inyuma lyaꞌkaaya. ");
INSERT INTO flr_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","«Iyo nyumba, ku kyanya ihamisirwi, iri umundu angayingira mwo, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Neꞌri umundu angalaala mwo, kandi iri aliira mweꞌkindu kirebe, akwiriiri afule ibyambalwa byage. ");
INSERT INTO flr_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Iyo nyumba, ikyanya bagashubi gibuguulula, umugingi agayiji gitanduula. Neꞌri angabona kwo hirya íhiri nga mubembe hitaki shubi boneka, kwokwo, agamenyeesa kwoꞌmuziro keera gwamala, inyumba ikola nyeeru. ");
INSERT INTO flr_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","«Iyo nyumba, mu kugiyeruusa, umugingi agayabiira utunyuni tubiri, kuguma neꞌkitolo kyeꞌkiti kyoꞌmwerezi, noꞌbwoya budukula, niꞌtavi lyeꞌhisopo. ");
INSERT INTO flr_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Akanyuni kaguma, agakabaagira mu nyungu yiꞌbumba íri mwaꞌmagoloovi, ganabe gavwomerwa ha shyoko. ");
INSERT INTO flr_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Yako kanyuni, umuko gwako, agagutibulira mwo kirya kitolo kyoꞌmwerezi, na lirya itavi lyeꞌhisopo, na bulya bwoya budukula, na kalya kanyuni kagumaana. Yugwo muko, anagushangire kwiꞌyo nyumba ubugira kalinda. ");
INSERT INTO flr_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","«Iyo nyumba, kwokwo kwo agagimala mwoꞌmuziro. ");
INSERT INTO flr_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kalya kanyuni kagumaana, anakaliike kapurumukire mu kishuka. Iyo nyumba, kwokwo kwo agagiyeruusa.» ");
INSERT INTO flr_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Kwokwo, kwo tuli mu tanduula ngiisi bulwazi úbuli ku magala, ngoꞌlubandu, ");
INSERT INTO flr_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","56","kandi iri kirole, kandi iri ihute kandi iri kishekera, kandi iri íbiloziri ibilabike ku kyambalwa, kandi iri ku nyumba. ");
INSERT INTO flr_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Ukutanduula mwene yukwo, kugayerekana ikyanya umundu ayeruusiri, kandi iri ayulubiiri. Kiri neꞌkindu kirebe, kwo na kwokwo. Yago migirizo, gali mu lola ku malwazi ga ku magala, kiri noꞌmuziro. ");
INSERT INTO flr_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Nahano anashubi bwira Musa na Harooni kwo ");
INSERT INTO flr_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","bamenyeese Abahisiraheeri kwokuno: «Ikyanya umushosi ali mu shuubala amasira, iri akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Yago masira, ikyanya gagakizi múlyoka mwo, kandi iri gamúyishwekera mwo, iri akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","«Kiri neꞌngingo, na ngiisi byo ali mu bwatala kwo, nabyo bigaaba bikoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Iyo ngingo, iri umundu angagihuma kwo, akwiriiri afule ibyambalwa byage, anayikarabe. Mukuba, agaaba akoli yulubiiri, halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","«Uyo mushosi, ikyanya ashuubala amasira, ikitumbi kyo atábwatiiri kwo, ngiisi gundi úgakibwatala kwo, akwiriiri afule ibyambalwa byage anayikarabe. Mukuba, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Uyo mushosi mulwazi, ngiisi úwangamúhuma kwo, naye akwiriiri afule ibyambalwa byage, anayikarabe. Mukuba, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","«Uyo mushosi mulwazi, iri angakengeera atwira ku gundi mundu, uyo atwira kwo akwiriiri afule ibyambalwa byage, anayikarabe. Mukuba, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","«Uyo mulwazi, iri angakengeera abwatala ku kyajo kya ngiisi kitugwa kyoꞌkugendera kwo, yikyo kyajo nakyo kigaaba kikoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Uyo mundu, ngiisi kindu kyo agabwatala kwo, ngiisi úgayiji kihuma kwo, agaaba akoli yulubiiri halinde kabigingwe. Akwaniini afule ibyambalwa byage, anayikarabe. Mukuba, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","«Uyo mulwazi, átazi yikaraba amaboko gaage, iri angahuma ku mundu, uyo ahuma kwo, akwaniini afule imirondo yage, anayikarabe. Mukuba agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","«Uyo mulwazi, iri angahuma ku kirugu kiꞌbumba, yikyo kirugu kikwiriiri kipwamuulwe. Na ngiisi kirugu íkyabaajwa mu kiti, kikwiriiri kishukwe naꞌmiiji. ");
INSERT INTO flr_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","«Umulwazi úshuba mu shuubala amasira, ikyanya gakama, agatee lindirira isiku zirinda, hiꞌgulu lyoꞌkuyiyeruusa. Kwokwo, agaaba akira lwoshi. Akwaniini afule ibyambalwa byage, anayikarabe amiiji maduutu, anabe akoli yeruusiri. ");
INSERT INTO flr_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","«Uyo mushosi, ku lusiku lwoꞌmunaana, akwaniini agendi leeta amahumba gabiri, kandi iri imitungulu ibiri yeꞌngunde, anabitwale imbere lya Nahano, ha mulyango gwiꞌheema lyeꞌmihumaanano, anabisikiirize umugingi. ");
INSERT INTO flr_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Yago mahumba, umugingi agatanga liguma hiꞌgulu lyoꞌkukogwa ibyaha. Neꞌlyabo, libe ituulo lyoꞌkusiriiza lwoshi. Mu kugira kwokwo, uyo mundu úshuba mu shuubala amasira, umugingi agaaba keera amúyeruusa imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","«Umushosi, iri angakengeera ayihwana kwo, akwiriiri akarabe amagala gooshi. Mukuba, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Yibyo ayihwana kwo, iri byangakwira ku mulondo, kandi iri ku luhu, bikwiriiri bifulwe. Mukuba, bigaaba bikoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","«Umushosi, iri angamenyana noꞌmukazi, bombi bakwiriiri bayikarabe. Mukuba, bagaaba bakoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","«Umukazi, ikyanya ali mu honerwa, agaahisa isiku zirinda ayulubiiri. Iri umundu agamúhuma kwo, naye agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Uyo mukazi, ku kyanya ali mu honerwa, ngiisi kyo agabwatala kwo, kandi iri kugwejera kwo, kigaaba kikoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","«Uyo mukazi, iri umundu angahuma ku ngingo yage, akwiriiri afule ibyambalwa byage, anayikarabe. Mukuba, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","«Uyo mukazi, iri umundu angahuma ku kindu kyo ashubi bwatiiri kwo, akwiriiri afule ibyambalwa byage, anayikarabe. Mukuba, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Neꞌri angahuma ku ngingo, kandi iri ku ngiisi bindi byo akabwatala kwo, agashiiba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","«Uyo mukazi, iri angagwejerwa, noꞌmuko gwage gunakengeerage gwatoonyera kuꞌyo mushosi, uyo mushosi agaaba akoli yulubiiri halinde ukuhisa ku siku zirinda. Neꞌngingo yo agaaba ali mu gwejera kwo, nayo igaaba ikoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","«Hali ikyanya umukazi angaleeza isiku zaage zoꞌkuhonerwa, kandi iri angahonerwa ku siku zo atali mu honerwa kwo. Kuli kudeta kwo akoli lwaziri umududu. Ku yikyo kyanya kyoshi umuko gugaaba guli mu toonya, agaaba akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Ku yikyo kyanya agaaba ayihandwiri, ikyajo kyage neꞌkitumbi kyage, byombi bigaaba biyulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","«Yibyo bindu byoshi, iri umundu angabihuma kwo, agaaba akoli yulubiiri. Akwiriiri afule ibyambalwa byage, anayikarabe. Mukuba, agaaba akoli yulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","«Uyo mukazi, iri umuko gwage gwangakama, akwiriiri alindirire isiku zirinda. Ha nyuma, agaaba akoli yeruusiri. ");
INSERT INTO flr_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","«Ku lusiku lwoꞌmunaana, agayabiira amahumba gabiri, kandi iri mitungulu ibiri yeꞌngunde, anabisikiirize umugingi ha mulyango gwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Yago mahumba, umugingi agatanga liguma libe ituulo lyoꞌkukogwa ibyaha. Neꞌlyabo, liri lyoꞌkusiriiza lwoshi. Umugingi, mu kugira kwokwo, lyo agamúyeruusa imbere lya Nahano. Noꞌyo mukazi, kundu âli kizi honerwa, haliko agaaba akoli yeruusiri. ");
INSERT INTO flr_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","«Kwokwo, kwo mugakizi langa Abahisiraheeri, gira batakizi yulubala. Buzira kwokwo, hali ikyanya bangayami fwa. Ikyanya bali mu ba bakoli yulubiiri, bangayulubaza kiri niꞌheema lyani Litaluule íriteresirwi mu kati kaabo.» ");
INSERT INTO flr_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Yulwo lubaaja, luloziri umushosi úli mu shuubala amasira, noꞌmushosi úli mu yihwana kwo, halinde anayulubale. ");
INSERT INTO flr_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Luloziri kiri noꞌmukazi úhoniirwi, na ngiisi mushosi úli mu shuubala amasira kandi iri mukazi úli noꞌmududu. Luloziri kiri noꞌmushosi úli mu menyana noꞌmukazi úyulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Balya bagala Harooni babiri, ikyanya bakayegeera Nahano mu bulyo úbutali nga bwo, banayami fwa. ");
INSERT INTO flr_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Ha nyuma, Nahano anabwira Musa kwokuno: «Ubwire mukulu wawe wa Harooni atakizi kolwa kwo ataluka gulya mulondo úguli mu handula Ahandu Heeru bweneene, áhali kalya Kajumba keꞌKihango, noꞌmutumbikizo gwako. Yaho handu, atakizi hayingira ngiisi kyanya kyo aloziizi. Mukuba, haaho ho ngakizi yiyerekana mu kati keꞌbibungu, ku yugwo mutumbikizo gwoꞌlukogo. Neꞌri atangasimbaha, ukufwa, agaafwa. ");
INSERT INTO flr_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","«Ikyanya Harooni agakizi yingira halya handu heeru, akizi kulikira imaaja ku bwitonde. Akwaniini atee leeta ishuuli yeꞌnjuuke libe ituulo lyoꞌkukogwa ibyaha, aleete neꞌkipanga libe ituulo lyoꞌkusiriiza lwoshi. ");
INSERT INTO flr_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Atee kizi karaba amagala gooshi, anabuli yambala ibyambalwa bitaluule byeꞌkitaani. Kuli kudeta ikanju, naꞌkabutura, noꞌmukaba, anayambale noꞌmulondo gwoꞌkusoosa kwiꞌtwe. ");
INSERT INTO flr_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Abahisiraheeri bagakizi múleetera ibihebe bibiri, libe ituulo lyoꞌkukogwa ibyaha, banamúleetere neꞌkipanga kiguma libe ituulo lyoꞌkusiriiza lwoshi. ");
INSERT INTO flr_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","«Iyo shuuli, Harooni agagitanga libe ituulo lyoꞌkukogwa ibyaha byage, halinde alonge ukuyiyeruusa, kuguma neꞌmbaga yage, banabe bakoli yeruusiri imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","«Yibyo bihebe byombi, agabitwala ha mulyango gwiꞌheema lyeꞌmihumaanano, anabitangire Nahano. ");
INSERT INTO flr_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Agabigirira ikibare, gira amenye kihebe kihi íkigatangwa imwa Nahano, na kihi íkigatwalwa imwa Hazazeeri. ");
INSERT INTO flr_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Kirya kihebe íkigayegukira Nahano, agakitanga libe ituulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Haliko kirya kyabo, kigaleetwa imbere lya Nahano kikiri kigumaana. Ha nyuma, kikabuli yimulirwa imwa Hazazeeri mwiꞌshamba, gira abandu ba Rurema balonge ukuyeruusibwa imbere lyage. ");
INSERT INTO flr_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Harooni agatee tanga ishuuli, libe ituulo lyoꞌkukogwa ibyaha byage, na byeꞌmbaga yage, gira balonge ukuyeruusibwa imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","«Ha nyuma, anayingire mwiꞌheema lyeꞌmihumaanano, áhali akatanda. Agaaba afumbiiti isheetezo, anagiyijuze mwoꞌmuliro. Anashamate ifune zibiri zoꞌmubadu mushye bwija, anabitwale mu kisiika íkisiisirwi noꞌmulondo. ");
INSERT INTO flr_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","«Yugwo mubadu, anaguleete imbere lya Nahano, anagubiike ku yugwo muliro. Haaho, hanatutumuke ikyusi, kinabwikire umutumbikizo gwaꞌKajumba ákali mwo galya mabuye geꞌkihango. Umugingi, iri angagira kwokwo, atagaafwa. ");
INSERT INTO flr_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","«Umuko gweꞌyo shuuli, umugingi agagudobeka mwoꞌmunwe, anagushangire ku mutumbikizo gwaꞌKajumba, uluhande lweꞌmbembe, abuli gushangira imbere lyako ubugira kalinda. ");
INSERT INTO flr_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«Ha nyuma, Harooni akwaniini atongeerage kirya kihebe kya mbere, libe ituulo lyoꞌkukogwa ibyaha byaꞌbandu booshi. Umuko gwakyo, anaguyingirane Ahandu Heeru bweneene, anakizi gushangira ku mutumbikizo gwaꞌKajumba, neꞌmbere lyako, nga kwo akagira ku muko gweꞌrya shuuli. ");
INSERT INTO flr_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Mu kugira kwokwo, lyo agayeruusa halya handu heeru, kuguma niꞌheema lyoshi lyeꞌmihumaanano. Mukuba, Abahisiraheeri bali mu kizi yiyulubaza, iri banahuna imbere lya Rurema. ");
INSERT INTO flr_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","«Ikyanya Harooni agakizi yeruusa kirya Kisiika Kyeru Bweneene, ndaaye gundi úhangwirwi ukuyingira mwo. Ku yukwo, akwaniini atee yiyeruusa yenyene, anayeruuse neꞌmbaga yage, naꞌbandi Bahisiraheeri booshi, halinde banabe bakoli kwaniini imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","«Ha nyuma, Harooni anashaage mwiꞌheema lyeꞌmihumaanano, gira agendi yeruusa akatanda ákali imbere lyalyo. Mu kukayeruusa, agayabiira ku muko gweꞌrya shuuli, na ku gwa kirya kihebe, anagubuge ku tugongo twoshi twaꞌkatanda. ");
INSERT INTO flr_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Yugwo muko, agagudobeka mwoꞌmunwe, anagushangire ubugira kalinda ku katanda. Kwokwo, kwo agakayeruusa. Mukuba, Abahisiraheeri bagaaba keera bakakayulubaza. ");
INSERT INTO flr_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Ikyanya Harooni agaaba keera ayeruusagya halya handu heeru, niꞌheema lyeꞌmihumaanano, naꞌkatanda, lyeryo lyo agatanga kirya kihebe íkikiri kigumaana. ");
INSERT INTO flr_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Yikyo kihebe, Harooni agakibiika kwaꞌmaboko gombi mu ruhanga, anakizi kitondobolera kweꞌbyaha byoshi byaꞌBahisiraheeri, naꞌmahube gaabo, noꞌbuhuni bwabo. Kwokwo, kwo agalyosa yibyo byaha mu bandu, anabibiike ku mbene. Ha nyuma, umundu útoozirwi, agakiyimula kigende mwiꞌshamba. ");
INSERT INTO flr_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Kwokwo, yikyo kihebe, ikyanya kigayidungeera mwiꞌshamba, kigatwala mweꞌbyaha byoshi byaꞌbandu. ");
INSERT INTO flr_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«Ha nyuma, Harooni anagalukire mwiꞌheema lyeꞌmihumaanano. Anamuhogolere birya byambalwa byo atáyambiiti Ahandu Heeru bweneene, anabisige mwo. ");
INSERT INTO flr_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Anatee yikarabira áhataluule, abuli yambala ibyambalwa bya ngiisi lusiku. Anahulukage, gira agendi tanga ituulo lyoꞌkusiriiza lwoshi hiꞌgulu lyage yenyene, neꞌlindi hiꞌgulu lyaꞌBahisiraheeri. Mu kugira kwokwo, lyo agayiyeruusa, naꞌbandi booshi, banabe bakoli yeruusiri imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Na kwakundi, akwaniini asiriize birya binyule byeꞌbitugwa íbyatangwa gabe matuulo goꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Ulya gundi mundu úkayimula kirya kihebe kigende mwiꞌshamba lya Hazazeeri, bigamúhuuna kwo atee fula ibyambalwa byage, anayikarabe. Abuli hanguulwa ukuyingira mu shumbi. ");
INSERT INTO flr_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","«Irya shuuli na kirya kihebe, bikwaniini bitwalwe inyuma lyeꞌshumbi. Yibyo bitugwa, byo byebirya íbikatangwa ituulo lyoꞌkukogwa ibyaha, gira abandu babe bakoli yeruusiri. Noꞌmuko gwabyo, Harooni anabe âli mali guyingirana Ahandu Heeru. Imbu zaabyo, neꞌminyofu, naꞌmashe, byoshi binasiriizibwe. ");
INSERT INTO flr_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Umundu úgabisiriiza, akwiriiri afule ibyambalwa byage, anayikarabe, átazi galukira mu shumbi. ");
INSERT INTO flr_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Ulusiku lwiꞌkumi lwoꞌmwezi gwa kalinda, mwe neꞌbinyamahanga íbimùtuuziri mwo, mukizi shiiba muyishalisiizi. Ndaanayo mikolwa yo mugakizi kola. Luno lubaaja, lugakizi yama ho. ");
INSERT INTO flr_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Ku lwolwo lusiku, mugakizi tangirwa amatuulo hiꞌgulu lyoꞌkumùyeruusa imbere lya Nahano, munabe mukoli tungiini. ");
INSERT INTO flr_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Yulwo lusiku, mugakizi luluhuuka kwo, iri munayishalisa. Luno lubaaja, lugayama ho. ");
INSERT INTO flr_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","«Uyo mugingi mukulu Harooni, agagomboolwa noꞌgundi mugingi. Naye, agakizi tanga amatuulo hiꞌgulu lyoꞌkuyeruusa. Agakizi ba ayambiiti ibyambalwa bitaluule byeꞌkitaani. ");
INSERT INTO flr_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Anabe ali mu yeruusa halya Handu Heeru bweneene, na lirya heema lyeꞌmihumaanano, na kalya katanda, na balya bagingi, kuguma naꞌbandi Bahisiraheeri booshi. ");
INSERT INTO flr_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","«Mu ngiisi mwaka, mugakizi yeruusa Abahisiraheeri liguma, iri munalyosa ibyaha byabo, halinde banabe bakoli kwaniini imbere lya Nahano. Luno lubaaja, lugayama ho.» Yibyo byoshi byo Nahano akakomeereza Musa, Musa anabikulikiriza. ");
INSERT INTO flr_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","kwo amenyeese Harooni, na bagala, naꞌBahisiraheeri booshi, kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","«Ngiisi úyimbwa Muhisiraheeri, hali ikyanya agatanga ituulo, mu kubaaga ingaavu, kandi iri kyanabuzi, kandi iri mbene. Yikyo kitugwa, atakwaniini akibaagire mu shumbi, kandi iri ha nyuma lyayo. ");
INSERT INTO flr_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Haliko, akizi kibaagira ha mulyango gwiꞌheema lyeꞌmihumaanano. Buzira kwokwo, uyo mundu agaharuurwa kwo ali munamahube, ngoꞌmundu úwayona umuko gwoꞌwabo. Uyo, alyagagi mwitani, anakwiriiri atwibwe mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","«Yulu lubaaja, akalimbi kaalwo, kwaꞌBahisiraheeri bakizi twala ibitugwa imunda umugingi ha mulyango gwiꞌheema lyeꞌmihumaanano, lyo alonga ukutangira Nahano amatuulo goꞌkuyerekana ingoome. Si buno, yago matuulo, yabo Bahisiraheeri bali mu kizi gabaagira mu mbingiro. ");
INSERT INTO flr_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Ikyanya abitwala áhali iheema lyeꞌmihumaanano, lyoꞌmugingi agalonga ukushangira umuko ku katanda ákali ha mulyango gwalyo. Anayokye neꞌrya mituli yeꞌbinyule, halinde umushiiriri gunasimiise Nahano. ");
INSERT INTO flr_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","«Abahisiraheeri batwikirage ukukizi tanga ituulo imweꞌmizimu íri neꞌnjusho yeꞌbihebe. Si mu kugira kwokwo, bataki ba bemeera imwani. Luno lubaaja, Abahisiraheeri bagaluyamana halinde mu bibusi byabo byoshi. ");
INSERT INTO flr_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«Ushubi bamenyeesa kwo ngiisi Muhisiraheeri, kandi iri kinyamahanga íkimùtuuziri mwo, iri kyangalooza ukutanga ituulo lyoꞌkusiriiza lwoshi, kandi iri irindi-rindi ituulo, ");
INSERT INTO flr_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","akwiriiri alileete ha mulyango gwiꞌheema lyeꞌmihumaanano, gira Nahano abe ye galitangirwa. Buzira kwokwo, uyo mundu akwiriiri atwibwe mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","«Ngiisi Muhisiraheeri nirizina, kandi iri kinyamahanga íkimùtuuziri mwo, iri angalya umuko, ngamúrakarira, ninamútwe mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Mukuba, ubugumaana bweꞌkiremwa, buli mu muko. Yugwo muko, keera namùyereka ngiisi kwo mugakizi gutanga ku katanda, mu kukogwa ibyaha biinyu. Yugwo muko, gwo guli mwoꞌbugumaana, gwo gunali mu mùyeruusa. ");
INSERT INTO flr_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Kyo kitumiri nꞌgamùkomeereza kwokuno: “Mutâye nywe umuko, aba mundu úli mu kati kiinyu, kandi iri binyamahanga íbimùtuuziri mwo.” ");
INSERT INTO flr_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«Hali ikyanya Umuhisiraheeri kandi iri kinyamahanga íkimùtuuziri mwo, angagendi hiiva, anayije ayita inyamiishwa íhangwirwi ukuliibwa, kandi iri kanyuni. Umuko gwabyo, akwiriiri aguyonere kwiꞌdaho, anagufulire. ");
INSERT INTO flr_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Mukuba, mu muko gweꞌkiremwa, mwo muli ubugumaana. Kyo kitumiri nꞌgabwira Abahisiraheeri kwokuno: “Mutâye lye umuko gweꞌkiremwa kyoshi. Mukuba, mu muko gwakyo, mwo muli ubugumaana. Yugwo muko, ngiisi úgaagunywa kwo, agatwibwa mu Bahisiraheeri.” ");
INSERT INTO flr_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","«Na kwakundi, ngiisi Muhisiraheeri nirizina, kandi iri ikinyamahanga mu byo mutuliinwi, iri angalya íkyatumba, kandi iri ikitugwa íkyayitwa neꞌnyamiishwa, akwiriiri afule ibyambalwa byage, anayikarabe. Agashiiba ayulubiiri halinde kabigingwe, akabuli yeruuka. ");
INSERT INTO flr_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","«Halikago uyo mundu, iri atangafula ibyambalwa byage, anabe atayikarabiri, bwo agira ikyaha, agaaba ayikululira umwama.» ");
INSERT INTO flr_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","kwo amenyeese Abahisiraheeri kwokuno: «Niehe, nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Kundu mwâli tuuziri mu kihugo kyeꞌMiisiri, na kundu nꞌgamùleeta mu kihugo kyeꞌKaanani, haliko yibyo bihugo, mutakolwe kwo mwayiga ingesho zaꞌbandu baamwo. ");
INSERT INTO flr_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Si mwehe, mukizi simbaha imaaja zaani, naꞌmategeko gaani. Mukuba, nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Yizo maaja zaani naꞌmategeko gaani, ikyanya mugakizi bisimbaha, lyo mugalonga ukulama. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","«Utakizi gira mbu ugwejere noꞌmukazi wa mu mbaga yawe. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","«Utasambane nyoko. Iri wangagira kwokwo, ugaaba wateerera yisho ulushaagwa. Bwo ali nyoko, utamúgwejere. ");
INSERT INTO flr_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","«Utanateerere yisho ulushaagwa, mu kugwejera muguma mu bakaage. ");
INSERT INTO flr_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","«Hatagirage úgagwejera mwali wage, ye yishe akabuta, kandi iri ye nyina akabuta. Biri kwokwo, kundu angaba akalererwa handi-handi. ");
INSERT INTO flr_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","«Hatagirage úgasambana mwijukulu wage, aba munyere wa mugala wawe, kandi iri wa munyere wawe. Iri wangamúsambana, ugaaba wayiteerera ulushaagwa wenyene. ");
INSERT INTO flr_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","«Hatagirage úgasambana mwali wage ye muka yishe akabuta. Si uyo naye, ali mwali wawe! ");
INSERT INTO flr_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","«Hatagirage úgagwejera nashengi. Uyo, ali mwali wa yisho. ");
INSERT INTO flr_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","«Hatagirage úgasambana mwene wabo nyina. Si uyo, ali mukulu wa nyoko, kandi iri mulumuna wage. ");
INSERT INTO flr_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","«Utanateerere yisho wawe ulushaagwa, mu kugwejera mukaage. Si uyo, ali nyoko. ");
INSERT INTO flr_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","«Hatagirage úgagwejera mwali-kazi wage. Si uyo, ali muka mugala wawe. ");
INSERT INTO flr_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","«Hatagirage úgasambana muka mukulu wage. Si mu kugira kwokwo, ugaaba wateerera mukulu wawe ulushaagwa, unabe wamúhubira. ");
INSERT INTO flr_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","«Utanagwejere umukazi, mbu unashubi sambana munyere wage, kandi iri mwijukulu wage, aba mwijukulu ku mugala wage kandi iri ku munyere wage. Si yabo, bo baguma! Iri wangabagirira mwene yukwo, ziri shoni ngana-ngana. ");
INSERT INTO flr_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","«Ikyanya mukaawe akiri ho, utakolwe kwo wayanga mulumuna wage. Mu kugira kwokwo, ugakengeera wavyula imirongwe. ");
INSERT INTO flr_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","«Utanagwejere noꞌmukazi, ikyanya ahoniirwi. Si ku yikyo kyanya, akoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","«Hatagirage úgasambana muka umutuulani wage. Mutayiji kengeera wayiyulubaza. ");
INSERT INTO flr_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","«Hatanagire úgatanga umwana wage, mbu libe ituulo lyoꞌkusiriiza imwoꞌmuzimu Moleki. Nga wangagira kwokwo, ugaaba wangayiriza. Niehe, nie Nahano Rurema wawe. ");
INSERT INTO flr_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","«Hatanagire úgasambana uwabo mushosi, nga kwo angagwejera umukazi. Ukugira kwokwo, kiri kyagaza ngana-ngana. ");
INSERT INTO flr_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","«Hatagirage úgasambana neꞌkitugwa. Mu kugira kwokwo, iri mwayiyulubaza. Kiri noꞌmukazi, atakolwe kwo ahigulire ku kitugwa. Kiri kyagaza bweneene. ");
INSERT INTO flr_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","«Yibyo bihigo byoshi byo nadeta hano, mutakolwe mbu muyidwakaze mu kubigira. Si abandu bo ngweti ngamùyimulira imbere liinyu, bagweti bagayiyulubaza mwene kwokwo. ");
INSERT INTO flr_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Kyo kitumiri ikihugo kyabo, kikoli yulubiiri. Na buno, ngweti ngakihana. Kiri naꞌbatuulaga baamwo, kigabashala, balyoke imbere lyani. ");
INSERT INTO flr_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","«E Bahisiraheeri, yibi bihigo byoshi, mwe neꞌbinyamahanga íbimùtuuziri mwo, mukwiriiri mubitwikire kwo, munakizi simbaha imaaja zaani, naꞌmategeko gaani. ");
INSERT INTO flr_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Yibyo bihigo byoshi, abatuulaga ba mu kihugo kyo ngamùheereza boohe, bâli kizi bigira, halinde ikihugo kyabo kikoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","«Aahago! Yikyo kihugo, mutashubi kiyulubaza, kitakengeere niinyu kyamùshala, nga kwo kikashala abandu ábâli kituuziri mwo. ");
INSERT INTO flr_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Ngiisi ábagakizi yifunda mu byaha mwene kwokwo, bagakizi twibwa mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","«Yizi maaja zaani, mukizi zisimbaha. Mutanakizi yiyulubaza, mu kukizi kulikira ingesho mbi zaꞌbandu ábakatanga imbere liinyu mu kino kihugo. Niehe, nie Nahano Rurema winyu.» ");
INSERT INTO flr_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Nahano anabwira Musa ");
INSERT INTO flr_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","kwo amenyeese Abahisiraheeri booshi kwokuno: «Niehe ndi mweru. Ku yukwo niinyu, mukizi ba beeru. ");
INSERT INTO flr_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ngiisi muguma winyu, akwiriiri akizi simbaha yishe na nyina, anakizi simbaha neꞌsiku zaani zeꞌSabaato. Nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","«Mutakizi yitulira imigisi mu byuma, mutanakizi giyikumba. Nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","«Ikyanya mugakizi ndangira ikitugwa, libe ituulo lyoꞌkuyerekana ingoome, mukizi litanga ku njira íkwaniini, gira lilonge ukuyemeerwa. ");
INSERT INTO flr_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Yikyo kitugwa, inyama zaakyo zikwiriiri ziliibwe lwolwo lusiku, kandi iri kusheezi. Halikago, ngiisi ízigasigala halinde ku lusiku úlugira izishatu, zikwiriiri zisiriizibwe. ");
INSERT INTO flr_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Yizo nyama, iri zangaliibwa ku úlugira izishatu, zigaaba zikoli yulubiiri, ndanganaki ziyemeera. ");
INSERT INTO flr_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ngiisi úgaazilya kwo, agaaba ayulubaza ikindu kyo nienyene nataluula. Ku yukwo, agatwibwa mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","«Ikyanya mugakizi yimbula umwimbu gweꞌngano mu kihugo kiinyu, mutayimbulize bweneene, halinde ukuhisa ku mbeka yeꞌndalo. Na kwakundi, mutakizi shubi galukira inyuma, mbu mukuumanie imisigala. ");
INSERT INTO flr_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Kiri neꞌmimbu yeꞌmizabibu, mutakizi galukira ukutoola imihuli yo mwayibagira, kandi iri íyatibukira haashi. Yibyo byoshi, mugakizi bisigira abakeni, kuguma neꞌbinyamahanga byo mukoli tuliinwi. Nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","«Mutakizi zimba. Mutanakizi tebana. Mutanakizi lyalyania. ");
INSERT INTO flr_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Mutanakizi ndeeza ishoni, mu kubiika iziina lyani kweꞌndahiro zeꞌbibeesha. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","«Mutakizi libuzania, kandi iri kuzimbana. Abakozi biinyu, mutakizi laalana imbembo zaabo halinde shesheezi. ");
INSERT INTO flr_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","«Mutakizi daaka babitwitwi. Kiri neꞌmbumi, mutakizi zisiitaza. Haliko, mukizi yoboha Rurema winyu. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","«Ikyanya mugakizi twa imaaja, mutakizi zishobania, mbu lyo mukizi kundirira abakeni, kandi iri abanalushaagwa. Halikago, mukizi zitwa ku njira íkwaniini. ");
INSERT INTO flr_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","«Mutakizi genda mugagambana. Mutanafunde umutuulani winyu, ho agaasiga itwe lyage. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","«Mwene winyu, iri angakuhubira, utabiike umujina mu mutima gwawe. Halikago, ugendi múyerekeza, utayiji kengeera wayibetuza ibyaha byage. ");
INSERT INTO flr_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","«Mutakolwe kwo mwayihoola abiinyu Bahisiraheeri. Mutanakizi babiikira inzigo. Haliko, mukizi kundana, nga kwo muyikuuziri mwenyene. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","«Mukizi simbaha imaaja zaani. Mu bitugwa biinyu, mutakizi yimiisa ibitugwa byeꞌmilala ibiri. Kiri neꞌndalo ziinyu, mutabyale mweꞌmbuto zeꞌmilala ibiri. Neꞌbyambalwa biinyu, mutayambale íbikalukwa mu milala ibiri yeꞌnuzi. ");
INSERT INTO flr_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","«Hali ikyanya umuja-kazi angaba afundikwa noꞌmushosi, haliko anabe atâli zaazi guluulwa, kandi iri kushwekuulwa. Kwokwo, iri ugundi mushosi angamúsambana, akwaniini ahyule. Haliko, yabo bombi batayitwe. Mukuba, uyo mukazi atâli zaazi shwekuulwa. ");
INSERT INTO flr_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Uyo mushosi akwiriiri atwale ikipanga ha mulyango gwiꞌheema lyeꞌmihumaanano, libe ituulo lyoꞌkuhyula. ");
INSERT INTO flr_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Uyo mundu, umugingiagamúnywaniisa imbere lya Nahano, ku njira yoꞌkumútangira yikyo kipanga. Kwokwo, kweꞌkyaha kyage kigaakogwa. ");
INSERT INTO flr_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","«Ikyanya mugayingira mu kihugo kyeꞌKaanani, mugabyala imilala mingi yeꞌbiti byeꞌbitumbwe. Yibyo bitumbwe, mugatee hisa imyaka ishatu muli mu biharuura nga biyulubiiri. ");
INSERT INTO flr_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ku mwaka gwa kana, mugabindangira, iri munakizi nyivuga. ");
INSERT INTO flr_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Na ku mwaka gwa kataanu, lyoki lyo mwangakoli tondeera ukubilya. Iri mwangakizi gira kwokwo, imimbu yinyu igakizi hemba ngana-ngana. Nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","«Mutakizi lya inyama, ikyanya ikiri noꞌmuko. Na kwakundi, mutakizi laguza, mutanakizi logana. ");
INSERT INTO flr_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","«Umushaku ku mwatwe giinyu, mutakizi gumwesa ikitapwa. Noꞌlwanwa lwinyu, mutakizi lumwa mu mbengere. ");
INSERT INTO flr_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","«Ikyanya mugagandaara úwafwa, mutakizi yibejanga-bejanga hiꞌgulu lyage. Mutanakizi yishala ishalo. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","«Munyere wawe, utamúmalire ulushaagwa, mu kumúshimya kwo abe mushule. Iri wangamúshimya kwokwo, abandu booshi ba mu kihugo, bagayiji músambana, anahimbuke bweneene. ");
INSERT INTO flr_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","«Mukizi simbaha isiku zaani zeꞌSabaato. Niꞌheema lyani lyeꞌmihumaanano, mukizi lisimbaha. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","«Mutakizi gendi laguza imweꞌmizimu. Mutanakizi hanuusa abafwiri, mutayiji kengeera mwayiyulubaza. Nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","«Ikyanya umushaaja agayija, mukizi múheereza ulushaagwa, mu kuyimuka imbere lyage. Na kwakundi, mukizi simbaha Rurema winyu. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","«Ikyanya ibinyamahanga bigayiji tuula mu kihugo kiinyu, utakizi bigirira buligo. ");
INSERT INTO flr_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Si mukizi bakunda nga beene winyu, nga kwo muyikuuziri mwenyene. Mukengeere kwo niinyu mwâli riiri binyamahanga mu kihugo kyeꞌMiisiri. Nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","«Ikyanya mugakizi gera ubula-bula, noꞌbuzito, kandi iri íbiyijwiri, mutakizi koleesa ingero zeꞌbibeesha. ");
INSERT INTO flr_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Haliko, mukwiriiri mukizi koleesa ibigerero íbikwaniini, noꞌbuzito úbukwaniini, neꞌndambo ízikwaniini. Nie kamùlyosa mu kihugo kyeꞌMiisiri. Na ndi nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","«Yizi maaja zaani zooshi, kuguma naꞌmategeko gaani, mukwiriiri mukizi bisimbaha. Niehe, nie Nahano.» ");
INSERT INTO flr_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","kwo amenyeese Abahisiraheeri kwokuno: «Umuhisiraheeri, iri angatanga umwana wage, libe ituulo lyoꞌkusiriigiza umuzimu Moleki, uyo mundu akwiriiri ayami yitwa. Abatuulaga bamúyite, mu kumúlasha amabuye. Yulwo lubaaja ludesiri hiꞌgulu lyaꞌBahisiraheeri booshi, kiri neꞌbinyamahanga byo mutuliinwi. ");
INSERT INTO flr_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Si mu baana baabo, ikyanya bali mu tanga muguma, libe ituulo lyoꞌkusiriigiza umuzimu Moleki, lyo bali mu yulubaza iheema lyani Litaluule, banabe bagayiriza iziina lyani. Haaho, lyo nienyene ngabaheereza ingoto, ninayami batwa mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","«Ulya mundu woꞌkutanga umwana wage imwa Moleki, hali ikyanya abatuulaga bangamúkejeerera, banaleke ukumúyita. ");
INSERT INTO flr_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Haaho, lyo nienyene, ngabahindukira, kuguma neꞌmbaga zaabo, na mbatwe mu Bahisiraheeri. Mukuba, ikyanya bali mu ba bagweti bagayikumba umuzimu Moleki, iri batakiri bemeera imwani. ");
INSERT INTO flr_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","«Yabo bandu, iri bangakizi gendi laguza, kandi iri bagendi hanuusa abafwiri, ngabahindukira, na mbatwe mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","«Ku yukwo, muyitaluule, munabe beeru. Nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","«Mukizi simbaha imaaja zaani zooshi. Mukuba, nie Nahano. Nie gweti ngakizi mùyeruusa. ");
INSERT INTO flr_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","«Umundu yeshi, iri angadaaka yishe kandi iri nyina, akwiriiri ayitwe. Bwo adaaka ababusi baage, umuko gwage gugaaba kwiꞌtwe lyage. ");
INSERT INTO flr_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","«Umushosi, iri angasambana muka uwabo, yabo bombi, bakwiriiri bayitwe. ");
INSERT INTO flr_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","«Umwana, iri angashuleha muka yishe, agaaba ateerera yishe ulushaagwa. Yabo bombi, bwo bashulehana, bakwiriiri bayitwe. Umuko gwabo, gugaaba ku matwe gaabo. ");
INSERT INTO flr_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","«Umushosi, iri angashuleha umwali-kazi, yabo bombi bakwiriiri bayitwe. Mukuba, bagira ibitalaalwe. Umuko gwabo, gugaaba ku matwe gaabo. ");
INSERT INTO flr_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","«Umushosi, iri angahigulira kuꞌwabo mushosi, nga kwo angashuleha umukazi, yabo bombi bali mu ba keera bahigula, bakwiriiri bayitwe. Umuko gwabo, gugaaba ku matwe gaabo. ");
INSERT INTO flr_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","«Umushosi, iri angayanga umunyere, anashubi yanga na nyina, agaaba ahigula. Uyo mushosi, na yabo bakazi bombi, bakwiriiri basiriizibwe, bakiri bagumaana. Kwokwo, kwo mugaaba mwashaaza amabi mu kati kiinyu. ");
INSERT INTO flr_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","«Umushosi, iri angahigulira ku kitugwa, akwiriiri ayitwe. Yikyo kitugwa nakyo, kikwiriiri kiyitwe. ");
INSERT INTO flr_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","«Umukazi naye, iri angahigula ku kitugwa, akwiriiri ayitwe. Na yikyo kitugwa, kikwiriiri kiyitwe. Umuko gwoꞌyo mukazi, gugaaba kwiꞌtwe lyage, na gweꞌkitugwa, gugaaba kwiꞌtwe lyakyo. ");
INSERT INTO flr_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","«Umushosi, iri angayanga mwali wage, umunyere wa yishe, kandi iri wa nyina, agaaba ashuleha. Yiryo igambo liri mu leeta ishoni bweneene. Ku yukwo, bakwiriiri bahanirwe ha bweruula, mu kutwibwa mu beene wabo. Bwoꞌyo mushosi ali mu ba keera ateeza mwali wage ishoni, akwaniini ukuhanwa. ");
INSERT INTO flr_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","«Umushosi, iri angamenyana noꞌmukazi úkoli honiirwi, bombi bakwiriiri bahandulwe mu Bahisiraheeri. Ku bwenge bayemerezania, mu kuyereka ishyoko yoꞌmuko gwage. ");
INSERT INTO flr_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","«Utakolwe kwo washuleha mu banyoko wawe, kandi iri mu banyoko-shengi. Umushosi, mu kugira kwokwo, agaaba abonia mwene wabo ishoni. Yabo bombi, bagaahanwa. ");
INSERT INTO flr_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","«Ngoꞌmundu angagwejera muka mwizo wage, agaaba ateerera mwizo wage ulushaagwa. Yabo bombi, bwo bahigula, bagaahanwa hiꞌgulu lya yikyo kyaha kyabo, bagaanafwa bátabuta. ");
INSERT INTO flr_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","«Umushosi, nga angayanga muka mwene wabo, agaaba agira íbitali nga byo. Uyo mwene wabo, amúgayiriza ngana. Yabo bombi, bagaafwa bátabuta. ");
INSERT INTO flr_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","«Imaaja zaani zooshi, mukwiriri mukizi zisimbaha, munakizi kulikira ngiisi kwo ndi mu mùtegeka. Buzira kwokwo, kundu nꞌgamùheereza ikihugo, haliko kigayiji mùshala. ");
INSERT INTO flr_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","«Mutakolwe mbu mukulikire ingesho zeꞌmilala yo nagwanwa namùyimulira. Si bagweti bagaagira íbiri mu teezania ishoni. Kyo kyatuma mbashombiri bweneene. ");
INSERT INTO flr_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","«Haliko mwehe, keera nꞌgamùlagaania kwo mwe mugahyana ikihugo kyabo. Ee! Nie namùheereza kyo, kibe kyeꞌmwinyu. Yikyo kihugo kiyeziri mwaꞌmata noꞌbuuki. «Nie Nahano Rurema winyu. Keera nꞌgamùhandula ku gindi milala. ");
INSERT INTO flr_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Kyo kitumiri mukwiriiri musobanukirwe neꞌbitugwa íbiyulubiiri, neꞌbyeru. Kiri noꞌtunyuni, na íbiri mu yibulula, kwo na kwokwo. Kyo kitumiri keera nꞌgabihandula, gira lyo mukizi longa ukumenya ngiisi íbiri naꞌkashembo. ");
INSERT INTO flr_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","«Nie Nahano, ndi mweru. Kwokwo, niinyu, mukizi ba beeru. Mukuba, nꞌgamùhandula ku gindi milala, gira lyo muba beꞌmwani. ");
INSERT INTO flr_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","«Umushosi kandi iri mukazi, iri angakizi lagula neꞌmizimu, kandi iri ahanuusa abafwiri, akwiriiri ayitwe mu kulashwa amabuye. Umuko gwage, gugaaba kwiꞌtwe lyage yenyene.» ");
INSERT INTO flr_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Nahano anabwira Musa, kwo amenyeese abagingi, bagala Harooni, kwokuno: «Umugingi atahangwirwi ukuyiyulubaza, mu kuhuma ku kirunda kyoꞌmundu wiꞌkondo lyage. ");
INSERT INTO flr_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Ngeeka kibe naaho kirunda kyoꞌmundu wa mu mbaga yage. Kuli kudeta ikirunda kya nyina, kandi iri kya yishe, kandi iri kya mugala wage, kandi iri kya munyere wage, kandi iri kya mwene wabo, ");
INSERT INTO flr_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kandi iri kya mwali wage útazindi yangwa. (Mukuba, uyo mwali wage, atakayingira mu mbaga yoꞌgundi mundu.) Yabo, iri bangafwa, booki, angayiyulubaza hiꞌgulu lyabo. ");
INSERT INTO flr_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Haliko atangayiyulubaza hiꞌgulu lyoꞌmundu, mbu bwo ali weꞌmbaga yage ku njira yoꞌkuyanga. ");
INSERT INTO flr_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","«Abagingi, mu kigandaaro, batahangwirwi ukumwebwa akahala, kandi iri ukumwa ulwanwa mu mbengere, kandi iri kuyishaakira. ");
INSERT INTO flr_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Bakwaniini bayitaluule imwa Rurema wabo, banakizi músimbaha, mu kukizi gingika iziina lyage. Mukuba boohe, bo bali mu ndeetera amatuulo goꞌkusiriiza. Yago matuulo, byo byokulya íbiri mu tangwa imwani. Ku yukwo, bakwiriiri bakizi ba beeru. ");
INSERT INTO flr_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","«Abagingi, bali mu ba bakoli talwirwi imwa Rurema wabo. Ku yukwo, batahangwirwi ukuyanga umukazi mushule, kandi iri úkahuluka imwa yiba. ");
INSERT INTO flr_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Yabo bagingi, mukwaniini mukizi baharuura kwo bali bandu beeru. Mukuba, bo bali mu ndangira ibyokulya. Niehe Nahano ndi mweru, na ndi mu mùyeruusa. Ku yukwo yabo bagingi nabo, mubaharuure kwo bali bataluule. ");
INSERT INTO flr_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","«Umunyere woꞌmugingi, iri angayiteerera ulushaagwa mu kuyiyingiza mu busambani, iri abonia yishe ishoni. Umunyere mwene uyo, akwiriiri asiriizibwe akiri mugumaana. ");
INSERT INTO flr_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","«Umugingi mukulu, ye kuliiri abaabo booshi. Ulusiku akabiikwa mu mukolwa, akataluulwa mu kuyonerwa amavuta mwiꞌtwe, anayambikwa ibyambalwa bitaluule. Kyo kitumiri atahangwirwi ukukizi shovya umushaku gwage, atanahangwirwi ukukizi daatula ibyambalwa byage, ");
INSERT INTO flr_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","kandi iri kuyegeera ikirunda. Kiri neꞌkyanya yishe kandi iri nyina afwa, atakwiriiri ukuyiyulubaza hiꞌgulu lyabo. ");
INSERT INTO flr_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Atanahangwirwi kwo alyoke Ahandu Heeru, mbu lyo agendi lola ikirunda. Mukuba, ali mu ba keera ayeruusibwa ku njira yoꞌkushiigwa amavuta ga Rurema wage. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","«Umugingi mukulu, akwiriiri ayange naaho úkiri munyere. ");
INSERT INTO flr_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Atakwiriiri kwo ayange namufwiri, kandi iri umukazi úkahuluka imwa yiba, kandi iri umushule. Akwiriiri ukuyanga naaho umuhyakazi wa mwiꞌkondo lyage. ");
INSERT INTO flr_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Kwokwo, lyaꞌbandu beꞌkibusi kyage bakizi ba bataluule. Uyo mugingi mukulu, nie ndi mu mútaluula. Niehe, nie Nahano.» ");
INSERT INTO flr_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","kwo amenyeese Harooni kwokuno: «Mu bibusi byawe íbigaki yija, ndaaye mwana wawe weꞌkirema, úhangwirwi ukuyegeera akatanda, mbu andangire ituulo lyeꞌbyokulya, ");
INSERT INTO flr_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","iba mbumi, kandi iri uluzingo, kandi iri waꞌmalanga magonye-gonye, kandi iri weꞌkirumbu kila ku kyabo, ");
INSERT INTO flr_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","kandi iri úli mu shunuka, kandi iri woꞌkuboko kuguma, ");
INSERT INTO flr_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","kandi iri weꞌfumbi, kandi iri weꞌkitirimo kyofi ukuhima ulugero, kandi iri weꞌmiryezi, kandi iri mulwazi weꞌkikoba, kandi iri mubata. ");
INSERT INTO flr_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","«Yabo ba mu kibusi kyawe ábalemahiri, ndaaye kiri noꞌmuguma úhangwirwi ukuyegeera akatanda mbu andangire ituulo lyeꞌbyokulya. Yubwo bulema bwage, bwo butumiri atahangwirwi ukugira imikolwa yoꞌbugingi. ");
INSERT INTO flr_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","«Uyo mundu úlemahiri, angalya ku byo bali mu ndangira ku katanda, kiri na ku bindi byokulya byo bali mu kizi ndaluula, nga kwaꞌbandi bali mu birya. ");
INSERT INTO flr_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Halikago, hiꞌgulu lya yubwo bulema bwage, atakolwe kwo ayegeera ha mulondo úguli mu siika Ikisiika Kyeru Bweneene, kandi iri ha kalya katanda. Atakolwe kwo ayulubaza Ahandu haani Heeru. Nie Nahano, nie mu mùtaluulira abagingi.» ");
INSERT INTO flr_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Yago gooshi, Musa anagaganuulira Harooni, na bagala baage, naꞌbandi Bahisiraheeri booshi. ");
INSERT INTO flr_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Ubwire Harooni naꞌbagala, kwaꞌmatuulo Abahisiraheeri bagakizi ndangira, gali mataluule imwani. Ku yukwo, bakizi gasimbaha, lyo bayerekana kwo basimbahiri iziina lyani. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","«Mu bibusi íbigaki yija, umundu weꞌmbaga yaꞌbagingi, nga angaba akoli yulubiiri, anabe aki gweti agayegeera amatuulo gaꞌBahisiraheeri bakataluula hiꞌgulu lyani, uyo mundu akwaniini alahizibwe atakizi ki ngolera. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","«Na kwakundi, ndaaye mugingi úhangwirwi ukulya ku matuulo mataluule imwa Rurema, ku kyanya ayahukiirwi noꞌmubembe, kandi iri ali mu shuubala amasira, kandi iri akayiyulubaza mu kuhuma ku kirunda, kandi iri ayihwana kwo, ");
INSERT INTO flr_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","kandi iri akahuma ikiremwa kiniini kyoꞌmuziro, kandi iri akahuma ku mundu úyulubiiri ku njira ndebe. ");
INSERT INTO flr_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Uyo mundu, agashiiba ayulubiiri halinde kabigingwe. Atanahangwirwi kwo alye ku byokulya byo bataluula imwa Rurema, átazi yikaraba. ");
INSERT INTO flr_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ikyanya izuuba ligasooka, lyo agaaba keera ayeruuka. Lyoki, anabuli lya ku yago matuulo. Mukuba, byebyo, byo byokulya byage. ");
INSERT INTO flr_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","«Umugingi, atakwiriiri ukukizi lya inyama yeꞌkitugwa íkyatumba, kandi iri íkyayitwa neꞌnyamiishwa. Yizo nyama, iri angazilya kwo, angakengeera ayiyulubaza. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","«Yizo maaja zooshi, iri abagingi bangazisimbaha, nga kwo nabakomeereza, batagayikululira umwama. Iri bangayitonda mu mukolwa gwabo, batagaafwa. Niehe, nie Nahano. Nie mu bayeruusa. ");
INSERT INTO flr_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","«Abandu ba mwiꞌkondo lyaꞌbagingi naaho bo bahangwirwi ukulya ibyokulya íbikataluulwa imwa Rurema. Si umugeezi úwalaalira umugingi, kandi iri abakozi baage, boohe batahangwirwi kwo babilye kwo. ");
INSERT INTO flr_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","«Uyo mugingi, iri angaba keera akagula umuja, uyo muja yeki ahangwirwi ukulya ku byokulya bitaluule imwoꞌmugingi. Kiri naꞌbaana boꞌyo muja nabo, bahangwirwi ukukizi birya kwo. ");
INSERT INTO flr_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","«Munyere woꞌyo mugingi, iri angayangwa noꞌmushosi útali mugingi, ataki hangwirwi ukukizi lya amatuulo mataluule imwa Rurema. ");
INSERT INTO flr_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Halikago, hali ikyanya angaba akola namufwiri, kandi iri akayimulwa na yiba, anabe atabusiri, anagalukire imwa yishe. Iri yishe angamúbeerana nga ku kyanya atâli zaazi yangwa, lyoki, angashubi kizi lya ku byokulya bya yishe. Mukuba, yibyo byokulya, abandu ba mu mbaga yoꞌmugingi naaho, bo bahangwirwi ukukizi birya kwo. ");
INSERT INTO flr_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","«Yibyo byokulya bitaluule, ngoꞌgundi mundu angatagalwa, anabilye kwo, akwaniini agalulire umugingi ikishingo kyoꞌmutuli gwo akatwala. Na mu kukigalula, akiyushuule kwoꞌmutuli muguma gwa kataanu. ");
INSERT INTO flr_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","«Ikyanya Abahisiraheeri bali mu tanga amatuulo mataluule imwa Nahano, abagingi batakwaniini ukugaharuura nga byokulya bya ngiisi lusiku. ");
INSERT INTO flr_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Batahanguule kwaꞌbandi bandu bakizi birya kwo. Yabo bagingi, iri bangahanguula ábatali bo, kwo bakizi birya kwo, bagaaba bababetuza ubuhube. Banabe bakoli kwaniini ukubigalula neꞌfwaranga. Niehe, nie Nahano. Nie mu bayeruusa.» ");
INSERT INTO flr_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","kwo amenyeese Harooni na bagala baage, naꞌbandi Bahisiraheeri booshi, kwokuno: «Yizi maaja, ziloziri Abahisiraheeri nirizina, kuguma neꞌbinyamahanga íbimùtuuziri mwo. Hali ikyanya mwangandangira ituulo lyeꞌkitugwa kyoꞌkusiriiza, liba lya kukwiza byo mukalagaania Rurema, kandi iri lya kwoꞌmundu aloziizi. ");
INSERT INTO flr_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Yikyo kitugwa, yangaba iri shuuli, kandi iri kipanga, kandi iri kihebe. Na kandi, kibe kizira kashembo. Lyoki, yiryo ituulo, ngaliyemeera. ");
INSERT INTO flr_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Si mutakwiriiri ukundangira ikitugwa íkiri naꞌkashembo. Mukuba, ndagamùyemeerera kyo. ");
INSERT INTO flr_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","«Iri mwangandeetera ituulo lyoꞌkuyerekana ingoome, yiryo ituulo kibe kitugwa kizira kashembo, iba shuuli, kandi iri kibuzi, kandi iri mbene. Yiryo ituulo, lyangaba lya kukwiza byo mukalagaania Rurema, kandi iri lya kwoꞌmundu aloziizi. ");
INSERT INTO flr_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Kwokwo, mutakolwe mbu muyiji ndangira ikitugwa kyoꞌkusiriiza ku katanda, kinahumiri, kandi iri kilemahiri, kandi iri kivunisiri, kandi iri kiri neꞌbishekera, kandi iri kiri mu huluka amasira, kandi iri kiri mu yikwaraashura. ");
INSERT INTO flr_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Yikyo kitugwa, iri kyangaba noꞌkugulu kula noꞌkwofi, kyangatangwa ngiꞌtuulo lyo muloziizi ukutanga mwenyene. Haliko, kitakwiriiri ukutangwa hiꞌgulu lyoꞌkukwiza indahiro. ");
INSERT INTO flr_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","«Yikyo kitugwa, kitabe kikasayulwa, kuba kututwa amahuura, kandi iri kugalyosa, kandi iri kuganongola. Ikyanya mugaaba keera mwahika mu kihugo kiinyu, ituulo mwene yiryo, mutakizi litanga. ");
INSERT INTO flr_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","«Na kwakundi, ibitugwa mwene yibyo, mutakolwe kwo mwabiyabiira mu binyamahanga, mbu muyiji bindangira amatuulo. Nie Rurema winyu. Ibitugwa mwene yibyo, ndangabiyemeera. Mukuba, biri naꞌkashembo, binali noꞌbulema.» ");
INSERT INTO flr_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Nahano anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Inyana kandi iri kyanabuzi, kandi iri kyanahene, iri kyangabutwa, kikwaniini kibeere na nyina halinde ku siku zirinda. Haliko, ukulyokera ku lusiku úlugira umunaana, nayemeera kwo mwangakoli kindangira ituulo lyoꞌkusiriiza. ");
INSERT INTO flr_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Kundu kwokwo, mutatongeere ingaavu, kandi iri kibuzi, kandi iri mbene lusiku luguma noꞌmwana wayo. ");
INSERT INTO flr_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","«Ikyanya mugakizi ndeetera ituulo mu kundangira kongwa, mugakizi litanga ku njira yo ligayemeerwa kwo. ");
INSERT INTO flr_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Yikyo kitugwa, mukwiriiri mulye inyama zaakyo lwolwo lusiku. Hatanagire inyama yo mugalaaza. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Yizi maaja zaani zooshi, mukwaniini mukizi zisimbaha. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Mwe Bahisiraheeri, ngayiyerekana mu kati kiinyu kwo ndi Rurema mweru. Nie Nahano, nie mu mùyeruusa. Ku yukwo, mukizi simbaha iziina lyani. ");
INSERT INTO flr_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Íbikatuma nꞌgamùlyosa mu kihugo kyeꞌMiisiri, gira lyo mba Rurema winyu. Niehe, nie Nahano.» ");
INSERT INTO flr_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Umenyeese Abahisiraheeri isiku ngulu zo bagakizi kulikira. Yizo siku, mukwaniini mukizi kuumana, gira munyikumbe. Isiku zo nꞌgashungika zo zeezino: ");
INSERT INTO flr_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","«Mu ngiisi iyinga, muli isiku ndatu zo muhangwirwi ukukola mwo. Haliko, ulusiku lwa kalinda, lwohe luli lweꞌSabaato. Yulwo lusiku, mukwaniini mukizi luluhuuka kwo, munakizi kuumana imbere lyani. Yulwo lusiku lweꞌSabaato, muleke ukukizi lukola kwo. Haliko, mukizi lundaluulira, ngiisi ho mugaaba mutuuziri. ");
INSERT INTO flr_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","«Hali neꞌzindi siku ngulu za Nahano zo mukwaniini ukukizi kuumana kwo, munakizi menyeesa ikyanya zigakizi koleka kwo. ");
INSERT INTO flr_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","«Ulusiku lukulu lweꞌPasaka, mukizi lutondeera kabigingwe koꞌlusiku lwiꞌkumi na zina, zoꞌmwezi gwa mbere. ");
INSERT INTO flr_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","«Ubugaakya bwalwo, ku lusiku lwiꞌkumi na zitaanu za gwogwo mwezi, mugatondeera ukunjambaalira isiku ngulu zeꞌmikate mizira saama, munahise isiku zirinda mugweti mugaagilya. ");
INSERT INTO flr_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Yiryo iyinga, ulusiku lwa mbere, ube noꞌmuhumaanano mutaluule. Ku yulwo lusiku, hatagirage umukolwa gwo mugaagira. ");
INSERT INTO flr_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ngiisi lusiku lwa mu yiryo iyinga, mugakizi ndangira ituulo lyoꞌkusiriiza lwoshi. Na ku lusiku lwa kalinda, munashubi kuumana hiꞌgulu lyani. Yulwo lusiku, mutakolwe mbu mukizi lukola kwo.» ");
INSERT INTO flr_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","kwo amenyeese Abahisiraheeri kwokuno: «Ikihugo kyo ngamùheereza, ikyanya mugakiyingira mwo, mugatondeera ukuyimbula. Ikyanya mugatomola, umubega gwa mbere, mukwaniini mugutwalire umugingi. ");
INSERT INTO flr_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Uyo mugingi agagulengeza imbere lyani mu kugundangira, ulusiku úlugakulikira lweꞌSabaato, gira ndonge ukumùyemeera. ");
INSERT INTO flr_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","«Ku lwolwo lusiku, mukwaniini ukunziriigiza ituulo lyeꞌkyanabuzi. Yikyo kyanabuzi, kibe kizira kashembo, kinabe kikola noꞌmwaka. ");
INSERT INTO flr_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Kuguma na yibyo, munandangire niꞌtuulo lyeꞌbilo bibiri byoꞌmushyano mulembu, gunabe mufushe mwaꞌmavuta. Yugwo mushyano, ikyanya mugagusiriiza, umushiiriri gwagwo guganzimiisa. Mugatanga niꞌtuulo lyeꞌlitiri lyeꞌdivaayi. ");
INSERT INTO flr_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Yugwo mubega, ikyanya mutazi gundeetera ngiꞌtuulo, mutahangwirwi ukulya ku mwimbu gwinyu, guba mubishi, kandi iri mukalange, kandi iri mukate muyokye. Luno lubaaja, mukwiriiri mukizi lusimbaha, ngiisi ho mugaaba mutuuziri. ");
INSERT INTO flr_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","«Galya matuulo goꞌmubega gwa mbere, ukulyokera ku Sabaato yo mukagatanga kwo mu kugalengeza, muharuure amayinga galinda hungu-hungu. ");
INSERT INTO flr_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Ku siku makumi gataanu, ulusiku úlugakulikira lweꞌSabaato ya kalinda, lwo lusiku mugashubi ndangira itomola lyeꞌngano mbyahya. ");
INSERT INTO flr_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Ku yulwo lusiku, ngiisi mbaga igayiji ndangira imikate ibiri mu kugilengeza imbere lyani. Ngiisi mukate, gugalinganizibwa mu bilo bibiri byoꞌmushyano mulembu, gunabe mufushe mweꞌsaama. Yiryo ituulo, mugalinjaagiza mu matomola giinyu geꞌngano. ");
INSERT INTO flr_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","«Lirya ituulo lyeꞌmikate, mulitange kuguma neꞌshuuli nguma, neꞌbipanga bibiri, neꞌbyanabuzi birinda bizira kashembo, binabe byoꞌmwaka muguma. Yibyo bitugwa, mubindangire libe ituulo lyoꞌkusiriiza lwoshi, kuguma naꞌmatuulo goꞌmushyano, na geꞌkinywebwa. Umushiiriri gwago, guganzimiisa ngana-ngana. ");
INSERT INTO flr_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","«Mugashubi tanga neꞌkihebe kiguma libe ituulo lyoꞌkukogwa ibyaha. Munatange neꞌbipanga bibiri byoꞌmwaka muguma, libe ituulo lyoꞌkuyerekana ingoome. ");
INSERT INTO flr_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Birya byanabuzi bibiri, umugingi agabilengeza imbere lya Nahano, kuguma neꞌrya mikate, mu kuyerekana itomola lyeꞌmimbu yinyu. Yago matuulo, bwo gali mataluule, gagaaba naaho gaꞌbagingi. ");
INSERT INTO flr_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","«Ku lwolwo lusiku, mugakuumana imbere lyani, hatagirage úgalukola kwo. Yulwo lubaaja, mukwiriiri mukizi lusimbaha, mu bibusi biinyu byoshi, ngiisi ho mugaaba mushumbisiri. ");
INSERT INTO flr_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","«Ikyanya mugakizi yimbula, mutakizi hererekeza. Mutanakizi shubi galukira inyuma, mbu mukuumanie imisigala. Si iyo misigala, mugakizi gisigira abakeni neꞌbinyamahanga byo mutuliinwi. Nie Nahano Rurema winyu.» ");
INSERT INTO flr_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","kwo amenyeese Abahisiraheeri kwokuno: «Ulusiku lwa mbere lwoꞌmwezi gwa kalinda, mugakizi luhuuka. Mugakizi lukengeezania mu kulasa ikibuga, gira muyiji kuumana hiꞌgulu lyani. ");
INSERT INTO flr_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Ku yulwo lusiku, hatagirage úgaakola. Si mugandangira amatuulo goꞌkusiriiza.» ");
INSERT INTO flr_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Nahano anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Mu siku ikumi za gwogwo mwezi gwa kalinda, mugakuumana hiꞌgulu lyani, iri munayishalisa, munandangire ituulo lyoꞌkusiriiza. ");
INSERT INTO flr_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","«Ku lwolwo lusiku, hatagirage umukolwa gwo mugaagira. Mukuba, luli lusiku lwoꞌkuyiyeruusa, halinde munabe mukoli kwaniini imbere lyani. Nie Rurema Nahamwinyu. ");
INSERT INTO flr_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","«Ku yulwo lusiku, ngiisi útagayishalisa, akwiriiri atwibwe lwoshi mu Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","31","Yulwo lusiku, ngiisi úgaagira mbu alukole kwo, nienyene ngayami múyita mu Bahisiraheeri. Yulwo lusiku, hatagirage úgalukola kwo. Luno lubaaja, mukwiriiri mukizi lusimbaha, mu bibusi biinyu byoshi, ngiisi ho mugaaba mutuuziri. ");
INSERT INTO flr_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Yulwo lusiku, mugaluluhuuka kwo nga kwo muli mu luhuuka ku lweꞌSabaato. Haliko, ku yulwo lusiku, muyishalise. Mugakizi lutondeera kabigingwe, mu siku mwenda za gwogwo mwezi, halinde kabigingwe ka úbugaakya.» ");
INSERT INTO flr_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","kwo amenyeese Abahisiraheeri kwokuno: «Ukulyokera ku lusiku lwiꞌkumi na zitaanu za gwogwo mwezi gwa kalinda, mugakizi hisa isiku zirinda mugweti muganjambaalira ulusiku lukulu lweꞌbitunda. ");
INSERT INTO flr_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","«Ulusiku lwa mbere, mugakuumana hiꞌgulu lyani, hatanagire byo mugaakola. ");
INSERT INTO flr_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Ngiisi lusiku lwa mu yiryo iyinga, mugakizi ndangira ituulo lyoꞌkusiriiza. Ku lusiku lwoꞌmunaana, mugashubi kuumana hiꞌgulu lyani, munashubi ndangira irindi ituulo lyoꞌkusiriiza. Ee! Yulwo lusiku luli lutaluule, hatanagire byo mugalukola kwo. ");
INSERT INTO flr_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","«Yizo siku, zo siku ngulu zo Nahano akabiika. Mukizi zikuumana kwo ngiisi mwaka, iri munakizi ndangira amatuulo goꞌkusiriiza lwoshi. Mugakizi ndangira ibitugwa, naꞌmatuulo geꞌmushyano, naꞌmatuulo geꞌdivaayi, ngiisi ituulo ku lusiku lwalyo. ");
INSERT INTO flr_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Yago matuulo, gali mu yushuulwa ku galya go muli mu ndangira ulusiku lweꞌSabaato, naꞌmatuulo go muli mu ndangira mu kukwiza byo mukandagaania, kiri naꞌgandi go muloziizi ukundangira. ");
INSERT INTO flr_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","«Kwokwo, yizo siku ngulu zeꞌbitunda, mukengeere kwo ziri mu tondeera ulusiku lwiꞌkumi na zitaanu zoꞌmwezi gwa kalinda, ku kyanya mwayusa ukuyimbula. Mukwaniini mukizi njambaalira isiku zirinda. Ulusiku lwa mbere na lwoꞌmunaana, zo siku zoꞌkuluhuuka kwo. ");
INSERT INTO flr_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","«Ku lusiku lwa mbere, mugakuumana naꞌmatavi geꞌbiti byeꞌbigazi, naꞌmatavi ágali neꞌbihunda bingi, naꞌgandi matavi geꞌbiti íbiri mu mera ha butambi lyoꞌlwiji. Ha nyuma, munakizi hisa isiku zirinda mugweti mugashambaala bweneene imbere lyani. ");
INSERT INTO flr_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Yizo siku ngulu, mugakizi zinjambaalira kwo ngiisi mwaka. Zigakizi mala iyinga lyoshi, mu mwezi gwa kalinda. Luno lubaaja, mukwiriiri mukizi lusimbaha. ");
INSERT INTO flr_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","E Bahisiraheeri, mweshi mugakizi hisa isiku zirinda mushumbisiri mu bitunda, ");
INSERT INTO flr_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","gira lyeꞌbibusi biinyu bimenye kwo nꞌgalyosa bashokuluza biinyu mu kihugo kyeꞌMiisiri, nanabashumbikiisa mu bitunda. Nie Nahano Rurema winyu.» ");
INSERT INTO flr_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Kwokwo, kwo Musa akamenyeesa Abahisiraheeri hiꞌgulu lyeꞌsiku ngulu zo Nahano akakyula za mu ngiisi mwaka. ");
INSERT INTO flr_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","kwo amenyeese Abahisiraheeri kwokuno: «Mundeetere amavuta miija geꞌmizehituuni, gira amatara gakizi yama gayasiri. ");
INSERT INTO flr_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Yago matara, gabiikwe mwiꞌheema lyeꞌmihumaanano, imbere lyoꞌmulondo gwoꞌkusiika Akajumba keꞌKihango. Harooni agakizi gayasa imbere lyani, ukulyokera kabigingwe halinde shesheezi. Yulwo lubaaja, lugayama lusimbahirwi halinde mu bibusi byoshi. ");
INSERT INTO flr_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Yago matara, gagaterekwa ku kiterekero íkikatulwa mu nooro muguuhya. Harooni akwaniini akizi gayasa imbere lyani ngiisi bushigi. ");
INSERT INTO flr_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Uyabiire umushyano mulembu, unaguyokye mweꞌbitumbula ikumi na bibiri. Na ngiisi kiguma kigirwe mu bihande bibiri-bibiri byeꞌheefa. ");
INSERT INTO flr_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Iyo mikate, ukizi gilambika ku kashasha keꞌnooro muguuhya. Ugitengeke mweꞌmiziizi ibiri, mikate ndatu-ndatu ku ngiisi muziizi. ");
INSERT INTO flr_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Na ku ngiisi muziizi, ukizi biika umubadu muguuhya, unagunyokere, ho mwanganyokera umukate, mu kukizi ngengeera. ");
INSERT INTO flr_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","«Iyo mikate, ngiisi lusiku lweꞌSabaato, Harooni agakizi gitengeka imbere lya Nahano. Kwokwo, lyaꞌBahisiraheeri bakizi yama bali mu kengeera ikihango. ");
INSERT INTO flr_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Iyo mikate, Harooni naꞌbandu beꞌkibusi kyage naaho bo bahangwirwi ukukizi gilya, banagiliire áhataluule. Mukuba, iyo mikate yonyene, iri mitaluule imwani. Iyo mikate, ngabaheereza yo, kwo ikizi ba yeꞌmwabo halinde imyaka neꞌmyakuula.» ");
INSERT INTO flr_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Lusiku luguma mu shumbi, hanaba imbamba ha kati kaꞌBahisiraheeri babiri. Muguma wabo, yishe âli riiri Mumiisiri, haliko nyina âli Muhisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Uyo maawe, iziina lyage Selomiti, munyere Dibiri wa mu mulala gwa Daani. Yugwo musore, gwanatondeera ukutuka Rurema. Kyanatuma abandu bagagutwala imunda Musa, ");
INSERT INTO flr_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","banagubiika mu mbohe, mu kulindirira Nahano yenyene abayereke ngiisi kwo bagagugira. ");
INSERT INTO flr_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Iri hakatama, Nahano anabwira Musa: ");
INSERT INTO flr_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Yugwo musore, uguhuluse inyuma lyeꞌshumbi. Balya booshi ábakayuvwa ngiisi kwo agweti agadaaka iziina lyani, balambikage amaboko gaabo kwiꞌtwe lyage. Ha nyuma, Abahisiraheeri booshi, bamúyite mu kumúlasha amabuye. ");
INSERT INTO flr_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","«Yabo Bahisiraheeri, ubamenyeese ulubaaja kwokuno: “Ngiisi úgadaaka Rurema wabo, agaahanwa ngana. ");
INSERT INTO flr_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Ee! Ngiisi úgatuka Nahano, akwiriiri ayitwe. Abahisiraheeri booshi bagamúyita, mu kumúlasha amabuye, aba mutuulaga, kandi iri kinyamahanga. Ndaakwo kundi! Ngiisi úgagayiriza iziina lya Rurema, agayitwa. ");
INSERT INTO flr_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","«“Ngiisi úgayita uwabo, akwiriiri naye ayitwe. ");
INSERT INTO flr_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Neꞌri angayita ikitugwa kyoꞌwabo, akwiriiri akigomboole neꞌkindi. ");
INSERT INTO flr_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","«“Umundu, iri angakomeresania, akwiriiri naye akomeresibwe mwene lwolwo luguma: ");
INSERT INTO flr_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ivuha kwiꞌvuha, niꞌsu kwiꞌsu, neꞌliino ku liino. Ngiisi buligo bwoꞌmundu agakolera uwabo, naye agabugalulirwa. ");
INSERT INTO flr_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","«“Ngiisi úgayita ikitugwa, akwiriiri akigomboole. Halikago, ngiisi úgayita uwabo, yehe akwiriiri ayitwe. ");
INSERT INTO flr_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","«“Yulwo lubaaja, lugakizi lola Abahisiraheeri nirizina, kiri neꞌbinyamahanga byo mutuliinwi. Nie Nahano Rurema winyu.”» ");
INSERT INTO flr_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Iri Musa akayusa ukudeta kwokwo, ulya mundu úkadaaka Nahano, banamútwala inyuma lyeꞌshumbi, banamúyitiisa mu kumúvurumika amabuye. Kwokwo, kwo bakagira, nga ngiisi kwo Nahano akabwira Musa. ");
INSERT INTO flr_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Ikyanya Musa âli riiri ku mugazi Sinaayi, Nahano anamúbwira, ");
INSERT INTO flr_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","kwo amenyeese Abahisiraheeri kwokuno: «Kirya kihugo kyo ngamùheereza, ikyanya mugaaba keera mwakiyingira mwo, mugakizi kileka kiluhuuke. Kwokwo, kwo mugakizi nzimbahiisa. ");
INSERT INTO flr_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Mugakizi hisa imyaka ndatu, mugweti mugabyala imbuto mu ndalo. Ku yikyo kyanya, munakizi hahuulira imizabibu yinyu, iri munakizi yimbula. ");
INSERT INTO flr_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","«Halikago, umwaka gwa kalinda gwohe, indalo zikwaniini ziluhuuke. Yugwo mwaka, gwataluulwa gube gweꞌSabaato imwani. Hatagirage kindu kyo mugabyala, mutanakizi hahuulira imizabibu yinyu. ");
INSERT INTO flr_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Ha nyuma lyoꞌmwimbu muzinda, ikisimbwe kyoshi, mutakiyimbule. Na kundu imihuli yeꞌmizabibu igaaba yayera ku yikyo kyanya, hatagirage úgagidootola. Si yugwo mwaka, gugaaba gwa kuluhuusa idaho. ");
INSERT INTO flr_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","«Kundu kwokwo, yugwo mwaka, mugakizi lya ngiisi biꞌdaho lyameza. Mugakizi birya, mwe naꞌbaja biinyu, naꞌbaja-kazi, naꞌbakozi bo muli mu hemba, kiri neꞌbinyamahanga byo mutuliinwi. ");
INSERT INTO flr_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Yutwo tumereera, kiri neꞌbitugwa biinyu bigakizi tulya, kuguma neꞌnyamiishwa kwakundi. ");
INSERT INTO flr_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","«Iyo myaka yoꞌkuluhuuka, mugakizi giharuura ubugira kalinda, kuli kudeta imyaka makumi gana na mwenda. ");
INSERT INTO flr_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Kwokwo, mu siku ikumi zoꞌmwezi gwa kalinda, mugadihiriza ikibuga mu kihugo kyoshi. Yulwo lusiku, lwo lugaaba lusiku luhamu lwoꞌkuyiyeruusa. ");
INSERT INTO flr_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","«Umwaka gwa makumi gataanu, mukizi gutaluula imwani. Munamenyeese kwaꞌbaja booshi ba mu kihugo bashwekuulwe. Yugwo mwaka, gugaaba gwoꞌbushambaale. Ngiisi muguma winyu, agagalukira mu matongo ga bashokuluza baage, gira ashubi gatuula mwo. ");
INSERT INTO flr_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","«Yugwo mwaka gwa makumi gataanu, mugakizi gushambaalira. Ee! Gube gwoꞌbushambaale. Ku yugwo mwaka, mutakizi ki byala imbuto. Na kundu imbuto igaaba yamera yonyene, mutagendi giyimbula. Kiri neꞌmizabibu, yo mutahahuulira, mutadootole imihuli yayo. ");
INSERT INTO flr_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Yugwo mwaka, guli gwoꞌbushambaale, munakwaniini mukizi gutaluula imwa Rurema. Ibyokulya biinyu, mugakizi lya naaho íbyamera byonyene mu ndalo. ");
INSERT INTO flr_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","«Yugwo mwaka gwoꞌBushambaale, ngiisi muguma winyu agagalukira amatongo ga bashokuluza baage, anagahyane. ");
INSERT INTO flr_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Iri wangagulira uwinyu itongo, kandi iri wamúguliikiza lyo, utamúgunge. ");
INSERT INTO flr_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Iri wangaligula, ikishingo kigakulikirana neꞌmyaka íkalenga, ukushaagira ku mwaka muzinda gwoꞌmwaka gwoꞌBushambaale. Kigakulikira kwakundi imyaka yoꞌmwimbu íyasigala ukuhikira ku gundi mwaka gwoꞌBushambaale. ");
INSERT INTO flr_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","«Imyaka íki sigiiri, iri yangaluguuka, ikishingo nakyo kinayushuuke. Kandi iri iyo myaka, iri yanganiiha, ikishingo nakyo kinaniihe. Kwokwo, mu kuguliisa, ikishingo kigakulikirana noꞌmuharuuro gweꞌmimbu ígaguliisibwa. ");
INSERT INTO flr_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","«Mutakizi gungana. Haliko, mukizi nyoboha, nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Iri mwangaba muloziizi ukutuula ku butoge, mukizi simbaha imaaja zaani, munakizi kulikiriza ngiisi kwo namùtegeka. ");
INSERT INTO flr_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Haaho, lyeꞌdaho igaameza imimbu ngana-ngana, munakizi lya, munayigute, munatuule buzira mbuzi-mbuzi. ");
INSERT INTO flr_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","«Hali ikyanya mwangakizi yibuuza: “Aaho! Mu mwaka gwa kalinda, bikagi byo tugaalya, tutanaki hangwirwi ukubyala kandi iri kuyimbula?” ");
INSERT INTO flr_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Yuvwagwi! Mu mwaka gwa kalindatu, ngamùgashaanira bweneene, halinde ikihugo kinatange imimbu ígamùhisa ku myaka ishatu. ");
INSERT INTO flr_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Mu mwaka gwoꞌmunaana, ikyanya mugaaba mukiri mu byala imbuto ziinyu, mugaaba muki gweti mugaalya irya mimbu yoꞌmwaka gwa kalindatu. Kiri na mu mwaka gwoꞌmwenda, mugaaba mukiri mu lya gwogwo mwimbu gwoꞌmwaka gwa kalindatu. ");
INSERT INTO flr_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","«Mutakolwe kwo mwakizi guliisa amatongo lwoshi. Si amatongo gooshi, gali geꞌmwani. Muli nga binyamahanga naaho, munakoli shumbisiri mu kihugo ku kyanya kiniini. ");
INSERT INTO flr_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Kyo kitumiri, ikyanya mugakizi gula amatongo, mukwaniini mukizi biika imaaja kweꞌkyanya umundu agagaguliisa, alonge ubulyo bwoꞌkushubi gagula. ");
INSERT INTO flr_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","«Tudete ngoꞌwinyu Muhisiraheeri angakena, anaguliise itongo lyage liguma. Haaho, mwene wabo wa hoofi akwaniini aliguluule. ");
INSERT INTO flr_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ulya mukeni, kundu angaba atahiiti mwene wabo woꞌkuliguluula, halikago, hali ikyanya yenyene angayiji longa ubulyo bwoꞌkuliguluula. ");
INSERT INTO flr_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Kwokwo, ahangwirwi kwo aliguluule. Mu kuliguluula, agatee haruura ibindu byeꞌmyaka keera íyalenga ukulyokera ho akaliguliikiza. Na byo agagalulira uwabo, bikwiriiri bihwanwe neꞌmyaka íkoli sigiiri ukuhisa ku mwaka gwoꞌBushambaale. Kwokwo yiryo itongo, linashubi galukira nalyo. ");
INSERT INTO flr_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","«Haliko, iri atangashobola ukuliguluula, ligasigala mu maboko goꞌlya úkaligula, halinde ukuhisa ku gundi mwaka gwoꞌBushambaale. Ku yugwo gundi mwaka, yiryo itongo ligalulirwe ulya mundu úkaliguliisa. ");
INSERT INTO flr_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","«Tudete ngoꞌmundu angaguliisa inyumba yage íri mu kaaya kazitire. Uyo mundu, iri angagiguluula, kube naaho ku mwaka muguma ukulyokera ikyanya akagiguliisa. ");
INSERT INTO flr_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Haliko, iyo nyumba, nga itangaguluulwa mu yugwo mwaka muguma, igayama iri yoꞌyo úwagigula. Kiri mu mwaka gwoꞌBushambaale, batâye gigalule. ");
INSERT INTO flr_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","«Haliko, inyumba za mu bishoola, bwo zitali nzitire, zoohe, zigaaba ngaꞌmatongo. Yizo nyumba, zangagomboolwa ku ngiisi kyanya. Na mu mwaka gwoꞌBushambaale, zikwiriiri zigalulirwe beene zo. ");
INSERT INTO flr_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","«Kuguma na yibyo, Abalaawi boohe, inyumba íziri mu twaya twabo, bahangwirwi ukuziguluula ku kyanya kyoshi. ");
INSERT INTO flr_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Na kwakundi, kundu umundu angaba akagula nguma yazo, haliko mu mwaka gwoꞌBushambaale, iyo nyumba ikwiriiri igalukire mwene yo. Mukuba, mu Bahisiraheeri, abagingi bagweti zeezo nyumba naaho mu twaya two batuuziri mwo. ");
INSERT INTO flr_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Amatongo ágazungulusiri utwaya twabo, gatakwiriiri kwo gaguliisibwe. Yago matongo, gagayama buli buhyane bwabo. ");
INSERT INTO flr_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","«Uwinyu Muhisiraheeri, iri angakena, anabe atashobwiri ukuyitabaala, ukwiriiri ukizi mútabaala, nga kwo wangatabaala ikinyamahanga, kandi iri mubalama úshumbisiri mu kihugo kiinyu. ");
INSERT INTO flr_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Uyo mukeni, utakolwe mbu wamúyungukira kwo. Haliko, ukizi yerekana kwo unzimbahiri, mu kumúhanguula kwo mutuulanwe. ");
INSERT INTO flr_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","«Ikyanya wamúkaaba ifwaranga, utasare mbu akizi kuyungula. Ikyanya wamúheereza ibyokulya, utasare kwo angakuyungula. ");
INSERT INTO flr_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nie nꞌgamùlyosa mu kihugo kyeꞌMiisiri, nanamùheereza ikihugo kyeꞌKaanani, gira lyo mba Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","«Uwinyu Muhisiraheeri, iri angakekerera, anayiji yiguliisa imwawe, utakolwe kwo wakizi múkoleesa ku kahaati nga muja. ");
INSERT INTO flr_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Haliko, umúyabiire nga mukozi woꞌkuhembwa, kandi iri nga mubalama útuuziri mu mwawe. Agakizi kukolera naaho, halinde ku mwaka gwoꞌBushambaale. ");
INSERT INTO flr_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","«Uyo winyu, ku yugwo mwaka, umúbwire kwo angataaha, naꞌbaana baage. Anagalukire mu mbaga yage, anagendi hyana itongo lya bashokuluza baage. ");
INSERT INTO flr_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Abahisiraheeri, nie kabalyosa mu kihugo kyeꞌMiisiri, banali bakozi baani. Ku yukwo, batakwiriiri bakizi guliisibwa, nga kwo bali mu guliisa abaja. ");
INSERT INTO flr_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Utakizi bakoleesa ku kahaati. Haliko, ukizi nzimbaha. ");
INSERT INTO flr_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","«Iri wangalooza abaja, kandi iri baja-kazi, ugendi bagulira mu mahanga. ");
INSERT INTO flr_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Wangabagulira kiri na mu baana beꞌbinyamahanga bo mutuliinwi, kiri naꞌba mu makondo gaabo. Yabo booki, bangaba bindu byawe. ");
INSERT INTO flr_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","«Yabo baja, mugayiji basigira abaana biinyu, gira bakayame bali buhyane bwabo. Yabo, ugayama ubalaaziri nga baja baawe. Si abiinyu Bahisiraheeri, nanga! Hatagirage kiri noꞌmuguma, ye mugakizi koleesa nga muja. ");
INSERT INTO flr_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","«Tudete ngeꞌkinyamahanga kyangayiji mùgalira mwo, kandi iri mubalama. Uwinyu Muhisiraheeri, anakene, anagendi yiguliisa imwa yikyo kinyamahanga, kandi iri imwoꞌmundu weꞌmbaga yage. ");
INSERT INTO flr_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Kundu uyo uwinyu angaba keera ayiguliisa, haliko angaki guluulwa. ");
INSERT INTO flr_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Angashubi guluulwa na mwizo wage, kandi iri muvyala wage, kandi iri mwene wabo wa hoofi-hoofi. «Uyo mundu, iri angaba ali noꞌbushobozi, angashubi yiguluula kiri na yenyene. ");
INSERT INTO flr_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Akwaniini aheereze sheebuja ifwaranga ízisigiiri ukukulikirana noꞌmukolwa gwo angagira halinde ukuhisa ku mwaka gwoꞌBushambaale. ");
INSERT INTO flr_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Umuharuuro gweꞌmyaka isigiiri halinde ukuhisa ku mwaka gwoꞌBushambaale, iri gwangaluguuka, agagalula ikimaanye íkiri tiita kyeꞌkishingo kyo akagulwa. ");
INSERT INTO flr_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Halikago, iyo myaka ísigiiri, iri yangaba iri miniini, anamúlihe ifwaranga niini, ukukulikirana neꞌyo myaka. ");
INSERT INTO flr_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","«Yabo ábakoli ba bakozi, yikyo kinyamahanga kikwaniini kikizi bakoleesa nga mukozi woꞌkuhembwa. Mutaleke ikinyamahanga kwo kikizi koleesa uwinyu Muhisiraheeri ku kahaati. ");
INSERT INTO flr_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","«Yugwo mwaka gwoꞌBushambaale, iri gwangahika, hanabe hali Umuhisiraheeri útazi guluulwa, akwiriiri ahaabwe ubushwekuule, naꞌbaana baage. ");
INSERT INTO flr_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","«Nie kalyosa Abahisiraheeri mu kihugo kyeꞌMiisiri. Bali bandu baani, banali bakozi baani. Nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","«Mutayigirire imigisi. Mutanayiterekere imigisi hiꞌgulu lyoꞌkukengeera imizimu. Hatagirage imigisi yo mugakizi yikumba. Nie Nahano Rurema winyu. ");
INSERT INTO flr_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","«Mukizi simbaha ulusiku lweꞌSabaato, munakizi heereza Ahandu haani Heeru ulushaagwa. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Nga mwangakizi kulikira imaaja zaani, munakizi zisimbaha, ");
INSERT INTO flr_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ngamùniekeza invula ku kyanya íkikwaniini, halinde ikihugo kilonge ukuyera bweneene. Kiri neꞌbiti binatongeke. ");
INSERT INTO flr_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","«Ikyanya muli mu gesha ingano, kigagenderera, halinde ku kyanya kyoꞌkuyimbula imizabibu. Neꞌkyanya kyoꞌkuyimbula imizabibu kinagenderere, halinde ku kyanya kyoꞌkushubi byala imbuto. Mugakizi longa ibyokulya bya namwingye, munatuule mu kati koꞌbutoge. ");
INSERT INTO flr_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","«Ngamùleetera umutuula, munakizi gwejera buzira kuyikanga-kanga. Ninamùyimulire inyamiishwa ndangi. Kiri naꞌbagoma, batagakizi yiji mùteera. ");
INSERT INTO flr_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Yabo bagoma biinyu, mugakizi bayimula, munabaminike ku ngooti. ");
INSERT INTO flr_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Kundu abagoma bangaba bali igana, haliko Abahisiraheeri bataanu naaho, bagabatibita kwo. Neꞌri abagoma bangaba bali bihumbi ikumi, Abahisiraheeri igana naaho, bagabatibita kwo. Yabo bagoma, mugabaminika ku ngooti. ");
INSERT INTO flr_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","«Ngakizi mùkejeerera, na ngizi mùgashaanira, halinde mulonge abaana bingi. Kirya kihango kyo nꞌganywana na niinyu, ngakizi kikwiza. ");
INSERT INTO flr_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Mugayeza ngana-ngana, ukuhisa ku kyanya mugaaba muki gweti mugaalya imimbu ya kare. Mugahikiira ukushaaza byo mukasingula kare, gira lyo mulonga ho mugalangira imimbu mihyahya. ");
INSERT INTO flr_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","«Ngayiji shumbika mu kati kiinyu, ndanâye mùheereze ingoto. ");
INSERT INTO flr_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ngakizi mùzaatira-zaatira. Nie ngaaba Rurema winyu. Niinyu munabe bandu baani. ");
INSERT INTO flr_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nie Nahano Rurema winyu. Nie nꞌgamùlyosa mu kihugo kyeꞌMiisiri, gira mutaki be baja. Kundu bâli kizi mùyambika ibyuma mu magosi, haliko keera nꞌgabitwisa, mwanalonga ukukizi genda muganooka-nooka. ");
INSERT INTO flr_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Halikago, hali ikyanya mutagandega amatwiri. Yizi maaja zooshi, munabe mutaki zikulikiiri. ");
INSERT INTO flr_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Munabe mukola mu hongola ikihango kyani, mu kugayiriza imaaja zaani, munashombe byo namùtegeka. ");
INSERT INTO flr_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","«Aaho! Yuvwagwi ngiisi kwo ngamùhaniiriza: Ngakizi mùleetera amalibu. Neꞌkyanya mugashuushirwa, amasu giinyu gagahumaala, halinde munajambe ngana-ngana. Kundu mugakizi byala imbuto mu ndalo, zitagamùgenduukira. Mukuba abagoma biinyu, bo bagakizi zirya. ");
INSERT INTO flr_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Nienyene, ngamùhana, halinde abagoma biinyu bagakizi mùhima. Na kundu abagoma biinyu bamùshombiri, haliko bo bagakizi mùtwala. Munayami tibita, kiri na ku kyanya ndaaye úmùyimwiri. ");
INSERT INTO flr_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Na kundu mugaaba keera mwahanwa, si mugaaba mukiri banduuvwa. Hiꞌgulu lyeꞌbyaha biinyu, ngamùyushuulira ikihano ubugira kalinda. ");
INSERT INTO flr_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Kundu mugaaba mukiri mu yikangaata, haliko ngamùhaniiriza. Ngahangika invula, mu kugira igulu libe likomu nga kyuma. Neꞌkihugo kiinyu, mu kubula invula, kigayumaguka nga miringa. ");
INSERT INTO flr_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Mugakizi yitubanula ku busha. Indalo ziinyu zitagayera ihiteerwa ku shinda. Kiri neꞌbiti, bitagatongeka. ");
INSERT INTO flr_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«Ha nyuma, iri mwangagenderera ukumbigiiriza, iri munabihuuka imbere lyani, ngashubi mùyushuulira ikihano ubugira kalinda. ");
INSERT INTO flr_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ngahamuliza inyamiishwa ndangi mu kati kiinyu, zinalye abaana biinyu, zinasivye neꞌbitugwa biinyu. Emwe! Umuharuuro gwinyu, gugakizi niiha, halinde injira ziinyu zinashake. ");
INSERT INTO flr_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Iri mwangalonga yibyo bihano, munabe muki genderiiri ukumbaga, ");
INSERT INTO flr_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","bwo mugaaba muki gweti mugayifunda mu byaha, ngashubi mùhaniiriza ubugira kandi kalinda. ");
INSERT INTO flr_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Na ku bwenge mugaaba muhongwiri ikihango kyani, ngamùtibulira mwiꞌzibo. Na kundu mwangagira mbu mugendi yibisha mu twaya, haliko ngamùmwagulira mweꞌkiija, gira mumale, munabiikwe mu maboko gaꞌbagoma biinyu. ");
INSERT INTO flr_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","«Ngamùyima ibyokulya. Abakazi ikumi, bagakizi koleesa ikiyokero kiguma naaho, mu kuyokya imikate. Na mu kumùhakira, bagakizi mùheereza utukoojoka tuniniini. Kwokwo, kundu mugakizi lya, halikago mutagayuvwa kwo mwashaluuka. ");
INSERT INTO flr_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Iri mwangalonga yibyo bihano, munabe muki genderiiri ukundahira, ");
INSERT INTO flr_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ngashubi mùhana kandi ku buraakari bwani. Bwo mugaaba muki gweti mugaagira ibyaha, ngashubi mùhaniiriza ubugira kalinda. ");
INSERT INTO flr_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Mugahikiira ukulya abaana bo muyibutira. ");
INSERT INTO flr_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Bwo ngaaba ngoli mùjinikiiri, ngamùsheregeza ho mugweti mugayikumbira imizimu. Kiri noꞌtutanda two muli mu giyokera kwoꞌmubadu, ngatuhongola. Ibirunda biinyu, ngabilasha ku migisi yinyu ífwiri namunyogo. ");
INSERT INTO flr_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","«Utwaya twinyu tuhamu, ngatujigiivya. Na ho mugweti mugayikumbira imigisi, ngahahindula libe ishamba. Na kundu mugakizi ndangira amatuulo goꞌkusiriiza, imishiiriri yago itaganzimiisa. ");
INSERT INTO flr_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ngasivya ikihugo kiinyu ngana-ngana. Ikyanya abagoma bagayiji kituula mwo, bagahuumirwa. ");
INSERT INTO flr_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Ngamùshabulira mu mahanga. Na nyiji mùminika ku ngooti. Utwaya twinyu, tugahongolwa, halinde ikihugo kiinyu, kinasigale kimaata. ");
INSERT INTO flr_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","«Noꞌbuzinda, mugaaba mukola mu maboko gaꞌbagoma biinyu. Haaho, lyeꞌkihugo kiinyu kigaaba kikola kimaata, kinabe kikoli luhuusiri. Lyoki, lyeꞌkihugo kiinyu kigaluhuuka, kinalongage isiku zaakyo zeꞌSabaato. ");
INSERT INTO flr_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ku kyanya kigaaba kikola kimaata, lyo kigalonga ukuluhuuka, halinde lyo kigomboola birya byanya byoshi byo kishuba kigaluhuuka, ku kyanya mwâli ki tuuziri mwo. ");
INSERT INTO flr_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«Mu kati kiinyu, ngiisi ábagaaba bakiri kitwe-kibona mu bihugo byaꞌbagoma biinyu, ngababiika mwoꞌlushunguti. Kiri neꞌhyasi íhigaaba higweti higayehuulwa neꞌmbuusi, higayami bakanga. Bagatibita ngoꞌmundu úgweti úgatibita indwani. Na kundu ndaaye úbayimwiri, haliko bagakizi gwa. ");
INSERT INTO flr_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Kundu ndaaye úmùyimwiri, mwenyene mugakangukana ngana-ngana, nga ábali mu kizi tibita abagoma. Munabe mutaki shobwiri ukugagika naꞌbagoma biinyu. ");
INSERT INTO flr_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","«Na mu kuheza, mugafwira yeyo munda mu mahanga, munaziikwe mu bagoma biinyu. ");
INSERT INTO flr_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Iyo munda i mahanga, ngiisi ábagasigala yo, bagarohokera yo ngana-ngana. Yibyo byoshi, bigaaba hiꞌgulu lyeꞌbyaha biinyu, kiri na hiꞌgulu lyeꞌbyaha bya bashokuluza biinyu. ");
INSERT INTO flr_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«Hali ikyanya abandu baani bagayiji yilega ibyaha byabo, kiri neꞌbya bashokuluza baabo. Banayemeerage kwo bakambubira bweneene, na kwo bâli kizi haasa-haasa imbere lyani. ");
INSERT INTO flr_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Hali ikyanya bagasobanukirwa na íbikatuma nꞌgabayihindulira, na mbahise i mahanga mu kihugo kyaꞌbagoma baabo. Banabe bakoli yibiisiri haashi imbere lyani, banayemeere kwo bakambubira. ");
INSERT INTO flr_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","«Haaho, ngakengeera ikihango kyo nꞌganywana na Yakobo, na Hisake, na Hiburahimu. Na njubi kengeera na kirya kihugo kyo nꞌgabalagaania. ");
INSERT INTO flr_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","«Yikyo kihugo, ikyanya kikiri kimaata, kikwaniini kishambaale nga kwo kikoli luhuusiri. Ku yikyo kyanya, bagayemeera ukuhanwa, mbu bwo bâli shombiri imaaja zaani, banalahira ukuzisimbaha. ");
INSERT INTO flr_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","«Kundu kwokwo, ku kyanya bagaaba bali iyo munda i mahanga, mu kihugo kyaꞌbagoma baabo, ndagaaba mbakabuliiri lwoshi-lwoshi. Nanga! Ndaganabashombereza, mbu mbahemukire, kandi iri mbu mbongole ikihango kyo tukanywana twe nabo. Niehe, nie Nahano Rurema wabo. ");
INSERT INTO flr_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","«Yikyo kihango, ngakizi kikengeera. Mukuba, nꞌgakinywana na bashokuluza baabo, ikyanya nꞌgabalyosa mu kihugo kyeꞌMiisiri, mu masu geꞌgindi milala, gira lyo mba Rurema wabo. Niehe, nie Nahano.» ");
INSERT INTO flr_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Yizo maaja, kuguma naꞌmategeko, naꞌmahano, yibi byoshi, Nahano akabiheereza Musa yaho ku mugazi Sinaayi. Kwokwo, kwo akabiika ingoome ha kati kaage naꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","kwo amenyeese Abahisiraheeri kwokuno: «Hali ikyanya umundu angalagaania Nahano kwo agamútangira umundu, mu kutanga ifwaranga ízikulikiriini neꞌkishingo kyoꞌyo mundu. ");
INSERT INTO flr_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Yikyo kishingo kyo kyekino: Umushosi weꞌmyaka makumi gabiri halinde ukuhisa ku myaka makumi galindatu, agagomboolwa neꞌbingorongoro makumi gataanu byeꞌharija, ukukulikirana noꞌlugero úluli mu koleesibwa Ahandu Heeru. ");
INSERT INTO flr_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ikishingo kyoꞌmukazi wa yeyo myaka, biri bingorongoro makumi gashatu. ");
INSERT INTO flr_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","«Umwana mutabana weꞌmyaka itaanu halinde ukuhisa ku makumi gabiri, agagomboolwa neꞌbingorongoro makumi gabiri. Noꞌmunyere wa yeyo myaka, agagomboolwa neꞌbingorongoro ikumi. ");
INSERT INTO flr_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","«Umwana woꞌmwezi muguma halinde ukuhisa ku myaka itaanu, umutabana agagomboolwa neꞌbingorongoro bitaanu. Noꞌmunyere, agagomboolwa neꞌbingorongoro bishatu. ");
INSERT INTO flr_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","«Umushosi weꞌmyaka ingingwe ya makumi galindatu, agagomboolwa neꞌbingorongoro ikumi na bitaanu. Noꞌmukazi, agagomboolwa neꞌbingorongoro ikumi. ");
INSERT INTO flr_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","«Halikago, iri wangaba uli mukeni, utanashobole ukuliha ifwaranga ízihuunirwi, ulya mundu ye uloziizi ukutanga, ugamútwalira umugingi. Umugingi agaagera ikishingo kyage, ukukulikirana noꞌbushobozi bwawe. ");
INSERT INTO flr_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","«Iri wangaba walagaania Nahano ikitugwa, yikyo kitugwa kigaaba kikola kitaluule, ");
INSERT INTO flr_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","utanahangwirwi kwo ukikaburanie neꞌkindi. Kuli kudeta, utangakaburania íkishishiri ku kibi, kandi iri ikibi ku kishishiri. Umundu, iri angakikaburania neꞌkindi, yibyo bitugwa byombi, bikwaniini bitangwe imwa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","«Hali ikyanya wangaba walagaania Nahano ikitugwa kyoꞌmuziro. Kundu kwokwo, ikitugwa mwene yikyo, utahangwirwi ukukitanga imwage. Kwokwo, mwene kyo agakileeta imwoꞌmugingi. ");
INSERT INTO flr_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Umugingi, anayikeeke ikishingo kyakyo, ukukulikirana nga kwo kishishiri, kandi iri kibihiiri. Ngiisi kwo agakyula, kwo na kwoshi kwokwo. ");
INSERT INTO flr_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Halikago yikyo kitugwa, iri wangalooza ukukiguluula, ukwaniini utange kyekyo kishingo kyoꞌmugingi adeta, kuguma neꞌkihande kiguma kya kataanu. ");
INSERT INTO flr_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","«Umundu, iri angataluula inyumba yage imwa Nahano, umugingi agayiji yikeeka ikishingo kyayo. Ngiisi kwo agaaba akyula, kwo bigaanaba. ");
INSERT INTO flr_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Halikago, mwene yo, iri angalooza ukugiguluula, akwaniini atangage kyekyo kishingo umugingi adeta, kuguma neꞌkihande kiguma kya kataanu kyakyo. ");
INSERT INTO flr_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","«Umundu, iri angataluula indalo yage nguma imwa Nahano, ikishingo kyayo kigaagerwa ukukulikirana noꞌbwija bweꞌmbuto ízigayimbuka mwo. Ku ngiisi bilo makumi gabiri byoꞌbulo, agakizi tanga ibingorongoro makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","«Iyo ndalo, iri yangaba yataluulwa mu mwaka gwoꞌBushambaale, ikishingo kyayo kigayumaana nga ngiisi kwoꞌmugingi agaaba akyula. ");
INSERT INTO flr_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Halikago, iri yangayiji taluulwa ha nyuma lya yugwo mwaka, umugingi agakyula ikishingo kyayo ukukulikirana neꞌmyaka ísigiiri mu kuhisa ku gundi mwaka gwoꞌBushambaale. ");
INSERT INTO flr_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Mwene yo ndalo, iri angalooza ukugiguluula ku kirya kishingo kyoꞌmugingi adeta, agayushuula ikihande kiguma kya kataanu, gira ishubi múyegukira. ");
INSERT INTO flr_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","«Halikago, iri umundu angaba ataloziizi ukugiguluula, anabe keera agiguliikiza ugundi mundu, kwokwo atahangwirwi ukushubi giguluula. ");
INSERT INTO flr_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Iyo ndalo, mu mwaka gwoꞌBushambaale, igataluulwa imwa Nahano, inabaagage bikola bindu byaꞌbagingi lwoshi. ");
INSERT INTO flr_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","«Hali ikyanya umundu angagula indalo, anagitaluule imwa Nahano. Haliko inabe itali yeꞌmwabo. ");
INSERT INTO flr_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Kwokwo, umugingi agakyula ikishingo kyayo, ukukulikirana neꞌmyaka ísigiiri ukuhisa ku mwaka gwoꞌBushambaale. Uyo mundu, agaaliha ikishingo kyayo lwolwo lusiku. Yibyo bindu, binataluulwe imwa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Halikago, mu mwaka gwoꞌBushambaale, iyo ndalo igalulirwe mwene yo, ulya úkagihyana. ");
INSERT INTO flr_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","«Ngiisi byo balagaania Nahano, ikishingo kyabyo kigagererwa ku fwaranga íziri mu kola Ahandu Heeru. Ikingorongoro kiguma kyeꞌharija kiri noꞌbuzito bweꞌgarama ikumi. ");
INSERT INTO flr_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","«Ikitugwa, íkyabutwa ubwa mbere, kikola kya Nahano. Umundu atangashubi kitaluula imwage kandi. Mukuba, ngiisi íkiri mu butwa kya mbere, kikola kya Nahano, iba nyana, kandi iri kyanahene, kandi iri kyanabuzi. ");
INSERT INTO flr_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","«Haliko, iri kyangabutwa kya mbere mu bitugwa íbiri noꞌmuziro, mwene kyo akwiriiri akiguluule mu kuyushuula ikihande kiguma kya kataanu ku kishingo umugingi agaaba akishingirira. Neꞌri atangakiguluula, umugingi ahangwirwi ukukiguliikiza ugundi ku kishingo kyo agaabona. ");
INSERT INTO flr_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","«Kundu kwokwo, iri umundu angayami taluula ikindu lwoshi imwa Nahano, aba mundu, kandi iri kitugwa, kandi iri ndalo yo akahyana, kitakwiriiri kwo kishubi guluulwa, kandi iri kiguliisibwa. Ngiisi íbyataluulwa lwoshi imwa Nahano, iri kikola kitaluule mene-mene. Kiganayama kiri kyeꞌmwa Nahano isiku zooshi. ");
INSERT INTO flr_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","«Umundu, iri angataluulwa kwo agayitwa, uyo atangaki guluulwa, si akwiriiri ayitwe naaho. ");
INSERT INTO flr_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«Mukwaniini mukizi taluulira Nahano ikihande kiguma kiꞌkumi kyeꞌmimbu, na kyeꞌbitumbwe. Kiri kyeꞌmwa Nahano, kinakwaniini kitaluulwe imwage. ");
INSERT INTO flr_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Yikyo kihande kiguma kiꞌkumi, iri wangalooza ukukiguluula, ugaaliha abagingi ikishingo kyalyo, unayushuule ikihande kiguma kya kataanu. ");
INSERT INTO flr_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","«Ku biloziri ingaavu, neꞌbibuzi, neꞌmbene, mukwaniini ukutaluula ikitugwa kiguma kwiꞌkumi, imwa Nahano. ");
INSERT INTO flr_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Mu yibyo bitugwa, mwene byo atahangwirwi ukutoola, mbu kirebe kyo kiija, kandi iri kyo kibi. Halikago, iri angagira mbu akaburanie ikitugwa neꞌkindi, yibyo byombi, bigaharuurwa nga bigataluulwa imwa Nahano. Mu yibyo byombi, ndaakyo kyo angaki guluula.» ");
INSERT INTO flr_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Yizo zo maaja Nahano akaheereza Musa ku mugazi Sinaayi, gira azimenyeese Abahisiraheeri.");
INSERT INTO flr_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ikyanya Abahisiraheeri bakahisa imyaka ibiri bashaaziri i Miisiri, bâli shumbisiri mwiꞌshamba lyeꞌSinaayi. Mu lusiku lwa mbere lwoꞌmwezi gwa kabiri, Nahano anaganuuza Musa mwiꞌheema lyeꞌmihumaanano, anamúbwira kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Mwe na Harooni, mukwiriiri muharuurage Abahisiraheeri booshi, ukukulikirana naꞌmakondo gaabo, neꞌmbaga zaabo, munayandike niꞌziina lya ngiisi mushosi. ");
INSERT INTO flr_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Mutondeerere ku bashosi ábahisiizi imyaka makumi gabiri neꞌngingwe, banabe bashobwiri ukugenda mwiꞌzibo. ");
INSERT INTO flr_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Iyo miharuuro, mu ngiisi mulala, umwimangizi muguma-muguma weꞌmbaga agakizi mùtabaala. ");
INSERT INTO flr_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Amaziina gaabo go gaaga: Woꞌmulala gwa Rubeni, hali Herizuuri mugala Shedeeri. ");
INSERT INTO flr_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Na woꞌmulala gwa Simyoni, hali Shelumyeri mugala Shuri-Shadayi. ");
INSERT INTO flr_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Na woꞌmulala gwa Yuda, hali Nasooni mugala Haminadabu. ");
INSERT INTO flr_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Na woꞌmulala gwa Hisakaari, hali Netaneeri mugala Swari. ");
INSERT INTO flr_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Na woꞌmulala gwa Zabulooni, hali Heryabu mugala Helooni. ");
INSERT INTO flr_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Na woꞌmulala gwa Hifurahimu mugala Yusefu, hali Herishama mugala Hamihudi. Na woꞌmulala gwa Manaasi mugala Yusefu, hali Gamalyeri mugala Pedashuri. ");
INSERT INTO flr_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Na woꞌmulala gwa Binyamiini, hali Habidaani mugala Gidyoni. ");
INSERT INTO flr_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Na woꞌmulala gwa Daani, hali Ahyezeeri mugala Hamishadayi. ");
INSERT INTO flr_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Na woꞌmulala gwa Hasheeri, hali Pagweri mugala Hokarani. ");
INSERT INTO flr_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Na woꞌmulala gwa Gaadi, hali Heryasafu mugala Deweri. ");
INSERT INTO flr_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Na woꞌmulala gwa Nafutaali, hali Ahira mugala Henani.» ");
INSERT INTO flr_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Yabo bashosi, bo bakatoolwa kwo bayimangire imilala yabo, nga kwo yâli gabulikiini yaho kare. ");
INSERT INTO flr_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Yabo kwo bâli ikumi na babiri, Musa bo na Harooni banabayabiira, ");
INSERT INTO flr_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","banakuumania Abahisiraheeri booshi ku lusiku lwa mbere lwoꞌmwezi gwa kabiri. Lyeryo, abandu bakaharuurwa, ukukulikirana naꞌmakondo gaabo, neꞌmbaga zaabo. Ngiisi bashosi ábâli hiiti imyaka makumi gabiri neꞌngingwe, banayandikwa, ngiisi muguma mwiꞌziina lyage. ");
INSERT INTO flr_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Kwokwo, ikyanya bâli koli shumbisiri yaho mwiꞌshamba lyeꞌSinaayi, Musa anaharuura abandu, nga ngiisi kwo Nahano akamúbwira. ");
INSERT INTO flr_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Mu ngiisi mulala gwaꞌBahisiraheeri, abandu bakaharuurwa ikondo kwiꞌkondo, neꞌmbaga ku mbaga. Banayandika amaziina gaꞌbashosi booshi, ukutondeerera ku myaka makumi gabiri neꞌngingwe, kwo bâli shobwiri ukulwa mwiꞌzibo. Umuharuuro gwabo, gwo gwoguno: ");
INSERT INTO flr_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Abandu boꞌmulala gwa Rubeni, ifula ya Yakobo, bâli bihumbi makumi gana na ndatu na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","Na boꞌmulala gwa Simyoni, bâli bihumbi makumi gataanu na mwenda na magana gashatu. ");
INSERT INTO flr_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","Na boꞌmulala gwa Gaadi, bâli bihumbi makumi gana na bitaanu na magana galindatu na makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","Na boꞌmulala gwa Yuda, bâli bihumbi makumi galinda na bina na magana galindatu. ");
INSERT INTO flr_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","Na boꞌmulala gwa Hisakaari, bâli bihumbi makumi gataanu na bina na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","Na boꞌmulala gwa Zabulooni, bâli bihumbi makumi gataanu na birinda na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","Na boꞌmulala gwa Hifurahimu mugala Yusefu, bâli bihumbi makumi gana na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","Na boꞌmulala gwa Manaasi mugala Yusefu, bâli bihumbi makumi gashatu na bibiri na magana gabiri. ");
INSERT INTO flr_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","Na boꞌmulala gwa Binyamiini, bâli bihumbi makumi gashatu na bitaanu na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","Na boꞌmulala gwa Daani, bâli bihumbi makumi galindatu na bibiri na magana galinda. ");
INSERT INTO flr_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","Na boꞌmulala gwa Hasheeri, bâli bihumbi makumi gana na kiguma na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","Na boꞌmulala gwa Nafutaali, bâli bihumbi makumi gataanu na bishatu na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Kwokwo, kwo Musa na Harooni, na balya bimangizi baabo ikumi na babiri, bakaharuura abashosi baꞌBahisiraheeri, ngiisi muguma mu mbaga yabo. ");
INSERT INTO flr_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Balya bashosi ábâli hisiizi imyaka makumi gabiri neꞌngingwe, banabe bashobwiri ukulwa mwiꞌzibo, ikyanya bakaharuurwa ukukulikirana neꞌmbaga zaabo, ");
INSERT INTO flr_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","bâli hisiri bashosi bihumbi magana galindatu na bishatu na magana gataanu na makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Imbaga zoꞌmulala gwa Laawi, zoohe, zitakaharuurwa, ");
INSERT INTO flr_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","bwo Nahano akagwanwa abwira Musa, kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Abandu beꞌkibusi kya Laawi, utabaharuurire kuguma naꞌbaabo Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Si ubabiikage bakizi laliira iheema lisingule mwaꞌmabuye geꞌKihango, kuguma na ngiisi bindi birugu byamwo. Yiryo iheema, bo bagakizi likola mwo, bo baganakizi libetula kuguma neꞌbirugu byalyo. «Neꞌkyanya mugaaba mukoli shumbisiri, boohe bo bagashinga amaheema gaabo ha butambi lyalyo. ");
INSERT INTO flr_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Neꞌkyanya mugayimuka, bo bagalishinguula. Neꞌkyanya mugashubi shumbika, bo bagashubi lishinga. Lirya iheema, ngiisi mundu útalyagagi Mulaawi, iri angaliyegeera, ayami yitwa. ");
INSERT INTO flr_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","«Abandi Bahisiraheeri, bagakizi shumbika buso-buso, ngiisi imbaga mwiꞌdako liꞌrembera lyabo. ");
INSERT INTO flr_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Haliko Abalaawi boohe, bakwiriiri bakizi shinga amaheema gaabo ha butambi liꞌheema lyeꞌmihumaanano, gira ndayiji kengeera narakarira Abahisiraheeri. Yabo Balaawi, bo baganakizi lihahalira.» ");
INSERT INTO flr_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Balya Bahisiraheeri, ngiisi byo Nahano âli bwiziri Musa, banakizi bigira. ");
INSERT INTO flr_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Nahano anabwira Musa bo na Harooni kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Ikyanya Abahisiraheeri bagakizi ba bagashumbika, ngiisi mulala gukwiriiri gubiikwe ahandu haagwo, hoofi niꞌrembera lyagwo. Bagaaba basokaniini lirya iheema lyeꞌmihumaanano, si bagayisumbura hiniini. ");
INSERT INTO flr_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","«Uluhande lweꞌsheere, hagakizi shumbika beene Yuda, bayiguziri áhali irembera lyabo. Umwimangizi wabo, ali Nasooni mugala Haminadabu. ");
INSERT INTO flr_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Naꞌbashosi baabo, bahisiri bihumbi makumi galinda na bina na magana galindatu. ");
INSERT INTO flr_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","«Ha butambi lyabo, hagakizi shumbika beene Hisakaari. Umwimangizi wabo, ali Netaneeri mugala Swari. ");
INSERT INTO flr_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Naꞌbashosi baabo, bahisiri bihumbi makumi gataanu na bina na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","«Ha butambi lyabo kandi, hagakizi shumbika beene Zabulooni. Umwimangizi wabo, ali Heryabu mugala Helooni. ");
INSERT INTO flr_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Naꞌbashosi baabo, bahisiri bihumbi makumi gataanu na birinda na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","«Kwokwo, abashosi ábagashumbika uluhande lwa beene Yuda, bahisiri ibihumbi igana na makumi galimunaana na ndatu na magana gana. Ikyanya Abahisiraheeri bagakizi sheguula, iyo milala ishatu yo igakizi shokola injira. ");
INSERT INTO flr_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","«Uluhande lweꞌkisaka, hagakizi shumbika beene Rubeni, bayiguziri áhali irembera lyabo. Umwimangizi wabo, ali Herishuri mugala Shedweri. ");
INSERT INTO flr_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Abashosi baabo, bahisiri bihumbi makumi gana na ndatu na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","«Ha butambi lyabo, hagakizi shumbika beene Simyoni. Umwimangizi wabo, ali Shelumyeri mugala Shuri-Shadayi. ");
INSERT INTO flr_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Abashosi baabo, bahisiri bihumbi makumi gataanu na mwenda na magana gashatu. ");
INSERT INTO flr_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","«Ha butambi lyabo kandi, hagakizi shumbika beene Gaadi. Umwimangizi wabo, ali Heryasafu mugala Rehuweri. ");
INSERT INTO flr_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Abashosi baabo, bahisiri bihumbi makumi gana na bitaanu na magana galindatu na makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","«Kwokwo, abashosi booshi ábagashumbika uluhande lwa beene Rubeni naꞌbatuulani baabo, bahisiri bihumbi igana na makumi gataanu na kiguma na magana gana na makumi gataanu. Iyo milala ishatu, yo igakizi shalagira beene Yuda naꞌbaabo. ");
INSERT INTO flr_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","«Ha nyuma, beene Laawi bagahulukana lirya iheema lyeꞌmihumaanano. Ahandu haabo, hagakizi beera ha kati-kati kaꞌbaabo. Nabo mu kuyimuka, bagakizi kulikirana na ngiisi kwo bali mu kizi shumbika. Ngiisi mulala, gugaaba guyiguziri áhali irembera lyagwo. ");
INSERT INTO flr_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","«Uluhande lweꞌmuga, hagakizi shumbika beene Hifurahimu, bayiguziri áhali irembera lyabo. Umwimangizi wabo, ali Herishama mugala Hamihudi. ");
INSERT INTO flr_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Abashosi baabo, bahisiri bihumbi makumi gana na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","«Ha butambi lyabo, hagakizi shumbika beene Manaasi. Umwimangizi wabo, ali Gamalyeri mugala Pedashuri. ");
INSERT INTO flr_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Abashosi baabo, bahisiri bihumbi makumi gashatu na bibiri na magana gabiri. ");
INSERT INTO flr_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","«Ha butambi lyabo kandi, hagakizi shumbika beene Binyamiini. Umwimangizi wabo, ali Habidaani mugala Gidyoni. ");
INSERT INTO flr_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Abashosi baabo, bahisiri bihumbi makumi gashatu na bitaanu na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","«Kwokwo, abashosi booshi ábagashumbika uluhande lwa beene Hifurahimu naꞌbatuulani baabo, bahisiri bihumbi igana na munaana niꞌgana. Mu lugeezi, iyo milala ishatu, yo igakizi shalagira beene Laawi. ");
INSERT INTO flr_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","«Uluhande lweꞌmbembe, hagakizi shumbika beene Daani, bayiguziri áhali irembera lyabo. Umwimangizi wabo, ali Ahyezeeri mugala Hamishadayi. ");
INSERT INTO flr_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Abashosi baabo, bahisiri bihumbi makumi galindatu na bibiri na magana galinda. ");
INSERT INTO flr_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","«Ha butambi lyabo, hagakizi shumbika beene Hasheeri. Umwimangizi wabo, ali Pagweri mugala Hokarani. ");
INSERT INTO flr_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Abashosi baabo, bahisiri bihumbi makumi gana na kiguma na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","«Ha butambi lyabo kandi, hagakizi shumbika beene Nafutaali. Umwimangizi wabo, ali Ahira mugala Henani. ");
INSERT INTO flr_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Abashosi baabo, bahisiri bihumbi makumi gataanu na bishatu na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","«Kwokwo, abashosi booshi ábagashumbika uluhande lwa beene Daani naꞌbatuulani baabo, bahisiri bihumbi igana na makumi gataanu na birinda na magana galindatu. Mu lugeezi, iyo milala ishatu, yo igakizi lyoka ubuzinda, iyiguziri áhali irembera lyabo.» ");
INSERT INTO flr_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Yabo Bahisiraheeri, kwokwo kwo bakaharuurwa, ukukulikirana na ngiisi kwo bâli kizi shumbika, kuguma neꞌmilala yabo. Booshi kuguma, bâli hisiri bihumbi magana galindatu na bishatu na magana gataanu na makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Haliko, ikyanya yabo Bahisiraheeri bakaharuurwa, beene Laawi batâli bali mwo, nga kwo Nahano akagwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Balya Bahisiraheeri, ngiisi byo Nahano akagwanwa abwira Musa, bakabigira. Ngiisi mulala, gwâli kizi shumbika ha butambi liꞌrembera lyabo. Kiri noꞌkukizi huluka mu shumbi, kwo ngiisi mundu âli kizi gira, kuguma neꞌmbaga yabo, noꞌmulala gwabo. ");
INSERT INTO flr_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Hano, hagatondobolwa imyazi yeꞌmbaga ya Harooni bo na Musa, ku kyanya Nahano akaganuuza Musa ku mugazi Sinaayi. ");
INSERT INTO flr_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Harooni âli gweti abagala bana. Ifula, ye Nadabu. Na ábagamúkulikira, hâli Habihu, na Heryazaari, na Hitamaari. ");
INSERT INTO flr_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Yabo bagala, bo bakataluulwa, kwo bakizi kola umukolwa gwoꞌbugingi. ");
INSERT INTO flr_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Halikago, Nadabu bo na Habihu, ikyanya bakaba bakiri mwiꞌshamba lyeꞌSinaayi, bakatangira Nahano ituulo ku njira ítali nga yo, banayami yitwa imbere lyage. Yabo bombi, batâli hiiti abaana. Kwokwo, ikyanya Harooni âli ki riiri ho, Heryazaari na Hitamaari, bo bakasigali kola bo naye, ku mukolwa gwoꞌbugingi. ");
INSERT INTO flr_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Utumirage beene Laawi, unabaleete imunda Harooni, gira bakizi mútabaala mu mikolwa yage. ");
INSERT INTO flr_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Bo bagakizi beera hoofi niꞌheema lyeꞌmihumaanano, bagweti bagakolera Harooni, kiri naꞌbandi Bahisiraheeri booshi. ");
INSERT INTO flr_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Banakizi langa ibikolanwa byalyo byoshi. Ku njira yoꞌkukola mu lirya iheema, lyo bagakizi kolera Abahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","«Yabo beene Laawi, ugabasikiiriza Harooni na bagala baage. Mu Bahisiraheeri booshi, bo bakoli talwirwi imwage. ");
INSERT INTO flr_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Utaluule Harooni na bagala baage, halinde balonge ukukizi gira imikolwa yabo yoꞌbugingi. Si iri hangaba halyagagi ugundi mundu úgayegeera yiryo iheema, emwe! Agayami yitwa.» ");
INSERT INTO flr_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Nahano anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Lola! Keera nꞌgatoola beene Laawi, kwo bakizi gomboola ifula zaꞌBahisiraheeri booshi. Aaho! Abalaawi balyagagi beꞌmwani. ");
INSERT INTO flr_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Kiri neꞌfula zooshi, nazo ziri zeꞌmwani. Ikyanya mwâli riiri i Miisiri, nꞌgayita ifula zooshi zaꞌBamiisiri, nanayami yitaluulira ifula zooshi zaꞌBahisiraheeri, kwo zibe zeꞌmwani, ziba mu bandu, kandi iri mu bitugwa. Niehe nie Nahano.» ");
INSERT INTO flr_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Haaho mwiꞌshamba lyeꞌSinaayi, Nahano anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Uharuurage beene Laawi booshi, ukukulikirana naꞌmakondo gaabo, neꞌmbaga zaabo. Uharuure abatabana booshi ábakoli hisiizi umwezi muguma neꞌngingwe.» ");
INSERT INTO flr_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Yago magambo ga Nahano, Musa anagasimbaha, anabaharuura booshi. ");
INSERT INTO flr_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Laawi âli gweti abagala bashatu, amaziina gaabo, go gaaga: Girishooni, na Kohaati, na Meraari. ");
INSERT INTO flr_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Uyo Girishooni, abandu ba mwiꞌkondo lyage, bâli Libuuni na Shimeyi. ");
INSERT INTO flr_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Uyo Kohaati naye, abandu ba mwiꞌkondo lyage, bâli Hamuramu, na Hishaari, na Heburooni, na Huzyeri. ");
INSERT INTO flr_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Uyo Meraari naye, abandu ba mwiꞌkondo lyage, bâli Maali na Muushi. Yabo booshi, bâli riiri beene Laawi, ukukulikirana naꞌmakondo gaabo. ");
INSERT INTO flr_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Ulya Girishooni, ye shyoko ya beene Libuuni, na beene Shimeyi. ");
INSERT INTO flr_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Umuharuuro gwabo, ukutondeerera ku mundu woꞌmwezi muguma noꞌkugenderera, bâli bashosi bihumbi birinda na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Yabo beene Girishooni, bo bakashumbika uluhande lweꞌmuga lwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Umwimangizi waꞌmakondo gaabo, âli Heryasafu mugala Layeri. ");
INSERT INTO flr_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Galya makondo gombi, umukolwa gwabo, gwâli gwoꞌkukizi langa iheema lyeꞌmihumaanano, kuguma na byoshi íbyâli kizi libwikira, kiri noꞌmulondo úgwâli kizi siika Ahandu Heeru, ");
INSERT INTO flr_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","neꞌmirondo íyâli zungulusiri ulubuga kuguma naꞌkatanda. Bâli kizi langa neꞌmigozi, na ngiisi birugu byoshi íbyâli loziri lirya iheema. ");
INSERT INTO flr_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Ulya Kohaati, ye shyoko yaꞌBahamuramu, na beene Hishaari, na beene Heburooni, na beene Huzyeri. ");
INSERT INTO flr_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Umuharuuro gwabo, ukutondeerera ku mundu woꞌmwezi muguma noꞌkugenderera, bâli bashosi bihumbi munaana na magana galindatu. Umukolwa gwabo, bâli kizi kola Ahandu Heeru. ");
INSERT INTO flr_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Yabo beene Kohaati, bâli kizi shumbika uluhande lweꞌkisaka lwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Umwimangizi wa beene Kohaati, âli riiri Herizafaani mugala Huzyeri. ");
INSERT INTO flr_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Yabo beene Kohaati, bâli kizi langa Akajumba keꞌKihango, naꞌkashasha, neꞌkiterekero kyaꞌmatara, noꞌtutanda, na ngiisi birugu byaꞌbagingi bâli kizi koleesa mwiꞌheema, kiri neꞌmirondo yoꞌkulisiika. ");
INSERT INTO flr_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Umwimangizi mukulu wa beene Laawi, âli Heryazaari mugala umugingiHarooni. Ye kabiikwa kwo akizi yimangira abakozi baꞌHandu Heeru. ");
INSERT INTO flr_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Uyo Meraari, ye shyoko ya beene Maali, na beene Muushi. ");
INSERT INTO flr_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Umuharuuro gwabo, ukutondeerera ku mundu woꞌmwezi muguma noꞌkugenderera, bâli bashosi bihumbi ndatu na magana gabiri. ");
INSERT INTO flr_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Umwimangizi mukulu waꞌmakondo gaabo, âli Shuryeri mugala Habihahiri. Yabo beene Meraari, bâli kizi shumbika uluhande lweꞌmbembe lwiꞌheema lyeꞌmihumaanano, ");
INSERT INTO flr_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","banâli kizi langa ibiti byoꞌkulishiga, neꞌnzuuma zaalyo, neꞌnguliro, neꞌbiterekero, na ngiisi birugu mwene yibyo. ");
INSERT INTO flr_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Na kwakundi, bâli kizi yimangira imirondo yoꞌkusiika ulubuga, kuguma neꞌbiterekero byalwo, neꞌmbambo, neꞌmigozi yalwo. ");
INSERT INTO flr_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Musa na Harooni, na bagala Haaroni boohe, bâli kizi shumbika imbere liꞌheema lyeꞌmihumaanano. Hâli riiri uluhande lweꞌsheere, hiꞌzuuba lyâli kizi tunduukira. Imikolwa yabo, bâli kizi kolera Abahisiraheeri, mu kuyimangira Ahandu Heeru. Ngiisi mundu úwâli kizi liyegeera, âli kwiriiri ayami yitwa. ");
INSERT INTO flr_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Kwokwo, kwo Musa bo na Harooni bakaharuura Abalaawi booshi, ukukulikirana neꞌmbaga zaabo, nga kwo Nahano âli mali gwanwa ababwira. Umuharuuro gwabo, ukutondeerera ku mundu woꞌmwezi muguma noꞌkugenderera, bâli bashosi bihumbi makumi gabiri na bibiri. ");
INSERT INTO flr_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Nahano anashubi bwira Musa kwokuno: «Balya Bahisiraheeri, ugendi haruura abatabana booshi beꞌfula, ukutondeerera ku mwana woꞌmwezi muguma noꞌkugenderera. Ukulikirize naꞌmaziina gaabo. ");
INSERT INTO flr_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Yabo Balaawi, ubahandulage babe beꞌmwani, nie Nahano, ahandu haꞌbatabana beꞌfula ba mu Bahisiraheeri. Na kwakundi, uhandule neꞌbitugwa bya beene Laawi, bibe byeꞌmwani, ho mwangayabiira ifula zeꞌbitugwa byaꞌBahisiraheeri.» ");
INSERT INTO flr_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Kwokwo, Musa anaharuura ifula zooshi zaꞌBahisiraheeri, nga kwo Nahano akamúbwira. ");
INSERT INTO flr_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Noꞌmuharuuro gwabo, bâli bashosi bihumbi makumi gabiri na bibiri na magana gabiri na makumi galinda na bashatu. ");
INSERT INTO flr_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Nahano anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Uhandule beene Laawi booshi babe beꞌmwani, ho wangayabiira ifula zaꞌBahisiraheeri. Na kwakundi, uhandule ibitugwa bya beene Laawi, ho wangayabiira ifula zeꞌbitugwa byaꞌBahisiraheeri. Balya beene Laawi, balyagagi beꞌmwani. Niehe, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","«Umuharuuro gweꞌfula zaꞌBahisiraheeri, gutalusiri umuharuuro gwa beene Laawi. Hali abandu magana gabiri na makumi galinda na bashatu, ábaki sigiiri. ");
INSERT INTO flr_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","Ku yukwo, ku yabo batabana magana gabiri na makumi galinda na bashatu, ukuumanie ibingorongoro bitaanu-bitaanu ku ngiisi muguma wabo. Ukoleese ulugero úluli mu koleesibwa Ahandu Heeru, lube lweꞌgarama ikumi. ");
INSERT INTO flr_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Yabo bandu magana gabiri na makumi galinda na bashatu, ngiisi harija ízigatangwa hiꞌgulu lyabo, uziheereze Harooni na bagala baage.» ");
INSERT INTO flr_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Kwokwo, Musa anakuumania zirya fwaranga ízâli kizi tangwa hiꞌgulu lyoꞌkuguluula balya ábakayushuuka. ");
INSERT INTO flr_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Imweꞌfula zooshi zaꞌBahisiraheeri, anakuumania ibingorongoro kihumbi na magana gashatu na makumi galindatu na zitaanu, ukukulikirana noꞌlugero úluli mu koleesibwa Ahandu Heeru. ");
INSERT INTO flr_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Yizo harija, anazisikiiriza Harooni na bagala baage, nga kwo Nahano akamúbwira. ");
INSERT INTO flr_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Nahano anabwira Musa na Harooni kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Mu yabo beene Laawi, muharuure beꞌkibusi kya Kohaati, ukukulikirana neꞌmbaga zaabo, naꞌmakondo gaabo. ");
INSERT INTO flr_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Muharuure abashosi booshi, kutondeerera ku myaka makumi gashatu halinde ku makumi gataanu, bakizi kola ku mikolwa ya mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Yabo beene Kohaati, bagayimangira ibindu íbikoli talwirwi mwiꞌheema. ");
INSERT INTO flr_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","«Ikyanya Abahisiraheeri bagakizi sheguula, Harooni na bagala baage bakwiriiri bayingire mu lirya iheema, banashonoole umulondo úgusiisiri Ikisiika Kyeru Bweneene. Yugwo mulondo, bagubwikire ku kalya Kajumba keꞌKihango. ");
INSERT INTO flr_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Banayabiire uluhu lukomu, banalubwikire hiꞌgulu lyagwo, bakabuli bwikira kweꞌkihunika kya namukungumo. Na mu kuheza, babuli shogeka birya biti byoꞌkukabetulira kwo. ");
INSERT INTO flr_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«Yikyo kihunika kya namukungumo, banashubi kireeza ku kashasha koꞌkutangira kweꞌmikate íyataluulwa imwa Nahano. Hiꞌgulu lyakyo, banabiike amasahaani, neꞌbikombe, neꞌbirembe, neꞌkarabo zoꞌkubiikira ituulo lyeꞌdivaayi. Irya mikate íyamiri-yamiri ku kashasha, igakizi yama ibiisirwi kwo. ");
INSERT INTO flr_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Kwokwo, birya birugu byoshi, banabwikire kweꞌkihunika kidukula, babuli leeza kwoꞌluhu lukomu. Ha nyuma, banashogeke birya biti byoꞌkukabetulira. ");
INSERT INTO flr_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«Ha nyuma, banayabiire ikindi kihunika kya namukungumo, banatumbikire mweꞌkiterekero kyaꞌmatara, kuguma naꞌmatara, neꞌbirugu byago, neꞌmikasi yakyo, neꞌsuniya zaakyo, na ngiisi makarabo goꞌkusingula mwaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Yibyo byoshi, bagabisingulira mu luhu lukomu, babuli bibiika ku kipoyo kyoꞌkubibetulira kwo. ");
INSERT INTO flr_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«Na kwakundi, banayaje ikihunika kya namukungumo ku katanda keꞌnooro, banakatumbikire kwoꞌluhu lukomu, babuli shogeka birya biti byoꞌkukabetulira kwo. ");
INSERT INTO flr_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","«Ibirugu byoshi byoꞌkukolera mwo Ahandu Heeru, babikuumanie, banabibohe mu kihunika kya namukungumo, banashubi bibwikira kwoꞌluhu lukomu, bakabuli bibiika ku kipoyo kyoꞌkubibetulira kwo. ");
INSERT INTO flr_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","«Kalya katanda koꞌkusiriigiza kwaꞌmatuulo, batee kashaaza kwoꞌmunyota-kiiko, banakaleeze kweꞌkihunika kyeꞌkituku-tuku, ");
INSERT INTO flr_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","babuli katereka kweꞌbirugu byoshi íbiri mu koleesibwa mu kutanga amatuulo goꞌkusiriiza. Kuli kudeta, isheetezo, neꞌkanya, neꞌmbahwa zoꞌkushamata, neꞌnzoozo zoꞌkubiikira umuko. Ha nyuma, banabibwikire noꞌluhu lukomu, babuli shogeka birya biti byoꞌkukabetulira kwo. ");
INSERT INTO flr_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«Ikyanya Harooni naꞌbagala bagaaba keera babwikira halya handu heeru kuguma neꞌbirugu byaho byoshi, kwo biri bitaluule, lyaꞌBahisiraheeri bagayibiika ibiringiini ukuyimuka. Kwokwo, beene Kohaati bayingirage, gira babibetule. Haliko, batahangwirwi ukubihuma kwo. Buzira kwokwo, ukufwa, bagaafwa nyene. Balya bandu, umukolwa gwabo, kuli betula ibirugu byoshi bitaluule bya mu lirya iheema. ");
INSERT INTO flr_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«Heryazaari mugala umugingi Harooni, ye gaaba mwimangizi mukulu wiꞌheema lyeꞌmihumaanano, kuguma neꞌbirugu bitaluule byamwo byoshi, kuli kudeta amavuta giꞌtara, noꞌmubadu gwoꞌmuhongolo mwija, neꞌngano íri mu tangwa ngiisi lusiku, naꞌmavuta goꞌkushiiga abagingi, na ngiisi bindi íbitalwirwi imwa Nahano.» ");
INSERT INTO flr_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ha nyuma, Nahano anabwira Musa na Harooni kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Mutalekage kwo beene Kohaati baminikwe mu Balaawi. ");
INSERT INTO flr_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Si ikyanya bagakizi yegeera birya birugu bitaluule, balongage ukutuula ho, batanayami yitwa. Kwokwo, Harooni na bagala baage babayingirane mwiꞌheema, banayerekage beene Kohaati ngiisi mukolwa gwo bakwiriiri ukukizi gira. ");
INSERT INTO flr_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Halikago, balya beene Kohaati batakolwe kwo balola ku birya bindu bitaluule. Iri bangabilola kwo, ukufwa, bagayami fwa.» ");
INSERT INTO flr_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Nahano anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Uharuurage beene Girishooni, ukukulikirana neꞌmbaga zaabo, naꞌmakondo gaabo. ");
INSERT INTO flr_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Uharuure abashosi booshi kutondeerera ku myaka makumi gashatu, halinde ku makumi gataanu, bakizi kola ku mikolwa ya mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Yabo beene Girishooni, imikolwa yabo, ");
INSERT INTO flr_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","iri ya kubetula imirondo yoꞌkubwikira iheema lyeꞌmihumaanano, kuguma niꞌheema lyeꞌmihumaanano lyonyene, noꞌmutumbikizo gwalyo, na lulya luhu lukomu lwoꞌkulibwikira. Na kwakundi, bakwiriiri bakizi betula imirondo ya ha mulyango gwalyo, ");
INSERT INTO flr_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","neꞌmirondo yoꞌluzitiro lwa lirya iheema naꞌkatanda, neꞌmirondo yoꞌkusiika umulyango gwoꞌlubuga lwalyo, kuguma neꞌmigozi, na ngiisi bindi birugu byamwo. Birya byoshi, balya Bagirishooni, bo bagakizi biyimangira. ");
INSERT INTO flr_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","«Yabo Bagirishooni, Harooni na bagala baage, bakwaniini bakizi tanduula imikolwa yabo, banababwire na ngiisi kwo bagakizi betula. ");
INSERT INTO flr_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Yeyo, yo mikolwa yabo mwiꞌheema lyeꞌmihumaanano. Hitamaari mugala umugingi Harooni, ye gakizi bayimangira. ");
INSERT INTO flr_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Na kwakundi, uharuurage Abalaawi ba mwiꞌkondo lya Meraari, ukukulikirana neꞌmbaga zaabo, naꞌmakondo gaabo. ");
INSERT INTO flr_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Uharuure abashosi booshi kutondeerera ku myaka makumi gashatu, halinde ku makumi gataanu, bakizi kola ku mikolwa ya mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Yabo nabo, imikolwa yabo, iri ya kubetula ibiti byoꞌkumanikira kwiꞌheema lyeꞌmihumaanano, neꞌnzizi, neꞌnguliro, neꞌbiterekero byalyo. ");
INSERT INTO flr_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","Na kwakundi, bakizi betula neꞌnguliro ízizungulusiri ulubuga, neꞌbiterekero byazo, neꞌmbambo, neꞌmigozi, na ngiisi bindi byoshi íbiri mu koleesibwa kwo. Ngiisi mundu, umúyerekage ngiisi byo akwiriiri ukubetula. ");
INSERT INTO flr_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Yugwo, gwo mukolwa gwo beene Meraari bagakizi gira mwiꞌheema lyeꞌmihumaanano. Hitamaari mugala umugingiHarooni, ye gakizi bayimangira.» ");
INSERT INTO flr_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Kwokwo, Musa na Harooni, naꞌbandi bimangizi baꞌBahisiraheeri, banaharuura beene Kohaati, ukukulikirana neꞌmbaga zaabo, naꞌmakondo gaabo. ");
INSERT INTO flr_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Bakaharuura abashosi booshi kutondeerera ku myaka makumi gashatu, halinde ku makumi gataanu, banabe bayemeriirwi ukukizi kola ku mikolwa ya mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Yabo bashosi booshi, bâli hisiri bihumbi bibiri na magana galinda na makumi gataanu. ");
INSERT INTO flr_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Yugwo, gwo muharuuro gwa beene Kohaati, kwo bâli bayemeriirwi ukukizi kola ku mikolwa ya mwiꞌheema lyeꞌmihumaanano. Musa na Harooni, bo bakabaharuura, nga kwo Nahano akabwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Na kwakundi, banashubi haruura beene Girishooni, ukukulikirana neꞌmbaga zaabo, naꞌmakondo gaabo. ");
INSERT INTO flr_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Bakaharuura abashosi booshi kutondeerera ku myaka makumi gashatu, halinde ku makumi gataanu, banabe bayemeriirwi ukukizi kola ku mikolwa ya mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Yabo bashosi booshi, bâli hisiri bihumbi bibiri na magana galindatu na makumi gashatu. ");
INSERT INTO flr_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Gwogwo gwo muharuuro gwa beene Girishooni, ábâli yemiirwi ukukizi kola mwiꞌheema lyeꞌmihumaanano. Musa na Harooni bo bakabaharuura, nga kwo Nahano akabwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Na kwakundi, banaharuura beene Meraari, ukukulikirana neꞌmbaga zaabo, naꞌmakondo gaabo. ");
INSERT INTO flr_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Bakaharuura abashosi booshi kutondeerera ku myaka makumi gashatu, halinde ku makumi gataanu, banabe bayemeriirwi ukukizi kola ku mikolwa ya mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Yabo bashosi booshi, bâli hisiri bihumbi bishatu na magana gabiri. ");
INSERT INTO flr_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Gwogwo, gwo muharuuro gwa beene Meraari. Musa na Harooni bo bakabaharuura, nga kwo Nahano akabwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Kwokwo, Musa na Harooni, naꞌbimangizi baꞌBahisiraheeri, banaharuura beene Laawi booshi, ukukulikirana neꞌmbaga zaabo, naꞌmakondo gaabo. ");
INSERT INTO flr_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Bakaharuura abashosi booshi kutondeerera ku myaka makumi gashatu, halinde ku makumi gataanu, banabe bayemeriirwi kukizi kola ku mikolwa ya mwiꞌheema lyeꞌmihumaanano, noꞌkulibetula. ");
INSERT INTO flr_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Yabo bashosi booshi, bâli hisiri bihumbi munaana na magana gataanu na makumi galimunaana. ");
INSERT INTO flr_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Na ngiisi muguma wabo akaharuurwa, anahaabwa ugwage mukolwa, anayerekwa na byo akwiriiri ukukizi betula, nga kwo Nahano akagwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","kwo agendi bwira Abahisiraheeri kwokuno: «Ngiisi úgweti umubembe, bakwiriiri bamúyimule mu shumbi. Bayimule na ngiisi úli mu shuubala amasira, na ngiisi úwayiyulubaza mu kuhuma ku kirunda. ");
INSERT INTO flr_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Yulu lubaaja, lugaakola ku bashosi, kiri na ku bakazi. Mukizi bayimula, gira batakengeere bayulubaza ishumbi lyo nduuziri mwo.» ");
INSERT INTO flr_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Galya magambo go Nahano akabwira Musa, Abahisiraheeri banagasimbaha. Yabo balwazi, banakizi yimulirwa inyuma lyeꞌshumbi. ");
INSERT INTO flr_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","kwo abwire Abahisiraheeri kwokuno: «Ngiisi mundu, aba mushosi kandi iri mukazi, iri angahubira uwabo, agaaba agira ikyaha imbere lya Nahano yenyene. ");
INSERT INTO flr_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Yikyo kyaha kyo akahubira uwabo, akwiriiri akiyilege. Na íbyagahyula, akwiriiri abiyushuule kweꞌkihande kiguma kya kataanu. ");
INSERT INTO flr_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","«Haliko, ulya nakuhubirwa, iri angaba akoli fwiri, anabe atahiiti mwene wabo wa hoofi úwangayakiira birya bindu, lyoki lyo bigaaba byeꞌmwani nie Nahano. Kwokwo, akwaniini abiheereze abagingi. Na kwakundi, akwiriiri atangage neꞌkipanga, libe ituulo lyoꞌkukogwa ibyaha. Kwokwo, lyo agayeruusibwa, anakogwe imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","«Abahisiraheeri, ikyanya bagakizi tanga ituulo, bakwaniini balitwalire umugingi, linabe likola lyeꞌmwage. ");
INSERT INTO flr_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Yago matuulo ágatangwa imwaꞌbagingi, gagaaba gakola geꞌmwabo.» ");
INSERT INTO flr_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Nahano anashubi bwira Musa, ");
INSERT INTO flr_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","kwo abwire Abahisiraheeri kwokuno: «Tudete ngoꞌmukazi angaba atakiri mwemeera imwa yiba, ");
INSERT INTO flr_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","anagendi shulehwa noꞌgundi mushosi. Haliko, yiba anabe atayiji. Kundu kwokwo, uyo mukazi agaaba akoli yulubiiri, kundu ndaaye úwabona ngiisi kwo bamúshuleha, ndaanaye úwamúgwata. ");
INSERT INTO flr_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","«Hali ikyanya yiba angagwatwa noꞌluugi, anakeeke mukaage kwo ngeeka alyagagi mushule, anabe aloziizi ukumenya inooka iri mukaage akoli yulubiiri, kandi iri nanga. ");
INSERT INTO flr_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Kwokwo, uyo mushosi akwiriiri atwale mukaage imbere lyoꞌmugingi. Akwiriiri atwale niꞌtuulo hiꞌgulu lyage. Yiryo ituulo, ligaaba litiri zibiri zoꞌmushyano gwoꞌbulo, muzira kubushwa mwaꞌmavuta, kandi iri mubadu. Yiryo ituulo ligatangwa noꞌyo munaluugi, gira alonge ukumenya iri mukaage amúhubiiri, kandi iri nanga. ");
INSERT INTO flr_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","«Uyo mukazi, umugingi agayiji múyimangika imbere lya Nahano, ");
INSERT INTO flr_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","anayabiire amagoloovi meeru mu kabindi, anagafuke mwoꞌluvu lwa mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ulya mukazi, ikyanya umugingi agamúyimangika imbere lya Nahano, agamúshwekuula umushaku, anamúfumbase lirya ituulo lyoꞌkuyerekana kwoꞌluugi lwa yiba luli lwoꞌkuli. Umugingi naye anabe afumbiiti galya magoloovi malulu, ágali mu leeta idaaki imwoꞌmuhubi. ");
INSERT INTO flr_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","«Ulya mugingi, anabikiise uyo mukazi indahiro mu kudeta: “Iri wangaba utayiyulubaziizi mu kushulehwa noꞌgundi mushosi, unabe ukiri mwemeera imwa yibalo, yaga magoloovi malulu, idaaki lyamwo litakuyahukire. ");
INSERT INTO flr_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","«“Halikago, iri wangaba utakiri mwemeera imwa yibalo, unabe keera wayiyulubaza mu kushulehwa noꞌgundi mushosi, ");
INSERT INTO flr_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Nahano akuhaniirize. Ibunda lyawe liheemage, unagumbe. Abandu bakizi kudaaka, iri banakunegura lwoshi. ");
INSERT INTO flr_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Gano magoloovi goꞌkuleeta idaaki, gayingirage mwiꞌbunda lyawe, linaheeme, halinde ganakugumbiise.” «Uyo umukazi, ikyanya agayuvwa kwokwo, akwaniini adumeereze, ti: “Ee! Bibe kwokwo.” ");
INSERT INTO flr_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","«Galya magambo gaꞌmadaaki, umugingi akwaniini agayandike mu kitaabo kibungirize. Na mu kugashaaza mu kitaabo, agadobeke mu galya magoloovi malulu. ");
INSERT INTO flr_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Anaganywese uyo mukazi, kwo gali mu leeterana idaaki. Iri angaba ahubiiri yiba, yago magoloovi gagayami múlwaza. ");
INSERT INTO flr_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","«Na lirya ituulo lyoꞌkuyerekana uluugi, uyo mugingi analiyabiire mu maboko goꞌlya mukazi, analitange imbere lya Nahano, abuli libiika ku katanda. ");
INSERT INTO flr_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Lyeryo, anayabiire ikigasha kiguma kyoꞌmushyano, gube mutuli gwoꞌbukengeeze, anagusiriigize ku katanda. Ha nyuma, galya magoloovi, anaganywese ulya mukazi. ");
INSERT INTO flr_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Iri angaba keera akahubira yiba mu kumenyana noꞌgundi mushosi, anabe akoli yiyulubaziizi, yago magoloovi, gagamúheemya ibunda, anagumbe. Niꞌziina lyage, mu bandu baage, ligahinduka iziina liꞌdaaki. ");
INSERT INTO flr_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","«Halikago, uyo mukazi, iri angaba atayiyulubaziizi, agaaba ali shululu, anakizi longa ukubuta. ");
INSERT INTO flr_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","«Lwolwo, lwo lubaaja hiꞌgulu lyoꞌmundu úkoli yuvwiti uluugi. Ngiisi mukazi úyazirwi, iri angahubira yiba anayidwakaze, kwokwo kwo agamúgira. ");
INSERT INTO flr_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Banganagira kwokulya, iri umushosi angagwatwa noꞌluugi hiꞌgulu lya mukaage. Uyo mukazi, yiba agamútwala imbere lya Nahano, umugingi anakoleese ngiisi kwoꞌlubaaja ludesiri. ");
INSERT INTO flr_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Kwiꞌyo njira, yiba atagaaba noꞌbuhube. Si mukaage, iri angaba ahubiri, agalibuuka bweneene hiꞌgulu lyoꞌbuhube bwage.» ");
INSERT INTO flr_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Nahano anashubi bwira Musa ");
INSERT INTO flr_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","kwo abwire Abahisiraheeri kwokuno: «Umundu, aba mushosi kandi iri mukazi, iri angayitaluula imwani nie Nahano, agaaba akola Mutaluule. ");
INSERT INTO flr_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Uyo mundu, atakizi ki nywa idivaayi, kandi iri ikindi kilalusa kwo kikaba kwoshi. Atakizi nywa noꞌmutobo gwoꞌmuzabibu, kandi iri imizabibu yonyene, kiri neꞌmizabibu myumu. ");
INSERT INTO flr_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","«Ikyanya ali mu ba akiri Mutaluule, hatagire ikindu íkilyosiri mu muzabibu, kyo agaanywa. Kiri noꞌlubuto lwagwo kandi iri kyula kyagwo, atakizi ki lya. ");
INSERT INTO flr_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Na kwakundi, ku kyanya ayitanga imwa Rurema nga Mutaluule, atâye begwe umushaku. Ee! Bwo ali mu ba akoli talwirwi imwa Nahano, atakwaniini ukubegwa umushaku gwage. Si ikyanya agaaba keera akwiza byo alagaania, lyoki, angagumwesa. ");
INSERT INTO flr_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","«Na kwakundi, yikyo kyanya agaaba akoli talwirwi imwa Nahano, atagire mbu ayegeere ikirunda. ");
INSERT INTO flr_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Yikyo kirunda, kundu kyangabiiri kya yishe, kandi iri kya nyina, kandi iri kya mwene wabo, kandi iri kya mwali wage, atakwaniini ukukihuma kwo, atayiji kengeera ayiyulubaza. Umushaku úguli kwiꞌtwe lyage, guyerekiini kwo akoli talwirwi imwa Nahano. ");
INSERT INTO flr_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Kwokwo, ikyanya agaaba akiri Mutaluule, ayilangage, mukuba agaaba aki talwirwi imwage. ");
INSERT INTO flr_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","«Iri ugundi angakengeera afwira ha butambi lyoꞌyo Mutaluule, gulya mushaku gwage gugaaba gukoli yulubiiri. Kwokwo, akwaniini ahise isiku zirinda agweti agayiyeruusa, akabuli yimwesa. ");
INSERT INTO flr_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","«Ku lusiku úlugira umunaana, akwiriiri agendage ha mulyango gwiꞌheema lyeꞌmihumaanano, ahitiiri umugingi amahumba gabiri, kandi iri byana bibiri byeꞌngunde. ");
INSERT INTO flr_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Uyo mugingi agatanga akanyuni kaguma kabaagage ituulo lyoꞌkukogwa ibyaha byage. Akandi kanyuni, anakatange libe ituulo lyoꞌkusiriiza lwoshi. Kwokwo, kwo agayiyeruusa, hiꞌgulu lyoꞌbuhube bwo akagira mu kuhuma kirya kirunda. Lwolwo lusiku, agashubi yitanga abe Mutaluule, anashubi leka umushaku gwage gulaahe kandi. ");
INSERT INTO flr_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Isiku zo âli haruriirwi mbu ayitaaziri imwa Nahano, zitagaki haruurwa. Si agaaba keera ayiyulubaza ku kyanya âli koli talwirwi imwage. Isiku zo agakizi yitanga imwa Nahano, bagatondeera ukuziharuura buhyahya. Aganatanga ikyanabuzi kyeꞌkipanga kiguma kyoꞌmwaka muguma libe ituulo lyoꞌkuhyula. ");
INSERT INTO flr_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","«Lwolwo, lwo lubaaja úluloziri Umutaluule. Ikyanya agaaba keera ayusa ukuyitaluula imwa Nahano, agagenda ha mulyango gwiꞌheema lyeꞌmihumaanano, ");
INSERT INTO flr_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","anatangire Nahano ibitugwa bishatu bizira kashembo. Agatanga ikyanabuzi kyeꞌkipanga kiguma kyoꞌmwaka muguma, libe ituulo lyoꞌkusiriiza lwoshi. Anatange neꞌshaashi nguma yeꞌkyanabuzi kyoꞌmwaka muguma, libe ituulo lyoꞌkukogwa ibyaha. Anatange neꞌkipanga kiguma, libe ituulo lyoꞌkuyerekana ingoome. ");
INSERT INTO flr_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Na kwakundi, anatange ikitiri íkiyijwiri imikate mizira saama, neꞌbitumbula íbikagirwa mu mushyano mulembu, gunabe mufushe mwaꞌmavuta, neꞌgaleeti nzira saama, inali nvushe mwaꞌmavuta. Agakizi tanga naꞌmatuulo goꞌmushyano, na geꞌbinywebwa. ");
INSERT INTO flr_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","«Yago matuulo gooshi, umugingi agatee gandangira, nie Nahano. Agatee tanga ituulo lyoꞌkukogwa ibyaha, kuguma niꞌtuulo lyoꞌkusiriiza lwoshi. ");
INSERT INTO flr_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Ha nyuma, ayite kirya kipanga, anakitange libe ituulo lyoꞌkuyerekana ingoome. Haaho, atange na kirya kitiri kyeꞌmikate mizira saama, kuguma niꞌtuulo lyoꞌmushyano, niꞌtuulo lyeꞌdivaayi. ");
INSERT INTO flr_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","«Ku yikyo kyanya, ulya Mutaluule akwaniini agende ha mulyango gwiꞌheema lyeꞌmihumaanano, anabegwe umushaku gwage gwo âli mali taluula imwa Nahano, anagulashe ku muliro, ngiisi ho ali mu yokera ituulo lyoꞌkuyerekana ingoome. ");
INSERT INTO flr_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","«Ulya Mutaluule, iri angayusa ukubegwa umushaku gwage, umugingi agayabiira akalambwe ka kirya kipanga, anamúheereze ko. Na kwakundi, agayabiira umukate mu kitiri, neꞌbitumbula bizira saama, anamúfumbase byo. ");
INSERT INTO flr_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Birya byoshi, uyo umugingi anabilengeze imbere lyani mu kubindangira nie Nahano. Byoshi, bwo bikoli talwirwi, bigaaba bikola byeꞌmwage. Ha nyuma lya yibyo byoshi, ulya Mutaluule agaaba ahangwirwi ukushubi nywa idivaayi. ");
INSERT INTO flr_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","«Lwolwo, lwo lubaaja úluloziri Umutaluule. Bwo agaaba akoli talwirwi imwani, akwaniini ukundangira amatuulo. Neꞌri angaba aloziizi ukutanga ibyeꞌngingwe, akwaniini akwize indagaano zaage, ukukulikirana noꞌlubaaja lwoꞌkuyiyeruusa kwage.» ");
INSERT INTO flr_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","kwo agendi bwira Harooni na bagala baage kwokuno: «Mu kukizi gashaanira Abahisiraheeri, mukizi deta kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“Nahano akizi mùgashaanira, anakizi mùlanga. ");
INSERT INTO flr_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Akizi mùgirira bwija, iri anakizi mùyuvwirwa indengeerwa. ");
INSERT INTO flr_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Nahano akizi mùloleekeza, iri anamùleetera umutuula.” ");
INSERT INTO flr_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","«Harooni na bagala baage, ikyanya bagakizi gashaanira Abahisiraheeri mwene yuku, kwokwo kwo naani ngaaba keera nabagashaanira.» ");
INSERT INTO flr_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Ulusiku Musa akayusa ukushinga iheema lyeꞌmihumaanano, analitaluula imwa Nahano mu kulishiiga kwaꞌmavuta. Anataluula kiri neꞌbirugu byalyo byoshi, kuguma naꞌkatanda, neꞌbirugu byako. ");
INSERT INTO flr_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ha nyuma, abimangizi beꞌmilala yaꞌBahisiraheeri, banayegeera ukutanga amatuulo, banali bo baabalya ábakaharuura abandu. ");
INSERT INTO flr_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Banayija hiꞌheema lyeꞌmihumaanano, bagweti bagaleetera Nahano amagaare galindatu goꞌkubululwa, ágâli tumbikiirwi, kuguma neꞌshuuli ikumi na zibiri. (Ngiisi bimangizi babiri bakateekera igaare liguma-liguma. Na ngiisi mwimangizi, akaleeta ishuuli nguma-nguma yeꞌmwage.) ");
INSERT INTO flr_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Yago matuulo gaabo, ugayakiirage. Yago magaare, na yizo shuuli, ukizi bikoleesa ku mikolwa yiꞌheema lyeꞌmihumaanano. Ugabiheereza beene Laawi, bikizi batabaala mu mikolwa yabo.» ");
INSERT INTO flr_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Kwokwo, yago magaare, Musa anagayabiira, kuguma na yizo shuuli, anabiheereza Abalaawi. ");
INSERT INTO flr_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Beene Girishooni, anabaheereza amagaare gabiri neꞌshuuli zina, ukukulikirana neꞌmikolwa yabo. ");
INSERT INTO flr_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Beene Meraari, anabaheereza amagaare gana neꞌshuuli munaana, ukukulikirana neꞌmikolwa yabo. Hitamaari mugala umugingiHarooni, anaba ye gakizi shungika imikolwa yabyo. ");
INSERT INTO flr_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Halikago, ku luhande lwa beene Kohaati, Musa atakabaheereza kiri igaare liguma, kandi iri ishuuli nguma. Mukuba boohe, imikolwa yabo, bâli kizi betula ibikolanwa byeruusibwa ku bitugo byabo boonyene. ");
INSERT INTO flr_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Ku kyanya akatanda kakataluulwa mu kushiigwa kwaꞌmavuta, abimangizi banatanga amatuulo imbere lyako. ");
INSERT INTO flr_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Nahano anabwira Musa kwokuno: «Yako katanda, mu kukandaluulira, ngiisi mwimangizi agakizi yija, muguma-muguma ku lwage lusiku, gira ayiji tanga iryage ituulo.» ");
INSERT INTO flr_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Iyo milala, kwo yâli ikumi niꞌbiri, ngiisi kirongoozi kyâli kizi tanga gaago-gaago matuulo. Isahaani nguma-nguma íkatulwa mu bilo bishatu byeꞌharija, neꞌgarama magana gabiri na makumi gataanu. Noꞌmutanga muguma-muguma úgukatulwa mu kilo kiguma kyeꞌharija neꞌgarama magana galinda na makumi gataanu. Yibyo, bikulikiriini neꞌngerero za mwiꞌheema lyeꞌmihumaanano. Yizo sahaani neꞌyo mitanga, byoshi byâli yijwiri mwaꞌmatuulo goꞌmushyano mulembu, mufushe mwaꞌmavuta. Na kwakundi, hâli isahaani nguma-nguma íkatulwa mu garama igana niꞌkumi, zeꞌnooro, yanâli yijwiri mwoꞌmubadu. Ngiisi muguma wabo akatanga ituulo lyoꞌkusiriiza lwoshi, shuuli nguma-nguma yeꞌnjuuke, neꞌkipanga kiguma-kiguma, neꞌkyanabuzi kyoꞌmwaka muguma, kiguma-kiguma. Hâli niꞌtuulo lyoꞌkukogwa ibyaha, kihebe kiguma-kiguma, niꞌtuulo lyoꞌkuyerekana ingoome shuuli zibiri-zibiri, neꞌbipanga bitaanu-bitaanu, neꞌbibuzi bitaanu-bitaanu byoꞌmwaka muguma. Yabo bimangizi, bâli kulikiriini kwokuno: Ulusiku lwa mbere, hâli Nasooni mugala Haminadabu, woꞌmulala gwa Yuda. Ulusiku lwa kabiri, hâli Netaneeri mugala Swari, woꞌmulala gwa Hisakaari. Ulusiku lwa kashatu, hâli Heryabu mugala Helooni, woꞌmulala gwa Zabulooni. Ulusiku lwa kana, hâli Herizuuri mugala Shedeeri, woꞌmulala gwa Rubeni. Ulusiku lwa kataanu, hâli Shelumyeri mugala Shuri-Shadayi, woꞌmulala gwa Simyoni. Ulusiku lwa kalindatu, hâli Heryasafu mugala Deweri, woꞌmulala gwa Gaadi. Ulusiku lwa kalinda, hâli Herishama mugala Hamihudi, woꞌmulala gwa Hifurahimu. Ulusiku lwoꞌmunaana, hâli Gamalyeri mugala Pedashuri, woꞌmulala gwa Manaasi. Ulusiku lwoꞌmwenda, hâli Habidaani mugala Gidyoni, woꞌmulala gwa Binyamiini. Ulusiku lwiꞌkumi, hâli Ahyezeeri mugala Hamishadayi, woꞌmulala gwa Daani. Ulusiku lwiꞌkumi na luguma, hâli Pagweri mugala Hokarani, woꞌmulala gwa Hasheeri. Ulusiku lwiꞌkumi na zibiri, hâli Ahira mugala Henani, woꞌmulala gwa Nafutaali. ");
INSERT INTO flr_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Yabo bimangizi, amatuulo go bakatanga ku lulya lusiku lukulu, mu kutaluula akatanda, umuharuuro gwo gwoguno: Isahaani ízikatulwa mu harija ikumi na zibiri, neꞌnzoozo zeꞌharija, zoꞌkubiika mwoꞌmuko ikumi na zibiri, neꞌbikombe íbikatulwa mu nooro ikumi na bibiri. ");
INSERT INTO flr_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Ngiisi sahaani yeꞌharija, yâli gweti ubuzito bweꞌbilo bishatu neꞌgarama magana gabiri na makumi gataanu. Na ngiisi kirembe, kyâli gweti ubuzito bweꞌkilo kiguma neꞌgarama magana galinda na makumi gataanu. Yibyo birugu byoshi, byâli gweti ubuzito bweꞌbilo makumi gabiri na bina, ukukulikirana neꞌngerero za mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Tulya turaaye ikumi na tubiri útukatulwa mu nooro, twâli yijwiri umubadu. Na ngiisi kaguma kâli noꞌbuzito bweꞌgarama igana ukukulikirana neꞌngerero za mwiꞌheema lyeꞌmihumaanano. Twoshi haguma, twâli gweti ubuzito bweꞌgarama kihumbi na magana gabiri. ");
INSERT INTO flr_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Ibitugwa byoshi íbikatangwa, gabe matuulo goꞌkusiriiza lwoshi, umuharuuro gwabyo, zâli shuuli ikumi na zibiri, neꞌbipanga ikumi na bibiri, neꞌbipanga bito byoꞌmwaka muguma ikumi na bibiri. Hanâli amatuulo goꞌmushyano, neꞌbihebe ikumi na bibiri íbikaleetwa biꞌtuulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Ku biloziri amatuulo goꞌkuyerekana ingoome, bakaleeta ishuuli makumi gabiri na zina, neꞌbipanga makumi galindatu, neꞌbihebe makumi galindatu, neꞌbipanga bito byoꞌmwaka muguma makumi galindatu. Yago matuulo go bakataluula, banagatanga ku katanda. ");
INSERT INTO flr_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Ku kyanya kyoshi Musa âli kizi yingira mwiꞌheema lyeꞌmihumaanano gira aganuule na Nahano, âli kizi yuvwa izu lyage. Lirya izu, lyâli kizi shaaga ha kati ka balya bamakerubi babiri ábakatulwa mu nooro. Bâli teresirwi ku Kajumba keꞌKihango. Ee! Ku yeyo njira, kwo Nahano âli kizi múganuuza. ");
INSERT INTO flr_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","kwo abwire Harooni kwokuno: «Ikyanya ugabiika galya matara galinda ku kiterekero, ugatereke, halinde gakizi molekera uluhande lweꞌmbere.» ");
INSERT INTO flr_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Harooni, anasimbaha, anagatereka bwija, gira gakizi molekera uluhande lweꞌmbere, nga kwo Nahano akagwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Yikyo kiterekero, kikatulwa mu nooro ukulyokera kwiꞌdako halinde ku mikombo. Kikatulwa ku bulenga, nga kwo Nahano akagwanwa ayereka Musa. ");
INSERT INTO flr_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Nahano, anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Bwobuno, uhandulage Abalaawi ku baabo Bahisiraheeri, unabayeruuse. ");
INSERT INTO flr_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ha nyuma, unabashangire kwaꞌmiiji, unababwire bayimwe ibyoya byoshi ku magala, banafule neꞌbyambalwa byabo, halinde baboneke kwo bakoli yerusiibwi lwoshi. ");
INSERT INTO flr_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","«Unababwire kwo bayabiire ishuuli nguma yeꞌnjuuke, kuguma niꞌtuulo lyoꞌmushyano mulembu, gunabe mufushe mwaꞌmavuta. Naawe, unayabiirage igindi shuuli yeꞌnjuuke, unagitange, gira lyo bakogwa ibyaha byabo. ");
INSERT INTO flr_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ha nyuma, unakuumanie Abahisiraheeri booshi, unabayereke Abalaawi imbere liꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Yabo Balaawi, ikyanya ugaaba keera wabaleeta imbere lyani, Abahisiraheeri bakwaniini bababiike kwaꞌmaboko. ");
INSERT INTO flr_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Haaho, Harooni anabiike yabo Balaawi imbere lyani, libe ituulo íryatangwa naꞌBahisiraheeri. Balya Balaawi, bakabuli tondeera ukungolera. ");
INSERT INTO flr_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","«Kwokwo, yabo Balaawi, banalambike amaboko gaabo ku mbanga za zirya shuuli zombi. Nguma igatangwa, libe ituulo lyoꞌkukogwa ibyaha. Neꞌyabo, libe ituulo lyoꞌkusiriiza lwoshi, gira Abalaawi bayeruusibwe, banabe bakoli tungiini imbere lyani, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","«Haaho yabo Balaawi, ubayimangike imbere lya Harooni na bagala baage, unalengeze amaboko, mu kubatanga imbere lyani. ");
INSERT INTO flr_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Kwokwo, kwo ugahandula Abalaawi ku bandi Bahisiraheeri, halinde babe beꞌmwani. ");
INSERT INTO flr_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","«Yabo Balaawi, ikyanya ugaaba keera wabayeruusa, unabe keera wabahandula babe beꞌmwani, lyo bangakoli yingiraga mwiꞌheema lyeꞌmihumaanano, banakizi ngolera mwo. ");
INSERT INTO flr_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","«Yabo Balaawi, mu baabo Bahisiraheeri, bakataluulwa kwo babe beꞌmwani ngana-ngana. Keera nꞌgatoola Abalaawi booshi, bakizi ba beꞌmwani, ho nangayabiira ifula zaꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Mukuba mu Bahisiraheeri, ifula zooshi ziri zeꞌmwani, baba bandu, kandi iri bitugwa. Yizo fula zaabo, nꞌgazibambala ku lulya lusiku nꞌgaminika ifula zooshi mu kihugo kyeꞌMiisiri. ");
INSERT INTO flr_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","«Halikago, ho nangáyabiiri yizo fula zaꞌBahisiraheeri, nanayabiira Abalaawi, kwo bazigomboole. ");
INSERT INTO flr_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Mu Bahisiraheeri booshi, keera nataluula Abalaawi kwo bakizi tabaala Harooni na bagala baage. Baganakizi kola mwiꞌheema lyeꞌmihumaanano, ahandu haꞌbaabo Bahisiraheeri. Bo baganakizi tanga amatuulo hiꞌgulu lyabo, gira ikyanya yabo Bahisiraheeri bagayegeera Ahandu Heeru, batayiji hanwa.» ");
INSERT INTO flr_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Kwokwo, Musa na Harooni, naꞌBahisiraheeri booshi, banataluula Abalaawi imwa Nahano, nga ngiisi kwo Nahano akabwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Abalaawi banayiyeruusa, banafula neꞌbyambalwa byabo. Ha nyuma, Harooni anabaleeta imbere lya Nahano, babe ngiꞌtuulo lyoꞌkulengezibwa imwage. Na kwakundi, anabayeruusa, gira lyo batungaana. ");
INSERT INTO flr_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ha nyuma, yabo Balaawi banatondeera umukolwa gwabo mwiꞌheema lyeꞌmihumaanano, banakizi tabaala Harooni na bagala baage. Kwokwo, kwo bâli kizi koleesa Abalaawi, nga ngiisi kwo Nahano akayereka Musa. ");
INSERT INTO flr_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Nahano anashubi bwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Abalaawi bakwiriiri bakizi gira kwokuno: Mu Balaawi, kutondeerera ku weꞌmyaka makumi gabiri niꞌtaanu neꞌngingwe, bakwaniini bakizi kola mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Neꞌkyanya bagaahisa imyaka makumi gataanu, bakwaniini baleke umukolwa, bataki shubi kola. ");
INSERT INTO flr_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Bangagenderera ukukizi tabaala abaabo Balaawi mwiꞌheema lyeꞌmihumaanano, si bataki hangwirwi ukukolera mwoꞌmukolwa boonyene. Kwokwo, kwo ukwaniini ukukizi tegekera Abalaawi imikolwa yabo.» ");
INSERT INTO flr_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ikyanya Abahisiraheeri bakahisa umwaka gwoshi bashaaziri mu kihugo kyeꞌMiisiri, mu mwezi gwa mbere gwoꞌmwaka gwa kabiri, Nahano anaganuuza Musa mwiꞌshamba lyeꞌSinaayi kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Ubwire Abahisiraheeri kwo bashambaalire ulusiku lukulu lweꞌPasaka ku kyanya íkikashungikwa. ");
INSERT INTO flr_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Yikyo kyanya, kali kabigingwe keꞌsiku ikumi na zina za gwoguno mwezi. Na mu kulushambaalira, bakwaniini bakizi simbaha ngiisi byo nꞌgababwira.» ");
INSERT INTO flr_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Iri Nahano akadeta kwokwo, Musa anabwira Abahisiraheeri kwo bashambaalire ulusiku lukulu lweꞌPasaka. ");
INSERT INTO flr_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Kwokwo, banalushambaalira yaho mwiꞌshamba lyeꞌSinaayi, kabigingwe koꞌlusiku lwiꞌkumi na zina zoꞌmwezi gwa mbere. Bakagira nga ngiisi kwo Nahano akabwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Haliko yulwo lusiku, Abahisiraheeri baguma batâli kwiriiri ukulushambaalira, bwo bâli koli yulubiiri hiꞌgulu lyoꞌkuhuma ku kirunda. Lwolwo lusiku, banagendera Musa na Harooni, ");
INSERT INTO flr_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","banabwira Musa: «Tukahuma ku kirunda, tunakoli yulubiiri. Kundu kwokwo, kituma kikagi tulahiziibwi kwo tutatangire Nahano amatuulo kuguma naꞌbiitu Bahisiraheeri ku kyanya kyo akashungika?» ");
INSERT INTO flr_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Na wa Musa, ti: «Mutee ndindira. Ngagendi ganuuza Nahano hiꞌgulu liinyu.» ");
INSERT INTO flr_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","kwo abwire Abahisiraheeri kwokuno: «Tudete nga muguma winyu, kandi iri muguma weꞌmbaga yinyu, angadwakala mu kuhuma ku kirunda, kandi iri angaba abalamiiri hala ku kyanya kyeꞌPasaka. Kundu kwokwo, mukwaniini mushambaalire Ipasaka yani, nie Nahano. ");
INSERT INTO flr_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","«Haliko, mugishambaalire mu mwezi gwa kabiri, kabigingwe mu zeezo siku ikumi na zina. Kirya kyanabuzi, mugakiliira kaako kalaaja, na yeyo mikate mizira saama. ");
INSERT INTO flr_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Hatanagire ibyokulya byayo byo mugalaaza, halinde shesheezi. Yikyo kitugwa, mutanakolwe kwo mwavuna kiri niꞌvuha lyakyo liguma. Lulya lusiku lweꞌPasaka, mu kulushambaalira, mukizi kulikiriza gaago mategeko gaalwo. ");
INSERT INTO flr_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","«Haliko, iri hangaba hali umundu úyiyerusiizi, anabe atabalamiri, uyo, iri atangalya Ipasaka, agatwibwa ngana mu Bahisiraheeri. Iri atangandangira ituulo ku kyanya íkishungisirwi, yenyene agayibetuza ikihano kyeꞌbyaha byage. ");
INSERT INTO flr_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","«Ibinyamahanga íbimùtuuziri mwo, iri byangasiima kwo nabyo bishambaalire ulusiku lukulu lwani lweꞌPasaka, bikwiriiri bikulikirize yerya migeeza, na zeezirya maaja zaayo. Yizo maaja, zo zeezirya ízigweti zigaakola ku binyamahanga, nga kwo zituula ziri mu kola neꞌmwinyu kwakundi.» ");
INSERT INTO flr_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Ku lusiku iheema lyeꞌmihumaanano likashingwa, ikibungu kyanajooka, kyanalibwikira. Mu bushigi, yikyo kibungu kyanaboneka nga nguliro yoꞌmuliro, kyanamoleka kwokwo halinde ku mukyo. ");
INSERT INTO flr_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Ukulyokera ku lulya lusiku, mwiꞌzuuba, yikyo kibungu kyâli kizi bwikira iheema. Na mu bushigi, kyanakizi boneka nga ngulumira yoꞌmuliro. ");
INSERT INTO flr_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Yikyo kibungu, ikyanya kyâli kizi nunga, lyeryo Abahisiraheeri banayami hongola ishumbi yabo, banakikulikire. Na ngiisi ho kyâli kizi gendi yimanga, ho na haaho nabo bâli kizi shubi shinga ishumbi yabo. ");
INSERT INTO flr_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Kwokwo, Abahisiraheeri bâli kizi yimuka ku burongoozi bwa Nahano. Na ku bwobwo burongoozi bwage, bâli kizi shubi shinga amaheema gaabo mu shumbi. Yikyo kibungu, ikyanya kyâli kizi beera hiꞌgulu liꞌheema, abandu banakizi shumbika haaho. ");
INSERT INTO flr_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ikyanya kiguma, yikyo kibungu kyâli kizi tinda hiꞌgulu liꞌheema. Kundu kwokwo, Abahisiraheeri batanalunguli yimuka yaho. Si bâli kizi simbaha Nahano. ");
INSERT INTO flr_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ikindi kyanya, yikyo kibungu kinabeere hiꞌgulu liꞌheema siku ngerwa naaho. Kwokwo, ku burongoozi bwa Nahano, bâli kizi shinga amaheema gaabo mu shumbi. Na ku bwobwo burongoozi bwage, banashubi kizi yimuka. ");
INSERT INTO flr_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ikindi kyanya, yikyo kibungu kyâli kizi beera hiꞌgulu liꞌheema ukutondeerera kabigingwe halinde shesheezi naaho. Kundu kwokwo, guba mulege-rege kandi iri bushigi, ikyanya kyâli kizi nunga, nabo lyo bâli kizi hongola ishumbi, banabunge. ");
INSERT INTO flr_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Kirya kibungu, hali ikyanya kyâli kizi beera kwiꞌheema siku zibiri, kandi iri mwezi muguma, kiri umwaka gwoshi. Ku yikyo kyanya, Abahisiraheeri bâli kwiriiri bakizi beera haaho, batanasheguuke. Halikago, iri kyangánuuziri, lyo bâli kizi genda. ");
INSERT INTO flr_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ku burongoozi bwa Nahano, lyo bâli kizi shumbika. Na ku bwobwo burongoozi bwage, banashubi kizi lyoka ho bashumbisiri. Kwokwo, kwo bâli kizi simbaha ngiisi kwo Nahano akabwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Uyabiirage iharija, unagitule mweꞌbibuga bibiri. Yibyo bibuga, mukizi bidihiriza mu kuhamagala abandu. Na kandi, mukizi bidihiriza, mu kuyerekana kwo bakola bagabungiisa ishumbi. ");
INSERT INTO flr_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","«Yibyo bibuga, ikyanya byombi bigadihirizibwa kinaliguma, kuli kudeta kwaꞌbandu booshi bagakizi kuumana imbere lyawe, ha mulyango gwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","«Haliko, iri mwangalasa kiguma naaho, kuli kudeta kwaꞌbimangizi baꞌBahisiraheeri naaho bo bagayiji kuumana imbere lyawe. ");
INSERT INTO flr_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","«Yibyo bibuga, ikyanya mugabidihiriza, haaho booshi ábashumbisiri uluhande lweꞌsheere, bakwaniini batondeerage ulugeezi. ");
INSERT INTO flr_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Neꞌkyanya mugashubi bidihiriza, kuli kudeta kwaꞌbandu boꞌluhande lweꞌkisaka, nabo banatondeere ukugenda. Yukwo kudihirizibwa kweꞌbibuga, kugakizi yerekana kwo bayimuke. ");
INSERT INTO flr_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","«Ikyanya mugakizi dihiriza ibibuga, mbu mukuumanie abandu, bikizi laka mu lindi-lindi izu. ");
INSERT INTO flr_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","«Yibyo bibuga, bagala Harooni naaho (kuli kudeta: abagingi), bo bakwaniini ukukizi bidihiriza. Yulu lubaaja, lugayama ho, mu bibusi biinyu byoshi. ");
INSERT INTO flr_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","«Neꞌkyanya mugaaba keera mwayingira mu kirya kihugo kiinyu, naꞌbagoma biinyu banayiji mùteera, muyami dihiriza ibibuga mu kukengulana. Lyeryo, Rurema Nahamwinyu agamùkengeera, anamùkize mu maboko gaabo. ");
INSERT INTO flr_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","«Na kwakundi, mukizi bidihiriza ku byanya kyoꞌbushambaale, nga ku siku ngulu zeꞌmbaluko yeꞌmyezi, na ku zindi siku ziinyu ngulu. Neꞌkyanya mugakizi tanga ituulo lyoꞌkusiriiza lwoshi, kandi iri lyoꞌkuyerekana ingoome, yibyo bibuga bigakizi ngengeeza kwo keera twanywana ikihango. Niehe, nie Nahano Rurema winyu.» ");
INSERT INTO flr_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Abahisiraheeri, bâli mali hisa umwaka muguma, noꞌmwezi muguma, neꞌsiku makumi gabiri, balyosiri i Miisiri. Ku lwolwo lusiku, ikibungu íkyâli riiri hiꞌgulu liꞌheema lyeꞌKihango, kyananunga. ");
INSERT INTO flr_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Haaho, yabo Bahisiraheeri banayimuka mwiꞌshamba lyeꞌSinaayi, banagenderera, halinde kirya kibungu kyanagendi yikira mwiꞌshamba lyeꞌParaani. ");
INSERT INTO flr_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Yukwo kubungiisibwa kwiꞌshumbi, kwo kwâli riiri kwa mbere, anali Nahano ye kahamuliza Musa kwo babunge. ");
INSERT INTO flr_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ibiso bya beene Yuda byo bikatangi genda, bali mwiꞌdako liꞌrembera lyabo. Nasooni mugala Haminadabu, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Na beene Hisakaari, Netaneeri mugala Swari, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Na beene Zabulooni, Heryabu mugala Helooni, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Haaho, banashinguula iheema lyeꞌmihumaanano. Yiryo iheema, beene Girishooni, na beene Meraari, bo bâli kizi libetula. Kwokwo, nabo banashokola injira. ");
INSERT INTO flr_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ibiso bya beene Rubeni, byanakulikira, bali mwiꞌdako liꞌrembera lyabo. Herizuuri mugala Shedeeri, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Na beene Simyoni, Shelumyeri mugala Shuri-Shadayi, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Na beene Gaadi, Heryasafu mugala Deweri, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Banakulikirwa na beene Kohaati. Yabo beene Kohaati, bo bâli betwiri ibirugu bitaluule. Neꞌkyanya bâli kizi hika mu shumbi lihyahya, banakizi gwana iheema lyeꞌmihumaanano keera lyashubi shingwa. ");
INSERT INTO flr_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Ibiso bya beene Hifurahimu, byanakulikira, bali mwiꞌdako liꞌrembera lyabo. Herishama mugala Hamihudi, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Na beene Manaasi, Gamalyeri mugala Pedashuri, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Na beene Binyamiini, Habidaani mugala Gidyoni, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Neꞌri hakatama, ibiso bya beene Daani byanakulikira, bali mwiꞌdako liꞌrembera lyabo. Bâli kizi genda inyuma lyaꞌbandi booshi, bwo bo bâli balaliizi baꞌbaabo. Ahyezeeri mugala Hamishadayi, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Na beene Hasheeri, Pagweri mugala Hokarani, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Na beene Nafutaali, Ahira mugala Henani, ye wâli barongwiri. ");
INSERT INTO flr_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Kwokwo, kwaꞌBahisiraheeri bâli kizi kulikirana, mu kulyoka ho batáshumbisiri. ");
INSERT INTO flr_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Musa, shevyala ye wâli Rehuweri, Umumidyani. Na Hobaabu, ye wâli mugala wage. Kwokwo, Musa anabwira ulya muramu wage: «Lolaga! Buno tugweti tugagenda ngiisi ho Nahano akatubwira kwo agatuheereza. Aaho! Yija tugendanwe. Tugakizi kugirira bwija. Si nyiitu, Rurema akatulagaania kwo agatugirira amiija!» ");
INSERT INTO flr_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobaabu anashuvya: «Nanga, e waliha! Tutangagendanwa. Si niehe, ngagalukira mu kihugo kiitu, na mu bandu biitu.» ");
INSERT INTO flr_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Musa anamúyinginga: «Utatusige, maashi! Si wehe, ukoli yiji ngiisi ho twangashumbika mwiꞌshamba. Kwokwo, wangaba we masu giitu. ");
INSERT INTO flr_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Iri twangagendanwa, ngiisi biija byo Nahano agakizi tuheereza, naawe, tugakizi bishangiira.» ");
INSERT INTO flr_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Kwokwo, yabo bandu banalyoka ku mugazi gwa Nahano i Sinaayi, banahisa isiku zishatu, bagweti bagagenda. Akajumba keꞌKihango, kanakizi genda imbere lyabo, gira kakizi baloogeza ho bagashubi shumbika. ");
INSERT INTO flr_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ikyanya bakalyoka mu lirya shumbi, ikibungu kya Nahano kyâli kizi barongoora mwiꞌzuuba. ");
INSERT INTO flr_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ngiisi kyanya akajumba kâli kizi tondeera ulugeezi, Musa anadete: «E Nahano, yimukaga! Abagoma baawe, bagwanwe keera bashaabuka. Banagwanwe bapuumuka imbere lyawe.» ");
INSERT INTO flr_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Neꞌkyanya kirya kibungu kyâli kizi yimanga, Musa anadete: «E Nahano Rurema, ugalukirage Abahisiraheeri, kwo bali kandaharuurwa.» ");
INSERT INTO flr_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Abahisiraheeri, banayuvwa kwo keera bahaha, kyanatuma bagakizi yidodombera Nahano. Iyo midodombo yabo, iri Nahano akagiyuvwa, anabarakarira bweneene. Kyanatuma agabatulagiza mweꞌnguba, yanayami jigiivya uluhande luguma lweꞌshumbi. ");
INSERT INTO flr_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Balya Bahisiraheeri, mbu babone kwokwo, banatondeera ukutakira Musa. Lyeryo, Musa naye anatakira Nahano bweneene. Gulya muliro gwanahota. ");
INSERT INTO flr_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Kwokwo, yaho handu, banahayinika iziina Tabeera. Mukuba, hoꞌmuliro gwa Nahano, gukabajigiivya mwo. ");
INSERT INTO flr_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Mu yabo Bahisiraheeri, mwâli riiri ibinyamahanga biguma, byanatondeera ukusara ibindi byokulya. Kyanatuma Abahisiraheeri bagashubi gira akamburugu, ti: «Ewe! Nga byangashobosiri, utuheereze inyama, tulye. ");
INSERT INTO flr_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ikyanya twâli riiri i Miisiri, twâli kizi vwajagira ifwi, neꞌmyungu, neꞌpasiteeke, neꞌpwaro, neꞌbitungulu, neꞌbitungulu-sumu. ");
INSERT INTO flr_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Halikago buno, tutakiri mu hesherwa. Ndaabyo byokulya byo tukiri mu longa, ítali yeno mana naaho.» ");
INSERT INTO flr_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Iyo mana, yâli riiri mbuto niini, íyâli shushiri amasike. ");
INSERT INTO flr_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Abandu bâli kizi genda bagagitoola, banayiji gishya ku lushyo, kandi iri bagihuula mu kishakulo. Ha nyuma, banagideeke, banagigire mweꞌbitumbula. Iyo mana, yâli kizi ba noꞌmwihulo nga gwa íbyakalangwa naꞌmavuta goꞌmuzehituuni. ");
INSERT INTO flr_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Yaho mu shumbi, ikyanya ikimi kyâli kizi yikira mwoꞌbushigi, neꞌmana nayo inakizi yika. ");
INSERT INTO flr_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Musa anayuvwa ngiisi kwaꞌbandu ba mu ngiisi mbaga bagweti bagalira-lira ha miryango yaꞌmaheema gaabo. Yukwo kulira, kwanaraakaza Nahano bweneene. Kiri na Musa, anayagalwa. ");
INSERT INTO flr_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Kwokwo, Musa anabwira Nahano: «Si ndi mukozi wawe! Aahago! Kituma kiki wambigulira kwoku? Kutagi kwo nakuyagaza, halinde umbetuze amalibu ga yaba booshi? ");
INSERT INTO flr_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Yaba bandu, ndali nie kababuta. Ndanali nie yishe. Aahago! Kituma kiki ugweti ugambwira kwo ngizi yama mbaheesiri, nga kwoꞌmulezi ali mu heeka umwana. Mbu na mbahise mu kihugo kyo ukaheereza bashokuluza baabo, mu kubabiikira indahiro. ");
INSERT INTO flr_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","«Yaka kanyegete kaꞌbandu, hayagi ho nangalongera inyama zoꞌkubayigusa? Si bagweti bagandakira, ti: “E maashi, utuheereze inyama, tulye.” ");
INSERT INTO flr_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Yaba bandu booshi, nienyene ndangahasha ukukizi bahahalira. Si mbwinagi kwo binzidohiiri bweneene. ");
INSERT INTO flr_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Iri wangakizi ndibuza kwokwo, nakuhuuna we kongwa we, bwangabiiri bwija uyami nyita ngana. Utaki ndekere mu yubu buhanya.» ");
INSERT INTO flr_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Ikyanya Musa akadeta kwokwo, Nahano anamúshuvya: «Mu yabo Bahisiraheeri, utoolage mwaꞌbashaaja makumi galinda, balya ábayijikiini kwo biri birongoozi mu baabo, banabe bali bakulu. Yabo bashaaja, ubaleetage mwiꞌheema lyeꞌmihumaanano, gira bayimange ha butambi lyawe. ");
INSERT INTO flr_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Lyeryo, ngamùshonooka mwo, ninamùganuuze. Umutima gwo nꞌgakuheereza, nabo ngabaheereza gwo. Kwokwo nabo, banakizi kutabaala, halinde lyo yubu burongoozi butakizi kuzidohera. ");
INSERT INTO flr_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","«Yabo bandu, ubabwire: “Si mugweti mugabululuka, ti: Nga byangashobosiri, utuheereze inyama, tulye. Ikyanya twâli tuuziri i Miisiri, kwo kukulu ku mwene yuku.” «“Aaho! Buno, Nahano keera amùyuvwa. Kwokwo, muyiyeruusagye, munayiringikanie. Mukuba, kusheezi Nahano akola agamùherezagya inyama. Yizo nyama, munaziyihaguule. ");
INSERT INTO flr_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Neꞌkyanya mugakizi zirya, lutagaaba lusiku luguma, kandi iri zibiri, kandi iri zitaanu, kandi iri makumi gabiri. ");
INSERT INTO flr_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Si mugaahisa umwezi gwoshi, mugweti mugaazilya. Haaho, imiraazi yazo, igakizi mùhuluka i mazuulu, halinde zinamùneke. Kundu Nahano ali hano mu kati kiinyu, haliko keera mwamúlahira. Munagweti mugatulagulira imbere lyage, ti: E balya, kituma kikagi tukalyoka i Miisiri.”» ");
INSERT INTO flr_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Musa anashuvya: «E Nahano, yaba bandu, bali mwaꞌbasirikaani bihumbi magana galindatu. Unagweti ugambwira kwo mbaheereze inyama zo bagaalya umwezi gwoshi. ");
INSERT INTO flr_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Aahago! Kundu twangabaaga inguuli nyingi zeꞌbibuzi na zeꞌngaavu, ka byangabayigusa? Na kundu twangabadubira ifwi zooshi za mu nyaaja, ka zangabakwira?» ");
INSERT INTO flr_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Nahano, ti: «E Musa, koꞌbushobozi bwani keera bukaniiha kwo? Buno ukola ugaabona iri igambo lyani liri lyoꞌkuli, kandi iri nanga.» ");
INSERT INTO flr_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Kwokwo, Musa anagendi menyeesa abandu ngiisi byo Nahano akamúbwira. Anakuumania balya bashaaja makumi galinda, anabayimangika, halinde banazunguluka iheema. ");
INSERT INTO flr_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Lyeryo Nahano anashonookaga mu bibungu, anaganuula na Musa. Gwogwo mutima úgwâli riiri mu Musa, anabaheereza gwo. Yabo bashaaja, iri gukabayingira mwo, banatondeera ukutanga ubuleevi. Haliko, bulya buleevi, bwâli riiri bwa yiryo liguma naaho. ");
INSERT INTO flr_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mu yabo bashaaja, babiri baabo, Heridaadi na Medaadi, bakasigala mu shumbi, batanagenda iwiꞌheema. Kundu kwokwo, ikyanya Umutima gukayijira abaabo, nabo gwanabayijira. Kwokwo, nabo, banatanga ubuleevi mu shumbi. ");
INSERT INTO flr_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Musore muguma gwanatibita, gwanabwira Musa: «Ewe! Heridaadi na Medaadi, haliira mu shumbi, bagweti bagatanga ubuleevi.» ");
INSERT INTO flr_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Lyeryo, Yoshwa mugala Nuuni, anabwira Musa: «E nahamwitu, ubabuze, maashi!» (Uyo Yoshwa, ye wâli kizi tabaala Musa, ukulyokera ubusore bwage.) ");
INSERT INTO flr_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Musa, ti: «Ka wanyuvwirwa uluugi? Bwangabiiri bwija, nga bandu booshi bangabiiri baleevi, gira Nahano abaheereze Umutima gwage.» ");
INSERT INTO flr_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ha nyuma, Musa na yabo bashaaja, banagalukira iwa shumbi. ");
INSERT INTO flr_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Ha nyuma, Nahano analeetaga ikihuhuuta kingi. Yikyo kihuhuuta, kyanahuusa bweneene ku nyaaja, kyanabalaza ulukuuli lweꞌngware, halinde zanagendi honera mu mbande zooshi zeꞌshumbi. Yizo ngware, ikyanya zikayilunda yo, zanahisa nga meetere nguma yeꞌkimango. Zanakwira hooshi-hooshi, ahandu hoꞌmundu angagenda ulusiku lwoshi. ");
INSERT INTO flr_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Abandu banahisa umulege-rege gwoshi, kiri noꞌbushigi, bagweti bagagendi zigwata. Yizo ngware, ngiisi mundu anayilundira ibitiri bihamu ikumi. Ha nyuma, banakizi zitala. ");
INSERT INTO flr_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Zirya nyama, ikyanya bâli ki gweti bagazikaaja, banaba batazi zimira, haaho Nahano anabarakarira bweneene, anabatibulira mweꞌkiija. ");
INSERT INTO flr_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Kyanatuma yaho handu, bagahayinika iziina Kiburooti-Hatava. Mukuba, ho bakaziikira abanamiiru booshi. ");
INSERT INTO flr_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Ha nyuma, banalyoka yaho i Kiburooti-Hatava, banahika i Haserooti, banashumbika yo. ");
INSERT INTO flr_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Ha nyuma, Miryamu bo na Harooni banatondeera ukuyidodombera Musa, mbu bwo Musa akayanga Umuhendyopiya-kazi. ");
INSERT INTO flr_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Kwo bali bombi, banadeta: «E balya, ka Nahano agweti agaganuula na Musa naaho? Si na nyiitu agweti agatuganuuza!» Ikyanya bakadeta kwokwo, Nahano anabiyuvwa. ");
INSERT INTO flr_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Uyo Musa, âli riiri mutuudu bweneene, ukuhima abandi bandu booshi ba mu kihugo.) ");
INSERT INTO flr_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Lyeryo, Nahano anabwira Musa na Harooni na Miryamu: «Kwo muli bashatu, mugendage halinde iwiꞌheema lyeꞌmihumaanano.» Neꞌri bakahika, ");
INSERT INTO flr_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Nahano anashonooka mu bibungu, anayimanga ha mulyango gwiꞌheema, anahamagala Harooni na Miryamu. Neꞌri bakayegeera, ");
INSERT INTO flr_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","anababwira: «Mutegage amatwiri. Mu kati kiinyu, iri nangabona mwoꞌmuleevi, ndi mu koleesa amabone, mu kuyimenyeesa imwage. Na ndi mu múganuuza ku njira yeꞌbirooto. ");
INSERT INTO flr_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Halikago, umukozi wani Musa, kutali kwokwo imwage. Yehe, ali mu ba mwemeera mu kukizi langa byoshi mu nyumba yani. ");
INSERT INTO flr_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Kyo kitumiri ngweti ngamúganuuza masu ku gandi, iri ninamúganuulira amagambo ku bweranyange, kutanali ku sakuuzo. Agweti agambona nga ngiisi kwo ndi. Aahago! Bwo ali mukozi wani, kituma kikagi mutayobohiri ukumúgamba?» ");
INSERT INTO flr_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Lyeryo, Nahano anabarakarira, anayigendera. ");
INSERT INTO flr_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Ikyanya ikibungu kikalyoka kwiꞌheema, ulya Miryamu anayiji boneka kwo keera adunduuka kwoꞌmubembe. Harooni, mbu amúkebagane, yoo, anabona kwo Miryamu keera abemba. ");
INSERT INTO flr_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Kyanatuma Harooni agayinginga Musa: «E nahamwitu, kino kyaha, twakigira mu kati koꞌbuhwija. Ku yukwo, utatuhaniirize, maashi! ");
INSERT INTO flr_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Utalekeerere Miryamu nga mundu úkabutwa akoli fwiri. Si uluhande luguma lwaꞌmagala gaage, lukoli boziri.» ");
INSERT INTO flr_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Kwokwo, Musa anatakira Nahano: «E Rurema, we kongwa umúkizagye.» ");
INSERT INTO flr_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Nahano anabwira Musa kwokuno: «Yishe, nga angamúfuhiiri amate ha malanga, ka atangahisiizi isiku zirinda, ahiiti ishoni? Aahago! Umúhulukize imbuga lyeꞌshumbi, anamale yeꞌsiku zirinda. Ha nyuma, unamúhanguule kwo ashubi galukira mu shumbi.» ");
INSERT INTO flr_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Kwokwo, uyo Miryamu anayimulwa mu shumbi, anahisa isiku zirinda, ali imbuga. Abandu batanaki lyoka yaho, halinde ukuhisa ku kyanya akagalukira kandi mu shumbi. ");
INSERT INTO flr_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ha nyuma, abandu banayimuka yaho i Haserooti, banagendi shumbika mwiꞌshamba lyeꞌParaani. ");
INSERT INTO flr_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Utumage abandu, bagendi gahiriza ikihugo kyeꞌKaanani. Yikyo kihugo, ngakiheereza abandu baani Abahisiraheeri. Mu ngiisi mulala, ulungike mweꞌkirongoozi kiguma-kiguma.» ");
INSERT INTO flr_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Kwokwo, Musa anatuma abagahirizi ukulyoka yaho mwiꞌshamba lyeꞌParaani. Yabo bagahirizi booshi, bâli riiri bakulu baꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","15","Naꞌmaziina gaabo, go gaaga: Mu beene Rubeni, hâli Shamuwa mugala Zakuri. Na mu beene Simyoni, hâli Shafaati mugala Hoori. Na mu beene Yuda, hâli Kalebu mugala Yefune. Na mu beene Hisakaari, hâli Higaari mugala Yusefu. Na mu beene Hifurahimu, hâli Hosheya mugala Nuuni. Na mu beene Binyamiini, hâli Paliti mugala Raafu. Na mu beene Zabulooni, hâli Gadyeri mugala Soodi. Na mu beene Manaasi, kwoꞌkudeta beene Yusefu, hâli Gaadi mugala Suusi. Na mu beene Daani, hâli Hamyeri mugala Gemali. Na mu beene Hasheeri, hâli Setuuri mugala Mikaheeri. Na mu beene Nafutaali, hâli Nabi mugala Wofiisi. Na mu beene Gaadi, hâli Gehuweri mugala Maki. ");
INSERT INTO flr_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Yabo bo bakulu baꞌBahisiraheeri, Musa akatuma, kwo bagendi gahiriza ikihugo kyeꞌKaanani. (Hosheya mugala Nuuni, Musa akamúyinika iziina lya Yoshwa.) ");
INSERT INTO flr_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Yabo bagahirizi booshi, ikyanya Musa akabatuma, anababwira: «Muzamukirage iriira munda i Negebu, munahike mu migazi. ");
INSERT INTO flr_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Mugendi yitegeereza ngiisi kweꞌkihugo kiri. Munalangiize iri abandu baamwo bali bihagarusi, kandi iri nanga. Munalole kwakundi, iri bangaba bali katundu, kandi iri bagerwa. ");
INSERT INTO flr_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Ikihugo kyabo, ka kiri kiija, kandi iri kibi? Noꞌtwaya twakyo, kuti tuli? Ka tuzungulusirwi neꞌnzitiro ngomu, kandi iri nanga? ");
INSERT INTO flr_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Yikyo kihugo, ka kihiiti inagiira, kandi iri ndaayo? Ka hali ibiti, kandi iri ndaabyo? Ikyanya mugagaluka, mugire umwete gwoꞌkugalukana neꞌmimbu.» (Yikyo kyanya, imizabibu yâli koli tondiiri ukuyera.) ");
INSERT INTO flr_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Kwokwo, yabo bagahirizi banazamuuka, banagendi gahiriza ikihugo, ukulyokera mwiꞌshamba lyeꞌSiini, halinde i Rehobu, mu njira yoꞌkugenda i Hamaati. ");
INSERT INTO flr_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Banalenga mu Negebu, banagenderera halinde i Heburooni. Iri bakahika ho, banagwana beene Ahimaanu, na Shesayi, na Talimaayi. Yabo, bo bakakomooka ku Hanaaki. (Yako kaaya keꞌHeburooni, kakahisa imyaka irinda kayubasirwi, ku kyanya akaaya keꞌSowani, ka mu kihugo kyeꞌMiisiri, kakatondeera ukuyubakwa.) ");
INSERT INTO flr_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Yabo bandu, iri bakahika mu ndekeera yeꞌHeshikooli, banatema itavi lyoꞌmuzabibu íryâli hembiri bweneene. Banalishwekera ku kiti kyoꞌkubetulira, gira abandu babiri bakizi libetula. Banatwala neꞌbitumbwe byaꞌmakoma-manga, na byoꞌmutiini. ");
INSERT INTO flr_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Yaho handu, íbikatuma bagahahamagala Heshikooli, bwaꞌBahisiraheeri bakahagwana lirya itavi, banalitema. ");
INSERT INTO flr_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Yabo bagahirizi, iri bakahisa isiku makumi gana bagweti bagagahiriza ikihugo, ");
INSERT INTO flr_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","banagalukira mwiꞌshamba lyeꞌParaani, imunda Musa na Harooni, kiri naꞌbandi Bahisiraheeri booshi, kwo bâli shumbisiri i Kadeeshi. Banaganuulira booshi ngiisi byo bakabona mu kihugo, banabayereka neꞌmbuto zaakyo. ");
INSERT INTO flr_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Banabwira Musa: «Yikyo kihugo kyo utátutumiri mwo, twakiyingira mwo, twanabona kwo kiyeziri mwaꞌmata, noꞌbuuki. Neꞌmbuto zaamwo, zeezino. ");
INSERT INTO flr_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Si abatuulaga baamwo, yehee! Balyagagi bihagarusi bweneene. Noꞌtwaya twabo, tudediiri, tunali tuhamu. Iyo munda, tukabona kiri naꞌBahanaaki. ");
INSERT INTO flr_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","«Ha Negebu, hatuuziri Abahamareki. Na mu migazi, mutuuziri Abahiti, naꞌBayebuusi, naꞌBahamoori. Na ku Nyaaja Mediterane, kutuuziri Abakaanani. Baabo, batuuziri na ha butambi lyoꞌlwiji Yorodaani.» ");
INSERT INTO flr_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Balya Bahisiraheeri kwo bâli yimaaziragi imbere lya Musa, banatondeera ukuyidodomba. Lyeryo, Kalebu anagira mbu abahoohye, ti: «Nanga, maashi! Kiriira kihugo, tuyami gendi kigwata. Tugaahasha ma!» ");
INSERT INTO flr_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Balya baabo bagahirizi, banalahira: «Aahabi! Tutangagendi bateera. Si balyagagi bihagarusi bweneene, ukutuhima.» ");
INSERT INTO flr_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Balya bagahirizi, banalumbuusa ibibeesha mu Bahisiraheeri, ti: «Kirya kihugo, ikyanya tukakigahiriza, twanabona kwo ngiisi ábatuuziri mwo, kigweti kigaabalya. Neꞌri tukalola abandu baakyo, twanabona kwo bali bifigisi bweneene. ");
INSERT INTO flr_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","E maashi, tukabona ibihagarusi byaꞌBahanaaki. Twehe imbere lyabo, tushuba mu yibonekera nga tuhaazi. Nabo kwakundi, kwokwo kwo bashuba mu tubona.» ");
INSERT INTO flr_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Lwolwo lusiku mu bushigi, yabo Bahisiraheeri booshi banatondeera ukubululuka ku kimombo. ");
INSERT INTO flr_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Yabo booshi kuguma, banakizi yidodombera Musa na Harooni, ti: «Bwangabiiri bwija tukamire i Miisiri, kandi iri, tukamire haahano mwiꞌshamba. ");
INSERT INTO flr_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Aahago! Kituma kiki Nahano atuleeta hano? Si tugagendi malira mwiꞌzibo! Na ku luhande lwa bakiitu naꞌbaana biitu boohe, bagagendi gwatwa imbira. E balya, ka tutangashubi galukira i Miisiri? Ka kutali kwo kukulu?» ");
INSERT INTO flr_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Haaho, banatondeera ukuhanuusania, ti: «Tutoolage ikindi kirongoozi, gira tushubi galukira i Miisiri.» ");
INSERT INTO flr_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Lyeryo, Musa na Harooni banagwa buubi imbere lyaꞌBahisiraheeri booshi. ");
INSERT INTO flr_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yoshwa mugala Nuuni, na Kalebu mugala Yefune, nabo bâli riiri mu yabo bagahirizi. Yabo bombi, banadaatula imirondo yabo. ");
INSERT INTO flr_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Yabo bombi, banabwira Abahisiraheeri: «Ikyanya tukagendi gahiriza ikihugo, twanabona kwo kiri kiija ngana. ");
INSERT INTO flr_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Iri twangasimiisa Nahano, agaturongoora mu kati kaakyo, anatuheereze kyo. Emwe! Mu kirya kihugo, kiyeziri mwaꞌmata, noꞌbuuki. ");
INSERT INTO flr_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Byo ngamùhuuna naaho, mutakolwe mbu muhune imbere lyage. Balya batuulaga baamwo, mutabayobohe. Si tugakizi bamira, nga shogo. Ngiisi byo bashuba mu yegamira kwo, bitakiri ho. Si twehe, Nahano tuyamiinwi. Kwokwo, mutaki bayobohe.» ");
INSERT INTO flr_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Yabo bombi, iri bakadeta kwokwo, balya Bahisiraheeri booshi banatondeera ukudeta: «E balya, tuyami bavurumika amabuye.» Lyeryo, ubulangashane bwa Nahano bwanaboneka hiꞌgulu liꞌheema lyeꞌmihumaanano, imbere lyaꞌBahisiraheeri booshi. ");
INSERT INTO flr_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Haahago, Nahano anabwira Musa: «Balya bandu, bagakizi ngayiriza halinde mangoki? Ka batâye mbiike kwoꞌmulangaaliro? Si nâli kizi gira ibitangaaza bya kwingi-kwingi mu kati kaabo. ");
INSERT INTO flr_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Halikago buno, ngola ngabatibulira mweꞌkiija, kinabaminike. Si wehe, ngakuvyula mwoꞌgundi mulala muhamu, úgubahimiri imisi.» ");
INSERT INTO flr_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ulya Musa, ti: «E Nahano, si ukakoleesa ubushobozi bwawe, mu kubalyosa mu kihugo kyeꞌMiisiri. Neꞌri wangabaminika, Abamiisiri bagayuvwa. ");
INSERT INTO flr_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Lyeryo, banayami menyeesa abatuulaga ba mu kino kihugo. Mukuba, yabo batuulaga, keera bakalonga imyazi kwo uli kuguma na nyiitu. E Nahano, bayuvwiti kwo uli mu boneka masu ku gandi. Bayuvwiti na kweꞌkibungu kyawe kiri mu beera hiꞌgulu liitu, na kwo ku kyanya kiꞌzuuba, ugweti ugatanga imbere liitu mu nguliro yeꞌkibungu. Na bushigi, ugweti ugatutanga mu nguliro yoꞌmuliro. ");
INSERT INTO flr_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","«Kwokwo, yaba Bahisiraheeri, iri wangayami bayitaga, ibinyamahanga bigayuvwa, binadete: ");
INSERT INTO flr_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","“Nahano keera akamalira abandu baage mwiꞌshamba. E balya, si ayabiirwi noꞌkubahisa mu kihugo kyo akabalagaania ku ndahiro.” ");
INSERT INTO flr_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","«Kwokwo e Nahano, utuyerekage ubushobozi bwawe, nga kwo ukatulagaania, ti: ");
INSERT INTO flr_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","“Nahano atali mu raakara mulindi-mulindi. Si ali munandengeerwa nyingi. Ali mu koga ibyaha, kiri noꞌbuhuni. Kundu kwokwo, ngiisi ábali naꞌmahube, atali mu balekeerera. Si ikyanya abandu bagweti bagahuba, ali mu hana abaana baabo, kiri na bijukulu baabo, halinde ukuhisa ku kibusi kya kashatu, neꞌkya kana.” ");
INSERT INTO flr_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","E Nahano, yaba bandu, wâli kizi bakejeerera, ukulyokera ikyanya bakalyoka i Miisiri, halinde buno. Ku yukwo, bwo uhiiti urukundo lwingi, ushubi bakoga ibyaha byabo kandi.» ");
INSERT INTO flr_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Nahano anamúshuvya: «Ukubakoga, nangabakoga, nga kwo wambuuna. ");
INSERT INTO flr_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Haliko, nga kwo ndyagagi mugumaana, na nga kweꞌkihugo kyoshi kiyijwiragi mwoꞌbulangashane bwani, ");
INSERT INTO flr_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ndaaye kiri noꞌmuguma wabo úgayingira mu kiriira kihugo. Yabo bandu, si keera bakabona ubulangashane bwani, na ngiisi kwo nâli kizi gira ibisoomeza mu Miisiri, kiri na mwiꞌshamba. Kundu kwokwo, bagenderiiri ukukizi ngayiriza, iri banangeza ubugira kingi. ");
INSERT INTO flr_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Kwokwo, ndaaye kiri noꞌmuguma wabo úgaabona ikihugo kyo nꞌgalagaania bashokuluza baabo, mu kubiika indahiro. Bwo bagweti bagangayiriza, ndaaye kiri noꞌmuguma wabo úgakibona. ");
INSERT INTO flr_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","«Haliko, umukozi wani Kalebu, yehe atali ngaꞌbaabo. Si agweti aganzimbaha ku mutima gwage gwoshi. Kwokwo, kiriira kihugo, ngamúyingiza mwo. Naꞌba mwiꞌkondo lyage, banayiji kihyana. ");
INSERT INTO flr_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","«Abahamareki naꞌBakaanani, batuuziri mu ndekeera. Ku yukwo, kusheezi mugalukage inyuma, munakulikire injira íri mu lenga mwiꞌshamba, halinde iwa Nyaaja Ndukula.» ");
INSERT INTO flr_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Ha nyuma, Nahano anabuuza Musa na Harooni: ");
INSERT INTO flr_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Bano banangora-mabi, bagagenderera ukunyidodombera halinde mangoki? Si keera nꞌgayuvwa midodombo yabo. ");
INSERT INTO flr_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ku yukwo, ugendi babwira: “Nga kwo ndyagagi mugumaana, amagambo go mugweti mugaadeta, go na gaago ngamùgirira. ");
INSERT INTO flr_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Yabo booshi, bwo bakanyidodombera hano mwiꞌshamba, mwomwo, mwo baganafwira, ukulyokera ku mushosi weꞌmyaka makumi gabiri, nga kwo bakaharuurwa. ");
INSERT INTO flr_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Mu kati kiinyu, ndaaye úgayingira mu kihugo kyo nꞌgamùheereza mu kubiika indahiro, átali Kalebu mugala Yefune naaho, na Yoshwa mugala Nuuni. ");
INSERT INTO flr_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","«“Mwadeta kwaꞌbaana biinyu bagagendi gwatwa imbira. Nanga! Si boohe, bo ngayingiza mu kiriira kihugo. Balya baana, bagakizi kishambaalira, kundu mwe babusi baabo mukakilahira. ");
INSERT INTO flr_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Mwehe, mu lyerino ishamba, mwo mugaherera. ");
INSERT INTO flr_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","«“Yabo baana biinyu, bagaahisa imyaka makumi gana, bagweti bagajeba-jeba mwiꞌshamba, halinde ku kyanya mweshi mugaaba keera mwafwira mwo. Na íbitumiri bagakizi libuuka kwokwo, bwo mutâli riiri bemeera imwani. ");
INSERT INTO flr_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","«“Balya bagahirizi, ikyanya bâli kizi gahiriza ikihugo, bakahisa isiku makumi gana. Kwo na kwokwo, mugaahisa yeyo myaka makumi gana, mugweti mugalibuuka hiꞌgulu lyeꞌbyaha biinyu. Neꞌkyanya mugalibuuka, lyo mugayiji menya kwo ngola mugoma winyu. ");
INSERT INTO flr_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nie Nahano, keera nakyula. Si mweshi mukayibiika kuguma mu kukizi ndahira. Kwokwo, ku kasiisa yibyo byoshi, ngamùgirira byo. Mweshi mugamalira mwomuno mwiꞌshamba. Ndaanakwo kundi.”» ");
INSERT INTO flr_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Balya bandu bo Musa âli tumiri kwo bagendi gahiriza kirya kihugo, bo bakayiji tuma Abahisiraheeri booshi bagayidodombera Nahano. ");
INSERT INTO flr_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Yabo bagahirizi, bwo bakaleeta imishahu yeꞌbibeesha, Nahano anabaminika. ");
INSERT INTO flr_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Mu bandu ábâli geeziri iwa kugahiriza ikihugo, hali Yoshwa mugala Nuuni, na Kalebu mugala Yefune naaho, bo bakasigala. ");
INSERT INTO flr_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ikyanya Musa akaganuulira Abahisiraheeri ngiisi byo Rurema adesiri, banakizi bululuka ku kimombo. ");
INSERT INTO flr_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Neꞌri bukakya, banavyuka kare-kare, banazamuukira mu migazi, iri banadeta: «E waliha, twayemeera maashi, kwo tugiziri ibyaha. Kundu kwokwo buno, tukolaga tugagendi gwata ngiisi ho Nahano akatulagaania.» ");
INSERT INTO flr_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Musa, ti: «Nanga! Amategeko ga Nahano, si mukagabambala! Kwokwo, mugayabirwa ngana. ");
INSERT INTO flr_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Mutakolwe kwo mwazamuukira mu migazi, maashi! Bwo Nahano atakiri kuguma na niinyu, abagoma biinyu bagayiji mùmalira yo. ");
INSERT INTO flr_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Bwo keera mukajanda Nahano Rurema, mutagaki yamanwa mwe naye. Si Abahamareki naꞌBakaanani bakola bagayiji mùlwisa, banamùminike ku ngooti.» ");
INSERT INTO flr_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Kundu Musa akadeta kwokwo, halikago yabo Bahisiraheeri banayumuusa imitima yabo, banazamuukira mwiꞌyo migazi. Si Musa yehe, akasigala mu shumbi. Kiri naꞌKajumba keꞌKihango kya Nahano, nako kakasigala mwo. ");
INSERT INTO flr_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Yabo Bahisiraheeri, iri bakahika mwiꞌyo migazi, lyeryo balya Bahamareki naꞌBakaanani banamanuka, gira bayiji balwisa. Neꞌri bakabateera, banabatibita kwo, halinde mu kaaya keꞌHorima. ");
INSERT INTO flr_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Nahano anaganuuza Musa, ");
INSERT INTO flr_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","kwo abwire Abahisiraheeri kwokuno: «Mwâye tuule mu kihugo kyo nimùhiiri. ");
INSERT INTO flr_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Neꞌkyanya mugaaba mukoli kituuziri mwo, mukakizi nzimiisa, ku njira yoꞌmushiiriri gweꞌbitugwa byo mugandangira. Yago matuulo, gagakizi shaaga mu nguuli zeꞌbitugwa biinyu. Bikizi ba kwokwo, iba ku matuulo goꞌkusiriiza lwoshi, kandi iri ku goꞌkukwiza byo mukandagaania, kandi iri ku ágatangwa nga kwoꞌmundu aloziizi, kandi iri ku geꞌbyanya byeꞌsiku ngulu ziinyu. ");
INSERT INTO flr_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","«Kwokwo, ngiisi úgaleetera Nahano ituulo, akizi múleetera neꞌlitiri nguma yoꞌmushyano mulembu, kuguma neꞌlitiri nguma yaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Na kwakundi, ikyanya mugatanga ituulo lyeꞌkyanabuzi, mulingaanie ilitiri nguma yeꞌdivaayi. ");
INSERT INTO flr_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","«Neꞌkyanya mugakizi tanga ituulo lyeꞌkipanga, utwalage ibilo bibiri byoꞌmushyano mufushe mweꞌlitiri nguma neꞌkitolo yaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Munatange neꞌlitiri nguma neꞌkitolo yeꞌdivaayi. Yago matuulo, ikyanya mugagatanga, umushiiriri gwago gugakizi simiisa Nahano. ");
INSERT INTO flr_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","«Hali ikyanya mugakizi tangira Nahano ishuuli, libe ituulo lyoꞌkusiriiza lwoshi, gira likwize ngiisi byo mukalagaania, kandi iri libe ituulo lyoꞌkuyerekana ingoome. ");
INSERT INTO flr_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Iyo shuuli, mukizi gitanga kuguma niꞌtuulo lyeꞌbilo bishatu byoꞌmushyano, neꞌlitiri zibiri zaꞌmavuta. ");
INSERT INTO flr_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Na kandi, muleetage ilitiri zibiri zeꞌdivaayi. Yago matuulo, ikyanya mugagatanga, umushiiriri gwago gugakizi simiisa Nahano. ");
INSERT INTO flr_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","«Ikyanya mugakizi tanga ituulo lyeꞌshuuli, kandi iri lyeꞌkipanga, kandi iri lyeꞌkihebe, hali amategeko go mukwaniini ukukulikira. ");
INSERT INTO flr_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ku ngiisi ituulo lyo mugatanga, mukizi gira kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Ngiisi úyimbwa Muhisiraheeri nirizina, ikyanya agakizi tanga ituulo lyoꞌkusiriiza, akwiriiri akulikire yizi maaja. Yago matuulo, ikyanya agagatanga, umushiiriri gwago gugakizi simiisa Nahano. ");
INSERT INTO flr_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","«Mu kati kiinyu, iri mwangaba muli ikinyamahanga, kinabe kiloziizi kwo nakyo kitange ituulo, kikwaniini kikizi gira nga kwokulya niinyu mugweti mugaagira. Yago matuulo, ikyanya kigagatanga, umushiiriri gwago gugakizi simiisa Nahano. ");
INSERT INTO flr_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","«Yizo maaja, zigayama ho, halinde ku bibusi byoshi íbigaki yija. Kwokwo, mwehe, kuguma neꞌbinyamahanga íbimùtuuziri mwo, mweshi mugakizi kulikira zeezo-zeezo maaja, imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Mwe na yibyo binyamahanga, mukwaniini ukukizi kulikira gaago-gaago mategeko.» ");
INSERT INTO flr_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Nahano anaganuuza Musa, ");
INSERT INTO flr_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","kwo abwire Abahisiraheeri na kwokuno: «Ikyanya mugayingira mu kihugo kyo ngamùrongoora mwo, ");
INSERT INTO flr_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ngiisi kyanya mugakizi lya ibitumbwe byamwo, mutee kizi ndomoza. ");
INSERT INTO flr_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ikyanya mugakizi shya umushyano, mutee ndomoza mu kutanga umukate, libe ituulo lya mu biyeluuliro biinyu. ");
INSERT INTO flr_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Yiryo ituulo, mu bibusi biinyu byoshi íbigaki yija, mukizi lindangira. ");
INSERT INTO flr_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","«Yizo maaja zo nꞌgaheereza Musa, hali ikyanya mugahubira nguma zaazo, buzira kugiriirira. ");
INSERT INTO flr_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Tudetage kwo baguma mu bibusi biinyu batangakulikira byoshi byo nꞌgabwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Iri umundu angagira ikyaha buzira kugiriirira, naꞌbandi Bahisiraheeri batashubi yiji kwo akigira, kwokwo, yabo booshi batangage ishuuli nguma. Ikyanya bagagisiriiza, umushiiriri gwayo, gugasimiisa Nahano. Haaho-haaho, banatange niꞌtuulo lyoꞌmushyano, na lyeꞌkinywebwa, nga kweꞌmaaja zidesiri. Batange neꞌkihebe kiguma, libe ituulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Bwo yikyo kyaha kitali kya kugiriirira, banabe keera baleeta amatuulo gaabo goꞌkusiriiza imbere lya Nahano, kuguma niꞌtuulo lyoꞌkukogwa ibyaha byabo, kwokwo umugingi ye gabanywaniisa na Rurema halinde banakogwe. ");
INSERT INTO flr_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Yabo Bahisiraheeri, kuguma neꞌbinyamahanga byo batuliinwi, booshi bakayikululira umwama. Kwokwo, na booshi bagaakogwa. ");
INSERT INTO flr_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","«Iri umundu muguma naaho angagira ikyaha buzira kugiriirira, akwiriiri atange ishaashi yeꞌmbene yoꞌmwaka muguma, libe ituulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Bwoꞌyo mundu akagira ikyaha buzira kugiriirira, umugingi agamúnywaniisa kuguma na Nahano, halinde anakogwe. ");
INSERT INTO flr_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Yulwo lubaaja, ludesiri hiꞌgulu lya ngiisi úkagira ikyaha buzira kugiriirira, aba Muhisiraheeri nirizina, kandi iri ikinyamahanga kyo mutuliinwi. ");
INSERT INTO flr_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","«Haliko, ngiisi úgaaba agweti agaagira ikyaha mu kugiriirira, yehe agaaba atuka Nahano, aba Muhisiraheeri nirizina, kandi iri kinyamahanga, uyo mundu, akwiriiri atwibwe mu bandu ba Nahano. ");
INSERT INTO flr_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Mukuba, agaaba alahira Igambo lya Nahano, anabe ahongwiri neꞌmaaja zaage. Uyo mundu, agaaba ayikululira umwama, anakwaniini atwibwe mu Bahisiraheeri.» ");
INSERT INTO flr_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ikyanya Abahisiraheeri bâli ki riiri mwiꞌshamba, banabona umundu muguma agweti agasheenya ku lusiku lweꞌSabaato. ");
INSERT INTO flr_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Uyo mundu, banamútwala imbere lya Musa na Harooni, naꞌBahisiraheeri booshi. ");
INSERT INTO flr_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Banatee múbiika mu nyumba yeꞌmbohe, bwo batâli yiji ngiisi kwo bakwaniini ukumúgira. ");
INSERT INTO flr_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Haaho, Nahano anabwira Musa kwokuno: «Uyo mundu, akwaniini ayitwe. Abahisiraheeri booshi, bamútwalage inyuma lyeꞌshumbi, banamúyitire yo, mu kumúlasha amabuye.» ");
INSERT INTO flr_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Lyeryo, balya bandu banamúhalamulira inyuma lyeꞌshumbi, banakizi múvurumika kwaꞌmabuye, halinde anafwa. Kwokwo, kwo Nahano akabwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Nahano anaganuuza Musa, ");
INSERT INTO flr_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","kwo abwire Abahisiraheeri kwokuno: «Abandu bakizi biika iminaganizo ku makano geꞌmirondo yabo. Iyo minaganizo, mukizi ginanika neꞌnuzi ya namukungumo. Yulu lubaaja, lugayama ho mu bibusi byoshi íbigaki yija. ");
INSERT INTO flr_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","«Iyo minaganizo, ikyanya mugagibona, mugakizi kengeera imaaja zooshi za Nahano. Mukizi zisimbaha, buzira kukizi yifwija íbibishirwi mu mitima yinyu mwenyene, kandi iri mu masu giinyu. ");
INSERT INTO flr_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Kwokwo, lyo mugakengeera ukusimbaha imaaja zaani zooshi, halinde munabe bandu baani bataluule. ");
INSERT INTO flr_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Nie Nahano Rurema winyu. Nie kamùlyosa mu kihugo kyeꞌMiisiri, gira lyo mba Rurema winyu. Niehe, nie Nahano Rurema winyu.» ");
INSERT INTO flr_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Mu Balaawi, mwâli riiri mugala Hishaari, mwijukulu Kohaati, iziina lyage ye Koora. Uyo Koora, lusiku luguma akahuna imbere lya Musa. Anayibiika ku Datani bo na Habiraamu, bagala Heryabu, ba mu mulala gwa Rubeni, anayibiika na ku Honi mugala Pereeti. ");
INSERT INTO flr_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Yabo booshi, banayibiika kuguma naꞌbaabo bakulu magana gabiri na makumi gataanu, ábâli yijikiini mu Bahisiraheeri kwo bo bimangizi. ");
INSERT INTO flr_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Yabo booshi, banayiguga imbere lya Musa na Harooni, banababwira: «Keera mwakavya. Si Abahisiraheeri booshi balyagagi bataluule! Ngiisi muguma wabo, Nahano bayamiinwi. Aahago! Kutagi mwehe mugweti mugayikuza, ukuhima abandi bandu booshi ba Nahano?» ");
INSERT INTO flr_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Uyo Musa, mbu ayuvwagwe kwokwo, anayami gwa buubi. ");
INSERT INTO flr_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Haaho, anabwira Koora naꞌbakulikizi baage booshi: «Kusheezi shesheezi, Nahano agayerekana ngiisi ábali beꞌmwage, banabe bakoli talwirwi imwage. Yabo bataluule, anabahanguule kwo bayimange imbere lyage, kwo ali mweru. ");
INSERT INTO flr_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Aahago! Wehe Koora, mwe na yaba bakulikizi baawe, kusheezi ngiisi muguma winyu aleete isheetezo, ");
INSERT INTO flr_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","munagibiike kwaꞌmakala ágayasiri, munagafuke kwoꞌmubadu. Kwokwo, lyo tugaabona ngiisi ye Nahano atooziri, kwo abe mutaluule. Si niinyu mwe Balaawi, keera mwakavya.» ");
INSERT INTO flr_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Musa anashubi bwira Koora: «E Balaawi, mundegage amatwiri. ");
INSERT INTO flr_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Rurema waꞌBahisiraheeri, keera akamùtaluula mu biinyu Bahisiraheeri booshi, anamùgira mukizi múyegeera, iri munamúkolera mwiꞌheema lyage Litaluule. Munakizi yimanga imbere lyaꞌBahisiraheeri, munabakolere. Aaho! Bikagi bindi byo muki loziizi? ");
INSERT INTO flr_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Si Rurema keera akamùyegeza imwage, mwe naꞌbiinyu Balaawi booshi. Ka mukoli loziizi kiri noꞌmukolwa gwoꞌbugingi? ");
INSERT INTO flr_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Kwokwo, atali Harooni ye mugweti mugayidodombera. Si mwe naꞌbakulikizi biinyu, mugweti mugalahira Nahano yenyene.» ");
INSERT INTO flr_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Lyeryo, Musa anabwira Datani, na Habiraamu bagala Heryabu, kwo bayije. Halikago, banalahira, ti: ");
INSERT INTO flr_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","«Ewe! Si ukatulyosa i Miisiri, yanâli yeziri amata noꞌbuuki. Na buno, ukoli loziizi ukutumalira hano mwiꞌshamba. Aaho! Ka uloziizi ukutuvindagaza ku kahaati. ");
INSERT INTO flr_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Na kwakundi, utazi tuhisa mu kihugo íkiyeziri mwaꞌmata noꞌbuuki. Tutanazi hyana amatongo, kandi iri indalo zeꞌmizabibu. Aahago! Ka ugagenderera ukutuhendereza? Nanga! Twehe, tutagayija.» ");
INSERT INTO flr_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Musa, mbu ayuvwagwe kwokwo, anaraakara bweneene, anabwira Nahano: «Utayakiire amatuulo gaabo. Si mu kati kaabo, ndaaye ye nzindi nyaga kiri punda wage. Ndaanaye muguma wabo ye nzindi hubira.» ");
INSERT INTO flr_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Kwokwo, Musa anabwira Koora: «E Koora, mwe naꞌbakulikizi baawe! Muyijage imbere lya Nahano kusheezi. Kiri na Harooni naye, agaaba ali ho. ");
INSERT INTO flr_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ngiisi muguma winyu, ayijage neꞌsheetezo yage, anagibiike mwoꞌmubadu. Iyo sheetezo, anagitwale imbere lya Nahano. Kwokwo, yizo sheetezo zooshi, zigaaba magana gabiri na makumi gataanu. Harooni naye, agaleeta iyeꞌmwage.» ");
INSERT INTO flr_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Kwokwo, ngiisi muguma wabo anayabiira isheetezo yage, anagibiika mwaꞌmakala ágayasiri, kuguma noꞌmubadu. Ha nyuma, banagendi yimanga ha mulyango gwiꞌheema lyeꞌmihumaanano, balyagagi kuguma na Musa na Harooni. ");
INSERT INTO flr_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Koora anakuumania abakulikizi baage booshi ha mulyango gwa lirya iheema, gira bahagane na yabo bombi. Lyeryo ngana, ubulangashane bwa Nahano bwanayami batanguulira booshi. ");
INSERT INTO flr_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Nahano anabwira Musa na Harooni: ");
INSERT INTO flr_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Mwembi, muyihandulage ku yaba bandu, gira ndonge ubulyo bwoꞌkuyami baminika kinaliguma.» ");
INSERT INTO flr_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Haliko, Musa na Harooni banagwa buubi, banayamiza, ti: «E Rurema, si we mu tuma abandu booshi bali bagumaana! Aahago! Ka ugayami rakarira abandu booshi, anali mundu muguma naaho ye kakuhubira?» ");
INSERT INTO flr_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Nahano naye, ti: ");
INSERT INTO flr_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«E Musa, ubwire abandu booshi kwo balyokage ha butambi lyaꞌmaheema ga Koora, naꞌga Datani, naꞌga Habiraamu.» ");
INSERT INTO flr_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Musa anakwabadukira ha mwa Datani na Habiraamu. Naꞌbashaaja baꞌBahisiraheeri banagenda bamúkulikiiri. ");
INSERT INTO flr_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Musa, mbu ahikage yaho, anakengula abandi bandu booshi, ti: «Yaba bandu, muyami lyoka ha gano maheema gaabo. Mukuba bakola banangora-mabi. Hatanagire kiri neꞌkindu kiguma kyabo kyo mugahuma kwo. Mutayiji kengeera mwashereezibwa mwe nabo. Si boohe, ibyaha byabo bigabamala.» ");
INSERT INTO flr_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Kwokwo, balya bandu banalyoka hoofi naꞌmaheema ga Koora, naꞌga Datani, na geꞌmwa Habiraamu. Haaho, Datani na Habiraamu banahuluka mu maheema gaabo, banayimanga ha miryango bali kuguma na bakaabo, naꞌbaana baabo, kiri noꞌtulenge twabo. ");
INSERT INTO flr_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Musa anabwira Abahisiraheeri: «Bwobuno, mumenyage kwo Nahano ye kanduma ngire yibi. Si kutali ku bulooze bwani. ");
INSERT INTO flr_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Yaba bandu, iri bangafwa nga kwaꞌbandi bali mu fwa, iri atali Nahano ye kanduma. ");
INSERT INTO flr_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Halikago, iri Nahano angagira igambo lihyahya, mu kuyigula idaho, linabamire bakiri bagumaana, kuguma neꞌbindu byabo byoshi, haaho lyo mugaamenya kwo yaba bandu bashuba mu gayiriza Nahano.» ");
INSERT INTO flr_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Uyo Musa, mbu ayusagye ukudeta kwokwo, lyeryo, idaho lyanayami yiguka. ");
INSERT INTO flr_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Ikishimo, kyanamira Datani na Habiraamu, kuguma neꞌmbaga zaabo. Kyanamira na balya bandi bahuni ba Koora, kuguma neꞌbindu byabo. ");
INSERT INTO flr_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Yabo booshi, bakaholobera i kuzimu bakiri bagumaana, kuguma neꞌbindu byabo byoshi. Ha nyuma kandi, yiryo idaho lyanashubi babwikira. Kwokwo, kwo bakaminikwa, batanaki boneka. ");
INSERT INTO flr_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Abahisiraheeri booshi ábâli yimaaziri ha butambi lyabo, mbu bayuvwe ngiisi kwo bagweti bagabululuka, banayami tibita, iri banadeta: «E balya, tushaagage, gira nyiitu, idaho litayiji tumira.» ");
INSERT INTO flr_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Haaho, balya bandu magana gabiri na makumi gataanu ábâli fumbiiti imibadu mu sheetezo, Nahano anayami batibulira kwoꞌmuliro, gwanabajigiivya booshi. ");
INSERT INTO flr_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Ha nyuma, Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Zirya sheetezo, ubwire Heryazaari mugala umugingi Harooni, kwo agendi zikondoola mu muliro. Naꞌmakala ágaziri mwo, agendi gayonera hala. Mukuba, yizo sheetezo, ziri ndaluule. ");
INSERT INTO flr_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","«Yizo sheetezo, beene zo keera bayitwa hiꞌgulu lyeꞌbyaha byabo. Na bwo bakazikoleesa imbere lya Nahano, zikolaga ndaluule. Ku yukwo, Heryazaari azitulage mwoꞌmutumbikizo gwaꞌkashasha. Kwokwo, yugwo mutumbikizo, gugaaba kalangikizo koꞌkukengeeza Abahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","«Yizo sheetezo kwo zikatulwa mu miringa, uyo mugingi Heryazaari, anaziyabiira, anazitula mwoꞌmutumbikizo gwaꞌkashasha. (Yizo sheetezo, zâli riiri za balya bandu ábakajigiivibwa.) ");
INSERT INTO flr_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Akagira nga kwo Nahano âli mali múyereka ku njira ya Musa. Kwokwo, Rurema anakengeeza yabo Bahisiraheeri kwo ndaaye úhangwirwi ukuyokera Nahano umubadu, átali umugingi wa mwiꞌkondo lya Harooni. Iri ugundi mundu angagira mbu aguyokye, agashereezibwa naye, nga kwokulya kwa Koora naꞌbakulikizi baage.» ");
INSERT INTO flr_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Iri bukakya, yabo Bahisiraheeri booshi banayidodombera Musa na Harooni, ti: «Emwe! Si keera mwayitiisa abandu ba Nahano!» ");
INSERT INTO flr_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Yabo Bahisiraheeri, banashololokera Musa na Harooni mu kubayihindulira. Haliko, iri bakakebagana iwiꞌheema lyeꞌmihumaanano, banabona ikibungu kyalizinga kwo. Mu yikyo kibungu, banabona ubulangashane bwa Nahano. ");
INSERT INTO flr_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Haaho, Musa na Harooni banagendi yimanga imbere lya lirya iheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","«E Musa, uyihandule ku yaba bandu. Mukuba, buno, ngola ngabashereeza.» Musa na Harooni, banagwa buubi. ");
INSERT INTO flr_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Musa anayami bwira Harooni: «Yabiiraga isheetezo yawe, unagibiike kwoꞌmubadu, kuguma noꞌmuliro ukushaaga ha kashasha. Unagivwarukane imunda yabo bandu, gira ubanywaniise na Nahano. Ubanguke! Mukuba, Nahano akoli barakariiri. Si kiija keera kyatondeera ukubayingira mwo!» ");
INSERT INTO flr_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Harooni anagira nga kwo Musa akamúbwira. Anayabiira isheetezo yage, anagiyokera kwoꞌmubadu, anagiyingirana úmuli balya Bahisiraheeri, gira abanywaniise na Rurema. Mukuba, kirya kiija kyâli mali bayingira mwo. ");
INSERT INTO flr_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Harooni anayimanga ha kati keꞌbirunda, na ábakiri bagumaana, halinde yikyo kiija kyanamala. ");
INSERT INTO flr_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Kundu kwokwo, kyanayita abandu bihumbi ikumi na bina na magana galinda, buzira kuharuura balya bahuni ábâli mali fwa bo na Koora. ");
INSERT INTO flr_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Ikyanya ikiija kikamala, Harooni anagalukira áhali Musa, ha mulyango gwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Ha nyuma, Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","«Ubwire Abahisiraheeri kwo bakuleetere ingoni ikumi na zibiri. Yizo ngoni, ngiisi mukulu woꞌmulala aleete ingoni nguma-nguma. Na ku ngiisi ngoni, uyandike iziina lya mwene yo. ");
INSERT INTO flr_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Neꞌngoni yaꞌBalaawi, ugiyandike kwiꞌziina lya Harooni. Kwokwo, ngiisi úyimangiiri umulala, agaaba neꞌngoni nguma-nguma. ");
INSERT INTO flr_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Yizo ngoni zooshi, uziyabiire, unazitwale mwiꞌheema, imbere lyeꞌmihumaanano, unazilambike imbere lyaꞌKajumba keꞌKihango. Haaho, ho tugagwanana twembi. ");
INSERT INTO flr_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Kwokwo, ngiisi ye ngaaba natoola, ingoni yage igaashoga. Kwiꞌyo njira, lyo ngaamala imidodombo yaꞌBahisiraheeri hiꞌgulu liinyu.» ");
INSERT INTO flr_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Kwokwo, Musa anaganuuza Abahisiraheeri booshi, naꞌbimangizi baabo. Yabo bimangizi, banamúheereza ingoni zaabo, ukukulikirana neꞌmilala yabo, kwo yâli ikumi niꞌbiri. Iyo ngoni ya Harooni nayo, yâli ziriiri mwo. ");
INSERT INTO flr_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Zirya ngoni zooshi, Musa anazibiika imbere lya Nahano, mwiꞌheema lyage lyeꞌKihango. ");
INSERT INTO flr_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Iri bukakya, Musa anagendi yingira mu lirya iheema. Neꞌri akahikaga mwo, anagwana irya ngoni ya Harooni keera yashoga, inakola naꞌkafundo. Yako kafundo, kanaleeta akaaso. Na mu yako kaaso mwanalyoka ibitumbwe íbikoli hiiri, binashushiini neꞌloozi. Ee! Iyo ngoni, yâli riiri ya beene Laawi. ");
INSERT INTO flr_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Haaho, Musa analyosa yizo ngoni imbere lya Nahano, anazileeta imbere lyaꞌBahisiraheeri. Ngiisi mukulu, anayabiira iyeꞌmwage. ");
INSERT INTO flr_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Nahano anabwira Musa kwokuno: «Irya ngoni ya Harooni, ugigalukane, unagibiike imbere lyaꞌKajumba keꞌKihango. Iyo ngoni, igakizi langwa, bube bumasi imwaꞌbahuni. Kwokwo, kweꞌmidodombo yabo igaamala, halinde batanashubi yitwa.» ");
INSERT INTO flr_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Ngiisi kwo Nahano akabwira Musa, kwo akanagira. ");
INSERT INTO flr_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Balya Bahisiraheeri banayiji bwira Musa: «Keera twahera, maashi! Tweshi twamala. ");
INSERT INTO flr_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Ngiisi úli mu yegeera iheema lya Nahano, si ali mu yami fwa. Aaho! Ka tumalage tweshi?» ");
INSERT INTO flr_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Ha nyuma, Nahano anabwira Harooni: «Mwe na bagala baawe, kuguma naꞌba mu mbaga yawe, ikyanya iheema lyeꞌmihumaanano ligahubirwa, mwe mugabetula umwama. Kiri neꞌkyanya abagingi bagayiji legwa, mwe bigaalola. ");
INSERT INTO flr_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ikyanya mwe na bagala baawe mugakizi kola imbere liꞌheema lyeꞌmihumaanano, uleetage naꞌbiinyu Balaawi, gira bakizi mùtabaala. ");
INSERT INTO flr_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","«Yabo beene winyu, ikyanya bagakizi gira imikolwa ya mu lirya iheema, bakizi yibiika mwiꞌdako lyawe. Kundu kwokwo, batahangwirwi ukuhuma ku birugu bya mwiꞌheema, batanayegeere ha kashasha. Iri bangabihuma kwo, mweshi mugayami fwa. ");
INSERT INTO flr_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Si imikolwa yoshi yoꞌkukizi lingaania lirya iheema lyeꞌmihumaanano, mube mugweti mugagikola kuguma. Neꞌkyanya ugakizi kola mwiꞌheema Litatuule, hatagirage ugundi mundu úgakizi kuyegeera. ");
INSERT INTO flr_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","«Kwokwo, mwehe mwenyene, mwe mugakizi kola imikolwa ya mwiꞌheema lyeꞌmihumaanano, kiri na ha kashasha. Kwokwo, lyoꞌburaakari bwani butashubi tibukira ku Bahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Mu Bahisiraheeri booshi, keera nꞌgatoola beene winyu Abalaawi, gira bataluulwe, lyo bakizi ngolera mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","«Haliko wehe, e Harooni, kuguma na bagala baawe, mwe mugakizi ngirira imikolwa yoꞌbugingi, mu kukunga íbiri ha kashasha, kiri na íbiri imbere lyeꞌKisiika Kyeru Bweneene. Kwokwo, yugu mukolwa gwinyu, namùheereza gwo. Nakuheereza neꞌkigabi kyoꞌkukizi kola mwoꞌmukolwa gwaꞌbagingi. Ngiisi gundi úwangayegeera iheema lyeꞌmihumaanano, akwaniini ayami yitwa.» ");
INSERT INTO flr_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Nahano anashubi bwira Harooni kwokuno: «Amatuulo gooshi gaꞌBahisiraheeri bagakizi ndeetera, we nabiikaga, ukizi galola. Kwo bagweti bagagambeereza gooshi mataluule, naani namùheereza go, mwe naꞌbaana baawe. Yago matuulo, gagayama gali geꞌmwinyu. ");
INSERT INTO flr_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ngiisi matuulo ágatali goꞌkusiriiza lwoshi, gagakizi ba geꞌmwinyu. Kuli kudeta amatuulo goꞌmushyano, na goꞌkukogwa ibyaha, na goꞌkuhyula. Ngiisi bindu byaꞌbandu bagakizi ndangira ituulo litaluule, bigakizi ba byeꞌmwawe, mwe naꞌbaana baawe. ");
INSERT INTO flr_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Yibyo byokulya, bwo biri bitaluule, mukizi birya. Si abashosi naaho, bo bagakizi birya. ");
INSERT INTO flr_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«Na kwakundi, ngiisi bindi byaꞌBahisiraheeri bagakizi ndangira ituulo mu kubishagania, nabyo bigakizi ba byeꞌmwawe mwe na bagala baawe, na banyere baawe. Kwokwo, ngiisi mundu wa mu mbaga yawe úkoli yeruusiri, ahangwirwi ukukizi birya kwo. ");
INSERT INTO flr_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","«Kwokwo, namùheereza ngiisi mimbu miija yaꞌBahisiraheeri bagakizi ndangira mu kundomoza, ngaꞌmavuta, neꞌdivaayi, neꞌngano. ");
INSERT INTO flr_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Ngiisi mimbu yabo yo bagakizi ndomoza, igakizi ba yeꞌmwawe. Yizo mbuto, ngiisi mundu wa mu mbaga yawe útayulubiiri angakizi zilya kwo. ");
INSERT INTO flr_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Kwokwo, mu kihugo kyoshi kyaꞌBahisiraheeri, ngiisi byo bagakizi taluula imwa Nahano, iri na niinyu, bikola byeꞌmwinyu. ");
INSERT INTO flr_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","«Ikyanya Abahisiraheeri bagakizi ndangira ifula zaabo, na niinyu zigakizi ba zeꞌmwinyu, ziba fula zaꞌbandu, kandi iri zeꞌbitugwa. Haliko, yizo fula zaꞌbandu, zikwaniini zikizi guluulwa. Neꞌbitugwa biinyu íbyabutwa ubwa mbere, iri byangaba biri naꞌkashembo, nabyo bikwaniini bikizi guluulwa. ");
INSERT INTO flr_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Byangaguluulwa ku kyanya biki hiiti umwezi muguma. Neꞌkishingo kyoꞌkubiguluula, biri bingorongoro bitaanu byeꞌharija, ukukulikirana na ngiisi kweꞌharija iri mu gerwa Ahandu Heeru. ");
INSERT INTO flr_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","«Halikago, ikitugwa íkyabutwa ubwa mbere, ziba shuuli, kandi iri bibuzi, kandi iri mbene, byohe, bitagakizi guluulwa. Si biryagagi bitaluule. Kwokwo, uyabiirage umuko gwabyo, unakizi gushangira ku kashasha. Neꞌbinyule byabyo, ukizi biyokya. Ikyanya ugakizi bisiriiza, umushiiriri gwabyo gugakizi simiisa Nahano. ");
INSERT INTO flr_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Yibyo bitugwa, inyama zaabyo zigaaba zeꞌmwinyu: umushaya neꞌkisingiira kyeꞌlulyo, nga kwo biri mu lengezibwa imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","«Kwokwo, ngiisi matuulo mataluule gaꞌBahisiraheeri bagakizi ndangira, naawe nakuheereza go, mwe na bagala baawe, kiri na banyere baawe. Kiri neꞌkihango ha kati kiitu twembi, kigaaba na ku bandu ba mwiꞌkondo lyawe. Yikyo kihango, kitanâye hongolwe.» ");
INSERT INTO flr_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Ha nyuma, Nahano anashubi bwira Harooni: «Kundu abiinyu Bahisiraheeri bagahyana íbiri mu kirya kihugo, haliko mwehe, mwe bagingi, ndaabyo mugahyana. Ndaagwo mutuli mugalonga mwo. Si mu Bahisiraheeri, niehe, nie gaaba mutuli gwawe, nie gaanaba buhyane bwawe. ");
INSERT INTO flr_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«Ku luhande lwaꞌBalaawi, ikyanya bagakizi gira umukolwa gwa mwiꞌheema lyeꞌmihumaanano, ngakizi baheereza ngiisi kihande kiꞌkumi kyaꞌBahisiraheeri bagakizi ndangira. Yikyo kihande kiꞌkumi, bwo bugaaba buhyane bwabo. ");
INSERT INTO flr_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","«Noꞌkulyokera buno, abandi Bahisiraheeri batakwaniini ukukizi yegeera iheema lyeꞌmihumaanano. Neꞌri bangaliyegeera, iri bayikululira umwama, gunabakwegere ulufu. ");
INSERT INTO flr_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Ku yukwo, Abalaawi naaho bo bagakizi kola mwiꞌheema lyeꞌmihumaanano. Neꞌri abandu bangagira amahube hiꞌgulu lyalyo, Abalaawi bo bagakizi gabetula. Yulu lubaaja lugayama ho, halinde mu bibusi biinyu byoshi. «Abalaawi, mu kihugo kyeꞌHisiraheeri, ndaakyo kindu bagahyana mwo. ");
INSERT INTO flr_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Si ikyanya Abahisiraheeri bagakizi tanga ikihande kiguma kiꞌkumi, ngakizi baheereza kyo. Kyo kikatuma nꞌgadeta, kwo mu baabo Bahisiraheeri, Abalaawi boohe, ndaabwo buhyane bwo bagalonga.» ");
INSERT INTO flr_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Nahano anabwira Musa, ");
INSERT INTO flr_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","kwo amenyeese Abalaawi kwokuno: «Ikyanya Abahisiraheeri bagakizi tangira Nahano ikihande kiguma kiꞌkumi, mwe mugakizi kihaabwa, kibe mutuli gwinyu. Neꞌkyanya mugakizi kihaabwa, niinyu mugakizi tanga ikihande kiꞌkumi kyeꞌmwinyu, gakizi ba go matuulo geꞌmwinyu. ");
INSERT INTO flr_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Yibyo byo mugakizi tanga, bigakizi haruurwa nga gaago matuulo gaꞌBahisiraheeri bali mu tanga ku mimbu yabo. ");
INSERT INTO flr_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Kwokwo, mukizi ndangira ikihande kiꞌkumi ku byo mugakizi yakiira mu Bahisiraheeri. Yikyo kiꞌkumi kiinyu, mugakizi kiheereza umugingiHarooni. ");
INSERT INTO flr_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ku ngiisi byo mugakizi yakiira, muheereze Nahano íbiri biija, bibe bitaluule imwage.» ");
INSERT INTO flr_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Nahano anashubi bwira Musa, kwo amenyeese Abalaawi na kwokuno: «Ikyanya mugakizi nzikiiriza yikyo kihande kiꞌkumi íkisimisiizi, ngakizi kiharuura nga íkyashaaga ha kiyeluuliro kiinyu, kandi iri ha kikandiro kiinyu. ");
INSERT INTO flr_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Birya bihande mwenda íbigasigala, mwe neꞌmbaga ziinyu, mwangakizi biliira ngiisi ho muloziizi. Bigakizi ba byo bihembo biinyu, hiꞌgulu lyoꞌmukolwa gwo mugweti mugagirira mwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","«Neꞌri mwangaba keera mwatanga íbiri biija imwani, ndaagwo mwama gwo mugakizi yikululira. Mukuba, iri mwangaba mutahubiiri amatuulo mataluule, mutagayitwa hiꞌgulu lyago.» ");
INSERT INTO flr_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Nahano anashubi bwira Musa na Harooni: ");
INSERT INTO flr_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Hali ulundi lubaaja lwo ngamùbwira. Ugendi menyeesa Abahisiraheeri kwo bakuleetere inyana yiꞌgaajo. Iyo nyana ibe iri nzira kashembo, inabe itazindi limiisibwa. ");
INSERT INTO flr_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Iyo nyana, mugiheereze umugingi Heryazaari, agitwale áhayerusiibwi inyuma lyeꞌshumbi, munabuli gitongeerera imbere lyage. ");
INSERT INTO flr_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","«Haaho umugingi Heryazaari analeeze umunwe mu muko gwayo, anagushangire ubugira kalinda imbere liꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Inyama zaayo, zisiriizibwe imbere lyage, kiri noꞌluhu, noꞌmuko, naꞌmashe. ");
INSERT INTO flr_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Lyeryo, umugingi anayabiire ihitolo hyeꞌkiti kyoꞌmwerezi, kuguma niꞌtavi lyeꞌhisopo, neꞌnuzi ndukula, anabilashe byoshi ngiisi heꞌyo nyana igweti igasiriigizibwa. ");
INSERT INTO flr_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","«Ha nyuma, umugingi akwaniini afulage ibyambalwa byage, anayikarabe, akabuli yingira mu shumbi. Kundu kwokwo, agaaba aki yulubiiri, halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ulya mundu úkasiriiza iyo nyana, naye kwakundi afule ibyambalwa byage, anayikarabe, bwo naye agaaba ayulubiiri halinde kabigingwe. ");
INSERT INTO flr_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","«Ugundi mundu úkoli yerusiibwi, agashamata umunyota-kiiko gweꞌyo nyana, anagendi gubiika áhayerusiibwi, inyuma lyeꞌshumbi. Yugwo munyota-kiiko, gunakizi langwa ho bwija. Ha nyuma, Abahisiraheeri banakizi gutobera mu miiji goꞌkuyeruusa. Yiryo, liri ituulo lyoꞌkukogwa ibyaha. ");
INSERT INTO flr_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Yugwo munyota-kiiko gweꞌyo nyana, umundu úgagushamata, akwaniini naye afulage ibyambalwa byage. Naye kwakundi, agaaba akoli yulubiiri halinde kabigingwe. Yulu lubaaja, lugayama mu Bahisiraheeri booshi, kiri na mu binyamahanga byo batuliinwi. ");
INSERT INTO flr_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Ngiisi úgaahuma ku kirunda, agaaba akoli yulubiiri, halinde ukuhisa isiku zirinda. ");
INSERT INTO flr_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Mu yizo siku, ulusiku úlugira izishatu, noꞌlugira izirinda, uyo mundu akwaniini ayiyeruuse na galya miiji. Kwokwo, lyo agaaba akoli yeruusiri. Haliko, iri atangayiyeruusa ku lusiku úlugira izishatu, na ku lugira izirinda, iri agayama aki yulubiiri. ");
INSERT INTO flr_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ngiisi úwahuma ku kirunda, anabe atagendi yiyeruusa, agaaba ayulubaza iheema lya Nahano. Uyo mundu, akwaniini atwibwe mu baabo Bahisiraheeri. Bwo atakayeruusibwa na galya miiji, anayamage aki yulubiiri. ");
INSERT INTO flr_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«Umundu, nga angafwira mwiꞌheema, abandu bakwaniini ukukulikira yulu lubaaja: Ngiisi úwangayingira mwo, kandi iri úwagwanwa mwo, booshi bagaaba bakoli yulubiiri, halinde ukuhisa ku siku zirinda. ");
INSERT INTO flr_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Yaho mwiꞌheema, ngiisi kirugu íkigaaba kitatumbikiirwi, nakyo kigaaba kikoli yulubiiri. ");
INSERT INTO flr_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","«Iri umundu angaba akola imbuga, anahumage ku kirunda kya úwayitwa, kandi iri kya úwafwa yenyene, uyo mundu agaaba akoli yulubiiri, halinde ukuhisa ku siku zirinda. Bigaaba kwokwo, kiri na ku mundu úwahuma imigongolo yoꞌmundu, kandi iri ishinda. ");
INSERT INTO flr_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«Umundu mwene uyo, iri angalooza ukuyiyeruusa, mukwaniini muyabiire umunyota-kiiko gwa galya matuulo goꞌkukogwa ibyaha. Yugwo munyota-kiiko, mugufuke mu nyungu, munagutobe naꞌmiiji meeru. ");
INSERT INTO flr_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Kwokwo, ngiisi úyeruusiri, ayabiire ihitavi hyeꞌhisopo, anahireeze mu yago miiji, anagashangire kwiꞌheema, na ku birugu íbiriri mwo, kiri na ku bandu ábali mwo. Akabuli gashangira na kuꞌlya mundu úhumiri ku migongolo, kandi iri úhumiri ku shinda, kandi iri ku mundu úkayitwa, kandi iri ku kirunda kya úkafwa yenyene. ");
INSERT INTO flr_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Ku lusiku úlugira izishatu, noꞌlugira izirinda, ngiisi úkoli yeruusiri, akwaniini ashangirage yago miiji ku úkoli yulubiiri. Na mu yizo siku zirinda, amúyeruuse. Uyo úshubi yulubiiri, akwaniini afulage ibyambalwa byage, anayikarabe. Na ku kyanya kyaꞌkabigingwe, agaaba akoli yeruusiri. ");
INSERT INTO flr_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«Iri umundu angayiyulubaza, atanayiyeruuse, akwaniini atwibwe mu baabo Bahisiraheeri. Mukuba, agaaba keera ayulubaza iheema lya Nahano. Bwo atakashangirwa kwaꞌmiiji goꞌkuyeruusa, agayama aki yulubiiri. ");
INSERT INTO flr_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","«Yulwo, lulyagagi lubaaja úlugayama ho. Ngiisi úgakizi shangira amiiji goꞌkuyeruusa, akwaniini akizi fula ibyambalwa byage. Ngiisi úgakizi huma mu yago miiji, agaaba akoli yulubiiri, halinde ukuhisa kabigingwe. ");
INSERT INTO flr_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Uyo mundu úkoli yulubiiri, ngiisi byo agahuma kwo, bigaaba nabyo keera byayulubala. Na ngiisi úgamúhuma kwo, naye agaaba akoli yulubiiri, halinde kabigingwe.» ");
INSERT INTO flr_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Mu mwezi gwa mbere, Abahisiraheeri booshi bâli mali hika mwiꞌshamba lyeꞌSiini, banashumbika i Kadeeshi. Ikyanya bâli kola ho, Miryamu anafwa, banamúziika. ");
INSERT INTO flr_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Yaho bâli shumbisiri, ndaago miiji ágâli riiri ho. Kwokwo, abandu banazunguluka Musa na Harooni, ");
INSERT INTO flr_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","iri banalongooza Musa: «Ikyanya beene witu bakayitwa imbere liꞌheema lya Nahano, bwangábiiragi bwija tufwire kuguma. ");
INSERT INTO flr_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Aahago! Kituma kiki mwatuleeta hano mwiꞌshamba? Ka mbu lyo tuyiji herera mwo, kuguma neꞌbitugwa biitu? ");
INSERT INTO flr_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Kituma kiki mukatulyosa i Miisiri, mwanatuleeta mu gano malibu? Si hano ndaayo ngano, ndaanayo mitiini, ndaanayo mizabibu, kandi iri makomamanga. Kiri naꞌmagoloovi, ndaago.» ");
INSERT INTO flr_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musa na Harooni banalyoka áhali yabo bandu, banagendi yimanga ha mulyango gwiꞌheema lyeꞌmihumaanano, banagwa buubi imbere lya Nahano. Neꞌri bakaba balyagagi yaho, lyeryo, ubulangashane bwage bwanabatanguulira. ");
INSERT INTO flr_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Nahano anabwira Musa: ");
INSERT INTO flr_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Uyabiirage ingoni yawe. Mwe na mukulu wawe wa Harooni, mukuumanie yaba bandu. Mango baba bakoli kumaniri imbere lyawe, unabwire luliira lwala kwo lushyokage mwaꞌmiiji. Haaho, amiiji gagalyoka mu lwala, halinde yaba booshi banalonge ukuganywa, kuguma neꞌbitugwa byabo.» ");
INSERT INTO flr_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Kwokwo, Musa anayabiira irya ngoni, imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musa na Harooni, banakuumania balya booshi imbere lyoꞌlwala. Musa anababwiririra: «E bahuni, munyuvwirizagye. Ka muloziizi tumùlyokeze amiiji mu yulu lwala?» ");
INSERT INTO flr_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Lyeryo Musa anabangula ukuboko, anashulika irya ngoni ubugira kabiri ku lwala, amiiji ganayami lushyoka mwo. Yabo booshi, bananywa kuguma neꞌbitugwa byabo. ");
INSERT INTO flr_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Haliko, Nahano anabwira Musa na Harooni kwokuno: «Si mutambiisiri kwoꞌmulangaaliro, mutananzimbahiri imbere lyaꞌBahisiraheeri! Kwokwo, mutakiri mwe mugabahisa mu kihugo kyo ngabaheereza.» ");
INSERT INTO flr_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Yaho handu, hali mu detwa Amiiji geꞌMeriba. Mukuba, haaho, haꞌBahisiraheeri bakahambanwa na Nahano, kundu âli mali yerekana ubulangashane bwage mu kati kaabo. ");
INSERT INTO flr_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Ikyanya Abahisiraheeri bâli ki riiri i Kadeeshi, Musa anatumira mwami weꞌHedoomu indumwa, ti: «E mwami, twehe tuli beene winyu, Abahisiraheeri. Ku yukwo, utuyuvwirize. Amalibu gooshi go tukalonga, ugayiji-yiji. ");
INSERT INTO flr_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Bashokuluza biitu bakagenda i Miisiri. Neꞌyo munda, tukahisa imyaka mingi tutuuziri yo. Balya Bamiisiri bâli kizi libuza bashokuluza biitu, kiri na nyiitu kwakundi. ");
INSERT INTO flr_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Haliko, ikyanya tukatakira Nahano mu kumúlirira, anatuyuvwa, anatutumira umuganda wage, gira ayiji tulyosa i Miisiri. Na buno, tukolaga hano i Kadeeshi, mu kaaya ákabibikiinwi neꞌkihugo kyawe. ");
INSERT INTO flr_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","«Ku yukwo, twakuyinginga, we kongwa, utulekage tulenge mu kihugo kyawe. Ikyanya tugalenga mwo, ndaayo ndalo yo tugashereeza, kiri zeꞌmizabibu. Tutaganayegeera ibirigo biinyu, mbu tuvwome mwaꞌmagoloovi. Mu lugeezi lwitu, tugakulikira injira ya namuhirye naaho, buzira kubambala ilulyo kandi iri ilumosho, halinde tunahulukaane ikihugo.» ");
INSERT INTO flr_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ulya mwami weꞌHedoomu, analahira: «Nanga! Iri mwangalenga mu kihugo kyani, ngayami mùlwisa neꞌngooti.» ");
INSERT INTO flr_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Abahisiraheeri banamúshuvya: «Tugayilengera ku njira ya namuhirye naaho. Neꞌri twanganywa ku miiji giinyu, twe neꞌbitugwa biitu, tugagaliha. Byo twakuhuuna naaho, utuhanguule tulenge. Ndaakyo kindi kyo tukuloziizi kwo.» ");
INSERT INTO flr_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Ulya mwami weꞌHedoomu anashubi shuvya: «Nanga! Mutahangwirwi ukulenga hano.» Lyeryo, ibihagange bingi byaꞌBahedoomu byanayija, gira biyiji balwisa. ");
INSERT INTO flr_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Na bwo yabo Bahedoomu batakabahanguula kwo balenge mu kihugo kyabo, kyanatuma Abahisiraheeri batagalenga mwo, banalooza igindi-gindi njira. ");
INSERT INTO flr_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Abahisiraheeri booshi, banayimuka yaho i Kadeeshi, banagenda halinde ku mugazi Hoori. ");
INSERT INTO flr_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Yaho i Hoori hâli ku lubibi lweꞌkihugo kyeꞌHedoomu. Kwokwo, Nahano anabwira Musa na Harooni: ");
INSERT INTO flr_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Mukulu wawe wa Harooni akola agaafwa, agwane bashokuluza baage. Na íbitumiri atagayingira mu kihugo kyo nꞌgaheereza Abahisiraheeri, bwo mwembi mukangayiriza i Meriba. ");
INSERT INTO flr_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Kwokwo, uyabiirage Harooni na mugala wage wa Heryazaari, munateramanwe ku mugazi Hoori. ");
INSERT INTO flr_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Mango mwahika ho, unamúhogole ibyambalwa byage byoꞌbugingi, unabiyambike mugala wage Heryazaari. Mukuba, haaho, ho Harooni agafwira.» ");
INSERT INTO flr_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Musa anagira nga ngiisi kwo Nahano amúbwira. Kwo bali bashatu, banateramira ku mugazi, naꞌBahisiraheeri booshi bababwini. ");
INSERT INTO flr_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Iri bakahika kwiꞌrango, Musa anahogola Harooni ibyambalwa, anabiyambika mugala wage wa Heryazaari. Haaho kwiꞌrango, ho uyo Harooni akafwira. Ha nyuma, Musa na Heryazaari banamanuka. ");
INSERT INTO flr_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Yabo Bahisiraheeri booshi, iri bakabwirwa kwo Harooni keera afwa, banahisa isiku makumi gashatu, bagweti bagamúgandaara. ");
INSERT INTO flr_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mwami weꞌKaanani âli kizi buuzibwa Haraadi. Uyo mwami, âli tuuziri i Negebu. Neꞌri akayuvwa kwaꞌBahisiraheeri bagweti bagayija mu njira yoꞌkugenda i Hatarimu, anayiji bateera, anagwata baguma baabo imbira. ");
INSERT INTO flr_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Lyeryo, yabo Bahisiraheeri banabiika indahiro imbere lya Nahano, ti: «Yaba bandu, iri wangababiika mu maboko giitu, tugasivya utwaya twabo twoshi.» ");
INSERT INTO flr_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Ikyanya bakahuuna Nahano kwokwo, anabayuvwa. Yabo Bakaanani, anababiika mu maboko gaabo. Kwokwo, Abahisiraheeri banabasivya lwoshi-lwoshi, kuguma noꞌtwaya twabo. Kyanatuma yaho handu hagakizi buuzibwa Horima, kuli kudeta: bushereeze. ");
INSERT INTO flr_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Abahisiraheeri banalyoka yaho ku mugazi Hoori, banashokola injira yoꞌkugenda iwa Nyaaja Ndukula, gira lyo babambala ikihugo kyeꞌHedoomu. Haliko, ikyanya bâli ki riiri mu njira, abandu banavunika umutima. ");
INSERT INTO flr_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Yabo bandu, banatondeera ukuyidodombera Rurema, kiri na Musa, ti: «Emwe! Si ukatulyosa i Miisiri, gira tuyiji herera mu lino ishamba! Hano, ndaahyo hyokulya, ndaanahyo tugaanywa. Si kino kyokulya kiri kyagaza imwitu, keera kyanatuneka.» ");
INSERT INTO flr_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Iri Nahano akayuvwa kwokwo, anatuma imijoka mu kati kaabo. Iyo mijoka, yâli naꞌmanjoka-njoka, yanakizi bakoma bweneene, halinde abingi baabo banafwa. ");
INSERT INTO flr_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Kyanatuma yabo bandu bagagendera Musa, banamúbwira: «Ikyanya tukayidodombera Nahano, kiri na naawe, tukakuhubira bweneene. Kwokwo, utuhunirage imwa Nahano, gira iyo mijoka, atulyokeze yo.» Musa mbu ayuvwe kwokwo, anabahuunira ulukogo. ");
INSERT INTO flr_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Nahano anabwira Musa: «Utee tula umujoka mu mulinga, unagumanike ku kiti. Kwokwo, ngiisi úgakizi komwa neꞌmijoka, iri angagulangiiza kwo, lyo agaakira.» ");
INSERT INTO flr_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Musa anayabiira umulinga, anatula mwoꞌmujoka. Gulya mujoka, anagumanika ku kiti. Kwokwo, ngiisi úwâli kizi komwa noꞌmujoka, anakizi langiiza ku gulya mujoka gwoꞌmulinga, anakire. ");
INSERT INTO flr_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Abahisiraheeri banalyoka yaho, banagendi shumbika i Hobooti. ");
INSERT INTO flr_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Banashubi lyoka i Hobooti, banagendi shumbika i Hiye-Habariimu, uluhande lweꞌsheere mwiꞌshamba lyeꞌMohabu. ");
INSERT INTO flr_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Neꞌkyanya bakalyokaga yaho, banagendi shumbika mu kabanda keꞌZereedi. ");
INSERT INTO flr_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Iri bakalyoka yaho, banagendi shumbika ha butambi lwoꞌlwiji Harinooni. Yulwo lwiji, luli mu hingira mu lubibi lweꞌkihugo kyeꞌMohabu, neꞌkyaꞌBahamoori. ");
INSERT INTO flr_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Kyo kitumiri biri biyandike mu Kitaabo kyaꞌMazibo ga Nahano, hiꞌgulu lyaꞌkaaya keꞌWahebu ka mu kihugo kyeꞌSuufa, na hiꞌgulu lyoꞌlwiji Harinooni, ");
INSERT INTO flr_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","neꞌmigenda yalwo ítabisiri halinde mu kaaya keꞌHari, na ku mbibi zeꞌMohabu. ");
INSERT INTO flr_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Abahisiraheeri, iri bakalyoka yaho, banashokola injira, halinde i Beeri. (Na yaho i Beeri, ho Nahano akabwirira Musa kwo akuumanie Abahisiraheeri booshi, gira abaheereze amiiji.) ");
INSERT INTO flr_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Yaho i Beeri, Abahisiraheeri banayimba yulu lwimbo: «E Kirigo, ushyokage mwaꞌmiiji. Ukizi gayimbira. ");
INSERT INTO flr_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Kino kirigo, abatwali biitu, bo bakakihumba. Ee! Kikahumbwa naꞌbimangizi biitu, iri banafumbiiti ingoni zaabo zoꞌbutwali.» Kwokwo, banalyoka yaho mwiꞌshamba, banagenda i Matana. ");
INSERT INTO flr_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Neꞌri bakalyoka i Matana, banagenda i Nahalyeri. Neꞌri bakalyoka i Nahalyeri, banagenda i Bamooti. ");
INSERT INTO flr_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Neꞌri bakalyoka i Bamooti, banagenda mu kabanda ákahisiri mu kihugo kyeꞌMohabu. Na yaho, iri umundu, angazamuukira mwiꞌrango lyeꞌPisiga, anayami langiiza hala bweneene mwiꞌshamba. ");
INSERT INTO flr_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Mwami waꞌBahamoori âli kizi buuzibwa Sihooni. Uyo Sihooni, Abahisiraheeri banamútumira indumwa: ");
INSERT INTO flr_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Utuhanguule tulengage mu kihugo kyawe. Ikyanya tugalenga mwo, tugabambala imbingiro zaawe, kiri neꞌndalo zaawe zeꞌmizabibu. Ndaanago miiji go tugaanywa mu birigo byawe. Si mu lugeezi lwitu, tugakulikira injira ya namuhirye naaho, halinde tuhulukaane ikihugo kyawe.» ");
INSERT INTO flr_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Uyo mwami Sihooni, analahira kwaꞌBahisiraheeri batalenge mu kihugo kyage, anakuumania abasirikaani baage booshi, anabatwala i Yahasa. Yaho mwiꞌshamba, ulya mwami, anagendi bateera. ");
INSERT INTO flr_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Uyo mwami, iri akayiji lwisa Abahisiraheeri, banamúyita neꞌngooti. Bananyaga ikihugo kyage, ukulyokera ku lwiji Harinooni, halinde ku lwiji Yaboki. Abahisiraheeri banagenderera, halinde mu kihugo kyaꞌBahamooni. Haliko, iri bakahika ho, banagwana ulubibi lwakyo ludediiri bweneene. ");
INSERT INTO flr_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Kwokwo, kwaꞌBahisiraheeri bakanyaga yutwo twaya twoshi twaꞌBahamoori, banatutuula mwo. Mu kati kaatwo, mwâli riiri tweꞌHeshibooni, kuguma noꞌtwaya twayo tuniini. ");
INSERT INTO flr_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Yako kaaya keꞌHeshibooni, kâli riiri kaaya ka Sihooni, mwami waꞌBahamoori. Ubwa mbere, ye katee lwisa mwami weꞌMohabu, anamúnyaga ikihugo kyage kyoshi, halinde ku lwiji Harinooni. ");
INSERT INTO flr_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Kyo kitumiri abimbi biitu bali mu yimba, ti: Muyiji yubakulula akaaya keꞌHeshibooni. Kalyagagi kaaya keꞌmwa Sihooni. Kwokwo, kashakululwe. ");
INSERT INTO flr_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Umuliro, gukalyoka i Heshibooni, wa gwi! Imbigi zaagwo, zikalyoka mu kaaya ka Sihooni. Yugwo muliro, gwanasiriiza akaaya keꞌHari, mu Mohabu, gwanajigiivya abakulu beꞌmigazi yeꞌHarinooni. ");
INSERT INTO flr_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","E bandu beꞌMohabu, yayewe imwinyu. Kundu mulyagagi bandu boꞌmugisi Kemooshi, haliko keera mukashereezibwa. Bagala biinyu, keera mukabaleka babe boꞌkukizi tibita-tibita. Banyere biinyu, keera mwabajandirira, bagendi gwatwa imbira na Sihooni, mwami waꞌBahamoori. ");
INSERT INTO flr_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Kundu kwokwo, balya booshi, twehe buno keera twabashereeza, ukulyokera i Heshibooni, halinde i Dibooni. Keera tukabaminika, ukulyokera i Nashimu halinde i Noofa, neꞌMedeba. ");
INSERT INTO flr_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Yabo Bahisiraheeri banayiji tuula mu kihugo kyaꞌBahamoori. ");
INSERT INTO flr_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Ha nyuma, Musa anatuma abagahirizi mu kaaya keꞌYazeeri. Yako kaaya nako, banakagwata mbira, kuguma noꞌtwaya twako tuniini. Kwokwo, kwo bakayimula mwaꞌBahamoori. ");
INSERT INTO flr_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Haaho, Abahisiraheeri banahinduka, banashokola injira yoꞌkulola i Bashaani. Mwami Hoogi weꞌBashaani, anayimuka naꞌbasirikaani baage, anagendi bateera i Hedireyi. ");
INSERT INTO flr_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Kundu kwokwo, Nahano anabwira Musa: «Uyo mwami Hoogi, utamúyobohe. Keera namúbiika mu maboko gaawe, kuguma naꞌbasirikaani baage booshi, kiri neꞌkihugo kyage. Ugamúgira nga kwo ukagira mwami Sihooni, waꞌBahamoori, úwâli tuuziri i Heshibooni.» ");
INSERT INTO flr_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Ehee! Yabo Bahisiraheeri banayita ulya mwami Hoogi, naꞌbasirikaani baage booshi. Ndaaye kiri noꞌmuguma úkatoloboka. Abahisiraheeri, banayiji tuula mu kihugo kyage. ");
INSERT INTO flr_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Abahisiraheeri banashubi yimuka, banagendi shumbika mu ndekeera zeꞌMohabu, uluhande lweꞌsheere lwoꞌlwiji Yorodaani. Yaho, hali mu lolana naꞌkaaya keꞌYeriko. ");
INSERT INTO flr_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Mwami Balaaki mugala Zipoori, âli yiji-yiji ngiisi kwaꞌBahisiraheeri bâli mali girira Abahamoori, ");
INSERT INTO flr_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","anâli koli shengusiri, kuguma naꞌbandu baage booshi. Ee! Balya Bamohabu, bâli gweti bagalenga mweꞌkinyukura. Na íbikabayobohya, bwaꞌBahisiraheeri bâli riiri bingi bweneene. ");
INSERT INTO flr_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Yabo Bamohabu banabwira abashaaja beꞌMidyani: «E balya, yaka kanyegete kaꞌbandu bagweti bagalabika abatuulani biitu, nga kweꞌshuuli iri mu vwajagira ubwasi mu ndagiriro.» Uyo Balaaki, bwo âli kola mwami weꞌMohabu, ");
INSERT INTO flr_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","anatumaga indumwa imunda umunamaleere Balaamu mugala Behoori. Âli tuuziri i Petoori, hoofi lyoꞌlwiji Hefuraati. Uyo mwami anabwira Balaamu kwokuno: «E waliha, hali akanyegete kaꞌbandu ábalyosiri i Miisiri. Yabo bandu, bakoli kwiziri mu mahanga gooshi. Buno naani, keera bakahiga kwo bagaanyaga kino kihugo kyani. ");
INSERT INTO flr_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","«We kongwa we, undabaale! Yaba bandu, uyiji bandaakira, bwo balyagagi bihagarusi bweneene ukumbima. Iri wangabadaaka, ngeeka lyo nangahasha ukubahima, na mbayimule mu kihugo kyani. Nyiji-nyiji kwo ngiisi ye uli mu gashaanira, iri akoli gashaniirwi. Na ngiisi ye uli mu daaka, iri akoli daasirwi.» ");
INSERT INTO flr_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Yabo bakulu beꞌMohabu naꞌbeꞌMidyani, banalyoka yaho, bafumbiiti imbuli, gira bagitwalire Balaamu. Neꞌri bakahika imunda ali, banamúganuulira ngiisi byo Balaaki akabatuma. ");
INSERT INTO flr_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Uyo Balaamu anababwira: «Mutee laalaga hano. Kusheezi ngaaba keera nalonga ishuvyo imwa Nahano. Ngiisi kwo agambwira, kwo na niinyu, ngamùbwira.» Kwokwo, yabo batwali beꞌMohabu banalaala yaho. ");
INSERT INTO flr_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Bushigi, Rurema anayijira uyo Balaamu, anamúbuuza: «Ewe! Yaba bandu bo muliriinwi, balyagagi banyandi?» ");
INSERT INTO flr_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaamu, ti: «E Rurema, yaba bandu, Balaaki mugala Zipoori, ye wabandumira, ti: ");
INSERT INTO flr_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","“Hali akanyegete kaꞌbandu ábalyosiri i Miisiri, keera banakwira ahandu hooshi. Buno, we kongwa we, ubandaakire! Ngeeka nangalonga ubulyo bwoꞌkubalwisa, na mbayimule.”» ");
INSERT INTO flr_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Rurema anamúbwira: «E Balaamu, utakolwe mbu mugendanwe, bwaꞌBahisiraheeri bakoli gashaniirwi. Ku yukwo, utashubi gendi badaaka.» ");
INSERT INTO flr_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Iri bukakya shesheezi, Balaamu anabwira yabo batwali ba mwami Balaaki: «Mugalukage mu kihugo kiinyu. Si Nahano alahiiri kwo tutagendanwe.» ");
INSERT INTO flr_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Yabo batwali beꞌMohabu banayimuka, banagalukira imunda Balaaki, banamúbwira: «E mwami, Balaamu alahira kwo tutayijanwe.» ");
INSERT INTO flr_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Uyo Balaaki anatuma abandi batwali. Boohe, bâli riiri bingi ukuhima balya ba mbere, banali bo bâli hiiti ulushaagwa bweneene. ");
INSERT INTO flr_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Yabo nabo, iri bakahika imunda Balaamu, banamúbwira: «Balaaki mugala Zipoori adesiri kwokuno: “Hatagirage igambo írigakubuza kwo utayije imwani. ");
INSERT INTO flr_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ngakubulika ibindu íbiri tiita. Ngiisi byo ugambuuna, byo nganakuheereza. Ku yukwo, uyiji ndaakira yaba bandu, maashi!”» ");
INSERT INTO flr_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Haliko balya bandu, iri bakahika, Balaamu anabashuvya: «Kundu Balaaki angambeziizi akajumiro kaage, kanabe kayijwiri mweꞌharija neꞌnooro, niehe ndangahongola igambo lyoshi lyo Nahano Rurema wani ambwira, liba lihamu, kandi iri liniini. ");
INSERT INTO flr_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Kwokwo, niinyu mulaalage hano, halinde ndonge ukumenya iri Nahano aganyushuulira irindi igambo.» ");
INSERT INTO flr_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Mu bwobwo bushigi, Rurema anayijira Balaamu, anamúbwira: «Yaba bandu, bwo bayiji kuyabiira, mugendanwe. Haliko, ukizi gira naaho ngiisi byo ngakubwira.» ");
INSERT INTO flr_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Iri bukakya shesheezi kare-kare, Balaamu anayabiira punda wage, banagendanwa. ");
INSERT INTO flr_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Uyo Balaamu, ikyanya akagendaga na yabo batwali, Rurema anaraakara bweneene. Kyanatuma umuganda wage agagendi múyitanga mu njira, gira amúhangirire. Balaamu âli bwatiiri ku punda wage, akulikiirwi naꞌbakozi baage babiri. ");
INSERT INTO flr_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Uyo punda mbu alangiize, anabona ulya muganda wa Nahano ayimaaziri mu njira, ayomwiri ingooti. Ehee! Uyo punda anayami shaaga mu njira, anayahuka mu ndalo. Balaamu anamúshulika, gira agalukire mu njira. ");
INSERT INTO flr_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ulya muganda wa Nahano anashubi bayitanga ha mbere. Anayimanga heꞌnjira ifindiini ha kati keꞌbyogo byeꞌndalo zeꞌmizabibu. ");
INSERT INTO flr_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ulya punda mbu ashubi múbona, anayihega ku kyogo, anakifyedekania kwoꞌkugulu kwa Balaamu, kyanatuma Balaamu agashubi múshulika. ");
INSERT INTO flr_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ulya muganda wa Nahano anashubi yegeera ha mbere, anayimanga áhafindiini bweneene. Ndaanaho hoꞌmundu angabambala, iba ilulyo kandi iri ilumosho. ");
INSERT INTO flr_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Uyo punda, mbu ashubi bona ulya muganda, leero anagwejera haashi. Balaamu anashubi raakara, anamúhimbula bukayu neꞌngoni. ");
INSERT INTO flr_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Lyeryo uyo punda, Nahano anamúyigula akanwa. Ulya punda, anatondeera ukudeta: «E Balaamu, maashi, bikagi nagira, halinde wanjulika ubugira kashatu?» ");
INSERT INTO flr_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaamu naye, ti: «Si ugweti ugangayiriza, mbu ndi muhwija. Nga nangabiiri neꞌngooti, nangakutongiiri.» ");
INSERT INTO flr_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Ulya punda, ti: «Ewe! Ka ndali nie yolya punda wawe? Si nyamiragi ndi mu kizi kuheeka halinde zeene? Aahago! Ka hali ulundi lusiku lwo nꞌgakugirira kwoku?» Balaamu anamúshuvya: «Nanga!» ");
INSERT INTO flr_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Lyeryo, Nahano anayigulaga amasu goꞌyo Balaamu, anabona ulya muganda wa Nahano, akoli yimaaziri ha kati keꞌnjira, ayomwiri ingooti. Leero, Balaamu anayami shonooka, anagwa buubi. ");
INSERT INTO flr_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ulya muganda, anamúbuuza: «Ewe! Kituma kiki washulika uyu punda wawe ubugira kashatu? Si nakuyijira, gira nyiji kuhangirira. Si yulu lugeezi lwawe, luli lwa buhwija! ");
INSERT INTO flr_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Uyu punda wawe ashuba mu mbona, ananyiyeke ubugira kashatu. Átaki nyiyeke, nga keera nakuyita. Haliko yehe, nangamúlesiri mugumaana.» ");
INSERT INTO flr_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Uyo Balaamu, ti: «E waliha, keera nꞌgagira ikyaha bweneene. Ndanashubi yiji kwo uyimaaziri mu njira, mbu lyo umbangirira. Buno, bwo utasimiisibwa na luno lugeezi lwani, ngola ngagalukira i kaaya.» ");
INSERT INTO flr_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Uyo muganda, ti: «Nanga! Mugendanwe na yaba bandu. Haliko, ugendi deta naaho, ngiisi byo ngakubwira.» Kwokwo, Balaamu anagenderera na yabo batwali ba Balaaki. ");
INSERT INTO flr_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Mwami Balaaki mbu ayuvwe kwo Balaamu akola mu njira, anayami gendi músanganira. Banagwanana mu kaaya keꞌHari. Yako kaaya, kâli riiri ku ngombe yoꞌlwiji Harinooni, ku lubibi lweꞌMohabu. ");
INSERT INTO flr_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Uyo munamaleere Balaamu, mbu ahikage, Balaaki anamúbuuza: «Ewe! Ikyanya nakutumira, kituma kiki utayami yija? Ka utoniragi kwo ndahiiti ubushobozi bwoꞌkukuhemba?» ");
INSERT INTO flr_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaamu anamúshuvya: «E waliha, nie yono, ngola hano. Kundu kwokwo, ndahangwirwi ukudeta amagambo, nga kwo ndoziizi nienyene. Nangadeta naaho ngiisi byo Rurema agambwira.» ");
INSERT INTO flr_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Lyeryo, Balaamu na Balaaki banagendanwa mu kaaya keꞌKiryati-Huzooti. ");
INSERT INTO flr_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Iri bakahika mwo, Balaaki anatanga ituulo lyeꞌshuuli, neꞌbipanga. Yago matuulo, anagaheereza kwo Balaamu, na yabo bashaaja bo bâli ririinwi. ");
INSERT INTO flr_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Iri bukakya, mwami Balaaki anatwala Balaamu, banazamuukira i Bamooti-Baali. Uyo Balaamu anabona yaꞌBahisiraheeri baguma-baguma. ");
INSERT INTO flr_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Uyo Balaamu anabwira Balaaki: «E mwami, unyubakire ututanda tulinda. Mango wayusa, unandeetere ishuuli zirinda, neꞌbipanga birinda.» ");
INSERT INTO flr_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Mwami Balaaki anagira nga kwoꞌyo Balaamu amúbwira. Ku ngiisi katanda, banakizi biika kweꞌshuuli nguma-nguma, neꞌkipanga kiguma-kiguma. ");
INSERT INTO flr_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Haaho, Balaamu anabwira Balaaki: «Usigalage ubwatiiri hano haꞌmatuulo gaawe. Hali ikyanya Nahano angakoli nyijira. Na ngiisi byo aganyereka, byebyo, byo ngayiji kubwira.» Balaamu anazamuuka, halinde anahika áhayiheriiri kwiꞌrango. ");
INSERT INTO flr_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Neꞌri akaba akola yaho, Rurema anamúhulukira kwo. Balaamu anamúbwira: «Keera nayubaka ututanda tulinda, na ku ngiisi katanda nabiika kwiꞌtuulo lyeꞌshuuli nguma-nguma, neꞌkipanga kiguma-kiguma.» ");
INSERT INTO flr_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Nahano anamúbwira ngiisi byo agaadeta, ti: «E Balaamu, ugalukire imunda Balaaki, unamúbwire ngiisi kwo nakubwira.» ");
INSERT INTO flr_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Kwokwo, Balaamu anagaluka, anagwanana Balaaki aki yimaaziri ha butambi liꞌtuulo lyoꞌkusiriiza. Naꞌbatwali booshi beꞌMohabu bâli riiri ho. ");
INSERT INTO flr_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Ulya Balaamu anatangaga yubu buleevi: «Mwami Balaaki andumira, njaage i Haraamu, na nyije hano. Ee! Bwo ye mwami weꞌMohabu, andumira ukulyoka mu migazi yeꞌsheere. Anambwira: “Yijaga, undaakire beene Yakobo. Ee! Uyiji daaka Abahisiraheeri.” ");
INSERT INTO flr_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Aahago! Kuti kwo ngabadaaka, na Rurema atabadaasiri? Kuti kwo nangabatwira ulubaaja, na Nahano atabatwiriiri lwo? ");
INSERT INTO flr_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Kwo nyimaaziri hano mu maala, kwiꞌrango, mbabwini. Ngweti ngabalangiriza hano ku mugazi. Balya bandu, bahandwirwi neꞌgindi milala, banatuuziri boonyene. ");
INSERT INTO flr_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Yaba beene Yakobo, si balyagagi kanyegete nga mushenyu. Aaho! Nyandi úwangaki baharuura? Nyandi úwangaharuura kiri neꞌkihande kyabo kiguma kya kana? Bwangaba bwija, nvwe nga boohe mu kati koꞌkuli. Ee! Kwokwo kwo kwangaba kwija.» ");
INSERT INTO flr_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Uyo Balaamu, lyeryo mwami Balaaki anamúnaakira: «Maki gano wagiraga? Nakuleeta hano, kwo uyiji daaka abagoma baani. Si ho wangabadaasiri, keera wabagashaanira.» ");
INSERT INTO flr_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Uyo Balaamu, ti: «E waliha, si mbangwirwi naaho ukudeta ngiisi byo Nahano ambwiziri!» ");
INSERT INTO flr_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Ha nyuma, mwami Balaaki anashubi bwira Balaamu: «Uyije tugendanwe ahandi, ngiisi ho wangashobola ukubona ikimaanye kyabo naaho, si batali booshi. Leero, unabandaakire.» ");
INSERT INTO flr_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Lyeryo, Balaaki anatwala Balaamu mu ndalo yeꞌSofiimu, kwiꞌrango lyeꞌPisiga. Yaho kwakundi, anahayubaka ututanda tulinda. Ku ngiisi katanda, anakizi tanga kwiꞌtuulo lyeꞌshuuli nguma-nguma, neꞌkipanga kiguma-kiguma. ");
INSERT INTO flr_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaamu anabwira Balaaki: «E mwami, utee sigala hano haꞌmatuulo gaawe. Niehe, ngagenda haliira, gira ngendi gwanana na Nahano.» ");
INSERT INTO flr_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Uyo Balaamu, iri akahikaga ho, banagwanana na Nahano. Anamúheereza indumwa, anabuli múbwira: «Ugalukire imunda Balaaki. Ino indumwa, umúbwire yo.» ");
INSERT INTO flr_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Kwokwo, Balaamu anagalukira imunda Balaaki, anagwana aki yimaaziri ha yago matuulo gaage, ali kuguma naꞌbatwali beꞌMohabu. Balaaki anamúbuuza: «Aahago! Biki byo Nahano akubwira?» ");
INSERT INTO flr_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Ulya Balaamu anatanga ubuleevi kwokuno: «E Balaaki mugala Zipoori! Yinamuka, undege amatwiri. ");
INSERT INTO flr_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Rurema atali nga mundu, mbu abeeshe. Atanali nga mundu mbu ayishuhize. Ngiisi byo agweti agaadeta, ali mu bigira. Na ngiisi byo ali mu lagaania, ali mu bikola. ");
INSERT INTO flr_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Lolaga! Keera Rurema ambwira kwo ngizi bagashaanira. Na bwo yenyene keera akabagashaanira, ndangaki bihindula. ");
INSERT INTO flr_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Mu beene Yakobo, ndaabwo buligo bwo mbabwini kwo. Yabo Bahisiraheeri, ndaago magoorwa go bagalonga. Nahano Rurema wabo, batuliinwi. Keera abamenyeesa kwo ye mwami wabo. ");
INSERT INTO flr_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Rurema keera akabalyosa i Miisiri, anahiitagi imisi nga ya mbogo. ");
INSERT INTO flr_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Beene Yakobo, ndaalyo idaaki íryangabahuma kwo. Ndaanabwo bulozi úbwangaba neꞌmisi hiꞌgulu lyabo. Buno, abandu bagakizi deta hiꞌgulu lyaꞌBahisiraheeri, ti: “Rurema keera akabagirira ibisoomeza bya kahebuuza.” ");
INSERT INTO flr_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Emwe! Bakoli yimaaziri nga ndare ngazi. Banakoli sikamiri nga ndare njosi. Bali nga ndare, bwo batagahunira, halinde batee vwajagira ku byo bayita, banabe keera banywa ku muko gwabyo.» ");
INSERT INTO flr_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Uyo mwami Balaaki anayami bwira Balaamu: «Iri utangashobola ukubadaaka, ulekage ukubagashaanira.» ");
INSERT INTO flr_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaamu anamúshuvya: «Ka ndakakubwira kwo ngiisi byo Nahano agambwira, byebyo byo nganagira?» ");
INSERT INTO flr_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Mwami Balaaki anashubi múbwira: «Uyije ngutwale ahandi. Ngeeka ho Rurema angayemeera undaakire yaba bandu.» ");
INSERT INTO flr_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Kwokwo, Balaaki anatwala Balaamu mwiꞌrango lyoꞌmugazi Pehoori. Yaho, umundu ali mu yami langiiza hala mwiꞌshamba. ");
INSERT INTO flr_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaamu anashubi múbwira: «Unyubakire ututanda tulinda, unandeetere ishuuli zirinda, neꞌbipanga birinda.» ");
INSERT INTO flr_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balaaki anagira nga kwo amúbwira. Ku ngiisi katanda, anakizi tanga ituulo lyeꞌshuuli nguma-nguma, neꞌkipanga kiguma-kiguma. ");
INSERT INTO flr_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Leero, umunamaleere Balaamu anabona kwo Nahano asiimiri naaho ukugashaanira Abahisiraheeri. Kwokwo, atanaki shubi gendi lagula, nga kwo âli kizi gira. Anakizi langiiza naaho mwiꞌshamba. ");
INSERT INTO flr_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Neꞌri akalangiiza, anabona ishumbi zaꞌBahisiraheeri. Ngiisi mulala, gwâli naꞌhandu haagwo. Ha nyuma, Umutima gwa Rurema gwanamúyijira, ");
INSERT INTO flr_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","anatangaga ubuleevi kwokuno: «Balaamu mugala Behoori, akayigulirwa ubuleevi, anabubona neꞌnooka. Yubwo buleevi bwage, abubwini ku bweranyange. ");
INSERT INTO flr_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Yubwo buleevi, buli bwoꞌmundu úkayuvwa amagambo ga Rurema. Ikyanya Rurema woꞌbushobozi bwoshi akanyereka amabone, amasu gaani ganayigulwa, nanagwa haashi mu kumúyikumba. ");
INSERT INTO flr_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","E beene Yakobo, amaheema giinyu, ganonosiri ngana-ngana! Ishumbi ziinyu, zisimisiizi amasu bweneene. ");
INSERT INTO flr_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Yizo shumbi ziyajabusiri ngeꞌbiti bingi byeꞌbigazi. Ziri nga ndalo íziri ku ngombe yoꞌlwiji. Ziri ngeꞌbiti byeꞌmyerezi byo Nahano akabyala. Zinali ngeꞌbiti byeꞌmyerezi, ímeziri hoofi lyoꞌlwiji. ");
INSERT INTO flr_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Abahisiraheeri bagakizi ba naꞌmiiji mingi. Kiri naꞌbaana baabo, bagakizi longa amiiji nga ngiisi kwo basiimiri. Mwami wabo, agaaba mukulu bweneene ukuhima Hagagi. Ubwami bwage, bugalumbuuka hooshi. ");
INSERT INTO flr_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Rurema akabashaaza i Miisiri. Na buno, balyagagi bikalage, nga mbogo. Ngiisi milala íbashombiri, bali mu gimirangusa. Amavuha geꞌyo milala, banagavungule-vungule, banakizi batumita neꞌmyambi. ");
INSERT INTO flr_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Bali mu ba bayibishiri, mu kubunda haashi nga ndare. Aahago! Nyandi úwangagira mbu abavyule? Ngiisi ábagagashaanira Abahisiraheeri, nabo bakizi gashaanirwa. Si ngiisi ábagabadaaka boohe, bagakizi daakwa.» ");
INSERT INTO flr_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Ulya mwami Balaaki, mbu ayuvwagwe kwokwo, anayami rakarira Balaamu bweneene. Anayami yishumata ku buraakari, ti: «Si nꞌgakutumira kwo uyiji daaka abagoma baani. Haliko buno, keera wabagashaanira ubugira kashatu. ");
INSERT INTO flr_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Aaho! Uyigenderage, ugalukire i kaaya. Nꞌgakulagaania kwo ngakuhemba bwija ngana. Si Nahano ataloziizi mbu ubilonge.» ");
INSERT INTO flr_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaamu anamúshuvya: «E Balaaki, ka utaki kengiiri ngiisi kwo nꞌgabwira indumwa zaawe? ");
INSERT INTO flr_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Si nꞌgababwira: “Kundu angambeereza akajumiro kaage, kanabe kayijwiri mweꞌharija, neꞌnooro, haliko ndaalyo igambo lyo nangagira ha lwani nienyene, liba liija, kandi iri libi. Ngaadeta naaho ngiisi byo Nahano agambwira. Ee! Byebyo byo ngaadeta.” ");
INSERT INTO flr_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","«Kwokwo buno, namu galukira mu bandu baani. Haliko, ku kyanya ndazi galuka, ngatee gwanwa nakubwira ngiisi byo yaba bandu bagagirira abandu baawe, mu siku ízigayija.» ");
INSERT INTO flr_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Lyeryo, Balaamu anatanga yubu bundi buleevi kwokuno: «Yubu, bulyagagi buleevi bwa Balaamu mugala Behoori. Yubu buleevi, mbubwini ku bweranyange. ");
INSERT INTO flr_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Nyuvwiti amagambo ga Rurema. Keera anammenyeesa hiꞌgulu lyabo, anali Rurema úli Hiꞌgulu lya Byoshi. Ngweti ngaabona amabone ukulyoka Rurema woꞌbushobozi bwoshi. Na ngweti ngayami fukama imbere lyage, buzira kuziba amasu. ");
INSERT INTO flr_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Nimúbwini, haliko bitazi ba bwobuno. Si nimúbwini ku siku ízâye yije. Mu beene Yakobo, mugahuluka indonde. Mu beene Hisiraheeri, mugahuluka umwami. Agakizi vungula-vungula abandu beꞌMohabu, anakizi bera utuhanga twa beene Seeti. ");
INSERT INTO flr_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Abahedoomu bagaahimwa, kuguma naꞌBaseyiri. Naꞌbandi bandu banayiji tuula mu kihugo kyabo. Haliko, beene Hisiraheeri boohe, bagakizi longa ubuhimi. ");
INSERT INTO flr_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Mu yabo beene Yakobo, mugayima umutwali. Kundu hali ábagafuuka mu twaya, haliko uyo mutwali agabashereeza.» ");
INSERT INTO flr_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ha nyuma, Balaamu analangiiza Abahamareki, anatanga ubuleevi hiꞌgulu lyabo, ti: «Abahamareki bâli hiiti imisi ukuhima abandi booshi. Kundu kwokwo, ukuheza kwabo, bagaminikwa ngana.» ");
INSERT INTO flr_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Haaho, Balaamu analangiiza Abakeeni, anatanga ubuleevi hiꞌgulu lyabo kwokuno: «E Bakeeni, utwaya twinyu tusikamiragi. Tuli nga ngisha ízibiisirwi hiꞌgulu ku nyaala. ");
INSERT INTO flr_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Kundu kwokwo, Abahashuuri bagayiji mùgwata imbira, halinde munashereezibwe.» ");
INSERT INTO flr_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ha nyuma, umunamaleere Balaamu anashubi tanga ubuleevi kwokuno: «Yibyo byoshi, ikyanya Rurema agabigira, nyandagi úgaaba úkiri ho? ");
INSERT INTO flr_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Amashuba gagalyoka i Kitimu, ganayiji teera i Hashuuri neꞌHebeeri. Kundu kwokwo, mu kugaluka, nabo bagashereezibwa lwoshi.» ");
INSERT INTO flr_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Uyo Balaamu, ikyanya akayusa ukutanga amaleevi, anagalukira i kaaya. Mwami Balaaki, naye anataaha. ");
INSERT INTO flr_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Abahisiraheeri, ikyanya bâli shumbisiri i Shitimu, abashosi banatondeera ukukizi shuleha abakazi beꞌMohabu. ");
INSERT INTO flr_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Yabo bakazi banakizi laalika Abahisiraheeri kwo nabo bayiji bona ngiisi kwo bagweti bagatangira imigisi yabo amatuulo. Kyanatuma balya Bahisiraheeri bagakizi yiji yikumba irya migisi, iri banavwagarara kuguma ha byokulya. ");
INSERT INTO flr_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Kwokwo, kwaꞌBahisiraheeri bakatondeera ukuyikumba umuzimu Baali weꞌPehoori, halinde Nahano anabarakarira. ");
INSERT INTO flr_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Nahano anabwira Musa kwokuno: «Abimangizi booshi baꞌBahisiraheeri, uyerekane ku bweranyange ngiisi kwo bagweti bagaagira, unabayitire imbere lyani. Kwokwo, lyoꞌburaakari bwani buhooha.» ");
INSERT INTO flr_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Musa anabwira abatwi beꞌmaaja baꞌBahisiraheeri: «Mu kati kiinyu, mulolage keera úwayibiika ku muzimu Baali weꞌPehoori, unayami múyitiisa.» ");
INSERT INTO flr_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Ku kyekyo kyanya, Umuhisiraheeri muguma, anafundaga Umumidyani-kazi mu shumbi lyage. Ikyanya akagira kwokwo, kwâli riiri ku bweranyange imbere lya Musa, naꞌbandi Bahisiraheeri booshi. Na yikyo kyanya, Abahisiraheeri bâli gweti bagaliruukira ha mulyango gwiꞌheema lyeꞌmihumaanano. ");
INSERT INTO flr_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Finehaasi mugala Heryazaari, mwijukulu woꞌmugingiHarooni, mbu abonage kwokwo, anayami lyoka mu muhumaanano gwaꞌBahisiraheeri afumbiiti itumu. ");
INSERT INTO flr_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Anagenda akulikiiri ulya Muhisiraheeri, halinde mwiꞌheema. Neꞌri akababona, anayami batumitira bombi mu nda. Itumu lyanahulukaana mu Muhisiraheeri, halinde mu mukazi. Lyeryo, kirya kiija íkyâli mali minika Abahisiraheeri, kyanayimanga. ");
INSERT INTO flr_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Haliko, ábakayitwa na yikyo kiija, bâli hisiri bandu bihumbi makumi gabiri na bina. ");
INSERT INTO flr_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Kundu njubi rakariiri Abahisiraheeri, haliko keera nahooha, hiꞌgulu lya Finehaasi mugala Heryazaari, mwijukulu umugingi Harooni. Mu Bahisiraheeri booshi, ye fitiirwi, kwo ngizi ba nie gayikumbwa naaho. Kyanatuma ndaki bashereeza.» ");
INSERT INTO flr_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Ku yukwo, uyo Finehaasi, umúbwire kwo nganywana ikihango kyoꞌmutuula twe naye. ");
INSERT INTO flr_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Yikyo kihango, kuli kudeta kwo yehe neꞌbibusi byage, bagayama bali bagingi, halinde imyaka neꞌmyakuula. Mukuba, yehe, ye kalooza kwo Rurema wage alongage ulushaagwa, keera ananywaniisa Abahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Uyo Muhisiraheeri úkayitwa kuguma noꞌlya Mumidyani-kazi, iziina lyage ye Zimuri mugala Saalu. Uyo Saalu, âli riiri mwimangizi wa mu mbaga nguma ya Simyoni. ");
INSERT INTO flr_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Noꞌyo Mumidyani-kazi, iziina lyage ye Kozibi, munyere Suuri. Uyo Suuri, âli riiri muguma wa mu batwali beꞌMidyani. ");
INSERT INTO flr_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Nahano anashubi bwira Musa: ");
INSERT INTO flr_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Balya Bamidyani, ugendi bateera, unabaminike. ");
INSERT INTO flr_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Mukuba, hiꞌgulu lyoꞌbulyalya bwabo, bakamùyihindulira, banaba bagoma biinyu. Yabo Bamidyani bakamùhenda, kwo mukizi yikumba umugisi gwabo Pehoori. Na kwakundi, bo bakatuma Abahisiraheeri bingi bagateerwa neꞌkiija i Pehoori, ku kyanya ulya munyere wabo Kozibi akayitwa.» ");
INSERT INTO flr_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ikyanya Nahano akamala kirya kiija mu Bahisiraheeri, anabwira Musa na Heryazaari mugala umugingiHarooni: ");
INSERT INTO flr_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Yaba Bahisiraheeri booshi, mubaharuurage, ukukulikirana neꞌmbaga zaabo. Ha nyuma, utondobole abashosi booshi, kutondeerera ku myaka makumi gabiri neꞌngingwe. Mukuba, bo bangaba basirikaani.» ");
INSERT INTO flr_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Ku yikyo kyanya, Abahisiraheeri booshi bâli shumbisiri mu ndekeera zeꞌMohabu, ha butambi lyoꞌlwiji Yorodaani, i kajabo keꞌYeriko. Kwokwo, Musa bo noꞌmugingi Heryazaari, banamenyeesa abakulu baꞌBahisiraheeri ngiisi kwo bagaharuura abandu, ti: ");
INSERT INTO flr_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Mukizi haruura abashosi, kutondeerera ku myaka makumi gabiri neꞌngingwe, nga kwo Nahano keera akabwira Musa.» Abahisiraheeri ábakashaaga i Miisiri, umuharuuro gwabo gwo gwogu: ");
INSERT INTO flr_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Rubeni, ye fula ya Yakobo. Beene Rubeni, bo baaba: Hinoki, ye yishe waꞌBahinoki. Paalu naye, ye yishe waꞌBapaalu. ");
INSERT INTO flr_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hesirooni naye, ye yishe waꞌBahesirooni. Karimi naye, ye yishe waꞌBakarimi. ");
INSERT INTO flr_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Yabo booshi, bo beene Rubeni. Noꞌmuharuuro gwabo gwâli riiri bandu bihumbi makumi gana na bishatu na magana galinda na makumi gashatu. ");
INSERT INTO flr_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Uyo Paalu, mugala wage ye wâli Heryabu. ");
INSERT INTO flr_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Heryabu naye, bagala baage bâli Nemweri, na Datani, na Habiraamu. Datani na Habiraamu, bâli bo baabalya bimangizi ábakahuna imbere lya Musa na Harooni. Ikyanya bakayibiika ku Koora, lyo bakahuna imbere lya Nahano. ");
INSERT INTO flr_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Ku yikyo kyanya, idaho likayiguka, lyanabamira, kuguma na Koora naꞌbakulikizi baage. Ku kyekyo kyanya, abandi bandu magana gabiri na makumi gataanu banajigimba noꞌmuliro. Yukwo kujigimba kwabo, kanaba kalangikizo koꞌkukizi kengula abandu. ");
INSERT INTO flr_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Si abaana ba Koora boohe, batakafwa. ");
INSERT INTO flr_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Beene Simyoni bo baaba: Nemweri, ye yishe waꞌBanemweri. Yamini naye, ye yishe waꞌBayamini. Yakiini naye, ye yishe waꞌBayakiini. ");
INSERT INTO flr_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zeera naye, ye yishe waꞌBazeera. Sahuli naye, ye yishe waꞌBasahuli. ");
INSERT INTO flr_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Yabo booshi, bali beene Simyoni. Umuharuuro gwaꞌbashosi baabo, bâli riiri bihumbi makumi gabiri na bibiri na magana gabiri. ");
INSERT INTO flr_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Beene Gaadi bo baaba: Sefooni, ye yishe waꞌBasefooni. Haagi naye, ye yishe waꞌBahaagi. Shuuni naye, ye yishe waꞌBashuuni. ");
INSERT INTO flr_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Hoziini naye, ye yishe waꞌBahoziini. Heeri naye, ye yishe waꞌBaheeri. ");
INSERT INTO flr_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Haroodi naye, ye yishe waꞌBaharoodi. Hareeri naye, ye yishe waꞌBahareeri. ");
INSERT INTO flr_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Yabo booshi, bali beene Gaadi. Umuharuuro gwaꞌbashosi baabo, bâli riiri bihumbi makumi gana na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Mu beene Yuda, hâli riiri mugala wage wa Heeri, na Honani. Haliko, yabo bombi bakafwira i Kaanani. ");
INSERT INTO flr_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Kwokwo, beene Yuda bo baaba: Sheela, ye yishe waꞌBasheela. Pereesi naye, ye yishe waꞌBapereesi. Zeera naye, ye yishe waꞌBazeera. ");
INSERT INTO flr_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Uyo Pereesi, aba mwiꞌkondo lyage, bâli: Hesirooni, ye yishe waꞌBahesirooni. Hamuli naye, ye yishe waꞌBahamuli. ");
INSERT INTO flr_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Yabo booshi, bâli beene Yuda. Umuharuuro gwaꞌbashosi bâli riiri bihumbi makumi galinda na ndatu na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Beene Hisakaari, bo baaba: Toola, ye yishe waꞌBatoola. Puuva naye, ye yishe waꞌBapuuva. ");
INSERT INTO flr_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yashubu naye, ye yishe waꞌBayashubu. Shimurooni naye, ye yishe waꞌBashimurooni. ");
INSERT INTO flr_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Yabo booshi, bâli beene Hisakaari. Umuharuuro gwaꞌbashosi, bâli riiri bihumbi makumi galindatu na bina na magana gashatu. ");
INSERT INTO flr_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Beene Zabulooni, bo baaba: Sereedi, ye yishe waꞌBasereedi. Helooni naye, ye yishe waꞌBaheloni. Yahireeri naye, ye yishe waꞌBayahireeri. ");
INSERT INTO flr_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Yabo booshi, bâli beene Zabulooni. Umuharuuro gwaꞌbashosi, bâli riiri bihumbi makumi galindatu na magana gataanu. ");
INSERT INTO flr_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Imilala íkalyoka mu Yusefu, yo yeyi: Manaasi na Hifurahimu. ");
INSERT INTO flr_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Beene Manaasi bo baaba: Makiiri, ye yishe waꞌBamakiiri. (Uyo Makiiri ye yishe wa Giryadi.) Uyo Giryadi, ye yishe waꞌBagiryadi. ");
INSERT INTO flr_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Hyezeeri naye, ye yishe waꞌBahyezeeri. Hereki naye, ye yishe waꞌBahereki. ");
INSERT INTO flr_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Hasiryeri naye, ye yishe waꞌBahasiryeri. Shekemu naye, ye yishe waꞌBashekemu. ");
INSERT INTO flr_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemida naye, ye yishe waꞌBashemida. Hefeeri naye, ye yishe waꞌBahefeeri. ");
INSERT INTO flr_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofehadi mugala Hefeeri, ndaaye mugala wage, bwo atakabuta abaana batabana. Si akabuta abaana banyere naaho. Naꞌmaziina gaabo, hali Maala, na Nuhu, na Hogula, na Mirika, na Tiriza. ");
INSERT INTO flr_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Yabo booshi, bâli beene Manaasi. Umuharuuro gwaꞌbashosi, bâli riiri bihumbi makumi gataanu na bibiri na magana galinda. ");
INSERT INTO flr_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Beene Hifurahimu, bo baaba: Shuteela, ye yishe waꞌBashuteela. Bekeeri naye, ye yishe waꞌBabekeeri. Tahaani naye, ye yishe waꞌBatahaani. ");
INSERT INTO flr_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Uyo Shuteela akabuta Herani. Herani naye ye yishe waꞌBaherani. ");
INSERT INTO flr_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Yabo booshi, bâli beene Hifurahimu. Umuharuuro gwaꞌbashosi, bâli riiri bihumbi makumi gashatu na bibiri na magana gataanu. Iyo milala yoshi ikalyoka mu Yusefu. ");
INSERT INTO flr_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Beene Binyamiini, bo baaba: Beela, ye yishe waꞌBabeela. Hashibeeri naye, ye yishe waꞌBahashibeeri. Ahiraamu naye, ye yishe waꞌBahiraamu. ");
INSERT INTO flr_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shofamu naye, ye yishe waꞌBashofamu. Hufaamu naye, ye yishe waꞌBahufaamu. ");
INSERT INTO flr_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Uyo Beela, akabuta Haridi na Namaani. Haridi, ye yishe waꞌBaharidi. Namaani naye, ye yishe waꞌBanamaani. ");
INSERT INTO flr_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Yabo booshi, bâli beene Binyamiini. Abashosi bâli riiri bihumbi makumi gana na bitaanu na magana galindatu. ");
INSERT INTO flr_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Beene Daani, bo baaba: Shuhamu ye yishe waꞌBashuhamu. ");
INSERT INTO flr_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Yabo Badaani booshi, bâli Bashuhamu. Umuharuuro gwaꞌbashosi, bâli riiri bihumbi makumi galindatu na bina na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Beene Hasheeri, bo baaba: Himuna, ye yishe waꞌBahimuna. Hishivi naye, ye yishe waꞌBahishivi. Beriya naye, ye yishe waꞌBaberiya. ");
INSERT INTO flr_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Uyo Beriya ye yishe wa Hebeeri na Malikyeri. Hebeeri naye, ye yishe waꞌBahebeeri. Malikyeri naye, ye yishe waꞌBamalikyeri. ");
INSERT INTO flr_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Uyo Hasheeri, âli hiiti umunyere, ye Seera. ");
INSERT INTO flr_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Yabo booshi, bâli beene Hasheeri. Umuharuuro gwaꞌbashosi, bâli riiri bihumbi makumi gataanu na bishatu na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Beene Nafutaali, bo baaba: Yahizeeri ye yishe waꞌBayahizeeri. Guuni naye, ye yishe waꞌBaguuni. ");
INSERT INTO flr_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yezeeri naye, ye yishe waꞌBayezeeri. Shireemu naye, ye yishe waꞌBashireemu. ");
INSERT INTO flr_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Yabo booshi, bâli beene Nafutaali. Umuharuuro gwaꞌbashosi, bâli riiri bihumbi makumi gana na bitaanu na magana gana. ");
INSERT INTO flr_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Yabo bashosi booshi baꞌBahisiraheeri, bâli hisiri bihumbi magana galindatu na kiguma na magana galinda na makumi gashatu. ");
INSERT INTO flr_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Ikyanya bakayusa ukubaharuura, Nahano anabwira Musa kwokuno: ");
INSERT INTO flr_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Kirya kihugo, ngabaheereza kyo, bube buhyane bwabo. Na mu kukigaba, ukizi kulikira umuharuuro gwa ngiisi mulala. ");
INSERT INTO flr_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Umulala úguhimbiri, gugahaabwa buhyane buhamu. Noꞌmulala muniini, gunahaabwe ubuniini. Ngiisi mulala gugaaba noꞌbwagwo buhyane, ukukulikirana noꞌmuharuuro gwaꞌbandu baabo. ");
INSERT INTO flr_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Kundu kwokwo, mu kugaba ikihugo, bagakoleesa ikibare. Ngiisi bandu bagakizi hyana, ukukulikirana naꞌmaziina ga bashokuluza baabo. ");
INSERT INTO flr_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Ee! Bakizi koleesa ikibare, mu kugabira imilala mihamu, neꞌminiini.» ");
INSERT INTO flr_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Beene Laawi, bo baaba: Girishooni, ye yishe waꞌBagirishooni. Kohaati naye, ye yishe waꞌBakohaati. Meraari naye, ye yishe waꞌBameraari. ");
INSERT INTO flr_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Hâli riiri neꞌgindi milala, nayo iri yaꞌBalaawi: Umulala gwaꞌBalibuuni. Noꞌmulala gwaꞌBaheburooni. Noꞌmulala gwaꞌBamaali. Noꞌmulala gwaꞌBamuushi. Noꞌmulala gwaꞌBakoora. Uyo Kohaati, ye yishe wa Hamuramu. ");
INSERT INTO flr_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Uyo Hamuramu, mukaage ye wâli Yokebeedi. Uyo Yokebeedi, âli munyere Laawi, akanabutirwa i Miisiri. Uyo Yokebeedi, akabutira Hamuramu abaana babiri boꞌbutabana, noꞌmuguma woꞌbunyere. Yabo bagala, bâli Harooni na Musa. Na mwali wabo, ye wâli Miryamu. ");
INSERT INTO flr_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Harooni, akabuta abaana bana boꞌbutabana: Nadabu, na Habihu, na Heryazaari, na Hitamaari. ");
INSERT INTO flr_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Si Nadabu na Habihu boohe, ikyanya bakatangaga ituulo lyoꞌkusiriiza ku njira ítakwaniini imbere lya Nahano, banayami fwa. ");
INSERT INTO flr_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Abaana boꞌbutabana baꞌBalaawi, kutondeerera ku mwezi muguma, neꞌngingwe, bâli riiri bihumbi makumi gabiri na bishatu. Yabo beene Laawi, ikyanya abaabo Bahisiraheeri bakaharuurwa, boohe batakaharuurirwa kuguma naꞌbaabo. Mukuba boohe, ndaabwo buhyane bakalonga. ");
INSERT INTO flr_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Yabo booshi, bo bashosi bo Musa noꞌmugingi Heryazaari bakaharuura, mu tubanda tweꞌMohabu. (Yutwo tubanda, twâli riiri ku ngombe yoꞌlwiji Yorodaani, hoofi naꞌkaaya keꞌYeriko.) ");
INSERT INTO flr_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mu yabo bandu ábakaharuurwa ubuzinda, ndaaye kiri noꞌmuguma úkasigala ku balya ábakatee haruurwa na Musa noꞌmugingi Harooni mwiꞌshamba lyeꞌSinaayi. Ee! Balya ba mbere, ndaaye kiri noꞌmuguma wabo úkasigala. ");
INSERT INTO flr_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Si Nahano âli mali gwanwa ababwira kwo booshi bagaherera mwiꞌshamba. Kwokwo, ndaaye kiri noꞌmuguma úkasigala, átali Kalebu mugala Yefune, na Yoshwa mugala Nuuni. ");
INSERT INTO flr_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Hâli riiri mushosi muguma, iziina lyage ye Selofehadi. Uyo Selofehadi akabuta abanyere naaho-naaho: Maala, na Nuhu, na Hogula, na Mirika, na Tiriza. Selofehadi âli riiri mugala Hefeeri, mwijukulu Giryadi. Giryadi naye, âli riiri mugala Makiiri, mwijukulu Manaasi. Yabo booshi, bâli riiri beene Manaasi mugala Yusefu. ");
INSERT INTO flr_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Yabo banyere banagenda iwiꞌheema lyeꞌmihumaanano, banayimanga imbere lya Musa, noꞌmugingi Heryazaari, naꞌbimangizi baꞌBahisiraheeri, banadeta: ");
INSERT INTO flr_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Daata akafwira mwiꞌshamba. Kundu kwokwo, atakayitwa kuguma na beene Koora, balya ábakahuna imbere lya Nahano. Si yehe akafwa hiꞌgulu lyeꞌbyaha byage, ndaanaye mwana mutabana ye akasiga. ");
INSERT INTO flr_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Aaho! Kiꞌziina lya daata ligateerekaga mu mbaga yage, mbu bwo atabuta umwana woꞌbutabana? Nanga, maashi! Nyiitu, tuhaabwe ubwitu buhyane, ngaꞌbandi beene witu.» ");
INSERT INTO flr_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Yago magambo gaabo, Musa anagatwala imunda Nahano. ");
INSERT INTO flr_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Nahano anamúshuvya: ");
INSERT INTO flr_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Ngiisi byo banyere Selofehadi badeta, biri byoꞌkuli. Kwokwo, utasisiitwe. Si ubaheereze ubwabo buhyane, ngaꞌbandi beene wabo yishe. ");
INSERT INTO flr_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","«Kwokwo, umenyeese Abahisiraheeri: “Iri umundu angafwa, atanasige umwana woꞌbutabana, ibindu byage bikwaniini bihyanwe na banyere baage. ");
INSERT INTO flr_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Neꞌri angaba atahiiti kiri noꞌmwana munyere, ubiheereze beene wabo, babe bo bagabihyana. ");
INSERT INTO flr_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Neꞌri beene wabo abashosi bangaba ndaabo, bakulu ba yishe kandi iri balumuna ba yishe, babe bo bagabihyana. ");
INSERT INTO flr_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Neꞌri yabo bayishe wage nabo bangaba ndaabo, ibindu byage bihaabwe mwene wabo wa hoofi-hoofi, abe ye gabihyana. Umenyage bwija kwo yulu lubaaja, Abahisiraheeri booshi bakwaniini bakizi lukulikira, nga kwo nꞌgabwira Musa.”» ");
INSERT INTO flr_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Lusiku luguma, Nahano anabwira Musa kwokuno: «Uzamuukage ku guno mugazi gweꞌHabariimu, gira ulangiize ikihugo kyo ngaheereza Abahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ikyanya ugaaba keera wakilangiiza, naawe lyo ugaafwa. Ee! Lyo ugagwana bashokuluza baawe, nga kwo mukulu wawe wa Harooni naye keera akabagwana. ");
INSERT INTO flr_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Si mwembi mukahuna imbere lyani, yaho i Meriba-Kadeeshi, mwiꞌshamba lyeꞌSiini. Mukuba, ikyanya Abahisiraheeri bakandongooza, mbwaꞌmagoloovi ndaago, mwembi mwanalahira ukubayereka ubulangashane bwani.» ");
INSERT INTO flr_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Uyo Musa, ti: ");
INSERT INTO flr_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«E Nahano, Rurema, we yiji íbiri mu mitima yaꞌbandu. Ku yukwo, nakuyinginga utoolage umundu woꞌkurongoora yaba bandu. ");
INSERT INTO flr_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Uyo mundu, abe ye gakizi genda imbere lyabo. Ye ganakizi barongoora mwiꞌzibo. We kongwa we! Batasigwe nga bibuzi bizira mungere.» ");
INSERT INTO flr_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Nahano anamúshuvya: «E Musa, uyabiire Yoshwa mugala Nuuni, unamúgololere kwaꞌmaboko. Mukuba, yehe, ye riiri mwoꞌMutima gwani. ");
INSERT INTO flr_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Umúyimangike imbere lyoꞌmugingi Heryazaari, neꞌmbere lyaꞌBahisiraheeri booshi, unamúyimike imbere lyabo. ");
INSERT INTO flr_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Uyo Yoshwa, umúheereze na ku bushobozi bwawe, gira Abahisiraheeri booshi bakizi músimbaha. ");
INSERT INTO flr_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","«Uyo Yoshwa, ikyanya agalooza ukumenya ngiisi kwo Rurema aloziizi, agakizi yimanga imbere lyoꞌmugingi Heryazaari. Heryazaari agakizi koleesa ibuye liguma íriri mu buuzibwa Hurimu, gira lyo alonga ukumenya ngiisi kwo Nahano aloziizi. Kwokwo, Yoshwa naꞌBahisiraheeri booshi, bagaamenya ikyanya kyoꞌkuhuluka, neꞌkyanya kyoꞌkuyingira.» ");
INSERT INTO flr_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ikyanya Nahano akabwira Musa kwokwo, Musa anabigira. Anayabiiraga Yoshwa, anamúyimangika imbere lyoꞌmugingi Heryazaari, neꞌmbere lyoꞌmuhumaanano gwoshi gwaꞌBahisiraheeri. ");
INSERT INTO flr_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Haaho, Musa anamúgololera kwaꞌmaboko, mu kumúyimika. Bikaba nga kwo Nahano âli mali gwanwa abwira Musa. ");
INSERT INTO flr_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Nahano anashubi menyeesa Musa, ");
INSERT INTO flr_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","kwo abwire Abahisiraheeri kwokuno: «Mukizi ndangira amatuulo goꞌkusiriiza, gira umushiiriri gukizi nzimiisa. Yago matuulo, mukizi gatanga ku kyanya íkikwaniini. ");
INSERT INTO flr_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","«Ngiisi lusiku, mukizi ndangira yaga matuulo: ibyana-buzi bibiri byoꞌmwaka muguma, binabe bizira kashembo. ");
INSERT INTO flr_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Ikipanga kiguma, kikizi tangwa shesheezi, neꞌkyabo kabigingwe. ");
INSERT INTO flr_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Ngiisi kyanabuzi, kigakizi tangwa kuguma neꞌbilo bishatu byoꞌmushyano, gunabe mufushe mweꞌlitiri nguma neꞌkitolo yaꞌmavuta mayunguule bwija. ");
INSERT INTO flr_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Yiryo ituulo lyoꞌkusiriiza lwoshi ngiisi lusiku, lyo lyerirya bakandangira ku mugazi Sinaayi. Umushiiriri gwalyo, gugakizi nzimiisa. ");
INSERT INTO flr_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","«Ku kyanabuzi íkiri mu tangwa shesheezi, mukizi tanga neꞌlitiri nguma yeꞌdivaayi, munakizi ginyonera ku katanda, ákali hiꞌheema lyani. ");
INSERT INTO flr_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Ikyanabuzi kya kabiri, mukizi kitanga kabigingwe, kuguma na lirya ituulo lyoꞌmushyano na lyeꞌkinywebwa. Yago matuulo gaꞌkabigingwe, nago gali goꞌkusiriiza. Noꞌmushiiriri gwago, gugakizi nzimiisa. ");
INSERT INTO flr_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«Ulusiku lweꞌSabaato, mukizi tanga ibipanga bibiri byoꞌmwaka muguma, binabe bizira kashembo. Munatange neꞌlitiri zina zoꞌmushyano mulembu, gunabe mufushe mwaꞌmavuta goꞌmuzehituuni. Munatange neꞌbinywebwa. ");
INSERT INTO flr_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Byebyo, liꞌtuulo lyoꞌkusiriiza ku ngiisi Sabaato. Na kwakundi, munakizi tanga niꞌtuulo lyoꞌkusiriiza ngiisi lusiku kuguma neꞌbinywebwa byo bali mu kizi yonera ku katanda. ");
INSERT INTO flr_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«Mu lusiku lwa mbere lwa ngiisi mwezi, mukizi tangira Nahano agandi matuulo goꞌkusiriiza lwoshi. Kuli kudeta ishuuli zibiri, neꞌkipanga kiguma, neꞌbyanabuzi birinda byoꞌmwaka muguma. Yibyo byoshi, bibaagage bizira kashembo. ");
INSERT INTO flr_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Ngiisi shuuli, mukizi gitanga, iri kweꞌlitiri ndatu-ndatu zoꞌmushyano mulembu, gunabe mufushe mwaꞌmavuta. Na ku ngiisi kipanga, zikizi ba litiri zina. ");
INSERT INTO flr_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Na ku ngiisi kyanabuzi, zikizi ba litiri zibiri-zibiri. Galya matuulo goꞌkusiriiza lwoshi, umushiiriri gwago gugakizi nzimiisa. ");
INSERT INTO flr_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","«Na kwakundi, ku ngiisi ituulo, mukizi tanga ikinywebwa. Ku ngiisi shuuli, zibe litiri zibiri-zibiri zeꞌdivaayi. Na ku kipanga, ibe litiri nguma neꞌkitolo. Na ku ngiisi kyanabuzi, ibe litiri nguma. Yago matuulo, mukizi gatanga mu mwaka gwoshi, ku ngiisi lusiku lwa mbere lwoꞌmwezi. ");
INSERT INTO flr_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Ku lwolwo lusiku, mutangage neꞌkihebe, libe ituulo lyoꞌkukogwa ibyaha biinyu. (Yago matuulo, gagaaba kuguma na galya goꞌkusiriiza lwoshi, na geꞌbinywebwa.) ");
INSERT INTO flr_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«Ulusiku lukulu lweꞌPasaka ya Nahano, mukizi lushambaalira mu siku ikumi na zina zoꞌmwezi gwa mbere. ");
INSERT INTO flr_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Noꞌkutondeerera ku siku ikumi na zitaanu za gwogwo mwezi, muhisagye isiku zirinda mugweti mugaalya imikate mizira saama. ");
INSERT INTO flr_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Yulwo lusiku lwa mbere, ube noꞌmuhumaanano mutaluule. Hatagirage umukolwa gwo mugaagira. ");
INSERT INTO flr_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","«Nie Nahano! Kwokwo, mugandeetera amatuulo goꞌkusiriiza lwoshi, kuli kudeta ishuuli zibiri, neꞌkipanga kiguma, neꞌbyanabuzi birinda byoꞌmwaka muguma. Yibyo byoshi, bibaagage bizira kashembo. ");
INSERT INTO flr_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Ku ngiisi shuuli, mutange ilitiri ndatu-ndatu zoꞌmushyano, mufushe mwaꞌmavuta goꞌmuzehituuni. Na ku kipanga, mutange ilitiri zina. ");
INSERT INTO flr_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Na ku ngiisi kyanabuzi, mutange ilitiri zibiri-zibiri. ");
INSERT INTO flr_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Mutangage neꞌkihebe kiguma, libe ituulo lyoꞌkuhyula, halinde munabe mukoli tungiini imbere lyani. ");
INSERT INTO flr_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Yaga matuulo, mugayushuule ku lirya ituulo lyo muli mu gatanga ngiisi shesheezi. ");
INSERT INTO flr_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","«Mu zirya siku ngulu zirinda, ngiisi lusiku, mugakizi ndangira ibyokulya. Umushiiriri gwabyo, gugakizi nzimiisa. Ku yibyo byokulya, mukizi tanga na lirya ituulo lyoꞌkusiriiza ngiisi lusiku, kuguma neꞌkinywebwa. ");
INSERT INTO flr_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Nie Nahano! Kwokwo, ku lusiku úlugira izirinda, mugashubi kuumana hiꞌgulu lyoꞌkunyikumba. Hatagirage umukolwa gwo mugaagira. ");
INSERT INTO flr_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«Niehe, nie Nahano. Kwokwo, ulusiku lukulu lwaꞌmayinga, mugakizi ndeetera itomola lyeꞌngano mbyahya. Ku lwolwo lusiku, munakuumane hiꞌgulu lyoꞌkunyikumba. Hatagirage umukolwa gwo mugaagira. ");
INSERT INTO flr_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","«Ku lwolwo lusiku, mundangire ituulo lyoꞌkusiriiza lwoshi, ishuuli zibiri, neꞌkipanga kiguma, neꞌbyanabuzi birinda byoꞌmwaka muguma. Yibyo byoshi, umushiiriri gwabyo guganzimiisa. ");
INSERT INTO flr_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Ku ngiisi shuuli, mugandangira ilitiri ndatu-ndatu zoꞌmushyano mufushe mwaꞌmavuta goꞌmuzehituuni. Na ku kipanga, mugandangira ilitiri zina. ");
INSERT INTO flr_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Na ku ngiisi kyanabuzi, zibe litiri zibiri-zibiri. ");
INSERT INTO flr_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","«Na kwakundi, mutangage ituulo lyeꞌkihebe. Yikyo kihebe, mukisiriize hiꞌgulu lyoꞌkukogwa ibyaha biinyu, halinde munabe mukoli tungiini imbere lyani. ");
INSERT INTO flr_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Yago matuulo gooshi, kuguma naꞌmatuulo geꞌdivaayi, mukizi gatanga, kuguma na galya matuulo goꞌkusiriiza ngiisi lusiku, kuguma naꞌmatuulo goꞌmushyano. Birya bitugwa byoshi byo mugatanga, bibaagage bizira kashembo. ");
INSERT INTO flr_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«Ngiisi mwaka, mu lusiku luguma lwoꞌmwezi gwa kalinda, mukizi kuumana hiꞌgulu lyoꞌkunyikumba, nie Nahano. Ku yulwo lusiku, hatagire umukolwa gwo mugaagira. Si lwo lusiku lwoꞌkudihiriza ibibuga. ");
INSERT INTO flr_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","«Yulwo lusiku, mundangire ituulo lyeꞌshuuli nguma, neꞌkipanga kiguma, neꞌbyanabuzi birinda byoꞌmwaka muguma. Byoshi bibaagage bizira kashembo. Ikyanya mugabisiriiza, umushiiriri gwabyo guganzimiisa. ");
INSERT INTO flr_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Iyo shuuli, mukizi gitanga kuguma neꞌlitiri ndatu zoꞌmushyano mufushe mwaꞌmavuta goꞌmuzehituuni. Na ku kipanga, mutangage ilitiri zina. ");
INSERT INTO flr_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Na ku ngiisi kyanabuzi, mukizi tanga ilitiri zibiri-zibiri. ");
INSERT INTO flr_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","«Na kwakundi, mutangage ikihebe, libe ituulo lyoꞌkukogwa ibyaha biinyu, halinde munabe mukoli tungiini imbere lyani. ");
INSERT INTO flr_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Yago matuulo, ikyanya mugakizi gandangira, umushiiriri gwago guganzimiisa. Na kwakundi, mutangage neꞌngano neꞌbinywebwa. Yago matuulo, mukizi gatanga, kuguma na galya gandi ágali mu tangwa ngiisi lusiku, na ku ngiisi mwezi. ");
INSERT INTO flr_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«Ngiisi mwaka, mukizi kuumana mu siku ikumi zoꞌmwezi gwa kalinda, hiꞌgulu lyoꞌkunyikumba. Ku yulwo lusiku, muyishalise, hatanagire umukolwa gwo mugaagira. ");
INSERT INTO flr_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","«Ku lwolwo lusiku, mundangi