﻿USE sofia;
DROP TABLE IF EXISTS sofia.fin_vpl;
CREATE TABLE fin_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES fin_vpl WRITE;
INSERT INTO fin_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jeesus Kristus oli kuningas Daavidin ja Aabrahamin jälkeläinen. Nämä ovat hänen esi-isänsä: ");
INSERT INTO fin_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aabraham oli Iisakin isä. Iisak oli Jaakobin isä, Jaakob oli Juudan ja tämän veljien isä. ");
INSERT INTO fin_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juuda oli Pereksen ja Serahin isä (heidän äitinsä oli Taamar). Peres oli Hesronin isä. Hesron oli Raamin isä. ");
INSERT INTO fin_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Raam oli Amminadabin isä. Amminadab oli Nahsonin isä. Nahson oli Salman isä. ");
INSERT INTO fin_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salma oli Booaan isä (hänen äitinsä oli Raahab). Booas oli Oobedin isä (hänen äitinsä oli Ruut). Oobed oli Iisain ");
INSERT INTO fin_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ja Iisai kuningas Daavidin isä. Daavid oli Salomon isä – hänen äitinsä oli Uurian vaimo. ");
INSERT INTO fin_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo oli Rehabeamin isä. Rehabeam oli Abiamin isä. Abiam oli Aasan isä. ");
INSERT INTO fin_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Aasa oli Joosafatin isä. Joosafat oli Jooramin isä. Jooram oli Ussian isä. ");
INSERT INTO fin_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ussia oli Jootamin isä. Jootam oli Aahaan isä. Aahas oli Hiskian isä. ");
INSERT INTO fin_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskia oli Manassen isä. Manasse oli Aamonin isä. Aamon oli Joosian isä. ");
INSERT INTO fin_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Joosia oli Jekonjan ja hänen veljiensä isä – pojat syntyivät niihin aikoihin, kun kansa karkotettiin Babyloniin. ");
INSERT INTO fin_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Karkotuksen jälkeen Jekonjalle syntyi Sealtiel, Sealtielille Serubbaabel, ");
INSERT INTO fin_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubbaabelille Abiud, Abiudille Eljakim, Eljakimille Asor, ");
INSERT INTO fin_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asorille Saadok, Saadokille Akim, Akimille Eliud, ");
INSERT INTO fin_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudille Eleasar, Eleasarille Mattan, Mattanille Jaakob ja ");
INSERT INTO fin_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jaakobille Joosef, joka meni naimisiin Marian, Jeesuksen Kristuksen äidin, kanssa. ");
INSERT INTO fin_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Aabrahamista Daavidiin on siis neljätoista sukupolvea, Daavidista Babyloniin karkottamiseen toiset neljätoista ja siitä Kristukseen taas neljätoista. ");
INSERT INTO fin_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jeesuksen Kristuksen syntymää edelsivät seuraavat tapahtumat: Jeesuksen äiti Maria oli kihloissa Joosefin kanssa. Mutta kun Maria vielä oli neitsyt, hän alkoi odottaa lasta Pyhän Hengen vaikutuksesta. ");
INSERT INTO fin_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Silloin Joosef katsoi, että hänen oli purettava kihlaus, mutta hän ei halunnut häpäistä Mariaa muiden silmissä, vaan päätti erota kaikessa hiljaisuudessa. ");
INSERT INTO fin_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Miettiessään asiaa Joosef nukahti. Unessa hän näki enkelin seisovan vieressään. Enkeli sanoi: »Joosef, Daavidin poika, älä epäröi mennä Marian kanssa naimisiin. Hän odottaa lasta, joka on saanut alkunsa Pyhästä Hengestä. ");
INSERT INTO fin_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Maria saa pojan. Sinun on annettava lapselle nimeksi Jeesus, joka merkitsee pelastajaa, sillä hän pelastaa kansansa sen synneistä. ");
INSERT INTO fin_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Näin toteutuu Jumalan lupaus, jonka hän antoi profeetan välityksellä: ");
INSERT INTO fin_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","’Kuulkaa! Neitsyt alkaa odottaa lasta! Hän synnyttää pojan, jota sanotaan Immanueliksi.’ Nimi merkitsee: ’Jumala on meidän kanssamme’.» ");
INSERT INTO fin_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Silloin Joosef haki Marian kotiinsa ja otti hänet vaimokseen, niin kuin enkeli oli käskenyt. ");
INSERT INTO fin_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Maria säilyi kuitenkin neitsyenä lapsen syntymään asti. Joosef antoi pojalle nimen Jeesus. ");
INSERT INTO fin_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jeesus syntyi Juudeassa, Betlehemin kaupungissa, kuningas Herodeksen hallituskaudella. Idästä tuli silloin Jerusalemiin muutamia tähtientutkijoita. He kysyivät: ");
INSERT INTO fin_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","»Missä se äskettäin syntynyt juutalaisten kuningas on? Näimme kaukana idässä hänen tähtensä ja olemme tulleet osoittamaan hänelle kunnioitusta.» ");
INSERT INTO fin_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kuningas Herodes hämmästyi kovasti kuullessaan tämän. Huhut alkoivat levitä Jerusalemissa. ");
INSERT INTO fin_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodes kutsui koolle juutalaisten hengelliset johtajat. »Ennustivatko profeetat, missä Messias syntyy?» hän kysyi. ");
INSERT INTO fin_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","»Kyllä, Betlehemissä», he vastasivat. »Profeetta Miika kirjoitti: ");
INSERT INTO fin_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","’Pieni Betlehemin kaupunki, et ole Juudan kaupunkien joukossa ollenkaan vähäpätöinen, sillä sinusta nousee kansani Israelin hallitsija.’» ");
INSERT INTO fin_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herodes kutsui tähtientutkijat salaa luokseen ja uteli heiltä tähden ilmestymisen tarkkaa ajankohtaa. ");
INSERT INTO fin_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Hän käski miesten lähteä Betlehemiin etsimään lasta. »Kun olette löytäneet hänet, tulkaa kertomaan, missä hän on. Minäkin haluaisin mennä osoittamaan hänelle kunnioitusta», Herodes sanoi. ");
INSERT INTO fin_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Vieraat lähtivät heti matkaan. Silloin he taas näkivät tähden. Se kulki heidän edellään, kunnes pysähtyi sen paikan yläpuolelle, jossa lapsi oli. ");
INSERT INTO fin_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Miesten riemulla ei ollut rajoja! ");
INSERT INTO fin_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","He menivät sisälle taloon, jossa lapsi ja hänen äitinsä Maria olivat, ja kumarsivat lapselle kunnioittavasti. Sitten he ottivat esiin Jeesukselle tuomansa lahjat: kultaa, suitsutusainetta ja mirhaa. ");
INSERT INTO fin_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ennen kuin tähtientutkijat lähtivät kotimatkalle, he saivat unessa Jumalalta varoituksen olla menemättä enää Herodeksen luo. Niinpä he palasivat toista kautta kotiin. ");
INSERT INTO fin_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Heidän lähtönsä jälkeen Herran enkeli ilmestyi unessa Joosefille. »Lähde kiireesti lapsen ja hänen äitinsä kanssa Egyptiin», enkeli sanoi. »Pysy siellä, kunnes käsken sinun palata. Kuningas Herodes yrittää nimittäin tappaa lapsen.» ");
INSERT INTO fin_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Joosef heräsi ja lähti heti yöllä Marian ja lapsen kanssa Egyptiä kohti. ");
INSERT INTO fin_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Hän asui siellä kuningas Herodeksen kuolemaan asti. Näin toteutui profeetan ennustus: »Olen kutsunut poikani Egyptistä.» ");
INSERT INTO fin_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes oli raivoissaan, kun tajusi, että idän tähtientutkijat olivat pettäneet hänet. Hän lähetti Betlehemiin sotilaita tappamaan kaupungista ja sen ympäristöstä kaikki kaksivuotiaat ja sitä nuoremmat pojat. Vieraat olivat nimittäin kertoneet hänelle, että tähti oli näkynyt ensi kertaa jo kaksi vuotta aikaisemmin. ");
INSERT INTO fin_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Herodeksen raa’assa teossa toteutui profeetta Jeremian ennustus: ");
INSERT INTO fin_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","»Tuskan huudot kuuluvat Raamasta: Raakel itkee hillittömästi lapsiaan, eikä kukaan pysty lohduttamaan häntä, sillä hänen lapsensa ovat kuolleet.» ");
INSERT INTO fin_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Kun Herodes oli kuollut, Herran enkeli ilmestyi unessa Joosefille, joka oli yhä Egyptissä. Enkeli sanoi: ");
INSERT INTO fin_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","»Lähde lapsen ja hänen äitinsä kanssa takaisin Israeliin, sillä ne, jotka yrittivät tappaa lapsen, ovat kuolleet.» ");
INSERT INTO fin_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Joosef, Maria ja Jeesus palasivat heti Israeliin. ");
INSERT INTO fin_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Matkalla Joosef sai kuulla, että Herodeksen poika Arkelaus oli tullut isänsä jälkeen Juudean kuninkaaksi, eikä Joosef sen vuoksi uskaltanut jäädä sinne. Unessa Jumala kehotti häntä menemään Galileaan, ");
INSERT INTO fin_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","missä hän asettui asumaan Nasaretiin. Näin Messiasta koskevat profeettojen ennustukset toteutuivat jälleen. Jesajahan oli kirjoittanut: »Häntä sanotaan Nasaretilaiseksi». ");
INSERT INTO fin_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Siihen aikaan kun Jeesus ja hänen kotiväkensä asuivat Nasaretissa, Johannes Kastaja alkoi saarnata Juudean autiomaassa. Hän julisti: ");
INSERT INTO fin_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","»Luopukaa synneistänne, sillä taivaan valtakunta alkaa pian toteutua.» ");
INSERT INTO fin_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jo satoja vuosia aikaisemmin oli profeetta Jesaja ennustanut Johanneksen työstä: »Kuulen autiomaasta äänen: ’Kunnostakaa Herralle tie, tasoittakaa hänelle polku.’» ");
INSERT INTO fin_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johanneksella oli kamelinkarvoista kudottu puku ja nahkavyö. Hänen ravintonaan olivat heinäsirkat ja luonnonhunaja. ");
INSERT INTO fin_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ihmisiä tuli Jerusalemista, kaikkialta Jordanin laaksosta ja eri puolilta Juudeaa autiomaahan kuuntelemaan hänen puhettaan. ");
INSERT INTO fin_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kun he tunnustivat syntinsä, Johannes kastoi heidät Jordanissa. ");
INSERT INTO fin_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kun Johannes näki useiden fariseusten ja saddukeusten tulevan kastettaviksi, hän arvosteli heitä ankarasti. »Te käärmeet!» hän sanoi. »Kuka teille on sanonut, että voitte paeta Jumalan vihaa? ");
INSERT INTO fin_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kastan teidät vasta sitten, kun tekonne osoittavat, että olette palanneet Jumalan luo. ");
INSERT INTO fin_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Älkää luulko olevanne turvassa siksi, että olette juutalaisia, Aabrahamin jälkeläisiä. Se ei todista mitään, sillä Jumala voi vaikka näistä kivistä luoda juutalaisia! ");
INSERT INTO fin_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jumalan tuomion kirves on valmiina kaatamaan jokaisen hedelmättömän puun. Kaadetut puut poltetaan. ");
INSERT INTO fin_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Minä kastan vedellä kaikki, jotka katuvat syntejään. Minun jälkeeni tulee toinen, joka on minua paljon suurempi – en kelpaa kantamaan edes hänen kenkiään! Hän kastaa teidät Pyhällä Hengellä ja tulella. ");
INSERT INTO fin_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Hän erottelee jyvistä akanat ja polttaa ne ikuisessa tulessa, mutta kokoaa jyvät talteen.» ");
INSERT INTO fin_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jeesus lähti kotoaan Galileasta. Hän tuli Jordanille Johanneksen kastettavaksi, ");
INSERT INTO fin_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","mutta Johannes ei halunnut tehdä sitä. »Ei missään tapauksessa», hän sanoi. »Sinunhan pitäisi kastaa minut.» ");
INSERT INTO fin_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mutta Jeesus vastasi: »Kasta sinä kuitenkin minut, sillä minun on tehtävä niin kuin Jumala tahtoo.» Lopulta Johannes suostui. ");
INSERT INTO fin_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kun Jeesus nousi kasteen jälkeen vedestä, hän näki taivaan avautuvan ja Jumalan Hengen laskeutuvan sieltä kuin kyyhkynen. ");
INSERT INTO fin_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ylhäältä kuului ääni: »Tämä on minun rakas Poikani, suuri iloni, jonka olen valinnut Pelastajaksi.» ");
INSERT INTO fin_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tämän jälkeen Pyhä Henki vei Jeesuksen autiomaahan saatanan kiusattavaksi. ");
INSERT INTO fin_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jeesus ei syönyt neljäänkymmeneen vuorokauteen mitään, ja hänelle tuli kova nälkä. ");
INSERT INTO fin_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Silloin saatana yritti saada häntä muuttamaan kiviä leiviksi. »Voit sillä osoittaa olevasi Jumalan Poika», hän houkutteli. ");
INSERT INTO fin_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jeesus kieltäytyi: »Raamattu sanoo, ettei leivällä voi ravita ihmisen sielua – sen ravitsee vain Jumalan sanan totteleminen.» ");
INSERT INTO fin_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sitten saatana vei Jeesuksen Jerusalemin temppelin katolle. ");
INSERT INTO fin_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","»Hyppää alas», hän kehotti. »Sitten näemme, oletko Jumalan Poika. Raamatussahan sanotaan: ’Jumala lähettää enkelinsä varjelemaan häntä, niin ettei hän satuta itseään.’ Enkelit eivät anna Jumalan Pojan murskautua kiviin.» ");
INSERT INTO fin_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mutta Jeesuskin vetosi Raamattuun: »Siellä myös kielletään panemasta Jumalaa näin järjettömään kokeeseen!» ");
INSERT INTO fin_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Seuraavaksi saatana vei hänet hyvin korkean vuoren huipulle ja esitteli hänelle kaikki maailman valtakunnat ja niiden rikkaudet. ");
INSERT INTO fin_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","»Annan ne kaikki sinulle, jos polvistut eteeni ja palvot minua», saatana lupasi. ");
INSERT INTO fin_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","»Mene tiehesi», Jeesus sanoi. »Raamatussa käsketään palvelemaan ja tottelemaan vain Jumalaa.» ");
INSERT INTO fin_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Silloin saatana lähti. Enkelit tulivat huolehtimaan Jeesuksesta. ");
INSERT INTO fin_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","Kun Jeesus kuuli, että Johannes oli vangittu, hän palasi Juudeasta kotiinsa Galilean Nasaretiin. Sieltä hän muutti pian Kapernaumiin Genesaretin järven rannalle Sebulonin ja Naftalin alueelle. ");
INSERT INTO fin_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Näin toteutui Jesajan ennustus: ");
INSERT INTO fin_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","»Sebulonin ja Naftalin alueella, järven rannalla, Jordanin toisella puolella ja Pohjois-Galileassa, missä asuu paljon ulkomaalaisia, ");
INSERT INTO fin_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","loisti pimeässä eläville ihmisille kirkas valo. He olivat eläneet kuoleman varjossa, mutta nyt he pääsivät valoon.» ");
INSERT INTO fin_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tästä lähtien Jeesus alkoi julistaa: »Kääntykää pois synnistä ja palatkaa Jumalan luo, sillä hänen valtakuntansa on lähellä.» ");
INSERT INTO fin_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Eräänä päivänä Jeesus käveli Genesaretin järven rannalla. Hän tapasi kaksi veljestä: Simonin, jota sanotaan Pietariksi, ja Andreaan. Miehet olivat kalastajia ja heittivät juuri verkkoa järveen. ");
INSERT INTO fin_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jeesus huusi: »Lähtekää minun mukaani! Näytän teille miten voitte kalastaa ihmisiä!» ");
INSERT INTO fin_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pietari ja Andreas jättivät heti verkkonsa ja lähtivät kulkemaan Jeesuksen kanssa. ");
INSERT INTO fin_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Kun he kävelivät pitkin rantaa, Jeesus näki siellä myös Sebedeuksen pojat, Jaakobin ja Johanneksen. He istuivat isänsä kanssa veneessä paikkaamassa verkkoja. Jeesus kutsui heidätkin. ");
INSERT INTO fin_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","He lopettivat heti työnsä, jättivät isänsä veneeseen ja lähtivät Jeesuksen mukaan. ");
INSERT INTO fin_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jeesus kierteli ympäri Galileaa, opetti juutalaisten synagogissa ja kertoi kaikille ihmisille iloisen uutisen taivaan valtakunnasta. Hän paransi myös kaikenlaisia sairauksia. ");
INSERT INTO fin_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tieto hänen tekemistään ihmeistä levisi Galilean ulkopuolellekin. Jopa Syyriasta asti tuli ihmisiä hänen parannettavakseen. Jeesus paransi heidät kaikki – olivatpa he sitten demonien vallassa, kaatumatautisia, halvaantuneita tai muuten sairaita. ");
INSERT INTO fin_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galileasta, Kymmenen kaupungin alueelta, Jerusalemista, koko Juudeasta ja Jordanin toiselta puolelta lähti valtava ihmisjoukko seuraamaan häntä. ");
INSERT INTO fin_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Eräänä päivänä väkeä alkoi taas kokoontua. Jeesus lähti oppilaidensa kanssa vuorenrinteelle ja istuutui opettamaan heitä. ");
INSERT INTO fin_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","»Onnellisia ovat ne ihmiset, jotka tarvitsevat Jumalaa: heille annetaan taivaan valtakunta», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","»Onnellisia ovat murheelliset, sillä he saavat lohdutuksen. ");
INSERT INTO fin_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Onnellisia ovat nöyrät, sillä koko maa on heidän. ");
INSERT INTO fin_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Onnellisia ovat ne, jotka toivovat Jumalan tahdon tapahtuvan: heidän toiveensa toteutuu. ");
INSERT INTO fin_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Onnellisia ovat hyväsydämiset ja ystävälliset ihmiset: heidät itsensäkin armahdetaan. ");
INSERT INTO fin_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Onnellisia ovat mieleltään puhtaat, sillä he näkevät Jumalan. ");
INSERT INTO fin_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Onnellisia ovat rauhantekijät, sillä Jumala kutsuu heitä lapsikseen. ");
INSERT INTO fin_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Onnellisia ovat nekin, joita vainotaan uskonsa tähden, sillä taivaan valtakunta on heidän. ");
INSERT INTO fin_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Olkaa vain iloisia, kun teitä pilkataan ja syrjitään ja teistä puhutaan valetta siksi, että seuraatte minua! Saatte taivaassa suunnattoman arvokkaan palkinnon. Muistakaa, että entisaikojen profeettojakin vainottiin. ");
INSERT INTO fin_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Te olette maailman suola. Jos suola menettää makunsa, siitä ei ole enää kenellekään mitään hyötyä, ja se heitetään pois. ");
INSERT INTO fin_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Te olette maailman valo, vuorella oleva kaupunki, joka näkyy kauas pimeässä. ");
INSERT INTO fin_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","16","Älkää estäkö valoanne näkymästä! Antakaa sen loistaa kaikille: tehkää hyvää, niin kaikki ylistävät Isäänne, joka on taivaassa. ");
INSERT INTO fin_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Alkää luulko, että olen tullut kumoamaan Mooseksen lain ja profeettojen varoitukset. Olen tullut täyttämään ja toteuttamaan ne. ");
INSERT INTO fin_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Niin kauan kuin taivas ja maa ovat olemassa, pysyy lakikin pienintä yksityiskohtaa myöten voimassa – aina siihen asti kunnes loppu tulee. ");
INSERT INTO fin_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jos joku rikkoo pienimmänkin käskyn ja opettaa muitakin tekemään samalla tavalla, hän on taivaan valtakunnassa kaikkein vähäpätöisin. Ne, jotka opettavat noudattamaan Jumalan lakeja ja itsekin tottelevat niitä, ovat siellä suuria. ");
INSERT INTO fin_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Pitäkää varanne! Jos teillä ei ole syvempää yhteyttä Jumalaan kuin fariseuksilla ja muilla juutalaisten johtajilla, ette pääse taivaan valtakuntaan. ");
INSERT INTO fin_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Mooseksen lain mukaan murhaajalle kuuluu kuolemanrangaistus. ");
INSERT INTO fin_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mutta minä sanon teille, että jos suututte veljeenne, olette jo ansainneet rangaistuksen. Jos sanotte häntä typeräksi, teidät pitäisi tuomita oikeudessa, ja jos sanotte häntä hulluksi, ansaitsisitte helvetin tulen. ");
INSERT INTO fin_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Kun seisot temppelissä alttarin edessä tuomassa lahjaa Jumalalle, voit äkkiä muistaa, etteivät ystäväsi ja sinun välit ole kunnossa. ");
INSERT INTO fin_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Jätä silloin lahjasi alttarin luo ja mene selvittämään asiat ystäväsi kanssa. Tule vasta sitten uhraamaan. ");
INSERT INTO fin_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","26","Tee pian sovinto, jos olet jonkun kanssa riidoissa. Hän voi muuten haastaa sinut oikeuteen. Joudut velkavankeuteen etkä pääse vapaaksi, ennen kuin olet maksanut viimeisenkin killingin. ");
INSERT INTO fin_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Mooseksen laki kieltää tekemästä aviorikosta, ");
INSERT INTO fin_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","mutta minä sanon teille, että jokainen, joka katsookin naista himoiten, on jo sisimmässään tehnyt hänen kanssaan aviorikoksen. ");
INSERT INTO fin_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jos siis silmäsi saa sinut himoitsemaan, revi se irti ja heitä menemään! On parempi, että menetät silmäsi kuin että joudut helvettiin. ");
INSERT INTO fin_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Samoin jos oikea kätesi saa sinut tekemään väärin, leikkaa se irti ja heitä menemään. On parempi elää käsipuolena kuin joutua kadotukseen. ");
INSERT INTO fin_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Mooseksen laki sanoo: ’Jos joku haluaa erota vaimostaan, hänen on vain annettava tälle erotodistus.’ ");
INSERT INTO fin_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Vakuutan teille, että jos ero johtuu muusta kuin uskottomuudesta, eroamalla mies pakottaa vaimonsa aviorikokseen. Myös se, joka menee eronneen naisen kanssa naimisiin, tekee aviorikoksen. ");
INSERT INTO fin_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Mooseksen laki sanoo myös: ’Älä riko valaa, jonka olet antanut Jumalalle, vaan täytä kaikki valasi.’ ");
INSERT INTO fin_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mutta minäpä sanon teille: Älkää koskaan vannoko! Älkää vannoko taivaan kautta, sillä taivas on Jumalan valtaistuin. ");
INSERT INTO fin_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Älkää vannoko maan nimessä, sillä maa on Jumalan astinlauta. Älkää vannoko myöskään Jerusalemin kautta. Se on suuren kuninkaan pääkaupunki. ");
INSERT INTO fin_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Älä vanno pääsi kautta, sillä et voi muuttaa hiuksiasi mustiksi tai valkoisiksi. ");
INSERT INTO fin_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Sano vain yksinkertaisesti ’kyllä’ tai ’ei’! Sanasi riittää. Asiat eivät ole oikein, jos sinun on vahvistettava lupauksesi valalla. ");
INSERT INTO fin_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Mooseksen lain mukaan pahoinpitely on kostettava samalla mitalla: ’Silmä silmästä, hammas hampaasta.’ ");
INSERT INTO fin_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mutta minä sanon: Älkää ruvetko taistelemaan väkivaltaa vastaan. Jos joku lyö sinua poskelle, käännä hänelle toinenkin. ");
INSERT INTO fin_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jos joku tahtoo käydä kanssasi oikeutta ja viedä sinulta paidan, anna hänelle takkisikin. ");
INSERT INTO fin_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jos Rooman sotilaat vaativat sinua kantamaan tavaroitaan kilometrin, kanna kaksi. ");
INSERT INTO fin_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jos joku pyytää sinulta jotakin, anna se hänelle, äläkä käännä selkääsi sille, joka tahtoisi sinulta lainaa. ");
INSERT INTO fin_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Meitä on käsketty rakastamaan ystäviämme ja vihaamaan vihollisiamme. ");
INSERT INTO fin_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Minä käsken teidän rakastaa myös vihollisianne. Rukoilkaa niiden puolesta, jotka vainoavat teitä. ");
INSERT INTO fin_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Silloin osoittaudutte Taivaan Isän lapsiksi. Hänen aurinkonsa paistaa sekä pahoille että hyville, ja hän antaa sataa sekä rehellisille että epärehellisille. ");
INSERT INTO fin_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kyllä pahat ihmisetkin rakastavat niitä, jotka rakastavat heitä. Mitä ihmeellistä siinä on? ");
INSERT INTO fin_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jos osoitatte ystävyyttä vain omille ystävillenne, ette mitenkään eroa pakanoista. ");
INSERT INTO fin_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Teidän on oltava yhtä täydellisiä kuin Isänne, joka on taivaassa.» ");
INSERT INTO fin_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","»Älkää tehkö hyvää siksi, että muut kehuisivat teitä. Silloin ette saa palkkaa Taivaan Isältä. ");
INSERT INTO fin_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Kun autat jotakuta, älä kerro siitä muille. Teeskentelijät antavat soittaa torvea kadulla ja synagogassa, kun he vievät lahjoitustaan! He ovat totisesti jo saaneet koko palkkansa. ");
INSERT INTO fin_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kun teet hyvää jollekin, tee se niin huomaamattomasti, ettei vasen kätesi tiedä, mitä oikea tekee. ");
INSERT INTO fin_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Isäsi tuntee kaikki salaisuudet ja palkitsee sinut. ");
INSERT INTO fin_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Puhun teille nyt rukoilemisesta. Älkää rukoilko kadunkulmissa ja synagogissa ihmisten nähden niin kuin teeskentelijät. He eivät saa muuta palkkaa kuin ihmisten huomion. ");
INSERT INTO fin_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mene sinä sen sijaan jonnekin yksinäisyyteen. Sulje ovi perässäsi ja rukoile hiljaa Isääsi. Hän tietää salaisetkin ajatuksesi ja palkitsee sinut. ");
INSERT INTO fin_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Älkää rukoillessanne hokeko tyhjää niin kuin pakanat. He luulevat, että mitä monisanaisempia he ovat, sitä varmemmin heidän rukouksensa kuullaan. ");
INSERT INTO fin_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Teidän Isänne nimittäin tietää täsmälleen, mitä tarvitsette, ennen kuin olette ehtineet pyytääkään häneltä mitään! ");
INSERT INTO fin_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rukoilkaa vaikka näin: ’Isämme, joka olet taivaassa! Me kunnioitamme pyhää nimeäsi. ");
INSERT INTO fin_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Anna valtakuntasi tulla pian. Tapahtukoon sinun tahtosi sekä maan päällä että taivaassa. ");
INSERT INTO fin_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Anna meille tänäänkin jokapäiväinen leipä. ");
INSERT INTO fin_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Anna anteeksi meidän syntimme, niin kuin mekin olemme antaneet anteeksi niille, jotka ovat tehneet meille pahaa. ");
INSERT INTO fin_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Älä johdata meitä kiusaukseen, vaan vapauta meidät pahasta. Aamen.’ ");
INSERT INTO fin_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Taivaan Isä antaa teille anteeksi, jos annatte itse anteeksi niille, jotka tekevät teille vääryyttä. ");
INSERT INTO fin_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jos te kieltäydytte antamasta anteeksi, ei Isäkään anna teille anteeksi. ");
INSERT INTO fin_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","17-18","Ihmisten ei tarvitse tietää myöskään teidän paastostanne. Teeskentelijät ovat paastotessaan surkean näköisiä, että muut säälisivät heitä. Sääli onkin ainoa palkka, jonka he saavat. Olkaa reippaan näköisiä, ettei kukaan aavistakaan teidän paastoavan. Vain Isänne, joka tietää kaiken, on selvillä asiasta, ja hän palkitsee teidät. ");
INSERT INTO fin_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Älkää kootko aarteita tähän maailmaan, jossa ne menettävät arvonsa tai voidaan varastaa. ");
INSERT INTO fin_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kerätkää niitä taivaaseen. Siellä ne säilyttävät arvonsa ja pysyvät hyvässä tallessa. ");
INSERT INTO fin_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jos aarteenne ovat taivaassa, sydämennekin on siellä. ");
INSERT INTO fin_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jos hengellinen näkökykysi on kunnossa, valo loistaa sieluusi. ");
INSERT INTO fin_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jos taas pahat ajatukset ovat vioittaneet sinua, olet hengellisessä pimeydessä. Miten synkkä se onkaan! ");
INSERT INTO fin_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Et voi palvella kahta isäntää, Jumalaa ja omaisuutta. Jos rakastat toista, vihaat toista. ");
INSERT INTO fin_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Siksi annan teille neuvon: älkää murehtiko ruuasta, juomasta ja vaatteista. Olette saaneet elämän, ja se on ihmiselle paljon tärkeämpi kuin syöminen tai pukeutuminen. ");
INSERT INTO fin_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Katsokaa lintuja! Ne eivät murehdi ravinnostaan, eivät kylvä eivätkä korjaa satoa, sillä Taivaan Isä ruokkii ne. Te olette Isällenne paljon arvokkaampia kuin linnut. ");
INSERT INTO fin_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ette voi pidentää elämäänne hetkeäkään, vaikka kuinka kovasti murehtisitte. ");
INSERT INTO fin_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","29","Miksi olette huolissanne vaatteista? Katsokaa niityllä kasvavia kukkia. Ne eivät huolehdi itsestään, mutta ei edes kuningas Salomo ollut loisteliaimmassa asussaan yhtä kaunis kuin ne. ");
INSERT INTO fin_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jos kerran Jumala pitää niin hyvää huolta kukista, jotka hehkuvat tänään ja ovat jo huomenna kuihtuneet, niin totta kai hän huolehtii teistä vielä paremmin, vaikka teillä on niin vähän uskoa häneen. ");
INSERT INTO fin_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Älkää siis edeltäpäin murehtiko sitä, onko teillä tarpeeksi ruokaa ja vaatteita. ");
INSERT INTO fin_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","33","Miksi eläisitte kuin pakanat, joille se kaikki on suunnattoman tärkeää? Taivaan Isä tietää kyllä, mitä tarvitsette. Hän antaa teille kaiken ilomielin, kun te annatte hänelle ensimmäisen sijan elämässänne. ");
INSERT INTO fin_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Älkää huolehtiko huomisesta. Se on Jumalan käsissä. Eläkää päivä kerrallaan.» ");
INSERT INTO fin_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","»Älkää tuomitko muita, niin teitäkään ei tuomita. ");
INSERT INTO fin_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Muut kohtelevat teitä samoin kuin te kohtelette heitä. ");
INSERT INTO fin_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Miten voit nähdä niin hyvin veljesi silmässä olevan roskan, kun sinulla on hirsi omassa silmässäsi? ");
INSERT INTO fin_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kuinka voit ehdottaa: ’Hyvä ystävä, saanhan ottaa roskan silmästäsi?’ vaikka et näe mitään, kun omassa silmässäsi on hirsi. ");
INSERT INTO fin_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Olet tekopyhä! Ota hirsi pois, niin voit auttaa ystävääsikin. ");
INSERT INTO fin_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Älkää antako helmiä sioille! Ne sotkevat helmet jalkoihinsa ja hyökkäävät kimppuunne. ");
INSERT INTO fin_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Pyytäkää, niin saatte mitä pyydätte. Etsikää, niin löydätte. Koputtakaa, niin ovi avataan. ");
INSERT INTO fin_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jokainen saa, kun vain pyytää, ja löytää, kun etsii. Jos vain koputat, ovi aukeaa. ");
INSERT INTO fin_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kun lapsi pyytää isältään leipäpalaa, antaako isä hänelle sen sijasta kiven? ");
INSERT INTO fin_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jos lapsi pyytää kalaa, antaako isä hänelle myrkkykäärmeen? ");
INSERT INTO fin_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kovasydämiset, pahat ihmisetkin antavat lapsilleen hyviä lahjoja. Tottahan Taivaan Isä antaa parasta mahdollista niille, jotka pyytävät häneltä. ");
INSERT INTO fin_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Olkaa muille sellaisia kuin toivotte heidän olevan itsellenne. Tämä on Mooseksen lain ja profeettojen opetuksen sisältö pähkinänkuoressa. ");
INSERT INTO fin_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Taivaaseen päästään vain kapeasta portista. Kadotuksen valtatie on leveä. Sen porteista on suurtenkin joukkojen helppo mennä sisään. ");
INSERT INTO fin_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Elämän tie ja sille johtava portti sen sijaan ovat niin kapeat, että vain harvat löytävät ne. ");
INSERT INTO fin_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Varokaa vääriä opettajia, jotka näyttävät lauhkeilta lampailta, mutta ovat itse asiassa vihaisia susia. ");
INSERT INTO fin_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Heidän toimintansa paljastaa kyllä heidät. Puukin tunnetaan hedelmistään. Et voi erehtyä luulemaan piikkipensaita viiniköynnökseksi tai ohdakkeita viikunapuuksi. ");
INSERT INTO fin_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Hedelmät paljastavat, millainen puu on. ");
INSERT INTO fin_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Herkullisia ja syötäväksi kelpaamattomia hedelmiä ei voi kasvaa samassa puussa. ");
INSERT INTO fin_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Huonoja hedelmiä tuottava puu kaadetaan ja poltetaan. ");
INSERT INTO fin_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Hedelmät siis ratkaisevat. ");
INSERT INTO fin_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Eivät kaikki hurskaita sanakäänteitä viljelevät ihmiset ole Jumalan lapsia. Ihmiset voivat puhua ’Herrasta’, mutta se ei merkitse, että he ovat taivaan tiellä. Ratkaisevaa on, tottelevatko he minun Isääni, joka on taivaassa. ");
INSERT INTO fin_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Monet sanovat minulle tuomiopäivänä: ’Herra, me kerroimme sinusta muille, ajoimme sinun nimesi avulla pahoja henkiä ihmisistä ja teimme muitakin suuria ihmeitä.’ ");
INSERT INTO fin_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mutta minä vastaan: ’Ette te ole koskaan olleet minun omiani. Menkää pois, sillä ette ole totelleet Jumalaa.’ ");
INSERT INTO fin_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Viisas on se, joka kuuntelee minun ohjeitani ja noudattaa niitä. Jos teette niin, olette kuin mies, joka rakentaa talonsa kallioperustalle. ");
INSERT INTO fin_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kun rankkasade yllättää ja tulva ja myrskytuuli uhkaavat kaataa talon, se ei sorru, koska sen perusta on kestävä. ");
INSERT INTO fin_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ne, jotka kuulevat neuvoni, mutta eivät välitä niistä, ovat yhtä tyhmiä kuin mies, joka rakentaa talonsa hiekalle. ");
INSERT INTO fin_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sateet tulevat, nousee tulva ja myrsky, ja silloin hänen talonsa sortuu maan tasalle.» ");
INSERT INTO fin_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jeesus lopetti puheensa. Kansanjoukot olivat ihmeissään, ");
INSERT INTO fin_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sillä Jeesus oli aivan erilainen kuin heidän omat lainopettajansa. Hän puhui niin kuin se, jolla on valta. ");
INSERT INTO fin_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Suuri ihmisjoukko seurasi Jeesusta, kun hän tuli vuoren rinnettä alas. ");
INSERT INTO fin_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Samassa muuan lepraa sairastava mies tuli hänen luokseen ja polvistui kunnioittavasti hänen eteensä. »Herra, voit parantaa minut jos tahdot», mies sanoi. ");
INSERT INTO fin_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jeesus kosketti sairasta. »Minä tahdon: parane!» Samassa sairauden merkit hävisivät. ");
INSERT INTO fin_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","»Älä kerro tästä kenellekään», Jeesus pyysi. »Mene suoraan papin luo, että hän voi todeta sinut terveeksi, uhraa sitten Mooseksen lain säätämä lahja, niin todistat julkisesti, että olet parantunut.» ");
INSERT INTO fin_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Jeesus tuli Kapernaumiin. Häntä vastassa oli eräs Rooman armeijan upseeri, joka pyysi hartaasti, että Jeesus parantaisi hänen palveluspoikansa. Tämä makasi halvaantuneena ja kärsi kovia tuskia. ");
INSERT INTO fin_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","»Minä tulen parantamaan hänet», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","»En ansaitse sitä, että tulisit kotiini», upseeri vastasi. »Eikä sinun tarvitsekaan. Sinähän voit parantaa pelkällä sanallasi. ");
INSERT INTO fin_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Olen itse ylemmän upseerin alainen ja komennan puolestani sotilaita. Jos käsken jotakuta menemään, hän menee. Kun pyydän toista tulemaan, hän tulee. Sanon orjalleni: ’Tee tämä tai tuo’, ja hän tekee. Niin sinäkin voit käskeä sairautta lähtemään pojasta, ja hän paranee.» ");
INSERT INTO fin_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jeesus seisoi siinä hämmästyneenä. Sitten hän kääntyi ja sanoi kansanjoukolle: »En ole nähnyt tällaista uskoa edes kenelläkään israelilaisella! ");
INSERT INTO fin_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Sanonpa teille, että monet pakanat kaikkialta maailmasta saavat taivaan valtakunnassa paikan Aabrahamin, Iisakin ja Jaakobin viereltä. ");
INSERT INTO fin_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sen sijaan monet valitun kansan jäsenet, joille valtakunta oli valmistettu, heitetään pimeään, itkun ja kärsimyksen paikkaan.» ");
INSERT INTO fin_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sitten Jeesus sanoi roomalaiselle upseerille: »Mene kotiin! Se, mitä uskoit, on tapahtunut.» Sillä hetkellä sairas parani. ");
INSERT INTO fin_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jeesus tuli Pietarin kotiin. Tämän anoppi oli vuoteessa kovassa kuumeessa. ");
INSERT INTO fin_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Kuume laski heti, kun Jeesus kosketti sairaan kättä. Tämä nousi terveenä valmistamaan ateriaa. ");
INSERT INTO fin_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Samana iltana Jeesuksen luo tuotiin monia ihmisiä, joita pahat henget pitivät vallassaan. Jeesuksen tarvitsi sanoa vain sana, niin henget lähtivät. ");
INSERT INTO fin_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesajan ennustus toteutui: »Hän otti kantaakseen meidän sairautemme ja kärsi meidän kipumme.» ");
INSERT INTO fin_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kun Jeesus huomasi, että ihmisjoukko paisui yhä suuremmaksi, hän pyysi oppilaitaan olemaan valmiina soutamaan järven yli. ");
INSERT INTO fin_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Eräs juutalaisten lain tuntija tuli silloin sanomaan: »Opettaja, seuraan sinua minne tahansa!» ");
INSERT INTO fin_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jeesus vastasi: »Ketuilla on luolat ja linnuilla pesät, mutta minulla, Ihmisen Pojalla, ei ole omaa kotia.» ");
INSERT INTO fin_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Eräs Jeesuksen oppilaista sanoi: »Haluaisin ensin haudata isäni ja lähteä sitten vasta mukaasi.» ");
INSERT INTO fin_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Hänelle Jeesus vastasi: »Lähde sinä vain heti minun mukaani! Anna hengellisesti kuolleiden haudata omat kuolleensa.» ");
INSERT INTO fin_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tämän jälkeen Jeesus astui veneeseen ja lähti oppilaidensa kanssa ylittämään järvenselkää. Matkalla hän nukahti. ");
INSERT INTO fin_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Äkkiä nousi raivoisa myrsky. Aallot löivät veneen laitojen yli. ");
INSERT INTO fin_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Oppilaat menivät herättämään Jeesuksen. »Herra, pelasta meidät, mehän hukumme!» he hätäilivät. ");
INSERT INTO fin_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jeesus vastasi: »Voi miten vähän teillä on uskoa! Miksi olette niin peloissanne?» Hän nousi ja moitti tuulta ja aaltoja. Ne asettuivat, ja tuli aivan tyyntä. ");
INSERT INTO fin_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Oppilaat hämmästyivät suunnattomasti. He miettivät: »Kuka Jeesus oikein on, kun tuuli ja aallotkin häntä tottelevat?» ");
INSERT INTO fin_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","He pääsivät järven toiselle puolelle gadaralaisten alueelle. Kaksi demonien vaivaamaa miestä tuli heitä vastaan. Miehet elivät hautaluolissa ja olivat niin väkivaltaisia, ettei kukaan uskaltanut mennä heidän lähelleen. ");
INSERT INTO fin_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","He alkoivat huutaa Jeesukselle: »Mitä sinä meistä oikein tahdot, Jumalan Poika? Sinulla ei ole mitään oikeutta vielä kiusata meitä.» ");
INSERT INTO fin_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Lähistöllä oli sikalauma laitumella. ");
INSERT INTO fin_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pahat henget pyysivät: »Jos ajat meidät pois, lähetä meidät tuohon sikalaumaan.» ");
INSERT INTO fin_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","»Hyvä on», Jeesus sanoi. »Menkää!» Henget siirtyivät miehistä sikoihin. Koko lauma syöksyi jyrkänteeltä järveen ja hukkui. ");
INSERT INTO fin_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Paimenessa olleet miehet juoksivat kaupunkiin pakoon ja kertoivat siellä tapahtuneesta. ");
INSERT INTO fin_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kaikki kaupungin asukkaat tulivat katsomaan Jeesusta. He pyysivät häntä lähtemään muualle ja jättämään heidät rauhaan. ");
INSERT INTO fin_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jeesus nousi veneeseen ja meni järven yli kotikaupunkiinsa Kapernaumiin. ");
INSERT INTO fin_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Pian hänen luokseen kannettiin matolla liikuntakyvytön mies. Kun Jeesus näki tulijoiden uskon, hän sanoi sairaalle: »Älä ole murheissasi. Olen antanut syntisi anteeksi.» ");
INSERT INTO fin_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","»Tuohan on jumalanpilkkaa», mutisivat jotkut juutalaisten uskonnolliset johtajat. »Mies puhuu kuin olisi Jumala.» ");
INSERT INTO fin_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jeesus tiesi, mitä he ajattelivat, ja kysyi: »Miksi teillä on niin pahat ajatukset? ");
INSERT INTO fin_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Eikö ole vaikeampaa antaa hänen syntinsä anteeksi kuin parantaa hänet? ");
INSERT INTO fin_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Mutta minä todistan teille, että minulla on valta täällä maan päällä antaa syntejä anteeksi» – ja Jeesus kääntyi sanomaan halvaantuneelle miehelle: »Nouse, kääri makuumattosi kokoon ja lähde kotiin!» ");
INSERT INTO fin_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Mies todellakin hyppäsi pystyyn ja lähti! ");
INSERT INTO fin_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kansanjoukko pelästyi nähdessään, mitä tapahtui. Se alkoi kiittää Jumalaa, joka oli antanut ihmiselle tuollaisen vallan. ");
INSERT INTO fin_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kun Jeesus jatkoi matkaansa, hän näki tulliasemalla Matteuksen, joka istui kojussaan keräämässä veroa. »Tule minun oppilaakseni», Jeesus sanoi. Matteus lähti heti hänen mukaansa. ");
INSERT INTO fin_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Myöhemmin Jeesus meni oppilaineen aterialle Matteuksen kotiin. Vieraiden joukossa oli myös monia huonomaineisia ihmisiä. ");
INSERT INTO fin_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseukset olivat närkästyneitä. He kysyivät Jeesuksen oppilailta: »Miksi teidän opettajanne seurustelee tuollaisten ihmisten kanssa?» ");
INSERT INTO fin_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jeesus vastasi itse: »Sen tähden, etteivät terveet lääkäriä tarvitse! Mutta sairaat tarvitsevat. ");
INSERT INTO fin_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Miettikääpä tämän raamatunkohdan merkitystä: ’En minä välitä teidän uhreistanne enkä lahjoistanne vaan siitä, miten kohtelette lähimmäistänne.’ Olen tullut maan päälle etsimään syntisiä ja johdattamaan heitä Jumalan luo – en murehtimaan hyvien takia.» ");
INSERT INTO fin_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Johannes Kastajan oppilaat tulivat eräänä päivänä kysymään Jeesukselta: »Miksi sinun oppilaasi eivät paastoa niin kuin fariseukset ja me?» ");
INSERT INTO fin_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jeesus kysyi: »Pitäisikö sulhasen ystävien surra ja paastota, kun sulhanen on heidän kanssaan? Minut kyllä otetaan vielä heiltä pois. Silloin on aika paastota. ");
INSERT INTO fin_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kukaan ei paikkaa vanhaa vaatetta kutistamattomalla tilkulla. Silloinhan vaate repeäisi entistä pahemmin. ");
INSERT INTO fin_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kuka panisi uutta viiniä vanhaan nahkaleiliin? Vanha nahka ei kestäisi painetta, vaan repeäisi ja viini valuisi maahan. Uusi viini pannaan tuoreisiin nahkaleileihin. Silloin molemmat säilyvät.» ");
INSERT INTO fin_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jeesuksen puhuessa tuli paikalle synagogan johtaja. Hän kumarsi Jeesuksen edessä kunnioittavasti ja sanoi: »Pieni tyttäreni kuoli juuri. Mutta sinä voit herättää hänet uudestaan eloon, jos vain kosketat häntä.» ");
INSERT INTO fin_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jeesus lähti oppilaineen kohti miehen kotia. ");
INSERT INTO fin_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Matkalla eräs nainen koski takaapäin Jeesuksen viitan tupsua. Nainen oli sairastanut kaksitoista vuotta verenvuototautia ja uskoi, että jos hän koskettaisi edes Jeesuksen viittaa, hän paranisi. ");
INSERT INTO fin_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jeesus kääntyi. »Ystäväni, kaikki on hyvin», hän sanoi naiselle. »Uskosi on parantanut sinut.» Nainen oli siitä lähtien terve. ");
INSERT INTO fin_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jeesus tuli nyt synagogan johtajan kotiin. Siellä soitettiin hautajaismusiikkia, ja talo oli täynnä häliseviä ihmisiä. ");
INSERT INTO fin_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jeesus sanoi: »Menkää pois! Tyttö ei ole kuollut, hän vain nukkuu.» Hänelle naurettiin pilkallisesti. ");
INSERT INTO fin_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kun ihmiset lopulta oli saatu ulos, Jeesus meni pikkutytön vuoteen viereen ja tarttui hänen käteensä. Tyttö nousi silloin terveenä seisomaan. ");
INSERT INTO fin_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tästä ihmeellisestä tapahtumasta levisi tieto koko alueelle. ");
INSERT INTO fin_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kun Jeesus lähti tytön kotoa, kaksi sokeaa miestä kulki hänen perässään. »Daavidin Poika, auta meitä!» he huusivat. ");
INSERT INTO fin_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jeesus poikkesi erääseen taloon. Sokeat tulivat perässä, ja Jeesus kysyi heiltä: »uskotteko, että voin parantaa teidän sokeutenne?» »Kyllä uskomme», he vastasivat. ");
INSERT INTO fin_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Silloin Jeesus kosketti heidän silmiään ja sanoi: »Tapahtukoon sitten niin kuin uskotte.» ");
INSERT INTO fin_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Yhtäkkiä he näkivät. Jeesus pyysi vakavasti, että he eivät puhuisi asiasta kenellekään. ");
INSERT INTO fin_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Siitä huolimatta he kertoivat Jeesuksesta kaikkialla. ");
INSERT INTO fin_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Seuraavaksi Jeesus tapasi miehen, jonka paha henki oli tehnyt puhekyvyttömäksi. ");
INSERT INTO fin_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kun Jeesus ajoi hengen pois, mies alkoi heti puhua. Kansanjoukko kummasteli. Ihmiset sanoivat, etteivät olleet eläessään nähneet mitään vastaavaa. ");
INSERT INTO fin_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Fariseukset väittivät: »Hänen täytyy itse olla pahojen henkien vallassa, kun hän voi ajaa henkiä pois. Hän saa varmasti voimansa paholaiselta!» ");
INSERT INTO fin_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jeesus kulki alueen kaikkien kaupunkien ja kylien läpi, opetti juutalaisten synagogissa ja julisti hyvää uutista Jumalan valtakunnasta. Joka paikassa hän paransi kaikenlaisia sairaita. ");
INSERT INTO fin_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Hänen kävi sääli ihmisiä, kun hän näki heidän tulevan hänen luokseen. Heillä oli monia vaikeuksia eivätkä he tienneet, mistä saisivat apua. He olivat kuin lampaat ilman paimenta. ");
INSERT INTO fin_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","»Satoa on paljon, mutta työväkeä vähän», Jeesus sanoi oppilailleen. ");
INSERT INTO fin_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","»Rukoilkaa häntä, joka on vastuussa sadonkorjuusta. Pyytäkää häntä lähettämään pelloille lisää työntekijöitä.» ");
INSERT INTO fin_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jeesus kutsui kaksitoista oppilastaan luokseen ja antoi heille voiman ajaa pois pahoja henkiä ja parantaa kaikkia sairauksia. ");
INSERT INTO fin_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Oppilaat olivat Simon, jota sanottiin myös Pietariksi, hänen veljensä Andreas, Sebedeuksen pojat Jaakob ja Johannes, ");
INSERT INTO fin_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filippus, Bartolomeus, Tuomas, veronkantaja Matteus, Alfeuksen poika Jaakob, Taddeus, vapautusliikkeen mies, ");
INSERT INTO fin_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon sekä Juudas Iskariot, joka petti Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jeesus valmisti oppilaitaan matkalle: »Älkää menkö pakanoiden tai samarialaisten luo, ");
INSERT INTO fin_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","vaan israelilaisten luo. He ovat Jumalan kadonneita lampaita. ");
INSERT INTO fin_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ilmoittakaa heille, että Jumalan valtakunta on nyt hyvin lähellä. ");
INSERT INTO fin_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Parantakaa sairaita, herättäkää kuolleita, puhdistakaa lepratautisia ja ajakaa ihmisistä pahoja henkiä. Antakaa ilmaiseksi niin kuin olette itsekin saaneet! ");
INSERT INTO fin_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Älkää ottako mukaanne rahaa, eväslaukkua, ylimääräisiä vaatteita, kenkiä tai edes matkasauvaa. Ne ihmiset, joita autatte, pitävät teistä huolta. ");
INSERT INTO fin_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Kun tulette johonkin kaupunkiin tai kylään, etsiytykää kotiin, joka ottaa teidät vastaan, ja asukaa siellä siihen asti, kunnes on aika jatkaa matkaa. ");
INSERT INTO fin_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tullessanne taloon toivottakaa siunausta ja osoittakaa ystävällisyyttä talonväelle. ");
INSERT INTO fin_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jos teidät otetaan siellä vastaan, teidän siunauksenne tulee kodille – ellei, niin siunauksenne palaa teille. ");
INSERT INTO fin_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jos teitä ei oteta vastaan jossakin kaupungissa tai kodissa, pudistakaa paikan tomut jaloistanne ja lähtekää eteenpäin. ");
INSERT INTO fin_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tuomiopäivänä on Sodomalla ja Gomorrallakin helpompaa kuin sillä. ");
INSERT INTO fin_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Lähetän teidät kuin lampaat susien keskelle. Olkaa harkitsevia kuin käärme ja viattomia kuin kyyhkynen. ");
INSERT INTO fin_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Pitäkää varanne, sillä teitä vangitaan, viedään oikeuteen ja ruoskitaan synagogissa. ");
INSERT INTO fin_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Minun takiani joudutte maaherrojen ja hallitsijoiden kuulusteltaviksi. Silloin saatte tilaisuuden kertoa minusta heille – ja samalla todistatte koko maailmalle. ");
INSERT INTO fin_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kun teidät pidätetään, älkää olko huolissanne siitä, mitä sanoisitte oikeudessa. Teille annetaan oikeat sanat oikeana hetkenä. ");
INSERT INTO fin_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Teidän ei tarvitse itse osata puhua, vaan Jumalan Henki puhuu teidän välityksellänne. ");
INSERT INTO fin_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Veli ilmiantaa veljensä ja isät lähettävät lapsensa kuolemaan. Lapset nousevat vanhempiaan vastaan ja vievät heidät kuolemaan. ");
INSERT INTO fin_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Kaikki vihaavat teitä siksi, että olette minun omiani. Mutta jokainen, joka kestää loppuun asti, pelastuu. ");
INSERT INTO fin_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Kun teitä vainotaan jossakin kaupungissa, paetkaa toiseen. Tulen takaisin, ennen kuin olette ehtineet viedä ilosanoman kaikkiin Israelin kaupunkeihin! ");
INSERT INTO fin_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Oppilas ei ole suurempi opettajaansa eikä palvelija isäntäänsä. ");
INSERT INTO fin_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Oppilas saa saman kohtalon kuin opettajansa. Palvelijan käy samalla tavoin kuin isäntänsä. Jos minua on sanottu paholaiseksi, varmasti teitäkin sanotaan. ");
INSERT INTO fin_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Älkää pelätkö ihmisten uhkailuja. Totuus paljastuu aikanaan, ja vastustajienne salajuonet tulevat ilmi. ");
INSERT INTO fin_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kertokaa ihmisille päivän tultua se, minkä sanon teille nyt, kun vielä on hämärä. Julistakaa katoilta, mitä kuiskaan korvaanne. ");
INSERT INTO fin_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Älkää pelätkö ihmisiä, jotka voivat tappaa ruumiinne, mutta eivät voi viedä teiltä ikuista elämää. Pelätkää sen sijaan Jumalaa, joka voi sulkea kadotukseen sekä sielun että ruumiin. ");
INSERT INTO fin_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mikä on varpusen hinta? Puoli penniä? Yksikään lintu ei putoa maahan Isänne tietämättä. ");
INSERT INTO fin_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hän jopa tietää hiustenne luvun. ");
INSERT INTO fin_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Älkää siis huolehtiko mistään, sillä olettehan te toki hänelle varpusia arvokkaammat. ");
INSERT INTO fin_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jos joku tunnustaa julkisesti minut ystäväkseen, minäkin tunnustan hänet ystäväkseni Isäni edessä. ");
INSERT INTO fin_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jos taas joku julkisesti kieltää minut, minäkin kiellän tuntevani häntä Isäni edessä, joka on taivaassa. ");
INSERT INTO fin_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Älkää kuvitelko, että minä olen tullut tuomaan maailmaan rauhaa – paremminkin päinvastoin! ");
INSERT INTO fin_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Minun takiani poika riitaantuu isänsä kanssa, tytär äitinsä ja miniä anoppinsa kanssa. ");
INSERT INTO fin_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Monen ihmisen pahimmiksi vihamiehiksi tulevat hänen omaisensa. ");
INSERT INTO fin_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jos rakastat isääsi ja äitiäsi enemmän kuin minua, et sovi minulle. Jos rakastat poikaasi tai tytärtäsi enemmän kuin minua, et myöskään sovi minulle. ");
INSERT INTO fin_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ellet suostu kantamaan ristiäsi ja seuraamaan minua, et ole sopiva oppilaakseni. ");
INSERT INTO fin_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jos yrität pitää kiinni omasta elämästäsi, menetät sen, mutta jos luovut siitä minun takiani, pelastat sen. ");
INSERT INTO fin_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Joka ottaa vastaan teidät, ottaa samalla vastaan minut. Joka taas ottaa vastaan minut, ottaa vastaan Jumalan, joka minut lähetti. ");
INSERT INTO fin_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jos otatte luoksenne profeetan siksi, että hän on Jumalan palvelija, saatte saman palkan kuin profeetta. Jos otatte luoksenne Jumalan ihmisen siksi, että hän elää Jumalan tahdon mukaan, teille annetaan sama palkka kuin hänelle. ");
INSERT INTO fin_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Jos annatte vaikkapa vain lasillisen kylmää vettä jollekin vähäiselle seuraajalleni, saatte siitä varmasti palkan.» ");
INSERT INTO fin_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kun Jeesus oli antanut kahdelletoista oppilaalleen nämä ohjeet, hän lähti puhumaan ympäristön kaupunkeihin. ");
INSERT INTO fin_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Johannes Kastaja oli pantu vankilaan. Hän sai siellä kuulla ihmeistä, joita Kristus teki, ja lähetti oppilaansa kysymään: ");
INSERT INTO fin_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","»Oletko sinä todella se, jota olemme odottaneet, vai onko meidän yhä odotettava?» ");
INSERT INTO fin_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jeesus käski kysyjien kertoa Johannekselle ihmeistä, joita he näkivät hänen tekevän: ");
INSERT INTO fin_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","»Sokeat saavat näkönsä, liikuntakyvyttömät kävelevät, lepratautiset paranevat, kuurot kuulevat, kuolleet heräävät eloon ja köyhille julistetaan iloista uutista.» ");
INSERT INTO fin_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sitten Jeesus jatkoi: »Sanokaa Johannekselle: ’Onnellinen se, joka ei epäile minua.’» ");
INSERT INTO fin_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Johanneksen oppilaat lähtivät. Jeesus rupesi puhumaan ihmisille Johanneksesta: »Kun menitte autiomaahan katsomaan Johannesta, millaiseksi häntä luulitte? Tuulessa häilyvän ruohon kaltaiseksi? ");
INSERT INTO fin_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Vai odotitteko näkevänne upeasti pukeutuneen hallitsijan? ");
INSERT INTO fin_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Lähdittekö katsomaan Jumalan profeettaa? Hän on enemmänkin kuin profeetta. ");
INSERT INTO fin_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Raamatussa on kirjoitettu juuri Johanneksesta, että hän on sanansaattaja, joka kertoo minun tulostani ja valmistaa ihmisiä ottamaan minut vastaan. ");
INSERT INTO fin_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Johannes Kastaja on todella suurin kaikista ihmisistä. Mutta taivaan valtakunnassa on kaikkein pieninkin häntä suurempi! ");
INSERT INTO fin_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Siitä asti, kun Johannes alkoi saarnata ja kastaa, on taivaan valtakuntaa vastaan kiihkeästi hyökätty. Johanneksen vastustajat tahtovat väkisin valloittaa sen itselleen. ");
INSERT INTO fin_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kaikki Mooseksen lait ja profeettojen kirjoitukset ovat tähdänneet Messiaaseen. ");
INSERT INTO fin_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Jos tahdotte tietää, niin Johannes on Elia, jonka profeetat sanoivat tulevan. ");
INSERT INTO fin_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nyt jos koskaan – pitäkää korvanne auki! ");
INSERT INTO fin_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Millainen teidän sukupolvenne oikein on? Ihmiset ovat kuin lapsia, jotka sanovat leikkitovereilleen: ");
INSERT INTO fin_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","’Me leikimme häitä, mutta te ette tulleet iloisiksi. Lauloimme hautajaisvirsiä, mutta te ette tulleet murheellisiksi.’ ");
INSERT INTO fin_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Johannes Kastaja ei koske viiniin ja paastoaa usein. Häntä te pidätte hulluna. ");
INSERT INTO fin_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Minä, Ihmisen Poika, syön ja juon, ja te syytätte minua: ’Mikä mässäilijä ja juoppo! Hän viihtyy vain kaikenlaisten huonojen ihmisten seurassa.’ Todellinen viisaus näkyy teoista.» ");
INSERT INTO fin_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kaupungit, joissa Jeesus oli tehnyt eniten ihmeitä, eivät olleet Jumalasta kiinnostuneita. Jeesus lausui niille vakavat sanat: ");
INSERT INTO fin_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","»Voi teitä, Korasin ja Beetsaida! Jos pahamaineisissa Tyyrossa ja Siidonissa olisivat tapahtuneet samat ihmeet kuin teidän kaduillanne, niiden asukkaat olisivat jo aikoja sitten katuneet nöyrinä ja häpeissään. ");
INSERT INTO fin_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Uskotteko: Tyyron ja Siidonin käy tuomiopäivänä paremmin kuin teidän! ");
INSERT INTO fin_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mutta Kapernaumin, joka sai suuren kunnian, on mentävä helvetin syvyyksiin. ");
INSERT INTO fin_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jos olisin tehnyt Sodomassa kaiken sen, mitä tein teidän kaduillanne, se olisi yhä pystyssä. Sodoman käy toden totta tuomiopäivänä paremmin kuin teidän.» ");
INSERT INTO fin_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jeesus rukoili: »Isä, taivaan ja maan Herra! Kiitos, että olet salannut totuuden niiltä, jotka pitävät itseään viisaina, ja paljastanut sen lapsenmielisille. ");
INSERT INTO fin_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Olet katsonut sen parhaaksi.» ");
INSERT INTO fin_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jeesus jatkoi: »Isä on uskonut minulle kaiken. Vain hän tuntee Pojan. Isän taas tuntee vain Poika ja jokainen, jolle Poika osoittaa hänet. ");
INSERT INTO fin_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tulkaa minun luokseni kaikki te, jotka teette kovaa työtä ja olette raskaiden kuormienne uuvuttamat. ");
INSERT INTO fin_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Ottakaa päällenne minun ikeeni – se on teille juuri sopiva – ja antakaa minun opettaa teitä, sillä olen lempeä ja nöyrä. Niin te löydätte levon sielullenne, koska minä annan kannettavaksenne vain kevyitä kuormia.» ");
INSERT INTO fin_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Eräänä päivänä Jeesus käveli oppilaidensa kanssa viljapeltojen halki. Oli sapatti, juutalaisten pyhäpäivä. Oppilaat alkoivat nälissään katkoa tähkiä ja syödä jyviä. ");
INSERT INTO fin_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Muutamat fariseukset huomasivat sen ja sanoivat Jeesukselle: »Oppilaasi rikkovat lakia. He korjaavat sapattina viljaa.» ");
INSERT INTO fin_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jeesus vastasi: »Ettekö ole lukeneet, mitä kuningas Daavid ja hänen seurueensa tekivät, kun heidän oli nälkä? ");
INSERT INTO fin_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hehän söivät temppelistä pyhät näkyleivät, joita vain papit olisivat saaneet nauttia. Se oli selvää lain rikkomista. ");
INSERT INTO fin_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ettekö ole lukeneet Mooseksen laista, että pappien on työvuorollaan palveltava sapattinakin temppelissä? ");
INSERT INTO fin_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Minä sanon teille nyt: minä olen suurempi kuin temppeli! ");
INSERT INTO fin_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ette tuomitsisi syyttömiä, jos ymmärtäisitte tämän raamatunkohdan merkityksen: ’En minä teidän uhreistanne välitä, vaan siitä, miten kohtelette lähimmäistänne.’ ");
INSERT INTO fin_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Minä, Ihmisen Poika, olen sapatinkin Herra.» ");
INSERT INTO fin_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jeesus meni tämän jälkeen synagogaan ");
INSERT INTO fin_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ja huomasi siellä miehen, jonka käsi oli surkastunut. Fariseukset tulivat kysymään Jeesukselta: »Onko laillista parantaa hänet sapattina?» He toivoivat tietysti, että Jeesus vastaisi myöntävästi ja antaisi heille aiheen nostaa syytteen. ");
INSERT INTO fin_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mutta hän vastasikin: »Jos teillä olisi vain yksi lammas ja se putoaisi sapattina kaivoon, ettekö pelastaisi sitä heti? Varmasti! ");
INSERT INTO fin_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Onhan ihminen sentään lammasta arvokkaampi! Sapattina on oikeus tehdä hyvää.» ");
INSERT INTO fin_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Sitten Jeesus sanoi miehelle: »Ojenna kätesi!» Tämä totteli, ja hänen surkastunut kätensä muuttui täysin terveeksi kädeksi. ");
INSERT INTO fin_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseukset kokoontuivat neuvottelemaan, miten saisivat Jeesuksen pidätetyksi ja surmatuksi. ");
INSERT INTO fin_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jeesus tiesi heidän suunnitelmansa ja lähti jatkamaan matkaansa. Monet seurasivat häntä, ja hän paransi kaikki sairaat. ");
INSERT INTO fin_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Hän kielsi heitä levittämästä tietoa ihmeistä. ");
INSERT INTO fin_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesaja olikin ennustanut hänestä: ");
INSERT INTO fin_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","»Katsokaa palvelijaani, jonka olen valinnut. Hän on minun rakkaani, joka on minulle suuri ilo. Annan Henkeni laskeutua hänen päälleen, ja hän tuomitsee kansat. ");
INSERT INTO fin_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Hän ei riitele eikä korota ääntään. ");
INSERT INTO fin_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Hän ei muserra heikkoa eikä tukahduta lepattavaa toivon liekkiä. Kaikki ristiriidat loppuvat, kun hän voittaa. ");
INSERT INTO fin_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Hänen nimensä on koko maailman toivo.» ");
INSERT INTO fin_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sitten Jeesuksen luo tuotiin pahojen henkien vaivaama mies, joka oli sokea ja puhekyvytön. Jeesus paransi hänet täysin terveeksi. ");
INSERT INTO fin_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ihmiset olivat hämmästyneitä. He miettivät: »Ehkä Jeesus onkin Messias, kansamme tuleva johtaja!» ");
INSERT INTO fin_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kun fariseukset kuulivat ihmeestä, he sanoivat: »Hän pystyy ajamaan henkiä ulos siksi, että hän on itse pääpaholainen.» ");
INSERT INTO fin_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jeesus tiesi, mitä he ajattelivat, ja sanoi: »Sisällissota tuhoaa maan. Kaupunki tai koti ei pysy koossa, jos se on riitojen repimä. ");
INSERT INTO fin_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jos paholainen ajaa paholaisen tiehensä, hänhän kaivaa maata omien jalkojensa alta ja hävittää omaa valtakuntaansa. ");
INSERT INTO fin_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nyt te väitätte, että minä ajan saatanan voimalla ulos pahoja henkiä. Kenen voimalla teikäläiset niitä sitten ajavat? Syyte kääntyy itseänne vastaan. ");
INSERT INTO fin_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Jos ajan pahoja henkiä ulos Jumalan Hengen voimalla, se merkitsee, että Jumalan valtakunta on keskellänne. ");
INSERT INTO fin_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Saatanan valtakuntaahan ei voi valloittaa, ellei ensin vangitse itse saatanaa. Vasta sitten hänen pahat henkensä voidaan ajaa pois. ");
INSERT INTO fin_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Joka ei minua auta, vahingoittaa työtäni. ");
INSERT INTO fin_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Jos ihminen pilkkaa minua tai tekee mitä tahansa muuta syntiä, sen hän voi saada anteeksi. Mutta on yksi asia, jota ei voi koskaan saada anteeksi, ei tässä maailmassa eikä tulevassa, ja se on Pyhää Henkeä vastaan puhuminen. ");
INSERT INTO fin_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Puu tunnetaan hedelmistään. Jalostetusta puusta saadaan hyviä hedelmiä, muista ei. ");
INSERT INTO fin_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Te käärmeet! Miten teidänlaisenne pahat ihmiset voisivat tietää, mikä on hyvää ja oikein? Ihmisen ajatukset paljastuvat hänen puheistaan. ");
INSERT INTO fin_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Hyvän ihmisen puheesta tulee esiin hänen sydämensä hyvyys. Samoin paljastuu pahan ihmisen ilkeys, kun hän avaa suunsa. ");
INSERT INTO fin_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Teidän on tehtävä tuomiopäivänä tiliä jokaisesta turhasta sanastanne. ");
INSERT INTO fin_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Se, mitä nyt puhut, sinetöi kohtalosi. Sanasi saavat Jumalan hyväksymään tai tuomitsemaan sinut.» ");
INSERT INTO fin_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Joukko juutalaisten johtomiehiä, mukana myös muutama fariseus, tuli eräänä päivänä pyytämään Jeesusta tekemään ihmeen, joka todistaisi, että hän oli Messias. ");
INSERT INTO fin_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jeesus vastasi: »Vain tämä paha, uskoton kansa voi vaatia vielä lisää todisteita. Profeetta Joonan merkki riittää. ");
INSERT INTO fin_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Joona oli kolme päivää ja yötä merieläimen vatsassa. Ihmisen Poika on maan alla samoin kolme päivää ja yötä. ");
INSERT INTO fin_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Viimeisellä tuomiolla niiniveläiset syyttävät teitä: kun Joona saarnasi heille, he katuivat pahuuttaan ja kääntyivät Jumalan puoleen. Te ette usko, vaikka keskellänne on hän, joka on Joonaa suurempi. ");
INSERT INTO fin_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Saaban kuningattaren teko tulee lopulta teidän tuomioksenne. Hänhän tuli kaukaa kuuntelemaan Salomon viisautta. Te taas ette usko, vaikka keskellänne on hän, joka on Salomoa paljon merkittävämpi. ");
INSERT INTO fin_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44-45","Tämä kansa on kuin pahan hengen hallitsema ihminen. Kun henki poistuu hänestä, se etsii jonkin aikaa rauhaa autiomaassa, mutta turhaan. Sitten se sanoo: ’Minä palaan siihen ihmiseen, josta lähdin.’ Tultuaan takaisin se huomaa, että ihmisen sydän on puhdas, mutta tyhjä. Se etsii seitsemän muuta henkeä, jotka ovat pahempia kuin se itse. Kaikki asettuvat tuohon ihmiseen, ja hänestä tulee pahempi kuin koskaan ennen.» ");
INSERT INTO fin_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","47","Jeesus puhui talontäydelle joukolle. Hänen äitinsä ja veljensä odottivat pihalla, että saisivat puhua hänen kanssaan. Joku kertoi heistä Jeesukselle. ");
INSERT INTO fin_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tämä kysyi: »Kuka on minun äitini ja ketkä ovat minun veljiäni?» ");
INSERT INTO fin_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Hän osoitti oppilaitaan: »Tässä ovat äitini ja veljeni.» ");
INSERT INTO fin_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sitten hän lisäsi: »Jokainen, joka tottelee Taivaallista Isääni, on minun veljeni, sisareni ja äitini.» ");
INSERT INTO fin_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Myöhemmin samana päivänä Jeesus lähti rannalle, ");
INSERT INTO fin_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ja valtava ihmisjoukko kokoontui pian hänen ympärilleen. Silloin hän meni veneeseen istumaan ja puhui sieltä rannalla kuunteleville ihmisille. ");
INSERT INTO fin_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Hän käytti monia vertauksia. »Maanviljelijä oli kylvämässä», Jeesus kertoi. ");
INSERT INTO fin_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","»Jotkut siemenet putosivat polulle, ja linnut söivät ne. ");
INSERT INTO fin_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Toiset putosivat kalliolle ja nousivat matalassa mullassa nopeasti oraalle. ");
INSERT INTO fin_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kuuma auringonpaiste kärvensi oraat kuitenkin pian, koska niillä ei ollut kunnon juurta. ");
INSERT INTO fin_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Osa siemenistä putosi ohdakkeiden sekaan. Hennot alut tukehtuivat niiden keskellä. ");
INSERT INTO fin_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Mutta loput siemenet putosivat hyvään maahan ja tuottivat satoa kolmekymmentä, kuusikymmentä tai jopa sata kertaa siementen määrän. ");
INSERT INTO fin_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jos teillä on korvat, niin kuunnelkaa!» ");
INSERT INTO fin_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Hänen oppilaansa tulivat kysymään: »Miksi käytät aina vertauksia?» ");
INSERT INTO fin_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jeesus selitti, että taivaan valtakunnan salaisuuden sai paljastaa vain heille. ");
INSERT INTO fin_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","»Sille, jolla on, annetaan lisää», Jeesus sanoi. »Hänellä on sitten yllin kyllin. Mutta siltä, jolla ei ole, otetaan pois sekin vähä, mikä hänellä on. ");
INSERT INTO fin_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Käytän vertauksia siksi, että ihmiset eivät ymmärtäisi, vaikka kuulevat ja näkevät. ");
INSERT INTO fin_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Näin toteutuu Jesajan ennustus: ’He kuuntelevat, mutta eivät ymmärrä, ja katselevat, mutta eivät näe. ");
INSERT INTO fin_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Heidän sydämensä on paatunut, ja he ovat kovakorvaisia ja sokeita. He eivät haluakaan nähdä eivätkä kuulla, etteivät ymmärtäisi, mistä on kysymys, eivät kääntyisi Jumalan puoleen eivätkä tulisi minun parannettavikseni.’ ");
INSERT INTO fin_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Mutta siunatut ovat teidän silmänne, sillä ne näkevät, ja korvanne, sillä ne kuulevat. ");
INSERT INTO fin_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Monet profeetat ja pyhät ihmiset ovat odottaneet näkevänsä ja kuulevansa, mitä te olette saaneet nähdä ja kuulla, mutta heidän toiveensa ei ole toteutunut. ");
INSERT INTO fin_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Mitä minä siis tarkoitin, kun kerroin kylväjästä? ");
INSERT INTO fin_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Polku, jolle jotkut siemenet putosivat, kuvaa sellaisen ihmisen sydäntä, joka ei ymmärrä ilosanomaa valtakunnasta, vaikka kuulee sen. Paholainen poimii hänen sydämestään kaikki siemenet. ");
INSERT INTO fin_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kallioinen maaperä muistuttaa ihmistä, joka kuuntelee sanomaa ja hyväksyy sen ilomielin. ");
INSERT INTO fin_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Juuret eivät kuitenkaan pääse kasvamaan syvälle hänen elämäänsä, ja kun hän joutuu kärsimään uskonsa tähden, hänen intonsa sammuu. ");
INSERT INTO fin_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ohdakkeinen maa on kuin ihminen, joka kuulee sanoman, mutta on tiukasti kiinni tässä maailmassa ja haluaa vain rikastua. Hänen uskonsa ei näy hänen elämästään. ");
INSERT INTO fin_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Hyvä maaperä kuvaa sellaista ihmistä, joka kuulee sanoman, ymmärtää sen ja lähtee liikkeelle. Hän opastaa valtakuntaan kolmekymmentä, kuusikymmentä tai jopa sata muuta ihmistä.» ");
INSERT INTO fin_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jeesus käytti myös muita vertauksia. Hän kertoi: »Taivaan valtakuntaa voidaan verrata maanviljelijään, joka kylvää peltoonsa hyvää siementä. ");
INSERT INTO fin_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Eräänä yönä, kun hän nukkuu kaikessa rauhassa, käy hänen vihamiehensä kylvämässä vehnän sekaan viljaa muistuttavaa rikkakasvia, lustetta. ");
INSERT INTO fin_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Siemenet itävät ja luste kasvaa siinä missä vehnäkin. ");
INSERT INTO fin_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Maanviljelijän apulaiset tulevat kertomaan hänelle: ’Kylvit peltoosi valikoitua siementä, mutta nyt se on täynnä lustetta!’ ");
INSERT INTO fin_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","’Se on vihamieheni työtä’, isäntä toteaa. ’Kitkemmekö sen rikkaruohon pois?’ apulaiset kysyvät. ");
INSERT INTO fin_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","’Jos ryhdytte kitkemään, vehnäkin kärsii’, isäntä vastaa. ");
INSERT INTO fin_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","’Annetaan niiden kasvaa yhdessä sadonkorjuuseen asti. Sitten minä käsken niittäjiä keräämään lusteen ja polttamaan sen. Vain vehnä korjataan aittaan.’» ");
INSERT INTO fin_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jeesus käytti myös tällaista vertauskuvaa: »Taivaan valtakunta on kuin pieni peltoon kylvetty sinapinsiemen. ");
INSERT INTO fin_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Se on pienin kaikista siemenistä, mutta siitä kasvaa kaikkein suurin vihanneskasvi. Linnutkin pesivät sen oksille, kun se kasvaa puuksi.» ");
INSERT INTO fin_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jeesus kertoi edelleen: »Taivaan valtakunta on kuin taikinan juuri. Kun leipuri sekoittaa sen jauhoihin, koko taikina happanee.» ");
INSERT INTO fin_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kun Jeesus puhui kansanjoukoille, hän käytti aina puhuessaan vähintään yhtä vertauskuvaa. ");
INSERT INTO fin_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Profeettahan oli ennustanut: »Minä puhun vertauksia. Tuon esille asioita, jotka ovat olleet salaisuuksia aikojen alusta asti.» ");
INSERT INTO fin_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jeesus lähti sisälle, ja ihmiset jäivät ulos. Oppilaat pyysivät Jeesusta selittämään, mitä kertomus vehnäpeltoon kylvetystä lusteesta tarkoitti. ");
INSERT INTO fin_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jeesus selitti: »Minä olen maanviljelijä, joka kylvän hyvää siementä. ");
INSERT INTO fin_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Pelto on tämä maailma ja siemenet ovat Jumalan lapsia. Rikkaruohot taas ovat paholaisen lapsia. ");
INSERT INTO fin_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Saatana on vihamies, joka kylvää lustetta vehnän sekaan. Elonkorjuu merkitsee tämän aikakauden loppua, ja niittäjät ovat enkeleitä. ");
INSERT INTO fin_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Tämän aikakauden lopussa rikkaruohot kootaan ja poltetaan kuten kertomuksessa. ");
INSERT INTO fin_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Minä, Ihmisen Poika, lähetän enkelini kokoamaan valtakunnastani kaikki, jotka pahuudessaan viettelevät muita synteihin. ");
INSERT INTO fin_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Heidät heitetään tuleen, jossa he joutuvat itkemään ja valittamaan. ");
INSERT INTO fin_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mutta Jumalan lapset loistavat Isänsä valtakunnassa kuin aurinko. Muistakaa tämä! ");
INSERT INTO fin_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Taivaan valtakunta on kuin aarre, jonka mies löysi pellosta. Innoissaan hän myi koko omaisuutensa ja osti rahoilla pellon ja sen mukana aarteen. ");
INSERT INTO fin_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Taivaan valtakunta on myös kuin arvokas helmi, jonka kauppias löysi pitkään etsittyään. ");
INSERT INTO fin_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Hän myi koko omaisuutensa ja osti tuon erityisen kauniin helmen. ");
INSERT INTO fin_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Taivaan valtakunta on myös kuin nuotta, jonka kalastaja heittää mereen. Nuottaan jää kaikenlaisia kaloja, sekä syötäviä että pois heitettäviä. ");
INSERT INTO fin_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kun se on täynnä, kalastajat vetävät sen rantaan ja istuutuvat lajittelemaan saalista. Hyvät kalat kootaan astiaan, huonot heitetään pois. ");
INSERT INTO fin_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Näin käy tämän aikakauden lopussa: enkelit erottelevat Jumalan omat muista. Ne, jotka eivät ole Jumalan omia, heitetään tuleen – itkun ja valituksen paikkaan. ");
INSERT INTO fin_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ymmärrättekö tämän?» Oppilaat sanoivat ymmärtävänsä. ");
INSERT INTO fin_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jeesus jatkoi: »Kun juutalaisten lain tuntijoista tulee minun oppilaitani, he voivat jakaa aarreaitastaan sekä uutta että vanhaa.» ");
INSERT INTO fin_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Kun Jeesus oli esittänyt nämä vertaukset, hän palasi kotikaupunkiinsa Galilean Nasaretiin ja opetti sen synagogassa. Kaikki ihmettelivät hänen viisauttaan ja ihme tekojaan. ");
INSERT INTO fin_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ihmiset ajattelivat: »Miten tämä on mahdollista? Hänhän on vain rakennusmiehen poika. Me tunnemme hänen äitinsä Marian ja veljensä Jaakobin, Joosefin, Simonin ja Juudaksen. ");
INSERT INTO fin_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Hänen sisarensakin asuvat kaikki täällä. Miten hän voi olla noin ihmeellinen?» ");
INSERT INTO fin_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ja nasaretilaiset suuttuivat häneen. Jeesus totesi: »Profeettaa kuunnellaan kaikkialla muualla paitsi hänen kotipaikkakunnallaan ja kotonaan.» ");
INSERT INTO fin_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Koska he eivät uskoneet häneen, hän ei voinut tehdä Nasaretissa montakaan ihmettä. ");
INSERT INTO fin_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Kun kuningas Herodes kuuli Jeesuksesta, ");
INSERT INTO fin_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","hän sanoi miehilleen: »Hänen täytyy olla Johannes Kastaja, joka on herännyt kuolleista. Siksi hän pystyy tekemään ihmeitäkin.» ");
INSERT INTO fin_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herodes oli näet sulkenut Johanneksen vankilaan, kun tämä oli sanonut, ettei Herodeksella ollut oikeutta pitää vaimonaan Herodiasta, veljensä Filippuksen vaimoa. ");
INSERT INTO fin_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes olisi halunnut surmata Johanneksen, mutta kansa piti Johannesta profeettana, ja Herodes pelkäsi mielenosoituksia. ");
INSERT INTO fin_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sitten Herodes vietti syntymäpäiviä. Herodiaan tytär esitti tanssia, ja kuningas oli niin ihastunut, ");
INSERT INTO fin_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","että vannoi antavansa tytölle mitä ikinä tämä halusi. ");
INSERT INTO fin_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Äitinsä yllytyksestä tyttö pyysi Johannes Kastajan päätä tarjottimella. ");
INSERT INTO fin_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kuningas oli onneton, mutta ei halunnut pettää sanaansa vieraiden nähden. ");
INSERT INTO fin_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Niinpä hän käski mestata Johanneksen. ");
INSERT INTO fin_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Pää tuotiin tarjottimella tytölle, ja tämä vei sen äidilleen. ");
INSERT INTO fin_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Johanneksen oppilaat hakivat hänen ruumiinsa ja hautasivat sen. Sitten he tulivat kertomaan Jeesukselle, mitä oli tapahtunut. ");
INSERT INTO fin_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Kun Jeesus kuuli suruviestin, hän lähti veneellä syrjäiseen paikkaan saadakseen olla yksin. Mutta ihmiset olivat huomanneet, minne hän meni, ja heitä tuli eri kaupungeista jalkaisin hänen peräänsä. ");
INSERT INTO fin_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kun Jeesus nousi maihin, suuri ihmisjoukko oli jo odottamassa häntä. Hänen kävi sääli ihmisiä ja hän paransi kaikki sairaat. ");
INSERT INTO fin_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Illalla oppilaat tulivat sanomaan hänelle: »On jo myöhä eikä näin syrjäiseltä seudulta saa mitään ruokaa. Lähetä ihmiset ostamaan kylistä syötävää.» ");
INSERT INTO fin_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jeesus vastasi: »Ei heidän tarvitse lähteä. Antakaa te heille ruokaa!» ");
INSERT INTO fin_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","»Mitä?» huudahtivat oppilaat. »Eihän meillä ole kuin viisi vaivaista leipää ja kaksi kalaa.» ");
INSERT INTO fin_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","»Tuokaa ne tänne», Jeesus pyysi. ");
INSERT INTO fin_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jeesus käski ihmisten istua ruohikkoon. Hän otti ne viisi leipää ja kaksi kalaa, katsoi ylös ja pyysi, että Jumala siunaisi aterian. Sitten hän taitteli leivät palasiksi ja käski oppilaidensa jakaa ne ihmisille. ");
INSERT INTO fin_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kaikki söivät itsensä kylläisiksi. Kun tähteet jälkeenpäin koottiin, niitä kertyi kaksitoista täyttä korillista. ");
INSERT INTO fin_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Paikalla oli noin viisituhatta miestä ja heidän lisäkseen naisia ja lapsia. ");
INSERT INTO fin_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Heti aterian jälkeen Jeesus käski oppilaidensa lähteä veneellä järven yli. Hän itse jäi hyvästelemään ihmisiä. ");
INSERT INTO fin_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kun väki oli lähtenyt, Jeesus meni yksinään rukoilemaan vuorelle. Tuli yö. ");
INSERT INTO fin_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Järvellä oppilaat joutuivat hätään, sillä tuuli oli yltynyt ja aallokko oli raju. ");
INSERT INTO fin_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Aamuyöllä Jeesus tuli heidän luokseen vettä pitkin kävellen. ");
INSERT INTO fin_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Oppilaat huusivat kauhusta, sillä he luulivat näkevänsä aaveen. ");
INSERT INTO fin_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jeesus puhui heille rauhoittavasti: »Minähän tässä olen, älkää pelätkö!» ");
INSERT INTO fin_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pietari ehdotti: »Herra, jos sinä tosiaan olet siinä, käske minun tulla luoksesi vettä pitkin.» ");
INSERT INTO fin_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","»Tule vain», Herra vastasi. Pietari astui veneen laidan yli ja lähti kävelemään Jeesusta kohti. ");
INSERT INTO fin_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mutta kun hänen silmänsä jälleen osuivat korkeihin aaltoihin, hän pelästyi ja alkoi vajota. »Pelasta minut, Herra!» hän parahti. ");
INSERT INTO fin_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jeesus tarttui heti Pietarin käteen. »Miksi epäilit?» hän kysyi. ");
INSERT INTO fin_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tuuli tyyntyi, kun he olivat nousseet veneeseen. ");
INSERT INTO fin_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Muut veneessä olijat istuivat mykistyneinä. Sitten he sanoivat: »Sinä todellakin olet Jumalan Poika!» ");
INSERT INTO fin_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","He nousivat maihin Genesaretissa. ");
INSERT INTO fin_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tieto heidän tulostaan levisi pian paikkakunnalla. Kaikki sairaat tuotiin Jeesuksen parannettaviksi. ");
INSERT INTO fin_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jotkut pyysivät, että saisivat koskea edes hänen viittansa tupsua, ja kaikki, jotka koskettivat sitä, tulivat terveiksi. ");
INSERT INTO fin_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jerusalemista tuli fariseuksia ja muita juutalaisten johtomiehiä keskustelemaan Jeesuksen kanssa. ");
INSERT INTO fin_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","He tiukkasivat: »Miksi sinun oppilaasi eivät noudata vanhaa juutalaisten perinnäissääntöä? Hehän eivät pese käsiään, ennen kuin rupeavat syömään.» ");
INSERT INTO fin_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jeesus vastasi: »Miksi teidän sääntönne sitten rikkovat Jumalan selviä käskyjä? ");
INSERT INTO fin_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jumala on esimerkiksi käskenyt: ’Kunnioita isääsi ja äitiäsi! Sen, joka pilkkaa vanhempiaan, on kuoltava.’ ");
INSERT INTO fin_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Te sen sijaan sanotte: ’Vaikka vanhempasi eläisivät puutteessa, voit antaa heille kuuluvan avustuksen temppelille.’ Olette omatekoisella säännöllänne mitätöineet Jumalan käskyn kunnioittaa vanhempia ja huolehtia heistä. ");
INSERT INTO fin_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tekopyhät! Jesaja ennusti teistä oikein: ");
INSERT INTO fin_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","’Tämä kansa sanoo kunnioittavansa minua, mutta sen sydän on minusta kaukana. ");
INSERT INTO fin_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Sen jumalanpalvelus on arvotonta, sillä se opettaa Jumalan käskyjen sijasta omia sääntöjään.’» ");
INSERT INTO fin_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jeesus huusi kansanjoukon luokseen ja sanoi: »Kuunnelkaa ja yrittäkää ymmärtää, mitä tarkoitan: ");
INSERT INTO fin_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ette te tule epäpyhiksi mistään ruuista! Teidän puheenne ja ajatuksenne teidät saastuttavat.» ");
INSERT INTO fin_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Oppilaat tulivat sanomaan hänelle: »Fariseukset suuttuvat kyllä tuosta väitteestä.» ");
INSERT INTO fin_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jeesus vastasi: »Jokainen kasvi, jota Isäni ei ole istuttanut, on revittävä juurineen maasta. ");
INSERT INTO fin_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Älkää siis heistä välittäkö. He ovat itse sokeita sokeiden taluttajia. Molemmat kaatuvat ojaan.» ");
INSERT INTO fin_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pietari pyysi Jeesusta selittämään, mitä hän tarkoitti sillä, ettei mikään ruoka saastuta ihmistä. ");
INSERT INTO fin_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jeesus ihmetteli: »Ettekö käsitä? ");
INSERT INTO fin_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tiedättehän, että ruoka kulkee suolistossa ja poistuu kehosta. ");
INSERT INTO fin_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sen sijaan pahojen sanojen lähteenä on paha sydän. Ne saastuttavat ihmisen. ");
INSERT INTO fin_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pahat ajatukset, murhat, uskottomuus, irralliset sukupuolisuhteet, varkaudet, valehteleminen ja jumalanpilkka saavat alkunsa sydämestä. ");
INSERT INTO fin_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Näistä ihminen saastuu. Mutta ette te saastu sisäisesti, vaikka jättäisittekin kätenne pesemättä ennen ateriaa.» ");
INSERT INTO fin_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jeesus siirtyi siltä seudulta Tyyron ja Siidonin alueelle. ");
INSERT INTO fin_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Eräs kanaanilainen nainen, joka asui siellä, tuli pyytämään Jeesukselta: »Auta minua, Herra, Daavidin poika! Tyttäressäni on paha henki, joka vaivaa häntä jatkuvasti.» ");
INSERT INTO fin_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jeesus ei vastannut mitään. Oppilaat kehottivat Jeesusta ajamaan naisen tiehensä. »Hänen kerjäämisensä vaivaa meitä», he valittivat. ");
INSERT INTO fin_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Silloin Jeesus sanoi naiselle: »Minut on lähetetty auttamaan juutalaisia, ei pakanoita.» ");
INSERT INTO fin_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mutta nainen tuli hänen eteensä, kumarsi kunnioittavasti ja pyysi taas: »Voi Herra, auta minua!» ");
INSERT INTO fin_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jeesus sanoi: »Ei ole oikein heittää lasten leipää koirille.» ");
INSERT INTO fin_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","»Mutta koiranpennuillakin on oikeus syödä pöydältä putoavia muruja», nainen väitti. ");
INSERT INTO fin_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","»Hyvä ystävä, sinulla on luja usko. Saat mitä pyydät», Jeesus vastasi. Naisen tytär tuli samalla hetkellä terveeksi. ");
INSERT INTO fin_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tämän jälkeen Jeesus palasi Genesaretin järven rannalle. Hän kiipesi vuorenrinteelle ja istuutui. ");
INSERT INTO fin_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Sankka ihmisjoukko tuli hänen luokseen ja toi mukanaan liikuntakyvyttömiä, sokeita, mykkiä ja muita sairaita ja vammaisia. Jeesus paransi heidät kaikki. ");
INSERT INTO fin_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Se oli valtava näytelmä! Mykät pystyivät puhumaan, vammaiset saivat terveet jäsenet, liikuntakyvyttömät kävelivät ja hyppivät ja sokeat katselivat kaikkea suurin silmin! Kansanjoukko ei voinut muuta kuin hämmästellä ja ylistää Israelin Jumalaa. ");
INSERT INTO fin_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jeesus pyysi oppilaansa luokseen ja sanoi heille: »Minun käy näitä ihmisiä sääliksi. He ovat olleet täällä luonani jo kolme päivää eikä heillä ole enää jäljellä mitään syötävää. En haluaisi lähettää heitä kotiin nälkäisinä, hehän nääntyisivät matkalla.» ");
INSERT INTO fin_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Oppilaat vastasivat: »Mistä luulet meidän saavan täällä autiomaassa tarpeeksi syötävää tällaiselle joukolle?» ");
INSERT INTO fin_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jeesus kysyi: »Mitä teillä on mukananne?» He vastasivat: »Seitsemän leipää ja muutama pieni kala.» ");
INSERT INTO fin_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Silloin Jeesus kehotti kaikkia ihmisiä istumaan maahan. ");
INSERT INTO fin_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Hän otti ne seitsemän leipää ja kalat, kiitti niistä Jumalaa ja mursi ne palasiksi. Oppilaat veivät ne kansanjoukoille. ");
INSERT INTO fin_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","38","Kaikki söivät itsensä kylläisiksi – neljäntuhannen miehen lisäksi naiset ja lapset. Jälkeenpäin koottiin vielä tähteitä seitsemän täyttä korillista. ");
INSERT INTO fin_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jeesus lähetti sitten ihmiset kotiin ja lähti itse veneellä Magadanin alueelle. ");
INSERT INTO fin_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseukset ja saddukeukset tulivat eräänä päivänä ottamaan Jeesukselta selvää, oliko hän tosiaan Messias niin kuin väitti. Sen vuoksi he pyysivät, että Jeesus antaisi näkyä jonkin merkin taivaalla. ");
INSERT INTO fin_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jeesus vastasi: »Te olette taitavia ennustamaan säätä taivaan merkkien perusteella: iltarusko tietää teidän mielestänne seuraavaksi päiväksi kaunista ");
INSERT INTO fin_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ja aamurusko huonoa ilmaa. Mutta aikojen merkkejä te ette näe, vaikka ne ovat selviä. ");
INSERT INTO fin_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tämä paha, epäuskoinen kansa pyytää ihmeellistä merkkiä, mutta sille ei anneta muuta merkkiä kuin ihme, joka tapahtui Joonalle.» Ja Jeesus lähti heidän luotaan. ");
INSERT INTO fin_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kun oli tultu järven toiselle rannalle, oppilaat huomasivat, että he olivat unohtaneet ottaa leipää mukaansa. ");
INSERT INTO fin_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jeesus varoitti heitä: »Pysykää erossa fariseusten ja saddukeusten hapatteesta.» ");
INSERT INTO fin_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Oppilaat luulivat, että Jeesus sanoi näin, koska he olivat unohtaneet eväät. ");
INSERT INTO fin_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jeesus tiesi, mitä he ajattelivat, ja sanoi: »Voi teidän uskoanne! Miksi olette niin huolissanne siitä, ettei teillä ole ruokaa? ");
INSERT INTO fin_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ettekö opi mitään? Ettekö muista, miten ruokin viidellä leivällä viisituhatta miestä ja tähteitäkin jäi korikaupalla? ");
INSERT INTO fin_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ettekö muista, miten ruokin neljätuhatta miestä seitsemällä leivällä ja mitä jäi tähteeksi? ");
INSERT INTO fin_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Kuinka voitte kuvitellakaan, että tarkoitin äsken ruokaa? Toistan vielä: varokaa fariseusten ja saddukeusten hapatetta.» ");
INSERT INTO fin_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Lopultakin he käsittivät, että Jeesus oli tarkoittanut hapatteella fariseusten ja saddukeusten väärää oppia. ");
INSERT INTO fin_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kun oli tultu Filippuksen Kesareaan, Jeesus kysyi oppilailtaan: »Kuka minä ihmisten mielestä olen?» ");
INSERT INTO fin_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","»Jotkut pitävät sinua Johannes Kastajana, jotkut Eliana, Jeremiana tai jonakin muuna profeettana», oppilaat vastasivat. ");
INSERT INTO fin_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jeesus kysyi silloin: »Kuka minä teidän mielestänne olen?» ");
INSERT INTO fin_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Pietari vastasi: »Sinä olet Kristus, elävän Jumalan Poika.» ");
INSERT INTO fin_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","»Onnellinen sinä, Simon, Joonan poika», Jeesus sanoi. »Kukaan ihminen ei ole sinulle ilmoittanut sitä, vaan minun Isäni, joka on taivaassa. ");
INSERT INTO fin_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sinun nimesi on Pietari, ’kallio’. Tälle kalliolle minä rakennan seurakuntani, eivätkä helvetin voimat voita sitä. ");
INSERT INTO fin_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Annan sinulle taivaan valtakunnan avaimet. Se, minkä lukitset maan päällä, on lukittu taivaassa, ja minkä täällä avaat, on auki taivaassa!» ");
INSERT INTO fin_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jeesus varoitti oppilaitaan ilmaisemasta muille, että hän on Kristus. ");
INSERT INTO fin_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tästä lähtien Jeesus alkoi puhua oppilailleen siitä, että hänen oli mentävä Jerusalemiin ja kärsittävä kansan johtomiesten käsissä. Hän joutuisi teloitettavaksi, mutta heräisi kolmantena päivänä taas eloon. ");
INSERT INTO fin_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pietari pyysi Jeesuksen syrjään ja alkoi moittia häntä. »Jumala varjelkoon sinua kaikesta tuollaisesta!» hän sanoi. ");
INSERT INTO fin_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jeesus kääntyi Pietariin päin ja sanoi: »Mene pois, saatana! Sinä asetat minulle vaarallisen ansan. Ajattelet asiaa vain ihmisen näkökulmasta, mutta et Jumalan.» ");
INSERT INTO fin_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sitten Jeesus sanoi oppilailleen: »Jos joku haluaa seurata minua, hänen on kiellettävä itsensä, otettava ristinsä ja tultava minun jäljessäni. ");
INSERT INTO fin_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Joka hallitsee itse elämäänsä, menettää sen, mutta joka menettää elämänsä minun takiani, saa sen takaisin. ");
INSERT INTO fin_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mitä hyötyä siitä on, vaikka ihminen omistaisi koko maailman, jos hän kuitenkin menettää ikuisen elämän? Onko mitään sen veroista? ");
INSERT INTO fin_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Minä, Ihmisen poika, tulen enkelieni kanssa Isäni kirkkaudessa ja tuomitsen jokaisen ihmisen sen mukaan, mitä hän on tehnyt. ");
INSERT INTO fin_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Jotkut teistä, jotka seisotte tässä, saavat vielä nähdä, kun palaan kuninkaana.» ");
INSERT INTO fin_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kuusi päivää myöhemmin Jeesus otti Pietarin, Jaakobin, ja tämän veljen Johanneksen mukaansa korkealle, syrjäiselle vuorelle. ");
INSERT INTO fin_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Näiden silmien edessä Jeesuksen olemus äkkiä muuttui: hänen kasvonsa alkoivat loistaa kuin aurinko ja hänen vaatteensa tulivat häikäisevän valkoisiksi. ");
INSERT INTO fin_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mooses ja Elia olivat samassa Jeesuksen luona ja puhuivat hänen kanssaan. ");
INSERT INTO fin_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","»Täällä meidän on hyvä olla», Pietari sanoi hämmentyneenä. »Jos haluat, teen sinulle, Moosekselle ja Elialle majat.» ");
INSERT INTO fin_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kun hän vielä puhui, heidät peitti kirkas pilvi. Pilvestä kuului ääni: »Tämä on rakas Poikani, jonka olen valinnut Pelastajaksi. Totelkaa häntä.» ");
INSERT INTO fin_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Oppilaat kaatuivat pelästyneinä maahan. ");
INSERT INTO fin_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jeesus tuli heidän luokseen ja kosketti heitä. »Nouskaa älkääkä pelätkö», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kohottaessaan katseensa he huomasivat, että Jeesus oli taas yksin. ");
INSERT INTO fin_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Paluumatkalla vuorelta Jeesus kielsi miehiä kertomasta kenellekään, mitä he olivat nähneet, ennen kuin hän olisi kuollut ja herännyt taas eloon. ");
INSERT INTO fin_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Oppilaat kysyivät: »Miksi kansan johtajat väittävät, että Elian on tultava takaisin ennen kuin Messias tulee?» ");
INSERT INTO fin_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jeesus vastasi: »He ovat oikeassa. Elian pitää tulla ja järjestää kaikki kuntoon Messiasta varten. ");
INSERT INTO fin_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Itse asiassa hän on jo tullutkin, mutta häntä ei tunnettu. Monet kohtelivat häntä huonosti. Myös minä, Ihmisen Poika, joudun kärsimään.» ");
INSERT INTO fin_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Silloin oppilaat tajusivat, että Jeesus puhui Johannes Kastajasta. ");
INSERT INTO fin_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Suuri kansanjoukko odotti heitä vuoren juurella. Eräs mies polvistui Jeesuksen eteen ja pyysi: ");
INSERT INTO fin_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","»Herra, armahda minun poikaani! Hän on sairautensa tähden usein suuressa vaarassa, sillä hän kaatuu jopa tuleen ja veteen. ");
INSERT INTO fin_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Toin hänet oppilaittesi parannettavaksi, mutta he eivät pystyneet auttamaan häntä.» ");
INSERT INTO fin_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jeesus vastasi: »Voi, miten epäuskoisia ja kovapäisiä te ihmiset olette! Kuinka kauan minun on siedettävä teitä? Tuokaa poika tänne.» ");
INSERT INTO fin_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jeesus käski pojassa olevaa pahaa henkeä lähtemään, ja niin tapahtui. Poika oli sen jälkeen terve. ");
INSERT INTO fin_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kun oppilaat olivat myöhemmin keskenään Jeesuksen kanssa, he kysyivät: »Miksi me emme saaneet sitä henkeä ajetuksi pois?» ");
INSERT INTO fin_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","»Te olitte epäuskoisia», Jeesus selitti. »Jos teillä olisi edes sinapinsiemenen kokoinen usko, voisitte sanoa tälle vuorelle: ’Siirry paikoiltasi!’ ja se siirtyisi muualle. Mikään ei olisi teille mahdotonta. ");
INSERT INTO fin_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Tosin tällaisen demonin pois ajaminen vaatii rukousta ja paastoa.» ");
INSERT INTO fin_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","He jatkoivat matkaansa Galileassa. Eräänä päivänä Jeesus sanoi: »Joudun sellaisten ihmisten käsiin, ");
INSERT INTO fin_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","jotka tappavat minut. Kolmantena päivän sen jälkeen herään kuitenkin uudestaan eloon.» Oppilaat tulivat hyvin murheellisiksi. ");
INSERT INTO fin_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kun he pääsivät Kapernaumiin, temppeliveron kerääjät tulivat kysymään Pietarilta: »Eikö teidän opettajanne maksa veroa?» ");
INSERT INTO fin_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","»Tietenkin hän maksaa», Pietari vastasi. Hän meni sisään kertomaan Jeesukselle asiasta, mutta ei ehtinyt sanoa sanaakaan ennen kuin Jeesus kysyi: »Mitä arvelet, Pietari, verottavatko hallitsijat omaa kansaansa vai valloittamiensa vieraiden maiden asukkaita?» ");
INSERT INTO fin_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","»Vieraita», Pietari vastasi. »Omalta kansalta ei siis mene veroa», Jeesus totesi. ");
INSERT INTO fin_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","»Mutta meidän ei pidä loukata heitä. Mene rantaan ja ongi kala. Avaa sen suu, niin löydät kolikon, jolla voit maksaa meidän molempien verot.» ");
INSERT INTO fin_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Oppilaat tulivat näihin aikoihin kerran kysymään Jeesukselta, kuka heistä olisi suurin taivaan valtakunnassa. ");
INSERT INTO fin_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jeesus pyysi silloin erään pikkulapsen luokseen ja asetti hänet seisomaan heidän keskelleen. ");
INSERT INTO fin_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Hän selitti: »Jos ette käänny synneistänne Jumalan luo ja muutu lasten kaltaisiksi, ette pääse ollenkaan taivaan valtakuntaan. ");
INSERT INTO fin_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Se joka on yhtä nöyrä kuin tämä lapsi, on taivaan valtakunnassa suurin. ");
INSERT INTO fin_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jos otatte tällaisen lapsen luoksenne siksi, että hän kuuluu minulle, huolehditte itse asiassa minusta. ");
INSERT INTO fin_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Mutta jos joku teistä saa lapsen menettämään uskonsa minuun, hänet pitäisi heittää mereen myllynkivi kaulassaan. ");
INSERT INTO fin_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Voi kuinka paljon maailmassa on pahaa! Kiusaus tehdä väärin tulee väistämättömästi, mutta voi sitä ihmistä, joka aiheuttaa kiusauksen. ");
INSERT INTO fin_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Jos kätesi tai jalkasi saa sinut tekemään syntiä, katkaise se poikki ja heitä menemään. On parempi päästä vammautuneena taivaaseen kuin joutua jäsenet ehjinä kadotukseen. ");
INSERT INTO fin_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jos silmäsi saa sinut tekemään vääryyttä, repäise se irti ja heitä menemään. On parempi olla silmäpuolena taivaassa kuin molemmat silmät tallella kadotuksessa. ");
INSERT INTO fin_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Älkää aliarvioiko ketään lasta. Tiedättekö: heidän enkelinsä ovat taivaassa jatkuvasti Isäni välittömässä läheisyydessä. ");
INSERT INTO fin_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Minä, Ihmisen Poika, tulin pelastamaan kadonneita. ");
INSERT INTO fin_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Jos miehellä on sata lammasta ja yksi niistä katoaa, mitä hän tekee? Eikö hän jätä niitä yhdeksääkymmentäyhdeksää ja lähde etsimään kadonnutta vuorilta? ");
INSERT INTO fin_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Jos hän löytää kadonneen, hän on siitä paljon iloisempi kuin kaikista muista, jotka ovat kotona turvassa. ");
INSERT INTO fin_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Samalla tavoin Isäni tahtoo, ettei yksikään näistä pienistä lapsista joudu hukkaan. ");
INSERT INTO fin_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jos uskonveljesi tekee sinulle vääryyttä, keskustele hänen kanssaan asiasta. Jos hän suostuu tunnustamaan syntinsä, olet voittanut hänet takaisin. ");
INSERT INTO fin_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ellei hän usko sinua, mene uudestaan parin muun kanssa hänen luokseen. Nyt sinulla on todistajat. ");
INSERT INTO fin_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jos hän yhä kieltäytyy kuuntelemasta, pyydä seurakuntaa ratkaisemaan asiasi. Mikäli seurakunta katsoo sinun olevan oikeassa, mutta hän ei hyväksy sen päätöstä, hänet on erotettava seurakunnasta. ");
INSERT INTO fin_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Vakuutan teille: se minkä te sidotte maan päällä, on sidottu taivaassa ja minkä taas päästätte vapaaksi, vapautetaan taivaassa. ");
INSERT INTO fin_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Teidän on myös hyvä tietää, että jos kaksi teistä päättää yhdessä pyytää jotakin Isältäni, joka on taivaassa, hän vastaa rukoukseenne. ");
INSERT INTO fin_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sillä siellä missä kaksi tai kolme omaani on koolla minuun nimessäni, olen minä heidän luonaan.» ");
INSERT INTO fin_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pietari tuli tämän jälkeen kysymään Jeesukselta: »Herra, kuinka monta kertaa minun on annettava anteeksi veljelleni, joka tekee minulle vääryyttä? Seitsemänkö?» ");
INSERT INTO fin_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","»Ei, vaan seitsemänkymmentä kertaa seitsemän», Jeesus vastasi. ");
INSERT INTO fin_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Sitten hän jatkoi: »Taivaan valtakuntaa voidaan verrata kuninkaaseen, joka ryhtyi tekemään selvitystä saatavistaan. ");
INSERT INTO fin_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eräällä miehellä oli hänelle miljoonien velka. ");
INSERT INTO fin_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kun mies ei pystynyt maksamaan, kuningas määräsi hänet, hänen vaimonsa ja lapsensa ja koko hänen omaisuutensa myytäväksi. ");
INSERT INTO fin_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Sen kuullessaan mies heittäytyi maahan kuninkaan eteen ja pyysi: ’Ole kärsivällinen, maksan vielä kaiken!’ ");
INSERT INTO fin_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kuninkaan kävi häntä sääliksi. Hän päästi miehen menemään ja antoi koko velan anteeksi. ");
INSERT INTO fin_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ulkona tämä mies tapasi toverinsa, joka puolestaan oli hänelle velkaa, mutta vain vähän. Hän kävi uhkaillen toverinsa kimppuun ja vaati, että velka oli heti maksettava. ");
INSERT INTO fin_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tämä heittäytyi polvilleen ja pyysi nöyrästi lisää aikaa. ’Jos voit vähän odottaa, niin maksan kyllä velkani’, hän anoi. ");
INSERT INTO fin_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Mutta toinen ei suostunut odottamaan. Hän järjesti miehen vankilaan siksi kunnes koko velka olisi maksettu. ");
INSERT INTO fin_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Vangitun ystävät menivät kertomaan kuninkaalle, mitä oli tapahtunut. ");
INSERT INTO fin_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tämä kutsui luokseen miehen, jolle oli antanut suuren velan anteeksi ja sanoi: ’Kuinka sinä voit olla noin kova? Sait minulta valtavan suuren velan anteeksi kun vain pyysit. ");
INSERT INTO fin_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Eikö sinun olisi samalla tavoin pitänyt antaa armon käydä oikeudesta?’ ");
INSERT INTO fin_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Vihaisena kuningas määräsi miehen vankilaan, kunnes tämä olisi maksanut velkansa viimeistä killinkiä myöten. ");
INSERT INTO fin_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Näin suhtautuu myös Taivaallinen Isäni teihin, ellette suostu antamaan muille sydämestänne anteeksi.» ");
INSERT INTO fin_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kun Jeesus oli lopettanut puheensa, hän lähti Galileasta takaisin Juudeaan Jordanin toiselle puolelle. ");
INSERT INTO fin_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Suuri ihmisjoukko seurasi häntä, ja hän paransi sairaita. ");
INSERT INTO fin_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jotkut fariseukset tulivat tekemään Jeesukselle kysymyksiä. He yrittivät saada hänet puhumaan sellaista, mikä koituisi hänen turmiokseen. »Hyväksytkö avioeron?» he kysyivät. ");
INSERT INTO fin_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","»Ettekö lue Raamattua?» Jeesus kysyi takaisin. »Siellähän sanotaan, että Jumala loi alun pitäen ihmisen mieheksi ja naiseksi. ");
INSERT INTO fin_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","6","Miehen on lähdettävä isänsä ja äitinsä luota ja liityttävä vaimoonsa niin, että heistä tulee kuin yksi ruumis. Jumala on yhdistänyt aviopuolisot, eikä kukaan saa erottaa heitä.» ");
INSERT INTO fin_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fariseukset kysyivät: »Miksi Mooses sitten sanoi, että mies voi erota vaimostaan, kunhan kirjoittaa erokirjan?» ");
INSERT INTO fin_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jeesus vastasi: »Mooses tiesi, miten sydämettömiä te olette. Hänen oli suostuttava sellaiseen, mikä alun perin ei ollut Jumalan tarkoitus. ");
INSERT INTO fin_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mutta minä sanon, että mies tekee aviorikoksen, jos hän eroaa vaimostaan jonkin muun syyn kuin uskottomuuden tähden ja menee toisen kanssa naimisiin. Samoin mies, joka solmii eronneen naisen kanssa avioliiton, tekee aviorikoksen.» ");
INSERT INTO fin_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Silloin Jeesuksen oppilaat sanoivat hänelle: »Jos noin on asia, niin sitten on parempi, ettei mene ollenkaan naimisiin.» ");
INSERT INTO fin_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","»Kaikkiin se ei sovi», Jeesus sanoi. »Vain ne, joille Jumala antaa siihen erityisen avun, voivat hyväksyä naimattomuutensa. ");
INSERT INTO fin_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jotkut ovat syntymästään saakka sellaisia, etteivät voi mennä naimisiin. Toisille ovat ihmiset aiheuttaneet esteitä. Jotkut eivät halua Jumalan valtakunnan tähden solmia avioliittoa. Joka voi, soveltakoon tämän itseensä.» ");
INSERT INTO fin_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jeesuksen luo tuotiin pieniä lapsia, että hän panisi kätensä heidän päälleen ja rukoilisi. Oppilaat moittivat lasten tuojia: »Te häiritsette Jeesusta!» ");
INSERT INTO fin_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mutta Jeesus sanoi: »Älkää estäkö lapsia tulemasta minun luokseni. Taivaan valtakunta kuuluu heidänlaisilleen.» ");
INSERT INTO fin_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jeesus pani kätensä lasten päälle ja siunasi heidät ennen kuin jatkoi matkaansa. ");
INSERT INTO fin_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nuori mies tuli kysymään Jeesukselta: »Herra, mitä hyvää minun on tehtävä, että pääsisin ikuiseen elämään?» ");
INSERT INTO fin_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","»Hyvää?» Jeesus sanoi. »Vain Jumala on todella hyvä. Mutta ikuiseen elämään voit päästä, kun pidät käskyt.» ");
INSERT INTO fin_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","»Mitkä käskyt?» mies kysyi. Jeesus luetteli: »Älä tapa, älä tee aviorikosta, älä varasta, älä valehtele, ");
INSERT INTO fin_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","kunnioita isääsi ja äitiäsi ja rakasta lähimmäistäsi niin kuin itseäsi.» ");
INSERT INTO fin_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","»Minähän olen aina noudattanut niitä kaikkia», nuori mies vastasi. »Eikö se riitä?» ");
INSERT INTO fin_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jeesus vastasi: »Jos tahdot olla täydellinen, myy omaisuutesi ja anna rahat köyhille. Silloin sinulla on aarre taivaassa. Ja sitten lähde minun mukaani.» ");
INSERT INTO fin_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kun mies kuuli tämän, hän meni allapäin pois, sillä hän oli hyvin rikas. ");
INSERT INTO fin_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jeesus selitti oppilailleen: »Rikkaan on todella vaikea päästä taivaan valtakuntaan. ");
INSERT INTO fin_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kamelikin menee helpommin neulansilmän läpi.» ");
INSERT INTO fin_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Oppilaat olivat ihmeissään. »Kuka sitten voi pelastua?» he kysyivät. ");
INSERT INTO fin_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jeesus katsoi heihin pitkään ja sanoi: »Omin voimin ei kukaan ihminen pelastu, mutta Jumalalle on kaikki mahdollista.» ");
INSERT INTO fin_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pietari muistutti: »Me jätimme kaiken ja lähdimme mukaasi. Mitä saamme siitä?» ");
INSERT INTO fin_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jeesus vastasi: »Kun syntyy uusi maailma, jota minä, Ihmisen Poika, hallitsen, saatte Israelin kaksitoista heimoa johtoonne. ");
INSERT INTO fin_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jokainen, joka on luopunut kodista, veljistä, sisarista, isästä, äidistä, vaimosta, lapsista tai henkilökohtaisesta omaisuudesta voidakseen seurata minua, saa takaisin satakertaisesti ja elää ikuisesti. ");
INSERT INTO fin_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Monet, jotka nyt ovat ensimmäisiä, ovat uudessa maailmassa viimeisiä, mutta monista viimeisistä tulee ensimmäisiä.» ");
INSERT INTO fin_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jeesus kuvasi taivaan valtakuntaa tällaisellakin kertomuksella: »Tilanomistaja lähti aikaisin aamulla pestaamaan sadonkorjaajia viinitarhaansa. ");
INSERT INTO fin_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Hän sopi päiväpalkasta ja lähetti miehet töihin. ");
INSERT INTO fin_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pari tuntia myöhemmin hän näki torilla työttömiä miehiä ");
INSERT INTO fin_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ja pyysi heitäkin työhön viljelmälleen. Hän lupasi maksaa illalla sen mikä heille kuului. ");
INSERT INTO fin_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Puolenpäivän aikaan ja kolmen maissa iltapäivällä hän palkkasi vielä uusia sadonkorjaajia. ");
INSERT INTO fin_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kun hän oli kaupungilla viiden tienoissa, hän näki vielä muutamia joutilaita miehiä ja kysyi: ’Mitä te täällä seisoskelette?’ ");
INSERT INTO fin_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","’Kukaan ei ole tarjonnut meille työtä’, he vastasivat. ’Menkää sitten muiden mukaan minun viinitarhaani’, isäntä sanoi. ");
INSERT INTO fin_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Illalla hän käski tilanhoitajansa kutsua miehet sisään hakemaan palkkaansa. ");
INSERT INTO fin_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ne, jotka olivat tulleet töihin viideltä, saivat täyden päiväpalkan. ");
INSERT INTO fin_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Aikaisemmin työnsä aloittaneet luulivat saavansa enemmän, mutta sama summa pantiin heidänkin käteensä. ");
INSERT INTO fin_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","He olivat tyytymättömiä: ’Nuohan olivat töissä vain tunnin! Me olemme tehneet työtä koko päivän kovassa helteessä, ja meille kuuluu suurempi palkka.’ ");
INSERT INTO fin_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Isäntä vastasi eräälle heistä: ’Hyvä ystävä, en ole tehnyt sinulle vääryyttä. Mehän sovimme palkasta. ");
INSERT INTO fin_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ota osuutesi ja lähde. Minä haluan antaa kaikille yhtä paljon. ");
INSERT INTO fin_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Onko laitonta jaella rahojaan kenelle tahtoo? Oletko vihainen siksi, että minä olen hyvä?’ ");
INSERT INTO fin_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Näin viimeisistä tulee ensimmäisiä ja ensimmäisistä viimeisiä.» ");
INSERT INTO fin_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Matkalla Jerusalemiin Jeesus vei kaksitoista oppilastaan syrjään ");
INSERT INTO fin_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","ja ilmoitti heille, mitä perillä tapahtuisi. »Minut annetaan ylipappien ja muiden johtavien juutalaisten käsiin. ");
INSERT INTO fin_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","He tuomitsevat minut kuolemaan ja luovuttavat minut roomalaisille. Minua pilkataan ja pahoinpidellään. Kuolen ristillä, mutta herään kolmantena päivänä sen jälkeen uudelleen eloon.» ");
INSERT INTO fin_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedeuksen vaimo tuli poikiensa Jaakobin ja Johanneksen kanssa Jeesuksen luoja kumarsi kunnioittavasti. ");
INSERT INTO fin_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","»Mitä sinä haluat?» Jeesus kysyi. »Annathan sitten valtakunnassasi pojilleni vierestäsi kunniapaikat?» nainen pyysi. ");
INSERT INTO fin_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jeesus sanoi veljeksille: »Ette tiedä, mitä pyydätte! Pystyttekö te tyhjentämään saman maljan kuin minä?» »Pystymme», he vastasivat. ");
INSERT INTO fin_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","»Te todellakin saatte saman kohtalon kuin minä, mutta minulla ei ole oikeutta määrätä, kuka istuu vieressäni. Ne paikat on varattu ihmisille, jotka Isäni on valinnut.» ");
INSERT INTO fin_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Muut Jeesuksen oppilaat loukkaantuivat veljeksiin, kun kuulivat, mitä nämä olivat pyytäneet. ");
INSERT INTO fin_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jeesus kutsui heidät kaikki luokseen ja alkoi puhua: »Te tiedätte, että maan mahtavat käyttävät valtaansa väärin ja harjoittavat sortoa. ");
INSERT INTO fin_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Näin ei saa olla teidän joukossanne. Joka haluaa olla johtaja, sen on oltava teidän palvelijanne. ");
INSERT INTO fin_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Joka tahtoo olla ensimmäinen, sen on oltava teidän kaikkien orja. ");
INSERT INTO fin_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Teillä täytyy olla sama asenne kuin minulla: minä, Ihmisen Poika, en tullut tänne palveltavaksi, vaan palvelemaan ja hengelläni ostamaan ihmiset vapaiksi.» ");
INSERT INTO fin_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Kun Jeesus lähti oppilaineen Jerikosta, valtava ihmisjoukko tungeksi heidän perässään. ");
INSERT INTO fin_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tien vieressä istui kaksi sokeaa miestä. Kun he kuulivat, että Jeesus oli tulossa, he alkoivat huutaa: »Armoa, Daavidin Poika, auta meitä!» ");
INSERT INTO fin_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ihmiset käskivät heidän olla hiljaa, mutta huuto vain yltyi. ");
INSERT INTO fin_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jeesus tuli paikalle. Hän pysähtyi tielle ja kysyi: »Mitä tahdotte minun tekevän teille?» ");
INSERT INTO fin_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","»Me tahtoisimme saada näkömme», he vastasivat. ");
INSERT INTO fin_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jeesuksen tuli sääli sokeita. Hän kosketti heidän silmiään, ja samassa he saivat näkönsä ja lähtivät seuraamaan Jeesusta. ");
INSERT INTO fin_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lähestyttiin Jerusalemia. Öljymäeltä Jeesus lähetti kaksi oppilasta edeltäpäin Beetfagen kylään. ");
INSERT INTO fin_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","»Löydätte heti kylään tultuanne sidotun aasin, jonka vierellä on varsa. Irrottakaa ne ja tuokaa tänne», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","»Jos joku kysyy, mitä oikein teette, sanokaa vain, että Herra tarvitsee niitä, ja kaikki sujuu hyvin.» ");
INSERT INTO fin_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Näin toteutui vanha ennustus: ");
INSERT INTO fin_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","»Kertokaa Jerusalemille, että sen Kuningas on tulossa. Hän ratsastaa nöyrästi aasilla, työjuhdan varsalla!» ");
INSERT INTO fin_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Oppilaat tekivät niin kuin Jeesus oli pyytänyt. ");
INSERT INTO fin_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","He toivat eläimet Jeesukselle ja levittivät vaatteitaan niiden selkään. Jeesus nousi ratsaille. ");
INSERT INTO fin_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Monet ihmiset riisuivat viittansa tielle Jeesuksen eteen. Toiset katkoivat puista oksia ja levittivät niitä tielle. ");
INSERT INTO fin_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kansanjoukko tungeksi hänen edellään ja jäljessään ja huusi: »Eläköön kuningas! Kunnia Jumalan lähettämälle! Auta meitä, sinä, joka tulet taivaasta!» ");
INSERT INTO fin_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Koko Jerusalem kohisi, kun Jeesus tuli kaupunkiin. Ihmiset kyselivät: »Kuka hän oikein on?» ");
INSERT INTO fin_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kansanjoukko vastasi: »Hän on se nasaretilainen profeetta Jeesus kaukaa Galileasta.» ");
INSERT INTO fin_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jeesus meni temppeliin, ajoi ulos myyjät ja ostajat ja kaatoi rahanvaihtajien pöydät ja kyyhkystenmyyjien telineet. ");
INSERT INTO fin_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","»Raamattu sanoo, että Jumalan temppeli on paikka, jossa rukoillaan», Jeesus julisti. »Te olette tehneet siitä rosvoluolan.» ");
INSERT INTO fin_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Sokeita ja rampoja tuli Jeesuksen luo, ja hän paransi heidät temppelissä. ");
INSERT INTO fin_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ylipapit ja muut juutalaisten johtomiehet näkivät, että ihmeitä tapahtui, ja kuulivat vielä lasten huutavan temppelissä: »Kiitetty olkoon Daavidin poika!» Silloin he suuttuivat ja menivät kysymään Jeesukselta: »Etkö tajua, mitä nuo lapset huutavat?» ");
INSERT INTO fin_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","»Tajuan», Jeesus vastasi. »Ettekö ole lukeneet Raamattua? Siellähän sanotaan, että jopa pienet lapset ylistävät Messiasta.» ");
INSERT INTO fin_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jeesus lähti yöksi Betaniaan. ");
INSERT INTO fin_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kun hän palasi aamulla Jerusalemiin, hänen oli nälkä. ");
INSERT INTO fin_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tien vieressä kasvoi viikunapuu. Jeesus meni etsimään siitä viikunoita, mutta löysi pelkkiä lehtiä. Silloin hän sanoi puulle: »Älä enää koskaan kanna hedelmää!» Puu kuivettui aivan silmissä. ");
INSERT INTO fin_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Oppilaat ällistyivät ja kysyivät: »Miten tuo puu voi kuolla noin nopeasti?» ");
INSERT INTO fin_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jeesus vastasi: »Toden totta, jos te uskoisitte epäilemättä yhtään, voisitte tehdä saman ihmeen ja paljon enemmänkin. Voisitte vaikka käskeä tätä Öljymäkeä siirtymään mereen, ja se siirtyisi. ");
INSERT INTO fin_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jos uskotte, saatte kaiken, mitä rukoilette.» ");
INSERT INTO fin_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jeesus palasi temppeliin ja alkoi opettaa kansaa. Ylipapit ja muut johtomiehet tulivat vaatimaan häneltä selitystä, kenen antamilla valtuuksilla hän teki kaikkea. ");
INSERT INTO fin_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","»Kerron sen, jos vastaatte ensin minun kysymykseeni», Jeesus lupasi. ");
INSERT INTO fin_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","»Lähettikö Jumala Johannes Kastajan? Kyllä vai ei?» ");
INSERT INTO fin_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","He keskustelivat asiasta. »Jos vastaamme myöntävästi, hän kysyy, miksi emme uskoneet Johannesta. Jos taas sanomme ei, ihmiset käyvät kimppuumme, sillä heidän mielestään Johannes oli profeetta.» ");
INSERT INTO fin_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Lopulta he vastasivat: »Emme tiedä.» Jeesus sanoi: »En minäkään sitten vastaa teidän kysymykseenne. ");
INSERT INTO fin_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Mutta mitä mieltä olette tästä: Eräällä miehellä oli kaksi poikaa. Hän pyysi vanhempaa menemään päiväksi pellolle töihin. ");
INSERT INTO fin_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","’En minä halua’, poika vastasi. Myöhemmin hän kuitenkin muutti mieltään ja meni. ");
INSERT INTO fin_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Isä pyysi nuorempaakin menemään työhön. Tämä lupasi lähteä, muttei lopulta mennytkään. ");
INSERT INTO fin_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kumpi totteli isäänsä?» He vastasivat: »Tietysti ensimmäinen.» Jeesus selitti, mitä hän oli tarkoittanut: »Monet syntiset pääsevät Jumalan valtakuntaan ennen teitä. ");
INSERT INTO fin_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Johannes Kastaja käski teidän katua ja tulla Jumalan luo, mutta te vähät välititte siitä. Sen sijaan monet julkisyntisetkin tottelivat. Vaikka näitte sen, ette sittenkään uskoneet. ");
INSERT INTO fin_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Kuunnelkaahan toista kertomusta. Tilanomistaja istutti viinitarhan ja ympäröi sen aidalla. Hän rakensi torninkin vartijalle. Sitten hän vuokrasi tarhan muille ja muutti ulkomaille. ");
INSERT INTO fin_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Hedelmien kypsymisen aikaan hän lähetti miehiään hakemaan tarhalta hänen osuuttaan. ");
INSERT INTO fin_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mutta vuokralaiset hyökkäsivät miesten kimppuun, pahoinpitelivät ja kivittivät heitä ja lopulta surmasivat heidät. ");
INSERT INTO fin_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Hän lähetti suuremman miesjoukon matkaan, mutta tulos oli sama. ");
INSERT INTO fin_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Lopulta hän lähetti oman poikansa ajatellen, että vuokraajat kunnioittaisivat sentään häntä. ");
INSERT INTO fin_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mutta kun viinitarhan hoitajat näkivät, että poika oli tulossa, he suunnittelivat: ’Tuo mies perii tilan. Kun tapamme hänet, saamme pitää viinitarhan!’ ");
INSERT INTO fin_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Niinpä he raahasivat pojan aidan ulkopuolelle ja tappoivat hänet. ");
INSERT INTO fin_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Mitä luulette omistajan tekevän viinitarhureille, kun hän palaa?» ");
INSERT INTO fin_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Juutalaisten johtomiehet vastasivat: »Hän tuhoaa heidät ja vuokraa viljelmänsä toisille, jotka maksavat täsmällisesti vuokransa.» ");
INSERT INTO fin_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Silloin Jeesus kysyi heiltä: »Ettekö ole lukeneet Raamatusta: ’Rakentajien hylkäämästä kivestä on tullut peruskivi. Mitä ihmeellistä Herra onkaan tehnyt!’ ");
INSERT INTO fin_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tarkoitan sitä, että te menetätte Jumalan valtakunnan. Se annetaan toiselle kansalle, joka tuottaa hedelmää Jumalalle. ");
INSERT INTO fin_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Joka kompastuu tähän totuuden kiveen, ruhjoutuu, ja joka jää sen alle, murskautuu kokonaan.» ");
INSERT INTO fin_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kun johtomiehet käsittivät, että Jeesus tarkoittikin heitä petollisilla viinitarhureilla, ");
INSERT INTO fin_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","he olisivat halunneet ottaa hänet kiinni, mutta eivät uskaltaneet: kansa näet piti häntä profeettana. ");
INSERT INTO fin_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jeesus kuvasi vielä monien kertomusten avulla Jumalan valtakuntaa. ");
INSERT INTO fin_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Hän kertoi kuninkaasta, joka järjesti pojalleen hienot häät. ");
INSERT INTO fin_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","»Kutsuttiin paljon vieraita. Kun kaikki oli valmista, kutsutuille lähetettiin viesti: ’Juhla alkaa!’ Mutta joka ainoa peruutti tulonsa. ");
INSERT INTO fin_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kuningas lähetti toiset viestinviejät ilmoittamaan: ’Tervetuloa häihin! Paistit ovat jo kypsymässä ja juhla voi kohta alkaa.’ ");
INSERT INTO fin_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ihmiset eivät välittäneet kutsusta vaan menivät omiin töihinsä – kuka kauppaansa, kuka pellollensa. ");
INSERT INTO fin_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jotkut hyökkäsivät kutsujien kimppuun ja uhkailivat heitä häpeämättömästi, jopa tappoivatkin muutamia heistä. ");
INSERT INTO fin_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Silloin kuningas suuttui. Hän lähetti sotilaita tekemään murhaajista lopun ja hävittämään heidän kaupunkinsa. ");
INSERT INTO fin_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sitten hän ilmoitti palvelijoilleen: ’Hääpäivällinen on valmis. Kutsumani vieraat eivät olleet kutsun arvoisia. ");
INSERT INTO fin_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Menkää katujen risteyksiin ja pyytäkää juhliin kaikki jotka tapaatte.’ ");
INSERT INTO fin_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Palvelijat tekivät niin kuin kuningas käski. He toivat juhlasalin täyteen ihmisiä. Joukkoon mahtui sekä hyviä että pahoja. ");
INSERT INTO fin_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Kun kuningas tuli tervehtimään vieraita, hän näki, että eräällä miehellä ei ollut juhlapukua, jollainen oli varattu kaikille vieraille? ");
INSERT INTO fin_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","’Hyvä ystävä, miten voit olla täällä tuollaisissa vaatteissa?’ hän ihmetteli. Mies ei osannut vastata. ");
INSERT INTO fin_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kuningas antoi palvelijoilleen käskyn: ’Sitokaa tämän miehen kädet ja jalat ja heittäkää hänet ulos pimeään, missä hän joutuu itkemään ja valittamaan.’ ");
INSERT INTO fin_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Monia kutsutaan, mutta vain harvat valitaan.» ");
INSERT INTO fin_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Fariseukset yrittivät keksiä, kuinka saisivat Jeesuksen puhumaan sellaista, mistä hänet voitaisiin pidättää. ");
INSERT INTO fin_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","He lähettivät asialle omia miehiään ja Herodeksen puolueen jäseniä. Nämä selittivät: »Opettaja, tiedämme, että olet rehellinen ja pidät kiinni totuudesta, maksoi mitä maksoi. Et pelkää tai suosi ketään. ");
INSERT INTO fin_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sano nyt meille, onko oikein maksaa veroja Rooman hallitukselle?» ");
INSERT INTO fin_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jeesus näki heidän lävitseen. »Voi teitä tekopyhiä», hän huokasi. »Ketä yritätte pettää kysymyksellänne? ");
INSERT INTO fin_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Antakaahan tänne kolikko.» He ojensivat hänelle rahan. ");
INSERT INTO fin_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","»Kenen kuva siihen on painettu?» Jeesus kysyi. ");
INSERT INTO fin_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","»Keisarin», he vastasivat. »No hyvä, antakaa se keisarille, jos se on hänen, mutta antakaa myös Jumalalle kaikki, mikä kuuluu hänelle.» ");
INSERT INTO fin_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jeesuksen vastaus sai heidät sanattomiksi, ja he lähtivät tiehensä. ");
INSERT INTO fin_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Samana päivänä tulivat muutamat saddukeukset, jotka eivät uskoneet kuolemanjälkeiseen elämään, kysymään Jeesuksen mielipidettä: ");
INSERT INTO fin_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","»Mooses sanoi, että jos mies kuolee lapsettomana, hänen veljensä on mentävä lesken kanssa naimisiin. Heidän lapsensa perivät kuolleen omaisuuden. ");
INSERT INTO fin_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Eräässä tuntemassamme perheessä oli seitsemän poikaa. Vanhin solmi avioliiton ja kuoli lapsettomana. Seuraava poika meni sitten naimisiin lesken kanssa. ");
INSERT INTO fin_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Myös tämä mies kuoli lapsettomana. Vaimosta tuli kolmannenkin veljeksen puoliso. ");
INSERT INTO fin_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Loppujen lopuksi hän ehti olla naimisissa kaikkien seitsemän kanssa ennen kuin kuoli itse. ");
INSERT INTO fin_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kenen vaimo hän oikein on kuoleman jälkeen?» ");
INSERT INTO fin_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jeesus vastasi: »Te erehdytte, kun ette tunne Raamattua ettekä Jumalan voimaa. ");
INSERT INTO fin_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ylösnousemuksen jälkeen ei avioliittoa ole. Ihmisistä tulee samanlaisia kuin taivaan enkeleistä. ");
INSERT INTO fin_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Onko sitten elämää kuoleman jälkeen? Ettekö lue Raamattua? Siellähän Jumala sanoo teille suoraan: ");
INSERT INTO fin_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","’Minä olen Aabrahamin, Iisakin ja Jaakobin Jumala.’ He elävät yhä, sillä Jumala ei ole kuolleiden Jumala.» ");
INSERT INTO fin_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jeesuksen vastaukset tekivät syvän vaikutuksen muihin ");
INSERT INTO fin_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","35","paitsi fariseuksiin. Kun he kuulivat, että hän oli vastauksillaan tukkinut saddukeusten suun, he keksivät taas itse uuden kysymyksen. Farisealainen laintuntija tuli tiedustelemaan Jeesukselta: ");
INSERT INTO fin_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","»Opettaja, mikä on Mooseksen lain tärkein käsky?» ");
INSERT INTO fin_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jeesus vastasi: »’Rakasta Herraa, sinun Jumalaasi, koko sydämestäsi, sielustasi ja mielestäsi.’ ");
INSERT INTO fin_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","39","Se on ensimmäinen ja tärkein käsky. Toinen, yhtä tärkeä on tämä: ’Rakasta lähimmäistäsi yhtä paljon kuin itseäsi.’ Jos tottelette näitä käskyjä, noudatatte koko lakia. ");
INSERT INTO fin_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kaikki muut käskyt ja profeettojen opetukset juontavat juurensa näistä kahdesta käskystä.» ");
INSERT INTO fin_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseukset pyörivät Jeesuksen ympärillä. Hän heitti heille kysymyksen: ");
INSERT INTO fin_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","»Mitä mieltä olette Messiaasta? Kenen poika hän on?» »Daavidin», he vastasivat. ");
INSERT INTO fin_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","»Miksi Daavid sitten sanoo häntä Pyhän Hengen innoittamana ’Herraksi’?» Jeesus kysyi. »Daavidhan kertoi: ");
INSERT INTO fin_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","’Jumala käski Herrani istuutua oikealle puolelleen, kunnes hän voittaisi tämän viholliset.’ ");
INSERT INTO fin_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Voiko Messias olla Daavidin poika, vaikka tämä kutsui häntä Herrakseen?» ");
INSERT INTO fin_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","He eivät osanneet vastata. Sen jälkeen ei kukaan enää uskaltanut kysyä Jeesukselta mitään. ");
INSERT INTO fin_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jeesus puhui sitten kansanjoukolle ja omille oppilailleen: ");
INSERT INTO fin_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","»Lainopettajat ja fariseukset opettavat teitä tuntemaan lakia. He ovat hyvin tiukkoja. ");
INSERT INTO fin_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Hyvä on, kun teette niin kuin he käskevät, mutta älkää seuratko heidän esimerkkiään, sillä he eivät itse elä oppiensa mukaan. ");
INSERT INTO fin_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","He asettavat teille mahdottomia vaatimuksia, mutta eivät yritäkään täyttää niitä itse. ");
INSERT INTO fin_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","He haluavat koko ajan herättää huomiota. Heidän raamatunlausekotelonsa ovat suuret ja viittansa tupsut pitkät, sillä he haluavat vaikuttaa pyhiltä. ");
INSERT INTO fin_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","He istuvat mielellään juhlissa parhailla paikoilla ja synagogassa etupenkillä. ");
INSERT INTO fin_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","He ovat mielissään, kun heitä tervehditään kadulla kunnioittavasti ja sanotaan ’rabbiksi’, ’opettajaksi’. ");
INSERT INTO fin_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Älkää te vain antako kenenkään sanoa itseänne ’rabbiksi’. Jumala on ainoa Opettajanne ja te olette kaikki samanarvoisia. ");
INSERT INTO fin_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Älkää sanoko ketään ihmistä ’Isäksi’, sillä taivaassa on ainoa Isänne, Jumala. ");
INSERT INTO fin_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Älkää antako sanoa itseänne ’Mestariksi’, sillä vain Kristus on Mestarinne. ");
INSERT INTO fin_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mitä enemmän palvelette muita, sitä suurempia olette. ");
INSERT INTO fin_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jos joku pitää itseään suurena, hän joutuu pettymään ja nöyrtymään, mutta vaatimaton korotetaan. ");
INSERT INTO fin_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Voi teitä tekopyhiä fariseuksia ja lainopettajia! Ette halua itse mennä taivaan valtakuntaan ettekä päästäisi sinne muitakaan. ");
INSERT INTO fin_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kuljette suunnattomia matkoja voittaaksenne yhden käännynnäisen. Sitten teette hänestä kaksi kertaa pahemman kuin itse olette, ja hän joutuu kadotukseen. ");
INSERT INTO fin_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Voi teitä sokeita oppaita! Neuvotte ihmisiä, että ’temppelin kautta’ vannottu vala voidaan purkaa, mutta ’temppelin kullan kautta’ vannottu vala on sitova. ");
INSERT INTO fin_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Järjetöntä! Kumpi on pyhempi: kultako vai temppeli, joka pyhittää kullan? ");
INSERT INTO fin_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Sanotte myös, että vala, joka on vannottu ’alttarin kautta’, voidaan rikkoa, mutta jos vannoo ’alttarilla olevien lahjojen kautta’, silloin vala on pitävä. ");
INSERT INTO fin_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sehän on järjetöntä! Onko alttarilla oleva lahja arvokkaampi kuin itse alttari, joka pyhittää lahjan? ");
INSERT INTO fin_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kun vannotte alttarin kautta, vannotte samalla kaiken sillä olevan kautta. ");
INSERT INTO fin_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kun taas vannotte temppelin kautta, vannotte samalla temppelissä asuvan Jumalan kautta. ");
INSERT INTO fin_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kun vannotte taivaan kautta, vannotte Jumalan valtaistuimen ja hänen itsensä kautta. ");
INSERT INTO fin_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Voi teitä teeskenteleviä fariseuksia ja lainopettajia! Te kyllä annatte Jumalalle tarkan kymmenesosan jopa mintuista, tilleistä ja kuminoista, mutta lyötte laimin jotakin hyvin tärkeää: oikeuden, armeliaisuuden ja uskollisuuden. Kymmenykset on toki maksettava, mutta teidän pitäisi muistaa myös tärkeämmät asiat. ");
INSERT INTO fin_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Olette sokeita! Te siivilöitte hyttysen ja nielaisette kamelin. ");
INSERT INTO fin_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Voi te hurskastelevat fariseukset ja lainopettajat! Kiillotatte maljan päältäpäin huolellisesti, mutta sisältä se on täynnä ahneutta ja kiristystä. ");
INSERT INTO fin_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Sinä sokea fariseus, pese malja ensin sisältä, niin se tulee kokonaan puhtaaksi! ");
INSERT INTO fin_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Te fariseukset ja lainopettajat olette kuin kalkilla päältä kaunistetut hautakammiot. Niiden sisällä on kuitenkin vain luita ja saastaa. ");
INSERT INTO fin_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yritätte näyttää täydellisiltä, mutta hurskaan ulkokuorenne alla on vain tekopyhyyttä ja vääryyttä. ");
INSERT INTO fin_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","Niin, te rakennatte muistomerkkejä isienne surmaamille profeetoille ja istutatte kukkia tapettujen Jumalan miesten haudoille. Väitätte, ettette ikinä olisi syyllistyneet samaan kuin esi-isänne. ");
INSERT INTO fin_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Samallahan te tunnustatte olevanne heidän lapsiaan. ");
INSERT INTO fin_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Seuraatte heidän jälkiään ja täytätte heidän pahuutensa mitan. ");
INSERT INTO fin_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Te käärmeet! Miten kuvittelette välttävänne kadotuksen? ");
INSERT INTO fin_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Lähetän teidän luoksenne profeettoja, opettajia ja Pyhän Hengen täyttämiä ihmisiä. Jotkut heistä te ristiinnaulitsette. Toisia ruoskitte synagogissa ja ajatte takaa kaupungista toiseen. ");
INSERT INTO fin_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Teistä tulee syyllisiä kaikkien pyhien ihmisten murhiin Aabelista Sakarjaan, Berekjan poikaan, asti. Hänethän te tapoitte temppelissä uhrialttarin ja temppelin pyhimmän osan välillä. ");
INSERT INTO fin_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Teidän sukupolvenne tuomitaan kaikesta tapahtuneesta. ");
INSERT INTO fin_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Voi sinua, Jerusalem! Sinä tapat profeetat ja kivität kaikki, jotka Jumala lähettää luoksesi. Miten usein olenkaan halunnut koota lapsesi turviini niin kuin kanaemo kokoaa poikasensa siipiensä alle, mutta te ette ole suostuneet tulemaan. ");
INSERT INTO fin_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nyt teidän temppelinne jää autioksi. ");
INSERT INTO fin_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Minua ette näe ennen kuin olette valmiit ottamaan minut vastaan Jumalan lähettämänä.» ");
INSERT INTO fin_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jeesus oli lähdössä temppelialueelta. Hänen oppilaansa halusivat katsella hänen kanssaan temppelin rakennuksia. ");
INSERT INTO fin_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Silloin Jeesus paljasti heille: »Kaikki nämä rakennukset hajotetaan maan tasalle.» ");
INSERT INTO fin_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kun Jeesus myöhemmin istui Öljymäen rinteellä, oppilaat tulivat kysymään, milloin kaikki tapahtuisi. »Millaiset enteet kertovat paluustasi ja maailmanlopusta?» he utelivat. ");
INSERT INTO fin_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jeesus vastasi: »Älkää antako kenenkään johtaa itseänne harhaan. ");
INSERT INTO fin_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Moni sanoo olevansa odotettu Messias, ja ihmiset uskovat sen. ");
INSERT INTO fin_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Saatte kuulla sodista, mutta ne eivät vielä merkitse paluutani. Niiden on ensin tultava: ");
INSERT INTO fin_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","maailman kansat ja valtiot hyökkäävät toisiaan vastaan. Monin paikoin on nälänhätää ja maanjäristyksiä. ");
INSERT INTO fin_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mutta kaikki tämä on vasta uuden aikakauden syntymiseen liittyvien tuskien alkua. ");
INSERT INTO fin_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Teitä kidutetaan ja tapetaan. Koko maailma vihaa teitä siksi, että olette minun omiani. ");
INSERT INTO fin_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Monet lankeavat takaisin syntiin ja alkavat pettää ja vihata muita. ");
INSERT INTO fin_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Väärät profeetat johtavat monia harhaan. ");
INSERT INTO fin_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Synti rehottaa joka puolella ja viilentää useiden rakkauden. ");
INSERT INTO fin_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mutta ne jotka kestävät loppuun asti, pelastuvat. ");
INSERT INTO fin_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hyvää uutista taivaan valtakunnasta julistetaan koko maailmassa. Vasta kun kaikki kansat ovat kuulleet sen, tulee loppu. ");
INSERT INTO fin_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kun pyhässä paikassa tapahtuu Danielin ennustama kauhea asia (hyvä lukija, ole tarkkana! Matt. huom.), ");
INSERT INTO fin_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Juudeassa olevien on paettava vuorille. ");
INSERT INTO fin_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kattotasanteelta ei pidä lähteä sisälle pakkaamaan, vaan suoraan pakoon. ");
INSERT INTO fin_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jos olette pellolla, älkää lähtekö hakemaan kotoa vaatteita. ");
INSERT INTO fin_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sääli niitä, jotka silloin odottavat lasta tai joiden hoidossa on pikkulapsia! ");
INSERT INTO fin_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Rukoilkaa, että pako ei tapahtuisi talvella eikä sapattina. ");
INSERT INTO fin_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sellaista vainoa kuin silloin ei maailmassa ole ollut koskaan aikaisemmin eikä tule sen jälkeen. ");
INSERT INTO fin_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jos niitä päiviä ei lyhennettäisi, koko ihmiskunta tuhoutuisi. Jumala lyhentää niitä valitsemiensa ihmisten tähden. ");
INSERT INTO fin_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Älkää uskoko, jos kuulette, että Messias, Kristus, on nähty jossakin. ");
INSERT INTO fin_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Väärät kristukset ja profeetat tekevät suuria ihmeitäkin. Jos olisi mahdollista, he pettäisivät jopa Jumalan omia. ");
INSERT INTO fin_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Olen nyt varoittanut teitä. ");
INSERT INTO fin_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jos joku kertoo teille, että Kristus on tullut takaisin ja on autiomaassa, älkää erehtykö lähtemään sinne. Älkää myöskään uskoko, jos kuulette huhun, että hän piileskelee jossakin tietyssä paikassa. ");
INSERT INTO fin_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kun palaan, kaikki näkevät sen kuin kirkkaan salamanleimahduksen. ");
INSERT INTO fin_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Raadon luo kokoontuvat korppikotkat. ");
INSERT INTO fin_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Pian tuon vainon jälkeen aurinko pimenee, kuu menettää valonsa ja tähdet näyttävät putoavan taivaalta. Maailmankaikkeutta säätelevät voimat järkkyvät. ");
INSERT INTO fin_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ja lopuksi sitten ilmestyy taivaalle minun tuloni merkki. Koko maailma valittaa surkeasti. Kansat näkevät minun tulevan pilvissä täynnä voimaa ja kirkkautta. ");
INSERT INTO fin_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kuuluu mahtava torventoitotus, ja minä lähetän enkelini maan päälle. He kokoavat valitsemani ihmiset kaikista ilmansuunnista. ");
INSERT INTO fin_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Viikunapuu muistuttaa teitä tärkeästä asiasta: kun siihen alkaa puhjeta lehtiä, on kesä miltei käsillä. ");
INSERT INTO fin_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Samoin, kun näette kaiken tämän alkavan tapahtua, tiedätte, että takaisintuloni on hyvin lähellä. ");
INSERT INTO fin_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tämä sukupolvi elää vielä silloin. ");
INSERT INTO fin_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Taivas ja maa katoavat, mutta minun sanani ovat ikuisia. ");
INSERT INTO fin_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Lopun hetkeä ei muuten tiedä kukaan, eivät enkelitkään – eikä edes Jumalan Poika. Vain Isä tietää sen. ");
INSERT INTO fin_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Maailma on minun palatessani samanlainen kuin Nooan aikaan. ");
INSERT INTO fin_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Ihmiset eivät uskoneet, että vedenpaisumus tulisi. Mistään piittaamatta he viettivät häitään ja juhliaan. Mutta yhtäkkiä alkoi sataa ja ihmiset hukkuivat tulvaan. Minun paluuni on yhtä yllättävä. ");
INSERT INTO fin_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kaksi miestä on silloin yhdessä peltotöissä: toinen heistä otetaan taivaaseen, toinen jää. ");
INSERT INTO fin_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Kaksi naista tekee kotitöitä: toinen otetaan, toinen jää siihen missä on. ");
INSERT INTO fin_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Olkaa valmiita. Ette tiedä, minä päivänä Herranne tulee. ");
INSERT INTO fin_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jos omistaja vartioi taloaan varkailta, he eivät pääse yllättämään häntä. ");
INSERT INTO fin_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Teidänkin on oltava koko ajan varuillanne. Ette voi etukäteen aavistaa tuloani. ");
INSERT INTO fin_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Oletko sinä hyvä ja uskollinen Herran palvelija? Olenko pyytänyt sinua huolehtimaan taloudestani ja antamaan lapsilleni joka päivä ruokaa? ");
INSERT INTO fin_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Siunattu sinä, jonka näen hoitavan uskollisesti tehtäviäsi, kun palaan. ");
INSERT INTO fin_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Annan sinulle silloin vastuun koko omaisuudestani. ");
INSERT INTO fin_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mutta jos olet huono palvelija ja sanot itseksesi: ’Ei isäntä varmaan vielä tule’ ");
INSERT INTO fin_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ja heittäydyt väkivaltaiseksi, alat mässäillä ja pitää juominkeja, sinulle ei käy hyvin. ");
INSERT INTO fin_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Isäntäsi palaa odottamatta. ");
INSERT INTO fin_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Saat yhtä ankaran rangaistuksen kuin teeskentelijät: joudut heidän kanssaan kadotukseen.» ");
INSERT INTO fin_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","»Kertomus kymmenestä morsiusneidosta kuvaa, millainen Jumalan valtakunta on. ");
INSERT INTO fin_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","3-4","He ottivat lamppunsa ja lähtivät sulhasta vastaan, mutta vain viidellä oli järkeä ottaa öljyä sekä lamppuun että vara-astiaan. Muut unohtivat varaöljyn. ");
INSERT INTO fin_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kun sulhasta ei kuulunut, tyttöjä alkoi väsyttää ja he nukahtivat. ");
INSERT INTO fin_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Keskiyöllä he heräsivät huutoon: ’Sulhanen tulee! Tulkaa ottamaan häntä vastaan!’ ");
INSERT INTO fin_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tytöt hyppäsivät pystyyn ja laittoivat lamppunsa kuntoon. ");
INSERT INTO fin_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Silloin ne viisi, jotka olivat unohtaneet varata tarpeeksi öljyä, huomasivat, että heidän lamppunsa pian sammuisivat, ja pyysivät öljyä toisilta. ");
INSERT INTO fin_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nämä vastasivat: ’Ei meillä niin paljon ole. Menkää ostamaan itsellenne lisää.’ ");
INSERT INTO fin_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mutta kun he olivat lähteneet, sulhanen tuli. Ne, jotka olivat valmiina odottamassa, pääsivät hänen kanssaan häihin. Juhlapaikan ovi suljettiin heidän jälkeensä. ");
INSERT INTO fin_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Myöhemmin toiset viisi tyttöä palasivat. He huusivat oven takana: ’Avatkaa meille ovi!’ ");
INSERT INTO fin_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Sulhanen vastasi: ’Tulette liian myöhään, menkää pois!’ ");
INSERT INTO fin_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Olkaa koko ajan valmiina. Ette tiedä, minä hetkenä minä tulen. ");
INSERT INTO fin_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Valaisen asiaa vielä toisella kertomuksella. Eräs mies oli lähdössä ulkomaille. Hän kutsui apulaisensa luokseen ja antoi heidän käyttöönsä rahaa, jotta he sijoittaisivat sen hänen puolestaan. ");
INSERT INTO fin_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Yksi apulaisista sai viisi säkkiä kultaa, toinen kaksi ja kolmas yhden säkillisen. Mies oli tarkkaan harkinnut, miten paljon kullekin kannatti antaa. Sitten hän lähti matkalle. ");
INSERT INTO fin_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Eniten saanut alkoi heti tehdä sijoituksia ja voitti pian toiset viisi kultasäkkiä. ");
INSERT INTO fin_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Se, jolla oli kaksi säkkiä, voitti toiset kaksi. ");
INSERT INTO fin_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mutta se, joka oli saanut yhden säkin kultaa, kaivoi maahan kuopan ja pani rahat sinne talteen. ");
INSERT INTO fin_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Pitkän ajan kuluttua isäntä palasi kotiin. Hän kutsui apulaisensa tekemään rahoista tiliä. ");
INSERT INTO fin_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Viisi säkkiä saanut toi hänelle kymmenen. ");
INSERT INTO fin_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Isäntä kiitteli häntä hyvästä suorituksesta. ’Olet osoittautunut luotettavaksi tämän pienen tehtävän hoitamisessa. Voin nyt antaa sinulle lisää vastuuta’, hän sanoi. ’Sen kunniaksi pidämme juhlan!’ ");
INSERT INTO fin_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Mies, jolla oli ollut kaksi säkkiä kultaa, ilmoitti: ’Minäkin olen voittanut toiset kaksi säkillistä.’ ");
INSERT INTO fin_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","’Hienoa!’ isäntä sanoi. ’Olet ollut uskollinen tämän pienen summan hoitamisessa. Nyt saat lisää töitä.’ ");
INSERT INTO fin_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","25","Mies, joka oli saanut yhden kultasäkin, tuli viimeksi esiin ja selitti: ’Tiesin, että olet kova mies ja pelkäsin, että veisit kuitenkin kaiken, minkä olen ansainnut. Siksi piilotin rahasi maahan. Tässä saat ne takaisin.’ ");
INSERT INTO fin_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Isäntä hurjistui: ’Laiska sinä olet! Kun kerran tiesit, että vaatisin voiton itselleni, ");
INSERT INTO fin_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","olisit edes voinut panna rahat pankkiin kasvamaan korkoa. ");
INSERT INTO fin_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ottakaa tältä rahat ja antakaa ne sille, jolla on jo kymmenen kultasäkkiä. ");
INSERT INTO fin_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Joka käyttää hyvin sen, mitä hänelle on uskottu, saa vielä lisää. Joka taas lyö laimin tehtävänsä, menettää vastuunsa. ");
INSERT INTO fin_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Heittäkää tuo huono apulainen ulos talostani!’ ");
INSERT INTO fin_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Minä, Ihmisen Poika, palaan kerran kuninkaana. Kaikki enkelit ovat kanssani, kun istun taivaan valtaistuimelle. ");
INSERT INTO fin_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Silloin kokoontuvat kaikki kansat eteeni. Erottelen ihmiset niin kuin paimen erottelee lampaat vuohista. ");
INSERT INTO fin_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Lampaiden paikka on oikealla puolellani, vuohien vasemmalla. ");
INSERT INTO fin_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Minä, Kuningas, sanon oikealla puolellani oleville: ’Te Isäni siunaamat! Tulkaa valtakuntaan, joka on odottanut teitä maailman luomisesta asti. ");
INSERT INTO fin_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kun minun oli nälkä, te ruokitte minua. Kun minun oli jano, annoitte minulle vettä. Kun olin teille vieras, avasitte minulle korinne. ");
INSERT INTO fin_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kun minulla ei ollut vaatteita, te annoitte niitä minulle. Kun olin sairaana tai vankilassa, te kävitte minua katsomassa.’ ");
INSERT INTO fin_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","He ihmettelivät: ’Herra, milloin me tapasimme sinut nälkäisenä ja annoimme sinulle ruokaa? Tai janoisena ja annoimme juotavaa? ");
INSERT INTO fin_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tai tuntemattomana, jota autoimme? Tai alastomana, jolle annoimme vaatteet? ");
INSERT INTO fin_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Milloin sinä olit sairas tai vanki, jota kävimme katsomassa?’ ");
INSERT INTO fin_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Minä, Kuningas, vastaan heille: ’Kun autoitte muita ihmisiä, autoitte minua.’ ");
INSERT INTO fin_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Sitten käännyn niihin päin, jotka ovat vasemmalla puolellani, ja sanon: ’Menkää tiehenne, te kirotut! Joudutte ikuiseen tuleen, joka on tarkoitettu saatanalle ja pahoille hengille. ");
INSERT INTO fin_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ette antaneet minulle ruokaa, kun minun oli nälkä. Ette halunneet antaa minulle juotavaa, kun minun oli jano. ");
INSERT INTO fin_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kieltäydyitte majoittamasta minua kotiinne, kun outona etsin yösijaa. Olin alaston, ettekä antaneet minulle vaatteita. Olin sairaana ja vankilassa, mutta ette käyneet luonani.’ ");
INSERT INTO fin_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","He vastasivat: ’Herra, milloin sinä kärsit nälkää ja janoa, olit yksinäinen, vieras, alaston, sairas tai vanki emmekä auttaneet sinua?’ ");
INSERT INTO fin_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Minä vastaan: ’Kun kieltäydyitte auttamasta avuttomia ihmisiä, minä jäin ilman apua.’ ");
INSERT INTO fin_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","He saavat ikuisen rangaistuksen, mutta ne, jotka olivat tehneet oikein, pääsevät ikuiseen elämään.» ");
INSERT INTO fin_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tämän jälkeen Jeesus kertoi oppilailleen: ");
INSERT INTO fin_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","»Kuten tiedätte, pääsiäisjuhlat alkavat kahden päivän kuluttua. Niiden aikana minut kavalletaan ja ristiinnaulitaan.» ");
INSERT INTO fin_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Samalla hetkellä ylipapit ja muut juutalaisten virkamiehet pitivät kokousta ylipappi Kaifaan palatsissa. ");
INSERT INTO fin_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","He neuvottelivat, miten saisivat Jeesuksen raivatuksi tieltään kaikessa hiljaisuudessa. ");
INSERT INTO fin_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","»Paras jättää pyhien yli, ettei synny mellakkaa», he päättivät. ");
INSERT INTO fin_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jeesus lähti Betaniaan ja majoittui lepratautisen Simonin luo. ");
INSERT INTO fin_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Kun hän oli syömässä, sisään astui nainen, jolla oli mukanaan hyvin kallista voidetta. Hän voiteli sillä Jeesuksen pään. ");
INSERT INTO fin_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Oppilaita suututti. »Siinä menivät hyvät rahat hukkaan», he sanoivat. ");
INSERT INTO fin_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","»Hän olisi voinut myydä pullon kalliiseen hintaan ja antaa rahat köyhille.» ");
INSERT INTO fin_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jeesus tiesi, mitä he supisivat ja sanoi: »Miksi arvostelette tätä naista? Hän on tehnyt minulle palveluksen. ");
INSERT INTO fin_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Köyhiä on aina teidän keskellänne, mutta minä en ole aina luonanne. ");
INSERT INTO fin_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tämä nainen valmisti ruumistani hautausta varten, kun hän voiteli pääni. ");
INSERT INTO fin_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hänen tekoaan ei unohdeta koskaan. Koko maailma saa tietää, mitä hän teki. Se muistetaan joka paikassa, missä hyvää uutista kerrotaan.» ");
INSERT INTO fin_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Juudas Iskariot, joka oli yksi Jeesuksen kahdestatoista oppilaasta, meni kysymään ylipapeilta: ");
INSERT INTO fin_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","»Paljonko maksatte, jos järjestän Jeesuksen käsiinne?» He antoivat hänelle kolmekymmentä hopearahaa. ");
INSERT INTO fin_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Juudas alkoi nyt etsiä sopivaa tilaisuutta, jossa voisi antaa Jeesuksen ilmi. ");
INSERT INTO fin_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Alkoi pääsiäisviikko, jonka aikana juutalaiset saivat käyttää vain happamatonta leipää. Ensimmäisenä päivänä oppilaat tulivat kysymään Jeesukselta: »Oletko suunnitellut, missä syömme pääsiäisaterian?» ");
INSERT INTO fin_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jeesus vastasi: »Menkää kaupunkiin sen ja sen luo ja sanokaa hänelle: ’Opettaja sanoo, että hänen aikansa on tullut ja hän syö pääsiäisaterian oppilaidensa kanssa sinun kotonasi.’» ");
INSERT INTO fin_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Oppilaat tekivät niin kuin Jeesus pyysi ja valmistivat aterian. ");
INSERT INTO fin_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Kun Jeesus söi heidän kanssaan illallista, hän sanoi: »Yksi teistä pettää minut.» ");
INSERT INTO fin_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Alakuloisina he alkoivat kysellä vuoron perään: »Minäkö, Herra?» ");
INSERT INTO fin_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jeesus vastasi: »Se joka otti ruokaa yhtä aikaa kuin minä. ");
INSERT INTO fin_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Minun on kuoltava, niin kuin on ennustettu, mutta sääli sitä ihmistä joka antaa minut ilmi. Hänelle olisi parempi, ettei hän olisi syntynytkään.» ");
INSERT INTO fin_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Myös Juudas kysyi: »Opettaja, en kai se ole minä?» Jeesus vastasi: »Sinäpä sen sanoit.» ");
INSERT INTO fin_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Illallisella Jeesus otti leivän, kiitti Jumalaa ja mursi leivästä oppilailleen palaset. »Ottakaa tästä ja syökää. Tämä on minun ruumiini», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Hän otti viinimaljan, kiitti Jumalaa ja antoi jokaisen oppilaansa juoda maljasta. ");
INSERT INTO fin_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","»Tämä on minun vereni, joka sinetöi uuden liiton Jumalan ja ihmisten välillä. Se vuodatetaan, että ihmiset saisivat syntinsä anteeksi. ");
INSERT INTO fin_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Huomatkaa, mitä sanon: seuraavan kerran juon viiniä vasta teidän kanssanne Isäni valtakunnassa. Siellä saamme uutta viiniä.» ");
INSERT INTO fin_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","He lauloivat kiitosvirren ja lähtivät Öljymäelle. ");
INSERT INTO fin_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jeesus paljasti: »Tänä yönä te kaikki jätätte minut. Raamatussa on sanottu, että Jumala lyö paimenta ja lammaslauma hajaantuu. ");
INSERT INTO fin_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kun olen noussut kuolleista, menen Galileaan. Tapaamme siellä.» ");
INSERT INTO fin_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pietari julisti: »Vaikka muut jättäisivät sinut, niin minä en jätä.» ");
INSERT INTO fin_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jeesus vastasi: »Totuus on, että tänä yönä ennen kukonlaulua ehdit kolme kertaa kieltää tuntevasi minut.» ");
INSERT INTO fin_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","»Mieluummin kuolen!» Pietari vakuutti. Niin sanoivat kaikki muutkin oppilaat. ");
INSERT INTO fin_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jeesus lähti heidän kanssaan Getsemanen puutarhaan. Hän pyysi heitä odottamaan sen aikaa, kun hän kävisi vähän kauempana rukoilemassa. ");
INSERT INTO fin_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pietari ja Sebedeuksen pojat Jaakob ja Johannes pääsivät hänen mukaansa. ");
INSERT INTO fin_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jeesus sanoi murheellisena ja tuskissaan: »Minä olen kuolemanhädässä. Pysykää tässä ja valvokaa kanssani.» ");
INSERT INTO fin_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Hän meni vähän matkan päähän, heittäytyi maahan ja rukoili: »Isä! Jos mahdollista, ota minulta pois tämä malja. Haluan kuitenkin, että tapahtuu sinun tahtosi eikä minun.» ");
INSERT INTO fin_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Hän palasi kolmen oppilaansa luo ja huomasi, että he nukkuivat. »Pietari!» hän sanoi. »Ettekö jaksaneet yhtään valvoa kanssani? ");
INSERT INTO fin_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Herätkää rukoilemaan! Muuten kiusaus voittaa teidät. Henki suostuu kyllä Jumalan tahtoon, mutta ruumis on heikko.» ");
INSERT INTO fin_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jeesus palasi taas rukoilemaan: »Isä! Jos minun on juotava tämä malja, olen valmis tekemään niin kuin sinä tahdot.» ");
INSERT INTO fin_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Hän kävi oppilaidensa luona. Uni painoi heidän silmiään, ja he nukkuivat nytkin. ");
INSERT INTO fin_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Kolmannen kerran Jeesus palasi rukoilemaan. Hän toisti saman rukouksen kuin aikaisemmin. ");
INSERT INTO fin_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sitten hän tuli sanomaan oppilailleen: »Te vain nukutte! Mutta nyt on määräaika täyttynyt. Minut annetaan pahojen ihmisten käsiin. ");
INSERT INTO fin_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nouskaa, niin lähdemme! Tuolla ilmiantajani jo onkin.» ");
INSERT INTO fin_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jeesus ei ollut vielä lopettanut lausettaan, kun Juudas tuli heitä kohti. Hänellä oli mukanaan johtavien juutalaisten lähettämä väkijoukko, jolla oli aseina miekkoja ja keppejä. ");
INSERT INTO fin_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Juudas oli sopinut, että hän tervehtisi miestä, joka heidän oli tarkoitus ottaa kiinni. ");
INSERT INTO fin_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Sen vuoksi Juudas tuli suoraan Jeesuksen luo: »Iltaa, opettaja!» hän sanoi ja tervehti Jeesusta suudelmalla. ");
INSERT INTO fin_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jeesus vastasi: »Hyvä ystävä, suorita vain loppuun tehtävä, jota varten tänne tulit.» Silloin miehet ottivat Jeesuksen kiinni. ");
INSERT INTO fin_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yksi Jeesuksen oppilaista veti miekkansa esille ja sivalsi ylipapin palvelijalta korvan. ");
INSERT INTO fin_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","»Pane miekka pois», Jeesus käski. »Ne, jotka käyttävät miekkaa, surmataan. ");
INSERT INTO fin_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ymmärräthän, että voisin pyytää Isältäni tuhansia enkeleitä suojelemaan meitä. Hän lähettäisi ne heti. ");
INSERT INTO fin_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mutta miten silloin osoittautuisivat tosiksi Raamatun sanat, joissa nämä tapahtumat on ennustettu?» ");
INSERT INTO fin_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sitten Jeesus kysyi kansanjoukolta: »Olenko joku vaarallinen rikollinen, kun olette noin aseistautuneina lähteneet pidättämään minua? Minähän olen opettanut temppelissä joka päivä, mutta siellä minua ei ole otettu kiinni. ");
INSERT INTO fin_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Näin piti käydä, että ennustukset toteutuisivat.» Silloin kaikki hänen oppilaansa lähtivät pakoon. ");
INSERT INTO fin_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ihmisjoukko kuljetti Jeesuksen ylipappi Kaifaan taloon. Kaikki juutalaisten johtomiehet olivat kokoontuneet sinne. ");
INSERT INTO fin_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pietari seurasi kaukana joukon jäljessä. Hän tuli ylipapin pihalle asti ja istui sinne palvelijoiden joukkoon nähdäkseen, kuinka Jeesuksen kävisi. ");
INSERT INTO fin_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ylipapit ja itse asiassa koko suuri neuvosto yrittivät löytää miehiä, jotka todistaisivat väärin Jeesusta vastaan, niin että voitaisiin nostaa syyte ja tuomita hänet kuolemaan. ");
INSERT INTO fin_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Heillä olikin useita todistajia, mutta nämä puhuivat keskenään ristiin. Sitten tuli kaksi miestä kertomaan: ");
INSERT INTO fin_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","»Tämä mies on sanonut, että hän pystyy hajottamaan ja rakentamaan uudelleen Jumalan temppelin kolmessa päivässä.» ");
INSERT INTO fin_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ylipappi nousi ja kysyi Jeesukselta: »Pitääkö tämä paikkansa?» ");
INSERT INTO fin_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jeesus ei sanonut mitään. Ylipappi jatkoi: »Vaadin sinua elävän Jumalan nimessä sanomaan, oletko sinä Kristus, Jumalan Poika.» ");
INSERT INTO fin_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","»Minä olen», Jeesus vastasi. »Pian näette minun, Ihmisen Pojan, istuvan Jumalan oikealla puolella ja tulevan takaisin pilvissä.» ");
INSERT INTO fin_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Silloin ylipappi repäisi vaatteensa ja huudahti: »Kuulkaa, millaista jumalanpilkkaa! Mihin me enää tarvitsemme todistajia? ");
INSERT INTO fin_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mitä sanotte?» Läsnäolijat huusivat: »Hänen on kuoltava!» ");
INSERT INTO fin_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","He sylkivät ja löivät Jeesusta kasvoihin ja nauroivat: ");
INSERT INTO fin_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","»No niin, Messias, sanohan kuka meistä iski sinua nyrkillä?» ");
INSERT INTO fin_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pietari istui tällä välin pihalla. Joku apulaistyttö tuli sanomaan hänelle: »Sinäkin olit Jeesuksen kanssa. Tehän olette molemmat galilealaisia.» ");
INSERT INTO fin_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pietari väitti vastaan: »En ymmärrä, mitä oikein tarkoitat», hän murahti. ");
INSERT INTO fin_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Myöhemmin eräs toinen tyttö näki hänet portin luona ja huomautti ympärillään seisoville ihmisille: »Tuokin kulki sen nasaretilaisen kanssa.» ");
INSERT INTO fin_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nyt Pietari väitti kivenkovaa: »En taatusti tunne koko miestä.» ");
INSERT INTO fin_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Hetken kuluttua tulivat pihalla seisoskelleet ihmiset sanomaan hänelle: »Olet varmasti hänen oppilaitaan. Sinähän puhut Galilean murrettakin.» ");
INSERT INTO fin_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pietari kirosi. »En edes tunne koko miestä», hän vannoi. ");
INSERT INTO fin_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Samassa kukko kiekui. Äkkiä Pietari muisti, mitä Jeesus oli sanonut: »Ennen kuin kukko kiekuu, sinä jo kiellät kolme kertaa tuntevasi minua.» Ja Pietari lähti pois katkerasti itkien. ");
INSERT INTO fin_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tuli aamu. Ylipapit ja juutalaisten johtomiehet kokoontuivat neuvottelemaan, miten saisivat Rooman viranomaiset suostumaan Jeesuksen teloitukseen. ");
INSERT INTO fin_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","He lähettivät vankinsa sidottuna maaherra Pilatuksen tutkittavaksi. ");
INSERT INTO fin_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Juudas, joka oli Jeesuksen kavaltanut, huomasi, että Jeesus aiottiin tappaa. Silloin hän katui tekoaan ja vei takaisin ylipapeille rahat, jotka oli heiltä saanut. ");
INSERT INTO fin_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","»Tein syntiä, kun petin syyttömän miehen», hän sanoi. »Omapa on asiasi», he tiuskaisivat takaisin. ");
INSERT INTO fin_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Juudas paiskasi hopearahat temppelin lattialle, lähti pois ja hirttäytyi. ");
INSERT INTO fin_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ylipapit korjasivat rahat talteen ja totesivat: »On lainvastaista panna murhasta maksettuja rahoja temppelirahastoon.» ");
INSERT INTO fin_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","He neuvottelivat asiasta ja päättivät ostaa rahoilla ruukuntekijöiden pellon Jerusalemissa kuolevien ulkomaalaisten hautausmaaksi. ");
INSERT INTO fin_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sitä sanotaan vieläkin »Veripelloksi». ");
INSERT INTO fin_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jeremian ennustus toteutui: »He ottivat kolmekymmentä hopearahaa, jotka olivat arvioineet israelilaisten nimissä tuon miehen hinnaksi, ");
INSERT INTO fin_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ja ostivat niillä savenvalajien pellon niin kuin Herra oli minulle neuvonut.» ");
INSERT INTO fin_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jeesus seisoi nyt maaherra Pilatuksen edessä. »Oletko sinä juutalaisten kuningas?» Pilatus kysyi. »Olen», Jeesus vastasi. ");
INSERT INTO fin_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kun juutalaisten johtomiehet esittivät syytöksiään, Jeesus ei sanonut mitään. ");
INSERT INTO fin_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","»Etkö kuule, mitä he sanovat?» Pilatus tiukkasi. ");
INSERT INTO fin_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mutta Jeesus ei vastannut hänelle. Maaherra oli ihmeissään. ");
INSERT INTO fin_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Maaherran tapana oli vapauttaa pääsiäisjuhlien aikana joku juutalainen vanki. Kansa sai valita, kuka vapautettiin. ");
INSERT INTO fin_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Barabbas-niminen tunnettu rikollinen oli juuri vankilassa. ");
INSERT INTO fin_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Väkeä kerääntyi aamulla sankoin joukoin Pilatuksen talon eteen, ja hän meni kysymään ihmisiltä: »Haluatteko, että vapautan Barabbaan vai Jeesuksen, jota sanotaan Messiaaksi?» ");
INSERT INTO fin_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Hän tiesi varsin hyvin, että juutalaisten johtomiehet olivat pidättäneet Jeesuksen siksi, että kadehtivat hänen kansansuosiotaan. ");
INSERT INTO fin_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Oikeudenkäynnin aikana Pilatus sai vaimoltaan sanan: »Päästä vapaaksi se hyvä mies. Näin viime yönä hänestä kauheaa unta.» ");
INSERT INTO fin_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ylipapit ja kansanjohtajat yllyttivät tällä välin kansaa äänestämään Barabbaan vapauttamisen puolesta heidän mielestään Jeesus piti teloittaa. ");
INSERT INTO fin_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Maaherra kysyi taas: »Kumman päästän vapaaksi?» Nyt ihmiset olivat valmiit huutamaan: »Barabbaan!» ");
INSERT INTO fin_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","»Mitä sitten teen tälle Messiaaksi sanotulle Jeesukselle?» Pilatus kysyi. »Anna naulita ristille!» kuului huuto. ");
INSERT INTO fin_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","»Minkä tähden?» Pilatus vaati saada tietää. »Mitä pahaa hän on tehnyt?» Kansa huusi kiihtyneenä: »Ristille! Ristille!» ");
INSERT INTO fin_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus huomasi, ettei puhumisesta ollut mitään apua. Meteli vain yltyi. Silloin hän pyysi hakemaan vesiastian, pesi kansanjoukon edessä kätensä ja sanoi: »Olen syytön tämän hyvän miehen kuolemaan. Vastuu on teidän!» ");
INSERT INTO fin_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ihmiset huusivat: »Me ja meidän lapsemme kannamme seuraukset hänen kuolemastaan!» ");
INSERT INTO fin_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilatus vapautti Barabbaan. Jeesuksen hän ruoskitti ja antoi roomalaisille sotilaille, joiden piti toimittaa teloitus. ");
INSERT INTO fin_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","He veivät Jeesuksen ensin kasarmialueelle ja kutsuivat kaikki muutkin sotilaat kokoon. ");
INSERT INTO fin_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","He riisuivat Jeesuksen, pukivat hänet tulipunaiseen viittaan, ");
INSERT INTO fin_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","väänsivät hänen päähänsä orjantappuroista kruunun, antoivat hänen käteensä kepin valtikaksi ja polvistuivat pilkaten hänen eteensä. »Terve, juutalaisten kuningas!» he huutelivat. ");
INSERT INTO fin_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Sitten he sylkivät hänen päälleen, sieppasivat hänen kädestään kepin ja löivät häntä sillä päähän. ");
INSERT INTO fin_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lopulta he riisuivat hänet uudelleen ja pukivat hänet taas hänen omiin vaatteisiinsa. ");
INSERT INTO fin_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Sitten he lähtivät panemaan teloitusta täytäntöön. Kyrenestä, Afrikasta, kotoisin oleva Simon-niminen mies tuli heitä matkalla vastaan. Sotilaat pakottivat Simonin kantamaan Jeesuksen ristiä. ");
INSERT INTO fin_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Golgatalla, »Pääkallonmäellä», ");
INSERT INTO fin_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","sotilaat tarjosivat Jeesukselle pahanmakuista viiniä. Hän maistoi sitä, mutta ei halunnut juoda. ");
INSERT INTO fin_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Kun sotilaat olivat naulanneet Jeesuksen ristille, he arpoivat keskenään hänen vaatteensa. ");
INSERT INTO fin_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sitten he istuivat ristin ympärille vartioimaan uhriaan. ");
INSERT INTO fin_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ristiin Jeesuksen pään yläpuolelle oli kirjoitettu selitys: »Tämä on Jeesus, juutalaisten kuningas.» ");
INSERT INTO fin_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Samana aamuna teloitettiin myös kaksi rikollista. Toisen risti oli Jeesuksen oikealla puolella, toisen vasemmalla. ");
INSERT INTO fin_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ohikulkijat pilkkasivat Jeesusta: ");
INSERT INTO fin_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","»Siinä sitä ollaan! Sinähän hajotat ja rakennat temppelin kolmessa päivässä. Jos kerran olet Jumalan poika, tule alas ristiltä.» ");
INSERT INTO fin_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Myös ylipapit ja muut johtomiehet sanoivat pilkallisesti: ");
INSERT INTO fin_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","»Hän auttoi muita, mutta ei pysty auttamaan itseään. Jos olet Israelin kuningas, tule alas sieltä, niin uskomme sinua! ");
INSERT INTO fin_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Hän luotti Jumalaan ja sanoi olevansa Jumalan poika. Osoittakoon Jumala nyt hänen sanansa todeksi ja vapauttakoon hänet.» ");
INSERT INTO fin_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Viereisillä risteillä riippuvat rikolliset ivasivat Jeesusta samalla tavalla kuin muutkin. ");
INSERT INTO fin_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Keskipäivällä koko maa pimeni kolmeksi tunniksi. ");
INSERT INTO fin_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kolmen aikaan Jeesus huusi: »Eli, Eli, lama sabaktani?» Se tarkoittaa: »Jumalani, Jumalani, miksi hylkäsit minut?» ");
INSERT INTO fin_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jotkut paikalla olevista käsittivät huudon väärin ja luulivat Jeesuksen tarkoittavan Eliaa. ");
INSERT INTO fin_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yksi heistä juoksi kastamaan sienen hapanviiniin ja kurkotti sen kepin nenässä Jeesuksen huulille. ");
INSERT INTO fin_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Toiset tuumivat: »Katsotaan nyt, tuleeko Elia pelastamaan hänet.» ");
INSERT INTO fin_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jeesus huusi taas kovalla äänellä ja antoi henkensä. ");
INSERT INTO fin_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ja ajatelkaa: Verho, joka erotti temppelin kaikkein pyhimmän osan muusta, repesi kahtia ylhäältä alas asti. Maa järisi ja kalliot halkeilivat. ");
INSERT INTO fin_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Haudat aukenivat, ja monet Jumalan ihmiset heräsivät eloon. ");
INSERT INTO fin_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Kun Jeesus oli noussut haudastaan, eloon heränneet näyttäytyivät Jerusalemissa monelle. ");
INSERT INTO fin_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Teloituksen toimeenpanneet sotilaat ja upseerit pelästyivät kovasti maanjäristystä ja kaikkea muuta mitä tapahtui. He sanoivat: »Hän oli varmasti Jumalan Poika.» ");
INSERT INTO fin_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Joukko naisia, jotka halusivat palvella Jeesusta, oli tullut hänen mukanaan Galileasta. Nyt he seisoivat etäämpänä seuraamassa tapahtumia. ");
INSERT INTO fin_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Mukana olivat muun muassa Maria Magdaleena, Jaakobin ja Joosefin äiti Maria sekä Sebedeuksen vaimo, Jaakobin ja Johanneksen äiti. ");
INSERT INTO fin_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tuli ilta. Jeesuksen seuraajiin oli kuulunut rikas arimatialainen mies, Joosef. ");
INSERT INTO fin_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Hän meni nyt pyytämään Pilatukselta Jeesuksen ruumista. Pilatus suostui ja käski antaa ruumiin Joosefille. ");
INSERT INTO fin_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joosef kääri sen puhtaaseen liinaan ");
INSERT INTO fin_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ja vei hautaan, jonka oli vasta hakkauttanut itselleen kallioon. Ennen lähtöään hän vieritti haudan suulle suuren kivenjärkäleen. ");
INSERT INTO fin_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Sekä Maria Magdaleena että toinen Maria katselivat, mitä hän teki. ");
INSERT INTO fin_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Seuraavana päivänä oli sapatti. Ylipapit ja fariseukset menivät ");
INSERT INTO fin_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","kertomaan Pilatukselle: »Se valehtelija väitti kerran heräävänsä eloon kolmen päivän kuluttua kuolemastaan. ");
INSERT INTO fin_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pyydämme, että järjestäisit haudalle vartioinnin kolmeksi päiväksi. Muuten Jeesuksen oppilaat voivat käydä salaa hakemassa hänen ruumiinsa ja ruveta levittämään sellaista huhua, että hän on noussut kuolleista. Silloin olisimme entistä vaikeammassa tilanteessa.» ");
INSERT INTO fin_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","»Pyytäkää omaa temppelipoliisianne vartioimaan hautaa mahdollisimman tarkasti», Pilatus sanoi. ");
INSERT INTO fin_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Haudan suuta peittävä kivi sinetöitiin paikoilleen ja haudalle jäi vartio. ");
INSERT INTO fin_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Hyvin aikaisin seuraavana aamuna lähtivät Maria Magdaleena ja toinen Maria katsomaan hautaa. ");
INSERT INTO fin_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Äkkiä tuli raju maanjäristys: taivaasta laskeutui Herran enkeli, joka vieritti haudan suulta kiven ja istui sille. ");
INSERT INTO fin_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Hänen kasvonsa olivat kirkkaat kuin salama ja vaatteensa lumivalkoiset. ");
INSERT INTO fin_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Vartijat vapisivat pelosta ja kaatuivat maahan kuin kuolleet. ");
INSERT INTO fin_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Enkeli sanoi naisille: »Älkää pelätkö! Tiedän, että etsitte Jeesusta, joka naulittiin ristille. ");
INSERT INTO fin_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ei hän ole täällä. Hän on noussut kuolleista niin kuin lupasi. Tulkaa katsomaan paikkaa, jossa hänen ruumiinsa oli… ");
INSERT INTO fin_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Lähtekää nyt nopeasti kertomaan hänen oppilailleen, että hän on noussut kuolleista. Hän aikoo mennä Galileaan ja kohdata heidät siellä. Sanokaa heille tällaiset terveiset.» ");
INSERT INTO fin_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Naiset lähtivät juoksemaan. He olivat säikähtäneet kovasti, mutta sydän ilosta pakahtumaisillaan he nyt kiirehtivät viemään oppilaille enkelin viestiä. ");
INSERT INTO fin_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Sitten yhtäkkiä tuli Jeesus itse heitä vastaan. »Huomenta, ystävät!» hän sanoi. Naiset heittäytyivät maahan hänen eteensä palvomaan häntä. ");
INSERT INTO fin_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jeesus sanoi heille: »Älkää pelätkö! Menkää sanomaan veljilleni, että he lähtisivät Galileaan. Tapaamme siellä.» ");
INSERT INTO fin_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kun naiset olivat matkalla kaupunkiin, jotkut haudan vartijoista menivät kertomaan ylipapeille, mitä oli tapahtunut. ");
INSERT INTO fin_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kaikki juutalaisten kansanjohtajat kutsuttiin koolle. Päätettiin lahjoa vartijat. ");
INSERT INTO fin_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Heidän oli levitettävä tietoa, että he olivat sattuneet kaikki yöllä nukahtamaan ja sillä aikaa Jeesuksen oppilaat olivat käyneet varastamassa hänen ruumiinsa. ");
INSERT INTO fin_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Johtajat lupasivat: »Jos maaherra saa kuulla asiasta, puolustamme teitä ja kaikki menee hyvin.» ");
INSERT INTO fin_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Vartijat saivat rahaa ja sanoivat ihmisille niin kuin oli käsketty. Huhu levisi nopeasti, ja juutalaiset uskovat siihen vieläkin. ");
INSERT INTO fin_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jeesuksen yksitoista oppilasta lähtivät Galileaan. He nousivat vuorelle, jolle Jeesus oli käskenyt heidän mennä. ");
INSERT INTO fin_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Siellä he näkivät hänet ja palvoivat häntä. Jotkut heistä eivät kuitenkaan uskoneet, että siinä todella oli Jeesus. ");
INSERT INTO fin_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Hän sanoi oppilailleen: »Minulle on annettu kaikki valta sekä taivaassa että tässä maailmassa. ");
INSERT INTO fin_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Menkää ja kutsukaa ihmisiä kaikista kansoista minun oppilaikseni. Kastakaa heidät Isän, Pojan ja Pyhän Hengen nimeen. ");
INSERT INTO fin_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Opettakaa heitä noudattamaan kaikkia käskyjä, jotka olen antanut teille. Saatte olla varmat, että minä olen teidän kanssanne aina – maailmanajan täyttymykseen asti.»");
INSERT INTO fin_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Näin alkaa ihmeellinen kuvaus Jeesuksesta, Jumalan Pojasta. ");
INSERT INTO fin_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Profeetta Jesajan kirjassa Jumala ilmoitti, että ensin tulisi erikoislähetti valmistamaan maailmaa Jeesuksen tuloon: ");
INSERT INTO fin_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","»Tuo lähetti asuu karussa autiomaassa ja julistaa, että jokaisen on valmistauduttava Herran saapumiseen.» ");
INSERT INTO fin_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tämä lähetti oli Johannes Kastaja. Hän eli autiomaassa ja julisti: »Luopukaa synnistä ja ottakaa kaste, niin Jumala antaa teille synnit anteeksi.» ");
INSERT INTO fin_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ihmisiä tuli Jerusalemista ja kaikkialta sen ympäristöstä Juudean autiomaahan Johannesta katsomaan ja kuulemaan. Kun he olivat tunnustaneet syntinsä, Johannes kastoi heidät Jordanissa. ");
INSERT INTO fin_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johanneksen vaatteet olivat kamelinkarvasta kudotut ja hänellä oli nahkavyö vyötäisillään. Ruuakseen hän söi heinäsirkkoja ja hunajaa. ");
INSERT INTO fin_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Tässä on esimerkki hänen julistustavastaan: »Pian tulee toinen, minua paljon suurempi – minusta ei ole edes hänen orjakseen. ");
INSERT INTO fin_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Minä kastan teidät vedellä, mutta hän kastaa teidät Jumalan Pyhällä Hengellä». ");
INSERT INTO fin_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Eräänä päivänä Jeesus tuli Galilean Nasaretista, ja Johannes kastoi hänet Jordanissa. ");
INSERT INTO fin_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Sinä hetkenä, jona Jeesus nousi vedestä, Johannes näki taivaan avoimena ja Pyhän Hengen laskeutuvan Jeesuksen ylle kuin kyyhkynen. ");
INSERT INTO fin_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Taivaasta kuului ääni: »Sinä olet minun rakas Poikani, jonka minä olen valinnut Pelastajaksi.» ");
INSERT INTO fin_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Heti sen jälkeen Pyhä Henki kehotti Jeesusta menemään autiomaahan. ");
INSERT INTO fin_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Siellä hän oli neljäkymmentä vuorokautta yksin – vain autiomaan eläimet seuranaan. Tuona aikana saatana yritti saada hänet lankeamaan syntiin. Myöhemmin tuli enkeleitä palvelemaan häntä. ");
INSERT INTO fin_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Vähän tämän jälkeen, kun kuningas Herodes oli jo vangituttanut Johanneksen, Jeesus meni Galileaan julistamaan Jumalan ilosanomaa: ");
INSERT INTO fin_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","»Lopultakin aika on tullut! Jumalan valtakunta on lähellä. Jättäkää syntinen elämänne ja uskokaa tämä ilosanoma.» ");
INSERT INTO fin_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kun Jeesus eräänä päivänä käveli Galilean järven rannalla, hän näki kaksi ammattikalastajaa, Simonin ja tämän veljen Andreaan, verkkoineen kalastuspuuhissa. ");
INSERT INTO fin_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jeesus huusi heille: »Tulkaa minun mukaani, niin minä teen teistä ihmisten kalastajia!» ");
INSERT INTO fin_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Heti Pietari ja Andreas jättivät verkkonsa ja lähtivät Jeesuksen mukaan. ");
INSERT INTO fin_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Vähän etäämmällä Jeesus näki Sebedeuksen pojat Jaakobin ja Johanneksen veneessä paikkaamassa verkkoja. ");
INSERT INTO fin_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Hän kutsui heitäkin. Miehet nousivat heti maihin. Heidän isänsä Sebedeus ja tämän palkkaamat kalastajat jäivät veneeseen. ");
INSERT INTO fin_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jeesus ja hänen seuralaisensa saapuivat sitten Kapernaumin kaupunkiin. Juutalaisten pyhäpäivänä, sapattina, he menivät synagogaan jumalanpalvelukseen, ja Jeesus saarnasi siellä. ");
INSERT INTO fin_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Seurakunta hämmästeli hänen saarnaansa, koska hän puhui kuin asiantuntija yrittämättä todistella väitteitään toisilta lainaamillaan ajatuksilla. Tällaista ei ollut totuttu kuulemaan. ");
INSERT INTO fin_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Siinä joukossa oli eräs demonin vallassa oleva mies, joka alkoi huutaa: ");
INSERT INTO fin_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","»Mitä sinä meitä häiritset, Nasaretin Jeesus – oletko tullut tuhoamaan meidät? Kyllä minä sinut tunnen – sinä olet Jumalan pyhä Poika!» ");
INSERT INTO fin_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jeesus käski pahan hengen heti vaieta ja tulla ulos miehestä. ");
INSERT INTO fin_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Silloin demoni huusi, kouristi miestä voimakkaasti ja lähti hänestä. ");
INSERT INTO fin_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Katselijat, jotka olivat seisseet hämmästyksestä mykkinä, alkoivat kysellä: »Mikä uusi uskonto tämä oikein on? Pahat hengetkin tottelevat hänen käskyjään!» ");
INSERT INTO fin_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Koko Galilean alueelle levisi nopeasti uutinen siitä, mitä Jeesus oli tehnyt. ");
INSERT INTO fin_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Synagogasta lähdettyään Jeesus ja hänen oppilaansa menivät Simonin ja Andreaan kotiin. ");
INSERT INTO fin_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simonin anoppi oli sairastunut korkeaan kuumeeseen, ja se kerrottiin heti Jeesukselle. ");
INSERT INTO fin_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jeesus meni sairasvuoteen luo, ja kun hän tarttui potilaan käteen ja auttoi hänet istumaan, kuume yhtäkkiä hävisi. Sairas nousi vuoteesta ja alkoi valmistaa miehille syötävää. ");
INSERT INTO fin_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Auringonlaskun jälkeen koko piha oli täynnä sairaita ja demonien vallassa olevia ihmisiä, joita tuotiin sinne Jeesuksen parannettavaksi. ");
INSERT INTO fin_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Suuri joukko Kapernaumin asukkaita kerääntyi oven ulkopuolelle katsomaan mitä tapahtuisi. ");
INSERT INTO fin_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jeesus paransi tuona iltana paljon sairaita ja vapautti monia demonien vallasta. Mutta hän kielsi demoneja puhumasta, koska ne tiesivät, kuka hän oli. ");
INSERT INTO fin_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Seuraavana aamuna Jeesus oli ylhäällä jo ennen auringonnousua; hän meni syrjäiseen paikkaan rukoilemaan yksin. ");
INSERT INTO fin_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Myöhemmin Simon ja muut menivät hakemaan häntä. ");
INSERT INTO fin_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Löydettyään hänet he sanoivat: »Kaikki kyselevät sinua.» ");
INSERT INTO fin_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jeesus vastasi: »Meidän täytyy jatkaa matkaamme muihin kaupunkeihin. Haluan puhua niissäkin, sillä sen vuoksi olen tullut.» ");
INSERT INTO fin_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Hän kulki Galilean maakunnan halki, puhui synagogissa ja vapautti monia ihmisiä demonien vallasta. ");
INSERT INTO fin_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kerran eräs lepratautinen mies polvistui Jeesuksen eteen ja kerjäsi Jeesusta parantamaan hänet. »Jos tahdot, sinä voit tehdä minut terveeksi», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jeesuksen tuli miestä sääli, hän kosketti tätä ja sanoi: »Minä tahdon. Tule terveeksi!» ");
INSERT INTO fin_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Siinä silmänräpäyksessä lepra hävisi miehestä ja hän oli terve. ");
INSERT INTO fin_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jeesus sanoi sitten hänelle vakavasti: ");
INSERT INTO fin_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","»Mene heti juutalaisen papin luo ja anna hänen tarkastaa itsesi. Älä pysähdy matkalla puhumaan kenenkään kanssa. Ota mukaasi Mooseksen määräämä uhrilahja, joka annetaan leprasta parannuttaessa. Näin kaikki saavat todisteen siitä, että olet parantunut.» ");
INSERT INTO fin_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mies lähti ja alkoi heti kertoa kaikille ihmeellisestä parantumisestaan. Sen seurauksena Jeesuksen ympärillä oli pian sellainen joukko ihmisiä, ettei hän voinut enää mennä julkisesti kaupunkeihin, vaan hänen oli pysyteltävä asumattomilla seuduilla. Mutta sinnekin tuli kaikkialta ihmisiä hänen luokseen. ");
INSERT INTO fin_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Muutaman päivän päästä Jeesus palasi Kapernaumiin, ja uutinen hänen tulostaan levisi nopeasti koko kaupunkiin. ");
INSERT INTO fin_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pian talo, johon hänet oli majoitettu, oli tupaten täynnä väkeä, niin ettei yhtään ihmistä mahtunut enää sisälle, eikä oven ulkopuolellakaan ollut tilaa. Hän julisti heille Jumalan sanaa. ");
INSERT INTO fin_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pihalle tuli neljä miestä, jotka kantoivat halvaantunutta. ");
INSERT INTO fin_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kantajat eivät päässeet Jeesuksen luo väkijoukon läpi. Silloin he tekivät savikattoon aukon sille kohtaa, missä Jeesus oli, ja laskivat sairaan makuumaton avulla suoraan Jeesuksen eteen. ");
INSERT INTO fin_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Kun Jeesus näki, miten lujasti he uskoivat, että hän auttaisi heidän ystäväänsä, hän sanoi sairaalle: »Poikani, saat syntisi anteeksi.» ");
INSERT INTO fin_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ihmisjoukossa oli myös muutamia juutalaisten lainopettajia, jotka kyselivät mielessään: ");
INSERT INTO fin_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","»Mitä? Tämähän on jumalanpilkkaa! Luuleeko hän olevansa Jumala? Vain Jumala voi antaa anteeksi syntejä.» ");
INSERT INTO fin_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jeesus tiesi heidän ajatuksensa ja sanoi heille: »Miksi tämä kiusaa teitä? ");
INSERT INTO fin_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Onko mielestänne vaikeampaa antaa tämän miehen synnit anteeksi kuin parantaa hänet? ");
INSERT INTO fin_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Minulla, joka olen tullut taivaasta, on toki valta antaa hänen syntinsä anteeksi.» Osoittaakseen sanansa oikeiksi Jeesus kääntyi halvaantuneeseen päin ja sanoi: ");
INSERT INTO fin_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","»Sinä olet nyt terve. Ota matto mukaasi ja mene kotiin.» ");
INSERT INTO fin_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mies ponnahti pystyyn, tarttui makuumattoonsa ja harppoi mykistyneen katselijajoukon halki ovelle. »Mitään tällaista emme ole koskaan nähneet», kaikki totesivat ja ylistivät Jumalaa. ");
INSERT INTO fin_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jeesus meni sen jälkeen taas järven rantaan ja puhui ympärilleen kerääntyneelle ihmisjoukolle. ");
INSERT INTO fin_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kun hän käveli rannalla, hän näki Leevin, Alfeuksen pojan, istumassa omalla paikallaan tulliasemalla. »Tule minun mukaani», Jeesus sanoi hänelle, »tule minun oppilaakseni!» Ja Leevi lähti saman tien Jeesuksen mukaan. ");
INSERT INTO fin_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sinä iltana Leevi kutsui kotiinsa päivälliselle työtoverinsa ja muita syntisestä elämästään tunnettuja ihmisiä, jotta nämä saisivat tutustua Jeesukseen ja hänen oppilaihinsa. (Siinä joukossa, joka seurasi Jeesusta, oli useitakin huonomaineisia ihmisiä.) ");
INSERT INTO fin_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mutta kun muutamat fariseusten ryhmään kuuluvat lainopettajat näkivät hänet syömässä näiden ihmisten kanssa, he sanoivat Jeesuksen oppilaille: »Kuinka hän viitsii seurustella tuollaisen roskajoukon kanssa?» ");
INSERT INTO fin_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kun Jeesus kuuli, mitä he puhuivat, hän sanoi heille: »Sairaathan lääkäriä tarvitsevat eivätkä terveet! En minä olekaan tullut kutsumaan uuteen elämään hyviä ihmisiä vaan syntisiä.» ");
INSERT INTO fin_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Johanneksen oppilailla ja fariseuksilla oli tapana uskontonsa vaatimusten mukaan välillä paastota. Eräänä päivänä tultiin Jeesukselta kysymään, miksi hänen oppilaansa eivät paastonneet. ");
INSERT INTO fin_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jeesus vastasi: »Kieltäytyvätkö sulhasen ystävät syömästä häissä? Pitäisikö heidän olla murheissaan, vaikka hän on heidän kanssaan? ");
INSERT INTO fin_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tulee päivä, jolloin hänet otetaan pois heidän joukostaan, ja silloin he paastoavat. ");
INSERT INTO fin_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ei vanhaan vaatteeseen ommella kutistamattomasta kankaasta leikattua paikkaa. Uusi paikkahan repii vanhan kankaan, ja reiästä tulee vain entistä pahempi. ");
INSERT INTO fin_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ei myöskään uutta viiniä panna vanhoihin nahkaleileihin, sillä silloinhan ne halkeavat, viini vuotaa maahan ja leilit menevät pilalle. Uusi viini tarvitsee uudet nahkaleilit.» ");
INSERT INTO fin_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Eräänä sapattina, kun Jeesus ja hänen oppilaansa kävelivät peltoa pitkin, Jeesuksen oppilaat katkoivat viljantähkiä ja söivät niistä jyvät. ");
INSERT INTO fin_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Fariseukset sanoivat Jeesukselle: »Katso nyt, mitä he tekevät! Lain mukaan se on sapattina kiellettyä.» ");
INSERT INTO fin_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jeesus vastasi: »Mutta olettehan kuulleet siitä, kuinka kuningas Daavid ja hänen seurueensa olivat nälissään ");
INSERT INTO fin_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ja menivät Jumalan huoneeseen – Abjatar oli silloin ylipappina – ja söivät ne uhrileivät, joita vain pappien oli lupa syödä. Sekin oli lain rikkomista. ");
INSERT INTO fin_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sapatti on tarkoitettu ihmistä varten eikä päinvastoin! ");
INSERT INTO fin_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Minulla, joka olen tullut taivaasta, on valta päättää siitäkin, mitä ihminen saa sapattina tehdä!» ");
INSERT INTO fin_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kapernaumissa ollessaan Jeesus meni taas synagogaan. Hän näki siellä miehen, jonka toinen käsi oli halvaantunut. ");
INSERT INTO fin_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Koska oli sapatti, Jeesuksen vastutajat seurasivat tarkasti hänen liikkeitään. Parantaisiko hän miehen käden? Jos hän sen tekisi, he nostaisivat syytteen häntä vastaan. ");
INSERT INTO fin_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jeesus pyysi miestä tulemaan seurakunnan eteen. ");
INSERT INTO fin_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sitten hän kääntyi niihin päin, jotka vihasivat häntä, ja kysyi: »Onko hyvän tekeminen sallittua sapattina? Vai pahaako silloin pitäisi tehdä? Onko tämä päivä annettu meille elämän pelastamista vai tuhoamista varten?» Kukaan ei vastannut. ");
INSERT INTO fin_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jeesus katsoi tuimasti ympärilleen, sillä hän oli pahoillaan nähdessään, miten vähän he välittivät ihmisen hädästä. Jeesus sanoi miehelle: »Ojenna kätesi!» Mies teki niin, ja hetkessä hänen kätensä tuli terveeksi. ");
INSERT INTO fin_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseukset lähtivät kiireesti ulos ja kokoontuivat yhdessä herodilaisten kanssa suunnittelemaan Jeesuksen surmaamista. ");
INSERT INTO fin_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sillä aikaa Jeesus ja hänen oppilaansa olivat menneet järvenrantaan. Heitä seurasi suuri ihmisjoukko. Kuulijoita oli tullut kaikkialta Galileasta, Juudeasta, ");
INSERT INTO fin_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalemista, Idumeasta, Jordanin itäpuolelta ja jopa Tyyrosta ja Siidonista saakka. Uutinen Jeesuksen tekemistä ihmeistä oli kiirinyt kaikkialle, ja ihmiset tulivat nyt nähdäkseen hänet omin silmin. ");
INSERT INTO fin_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jeesus neuvoi oppilaitaan pitämään varalla venettä, johon hän voisi vetäytyä, jos rannalla tungeksiva ihmisjoukko alkaisi liiaksi ahdistaa häntä. ");
INSERT INTO fin_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Hän oli tehnyt tuona päivänä monta parantamisihmettä, ja siksi suuri joukko sairaita pyrki häntä lähelle voidakseen edes koskettaa häntä. ");
INSERT INTO fin_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ja kun pahan hengen vallassa olevat saivat hänet näkyviinsä, he kaatuivat maahan Jeesuksen eteen ja alkoivat huutaa: »Sinä olet Jumalan Poika!» ");
INSERT INTO fin_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Mutta Jeesus varoitti ankarasti heitä paljastamasta häntä. ");
INSERT INTO fin_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Myöhemmin Jeesus meni vuorille. Muutamia seurassaan olevia miehiä hän pyysi tulemaan perässä. ");
INSERT INTO fin_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Hän valitsi heistä kaksitoista vakituisiksi seuralaisikseen – julistamaan Jumalan hyvää uutista ");
INSERT INTO fin_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ja vapauttamaan ihmisiä demonien vallasta. ");
INSERT INTO fin_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ne kaksitoista olivat: Simon (jolle hän antoi nimen Pietari), ");
INSERT INTO fin_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jaakob ja Johannes (Sebedeuksen pojat, joita hän kutsui »Ukkosenjylinän pojiksi»), ");
INSERT INTO fin_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filippus, Bartolomeus, Matteus, Tuomas, Jaakob (Alfeuksen poika), Taddeus, Simon (vastarintaliikkeen jäsen, joka ajoi Rooman hallituksen väkivaltaista kumoamista) ");
INSERT INTO fin_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ja Juudas Iskariot (joka myöhemmin kavalsi Jeesuksen). ");
INSERT INTO fin_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Kun Jeesus palasi majapaikkaansa, ihmisjoukko alkoi jälleen kokoontua. Pian avunpyytäjiä oli niin paljon, ettei hänellä ollut aikaa edes syödä. ");
INSERT INTO fin_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Kun hänen omaisensa kuulivat tästä kaikesta, he lähtivät hakemaan häntä kotiin. »Hänhän on aivan järjiltään», he sanoivat. ");
INSERT INTO fin_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mutta juutalaiset lainopettajat, jotka olivat saapuneet paikalle Jerusalemista, sanoivat: »Tuo mies on saatanan vallassa, ja sen vuoksi pahat henkivallat häntä tottelevat.» ");
INSERT INTO fin_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jeesus kutsui miehet luokseen ja kysyi heiltä käyttäen kaikille tuttuja vertauksia: »Kuinka saatana voi ajaa ulos saatanan? ");
INSERT INTO fin_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Sellainen valtakunta, joka riitaantuu itsensä kanssa, sortuu. ");
INSERT INTO fin_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Koti, joka on täynnä riitaa ja eripuraisuutta, tuhoaa itsensä. ");
INSERT INTO fin_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ja jos saatana taistelee itseään vastaan, kuinka hän voi saada mitään aikaan, kuinka hän voi jäädä eloonkaan? ");
INSERT INTO fin_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Voimakas mies täytyy sitoa, ennen kuin hänen taloonsa voidaan tunkeutua ryöstämään hänen omaisuuttaan. ");
INSERT INTO fin_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Totta totisesti: minkä tahansa muun synnin voi saada anteeksi, vieläpä kaikkinaisen rienaamisenkin, ");
INSERT INTO fin_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","mutta Pyhän Hengen pilkkaa ei koskaan anneta anteeksi. Se pysyy ikuisesti syntinä.» ");
INSERT INTO fin_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Hän puhui heille näin, koska he olivat sanoneet, että hän teki ihmeensä saatanan voimalla – sen sijaan, että olisivat tunnustaneet hänen tekevän ne Pyhän Hengen voimalla. ");
INSERT INTO fin_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jeesuksen äiti ja veljet tulivat tuon ihmisiä täynnä olevan talon luo, jossa hän opetti. He lähettivät hänelle sanan, että hän tulisi ulos puhumaan heidän kanssaan. ");
INSERT INTO fin_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","»Äitisi ja veljesi ovat ulkona, ja heillä on sinulle asiaa», hänelle ilmoitettiin. ");
INSERT INTO fin_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jeesus vastasi: »Kuka on minun äitini? Ketkä ovat minun veljiäni?» ");
INSERT INTO fin_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ympärillään olevia katsellen Jeesus sanoi: »Nämä ovat minun äitini ja veljeni! ");
INSERT INTO fin_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Jokainen, joka toimii Jumalan tahdon mukaan, on minun veljeni, sisareni ja äitini.» ");
INSERT INTO fin_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Kerran taas kokoontui valtava ihmisjoukko Jeesuksen ympärille, kun hän opetti järven rannalla. Hän meni silloin istumaan veneeseen ja puhui sieltä. ");
INSERT INTO fin_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Hänen tavallisin opetusmenetelmänsä oli vertausten kertominen. Yksi niistä oli tällainen: ");
INSERT INTO fin_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","»Kuulkaa! Eräs maanviljelijä lähti kylvämään. ");
INSERT INTO fin_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Hänen heittäessään jyviä peltoon niitä putosi myös polulle, josta linnut nokkivat ne pois. ");
INSERT INTO fin_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Osa jyvistä putosi ohueen multakerrokseen, jonka alla oli kallio. Siinä ne kyllä alkoivat nopeasti itää, mutta pian oraat lakastuivat kuumassa auringossa ja kuolivat, sillä juurilla ei ollut siinä kylliksi ravintoa. ");
INSERT INTO fin_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jyviä putosi myös orjantappuroihin, jotka tukahduttivat nuoret taimet, eivätkä ne tuottaneet satoa. ");
INSERT INTO fin_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Osa jyvistä putosi sentään hyvään maahan, jossa niistä kasvoi kolmekymmentä kertaa niin paljon jyviä kuin oli kylvetty – toisista jopa kuusikymmen- tai satakertainen määrä! ");
INSERT INTO fin_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jos teillä on korvat, niin kuunnelkaa!» ");
INSERT INTO fin_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Myöhemmin, kun Jeesus oli yksin niiden kahdentoista ja muiden oppilaidensa kanssa, oppilaat kysyivät häneltä: »Mitä kertomuksesi tarkoittaa?» ");
INSERT INTO fin_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jeesus vastasi: »Te saatte tietää Jumalan valtakunnan totuuksia – sellaisiakin, jotka ovat salassa ulkopuolella olevilta. ");
INSERT INTO fin_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Profeetta Jesaja sanookin: ’Vaikka he näkevät ja kuulevat, he eivät ymmärrä, eivät käänny Jumalaa kohti eivätkä saa syntejään anteeksi.’ ");
INSERT INTO fin_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jos te ette pysty käsittämään tätä yksinkertaista vertausta, niin miten te sitten ymmärrätte kaikki ne muut vertaukset, jotka olen aikonut teille kertoa? ");
INSERT INTO fin_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Maanviljelijä, josta puhuin, on kuka tahansa ihminen, joka vie sanomaa Jumalasta toisille ja yrittää tällä tavalla kylvää heidän elämäänsä hyvää siementä. ");
INSERT INTO fin_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kovaksi tallattu polku, johon osa siemenistä putosi, kuvaa sanankuulijoita, jotka kiusaaja saa heti unohtamaan kuulemansa. ");
INSERT INTO fin_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Kallioinen maa vastaa niitä ihmissydämiä, jotka kyllä mielellään kuuntelevat sanomaa, mutta joiden käy kuin taimien ohuessa multakerroksessa – niiden juuret eivät kasva syvälle, ja vaikka ne näyttävät pääsevän hyvään alkuun, ne kuihtuvat heti vaikeuksien tullessa. ");
INSERT INTO fin_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Orjantappuroita kasvava maa taas kuvaa sellaisia ihmisiä, jotka kuulevat hyvän uutisen ja ottavat sen vastaan, ");
INSERT INTO fin_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mutta joita maailma alkaa pian viehättää enemmän. Rikkauden tuomien ilojen ja menestyksen tavoittelu sekä mukavuudenrakkaus täyttävät heidän sydämensä ja tukahduttavat sanoman Jumalasta, niin että siemen ei tuota satoa. ");
INSERT INTO fin_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Hyvä maa on kuva niiden sydämestä, jotka todella ottavat sanoman omakseen ja tuottavat Jumalalle runsaan sadon – kolmekymmentä, kuusikymmentä tai jopa satakin kertaa sen määrän, joka heidän omaan sydämeensä kylvettiin.» ");
INSERT INTO fin_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sitten Jeesus kysyi heiltä: »Kun lamppu on sytytetty, pannaanko se laatikon tai vuoteen alle? Eipä tietenkään! Silloinhan valosta ei olisi mitään hyötyä. Lamppu pannaan näkyviin, niin että sen valo saa vapaasti loistaa. ");
INSERT INTO fin_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kaikki, mikä on nyt salassa, tulee vielä kerran valoon. ");
INSERT INTO fin_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kun teillä kerran on korvat, niin kuunnelkaa! ");
INSERT INTO fin_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Toteuttakaa myös se, mitä kuulette. Saatte takaisin saman verran kuin annatte, ja enemmänkin. ");
INSERT INTO fin_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sillä sille, jolla on, annetaan lisää ja siltä, jolla ei ole, otetaan pois sekin vähä, mikä hänellä on. ");
INSERT INTO fin_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jumalan valtakuntaa kuvaa myös seuraava vertaus: Eräs maanviljelijä kylvi peltonsa. ");
INSERT INTO fin_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","28","Siemenet alkoivat itsestään kasvaa maassa. Ensin nousivat oraat, sitten muodostuivat tähkät korsiin ja lopulta kypsyivät jyvät. ");
INSERT INTO fin_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Silloin tuli maanviljelijä sirppeineen ja korjasi sadon.» ");
INSERT INTO fin_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ja Jeesus jatkoi: »Kuinka vielä voisin kuvata Jumalan valtakuntaa? Mitä vertausta käyttäisin? ");
INSERT INTO fin_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jumalan valtakunta on kuin pienen pieni sinapinsiemen. Vaikka se on kaikkein pienimpiä siemeniä, ");
INSERT INTO fin_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","siitä kuitenkin kasvaa yksi suurimpia pensaskasveja, jonka tukeville oksille linnut voivat rakentaa pesänsä.» ");
INSERT INTO fin_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jeesus käytti monia tällaisia vertauksia opettaessaan ihmisille sen mukaan kuin he kykenivät ymmärtämään. ");
INSERT INTO fin_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Itse asiassa hän käytti julkisessa opetuksessaan pelkästään vertauksia, ja sitten jälkeenpäin, kun hän oli yksin oppilaidensa kanssa, hänellä oli tapana selittää heille, mitä hän oli vertauksilla tarkoittanut. ");
INSERT INTO fin_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kun oli tullut ilta, Jeesus sanoi oppilailleen: »Soudetaanpa järven toiselle rannalle.» ");
INSERT INTO fin_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Niin he lähtivät sieltä veneellä, ja kansanjoukko jäi rantaan. (Joitakin veneitä tosin tuli heidän perässään.) ");
INSERT INTO fin_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pian nousi kuitenkin kova myrsky. Korkeat aallot pärskivät veneeseen, ja kun se oli melkein täynnä vettä, se alkoi upota. ");
INSERT INTO fin_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jeesus nukkui veneen perässä pää tyynyllä. Pelosta suunniltaan joutuneet miehet herättivät hänet huutaen: »Etkö ollenkaan piittaa siitä, että me kohta hukumme?» ");
INSERT INTO fin_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Silloin Jeesus moitti tuulta ja sanoi järvelle: »Tyynny!» Heti lakkasi tuulemasta ja tuli aivan tyyni. ");
INSERT INTO fin_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jeesus kysyi oppilailtaan: »Miksi te pelkäsitte niin kovasti? Ettekö vieläkään luota minuun?» ");
INSERT INTO fin_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Heidät täytti pelko ja kunnioitus, ja he sanoivat toisilleen: »Kuka tämä mies oikein on, kun jopa tuulet ja vedet tottelevat häntä?» ");
INSERT INTO fin_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Kun Jeesus ja oppilaat saapuivat järven toiselle rannalle, gerasalaisten alueelle, ");
INSERT INTO fin_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","eräs demonien vallassa oleva mies syöksyi hautausmaalta juuri, kun Jeesus oli nousemassa maihin. ");
INSERT INTO fin_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Mies asui hautakammioissa, ja hän oli niin vahva, että joka kerta kun hänet pantiin käsirautoihin ja kahleisiin, hän rikkoi käsiraudat, katkaisi kahleensa ja juoksi pakoon. Kukaan ei mahtanut hänelle mitään. ");
INSERT INTO fin_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yötä päivää hän kuljeksi haudoilla tai autioilla vuorilla ja viilteli itseään terävillä kivillä. ");
INSERT INTO fin_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mies oli nähnyt Jeesuksen, kun tämä oli ollut vielä kaukana järven selällä, ja juoksi nyt häntä vastaan. Hän heittäytyi maahan Jeesuksen eteen. ");
INSERT INTO fin_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jeesus oli juuri käskemäisillään pahaa henkeä lähtemään miehestä, kun se parahti: »Mitä sinä aiot tehdä minulle, Jeesus, kaikkein korkeimman Jumalan Poika? Jumalan tähden, älä kiduta minua!» ");
INSERT INTO fin_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","»Mikä sinun nimesi on?» Jeesus kysyi, ja demoni vastasi: »Legioona, sillä meitä on monta tässä miehessä.» ");
INSERT INTO fin_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Sitten pahat henget kerjäämällä kerjäsivät, ettei Jeesus lähettäisi niitä mihinkään kaukaiseen maahan. ");
INSERT INTO fin_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Suuri sikalauma sattui olemaan tonkimassa läheisen kukkulan rinteellä. ");
INSERT INTO fin_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","»Lähetä meidät noihin sikoihin», demonit pyysivät, ");
INSERT INTO fin_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ja Jeesus teki niin. Pahat henget lähtivät miehestä ja menivät sikoihin. Silloin koko sikalauma syöksyi alas jyrkkää rinnettä ja hukkui järveen. ");
INSERT INTO fin_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sikopaimenet juoksivat pakoon läheisiin kaupunkeihin ja maaseudulle ja levittivät uutista tapahtuneesta. Kaikki kiirehtivät katsomaan, ja pian oli suuri joukko ihmisiä kerääntynyt sinne, missä Jeesus oli. ");
INSERT INTO fin_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mutta kun ihmiset näkivät demonien vallassa olleen miehen istumassa täysissä pukeissa ja järjissään, heitä alkoi pelottaa. ");
INSERT INTO fin_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ne, jotka olivat nähneet tapahtuneen, kertoivat siitä parhaillaan. ");
INSERT INTO fin_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kansanjoukko alkoi pyytää Jeesusta menemään pois ja jättämään heidät rauhaan. ");
INSERT INTO fin_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Sen vuoksi Jeesus meni takaisin veneeseen. Demonien vallassa ollut mies kerjäsi Jeesusta ottamaan hänet mukaansa. ");
INSERT INTO fin_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mutta Jeesus sanoi: »Ei! Mene kotiin omaistesi luo ja kerro heille, miten ihmeellisiä tekoja Jumala on tehnyt sinulle ja kuinka hän on armahtanut sinut.» ");
INSERT INTO fin_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Mies lähti matkaan ja meni kymmenen kaupungin alueelle kertomaan kaikille suuresta ihmeestä, jonka Jeesus oli hänelle tehnyt. Ihmiset olivat hämmästyneitä hänen kertomastaan. ");
INSERT INTO fin_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Järven toisella rannalla Jeesuksen ympärille kerääntyi suuri väkijoukko. ");
INSERT INTO fin_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Paikallisen synagogan johtaja, Jairus, tuli Jeesuksen luo. Hän kumarsi maahan asti ");
INSERT INTO fin_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ja anoi Jeesusta parantamaan hänen pienen tyttärensä. »Tyttö on kuolemaisillaan», hän sanoi epätoivoisena, »tule panemaan kätesi hänen päälleen ja tekemään hänet terveeksi!» ");
INSERT INTO fin_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jeesus lähti miehen mukaan, ja ihmismassa tungeksi heidän ympärillään. ");
INSERT INTO fin_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Joukossa oli eräs nainen, joka oli sairastanut kaksitoista vuotta verenvuototautia. ");
INSERT INTO fin_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Hän oli kärsinyt paljon ja menettänyt koko omaisuutensa etsiessään vuosikausia apua monilta lääkäreiltä. Terveemmäksi hän ei ollut kuitenkaan tullut – päinvastoin. ");
INSERT INTO fin_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nainen oli kuullut paljon Jeesuksen tekemistä ihmeistä, ja sen takia hän tuli ihmisjoukon läpi Jeesuksen taakse voidakseen koskettaa hänen vaatteitaan. ");
INSERT INTO fin_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nainen näet ajatteli: »Jos pääsen edes koskettamaan hänen vaatteitaan, tulen terveeksi.» ");
INSERT INTO fin_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ja niin tapahtuikin: heti kun hän koski Jeesukseen, verenvuoto lakkasi, ja hän tiesi olevansa terve. ");
INSERT INTO fin_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jeesus tunsi, että parantavaa voimaa oli lähtenyt hänestä. Hän kääntyi kansanjoukkoon päin ja kysyi: »Kuka kosketti minuun vaatteitani?» ");
INSERT INTO fin_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jeesuksen oppilaat sanoivat hänelle: »Tällainen ihmispaljous tungeksii ympärilläsi, ja sinä kysyt, kuka sinua kosketti!» ");
INSERT INTO fin_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mutta Jeesus katsoi jatkuvasti etsien ympärilleen löytääkseen henkilön, joka oli koskettanut häntä. ");
INSERT INTO fin_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Silloin pelästynyt nainen, joka vapisi tajutessaan, mitä hänelle oli juuri tapahtunut, heittäytyi maahan Jeesuksen eteen ja kertoi kaiken. ");
INSERT INTO fin_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jeesus sanoi hänelle: »Tyttäreni, sinun uskosi on tehnyt sinut terveeksi. Mene rauhassa, sairautesi on parantunut.» ");
INSERT INTO fin_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kun Jeesus vielä puhui naisen kanssa, Jairuksen kotoa tultiin sanomaan, ettei Jeesuksen enää kannattanut tulla – tyttö oli jo kuollut. ");
INSERT INTO fin_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mutta Jeesus sanoi Jairukselle: »Älä pelkää! Luota vain minuun.» ");
INSERT INTO fin_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Sitten hän pysäytti ihmisjoukon eikä antanut muiden kuin Pietarin, Jaakobin ja Johanneksen tulla mukanaan Jairuksen kotiin. ");
INSERT INTO fin_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Kun he saapuivat paikalle, Jeesus näki, että siellä vallitsi täysi sekasorto, hillitön itku ja vaikerrus. ");
INSERT INTO fin_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jeesus meni sisään ja kysyi: »Miksi tällainen itku ja hälinä? Lapsi ei ole kuollut – hän vain nukkuu.» ");
INSERT INTO fin_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ihmiset nauroivat hänelle ivallisesti, mutta hän pyysi heitä menemään pois ja otti mukaansa tytön vanhemmat ja ne kolme oppilastaan. Heidän kanssaan hän meni huoneeseen, jossa tyttö makasi. ");
INSERT INTO fin_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jeesus tarttui lapsen käteen ja sanoi: »Nouse ylös, tyttöseni.» ");
INSERT INTO fin_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","(Tämä oli kaksitoistavuotias.) Tyttö hypähti pystyyn ja käveli. Hänen vanhempansa eivät olleet uskoa silmiään. ");
INSERT INTO fin_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jeesus kielsi vakavasti heitä kertomasta kenellekään tapahtuneesta ja pyysi antamaan tytölle jotain syötävää. ");
INSERT INTO fin_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jeesus lähti pian siitä osasta maata ja palasi oppilaineen kotikaupunkiinsa Nasaretiin. ");
INSERT INTO fin_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","3","Seuraavana sapattina hän opetti synagogassa. Siellä ihmeteltiin hänen viisauttaan ja ihmetekojaan – olihan hän oman paikkakunnan miehiä. »Ei hän sen kummempi ole kuin mekään», ihmiset sanoivat. »Hän on vain tavallinen rakennusmies, Marian poika ja Jaakobin, Jooseen, Juudaan ja Simonin veli. Ja hänen sisarensakin asuvat tässä lähellä.» Ihmiset olivat suorastaan närkästyneitä. ");
INSERT INTO fin_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Silloin Jeesus sanoi heille: »Profeettaa kunnioitetaan kaikkialla muualla paitsi hänen omassa kotikaupungissaan, sukulaistensa ja perheensä parissa.» ");
INSERT INTO fin_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Heidän epäuskonsa tähden Jeesus ei voinut tehdä siellä muita ihmetekoja kuin laskea kätensä muutamien sairaiden päälle ja parantaa heidät. ");
INSERT INTO fin_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Hän ihmetteli ihmisten epäuskoa ja lähti lähiseudun kyliin opettamaan kansaa. ");
INSERT INTO fin_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jeesus kutsui koolle kaksitoista oppilastaan ja lähetti heidät pareittain liikkeelle. Hän antoi heille voiman vapauttaa ihmisiä demonien vallasta. ");
INSERT INTO fin_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","He saivat ottaa mukaan vain matkasauvan – ei ruokaa, ei laukkua, ei rahaa, ");
INSERT INTO fin_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ei edes ylimääräistä jalkineparia tai toista vaatekertaa. ");
INSERT INTO fin_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","»Asukaa kullakin paikkakunnalla koko ajan samassa talossa älkääkä siirtykö talosta taloon», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","»Ja kun jossain ei oteta teitä vastaan tai kuunnella teitä, karistakaa lähtiessänne tomu jaloistanne merkiksi siitä, että olette jättäneet sen paikan oman onnensa nojaan.» ");
INSERT INTO fin_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jeesuksen oppilaat lähtivät julistamaan, että kaikkien ihmisten oli luovuttava synnistä. ");
INSERT INTO fin_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","He myös vapauttivat monia pahojen henkien vallasta ja paransivat useita sairaita voitelemalla heidät öljyllä. ");
INSERT INTO fin_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pian kuningas Herodes kuuli Jeesuksesta, sillä kaikkialla puhuttiin hänen ihmeteoistaan. Kuningas luuli Jeesuksen olevan henkiin herännyt Johannes Kastaja. Ihmiset sanoivatkin: »Kummako siis, että hän pystyy tekemään sellaisia ihmeitä!» ");
INSERT INTO fin_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Toiset taas ajattelivat Jeesuksen olevan muinainen profeetta Elia, joka olisi palannut maailmaan. Jotkut väittivät että hän oli uusi profeetta, samanlainen kuin entisaikojen suurmiehet. ");
INSERT INTO fin_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","»Ei», Herodes sanoi, »se on Johannes, jonka minä mestautin – hän on noussut kuolleista.» ");
INSERT INTO fin_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Herodes oli näet lähettänyt sotilaat pidättämään ja vangitsemaan Johanneksen, koska hän muistutti jatkuvasti kuningasta siitä, että tämä oli tehnyt väärin ottaessaan vaimokseen Herodiaan, veljensä Filippuksen vaimon. ");
INSERT INTO fin_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias halusi kostaa ja surmauttaa Johanneksen, mutta ilman Herodeksen suostumusta hänellä ei ollut valtaa tehdä sitä. ");
INSERT INTO fin_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes puolestaan kunnioitti Johannesta hyvänä ja pyhänä miehenä ja piti sen vuoksi tätä suojeluksessaan. Joka kerta puhuessaan Johanneksen kanssa Herodes tuli rauhattomaksi, mutta kuunteli Johannesta kuitenkin mielellään. ");
INSERT INTO fin_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Lopulta Herodiaan tilaisuus tuli. Oli Herodeksen syntymäpäivä, ja hän piti juhlat palatsinsa työntekijöille, armeijan upseereille ja Galilean johtaville kansalaisille. ");
INSERT INTO fin_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Herodiaan tytär esitti heille tanssia, joka miellytti kovasti katselijoita. »Saat pyytää, mitä ikinä tahdot», kuningas lupasi, »ja minä annan sen sinulle – vaikka puolet valtakuntaani.» ");
INSERT INTO fin_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Tyttö lähti kysymään äidiltään, mitä pyytäisi. Tämä sanoi: »Pyydä Johannes Kastajan päätä.» ");
INSERT INTO fin_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tytär palasi kiireesti kuninkaan luo ja sanoi: »Minä haluan Johannes Kastajan pään – nyt heti – tarjottimella!» ");
INSERT INTO fin_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kuninkaan kasvot synkkenivät, mutta hän ei voinut rikkoa lupaustaan vieraiden nähden. ");
INSERT INTO fin_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Hän lähetti siis yhden henkivartijansa lyömään Johannes Kastajalta pään poikki ja tuomaan sen tytölle. ");
INSERT INTO fin_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Sotilas mestasi Johanneksen vankilassa, toi hänen päänsä tarjottimella ja antoi sen tytölle. Tämä vei sen äidilleen. ");
INSERT INTO fin_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kun Johanneksen oppilaat kuulivat, mitä oli tapahtunut, he tulivat hakemaan hänen ruumiinsa ja hautasivat sen erääseen hautakammioon. ");
INSERT INTO fin_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jeesuksen oppilaat palasivat matkalta ja kertoivat hänelle, mitä olivat tehneet ja puhuneet ihmisille, joiden kodeissa olivat käyneet. ");
INSERT INTO fin_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jeesus ehdotti silloin: »Mennään hetkeksi lepäämään – pois ihmisten joukosta.» Heidän luonaan kävi näet niin paljon ihmisiä, että heillä oli tuskin aikaa syödäkään. ");
INSERT INTO fin_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","He lähtivät veneellä rauhallisempaan paikkaan. ");
INSERT INTO fin_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Moni näki kuitenkin heidän lähtönsä ja juoksi jo edeltäpäin rantaa pitkin sinne, missä he vetivät venettä maihin. ");
INSERT INTO fin_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Niinpä siellä oli jo tavanomainen kansanpaljous odottamassa, kun Jeesus nousi veneestä. Hänen tuli sääli kokoon tulleita, sillä he olivat kuin lampaat ilman paimenta, ja hän rupesi opettamaan ja neuvomaan heitä. ");
INSERT INTO fin_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Illansuussa oppilaat tulivat Jeesuksen luo ja sanoivat: »Käske ihmisten mennä läheisiin kyliin ja maalaistaloihin ostamaan itselleen syötävää, sillä täällähän ei ole ruokaa, ja alkaa jo olla myöhä.» ");
INSERT INTO fin_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mutta Jeesus sanoikin: »Antakaa te heille syötävää.» »Miten me sitä saisimme?» Oppilaat kysyivät. »Tällaisen joukon ruokkimiseen tarvittaisiin kokonainen omaisuus!» ");
INSERT INTO fin_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","»Kuinka paljon ruokaa meillä on?» Jeesus kysyi. »Menkää ottamaan selvää.» Oppilaat tulivat ilmoittamaan, että tarjolla oli viisi leipää ja kaksi kalaa. ");
INSERT INTO fin_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jeesus kehotti silloin väkijoukkoa istumaan, ");
INSERT INTO fin_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ja pian kaikki istuivat vihreässä ruohikossa viidenkymmenen ja sadan hengen ryhmissä. ");
INSERT INTO fin_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Hän otti ne viisi leipää ja kaksi kalaa ja kiitti ruuasta katse kohotettuna taivasta kohti. Taitettuaan leivät palasiksi hän antoi kullekin oppilaalleen vähän leipää ja kalaa jaettavaksi ihmisille. ");
INSERT INTO fin_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ja tuo joukko söi, kunnes tuli kylläiseksi! ");
INSERT INTO fin_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","44","Aterialla oli noin viisituhatta miestä, ja myöhemmin ruohikosta koottiin kaksitoista korillista ruuantähteitä. ");
INSERT INTO fin_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Heti tämän jälkeen Jeesus kehotti oppilaitaan lähtemään veneellä järven yli Beetsaidaan, jonne hän tulisi myöhemmin. Itse hän jäi hyvästelemään kansanjoukkoa ja lähettämään sen kotimatkalle. ");
INSERT INTO fin_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Sitten hän meni vuorille rukoilemaan. ");
INSERT INTO fin_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Illalla, kun Jeesuksen oppilaat olivat veneessä keskellä järvenselkää ja Jeesus oli yksin maissa, ");
INSERT INTO fin_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","hän näki heidän olevan vaikeuksissa. He taistelivat tuulta ja aallokkoa vastaan ja saivat soutaa kaikin voimin. Aamuyöllä Jeesus tuli heidän luokseen kävellen veden pintaa pitkin. ");
INSERT INTO fin_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kun he näkivät veneen ohi kävelevän hahmon, he huusivat pelosta, koska luulivat näkevänsä aaveen. ");
INSERT INTO fin_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jokainen veneessä olija näki hänet. Heti he kuulivat myös hänen rauhoittavan äänensä: »Ei tässä ole mitään hätää. Minähän se olen – älkää pelätkö.» ");
INSERT INTO fin_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Sitten hän nousi veneeseen, ja tuuli tyyntyi. Miehet istuivat siinä sanattomina kykenemättä tajuamaan, mitä oli tapahtunut. ");
INSERT INTO fin_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","He eivät näet vieläkään käsittäneet, kuka hän todella oli – eivät edes edellisen illan ihmeen jälkeen. Niin ymmärtämättömiä he olivat. ");
INSERT INTO fin_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","He tulivat järven toiselle rannalle, Genesaretiin, kiinnittivät veneen ");
INSERT INTO fin_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ja nousivat maihin. Siellä olevat ihmiset tunsivat heti Jeesuksen ");
INSERT INTO fin_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ja kiirehtivät levittämään uutista Jeesuksen tulosta. Kohta kannettiin hänen luokseen sairaita matoilla ja paareilla. ");
INSERT INTO fin_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Missä hän kulkikin – kylissä, kaupungeissa ja maaseudulla – ihmiset toivat sairaita toreille ja kaduille ja pyysivät, että hän sallisi heidän koskettaa edes hänen vaatteidensa reunusta. Ja kaikki, jotka koskettivat häntä, tulivat terveiksi. ");
INSERT INTO fin_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kerran saapui Jerusalemista juutalaisten hengellisiä johtomiehiä seuraamaan Jeesuksen toimintaa. ");
INSERT INTO fin_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","He huomasivat, etteivät jotkut hänen oppilaansa aina noudattaneet juutalaisten tavanomaisia puhdistusmenoja. ");
INSERT INTO fin_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Juutalaiset – varsinkaan fariseukset – eivät koskaan rupea syömään, ennen kuin ovat pirskotelleet vettä käsivarsilleen aina kyynärpäihin saakka, niin kuin heidän vanhat tapansa vaativat. ");
INSERT INTO fin_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Niinpä heidän täytyy aina tultuaan torilta kotiin pirskotella itsensä tällä tavoin ennen kuin koskevat mihinkään ruokaan. Tämä on vain yksi esimerkki niistä monista laeista ja säännöksistä, joita he ovat noudattaneet vuosisatoja ja noudattavat vieläkin – kuten erilaisten astioiden puhdistusseremonioita ja muuta vastaavaa. ");
INSERT INTO fin_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nämä johtomiehet kysyivät nyt Jeesukselta: »Miksi sinun oppilaasi eivät noudata meidän ikivanhoja tapojamme? Hehän eivät suorita peseytymismenojakaan ennen kuin rupeavat syömään.» ");
INSERT INTO fin_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","7","Jeesus vastasi: »Voi teitä tekopyhiä! Profeetta Jesaja kuvasi teitä sattuvasti sanoessaan: ’Nämä ihmiset kyllä puhuvat Herrasta kauniita sanoja, mutta eivät rakasta häntä. Heidän jumalanpalveluksensa on pelkkää narrinpeliä, sillä he väittävät, että Jumala käskee ihmisen noudattaa heidän tyhjänpäiväisiä sääntöjään.’ Kuinka oikeassa Jesaja olikaan! ");
INSERT INTO fin_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Te ette ole tietävinännekään Jumalan selvistä käskyistä, vaan korvaatte ne omilla perinnäistavoillanne. ");
INSERT INTO fin_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Te suoraan sanoen hylkäätte Jumalan lait ja poljette ne jalkoihinne perinnäistapojenne tähden. ");
INSERT INTO fin_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mooses esimerkiksi antoi teille Jumalan säätämän lain: ’Kunnioita isääsi ja äitiäsi’ ja sanoi, että sen, joka puhui isäänsä tai äitiään vastaan, oli kuoltava. ");
INSERT INTO fin_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Mutta te sanotte, että on täysin oikein miehen olla huolehtimatta puutteessa elävistä vanhemmistaan ja selittää heille: ’Ikävä kyllä en nyt voi auttaa teitä, sillä annoin Jumalalle sen, mitä minulta olisi liiennyt teille.’ ");
INSERT INTO fin_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Näin te rikotte Jumalan lain suojellaksenne ihmisten tekemää perinnäissääntöä. Ja tämä on vain yksi monen monista esimerkeistä.» ");
INSERT INTO fin_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sitten Jeesus kutsui kansanjoukon luokseen kuuntelemaan. »Kuulkaa, te kaikki», hän sanoi, »ja koettakaa ymmärtää. ");
INSERT INTO fin_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ei teidän sielunne siitä vahingoitu, mitä se syötte, vaan siitä, mitä te ajattelette ja sanotte! ");
INSERT INTO fin_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jos teillä on korvat, niin kuunnelkaa!» ");
INSERT INTO fin_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Hän meni erääseen taloon päästäkseen pois ihmisjoukon keskeltä, ja hänen oppilaansa kysyivät häneltä, mitä hän tarkoitti sillä, mistä juuri oli puhunut. ");
INSERT INTO fin_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","»Ettekö tekään ymmärrä?» hän kysyi. »Ettekö käsitä, ettei se, mitä te syötte, vahingoita teidän sieluanne? ");
INSERT INTO fin_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sillä eihän ruoka tahraa teidän ajatusmaailmaanne, se kulkee vain ruuansulatuksen läpi.» (Sanoessaan näin hän osoitti, ettei mikään ruoka ole saastaista.) ");
INSERT INTO fin_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Hän lisäsi: »Ajatusmaailma ihmisen saastuttaa. ");
INSERT INTO fin_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sillä sisältä, ihmisen sydämestä, nousevat pahat ajatukset; niistä saavat alkunsa siveettömyys, varkaudet, murhat, ");
INSERT INTO fin_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","uskottomuus, ahneus, häijyys, petollisuus, hillittömyys, kateus, jumalanpilkka, ylpeys ja kaikki muu mielettömyys. ");
INSERT INTO fin_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tällainen paha tulee sisältäpäin ja tahraa ihmisen.» ");
INSERT INTO fin_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sitten Jeesus lähti Galileasta Tyyron ja Siidonin alueelle. Hän yritti pysytellä syrjässä, mutta se ei onnistunut. Kuten tavallista, uutinen hänen tulostaan levisi nopeasti. ");
INSERT INTO fin_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Heti hänen luokseen tuli eräs nainen, jonka pieni tytär oli demonin vallassa. Nainen oli kuullut Jeesuksesta ja tuli nyt, polvistui hänen jalkojensa juureen ");
INSERT INTO fin_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ja kerjäsi Jeesusta vapauttamaan hänen lapsensa pahan hengen vallasta. (Nainen oli kreikkalainen, kotoisin Syyrian Foinikiasta – juutalaisten mielestä siis halveksittava pakana.) ");
INSERT INTO fin_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jeesus sanoi hänelle: »Ensiksi minun on autettava omaa perhettäni – juutalaisia. Ei ole oikein ottaa lasten leipää ja heittää sitä koirille.» ");
INSERT INTO fin_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Nainen vastasi: »Se on totta, herra. Mutta annetaanhan pöydän alla makaaville koiranpennuillekin lasten ruuantähteitä.» ");
INSERT INTO fin_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","»Tuo oli hyvä vastaus», Jeesus sanoi. »Mene nyt kotiin, sillä paha henki on lähtenyt lapsestasi.» ");
INSERT INTO fin_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kun nainen palasi kotiin, hänen pieni tyttönsä makasi rauhallisena vuoteessaan. Demoni oli lähtenyt hänestä. ");
INSERT INTO fin_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tyyrosta Jeesus meni Siidoniin ja sitten takaisin Genesaretin järvelle kymmenen kaupungin alueen kautta. ");
INSERT INTO fin_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Hänen luokseen tuotiin eräs kuuro mies, joka ei pystynyt oikein puhumaankaan, ja kaikki pyysivät Jeesusta laskemaan kätensä hänen päälleen ja parantamaan hänet. ");
INSERT INTO fin_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jeesus vei miehen pois ihmisjoukosta ja pani sormensa hänen korviinsa. Sitten hän kostutti miehen kieltä syljellään. ");
INSERT INTO fin_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sen jälkeen hän katsoi ylös, huokasi ja sanoi: »Aukene!» ");
INSERT INTO fin_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ja heti mies pystyi sekä kuulemaan että puhumaan selvästi. ");
INSERT INTO fin_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jeesus kielsi ihmisjoukkoa levittämästä tietoa tapahtuneesta, mutta mitä enemmän hän ihmisiä kielsi, sitä enemmän he levittivät uutista, sillä he olivat niin ihmeissään kaikesta. ");
INSERT INTO fin_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Yhä uudelleen he sanoivat: »Kaikki, mitä hän tekee, on ihmeellistä: hän parantaa jopa kuurot ja puhevikaisetkin!» ");
INSERT INTO fin_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Samoihin aikoihin, kun eräänä päivänä oli paljon kansaa koolla, ruoka loppui taas. Jeesus kutsui oppilaansa neuvottelemaan. ");
INSERT INTO fin_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","»Minun tulee näitä ihmisiä sääli», hän sanoi, »sillä he ovat olleet koolla jo kolme päivää, eikä heillä ole enää mitään syötävää. ");
INSERT INTO fin_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jos lähetän heidät kotiin ilman ruokaa, he nääntyvät matkalla, sillä jotkut heistä ovat tulleet hyvinkin kaukaa.» ");
INSERT INTO fin_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","»Ja meidänkö pitäisi löytää heille ruokaa tästä autiomaasta?» Jeesuksen oppilaat kysyivät. ");
INSERT INTO fin_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","»Montako leipää teillä on?» Jeesus kysyi. »Seitsemän», he vastasivat. ");
INSERT INTO fin_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Niinpä hän kehotti ihmisjoukkoa istumaan maahan. Hän otti ne seitsemän leipää, kiitti niistä Jumalaa, taitteli ne palasiksi ja ojensi oppilailleen. Nämä puolestaan jakoivat ne ihmisille. ");
INSERT INTO fin_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Joillakin ihmisillä oli mukanaan myös muutamia pieniä kaloja, jotka Jeesus siunasi ja antoi oppilaidensa tarjoiltavaksi. ");
INSERT INTO fin_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Kaikki söivät itsensä kylläiseksi. Sen jälkeen Jeesus lähetti heidät kotiin. Tuona päivänä oli ihmisiä koolla noin neljätuhatta, ja kun ruuantähteet koottiin aterian jälkeen, niitä kertyi seitsemän suurta korillista. ");
INSERT INTO fin_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Heti tämän jälkeen Jeesus lähti oppilaidensa kanssa veneellä Dalmanutan seudulle. ");
INSERT INTO fin_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kun sikäläiset fariseukset kuulivat hänen saapumisestaan, he tulivat hänen luokseen saadakseen väitellä hänen kanssaan. »Tee meille jokin ihme», he sanoivat. »Näytä meille jotain yliluonnollista. Sitten me uskomme sinuun.» ");
INSERT INTO fin_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Tämän kuullessaan Jeesus huokasi syvään ja sanoi: »Kuinka monta ihmettä te oikein vielä tarvitsette?» ");
INSERT INTO fin_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Hän jätti heidät siihen, meni takaisin veneeseen ja lähti järven toiselle puolelle. ");
INSERT INTO fin_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jeesuksen oppilaat olivat unohtaneet ottaa tarpeeksi ruokaa mukaan, ennen kuin lähtivät matkaan, ja heillä oli veneessä vain yksi leipä. ");
INSERT INTO fin_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Heidän ylittäessään järvenselkää Jeesus sanoi hyvin vakavasti: »Varokaa kuningas Herodeksen ja fariseusten hapatetta.» ");
INSERT INTO fin_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","»Mitä hän nyt tarkoittaa?» oppilaat kysyivät toinen toisiltaan. He tulivat siihen tulokseen, että Jeesus oli puhunut leivän hapattamisesta ja tarkoittanut sitä, ettei heillä ollut leipää mukanaan. ");
INSERT INTO fin_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jeesus huomasi, mistä he puhuivat, ja sanoi: »Siitä ei suinkaan ole kysymys. Tarkoitin Herodeksen ja fariseusten opetuksia. Ettekö te ymmärrä? Ettekö te huomaa mitään? ");
INSERT INTO fin_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Jesajakin sanoi: ’Teillä on silmät – miksi ette niitä käytä? Miksi ette pidä korvianne auki?’ Ettekö edes muista mitään? ");
INSERT INTO fin_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Enkö minä ruokkinut viittätuhatta miestä viidellä leivällä? Montako korillista te keräsitte ruuantähteitä syönnin jälkeen?» »Kaksitoista», oppilaat vastasivat. ");
INSERT INTO fin_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","»Ja kun minä ruokin ne neljätuhatta seitsemällä leivällä, paljonko jäi tähteeksi?» »Seitsemän korillista», he sanoivat. ");
INSERT INTO fin_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","»Ja kuitenkin te luulette minun olevan huolissani siitä, ettei meillä ole leipää!» ");
INSERT INTO fin_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kun he saapuivat Beetsaidaan, ihmiset taluttivat heidän eteensä sokean miehen ja pyysivät Jeesusta koskettamaan häntä ja parantamaan hänet. ");
INSERT INTO fin_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jeesus tarttui sokean käteen ja vei hänet kylän ulkopuolelle. Sitten hän sylki sokean silmiin ja laski niille kätensä. »Pystytkö nyt näkemään mitään?» Jeesus kysyi. ");
INSERT INTO fin_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mies katsoi ympärilleen. »Minä näen!» hän sanoi. »Näen ihmisiä! Mutta en pysty erottamaan heitä oikein selvästi – he näyttävät käveleviltä puunrungoilta!» ");
INSERT INTO fin_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sitten Jeesus pani uudelleen kätensä miehen silmille. Kun tämä tuijotti eteensä, hänen näkönsä palasi täydellisesti, ja hän ahmi silmillään ympärillä avautuvia näkymiä. ");
INSERT INTO fin_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jeesus lähetti miehen kotiin perheensä luo. »Älä poikkea edes kylään», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jeesus ja hänen oppilaansa lähtivät Filippuksen Kesarean kyliin. Heidän kävellessään hän kysyi oppilailtaan: »Kuka minä ihmisten mielestä olen? Mitä he sanovat minusta?» ");
INSERT INTO fin_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","»Jotkut ajattelevat sinun olevan Johannes Kastaja», oppilaat vastasivat. »Toiset sanovat, että olet Elia tai joku muu entisaikojen profeetta, joka on noussut kuolleista.» ");
INSERT INTO fin_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Silloin Jeesus kysyi: »Kuka minä teidän mielestänne olen?» Pietari vastasi: »Sinä olet Messias.» ");
INSERT INTO fin_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jeesus varoitti heitä kertomasta sitä kenellekään. ");
INSERT INTO fin_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sitten Jeesus alkoi kertoa heille tulevista kärsimyksistään: ylipapit ja muut juutalaisten johtomiehet kääntäisivät hänelle lopullisesti selkänsä, hänet surmattaisiin ja kolmen päivän kuluttua hän nousisi kuolleista. ");
INSERT INTO fin_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Hän puhui tästä heille aivan avoimesti, ja silloin Pietari veti hänet syrjään ja sanoi moittivasti: »Et saa puhua sellaisia.» ");
INSERT INTO fin_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jeesus kääntyi katsomaan oppilaihinsa ja sanoi sitten ankarasti Pietarille: »Väisty syrjään, saatana! Sinä näet asian ihmisen etkä Jumalan näkökulmasta!» ");
INSERT INTO fin_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Sitten Jeesus kutsui oppilaansa ja kansanjoukon luokseen kuuntelemaan. »Jos joku teistä haluaa olla minun seuraajani», hän sanoi, »hänen on unohdettava itsensä, otettava kantaakseen ristinsä ja pysyttävä minun seurassani. ");
INSERT INTO fin_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Joka tahtoo itse olla oman elämänsä herra, menettää elämänsä. Vain se, joka on valmis antamaan elämänsä minun hallittavakseni ja levittämään Jumalan hyvää sanomaa, saa kokea, millaista todellinen elämä on. ");
INSERT INTO fin_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ja mitä hyötyä ihmiselle on siitä, että hän voittaa koko maailman, jos hän samalla menettää sielunsa ja elämän? Sillä onko hänellä mitään sieluaan arvokkaampaa? ");
INSERT INTO fin_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kadotettua elämää ei osteta rahalla takaisin. ");
INSERT INTO fin_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jokaista, joka häpeää minua ja minun sanomaani tänä epäuskon ja synnin aikana, minäkin häpeän kerran, kun palaan Isäni kirkkaudessa, pyhien enkelien kanssa.» ");
INSERT INTO fin_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jeesus sanoi oppilailleen jatkaen äskeistä puhettaan: »Voitte olla varmoja siitä, että jotkut tässä seisovista ovat elossa vielä silloin, kun Jumalan valtakunta näkyy koko voimassaan.» ");
INSERT INTO fin_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kuusi päivää myöhemmin Jeesus otti Pietarin, Jaakobin ja Johanneksen mukaansa yksinäisyyteen vuoren huipulle. Yhtäkkiä Jeesuksen kasvot alkoivat sädehtiä kirkkautta. ");
INSERT INTO fin_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Hänen vaatteensa tulivat hohtavan valkoisiksi, niin loistaviksi, ettei kukaan olisi kyennyt saamaan sellaista kirkkautta aikaan. ");
INSERT INTO fin_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Sitten hänen viereensä ilmestyivät Elia ja Mooses, jotka alkoivat puhua hänen kanssaan. ");
INSERT INTO fin_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","»Opettaja, tämähän on ihmeellistä!» Pietari huudahti. »Me tahtoisimme rakentaa tänne kolme lehtimajaa, yhden teille jokaiselle…» ");
INSERT INTO fin_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Hän sanoi tämän vain jotain sanoakseen, sillä oppilaat olivat kauhean peloissaan. ");
INSERT INTO fin_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kun Pietari vielä puhui, heidät peitti pilvi, joka esti aurinkoa näkymästä, ja pilvestä tuleva ääni sanoi: »Tämä on minun rakas Poikani. Kuunnelkaa häntä.» ");
INSERT INTO fin_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mutta kun he sitten katsoivat ympärilleen, Mooses ja Elia olivat lähteneet, ja Jeesus yksin oli heidän kanssaan. ");
INSERT INTO fin_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kun he laskeutuivat alas vuorenrinnettä, Jeesus kielsi heitä kertomasta kenellekään, mitä olivat nähneet, kunnes hän olisi noussut kuolleista. ");
INSERT INTO fin_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","He pitivätkin kaiken omana tietonaan, mutta puhuivat näkemästään usein keskenään ja ihmettelivät, mitä hän mahtoi tarkoittaa »kuolleista nousemisella». ");
INSERT INTO fin_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","He alkoivat kysellä häneltä asiasta, josta juutalaiset lainopettajat usein puhuivat – siitä, että Elian täytyi palata, ennen kuin Messias tulisi. Jeesus myönsi tämän todeksi. ");
INSERT INTO fin_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","»Elia on jo tullutkin, mutta häntä kohdeltiin hyvin huonosti, aivan niin kuin profeetat olivat ennustaneet», Jeesus selitti. Sitten hän kysyi heiltä, mitä profeetat olivat mahtaneet tarkoittaa ennustaessaan, että Messias joutuu ihmisten halveksittavaksi ja suuriin kärsimyksiin. ");
INSERT INTO fin_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Laskeuduttuaan takaisin vuoren juurelle he näkivät, että suuri ihmisjoukko oli kokoontunut alas jääneiden oppilaiden ympärille. Jotkut juutalaisten lainopettajat olivat siellä väittelemässä Jeesuksen oppilaiden kanssa. ");
INSERT INTO fin_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ihmisjoukko katseli Jeesuksen lähestymistä pelon ja kunnioituksen vallassa, ja monet menivät heti tervehtimään häntä. ");
INSERT INTO fin_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","»Mistä täällä väitellään?» hän kysyi. ");
INSERT INTO fin_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Eräs mies ihmisjoukon keskeltä vastasi: »Opettaja, minä toin poikani sinun parannettavaksesi – hän ei pysty puhumaan, sillä hänessä on paha henki. ");
INSERT INTO fin_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ja aina kun henki saa hänessä vallan, poika kaatuu maahan ja hänen suustaan tulee vaahtoa, hän kiristelee hampaitaan ja jäykistyy. Pyysin oppilaitasi karkottamaan pahan hengen, mutta he eivät pystyneet siihen.» ");
INSERT INTO fin_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jeesus sanoi oppilailleen: »Voi, miten vähän teillä on uskoa! Kuinka pitkään minun on vielä oltava teidän kanssanne, ennen kuin te uskotte? Miten kauan minun on kestettävä teitä? Tuokaa poika tänne!» ");
INSERT INTO fin_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Poika tuotiin, mutta kun hän näki Jeesuksen, demoni kouristi häntä pahasti, ja hän kaatui maahan. Siinä hän vääntelehti suu vaahdossa. ");
INSERT INTO fin_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","»Kuinka kauan tämä on pojassa ollut?» Jeesus kysyi isältä. »Siitä saakka, kun hän oli aivan pieni. ");
INSERT INTO fin_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Paha henki kaataa hänet usein tuleen tai veteen saadakseen hänet surmatuksi. Sääli meitä ja tee jotakin, jos voit!» ");
INSERT INTO fin_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","»Jos voin?» Jeesus sanoi. »Joka uskoo, voi tehdä mitä hyvänsä.» ");
INSERT INTO fin_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Silloin isä huusi hätääntyneenä: »Uskonhan minä! Auta minua pääsemään epäuskostani.» ");
INSERT INTO fin_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Kun Jeesus näki, että ihmisjoukko oli yhä kasvamassa, hän sanoi ankarasti demonille: »Kuurouden ja mykkyyden henki, tule ulos tästä lapsesta ja jätä hänet rauhaan!» ");
INSERT INTO fin_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Paha henki huusi kauhealla äänellä, kouristi uudelleen poikaa ja lähti hänestä. Poika jäi lojumaan liikkumattomana. Kansanjoukko kohahti: »Hän kuoli.» ");
INSERT INTO fin_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mutta Jeesus tarttui lasta kädestä ja auttoi hänet jaloilleen. Poika nousi ylös terveenä. ");
INSERT INTO fin_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Myöhemmin, kun Jeesus oli eräässä talossa yksin oppilaidensa kanssa, he kysyivät häneltä: »Miksi me emme kyenneet ajamaan tuota henkeä ulos?» ");
INSERT INTO fin_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jeesus vastasi: »Tällaiset tapaukset vaativat rukousta.» ");
INSERT INTO fin_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","He lähtivät siltä seudulta ja kulkivat Galilean halki. Jeesus yritti välttää julkisuutta voidakseen olla enemmän oppilaidensa kanssa ja opettaa heitä. Hän sanoi heille: »Minä, joka olen tullut taivaasta, joudun petoksen uhriksi. Minut surmataan ja kolmantena päivänä nousen kuolleista.» ");
INSERT INTO fin_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Mutta oppilaat eivät ymmärtäneet häntä eivätkä uskaltaneet kysyä, mitä hän tarkoitti. ");
INSERT INTO fin_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","He saapuivat Kapernaumiin. Kun he olivat asettuneet majapaikkaansa, Jeesus kysyi oppilailtaan: »Mistä te matkalla keskustelitte?» ");
INSERT INTO fin_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Heitä hävetti vastata, sillä he olivat kiistelleet siitä, kuka heistä oli suurin. ");
INSERT INTO fin_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jeesus meni istumaan, kutsui oppilaansa ympärilleen ja sanoi: »Sen, joka haluaa olla suurin, täytyy olla vähäisin – kaikkien palvelija!» ");
INSERT INTO fin_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sitten hän asetti pienen lapsen heidän eteensä, nosti lapsen syliinsä ja sanoi heille: ");
INSERT INTO fin_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","»Joka ottaa luokseen tällaisen pienen lapsen minun nimessäni, ottaa luokseen minut, ja joka ottaa luokseen minut, ottaa luokseen minun Isäni, joka minut tänne lähetti.» ");
INSERT INTO fin_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yksi Jeesuksen oppilaista, Johannes, sanoi kerran hänelle: »Opettaja, me näimme erään miehen käyttävän sinun nimeäsi vapauttaessaan ihmisiä pahojen henkien vallasta. Me kielsimme häntä, koska hän ei kuulu meidän joukkoomme.» ");
INSERT INTO fin_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","»Älkää kieltäkö häntä», Jeesus sanoi, »sillä ei kukaan, joka tekee ihmeitä minun nimeeni, saman tien käänny minua vastaan. ");
INSERT INTO fin_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Se, joka ei ole meitä vastaan, on meidän puolellamme. ");
INSERT INTO fin_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Jos joku antaa teille vaikka vain kupillisen vettä siksi, että te olette Kristuksen omia, hän ei totta totisesti ole jäävä palkkaansa vaille. ");
INSERT INTO fin_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mutta jos joku riistää uskon yhdeltäkin näistä pienistä, jotka turvautuvat minuun, sille ihmiselle olisi parempi, jos hänet heitettäisiin myllynkivi kaulassa mereen. ");
INSERT INTO fin_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Jos kätesi tekee sellaista, mikä on väärin, leikkaa se pois. On parempi päästä käsipuolena ikuiseen elämään kuin joutua kumpikin käsi tallella helvetin sammumattomaan tuleen. ");
INSERT INTO fin_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jos jalkasi vie sinut pahaan, hakkaa se pois! Parempi sinun on päästä ikuiseen elämään rampana kuin molemmat jalat tallella joutua kadotukseen. ");
INSERT INTO fin_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ja jos silmäsi houkuttelee sinua syntiin, revi se pois. On parempi päästä silmäpuolena Jumalan valtakuntaan, kuin molemmilla silmillään katsella helvetin tulta, ");
INSERT INTO fin_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","missä mato ei koskaan kuole eikä tuli sammu. ");
INSERT INTO fin_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Jokainen ihminen joutuu koeteltavaksi. ");
INSERT INTO fin_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Hyväkin suola on arvotonta, jos se menettää suolaisuutensa; sillä ei voida maustaa mitään. Älkää siis menettäkö suolaisuuttanne! Eläkää sovussa keskenänne.» ");
INSERT INTO fin_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sitten Jeesus lähti Kapernaumista etelään päin Juudean rajalle ja Jordanin itärannalla olevalle alueelle. Kuten aina, hänen ympärillään oli nytkin joukoittain ihmisiä, ja hän opetti heitä niin kuin tavallisesti. ");
INSERT INTO fin_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Muutamat fariseukset tulivat kysymään häneltä: »Hyväksytkö sinä avioeron?» He halusivat saada hänet ansaan. ");
INSERT INTO fin_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","»Mitä Mooses opetti avioerosta?» Jeesus kysyi heiltä. ");
INSERT INTO fin_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","»Hän hyväksyi sen», he vastasivat. »Hän sanoi, ettei miehen tarvinnut tehdä muuta kuin kirjoittaa vaimolleen erokirja.» ");
INSERT INTO fin_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","»Ja miksi hän sen sanoi?» Jeesus kysyi. »Hän myöntyi siihen teidän sydämenne kovuuden tähden. ");
INSERT INTO fin_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jumalan alkuperäinen tarkoitus ei ollut sellainen. Jumala loi miehen ja naisen toisilleen; ");
INSERT INTO fin_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","siksi miehen on jätettävä isänsä ja äitinsä, ja hän ja hänen vaimonsa liittyvät yhteen, ");
INSERT INTO fin_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","niin etteivät he enää ole kaksi vaan yksi. ");
INSERT INTO fin_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kenenkään ihmisen ei ole lupa erottaa sellaista, minkä Jumala on liittänyt yhteen.» ");
INSERT INTO fin_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Myöhemmin, kun hän oli talossa yksin oppilaidensa kanssa, he ottivat asian jälleen puheeksi. ");
INSERT INTO fin_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jeesus sanoi heille: »Kun mies ottaa eron vaimostaan ja menee naimisiin jonkun toisen kanssa, hän on uskoton ensimmäiselle vaimolleen ja tekee siis aviorikoksen. ");
INSERT INTO fin_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ja kun vaimo ottaa eron miehestään ja menee uusiin naimisiin, myös hän on uskoton ja tekee aviorikoksen.» ");
INSERT INTO fin_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kerran, kun muutamat äidit toivat lapsiaan Jeesuksen siunattavaksi, hänen oppilaansa hätistelivät heitä pois ja kielsivät heitä vaivaamasta Jeesusta. ");
INSERT INTO fin_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mutta Jeesus näki mitä tapahtui ja sanoi harmistuneena oppilaillensa: »Antakaa lasten tulla minun luokseni, sillä Jumalan valtakunta kuuluu heidänlaisilleen ihmisille. Älkää kieltäkö heitä tulemasta! ");
INSERT INTO fin_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Asia on niin, että joka ei tule Jumalan luo kuin lapsi, ei pääse hänen valtakuntaansa.» ");
INSERT INTO fin_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Sitten Jeesus otti lapset syliinsä, pani kätensä heidän päänsä päälle ja siunasi heidät. ");
INSERT INTO fin_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kun hän oli lähdössä, hänen luokseen juoksi eräs mies, polvistui maahan ja kysyi: »Hyvä opettaja, mitä minun pitäisi tehdä, että saisin ikuisen elämän?» ");
INSERT INTO fin_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","»Miksi sanot minua hyväksi?» Jeesus kysyi. »Vain Jumala on todella hyvä. ");
INSERT INTO fin_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mutta mitä kysymykseesi tulee – käskythän sinä tiedät: älä tapa, älä tee aviorikosta, älä varasta, älä valehtele, älä riistä toiselta, kunnioita isääsi ja äitiäsi.» ");
INSERT INTO fin_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","»Opettaja», mies vastasi, »ainuttakaan näistä käskyistä en ole koskaan rikkonut.» ");
INSERT INTO fin_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jeesus katsoi mieheen sillä tavalla, että selvästi huomasi hänen rakastavan tätä. »Vain yksi sinulta puuttuu», hän sanoi, »mene ja myy kaikki, mitä omistat, ja anna rahat köyhille, niin sinulla on aarre taivaassa – ja tule minun mukaani.» ");
INSERT INTO fin_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Mies kääntyi pois pettyneenä, sillä hän oli hyvin rikas. ");
INSERT INTO fin_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jeesus katsoi hänen jälkeensä ja sanoi sitten oppilailleen: »Ei ole helppoa rikkaan päästä Jumalan valtakuntaan!» ");
INSERT INTO fin_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tämä hämmästytti heitä. Sen tähden Jeesus sanoi vielä uudestaan: »Rakkaat lapset, kuinka vaikea onkaan niiden, jotka luottavat rikkauksiinsa, päästä Jumalan valtakuntaan. ");
INSERT INTO fin_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Helpompi on kamelin mennä neulansilmän läpi kuin rikkaan päästä Jumalan valtakuntaan.» ");
INSERT INTO fin_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Oppilaat eivät ottaneet uskoakseen. »Kuka sitten voi pelastua?» he kysyivät. ");
INSERT INTO fin_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jeesus katsoi heihin tutkivasti ja sanoi sitten: »Ihmiselle se onkin sula mahdottomuus. Jumalalle sen sijaan ei, sillä hän voi tehdä kaiken mahdolliseksi.» ");
INSERT INTO fin_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Silloin Pietari alkoi todistella, mistä kaikesta hän ja muut Jeesuksen oppilaat olivat luopuneet lähtiessään Jeesuksen mukaan. »Me olemme jättäneet kaiken sinun vuoksesi», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Siihen Jeesus vastasi: »Usko minua: ei ole ketään, joka olisi luopunut kodista, veljistä, sisarista, äidistä, isästä, lapsista tai omaisuudesta minun ja ilosanoman eteenpäin viemisen tähden ");
INSERT INTO fin_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ja joka ei saisi satakertaista korvausta: veljiä, sisaria, äitejä, lapsia, maata – hän tosin joutuu kokemaan myös vainoa tässä maailmassa, mutta saa tulevassa maailmassa ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Monista tärkeistä henkilöistä tulee silloin vähäpätöisiä, ja monille sellaisille, joita täällä pidetään mitättöminä, osataan siellä antaa arvoa.» ");
INSERT INTO fin_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jeesus ja oppilaat kulkivat Jerusalemiin vievällä tiellä. Jeesus käveli edellä. Oppilaat, jotka kulkivat hänen perässään, olivat peloissaan ja epätietoisia. Jeesus vei heidät syrjään muista ihmisistä ja kuvasi taas kerran kaiken, mitä hänelle tapahtuu, kun he saapuvat Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","»Kun me tulemme sinne», hän selitti, »minut, Ihmisen Poika, pidätetään ja viedään ylipappien ja muiden johtavien juutalaisten eteen. He tuomitsevat minut kuolemaan ja antavat roomalaisten panna tuomion täytäntöön. ");
INSERT INTO fin_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","He pilkkaavat minua, sylkevät päälleni, ruoskivat minua ja surmaavat minut. Mutta kolmantena päivänä minä nousen kuolleista.» ");
INSERT INTO fin_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jaakob ja Johannes, Sebedeuksen pojat, tulivat puhumaan hänen kanssaan. »Mestari», he sanoivat, »haluaisimme, että tekisit meille ystävänpalveluksen.» ");
INSERT INTO fin_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","»Minkälaisen?» hän kysyi. ");
INSERT INTO fin_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","»Me haluamme istua lähinnä sinua olevilla valtaistuimilla valtakunnassasi», he sanoivat, »toinen oikealla ja toinen vasemmalla puolellasi.» ");
INSERT INTO fin_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jeesus vastasi: »Te ette tiedä, mitä pyydätte! Pystyttekö myös juomaan siitä katkerasta kärsimysten maljasta, josta minun on juotava? Pystyttekö te ottamaan sen kärsimyksen kasteen, jolla minut kastetaan?» ");
INSERT INTO fin_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","»Kyllä pystymme!» he sanoivat. Jeesus sanoi heille: »Minun maljastani te joudutte todellakin juomaan ja minun kasteellani teidät kastetaan, ");
INSERT INTO fin_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","mutta minulla ei ole oikeutta antaa teille valtaistuinsijoja vierestäni. Se istumajärjestys on jo laadittu.» ");
INSERT INTO fin_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kun toiset oppilaat kuulivat, mitä Jaakob ja Johannes olivat pyytäneet, heitä alkoi tavattomasti harmittaa. ");
INSERT INTO fin_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Silloin Jeesus kutsui heidät luokseen ja sanoi: »Te tiedätte, että kansojen johtomiehet hallitsevat herroina alaisiaan. ");
INSERT INTO fin_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","44","Teidän joukossanne on oltava toisin. Sen teistä, joka haluaa olla suuri, täytyy olla kaikkien palvelija. ");
INSERT INTO fin_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","En minäkään, vaikka olen kotoisin taivaasta, ole tullut palveltavaksi, vaan palvelemaan ihmisiä ja antamaan henkeni lunnaiksi monien puolesta.» ");
INSERT INTO fin_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Näin he tulivat Jerikoon. Myöhemmin, heidän lähtiessään kaupungista, heitä seurasi suuri kansanjoukko. Nyt sattui sokea kerjäläinen nimeltä Bartimeus (Timeuksen poika) istumaan tiepuolessa Jeesuksen kulkiessa ohi. ");
INSERT INTO fin_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Kun Bartimeus kuuli, että Nasaretin Jeesus oli lähellä, hän alkoi huutaa: »Jeesus, Daavidin poika, auta minua!» ");
INSERT INTO fin_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","»Suu kiinni!» tiuskaisivat jotkut sokealle. Mutta tämä huusi sitä äänekkäämmin ja yhä uudestaan: »Daavidin poika, sääli minua!» ");
INSERT INTO fin_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kun Jeesus kuuli huudon, hän pysähtyi ja sanoi: »Pyytäkää mies tänne.» Lähellä olijat sanoivat sokealle: »Sinulla oli onnea! Mene nyt, hän kutsuu sinua!» ");
INSERT INTO fin_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bartimeus heitti viitan yltään ja tuli Jeesuksen luo. ");
INSERT INTO fin_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","»Mitä haluat minun tekevän itsellesi?» Jeesus kysyi. »Voi, opettaja», sokea sanoi, »haluan saada takaisin näköni!» ");
INSERT INTO fin_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jeesus sanoi hänelle: »Hyvä on, tapahtukoon niin! Uskosi on parantanut sinut.» Sokea sai heti näkönsä ja lähti kulkemaan Jeesuksen jäljessä. ");
INSERT INTO fin_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jeesus ja hänen oppilaansa lähestyivät Jerusalemia Beetfagen ja Betanian kautta, Öljymäeltä. Jeesus lähetti kaksi oppilastaan edeltä. ");
INSERT INTO fin_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","»Menkää tuohon kylään», hän sanoi heille, »ja kun tulette kylän laitaan, näette siellä kiinni sidotun aasinvarsan, jolla kukaan ei ole vielä ratsastanut. Päästäkää se irti ja tuokaa tänne. ");
INSERT INTO fin_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jos joku kysyy, mitä teette, sanokaa vain: ’Herra tarvitsee sitä ja toimittaa sen pian takaisin.’» ");
INSERT INTO fin_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Miehet löysivätkin varsan kujalta, missä se oli sidottuna erään talon seinustalle. Kun he olivat irrottamassa sitä, ");
INSERT INTO fin_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","lähistöllä seisoskelevat miehet huusivat: »Mitä te oikein teette – päästätte varsan irti?» ");
INSERT INTO fin_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Silloin he vastasivat, niin kuin Jeesus oli neuvonut, ja miehet antoivat heidän ottaa sen. ");
INSERT INTO fin_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","He toivat varsan Jeesuksen luo. Oppilaat heittivät viittansa sen selkään, niin että Jeesus voisi ratsastaa sillä. ");
INSERT INTO fin_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Monet kansanjoukostakin levittivät vaatteita tielle hänen eteensä, toiset taas heittivät tielle reheviä oksia, joita olivat katkaisseet puista. ");
INSERT INTO fin_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jeesus oli keskellä väkijoukkoa, ja kaikki hänen edellään ja jäljessään kulkevat huusivat: »Eläköön kuningas! Kunnia hänelle, jonka Jumala on lähettänyt! ");
INSERT INTO fin_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Menestys sille valtakunnalle, jonka hän tuo tullessaan, isämme Daavidin valtakunnalle! Auta meitä, sinä, joka olet taivaasta!» ");
INSERT INTO fin_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Näin hän saapui Jerusalemiin ja meni temppeliin. Hän katseli tarkasti kaikkea ja lähti sitten – oli jo ilta – Betaniaan yhdessä kahdentoista oppilaansa kanssa. ");
INSERT INTO fin_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kun he seuraavana aamuna lähtivät Betaniasta, Jeesuksen oli nälkä. ");
INSERT INTO fin_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Hän huomasi lähellään täydessä lehdessä olevan viikunapuun; niinpä hän meni katsomaan, löytyisikö siitä hedelmiäkin. Mutta siinä oli pelkkiä lehtiä, sillä vielä ei ollut hedelmien kypsymisen aika. ");
INSERT INTO fin_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Silloin Jeesus sanoi puulle: »Sinä et koskaan enää kanna hedelmää!» Hänen oppilaansa kuulivat nämä sanat. ");
INSERT INTO fin_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Kun he tulivat takaisin Jerusalemiin, Jeesus meni temppeliin ja alkoi ajaa sieltä ulos ostajia ja myyjiä. Hän kaatoi rahanvaihtajien pöydät ja kyyhkysenmyyjien telineet ");
INSERT INTO fin_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ja esti ihmisiä kantamasta sisään lisää kauppatavaraa. ");
INSERT INTO fin_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Hän sanoi heille: »Raamatussa sanotaan: ’Minun temppelini on kaikkien kansojen rukoushuone’, mutta te olette tehneet siitä rosvoluolan.» ");
INSERT INTO fin_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kun ylipapit ja muut juutalaisten hengelliset johtomiehet kuulivat, mitä hän oli tehnyt, he alkoivat suunnitella, kuinka parhaiten saisivat raivatuksi hänet pois tieltään. He näet pelkäsivät mellakoita, koska ihmiset olivat niin innoissaan hänen opetuksestaan. ");
INSERT INTO fin_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Illalla Jeesus ja hänen oppilaansa lähtivät kaupungista, niin kuin he tapasivat tehdä. ");
INSERT INTO fin_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kun he seuraavana aamuna kulkivat Jeesuksen kiroaman viikunapuun ohi, he näkivät sen kuihtuneen juuria myöten. ");
INSERT INTO fin_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Silloin Pietari muisti, mitä Jeesus oli edellisenä päivänä sanonut puulle, ja hän huudahti: »Katso, opettaja, viikunapuu, jonka sinä kirosit, on kuihtunut!» ");
INSERT INTO fin_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Silloin Jeesus sanoi oppilailleen: »Jos teillä vain olisi usko Jumalaan, ");
INSERT INTO fin_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","niin vakuutan teille, että te voisitte sanoa tälle Öljymäelle: ’Kohoa ylös ja putoa mereen’, ja se tottelisi. Teiltä ei vaadita muuta kuin että todella uskotte. ");
INSERT INTO fin_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Voitte pyytää mitä tahansa, ja jos uskotte sen saaneenne, se on teidän. ");
INSERT INTO fin_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Mutta kun rukoilette, antakaa ensin anteeksi niille, joita vastaan kannatte kaunaa, niin myös teidän Isänne taivaassa antaa teille teidän syntinne anteeksi.» ");
INSERT INTO fin_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Näihin aikoihin he olivat jälleen saapuneet Jerusalemiin. Jeesuksen kävellessä temppelialueen halki ylipapit ja muut juutalaisten kansanjohtajat tulivat hänen luokseen ");
INSERT INTO fin_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ja tiukkasivat: »Mitä täällä tapahtuu? Kuka sinulle antoi valtuudet ajaa kauppiaat ulos?» ");
INSERT INTO fin_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jeesus vastasi: »Sanon sen teille, jos vastaatte kysymykseeni. ");
INSERT INTO fin_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Mitä te sanotte Johannes Kastajasta: oliko hän Jumalan lähettämä vai ei? Vastatkaa minulle!» ");
INSERT INTO fin_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Miehet neuvottelivat keskenään. »Jos vastaamme, että hän oli Jumalan lähettämä, silloin Jeesus sanoo: ’No, miksi hän ei sitten kelvannut teille?’ ");
INSERT INTO fin_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mutta jos sanomme, ettei hän ollut Jumalan lähettämä, silloin syntyy mellakka.» Kansa näet uskoi lujasti, että Johannes oli profeetta. ");
INSERT INTO fin_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","He siis sanoivat: »Me emme osaa vastata. Emme tiedä.» Silloin Jeesus sanoi: »Siinä tapauksessa minäkään en vastaa teidän kysymykseenne.» ");
INSERT INTO fin_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jeesus kertoi noihin aikoihin ihmisille muutamia vertauksia. »Eräs mies istutti itselleen viinitarhan. Hän pystytti sen ympärille muurin ja teki altaan rypälemehun puristamista varten. Hän rakensi vielä vartiotornin. Sitten hän antoi viljelmän vuokralle ja lähti pitkälle ulkomaanmatkalle. ");
INSERT INTO fin_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Rypäleiden korjaamisen aikaan hän lähetti yhden miehistään perimään hänelle kuuluvan osan sadosta. ");
INSERT INTO fin_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mutta vuokralaiset löivät miestä ja ajoivat hänet pois. ");
INSERT INTO fin_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Omistaja lähetti silloin toisen miehen. Häntä kohdeltiin vieläkin huonommin: hän sai kovan iskun päähänsä. ");
INSERT INTO fin_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Seuraava mies, jonka omistaja lähetti, tapettiin ja muut myöhemmin lähetetyt joko hakattiin tai tapettiin, ");
INSERT INTO fin_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","kunnes oli enää vain yksi mies jäljellä: omistajan ainoa poika. Lopulta omistaja lähetti hänet ajatellen, että häntä he varmasti kuuntelisivat. ");
INSERT INTO fin_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mutta kun vuokraajat näkivät hänen tulevan, he sanoivat: ’Tuosta tulee tämän paikan omistaja, kun hänen isänsä kuolee. Tapetaan hänet – ja viinitarha on meidän!’ ");
INSERT INTO fin_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ja niin he ottivat pojan kiinni, murhasivat hänet ja heittivät ruumiin viinitarhan muurin yli. ");
INSERT INTO fin_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Mitä arvelette omistajan tekevän, kun hän saa kuulla tapahtuneesta? Hän tulee ja surmaa heidät kaikki ja vuokraa viinitarhan muille. ");
INSERT INTO fin_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ettekö muista lukeneenne Raamatusta tällaista jaetta: ’Kivestä, joka ei kelvannut rakentajille, on tullut kulmakivi – rakennuksen arvokkain kivi. ");
INSERT INTO fin_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Herra on tämän tehnyt, se on meistä todella ihmeellistä.’» ");
INSERT INTO fin_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Juutalaisten kansanjohtajat halusivat pidättää Jeesuksen heti paikalla tämän vertauksen tähden, sillä he tiesivät, että sen kärki kohdistui heihin – he olivat kertomuksen kelvottomia viinitarhureita. Mutta he eivät uskaltaneet koskea häneen, sillä he pelkäsivät kansanjoukkoa. He menivät matkoihinsa, ");
INSERT INTO fin_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","mutta lähettivät muita uskonnollisia ja poliittisia johtomiehiä puhumaan hänen kanssaan, että saisivat hänet sanomaan jotain, minkä nojalla hänet voitaisiin pidättää. ");
INSERT INTO fin_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","»Opettaja», nämä urkkijat sanoivat, »me tiedämme, että sinä puhut totta – maksoi mitä maksoi. Sinä et puhu ollaksesi ihmisille mieliksi, vaan opetat mitä Jumala sanoo. Kysymyksemme on tämä: onko oikein maksaa veroja Rooman keisarille?» ");
INSERT INTO fin_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jeesus huomasi heidän virittämänsä ansan ja sanoi: »Näyttäkää minulle kolikko, niin minä vastaan teille.» ");
INSERT INTO fin_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Kun he olivat antaneet hänelle rahan, hän kysyi: »Kenen kuva ja nimi tässä on?» He vastasivat: »Keisarin.» ");
INSERT INTO fin_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","»No niin», Jeesus sanoi, »jos se kerran on hänen, niin antakaa se sitten hänelle. Mutta antakaa Jumalalle se mikä on Jumalan!» Tämä vastaus tukki heidän suunsa. ");
INSERT INTO fin_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sitten astuivat esiin saddukeukset, jotka eivät usko ylösnousemukseen. He puolestaan kysyivät: ");
INSERT INTO fin_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","»Opettaja, Mooses antoi meille lain, jossa sanotaan, että kun mies kuolee lapsettomana, hänen veljensä on mentävä naimisiin lesken kanssa, ja lapset tulevat kuolleen veljen nimiin. ");
INSERT INTO fin_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oli seitsemän veljestä. Vanhin heistä meni naimisiin ja kuoli jättämättä jälkeensä lapsia. ");
INSERT INTO fin_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Niinpä toinen veli meni lesken kanssa naimisiin, mutta pian hänkin kuoli lapsettomana. Sitten seuraava veli nai lesken ja kuoli ilman lapsia, ");
INSERT INTO fin_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ja niin edelleen, kunnes kaikki veljekset olivat kuolleet ilman ainuttakaan lasta. Lopuksi myös nainen kuoli. ");
INSERT INTO fin_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sano nyt, kenen vaimoksi tuo nainen joutuu, kun kuolleet nousevat ylös – hänhän on ollut naimisissa heidän jokaisen kanssa?» ");
INSERT INTO fin_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jeesus sanoi heille: »Teidän ongelmanne on siinä, ettette tunne Raamattua ettekä Jumalan voimaa. ");
INSERT INTO fin_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sillä kun nämä seitsemän veljestä ja tuo nainen kerran nousevat kuolleista, niin he eivät enää ole avioliitossa, vaan he ovat kuin enkelit. ");
INSERT INTO fin_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ja mitä tulee ylösnousemuksen toteutumiseen, niin ettekö ole lukeneet, mitä Mooseksen kirjassa kerrotaan palavasta pensaasta? Jumala sanoi Moosekselle: ’Minä olen Aabrahamin Jumala ja minä olen Iisakin Jumala ja minä olen Jaakobin Jumala!’ ");
INSERT INTO fin_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Jumala ei todellakaan ole kuolleiden Jumala, vaan elävien. Teillä on asioista kokonaan väärä käsitys.» ");
INSERT INTO fin_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yksi keskustelua kuunnellut lainopettaja oli pannut merkille Jeesuksen terävän vastauksen ja tuli kysymään: »Mikä on kaikista käskyistä tärkein?» ");
INSERT INTO fin_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jeesus vastasi: »Se, jossa sanotaan: ’Kuule Israel! Herra, meidän Jumalamme, on yksi ja ainoa Jumala. ");
INSERT INTO fin_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Rakasta häntä kaikesta sydämestäsi, sielustasi, mielestäsi ja voimastasi.’ ");
INSERT INTO fin_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Toinen on tämä: ’Rakasta lähimmäistäsi yhtä paljon kuin itseäsi.’ Nämä ovat käskyistä suurimmat.» ");
INSERT INTO fin_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kysyjä vastasi: »Olet oikeassa – on vain yksi Jumala eikä ole ketään muuta Jumalaa. ");
INSERT INTO fin_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tiedän, että kaikkia uhreja tärkeämpää on rakastaa Jumalaa koko sydämestään, ymmärryksestään ja voimastaan ja toisia ihmisiä niin kuin itseään.» ");
INSERT INTO fin_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jeesus huomasi miehen ymmärtäneen, mistä oli kysymys, ja sanoi hänelle: »Sinä et ole kaukana Jumalan valtakunnasta.» Sen jälkeen ei kukaan enää uskaltanut esittää kysymyksiä. ");
INSERT INTO fin_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Opettaessaan myöhemmin kansaa temppelialueella Jeesus kysyi kuulijoilta: »Miksi teidän hengelliset johtomiehenne väittävät, että Messiaan täytyy olla kuningas Daavidin jälkeläinen? ");
INSERT INTO fin_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Itsehän Daavid sanoi – ja Pyhä Henki puhui näin hänen välityksellään: ’Jumala sanoi Herralleni: istu oikealla puolellani, kunnes alistan vihollisesi sinun valtaasi.’ ");
INSERT INTO fin_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Kun Daavid kutsui häntä Herrakseen, kuinka hän voi olla Daavidin poika?» Tällainen päättely kiinnosti kovasti kansanjoukkoa. ");
INSERT INTO fin_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jeesus neuvoi ihmisiä: »Varokaa lainopettajianne. He pukeutuvat kyllä kovin mielellään rikkaiden ja oppineiden viittoihin ja haluavat kaikkien kumartavan heille, kun he kävelevät kauppapaikoilla. ");
INSERT INTO fin_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Hyvin mielellään he istuvat synagogien parhailla istuimilla ja juhlapäivällisten kunniapaikoilla, ");
INSERT INTO fin_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","mutta kuitenkin riistävät leskiltä heidän kotinsa ja sitten – peittääkseen todellisen luontonsa – teeskentelevät hurskasta: latelevat julkisilla paikoilla pitkiä rukouksia. Siksi on heidän tuomionsa ankara.» ");
INSERT INTO fin_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sen jälkeen Jeesus meni temppelin kolehtiarkkujen luo ja katseli, kun ihmiset pudottivat niihin rahaa. Jotkut, jotka olivat rikkaita, antoivat suuria summia. ");
INSERT INTO fin_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sitten eräs köyhä leski pudotti pari kolikkoa. ");
INSERT INTO fin_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jeesus kutsui oppilaansa luokseen ja sanoi: »Tämä köyhä leski antoi todellisuudessa enemmän kuin nuo kaikki rikkaat yhteensä. ");
INSERT INTO fin_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Hehän antoivat vain vähän ylijäämästään, mutta leski lahjoitti viimeiset lanttinsa.» ");
INSERT INTO fin_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kun Jeesus sinä päivänä oli lähdössä temppelistä, yksi hänen oppilaansa sanoi: »Katso, opettaja, miten jyhkeät kivet ja valtavat rakennukset.» ");
INSERT INTO fin_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jeesus vastasi: »Se on totta, mutta niistä ei jää kiveä kiven päälle – vain raunioita.» ");
INSERT INTO fin_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kun Jeesus istui Öljymäen rinteellä Jerusalemia vastapäätä, Pietari, Jaakob, Johannes ja Andreas tulivat muiden luota kysymään häneltä: ");
INSERT INTO fin_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","»Milloin temppeli hävitetään? Voiko sitä mistään tietää?» ");
INSERT INTO fin_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jeesus selitti: »Älkää antako kenenkään johtaa itseänne harhaan. ");
INSERT INTO fin_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ilmaantuu nimittäin useita sellaisia ihmisiä, jotka julistavat olevansa teidän vapahtajianne ja jotka johtavat monia eksyksiin. ");
INSERT INTO fin_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Sotia syttyy lähellä ja kaukana, mutta tämä ei vielä merkitse loppua. ");
INSERT INTO fin_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kansat ja valtakunnat julistavat sodan toisiaan vastaan, ja monissa maissa on maanjäristyksiä ja nälänhätää. Nämä ovat vasta tulossa olevan ahdistuksen esimakua. ");
INSERT INTO fin_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mutta kun tällaista alkaa tapahtua, olkaa varuillanne, sillä olette suuressa vaarassa. Teidät vedetään oikeuteen, teitä lyödään synagogissa, ja teitä syytetään maaherrojen ja kuninkaiden edessä minun seuraamisestani. Silloin teillä on tilaisuus kertoa heille minusta. ");
INSERT INTO fin_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Hyvän uutisen täytyy ensin tulla jokaisen kansan tietoon, ennen kuin loppu tulee. ");
INSERT INTO fin_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mutta kun teidät on pidätetty ja seisotte kuulusteltavina, älkää huolehtiko siitä, miten puolustaudutte. Sanokaa vain se, mitä Jumala antaa teille sanottavaksi. Silloin ette puhu te, vaan Pyhä Henki. ");
INSERT INTO fin_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Veljekset kavaltavat toisensa, isät ilmiantavat omat lapsensa kuolemaan ja lapset vanhempansa. ");
INSERT INTO fin_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kaikki vihaavat teitä, koska olette minun omiani. Mutta ne, jotka kestävät loppuun asti kieltämättä minua, pelastuvat. ");
INSERT INTO fin_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kun näette ’kauhistuksen’ olevan siellä, missä sen ei pitäisi olla – temppelissä – paetkaa Juudean vuorille, jos voitte. Kiirehtikää! ");
INSERT INTO fin_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Jos olette kattotasanteillanne, älkää menkö edes takaisin taloon. ");
INSERT INTO fin_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jos olette ulkona pellolla, älkää palatko hakemaan ruokaa tai vaatteita. ");
INSERT INTO fin_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Voi odottavia äitejä ja niitä, joilla on pikkulapsia! ");
INSERT INTO fin_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Rukoilkaa, ettei teidän pakonne tapahtuisi talvella. ");
INSERT INTO fin_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nuo päivät ovat sellaisia kauhun päiviä, ettei vastaavaa ole koettu Jumalan luomistyön alkamisesta saakka eikä enää tulla kokemaan. ");
INSERT INTO fin_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ellei Herra lyhentäisi tuota aikaa, ei yksikään ihminen maailmassa pelastuisi. Mutta valitsemiensa ihmisten tähden hän rajoittaa noiden päivien määrää. ");
INSERT INTO fin_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Jos joku sanoo silloin teille: ’Tämä tai tuo on Messias’, älkää uskoko. ");
INSERT INTO fin_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Monet valevapahtajat ja väärät profeetat tekevät silloin ihmeitä ja pettävät, jos mahdollista, jopa Jumalan omatkin. ");
INSERT INTO fin_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Olkaa varuillanne! Minä olen varoittanut teitä. ");
INSERT INTO fin_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ahdistuksen ajan jälkeen aurinko pimenee, kuu menettää loisteensa ");
INSERT INTO fin_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ja tähdet putoilevat: taivaat järkkyvät. ");
INSERT INTO fin_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Silloin koko ihmiskunta näkee minun, joka olen lähetetty taivaasta, tulevan pilvissä voimassani ja kunniassani. ");
INSERT INTO fin_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Lähetän myös enkelini kokoamaan yhteen valitsemani ihmiset kaikkialta maailmasta – maan ja taivaan ääristä. ");
INSERT INTO fin_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mitä viikunapuu meille opettaa? Kun sen silmut alkavat puhjeta ja lehdet työntyä esiin, te tiedätte, että kevät on tullut. ");
INSERT INTO fin_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ja kun te näette kaiken kuvaamani tapahtuvan, voitte olla varmat, että paluuni on hyvin lähellä – minä olen silloin jo ovella. ");
INSERT INTO fin_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nämä tapahtumat ovat merkki tälle sukupolvelle ajan loppumisesta. ");
INSERT INTO fin_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Taivas ja maa katoavat, mutta minun sanani pysyvät varmoina ikuisesti. ");
INSERT INTO fin_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kuitenkaan ei kukaan – eivät edes taivaan enkelit enkä minä itsekään, – tiedä sitä päivää tai tuntia, jolloin tämä tapahtuu; vain Isä sen tietää. ");
INSERT INTO fin_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ja koska ette tiedä, milloin palaan, olkaa jatkuvasti valmiina! ");
INSERT INTO fin_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Minun takaisintuloni on verrattavissa ulkomaille matkustaneen miehen kotiinpaluuseen. Hän selitti työntekijöilleen, mitä heidän tehtäviinsä kuuluisi hänen poissaollessaan, ja ovenvartijan hän käski olla valmiina, tulipa hän milloin tahansa. ");
INSERT INTO fin_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Odottakaa minua joka hetki, sillä ette tiedä milloin minä tulen – illalla, keskiyöllä, aamuvarhaisella vai päivänkoitteessa. ");
INSERT INTO fin_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Katsokaa, etten löydä teitä nukkumasta! ");
INSERT INTO fin_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Odottakaa minun paluutani! Tämä on minun sanomani teille ja kaikille muille.» ");
INSERT INTO fin_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Kahden päivän päästä alkoi juutalaisten pääsiäinen ja happamattoman leivän juhla-aika. Ylipapit ja lainopettajat odottivat jatkuvasti tilaisuutta pidättääkseen Jeesuksen kaikessa hiljaisuudessa ja surmauttaakseen hänet. ");
INSERT INTO fin_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","»Mutta pääsiäisen aikana emme voi sitä tehdä», he sanoivat. »Muuten syntyy mellakka.» ");
INSERT INTO fin_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jeesus oli siihen aikaan Betaniassa, lepraa sairastavan Simonin kotona. Aterian aikana sinne tuli eräs nainen mukanaan hyvin arvokas voideastia. Lyötyään astian rikki hän valeli voiteen Jeesuksen päähän. ");
INSERT INTO fin_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Muutamat pöydässä istuvat pahoittelivat tätä voiteen »haaskausta», joksi he sitä nimittivät. ");
INSERT INTO fin_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","»Nainenhan olisi voinut myydä voiteen kalliiseen hintaan ja antaa rahat köyhille», he mutisivat. ");
INSERT INTO fin_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Mutta Jeesus sanoi: »Jättäkää hänet rauhaan; miksi moititte häntä hyvän tekemisestä? ");
INSERT INTO fin_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Keskuudessanne on aina köyhiä, jotka tarvitsevat apuanne. Teillä on mahdollisuus auttaa heitä milloin tahdotte, mutta minä en ole täällä enää kauan. ");
INSERT INTO fin_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tämä nainen teki mitä voi; hän voiteli minun ruumiini edeltäpäin hautaamista varten. ");
INSERT INTO fin_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ja todellakin, kaikkialla maailmassa, missä julistetaan ilosanomaa minusta, muistetaan ja ylistetään tämän naisen tekoa.» ");
INSERT INTO fin_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Silloin yksi Jeesuksen oppilas, Juudas Iskariot, meni ylipappien luo sopimaan Jeesuksen kavaltamisesta. ");
INSERT INTO fin_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Kun papit kuulivat hänen asiansa, he ihastuivat siinä määrin, että lupasivat hänelle palkkionkin. Niinpä Juudas alkoi miettiä, miten saisi sopivan tilaisuuden kavaltaa Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pääsiäisjuhlan alkaessa – sinä päivänä, jona pääsiäislammas syödään – Jeesuksen oppilaat kysyivät häneltä, missä hän halusi syödä perinnäistapoihin kuuluvan pääsiäisaterian. ");
INSERT INTO fin_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Hän lähetti kaksi oppilastaan edeltä tekemään järjestelyjä. »Kun pääsette Jerusalemiin», hän sanoi heille, »teitä vastaan tulee vesiastiaa kantava mies. Menkää hänen perässään taloon, jonne hän kääntyy. ");
INSERT INTO fin_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Sanokaa talon isännälle: ’Mestarimme lähetti meidät katsomaan sitä huonetta, jonka sinä olet varannut meille täksi illaksi pääsiäisaterian viettoon.’ ");
INSERT INTO fin_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Isäntä vie teidät yläkertaan suureen huoneeseen, joka on juhlakunnossa. Valmistakaa meidän illallisemme sinne.» ");
INSERT INTO fin_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ne kaksi Jeesuksen oppilasta lähtivät edeltä kaupunkiin. He tapasivat miehen, löysivät huoneen ja valmistivat sen pääsiäisenviettoa varten Jeesuksen ohjeiden mukaan. ");
INSERT INTO fin_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Illalla saapui Jeesus toisten oppilaiden kanssa. ");
INSERT INTO fin_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Kun he olivat pöydän ympärillä syömässä, Jeesus sanoi surullisena: »Yksi teistä pettää minut – yksi teistä, jotka olette minun kanssani tällä aterialla.» ");
INSERT INTO fin_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Sen kuullessaan oppilaat tulivat pahoille mielin ja kysyivät toinen toisensa jälkeen: »Olenko se minä?» ");
INSERT INTO fin_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jeesus vastasi: »Hän on yksi teistä kahdestatoista, jotka olette aterialla minun kanssani. ");
INSERT INTO fin_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Minunhan täytyy kuolla, niin kuin profeetat jo kauan sitten julistivat, mutta voi miten käykään sen, joka minut pettää – hänelle olisi ollut parempi, ettei hän olisi syntynyt!» ");
INSERT INTO fin_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Aterian aikana Jeesus otti leivän käteensä ja pyysi sille Jumalan siunausta. Sitten hän mursi sen palasiksi, antoi ne oppilailleen ja sanoi: »Syökää tämä – se on minun ruumiini.» ");
INSERT INTO fin_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sen jälkeen hän otti viinimaljan, kiitti siitä Jumalaa ja antoi sen heille; he kaikki joivat siitä. ");
INSERT INTO fin_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Hän sanoi: »Tämä on minun vereni, joka vuodatetaan ihmisten puolesta ja joka vahvistaa uuden liiton Jumalan ja ihmisten välille. ");
INSERT INTO fin_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Minä vakuutan teille, etten maista viiniä, ennen kuin juon uutta viiniä Jumalan valtakunnassa.» ");
INSERT INTO fin_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sitten he lauloivat kiitosvirren ja lähtivät ulos Öljymäelle. ");
INSERT INTO fin_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","»Kaikki te hylkäätte minut», Jeesus sanoi heille, »sillä Jumala on julistanut profeettojen välityksellä: ’Minä surmaan paimenen, ja lampaat joutuvat hajalle.’ ");
INSERT INTO fin_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kuolleista noustuani minä menen Galileaan ja tapaan teidät sitten siellä.» ");
INSERT INTO fin_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pietari sanoi hänelle: »Minä ainakaan en jätä sinua, vaikka toiset jättäisivätkin!» ");
INSERT INTO fin_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","»Pietari», Jeesus sanoi, »ennen kuin kukko kiekuu toisen kerran huomenaamuna, sinä olet ehtinyt kieltää minut jo kolme kertaa.» ");
INSERT INTO fin_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","»En ikinä», Pietari huudahti. »Ei, vaikka minun täytyisi kuolla sinun kanssasi. Minä en ikinä kiellä sinua!» Kaikki toisetkin vakuuttivat samaa. ");
INSERT INTO fin_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","He tulivat öljypuumetsikköön, jonka nimi oli Getsemane. Jeesus sanoi oppilailleen: »Istukaa tähän siksi aikaa kun menen rukoilemaan.» ");
INSERT INTO fin_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Hän otti mukaansa Pietarin, Jaakobin ja Johanneksen. Jeesus joutui kauhun ja ahdistuksen valtaan ");
INSERT INTO fin_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ja sanoi heille: »Sydämeni on murtumaisillaan tuskasta. Istukaa tässä ja valvokaa minun kanssani.» ");
INSERT INTO fin_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Hän meni jonkin matkan päähän, heittäytyi maahan ja rukoili, että lähestyvää kauhun hetkeä ei tulisi, jos se vain suinkin olisi mahdollista. ");
INSERT INTO fin_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","»Isä, Isä», hän sanoi, »kaikki on sinulle mahdollista. Ota minulta pois tämä malja. Haluan kuitenkin, että tapahtuu sinun tahtosi – ei minun.» ");
INSERT INTO fin_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sitten hän palasi noiden kolmen oppilaan luo ja löysi heidät nukkumasta. »Simon», hän sanoi, »nukutko? Etkö jaksanut valvoa kanssani edes yhtä tuntia? ");
INSERT INTO fin_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Valvokaa kanssani ja rukoilkaa, ettei kiusaaja saisi teitä valtaansa. Teillä on kyllä hyvää tahtoa, mutta ei voimaa.» ");
INSERT INTO fin_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Hän meni taas sivummalle ja esitti uudestaan pyyntönsä Jumalalle. ");
INSERT INTO fin_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jälleen hän palasi heidän luokseen ja tapasi heidät nukkumasta, sillä he olivat hyvin väsyneitä. He eivät enää tienneet, mitä sanoa. ");
INSERT INTO fin_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kun hän kolmannen kerran palasi heidän luokseen, hän sanoi: »Nukkukaa te vain. Levähtäkää vähän. Mutta ei – ei nyt ole enää aika nukkua. Minut kavalletaan ja annetaan jumalattomien ihmisten käsiin. ");
INSERT INTO fin_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Herätkää! Meidän täytyy lähteä. Katsokaa, minun pettäjäni on täällä!» ");
INSERT INTO fin_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Juuri silloin, Jeesuksen vielä puhuessa, tuli paikalle Juudas, yksi hänen oppilaistaan. Juudaksen kanssa oli miekoin ja seipäin aseistautunut ihmisjoukko, jonka ylipapit, lainopettajat ja muut kansanjohtajat olivat lähettäneet. ");
INSERT INTO fin_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Juudas oli sanonut heille: »Te tiedätte, kuka on Jeesus, kun minä tervehdin häntä. Silloin voitte helposti ottaa hänet kiinni.» ");
INSERT INTO fin_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Heti, kun he olivat tulleet tarpeeksi lähelle, Juudas meni Jeesuksen eteen. »Mestari», Juudas huudahti ja suuteli häntä teeskennellen ystävyyttä. ");
INSERT INTO fin_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Silloin ihmisjoukko kävi Jeesukseen käsiksi ja vangitsi hänet. ");
INSERT INTO fin_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mutta yksi oppilaista veti esiin miekan ja löi sillä ylipapin palvelijalta korvan irti. ");
INSERT INTO fin_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jeesus kysyi ihmisjoukolta: »Olenko minä vaarallinen rikollinen, kun te tulette tällä tavoin aseistautuneina ottamaan minua kiinni? ");
INSERT INTO fin_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Miksi ette vanginneet minua temppelissä? Minähän opetin siellä joka päivä. Mutta tämä tapahtuu, jotta toteutuisi kaikki, mitä minusta jo etukäteen on kirjoitettu.» ");
INSERT INTO fin_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tällä välin Jeesuksen oppilaat olivat lähteneet pakoon. ");
INSERT INTO fin_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Siellä oli vielä eräs joukon jäljessä seurannut nuori poika, joka oli yöpuvussa. Kun muutamat kansanjoukosta yrittivät ottaa hänet kiinni, ");
INSERT INTO fin_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","hän riuhtaisi itsensä vapaaksi, niin että hänen vaatteensa jäivät kiinniottajien käsiin, ja juoksi pakoon aivan alastomana. ");
INSERT INTO fin_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jeesus vietiin ylipapin luo. Sinne kokoontuivat nopeasti kaikki korkea-arvoisimmat papit ja juutalaisten kansanjohtajat. ");
INSERT INTO fin_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pietari seurasi kaukana perässä ja pujahti ylipapin talon portista sisään. Palvelijoilla oli pihalla nuotio, ja Pietari kyyristyi heidän joukkoonsa lämmittelemään. ");
INSERT INTO fin_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sisällä ylipapit ja koko juutalaisten neuvosto yrittivät löytää Jeesusta vastaan sellaista, minkä nojalla hänet voitaisiin tuomita kuolemaan. Mutta he eivät onnistuneet. ");
INSERT INTO fin_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Hankittiin useita vääriä todistajia, mutta he puhuivat keskenään ristiin. ");
INSERT INTO fin_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Tosin muutamat miehet valehtelivat: ");
INSERT INTO fin_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","»Me olemme kuulleet hänen sanovan: ’Minä hävitän tämän ihmisten rakentaman temppelin ja pystytän kolmessa päivässä uuden, joka on rakennettu ilman ihmisten apua!’» ");
INSERT INTO fin_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mutta nytkään he eivät saaneet kertomuksia sopimaan toisiinsa. ");
INSERT INTO fin_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Silloin ylipappi astui oikeuden eteen ja kysyi Jeesukselta: »Kieltäydytkö vastaamasta tähän syytökseen? Mitä sanottavaa sinulla on puolustukseksesi?» ");
INSERT INTO fin_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jeesus ei vastannut mitään. Silloin ylipappi kysyi häneltä: »Oletko sinä Messias, Jumalan Poika?» ");
INSERT INTO fin_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jeesus sanoi: »Olen. Ja te näette vielä minun istuvan Jumalan oikealla puolella ja palaavan maan päälle taivaan pilvissä.» ");
INSERT INTO fin_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Silloin ylipappi repäisi pukunsa ja sanoi: »Mitä muita todisteita me enää tarvitsemme? ");
INSERT INTO fin_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Olette kuulleet, kuinka hän pilkkaa Jumalaa. Miten te hänet tuomitsisitte?» Äänestyksen tulos oli yksimielinen: kuolemantuomio. ");
INSERT INTO fin_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jotkut sylkivät hänen päälleen. Toiset sitoivat hänen silmänsä ja hakkasivat häntä nyrkillä. »Hei, profeetta, kuka sinua nyt löi?» he ilkkuivat. Vartijatkin käyttivät nyrkkejä viedessään häntä pois. ");
INSERT INTO fin_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","67","Sillä välin Pietari oli alhaalla pihalla. Eräs ylipapin palvelustyttö huomasi hänet lämmittelemässä nuotion ääressä. Palvelustyttö tarkasteli häntä hetken ja huomautti sitten: »Sinä olit sen nasaretilaisen kanssa.» ");
INSERT INTO fin_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","»En ollut! En edes ymmärrä, mistä sinä puhut!» hän sanoi ja käveli pihan laitaan. Juuri silloin kiekui kukko. ");
INSERT INTO fin_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Tyttö näki Pietarin siellä ja selitti toisille: »Tuolla hän on! Hän on Jeesuksen oppilaita!» ");
INSERT INTO fin_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Jälleen Pietari kielsi kaiken. Jonkin ajan päästä muut nuotion ympärillä seisoskelevat alkoivat tivata Pietarilta: »Oletko sinäkin yksi heistä, sillä Galileastahan sinä olet!» ");
INSERT INTO fin_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pietari kirosi ja vannoi Jumalan nimeen: »En tunne tätä miestä, josta te puhutte», hän sanoi, ");
INSERT INTO fin_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ja silloin kukko kiekui toisen kerran. Pietarin mielessä välähtivät Jeesuksen sanat: »Ennen kuin kukko kaksi kertaa kiekuu, sinä kiellät minut jo kolme kertaa.» Hän purskahti katkeraan itkuun. ");
INSERT INTO fin_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Aikaisin aamulla kokoontui koko suuri neuvosto – ylipapit, kansanjohtajat ja lainopettajat – keskustelemaan tilanteesta. Jeesus päätettiin lähettää aseistettujen vartijoiden saattamana roomalaisen maaherran, Pilatuksen, luo. ");
INSERT INTO fin_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus kysyi Jeesukselta: »Oletko sinä juutalaisten kuningas?» »Olen», Jeesus vastasi. »Niin on kuin sinä sanoit.» ");
INSERT INTO fin_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sitten ylipapit syyttivät häntä monista rikoksista, ");
INSERT INTO fin_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ja Pilatus kysyi häneltä: »Miksi et puhu mitään? Mitä sanottavaa sinulla on näihin syytöksiin?» ");
INSERT INTO fin_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pilatuksen suureksi hämmästykseksi Jeesus ei sanonut yhtään mitään. ");
INSERT INTO fin_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilatuksella oli tapana joka vuosi pääsiäisjuhlien aikana vapauttaa joku juutalaisista vangeista – kenet tahansa ihmiset häneltä pyysivät. ");
INSERT INTO fin_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Yksi silloisista vangeista oli Barabbas, joka oli muutamien muiden kanssa vangittu murhasta erään kapinahankkeen yhteydessä. ");
INSERT INTO fin_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nyt ihmisjoukko alkoi tungeksia Pilatuksen luo pyytämään, että hän taas vapauttaisi jonkun vangin, niin kuin oli ollut tapana. ");
INSERT INTO fin_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","»Mitä sanotte, jos annan teille ’juutalaisten kuninkaan’?» Pilatus kysyi. »Hänetkö haluatte vapaaksi?» ");
INSERT INTO fin_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Hän oli näet ymmärtänyt kaiken olevan ylipappien aikaansaannosta, koska he kadehtivat Jeesuksen kansansuosiota. ");
INSERT INTO fin_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mutta ylipapit yllyttivät kansaa vaatimaan, että Jeesuksen sijasta vapautettaisiin Barabbas. ");
INSERT INTO fin_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","»Jos vapautan Barabbaan, niin mitä minun sitten pitäisi tehdä tälle miehelle, jota te kutsutte kuninkaaksenne?» Pilatus kysyi. ");
INSERT INTO fin_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Kansanjoukko huusi: »Ristiinnaulitse hänet!» ");
INSERT INTO fin_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","»Mutta miksi?» Pilatus kysyi. »Mitä pahaa hän on tehnyt?» Yhä kovemmin huudettiin: »Ristiinnaulitse hänet!» ");
INSERT INTO fin_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatus pelkäsi, että syntyisi mellakka, ja koska hän halusi olla kansalle mieliksi, hän vapautti Barabbaan. Jeesuksen hän määräsi ruoskittavaksi lyijyllä vahvistetulla ruoskalla ja lähetti hänet sitten ristiinnaulittavaksi. ");
INSERT INTO fin_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Roomalaiset sotilaat veivät Jeesuksen maaherran palatsin pihalle ja kutsuivat paikalle koko palatsin henkivartioston. ");
INSERT INTO fin_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","He pukivat Jeesuksen tummanpunaiseen viittaan, väänsivät kruunun teräväpiikkisistä orjantappuran oksista ja panivat sen hänen päähänsä. ");
INSERT INTO fin_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sitten he tekivät hänelle kunniaa ja huusivat: »Terve, juutalaisten kuningas!» ");
INSERT INTO fin_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","He myös hakkasivat häntä kepillä päähän, sylkivät häntä kasvoihin ja polvistuivat muka kumartamaan häntä. ");
INSERT INTO fin_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Kun sotilaat väsyivät ilveilyyn, he riisuivat Jeesukselta punaisen viitan ja pukivat hänen omat vaatteensa takaisin hänen ylleen. Sitten he veivät hänet ristiinaulittavaksi. ");
INSERT INTO fin_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Matkalla he pakottivat Simon Kyreneläisen, joka juuri silloin palasi maalta, kantamaan Jeesuksen ristiä. (Simon on Aleksanderin ja Rufuksen isä.) ");
INSERT INTO fin_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","He veivät Jeesuksen paikkaan, jonka nimi on Golgata. (Nimi tarkoittaa pääkalloa.) ");
INSERT INTO fin_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Siellä Jeesukselle tarjottiin viiniä, johon oli sekoitettu huumaavaa ainetta, mutta hän ei huolinut siitä. ");
INSERT INTO fin_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sitten he ristiinnaulitsivat hänet – ja heittivät arpaa hänen vaatteistaan. ");
INSERT INTO fin_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ristiinnaulitseminen tapahtui noin kello yhdeksän aamulla. ");
INSERT INTO fin_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ristiin Jeesuksen pään yläpuolelle kiinnitettiin kilpi, josta kävi ilmi hänen rikoksensa. Siinä luki: »Juutalaisten kuningas.» ");
INSERT INTO fin_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tuona aamuna ristiinnaulittiin myös muita – kaksi rikollista, joiden ristit seisoivat Jeesuksen kummallakin puolella. ");
INSERT INTO fin_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Näin toteutui Raamatun ennustus: »Hänen katsottiin kuuluvan pahantekijöiden joukkoon.» ");
INSERT INTO fin_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ristin ohi kulkevat pilkkasivat Jeesusta ja nyökyttelivät ilkkuen päätään: »Siitä sait! Ja sinä muka pystyt hajottamaan temppelin maan tasalle ja rakentamaan sen kolmessa päivässä uudelleen! ");
INSERT INTO fin_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jos kerran olet niin ihmeellinen, niin pelasta itsesi ja tule alas sieltä ristiltä.» ");
INSERT INTO fin_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Myös ylipappeja ja muita juutalaisten johtomiehiä seisoi siellä Jeesusta pilkkaamassa. »Hän on kovin taitava pelastamaan muita», he sanoivat, »mutta itseään hän ei pysty auttamaan!» ");
INSERT INTO fin_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","»Hei siellä, messias!» he huusivat hänelle. »Sinä ’Israelin kuningas’! Tule alas ristiltä, niin me uskomme sinuun!» Vieläpä ne kaksi rikollista, jotka kituivat yhdessä hänen kanssaan, kirosivat häntä. ");
INSERT INTO fin_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Keskipäivän aikaan tuli koko maahan pimeys, jota kesti iltapäivään noin kolmeen asti. ");
INSERT INTO fin_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jeesus huusi silloin kovalla äänellä: »Eli, Eli, lama sabaktani?» »Jumalani, Jumalani, miksi hylkäsit minut?» ");
INSERT INTO fin_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jotkut ympärillä seisovista luulivat, että hän kutsui profeetta Eliaa. ");
INSERT INTO fin_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Silloin eräs mies juoksi ottamaan sienen, kostutti sen happamaan viiniin ja kurkotti sienen kepin avulla Jeesuksen huulille. »Saa nähdä, tuleeko Elia auttamaan hänet alas!» hän sanoi. ");
INSERT INTO fin_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jeesus huusi jälleen kovalla äänellä ja antoi henkensä. ");
INSERT INTO fin_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Silloin temppelin väliverho repeytyi kahtia ylhäältä alas. ");
INSERT INTO fin_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kun Jeesuksen ristin juurella seisova roomalainen upseeri näki Jeesuksen kuoleman, hän huudahti: »Tämä oli todella Jumalan Poika!» ");
INSERT INTO fin_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Siellä oli myös muutamia naisia, jotka seurasivat tapahtumien kulkua matkan päästä – Maria Magdaleena, Maria, nuoremman Jaakobin ja Jooseen äiti, Salome sekä muita. ");
INSERT INTO fin_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","He ja monet muut Galilean naiset, jotka olivat liittyneet Jeesuksen oppilasjoukkoon ja palvelleet häntä Galileassa, olivat tulleet hänen mukanaan Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tämä kaikki tapahtui sapatin aattona. ");
INSERT INTO fin_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Illansuussa tuli paikalle arimatialainen Joosef, juutalaisten suuren neuvoston kunnianarvoisa jäsen, joka hänkin odotti innokkaasti Jumalan valtakunnan tuloa. Hän keräsi kaiken rohkeutensa ja meni pyytämään Pilatukselta Jeesuksen ruumista. ");
INSERT INTO fin_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatus ei ollut uskoa, että Jeesus olisi jo kuollut. Hän kutsui sen vuoksi luokseen ristiinnaulitsemisista vastaavan roomalaisen upseerin ja tiedusteli asiaa häneltä. ");
INSERT INTO fin_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kun upseeri oli ilmoittanut Jeesuksen kuolleen, Pilatus sanoi Joosefille, että tämä saisi viedä ruumiin. ");
INSERT INTO fin_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joosef osti pitkän pellavaliinan, otti Jeesuksen ruumiin alas ristiltä, kääri liinan sen ympärille ja vei ruumiin kallioon hakattuun hautaan. Haudan oviaukkoon hän vieritti kiven. ");
INSERT INTO fin_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Magdaleena ja Maria, Jooseen äiti, seisoivat katselemassa, kun Jeesus pantiin hautaan. ");
INSERT INTO fin_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kun sapatti seuraavana iltana päättyi, Maria Magdaleena, Salome ja Maria, Jaakobin äiti, menivät ostamaan balsamointivoiteita. ");
INSERT INTO fin_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Seuraavana aamuna he lähtivät jo auringonnousun aikaan viemään niitä haudalle. ");
INSERT INTO fin_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Matkalla he miettivät, miten ihmeessä saisivat vieritetyksi syrjään suuren kiven, joka sulki hautakammion oviaukon. ");
INSERT INTO fin_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mutta paikalle tullessaan he näkivät, että kivi oli jo siirretty syrjään. ");
INSERT INTO fin_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","He menivät hautakammioon sisälle, ja siellä, oikealla puolella, istui nuori mies, jolla oli valkoiset vaatteet. Naiset säikähtivät, ");
INSERT INTO fin_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","mutta enkeli sanoi: »Älkää pelästykö. Tehän etsitte Jeesusta, nasaretilaista, joka ristiinnaulittiin. Ei hän ole täällä! Hän on palannut elämään. Katsokaa, tässä hänen ruumiinsa oli. ");
INSERT INTO fin_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Menkää nyt viemään tämä sanoma Pietarille ja muille hänen oppilailleen: Jeesus menee teidän edellänne Galileaan. Te saatte nähdä hänet siellä, aivan niin kuin hän teille ilmoitti ennen kuolemaansa.» ");
INSERT INTO fin_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Naiset pakenivat kiireesti haudalta. He olivat niin säikähdyksissään, etteivät uskaltaneet puhua kenellekään näkemästään. ");
INSERT INTO fin_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jeesuksen ylösnousemus tapahtui varhain sunnuntaiaamuna. Ensimmäinen ihminen, joka hänet näki, oli Maria Magdaleena – nainen, jonka hän oli vapauttanut seitsemästä riivaajahengestä. ");
INSERT INTO fin_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Maria löysi Jeesuksen oppilaat murheen murtamina ja vakuutti heille innoissaan, että hän oli nähnyt Jeesuksen ja että tämä oli elossa. Mutta kukaan ei uskonut häntä. ");
INSERT INTO fin_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Myöhemmin Jeesus ilmestyi kahdelle miehelle, jotka olivat matkalla Jerusalemista maaseudulle. He eivät ensin tunteneet häntä, koska hän oli erilainen kuin ennen. ");
INSERT INTO fin_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Kun he viimein tajusivat, kuka hän oli, he ryntäsivät takaisin Jerusalemiin kertomaan toisille, mutta heitäkään ei uskottu. ");
INSERT INTO fin_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Vielä myöhemmin Jeesus ilmestyi yhdelletoista oppilaalleen näiden ollessa aterialla. Hän moitti heitä epäuskosta – että he olivat itsepäisesti kieltäytyneet uskomasta niitä, jotka olivat nähneet hänet ylösnousseena. ");
INSERT INTO fin_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sitten hän sanoi heille: »Menkää nyt kaikkialle maailmaan ja kertokaa Jumalan hyvä uutinen kaikille ihmisille. ");
INSERT INTO fin_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ne, jotka uskovat ja kastetaan, saavat ikuisen elämän. Mutta ne, jotka kieltäytyvät uskomasta, tuomitaan. ");
INSERT INTO fin_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ne, jotka uskovat, saavat minulta voiman tehdä tunnustekoja: minun nimessäni he ajavat pahoja henkiä ihmisistä ja puhuvat uusilla kielillä. ");
INSERT INTO fin_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","He voivat koskea turvallisesti jopa käärmeisiin, ja jos he juovat jotakin myrkyllistä, se ei vahingoita heitä. He panevat myös kätensä sairaiden päälle ja parantavat heidät.» ");
INSERT INTO fin_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kun Herra Jeesus oli lakannut puhumasta heille, hänet kohotettiin ylös taivaaseen, ja hän istui Jumalan oikealle puolelle. ");
INSERT INTO fin_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jeesuksen oppilaat lähtivät viemään kaikkialle ilosanomaa Jeesuksesta. Herra oli heidän kanssaan ja vahvisti heidän puheensa todeksi antamalla ihmeiden seurata heidän sanojaan.");
INSERT INTO fin_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Hyvä Jumalaa rakastava ystäväni Jeesuksesta on kirjoitettu jo useita elämäkertoja. Tiedot on saatu niiltä, jotka ovat itse nähneet ja kertoneet hänestä muillekin. ");
INSERT INTO fin_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Halusin kuitenkin vielä tutkia kaiken tarkasti alusta loppuun ja kertoa asiat sinulle järjestyksessä. ");
INSERT INTO fin_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Huomaat, että voit luottaa siihen, mitä sinulle on opetettu. ");
INSERT INTO fin_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kerron ensiksi juutalaisesta papista, Sakariaasta, joka eli siihen aikaan kun Herodes oli Juudean kuninkaana. Sakarias oli temppelipalvelija ja kuului Abian osastoon. Hänen vaimonsa Elisabet oli juutalaista Aaronin sukua. ");
INSERT INTO fin_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakarias ja Elisabet olivat hyviä ja hurskaita ihmisiä ja halusivat sydämestään noudattaa Jumalan lakia. ");
INSERT INTO fin_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","He olivat lapsettomia, sillä Elisabet ei ollut voinut saada lasta, ja nyt he molemmat olivat jo iäkkäitä. ");
INSERT INTO fin_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kerran, kun oli Abian osaston vuoro palvella temppelissä, Sakarias oli siellä hoitamassa tehtäväänsä. ");
INSERT INTO fin_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Arvalla ratkaistiin, kuka saisi mennä temppelin pyhimpään osaan polttamaan suitsuketta Herran edessä. Tämä kunnia tuli Sakariaan osaksi. ");
INSERT INTO fin_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jumalanpalvelukseen kokoontuneet ihmiset seisoivat toimituksen ajan temppelin pihalla ja rukoilivat. ");
INSERT INTO fin_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","12","Sakarias oli suitsutusalttarin ääressä. Äkkiä sen oikealle puolelle ilmestyi enkeli. Sakarias pelästyi suunnattomasti. ");
INSERT INTO fin_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Enkeli sanoi: »Älä pelkää, Sakarias! Tulin kertomaan, että Jumala on kuullut rukouksesi ja vaimosi Elisabet synnyttää sinulle pojan. Sinun pitää antaa hänelle nimeksi Johannes. ");
INSERT INTO fin_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kun lapsi syntyy, te ja monet muutkin tulette hyvin iloisiksi. Pojasta kasvaa suuri Jumalan mies. ");
INSERT INTO fin_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Viiniin tai väkeviin juomiin hän ei koske, ja hän on syntymästään saakka täynnä Pyhää Henkeä. ");
INSERT INTO fin_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Hän saa monet juutalaiset kääntymään Herran, heidän Jumalansa, puoleen. ");
INSERT INTO fin_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Johanneksessa on sama voima ja Henki kuin aikoinaan profeetta Eliassa, ja hän valmistaa ihmisiä Kristuksen tuloon. Hän opettaa heitä rakastamaan Herraa, niin kuin heidän esi-isänsä rakastivat, ja elämään niin kuin Jumala tahtoo.» ");
INSERT INTO fin_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakarias sanoi enkelille: »Se on mahdotonta! Minä olen jo vanha mies, ja vaimonikin on iäkäs.» ");
INSERT INTO fin_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Siihen enkeli sanoi: »Olen Gabriel, Jumalan palvelija. Jumala itse lähetti minut luoksesi kertomaan tämän iloisen uutisen. ");
INSERT INTO fin_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Koska et uskonut minua, menetät puhekykysi siihen asti, kunnes lapsi syntyy. Saat nähdä, että ennustukseni varmasti toteutuu.» ");
INSERT INTO fin_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Väkijoukko odotti Sakariasta pihalla ja kummasteli hänen viipymistään. ");
INSERT INTO fin_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kun Sakarias lopulta tuli ulos, hän ei pystynyt puhumaan, mutta hänen eleistään ihmiset ymmärsivät, että hän oli nähnyt temppelissä näyn. ");
INSERT INTO fin_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakarias jäi työvuoronsa loppuun asti temppeliin ja palasi vasta sitten kotiin. ");
INSERT INTO fin_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pian tämän jälkeen Elisabet alkoi odottaa lasta ja eristäytyi muista ihmisistä viideksi kuukaudeksi. ");
INSERT INTO fin_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","»Herra on hyvä», hän totesi onnellisena. »Enää minun ei tarvitse hävetä lapsettomuuttani.» ");
INSERT INTO fin_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kuukauden kuluttua Jumala lähetti enkeli Gabrielin Nasaretiin, erääseen Galilean kaupunkiin. ");
INSERT INTO fin_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Hän ilmestyi siellä Maria-nimiselle tytölle. Maria oli neitsyt ja kihloissa kuningas Daavidin sukuun kuuluvan Joosefin kanssa. ");
INSERT INTO fin_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Enkeli tervehti Mariaa kunnioittavasti ja jatkoi: »Jumala on siunannut sinua ja on kanssasi.» ");
INSERT INTO fin_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Hämmästynyt ja pelästynyt Maria ei ymmärtänyt, miksi enkeli hänelle näin sanoi. ");
INSERT INTO fin_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","»Älä pelkää, Maria», enkeli jatkoi. »Jumala on päättänyt antaa sinulle suuren siunauksen. ");
INSERT INTO fin_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Alat pian odottaa lasta ja saat pojan. Anna hänen nimekseen Jeesus. ");
INSERT INTO fin_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","33","Hän on suuri, hän on Jumalan Poika. Jumala tekee hänestä kuninkaan niin kuin hänen esi-isästään Daavidista, mutta Jeesuksen valtakunta, hänen Israelinsa, on ikuinen.» ");
INSERT INTO fin_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria kysyi enkeliltä: »Miten minä, joka olen neitsyt, voisin saada lapsen?» ");
INSERT INTO fin_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Enkeli vastasi: »Sinuun tulee Pyhä Henki; Jumalan voima valtaa sinut. Sen tähden lapsesi on pyhä Jumalan Poika. ");
INSERT INTO fin_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sukulaisesi Elisabetin uskottiin jääneen lapsettomaksi. Kuusi kuukautta sitten hän on vanhoilla päivillään kuitenkin alkanut odottaa lasta. ");
INSERT INTO fin_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Jumalallehan on kaikki mahdollista.» ");
INSERT INTO fin_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria sanoi: »Olen Herran palvelija ja valmis kaikkeen, mitä hän tahtoo. Tapahtukoon niin kuin sanot.» Silloin enkeli hävisi hänen näkyvistään. ");
INSERT INTO fin_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","Maria halusi tavata Elisabetin ja lähti muutaman päivän kuluttua tämän kotikaupunkiin Juudean vuorille. ");
INSERT INTO fin_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kun Maria tervehti Elisabetia, tämä tunsi lapsensa liikahtavan ja tuli täyteen Pyhää Henkeä. ");
INSERT INTO fin_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabet huudahti Marialle iloisesti: »Jumala on siunannut sinua enemmän kuin ketään muuta naista! Lapsestasi kiitetään ja ylistetään Jumalaa. ");
INSERT INTO fin_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","On suuri kunnia, että Herrani äiti tulee tapaamaan minua. ");
INSERT INTO fin_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kun tulit sisään ja kuulin äänesi, lapsenikin liikahti ilosta. ");
INSERT INTO fin_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sinä uskoit Jumalan pitävän sanansa, ja siksi hän on antanut sinulle tämän suuren siunauksen.» ");
INSERT INTO fin_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","47","Maria vastasi: »Ylistän lakkaamatta Jumalaa ja iloitsen Pelastajastani! ");
INSERT INTO fin_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Halusin palvella häntä, ja hän muisti minua, tavallista tyttöä. Kaikki tulevat sukupolvet sanovat minua Jumalan siunaamaksi. ");
INSERT INTO fin_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pyhä, kaikkivaltias Jumala on tehnyt minulle jotain suurta. ");
INSERT INTO fin_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Hän osoittaa sukupolvesta toiseen hyvyyttä jokaiselle, joka kunnioittaa häntä. ");
INSERT INTO fin_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Miten valtava on hänen voimansa! Hän on nöyryyttänyt ylpeät, ");
INSERT INTO fin_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","syössyt hallitsijat valtaistuimilta ja asettanut vaatimattomat kunniaan. ");
INSERT INTO fin_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Hän on ruokkinut nälkäiset sydämet, mutta lähettänyt rikkaat tyhjinä pois. ");
INSERT INTO fin_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ihmeellisesti hän on auttanut palvelijaansa Israelia. ");
INSERT INTO fin_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Hän lupasi esi-isillemme – Aabrahamille ja hänen jälkeläisilleen – että armahtaisi heidät ikuisiksi ajoiksi, eikä ole unohtanut lupaustaan.» ");
INSERT INTO fin_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria oli Elisabetin luona kolmisen kuukautta ennen kuin palasi kotiinsa. ");
INSERT INTO fin_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetin odotusaika kului loppuun, ja hänelle syntyi poika. ");
INSERT INTO fin_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Naapurit ja sukulaiset saivat pian kuulla, miten hyvä Jumala oli ollut Elisabetille, ja kaikki olivat iloisia. ");
INSERT INTO fin_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Kun lapsi oli kahdeksan päivän ikäinen, sukulaiset ja ystävät saapuivat ympärileikkausjuhlaan. He ajattelivat, että lapsen nimeksi pantaisiin isän mukaan Sakarias. ");
INSERT INTO fin_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mutta Elisabet sanoikin yllättäen: »Ei hänestä tehdä Sakariasta, vaan Johannes.» ");
INSERT INTO fin_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Vieraat ihmettelivät: »Eihän suvussanne ole ketään sennimistä.» ");
INSERT INTO fin_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Viittomalla he kysyivät asiaa lapsen isältä. ");
INSERT INTO fin_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sakarias pyysi kirjoitusvälineet ja kirjoitti kaikkien hämmästykseksi: »Hänen nimensä on Johannes.» ");
INSERT INTO fin_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Heti tämän jälkeen hän pystyi taas puhumaan, ja ensimmäiseksi hän alkoi kiittää Jumalaa. ");
INSERT INTO fin_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Koko paikkakunta joutui ihmetyksen valtaan, ja tapauksesta puhuttiin kaikkialla Juudean vuoristoalueella. ");
INSERT INTO fin_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Jokainen, joka kuuli siitä, jäi kyselemään mielessään, mitä tästä lapsesta oikein tulee. Herra näytti aivan erityisellä tavalla olevan hänen kanssaan. ");
INSERT INTO fin_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Sakarias täyttyi Pyhällä Hengellä ja sai Jumalalta sanoman: ");
INSERT INTO fin_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","»Ylistäkää Herraa, Israelin Jumalaa, joka on tullut kansansa luo ja ostanut sen vapaaksi. ");
INSERT INTO fin_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Hän lähettää meille Pelastajan, joka kuuluu hänen palvelijansa Daavidin kuningassukuun. ");
INSERT INTO fin_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","Ovathan Jumalan pyhät profeetat ilmoittaneet jo aikoja sitten, että hän on luvannut pelastaa meidät kaikkien vihollistemme käsistä. ");
INSERT INTO fin_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Jumala on ollut hyvä esi-isillemme. Kun hän antoi Aabrahamille pyhän lupauksen, hän myös piti sanansa. ");
INSERT INTO fin_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Saimme etuoikeuden palvella Jumalaa koko elämämme oikeamielisinä ilman moitteen sijaa ja vihollisia pelkäämättä. ");
INSERT INTO fin_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Pieni poikani, sinusta tulee suuren Jumalan profeetta. Sinä valmistat tietä Herralle. ");
INSERT INTO fin_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kerrot hänen kansalleen, miten se voi saada syntinsä anteeksi ja pelastua. ");
INSERT INTO fin_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Jumalan armo tekee tämän mahdolliseksi. Meille pimeässä, kuoleman varjossa, eläville ihmisille alkaa valjeta aamu, ja voimme nähdä rauhan tien.» ");
INSERT INTO fin_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Poika kasvoi Jumalan lapsena. Tultuaan aikuiseksi hän oleskeli autiomaassa ennen kuin alkoi julkisen toimintansa Israelin kansan keskuudessa. ");
INSERT INTO fin_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Rooman keisari Augustus päätti näihin aikoihin, että koko valtakunnassa oli toimitettava väestönlaskenta. ");
INSERT INTO fin_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Se suoritettiin, kun Kyrenius oli Syyrian maaherrana. ");
INSERT INTO fin_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jokaisen piti matkustaa henkikirjoitusta varten sille paikkakunnalle, josta hänen sukunsa oli lähtoisin. ");
INSERT INTO fin_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Koska Joosef kuului Daavidin sukuun, hänen oli mentävä Juudean Betlehemiin – sehän oli kuningas Daavidin kotikaupunki. Joosef itse asui Galilean Nasaretissa. ");
INSERT INTO fin_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hän otti matkalle mukaan morsiamensa Marian, joka odotti lasta. ");
INSERT INTO fin_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Kun he olivat Betlehemissä, lapsi syntyi. ");
INSERT INTO fin_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Se oli poika. Maria kääri lapsen, esikoisensa, kapaloihin ja pani eläinten seimeen, sillä kaikki kaupungin majoituspaikat olivat täynnä. ");
INSERT INTO fin_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Samana yönä oli muutamia paimenia kylän ulkopuolella vartioimassa lammaslaumoja. ");
INSERT INTO fin_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yhtäkkiä heidän keskelleen ilmestyi enkeli, ja Herran kirkkaus valaisi koko tienoon. Paimenet pelästyivät suunnattomasti, ");
INSERT INTO fin_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","mutta enkeli rauhoitti heitä. »Älkää pelätkö!» hän sanoi. »Saatte kuulla kaikkien aikojen iloisimman uutisen. Se koskee jokaista ihmistä. ");
INSERT INTO fin_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Betlehemissä on tänä yönä syntynyt Vapahtaja – Messias, Herra! ");
INSERT INTO fin_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Voitte mennä katsomaan häntä: lapsi nukkuu kapaloituna eläinten seimessä.» ");
INSERT INTO fin_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Yhtäkkiä enkelin seuraan liittyi kokonainen taivaan armeija, joka kiitti Jumalaa: ");
INSERT INTO fin_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","»Kunnia korkeuden Jumalalle. Rauha maan ihmisille, joita Jumala rakastaa!» ");
INSERT INTO fin_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kun enkelijoukko oli palannut taivaaseen, paimenet sanoivat toisilleen: »Mennään heti Betlehemiin katsomaan ihmettä, josta Jumala ilmoitti meille.» ");
INSERT INTO fin_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","He juoksivat kaupunkiin ja löysivät Marian ja Joosefin. Seimessä todellakin oli vastasyntynyt lapsi! ");
INSERT INTO fin_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Paimenet kertoivat kaikille, mitä oli tapahtunut ja mitä enkeli oli sanonut heille lapsesta. ");
INSERT INTO fin_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ihmiset hämmästyivät kuullessaan heidän kertomuksensa, ");
INSERT INTO fin_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","mutta Maria painoi tapahtumat hiljaa mieleensä ja mietti niitä usein. ");
INSERT INTO fin_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Paimenet menivät takaisin laumansa luo. He ylistivät Jumalaa enkelien tuomasta ilosanomasta ja siitä, että olivat saaneet nähdä lapsen aivan niin kuin enkeli oli luvannut. ");
INSERT INTO fin_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kahdeksan päivää myöhemmin oli lapsen ympärileikkaus. Hänen nimekseen tuli Jeesus. Tämän nimenhän hän oli saanut enkeliltä jo ennen kuin Maria alkoi häntä odottaa. ");
INSERT INTO fin_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mooseksen laki vaati äitiä uhraamaan temppelissä lapsen syntymän jälkeen puhdistusuhrin. Kun Joosef ja Maria lähtivät tämän vuoksi Jerusalemiin, he veivät samalla Jeesuksen Herran eteen, ");
INSERT INTO fin_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","sillä Jumala oli laissaan määrännyt, että jokainen esikoispoika on omistettava Herralle. ");
INSERT INTO fin_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Jeesuksen vanhempien puhdistusuhrina oli lain mukaan »kaksi metsäkyyhkystä tai kyyhkysenpoikasta». ");
INSERT INTO fin_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Temppelissä oli silloin myös Simeon-niminen jerusalemilainen. Hän oli hurskas, Jumalaa pelkäävä ja Pyhän Hengen täyttämä mies, joka jatkuvasti odotti Messiaan tuloa. ");
INSERT INTO fin_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pyhä Henki oli ilmoittanut hänelle, että hän ennen kuolemaansa näkisi Jumalan lähettämän Messias-kuninkaan. ");
INSERT INTO fin_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nyt Henki oli ohjannut hänet temppeliin, ja kun Maria ja Joosef lainkuulaisina toivat lastaan Herran eteen, ");
INSERT INTO fin_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon otti Jeesuksen syliinsä ja ylisti Jumalaa. ");
INSERT INTO fin_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30-31","»Herra, nyt voin kuolla rauhassa, sillä olet täyttänyt lupauksesi», hän sanoi. »Olen nähnyt Vapahtajan, jonka annoit maailmalle. ");
INSERT INTO fin_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Hän on kaikkien kansojen valo ja oman kansasi Israelin kunnia.» ");
INSERT INTO fin_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Joosef ja Maria seisoivat vieressä ja ihmettelivät kuullessaan, mitä Simeon sanoi Jeesuksesta. ");
INSERT INTO fin_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","35","Simeon siunasi heidät ja sanoi vielä Marialle: »Joudut kärsimään paljon, sillä monet israelilaiset kääntävät selkänsä pojallesi – omaksi onnettomuudekseen. Toisille taas hän on heidän suurin ilonsa, ja monet salaiset ajatukset paljastuvat.» ");
INSERT INTO fin_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Temppelissä oli sinä päivänä myös 84-vuotias profeetta Hanna. Hänen isänsä oli juutalaiseen Asserin heimoon kuuluva Fanuel. Hanna oli aikoinaan mennyt nuorena naimisiin, mutta jäänyt leskeksi seitsemän avioliittovuoden jälkeen. Hän oli jatkuvasti temppelissä, rukoili yötä päivää ja paastosi usein. ");
INSERT INTO fin_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kun Simeon puhui Marian ja Joosefin kanssa, Hannakin tuli heidän luokseen. Hän kiitti Jumalaa ja kertoi kaikille, jotka odottivat Jerusalemin vapaaksi lunastajaa: Messias oli nyt tullut! ");
INSERT INTO fin_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kun Jeesuksen vanhemmat olivat tehneet sen, mitä Jumalan laki vaati, he palasivat kotiinsa Galilean Nasaretiin. ");
INSERT INTO fin_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Siellä lapsesta kasvoi voimakas ja viisas poika, jota Jumala runsaasti siunasi. ");
INSERT INTO fin_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jeesuksen vanhemmat kävivät joka vuosi Jerusalemin pääsiäisjuhlilla. ");
INSERT INTO fin_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kun Jeesus oli kaksitoistavuotias, perhe kävi taas Jerusalemissa. ");
INSERT INTO fin_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Juhlien päätyttyä Joosef ja Maria lähtivät paluumatkalle, mutta Jeesus jäi heidän huomaamattaan Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ensimmäisenä päivänä vanhemmat eivät osanneet kaivata häntä. He olettivat, että hän oli ystäviensä kanssa muiden matkalaisten joukossa. Kun Jeesusta ei illallakaan näkynyt, Joosef ja Maria alkoivat kysellä häntä tuttavilta ja sukulaisilta, ");
INSERT INTO fin_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","mutta kukaan ei tiennyt pojasta. Vanhempien oli palattava Jerusalemiin etsimään häntä. ");
INSERT INTO fin_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Vasta kolmen päivän kuluttua he löysivät pojan. Hän istui temppelissä keskustelemassa lainopettajien kanssa. ");
INSERT INTO fin_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kaikki ihmettelivät hänen käsityskykyään ja vastauksiaan. ");
INSERT INTO fin_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Joosef ja Maria eivät tienneet mitä ajatella, kun näkivät hänen istuvan siellä kaikessa rauhassa. »Miksi sinä teit meille tämän?» Maria kysyi. »Isä ja minä olemme olleet huolissamme ja etsineet sinua joka paikasta.» ");
INSERT INTO fin_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","»Mutta miksi teidän piti minua etsiä?» Jeesus kysyi. »Ettekö tienneet, että täällähän minä olisin – Isäni talossa?» ");
INSERT INTO fin_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Isä ja äiti eivät ollenkaan ymmärtäneet, mitä hän tarkoitti. ");
INSERT INTO fin_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jeesus palasi sitten vanhempiensa kanssa Nasaretiin ja oli heille tottelevainen. Hänen äitinsä painoi myös tämän tapahtuman mieleensä. ");
INSERT INTO fin_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jeesus kasvoi ja kehittyi sekä Jumalan että ihmisten rakastamana. ");
INSERT INTO fin_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Tiberius oli keisarina viidettätoista vuotta, kun Sakariaan poika Johannes sai autiomaassa Jumalalta viestin. Tähän aikaan Pilatus oli Juudean maaherrana ja Herodes hallitsi Galileaa, Herodeksen veli Filippus Itureaa ja Trakonitia ja Lysanias Abilenea. Juutalaisten ylipappeina olivat Hannas ja Kaifas. ");
INSERT INTO fin_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Johannes alkoi kulkea Jordanin molemmilla rannoilla paikasta toiseen. Hän julisti ihmisille, että saadakseen Jumalan anteeksiantamuksen heidän oli hylättävä syntinsä ja palattava Jumalan luo. Tämän merkiksi heidän oli otettava kaste. ");
INSERT INTO fin_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Profeetta Jesaja oli ennustanut Johanneksesta: »Autiomaasta kuuluu hänen äänensä: ’Tehkää tie, jota Herra voi kulkea. Leventäkää polku häntä varten. ");
INSERT INTO fin_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tasoittakaa vuoret, täyttäkää laaksot, oikaiskaa mutkat ja raivatkaa kivikot! ");
INSERT INTO fin_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Silloin koko ihmiskunta saa nähdä Jumalan lähettämän Vapahtajan.’» ");
INSERT INTO fin_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Johannes puhui niille, jotka tulivat kastettaviksi: »Te käärmeet! Tahdotte saada kasteen, koska ette halua joutua kadotukseen, mutta ette käänny tosissanne Jumalan puoleen. ");
INSERT INTO fin_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Teidän elämästänne näkyy, oletteko tehneet parannuksen. Älkää luulko selviävänne sillä, että olette Aabrahamin jälkeläisiä. Se ei riitä. Jumala voi tehdä Aabrahamille lapsia näistä autiomaan kivistä! ");
INSERT INTO fin_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tuomion kirves on valmiina, ja jokainen puu, josta ei saada hyviä hedelmiä, hakataan poikki ja poltetaan.» ");
INSERT INTO fin_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","»Mitä meidän sitten on tehtävä?» ihmiset kysyivät. ");
INSERT INTO fin_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Hän vastasi: »Jos sinulla on kaksi paitaa, anna toinen jollekin köyhälle. Jos sinulla on ruokaa, anna sitä niille, joilla on nälkä.» ");
INSERT INTO fin_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Myös jotkut veronkantajat tulivat kastettaviksi ja kysyivät: »Miten voimme todistaa, että olemme luopuneet synneistämme?» ");
INSERT INTO fin_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","»Olkaa rehellisiä», hän vastasi. »Älkää kerätkö veroa enempää kuin Rooman hallinto teiltä vaatii.» ");
INSERT INTO fin_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","»Mitä meidän on tehtävä?» kysyivät muutamat sotilaat. Johannes vastasi: »Älkää kiristäkö rahaa uhaten tai väkivalloin vaan tyytykää palkkaanne. Älkää syyttäkö ketään vastoin parempaa tietoanne.» ");
INSERT INTO fin_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Siihen aikaan odotettiin yleisesti, että Messias tulisi pian, ja ihmiset pohtivat, oliko Johannes itse Messias. Tämä oli joka puolella yleisenä puheenaiheena. ");
INSERT INTO fin_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Johannes vastasi kysyjille: »Minä kastan vain vedellä, mutta pian tulee toinen, jolla on enemmän valtaa kuin minulla – oikeastaan en kelpaisi edes irrottamaan hänen sandaaliensa nauhoja. Hän kastaa teidät tulella, Pyhällä Hengellä. ");
INSERT INTO fin_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Hän erottelee jyvistä akanat ja polttaa ne ikuisessa tulessa, mutta kokoaa jyvät aittaan.» ");
INSERT INTO fin_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Johannes käytti usein tällaisia varoittavia esimerkkejä julistaessaan ihmisille hyvää uutista. ( ");
INSERT INTO fin_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Myöhemmin Johannes arvosteli julkisesti Galilean hallitsijaa Herodesta siitä, että tämä otti itselleen veljensä vaimon Herodiaan ja teki monenlaista muutakin vääryyttä. ");
INSERT INTO fin_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Silloin Herodes panetti Johanneksen vankilaan.) ");
INSERT INTO fin_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Eräänä päivänä Jeesus itse tuli kansanjoukon mukana Johanneksen kastettavaksi. Kun hän rukoili kasteen jälkeen, ");
INSERT INTO fin_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pyhä Henki laskeutui taivaasta hänen ylleen kuin kyyhkynen. Samalla ylhäältä kuului ääni: »Sinä olet minun rakas poikani, minun silmäteräni.» ");
INSERT INTO fin_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Kun Jeesus aloitti julkisen toimintansa, hän oli noin kolmikymmenvuotias. Häntä pidettiin Joosefin poikana. Joosefin isä oli Eeli, ");
INSERT INTO fin_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eelin isä oli Mattat, Mattatin isä oli Leevi, Leevin isä oli Melki, Melkin isä oli Jannai, Jannain isä oli Joosef, ");
INSERT INTO fin_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joosefin isä oli Mattatias, Mattatiaan isä oli Aamos, Aamoksen isä oli Naahum, Naahumin isä oli Esli, Eslin isä oli Naggai, ");
INSERT INTO fin_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggain isä oli Maahat, Maahatin isä oli Mattatias, Mattatiaan isä oli Semein, Semeinin isä oli Joosek, Joosekin isä oli Jooda, ");
INSERT INTO fin_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joodan isä oli Johanan, Johananin isä oli Reesa, Reesan isä oli Serubbaabel, Serubbaabelin isä oli Sealtiel, Sealtielin isä oli Neeri, ");
INSERT INTO fin_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neerin isä oli Melki, Melkin isä oli Addi, Addin isä oli Koosam. Koosamin isä oli Elmadam, Elmadamin isä oli Eer, ");
INSERT INTO fin_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eerin isä oli Joosua, Joosuan isä oli oli Elieser, Elieserin isä oli Joorim, Joorimin isä oli Mattat, Mattatin isä oli Leevi, ");
INSERT INTO fin_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Leevin isä oli Simeon, Simeonin isä oli Juuda, Juudan isä oli Joosef, Joosefin isä oli Joonam, Joonamin isä oli Eljakim, ");
INSERT INTO fin_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eljakimin isä oli Melea, Melean isä oli Menna, Mennan isä oli Mattatan, Mattatanin isä oli Naatan, Naatanin isä oli Daavid, ");
INSERT INTO fin_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daavidin isä oli Iisai, Iisain isä oli Oobed, Oobedin isä oli Booas, Booaan isä oli Selah, Selahin isä oli Nahson, ");
INSERT INTO fin_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahsonin isä oli Amminadab, Amminadabin isä oli Admin, Adminin isä oli Arni, Arnin isä oli Hesron, Hesronin isä oli Peres, Pereksen isä oli Juuda, ");
INSERT INTO fin_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juudan isä oli Jaakob, Jaakobin isä oli Iisak, Iisakin isä oli Aabraham, Aabrahamin isä oli Terah, Terahin isä oli Naahor, ");
INSERT INTO fin_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naahorin isä oli Serug, Serugin isä oli Regu, Regun isä oli Peleg, Pelegin isä oli Eeber, Eeberin isä oli Selah, ");
INSERT INTO fin_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selahin isä oli Kainam, Kainamin isä oli Arpaksad, Arpaksadin isä oli Seem, Seemin isä oli Nooa, Nooan isä oli Lemek, ");
INSERT INTO fin_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemekin isä oli Metusalah, Metusalahin isä oli Eenok, Eenokin isä oli Jaaret, Jaaretin isä oli Mahalalel, Mahalalelin isä oli Keenan, ");
INSERT INTO fin_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Keenanin isä oli Enos, Enoksen isä oli Seet, Seetin isä oli Aadam, Aadamin isä oli Jumala. ");
INSERT INTO fin_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","2","Jeesus lähti Jordanilta täynnä Pyhää Henkeä, ja Henki vei hänet Juudean kuivaan autiomaahan. Siellä saatana kiusasi häntä neljäkymmentä päivää. Hän ei syönyt koko aikana mitään ja hänellä oli kova nälkä. ");
INSERT INTO fin_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Kiusaaja sanoi: »Jos olet Jumalan Poika, käske tämän kiven muuttua leiväksi.» ");
INSERT INTO fin_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mutta Jeesus vastasi: »Raamatussa on sanottu: ’Ihminen ei elä pelkästä leivästä’.» ");
INSERT INTO fin_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sitten saatana näytti hänelle yhdessä vilauksessa kaikki maailman valtakunnat ");
INSERT INTO fin_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","ja lupasi: »Annan sinulle kaikki nämä maat ja niiden loiston ja rikkaudet, sillä ne ovat minun, ja voin lahjoittaa ne kenelle haluan. Sinun täytyy vain polvistua eteeni ja palvoa minua.» ");
INSERT INTO fin_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jeesus vastasi: »Yksin Jumalaa meidän on palvottava, Raamattu sanoo niin.» ");
INSERT INTO fin_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","10-11","Sitten saatana vei hänet Jerusalemin temppelin katolle ja sanoi: »Jos olet Jumalan Poika, hyppää alas! Raamattuhan sanoo, että Jumala lähettää enkelinsä varjelemaan sinua, niin ettet murskaudu kivikkoon.» ");
INSERT INTO fin_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jeesus vastasi: »Raamattu sanoo myös: ’Älkää koetelko Jumalan kärsivällisyyttä’.» ");
INSERT INTO fin_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kiusattuaan Jeesusta kyllikseen saatana jätti hänet joksikin aikaa rauhaan. ");
INSERT INTO fin_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","15","Jeesus oli Galileaan palatessaan täynnä Pyhän Hengen voimaa. Hän tuli pian koko seudulla kuuluisaksi synagogissa pitämistään puheista, ja kaikki ylistivät häntä. ");
INSERT INTO fin_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tultuaan kotikaupunkiinsa Nasaretiin hän meni tapansa mukaan juutalaisten pyhäpäivänä synagogaan ja nousi lukemaan Raamattua. ");
INSERT INTO fin_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Hänelle ojennettiin profeetta Jesajan kirja, ja hän avasi sen tällaisesta kohdasta: ");
INSERT INTO fin_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","19","»Herran Henki on ylläni; hän on valinnut minut viemään ilosanomaa köyhille, julistamaan vapautusta vangeille, antamaan sokeille näön, vapauttamaan sorretut ja siunaamaan jokaista, joka tulee hänen luokseen.» ");
INSERT INTO fin_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Hän sulki kirjan, ojensi sen takaisin avustajalle ja istuutui kaikkien katsoessa häneen. ");
INSERT INTO fin_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sitten hän lisäsi: »Tämä Raamatun kohta on tänään toteutunut!» ");
INSERT INTO fin_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jeesuksen hyvät sanat ihastuttivat läsnäolijoita ja he kyselivät hämmästyneinä: »Miten hän voi noin puhua? Eikö hän ole Joosefin poika?» ");
INSERT INTO fin_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Mutta hän sanoi: »Ehkä tahdotte soveltaa minuun sananlaskua ’Parantaja, paranna itsesi’ ja kysytte, miksi en tee täällä kotikaupungissani samanlaisia ihmeitä kuin Kapernaumissa. ");
INSERT INTO fin_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Mutta väitän – ja olen aivan vakavissani – ettei kukaan profeetta ole hyväksytty kotipaikkakunnallaan. ");
INSERT INTO fin_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","26","Muistatteko esimerkiksi, kun profeetta Elia teki ihmeen auttaessaan Sarpatin leskeä, joka oli siidonilainen? Monet juutalaiset lesket olisivat silloin tarvinneet apua, sillä kolmeen ja puoleen vuoteen ei ollut satanut yhtään, ja kansa kärsi nälkää. Mutta Eliaa ei lähetetty heidän luokseen. ");
INSERT INTO fin_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tai ajatelkaa profeetta Elisaa, joka paransi syyrialaisen Naemanin eikä niitä monia juutalaisia lepratautisia, jotka myös olisivat tarvinneet apua.» ");
INSERT INTO fin_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tämä Jeesuksen puhe sai kuulijat raivoihinsa. ");
INSERT INTO fin_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Kaupunki oli rakennettu vuorelle, ja nyt he alkoivat työntää Jeesusta edellään kohti jyrkänteen reunaa syöstäkseen hänet alas. ");
INSERT INTO fin_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mutta hän käveli väkijoukon läpi ja lähti pois heidän luotaan. ");
INSERT INTO fin_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sitten hän palasi Kapernaumiin, erääseen Galilean kaupunkiin, ja saarnasi sen synagogassa joka pyhäpäivä. ");
INSERT INTO fin_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Täälläkin ihmiset olivat hämmästyneitä hänen puheistaan, sillä hänen sanoissaan oli Jumalan voima. ");
INSERT INTO fin_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kerran Jeesuksen opettaessa synagogassa eräs riivaajahengen vallassa oleva mies alkoi huutaa hänelle: ");
INSERT INTO fin_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","»Pois täältä! Meillä ei ole mitään tekemistä sinun kanssasi, Jeesus Nasaretilainen. Olet tullut tuhoamaan meidät. Tiedän kyllä, että olet Jumalan pyhä Poika.» ");
INSERT INTO fin_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jeesus keskeytti hänet jyrkästi. »Ole hiljaa ja lähde tästä miehestä», hän käski demonia. Väkijoukon silmien edessä henki kaatoi miehen lattialle ja lähti sitten hänestä vahingoittamatta häntä enempää. ");
INSERT INTO fin_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ällistyneenä ihmiset kyselivät: »Miten Jeesus saa pahat hengetkin tottelemaan sanaansa?» ");
INSERT INTO fin_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tieto siitä, mitä hän oli tehnyt, levisi seudulla kulovalkean tavoin. ");
INSERT INTO fin_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Lähdettyään sinä päivänä synagogasta Jeesus meni Simonin kotiin. Tämän anoppi oli hyvin sairaana kovassa kuumeessa. »Etkö voisi parantaa häntä!» kaikki pyysivät. ");
INSERT INTO fin_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jeesus seisoi sairaan vuoteen vieressä ja käski kuumetta lähtemään. Heti naisen ruumiinlämpö laski normaaliksi, ja hän nousi vuoteesta ja valmisti heille aterian. ");
INSERT INTO fin_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Illalla auringon laskettua kaikki kyläläiset toivat sairaat omaisensa Jeesuksen luo. Kun hän kosketti sairaita, he kaikki paranivat. ");
INSERT INTO fin_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jotkut olivat pahojen henkien vallassa, ja Jeesuksen käskystä demonit lähtivät heistä huutaen: »Sinä olet Jumalan Poika!» Mutta koska ne tiesivät, että hän oli Kristus, hän käski niiden olla hiljaa. ");
INSERT INTO fin_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aikaisin seuraavana aamuna hän lähti asumattomaan paikkaan. Kansa etsi häntä joka puolelta, ja löydettyään hänet lopulta ihmiset pyysivät, ettei hän lähtisi Kapernaumista mihinkään. ");
INSERT INTO fin_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Mutta hän vastasi: »Minun on vietävä muuallekin hyvä uutinen Jumalan valtakunnasta, sillä sitä varten minut on lähetetty.» ");
INSERT INTO fin_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ja hän jatkoi kulkemistaan pitkin Galileaa ja piti puheita eri synagogissa. ");
INSERT INTO fin_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kun Jeesus eräänä päivänä puhui Genesaretin järven rannalla, suuret väkijoukot tunkeutuivat hänen lähelleen kuulemaan Jumalan sanaa. ");
INSERT INTO fin_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Hän näki vedenrajassa kaksi tyhjää venettä; kalastajat olivat huuhtelemassa verkkojaan. ");
INSERT INTO fin_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jeesus nousi toiseen veneeseen ja pyysi sen omistajaa, Simonia, työntämään sen vähän kauemmaksi rannasta, että hän voisi veneessä istuen puhua väkijoukoille. ");
INSERT INTO fin_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lopetettuaan puheensa Jeesus sanoi Simonille: »Menkää nyt syvemmälle ja heittäkää verkkonne veteen, niin saatte paljon kalaa!» ");
INSERT INTO fin_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon vastasi: »Herra, olemme tehneet koko viime yön turhaa työtä. Mutta voimmehan yrittää uudestaan sieltä, mistä sanoit.» ");
INSERT INTO fin_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tällä kertaa he saivat niin paljon kalaa, että verkot repeilivät. ");
INSERT INTO fin_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","He huusivat tovereitaan tulemaan toisella veneellä apuun, ja molemmat veneet olivat pian niin täynnä kaloja, että ne olivat vähällä upota. ");
INSERT INTO fin_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nähtyään, mitä oli tapahtunut, Simon Pietari heittäytyi polvilleen Jeesuksen eteen ja sanoi: »Herra, lähde pois täältä, sillä minä olen liian syntinen sinun lähellesi.» ");
INSERT INTO fin_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Hän ja hänen toverinsa, Sebedeuksen pojat Jaakob ja Johannes, olivat pelästyneet saaliin suuruuden tähden. Jeesus vastasi: »Älä pelkää! Tästä lähtien saat kalastaa ihmisiä!» ");
INSERT INTO fin_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Tultuaan rantaan miehet jättivät heti kaiken ja lähtivät Jeesuksen mukaan. ");
INSERT INTO fin_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jeesus kävi eräänä päivänä kaupungissa, jossa oli pitkälle edennyttä lepraa sairastava mies. Nähdessään Jeesuksen sairas heittäytyi hänen eteensä ja painoi kasvonsa maahan. Siinä hän kerjäsi, että Jeesus parantaisi hänet. »Herra, jos vain tahdot, voit puhdistaa minusta kaikki lepran jäljetkin», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jeesus ojensi kätensä, kosketti miestä ja sanoi: »Tietysti tahdon. Tule terveeksi.» Lepra parani heti. ");
INSERT INTO fin_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jeesus lähetti miehen pois ja kielsi häntä puhumasta tapahtuneesta. Hänen oli kyllä käytävä juutalaisen papin tarkastettavana. »Uhraa mitä Mooseksen laki säätää leprasta parantuneille», Jeesus sanoi. »Siten osoitat kaikille olevasi terve.» ");
INSERT INTO fin_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tieto Jeesuksen voimasta levisi yhä laajemmalle, ja sankat joukot tulivat kuuntelemaan häntä ja hänen parannettavikseen. ");
INSERT INTO fin_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mutta usein hän vetäytyi asumattomaan paikkaan rukoilemaan. ");
INSERT INTO fin_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Muutamia fariseusten jyrkän uskonnollisen puolueen jäseniä ja lainopettajia istui eräänä päivänä kuuntelemassa, kun Jeesus opetti. (Näitä miehiä näytti ilmaantuvan paikalle kaikista Galilean ja Juudean kylistä ja Jerusalemista asti.) Jeesus paransi ihmisiä Jumalan voimalla. ");
INSERT INTO fin_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","19","Silloin paikalle kannettiin halvautunutta miestä. Kantajat yrittivät tunkeutua väkijoukon läpi Jeesuksen luo, mutta se oli mahdotonta. Niinpä kantajat kiipesivät katolle, irrottivat muutamia tiiliä ja laskivat sairaan makuumaton avulla aukosta suoraan Jeesuksen eteen. ");
INSERT INTO fin_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nähdessään kantajien uskon Jeesus sanoi halvautuneelle miehelle: »Ystäväni, olet saanut syntisi anteeksi.» ");
INSERT INTO fin_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Fariseukset ja lainopettajat alkoivat puhua keskenään: »Kuka hän oikein luulee olevansa? Tuo on jumalanpilkkaa! Eihän kukaan muu kuin Jumala voi antaa syntejä anteeksi.» ");
INSERT INTO fin_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jeesus tiesi, mitä he ajattelivat, ja vastasi: »Miksi tämä on jumalanpilkkaa? ");
INSERT INTO fin_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Eikö ole vaikeampaa antaa hänen syntinsä anteeksi kuin parantaa hänet? ");
INSERT INTO fin_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Saatte nähdä, että minulla on valta antaa syntejä anteeksi, kun parannan hänet.» Sitten Jeesus sanoi halvautuneelle: »Nouse, ota mattosi ja mene kotiin.» ");
INSERT INTO fin_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Kaikkien katsellessa mies hyppäsi heti pystyyn, otti maton ja lähti kotiinsa Jumalaa kiittäen. ");
INSERT INTO fin_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kunnioitus ja pelko tarttui kaikkiin paikalla oleviin. He ylistivät Jumalaa ja toistelivat: »Olemme nyt nähneet jotain hyvin merkillistä.» ");
INSERT INTO fin_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Lähtiessään myöhemmin kaupungista Jeesus näki tulliasemalla veronkantajan, joka istui omalla paikallaan. Kaikki tiesivät veronkantajien pettävän ihmisiä. Tämän miehen nimi oli Leevi. Jeesus sanoi hänelle: »Tule minun oppilaakseni.» ");
INSERT INTO fin_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leevi jätti silloin kaiken ja lähti hänen mukaansa. ");
INSERT INTO fin_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Leevi piti pian kotonaan juhlat, joissa kunniavieraana oli Jeesus. Mukana oli monia Leevin työtovereita ja muita vieraita. ");
INSERT INTO fin_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseukset ja lainopettajat tulivat myrtyneinä sanomaan Jeesuksen oppilaille siitä, että hän aterioi huonomaineisten ihmisten luona. ");
INSERT INTO fin_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jeesus vastasi heille: »Sairas tarvitsee lääkäriä, eivät terveet. ");
INSERT INTO fin_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Olen tullut kutsumaan syntisiä, että he kääntyisivät synneistään, enkä viettämään aikaani niiden kanssa, jotka pitävät itseään jo tarpeeksi hyvinä.» ");
INSERT INTO fin_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sitten he sanoivat siitä, että Jeesuksen oppilaat eivät paastonneet: »Johannes Kastajan oppilaat paastoavat ja rukoilevat jatkuvasti, samaten fariseusten oppilaat. Miksi sinun oppilaasi syövät ja juovat?» ");
INSERT INTO fin_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jeesus sanoi: »Eihän nyt häissä paastota! ");
INSERT INTO fin_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mutta tulee päivä, jona sulhanen surmataan, ja silloin häävieraat paastoavat.» ");
INSERT INTO fin_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jeesus käytti sitten tällaista vertausta: »Kukaan ei leikkaa kutistamattomasta kankaasta tilkkua vanhojen vaatteiden paikaksi, sillä tällainen tilkku vain repii vanhan vaatteen uudestaan. ");
INSERT INTO fin_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kukaan ei myöskään pane uutta viiniä vanhoihin nahkaleileihin, sillä uusi viini halkaisee vanhan nahan ja valuu maahan. ");
INSERT INTO fin_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Uusi viini on pantava uusiin leileihin. ");
INSERT INTO fin_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Mutta kukaan, joka on juonut vanhaa viiniä, ei näytä haluavan tuoretta. ’Vanha on parempaa’, he sanovat.» ");
INSERT INTO fin_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kun Jeesus ja hänen oppilaansa kulkivat eräänä pyhäpäivänä viljapeltojen halki, he katkoivat vehnän tähkiä, hieroivat akanat niistä irti käsissään ja söivät jyvät. ");
INSERT INTO fin_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jotkut fariseukset sanoivat silloin: »Tehän teette työtä! Meidän lakimme kieltää tekemästä sapattina työtä.» ");
INSERT INTO fin_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jeesus vastasi: »Ettekö lue Raamattua? Ettekö tiedä, mitä kuningas Daavid ja hänen miehensä tekivät, kun heidän oli nälkä? ");
INSERT INTO fin_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","He ottivat temppelistä ne erityiset leivät, jotka oli pantu uhrina Herran eteen, ja söivät ne, vaikka se olikin vastoin juutalaisten lakia.» ");
INSERT INTO fin_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ja Jeesus lisäsi: »Minä olen sapatinkin Herra.» ");
INSERT INTO fin_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Eräänä toisena sapattina hän opetti synagogassa. Kuulijoiden joukossa oli mies, jonka oikea käsi oli epämuodostunut. ");
INSERT INTO fin_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Lainopettajat ja fariseukset seurasivat tarkasti, parantaisiko Jeesus miehen, vaikka oli sapatti. He olivat nimittäin kovin innokkaita löytämään jotakin, mistä voisivat häntä syyttää. ");
INSERT INTO fin_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jeesus tiesi täsmälleen heidän ajatuksensa. Siksi hän sanoi vammaiselle miehelle: »Tule tänne eteen, niin että kaikki voivat nähdä sinut.» Mies tuli. ");
INSERT INTO fin_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Sitten Jeesus sanoi fariseuksille ja lainopettajille: »Vastatkaa minulle: Kumpi on parempi, tehdä pyhäpäivänä hyvää vai pahaa, pelastaa ihmiselämä vai antaa sen tuhoutua?» ");
INSERT INTO fin_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Hän katsoi heitä jokaista vuoron perään ja sanoi sitten miehelle: »Ojenna kätesi.» Kun mies ojensi kätensä, se tuli täysin terveeksi. ");
INSERT INTO fin_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jeesuksen vihamiehet olivat tästä raivoissaan ja alkoivat suunnitella hänen murhaamistaan. ");
INSERT INTO fin_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pian tämän jälkeen Jeesus meni koko yöksi vuorille rukoilemaan. ");
INSERT INTO fin_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Aikaisin seuraavana aamuna hän kutsui luokseen ne, jotka olivat alkaneet kulkea hänen mukanaan ja valitsi heistä kaksitoista. Heitä hän nimitti apostoleiksi. ");
INSERT INTO fin_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","15-16","He olivat: Simon, jota Jeesus sanoi myös Pietariksi, Simonin veli Andreas, Jaakob, Johannes, Filippus, Bartolomeus, Matteus, Tuomas, Jaakob Alfeuksen poika, Simon, vapautusliikkeen mies, Juudas Jaakobin poika ja Juudas Iskariot, joka myöhemmin petti Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Jeesus tuli heidän kanssaan vuorelta ja seisahtui aukealle kentälle. Hänen oppilaitaan ja joukoittain muuta väkeä kerääntyi hänen ympärilleen. Ihmisiä tuli näet kaikkialta Juudeasta, Jerusalemista ja niinkin pohjoisesta kuin Tyyron ja Siidonin rannikkoalueelta kuuntelemaan Jeesuksen puheita ja hänen parannettavikseen. Hän vapautti myös useita ihmisiä pahojen henkien vallasta. ");
INSERT INTO fin_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Monet yrittivät koskettaa häntä, sillä hänestä lähti parantavaa voimaa, joka teki kaikki terveiksi. ");
INSERT INTO fin_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jeesus kääntyi puhumaan oppilailleen: »Onnellisia te köyhät, sillä te saatte Jumalan valtakunnan! ");
INSERT INTO fin_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Onnellisia te nälkäiset, sillä teidät ravitaan. Onnellisia te, jotka nyt itkette, sillä kohta on aika nauraa. ");
INSERT INTO fin_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Onnellisia te, joita vihataan, parjataan, hyljeksitään ja loukataan minun takiani. ");
INSERT INTO fin_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Olkaa siitä vain iloisia, sillä taivaassa teitä odottaa suuri palkinto. Muistakaa, että profeetat saivat aikoinaan saman kohtelun. ");
INSERT INTO fin_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mutta voi teitä, te rikkaat: teidän onnenne jää tänne maan päälle. ");
INSERT INTO fin_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Voi teitä, jotka nyt olette kylläisiä: teillä tulee vielä kerran olemaan tuskallinen nälkä. Voi teitä, jotka nyt nauratte huolettomina, sillä te joudutte suremaan. ");
INSERT INTO fin_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Voi teitä, joita maailma nyt kiittelee – väärät profeetat ovat aina olleet kansan suosiossa. ");
INSERT INTO fin_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Kuulkaa kaikki! Rakastakaa vihollisianne. Tehkää hyvää niille, jotka vihaavat teitä. ");
INSERT INTO fin_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Rukoilkaa niiden puolesta, jotka pyrkivät teitä vahingoittamaan. Pyytäkää Jumalan siunausta niille, jotka parjaavat teitä. ");
INSERT INTO fin_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jos joku lyö sinua toiselle poskelle, anna hänen lyödä toisellekin. Jos joku pyytää takkiasi, anna hänelle myös paitasi. ");
INSERT INTO fin_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Anna, mitä ihmiset sinulta pyytävät, äläkä yritä saada takaisin sellaista, mikä on sinulta viety. ");
INSERT INTO fin_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kohtele muita niin kuin toivot heidän kohtelevan itseäsi. ");
INSERT INTO fin_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Mitä erinomaista te siinä teette, jos rakastatte niitä, jotka teitä rakastavat? Niinhän jumalattomatkin tekevät! ");
INSERT INTO fin_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ei siinä ole mitään ihmeellistä, jos teette hyvää niille, jotka ovat hyviä teille itsellenne. Kyllä jumalattomatkin tekevät hyvää. ");
INSERT INTO fin_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mitä erikoista siinä on, jos lainaatte rahaa niille, jotka maksavat takaisin? Pahimmatkin ihmiset lainaavat toisilleen, jos saavat omansa takaisin. ");
INSERT INTO fin_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Rakastakaa siis niitä, jotka vihaavat teitä, olkaa hyviä heitä kohtaan ja lainatkaa välittämättä siitä, maksavatko he takaisin. Saatte taivaasta suuren palkan ja toimitte niin kuin Jumalan lapset – onhan Jumalakin hyvä kiittämättömille ja pahoille. ");
INSERT INTO fin_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Olkaa yhtä armahtavia kuin Isännekin. ");
INSERT INTO fin_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Älkää koskaan arvostelko tai tuomitko muita, ettette saisi samalla mitalla takaisin. Suhtautukaa ihmisiin hyväntahtoisesti, niin teihin suhtaudutaan samoin. ");
INSERT INTO fin_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jos itse annatte, teillekin annetaan. Saatte lahjana takaisin kukkuramitoin, täpötäydessä astiassa. Siitä, käytättekö antaessanne pientä vai suurta mittaa, riippuu, miten itsellenne mitataan.» ");
INSERT INTO fin_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jeesus käytti tällaisia vertauksia puheissaan: »Kannattaako sokean taluttaa toista sokeaa? Kuoppaan pudotessaan toinen vetää toisen perässään. ");
INSERT INTO fin_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Voisiko oppilas tietää enemmän kuin opettajansa? Suurin ponnistuksin hän voi päästä yhtä pitkälle kuin tämä. ");
INSERT INTO fin_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Miksi kiinnitämme huomiomme jonkun toisen silmässä olevaan roskaan – hänen pikkuvirheeseensä – jos omassa silmässämme on kokonainen hirsi? ");
INSERT INTO fin_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Miten voit kuvitella sanovasi jollekulle: ’Kuulehan, hyvä veli, ottaisin mielelläni tuon roskan silmästäsi’, vaikka et näe omassa silmässäsi olevaa hirttä? Tekopyhyyttä! Ota ensin hirsi silmästäsi, niin sen jälkeen näet ehkä kyllin hyvin auttaaksesi sitä, jonka silmässä on pieni roska. ");
INSERT INTO fin_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jalostetussa puussa ei kasva villihedelmiä, eivätkä jalostamattoman puun hedelmät ole valiolaatua. ");
INSERT INTO fin_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Puu tunnetaan hedelmistään. Piikkipensaissa ei kasva viikunoita eikä villimarjapensaissa viinirypäleitä. ");
INSERT INTO fin_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ihminen, jolla on hyvä sydän, tekee hyvää. Pahan ihmisen sydämen ilkeys käy ilmi hänen teoistaan. Sydämen kyllyydestä suu puhuu. ");
INSERT INTO fin_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Miksi sanotte minua ’Herraksi’, ellette tahdo totella minua? ");
INSERT INTO fin_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Jokainen, joka kuuntelee ja myös tottelee minua, on kuin mies, joka rakentaa talonsa lujasti peruskallion varaan. Tulvavedetkään eivät saa hänen vahvasti rakennettua taloaan horjumaan. ");
INSERT INTO fin_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sellainen taas, joka kuuntelee mutta ei tottele minua, on kuin mies, joka ei kaiva talolleen perustaa. Tulvan noustessa hänen rakennuksensa sortuu raunioiksi.» ");
INSERT INTO fin_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Lopetettuaan puheensa Jeesus lähti takaisin Kapernaumiin. ");
INSERT INTO fin_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Erään Rooman armeijan upseerin orja, joka oli isännälleen hyvin arvokas, oli juuri silloin vakavasti sairaana. ");
INSERT INTO fin_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kuultuaan Jeesuksesta upseeri lähetti muutamia nimekkäitä juutalaisia pyytämään, että tämä tulisi ja parantaisi sairaan. ");
INSERT INTO fin_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Miehet tekivät niin. He pyysivät hartaasti Jeesusta mukaansa vedoten siihen, että upseeri oli tehnyt paljon hyvää. »Hän jos kuka ansaitsee, että autat häntä, ");
INSERT INTO fin_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sillä hän on osoittanut rakkautta juutalaisia kohtaan. Hän on rakentanut meille synagogankin», he sanoivat. ");
INSERT INTO fin_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Jeesus lähti heidän mukaansa. Kun he olivat jo lähellä taloa, upseeri lähetti muutamia ystäviään sanomaan: »Herra, älä vaivaudu tulemaan kotiini, sillä en ansaitse sellaista kunniaa enkä ole tarpeeksi hyvä edes tulemaan luoksesi. Voit varmasti parantaa palvelijani pelkällä sanalla siinä, missä nyt olet. ");
INSERT INTO fin_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Olen itse ylempien upseerien alainen ja komennan omia miehiäni. Sanon vain: ’Mene!’ ja sotilas menee, tai ’tule!’ ja hän tulee. Ja kun sanon palvelijalleni: ’Tee tämä tai tuo’, hän tekee. Sano siis vain: ’Tule terveeksi!’, niin palvelijani toipuu.» ");
INSERT INTO fin_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jeesus oli hämmästynyt. Hän sanoi väkijoukolle: »En ole tavannut yhtään juutalaista, jolla olisi tällainen usko.» ");
INSERT INTO fin_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kun upseerin ystävät palasivat tämän taloon, orja oli siellä täysin terveenä. ");
INSERT INTO fin_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Vähän tämän jälkeen Jeesus lähti oppilaidensa kanssa Nain-nimiseen kaupunkiin. Kuten tavallista, paljon ihmisiä seurasi hänen kintereillään. ");
INSERT INTO fin_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Heidän ehtiessään kaupungin portille tuli hautajaissaatto heitä vastaan. Erään leskiäidin ainoa poika oli kuollut. Äidin mukana kulki suuri surevien joukko. ");
INSERT INTO fin_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kun Jeesus näki äidin, hänet valtasi syvä myötätunto ja hän sanoi: »Älä itke!» ");
INSERT INTO fin_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sitten hän astui paarien luo, ja kantajat pysähtyivät. »Poika, tule takaisin elämään», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Poika nousi istumaan ja sanoi jotain ympärillään oleville. Jeesus antoi hänet takaisin hänen äidilleen. ");
INSERT INTO fin_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ihmiset joutuivat pelon valtaan ja alkoivat kiittää Jumalaa. »Tänne on tullut suuri profeetta», he sanoivat. »Olemme tänään nähneet Jumalan toimivan.» ");
INSERT INTO fin_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tapahtuneesta levisi tieto ympäri Juudeaa ja sen ulkopuolellekin. ");
INSERT INTO fin_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Johannes Kastajan oppilaat kuulivat pian tästä kaikesta ja kertoivat Johannekselle. ");
INSERT INTO fin_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Silloin hän lähetti kaksi heistä kysymään Jeesukselta: »Oletko sinä tosiaan Messias vai onko meidän yhä odotettava häntä?» ");
INSERT INTO fin_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21-22","Johanneksen oppilaat löysivät Jeesuksen sairaiden keskeltä – hän paransi rampoja ja sokeita ja ajoi ihmisistä demoneja. Kuultuaan Johanneksen esittämän kysymyksen hän vastasi: »Menkää kertomaan Johannekselle, mitä olette täällä nähneet ja kuulleet: sokeat saavat näkönsä, liikuntakyvyttömät juoksevat, lepratautisissa ei näy enää sairauden merkkiäkään, kuurot kuulevat, kuolleet herätetään eloon ja köyhät saavat kuulla Jumalan iloisen uutisen. ");
INSERT INTO fin_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sanokaa Johannekselle myös: ’Onnellinen se, joka ei loukkaannu minuun!’» ");
INSERT INTO fin_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Heidän lähdettyään Jeesus puhui ihmisille Johanneksesta. »Millainen oli se mies, jota te menitte katsomaan Juudean autiomaahan?» hän kysyi. »Heikko kuin ruohonkorsi, jonka jokainen tuulenpuuska saa taipumaan? ");
INSERT INTO fin_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ja oliko hän hienoissa vaatteissa? Ei! Ne, jotka elävät ylellisyydessä, eivät viihdy autiomaassa, vaan palatsissa. ");
INSERT INTO fin_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Entä löysittekö profeetan? Kyllä, löysitte enemmänkin kuin profeetan! ");
INSERT INTO fin_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Raamattu puhuu juuri hänestä: ’Lähetän sanansaattajan edelläsi tekemään sinulle tietä.’ ");
INSERT INTO fin_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Johannes on ihmisistä suurin, mutta pieninkin Jumalan valtakunnan kansalainen on kuitenkin suurempi kuin hän.» ");
INSERT INTO fin_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kaikki, jotka kuulivat Johanneksen puhuvan – paatuneimmatkin – olivat Jumalan kanssa yhtä mieltä synneistään ja antoivat Johanneksen kastaa heidät. ");
INSERT INTO fin_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Vain fariseukset ja lainopettajat hylkäsivät suunnitelman, joka Jumalalla oli heitä varten, ja kieltäytyivät Johanneksen kasteesta. ");
INSERT INTO fin_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","»Mitä sellaisista ihmisistä on ajateltava?» Jeesus kysyi. »Mihin oikein heitä vertaisin? ");
INSERT INTO fin_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","He ovat kuin lapsia, jotka kiukuttelevat tovereilleen: ’Te ette tulleet mukaan leikkimään häitä ettekä te tulleet leikkimään hautajaisia!’ ");
INSERT INTO fin_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Johannes Kastaja paastoaa usein, eikä hän ole eläessään edes maistanut viiniä, ja te sanotte: ’Hänen täytyy olla riivattu!’ ");
INSERT INTO fin_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mutta kun minä syön ja juon, te sanotte: ’Hän on syömäri ja juoppo! Sitä paitsi hän seurustelee kaikenlaisten huonomaineisten tyyppien kanssa.’ ");
INSERT INTO fin_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kaikki Jumalan lapset ovat kuitenkin nähneet hänen viisautensa todeksi.» ");
INSERT INTO fin_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Eräs fariseus pyysi Jeesusta kotiinsa syömään, ja Jeesus meni. Kun käytiin pöytään, ");
INSERT INTO fin_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","tuli sisään huono nainen, joka oli kuullut Jeesuksen olevan siellä. Hänellä oli mukanaan hieno pullo kallista, hyvältä tuoksuvaa voidetta. ");
INSERT INTO fin_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nainen lysähti polvilleen Jeesuksen viereen ja itki niin, että Jeesuksen jalat kastuivat hänen kyynelistään. Nainen alkoi pyyhkiä hiuksillaan Jeesuksen jalkoja, suuteli niitä ja kaatoi niille koko voiteen. ");
INSERT INTO fin_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kun talon isäntä näki, mitä tapahtui ja kuka nainen oli, hän ajatteli itsekseen, ettei Jeesus voinut olla profeetta. »Jos hän tosiaan olisi Jumalan lähettämä, hän tietäisi, millainen nainen tuo on!» ");
INSERT INTO fin_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Tajuten, mitä mies ajatteli, Jeesus sanoi: »Simon, tahtoisin sanoa sinulle jotain.» »Ole hyvä vain, opettaja», Simon sanoi. ");
INSERT INTO fin_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jeesus kertoi hänelle: »Eräs mies lainasi kahdelle ihmiselle rahaa – toiselle viidensadan päivän palkan, toiselle kymmenesosan siitä. ");
INSERT INTO fin_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kun kumpikaan heistä ei pystynyt maksamaan takaisin, hän antoi hyväntahtoisena miehenä molempien pitää rahan omanaan. Kumpi mahtoi rakastaa häntä sen jälkeen enemmän?» ");
INSERT INTO fin_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","»Varmaankin se, joka oli ollut enemmän velkaa», Simon vastasi. »Niin varmasti», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sitten hän katsoi naista ja sanoi Simonille: »Näetkö naisen, joka on tässä polvillaan? Kun tulin teille, en saanut vettä pestäkseni pölyt jaloistani, mutta hän on kastellut jalkani kyynelillään ja kuivannut ne hiuksillaan. ");
INSERT INTO fin_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","En saanut sinulta tavanomaista tervehdyssuudelmaa, mutta hän on suudellut jalkojani siitä asti kun tulin tähän. ");
INSERT INTO fin_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Et voidellut päätäni oliiviöljyllä, niin kuin tapa on, mutta tämä nainen on kaatanut jaloilleni kalliin voiteen. ");
INSERT INTO fin_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Hän on tehnyt paljon syntiä, mutta saa kaiken anteeksi – hän on rakastanut minua paljon. Se, joka on saanut vähän anteeksi, rakastaa vain vähän.» ");
INSERT INTO fin_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Naiselle hän sanoi vielä: »Saat syntisi anteeksi.» ");
INSERT INTO fin_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Muut vieraat alkoivat ajatella: »Kuka tuo mies oikein luulee olevansa, kun tuolla tavoin antaa ihmisille syntejä anteeksi?» ");
INSERT INTO fin_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mutta Jeesus sanoi naiselle: »Uskosi on pelastanut sinut; voit lähteä rauhassa.» ");
INSERT INTO fin_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Pian tämän jälkeen Jeesus lähti kahdentoista oppilaansa kanssa kiertämään kaupunkeja ja kyliä ja julistamaan, että Jumalan valtakunta oli tullut. ");
INSERT INTO fin_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Joukkoon liittyi myös muutamia naisia, jotka Jeesus oli vapauttanut demonien vallasta tai jotka hän oli muuten parantanut: Maria Magdaleena, jossa oli ollut seitsemän demonia, ");
INSERT INTO fin_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kuusaan, kuningas Herodeksen taloudenhoitajan, vaimo Johanna, Susanna ja useita muita. He auttoivat varoillaan Jeesusta ja hänen oppilaitaan. ");
INSERT INTO fin_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Suuri joukko ihmisiä oli eräänä päivänä kerääntynyt Jeesuksen ympärille. Monia muita oli yhä tulossa eri kaupungeista, kun hän alkoi kertoa: ");
INSERT INTO fin_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","»Maanviljelijä meni pellolle kylvämään. Kun hän heitti siemeniä maahan, jotkut putosivat tielle ja tallautuivat, ja linnut huomasivat ne ja söivät pois. ");
INSERT INTO fin_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Osa putosi kalliolle ohueen kasvualustaan, jossa oraat pian kuivettuivat. ");
INSERT INTO fin_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Osa siemenistä lensi ohdakkeiden sekaan, missä hennot taimet tukehtuivat heti alkuunsa. ");
INSERT INTO fin_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Loput siemenet putosivat viljavaan maahan, kasvoivat hyvin ja tuottivat satakertaisen sadon.» Kerrottuaan tämän Jeesus jatkoi: »Jolla on kuulevat korvat – käyttäköön niitä nyt!» ");
INSERT INTO fin_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jeesuksen oppilaat kysyivät, mitä kertomus tarkoitti. ");
INSERT INTO fin_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Hän vastasi: »Te saatte tietää, mitä Jumalan valtakunnan salaisuuksia nämä vertaukset sisältävät. Muut eivät niitä ymmärrä, niin kuin profeetat aikoinaan ennustivatkin. ");
INSERT INTO fin_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Siemen merkitsee Jumalan sanaa. ");
INSERT INTO fin_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tallattu polku, jolle osa siitä putoaa, kuvaa sellaisten ihmisten sydäntä, jotka kuulevat sanoman, mutta joilta paholainen ryöstää sen ja estää niin heitä uskomasta ja pelastumasta. ");
INSERT INTO fin_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kallioinen maaperä kuvaa ihmisiä, jotka ovat iloisia kuullessaan hyvän uutisen, mutta joihin Jumalan sana ei koskaan pääse juurtumaan. He tietävät, että se on totta, ja uskovat siihen hetken jollakin tavalla, mutta muiden houkutusten ilmaantuessa heidän mielenkiintonsa katoaa. ");
INSERT INTO fin_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ohdakkeinen maa on kuin ihmiset, jotka kuulevat ja uskovat Jumalan sanan, mutta jotka pian menettävät uskonsa, sillä jokapäiväiset huolet ja rikkauden ja nautintojen tavoittelu tukahduttavat sen. He eivät pysty koskaan auttamaan muita sisälle Jumalan valtakuntaan. ");
INSERT INTO fin_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Hyvä maaperä sen sijaan kuvaa ihmisiä, jotka kuultuaan Jumalan sanaa alkavat elää sen mukaan vilpittömästi ja ehyesti.» ");
INSERT INTO fin_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kerran taas Jeesus kysyi: »Oletteko kuulleet, että kukaan olisi pannut lampun palamaan ja sitten peittänyt sen, ettei valo näkyisi? Kyllä lamput pidetään esillä. ");
INSERT INTO fin_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kaikki, mitä on ihmisen sydämessä, paljastuu kerran samalla tavoin. ");
INSERT INTO fin_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Olkaa kuunnellessanne tarkkoja, sillä sellaiselle annetaan lisää, jolla jo on, mutta sellainen, jolla ei mitään ole, menettää senkin mitä luulee omistavansa.» ");
INSERT INTO fin_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jeesuksen äiti ja veljet tulivat kerran tapaamaan häntä, mutta eivät päässeet väenpaljouden vuoksi sisälle taloon, jossa hän opetti. ");
INSERT INTO fin_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Kun Jeesukselle kerrottiin heidän olevan ulkona ja haluavan tavata hänet, ");
INSERT INTO fin_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jeesus vastasi: »Äitini ja veljeni ovat nämä, jotka kuulevat Jumalan sanan ja tottelevat sitä.» ");
INSERT INTO fin_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Eräänä päivänä Jeesus ehdotti oppilailleen, että he lähtisivät veneellä yli järvenselän. ");
INSERT INTO fin_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Matkalla Jeesus nukkui. Tuuli alkoi voimistua, ja ennen pitkää he joutuivat myrskyn kouriin. Vettä tulvi veneeseen, ja he olivat suuressa vaarassa. ");
INSERT INTO fin_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Oppilaat herättivät hädissään Jeesuksen. »Me hukumme!» he huusivat. Jeesus sanoi silloin myrskylle: »Tyynny!» Tuuli ja aallot hiljenivät heti, ja tuli aivan tyyntä. ");
INSERT INTO fin_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Oppilailta hän kysyi: »Missä teidän uskonne on?» Mutta oppilaat olivat peloissaan ja hämmästyneitä. He katsoivat toisiinsa: »Kuka tämä mies oikein on, kun jopa tuuli ja aallot tottelevat häntä?» ");
INSERT INTO fin_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","He pääsivät järven toiselle puolelle Gerasan alueelle, joka on Galileaa vastapäätä. ");
INSERT INTO fin_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jeesuksen noustessa maihin hänen luokseen tuli eräs mies, joka oli pitkään ollut pahojen henkien vallassa. Hän oli asunut hautaluolissa kodittomana ja alastomana. ");
INSERT INTO fin_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jeesuksen nähdessään mies parahti ja heittäytyi maahan hänen eteensä. »Mitä sinä minusta tahdot, Jeesus, korkeimman Jumalan Poika? Älä kiusaa minua!» mies huusi. ");
INSERT INTO fin_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jeesus oli juuri aikeissa käskeä demonia lähtemään miehestä. Paha henki oli pitänyt häntä täysin vallassaan, niin että hän oli murtanut kahleetkin, joihin hänet oli sidottu, ja juossut pakoon asumattomille seuduille. ");
INSERT INTO fin_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jeesus kysyi demonilta: »Mikä on nimesi?» »Legioona», kuului vastaus, sillä miehessä oli paljon henkiä. ");
INSERT INTO fin_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ne kerjäsivät, ettei Jeesus ajaisi niitä syvyyteen. ");
INSERT INTO fin_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Suuri sikalauma oli laitumella läheisellä vuorenrinteellä, ja demonit pyysivät, että saisivat mennä sikoihin. Jeesus antoi niille luvan. ");
INSERT INTO fin_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ne siirtyivät miehestä sikoihin, ja koko lauma ryntäsi äkkiä alas vuorenrinnettä, syöksyi kallion yli järveen ja hukkui. ");
INSERT INTO fin_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Sikalauman hoitajat juoksivat kaupunkiin ja kertoivat jo matkalla kaikille tapahtuneesta. ");
INSERT INTO fin_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ihmiset lähtivät paikalle nähdäkseen omin silmin, mitä oli tapahtunut. Demonien vallassa ollut mies istui nyt rauhallisena ja siistinä, vaatteet yllään, kuuntelemassa Jeesuksen puhetta. Pelko valtasi väkijoukot. ");
INSERT INTO fin_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Silminnäkijät kuvailivat, miten mies oli vapautunut henkien vallasta. ");
INSERT INTO fin_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Peloissaan kaikki pyysivät Jeesusta lähtemään pois. Hän palasi veneeseen ja purjehti takaisin järven toiselle puolelle. ");
INSERT INTO fin_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Demoneista vapautunut mies olisi halunnut lähteä mukaan, mutta Jeesus ei ottanut häntä. ");
INSERT INTO fin_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","»Mene kertomaan omaisillesi, mitä suurta Jumala on tehnyt sinulle», Jeesus kehotti. Mies kertoi kaikille kaupunkilaisille Jeesuksen tekemästä ihmeestä. ");
INSERT INTO fin_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Järven toisella puolella Jeesus otettiin avosylin vastaan, sillä ihmiset olivat odottaneet häntä. ");
INSERT INTO fin_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Juutalaisten synagogan johtaja Jairus oli odottajien joukossa. Hän heittäytyi Jeesuksen eteen ja pyysi tätä tulemaan kotiinsa, ");
INSERT INTO fin_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","sillä hänen ainoa lapsensa, kaksitoistavuotias tyttö, oli kuolemaisillaan. Jeesus lähti hänen kanssaan, ja he tunkeutuivat ihmisjoukon läpi. ");
INSERT INTO fin_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","44","Eräs nainen, joka halusi parantua, kosketti Jeesusta takaapäin. Nainen oli etsinyt kaikkialta apua verenvuototautiin, jota hän oli sairastanut kaksitoista vuotta. Koko omaisuutensa hän oli menettänyt lääkäreille. Kun hän kosketti Jeesuksen viitan reunaa, vuoto tyrehtyi heti. ");
INSERT INTO fin_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","»Kuka minuun koski?» Jeesus kysyi. Kukaan ei tunnustanut, ja Pietari sanoi: »Opettaja, monet ihmisethän tungeksivat sinua vasten…» ");
INSERT INTO fin_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jeesus vakuutti hänelle: »Joku nimenomaan kosketti minua, sillä tunsin parantavaa voimaa lähtevän itsestäni.» ");
INSERT INTO fin_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nainen alkoi vapista tajutessaan, että Jeesus tiesi, mitä hän oli tehnyt. Hän heittäytyi Jeesuksen eteen polvilleen ja kertoi, miksi oli koskettanut häntä. Hän sanoi myös parantuneensa heti. ");
INSERT INTO fin_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","»Tyttäreni, uskosi on parantanut sinut. Mene rauhassa kotiisi», Jeesus sanoi hänelle. ");
INSERT INTO fin_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jeesuksen vielä puhuessa tuli Jairuksen kotoa tieto, että tyttö oli kuollut. Sanantuoja kertoi tästä Jairukselle ja jatkoi: »Sinun ei kannata enää vaivata opettajaa.» ");
INSERT INTO fin_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Mutta kuultuaan, mitä oli tapahtunut, Jeesus sanoi isälle: »Älä pelkää! Luota vain minuun, niin tyttäresi on pian terve.» ");
INSERT INTO fin_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairuksen kotona Jeesus otti vain Pietarin, Jaakobin ja Johanneksen sekä tytön vanhemmat mukaansa mennessään tytön luo. ");
INSERT INTO fin_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Talo oli täynnä surevia ihmisiä, mutta Jeesus sanoi heille: »Lakatkaa valittamasta! Ei hän ole kuollut: hän vain nukkuu!» ");
INSERT INTO fin_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ihmiset alkoivat nauraa pilkallisesti, sillä kaikki tiesivät, että tyttö oli kuollut. ");
INSERT INTO fin_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jeesus tarttui tytön käteen ja sanoi: »Nousehan, tyttö pieni!» ");
INSERT INTO fin_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ja kuollut palasi elämään ja nousi heti pystyyn. »Antakaa hänelle ruokaa», Jeesus kehotti. ");
INSERT INTO fin_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tytön vanhemmat olivat riemuissaan, mutta Jeesus kielsi heitä kertomasta kenellekään tapahtuman yksityiskohtia. ");
INSERT INTO fin_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jeesus pyysi eräänä päivänä kaksitoista oppilastaan luokseen ja antoi heille vallan ajaa ihmisistä pahoja henkiä ja parantaa kaikkia sairauksia. ");
INSERT INTO fin_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Hän lähetti heidät kertomaan kaikille Jumalan valtakunnan tulosta ja parantamaan sairaita. ");
INSERT INTO fin_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","»Älkää ottako mukaanne matkasauvaa, laukkua, ruokaa tai rahaa», hän neuvoi. »Älkää myöskään ottako kahta takkia. ");
INSERT INTO fin_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Majailkaa kussakin kylässä vain yhdessä talossa. ");
INSERT INTO fin_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jos jonkin kaupungin asukkaat eivät halua kuunnella teitä, lähtekää sieltä ja karistakaa pölyt jaloistanne osoituksena Jumalan vihasta.» ");
INSERT INTO fin_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","He alkoivat kiertää kylissä, kertoa hyvää uutista ja parantaa sairaita. ");
INSERT INTO fin_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galilean hallitsija Herodes ei tiennyt mitä ajatella, kun tiedot Jeesuksen tekemistä ihmeistä kantautuivat hänen korviinsa. Jotkut sanoivat: »Johannes Kastaja on herännyt henkiin», ");
INSERT INTO fin_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ja jotkut muut väittivät: »Elia on tullut takaisin tai joku toinen vanhan ajan profeetta noussut haudasta.» Tällaiset huhut kiertelivät koko maassa. ");
INSERT INTO fin_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","»Minähän annoin tappaa Johanneksen», Herodes sanoi. »Kuka oikein on tämä mies, josta kuulen kummallisia huhuja?» Hän yritti päästä näkemään Jeesusta. ");
INSERT INTO fin_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Kun apostolit olivat palanneet kierrokseltaan Jeesuksen luo ja kertoneet, mitä olivat tehneet, he vetäytyivät kaikessa hiljaisuudessa Beetsaidan kaupunkiin. ");
INSERT INTO fin_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mutta väkijoukot huomasivat sen ja lähtivät perässä. Jeesus otti ihmiset vastaan, puhui heille taas Jumalan valtakunnasta ja paransi sairaat. ");
INSERT INTO fin_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Illan suussa Jeesuksen kaksitoista oppilasta tulivat hänen luokseen ja pyysivät, että hän lähettäisi ihmiset lähiseudun kyliin ja maataloihin syömään ja yöpymään. »Eihän tässä asumattomassa maankolkassa mistään ruokaa saa», he sanoivat. ");
INSERT INTO fin_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mutta Jeesus vastasi: »Antakaa te heille syötävää!» »Me? Meillä on vain viisi leipää ja kaksi kalaa», he sanoivat. »Et kai odota, että lähtisimme ostamaan ruokaa koko joukolle?» ");
INSERT INTO fin_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Paikalla oli noin viisituhatta miestä. »Käskekää ihmisten istua maahan noin viidenkymmenen hengen ryhmiin», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Oppilaat tekivät niin. ");
INSERT INTO fin_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jeesus otti ne viisi leipää ja kaksi kalaa, katsoi taivaalle ja siunasi ne. Sitten hän mursi leivistä ja kaloista oppilailleen paloja, joita nämä jakoivat ihmisille. ");
INSERT INTO fin_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Jokainen söi tarpeekseen, ja lopuksi kerättiin vielä kaksitoista täyttä korillista tähteitä. ");
INSERT INTO fin_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jeesus tuli eräänä päivänä oppilaidensa luo rukoiltuaan lähistöllä yksinään ja kysyi: »Kuka minä ihmisten mielestä olen?» ");
INSERT INTO fin_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","»Johannes Kastaja tai Elia tai joku entisajan profeetta, joka on herännyt kuolleista», he vastasivat. ");
INSERT INTO fin_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Sitten hän kysyi: »Kuka minä sitten teidän mielestänne olen?» Pietari vastasi: »Messias – Jumalan lähettämä Kristus!» ");
INSERT INTO fin_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jeesus pyysi vakavasti, että he eivät kertoisi sitä kenellekään. ");
INSERT INTO fin_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","»Minun on kärsittävä paljon», hän sanoi. »Juutalaisten johtajat – kansan vanhimmat, ylipapit ja lainopettajat – torjuvat minut, ja sitten minut surmataan, mutta kolme päivää myöhemmin virkoan jälleen eloon.» ");
INSERT INTO fin_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Hän sanoi kaikille: »Jokaisen, joka haluaa seurata minua, on luovuttava omista mieliteoistaan ja mukavuudestaan, otettava joka päivä ristinsä ja pysyttävä lähelläni. ");
INSERT INTO fin_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jokainen, joka menettää minun tähteni elämänsä, pelastaa sen, mutta joka pitää elämästään kiinni, kadottaa sen. ");
INSERT INTO fin_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mitä hyötyä siitä on, jos ihminen voittaa omakseen vaikka koko maailman, mutta samalla tuhoaa itsensä? ");
INSERT INTO fin_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kun kerran palaan kirkkaudessani ja Isäni ja pyhien enkelien kirkkaudessa, häpeän jokaista, joka nyt häpeää minua ja sanojani. ");
INSERT INTO fin_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tosiasia on, että jotkut teistä tässä seisovista eivät kuole, ennen kuin näkevät Jumalan valtakunnan.» ");
INSERT INTO fin_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Kahdeksan päivää myöhemmin Jeesus lähti Pietarin, Jaakobin ja Johanneksen kanssa vuorelle rukoilemaan. ");
INSERT INTO fin_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kun hän rukoili, hänen kasvonsa alkoivat säteillä ja vaatteensa tulivat häikäisevän valkoisiksi. ");
INSERT INTO fin_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Hänen viereensä ilmestyi kaksi miestä, Mooses ja Elia, jotka rupesivat keskustelemaan hänen kanssaan. ");
INSERT INTO fin_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Hekin säteilivät kirkkautta. Miehet puhuivat Jeesuksen kuolemasta, joka tapahtuisi Jerusalemissa Jumalan suunnitelman mukaan. ");
INSERT INTO fin_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pietari ja toiset kaksi olivat väsyneinä nukahtaneet. Nyt he säpsähtivät hereille ja näkivät Jeesuksen kaikessa loistossaan ja hänen vierellään seisovat miehet. ");
INSERT INTO fin_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kun Mooses ja Elia olivat lähdössä, tokaisi hämmentynyt Pietari tajuamatta oikein mitä sanoi: »Opettaja, tämä on ihmeellistä! Rakennetaan tänne kolme majaa: yksi sinulle, yksi Moosekselle ja yksi Elialle!» ");
INSERT INTO fin_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Hän ei ollut vielä lopettanut lausetta, kun heidän yläpuolelleen muodostui kirkas pilvi. Kun se peitti heidät sisäänsä, he olivat kauhuissaan, ");
INSERT INTO fin_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","mutta pilvestä kuuluikin ääni: »Tämä on minun Poikani, jonka olen valinnut – kuunnelkaa häntä.» ");
INSERT INTO fin_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Äänen vaietessa oppilaat eivät nähneet paikalla enää muita kuin Jeesuksen. Vasta paljon myöhemmin he kertoivat tapahtumasta muille. ");
INSERT INTO fin_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Suunnaton ihmispaljous oli heitä vastassa, kun he seuraavana päivänä laskeutuivat vuorelta. ");
INSERT INTO fin_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Eräs mies huusi väkijoukon keskeltä: »Opettaja, täällä on ainoa poikani. ");
INSERT INTO fin_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Paha henki hyökkää usein hänen kimppuunsa, niin että hän alkaa kirkua, häntä kouristaa ja vaahtoa valuu hänen suustaan. Se toistuu vähän väliä. ");
INSERT INTO fin_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Olen pyytänyt oppilaitasi ajamaan hengen pois, mutta he eivät pystyneet siihen.» ");
INSERT INTO fin_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","»Voi teitä jäykkäniskaisia ja epäuskoisia ihmisiä», Jeesus sanoi oppilailleen. »Miten kauan minun on kestettävä teitä? Tuo poika tänne!» ");
INSERT INTO fin_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kun poika oli tulossa, demoni iski hänet maahan, ja häntä alkoi pahasti kouristaa. Mutta Jeesus käski demonia lähtemään, paransi pojan ja ohjasi hänet takaisin isänsä luo. ");
INSERT INTO fin_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pelko ja kunnioitus valtasi ihmiset, kun he näkivät tämän osoituksen Jumalan voimasta. Heidän hämmästellessään ihmeitä, joita Jeesus teki, tämä sanoi oppilailleen: ");
INSERT INTO fin_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","»Kuulkaa, mitä minä sanon, ja painakaa mieleenne: ihmiset pettävät minut, Ihmisen Pojan.» ");
INSERT INTO fin_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mutta oppilaat eivät tajunneet, mitä hän tarkoitti, eivätkä uskaltaneet kysyä häneltä. ");
INSERT INTO fin_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","He alkoivat väitellä, kuka heistä oli suurin. ");
INSERT INTO fin_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jeesus tiesi, mitä he ajattelivat, talutti pienen lapsen heidän viereensä ");
INSERT INTO fin_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ja sanoi: »Joka ottaa huolehtiakseen tällaisesta pienestä lapsesta, ottaa vastaan minut. Ja jokainen, joka avaa sydämensä minulle, avaa sen myös Jumalalle, joka lähetti minut. Suuruutenne mitataan sillä, miten pidätte huolta toisista.» ");
INSERT INTO fin_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sitten Johannes, yksi oppilaista, tuli sanomaan hänelle: »Opettaja, näimme jonkun ajavan sinun nimessäsi ulos pahoja henkiä ja kielsimme häntä, koska hän ei kuulu meidän ryhmäämme.» ");
INSERT INTO fin_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jeesus sanoi: »Sitä teidän ei olisi tarvinnut tehdä. Jos joku ei ole teitä vastaan, hän on puolellanne.» ");
INSERT INTO fin_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kun Jeesuksen taivaaseen palaamisen aika lähestyi, hän alkoi määrätietoisesti suunnata kulkuaan Jerusalemiin päin. ");
INSERT INTO fin_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Eräänä päivänä hän lähetti miehiä edellään varaamaan heille majapaikkaa samarialaisesta kylästä. ");
INSERT INTO fin_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Miehet käännytettiin takaisin. Kyläläiset eivät halunneet olla missään tekemisissä heidän kanssaan, koska he olivat menossa Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kun tieto tapahtuneesta tuli oppilaiden korviin, Jaakob ja Johannes sanoivat Jeesukselle: »Opettaja, käskemmekö tulen iskeä taivaasta alas ja polttaa heidät poroksi?» ");
INSERT INTO fin_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jeesus moitti heitä tästä, ");
INSERT INTO fin_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ja he jatkoivat matkaansa toiseen kylään. ");
INSERT INTO fin_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Heidän kulkiessaan tuli joku sanomaan Jeesukselle: »Haluan seurata sinua mihin tahansa.» ");
INSERT INTO fin_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Mutta Jeesus vastasi: »Muista, ettei minulle ole paikkaa, mihin painaisin pääni. Ketuilla on luolat ja linnuilla pesät, mutta minulla, joka olen tullut taivaasta, ei ole kotia maan päällä.» ");
INSERT INTO fin_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Eräälle miehelle Jeesus sanoi: »Tule minun oppilaakseni.» Mies vastasi: »Minun pitäisi ensin hoitaa eräs tärkeä asia.» ");
INSERT INTO fin_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jeesus sanoi: »Anna niiden, joilla ei ole ikuista elämää, murehtia tämän maailman asioista. Sinun tehtäväsi on julistaa Jumalan valtakunnan tuloa kaikille ihmisille.» ");
INSERT INTO fin_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Vielä joku sanoi: »Minä tulen mukaasi, Herra, mutta saanhan ensin käydä puhumassa vanhempieni kanssa.» ");
INSERT INTO fin_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Hänelle Jeesus vastasi: »Joka ryhtyy Jumalan valtakunnan työhön, mutta hajottaa voimansa kaikkeen muuhun, ei sovi saamaansa tehtävään.» ");
INSERT INTO fin_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Herra valitsi seitsemänkymmentä muuta oppilasta ja lähetti heidät pareittain kaikkiin kaupunkeihin ja kyliin, joissa aikoi myöhemmin käydä. ");
INSERT INTO fin_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hän antoi heille ohjeita: »Satoa on paljon, mutta korjaajia vähän. Pyytäkää Herraa, joka sadon omistaa, antamaan avuksenne lisää työntekijöitä. ");
INSERT INTO fin_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Muistakaa, että lähetän teidät kuin lampaat susien keskelle. ");
INSERT INTO fin_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Älkää ottako mukaanne rahaa tai laukkua, älkää edes ylimääräisiä kenkiä. Älkää antako vastaantulijoiden viivyttää itseänne. ");
INSERT INTO fin_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Siunatkaa jokaista kotia, johon menette. ");
INSERT INTO fin_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jos se on siunauksen arvoinen, siunauksenne jää sinne – muussa tapauksessa se palaa teille itsellenne. ");
INSERT INTO fin_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kylään tullessanne älkää muuttako talosta toiseen, vaan pysykää yhdessä paikassa ja syökää ja juokaa mitä saatte. Älkää epäröikö nauttia vieraanvaraisuutta, sillä työmies on ansainnut palkkansa. ");
INSERT INTO fin_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","9","Kun teidät otetaan kaupungissa vastaan, muistakaa nämä neuvot: syötte, mitä teille tarjotaan, ja parannatte sairaat. Kertokaa samalla, että Jumalan valtakunta on nyt hyvin lähellä. ");
INSERT INTO fin_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jos teitä ei huolita johonkin kaupunkiin, menkää kadulle ja ilmoittakaa: ");
INSERT INTO fin_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","’Karistamme kaupunkinne pölytkin jaloistamme. Muistakaa aina, miten lähellä Jumalan valtakuntaa olitte. Vastuu on nyt teidän.’ ");
INSERT INTO fin_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tuomiopäivä on jopa pahuudestaan kuuluisalle Sodomalle helpompi kuin sellaiselle kaupungille. Voi teitä, Korasin ja Beetsaida! ");
INSERT INTO fin_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mitkä kauhut teitä odottavat! Jos olisin tehnyt Tyyrossa ja Siidonissa ne ihmeet, jotka tein teidän nähtenne, niiden asukkaat olisivat ajat sitten katuneet katkerasti, pukeutuneet säkkiin, ripotelleet tuhkaa päälleen ja kääntyneet. ");
INSERT INTO fin_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Tyyrolla ja Siidonilla on tuomiopäivänä helpompaa kuin teillä. ");
INSERT INTO fin_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Entä miten käy Kapernaumin asukkaiden? Pääsettekö te taivaaseen? Ei, kadotukseen teidän on mentävä.» ");
INSERT INTO fin_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sitten hän sanoi oppilailleen: »Ne, jotka ottavat vastaan teidät, ottavat vastaan minut. Jotka torjuvat teidät, torjuvat minut. Ja ne, jotka eivät välitä minusta, hylkäävät Jumalan, joka on lähettänyt minut.» ");
INSERT INTO fin_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kun ne seitsemänkymmentä matkaan lähetettyä tulivat takaisin, he kertoivat iloisina: »Jopa demonit tottelevat meitä, kun käytämme sinun nimeäsi.» ");
INSERT INTO fin_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","»Näin, miten saatana putosi taivaasta kuin salaman leimaus», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","»Olen antanut teille vallan kaikkea vihollisen voimaa vastaan. Voitte kävellä käärmeiden ja skorpionien keskellä ja murskata ne jalkoihinne vanhingoittumatta itse mistään. ");
INSERT INTO fin_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tärkeintä ei kuitenkaan ole se, että pahat henget tottelevat teitä, vaan se, että teidät on merkitty taivaan kansalaisiksi.» ");
INSERT INTO fin_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pyhän Hengen ilo täytti hänet ja hän sanoi: »Kiitos Isä, taivaan ja maan Herra, ettet ole paljastanut salaisuuksiasi maailman mielestä viisaille, vaan niille, jotka uskovat kuin pieni lapsi. Niin, kiitos Isä siitä, että olet tämän näin suunnitellut. ");
INSERT INTO fin_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Olen kaikessa Isäni edustaja maan päällä, ja vain Isä tuntee Pojan todella. Isää taas ei tunne kukaan muu kuin Poika ja ne, joille tämä haluaa ilmaista Isän.» ");
INSERT INTO fin_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sitten hän sanoi hiljaa lähimmille oppilailleen: »Teillä on ollut erityinen etuoikeus nähdä nämä tapahtumat. ");
INSERT INTO fin_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Monet vanhan ajan profeetat ja kuninkaat olisivat halunneet elää tänä aikana nähdäkseen ja kuullakseen saman kuin te.» ");
INSERT INTO fin_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Eräs Mooseksen lain erikoistuntija tuli koettelemaan Jeesuksen oikeaoppisuutta kysymällä: »Opettaja, mitä ihmisen on tehtävä, että saisi ikuisen elämän taivaassa?» ");
INSERT INTO fin_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jeesus vastasi: »Mitä Mooseksen laki käskee?» ");
INSERT INTO fin_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","»Sen mukaan meidän on rakastettava Herraa, Jumalaamme, sydämen pohjasta, kaikin voimin, koko olemuksellamme ja järjellämme», mies vastasi. »Meidän on myös rakastettava muita ihmisiä niin kuin itseämme.» ");
INSERT INTO fin_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","»Oikein!» Jeesus sanoi. »Saat elämän, kun teet niin.» ");
INSERT INTO fin_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mies halusi puolustella sitä, ettei osoittanut rakkautta kaikille ihmisille ja kysyi: »Kuka sitten on minun lähimmäiseni, jota minun on rakastettava?» ");
INSERT INTO fin_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Vastaukseksi Jeesus kertoi vertauksen: »Maantierosvot hyökkäsivät erään juutalaisen kimppuun, joka oli matkalla Jerusalemista Jerikoon. He ryöstivät hänet putipuhtaaksi, löivät verille ja jättivät puolikuolleena tien viereen. ");
INSERT INTO fin_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Sattumalta eräs juutalainen pappi kulki siitä ohi. Nähdessään miehen hän väisti toiselle puolelle tietä ja jatkoi matkaansa. ");
INSERT INTO fin_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Samoin ohikulkeva temppelin virkailija jätti hänet sinne makaamaan. ");
INSERT INTO fin_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sitten paikalle osui halveksittu samarialainen, jonka tuli miestä sääli. ");
INSERT INTO fin_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Hän meni ryöstetyn luo ja lääkitsi ja sitoi tämän haavat. Sitten hän nosti miehen aasinsa selkään ja talutti sen majataloon. Siellä hän hoiti sairasta koko yön. ");
INSERT INTO fin_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Aamulla hän antoi majatalon omistajalle rahaa ja ja pyysi tätä huolehtimaan miehestä. ’Jos kustannukset kohoavat suuremmiksi, maksan erotuksen seuraavan kerran täällä käydessäni’, hän lupasi. ");
INSERT INTO fin_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kuka noista kolmesta osoitti rosvojen uhrille lähimmäisenrakkautta?» ");
INSERT INTO fin_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mies vastasi: »Se, joka auttoi häntä.» Jeesus sanoi: »Elä sinä samalla tavalla.» ");
INSERT INTO fin_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kun Jeesus jatkoi oppilaidensa kanssa matkaa Jerusalemia kohti, pyysi Martta-niminen nainen heitä eräässä kylässä kotiinsa. ");
INSERT INTO fin_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Hänen sisarensa Maria kävi lattialle istumaan ja kuunteli siinä, mitä Jeesus puhui. ");
INSERT INTO fin_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martta oli hermostunut, sillä hänellä oli paljon tehtävää. Hän tuli sanomaan Jeesukselle: »Herra, eihän sinustakaan ole oikein, että sisareni vain istuu täällä, kun minulla on niin paljon työtä? Käske hänen auttaa minua.» ");
INSERT INTO fin_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Mutta Herra sanoi hänelle: »Martta, Martta! Suotta sinä hätäilet kaikista pikkuasioista! ");
INSERT INTO fin_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Vain yksi asia on todella tärkeä. Maria on huomannut, mikä se on, enkä aio ottaa sitä häneltä pois.» ");
INSERT INTO fin_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jeesus oli juuri ollut rukoilemassa, kun yksi oppilaista tuli pyytämään häneltä: »Herra, opeta meille jokin rukous, niin kuin Johanneskin opetti oppilailleen.» ");
INSERT INTO fin_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ja Jeesus opetti heitä rukoilemaan näin: »Isä, auta meitä kunnioittamaan pyhää nimeäsi. Anna valtakuntasi pian tulla. ");
INSERT INTO fin_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Anna meille joka päivä mitä tarvitsemme, ");
INSERT INTO fin_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ja anna meidän syntimme anteeksi, sillä mekin olemme antaneet anteeksi niille, jotka ovat tehneet syntiä meitä vastaan. Vapauta meidät kiusauksista.» ");
INSERT INTO fin_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Hän opetti heille lisää rukouksesta: »Kuvitelkaa, että menette keskiyöllä ystävänne kotiin lainaamaan kolmea leipää. Huudatte oven takaa: ’Eräs ystäväni tuli meille, eikä minulla ole hänelle mitään tarjottavaa.’ ");
INSERT INTO fin_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Naapuri vastaa vuoteestaan: ’Älä häiritse minua enää. Ovi on jo lukossa ja me olemme kaikki nukkumassa. Minä en nyt kerta kaikkiaan voi auttaa sinua.’ ");
INSERT INTO fin_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Mutta sanonpa teille: vaikka hän ei avaisikaan ovea siksi, että on ystävänne, hän antaa teille sen mitä haluatte, jos vain itsepintaisesti jatkatte koputtamista tarpeeksi kauan. ");
INSERT INTO fin_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Sama koskee rukousta. Pyytäkää sinnikkäästi, niin saatte. Etsikää, niin löydätte. Kolkuttakaa, niin ovi avataan. ");
INSERT INTO fin_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jokainen pyytävä saa ja etsivä löytää, ja kaikille, jotka kolkuttavat, avataan ovi. ");
INSERT INTO fin_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Annatteko te, isät, pojallenne kiven, jos hän pyytää teiltä leipää? Jos hän pyytää kalaa, annatteko hänelle käärmeen? ");
INSERT INTO fin_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Tai jos hän pyytää munaa, annatteko skorpionin? ");
INSERT INTO fin_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jos kerran teidänlaisenne syntiset ihmiset antavat lapsilleen, mitä nämä tarvitsevat, miten Taivaan Isä ei tekisi enemmän? Hän antaa Pyhän Hengen niille, jotka häneltä pyytävät.» ");
INSERT INTO fin_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kun Jeesus oli eräänä päivänä vapauttanut mykän miehen riivaajahengen vallasta, mies sai puhekykynsä takaisin. Väkijoukko oli kiihtynyt ja innoissaan, ");
INSERT INTO fin_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","mutta jotkut sanoivat: »Mikä ihme se on, että hän ajaa pahoja henkiä ihmisistä. Hänhän saa voimansa itse paholaiselta, riivaajahenkien kuninkaalta!» ");
INSERT INTO fin_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Toiset pyysivät, että hän antaisi jonkin merkin näkyä taivaalla osoittaakseen olevansa Messias, kuten väitti. ");
INSERT INTO fin_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Hän tiesi jokaisen ajatukset ja sanoi: »Sisällissotaan joutunut maa on tuhon oma, samoin koti, jossa riidellään. ");
INSERT INTO fin_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jos paholainen tosiaan taistelee itseään vastaan niin että antaa minulle voiman ajaa omia henkiään tiehensä, miten hänen valtakuntansa voi kestää? ");
INSERT INTO fin_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jos minun voimani tulee häneltä, mistä teidän seuraajanne sitten saavat voiman? Hehän myös ajavat ulos demoneja. Osoittaako se mielestänne, että saatana hallitsee heitä? Kysykää heiltä, oletteko oikeassa! ");
INSERT INTO fin_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jos ajan pahoja henkiä ulos Jumalan voimalla, se osoittaa, että Jumalan valtakunta on tullut. ");
INSERT INTO fin_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kun saatana vahvana ja hyvin aseistautuneena vartioi linnaansa, hän on turvassa – ");
INSERT INTO fin_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","kunnes joku vahvempi ja paremmin aseistettu hyökkää hänen kimppuunsa ja voittaa hänet, riisuu aseista ja ryöstää hänen omaisuutensa. ");
INSERT INTO fin_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Se, joka ei ole puolellani, on minua vastaan; jos joku ei auta minua, hän vahingoittaa asiaani. ");
INSERT INTO fin_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kun paha henki karkotetaan ihmisestä, se lähtee asumattomiin paikkoihin etsimään lepoa. Kun se ei saa rauhaa, se palaa takaisin ");
INSERT INTO fin_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ja huomaa, että sen entinen koti onkin nyt lakaistu ja puhdas. ");
INSERT INTO fin_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nyt se käy hakemassa seitsemän muuta henkeä, jotka ovat vielä pahempia kuin se itse, ja ne kaikki asettuvat sinne asumaan. Ihmisraukan tila on nyt seitsemän kertaa huonompi kuin aikaisemmin.» ");
INSERT INTO fin_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hänen puhuessaan joku nainen huusi väkijoukon keskeltä: »Jumala siunatkoon äitiäsi, joka sinut synnytti ja sinua rinnoillaan ravitsi.» ");
INSERT INTO fin_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Hän vastasi: »Vielä enemmän Jumala siunaa niitä, jotka kuulevat hänen sanansa ja elävät niiden mukaan.» ");
INSERT INTO fin_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","30","Kun kansaa tungeksi hänen ympärillään, hän puhui heille: »Aika on paha ja ihmiset pahoja. He vaativat minulta merkkiä taivaalle todisteeksi siitä, että olen Messias, mutta he saavat minulta vain Joonan todisteen. Se, mitä Joona koki, osoitti Niiniven asukkaille, että hän oli Jumalan lähettämä. Samoin se, mitä minulle tapahtuu, todistaa teille, että minä olen Jumalan lähettämä. ");
INSERT INTO fin_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Saban kuningatar nousee tuomiopäivänä tätä sukupolvea vastaan ja tulee sille tuomioksi; hän teki pitkän ja vaivalloisen matkan päästäkseen kuulemaan Salomon viisautta, ja teillä on nyt joukossanne paljon suurempi mies kuin Salomo, mutta vain harvat välittävät hänestä. ");
INSERT INTO fin_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Myös Niiniven miehet heräävät tuomitsemaan tämän kansan, sillä Joonan puhuessa he katuivat, ja Joonaa paljon suurempi mies on nyt täällä, mutta tämä kansa ei halua kuunnella.» ");
INSERT INTO fin_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ei kukaan pane lamppua piiloon sytytettyään sen ensin palamaan. Se pannaan näkyviin, jotta valosta olisi hyötyä kaikille huoneeseen tuleville. ");
INSERT INTO fin_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Silmäsi antaa sisimpääsi valon. Terveet silmät välittävät auringonpaisteen sieluusi. Himoitsevat silmät sammuttavat valon, ja joudut pimeään. ");
INSERT INTO fin_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ole varuillasi, ettei auringonpaiste peity! ");
INSERT INTO fin_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Jos sisimpäsi on täynnä valoa, niin ettei mikään nurkka jää pimeään, on ympärilläsikin valoisaa – aivan kuin olisit kirkkaan lampun loisteessa. ");
INSERT INTO fin_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","38","Samassa yhteydessä eräs fariseus pyysi Jeesusta kotiinsa syömään. Tultuaan sisään Jeesus kävi heti pöytään eikä peseytynyt niin kuin juutalaisten tapa vaati. Hänen isäntänsä oli tästä hyvin hämmästynyt. ");
INSERT INTO fin_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jeesus sanoi hänelle silloin: »Te fariseukset olette kyllä päältäpäin puhtaita mutta sisältä likaisia – täynnä ahneutta ja pahuutta. ");
INSERT INTO fin_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Olette järjettömiä! Eikö Jumala ole tehnyt niin sisä- kuin ulkopuoltakin? ");
INSERT INTO fin_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Sisäinen puhtaus tulee näkyviin anteliaisuutena. ");
INSERT INTO fin_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Voi teitä fariseuksia! Kyllä te luovutatte tarkkaan kymmenykset pienimmistäkin tuloistanne, mutta unohdatte oikeudenmukaisuuden ja Jumalan rakkauden. On hyvä, että annatte kymmenykset, mutta teidän ei pitäisi sivuuttaa muuta tärkeää. ");
INSERT INTO fin_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Voi teitä fariseuksia! Te rakastette synagogan kunniapaikkoja ja vastaantulijoiden kohteliaita tervehdyksiä. ");
INSERT INTO fin_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ankara tuomio odottaa teitä. Olette kuin merkitsemättömät haudat, joiden ohi ihmiset kulkevat tietämättä, mitä saastaa niissä on sisällä.» ");
INSERT INTO fin_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Eräs uskonnollisen lain tuntija, joka seisoi siinä lähellä, sanoi silloin: »Opettaja, nyt loukkasit myös meidän ammattikuntaamme.» ");
INSERT INTO fin_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","»Sama tuomio on edessä teilläkin», Jeesus vastasi. »Te näännytätte ihmiset mahdottomilla uskonnollisilla vaatimuksillanne, joita itse ette koskaan yritäkään täyttää. ");
INSERT INTO fin_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Voi teitä! Olette juuri samanlaisia kuin esi-isänne, jotka kauan sitten tappoivat profeetat. ");
INSERT INTO fin_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Murhaajat! Hyväksytte sen, mitä isänne tekivät, ja olisitte itse toimineet samoin. ");
INSERT INTO fin_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Jumala sanoo teistä: ’Minä lähetän luoksenne profeettoja ja apostoleita: muutamia heistä te tapatte ja loput ajatte pois.’ ");
INSERT INTO fin_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tämä sukupolvi on vastuussa jokaisesta Jumalan palvelijan murhasta, joka maailman alusta asti on tehty: ");
INSERT INTO fin_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","te olette syyllisiä kaikkien kuolemaan Aabelista Sakarjaan asti, joka menehtyi alttarin ja temppelin pyhimmän osan välillä. ");
INSERT INTO fin_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Voi teitä uskonnon tuntijoina pidettyjä miehiä! Te estätte ihmisiä näkemästä totuutta. Itse ette halua sitä hyväksyä ja viette muiltakin mahdollisuuden sen vastaanottamiseen.» ");
INSERT INTO fin_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Fariseukset ja lain tuntijat olivat raivoissaan ja ahdistivat häntä tämän jälkeen kiihkeästi monenlaisilla kysymyksillä. He toivoivat hänen sanovan sellaista, mikä antaisi aiheen hänen pidättämiseensä. ");
INSERT INTO fin_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Väkeä oli sillä välin kokoontunut tuhatmäärin. Ihmiset talloivat toisiaan tungoksessa. Jeesus sanoi oppilailleen: »Varokaa ennen muuta fariseuksia, jotka esiintyvät hyvinä ja hurskaina, vaikka eivät ole. Sellainen tekopyhyys paljastuu kerran. ");
INSERT INTO fin_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Se on kuin taikinaan pantu hiiva: ");
INSERT INTO fin_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","mitä he pimeässä sanovatkin, sen kaikki saavat kuulla päivänvalossa, ja mitä te kuiskaatte seinien sisällä, se kuulutetaan ihmisille katoilta. ");
INSERT INTO fin_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ystäväni, älkää pelätkö niitä, jotka tahtovat tappaa teidät. He voivat tuhota ruumiin, mutta sieluun heillä ei ole valtaa. ");
INSERT INTO fin_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sen sijaan teidän on pelättävä Jumalaa, jolla on valta sekä tappaa ihminen että heittää hänet ikuiseen kadotukseen. ");
INSERT INTO fin_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mikä on viiden varpusen hinta? Pari killinkiä? Eipä juuri enempää. Kuitenkaan Jumala ei unohda niistä yhtäkään. ");
INSERT INTO fin_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jopa sen hän tietää, montako hiusta teillä on päässänne. Teidän ei koskaan tarvitse pelätä, sillä olette te toki Jumalalle arvokkaammat kuin kokonainen varpusparvi. ");
INSERT INTO fin_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Vakuutan teille, että minä tunnustan taivaassa Jumalan enkelien luona teidät omikseni, jos nyt maan päällä julkisesti tunnustatte minut ystäväksenne. ");
INSERT INTO fin_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mutta minä kiellän enkelien edessä tuntevani niitä, jotka täällä ihmisten keskellä kieltävät minut. ");
INSERT INTO fin_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ne, jotka vastustavat minua, saavat kuitenkin anteeksi. Sen sijaan niille, jotka herjaavat Pyhää Henkeä, ei anneta anteeksi. ");
INSERT INTO fin_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kun teidät viedään synagogiin johtavien juutalaisten tutkittaviksi, älkää huolehtiko siitä, mitä sanotte puolustukseksenne, ");
INSERT INTO fin_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","sillä Pyhä Henki antaa teille oikeat sanat oikealla hetkellä.» ");
INSERT INTO fin_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Silloin joku huusi väkijoukosta: »Opettaja, sanothan veljelleni, että hän jakaisi kanssani isämme perinnön!» ");
INSERT INTO fin_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Mutta Jeesus vastasi: »Miksi minun pitäisi olla tuomarinne tuollaisessa asiassa? ");
INSERT INTO fin_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Älkää aina olko toivomassa itsellenne sellaista, mitä teillä ei ole.» ");
INSERT INTO fin_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jeesus kertoi vertauksen: »Rikkaalla miehellä oli tuottoisa maatila. ");
INSERT INTO fin_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Hänen varastonsa olivat jo täpötäynnä, ja hän mietti, mihin saisi mahtumaan lopun viljan. ");
INSERT INTO fin_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Vihdoin hän keksi: ’Minäpä puran varastoni ja rakennan tilalle suuremmat. Sitten minulla on tarpeeksi säilytystilaa. ");
INSERT INTO fin_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jään lepäämään laakereillani ja sanon itselleni: Tämä riittää moniksi vuosiksi. Nyt voin ottaa vähän kevyemmin – syön, juon ja huvittelen.’ ");
INSERT INTO fin_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mutta Jumala sanoi hänelle: ’Olet hullu! Sinä kuolet tänä yönä. Kuka sitten saa kaiken omaisuutesi?’ ");
INSERT INTO fin_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","On järjetöntä koota rikkauksia maan päälle eikä taivaaseen.» ");
INSERT INTO fin_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Oppilailleen Jeesus sanoi sitten: »Älkää kantako huolta siitä, onko teillä tarpeeksi ruokaa ja vaatteita. ");
INSERT INTO fin_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Onhan elämässä toki paljon muutakin kuin ruoka ja vaatteet! ");
INSERT INTO fin_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Katsokaa lintuja – ne eivät kylvä eivätkä korjaa satoa aittoihin ja kuitenkin tulevat hyvin toimeen, sillä Jumala ruokkii ne. Olettehan te toki hänelle lintuja arvokkaammat. ");
INSERT INTO fin_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ja miksi yleensä kannattaa antaa tällaisten asioiden painaa mieltään? ");
INSERT INTO fin_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ettehän te suremalla voi pidentää elämäänne edes yhdellä ainoalla päivällä. Ja jos ei suremisesta ole apua pienissä asioissa, niin vielä vähemmän siitä on apua suurissa. ");
INSERT INTO fin_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Katsokaa kukkia: ne eivät tee työtä eivätkä ompele, mutta Salomokaan ei ollut juhla-asussaan niin kaunis kuin ne. ");
INSERT INTO fin_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ja jos kerran Jumala näin pukee kasvin, joka tänään kukkii ja huomenna jo lakastuu – ettekö usko, että hän voi myös antaa teille vaatteet? ");
INSERT INTO fin_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Älkää kantako huolta ruuastanne ja vaatteistanne. ");
INSERT INTO fin_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ihmiset uurastavat turvatakseen toimeentulonsa, mutta teidän Isänne tietää kyllä, mitä tarvitsette. ");
INSERT INTO fin_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pitäkää Jumalan valtakuntaa elämänne tärkeimpänä asiana, niin Isä antaa teille joka päivä kaiken muunkin, mitä tarvitsette. ");
INSERT INTO fin_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Älä siis pelkää, pieni joukko! Teidän Isänne tahtoo antaa teille valtakunnan. ");
INSERT INTO fin_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Myykää, mitä teillä on, ja antakaa niille, jotka tarvitsevat. Näin kokoatte itsellenne aarteita taivaaseen. Niitä eivät varkaat vie eivätkä koit turmele. ");
INSERT INTO fin_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sillä missä teidän aarteenne on, siellä ovat myös teidän sydämenne ja ajatuksenne. ");
INSERT INTO fin_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Olkaa kuin palvelijat, jotka odottavat isäntäänsä kotiin häistä. Olkaa valveilla ja täysissä pukeissa. Silloin olette valmiit avaamaan oven ja päästämään hänet sisään, kun hän koputtaa. ");
INSERT INTO fin_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ne, jotka ovat odottaneet hänen paluutaan, kokevat suuren ilon. Isäntä itse kutsuu heidät ruokapöytään, pukeutuu tarjoilijan asuun ja palvelee heitä. ");
INSERT INTO fin_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Hän voi palata illalla yhdeksältä tai yhtä hyvin keskiyöllä. Mutta tulipa hän milloin tahansa, ne, jotka ovat häntä odottaneet, ovat onnellisessa asemassa. ");
INSERT INTO fin_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kyllähän jokainen olisi valmiina, jos tietäisi tarkan ajan, milloin hän tulee. Varastakin osattaisiin varoa, jos hänen tulonsa tiedettäisiin etukäteen. ");
INSERT INTO fin_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Olkaa siis koko ajan valmiina, sillä palaan silloin kun minua vähiten odotetaan.» ");
INSERT INTO fin_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pietari kysyi: »Herra, tarkoititko tuon meille vai kaikille muillekin?» ");
INSERT INTO fin_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","43-44","Herra vastasi: »Puhun kaikille, jotka ovat uskollisia ja järkeviä ja joille heidän isäntänsä on antanut vastuun palvelijoiden hyvinvoinnista. Jos isäntä palatessaan huomaa heidän toimineen niin kuin pitikin, he saavat palkan: isäntä antaa koko omaisuutensa heidän hoidettavakseen. ");
INSERT INTO fin_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Palvelija voi myös ajatella, ettei hänen isäntänsä palaa vielä pitkiin aikoihin, ja rupeaakin suojelemisen sijasta lyömään toisia, juopottelemaan ja juhlimaan. ");
INSERT INTO fin_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Isäntä palaa ilman ennakkovaroitusta, ja palvelija menettää silloin luottamustehtävänsä ja kokee pettureiden kohtalon. ");
INSERT INTO fin_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Hän saa ankaran rangaistuksen, koska ei huolehtinut tehtävistään vaikka ne tiesi. ");
INSERT INTO fin_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sellainen, joka ei tiedä tehneensä väärin, saa vain lievän rangaistuksen. Niiltä, joille on annettu paljon, myös vaaditaan paljon, sillä heidän vastuunsa on suurempi. ");
INSERT INTO fin_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Olen tullut tuomaan tulta maan päälle ja miten toivoisinkaan, että olisin jo täyttänyt tehtäväni! ");
INSERT INTO fin_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Edessäni on hirvittävä koettelemus, ja olen hyvin ahdistunut siihen asti kunnes olen läpäissyt sen. ");
INSERT INTO fin_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Luuletteko, että olen tullut tuomaan rauhaa maan päälle? Pikemminkin tuon riitaa ja erimielisyyttä. ");
INSERT INTO fin_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tästä lähin perheet jakautuvat kahtia: Kolme on minun puolellani ja kaksi minua vastaan tai päinvastoin. ");
INSERT INTO fin_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Isäja poika ovat eri mieltä, äiti ja tytär joutuvat ristiriitaan keskenään, eivätkä miniä ja anoppi ymmärrä toisiaan.» ");
INSERT INTO fin_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jeesus kääntyi sitten sanomaan väkijoukolle: »Kun te näette pilvien kerääntyvän läntiselle taivaalle, sanotte, että sade on tulossa, ja olette oikeassa. ");
INSERT INTO fin_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Etelätuulten puhaltaessa sanotte: ’Tänään tulee hellepäivä’, ja niin tuleekin. ");
INSERT INTO fin_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tekopyhät! Osaatte kyllä arvioida oikein ilmoja, mutta suljette silmänne kriisiä ennakoivilta merkeiltä, joita näkyy joka puolella ympärillänne. ");
INSERT INTO fin_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Miksi ette tahto nähdä totuutta? ");
INSERT INTO fin_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jos tapaat syyttäjäsi matkalla oikeussaliin, yritä sopia asiasi hänen kanssaan ajoissa, ettet saisi tuomiota ja joutuisi vankilaan. ");
INSERT INTO fin_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sieltä et nimittäin pääse vapaaksi ennen kuin olet maksanut viimeisenkin killingin.» ");
INSERT INTO fin_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Jeesus sai näihin aikoihin tietää, että Pilatus oli surmauttanut joitakin Galilean juutalaisia näiden ollessa uhraamassa Jerusalemin temppelissä. ");
INSERT INTO fin_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","»Luuletteko, että he olivat suurempia syntisiä kuin muut galilealaiset, kun heidän kävi näin?» Jeesus kysyi. ");
INSERT INTO fin_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","»Varmasti eivät! Ettekö tajua, että tuhoudutte itsekin, jos ette käänny omilta teiltänne Jumalan luo? ");
INSERT INTO fin_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Entä ne kahdeksantoista miestä, jotka kuolivat, kun Siiloan torni kaatui heidän päälleen? Olivatko he Jerusalemin pahimpia syntisiä? ");
INSERT INTO fin_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Varmasti eivät! Tekin tuhoudutte, ellette käänny.» ");
INSERT INTO fin_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Hän kertoi kuvaavan esimerkin: »Eräs mies istutti puutarhaansa viikunapuun ja kävi usein katsomassa, joko se alkaisi tuottaa hedelmää, mutta turhaan. ");
INSERT INTO fin_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Lopulta hän käski puutarhuria kaatamaan puun. ’Olen odottanut kolme vuotta, mutta yhtään viikunaa siinä ei ole kasvanut’, hän sanoi. ’Ei kannata enää nähdä vaivaa. Voimme käyttää maan hyödyllisemminkin.’ ");
INSERT INTO fin_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","’Anna sille vielä mahdollisuus’, puutarhuri pyysi. ’Yritetään yksi vuosi. Minä lannoitan ja hoidan sitä hyvin. ");
INSERT INTO fin_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ensi vuonna varmaan jo saamme viikunoita. Jos niitä ei tule, hävitän sen sitten.’» ");
INSERT INTO fin_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Opettaessaan eräänä sapattina synagogassa ");
INSERT INTO fin_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jeesus näki vaikeavammaisen naisen, joka oli joutunut kulkemaan selkä koukussa kahdeksantoista vuotta. ");
INSERT INTO fin_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jeesus kutsui hänet luokseen ja sanoi: »Nainen, olet päässyt vammastasi!» ");
INSERT INTO fin_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Hän kosketti naista, ja tämä pystyi heti oikaisemaan selkänsä. Nainen alkoi ääneen ylistää Jumalaa. ");
INSERT INTO fin_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Synagogan johtaja oli kuitenkin hyvin vihainen, koska Jeesus oli parantanut naisen sapattina. Hän huusi kansalle: »Viikossa on kuusi päivää työntekoa varten. Tulkaa silloin parannuttamaan itsenne älkääkä sapattina!» ");
INSERT INTO fin_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Mutta Herra vastasi: »Oletpa sinä tekopyhä! Teet itsekin sapattina työtä. Viet karjasi navetasta ulos juomaan. ");
INSERT INTO fin_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Teinkö väärin vapauttaessani juuri pyhäpäivänä tämän juutalaisen naisen kahleista, joissa saatana on pitänyt häntä kahdeksantoista vuotta?» ");
INSERT INTO fin_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Hänen vihamiehensä häpesivät, ja kansa oli riemuissaan ihmeistä, joita hän teki. ");
INSERT INTO fin_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Hän alkoi taas puhua heille Jumalan valtakunnasta: »Millainen tuo valtakunta on? Miten kuvailisin sitä? ");
INSERT INTO fin_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Se on kuin pieni sinapinsiemen, joka istutetaan puutarhaan. Pian siitä kasvaa suuri puu, jonka oksille linnut pesivät. ");
INSERT INTO fin_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","21","Taivaan valtakuntaa voidaan myös verrata hiivaan, joka on sekoitettu taikinaan. Hiivan olemassaolo tulee näkyviin vasta sitten, kun taikina nousee.» ");
INSERT INTO fin_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Hän jatkoi kulkuaan kylästä toiseen ja kaupungista kaupunkiin pyrkien jatkuvasti Jerusalemia kohti. Joka paikassa hän opetti ihmisiä. ");
INSERT INTO fin_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Joku kysyi häneltä: »Pelastuvatko vain harvat?» Hän vastasi: ");
INSERT INTO fin_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","»Taivaan ovi on ahdas. Yrittäkää kaikin voimin päästä siitä sisään, sillä totuus on, että monet sinne kyllä pyrkivät, mutta sitten kun isäntä lukitsee oven, on jo myöhäistä. Jos silloin jäätte ulkopuolelle, kolkutatte oveen ja pyydätte: ’Herra, avaa’, niin hän vastaa: ’En tunne teitä.’ ");
INSERT INTO fin_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Te sanotte siihen: ’Mehän söimme kanssasi ja sinä opetit meidän kaduillamme.’ ");
INSERT INTO fin_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Hän vastaa: ’Minä en tunne teitä, vaikka olette noin varmoja itsestänne. Menkää tiehenne!’ ");
INSERT INTO fin_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Te itkette ja kiristelette hampaitanne, kun seisotte ulkopuolella ja näette Aabrahamin, Iisakin, Jaakobin ja kaikkien profeettojen olevan sisällä valtakunnassa. ");
INSERT INTO fin_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Joka puolelta maailmaa tulee ihmisiä, joille on varattu paikka. ");
INSERT INTO fin_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Monia, joita nyt halveksitaan, kunnioitetaan silloin syvästi, ja toiset, joita nyt erityisesti arvostetaan, ovat silloin kaikkein vähäpätöisimpiä.» ");
INSERT INTO fin_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jonkin ajan kuluttua muutamat fariseukset tulivat sanomaan hänelle: »Lähde pois täältä, jollet tahdo joutua Herodeksen kynsiin.» ");
INSERT INTO fin_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jeesus vastasi: »Menkää sanomaan sille ketulle, että aion tänään ja huomenna parantaa ihmisiä ja ajaa ulos pahoja henkiä, mutta kolmantena päivänä pääsen määränpäähäni. ");
INSERT INTO fin_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Niin, vielä tämän päivän, huomisen ja ylihuomisen aion kulkea eteenpäin, sillä ei sovi, että Jumalan profeetta surmataan muualla kuin Jerusalemissa. ");
INSERT INTO fin_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jerusalem, Jerusalem, sinä, joka murhaat profeetat ja kivität ne, jotka tulevat sinua auttamaan! Miten usein olenkaan tahtonut koota lapsesi niin kuin kana kokoaa poikasensa turvaan siipiensä alle, mutta te ette ole tahtoneet. ");
INSERT INTO fin_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Teidän talonne autioituu. Ette näe minua, ennen kuin sanotte: ’Ole tervetullut, sinä, joka tulet Herran nimessä!’» ");
INSERT INTO fin_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","Jeesus tuli sapattina erään juutalaisten neuvoston jäsenen kotiin. Fariseukset seurasivat haukan silmin, parantaisiko hän paikalla olevan vesipöhöstä kärsivän miehen. ");
INSERT INTO fin_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jeesus kysyi fariseuksilta ja laintuntijoilta, jotka seisoivat hänen ympärillään: »Antaako laki luvan parantaa ihmisen sapattina?» ");
INSERT INTO fin_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kun vastausta ei kuulunut, Jeesus tarttui sairaan käteen, paransi hänet ja lähetti pois. ");
INSERT INTO fin_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Muille Jeesus sanoi: »Kuka teistä ei tee sapattina työtä, jos teidän poikanne tai härkänne putoaa kaivoon? Ettekö heti ryhdy nostamaan niitä sieltä ylös?» ");
INSERT INTO fin_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Vieläkään hän ei saanut vastausta. ");
INSERT INTO fin_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Huomatessaan, että kaikki päivällisvieraat yrittivät päästä istumaan arvokkaimmille paikoille lähelle pöydän päätä, Jeesus antoi heille neuvon: ");
INSERT INTO fin_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","»Jos teidät kutsutaan häihin, älkää pyrkikö parhaalle paikalle. Joku arvokkaampi saattaa tulla teidän jälkeenne, ");
INSERT INTO fin_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ja isäntä johdattelee hänet sinne, missä te istutte. Joudutte silloin nolona etsimään tyhjää paikkaa ovensuusta. ");
INSERT INTO fin_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Menkää sen sijaan ensin vähemmän arvokkaalle paikalle. Huomatessaan teidät isäntä sanoo: ’Ystävä hyvä, kyllä sinulle löytyy parempikin paikka.’ Näin arvonne nousee muiden vieraiden silmissä. ");
INSERT INTO fin_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jokainen, joka yrittää saada kunniaa itselleen, joutuu nöyrtymään, mutta joka nöyrtyy, saa kunnian.» ");
INSERT INTO fin_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sitten hän sanoi isännälle: »Kun järjestät päivälliset, älä kutsu ystäviäsi, veljiäsi, sukulaisiasi tai rikkaita naapureitasi, sillä he palkitsevat sinut kutsumalla sinut vastavierailulle. ");
INSERT INTO fin_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kutsu sen sijaan köyhiä, raajarikkoja ja sokeita. ");
INSERT INTO fin_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kun Jumalan omien ylösnousemus tulee, Jumala maksaa sinulle sen, että kutsuit kotiisi sellaisia, jotka eivät voineet tehdä sinulle vastapalveluksia.» ");
INSERT INTO fin_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kuultuaan tämän eräs pöydässä oleva mies huudahti: »Miten suurenmoista olisikaan päästä aterialle Jumalan valtakuntaan!» ");
INSERT INTO fin_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Vastaukseksi Jeesus kertoi vertauksen: »Eräs mies järjesti suuret juhlat ja kutsui niihin paljon ihmisiä. ");
INSERT INTO fin_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Kun kaikki oli valmista, hän lähetti palvelijansa muistuttamaan vieraita, että nyt heidän oli aika tulla. ");
INSERT INTO fin_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Mutta kaikilla oli verukkeita. Yksi sanoi ostaneensa juuri pellon – hänen piti mennä nyt katsomaan sitä. ");
INSERT INTO fin_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Toinen halusi kokeilla viittä härkäparia, jotka juuri oli ostanut. ");
INSERT INTO fin_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Joku oli mennyt vasta naimisiin eikä siksi voinut tulla. ");
INSERT INTO fin_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Palvelija palasi kertomaan isännälleen, mitä kutsutut olivat sanoneet. Isäntä suuttui ja käski hänen heti mennä kaupungin kaduille ja kujille hakemaan juhliin kerjäläisiä, rampoja ja sokeita. ");
INSERT INTO fin_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kun nämä oli tuotu sisään, talossa oli yhä tilaa. ");
INSERT INTO fin_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","’Lähde sitten maaseudulle ja pakota kaikki, jotka tienvarsilta löydät, tulemaan tänne, että saamme talon täyteen’, isäntä käski. ");
INSERT INTO fin_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","’Kukaan niistä, jotka ensin kutsuin, ei saa maistaa muruakaan ateriasta, jonka heille valmistin.’» ");
INSERT INTO fin_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Valtava joukko ihmisiä kulki Jeesuksen jäljessä. Hän kääntyi ja sanoi heille: ");
INSERT INTO fin_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","»Sen, joka haluaa seurata minua, on rakastettava minua enemmän kuin omaa isäänsä, äitiänsä, vaimoaan, lapsiaan, veljiään tai sisariaan – jopa enemmän kuin omaa elämäänsä. Muuten hän ei voi olla oppilaani. ");
INSERT INTO fin_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kukaan, joka ei kanna omaa ristiään ja seuraa minua, ei voi olla oppilaani. ");
INSERT INTO fin_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Laskekaa kustannukset, ennen kuin teette ratkaisuja. Eihän kukaan aloita rakentamista ennen kuin arvioi, onko hänellä tarpeeksi rahaa talon maksamiseen. ");
INSERT INTO fin_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Muuten voi käydä niin, että rahat loppuvat, kun hän on saanut vasta rakennuksen perustuksen valmiiksi. Kyllä hänelle silloin naurettaisiin! ");
INSERT INTO fin_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","’Katsokaa tuota’, kaikki ilkkuisivat. ’Hän alkoi rakentaa, mutta rahat loppuivat kesken.’ ");
INSERT INTO fin_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Tai mitä tekee kuningas ennen sotaan lähtöä? Hän neuvottelee ensin asiantuntijoiden kanssa, onko hänen kymmentuhantinen armeijansa kyllin vahva puolustautumaan kahtakymmentätuhatta vihollista vastaan. ");
INSERT INTO fin_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jos hän huomaa yrityksen toivottomaksi, hän lähettää rauhanneuvottelijat matkaan, kun vihollisjoukot ovat vielä kaukana. ");
INSERT INTO fin_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kukaan ei voi olla oppilaani, ellei hän luovuta käyttööni kaikkea mitä hänellä on. ");
INSERT INTO fin_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Mitä merkitystä on suolalla, joka ei enää ole suolaista? ");
INSERT INTO fin_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mauton suola ei kelpaa edes lannoitteeksi. Se on arvottomana heitettävä pois. Kuunnelkaa tarkasti ymmärtääksenne, mitä tarkoitan.» ");
INSERT INTO fin_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Epärehelliset veronkantajat ja muut huonomaineiset ihmiset tulivat usein kuuntelemaan Jeesuksen puheita. ");
INSERT INTO fin_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Tämä taas antoi juutalaisten uskonnollisille johtajille ja laintuntijoille aiheen moittia häntä siitä, että hän oli tekemisissä sellaisten halveksittujen ihmisten kanssa – ja jopa söi heidän kanssaan! ");
INSERT INTO fin_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Siksi Jeesus kertoi havaintoesimerkin: »Jos sinulla olisi sata lammasta ja yksi niistä eksyisi erämaahan, etkö jättäisi ne yhdeksänkymmentäyhdeksän laitumelle ja etsisi kadonnutta niin kauan, että löytäisit sen? ");
INSERT INTO fin_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Sitten kantaisit sen iloisena olallasi kotiin. ");
INSERT INTO fin_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kutsuisit ystävät ja naapurit luoksesi siitä ilosta, että kadonnut lampaasi löytyi. ");
INSERT INTO fin_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Samoin taivaassakin ollaan iloisempia yhdestä kadonneesta syntisestä, joka palaa Jumalan luo, kuin yhdeksästäkymmenestäyhdeksästä muusta, jotka eivät ole eksyneet. ");
INSERT INTO fin_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Tai toinen esimerkki: Nainen kadottaa yhden kymmenestä arvokkaasta hopearahastaan. Hän sytyttää lampun ja tutkii ja lakaisee talonsa jokaisen kolkan, kunnes löytää rahansa. ");
INSERT INTO fin_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Sitten hän kutsuu tapauksen kunniaksi luokseen ystävänsä ja naapurinsa. ");
INSERT INTO fin_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Niin Jumalan enkelitkin riemuitsevat, kun yksi syntinen kääntyy.» ");
INSERT INTO fin_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Selvittääkseen asiaa lisää hän kertoi vielä yhden vertauksen: »Eräällä miehellä oli kaksi poikaa. ");
INSERT INTO fin_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nuorempi pyysi isältään: ’En haluaisi odottaa kuolemaasi asti, vaan ottaisin jo nyt oman osuuteni perinnöstä.’ Isä suostui ja jakoi omaisuutensa poikiensa kesken. ");
INSERT INTO fin_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Muutama päivä myöhemmin nuorempi poika pakkasi tavaransa ja matkusti kauas ulkomaille. Siellä hän tuhlasi kaikki rahansa juhlimiseen ja huonoon elämään. ");
INSERT INTO fin_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Näihin aikoihin maahan tuli nälänhätä, ja hänkin joutui kärsimään siitä. ");
INSERT INTO fin_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hän sai erään maanomistajan ottamaan hänet sikojenhoitajaksi. ");
INSERT INTO fin_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Poika oli niin nälissään, että jopa sioille tarkoitetut palot näyttivät hänestä hyvältä. Mutta hän ei saanut syödä niitäkään. ");
INSERT INTO fin_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kun hän lopulta tuli järkiinsä, hän mietti itsekseen: ’Kotona on isäni työmiehillä yllin kyllin syötävää, mutta minä kuolen täällä nälkään! ");
INSERT INTO fin_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Lähden kotiin ja sanon isälle: Olen tehnyt syntiä sekä sinua että Jumalaa vastaan ");
INSERT INTO fin_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","enkä ole enää sen arvoinen, että sanoisit minua pojaksesi. Etkö kuitenkin voisi antaa minulle työtä kotona?’ ");
INSERT INTO fin_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Hän lähti kotiin isänsä luo. Hän oli vielä kaukana, kun isä näki hänen tulevan. Sydän täynnä rakkautta ja sääliä isä juoksi poikaa vastaan. Hän sulki pojan syliinsä ja suuteli häntä. ");
INSERT INTO fin_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Poika sanoi: ’Isä, olen tehnyt syntiä Jumalaa ja sinua vastaan enkä ole sen arvoinen, että sanoisit minua enää pojaksesi…’ ");
INSERT INTO fin_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mutta hänen isänsä sanoi palvelijoille: ’Tuokaa tänne talon hienoin puku, pankaa jalokivisormus pojan sormeen ja kengät hänen jalkaansa. ");
INSERT INTO fin_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Teurastakaa syöttövasikka, sillä nyt on syytä juhlaan. ");
INSERT INTO fin_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Tämä poikani oli kuollut, mutta palasi elämään. Hän oli kadonnut, mutta nyt hän on löytynyt.’ Ja he järjestivät juhlan. ");
INSERT INTO fin_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Vanhempi poika oli tämän tapahtuessa työssä pellolla. Palatessaan kotiin hän kuuli talosta iloista musiikkia ");
INSERT INTO fin_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ja kysyi joltakin palvelijalta, mitä oikein oli tekeillä. ");
INSERT INTO fin_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","’Veljesi tuli takaisin’, tämä kertoi. ’Isäsi teurastutti syöttövasikan ja käski järjestää pidot, kun sai pojan vahingoittumattomana kotiin.’ ");
INSERT INTO fin_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Vanhempi veli oli vihainen eikä halunnut mennä sisään. Isä tuli pyytämään häntä mukaan juhlaan. ");
INSERT INTO fin_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mutta hän vastasi: ’Olen koko ikäni tehnyt täällä ilmaista työtä. En ole koskaan kieltäytynyt tekemästä mitään, mitä olet käskenyt. Mutta minulle et ole antanut edes pientä vuohta, että olisin voinut järjestää juhlat ystävilleni. ");
INSERT INTO fin_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nyt kun veljeni tuli takaisin, teurastutit parhaan vasikan ja panit pystyyn juhlat, vaikka hän on tuhlannut rahasi huonojen naisten kanssa.’ ");
INSERT INTO fin_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","’Kuule nyt, oma poikani’, isä sanoi. ’Me olemme hyvin läheiset toisillemme, ja kaikki, mikä on minun, on myös sinun. ");
INSERT INTO fin_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mutta täytyihän meidän järjestää juhlat, kun veljesi, joka oli kuollut, palasi elämään – hän oli kadonnut, mutta nyt hän on löytynyt!’» ");
INSERT INTO fin_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jeesus kertoi oppilailleen: »Eräs varakas mies palkkasi talouspäällikön hoitamaan raha-asioitaan, mutta pian lähti kiertämään huhu, että talouspäällikkö oli hyvin epärehellinen. ");
INSERT INTO fin_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Työnantaja kutsui miehen puheilleen. ’Tiedätkö, mitä olen saanut selville? Sinä olet varas. Tee tili toimistasi, sillä saat lähteä.’ ");
INSERT INTO fin_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Talouspäällikkö mietti, miten selviäisi. ’Minun on lähdettävä täältä, mutta ruumiillista työtä en jaksa tehdä ja kerjäämäänkään en rupea. ");
INSERT INTO fin_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nyt tiedän, mistä saan ystäviä! He huolehtivat minusta, kun lähden täältä.’ ");
INSERT INTO fin_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","6","Hän pyysi kaikkia, jotka olivat hänen työnantajalleen velkaa, tulemaan puheilleen. Ensimmäiseltä hän kysyi: ’Paljonko olet velkaa?’ ’3 600 litraa oliiviöljyä’, mies vastasi. ’Tässä onkin velkakirjasi. Revi se ja kirjoita uusi, jossa velaksesi ilmoitetaan vain puolet siitä’, talouspäällikkö sanoi. ");
INSERT INTO fin_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","’Mitä sinä olet velkaa?’ hän kysyi sitten seuraa valta. ’36 tonnia vehnää’, tämä vastasi. ’Tehdään uusi sopimus ja merkitään velaksesi vain 29 tonnia’, talouspäällikkö sanoi. ");
INSERT INTO fin_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Saatuaan kuulla asiasta rikas mies ei voinut olla ihailematta talouspäällikkönsä nerokasta ratkaisua. Ovathan tämän maailman ihmiset ovelampia kuin ne, jotka tahtovat elää Jumalan mielen mukaan. ");
INSERT INTO fin_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mutta neuvoisinko teitä hankkimaan itsellenne ystäviä petoksella? Hekö sitten auttaisivat teitä pääsemään taivaaseen? ");
INSERT INTO fin_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Varmaa on, että jollette ole pienissä asioissa rehellisiä, ette ole suurissakaan. Jos harrastatte pientä vilppiä, olette epärehellisiä myös saadessanne paljon vastuuta. ");
INSERT INTO fin_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jos teidän hoidettavaksenne ei voi uskoa maallista omaisuutta, niin vielä vähemmän taivaan aarteita. ");
INSERT INTO fin_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jos ette ole luotettavia hoitaessanne toisten ihmisten rahoja, kuinka sitten pystyisitte hoitamaan sellaista omaisuutta, joka on uskottu teidän omaksenne? ");
INSERT INTO fin_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kukaan ei voi olla samalla kertaa kahden isännän palveluksessa. Jos yritämmekin, alamme ennen pitkää vihata toista ja pitää toisen puolta tai arvostaa toista ja halveksia toista. On mahdotonta palvella sekä Jumalaa että omaisuutta.» ");
INSERT INTO fin_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseukset, jotka olivat hyvin rahanahneita, hymähtelivät ivallisesti. ");
INSERT INTO fin_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jeesus sanoi heille: »Teitä luullaan hyviksi ja hurskaiksi, mutta Jumala tuntee sydämenne pahuuden. Teeskentelette niin hyvin, että onnistutte pettämään ihmisiä, mutta Jumala kauhistuu menettelyänne. ");
INSERT INTO fin_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ennen Johannes Kastajaa saitte elämänohjeet Mooseksen laista ja profeettojen kilvoituksista, mutta Johannes julisti hyvää uutista: Jumalan valtakunta oli pian tulossa. Innokkaat ihmisjoukot yrittävät nyt työntyä sinne. ");
INSERT INTO fin_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Tämä ei kuitenkaan merkitse, että laki olisi vähääkään menettänyt voimaansa. Se on yhtä luja ja horjumaton kuin taivas ja maa. ");
INSERT INTO fin_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Niinpä jokainen, joka eroaa vaimostaan ja menee naimisiin jonkun toisen kanssa, tekee aviorikoksen, samoin jokainen, joka menee naimisiin eronneen naisen kanssa.» ");
INSERT INTO fin_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","»Eräs varakas mies vietti iloista ja ylellistä elämää ja pukeutui loisteliaasti», Jeesus kertoi. ");
INSERT INTO fin_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","»Sairas kerjäläinen, Lasarus, makasi hänen ovensa edessä odottaen, että saisi jotakin pientä suuhunsa rikkaan pöydältä. Koirat kävivät nuolemassa Lasaruksen paiseita. ");
INSERT INTO fin_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lopulta hän kuoli, ja enkelit veivät hänet Aabrahamin luo paikkaan, minne Jumalan hyväksymät ihmiset pääsevät kuoltuaan. Myös rikas mies kuoli, ja hänet haudattiin, ");
INSERT INTO fin_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","mutta hän joutui kadotukseen. Kärsiessään siellä hän näki kaukana Lasaruksen, joka oli Aabrahamin seurassa. ");
INSERT INTO fin_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","’Isä Aabraham, sääli minua!’ hän huusi. ’Lähetä Lasarus tänne ja pyydä häntä kastamaan vaikka sormenpäänsä veteen ja kostuttamaan kieltäni, sillä näissä liekeissä on kauhea olla.’ ");
INSERT INTO fin_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Mutta Aabraham sanoi hänelle: ’Muistat kai, poikani, että koko elämäsi ajan sait kaikkea mitä tahdoit, mutta Lasaruksella ei ollut mitään. Hänen vuoronsa on nyt saada lohdutusta ja sinun kärsiä. ");
INSERT INTO fin_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Sitä paitsi meitä erottaa syvä kuilu, niin että jos joku haluaisikin tulla täältä sinne, hän ei pääse. Samoin sieltä ei kukaan pääse tälle puolelle.’ ");
INSERT INTO fin_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Rikas mies sanoi silloin: ’Voisitko sitten lähettää hänet perintötilallemme ");
INSERT INTO fin_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","varoittamaan viittä veljeäni, etteivät he joutuisi kuoltuaan tähän hirveään paikkaan?’ ");
INSERT INTO fin_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Mutta Aabraham vastasi: ’Jumalan laki ja profeettojen kirjoitukset varoittavat heitä kylliksi. Veljesi voivat lukea niitä milloin vain.’ ");
INSERT INTO fin_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Rikas mies sanoi: ’Eivät he lue Raamattua. Mutta jos joku kuollut palaisi puhumaan heille, he varmasti luopuisivat synneistään.’ ");
INSERT INTO fin_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Aabraham vastasi: ’Jos he eivät kuuntele Moosesta ja profeettoja, he eivät kuuntelisi, vaikka joku kuollut heräisi eloon.’» ");
INSERT INTO fin_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jeesus sanoi oppilailleen: »Kiusauksia on aina, mutta ihmisen, joka aiheuttaa kiusauksen, käy huonosti. ");
INSERT INTO fin_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","3","Parempi olisi heittää hänet myllynkivi kaulassa mereen kuin antaa hänen aiheuttaa vahinkoa näille pienille lapsille. Varoitan teitä! Mene puhumaan veljesi kanssa, jos hän tekee syntiä, ja jos hän katuu, anna hänelle anteeksi. ");
INSERT INTO fin_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Vaikka hän pahoittaisi mielesi seitsemän kertaa samana päivänä, anna hänelle anteeksi, jos hän joka kerta tulee katuvana luoksesi.» ");
INSERT INTO fin_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Oppilaat tulivat eräänä päivänä pyytämään Herralta: »Selitä meille, miten saisimme lisää uskoa.» ");
INSERT INTO fin_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jeesus vastasi: »Jos teillä olisi sinapinsiemenenkään verran uskoa, voisitte käskeä tuota silkkiäispuuta heittäytymään juurineen mereen, ja se tapahtuisi. ");
INSERT INTO fin_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8-9","Kun palvelija tulee kyntämästä tai hoitamasta lampaita, hän ei istu heti syömään, vaan valmistaa ensin ruuan isännälleen ja tarjoilee hänelle ennen kuin ottaa itse. Isäntä ei kiittele palvelijaa, koska tämä tekee vain sen, mikä hänelle kuuluu. ");
INSERT INTO fin_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ei teidänkään pidä odottaa kiitosta siitä, että tottelette minua. Olette vain tehneet velvollisuutenne!» ");
INSERT INTO fin_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Matkalla Jerusalemiin he kulkivat Galilean ja Samarian välistä rajaa. ");
INSERT INTO fin_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Eräässä kylässä alkoi kymmenen leprasairasta huutaa matkan päästä: ");
INSERT INTO fin_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","»Auta meitä, Jeesus!» ");
INSERT INTO fin_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jeesus katsoi heihin ja sanoi: »Menkää näyttämään papeille, että olette parantuneet.» Matkalla sairaat tulivat terveiksi. ");
INSERT INTO fin_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yksi heistä palasi Jeesuksen luo ja huusi riemuissaan: »Kiitos Jumalalle, minä olen terve!» ");
INSERT INTO fin_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Hän heittäytyi Jeesuksen eteen kasvot maata vasten ja ylisti Jeesusta siitä, mitä tämä oli tehnyt. Mies oli halveksittu samarialainen. ");
INSERT INTO fin_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jeesus kysyi: »Eikö teitä ollut kymmenen? Mihin ne yhdeksän jäivät? ");
INSERT INTO fin_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tämä ulkomaalainenko vain palasi kiittämään Jumalaa?» ");
INSERT INTO fin_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jeesus sanoi miehelle: »Nouse ja mene. Uskosi on tehnyt sinut terveeksi.» ");
INSERT INTO fin_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseukset kyselivät Jeesukselta: »Milloin Jumalan valtakunta oikein saa alkunsa?» Jeesus vastasi: »Ei Jumalan valtakuntaa voi nähdä näillä silmillä. ");
INSERT INTO fin_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","On mahdotonta sanoa, että nyt se on alkanut tuolla- tai täälläpäin maata. Jumalan valtakunta on teidän sisimmässänne.» ");
INSERT INTO fin_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Hän keskusteli oppilaidensa kanssa tästäkin myöhemmin. »Kerran vielä toivotte, että minä olisin kanssanne edes yhden päivän, mutta silloin en enää ole täällä. ");
INSERT INTO fin_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kuulette huhuja, että olen palannut ja olen siellä tai siellä. Älkää uskoko sellaisiin puheisiin älkääkä lähtekö etsimään minua. ");
INSERT INTO fin_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Kun todella palaan, siinä ei ole mitään epäselvyyttä. Se näkyy yhtä selvästi kuin salaman leimahdus taivaalla. ");
INSERT INTO fin_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mutta sitä ennen minun on kärsittävä paljon. Koko tämä kansa kääntää minulle selkänsä», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","»Kun minä palaan, ihmiset välittävät Jumalasta yhtä vähän kuin Nooan aikana. ");
INSERT INTO fin_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Silloin he söivät, joivat ja menivät naimisiin – aivan niin kuin tavallisesti, kunnes eräänä päivänä alkoi nousta tulva. Nooa meni arkkiin, mutta muut hukkuivat. ");
INSERT INTO fin_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Maailma on minun palatessani samanlainen kuin Lootin aikana: ihmiset hoitivat jokapäiväisiä tehtäviään, söivät ja joivat, ostivat ja myivät, viljelivät maata ja rakensivat. ");
INSERT INTO fin_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sitten eräänä aamuna Loot lähti Sodomasta, ja taivaasta alkoi sataa tulta ja tulikiveä. Kaikki muut kuolivat. ");
INSERT INTO fin_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Samanlaisia ihmiset ovat silloinkin, kun tulen takaisin. ");
INSERT INTO fin_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Jos joku on sinä päivänä ulkona, hänen ei pidä palata sisään kotiinsa, eikä pellolta pidä tulla kaupunkiin – ");
INSERT INTO fin_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","muistattehan, miten Lootin vaimon kävi. ");
INSERT INTO fin_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jokainen, joka pitää kiinni elämästään, menettää sen, mutta joka luopuu elämästään, pelastaa sen. ");
INSERT INTO fin_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kaksi miestä nukkuu sinä yönä samassa huoneessa: toinen heistä otetaan, toinen jää. ");
INSERT INTO fin_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Kaksi naista tekee yhdessä taloustöitä: toinen otetaan, toinen jää. Samoin käy pellolla työssä oleville miehille.» ");
INSERT INTO fin_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Oppilaat kysyivät: »Missä ja milloin tämä kaikki tapahtuu?» Jeesus vastasi: »Korppikotkat kerääntyvät sinne, missä raato on.» ");
INSERT INTO fin_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jeesus kertoi eräänä päivänä oppilailleen havainnollisen esimerkin sinnikkäästä rukouksesta. Hän halusi osoittaa, ettei pidä lakata rukoilemasta, ennen kuin vastaus tulee. ");
INSERT INTO fin_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","»Eräässä kaupungissa oli tuomari, joka ei kunnioittanut Jumalaa eikä piitannut siitä, mitä ihmiset sanoivat. ");
INSERT INTO fin_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Muuan köyhä leski tuli vähän väliä hänen luokseen pyytämään oikeudenkäyntiä erästä miestä vastaan, joka oli aiheuttanut hänelle vahinkoa. ");
INSERT INTO fin_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Tuomari ei jaksanut kiinnostua hänen asiastaan, mutta ajan mittaan nainen kävi hänen hermoilleen. ’En pelkää Jumalaa enkä ihmisiä, mutta tämä nainen on oikea maanvaiva. Otan hänen asiansa hoitaakseni, niin pääsen hänestä eroon’, tuomari päätti.» ");
INSERT INTO fin_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jeesus jatkoi: »Jos kova tuomarikin on taivutettavissa, ");
INSERT INTO fin_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","niin kuinka sitten Jumala ei auttaisi lapsiaan, jotka pyytävät häneltä apua yötä päivää? Hän vastaa pian. Kysymys onkin siitä, kuinka moni rukoilee uskoen silloin, kun minä palaan maan päälle.» ");
INSERT INTO fin_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sitten Jeesus kertoi tällaisen vertauksen niille, jotka ylpeilivät omasta hyvyydestään ja halveksivat muita ihmisiä: ");
INSERT INTO fin_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","»Kaksi miestä meni temppeliin rukoilemaan. Toinen oli ylpeä fariseus, joka piti itseään hyvänä ihmisenä, ja toinen halveksittu veronkantaja. ");
INSERT INTO fin_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseus rukoili näin: ’Kiitos, Jumala, etten olen syntinen niin kuin muut, esimerkiksi tuo veronkantaja. En petä koskaan ketään, en tee aviorikosta, ");
INSERT INTO fin_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","paastoan kaksi päivää viikossa ja annan Jumalalle kymmenesosan tuloistani.’ ");
INSERT INTO fin_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Veronkantaja sen sijaan seisoi temppelin perällä uskaltamatta edes katsoa ylöspäin rukoillessaan. Hän löi murheissaan rintaansa ja pyysi: ’Jumala, olen syntinen ja pyydän armoa!’ ");
INSERT INTO fin_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Vakuutan teille, että tämä syntinen palasi kotiinsa anteeksi saaneena eikä suinkaan se fariseus. Ylpeä alennetaan, mutta nöyrä ylennetään.» ");
INSERT INTO fin_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Äidit toivat eräänä päivänä pieniä lapsiaan Jeesuksen luo pyytäen, että tämä koskettaisi heitä ja siunaisi heidät. Oppilaat hätistelivät heidät kuitenkin pois. ");
INSERT INTO fin_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","17","Jeesus pyysi heitä tulemaan takaisin ja sanoi oppilailleen: »Antakaa pienten lasten tulla luokseni! Älkää missään tapauksessa käskekö heidän mennä pois. Taivaan valtakunta kuuluu niille ihmisille, jotka ovat yhtä luottavaisia kuin nämä pikkulapset. Jos jollakulla ei ole sellaista uskoa kuin lapsella, hän ei pääse sisään valtakunnan porteista.» ");
INSERT INTO fin_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Eräs juutalaisten uskonnollinen johtaja kysyi Jeesukselta: »Hyvä opettaja, mitä minun on tehtävä, että pääsisin taivaaseen?» ");
INSERT INTO fin_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jeesus kysyi takaisin: »Miksi sanoit minua hyväksi? Vain Jumala on todella hyvä. ");
INSERT INTO fin_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mutta mitä kysymykseesi tulee, tunnet kai kymmenen käskyä? Älä tee aviorikosta, älä tapa, älä varasta, älä valehtele, kunnioita vanhempiasi ja niin edelleen.» ");
INSERT INTO fin_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Mies vastasi: »Olen pikkulapsesta asti elänyt näiden lakien mukaan.» ");
INSERT INTO fin_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","»Sinulta puuttuu vain yksi asia», Jeesus sanoi silloin. »Myy kaikki, mitä omistat, anna rahat köyhille ja lähde seuraamaan minua. Silloin sinulla on aarre taivaassa.» ");
INSERT INTO fin_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kuullessaan tämän mies lähti pois alakuloisena, sillä hän oli hyvin rikas. ");
INSERT INTO fin_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jeesus katseli hänen menoaan ja sanoi oppilailleen: »Rikkaan on tosiaan vaikea päästä Jumalan valtakuntaan. ");
INSERT INTO fin_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kamelinkin on helpompi mennä neulansilmän läpi.» ");
INSERT INTO fin_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Kuulijat ihmettelivät: »Jos se on niin vaikeaa, kuinka kukaan voi pelastua?» ");
INSERT INTO fin_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Hän vastasi: »Jumalalle on mahdollista se, mikä ihmiselle on mahdotonta.» ");
INSERT INTO fin_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pietari muistutti: »Me olemme lähteneet kodeistamme ja seuranneet sinua.» ");
INSERT INTO fin_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","»Niin olette», Jeesus vastasi. »Jokainen, joka tekee samalla tavoin – luopuu kodistaan, vaimosta, veljistä, vanhemmista tai lapsista Jumalan valtakunnan tähden – ");
INSERT INTO fin_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","saa jo nyt moninkertaisen korvauksen ja uudessa maailmassa ikuisen elämän.» ");
INSERT INTO fin_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jeesus kutsui kaksitoista oppilastaan luokseen ja sanoi heille: »Kun nyt menemme Jerusalemiin, siellä toteutuvat kaikki minua koskevat entisajan profeettojen ennustukset. ");
INSERT INTO fin_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Joudun pakanoiden käsiin ja he pilkkaavat minua, sylkevät päälleni ja kohtelevat minua häpeällisesti. ");
INSERT INTO fin_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","He ruoskivat minua ja viimein surmaavat minut, mutta kolmantena päivänä nousen kuolleista.» ");
INSERT INTO fin_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","He eivät ollenkaan ymmärtäneet hänen puhettaan. Tuntui, kuin hän olisi esittänyt arvoituksia. ");
INSERT INTO fin_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Heidän tullessaan Jerikon lähelle istui tien laidassa sokea mies kerjäämässä ohikulkijoilta. ");
INSERT INTO fin_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Kun mies kuuli äänestä, että liikkeellä oli suuri väkijoukko, hän kysyi, mitä oli tekeillä. ");
INSERT INTO fin_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hän sai kuulla, että Jeesus Nasaretilainen oli menossa ohi. ");
INSERT INTO fin_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Silloin hän alkoi huutaa: »Jeesus, Daavidin Poika, auta minua!» ");
INSERT INTO fin_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jeesuksen edellä kulkevat ihmiset yrittivät vaientaa sokean, mutta tämä huusi entistä kovempaa: »Daavidin Poika, auta minua!» ");
INSERT INTO fin_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jeesus pysähtyi tullessaan miehen kohdalle. »Tuokaa sokea tänne», hän pyysi. ");
INSERT INTO fin_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","Sitten hän kysyi mieheltä: »Mitä haluat?» »Tahtoisin saada näköni, Herra», tämä vastasi. ");
INSERT INTO fin_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jeesus sanoi: »Hyvä on, nyt voit nähdä! uskosi on parantanut sinut.» ");
INSERT INTO fin_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mies sai heti näkönsä ja lähti kulkemaan Jeesuksen jäljessä. Koko ajan hän kiitti Jumalaa. Myös kaikki tapahtuman todistajat ylistivät Jumalaa. ");
INSERT INTO fin_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","2","Jeesuksen kulkiessa Jerikon läpi eräs Sakkeus-niminen mies, joka oli paikkakunnan veronkantajien johtaja ja tietysti hyvin rikas, ");
INSERT INTO fin_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","halusi välttämättä nähdä hänet. Väkijoukon keskeltä hän ei lyhyenä miehenä nähnyt mitään. ");
INSERT INTO fin_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Siksi hän juoksi edelle ja kiipesi tien vieressä kasvavaan viikunapuuhun tähystelemään. ");
INSERT INTO fin_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kun Jeesus tuli sille kohdalle, hän katsoi ylös ja puhutteli Sakkeusta nimeltä: »Sakkeus, tule heti alas! Aion tänään tulla vieraaksi kotiisi.» ");
INSERT INTO fin_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakkeus tuli nopeasti alas ja vei iloisena Jeesuksen kotiinsa. ");
INSERT INTO fin_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ihmiset olivat tyytymättömiä. He mutisivat: »Kaikenlaisten syntisten luo hänkin viitsii mennä.» ");
INSERT INTO fin_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mutta Sakkeus sanoi Jeesukselle: »Olen valmis antamaan puolet omaisuudestani köyhille, ja jos huomaan ottaneeni joltakin liikaa veroja, korvaan sen hänelle nelinkertaisesti.» ");
INSERT INTO fin_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","Jeesus vastasi hänelle: »Tuo osoittaa, että tässä kodissa on tänään löydetty pelastus.» Hän jatkoi: »Tämäkin mies oli Aabrahamin kadonnut poika. Minä, Ihmisen Poika, olen tullut etsimään ja pelastamaan juuri kadonneita.» ");
INSERT INTO fin_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Koska Jeesus nyt oli lähellä Jerusalemia ja ihmiset luulivat, että Jumalan valtakunta alkaisi pian, hän esitti tällaisen vertauksen oikaistakseen heidän käsitystään: ");
INSERT INTO fin_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","»Aatelismies lähti pitkälle matkalle valtakuntansa pääkaupunkiin, missä hänet kruunattaisiin oman alueensa kuninkaaksi. ");
INSERT INTO fin_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ennen lähtöään hän kutsui kymmenen palvelijaansa luokseen ja antoi heille kullekin leiviskän verran rahaa, että he sijoittaisivat sen mahdollisimman hyvin hänen poissaollessaan. ");
INSERT INTO fin_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Osa kansasta kuitenkin vihasi häntä ja ilmoitti, ettei hyväksynyt häntä kuninkaakseen. ");
INSERT INTO fin_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Palattuaan hän kutsui koolle ne kymmenen miestä, joille oli antanut rahaa, saadakseen selville miten he olivat toimineet ja kuinka paljon voittaneet. ");
INSERT INTO fin_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ensimmäinen mies oli päässyt erittäin hyvään tulokseen: hänellä oli alkupääomaan verrattuna rahaa kymmenkertaisesti. ");
INSERT INTO fin_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","’Hienoa, sinä olet hyvä työntekijä!’ kuningas sanoi. ’Koska olet hoitanut vaatimattoman tehtävän uskollisesti, annan nyt johdettavaksesi kymmenen kaupunkia.’ ");
INSERT INTO fin_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Myös seuraavan miehen saavutus oli loistava – voitto oli viisinkertainen. ");
INSERT INTO fin_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kuningas sanoi: ’Hyvä, saat hallintaasi viisi kaupunkia.’ ");
INSERT INTO fin_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kolmas mies sen sijaan palautti vain saman summan, jonka oli saanut. Hän selitti: ’Pidin sitä säästössä, ");
INSERT INTO fin_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","koska pelkäsin sinua. Sinun kanssasi on vaikea olla tekemisissä, kun sinä otat sellaistakin mikä ei ole sinun ja korjaat sieltä mihin et ole kylvänyt.’ ");
INSERT INTO fin_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kuningas huusi: ’Veltto vätys! Sinua kohtaan olenkin kova, niin kuin sanoit. Jos kerran niin hyvin tiesit, millainen olen, ");
INSERT INTO fin_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","miksi et vienyt rahaani edes pankkiin, että olisin saanut nostaa sen korkoineen?’ ");
INSERT INTO fin_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Hän käski vieressä seisovien ottaa mieheltä rahat pois ja antaa sille, joka oli voittanut eniten. ");
INSERT INTO fin_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","’Mutta hänellähän on tarpeeksi ennestäänkin’, he huomauttivat. ");
INSERT INTO fin_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kuningas vastasi: ’Aina käy niin, että ne, joilla on jo ennestäänkin, saavat lisää, ja ne joilla on vain vähän, menettävät senkin. ");
INSERT INTO fin_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ja nyt – tuokaa tänne kapinaan nousseet vastustajani ja teloittakaa heidät silmieni edessä.’» ");
INSERT INTO fin_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Lopetettuaan kertomuksensa Jeesus lähti kulkemaan oppilaidensa edellä Jerusalemia kohti. ");
INSERT INTO fin_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kun he tulivat Öljymäelle Beetfagen ja Betanian lähelle, Jeesus lähetti kaksi oppilastaan ");
INSERT INTO fin_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","edellään seuraavaan kylään. Heidän piti etsiä sieltä tien viereen sidottu aasinvarsa, jolla kukaan ei ollut vielä ratsastanut. »Irrottakaa varsa ja tuokaa tänne», Jeesus pyysi. ");
INSERT INTO fin_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","»Jos joku kysyy, miksi otatte sen, sanokaa vain, että Herra tarvitsee sitä.» ");
INSERT INTO fin_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Oppilaat löysivät täsmälleen sellaisen varsan, josta Jeesus oli puhunut. ");
INSERT INTO fin_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Omistajat tulivat vaatimaan heiltä selitystä juuri kun he olivat irrottamassa varsaa. »Mitä te oikein teette?» he kysyivät. ");
INSERT INTO fin_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Oppilaat vastasivat: »Herra tarvitsee sitä!» ");
INSERT INTO fin_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","He veivät varsan Jeesukselle ja riisuivat sen selkään vaatteitaan, ja Jeesus istui niille. ");
INSERT INTO fin_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","37","Myös väki levitti vaatteitaan tielle Jeesuksen eteen. Kun väkijoukko lähti laskeutumaan Öljymäen rinnettä, se rupesi kävellessään laulamaan ja ääneen ylistämään Jumalaa kaikista Jeesuksen tekemistä ihmeistä. ");
INSERT INTO fin_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","»Kunnia Jumalan lähettämälle kuninkaalle! Eläköön kuningas! Taivaatkin iloitsevat! Kunnia taivaan Jumalalle!» ihmiset huusivat. ");
INSERT INTO fin_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jotkut fariseukset huomauttivat väentungoksen keskeltä: »Opettaja, sinun pitäisi hillitä oppilaitasi, kun he huutavat tuollaista.» ");
INSERT INTO fin_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jeesus vastasi: »Jos he olisivat hiljaa, nämä kivet puhkeaisivat huutamaan.» ");
INSERT INTO fin_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kun he yhä etenivät lähemmäksi Jerusalemia ja Jeesus näki kaupungin edessään, kyyneleet tulivat hänen silmiinsä. ");
INSERT INTO fin_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Hän sanoi itkien: »Ikuinen rauha oli ulottuvillasi, mutta torjuit sen, ja nyt on liian myöhäistä. ");
INSERT INTO fin_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Vihollisesi piirittävät sinua, rakentavat vallin ympärillesi ja ahdistavat sinua joka puolelta. ");
INSERT INTO fin_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Sinut ja lapsesi murskataan, eivätkä vihollisesi jätä kiveä kiven päälle, sillä olet hylännyt mahdollisuuden, jonka Jumala sinulle antoi.» ");
INSERT INTO fin_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jeesus meni temppeliin ja alkoi ajaa kauppiaita pois myyntipöytiensä takaa. ");
INSERT INTO fin_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Hän huusi: »Raamattu sanoo: ’Minun temppelini on tarkoitettu paikaksi, jossa rukoillaan, mutta te olette tehneet siitä rosvoluolan.’» ");
INSERT INTO fin_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Tämän jälkeen hän opetti joka päivä temppelissä. Ylipapit, muut uskonnolliset johtajat ja vaikutusvaltaiset ihmiset alkoivat tosissaan miettiä, miten saisivat hänet hengiltä. ");
INSERT INTO fin_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","He eivät kuitenkaan keksineet mitään, sillä kansa oli hänen puolellaan ja kuunteli tarkasti hänen jokaista sanaansa. ");
INSERT INTO fin_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jeesus oli taas eräänä päivänä temppelissä opettamassa ja julistamassa hyvää uutista. Ylipappeja, lainopettajia ja muita kansan johtomiehiä tuli silloin kuulustelemaan häntä. ");
INSERT INTO fin_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","He vaativat häntä selittämään, millä valtuudella hän oli ajanut kauppiaat temppelistä. ");
INSERT INTO fin_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","»Teen teille kysymyksen ennen kuin vastaan itse», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","»Saiko Johannes valtuudet kastaa Jumalalta vai ihmisiltä?» ");
INSERT INTO fin_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","He pohtivat asiaa keskenään: »Jos sanomme, että Johanneksen sanoma oli taivaasta, hän kysyy, miksi sitten emme uskoneet siihen. ");
INSERT INTO fin_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jos taas sanomme, että Jumala ei lähettänyt Johannesta, kansa käy kimppuumme. Se kun uskoo vakaasti, että Johannes oli profeetta.» ");
INSERT INTO fin_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Lopulta he vastasivat: »Emme tiedä.» ");
INSERT INTO fin_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jeesus puolestaan sanoi: »En minäkään sitten vastaa kysymykseenne.» ");
INSERT INTO fin_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Hän alkoi taas puhua ihmisjoukolle. Se sai kuulla tällaisen vertauksen: »Mies istutti viinitarhan, vuokrasi sen viininviljelijöille ja matkusti itse useiksi vuosiksi ulkomaille. ");
INSERT INTO fin_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Viininkorjuuaikaan hän lähetti yhden miehistään maatilalle hakemaan osaa sadosta. Mutta vuokraajat pahoinpitelivät miehen, ja hän joutui lähtemään tyhjin käsin pois. ");
INSERT INTO fin_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Omistaja lähetti toisen miehen, mutta hänelle kävi yhtä huonosti. ");
INSERT INTO fin_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Vielä kolmaskin mies yritti suorittaa tehtävän: myös hänet hakattiin. ");
INSERT INTO fin_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Mitä minä nyt teen?’ omistaja mietti. Sitten hän keksi. ’Lähetän sinne oman rakkaan poikani. Häntä he nyt sentään kunnioittavat.’ ");
INSERT INTO fin_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kun vuokraajat näkivät pojan, he sanoivat: ’Hän perii tilan isänsä kuoltua. Mutta nyt on meidän tilaisuutemme! Tapetaan poika, niin maa on meidän.’ ");
INSERT INTO fin_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","He raahasivat omistajan pojan viinitarhan ulkopuolelle ja tappoivat hänet. Mitä luulette omistajan tekevän? ");
INSERT INTO fin_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Minä sanon sen teille: hän tulee, tuhoaa entiset vuokraajat ja vuokraa viinitarhan muille.» Kuuntelijat väittivät vastaan: »Ei sellaista voi tapahtua.» ");
INSERT INTO fin_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jeesus vilkaisi heihin ja kysyi: »Mitä Raamattu sitten tarkoittaa sanoessaan, että rakentajien hylkäämästä kivestä tulee kulmakivi?» ");
INSERT INTO fin_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ja hän jatkoi: »Jokainen, joka kompastuu tuohon kiveen, ruhjoutuu. Ne, joiden päälle kivi kaatuu, murskautuvat.» ");
INSERT INTO fin_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kun ylipapit ja muut kansan uskonnolliset johtajat kuulivat hänen kertomuksensa, he olisivat halunneet saada Jeesuksen heti vangituksi, sillä he tajusivat pahojen viininviljelijöiden tarkoittavan juuri heitä. Levottomuuksia peläten he eivät tahtoneet itse pidättää Jeesusta, vaan yrittivät saada hänet sanomaan jotain sellaista, josta Rooman maaherra saisi aiheen pidätykseen. ");
INSERT INTO fin_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","He lähettivät Jeesuksen luo tarkkailijoitaan, jotka kysyivät muka vilpittömästi: ");
INSERT INTO fin_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","»Tiedämme, että opetuksesi on aina oikeaa etkä anna minkään horjuttaa itseäsi. Sinä opetat niin kuin Jumala tahtoo. ");
INSERT INTO fin_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sano meille, onko oikein maksaa veroja Rooman hallitukselle?» ");
INSERT INTO fin_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jeesus näki heidän lävitseen ja sanoi: ");
INSERT INTO fin_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","»Näyttäkää minulle kolikko. Kenen kuva ja nimi siinä on?» He vastasivat: »Rooman keisarin.» ");
INSERT INTO fin_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Hän sanoi: »Antakaa keisarille kaikki, mikä hänelle kuuluu, ja myös Jumalalle kaikki, mikä hänelle kuuluu.» ");
INSERT INTO fin_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","He eivät siis onnistuneet saamaan häntä ansaan väkijoukon edessä, ja ihmetellen Jeesuksen vastausta he vaikenivat. ");
INSERT INTO fin_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Muutama saddukeusten puolueen jäsen tuli sitten esittämään hänelle asiaansa. Saddukeuksethan eivät uskoneet kuolleiden ylösnousemukseen. He sanoivat hänelle: »Mooseksen laissa määrätään, että jos mies kuolee lapsettomana, hänen veljensä on mentävä naimisiin lesken kanssa ja yhteiset lapset tulevat kuolleen miehen nimiin. ");
INSERT INTO fin_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kuulimme perheestä, jossa oli seitsemän poikaa. Vanhin meni naimisiin ja kuoli lapsettomana. ");
INSERT INTO fin_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Hänen veljensä solmi avioliiton lesken kanssa mutta kuoli myös ilman perillistä. ");
INSERT INTO fin_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kaikille veljeksille kävi samalla tavalla. ");
INSERT INTO fin_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Lopulta vaimokin kuoli. ");
INSERT INTO fin_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Olemme nyt ymmällä: kenen vaimo hänestä tulee kuoleman jälkeisessä elämässä, kun hän ehti olla kaikkien näiden veljesten kanssa naimisissa!» ");
INSERT INTO fin_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","35","Jeesus vastasi: »Avioliittoja solmitaan vain täällä maan päällä. Ne, jotka pääsevät kuoleman jälkeen ikuiseen elämään, eivät enää mene siellä naimisiin. ");
INSERT INTO fin_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","He eivät myöskään enää kuole. Tässä suhteessa he ovat kuin enkeleitä. He ovat Jumalan lapsia, sillä he ovat heränneet kuoltuaan uuteen elämään. ");
INSERT INTO fin_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","38","Itse asiassa te kysytte, onko ylösnousemusta. Ylösnousemuksesta todistavat jopa Mooseksen kertomukset. Kuvaillessaan, miten Jumala ilmestyi hänelle palavassa pensaassa, hän nimittää tätä ’Aabrahamin, Iisakin ja Jaakobin Jumalaksi’. Koska hän sanoo, että Herra on jonkun Jumala, hän tarkoittaa, että tuo henkilö on elossa eikä kuollut. Jumalan näkökulmasta katsoen kaikki ihmiset ovat elossa.» ");
INSERT INTO fin_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","»Hyvin sanottu!» totesivat paikalla olleet lainopettajat. ");
INSERT INTO fin_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kysymykset tyrehtyivät siihen. ");
INSERT INTO fin_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jeesus kysyi nyt vuorostaan heiltä: »Miksi Kristusta sanotaan Daavidin jälkeläiseksi? ");
INSERT INTO fin_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Daavidhan kirjoitti itse psalmeissaan: ’Jumala sanoi Messiaalle, minun Herralleni: Istu oikealle puolelleni, kunnes alistan vihollisesi jalkojesi alle.’ ");
INSERT INTO fin_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Miten Messias voi olla sekä Daavidin poika että hänen Jumalansa?» ");
INSERT INTO fin_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Sitten hän sanoi oppilailleen kaikkien kuullen: ");
INSERT INTO fin_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","»Varokaa noita oppineita, jotka mielellään kulkevat hienoissa viitoissa ja haluavat, että ihmiset kumartelisivat heille kaduilla. He rakastavat kunniapaikkoja synagogissa ja juhlissa. ");
INSERT INTO fin_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","He rukoilevat pitkään ja näennäisen hartaina, mutta havittelevat kuitenkin leskien omaisuutta. Siksi heidän osakseen tulee Jumalan ankarin tuomio.» ");
INSERT INTO fin_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Seisoessaan temppelissä Jeesus näki rikkaiden heittävän lahjojaan kolehtiarkkuun. ");
INSERT INTO fin_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Sitten köyhä leski pudotti siihen kaksi pikkukolikkoa. ");
INSERT INTO fin_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jeesus sanoi: »Itse asiassa tämä leski antoi enemmän kuin kaikki muut yhteensä. ");
INSERT INTO fin_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Toiset antoivat sellaista, mitä eivät itse tarvinneet, mutta hän antoi kaiken, mitä hänellä oli.» ");
INSERT INTO fin_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jotkut oppilaista ihastelivat temppelin kauniita rakennuskiviä ja sinne tuotuja lahjoja. ");
INSERT INTO fin_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Mutta Jeesus sanoi: »Tulee aika, jolloin kaikki, mitä te nyt ihailette, on soraläjänä.» ");
INSERT INTO fin_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","»Milloin niin käy, opettaja?» he kysyivät. »Tapahtuuko se ilman ennakkovaroitusta?» ");
INSERT INTO fin_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jeesus vastasi: »Älkää antako johtaa itseänne harhaan. Moni väittää olevansa Messias ja sanoo, että se aika on tullut. Älkää uskoko heitä! ");
INSERT INTO fin_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kun kuulette sodista ja kapinoista, älkää joutuko pakokauhun valtaan. Sotien täytyy tulla, mutta ne eivät merkitse välitöntä loppua. ");
INSERT INTO fin_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kansat ja valtiot hyökkäävät toisiaan vastaan. ");
INSERT INTO fin_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tulee suuria maanjäristyksiä, kulkutaudit leviävät, monissa maissa on nälänhätää, ja taivaalla on pelottavia ilmiöitä. ");
INSERT INTO fin_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ennen tätä kaikkea on erityinen vainon aika. Teitä viedään minun takiani synagogiin ja vankiloihin, kuninkaiden ja maaherrojen eteen. ");
INSERT INTO fin_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tästä on se hyöty, että saatte tilaisuuden todistaa minusta. ");
INSERT INTO fin_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Älkää edeltäpäin huolehtiko, miten vastaatte syytöksiin. ");
INSERT INTO fin_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Annan teille oikeat sanat ja viisauden, jonka edessä vastustajanne ovat sanattomia. ");
INSERT INTO fin_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jopa omat vanhempanne, veljenne, sukulaisenne ja ystävänne voivat ilmiantaa teidät. Muutamia teistä myös surmataan. ");
INSERT INTO fin_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kaikki vihaavat teitä, koska olette minun omiani. ");
INSERT INTO fin_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mutta teiltä ei katoa hiuskarvakaan, ");
INSERT INTO fin_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ja kun pysytte lujina, voitatte ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Kun näette sotajoukot Jerusalemin ympärillä, tiedätte, että sen tuhon hetki on tullut. ");
INSERT INTO fin_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Juudean asukkaiden on silloin lähdettävä kiireesti vuorille ja jerusalemilaisten yritettävä päästä pakoon; maalle lähteneiden ei kannata palata kaupunkiin. ");
INSERT INTO fin_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ne ovat Jumalan tuomion päiviä, jolloin vanhat profeettojen kirjoitukset toteutuvat. ");
INSERT INTO fin_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Voi odottavia äitejä ja niitä, joilla on pieniä lapsia! Tämä maa on kovassa ahdingossa ja tätä kansaa vihataan. ");
INSERT INTO fin_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ihmisiä tapetaan raa’asti ja viedään suurin joukoin vankeuteen ja maanpakoon kaikkiin maailman maihin. Pakanat pitävät Jerusalemia hallussaan, kunnes heidän aikansa päättyy Jumalan säätämällä hetkellä. ");
INSERT INTO fin_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Myös auringossa, kuussa ja tähdissä on varoittavia merkkejä. Meret pauhaavat ja kansat ovat hämmentyneitä ja epätoivoisia. ");
INSERT INTO fin_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Monien ihmisten rohkeus pettää, kun he tajuavat maapallon kauhean kohtalon; avaruuden tasapaino nimittäin järkkyy. ");
INSERT INTO fin_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Silloin ihmiset näkevät minun tulevan pilvissä täynnä suurta kirkkautta ja voimaa. ");
INSERT INTO fin_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kun nämä kaikki alkavat toteutua, pysykää rohkeina ja katsokaa ylös: pelastumisenne on lähellä.» ");
INSERT INTO fin_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jeesus kertoi heille esimerkin: »Katsokaa viikunapuuta ja kaikkia muitakin puita. ");
INSERT INTO fin_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kun lehdet puhkeavat, teille ei tarvitse sanoa, että pian tulee kesä. ");
INSERT INTO fin_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kun tapahtumat, joita olen kuvaillut, alkavat vyöryä, voitte samalla tavoin luottaa siihen, että Jumalan valtakunta on lähellä. ");
INSERT INTO fin_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Olkaa varmat siitä, että kun näin tapahtuu, tämän ajan loppu on tullut. ");
INSERT INTO fin_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Minun sanani ovat ikuisesti totta, vaikka taivas ja maa lakkaisivat olemasta. ");
INSERT INTO fin_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Olkaa valmiina, ettei äkillinen paluuni pääse yllättämään teitä! En tahtoisi nähdä teidän juhlivan ja juopottelevan huolettomina tai elävän kuin muut kaiken maailman murheiden painamina. ");
INSERT INTO fin_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Olkaa valppaat ja rukoilkaa, että jos suinkin mahdollista, voisitte ilmestyä eteeni tarvitsematta kokea noita kauhuja.» ");
INSERT INTO fin_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","Jeesus tuli temppeliin joka päivä opettamaan ihmisiä, ja sankat kuulijajoukot alkoivat kokoontua sinne jo aikaisin aamulla. Yöt Jeesus vietti Öljymäellä. ");
INSERT INTO fin_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Oli tulossa pääsiäinen – juhla, jonka aikana juutalaiset käyttivät vain happamatonta leipää. ");
INSERT INTO fin_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ylipapit ja muut uskonnolliset johtomiehet suunnittelivat kiihkeästi Jeesuksen murhaa. Se piti vain tehdä niin, ettei syntyisi levottomuuksia: he pelkäsivät kansaa. ");
INSERT INTO fin_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sitten saatana meni Juudas Iskariotiin, joka oli yksi Jeesuksen kahdestatoista oppilaasta. ");
INSERT INTO fin_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tämä lähti ylipappien ja temppelivartion päälliköiden luo neuvottelemaan, miten saisi Jeesuksen helpoimmin heidän käsiinsä. ");
INSERT INTO fin_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nämä tulivat tietysti iloisiksi ja lupasivat maksaa Juudakselle. ");
INSERT INTO fin_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Juudas alkoi odottaa sopivaa tilaisuutta; Jeesus olisi paras pidättää sellaisena hetkenä, jolloin hänen ympärillään ei olisi väkijoukkoja. ");
INSERT INTO fin_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Oli pääsiäisviikon se päivä, jona pääsiäislammas teurastetaan ja syödään happamattoman leivän kanssa. ");
INSERT INTO fin_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jeesus lähetti Pietarin ja Johanneksen tekemään valmisteluja pääsiäisateriaa varten. ");
INSERT INTO fin_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","»Minne valmistamme sen?» he kysyivät. ");
INSERT INTO fin_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jeesus vastasi: »Kun tulette Jerusalemiin, näette kadulla vesiruukkua kantavan miehen. Menkää samaan taloon kuin hänkin ");
INSERT INTO fin_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ja sanokaa isännälle: ’Opettajamme pyytää, että näyttäisit meille vierashuoneen, jossa hän voisi syödä oppilaidensa kanssa pääsiäisaterian.’ ");
INSERT INTO fin_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Hän vie teidät suureen yläkerran huoneeseen. Kaikki on siellä kunnossa meitä varten. Valmistakaa ateria sinne.» ");
INSERT INTO fin_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","He menivät muiden edellä kaupunkiin, ja kaikki kävi niin kuin Jeesus oli sanonut. He kattoivat pääsiäisaterian. ");
INSERT INTO fin_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jeesus tuli jäljestä toisten kanssa, ja aterian alkamisaikaan he kaikki kävivät pöytään. ");
INSERT INTO fin_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jeesus sanoi: »Olen hartaasti odottanut, että saan syödä tämän pääsiäislampaan teidän kanssanne, ennen kuin joudun kärsimään. ");
INSERT INTO fin_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Seuraavan kerran syön sitä vasta sitten, kun Jumalan valtakunnassa on toteutunut tällaisen aterian tarkoitus.» ");
INSERT INTO fin_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Hän otti viinimaljan käteensä, kiitti Jumalaa ja sanoi: »Ottakaa tämä ja juokaa siitä kaikki. ");
INSERT INTO fin_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nyt en enää juo viiniä, ennen kuin Jumalan valtakunta on tullut.» ");
INSERT INTO fin_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sitten hän tarttui leipään, ja kiitettyään siitä Jumalaa hän mursi sen palasiksi, antoi oppilailleen ja sanoi: »Tämä on ruumiini, jonka annan puolestanne. Syökää se minun muistokseni.» ");
INSERT INTO fin_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Aterian jälkeen hän otti viinimaljan ja sanoi: »Tämä on uusi liitto, jonka Jumala tekee teidän kanssanne pelastaakseen teidät. Liitto vahvistetaan minun verelläni, jonka vuodatan uhrina puolestanne. ");
INSERT INTO fin_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Mutta meidän joukossamme istuu myös pettäjäni. ");
INSERT INTO fin_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Minun on kuoltava. Se kuuluu Jumalan suunnitelmaan. Mutta sen ihmisen kohtalo on kauhea, joka minut pettää.» ");
INSERT INTO fin_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Oppilaat kyselivät ihmeissään, kuinka kukaan heistä koskaan voisi tehdä sellaista. ");
INSERT INTO fin_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sitten he alkoivat kinastella siitä, kuka heistä pääsisi parhaaseen asemaan tulevassa valtakunnassa. ");
INSERT INTO fin_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jeesus sanoi heille: »Tässä maailmassa määräilevät hallitsijat ja mahtimiehet kansoja kuin orjiaan, ja heitä sanotaan hyväntekijöiksi. ");
INSERT INTO fin_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mutta teidän keskuudessanne on suurin se, joka palvelee parhaiten. ");
INSERT INTO fin_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tavallisesti isäntä istuu pöydässä ja edellyttää, että häntä palvellaan. Mutta nyt minä olen teidän palvelijanne. ");
INSERT INTO fin_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Olette kuitenkin olleet minulle uskollisia näinä vaikeina päivinä. ");
INSERT INTO fin_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Isäni on tehnyt minusta kuninkaan, ja minä puolestani annan teille oikeuden ");
INSERT INTO fin_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","syödä ja juoda pöydässäni hänen valtakunnassaan. Saatte istua valtaistuimella ja tuomita Israelin kahtatoista heimoa. ");
INSERT INTO fin_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, saatana haluaisi seuloa teitä kuin vehnää, ");
INSERT INTO fin_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","mutta olen rukoillut puolestasi, ettet kokonaan menettäisi uskoasi. Kun olet katunut ja palannut taas luokseni, vahvista myös veljiesi uskoa.» ");
INSERT INTO fin_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simon sanoi: »Herra, minähän olen valmis menemään kanssasi vankilaan ja vaikka kuolemaankin.» ");
INSERT INTO fin_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mutta Jeesus sanoi: »Kuule nyt, Pietari! Jo tänä yönä, ennen kuin kukko aamulla kiekuu, sinä kolme kertaa kiellät edes tuntevasi minua.» ");
INSERT INTO fin_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sitten hän kysyi: »Miten tulitte toimeen, kun lähetin teidät ilman rahaa, laukkua ja ylimääräisiä vaatteita hyvää uutista julistamaan?» He vastasivat: »Aivan hyvin.» ");
INSERT INTO fin_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","»Jos teillä on laukku tai rahaa, ottakaa ne nyt mukaanne», hän sanoi. »Ellei teillä ole miekkaa, myykää vaatteenne ja ostakaa. ");
INSERT INTO fin_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nyt nimittäin toteutuu minusta sanottu ennustus: ’Hänet tuomitaan rikollisena.’ Kaikki, mitä profeetat ovat kirjoittaneet minusta, toteutuu.» ");
INSERT INTO fin_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","He sanoivat: »Herra, meillä on kaksi miekkaa mukanamme.» »Jo riittää», hän vastasi. ");
INSERT INTO fin_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jeesus lähti oppilaidensa kanssa ulos ja meni tapansa mukaan Öljymäelle. ");
INSERT INTO fin_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Siellä hän kehotti: »Rukoilkaa Jumalaa, ettei kiusaus voittaisi teitä.» ");
INSERT INTO fin_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","42","Hän meni yksinään kivenheiton päähän heistä, painui polvilleen ja rukoili: »Jos tahdot, Isä, ota minulta tämä kärsimysten malja. Olen kuitenkin valmis kaikkeen, mitä sinä tahdot.» ");
INSERT INTO fin_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Taivaasta tuli silloin enkeli vahvistamaan häntä. ");
INSERT INTO fin_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Hän oli niin suuressa tuskassa, että hikoili veripisaroita. ");
INSERT INTO fin_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Lopulta hän nousi ja palasi oppilaidensa luo, mutta huomasi, että he olivat murheen uuvuttamina nukahtaneet. ");
INSERT INTO fin_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","»Te nukutte!» hän sanoi. »Herätkää ja rukoilkaa Jumalaa, ettette lankeaisi, kun joudutte kiusaukseen.» ");
INSERT INTO fin_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Hänen vielä puhuessaan heitä lähestyi meluisa ihmisjoukko Juudas etunenässä. Juudas tuli Jeesuksen luo tervehtiäkseen häntä suudelmalla, ");
INSERT INTO fin_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","mutta Jeesus sanoi: »Suudelmallako sinä Messiaan kavallat?» ");
INSERT INTO fin_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kun muut oppilaat ymmärsivät, mitä oli tekeillä, he huusivat: »Opettaja, käytämmekö näitä miekkoja?» ");
INSERT INTO fin_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yksi heistä sivalsi ylipapin palvelijalta oikean korvan pois. ");
INSERT INTO fin_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mutta Jeesus sanoi: »Älkää enää tehkö vastarintaa.» Ja hän kosketti miehen korvaa ja paransi hänet. ");
INSERT INTO fin_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sitten hän sanoi ylipapeille, temppelivartion päälliköille ja väkijoukon kärjessä tulleille kansan johtomiehille: »Olenko minä rikollinen, kun te tulette ottamaan minua kiinni miekkojen ja seipäiden kanssa? ");
INSERT INTO fin_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Miksi ette pidättäneet minua temppelissä, kun olin siellä joka päivä? Mutta nyt on teidän ja saatanan voiton hetki.» ");
INSERT INTO fin_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","He ottivat hänet kiinni ja veivät ylipapin taloon. Pietari seurasi jäljessä. ");
INSERT INTO fin_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sotilaat sytyttivät keskelle pihaa nuotion ja istuivat sen ympärille lämmittelemään. Pietari meni heidän joukkoonsa. ");
INSERT INTO fin_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Eräs palvelustyttö huomasi hänet tulen valossa ja alkoi tuijottaa häntä. Lopulta tyttö tokaisi: »Tuokin oli Jeesuksen kanssa!» ");
INSERT INTO fin_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pietari kielsi: »Minä en edes tunne koko miestä!» ");
INSERT INTO fin_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Hetken kuluttua joku toinen katsoi häntä ja sanoi: »Kyllä sinä vain olet yksi heistä!» »Varmasti en ole», Pietari vastasi. ");
INSERT INTO fin_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tuntia myöhemmin joku väitti taas: »Tiedän, että tuo mies on Jeesuksen oppilaita. Hehän ovat molemmat galilealaisiakin.» ");
INSERT INTO fin_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mutta Pietari kielsi: »En ymmärrä, mitä tarkoitat.» Ja silloin kiekui kukko. ");
INSERT INTO fin_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sillä hetkellä Jeesus kääntyi ja katsoi Pietariin. Tämä muisti äkkiä, mitä Jeesus oli sanonut: »Huomisaamuun kukonlauluun mennessä kiellät kolme kertaa tuntevasi minut.» ");
INSERT INTO fin_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pietari lähti pois pihalta katkerasti itkien. ");
INSERT INTO fin_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","Vartiosotilaat alkoivat pilkata Jeesusta. He sitoivat hänen silmänsä, iskivät häntä nyrkillä ja kysyivät: »Kuka sinua nyt löi, profeetta?» ");
INSERT INTO fin_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","He solvasivat häntä kaikin tavoin. ");
INSERT INTO fin_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aikaisin seuraavana aamuna kokoontui ylipappien ja muiden uskonnollisten johtomiesten muodostama neuvosto, juutalaisten korkein oikeus. Jeesus vietiin sen eteen ");
INSERT INTO fin_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","68","ja häntä vaadittiin ilmoittamaan, oliko hän Messias. Jeesus vastasi: »Jos sanon teille, miten asia on, ette usko minua ettekä myöskään anna minun puhua. ");
INSERT INTO fin_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mutta pian istun kunniapaikalla kaikkivaltiaan Jumalan kirkkaudessa.» ");
INSERT INTO fin_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Kaikki huusivat: »Sanot siis olevasi Jumalan Poika?» Hän vastasi: »Te sanoitte sen nyt itse.» ");
INSERT INTO fin_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","He huusivat: »Tarvitsemmeko lisää todisteita? Tuo oli jo tunnustus.» ");
INSERT INTO fin_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Koko neuvosto vei sitten Jeesuksen maaherra Pilatuksen luo. ");
INSERT INTO fin_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Siellä neuvoston jäsenet esittivät syytöksensä: »Tämä mies johtaa kansamme tuhoon, sillä hän kieltää maksamasta veroja Rooman hallinnolle ja väittää olevansa kuningas, meidän Messiaamme.» ");
INSERT INTO fin_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilatus kysyi Jeesukselta: »Oletko sinä juutalaisten kuningas?» »Olen, aivan niin kuin sanoit», Jeesus vastasi. ");
INSERT INTO fin_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilatus kääntyi ylipappeihin ja kansaan päin: »Ei kai tätä voi pitää rikoksena?» ");
INSERT INTO fin_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","He hurjistuivat. »Hän saa aikaan mellakoita hallitusta vastaan missä vain liikkuukin – kaikkialla Juudeassa, Galileasta tänne asti.» ");
INSERT INTO fin_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","»Onko hän sitten galilealainen?» Pilatus kysyi. ");
INSERT INTO fin_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Saatuaan myöntävän vastauksen Pilatus lähetti Jeesuksen Herodeksen luo, sillä Galilea kuului tämän hallintaan. Herodes sattui olemaan silloin Jerusalemissa. ");
INSERT INTO fin_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hän oli kuullut paljon Jeesuksesta ja ilahtui, kun sai nyt tilaisuuden nähdä hänet. Erityisesti Herodes toivoi, että hän tekisi jonkin ihmeen. ");
INSERT INTO fin_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes teki Jeesukselle kysymyksen toisensa perään, mutta tämä ei vastannut yhteenkään. ");
INSERT INTO fin_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ylipapit ja lainopettajat huusivat syytöksiä. ");
INSERT INTO fin_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes ja hänen sotilaansa alkoivat pilkata Jeesusta. He pukivat hienon viitan hänen päälleen ja lähettivät hänet takaisin Pilatuksen luo. ");
INSERT INTO fin_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodes ja Pilatus olivat tätä ennen olleet vihamiehiä keskenään, mutta nyt heistä tuli ystäviä. ");
INSERT INTO fin_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatus kutsui ylipapit, lainopettajat ja muun joukon sisään ");
INSERT INTO fin_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ja ilmoitti heille päätöksensä: »Toitte tämän miehen luokseni ja syytitte häntä kapinan lietsomisesta Rooman hallitusta vastaan. Olen nyt kuulustellut häntä ja todennut hänet syyttömäksi. ");
INSERT INTO fin_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes tuli samaan tulokseen ja lähetti hänet takaisin tänne. Tämä mies ei ole syyllistynyt mihinkään, mikä vaatisi kuolemanrangaistusta. ");
INSERT INTO fin_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Annan hänet ruoskittavaksi ja päästän sitten vapaaksi.» ");
INSERT INTO fin_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Oli tapana, että juhlan aikana vapautettiin se vanki, jonka kansa halusi. ");
INSERT INTO fin_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kansanjoukko alkoi huutaa: »Ei häntä, vaan päästä meille Barabbas!» ");
INSERT INTO fin_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabbas oli vangittuna hallituksen vastaisen kapinan lietsomisesta ja murhasta. ");
INSERT INTO fin_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus yritti vielä puhua väkijoukolle, sillä hän tahtoi vapauttaa Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mutta ihmiset huusivat: »Ristiinnaulitse! Ristiinnaulitse!» ");
INSERT INTO fin_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilatus vetosi heihin vielä kolmannen kerran: »Minkä rikoksen hän on tehnyt? En ole todennut mitään sellaista, mistä voisin tuomita hänet kuolemaan. Annan ruoskia hänet ja päästän sitten vapaaksi.» ");
INSERT INTO fin_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mutta ihmiset huusivat yhä hurjemmin, että Jeesuksen oli kuoltava, ja lopulta heidän huutonsa pääsivät voitolle. ");
INSERT INTO fin_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","Pilatus antoi periksi ja lähetti Jeesuksen kuolemaan. Hän myös päästi Barabbaan vapaaksi, kuten he vaativat. Jeesukselle hän antoi heidän tehdä mitä tahtoivat. ");
INSERT INTO fin_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Kun Jeesusta vietiin surmattavaksi, tiellä tuli vastaan kyreneläinen Simon. Hän oli palaamassa maalta Jerusalemiin, ja nyt hänet pantiin kantamaan Jeesuksen ristiä. ");
INSERT INTO fin_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Suuri joukko ihmisiä kulki Jeesuksen perässä. Mukana oli useita surun murtamia naisia. ");
INSERT INTO fin_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jeesus kääntyi sanomaan heille: »Jerusalemin tyttäret, älkää itkekö minua, vaan itseänne ja lapsianne. ");
INSERT INTO fin_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tulee aika, jolloin pidetään onnellisina niitä naisia, joilla ei ole lapsia. ");
INSERT INTO fin_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ihmiset toivovat silloin, että vuoret murskaisivat heidät alleen ja maa peittäisi heidät. ");
INSERT INTO fin_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jos tällaista tapahtuu minulle, joka olen elävä puu, miten käykään teidän?» ");
INSERT INTO fin_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","33","Kaksi rikollista vietiin Jeesuksen kanssa teloitettavaksi niin sanotulle Pääkallonpaikalle. Siellä kaikki kolme ristiinnaulittiin – Jeesus keskimmäiseen ristiin ja rikolliset hänen kummallekin puolelleen. ");
INSERT INTO fin_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jeesus sanoi: »Isä, anna näille ihmisille anteeksi, sillä he eivät tiedä, mitä tekevät.» Sotilaat arpoivat keskenään hänen vaatteensa. ");
INSERT INTO fin_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ihmisjoukko seisoi ristien ympärillä katselemassa. Juutalaisten johtomiehet naureskelivat pilkallisina: »Hän oli hyvä auttamaan ihmisiä. Pelastakoon nyt itsensäkin, jos kerran on Jumalan valitsema Messias.» ");
INSERT INTO fin_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Myös sotilaat pilkkasivat häntä. He tarjosivat hänelle juotavaksi hapanviiniä ");
INSERT INTO fin_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ja huutelivat: »Pelasta itsesi, jos olet juutalaisten kuningas!» ");
INSERT INTO fin_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Hänen yläpuolelleen ristiin kiinnitettiin kilpi: »Juutalaisten kuningas.» ");
INSERT INTO fin_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Toinen hänen vierellään riippuvista rikollisista alkoi pilkata häntä: »Sinähän olet Messias? Auta nyt äkkiä itseäsi ja meitä myös.» ");
INSERT INTO fin_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","41","Mutta toinen rikollinen keskeytti hänet moittivasti: »Etkö pelkää Jumalaa edes kuollessasi? Meidän on kuoltava, koska olemme tehneet pahaa, mutta tämä mies on syytön.» ");
INSERT INTO fin_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Sitten hän sanoi: »Jeesus, muista minua, kun tulet valtakuntaasi.» ");
INSERT INTO fin_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jeesus vastasi: »Lupaan, että olet tänään kanssani paratiisissa.» ");
INSERT INTO fin_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Oli keskipäivä, mutta äkkiä koko maa pimeni kolmeksi tunniksi. ");
INSERT INTO fin_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Aurinkoa ei näkynyt. Yhtäkkiä temppelin pyhintä osaa erottava raskas verho repesi keskeltä halki. ");
INSERT INTO fin_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Sitten Jeesus huusi: »Isä, minä annan henkeni sinun käsiisi!» Ja niin hän kuoli. ");
INSERT INTO fin_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kun teloituksia johtava roomalainen upseeri näki, mitä oli tapahtunut, hän antoi kunnian Jumalalle ja sanoi: »Tämä oli varmasti Jumalan mies.» ");
INSERT INTO fin_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kun ristiinnaulitsemista seuranneet ihmiset näkivät Jeesuksen kuolleen, he palasivat murheellisina kotiin. ");
INSERT INTO fin_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jeesuksen ystävät seisoivat jonkin matkan päässä katselemassa. Heidän joukossaan olivat Jeesuksen mukana Galileasta tulleet naiset. ");
INSERT INTO fin_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51-52","Joosef – juutalaisten suuren neuvoston jäsen Juudean Arimatiasta – meni pyytämään Pilatukselta, että saisi ottaa Jeesuksen ruumiin ristiltä. Joosef oli Jumalan tahtoa kyselevä mies, joka odotti Messiaan tuloa. Hän ei ollut yhtynyt muiden kansanjohtajien päätöksiin. ");
INSERT INTO fin_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Hän otti nyt Jeesuksen ruumiin, kääri sen suureen liinaan ja vei kallioon hakattuun, käyttämättömään hautaan. ");
INSERT INTO fin_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Silloin oli perjantai-iltapäivä ja sapatinvietto alkamassa. ");
INSERT INTO fin_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galilealaiset naiset seurasivat hautausta kauempaa. ");
INSERT INTO fin_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sitten he menivät kotiinsa ja valmistivat tuoksuvia voiteita hautausta varten. Sapatin he lepäsivät, niin kuin laki vaati. ");
INSERT INTO fin_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Hyvin aikaisin sunnuntaiaamuna naiset lähtivät haudalle mukanaan valmistamansa voiteet. ");
INSERT INTO fin_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Perille tultuaan he huomasivat, että haudan suuta peittänyt valtava kivi oli vieritetty syrjään. ");
INSERT INTO fin_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","He menivät sisään – mutta Jeesuksen ruumista ei ollut missään! ");
INSERT INTO fin_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hämmästyneinä he seisoivat siinä kysellen, mitä ruumiille oli voinut tapahtua. Yhtäkkiä heidän eteensä ilmestyi kaksi miestä, joilla oli häikäisevän kirkkaat vaatteet. ");
INSERT INTO fin_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Kauhuissaan naiset painuivat maahan olentojen eteen. Miehet kysyivät: »Miksi etsitte haudasta häntä, joka elää? ");
INSERT INTO fin_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ei hän ole täällä. Hän elää, hän on noussut kuolleista! Ettekö muista, mitä hän puhui teille Galileassa? ");
INSERT INTO fin_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Hänhän kertoi, että Messias joutuu syntisten käsiin ja hänet ristiinnaulitaan, mutta kolmantena päivänä hän nousee kuolleista.» ");
INSERT INTO fin_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jeesuksen puhe palautui naisten mieleen. ");
INSERT INTO fin_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","He ryntäsivät haudalta takaisin Jerusalemiin ja kertoivat tapahtuneesta Jeesuksen yhdelletoista oppilaalle ja kaikille muille, joita tapasivat. ");
INSERT INTO fin_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Haudalla käyneiden naisten joukossa olivat Maria Magdaleena, Johanna ja Jaakobin äiti Maria. ");
INSERT INTO fin_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Miehet sanoivat: »Älkää nyt tyhjiä houriko!» eivätkä uskoneet naisten kertomusta. ");
INSERT INTO fin_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pietari kuitenkin lähti heti juoksujalkaa haudalle. Kurkistaessaan sisään hän näki vain käärinliinat. Hän palasi kotiin ja oli aivan ymmällään siitä, mitä oli nähnyt. ");
INSERT INTO fin_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Samana sunnuntaina kaksi Jeesuksen oppilasta oli menossa Emmauksen kylään, joka on melkein kahdentoista kilometrin päässä Jerusalemista. ");
INSERT INTO fin_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","He keskustelivat kulkiessaan Jeesuksen kuolemasta. ");
INSERT INTO fin_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Äkkiä Jeesus itse liittyi heidän seuraansa, ");
INSERT INTO fin_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","mutta he eivät tunteneet häntä. ");
INSERT INTO fin_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","»Teillä taitaa olla menossa syvällinen keskustelu», hän sanoi. »Mistä te puhutte?» He pysähtyivät murheellisen näköisinä. ");
INSERT INTO fin_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Kleopas, toinen miehistä, vastasi: »Sinä olet varmaan ainoa ihminen koko Jerusalemissa, joka et tiedä, mitä siellä on viime päivinä tapahtunut.» ");
INSERT INTO fin_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","20","»Mitä sitten?» Jeesus kysyi. He kertoivat: »Ylipapit ja muut johtajat pidättivät Jeesuksen, sen nasaretilaisen miehen, joka oli profeetta, Jumalan ja ihmisten kunnioittama. Hän teki valtavia ihmeitä ja oli ainutlaatuinen Jumalan sanan opettaja. Mutta kuitenkin hänet tuomittiin kuolemaan ja ristiinnaulittiin. ");
INSERT INTO fin_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Me olimme toivoneet, että hän olisi ollut Messias, joka vapauttaa Israelin. Nyt on kolmas päivä hänen kuolemastaan, ");
INSERT INTO fin_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","ja me olemme aivan ihmeissämme siitä, mitä muutamat joukkoomme kuuluvat naiset ovat kertoneet. He menivät aikaisin tänä aamuna haudalle ja kertoivat palattuaan jotain aivan merkillistä: Jeesuksen ruumis oli kadonnut ja he olivat nähneet enkeleitä, joka olivat sanoneet Jeesuksen elävän! ");
INSERT INTO fin_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jotkut miehistä juoksivat varmistamaan tietoa, ja Jeesuksen ruumis oli tosiaan kadonnut, niin kuin naiset väittivät.» ");
INSERT INTO fin_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Silloin Jeesus sanoi heille: »Voi, miten vastahakoisia te olette uskomaan sitä, mitä profeetat ovat kirjoittaneet! ");
INSERT INTO fin_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Eivätkö he ennustaneet selvästi, että Messias kärsisi kaiken tämän, ennen kuin hänen kirkkautensa aika alkaisi?» ");
INSERT INTO fin_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Sitten Jeesus selitti heille kaiken, mitä profeetat olivat Mooseksesta alkaen eri raamatunkohdissa hänestä sanoneet. ");
INSERT INTO fin_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","He olivat jo lähellä matkansa päämäärää, Emmausta. Jeesus oli jatkavinaan matkaa, ");
INSERT INTO fin_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mutta he pyysivät häntä luokseen yöksi, koska oli jo myöhä. Hän jäi. ");
INSERT INTO fin_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kun he kävivät illalliselle, Jeesus siunasi ruuan. Hän otti käteensä leivän, mursi sen palasiksi ja antoi oppilailleen. ");
INSERT INTO fin_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Silloin nämä äkkiä tunsivat hänet, mutta samassa hän jo katosi heidän näkyvistään. ");
INSERT INTO fin_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","He muistivat nyt, miten he olivat innostuneet, kun Jeesus puhui heidän kanssaan tiellä ja selitti heille Raamattua. ");
INSERT INTO fin_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","34","Viivyttelemättä he lähtivät takaisin Jerusalemiin. Jeesuksen yksitoista lähintä oppilasta ja muut seuraajat olivat siellä koolla ja kertoivat heti uutisen: »Herra on todella noussut kuolleista! Hän on ilmestynyt Pietarille!» ");
INSERT INTO fin_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tulijat puolestaan kertoivat, mitä tiellä oli tapahtunut ja miten he olivat tunteneet Jeesuksen, kun tämä mursi leipää. ");
INSERT INTO fin_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","He eivät olleet ehtineet vielä lopettaa, kun Jeesus äkkiä seisoi itse heidän keskellään ja tervehti heitä. ");
INSERT INTO fin_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Koko joukko pelästyi valtavasti; he luulivat näkevänsä hengen. ");
INSERT INTO fin_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","»Miksi pelästyitte?» Jeesus kysyi. »Miksi ette usko, että minä todella olen tässä? ");
INSERT INTO fin_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Katsokaa käsiäni ja jalkojani! Koskettakaa minua, niin uskotte, etten ole henki. Eihän hengellä ole ruumista niin kuin minulla.» ");
INSERT INTO fin_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Hän näytti heille käsissään ja jaloissaan olevat naulanjäljet. ");
INSERT INTO fin_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","He olivat suunnattoman iloisia, mutta epäröivät vieläkin. Silloin hän kysyi: »Onko teillä mitään syötävää?» ");
INSERT INTO fin_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","He antoivat hänelle palasen paistettua kalaa, ");
INSERT INTO fin_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ja hän söi sen heidän katsellessaan. ");
INSERT INTO fin_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sitten hän kysyi: »Ettekö muista, kuinka puhuin teille siitä, että kaikki toteutuu, mitä Mooseksen ja profeettojen kirjoissa ja psalmeissa on sanottu minusta?» ");
INSERT INTO fin_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kun hän oli saanut heidät lopulta ymmärtämään nuo raamatunkohdat, ");
INSERT INTO fin_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","hän sanoi: »Jo kauan sitten on kirjoitettu, että Messiaan täytyy kärsiä ja kuolla ja että hän nousee kolmantena päivänä kuolleista. ");
INSERT INTO fin_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Pelastussanoma on vietävä Jerusalemista kaikille kansoille: jokainen, joka kääntyy minun puoleeni, saa syntinsä anteeksi. ");
INSERT INTO fin_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Te olette saaneet nähdä ennustusten toteutuvan. ");
INSERT INTO fin_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Lähetän teille Pyhän Hengen, jonka Isäni on luvannut. Älkää vielä lähtekö liikkeelle, vaan odottakaa tässä kaupungissa, kunnes saatte taivaasta Pyhän Hengen voiman.» ");
INSERT INTO fin_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Myöhemmin Jeesus vei heidät Betanian lähelle, kohotti kätensä ja siunasi heidät. ");
INSERT INTO fin_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Silloin hän alkoi nousta ylöspäin, ja hänet otettiin taivaaseen. ");
INSERT INTO fin_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Maassa polvillaan oppilaat ylistivät Jeesusta. He palasivat Jerusalemiin suunnattoman iloisina ");
INSERT INTO fin_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ja ylistivät jatkuvasti temppelissä Jumalaa.");
INSERT INTO fin_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jeesus Kristus oli olemassa jo ennen kuin mitään muuta olikaan. ");
INSERT INTO fin_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Alussa hän oli Jumalan luona. Kristus on ollut olemassa aina, ja hän on Jumala. ");
INSERT INTO fin_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jo luomistyössä hän oli mukana – mitään ei ole luotu ilman häntä. ");
INSERT INTO fin_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kristuksessa on ikuinen elämä, valo koko ihmiskunnalle. ");
INSERT INTO fin_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tämä valo loistaa pimeään maailmaan, mutta maailma ei sitä ymmärrä. ");
INSERT INTO fin_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Jumala lähetti Johannes Kastajan todistamaan siitä, että Jeesus Kristus on ainoa oikea valo. ");
INSERT INTO fin_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Itse Johannes oli vain todistaja, jonka tehtävänä oli osoittaa, kuka valo on. ");
INSERT INTO fin_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kun Kristus sitten tuli tänne maailmaan, todellinen valo alkoi loistaa jokaiselle. Se valo oli ihmistä varten. ");
INSERT INTO fin_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Mutta vaikka Kristus oli osallistunut jo maailman luomiseen, maailma ei tuntenut häntä. ");
INSERT INTO fin_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ei edes hänen oma kansansa, juutalaiset, häntä hyväksynyt. Vain harvojen mielestä hän oli tervetullut. ");
INSERT INTO fin_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mutta kaikille niille, jotka ottivat hänet vastaan ja luottivat hänen tarjoamaansa pelastukseen, hän antoi oikeuden tulla Jumalan lapsiksi. ");
INSERT INTO fin_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tällaiset ihmiset ovat saaneet uuden elämän, syntyneet uudelleen – eivät ruumiillisesti, ihmisten suunnitelmien tai himojen tähden, vaan Jumalan tahdosta. ");
INSERT INTO fin_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kristus tuli ihmiseksi ja eli ihmisten kanssa täällä maan päällä. Hän oli täynnä armahtavaa rakkautta ja totuutta. Muutamat meistä ovat nähneet hänen kirkkautensa, Jumalan ainoalle Pojalle kuuluvan kirkkauden. ");
INSERT INTO fin_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Johannes osoitti häntä ihmisjoukoille: »Hänestä minä puhuin sanoessani, että se, joka tulee minun jälkeeni, on minua paljon suurempi. Hän on ollut olemassa kauan ennen minua.» ");
INSERT INTO fin_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jeesus toi Jumalan lahjat kaikkien meidän ulottuvillemme. ");
INSERT INTO fin_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mooseshan antoi meille ainoastaan lain jyrkkine vaatimuksineen ja armottomine oikeudenkäyttöineen, mutta Jeesus on tuonut meille armahtavan rakkauden. ");
INSERT INTO fin_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kukaan ei ole koskaan silmillään nähnyt Jumalaa paitsi hänen ainoa Poikansa, joka on hänen lähellään ja josta me näemme, millainen Jumala on. ");
INSERT INTO fin_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juutalaisten johtomiehet lähettivät Jerusalemista pappeja ja heidän apulaisiaan kysymään Johannekselta, väittikö tämä olevansa Messias. ");
INSERT INTO fin_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Johannes vastasi heti: »En minä ole Messias.» ");
INSERT INTO fin_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","»Kuka sitten olet?» häneltä kysyttiin. »Oletko Elia?» »En», hän vastasi. »Oletko se ennustusten profeetta?» »En.» ");
INSERT INTO fin_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","»Kuka sitten olet? Sano meille, että voimme vastata niille, jotka lähettivät meidät tänne. Mitä sanot itsestäsi?» ");
INSERT INTO fin_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Johannes vastasi: »Minä olen huutavan ääni autiomaasta, huudan niin kuin profeetta Jesaja ennusti: ’Valmistautukaa Herran tuloon!’» ");
INSERT INTO fin_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Silloin kansan johtajien lähettämät fariseukset kysyivät: »Jollet siis ole Messias tai Elia tai se profeetta, niin mikä oikeus sinulla on kastaa ihmisiä?» ");
INSERT INTO fin_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johannes selitti: »Minä kastan vain vedellä, mutta tässä ihmisjoukossa seisoo mies, jota te ette tunne. ");
INSERT INTO fin_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Hän tulee minun jälkeeni suorittamaan oman tehtävänsä. Minusta ei ole edes hänen orjakseen.» ");
INSERT INTO fin_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tämä tapahtui Jordanin toisella puolella olevassa Betaniassa, jossa Johannes kastoi ihmisiä. ");
INSERT INTO fin_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Seuraavana päivänä Johannes näki Jeesuksen tulevan luokseen ja sanoi: »Katsokaa, Jumalan uhrikaritsa, joka ottaa pois maailman synnin! ");
INSERT INTO fin_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Häntä minä tarkoitin sanoessani, että pian tulee mies, joka on paljon minua suurempi ja joka on ollut kauan ennen minua. ");
INSERT INTO fin_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ensin en tuntenut häntä, vaikka olen täällä kastamassa vedellä voidakseni osoittaa Israelin kansalle, kuka hän on.» ");
INSERT INTO fin_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Sitten Johannes kertoi, miten hän oli nähnyt Pyhän Hengen laskeutuvan taivaasta kuin kyyhkynen Jeesuksen päälle. ");
INSERT INTO fin_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","»En tiennyt, että se oli tämä mies», Johannes toisti, »mutta lähettäessään minut kastamaan Jumala ilmoitti: ’Kun näet Pyhän Hengen laskeutuvan ja jäävän jonkun päälle, tiedät, että siinä on henkilö, jota etsit: hän kastaa Pyhällä Hengellä.’ ");
INSERT INTO fin_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Tämän miehen päälle näin Pyhän Hengen laskeutuvan, ja sen vuoksi voin varmasti vakuuttaa, että hän on Jumalan Poika.» ");
INSERT INTO fin_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Seuraavana päivänä, kun Johannes seisoi keskustelemassa kahden oppilaansa kanssa, Jeesus kulki heidän ohitseen. ");
INSERT INTO fin_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Johannes katsoi häntä pitkään ja sanoi sitten: »Siinä on Jumalan uhrikaritsa.» ");
INSERT INTO fin_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Johanneksen oppilaat kääntyivät katsomaan ja lähtivät Jeesuksen perään. ");
INSERT INTO fin_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jeesus vilkaisi taakseen ja näki heidät. »Mitä te haluatte?» hän kysyi. »Tahtoisimme tietää missä sinä asut», he vastasivat. ");
INSERT INTO fin_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","»Tulkaa mukaan», Jeesus sanoi. He lähtivät hänen majapaikkaansa ja viettivät hänen luonaan sen iltapäivän. ");
INSERT INTO fin_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Toinen näistä oppilaista oli Andreas, Simon Pietarin veli. ");
INSERT INTO fin_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Seuraavana aamuna Andreas lähti jo varhain etsimään veljeään Pietaria ja kertoi tälle: »Me olemme löytäneet Messiaan!» ");
INSERT INTO fin_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andreas vei sitten Pietarin Jeesuksen luo. Jeesus katsoi hetken tarkasti Pietaria ja sanoi sitten: »Sinä olet Simon, Johanneksen poika, mutta tästä lähtien sinua kutsutaan Pietariksi, kallioksi.» ");
INSERT INTO fin_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Seuraavana päivänä Jeesus päätti lähteä Galileaan. Siellä hän näki Filippuksen ja sanoi tälle: »Tule minun mukaani.» ");
INSERT INTO fin_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filippus oli Beetsaidasta, samalta seudulta kuin Andreas ja Pietari. ");
INSERT INTO fin_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filippus lähti nyt etsimään ystäväänsä Natanaelia ja kertoi tälle: »Me olemme löytäneet Messiaan, sen, josta Mooses ja profeetat puhuivat! Hänen nimensä on Jeesus, ja hän on Joosefin poika Nasaretista.» ");
INSERT INTO fin_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","»Nasaretista!» Natanael huudahti. »Voiko sieltä tulla mitään hyvää?» »Lähde itse katsomaan», Filippus sanoi. ");
INSERT INTO fin_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nähdessään Natanaelin tulevan Jeesus sanoi: »Siinä on rehellinen mies – oikea israelilainen.» ");
INSERT INTO fin_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","»Mistä tiedät millainen minä olen?» Natanael ihmetteli. Jeesus vastasi: »Näin sinut viikunapuun alla ennen kuin Filippus tapasi sinut.» ");
INSERT INTO fin_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","»Opettaja, sinä olet Jumalan Poika – Israelin kuningas!» Natanael sanoi. ");
INSERT INTO fin_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jeesus kysyi häneltä: »Uskotko niin vain siksi, että sanoin nähneeni sinut viikunapuun alla? Saat paljon parempiakin todisteita. ");
INSERT INTO fin_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Saat jopa nähdä taivaan avoimena ja Jumalan enkelien tulevan luokseni – sillä minä olen taivaasta kotoisin.» ");
INSERT INTO fin_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Pari päivää myöhemmin Jeesuksen äiti oli vieraana eräissä häissä Kaanan kylässä Galileassa. ");
INSERT INTO fin_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Myös Jeesus ja hänen oppilaansa oli kutsuttu häihin. ");
INSERT INTO fin_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Kesken kaiken loppui viini, ja Jeesuksen äiti tuli kertomaan Jeesukselle, mihin pulaan oli jouduttu. ");
INSERT INTO fin_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","»En voi nyt auttaa sinua», Jeesus sanoi. »Vielä ei ole tullut minun aikani tehdä ihmeitä.» ");
INSERT INTO fin_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jeesuksen äiti sanoi kuitenkin palvelijoille: »Tehkää mitä ikinä hän käskee.» ");
INSERT INTO fin_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Siellä oli kuusi kivistä vesiastiaa, joita käytettiin juutalaisten uskonnollisten puhdistusmenojen yhteydessä, noin sadan litran vetoisia. ");
INSERT INTO fin_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jeesus käski palvelijoiden täyttää ne reunoja myöten vedellä. ");
INSERT INTO fin_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kun se oli tehty, hän sanoi: »Ottakaa siitä ja viekää pitojen järjestäjälle.» ");
INSERT INTO fin_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Kun tämä oli maistanut vettä, joka oli muuttunut viiniksi, hän kutsui sulhasen luokseen kysyäkseen, mistä viini oli peräisin. (Palvelijat tosin tiesivät sen.) ");
INSERT INTO fin_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","»Tämähän on hyvää viiniä!» hän sanoi. »Taidat tehdä päinvastoin kuin yleensä on tapana: tavallisesti isäntä tarjoaa ensin parhaan viininsä, ja sitten kun ihmiset ovat päihtyneet, hän tuo esiin halvemman viinin. Mutta sinä säästit parhaan viimeiseksi.» ");
INSERT INTO fin_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tämä Galilean Kaanassa tapahtunut ihme oli ensimmäinen julkinen osoitus Jeesuksen jumalallisesta voimasta. Hänen oppilaansa uskoivat hänen todella olevan Messias. ");
INSERT INTO fin_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Häiden jälkeen Jeesus lähti muutamaksi päiväksi Kapernaumiin äitinsä, veljiensä ja oppilaidensa kanssa. ");
INSERT INTO fin_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Sitten tuli juutalaisten pääsiäisjuhlan aika, ja Jeesus meni Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Temppelialueella hän näki kauppiaat myymässä karjaa, lampaita ja kyyhkysiä uhrieläimiksi ja rahanvaihtajat istumassa pöytiensä takana. ");
INSERT INTO fin_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jeesus teki nuoranpätkistä ruoskan ja ajoi ulos kauppiaat, lampaat ja härät ja kaatoi rahanvaihtajien pöydät, niin että kolikot vierivät pitkin kiveystä. ");
INSERT INTO fin_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sitten hän meni kyyhkysiä myyvien miesten luo ja sanoi heille: »Viekää nämä pois täältä! Älkää tehkö minun Isäni talosta markkinatoria.» ");
INSERT INTO fin_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Oppilaat muistivat silloin Vanhan testamentin ennustuksen: »Huoli sinun temppelistäsi kuluttaa minua.» ");
INSERT INTO fin_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","»Mikä oikeus sinulla on ajaa heidät ulos?» juutalaisten johtomiehet kysyivät tiukasti. »Jos olet saanut valtuutesi Jumalalta, sinun on todistettava se tekemällä jokin ihme.» ");
INSERT INTO fin_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","»Kyllä minä teen teille ihmeen», Jeesus vastasi. »Hävittäkää maan tasalle tämä temppeli, niin minä rakennan sen uudelleen kolmessa päivässä.» ");
INSERT INTO fin_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","»Mitä!» miehet huusivat. »Tämän temppelin rakentaminen kesti neljäkymmentäkuusi vuotta, ja sinäkö pystyisit tekemään saman kolmessa päivässä!» ");
INSERT INTO fin_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Puhuessaan »tästä temppelistä» Jeesus kuitenkin tarkoitti omaa ruumistaan. ");
INSERT INTO fin_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kun hän sitten oli noussut kuolleista, hänen oppilaansa muistivat hänen sanansa ja tajusivat, että ne raamatunkohdat, joihin Jeesus oli viitannut, puhuivatkin hänestä itsestään ja olivat kaikki toteutuneet. ");
INSERT INTO fin_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ihmeet, jotka Jeesus teki Jerusalemissa pääsiäisjuhlan aikana, saivat monet vakuuttuneiksi siitä, että hän todella oli Messias. ");
INSERT INTO fin_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mutta Jeesus ei uskoutunut heille, sillä hän tunsi ihmiset perin juurin. ");
INSERT INTO fin_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kenenkään ei tarvinnut selittää hänelle, miten epävakaa ihmisen mieli on. ");
INSERT INTO fin_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Kerran iltapimeällä tuli eräs juutalainen hallitusmies nimeltä Nikodeemus, fariseusten puolueen jäsen, puhumaan Jeesuksen kanssa. »Opettaja», hän aloitti, »me kaikki tiedämme, että itse Jumala on lähettänyt sinut meitä opettamaan. Tekemäsi ihmeet ovat siitä todistuksena.» ");
INSERT INTO fin_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jeesus vastasi: »Totta totisesti: sinun on mahdotonta päästä Jumalan valtakuntaan, jollet synny uudestaan.» ");
INSERT INTO fin_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","»Synny uudestaan!» Nikodeemus huudahti. »Mitä se tarkoittaa? Miten ihminen voi vanhana syntyä uudestaan? Eihän hän voi mennä takaisin äitinsä kohtuun ja syntyä toista kertaa.» ");
INSERT INTO fin_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jeesus vastasi: »Kuuntele tarkasti: jollei ihminen synny vedestä ja Hengestä, hän ei pääse Jumalan valtakuntaan. ");
INSERT INTO fin_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ihmisestä syntyy ihminen tähän maailmaan, mutta vain Pyhä Henki antaa uuden elämän taivaasta. ");
INSERT INTO fin_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Älä siis ihmettele, kun sanon, että sinun on synnyttävä uudestaan hengellisesti. ");
INSERT INTO fin_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pyhä Henki on kuin tuuli: voit kuulla sen huminan, mutta et pysty sanomaan mistä se tulee tai minne se on menossa. Samoin ihminenkään ei pysty arvioimaan, kenelle Henki seuraavaksi lahjoittaa taivaasta elämän.» ");
INSERT INTO fin_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","»Mitä tarkoitat?» Nikodeemus kysyi. ");
INSERT INTO fin_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jeesus vastasi: »Olet arvostettu juutalaisten opettaja etkä kuitenkaan ymmärrä näitä asioita! ");
INSERT INTO fin_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Minä puhun sinulle nyt sellaisesta, minkä tunnen ja minkä olen nähnyt, etkä sinä kuitenkaan usko minua. ");
INSERT INTO fin_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Mutta jos et usko, kun puhun tämän maailman asioista, kuinka voisit uskoa, jos kertoisin sinulle mitä taivaassa tapahtuu? ");
INSERT INTO fin_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Minä yksin olen tullut maailmaan taivaasta ja menen sinne takaisin. ");
INSERT INTO fin_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Samalla tavoin kuin Mooses autiomaassa nosti pronssista tehdyn käärmeen tankoon, samoin minutkin naulitaan ristille – ");
INSERT INTO fin_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","siksi, että jokainen, joka uskoo minuun, saisi ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Jumala rakasti maailmaa niin paljon, että antoi ainoan Poikansa sitä varten, ettei kukaan, joka uskoo häneen, joutuisi perikatoon vaan saisi ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jumala ei lähettänyt Poikaansa maailmaan tuomitsemaan sitä vaan pelastamaan sen. ");
INSERT INTO fin_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Niitä ei tuomita, jotka uskovat. Muut sanelevat oman kadotustuomionsa kieltäytyessään hyväksymästä Jumalan ainoaa Poikaa pelastajakseen. ");
INSERT INTO fin_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Heidän tuomionsa perustuu siihen, että maailmaan loistaa Jumalan valo, mutta pimeys miellyttää heitä enemmän, sillä heidän tekonsa ovat pahat. ");
INSERT INTO fin_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","He pysyvät kaukana valosta, koska pelkäävät, että se paljastaisi heidän syntinsä ja heitä rangaistaisiin. ");
INSERT INTO fin_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mutta ne, jotka tottelevat Jumalaa, tulevat mielellään valoon, että muutkin näkisivät, miten Jumalan tahto voi toteutua ihmisen elämässä.» ");
INSERT INTO fin_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Myöhemmin Jeesus ja hänen oppilaansa lähtivät Jerusalemista, mutta viipyivät jonkin aikaa muualla Juudeassa, jossa he kastoivat ihmisiä. ");
INSERT INTO fin_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","Johannes Kastaja ei vielä silloin ollut joutunut vankilaan. Hän kastoi Ainonissa lähellä Salimia, koska siellä oli paljon vettä. ");
INSERT INTO fin_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Johanneksen oppilaiden ja juutalaisten kesken syntyi väittelyä juutalaisten puhdistusmenoista ja kasteesta. ");
INSERT INTO fin_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Sen tähden Johanneksen oppilaat tulivat sanomaan Johannekselle: »Mies, jonka näimme Jordanin toisella puolella – se, jonka sanoit olevan Messias – hänkin kastaa, ja kaikki menevät sinne eivätkä tule enää meidän luoksemme.» ");
INSERT INTO fin_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johannes vastasi: »Jumala antaa jokaiselle ihmiselle oman tehtävän. Minun tehtäväni on valmistaa tietä tuolle miehelle, että kaikki menisivät hänen luokseen. ");
INSERT INTO fin_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Tiedätte itse, kuinka selvästi olen sanonut, etten ole Messias. Olen täällä valmistamassa hänelle tietä – siinä kaikki. ");
INSERT INTO fin_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ihmisten huomio kiintyy luonnollisesti häneen – morsian kiirehtii tietenkin sinne, missä sulhanen on. Sulhasen ystävät ovat iloisia yhdessä hänen kanssaan. Minä olen sulhasen ystävä, ja olen riemuissani hänen menestyksestään. ");
INSERT INTO fin_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jeesuksen kuuluukin tulla yhä suuremmaksi ja minun yhä pienemmäksi. ");
INSERT INTO fin_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Hän on taivaasta ja hallitsee kaikkea. Minä olen maasta ja puhun sen mukaan. ");
INSERT INTO fin_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Jeesus puhuu siitä, mitä hän on nähnyt ja kuullut, mutta vain harvat uskovat häntä. ");
INSERT INTO fin_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ne, jotka uskovat, huomaavat, että Jumala on totuus. ");
INSERT INTO fin_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jumala on tämän miehen lähettänyt, ja hän puhuu Jumalan sanoja, sillä Jumalan Henki täyttää hänet. ");
INSERT INTO fin_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Isä rakastaa Poikaansa ja on antanut kaiken hänen käsiinsä. ");
INSERT INTO fin_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kaikilla, jotka uskovat Jumalan Poikaan, on ikuinen elämä. Ne, jotka eivät usko häneen eivätkä tee hänen tahtonsa mukaan, eivät saa nähdä taivasta, vaan jäävät Jumalan tuomittaviksi.» ");
INSERT INTO fin_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Jeesus sai tietää fariseusten kuulleen, että hän kastoi suurempia ihmisjoukkoja kuin Johannes – vaikka Jeesus itse ei kastanut, vaan hänen oppilaansa – ja että hänen oppilaihinsa liittyi enemmän ihmisiä kuin Johanneksen oppilaihin. ");
INSERT INTO fin_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Sen vuoksi hän lähti Juudeasta takaisin Galileaan. ");
INSERT INTO fin_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Matkalla hänen oli kuljettava Samarian halki. ");
INSERT INTO fin_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Puolen päivän aikaan hän tuli lähelle Sykarin kylää. Siellä on Jaakobin kaivo maalla, jonka Jaakob oli antanut pojalleen Joosefille. Pitkä kävelymatka kuumassa auringossa oli uuvuttanut Jeesuksen, ja hän istui kaivolle lepäämään. ");
INSERT INTO fin_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Pian tuli eräs samarialainen nainen hakemaan vettä, ja Jeesus pyysi häneltä juotavaa. ");
INSERT INTO fin_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jeesus oli sillä hetkellä yksin, sillä hänen oppilaansa olivat lähteneet kylään ostamaan ruokaa. ");
INSERT INTO fin_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nainen hämmästyi. »Olet juutalainen! Kuinka sinä pyydät juotavaa minulta – samarialaiselta naiselta?» hän sanoi. Juutalaiset eivät näet yleensä suostuneet edes puhumaan samarialaisten kanssa. ");
INSERT INTO fin_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jeesus vastasi: »Jos tietäisit, minkä ihmeellisen lahjan Jumala tahtoo sinulle antaa ja kuka minä olen, sinä pyytäisit ja saisit minulta elävää vettä.» ");
INSERT INTO fin_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","»Mutta eihän sinulla ole edes köyttä eikä astiaa», nainen sanoi, »ja tämä on syvä kaivo. Mistä sinä sitä elävää vettä saisit? ");
INSERT INTO fin_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Oletko muka suurempi kuin esi-isämme Jaakob? Kuinka sinulla voisi olla parempaa vettä kuin tämä, joka kelpasi Jaakobille, hänen pojilleen ja karjalleen?» ");
INSERT INTO fin_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","»Tämä vie janon vain hetkeksi», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","»Mutta siitä vedestä, jota minä ihmisille annan, tulee heidän sisimpäänsä ehtymätön lähde, josta pulppuaa ikuinen elämä», hän jatkoi. ");
INSERT INTO fin_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","»Anna minulle sellaista vettä», nainen sanoi. »Silloin minun ei enää tule jano eikä minun tarvitse tehdä joka päivä tätä pitkää vedenhakumatkaa.» ");
INSERT INTO fin_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","»Hae miehesi tänne», Jeesus kehotti. ");
INSERT INTO fin_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","»En minä ole naimisissa», nainen vastasi. »Et todellakaan», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","»Sinullahan on ollut viisi miestä, eikä sekään, jonka kanssa nyt asut, ole aviomiehesi.» ");
INSERT INTO fin_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","»Sinun täytyy olla profeetta, kun sen tiedät», nainen vastasi. ");
INSERT INTO fin_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","»Mutta sano minulle, miksi te juutalaiset väitätte, että Jerusalem on ainoa oikea jumalanpalveluspaikka. Meidän samarialaisten mielestä se on täällä Garissimin vuorella, jossa esi-isämme pitivät jumalanpalveluksia.» ");
INSERT INTO fin_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jeesus vastasi: »Nyt on tulossa aika, jolloin ei enää väitellä siitä, onko Isää rukoiltava täällä vai Jerusalemissa. ");
INSERT INTO fin_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","23-24","Tärkeämpää kuin missä Jumalaa palvotaan ja rukoillaan, on miten se tehdään. Jumala, Isämme, on Henki, ja hän tahtoo, että rukoillessamme annamme Pyhän Hengen ohjata meitä totuuteen. Te palvelette Jumalaa, jota ette tunne. Minun oppilaani palvelevat Jumalaa, jonka tuntevat. Maailman pelastus tulee juutalaisten keskuudesta.» ");
INSERT INTO fin_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nainen sanoi: »Sen ainakin tiedän, että Messias tulee – hän, jota kutsutaan Kristukseksi – ja kun hän tulee, hän selittää meille kaiken.» ");
INSERT INTO fin_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Silloin Jeesus sanoi hänelle: »Minä olen Messias!» ");
INSERT INTO fin_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jeesuksen oppilaat tulivat takaisin. He hämmästyivät löytäessään Jeesuksen puhumasta naisen kanssa, mutta kukaan heistä ei kysynyt, miksi hän niin teki tai mistä he olivat puhuneet. ");
INSERT INTO fin_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nainen jätti silloin vesiastiansa kaivon viereen, meni kylään ja sanoi siellä kaikille: ");
INSERT INTO fin_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","»Tulkaa katsomaan miestä, joka tietää minusta kaiken! Voisiko hän olla Messias?» ");
INSERT INTO fin_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kyläläisiä lähti suuri joukko katsomaan häntä. ");
INSERT INTO fin_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Sillä välin Jeesuksen oppilaat kehottivat häntä syömään. ");
INSERT INTO fin_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","»Minun ei ole nälkä», hän sanoi. »Minulla on sellaista ruokaa, mistä te ette tiedä mitään.» ");
INSERT INTO fin_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","»Kukahan sitä on tuonut?» oppilaat kyselivät toinen toisiltaan. ");
INSERT INTO fin_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Silloin Jeesus selitti: »Minun ruokani on sitä, että teen, mitä lähettäjäni, Jumala, tahtoo. ");
INSERT INTO fin_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Kuvitteletteko te, että korjuuaika alkaa vasta sitten, kun kesä neljän kuukauden kuluttua on ohi? Katsokaa ympärillenne! Leikkuutyö voi alkaa, sillä vilja on kypsynyt korjattavaksi. ");
INSERT INTO fin_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Sadonkorjaajan palkkana on ilo saada koota satoa ikuiseen elämään. Kylväjän ja leikkaajan ilo on yhteinen. ");
INSERT INTO fin_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Usein toinen kylvää ja joku toinen korjaa sadon. ");
INSERT INTO fin_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Minä olen lähettänyt teidät leikkaamaan viljaa sieltä, minne ette ole kylväneet; toiset tekevät työn, ja te saatte korjata sadon.» ");
INSERT INTO fin_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Monet tuon samarialaiskylän asukkaista uskoivat Jeesuksen olevan Messias, koska nainen oli sanonut: »Hän tiesi minusta kaiken!» ");
INSERT INTO fin_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ihmiset, jotka olivat tulleet kaivolle Jeesusta katsomaan, pyysivät häntä jäämään heidän kyläänsä. Hän jäikin sinne kahdeksi päiväksi. ");
INSERT INTO fin_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Monet uskoivat häneen kuultuaan hänen puhuvan. ");
INSERT INTO fin_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","He sanoivat silloin naiselle: »Me uskomme nyt, kun itse kuulimme hänen puhuvan – emme enää vain sen perusteella mitä sinä kerroit. Hän on todella maailman pelastaja, Messias.» ");
INSERT INTO fin_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Niiden kahden päivän kuluttua Jeesus meni Galileaan. ");
INSERT INTO fin_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Hänellä oli tapana sanoa: »Muualla profeettaa kunnioitetaan, mutta ei hänen omassa maassaan.» ");
INSERT INTO fin_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nyt galilealaiset ottivat hänet vastaan avosylin, sillä he olivat olleet Jerusalemissa pääsiäisjuhlan aikana ja nähneet hänen tekevän joitakin ihmeitä. ");
INSERT INTO fin_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","47","Ollessaan matkalla Galilean halki Jeesus saapui Kaanan kaupunkiin, jossa hän oli muuttanut veden viiniksi. Kun hän oli siellä, eräs kapernaumilainen hallituksen virkamies, jonka poika oli hyvin sairas, kuuli Jeesuksen tulleen Juudeasta ja olevan nyt Galileassa. Mies meni Kaanaan, löysi Jeesuksen ja pyysi hartaasti tätä tulemaan Kapernaumiin parantamaan hänen poikansa, joka oli kuolemaisillaan. ");
INSERT INTO fin_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jeesus kysyi: »Eikö kukaan teistä usko minuun, ellen tee yhä uusia ihmeitä?» ");
INSERT INTO fin_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Virkamies hätääntyi: »Voi tule, ennen kuin lapseni kuolee!» ");
INSERT INTO fin_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jeesus sanoi silloin miehelle: »Palaa kotiin. Poikasi on parantunut.» Mies uskoi Jeesusta ja lähti kotiinsa. ");
INSERT INTO fin_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kun mies oli vielä matkalla, muutamia hänen palvelijoitaan tuli häntä vastaan. Heiltä hän kuuli, että kaikki oli hyvin: hänen poikansa oli terve! ");
INSERT INTO fin_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Mies kysyi, milloin poika oli alkanut toipua, ja hänelle kerrottiin: »Eilen kello yhden maissa päivällä kuume yhtäkkiä laski.» ");
INSERT INTO fin_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Silloin isä tajusi, että juuri samaan aikaan Jeesus oli sanonut hänelle: »Poikasi on parantunut.» Hän ja koko hänen talonsa väki uskoivat, että Jeesus oli Messias. ");
INSERT INTO fin_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tämä oli toinen ihme, jonka Jeesus Juudeasta lähtönsä jälkeen teki Galileassa. ");
INSERT INTO fin_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Myöhemmin Jeesus palasi Jerusalemiin eräille juutalaisten juhlille. ");
INSERT INTO fin_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kaupungissa oli lähellä Lammasporttia Betesdan lammikko, jota ympäröi viisi pylväskäytävää. ");
INSERT INTO fin_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Niissä makasi joukoittain halvaantuneita ja sokeita ihmisiä. He odottivat veden kuohuvan tietyllä tavalla, sillä uskottiin, että enkeli kävi liikuttamassa sitä ja ensimmäinen ihminen, joka sen jälkeen astuisi veteen, parantuisi. ");
INSERT INTO fin_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Yksi siellä makaavista miehistä oli ollut liikuntakyvytön 38 vuotta. ");
INSERT INTO fin_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jeesus näki miehen. Hän tiesi, kuinka kauan tämä oli ollut sairas ja kysyi: »Haluatko tulla terveeksi?» ");
INSERT INTO fin_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","»Ei minulla ole mitään mahdollisuutta», mies sanoi, »sillä en tunne ketään, joka auttaisi minut veteen silloin kun se alkaa kuohua. Kun yritän päästä sinne, joku muu ehtii aina edelleni.» ");
INSERT INTO fin_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jeesus sanoi hänelle: »Nouse seisomaan, kääri makuumattosi kokoon ja mene kotiin.» ");
INSERT INTO fin_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mies parani silmänräpäyksessä! Hän kääri maton kokoon ja käveli kaikkien nähden. Mutta silloin oli juutalaisten pyhäpäivä, sapatti. ");
INSERT INTO fin_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Sen vuoksi kansan johtomiehet sanoivat parannetulle: »Sapattina ei saa tehdä työtä – sinunkaan ei ole lupa kantaa mattoasi.» ");
INSERT INTO fin_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","»Hän, joka minut paransi, käski minun ottaa sen», hän vastasi. ");
INSERT INTO fin_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","»Kuka niin uskalsi sanoa?» he tiukkasivat. ");
INSERT INTO fin_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mies ei tiennyt, ja Jeesus oli jo kadonnut ihmisjoukkoon. ");
INSERT INTO fin_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Myöhemmin Jeesus näki parantamansa miehen temppelissä ja sanoi hänelle: »Sinä olet nyt terve. Älä enää tee syntiä, ettei sinulle tapahdu mitään pahempaa.» ");
INSERT INTO fin_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Silloin mies lähti etsimään juutalaisten johtomiehiä ja sanoi heille, että hänen parantajansa nimi oli Jeesus. ");
INSERT INTO fin_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Sen vuoksi Jeesusta alettiin syyttää sapatin rikkomisesta. ");
INSERT INTO fin_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Siihen hän vastasi: »Minun Isäni tekee aina hyvää, ja minä noudatan hänen esimerkkiään.» ");
INSERT INTO fin_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Silloin juutalaisten johtomiehet halusivat surmata hänet; eihän hän ainoastaan rikkonut heidän sapattimääräyksiään, vaan myös puhui Jumalasta Isänään tehden siten itsensä Jumalan vertaiseksi. ");
INSERT INTO fin_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jeesus sanoi heille: »Ei Poika voi tehdä mitään yksinään. Hän tekee vain sitä, mitä näkee Isän tekevän, ja samalla tavalla kuin Isä. ");
INSERT INTO fin_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Isähän rakastaa Poikaansa ja näyttää hänelle kaiken, mitä itse tekee – vieläkin suurempia ihmeitä kuin tämän miehen parantaminen. ");
INSERT INTO fin_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Samoin tekee Poika: hän jopa herättää kuolleista ne, jotka haluaa. ");
INSERT INTO fin_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Isä on jättänyt myös tuomiovallan Pojalleen, ");
INSERT INTO fin_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","jotta kaikki kunnioittaisivat Poikaa samalla tavoin kuin Isää. Mutta jos ette halua kunnioittaa Jumalan Poikaa, jonka Jumala on lähettänyt teidän luoksenne, silloin ette kunnioita Isääkään. ");
INSERT INTO fin_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Todellakin: jokaisella, joka kuulee minun sanani ja uskoo Jumalaan, on ikuinen elämä, eikä hän joudu tuomittavaksi synneistään, vaan on jo siirtynyt kuolemasta elämään. ");
INSERT INTO fin_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Totisesti se aika vielä tulee – oikeastaan se on jo tullutkin – jolloin Jumalasta erossa elävät ihmiset kuulevat minun ääneni. Ne heistä, jotka haluavat kuunnella Jumalan Pojan ääntä, saavat elää. ");
INSERT INTO fin_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Isällä on elämä itsessään, samoin Pojalla, sillä Isä on sen hänelle antanut. ");
INSERT INTO fin_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pojalla on myös valta tuomita ihmiskunta, onhan hän Messias. ");
INSERT INTO fin_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ei siinä ole mitään ihmettelemistä. Kerran tulee sekin aika, jolloin kaikki kuolleet kuulevat hautoihinsa Jumalan Pojan äänen ");
INSERT INTO fin_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ja nousevat kuolleista – ne, jotka ovat tehneet hyvää, ikuiseen elämään, ja ne, jotka ovat jatkaneet pahan palvelemista, kadotustuomioon. ");
INSERT INTO fin_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Minä en tuomitse ketään ilman Isää. Langetan tuomioni sen mukaan, mitä Jumala, joka on minut lähettänyt, tahtoo. Siksi tuomio on oikea. ");
INSERT INTO fin_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Teidän ei tietysti tarvitse uskoa minuun sen tähden, että puhun itse itsestäni. ");
INSERT INTO fin_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mutta uskokaa Johannes Kastajaa! ");
INSERT INTO fin_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Olettehan te käyneet häntä kuuntelemassa – mitä hän puhuu minusta, on totta. ");
INSERT INTO fin_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ratkaisevaa ei kuitenkaan ole se, mitä ihminen sanoo. Muistutin Johanneksesta vain sen tähden, että uskoisitte minuun ja pelastuisitte. ");
INSERT INTO fin_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johannes oli teille kuin valo, jota hetken ihailitte. ");
INSERT INTO fin_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Minulla on kuitenkin vielä Johannesta suurempi todistaja: ihmeet, joita olen tehnyt. Isä on antanut minulle vallan tehdä niitä – ne osoittavat, että hän on minut lähettänyt. ");
INSERT INTO fin_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Isä on myös itse todistanut minusta, vaikka te ette olekaan häntä nähneet eikä hän ole suoraan puhunut teille. ");
INSERT INTO fin_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Mutta miten te voisitte ottaa vastaan hänen sanomansa – ettehän usko minuakaan. ");
INSERT INTO fin_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Te tutkitte Vanhaa testamenttia, koska siinä on teidän mielestänne ikuinen elämä. Se puhuu juuri minusta! ");
INSERT INTO fin_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mutta minun luokseni te ette halua tulla, että voisin antaa teille ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","En minä teidän suosiotanne etsi. ");
INSERT INTO fin_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Tunnen teidät ja tiedän hyvin, ettei teissä ole Jumalan rakkautta. ");
INSERT INTO fin_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Tulin luoksenne Isäni nimissä, ettekä te ottaneet minua vastaan. Kuitenkin otatte avosylin vastaan sellaisia, joita Jumala ei ole lähettänyt, vaan jotka edustavat vain itseään. ");
INSERT INTO fin_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Onko siis ihme, ettette voi uskoa? Tehän etsitte inhimillistä vaikutusvaltaa, mutta vähän välitätte siitä kunniasta, joka tulee Jumalalta. ");
INSERT INTO fin_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Isän edessä en kuitenkaan minä ole syyttäjänne vaan Mooses, sama Mooses, jonka lakeja noudattamalla te toivotte pelastuvanne. ");
INSERT INTO fin_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Mutta ettehän te usko Moosesta: jos te häntä uskoisitte, uskoisitte myös minua, sillä minusta Mooses kirjoitti. ");
INSERT INTO fin_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ja kun ette usko Mooseksen kirjoituksia, ei ole ihme, ettette usko minuakaan.» ");
INSERT INTO fin_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tämän jälkeen Jeesus meni Galilean- eli Tiberiaanjärven yli. ");
INSERT INTO fin_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","3-4","Suuri ihmisjoukko – useimmat pyhiinvaeltajia ja matkalla Jerusalemin pääsiäisjuhlille – seurasi häntä kaikkialle nähdäkseen, kuinka hän paransi sairaita. Jeesus meni vuorelle ja istui siellä opetuslapset ympärillään. ");
INSERT INTO fin_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Pian hän näki suuren väkijoukon nousevan vuoren rinnettä. Ihmiset etsivät taas häntä. Filippukseen päin kääntyen Jeesus kysyi: »Mistä me ostamme leipää tälle kansanpaljoudelle?» ");
INSERT INTO fin_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Hän tahtoi kysymyksellään vain koetella Filippusta – itse hän tiesi, mitä aikoi tehdä. ");
INSERT INTO fin_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filippus vastasi: »Siihen tarvittaisiin kokonainen omaisuus!» ");
INSERT INTO fin_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Silloin Simon Pietarin veli Andreas puuttui puheeseen: ");
INSERT INTO fin_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","»Täällä on poika, jolla on viisi ohraleipää ja pari kalaa. Mutta mitä niistä kannattaa puhuakaan, kun on tällainen joukko ruokittavana.» ");
INSERT INTO fin_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","»Pyytäkää kaikkia istumaan», Jeesus sanoi. Ja kaikki – yksin miehiä arvioitiin olevan viisituhatta – istuivat ruohon peittämille rinteille. ");
INSERT INTO fin_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jeesus otti leivät, kiitti niistä Jumalaa ja jakoi ne ihmisille. Samoin hän jakoi kalat. ");
INSERT INTO fin_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kaikki söivät kyllikseen. »Kerätkää nyt ruuantähteet», Jeesus kehotti oppilaitaan, »niin ettei mitään jää hukkaan.» ");
INSERT INTO fin_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Leivänpalasia kertyi vielä kaksitoista korillista. ");
INSERT INTO fin_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kun ihmiset tajusivat, mikä valtava ihme oli tapahtunut, he sanoivat innostuneina: »Hän on varmasti se profeetta, jonka tuloa olemme odottaneet.» ");
INSERT INTO fin_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jeesus näki, että kansa oli valmis kruunaamaan hänet kuninkaaksi – vaikka väkisin. Sen vuoksi hän lähti yksinään vielä ylemmäs vuorelle. ");
INSERT INTO fin_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Illalla Jeesuksen oppilaat menivät alas rantaan odottamaan häntä. ");
INSERT INTO fin_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mutta kun sitten tuli pimeä, eikä Jeesus ollut vieläkään palannut, he nousivat veneeseen ja suuntasivat sen keulan kohti järven vastakkaista rantaa ja Kapernaumia. ");
INSERT INTO fin_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Matkalla alkoi puhaltaa navakka tuuli, ja vaahtopäät laineet löivät veneen laidan yli. ");
INSERT INTO fin_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Soudettuaan viitisen kilometriä miehet yhtäkkiä näkivät Jeesuksen kävelevän järvellä heitä kohti. He pelästyivät suunnattomasti. ");
INSERT INTO fin_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jeesus huusi heille: »Minä se vain olen, älkää pelästykö!» ");
INSERT INTO fin_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Silloin he pyysivät häntä tulemaan veneeseen, mutta samassa vene olikin jo perillä. ");
INSERT INTO fin_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Vielä seuraavana aamunakin ihmisiä oli koolla sillä paikalla, missä Jeesus oli antanut heille ruokaa. Tiedettiin näet, että Jeesus ja hänen oppilaansa olivat ensin yhdessä saapuneet sinne, ja että vain oppilaat olivat edellisenä iltana astuneet veneeseen. Muutamia Tiberiaasta tulleita veneitä oli lähistöllä. ");
INSERT INTO fin_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kun ihmiset olivat nähneet, ettei Jeesus eivätkä hänen oppilaansa olleet rannalla, he lähtivät veneillä Kapernaumiin etsimään Jeesusta. ");
INSERT INTO fin_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Päästyään perille ja löydettyään hänet ja sanoivat: »Miten sinä tänne tulit?» ");
INSERT INTO fin_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jeesus vastasi: »Totuus on, että te juoksette perässäni siksi, että saitte minulta leipää, ettekä siksi, että uskotte minuun. ");
INSERT INTO fin_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Älkää ajatelko pelkästään kaikkea katoavaa – ruokaa ja muuta sellaista. Etsikää sen sijaan ikuista elämää. Minä, Ihmisen Poika, voin sen teille antaa. Juuri sitä varten Isä Jumala on minut taivaasta tänne lähettänyt.» ");
INSERT INTO fin_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kansanjoukosta kysyttiin: »Mitä meidän sitten pitäisi tehdä, että Jumala olisi meihin tyytyväinen?» ");
INSERT INTO fin_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jeesus sanoi: »Jumalan tahto on, että te uskoisitte häneen, jonka Jumala on lähettänyt.» ");
INSERT INTO fin_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ihmiset vastasivat: »Sinun on tehtävä enemmän ihmeitä meidän nähtemme, jos haluat meidän uskovan, että olet Messias. ");
INSERT INTO fin_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Anna meille joka päivä ilmaista leipää – saivathan esi-isämmekin sitä autiomaavaelluksensa aikana. Raamatussa sanotaan: ’Mooses antoi heille leipää taivaasta.’» ");
INSERT INTO fin_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jeesus sanoi: »Ei Mooses sitä heille antanut, vaan minun Isäni. ");
INSERT INTO fin_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Hän tarjoaa teille todellista taivaan leipää, joka tuo maailmalle elämän.» ");
INSERT INTO fin_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","»Anna meille aina sitä leipää», kuulijat sanoivat. ");
INSERT INTO fin_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jeesus vastasi: »Minä olen elämän leipä. Joka tulee minun luokseni, löytää vastauksen perimmäisiin kysymyksiinsä. ");
INSERT INTO fin_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mutta te ette usko minuun, vaikka olette minut nähneet. ");
INSERT INTO fin_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kaikista niistä, joille Isä on antanut uskon minuun, tulee minun omiani. Minä en koskaan aja pois ketään, joka luokseni tulee. ");
INSERT INTO fin_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Olen tullut tänne maailmaan tekemään kaiken mitä lähettäjäni, Jumala, tahtoo – en sitä mitä itse tahdon. ");
INSERT INTO fin_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jumala tahtoo, etten hukkaa ainuttakaan niistä, jotka hän on minulle antanut, vaan viimeisenä päivänä herätän heidät kuolleista ikuiseen elämään. ");
INSERT INTO fin_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Isäni haluaa, että jokainen, joka uskoo minun olevan hänen Poikansa, saa ikuisen elämän, ja siksi minä herätän sen ihmisen kuolleista viimeisenä päivänä.» ");
INSERT INTO fin_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Juutalaisia ärsytti, että hän väitti olevansa leipä, jonka Jumala on antanut taivaasta. ");
INSERT INTO fin_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","»Mitä tuo nyt muka on? Eihän hän ole sen kummempi kuin Joosefin poika. Tunnemmehan me hänen vanhempansa. Kuinka hän voi sanoa tulleensa taivaasta?» he kyselivät. ");
INSERT INTO fin_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jeesus vastasi siihen: »Mikä teitä niin kovasti ärsyttää? ");
INSERT INTO fin_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ei kukaan voi tulla minun luokseni, ellei Isä, joka on minut lähettänyt, häntä minun luokseni vedä. Ja hänet minä herätän eloon viimeisenä päivänä. ");
INSERT INTO fin_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Onhan Raamattuun kirjoitettu: ’Jumala opettaa heitä kaikkia.’ Ne, jotka ovat Isältä kuulleet totuuden ja siihen myöntyneet, tulevat minun luokseni. ");
INSERT INTO fin_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Vain minä olen nähnyt Isän, ei kukaan muu. ");
INSERT INTO fin_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ja tämä on totuus: jokaisella, joka uskoo minuun, on jo nyt ikuinen elämä. ");
INSERT INTO fin_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Minä olen elämän leipä. ");
INSERT INTO fin_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Siinä leivässä, jonka teidän esi-isänne autiomaavaelluksen aikana saivat taivaasta, ei ollut todellista elämää, sillä he kaikki kuolivat. ");
INSERT INTO fin_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mutta on myös sellaista taivaan leipää, että jokainen joka sitä syö, saa ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Minä olen se taivaasta annettu leipä, joka tekee eläväksi. Jokainen, joka syö tätä leipää, elää ikuisesti. Tämä leipä on minun ruumiini, joka on annettu ihmiskunnalle, että se pelastuisi.» ");
INSERT INTO fin_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Juutalaiset rupesivat riitelemään keskenään siitä, mitä Jeesus tarkoitti. »Miten tuo mies voisi antaa meille ruumiinsa syötäväksi?» he kyselivät. ");
INSERT INTO fin_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Silloin Jeesus sanoi uudestaan: »Totisesti: jollette syö minun ruumistani ja juo minun vertani, teillä ei ole ikuista elämää. ");
INSERT INTO fin_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mutta sillä, joka syö ruumiini ja juo vereni, on ikuinen elämä. Minä myös herätän hänet kuolleista viimeisenä päivänä. ");
INSERT INTO fin_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Minun ruumiini on ainoa oikea ruoka ja vereni ainoa oikea juoma. ");
INSERT INTO fin_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jokainen, joka syö ruumiini ja juo vereni, pysyy tiiviissä yhteydessä minuun – ja minä häneen. ");
INSERT INTO fin_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Voima, josta minä elän, tulee elävältä Jumalalta. Samalla tavalla ne, jotka nauttivat minun ruumiini ja vereni, saavat elämän minulta. ");
INSERT INTO fin_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","He eivät kuole niin kuin teidän esi-isänne. Minä olen taivaasta. Joka syö tätä leipää, sillä on ikuinen elämä.» ");
INSERT INTO fin_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tämän kaiken Jeesus puhui Kapernaumin synagogassa. ");
INSERT INTO fin_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jeesuksen oppilaatkin sanoivat: »Onhan tuo nyt aivan käsittämätöntä puhetta. Tajuaako joku, mitä hän tarkoittaa?» ");
INSERT INTO fin_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jeesus näki oppilaidensa tyytymättömyyden ja sanoi heille: »Loukkaako tämä teitä? ");
INSERT INTO fin_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mitä te sitten ajattelette, kun näette minun palaavan taivaaseen? ");
INSERT INTO fin_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pyhä Henki yksin antaa ikuisen elämän. Ihmisponnistuksin sitä ei saavuteta. Minun sanani ovat Hengen puhetta: niissä on elämä. ");
INSERT INTO fin_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jotkut teistä eivät kuitenkaan usko minua.» Jeesus tiesi alusta saakka, ketkä eivät uskoneet ja kuka hänet kavaltaisi. ");
INSERT INTO fin_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jeesus lisäsi: »Tätä minä tarkoitin sanoessani, ettei kukaan voi tulla minun luokseni, jollei Isäni häntä vedä.» ");
INSERT INTO fin_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tämän puheen kuultuaan monet hänen oppilaistaan käänsivät hänelle selkänsä. ");
INSERT INTO fin_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Silloin Jeesus kysyi niiltä kahdeltatoista oppilaaltaan: »Lähdettekö tekin pois?» ");
INSERT INTO fin_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Pietari vastasi: »Mestari, kenen luo me menisimme? Vain sinun sanoistasi ihminen saa ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Me uskomme sinua ja tiedämme, että olet Jumalan pyhä Poika.» ");
INSERT INTO fin_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Silloin Jeesus sanoi: »Minä valitsin teidät kaksitoista, ja yksi teistä on saatana.» ");
INSERT INTO fin_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Hän tarkoitti Juudasta, Simon Iskariotin poikaa, joka oli yksi niistä kahdestatoista ja joka myöhemmin kavalsi Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Sen jälkeen Jeesus meni Galileaan, jossa hän kulki kylästä kylään. Hän pysytteli poissa Juudeasta, sillä juutalaisten johtomiehet punoivat siellä juonia hänen surmaamisekseen. ");
INSERT INTO fin_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Yksi juutalaisten suurista juhlista, lehtimajanjuhla, oli tulossa, ");
INSERT INTO fin_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ja Jeesuksen veljet kehottelivat häntä lähtemään Juudeaan juhlille: »Mene vain sinne, niin useammat ihmiset saavat nähdä ihmeitäsi. ");
INSERT INTO fin_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Eihän sinusta koskaan tule kuuluisaa, kun tällä tavalla piileksit. Jos kerran olet niin erinomainen, niin näytä se maailmalle.» ");
INSERT INTO fin_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jeesuksen veljetkään eivät uskoneet häneen. ");
INSERT INTO fin_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jeesus vastasi: »Jumala ei ole tarkoittanut, että menisin sinne nyt. ");
INSERT INTO fin_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Te voitte mennä milloin tahansa – eihän maailma teitä vihaa. Mutta minua se vihaa, koska minä osoitan sille sen syntisyyden. ");
INSERT INTO fin_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Menkää te vain! Minä tulen myöhemmin, kun oikea hetki koittaa.» ");
INSERT INTO fin_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ja Jeesus jäi vielä Galileaan. ");
INSERT INTO fin_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Sen jälkeen kun Jeesuksen veljet jo olivat lähteneet juhlille, hänkin meni sinne kaikessa hiljaisuudessa. ");
INSERT INTO fin_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Juutalaisten johtomiehet etsivät häntä juhlaväen joukosta ja kyselivät, oliko kukaan nähnyt häntä. ");
INSERT INTO fin_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Hänestä kyllä kohistiin. »Ihmeellinen mies», sanoivat toiset. »Huijari hän on!» sanoivat toiset. ");
INSERT INTO fin_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Julkisesti ei kukaan uskaltanut häntä puolustaa peläten johtavien juutalaisten rangaistusta. ");
INSERT INTO fin_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Juhlat olivat puolivälissä, kun Jeesus meni temppeliin ja ryhtyi opettamaan kansaa. ");
INSERT INTO fin_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juutalaisten johtomiehet hämmästyivät kuullessaan, mitä hän puhui. »Kuinka hänellä voi olla näin paljon tietoa Raamatusta, kun hän ei ole käynyt meidän koulujamme?» he ihmettelivät. ");
INSERT INTO fin_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jeesus sanoi siihen: »Minä en esitä omia ajatuksiani, vaan Jumalan, joka minut on lähettänyt. ");
INSERT INTO fin_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jos joku teistä todella päättää tehdä, niin kuin Jumala tahtoo, hän saa aivan varmasti tietää, opetanko minä Jumalan totuutta vai jotain omaani. ");
INSERT INTO fin_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Joka esittää omia ajatuksiaan, toivoo saavansa niistä kiitosta, mutta joka tahtoo tuottaa kunniaa lähettäjälleen, on luotettava ja rehellinen. ");
INSERT INTO fin_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kukaan teistä ei noudata Mooseksen lakia. Miksi sitten syytätte minua sen rikkomisesta? Miksi haluatte tappaa minut sen takia?» ");
INSERT INTO fin_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kansanjoukko vastasi: »Olet järjiltäsi! Kuka sinua on yrittänyt tappaa?» ");
INSERT INTO fin_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jeesus sanoi: »Tein työtä sapattina, kun paransin miehen, ja te olitte ihmeissänne. ");
INSERT INTO fin_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tekin teette työtä sapattina pyrkiessänne noudattamaan Mooseksen ympärileikkausmääräystä. Ja huomatkaa, että tuo määräys on vanhempi kuin Mooseksen laki. ");
INSERT INTO fin_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Tekin ympärileikkaatte lapsen sapattina, jos se sattuu olemaan oikea aika. Miksi minut sitten tuomittaisiin siitä, että teen ihmisen kokonaan terveeksi sapattina? ");
INSERT INTO fin_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ajatelkaapa asiaa, niin näette, että olen oikeassa.» ");
INSERT INTO fin_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jotkut jerusalemilaiset sanoivat keskenään: »Eikö tämä ole juuri se mies, joka halutaan tappaa? ");
INSERT INTO fin_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nyt hän puhuu täällä julkisesti, eikä kukaan tee mitään. Olisivatko johtajamme kuitenkin saaneet selville, että hän todella on Messias? Mutta miten tämä mies voisi olla Messias? ");
INSERT INTO fin_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mehän tiedämme missä hän on syntynyt! Mutta kun Messias tulee, hän vain ilmestyy jostakin, eikä kukaan tiedä mistä.» ");
INSERT INTO fin_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Sen vuoksi Jeesus sanoi kovalla äänellä puhuessaan temppelissä: »Te tiedätte kyllä, missä minä olen syntynyt ja kasvanut. Mutta häntä, joka minut on lähettänyt, te ette tunne – ja hän on totuus. ");
INSERT INTO fin_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Minä tunnen hänet, koska olen ollut hänen luonaan. Hän minut lähettikin teidän luoksenne.» ");
INSERT INTO fin_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Silloin juutalaisten johtomiehet halusivat pidättää Jeesuksen, mutta kukaan ei kuitenkaan koskenut häneen, sillä Jumalan säätämä hetki ei ollut vielä tullut. ");
INSERT INTO fin_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Monet ihmiset uskoivat häneen. »Minkä sellaisen ihmeen te odotatte Messiaan tekevän, jota tämä mies ei jo olisi tehnyt?» he sanoivat. ");
INSERT INTO fin_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kun fariseukset kuulivat ihmisten puhuvan tällaista, he ja ylipapit lähettivät viranomaiset pidättämään Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Mutta Jeesus jatkoi puhettaan: »Minun on määrä viipyä täällä vielä vähän aikaa. Sitten palaan lähettäjäni luo. ");
INSERT INTO fin_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Te etsitte minua, mutta ette löydä. Ettekä te voi tulla sinne missä minä olen.» ");
INSERT INTO fin_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Juutalaisten uskonnolliset johtajat hämmästyivät perin juurin kuullessaan tämän väitteen. »Minne hän oikein aikoo mennä?» he kyselivät. »Ehkäpä hän matkustaa lähetyssaarnaajaksi muissa maissa asuvien juutalaisten tai jopa pakanoiden luo. ");
INSERT INTO fin_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Mitä hän sillä tarkoittaa, että me etsimme häntä, mutta emme pysty löytämään, ja sillä, ettemme voi mennä sinne missä hän on?» ");
INSERT INTO fin_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Viimeisenä juhlapäivänä, kun oli tullut juhlan kohokohta, Jeesus huusi ihmisjoukoille: »Jos jollakin on jano, niin tulkoon minun luokseni ja juokoon! ");
INSERT INTO fin_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Raamatussa sanotaan, että elävän veden virrat tulvivat jokaisen minuun uskovan ihmisen sisimmästä.» ");
INSERT INTO fin_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Tällä Jeesus tarkoitti Pyhän Hengen työtä ja lupasi Henkensä jokaiselle, joka uskoo häneen. Pyhä Henki ei ollut vielä tullut, sillä Jeesus ei ollut palannut kirkkauteensa taivaaseen.) ");
INSERT INTO fin_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kuullessaan Jeesuksen sanat jotkut kansanjoukosta innostuivat: »Tämä mies on se odotettu profeetta!» ");
INSERT INTO fin_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Toiset sanoivat: »Hän on Messias itse.» Kolmannet väittivät vastaan: »Se ei voi olla totta! Eihän Messias voi olla Galileasta kotoisin. ");
INSERT INTO fin_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Raamattu sanoo selvästi, että Messias syntyy Daavidin kuningassukuun ja vielä Betlehemissä, samassa kaupungissa kuin Daavid.» ");
INSERT INTO fin_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Näin ihmisten mielipiteet Jeesuksesta menivät ristiin. ");
INSERT INTO fin_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Toiset tahtoivat, että hänet pidätettäisiin, mutta kukaan ei koskenut häneen. ");
INSERT INTO fin_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Temppelipoliisit, jotka oli lähetetty pidättämään Jeesusta, tulivat takaisin ylipappien ja fariseusten luo. »Miksi ette tuoneetkaan häntä?» nämä tiukkasivat. ");
INSERT INTO fin_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","»Se mies puhuu aivan ihmeellisellä tavalla», he sanoivat. »Mitään sellaista emme ole ikinä kuulleet.» ");
INSERT INTO fin_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","»Joko hän on saanut teidätkin kannattajikseen?» fariseukset kysyivät pilkallisesti. ");
INSERT INTO fin_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","»Onko johtavien juutalaisten ja fariseusten joukossa yhtään ainutta, joka uskoo hänen olevan Messias? ");
INSERT INTO fin_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kansa kyllä uskoo, mutta mitä tuo kirottu lauma ymmärtää koko asiasta! Eihän se tunne lakia.» ");
INSERT INTO fin_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Silloin Nikodeemus puuttui puheeseen. Hän oli sama mies, joka kerran oli käynyt salaa keskustelemassa Jeesuksen kanssa. ");
INSERT INTO fin_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","»Onko laillista tuomita ihminen ilman oikeudenkäyntiä?» hän kysyi. »Eikö ensin ole selvitettävä, mihin hän on syyllistynyt?» ");
INSERT INTO fin_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Johtomiehet vastasivat: »Oletko sinäkin noita galilealaisia? Katso itse Raamatusta: ei Galileasta nouse profeettaa.» ");
INSERT INTO fin_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Neuvonpito päättyi siihen, ja kaikki lähtivät kotiin. ");
INSERT INTO fin_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jeesus palasi Öljymäelle, ");
INSERT INTO fin_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","mutta aikaisin seuraavana aamuna hän lähti taas temppeliin. Pian hänen ympärillään oli väkijoukko. Hän oli juuri puhumassa ihmisten kanssa, ");
INSERT INTO fin_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","kun sinne tuli lainopettajia ja fariseuksia raahaten mukanaan naista, joka oli saatu kiinni aviorikoksesta. Nainen työnnettiin ihmisjoukon eteen. ");
INSERT INTO fin_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Naisen tuojat sanoivat Jeesukselle: »Opettaja, tämä nainen on tavattu aviorikosta tekemästä. ");
INSERT INTO fin_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mooseksen laki määrää hänelle kuolemantuomion. Mitä sinä tähän sanot?» ");
INSERT INTO fin_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Sillä tavalla Jeesus yritettiin saada sanomaan jotain sellaista, mitä voitaisiin käyttää häntä vastaan. Mutta hän kumartuikin ja kirjoitti sormellaan hiekkaan. ");
INSERT INTO fin_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Miehet eivät kuitenkaan jättäneet häntä rauhaan, vaan vaatimalla vaativat häntä ilmoittamaan oman kantansa. Silloin hän nousi ja sanoi: »Hyvä on, kivittäkää hänet kuoliaaksi. Mutta ensimmäisen kiven heittäköön se, joka on synnitön.» ");
INSERT INTO fin_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jeesus kumartui jälleen kirjoittamaan maahan. ");
INSERT INTO fin_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Juutalaisten johtomiehet livahtivat tiehensä yksi toisensa jälkeen, vanhimmasta lähtien, kunnes paikalla oli enää vain Jeesus ja se nainen. ");
INSERT INTO fin_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jeesus ojentautui seisomaan ja sanoi naiselle: »Missä sinun syyttäjäsi ovat? Eikö kukaan heistä jäänyt tuomitsemaan sinua?» ");
INSERT INTO fin_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","»Ei, herra, ei kukaan», hän sanoi. »En minäkään sinua tuomitse», Jeesus sanoi. »Mene nyt, äläkä enää tee syntiä.» ");
INSERT INTO fin_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Myöhemmin Jeesus sanoi eräässä puheessaan kansalle: »Minä olen maailman valo. Jos siis seuraatte minua, teidän ei tarvitse kompastella pimeässä, vaan saatte kulkea valaistua elämän tietä.» ");
INSERT INTO fin_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Fariseukset vastasivat: »Sinä vain kehut itseäsi – ja valehtelet!» ");
INSERT INTO fin_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jeesus sanoi: »Minä puhun totta, vaikka puhunkin itsestäni. Minähän tiedän, mistä olen tänne tullut ja minne olen matkalla, mutta te ette sitä tiedä. ");
INSERT INTO fin_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Te tuomitsette minut tuntematta tosiasioita. Minä en teitä tuomitse – ");
INSERT INTO fin_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","mutta jos tuomitsisin, se olisi joka suhteessa oikea tuomio, sillä Isä on kanssani. ");
INSERT INTO fin_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Teidän lakinne sanoo, että jos kaksi todistajaa puhuu yhdenmukaisesti, heidän todistuksensa on pätevä. ");
INSERT INTO fin_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Minä olen toinen todistaja ja toinen on Isä, joka on minut tänne lähettänyt.» ");
INSERT INTO fin_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","»Missä sinun isäsi on?» häneltä kysyttiin. Jeesus vastasi: »Te ette tiedä, kuka olen, ja sen vuoksi te ette myöskään tiedä, kuka minun Isäni on. Jos tuntisitte minut, niin tuntisitte hänetkin.» ");
INSERT INTO fin_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jeesus puhui näistä asioista siinä osassa temppeliä, jossa kolehtiarkut olivat. Häntä ei ollut vielä pidätetty, sillä Jumalan säätämä hetki ei ollut tullut. ");
INSERT INTO fin_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jeesus sanoi jälleen ihmisille: »Minä menen pois. Te etsitte minua ja kuolette synteihinne. Mutta sinne, minne minä menen, te ette voi tulla.» ");
INSERT INTO fin_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Juutalaiset kyselivät: »Aikooko hän tappaa itsensä? Mitä hän tarkoittaa sanoessaan: ’Sinne, minne minä menen, te ette voi tulla’?» ");
INSERT INTO fin_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Siihen Jeesus sanoi: »Te olette alhaalta, minä ylhäältä. Te olette tästä maailmasta, minä en. ");
INSERT INTO fin_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sen vuoksi sanoin, että te kuolette synteihinne. Jos ette usko minun olevan Messias, Jumalan Poika, kuolette synteihinne.» ");
INSERT INTO fin_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","»Sano meille, kuka olet», he ahdistivat häntä. Hän vastasi: »Minä olen se, joka aina olen sanonutkin olevani. ");
INSERT INTO fin_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Minulla olisi teille paljon puhuttavaa ja täysi syy tuomita teidät. En sitä kuitenkaan tee, sillä puhun vain sen, mitä lähettäjäni käskee – ja hän on totuus.» ");
INSERT INTO fin_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Vieläkään ihmiset eivät ymmärtäneet hänen puhuvan heille Jumalasta. ");
INSERT INTO fin_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Sen vuoksi Jeesus sanoi: »Kun olette surmanneet minut, silloin ymmärrätte, kuka minä olen, ja etten esitä omia ajatuksiani, vaan puhun sitä mitä Isä on opettanut minulle. ");
INSERT INTO fin_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Lähettäjäni on minun kanssani – ei hän ole minua hylännyt, sillä toimin kaikessa hänen tahtonsa mukaan.» ");
INSERT INTO fin_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","31","Monet niistä, jotka kuulivat Jeesuksen sanovan näin, alkoivat uskoa, että hän oli Messias. Heille Jeesus sanoi: »Olette oikeita oppilaitani, jos tottelette sanojani. ");
INSERT INTO fin_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Silloin opitte tuntemaan totuuden, ja totuus vapauttaa teidät.» ");
INSERT INTO fin_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","»Me olemme Aabrahamin jälkeläisiä», he sanoivat, »emmekä ole ikinä olleet kenenkään orjia. Mitä sinä ’vapauttamisesta’ puhut?» ");
INSERT INTO fin_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jeesus vastasi: »Synnin orjia te olette – jokainen teistä. ");
INSERT INTO fin_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Eikä orjilla ole oikeuksia, mutta Pojalla on kaikki oikeudet. ");
INSERT INTO fin_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jos siis Poika vapauttaa teidät, teistä tulee todella vapaita. ");
INSERT INTO fin_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Tiedänhän minä teidän olevan Aabrahamin jälkeläisiä. Kuitenkin jotkut teistä yrittävät tappaa minut, koska ette kestä kuulla mitä sanon. ");
INSERT INTO fin_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Puhun teille siitä, mitä näin Isäni luona. Kuuntelettehan tekin oman isänne neuvoja.» ");
INSERT INTO fin_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","»Meidän isämme on Aabraham», he julistivat. »Jos Aabraham olisi isänne», Jeesus sanoi, »te seuraisitte hänen hyvää esimerkkiään. ");
INSERT INTO fin_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Sen sijaan te yritätte tappaa minut – vain siksi, että puhuin teille Jumalalta kuulemaani totuutta. Aabraham ei olisi tehnyt niin kuin te. ");
INSERT INTO fin_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mutta te tottelettekin todellista isäänne.» Kuulijat vastasivat: »Emme me ole aviottomia lapsia – meidän todellinen isämme on itse Jumala.» ");
INSERT INTO fin_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jeesus sanoi heille: »Jos niin olisi, te rakastaisitte minua, sillä minä olen tullut Jumalan luota. En minä ole tullut tänne omasta aloitteestani, vaan hän on lähettänyt minut. ");
INSERT INTO fin_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Miksi ette voi ymmärtää, mitä teille selitän? Siksi, että joku estää teitä ymmärtämästä! ");
INSERT INTO fin_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Te olette isänne, saatanan, lapsia ja haluatte tehdä kaikkea sitä pahaa mitä hänkin tekee. Hän on jo alun perin ollut murhaaja ja vihannut totuutta. On vain luonnollista, että hän valehtelee, sillä hän on valheen isä. ");
INSERT INTO fin_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ettekä tekään usko minua, koska puhun teille totta. ");
INSERT INTO fin_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kuka teistä voi osoittaa minun langenneen syntiin? Ei kukaan! Koska siis puhun totta, miksi ette usko minua? ");
INSERT INTO fin_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jokainen, jonka Isä Jumala on, kuuntelee ilomielin Jumalan sanoja. Te ette ole hänen lapsiaan, koska ette kuuntele häntä.» ");
INSERT INTO fin_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","»Sinä olet samarialainen! Sinussa on paha henki!» Johtavat juutalaiset sähisivät kiukkua. ");
INSERT INTO fin_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","»Minussa ei ole pahaa henkeä», Jeesus sanoi, »vaan minä kunnioitan Isääni, mutta te häpäisette minua. ");
INSERT INTO fin_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","En minä havittele kunniaa itselleni. Kunnia ja oikeus tuomita kuuluvat yksin Jumalalle. ");
INSERT INTO fin_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mutta sanon teille vakavasti: joka tottelee minua, ei kuole koskaan.» ");
INSERT INTO fin_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Juutalaisten johtajat vastasivat: »Nyt se tiedetään, että sinä olet riivattu. Jopa Aabraham ja muut suuret profeetat ovat kuolleet, ja sinä väität, että sinua tottelemalla voi säästyä kuolemalta! ");
INSERT INTO fin_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Väitätkö siis olevasi suurempi kuin esi-isämme Aabraham, joka hänkin on kuollut? Suurempi kuin profeetat, jotka ovat kuolleet! Kuka oikein kuvittelet olevasi?» ");
INSERT INTO fin_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Silloin Jeesus sanoi: »Jos puhuisin perättömiä, kenenkään ei tarvitsisi uskoa minua. Mutta entä sitten, kun Isäni – tehän pidätte häntä Jumalananne – sanoo minusta samaa? ");
INSERT INTO fin_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ettehän te edes tunne häntä. Minä tunnen. Jos muuta väittäisin, olisin valehtelija niin kuin tekin. Mutta minä todella tunnen hänet ja toimin täysin hänen tahtonsa mukaan. ");
INSERT INTO fin_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Teidän esi-isänne Aabraham oli jo etukäteen iloinen siitä, että tiesi minun aikani tulevan.» ");
INSERT INTO fin_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","»Et ole edes viittäkymmentä ja olet muka nähnyt Aabrahamin», Jeesukselle sanottiin. ");
INSERT INTO fin_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","»Tämä on totuus: minä olen ollut jo ennen Aabrahamin syntymää», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Sen kuullessaan juutalaisten johtomiehet jo sieppasivat maasta kiviä surmatakseen Jeesuksen, mutta Jeesus pääsi heidän huomaamattaan lähtemään temppelistä. ");
INSERT INTO fin_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Matkan varrella Jeesus tapasi miehen, joka oli ollut syntymästään saakka sokea. ");
INSERT INTO fin_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Oppilaat kysyivät Jeesukselta: »Mestari, miksi tämä mies syntyi sokeana? Siksikö, että hän teki syntiä? Vai onko hän sokea vanhempiensa syntien tähden?» ");
INSERT INTO fin_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","»Ei kummastakaan syystä», Jeesus vastasi. »Hän on sokea siksi, että Jumalan voima pääsisi näkyviin. ");
INSERT INTO fin_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Meidän on tehtävä Jumalan työtä niin kauan kuin vielä päivä on, sillä yön tuloon ei ole enää pitkä aika, ja silloin on kaikki työt lopetettava. ");
INSERT INTO fin_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Niin kauan kuin vielä viivyn täällä maailmassa, olen maailman valo.» ");
INSERT INTO fin_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Sen sanottuaan Jeesus kostutti syljellään multaa ja levitti sitä sokean silmille. ");
INSERT INTO fin_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sitten hän sanoi sokealle: »Mene pesemään itsesi Siiloan lammessa.» (Sana Siiloa merkitsee »lähetetty».) Mies meni, peseytyi ja tuli takaisin näkevänä. ");
INSERT INTO fin_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Lähellä asuvat ja muutkin, jotka tunsivat sokean kerjäläisen, kyselivät: »Onko tuo se kerjäläinen?» ");
INSERT INTO fin_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Toiset sanoivat: »On», ja toiset: »Ei ole.» »Eihän se voi olla sama mies, hän vain muistuttaa kovasti sitä sokeaa», he ajattelivat. Kerjäläinen sanoi: »Kyllä minä olen sama mies.» ");
INSERT INTO fin_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Silloin ihmiset alkoivat kysellä häneltä, kuinka hän nyt sitten pystyi näkemään. Mitä oli tapahtunut? ");
INSERT INTO fin_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kerjäläinen selitti: »Eräs mies, jonka nimi kuuluu olevan Jeesus, otti multaa ja levitti sitä silmilleni. Sitten hän käski minun mennä Siiloan lammelle pesemään silmäni. Minä tein niin, ja nyt näen!» ");
INSERT INTO fin_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","»Missä hän nyt on?» he kysyivät. »Sitä minä en tiedä», hän vastasi. ");
INSERT INTO fin_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sitten mies vietiin fariseusten luo. ");
INSERT INTO fin_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Tämä kaikki tapahtui sapattina. ");
INSERT INTO fin_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseukset kyselivät mieheltä tarkkaan, mitä Jeesus oli tehnyt. Mies selitti heille, kuinka Jeesus oli sivellyt multaa hänen silmilleen ja kuinka hän pestyään sen pois oli saanut näkönsä. ");
INSERT INTO fin_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jotkut fariseukset sanoivat silloin: »Eihän tämä Jeesus voi olla Jumalan lähettämä, koska hän kerran tekee työtä sapattina.» Toiset sanoivat: »Mutta miten tavallinen syntinen voisi tehdä tällaisia ihmeitä?» Näin mielipiteet hänestä menivät ristiin. ");
INSERT INTO fin_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Fariseukset rupesivat tiukkaamaan näkönsä saaneelta: »Se mies paransi silmäsi – kuka hän sinun mielestäsi on?» »Hänen täytyy olla Jumalan lähettämä profeetta», mies vastasi. ");
INSERT INTO fin_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juutalaisten johtomiehet eivät uskoneet, että mies oli ollutkaan sokea, vaan kutsuivat hänen vanhempansa paikalle ");
INSERT INTO fin_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ja kysyivät heiltä: »Onko tämä teidän poikanne? Onko hän syntynyt sokeana? Ja jos on, niin kuinka hän sitten nyt näkee?» ");
INSERT INTO fin_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Vanhemmat vastasivat: »Kyllä tämä on meidän poikamme, ja syntymästään saakka hän on ollut sokea. ");
INSERT INTO fin_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Mutta sitä me emme tiedä, miten hän on saanut näkönsä tai kuka hänet paransi. Hän on tarpeeksi vanha puhumaan itse puolestaan, kysykää häneltä.» ");
INSERT INTO fin_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","23","Näin he sanoivat siksi, että pelkäsivät juutalaisten johtomiehiä, jotka olivat antaneet määräyksen, että jokainen, joka sanoisi Jeesuksen olevan Messias, erotettaisiin seurakunnasta. ");
INSERT INTO fin_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sokeana ollut mies kutsuttiin siis uudestaan kuultavaksi, ja hänelle sanottiin: »Anna kunnia Jumalalle äläkä Jeesukselle, sillä me tiedämme, että Jeesus on paha ihminen.» ");
INSERT INTO fin_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","»Minä en tiedä, onko hän hyvä vai paha», mies vastasi, »mutta sen tiedän, että olen ollut sokea ja nyt näen!» ");
INSERT INTO fin_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","»Mitä hän sitten teki?» häneltä kysyttiin. »Miten hän sinut paransi?» ");
INSERT INTO fin_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","»Johan minä sen selitin», mies huudahti. »Miksette voi kuunnella? Pitääkö minun selittää kaikki uudestaan? Haluatteko tekin ruveta hänen oppilaikseen?» ");
INSERT INTO fin_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Vastaukseksi hän sai oikean sadattelujen ryöpyn. »Sinusta on tullut Jeesuksen oppilas», kuulustelijat sanoivat, »mutta me olemme Mooseksen oppilaita. ");
INSERT INTO fin_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Me tiedämme Jumalan puhuneen Moosekselle, mutta tuosta miehestä emme tiedä mitään.» ");
INSERT INTO fin_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","»Sepä merkillistä», mies vastasi. »Hän parantaa sokeita, ettekä te tiedä hänestä mitään! ");
INSERT INTO fin_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Eihän Jumala pahoja kuule, hän kuulee niitä, jotka palvelevat häntä ja toimivat hänen tahtonsa mukaan. ");
INSERT INTO fin_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Maailmassa ei ole ikinä ollut ketään, joka pystyisi avaamaan sokeana syntyneen silmät. ");
INSERT INTO fin_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ellei tämä mies olisi Jumalan lähettämä, hän ei pystyisi tekemään sitä.» ");
INSERT INTO fin_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","»Sinä senkin syntisäkki – yrität opettaa meitä», he huusivat ja ajoivat hänet ulos. ");
INSERT INTO fin_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jeesus kuuli siitä, ja tavatessaan miehen hän kysyi tältä: »Uskotko Jumalan Poikaan?» ");
INSERT INTO fin_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mies vastasi: »Tahtoisin uskoa – mutta kuka hän on?» ");
INSERT INTO fin_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","»Sinä olet nähnyt hänet», Jeesus sanoi, »ja hän puhuu juuri nyt sinun kanssasi.» ");
INSERT INTO fin_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","»Uskon, Herra», mies sanoi, »kyllä minä uskon!» Hän kumartui palvomaan Jeesusta. ");
INSERT INTO fin_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Silloin Jeesus sanoi hänelle: »Olen tullut maailmaan antamaan näön hengellisesti sokeille ja osoittamaan niille, jotka luulevat näkevänsä, että he ovat sokeita.» ");
INSERT INTO fin_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Siinä seisovat fariseukset kysyivät: »Yritätkö sanoa, että me olemme sokeita?» ");
INSERT INTO fin_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","»Jos olisittekin sokeita, teitä ei syytettäisi teoistanne», Jeesus vastasi. »Mutta koska väitätte tietävänne mikä on oikein, olette syyllisiä, kun ette tee sen mukaan.» ");
INSERT INTO fin_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","»Joka ei käytä lammastarhan ovea, vaan kiipeää sinne muurin yli, on varas. ");
INSERT INTO fin_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Paimen kulkee ovesta. ");
INSERT INTO fin_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Portinvartija päästää hänet sisään, ja kun lampaat kuulevat hänen äänensä, ne tulevat hänen luokseen. Paimen kutsuu nimeltä omia lampaitaan ja vie ne ulos. ");
INSERT INTO fin_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Hän kulkee niiden edellä, ja ne seuraavat perässä, koska tuntevat hänen äänensä. ");
INSERT INTO fin_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Eivät ne lähde vierasta seuraamaan, vaan juoksevat pois, jos kutsujan ääni on outo.» ");
INSERT INTO fin_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ne, jotka kuulivat Jeesuksen käyttävän tätä vertausta, eivät ymmärtäneet, mitä hän sillä tarkoitti. ");
INSERT INTO fin_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Sen vuoksi hänen oli selitettävä: »Minä olen lammastarhan ovi», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","»Kaikki ne, jotka ovat tulleet ennen minua, ovat olleet varkaita ja ryöstäjiä. Mutta oikeat lampaat eivät ole kuunnelleet heidän houkutuksiaan. ");
INSERT INTO fin_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Minä olen ovi. Ne lampaat, jotka tulevat sisään ovesta, pelastuvat. Ne saavat kulkea sisään ja ulos ja syödä vihreillä laitumilla. ");
INSERT INTO fin_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Varas tulee varastamaan, tappamaan ja tuhoamaan. Minä olen tullut antamaan ikuisesti kestävän, rikkaan elämän. ");
INSERT INTO fin_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Minä olen hyvä paimen, ja minä annan henkeni lampaiden puolesta. ");
INSERT INTO fin_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Palkkapaimen saattaa juosta pakoon nähdessään suden tulevan. Lampaat hän jättää suden suuhun – eiväthän ne ole hänen omiaan eikä hän oikea paimen. Näin susi pääsee hajottamaan lauman. ");
INSERT INTO fin_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Mies lähtee pakoon, koska hän tekee työnsä vain palkan toivossa eikä häntä kiinnosta se, mikä on parasta lampaille. ");
INSERT INTO fin_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Mutta minä olen hyvä paimen. Tunnen omat lampaani ja ne tuntevat minut, ");
INSERT INTO fin_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","aivan niin kuin Isä tuntee minut ja minä Isän. Ja minä annan henkeni lampaiden puolesta. ");
INSERT INTO fin_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Muitakin lampaita minulla on – toisessa laumassa. Myös niiden kulkua minun tulee johtaa. Nekin kuulevat ääneni, ja on yksi lauma ja yksi paimen. ");
INSERT INTO fin_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Isä rakastaa minua, sillä minä annan henkeni – ja saan sen jälleen takaisin. ");
INSERT INTO fin_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Kukaan ei voisi surmata minua, ellen antaisi henkeäni vapaaehtoisesti. Onhan minulla oikeus ja valta antaa se milloin tahdon ja ottaa se taas milloin tahdon. Tämän oikeuden on Isä minulle antanut.» ");
INSERT INTO fin_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Kun Jeesus puhui näin, kansanjohtajien mielipiteet hajaantuivat. ");
INSERT INTO fin_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Toiset sanoivat: »Hän on joko pahan hengen riivaama tai mielenvikainen. Ei häntä kannata kuunnella.» ");
INSERT INTO fin_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Toiset taas sanoivat: »Ei hän puhu kuin pahan hengen vallassa oleva ihminen. Kykeneekö paha henki antamaan sokeille näön?» ");
INSERT INTO fin_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Oli talvi ja Jerusalemissa vietettiin temppelin vihkimisen muistojuhlaa. ");
INSERT INTO fin_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jeesus oli temppelissä, ja hän oli juuri menossa sen osan läpi, jota kutsuttiin Salomon pylväiköksi. ");
INSERT INTO fin_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Juutalaisten johtomiehet piirittivät hänet ja kysyivät: »Kuinka kauan aiot pitää meitä jännityksessä? Jos olet Messias, niin sano se suoraan.» ");
INSERT INTO fin_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","»Olenhan sen jo sanonut, mutta te ette näytä sitä uskovan», Jeesus vastasi. »Puolestani puhuvat ne ihmeet, joita teen Isäni nimissä. ");
INSERT INTO fin_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Te ette usko minua sen vuoksi, ettette kuulu laumaani. ");
INSERT INTO fin_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Minun lampaani tuntevat minun ääneni, minä tunnen ne, ja ne seuraavat minua. ");
INSERT INTO fin_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","29","Annan omilleni ikuisen elämän, eivätkä he joudu hukkaan. Missään tapauksessa ei kukaan pysty ryöstämään heitä Isältä eikä minulta, sillä Isä on antanut heidät minulle, ja hän on kaikkia muita voimakkaampi. ");
INSERT INTO fin_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Minä ja Isä olemme yhtä.» ");
INSERT INTO fin_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Silloin juutalaisten johtomiehet sieppasivat taas kiviä maasta surmatakseen Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Hän sanoi: »Jumalan tahdosta olen tehnyt monta hyvää tekoa ja auttanut ihmisiä. Mikä niistä on se, jonka vuoksi tahdotte minut kivittää?» ");
INSERT INTO fin_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","He vastasivat: »Ei sinua kukaan hyvistä teoista kivitä, vaan jumalanpilkasta. Sinä, tavallinen ihminen, olet julistanut itsesi Jumalaksi!» ");
INSERT INTO fin_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","»Mutta teidän oma lakinnehan sanoo, että ihmiset ovat jumalia», Jeesus vastasi. ");
INSERT INTO fin_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","»Raamattu, joka ei valehtele, nimittää jumaliksi niitä, jotka saivat sanan Jumalalta. ");
INSERT INTO fin_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Onko teistä Jumalan pilkkaamista, jos se pyhä, jonka Isä on lähettänyt maailmaan, sanoo: ’Minä olen Jumalan Poika’? ");
INSERT INTO fin_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Ei teidän tarvitse uskoa minua, ellen tee Jumalan ihmeitä. ");
INSERT INTO fin_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mutta jos niitä teen, uskokaa niitä, ellette usko minua. Silloin tulette vakuuttuneiksi siitä, että Isä elää minussa ja minä hänessä.» ");
INSERT INTO fin_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Taas kansanjohtajat olivat ottamaisillaan hänet kiinni. Mutta Jeesus lähti pois heidän ulottuviltaan ");
INSERT INTO fin_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ja meni Jordanin yli lähelle sitä paikkaa, jossa Johannes aloitti kastetoimituksensa. ");
INSERT INTO fin_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Monia ihmisiä tuli hänen perässään. »Johannes ei tehnyt ihmeitä», he sanoivat toinen toisilleen, »mutta kaikki, mitä hän ennusti tästä miehestä, on käynyt toteen.» ");
INSERT INTO fin_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Monet päättelivätkin, että Jeesuksen oli siis oltava Messias. ");
INSERT INTO fin_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Tunnetteko kertomuksen Mariasta, joka kaatoi kalliin voiteen Jeesuksen jaloille ja pyyhki ne hiuksillaan? Marialla oli sisar, Martta, ja veli nimeltä Lasarus. He asuivat kaikki yhdessä Betaniassa. Lasarus oli vakavasti sairaana. ");
INSERT INTO fin_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sen vuoksi hänen sisarensa lähettivät Jeesukselle sanan: »Sinun hyvä ystäväsi on pahasti sairas.» ");
INSERT INTO fin_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Sen kuullessaan Jeesus sanoi: »Lasarus paranee. Kun tämä ihme tapahtuu, ihmiset saavat nähdä, että se on Jumalan teko ja että minä olen Jumalan Poika.» ");
INSERT INTO fin_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","6-7","Jeesus ei kuitenkaan heti lähtenyt matkaan, vaikka Martta, Maria ja Lasarus olivat hänen rakkaita ystäviään. Vasta kahden päivän kuluttua hän sanoi oppilailleen: »Nyt lähdetään Juudeaan.» ");
INSERT INTO fin_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Oppilaat vastustelivat: »Ei ole kulunut kuin muutama päivä siitä, kun juutalaisten johtomiehet yrittivät tappaa sinut Juudeassa. Joko nyt olet taas menossa sinne?» ");
INSERT INTO fin_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jeesus vastasi: »Onhan vuorokaudessa kaksitoista tuntia päivänvaloa, ja silloin näkee kulkea kompastumatta. ");
INSERT INTO fin_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Vain yöllä pimeässä astuu helposti harhaan.» ");
INSERT INTO fin_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Hän lisäsi: »Ystävämme Lasarus nukkuu nyt, mutta minä menen herättämään hänet.» ");
INSERT INTO fin_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Oppilaat luulivat Jeesuksen tarkoittavan, että Lasarus nukkui jo rauhallisesti. »Sittenhän hän on paranemaan päin», he totesivat. ");
INSERT INTO fin_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Mutta Jeesus tarkoitti, että Lasarus oli jo kuollut. ");
INSERT INTO fin_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jeesus sanoikin heille lopulta suoraan: »Lasarus on kuollut. ");
INSERT INTO fin_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Teidän tähtenne olen iloinen, etten silloin ollut siellä, sillä tämä antaa teille uuden tilaisuuden uskoa minuun. Lähdetään nyt Lasaruksen luo.» ");
INSERT INTO fin_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tuomas, lisänimeltään Kaksonen, sanoi toisille oppilaille: »Mennään vain – ja kuollaan yhdessä opettajan kanssa!» ");
INSERT INTO fin_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kun matkalaiset tulivat perille, heille kerrottiin, että Lasarus oli jo neljä päivää ollut haudattuna. ");
INSERT INTO fin_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania on vain kolmisen kilometriä Jerusalemista, ");
INSERT INTO fin_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ja monia johtavia juutalaisia oli tullut surunvalittelukäynnille Martan ja Marian luo. ");
INSERT INTO fin_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Kun Martta sai kuulla, että Jeesus oli tulossa, hän lähti tätä vastaan. Maria jäi kuitenkin kotiin. ");
INSERT INTO fin_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martta sanoi Jeesukselle: »Herra, jos sinä olisit ollut täällä, veljeni ei olisi kuollut. ");
INSERT INTO fin_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mutta tälläkin hetkellä kaikki on sinun vallassasi. Tiedän, että saat Jumalalta mitä ikinä pyydät.» ");
INSERT INTO fin_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jeesus sanoi: »Sinun veljesi herää kuolleista.» ");
INSERT INTO fin_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","»Niin, sitten ylösnousemuksessa, kun kaikki muutkin kuolleet heräävät», Martta totesi. ");
INSERT INTO fin_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Siihen Jeesus sanoi: »Minä herätän kuolleet ja annan ikuisen elämän. Jokainen, joka uskoo minuun, elää ikuisesti, vaikka hänen ruumiinsa kuoleekin. ");
INSERT INTO fin_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ei kukaan, joka elää minuun uskoen, koe ikuista kuolemaa. Uskotko sen, Martta?» ");
INSERT INTO fin_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","»Kyllä, Herra», Martta sanoi, »Uskon, että olet Messias ja Jumalan Poika – se, jota kansamme on kauan odottanut.» ");
INSERT INTO fin_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martta palasi sitten Marian luo, veti hänet syrjään ja kuiskasi: »Hän on tullut ja haluaa puhua kanssasi.» ");
INSERT INTO fin_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria lähti heti Jeesuksen luo. ");
INSERT INTO fin_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jeesus oli vielä kylän ulkopuolella samassa paikassa, jonne Martta oli tullut häntä vastaan. ");
INSERT INTO fin_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Kun huoneessa olijat, jotka olivat yrittäneet lohduttaa Mariaa, näkivät hänen lähtevän kiireesti johonkin, he otaksuivat hänen menevän Lasaruksen haudalle itkemään ja lähtivät hänen peräänsä. ");
INSERT INTO fin_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Kun Maria tuli Jeesuksen luo, hän heittäytyi Jeesuksen jalkoihin ja sanoi: »Herra, jos sinä olisit ollut täällä, veljeni olisi elossa.» ");
INSERT INTO fin_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kun Jeesus näki Marian ja hänen mukanaan tulleiden ihmisten itkevän, hän liikuttui syvästi. ");
INSERT INTO fin_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","»Mihin hänet on haudattu?» hän kysyi. »Tule katsomaan», hänelle sanottiin. ");
INSERT INTO fin_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jeesus itki. ");
INSERT INTO fin_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","»He olivat hyvin läheisiä ystäviä», juutalaisten johtomiehet sanoivat. »Katsokaa, miten rakas Lasarus oli hänelle.» ");
INSERT INTO fin_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Jotkut sanoivat: »Tämä mies antoi sokealle näön – miksei hän sitten pystynyt estämään Lasaruksen kuolemaa?» ");
INSERT INTO fin_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jeesus seisahtui liikuttuneena. He kävelivät sitten haudan luo. Se oli luola, jonka suulle oli vieritetty suuri kivi. ");
INSERT INTO fin_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","»Työntäkää kivi syrjään», Jeesus käski. Mutta kuolleen sisar Martta esteli: »Sieltä tulee kauhea haju, sillä hän on ollut kuolleena jo neljä päivää.» ");
INSERT INTO fin_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","»Enkö sanonut, että saat nähdä suuren Jumalan ihmeen, jos uskot», Jeesus vastasi Martalle. ");
INSERT INTO fin_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Kivi vieritettiin syrjään. Sitten Jeesus katsoi ylöspäin ja sanoi: »Isä, kiitos siitä, että kuulet minua. ");
INSERT INTO fin_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Tiedän, että kuulet minua aina, mutta sanoin tämän näiden ihmisten takia, että he uskoisivat sinun lähettäneen minut.» ");
INSERT INTO fin_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Sitten Jeesus huusi: »Lasarus, tule ulos!» ");
INSERT INTO fin_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kuolleena ollut Lasarus tuli. Hänet oli kääritty hautausliinaan: jalat, kädet ja kasvotkin olivat kääreessä. Jeesus sanoi: »Päästäkää hänet noista käärinliinoista.» ");
INSERT INTO fin_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Monet juutalaisten johtomiehet, jotka olivat tulleet Marian kanssa ja nähneet mitä tapahtui, uskoivat nyt lopultakin Jeesukseen. ");
INSERT INTO fin_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Jotkut silminnäkijät menivät kuitenkin fariseusten luo kertomaan mitä Betaniassa oli tapahtunut. ");
INSERT INTO fin_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Silloin ylipapit ja fariseukset kokosivat ylimmän tuomioistuimensa, suuren neuvoston, keskustelemaan tilanteesta. »Mitä me nyt teemme?» he kyselivät toinen toisiltaan. »Tämä mieshän aivan ilmeisesti tekee ihmeitä. ");
INSERT INTO fin_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jos hän saa rauhassa toimia, koko kansa juoksee pian hänen perässään. Ja silloin Rooman armeija tulee ja hävittää kansamme ja temppelimme.» ");
INSERT INTO fin_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yksi heistä, Kaifas, joka oli sinä vuonna ylipappina, sanoi: »Ajatelkaa nyt loppuun asti: ");
INSERT INTO fin_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","eikö ole parempi heti surmauttaa tuo mies? Miksi koko kansan pitäisi joutua tuhoon?» ");
INSERT INTO fin_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Tähän ylipappi Kaifaan puheenvuoroon sisältyi profetia: Jeesus ei kuolisi vain Israelin puolesta, vaan kaikkien Jumalan lasten puolesta, jotka ovat hajallaan ympäri maailmaa. ");
INSERT INTO fin_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tuona päivänä juutalaisten johtajat päättivät surmata Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sen vuoksi Jeesus lakkasi toimimasta julkisesti. Hän lähti autiomaan laidassa olevaan Efraim-nimiseen kylään, ja jäi sinne oppilaidensa kanssa. ");
INSERT INTO fin_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Juutalaisten pääsiäisjuhla oli lähellä, ja Jerusalemiin tuli paljon väkeä maaseudulta jo useita päiviä ennen juhlien alkua saadakseen ajoissa valmistavat puhdistusmenonsa suoritetuksi. ");
INSERT INTO fin_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nämä ihmiset olisivat halunneet nähdä Jeesuksen, ja temppelissä kuiskailtiin: »Mitä arvelette – tuleeko hän pääsiäisjuhlille?» ");
INSERT INTO fin_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Suuri neuvosto oli ilmoittanut julkisesti, että heti kun joku näkisi Jeesuksen, hänen tulisi tehdä siitä ilmoitus, ja Jeesus pidätettäisiin. ");
INSERT INTO fin_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Kuusi päivää ennen pääsiäisenvieton alkua Jeesus saapui Betaniaan, jossa Lasarus asui – mies, jonka Jeesus oli herättänyt kuolleista. ");
INSERT INTO fin_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jeesuksen tulon kunniaksi jäljestettiin juhla-ateria. Martta tarjoili, ja Lasarus oli pöydässä Jeesuksen kanssa. ");
INSERT INTO fin_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria otti silloin astian aitoa kallisarvoista nardusvoidetta ja voiteli sillä Jeesuksen jalat. Sitten hän kuivasi ne omiin hiuksiinsa. Voiteen tuoksu levisi koko taloon. ");
INSERT INTO fin_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Juudas Iskariot, yksi oppilaista – se joka myöhemmin kavalsi Jeesuksen – sanoi: ");
INSERT INTO fin_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","»Tuo voidehan maksoi kokonaisen omaisuuden. Se olisi pitänyt myydä ja rahat antaa köyhille.» ");
INSERT INTO fin_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ei hän kuitenkaan köyhistä välittänyt, mutta yhteiset rahat olivat hänen hallussaan, ja hän oli ottanut niistä usein itselleen. ");
INSERT INTO fin_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jeesus vastasi: »Jättäkää Maria rauhaan. Näin tehdessään hän valmisti minua hautaan. ");
INSERT INTO fin_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Teillä on aina mahdollisuus auttaa köyhiä, mutta minä en ole enää kauan teidän luonanne.» ");
INSERT INTO fin_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Kun ihmiset kuulivat Jeesuksen tulleen, heitä tulvi suurin joukoin Betaniaan. He tulivat katsomaan Jeesusta ja myös Lasarusta, jonka hän oli herättänyt kuolleista. ");
INSERT INTO fin_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ylipapit päättivät, että myös Lasarus oli surmattava, ");
INSERT INTO fin_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","sillä hänen takiaanhan monet menivät sinne ja uskoivat, että Jeesus oli heidän Messiaansa. ");
INSERT INTO fin_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","13","Seuraavana päivänä kaupunkiin levisi tieto siitä, että Jeesus oli matkalla Jerusalemiin. Suuri joukko pääsiäisjuhlille tulleita ihmisiä meni palmunoksat kädessään Jeesusta vastaan. Väkijoukko huusi: »Eläköön kuningas! Kunnia Jumalan lähettiläälle! Kunnia Israelin kuninkaalle!» ");
INSERT INTO fin_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jeesus ratsasti kaupunkiin nuorella aasilla. Näin hän täytti Raamatun ennustuksen, jossa sanotaan: ");
INSERT INTO fin_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","»Älä pelkää kuningastasi, Israelin kansa, sillä minä tulen sinun luoksesi nöyränä, aasin varsan selässä.» ");
INSERT INTO fin_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jeesuksen oppilaat eivät vielä silloin tajunneet, että tämä oli ennustusten toteutumista. Vasta sitten kun Jeesus oli palannut taivaan kirkkauteen, he huomasivat, kuinka monet Raamatun ennustukset olivat toteutuneet aivan heidän silmiensä edessä. ");
INSERT INTO fin_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Väkijoukossa oli sellaisia, jotka olivat itse nähneet, kuinka Jeesus herätti Lasaruksen kuolleista ja olivat kertoneet siitä kaikille. ");
INSERT INTO fin_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Monet menivätkin Jeesusta vastaan juuri sen vuoksi, että olivat kuulleet tästä valtavasta ihmeestä. ");
INSERT INTO fin_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Silloin fariseukset sanoivat keskenään: »Me hävisimme – koko maailmahan juoksee hänen perässään.» ");
INSERT INTO fin_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Muutamat kreikkalaiset, jotka olivat saapuneet Jerusalemiin pääsiäisjuhlille, ");
INSERT INTO fin_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","tulivat Beetsaidasta kotoisin olevan Filippuksen luo ja pyysivät: »Me haluaisimme puhua Jeesuksen kanssa.» ");
INSERT INTO fin_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filippus esitti asian Andreaalle, ja yhdessä he menivät kysymään Jeesukselta. ");
INSERT INTO fin_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jeesus vastasi, että nyt oli tullut se aika, jolloin hänen oli palattava kunniaansa taivaaseen. ");
INSERT INTO fin_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","»Minun käy kuin vehnänjyvän, kun se putoaa multaan. Ellen kuole, jään yksin kuin siemen, jota ei ole pantu maahan. Mutta minun kuolemani tähden syntyy paljon uutta elämää, kuin uusia jyviä. ");
INSERT INTO fin_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jos rakastatte vain tätä maanpäällistä elämää, ikään kuin se olisi ainoa, ette ole löytäneet todellista elämää. Todellinen elämä on ikuista – miksi siis takerrutte vain tähän maanpäälliseen? ");
INSERT INTO fin_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jos nämä kreikkalaiset haluavat päästä oppilaikseni, pyytäkää heitä tulemaan minun mukaani, sillä minun palvelijoideni on oltava siellä missä minäkin olen. Ja Isä kunnioittaa heitä, jos he seuraavat minua. ");
INSERT INTO fin_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sydämeni on tuskaa täynnä. Pyytäisinkö Isältä: ’Pelasta minut siitä mikä on edessä’? Mutta sen vuoksihan tulin maailmaan! ");
INSERT INTO fin_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Isä, näytä valtasi!» Silloin taivaasta kuului ääni: »Minä olen sen jo tehnyt ja teen niin edelleenkin.» ");
INSERT INTO fin_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kun kansanjoukko kuuli äänen, jotkut luulivat sitä ukkoseksi ja toiset ajattelivat, että enkeli oli puhunut Jeesukselle. ");
INSERT INTO fin_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Silloin Jeesus sanoi kansanjoukolle: »Ei tämä ääni kuulunut minun tähteni vaan teidän. ");
INSERT INTO fin_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Maailman tuomitsemisen aika on tullut – se aika, jolloin tämän maailman ruhtinas, saatana, heitetään ulos. ");
INSERT INTO fin_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kun minut ylennetään ristille, vedän kaikki luokseni.» ( ");
INSERT INTO fin_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Hän sanoi tämän ilmoittaakseen, millä tavalla hän kuolisi.) ");
INSERT INTO fin_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","»Kuoletko sinä?» ihmiset kyselivät. »Me luulimme, ettei Messias kuole ollenkaan, vaan elää ikuisesti. Miksi sanot, että hänet ylennetään? Kuka hän sitten oikein on?» ");
INSERT INTO fin_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jeesus vastasi: »Minun valoni loistaa teille vielä hetkisen. Kulkekaa siinä valossa niin kauan kuin voitte. Menkää perille asti ennen kuin tulee pimeä, sillä silloin ette enää näe tietä. ");
INSERT INTO fin_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Uskokaa minuun niin kauan kuin minä vielä olen keskellänne, että teistä tulisi Jumalan lapsia.» ");
INSERT INTO fin_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Nämä sanat sanottuaan Jeesus vetäytyi syrjään ihmisjoukosta. Vaikka hän oli tehnyt paljon ihmeitä, suurin osa kansaa ei uskonut hänen olevan Messias. ");
INSERT INTO fin_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Juuri niinhän profeetta Jesaja oli ennustanutkin: »Herra, kuka meitä uskoo? Kenelle Jumalan valtavat ihmeet riittävät todistukseksi?» ");
INSERT INTO fin_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Eivät he voineet uskoa, sillä myös nämä Jesajan sanat pitivät paikkansa: ");
INSERT INTO fin_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","»Jumala on sokaissut heidän silmänsä ja kovettanut heidän sydämensä, niin etteivät he voi nähdä, eivät ymmärtää eivätkä tulla minun luokseni parannettaviksi.» ");
INSERT INTO fin_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Tässä ennustuksessa Jesaja puhui Jeesuksesta, sillä hän oli saanut näyssä nähdä Messiaan kirkkauden. ");
INSERT INTO fin_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kuitenkin jopa monet juutalaisten johtomiehet uskoivat hänen olevan Messias, mutta eivät myöntäneet sitä, koska pelkäsivät, että fariseukset erottaisivat heidät synagogasta. ");
INSERT INTO fin_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Heille oli ihmisten kiitos Jumalan kiitosta tärkeämpi. ");
INSERT INTO fin_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jeesus puhui kuuluvalla äänellä kansanjoukolle: »Jos uskotte minuun, uskotte silloin itse asiassa Jumalaan. ");
INSERT INTO fin_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nähdessänne minut näette minun lähettäjäni. ");
INSERT INTO fin_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Minä olen tullut valoksi pimeään maailmaan, eikä kukaan, joka turvautuu minuun, enää kulje pimeässä. ");
INSERT INTO fin_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","En minä tuomitse sitä, joka kuulee sanani, mutta ei niitä tottele – minä olen tullut pelastamaan maailman enkä sitä tuomitsemaan. ");
INSERT INTO fin_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sillä, joka halveksii minua ja sanojani, on tuomiopäivänä toinen tuomitsija: puhumani totuus tuomitsee hänet. ");
INSERT INTO fin_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","En ole puhunut omiani, vaan sen, mitä Isä on minut valtuuttanut teille puhumaan. ");
INSERT INTO fin_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tiedän, että hänen sanomansa avaa ihmisille tien ikuiseen elämään, ja sen vuoksi puhun, mitä hän on käskenyt minun puhua.» ");
INSERT INTO fin_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","2-3","Kun pääsiäisjuhla lähestyi, Jeesus tiesi, että hän tulisi pian palaamaan Isän luo. Ilta-aterian aikana saatana oli saanut Juudas Iskariotin, Simonin pojan, uskomaan, että juuri sinä yönä tämän olisi paras toteuttaa suunnitelmansa kavaltaa Jeesus. Jeesus tiesi, että Isä oli antanut kaiken Poikansa käsiin ja että hän menisi kohta Jumalan luo, mistä oli tullutkin. Hän rakasti oppilaitaan loppuun asti. ");
INSERT INTO fin_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Sen vuoksi hän nousi illallispöydästä, riisui viittansa ja kietoi pyyhkeen ympärilleen. ");
INSERT INTO fin_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sitten hän kaatoi vettä pesuastiaan ja alkoi pestä oppilaidensa jalkoja ja kuivata niitä vyötäisillään olevaan pyyhkeeseen. ");
INSERT INTO fin_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Kun tuli Simon Pietarin vuoro, tämä sanoi Jeesukselle: »Mestari, sinäkö peset minun jalkani?» ");
INSERT INTO fin_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jeesus vastasi: »Nyt sinä et ymmärrä, miksi minä tämän teen, mutta kerran sen vielä ymmärrät.» ");
INSERT INTO fin_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Vieläkin Pietari vastusteli: »Ei, et ikinä sinä saa pestä minun jalkojani!» »Jollen minä pese jalkojasi, et voi olla kanssani», Jeesus vastasi. ");
INSERT INTO fin_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Silloin Pietari huudahti: »Mestari, pese sitten myös käteni ja pääni äläkä vain jalkoja!» ");
INSERT INTO fin_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jeesus vastasi: »Sen, joka on kylpenyt, ei tarvitse kuin pestä pölyt jaloistaan ollakseen kokonaan puhdas. Sinä olet nyt puhdas – mutta kaikki teistä eivät ole.» ");
INSERT INTO fin_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jeesus tiesi, kuka kavaltaisi hänet, ja sen vuoksi hän sanoi: »Kaikki teistä eivät ole puhtaita.» ");
INSERT INTO fin_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Pestyään oppilaidensa jalat Jeesus puki jälleen viitan ylleen, asettui pöydän ääreen ja kysyi: »Ymmärrättekö mitä äsken tein? ");
INSERT INTO fin_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Te kutsutte minua opettajaksi ja Herraksi ja teettekin siinä oikein. ");
INSERT INTO fin_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ja koska minä, teidän Herranne ja opettajanne, olen pessyt teidän jalkanne, teidänkin tulee pestä toinen toistenne jalat. ");
INSERT INTO fin_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Olen antanut teille esimerkin: tehkää toisillenne niin kuin minä tein teille. ");
INSERT INTO fin_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kuinka totta onkaan, ettei palvelija ole isäntäänsä arvokkaampi. Samoin ei lähetti ole lähettäjäänsä tärkeämpi. ");
INSERT INTO fin_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nyt te tämän tiedätte – tehkää sen mukaan! Silloin olette onnelliset. ");
INSERT INTO fin_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","En sano tätä teistä kaikista. Tunnen teidät – itsehän teidät valitsin. Raamatussa sanotaan: ’Yksi kanssani aterialla olevista kavaltaa minut.’ Pian tämä toteutuu. ");
INSERT INTO fin_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Puhun asiasta nyt, että te kaiken tapahtuessa uskoisitte, kuka minä olen. ");
INSERT INTO fin_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Totuus on, että jos joku ottaa vastaan ihmisen, jonka minä olen lähettänyt, hän ottaa vastaan minut. Ja samalla hän ottaa vastaan Isän, joka on minut lähettänyt.» ");
INSERT INTO fin_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nyt Jeesus oli sydänjuuriaan myöten järkyttynyt. Hän huudahti: »Totta se on – yksi teistä kavaltaa minut!» ");
INSERT INTO fin_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Hänen oppilaansa katsoivat toinen toisiaan kysellen mielessään, ketä Jeesus saattoi tarkoittaa. ");
INSERT INTO fin_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jeesuksen oppilaista se, joka oli hänelle läheisin, oli pöydässä hänen oikealla puolellaan ja nojasi päätään hänen rintaansa vasten. ");
INSERT INTO fin_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Pietari antoi merkkejä tälle oppilaalle, että hän kysyisi Jeesukselta, kuka tuon kauhean teon tekee. ");
INSERT INTO fin_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tämä kysyi hiljaa Jeesukselta: »Herra, kuka se on?» ");
INSERT INTO fin_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jeesus vastasi niin että toiset eivät sitä kuulleet: »Se, jolle kastan leipäpalan.» Sitten Jeesus kastoi leipäpalan ja ojensi sen Juudaalle, Simon Iskariotin pojalle. ");
INSERT INTO fin_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kun Juudas oli sen syönyt, saatana meni häneen. Jeesus sanoi Juudaalle: »Tee se nyt heti.» ");
INSERT INTO fin_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kukaan muu aterialla olevista ei tiennyt, mitä Jeesus tarkoitti. ");
INSERT INTO fin_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Koska Juudas hoiti yhteisiä varoja, jotkut arvelivat, että Jeesus käski hänen mennä ostamaan tarvikkeita pääsiäisjuhlaa varten tai antamaan rahaa köyhille. ");
INSERT INTO fin_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Juudas lähti heti ulos pimeään yöhön. ");
INSERT INTO fin_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kun Juudas oli mennyt, Jeesus sanoi: »Minun aikani on nyt tullut. Pian on ympärilläni Jumalan kirkkaus, ja kaikki mitä minulle tapahtuu, koituu Jumalan kunniaksi. ");
INSERT INTO fin_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jumala antaa minulle oman kirkkautensa – ja tekee sen pian. ");
INSERT INTO fin_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Rakkaat lapset, kuinka vähän minun lähtööni on enää aikaa. Sitten te ette voi tulla minun luokseni, vaikka etsittekin minua – niin kuin jo olen sanonut. ");
INSERT INTO fin_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Sen vuoksi annan teille uuden käskyn: rakastakaa toisianne niin kuin minä rakastan teitä. ");
INSERT INTO fin_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Siitä koko maailma tuntee teidät minun oppilaikseni, että rakastatte toisianne.» ");
INSERT INTO fin_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Pietari sanoi: »Mestari, minne oikein menet?» Jeesus vastasi: »Nyt et voi tulla minun mukaani, mutta myöhemmin saat tulla perässäni.» ");
INSERT INTO fin_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","»Miksi en voi tulla nyt?» Pietari kysyi. »Minähän olen valmis vaikka kuolemaan puolestasi.» ");
INSERT INTO fin_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jeesus sanoi: »Kuolemaan puolestani? Ennen kuin kukko huomisaamuna kiekuu, olet jo kolmesti kieltänyt edes tuntevasi minua.» ");
INSERT INTO fin_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jeesus jatkoi puhettaan: »Älkää olko murheissanne. Te uskotte Jumalaan – uskokaa siis minuunkin. ");
INSERT INTO fin_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Siellä missä minun Isäni asuu, on paljon tilaa, ja minä menen sinne valmistamaan teidän tuloanne. ");
INSERT INTO fin_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kun sitten kaikki on valmista, tulen hakemaan teitä, ja saatte aina olla minun luonani. Jos niin ei olisi, sanoisin sen teille suoraan. ");
INSERT INTO fin_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tehän tiedätte, minne minä olen menossa ja miten sinne pääsee.» ");
INSERT INTO fin_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","»Emme me tiedä», Tuomas sanoi. »Meillä ei ole aavistustakaan siitä, minne sinä olet menossa – kuinka sitten tietäisimme, miten sinne pääsee?» ");
INSERT INTO fin_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jeesus sanoi Tuomaalle: »Minä olen tie, totuus ja elämä. Isän luo ei kukaan pääse muuten kuin tulemalla minun luokseni. ");
INSERT INTO fin_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jos olisit ymmärtänyt kuka minä olen, olisit käsittänyt myös millainen minun Isäni on. Tästä lähtien sinä tunnet hänet – olethan nähnyt hänet!» ");
INSERT INTO fin_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Silloin Filippus sanoi: »Anna meidän nähdä Isä, niin olemme tyytyväisiä.» ");
INSERT INTO fin_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jeesus vastasi: »Etkö sinä, Filippus, vielä tiedä edes kuka minä olen, vaikka olen ollut näin kauan teidän kanssanne? Jokainen, joka on nähnyt minut, on nähnyt Isän. Miksi siis pyydät saada nähdä Isän? ");
INSERT INTO fin_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Etkö usko, että minä olen Isässä ja Isä minussa? En ole itse keksinyt sitä, mitä puhun, vaan saanut sen Isältä, joka asuu minussa. Hän tekee työtään minun välitykselläni. ");
INSERT INTO fin_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Uskokaa, että minä olen Isässä ja Isä minussa. Uskokaa edes niiden suurten ihmeiden tähden, jotka olette nähneet minun tekevän. ");
INSERT INTO fin_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Totta totisesti: jokainen, joka uskoo minuun, tekee samoja tekoja kuin minä olen tehnyt – ja suurempiakin, koska menen Isän luo. ");
INSERT INTO fin_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Te voitte pyytää häneltä mitä tahansa minuun vedoten, ja minä teen sen, että Isää ylistettäisiin siitä mitä Poika tekee. ");
INSERT INTO fin_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Muistakaa: teen kaiken, mitä te minun nimeeni vedoten pyydätte! ");
INSERT INTO fin_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jos rakastatte minua, niin myös tottelette minua. ");
INSERT INTO fin_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Pyydän Isää antamaan teille toisenkin auttajan, joka ei jätä teitä koskaan. ");
INSERT INTO fin_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Hän on Pyhä Henki, ja hän johtaa teidät koko totuuteen. Useimmat ihmiset eivät ota häntä vastaan, sillä he eivät näe häntä eivätkä tunne häntä. Mutta te tunnette, sillä hän pysyy teidän luonanne ja teissä itsessänne. ");
INSERT INTO fin_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","En minä hylkää teitä enkä jätä teitä orvoiksi, vaan tulen takaisin luoksenne. ");
INSERT INTO fin_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Vain vähän aikaa enää, niin olen jo lähtenyt maailmasta, mutta silti olen lähellä teitä. Mutta palaan elämään – ja tekin saatte elää. ");
INSERT INTO fin_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Sinä päivänä te tiedätte, että olen Isässäni, te minussa ja minä teissä. ");
INSERT INTO fin_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Joka tottelee minua, myös rakastaa minua, ja koska hän minua rakastaa, Isä rakastaa häntä, ja minäkin rakastan ja ilmaisen hänelle itseni.» ");
INSERT INTO fin_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Juudas – ei Juudas Iskariot, vaan Jeesuksen toinen samanniminen oppilas, Jaakobin poika – sanoi hänelle: »Miksi ilmaiset itsesi vain meille, oppilaillesi, etkä muulle maailmalle?» ");
INSERT INTO fin_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jeesus vastasi: »Siksi, että ilmaisen itseni vain sellaiselle, joka rakastaa ja tottelee minua. Myös Isä rakastaa häntä, ja me tulemme ja jäämme hänen luokseen. ");
INSERT INTO fin_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Joka ei rakasta minua, ei voi myöskään totella minua – eikä Isääni, joka minut tänne lähetti. ");
INSERT INTO fin_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Puhun teille näistä asioista nyt kun vielä olen luonanne. ");
INSERT INTO fin_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mutta kun Isä lähettää teille auttajan, Pyhän Hengen, minun edustajanani, hän opettaa teille kaiken ja muistuttaa teitä siitä, mitä itse olen teille puhunut. ");
INSERT INTO fin_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Jätän teille lahjan: rauhan. Minun antamani rauha ei ole särkyvä kuten maailman rauha. Älkää siis kantako huolia ja pelkoja. ");
INSERT INTO fin_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Muistakaa, mitä olen teille sanonut: menen pian pois, mutta tulen vielä takaisin teidän luoksenne. Jos todella rakastatte minua, olette iloisia siitä, että menen nyt Isän luo, joka on minua suurempi. ");
INSERT INTO fin_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Olen puhunut teille edeltäpäin kaikista näistä asioista, että uskoisitte minuun, kun ne sitten tapahtuvat. ");
INSERT INTO fin_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Minulla ei ole enää tilaisuutta puhua paljoakaan teidän kanssanne, sillä nyt on pahuuden valtiaan hetki. Minuun hänellä ei ole valtaa. ");
INSERT INTO fin_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Teen vapaaehtoisesti sen, mitä Isä minulta pyytää, jotta maailma saisi tietää minun rakastavan Isää. Tulkaa, meidän täytyy nyt lähteä!» ");
INSERT INTO fin_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","»Minä olen oikea viiniköynnös, ja Isäni on puutarhuri. ");
INSERT INTO fin_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Hän leikkaa pois sellaiset oksat, jotka eivät tee hedelmiä. Hedelmiä kantavia oksia hän hoitaa: hän karsii niitä, että ne tuottaisivat suuremman sadon. ");
INSERT INTO fin_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Teitä hän on jo karsinut kaiken sen avulla, mitä minä olen teille puhunut, jotta saisitte enemmän voimaa ja minä voisin käyttää teitä paremmin. ");
INSERT INTO fin_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Eläkää yhteydessä minuun ja antakaa minun elää itsessänne. Eihän oksa voi kantaa hedelmää, jos se leikataan irti rungosta – ette siis tekään, jos teillä ei ole yhteyttä minuun. ");
INSERT INTO fin_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Niin, minä olen viiniköynnös ja te olette oksat. Joka pysyy yhteydessä minuun ja jonka elämässä minä saan vaikuttaa, se tuottaa hyvän sadon. Ilman minua ette voi tehdä mitään. ");
INSERT INTO fin_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Se, joka ei pysy yhteydessä minuun, heitetään hyödyttömänä pois. Irralliset oksat kuivuvat, ne kerätään ja poltetaan muiden roskien kanssa. ");
INSERT INTO fin_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mutta jos pysytte minun yhteydessäni ja teette mitä minä sanon, saatte pyytää mitä tahdotte, ja se annetaan teille. ");
INSERT INTO fin_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Minun todelliset oppilaani ovat kuin satoisat oksat. Heidän tähtensä ihmiset alkavat kunnioittaa Jumalaa. ");
INSERT INTO fin_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Olen rakastanut teitä samalla tavoin kuin Isä minua. Eläkää minun rakkaudessani. ");
INSERT INTO fin_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Kun noudatatte minun sanojani, elätte minun rakkaudessani – aivan niin kuin minäkin noudatan Isäni tahtoa ja elän hänen rakkaudessaan. ");
INSERT INTO fin_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Puhuin tästä sen vuoksi, että saisitte minun iloni – että se aivan täyttäisi teidät. Teidän riemullanne ei silloin ole rajoja! ");
INSERT INTO fin_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Annan teille käskyn: rakastakaa toisianne niin kuin minä teitä rakastan. ");
INSERT INTO fin_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Suurta rakkautta on se, että ihminen menee vaikka kuolemaan ystäviensä puolesta. ");
INSERT INTO fin_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Te olette minun ystäviäni, jos teette niin kuin minä sanon. ");
INSERT INTO fin_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","En nimitä teitä enää palvelijoiksi, sillä isäntä ei usko asioitaan palvelijalleen. Nyt te olette minun ystäviäni, olenhan uskonut teille kaiken, minkä Isä on uskonut minulle. ");
INSERT INTO fin_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ette te ole minua valinneet, vaan minä valitsin teidät. Valitsin teidät, jotta jatkuvasti tuottaisitte hyvää hedelmää, joka säilyy, ja että Isä antaisi teille, mitä ikinä minun nimeeni vedoten pyydättekin. ");
INSERT INTO fin_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","18","Tahdon teidän rakastavan toisianne, sillä te saatte jo yllin kyllin vihamielisyyttä osaksenne niiden taholta, jotka kääntävät minulle selkänsä. Mutta eihän se ole uutta: he vihasivat minua jo ennen kuin teitä. ");
INSERT INTO fin_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Kyllä he rakastaisivat teitä, jos te kuuluisitte heidän joukkoonsa, mutta te ette kuulu, sillä minä valitsin teidät sieltä, ja siksi he vihaavat teitä. ");
INSERT INTO fin_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Muistatteko mitä teille sanoin: ’Palvelijaa ei arvosteta enempää kuin isäntäänsä.’ Koska he siis vainosivat minua, on aivan luonnollista, että he vainoavat teitäkin. Jos he olisivat kuunnelleet minua, he kuuntelisivat teitäkin. ");
INSERT INTO fin_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mutta he vainoavat teitä, koska te kuulutte minulle. Eiväthän he tunne Jumalaa, joka minut tänne lähetti. ");
INSERT INTO fin_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","He eivät olisi syyllisiä, ellen minä olisi tullut maailmaan ja puhunut heille. Mutta nyt he eivät voi mitenkään puolustella syntiään. ");
INSERT INTO fin_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jotka vihaavat minua, vihaavat myös Isääni. ");
INSERT INTO fin_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ellen olisi tehnyt suuria ihmeitä heidän silmiensä edessä, he eivät olisi vastuussa synneistään. Mutta he näkivät nuo ihmeet ja kuitenkin vihasivat sekä minua että Isääni. ");
INSERT INTO fin_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Näin kävi toteen se ennustus, jonka profeetat lausuivat Messiaasta: ’He ovat vihanneet minua aivan syyttä.’ ");
INSERT INTO fin_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Lähetän teidän avuksenne Pyhän Hengen, joka on totuuden lähde. Hän tulee Isän luota puhumaan teille minusta. ");
INSERT INTO fin_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mutta myös teidän on kerrottava minusta kaikille ihmisille, koska olette olleet kanssani alusta saakka.» ");
INSERT INTO fin_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","»Olen puhunut tästä kaikesta, ettei mikään mitä tapahtuu, voisi horjuttaa uskoanne. ");
INSERT INTO fin_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Toiset teistä erotetaan seurakunnasta, ja sekin aika tulee, että ne, jotka tappavat teistä jonkun, kuvittelevat tekevänsä palveluksen Jumalalle. ");
INSERT INTO fin_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Hehän eivät tunne Isää eivätkä minua. ");
INSERT INTO fin_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Puhun teille tästä nyt, jotta vaikeuksiin joutuessanne muistaisitte, että valmistin teitä etukäteen. En ole maininnut siitä ennen, koska olen ollut tämän ajan teidän luonanne. ");
INSERT INTO fin_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mutta nyt menen takaisin lähettäjäni luo. Kukaan teistä ei kysy miksi – ");
INSERT INTO fin_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","te vain surette lähtöäni. ");
INSERT INTO fin_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Itse asiassa teille on kuitenkin hyväksi, että lähden, sillä jollen lähtisi, niin teidän auttajanne, Pyhä Henki, ei tulisi tänne. Jos minä menen, hän tulee – sillä minä lähetän hänet luoksenne. ");
INSERT INTO fin_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ja kun Pyhä Henki on tullut, hän näyttää maailmalle sen syntisyyden, Jumalan hyvyyden ja tuomiosta vapautumisen. ");
INSERT INTO fin_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Maailman synti on, että se ei usko minuun. ");
INSERT INTO fin_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Jumalan hyvyys on kaikkien ulottuvilla, koska minä menen Isän luo ettekä te enää näe minua. ");
INSERT INTO fin_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tuomiosta on mahdollisuus vapautua, koska saatana, kaiken pahan valtias, on jo tuomittu. ");
INSERT INTO fin_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Minulla olisi teille vielä paljon puhuttavaa, mutta te ette kuitenkaan pystyisi sitä nyt ymmärtämään. ");
INSERT INTO fin_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kun Pyhä Henki – joka on totuus – tulee, hän opettaa teitä ymmärtämään totuutta. Hänkään ei puhu omiaan, vaan välittää teille sen mitä on kuullut. Pyhä Henki paljastaa teille myös tulevaisuuden tapahtumia. ");
INSERT INTO fin_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Hän puhuu minusta: hän selvittää teille, kuka minä olen. ");
INSERT INTO fin_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Koko Isän kirkkaus on minun. Juuri tämän Pyhä Henki teille osoittaa. ");
INSERT INTO fin_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Vain hetki enää ja sitten lähden. Silloin ette enää saa nähdä minua. Mutta jonkin ajan päästä näette minut taas.» ");
INSERT INTO fin_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","»Mitä hän oikein puhuu?» jotkut oppilaat kyselivät. »Mitä tämä ’Isän luo meneminen’ on? Emme ymmärrä mitä hän tarkoittaa.» ");
INSERT INTO fin_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jeesus näki, että he olisivat halunneet kysellä häneltä ja sanoi: »Mitäkö minä tarkoitan? ");
INSERT INTO fin_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Maailma on vain iloinen nähdessään miten minulle käy, mutta te joudutte itkemään. Teidän itkunne muuttuu kuitenkin suureksi riemuksi, kun näette minut jälleen. ");
INSERT INTO fin_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Te saatte kokea samanlaista iloa kuin nainen, joka on juuri synnyttänyt lapsen: tuskan sijaan on tullut suuri riemu, ja kipu on unohtunut. ");
INSERT INTO fin_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Te olette nyt suruissanne, mutta minä näen teidät vielä, ja silloin teidät täyttää ilo, jota kukaan ei voi teiltä riistää. ");
INSERT INTO fin_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Silloin teidän ei tarvitse pyytää mitään minulta; voitte pyytää suoraan Isältä minun nimeeni vedoten, ja hän antaa teille, mitä pyydätte. ");
INSERT INTO fin_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Vielä ette ole tällä tavoin pyytäneet, mutta aloittakaa nyt: pyytäkää ja vedotkaa minun nimeeni, niin saatte. Eikä teidän riemullanne ole rajoja. ");
INSERT INTO fin_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Tähän asti olen puhunut teille varovaisesti, mutta kerran tulee aika, jolloin voin avoimesti kertoa teille Isästä. ");
INSERT INTO fin_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Silloin voitte esittää hänelle pyyntönne minun nimeeni vedoten, eikä minun tarvitse pyytää Isää täyttämään niitä. ");
INSERT INTO fin_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Isä itse rakastaa teitä, koska te rakastatte minua ja uskotte minun olevan kotoisin taivaasta. ");
INSERT INTO fin_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Minähän tulin maailmaan Isäni luota ja olen nyt menossa takaisin hänen luokseen.» ");
INSERT INTO fin_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","»Vihdoinkin puhut selvää kieltä», Jeesuksen oppilaat sanoivat. ");
INSERT INTO fin_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","»Nyt ymmärrämme, että tiedät kaiken eikä sinulle tarvitse mitään selittää. Sen vuoksi uskomme sinun tulleen Jumalan luota.» ");
INSERT INTO fin_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","»Joko te nyt uskotte?» Jeesus kysyi. ");
INSERT INTO fin_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","»Mutta aivan pian – oikeastaan nyt heti – teidän joukkonne hajotetaan. Te menette takaisin kotiinne ja jätätte minut yksin. Minä en kuitenkaan ole yksin, sillä Isä on kanssani. ");
INSERT INTO fin_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Tämän minä olen teille puhunut, että löytäisitte minussa rauhan. Te joudutte kokemaan maailmassa suuria vaikeuksia ja tuskaa, mutta olkaa levolliset ja rohkeat – minä olen voittanut maailman.» ");
INSERT INTO fin_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kun Jeesus oli lakannut puhumasta oppilailleen, hän katsoi ylöspäin ja sanoi: »Isä, nyt se hetki on tullut! Anna ihmisten nähdä, kuka Poikasi todella on, jotta hän puolestaan saisi osoittaa heille sinun suuruutesi. ");
INSERT INTO fin_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sinä olet luovuttanut jokaisen ihmisen hänen käsiinsä, ja hän antaa ikuisen elämän kaikille, jotka hän on sinulta saanut. ");
INSERT INTO fin_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ikuinen elämä on jokaisella, joka tuntee sinut – ainoan oikean Jumalan – ja Jeesuksen Kristuksen, jonka sinä lähetit. ");
INSERT INTO fin_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Olen ilmaissut ihmisille sinun rakkautesi ja suuruutesi: olen täyttänyt antamasi tehtävän. ");
INSERT INTO fin_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ja nyt, kun olen tässä edessäsi, Isä, anna ihmisten tajuta, että minulla oli jumalallinen valta-asema sinun luonasi jo ennen maailman luomista. ");
INSERT INTO fin_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Olen puhunut sinusta näille ihmisille, jotka kuuluivat maailmaan. Sinä heidät kutsuit ja annoit minulle. Itse asiassa he olivat jo sinun, mutta annoit heidät minulle. He ovat tahtoneet kuunnella sinua. ");
INSERT INTO fin_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nyt he tietävät, että kaikki mitä minulla on, on lahjaa sinulta, ");
INSERT INTO fin_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","sillä olen tuonut heille sanoman, jonka sinulta sain. He käsittivät puheeni ja tietävät nyt varmasti, että tulin maailmaan sinun luotasi. He myös uskovat sinun lähettäneen minut. ");
INSERT INTO fin_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","10","En rukoile sinua maailman puolesta, vaan näiden omiesi, jotka olet antanut minulle. Ja he kaikki – koska ovat minun – kuuluvat sinulle. Sinä olet antanut minulle heidät ja kaiken, mikä on omaasi. Sen vuoksi minä ilmaisen heille itseni. ");
INSERT INTO fin_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lähden nyt maailmasta – he jäävät. Tulen sinun luoksesi. Pyhä Isä, pidä heistä huolta, kaikista niistä, jotka minulle annoit, että hekin olisivat yhtä – niin kuin me. ");
INSERT INTO fin_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Täällä maan päällä ollessani olen pitänyt turvassa sinun ominasi kaikki ne, jotka sinulta sain. Suojelin heitä, niin ettei kukaan heistä joutunut eksyksiin – lukuun ottamatta Juudasta, tuota kadotuksen lasta, josta Raamattuun on edeltäpäin kirjoitettu. ");
INSERT INTO fin_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nyt tulen sinun luoksesi. Täällä maailmassa ollessani olen kertonut heille sinusta, että he voisivat olla iloisia täydestä sydämestään. ");
INSERT INTO fin_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Maailma vihaa niitä, joille sanomani on kelvannut, koska he eivät sopeudu tämän maailman henkeen – niin kuin en minäkään. ");
INSERT INTO fin_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","En pyydä sinua nyt ottamaan heitä pois maailmasta, vaan varjelemaan heidät joutumasta saatanan valtaan. ");
INSERT INTO fin_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Eiväthän he kuulu tähän maailmaan enempää kuin minäkään. ");
INSERT INTO fin_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Puhdista heidän sisimpänsä, osoita heille totuutesi. Se, mitä sinä sanot, on totuus. ");
INSERT INTO fin_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Lähetän heidät maailmaan niin kuin sinä lähetit minut. ");
INSERT INTO fin_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Minä vihkiydyn kuolemaan, jotta he saisivat elää sinulle omistettua elämää. ");
INSERT INTO fin_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","En rukoile vain heidän puolestaan, vaan myös kaikkien niiden, jotka uskovat minuun kuultuaan heidän todistuksensa. ");
INSERT INTO fin_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","22-23","Kaikkien puolesta pyydän, että he olisivat yhtä niin kuin sinä ja minä – niin kuin sinä olet minussa ja minä sinussa. Olen antanut heille sinulta saamani kirkkauden. Hekin saavat olla tässä yhteydessä: minä heissä ja sinä minussa – kaikki yhtä, että maailma uskoisi sinun lähettäneen minut ja rakastavan omiasi yhtä paljon kuin minua. ");
INSERT INTO fin_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Isä, haluan näiden olevan lähelläni – näiden ihmisten, jotka sinä olet minulle antanut – niin että he saavat nähdä kunniani. Sinähän sen minulle annoit, koska rakastit minua jo ennen kuin maailmaa olikaan. ");
INSERT INTO fin_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Pyhä Isä, maailma ei sinua tunne, mutta minä tunnen sinut. Nämä minun oppilaani tietävät sinun lähettäneen minut. ");
INSERT INTO fin_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Olen opettanut heitä tuntemaan sinua, jotta myös heissä olisi se rakkaus, jolla sinä minua rakastat, ja jotta minä eläisin heissä.» ");
INSERT INTO fin_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tämän puhuttuaan Jeesus lähti oppilaineen Kidronin-puron toisella puolella olevaan öljypuumetsikköön. ");
INSERT INTO fin_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kavaltaja-Juudas tiesi paikan, sillä Jeesus oli usein ollut siellä oppilaidensa kanssa. ");
INSERT INTO fin_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ylipapit ja fariseukset olivat lähettäneet Juudaksen mukana joukon sotilaita ja temppelipoliiseja. Nämä marssivat nyt metsikköön loimuavine soihtuineen ja välkähtelevine aseineen. ");
INSERT INTO fin_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jeesus tiesi mikä häntä odotti. Hän astui tulijoita vastaan ja kysyi: »Ketä etsitte?» ");
INSERT INTO fin_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","»Nasaretilaista Jeesusta», he sanoivat. »Minä se olen», Jeesus vastasi. ");
INSERT INTO fin_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kun hän näin sanoi, miehet astuivat taaksepäin ja kaatuivat maahan. ");
INSERT INTO fin_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Hän kysyi heiltä uudestaan: »Ketä etsitte?» Ja taas he vastasivat: »Nasaretilaista Jeesusta.» ");
INSERT INTO fin_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","»Minähän sanoin, että se olen minä, ja koska te kerran minua etsitte, niin antakaa näiden muiden mennä.» ");
INSERT INTO fin_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tämän Jeesus sanoi toteuttaakseen ennustuksen, jonka oli aikaisemmin sanonut: »En ole kadottanut yhtään niistä, jotka sinä, Jumala, minulle annoit.» ");
INSERT INTO fin_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Silloin Simon Pietari veti esiin miekkansa ja sivalsi korvan Malkukselta, ylipapin palvelijalta. ");
INSERT INTO fin_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Mutta Jeesus sanoi Pietarille: »Pane miekka pois. Enkö tyhjentäisi pohjaan asti sitä maljaa, jonka Isä on minulle antanut?» ");
INSERT INTO fin_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Silloin sotilaat ja heidän päällikkönsä ja temppelipoliisit pidättivät Jeesuksen ja sitoivat hänet. ");
INSERT INTO fin_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ensiksi hänet vietiin Hannaan luo. Hannas oli Kaifaan, sen vuoden ylipapin, appi. ");
INSERT INTO fin_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifas taas oli sanonut suuressa neuvostossa juutalaisten johtomiehille: »On parempi, että yksi kuolee kaikkien puolesta.» ");
INSERT INTO fin_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pietari lähti kulkemaan kiinniottajien perässä. Hänen mukanaan tuli eräs toinen oppilas, joka kuului ylipapin tuttaviin; hän pääsi Jeesuksen mukana pihaan, ");
INSERT INTO fin_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","mutta Pietarin täytyi jäädä portin ulkopuolelle. Sitten se toinen Jeesuksen oppilas puhui portinvartijana toimivalle tytölle, ja tämä päästi Pietarinkin sisään. ");
INSERT INTO fin_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tyttö kysyi Pietarilta: »Etkö sinä olekin Jeesuksen oppilaita?» »En ole!» Pietari sanoi. ");
INSERT INTO fin_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sotilaita ja talon palvelijoita värjötteli nuotion ympärillä, sillä yö oli kylmä. Pietari seisoi siellä heidän kanssaan lämmittelemässä. ");
INSERT INTO fin_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Sisällä ylipappi alkoi kysellä Jeesukselta hänen kannattajistaan ja siitä, mitä hän oli heille puhunut. ");
INSERT INTO fin_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jeesus vastasi: »Minun puheeni ovat laajalti tunnettuja, sillä olen usein puhunut julkisesti synagogassa ja temppelissä. Kaikki juutalaisten johtomiehet ovat kuulleet minua, enkä puhu kahden kesken mitään sellaista, mitä en olisi julkisestikin sanonut. ");
INSERT INTO fin_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Miksi kyselette tätä minulta? Kysykää niiltä, jotka ovat kuulleet minua! Täälläkin on joitakin sellaisia. He kyllä tietävät, mitä olen sanonut.» ");
INSERT INTO fin_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yksi lähellä seisovista sotilaista läimäytti Jeesusta korvalle. »Sillä tavallako vastataan ylipapille?» sotilas huusi. ");
INSERT INTO fin_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","»Jos valehtelin, niin osoita se», Jeesus vastasi. »Lyödäänkö ihmistä siksi, että hän sanoo totuuden?» ");
INSERT INTO fin_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Sitten Hannas lähetti Jeesuksen sidottuna ylipappi Kaifaan luo. ");
INSERT INTO fin_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Tällä välin Simon Pietari seisoi nuotiolla lämmittelemässä, ja häneltä kysyttiin taas: »Etkö sinä olekin hänen oppilaitaan?» »En varmasti», Pietari vastasi. ");
INSERT INTO fin_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mutta yksi ylipapin talon palvelijoista – sen miehen sukulainen, jolta Pietari oli lyönyt korvan – sanoi: »Minähän näin sinut siellä puutarhassa Jeesuksen kanssa!» ");
INSERT INTO fin_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pietari kielsi senkin. Ja silloin kiekui kukko. ");
INSERT INTO fin_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jeesuksen oikeudenkäynti Kaifaan edessä päättyi aamuyöllä. Sieltä hänet vietiin Rooman maaherran palatsiin. Juutalaiset eivät itse voineet tulla sisälle, sillä pakanan taloon astuminen »saastuttaisi» heidät, eivätkä he sen jälkeen saisi syödä pääsiäislammasta. ");
INSERT INTO fin_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Sen vuoksi maaherra Pilatus meni ulos heidän luokseen kysymään: »Mistä te tätä miestä syytätte? Mitä hän oikein on tehnyt?» ");
INSERT INTO fin_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","»Eihän häntä olisi pidätetty, ellei hän olisi rikollinen!» he sinkosivat vastaan. ");
INSERT INTO fin_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","»Viekää hänet sitten mukananne ja tuomitkaa itse omien lakienne mukaan», Pilatus sanoi. »Mutta me haluamme, että hänet ristiinnaulitaan, ja siihen tarvitaan sinun suostumuksesi», juutalaiset vastasivat. ");
INSERT INTO fin_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Näin täyttyi Jeesuksen ennustus siitä tavasta, jolla hänet surmattaisiin. ");
INSERT INTO fin_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatus meni takaisin palatsiin ja käski tuoda Jeesuksen eteensä. »Oletko sinä juutalaisten kuningas?» hän kysyi Jeesukselta. ");
INSERT INTO fin_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","»Itsekö näin ajattelet vai ovatko muut sanoneet sinulle niin?» Jeesus kysyi. ");
INSERT INTO fin_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","»Enhän minä ole juutalainen!» Pilatus tiuskaisi. »Oma kansasi ja ylipapit toivat sinut tänne. Mitä olet tehnyt?» ");
INSERT INTO fin_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Siihen Jeesus sanoi: »Minun kuninkuuteni ei ole maallista kuninkuutta. Jos se olisi, kannattajani olisivat nousseet vastarintaan, kun juutalaisten johtomiehet lähettivät pidättämään minua.» ");
INSERT INTO fin_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatus vastasi: »Olet siis kuitenkin kuningas?» »Olen», Jeesus sanoi. »Olen kuningas. Sitä varten olen syntynyt. Tulin tuomaan maailmalle totuuden. Kaikki ne, jotka rakastavat totuutta, kuuntelevat minua.» ");
INSERT INTO fin_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","»Mikä oikein on totuus?» Pilatus huudahti. Sitten hän meni jälleen ulos kansanjoukon luo ja sanoi: »Ei hän ole syyllistynyt mihinkään rikokseen. ");
INSERT INTO fin_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mutta koska on tapana joka pääsiäinen vapauttaa yksi vanki, niin jos haluatte, päästän vapaaksi ’juutalaisten kuninkaan’.» ");
INSERT INTO fin_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Siihen kansanjoukko huusi: »Ei, ei häntä! Päästä Barabbas!» Barabbas oli tunnettu kapinallinen ja murhaaja. ");
INSERT INTO fin_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilatus luovutti Jeesuksen sotamiestensä ruoskittavaksi. ");
INSERT INTO fin_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nämä tekivät kruunun orjantappuroista ja panivat sen Jeesuksen päähän. Hänen hartioilleen he panivat purppuranpunaisen viitan. ");
INSERT INTO fin_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","»Terve, juutalaisten kuningas!» he pilkkasivat ja löivät häntä nyrkillä. ");
INSERT INTO fin_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus meni jälleen ulos ja sanoi juutalaisille: »Tuon hänet nyt tänne, mutta teidän on käsitettävä, että pidän häntä syyttömänä.» ");
INSERT INTO fin_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sitten Jeesus tuli ulos piikkikruunu päässä ja purppuraviitta yllä. Pilatus sanoi: »Katsokaa tätä ihmistä!» ");
INSERT INTO fin_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Heti Jeesuksen nähdessään ylipapit ja temppelipoliisit alkoivat huutaa: »Ristiinnaulitse! Ristinnaulitse!» »Teidän se on tehtävä», Pilatus totesi. »Minä sanon, että hän ei ole syyllinen.» ");
INSERT INTO fin_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Syyttäjät vastasivat: »Meidän lakimme mukaan hänen on kuoltava, koska hän sanoo olevansa Jumalan Poika.» ");
INSERT INTO fin_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Tämän kuullessaan Pilatus säikähti entistä pahemmin. ");
INSERT INTO fin_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Hän vei Jeesuksen takaisin palatsiin ja kysyi: »Mistä olet kotoisin?» Jeesus ei vastannut. ");
INSERT INTO fin_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","»Miksi et sano mitään?» Pilatus kysyi. »Etkö tajua, että minun vallassani on, vapautetaanko vai ristiinnaulitaanko sinut?» ");
INSERT INTO fin_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Silloin Jeesus sanoi: »Sinulla ei olisi mitään valtaa minuun, ellei Jumala olisi antanut sitä sinulle. Niinpä ne, jotka toivat minut eteesi, ovat tehneet suuremman synnin kuin sinä.» ");
INSERT INTO fin_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus yritti saada Jeesuksen vapaaksi syytteestä, mutta johtavat juutalaiset sanoivat hänelle: »Jos päästät tämän miehen vapaaksi, et ole keisarin ystävä. Sellainen ihminen, joka julistaa itsensä kuninkaaksi, on kapinassa keisaria vastaan.» ");
INSERT INTO fin_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tämän kuultuaan Pilatus toi taas Jeesuksen ulos ja istuutui kivetyllä korokkeella olevalle tuomarinistuimelle. ");
INSERT INTO fin_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pääsiäispäivän aatto oli silloin jo puolessa. Pilatus sanoi juutalaisille: »Tässä teidän kuninkaanne!» ");
INSERT INTO fin_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","»Vie pois!» he huusivat. »Hänet on tapettava – ristiinnaulittava!» »Teidän kuninkaanneko minun pitäisi ristiinnaulita?» Pilatus kysyi. »Ei meillä kuningasta ole, vaan keisari», huusivat ylipapit. ");
INSERT INTO fin_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Silloin Pilatus luovutti Jeesuksen ristiinnaulittavaksi. ");
INSERT INTO fin_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Viimeinkin hän oli heidän käsissään. Hänet vietiin kaupungin ulkopuolelle. Itse hän sai kantaa ristinsä paikalle, jota kutsuttiin »Pääkalloksi», heprean kielellä Golgataksi. ");
INSERT INTO fin_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Siellä hänet naulittiin ristiin. Samalla kertaa ristiinnaulittiin kaksi muutakin, joiden ristit nostettiin Jeesuksen kummallekin puolelle. ");
INSERT INTO fin_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus kiinnitytti Jeesuksen pään yläpuolelle kilven, jossa luki: »Jeesus Nasaretilainen, juutalaisten kuningas». ");
INSERT INTO fin_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ristiinnaulitsemispaikka oli lähellä kaupunkia, ja sanat oli kirjoitettu hepreaksi, latinaksi ja kreikaksi, joten monet lukivat ne. ");
INSERT INTO fin_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ylipapit sanoivat sen tähden Pilatukselle: »Kirjoitus on muutettava kuulumaan: – ei ’juutalaisten kuningas’ vaan – ’Hän sanoi: minä olen juutalaisten kuningas’.» ");
INSERT INTO fin_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatus vastasi: »Minkä kirjoitin, sen kirjoitin, eikä sitä muuteta.» ");
INSERT INTO fin_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","24","Kun sotilaat – heitä oli neljä – olivat ristiinnaulinneet Jeesuksen, he jakoivat keskenään hänen vaatteensa. Saumattomaksi kudottua paitaa he eivät kuitenkaan leikanneet rikki. »Heitetään arpaa ja katsotaan kuka sen saa», he tuumivat. Näin toteutui se raamatunkohta, jossa sanotaan: »He jakoivat keskenään vaatteeni ja heittivät puvustani arpaa.» ");
INSERT INTO fin_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lähellä ristiä seisoivat Maria, Jeesuksen äiti, Jeesuksen täti Salome, Maria, Kloopaan vaimo, ja Magdalasta kotoisin oleva Maria. ");
INSERT INTO fin_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kun Jeesus näki äitinsä ja rakkaan oppilaansa, hän sanoi Marialle: »Hän pitää sinusta huolta.» ");
INSERT INTO fin_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ja oppilaalleen hän sanoi: »Pidä huolta äidistäni.» Sen jälkeen tämä oppilas otti Marian kotiinsa asumaan. ");
INSERT INTO fin_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jeesus tiesi, että kaikki oli nyt loppuun suoritettu, ja hän sanoi niin kuin Raamattu oli ennustanut: »Minun on jano.» ");
INSERT INTO fin_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Paikalla oli hapanviiniastia, ja joku kastoi siihen sienen, jonka sitten ojensi kepin päässä ylös Jeesuksen huulille. ");
INSERT INTO fin_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Otettuaan vähän hapanviiniä Jeesus sanoi: »Nyt olen täyttänyt tehtäväni.» Sen jälkeen hän kumarsi päänsä ja antoi henkensä. ");
INSERT INTO fin_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Juutalaisten johtomiehet eivät halunneet tuomittujen olevan ristillä enää seuraavana päivänä, sillä se oli sapatti (ja vielä tavallista suurempi juhlapäivä – pääsiäinen). Sen vuoksi he pyysivät Pilatusta antamaan määräyksen murtaa ristiinnaulittujen sääriluut, jotta miehet kuolisivat nopeammin ja heidän ruumiinsa voitaisiin ottaa alas ristiltä. ");
INSERT INTO fin_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Sotilaat tulivat ja katkaisivat ensin ristiinnaulittujen rikollisten sääriluut. ");
INSERT INTO fin_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tullessaan Jeesuksen kohdalle he näkivät hänen jo kuolleen eivätkä katkaisseet hänen sääriluitaan. ");
INSERT INTO fin_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Yksi sotilaista pisti kuitenkin varmuuden vuoksi keihäällä hänen kylkeensä, jolloin siitä vuoti verta ja vettä. ");
INSERT INTO fin_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Tämän silminnäkijä on itse selostanut kaiken tarkasti sitä varten, että tekin uskoisitte. ");
INSERT INTO fin_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Siinä, mitä sotilaat tekivät, toteutui raamatunkohta: »Yhtään hänen luutaan ei rikota», ");
INSERT INTO fin_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ja: »He katsovat häneen, jonka ovat lävistäneet.» ");
INSERT INTO fin_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Arimatiasta kotoisin oleva Joosef, joka oli – juutalaisten johtomiehiä peläten – salaa kuulunut Jeesuksen oppilaisiin, meni rohkeasti pyytämään Pilatukselta lupaa ottaa Jeesuksen ruumiin alas ristiltä. Pilatus antoi luvan, ja Joosef laski ruumiin alas. ");
INSERT INTO fin_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Silloin ilmaantui paikalle myös Nikodeemus, joka aikoinaan oli tullut yöllä Jeesuksen luo. Hänellä oli mukanaan kolmisenkymmentä kiloa voidetta, joka oli valmistettu mirhasta ja aloesta. ");
INSERT INTO fin_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Yhdessä miehet käärivät Jeesuksen ruumiin pitkään liinavaatteeseen, jonka he juutalaisten hautaustavan mukaan kyllästivät noilla hyvänhajuisilla voiteilla. ");
INSERT INTO fin_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ristiinnaulitsemispaikkaa lähellä oli puutarha, jossa oli vielä käyttämätön hautakammio. ");
INSERT INTO fin_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Koska oli kiire saada hautaaminen suoritetuksi ennen sapatin alkua ja hauta oli lähellä, Jeesuksen ruumis pantiin siihen. ");
INSERT INTO fin_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sunnuntaiaamuna niin varhain, että vielä oli pimeää, Maria Magdaleena tuli hautakammion luo ja huomasi, että sen suulla ollut kivi oli vieritetty syrjään. ");
INSERT INTO fin_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Hän meni kiireesti Pietarin ja tämän ystävän, Jeesuksen läheisimmän oppilaan, luo. »Herran ruumis on viety pois haudasta – en tiedä, mihin!» Maria ilmoitti. ");
INSERT INTO fin_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Molemmat miehet ryntäsivät haudalle. ");
INSERT INTO fin_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Juostessa Pietari jäi jälkeen, ja hänen ystävänsä pääsi ensin perille, ");
INSERT INTO fin_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","kumartui katsomaan sisään hautaan ja näki käärinliinat. Hän ei kuitenkaan mennyt sisälle. ");
INSERT INTO fin_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Silloin Pietarikin tuli siihen, ja hän astui sisälle hautakammioon. Hänkin näki käärinliinat ");
INSERT INTO fin_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ja sivummalla, kokoon käärittynä, Jeesuksen päätä peittäneen kankaan. ");
INSERT INTO fin_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Silloin toinenkin oppilas meni sisään hautakammioon, näki tyhjät käärinliinat – ja uskoi, että Jeesus oli noussut kuolleista! ");
INSERT INTO fin_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Siihen hetkeen asti he eivät olleet ymmärtäneet Raamatun ilmoittaneen, että Jeesus nousisi kuolleista. ");
INSERT INTO fin_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Oppilaat palasivat haudalta kotiinsa. ");
INSERT INTO fin_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Sillä aikaa Maria oli tullut takaisin haudalle. Hän seisoi sen ulkopuolella ja itki. Lopulta hän kumartui katsomaan sisälle hautakammioon ");
INSERT INTO fin_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ja näki kahden valkopukuisen enkelin istuvan – toisen pääpuolessa ja toisen jalkapuolessa – siinä missä Jeesuksen ruumis oli ollut. ");
INSERT INTO fin_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","»Mitä sinä itket?» enkelit kysyivät Marialta. »Koska Herrani on viety pois», hän vastasi, »enkä tiedä mihin hänet on pantu.» ");
INSERT INTO fin_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maria vilkaisi olkapäänsä yli ja näki jonkun seisovan takanaan. Se oli Jeesus, mutta Maria ei tuntenut häntä. ");
INSERT INTO fin_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","»Miksi itket?» hän kysyi Marialta. »Ketä etsit?» Maria luuli Jeesusta puutarhuriksi. »Jos olet vienyt hänet täältä pois, sano minulle minne, niin minä otan hänet», Maria pyysi. ");
INSERT INTO fin_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","»Maria!» Jeesus sanoi. Maria kääntyi katsomaan. »Mestari!» hän huudahti. ");
INSERT INTO fin_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","»Älä koske minuun», Jeesus varoitti, »sillä en ole vielä palannut Isän luo. Mutta mene kertomaan veljilleni, että minä palaan Isäni luo, joka on myös teidän Isänne – minun Jumalani ja teidän Jumalanne.» ");
INSERT INTO fin_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria Magdaleena löysi Jeesuksen oppilaat ja vakuutti heille: »Minä olen nähnyt Herran!» Hän kertoi myös, minkä sanoman Jeesus oli käskenyt heille tuoda. ");
INSERT INTO fin_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Myöhään samana iltana Jeesuksen oppilaat olivat koolla lukittujen ovien takana, koska he pelkäsivät juutalaisten johtomiehiä. Yhtäkkiä Jeesus seisoi heidän keskellään. Ensin hän tervehti heitä sanoen: »Rauha teille», ");
INSERT INTO fin_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ja näytti sitten heille kätensä ja kylkensä. Oppilaat olivat riemuissaan, kun näkivät Herransa. ");
INSERT INTO fin_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Hän jatkoi: »Niin kuin Isä on lähettänyt minut, samoin minä lähetän teidät.» ");
INSERT INTO fin_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sitten hän puhalsi heihin päin ja sanoi: »Ottakaa vastaan Pyhä Henki. ");
INSERT INTO fin_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Hänen valtuuttamanaan te saatte julistaa ihmisille, että heidän syntinsä ovat anteeksi annetut – ja minä todella annan heille anteeksi. Häneltä teillä on myös valtuus tarvittaessa kieltäytyä julistamasta syntejä anteeksi annetuiksi. Silloin minä en anna niitä anteeksi.» ");
INSERT INTO fin_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Yksi Jeesuksen oppilaista, Tuomas, jota sanottiin Kaksoseksi, ei ollut toisten kanssa silloin kun Jeesus kävi. ");
INSERT INTO fin_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","He yrittivät vakuuttaa hänelle: »Me todella näimme Herran», mutta Tuomas sanoi: »En usko sitä, ellen näe naulanjälkiä hänen käsissään – ja kosketa niitä ja pane kättäni hänen kylkeensä.» ");
INSERT INTO fin_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kahdeksan päivää myöhemmin nämä miehet olivat jälleen yhdessä, ja tällä kertaa Tuomas oli heidän kanssaan. Ovet olivat lukossa, mutta yhtäkkiä, aivan niin kuin aikaisemminkin, Jeesus seisoi keskellä huonetta ja tervehti heitä. ");
INSERT INTO fin_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ja hän sanoi Tuomaalle: »Pane sormesi käsiini. Paina kätesi kylkeeni. Älä ole enää epäuskoinen, vaan usko!» ");
INSERT INTO fin_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","»Sinä olet minun Herrani ja Jumalani!» Tuomas huudahti. ");
INSERT INTO fin_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jeesus sanoi hänelle: »Sinä uskot, koska sait nähdä minut. Mutta onnellisia ne, jotka eivät ole minua nähneet ja kuitenkin uskovat.» ");
INSERT INTO fin_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jeesuksen oppilaat näkivät hänen tekevän vielä paljon muita ihmeitä niiden lisäksi, joista tässä kirjassa on kerrottu. ");
INSERT INTO fin_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Näistä on kirjoitettu siksi, että tekin uskoisitte hänen olevan Messias, Jumalan Poika, ja että saisitte häneen uskomalla ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Myöhemmin Jeesus näyttäytyi jälleen oppilailleen Genesaretin rannalla. ");
INSERT INTO fin_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Siellä oli Simon Pietari, Tuomas, Kaksoseksi kutsuttu, Natanael Galilean Kaanasta, Sebedeuksen pojat Jaakob ja Johannes ja pari muuta oppilasta. ");
INSERT INTO fin_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Pietari sanoi: »Minä lähden kalaan.» »Me tulemme mukaan», kaikki sanoivat. Sinä yönä he eivät kuitenkaan saaneet mitään. ");
INSERT INTO fin_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Aamun sarastaessa he näkivät jonkun seisovan rannalla, mutta eivät erottaneet kuka se oli. ");
INSERT INTO fin_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Mies huusi: »Saitteko kalaa, ystävät?» »Emme saaneet», he vastasivat. ");
INSERT INTO fin_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Silloin hän sanoi: »Heittäkää verkko veneen oikealle puolelle, niin saatte suuren saaliin.» He tekivät niin eivätkä jaksaneet vetää verkkoa veneeseen – sillä se oli täynnä kaloja. ");
INSERT INTO fin_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Silloin Pietarin toveri sanoi: »Se on Herra!» Sen kuullessaan Simon Pietari vetäisi viitan päälleen, hyppäsi veteen ja lähti kohti rantaa. ");
INSERT INTO fin_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Muut jäivät veneeseen ja vetivät täyttä verkkoa maihin, jonne oli matkaa noin sata metriä. ");
INSERT INTO fin_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Kun he pääsivät rantaan, sinne oli tehty nuotio. Hiilloksella oli paistumassa kalaa, ja vieressä oli leipää. ");
INSERT INTO fin_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","»Tuokaa nyt muutama kala, niitä jotka juuri saitte», Jeesus sanoi – sillä hän se oli. ");
INSERT INTO fin_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pietari kahlasi vetämään verkkoa maalle. Se oli täynnä. Hän laski siinä 153 suurta kalaa, eikä verkko ollut kuitenkaan repeytynyt. ");
INSERT INTO fin_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","»Tulkaa syömään», Jeesus sanoi. Kukaan oppilaista ei uskaltanut kysyä, oliko hän todella Herra, sillä he ymmärsivät, että hän se oli. ");
INSERT INTO fin_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Sitten hän tarjosi vuorotellen jokaiselle heille leipää ja kalaa. ");
INSERT INTO fin_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tämä oli kolmas kerta, kun Jeesus näyttäytyi oppilailleen ylösnousemuksensa jälkeen. ");
INSERT INTO fin_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Kun oli syöty, Jeesus kysyi Simon Pietarilta: »Simon, Johanneksen poika, rakastatko sinä minua enemmän kuin nämä toiset?» »Rakastan», Pietari vastasi. »Tiedäthän sinä, että olen ystäväsi.» »Huolehdi sitten laumani pienimmistä», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jeesus toisti kysymyksensä: »Simon, Johanneksen poika, rakastatko sinä minua koko sydämestäsi?» »Rakastan, Herra», Pietari sanoi. »Sinä tiedät kyllä, että olen ystäväsi.» »Pidä huolta lampaistani», Jeesus sanoi. ");
INSERT INTO fin_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Vielä kerran hän kysyi Pietarilta: »Simon, Johanneksen poika, olenko minä sinulle kaikkein tärkein?» Pietari jo melkein pahastui, kun Jeesus vielä kolmannen kerran kysyi samaa asiaa, ja vastasi: »Herra, sinä tunnet minut sydämen pohjia myöten – tiedät itse, että olet minulle kaikki kaikessa.» Jeesus sanoi: »Hoida minun lampaitani. ");
INSERT INTO fin_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nuorempana voit tehdä mitä tahdoit ja mennä minne halusit. Mutta kun vanhenet, ojennat kätesi ja toiset vievät sinut minne et halua mennä.» ");
INSERT INTO fin_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jeesus sanoi tämän ilmoittaakseen, miten Pietari kuolisi ja kuolemallaan todistaisi Jumalan voiman suuruudesta. Sitten Jeesus sanoi hänelle: »Anna minun johtaa itseäsi.» ");
INSERT INTO fin_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pietari kääntyi ja näki, että heidän perässään tuli se oppilas, jota Jeesus erityisesti rakasti, se, joka oli kumartunut illallispöydässä kysymään Jeesukselta: »Mestari, kuka meistä sinut kavaltaa?» ");
INSERT INTO fin_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pietari kysyi Jeesukselta: »Miten hänen käy, Herra? Millä tavalla hän kuolee?» ");
INSERT INTO fin_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jeesus vastasi: »Jos tahdon, että hän on elossa vielä silloin kun palaan, se on minun asiani – kulje sinä minun askelissani.» ");
INSERT INTO fin_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Siten Kristukseen uskovien keskuuteen levisi sellainen huhu, että tuo oppilas ei ollenkaan kuolisi. Mutta ei Jeesus niin sanonut. Hän sanoi vain: »Jos tahdon, että hän on elossa vielä silloin kun palaan, se on minun asiani.» ");
INSERT INTO fin_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Se oppilas olen minä! Olen itse nähnyt nämä tapahtumat ja kirjoittanut ne tähän. On yleisesti tunnettua, että kirjoittamani on totta. ");
INSERT INTO fin_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ja luulen, että jos kaikki Jeesuksen elämän tapahtumat kirjoitettaisiin muistiin, tuskin koko maailmaan mahtuisi niin paljon kirjoja!");
INSERT INTO fin_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Hyvä Jumalaa rakastava ystäväni Kerroin sinulle ensimmäisessä kirjeessäni, miten Jeesus eli ja opetti. Ennen taivaaseen paluutaan hän antoi lähimmille miehilleen Pyhältä Hengeltä saamansa ohjeet. ");
INSERT INTO fin_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kuolemansa jälkeisten neljänkymmenen päivän aikana hän näyttäytyi heille useita kertoja ja osoitti eri tavoin todellakin olevansa itse ilmielävänä heidän edessään. Tällöin hän kertoi heille myös Jumalan valtakunnasta. ");
INSERT INTO fin_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Erään tapaamisen yhteydessä Jeesus käski oppilaidensa pysyä Jerusalemissa siihen asti, kunnes saisivat Isän lupaaman Pyhän Hengen. Jeesus oli keskustellut tästä aikaisemminkin heidän kanssaan. ");
INSERT INTO fin_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Hän muistutti heitä: »Johannes kastoi vedellä, mutta muutaman päivän kuluttua teidät kastetaan Pyhällä Hengellä.» ");
INSERT INTO fin_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Toisella kertaa oppilaat kysyivät häneltä: »Herra, aiotko nyt vapauttaa Israelin Rooman vallasta ja tehdä meistä itsenäisen kansan?» ");
INSERT INTO fin_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Hän vastasi: »Isä hoitaa sellaiset asiat, eikä teidän tarvitse tietää päivämääriä. ");
INSERT INTO fin_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mutta kun Pyhä Henki tulee teihin, saatte voiman julistaa minun kuolemaani ja ylösnousemustani ensin Jerusalemissa, koko Juudeassa, Samariassa ja sitten kaikkialla maailmassa.» ");
INSERT INTO fin_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kun hän oli sen sanonut, hänet otettiin oppilaiden silmien edestä taivaaseen, ja pilvi peitti hänet. ");
INSERT INTO fin_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","He jäivät tuijottamaan hänen jälkeensä nähdäkseen hänestä vielä edes vilauksen. Yhtäkkiä heidän edessään seisoi kaksi valkopukuista miestä, jotka sanoivat: ");
INSERT INTO fin_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","»Galilean miehet, miksi seisotte siinä ja katselette taivaalle? Jeesus on mennyt taivaaseen, mutta hän tulee sieltä kerran samalla tavalla takaisin.» ");
INSERT INTO fin_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tämä tapahtui Öljymäellä, runsaan kilometrin päässä Jerusalemista. Oppilaat palasivat sieltä kaupunkiin. ");
INSERT INTO fin_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","14","He rukoilivat usein erään talon yläkerrassa, johon olivat majoittuneet. Kokouksiin osallistuivat Pietari, Johannes, Jaakob, Andreas, Filippus, Tuomas, Bartolomeus, Matteus, Alfeuksen poika Jaakob, vapautusliikkeen mies Simon, Jaakobin poika Juudas sekä Jeesuksen veljet. Läsnä oli myös joitakin naisia, muiden muassa Jeesuksen äiti, Maria. ");
INSERT INTO fin_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kun yhdessäoloa oli jatkunut monta päivää, oli kerran koolla sata kaksikymmentä henkeä. Silloin Pietari nousi puhumaan heille: ");
INSERT INTO fin_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","»Hyvät ystävät, oli välttämätöntä, että Juudasta koskeneet Raamatun sanat toteutuivat. Pyhä Henki paljasti jo kauan sitten Kuningas Daavidin välityksellä, että Juudas pettäisi Jeesuksen ja opastaisi kiinniottajat tämän luokse. ");
INSERT INTO fin_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Juudas oli valittu apostoliksi niin kuin mekin. ");
INSERT INTO fin_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Hän osti pellon niillä rahoilla, jotka sai petoksestaan. Siellä hän kaatui suin päin maahan ja loukkaantui niin, että hänen sisälmyksensä pursuivat ulos. ");
INSERT INTO fin_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalemilaiset kuulivat pian uutisen hänen kuolemastaan ja alkoivat nimittää paikkaa Veripelloksi. ");
INSERT INTO fin_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Psalmeissaanhan kuningas Daavid sanoo: ’Tulkoon hänen kotinsa asumattomaksi’ ja ’annettakoon hänen paikkansa jollekin toiselle’. ");
INSERT INTO fin_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Meidän on nyt valittava Juudaksen tilalle joku toinen todistamaan Jeesuksen ylösnousemuksesta. Tehtävään tarvitaan mies, joka on ollut mukanamme koko Jeesuksen julkisen toiminnan ajan – siitä päivästä, jona Johannes hänet kastoi, siihen päivään, jona hänet otettiin luotamme takaisin taivaaseen.» ");
INSERT INTO fin_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ehdolle asetettiin kaksi miestä: Joosef, jota sanottiin Justukseksi tai Barsabbaaksi, ja Mattias. ");
INSERT INTO fin_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Sitten rukoiltiin yhdessä, että valinta osuisi oikeaan mieheen: »Herra, sinä tunnet jokaisen sydämen. Näytä meille, kumman näistä miehistä olet valinnut apostoliksi Juudaksen tilalle, joka pettäjänä joutui omaan paikkaansa.» ");
INSERT INTO fin_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Arvan perusteella valittiin Mattias kahdenneksitoista apostoliksi. ");
INSERT INTO fin_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nyt oli kulunut seitsemän viikkoa Jeesuksen kuolemasta ja ylösnousemuksesta, ja tuli helluntaipäivä. Kun Jeesukseen uskovat olivat kokoontuneet yhteen, ");
INSERT INTO fin_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","he kuulivat äkkiä yläpuoleltaan kuin kovan tuulen huminaa. Humina täytti koko talon, ");
INSERT INTO fin_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ja näytti siltä, kuin tulenliekkejä olisi laskeutunut heidän jokaisen päälle. ");
INSERT INTO fin_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kaikki täyttyivät Pyhällä Hengellä ja alkoivat puhua kielillä, joita eivät ennestään osanneet. Pyhä Henki antoi heille tällaisen kyvyn. ");
INSERT INTO fin_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Jerusalemiin oli tullut Jumalaa kunnioittavia juutalaisia joka puolelta maailmaa. ");
INSERT INTO fin_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kun ihmiset kuulivat oudon huminan, he lähtivät juoksemaan taloa kohti nähdäkseen, mitä siellä tapahtui. He hämmästyivät, kun kuulivat Jeesuksen oppilaiden puhuvan heidän omaa äidinkieltään. ");
INSERT INTO fin_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","»Miten tämä on mahdollista?» he ihmettelivät. »Nämähän ovat kaikki galilealaisia, ");
INSERT INTO fin_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ja kuitenkin kuulemme heidän puhuvan niiden maiden kieliä, joista olemme kotoisin! ");
INSERT INTO fin_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Olemme Partiasta, Meediasta ja Eelamista, Mesopotamiasta, Juudeasta ja Kappadokiasta, Pontoksesta ja Vähästä-Aasiasta, ");
INSERT INTO fin_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frygiasta ja Pamfyliasta, Egyptistä ja Libyan kyreneläiseltä alueelta. Jotkut juutalaiset tai uskoomme kääntyneet ovat tulleet käymään täällä Roomasta asti, ");
INSERT INTO fin_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","toiset ovat kreetalaisia tai arabialaisia. Kaikki me kuulemme noiden miesten kertovan omalla kielellämme Jumalan suurista ihmeistä!» ");
INSERT INTO fin_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","He kuuntelivat hämmästyneinä ja kyselivät toisiltaan: »Mitä tämä oikein on?» ");
INSERT INTO fin_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mutta jotkut naureskelivat: »Humalassa he vain ovat!» ");
INSERT INTO fin_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Silloin Pietari ja muut apostolit astuivat esiin, ja Pietari huusi väkijoukolle: »Kuulkaa, hyvät vieraat ja jerusalemilaiset! ");
INSERT INTO fin_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Luulette, että nämä ihmiset ovat humalassa, mutta se ei ole totta. Nythän on aamu, kello on vasta yhdeksän. ");
INSERT INTO fin_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Profeetta Jooel ennusti tämänaamuisen tapahtuman jo satoja vuosia sitten: ");
INSERT INTO fin_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","’Viimeisinä päivinä annan Pyhän Henkeni ihmiskunnalle’, Jumala sanoo. ’Silloin poikanne ja tyttärenne ennustavat, nuoret miehet saavat näkyjä ja vanhat miehet näkevät unia. ");
INSERT INTO fin_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kaikkiin palvelijoihini, sekä miehiin että naisiin, tulee Pyhä Henki, ja he profetoivat. ");
INSERT INTO fin_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Annan näkyä avaruudessa ja maassa outoja merkkejä: verta, tulta ja savupilviä. ");
INSERT INTO fin_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Aurinko muuttuu mustaksi ja kuu verenpunaiseksi, ennen kuin suuri Herran päivä tulee. ");
INSERT INTO fin_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Mutta jokainen, joka pyytää apua Herralta, pelastuu.’ ");
INSERT INTO fin_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Kuulkaa, Israelin miehet! Jumala on julkisesti osoittanut hyväksyvänsä Jeesus Nasaretilaisen antamalla hänelle vallan tehdä suuria ihmeitä, niin kuin tiedätte. ");
INSERT INTO fin_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jumala myös toteutti suunnitelmansa loppuun asti: hän salli teidän teloittaa Jeesuksen Rooman viranomaisten avulla. ");
INSERT INTO fin_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sitten Jumalan vapautti hänet kuoleman kauhuista ja herätti eloon, sillä eihän kuolema voinut pitää sellaista miestä otteessaan. ");
INSERT INTO fin_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kuningas Daavid viittasi juuri Jeesukseen sanoessaan: ’Tiedän, että Herra on aina kanssani. Hän auttaa minua. Jumalan suunnaton voima on tukenani. ");
INSERT INTO fin_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ei ihme, että sydämeni on iloa täynnä ja kieleni ylistää häntä! Tiedän, että minun käy kuollessani hyvin. ");
INSERT INTO fin_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Sinä et anna sieluni mennä kadotukseen etkä pyhän Poikasi ruumiin maatua. ");
INSERT INTO fin_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Annat minun palata elämään ja elää lähelläsi täynnä iloa.’ ");
INSERT INTO fin_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ajatelkaa, rakkaat veljet! Daavid ei tarkoittanut näillä sanoilla itseään, sillä hän kuoli ja hänen hautansa tunnetaan yhä. ");
INSERT INTO fin_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Mutta hän oli profeetta ja tiesi, että Jumala oli vannonut Messiaan olevan hänen oma jälkeläisensä ja istuvan hänen valtaistuimellaan. ");
INSERT INTO fin_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Hän näki tulevaisuuteen ja sanoi, ettei Messiaan sielu jäisi tuonelaan eikä ruumis maatuisi, vaan että hän heräisi kuolleista. ");
INSERT INTO fin_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Daavid puhui Jeesuksesta, ja me kaikki voimme todistaa, että Jeesus nousi kuolleista. ");
INSERT INTO fin_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nyt hän istuu kunniapaikalla taivaassa Jumalan luona. Isä on lähettänyt lupaamansa Pyhän Hengen, jonka nyt näette ja kuulette toimivan. ");
INSERT INTO fin_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Daavid ei puhunut itsestään, sillä ei hän ole noussut taivaaseen. Sen sijaan hän kirjoittaa: ’Jumala puhui Messiaalle, Herralleni, ja pyysi häntä istumaan viereensä kunniapaikalle ");
INSERT INTO fin_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","odottamaan, kunnes kukistaisi hänen vihollisensa täydellisesti.’ ");
INSERT INTO fin_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tulkoon siis jokaiselle israelilaiselle selväksi, että Jumala on tehnyt Herran ja Messiaan tästä Jeesuksesta, jonka te teloititte ristillä.» ");
INSERT INTO fin_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pietarin puhe kosketti kuulijoita syvästi, ja he kysyivät häneltä ja muilta apostoleilta: »Kuulkaa, hyvät veljet, mitä meidän oikein pitäisi tehdä?» ");
INSERT INTO fin_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pietari vastasi: »Jokaisen teistä on käännyttävä synnistä, palattava Jumalan luo ja otettava kaste Jeesuksen nimeen. Jumala antaa teille syntinne anteeksi ja lahjoittaa teille Pyhän Hengen. ");
INSERT INTO fin_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kristushan lupasi tämän lahjan kaikille teille, teidän lapsillenne ja eri maissa asuville ihmisille, jotka Jumala kutsuu.» ");
INSERT INTO fin_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pietari kertoi vielä paljon muutakin Jeesuksesta ja kehotti vakavasti: »Antakaa pelastaa itsenne tämän pahan ajan keskeltä.» ");
INSERT INTO fin_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ne, jotka uskoivat Pietarin puheen, kastettiin; heitä oli noin kolmetuhatta. ");
INSERT INTO fin_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","He osallistuivat sitten muiden uskovien kanssa säännöllisesti apostolien antamaan opetukseen, yhteisiin aterioihin, joilla murrettiin leipää, sekä rukoushetkiin. ");
INSERT INTO fin_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kunnioituksen ja pelonsekaisin tuntein ihmiset seurasivat apostolien ihmetekoja. ");
INSERT INTO fin_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jeesukseen uskovat olivat yhdessä ja jakoivat keskenään omaisuutensa. ");
INSERT INTO fin_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","He myivät maatilansa, ja yhteisistä varoista kukin sai mitä tarvitsi. ");
INSERT INTO fin_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","He kokoontuivat joka päivä säännöllisesti temppeliin jumalanpalvelukseen, mursivat leipää kodeissa pieninä ryhminä ja nauttivat yhteiset ateriansa iloisina ja kiitollisina. ");
INSERT INTO fin_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Koko kaupunki piti heistä, ja joka päivä Jumala lisäsi uusia pelastuneita heidän joukkoonsa. ");
INSERT INTO fin_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Eräänä iltapäivänä Pietari ja Johannes olivat menossa temppeliin kello kolmen rukoushetkeen. ");
INSERT INTO fin_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kadulla kannettiin juuri silloin miestä, joka oli syntymästään asti ollut liikuntakyvytön. Hänet laskettiin – niin kuin aina – Kauniin portin luo kerjäämään. ");
INSERT INTO fin_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pietarin ja Johanneksen kulkiessa ohi hän pyysi rahaa näiltäkin. ");
INSERT INTO fin_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","He katsoivat miestä tarkasti, ja Pietari sanoi sitten: »Katso tänne!» ");
INSERT INTO fin_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Miehen silmät seurasivat heidän jokaista liikettään: hän odotti saavansa jotain. ");
INSERT INTO fin_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Mutta Pietari sanoi: »Rahaa meillä ei ole, mutta minä annan sinulle jotakin muuta! Nasaretin Jeesuksen nimessä: nouse!» ");
INSERT INTO fin_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","8","Pietari tarttui miehen käteen ja auttoi hänet pystyyn. Silloin miehen jalat vahvistuivat, ja hän rupesi hetken seisottuaan kävelemään. Hän meni Pietarin ja Johanneksen mukana temppelialueelle ja hyppeli kuin lapsi kulkiessaan. ");
INSERT INTO fin_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ihmiset hämmästyivät, ");
INSERT INTO fin_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","kun heille selvisi, että tuo Jumalaa kiittävä mies oli sama kerjäläinen, jonka he olivat nähneet istuvan liikuntakyvyttömänä Kauniin portin luona. ");
INSERT INTO fin_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","He ryntäsivät Salomon pylväikköön, jossa mies pysytteli tiiviisti Pietarin ja Johanneksen kintereillä. Ihmisjoukko jäi pylväikköön ihmettelemään tapahtunutta. ");
INSERT INTO fin_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pietari käytti tilaisuutta hyväkseen ja piti puheen: »Hyvät israelilaiset, miksi olette niin yllättyneitä ja tuijotatte meitä ihmeissänne, niin kuin olisimme omalla voimallamme saaneet tämän miehen kävelemään? ");
INSERT INTO fin_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Aabrahamin, Iisakin, Jaakobin ja kaikkien esi-isiemme Jumala sen teki palvelijansa Jeesuksen kunniaksi. Te hylkäsitte Jeesuksen, vaikka Pilatus oli päättänyt vapauttaa hänet. ");
INSERT INTO fin_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Tahdoitte mieluummin päästää vapaaksi murhaajan kuin Jeesuksen, joka oli syytön ja pyhä. ");
INSERT INTO fin_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Teloititte elämän antajan, mutta Jumala herätti hänet kuolleista. Johannes ja minä voimme todistaa sen, sillä näimme omin silmin Jeesuksen elävänä teloituksen jälkeen. ");
INSERT INTO fin_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tiedätte, että tämä edessänne seisova mies oli aikaisemmin täysin liikuntakyvytön. Jumala on antanut meille uskon Jeesukseen, ja Jeesuksen nimi on nyt parantanut hänet täydellisesti. ");
INSERT INTO fin_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Hyvät ystävät, ymmärrän kyllä, että te ja johtajanne ette tienneet, mitä teitte, kun murhasitte Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Samalla Jumala toteutti sen, minkä oli edeltäpäin profeettojensa välityksellä ilmoittanut: että Messias joutuisi kärsimään. ");
INSERT INTO fin_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Nyt teillä on tilaisuus muuttaa asenteenne Jumalaa kohtaan. Palatkaa hänen luokseen, niin hän ottaa syntinne pois, antaa teille uuden elämän ");
INSERT INTO fin_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ja lähettää Jeesuksen, Messiaanne, takaisin luoksenne. ");
INSERT INTO fin_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","22","Hän on nyt taivaassa siihen asti kunnes Jumala toteuttaa kaiken, mitä on aikojen kuluessa luvannut profeettojensa välityksellä. Esimerkiksi Mooses sanoi: ’Jumala herättää joukostanne profeetan, joka muistuttaa minua. Kuunnelkaa tarkasti, mitä hän puhuu teille. ");
INSERT INTO fin_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jokainen, joka kieltäytyy kuuntelemasta, joutuu tuhon omaksi.’ ");
INSERT INTO fin_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuelista alkaen ovat kaikki profeetat puhuneet myös tämänhetkisistä tapahtumista. ");
INSERT INTO fin_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Te olette noiden profeettojen jälkeläisiä, ja teitäkin koskee Jumalan lupaus: hänhän lupasi Aabrahamille siunata koko maailmaa juutalaisen Kristuksen välityksellä. ");
INSERT INTO fin_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Herätettyään Poikansa Kristuksen kuolleista Jumala lähetti hänet ensin teidän israelilaisten luo. Hän siunaa teitä antamalla teille voiman luopua pahuudestanne.» ");
INSERT INTO fin_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kun Pietari ja Johannes olivat puhumassa ihmisille, tulivat ylipapit, temppelin poliisipäällikkö ja muutamat saddukeukset heidän luokseen ");
INSERT INTO fin_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","raivoissaan siitä, että Pietari ja Johannes väittivät Jeesuksen nousseen haudasta. ");
INSERT INTO fin_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Apostolit pidätettiin ja vietiin yöksi vankilaan, sillä oli jo ilta. ");
INSERT INTO fin_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Monet, jotka kuulivat heidän puheensa, uskoivat siihen. Kaiken kaikkiaan uskovien määrä kohosi nyt jo noin viiteentuhanteen mieheen. ");
INSERT INTO fin_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Seuraavana päivänä Jerusalemissa sattui olemaan suuren neuvoston kokous. ");
INSERT INTO fin_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Mukana olivat ylipappi Hannas sekä Kaifas, Johannes, Aleksander ja muita Hannaan sukulaisia. ");
INSERT INTO fin_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Apostolit tuotiin heidän eteensä. »Millä voimalla tai valtuuksilla te miehen paransitte?» juutalaisten johtajat kysyivät. ");
INSERT INTO fin_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Pietari vastasi Pyhän Hengen valtaamana: »Arvoisat kansanjohtajat! ");
INSERT INTO fin_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","10","Jos tarkoitatte sitä hyvää tekoa, jonka teimme sairaalle, niin haluan selvästi sanoa teille ja kaikille israelilaisille, että paransimme hänet Jeesus Nasaretilaisen nimessä ja hänen voimallaan. Hän on Messias, jonka te ristiinnaulitsitte, mutta jonka Jumala herätti kuolleista. Hänen vaikutuksestaan tämä sairas mies seisoo edessänne terveenä. ");
INSERT INTO fin_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Raamattu tarkoittaa juuri Jeesusta puhuessaan ’rakentajien hylkäämästä kivestä, josta tuli peruskivi’. ");
INSERT INTO fin_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kukaan muu ei voi pelastaa ihmistä kuin hän. Koko maailmassa on hänen nimensä ainoa, joka voi meidät pelastaa.» ");
INSERT INTO fin_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kun neuvoston jäsenet näkivät Pietarin ja Johanneksen rohkeuden, he ihmettelivät sitä vaikutusta, joka Jeesuksella oli ollut heihin – olivathan he selvästikin koulua käymättömiä kansanmiehiä. ");
INSERT INTO fin_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Sairaan paranemisesta ei ollut epäilystäkään, sillä hän seisoi kuulusteltavien vieressä. ");
INSERT INTO fin_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Heidän käskettiin poistua kokoussalista siksi aikaa, kun neuvosto käsitteli heidän asiaansa. ");
INSERT INTO fin_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","»Miten meidän pitäisi suhtautua näihin miehiin?» neuvoston jäsenet pohtivat. »He ovat kieltämättä tehneet suuren ihmeteon, ja sen tietää jokainen jerusalemilainen. ");
INSERT INTO fin_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mutta ehkä voimme estää heidän sanomansa leviämisen. Uhkaamme heitä ankarimmalla mahdollisella rangaistuksella, jos he eivät pysy hiljaa.» ");
INSERT INTO fin_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","He kutsuivat miehet sisään ja kielsivät heitä enää puhumasta Jeesuksesta. ");
INSERT INTO fin_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Silloin Pietari ja Johannes sanoivat: »Ajatelkaa itse: tahtooko Jumala, että tottelemme teitä emmekä häntä? ");
INSERT INTO fin_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Emme me voi olla hiljaa kaiken sen jälkeen, mitä olemme nähneet Jeesuksen tekevän ja kuulleet hänen puhuvan.» ");
INSERT INTO fin_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Neuvoston jäsenet uhkailivat apostoleja, mutta päästivät heidät lopulta vapaaksi. Heitä ei uskallettu tuomita, sillä kaikki kiittivät Jumalaa heidän tekemästään suuresta ihmeestä: ");
INSERT INTO fin_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","parantunut mies oli ollut liikuntakyvytön yli neljäkymmentä vuotta. ");
INSERT INTO fin_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Päästyään vapaaksi Pietari ja Johannes menivät muiden Jeesuksen oppilaiden luo ja kertoivat, mitä johtomiehet olivat heille sanoneet. ");
INSERT INTO fin_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kaikki Jeesukseen uskovat alkoivat yhdessä rukoilla: »Herra, sinä loit taivaan, maan ja meren ja kaiken, mitä niissä on. ");
INSERT INTO fin_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","26","Kauan sitten esi-isämme, kuningas Daavid, joka oli palvelijasi, sai sinulta Pyhän Hengen välityksellä viestin: ’Miksi pakanat vastustavat Herraa ja mielettömät kansat punovat juonia kaikkivaltiasta Jumalaa vastaan? Maailman kuninkaat liittoutuvat Messiasta vastaan!’ ");
INSERT INTO fin_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Kuningas Herodes, maaherra Pontius Pilatus, kaikki roomalaiset ja jopa israelilaiset ovat nyt liittoutuneet tässä kaupungissa Jeesusta, sinun omaa Poikaasi, pyhää palvelijaasi, vastaan. ");
INSERT INTO fin_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","He toteuttavat kaiken, minkä olet etukäteen päättänyt antaa heidän tehdä. ");
INSERT INTO fin_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sinä, Herra, olet kuullut heidän uhkauksensa. Anna palvelijoillesi paljon rohkeutta, kun he puhuvat. ");
INSERT INTO fin_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Paranna voimallasi sairaita ja tee ihmeitä pyhän Poikasi Jeesuksen nimessä.» ");
INSERT INTO fin_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Kun he olivat rukoilleet, rakennus, jossa he olivat koolla, tärisi. He tulivat kaikki täyteen Pyhää Henkeä ja puhuivat rohkeasti Jumalan sanaa. ");
INSERT INTO fin_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Uskovat tunsivat syvää yhteenkuuluvuutta ja jakoivat auliisti keskenään kaiken mitä omistivat. ");
INSERT INTO fin_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Apostolit todistivat voimakkaasti, että Jeesus oli herännyt kuolleista, ja uskovat kokivat suurta Jumalan rakkautta. ");
INSERT INTO fin_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Kukaan ei kärsinyt puutetta, sillä ne, jotka omistivat maatiloja tai taloja, myivät omaisuutensa ja toivat rahat apostoleille. Nämä jakoivat kaikille sen mukaan kuin kukin tarvitsi. ");
INSERT INTO fin_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Näin teki muun muassa kyproslainen Joosef, Leevin jälkeläinen, jota apostolit sanoivat myös Barnabaaksi tai Kehottajaksi. ");
INSERT INTO fin_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Hän myi peltonsa ja toi rahat apostoleille edelleen jaettaviksi. ");
INSERT INTO fin_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Myös eräs Ananias-niminen mies ja hänen vaimonsa Safiira myivät maatilansa. ");
INSERT INTO fin_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananias toi apostoleille kuitenkin vain osan rahoista mutta sanoi, että siinä oli kaikki. ");
INSERT INTO fin_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pietari vastasi hänelle: »Ananias, saatana hallitsee nyt sydäntäsi. Valehtelit Pyhälle Hengelle kun sanoit, että tämä on koko hinta. ");
INSERT INTO fin_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Olit vapaa myymään tilan, jos halusit, ja kaupan jälkeenkin rahat olivat yhä sinun ja sait tehdä niillä mitä halusit. Mutta miksi valehtelit? Et rikkonut meitä, vaan Jumalaa vastaan.» ");
INSERT INTO fin_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kuultuaan tämän Ananias kaatui kuolleena lattialle. Kaikki säikähtivät. ");
INSERT INTO fin_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Nuoret miehet kantoivat pois hänen ruumiinsa ja hautasivat hänet. ");
INSERT INTO fin_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kolme tuntia myöhemmin hänen vaimonsa Safiira tuli paikalle tietämättä tapahtuneesta. ");
INSERT INTO fin_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pietari kysyi häneltä: »Tämäkö on hinta, jonka saitte maatilastanne?» Hän vastasi myöntävästi. ");
INSERT INTO fin_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Silloin Pietari sanoi: »Kuinka teille tuli mieleenkään ruveta tällä tavoin kiusaamaan Herran Henkeä? Ne, jotka hautasivat miehesi, ovat jo oven takana, ja he kantavat sinutkin pois.» ");
INSERT INTO fin_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Silloin Safiira kaatui kuolleena lattialle. Kun nuoret miehet näkivät hänet siinä sisään tullessaan, he veivät hänet ja hautasivat Ananiaan viereen. ");
INSERT INTO fin_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kauhu valtasi koko seurakunnan ja kaikki, jotka kuulivat tapahtuneesta. ");
INSERT INTO fin_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Apostolit tekivät monia ihmeitä. He kokoontuivat säännöllisesti uskovien kanssa temppelialueelle Salomon pylväikköön. ");
INSERT INTO fin_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Muut eivät uskaltaneet liittyä heihin, mutta kansa antoi heille suuren arvon. ");
INSERT INTO fin_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Sekä miehiä että naisia liittyi joukoittain uskoviin. ");
INSERT INTO fin_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kaduille kannettiin sairaita vuoteilla ja paareilla; sairaat toivoivat, että edes Pietarin varjo osuisi johonkin heistä hänen kulkiessaan ohi. ");
INSERT INTO fin_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalemin naapurikaupungeista tuotiin sairaita ja pahojen henkien valtaamia ihmisiä, ja kaikki paranivat. ");
INSERT INTO fin_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ylipappi sekä hänen kannattajansa, jotka kuuluivat saddukeusten puolueeseen, tulivat kateellisiksi. ");
INSERT INTO fin_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","He pidättivät apostolit ja sulkivat heidät vankilaan. ");
INSERT INTO fin_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Yöllä Herran enkeli avasi kuitenkin vankilan portit ja opasti heidät ulos. Enkeli rohkaisi: ");
INSERT INTO fin_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","»Menkää temppeliin ja puhukaa uudesta elämästä!» ");
INSERT INTO fin_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","He menivät temppeliin jo aikaisin aamulla ja alkoivat heti puhua ihmisille. Vähän myöhemmin ylipappi tuli seurueineen temppeliin ja kutsui hallitusmiehet koolle suuren neuvoston istuntoon. Apostoleja lähdettiin hakemaan neuvoston eteen. ");
INSERT INTO fin_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mutta poliisit palasivat vankilasta tyhjin toimin ja kertoivat: ");
INSERT INTO fin_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","»Vankilan ovet olivat lukossa ja vartijat seisoivat ulkopuolella, mutta kun avasimme portit, sisällä ei ollutkaan ketään!» ");
INSERT INTO fin_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kun poliisipäällikkö ja ylipapit kuulivat tämän, he tulivat aivan neuvottomiksi. Mitä vielä tapahtuisi ja mihin tämä kaikki lopulta johtaisi? ");
INSERT INTO fin_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Sitten joku tuli kertomaan, että vangitut miehet saarnasivat paraikaa temppelissä. ");
INSERT INTO fin_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","27","Poliisipäällikkö meni miehineen vangitsemaan heidät. Poliisit eivät käyttäneet väkivaltaa, sillä he pelkäsivät, että kansa kävisi heidän kimppuunsa. Vangit tuotiin neuvoston eteen. ");
INSERT INTO fin_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ylipappi huomautti: »Mehän kielsimme teitä enää puhumasta Jeesuksesta. Kuitenkin te olette levittäneet oppianne ympäri kaupunkia ja yritätte vierittää syyn sen miehen kuolemasta meidän niskoillemme.» ");
INSERT INTO fin_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pietari ja muut apostolit vastasivat: »Meidän on toteltava Jumalaa enemmän kuin ihmisiä. ");
INSERT INTO fin_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Esi-isiemme Jumala on herättänyt kuolleista Jeesuksen, jonka te tapoitte ristiinnaulitsemalla. ");
INSERT INTO fin_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Suunnattomalla voimallaan Jumala teki hänestä Kuninkaan ja Vapahtajan. Nyt israelilaisilla on mahdollisuus katua ja saada syntinsä anteeksi. ");
INSERT INTO fin_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Me voimme osoittaa tämän kaiken todeksi, samoin Pyhä Henki, jonka Jumala antaa häntä totteleville.» ");
INSERT INTO fin_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Tämä raivostutti johtomiehiä, ja he päättivät tappaa apostolit. ");
INSERT INTO fin_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mutta Gamaliel-niminen fariseusten puolueen jäsen, joka oli uskonnollisen lain erikoistuntija ja kansan arvostama mies, nousi puhumaan. Hän pyysi, että apostolit vietäisiin vähäksi aikaa salin ulkopuolelle. ");
INSERT INTO fin_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Sitten hän sanoi muille neuvoston jäsenille: »Älkää tehkö mitään hätiköityä. ");
INSERT INTO fin_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Muistatteko vielä Teudaan, joka joitakin aikoja sitten yritti väittää olevansa jokin suurmies? Nelisensataa ihmistä uskoi häntä, mutta hänet tapettiin ja hänen seuraajansa hajotettiin. ");
INSERT INTO fin_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Siihen aikaan, kun suoritettiin henkikirjoitusta, houkutteli galilealainen Juudas ihmisiä kannattajikseen. Myös hän kuoli, ja häneen liittyneiden joukko hajotettiin. ");
INSERT INTO fin_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ehdotan, että jätätte nyt nämä miehet rauhaan. Jos he puhuvat omiaan, he eivät pääse pitkällekään. ");
INSERT INTO fin_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Mutta jos heidän puheensa ja tekonsa ovat Jumalan vaikuttamia, niin te ette voi heitä pysäyttää, vaan huomaatte vielä sotivanne itse Jumalaa vastaan.» ");
INSERT INTO fin_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Suuri neuvosto hyväksyi hänen ehdotuksensa. Apostolit pyydettiin sisään, heidät ruoskittiin ja heitä kiellettiin enää puhumasta Jeesuksesta, mutta sitten heidän annettiin mennä. ");
INSERT INTO fin_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","He poistuivat oikeussalista iloisina siitä, että Jumala oli pitänyt heitä kyllin arvokkaina kärsimään häpeää Jeesuksen nimen tähden. ");
INSERT INTO fin_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","He julistivat yhä joka päivä temppelissä ja kaupungilla, että Jeesus oli Messias. ");
INSERT INTO fin_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Näihin aikoihin, kun uskovien joukko kasvoi nopeasti, heidän keskuudessaan alkoi ilmetä tyytymättömyyttä. Kreikkaa puhuvat valittivat, että heidän leskensä eivät saaneet päivittäisessä jaossa yhtä paljon ruokaa kuin ne lesket, jotka puhuivat hepreaa. ");
INSERT INTO fin_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Apostolit kutsuivat kaikki uskovat koolle. »Meidän pitäisi puhua ihmisille Jumalan sanaa eikä tuhlata aikaamme ruuanjakelun järjestämiseen», he sanoivat. ");
INSERT INTO fin_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","»Valitkaa te, hyvät veljet, joukostanne seitsemän miestä, jotka ovat Pyhän Hengen täyttämiä, osaavat tehdä tällaista työtä ja nauttivat yleistä luottamusta. Annamme heille tehtäväksi ruuan jakamisen, ");
INSERT INTO fin_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","niin että voimme itse keskittyä rukoukseen, hyvän uutisen levittämiseen ja ihmisten opettamiseen.» ");
INSERT INTO fin_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kaikki hyväksyivät ehdotuksen. Tehtävään valittiin Stefanus, joka oli täynnä uskoa ja Pyhää Henkeä, Filippus, Prokorus, Nikanor, Timon, Parmenas ja antiokialainen Nikolaus, joka oli ensin kääntynyt pakanuudesta juutalaisuuteen ja tullut sitten kristityksi. ");
INSERT INTO fin_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Heidät siunattiin tähän tehtävään: rukoiltuaan apostolit panivat kätensä heidän päälleen. ");
INSERT INTO fin_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yhä useammat ihmiset saivat kuulla hyvän uutisen Jeesuksesta, ja uskovien joukko kasvoi valtavasti Jerusalemissa. Monista juutalaisista papeistakin tuli kristittyjä. ");
INSERT INTO fin_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanus, joka oli täynnä uskoa ja Pyhän Hengen voimaa, teki kaupunkilaisten keskuudessa suuria ihmeitä. ");
INSERT INTO fin_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Eräänä päivänä alkoivat jotkut »vapautetuiksi» nimitetyt kreikkaa puhuvat juutalaiset väitellä hänen kanssaan, ja heihin liittyi pian Kyrenestä, Aleksandriasta, Kilikiasta ja Vähästä-Aasiasta tulleita juutalaisia. ");
INSERT INTO fin_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mutta kukaan ei pystynyt kumoamaan Stefanuksen sanoja, sillä hänessä vaikuttivat Pyhän Hengen viisaus ja voima. ");
INSERT INTO fin_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Silloin he haalivat kokoon muutamia miehiä, jotka väittivät muka kuulleensa Stefanuksen pilkkaavan Moosesta ja jopa Jumalaa. ");
INSERT INTO fin_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Tämä syytös sai kansanjoukon raivoihinsa. Juutalaisten johtajat pidättivät Stefanuksen ja toivat hänet suuren neuvoston eteen. ");
INSERT INTO fin_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Todistajat valehtelivat taas, että hän puhui jatkuvasti temppeliä ja Mooseksen lakia vastaan. ");
INSERT INTO fin_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","He selittivät: »Olemme kuulleet hänen väittävän, että tuo nasaretilainen Jeesus hävittää temppelin ja kumoaa Mooseksen lain.» ");
INSERT INTO fin_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Neuvoston jäsenten huomio kiinnittyi Stefanuksen kasvoihin: ne loistivat kuin enkelin kasvot. ");
INSERT INTO fin_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ylipappi kysyi Stefanukselta: »Onko syyte oikea?» ");
INSERT INTO fin_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Stefanus alkoi selittää: »Jumala ilmestyi Mesopotamiassa esi-isällemme Aabrahamille ja käski hänen jättää hyvästit sukulaisilleen ja muuttaa synnyinmaastaan Jumalan osoittamaan maahan. ");
INSERT INTO fin_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Hän lähtikin kaldealaisten maasta ja asettui asumaan Harraniin. Kun hänen isänsä oli kuollut, Jumala johdatti hänet tänne Israeliin, ");
INSERT INTO fin_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","mutta ei antanut hänelle omaksi yhtään maata. Kuitenkin Jumala lupasi, että joskus koko maa olisi Aabrahamin jälkeläisten hallussa. Tämä oli silloin vielä lapseton. ");
INSERT INTO fin_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jumala ilmoitti Aabrahamille myös, että hänen jälkeläisensä joutuisivat lähtemään maasta ja elämään vieraassa maassa orjina neljäsataa vuotta. ");
INSERT INTO fin_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jumala sanoi: ’Minä rankaisen sitä kansaa, jonka orjiksi he joutuvat, ja oma kansani saa palata Israeliin ja palvella minua siellä.’ ");
INSERT INTO fin_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tällöin Jumala teki Aabrahamin kanssa liiton, jonka merkkinä oli ympärileikkaus. Kun Aabrahamin poika Iisak syntyi, hänet ympärileikattiin kahdeksan päivän ikäisenä. Iisakista tuli Jaakobin isä, ja Jaakobin kaksitoista poikaa taas olivat juutalaisten kantaisät. ");
INSERT INTO fin_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","He olivat kateellisia Joosefille ja myivät hänet orjaksi Egyptiin, mutta Jumala oli hänen kanssaan ");
INSERT INTO fin_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ja auttoi häntä selviytymään kaikista vaikeuksista. Hän pääsi Egyptin kuninkaan, faaraon, suosioon. Jumala antoi hänelle sellaisen viisauden, että faarao uskoi hänen hallintaansa koko Egyptin ja kaikki palatsinsa asiat. ");
INSERT INTO fin_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Egyptiin ja Kanaaniin tuli kova nälänhätä, josta esi-isämmekin joutuivat kärsimään. ");
INSERT INTO fin_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jaakob sai kuulla, että Egyptissä vielä oli viljaa, ja lähetti poikansa sitä ostamaan. ");
INSERT INTO fin_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kun he olivat toista kertaa samalla asialla, Joosef paljasti heille henkilöllisyytensä. Heidät vietiin faaraon luo. ");
INSERT INTO fin_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Joosef kutsui luokseen myös isänsä ja veljiensä perheet, kaikkiaan seitsemänkymmentäviisi henkeä. ");
INSERT INTO fin_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Tällä tavoin Jaakob ja hänen sukunsa tulivat Egyptiin, missä sekä Jaakob että kantaisämme kuolivat. ");
INSERT INTO fin_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Aabraham oli ostanut sukuhaudan Emmorin lapsilta Sikemistä. Heidät kaikki haudattiin sinne. ");
INSERT INTO fin_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","18","Jumala oli Aabrahamille luvannut vapauttaa hänen jälkeläisensä orjuudesta. Kun lupauksen täyttymisen aika lähestyi, juutalaisten joukko oli kasvanut Egyptissä suureksi. Sitten maa sai uuden hallitsijan, jolle Joosefin muisto ei merkinnyt mitään. ");
INSERT INTO fin_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Uusi kuningas punoi juonia kansaamme vastaan ja pakotti vanhemmat jättämään lapsensa heitteille, että nämä kuolisivat. ");
INSERT INTO fin_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Siihen aikaan syntyi Mooses – kaunis lapsi, jota Jumala rakasti. Vanhemmat piilottelivat poikaa kolme kuukautta, ");
INSERT INTO fin_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ja kun heidän lopulta oli jätettävä hänet heitteille, faaraon tytär löysi hänet ja otti kasvatikseen. ");
INSERT INTO fin_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mooses sai parhaan mahdollisen kasvatuksen ja koulutuksen, niin että hän pystyi toimimaan muiden johtajana. ");
INSERT INTO fin_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Kerran – Mooses oli silloin nelikymmenvuotias – hänen mieleensä tuli lähteä tapaamaan oman kansansa jäseniä, israelilaisia. ");
INSERT INTO fin_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Hän näki erään egyptiläisen pahoinpitelevän israelilaista miestä. Silloin Mooses löi egyptiläisen kuoliaaksi. ");
INSERT INTO fin_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Hän oletti veljiensä tajuavan, että Jumala oli lähettänyt hänet heitä auttamaan, mutta eivät he sitä ymmärtäneet. ");
INSERT INTO fin_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Seuraavana päivänä Mooses meni taas israelilaisten luo. Nähdessään kahden miehen riitelevän hän yritti sovitella: ’Teidän ei pitäisi tapella keskenänne, kun kuulutte samaan kansaan.’ ");
INSERT INTO fin_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Se, joka oli tehnyt vääryyttä, sanoi Moosekselle, että tämän oli paras olla sekaantumatta heidän asioihinsa. ’Kuka sinulle on antanut luvan määräillä ja neuvoa meitä?’ hän kysyi. ");
INSERT INTO fin_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","’Aiotko tappaa minutkin, niin kuin eilen sen egyptiläisen?’ ");
INSERT INTO fin_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Silloin Mooses pakeni maasta. Hän asettui midianilaisten maahan, ja hänelle syntyi siellä kaksi poikaa. ");
INSERT INTO fin_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Neljäkymmentä vuotta myöhemmin enkeli ilmestyi hänelle palavassa pensaassa autiomaassa lähellä Siinain vuorta. ");
INSERT INTO fin_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nähdessään pensaan palavan Mooses juoksi ihmeissään tarkemmin katsomaan sitä, ja silloin hän kuuli Herran sanovan: ");
INSERT INTO fin_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","’Minä olen esi-isiesi Aabrahamin, Iisakin ja Jaakobin Jumala.’ Mooses vapisi pelosta eikä uskaltanut nostaa katsettaan. ");
INSERT INTO fin_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Herra sanoi: ’Riisu kenkäsi, sillä seisot pyhällä maalla. ");
INSERT INTO fin_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Olen nähnyt kansani ahdistuksen Egyptissä ja kuullut sen avunhuudot. Olen tullut vapauttamaan sen. Siksi lähetän sinut Egyptiin.’ ");
INSERT INTO fin_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Näin Jumala lähetti sinne takaisin saman miehen, jonka hänen maanmiehensä aikaisemmin olivat torjuneet. Mooseksesta tuli heidän johtajansa ja pelastajansa, vaikka he olivat kysyneet: ’Kuka sinulle on antanut luvan määreillä ja neuvoa meitä?’ ");
INSERT INTO fin_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Hän johti heidät pois Egyptistä ja teki monia ihmeitä Egyptissä, Punaisellamerellä ja autiomaassa neljäkymmentä vuotta kestäneen harhailun aikana. ");
INSERT INTO fin_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Mooses kertoi israelilaisille, että Jumala herättäisi kansan keskuudesta profeetan, joka olisi kuin hän. ");
INSERT INTO fin_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Autiomaassa hän toimi välittäjänä, kun enkeli antoi Israelin kansalle Jumalan lain. Mooses otti Siinain vuorella Jumalalta vastaan elävät sanat ja antoi ne meille. ");
INSERT INTO fin_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mutta esi-isämme kyllästyivät Moosekseen ja halusivat takaisin Egyptiin. ");
INSERT INTO fin_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","He pyysivät Aaronia tekemään epäjumalia, jotta he pääsisivät niiden avulla palaamaan. ’Mooses opasti meidät Egyptistä tänne, mutta nyt emme tiedä, miten hänen on käynyt’, he sanoivat. ");
INSERT INTO fin_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","He tekivät itselleen epäjumalan, kultaisen vasikan, jolle uhrasivat tyytyväisinä aikaansaannokseensa. ");
INSERT INTO fin_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Silloin Jumala jätti heidät palvomaan aurinkoa, kuuta ja tähtiä. Profeetta Aamoksen kirjassa Herra kysyy: ’Minulleko te uhrasitte autiomaassa noiden neljänkymmenen vuoden aikana, israelilaiset? ");
INSERT INTO fin_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ei, vaan teitä houkuttivat pakanajumalat ja heidän kuvansa. Kannoitte Molokin telttaa ja Refan-jumalan tähteä. Siksi lähetän teidät vankeuteen kauas Babylonin toiselle puolelle.’ ");
INSERT INTO fin_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Esi-isillämme oli autiomaassa mukanaan siirrettävä temppeli, ilmestysmaja. Siinä säilytettiin kivitauluja, joihin kymmenen käskyä oli kirjoitettu. Telttatemppeli oli tehty tarkasti niiden ohjeiden mukaan, jotka Mooses oli saanut enkeliltä. ");
INSERT INTO fin_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Vuosia myöhemmin ilmestysmaja tuotiin maahan, joka Joosuan johdolla vallattiin pakanakansoilta. Siellä sitä käytettiin Daavidin aikaan asti. ");
INSERT INTO fin_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Jumala siunasi runsaasti Daavidia. Tämä halusi rakentaa Jaakobin Jumalalle pysyvän temppelin, ");
INSERT INTO fin_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","mutta Salomo sen lopulta rakennutti. ");
INSERT INTO fin_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","49","Jumala ei kuitenkaan asu ihmiskäsin rakennetuissa temppeleissä. Hän on sanonut profeetan välityksellä: ’Taivas on minun valtaistuimeni ja maa jalkajakkarani. Millaisen asumuksen te voisitte minulle rakentaa? Minäkö asuisin teidän rakennuksissanne? ");
INSERT INTO fin_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Minähän olen tehnyt sekä taivaan että maan!’ ");
INSERT INTO fin_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Olette itsepäisiä ja sydämeltänne pakanoita! Aina vain te vastustatte Pyhää Henkeä niin kuin esi-isännekin. ");
INSERT INTO fin_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mainitkaa yksikin profeetta, jota he eivät olisi vainonneet. He tappoivat nekin, jotka ennustivat Messiaan tulon. Tämän Jumalan valitseman Messiaan te puolestanne petitte ja murhasitte. ");
INSERT INTO fin_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Te olette ehdoin tahdoin rikkoneet Jumalan lainkin, jonka saitte enkeleiltä.» ");
INSERT INTO fin_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stefanuksen puhuessa ja esittäessä syytöksiä kansan johtomiehet tulivat raivoihinsa. ");
INSERT INTO fin_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mutta Pyhän Hengen täyttämänä Stefanus katsoi kiinteästi kohti taivasta. Hän näki Jumalan kirkkauden ja Jeesuksen seisomassa Jumalan oikealla puolella. ");
INSERT INTO fin_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stefanus sanoi: »Nyt näen taivaat avoimina ja Jeesuksen, Messiaan, seisovan Jumalan oikealla puolella.» ");
INSERT INTO fin_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ympärillä olijat ryntäsivät hänen kimppuunsa, tukkivat korvansa ja huusivat niin että hänen äänensä hukkui heidän huutoonsa. ");
INSERT INTO fin_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","He raahasivat hänet kaupungin ulkopuolelle kivitettäväksi. Viralliset todistajat riisuivat takkinsa Saulus-nimisen nuoren miehen jalkojen juureen. ");
INSERT INTO fin_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Kun tappavia kiviä alkoi sadella, Stefanus rukoili: »Herra Jeesus, ota minun henkeni.» ");
INSERT INTO fin_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Hän lysähti polvilleen ja huusi: »Herra, älä syytä heitä tästä synnistä.» Ja Stefanus oli kuollut. ");
INSERT INTO fin_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus hyväksyi täysin Stefanuksen murhan. Sinä päivänä alkoi Jerusalemin seurakuntaa ravistella suuri vainon aalto, ja apostoleja lukuun ottamatta uskovat hajaantuivat pitkin Juudeaa ja Samariaa. ");
INSERT INTO fin_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Stefanuksen hautasivat eräät hurskaat juutalaiset, jotka surivat vilpittömästi hänen kuolemaansa. ");
INSERT INTO fin_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulus sen sijaan kulki ympäriinsä kuin raivopää tuhoten uskovia. Hän etsi heitä kodeistakin ja panetti vankilaan sekä miehiä että naisia. ");
INSERT INTO fin_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalemista paenneet uskovat kulkivat paikasta toiseen levittämässä hyvää uutista Jeesuksesta. ");
INSERT INTO fin_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Esimerkiksi Filippus meni Samarian kaupunkiin ja kertoi sen asukkaille Kristuksesta. ");
INSERT INTO fin_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Hän teki ihmeitä ja sai väkijoukot kuuntelemaan tarkoin, mitä sanottavaa hänellä oli. ");
INSERT INTO fin_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","8","Hän ajoi monista ihmisistä pahoja henkiä, ja ne huusivat joutuessaan lähtemään ihmisistä. Hän paransi myös halvaantuneita ja rampoja, niin että kaupungin asukkailla oli tosiaan aihetta riemuun. ");
INSERT INTO fin_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","10-11","Muuan Simon-niminen mies oli aikaisemmin harjoittanut kaupungissa noituutta useita vuosia. Hän piti itseään tärkeänä ja oli saanut tekemiensä ihmeiden vuoksi paljon vaikutusvaltaa. Itse asiassa samarialaiset olivat pitäneet häntä jumalallisena olentonakin. ");
INSERT INTO fin_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Nyt he uskoivat Filippusta, joka kertoi Jumalan valtakunnasta ja sanoi, että Jeesus oli Messias. Monia miehiä ja naisia kastettiin. ");
INSERT INTO fin_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Myös Simon uskoi ja sai kasteen. Hän seurasi Filippusta tiiviisti ja oli hämmästynyt tämän tekemistä ihmeistä. ");
INSERT INTO fin_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kun apostolit saivat Jerusalemiin tiedon, että samarialaiset olivat ottaneet Jumalan sanan vastaan, he lähettivät Pietarin ja Johanneksen Samariaan. ");
INSERT INTO fin_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Heti perille tultuaan he alkoivat rukoilla, että uudet kristityt saisivat Pyhän Hengen, ");
INSERT INTO fin_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","hän ei näet vielä ollut tullut heihin: heidät oli vain kastettu Jeesuksen nimeen. ");
INSERT INTO fin_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kun Pietari ja Johannes panivat kätensä uskovien päälle, nämä saivat Pyhän Hengen. ");
INSERT INTO fin_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Kun Simon näki, miten Pyhä Henki tuli ihmisiin, hän tarjosi apostoleille rahaa ostaakseen samanlaisen voiman kuin näillä oli. ");
INSERT INTO fin_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Hän pyysi: »Antakaa minullekin tuollainen voima, että ne, joiden päälle panen käteni, saavat Pyhän Hengen.» ");
INSERT INTO fin_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Mutta Pietari vastasi: »Joudut rahoinesi kadotukseen, kun kuvittelet, että Jumalan lahjan voi ostaa! ");
INSERT INTO fin_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Tämä lahja ei kuulu sinulle – Jumala kyllä tietää sydämesi tilan. ");
INSERT INTO fin_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Luovu itsekkäistä pyyteistäsi ja rukoile Jumalaa. Ehkä hän vielä antaa sinulle kaiken anteeksi. ");
INSERT INTO fin_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nyt olet synnin ja kateuden vallassa.» ");
INSERT INTO fin_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon pyysi: »Rukoilkaa puolestani, ettei minulle tapahtuisi mitään pahaa.» ");
INSERT INTO fin_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Puhuttuaan Samariassa Jeesuksesta Pietari ja Johannes palasivat Jerusalemiin. Matkalla he pysähtyivät moniin Samarian kyliin julistamaan hyvää uutista. ");
INSERT INTO fin_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Filippukselle kävi Jumalan enkeli sanomassa: »Mene Jerusalemista Gassaan johtavalle autiolle tielle puolenpäivän aikaan.» ");
INSERT INTO fin_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Filippus totteli. Tiellä hän tapasi Etiopian kuningattaren hovin varainhoitajan. Tämä korkea virkamies oli ollut Jerusalemissa rukoilemassa ");
INSERT INTO fin_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ja palasi nyt kotiin päin. Vaunuissa hän luki profeetta Jesajan kirjaa. ");
INSERT INTO fin_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Pyhä Henki kehotti Filippusta: »Mene vaunujen luo ja pysyttele niiden vierellä.» ");
INSERT INTO fin_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filippus juoksi vaunujen luo ja kuuli, mitä mies luki. »Ymmärrätkö, mitä siinä sanotaan?» hän kysyi. ");
INSERT INTO fin_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Mies vastasi: »En tietenkään, kun kukaan ei selitä minulle.» Hän pyysi Filippusta nousemaan vaunuihin ja istumaan viereensä. ");
INSERT INTO fin_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Hovivirkamies luki juuri tätä kohtaa: »Hänet vietiin teurastajalle kuin lammas, ja niin kuin karitsa on hiljaa keritsijän edessä, ei hänkään avannut suutaan. ");
INSERT INTO fin_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Häntä nöyryytettiin ja kohdeltiin vastoin oikeutta. Kukapa pystyisi kuvaamaan hänen aikalaistensa pahuutta? Hänen elämänsä ei saanut jatkua maan päällä.» ");
INSERT INTO fin_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopialainen kysyi Filippukselta: »Puhuiko Jesaja itsestään vai jostakin toisesta?» ");
INSERT INTO fin_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filippus alkoi kertoa hänelle Jeesuksesta. Tämän Raamatun kohdan lisäksi hän otti esille monia muitakin. ");
INSERT INTO fin_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Matkan jatkuessa he tulivat pienen lammen luo. »Etkö voisi kastaa minua tässä?» etiopialainen pyysi. ");
INSERT INTO fin_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","»Teen sen, jos uskot koko sydämestäsi», Filippus vastasi. Mies sanoi: »Uskon, että Jeesus Kristus on Jumalan Poika.» ");
INSERT INTO fin_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Hän käski pysäyttää vaunut, ja kun he olivat yhdessä astuneet veteen, Filippus kastoi hänet. ");
INSERT INTO fin_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kun he olivat nousseet rannalle, Jumalan Henki tarttui Filippukseen ja vei hänet muualle. Etiopialainen ei enää nähnyt häntä, mutta jatkoi iloisena matkaansa. ");
INSERT INTO fin_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filippus ilmestyi Asdodiin. Hän levitti siellä hyvää uutista Jeesuksesta ja jatkoi matkaansa Kesarean suuntaan. Kaikissa kaupungeissa hän kertoi ihmisille Jeesuksesta. ");
INSERT INTO fin_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Saulus vihasi silmittömästi kristittyjä ja uhkasi tappaa joka ainoan heistä. Hän meni Jerusalemissa ylipapin luo ");
INSERT INTO fin_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ja pyysi tätä kirjoittamaan kirjeen kaikille Damaskon synagogille. Näitä vaadittaisiin yhteistyöhön uskovien paljastamiseksi. Saulus toisi sitten kaikki löytämänsä kristityt vangittuina Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Hän lähti matkaan. Damaskon lähellä taivaasta leimahti äkkiä kirkas valo Sauluksen ympärille. ");
INSERT INTO fin_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulus kaatui maahan ja kuuli äänen: »Saul, Saul, miksi vainoat minua?» ");
INSERT INTO fin_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","»Kuka olet?» hän kysyi. Ääni vastasi: »Olen Jeesus, jota vainoat. ");
INSERT INTO fin_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Nouse nyt ja mene kaupunkiin odottamaan lisäohjeitani.» ");
INSERT INTO fin_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sauluksen matkatoverit olivat hämmästyksestä sanattomia. He kuulivat äänen, mutta eivät nähneet ketään. ");
INSERT INTO fin_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","9","Kömpiessään pystyyn Saulus tajusi tulleensa sokeaksi. Hänet talutettiin Damaskoon, ja kolmeen päivään hän ei nähnyt mitään. Hän ei myöskään syönyt tai juonut noina päivinä. ");
INSERT INTO fin_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damaskossa oli Ananias-niminen uskova. Hän näki näyn. Herra sanoi hänelle: »Ananias!» »Mitä, Herra?» hän vastasi. ");
INSERT INTO fin_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Herra sanoi: »Mene Suoralle kadulle Juudaksen taloon ja kysy sieltä Saulus-nimistä tarsolaista. Hän rukoilee tällä hetkellä, ");
INSERT INTO fin_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","sillä olen ilmoittanut hänelle näyssä, että Ananias-niminen mies tulee hänen luokseen, panee kätensä hänen päälleen ja hän saa näkönsä takaisin.» ");
INSERT INTO fin_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias vastusteli: »Olen kuullut kauheuksista, joita se mies on tehnyt Jerusalemin uskoville. ");
INSERT INTO fin_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nytkin hänellä on ylipapin kirjoittama pidätysmääräys, joka oikeuttaa hänet vangitsemaan kaikki Damaskon uskovat!» ");
INSERT INTO fin_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mutta Herra sanoi: »Tee mitä pyysin. Olen valinnut Sauluksen levittämään sanomaa minusta sekä pakanakansoille ja niiden kuninkaille että Israelille. ");
INSERT INTO fin_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Hän saa kärsiä paljon minun tähteni.» ");
INSERT INTO fin_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananias lähti. Hän löysi Sauluksen, pani kätensä hänen päälleen ja sanoi: »Veljeni Saulus, sama Jeesus, joka ilmestyi sinulle tiellä, lähetti minut luoksesi, että täyttyisit Pyhällä Hengellä ja voisit taas nähdä.» ");
INSERT INTO fin_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Sauluksen näkö palasi heti aivan kuin suomukset olisivat pudonneet hänen silmiltään. Saulus kastettiin. ");
INSERT INTO fin_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Hän en voimansa palautuivat, kun hän oli syönyt. Hän jäi Damaskon uskovien luo muutamiksi päiviksi ");
INSERT INTO fin_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ja kävi synagogassakin kertomassa ihmisille, että Jeesus todella oli Jumalan Poika. ");
INSERT INTO fin_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kaikki, jotka kuulivat hänen puhuvan, olivat ihmeissään. He kyselivät: »Eikö tämä sama mies vasta vainonnut Jerusalemissa Jeesukseen uskovia? Ja eikö hänen pitänyt täälläkin pidättää heidät kaikki ja viedä ylipappien eteen?» ");
INSERT INTO fin_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sauluksen puheisiin tuli yhä enemmän voimaa. Damaskon juutalaiset olivat ymmällä, kun hän osoitti, että Jeesus todella oli Messias. ");
INSERT INTO fin_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kun joitakin päiviä oli kulunut, juutalaisten johtajat päättivät raivata hänet tieltään. ");
INSERT INTO fin_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulukselle kerrottiin heidän suunnitelmistaan: he pitivät kaupungin porttejakin yötä päivää silmällä. ");
INSERT INTO fin_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yöllä muutamat uskovat laskivat hänet korissa alas kaupungin muurin aukosta. ");
INSERT INTO fin_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tultuaan Jerusalemiin Saulus yritti tavata uskovia, mutta he pelkäsivät häntä. He nimittäin luulivat hänen pettävän heitä. ");
INSERT INTO fin_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas otti hänet vihdoin hoiviinsa ja vei apostolien luo. Hän kertoi, miten Saulus matkalla Damaskoon oli nähnyt Herran, mitä Herra oli sanonut hänelle ja kuinka Saulus sitten oli rohkeasti levittänyt Damaskossa uutista Jeesuksesta. ");
INSERT INTO fin_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Nyt he hyväksyivät Sauluksen joukkoonsa. Hän oli jatkuvasti heidän kanssaan ");
INSERT INTO fin_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ja puhui Jeesuksesta rohkeasti. Eräät kreikkaa puhuvat juutalaiset, joiden kanssa hän väitteli, suunnittelivat hänen murhaamistaan. ");
INSERT INTO fin_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Kun uskovat saivat kuulla, missä vaarassa hän oli, he saattoivat hänet Kesareaan ja lähettivät hänet sieltä kotiin Tarsoon. ");
INSERT INTO fin_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Juudean, Galilean ja Samarian seurakunnat saivat nyt kasvaa rauhassa. Uskovat oppivat, millaista on elää Jumalan lapsena, ja Pyhä Henki antoi heille lisää rohkeutta. ");
INSERT INTO fin_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pietari kiersi eri seurakunnissa ja tuli myös Lyddaan. ");
INSERT INTO fin_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Siellä hän näki Aineas-nimisen miehen, joka oli maannut halvaantuneena vuoteessa kahdeksan vuotta. ");
INSERT INTO fin_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pietari sanoi: »Aineas, Jeesus Kristus on parantanut sinut! Voit kääriä kokoon makuumattosi.» Aineas parani heti. ");
INSERT INTO fin_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kun Lyddan ja Saaronin asukkaat näkivät hänen kävelevän, he uskoivat Herraan. ");
INSERT INTO fin_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppessa asui uskova nainen, jonka nimi oli Tabita (kreikaksi Dorkas, ’gaselli’). Hän teki paljon hyvää, varsinkin köyhille. ");
INSERT INTO fin_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Näihin aikoihin hän sairastui ja kuoli. Ystävät pesivät hänen ruumiinsa ja veivät erääseen yläkerran huoneeseen. ");
INSERT INTO fin_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Kuultuaan, että Pietari oli juuri naapurikaupungissa, uskovat lähettivät kaksi miestä hakemaan häntä. ");
INSERT INTO fin_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Hän tuli miesten mukana, ja hänet vietiin kuolleen Tabitan luo heti. Huone oli täynnä itkeviä naisia, jotka tulivat näyttämään Pietarille Tabitan tekemiä vaatteita. ");
INSERT INTO fin_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pietari pyysi heitä lähtemään ulos huoneesta. Sitten hän polvistui rukoilemaan. Hän sanoi Tabitalle: »Nouse!» Tabita avasi silmänsä ja nousi istumaan, kun näki Pietarin. ");
INSERT INTO fin_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pietari auttoi hänet jaloilleen ja kutsui ulkona odottavat sisään. ");
INSERT INTO fin_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Uutinen levisi ympäri kaupunkia, ja monet alkoivat uskoa Herraan. ");
INSERT INTO fin_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pietari jäi Joppeen useiksi päiviksi. Hän asui nahkuri Simonin luona. ");
INSERT INTO fin_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kesareassa asui Kornelius-niminen Rooman armeijan upseeri, joka toimi komppanian päällikkönä niin kutsutussa Italian rykmentissä. ");
INSERT INTO fin_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Hän ja hänen perheensä olivat Jumalaa kunnioittavia ihmisiä. He osallistuivat juutalaisten jumalanpalveluksiin ja harjoittivat hyväntekeväisyyttä. ");
INSERT INTO fin_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Eräänä iltapäivänä kolmen aikaan Kornelius sai selvän näyn: Jumalan enkeli tuli hänen luokseen. »Kornelius!» enkeli sanoi. ");
INSERT INTO fin_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Mies tuijotti enkeliä kauhuissaan ja sopersi: »Mistä on kysymys?» Enkeli vastasi: »Jumala on kuullut rukouksesi ja nähnyt hyvät työsi. ");
INSERT INTO fin_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","6","Lähetä muutamia miehiä Joppeen etsimään Simon Pietaria. Hän asuu lähellä rantaa nahkuri Simonin talossa. Kutsu hänet luoksesi.» ");
INSERT INTO fin_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Heti kun enkeli oli lähtenyt, Kornelius kutsui kaksi palvelijaansa ja erään Jumalaa kunnioittavan sotilaan, joka kuului hänen henkivartijoihinsa. ");
INSERT INTO fin_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Hän selosti heille, mitä oli tapahtunut, ja lähetti heidät matkaan. ");
INSERT INTO fin_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","10","Seuraavana päivänä, kun miehet olivat jo lähellä Joppea, Pietari meni asuntonsa katolle rukoilemaan. Hänen oli nälkä. Odottaessaan ruuan valmistumista hän näki näyn. ");
INSERT INTO fin_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Taivas avautui, ja sieltä laskettiin maahan kuin suurta valkoista liinaa, jota pidettiin neljästä kulmasta kiinni. ");
INSERT INTO fin_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Liinassa oli matelijoita, lintuja ja muita eläimiä. ");
INSERT INTO fin_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ääni sanoi Pietarille: »Teurasta ja syö mitä haluat.» ");
INSERT INTO fin_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pietari vastusteli: »En suinkaan, Herra. Juutalaisten lakihan kieltää tuollaisten eläinten syömisen.» ");
INSERT INTO fin_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ääni sanoi uudelleen: »Syö vain, sillä jos Jumala pitää jotakin puhtaana, myös sinä voit sen hyväksyä.» ");
INSERT INTO fin_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Sama näky toistui kolme kertaa. Sitten liina nostettiin takaisin taivaaseen. ");
INSERT INTO fin_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pietari oli hämmentynyt. Mitä tuollainen näky oikein merkitsi? Mitä hänen pitäisi tehdä? Sillä välin Korneliuksen lähettämät miehet olivat löytäneet talon ja seisoivat juuri silloin portilla ");
INSERT INTO fin_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","tiedustelemassa, sielläkö Simon Pietari asui. ");
INSERT INTO fin_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pietari pohti yhä näyn merkitystä, mutta Pyhä Henki sanoi hänelle: »Kolme miestä on tullut tapaamaan sinua. ");
INSERT INTO fin_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Mene heidän luokseen ja lähde epäröimättä heidän mukaansa, sillä minä olen lähettänyt heidät.» ");
INSERT INTO fin_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pietari meni alas ja sanoi vieraille: »Minä olen mies jota etsitte. Mitä asiaa teillä on?» ");
INSERT INTO fin_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","He kertoivat hänelle Korneliuksesta, hyvästä, jumalaapelkäävästä Rooman armeijan upseerista, joka nautti kaikkien juutalaisten arvonantoa. Miehet kuvailivat, miten enkeli oli neuvonut Korneliusta etsimään Pietarin käsiinsä, jotta tämä sanoisi hänelle, mitä Jumala tahtoi hänen tekevän. ");
INSERT INTO fin_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pietari pyysi miehet sisään ja majoitti heidät yöksi. Seuraavana päivänä he lähtivät matkaan. Muutamat Joppen uskovat tulivat mukaan. ");
INSERT INTO fin_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Matkustettuaan vuorokauden he tulivat Kesareaan, missä Kornelius odotti heitä. Hän oli kutsunut paikalle myös sukulaisiaan ja läheisiä ystäviään. ");
INSERT INTO fin_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kun Pietari tuli sisään, Kornelius heittäytyi kunnioittavasti hänen eteensä maahan. ");
INSERT INTO fin_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pietari sanoi silloin: »Nouse toki, en minä ole mikään jumala!» ");
INSERT INTO fin_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kornelius nousi. He vaihtoivat muutaman sanan ja menivät sitten muiden luo sisälle. ");
INSERT INTO fin_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pietari kertoi: »Tiedätte varmaan, että juutalaisten laki ei sallisi minun tulla luoksenne, koska te ette ole juutalaisia. Jumala osoitti minulle kuitenkin näyssä, etten saa koskaan pitää ketään alempiarvoisena. ");
INSERT INTO fin_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Siksi tulin heti kun pyysitte. Haluaisin nyt kuulla, miksi minut haettiin.» ");
INSERT INTO fin_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kornelius vastasi: »Olin neljä päivää sitten juuri näihin aikoihin rukoilemassa, kun edessäni äkkiä seisoi häikäisevän kirkkaaseen viittaan pukeutunut mies. ");
INSERT INTO fin_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Hän sanoi, että Jumala on kuullut rukoukseni ja nähnyt hyvät työni, ");
INSERT INTO fin_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ja käski lähettää hakemaan sinua Joppesta. Hän sanoi sinun asuvan meren rannalla nahkuri Simonin talossa. ");
INSERT INTO fin_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Lähetin miehet heti matkaan ja olen iloinen, kun tulit näin pian. Odotamme tässä nyt kaikki Jumalan edessä, mitä hän on käskenyt sinun puhua meille.» ");
INSERT INTO fin_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pietari vastasi: »Käsitän nyt, että Jumala on kiinnostunut muistakin kuin juutalaisista. ");
INSERT INTO fin_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Kaikissa kansoissa on ihmisiä, jotka palvelevat häntä ja tekevät hänen mielensä mukaisia tekoja. ");
INSERT INTO fin_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Olette varmasti kuulleet Israelin kansalle julistetusta hyvästä uutisesta: meidän ja Jumalan välillä on rauha Jeesuksen tähden. Hän on Messias, koko luomakunnan Herra. ");
INSERT INTO fin_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tämä sanoma lähti liikkeelle Galileasta, ja Johannes Kastajan julistustoiminnan jälkeen se levisi myös kaikkialle Juudeaan. ");
INSERT INTO fin_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Tiedätte varmaan, että Jumala antoi Jeesus Nasaretilaiselle voiman ja Pyhän Hengen. Hän vaelsi ympäri maata, auttoi ihmisiä ja paransi kaikki pahojen henkien valtaan joutuneet, sillä Jumala oli hänen kanssaan. ");
INSERT INTO fin_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Me apostolit olemme omin silmin nähneet kaiken, mitä hän teki Israelissa ja Jerusalemissa – siellähän hänet murhattiin, ristiinnaulittiin. ");
INSERT INTO fin_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","41","Kolme päivää myöhemmin Jumala kuitenkin herätti hänet eloon ja antoi muutamien todistajiksi valitsemiensa ihmisten nähdä hänet – ei kansanjoukkojen, vaan meidän, jotka söimme ja joimme hänen kanssaan hänen ylösnousemuksensa jälkeen. ");
INSERT INTO fin_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Hän käski meidän kertoa kaikille hyvän uutisen: Jumala on asettanut hänet koko maailman – elävien ja kuolleiden – tuomariksi. ");
INSERT INTO fin_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kaikki profeetat ovat kirjoittaneet, että ne, jotka uskovat häneen, saavat hänen tähtensä synnit anteeksi.» ");
INSERT INTO fin_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pyhä Henki tuli Pietarin puhuessa kaikkiin kuulijoihin. ");
INSERT INTO fin_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pietarin mukana seuranneet juutalaiset ihmettelivät, kun Pyhän Hengen lahja annettiin pakanoillekin. ");
INSERT INTO fin_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Siitä ei kuitenkaan ollut epäilystäkään, sillä Kornelius ja hänen vieraansa puhuivat kielillä ja kiittivät Jumalaa. Pietari kysyi: »Ei kai kenelläkään voi olla mitään sitä vastaan, että nämä ihmiset kastetaan, kun he ovat saaneet Pyhän Hengen niin kuin me?» ");
INSERT INTO fin_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Heidät kastettiin Jeesuksen Kristuksen nimeen. Sen jälkeen Kornelius pyysi Pietaria jäämään vieraakseen muutamaksi päiväksi. ");
INSERT INTO fin_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Apostolit ja Juudean uskovat saivat pian tietää, että pakanatkin olivat ottaneet vastaan sanoman Jeesuksesta. ");
INSERT INTO fin_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kun Pietari palasi Jerusalemiin, juutalaiskristityt vaativat häneltä selvitystä. ");
INSERT INTO fin_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","He syyttivät Pietaria: »Sinä olet käynyt pakanoiden luona ja syönytkin heidän kanssaan.» ");
INSERT INTO fin_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pietari kertoi heille koko tapauksen: ");
INSERT INTO fin_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","»Näin eräänä päivänä Joppessa rukoillessani näyn. Oli kuin suuri valkea liina olisi laskettu neljästä kulmasta alas taivaasta. ");
INSERT INTO fin_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Liinassa oli matelijoita, lintuja ja kaikenlaisia muita eläimiä. ");
INSERT INTO fin_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Kuulin äänen sanovan: ’Teurasta ja syö mitä tahdot!’ ");
INSERT INTO fin_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mutta minä sanoin, etten koskaan ollut syönyt mitään juutalaisten lain kieltämiä ruokia. ");
INSERT INTO fin_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Silloin kuulin äänen uudelleen: ’Jos Jumala pitää jotain puhtaana, sinäkin voit hyväksyä sen.’ ");
INSERT INTO fin_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tämä toistui kolme kertaa. Sitten liina nostettiin taivaaseen kaikkine eläimineen. ");
INSERT INTO fin_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Samanaikaisesti talon luo ilmestyi kolme miestä, jotka olivat tulleet hakemaan minua Kesareaan. ");
INSERT INTO fin_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Pyhä Henki käski minun lähteä heidän mukaansa ja olla välittämättä siitä, etteivät he olleet juutalaisia. Nämä täällä olevat kuusi uskonveljeä lähtivät kanssani. Tulimme perille sen miehen kotiin, joka oli lähettänyt hakijat. ");
INSERT INTO fin_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Hän kertoi, että enkeli oli tullut hänen luokseen ja kehottanut häntä etsimään minut käsiinsä Joppesta. ");
INSERT INTO fin_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Enkeli oli luvannut, että selittäisin, miten hän ja hänen talonväkensä voisivat pelastua. ");
INSERT INTO fin_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kerroin heille ensin hyvän uutisen Jeesuksesta. Olin vasta päässyt alkuun, kun he saivat Pyhän Hengen samalla tavalla kuin mekin aikaisemmin. ");
INSERT INTO fin_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Muistin Herran sanat: ’Johannes kastaa vedellä, mutta teidät kastetaan Pyhällä Hengellä.’ ");
INSERT INTO fin_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Koska Jumala antoi näille pakanoille saman lahjan kuin meillekin, kun uskoimme Jeesukseen, en kai voinut ruveta häntä estämään?» ");
INSERT INTO fin_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Heidän vastalauseensa tyrehtyivät, kun he kuulivat Pietarin kertomuksen, ja he alkoivat kiittää Jumalaa siitä, että hän oli antanut pakanoillekin oikeuden tulla hänen luokseen ja saada ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Uskovat, jotka olivat lähteneet Jerusalemista Stefanuksen kuolemaa seuranneen vainon aikana, siirtyivät Foinikiaan, Kyprokseen ja Antiokiaan asti. He levittivät hyvää uutista, mutta vain juutalaisille. ");
INSERT INTO fin_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jotkut kyproslaiset ja kyreneläiset puhuivat Jeesuksesta kuitenkin myös Antiokian kreikkalaisille. ");
INSERT INTO fin_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Herra siunasi heidän puheensa, niin että monet, jotka siis eivät olleet juutalaisia, uskoivat Jeesukseen. ");
INSERT INTO fin_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kun Jerusalemin seurakunta sai kuulla tästä, se lähetti Barnabaan Antiokiaan. ");
INSERT INTO fin_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Päästyään perille ja nähtyään, miten ihmeellisellä tavalla Jumala oli siellä toiminut, Barnabas ilahtui kovasti ja kehotti uskovia pysymään lähellä Herraa, mitä tahansa tapahtuisikin. ");
INSERT INTO fin_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas oli hyvä mies – oikea Hengen ja uskon ihminen. Jeesukseen uskovien joukko kasvoi paljon hänen vaikutuksestaan. ");
INSERT INTO fin_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas lähti sitten Tarsoon etsimään Saulusta. ");
INSERT INTO fin_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Löydettyään hänet Barnabas tuli yhdessä hänen kanssaan takaisin Antiokiaan, ja he jäivät sinne kokonaiseksi vuodeksi. He opettivat sikäläisiä uskovia. (Antiokiassa uskovia alettiin sanoa »kristityiksi».) ");
INSERT INTO fin_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Tuona aikana tuli Jerusalemista profeettoja Antiokiaan. ");
INSERT INTO fin_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Eräs heistä, Agabus-niminen, nousi kerran kokouksessa Pyhän Hengen vaikutuksesta ilmoittamaan, että maailmaan oli tulossa suuri nälänhätä. (Keisari Claudiuksen aikana ennustus toteutui.) ");
INSERT INTO fin_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Uskovat päättivät lähettää apua Juudeassa asuville kristityille. Jokainen antoi minkä voi, ");
INSERT INTO fin_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ja Barnabas ja Saulus veivät näin kootun lahjan Jerusalemin seurakunnan johtajille. ");
INSERT INTO fin_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Näihin aikoihin kuningas Herodes sai kynsiinsä muutamia seurakunnan jäseniä. Heitä kidutettiin, ");
INSERT INTO fin_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ja Jaakob, Johanneksen veli, teloitettiin miekalla. ");
INSERT INTO fin_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Kun Herodes huomasi, että se oli mieleen juutalaisten johtajille, hän pidätti pääsiäisviikolla Pietarin ");
INSERT INTO fin_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ja pani hänet vankilaan. Kuusitoista vartijaa oli neljän miehen ryhminä häntä vartioimassa. Herodes aikoi jättää hänet pääsiäisen jälkeen juutalaisten tuomittavaksi. ");
INSERT INTO fin_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Seurakunnan jäsenet rukoilivat koko ajan, että hän pelastuisi. ");
INSERT INTO fin_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Oli oikeudenkäyntiä edeltävä yö, ja Pietari nukkui kahden vartijan välissä. Hän oli kaksinkertaisissa kahleissa, ja portin ulkopuolellakin oli vartijoita. ");
INSERT INTO fin_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Yhtäkkiä selli tuli valoisaksi ja Pietarin viereen ilmestyi Jumalan lähettämä enkeli, joka töytäisi häntä kylkeen ja sanoi: »Herää ja nouse heti!» Kahleet irtosivat hänen ranteistaan. ");
INSERT INTO fin_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Enkeli sanoi: »Pue päällesi ja vedä sandaalit jalkaasi!» Pietari totteli. »Ota nyt viittasi ja tule perässäni», enkeli jatkoi. ");
INSERT INTO fin_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pietari seurasi häntä ulos sellistä. Pietari luuli näkevänsä unta tai näyn eikä käsittänyt, että kaikki oli totta. ");
INSERT INTO fin_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","He kulkivat ensimmäisten ja toisten vartijoiden ohi ja tulivat rautaportille, joka avautui itsestään. Kuljettuaan portista vapauteen he kävelivät eteenpäin katua pitkin. Sitten enkeli katosi. ");
INSERT INTO fin_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Pietari tajusi nyt, mitä oli tapahtunut. Hän ihmetteli itsekseen: »Tämä on totta! Herra lähetti enkelinsä pelastamaan minut. Herodes ja juutalaiset eivät saaneetkaan tahtoaan toteutetuksi.» ");
INSERT INTO fin_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Hetken tilannetta harkittuaan hän lähti kohti Marian, Johannes Markuksen äidin, kotia. Siellä oli suuri joukko koolla rukoilemassa. ");
INSERT INTO fin_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pietari koputti eteisen oveen, ja Rode-niminen apulainen tuli katsomaan, kuka siellä oli. ");
INSERT INTO fin_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Tunnettuaan Pietarin äänen hän riemastui niin, ettei huomannut edes avata ovea, vaan juoksi kertomaan muille, että Pietari seisoi ovella. ");
INSERT INTO fin_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Sisällä olijat eivät uskoneet häntä, vaan sanoivat, että hän oli sekaisin päästään. Kun hän ei antanut periksi, he arvelivat: »Sitten siellä on Pietarin suojelusenkeli.» ");
INSERT INTO fin_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Pietari koputti yhä. Kun he lopulta avasivat oven, heidän hämmästyksellään ei ollut rajoja. ");
INSERT INTO fin_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pietari pyysi hiljaisuutta ja selosti, miten Herra oli auttanut hänet pois vankilasta. »Kertokaa Jaakobille ja muille, mitä on tapahtunut», hän sanoi ja lähti sitten turvallisempaan paikkaan. ");
INSERT INTO fin_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Vankilassa oli aamulla melkoinen sekasorto. Mihin Pietari oli voinut kadota? ");
INSERT INTO fin_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Kun Herodes sai tietää, ettei Pietari enää ollut vankilassa, hän käski pidättää vartijat. Heidät tuomittiin kuolemaan. Herodes itse matkusti joksikin aikaa Kesareaan. ");
INSERT INTO fin_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Tyyrosta ja Siidonista tuli lähetystö Kesareaan tapaamaan Herodesta. Herodes oli hyvin vihainen näiden kahden kaupungin asukkaille. Lähetystö sai kuitenkin taivutetuksi puolelleen Blastoksen, kuninkaan sihteerin, ja pyysi rauhaa, sillä kaupankäynti Herodeksen alueen kanssa oli kaupungeille välttämätöntä. ");
INSERT INTO fin_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herodeksen kanssa sovittiin vastaanotosta. Määräaikana hän pukeutui virkapukuunsa, istuutui valtaistuimelleen ja piti puheen. ");
INSERT INTO fin_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Kun hän oli lopettanut, ihmiset huusivat: »Jumala ääni – ei ihmisen!» ");
INSERT INTO fin_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Koska Herodes ei antanut kunniaa Jumalalle, enkelin lähettämä sairaus iski häneen välittömästi: madot söivät hänet kuoliaaksi. ");
INSERT INTO fin_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Hyvä uutinen Jumalan rakkaudesta levisi nopeasti, ja yhä useammat alkoivat uskoa Jeesukseen. ");
INSERT INTO fin_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas ja Saulus kävivät Jerusalemissa ja toimitettuaan tehtävänsä palasivat sieltä Antiokiaan Johannes Markus mukanaan. ");
INSERT INTO fin_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiokian seurakunnassa oli useita profeettoja ja opettajia: Barnabas, Simeon (»Musta»), kyreneläinen Lukius, kuningas Herodeksen kasvatusveli Manaen sekä Saulus. ");
INSERT INTO fin_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kun he kerran pitivät jumalanpalvelusta ja paastosivat, Pyhä Henki sanoi: »Vapauttakaa Barnabas ja Saulus suorittamaan sitä tehtävää, johon minä olen heidät valinnut.» ");
INSERT INTO fin_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jatkettuaan paastoa ja rukoilemista miehet panivat kätensä heidän päälleen ja siunasivat heidät matkaan. ");
INSERT INTO fin_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Pyhä Henki ohjasi heidät Seleukiaan, josta he purjehtivat Kyprokseen. ");
INSERT INTO fin_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Siellä he puhuivat Salamiissa juutalaisten synagogassa. Johannes Markus oli tullut matkalle mukaan toimiakseen heidän apulaisenaan. ");
INSERT INTO fin_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","7","He kulkivat tämän jälkeen koko saaren läpi ja kertoivat Jeesuksesta kaikissa kaupungeissa. Pafossa he tapasivat juutalaisen noidan, Barjeesuksen, joka esiintyi profeettana. Tämä oli asettunut taloksi maaherra Sergius Pauluksen luo, joka oli hyvin viisas mies. Maaherra kutsui Barnabaan ja Sauluksen kuullakseen, mitä nämä puhuivat Jumalasta. ");
INSERT INTO fin_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Barjeesus, jonka kreikkalainen nimi oli Elymas, tuli kuitenkin väliin ja yritti estää Sergius Paulusta uskomasta Jumalaan. ");
INSERT INTO fin_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulus, jota oli alettu sanoa myös Paavaliksi, katsoi silloin ankarasti Elymasta ja sanoi Pyhän Hengen täyttämänä: ");
INSERT INTO fin_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","»Sinä olet saatanan asialla, olet ovela ja kiero. Etkö jo lakkaa vastustamasta Jumalaa ja hänen hyvyyttään? ");
INSERT INTO fin_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Herra rankaisee sinua: tulet joksikin aikaa sokeaksi.» Elymas menetti heti näkönsä ja kuljeskeli avuttomana ympäriinsä pyytäen, että joku taluttaisi häntä. ");
INSERT INTO fin_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kun maaherra näki, mitä oli tapahtunut, hän uskoi ja ihmetteli Jumalan voimaa. ");
INSERT INTO fin_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paavali matkusti seuralaisineen laivalla Pafosta Vähään-Aasiaan ja nousi maihin Pergen satamassa. Johannes palasi sieltä Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Barnabas ja Paavali jatkoivat matkaa Pisidian Antiokiaan. Sapattina he menivät synagogaan jumalanpalvelukseen. ");
INSERT INTO fin_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kun Mooseksen ja profeettojen kirjoja oli tavan mukaan luettu, vieraat saivat synagogan johtajilta sanan: »Veljet, jos teillä on jotain sanottavaa seurakunnalle, niin puhukaa.» ");
INSERT INTO fin_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paavali nousi, viittasi kädellään tervehdykseksi ja aloitti: »Kuulkaa, israelilaiset ja te muut, jotka kunnioitatte Jumalaa! ");
INSERT INTO fin_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Israelin Jumala valitsi esi-isämme ja auttoi heidät ihmeellisellä tavalla pois Egyptistä, jossa he olivat orjina. ");
INSERT INTO fin_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Hän hoiti heitä hyvin neljäkymmentä vuotta kestäneen autiomaamatkan aikana. ");
INSERT INTO fin_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","20","Sitten hän hävitti Kanaanin maasta seitsemän kansaa ja antoi Israelille näiden alueen. Noin neljänsadanviidenkymmenen vuoden kuluttua tulivat kansan johtajiksi tuomarit. Heidän jälkeensä kansaa johti profeetta Samuel. ");
INSERT INTO fin_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kansa tahtoi kuningasta, ja Jumala antoi sille Saulin, Benjaminin sukuun kuuluvan Kiisin pojan. Saul hallitsi neljäkymmentä vuotta, ");
INSERT INTO fin_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","mutta sitten Jumala antoi hänen tilalleen kuninkaaksi Daavidin. Jumala sanoi: ’Daavid, Iisain poika, on minun mieleiseni ihminen, sillä hän tottelee minua.’ ");
INSERT INTO fin_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Daavidin jälkeläisistä Jumala on antanut lupauksensa mukaan Israelille vapauttajan, Jeesuksen. ");
INSERT INTO fin_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Ennen hänen tuloaan Johannes Kastaja julisti voimakkaasti, että jokaisen israelilaisen oli luovuttava synnistä ja tultava Jumalan luo. ");
INSERT INTO fin_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kun Johannes oli suorittanut tehtävänsä, hän kysyi: ’Pidättekö minua Messiaana? Hän tulee pian, ja häneen verrattuna minä en ole mitään.’ ");
INSERT INTO fin_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Tämä pelastus koskee meitä kaikkia, sekä Aabrahamin jälkeläisiä että teitä muita, jotka kunnioitatte Jumalaa. ");
INSERT INTO fin_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalemin juutalaiset ja heidän johtajansa tappoivat Jeesuksen, niin kuin oli ennustettukin. He eivät tajunneet kuka hän oli, vaikka olivat kuulleet joka sapatti, mitä profeetat olivat kirjoittaneet hänestä. ");
INSERT INTO fin_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","He eivät keksineet mitään syytä, mistä hän olisi ansainnut kuolemantuomion, mutta kuitenkin he vaativat Pilatusta surmauttamaan hänet. ");
INSERT INTO fin_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kun kaikki hänen kuolemaansa koskevat ennustukset olivat toteutuneet, hänet otettiin alas ristiltä ja haudattiin. ");
INSERT INTO fin_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mutta Jumala herätti hänet eloon! ");
INSERT INTO fin_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Seuraavien päivien aikana monet, jotka olivat tulleet hänen kanssaan Galileasta Jerusalemiin, näkivät hänet useita kertoja. He puhuvat jatkuvasti tästä kaikille. ");
INSERT INTO fin_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Barnabas ja minä olemme myös täällä tuomassa teille tätä hyvää uutista. Lupaus, jonka Jumala antoi esi-isillemme, on toteutunut meidän aikanamme, kun Jumala herätti Jeesuksen kuolleista. Toisessa psalmissa sanotaan juuri Jeesuksesta: ’Sinä olet minun poikani, jonka tänään synnytin.’ ");
INSERT INTO fin_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Jumala oli luvannut, ettei Jeesus enää kuolisi. Raamatussa hän vakuuttaa: ’Annan teidän kokea jotakin ihmeellistä, jonka lupasin Daavidille.’ ");
INSERT INTO fin_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Toisessa kohdassa hän ilmaisee vielä selvemmin tarkoituksensa sanoessaan: ’Jumala ei anna Pyhänsä joutua maatumaan.’ ");
INSERT INTO fin_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Hän ei tarkoittanut Daavidia, joka kuoli sen jälkeen kun oli palvellut aikalaisiaan Jumalan tahdon mukaan. Hänet haudattiin, ja hänen ruumiinsa tuli maaksi. ");
INSERT INTO fin_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jumala herätti elämään toisen, jonka ruumis siis ei maatunut. ");
INSERT INTO fin_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kuulkaa, rakkaat veljet! Tämä Jeesus voi antaa teidän syntinne anteeksi. ");
INSERT INTO fin_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jokainen, joka uskoo häneen, vapautuu kaikesta syyllisyydestä, mistä Mooseksen laki ei pysty ihmistä vapauttamaan, ja Jumala hyväksyy hänet lapsekseen. ");
INSERT INTO fin_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Toivottavasti teihin ei tarvitse soveltaa profeettojen sanoja: ");
INSERT INTO fin_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","’Kuulkaa ja hukkukaa, totuuden halveksijat, kun ette usko vaikka kuulette kerrottavan, mitä teen teidän elinaikananne.’» ");
INSERT INTO fin_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kun ihmiset lähtivät jumalanpalveluksesta, he pyysivät Paavalia puhumaan heille taas viikon kuluttua. ");
INSERT INTO fin_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Monet juutalaiset ja ulkomaalaiset, jotka olivat olleet synagogassa, lähtivät Paavalin ja Barnabaan perässä. Paavali ja Barnabas kehottivat heitä ottamaan vastaan kaiken hyvän, mitä Jumala tarjosi heille lahjaksi. ");
INSERT INTO fin_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Seuraavalla viikolla melkein koko kaupunki oli liikkeellä, kun apostolit puhuivat Jumalan sanaa. ");
INSERT INTO fin_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kun juutalaisten johtajat näkivät ihmisjoukon, he vimmastuivat ja väittivät vastaan ivaten, sanoipa Paavali mitä tahansa. ");
INSERT INTO fin_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Silloin Paavali ja Barnabas selittivät rohkeasti: »Jumalan sanaa oli ensin tarjottava teille juutalaisille. Koska olette torjuneet sen ja osoittaneet olevanne sopimattomia ikuiseen elämään, viemme hyvän uutisen pakanoille. ");
INSERT INTO fin_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Sitä Herra tarkoitti sanoessaan: ’Olen tehnyt sinut pakanoiden valoksi, että johtaisit heitä maailman ääristä pelastukseen.’» ");
INSERT INTO fin_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Kun pakanat kuulivat tämän, he tulivat hyvin iloisiksi. Kaikki, jotka Jumala oli valinnut ikuiseen elämään, uskoivat hänen sanaansa. ");
INSERT INTO fin_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jumalan sana levisi koko maakuntaan. ");
INSERT INTO fin_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Juutalaisten johtajat yllyttivät uskonnollismielisiä rikkaita naisia ja vaikutusvaltaisia miehiä vastustamaan Paavalia ja Barnabasta. Vieraat ajettiin ulos kaupungista. ");
INSERT INTO fin_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","He pudistivat kaupungin pölyt jaloistaan ja menivät Ikonioniin. ");
INSERT INTO fin_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ne, jotka olivat heidän työnsä tuloksena alkaneet uskoa Jeesukseen, saivat kokea suurta iloa, ja Herra täytti heidät Pyhällä Hengellä. ");
INSERT INTO fin_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Myös Ikonionissa Paavali ja Barnabas menivät synagogaan. Heidän siellä pitämissään puheissa oli sellainen voima, että monet sekä juutalaiset että pakanat uskoivat Jeesukseen. ");
INSERT INTO fin_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ne juutalaiset, jotka vähät välittivät heidän sanomastaan, puhuivat heistä perättömiä, jotta olisivat saaneet pakanat vastustamaan heitä. ");
INSERT INTO fin_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Siitä huolimatta Paavali ja Barnabas viipyivät siellä pitkään ja pitivät puheitaan rohkeasti. Jumala osoitti, että he puhuivat hänen sanaansa, ja antoi heille voiman tehdä suuria ihmeitä. ");
INSERT INTO fin_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kaupunkilaisten mielipiteet jakautuivat kahtia. Toiset puolustivat juutalaisten johtajia, toiset apostoleja. ");
INSERT INTO fin_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","6-7","Pakanat sekä juutalaiset ja heidän johtajansa suunnittelivat Paavalin ja Barnabaan kivittämistä. Kuultuaan salajuonesta nämä pakenivat ja alkoivat levittää hyvää uutista Jeesuksesta Lykaonian kaupungeissa Lystrassa ja Derbessä ja niiden ympäristössä. ");
INSERT INTO fin_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystrassa he tapasivat liikuntakyvyttömän miehen, joka ei ollut koskaan eläessään pystynyt kävelemään. ");
INSERT INTO fin_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Hän oli mukana kuuntelemassa Paavalin puhetta. Paavali huomasi hänet ja tajusi hänen uskovan, että Jumala voi hänet parantaa. ");
INSERT INTO fin_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Apostoli sanoi hänelle lujalla äänellä: »Nouse seisomaan!» Mies nousi ja käveli. ");
INSERT INTO fin_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Kun muut kuulijat näkivät, mitä Paavali oli tehnyt, he alkoivat huutaa – paikallisella murteella tietysti: »Nuo miehet ovat jumalia ihmisen hahmossa!» ");
INSERT INTO fin_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","He pitivät Barnabasta kreikkalaisten Zeus-jumalana ja Paavalia Hermeksenä, koska hän oli pääpuhuja. ");
INSERT INTO fin_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kaupungin laitamilla oli Zeuksen temppeli, jonka pappi toi heille kukkaseppeleitä ja tahtoi ihmisten kanssa uhrata härkiä heidän kunniakseen kaupungin portilla. ");
INSERT INTO fin_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Paavali ja Barnabas kauhistuivat, kun huomasivat, mitä tapahtui. He juoksivat ihmisjoukon keskelle ");
INSERT INTO fin_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ja huusivat: »Mitä ihmettä te oikein teette? Olemme ihmisiä niin kuin tekin. Tulimme tuomaan teille hyvän uutisen: elävä Jumala, joka on tehnyt taivaan ja maan ja meren ja kaiken, mitä niissä on, kutsuu teitä luokseen. Lopettakaa tuollaiset turhat uhrit ja rukoilkaa häntä! ");
INSERT INTO fin_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tähän asti hän on antanut kaikkien ihmisten kulkea omia teitään, ");
INSERT INTO fin_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","mutta hänen olemassaolostaan on jatkuvasti ollut todisteita. Hän lähetti sateita, antoi hyvän sadon, ravintoa ja iloa sekä ruumiille että sydämelle.» ");
INSERT INTO fin_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Paavalilla ja Barnabaalla oli yhä täysi työ estää ihmisiä uhraamasta heille. ");
INSERT INTO fin_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kului kuitenkin vain muutama päivä, kun Antiokiasta ja Ikonionista tuli juutalaisia, jotka saivat ihmiset puolelleen yllyttäessään väkeä Paavalia ja Barnabasta vastaan. Paavalia kivitettiin, niin että hän oli kuin kuollut, kun hänet raahattiin lopulta kaupungin ulkopuolelle. ");
INSERT INTO fin_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kun uskovat olivat hänen ympärillään, hän nousi maasta ja lähti takaisin kaupunkiin. Seuraavana päivänä hän meni Barnabaan kanssa Derbeen. ");
INSERT INTO fin_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Hän kertoi siellä ihmisille hyvän uutisen, ja monet alkoivat uskoa Jeesukseen. Sitten Paavali ja Barnabas palasivat taas yhdessä Lystraan, Ikonioniin ja Antiokiaan ");
INSERT INTO fin_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ja kehottivat kristittyjä rakastamaan entistä enemmän Jumalaa ja toisiaan. He rohkaisivat heitä uskomaan kaikesta vastustuksesta huolimatta ja muistuttivat, että Jumalan valtakuntaan kuljetaan vaikeuksien kautta. ");
INSERT INTO fin_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","He valitsivat jokaiselle seurakunnalle myös johtajat, paastosivat ja rukoilivat heidän puolestaan ja jättivät heidät sitten sen Herran hoitoon, johon he olivat oppineet luottamaan. ");
INSERT INTO fin_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Paavali ja Barnabas jatkoivat matkaansa Pisidian läpi Pamfyliaan, ");
INSERT INTO fin_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","puhuivat Pergessä Jumalan sanaa ja menivät sitten Attaliaan. ");
INSERT INTO fin_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Lopulta he palasivat laivalla Antiokiaan. Siellähän he alun perin olivat saaneet tehtävän, jonka he nyt Jumalan avulla olivat suorittaneet loppuun. ");
INSERT INTO fin_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Perille päästyään he kutsuivat seurakuntalaiset koolle ja kertoivat matkastaan – siitä, kuinka Jumala oli pakanoillekin avannut uskon oven. ");
INSERT INTO fin_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","He jäivät pitkäksi aikaa uskovien luo Antiokiaan. ");
INSERT INTO fin_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Kun Paavali ja Barnabas olivat Antiokiassa, sinne tuli Juudeasta miehiä, jotka alkoivat opettaa, että ilman Mooseksen lain määräämää ympärileikkausta olisi mahdotonta kelvata Jumalalle. ");
INSERT INTO fin_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paavali ja Barnabas olivat eri mieltä, ja asiasta kehittyi kiivas väittely. Uskovat lähettivät heidät lopulta muutamien paikkakuntalaisten kanssa Jerusalemiin neuvottelemaan kysymyksestä apostolien ja seurakunnan johtajien kanssa. ");
INSERT INTO fin_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Seurakunta varusti heidät matkalle, ja he lähtivät kohti pääkaupunkia. Samalla he kävivät tapaamassa Foinikian ja Samarian uskovia ja kertoivat näiden suureksi iloksi, että pakanoistakin oli tullut kristittyjä. ");
INSERT INTO fin_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalemissa he tapasivat kaikki seurakunnan johtajat – apostolit ja vanhimmat –, ja Paavali ja Barnabas kertoivat näillekin, miten Jumala oli heitä työssään käyttänyt. ");
INSERT INTO fin_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Silloin muutamat miehet, jotka olivat ennen kääntymistään kuuluneet fariseuksiin, hyppäsivät pystyyn ja alkoivat selittää, että kaikki pakanakristityt oli ympärileikattava ja heidän oli noudatettava juutalaisten tapoja ja rituaaleja. ");
INSERT INTO fin_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Seurakunnan johtajat sopivat kokouksesta, jossa tämä asia selvitettäisiin. ");
INSERT INTO fin_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kokouksessa väiteltiin aluksi pitkään. Sitten Pietari pyysi puheenvuoron ja sanoi: »Rakkaat veljet, tiedätte kaikki, että Jumala valitsi minut joukostamme viemään pakanoille hyvän uutisen, jotta hekin voisivat uskoa. ");
INSERT INTO fin_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Jumala tuntee ihmisten sydämet, ja hän osoitti hyväksyvänsä pakanat, kun antoi heille Pyhän Hengen aivan niin kuin meillekin. ");
INSERT INTO fin_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Hän ei tehnyt eroa meidän ja pakanoiden välillä, vaan puhdisti uskolla heidänkin sydämensä. ");
INSERT INTO fin_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Tahtoisitteko siis oikaista Jumalaa, kun panette pakanoiden kannettavaksi sellaisen taakan, jota emme me enempää kuin esi-isämmekään ole jaksaneet kantaa? ");
INSERT INTO fin_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mutta Jeesuksen Kristuksen ilmaisen lahjan ansiostahan me kaikki uskomme pelastuvamme.» ");
INSERT INTO fin_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Keskustelu tyrehtyi tähän. Barnabas ja Paavali alkoivat kertoa, millaisia ihmeitä Jumala oli heidän välityksellään tehnyt pakanoille. ");
INSERT INTO fin_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kun he olivat lopettaneet, Jaakob nousi puhumaan: »Kuulkaa, veljet! ");
INSERT INTO fin_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Pietari on kertonut, kuinka Jumala ensi kertaa valitsi pakanoita lapsikseen. ");
INSERT INTO fin_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tämä pitää yhtä profeettojen ennustusten kanssa. Kuulkaahan esimerkiksi tätä profeetta Aamoksen kohtaa: ");
INSERT INTO fin_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","’Palaan myöhemmin ja uudistan rikotun sopimuksen, jonka tein Daavidin kanssa, ");
INSERT INTO fin_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","että pakanatkin löytäisivät Herran – kaikki, jotka ovat omiani. ");
INSERT INTO fin_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Herra, joka on ilmoittanut maailman alussa tekemänsä suunnitelman, sanoo näin.’ ");
INSERT INTO fin_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Siksi olen sitä mieltä, ettei meidän pidä vaatia Jumalan luo tulevia pakanoita noudattamaan juutalaisten lakia. ");
INSERT INTO fin_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ehdotan, että lähetämme kirjeen, jossa pyydämme heitä kieltäytymään epäsiveellisyydestä, epäjumalille uhratusta lihasta ja myös lihasta, josta verta ei ole laskettu, sekä verestä. ");
INSERT INTO fin_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Näistä asioistahan on aina puhuttu kaikissa juutalaisten synagogissa joka sapatti.» ");
INSERT INTO fin_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Seurakunnan johto yhdessä koko seurakunnan kanssa päätti valita keskuudestaan miehet, jotka lähtisivät Paavalin ja Barnabaan mukana Antiokiaan kertomaan päätöksestä. Lähtijöiksi valittiin Juudas eli Barsabbas ja Silas. ");
INSERT INTO fin_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","He saivat mukaansa tällaisen kirjeen: »Apostolit, Jerusalemin seurakunnan vanhimmat ja muut veljet tervehtivät Antiokian, Syyrian ja Kilikian pakanuudesta kääntyneitä kristittyjä. ");
INSERT INTO fin_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Olemme kuulleet, että täältä on tullut sinne uskovia, jotka puheillaan ovat saaneet teidät hämmennyksiin ja epäilemään pelastumistanne. He eivät ole meidän lähettämiämme. ");
INSERT INTO fin_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Mutta olemme nyt yhdessä sopineet siitä, että kaksi miestä lähtee luoksenne rakkaiden veljiemme Paavalin ja Barnabaan mukana virallisina edustajinamme. ");
INSERT INTO fin_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","27","He ovat Juudas ja Silas. Kumpikin on vaarantanut henkensä Kristuksen tähden. He vahvistavat suullisesti sen, mitä me olemme kiistanalaisesta kysymyksestä päättäneet. ");
INSERT INTO fin_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","29","Pyhän Hengen ja meidän oman näkemyksemme mukaan teidän ei tarvitse kantaa juutalaisten lain taakkaa muuten kuin siltä osin, ettette syö epäjumalille uhrattua lihaa ettekä verta tai lihaa, josta verta ei ole laskettuja kieltäydytte epäsiveellisistä teoista. Riittää kun noudatatte näitä rajoituksia. Jääkää hyvästi!» ");
INSERT INTO fin_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Miehet lähtivät matkaan. Päästyään Antiokiaan he kutsuivat kaikki kristityt koolle ja antoivat heille kirjeen. ");
INSERT INTO fin_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Seurakunta tuli hyvin iloiseksi näistä rohkaisevista sanoista. ");
INSERT INTO fin_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Juudas ja Silas, jotka olivat kumpikin profeettoja, opettivat ja rohkaisivat uskovia. ");
INSERT INTO fin_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kun he olivat olleet jonkin aikaa Antiokiassa, he palasivat Jerusalemiin vieden mukanaan seurakunnan kiitolliset terveiset niille, jotka olivat heidät lähettäneet. ");
INSERT INTO fin_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Paavali, Barnabas ja monet muut julistivat kaupungissa Jumalan sanaa ja opettivat ihmisiä. ");
INSERT INTO fin_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Paavali ehdotti Barnabaalle muutaman päivän kuluttua: »Lähdetään uudestaan niihin Vähän-Aasian kaupunkeihin, joissa julistimme sanomaa Jeesuksesta, katsomaan, miten uskoon tulleet voivat.» ");
INSERT INTO fin_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas lupasi lähteä, mutta tahtoi ottaa Johannes Markuksen mukaan. ");
INSERT INTO fin_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Paavali ei kannattanut ajatusta, koska Johannes oli jättänyt heidät Pamfyliassa. ");
INSERT INTO fin_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Paavali ja Barnabas riitaantuivat tästä asiasta niin, että Barnabas purjehti Markuksen kanssa Kyprokseen, mutta ");
INSERT INTO fin_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","41","Paavali pyysi toverikseen Silasta. Tämän kanssa hän lähti Syyriaan ja Kilikiaan antamaan hengellistä tukea seurakunnille. Uskovat saattoivat heidät matkaan rukoillen Jumalan siunausta. ");
INSERT INTO fin_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paavali ja Silas menivät ensin Derbeen ja sieltä Lystraan, missä he tutustuivat Timoteukseen. Tämä oli nuori kristitty, jonka äiti oli Jeesukseen uskova juutalainen, mutta isä kreikkalainen. ");
INSERT INTO fin_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Lystran ja Ikonionin uskovat arvostivat Timoteusta, ");
INSERT INTO fin_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ja Paavali ehdotti, että tämä lähtisi heidän mukaansa matkalle. Alueella asuvien juutalaisten takia Timoteus ympärileikattiin ennen matkaa; kaikkihan tiesivät, että hänen isänsä oli kreikkalainen. ");
INSERT INTO fin_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","He etenivät kaupungista toiseen ja kertoivat Jerusalemin kokouksessa tehdystä päätöksestä, joka koski pakanuudesta kääntyneitä kristittyjä. ");
INSERT INTO fin_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Seurakuntien usko ja jäsenmäärä kasvoi päivä päivältä. ");
INSERT INTO fin_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Tämän jälkeen he kulkivat Fryygian ja Galatian läpi, sillä Pyhä Henki oli kieltänyt heitä menemästä nyt Vähään-Aasiaan. ");
INSERT INTO fin_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Mysian rajamailla he päättivät suunnistaa pohjoiseen, Bityniaan, mutta Jeesuksen Henki ei taaskaan antanut heidän mennä sinnepäin. ");
INSERT INTO fin_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Sen vuoksi he kulkivat Mysian läpi Trooaan kaupunkiin. ");
INSERT INTO fin_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Yöllä Paavali näki näyn. Kreikkalainen mies pyysi häntä: »Tule tänne Makedoniaan auttamaan meitä.» ");
INSERT INTO fin_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Tahdoimme päästä heti lähtemään, sillä tajusimme, että Jumala halusi lähettää meidät Makedoniaan levittämään hyvää uutista. ");
INSERT INTO fin_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Lähdimme purjehtimaan Trooaasta, tulimme suoraan Samotrakeen ja sieltä seuraavana päivänä Neapolikseen. ");
INSERT INTO fin_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Lopulta olimme Filippissä, Makedonian rajalla sijaitsevassa Rooman siirtokunnassa, ja jäimme sinne muutamaksi päiväksi. ");
INSERT INTO fin_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sapattina lähdimme kaupungista joen rantaan, jossa arvelimme olevan kokouspaikan. Muutamia naisia tulikin sinne, ja me opetimme heille Raamattua. ");
INSERT INTO fin_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Eräs heistä oli tyatiralainen purppurakauppias Lyydia. Hän kunnioitti ennestäänkin Jumalaa, ja nyt Herra avasi hänen sydämensä ottamaan vastaan sen, mistä Paavali puhui. ");
INSERT INTO fin_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Hänet kastettiin, samoin koko hänen talonväkensä. Hän sanoi meille: »Jos pidätte minua Jeesuksen oppilaana, tulkaa kotiini ja jääkää vieraikseni.» Hän suorastaan vaati meitä lähtemään mukaansa. ");
INSERT INTO fin_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kun eräänä päivänä olimme menossa kokouspaikalle rantaan, vastaamme tuli pahojen henkien vallassa oleva orjatyttö, joka osasi ennustaa. Tytön isäntä sai hänen avullaan paljon tuloja. ");
INSERT INTO fin_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tyttö alkoi kulkea perässämme ja huutaa: »Nämä miehet ovat Jumalan palvelijoita! He ilmoittavat teille, miten voitte pelastua.» ");
INSERT INTO fin_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tätä jatkui monta päivää. Lopulta Paavali kääntyi perin juurin kyllästyneenä ja sanoi tytössä olevalle hengelle: »Käsken sinua lähtemään hänestä Jeesuksen Kristuksen nimessä.» Tyttö vapautui heti. ");
INSERT INTO fin_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Orjatytön omistajien oli nyt turha odottaa rikastuvansa hänen avullaan. He ottivat Paavalin ja Silaan kiinni ja raahasivat torille kaupungin johdon tuomittavaksi. ");
INSERT INTO fin_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","21","»Nämä juutalaiset saavat aikaan häiriötä kaupungissamme», he selittivät tuohtuneina. »He opettavat ihmisiä tekemään kaikkea sellaista, minkä Rooman laki kieltää.» ");
INSERT INTO fin_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Kaupunkilaiset kääntyivät hetkessä Paavalia ja Silasta vastaan. Viranomaiset käskivät riisua heidät ja hakata perin pohjin. ");
INSERT INTO fin_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Rajun pieksämisen jälkeen heidät teljettiin vankilaan. Vanginvartija vastasi omalla hengellään siitä, etteivät vangit karanneet. ");
INSERT INTO fin_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Sen vuoksi hän pani Paavalin ja Silaan perimmäiseen selliin ja lukitsi jalkapuuhun. ");
INSERT INTO fin_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Puolenyön aikaan miehet rukoilivat ja lauloivat kiitosvirsiä. Muut vangit kuuntelivat. ");
INSERT INTO fin_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Silloin tuli yhtäkkiä voimakas maanjäristys. Se sai koko vankilan perustukset järkkymään, ovet avautuivat ja vankien kahleet irtosivat. ");
INSERT INTO fin_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kun vanginvartija heräsi ja näki, että ovet olivat auki, hän luuli vankien karanneen ja aikoi tappaa heti itsensä. ");
INSERT INTO fin_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Silloin Paavali huusi: »Rauhoitu, me olemme kaikki täällä!» ");
INSERT INTO fin_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Pelosta vavisten vartija pyysi valoa ja juoksi selliin Paavalin ja Silaan luo. ");
INSERT INTO fin_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Hän vei heidät ulos ja kysyi: »Hyvät herrat, mitä minun on tehtävä, että pelastuisin?» ");
INSERT INTO fin_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","He vastasivat: »Usko Jeesukseen, niin sinä ja koko perheesi pelastutte.» ");
INSERT INTO fin_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","He kertoivat hänen kodissaan Jumalan hyvän uutisen Jeesuksesta. ");
INSERT INTO fin_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Hän pesi vankien haavat. Koko perhe kastettiin. ");
INSERT INTO fin_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Sitten vanginvartija kutsui vieraat aterialle. Hän oli hyvin iloissaan siitä, että hän ja koko talonväki olivat saaneet uskon Jumalaan. ");
INSERT INTO fin_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kaupungin johto lähetti seuraavana aamuna poliisit sanomaan vartijalle: »Päästä ne miehet menemään.» ");
INSERT INTO fin_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Vartija kertoi Paavalille, että heidät oli nyt virallisesti vapautettu. ");
INSERT INTO fin_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mutta Paavali sanoi: »Me olemme Rooman kansalaisia, ja kuitenkin meitä on ruoskittu julkisesti ilman oikeudenkäyntiä, ja sitten meidät on vielä teljetty vankilaan. Nyt meistä haluttaisiin päästä vähin äänin eroon. Ei, kyllä johtajat saavat itse tulla vapauttamaan meidät.» ");
INSERT INTO fin_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Poliisit kertoivat johtomiehille, mitä Paavali oli sanonut. Nämä pelästyivät, kun kuulivat Paavalin ja Silaan olevan Rooman kansalaisia. ");
INSERT INTO fin_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","He tulivat nöyrästi suostuttelemaan vankeja, että nämä lähtisivät kaupungista. ");
INSERT INTO fin_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paavali ja Silas menivät vielä käymään Lyydian kotona, jossa oli muitakin uskovia. Apostolit julistivat heille Jumalan sanaa ja lähtivät jatkamaan matkaa. ");
INSERT INTO fin_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Matka jatkui Amfipoliksen ja Apollonian kautta Tessalonikaan, jossa oli juutalaisten synagoga. ");
INSERT INTO fin_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paavali meni sinne tapansa mukaan puhumaan. Kolmena perättäisenä sapattina ");
INSERT INTO fin_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","hän selitti ihmisille Raamatusta Messiaan kärsimistä ja ylösnousemusta koskevia ennustuksia ja osoitti, että tuo Messias oli juuri Jeesus. ");
INSERT INTO fin_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jotkut kuulijoista alkoivat uskoa Jeesukseen, muun muassa monet juutalaisten jumalanpalveluksiin osallistuvat kreikkalaiset miehet ja ylhäisöpiireihin kuuluvat naiset. ");
INSERT INTO fin_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Juutalaisten johtomiehet suuttuivat, keräsivät kaduilta joutilaita miehiä ja panivat pystyyn mellakan. He tunkeutuivat Jaasonin taloon viedäkseen Paavalin ja Silaan viranomaisten eteen. ");
INSERT INTO fin_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Kun etsityt eivät olleetkaan siellä, raahattiin Jaason ja joitakin muita uskovia oikeuteen. Juutalaiset huusivat: »Paavali ja Silas ovat jo kääntäneet nurin muun maailman ja tulleet nyt mullistamaan meidän kaupunkiamme. ");
INSERT INTO fin_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jaason on päästänyt heidät kotiinsa. He ovat syyllistyneet valtiopetokseen, kun sanovat kuninkaaksi erästä Jeesusta eivätkä keisaria.» ");
INSERT INTO fin_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","9","Tuomarit ja kaupunkilaiset tulivat levottomiksi. Jaason ja muut pidätetyt päästettiin takuuta vastaan vapaalle jalalle. ");
INSERT INTO fin_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Paavali ja Silas lähetettiin yön selkään kohti Bereaa. Perille päästyään he menivät taas juutalaisten synagogaan. ");
INSERT INTO fin_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berealaiset olivat avoimempia heidän sanomalleen kuin tessalonikalaiset. He kuuntelivat puheita mielellään ja tutkivat joka päivä Raamatusta, pitivätkö Paavalin ja Silaan väitteet paikkansa. ");
INSERT INTO fin_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Uskoon tulleiden joukossa oli useita tunnettuja kreikkalaisia miehiä ja naisia. ");
INSERT INTO fin_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kun Tessalonikan juutalaiset saivat tietää, että Paavali oli mennyt puhumaan berealaisille, he lähtivät yllyttämään ihmisiä häntä vastaan. ");
INSERT INTO fin_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","15","Uskovat veivät Paavalin heti meren rantaan, ja jotkut saattoivat häntä Ateenaan asti. Silas ja Timoteus jäivät Bereaan, mutta Paavalin saattajat toivat palatessaan viestin, että näiden oli kiireen kaupalla lähdettävä Paavalin luo. ");
INSERT INTO fin_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Odotellessaan heitä Ateenassa Paavali joutui kuohuksiin epäjumalankuvista, joita kaupunki oli täynnä. ");
INSERT INTO fin_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Hän meni synagogaan keskustelemaan juutalaisten ja juutalaisia tapoja noudattavien kreikkalaisten kanssa ja puhui joka päivä ihmisille, joita tapasi torilla. ");
INSERT INTO fin_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Paavali joutui väittelyyn myös eräiden epikurolaisten ja stoalaisten filosofien kanssa. Kun hän kertoi heille Jeesuksesta ja hänen ylösnousemuksestaan, he totesivat: »Mies puhuu roskaa.» Toiset tuumivat: »Hän tyrkyttää jotain vierasta uskontoa.» ");
INSERT INTO fin_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Paavali vietiin Areiopagille. Hänen katsottiin edustavan uutta uskontoa, josta häntä pyydettiin kertomaan lisää. ");
INSERT INTO fin_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","»Puhuit niin erikoisista asioista, että tulimme uteliaiksi», ateenalaiset totesivat. ");
INSERT INTO fin_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Kaikki ateenalaiset ja kaupungissa oleskelevat ulkomaalaiset olivat aina halukkaita keskustelemaan uusimmista aatevirtauksista. ");
INSERT INTO fin_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paavali astui keskelle Areiopagia ja aloitti: »Hyvät ateenalaiset, te olette selvästikin syvästi uskonnollisia ihmisiä, ");
INSERT INTO fin_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","sillä näin kadulla kävellessäni monia alttareita. Yhteen niistä oli kirjoitettu: ’Tuntemattomalle Jumalalle.’ Haluaisin nyt kertoa teille tästä Jumalasta, jota olette palvelleet häntä tuntematta. ");
INSERT INTO fin_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Hän on luonut koko maailman ja kaiken, mitä siinä on. Koska hän on taivaan ja maan Herra, hän ei asu ihmisten rakentamissa temppeleissä, ");
INSERT INTO fin_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","eivätkä ihmiset voi täyttää hänen tarpeitaan; eihän hän tarvitse mitään! Hän antaa meille elämän ja hengen ja kaiken, mitä me tarvitsemme. ");
INSERT INTO fin_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Koko ihmiskunta sai alkunsa ensimmäisestä ihmisestä, jonka hän loi. Hän on etukäteen määrännyt kansojen kohtalot ja asuinrajat. ");
INSERT INTO fin_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Tämän kaiken hän teki siksi, että ihmiset voisivat etsiä häntä ja ehkä löytääkin – vaikka eihän hän ole kaukana kenestäkään meistä. ");
INSERT INTO fin_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Hänessä me elämme, liikumme ja olemme. Eräs oma runoilijanne on sanonut: ’Me olemme Jumalan sukua.’ ");
INSERT INTO fin_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Jos tämä pitää paikkansa, emme voi ajatella, että Jumala olisi jokin ihmisten tekemä kultainen tai hopeinen tai kivinen patsas. ");
INSERT INTO fin_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Jumala on sietänyt ihmisten tietämättömyyttä, mutta nyt hän käskee kaikkia luopumaan epäjumalista ja kunnioittamaan yksin häntä. ");
INSERT INTO fin_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Määrähetkenä hän antaa valitsemansa miehen tuomita maailman oikeudenmukaisesti; ja todistukseksi siitä hän on herättänyt tuon miehen kuolleista.» ");
INSERT INTO fin_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Kun he kuulivat Paavalin puhuvan ihmisestä, joka oli noussut kuolleista, jotkut nauroivat, mutta toiset sanoivat: »Haluaisimme kuulla asiasta lisää myöhemmin.» ");
INSERT INTO fin_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Paavali lopetti puheensa ja lähti. ");
INSERT INTO fin_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Muutamien kuulijoiden sisimpään syntyi usko – näitä olivat muun muassa Dionysius, tuomioistuimen jäsen, sekä eräs Damaris-niminen nainen. ");
INSERT INTO fin_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Paavali lähti Ateenasta Korinttiin. ");
INSERT INTO fin_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","3","Siellä hän tutustui Pontoksesta kotoisin olevaan juutalaiseen, Akvilaan, joka oli juuri muuttanut sinne vaimonsa Priskillan kanssa Italiasta. Keisari Claudius oli nimittäin karkottanut Roomasta kaikki juutalaiset. Paavali asui tämän pariskunnan luona, ja koska he kaikki kolme olivat ammatiltaan teltantekijöitä, he tekivät yhdessä työtä. ");
INSERT INTO fin_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Jokaisena sapattina Paavali meni synagogaan ja yritti saada sekä juutalaisia että kreikkalaisia uskomaan Jeesukseen. ");
INSERT INTO fin_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Kun Silas ja Timoteus olivat tulleet Makedoniasta, Paavali omistautui kokonaan Jumalan valtakunnan työlle ja julisti hyvää uutista ja todisti juutalaisille, että Jeesus on Kristus. ");
INSERT INTO fin_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kun nämä vain vastustivat häntä ja suhtautuivat pilkallisesti Jeesukseen, Paavali pudisti pölyt viitastaan ja sanoi: »Vastuu on teillä itsellänne; minä olen syytön. Minä lähden nyt julistamaan Kristusta pakanoille.» ");
INSERT INTO fin_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Hän meni synagogan vieressä asuvan Titius Justuksen luo, joka ei ollut juutalainen, mutta kunnioitti Jumalaa. ");
INSERT INTO fin_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Synagogan johtaja Krispus ja hänen perheensä uskoivat Herraan, ja heidät sekä muita korinttilaisia kastettiin. ");
INSERT INTO fin_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Herra sanoi Paavalille eräänä yönä näyssä: »Älä pelkää, vaan jatka työtäsi. ");
INSERT INTO fin_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Minä olen kanssasi, eikä kukaan voi tehdä sinulle pahaa. Tässä kaupungissa on monia, jotka uskovat minuun.» ");
INSERT INTO fin_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paavali jäi Korinttiin puoleksitoista vuodeksi opettamaan Jumalan sanaa. ");
INSERT INTO fin_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Gallion tultua Kreikan maaherraksi juutalaiset alkoivat yhteistoimin vastustaa Paavalia ja vetivät hänet oikeuteen. ");
INSERT INTO fin_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Paavalia syytettiin siitä, että hän suostutteli ihmisiä palvelemaan Jumalaa Rooman lakien vastaisella tavalla. ");
INSERT INTO fin_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paavali aikoi ruveta puolustautumaan, mutta silloin Gallio sanoi syyttäjille: »Jos kysymyksessä olisi rikos, minun olisi kuunneltava teitä. ");
INSERT INTO fin_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mutta, hyvät juutalaiset, kun kiistellään sanoista ja ihmisistä ja teidän omista laeistanne, ne eivät kuulu minulle. En välitä puuttua niihin.» ");
INSERT INTO fin_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Hän ajoi heidät pois oikeussalista. ");
INSERT INTO fin_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kiihtyneet kreikkalaiset ottivat kiinni synagogan uuden esimiehen Soosteneen ja löivät häntä pihalla, mutta Gallio ei ollut sitä huomaavinaankaan. ");
INSERT INTO fin_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paavali jäi vielä moneksi päiväksi kaupunkiin. Sitten hän jätti hyvästit kristityille ja purjehti Priskillan ja Akvilan kanssa Syyrian rannikolle. Kenkreassa hän ajatti tukkansa juutalaisen tavan mukaan, sillä hän oli tehnyt lupauksen. ");
INSERT INTO fin_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efesossa hän jätti seuralaisensa satamaan ja meni itse synagogaan keskustelemaan juutalaisten kanssa. ");
INSERT INTO fin_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Häntä pyydettiin jäämään kaupunkiin joksikin aikaa, mutta hän ei suostunut siihen. ");
INSERT INTO fin_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","»Minun on ehdittävä Jerusalemiin juhlille», hän sanoi. Hän lupasi palata Efesoon, jos Jumala sallisi, ja lähti sitten purjehtimaan eteenpäin. ");
INSERT INTO fin_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Seuraava pysähdyspaikka oli Kesarean satama. Sieltä käsin hän kävi tervehtimässä Jerusalemin seurakuntaa. Merimatka jatkui Antiokiaan. ");
INSERT INTO fin_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Oltuaan siellä jonkin aikaa hän lähti taas Vähään-Aasiaan ja kävi tapaamassa kaikkia Fryygian ja Galatian uskovia. Hän rohkaisi heitä luottamaan kaikessa Jumalaan. ");
INSERT INTO fin_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Efesoon oli juuri tullut Aleksandriasta, Egyptistä, Apollos-niminen juutalainen, joka oli hyvä puhuja ja osasi opettaa Raamattua. ");
INSERT INTO fin_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","26","Hän oli kotimaassaan kuullut Johannes Kastajasta ja siitä, mitä tämä oli puhunut Jeesuksesta, mutta ei tiennyt Jeesuksesta enempää. Niinpä hän julisti synagogassa innostuneena, että Messias oli tulossa. Priskilla ja Akvila olivat paikalla. He kutsuivat hänet vieraakseen ja kertoivat hänelle Jeesuksen elämän loppuvaiheesta ja sen merkityksestä ihmiskunnalle. ");
INSERT INTO fin_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolloksen teki mieli lähteä Kreikkaan, ja uskovat innostivat häntä matkustamaan sinne. He kirjoittivat Kreikan kristityille, että nämä ottaisivat tulijan hyvin vastaan. Apollos saikin tehdä Kreikassa Jumalan työtä, vahvistaa uusien kristittyjen uskoa. ");
INSERT INTO fin_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Hän kumosi kirkkaasti julkisessa keskustelussa kaikki juutalaisten vastaväitteet. Hänen oli helppo näyttää Raamatusta, että Jeesus todella oli Messias. ");
INSERT INTO fin_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Kun Apollos oli Korintissa, Paavali matkusti maitse Efesoon, missä hän tapasi uskovia. ");
INSERT INTO fin_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Hän kysyi heiltä: »Saitteko Pyhän Hengen, kun teistä tuli kristittyjä?» He vastasivat: »Emme oikein käsitä, mitä tarkoitat. Mikä se Pyhä Henki on?» ");
INSERT INTO fin_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","»Mihin sitten uskoitte, kun teidät kastettiin?» Paavali kysyi. »Siihen, mitä Johannes Kastaja on opettanut», he vastasivat. ");
INSERT INTO fin_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Silloin Paavali selitti, mitä Johanneksen kaste merkitsi. Se merkitsi, että kastettava tunnusti haluavansa kääntyä synnistä Jumalaan päin. Sen jälkeen tuli kuitenkin Jeesus, johon Johannes kehotti kastettuja uskomaan. ");
INSERT INTO fin_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kun efesolaiset kuulivat tämän, he halusivat saada kasteen Jeesuksen nimeen. ");
INSERT INTO fin_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Kun Paavali sen jälkeen pani kätensä heidän päälleen, he saivat Pyhän Hengen, puhuivat kielillä ja profetoivat. ");
INSERT INTO fin_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Miehiä oli toistakymmentä. ");
INSERT INTO fin_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Paavali meni synagogaan ja puhui siellä kolmen kuukauden aikana joka sapatti rohkeasti ja vakuuttavasti uskon perusteista. Keskustelujen jälkeen monet uskoivat Jeesukseen. ");
INSERT INTO fin_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mutta oli niitäkin, jotka eivät hyväksyneet hänen sanomaansa, vaan vastustivat Kristusta julkisesti. Paavali kieltäytyi puhumasta enää heille ja alkoi sen sijaan opettaa Jeesukseen uskovia Tyrannuksen luentosalissa joka päivä. ");
INSERT INTO fin_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Tätä koulutusta kesti kaksi vuotta, ja sen aikana kaikki Vähän-Aasian asukkaat, sekä juutalaiset että kreikkalaiset, saivat kuulla hyvän uutisen Jeesuksesta. ");
INSERT INTO fin_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Jumala teki ihmeitä: ");
INSERT INTO fin_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","kun Paavalin vaatekappaleita vietiin sairaiden päälle, nämä paranivat ja pahat henget lähtivät heistä. ");
INSERT INTO fin_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kaupungista toiseen kierteli juutalaisia, jotka myös ajoivat ihmisistä pahoja henkiä. Hekin päättivät kokeilla Jeesuksen nimen tehoa. He ottivat käyttöönsä uuden manauksen: »Vannotamme teitä lähtemään sen Jeesuksen nimessä, josta Paavali puhuu.» ");
INSERT INTO fin_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Juutalaisen ylipapin Skeuaan seitsemän poikaa ");
INSERT INTO fin_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","yrittivät tällä tavoin vapauttaa erästä miestä demonin vallasta, mutta henki vastasi: »Tunnen kyllä Jeesuksen ja Paavalin, mutta keitä te olette?» ");
INSERT INTO fin_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Demonin vallassa oleva mies hyökkäsi veljesten kimppuun ja antoi heille sellaisen selkäsaunan, että heidän oli paettava talosta vaatteet revittyinä ja verissä päin. ");
INSERT INTO fin_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Pian kaikki Efeson asukkaat – sekä juutalaiset että kreikkalaiset – saivat tietää, mitä oli tapahtunut. He pelästyivät kovasti ja alkoivat kunnioittaa Jeesuksen nimeä. ");
INSERT INTO fin_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","19","Monet Jeesukseen uskovat, jotka olivat harjoittaneet noituutta, tunnustivat asian ja polttivat loitsukirjansa suuressa yhteisessä roviossa. Kirjoja arvioitiin olleen 50 000 hopearahan arvosta. ");
INSERT INTO fin_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tämä osoittaa, miten suuri Jumalan sanan vaikutus oli paikkakunnalla. ");
INSERT INTO fin_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Näiden tapahtumien jälkeen Paavali tunsi Pyhän Hengen kehottavan häntä kulkemaan Kreikan kautta, kun hän palaa Jerusalemiin. »Sitten minun on mentävä Roomaan», Paavali sanoi. ");
INSERT INTO fin_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Hän lähetti kaksi avustajaansa, Timoteuksen ja Erastuksen, edellään Kreikkaan, mutta jäi itse vielä joksikin aikaa Vähään-Aasiaan. ");
INSERT INTO fin_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Efesossa kehittyi niihin aikoihin melkoinen kiista kristinuskosta. ");
INSERT INTO fin_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sen aloitti Demetrius. Hän oli hopeaseppä, jonka palveluksessa oli monilla alan ammattimiehillä hyvät tulot: he tekivät pyhiinvaeltajille hopeisia Artemis-jumalattaren temppelin pienoismalleja. ");
INSERT INTO fin_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrius kutsui koolle omat miehensä ja muut saman alan ammattilaiset ja selosti heille tilanteen: »Hyvät miehet, ansaitsemme tästä työstä toimeentulomme. ");
INSERT INTO fin_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Niin kuin olette huomanneet, tuo Paavali on saanut monet uskomaan, että käsin tehdyt jumalat eivät olekaan mitään jumalia. Myyntimme alkaa pienentyä koko maakunnassa. ");
INSERT INTO fin_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Muutkin näkökohdat on otettava huomioon: suuren Artemis-jumalattaren temppeliä aletaan halveksia, ja jumalatar, jota ei palvella vain täällä vaan muuallakin maailmassa, unohdetaan kokonaan.» ");
INSERT INTO fin_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Vihaisina kuulijat alkoivat huutaa: »Efeson Artemis on suurin!» ");
INSERT INTO fin_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Paikalle alkoi kerääntyä väkeä, ja kaupunki oli äkkiä sekasorron vallassa. Kaikki ryntäsivät ulkoilmateatteriin. Ihmisjoukko veti mukaansa Paavalin makedonialaiset matkatoverit Gaiuksen ja Aristarkuksen. ");
INSERT INTO fin_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paavalikin olisi tahtonut mennä sisään, mutta hänen kristityt ystävänsä eivät päästäneet häntä sinne. ");
INSERT INTO fin_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Myös maakunnan hallintoviranomaisissa oli hänen ystäviään, ja he lähettivät sanan, ettei Paavali saisi vaarantaa henkeään menemällä teatteriin. ");
INSERT INTO fin_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ihmiset huusivat kuka mitäkin – tilanne oli kaaosmainen, eivätkä useimmat edes tienneet, miksi oltiin koolla. ");
INSERT INTO fin_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Joukosta vedettiin esiin Aleksander, ja juutalaiset yrittivät työntää häntä puhumaan. Hän koetti pyytää hiljaisuutta voidakseen aloittaa, ");
INSERT INTO fin_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","mutta kun ihmiset huomasivat, että hän oli juutalainen, he alkoivat huutaa: »Efeson Artemis on suurin!» Tätä jatkui kaksi tuntia. ");
INSERT INTO fin_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kaupunginsihteeri sai heidät lopulta rauhoittumaan sen verran, että pystyi puhumaan: »Hyvät efesolaiset, kaikkihan tietävät, että Efeso on Artemiin palvonnan keskus – hänen kuvansakin putosi taivaasta juuri tänne. ");
INSERT INTO fin_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Tämä on kiistämätön tosiasia, ja siksi teidän ei pitäisi menettää malttianne eikä tehdä mitään hätiköityä. ");
INSERT INTO fin_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Nyt olette tuoneet tänne miehiä, jotka eivät ole varastaneet mitään temppelistä eivätkä pilkanneet Artemista. ");
INSERT INTO fin_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Jos Demetriuksella ja hänen työntekijöillään on jotakin näitä vastaan, niin haastakoot nämä miehet oikeuteen. ");
INSERT INTO fin_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Muista asioista voidaan tavalliseen tapaan valittaa kansankokoukselle. ");
INSERT INTO fin_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Rooman hallitus voi hyvinkin panna meidät tilille tämänpäiväisestä aiheettomasta mellakasta.» ");
INSERT INTO fin_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Hän sai lopulta kokouksen hajotetuksi. ");
INSERT INTO fin_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Kun tilanne oli rauhoittunut, Paavali kutsui kristityt koolle, piti heille rohkaisevan puheen ja hyvästeli heidät. Hän oli lähdössä Kreikkaan. ");
INSERT INTO fin_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Matkalla hän vahvisti tapaamiensa kristittyjen uskoa. ");
INSERT INTO fin_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Hän oli Kreikassa kolme kuukautta ja valmistautui purjehtimaan Syyriaan, mutta saikin kuulla juutalaisten punovan juonia häntä vastaan ja päätti lähteä ensin Makedoniaan. ");
INSERT INTO fin_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Paavalin mukana matkusti monta miestä: berealainen Soopatros, Pyrrhoksen poika, tessalonikalaiset Aristarkus ja Sekundus, derbeläinen Gaius, Timoteus sekä Tykikus ja Trofimus, jotka nyt palasivat kotiinsa Vähään-Aasiaan. ");
INSERT INTO fin_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","He menivät edeltä ja odottivat meitä Trooaassa. ");
INSERT INTO fin_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Pääsiäisen jälkeen nousimme laivaan Filippissä, Pohjois-Kreikassa, ja olimme viisi päivää myöhemmin perillä Trooaassa, jonne jäimme viikoksi. ");
INSERT INTO fin_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Kokoonnuimme sunnuntaina yhteiselle aterialle. Paavalin oli määrä lähteä seuraavana päivänä. Hän piti pitkän puheen, joka jatkui puoleen yöhön. ");
INSERT INTO fin_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Monta lamppua oli sytytetty palamaan yläkerran huoneeseen, jossa olimme koolla. ");
INSERT INTO fin_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kun Paavali puhui puhumistaan, ikkunalaudalla istunut Eutykus-niminen nuori poika nukahti ja putosi kolmannesta kerroksesta maahan. Hän kuoli heti. ");
INSERT INTO fin_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","11-12","Paavali meni pihalle ja kiersi kätensä pojan ympärille. »Olkaa rauhassa, pojalla ei ole mitään hätää», hän sanoi. Poika eli ja oli terve! Kaikki menivät riemuissaan takaisin sisään ja nauttivat ehtoollista. Sitten Paavali puhui vielä pitkään ja lähti vasta aamun sarastaessa jatkamaan matkaansa. ");
INSERT INTO fin_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Paavali kulki jalkaisin Assokseen, jonne me olimme purjehtineet jo edeltäpäin. ");
INSERT INTO fin_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Sieltä jatkoimme yhdessä matkaa Mityleneen ");
INSERT INTO fin_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ja edelleen Kioksen kohdalle Samokseen ja sitten Miletoon. Kussakin paikassa kului vuorokausi. ");
INSERT INTO fin_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paavali oli päättänyt, ettei tällä kertaa pysähtyisi Efesoon, sillä hänen teki mieli ehtiä helluntaiksi Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Mileton satamasta hän kuitenkin lähetti Efeson seurakunnan johtajille viestin, jossa hän pyysi näitä tulemaan luokseen. ");
INSERT INTO fin_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Efesolaiset tulivat, ja Paavali puhui heille: »Tiedätte, että siitä asti, kun ensi kertaa tulin Vähään-Aasiaan, ");
INSERT INTO fin_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","olen nöyrästi halunnut tehdä Jumalan työtä. Joskus olen saanut tehdä sitä itkien, joskus olen joutunut suureen vaaraan, kun juutalaiset ovat suunnitelleet minun murhaamistani. ");
INSERT INTO fin_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kaikesta huolimatta olen jatkanut työtäni ja puhunut julkisesti ja kodeissanne siitä, minkä tiedän olevan totta. ");
INSERT INTO fin_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Olen puhunut samasta asiasta sekä juutalaisille että pakanoille: meidän on Jeesukseen Kristukseen uskoen käännyttävä synnistä Jumalan tielle. ");
INSERT INTO fin_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Nyt olen menossa Jerusalemiin. En tiedä, mikä minua siellä odottaa, mutta Pyhä Henki kuljettaa minua sinne vastustamattomasti ");
INSERT INTO fin_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ja muistuttaa minua joka kaupungissa siitä, että minut vangitaan ja että joudun kärsimään. ");
INSERT INTO fin_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Elämäni ei kuitenkaan ole minkään arvoista, ellen käytä sitä Jeesuksen minulle antaman tehtävän suorittamiseen. Haluan viedä kaikkialle ilosanoman Jumalan suunnattomasta hyvyydestä ja rakkaudesta. ");
INSERT INTO fin_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Tiedän, ettei kukaan teistä, joille olen puhunut Jumalan valtakunnasta, näe minua enää. ");
INSERT INTO fin_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Tahtoisin sanoa suoraan, että tunnen täyttäneeni tehtävän, jonka sain, eikä kukaan joudu minun laiminlyöntieni tähden kadotukseen. ");
INSERT INTO fin_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Pitäkää hyvää huolta itsestänne ja joukosta, jonka Pyhä Henki on antanut johdettavaksenne. Te olette vastuussa seurakunnasta, jonka hintana oli Jumalalle hänen oman Poikansa henki. ");
INSERT INTO fin_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Tiedän, että lähtöni jälkeen seurakuntaanne tulee miehiä, jotka käyvät kuin sudet lauman kimppuun. ");
INSERT INTO fin_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Omastakin joukostanne nousee sellaisia, jotka alkavat vääristellä totuutta ja haalia itselleen oppilaita. ");
INSERT INTO fin_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Olkaa tarkkoja! Muistakaa, että olen kolme vuotta kaikkeni antaen neuvonut teitä kädestä pitäen. ");
INSERT INTO fin_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Jätän teidät nyt Jumalan ja hänen lupaustensa varaan. Jumala kasvattaa uskoanne ja antaa teille ja muille lapsilleen perinnöksi ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","En ole havitellut rahaa tai hienoja vaatteita. ");
INSERT INTO fin_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Näillä käsilläni olen elättänyt itseni ja työtoverini. ");
INSERT INTO fin_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Autoin köyhiäkin, että esimerkilläni muistuttaisin Jeesuksen sanoista ’Onnellisempaa on antaa kuin ottaa’.» ");
INSERT INTO fin_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paavali lopetti ja polvistui rukoilemaan kaikkien kanssa. ");
INSERT INTO fin_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Efesolaiset itkivät hyvästellessään hellästi Paavalia. ");
INSERT INTO fin_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Eniten heitä surettivat Paavalin sanat, etteivät he enää näkisi häntä. Sitten he saattoivat hänet laivaan. ");
INSERT INTO fin_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Kun olimme hyvästelleet efesolaiset, purjehdimme suoraan Koos-saaren rantaan. Sieltä ehdimme seuraavana päivänä Rodokseen ja edelleen Pataraan, ");
INSERT INTO fin_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","missä nousimme Foinikiaan menevään laivaan. ");
INSERT INTO fin_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Kypros jäi reitistämme vasemmalle, ja purjehdimme Syyriaan, Tyyron satamaan, jonne laivan piti purkaa lastinsa. ");
INSERT INTO fin_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Menimme tapaamaan paikkakunnan kristittyjä ja jäimme heidän luokseen viikoksi. Pyhän Hengen vaikutuksesta he varoittivat Paavalia menemästä Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Viikon kuluttua palasimme satamaan, ja koko seurakunta saattoi meitä – naiset ja lapsetkin olivat mukana. Rannassa rukoilimme polvillamme. Kun olimme sanoneet hyvästit, ");
INSERT INTO fin_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","nousimme laivaan, ja saattajat palasivat kotiinsa. ");
INSERT INTO fin_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tyyron jälkeen oli seuraava pysähdyspaikkamme Ptolemais. Tapasimme uskovat, mutta viivyimme siellä vain päivän. ");
INSERT INTO fin_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Jatkoimme matkaa Kesareaan ja menimme evankelista Filippuksen kotiin. Hän oli yksi seitsemästä ensimmäisestä diakonista. ");
INSERT INTO fin_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Hänellä oli neljä naimatonta tytärtä, joilla oli profetoimisen lahja. ");
INSERT INTO fin_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Olimme siellä monta päivää. Juudeasta tuli luoksemme Agabus-niminen mies, ");
INSERT INTO fin_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ja hänkin profetoi. Hän sitoi kätensä ja jalkansa Paavalin vyöllä ja sanoi: »Pyhä Henki on ilmoittanut minulle, että juutalaiset sitovat näin Jerusalemissa tämän vyön omistajan ja antavat hänet roomalaisille.» ");
INSERT INTO fin_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Kun kuulimme tämän, pyysimme kaikki, ettei Paavali matkustaisi Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mutta hän sanoi itse: »Mitä varten te itkette ja teette minutkin onnettomaksi? Olen valmis pidätettäväksi ja jopa kuolemaan Jerusalemissa Jeesuksen tähden.» ");
INSERT INTO fin_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Kun kävi ilmi, ettei hän halunnut muuttaa suunnitelmiaan, annoimme periksi ja sanoimme: »Tapahtukoon sitten Jumalan tahto.» ");
INSERT INTO fin_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Vähän myöhemmin pakkasimme tavaramme ja lähdimme ratsastaen Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Eräät kesarealaiset uskovat saattoivat meidät majapaikkaamme, vanhan kyproslaisen kristityn, Mnasonin, kotiin. ");
INSERT INTO fin_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Meidät otettiin Jerusalemissa sydämellisesti vastaan. ");
INSERT INTO fin_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Seuraavana päivänä pääsimme Paavalin kanssa tapaamaan Jaakobia ja Jerusalemin seurakunnan johtajia. ");
INSERT INTO fin_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Kun olimme tervehtineet, Paavali selosti tarkkaan, mitä kaikkea Jumala oli tehnyt hänen työnsä välityksellä pakanoiden keskuudessa. ");
INSERT INTO fin_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Seurakunnan johtajat kiittivät Jumalaa kuulemastaan. Sitten he sanoivat: »Tiedät varmaan, että monia tuhansia juutalaisiakin on tullut uskoon. He ovat kaikki hyvin tarkkoja siitä, että noudatamme edelleen juutalaisten perinnäistapoja. ");
INSERT INTO fin_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Jerusalemin juutalaiskristityille on kerrottu, että sinä vastustaisit Mooseksen lakia ja juutalaisia tapoja ja kieltäisit jopa ympärileikkaamasta lapsia. ");
INSERT INTO fin_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Mitähän nyt olisi paras tehdä? He saavat varmasti kuulla, että olet tullut tänne. ");
INSERT INTO fin_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Meillä olisi ehdotus: Täällä on neljä miestä, jotka ovat tehneet Jumalalle lupauksen. ");
INSERT INTO fin_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Menkää yhdessä temppeliin ja osallistu sinä heidän kanssaan lain säätämään uhritoimitukseen. Maksa kaikkien kulut. Sen jälkeen miehet voivat leikkauttaa tukkansa. Näin kaikki saavat tietää, että hyväksyt tällaisen tavan ja tottelet itsekin juutalaisten lakia. ");
INSERT INTO fin_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Pakanakristittyjähän emme vaadi noudattamaan juutalaisten tapoja muutamaa poikkeusta lukuunottamatta: pyysimme kirjeessämme, että he eivät söisi epäjumalille uhrattua lihaa eivätkä sellaista lihaa, josta verta ei ole laskettu, sekä kieltäytyisivät epäsiveellisyydestä.» ");
INSERT INTO fin_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","27","Paavali suostui ehdotukseen. Hän meni miesten kanssa seuraavana päivänä temppeliin toimitusta varten ja ilmoitti julkisesti, mihin mennessä he toisivat lupaamansa uhrin: aikaa oli seitsemän päivää. Melkein viikko oli kulunut, kun muutamat Vähästä-Aasiasta tulleet juutalaiset huomasivat Paavalin temppelissä ja järjestivät häntä vastaan mielenosoituksen. He ottivat hänet kiinni ");
INSERT INTO fin_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ja huusivat: »Israelilaiset, tulkaa auttamaan! Tämä mies opettaa ihmisiä vastustamaan juutalaisten lakia ja koko kansaamme. Hän puhuu pahaa temppelistäkin ja tuo tänne luvattomasti pakanoita.» ");
INSERT INTO fin_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Aikaisemmin päivällä he olivat nähneet Paavalin kaupungilla efesolaisen Trofimuksen kanssa ja luulivat, että Paavali oli tuonut tämän temppeliin. ");
INSERT INTO fin_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Kohina valtasi kaupungin. Villiintyneet ihmiset juoksivat temppelialueelle, ottivat Paavalin kiinni ja raahasivat hänet ulos. Portit suljettiin heti. ");
INSERT INTO fin_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Paavali aiottiin tappaa saman tien, mutta roomalaisen joukko-osaston komentaja ehti kuulla, että Jerusalem oli joutunut sekasorron valtaan. ");
INSERT INTO fin_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Hän lähti heti sotilaiden ja upseerien kanssa tapahtumapaikalle. Ihmiset lakkasivat pahoinpitelemästä Paavalia, kun näkivät heidän tulevan. ");
INSERT INTO fin_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Komentaja antoi pidätysmääräyksen ja käski sitoa Paavalin kaksinkertaisilla kahleilla. Sitten hän kysyi väkijoukolta, kuka Paavali oli ja mitä hän oli tehnyt. ");
INSERT INTO fin_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Yksi selitti yhtä, toinen toista, ja kun komentaja ei saanut asiasta selvää, hän käski tuoda Paavalin kasarmiin. ");
INSERT INTO fin_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Kun hänet oli tuotu portaille, ihmisjoukko tuli niin väkivaltaiseksi, että sotilaiden piti kantaa Paavalia olkapäillään saadakseen hänet sisään. ");
INSERT INTO fin_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Perässä seuraava joukko huusi: »Kuolema tälle miehelle!» ");
INSERT INTO fin_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","38","Kun päästiin ovelle, Paavali kysyi komentajalta: »Saanko sanoa jotain?» Komentaja kysyi hämmästyneenä: »Osaatko kreikkaa? Etkö olekaan se Egyptistä tullut kansankiihottaja, joka muutama vuosi sitten vei autiomaahan neljätuhatta juutalaista kapinallista?» ");
INSERT INTO fin_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paavali vastasi: »En toki. Olen juutalainen ja kotoisin suuresta kilikialaisesta kaupungista, Tarsosta. Saisinko puhua näille ihmisille?» ");
INSERT INTO fin_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Komentaja suostui pyyntöön. Paavali seisoi portailla ja viittasi väkijoukkoa vaikenemaan. Kun oli syntynyt syvä hiljaisuus, hän alkoi puhua heprean kielellä: ");
INSERT INTO fin_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","»Hyvät veljet, antakaa minun sanoa jotain puolustuksekseni.» ");
INSERT INTO fin_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Kun ihmiset tajusivat hänen puhuvan hepreaa, hiljaisuus syveni entisestään. ");
INSERT INTO fin_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","»Olen juutalainen, kotoisin kilikialaisesta Tarson kaupungista», hän selitti. »Olin Jerusalemissa Gamalielin oppilaana ja opin tarkkaan juutalaisten lait ja tavat. Halusin innokkaasti tehdä kaiken Jumalan kunniaksi; siihenhän tekin olette pyrkineet tänään. ");
INSERT INTO fin_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Henkeen ja vereen asti vainosin kristittyjä ja panin tyrmään sekä miehiä että naisia. ");
INSERT INTO fin_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ylipappi tai kuka muu kansanjohtaja tahansa voi todistaa tämän. Pyysin nimittäin heiltä kirjeet Damaskon juutalaisten johtomiehille, että nämä antaisivat minun pidättää sikäläiset kristityt ja tuoda Jerusalemiin rangaistaviksi. ");
INSERT INTO fin_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Matkalla lähellä Damaskoa leimahti ympärilläni keskipäivän aikaan äkkiä valtavan kirkas valo. ");
INSERT INTO fin_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Kaaduin maahan ja kuulin äänen: ’Saul, miksi vainoat minua?’ ");
INSERT INTO fin_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","’Kuka oikein olet?’ kysyin puhujalta. Hän vastasi: ’Olen Jeesus Nasaretilainen, jota vainoat.’ ");
INSERT INTO fin_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Matkatoverini näkivät valon, mutta eivät kuulleet Jeesuksen ääntä. ");
INSERT INTO fin_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Vastasin hänelle: ’Herra, mitä minun pitäisi tehdä?’ Hän sanoi: ’Mene Damaskoon, niin saat kuulla siellä, millaisia tehtäviä sinulle on varattu.’ ");
INSERT INTO fin_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Olin tullut sokeaksi kirkkaasta valosta, ja tovereideni piti taluttaa minut Damaskoon. ");
INSERT INTO fin_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","13","Luokseni tuli kaupungissa eräs Ananias-niminen mies. Hän oli lakia tarkoin noudattava juutalainen, jota muut juutalaiset pitivät suuressa arvossa. Hän sanoi minulle: ’Saul, veljeni, nyt sinä pystyt taas näkemään!’ Samalla hetkellä näköni palasi. ");
INSERT INTO fin_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Sitten hän selitti minulle: ’Isiemme Jumala on valinnut sinut: saat oppia tuntemaan hänen tahtonsa, saat nähdä Messiaan ja kuulla hänen äänensä. ");
INSERT INTO fin_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Sinun on julistettava sanomaa hänestä kaikkialla ja kerrottava ihmisille, mitä olet nähnyt ja kuullut. ");
INSERT INTO fin_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Mene nyt heti kastettavaksi, anna pestä pois syntisi ja rukoile Herran nimeen.’ ");
INSERT INTO fin_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","18","Kun palasin Jerusalemiin, vaivuin temppelissä rukoillessani unentapaiseen tilaan. Herra sanoi minulle näyssä: ’Lähde pian Jerusalemista, sillä täällä ihmiset eivät usko, kun puhut heille minusta.’ ");
INSERT INTO fin_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Minä sanoin: ’Mutta Herra, kyllähän he tietävät, miten olen vanginnut ja lyönyt synagogissa niitä, jotka uskovat sinuun. ");
INSERT INTO fin_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Olin mukana, kun todistajasi Stefanus murhattiin ja hyväksyin sen: vartioin kivittäjien vaatteita.’ ");
INSERT INTO fin_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Mutta Jumala sanoi minulle: ’Lähde Jerusalemista, sillä minä lähetän sinut kauas pakanoiden luo.’» ");
INSERT INTO fin_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tähän asti väkijoukko oli kuunnellut Paavalia. Nyt ihmiset alkoivat huutaa kuin yhdestä suusta: »Pois tuo mies! Tuollaisella ei ole oikeutta elää!» ");
INSERT INTO fin_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","He kirkuivat, heittelivät vaatekappaleita ja viskoivat hiekkaa ilmaan. ");
INSERT INTO fin_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Komentaja käski viedä Paavalin sisään ja lyödä häntä, että hän tunnustaisi rikoksensa. Hän halusi saada selville, miksi ihmiset olivat noin raivoissaan. ");
INSERT INTO fin_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Paavali sidottiin ruoskittavaksi. Silloin hän kysyi vieressä seisovalta upseerilta: »Antaako laki teidän ruoskia Rooman kansalaista ilman oikeudenkäyntiä?» ");
INSERT INTO fin_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Upseeri meni kysymään komentajalta: »Mitä aiot tehdä? Mies on Rooman kansalainen.» ");
INSERT INTO fin_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Komentaja tuli kysymään Paavalilta: »Oletko tosiaan Rooman kansalainen?» »Varmasti olen», hän vastasi. ");
INSERT INTO fin_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","»Niin olen minäkin», vastasi komentaja. »Tosin sain maksaa siitä paljon.» »Minä olen ollut Rooman kansalainen syntymästäni saakka», Paavali sanoi. ");
INSERT INTO fin_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Sotilaat, joiden piti ruoskia Paavalia, hävisivät äkkiä paikalta. Komentajakin pelästyi tajutessaan, että oli määrännyt Rooman kansalaisen sidottavaksi. ");
INSERT INTO fin_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Seuraavana päivänä komentaja irrotti Paavalin kahleet ja käski ylipappien kokoontua juutalaisten neuvoston istuntoon. Hän vei Paavalin tutkittavaksi, sillä hän halusi saada selville, mistä koko jutussa oikein oli kysymys. ");
INSERT INTO fin_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paavali katsoi suoraan neuvoston jäseniin ja aloitti: »Hyvät veljet, minulla on aina ollut Jumalan edessä puhdas omatunto.» ");
INSERT INTO fin_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Silloin ylipappi Ananias käski niitä, jotka seisoivat lähellä Paavalia, läimäyttää häntä vasten suuta. ");
INSERT INTO fin_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paavali sanoi: »Jumala lyö sinua itseäsi, senkin teeskentelijä! Mikä tuomari sinä olet? Rikot lakia, kun käsket noin vain lyödä minua.» ");
INSERT INTO fin_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Paavalin lähellä olevat miehet varoittivat: »Näinkö sinä puhut Jumalan ylipapille?» ");
INSERT INTO fin_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paavali vastasi: »En tiennyt, että hän on ylipappi. Raamatussahan sanotaan: ’Älä puhu pahaa kenestäkään kansasi johtajasta.’» ");
INSERT INTO fin_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Silloin Paavali muisti erään asian. Neuvoston jäsenistä osa oli fariseuksia, osa saddukeuksia. Niinpä hän huusi: »Olen fariseusten jälkeläinen ja itsekin fariseus. Olen oikeuden edessä siksi, että uskon kuolleiden ylösnousemukseen!» ");
INSERT INTO fin_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Odotetusti neuvosto jakautui nyt kahtia, ");
INSERT INTO fin_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","sillä saddukeukset eivät usko henkien olemassaoloon, ylösnousemukseen eivätkä enkeleihin kuten fariseukset. ");
INSERT INTO fin_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Syntyi kova hälinä. Muutamat fariseusten opettajat alkoivat väittää, että Paavali oli oikeassa, ja huusivat: »Ei hänessä mitään vikaa ole. Ehkä henki tai enkeli on tosiaan puhunut hänelle Damaskon-matkalla.» ");
INSERT INTO fin_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Meteli yltyi ja Paavalia kiskottiin sinne tänne. Komentaja pelkäsi, että hänet revittäisiin kappaleiksi ja käski sotilaiden pelastaa hänet ja viedä voimakeinoin oikeussalista kasarmiin. ");
INSERT INTO fin_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Seuraavana yönä Herra seisoi Paavalin vieressä ja sanoi hänelle: »Sinun ei tarvitse pelätä. Saat puhua minusta Roomassa niin kuin olet puhunut täällä Jerusalemissakin.» ");
INSERT INTO fin_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Seuraavana aamuna yli neljäkymmentä juutalaista sopi keskenään, että he eivät söisi eivätkä joisi mitään ennen kuin olisivat tappaneet Paavalin. ");
INSERT INTO fin_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","He menivät kertomaan ylipapeille ja muille kansanjohtajille valastaan ja pyysivät: ");
INSERT INTO fin_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","»Käskekää komentajan tuoda Paavali taas oikeuteen. Sanokaa, että aiotte tehdä joitakin lisäkysymyksiä. Tapamme hänet matkalla.» ");
INSERT INTO fin_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Paavalin sisarenpoika sai kuitenkin vihiä suunnitelmasta ja tuli kasarmiin kertomaan siitä Paavalille. ");
INSERT INTO fin_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paavali kutsui erään upseerin luokseen ja pyysi: »Vie tämä poika komentajan luo. Hänellä on tärkeää asiaa.» ");
INSERT INTO fin_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Upseeri täytti pyynnön ja sanoi komentajalle: »Vankina oleva Paavali sanoi, että pojalla olisi sinulle jotain asiaa.» ");
INSERT INTO fin_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Komentaja veti pojan syrjään ja kysyi: »No, mitä sinä tahdot?» ");
INSERT INTO fin_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Poika vastasi: »Juutalaiset aikovat pyytää sinulta, että veisit Paavalin huomenna takaisin oikeuteen. He haluaisivat muka vielä jatkaa kuulustelua. ");
INSERT INTO fin_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mutta älä päästä häntä! Kadun varrella on nimittäin yli neljäkymmentä miestä valmiina hyökkäämään hänen kimppuunsa ja tappamaan hänet. He ovat vannoneet, etteivät syö tai juo mitään, ennen kuin Paavali on kuollut. Kaikki on valmiina, vain sinun suostumuksesi enää tarvitaan.» ");
INSERT INTO fin_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ennen kuin komentaja päästi pojan menemään, hän varoitti tätä: »Älä paljasta kenellekään, mitä kerroit minulle.» ");
INSERT INTO fin_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","24","Komentaja pyysi luokseen kaksi upseeria ja antoi käskyn: »Varustakaa iltaan kello yhdeksään mennessä kaksisataa sotilasta lähtemään Kesareaan. Tarvitsette myös kaksisataa keihäsmiestä ja seitsemänkymmentä ratsua. Antakaa Paavalille hevonen ja saattakaa hänet turvallisesti maaherra Felixin luo.» ");
INSERT INTO fin_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Sitten hän kirjoitti maaherralle kirjeen: ");
INSERT INTO fin_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","»Claudius Lysias tervehtii hänen ylhäisyyttään, maaherra Felixiä. ");
INSERT INTO fin_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Juutalaiset ottivat tämän miehen kiinni ja olivat vähällä tappaa hänet. Lähetin sotilaat pelastamaan hänet, kun kuulin, että hän on Rooman kansalainen. ");
INSERT INTO fin_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Toimitin hänet juutalaisten neuvoston eteen saadakseni selville, mitä hän oli tehnyt. ");
INSERT INTO fin_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Huomasin pian, että kiista koski juutalaisten uskoa, eikä mies varmastikaan ansainnut vankeutta eikä kuolemantuomiota. ");
INSERT INTO fin_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kun sain tietää, että on tehty salaliitto hänen murhaamisekseen, päätin lähettää hänet luoksesi. Pyydän syyttäjiäkin esittämään asiansa sinulle.» ");
INSERT INTO fin_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sotilaat veivät Paavalin illalla määräyksen mukaan Antipatrikseen. ");
INSERT INTO fin_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","He palasivat seuraavana päivänä kasarmille, mutta Paavali jatkoi matkaa Kesareaan ratsujoukon saattamana. ");
INSERT INTO fin_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Perillä Kesareassa ratsumiehet esittelivät Paavalin maaherralle ja antoivat kirjeen. ");
INSERT INTO fin_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Luettuaan viestin maaherra kysyi, mistä Paavali oli kotoisin. »Olen Kilikiasta», Paavali vastasi. ");
INSERT INTO fin_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","»Kuulustelen sinua sitten tarkemmin, kun syyttäjäsi tulevat», maaherra sanoi ja käski pitää Paavalia vangittuna kuningas Herodeksen linnassa. ");
INSERT INTO fin_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Viisi päivää myöhemmin tulivat Kesareaan ylipappi Ananias, eräät muut juutalaisten johtajat ja asianajaja Tertullus. He halusivat esittää kanteen Paavalia vastaan. ");
INSERT INTO fin_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Kun syytetty oli tuotu maaherran eteen, Tertullus aloitti: »Arvoisa maaherra. ");
INSERT INTO fin_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Olemme hyvin kiitollisia olojen rauhoittumisesta ja monista uudistuksista, joista juutalaiset ovat päässeet osalliseksi toimintasi ansiosta. ");
INSERT INTO fin_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","En tahdo viivyttää sinua pitkään, mutta toivon, että kuuntelisit hetkisen, mistä syytämme tätä miestä. ");
INSERT INTO fin_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Olemme huomanneet hänen aiheuttavan hankaluuksia, sillä hän kiihottaa juutalaisia kaikkialla mellakoihin ja kapinaan Rooman hallitusta vastaan. Hän on nasaretilaisten lahkon johtaja. ");
INSERT INTO fin_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Hän yritti häpäistä temppeliäkin, mutta silloin me pidätimme hänet. Halusimme rangaista häntä lakimme mukaan, ");
INSERT INTO fin_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","mutta varuskunnan komentaja Lysias otti hänet väkisin käsistämme ");
INSERT INTO fin_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ja alkoi vaatia, että asia olisi vietävä Rooman lakien mukaan oikeuteen. Voit todeta syytöksemme paikkansapitävyyden, kun tutkit vankia itse.» ");
INSERT INTO fin_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Kaikki muut juutalaiset vakuuttivat, että Tertullus puhui totta. ");
INSERT INTO fin_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Maaherra viittasi, että Paavalilla oli puheenvuoro. Tämä aloitti: »Arvoisa maaherra, olet toiminut juutalaisten tuomarina useita vuosia, ja siksi voin luottavasti puolustaa asiaani. ");
INSERT INTO fin_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Voit helposti todeta, että siitä on vasta kaksitoista päivää, kun menin Jerusalemiin palvellakseni temppelissä Jumalaa. ");
INSERT INTO fin_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","En ole aiheuttanut mellakoita sen paremmin synagogissa kuin kaduillakaan, ");
INSERT INTO fin_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","eikä minua vastaan osoitettuja syytöksiä voida mitenkään todistaa oikeiksi. ");
INSERT INTO fin_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Yhden asian kuitenkin tunnustan: kuljen pelastuksen tietä, jota he sanovat lahkoksi. Palvelen esi-isiemme Jumalaa, noudatan juutalaisten lakia ja uskon kaiken, mitä profeetat ovat kirjoittaneet. ");
INSERT INTO fin_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Uskon myös samoin kuin nämä miehet, että kaikki ihmiset heräävät kuolleista, sekä jumalattomat että Jumalaan uskovat. ");
INSERT INTO fin_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Tästä syystä pyrin siihen, että minulla olisi aina puhdas omatunto sekä Jumalan että ihmisten edessä. ");
INSERT INTO fin_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Oltuani vuosikausia poissa pääsin nyt tulemaan Jerusalemiin. Mukanani oli avustus juutalaisille, ja halusin myös antaa uhrin Jumalalle. ");
INSERT INTO fin_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Olin suorittanut puhdistusmenot, kuten laki vaatii, eikä temppelissä ollut ympärilläni minkäänlaista hälinää. Muutamat Vähän-Aasian juutalaiset tapasivat minut siellä. ");
INSERT INTO fin_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Heidän pitäisi nyt olla kertomassa teille, jos heillä on jotakin minua vastaan. ");
INSERT INTO fin_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Voitte kysyä näiltäkin miehiltä, mitä väärää heidän neuvostonsa näki minussa. ");
INSERT INTO fin_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ehkä minun ei olisi pitänyt huutaa neuvoston istunnossa: ’Olen tässä siksi, että uskon kuolleiden ylösnousemukseen!’ Muutahan en sanonut.» ");
INSERT INTO fin_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felix tiesi, että kristityt eivät panneet alulle mellakoita. Hän pyysi juutalaisia odottamaan Lysiaksen tuloa ja siirsi asian käsittelyä. ");
INSERT INTO fin_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Paavalin hän lähetti vankilaan, mutta käski vartijoiden kohdella häntä hyvin ja päästää hänen ystävänsä vapaasti tuliaisineen hänen luokseen. ");
INSERT INTO fin_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Muutamaa päivää myöhemmin Felix ja hänen juutalaissyntyinen vaimonsa Drusilla haettivat Paavalin luokseen ja pyysivät, että tämä kertoisi heille uskosta Jeesukseen Kristukseen. ");
INSERT INTO fin_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kun Paavali puhui Jumalan mielen mukaisesta elämästä, itsehillinnästä ja ihmiskunnan tuomiosta, Felix kuitenkin pelästyi. »Saat mennä nyt, mutta lähetän hakemaan sinua myöhemmin, kun minulla on sopivampaa aikaa», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Hän myös toivoi, että Paavali alkaisi lahjoa häntä, ja siksi tämä sai tulla kerran toisensa jälkeen keskustelemaan hänen kanssaan. ");
INSERT INTO fin_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Näin kului kaksi vuotta. Sitten Porcius Festuksesta tuli Felixin seuraaja. Felix, joka tavoitteli juutalaisten suosiota, jätti Paavalin vankeuteen. ");
INSERT INTO fin_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Kolme päivää sen jälkeen, kun Festus oli astunut virkaansa Kesareassa, hän lähti Jerusalemiin. ");
INSERT INTO fin_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Siellä juutalaisten johtajat tulivat kertomaan hänelle Paavalin tapauksesta. ");
INSERT INTO fin_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","He pyysivät, että Festus lähettäisi Paavalin heti Jerusalemiin. Itse asiassa heidän tarkoituksensa oli murhata hänet matkalla. ");
INSERT INTO fin_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Mutta Festus vastasi, että hän aikoi pian palata Kesareaan, ja koska Paavalikin oli siellä, ");
INSERT INTO fin_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","olisi yksinkertaisinta, että asiaa käsittelevät viranomaiset lähtisivät hänen mukanaan oikeudenkäyntiin. ");
INSERT INTO fin_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus palasi Kesareaan kahdeksan tai kymmenen päivää myöhemmin, ja heti seuraavana päivänä alkoi Paavalin oikeudenkäynti. ");
INSERT INTO fin_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Kun Paavali oli tuotu oikeussaliin, Jerusalemista tulleet juutalaiset rupesivat esittämään vakavia syytöksiä, joita he kuitenkaan eivät kyenneet todistamaan. ");
INSERT INTO fin_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paavali torjui syytökset: »En ole millään tavalla rikkonut juutalaisten lakia enkä toiminut temppeliä tai Rooman hallitusta vastaan.» ");
INSERT INTO fin_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Juutalaisia mielistelläkseen Festus ehdotti: »Lähtisitkö Jerusalemiin vastaamaan edessäni näihin syytöksiin?» ");
INSERT INTO fin_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","11","Paavali vastasi: »En. Vaadin pääsyä itsensä keisarin eteen, sillä siihen minulla on oikeus. Tiedät aivan hyvin, että olen syytön. Suostun kyllä kuolemaan, jos olen tehnyt jotakin sellaista, mistä seuraa kuolemanrangaistus. Mutta jos olen syytön, ei sinulla sen enempää kuin muillakaan ole oikeutta antaa noiden miesten tappaa minua. Vetoan keisariin.» ");
INSERT INTO fin_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus keskusteli neuvonantajien kanssa ja teki päätöksensä: »Hyvä on. Olet vedonnut keisariin ja keisarin eteen myös joudut.» ");
INSERT INTO fin_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Muutaman päivän kuluttua tuli kuningas Agrippa sisarensa Berniken kanssa tapaamaan Festusta. ");
INSERT INTO fin_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Vierailu kesti monta päivää, ja Festus selosti kuninkaalle Paavalinkin tapauksen: »Felix jätti tänne erään vangin. ");
INSERT INTO fin_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kun kävin Jerusalemissa, ylipapit ja muut juutalaisten johtajat esittivät minulle oman näkemyksensä hänestä ja vaativat, että hänet oli tuomittava kuolemaan. ");
INSERT INTO fin_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Muistutin tietysti heti, että Rooman lain mukaan häntä ei voida tuomita ilman oikeudenkäyntiä. Hänen on saatava puolustautua syyttäjiensä läsnäollessa. ");
INSERT INTO fin_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Juutalaisten johtomiehet tulivat tänne, ja otin tapauksen heti seuraavana päivänä käsiteltäväksi. Paavali tuotiin oikeuteen. ");
INSERT INTO fin_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Syytökset eivät kuitenkaan olleet lainkaan sellaisia kuin olin odottanut. ");
INSERT INTO fin_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Kiista koski heidän uskontoaan ja jotakin Jeesus-nimistä miestä, joka on kuollut mutta jonka Paavali väittää elävän. ");
INSERT INTO fin_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","En tiennyt, miten tällainen riita on ratkaistava ja kysyin Paavalilta, tahtoisiko hän vastata syytöksiin Jerusalemin oikeusistuimessa. ");
INSERT INTO fin_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Silloin hän vetosi keisariin. Lähetin hänet vankilaan odottamaan kuljetusta keisarin luo.» ");
INSERT INTO fin_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","»Minua kiinnostaisi itse kuulla, mitä se mies puhuu», Agrippa sanoi. »Huomenna sinulla on siihen tilaisuus», Festus vastasi. ");
INSERT INTO fin_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Seuraavana päivänä kuningas ja Bernike tulivat loisteliaasti upseerien ja kaupungin johtomiesten saattelemina oikeussaliin. Festus käski tuoda Paavalin ja avasi istunnon: ");
INSERT INTO fin_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","»Kuningas Agrippa, hyvät läsnäolijat. Sekä tämän kaupungin että Jerusalemin juutalaiset vaativat syytetyn kuolemaa. ");
INSERT INTO fin_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mielestäni hän ei ole sitä ansainnut. Koska hän vetosi keisariin, minun on lähetettävä hänet Roomaan. ");
INSERT INTO fin_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","En kuitenkaan ymmärrä, mitä kirjoittaa hänestä keisarille. Siksi toin vangin tänne tutkittavaksi. Toivon, että te kaikki, ja varsinkin kuningas Agrippa, voisitte auttaa minua syytöskirjelmän laatimisessa, ");
INSERT INTO fin_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","sillä on järjetöntä lähettää vanki keisarin luo, jos häntä ei syytetä mistään.» ");
INSERT INTO fin_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa sanoi Paavalille: »No niin, saat puhua.» Paavali aloitti käsillään elehtien: ");
INSERT INTO fin_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","»Minulle on suuri onni, että saan puolustautua sinun läsnäollessasi, kuningas Agrippa. ");
INSERT INTO fin_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Sinähän olet juutalaisten lakien ja tapojen erikoistuntija. Toivon, että jaksat sen tähden kuunnella minua kärsivällisesti! ");
INSERT INTO fin_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Kuten juutalaiset hyvin tietävät, sain uskontomme mukaisen kasvatuksen lapsena Tarsossa ja myöhemmin Jerusalemissa. ");
INSERT INTO fin_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Jos he vain haluavat myöntää, he voivat todistaa, että noudatin ankarana fariseuksena erittäin tarkasti juutalaisten lakia ja tapoja. ");
INSERT INTO fin_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Syytösten takana on kuitenkin jotain muuta: se, että minä luotan lupaukseen, jonka Jumala antoi esi-isillemme. ");
INSERT INTO fin_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Israelin kaksitoista heimoa odottavat yötä päivää tämän lupauksen toteutumista. Jostakin syystä minua kuitenkin pidetään tämän toivon tähden rikollisena. ");
INSERT INTO fin_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Onko rikollista uskoa ylösnousemukseen? Onko teistä mahdotonta uskoa, että Jumala herättää kuolleet? ");
INSERT INTO fin_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Luulin aikaisemmin, että minun pitää taistella kaikin voimin Jeesus Nasaretilaiseen uskovia vastaan. ");
INSERT INTO fin_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Vangitsin heitä joukoittain ylipappien luvalla Jerusalemissa ja äänestin heidän kuolemantuomionsa puolesta. ");
INSERT INTO fin_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Yritin kiduttamalla saada kristittyjä kiroamaan Kristuksen. Etsin heitä kiihkoissani kaukaa ulkomaiden kaupungeistakin. ");
INSERT INTO fin_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Ylipappien valtuuttamana lähdin kerran Damaskoon tällaiselle matkalle. ");
INSERT INTO fin_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Olimme tiellä, kun puolen päivän aikaan minun ja matkatovereideni ympärillä leimahti äkkiä auringonpaistetta kirkkaampi valo. ");
INSERT INTO fin_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Kaaduimme kaikki maahan, ja kuulin äänen kysyvän hepreaksi: ’Saul, Saul, miksi vainoat minua? Vahingoitat sillä vain itseäsi.’ ");
INSERT INTO fin_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Kysyin puhujalta: ’Kuka oikein olet?’ Ääni vastasi: ’Olen Jeesus, jota vainoat. ");
INSERT INTO fin_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nouse seisomaan! Olen ilmestynyt sinulle siksi, että teen sinusta palvelijani ja todistajani. Sinun on kerrottava maailmalle mitä nyt näit ja mitä vielä saat nähdä. ");
INSERT INTO fin_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Suojelen sinua sekä juutalaisilta että pakanoilta, joiden luokse sinut lähetän. ");
INSERT INTO fin_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tehtäväsi on avata heidän silmänsä näkemään totuus: turvautumalla minuun he voivat tulla pimeydestä, saatanan hallinnasta, Jumalan valoon, saada syntinsä anteeksi ja periä ikuisen elämän yhdessä muiden Jumalan lasten kanssa.’ ");
INSERT INTO fin_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Ymmärrät varmasti, kuningas Agrippa, etten voinut olla tottelematta tuota ääntä. ");
INSERT INTO fin_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Julistin ensin Damaskossa, sitten Jerusalemissa ja koko Juudeassa – ja myös pakanoille, että kaikkien on luovuttava synneistään ja tultava Jumalan luo. Elämänmuutos näkyisi sitten arkipäivän toiminnassa. ");
INSERT INTO fin_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Tästä asiasta saamasin temppelissä, kun juutalaiset ottivat minut kiinni ja yrittivät tappaa. ");
INSERT INTO fin_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Jumala on suojellut minua, niin että olen saanut kulkea puhumassa sekä pienille että suurille. Myös Mooses ja profeetat julistivat samaa sanomaa: ");
INSERT INTO fin_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Messias joutuu kärsimään, herää ensimmäisenä kuolleista ja on sen tähden uusi valo sekä pakanoille että juutalaisille.» ");
INSERT INTO fin_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Silloin Festus huusi: »Olet hullu! Uskonto on sekoittanut pääsi!» ");
INSERT INTO fin_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Mutta Paavali vastasi: »Ei suinkaan, arvoisa maaherra, olen täysin järjissäni ja kaikki, mitä olen puhunut, on totta. ");
INSERT INTO fin_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Kuningas Agrippalle nämä asiat ovat tuttuja, ja siksi puhun rohkeasti. Nämähän eivät ole tapahtuneet missään syrjäkulmilla. ");
INSERT INTO fin_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kuningas, uskotko profeettojen kirjoituksiin? Tiedän, että uskot.» ");
INSERT INTO fin_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa sanoi: »Vähälläpä luulet tekeväsi minusta kristityn.» ");
INSERT INTO fin_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paavali vastasi: »Vähällä tai paljolla: rukoilen Jumalaa, että teistä kaikista tulisi samanlaisia kuin minä – ilman kahleita tietysti!» ");
INSERT INTO fin_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kuningas, maaherra, Bernike ja muu yleisö poistuivat salista. ");
INSERT INTO fin_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Keskustellessaan asiasta keskenään he totesivat: »Ei tämä mies ansaitse vankeutta tai kuolemantuomiota.» ");
INSERT INTO fin_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa huomautti Festukselle: »Hänet olisi voinut päästää vapaaksi, ellei hän olisi vedonnut keisariin.» ");
INSERT INTO fin_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Kaikki oli viimein kunnossa Italian-matkaamme varten. Paavali ja muutama muu vanki joutuivat Juliuksen, keisarillisen joukko-osaston päällikön, valvontaan. ");
INSERT INTO fin_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Lähdimme purjehtimaan kreikkalaisella laivalla, jonka oli tarkoitus pysähtyä useissa Vähän-Aasian satamissa. Mukanamme oli myös kreikkalainen Aristarkus Tessalonikasta. ");
INSERT INTO fin_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Pysähdyimme seuraavana päivänä Siidonissa. Julius oli Paavalille hyvin ystävällinen ja antoi hänen mennä maihin tapaamaan ystäviä ja nauttimaan heidän vieraanvaraisuudestaan. ");
INSERT INTO fin_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Lähdettyämme taas merelle purjehdimme vastatuulen takia Kyproksen pohjoispuolelta saaren ja mantereen välistä. ");
INSERT INTO fin_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ohitimme Kilikian ja Pamfylian rannikot ja laskimme maihin Lykian Myraan. ");
INSERT INTO fin_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Päällikkömme huomasi siellä aleksandrialaisen laivan, joka oli menossa Italiaan, ja siirryimme siihen. ");
INSERT INTO fin_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Purjehtiminen oli seuraavina päivinä vaivalloista. Pääsimme lopulta Knidoksen kohdalle, mutta koska tuuli oli käynyt todella kovaksi, jatkoimme matkaa Salmonen niemen ohi Kreetan suojiin. ");
INSERT INTO fin_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Etenimme hitaasti sen rannikkoa pitkin ja tulimme Lasaian kaupungin lähellä sijaitsevaan paikkaan, jonka nimi oli Kauniit satamat. ");
INSERT INTO fin_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Jäimme sinne moneksi päiväksi. Sää alkoi käydä pitkille merimatkoille vaaralliseksi, koska oli jo myöhäissyksy. Paavali huomautti tästä laivan miehistölle. ");
INSERT INTO fin_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","»Kuulkaa, on varmasti vaarallista jatkaa nyt matkaa. Voimme joutua haaksirikkoon, ja meiltä menee sekä laiva että lasti – ehkä vielä henkikin», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Vangeista vastaava upseeri uskoi kuitenkin laivanvarustajaa ja kapteenia enemmän kuin Paavalia. ");
INSERT INTO fin_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Koska olimme avosatamassa, jossa talvehtiminen olisi hankalaa, useimmat halusivat lähteä yrittämään Foiniksiin, erääseen Kreetan satamaan. Se oli avoin vain lounaaseen ja luoteeseen. ");
INSERT INTO fin_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Alkoi juuri sopivasti tuulla etelästä, ja suunnitelman toteuttaminen näytti mahdolliselta. Ankkuri nostettiin, ja lähdettiin purjehtimaan pitkin rannikkoa. ");
INSERT INTO fin_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","15","Pian ilma yllättäen muuttui, ja laiva joutui rajun koillismyrskyn kouriin. Miehet eivät yrityksistään huolimatta pystyneet enää ohjaamaan sitä rannikolle, ja niin olimme tuuliajolla. ");
INSERT INTO fin_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Pienen Klauda-nimisen saaren suojissa onnistuimme töin tuskin kiskomaan turvaan pelastusveneen, jota olimme siihen asti hinanneet perässämme. ");
INSERT INTO fin_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Sen jälkeen laivan ympärille sidottiin köysiä. Merimiehet pelkäsivät, että ajautuisimme Afrikan rannikon hiekkasärkille, ja laskivat purjeet. Ajelehdimme tuulessa päämäärättömästi. ");
INSERT INTO fin_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Kun merenkäynti yhä yltyi, miehistö heitti seuraavana päivänä lastin yli laidan, ");
INSERT INTO fin_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","ja kolmantena päivänä heitimme yhteisvoimin kaiken irtaimen mereen. ");
INSERT INTO fin_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Kauhea myrsky raivosi vuorokausikaupalla, ja kun meillä ei ollut aavistustakaan, missäpäin olimme, menetimme lopulta kaiken toivon selvitä hengissä. ");
INSERT INTO fin_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Moneen päivään ei ollut syöty mitään. Lopulta Paavali kutsui miehistön kokoon ja sanoi: »Jos olisitte uskoneet minua ja jääneet Kreetaan, olisitte säästyneet tältä vahingolta. ");
INSERT INTO fin_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mutta älkää hätäilkö! Kukaan meistä ei huku, vaikka laiva uppoaakin. ");
INSERT INTO fin_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Viime yönä Jumalani, jota palvelen, lähetti enkelinsä ");
INSERT INTO fin_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","sanomaan minulle: ’Älä pelkää, Paavali, sinä pääset perille keisarin luo! Jumala on myös kuullut rukouksesi ja pelastaa kaikki matkatoverisi.’ ");
INSERT INTO fin_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Älkää siis ollenkaan pelätkö! Uskon Jumalaa, ja varmasti käy niin kuin hän on sanonut. ");
INSERT INTO fin_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Mutta aallot heittävät laivan ilmeisesti jonkin saaren rantaan.» ");
INSERT INTO fin_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Tuli neljästoista yömme myrskyn kourissa Välimerellä. Puolenyön aikaan merimiehistä alkoi tuntua, että lähestyimme maata. ");
INSERT INTO fin_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","He luotasivat ja totesivat, että syvyys oli neljäkymmentä metriä. Vähän ajan kuluttua se oli vain kolmekymmentä metriä. ");
INSERT INTO fin_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Laiva siis lähestyi rantaa koko ajan. Merimiehet pelkäsivät kareja ja laskivat perästä neljä ankkuria. Aamun valkenemista odotettiin hartaasti. ");
INSERT INTO fin_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Muutamat merimiehet aikoivat lähteä laivasta ja irrottivat pelastusveneen laskeakseen muka keulasta ankkureita mereen. ");
INSERT INTO fin_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paavali sanoi silloin päällikölle ja sotilaille: »Jos yksikin lähtee, kuolette kaikki.» ");
INSERT INTO fin_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Sotilaat hakkasivat veneen köydet poikki ja päästivät sen menemään. ");
INSERT INTO fin_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Aamuyöllä Paavali kehotti kaikkia syömään. »Ettehän ole kahteen viikkoon syöneet mitään», hän totesi. ");
INSERT INTO fin_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","»Nyt tarvitsemme voimaa. Hiuskarvakaan ei katoa päästänne.» ");
INSERT INTO fin_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Sitten hän otti leipäpalasen, kiitti kaikkien nähden Jumalaa ja rupesi syömään. ");
INSERT INTO fin_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Muillekin tuli äkkiä parempi olo ja he rupesivat syömään. ");
INSERT INTO fin_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Meitä oli kaikkiaan 276 henkeä. ");
INSERT INTO fin_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Syönnin jälkeen alusta kevennettiin vielä heittämällä vilja mereen. ");
INSERT INTO fin_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Kun päivä vaikeni, he näkivät oudon rannikon. Siinä oli lahdenpoukama, johon laiva päätettiin yrittää ohjata. ");
INSERT INTO fin_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ankkurit hakattiin poikki ja jätettiin mereen. Peräsimet irrotettiin, keulapurje nostettiin ja laivaa ohjattiin kohti rantaa. ");
INSERT INTO fin_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mutta laiva joutui vedenalaiselle karikolle ja juuttui keulastaan kiinni. Peräpuoli alkoi hajota aallokossa. ");
INSERT INTO fin_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sotilaat halusivat tappaa vangit, etteivät he pääsisi uimalla karkuun. ");
INSERT INTO fin_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Päällikkö halusi säästää Paavalin ja kielsi sotilaita toteuttamasta suunnitelmaansa. Hän käski uimataitoisten hypätä ensin veteen ja lähteä maihin ");
INSERT INTO fin_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","ja muiden käyttää apunaan lautoja ja laivankappaleita. Tällä tavoin kaikki pääsivät turvaan. ");
INSERT INTO fin_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","2","Saimme pian tietää tulleemme Maltan saarelle. Asukkaat ottivat meidät ystävällisesti vastaan. He sytyttivät rantaan nuotion, sillä ilma oli sateinen ja kylmä. ");
INSERT INTO fin_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Kun Paavali keräili nuotioon risuja, lämmön esiin houkuttelema kyykäärme pureutui hänen käteensä. ");
INSERT INTO fin_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Saaren asukkaat mutisivat keskenään: »Tuo on kyllä varmasti murhaaja, kun oikeuden jumalatar ei anna hänen elää, vaikka hän selvisi hengissä haaksirikosta.» ");
INSERT INTO fin_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Mutta Paavali ravisti käärmeen kädestään nuotioon, eikä hänen käynyt kuinkaan. ");
INSERT INTO fin_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ihmiset odottivat, että hän alkaisi turvota tai kaatuisi äkkiä kuolleena maahan. Kun aika kului, eikä mitään tapahtunut, he alkoivatkin pitää Paavalia jumalana. ");
INSERT INTO fin_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Lähellä rantaa oli saaren merkittävimmän miehen, Publiuksen, maatila. Hän otti meidät luokseen toipumaan ja piti ystävällisesti kolme päivää vierainaan. ");
INSERT INTO fin_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publiuksen isä sattui olemaan kovassa kuumeessa ja punataudissa. Paavali meni sairaan luo, rukoili hänen puolestaan ja paransi hänet panemalla kätensä hänen päälleen. ");
INSERT INTO fin_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Tämän jälkeen tulivat saaren muutkin sairaat parannettaviksi. ");
INSERT INTO fin_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Saimme osaksemme monenlaisia kunnianosoituksia, ja kun lähdimme jatkamaan matkaa, saimme laivaan kaikkea, mitä tarvitsimme. ");
INSERT INTO fin_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Lähtö tapahtui vasta kolmen kuukauden kuluttua haaksirikosta. Pääsimme saarella talvehtineeseen aleksandrialaiseen laivaan, nimeltä Castor ja Pollux. ");
INSERT INTO fin_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Ensimmäinen pysähdyspaikkamme oli Syrakusa, jonne jäimme kolmeksi päiväksi. ");
INSERT INTO fin_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Sieltä kiersimme Regiumiin, ja kun seuraavana päivänä alkoi tuulla etelästä, pääsimme vuorokaudessa Puteoliin. ");
INSERT INTO fin_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Olimme siellä yhteydessä uskoviin, ja he pyysivät meitä jäämään luokseen viikoksi. Sen jälkeen purjehdimme Roomaan. ");
INSERT INTO fin_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Kun Rooman kristityt kuulivat, että olimme tulossa, he lähtivät meitä vastaan Appiuksen torille ja Kolmen majatalon luo. Heidän tapaamisensa antoi Paavalille uutta rohkeutta, ja hän kiitti Jumalaa. ");
INSERT INTO fin_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Paavali sai Roomassa asua sotilaan vartioimana missä tahtoi. ");
INSERT INTO fin_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Kolme päivää tulonsa jälkeen hän kutsui kokoon paikalliset juutalaisten johtajat ja kertoi heille: »Hyvät veljet. Juutalaiset pidättivät minut Jerusalemissa ja luovuttivat oikeudenkäyntiä varten roomalaisille, vaikka en ollut aiheuttanut kenellekään vahinkoa enkä loukannut perinnäistapojamme. ");
INSERT INTO fin_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Roomalaiset järjestivät oikeudenkäynnin ja olisivat vapauttaneet minut, koska en ollut tehnyt kuolemaa ansaitsevaa rikosta. ");
INSERT INTO fin_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Minulla ei ole mitään kansaani vastaan, mutta kun juutalaiset vastustivat oikeuden päätöstä, minun oli vedottava keisariin. ");
INSERT INTO fin_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Pyysin teitä tulemaan nyt tänne, että voisimme tutustua toisiimme. Haluaisin kertoa, miksi olen vangittuna: uskon, että Messias on tullut.» ");
INSERT INTO fin_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Juutalaisten johtajat vastasivat: »Kukaan Juudeasta ei ole kirjoittanut sinusta mitään, eivätkä Jerusalemista tulleet juutalaiset ole puhuneet sinusta pahaa. ");
INSERT INTO fin_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Haluaisimme kuitenkin kuulla, mihin oikein uskot, sillä kristittyjähän arvostellaan joka paikassa ankarasti.» ");
INSERT INTO fin_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Sovittuna ajankohtana Paavalin asunnolle tuli heidän lisäkseen monia muitakin. Paavali kertoi heille Jumalan valtakunnasta ja opetti, mitä Mooseksen ja profeettojen kirjoissa oli sanottu Jeesuksesta. Aamulla hän aloitti puheensa ja jatkoi sitä aina iltaan asti. ");
INSERT INTO fin_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Osa kuuntelijoista uskoi, osa ei. ");
INSERT INTO fin_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Kiisteltyään keskenään asiasta he lähtivät pois. Paavali totesi: »Pyhä Henki oli oikeassa sanoessaan Jesajan välityksellä: ");
INSERT INTO fin_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","’Sano juutalaisille: Te kuulette ja näette, mutta ette ymmärrä, ");
INSERT INTO fin_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","sillä sydämenne ovat kovettuneet, korvanne eivät kuule ja silmänne ovat pimeät, koska ette halua käsittää, mistä on kysymys, ettekä tulla minun parannettavakseni.’ ");
INSERT INTO fin_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","29","Muistakaa, että Jumala haluaa myös pakanoiden pelastuvan, ja he kyllä uskovat kun kerron heille Jeesuksesta.» ");
INSERT INTO fin_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paavali asui omassa vuokra-asunnossaan kaksi vuotta ja otti mielellään vastaan vieraita. ");
INSERT INTO fin_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Hän kertoi heille rohkeasti Jumalan valtakunnasta ja Jeesuksesta, eikä kukaan yrittänyt estää häntä.");
INSERT INTO fin_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Rakkaat Roomassa asuvat ystävät! Tämä kirje on Paavalilta, Jeesuksen Kristuksen palvelijalta, jonka Jumala on kutsunut työhönsä ja lähettänyt levittämään hyvää uutistaan. ");
INSERT INTO fin_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Jumalan profeetat ovat Vanhassa testamentissa jo kauan sitten luvanneet, että ihmiskunta kerran saisi kuulla tämän uutisen. ");
INSERT INTO fin_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Sen sisältö on tämä: Jumalan Poika, Jeesus Kristus, meidän Herramme, syntyi ihmislapsena Daavidin kuningassukuun. ");
INSERT INTO fin_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Hänen kuolleista herättämisensä todisti, että hän on Jumalan Poika, joka on pyhä niin kuin Jumala ja jolla on voima. ");
INSERT INTO fin_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Kristuksen tähden Jumalan hyvyys tulvii meille syntisille, vaikka emme sitä ansaitsekaan. Jumala lähettää meidät maailman ääriin kertomaan kaikille ihmisille kaikkialla niistä valtavista teoista, jotka hän on tehnyt heidän puolestaan, jotta hekin alkaisivat uskoa häneen ja noudattaa hänen tahtoaan. ");
INSERT INTO fin_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","7","Tekin, rakkaat Rooman ystävät, kuulutte niihin, joita Jumala rakastaa. Teidätkin Jeesus on kutsunut tulemaan Jumalan omiksi – niin, hänen pyhäksi kansakseen. Tulkoon elämäänne armo ja rauha Jumalalta, Isältämme, ja Jeesukselta Kristukselta, Herraltamme. ");
INSERT INTO fin_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ensiksi minun on kerrottava, että minne tahansa menenkin, kuulen puhuttavan teistä! Teidän uskonne Jumalaan tunnetaan pian kaikkialla. Miten kiitänkään Jumalaa Jeesuksen Kristuksen tähden hyvästä maineestanne ja teistä jokaisesta! ");
INSERT INTO fin_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Jumala tietää, että rukoilen usein teidän puolestanne. Öin ja päivin puhun teistä ja teidän tarpeistanne Jumalalle, jota koko sydämestäni palvelen levittämällä hyvää uutista hänen Pojastaan. ");
INSERT INTO fin_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Rukoilen myös jatkuvasti, että voisin vihdoinkin, jos Jumala sallii, tulla teitä katsomaan ja että pääsisin hyvin perille. ");
INSERT INTO fin_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","12","Haluaisin mielelläni tavata teidät voidakseni vahvistaa uskoanne, että seurakuntanne tulisi vahvaksi Herrassa. Minäkin puolestani tarvitsen teitä, sillä en tahdo vain jakaa uskostani teille, vaan haluan myös itse saada rohkaisua. Näin me voimme tukea toinen toisiamme. ");
INSERT INTO fin_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Rakkaat ystävät, teidän on hyvä tietää, että olen monta kertaa aikaisemminkin halunnut tulla luoksenne, mutta aina minulle on tullut este. Tahtoisin tehdä työtä keskellänne ja nähdä työstäni myös tuloksia, aivan niin kuin olen saanut nähdä muidenkin kansojen keskuudessa. ");
INSERT INTO fin_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Tunnen olevani paljon velkaa sekä teille että kaikille muille kansoille – niin vanhoille sivistysmaille kuin muulle maailmalle, sekä oppineille että oppimattomille ihmisille. ");
INSERT INTO fin_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Sen vuoksi olen valmis tulemaan myös teidän luoksenne Roomaan julistamaan Jumalan hyvää sanomaa. ");
INSERT INTO fin_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","En näet häpeä uutista Kristuksesta. Se on Jumalan pelastava voima kaikille ihmisille, jotka ottavat sen uskoen vastaan. Ensin tätä sanomaa tosin julistettiin vain juutalaisille, mutta nyt Jumala kutsuu luokseen kaikkia ihmisiä. ");
INSERT INTO fin_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Hyvän uutisen sisältö on tämä: Jumala hyväksyy meidät omikseen, kun luotamme Kristukseen ja uskomme siihen, että hän sovitti meidän syntimme. Sanoohan Raamattu: »Ihminen, joka turvautuu Jumalaan, löytää elämän.» ");
INSERT INTO fin_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Mutta Jumalan viha tulee niiden turmeltuneiden ihmisten osaksi, jotka työntävät luotaan totuuden, ");
INSERT INTO fin_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","sillä he tietävät jo vaistonvaraisesti totuuden Jumalasta. ");
INSERT INTO fin_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Aikojen alusta heillä on ollut silmiensä edessä Jumalan luomistyö, maa ja taivas, ja he ovat olleet tietoisia hänen olemassaolostaan ja valtavasta, ikuisesta voimastaan. Siksi heillä ei ole mitään sanottavaa puolustuksekseen, kun he tuomiopäivänä seisovat Jumalan edessä. ");
INSERT INTO fin_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","He kyllä tietävät hänestä, mutta eivät ole halunneet myöntää sitä, eivät kunnioittaa häntä eivätkä kiittää häntä hänen päivittäisestä huolenpidostaan. Niin he ovat vähitellen saaneet päähänsä järjettömiä kuvitelmia siitä, millainen Jumala on tai mitä hän tahtoo heidän tekevän. Tämän vuoksi he ovat joutuneet sisäiseen pimeyteen. ");
INSERT INTO fin_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Kerskuessaan omasta viisaudestaan he paljastavatkin tyhmyytensä. ");
INSERT INTO fin_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ja sen sijaan että palvoisivat elävää Jumalaa, he ovat puusta ja kivestä tehneet itselleen epäjumalia. He ovat veistäneet omat jumalansa lintujen, nelijalkaisten eläinten, käärmeiden ja kuolevaisten ihmisten näköisiksi. ");
INSERT INTO fin_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Niinpä Jumala on jättänyt heidät omiin oloihinsa tekemään mitä tahtovat: heidän sukupuolielämänsäkin on luonnotonta, ja siten he ovat häpäisseet toinen toisensa ruumiin. ");
INSERT INTO fin_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Sen sijaan että olisivat uskoneet todeksi sen, mitä ovat tienneet Jumalasta, he ovat ehdoin tahdoin uskoneet valheisiin. Niin he ovat palvoneet sellaista, minkä Jumala on luonut, mutta eivät ole suostuneet tottelemaan kaiken Luojaa, Jumalaa. Häntähän heidän tulisi ylistää. ");
INSERT INTO fin_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","27","Sen vuoksi Jumala antoi heidän olla ja elää häpeällisten himojensa mukaisesti: he ovat antaneet vallan homoseksuaalisille haluilleen ja saaneet ansaitsemansa rangaistuksen. ");
INSERT INTO fin_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Kun he luopuivat Jumalasta eivätkä tahtoneet edes tunnustaa hänen olemassaoloaan, Jumala hylkäsi heidät ja antoi heidän tehdä sitä, mihin heidän paha sydämensä heitä yllytti. ");
INSERT INTO fin_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Heidän elämänsä on täynnä kaikkea vääryyttä ja pahuutta, ahneutta ja vihaa, kateutta, murhaa, riitaa, valhetta, katkeruutta ja juoruilua. ");
INSERT INTO fin_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","He ovat panettelijoita, Jumalan vihaajia, röyhkeitä ja ylpeitä kerskureita, jotka etsivät aina uusia synnin teitä eivätkä piittaa vanhemmistaan. ");
INSERT INTO fin_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","He ovat ymmärtämättömiä. He rikkovat lupauksensa ja ovat sydämettömiä ihmisiä, jotka eivät tunne sääliä. ");
INSERT INTO fin_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","He ovat täysin selvillä siitä, että Jumala on määrännyt kuolemantuomion näistä rikoksista, mutta kuitenkin he yhä jatkavat samaa elämäntapaa ja yllyttävät siihen toisiakin. ");
INSERT INTO fin_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Nyt ehkä sanot: »Kuinka kauheista ihmisistä puhutkaan!» Mutta odota! Olet itse samanlainen: kun tuomitset toista, tuomitset itsesi. ");
INSERT INTO fin_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Tiedämme, että Jumala on oikeudenmukainen ja rankaisee jokaista, joka tekee pahaa. ");
INSERT INTO fin_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Vai ajatteletko ehkä, että Jumala tuomitsee toiset heidän pahojen tekojensa mukaan, mutta katsoo sinun tekojasi sormiensa läpi? ");
INSERT INTO fin_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Etkö tajua, kuinka kärsivällinen hän on sinua kohtaan? Vai eikö se merkitse sinulle mitään? Etkö näe, että hän on halunnut antaa sinulle aikaa luopua synnistä? Kun hän näin osoittaa hyvyyttään, hän tahtoo saada sinut hylkäämään pahuutesi. ");
INSERT INTO fin_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Mutta sinä et tahdo edes kuunnella! Näin valmistat itsellesi rangaistusta, kun jääräpäisesti paadutat sydämesi. Kerran tulee vihan päivä, jolloin Jumala tuomitsee oikeudenmukaisesti koko maailman. ");
INSERT INTO fin_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Hän antaa jokaiselle, mitä tämän teot ansaitsevat. ");
INSERT INTO fin_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Ikuisen elämän hän antaa niille, jotka kärsivällisesti toteuttavat elämässään Jumalan tahtoa ja tavoittelevat näkymätöntä kirkkautta ja kunniaa sekä kuolemattomuutta. ");
INSERT INTO fin_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Mutta Jumalan viha kohtaa niitä, jotka taistelevat hänen totuuttaan vastaan ja elävät itsekkäästi. ");
INSERT INTO fin_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Tuska ja ahdistus tulevat niin juutalaisen kuin pakanankin osaksi, jos hän jatkaa kelvotonta elämäänsä. ");
INSERT INTO fin_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Mutta Jumalan kirkkaus, kunnia ja rauha tulvivat kaikille niille, jotka tottelevat häntä, riippumatta siitä ovatko he juutalaisia vai muiden kansojen jäseniä. ");
INSERT INTO fin_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Jumala kohtelee kaikkia ihmisiä samalla tavalla. ");
INSERT INTO fin_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","13-14-15","Syntiä seuraa aina Jumalan rangaistus. Pakanatkin saavat synneistään rangaistuksen, vaikkei heillä olekaan Jumalan kirjoitettua lakia, sillä sydämessään he tietävät, mikä on oikein ja mikä väärin. Jumalan laki on kuitenkin kirjoitettu heidän sisimpäänsä. Heidän omatuntonsa joko syyttää heitä tai sanoo, että he ovat tehneet oikein. Juutalaiset Jumala tuomitsee siitä, että heillä on hänen lakinsa kirjoitettuna, mutta he eivät elä sen mukaan. He tietävät, mikä on oikein, mutta eivät tee niin. Pelkkä tieto Jumalan tahdosta ei kuitenkaan riitä, vaan sen mukaan on myös elettävä. ");
INSERT INTO fin_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Kerran tulee päivä, jolloin Jeesus Kristus Jumalan käskystä paljastaa kaikkien ihmisten elämän salaisuudet, heidän sisimmät ajatuksensa ja vaikuttimensa. Tämä kaikki kuuluu osana siihen Jumalan suureen suunnitelmaan, jota minäkin julistan. ");
INSERT INTO fin_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Juutalaisena sinä ajattelet, että kaikki on hyvin sinun ja Jumalan välillä, koska hän antoi lakinsa juutalaisille. Kehut kuuluvasi hänen erityisiin ystäviinsä. ");
INSERT INTO fin_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Sinä tiedät, mitä hän tahtoo; osaat erottaa hyvän pahasta ja suosit hyvää, koska sinulle on lapsesta saakka opetettu hänen käskyjään. ");
INSERT INTO fin_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Luulet tuntevasi tien Jumalan luo niin tarkkaan, että voisit osoittaa sen vaikka sokealle. Olet kai mielestäsi kuin kirkas majakka, joka johtaa pimeyteen eksyneitä ihmisiä Jumalan luo. ");
INSERT INTO fin_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","Luulet pystyväsi ohjaamaan yksinkertaisia ihmisiä ja jopa opettamaan lapsille Jumalan tuntemista; sinähän tunnet hänen lakinsa, joka on täynnä tietoa ja totuutta Jumalasta. ");
INSERT INTO fin_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Opetat kyllä toisia, miksi et sitten opeta itseäsi? Kiellät toisia varastamasta, mutta varastat itse. ");
INSERT INTO fin_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Sanot, että on väärin olla aviopuolisolleen uskoton, mutta syyllistyt itse samaan. Sanot: »Älkää rukoilko epäjumalia», ja pidät silti rahaa omana jumalanasi. ");
INSERT INTO fin_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Olet kovin ylpeä siitä, että tunnet Jumalan lain, mutta häpäiset hänet rikkomalla sen. ");
INSERT INTO fin_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Onko sitten ihme, että Raamattu sanoo maailman puhuvan pahaa Jumalasta sinunlaistesi tähden? ");
INSERT INTO fin_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Sinun juutalaisuudellasi on arvoa, jos tottelet Jumalan lakia. Mutta jos et sitä tee, et ole sen kummempi kuin pakanatkaan. ");
INSERT INTO fin_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Jos pakanat noudattavat Jumalan lakia, eikö Jumala anna heille kaikki ne oikeudet ja sen kunnian, jotka hän oli varannut juutalaisille? ");
INSERT INTO fin_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Itse asiassa – jos pakana noudattaa Jumalan lakia paremmin kuin juutalainen, niin hän elämällään tuomitsee sinut. Te juutalaiset tiedätte paljon Jumalasta ja teillä on hänen lupauksensa, mutta te ette silti noudata hänen lakiaan. ");
INSERT INTO fin_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Ette te ole oikeita juutalaisia vain sen tähden, että olette syntyneet juutalaisista vanhemmista, tai sen tähden, että teidät on juutalaisen tavan mukaan ympärileikattu. ");
INSERT INTO fin_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Todellisia juutalaisia ovat kaikki ne ihmiset, joiden suhde Jumalaan on oikea. Jumala ei etsi niitä, jotka leikkelevät ruumistaan ympärileikkauksella, vaan niitä, joiden sydän ja mieli on muuttunut. Sellainen ihminen, jonka elämässä tämä muutos on tapahtunut, saa kiitoksensa Jumalalta, vaikkei hän sitä ihmisiltä saisikaan. ");
INSERT INTO fin_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Mitä hyötyä sitten on juutalaisuudesta? Onko Jumala antanut juutalaisille joitakin erityisiä etuja? Onko ympärileikkausmenoilla mitään arvoa? Kyllä on! ");
INSERT INTO fin_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Juutalaisilla on monia etuoikeuksia. Ensiksikin, Jumala uskoi juutalaisille lakinsa, että he tuntisivat hänen tahtonsa ja noudattaisivat sitä. ");
INSERT INTO fin_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","On totta, että muutamat heistä olivat tottelemattomia. Mutta tarvitseeko tämän merkitä sitä, että Jumala rikkoisi oman lupauksensa? ");
INSERT INTO fin_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ei tietenkään! Vaikka jokainen ihminen maailmassa onkin valehtelija, Jumala ei ole. Psalmeissahan sanotaan, että Jumalan sanat osoittautuvat aina tosiksi ja oikeiksi, vaikka kuka tahansa nousisi niitä vastaan. ");
INSERT INTO fin_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Jotkut ihmiset sanovat: »On vain hyvä, että me olemme tottelemattomia Jumalalle; meidän syntimme palvelevat hyvää tarkoitusta. Ihmiset huomaavat, kuinka hyvä Jumala on, kun näkevät, miten huonoja me olemme. Tekeekö Jumala siis oikein rangaistessaan meitä, jos meidän syntimme kerran auttavat häntä?» ");
INSERT INTO fin_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Mitä hölynpölyä! Millainen Jumala se olisi, joka katsoo syntiä sormien läpi? Kuinka sellainen Jumala voisi tuomita ainuttakaan ihmistä? ");
INSERT INTO fin_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Eihän hän voisi tuomita minua synneistäni, jos epärehellisyyteni toisi hänelle kunniaa, kun hänen rehellisyytensä korostuisi minun valheellisuuteni vastakohtana. ");
INSERT INTO fin_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Eli toisin sanoen: »Mitä pahempia me olemme, sitä enemmän se Jumalaa miellyttää!» Näinhän muutamat pilkaten väittävät meidän sanovankin. He ansaitsevat Jumalan tuomion. ");
INSERT INTO fin_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Olemmeko me juutalaiset sitten parempia kuin muut ihmiset? Emme suinkaan, olemmehan jo osoittaneet, että kaikki ihmiset ovat syntisiä, olivatpa he sitten juutalaisia tai muiden kansojen jäseniä. ");
INSERT INTO fin_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Raamattu sanookin: »Kukaan ei ole hyvä – koko maailmassa ei ole ainuttakaan synnitöntä ihmistä. ");
INSERT INTO fin_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ei ole ketään, joka olisi täysin noudattanut Jumalan tahtoa tai edes todella halunnut sitä noudattaa. ");
INSERT INTO fin_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Jokainen on poikennut pois Jumalan tieltä. Kaikki ovat menneet harhaan. Mistään ei löydy ihmistä, joka olisi tehnyt pelkkää hyvää. Sellaista ihmistä ei kerta kaikkiaan ole. ");
INSERT INTO fin_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ihmisten puheet ovat likaisia ja iljettäviä kuin avoimesta haudasta tuleva löyhkä. He syytävät suustaan valheita ja heillä on pistävä kieli kuin myrkkykäärmeellä. ");
INSERT INTO fin_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Heidän suunsa on täynnä kirouksia ja katkeruutta. ");
INSERT INTO fin_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","He ovat nopeita tappamaan ja vihaavat jokaista, joka heitä vastustaa. ");
INSERT INTO fin_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Minne he menevätkin, he jättävät jälkeensä kurjuutta ja kärsimystä. ");
INSERT INTO fin_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Todellisesta rauhasta ja Jumalan siunauksesta he eivät tiedä mitään. ");
INSERT INTO fin_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","He eivät piittaa Jumalasta eivätkä siitä, mitä hän heistä ajattelee.» ");
INSERT INTO fin_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Tiedämme, että Jumalan tuomio kohtaa raskaasti juuri juutalaisia, sillä he ovat sitoutuneet pitämään Jumalan lait. Kukaan ei voi itseään puolustaa – koko maailma seisoo syyllisyytensä mykistämänä kaikkivaltiaan Jumalan edessä. ");
INSERT INTO fin_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Joko nyt ymmärrätte? Kukaan ei kykene niin noudattamaan lakia, että hän sen perusteella kelpaisi Jumalalle. Päinvastoin: mitä paremmin tunnemme Jumalan lain, sitä selvemmin tajuamme, ettemme ole noudattaneet sitä elämässämme. Jumalan lain tarkoituksena onkin saada meidät tajuamaan, miten puutteellisia ja syntisiä olemme. ");
INSERT INTO fin_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","22","Mutta nyt Jumala on osoittanut meille toisenlaisen pelastuksen tien. Raamatussa on puhuttu siitä jo aikaisemmin. Jumalan yhteyteen ei kukaan voi päästä olemalla riittävän hyvä tai noudattamalla Jumalan lakia. Jumala näet sanoo, että hän hyväksyy meidät ja julistaa meidät syyttömiksi, kun turvaudumme Jeesukseen Kristukseen: siihen, että Jeesus on ottanut syntimme kannettavakseen. Me kaikki pelastumme tällä samalla tavalla – uskomalla Jeesukseen – aivan riippumatta siitä, keitä olemme tai minkälaisia olemme olleet. ");
INSERT INTO fin_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Kaikki ihmisethän ovat tehneet syntiä. Ei kukaan täytä Jumalan asettamia vaatimuksia. ");
INSERT INTO fin_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Mutta me saamme lahjaksi armahduksen: Jumala julistaa meidät syyttömiksi, koska Jeesus Kristus on kuollut puolestamme. Näin armahtavainen Jumala on ihmisiä kohtaan. ");
INSERT INTO fin_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Jumala lähetti Jeesuksen Kristuksen kuolemaan ristillä ja kärsimään rangaistuksen meidän synneistämme. Joka luottaa Jeesukseen, ei siis joudu tuomittavaksi. Jumala menetteli täysin oikeudenmukaisesti, vaikka hän ei ollutkaan rangaissut niitä, jotka menneinä aikoina olivat tehneet syntiä. Hän katsoi eteenpäin siihen aikaan, jolloin Kristus tulisi poistamaan myös kaiken entisen. Samalla tavalla Jumala nytkin armahtaa syntisen, joka uskoo Jeesukseen. ");
INSERT INTO fin_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Mitä sellaista me sitten voimme kehua tehneemme, jonka avulla voisimme ansaita pelastuksen? Emme yhtään mitään. Meitä ei julisteta syyttömiksi hyvien tekojemme perusteella, vaan sen perusteella, mitä Kristus on puolestamme tehnyt. Saamme hänen valmistamansa pelastuksen uskomalla häneen. ");
INSERT INTO fin_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Niin Jumala siis hyväksyy meidät omikseen, kun luotamme Kristukseen, eikä meidän hyvien tekojemme tähden. ");
INSERT INTO fin_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Entä pelastaako Jumala vain juutalaiset tällä tavalla? Ei toki: myös muihin kansoihin kuuluvat saavat samoin tulla hänen luokseen. ");
INSERT INTO fin_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Jumala suhtautuu kaikkiin ihmisiin samalla tavalla: hän hyväksyy yhteyteensä kaikki – olivatpa he juutalaisia tai mitä kansallisuutta tahansa – kun he uskovat Jeesukseen. ");
INSERT INTO fin_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Jos me siis korostamme uskon merkitystä, eikö meidän enää tarvitse noudattaa Jumalan lakeja? Päinvastoin: vasta kun uskomme Jeesukseen, me todella voimme noudattaa Jumalan tahtoa. ");
INSERT INTO fin_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","2","Aabraham on juutalaisten kantaisä. Miten edellä korostamamme uskon merkitys näkyy hänen suhteestaan Jumalaan? Jos Aabraham sai Jumalan suosion hyvien tekojensa tähden, niin hänellä oli syytä olla ylpeä, mutta ei Jumalan edessä. ");
INSERT INTO fin_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Raamattuhan sanoo, että Aabraham uskoi Jumalaa, ja tämän uskon vuoksi Jumala hyväksyi hänet omakseen. ");
INSERT INTO fin_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","5","Mutta eikö Aabraham kaikilla hyvillä teoillaan ansainnut pääsyä taivaaseen? Ei, sillä pelastusta ei ansaita teoilla, se on lahja. Ja mikä lahja se olisi, jos se voitaisiin ansaita hyvän elämän avulla? Jumalalle riittää syntisen usko – hän hyväksyy omakseen jokaisen, joka turvautuu häneen. ");
INSERT INTO fin_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Kuningas Daavid puhui tästä kuvatessaan onnelliseksi sitä ihmistä, jonka Jumala ilman hänen omaa ansiotaan julistaa syyttömäksi. ");
INSERT INTO fin_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","»Onnellisia ovat ne, joiden synnit on annettu anteeksi ja poistettu», hän sanoi. ");
INSERT INTO fin_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","»Miten riemuitseekaan ihminen, jota Herra ei enää vaadi tilille synneistä.» ");
INSERT INTO fin_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Entä tuleeko tämä onni sitten vain niiden osaksi, jotka uskovat Kristukseen mutta samalla noudattavat myös juutalaisten lakia? Vai saavatko sen myös ne, jotka eivät noudata juutalaisten sääntöjä, vaan ainoastaan turvautuvat Kristukseen? Miten kävi Aabrahamin? Jumala hyväksyi hänet hänen uskonsa tähden. Tapahtuiko se yksin uskosta vai sen vuoksi, että hän myös noudatti juutalaisten sääntöjä? ");
INSERT INTO fin_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Vastaus löytyy toisesta kysymyksestä: milloin Jumala otti Aabrahamin omakseen? Se tapahtui ennen kuin hänestä tuli juutalainen – ennen kuin hänet ympärileikattiin. ");
INSERT INTO fin_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ympärileikkaaminen oli sen merkkinä, että Aabraham jo uskoi ja että Jumala jo oli hyväksynyt hänet. Aabraham on siis niiden hengellinen isä, jotka uskovat niin kuin Aabraham ja pelastuvat noudattamatta juutalaisten säädöksiä. ");
INSERT INTO fin_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Aabraham on myös ympärileikattujen juutalaisten hengellinen isä. Eivät ympärileikkausmenot siis heitäkään pelasta, sillä Aabraham kelpasi Jumalalle yksin uskonsa tähden, ennen kuin hänet oli ympärileikattu. ");
INSERT INTO fin_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Jumala lupasi siis antaa koko maailman Aabrahamille ja hänen jälkeläisilleen. Jumala ei tehnyt sitä sen vuoksi, että Aabraham noudatti hänen lakejaan, vaan siksi, että Aabraham uskoi Jumalan pitävän lupauksensa. ");
INSERT INTO fin_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Jos siis vielä väitätte Jumalan lupauksen koskevan niitä, jotka ovat »tarpeeksi hyviä», niin väitätte samalla, ettei hänen uskoville antamallaan lupauksella ole mitään merkitystä ja että uskominen on mieletöntä. ");
INSERT INTO fin_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Asian ydin on tämä: kun me yritämme päästä Jumalan lapsiksi elämällä hänen lakiensa mukaan, emme pysty noudattamaan niitä ja ansaitsemme siis Jumalan vihan. Ihminen voi elää rikkomatta lakeja vain silloin, kun niitä ei ole! ");
INSERT INTO fin_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Jumalan lupaama pelastuminen siis otetaan vastaan uskolla – ilmaisena lahjana. Me saamme sen riippumatta siitä, noudatammeko juutalaisten tapoja, jos uskomme niin kuin Aabraham, sillä uskoon kuuluvissa asioissa Aabraham on jokaisen ihmisen isä. ");
INSERT INTO fin_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Juuri sitä Raamattu tarkoittaa sanoessaan, että Jumala teki Aabrahamista monien kansojen isän. Jumala ottaa jokaisesta kansasta omakseen kaikki ne ihmiset, jotka luottavat häneen niin kuin Aabraham. Tämän lupauksen on itse Jumala antanut – hän, joka herättää kuolleet ja joka tietää tulevat tapahtumat yhtä hyvin kuin menneet. ");
INSERT INTO fin_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Kun siis Jumala lupasi antaa Aabrahamille pojan, jonka jälkeläisistä kerran tulee suuri kansa, Aabraham uskoi Jumalaa, vaikkei sellaisen lupauksen toteutuminen ollut mahdollisuuksien rajoissakaan! ");
INSERT INTO fin_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Koska hänen uskonsa oli vahva, hän ei murehtinut sitä, että oli liian vanha tulemaan isäksi – olihan hän satavuotias – ja että hänen vaimonsa Saara, joka oli yhdeksänkymmentävuotias, oli myös aivan liian vanha saamaan lapsia. ");
INSERT INTO fin_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Mutta Aabraham ei epäillyt, vaan uskoi Jumalaa. Hänen uskonsa ja luottamuksensa kasvoivat jatkuvasti, ja hän ylisti Jumalaa ihmeestä, ennen kuin se oli edes tapahtunutkaan. ");
INSERT INTO fin_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Hän oli aivan varma siitä, että Jumala kykeni tekemään kaiken, mitä oli luvannutkin. ");
INSERT INTO fin_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Aabrahamin uskon tähden Jumala hyväksyi hänet omakseen. ");
INSERT INTO fin_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Tästä asiasta ei ole kirjoitettu vain Aabrahamin vuoksi. ");
INSERT INTO fin_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Samalla tavoin kuin Jumala hyväksyi Aabrahamin, hän hyväksyy myös meidät, kun me uskomme häneen, joka herätti kuolleista Herramme Kristuksen. ");
INSERT INTO fin_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jeesus kuoli, että me saisimme syntimme anteeksi, ja hänen ylösnousemuksensa takaa sen, että Jumala on ottanut meidät lapsikseen Kristuksen teon tähden. ");
INSERT INTO fin_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Olemme nyt siis uskosta tulleet Jumalan lapsiksi. Jumalan ja meidän välillämme vallitsee rauha, joka perustuu siihen, mitä Herramme Jeesus Kristus on tehnyt puolestamme. ");
INSERT INTO fin_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kristuksen tekoon luottamalla olemme päässeet tähän erikoisasemaan, ja turvallisesti ja iloisesti me odotamme sitä aikaa, jolloin pääsemme Jumalan kirkkauteen. ");
INSERT INTO fin_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Voimme iloita, vaikka elämäämme tulee vaikeuksia, sillä tiedämme, että ne ovat meille hyväksi: ne opettavat meille kärsivällisyyttä. ");
INSERT INTO fin_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Se taas auttaa meitä kestämään koettelemuksia ja luottamaan Jumalaan yhä enemmän. Niin meidän toivomme ja uskomme vahvistuvat. ");
INSERT INTO fin_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Mitä tahansa tapahtuukin – tiedämme, että kaikki on hyvin, koska Jumala rakastaa meitä. Jumala on antanut meille Pyhän Hengen, joka täyttää sydämemme hänen rakkaudellaan. ");
INSERT INTO fin_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Kun olimme täysin avuttomia ja kokonaan vailla omia mahdollisuuksia, Kristus kuoli oikeaan aikaan meidän syntisten puolesta, vaikka emme vähääkään piitanneet hänestä. ");
INSERT INTO fin_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ja jos olisimme hyviäkin, emme voisi odottaa kenenkään kuolevan puolestamme, vaikka se tietysti olisi mahdollista. ");
INSERT INTO fin_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mutta Jumala paljasti meille suuren rakkautensa lähettämällä Kristuksen kuolemaan puolestamme, kun me vielä olimme syntisiä. ");
INSERT INTO fin_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Kristuksen veren tähden Jumala on julistanut meidät syyttömiksi. Kristus pelastaa meidät myös tulevasta Jumalan vihasta. ");
INSERT INTO fin_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Me olimme Jumalan vihollisia, mutta nyt olemme päässeet sovintoon Jumalan kanssa hänen Poikansa kuoleman tähden. Minkä siunauksen häneltä saammekaan nyt, kun olemme hänen ystäviään ja hän elää meidän kanssamme! ");
INSERT INTO fin_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Tästä me olemme riemuissamme: Jeesus Kristus on kuollut meidän syntiemme tähden ja näin tehnyt meistä Jumalan lapsia. ");
INSERT INTO fin_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Aadamin teon tähden tuli synti maailmaan ja synnin mukana kuolema. Kaikista ihmisistä tuli kuolevaisia, koska kaikki tekevät syntiä. ");
INSERT INTO fin_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Ihmiset tekivät syntiä Aadamin ajasta Mooseksen aikaan, mutta Jumala ei kuitenkaan tuominnut heitä kuolemaan lain rikkomisesta – eihän hän vielä ollut antanut ihmisille lakiaan eikä ilmoittanut, mitä hän halusi heidän tekevän. ");
INSERT INTO fin_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kuitenkin kaikki ihmiset, jotka olivat eläneet Aadamin ja Mooseksen välisenä aikana, kuolivat, vaikka he eivät olleetkaan rikkoneet Jumalan suoranaista käskyä tai kieltoa, kuten Aadam oli tehnyt. Mikä valtava ero olikaan Aadamilla ja Kristuksella, jota Aadam eräänlaisena ennakkokuvana vastaa! ");
INSERT INTO fin_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Ja mikä ero onkaan ihmisen synnin ja Jumalan anteeksiantamuksen välillä! Aadamin lankeemus toi kaikille kuoleman, mutta Jeesus Kristus anteeksiantamuksen – Jumalan hyvyyden ja armahtavaisuuden tähden. ");
INSERT INTO fin_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Aadamin synti toi kuolemanrangaistuksen kaikille – Kristus taas pyyhkii pois rikkomukset ja antaa ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Aadamin synti sai aikaan sen, että kuolemasta tuli kaikkia hallitseva kuningas. Mutta niiden elämää, jotka ottavat vastaan Jumalan lahjan – anteeksiantamuksen, armahduksen – hallitsee Jeesus Kristus, joka on voittanut kuoleman. ");
INSERT INTO fin_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Niin kuin Aadamin synti toi kuolemanrangaistuksen kaikille ihmisille, niin Jeesuksen hyvä teko saa aikaan sen, että Jumala omasta puolestaan on valmis hyväksymään kaikki ihmiset yhteyteensä ja antamaan heille elämän. ");
INSERT INTO fin_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Aadamin tottelemattomuuden tähden kaikista ihmisistä tuli syntisiä, mutta Kristuksen kuuliaisuuden tähden he saavat anteeksi ja kelpaavat Jumalalle. ");
INSERT INTO fin_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Käskyt annettiin siksi, että kaikki ymmärtäisivät, kuinka perusteellisesti he olivat epäonnistuneet Jumalan tahdon noudattamisessa. Mutta mitä selvemmin me näemme syntisyytemme, sitä paremmin myös tajuamme Jumalan armon runsauden saadessamme anteeksi. ");
INSERT INTO fin_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Aikaisemmin synti hallitsi kaikkia ihmisiä ja vei heidät kuolemaan. Nyt hallitsee armahtava Jumala: hän ottaa meidät lapsikseen ja antaa meille ikuisen elämän Jeesuksen Kristuksen, Herramme, tähden. ");
INSERT INTO fin_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Onko meidän sitten jatkuvasti tehtävä syntiä, että Jumala osoittaisi meille yhä enemmän hyvyyttään ja anteeksiantamustaan? ");
INSERT INTO fin_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","3","Ei tietenkään! Miksi tekisimme tahallamme jatkuvasti syntiä, kun kerran olemme päässeet osallisiksi uudesta elämästä? Muistattehan toki, että synnin valta meihin murtui, kun meidät liitettiin kasteessa Jeesukseen Kristukseen: hänen kuolemassaan meidän turmeltunut minämme menetti ylivaltansa. ");
INSERT INTO fin_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Kasteessa meidän vanha syntiä rakastava minämme haudattiin Kristuksen kanssa. Ja koska Isä Jumala herätti ihmeellisellä voimallaan Kristuksen kuolleista, mekin saamme elää uutta elämää hänessä ja hänen kanssaan. ");
INSERT INTO fin_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Me ja Kristus olemme yhtä: me kuolimme hänen kanssaan. Nyt olemme osallisia hänen uudesta elämästään ja kerran nousemme kuolleista niin kuin hän. ");
INSERT INTO fin_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Meidän vanha minämme ristiinnaulittiin Kristuksen kanssa, jotta emme enää olisi synnin hallittavina emmekä synnin orjia. ");
INSERT INTO fin_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Koska olemme kuolleet synnille, sillä ei ole ylivaltaa elämässämme. ");
INSERT INTO fin_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Vanha, syntiä rakastava minämme on kuollut Kristuksen kanssa, ja niin uskomme saavamme myös elää ikuisesti hänen kanssaan. ");
INSERT INTO fin_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Jeesus nousi kuolleista, eikä hän enää koskaan kuole. Kuolemalla ei ole enää valtaa häneen. ");
INSERT INTO fin_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Hän kuoli kaikkien puolesta murtaakseen synnin vallan, ja nyt hän elää ikuisesti Jumalalle. ");
INSERT INTO fin_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Pitäkää siis tekin itsenne synnille kuolleina ja eläkää Jumalalle Jeesuksen Kristuksen, meidän Herramme, tähden. ");
INSERT INTO fin_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Synti ei saa enää hallita kuolevaista ruumistanne. Älkää antautuko pahojen halujen valtaan. ");
INSERT INTO fin_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Älkää antako mitään osaa ruumiistanne pahan työvälineeksi synnintekoon, vaan antakaa itsenne kokonaan Jumalalle. Kun te nyt olette vapautuneet kuolemasta, niin antakaa itsenne kokonaan Jumalan käyttöön, toteuttamaan hänen hyviä tarkoituksiaan. ");
INSERT INTO fin_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Synti ei enää koskaan ole teidän hallitsijanne. Tehän ette elä enää lain orjuudessa, vaan vapaina Jumalan suosiossa ja armossa. ");
INSERT INTO fin_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Tarkoittaako tämä sitä, että voimme huoletta tehdä syntiä? Pelastuksemmehan ei riipu lain noudattamisesta, vaan Jumalan armon vastaanottamisesta. Emme tietenkään! ");
INSERT INTO fin_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ettekö ymmärrä, että voitte nyt itse valita isäntänne: joko synnin, mistä seuraa kuolema, tai Jumalan tottelemisen, mistä seuraa Jumalan tuomiosta vapautuminen. Jos annatte itsenne jollekulle, hänestä tulee teidän valtiaanne ja teistä hänen orjiaan. ");
INSERT INTO fin_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Jumalalle kiitos siitä, että vaikka aikaisemmin valitsitte synnin orjuuden, noudatatte nyt koko sydämestänne Jumalan tahtoa. ");
INSERT INTO fin_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Nyt olette vapaat vanhasta hallitsijastanne, synnistä, ja teistä on tullut uuden isäntänne, Jumalan, palvelijoita. ");
INSERT INTO fin_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Puhun käyttäen vertausta orjista ja heidän valtiaistaan, koska se on teidän helppo ymmärtää. Aivan niin kuin olitte ennen kaikenlaisen synnin orjia, samalla tavoin teidän on nyt annettava itsenne kaiken oikean ja pyhän palvelukseen. ");
INSERT INTO fin_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ollessanne synnin orjia ette piitanneet Jumalasta. ");
INSERT INTO fin_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ja mitä siitä oli seurauksena? Ilmeisestikään ei mitään hyvää, koska nyt teitä hävettää muistellakin sitä, mitä silloin teitte: sellainen elämä päättyy ikuiseen kuolemaan. ");
INSERT INTO fin_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Mutta nyt olette vapaat synnin vallasta, olette Jumalan palvelijoita. Te elätte Jumalan tahdon mukaan ja saatte ikuisen elämän. ");
INSERT INTO fin_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Synnin palkkahan on kuolema, mutta Jumala antaa lahjaksi ikuisen elämän Herramme Jeesuksen Kristuksen tähden. ");
INSERT INTO fin_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Ettekö vielä ymmärrä, että kun ihminen on kuollut, laki ei enää sido häntä? ");
INSERT INTO fin_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kun esimerkiksi nainen menee naimisiin, laki sitoo hänet aviomieheen niin kauan kuin tämä elää. Mutta kun mies kuolee, vaimo ei enää ole häneen sidoksissa. Avioliittolaki ei enää koske häntä. ");
INSERT INTO fin_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Hän voi mennä naimisiin jonkun toisen kanssa, jos tahtoo. Se olisi ollut väärin silloin, kun hänen miehensä vielä eli, mutta nyt se on täysin luvallista, koska aviomies on kuollut. ");
INSERT INTO fin_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Teidän »aviomiehenne», teidän käskijänne, oli aikaisemmin juutalaisten laki. Mutta sitten te kuolitte Kristuksen kanssa ristillä. Nyt ette enää ole »avioliitossa» lain kanssa, eikä sillä ole enää käskyvaltaa teidän elämässänne. Te heräsitte kuolleista Kristuksen kanssa ja olette nyt uusia ihmisiä, Kristuksen omia, niin että voitte tuottaa Jumalalle hyviä hedelmiä eli tehdä hyviä tekoja. ");
INSERT INTO fin_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kun vanha minämme vielä hallitsi meitä, pahat halumme saivat meidät tekemään kaikkea sitä, minkä Jumala oli kieltänyt, ja tuottivat kuoleman hedelmiä eli pahoja tekoja. ");
INSERT INTO fin_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Mutta nyt eivät juutalaisten lait ja tavat enää sido meitä, koska me kuolimme ollessamme niiden alaisuudessa ja vapauduimme niistä. Vasta nyt voimme palvella Jumalaa oikein – ei vanhalla tavalla orjallisesti noudattamalla tiettyjä sääntöjä, vaan Pyhän Hengen johtamina. ");
INSERT INTO fin_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Väitänkö siis, että Jumalan lait ovat pahasta? En tietenkään! Ei laki ole syntiä, vaan juuri laki näytti minulle syntini. En olisi koskaan oppinut tuntemaan sydämessäni olevaa syntiä – sinne kätkeytyneitä pahoja haluja – ellei laki olisi sanonut: »Älä himoitse!» ");
INSERT INTO fin_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Synti käytti hyväkseen kieltoa herättämällä mielessäni kaikenlaisia vääriä haluja. Vain siinä tapauksessa, ettei olisi lakeja mitä rikkoa, ei myöskään olisi syntiä. ");
INSERT INTO fin_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Kaikki oli minun mielestäni kunnossa niin kauan kuin en ymmärtänyt, mitä laki todella vaati. Mutta kun tajusin, että olin rikkonut Jumalan lakia vastaan, ymmärsin olevani syntinen ja kuolemaan tuomittu. ");
INSERT INTO fin_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Sinänsä hyvä laki, jonka piti osoittaa minulle elämän tietä, tuottikin päinvastoin minulle kuolemantuomion. ");
INSERT INTO fin_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Synti petti minut Jumalan hyvien lakien varjolla ja teki minusta niiden avulla kuolemaan tuomitun. ");
INSERT INTO fin_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Mutta niin kuin näette, laki itsessään on täysin oikea ja hyvä. ");
INSERT INTO fin_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Kuinka se voi olla mahdollista? Eikö juuri laki tuottanut minulle kuolemantuomion – miten se siis voi olla hyvä? Ei tällä tavoin voi ajatella, vaan synti, joka on peräisin saatanasta, käytti minut tuomitakseen sellaista, mikä itsessään on hyvää. Näette siis, kuinka ovela, hengenvaarallinen ja inhottava synti on käyttäessään Jumalan hyviä lakeja omiin pahoihin tarkoituksiinsa. ");
INSERT INTO fin_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Laki on siis hyvä, eikä vika ole siinä. Vika on minussa, sillä olen kovin altis suostumaan synnin palvelijaksi. ");
INSERT INTO fin_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","En ollenkaan ymmärrä itseäni, sillä todella haluan tehdä oikein, mutta en voi. Päinvastoin teen sitä, mitä en halua – sellaista, mitä vihaan. ");
INSERT INTO fin_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Tiedän aivan hyvin tekeväni väärin. Omatuntoni syyttää minua. Myönnän lain käskyt oikeiksi, vaikka jatkuvasti niitä rikon. ");
INSERT INTO fin_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","En voi itselleni mitään: sisimmässäni oleva synti on minua voimakkaampi, ja se saa minut tekemään pahaa. ");
INSERT INTO fin_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Tiedän olevani pohjiani myöten turmeltunut, eikä minussa itsessäni – itsekkäässä vanhassa minässäni – ole mitään hyvää. Vaikka kuinka yritän, en pysty elämään oikein. Tahdon, mutta en voi. ");
INSERT INTO fin_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Kun haluan tehdä hyvää, siitä ei tule mitään, ja kun yritän olla pahaa tekemättä, sorrun siihen kuitenkin. ");
INSERT INTO fin_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Jos siis teen sellaista, mitä en halua, niin vika on siinä, että synti pitää minua vielä talutusnuorassaan. ");
INSERT INTO fin_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Näyttää siis siltä, etten pääse tästä mihinkään: aina kun tahdon tehdä oikein, teen kuitenkin sellaista, mikä on väärin. ");
INSERT INTO fin_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Uusi minäni eläisi mielellään Jumalan tahdon mukaan, ");
INSERT INTO fin_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","24-25","mutta syvällä sisimmässäni jokin sotii hyvää aikomustani vastaan ja voittaa sen. Näin minussa asuva synti pitää minua kahleissaan. Haluaisin olla nöyrä Jumalan palvelija, mutta huomaankin yhä olevani synnin orja. Tilanne on kestämätön: uusi minäni kehottaa minua elämään oikein, mutta vanha minä, joka elää sisimmässäni, rakastaa syntiä. Olen epätoivoinen – kuka vapauttaa minut tästä kuoleman kierteestä? Jumalan kiitos – Herramme Jeesus on jo tehnyt sen! ");
INSERT INTO fin_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nyt ei siis tuomita kadotukseen niitä, jotka ovat Jeesuksen Kristuksen omia. ");
INSERT INTO fin_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Eläväksi tekevä Pyhä Henki on vapauttanut minut, joka olen Jeesuksen oma, synnin ja kuoleman noidankehästä. ");
INSERT INTO fin_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Kun ihminen ei pystynyt täyttämään käskyjä niin että olisi kelvannut Jumalalle, Jumala lähetti oman Poikansa ihmisenä kärsimään meidän tuomiomme ja uhraamaan oman henkensä meidän syntiemme tähden. ");
INSERT INTO fin_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Jumalan tahto voi toteutua meidän elämässämme, jos Jumalan Henki johtaa meitä emmekä enää tottele pahaa vanhaa minäämme. ");
INSERT INTO fin_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ne, jotka antavat pahan hallita itseään, elävät omien mielitekojensa mukaan, mutta ne, joita Pyhä Henki hallitsee, elävät Jumalan tahdon mukaan. ");
INSERT INTO fin_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Pyhä Henki johtaa meitä elämään ja rauhaan, mutta vanhan minän halujen toteuttaminen johtaa kuolemaan, ");
INSERT INTO fin_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","sillä meidän vanha, turmeltunut minämme vastustaa Jumalaa. Se ei ole vielä milloinkaan noudattanut Jumalan lakeja eikä tule noudattamaankaan. ");
INSERT INTO fin_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Niitä, jotka vielä elävät turmeltuneen minänsä hallinnassa ja seuraavat sen pahoja mielihaluja, Jumala ei hyväksy. ");
INSERT INTO fin_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Mutta te ette kuulu heidän joukkoonsa. Jos Jumalan Henki on teissä, niin hän hallitsee teitä. Ja muistakaa, että jos Kristuksen Henki ei asu ihmisessä, tämä ei ole Kristuksen oma! ");
INSERT INTO fin_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Teidän ruumiinne kuolee kyllä kerran synnin tähden, mutta jos Kristus elää teissä, teidän henkenne elää, koska Kristus on saattanut teidät sovintoon Jumalan kanssa. ");
INSERT INTO fin_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Jumala herätti Jeesuksen kuolleista, ja hän herättää Hengellään teidän ruumiinne jälleen eloon – samalla Hengellä, joka nyt asuu teissä. ");
INSERT INTO fin_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Ystävät, meidän ei siis tarvitse tehdä sitä, mitä vanha, turmeltunut minämme vaatii meitä tekemään. ");
INSERT INTO fin_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Jos te elätte vanhan minänne neuvojen mukaan, te eksytte ja tuhoudutte. Mutta jos Pyhän Hengen voimalla murskaatte sen kaikkine pahoine tekoineen, saatte elää. ");
INSERT INTO fin_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Kaikki, joita Jumalan Henki johdattaa, ovat Jumalan lapsia. ");
INSERT INTO fin_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ette siis saa käyttäytyä kuin peloissaan matelevat orjat, vaan niin kuin Jumalan lapset, jotka on otettu hänen perheensä jäseniksi ja jotka sanovat häntä Isäksi. ");
INSERT INTO fin_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Hänen Pyhä Henkensä todistaa meidän sydämessämme, että olemme Jumalan lapsia. ");
INSERT INTO fin_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Koska olemme hänen lapsiaan, meillä on osuus hänen omaisuuteensa, sillä me saamme perinnöksemme kaiken sen, minkä Kristuskin perii. Mutta jos pääsemme kerran osallisiksi hänen kunniastaan, meidän on myös kärsittävä hänen kanssaan. ");
INSERT INTO fin_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Eihän se, mitä me nyt kärsimme, ole mitään verrattuna siihen kirkkauteen, johon kerran Jumalan luona pääsemme. ");
INSERT INTO fin_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Koko luomakunta odottaa toiveikkaasti sitä päivää, jolloin Jumala herättää lapsensa kuolleista. ");
INSERT INTO fin_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","21","Sinä päivänä ei ole enää kärsimystä eikä kuolemaa, jotka Jumalan käskystä nyt hallitsevat maailmaa vastoin sen tahtoa. Koko luomakunta pääsee ihanaan vapauteen synnistä ja kuolemasta yhdessä Jumalan lasten kanssa. ");
INSERT INTO fin_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Mehän tiedämme, että tätä suurta tapahtumaa odottaa koko luomakunta – eläimiä ja kasveja myöten – sillä sen osana on sairaus ja kuolema. ");
INSERT INTO fin_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Myös me kristityt kaipaamme lopullista vapautusta tuskista ja kärsimyksistä, vaikka meissä asuva Pyhä Henki antaa meidän jo nyt aavistaa tulevaa kirkkautta. Mekin odotamme innokkaasti sitä päivää, jona Jumala antaa meille uuden, täydellisen ruumiin. ");
INSERT INTO fin_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Olemme toivossa pelastettuja. Eihän ihmisen tarvitse toivoa ja odottaa saavansa sitä, mikä hänellä jo on. ");
INSERT INTO fin_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Me toivomme sellaista, mitä emme näe, ja odotamme sitä kärsivällisesti. ");
INSERT INTO fin_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Samalla tavalla Pyhä Henki auttaa meitä joka päivä tuntiessamme uskomme heikkouden. Mehän emme edes tiedä, minkä puolesta ja miten meidän tulee rukoilla. Mutta Pyhä Henki rukoilee meidän puolestamme huokauksin, joita ei voi pukea sanoiksi. ");
INSERT INTO fin_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Isä, joka tuntee kaikkien sydämet, kyllä tietää, mitä Henki meidän puolestamme rukoilee, sillä Pyhän Hengen rukoukset ovat sopusoinnussa Jumalan oman tahdon kanssa. ");
INSERT INTO fin_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tiedämme, että kaikki, mitä tapahtuu, vaikuttaa niiden parhaaksi, jotka rakastavat Jumalaa ja jotka on hänen suunnitelmansa mukaan kutsuttu hänen omikseen. ");
INSERT INTO fin_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Jumala on jo edeltäpäin tuntenut omansa ja päättänyt, että heistä tulisi samanlaisia kuin hänen Poikansa. Kristus on silloin esikoinen, ja hänellä on paljon sisaria ja veljiä. ");
INSERT INTO fin_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Valittuaan meidät hän myös kutsui meidät luokseen, ja kun me tulimme, hän julisti meidät syyttömiksi, hyväksyi lapsikseen ja lahjoitti meille oman kirkkautensa. ");
INSERT INTO fin_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Mitä me voimme tähän sanoa? Jos Jumala on meidän puolellamme, kuka voi olla meitä vastaan? ");
INSERT INTO fin_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Hän ei säästänyt omaa Poikaansakaan, vaan luopui hänestä kaikkien meidän tähtemme – eikö hän siis lahjoittaisi meille kaikkea muutakin? ");
INSERT INTO fin_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Kuka uskaltaa syyttää meitä, jotka Jumala on valinnut omikseen? Jumala on itse antanut meille syntimme anteeksi ja julistanut meidät syyttömiksi Jeesuksen teon tähden. ");
INSERT INTO fin_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Kuka sitten voi tuomita meidät kadotukseen? Ei kukaan! Kristus kuoli ja nousi kuolleista meidän tähtemme. Taivaassa Jumalan oikealla puolella hän rukoilee meidän puolestamme. ");
INSERT INTO fin_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kuka pystyy erottamaan meidät Kristuksen rakkaudesta? Kun olemme vaikeuksissa ja ahdingossa, kun meitä vainotaan tai vahingoitetaan – johtuuko se siitä, ettei hän enää rakasta meitä? Jos joudumme kärsimään nälkää, elämään kurjuudessa, vaaran tai kuoleman uhan alaisina – onko Jumala silloin hylännyt meidät? ");
INSERT INTO fin_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Ei, sillä Raamattu sanoo, että hänen tähtensä meidän on oltava valmiit kuolemaan minä hetkenä tahansa – olemme kuin lampaat, jotka on tuotu teurastettaviksi. ");
INSERT INTO fin_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Kaikesta tästä huolimatta saamme loistavan voiton Jeesuksen tähden, sillä hän rakasti meitä niin paljon, että kuoli puolestamme. ");
INSERT INTO fin_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Olen varma siitä, ettei mikään voi erottaa meitä Jumalan rakkaudesta. Siihen ei pysty kuolema eikä elämä, eivät enkelit – eivät edes helvetin vallatkaan voi tehdä mitättömäksi Jumalan rakkautta meitä kohtaan. Ei meidän nykyinen ahdistuksemme, ei epävarma tulevaisuus, ");
INSERT INTO fin_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","eivät henkivoimat – ei mikään tässä maailmassa eikä koko maailmankaikkeudessa voi erottaa meitä Jumalan rakkaudesta, jota hän on osoittanut antamalla meille Herramme Jeesuksen Kristuksen. ");
INSERT INTO fin_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","2-3-4","Voi Israelia, minun kansaani! Voi miten tahtoisinkaan juutalaisten veljieni tulevan Kristuksen luo! Sydämeni on raskas, ja minä murehdin katkerasti yötä päivää heidän tähtensä. Kristus tietää ja Pyhä Henki tietää, etten teeskentele, kun sanon olevani valmis menemään kadotukseen, jos se heidät pelastaa. Jumala on antanut heille hyvin paljon, mutta he eivät halua kuunnella häntä. Hän valitsi heidät omaksi kansakseen ja johti monissa vaiheissa heidän kulkuaan. Hän myös ilmoitti heille, miten suuresti hän halusi siunata heitä. Hän antoi heille ohjeet jokapäiväistä elämää varten, niin että he tietäisivät hänen tahtonsa. Hän opetti heille oikeaa jumalanpalvelusta, ja valtavat lupaukset tulivat heidän osakseen. ");
INSERT INTO fin_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Suuret Jumalan miehet olivat heidän isiään, ja Kristus itse oli ihmisenä syntyisin heistä – hän, joka on nyt kaiken hallitsija ja jota me Jumalana ylistämme ikuisesti. ");
INSERT INTO fin_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Eivätkö Jumalan juutalaisille antamat lupaukset sitten ole toteutuneet? Kyllä ovat! Kuuluvathan hänen lupauksensa niille, jotka uskoen ne omistavat. Ja vain sellaiset ihmiset ovatkin todella hänen kansaansa. He ovat oikeita juutalaisia. ");
INSERT INTO fin_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ei pelkästään se, että juutalaiset polveutuvat Aabrahamista, tee heistä oikeita Aabrahamin jälkeläisiä. Raamattu sanoo, että lupaukset koskevat vain Aabrahamin poikaa Iisakia ja Iisakin jälkeläisiä, vaikka Aabrahamilla oli muitakin lapsia. ");
INSERT INTO fin_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Kaikki Aabrahamin lapset eivät siis ole Jumalan lapsia, vaan ainoastaan ne, jotka uskovat siihen lupaukseen pelastuksesta, jonka Jumala antoi Aabrahamille. ");
INSERT INTO fin_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Jumala lupasi: »Ensi vuonna minä annan sinulle ja Saaralle pojan.» ");
INSERT INTO fin_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","11-12-13","Vuosia myöhemmin, kun tämä poika, Iisak, oli varttunut aikuiseksi ja mennyt naimisiin ja hänen vaimonsa Rebekka odotti kaksosia, Jumala ilmoitti tälle, että Eesausta, joka syntyisi ensin, tulisi kaksoisveljensä Jaakobin palvelija. Raamatun kertoman mukaan Jumala sanoi: »Jaakobia minä rakastin, mutta Eesauta vihasin.» Tämän Jumala sanoi, ennen kuin lapset olivat syntyneetkään, ennen kuin he olivat tehneet mitään – hyvää tai pahaa. Jumala siis menetteli, niin kuin oli alusta asti päättänyt menetellä: ei sen mukaan, mitä lapset tekivät, vaan sen mukaan, mikä oli Jumalan suunnitelma. ");
INSERT INTO fin_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Oliko Jumala näin tehdessään epäoikeudenmukainen? Ei tietenkään! ");
INSERT INTO fin_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Olihan Jumala sanonut Moosekselle: »Jos haluan osoittaa hyvyyttäni jollekulle, myös teen sen. Ja minä armahdan kenet haluan.» ");
INSERT INTO fin_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ei tämä riipu ihmisen tahdosta eikä toiminnasta, vaan Jumalan armosta. ");
INSERT INTO fin_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Faarao, Egyptin kuningas, oli tästä hyvänä esimerkkinä. Jumala sanoi antaneensa hänelle Egyptin juuri sitä varten, että Jumalan pelottava voima tulisi näkyviin hänen valtansa rinnalla. Näin Jumalan nimi tulisi kunniaan koko maailmassa. ");
INSERT INTO fin_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Jumala osoittaa hyvyyttään joillekin ihmisille vain siksi, että hän haluaa sen tehdä, ja jotkut taas hän paaduttaa ja tekee tottelemattomiksi. ");
INSERT INTO fin_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Miksi Jumala sitten syyttää heitä siitä, että he eivät kuuntele? Eivätkö he ole tehneet vain sitä, minkä hän on pannut heidät tekemään? ");
INSERT INTO fin_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Älkää sanoko niin! Kuka teistä pystyy arvostelemaan Jumalaa? Sanoisiko työ tekijälleen: »Miksi teit minusta tällaisen?» ");
INSERT INTO fin_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Kun ihminen tekee saviruukkuja, eikö hänellä ole oikeutta muotoilla samasta savimöykystä sekä kauniita koriste-esineitä että vaatimattomia jätekulhoja? ");
INSERT INTO fin_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Eikö Jumalalla ole täyttä oikeutta osoittaa voimaansa ja vihastumistaan niitä kohtaan, jotka eivät kelpaa muuhun kuin hävitettäviksi – niitä, joille hän on jo kauan osoittanut kärsivällisyyttään? ");
INSERT INTO fin_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","24","Hänellä on myös oikeus ottaa omikseen toiset – niin kuin meidät, olimmepa sitten juutalaisia tai emme – käyttää meitä palveluksessaan ja osoittaa meille hyvyyttään, jotta kaikki ihmiset alkaisivat tajuta hänen pelastavan läsnäolonsa. ");
INSERT INTO fin_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Muistatteko, mitä Hoosean kirjassa sanotaan? Siinä Jumala ilmoittaa, että hän etsii itselleen lapsia muista kansoista, jotka eivät kuulu hänen juutalaiseen perheeseensä, ja hän rakastaa heitä, vaikka kukaan ei ole aikaisemmin heitä rakastanut. ");
INSERT INTO fin_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Pakanoita, joista sanottiin kerran: »Te ette ole minun kansaani», tullaan kutsumaan »elävän Jumalan lapsiksi». ");
INSERT INTO fin_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Profeetta Jesaja huudahti juutalaisista puhuessaan, että vaikka heitä olisi miten paljon tahansa, vain pieni osa heistä pelastuu kerran. ");
INSERT INTO fin_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","»Sillä Herra panee tuomionsa täytäntöön maan päällä. Äkkiä ja peruuttamattomasti hän tuomitsee.» ");
INSERT INTO fin_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Toisessa paikassa Jesaja sanoo, että jollei Jumala armahtaisi juutalaisia, he kaikki tuhoutuisivat – jokainen heistä, aivan niin kuin jokainen Sodoman ja Gomorran kaupunkien asukas tuhoutui. ");
INSERT INTO fin_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Mitä siis sanomme tästä kaikesta? Vaikka pakanat eivät edes yrittäneet kelvata Jumalalle, hän hyväksyy heidät, koska he uskovat Kristuksen kuolleen heidän puolestaan. ");
INSERT INTO fin_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Mutta juutalaiset, jotka ovat yrittäneet kaikin voimin päästä oikeaan Jumala-suhteeseen lakia noudattamalla, eivät ole siihen päässeet. ");
INSERT INTO fin_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Miksi eivät? Siksi, että he yrittivät pelastua täyttämällä lain ja olemalla hyviä ihmisiä sen sijaan, että olisivat uskon varassa olleet riippuvaisia Jumalasta. He kompastuivat siihen kiveen, ");
INSERT INTO fin_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","josta Jumala varoitti heitä sanoessaan Raamatussa: »Minä olen pannut juutalaisten polulle kiven (Jeesuksen), johon monet kompastuvat. Mutta ne, jotka uskovat häneen, eivät pety.» ");
INSERT INTO fin_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Rakkaat veljet, hartain toiveeni ja rukoukseni on, että oma kansani, juutalaiset, pelastuisivat. ");
INSERT INTO fin_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Tiedän, kuinka kiihkeästi juutalaiset ajavat Jumalan asiaa, mutta heidän intonsa johtaa heidät harhaan. ");
INSERT INTO fin_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","He eivät ymmärrä, että Jumala hyväksyy heidät Kristuksen tähden, joka kuoli heidän puolestaan. Sen sijaan he yrittävät olla tarpeeksi hyviä kelvatakseen Jumalalle omien tekojensa perusteella. Mutta tämä ei ole Jumalan valmistama tie pelastukseen. ");
INSERT INTO fin_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Kaiken sen, mitä ihmiset yrittävät saada Jumalan lakia noudattamalla, Kristus antaa heille, kun he turvautuvat häneen. ");
INSERT INTO fin_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mooses kirjoitti, että jos joku kykenee täydellisesti noudattamaan Vanhan testamentin lakia, hän on ansainnut pelastuksen. ");
INSERT INTO fin_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Uskosta tuleva pelastus sen sijaan merkitsee tätä: »Teidän ei tarvitse nousta taivaisiin löytääksenne Kristuksen ja tuodaksenne hänet alas auttamaan itseänne. ");
INSERT INTO fin_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Teidän ei tarvitse mennä kuolleiden luo palauttaaksenne Kristuksen elämään.» ");
INSERT INTO fin_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Pelastus, joka tulee uskosta Kristukseen – ja sitähän me julistamme – on jo meidän jokaisen saatavissa. Itse asiassa se on yhtä lähellä meitä kuin oma sydämemme ja suumme. ");
INSERT INTO fin_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Sillä jos sinä suullasi tunnustat, että Jeesus Kristus on Herra, ja uskot omassa sydämessäsi, että Jumala on herättänyt hänet kuolleista, niin pelastut. ");
INSERT INTO fin_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Sydämen uskolla ihminen tulee Jumalan lapseksi ja suullaan hän tunnustaa sen ihmisten edessä, ja näin hänen uskonsa lujittuu. ");
INSERT INTO fin_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Raamattu sanoo, ettei kukaan, joka uskoo Kristukseen, pety. ");
INSERT INTO fin_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Juutalaiset ja muihin kansoihin kuuluvat ihmiset ovat tässä suhteessa samassa asemassa. Jokaisella heistä on sama Herra, joka antaa runsaasti lahjojaan kaikille, jotka niitä häneltä pyytävät. ");
INSERT INTO fin_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Jokainen, joka huutaa avuksi Herran nimeä, pelastuu. ");
INSERT INTO fin_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Mutta kuinka he voivat pyytää häneltä mitään, elleivät usko häneen? Ja kuinka he voivat uskoa häneen, elleivät ole koskaan kuulleet hänestä? Entä kuinka he voivat kuulla hänestä, ellei kukaan hänestä kerro? ");
INSERT INTO fin_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Kuinka kukaan voi mennä kertomaan heille, ellei ketään lähetetä? Juuri tästä Raamattu puhuu sanoessaan: »Kuinka tervetulleita ovatkaan ne, jotka tuovat Jumalan hyvän sanoman ihmisille!» ");
INSERT INTO fin_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Kaikki eivät ota hyvää sanomaa vastaan. »Herra, ketkä uskoivat minua, kun minä puhuin heille?» kysyi profeetta Jesaja. ");
INSERT INTO fin_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Hyvä sanoma Kristuksesta, sen kuuleminen, synnyttää uskon. ");
INSERT INTO fin_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Entä juutalaiset, ovatko he kuulleet Kristuksesta? Ovat toki, tieto hänestä on kulkeutunut kaikkialle, missä heitä on: hyvä sanoma on viety maan ääriin saakka. ");
INSERT INTO fin_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Mutta tiesivätkö juutalaiset Jumalan suunnitelman? Tiesivät! Jo Mooseksen aikana Jumala sanoi, että hän tekee kansansa kateelliseksi ja yrittää havahduttaa sen antamalla pelastuksensa ymmärtämättömille pakanakansoille. ");
INSERT INTO fin_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Myöhemmin Jesaja myös sanoi rohkeasti, että sellaiset ihmiset, jotka eivät edes etsineet Jumalaa, löysivät hänet. ");
INSERT INTO fin_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Koko ajan Jumala kuitenkin on ojentanut käsiään juutalaisia kohti, mutta nämä ovat olleet uppiniskaisia ja kieltäytyneet tulemasta hänen luokseen. ");
INSERT INTO fin_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Onko Jumala nyt siis hylännyt kansansa ja työntänyt juutalaiset luotaan? Ei suinkaan! Muistatte kai, että minäkin olen juutalainen, Aabrahamin jälkeläinen ja Benjaminin suvun jäsen. ");
INSERT INTO fin_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Ei, Jumala ei ole heittänyt kelvottomana luotaan omaa kansaansa, jonka hän valitsi jo aikojen alussa. Muistatteko, mitä Raamatussa tästä asiasta sanotaan? Profeetta Elia syytti juutalaisia Jumalan edessä. ");
INSERT INTO fin_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Hän puhui Jumalalle siitä, kuinka juutalaiset olivat surmanneet profeettoja ja hajottaneet maahan Jumalan alttareita. Elia väitti, ettei koko maassa ollut hänen lisäkseen enää yhtään ihmistä, joka rakasti Jumalaa, ja nyt hänenkin henkeään uhattiin. ");
INSERT INTO fin_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Muistatteko, mitä Jumala vastasi? Hän sanoi: »Ei, et sinä ole ainoa. Sinun lisäksesi on vielä seitsemäntuhatta ihmistä, jotka rakastavat minua eivätkä ole palvelleet epäjumalia.» ");
INSERT INTO fin_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Tämä pitää paikkansa nytkin. Eivät kaikki juutalaiset ole kääntäneet selkäänsä Jumalalle. Jumala on hyvyydessään valinnut muutamia, jotka ovat jääneet jäljelle. ");
INSERT INTO fin_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Heidän pelastumisensa riippuu siis Jumalan hyvyydestä – ei siitä, kuinka hyviä he ovat. Jos he ansaitsisivat pelastuksen omalla hyvyydellään, silloinhan se ei enää olisi Jumalan lahja. ");
INSERT INTO fin_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Suurin osa juutalaisista ei ole saavuttanut tavoittelemaansa Jumalan suosiota. Jotkut ovat sen saavuttaneet – ne, jotka Jumala on valinnut, – mutta toisten silmät on sokaistu. ");
INSERT INTO fin_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Raamattu viittaa tähän sanoessaan, että Jumala on turruttanut juutalaiset, sulkenut heidän silmänsä ja korvansa. Samoin on siis nytkin, ja niinpä he eivät ymmärrä, mistä me puhumme kertoessamme heille Kristuksesta. ");
INSERT INTO fin_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Myös kuningas Daavid kirjoitti samasta asiasta: »Heidän vaurautensa ja menestymisensä houkuttelevat heidät ajattelemaan, että kaikki on kunnossa heidän ja Jumalan välillä. Kaatukoot ja murskaantukoot he hyvyyksiensä alle. ");
INSERT INTO fin_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Tulkoot heidän silmänsä sokeiksi, niin että he eivät kykene näkemään, ja kulkekoot he aina selkä kumarassa.» ");
INSERT INTO fin_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Onko Jumala nyt siis lopullisesti hylännyt juutalaiset, oman kansansa? Ei suinkaan! Hänen tarkoituksensa oli tehdä pelastuminen mahdolliseksi pakanoille, että juutalaiset tulisivat kateellisiksi ja alkaisivat tavoitella sitä itselleen. ");
INSERT INTO fin_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Jos nyt Jumalan tarjoama pelastus koitui koko maailmalle rikkaudeksi, kun juutalaiset loukkaantuivat siihen ja kieltäytyivät ottamasta sitä vastaan, niin kuinka paljon suuremmasta siunauksesta maailma pääseekään osalliseksi sitten, kun juutalaisetkin tulevat Kristuksen luo! ");
INSERT INTO fin_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Niin kuin tiedätte, Jumala on tehnyt minusta lähettiläänsä erityisesti teitä pakanoita varten. ");
INSERT INTO fin_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Muistutan siitä juutalaisia niin usein kuin voin saadakseni, jos mahdollista, heidät haluamaan itselleen sitä, mitä teillä pakanoilla on, ja voidakseni tällä tavalla pelastaa edes joitakin heistä. ");
INSERT INTO fin_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Kääntyessään pois juutalaisista Jumala kääntyi tarjoamaan pelastusta muulle maailmalle. Kuinka ihmeellistä onkaan kerran, kun juutalaiset tulevat Kristuksen luo – se on aivan kuin kuolleiden heräämistä eloon. ");
INSERT INTO fin_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Koska Aabraham ja profeetat ovat Jumalan kansaa, niin heidän jälkeläisensäkin kuuluvat siihen. Jos puun juuret ovat Jumalan, niin ovat sen oksatkin. ");
INSERT INTO fin_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Jotkut näistä oksista – jotkut juutalaisista – on katkaistu pois. Sinut, joka pakanana olit ikään kuin villin öljypuun oksa, oksastettiin tähän Aabrahamin öljypuuhun. Niin sinäkin saat nyt siunauksen, jonka Jumala on luvannut Aabrahamille ja hänen jälkeläisilleen, ja saat osasi Jumalan oman öljypuun runsaasta ravinnosta. ");
INSERT INTO fin_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Sinun on vain tarkoin varottava ylpeilemästä siitä, että olet päässyt poishakattujen oksien paikalle. Muista: Sinun arvosi on siinä, että olet nyt osa Jumalan puuta. Olet kuitenkin vain oksa, et juuri. ");
INSERT INTO fin_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","»Mutta», saatat sanoa, »nuo oksat leikattiin pois, jotta minulle tulisi tilaa. Minä olen siis varmaan niitä arvokkaampi.» ");
INSERT INTO fin_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Varo! Muista, että nuo oksat, juutalaiset, leikattiin pois siksi, että he eivät uskoneet Jumalaan, ja sinut oksastettiin vain siksi, että sinä uskot. Älä ole ylpeä, vaan ole nöyrä ja kiitollinen, ");
INSERT INTO fin_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","sillä jos Jumala ei säästänyt alkuperäisiä oksia, hän ei säästä sinuakaan. ");
INSERT INTO fin_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Huomaa, kuinka Jumala on samalla sekä lempeä että ankara: hän on ankara niille, jotka ovat tottelemattomia, mutta hän on lempeä sinulle, jos jatkuvasti rakastat häntä ja turvaudut häneen. Mutta jos et halua sitä tehdä, sinutkin leikataan pois. ");
INSERT INTO fin_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Toisaalta taas, jos juutalaiset hylkäävät epäuskonsa ja palaavat Jumalan luo, hän oksastaa heidät takaisin puuhunsa. Hänellä on valta tehdä se. ");
INSERT INTO fin_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Jos Jumala suostui ottamaan sinut, joka olit kaukana hänestä – sinähän olit villin öljypuun oksa – ja oksastamaan sinut luonnonvastaisesti omaan jaloon puuhunsa, niin etkö tajua, että vielä paljon luontevammin hän oksastaa takaisin juutalaiset, jotka kuuluivat siihen alun alkaen? ");
INSERT INTO fin_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Rakkaat veljet, haluan teidän tietävän erään Jumalan totuuden, ettette ala ylpeillä. Totta on, että monet juutalaiset ovat nyt torjuneet hyvän uutisen Kristuksesta, mutta juutalaisten paatumus kestää vain siihen saakka, kun Jumalan säätämä joukko pakanoita on tullut Kristuksen luo. ");
INSERT INTO fin_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Sen jälkeen koko Israel pelastuu. Muistatteko, mitä profeetat sanoivat tästä? »Siionista on tuleva pelastaja, ja hän kääntää juutalaiset pois jumalattomuudesta. ");
INSERT INTO fin_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Silloin minä teen uuden liiton heidän kanssaan ja otan pois heidän syntinsä, aivan niin kuin olen luvannut.» ");
INSERT INTO fin_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Monet juutalaiset vihaavat nyt hyvää sanomaa Jeesuksesta. Mutta se on koitunut teille hyödyksi, sillä näin Jumala on antanut lahjansa teille pakanoille. Kuitenkin juutalaiset ovat yhä rakkaita Jumalalle niiden lupausten tähden, jotka hän antoi Aabrahamille, Iisakille ja Jaakobille. ");
INSERT INTO fin_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Jumala ei ota takaisin lahjojaan eikä peruuta kutsuaan. ");
INSERT INTO fin_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Kerran te elitte kapinassa Jumalaa vastaan, mutta kun juutalaiset kieltäytyivät hänen lahjoistaan, hän armahti heidän sijastaan teitä. ");
INSERT INTO fin_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Nyt siis juutalaiset puolestaan ovat osoittautuneet kapinallisiksi, mutta kerran Jumala armahtaa heitä samalla tavoin kuin teitä. ");
INSERT INTO fin_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Hän on luovuttanut kaikki ihmiset synnin valtaan, että hän voisi armahtaa kaikkia samalla tavoin. ");
INSERT INTO fin_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Meillä on todella ihmeellinen Jumala! Hänen viisautensa, tietonsa ja rikkautensa on valtava. Mahdotonta meidän on käsittää hänen päätöksiään ja hänen menettelyään. ");
INSERT INTO fin_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Sillä kuka meistä tietää Jumalan ajatukset? Kuka on niin viisas, että voisi olla hänen neuvonantajansa? ");
INSERT INTO fin_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Kuka pystyisi antamaan Herralle jotain sellaista, mistä voisi odottaa vastalahjaa? ");
INSERT INTO fin_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Kaikkihan tulee Jumalalta. Kaikki on olemassa hänen voimastaan ja hänen kunniakseen. Tulkoon hänelle siitä ikuisesti kunnia! ");
INSERT INTO fin_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Rakkaat ystävät, koska Jumala siis on Kristuksen tähden hyväksynyt meidät omikseen, pyydän hartaasti teitä antamaan itsenne kokonaan Jumalan käyttöön – elävänä uhrina, jonka hän voi ottaa vastaan. Tämä on oikea tapa palvella Jumalaa. ");
INSERT INTO fin_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Älkää omaksuko tämän maailman elämäntapaa, vaan olkaa te erilaisia ihmisiä. Muuttukaa, uudistukaa jatkuvasti, tutkikaa, mikä on Jumalan tahto, mikä hyvää, oikeudenmukaista, puhdasta. ");
INSERT INTO fin_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Jumalan lähettiläänä sanon teille jokaiselle: älkää kuvitelko itsestänne liikoja, vaan arvioikaa itseänne sen mukaan kuin Jumala on teille kullekin uskoa antanut. ");
INSERT INTO fin_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","5","Samoin kuin meillä on monta ruumiinosaa omassa ruumiissamme, niin on myös Kristuksen ruumiissa, seurakunnassa. Kaikki me kuulumme siihen, eikä se olisi täydellinen ilman meitä, sillä meillä kullakin on erilainen tehtävä. Niin me olemme myös toinen toistemme jäseniä ja tarvitsemme toisiamme. ");
INSERT INTO fin_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Jumala on antanut meille erilaisia armolahjoja. Jos hän on antanut sinulle profetoimisen lahjan, niin profetoi, milloin voit – niin usein kuin uskosi on kyllin vahva vastaanottamaan sanoman Jumalalta. ");
INSERT INTO fin_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Jos sinun lahjasi on toisten palveleminen, niin palvele tunnollisesti. Jos olet seurakunnan opettaja, opeta hyvin. ");
INSERT INTO fin_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Jos olet sananjulistaja, huolehdi siitä, että puheesi ovat rohkaisevia ja hyödyksi seurakunnalle. Jos Jumala on uskonut sinulle varoja, käytä niitä toisten auttamiseen. Jos Jumala on antanut sinulle järjestelykykyä ja pannut sinut johtavaan asemaan, ota vastuusi vakavasti. Jos autat ja lohdutat muita, tee se ilomielin. ");
INSERT INTO fin_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Rakastakaa vilpittömästi toisianne. Vihatkaa kaikkea väärää. Asettukaa aina hyvän puolelle. ");
INSERT INTO fin_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Rakastakaa toisianne kuin veljet ja suorastaan kilpailkaa toinen toisenne kunnioittamisessa. ");
INSERT INTO fin_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Älkää koskaan tehkö työtänne laiskasti, vaan palvelkaa innokkaasti Herraa. ");
INSERT INTO fin_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Iloitkaa kaikesta, mitä Jumala on suunnitellut teidän varallenne. Olkaa kärsivällisiä vaikeuksissa ja pyytäkää itsellenne rukouksen henkeä. ");
INSERT INTO fin_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Kun Jumalan lapset kärsivät puutetta, auttakaa te heitä. Ottakaa tavaksenne osoittaa vieraanvaraisuutta. ");
INSERT INTO fin_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Jos joku sortaa teitä siksi, että olette kristittyjä, älkää kostako hänelle, vaan rukoilkaa, että Jumala siunaisi häntä. ");
INSERT INTO fin_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Kun toiset ovat onnellisia, iloitkaa heidän kanssaan. Jos he ovat surullisia, jakakaa heidän murheensa. ");
INSERT INTO fin_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Tehkää iloisina työtä yhdessä korostamatta omaa osuuttanne. Älkää tavoitelko merkkihenkilöiden suosiota, vaan iloitkaa tavallisten ihmisten seurasta. Älkää kuvitelko olevanne kaikkitietäviä! ");
INSERT INTO fin_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Älkää milloinkaan kostako pahaa pahalla. Toimikaa siten, että kaikkien on helppo nähdä teidän olevan täysin rehellisiä. ");
INSERT INTO fin_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Älkää riidelkö kenenkään kanssa. Eläkää kaikkien kanssa rauhassa, mikäli se teistä riippuu. ");
INSERT INTO fin_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Rakkaat ystävät, älkää kostako kenellekään! Jättäkää kostaminen Jumalalle, sillä hän on sanonut, että hän maksaa kullekin tämän ansioiden mukaan. Älkää ottako oikeutta omiin käsiinne. ");
INSERT INTO fin_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Antakaa mieluummin vihollisellenne ruokaa, jos hän on nälissään. Jos hänen on jano, antakaa hänelle juotavaa, ja niin hän joutuu häpeämään sitä, mitä on teille tehnyt. ");
INSERT INTO fin_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Älkää antako pahan saada ylivaltaa elämässänne, vaan voittakaa paha hyvällä. ");
INSERT INTO fin_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Olkaa kuuliaisia omalle esivallallenne, sillä Jumala on asettanut sen teidän yläpuolellenne. Ei ole olemassa sellaista hallitusvaltaa, jota Jumala ei olisi antanut. ");
INSERT INTO fin_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Sen tähden ne, jotka kieltäytyvät noudattamasta maan lakeja, kieltäytyvät tottelemasta Jumalaa. He saavat siitä rangaistuksen. ");
INSERT INTO fin_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Viranomaisten valta ei pelota ihmistä, joka elää oikein, mutta huonoilla teillä oleva pelkää aina viranomaisia. Jos siis et tahdo olla peloissasi, noudata maasi lakeja, ja elämäsi sujuu hyvin. ");
INSERT INTO fin_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Jumala on pannut esivallan auttamaan sinua. Mutta jos teet jotain väärää, sinun on tietenkin pelättävä, sillä esivallan edustaja vie sinut rangaistavaksi. Tässäkin esivalta on Jumalan palvelija. ");
INSERT INTO fin_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Noudattakaa siis lakeja kahdesta syystä: ensiksi, ettette joutuisi rangaistaviksi, ja toiseksi, koska omatuntonne sanoo, että se on oikein. ");
INSERT INTO fin_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Näistä samoista syistä me verojakin maksamme. Täytyyhän viranomaisilla olla varoja, joita he voivat käyttää yhteiseksi hyväksi. Tässä he ovat Jumalan palvelijoita. ");
INSERT INTO fin_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Sen tähden maksakaa jokaiselle se, mitä olette velvolliset maksamaan. Maksakaa iloisesti veronne ja tullinne. Totelkaa niitä, jotka ovat yläpuolellanne, ja kunnioittakaa niitä, joille kunnia kuuluu. ");
INSERT INTO fin_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Maksakaa pois kaikki velkanne, paitsi rakkauden velkaa – sitä älkää koskaan lakatko maksamasta! Sillä jos rakastatte ihmisiä, noudatatte siten kaikkia Jumalan lakeja ja täytätte kaikki hänen vaatimuksensa. ");
INSERT INTO fin_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Jos rakastatte lähimmäistänne yhtä paljon kuin itseänne, ette tahdo vahingoittaa ettekä pettää häntä, ette tappaa häntä ettekä varastaa häneltä. Ette myöskään tahdo tehdä aviorikosta hänen puolisonsa kanssa, ettekä halua itsellenne sellaista, mikä kuuluu hänelle. Tehän ymmärrätte, että kaikki nämä käskyt sisältyvät tähän yhteen: »Rakasta lähimmäistäsi niin kuin rakastat itseäsi!» ");
INSERT INTO fin_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Rakkaus ei tee toiselle mitään pahaa. Sen vuoksi se täyttää kaikki Jumalan vaatimukset. Se on ainoa laki, jonka te tarvitsette. ");
INSERT INTO fin_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Teidän tulee elää oikein myös toisesta syystä: tiedätte kuinka pitkälle aika on kulunut. Maailmanaika on loppumassa. Herätkää unestanne, sillä Herran paluu on nyt lähempänä kuin silloin, kun meistä tuli Kristukseen uskovia. ");
INSERT INTO fin_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","13","Yö on jo kulunut pitkälle. Aamu sarastaa. Lakatkaa sen tähden tekemästä pahoja pimeyden töitä ja eläkää oikein – niin, että kaikki tekonne kestävät päivänvalon. Olkaa kunniallisia ja rehellisiä kaikessa, mitä teette. Älkää tuhlatko aikaanne juhlimiseen ja juopotteluun, siveettömyyteen ja holtittomaan elämään tai riitaan ja kateuteen. ");
INSERT INTO fin_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Pyytäkää Herraa Jeesusta Kristusta auttamaan teitä elämään oikein ja välttämään sellaista, mikä houkuttelee pahaan. ");
INSERT INTO fin_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ottakaa lämpimästi vastaan jokainen Kristukseen uskova, joka haluaa liittyä teidän joukkoonne, vaikka hänen uskonsa olisikin heikko. Älkää arvostelko häntä sen vuoksi, että hänellä saattaa olla erilainen käsitys siitä mikä on oikein. ");
INSERT INTO fin_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Älkää esimerkiksi väitelkö kysymyksestä, voiko epäjumalille uhrattua lihaa syödä vai ei. Te saatatte uskoa, ettei sen syöminen teitä vahingoita. Mutta toisten usko on heikompi: heidän mielestään se on väärin, ja he lopettavat kokonaan lihansyönnin ja syövät vihanneksia mieluummin kuin sellaista lihaa, josta eivät varmasti tiedä, onko se epäjumalille uhrattua vai ei. ");
INSERT INTO fin_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ne, jotka syövät epäjumalille uhrattua lihaakin, eivät saa halveksia niitä, jotka eivät sitä syö. Ja ne, jotka eivät syö, eivät saa tuomita niitä, jotka syövät. Jumala on ottanut heidätkin lapsikseen. ");
INSERT INTO fin_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","He ovat Jumalan palvelijoita – eivät sinun. Hänelle he ovat vastuussa eivätkä sinulle. Anna Jumalan ilmaista heille, ovatko he oikeassa vai väärässä. Kyllä Jumala voi auttaa heitä menettelemään oikein. ");
INSERT INTO fin_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Joidenkin mielestä on yksi päivä toista pyhempi, muutamien mielestä taas jokainen päivä kuuluu samalla tavoin Jumalalle. Tämäntapaisissa kysymyksissä jokaisen on ratkaistava itse oma kantansa. ");
INSERT INTO fin_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Jos valikoit päiviä, teet sen kunnioittaaksesi Herraa. Toinen syö kaikkea, toinen ei – kumpikin haluaa elää Jumalan tahdon mukaan ja kiittää Herraa. ");
INSERT INTO fin_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Emme me voi elää emmekä kuolla niin kuin itse tahdomme. ");
INSERT INTO fin_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Elimmepä tai kuolimme, olemme Herran omat ja noudatamme hänen tahtoaan. ");
INSERT INTO fin_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Kristus kuoli ja nousi kuolleista juuri sen tähden, että hän olisi Herramme sekä meidän eläessämme että kuollessamme. ");
INSERT INTO fin_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Miksi arvostelet veljeäsi tai halveksit häntä? Jokainen meistä joutuu itse vastaamaan omista teoistaan Jumalan tuomioistuimen eteen. ");
INSERT INTO fin_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Onhan kirjoitettu: »Koska minä elän, sanoo Herra, jokaisen ihmisen täytyy kumartua maahan saakka edessäni ja jokaisen kielen tunnustaa minut kaikkivaltiaaksi.» ");
INSERT INTO fin_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Meidän kaikkien on tehtävä itsestämme täi Jumalalle. ");
INSERT INTO fin_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Älkää sen vuoksi enää arvostelko toisianne. Yrittäkää sen sijaan elää sillä tavoin, ettette aiheuta veljellenne lankeemusta tekemällä hänen nähtensä jotakin sellaista, mikä on hänen mielestään väärin. ");
INSERT INTO fin_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Koska Herra Jeesus on antanut minulle viisautta, uskallan sanoa varmasti: epäjumalille uhratun lihan syömisessä ei ole mitään pahaa. Mutta jos joku uskoo, että se on väärin, hänen ei pitäisi tehdä sitä, koska hänelle se on väärin. ");
INSERT INTO fin_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","Jos veljeäsi kiusaa se, mitä sinä syöt, voit silloin rakkaudesta häneen jättää sen syömättä. Älä anna syömisesi turmella ihmistä, jonka puolesta Kristus on kuollut. ");
INSERT INTO fin_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Älkää tehkö sellaista, mikä herättää arvostelua, vaikka tietäisittekin tekevänne oikein. ");
INSERT INTO fin_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Eihän Jumalan valtakunnassa syöminen ja juominen ole pääasia, vaan uusi elämä: Pyhän Hengen antama ilo ja rauha. ");
INSERT INTO fin_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Jos sallit Kristuksen ohjata elämääsi näissä asioissa, ilahdutat sekä Jumalaa että lähimmäistäsi. ");
INSERT INTO fin_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Pyrkikäämme tällä tavalla hyvään keskinäiseen yhteyteen. Se edistää rauhaa ja koituu jokaisen parhaaksi. ");
INSERT INTO fin_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Älä tee Jumalan työtä tyhjäksi ruokailutottumuksillasi. Kaikki on tosin puhdasta, mutta ei ole hyvä toimia vastoin omaatuntoaan. ");
INSERT INTO fin_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","On parempi luopua lihasta tai viinistä ja kaikesta muustakin, mikä loukkaa toista tai saa hänet tekemään syntiä. ");
INSERT INTO fin_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Tiedät ehkä, ettei Jumalankaan mielestä ole mitään väärää siinä, mitä teet. Jollekin toiselle se voi kuitenkin olla arka asia. Onnellinen se, joka ei tuomitse itseään sellaisesta, minkä näkee oikeaksi. ");
INSERT INTO fin_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Mutta luovu sellaisesta, minkä arvelet olevan väärin. Se on silloin sinulle syntiä – sillä syntiä on kaikki, mikä ei perustu uskoon. ");
INSERT INTO fin_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","2","Vaikka uskommekin, etteivät tietyt asiat ole Herran tahtoa vastaan, emme silti voi ilman muuta tehdä sellaista, minkä itse katsomme olevan oikein. Sen sijaan meidän on suhtauduttava hienotunteisesti niihin pelkoihin ja epäilyksiin, joita toisilla saattaa olla. Meidän on toimittava lähimmäisemme parhaaksi, että hän kasvaisi Herran tuntemisessa. ");
INSERT INTO fin_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Kristus ei elänyt omien mielihalujensa mukaan. Psalmin kirjoittaja sanoikin: »Hän tuli kärsimään pilkkaa niiden taholta, jotka ovat Jumalaa vastaan.» ");
INSERT INTO fin_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Näistä asioista on jo kauan sitten kirjoitettu Raamattuun siksi, että me oppisimme niistä kärsivällisyyttä ja saisimme rohkaisua voidaksemme odottaa iloisina sitä aikaa, jolloin Jumala on lopullisesti voittanut synnin ja kuoleman. ");
INSERT INTO fin_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Jumala, joka antaa kärsivällisyyttä ja kestävyyttä, antakoon teille myös hyvän keskinäisen yhteyden, niin että teillä jokaisella on Kristuksen mieli toista kohtaan. ");
INSERT INTO fin_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","Silloin me kaikki voimme yhdessä ylistää Herraa ja antaa kunnian Jumalalle, Herramme Jeesuksen Kristuksen Isälle. ");
INSERT INTO fin_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Tukekaa ja hoitakaa toisianne, niin kuin Kristuskin on ottanut teidät hoivaansa. Silloin Jumala saa elämästänne kunnian. ");
INSERT INTO fin_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Jeesushan tuli palvelemaan juutalaisia ja osoittamaan heille, että Jumala pitää heidän isilleen antamansa lupaukset. ");
INSERT INTO fin_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","Mutta Jeesus tuli myös sen tähden, että pakanatkin pelastuisivat ja antaisivat siitä kunnian Jumalalle. Sitä psalmirunoilija tarkoitti kirjoittaessaan: »Minä ylistän sinua pakanoiden keskellä ja laulan kiitosta nimellesi.» ");
INSERT INTO fin_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Toisessa paikassa sanotaan: »Iloitkaa, te pakanat, hänen kansansa, juutalaisten, kanssa.» ");
INSERT INTO fin_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Ja vielä: »Ylistäkää Herraa, kaikki pakanat; ylistäköön häntä jokainen.» ");
INSERT INTO fin_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Profeetta Jesaja sanoi: »Iisain suvusta on tuleva perillinen, joka on pakanoiden kuningas. Heidän toivonsa on yksin hänessä.» ");
INSERT INTO fin_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Sen tähden rukoilen teidän pakanoiden puolesta, että Jumala, toivon antaja, antaisi teille, jotka uskotte, Pyhän Hengen voimasta myös kestävän ilon ja rauhan. ");
INSERT INTO fin_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Tiedän, että te, veljet, olette viisaita ja hyviä ihmisiä. Te tunnette nämä asiat niin hyvin, että kykenette opettamaan ne toisillekin. ");
INSERT INTO fin_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","16","Olen kuitenkin rohkeasti korostanut joitakin kohtia tietäen, ettei minun tarvitse muuta kuin muistuttaa teitä, sillä olen Jumalan armosta Jeesuksen Kristuksen erikoislähettiläs teidän pakanoiden keskuudessa. Minun tehtäväni on tuoda teille hyvä sanoma Jeesuksesta ja valmistaa teidät Jumalalle kelpaavaksi uhriksi. Pyhä Henki onkin puhdistanut teidät ja tehnyt teistä Jumalan mielen mukaisia. ");
INSERT INTO fin_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Olen ylpeä siitä, mitä Kristus on saanut teissä aikaan. ");
INSERT INTO fin_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","En uskalla arvioida, missä määrin hän on käyttänyt muita palveluksessaan, mutta tämän tiedän: minua hän on käyttänyt työntekijänä pakanoiden keskuudessa. ");
INSERT INTO fin_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Pyhän Hengen voimasta olen puhunut, elänyt heidän joukossaan ja tehnyt ihmeitä. Tällä tavalla olen vienyt Kristuksen hyvän sanoman aina Jerusalemista kauas Illyrikoniin asti. ");
INSERT INTO fin_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Mutta koko ajan olen kiihkeästi halunnut päästä yhä kauemmaksi – sellaisille seuduille, joissa Kristuksen nimeä ei ole vielä kuultu ja joihin ei ole vielä syntynyt seurakuntia. ");
INSERT INTO fin_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Olen seurannut Raamatun työsuunnitelmaa, josta Jesaja sanoo: »Ne, jotka eivät vielä ole kuulleet Kristuksen nimeä, saavat nyt oppia tuntemaan hänet.» ");
INSERT INTO fin_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Tässä oikeastaan on syy siihen, miksi en ole ennen päässyt teidän luoksenne. ");
INSERT INTO fin_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Mutta nyt on tehtäväni täällä vihdoin lopussa, ja olen valmis tulemaan luoksenne näiden pitkien odotuksen vuosien jälkeen. ");
INSERT INTO fin_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Suunnittelen näet matkaa Espanjaan, ja kun menen sinne, poikkean samalla Roomaan. Kun sitten olemme saaneet nauttia yhdessäolosta jonkin aikaa, toivon että pääsen teidän avullanne jatkamaan matkaa. ");
INSERT INTO fin_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Ennen kuin tulen, minun on kuitenkin vietävä eräs lahja Jerusalemin juutalaiskristityille. ");
INSERT INTO fin_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Makedonian ja Akaian kristityt ovat näet keränneet keskuudestaan lahjan niille, jotka nyt ovat suurissa vaikeuksissa Jerusalemissa. ");
INSERT INTO fin_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Makedonialaiset ja akaialaiset ovat tehneet sen mielellään, sillä he katsovat olevansa kiitollisuudenvelassa Jerusalemin kristityille. Sanoma Kristuksesta tuli heille nimittäin Jerusalemin seurakunnan välityksellä. Ja koska he saivat tuon ihmeellisen hengellisen lahjan – hyvän sanoman – jerusalemilaisilta, heistä tuntuu, että vähin, mitä he puolestaan voivat tehdä, on antaa heille aineellista apua. ");
INSERT INTO fin_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Niin pian kuin olen vienyt perille tämän avustuksen ja toimittanut siten heidän hyvän tekonsa päätökseen, tulen katsomaan teitä matkallani Espanjaan. ");
INSERT INTO fin_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Olen varma siitä, että Herra antaa minulle suuren siunauksen teille välitettäväksi. ");
INSERT INTO fin_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Tahdotteko olla minun esirukoilijoitani? Jeesuksen Kristuksen tähden ja sen rakkauden tähden, jonka Pyhä Henki on antanut teille minua kohtaan, rukoilkaa paljon kanssani työni puolesta. ");
INSERT INTO fin_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Rukoilkaa, että saisin Jerusalemissa suojan niiden vihalta, jotka eivät ole kristittyjä. Pyytäkää Jumalalta myös, että kristityt siellä suostuisivat ottamaan vastaan tuomani avustuksen. ");
INSERT INTO fin_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Sitten voin tulla huojentuneena teidän luoksenne, jos Jumala niin tahtoo, ja voimme virkistää toinen toistamme. ");
INSERT INTO fin_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Lopuksi toivon vielä, että rauhan Jumala olisi teidän kaikkien kanssa. ");
INSERT INTO fin_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","2","Foibe, jalo kristitty Kenkreasta, tulee pian teitä tapaamaan. Hän on tehnyt paljon työtä omassa seurakunnassaan. Ottakaa hänet lämpimästi vastaan sisarenanne Herrassa. Tarjotkaa hänelle apuanne siinä, missä voitte, sillä hän on auttanut monia hädänalaisia – myös minua. ");
INSERT INTO fin_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Terveisiä Priskalle ja Akvilalle. He ovat kulkeneet työtovereinani Kristuksen Jeesuksen asialla. ");
INSERT INTO fin_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","He ovat panneet henkensäkin alttiiksi tähteni, enkä minä ole ainoa, joka on heille kiitollisuudenvelassa – myös kaikki pakanaseurakunnat ovat heille kiitollisia. Viekää terveiseni myös sille seurakuntalaisten joukolle, joka kokoontuu heidän kodissaan. ");
INSERT INTO fin_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Terveisiä hyvälle ystävälleni Epainetukselle. Hän oli ensimmäinen Vähän-Aasian asukas, josta tuli kristitty. ");
INSERT INTO fin_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Sanokaa terveiseni Marialle, joka on paljon auttanut meitä. ");
INSERT INTO fin_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Siellä ovat myös maanmieheni Andronikus ja Junias, jotka olivat vankilassa yhdessä kanssani. Apostolit arvostavat heitä suuresti – he olivatkin kristittyjä jo ennen minua. Lähettäkää terveisiä myös heille. ");
INSERT INTO fin_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Terveisiä Ampliatukselle, jota rakastan Jumalan lapsena, ");
INSERT INTO fin_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","ja Urbanukselle, työtoverillemme, ja rakkaalle Stakykselle. ");
INSERT INTO fin_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Muistan myös Apellesta, tuota hyvää miestä, jota on paljon koeteltu ja joka on Kristuksen avulla kestänyt kaiken. Parhaat terveiset niillekin, jotka ovat työssä Aristobuluksen talossa. ");
INSERT INTO fin_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Terveisiä maanmiehelleni Herodionille sekä Narkissuksen talon kristityille orjille. ");
INSERT INTO fin_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Lähetän myös terveiseni Herran työntekijöille Tryfainalle ja Tryfosalle sekä rakkaalle Persikselle, joka on tehnyt paljon Herran työtä. ");
INSERT INTO fin_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Terveisiä Rufukselle, jonka Herra on ottanut omakseen, ja hänen rakkaalle äidilleen, joka on ollut kuin äiti minullekin. ");
INSERT INTO fin_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Älkää unohtako Asynkritusta, Flegonia, Hermestä, Patrobasta, Hermasta ja heidän kanssaan olevia veljiä. ");
INSERT INTO fin_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Rakkaat terveiset Filologukselle, Julialle, Nereukselle ja hänen sisarelleen ja Olympaalle sekä kaikille kristityille, jotka ovat heidän luonaan. ");
INSERT INTO fin_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Tervehtikää toisianne lämpimästi. Kaikki Kristuksen seurakunnat täältä lähettävät teille terveisiä. ");
INSERT INTO fin_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Vielä yksi asia, ennen kuin lopetan tämän kirjeen. Pysytelkää erossa niistä, jotka aiheuttavat hajaannusta ja järkyttävät ihmisten uskoa opettamalla vastoin sitä, mitä teille on aikaisemmin Kristuksesta opetettu. ");
INSERT INTO fin_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Sellaiset opettajat eivät edistä Herran Jeesuksen asiaa, vaan he haluavat voittoa itselleen. He ovat hyviä puhumaan, ja yksinkertaiset ihmiset joutuvat helposti heidän pauloihinsa. ");
INSERT INTO fin_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Teidän uskollisuutenne on kaikkien tiedossa. Minäkin olen teistä hyvin iloinen. Pyrkikää aina hyvään ja välttäkää pahaa. ");
INSERT INTO fin_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Rauhan Jumala murskaa pian saatanan teidän jalkojenne alle. Rukoilen elämäänne Herran Jeesuksen Kristuksen siunausta. ");
INSERT INTO fin_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Työtoverini Timoteus sekä maanmieheni Lukius, Jaason ja Soosipater lähettävät teille parhaat toivotukset. ");
INSERT INTO fin_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Minä, Tertius, joka kirjoitan tätä kirjettä Paavalin sanelun mukaan, lähetän myös terveisiä teidän kristittynä veljenänne. ");
INSERT INTO fin_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gaius pyytää lähettämään teille terveisiä. Olen hänen vieraanaan, ja seurakunta kokoontuu täällä hänen kodissaan. Erastus, kaupungin varainhoitaja, lähettää teille terveisiä, samoin kuin Kvartus, eräs kristitty veli. Näkemiin! ");
INSERT INTO fin_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Herramme Jeesuksen Kristuksen armo kanssanne! ");
INSERT INTO fin_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Jätän teidät Jumalan huolenpitoon, hänen, joka voi tehdä teistä vahvoja Herrassa, aivan niin kuin hyvä sanoma kertoo ja minä olen teille sanonut. Tämä on Jumalan pelastussuunnitelma teille pakanoille. Aikojen alusta saakka se on pidetty salassa, ");
INSERT INTO fin_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","mutta nyt – niin kuin profeetat ennustivat ja Jumala kehottaa – tätä sanomaa julistetaan kaikkialla, ja kaikki ihmiset maailman joka kolkassa voivat uskoa Jeesukseen ja noudattaa hänen tahtoaan. ");
INSERT INTO fin_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Jumalalle, joka yksin on viisas, kunnia ikuisesti Jeesuksen Kristuksen, meidän Herramme tähden!");
INSERT INTO fin_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Lähettäjät: Paavali, jonka Jumala on valinnut levittämään tietoa Jeesuksesta Kristuksesta, sekä hänen uskonveljensä Soostenes. ");
INSERT INTO fin_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Vastaanottajat: Korintin kristityt, jotka Jumala on kutsunut omikseen ja hyväksynyt Jeesuksen tähden. Kaikki muutkin kristityt, jotka eri paikkakunnilla rukoilevat Herraamme Jeesusta. ");
INSERT INTO fin_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Jumala, Isämme, ja Herra Jeesus Kristus antakoon teille runsaan siunauksen ja kestävän rauhan. ");
INSERT INTO fin_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","En voi lakata kiittämästä Jumalaa kaikista niistä ihmeellisistä lahjoista, joita olette nyt, Kristuksen omina, saaneet. ");
INSERT INTO fin_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Hän on antanut elämällenne uuden, rikkaan sisällön. Hän on auttanut teitä puhumaan hänestä rohkeasti ja ymmärtämään, mikä on totuus. ");
INSERT INTO fin_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Juuri kaikkea tällaistahan sanoimmekin Kristuksen voivan saada teissä aikaan. ");
INSERT INTO fin_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Teillä on kaikki armolahjat ja voima toteuttaa Herramme Jeesuksen Kristuksen tahtoa odottaessanne hänen paluutaan. ");
INSERT INTO fin_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Hän pitää teidät lujina loppuun asti, niin että olette moitteettomat hänen tullessaan. ");
INSERT INTO fin_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Jumala, joka on kutsunut teidät Poikansa Jeesuksen Kristuksen, meidän Herramme ystäviksi, ei koskaan petä lupaustaan. ");
INSERT INTO fin_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Mutta, rakkaat veljet: pyydän Jeesuksen nimessä, että lakkaisitte riitelemästä keskenänne. Älkää antako erimielisyyksien hajottaa seurakuntaa, vaan eläkää sovussa ja pyrkikää yhteiseen päämäärään. ");
INSERT INTO fin_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Olen kuullut riidoistanne Kloen luona asuvilta ihmisiltä. ");
INSERT INTO fin_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Jotkut teistä sanovat olevansa Paavalin puolella, toiset Apolloksen tai Pietarin – eräät taas katsovat olevansa ainoita oikeita Kristuksen seuraajia. ");
INSERT INTO fin_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Itse asiassa olette jakaneet Kristuksen moneen osaan. Minäkö, Paavali, kuolin teidän syntienne tähden? Kastettiinko joku teistä minun nimeeni? ");
INSERT INTO fin_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","On todella hyvä, etten ole kastanut teistä muita kuin Krispuksen ja Gaiuksen. ");
INSERT INTO fin_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Kukaan ei voi ajatella, että olen yrittänyt perustaa jonkin »Paavalin kirkon». ");
INSERT INTO fin_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Stefanaan talonväen taisin tosin myös kastaa, mutta muita ei tule mieleeni. ");
INSERT INTO fin_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Kristus ei lähettänyt minua kastamaan, vaan levittämään hyvää uutista Vapahtajasta. En edes käytä puheissani monimutkaisia ajatusrakennelmia enkä lennokkaita sanoja. En näet tahdo niillä heikentää sitä voimaa, joka on yksinkertaisessa sanomassa Kristuksen rististä. ");
INSERT INTO fin_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Tiedän hyvin, että puhe Kristuksen ristinkuolemasta ja pelastuksesta tuntuu järjettömältä niistä, jotka menevät kadotukseen. Me taas, jotka pelastumme, näemme tässä samassa sanomassa suuren Jumalan voiman. ");
INSERT INTO fin_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Jumala sanoo: »Minä teen järjettömiksi kaikki ihmisten keksimät pelastussuunnitelmat, vaikka ne näyttäisivät kuinka viisailta, ja minun silmissäni heidän loistavimmatkin ajatuksensa ovat typeryyttä.» ");
INSERT INTO fin_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Miten meidän on suhtauduttava oppineisiin ihmisiin ja loistaviin ajattelijoihin, joiden viisaus perustuu heidän omiin näkemyksiinsä ja ajatusrakennelmiinsa? Jumalan näkökulmasta katsottuna heidän viisautensa on arvotonta. ");
INSERT INTO fin_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Jumala tiesi, ettei häntä voida oppia tuntemaan ihmisjärjen avulla. Siksi hän tuli ihmisenä maailmaan ja päätti pelastaa ne, jotka uskovat hänen sanaansa – mutta sitähän maailma pitää tyhmänä ja älyttömänä. ");
INSERT INTO fin_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Juutalaisten mielestä se on järjetöntä siksi, että he odottavat taivaasta merkkiä, ennen kuin voivat uskoa sanoman todeksi. Kreikkalaiset taas uskovat vain sellaiseen, mikä sopii yhteen heidän filosofiansa kanssa. ");
INSERT INTO fin_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Mutta me kerromme kaikille, että Kristus kuoli pelastaakseen ihmiset. Silloin juutalaiset suuttuvat ja muut sanovat, ettei siinä voi olla perää. ");
INSERT INTO fin_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Mutta Jumala on avannut niiden silmät, jotka hän pelastaa. Riippumatta siitä, ovatko he juutalaisia vai kreikkalaisia, he näkevät, että Kristus on Jumalan viisaan suunnitelman mukainen voima, joka pelastaa heidät. ");
INSERT INTO fin_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Jumalan mielettömältä näyttävä suunnitelma on viisaampi kuin viisaimpien ihmisten hienoimmat suunnitelmat, ja Jumalan heikkous – Kristus ristillä – on kaikkia ihmisiä voimakkaampi. ");
INSERT INTO fin_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Pankaa merkille, ettei monellakaan Kristukseen uskovalla ole erityisemmin nimeä tai valtaa tai rikkautta. ");
INSERT INTO fin_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Jumala on tieten tahtoen valinnut järjettömältä ja arvottomalta näyttävän mahdollisuuden, jotta maailman arvostamat ihmiset joutuisivat häpeään. ");
INSERT INTO fin_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Hän on ryhtynyt toteuttamaan suunnitelmaa, jota maailma halveksii ja pitää hölynpölynä. Hän haluaa osoittaa, miten olematonta inhimillinen suuruus on, ");
INSERT INTO fin_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","ettei kukaan koskaan voisi ylpeillä hänen edessään. ");
INSERT INTO fin_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Jeesuksen uhrikuoleman tähden Jumala on antanut meille elämän. Jeesus paljasti meille Jumalan pelastussuunnitelman, ja hänen ansiostaan Jumala hyväksyy meidät. Jeesuksen puhtaus on meidän puhtautemme. Hän vapautti meidät tuomiosta. ");
INSERT INTO fin_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Raamattu sanookin: »Jos joku ylpeilee, ylpeilköön vain Herran suurista töistä.» ");
INSERT INTO fin_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Hyvät ystävät, kun tulin Korinttiin ensimmäistä kertaa, en yrittänyt teillekään kertoa Jumalasta ja hänen sanomastaan hienoin sanankääntein. ");
INSERT INTO fin_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Olin päättänyt puhua vain Jeesuksesta Kristuksesta ja hänen kuolemastaan ristillä. ");
INSERT INTO fin_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Tulin sinne hyvin heikkona ja peloissani. ");
INSERT INTO fin_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Puhuin kaunistelematta, en pyrkinyt älyllisesti loistavaan esitykseen. Mutta sanoissani oli Pyhän Hengen voima, joka paljasti kuulijoille, että sanomani oli Jumalalta. ");
INSERT INTO fin_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","Halusin nimittäin, että uskonne perustuisi Jumalaan eikä ihmisten ajatuksiin. ");
INSERT INTO fin_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Kypsille kristityille voin kyllä puhua syvää viisautta. Mutta sekään ei ole peräisin tästä maailmasta eikä vetoa sen silmäätekeviin, joiden valta kerran katoaa. ");
INSERT INTO fin_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Meidän sanamme ovat viisaita, koska saamme ne Jumalalta. Ne kertovat siitä suuresta suunnitelmasta, jonka Jumala teki voidakseen viedä meidät taivaan kirkkauteen. Tämä suunnitelma pidettiin aikaisemmin salassa, vaikka se on laadittu meitä varten jo ennen maailman luomista. ");
INSERT INTO fin_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Maailman suuret johtajat eivät ole tajunneet tätä suunnitelmaa – muuten he eivät olisi ristiinnaulinneet taivaan Herraa. ");
INSERT INTO fin_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Tätä Raamattu tarkoittaa sanoessaan, ettei kukaan ihminen ole koskaan nähnyt, kuullut eikä osannut edes kuvitella, mitä kaikkea ihmeellistä Jumala on varannut häntä rakastaville. ");
INSERT INTO fin_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Me kuitenkin tiedämme sen, sillä Jumala lähetti Henkensä ilmoittamaan sen meille, ja Jumalan Henki tutkii ja paljastaa hänen suurimmatkin salaisuutensa. ");
INSERT INTO fin_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Kukaan ihminen ei pysty tarkasti sanomaan, mitä joku toinen ajattelee tai millainen hän on, paitsi tuo toinen itse. Samaten Jumalankaan ajatuksia ei voi tuntea kukaan muu kuin Jumalan Henki. ");
INSERT INTO fin_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Jumala on antanut meille juuri oman Henkensä eikä maailman henkeä, jotta tietäisimme, miten paljon lahjoja hän on varannut meille. ");
INSERT INTO fin_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Kun olemme kertoneet teille näistä lahjoista, olemme käyttäneet Pyhän Hengen antamia sanoja – emme siis sellaisia, joita ihmisinä ehkä olisimme valinneet. Olemme kertoneet hengellisistä asioista Pyhän Hengen kielellä. ");
INSERT INTO fin_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Ihminen, jolla ei ole Pyhää Henkeä, ei voi ymmärtää eikä hyväksyä Jumalan ajatuksia, joita hänen Henkensä opettaa. Ne tuntuvat mielettömiltä, ellei Pyhä Henki auta käsittämään niitä. ");
INSERT INTO fin_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Hengellinen ihminen ymmärtää kaiken, mutta se, joka ei usko, hämmentyy, kun ei lainkaan tajua mistä on kysymys. ");
INSERT INTO fin_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Miten hän voisikaan? Eihän hän ole koskaan tiennyt Jumalan ajatuksia. Hän ei ole voinut keskustella Jumalan kanssa eli rukoilla. Meillä kristityillä sen sijaan on Kristuksen mielenlaatu ja ajatukset, niin ihmeelliseltä kuin se tuntuukin. ");
INSERT INTO fin_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Hyvät ystävät, minun on pitänyt puhua teille kuin lapsille, kuin vastasyntyneille kristityille. Lapset elävät omien mielitekojensa vallassa, mutta kypsiä kristittyjä hallitsee Pyhä Henki ja he seuraavat Herraa. ");
INSERT INTO fin_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Minun on pitänyt ruokkia teitä maidolla, koska ette ole sietäneet vahvempaa ruokaa. Ja tilanne on edelleen sama. ");
INSERT INTO fin_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Olette kristittyinä yhä lapsia. Se näkyy siitä, että olette kateellisia toisillenne ja jakaudutte keskenään riiteleviin kuppikuntiin. Itse asiassa käyttäydytte niin kuin ette olisikaan Herran omia. ");
INSERT INTO fin_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Kiistelette siitä, kumpi meistä on suurempi, Apollos vai minä, ja päästätte seurakunnan hajaantumaan. Eikö tämä osoita, miten vähän olette kasvaneet kristittyinä? ");
INSERT INTO fin_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Mikä sitten olen minä ja mikä on Apollos, kun meistä tehdään kiistakapuloita? Me olemme vain Jumalan palvelijoita, jotka kumpikin olemme saaneet omat lahjamme Jumalalta, ja me autoimme teidät uskoon. ");
INSERT INTO fin_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Minun tehtäväni oli kylvää siemen sydämenne peltoon ja Apolloksen kastella sitä, mutta vain Jumala sai siemenet kasvamaan. ");
INSERT INTO fin_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","On sivuasia, kuka istuttaa ja kuka kastelee – pääasia on, että Jumala antaa ka