﻿USE sofia;
DROP TABLE IF EXISTS sofia.ffm_vpl;
CREATE TABLE ffm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ffm_vpl WRITE;
INSERT INTO ffm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dammbe Iisaa Almasiihu, taanii Daawuuda, taanii Ibarahiima, annii: ");
INSERT INTO ffm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibarahiima rimi Isiyaaka, Isiyaaka rimi Yaakuuba, Yaakuuba rimi Yahuuda e miɲiraaɓe mum, ");
INSERT INTO ffm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yahuuda rimi Fares e Sera, ɓee ngoni ɓe o rimdi e Tamara, Fares rimi Hisuruuna, Hisuruuna rimi Aram, ");
INSERT INTO ffm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram rimi Aminadaabu, Aminadaabu rimi Nasuuna, Nasuuna rimi Salmon, ");
INSERT INTO ffm_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon rimi Bo'es, oo woni mo o rimdi e Rahab, Bo'es rimi Obed, oo woni mo o rimdi e Ruut, Obed rimi Yessa, ");
INSERT INTO ffm_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yessa rimi Daawuuda kaananke oo. Daawuuda rimi Suleymaana, oo woni mo o rimdi e debbo ɗalaaɗo Uriya, ");
INSERT INTO ffm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Suleymaana rimi Robo'am, Robo'am rimi Abiya, Abiya rimi Asa, ");
INSERT INTO ffm_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa rimi Yusafat, Yusafat rimi Yoram, Yoram rimi Ujiya, ");
INSERT INTO ffm_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ujiya rimi Yotam, Yotam rimi Akas, Akas rimi Hejekiya, ");
INSERT INTO ffm_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hejekiya rimi Manaasa, Manaasa rimi Amon, Amon rimi Yusiya, ");
INSERT INTO ffm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yusiya rimi Yekuniya e miɲiraaɓe mum. Ɗum hawrii e jamaanu nde Yahuudiyankooɓe konaa so naɓiraa Baabila ndee. ");
INSERT INTO ffm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Caggal ɓe konaama ɓe naɓaama Baabila, Yekuniya rimi Salaatiyel, Salaatiyel rimi Jorobaabel, ");
INSERT INTO ffm_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Jorobaabel rimi Abihuda, Abihuda rimi Eliyakim, Eliyakim rimi Ajora, ");
INSERT INTO ffm_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ajora rimi Sadok, Sadok rimi Akim, Akim rimi Eliyuda, ");
INSERT INTO ffm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyuda rimi Eliyaajaru, Eliyaajaru rimi Mattan, Mattan rimi Yaakuuba, ");
INSERT INTO ffm_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yaakuuba rimi Yuusufu, jom suudu Mariyama, Mariyama woni inna Iisaa noddirteeɗo Almasiihu oo. ");
INSERT INTO ffm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","No dammbe ɗee njokkondirta iwde Ibarahiima faa yottii Daawuuda, jamaanuuji sappo e nay hawrata, iwde Daawuuda faa yottii nde Yahuudiyankooɓe konaa naɓiraa Baabila, jamaanuuji sappo e nay hawrata, iwde nde Yahuudiyankooɓe konaa naɓiraa Baabila faa yottii Almasiihu oo, jamaanuuji sappo e nay hawrata. ");
INSERT INTO ffm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","No Iisaa Almasiihu finiri annii: Mariyama inniiko oo yo cabbaaɗo Yuusufu, kaa fade makko suddeede, Ruuhu Ceniiɗo waɗi mo cowiiɗo. ");
INSERT INTO ffm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yuusufu cabbuɗo mo oo yo neɗɗo pooccitiiɗo, ana waɲi hersa makko, miili yaltude e cabbugal ngal e cuucuukka. ");
INSERT INTO ffm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nde o miili ɗum ndee, malaa'ika Joomiraaɗo wari e makko ley koyɗol, wii mo: —Aan Yuusufu, taanii Daawuuda, pati hul ɓamde Mariyama, sabi ɓinngel o saawi ngel e Ruuhu Ceniiɗo iwi. ");
INSERT INTO ffm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","O riman ɓiɗɗo gorko, inndiraa mo Iisaa. Sabi oon hisinan yimɓe mum e luutti mum'en ɗii. ");
INSERT INTO ffm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ɗum fuu, ɗum waɗii yalla haala ka Laamɗo yottiniri annabaajo oo kaa ana tabita nde oon wii: ");
INSERT INTO ffm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Surba oo ɓaman reedu, rima ɓiɗɗo gorko, oon inndirte Immaanuwel.» Maanaa innde ndee yo: «Laamɗo ana wondi e meeɗen». ");
INSERT INTO ffm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nde Yuusufu fini ndee, waɗiri no malaa'ika Joomiraaɗo oo wiirunoo ɗum nii. O ɓami Mariyama, ");
INSERT INTO ffm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","kaa o reentaali e mum faa ɓeyni ɓiɗɗo gorko. Yuusufu inndiri oon Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Iisaa fini Baytilaama ley leydi Yahuudiya e jamaanu laamu Hirudus. Jom'en annde iwrii funnaange, ngari Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nde ɓe ngari ndee, ɓe mbii: —Hoto kaananke Yahuudiyankooɓe dimaaɗo jooni oo woni? Min njii hoodere makko ɓanngii funnaange, min ngarii sujidande mo. ");
INSERT INTO ffm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Oon kabaaru jiiɓi hakkille Hirudus, kaɲum e Urusaliimankooɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","O noddi hooreeɓe yottinooɓe sadaka ɓee e dunkee'en Sariya ɓee fuu, o lamndii ɗum'en hoto Almasiihu oo foti rimeede. ");
INSERT INTO ffm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ɓe njaabii mo, ɓe mbii: —Baytilaama ley leydi Yahuudiya, sabi ko annabaajo oo winndunoo koo annii: ");
INSERT INTO ffm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","«Aan, Baytilaama, leydi Yahuudiya, taƴoral a wanaa ngeenndi pamardi barke e geelle Yahuuda mawɗe ɗee. Sabi ardotooɗo iwan e maa, garoowo durde Israa'iilankooɓe, yimɓe am.» ");
INSERT INTO ffm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","E ley ɗum, Hirudus noddi jom'en annde ɓee e cuucuukka, lamndii ɓe wakkati mo hoodere ndee ɓanngi oo. Ɓeen pammini mo. ");
INSERT INTO ffm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Caggal mum, o neli ɓe Baytilaama, o wii ɓe: —Njehee, kumpitoyo-ɗon kabaaru cukalel ngel faa taƴoron. So on njii ngel, kumpitee kam yalla miɗo yaha miin duu, mi sujidanoya ngel. ");
INSERT INTO ffm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Nde ɓe nani ko kaananke oo haali koo ndee, ɓe mbitti. Non ɓe coynii hoodere nde ɓe njiinoo funnaange ndee. Ko ɓe njii nde koo, ɓe ceyii seyo manngo sanne. Nde ardii ɓe yaade. Nde nde yottii ɗo cukalel ngel woni ɗoo ndee, nde darii. ");
INSERT INTO ffm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ɓe naati ley galle oo, ɓe njii cukalel ngel e inna mum Mariyama. Ɓe korfii, ɓe cujidani ngel, ɓe kumti gineeji maɓɓe, ɓe teddiniri ngel kaŋŋe e gowe e ɗacce uurooje biyeteeɗe miiri. ");
INSERT INTO ffm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Caggal ɗum, Laamɗo daalii ɓe ley koyɗol pati ɓe mbirfitoo to Hirudus, ɓe kootiri leydi maɓɓe laawol gonngol. ");
INSERT INTO ffm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nde ɓe mbitti ndee, malaa'ika Joomiraaɗo wari e Yuusufu ley koyɗol, wii ɗum: —Imma, ɓam cukalel ngel e inna mum, dogu njahaa Misira, keddo-ɗaa ton faa nde mbii-maa-mi ngartaa. Sabi Hirudus waran tewtude cukalel ngel faa wara ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yuusufu immii jemma, naɓi cukalel ngel e inna maggel Misira. ");
INSERT INTO ffm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","O heddii ton faa Hirudus maayi, yalla haala ka Laamɗo yottinirnoo annabaajo oo kaa ana tabita nde oon wii: «Mi noddii ɓiyam gonɗo Misira.» ");
INSERT INTO ffm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Nde Hirudus faami jom'en annde ɓee njammbike ɗum ndee, mettaa sanne. O yamiri sukaaɓe worɓe Baytilaama e ɗakkol mum fuu mbaree, gila keccoy faa heɓuɓe duuɓi ɗiɗi. O waɗi ɗum hakke ɲalaaɗe ɗe jom'en annde ɓee ndokki mo taƴoral mum ɗee. ");
INSERT INTO ffm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ɗum tabitirii haala ka Laamɗo yottiniri annabi Yeremiya kaa nde oon wii: ");
INSERT INTO ffm_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Wullaango nanaama ley ngeenndi Rama, kaɲum e bojji e boytaali: Ɗum Rahiilu woyata cukaloy mum. O jaɓaali waaltineede, sabi koy keddaaki.» ");
INSERT INTO ffm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Caggal maayde Hirudus, malaa'ika Joomiraaɗo wari e Yuusufu to Misira too ley koyɗol, ");
INSERT INTO ffm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","wii ɗum: —Imma, wirfintin cukalel ngel e inna mum leydi Israa'iila, sabi yiɗunooɓe warde suka oo ɓee maayii. ");
INSERT INTO ffm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yuusufu immii, naɓti cukalel ngel e inna mum leydi Israa'iila. ");
INSERT INTO ffm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kaa o nanii Arikilawus loomtiima baam mum Hirudus laatike kaananke Yahuudiya, o huli yaade ton. Ley ɗum, Laamɗo jeertini mo ley koyɗol, o yehi leydi Galili, ");
INSERT INTO ffm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","o hoɗoyi ngeenndi mbiyeteendi Nasaraatu. Non ɗum laatorii so ɗum tabintini ko annabaaɓe ɓee mbiinoo koo: «O wiyete Nasaraatunke.» ");
INSERT INTO ffm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","E oon jamaanu, Yaayaa mo lootogal batisima ɓanngi. Omo ooynoo ley ladde jeereende Yahuudiya, omo wiya: ");
INSERT INTO ffm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Tuubee, sabi Laamu Laamɗo ɓattiima. ");
INSERT INTO ffm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Oo woni mo annabi Esaaya sappinoo, nde wiinoo: «Neɗɗo ana ooynoo ley ladde jeereende, ana wiya: Moƴƴinee laawol Joomiraaɗo ngol, ndartinee ɗati makko!» ");
INSERT INTO ffm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Kaddungal Yaayaa yo caɲiraangal leeɓi ngelooba, omo humii nguruwol. Nguure makko yo buureeti e njuumri ladde. ");
INSERT INTO ffm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Yimɓe iwri Urusaliima e leydi Yahuudiya e seraaji maayo Urdun fuu, ngari e makko. ");
INSERT INTO ffm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Eɓe njaadira luutti maɓɓe, Yaayaa looti ɓe lootogal batisima ley maayo Urdun. ");
INSERT INTO ffm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nde o yii Farisa'en e Saduki'en heewɓe ana ngara faa lootee lootogal batisima ndee, o wii ɗum'en: —Ɓiɓɓe bolle! Homo jeertini on ndogon jukkungo waroowo? ");
INSERT INTO ffm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ngollee golleeji kawrooji e tuubal. ");
INSERT INTO ffm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Pati miilee e ɓerɗe mon: «Minen, min taaniraaɓe Ibarahiima.» Sabi miɗo wiya on: Laamɗo ana waawi waylitinde ɗee kaaƴe laatoo ɓiɓɓe Ibarahiima! ");
INSERT INTO ffm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jooni, jammbere ndee huncaama faa soppa ɗaɗi leɗɗe. Ndennoo, lekki fuu ki rimataa ɓiɗɗe lobbe, soppete, wedee e yiite. ");
INSERT INTO ffm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Miin, ndiyam mbatisiran-mi on faa hollita on tuubii. Kaa garoowo caggal am oo, kaɲum ɓuri kam baawɗe, mi fotaa fay soccude paɗe makko. Kanko, Ruuhu Ceniiɗo e yiite o batisirta on. ");
INSERT INTO ffm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","O lanndinike faa o hennoo ɲamri makko faa laaɓa. O mooɓta ɲamri makko ley beembal, kaa ɲaande ndee o duppiran ɗum yiite nge ɲifataa. ");
INSERT INTO ffm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Oon wakkati fuu, Iisaa iwi Galili, wari maayo Urdun to Yaayaa, yalla Yaayaa ana loota ɗum lootogal batisima. ");
INSERT INTO ffm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kaa Yaayaa ujii, wii mo: —Aan haani lootude kam, hono aan ngardataa ga am faa mi loote? ");
INSERT INTO ffm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Iisaa jaabii mo, wii: —Walaa baasi, jaɓu ngaɗaa non, sabi hono non kaan-ɗen hiɓɓinirde ko dartii fuu. Nden, o jaɓi. ");
INSERT INTO ffm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iisaa lootaa tan, ƴeeŋi iwde e ndiyam ɗam. E oon wakkati, kammu oo udditii, o yii Ruuhu Laamɗo ana jippoo no wuugaandu nii, ana wara e makko. ");
INSERT INTO ffm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɗon daande iwri dow kammu, wii: —Oo ɗoo yo Ɓiyam mo korsin-mi, mo cuɓii-mi. ");
INSERT INTO ffm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","E oon wakkati, Ruuhu Ceniiɗo naɓi Iisaa ley ladde jeereende, yalla Ibiliisa ana tewta seytaade mo. ");
INSERT INTO ffm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iisaa ɲaamaali faa waɗi balɗe capanɗe nay jemma e ɲalooma. Caggal ɗum, o yolbi. ");
INSERT INTO ffm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nii, Ceytotooɗo oo ɓattitii mo, wii mo: —So a Ɓii Laamɗo, yamir ɗee kaaƴe laatoo ɲaamdu. ");
INSERT INTO ffm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kaa o jaabii oon, o wii: —Ana winndii: «Wanaa ɲaamdu tan neɗɗo wuurdata, ko neɗɗo wuurdata dee, haala fuu ka Laamɗo haali.» ");
INSERT INTO ffm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Caggal ɗum, Ibiliisa naɓi mo Urusaliima ngeenndi ceniindi ndii, darni mo dow leŋŋe-leŋŋe Suudu Dewal Mawndu, ");
INSERT INTO ffm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","wii mo: —So a Ɓii Laamɗo, suur njippo-ɗaa e leydi. Sabi ana winndii: «Laamɗo yamiran malaa'ika'en mum njaɓɓite pati koyngal maa gaaɲo e haayre.» ");
INSERT INTO ffm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Oon wii mo: —Ana winndii kasen: «Pati ittu koro Laamɗo, Joomiraaɗo maa.» ");
INSERT INTO ffm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kasen Ibiliisa naɓi mo dow waamnde haayre toownde sanne, holli mo laamuuji aduna ɗii fuu e darja mum'en, ");
INSERT INTO ffm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","wii mo: —Mi hokkete ɗum ɗoo fuu so tawii a sujidanii kam. ");
INSERT INTO ffm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Oon wii mo: —Fottanam too, Ibiliisa! Sabi ana winndii: «Laamɗo Joomiraaɗo maa tan kaan-ɗaa sujidande, kanko tan kaan-ɗaa rewde.» ");
INSERT INTO ffm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Oon wakkati fuu, Ibiliisa seli e makko. Malaa'ika'en ngari e makko, ana ngollana mo. ");
INSERT INTO ffm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nde Iisaa nani Yaayaa uddaama ley kasu ndee, o wirfitii Galili. ");
INSERT INTO ffm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","O eggi Nasaraatu, o hoɗoyi Kafarnahum e daande weendu nduu ley leydi Jebulon, kaɲum e Naftali, ");
INSERT INTO ffm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","yalla ana tabintina haala ka Laamɗo yottiniri annabi Esaaya kaa nde oon wii: ");
INSERT INTO ffm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Leydi Jebulon e leydi Naftali gonɗe dow laawol weendu, caggal maayo Urdun, e Galili hoɗorde yimɓe ɓe nganaa Yahuudiyankooɓe: ");
INSERT INTO ffm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Leɲol gonnoongol e nimre ngol yii fooyre mawnde. Wuurɓe e ley leydi maayde niɓɓundi, fooyre yaaynani ɗum'en.» ");
INSERT INTO ffm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Gila nden, Iisaa fuɗɗi waajaade ana wiya: —Tuubee, sabi Laamu Laamɗo ɓattiima. ");
INSERT INTO ffm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Iisaa ana yahannoo dow fonngo weendu Galili, o yii worɓe ɗiɗon miɲiraaɗo e mawniraaɗo, Simon noddirteeɗo Piyeer e miɲum Andire ana tippoo bubbi mum'en ley weendu nduu, yo awooɓe. ");
INSERT INTO ffm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Iisaa wii ɓe: —Njokkee kam, mi waɗa on awooɓe yimɓe. ");
INSERT INTO ffm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ɗon e ɗon ɓe njoppi bubbi maɓɓe ɗii, ɓe njokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","O yehi yeeso, o yii kasen rimdaaɓe ɗiɗon woɓɓe, ɓiɓɓe Jebede, Yaakuuba e miɲum Yuhanna ana ley laana. Kamɓe e baam maɓɓe Jebede, eɓe moƴƴintina bubbi maɓɓe. O noddi ɓe. ");
INSERT INTO ffm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ɗon e ɗon ɓe njoppi laana kaa e baam maɓɓe fuu, ɓe njokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iisaa yiilii ley leydi Galili fuu omo waajoo e ley cuuɗi baajorɗi maɓɓe, omo ooynoo Kabaaru Lobbo haala Laamu Laamɗo oo, kasen omo sellina sii ɲawuuji e ellaaji fuu. ");
INSERT INTO ffm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kabaaru makko saakii ley leydi Siriya fuu. Omo waddanee sii ɲawɓe fuu, laddaaɓe e kirikiraaɓe, kaɲum e wooyɓe, o sellini ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jamaa keewɗo sanne jokki e makko iwruɗo Galili e leydi ndi geelle sappo e Urusaliima e Yahuudiya e caggal maayo Urdun. ");
INSERT INTO ffm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nde Iisaa yii jamaa oo heewii ndee, o ŋabbi dow waamnde haayre, o jooɗii ton. Taalibaaɓe makko ɓee ngari e makko, ");
INSERT INTO ffm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","o fuɗɗi waajaade ɓe, o wii: ");
INSERT INTO ffm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ɓeen annditinɓe yonkiiji mum'en ana lo'i, mbelii hoore, sabi kamɓe njey Laamu Laamɗo oo! ");
INSERT INTO ffm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ɓeen woyooɓe, mbelii hoore, sabi Laamɗo waaltinan ɓerɗe mum'en! ");
INSERT INTO ffm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ɓeen leyɗinkiniiɓe, mbelii hoore, sabi ɓe keɓan leydi ndi Laamɗo fodani ɓe ndii! ");
INSERT INTO ffm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ɓeen yolbuɓe fooccitaare so ɗomɗi ɗum, mbelii hoore, sabi ɓe kaaran ɓe ɗomɗitan! ");
INSERT INTO ffm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ɓeen yurmotooɓe, mbelii hoore, sabi Laamɗo yurmoto ɓe! ");
INSERT INTO ffm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ɓeen laaɓuɓe ɓerɗe, mbelii hoore, sabi ɓe njiyan Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ɓeen waddooɓe jam, mbelii hoore, sabi ɓe noddirte ɓiɓɓe Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ɓeen torraaɓe kammari fooccitaare, mbelii hoore, sabi kamɓe njey Laamu Laamɗo oo! ");
INSERT INTO ffm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","On mbelii hoore so yimɓe njennii on, torrii on, kappii on sii boneeji fuu saabe am. ");
INSERT INTO ffm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ceyee, mbeltee, sabi mbarjaari mawndi ana doomi on dow kammu. Sabi hono non annabaaɓe adiiɓe on ɓee torriraa. ");
INSERT INTO ffm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Onon ngoni lamɗam aduna oo. Kaa so lamɗam ŋoottii lammude, koɗum lamminta ɗum? Ɗam nafataa fay huunde! Ko ɗam waawi waɗeede tan, tippeede sella, yimɓe njaɓɓa ɗam. ");
INSERT INTO ffm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Onon ngoni fooyre aduna oo. Ngalluure ɲiɓaande dow waamnde haayre waawaa ɲooɓude. ");
INSERT INTO ffm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Fay gooto huɓɓataa lampa, so hippa hen kaakol. Ko waɗata dee, sinndan ka, ka yaaynana gonɗo e suudu nduu fuu. ");
INSERT INTO ffm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hono non fooyre mooɗon haani yaaynirde yeeso yimɓe, yalla eɓe njiya golleeji lobbi ɗi ngaɗaton ɗii, ɓe njetta Baabiraaɗo mooɗon gonɗo dow kammu oo. ");
INSERT INTO ffm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Pati cikkee mi garɗo ittude Sariya binndaaɗo ley Tawreeta naa ley dewte annabaaɓe oo. Mi waraali ittude mo, mi garɗo hiɓɓinde mo. ");
INSERT INTO ffm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Miɗo haalana on goonga: so nii kammu e leydi ana keddii, wanaa toɓɓel wanaa masel tosataake e Sariya oo faa nde fuu tabiti. ");
INSERT INTO ffm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ɗum nee, boofuɗo ko ɓuri fuu famɗude e jamirooje ɗee, so janngini woɓɓe faa ngaɗa non, laatoto ɓurɗo famɗude e Laamu Laamɗo. Kaa neɗɗo fuu jokkuɗo sariya oo, so janngini woɓɓe ngaɗa non, laatoto mawɗo e Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Sabi miɗo wiya on: so on ɓuraali dunkee'en Sariya e Farisa'en fooccitaare, on naatataa e Laamu Laamɗo abada. ");
INSERT INTO ffm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—On nanii njaatiraaɓe meeɗen ɓee mbiyanooma: «Pati ɲaaɗu hoore, ɲaaɗuɗo hoore fuu, ana haandi e sareede.» ");
INSERT INTO ffm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Miin noo miɗo wiya on: tikkanɗo sakiike mum fuu, ana haandi e sareede. Oon biiɗo sakiike mum «Meereejo» darnete yeeso sariya ɓurɗo fuu naawde. Kasen neɗɗo fuu biiɗo mo «Nuykaaɗo» ana haandi e naatude yiite jahannama. ");
INSERT INTO ffm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ndennoo, so a warii e ittirde sadaka faa cakko-ɗaa, a miccitike ɗon e ɗon sakiike maa ana jogani maa metti, ");
INSERT INTO ffm_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yoppu ɗon sadaka maa oo, njahaa njaafondiroyaa e sakiike maa oo tafon, so keɓaa wartude cakko-ɗaa. ");
INSERT INTO ffm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","So won gullaniiɗo ma saabe ɲamaande, oɗon njaada sariya, yaawnu ndewritaa e joomum fade mooɗon yottaade, pati o waɗe e juuɗe caroowo, oon waɗe e junngo kayboowo kasu, nden kaa, udde-ɗaa e kasu. ");
INSERT INTO ffm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Miɗo haalane goonga: abada a yaltataa so a yoɓaali ko ndewete-ɗaa koo faa laaɓa. ");
INSERT INTO ffm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—On nanii wiyanooma: «Pati jeenu!» ");
INSERT INTO ffm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Miin noo miɗo wiya on: ƴeewruɗo debbo janano muuyo fuu, jeenii e ley ɓernde mum. ");
INSERT INTO ffm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ndennoo, so yitere maa ɲaamere luuttinte, sol nde tippo-ɗaa nde to woɗɗi! Mbaasaa salndu maa wooturu ɓuri moƴƴande ma diina calɗi maa ɗii fuu mbedee e jahannama. ");
INSERT INTO ffm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","So junngo maa ɲaamo luuttinte, taƴu ngo tippo-ɗaa ngo to woɗɗi: mbaasaa salndu maa wooturu ɓuri moƴƴande ma diina calɗi maa ɗii fuu naata jahannama. ");
INSERT INTO ffm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","—Wiyanooma kasen: «Ceerɗo jom suudu mum fuu, yo hokku ɗum talkuru ceergal.» ");
INSERT INTO ffm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Miin noo miɗo wiya on: ceerɗo jom suudu mum tawee oon jeenaali, so o ɓamoyaama, gorko arano oo waɗii mo e jeenu. Neɗɗo fuu ɓamɗo debbo ceeraaɗo, kaɲum duu jeenii. ");
INSERT INTO ffm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","—On nanii kasen, njaatiraaɓe meeɗen mbiyanooma: «Pati fiirtu hunoore maa, tabintin nde yeeso Joomiraaɗo.» ");
INSERT INTO ffm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Miin noo miɗo wiya on: pati kunee fey. Pati kunoree kammu, sabi ɗum yo jooɗorgal Laamɗo, ");
INSERT INTO ffm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","naa leydi, sabi ɗum yo njaaɓirdi koyɗe makko, naa Urusaliima, sabi ɗum yo ngeenndi Kaananke mawɗo oo. ");
INSERT INTO ffm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pati hunora hoore maa ndee, sabi a waawaa rawninde naa ɓawlinde fay leeɓol mayre gootol. ");
INSERT INTO ffm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mbiyaa «Mi waɗan» naa «Mi waɗataa», ɗum tan heƴii. Ko ɓeydii hen fuu, e Bonɗo oo iwi. ");
INSERT INTO ffm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","—On nanii wiyanooma: «Yitere yoɓirtee yitere, ɲiinde yoɓirtee ɲiinde.» ");
INSERT INTO ffm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Miin noo miɗo wiya on: pati njoɓtee gaɗuɗo on ko boni. So won piiɗo ma banaawo bannge ɲaamo, accu ɗum fiye bannge goɗɗo oo duu. ");
INSERT INTO ffm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","So won gullaniiɗo ma faa teeta forgo maa, accu ɗum naɓa dolloke oo duu. ");
INSERT INTO ffm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","So won tilsinɗo ma roondaade donngal yaadu kiloomeetere, roonda ngal yaadu kiloomeetereeji ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","So won ɲaagiiɗo ma, hokku ɗum, so won ndaarduɗo ma luɓal, pati haɗu ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","—On nanii wiyanooma: «Njiɗaa tanaa maa, mbaɲaa gaɲo maa.» ");
INSERT INTO ffm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Miin noo miɗo wiya on: njiɗee konnee'en mooɗon, kasen duu nduwanee torrooɓe on, ");
INSERT INTO ffm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","yalla oɗon laatoo ɓiɓɓe Baabiraaɗo mooɗon gonɗo dow kammu oo. Sabi no o fuɗinirta naange makko e bonɓe nii, hono non o fuɗinirta nge e moƴƴuɓe, kasen duu no o toɓinirta e fooccitiiɓe nii, hono non o toɓinirta e ooɲiiɓe. ");
INSERT INTO ffm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","So yiɗuɓe on tan njiɗaton, mbarjaari hendi keɓaton hen? Fay duwaaɲe'en ɓee ana ngaɗira non! ");
INSERT INTO ffm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","So sakiraaɓe mooɗon tan njowtaton, koɗum seenndi on e woɓɓe ɓee? Fay heeferɓe ɓee ana ngaɗira non! ");
INSERT INTO ffm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ndennoo, laatee hiɓɓuɓe, hono no Baabiraaɗo mooɗon gonɗo dow kammu oo laatorii kiɓɓuɗo nii. ");
INSERT INTO ffm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Ndeentee e gollirde golleeji mon lobbi faa yiyee. So on ngaɗii ɗum, on keɓataa mbarjaari to Baabiraaɗo mooɗon gonɗo dow kammu oo. ");
INSERT INTO ffm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ndennoo, so aɗa itta sadaka, pati waɗu dillere faa yimɓe njiye, hono no naafigi'en ɓee ngaɗata ley cuuɗi baajorɗi, kaɲum e laawi nii. Eɓe ngaɗa non yalla yimɓe ana mana ɓe. Miɗo haalana on goonga, ɓeen keɓii mbarjaari mum'en faa timmi. ");
INSERT INTO ffm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kaa aan, so aɗa itta sadaka, pati nano maa annda ko ɲaamo maa waɗata, ");
INSERT INTO ffm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","yalla sadaka maa oo ana heddoo ley cuucuukka. Nden Baabiraaɗo maa jiyoowo ko woni e cuucuukka oo, yoɓete. ");
INSERT INTO ffm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—So oɗon nduwoo, pati ngaɗee no naafigi'en nii: ɓeen ana njiɗi duworaade darnde ley cuuɗi baajorɗi, kaɲum e hakkunde ɗati celi, yalla yimɓe fuu ana njiya ɗum'en. Miɗo haalana on goonga, ɓeen keɓii mbarjaari mum'en faa timmi. ");
INSERT INTO ffm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kaa aan, nde nduwoto-ɗaa fuu, naatu ley suudu maa, uddaa damal, ɲaago-ɗaa Baabiraaɗo maa e cuucuukka. Nden, Baabiraaɗo maa jiyoowo ko suuɗii oo, yoɓete. ");
INSERT INTO ffm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","So oɗon nduwoo, pati kebbinee haalaaji ɓoli ɗi ngalaa nafaa hono no heeferɓe ɓee nii: eɓe miili Laamɗo jaabanto ɓe so ɓe kebbinii haala. ");
INSERT INTO ffm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pati ɲemmbee ɓe, sabi Baabiraaɗo mooɗon ana anndi ko kaaje-ɗon gila on ɲaagaaki mo. ");
INSERT INTO ffm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Nii kaan-ɗon duworaade: Baabiraaɗo amen gonɗo dow kammu, yo innde maa teddine. ");
INSERT INTO ffm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yo Laamu maa war. Yo muuyɗe maa ngaɗe dow leydi no ngaɗiraa dow kammu nii. ");
INSERT INTO ffm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hokku min hannde ɲaamdu heƴooru min. ");
INSERT INTO ffm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Yaafa min luutti amen, hono no min njaaforii tooɲuɓe min nii. ");
INSERT INTO ffm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pati accu min ceytee, hisin min e Bonɗo oo. Sabi laamu e baawɗe e teddeengal ana ngoodan maa faa abada. Aamiina. ");
INSERT INTO ffm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ndennoo, so on njaafiima tooɲuɓe on, Baabiraaɗo mooɗon gonɗo dow kammu oo duu yaafoto on. ");
INSERT INTO ffm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kaa so on njaafataako tooɲuɓe on, Baabiraaɗo mooɗon oo duu yaafataako luutti mooɗon. ");
INSERT INTO ffm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—So on koorii, pati njurminkinee no naafigi'en ɓee nii: ɓeen ŋornoto, yalla yimɓe fuu ana anndita ɓe hoorɓe. Miɗo haalana on goonga: ɓeen keɓii mbarjaari mum'en faa timmi. ");
INSERT INTO ffm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kaa aan, so a hoorii, culmaa yeeso maa, ngujaa hoore maa ");
INSERT INTO ffm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pati yimɓe annda a koorɗo. Baabiraaɗo maa mo yiyataake oo tan anndata. Kasen duu Baabiraaɗo maa jiyoowo ko ngaɗ-ɗaa e cuucuukka, kaɲum yoɓete. ");
INSERT INTO ffm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Pati paggee jawdi aduna, ɗo mooƴu e nguɗu mbonnata, ɗo wuyɓe kelata baafe so ngujja. ");
INSERT INTO ffm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Paggee jawdi dow kammu, ɗo fay huunde bonnataa, wanaa mooƴu wanaa nguɗu, ɗo wuyɓe kelataa baafe sako ngujja. ");
INSERT INTO ffm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sabi ɗo jawdi maa woni fuu, ɗon yonki maa duu woni. ");
INSERT INTO ffm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Gite ngoni lampa calɗi. So gite maa ana moƴƴi, calɗi maa fuu pooynan. ");
INSERT INTO ffm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kaa so ɗe moƴƴaa, calɗi maa fuu niɓɓan. Ndennoo, so fooyre wonnde e maa ndee yo nimre, nimre hoontii nimre! ");
INSERT INTO ffm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Fay gooto waawaa gollande halfaaɓe ɗiɗon, sabi naa joomum waɲii gooto, yiɗii keddiiɗo oo, naa nanngondirii e gooto oo, yoppii keddiiɗo oo. On mbaawaa gollidande Laamɗo e jawdi. ");
INSERT INTO ffm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ɗum nee, miɗo wiya on: pati cuŋlee e nguurndam mon ko ɲaamaton e ko njaraton e ko koltoton. Pati cuŋlanee ko ɓoornoto-ɗon. Tama nguurndam ɓuraa nguure? Tama calɗi ɓuraa koltal? ");
INSERT INTO ffm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ƴeewee pooli diwooji ɗii: ɗi aawataa, ɗi kettataa, ɗi mbeembataa, kaa Baabiraaɗo mooɗon gonɗo dow kammu oo ana ɲammina ɗi. Onon nee, on ɓuraa pooli teentilaade naa? ");
INSERT INTO ffm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Homo e mon waawi ɓeydude e balɗe mum fay ɲalooma gooto kammari sugulla mum? ");
INSERT INTO ffm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ko waɗi so oɗon cuŋlana kaddule? Ƴeewee piindiiji ley ngesa no peertirta: ɗi tampataa, ɗi mottataa. ");
INSERT INTO ffm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Haya miɗo wiya on: Suleymaana e ngalu mum fuu paroraaki no gootel e majji nii. ");
INSERT INTO ffm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","So Laamɗo ana holtinira nii leggiri taweteendi ley ngesa hannde, tippeteendi e yiite janngo, ko haɗata mo holtinde on faa ɓura nii, onon famɗuɓe hoolaare! ");
INSERT INTO ffm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ndennoo, pati cuŋlee faa mbiyon: «Koɗum ɲaamaten? Koɗum njaraten? Koɗum ɓoornoto-ɗen?» ");
INSERT INTO ffm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sabi ɗee kulle fuu heeferɓe tan ndaarata ɗum. Kaa Baabiraaɗo mon gonɗo dow kammu oo ana anndi oɗon kasindini e majjum ɗum fuu. ");
INSERT INTO ffm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ndaartee tafon Laamu Laamɗo oo, kaɲum e fooccitaare makko ndee. Ko heddii koo fuu, on ɓeydante ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ndennoo, pati cuŋlanee janngo, sabi janngo suŋlanan hoore mum. Ɲalooma fuu, donngal mum ana heƴa ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Pati ɲiŋee, yalla oɗon mbaasa ɲiŋeede. ");
INSERT INTO ffm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Sabi hono no ɲiŋirton woɓɓe nii, nii ɲiŋirte-ɗon. Kasen duu ko etiranton woɓɓe koo, ɗum etirante-ɗon. ");
INSERT INTO ffm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ko saabii so aɗa yiya kuɗol ley yitere sakiike maa, tawee aan nee, a yiyataa leggal gonngal e ley nde maa ndee? ");
INSERT INTO ffm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hono mbaawru-ɗaa wiide sakiike maa: «Sakiike, ɗal mi ittane kuɗol gonngol e yitere maa ngol», tawee aan nee, leggal woni e ley nde maa ndee? ");
INSERT INTO ffm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Naafigi, ittu leggal gonngal e yitere maa ngal tafon, nden jiile maa laaɓata, faa keɓaa no ittiraa kuɗol gonngol e yitere sakiike maa ngol. ");
INSERT INTO ffm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Pati ndokkee dawaaɗi ko dagii, sabi ɗi mbirfitanto on ɗi ŋata on. Pati caakee ɲaaƴe mooɗon dime yeeso girooji, sabi ɗi njaɓɓan ɗe. ");
INSERT INTO ffm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Ɲaagee, on keɓan, tewtee, on njiitan, calminee gila oɗon damal galle, on udditante. ");
INSERT INTO ffm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sabi ɲaagiiɗo fuu heɓan, tewtuɗo fuu yiitan, calminɗo fuu udditante. ");
INSERT INTO ffm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Homo woni e mon mo ɓiyum ɲaagotoo buuru so hokka ɗum haayre? ");
INSERT INTO ffm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Naa ɲaagoo ɗum liingu, hokka ɗum mboddi? ");
INSERT INTO ffm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","No mbonir-ɗon fuu, oɗon ndokka ɓiɓɓe mon kulle lobbe, sako Baabiraaɗo mon gonɗo dow kammu oo. Omo hokka ɲaagiiɗo mo fuu kulle lobbe. ");
INSERT INTO ffm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ndennoo, ngaɗiranee yimɓe no njiɗ-ɗon ɓe ngaɗirana on nii. Ɗum woni ko Tawreeta Muusaa e dewte annabaaɓe ɗee njamiri. ");
INSERT INTO ffm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Naatiree damal paaɗungal ngal! Sabi damal naatirgal e halkere ana yaajii, laawol mum ngol ana newii, jokkooɓe ngol ɓee duu ana keewi. ");
INSERT INTO ffm_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kaa damal naatirgal e nguurndam ana faaɗii, laawol mum ngol ana tiiɗi, kasen yiitooɓe ngol ɓee yo seeɗa. ");
INSERT INTO ffm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Ndeentee e annabaaɓe peneeɓe ɓee. So eɓe ngara e mon, ɓe nanndinkinto e baali, kaa so goonga, ɓe ɲaatooji bonɗi. ");
INSERT INTO ffm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Golleeji maɓɓe annditirton ɓe hono no lekki annditirtee ɓiɗɗe mum nii. Peguuje teɓataake e kebbe, ibbe teɓataake e ɲakkaɓere. ");
INSERT INTO ffm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Lekki lobbi ɓiɗɗe lobbe rimata, kaa lekki mbonki ɓiɗɗe bonɗe rimata. ");
INSERT INTO ffm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Lekki lobbi waawataa rimde ɓiɗɗe bonɗe, kasen duu lekki mbonki waawataa rimde ɓiɗɗe lobbe. ");
INSERT INTO ffm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Lekki fuu ki rimataa ɓiɗɗe lobbe soppete, wedee e yiite. ");
INSERT INTO ffm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ndennoo, golleeji maɓɓe annditirton ɓe. ");
INSERT INTO ffm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Wanaa wiyooɓe kam «Moobbo, Moobbo» ɓee fuu naatata e Laamu Laamɗo oo. Waɗooɓe sago Baabiraaɗo am gonɗo dow kammu oo ɓee tan ngoni naatooɓe e makko. ");
INSERT INTO ffm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ɲannde darngal, heewɓe mbiyan kam: «Moobbo, Moobbo! Wanaa e innde maa min njottiniri nulal naa? Wanaa e innde maa min ndibbiri seyɗaani'en naa? Wanaa e innde maa min ngaɗiri kaayɗe keewɗe naa?» ");
INSERT INTO ffm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Oon wakkati, mi jaaborto ɓe nii: «Mi anndaa on abada. Ngoɗɗee kam, onon waɗooɓe ko boni ɓee!» ");
INSERT INTO ffm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Ndennoo, neɗɗo fuu kettindiiɗo haalaaji am ɗii so jokki ɗi, nanndan e hakkilante mahuɗo suudu mum e dow haayre. ");
INSERT INTO ffm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ƴiiwoonde toɓi, ilaali mbuuwi, kenuuli mawɗi mbibbi e mayru, fuu ndu saamaali, sabi ndu diidaama dow haayre. ");
INSERT INTO ffm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kaa neɗɗo fuu kettindiiɗo haalaaji am ɗii so jokkaali ɗi, ana nanndi e mo walaa hakkille, mahuɗo suudu mum e dow njaareendi. ");
INSERT INTO ffm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ƴiiwoonde toɓi, ilaali mbuuwi, kenuuli mawɗi mbibbi e mayru, ndu wurji wurjugol manngol. ");
INSERT INTO ffm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nde Iisaa tilii e ɗiin konngi ndee, jamaa oo satti haayneede e waaju makko oo, ");
INSERT INTO ffm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sabi o waajorike ɓe hono no jom baawɗe nii, wanaa no dunkee'en Sariya ɓee nii. ");
INSERT INTO ffm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ko Iisaa jippii waamnde haayre ndee koo, jamaa keewɗo jokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Oon wakkati, gorko ceppaaɗo wari diccii yeeso makko, wii mo: —Moobbo, so tawii a jaɓii aɗa waawi sellinde kam. ");
INSERT INTO ffm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iisaa foocci junngo mum, memi mo, wii: —Mi jaɓii, sellu! Ɗon e ɗon, ceppu gorko oo selli. ");
INSERT INTO ffm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Caggal ɗum, Iisaa wii mo: —Hettinda faa moƴƴa! Pati kaalanaa ɗum fay gooto, kaa yaa holloy hoore maa jottinoowo sadaka, ngaɗaa sadaka mo Muusaa yamiri oo, faa anndina ɓe a sellii. ");
INSERT INTO ffm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nde Iisaa naatannoo Kafarnahum ndee, hooreejo sordaasi'en ɓattii mo, ndaardi mo mballa, wii: ");
INSERT INTO ffm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Moobbo, golloowo am ana lelii cuuɗi, sellaa faa junngo yahataa koyngal warataa, ana naawa sanne! ");
INSERT INTO ffm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iisaa wii mo: —Mi yahan mi sellinoya mo. ");
INSERT INTO ffm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kaa hooreejo sordaasi'en oo jaabii, wii: —Moobbo, miin, mi wanaa fay huunde, fotaa ko ngaraa galle am. Ndennoo daɲa ko kaal-ɗaa tan, golloowo am oo sellan. ");
INSERT INTO ffm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Miin e hoore am mi laamaaɗo, miin duu miɗo laamii sordaasi'en. So mi yamirii gooto yaha, yahan, so mi wii goɗɗo wara, waran, so mi wii golloowo am waɗa huunde, waɗan. ");
INSERT INTO ffm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nde Iisaa hettindii mo ndee, haaynaa e makko sanne, wii jokkuɓe e mum ɓee: —Miɗo haalana on goonga, mi yiyaali hono ngal goonɗinal e sellude fay e Israa'iilanke. ");
INSERT INTO ffm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Miɗo haalana on, heewɓe iwrata funnaange e hiirnaange, njooɗodoo e Ibarahiima e Isiyaaka e Yaakuuba, ɓe ɲaamda ley Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kaa jogoraaɓe naatooɓe e Laamu oo ɓee, mbedete ley nimre wonnde sella ndee, ton ɓe mboyata ɓe ŋerƴondira ɲiiƴe. ");
INSERT INTO ffm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Caggal ɗum, o wii hooreejo sordaasi'en oo: —Hootu galle maa! Yo laatane no ngoonɗinir-ɗaa nii. E oon wakkati jaati, golloowo hooreejo sordaasi'en oo sellinaa. ");
INSERT INTO ffm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Iisaa yehi galle Piyeer, tawi esii Piyeer debbo ana lelii yo jontaaɗo. ");
INSERT INTO ffm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Iisaa memi junngo makko, jontere makko selli, oon immii laatanii mo njaatigi. ");
INSERT INTO ffm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nde hiirnoo ndee, Iisaa waddanaa yimɓe heewɓe ɓe ladde woni e mum'en. Konngol makko tan o ribbiri laddeeji gonɗi e maɓɓe ɗii, o sellini ɲawɓe ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","O waɗi non faa ɗum tabintina haala ka Laamɗo yottiniri annabi Esaaya kaa nde oon wii: «O ittii tampere meeɗen, o sellinii ɲawuuji meeɗen.» ");
INSERT INTO ffm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nde o yii jamaa oo ana filii mo ndee, o yamiri o lummbinee. ");
INSERT INTO ffm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Dunkee Sariya gooto ɓattii, wii mo: —Moobbo, mi jokkete ɗo njahataa fuu. ");
INSERT INTO ffm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","O wii oon: —Doldolɗe ana njogii gayɗe, pooli duu ana njogii cuuɗi, kaa Ɓii Neɗɗo oo walaa fay ɗo soppinoo sako faa lelna hoore mum fowtinoo. ");
INSERT INTO ffm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Goɗɗo jeyaaɗo e taalibaaɓe ɓee wii mo: —Moobbo, accu mi iroya baabam tafon. ");
INSERT INTO ffm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","O jaabii oon, o wii: —Jokkam, ɗal maayɓe ira maayɓe mum'en. ");
INSERT INTO ffm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","O naati laana, taalibaaɓe makko njokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ɗon e ɗon, ƴiiwoonde immodii e henndu mawndu e weendu nduu faa bempeeje ana cudda laana kaa, tawi kanko omo ɗaanii. ");
INSERT INTO ffm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Taalibaaɓe ɓee ɓattii mo, pinndini mo, mbii mo: —Moobbo, danndu min! Miɗen nii kalkoo! ");
INSERT INTO ffm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","O jaabii ɓe, o wii: —Ko hulɓinta on? Onon famɗuɓe hoolaare! E oon wakkati, o immii, o jahii e henndu nduu e ndiyam weendu ɗam. Non fuu wii teen! ");
INSERT INTO ffm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Haaynii ɓe, eɓe mbiya: —Gorko homo sifa mum wa'i nii, fay kenuuli e ndiyam ana ɗowtanoo ɗum? ");
INSERT INTO ffm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nde Iisaa lummbunoo so heetti e leydi Gadaren ndee, worɓe ɗiɗon laddaaɓe njalti ley janaale, kawri e makko. Eɓe ɲanngunoo faa fay gooto suusaano ƴaɓɓoraade laawol ngol. ");
INSERT INTO ffm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ɓe ndarii eɓe nduka eɓe mbiya: —Ɓii Laamɗo, ko njiɗ-ɗaa waɗude min? Torrude min waddu maa ɗoo, gila wakkati cartaaɗo oo yottaaki naa? ");
INSERT INTO ffm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Sewre girooji mawnde ana durannoo sera ɗon. ");
INSERT INTO ffm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Seyɗaani'en ɓee ndaardi mo mbii: —So ribbude min njiɗ-ɗaa, duŋana min min naatoya e ndee ɗoo sewre girooji. ");
INSERT INTO ffm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","O wii ɓe: —Njehee! Seyɗaani'en ɓee njalti, naatoyi e girooji ɗii. Ɗon e ɗon, sewre ndee fuu diiri iwi hoore waamnde haayre too, sumpitii ley weendu nduu, yoolii. ");
INSERT INTO ffm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Durooɓe ɓee ndogi kooti ngeenndi too, njantoyii ko waɗi koo fuu fay ko laddaaɓe ɓee koo. ");
INSERT INTO ffm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Oon wakkati, yimɓe ngeenndi ɓee fuu njehi hawritoyde e Iisaa. Nde ɓe njii mo ndee, ɓe ndaardi mo o yalta leydi maɓɓe ndii. ");
INSERT INTO ffm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iisaa naati laana, lummbiti, warti ngeenndi mum. ");
INSERT INTO ffm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","O waddanaa bonnguujo ana lelnaa e dengeleewo. Nde o yii goonɗinal yimɓe ɓee ndee, o wii bonnguujo oo: —Giɗam, seya! Luutti maa njaafaama! ");
INSERT INTO ffm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","E oon wakkati, dunkee'en Sariya yogaaɓe miili e ko'e mum'en: «Oo gorko ana bonkoo Laamɗo!» ");
INSERT INTO ffm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","O faami miilooji maɓɓe, o wii: —Koɗum waɗi so oɗon miiloo ɗii miilooji bonɗi e ɓerɗe mooɗon? ");
INSERT INTO ffm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wiide «Luutti maa njaafaama» e wiide «Imma yaa», koɗum hen ɓuri newaade? ");
INSERT INTO ffm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kaa, faa mi anndina on Ɓii Neɗɗo ana jogii baawɗe e aduna oo yaafaade luutti… Nden, o wii bonnguujo oo: —Imma, ɓam dengeleewo maa, kootaa suudu maa! ");
INSERT INTO ffm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gorko oo immii, hooti suudu mum. ");
INSERT INTO ffm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nde yimɓe ɓee njii ɗum ndee, kuli, ndarii ana njetta Laamɗo saabe ko hokki ɓii-aadama baawɗe baaɗe nii koo. ");
INSERT INTO ffm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iisaa iwi ɗon, ana e laawol. O yii gorko biyeteeɗo Matta ana jooɗii e duwaaɲeere mum, o wii ɗum: —Jokku e am. Matta immii, jokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Caggal ɗum, o wari omo ɲaama ley galle Matta. Duwaaɲe'en heewɓe e luuttooɓe hono mum'en ngari njooɗii ana ɲaamda e makko kanko e taalibaaɓe makko. ");
INSERT INTO ffm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisa'en ɓee njii ɗum, ndarii ana mbiya taalibaaɓe makko ɓee: —Ko saabii so moobbo mooɗon ana ɲaamda e duwaaɲe'en, kaɲum e luuttooɓe hono mum'en? ");
INSERT INTO ffm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","O nani ɗum, o wii ɓe: —Wanaa celluɗo hasindini e cawroowo, ɲawɗo hasindini e cawroowo. ");
INSERT INTO ffm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Njehee njanngoyee ko winndaa ley Dewtere Seniinde koo. Laamɗo wii: «Yurmeende woni ko njiɗu-mi, wanaa sadaka duppeteeɗo.» Sabi wanaa noddude fooccitiiɓe waddi kam, noddude luuttooɓe woni ko waddi kam. ");
INSERT INTO ffm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","E oon wakkati, taalibaaɓe Yaayaa ɓattii Iisaa, lamndii mo ɗum ɗoo: —Ko saabii so minen e Farisa'en ɓee miɗen koora kaa taalibaaɓe maa ɓee koorataa? ");
INSERT INTO ffm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","O jaabii ɓe, o wii: —Tama nootiiɓe kuurtungu ana mbaawi ŋoornaade so jommbaajo gorko ana wondi e mum'en? Kaa ɲalaaɗe ngaran ɗe jommbaajo gorko oo ittetee e hakkunde maɓɓe. E ɗeen ɲalaaɗe, ɓe kooran. ");
INSERT INTO ffm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Fay gooto ɗammbataa fetalaare heyre e kaddungal kiinngal, sabi fetalaare heyre ndee daamtan kaddungal kiinngal ngal, ceekol ngol ɓeydoo. ");
INSERT INTO ffm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kasen duu peguujam kesam loowataake e sumalleeji kiiɗɗi. So ɗum waɗii, sumalleeji ɗii pusan, peguujam ɗam yuppoo, sumalleeji ɗii mbona. Haya peguujam kesam e sumalleeji kesi loowetee, yalla ɗum fuu eɗum reenoo. ");
INSERT INTO ffm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nde Iisaa woni e haalde ɗum ndee, hooreejo suudu waajordu gooto yottii, diccii yeeso mum, wii: —Ɓiyam debbo hedditaaki jooni temmbu. Kaa war faw junngo maa e makko, o wuurtan. ");
INSERT INTO ffm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iisaa immii jokki e makko, kaɲum e taalibaaɓe mum. ");
INSERT INTO ffm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Eɓe e laawol, debbo gooto mo tuundi mum taƴataa ko waarata e duuɓi sappo e ɗiɗi, iwri caggal Iisaa, memi kommbol saaya makko. ");
INSERT INTO ffm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sabi o miilii e becce makko: «So mi heɓii memde saaya makko tan, mi sellan.» ");
INSERT INTO ffm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Iisaa yeeccitii, yii mo, wii: —Banndam debbo, seya! Goonɗinal maa danndii ma. Oon wakkati fuu, debbo oo selli. ");
INSERT INTO ffm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iisaa yottii galle hooreejo waajordu oo, non o yii fiyooɓe cereeli wonɓe to maayde too ɓee e yimɓe woyooɓe ɓee, ");
INSERT INTO ffm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","o wii: —Immee ɗoo, sabi suka debbo oo maayaali, o ɗaaniiɗo tan. Ɓe njali mo. ");
INSERT INTO ffm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nde yimɓe ɓee njaltinaa sella ndee, o naati ley suudu nduu, o nanngi junngo suka debbo oo, nii immii. ");
INSERT INTO ffm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Oon kabaaru saakii e leydi ndii fuu. ");
INSERT INTO ffm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nde Iisaa yahata ndee, wumɓe ɗiɗon njokki e mum ana ngulla ana mbiya: —Taanii Daawuuda, yurma min! ");
INSERT INTO ffm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nde o yottii cuuɗi ndee, wumɓe ɓee ɓattii mo, o lamndii ɗum'en, o wii: —Oɗon ngoonɗini miɗo waawi wallude on? Ɓe njaabii mo, ɓe mbii: —Moobbo, miɗen ngoonɗini. ");
INSERT INTO ffm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","E oon wakkati, o memi gite maɓɓe, o wii: —Yo laatano on no ngoonɗinir-ɗon nii. ");
INSERT INTO ffm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ɗon e ɗon ɓe mbumti. O yaggini ɓe, o wii ɓe: —Pati kaalanee ɗum fay gooto. ");
INSERT INTO ffm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kaa ɓe njehi tan ɓe caaki kabaaru makko e leydi ndii fuu. ");
INSERT INTO ffm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nde wumtinaaɓe ɓee njaltunoo ndee, Iisaa waddanaa kasen gorko mo seyɗaani muumɗini. ");
INSERT INTO ffm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","O ribbi seyɗaani oo tan, muumɗunooɗo oo watti haalde. Jamaa oo fuu haaynaa, ana wiya: —Hono ɗum yiyaaka e Israa'iila abada! ");
INSERT INTO ffm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kaa Farisa'en ɓee mbii: —Hooreejo seyɗaani'en oo hokki mo baawɗe ribbude seyɗaani'en ɓee! ");
INSERT INTO ffm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iisaa ana yiiloo e geelle e gure fuu, ana waajoo e ley cuuɗi baajorɗi, ana ooynoo Kabaaru Lobbo haala Laamu Laamɗo oo, omo sellina ɲawuuji e ellaaji fuu. ");
INSERT INTO ffm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nde o yii yimɓe ɓee ndee, ɓe njurminii mo, sabi ɓe tampuɓe ɓe taƴuɓe dimme hono baali ɗi ngalaa duroowo nii. ");
INSERT INTO ffm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Oon wakkati, o wii taalibaaɓe makko ɓee: —Gese ɓennduɗe ana keewi, kaa hettooɓe keewaa. ");
INSERT INTO ffm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ndennoo, ɲaagee Jom kettal oo nelda hettooɓe to hettantee too. ");
INSERT INTO ffm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Iisaa noddi taalibaaɓe mum sappo e ɗiɗon ɓee, o hokki ɓe baawɗe ribbugol seyɗaani'en e sellingol sii ɲawuuji e ellaaji fuu. ");
INSERT INTO ffm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Inɗe nelaaɓe sappo e ɗiɗon ɓee annii: arano e maɓɓe yo Simon noddirteeɗo Piyeer e Andire miɲum, Yaakuuba ɓii Jebede e Yuhanna miɲum, ");
INSERT INTO ffm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipa e Bartolome, Tomaa e Matta duwaaɲe oo, Yaakuuba ɓii Alfaa, kaɲum e Tadde, ");
INSERT INTO ffm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon kiranoowo suudu baaba e Yahuuda Isikariyota jammbotooɗo mo oo. ");
INSERT INTO ffm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iisaa neli ɓeen sappo e ɗiɗon, o wii ɓe: —Pati njehee e leyɗe ɗe Yahuudiyankooɓe ngalaa e mum ɗee, kasen duu pati naatee e geelle Samariya. ");
INSERT INTO ffm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","To baali suudu Israa'iila majjuɗi ɗii kaan-ɗon yaade. ");
INSERT INTO ffm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","To njahaton fuu, ooynee mbiyon «Laamu Laamɗo ɓattiima!» ");
INSERT INTO ffm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Cellinon ɲawɓe, nguurtinon maayɓe, cellinon seppaaɓe, ndibbon seyɗaani'en. On keɓirii nii tan, ndokkiree nii tan. ");
INSERT INTO ffm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Pati naɓoree kaŋŋe naa cardi naa mbuuɗu jakawalle e njiibaaji mooɗon. ");
INSERT INTO ffm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pati fay gooto e mooɗon naɓora mbasu naa saayaaji ɗiɗi. Pati fay gooto e mooɗon ɓama paɗe naa sawru. Sabi golloowo ana haandi e nguure. ");
INSERT INTO ffm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","So tawii on ngarii e ngeenndi naa wuro, tewtee njaatigi lobbo, kasen keddee njaatigi mon ɗoo faa nde iw-ɗon ɗon. ");
INSERT INTO ffm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","So oɗon naata e galle, calminon. ");
INSERT INTO ffm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","So galle oo ana haandi hen, yo jam mon yotto mo. Kaa so mo haandaa hen, yo jam mon wartu e mon. ");
INSERT INTO ffm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","So won galle naa ngeenndi ɗo on njaɓɓaaka naa on kettindaaka, njaltee nokku oo, piɗɗon colla koyɗe mon duu. ");
INSERT INTO ffm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Miɗo haalana on goonga: ɲannde darngal, jukkungo ndiin ngeenndi ɓuran ngo geelle Sodooma e Gomoora ngoo naawde. ");
INSERT INTO ffm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Kettindee! Mi nelii on no baali hakkunde pobbi nii. Ndennoo, ƴoƴiree no boje nii, neworee no buugaaji nii. ");
INSERT INTO ffm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ndeento-ɗon e yimɓe ɓee, sabi ɓe ndarnan on e carirɗe, ɓe piyan on dorri ley cuuɗi maɓɓe baajorɗi. ");
INSERT INTO ffm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","On naɓete yeeso sarooɓe e kaanankooɓe saabe am, faa laatano-ɗon kam seedee'en yeeso maɓɓe kamɓe e heeferɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","So on ndarnaama e sarirde, pati mbemmbe-ɗon no kaaldaton naa ko kaalaton. Sabi on ndokkete konngi ɗi kaan-ɗon haalde e oon wakkati, ");
INSERT INTO ffm_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ɗi iwataa e mooɗon, ko selli hen dee, RuuhuBaabiraaɗo mooɗon oo haalata ley mooɗon. ");
INSERT INTO ffm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Neɗɗo hokkitiran sakiike mum waree, baabiraaɗo duu ɓiyum. Ɓiɓɓe immanto saaraaɓe mum'en, piya dabare yalla ɓeen ana mbaree. ");
INSERT INTO ffm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yimɓe fuu mbaɲan on saabe am. Kaa muɲuɗo faa timmooɗe, joomum hisinte. ");
INSERT INTO ffm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","So on torraama e ngeenndi ngootiri, ndoganee ngonndi. Miɗo haalana on goonga: on piltidataako geelle Israa'iila ɗee fuu tawa Ɓii Neɗɗo wartaali. ");
INSERT INTO ffm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Taalibbo ɓuraa moobbo mum, maccuɗo ɓuraa kalfaaɗo mum. ");
INSERT INTO ffm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ana yiɗaa taalibbo wuurda no moobbo mum wuurdi fuu, maccuɗo duu no kalfaaɗo mum wuurdi. Miin duu, mi noddiraama «Beelsebul» (hooreejo seyɗaani'en), wanaa haala mon onon. ");
INSERT INTO ffm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Ndennoo, pati kulee yimɓe. Walaa fuu ko suuɗii ko ɓanngintaake, walaa sirri mo saakataake. ");
INSERT INTO ffm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ko kaalan-mi on e nimre koo, kaaltee ɗum e fooyre. Ko ngunndante-ɗon koo, ooynee ɗum dow beneeji. ");
INSERT INTO ffm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Pati kulee warooɓe terɗe, ɓe mbaawanaa yonkiiji. Laamɗo baawɗo halkude terɗe e yonkiiji fuu e jahannama, oo kaan-ɗon hulde. ");
INSERT INTO ffm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Tama biiwuuji ɗiɗi coottataake mbuuɗu? Kaa fay gootel e majji yanataa e leydi tawa wanaa e sago Baabiraaɗo mooɗon oo. ");
INSERT INTO ffm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Onon, fay leeɓi ko'e mon fuu ko limaa. ");
INSERT INTO ffm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ndennoo, pati kulee, sabi onon ɓuri biiwuuji keewɗi teentilaade. ");
INSERT INTO ffm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Neɗɗo fuu ceettaniiɗo kam yeeso yimɓe, miin duu, mi seettanto ɗum yeeso Baabiraaɗo am gonɗo dow kammu oo. ");
INSERT INTO ffm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kaa calaniiɗo kam hakkunde yimɓe fuu, miin duu, mi salanto ɗum yeeso Baabiraaɗo am gonɗo dow kammu oo. ");
INSERT INTO ffm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Pati miilee jam ngardu-mi e leydi ndii. Mi wardaali e jam, kaafaawi ngardu-mi. ");
INSERT INTO ffm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ko waddi kam dee, seenndude ɓiɗɗo gorko e baam mum, ɓiɗɗo debbo e inna mum, debbo ɓamaaɗo e esum debbo. ");
INSERT INTO ffm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Neɗɗo fuu koreeji mum laatotoo wayɓe mum. ");
INSERT INTO ffm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Korsinɗo inna mum naa baam mum faa ɓuri kam fuu, wanaa potuɗo laataade taalibbo am. Korsinɗo ɓiyum gorko naa debbo faa ɓuri kam fuu, wanaa potuɗo laataade taalibbo am. ");
INSERT INTO ffm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mo ɓamaali leggal mum bardugal, jokka e am fuu, wanaa potuɗo laataade taalibbo am. ");
INSERT INTO ffm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tewtuɗo reenude yonki mum fuu, waasan ki, kaa baasirɗo ki sabaabu am, hewtan ki. ");
INSERT INTO ffm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Jaɓɓiiɗo on fuu jaɓɓiima kam, jaɓɓiiɗo kam fuu jaɓɓiima nelɗo kam oo. ");
INSERT INTO ffm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jaɓɓiiɗo annabaajo saabe o annabaajo fuu, heɓan mbarjaari ndi annabaajo fodanaa ndii. Jaɓɓiiɗo neɗɗo pooccitiiɗo saabe o pooccitiiɗo fuu, heɓan mbarjaari ndi pooccitiiɗo fodanaa ndii. ");
INSERT INTO ffm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Miɗo haalana on goonga: neɗɗo fuu dokkuɗo ɓurɗo famɗude e taalibaaɓe am ɓee fay so horde loonde ndiyam ɓuuɓuɗam tan saabe o taalibbo am, o waasataa heɓude mbarjaari makko. ");
INSERT INTO ffm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nde Iisaa tilii yamirde taalibaaɓe mum sappo e ɗiɗon ɓee ndee, iwi ɗon, yehi jannginoyde e waajoyaade ley geelle piliiɗe ɗee. ");
INSERT INTO ffm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yaayaa ana ley kasu. O nani golleeji Almasiihu oo ana njantee, o neli taalibaaɓe makko ɓee, ");
INSERT INTO ffm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","faa lamndoo Iisaa: —Aan woni kaanɗo warde oo, naa min ndooman goɗɗo? ");
INSERT INTO ffm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iisaa jaabii ɓe, wii: —Njehee, njantanoyee Yaayaa ko nan-ɗon e ko njii-ɗon fuu: ");
INSERT INTO ffm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","wumɓe ana mbumta, laƴannooɓe ana njaɓɓa faa gasa, seppaaɓe ana cellinee, faaɗuɓe ana paaɗita, maayɓe ana nguurta, misikiina'en duu kaalanaama Kabaaru Lobbo oo. ");
INSERT INTO ffm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Oon mo salaaki goonɗinde kam, welii hoore. ");
INSERT INTO ffm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nde nelaaɓe Yaayaa ɓee njahata ndee, Iisaa fuɗɗi haalande jamaa oo haala Yaayaa, o wii: —Koɗum ƴeewoyno-ɗon to ladde jeereende too? Kuɗol dimmbotoongol e henndu naa? ");
INSERT INTO ffm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ndennoo, koɗum ƴeewoyno-ɗon? Gorko pariiɗo naa? Pariiɓe e galleeji kaanankooɓe tawetee. ");
INSERT INTO ffm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ndennoo, koɗum ƴeewoyno-ɗon? Annabaajo naa? Goonga! Miɗo haalana on, omo ɓuri annabaajo. ");
INSERT INTO ffm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Kanko woni mo Binndi ɗii cappii oo: «Miin Laamɗo, mi ardinante nelaaɗo am moƴƴinanoowo ma laawol.» ");
INSERT INTO ffm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Miɗo haalana on goonga: bammbaade bammbaali ɓurɗo Yaayaa mo lootogal batisima oo, tawee nee, ɓurɗo lo'ude e Laamu Laamɗo oo ɓuri mo teddude. ");
INSERT INTO ffm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Gila Yaayaa mo lootogal batisima fuɗɗi waajaade, Laamu Laamɗo ana ruggoree semmbe, ruggotooɓe ɓee ana ndaara teetude mo. ");
INSERT INTO ffm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Annabaaɓe ɓee fuu kaɲum e Tawreeta Muusaa cappike Laamu oo faa e jamaanu Yaayaa. ");
INSERT INTO ffm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","So oɗon njaɓa haala maɓɓe, Yaayaa woni annabi Iliyaasa mo garol mum sappaa oo. ");
INSERT INTO ffm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jom nowru fuu yo nanu. ");
INSERT INTO ffm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Koɗum mbaaw-mi nanndinde e yimɓe oo jamaanu? Eɓe nanndi e sukaaɓe jooɗiiɓe e luumooji, ɓee ɗoo ana mbiya ɓee too: ");
INSERT INTO ffm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","«Min piyanii on cereeli, on mbamaali, min mboyanii on woondu yurminiindu, on ɗusaali.» ");
INSERT INTO ffm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sabi Yaayaa warii, o kooroowo, o yarataa doro, wiyaama o laddaaɗo. ");
INSERT INTO ffm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ɓii Neɗɗo oo duu warii ana ɲaama, ana yara, yimɓe mbii ɗum: «Ɲaamde e yarde tan woni e hakkille mum, o giɗo duwaaɲe'en e luuttooɓe hono mum'en!» Kaa hakkilantaaku Laamɗo ana ɓanngina goonga muuɗum ley golleeji muuɗum. ");
INSERT INTO ffm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Caggal ɗum, Iisaa fuɗɗi felde geelle ɗe o ɓuri waɗude e mum kaayɗe ɗee, sabi hoɗuɓe e ɗeen geelle ɓee tuubaali. O wii: ");
INSERT INTO ffm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Bone woodanii ma, aan Korasin! Bone woodanii ma, aan Baytisayda! Sabi so kaayɗe gaɗanooɗe e ley mooɗon ɗee ngaɗanooma Tirus e Sidon, nden, hoɗuɓe ton ɓee tuubanno law, tawete ɓe ɓoornike licce caakuuji, ɓe njooɗike e ndoondi faa ɓe kollita tuubugol maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Saabe ɗum, miɗo wiya on: ɲannde darngal, jukkungo mon ɓuran ngo Tirus e Sidon ngoo naawde. ");
INSERT INTO ffm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aan duu Kafarnahum, aɗa miila a toownete faa dow kammu naa? A leyɗinte faa keedaa ley maayɓe. Sabi so kaayɗe gaɗanooɗe e maa ɗee ngaɗanooma Sodooma, nden, ndiin ngeenndi heddotono faa jooni. ");
INSERT INTO ffm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Saabe ɗum, miɗo wiya on: ɲannde darngal, jukkungo mon ɓuran ngo Sodooma ngoo naawde. ");
INSERT INTO ffm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Oon wakkati fuu, Iisaa wii: —Baabiraaɗo jom kammu e leydi, mi yettii ma, sabi a suuɗii ɗee kulle hakkilanteeɓe, kaɲum e annduɓe, ɓannginan-ɗaa ɗum cukaloy. ");
INSERT INTO ffm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jaati Baabiraaɗo, hono non worri sabi ɗum wel maa. ");
INSERT INTO ffm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Baabiraaɗo am tummbii huunde fuu e junngo am. Fay gooto anndaa Bajjo oo so wanaa Baabiraaɗo oo, fay gooto anndaa Baabiraaɗo oo so wanaa Bajjo oo, kaɲum e mo Bajjo oo muuyi ɓannginande ɗum fuu. ");
INSERT INTO ffm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Onon yimɓe tampuɓe roondaade donnge tedduɗe, on fuu ngaree e am, mi fowtinan on. ");
INSERT INTO ffm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ɗalee mi fawa tekkere am e dow mon, accon mi janngina on, sabi miɗo sawrii, miɗo leyɗinkinii, on tawan hen fowtere yonkiiji mooɗon. ");
INSERT INTO ffm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sabi tekkere am ana yaafi roondaade, donngal am ana huyfi. ");
INSERT INTO ffm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Oon wakkati, Iisaa e taalibaaɓe mum ana ceeka gese ley ɲalaande fowteteende. Taalibaaɓe makko njolbi, ana kelta butaali ana ƴakka. ");
INSERT INTO ffm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nde Farisa'en ɓee njii ɗum ndee, ndarii ana mbiya mo: —Ƴeew, taalibaaɓe maa ɓee ana ngolla ko dagaaki gollude ɲalaande fowteteende! ");
INSERT INTO ffm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","O jaabii ɓe, o wii: —Tama on njanngaali ko Daawuuda waɗi nde yolbunoo, kaɲum e yimɓe mum? ");
INSERT INTO ffm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","O naati e ley hukkum ceniiɗo oo, kanko e yimɓe makko, ɓe ɲaami buuru cakkaaɗo oo. Haya, ɓe nduŋanaaka ɲaamde mo, yottinooɓe sadaka tan njey ɲaamde mo. ");
INSERT INTO ffm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Naa duu, on njanngaali e ley Tawreeta Muusaa, nde wonnoo yottinooɓe sadaka ɓee ana ngolla ley Suudu Dewal Mawndu nduu fay ɲalaande fowteteende? Kamɓe nee, eɓe comna ɲalaande fowteteende ndee, kaa ɗum felataa ɓe. ");
INSERT INTO ffm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Miɗo wiya on: ko ɓuri Suudu Dewal Mawndu ana ɗoo. ");
INSERT INTO ffm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Sinndo oɗon anndunoo ko kaa haala Laamɗo firritata: «Yurmeende woni ko njiɗu-mi, wanaa sadaka duppeteeɗo», on carataano ɓee laaɓuɓe. ");
INSERT INTO ffm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sabi Ɓii Neɗɗo oo jey ɲalaande fowteteende ndee. ");
INSERT INTO ffm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iisaa iwi ɗon naatoyi suudu maɓɓe waajordu. ");
INSERT INTO ffm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Gorko mo junngo mum waati ana wonnoo ɗon. Wonnooɓe ɗon ɓee tuufani Iisaa yalla ana keɓa no kappira ɗum. Saabe ɗum, ɓe lamndii mo ɗum ɗoo: —Sariya meeɗen oo hokkii en sellinde neɗɗo ɲalaande fowteteende naa? ");
INSERT INTO ffm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","O jaabii ɓe, o wii: —So won e mon jogiiɗo mbaalu, so oon mbaalu saamii e luggere ɲalaande fowteteende, wanaa joomum yaltinoyan mo naa? ");
INSERT INTO ffm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Oɗon anndi neɗɗo ana ɓuri mbaalu ɗo woɗɗi! Ndennoo, ana dagoo waɗande neɗɗo ko moƴƴi ɲalaande fowteteende. ");
INSERT INTO ffm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Caggal ɗum, o wii gorko oo: —Fooccu junngo maa! Oon foocci ngo tan, ngo selli faa ngo warti hono no wonngo ngoo nii. ");
INSERT INTO ffm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisa'en ɓee njalti, njooɗoyii faa ndawrida no mbarda Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Nde Iisaa nani ɗum ndee, iwi e oon nokku, yimɓe heewɓe njokki e makko. O sellini ɲawɓe ɓee fuu, ");
INSERT INTO ffm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","o daalii ɓeen pati kumpita fay gooto kabaaru makko. ");
INSERT INTO ffm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɗum waɗirii non yalla haala ka Laamɗo yottinirnoo annabi Esaaya kaa ana tabita nde oon wii: ");
INSERT INTO ffm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Annii kaadime am mo cuɓii-mi. Kanko korsin-mi, kanko welni ɓernde am. Mi jippinan e makko Ruuhu am, o ooynanto leɲi ɗii laawol fooccitaare. ");
INSERT INTO ffm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","O falondirtaake, o dukataa, daande makko nanataake e mbeddaaji. ");
INSERT INTO ffm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","O helataa kuɗol ooɲiingol, o ɲifataa moottila mo pooyel mum famɗi faa ɲannde o hokki fooccitaare jaalogal. ");
INSERT INTO ffm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Leɲi ɗii fuu pawan jikke mum'en e makko.» ");
INSERT INTO ffm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nden, Iisaa waddanaa gorko bumɗo muumo, sabi oon yo laddaaɗo. O sellini ɗum faa watti haalde e yiide. ");
INSERT INTO ffm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Haaynii yimɓe ɓee fuu, ndarii ana mbiya: —Ɗum nee, taanii Daawuuda oo woni ɗoo naa? ");
INSERT INTO ffm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kaa nde Farisa'en ɓee nani ɗum ndee, mbii: —E baawɗe «Beelsebul» hooreejo seyɗaani'en o ribbirta seyɗaani'en ɓee. ");
INSERT INTO ffm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Nde wonnoo Iisaa anndii miilooji maɓɓe, o wii ɓe: —Laamu fuu pecciiɗo ana haɓa e hoore mum, bonan. Ngeenndi naa galle fuu pecciiɗo ana haɓa e hoore mum, heddataako. ");
INSERT INTO ffm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","So Ibiliisa ribbii seyɗaani'en mum, feccii hoore mum. Ndennoo, hono laamu mum heddortoo? ");
INSERT INTO ffm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","So tawii «Beelsebul» ndibbiran-mi seyɗaani'en, yimɓe mon ɓee nee, homo ndibbirta ɓe? Yimɓe mon ɓee jaati kollata on ngalaa e goonga! ");
INSERT INTO ffm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kaa so Ruuhu Laamɗo ndibbiran-mi seyɗaani'en, ɗum ana holla Laamu Laamɗo warii e mon. ");
INSERT INTO ffm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Iisaa ɓeydi hen, wii: —Fay gooto waawaa naatude e galle gorko jom semmbe teeta jawdi mum tawee haɓɓaali joomum tafon. Kaa so haɓɓii joomum faa teeŋii, ana waawi naɓude ko woni e galle mum fuu. ");
INSERT INTO ffm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mo waldaa e am fuu yo gaɲo am. Mo mooɓtidataa e am fuu yo caakoowo. ");
INSERT INTO ffm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Saabe ɗum, miɗo wiya on: yimɓe ana mbaawi yaafeede luutti mum'en fuu, kaɲum e bonkaaji fuu. Kaa bonkiiɗo Ruuhu Ceniiɗo oo yaafataake. ");
INSERT INTO ffm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Neɗɗo fuu kaalɗo ko boni e Ɓii Neɗɗo, ana waawi yaafeede, kaa neɗɗo fuu kaalɗo ko boni e Ruuhu Ceniiɗo, yaafataake jooni, yaafataake wakkati garoyoowo. ");
INSERT INTO ffm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—So lekki ana moƴƴi, ɓiɗɗe mum moƴƴan, so lekki moƴƴaa, ɓiɗɗe mum moƴƴataa, sabi lekki ɓiɗɗe mum annditirtee. ");
INSERT INTO ffm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɓiɓɓe bolle bonɗe! Hono hen mbaawirton haalde ko moƴƴi tawee on bonɓe? Sabi ko woni e ɓernde, ɗum yaltata e hunduko. ");
INSERT INTO ffm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Neɗɗo moƴƴo, ko moƴƴi iwata e ndesaari ngonndi ley ɓernde mum. Neɗɗo bonɗo, ko boni iwata e ndesaari ngonndi ley ɓernde mum. ");
INSERT INTO ffm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Miɗo wiya on: ɲannde darngal yimɓe kaaltan haalaaji laaliiɗi ɗi kaalnoo fuu. ");
INSERT INTO ffm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Sabi neɗɗo haalaaji mum sarirtee pooccitiiɗo naa jukketeeɗo. ");
INSERT INTO ffm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Caggal ɗum, yoga e dunkee'en Sariya, kaɲum e Farisa'en mbii Iisaa: —Moobbo, miɗen njiɗi kollaa min taagumansa Laamɗo nel maa. ");
INSERT INTO ffm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","O jaabii ɓe, o wii: —Jamaanu jooni bonɗo coɓuɗo oo ana ndaara holleede taagumansa, kaa taagumansa fuu o hollataake so wanaa taagumansa annabi Yuunusa oo. ");
INSERT INTO ffm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sabi, no Yuunusa waɗiri balɗe tati jemma e ɲalooma ley reedu liingu mawɗo oo nii, hono non Ɓii Neɗɗo waɗirta balɗe tati jemma e ɲalooma ley yanaande. ");
INSERT INTO ffm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ɲannde darngal, worɓe Niniwe immodoto e yimɓe jamaanu jooni ɓee, liɓa ɗum'en. Sabi worɓe Niniwe tuubii nde nannoo waaju Yuunusa oo ndee. Haya, ɓurɗo Yuunusa ana ɗoo! ");
INSERT INTO ffm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ɲannde darngal, kaananke debbo leydi ɓaleeri oo immodoto e yimɓe jamaanu jooni ɓee, liɓa ɗum'en. Sabi o iwriino faa hoore leydi, warde hettindaade haalaaji Suleymaana kebbinaaɗi hakkilantaaku ɗii. Haya, ɓurɗo Suleymaana ana ɗoo! ");
INSERT INTO ffm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—So seyɗaani yaltii e neɗɗo, seyɗaani oo yiiloyto e nokkuuje joorɗe tewta ɗo ŋoottinoo, kaa ŋoottere fuu o heɓataa. ");
INSERT INTO ffm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nden kaa, o wiya: «Miɗo nii wirfitoo galle am mo eggunoo-mi e mum oo.» So o wirfitike, o tawan galle oo yo ɓolo, ana wuuwaa, ana moƴƴinaa faa wooɗi. ");
INSERT INTO ffm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nden, o wirfitoo, o waddoya seyɗaani'en njeɗɗon woɓɓe ɓurɓe mo bonde. Ɓe naata e galle oo, ɓe koɗa e mum. Nii battane oo neɗɗo ɓurdata arannde mum bonde. Nii yimɓe ndee fedde bonnde duu laatoytoo. ");
INSERT INTO ffm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nde Iisaa haaldannoo e jamaa oo ndee, inna makko e miɲiraaɓe makko worɓe njottii. Ɓe ndarii sella, eɓe njiɗi yiide mo. ");
INSERT INTO ffm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Won biiɗo mo: —Inna maa e miɲiraaɓe maa ana ndarii sella ana njiɗi yiide ma. ");
INSERT INTO ffm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","O jaabii oon neɗɗo, o wii ɗum: —Homo woni innam? Hoɓe ngoni miɲiraaɓe am? ");
INSERT INTO ffm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","O sappii taalibaaɓe makko ɓee, o wii: —Innam e miɲiraaɓe am annii. ");
INSERT INTO ffm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sabi miɲam naa innam yo neɗɗo gaɗoowo sago Baabiraaɗo am gonɗo dow kammu oo. ");
INSERT INTO ffm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ley oon ɲalooma, Iisaa yalti cuuɗi, jooɗoyii daande weendu. ");
INSERT INTO ffm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jamaa keewɗo ana filii mo faa o naatoyi laana, o jooɗii ley makka. Yimɓe ɓee ndarii e daande ndiyam ɗam. ");
INSERT INTO ffm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","O haalaniri ɓe kulle keewɗe e banndi. Omo wiya: —Aawoowo yalti aawoyde. ");
INSERT INTO ffm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E ley sankugol ngol, yoga e aawdi ndii saami e laawol, pooli ngari cuɓi ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Yoga mayri saami e korokaaƴe ɗo leydi heewaano, fuɗi ɗon e ɗon sabi aawdi ndii iraaka gasa. ");
INSERT INTO ffm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kaa nde naange wulnoo ndee, sumi, yoori saabe walaa ɗaɗi. ");
INSERT INTO ffm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yoga mayri saami ɗo kebbe puɗata. Ndi fuɗidi e majje, ɗe cuumi ndi. ");
INSERT INTO ffm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yoga mayri saami e leydi lobbiri, fuɗi, rimi: yoga sowii cowe teemedere, yoga capanɗe jeegom, yoga capantati. ");
INSERT INTO ffm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jom nowru fuu yo nanu! ");
INSERT INTO ffm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Oon wakkati, taalibaaɓe ɓee ɓattii Iisaa lamndii mo, mbii: —Koɗum waɗi so aɗa haaldira e maɓɓe banndi? ");
INSERT INTO ffm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","O jaabii ɓe, o wii: —Onon, on ndokkaama faamude goonga tedduɗo haala Laamu Laamɗo oo, kaa kamɓe, ɓe ndokkaaka ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sabi jogiiɗo fuu, ɓeydante faa heewa. Kaa mo walaa oo, fay seeɗa mo jogii oo teetete. ");
INSERT INTO ffm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ɗum saabii so miɗo haaldira e maɓɓe banndi: «Tawee ɓe ƴeewooɓe, ɓe njiyataa, Tawee ɓe hettintooɓe, ɓe nanataa, ɓe paamataa.» ");
INSERT INTO ffm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nii ko Laamɗo waɗunoo e hunduko annabi Esaaya koo tabitiri e maɓɓe: «On kettinto faa palon noppi, kaa on paamataa. On ƴeewan faa puttinon gite, kaa on njiyataa. ");
INSERT INTO ffm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sabi yimɓe ngol leɲol laatike tiiɗuɓe ko'e: Ɓe cukkii noppi maɓɓe, ɓe muɓɓii gite maɓɓe, so wanaa ɗum gite maɓɓe njiyan, noppi maɓɓe nanan, hakkillaaji maɓɓe paaman, ɓe tuuban, mi sellina ɓe.» ");
INSERT INTO ffm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Kaa onon, on mbelii hoore: gite mooɗon ana njiya, noppi mooɗon duu ana nana! ");
INSERT INTO ffm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Miɗo haalana on goonga: annabaaɓe heewɓe e fooccitiiɓe heewɓe muuyiino yiide ko njiyaton koo, ɓe njiyaali. Ɓe muuyiino nande ko nanaton koo, ɓe nanaali. ");
INSERT INTO ffm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Ndennoo, kettinee maanaa banndol aawoowo ngol. ");
INSERT INTO ffm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Neɗɗo fuu nanɗo haala Laamu Laamɗo tawee faamaali ɗum, bonɗo oo waran, ɗoofa ko aawaa e ɓernde mum koo. Kabaaru oo neɗɗo ana nanndi e laawol ɗo aawdi ndii saami ɗoo. ");
INSERT INTO ffm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Kabaaru aawdi saamundi e korokaaƴe ndii, ana nanndi e neɗɗo nanoowo konngol ngol so jaɓɓoroo ngol seyo ɗon e ɗon. ");
INSERT INTO ffm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kaa ngol walaa ɗaɗi e makko, o nanngan ngol wakkati gooto tan. So ɗum ɓillike naa so o torrike saabe konngol ngol, o yankiran ɗon e ɗon. ");
INSERT INTO ffm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Kabaaru aawdi saamundi e kebbe ndii, ana nanndi e neɗɗo nanoowo konngol ngol, so sugullaaji aduna e koomti jawdi cuuma ngol, ngol laatoo dimarol. ");
INSERT INTO ffm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kaa kabaaru aawdi saamundi e leydi mbelndi ndii, ɓeen ngoni nanooɓe konngol ngol so paama ngol. Oon wakkati, ɓe ndiman ɓiɓɓe: yoga teemedere, yoga capanɗe jeegom, yoga capantati. ");
INSERT INTO ffm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iisaa haalani ɓe banndol gonngol, wii: —Hono nii Laamu Laamɗo oo wa'i: gorko aawi e ngesa mum aawdi lobbiri. ");
INSERT INTO ffm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nde yimɓe fuu ɗaaninoo, gaɲo oon gorko wari, aawi huɗo bonko e ley gulle ɗee, witti. ");
INSERT INTO ffm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nde aawdi ndii fuɗi faa rimi, nden huɗo bonko koo duu ɓanngi. ");
INSERT INTO ffm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Maccuɓe ɓee njehi mbiyoyi jom ngesa oo: «Kalfaaɗo, wanaa aawdi lobbiri aawu-ɗaa e ngesa maa ngaa naa? Hoto koo huɗo bonko iwi?» ");
INSERT INTO ffm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","O jaabii ɓe, o wii: «Gaɲo waɗi nii.» Caggal ɗum, maccuɓe ɓee lamndii mo, mbii: «Min njaha min ɗoofoya huɗo bonko koo?» ");
INSERT INTO ffm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","O jaabii ɓe, o wii: «Wanaa non, sabi so oɗon ɗoofa huɗo bonko koo, so on ndeentaaki on ɗoofidan hen alkama oo. ");
INSERT INTO ffm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Accidee ɗi faa kettal. Nden, mi wiyan hettooɓe ɓee ɗoofa huɗo bonko koo tafon, ɓe ngaɗa ɗum kafe faa duppee. So ɓe ngaɗi ɗum fuu, ɓe ketta alkama oo, nden ɓe mooɓta ɗum ley beembal am.» ");
INSERT INTO ffm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iisaa haalani ɓe banndol gonngol, wii: —Laamu Laamɗo oo ana nanndi e ngeeƴu buyaage mo neɗɗo ɓami, so aawi e ngesa mum. ");
INSERT INTO ffm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kanko ɓuri geeƴi fuu famɗude, kaa so mo fuɗii, o laatoto lekki mawki sanne faa pooli ngara ɲiɓa cuuɗi mum'en e caɓe makki. ");
INSERT INTO ffm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","O haalani ɓe banndol gonngol, o wii: —Laamu Laamɗo oo ana wa'i hono no ƴuufinirdi seeɗa ndi debbo jiiɓi e saawal tati conndi alkama faa ndi fuu ndi ƴuufi. ");
INSERT INTO ffm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ɗum fuu, Iisaa haalaniri yimɓe ɓee e banndi. O haaldataa e maɓɓe so wanaa e banndi, ");
INSERT INTO ffm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","yalla haala ka Laamɗo yottinirnoo annabaajo oo kaa ana tabita nde oon wii: «Mi haalaniran ɓe banndi, mi haalanan ɓe kulle cuuɗaaɗe gila nde aduna tagaa.» ");
INSERT INTO ffm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Caggal ɗum, Iisaa yoppiti yimɓe ɓee, naati ley suudu. Taalibaaɓe makko ɓee ɓattii mo, mbii mo: —Firritan min banndol huɗo bonko ngol. ");
INSERT INTO ffm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","O jaabii ɓe, o wii: —Aawɗo aawdi lobbiri ndii oo, oon woni Ɓii Neɗɗo oo, ");
INSERT INTO ffm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ngesa ngaa woni aduna oo. Ɓiɓɓe Laamu Laamɗo ɓee ngoni aawdi lobbiri ndii, ɓiɓɓe bonɗo oo ngoni huɗo bonko koo. ");
INSERT INTO ffm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Gaɲo aawɗo huɗo bonko oo yo Ibiliisa, kettal ngal yo timmooɗe aduna, hettooɓe ɓee yo malaa'ika'en. ");
INSERT INTO ffm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Hono no huɗo bonko ittirtee wedee e yiite nii, non timmooɗe aduna laatortoo. ");
INSERT INTO ffm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ɓii Neɗɗo oo nelan malaa'ika'en mum, itta e laamu mum oo waɗooɓe woɓɓe e luuttal, kaɲum e waɗooɓe ko boni fuu, ");
INSERT INTO ffm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","mbedoo ɗum'en e yiite jahannama, ton ɓe ngullata, ɓe ŋerƴondira ɲiiƴe. ");
INSERT INTO ffm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kaa e oon wakkati, fooccitiiɓe ɓee njalbiran no naange nii e ley Laamu Baabiraaɗo mum'en. Jom nowru fuu, yo nanu! ");
INSERT INTO ffm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Laamu Laamɗo oo ana wa'i hono no jawdi cuuɗiindi e ley ngesa, gorko goɗɗo hoocci ndiin jawdi, suuɗi ndi kasen. E ley seyo makko ngoo, o soottoyi ko o joginoo fuu, o soodi ngesa ngaa. ");
INSERT INTO ffm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Laamu Laamɗo oo ana wa'i kasen hono no julaajo tewtoowo ɲaaƴe dime nii. ");
INSERT INTO ffm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","So joomum yii ɲaayre rimre heewnde coggu, soottan ko jogii fuu sooda ɲaayre ndee. ");
INSERT INTO ffm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Laamu Laamɗo oo ana wa'i kasen hono no bubbol bedaangol e geeci, so nanngi sii liɗɗi fuu nii. ");
INSERT INTO ffm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Faa ngol heewi, summbooɓe ɓee pooɗi ngol faa e daŋŋeere, ana cuɓa liɗɗi ɗii. Ɓe ngaɗi liɗɗi lobbi ɗii e ley cagiije, ɓe mbedii ɗi nafataa fay huunde ɗii. ");
INSERT INTO ffm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Hono non timmooɗe aduna laatortoo. Malaa'ika'en ngaran ceennda bonɓe e moƴƴuɓe, ");
INSERT INTO ffm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","mbedoo bonɓe ɓee e ley yiite jahannama, ton ɓeen ngullata ɓe ŋerƴondira ɲiiƴe. ");
INSERT INTO ffm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iisaa lamndii ɓe, o wii: —On paamii ɗum fuu naa? Ɓe njaabii, ɓe mbii: —Min paamii. ");
INSERT INTO ffm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Caggal ɗum, o wii ɓe: —Jannginoowo Sariya fuu laatiiɗo taalibbo Laamu Laamɗo, ana wa'i hono no jom galle jaltinoowo e ley ndesaari mum kulle kese e kulle ɓooyɗe nii. ");
INSERT INTO ffm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nde Iisaa tilinoo e ɗiin banndi ndee, o iwi ton, ");
INSERT INTO ffm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","o hooti ngeenndi ɗo o mawni ɗoo, omo waajoo e suudu maɓɓe waajordu. Haaynii yimɓe hettintooɓe ɓee sanne, ndarii ana mbiya: —Hoto fuu o heɓi ngal anndal? Hono hen o heɓiri baawɗe waɗude ɗii kaayeefiiji? ");
INSERT INTO ffm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Tama o wanaa ɓii cehoowo leɗɗe oo? Tama wanaa Mariyama woni inniiko? Tama o wanaa mawnii Yaakuuba e Yuusufu e Simon, kaɲum e Yahuuda? ");
INSERT INTO ffm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tama wanaa enen e banndiraaɓe makko rewɓe koddi? Ndennoo, hoto o heɓi ɗum fuu? ");
INSERT INTO ffm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɗum saabanii ɓe tippitaade mo. Caggal ɗum, o wii ɓe: —Annabaajo ana teddinaa e nokkuuje ɗee fuu, so wanaa ley ngeenndi mum'en, kaɲum e ley galle mum'en. ");
INSERT INTO ffm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iisaa waɗaali ɗon kaayɗe keewɗe saabe waasude maɓɓe goonɗinde mo. ");
INSERT INTO ffm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","E oon wakkati, Hirudus hooreejo leydi Galili oo nani haala Iisaa ana haalee. ");
INSERT INTO ffm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","O wii gollooɓe makko: —Ɗum Yaayaa mo lootogal batisima! O wuurtii. Ɗum saabii so omo jogii baawɗe waɗude kaayɗe. ");
INSERT INTO ffm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Tawi Hirudus yamiriino Yaayaa nanngee, haɓɓee, uddee ley kasu, kammari Hirudiya jom suudu mawniiko biyeteeɗo Filipa. ");
INSERT INTO ffm_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Sabi Yaayaa ana wiyannoo Hirudus: —Dagantaako ma teetaa Hirudiya, sabi o gen mawna. ");
INSERT INTO ffm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hirudus yiɗi warde mo kaa suusaano yimɓe ɓee, sabi ɓe fuu eɓe njogorinoo Yaayaa yo annabaajo. ");
INSERT INTO ffm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ɗum nee, ɲannde yiitu-mawuuri rimeede Hirudus, ɓii Hirudiya debbo darii ana woma yeeso nootiiɓe mo ɓee. Hirudus weltii sanne, ");
INSERT INTO ffm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","faa hunii hokkan mo huunde fuu ko o ɲaagii. ");
INSERT INTO ffm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Suka debbo oo jokki haala inna mum, wii Hirudus: —Waddanam ɗoo hoore Yaayaa mo lootogal batisima oo e la'al! ");
INSERT INTO ffm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hirudus yoomi, kaa nde wonnoo hunike yeeso nootiiɓe ɗum ɓee, yamiri oon waddanee nde. ");
INSERT INTO ffm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Oon wakkati fuu, o yamiri hoore Yaayaa taƴoyee ley kasu too. ");
INSERT INTO ffm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Hoore ndee taƴaa tummbaa e la'al, hokkaa suka debbo oo. Oon hokkoyi nde inna mum. ");
INSERT INTO ffm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Taalibaaɓe Yaayaa ɓee ngari ɓamti tew oo, iroyi. Caggal ɗum, ɓe njehi ɓe kaalanoyi Iisaa ko waɗi koo. ");
INSERT INTO ffm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nde nanirde ndee warnoo e Iisaa ndee, Iisaa iwi ton naati laana, fa'i nokku teelɗo, kaɲum tan. Yimɓe ɓee kumpitii ɗum, njalti e geelle ɗee, cawndii daande weendu nduu, njokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nde o yalti e laana kaa ndee, o yii jamaa keewɗo, o yurminaa ɓe sanne, heddii omo sellina ɲawɓe maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nde hiiri ndee, taalibaaɓe ɓee ɓattitii Iisaa, mbii ɗum: —Jooni hiirii, kasen duu nokku oo yo ladde. Yoppitin jamaa oo, yalla ana coodoya ko ɲaama to geelle too. ");
INSERT INTO ffm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","O jaabii ɓe, o wii: —Fotaa ko ɓe njaha. Onon e ko'e mooɗon, ndokkee ɓe ko ɓe ɲaama! ");
INSERT INTO ffm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ɓe njaabii mo, ɓe mbii: —En ngalaa ɗoo so wanaa buuruuje joy e liɗɗi ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","O wii ɓe: —Ngaddanee kam ɗum gaa. ");
INSERT INTO ffm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","O yamiri yimɓe ɓee njooɗoo e huɗo, o ɓami buuruuje joy ɗee e liɗɗi ɗiɗi ɗii, o tiggitii kammu, o yetti Laamɗo. O taƴi buuru oo, o hokki taalibaaɓe ɓee ndokka jamaa oo. ");
INSERT INTO ffm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɓe fuu ɓe ɲaami faa ɓe keddi. Taalibaaɓe ɓee ndeentini taƴe keddiiɗe ɗee, ɗe kebbini cagiije sappo e ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ɲaamnooɓe ɓee ana mbaara e ujunaaji joy gorko ko waldaa e rewɓe e sukaaɓe. ");
INSERT INTO ffm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ɗon e ɗon, o naanni taalibaaɓe ɓee e laana kaa yalla ana adoo mo lummbude weendu nduu, tawi kanko omo wondi e yoppitinde jamaa oo. ");
INSERT INTO ffm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Caggal o yoppitii ɓe, o ŋabboyi dow waamnde haayre faa o waɗa duwaawu kanko tan. Naange yanii, tawi kanko tan woni ton. ");
INSERT INTO ffm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Laana kaa yehi faa woɗɗii daŋŋeere ndee, tawi bempeeje ana piya ka, sabi ka jaɓɓotooka henndu. ");
INSERT INTO ffm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nde ɓadinoo weetude ndee, o wari e taalibaaɓe ɓee, omo yaara koyɗe dow ndiyam ɗam. ");
INSERT INTO ffm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kaa nde ɓe njii mo omo yaha e dow ndiyam ɗam ndee, kulol manngol nanngi ɓe, ɓe mbii: —Ɗum yo seyɗaani! Ɓe ndarii eɓe conkina no ɓe poti hulde. ");
INSERT INTO ffm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ɗon e ɗon Iisaa wii ɓe: —Mbaaltinee hakkillaaji mooɗon! Ɗum miin, pati kulee! ");
INSERT INTO ffm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piyeer jaabii mo, wii: —Moobbo, so ɗum aan jaati woni ɗoo, yamir mi yaha dow ndiyam ɗam mi wara to maa. ");
INSERT INTO ffm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","O jaabii mo, o wii: —War! Piyeer yalti laana kaa, hedde ana yaha dow ndiyam ɗam, fewti Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kaa nde mo yiinoo henndu nduu sattii ndee, o huli, o fuɗɗi yorkitaade, o wulli, o wii: —Moobbo, nootam! ");
INSERT INTO ffm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ɗon e ɗon, Iisaa foocci junngo mum, nanngi mo, wii: —Nii pamɗir-ɗaa hoolaare? Ko saabii so cikkiti-ɗaa? ");
INSERT INTO ffm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ɓe ɗiɗon fuu, ɓe naati laana kaa tan, henndu nduu darii. ");
INSERT INTO ffm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Taalibaaɓe wonnooɓe ley laana kaa ɓee cujidani mo, mbii: —A Ɓii Laamɗo jaati! ");
INSERT INTO ffm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ɓe lummbi weendu nduu, ɓe panndi leydi Genesaret. ");
INSERT INTO ffm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Worɓe oon nokku annditi mo, kaalani leydi ndii fuu garol makko, o waddanaa ɲawɓe ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ɓe ɲaagii mo mo acca ɲawɓe ɓee mema fay so kommbol saaya makko tan. Haya duu, memɗo ngol fuu sellii. ");
INSERT INTO ffm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Farisa'en e dunkee'en Sariya iwi Urusaliima, ngari e Iisaa lamndii ɗum, mbii: ");
INSERT INTO ffm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Koɗum waɗi so taalibaaɓe maa ɓee ana koyna neesuuji njaatiraaɓe meeɗen ɗii? Sabi ɓe lootataa juuɗe fade maɓɓe ɲaamde. ");
INSERT INTO ffm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","O jaabii ɓe, o wii: —Onon nee, koɗum waɗi so oɗon luutta yamiroore Laamɗo ndee faa njokkon neesu mooɗon? ");
INSERT INTO ffm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Sabi Laamɗo wii: «Teddin inna maa e baam maa.» O wii kasen: «Kuɗuɗo baam mum naa inna mum, wareede laato jukkungo mum.» ");
INSERT INTO ffm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kaa onon, oɗon mbiya so neɗɗo wii baam mum naa inna mum: «Ko kaannoo-mi wallirde ma koo yo ngeɗu Laamɗo», ");
INSERT INTO ffm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ɗum ana heƴa neɗɗo, fotaa ko teddina saaraa mum kasen. Hono non tosirton konngol Laamɗo, faa njokkon neesu mooɗon! ");
INSERT INTO ffm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Naafigi'en! Annabi Esaaya woofaali fey nde sappinoo e mooɗon so wii: ");
INSERT INTO ffm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","«Laamɗo wii: Ngol leɲol e haala tan teddinirta kam, kaa e ley ɓerɗe maɓɓe eɓe ngoɗɗi kam. ");
INSERT INTO ffm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Meere ɓe ndewata kam, sabi ko ɓe tuugii e ley janngingol maɓɓe koo yo jamirooje yimɓe tan.» ");
INSERT INTO ffm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Oon wakkati, Iisaa noddi jamaa oo, wii ɗum: —Kettinee, paamee: ");
INSERT INTO ffm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","wanaa ko naatata e hunduko neɗɗo soɓinta ɗum. Ko yaltata e hunduko soɓinta neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","E oon wakkati, taalibaaɓe ɓee ɓattitii mo, mbii mo: —Tama a anndii Farisa'en ɓee mettaama e haalaaji maa ɗii? ");
INSERT INTO ffm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","O jaabii, o wii: —Funngo fuu ngo Baabiraaɗo am gonɗo dow kammu oo aawaali, ɗoofete. ");
INSERT INTO ffm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Accee ɓe, ɓe wumɓe ɗowooɓe wumɓe! So bumɗo ɗowii bumɗo, ɓe ɗiɗon fuu ɓe caaman ley ngaykaare. ");
INSERT INTO ffm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piyeer jaabii, wii mo: —Firritan min kaa haala. ");
INSERT INTO ffm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Iisaa wii: —Onon duu, faa jooni eɗum finkinii on naa? ");
INSERT INTO ffm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","On paamaali ko naati e hunduko fuu yahan ley reedu, kasen duu ɗum yehete ladde? ");
INSERT INTO ffm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kaa ko yaltata e hunduko koo e ɓernde iwata, ɗum jaati soɓinta neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Sabi e ɓernde neɗɗo miilooji bonɗi iwata so ndunƴa ɗum e ɲaako'aaku e jeenu e faasigaaku e nguyka e kappi, kaɲum e mbonka. ");
INSERT INTO ffm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ɗum woni ko soɓinta neɗɗo. Kaa ɲaamde tawee lootaali juuɗe mum no ɓe mbii nii soɓintaa neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Caggal ɗum, Iisaa iwi ɗon fa'i seraaji Tirus e Sidon. ");
INSERT INTO ffm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Debbo jeyaaɗo Kanaana koɗuɗo e ndiin leydi wari e makko, wulli, wii: —Moobbo, taanii Daawuuda, yurmam! Ɓiyam debbo ladde ana e mum, ana torra ɗum sanne! ");
INSERT INTO ffm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kaa o jaabaaki ɗum fay huunde. Taalibaaɓe makko ɓee ndaardoyi mo, mbii mo: —Ribbu mo dee! Omo nii jokki e meeɗen tan omo wulla. ");
INSERT INTO ffm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Iisaa jaabii, wii: —E baali suudu Israa'iila majjuɗi ɗii tan nelaa-mi. ");
INSERT INTO ffm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nii debbo oo saami yeeso makko, sujidi, wii: —Moobbo, wallam! ");
INSERT INTO ffm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","O jaabii, o wii: —Ɓamde ɲaamdu sukaaɓe so tippoo dawaaɗi moƴƴaa. ");
INSERT INTO ffm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Debbo oo wii: —Goonga, Moobbo, kaa fay dawaaɗi ana ɲaama ɲaamdu joomum'en iwooru e la'al so saama nduu. ");
INSERT INTO ffm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nden, Iisaa jaabii mo, wii: —Debbo, hee goonɗinal maa ana mawni! Yo a waɗane no njiɗir-ɗaa nii. E oon wakkati jaati, ɓiyiiko debbo oo selli. ");
INSERT INTO ffm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iisaa iwi ɗon, takkii daande weendu Galili, ŋabbi waamnde haayre, jooɗii ton. ");
INSERT INTO ffm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Yimɓe heewɓe ngari to makko, ngaddi laƴooɓe e wumɓe e ɓe terɗe mum'en mbaati e muumɗuɓe, kaɲum e ɲawɓe woɓɓe heewɓe. Ɓe ɓattini ɓeen yeeso makko, o sellini ɓe. ");
INSERT INTO ffm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Haaynii yimɓe ɓee sanne nde njiinoo muumɗunooɓe ana kaala, ɓe terɗe mum'en mbaati cellii, laƴannooɓe ana njaha faa gasa, wumnooɓe ana njiya. Hedde eɓe njetta Laamɗo Israa'iila oo. ");
INSERT INTO ffm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iisaa noddi taalibaaɓe mum ɓee, wii ɓee: —Ɓee yimɓe ana njurminii kam, sabi hannde woni balɗe tati ko ɓe ngondi e am, haya duu ɓe ngalaa ko ɓe ɲaama. Mi waawaa yoppitinde ɓe tawee ɓe ɲaamaali, pati ɓe caama yolbere e laawol so eɓe koota. ");
INSERT INTO ffm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Taalibaaɓe makko ɓee mbii mo: —Hoto fuu keɓaten ko ɲamminen oo jamaa e ley ndee ladde jeereende? ");
INSERT INTO ffm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","O lamndii ɓe, o wii: —Hono foti buuruuje njogi-ɗon? Ɓe njaabii mo, ɓe mbii: —Jeɗɗi, kaɲum e liikoy seeɗa min njogii. ");
INSERT INTO ffm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Caggal ɗum, o yamiri jamaa oo jooɗoo e leydi. ");
INSERT INTO ffm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","O ɓami buuruuje jeɗɗi ɗee kaɲum e liikoy koy, o yetti Laamɗo, o taƴi ɗe, o hokki taalibaaɓe ɓee ndokka ɗum jamaa oo. ");
INSERT INTO ffm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɓe fuu ɓe ɲaami faa ɓe keddi. Taalibaaɓe ɓee ndeentini kedde ɗee, ɗe kebbini cagiije jeɗɗi. ");
INSERT INTO ffm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ɲaamnooɓe ɓee yo ujunaaji nay gorko, ko waldaa e rewɓe e sukaaɓe. ");
INSERT INTO ffm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Caggal Iisaa yoppitii yimɓe ɓee, naati laana, fa'i leydi Magadan. ");
INSERT INTO ffm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisa'en e Saduki'en ngari ittude koro Iisaa, ɓe ndaardi mo o holla ɓe taagumansa kaayniiɗo iwoowo dow kammu. ");
INSERT INTO ffm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","O jaaborii ɓe nii: —So on njii kammu ana wojji kiikiiɗe, on mbiyan welan. ");
INSERT INTO ffm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Beetee law, so on njii kammu ana wojji ana niɓɓi, on mbiyan toɓan. Oɗon mbaawi seenndude mbaadi kammu, kaa on mbaawaa seenndude taagumansaaji wakkatiiji ɗii! ");
INSERT INTO ffm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Jamaanu jooni bonɗo coɓuɗo oo ana ndaara holleede taagumansa, kaa taagumansa fuu o hollataake, so wanaa taagumansa annabi Yuunusa oo. Caggal ɗum, o yoppi ɓe ɗon, o witti. ");
INSERT INTO ffm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nde taalibaaɓe ɓee lummbata weendu nduu ndee, njeggiti yooɓaade ɲaamdu. ");
INSERT INTO ffm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Iisaa wii ɓe: —Kakkilee, ndeentee e ƴuufinirdi Farisa'en e Saduki'en ndii. ");
INSERT INTO ffm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Taalibaaɓe ɓee ndarii ana mbiyondira: —Ko en njooɓaaki buuru koo o wiiri non. ");
INSERT INTO ffm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Iisaa anndi ko ɓe kaalata koo, wii ɓe: —Ko waɗi so oɗon kaalda hakkunde mooɗon on njooɓaaki buuru mbiiru-mi non? Onon famɗuɓe hoolaare! ");
INSERT INTO ffm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Tama faa jooni on paamaali? Tama on miccitaaki buuruuje joy ɗe njeɗu-mi e ujunaaji njoyon gorko ɗee, e cagiije ɗe kebbin-ɗon kedde ɗee? ");
INSERT INTO ffm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tama on miccitaaki kasen buuruuje jeɗɗi ɗe njeɗu-mi e ujunaaji nay neɗɗo ɗee, e cagiije ɗe kebbin-ɗon kedde ɗee? ");
INSERT INTO ffm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Hono waɗi on paamaali wanaa haala buuru kaalanan-mi on? Ndeentee e ƴuufinirdi Farisa'en e Saduki'en ndii. ");
INSERT INTO ffm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Oon wakkati, taalibaaɓe ɓee paami o wiyaali ɓe ndeentoo e ko ƴuufinta buuru koo, ko o wii dee, ɓe ndeentoo e ko Farisa'en e Saduki'en njannginta koo. ");
INSERT INTO ffm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Iisaa yehi leydi Kaysariya Filipa. O lamndii taalibaaɓe makko ɓee, o wii: —Homo yimɓe mbiyata Ɓii Neɗɗo oo woni? ");
INSERT INTO ffm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ɓe njaabii, ɓe mbii: —Won wiyooɓe a Yaayaa mo lootogal batisima, won wiyooɓe a annabi Iliyaasa, won wiyooɓe kasen a annabi Yeremiya naa gooto e annabaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","O wii ɓe: —Onon nee, homo mbiyaton ngon-mi? ");
INSERT INTO ffm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piyeer jaabii mo, wii: —Aan woni Almasiihu, Ɓii Laamɗo guurɗo oo. ");
INSERT INTO ffm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nden Iisaa wii mo: —A welii hoore, aan Simon ɓii Yuunusa. Sabi wanaa ɓii-aadama anndin maa ɗum, Baabiraaɗo am gonɗo dow kammu oo anndin maa ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Miin duu, miɗo wiye Piyeer (ɗum woni haayre), e dow nden haayre mahan-mi deental am goonɗinɓe ngal. Maayde e heewde semmbe fuu walaa ko waawi e mayre. ");
INSERT INTO ffm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mi hokkete cokitirɗe Laamu Laamɗo: huunde fuu ko kaɗu-ɗaa e leydi, haɗete dow kammu. Ko njaɓu-ɗaa e leydi, jaɓete dow kammu. ");
INSERT INTO ffm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nden, Iisaa daalii taalibaaɓe mum ɓee pati kaalana fay gooto kaɲum woni Almasiihu oo. ");
INSERT INTO ffm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gila e oon wakkati, Iisaa fuɗɗi anndinde taalibaaɓe mum ɓee ana tilsi mo yaha Urusaliima, ton mawɓe leɲol e hooreeɓe yottinooɓe sadaka e dunkee'en Sariya torran mo sanne, mo waree, kaa mo wuurtan ɲannde tataɓere. ");
INSERT INTO ffm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","E ley ɗum, Piyeer sawndintini mo hedde ana ɲiŋa mo, wii mo: —Yo Laamɗo dannde Moobbo! Ɗum heɓataa ma! ");
INSERT INTO ffm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Iisaa yeeccitii, wii Piyeer: —Woɗɗam aan Ibiliisa! A fergitere e laawol am, sabi miiloo maa ngoo iwrataa to Laamɗo, to yimɓe ngo iwrata! ");
INSERT INTO ffm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Caggal ɗum, o wii taalibaaɓe makko ɓe: —Muuyɗo jokkude kam fuu, ŋootta yurmaade hoore mum, ɓama leggal mum bardugal jokka e am. ");
INSERT INTO ffm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sabi muuyɗo danndude yonki mum, waasan ki. Kaa baasirɗo ki sabaabu am, hisinan ki. ");
INSERT INTO ffm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Koɗum heɓude aduna oo fuu nafata neɗɗo, so waasii yonki mum? Won ko neɗɗo waawi hokkitirde faa soottitoo yonki mum naa? ");
INSERT INTO ffm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Sabi Ɓii Neɗɗo oo wardan e malaa'ika'en mum e ley teddeengal Baabiraaɗo mum. Oon wakkati, o barjoto gooto fuu ko waarata e golle mum. ");
INSERT INTO ffm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Miɗo haalana on goonga: yoga e wonɓe ɗoo ɓee maayataa tawee njiyaali Ɓii Neɗɗo oo ana wara e ley laamu mum. ");
INSERT INTO ffm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Balɗe jeegom caggal mum, Iisaa yaadi e Piyeer e rimdaaɓe ɗiɗon Yaakuuba e Yuhanna, o teeldoyi e mum'en dow waamnde haayre toownde. ");
INSERT INTO ffm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Noone makko waylitii yeeso maɓɓe. Yeeso makko ana jalba no naange nii, kaddule makko ndawni far hono fooyre. ");
INSERT INTO ffm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Muusaa e Iliyaasa ɓanngani ɓe, ana kaalda e makko. ");
INSERT INTO ffm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Piyeer wii Iisaa: —Moobbo, gonal amen ɗoo ana moƴƴi. Ɗal mi darna ɗoo buguuji tati: aan wooturu, Muusaa wooturu, Iliyaasa wooturu. ");
INSERT INTO ffm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","O tilaaki haalde, faa luurde jalboore suddi ɓe. Daande iwi ley luurde ndee, wii: —Oo ɗoo yo Ɓiyam mo korsin-mi, mo cuɓii-mi. Kettindee mo! ");
INSERT INTO ffm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nde taalibaaɓe ɓee nani nden daande ndee, ɓe caami ɓe kippii e leydi, ɓe kuli sanne. ");
INSERT INTO ffm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Iisaa ɓattitii ɓe, memi ɓe, wii: —Immee, pati kulee. ");
INSERT INTO ffm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","E ley ɗum, ɓe kunci gite, ɓe njiyaali fay gooto so wanaa Iisaa tan. ");
INSERT INTO ffm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","E ley ko ɓe njippotoo waamnde haayre ndee koo, Iisaa daalii ɓe, wii: —Pati kaalanee fay gooto ko njii-ɗon koo faa wakkati nde Ɓii Neɗɗo oo immitii e hakkunde maayɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Caggal ɗum, taalibaaɓe ɓee lamndii mo, mbii: —Koɗum waɗi so dunkee'en Sariya ɓee ana mbiya annabi Iliyaasa haani adaade Almasiihu warde? ");
INSERT INTO ffm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","O jaabii ɓe, o wii: —Goonga, Iliyaasa adotoo warde moƴƴintina kulle ɗee fuu. ");
INSERT INTO ffm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kaa miɗo wiya on: Iliyaasa ƴaɓɓike, ɓe annditaali ɗum, ɓe ngollii ɗum ko ɓe muuyi fuu. Hono non ɓe torrirta Ɓii Neɗɗo oo duu. ");
INSERT INTO ffm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Taalibaaɓe ɓee paami ko o haalata haala Iliyaasa koo, haala Yaayaa mo lootogal batisima o haalani ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nde ɓe ngarti e jamaa oo ndee, gorko gooto ɓattitii mo, diccii yeeso makko, ");
INSERT INTO ffm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","wii: —Moobbo, yurma ɓiyam gorko! O kirikiraaɗo omo tampi sanne, wakkatiiji omo saama e yiite naa e ndiyam. ");
INSERT INTO ffm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi naɓii mo to taalibaaɓe maa ɓee kaa ɓe ndonkii sellinde mo. ");
INSERT INTO ffm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","O ɓattitii, o wii: —Hey yimɓe jamaanu bonɗo ɓe nganaa goonɗinɓe! Faa mande tilotoo-mi e mon? Faa mande keddotoo-mi muɲande on? Ngaddanee kam cukalel ngel ɗoo! ");
INSERT INTO ffm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","O jahii e ladde ndee, nde yalti e suka oo, o selli ɗon e ɗon. ");
INSERT INTO ffm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Caggal ɗum, taalibaaɓe ɓee teeldi e makko, lamndii mo, mbii: —Koɗum waɗi so min ndonki ittude ndee ladde? ");
INSERT INTO ffm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Iisaa jaabii ɓe, wii: —Saabe oɗon pamɗi goonɗinal waɗi ɗum. Miɗo haalana on goonga: so goonɗinal mooɗon fotii fay no ngeeƴu buyaage nii, so on mbii ndee ɗoo waamnde haayre: «Sottu ɗoo, njahaa too», nde sottan. Fay huunde on ndonkataa waɗude.  ");
INSERT INTO ffm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","No ɓe njiilortoo e ley Galili nii, Iisaa wii ɓe: —Ɓii Neɗɗo oo waɗete e juuɗe yimɓe, ");
INSERT INTO ffm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ɓe mbara mo, kaa e ley ɲalaande majjum tataɓere, o immitoto. Taalibaaɓe ɓee cuŋli sanne. ");
INSERT INTO ffm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nde Iisaa e taalibaaɓe mum njottinoo Kafarnahum ndee, nanngooɓe usuru Suudu Dewal Mawndu ɓee ɓattii Piyeer, mbii ɗum: —Tama moobbo mooɗon oo ana yoɓa usuru Suudu Dewal Mawndu? ");
INSERT INTO ffm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piyeer jaabii, wii: —Omo yoɓa. Ko Piyeer naati galle oo koo, fade mum heɓude haala, Iisaa wii: —Simon, koɗum woni miilo maa e ɗum? Kaanankooɓe aduna ɓee, homo ɓe nduuɲata? Homo ɓe njoɓinta lampo? Dugule'en naa honaaɓe? ");
INSERT INTO ffm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piyeer jaabii, wii: —Honaaɓe ɓee. Iisaa wii mo: —Ndennoo, dugule'en ɓee kaanaa yoɓude. ");
INSERT INTO ffm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kaa noo, en njiɗaa mettinde ɓerɗe ɓee yimɓe. Yaa to weendu too, tippo-ɗaa yammbuure maa e ley ndiyam ɗam. Liingu fuu adiiɗo moɗude nde pooɗaa, ƴeŋŋinaa ɗum aaraa hunduko mum, a tawan hen kaalisi daneejo kiɓɓinoowo usuru meeɗen. Ittaa njoɓanaa en, enen ɗiɗon. ");
INSERT INTO ffm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Oon wakkati, taalibaaɓe ɓee ɓattitii Iisaa, lamndii ɗum, mbii: —Homo ɓuri teddude ley Laamu Laamɗo oo? ");
INSERT INTO ffm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Iisaa noddi cukalel, darni ngel yeeso maɓɓe, ");
INSERT INTO ffm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","wii: —Miɗo haalana on goonga: so nii on mbaylitaaki faa nanndon e cukaloy, on naatataa e Laamu Laamɗo oo abada. ");
INSERT INTO ffm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ɓurɗo teddude ley Laamu Laamɗo yo leyɗinkiniiɗo faa nanndi e ngel cukalel. ");
INSERT INTO ffm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Neɗɗo fuu jaɓɓiiɗo cukalel gootel hono ngel e innde am, miin jaati o jaɓɓii. ");
INSERT INTO ffm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Neɗɗo fuu luuttinɗo gootel e koy cukaloy goonɗinkoy kam, ko ɓuri moƴƴande joomum haayre teddunde haɓɓee e daande mum, yoolee ley iduru geeci. ");
INSERT INTO ffm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bone woodanii oo aduna saabe kulle gaɗooje yimɓe ley luutti ɗee! Waajibi kulle ɗee ngaɗa, kaa bone woodanii laatiiɗo sabaabu majje! ");
INSERT INTO ffm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","So tawii junngo maa naa koyngal maa luuttinte, taƴu ɗum tippo-ɗaa to woɗɗi. Naataa e nguurndam nduumiiɗam a ɲakuɗo ɓuri moƴƴande ma diina tippeede e yiite duumiinge a kiɓɓuɗo. ");
INSERT INTO ffm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","So tawii yitere maa luuttinte, sol nde tippo-ɗaa. Sabi naatude maa e nguurndam nduumiiɗam a ɗokko, ɓuri moƴƴande ma diina tippe-ɗaa e yiite jahannama a kiɓɓuɗo. ");
INSERT INTO ffm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Ndeentee e yawde fay gootel e koy cukaloy. Sabi miɗo wiya on: malaa'ika'en makkoy dow kammu ɓee, wakkati fuu ana ƴeewa yeeso Baabiraaɗo am gonɗo dow kammu oo.  ");
INSERT INTO ffm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ko miilaton? So neɗɗo ana jogii baali teemedere majjiraama mbaalu gooto, yoppataa capanɗe jeenay e jeenay ɗii fuu ana ndura ley ferro, tewtoya majjuɗo oo? ");
INSERT INTO ffm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Miɗo haalana on goonga: so o yiitii mo, o seyorto oon faa ɓura capanɗe jeenay e jeenay ɗi majjaali ɗii. ");
INSERT INTO ffm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hono non Baabiraaɗo mooɗon gonɗo dow kammu oo yiɗaa fay gootel e koy cukaloy majja. ");
INSERT INTO ffm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—So sakiike maa tooɲii ma, yaa to mum kollitaa ɗum tooɲannge mum oo tawee onon tan ɗiɗon. So o jaɓanii ma, a hewtii sakiike maa. ");
INSERT INTO ffm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kaa so o jaɓaali kollitaa mo yaadu e neɗɗo gooto naa yimɓe ɗiɗon hono no Binndi ɗii mbiiri nii: «Huunde fuu ko neɗɗo happaa ana hasindini e seedaaku yimɓe ɗiɗon naa taton.» ");
INSERT INTO ffm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","So o jaɓanaali ma, haalan ɗum deental goonɗinɓe ngal. So o salike jaɓande deental goonɗinɓe ngal, jogora mo keefeero naa duwaaɲe. ");
INSERT INTO ffm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Miɗo haalana on goonga: huunde fuu ko kaɗu-ɗon e leydi, haɗete dow kammu. Huunde fuu ko njaɓu-ɗon e leydi, jaɓete dow kammu. ");
INSERT INTO ffm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Miɗo haalana on kasen: e ley aduna, nde ɗiɗon mon kawritii e dow huunde wootere ɲaagike Laamɗo, ko nde waawi laataade fuu, Baabiraaɗo am gonɗo dow kammu oo hokkan ɓe nde. ");
INSERT INTO ffm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Sabi nde ɗiɗon naa taton kawriti e innde am fuu, miɗo hakkunde mum'en. ");
INSERT INTO ffm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Oon wakkati, Piyeer ɓattitii mo, lamndii mo, wii: —Moobbo, cili hono foti kaan-mi yaafaade sakiike am mo ŋoottaali tooɲude kam? Cili jeɗɗi naa? ");
INSERT INTO ffm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Iisaa jaabii mo, wii: —Mi wiyaali ma cili jeɗɗi, mbii-maa-mi cili capanɗe jeɗɗi faa nde cili jeɗɗi. ");
INSERT INTO ffm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iisaa ɓeydi hen wii: —Ɗum Laamu Laamɗo nanndi: kaananke gooto anniyii ƴamtude gollooɓe mum ɲamaande. ");
INSERT INTO ffm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nde mo fuɗɗi ƴamtude ndee, o waddanaa golloowo gooto mo o rewata miliyooji. ");
INSERT INTO ffm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Oon gorko walaa ko yoɓira oon kaalisi. Ɗum nee, kaananke oo yamiri o soottee, kanko e jom suudu makko e sukaaɓe makko e ko o jogii fuu, faa yoɓa ɲamaande ndee. ");
INSERT INTO ffm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Golloowo oo diccii yeeso makko, ɲaagii mo, wii: «Muɲanam, mi yoɓete fuu!» ");
INSERT INTO ffm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Kaananke oo yurmii mo, yaafii mo ɲamaande ndee, yoppi mo o witti. ");
INSERT INTO ffm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Golloowo oo yalti tan, hawri e gollidiiɗo mum mo rewata kaalisi seeɗa. O teɓɓii ɗum, o nanngi daande mum, o wii: «Yoɓam kaalisi am!» ");
INSERT INTO ffm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Gollidiiɗo makko oo diccii, ɲaagii mo, wii: «Muɲanam, mi yoɓete!» ");
INSERT INTO ffm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kaa oon jaɓaali. O uddoyi ɗum kasu, faa nde yoɓi ɲamaande ndee fuu. ");
INSERT INTO ffm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nde gollooɓe heddiiɓe ɓee njii ɗum ndee, mettaa sanne, njehi kaalanoyi ɗum kaananke oo. ");
INSERT INTO ffm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","E ley ɗum, kaananke oo noddi golloowo oo, wii ɗum: «Aan a golloowo bonɗo! Nde ɲaagi-ɗaa kam, mi yaafe ko ndewan-maa-mi koo ndee, mi yaafike ma. ");
INSERT INTO ffm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Aan duu, a haanaanoo yurmaade jaado maa oo no njurmori-maa-mi nii naa?» ");
INSERT INTO ffm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kaananke oo bilaa sanne, waɗi mo e juuɗe jukkooɓe ɓee, faa nde o yoɓi ɲamaande ndee faa laaɓi. Iisaa ɓeydi hen wii: ");
INSERT INTO ffm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","—Hono non Baabiraaɗo am gonɗo dow kammu oo waɗata neɗɗo fuu e mooɗon mo yaaforaaki sakiike mum ɓernde laaɓunde. ");
INSERT INTO ffm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nde Iisaa tilii e ɗiin waajuuji ndee, iwi Galili fa'i bannge Yahuudiya gonɗo caggal maayo Urdun oo. ");
INSERT INTO ffm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Yimɓe heewɓe njokki e makko, o sellini ton ɲawɓe mum'en. ");
INSERT INTO ffm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yoga e Farisa'en ngari e makko, lamndii mo ɗum ɗoo faa itta koro makko: —Tama ana daganii gorko seerdude jom suudu mum daliili tawaaɗo fuu? ");
INSERT INTO ffm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","O jaabii, o wii: —Tama on njanngaali ko Binndi ɗii mbii? E fuɗɗoode Laamɗo tagii ɓe waɗii ɓe gorko e debbo, ");
INSERT INTO ffm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","wii: «Ɗum waɗi so gorko yoppan inna mum e baam mum, nanngondira e jom suudu mum, ɓe ɗiɗon fuu ɓe laatoo neɗɗo gooto.» ");
INSERT INTO ffm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nii woni ɓe nganaa ɗiɗon kasen, ɓe neɗɗo gooto. Ndennoo, pati neɗɗo seenndu ko Laamɗo reentini. ");
INSERT INTO ffm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɓe lamndii mo, ɓe mbii: —Ko saabii so Muusaa yamiri gorko hokka jom suudu mum talkuru ceergal nde ana seera ɗum? ");
INSERT INTO ffm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","O jaabii ɓe, o wii: —On yoorɓe ɓerɗe, ɗum saabii so Muusaa hokki on no ceerdon rewɓe mooɗon. Kaa e fuɗɗoode, wanaa non worrunoo. ");
INSERT INTO ffm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Miɗo wiya on: ceerduɗo jom suudu mum ko wanaa fijirde, so ɓamii debbo goɗɗo, jeenii. ");
INSERT INTO ffm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Taalibaaɓe makko ɓee mbii mo: —So nii hakkunde gorko e debbo worri, waasude ɓamde ɓuri. ");
INSERT INTO ffm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Iisaa jaabii ɓe, wii: —Wanaa yimɓe fuu mbaawi jaɓude kaa haala, ɓe Laamɗo hokki ɗum ɓee tan mbaawi jaɓude ka. ");
INSERT INTO ffm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Daliiliiji kaɗooji worɓe ɓamde ana ngoodi. Sabi won worɓe rimeteeɓe tawa yo waatoraaɓe. Won ɗereteeɓe. Heddiiɓe ɓee noo, kaɲum'en kaɗi ko'e mum'en ɓamde faa ngollana Laamu Laamɗo oo. Neɗɗo fuu jarriiɗo ndee tinndinoore, yo jaɓu! ");
INSERT INTO ffm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Caggal ɗum, won waddanɓe Iisaa cukaloy yalla omo fawa e makkoy juuɗe makko o duwanoo koy, kaa taalibaaɓe ɓee njahii e yimɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nden o wii: —Accee cukaloy koy ngara e am, pati kaɗee koy, sabi wa'uɓe no makkoy nii ɓee njey Laamu Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","O fawi junngo makko dow makkoy, o duwanii koy. Nden o iwi ton. ");
INSERT INTO ffm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Gorko gooto ɓattitii Iisaa, lamndii mo, wii: —Moobbo, honde huunde moƴƴunde kaan-mi waɗude faa mi heɓa nguurndam nduumiiɗam? ");
INSERT INTO ffm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Iisaa wii mo: —Ko saabii so laamdi-ɗaa kam ko moƴƴi? Laamɗo tan woni moƴƴo! So aɗa yiɗi naatude e nguurndam, jokku sariyaaji ɗii. ");
INSERT INTO ffm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Gorko oo lamndii Iisaa, wii: —Hoɗi ngoni sariyaaji ɗii? Iisaa jaabii, wii: —Pati ɲaaɗu hoore, pati jeenu, pati wujju, pati seeda fenaande, ");
INSERT INTO ffm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","teddin inna maa e baam maa, njiɗiraa tanaa maa no njiɗir-ɗaa hoore maa nii. ");
INSERT INTO ffm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Suka jokolle oo wii mo: —Miɗo haybi ɗum fuu. Koɗum heddii? ");
INSERT INTO ffm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Iisaa wii mo: —So tawii aɗa yiɗi hiɓɓude, yaa soottoy ko njogi-ɗaa fuu, ndokkaa kaalisi oo misikiina'en. Nden a heɓan jawdi dow kammu. Caggal ɗum, ngaraa njokkaa kam. ");
INSERT INTO ffm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nde suka jokolle oo nani ɗiin haalaaji ndee, yaadi e yoomeende, sabi o arsukunte ɲolɗo. ");
INSERT INTO ffm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","E ley ɗum, Iisaa wii taalibaaɓe mum ɓee: —Miɗo haalana on goonga: hee naatugol arsukunte e Laamu Laamɗo ana tiiɗi! ");
INSERT INTO ffm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Miɗo haalana on kasen ɗum ɗoo: ngelooba ƴaɓɓoroo e wuddere mesalal ɓuri newaade diina naatugol arsukunte e Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Haaynii taalibaaɓe ɓee sanne nde nani ɗiin haalaaji ndee, ɓe mbii: —Ndennoo, homo woni kisoowo? ");
INSERT INTO ffm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","O ƴeewi ɓe, o wii: —Ɗo yimɓe ɗum laatataako, kaa walaa fuu ko Laamɗo waawaa. ");
INSERT INTO ffm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piyeer ɓami haala, wii mo: —Minen, min njoppii fuu, min njokkii e maa. Koɗum min keɓoyta? ");
INSERT INTO ffm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Iisaa wii ɓe: —Miɗo haalana on goonga: so Ɓii Neɗɗo oo jooɗiima e jooɗorgal mum laamu teddungal ley aduna keso, onon sappo e ɗiɗon jokkuɓe e am ɓee duu, on njooɗoto e dow jooɗorɗe kaanankooɓe, caron cuuɗi baaba Israa'iila sappo e ɗiɗi ɗii. ");
INSERT INTO ffm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Neɗɗo fuu joppirɗo saabe am galle mum naa sakiraaɓe mum worɓe naa sakiraaɓe mum rewɓe naa inna mum naa baam mum naa sukaaɓe mum naa gese mum, heɓan ko ɓuri ɗum cowe teemedere, kasen duu heɓan nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kaa ardinooɓe heewɓe laatoto caggalaaɓe, caggalaaɓe ɓee laatoto ardiiɓe. ");
INSERT INTO ffm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Annii ko Laamu Laamɗo nanndi: jom ngesa peguuje yalti beetee law faa hasa gollooɓe ɓe ngolla ngesa mum peguuje. ");
INSERT INTO ffm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","O heɓi gollooɓe, o hawri e maɓɓe o yoɓan ɓe hono ko woowi: ɲalooma fuu mbuuɗu cardi. O naɓi ɓe ngesa makko. ");
INSERT INTO ffm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wakkati ɲawlal, o yalti kasen, o tawi woɓɓe sakoro ɓe keɓaali golle, ");
INSERT INTO ffm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","o wii ɓe: «Njehee onon duu ngolloyon to ngesa am peguuje too, mi yoɓan on ko haani yoɓeede koo.» ");
INSERT INTO ffm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ɓeen duu njehi ton. Jom ngesa oo waɗi non kasen hakkunde naange e caggal sallifanaa. ");
INSERT INTO ffm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Caggal ɗum, o yalti kasen wakkati laasaraa, o tawi woɓɓe ana ndarii to sakoro too, o wii ɗum'en: «Koɗum waɗi so ɲallu-ɗon ɗoo on ngollaali fay huunde?» ");
INSERT INTO ffm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ɓe njaabii mo, ɓe mbii: «Fay gooto ɓamaali min golle.» O wii ɓe: «Njehee onon duu ngolloyon e ngesa am peguuje ngaa.» ");
INSERT INTO ffm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nde hiirnoo ndee, jom ngesa oo wii keƴaaɗo mum oo: «Noddu gollooɓe ɓee njoɓaa ɗum'en. Ardoro-ɗaa sakitiiɓe nanngeede ɓee, cakitoro-ɗaa adiiɓe nanngeede ɓee.» ");
INSERT INTO ffm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nannganooɓe laasaraa ɓee ngari, gooto e mum'en fuu hokkaa mbuuɗu cardi. ");
INSERT INTO ffm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Adinooɓe nanngeede ɓee duu ngari, cikki njoɓete ko ɓuri ɗum. Kaa gooto e maɓɓe fuu hokkaa mbuuɗu cardi hono no ɓee too nii. ");
INSERT INTO ffm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nde ɓe njoɓaa ɗum ndee, eɓe ŋermitoo yaade to jom ngesa too ");
INSERT INTO ffm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","eɓe mbiya: «Ɓee ɗoo gollooɓe ngollaali kinaa wakkati gooto tan, ɓe ponndaama e amen njoɓdi, minen nee min ngollii ɲalooma kuurɗo ley ngee naange wulnge!» ");
INSERT INTO ffm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jom ngesa oo jaabii gooto e maɓɓe, wii: «Giɗam, mi tooɲaali ma. Tama wanaa aan jaɓunoo mi nanngire mbuuɗu cardi ɲalooma? ");
INSERT INTO ffm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ndennoo, ɓam njoɓdi maa njahaa. Miin muuyi hokkude cakitiiɗo oo hono ko keɓu-ɗaa koo. ");
INSERT INTO ffm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Tama wanaa ko weli kam ngaɗan-mi e kaalisi am oo? Naa moƴƴuki am kii waddan maa haasidaade?» ");
INSERT INTO ffm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iisaa wii: —Hono nii caggalaaɓe ɓee laatoto ardiiɓe, ardiiɓe ɓee laatoto caggalaaɓe. ");
INSERT INTO ffm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tawi Iisaa ana ŋabbita faade Urusaliima, sawndintini taalibaaɓe sappo e ɗiɗon ɓee e laawol, wii ɗum'en: ");
INSERT INTO ffm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Kettinee, eɗen nii ŋabbita Urusaliima. Ɗon Ɓii Neɗɗo oo waɗetee e juuɗe hooreeɓe yottinooɓe sadaka e dunkee'en Sariya. Ɓe caran mo waree, ");
INSERT INTO ffm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ɓe ngaɗa mo e juuɗe heeferɓe, ɓeen duu njaayran mo, piya mo dorri, peŋa mo e leggal bardugal faa mo maaya. Kaa ɲalooma majjum tataɓo oo mo wuurtan. ");
INSERT INTO ffm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nden, inna ɓiɓɓe Jebede ɓattini sukaaɓe mum Iisaa. Inna oo diccii yeeso Iisaa faa ɲaagoo ɗum ballal. ");
INSERT INTO ffm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Iisaa wii mo: —Koɗum njiɗ-ɗaa? Debbo oo jaabii mo, wii: —Miɗo yiɗi podaa ɓiɓɓe am worɓe ɗiɗon ɓee njooɗoo bannge maa so a laamiima, gooto wona bannge maa ɲaamo, goɗɗo oo wona bannge maa nano. ");
INSERT INTO ffm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Iisaa jaabii, wii: —On anndaa ko ɲaagoto-ɗon. Oɗon mbaawi yarde horde mettunde nde njaran-mi ndee naa? Ɓe njaabii mo, ɓe mbii: —Miɗen mbaawi. ");
INSERT INTO ffm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","O wii ɓe: —On njaran nde jaati. Kaa jooɗagol bannge am ɲaamo naa nano wanaa miin yamirta ɗum. Ɗeen joolle, ɓe Baabiraaɗo am moƴƴinani ɓee njey ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nde taalibaaɓe sappo heddiiɓe ɓee nani ɗum ndee, mettaa e rimdaaɓe ɗiɗon ɓee. ");
INSERT INTO ffm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","E oon wakkati, Iisaa noddi ɓe fuu, wii ɓe: —Oɗon anndi laamiiɓe heeferɓe ana kawjorii ɗum'en hawju bonɗo. Mawɓe ɓee duu ana laamorii ɓe laamu boɗeejo. ");
INSERT INTO ffm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Onon kaa, ɗum waɗataa hakkunde mooɗon. So won jiɗɗo teddeengal hakkunde mon, ana haani laataade golloowo mooɗon. ");
INSERT INTO ffm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kasen so won muuyɗo ardaade e mon, ana haani laataade maccuɗo mooɗon. ");
INSERT INTO ffm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ɗum nee, Ɓii Neɗɗo wardaali faa gollanee, gollande yimɓe wardi, hokkitira yonki mum yalla ana laatoo coottitaari heewɓe. ");
INSERT INTO ffm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nde Iisaa e taalibaaɓe mum njalti Yeriko ndee, jamaa keewɗo jokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Wumɓe ɗiɗon ana njooɗinoo e sera laawol ngol, nani ana wiyee Iisaa annii ɓettoo, puɗɗi wullude ana mbiya: —Taanii Daawuuda, yurma min! ");
INSERT INTO ffm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jamaa oo darii ana jahoo e maɓɓe ana wiya ɓe ndeƴƴinoo, kaa ɓe ɓeydii wullude eɓe mbiya: —Moobbo, taanii Daawuuda, yurma min! ");
INSERT INTO ffm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iisaa darii, noddi ɓe, wii: —Koɗum njiɗ-ɗon mi waɗana on? ");
INSERT INTO ffm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ɓe njaabii mo, ɓe mbii: —Moobbo, min mbumta. ");
INSERT INTO ffm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Iisaa yurminaa ɓe, memi gite maɓɓe. Ɗon e ɗon ɓe mbumti, ɓe njokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nde Iisaa e taalibaaɓe mum ɓadinoo Urusaliima njottii Baytifaaji dow waamnde haayre wiyeteende Jaytun ndee, Iisaa neli taalibaaɓe ɗiɗon, ");
INSERT INTO ffm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","wii ɓe: —Njehee naatoyee ngeenndi ngonndi yeeso mon ndii, oon wakkati fuu, on tawan ton ndakiiwa e mola mum ana kaɓɓii. Kumton ɗi ngaddanon kam. ");
INSERT INTO ffm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","So won biiɗo on huunde, njaabo-ɗon ɗum Moobbo ana haajaa ɗi. Ɗon e ɗon on njoppete ngaddon ɗi. ");
INSERT INTO ffm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ɗum waɗii yalla haala ka Laamɗo yottinirnoo annabaajo oo kaa ana tabita nde oon wii: ");
INSERT INTO ffm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Mbiyee ɓiɓɓe Siyona: Ƴeew, kaananke maa annii wara e maa, ana leyɗinkinii, ana waɗɗii tefeewa, ana waɗɗii mola tefeewa.» ");
INSERT INTO ffm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Oon wakkati, taalibaaɓe ɓee njehi ngaɗoyi ko Iisaa yamiri ɗum'en koo. ");
INSERT INTO ffm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ɓe ngaddi ndakiiwa ngaa e mola mum, ɓe njappi e majji saayaaji maɓɓe, Iisaa waɗɗii. ");
INSERT INTO ffm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ko ɓuri heewde e jamaa oo weerti saayaaji mum'en e laawol. Woɓɓe kelti caɓe leɗɗe, mbeerti ɗe e laawol ngol. ");
INSERT INTO ffm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ardiiɓe Iisaa ɓee e jokkuɓe e caggal makko ɓee ana ilina ana mbiya: —Jettooje ngoodanii taanii Daawuuda! Barke woodanii gardoowo e dow innde Joomiraaɗo! Jettooje ngoodanii Laamɗo Toowɗo! ");
INSERT INTO ffm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nde o naati Urusaliima ndee, yimɓe ɓee fuu keddii ana caaƴa ana mbiya: —Homo woni oo gorko? ");
INSERT INTO ffm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jamaa oo jaabii: —Ɗum annabi Iisaa, iwruɗo Nasaraatu ley leydi Galili. ");
INSERT INTO ffm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iisaa naati daalaare Suudu Dewal Mawndu nduu, ribbi soodooɓe e soottooɓe wonɓe ley mayre ɓee fuu, liɓi taabe weccooɓe kaalisi e jooɗorɗe soottooɓe buugaaji. ");
INSERT INTO ffm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Caggal ɗum, o wii ɓe: —Ley Binndi ɗii Laamɗo wii: «Suudu am noddirte suudu rewrudu Laamɗo.» Iisaa ɓeydi hen, wii: —Kaa onon, on ngaɗii ndu «suuɗorde yanooɓe!» ");
INSERT INTO ffm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wumɓe e laƴooɓe ngari e makko e ley Suudu Dewal Mawndu nduu, o sellini ɓe. ");
INSERT INTO ffm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Hooreeɓe yottinooɓe sadaka ɓee e dunkee'en Sariya ɓee mettaa nde njii kulle kaayniiɗe ɗe o waɗata ɗee, e nde nani sukaaɓe ana ilina e ley Suudu Dewal Mawndu ana mbiya: —Jettooje ngoodanii taanii Daawuuda! ");
INSERT INTO ffm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nden ɓe mbii Iisaa: —A nanii ko cukaloy koy kaalata koo? O wii ɓe: —Mi nanii. Tama on janngaali ɗum ɗoo abada: «A waɗii fay sukaaɓe wadduɓe e muynooɓe ana njette»? ");
INSERT INTO ffm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Caggal ɗum, o seerti e maɓɓe, o yalti ngalluure ndee, o yehi Baytaniya, o waaloyi ton. ");
INSERT INTO ffm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Beetee law omo wirfitoo to ngalluure too, tawi omo yolbi. ");
INSERT INTO ffm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O soynii ibbi e sera laawol ngol, o faŋi ki, kaa o tawaali e makki so wanaa haakolooji. Oon wakkati, o wii ki: —Pati a rimu abada! Ɗon e ɗon, ibbi kii yoori kolon. ");
INSERT INTO ffm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Haaynii taalibaaɓe ɓee nde njii ɗum ndee, ɓe lamndii mo, ɓe mbii: —Hono hen kii ibbi yoordi wakkati gooto tan? ");
INSERT INTO ffm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","O jaabii ɓe, o wii: —Miɗo haalana on goonga: so tawii oɗon ngoonɗini on cikkitaaki, on njawtan waɗude ko ngaɗu-mi kii ibbi koo. On mbaawan wiide fay ndee ɗoo waamnde haayre: «Ɗoofa, saamoy ley maayo geeci», laatoto non. ");
INSERT INTO ffm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","So oɗon ngoonɗini, ko ɲaagi-ɗon e ley duwaawu fuu on njaabante. ");
INSERT INTO ffm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iisaa naati Suudu Dewal Mawndu nduu. Nde mo waajotoo ndee, hooreeɓe yottinooɓe sadaka ɓee e mawɓe Yahuudiyankooɓe ɓee ɓattii mo, lamndii, mbii: —Yamiroore hende ngollirtaa ko ngollataa koo? Kasen, dow yamiroore homo? ");
INSERT INTO ffm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Iisaa jaabii ɓe, wii: —Miin duu, huunde wootere tan lamndotoo-mi on. So on njaabike kam, mi haalanan on jamirɗo kam mi golla ko ngollan-mi koo. ");
INSERT INTO ffm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Homo neli Yaayaa loota yimɓe lootogal batisima? Laamɗo naa yimɓe? Ɓe ndawridi hakkunde maɓɓe, ɓe mbii: —So en mbii «Laamɗo», o wiyan: «Ndennoo, ko saabii so on ngoonɗinaali Yaayaa?» ");
INSERT INTO ffm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kaa so en mbii «yimɓe», waajibi kulen jamaa oo, sabi yimɓe ɓee fuu ana njogorii Yaayaa yo annabaajo. ");
INSERT INTO ffm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɓe njaabii Iisaa, ɓe mbii: —Min anndaa. O jaɓɓitii, o wii ɓe: —Haya miin duu, mi haalantaa on yamiroore nde ngolliran-mi ko ngollan-mi koo. ");
INSERT INTO ffm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iisaa ɓeydi hen wii: —Koɗum miilaton e ngol banndol: gorko gooto ana joginoo ɓiɓɓe worɓe ɗiɗon, ɓadii arano oo, wii ɗum: «Ɓinngel am, yaa golloy hannde to ngesa peguuje too.» ");
INSERT INTO ffm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ɓiɗɗo oo jaabii, wii yahataa. Kaa caggal mum, oon mimsiti yehi. ");
INSERT INTO ffm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Baabiraaɗo oo noddi ɓiɗɗo ɗiɗaɓo oo, wii ɗum ko wiinoo arano oo koo. Oon duu jaabii, wii: «Moƴƴi Baaba», kaa yahaali. ");
INSERT INTO ffm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Homo e maɓɓe woni jaɓanɗo baam mum ko wii koo? Ɓe njaabii, ɓe mbii: —Arano oo. Nden, Iisaa wii ɓe: —Miɗo haalana on goonga: duwaaɲe'en ɓee kaɲum e bamfaaji ɗii adoyto on naatude e Laamu Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sabi Yaayaa warii e mooɗon, hollii on laawol fooccitaare, on njaɓanaali ɗum. Kaa duwaaɲe'en ɓee kaɲum e bamfaaji ɗii ngoonɗinii mo. Haya duu, fay nde njii-ɗon ɗum ndee, on mimsitaali so sakitii ngoonɗin-ɗon mo. ");
INSERT INTO ffm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Kettinee banndol gonngol: neɗɗo gooto tuti ngesa peguuje, o filtini nga kokowol, o asi ngaykaare ɓoosirde peguujam, o mahi suudu toowndu faa o soynoroo ko warata e ngesa ngaa. Caggal ɗum, o hasiri nga remooɓe gese peguuje, o dawi. ");
INSERT INTO ffm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Faa teɓugol peguuje yottii, o neli gollooɓe makko to remooɓe ɓee too, ɓe ngaddanoya mo ngeɗu makko e ɓiɓɓe peguuje ɗee. ");
INSERT INTO ffm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kaa remooɓe ɓee nanngi gollooɓe makko ɓee, pii hen gooto, mbari gooto, mbardi gooto kaaƴe. ");
INSERT INTO ffm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jom ngesa oo neli e maɓɓe gollooɓe ɓurɓe aranndeeɓe ɓee heewde. Remooɓe ɓee ngaɗi ɓe no ngaɗunoo ɓee too nii. ");
INSERT INTO ffm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","O sakitii nelde ɓiyiiko gorko to maɓɓe, o wii: «No laatii fuu, ɓe njaagoto ɓiyam oo.» ");
INSERT INTO ffm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kaa nde remooɓe ɓee njii ɓiyiiko oo ndee, mbiyondiri e ko'e mum'en: «Oo woni donoowo mo. Ngaree mbaren mo, keddoro-ɗen ngesa ngaa!» ");
INSERT INTO ffm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Oon wakkati, ɓe nanngi mo, ɓe mbedii mo to caggal ngesa too, ɓe mbari mo. ");
INSERT INTO ffm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jooni nee, so jom ngesa peguuje oo warii, hono o waɗata remooɓe ɓee? ");
INSERT INTO ffm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ɓe njaabii mo, ɓe mbii: —Ɓeen bonɓe, o halkiran ɓe no boniri. O hasira ngesa ngaa remooɓe woɓɓe hokkooɓe mo ngeɗu makko e ɓiɓɓe magga nde nga teɓaa fuu. ");
INSERT INTO ffm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Caggal ɗum, Iisaa wii ɓe: —Tama on njanngaali ko winndaa ley Binndi ɗii koo? «Haayre nde mahooɓe ɓee tippitii ndee, kaɲum laatii haayre ɓurnde fuu teentilaade e maadi ndii. Ɗum yo golle Joomiraaɗo, kanjum ɗum haaynde e jiile meeɗen!» ");
INSERT INTO ffm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Saabe ɗum, miɗo wiya on: Laamu Laamɗo oo ittete e mon, hokkee yimɓe waɗooɓe ko Laamɗo yiɗi. ");
INSERT INTO ffm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Neɗɗo fuu caamɗo e nden haayre, helan. Neɗɗo fuu mo nde saami e mum, noƴoto. ");
INSERT INTO ffm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nde hooreeɓe yottinooɓe sadaka ɓee e Farisa'en ɓee nani banndi makko ɗii ndee, paamii banndi ɗii e mum'en peewti. ");
INSERT INTO ffm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eɓe tewta no ɓe nanngira mo, kaa ɓe kulii yimɓe ɓee, sabi ɓe fuu eɓe njogorii mo annabaajo. ");
INSERT INTO ffm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iisaa haaldiri e maɓɓe banndol kasen, wii ɓe: ");
INSERT INTO ffm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Laamu Laamɗo ana wa'i hono no kaananke kuurtinanɗo ɓiyum gorko, so waɗani ɗum yannge. ");
INSERT INTO ffm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","O neli gollooɓe makko noddanoya mo ɲaamooɓe, kaa gansaaɓe ɓee calii warde. ");
INSERT INTO ffm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","O neli kasen gollooɓe woɓɓe, o wii ɗum'en: «Mbiyee gansaaɓe ɓee ɲiiri yannge ndii moƴƴinaama faa gasi, mi hirsii ga'i e ɲalbi payɗi, hankasen fuu lanndinaama, ɓe ngara ɓe nootoo yannge oo.» ");
INSERT INTO ffm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kaa gansaaɓe ɓee koyni mo, kiinnii haajuuji mum'en: oo ngesa mum, oo jaagu mum. ");
INSERT INTO ffm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Heddiiɓe ɓee nanngi gollooɓe ɓee, torri ɓe, mbari ɓe. ");
INSERT INTO ffm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kaananke oo mettaa, neli sordaasi'en mum mbaroyi ɓeen ɲaaɗuɓe ko'e, nduppi ngeenndi mum'en. ");
INSERT INTO ffm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Caggal ɗum, o wii gollooɓe makko ɓee: «Ɲiiri yannge ndii moƴƴinaama, kaa gansaaɓe ɓee kaandaa e ɲaamde ndi. ");
INSERT INTO ffm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ɗum nee, njehee dow mbeddaaji mawɗi ɗii, noddon neɗɗo fuu mo kawru-ɗon wara ɲaama ɲiiri yannge oo ndii.» ");
INSERT INTO ffm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kaadime'en ɓee njehi dow mbeddaaji ɗii, noddi yimɓe ɓe tawi ton fuu gila e bonɓe faa e moƴƴuɓe faa galle ɗo yannge oo waɗata ɗoo heewi yimɓe. ");
INSERT INTO ffm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Nde kaananke oo naati faa yiya noddaaɓe ɓee ndee, o soynii gorko mo paraaki. ");
INSERT INTO ffm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","O wii ɗum: «Giɗam, hono naatir-ɗaa ɗoo tawi a paraaki?» Kaa oon deƴƴinii. ");
INSERT INTO ffm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","E ley ɗum, kaananke oo wii gollooɓe ɓee: «Kaɓɓee juuɗe makko e koyɗe makko, tippo-ɗon mo e ley nimre sella ndee, ton o wullata o ŋerƴondira ɲiiƴe.» ");
INSERT INTO ffm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iisaa jokki wiide: —Noddaaɓe ana keewi kaa suɓaaɓe ana pamɗi. ");
INSERT INTO ffm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisa'en njehi ndawridoyi no tuufiranta Iisaa e ley haala mum. ");
INSERT INTO ffm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ɓe neli yoga e taalibaaɓe maɓɓe, kaɲum e howruuɓe Hirudus mbiya mo: —Moobbo, miɗen anndi a goongirante: aɗa jannginira laawol Laamɗo ngol goonga, a hulataa fay gooto, sabi a ɓurdintaa yimɓe. ");
INSERT INTO ffm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ɗum nee, haalan min koɗum anndu-ɗaa e ɗum ɗoo: ana dagoo min ndokka kaananke Roma mawɗo oo lampo naa dagaaki? ");
INSERT INTO ffm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kaa Iisaa ana anndi anniyaaji maɓɓe bonɗi ɗii. O wii ɓe: —Onon naafigi'en! Koɗum waɗi so oɗon tuufana kam? ");
INSERT INTO ffm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kollee kam kaalisi joɓirteeɗo lampo oo. Ɓe ngaddani mo mbuuɗu cardi gooto. ");
INSERT INTO ffm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","O lamndii ɓe, o wii: —Natal homo e innde homo woni ɗoo? ");
INSERT INTO ffm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ɓe njaabii mo, ɓe mbii: —Kaananke Roma. O wii ɓe: —Ndennoo, ndokkee kaananke Roma oo ko jey, ndokkee Laamɗo duu ko jey. ");
INSERT INTO ffm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Haaynii ɓe nde ɓe nani oo jaabu ndee. Ɓe celi mo, ɓe mbitti. ");
INSERT INTO ffm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","E ley oon ɲalooma jaati, yoga e waaldeSaduki'en ngari e Iisaa. Kamɓe ngoni fennuɓe immital. ");
INSERT INTO ffm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ɓe lamndii mo, ɓe mbii: —Moobbo, Muusaa wii: «So neɗɗo maayii heɓaali ɓiɗɗo, miɲum naa mawnum ɓamta debbo ɗalaaɗo oo, yalla ana heɓana ɗum ɓeyngu.» ");
INSERT INTO ffm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Waɗiino e ɓettaade to amen rimdaaɓe njeɗɗon worɓe. Arano oo caggal dewlii, maayi heɓaali ɓiɗɗo. Miɲiiko gorko ɓamti debbo makko oo, ");
INSERT INTO ffm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","kaɲum duu maayi heɓaali ɓiɗɗo. Tataɓo oo duu jokki hen faa yottii njeɗɗaɓo oo. ");
INSERT INTO ffm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Caggal maɓɓe ɓe fuu, debbo oo duu maayi. ");
INSERT INTO ffm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ɲannde immital nee, homo e njeɗɗon ɓee debbo oo laatotoo jom suudu mum? Sabi ɓe fuu ɓe ɓamiino mo. ");
INSERT INTO ffm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Iisaa jaabii ɓe, wii: —On majjii, sabi on paamaali Binndi ɗii, on anndaa baawɗe Laamɗo ɗee duu. ");
INSERT INTO ffm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sabi so maayɓe immitike, worɓe ɓamataa, rewɓe ɓamataake, ɓe laatoto hono no malaa'ika'en wonɓe dow kammu ɓee nii. ");
INSERT INTO ffm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","E haala immital maayɓe, tama on njanngaali ko Laamɗo wii on koo? O wii: ");
INSERT INTO ffm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","«Miin woni Laamɗo Ibarahiima, Laamɗo Isiyaaka, Laamɗo Yaakuuba.» Laamɗo yo Laamɗo wuurɓe, wanaa Laamɗo maayɓe. ");
INSERT INTO ffm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Waaju makko oo haaynii yimɓe hettindotooɓe mo ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Nde Farisa'en ɓee nani o muɓɓii kunduɗe Saduki'en ɓee e haala ndee, ɓe kawriti. ");
INSERT INTO ffm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Gooto e maɓɓe jannginoowo Sariya yiɗi tuufande mo, lamndii mo, wii: ");
INSERT INTO ffm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Moobbo, honde woni yamiroore ɓurnde fuu teentilaade e ley Tawreeta? ");
INSERT INTO ffm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Iisaa jaabii mo, wii: —Yiɗir Laamɗo Joomiraaɗo maa ɓernde maa fuu e yonki maa fuu e hakkille maa fuu. ");
INSERT INTO ffm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nden woni yamiroore ɓurnde mawnude, ɓurnde teentilaade. ");
INSERT INTO ffm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yamiroore ɗiɗaɓere hono mayre annii: «Njiɗiraa tanaa maa no njiɗir-ɗaa hoore maa nii.» ");
INSERT INTO ffm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Tawreeta Muusaa e dewte annabaaɓe ɗee fuu e ɗeen jamirooje ɗiɗi pawii. ");
INSERT INTO ffm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nde wonnoo Farisa'en ɓee ana kawriti, Iisaa lamndii ɓe, wii: ");
INSERT INTO ffm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—Koɗum miilu-ɗon e Almasiihu oo? O taanii homo? Ɓe njaabii, ɓe mbii: —O taanii Daawuuda. ");
INSERT INTO ffm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","O wii ɓe: —Ndennoo, hono Daawuuda noddirta mo Joomiraaɗo? Ruuhu Laamɗo anndini mo ɗum, saabe majjum o wii: ");
INSERT INTO ffm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","«Joomiraaɗo wii Joomam: Jooɗa ɲaamo am, faa mi waɗa njaɓɓaa wayɓe maa.» ");
INSERT INTO ffm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","So Daawuuda ana noddira mo «Joomam», ndennoo, hono mo laatortoo taanum tan? ");
INSERT INTO ffm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ɓe fuu ɓe ndonki jaabaade mo fay karrol. Gila ɲannde nden, fay gooto suusaali lamndaade mo lamndi goɗɗi. ");
INSERT INTO ffm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nden, Iisaa wii jamaa oo e taalibaaɓe mum ɓee: ");
INSERT INTO ffm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Dunkee'en Sariya ɓee e Farisa'en ɓee kaɲum'en ndokkaa jannginde Sariya Muusaa oo. ");
INSERT INTO ffm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Saabe ɗum, oɗon kaani jaɓande ɓe, ngaɗon huunde fuu ko ɓe mbii on. Kaa pati ɲemmbon golleeji maɓɓe, sabi ɓe ngaɗataa ko ɓe mbaajotoo koo. ");
INSERT INTO ffm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ɓe kaɓɓan donnge tedduɗe, ɓe mbakkina yimɓe, kaa ɓe njiɗaa wallirde ɓeen huncude ɗe fay hoore feɗeendu. ");
INSERT INTO ffm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Huunde fuu ko ɓe ngaɗata, ɓe ngaɗiran ɗum faa ɓe kollinkinoo. Ɗum waɗi so eɓe kaɓɓa talki mawɗi, eɓe njuutina cilmbi saayaaji maɓɓe faa ana ndaasoo. ");
INSERT INTO ffm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Eɓe njiɗi joolle ɓurɗe teddude so ɓe noddaama e yanngeeji, eɓe njiɗi joolle ɓurɗe yiitinkinaade ley cuuɗi baajorɗi. ");
INSERT INTO ffm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ko ɓe njiɗi tan salmineede calminaali tedduɗi ley luumooji e noddoreede «Moobbo». ");
INSERT INTO ffm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kaa onon, pati njaɓee noddoreede «Moobbo», sabi on fuu on sakiraaɓe, Moobbo gooto tan njogi-ɗon. ");
INSERT INTO ffm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Pati mbiyee fay gooto «Baabiraaɗo» e aduna, sabi Baabiraaɗo gooto tan njogi-ɗon, ɗum woni gonɗo dow kammu oo. ");
INSERT INTO ffm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pati njaɓee noddireede «Hooreejo», sabi Hooreejo gooto tan njogi-ɗon, ɗum woni Almasiihu oo. ");
INSERT INTO ffm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ɓurɗo teddude hakkunde mooɗon yo laato gollanoowo heddiiɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Toownuɗo hoore mum fuu, leyɗinte. Leyɗinkiniiɗo fuu toownete. ");
INSERT INTO ffm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Bone yanan e mon onon dunkee'en Sariya e Farisa'en, naafigi'en! Oɗon cokana yimɓe damal Laamu Laamɗo ngal. On naatataa, on accataa naatooɓe naata.  ");
INSERT INTO ffm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Bone yanan e mon, onon dunkee'en Sariya e Farisa'en, naafigi'en! Oɗon njiiloo e leyɗeele oɗon mbanngoo geeci faa keɓon tuubuɗo gooto. So on keɓii ɗum, mbirfito-ɗon kasen, ngaɗon ɗum ɓii jahannama faa sowa on cili ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Bone yanan e mon, onon wumɓe ɗowooɓe yimɓe! Oɗon mbiya: «So neɗɗo hunorike Suudu Dewal Mawndu nduu yo meere, kaa so hunorike kaŋŋe Suudu Dewal Mawndu oo, hunoore mum nanngan ɗum.» ");
INSERT INTO ffm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Majjuɓe, wumɓe! Koɗum ɓuri teentilaade: kaŋŋe oo naa Suudu laɓɓinooru kaŋŋe oo nduu? ");
INSERT INTO ffm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Oɗon mbiya kasen: «So neɗɗo hunorike ittirde sadaka ndee yo meere, kaa so hunorike sadaka gonɗo dow mayre oo, hunoore mum nanngan ɗum.» ");
INSERT INTO ffm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wumɓe! Koɗum hen ɓuri teentilaade: sadaka oo naa ittirde sadaka laɓɓinoore sadaka oo ndee? ");
INSERT INTO ffm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ndennoo, neɗɗo fuu kunoriiɗo ittirde sadaka ndee, hunorike nde kayre e huunde fuu ko fawii e mayre. ");
INSERT INTO ffm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Neɗɗo fuu kunoriiɗo Suudu Dewal Mawndu nduu, hunorike ndu kayru e Laamɗo jooɗiiɗo e mayru oo. ");
INSERT INTO ffm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Neɗɗo fuu kunoriiɗo kammu oo, hunorike jooɗorgal Laamɗo ngal e Jooɗiiɗo e maggal oo. ");
INSERT INTO ffm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Bone yanan e mon, onon dunkee'en Sariya e Farisa'en, naafigi'en! Oɗon ittana Laamɗo jakka naanaa, kaɲum e haakolooji goɗɗi, kaa oɗon njeeboo ko ɓuri teentilaade e Sariya oo koo, hono fooccitaare e yurmeende e goonɗinal. Tawee nee, kaɲum kaanno-ɗon waɗude tawee on njeebaaki ko heddii koo. ");
INSERT INTO ffm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","On wumɓe ɗowooɓe yimɓe! So ɓowngu saamii e njaram mooɗon, on ciiwan itton ɗum, tawee nee, oɗon moɗa ngelooba! ");
INSERT INTO ffm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Bone yanan e mon, onon dunkee'en Sariya e Farisa'en, naafigi'en! Oɗon lawƴa caggal kore looɗe e caggal lehoy, tawee nee ley mum'en ana heewi ko wujjaa e ko yanaa. ");
INSERT INTO ffm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisanke bumɗo! Lawƴu ley kore looɗe tafon, nden caggal ngal duu laaɓan. ");
INSERT INTO ffm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Bone yanan e mon, onon dunkee'en Sariya e Farisa'en, naafigi'en! Oɗon nanndi e janaale dawninaaɗe, ɗe dow mum'en wooɗi tawee ley mum'en ana heewi gi'e e ko soɓi fuu. ");
INSERT INTO ffm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Onon duu hono non mbaa-ɗon: e jiile gite oɗon nanndi e fooccitiiɓe, kaa ley mooɗon ana wii pep naafigaaku e ooɲaare. ");
INSERT INTO ffm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Bone yanan e mon, onon dunkee'en Sariya e Farisa'en, naafigi'en! Oɗon mahana annabaaɓe ɓee cuuɗi dow janaale mum'en, oɗon ŋarɗina janaale fooccitiiɓe ɓee, ");
INSERT INTO ffm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","mbirfito-ɗon mbiyon: «Sinndo min kawriino e jamaanu njaatiraaɓe amen, min ittidataano e maɓɓe yonkiiji annabaaɓe ɗii.» ");
INSERT INTO ffm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Hono non, ceettori-ɗon onon jaati on ɓiɓɓe warannooɓe annabaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ndennoo, kebbintinee saawal golleeji bonɗi ɗi njaatiraaɓe mon puɗɗunoo ɗii! ");
INSERT INTO ffm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Bolle, ɓiɓɓe posoke! Hono fuu miilorto-ɗon waasude wedeede e jahannama? ");
INSERT INTO ffm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ɗum saabii, miɗo nelda on annabaaɓe e hakkilanteeɓe, kaɲum e jannginooɓe. Mbaron yoga, peŋon yoga, piyon yoga dorri e ley cuuɗi mon baajorɗi, njokkon ɗum'en ngeenndi e ngeenndi. ");
INSERT INTO ffm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Yalla yonkiiji laaɓuɓe ittaaɗi e aduna oo ɗii fuu, hakke mum ana fiitoo on, gila yonki Haabiila pooccitiiɗo oo faa yonki Jakariyaa ɓii Barakiya mo mbarno-ɗon hakkunde Suudu Dewal Mawndu e ittirde sadaka oo. ");
INSERT INTO ffm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Miɗo haalana on goonga: jukkungo majjum ɗum fuu e yimɓe oo jamaanu saamata! ");
INSERT INTO ffm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—Hay yimɓe Urusaliima, on mbarii annabaaɓe, on mbardii nelaaɓe e mon kaaƴe! Cili kuurɗi njiɗu-mi hawrintinde ɓiɓɓe mon no cofal hawrintinirta ɓiɓɓe mum ley biifoole mum nii. Kaa on njaɓaali. ");
INSERT INTO ffm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ɗum nee, on ɗaldete e Suudu mon Dewal, ndu laatoo saabeere. ");
INSERT INTO ffm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Miɗo wiya on: on njiyataa kam gila jooni faa wakkati mo mbiyoyton e mum: «Barke woodanii gardoowo e dow innde Joomiraaɗo!» ");
INSERT INTO ffm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nde Iisaa yaltunoo Suudu Dewal Mawndu ndee, taalibaaɓe mum ɓattitii ɗum, kolli ɗum maadiiji galle mayru ɗii. ");
INSERT INTO ffm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","O wii ɓe: —On njii ɗum ɗoo fuu naa? Miɗo haalana on goonga: fay haayre wootere heddataako ɗoo ana fawii dow wonnde, fuu wurjinte. ");
INSERT INTO ffm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nde Iisaa jooɗinoo dow waamnde haayre wiyeteende Jaytun ndee, taalibaaɓe makko ngari e makko kaɲum'en tan, mbii mo: —Humpitin min nde ɗum waɗata. Taagumansa homo hollata gartol maa, kaɲum e timmooɗe aduna? ");
INSERT INTO ffm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","O jaabii ɓe, o wii: —Ndeentee pati fay gooto ƴoɲɲa on. ");
INSERT INTO ffm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Sabi heewɓe ngardan innde am, gooto e mum'en fuu wiya: «Miin woni Almasiihu oo.» Ɓe ƴoɲɲan heewɓe. ");
INSERT INTO ffm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","On nanan golowole e kabaaru golowole kaa pati kulee! Ana tilsi ɗum waɗa, kaa ɗum wanaa timmooɗe tafon. ");
INSERT INTO ffm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Leɲol haɓan e leɲol, laamu haɓan e laamu. Yolbereeji ngaɗan, leydi dimmboto e nokkuuje yogaaje. ");
INSERT INTO ffm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ɗum kaa fuu hono no puɗɗooɗe ŋatawere ɓeynoowo nii. ");
INSERT INTO ffm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nden, yimɓe naɓan on e carirɗi yalla oɗon torree, mbare-ɗon. Leɲi ɗii fuu mbaɲan on saabe am. ");
INSERT INTO ffm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Oon wakkati, heewɓe njoppan goonɗinal mum'en, ana njammbondira ana mbaɲondira e ko'e mum'en. ");
INSERT INTO ffm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Annabaaɓe peneeɓe heewɓe ɓanngan, ƴoɲɲa heewɓe. ");
INSERT INTO ffm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bonanndaaji keewan faa jilli yimɓe heewɓe ɓuuɓta. ");
INSERT INTO ffm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kaa muɲuɗo faa timmooɗe, joomum hisinte. ");
INSERT INTO ffm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Oo ɗoo Kabaaru Lobbo haala Laamu Laamɗo ooynete e aduna oo fuu, yalla leɲi ɗii fuu ana keɓa seedaaku oo. Nden, aduna timmata. ");
INSERT INTO ffm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—Nde njii-ɗon «huunde harmunde bonnde», ko annabi Daniyel haalnoo koo ana e nokku ceniiɗo oo (jannguɗo ɗum, tiinnoo faama) ");
INSERT INTO ffm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","nden, tawaaɓe ley Yahuudiya fuu yo ndogu peewa baamle kaaƴe. ");
INSERT INTO ffm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tawaaɗo dow bene, pati wiya ɓaman kaaki ley suudu mum. ");
INSERT INTO ffm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tawaaɗo gese, pati wirfoo so wiya ɓamoowo saaya mum. ");
INSERT INTO ffm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Bone yanan e haamili'en e muyninooɓe ley ɗeen ɲalaaɗe! ");
INSERT INTO ffm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ɲaagee Laamɗo pati doddu mon laatoo wakkati dabbunde naa ɲalaande fowteteende. ");
INSERT INTO ffm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sabi nden, torra mawɗo waɗan mo hono mum waɗaali gila puɗɗooɗe aduna, hono makko waɗataa abada kasen. ");
INSERT INTO ffm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sinndo tawiino ɗeen ɲalaaɗe ndaɓɓinɗinaaka, fay gooto e ɓiɓɓe aadama hisataano. Kaa Laamɗo raɓɓinɗinirii ɗe sabaabu ɓe o suɓii ɓee. ");
INSERT INTO ffm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","E oon wakkati, so won biiɗo on: «Ƴeewee! Almasiihu annii ɗoo», naa «Omo naa too», pati ngoonɗinee. ");
INSERT INTO ffm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sabi almasiihu'en peneeɓe e annabaaɓe peneeɓe ɓanngoyan, ɓe ngaɗa taagumansaaji mawɗi e kaayeefiiji yalla eɓe majjina fay suɓaaɓe ɓee, so ɓe mbaawii. ");
INSERT INTO ffm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Paamee gasa. Mi haalanii on gila ɗum waraali. ");
INSERT INTO ffm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","So won biiɗo on: «Ƴeewee, omo naa ley ladde jeereende», pati njehee. Naa so won biiɗo on: «Ƴeewee, omo naa to ley cuuɗi too», pati ngoonɗinee. ");
INSERT INTO ffm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Hono no majere fooynirta kammu gila funnaange faa hiirnaange nii, hono non Ɓii Neɗɗo oo wardata. ");
INSERT INTO ffm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ɗo jiibe ngoni fuu, ɗon dute kawritata. ");
INSERT INTO ffm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Ɗon e ɗon, caggal torra ley ɗeen ɲalaaɗe, naange niɓɓan, lewru ŋoottan yaaynude, koode kammu caaman, kulle gonɗe dow kammu ɗee ndimmboto. ");
INSERT INTO ffm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","E oon wakkati, taagumansa Ɓii Neɗɗo oo ɓanngan e mbeeyu, leɲi aduna ɗii fuu ngullan. Ɓe njiyan Ɓii Neɗɗo oo, ana wara e duule, ana warda baawɗe mawɗe e teddeengal. ");
INSERT INTO ffm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Buututal manngal fuufete, o nela malaa'ika'en makko funnaange e hiirnaange, saahal e ɓaleeri, mooɓta suɓaaɓe makko ɓee gila hoore leydi faa hoore leydi. ");
INSERT INTO ffm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Taykitee ibbe: so caɓe majje keyɗitii, haakolooji majje mbillitii, oɗon anndi ndunngu ɓadike. ");
INSERT INTO ffm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hono non, so on njii ɗum fuu, anndee wakkati oo ɓattiima, omo damal galle. ");
INSERT INTO ffm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Miɗo haalana on goonga: oo jamaanu timmataa tawee kuɗɗe ɗee fuu ngaɗaali. ");
INSERT INTO ffm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kammu e leydi timman, kaa haalaaji am ɗii timmataa abada. ");
INSERT INTO ffm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Kaa nden ɲalaande e oon wakkati fay gooto anndaa ɗum, wanaa malaa'ika'en wonɓe dow kammu, wanaa Ɓiɗɗo oo. Walaa annduɗo ɗum so wanaa Baabiraaɗo oo. ");
INSERT INTO ffm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","No jamaanu Nuuhu nii, hono non nanndata so Ɓii Neɗɗo oo ana wara. ");
INSERT INTO ffm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","E ley ɗeen ɲalaaɗe fade ilam tuufaanu ɗam warde, yimɓe ana ɲaama, ana njara, ana ndewla, ana ndewlee, faa ɲannde Nuuhu naati laana kaa. ");
INSERT INTO ffm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ɓe miilaali, ɓe njaalaali faa ilam tuufaanu ɗam wari yooli ɓe fuu. Garol Ɓii Neɗɗo oo hono non nanndata. ");
INSERT INTO ffm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","E oon wakkati, worɓe ɗiɗon wonɓe e ngesa ngoota, gooto mum'en naɓete, goɗɗo oo yoppee. ");
INSERT INTO ffm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Rewɓe ɗiɗon undooɓe dow unirde wootere, gooto mum'en naɓete, goɗɗo oo yoppee. ");
INSERT INTO ffm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ndennoo, njeertee, sabi on anndaa wakkati mo Joomiraaɗo mon warata. ");
INSERT INTO ffm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Paamee ɗum ɗoo: sinndo jom galle ana anndunoo wakkati mo gujjo warata ley jemma, ɗaanataako yoppataa o naata galle mum. ");
INSERT INTO ffm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ɗum nee, onon duu lanndinee, sabi Ɓii Neɗɗo oo waran e wakkati mo on miilaali. ");
INSERT INTO ffm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—Ndennoo, homo woni golloowo koolniiɗo, hakkilante? Oon woni mo kalfaaɗo mum halfini ɗum koreeji mum faa hokka ɗum'en nguure mum'en e wakkati jiɗaaɗo. ");
INSERT INTO ffm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Golloowo mo kalfaaɗo mum warti tawi ana hiinnii golle mum, welii hoore. ");
INSERT INTO ffm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Miɗo haalana on goonga: kalfaaɗo oo halfinan mo jawdi mum fuu. ");
INSERT INTO ffm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kaa so golloowo oo yo bonɗo, wii e hoore mum kalfaaɗo mum ɓooyan wartaali, ");
INSERT INTO ffm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","hedde ana fiya waayiraaɓe mum gollooɓe ɓee, ana ɲaamda ana yarda e sigirooɓe, ");
INSERT INTO ffm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","nden, kalfaaɗo oo wartiran ɲalooma mo golloowo oo anndaa e wakkati mo o miilaali, ");
INSERT INTO ffm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","jukka mo jukkungo naawngo, watta mo hakkunde naafigi'en, ton o wullata o ŋerƴondira ɲiiƴe. ");
INSERT INTO ffm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","—Laamu Laamɗo oo nanndan e oo janta: surbayɓe sappo ɓamɓe moottilaaji mum'en so njehi jaɓɓoyaade jommbaajo gorko. ");
INSERT INTO ffm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Njoyon ɓee ƴoƴaa, njoyon woɓɓe ɓee ana ƴoƴi. ");
INSERT INTO ffm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɓe ƴoƴaa ɓee ɓami moottilaaji tawi njooɓaaki bulannga, ");
INSERT INTO ffm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ƴoƴuɓe ɓee noo naɓori paali bulannga. ");
INSERT INTO ffm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nde jommbaajo oo jenngi waraali ndee, ɓe fuu ɓe ŋoŋi, ɓe ɗaanii. ");
INSERT INTO ffm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Faa hejjere jemma, wullaango nanaa, wii: «Jommbaajo oo warii! Njaltee! Njaɓɓoyee mo!» ");
INSERT INTO ffm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nden ɓe fuu ɓe pini, eɓe moƴƴina moottilaaji maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Surbayɓe ɓe ƴoƴaa ɓee mbii ƴoƴuɓe ɓee: «Ndokkoree min e bulannga mon mo njooɓi-ɗon oo, sabi moottilaaji amen annii ɲifa.» ");
INSERT INTO ffm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ƴoƴuɓe ɓee mbii: «Huɓindaaki, sabi ko min njogii koo hejjataa en, en fuu. Njehee to soottooɓe, coodoyon!» ");
INSERT INTO ffm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","E ley no ɓe ƴoƴaa ɓee njaari soodoyde bulannga nii, jommbaajo oo yottii. Lanndininooɓe ɓee naatidi e makko e ley dammbordu nduu, damal ngal uddaa. ");
INSERT INTO ffm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Faa ɓooyi seeɗa, surbayɓe heddiiɓe ɓee ngarti, hedde ana ngulla ana mbiya: «Kalfaaɗo, kalfaaɗo, udditan min!» ");
INSERT INTO ffm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kaa o jaabii ɓe, o wii: «Miɗo haalana on goonga: mi anndaa on.» ");
INSERT INTO ffm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iisaa sakitii wiide: —Njeertee, sabi on anndaa ɲalaande naa e wakkati mo Ɓii Neɗɗo warata e mum. ");
INSERT INTO ffm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","—Laamu Laamɗo ana nanndi e gorko lanndiniiɗo faa dawa, noddi gollooɓe mum, halfini ɗum'en jawdi mum. ");
INSERT INTO ffm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","O halfini gooto maɓɓe mutakal teemeɗe joy kaŋŋe, goɗɗo teemeɗe ɗiɗi, tataɓo oo teemedere, gooto fuu ko waarata e mum. Caggal ɗum, o dawi. Ɗon e ɗon, ");
INSERT INTO ffm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","golloowo keɓuɗo mutakal teemeɗe joy kaŋŋe oo yehi jaagoroyii mo, tinorii mutakal teemeɗe joy goɗɗe. ");
INSERT INTO ffm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kalfinaaɗo mutakal teemeɗe ɗiɗi kaŋŋe oo duu waɗi non, tinorii kaɲum duu mutakal teemeɗe ɗiɗi goɗɗe. ");
INSERT INTO ffm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kaa kalfinaaɗo mutakal teemedere kaŋŋe oo yehi asoyi ngayka, iri ton ko kalfaaɗo mum oo hokkunoo ɗum koo. ");
INSERT INTO ffm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Faa ɓooyi caggal mum, kalfaaɗo maɓɓe oo warti noddi ɓe, o ƴeewi jate maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kalfinaaɗo mutakal teemeɗe joy kaŋŋe oo wari, waddi mutakal teemeɗe joy goɗɗe, wii: «Kalfaaɗo am, mutakal teemeɗe joy kalfin-ɗaa kam, eɗe nii. Ƴeew, mi tinorike ɗe mutakal teemeɗe joy goɗɗe.» ");
INSERT INTO ffm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kalfaaɗo makko oo wii mo: «Golle maa gasii sanne golloowo lobbo, koolniiɗo. Nde wonnoo a hoolnike e ko famɗi, mi halfinte ko teentilii sanne. War naatu faa ceyodo-ɗen!» ");
INSERT INTO ffm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Golloowo kalfinaaɗo mutakal teemeɗe ɗiɗi kaŋŋe oo wari kaɲum duu, wii: «Kalfaaɗo am, mutakal teemeɗe ɗiɗi kaŋŋe kalfin-ɗaa kam, eɗe nii. Ƴeew, mi tinorike ɗe mutakal teemeɗe ɗiɗi goɗɗe.» ");
INSERT INTO ffm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kalfaaɗo makko oo wii mo: «Golle maa gasii sanne golloowo lobbo, koolniiɗo. Nde wonnoo a hoolnike e ko famɗi, mi halfinte ko teentilii sanne. War naatu faa ceyodo-ɗen!» ");
INSERT INTO ffm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kalfinaaɗo mutakal teemedere kaŋŋe oo wari kaɲum duu, wii: «Kalfaaɗo am, miɗo anndunoo a gorko tiiɗuɗo alhaali: aɗa hetta ko a aawaali, aɗa mooɓta ko a tutaali. ");
INSERT INTO ffm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Saabe ɗum, mi hulii, njaa-mi iroy-mi kaŋŋe maa oo. Haya, fii maa annii!» ");
INSERT INTO ffm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Kalfaaɗo makko jaabii mo, wii: «Golloowo laaliiɗo, nattuɗo! So tawii aɗa anndunoo miɗo hetta ko mi aawaali, miɗo mooɓta ko mi tutaali, ");
INSERT INTO ffm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ndennoo, aɗa haannoo waɗude kaŋŋe am oo e banki, yalla ana daɲa ko tinorii-mi so mi wartoyii. ");
INSERT INTO ffm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jooni, teetee mo mutakal teemedere kaŋŋe oo, ndokkon ɗum jom mutakal teemeɗe joy kaŋŋe oo. ");
INSERT INTO ffm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sabi jogiiɗo fuu ɓeydante faa heewa. Kaa mo walaa, fay seeɗa mo jogii oo teetete. ");
INSERT INTO ffm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Golloowo meereejo oo kaa, mbedee ɗum e ley nimre sella ndee, ton o wullata o ŋerƴondira ɲiiƴe.» ");
INSERT INTO ffm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—So Ɓii Neɗɗo oo warii e teddungal mum, kaɲum e malaa'ika'en ɓee fuu, o jooɗoto e jooɗorgal makko laamu ngal. ");
INSERT INTO ffm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Yimɓe aduna ɓee fuu mooɓtete yeeso makko, o faltoroo ɓe no duroowo faltortoo baali e be'i nii: ");
INSERT INTO ffm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","o waɗan baali ɗii e junngo makko ɲaamo, o waɗa be'i ɗii e junngo makko nano. ");
INSERT INTO ffm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Hono nii, Kaananke oo wiirata wonɓe junngo mum ɲaamo ɓee: «Ngaree, onon barkinaaɓe Baabiraaɗo am, nanngee laamu mo ndesane-ɗon gila e puɗɗooɗe aduna oo. ");
INSERT INTO ffm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sabi mi yolbiino, on ɲamminii kam, mi ɗomɗiino, on njarnii kam, mi laatinoke koɗo, on njippinii kam, ");
INSERT INTO ffm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mi holiino, on koltinii kam, mi ɲawiino, on njanɗinii kam, mi uddanooma kasu, on ƴeewoyii kam.» ");
INSERT INTO ffm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","E oon wakkati, fooccitiiɓe ɓee njaabotoo mo, mbiya: «Joomiraaɗo, mande min njii maa aɗa yolbi, min ɲammin maa naa aɗa ɗomɗi, min njarnu maa? ");
INSERT INTO ffm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Mande min njii maa a koɗo, min njippin maa naa a kolɗo, min koltin maa? ");
INSERT INTO ffm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mande min njii maa a ɲawɗo naa a uddaaɗo kasu, min ngari ƴeewde ma?» ");
INSERT INTO ffm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Kaananke oo jaaboo ɓe wiya: «Miɗo haalana on goonga: ko ngaɗan-ɗon gooto e ɓurɗo famɗude e sakiraaɓe am ɓee, yo miin ngaɗan-ɗon.» ");
INSERT INTO ffm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Caggal ɗum, o wiyan wonɓe junngo makko nano ɓee: «Ngoɗɗee kam, onon huɗaaɓe Laamɗo! Njehee ley yiite duumiinge nge Laamɗo resani Ibiliisa e malaa'ika'en mum ngee! ");
INSERT INTO ffm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sabi mi yolbiino, on ɲamminaali kam, mi ɗomɗiino, on njarnaali kam, ");
INSERT INTO ffm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mi koɗo, on njippinaali kam, mi kolɗo, on koltinaali kam, mi ɲawɗo naa mi uddanooma, on ngaraali ƴeewde kam.» ");
INSERT INTO ffm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nden, ɓe njaaboto mo kamɓe duu ɓe mbiya: «Joomiraaɗo, mande min njii maa aɗa yolbi naa aɗa ɗomɗi naa a koɗo naa a kolɗo naa a ɲawɗo naa aɗa uddaa kasu, min paabaaki ma?» ");
INSERT INTO ffm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","O jaaboto ɓe o wiya: «Miɗo haalana on goonga: ko mbaasu-ɗon waɗande gooto e ɓee ɗoo ɓurɓe famɗude koo, miin woni mo on ngaɗanaali.» ");
INSERT INTO ffm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nden, ɓeen njaha e jukkungo duumiingo, fooccitiiɓe ɓee keɓa nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nde Iisaa timmini ɗiin waajuuji fuu ndee, wii taalibaaɓe mum ɓee: ");
INSERT INTO ffm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Oɗon anndi balɗe ɗiɗi palii en e iidi Paska, Ɓii Neɗɗo oo hokkitirte tontee e leggal bardugal. ");
INSERT INTO ffm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","E oon wakkati, hooreeɓe yottinooɓe sadaka e mawɓe Yahuudiyankooɓe ɓee kawritoyi galle Jottinoowo Sadaka Mawɗo biyeteeɗo Kayafas. ");
INSERT INTO ffm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ɓe fuu ɓe ndawridi faa ɓe njammboroo Iisaa hiila, ɓe mbara ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kaa ɓe mbii: —Pati ngaɗen ɗum ley iidi oo so yimɓe ɓee murta. ");
INSERT INTO ffm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nde wonnoo Iisaa ana Baytaniya ɗo galle Simon ceppaaɗo oo ɗoo, ");
INSERT INTO ffm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","debbo gooto ɓattitii ɗum ana jogii faandu nebam uuroojam, tiiɗuɗam coggu sanne. O tawi Iisaa ana ɲaama, o wuji ɗam dow hoore mum. ");
INSERT INTO ffm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nde taalibaaɓe ɓee njii ɗum ndee, mettaa, ana mbiya: —Ko woni oo bonannda meere meere? ");
INSERT INTO ffm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Eɗam waawnoo sootteede kaalisi keewɗo, kaalisi oo hokkee misikiina'en. ");
INSERT INTO ffm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Iisaa faami ko ɓe kaalannoo koo, wii ɓe: —Ko saabii so oɗon torra oo debbo? O gollanii kam golle ŋarɗuɗo. ");
INSERT INTO ffm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Sabi misikiina'en ana tawdee e mon ɲannde fuu. Kaa miin, mi tawdataake e mon ɲannde fuu. ");
INSERT INTO ffm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","O wujii terɗe am nebam uuroojam, ko o waɗiri ɗum yalla omo lanndinanoo kam yanaande. ");
INSERT INTO ffm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Miɗo haalana on goonga: ɗo Kabaaru Lobbo waajaa e aduna oo fuu, ko oo debbo waɗi koo jantete, kasen duu o miccitete. ");
INSERT INTO ffm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nden Yahuuda Isikariyota, gooto e taalibaaɓe sappo e ɗiɗon ɓee, yehi to hooreeɓe yottinooɓe sadaka, ");
INSERT INTO ffm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","wii ɗum'en: —Ko ndokkaton kam so mi waddanii on Iisaa? Ɓe njakkii buuɗi capantati cardi, ɓe ndokki mo. ");
INSERT INTO ffm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Gila nden, omo fiya dabare no o jammbortoo Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","E ɲalooma arano iidi mo buuru ƴuufinaaka, taalibaaɓe ɓee ngari, lamndii Iisaa, mbii ɗum: —Hoto njiɗ-ɗaa min lanndinoyoo hiraande iidi Paska ndee? ");
INSERT INTO ffm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","O jaabii ɓe, o wii: —Njehee ngeenndi too, naaton galle maani, mbiyon ɗum: «Moobbo wii, wakkati mum yonii, e galle maa oo waɗata iidi Paska oo, kanko e taalibaaɓe makko.» ");
INSERT INTO ffm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Taalibaaɓe ɓee ngaɗi ko Iisaa yamirnoo ɗum'en koo, lanndinii hiraande ndee. ");
INSERT INTO ffm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Hiiri, o jooɗodii e taalibaaɓe sappo e ɗiɗon ɓee faa ɓe kirtoo. ");
INSERT INTO ffm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Nde ɓe kirtotoo ndee, o wii: —Miɗo haalana on goonga: gooto mooɗon jammboto kam. ");
INSERT INTO ffm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ɓe cuŋli sanne, hedde eɓe lamndoroo mo gooto gooto, gooto fuu ana wiya: —Moobbo, kori wanaa miin? ");
INSERT INTO ffm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","O jaabii, o wii: —Tummbidiɗɗo e am junngo mum e la'al oo, oon jammbotoo kam. ");
INSERT INTO ffm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Waajibi Ɓii Neɗɗo ɗalira aduna no haaliraa ley Binndi ɗii nii. Kaa bone woodanii jammbotooɗo Ɓii Neɗɗo oo! Oon gorko, so rimanooka fey ɓuri moƴƴande ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuuda garoowo jammbaade mo oo ɓami haala, lamndii mo, wii: —Moobbo, kori wanaa miin? O jaabii ɗum, o wii: —Aan haaldi hunduko maa. ");
INSERT INTO ffm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nde ɓe ɲaamata ndee, Iisaa ɓami buuru, yetti Laamɗo, helti, hokki taalibaaɓe mum ɓee, wii: —Nanngee, ɲaamee, ɗum yo terɗe am. ");
INSERT INTO ffm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Caggal ɗum, o ɓami horde peguujam, o yetti Laamɗo, o hokki ɓe, o wii: —On fuu, njaree hen. ");
INSERT INTO ffm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ɗum yo ƴiiƴam am, ƴiiƴam tabintinoojam aadi keyri, njupportooɗam saabe heewɓe faa luutti njaafee. ");
INSERT INTO ffm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Miɗo wiya on: abada mi yarataa ɗam peguujam kasen so wanaa ɲannde njardoy-ɗen peguujam kesam e ley LaamuBaabiraaɗo am. ");
INSERT INTO ffm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Caggal ɓe njimii Jabuura, ɓe njalti, ɓe njehi waamnde haayre wiyeteende Jaytun. ");
INSERT INTO ffm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","E oon wakkati, Iisaa wii ɓe: —E ley oo jemma jaati, on fuu on njoppan kam, sabi ana winndii: «Mi fiyan duroowo oo, mi wara ɗum, sewre baali ndee saakoo.» Iisaa ɓeydi hen, wii: ");
INSERT INTO ffm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—Kaa caggal mi wuurtii, mi adoyto on Galili. ");
INSERT INTO ffm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nden Piyeer ɓami haala, wii mo: —Fay so ɓe fuu ɓe njoppu maa, miin kaa abada mi yoppataa ma. ");
INSERT INTO ffm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iisaa jaabii mo, wii: —Miɗo haalane goonga: jemma hannde oo jaati, fade ndontoori jogginde a wiyan a anndaa kam cili tati. ");
INSERT INTO ffm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piyeer wii mo: —Fay so tilsi mi maaydan e maa, abada mi wiyataa mi anndaa ma. Taalibaaɓe ɓee fuu mbii hono non. ");
INSERT INTO ffm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Caggal ɗum, Iisaa yottodii e maɓɓe nokku biyeteeɗo Gecemane, wii ɓe: —Njooɗee ɗoo, faa mi waɗoya too duwaawu. ");
INSERT INTO ffm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","O yaadi e Piyeer e ɓiɓɓe Jebede ɗiɗon ɓee, ɓernde makko fuɗɗi maatude yoomeende e ruubu. ");
INSERT INTO ffm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","E ley ɗum, o wii ɓe: —Yoomeende ana mawni e am sanne faa ana ndaara warde kam. Keddee ɗoo, njeertodee e am pati ɗaano-ɗon. ");
INSERT INTO ffm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","O woɗɗitii seeɗa, o hippii e leydi, omo duwoo, omo wiya: —Baabiraaɗo, so tawii ana laatoo, woɗɗinam ndee horde bone. Kaa pati laatoroo no njiɗir-mi, yo laatoro no njiɗir-ɗaa aan. ");
INSERT INTO ffm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","O warti, o tawi eɓe ɗaanii. O wii Piyeer: —On mbaawaa jeertodaade e am tawee on ɗaanaaki fay wakkati gooto naa? ");
INSERT INTO ffm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pati ɗaanee, nduwee, pati on ceyte. Sabi hakkille ana heewi anniya lobbo, kaa terɗe ana lo'i. ");
INSERT INTO ffm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","O yehi kasen, o duwii, o wii: —Baabiraaɗo, so tawii nden horde bone waawaa woɗɗineede so wanaa mi yara ɗum, yo sago maa waɗu! ");
INSERT INTO ffm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","O warti, o tawi ɓe ɗaantike, sabi ɗoyɗi ana piilii e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","O yehi kasen, o duwii tataɓerde hono no o duworinoo nii. ");
INSERT INTO ffm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Caggal ɗum, o warti e taalibaaɓe ɓee, o wii ɗum'en: —Faa jooni oɗon ɗaanii oɗon ŋoottinoo? Ƴeewee, wakkati oo yottike! Ɓii Neɗɗo oo waɗete e juuɗe luuttooɓe. ");
INSERT INTO ffm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Immee njehen! Ƴeewee, jammbotooɗo kam oo annii wara! ");
INSERT INTO ffm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","O tilaaki haalde, faa Yahuuda, gooto e sappo e ɗiɗon ɓee, yottii ana wondi e yimɓe heewɓe jogiiɓe kaafaaje e cabbi. Hooreeɓe yottinooɓe sadaka ɓee e mawɓe Yahuudiyankooɓe ɓee neli ɓe. ");
INSERT INTO ffm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jammbotooɗo mo oo hokki ɓe finnde, wii: —Neɗɗo mo ɓuccii-mi fuu, oo woni kanko. Nanngee ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ɗon e ɗon, Yahuuda ɓattitii Iisaa, wii ɗum: —Saɗi Moobbo! O ɓuccii ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Iisaa jaabii mo, wii: —Giɗam, waɗu ko waddu maa koo. E oon wakkati, ɓe ɓattitii, ɓe njani e Iisaa, ɓe nanngi ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Gooto e wondunooɓe e Iisaa ɓee soorti kaafaawi mum, soppi golloowo Jottinoowo Sadaka Mawɗo taƴi nowru mum. ");
INSERT INTO ffm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Nden, Iisaa wii mo: —Soornu kaafaawi maa kii e ŋaro mum, sabi jogotooɗo kaafaawi fuu, kaafaawi halkata ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Naa aɗa miila jooni mi waawaa noddude Baabiraaɗo am nelda kam ko ɓuri konuuji sappo e ɗiɗi malaa'ika? ");
INSERT INTO ffm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kaa so non laatorii, hono ko winndaa ley Binndi ɗii koo tabitirta? Sabi ɗi mbii hono non ɗum laatotoo. ");
INSERT INTO ffm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","E oon wakkati, o wii jamaa oo: —Ko ngardu-ɗon e kaafaaje e cabbi faa nanngon kam hono mi janoowo? Ley Suudu Dewal Mawndu nduu ngonannoo-mi ɲannde fuu miɗo janngina, on nanngaali kam. ");
INSERT INTO ffm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kaa ɗum fuu waɗan yalla Binndi annabaaɓe ɗii ana tabita. Nden, taalibaaɓe ɓee fuu njoppi mo, ndogi. ");
INSERT INTO ffm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nannguɓe Iisaa ɓee naɓi ɗum to Kayafas Jottinoowo Sadaka Mawɗo oo, tawi dunkee'en Sariya ɓee e mawɓe leɲol ɓee ana kawritinnoo ton. ");
INSERT INTO ffm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piyeer jokkitii mo fali daawre hakkunde maɓɓe, faa daalaare galle Jottinoowo Sadaka Mawɗo oo. O naati ley galle oo, o jooddii e doomooɓe ɓee faa o yiya no ɗum sakitortoo. ");
INSERT INTO ffm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Hooreeɓe yottinooɓe sadaka e waalde Saahiiɓe ndee fuu ana tewta fenaande nde kappira Iisaa yalla ana waree. ");
INSERT INTO ffm_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Fay so taweede yimɓe heewɓe ngari seedanaade mo pene, ɓe keɓaali sabaabu fuu ko waawi warde mo. Ko sakitii koo, worɓe ɗiɗon ngari, ");
INSERT INTO ffm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","mbii: —Kanko wiinoo omo waawi wurjinde Suudu Dewal Laamɗo, o mahitoo ndu ley balɗe tati. ");
INSERT INTO ffm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jottinoowo Sadaka Mawɗo oo immii, wii Iisaa: —A jaabataako fay huunde naa? Tama a nanaali ko ɓe mbiyete koo? ");
INSERT INTO ffm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Fuu omo deƴƴinii. Jottinoowo Sadaka Mawɗo oo wii mo: —Miɗo lamndore saabe Laamɗo guurɗo oo, haalan min so tawii aan woni AlmasiihuƁii Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","O jaabii ɗum, o wii: —No mbii-ɗaa nii. Kasen, miɗo wiya on fuu: gila jooni, on njiyan Ɓii Neɗɗo ana jooɗii ɲaamo Jom Baawɗe oo, ana wara dow duule kammu. ");
INSERT INTO ffm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","E ley ɗum, Jottinoowo Sadaka Mawɗo oo mettaa faa seeki kaddule mum, wii: —O bonkike Laamɗo! En kaajaaka seedee'en hankasen! On narrii noppi mooɗon ko o bonkii Laamɗo koo. ");
INSERT INTO ffm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Koɗum njii-ɗon hen? Ɓe njaabii, ɓe mbii: —Omo haani wareede. ");
INSERT INTO ffm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Caggal ɗum, ɓe tutti e yeeso makko, ɓe culkii mo. Yoga maɓɓe ana piya mo banaaje ");
INSERT INTO ffm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ana mbiya: —Almasiihu! Haalan min piiɗo ma, so a annabaajo. ");
INSERT INTO ffm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piyeer jooɗii sella e daalaare galle oo. Gooto e horɓe ɓee ɓattitii mo, wii: —Aan, aɗa wondunoo e Iisaa Galilinke oo. ");
INSERT INTO ffm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Nii o yeddi ɗum hakkunde yimɓe fuu, o wii: —Mi faamataa ko kaalataa koo. ");
INSERT INTO ffm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Caggal ɗum, o fa'i to damal galle too. Korɗo goɗɗo yii mo, wii wonɓe ɗon ɓee: —Oo gorko e Iisaa Nasaraatunke oo wondunoo. ");
INSERT INTO ffm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piyeer yeddi kasen, wii: —Mi hunike, mi anndaa oo gorko. ");
INSERT INTO ffm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Faa ɓooyi seeɗa, wonɓe ɗon ɓee ɓattii Piyeer, mbii ɗum: —Taƴoral, e maɓɓe njeye-ɗaa, sabi ɗemngal maa ngal hollii to iw-ɗaa. ");
INSERT INTO ffm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","E ley ɗum, Piyeer darii ana hunoo ana huttoo ana wiya: —Mi anndaa oo gorko! Oon wakkati fuu, ndontoori joggini, ");
INSERT INTO ffm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","non Piyeer miccitii ko Iisaa wiinoo ɗum koo: «Fade ndontoori jogginde, a wiyan a anndaa kam cili tati.» O yalti sella, o darii omo woya faa omo heppiƴa. ");
INSERT INTO ffm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Beetee law, hooreeɓe yottinooɓe sadaka ɓee e mawɓe leɲol ɓee fuu njooddii faa ƴeewa no mbarda Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ɓe kaɓɓi mo, ɓe naɓi mo to Pilaatu goforneer oo. ");
INSERT INTO ffm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nde Yahuuda jammbiiɗo Iisaa oo yii no o sariraa o bareteeɗo nii, mimsiti, wartiri buuɗi capantati cardi ɗii to hooreeɓe yottinooɓe sadaka e mawɓe leɲol ɓee, ");
INSERT INTO ffm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","wii ɗum'en: —Mi luuttii ko njammbii-mi mo wiyaali waɗaali oo koo! Nii ɓe njaabii mo, ɓe mbii: —Ko hilli min? Aan anndi! ");
INSERT INTO ffm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yahuuda tippii kaalisi oo ley Suudu Dewal Mawndu nduu. Caggal ɗum, o ɓami ɓoggol, o wartoyii. ");
INSERT INTO ffm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Hooreeɓe yottinooɓe sadaka ɓee ɓami kaalisi oo, mbii: —E sariya meeɗen daganaaki en wattude oo kaalisi e keesu oo, sabi ɗum diyo. ");
INSERT INTO ffm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Caggal ɓe ndawridii, ɓe ɓami kaalisi oo, ɓe coodi ɗum ngesa e junngo mahoowo looɗe faa waɗee jenaale joolaa'en. ");
INSERT INTO ffm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ɗum waɗi so ngaan ngesa ana wiyee faa jooni «Ngesa Ƴiiƴam». ");
INSERT INTO ffm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nden haala ka Laamɗo yottinirnoo annabi Yeremiya kaa tabiti nde oon wii: «Ɓe ɓamii buuɗi capantati cardi, coggu mo yimɓe Israa'iila njatorii yonki makko, ");
INSERT INTO ffm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ɓe coodi ɗum ngesa mahoowo looɗe, hono no Joomiraaɗo yamirnoo kam nii.» ");
INSERT INTO ffm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Iisaa darii yeeso goforneer oo, oon lamndii mo, wii: —Aan woni kaananke Yahuudiyankooɓe oo naa? O jaabii, o wii: —No mbii-ɗaa nii. ");
INSERT INTO ffm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kaa nde hooreeɓe yottinooɓe sadaka ɓee e mawɓe leɲol ɓee kappi mo ndee, o jaabaaki fay huunde. ");
INSERT INTO ffm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ɗum waɗi so Pilaatu wii mo: —A nanaali ko ɓe ceettante koo fuu naa? ");
INSERT INTO ffm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kaa o jaabaaki hen fay karrol. Ɗum haaynii goforneer oo sanne. ");
INSERT INTO ffm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Iidi Paska fuu, goforneer oo ana hokkannoo yimɓe ɓee suɓaade e kasunkooɓe ɓee mo njiɗi yoppitaneede. ");
INSERT INTO ffm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","E oon wakkati, ana woodunoo kasunke jom innde biyeteeɗo Iisaa Barabas. ");
INSERT INTO ffm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","E ley no jamaa oo mooɓtorii nii, Pilaatu lamndii ɓe, wii: —Homo njiɗ-ɗon mi yoppitana on: Iisaa Barabas naa, naa Iisaa biyeteeɗo Almasiihu oo? ");
INSERT INTO ffm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Sabi Pilaatu ana anndunoo haasidaaku waɗi so ɓe ndokkitiri Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kasen, nde o jooɗii to sarirde too ndee, jom suudu makko neli e makko, wii: —Sel e oo gorko pooccitiiɗo, sabi jemma hanken koyɗi makko tampinii kam sanne. ");
INSERT INTO ffm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Hooreeɓe yottinooɓe sadaka ɓee e mawɓe leɲol ɓee ndunƴi jamaa oo ɲaagoo Pilaatu yoppitana ɓe Barabas, wara Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Goforneer oo lamnditii ɓe: —Homo e ɗiɗon ɓee njiɗ-ɗon mi yoppitana on? Ɓe njaabii, ɓe mbii: —Barabas! ");
INSERT INTO ffm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilaatu lamndii ɓe, wii: —Ndennoo, hono ngaɗan-mi Iisaa biyeteeɗo Almasiihu oo? Ɓe fuu ɓe njaabii, ɓe mbii: —Tontu mo e leggal bardugal! ");
INSERT INTO ffm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","O lamndii ɓe, o wii: —Koɗum o waɗi ko boni? Ɓe ɓeydii dukude semmbe, eɓe mbiya: —Tontu mo e leggal bardugal! ");
INSERT INTO ffm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Nden Pilaatu yii walaa ko waawi hen, tawi duko ngoo duu ana ɓeydii sanne, o ɓami ndiyam, o looti juuɗe makko yeeso yimɓe ɓee, o wii ɓe: —Mi woytirtaake yonki oo gorko. Ɗum yo kunkoo mon. ");
INSERT INTO ffm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ɓe fuu ɓe njaabii, ɓe mbii: —Yonki makko ana jonngii dow amen, minen e ɓiɓɓe amen! ");
INSERT INTO ffm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","E oon wakkati, Pilaatu yoppitani ɓe Barabas, yamiri Iisaa fiyee dorri, caggal ɗum, o hokkitiri ɗum tontoyee e leggal bardugal. ");
INSERT INTO ffm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Sordaasi'en goforneer ɓee naɓi Iisaa ley galle to huɓeere ndee woni too, fedde sordaasi'en ɓee fuu pilii mo. ");
INSERT INTO ffm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ɓe ɓoorti mo kaddule makko, ɓe ɓoorni mo burmusuure woɗeere. ");
INSERT INTO ffm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Caggal ɗum, ɓe caɲi tenngaade gi'e, ɓe kippi e hoore makko. Ɓe ngaɗi kasen kalacal e junngo makko ɲaamo, ɓe ndiccii yeeso makko, hedde eɓe njaayra mo eɓe mbiya: —Saɗi, kaananke Yahuudiyankooɓe! ");
INSERT INTO ffm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ɓe tutti e makko, ɓe ɓami kalacal ngal eɓe piya e hoore makko. ");
INSERT INTO ffm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Nde ɓe tilii jaayrude mo ndee, ɓe itti burmusuure ndee, ɓe ɓoorni mo kaddule makko. Caggal ɗum, ɓe naɓi mo faa ɓe tontoya mo e leggal bardugal. ");
INSERT INTO ffm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Nde ɓe njaltata ngeenndi ndii ndee, ɓe kawriti e gorko Sireenanke biyeteeɗo Simon. Sordaasi'en ɓee ndoolɗini mo o wakkoo leggal bardugal Iisaa ngal. ");
INSERT INTO ffm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ɓe njottii nokku biyeteeɗo Golgata. (Maanaa Golgata woni nokku laalagal hoore.) ");
INSERT INTO ffm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ɓe ndokki Iisaa peguujam njillondiraaɗam e safaare haaɗunde faa o yara. Nde o meeɗi ɗum ndee, o salii yarde. ");
INSERT INTO ffm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nde ɓe tonti mo e leggal bardugal ndee, ɓe pecciri kaddule makko urwa. ");
INSERT INTO ffm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Caggal ɗum, ɓe njooɗii ɗon eɓe kayba mo. ");
INSERT INTO ffm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ɓe mbinndi daliili ko tonti mo, ɓe takki ɗum ɗo tiimde hoore makko ɗoo. Ɗum ɗoo ɓe mbinndi: OO YO IISAA, KAANANKE YAHUUDIYANKOOƁE. ");
INSERT INTO ffm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","E oon wakkati, yanooɓe ɗiɗon tontidaa e makko, gooto ɲaamo makko, goɗɗo oo nano makko. ");
INSERT INTO ffm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yimɓe ƴaɓɓotooɓe ɗon ɓee ana njenna mo, ana njinka ko'e mum'en, ");
INSERT INTO ffm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ana mbiya: —Aan gurjinoowo Suudu Dewal Mawndu nduu so mahitoo ndu ley balɗe tati, biltu hoore maa. So a Ɓii Laamɗo, jippa leggal bardugal ngal! ");
INSERT INTO ffm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hono non, hooreeɓe yottinooɓe sadaka ɓee e dunkee'en Sariya ɓee e mawɓe leɲol ɓee fuu njaayriri mo ana mbiya: ");
INSERT INTO ffm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—O biltii woɓɓe, kaa o ronkii biltude hoore makko. Kanko o kaananke Israa'iila. Jooni, o jippoo leggal bardugal ngal, faa ngoonɗinen mo. ");
INSERT INTO ffm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","O fawii fii makko e Laamɗo. Yo Laamɗo biltu mo jooni, so ana yiɗi mo. Sabi o wii o Ɓii Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Yanooɓe tontaaɓe sera makko ɓee duu ndarii ana mbonkoroo mo non. ");
INSERT INTO ffm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Gila hakkunde naange, nimre waɗi e leydi ndii fuu faa wakkati yamnde tati kiikiiɗe. ");
INSERT INTO ffm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Banngal yamnde tati kiikiiɗe, Iisaa wulli wullaango toowngo, wii: —Eli, Eli, lama sabaktanii? (Ɗum woni: «Laamɗo am, Laamɗo am! Koɗum waɗi so njoppu-ɗaa kam?») ");
INSERT INTO ffm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yoga e darinooɓe ton ɓee nde nanunoo ɗum ndee, mbii: —Omo nii nodda annabi Iliyaasa! ");
INSERT INTO ffm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ɗon e ɗon, gooto dogi waddoyi liccere, suuwi ɗum e biineegiri, haɓɓi ɗum e sawru, feewtini hunduko makko yalla omo ɓuuccoo. ");
INSERT INTO ffm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kaa heddiiɓe ɓee mbii: —Njoppee mo. Ƴeewen yalla Iliyaasa waran bilta mo. ");
INSERT INTO ffm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Caggal ɗum, Iisaa wulli wullaango toowngo kasen, ɗali aduna. ");
INSERT INTO ffm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Oon wakkati, heedoode faliinde ley Suudu Dewal Mawndu ndee seekii gila dow faa ley, laatii taƴe ɗiɗi. Leydi dimmbii, kaaƴe ceekii, ");
INSERT INTO ffm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","janaale udditii, seniiɓe heewɓe maaynooɓe nguurti. ");
INSERT INTO ffm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ɓe njalti e janaale ɗee. Caggal ko Iisaa wuurti koo, ɓe naati ngalluure seniinde ndee, yimɓe heewɓe njii ɓe. ");
INSERT INTO ffm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hooreejo sordaasi'en oo e dardinooɓe e mum faa kayba Iisaa ɓee njii no leydi ndii dimmborii nii e ko waɗi koo fuu, kuli sanne, mbii: —So goonga nii, oo yo Ɓii Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Rewɓe heewɓe ana toowti, ana coynoo. Ɓeen yo jokkunooɓe e makko gila Galili faa ngollana mo. ");
INSERT INTO ffm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ana e ɓeen rewɓe: Mariyama mo Magdala e Mariyama inna Yaakuuba e Yuusufu, kaɲum e inna ɓiɓɓe Jebede. ");
INSERT INTO ffm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Faa hiiri, gorko arsukunte jeyaaɗo Arimatiya wari. Omo wiyee Yuusufu, kanko duu o taalibbo Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","O yehi to Pilaatu, o ndaardi ɗum tew Iisaa. E oon wakkati, Pilaatu duŋanii mo o hokkee ɗum. ");
INSERT INTO ffm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","O ɓami tew oo, o fiili ɗum e kasanke keso, ");
INSERT INTO ffm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","o watti ɗum e yanaande heyre nde o yamirnoo o asanee e haayre. Caggal ɗum, o talliti haayre teddunde, o uddiri damal yanaande ndee, o witti. ");
INSERT INTO ffm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mariyama mo Magdala e Mariyama goɗɗo oo ana njooɗinoo ɗon, ana peewti e yanaande ndee. ");
INSERT INTO ffm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Janngo mum yo ɲalaande fowteteende. Hooreeɓe yottinooɓe sadaka e Farisa'en kawriti to Pilaatu, ");
INSERT INTO ffm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","mbii ɗum: —Kaananke, min miccitike ƴoɲɲoowo yimɓe oo wiino nde wuuri ndee, wuurtan balɗe tati caggal maayde mum. ");
INSERT INTO ffm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ndennoo, tiinna yamir yanaande ndee doomee faa ɲalooma tataɓo oo yawta, pati taalibaaɓe makko ngara ngujjita tew makko mbiya yimɓe ɓee o immitiiɗo hakkunde maayɓe. Nden ngol ƴoɲɲugol cakitiingol ɓuran aranndeewol ngol bonde. ");
INSERT INTO ffm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilaatu wii ɓe: —Sordaasi'en haybooɓe annii. Njehee ndoomiroyee yanaande ndee no mbaawru-ɗon fuu! ");
INSERT INTO ffm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","E oon wakkati, ɓe njehi hiinnoyaade yanaande ndee: ɓe uddi nde faa gasi, ɓe meeli nde, ɓe ndarni ɗon sordaasi'en haybooɓe. ");
INSERT INTO ffm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ko ɲalaande fowteteende ndee ɓettii koo, beetee kecco ɲannde alan, Mariyama mo Magdala e Mariyama goɗɗo oo njehi ƴeewtoyaade yanaande ndee. ");
INSERT INTO ffm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ɗon, leydi dimmbii semmbe. Malaa'ika Joomiraaɗo jippii iwde dow kammu talliti haayre ndee jooɗii dow mayre. ");
INSERT INTO ffm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Omo jalbira hono no majere nii, kaddule makko duu ana ndawni far hono no ɓiraaɗam nii. ");
INSERT INTO ffm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Doomooɓe ɓee kuli sanne faa ana ciɲɲa, ɓe laatii hono maayɓe nii. ");
INSERT INTO ffm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Malaa'ika oo wii rewɓe ɓee: —Pati kulee! Miɗo anndi Iisaa tontanooɗo oo tewtaton. ");
INSERT INTO ffm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","O walaa ɗoo, o immitike hono no o wiirunoo nii. Ngaree, ƴeewee ɗo o lelinoo ɗoo. ");
INSERT INTO ffm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Njaawnee njehee, kumpitoyee taalibaaɓe makko ɓee o immitike e maayde. Jooni o adoyto on Galili, ton njiyoyton mo. Ɗum njiɗunoo-mi haalande on. ");
INSERT INTO ffm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Rewɓe ɗiɗon ɓee keɲii iwi ɗo yanaande ɗoo, ɓe heewɓe kulol e seyo manngo, ɓe ndogi haalanoyde taalibaaɓe makko ɓee oo kabaaru. ");
INSERT INTO ffm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ɗon e ɗon, Iisaa hawri e maɓɓe, wii ɓe: —Caɗee! Ɓe ɓattitii mo, ɓe nanngi koyɗe makko, ɓe cujidani mo. ");
INSERT INTO ffm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","E oon wakkati, o wii ɓe: —Pati kulee! Njehee mbiyoyee taalibaaɓe am ɓee njaha Galili. Ton ɓe njiyoyta kam. ");
INSERT INTO ffm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Rewɓe ɓee ana e laawol, faa yoga e sordaasi'en haybannooɓe yanaande nde ɓee kooti ngeenndi too, kaalani hooreeɓe yottinooɓe sadaka ɓee ko waɗi koo fuu. ");
INSERT INTO ffm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Hooreeɓe yottinooɓe sadaka ɓee kawriti e mawɓe ɓee. Ɓe ndawridi yeenude sordaasi'en haybanooɓe yanaande ndee ɓee kaalisi keewɗo, ");
INSERT INTO ffm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ɓe mbii ɗum'en: —Mbiyon taalibaaɓe makko ɓee ngarii jemma tawi oɗon ɗaanii, ngujjitii mo. ");
INSERT INTO ffm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","So goforneer oo nanii ɗum, min kawan ɗum e haala, min palanoo on e torra fuu. ");
INSERT INTO ffm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sordaasi'en ɓee nanngi kaalisi oo, ngaɗiri no mbiyaa nii. Oon kabaaru ana jantee hakkunde Yahuudiyankooɓe faa hannde. ");
INSERT INTO ffm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Taalibaaɓe sappo e go'o ɓee njehi Galili to dow waamnde haayre nde Iisaa tinndinnoo ɗum'en ndee. ");
INSERT INTO ffm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nde ɓe njii mo ndee, ɓe cujidani mo, kaa yoga e maɓɓe ana sikkitii. ");
INSERT INTO ffm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","O ɓattitii, o wii ɓe: —Mi hokkaama baawɗe fuu dow kammu e leydi. ");
INSERT INTO ffm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ndennoo, njehee ngaɗee leɲi ɗii fuu taalibaaɓe am, lootiree ɓe lootogal batisima innde Baabiraaɗo e Ɓiɗɗo e Ruuhu Ceniiɗo, ");
INSERT INTO ffm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","njannginee ɓe ɓe njokka ko njamir-mi on koo fuu. Anndee, miɗo wondi e mooɗon ɲannde fuu faa aduna timma.");
INSERT INTO ffm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ɗum woni puɗɗooɗe Kabaaru Lobbo haala Iisaa AlmasiihuƁii Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nii winndorii e dewtere annabi Esaaya: «Miin Laamɗo, mi ardinante nelaaɗo am moƴƴinanoowo ma laawol. ");
INSERT INTO ffm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Neɗɗo ana ooynoo ley ladde jeereende: Moƴƴinee laawol Joomiraaɗo ngol, ndartinee ɗati makko.» ");
INSERT INTO ffm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Oon nelaaɗo woni Yaayaa lootoowo lootogal batisima oo. O ɓanngi ley ladde jeereende, omo ooynoo omo wiya yimɓe tuuba, mbatisee yalla luutti mum'en ana njaafee. ");
INSERT INTO ffm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yimɓe leydi Yahuudiya e yimɓe Urusaliima fuu ngari, njaadiri luutti mum'en, Yaayaa looti ɓe lootogal batisima ley maayo Urdun. ");
INSERT INTO ffm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yaayaa, kaddule ɗe leeɓi gelooɗi ɓoornotonoo, humoo nguruwol, buureeti e njumri ladde o wuuri. ");
INSERT INTO ffm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Omo waajoroo daande toownde, omo wiya: —Ɓurɗo kam baawɗe waran caggal am, mi fotaa fay turaade mi humta ɓoggi paɗe makko. ");
INSERT INTO ffm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Miin, ndiyam mbatisir-mi on, kaa kanko, Ruuhu Ceniiɗo o batisirta on. ");
INSERT INTO ffm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ley ɗeen ɲalaaɗe, Iisaa iwi ngeenndi Nasaraatu ley leydi Galili, wari, Yaayaabatisi mo ley maayo Urdun. ");
INSERT INTO ffm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wakkati o ƴeentata ndiyam ɗam oo, o yii kammu udditike, o yii Ruuhu Ceniiɗo ana jippoo e makko hono no wuugaandu nii. ");
INSERT INTO ffm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Daande iwnde dow kammu ooynii, wii: —Aan woni Ɓiyam mo korsin-mi, aan cuɓii-mi. ");
INSERT INTO ffm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Oon wakkati fuu, Ruuhu naɓi mo ley ladde jeereende. ");
INSERT INTO ffm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","O waɗi ton balɗe capanɗe nay, Ibiliisa ana tewta seytaade mo, omo hakkunde kulle ladde, malaa'ika'en ana ngollana mo. ");
INSERT INTO ffm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Caggal uddeede Yaayaa ley kasu, Iisaa yehi Galili ana waajoo Kabaaru Lobbo haala Laamɗo, ");
INSERT INTO ffm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ana wiya: —Wakkati oo warii, Laamu Laamɗo ɓattiima. Tuubee, ngoonɗinee Kabaaru Lobbo. ");
INSERT INTO ffm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Iisaa ana yahannoo dow fonngo weendu Galili, non yii Simon e miɲum Andire ana tippoo bubbi mum'en ley weendu nduu yo awooɓe. ");
INSERT INTO ffm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Iisaa wii ɓe: —Njokkee kam, mi waɗa on awooɓe yimɓe. ");
INSERT INTO ffm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ɗon e ɗon ɓe njoppi bubbi maɓɓe ɗii, ɓe njokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","O yehi yeeso seeɗa, o yii Yaakuuba ɓii Jebede e miɲum Yuhanna ley laana mum'en ana moƴƴintina bubbi. ");
INSERT INTO ffm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Oon wakkati fuu, o noddi ɓe. Ɓe njoppi baam maɓɓe Jebede, kaɲum e hasaaɓe ɓee ley laana kaa, ɓe njokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Caggal ɗum, ɓe njehi ngeenndi mbiyeteendi Kafarnahum, Iisaa naati suudu waajordu, fuɗɗi waajaade. Ɲannde mum yo fowteteende. ");
INSERT INTO ffm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tawaaɓe ɗon ɓee kaaynaa e waaju makko oo, sabi o waajorike ɓe no jom baawɗe nii, wanaa no dunkee'en Sariya nii. ");
INSERT INTO ffm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Gorko laddaaɗo ana e waajordu nduu, wulli, ");
INSERT INTO ffm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","wii: —Iisaa Nasaraatunke oo, koɗum hillu maa e amen? A garɗo halkude min naa? Miɗo anndi ko ngon-ɗaa, a ceniiɗo iwruɗo to Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Iisaa jahii e seyɗaani oo, wii: —Deƴƴu yaltu e makko! ");
INSERT INTO ffm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Seyɗaani oo dimmbi gorko oo semmbe, wulli wullaango toowngo, yalti e makko. ");
INSERT INTO ffm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jamaa oo fuu haaynaa, hedde ana lamndondira: —Ko ɗum woni? Ɗum anndal kesal koy! Omo yamira fay seyɗaani'en ɓee, ɓe ɗowtanto mo. ");
INSERT INTO ffm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Wakkati gooto kabaaru makko saakii ley leydi Galili fuu. ");
INSERT INTO ffm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nde ɓe njaltunoo waajordu nduu ndee, ɓe njehi galle Simon e Andire. Yaakuuba e Yuhanna njaadi e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Esii Simon debbo ana lelii yo jontaaɗo. Iisaa yottii tan, haalanaa haala makko, ");
INSERT INTO ffm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ɓattitii mo, nanngi junngo makko, immini mo. Ɗon e ɗon jontere makko selli, o laatanii ɓe njaatigi. ");
INSERT INTO ffm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kiikiiɗe caggal janal naange, yimɓe ngaddani Iisaa ɲawɓe e laddaaɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ngeenndi ndii fuu hawriti dow damal ngal. ");
INSERT INTO ffm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","O sellini ɲawɓe heewɓe, ɲawɓe ɲawuuji ɗi ngaldaa sii. O ribbi seyɗaani'en heewɓe, o accataa seyɗaani'en ɓee kaala, sabi eɓe anndi ko mo woni jaati. ");
INSERT INTO ffm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Janngo mum, Iisaa hujji gila law, yehi nokku teelɗo ana waɗa ton duwaawu. ");
INSERT INTO ffm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon e wondiiɓe mum ndarii ana tewta mo. ");
INSERT INTO ffm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Nde ɓe njiiti mo ndee, ɓe mbii mo: —Yimɓe fuu ana ndaarte. ");
INSERT INTO ffm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Iisaa wii ɓe: —Njehen ley geelle ɓadiiɗe ɗee faa mi waajoo ton duu, sabi ɗum waddi kam. ");
INSERT INTO ffm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","O yehi ley leydi Galili fuu, omo waajoo ley cuuɗi baajorɗi maɓɓe, omo ribba seyɗaani'en. ");
INSERT INTO ffm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Gorko ceppaaɗo wari diccii yeeso makko, ndaardi mo, wii: —So tawii a jaɓii, aɗa waawi sellinde kam! ");
INSERT INTO ffm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iisaa yurminaa, foocci junngo mum, memi mo, wii: —Mi jaɓii, sellu! ");
INSERT INTO ffm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ɗon e ɗon, ceppe ɗee iwi e gorko oo, o selli. ");
INSERT INTO ffm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Oon wakkati fuu, Iisaa yoppiti mo, daalii mo, ");
INSERT INTO ffm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","wii: —Haya koy, pati humpitin fay gooto, yaa holloy hoore maa jottinoowo sadaka, ngaɗanaa laaɓugol maa ngol sadaka mo Muusaa yamiri oo faa anndina ɓe a sellii. ");
INSERT INTO ffm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kaa kanko, o iwi ɗon tan, o darii omo saaka kabaaru oo. Ɗum waɗi so Iisaa ronki naatude geelle, heddii ladde, yimɓe ana iwra tatteeji fuu ana ngara e mum. ");
INSERT INTO ffm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Caggal balɗe seeɗa, Iisaa warti ngeenndi Kafarnahum. Yimɓe nani omo cuuɗi. ");
INSERT INTO ffm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jamaa keewɗo hawriti ɗon faa fay nokkuure heddaaki, wanaa haala yeeso damal ngal, hedde omo waajoo ɓe konngol Laamɗo ngol. ");
INSERT INTO ffm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yimɓe ngari, ngaddani mo bonnguujo mo worɓe nayon ndoondii. ");
INSERT INTO ffm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kaa ɓe ndonkii yottinde mo Iisaa sabaabu jamaa oo. Ɗum waɗi so ɓe kippiti bene oo foonndo makko, ɓe njippiniri bonnguujo oo e yulannde ndee, tawi ana lelnaa e dengeleewo. ");
INSERT INTO ffm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nde Iisaa yiinoo goonɗinal maɓɓe ndee, wii bonnguujo oo: —Giɗam, luutti maa njaafaama. ");
INSERT INTO ffm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Dunkee'en Sariya jooɗinooɓe ɗon ɓee ndarii ana miiloo e ɓerɗe mum'en: ");
INSERT INTO ffm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Hono oo gorko haaldi ɗum? O bonkike Laamɗo! Homo waawi yaafaade luutti so wanaa Laamɗo gooto oo?» ");
INSERT INTO ffm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Iisaa faami ɗon e ɗon miilooji maɓɓe, wii ɓe: —Koɗum waɗi so oɗon miiloo miilooji baaɗi nii e ɓerɗe mooɗon? ");
INSERT INTO ffm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wiide bonnguujo «Luutti maa njaafaama» e wiide ɗum «Imma, ɓam dengeleewo maa njahaa», koɗum hen ɓuri newaade? ");
INSERT INTO ffm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kaa, faa mi anndina on Ɓii Neɗɗo ana jogii baawɗe e aduna oo yaafaade luutti… Nden, o wii bonnguujo oo: ");
INSERT INTO ffm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Miɗo haalane: imma, ɓam dengeleewo maa, kootaa suudu maa. ");
INSERT INTO ffm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ɗon e ɗon gorko oo immii, ɓami dengeleewo mum witti, hedde yimɓe fuu ana ƴeewa ɗum. Ɓe fuu ɓe kaaynaa, ɓe ndarii eɓe njetta Laamɗo, eɓe mbiya: —Min njiyaali hono ɗum abada. ");
INSERT INTO ffm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iisaa wirfitii to weendu too. Jamaa oo fuu tawoyi mo ton, omo waajoo ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nde o yahata ndee, o yii Lewi ɓii Alfaa ana jooɗii e duwaaɲeere mum, o wii ɗum: —Jokku e am! Lewi immii, jokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Nde Iisaa ɲaamannoo e ley suudu Lewi ndee, duwaaɲe'en heewɓe e luuttooɓe hono mum'en njooɗii, ana ɲaamda e makko, kanko e taalibaaɓe makko. Sabi yimɓe heewɓe ana njokki e Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dunkee'en Sariya jeyaaɓe e waalde Farisa'en njii Iisaa ana ɲaamda e ɓeen yimɓe, mbii taalibaaɓe makko ɓee: —Ko saabii so omo ɲaamda e duwaaɲe'en, kaɲum e luuttooɓe hono mum'en? ");
INSERT INTO ffm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nde o nani ɗum ndee, o wii ɓe: —Wanaa celluɗo hasindini e cawroowo, ɲawɗo hasindini e cawroowo. Wanaa noddude fooccitiiɓe waddi kam, noddude luuttooɓe woni ko waddi kam. ");
INSERT INTO ffm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Taalibaaɓe Yaayaa e Farisa'en ana koora. E ley ɗum, yimɓe ngari, lamndii Iisaa: —Ko saabii so taalibaaɓe Yaayaa e taalibaaɓe Farisa'en ana koora, kaa ɓe maa ɓee koorataa? ");
INSERT INTO ffm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","O jaabii ɓe, o wii: —Nootiiɓe kuurtungu ana mbaawi salaade ɲaamde tawa jommbaajo gorko oo ana wondi e mum'en naa? Mbaawaa. So nii jommbaajo gorko oo ana wondi e maɓɓe, ɓe mbaawaa salaade ɲaamde. ");
INSERT INTO ffm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kaa ɲalaaɗe ngaran ɗe jommbaajo gorko oo ittetee e hakkunde maɓɓe. E ɗeen ɲalaaɗe, ɓe kooran. ");
INSERT INTO ffm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Fay gooto ɗammbataa fetalaare heyre e kaddungal kiinngal. So ɗum waɗii, fetalaare heyre ndee daamtan kaddungal kiinngal ngal, ceekol ngol ɓeydoo. ");
INSERT INTO ffm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kasen duu fay gooto loowataa peguujam kesam e sumalleeji kiiɗɗi. So ɗum waɗii peguujam ɗam fusan ɗi, kanjam e sumalleeji ɗii fuu mursidee. Peguujam kesam e sumalleeji kesi loowetee! ");
INSERT INTO ffm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Waɗiino e ɲalaande fowteteende wootere, Iisaa ana seeka gese, taalibaaɓe mum ana kelta butaali e laawol ngol. ");
INSERT INTO ffm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","E ley ɗum, Farisa'en ɓee mbii mo: —Ƴeew, koɗum waɗi so taalibaaɓe maa ɓee ana ngolla ko dagaaki gollude ɲalaande fowteteende? ");
INSERT INTO ffm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","O jaabii ɓe, o wii: —Tama on meeɗaali janngude ko Daawuuda waɗi nde yolbi haajaa ko ɲaametee, kaɲum e yimɓe mum? ");
INSERT INTO ffm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","O naati e ley hukkum ceniiɗo oo e jamaanu Jottinoowo Sadaka Mawɗo biyeteeɗo Abiyataar, o ɲaami buuru cakkaaɗo oo, o hokki hen yimɓe makko. Tawee nee, yottinooɓe sadaka tan nduŋanaa ɲaamde oon buuru. ");
INSERT INTO ffm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iisaa wii ɓe kasen: —Ɲalaande fowteteende ndee kammari neɗɗo waɗiraa, wanaa neɗɗo waɗiraa kammari ɲalaande fowteteende ndee. ");
INSERT INTO ffm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ndennoo fay ɲalaande fowteteende ndee, Ɓii Neɗɗo woni joomum. ");
INSERT INTO ffm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Iisaa naatti ley suudu waajordu nduu, o tawi ton gorko mo junngo mum waati. ");
INSERT INTO ffm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yimɓe wonnooɓe ɗon ɓee ngattani Iisaa hakkille. Ana ƴeewa yalla o anniyiiɗo sellinde gorko oo e ɲalaande fowteteende ndee, faa keɓa wullanaade mo. ");
INSERT INTO ffm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Iisaa wii mo junngo mum waati oo: —Imma, dara hakkunde maɓɓe! ");
INSERT INTO ffm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Caggal ɗum, o lamndii ɓe: —E ley ɲalaande fowteteende ana dagoo gollude ko moƴƴi naa gollude ko boni? Danndude neɗɗo naa warde ɗum? Kaa ɓe njaabaaki. ");
INSERT INTO ffm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iisaa ƴeewri ɓe tikkere, tiinndam-hoore maɓɓe ɗam woyni yonki makko, o wii gorko oo: —Fooccu junngo maa! Oon foocci ngo tan, ngo selli faa ngo warti hono no wonngo ngoo nii. ");
INSERT INTO ffm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Ɗon e ɗon, Farisa'en ɓee njalti, njooddii e howruuɓe Hirudus faa ndawrida no mbarda Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Caggal ɗum, o iwi ɗon, o fa'i weendu too, kanko e taalibaaɓe makko. Jamaa keewɗo iwɗo Galili jokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yimɓe heewɓe, iwɓe Yahuudiya e Urusaliima e Idumiya e leydi funnaange Urdun e seraaji Tirus e Sidon, nani ko o waɗannoo koo, ngari to makko. ");
INSERT INTO ffm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iisaa wii taalibaaɓe mum ɓee ndaarana ɗum laana pati jamaa oo ɓilla ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Saabe omo sellinannoo heewɓe waɗi so ɲawɓe ɓee fuu keɲanii mo yalla ana mema mo. ");
INSERT INTO ffm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Wakkati mo seyɗaani'en njii mo fuu, ndiccoto, ngulla: —Aan a Ɓii Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Omo yagginannoo ɓe pati ɓe kumpita fay gooto kabaaru makko. ");
INSERT INTO ffm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Caggal ɗum, o ŋabboyi dow waamnde haayre, o noddi ɓe o muuyi noddude, ɓeen ngari e makko. ");
INSERT INTO ffm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","O suɓii hen sappo e ɗiɗon, yalla ana ngonda e makko, o nela ɗum'en waajoyaade, ");
INSERT INTO ffm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kasen o hokka ɗum'en baawɗe ribbude seyɗaani'en. ");
INSERT INTO ffm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ɓee ɗoo ngoni sappo e ɗiɗon ɓe o suɓii ɓee: Simon mo o innditiri Piyeer oo ");
INSERT INTO ffm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","e Yaakuuba e miɲum biyeteeɗo Yuhanna, ɓiɓɓe Jebede ɓe o innditiri Bowanerges ɓee (maanaa mum woni «nannduɓe e gidaango») ");
INSERT INTO ffm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","kaɲum e Andire e Filipa e Bartolome e Matta e Tomaa e Yaakuuba ɓii Alfaa e Tadde e Simon kiranoowo suudu baaba ");
INSERT INTO ffm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","e Yahuuda Isikariyota jammbotooɗo mo oo. ");
INSERT INTO ffm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Caggal ɗum, o hooti cuuɗi. Jamaa hawriti dow hoore makko kasen faa kanko e taalibaaɓe makko ɓe ndonki heɓude no ɓe ɲaamira. ");
INSERT INTO ffm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nde sakiraaɓe makko nani ɗum ndee, ngarani mo, sabi wiyaama hakkille makko sottii. ");
INSERT INTO ffm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Dunkee'en Sariya iwnooɓe Urusaliima ngari, mbii: —Beelsebul woni e makko. Kasen ɓe mbii: —Oon woni hooreejo seyɗaani'en mo o ribbirta seyɗaani'en ɓee. ");
INSERT INTO ffm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","E ley ɗum, Iisaa noddi ɓe ɓe ngara e mum, haalaniri ɓe banndol, wii: —Hono Ibiliisa waawirta ribbude Ibiliisa? ");
INSERT INTO ffm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","So laamu fecciima ana haɓa e hoore mum, oon laamu waawataa heddaade. ");
INSERT INTO ffm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kasen duu so galle fecciima ana haɓa e hoore mum, oon galle waawataa heddaade. ");
INSERT INTO ffm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ndennoo, so Ibiliisa yanii e hoore mum fecciima, waawataa heddaade. Ko laatoto dee, kabaaru mum timman. ");
INSERT INTO ffm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Iisaa jokkini hen: —Fay gooto waawaa naatude e galle gorko jom semmbe yaada e jawdi mum tawa haɓɓaali joomum tafon. Kaa so haɓɓii joomum faa teeŋii, ana waawi naɓude ko woni e galle mum fuu. ");
INSERT INTO ffm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Miɗo haalana on goonga: yimɓe ana mbaawi yaafeede luutti mum'en fuu e bonkaaji ɗi ɓe mbonkii Laamɗo fuu. ");
INSERT INTO ffm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kaa bonkiiɗo Ruuhu Ceniiɗo oo heɓataa yaafaamuya fey, sabi joomum heddoto e luuttal mum faa abada. ");
INSERT INTO ffm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iisaa haaldii kaa haala saabe ko ɓe mbii omo wondi e seyɗaani koo. ");
INSERT INTO ffm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Inna Iisaa e miɲiraaɓe Iisaa worɓe ngari, ndarii caggal galle oo, neli o noddee. ");
INSERT INTO ffm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ɗo jamaa oo filii mo ɗoo, wii mo: —Inna maa e miɲiraaɓe maa ana sella too, ana kaaje maa. ");
INSERT INTO ffm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","O jaabii, o wii: —Homo woni innam e miɲiraaɓe am? ");
INSERT INTO ffm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","O ƴeewi jooɗiiɓe so ana pilii mo ɓee, o wii: —Innam e miɲiraaɓe am annii. ");
INSERT INTO ffm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sabi gaɗoowo sago Laamɗo, kaɲum woni miɲam gorko, kaɲum woni miɲam debbo, kaɲum woni innam. ");
INSERT INTO ffm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Iisaa ana waajoo dow fonngo weendu nduu kasen. Jamaa keewɗo filii mo faa o naati laana, o jooɗii. Jamaa oo fuu ana dow fonngo ngoo. ");
INSERT INTO ffm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","O darii omo waajoroo ɓe geɗe keewɗe e banndol, omo wiya ɓe: ");
INSERT INTO ffm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Kettinee! Aawoowo yalti aawoyde. ");
INSERT INTO ffm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E ley sankugol ngol, yoga e aawdi ndii saami e laawol: pooli ngari cuɓi ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yoga mayri saami e korokaaƴe ɗo leydi heewaano, fuɗi ɗon e ɗon, sabi aawdi ndii suddaaki gasa. ");
INSERT INTO ffm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kaa nde naange wulnoo ndee, sumi, yoori saabe walaa ɗaɗi. ");
INSERT INTO ffm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yoga mayri saami ɗo kebbe puɗata. Ndi fuɗidi e majje, ɗe cuumi ndi, ndi rimaali. ");
INSERT INTO ffm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yoga mayri saami e leydi mbelndi, fuɗi, mawni, rimi: yoga sowii cowe capantati, yoga capanɗe jeegom, yoga teemedere. ");
INSERT INTO ffm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Caggal ɗum, o wii: —Jom nowru fuu yo nanu! ");
INSERT INTO ffm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nden Iisaa teelti, sappo e ɗiɗon ɓee e filinooɓe mo ɓee lamndii mo maanaa banndol ngol. ");
INSERT INTO ffm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","O wii ɓe: —Onon, on ndokkaama faamde goonga tedduɗo haala Laamu Laamɗo oo. Kaa wonɓe sella ɓee, huunde fuu e banndol kaalaniran-mi ɓe. ");
INSERT INTO ffm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ɗum waɗi so: «ana ƴeewa faa gasa tawa njiyataa, ana nana faa laaɓa paca tawa paamataa, sako ɓe tuuba so ɓe njaafee.» ");
INSERT INTO ffm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","O wii ɓe: —On paamaali ngol banndol naa? Hono paamirton banndi goɗɗi ɗii fuu ndennoo? ");
INSERT INTO ffm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aawoowo oo konngol Laamɗo o aawata. ");
INSERT INTO ffm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Yimɓe yogaaɓe ana nanndi e laawol ɗo aawdi ndii saami ɗoo. Ɓe nanan konngol ngol, oon wakkati fuu Ibiliisa warata so itta konngol aawaangol e maɓɓe ngol. ");
INSERT INTO ffm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yogaaɓe ana nanndi e korokaaƴe ɗe aawdi ndii yuppii e muuɗum ɗee. Ɓe nanan konngol ngol, ɓe njaɓɓoroo ngol seyo oon wakkati fuu, ");
INSERT INTO ffm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","kaa ngol walaa ɗaɗi e maɓɓe, wakkati gooto tan ngol wonata e maɓɓe. Wakkati mo ɓillaare naa torra hewti ɓe saabe konngol ngol fuu, ɓe njankiran. ");
INSERT INTO ffm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yogaaɓe ɓee ana nanndi e nokku kebbe ɗo aawdi ndii saami ɗoo. Ɓee ngoni nanɓe konngol ngol, ");
INSERT INTO ffm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kaa sugullaaji aduna e koomti jawdi, kaɲum e giɗaaɗe yonki goɗɗe naatan e maɓɓe, cuuma konngol ngol, ngol laatoo dimarol. ");
INSERT INTO ffm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kaa ɗo aawdi ndii saami e leydi lobbiri ɗoo, ɓee ngoni nanooɓe konngol ngol so njaɓa ngol. Ɓe ndiman: yoga sowoo cowe capantati, yoga capanɗe jeegom, yoga teemedere. ");
INSERT INTO ffm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Caggal ɗum, Iisaa wii ɓe: —Won fuu kuɓɓoowo lampa so hippa hen saawal, naa soorna ɗum ley leeso? Wanaa sinndan ɗum naa? ");
INSERT INTO ffm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Walaa fuu ko ɲooɓi ko ɓanngintaake, walaa ko suuɗii ko yaltintaake sella. ");
INSERT INTO ffm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jom nowru fuu yo nanu! ");
INSERT INTO ffm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","O wii ɓe kasen: —Tiiɗee e no nanirton haalaaji am ɗii nii! Sabi no etirton nii, non etirante-ɗon on ɓeydante duu. ");
INSERT INTO ffm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sabi jogiiɗo fuu ɓeydante, kaa mo walaa oo, fay seeɗa mo jogii oo teetete. ");
INSERT INTO ffm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","O wii kasen: —Laamu Laamɗo ana wa'i no neɗɗo cankuɗo aawdi e ngesa mum nii. ");
INSERT INTO ffm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Caggal mum, ɗaanoo jemma daroo ɲalooma, no laatii fuu aawdi ndii fuɗan, mawna, tawa joomum anndaa no ndi mawniri. ");
INSERT INTO ffm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Leydi ndii e hoore mum fuɗinta ndi, ndi waɗa gulle, wutaandu jokka hen, caggal ɗum, gabbe njokka hen. ");
INSERT INTO ffm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","So ko aawaa koo ɓenndii, o ɓaman wawdu makko o hetta, sabi wakkati mum yottike. ");
INSERT INTO ffm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","O jokkini hen: —Koɗum nanndinten e Laamu Laamɗo oo? Banndol hongol mbanndirten mo? ");
INSERT INTO ffm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Laamu Laamɗo ana nanndi e ngeeƴu buyaage. Kaɲum ɓuri geeƴi ɗii fuu famɗude. ");
INSERT INTO ffm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kaa so mo aawaama, mo mawnan faa mo laatoo lekki mawki sanne, ki waɗa caɓe mawɗe faa pooli mbaawa ɲiɓude cuuɗi e ɗowdi makki. ");
INSERT INTO ffm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iisaa haalaniri yimɓe ɓee konngol Laamɗo ngol e banndi keewɗi baaɗi non, ko waarata e faamu maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","O waajortaako so wanaa e banndol. Kaa nde o teeldi e taalibaaɓe makko ɓee fuu, o firritanan ɗum'en banndi ɗii fuu. ");
INSERT INTO ffm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kiikiiɗe oon ɲalooma, Iisaa wii taalibaaɓe mum ɓee: —Lummben, keedoyen ootoo bannge. ");
INSERT INTO ffm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɓe njoppi jamaa oo, ɓe tawti mo e laana ka o wonnoo e mum kaa, ɓe ndeerti. Laanaaji goɗɗi duu ana njokki e makko. ");
INSERT INTO ffm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Henndu sattundu immii, bempeeje immii ana piya laana kaa, faa ka hosi heewde ndiyam. ");
INSERT INTO ffm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kanko, omo ɗaanii to laaci laana too, omo wawlii mbawlu. Ɓe pinndini mo, ɓe mbii mo: —Moobbo, tama ko min kalkotoo koo wemmbaali ma? ");
INSERT INTO ffm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","O immii, o jahii e henndu nduu, o wii weendu nduu: —Deƴƴina! Wii teen! Henndu nduu deƴƴinii, fuu wii teen. ");
INSERT INTO ffm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Caggal ɗum, o wii ɓe: —Ko saabii so kul-ɗon? Faa hannde on ngalaa hoolaare naa? ");
INSERT INTO ffm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ɓe kuli kulol cattungol hedde eɓe mbiyondira: —Homo oo gorko woni faa henndu e ndiyam ana ɗowtanoo ɗum? ");
INSERT INTO ffm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Caggal ɗum, ɓe njottii oo too bannge e weendu nduu, e leydi Gerasankooɓe. ");
INSERT INTO ffm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nde Iisaa yalti laana kaa ndee, laddaaɗo iwri ley janaale, hawri e makko. ");
INSERT INTO ffm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ley janaale ɗee o jooɗinoo, fay gooto waawaa haɓɓude mo, sabi fay calali kaɓɓataa mo. ");
INSERT INTO ffm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sabi heewii ko o humti tonngooɗe e calali, o taƴan calali, o hela geƴƴelle. Fay gooto waawaa nanngirde mo semmbe. ");
INSERT INTO ffm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ɲannde fuu, jemma e ɲalooma ley janaale e baamle kaaƴe o woni, omo wulla omo fiitoroo kaaƴe. ");
INSERT INTO ffm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","O soynii Iisaa, o dogani ɗum, o sujidani ɗum, ");
INSERT INTO ffm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","o wulli faa toowi, o wii: —Iisaa Ɓii Laamɗo Toowɗo, koɗum njiɗ-ɗaa waɗude kam? Mi surdii ma saabe Laamɗo, pati torram! ");
INSERT INTO ffm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Walaa ko o wiiri non sinaa Iisaa wii mo: —Seyɗaani, yaltu e makko. ");
INSERT INTO ffm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Iisaa lamndii mo, wii: —Hono mbiyete-ɗaa? O jaabii, o wii: —Miɗo wiyee jamaa, sabi miɗen keewi. ");
INSERT INTO ffm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","O ɲaagii ɗum sanne, o ndaardi ɗum pati yaltina seyɗaani'en ɓee leydi ndii. ");
INSERT INTO ffm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Sewre girooji mawnde ana durannoo ɗon e hoore waamnde haayre. ");
INSERT INTO ffm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Seyɗaani'en ɓee ndaardi mo o duŋanoo ɗum'en naata e ley girooji ɗii. ");
INSERT INTO ffm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","O duŋanii ɓe ɗum. Seyɗaani'en ɓee njalti, naati e girooji ɗii. Sewre ndee fuu diiri iwi daande waamnde haayre too, naatoyi ley weendu nduu, yoolii. Eɗi poti ujunaaji ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Durooɓe ɓee ndogi njantanoyii ngeenndi ndii e seraaji mum ko hewtii ɗum'en koo. Yimɓe ɓee njehi ƴeewoyde ko waɗi koo, ");
INSERT INTO ffm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ɓe ngari e Iisaa. Nde ɓe njii gorko laddanooɗo oo ana jooɗii ana ɓoornii kaddule, yeeɗɗitii ndee, kulol nanngi ɓe. ");
INSERT INTO ffm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Tawaaɓe ɗon ɓee njantanii ɓe ko hewtinoo laddaaɗo oo e girooji ɗii. ");
INSERT INTO ffm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ɓe ndaardi Iisaa yalta leydi maɓɓe ndii. ");
INSERT INTO ffm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nde o naattata laana kaa ndee, laddanooɗo oo ndaardi mo o acca jokka e makko. ");
INSERT INTO ffm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","O salanii oon, o wii ɗum: —Hootu suudu maa e koreeji maa, kumpitaa ɓe ko Joomiraaɗo waɗan maa e no o yurmori maa. ");
INSERT INTO ffm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","O yehi omo haala e leydi ndi geelle sappo ndii ko Iisaa waɗani mo. Ɓe fuu ɓe kaaynaa. ");
INSERT INTO ffm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nde Iisaa naati e laana wirfitii oo too bannge weendu nduu ndee, jamaa keewɗo filii mo kasen dow fonngo ɗoo. ");
INSERT INTO ffm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nden gooto e hooreeɓe suudu waajordu biyeteeɗo Jayrus wari. O yii Iisaa tan, o diccii yeeso mum, ");
INSERT INTO ffm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","o ɲaagii ɗum o haali faa heewi, o wii: —Ɓiyam debbo ana haɓana yonki. War faw junngo maa e makko, yalla omo sella, o wuura! ");
INSERT INTO ffm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Iisaa yaadi e makko, jamaa keewɗo jokki e mum faa ana ɓilla ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Debbo mo tuundi mum taƴataa ko waarata e duuɓi sappo e ɗiɗi ana wonnoo ton. ");
INSERT INTO ffm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O tampii hen sanne, o yehii to sawrooɓe heewɓe faa junngo makko laaɓi. Ko ɓuri ɗum fuu o yiyaali hen sami, ɲaw oo ɓeydoto jaati. ");
INSERT INTO ffm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","O nani haala Iisaa ana haalee, o naati e jamaa oo. Sabi o miilii: «So mi memii saaya makko tan, mi sellan.» O iwri caggal mum, o memi saaya mum. ");
INSERT INTO ffm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ɗon e ɗon tuundi makko taƴi, o maati e calɗi makko o sellii. ");
INSERT INTO ffm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Oon wakkati fuu, Iisaa maati won semmbe iwi e mum, yeeccitii hakkunde jamaa oo, wii: —Homo memi saaya am? ");
INSERT INTO ffm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Taalibaaɓe makko ɓee mbii mo: —A yii jamaa annii ɓillu maa, aɗa lamndoo: «Homo memi kam?» ");
INSERT INTO ffm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kaa o darii omo tewta memɗo mo oo. ");
INSERT INTO ffm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Debbo oo ana siɲɲa no foti hulde sabi ana anndi ko waɗi, wari, diccii yeeso makko, haalani mo goonga. ");
INSERT INTO ffm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Iisaa wii mo: —Banndam debbo, goonɗinal maa danndii ma. Yaa e jam! A sellii e ɲaw maa oo! ");
INSERT INTO ffm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","O tilaaki haalde, faa won iwruɓe to suudu Jayrus hooreejo waajordu oo, mbii ɗum: —Ɓiya oo heddaaki. Fotaa ko tampinaa Moobbo oo hankasen! ");
INSERT INTO ffm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kaa Iisaa tippitii haala maɓɓe, wii Jayrus: —Pati hul, hoolam tan! ");
INSERT INTO ffm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","O ɗalaali fay gooto yaada e makko so wanaa Piyeer e Yaakuuba e Yuhanna miɲii Yaakuuba oo. ");
INSERT INTO ffm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ɓe njottii suudu hooreejo waajordu nduu oo. O tawi ɗon dooyoore, yimɓe ana mboya, ana conkina semmbe. ");
INSERT INTO ffm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nde o naatunoo ndee, o wii ɓe: —Ko woni ɗii bojji e ɗii ɲonaali? Suka oo maayaali, o ɗaaniiɗo tan. ");
INSERT INTO ffm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɓe puuytini haala makko. Non o yaltini ɓe fuu, o naatidi e baaba suka oo e inna mum e taalibaaɓe taton ɓee suudu to suka oo lelii too. ");
INSERT INTO ffm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","O nanngi junngo mum, o wii: —Talita kuumii! (Ɗum woni: «Suka debbo, imma!») ");
INSERT INTO ffm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Suka oo immii ɗon e ɗon, ana yaha. Duuɓi makko yo sappo e ɗiɗi. Yimɓe ɓee kaaynaa sanne. ");
INSERT INTO ffm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Iisaa yaggini ɓe pati ɓe anndina ɗum fay gooto. O wii ɓe ndokka suka oo ko ɲaama. ");
INSERT INTO ffm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iisaa iwi e oon nokku, taalibaaɓe mum njokki e mum, wirfitii ngeenndi mum'en. ");
INSERT INTO ffm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nde ɲalaande fowteteende yottinoo ndee, o fuɗɗi waajaade ley suudu waajordu nduu. Nanɓe waaju makko ɓee kaaynaa, hedde ana mbiya: —Hoto o heɓi ɗum? Hono o heɓiri oo hakkille? Ƴee! Hono neɗɗo waawiri waɗirde ɗii kaayeefiiji? ");
INSERT INTO ffm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tama o wanaa cehoowo leɗɗe, tama o wanaa ɓii Mariyama? Tama o wanaa mawnii Yaakuuba e Yoses e Yahuuda e Simon? Tama wanaa enen e banndiraaɓe makko rewɓe koddi? Kammari ɗum waɗi so ɓe njankiri mo. ");
INSERT INTO ffm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","E oon wakkati, o wii ɓe: —Annabaajo ana teddinaa nokku fuu so wanaa e ley ngeenndi mum'en e hakkunde rimdaaɓe mum, kaɲum e ley galle mum'en. ");
INSERT INTO ffm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Iisaa heɓaali waɗude ɗon fay haaynde wootere, so wanaa ko fawi junngo mum e ɲawɓe seeɗa, sellini ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kasen duu waasude maɓɓe goonɗinde laatanii mo haaynde. Caggal ɗum, Iisaa yiilii e geelle piliiɗe ɗon ɗee, ana waajoo. ");
INSERT INTO ffm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","O noddi taalibaaɓe sappo e ɗiɗon ɓee, o neliri ɗum'en ɗiɗon ɗiɗon. O hokki ɓe baawɗe ribbude seyɗaani'en, ");
INSERT INTO ffm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","o wii ɓe so eɓe ndawa, pati ɓe naɓora fay huunde, so wanaa sawru. Pati ɓe naɓora buuru naa mbasu naa kaalisi e ley njiibaaji maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","O yamiri ɓe ɓe ɓoornoo paɗe, kaa pati ɓe naɓora saayaaji ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","O wii ɓe kasen: —Galle fuu mo njippi-ɗon e mum, keddo-ɗon ɗon faa nde iw-ɗon e oon nokku fuu. ");
INSERT INTO ffm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","So on ngarii e nokku, yimɓe njaɓɓaaki on naa kettinanaaki on, iwon ton, piɗɗon colla koyɗe mooɗon faa jeertina ɓe ko ɓe ngaɗi koo ana boni. ");
INSERT INTO ffm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ɓe njehi, ɓe mbaajii yimɓe ɓee tuuba, ");
INSERT INTO ffm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ɓe ndibbi seyɗaani'en heewɓe, ɓe nguji nebam e ɲawɓe heewɓe ɓe cellini ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Hirudus, kaananke oo, nani haala Iisaa ana haalee, sabi innde Iisaa walaa fuu ɗo yottaaki. Won wiyooɓe Yaayaa mo lootogal batisima wuurti, ɗum waɗi so o jogii baawɗe waɗude kaayɗe. ");
INSERT INTO ffm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Woɓɓe ana mbiya o annabi Iliyaasa. Woɓɓe duu ana mbiya o annabaajo no annabaaɓe aranndeeɓe ɓee nii. ");
INSERT INTO ffm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nde Hirudus nani ɗum ndee, wii: —Yaayaa mo taƴunoo-mi hoore mum oo, kaɲum wuurti! ");
INSERT INTO ffm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tawi Hirudus yamiriino Yaayaa nanngee, haɓɓee, uddee ley kasu. Saabe Hirudiya jom suudu mawniiko biyeteeɗo Filipa mo o ɓamnoo oo, waɗi. ");
INSERT INTO ffm_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Sabi Yaayaa ana wiyannoo mo: —Dagantaako ma teetaa jom suudu mawna. ");
INSERT INTO ffm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Hirudiya mettaa e Yaayaa, yiɗi o waree, kaa heɓaali laawol, ");
INSERT INTO ffm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","sabi Hirudus ana hulannoo Yaayaa, ana anndunoo o gorko pooccitiiɗo, ceniiɗo. Ɗum waɗi so omo haybannoo ɗum. So o hettinike haala mum, hakkille makko jiiɓoto, haya kasen duu omo yiɗi hettinaade ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kaa noo, Hirudiya heɓi laawol ɲannde yiitu-mawuuri rimeede Hirudus. Hirudus waɗani howruuɓe mum e hooreeɓe sordaasi'en ɓee e inndee-anndee'en Galili ɓee fuu hiraande. ");
INSERT INTO ffm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ɓii Hirudiya debbo naati ana woma. Ɗum weli Hirudus e nootiiɓe ɗum ɓee fuu. O wii suka debbo oo: —Haalanam ko njiɗ-ɗaa faa mi waɗane. ");
INSERT INTO ffm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","O hunanii ɗum, o wii o hokkan ɗum huunde fuu ko ɲaagii mo, fay so tawii feccere laamu makko oo. ");
INSERT INTO ffm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","E ley ɗum, suka debbo oo yalti, wii inna mum: —Koɗum kaan-mi ɲaagaade? Inniraaɗo oo jaabii mo, wii: —Ɲaaga mo hoore Yaayaa mo lootogal batisima oo! ");
INSERT INTO ffm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Suka debbo oo heɲii, wirfitii to kaananke oo too, ɲaagii ɗum, wii: —Ko njiɗu-mi, ngaddanaa kam jooni jooni hoore Yaayaa mo lootogal batisima oo e la'al! ");
INSERT INTO ffm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Terɗe Hirudus mbaati faa wanaa seese, kaa nde wonnoo o hunike yeeso nootiiɓe mo ɓee, o waɲi yaltude e konngol makko ngol. ");
INSERT INTO ffm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","O neli ɗon e ɗon gooto e sordaasi'en doomooɓe mo ɓee, o yamiri ɗum yo waddoy hoore Yaayaa. Sordaasi oo wirfitii, naati e ley kasu oo, taƴi hoore Yaayaa, ");
INSERT INTO ffm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tummbi e la'al, waddi, hokki suka debbo oo. Suka debbo oo duu hokki inna mum. ");
INSERT INTO ffm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nde taalibaaɓe Yaayaa ɓee nani ɗum ndee, ngari ɓamti tew makko oo, ngaɗoyi ɗum e yanaande. ");
INSERT INTO ffm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nelaaɓe ɓee ngarti e Iisaa, njantanii ɗum ko ngaɗi koo e ko mbaajii koo fuu. ");
INSERT INTO ffm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","O wii ɓe: —Njehen nokku teelɗo, yalla oɗon keɓa fowtinaade. Sabi yaha-warta ana heewi, faa kanko e taalibaaɓe makko ɓee, ɓe ndonki heɓude fay no ɓe ɲaamira. ");
INSERT INTO ffm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɓe njehi ɓe naatoyi laana, ɓe teeli kamɓe tan e feere maɓɓe, ");
INSERT INTO ffm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","tawi heewɓe njii eɓe njaha, annditi to ɓe peewi. Yimɓe heewɓe iwri e geelle ɗee fuu, keɲanii to ɓe peewi too, adii ɓe yottaade. ");
INSERT INTO ffm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nde o yalti e laana kaa ndee, o yii jamaa keewɗo. O yurminaa ɓe sanne, sabi eɓe mba'i no baali ɗi ngalaa duroowo nii. O darii omo waajoo ɓe kulle keewɗe. ");
INSERT INTO ffm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nde hiiri ndee, taalibaaɓe ɓee ɓattitii mo, mbii: —Jooni hiirii, kasen duu nokku oo yo ladde. ");
INSERT INTO ffm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yoppitin jamaa oo saakoo e geelle e daakaaji piliiɗi ɗii yalla ana coodoya ko ɲaama. ");
INSERT INTO ffm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","O jaabii ɓe, o wii: —Onon e ko'e mooɗon, ndokkee ɓe ko ɓe ɲaama! Non ɓe lamndii mo, ɓe mbii: —Ndennoo aɗa yiɗi min ɓama buuɗi cardi teemeɗe ɗiɗi min coodanoya ɓe buuru ko ɓe ɲaama? ");
INSERT INTO ffm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","E oon wakkati, o wii ɓe: —Hono foti buuruuje njogi-ɗon? Njehee ƴeewoyee! Nde ɓe njehi ɓe kumpitoyii ndee, ɓe mbii mo: —Buuruuje joy e liɗɗi ɗiɗi min njogii. ");
INSERT INTO ffm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","O yamiri taalibaaɓe ɓee njoƴƴinira jamaa oo tunaale-tunaale dow huɗo hecco. ");
INSERT INTO ffm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ɓe njooɗii ɓe ngaɗi tunaale-tunaale, yoga teemedere neɗɗo, yoga capanɗe njoyon. ");
INSERT INTO ffm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","O ɓami buuruuje joy ɗee e liɗɗi ɗiɗi ɗii, o tiggitii kammu, o yetti Laamɗo. O taƴi buuru oo, o hokki taalibaaɓe ɓee njeɗa yimɓe ɓee. Hono non liɗɗi ɗiɗi ɗii duu. ");
INSERT INTO ffm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ɓe fuu ɓe ɲaami faa ɓe keddi. ");
INSERT INTO ffm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Taalibaaɓe ɓee ndeentini kedde ɗee, kebbini cagiije sappo e ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ujunaaji joy gorko ɲaamunoo buuru oo. ");
INSERT INTO ffm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ɗon tan, Iisaa yamiri taalibaaɓe mum naata laana kaa yalla ana adoo ɗum oo too bannge weendu nduu faade Baytisayda, tawi kanko e hoore makko omo wondi e yoppitinde jamaa oo. ");
INSERT INTO ffm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nde o seerti e maɓɓe ndee, o ŋabboyi dow waamnde haayre faa o waɗa duwaawu. ");
INSERT INTO ffm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nde jemma wari ndee, tawi laana kaa ana hakkunde weendu too, kanko tan gooto heddii njoorndi. ");
INSERT INTO ffm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","O soynii taalibaaɓe ɓee ana ngurfa ko mbaawi fuu, sabi ɓe njaɓɓotooɓe henndu. Nde ɓadinoo weetude ndee, o wari e maɓɓe omo yaara koyɗe dow ndiyam ɗam, faa o hosi ƴaɓɓaade ɓe. ");
INSERT INTO ffm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Kaa nde ɓe njii mo omo yaha e dow ndiyam ɗam ndee, ɓe cikki ɗum seyɗaani, ɓe ndarii eɓe ngulla, ");
INSERT INTO ffm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sabi ɓe fuu, nde ɓe njiinoo mo ndee, ɓe kulii. Ɗon e ɗon Iisaa wii ɓe: —Mbaaltinee hakkillaaji mooɗon! Miin, mi Iisaa, pati kulee! ");
INSERT INTO ffm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","O naati laana kaa, o tawti ɓe, henndu nduu darii. Ɓe mugaa. ");
INSERT INTO ffm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ɓe paamaano haaynde nde Iisaa waɗiri buuru oo ndee, sabi ɓe wumɓe ɓerɗe. ");
INSERT INTO ffm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ɓe lummbi weendu nduu, ɓe njottii Genesaret, ɓe panndi ɗon. ");
INSERT INTO ffm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ɓe njalti e laana kaa tan, yimɓe ɓee annditi mo, ");
INSERT INTO ffm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","caakii e seraaji ɗii fuu, ana pawa ɲawɓe mum'en e dengeleeje, ana ngaddana mo nokku fuu ɗo nanaa omo woodi. ");
INSERT INTO ffm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Kasen duu ɗo Iisaa tawaa fuu, gila e ley gure faa e geelle faa e ladde, yimɓe ɓee ngaddan ɲawɓe mum'en e daalaaje, ana ɲaagoo mo mo acca ɓe mema fay so kommbol saaya makko. Kasen duu memɗo ɗum fuu sellii. ");
INSERT INTO ffm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisa'en e yoga e dunkee'en Sariya iwnooɓe Urusaliima pilii Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ɓe njii won e taalibaaɓe makko ana ɲaamira juuɗe coɓuɗe, ɗum woni tawa lootiraali no tawaangal maɓɓe worri nii. ");
INSERT INTO ffm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sabi Farisa'en e Yahuudiyankooɓe fuu ɲaamataa lootaali juuɗe mum'en faa laaɓa, neesu njaatiraaɓe maɓɓe oo ɓe njokki. ");
INSERT INTO ffm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","So ɓe ngartii luumo, ɓe ɲaamataa so ɓe lootaaki. Eɓe njogii neesuuji goɗɗi keewɗi ɗi ɓe njokki, ko wa'i hono lawƴude kore looɗe e potiije e kaaki jakawalle. ");
INSERT INTO ffm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","E oon wakkati, Farisa'en e dunkee'en Sariya lamndii Iisaa, mbii: —Koɗum waɗi so taalibaaɓe maa ɓee ana mbaasa rewde neesuuji njaatiraaɓe meeɗen ɗii, ana ɲaamira juuɗe coɓuɗe? ");
INSERT INTO ffm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","O jaabii ɓe, o wii: —Annabi Esaaya woofaali fey nde sappinoo e mooɗon, onon naafigi'en ɓee, ngol ɗoo konngol: «Ngol leɲol e haala tan teddinirta kam, kaa e ley ɓerɗe maɓɓe eɓe ngoɗɗi kam. ");
INSERT INTO ffm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Meere ɓe ndewata kam, sabi ko ɓe tuugii e ley janngingol maɓɓe koo yo jamirooje yimɓe tan.» ");
INSERT INTO ffm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Iisaa jokkini hen, wii: —Oɗon njoppa jamirooje Laamɗo ɗee, oɗon njokka neesuuji yimɓe ɗii. ");
INSERT INTO ffm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Eyyoo! Oɗon mbaawi salaade yamiroore Laamɗo faa loomtinon nde neesu mooɗon! ");
INSERT INTO ffm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sabi Muusaa wii: «Teddin inna maa e baam maa.» O wii kasen: «Kuɗuɗo inna mum naa baam mum, wareede laato jukkungo mum.» ");
INSERT INTO ffm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kaa onon, oɗon mbiya: so neɗɗo wii inna mum naa baam mum: «Ko kaannoo-mi wallirde ma koo yo Korbaan» (ɗum woni sadaka Laamɗo), ");
INSERT INTO ffm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","hankasen fotaa ko o walla inna makko naa baam makko. ");
INSERT INTO ffm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Hono non tosirton konngol Laamɗo neesuuji ɗi ndonondirton ɗii. Kasen duu oɗon ngaɗa kulle keewɗe baaɗe non. ");
INSERT INTO ffm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Caggal ɗum, Iisaa nodditi jamaa oo, wii ɗum: —Kettinanee kam, on fuu paamee: ");
INSERT INTO ffm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fay huunde naatataa e neɗɗo so soɓina ɗum, kaa kuɗɗe iwooje e neɗɗo ɗee, kaɲum coɓinta ɗum.  ");
INSERT INTO ffm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nde Iisaa seertii e jamaa oo so naatoyi ley suudu ndee, taalibaaɓe mum ɓee lamndii ɗum maanaa banndol ngol. ");
INSERT INTO ffm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","O wii ɓe: —Onon duu, eɗum finkinii on naa? On paamaali ko iwata sella so naata e hunduko neɗɗo koo, soɓintaa joomum? ");
INSERT INTO ffm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Sabi ɗum naataali e ɓernde joomum, e reedu mum naati, kasen duu ɗum yaltan. Ɗii haalaaji Iisaa daginirii ɲaamdu fuu. ");
INSERT INTO ffm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","O wii kasen: —Ko yaltata e ɓernde koo, ɗum soɓinta neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sabi e ɓernde neɗɗo miilooji bonɗi iwata so ndunƴa ɗum e faasigaaku e nguyka e ɲaako'aaku e ");
INSERT INTO ffm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","jeenu e joote e comndam e jammba e somburaaku e haasidaaku e mbonka e mawninkinaare, kaɲum e majjere. ");
INSERT INTO ffm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ɗeen geɗe bonɗe fuu e ɓernde iwata, kasen duu kaɲum'en coɓinta neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iisaa iwi ɗon fa'i leydi Tirus. O jippii e galle gooto. O yiɗaano fay gooto humpitoo omo ton, kaa o waawaano suuɗaade. ");
INSERT INTO ffm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","E ley ɗum, debbo gooto mo ɓinngel mum dewel laddaa, nani haala makko ana haalee, heɲanii mo sujidi yeeso makko. ");
INSERT INTO ffm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Oon debbo wanaa Yahuudiyanke, o leɲol Sirifenisi'en. O ɲaagii Iisaa itta ladde ndee e ɓiyiiko oo. ");
INSERT INTO ffm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kaa Iisaa wii mo: —Accu sukaaɓe ɓee kaara tafon. Sabi ɓamde ɲaamdu sukaaɓe so tippoo dawaaɗi moƴƴaa. ");
INSERT INTO ffm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Debbo oo jaabii, wii mo: —Goonga, Moobbo, kaa fay dawaaɗi minotooɗi ɗii ana ɲaama ɲaamdu sukaaɓe iwooru e la'al so saama nduu. ");
INSERT INTO ffm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","E oon wakkati, Iisaa wii mo: —Saabe oo jaabu, hootu, ladde ndee yaltii e ɓiya oo. ");
INSERT INTO ffm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","E ley ɗum, o hooti, o tawi ɓiyiiko oo ana lelii dow leeso, ladde ndee yaltii e mum. ");
INSERT INTO ffm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iisaa iwi leydi Tirus, wardi leydi Sidon, tacciti leydi ndi geelle sappo ndii, warti weendu Galili. ");
INSERT INTO ffm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","O waddanaa gorko paho mo haala mum laaɓaa, o ɲaagaa o fawa junngo makko e dow mum. ");
INSERT INTO ffm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","E oon wakkati, Iisaa woɗɗintini mo jamaa oo, waɗi peɗeeli mum e noppi makko, sirƴi, memiri cirƴe ɗee ɗemngal makko. ");
INSERT INTO ffm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Caggal ɗum, o tiggitii kammu, o uumi, o wii paho oo: —Efata! (Ɗum woni: «Sukkita!») ");
INSERT INTO ffm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ɗon e ɗon, noppi gorko oo cukkiti, ɗemngal mum tonngitii, hedde ana haalira no haalirtee nii. ");
INSERT INTO ffm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Iisaa haɗi yimɓe ɓee haalande ɗum fay gooto. Kaa omo haɗa ɓe ɗum tan, eɓe ɓeydoo haalde. ");
INSERT INTO ffm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ɓe kaaynaa faa yottii kaaddi, eɓe mbiya: —Golle makko fuu ana moƴƴi. Omo nanina faaɗuɓe, omo haalina muumɗuɓe. ");
INSERT INTO ffm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","E oon wakkati, jamaa keewɗo hawriti kasen. Nde wonnoo ɓe ngalaa ko ɓe ɲaama, Iisaa noddi taalibaaɓe mum ɓee, wii ɗum'en: ");
INSERT INTO ffm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ɓee yimɓe ana njurminii kam, sabi hannde woni balɗe tati eɓe ngondi e am, ɓe keddoraaki ko ɓe ɲaama. ");
INSERT INTO ffm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","So mi yoppitii ɓe koota tawee ɓe ɲaamaali, ɓe mboɓɓoto yolbere e laawol. Sabi yoga maɓɓe iwii to woɗɗi. ");
INSERT INTO ffm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Taalibaaɓe makko ɓee njaabii mo, mbii: —Hoto fuu keɓaten ko ɲamminen ɓe e ley ndee ladde jeereende? ");
INSERT INTO ffm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","O lamndii taalibaaɓe makko ɓee, o wii: —Hono foti buuruuje njogi-ɗon? Ɓe mbii mo: —Buuruuje jeɗɗi min njogii. ");
INSERT INTO ffm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","E ley ɗum, o yamiri jamaa oo jooɗoo e leydi. O ɓami buuruuje jeɗɗi ɗee, o yetti Laamɗo, o taƴi ɗe, o hokki taalibaaɓe makko ɓee njeɗa jamaa oo. Ɓe ngaɗiri non. ");
INSERT INTO ffm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Eɓe njoginoo kasen liikoy pamaroy seeɗa. Iisaa yetti Laamɗo dow makkoy, wii taalibaaɓe mum ɓee njeɗa koy, kankoy duu. ");
INSERT INTO ffm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ɓe ɲaami faa ɓe keddi. Taalibaaɓe ɓee ndeentini kedde ɗee, ɗe kebbini cagiije jeɗɗi. ");
INSERT INTO ffm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Eɓe poti ujunaaji nay neɗɗo. Caggal ɗum, Iisaa yoppiti ɓe, ");
INSERT INTO ffm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","naatidi e taalibaaɓe mum laana ɗon e ɗon, fa'i leydi Dalmanuuta. ");
INSERT INTO ffm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisa'en ɓee ngari, puɗɗi hiitondirde e Iisaa. Faa itta koro makko, ɓe ndaardi mo o holla ɓe taagumansa kaayniiɗo iwoowo dow kammu. ");
INSERT INTO ffm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iisaa uumi, wii: —Koɗum waɗi so oo ɗoo jamaanu ana ndaara holleede taagumansa? Miɗo haalana on goonga: fay taagumansa gooto mo heɓataa! ");
INSERT INTO ffm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Caggal ɗum, o seerti e maɓɓe, o naatti e laana kaa, o fa'i oo too bannge. ");
INSERT INTO ffm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Taalibaaɓe ɓee njeggiti yooɓaade ɲaamdu, sabi buuruwal gootal tan heddinoo e ley laana kaa. ");
INSERT INTO ffm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","E oon wakkati, o yaggini ɓe, o wii: —Kakkilee, ndeentee e ƴuufinirdi Farisa'en ndii e ndi Hirudus ndii. ");
INSERT INTO ffm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Taalibaaɓe ɓee ndarii ana kaalda ana mbiya ko en njooɓaaki buuru koo o wiiri non. ");
INSERT INTO ffm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Iisaa anndi ko ɓe kaalata koo, wii ɓe: —Ko waɗi so oɗon kaalda hakkunde mooɗon on njooɓaaki buuru? Tama faa jooni on paamataa? Naa on wumɓe ɓerɗe? ");
INSERT INTO ffm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Oɗon njogii gite, on njiyataa naa? Oɗon njogii noppi, on nanataa naa? Tama on miccitaaki ");
INSERT INTO ffm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","nde njeɗu-mi ujunaaji njoyon gorko buuruuje joy ndee, cagiije hono foti kebbin-ɗon kedde? Ɓe njaabii mo, ɓe mbii: —Cagiije sappo e ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","O lamndii ɓe kasen, o wii: —Nde njeɗu-mi ujunaaji nay neɗɗo buuruuje jeɗɗi ndee, cagiije hono foti kebbin-ɗon kedde? Ɓe njaabii mo, ɓe mbii: —Cagiije jeɗɗi. ");
INSERT INTO ffm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nden, o wii ɓe: —Faa jooni on paamataa naa? ");
INSERT INTO ffm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ɓe njottii Baytisayda, Iisaa waddanaa bumɗo, o ndaardaa o mema ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","O nanngi bumɗo oo, o renni ɗum ngeenndi ndii. Caggal ɗum, o sirƴi e gite mum, o fawi juuɗe makko e mum, o lamndii ɗum, o wii: —Won ko njiyataa naa? ");
INSERT INTO ffm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Bumɗo oo feerti gite mum, wii: —Miɗo yiya yimɓe, kaa eɓe mba'ani kam no leɗɗe jahooje nii. ");
INSERT INTO ffm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Iisaa fawi juuɗe mum e gite makko kasen. Nden o tawi o sellii, o wonti yiide no laaɓiri. ");
INSERT INTO ffm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Iisaa wii mo: —Hootu, kaa pati mbirfito-ɗaa ley ngeenndi ndii. ");
INSERT INTO ffm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Caggal ɗum, Iisaa e taalibaaɓe mum pahi geelle ɓadaangal Kaysariya Filipa. O lamndii ɓe ɗum ɗoo e laawol: —Homo yimɓe mbiyata ngon-mi? ");
INSERT INTO ffm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ɓe njaabii mo, ɓe mbii: —Won wiyooɓe a Yaayaa mo lootogal batisima, won wiyooɓe a annabi Iliyaasa, won wiyooɓe kasen a gooto e annabaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","O lamndii ɓe, o wii: —Onon nee, homo mbiyaton ngon-mi? Piyeer jaabii mo, wii: —Aan woni Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","E ley ɗum, o daalii ɓe daaloore sattunde pati ɓe kaalana ɗum fay gooto. ");
INSERT INTO ffm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","O fuɗɗi famminde ɓe: —Ana tilsi Ɓii Neɗɗo torree torraaji keewɗi, mawɓe ɓee e hooreeɓe yottinooɓe sadaka e dunkee'en Sariya tippitoto mo. O waree, caggal balɗe tati o immitoto. ");
INSERT INTO ffm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","O haalani ɓe ɗum faa laaɓi, nii Piyeer sawndintini mo, wii pati o haala hono ɗii haalaaji. ");
INSERT INTO ffm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","O yeeccitii, o ƴeewi taalibaaɓe makko ɓee, o jahii e Piyeer, o wii: —Woɗɗam aan Ibiliisa! Sabi miilooji maa ɗii iwrataa to Laamɗo, to yimɓe ɗi iwrata. ");
INSERT INTO ffm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Caggal ɗum, o noddi jamaa oo e taalibaaɓe makko ɓee, o wii ɗum'en: —Muuyɗo jokkude kam fuu, ŋootta yurmaade hoore mum, ɓama leggal mum bardugal, jokka e am. ");
INSERT INTO ffm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sabi muuyɗo danndude yonki mum, waasan ki. Kaa baasirɗo ki sabaabu am e sabaabu Kabaaru Lobbo oo, danndan ki. ");
INSERT INTO ffm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Koɗum heɓude aduna oo fuu nafata neɗɗo so tawii waasii yonki mum? ");
INSERT INTO ffm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Won ko neɗɗo waawi hokkitirde faa soottitoo yonki mum naa? ");
INSERT INTO ffm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Neɗɗo fuu jaannoriiɗo kam miin e haalaaji am ɗii e ley oo jamaanu coɓuɗo, luuttuɗo Laamɗo, miin, Ɓii Neɗɗo oo duu, mi yaannorto ɗum nde mi wardii e malaa'ika'en seniiɓe e ley teddeengal Baabiraaɗo am. ");
INSERT INTO ffm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","O wii ɓe kasen: —Miɗo haalana on goonga: yoga e wonɓe ɗoo ɓee maayataa tawee njiyaali Laamu Laamɗo oo ana warda baawɗe. ");
INSERT INTO ffm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Balɗe jeegom caggal mum, Iisaa yaadi e Piyeer e Yaakuuba e Yuhanna, o teeldoyi e mum'en dow waamnde haayre toownde. Noone makko waylitii yeeso maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kaddule makko ngatti jalbude, ndawni far faa fay cuuwoowo gooto waawaa rawninirde non e aduna oo. ");
INSERT INTO ffm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iliyaasa e Muusaa ɓanngani ɓe, ana kaalda e Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","E ley ɗum, Piyeer wii mo: —Moobbo, gonal amen ɗoo ana moƴƴi. Ɗal min ndarna ɗoo buguuji tati: aan wooturu, Muusaa wooturu, Iliyaasa wooturu. ");
INSERT INTO ffm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","O anndaano ko o haalannoo, sabi kulol manngol naati ɓe, kamɓe taalibaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Luurde wari suddi ɓe, daande iwri e ley luurde ndee ana wiya: —Oo ɗoo yo Ɓiyam mo korsin-mi. Kettindee mo! ");
INSERT INTO ffm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ɗon e ɗon, taalibaaɓe ɓee tiggitii, njiyaali fay gooto so wanaa Iisaa tan. ");
INSERT INTO ffm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","E ley ko ɓe njippotoo waamnde haayre ndee koo, o daalii ɓe pati ɓe kaalana fay gooto ko ɓe njii koo faa wakkati nde Ɓii Neɗɗo oo wuurti e hakkunde maayɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɓe njaɓii konngol ngol, kaa ɓe ndarii eɓe lamndondira e ko'e maɓɓe koɗum woni maanaa wuurtude e hakkunde maayɓe. ");
INSERT INTO ffm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Caggal ɗum, ɓe lamndii mo, ɓe mbii: —Koɗum waɗi so dunkee'en Sariya ɓee ana mbiya annabi Iliyaasa haani adaade Almasiihu warde? ");
INSERT INTO ffm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","O jaabii ɓe: —Goonga, Iliyaasa adotoo warde tafon moƴƴintinde kulle ɗee fuu. Ndennoo ko saabii so Binndi ɗii mbii ana tilsi Ɓii Neɗɗo torree torraaji keewɗi, hoynee? ");
INSERT INTO ffm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Miɗo haalana on: Iliyaasa warii, ɓe ngollii ɗum kamɓe duu ko ɓe muuyi fuu, hono no haala makko haaliraa e Binndi ɗii nii. ");
INSERT INTO ffm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nde ɓe ngarti e taalibaaɓe heddiiɓe ɓee ndee, ɓe njii jamaa keewɗo ana filii ɗum'en, dunkee'en Sariya ɓee ana njeddondira e mum'en. ");
INSERT INTO ffm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Yimɓe ɓee njii Iisaa tan, ɓe fuu ɓe kaaynaa, ɓe ndogi ɓe njaɓɓoyii mo. ");
INSERT INTO ffm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","O lamndii ɓe, o wii: —Koɗum njeddondirton e maɓɓe? ");
INSERT INTO ffm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Gorko gooto jaabii mo e jamaa oo, wii: —Moobbo, mi gaddanɗo ma ɓiyam gorko mo ladde muumɗini. ");
INSERT INTO ffm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ɗo ladde ndee immorii mo fuu, liɓan mo e leydi, hunduko makko ƴufa ngufo, o ŋerƴondira ɲiiƴe, o yoora kolon. Mi ɲaagike taalibaaɓe maa ɓee ndibba nde, kaa ɓe ndonkii. ");
INSERT INTO ffm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iisaa wii yimɓe ɓee: —Hey yimɓe jamaanu jooni ɓe nganaa goonɗinɓe! Faa mande tilotoo-mi e mon? Faa mande keddotoo-mi muɲande on? Ngaddanee kam suka oo! ");
INSERT INTO ffm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","O waddanaa oon. Nde ladde ndee yii Iisaa ndee, dimmbi suka oo, liɓi ɗum, hedde suka oo ana talloo e leydi, hunduko mum ana ƴufa ngufo. ");
INSERT INTO ffm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Iisaa lamndii baaba suka oo, wii: —Gila mande ɗum heɓi mo? Baaba oo jaabii, wii: —Gila omo famɗi. ");
INSERT INTO ffm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kasen duu wakkati fuu ladde ndee ana liɓa mo ley yiite naa ndiyam faa halka mo. Yurma min, mballaa min so tawii aɗa waawi! ");
INSERT INTO ffm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Iisaa wii mo: —So miɗo waawi mbii-ɗaa? Huunde fuu ana waawi laatanaade goonɗinɗo. ");
INSERT INTO ffm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ɗon e ɗon, baaba suka oo wulli, wii: —Mi goonɗinii, kaa wallam, sabi goonɗinde ana tiiɗi kam! ");
INSERT INTO ffm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nde Iisaa yii jamaa oo ana doga ana wara ndee, jahii e ladde ndee, wii ɗum: —Ladde muumɗinoore faaɗinoore, mi yamirii ma yaltu e suka oo, pati naattu e makko abada kasen! ");
INSERT INTO ffm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ladde ndee wulli, dimmbi suka oo semmbe, yalti. O wa'i no maayɗo nii, faa ko heewi e wonnooɓe ɗon ɓee ndarii ana mbiya o maayii. ");
INSERT INTO ffm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kaa Iisaa nanngi junngo makko, immini mo tan, o darii. ");
INSERT INTO ffm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nden Iisaa naati suudu, taalibaaɓe mum ɓee teeldi e mum, lamndii ɗum, mbii: —Koɗum waɗi so min ndonki ribbude ladde ndee? ");
INSERT INTO ffm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","O jaabii: —Ndee ladde, sii mum ribbirtaake so wanaa duwaawu. ");
INSERT INTO ffm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ɓe iwi ɗon, ɓe ceeki leydi Galili. O yiɗaa fay gooto annda ɗum, ");
INSERT INTO ffm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sabi omo waajotonoo taalibaaɓe makko ɓee, kasen duu omo wiyannoo ɗum'en: —Ɓii Neɗɗo oo waɗete e juuɗe yimɓe, ɓe mbara mo, kaa e ley balɗe tati caggal maayde makko, o wuurtan. ");
INSERT INTO ffm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kaa taalibaaɓe makko ɓee paamaali haala kaa, kulii lamndaade mo. ");
INSERT INTO ffm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ɓe njottii Kafarnahum. Nde ɓe njippinoo e galle ndee, o lamndii taalibaaɓe makko, o wii: —Koɗum njeddondir-ɗon e laawol ngol? ");
INSERT INTO ffm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɓe ndeƴƴinii. Ko ɓe njeddondiri e laawol ngol dee, ɓurɗo teddude. ");
INSERT INTO ffm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ndennoo Iisaa jooɗii, noddi taalibaaɓe sappo e ɗiɗon ɓee, wii ɗum'en: —Muuyɗo ardaade fuu, caggal heddiiɓe ɓee heedata, laatoo golloowo maɓɓe ɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Caggal ɗum, o nanngi junngo cukalel, o darni ngel yeeso maɓɓe, o huufi ngel, o wii ɓe: ");
INSERT INTO ffm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Neɗɗo fuu jaɓɓiiɗo cukalel gootel hono ngel e innde am, miin jaati o jaɓɓii. Kasen duu jaɓɓiiɗo kam fuu, wanaa miin tan jaɓɓii, jaɓɓike nelɗo kam oo duu. ");
INSERT INTO ffm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yuhanna wii mo: —Moobbo, min njii gorko gooto ana ribbira seyɗaani'en innde maa. Min kaɗii mo, sabi o jokkaali e meeɗen. ");
INSERT INTO ffm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Kaa Iisaa wii: —Pati kaɗee mo ɗum, sabi fay gooto waawaa waɗirde kaayɗe e innde am, so sakitoo bonkoo kam ɗon e ɗon. ");
INSERT INTO ffm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Sabi mo honnaaki en fuu, e meeɗen wondi. ");
INSERT INTO ffm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Miɗo haalana on goonga: neɗɗo fuu dokkuɗo on horde ndiyam kammari on yimɓe Almasiihu, o waasataa heɓude mbarjaari makko. ");
INSERT INTO ffm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Neɗɗo fuu luuttinɗo gootel e koy cukaloy goonɗinkoy kam, ko ɓuri moƴƴande joomum haayre teddunde haɓɓee e daande mum, tippee e geeci. ");
INSERT INTO ffm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","So tawii junngo maa luuttinte, taƴu ngo. Naataa e nguurndam nduumiiɗam a ɲakuɗo ɓuri moƴƴande ma diina naatude e jahannama yiite nge ɲifataa tawee a kiɓɓuɗo.  ");
INSERT INTO ffm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","So tawii koyngal maa luuttinte, taƴu ngal. Naataa e nguurndam nduumiiɗam a ɲakuɗo ɓuri moƴƴande ma diina tippeede e jahannama a kiɓɓuɗo.  ");
INSERT INTO ffm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Kasen duu so yitere maa luuttinte, sol nde. Sabi naatude maa e Laamu Laamɗo a ɗokko ɓuri moƴƴande ma diina tippe-ɗaa e jahannama a kiɓɓuɗo. ");
INSERT INTO ffm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ɗon, «gilɗi mum mbaatataa, yiite mum duu ɲifataa.» ");
INSERT INTO ffm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sabi gooto fuu laɓɓinirte yiite hono no sadakaaji laɓɓinirtee lamɗam nii. ");
INSERT INTO ffm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Lamɗam yo huunde lobbere, so lamɗam ŋoottii lammude, koɗum lamminta ɗum? Ngaɗee lamɗam e mooɗon, moƴƴondiron. ");
INSERT INTO ffm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","O iwi ɗon, o feewi leydi Yahuudiya e funnaange maayo Urdun. Yimɓe heewɓe pilii mo, o darii omo waajoo ɗum'en kasen, hono no o woownoo nii. ");
INSERT INTO ffm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yoga e Farisa'en ngari faa itta koro makko, lamndii mo: —Tama ana daganii gorko seerde jom suudu mum? ");
INSERT INTO ffm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","O jaabii ɓe: —Koɗum Muusaa yamiri on? ");
INSERT INTO ffm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ɓe njaabii, ɓe mbii: —Muusaa yamirii gorko winnda talkuru ceergal nde ana seera jom suudu mum. ");
INSERT INTO ffm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","E ley ɗum, o wii ɓe: —On yoorɓe ɓerɗe, ɗum saabii so Muusaa winndani on nden yamiroore. ");
INSERT INTO ffm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kaa gila e fuɗɗoode, «Laamɗo tagii ɓe waɗii ɓe gorko e debbo. ");
INSERT INTO ffm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɗum waɗi so gorko yoppan inna mum e baam mum, ");
INSERT INTO ffm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ɓe ɗiɗon fuu ɓe laatoo neɗɗo gooto.» Nii woni ɓe nganaa ɗiɗon kasen, ɓe neɗɗo gooto. ");
INSERT INTO ffm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ndennoo, pati neɗɗo seenndu ko Laamɗo reentini. ");
INSERT INTO ffm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nde ɓe kootunoo cuuɗi ndee, taalibaaɓe makko ɓee lamndii mo haala majjum. ");
INSERT INTO ffm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","O wii ɓe: —Ceerɗo jom suudu mum fuu so ɓami goɗɗo, jeenii, ");
INSERT INTO ffm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","hono non duu, debbo cuutaniiɗo gorum, so gorko goɗɗo ɓami ɗum, oon debbo jeenii. ");
INSERT INTO ffm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Won waddanɓe Iisaa cukaloy, yalla ana mema koy, non taalibaaɓe ɓee njahii e yimɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Nde o yii ɗum ndee, o ɓerni, o wii taalibaaɓe ɓee: —Accee cukaloy koy ngara e am, pati kaɗee koy, sabi wa'uɓe no makkoy nii ɓee njey Laamu Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Miɗo haalana on goonga: mo jaɓiraali Laamu Laamɗo oo no cukalel nii fuu, naatataa hen. ");
INSERT INTO ffm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Caggal ɗum, o huufi cukaloy koy, o fawi junngo makko e makkoy, o duwanii koy. ");
INSERT INTO ffm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nde Iisaa nanngunoo laawol ndee, gorko gooto dogani mo, diccii yeeso makko, lamndii mo, wii: —Moobbo moƴƴo, koɗum kaan-mi waɗude faa mi heɓa nguurndam nduumiiɗam? ");
INSERT INTO ffm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Iisaa wii mo: —Ko saabii so aɗa noddira kam moƴƴo? Moƴƴo walaa so wanaa gooto, oo woni Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Aɗa anndi ɗii ɗoo sariyaaji: «Pati ɲaaɗu hoore, pati jeenu, pati wujju, pati seeda fenaande, pati tooɲu, teddin inna maa e baam maa.» ");
INSERT INTO ffm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Gorko oo jaabii mo, wii: —Moobbo, miɗo haybi ɗum fuu gila e cukaaku am. ");
INSERT INTO ffm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nden Iisaa ƴeewi mo, yiɗi mo, wii mo: —Huunde wootere ana ɲaku maa: yaa soottoy ko njogi-ɗaa koo fuu, ndokkaa kaalisi oo misikiina'en. Nden, a heɓan jawdi dow kammu. Caggal ɗum, ngaraa njokkaa kam. ");
INSERT INTO ffm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kaa nde gorko oo nani ɗiin haalaaji ndee, ɲirɓinii, wittidi e metti, sabi o arsukunte ɲolɗo. ");
INSERT INTO ffm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iisaa ƴeewi taalibaaɓe mum ɓee, wii: —Hee naatugol arsukunte e Laamu Laamɗo ana tiiɗi! ");
INSERT INTO ffm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Taalibaaɓe ɓee mugaa e ɗiin haalaaji. O ɓeydi hen kasen, o wii ɓe: —Sukaaɓe am, hee naatude e Laamu Laamɗo ana tiiɗi! ");
INSERT INTO ffm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Sabi ngelooba ƴaɓɓoroo e wuddere mesalal ɓuri newaade diina naatugol arsukunte e Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Taalibaaɓe ɓee ɓeydii mugeede, hedde ana lamndondira e ko'e mum'en ana mbiya: —Ndennoo, homo woni kisoowo? ");
INSERT INTO ffm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","O ƴeewi ɓe, o wii: —Ɗo yimɓe ɗum laatataako, kaa eɗum laatoo to Laamɗo. Sabi walaa fuu ko Laamɗo waawaa. ");
INSERT INTO ffm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nden, Piyeer darii ana wiya mo: —Minen, min njoppii fuu min njokkii e maa! ");
INSERT INTO ffm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","O jaabii ɗum, o wii: —Miɗo haalana on goonga: neɗɗo fuu joppirɗo saabe am e saabe Kabaaru Lobbo oo galle mum naa sakiraaɓe mum worɓe naa sakiraaɓe mum rewɓe naa inna mum naa baam mum naa sukaaɓe mum naa gese mum, ");
INSERT INTO ffm_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","heɓan ko ɓuri ɗum cowe teemedere e oo ɗoo wakkati mo ngon-ɗen e mum jooni: joomum heɓan galleeji e sakiraaɓe worɓe e sakiraaɓe rewɓe e inniraaɓe e sukaaɓe e gese, torrete duu. E ley wakkati garoyoowo oo duu, joomum heɓan nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kaa ardinooɓe heewɓe laatoto caggalaaɓe, caggalaaɓe ɓee laatoto ardiiɓe. ");
INSERT INTO ffm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Eɓe e laawol faa ɓe ŋabbita Urusaliima. Iisaa ardii ɓe, tawi taalibaaɓe ɓee ana cuŋli, jokkunooɓe e maɓɓe ɓee duu yo hulɓe. O noddi taalibaaɓe sappo e ɗiɗon ɓee, o darii omo haalana ɗum'en ko warata heɓude mo. ");
INSERT INTO ffm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","O wii ɓe: —Kettinee, eɗen nii ŋabbita Urusaliima, ɗon Ɓii Neɗɗo oo waɗetee e juuɗe hooreeɓe yottinooɓe sadaka e dunkee'en Sariya. Ɓe caran mo waree, ɓe ngaɗa mo e juuɗe heeferɓe. ");
INSERT INTO ffm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ɓeen njaayran mo, tutta e makko, piya mo dorri, mbara mo. Kaa balɗe tati caggal mum, o wuurtan. ");
INSERT INTO ffm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Caggal ɗum, Yaakuuba e Yuhanna ɓiɓɓe Jebede ɓee ngari e Iisaa, mbii ɗum: —Moobbo, won ko min njiɗi ɲaagaade ma, miɗen njiɗi ngaɗanaa min ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","O wii ɓe: —Koɗum njiɗ-ɗon mi waɗana on? ");
INSERT INTO ffm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ɓe njaabii mo: —Ngaɗanaa min min njooɗoo oo bannge maa ɲaamo, oo bannge maa nano e ley teddeengal maa. ");
INSERT INTO ffm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","O jaabii ɓe, o wii: —On anndaa ko ɲaagoto-ɗon. Oɗon mbaawi yarde horde mettunde nde njaran-mi ndee, naa batiseede batisima naawɗo mo mbatisetee-mi oo naa? ");
INSERT INTO ffm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ɓe njaabii mo, ɓe mbii: —Miɗen mbaawi. O wii ɓe: —On njaran horde nde njaran-mi ndee, keɓon batisima mo mbatisetee-mi oo. ");
INSERT INTO ffm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kaa jooɗagol bannge am ɲaamo naa nano wanaa miin yamirta ɗum. Ɗeen joolle, ɓe Laamɗo moƴƴinani ɗum'en ɓee njey ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nde taalibaaɓe sappo heddiiɓe ɓee nani ɗum ndee, mettaa e Yaakuuba e Yuhanna. ");
INSERT INTO ffm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Iisaa noddi ɓe fuu, wii: —Oɗon anndi jataaɓe laamiiɓe heeferɓe ɓee, ana kawjorii yimɓe mum'en hawju bonɗo, mawɓe ɓee duu ana laamorii laamu boɗeejo. ");
INSERT INTO ffm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Onon kaa, ɗum waɗataa hakkunde mooɗon. So won jiɗɗo teddeengal hakkunde mon, ana haani laataade golloowo mooɗon. ");
INSERT INTO ffm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kasen so won muuyɗo ardaade e mon, ana haani laataade maccuɗo mooɗon, on fuu. ");
INSERT INTO ffm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Sabi fay Ɓii Neɗɗo wardaali faa gollanee, gollande yimɓe wardi, hokkitira yonki mum yalla ana laatoo coottitaari heewɓe. ");
INSERT INTO ffm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ɓe njottii Yeriko. Nde Iisaa e taalibaaɓe mum ɓee njalti ngeenndi ndii ndee, kamɓe e jamaa keewɗo, ɓe tawi bumɗo biyeteeɗo Bartime ɓii Time ana jooɗii ana garbinoo e sera laawol ngol. ");
INSERT INTO ffm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nde o nani Iisaa Nasaraatunke oo ɓettotoo ɗon ndee, o darii omo wulla omo wiya: —Iisaa, taanii Daawuuda, yurmam! ");
INSERT INTO ffm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Heewɓe ndarii ana njahoo e makko ana mbiya o deƴƴinoo, kaa o ɓeydii wullude, omo wiya: —Taanii Daawuuda, yurmam! ");
INSERT INTO ffm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iisaa darii, wii: —Noddee mo. Nden, ɓe noddi bumɗo oo, ɓe mbii ɗum: —Seya, imma, o noddii ma. ");
INSERT INTO ffm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","O gurbitii, o tippii disaare makko, o wari e Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Iisaa lamndii mo, wii: —Koɗum njiɗ-ɗaa mi waɗane? Bumɗo oo jaabii mo, wii: —Moobbo, mi hewta gite am. ");
INSERT INTO ffm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Iisaa wii mo: —Yaa, goonɗinal maa danndii ma. Ɗon e ɗon o wumti, o yaadi e Iisaa jahaangal muuɗum ngal. ");
INSERT INTO ffm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nde ɓe ɓadinoo Urusaliima, ɓe njottii Baytifaaji e Baytaniya, dow waamnde haayre wiyeteende Jaytun, Iisaa neli taalibaaɓe mum ɗiɗon, ");
INSERT INTO ffm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","o wii ɓe: —Njehee naatoyee ngeenndi ngonndi yeeso mon ndii. Oon wakkati fuu, on tawan mola ndakiiwa nga fay gooto waɗɗaaki abada ana haɓɓii. Kumton nga, ngaddon nga ɗoo. ");
INSERT INTO ffm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","So won biiɗo on ko ngatton nga, njaabo-ɗon Moobbo ana haajaa nga. Ɗon e ɗon on njoppete ngaddon nga. ");
INSERT INTO ffm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ɓe njehi, ɓe tawi mola ana haɓɓii damal sella, ɓe kumti ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yoga e darinooɓe ɗon ɓee lamndii ɓe: —Koɗum ngollaton ɗoo? Ko kumtirton mola ngaa? ");
INSERT INTO ffm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ɓe njaaborii ɓeen no Iisaa wiirunoo nii. Ɓeen njoppi ɓe. ");
INSERT INTO ffm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓe naɓani Iisaa mola ngaa, ɓe njappi e magga saayaaji maɓɓe, o waɗɗii. ");
INSERT INTO ffm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Heewɓe mbeerti saayaaji mum'en e laawol, woɓɓe kelti caɓe leɗɗe sera ton, mbeerti ɗe e laawol ngol. ");
INSERT INTO ffm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ɓee ardii mo, ɓee keedi caggal makko eɓe ilinoo: —Jettooje e barke ngoodanii gardoowo e dow innde Joomiraaɗo! ");
INSERT INTO ffm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Barke woodanii laamu njaati meeɗen Daawuuda, laamu garoowo oo! Jettooje ngoodanii Laamɗo Toowɗo! ");
INSERT INTO ffm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iisaa ŋabbiti Urusaliima tan, naatoyi Suudu Dewal Mawndu nduu. Nde o yiinoo ko woni e mayru fuu ndee, o feewi Baytaniya kanko e sappo e ɗiɗon ɓee, tawi hiirii. ");
INSERT INTO ffm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Janngo mum, caggal ɓe ndawii Baytaniya, tawi omo yolbi. ");
INSERT INTO ffm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","O soynii ibbi mbillitikki, o yehi ƴeewoyde yalla omo tawa e makki ɓiɓɓe. Nde o yottinoo ki ndee, o tawaali e makki so wanaa haakolooji. Sabi oon wakkati wanaa wakkati rimugol ibbe. ");
INSERT INTO ffm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","O wii ibbi kii: —Pati fay gooto ɲaamu ɓiɓɓe maa abada kasen! Taalibaaɓe makko ɓee nani ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ɓe njottii Urusaliima, Iisaa naati daalaare Suudu Dewal Mawndu nduu, o darii omo ribba soodooɓe e soottooɓe wonɓe ley mayre ɓee. O liɓi taabe weccooɓe kaalisi e jooɗorɗe soottooɓe buugaaji. ");
INSERT INTO ffm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","O ɗalaali fay gooto seeka daalaare Suudu Dewal Mawndu nduu ana roondii kaaki. ");
INSERT INTO ffm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","O waajii ɓe: —Tama wanaa ana winndii: «Suudu am nduu noddirte suudu rewrudu leɲi fuu!» Kaa onon, on ngaɗii ndu suuɗorde yanooɓe. ");
INSERT INTO ffm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Hooreeɓe yottinooɓe sadaka e dunkee'en Sariya nani ɗum, ndaari no masinbinira mo. Ɓe kuli mo, sabi waaju makko oo naatii jamaa oo sanne. ");
INSERT INTO ffm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nde hiirnoo ndee, kanko e taalibaaɓe makko ɓe njalti ngeenndi ndii. ");
INSERT INTO ffm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Janngo mum, beetee law, eɓe ɓettoroo to ibbi kii too, ɓe njii ki yoorii kolon faa yottii ɗaɗi. ");
INSERT INTO ffm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piyeer miccitii, wii mo: —Moobbo, ƴeew! Ibbi ki kuɗuno-ɗaa kii yoorii. ");
INSERT INTO ffm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Iisaa jaabii, wii ɓe: —Ngoonɗinee Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Miɗo haalana on goonga: neɗɗo fuu biiɗo ndee waamnde haayre: «Ɗoofa, saamoy ley maayo geeci», sikkitaaki ley ɓernde mum, goonɗinii ko wii koo waɗan, jaɓante. ");
INSERT INTO ffm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ɗum saabii so miɗo wiya on: ko ɲaagi-ɗon e ley duwaawu fuu, ngoonɗinee on keɓii ɗum, nden, on njaɓante. ");
INSERT INTO ffm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Nde ndari-ɗon faa ngaɗon duwaawu fuu, so won gaɗunooɗo on huunde, njaafee ɗum, yalla Baabiraaɗo mon gonɗo dow kammu oo ana yaafoo on luutti mooɗon.  ");
INSERT INTO ffm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ɓe mbirfitii Urusaliima kasen. E ley no o yiilortoo ley Suudu Dewal Mawndu nii, hooreeɓe yottinooɓe sadaka e dunkee'en Sariya e mawɓe ɓattitii mo ");
INSERT INTO ffm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","lamndii mo: —Yamiroore hende ngollirtaa ko ngollataa koo? Homo yamir maa ngollaa ɗum? ");
INSERT INTO ffm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Iisaa wii: —Huunde wootere tan lamndotoo-mi on. Njaabo-ɗon kam, mi haalanan on jamirɗo kam mi golla ko ngollan-mi koo. ");
INSERT INTO ffm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Lootogal batisimaYaayaa ngal to Laamɗo iwri naa to yimɓe? Njaabee kam! ");
INSERT INTO ffm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ɓe ndawridi hakkunde maɓɓe, ɓe mbii: —So en mbii to Laamɗo, o wiyan: «Ndennoo ko saabii so on ngoonɗinaali Yaayaa?» ");
INSERT INTO ffm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","En mbiyan «yimɓe» naa? Eɓe kula yimɓe ɓee sabi ɓe fuu eɓe njogorii Yaayaa yo annabaajo jaati. ");
INSERT INTO ffm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɓe njaabii Iisaa, ɓe mbii: —Min anndaa. Iisaa wii ɓe: —Haya miin duu, mi haalantaa on yamiroore nde ngolliran-mi ko ngollan-mi koo. ");
INSERT INTO ffm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iisaa fuɗɗi haaldirde e maɓɓe e banndol, o wii: —Neɗɗo gooto tuti ngesa peguuje, o filtini nga kokowol, o asi ngaykaare ɓoosirde, o mahi doomirdu. Caggal ɗum, o hasiri nga woɓɓe, o dawi. ");
INSERT INTO ffm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nde teɓugol yottinoo, o neli golloowo makko to remooɓe ɓee too, ɓe ngaddanoya mo ngeɗu makko e ɓiɓɓe peguuje ɗee. ");
INSERT INTO ffm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ɓe nanngi nelaaɗo oo, ɓe pii ɗum, ɓe mbirfini ɗum juuɗe teete. ");
INSERT INTO ffm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","O neli e maɓɓe golloowo makko goɗɗo. Ɓe koyni ɗum, ɓe eli ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jom ngesa oo neli kasen golloowo mum tataɓo, ɓe mbari ɗum. Non ɓe ngaɗiri woɓɓe heewɓe: ɓe pii yoga, ɓe mbari yoga. ");
INSERT INTO ffm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Jooni kaa gooto tan o heddorii, ɓiyiiko korsuɗo oo. Sakitii o neli oo duu e maɓɓe, o wii: «Ɓe njaagoto ɓiyam oo.» ");
INSERT INTO ffm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kaa remooɓe ɓee mbiyondiri e ko'e mum'en: «Oo woni donoowo mo. Ngaree mbaren mo, keddoro-ɗen ngesa ngaa!» ");
INSERT INTO ffm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ɓe nanngi ɓiɗɗo oo, ɓe mbari ɗum, ɓe mbedii ɗum to caggal ngesa too. ");
INSERT INTO ffm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jooni nee, hono jom ngesa oo waɗata? O waran, o halka remooɓe ɓee, o hasira ngesa ngaa woɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Tama on njanngaali ko winndaa ley Binndi ɗii koo? «Haayre nde mahooɓe ɓee tippitii ndee, kaɲum laatii haayre ɓurnde fuu teentilaade e maadi ndii. ");
INSERT INTO ffm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ɗum yo golle Joomiraaɗo, kanjum ɗum haaynde e jiile meeɗen!» ");
INSERT INTO ffm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Hooreeɓe Yahuudiyankooɓe tewti no nanngira Iisaa, sabi ɓe paamii ngol banndol e maɓɓe fewti. Kaa ɓe cuusaano jamaa oo, ɗum waɗi so ɓe njoppi mo, ɓe mbitti. ");
INSERT INTO ffm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ɓe neli e makko yoga e Farisa'en e howruuɓe Hirudus yalla ana tuufinira mo konngol makko. ");
INSERT INTO ffm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ɓe ngari, ɓe mbii mo: —Moobbo, miɗen anndi a goongirante: a hulataa fay gooto, sabi a ɓurdintaa yimɓe, aɗa jannginira laawol Laamɗo ngol goonga. Ana dagoo min ndokka kaananke Roma mawɗo oo lampo naa dagaaki? Min ndokka mo naa pati min ndokka mo? ");
INSERT INTO ffm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nde wonnoo omo anndi naafigaaku maɓɓe, o wii ɓe: —Koɗum waɗi so oɗon tuufana kam? Ngaddanee kam mbuuɗu cardi faa mi yiya ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓe ngaddani mo. O lamndii ɓe: —Natal homo e innde homo woni ɗoo? Ɓe mbii mo: —Kaananke Roma. ");
INSERT INTO ffm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","O jaabii ɓe, o wii: —Ndennoo ndokkee kaananke Roma ko jey, ndokkee Laamɗo duu ko jey. Ɓe kaaynaa e makko. ");
INSERT INTO ffm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Yoga e Saduki'en ngari e makko. Kamɓe ngoni fennuɓe immital. Ɓe lamndii mo, ɓe mbii: ");
INSERT INTO ffm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Moobbo, Muusaa yamirii en so neɗɗo maayii heɓaali ɓiɗɗo, miɲum naa mawnum ɓamta debbo ɗalaaɗo oo yalla ana heɓana ɗum ɓeyngu. ");
INSERT INTO ffm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Waɗiino e ɓettaade rimdaaɓe njeɗɗon. Arano oo ɓami debbo, maayi, heɓaali ɓiɗɗo. ");
INSERT INTO ffm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ɗiɗaɓo oo ɓamti debbo oo, kaɲum duu maayi heɓaali ɓiɗɗo. Tataɓo oo duu waɗi hono non. ");
INSERT INTO ffm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Hono nii njeɗɗon ɓee fuu ɓamiri mo, ɗalaali ɓiɗɗo. Caggal maɓɓe ɓe fuu, debbo oo duu maayi. ");
INSERT INTO ffm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ndennoo, ɲannde immital, homo e maɓɓe debbo oo laatotoo jom suudu mum? Sabi ɓe njeɗɗon fuu ɓe ɓamiino mo! ");
INSERT INTO ffm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Iisaa jaabii ɓe, wii: —Hee on majjii! On paamaali Binndi ɗii, on paamaali baawɗe Laamɗo ɗee. ");
INSERT INTO ffm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sabi so maayɓe immitike, worɓe ɓamataa, rewɓe ɓamataake, ɓe laatoto hono no malaa'ika'en wonɓe dow kammu ɓee nii. ");
INSERT INTO ffm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ko maayɓe immitoto koo, on njanngaali e dewtere Muusaa haala wuutuure, hono Laamɗo haaldiri e makko, wii: «Miin woni Laamɗo Ibarahiima, Laamɗo Isiyaaka, Laamɗo Yaakuuba»? ");
INSERT INTO ffm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Laamɗo yo Laamɗo wuurɓe, wanaa Laamɗo maayɓe. On majjuɓe sanne. ");
INSERT INTO ffm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Dunkee Sariya gooto ɓattitii Iisaa, nani jeddondiral maɓɓe, nani o jaabike Saduki'en ɓee faa gasi, lamndii mo: —Jamirooje ɗee fuu, honde ɓuri teentilaade? ");
INSERT INTO ffm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Iisaa jaabii mo: —Ɓurnde fuu teentilaade e jamirooje ɗee yo ndee ɗoo: «Hettina Israa'iila, Laamɗo Joomiraaɗo meeɗen oo tan woni Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Yiɗir Laamɗo Joomiraaɗo maa ɓernde maa fuu e yonki maa fuu e hakkille maa fuu e semmbe maa fuu.» ");
INSERT INTO ffm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ɗiɗaɓerde ndee yo hono mayre, kayre woni: «Njiɗiraa tanaa maa no njiɗir-ɗaa hoore maa nii.» Walaa fuu yamiroore ɓurnde ɗee ɗiɗi teentilaade. ");
INSERT INTO ffm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","33","Dunkee Sariya oo wii mo: —Moobbo! A haalii goonga nde mbii-ɗaa Laamɗo tan woni Joomiraaɗo, kasen duu Laamɗo goɗɗo walaa so wanaa kanko. E yiɗirde Laamɗo ɓernde fuu e hakkille fuu e semmbe fuu, e yiɗirde tanaa no hoore mum nii, kanjum ɓuri sadakaaji duppamaaji e kirsamaaji fuu! Haala maa ana selli sanne. ");
INSERT INTO ffm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nde Iisaa yii o jaaborike hakkilantaaku ndee, wii mo: —A woɗɗaa Laamu Laamɗo oo. Caggal ɗum, fay gooto suusaali lamndaade Iisaa huunde. ");
INSERT INTO ffm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nde Iisaa waajotoo ley Suudu Dewal Mawndu ndee, wii: —Hono dunkee'en Sariya ɓee mbaawiri wiirude Almasiihu oo yo taanii Daawuuda tan? ");
INSERT INTO ffm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sabi Daawuuda e hoore mum wiirii Ruuhu Ceniiɗo: «Joomiraaɗo wii Joomam: Jooɗa ɲaamo am, faa mi waɗa njaɓɓaa wayɓe maa.» ");
INSERT INTO ffm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Daawuuda e hoore mum «Joomam» noddirta mo. Ndennoo, hono o laatortoo taanum tan? Jamaa keewɗo ana hettiranoo Iisaa seyo. ");
INSERT INTO ffm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","E ley waajagol makko ngol, o wii ɓe: —Ndeentee e dunkee'en Sariya yiɗuɓe yiiloraade saayaaji mawɗi e jowteede ley luumooji, ");
INSERT INTO ffm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","fooɗantooɓe joolle ɓurɗe teddude e ley cuuɗi baajorɗi e ley yanngeeji fuu. ");
INSERT INTO ffm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Eɓe teeta cuuɗi rewɓe talka'en ɓe worɓe mum'en maayi, eɓe njuutina duwaawuuji maɓɓe faa ɓe nanndinkinoo e moƴƴuɓe. Kamɓe, jukkungo naawngo ɓurata jippineede e muuɗum'en. ");
INSERT INTO ffm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iisaa jooɗii fewti e keesu Suudu Dewal Mawndu nduu, yii no jamaa oo waɗirta kaalisi e keesu oo nii. Arsukunte'en heewɓe ngaɗi e makko kaalisi keewɗo. ");
INSERT INTO ffm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Debbo talka mo gorum maayi wari, waɗi hen buuɗi ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iisaa noddi taalibaaɓe mum ɓee, wii ɗum'en: —Miɗo haalana on goonga: oo debbo talka, ko o waɗi e ley keesu oo koo ana ɓuri ko ɓee too fuu ngaɗi hen koo. ");
INSERT INTO ffm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sabi ɓe fuu, ko bonnantaa ɓe huunde tan ɓe ngaɗi hen, kaa kanko debbo oo, ko o hasindini e mum o waɗi hen, ko o jogii faa o wuurda koo fuu. ");
INSERT INTO ffm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nde o yalti Suudu Dewal Mawndu nduu ndee, taalibbo makko gooto wii mo: —Moobbo, ƴeew! Woy kaaƴe mawɗe mahiraaɗe maadi lobbiri! ");
INSERT INTO ffm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Iisaa jaabii mo, wii: —A yii ndii maadi no foti mawnude? Fay haayre wootere heddataako ɗoo ana fawii dow wonnde, fuu wurjinte. ");
INSERT INTO ffm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","O jooɗoyii dow waamnde haayre wiyeteende Jaytun, o fewti e Suudu Dewal Mawndu nduu. Piyeer e Yaakuuba e Yuhanna e Andire teeldi e makko, lamndii mo, mbii: ");
INSERT INTO ffm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Humpitin min nde ɗum waɗata. Taagumansa homo hollata waɗugol kuɗɗe ɗee fuu? ");
INSERT INTO ffm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nii Iisaa darii ana wiya ɓe: —Ndeentee, pati fay gooto ƴoɲɲa on. ");
INSERT INTO ffm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Heewɓe ngardan innde am, mbiya: «Miin woni kanko.» Ɓe ƴoɲɲan heewɓe. ");
INSERT INTO ffm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","So on nanii dillere golowole ɓadiiɗe, so on kaalanaama golowole goɗɗuɗe, pati kulee, ana tilsi ɗum waɗan, kaa ɗum wanaa timmooɗe tafon. ");
INSERT INTO ffm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Leɲol haɓan e leɲol, laamu haɓan e laamu, leydi dimmboto e nokkuuje yogaaje, hono non yolbereeji duu. Ɗum woni puɗɗooɗe ŋatawere. ");
INSERT INTO ffm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ndeenee ko'e mon, sabi yimɓe naɓan on to carirɗi, on piyete ley cuuɗi baajorɗi, ɓe ndarna on yeeso sarooɓe e kaanankooɓe saabe am, faa laatano-ɗon kam seedee'en yeeso maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ana tilsi Kabaaru Lobbo oo waajee leɲi ɗii fuu tafon. ");
INSERT INTO ffm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nde ɓe naɓii on faa ɓe ndokkitira on, pati mbemmbe-ɗon ko kaalaton. Nde wakkati mum wari fuu, on keɓan ko kaalon. Sabi wanaa onon kaalata, Ruuhu Ceniiɗo haalata. ");
INSERT INTO ffm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Neɗɗo hokkitiran sakiike mum waree, baabiraaɗo duu ɓiyum. Ɓiɓɓe immanto saaraaɓe mum'en, piya dabare yalla ɓeen ana mbaree. ");
INSERT INTO ffm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yimɓe fuu mbaɲan on saabe am. Kaa muɲuɗo faa timmooɗe, joomum hisinte. ");
INSERT INTO ffm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nde njii-ɗon «huunde harmunde bonnde» ana woni ɗo haanaa wonde fuu (jannguɗo ɗum, tiinnoo faama), nden, ɓe ɗum tawi ley Yahuudiya fuu yo ndogu peewa baamle kaaƴe. ");
INSERT INTO ffm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tawaaɗo dow bene, pati jippoo fey so wiya naatan faa ɓama huunde ley suudu muuɗum. ");
INSERT INTO ffm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tawaaɗo gese, pati wirfoo so wiya ɓamoowo saaya mum. ");
INSERT INTO ffm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Bone yanan e haamili'en e muyninooɓe ley ɗeen ɲalaaɗe! ");
INSERT INTO ffm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ɲaagee Laamɗo pati ɗum waɗa wakkati dabbunde. ");
INSERT INTO ffm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sabi ley ɗeen ɲalaaɗe torra waɗan mo hono mum waɗaali gila fuɗɗoode aduna nde Laamɗo tagi tageefu oo warde hannde, mo wattataa kasen duu. ");
INSERT INTO ffm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Sinndo Joomiraaɗo raɓɓinɗinaalino ɗeen ɲalaaɗe, fay gooto hisataano, kaa sabaabu suɓaaɓe ɓee o raɓɓinɗiniri ɗe. ");
INSERT INTO ffm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","E oon wakkati, so won biiɗo on: «Almasiihu annii ɗoo», naa «Ƴeewee! Omo naa too», pati ngoonɗinee. ");
INSERT INTO ffm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sabi almasiihu'en peneeɓe e annabaaɓe peneeɓe ɓanngoyan, ɓe ngaɗa taagumansaaji e kaayeefiiji yalla eɓe majjina suɓaaɓe ɓee, so ɓe mbaawii. ");
INSERT INTO ffm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ɗum nee, so wanaa ndeento-ɗon! Mi haalanii on huunde fuu gila waraali tafon. ");
INSERT INTO ffm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Kaa e ley ɗeen ɲalaaɗe, caggal oon torra, naange niɓɓan, lewru ŋoottan yaaynude, ");
INSERT INTO ffm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","koode kammu caaman, kulle gonɗe dow kammu ɗee ndimmboto. ");
INSERT INTO ffm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","E oon wakkati, Ɓii Neɗɗo oo yiyete ana wara e duule, ana warda baawɗe mawɗe e teddeengal. ");
INSERT INTO ffm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","O nelan malaa'ika'en makko funnaange e hiirnaange, saahal e ɓaleeri, mooɓta suɓaaɓe makko ɓee gila hoore leydi faa hoore leydi. ");
INSERT INTO ffm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Taykitee ibbe: so caɓe majje keyɗitii, haakolooji majje mbillitii, oɗon anndi ndunngu ɓadike. ");
INSERT INTO ffm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hono non, so on njii ɗeen kulle ana ngaɗa, anndee o ɓattiima, omo damal galle. ");
INSERT INTO ffm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Miɗo haalana on goonga: oo jamaanu timmataa tawee kuɗɗe ɗee fuu ngaɗaali. ");
INSERT INTO ffm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kammu e leydi timman, kaa haalaaji am ɗii timmataa abada. ");
INSERT INTO ffm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Kaa nden ɲalaande e oon wakkati fay gooto anndaa ɗum. Wanaa malaa'ika'en wonɓe dow kammu, wanaa Ɓiɗɗo oo. Walaa annduɗo ɗum so wanaa Baabiraaɗo oo. ");
INSERT INTO ffm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ndeentee, njeerto-ɗon, sabi on anndaa wakkati mo o warata. ");
INSERT INTO ffm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Eɗum wa'i no gorko lanndiniiɗo faa dawa, yalti suudu mum, hokki gollooɓe mum homo fuu golle mum, yamiri doomoowo damal oo yo jeerto. ");
INSERT INTO ffm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ndennoo, njeertee, sabi on anndaa nde jom galle oo wartata: ana waawi laataade kiikiiɗe, naa hejjere jemma, naa wakkati nde ndontoori jogginta, naa beetee law. ");
INSERT INTO ffm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Pati o juha on so o tawa oɗon ɗaanii! ");
INSERT INTO ffm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ko kaalanan-mi on koo, ɗum kaalanan-mi yimɓe fuu: njeertee! ");
INSERT INTO ffm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Balɗe ɗiɗi haɗi iidi Paska e iidi mo buuru ƴuufinaaka yottaade. Hooreeɓe yottinooɓe sadaka e dunkee'en Sariya tewti molanaade Iisaa faa nannga ɗum yalla ana mbara ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kaa ɓe mbii: —Pati ngaɗen ɗum ley iidi oo so yimɓe ɓee murta. ");
INSERT INTO ffm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nden Iisaa ana Baytaniya, ɗo galle Simon ceppaaɗo oo ɗoo. O jooɗii faa o ɲaama, debbo gooto naati ana jogii faandu nebam laaɓuɗam, uuroojam, tiiɗuɗam coggu sanne. Debbo oo heli faandu nduu, wuji nebam ɗam e hoore makko. ");
INSERT INTO ffm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yoga e wonnooɓe ton ɓee mettaa, mbiyondiri e ko'e mum'en: —Bonnude ɗam nebam, koɗum nafata? ");
INSERT INTO ffm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Eɗam waawnoo sootteede ko ɓuri buuɗi cardi teemeɗe tati, kaalisi oo hokkee misikiina'en! Hedde eɓe ɲiŋa debbo oo. ");
INSERT INTO ffm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kaa Iisaa wii: —Celee e makko! Ko saabii so oɗon torra mo? Golle makko ŋarɗii sanne. ");
INSERT INTO ffm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Sabi misikiina'en ana tawdee e mon ɲannde fuu, nde muuy-ɗon fuu oɗon mbaawi waɗande ɗum'en moƴƴere. Kaa miin, mi tawdataake e mon ɲannde fuu. ");
INSERT INTO ffm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","O waɗii ko o waawi: ko o wujiri kam nebam uuroojam ɗam yalla miɗo lanndinanoo yanaande. ");
INSERT INTO ffm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Miɗo haalana on goonga: ɗo Kabaaru Lobbo waajaa e aduna oo fuu, ko oo debbo waɗi koo jantete, kasen duu o miccitete. ");
INSERT INTO ffm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yahuuda Isikariyota, gooto e sappo e ɗiɗon ɓee, yehi to hooreeɓe yottinooɓe sadaka faa waɗa Iisaa e juuɗe mum'en. ");
INSERT INTO ffm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nde ɓe nani ɗum ndee, ɓe ceyii, ɓe podani mo ɓe njeenan mo kaalisi. E ley ɗum, omo fiya dabare no o jammbortoo Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ɲalooma arano iidi mo buuru ƴuufinaaka, nde ɓe mboownoo hirsude jawɗi Paska ndee, taalibaaɓe Iisaa lamndii ɗum, mbii: —Hoto njiɗ-ɗaa min njaha min lanndinanoye hiraande iidi Paska ndee? ");
INSERT INTO ffm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","O neli taalibaaɓe makko ɗiɗon, o wii ɗum'en: —Njehee ngeenndi too, on kawran ton e gorko ana roondii mbulku ndiyam, njokkon e mum. ");
INSERT INTO ffm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Galle mo o naati fuu, mbiyon jom galle oo: «Moobbo wii suudu hondu ɲaamdata e taalibaaɓe mum ɓee hiraande iidi Paska?» ");
INSERT INTO ffm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","O hollan on sooro manngo, paraango faa gasi, ton lanndinanto-ɗon en hiraande ndee. ");
INSERT INTO ffm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Taalibaaɓe ɗiɗon ɓee njehi, naatoyi ngeenndi ndii, ɓe tawri hono no o wii ɓe nii, ton ɓe lanndinii hiraande Paska ndee. ");
INSERT INTO ffm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Hiiri, Iisaa wardi e sappo e ɗiɗon ɓee. ");
INSERT INTO ffm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nde ɓe njooɗii eɓe ɲaama ndee, Iisaa wii: —Miɗo haalana on goonga: gooto mooɗon jammboto kam, omo ɲaamda e am jooni. ");
INSERT INTO ffm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ɗum laatanii ɓe sugulla, hedde eɓe lamndoroo mo gooto gooto, gooto fuu ana wiya: —Kori wanaa miin kaa? ");
INSERT INTO ffm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","O jaabii ɓe, o wii: —Gooto e mooɗon, onon sappo e ɗiɗon ɓee, tummbidoowo e am junngo mum e la'al oo. ");
INSERT INTO ffm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Waajibi Ɓii Neɗɗo ɗalira aduna no haaliraa ley Binndi ɗii nii. Kaa bone woodanii jammbotooɗo Ɓii Neɗɗo oo! Oon gorko, so rimanooka fey ɓuri moƴƴande ɗum! ");
INSERT INTO ffm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nde ɓe ɲaamata ndee, Iisaa ɓami buuru, yetti Laamɗo, helti, hokki ɓe, wii: —Nanngee, ɗum yo terɗe am. ");
INSERT INTO ffm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Caggal ɗum, o ɓami horde peguujam, o yetti Laamɗo, o hokki ɓe, ɓe fuu ɓe njari. ");
INSERT INTO ffm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","O wii ɓe: —Ɗum yo ƴiiƴam am, ƴiiƴam tabintinoojam aadi keyri, njupportooɗam saabe heewɓe. ");
INSERT INTO ffm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Miɗo haalana on goonga: abada mi yarataa peguujam kasen so wanaa ɲannde njaroy-mi peguujam kesam e ley Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Caggal ɓe njimii Jabuura, ɓe njalti, ɓe njehi waamnde haayre wiyeteende Jaytun. ");
INSERT INTO ffm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Iisaa wii ɓe: —On fuu on njoppan kam, sabi ana winndii: «Mi fiyan duroowo oo, mi wara ɗum, baali ɗii caakoo.» ");
INSERT INTO ffm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kaa caggal mi wuurtii, mi adoyto on Galili. ");
INSERT INTO ffm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piyeer wii mo: —Fay so ɓe fuu ɓe njoppu maa, miin kaa mi yoppataa ma. ");
INSERT INTO ffm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Iisaa wii mo: —Miɗo haalane goonga: jemma hannde oo jaati, fade ndontoori jogginde cili ɗiɗi a wiyan a anndaa kam cili tati. ");
INSERT INTO ffm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Piyeer haali, tekkini, wii: —Fay so tilsi mi maaydan e maa, abada mi wiyataa mi anndaa ma. Taalibaaɓe ɓee fuu mbii hono non. ");
INSERT INTO ffm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ɓe njottii nokku biyeteeɗo Gecemane, o wii taalibaaɓe makko ɓee: —Njooɗee ɗoo, faa mi waɗoya duwaawu. ");
INSERT INTO ffm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","O yaadi e Piyeer e Yaakuuba e Yuhanna. O fuɗɗi maatude kulol, o ruubi. ");
INSERT INTO ffm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","O wii ɓe: —Yoomeende ana mawni e am sanne faa ana ndaara warde kam. Keddee ɗoo, njeertee pati ɗaanee. ");
INSERT INTO ffm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","O woɗɗitii seeɗa, o hippii e leydi, o duwii yalla omo daɗa e oo wakkati naawɗo so ana huɓindoo. ");
INSERT INTO ffm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","O wii: —Abba! Aɗa waawi huunde fuu, woɗɗinam ndee horde bone. Kaa pati laatoro no njiɗir-mi, yo laatoro no njiɗir-ɗaa aan. ");
INSERT INTO ffm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","O warti, o tawi eɓe ɗaanii. O wii Piyeer: —Simon, a ɗaaniiɗo naa? A waawaa jeertaade tawee a ɗaanaaki fay wakkati gooto naa? ");
INSERT INTO ffm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Pati ɗaanee, nduwee, pati on ceyte. Sabi hakkille ana heewi anniya lobbo, kaa terɗe ana lo'i. ");
INSERT INTO ffm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","O yehi kasen, o duworii no arannde nii. ");
INSERT INTO ffm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","O warti, o tawi ɓe ɗaantike, sabi ɗoyɗi ana piilii e maɓɓe. Ɓe ndonki anndude ko ɓe njaabotoo mo. ");
INSERT INTO ffm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","O warti cilol tataɓol, o wii ɓe: —Faa jooni oɗon ɗaanii oɗon ŋoottinoo naa? Heƴii. Wakkati oo warii. Ɓii Neɗɗo waɗete e juuɗe luuttooɓe. ");
INSERT INTO ffm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Immee njehen! Ƴeewee, jammbotooɗo kam oo annii. ");
INSERT INTO ffm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","O tilaaki haalde, faa Yahuuda, gooto e sappo e ɗiɗon ɓee, yottii ana wondi e yimɓe heewɓe jogiiɓe kaafaaje e cabbi. Hooreeɓe yottinooɓe sadaka, dunkee'en Sariya e mawɓe, kaɲum'en neli ɓe. ");
INSERT INTO ffm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jammbotooɗo mo oo hokki ɓe finnde, wii: —Neɗɗo mo ɓuccii-mi fuu, oo woni kanko. Nanngee ɗum, naɓon ɗum kawjo-ɗon ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yahuuda yottii tan, ɓattitii Iisaa, wii ɗum: —Moobbo! O ɓuccii ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nii ɓe njani e Iisaa, ɓe nanngi ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Gooto e darinooɓe ɗon ɓee, soorti kaafaawi mum, soppi golloowo Jottinoowo Sadaka Mawɗo, taƴi nowru mum. ");
INSERT INTO ffm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Iisaa wii ɓe: —Ko ngardu-ɗon e kaafaaje e cabbi faa nanngon kam hono mi janoowo? ");
INSERT INTO ffm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Miɗo wondi e mon ɲannde fuu ley Suudu Dewal Mawndu nduu miɗo waajoo, on nanngaali kam. Kaa ɗum waɗan yalla ko Binndi ɗii mbii koo ana tabita. ");
INSERT INTO ffm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","E ley ɗum, taalibaaɓe ɓee fuu njoppi mo, ndogi. ");
INSERT INTO ffm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jokolle mo ɓoornaaki ko wanaa waandaade disaare, jokki e makko, ɓe nanngi ɗum ");
INSERT INTO ffm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","o yoppi disaare ndee, o dogiri ɓe terɗe teete. ");
INSERT INTO ffm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ɓe naɓi Iisaa to Jottinoowo Sadaka Mawɗo oo, tawi hooreeɓe yottinooɓe sadaka e mawɓe e dunkee'en Sariya fuu ana mooɓtii. ");
INSERT INTO ffm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piyeer jokkitii mo fali daawre hakkunde maɓɓe, faa naati ley daalaare galle Jottinoowo Sadaka Mawɗo. O jooddii e doomooɓe, omo ƴuwloo yiite. ");
INSERT INTO ffm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Hooreeɓe yottinooɓe sadaka e jeyaaɓe e waalde Saahiiɓe ndee fuu ana tewta ko kappira Iisaa yalla ana waree, kaa ɓe keɓaali. ");
INSERT INTO ffm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Heewɓe ana kappa mo, kaa kamɓe e hoore maɓɓe, kappi maɓɓe ɗii ana luuttondiri. ");
INSERT INTO ffm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yogaaɓe kappi mo, mbii: ");
INSERT INTO ffm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Min nanii omo wiya: «Mi wurjinan Suudu Dewal Mawndu ndu yimɓe mahiri juuɗe, e ley balɗe tati mi maha suudu dewal wonndu ndu mahiraaka juuɗe.» ");
INSERT INTO ffm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kaa e ɗum duu, happugol maɓɓe ngol ana luuttondiri. ");
INSERT INTO ffm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jottinoowo Sadaka Mawɗo oo darii hakkunde jamaa oo, lamndii Iisaa: —Walaa ko njaaboto-ɗaa naa? Tama a nanaali ko ɓe mbiyete koo? ");
INSERT INTO ffm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Fuu omo deƴƴinii, o jaabaaki fay huunde. Jottinoowo Sadaka Mawɗo oo ana lamndoo mo kasen, ana wiya: —Aan a Almasiihu, ɓii mo jettooje ngoodani oo naa? ");
INSERT INTO ffm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","O jaabii, o wii: —Miin woni kanko. On njiyan Ɓii Neɗɗo ana jooɗii ɲaamo Jom Baawɗe oo, ana warda e duule kammu. ");
INSERT INTO ffm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","E ley ɗum, Jottinoowo Sadaka Mawɗo oo mettaa faa seeki kaddule mum, wii: —En kaajaaka seedee'en hankasen. ");
INSERT INTO ffm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","On narrii noppi mooɗon ko o bonkii Laamɗo koo. Koɗum njii-ɗon hen? Ɓe fuu ɓe mbii omo haani wareede. ");
INSERT INTO ffm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yoga maɓɓe fuɗɗi tuttude e makko, ɓe cuddi yeeso makko, eɓe culkoo mo, eɓe mbiya mo: —Annditin culkiiɗo ma! Nii doomooɓe ɓee nanngi mo, ana piya mo banaaje. ");
INSERT INTO ffm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","E ley no Piyeer worri e ley daalaare galle oo nii, gooto e horɓe Jottinoowo Sadaka Mawɗo yottii. ");
INSERT INTO ffm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nde o yiinoo Piyeer ana ƴuwloo ndee, o taykitii ɗum, o wii: —Aan, aɗa wondunoo e Iisaa Nasaraatunke oo. ");
INSERT INTO ffm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nii Piyeer yeddi mo, wii: —Wanaa miin! Mi faamataa ko kaalataa koo. Caggal ɗum, Piyeer yehi naatoyi bolongal galle oo. Tan ndontoori joggini. ");
INSERT INTO ffm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nde korɗo oo yiinoo mo kasen ndee, haaltani darinooɓe ɗon ɓee, wii: —Oo yo gooto maɓɓe! ");
INSERT INTO ffm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piyeer yeddi kasen. Ɗon e ɗon darinooɓe ɗon ɓee mbii Piyeer: —Taƴoral, a gooto e maɓɓe, sabi a Galilinke. ");
INSERT INTO ffm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nii o fuɗɗi hunaade e huttaade, omo wiya: —Mi anndaa gorko mo kaalaton haala mum oo fey! ");
INSERT INTO ffm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ndontoori joggini ɗiɗaɓerde, Piyeer miccitii ko Iisaa wiinoo ɗum koo: «Fade ndontoori jogginde cili ɗiɗi, a wiyan a anndaa kam cili tati.» O darii omo woya. ");
INSERT INTO ffm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Beetee law, hooreeɓe yottinooɓe sadaka e mawɓe e dunkee'en Sariya e waalde Saahiiɓe ndee, ɓe fuu ɓe ndawridi. Ɓe kaɓɓi Iisaa, ɓe naɓi ɗum to Pilaatu goforneer oo. ");
INSERT INTO ffm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilaatu lamndii mo, wii: —Aan woni kaananke Yahuudiyankooɓe oo naa? O jaabii, o wii: —No mbii-ɗaa nii. ");
INSERT INTO ffm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Hooreeɓe yottinooɓe sadaka ɓee ana ngullanoroo mo kulle keewɗe. ");
INSERT INTO ffm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilaatu lamndii mo kasen: —Walaa ko njaaboto-ɗaa naa? A nanaali ko ɓe ngullani maa koo fuu naa? ");
INSERT INTO ffm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kaa Iisaa jaabaaki fay huunde, faa ɗum haaynii Pilaatu. ");
INSERT INTO ffm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Iidi Paska fuu, goforneer oo ana hokkannoo yimɓe ɓee suɓaade e kasunkooɓe ɓee mo njiɗi yoppitaneede. ");
INSERT INTO ffm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Gorko biyeteeɗo Barabas murtidiino e woɓɓe faa ɓe mbari neɗɗo. Oon wakkati, eɓe uddanoo kasu saabe ko ɓe ngaɗi koo. ");
INSERT INTO ffm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jamaa oo ŋabboyi to Pilaatu woni too, naati e ɲaagaade ɗum waɗana ɓe ko woownoo waɗande ɓe koo. ");
INSERT INTO ffm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","O jaabii ɓe, o wii: —Oɗon njiɗi mi yoppitana on kaananke Yahuudiyankooɓe oo naa? ");
INSERT INTO ffm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sabi o anndii hooreeɓe yottinooɓe sadaka ɓee haasidaaku waɗi so ndokkitiri mo. ");
INSERT INTO ffm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kaa ɓe ndunƴi jamaa oo e ɲaagaade Pilaatu yoppitana ɓe Barabas ɓurani ɓe yoppita Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilaatu jaabii kasen, wii ɓe: —Ndennoo, koɗum njiɗ-ɗon mi waɗa mo mbiyaton kaananke Yahuudiyankooɓe oo? ");
INSERT INTO ffm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɓe ngulli: —Tontu mo e leggal bardugal! ");
INSERT INTO ffm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilaatu lamndii ɓe: —Koɗum o waɗi ko boni? Ɓe ɓeydi dukude semmbe: —Tontu mo e leggal bardugal! ");
INSERT INTO ffm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Nde wonnoo Pilaatu ana yiɗi welnude ɓerɗe jamaa oo, yoppitani ɗum'en Barabas. Caggal ɗum, o yamiri Iisaa fiyee dorri, tontoyee e leggal bardugal. ");
INSERT INTO ffm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sordaasi'en ɓee naɓi mo naannoyi mo ley galle to huɓeere ndee woni too, mooɓti fedde sordaasi'en ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ɓe ɓoorni mo burmusuure woɗeere, ɓe caɲi tenngaade gi'e ɓe kippi e hoore makko. ");
INSERT INTO ffm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ɓe keddii eɓe calmina mo, eɓe mbiya: —Saɗi, kaananke Yahuudiyankooɓe. ");
INSERT INTO ffm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eɓe piira hoore makko kalacal, eɓe tutta e makko, ɓe tuggi koppi maɓɓe eɓe cujidana mo. ");
INSERT INTO ffm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nde ɓe tilii jaayrude mo ndee, ɓe itti burmusuure woɗeere ndee, ɓe ɓoorni mo kaddule makko, ɓe naɓi mo sella faa ɓe tontoya mo e leggal bardugal. ");
INSERT INTO ffm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Gorko gooto biyeteeɗo Simon, jeyaaɗo Sireene, baaba Aleksandere e Rufus, ana ɓettoroo ɗon iwruɗo ley ladde. Sordaasi'en ɓee ndoolɗini mo o wakkoo leggal bardugal Iisaa ngal. ");
INSERT INTO ffm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ɓe naɓi Iisaa nokku biyeteeɗo Golgata. (Maanaa Golgata woni nokku laalagal hoore.) ");
INSERT INTO ffm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ɓe ngaddani mo peguujam njillondiraaɗam e safaare haaɗunde yalla omo yara, kaa o jaɓaali. ");
INSERT INTO ffm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ɓe tonti mo e leggal bardugal, ɓe pecciri kaddule makko urwa, ɓe anndi ko gooto fuu heɓata. ");
INSERT INTO ffm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nde ɓe tontata mo ndee, wakkati yamnde jeenay beetee. ");
INSERT INTO ffm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ɓe mbinndi e alluwal tiimde hoore makko daliili ko tonti mo: KAANANKE YAHUUDIYANKOOƁE. ");
INSERT INTO ffm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ɓe tontidi mo e yanooɓe ɗiɗon, gooto ɲaamo makko, goɗɗo oo nano makko.  ");
INSERT INTO ffm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Yimɓe ƴaɓɓotooɓe ɗon ɓee ana njenna mo, ana njinka ko'e mum'en, ana mbiya: —Coo! Gurjinoowo Suudu Dewal Mawndu nduu so mahitoo ndu ley balɗe tati, ");
INSERT INTO ffm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","biltu hoore maa, jippa leggal bardugal ngal! ");
INSERT INTO ffm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hono non, hooreeɓe yottinooɓe sadaka ɓee duu njaayriri mo, kaɲum e dunkee'en Sariya ana mbiyondira e ko'e mum'en: —O biltii woɓɓe, kaa o ronkii biltude hoore makko! ");
INSERT INTO ffm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kanko Almasiihu kaananke Israa'iila oo. Jooni, o jippoo leggal bardugal ngal, yalla eɗen njiya ngoonɗinen! Yanooɓe ɗiɗon ɓe o tontidaa ɓee duu ana mbonkoroo mo non. ");
INSERT INTO ffm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wakkati hakkunde naange, nimre waɗi e leydi ndii fuu faa wakkati yamnde tati kiikiiɗe. ");
INSERT INTO ffm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","E ley yamnde tati kiikiiɗe ndee, Iisaa wulli wullaango toowngo, wii: —Eloyi, eloyi, lama sabaktanii? (Ɗum woni: «Laamɗo am, Laamɗo am! Koɗum waɗi so njoppu-ɗaa kam?») ");
INSERT INTO ffm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yoga e darinooɓe ton ɓee nde nanunoo ɗum ndee, mbii: —Kettinee, omo nii nodda annabi Iliyaasa! ");
INSERT INTO ffm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nii gooto dogi, suuwoyi liccere ley biineegiri, haɓɓi ɗum e sawru, feewtini hunduko makko yalla omo ɓuuccoo, wii: —Njoppen mo ƴeewen yalla Iliyaasa waran jippina mo! ");
INSERT INTO ffm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Iisaa wulli wullaango toowngo kasen, ɗali aduna. ");
INSERT INTO ffm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Heedoode faliinde ley Suudu Dewal Mawndu ndee seekii gila dow faa ley, laatii taƴe ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hooreejo sordaasi'en darinooɗo yeeso makko oo yii no o ɗaliri aduna nii, wii: —So goonga nii, oo neɗɗo yo Ɓii Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Rewɓe yogaaɓe ana toowti, ana coynoo. Ana e maɓɓe: Mariyama mo Magdala e Salome e Mariyama inna Yaakuuba suka e Yoses. ");
INSERT INTO ffm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɓeen njokkannoo e makko ana ngollana mo nde o wonnoo Galili ndee. E rewɓe woɓɓe kasen, ŋabbidinnooɓe e makko Urusaliima ana ngonnoo ɗon. ");
INSERT INTO ffm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Hiiri, ɗum hawri e wakkati lanndinal tawi ɲalaande fowteteende ɓadike fuɗɗude. ");
INSERT INTO ffm_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Gooto e waalde Saahiiɓe, tedduɗo, biyeteeɗo Yuusufu mo Arimatiya, wari. Kanko duu omo doomunoo ɓanngugol Laamu Laamɗo oo. O hulaali yaade to Pilaatu o ndaarda ɗum tew Iisaa. ");
INSERT INTO ffm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilaatu haaynaa nde nanunoo o maayirii nii tan ndee, noddi hooreejo sordaasi'en, lamndii ɗum so tawii yo goonga o maayii. ");
INSERT INTO ffm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nde hooreejo sordaasi'en haalani mo ɗum ndee, o duŋanii Yuusufu ɓamta tew oo. ");
INSERT INTO ffm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yuusufu soodi kasanke, jippini tew Iisaa oo, fiili ɗum e kasanke oo, o watti ɗum e yanaande asaande ley haayre. Caggal ɗum, o talliti haayre, o uddiri damal yanaande ndee. ");
INSERT INTO ffm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariyama mo Magdala e Mariyama inna Yoses njii to o waɗaa too. ");
INSERT INTO ffm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nde ɲalaande fowteteende ndee ɓettinoo ndee, Mariyama mo Magdala e Salome e Mariyama inna Yaakuuba, coodi nebameeji uurooji ngaddi faa nguja e tew makko oo. ");
INSERT INTO ffm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ɲannde alan, ɓe ngari e yanaande ndee beetee kecco wakkati puɗal naange. ");
INSERT INTO ffm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ɓe ndarii eɓe mbiyondira: —Homo tallitanta en haayre ndee iwa e damal yanaande ndee? ");
INSERT INTO ffm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kaa nde ɓe kunci gite ndee, ɓe njii haayre ndee tallitaama. Ende mawni sanne. ");
INSERT INTO ffm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Wakkati ɓe naatunoo e yanaande ndee, ɓe njii jokolle ana jooɗii bannge ɲaamo ana ɓoornii saaya ndaneewa, ɓe kuli. ");
INSERT INTO ffm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","O wii ɓe: —Pati kulee! Iisaa Nasaraatunke tontanooɗo oo tewtaton. O immitike, o walaa ɗoo. Nokku ɗo o waɗanoo ɗoo, annii. ");
INSERT INTO ffm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jooni kaa, njehee, mbiyoyee taalibaaɓe makko ɓee e Piyeer o adoyto on Galili. Ton njiyoyton mo, hono no o wiirunoo on nii. ");
INSERT INTO ffm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Rewɓe ɓee njalti yanaande ndee, ɓe ndogi eɓe ciɲɲa kulol cattungol. Ɓe kaalanaali fay gooto huunde no ɓe poti hulde. ———————————————— ");
INSERT INTO ffm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Caggal Iisaa wuurtii beetee law ɲannde alan, Mariyama mo Magdala mo o ribbani seyɗaani'en njeɗɗon oo, kaɲum mo adii ɓanngande. ");
INSERT INTO ffm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","O yehi humpitoyde ɗum wondunooɓe e Iisaa ɓee, tawi eɓe cunaa eɓe mboya. ");
INSERT INTO ffm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ko ɓe nanunoo o wuurtii koo e ko Mariyama yii mo koo, fuu ɓe ngoonɗinaali ɗum. ");
INSERT INTO ffm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Caggal ɗum, o ɓanngirani ɗiɗon maɓɓe mbaadi ngonndi, eɓe nanngi laawol jahoowol ladde. ");
INSERT INTO ffm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɓe ngarti ɓe kumpitoyi heddiiɓe ɓee, ɓe ngoonɗinaali ɗum'en kaɲum'en duu. ");
INSERT INTO ffm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ko sakitii koo o ɓanngani taalibaaɓe sappo e go'o ɓee tawaaɓe ana ɲaama. O ɲiŋiri ɓe waasude maɓɓe goonɗinde e yoorde maɓɓe ɓernde, sabi ɓe ngoonɗinaali yiiɓe mo caggal immitagol makko ɓee. ");
INSERT INTO ffm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","O wii ɓe: —Njehee ley aduna oo fuu, mbaajo-ɗon tagoore ndee fuu Kabaaru Lobbo oo. ");
INSERT INTO ffm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Goonɗinɗo so lootaa lootogal batisima, hisinte. Mo goonɗinaali jukkete. ");
INSERT INTO ffm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ɗii kaayeefiiji ana ngoodani goonɗinɓe ɓee: ɓe ndibbiran seyɗaani'en saabe am, ɓe kaalan ɗemle kese, ");
INSERT INTO ffm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ɓe nanngiran ɓoggi leydi juuɗe maɓɓe. Fay so ɓe njarii poson, fay huunde waɗataa ɓe. Ɓe pawan junngo maɓɓe e ɲawɓe, cella. ");
INSERT INTO ffm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Caggal Iisaa Joomiraaɗo oo haaldii e maɓɓe, ŋabbinaa kammu, jooɗii ɲaamo Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kaa kamɓe, ɓe njehi eɓe mbaajoyoo ley nokkuuje fuu. Joomiraaɗo ana wondi e maɓɓe, tabintiniri konngol ngol taagumansaaji jaadooji e maggol.");
INSERT INTO ffm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yimɓe heewɓe kornii jantaade kulle gaɗuɗe hakkunde men, ");
INSERT INTO ffm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","hono no seediiɓe gila puɗɗooɗe, laatiiɓe kaadime'en konngol ngol ɓee, kaalaniri en nii. ");
INSERT INTO ffm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Tawfilus tedduɗo, mi wiɗike kulle ɗee fuu gila arannde, mi tawii ana haani mi winndane ɗum no waɗiri nii, ");
INSERT INTO ffm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","yalla aɗa heɓa taƴoral jannde nde njanngine-ɗaa ndee yo goonga. ");
INSERT INTO ffm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","E ley jamaanu Hirudus, kaananke Yahuudiya, jottinoowo sadaka biyeteeɗo Jakariyaa ana woodunoo. Omo jeyaa e waalde Abiya, ɓii Haaruuna oo. Jom suudu Jakariyaa duu yo iwdi Haaruuna, innde mum yo Elisabet. ");
INSERT INTO ffm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɓe ɗiɗon fuu ɓe fooccitiiɓe yeeso Laamɗo, eɓe njokki jamirooje Joomiraaɗo e sariyaaji mum fuu, ɲiŋoore fuu walaa e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kaa ɓe keɓaalino ɓiɗɗo, sabi Elisabet laatinoke dimaro, kasen duu ɓe ɗiɗon fuu ɓe naywii. ");
INSERT INTO ffm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ɲannde wootere, Jakariyaa ana golla golle mum yottingol sadaka yeeso Laamɗo, sabi ɲannde mum yo waalde makko jeyti. ");
INSERT INTO ffm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nde wonnoo yottinooɓe sadaka ana mboownoo waɗude urwa, nii urwa nanngi mo faa o naata Suudu Dewal Mawndu nduu, o ura ton uurdi. ");
INSERT INTO ffm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jamaa oo fuu darii sella ana duwoo wakkati mo uurdi ndii uretee oo. ");
INSERT INTO ffm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Oon wakkati, malaa'ika Joomiraaɗo ɓanngani mo, darii ɲaamo urirde ndee. ");
INSERT INTO ffm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nde Jakariyaa yiinoo malaa'ika oo ndee, taƴi, darii ana siɲɲa. ");
INSERT INTO ffm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Malaa'ika oo wii mo: —Jakariyaa pati hul, sabi duwaawu maa jaabaama. Jom suudu maa Elisabet rimante ɓiɗɗo gorko, inndiraa ɗum Yaayaa. ");
INSERT INTO ffm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Oon ɓiɗɗo waddante seyo manngo, heewɓe ceyorto pinaaɗe makko, ");
INSERT INTO ffm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","sabi o laatoto tedduɗo e Joomiraaɗo. O yarataa doro, o yarataa huunde fuu ko sigirta. O heewan Ruuhu Ceniiɗo gila e ley reedu inniiko, ");
INSERT INTO ffm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","o wartiran ɓiɓɓe Israa'iilankooɓe heewɓe e Laamɗo Joomiraaɗo mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","O ardoto Joomiraaɗo oo warde, o wonda e ruuhu e baawɗe ɗe annabi Iliyaasa heɓunoo, faa o wartira ɓerɗe baabiraaɓe faade e ɓiɓɓe mum'en, faa o wartira murtuɓe duu e hakkille fooccitiiɓe, kaɲum e moƴƴinande Joomiraaɗo oo leɲol lanndiniingol. ");
INSERT INTO ffm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jakariyaa lamndii malaa'ika oo, wii: —Hono hen anndiran-mi ɗum goonga? Sabi miin mi naywii, jom suudu am oo duu waɗii duuɓi. ");
INSERT INTO ffm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Malaa'ika oo jaabii mo, wii: —Miin woni Jibiriilu darotooɗo yeeso Laamɗo, mi nelaaɗo e maa faa mi haalane oo kabaaru lobbo. ");
INSERT INTO ffm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ndennoo jooni a muumɗan. A haalataa so wanaa wakkati mo ɗum tabiti, sabi a goonɗinaali haala am. Haala am kaa tabitoyan so wakkati majjum warii. ");
INSERT INTO ffm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","E ley ɗum fuu tawi yimɓe ɓee ana ndoomi Jakariyaa, ana kaaynaa ko ɓooyni ɗum ley Suudu Dewal Mawndu too. ");
INSERT INTO ffm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nde o yalti ndee, o ronki haaldude e maɓɓe. Ɓe paami won ko jergii e makko e ley Suudu Dewal Mawndu nduu. O darii omo haalda e maɓɓe muumankoore, o heddii e muumaaku. ");
INSERT INTO ffm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nde o tilinoo e golle makko ndee, o hooti suudu makko. ");
INSERT INTO ffm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Caggal ɗeen balɗe, Elisabet jom suudu makko oo reedi, dammbii hakke lebbi joy, ana wiya: ");
INSERT INTO ffm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Ɗum woni ko Joomiraaɗo waɗani kam nde wattani kam hakkille, ittani kam dukkuru hakkunde yimɓe. ");
INSERT INTO ffm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","E ley lewru Elisabet jeegoɓurdu nduu, Laamɗo neli malaa'ika Jibiriilu e ngeenndi mbiyeteendi Nasaraatu ley leydi Galili, ");
INSERT INTO ffm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","faade e surba mo taanii Daawuuda biyeteeɗo Yuusufu sabbi. Surba oo ana wiyee Mariyama. ");
INSERT INTO ffm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Malaa'ika oo naati ɗo Mariyama woni ɗoo, wii ɗum: —Aan e jam, keɓuɗo moƴƴere Laamɗo. Joomiraaɗo ana wondi e maa. ");
INSERT INTO ffm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Haala kaa jiiɓi hakkille Mariyama, darii ana miila ko ngoo jowtaango waawi laataade. ");
INSERT INTO ffm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nii malaa'ika oo wii mo: —Mariyama pati hul! Sabi a heɓii moƴƴere iwnde e Laamɗo, ");
INSERT INTO ffm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","a reedan, ndimaa ɓiɗɗo gorko, inndiraa ɗum Iisaa. ");
INSERT INTO ffm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Oon ɓiɗɗo laatoto tedduɗo, o noddirte Ɓii Laamɗo Toowɗo. Laamɗo Joomiraaɗo hokkan mo laamu maamiiko Daawuuda. ");
INSERT INTO ffm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","O laamoto iwdi Yaakuuba, laamu makko timmataa abada. ");
INSERT INTO ffm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariyama wii malaa'ika oo: —Hono ɗum laatortoo, mi anndaa gorko? ");
INSERT INTO ffm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Malaa'ika oo jaabii mo, wii: —Ruuhu Ceniiɗo jippoto e maa, baawɗe Laamɗo Toowɗo oo kuurete no ɗowdi nii. Saabe ɗum, ɓiɗɗo mo ndimataa oo noddirte Ceniiɗo, noddirte Ɓii Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Haya ƴeew, sakiike maa Elisabet duu ɓamii reedu, taweede mo naywii fuu, mo riman ɓiɗɗo gorko. Ana wiyetenoo mo dimaro, kaa jooni omo woni e lewru makko jeegoɓurdu, ");
INSERT INTO ffm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","sabi walaa fuu ko Laamɗo waawaa. ");
INSERT INTO ffm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","E oon wakkati, Mariyama wii: —Miin, mi korɗo Joomiraaɗo. Yo laatanoram no mbiiru-ɗaa nii. Caggal ɗum, malaa'ika oo witti, seli e makko. ");
INSERT INTO ffm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","E ley ɗeen ɲalaaɗe, Mariyama immii law yehi ngeenndi Yahuudiya ngootiri ngonndi dow baamle kaaƴe. ");
INSERT INTO ffm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","O naati galle Jakariyaa, o jowti Elisabet. ");
INSERT INTO ffm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nde Elisabet nannoo jowtaango makko ndee, ɓiɗɗo gonɗo e reedu mum oo dillinii, Elisabet hebbinaa Ruuhu Ceniiɗo, ");
INSERT INTO ffm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ilinii, wii: —A barkinaaɗo hakkunde rewɓe, ɓiɗɗo mo caaw-ɗaa oo duu yo barkinaaɗo. ");
INSERT INTO ffm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Miin, ko ngon-mi faa inna Joomam naata galle am? ");
INSERT INTO ffm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nde jowtaango maa toɓɓinoo e nowru am ndee, ɓiɗɗo gonɗo e reedu am oo dillinike saabe kuyam. ");
INSERT INTO ffm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","A welii hoore, aan goonɗinɗo ko Joomiraaɗo fodan maa koo laatoto. ");
INSERT INTO ffm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariyama wii: —Yonki am ana yetta Joomiraaɗo, ");
INSERT INTO ffm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ɓernde am ana heewi seyo Laamɗo Kisinoowo kam, ");
INSERT INTO ffm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","sabi o yurmike kam, miin, korɗo makko lo'uɗo oo. Gila jooni jamaanuuji fuu noddiran kam belɗo hoore. ");
INSERT INTO ffm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Sabi Jom Baawɗe oo waɗanii kam kulle mawɗe! Innde makko yo seniinde. ");
INSERT INTO ffm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yurmeende makko herataa e hulɓe mo abada. ");
INSERT INTO ffm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","O gollirii golleeji mawɗi junngo makko semmbinngo, o saakii mawninkiniiɓe. ");
INSERT INTO ffm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","O ɓoortii kaanankooɓe iwde e laamu mum'en, o toownii leyɗuɓe. ");
INSERT INTO ffm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","O haarnirii yolbuɓe kulle lobbe, o wirfintinii taajiri'en juuɗe ɓole. ");
INSERT INTO ffm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","O faabike Israa'iilankooɓe, jiyaaɓe makko, o yeggitaali yurmaade Ibarahiima e iwdi mum faa abada, hono no o fodanirnoo njaatiraaɓe men nii. ");
INSERT INTO ffm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariyama faɓɓidi e Elisabet ko waarata e lebbi tati, caggal mum, hooti suudu mum. ");
INSERT INTO ffm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wakkati ɓeynugol Elisabet yottii, o ɓeyni o heɓi ɓiɗɗo gorko. ");
INSERT INTO ffm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Taakallemme'en makko e sakiraaɓe makko nani hinnee mawɗo mo Joomiraaɗo waɗani mo oo, ceyodii e makko. ");
INSERT INTO ffm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nde cukalel ngel hiɓɓinnoo yontere ndee, ɓe ngari taadude ngel. Ɓe njiɗiino inndirde ngel baaba maggel Jakariyaa, ");
INSERT INTO ffm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kaa inna maggel jaɓaali, wii ngel inndiree Yaayaa. ");
INSERT INTO ffm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɓe mbii ɗum: —Sii maa fuu walaa inndiraaɗo ndee innde. ");
INSERT INTO ffm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɓe lamndorii baaba maggel muumankoore, homo yiɗi ɓiyum oo inndiree. ");
INSERT INTO ffm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jakariyaa lamndii alluwal, winndi e maggal: «Innde maggel yo Yaayaa.» Ɓe fuu ɓe kaaynaa. ");
INSERT INTO ffm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Oon wakkati fuu, hunduko Jakariyaa yoppitaa, ɗemngal mum humtaa, watti haalde e yettude Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kulol nanngi hoɗuɓe e seraaji ɗii ɓee fuu. Kasen duu ɗum saakii e ley haayre Yahuudiya fuu. ");
INSERT INTO ffm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nanɓe ɗum ɓee fuu ndesi ɗum e hakkillaaji mum'en, ana mbiya: «Koɗum ngel cukalel foti laataade?» Sabi ɓe njii baawɗe Joomiraaɗo ana e maggel. ");
INSERT INTO ffm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jakariyaa, baaba cukalel ngel, heewi Ruuhu Ceniiɗo, sappii, wii: ");
INSERT INTO ffm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Jettooje ngoodanii Joomiraaɗo, Laamɗo Israa'iila, sabi faabike yimɓe mum, soottitike ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","O waddanii en kisinoowo tedduɗo iwɗo e suudu Daawuuda, kaadime makko oo ");
INSERT INTO ffm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","hono no o haalirnoo e kunduɗe annabaaɓe makko seniiɓe gila arannde nii. ");
INSERT INTO ffm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","O fodii o danndan en e konnee'en men, o ittan en e juuɗe wayɓe men. ");
INSERT INTO ffm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","O ɓannginanan en yurmeende nde o ɓannginani maamiraaɓe men ndee, sabi o miccitike aadi makko ceniindi ndii, ");
INSERT INTO ffm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ɗum yo hunoore nde o hunanii maama men Ibarahiima. Hunoore ndee woni o hokkan en ");
INSERT INTO ffm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","rewirde mo rafi kulol ley nguurndam men fuu e ley senaare e fooccitaare yeeso makko, tawi en ittaaɓe e juuɗe konnee'en men. ");
INSERT INTO ffm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Aan duu ɓinngel am, a noddirte annabaajo Laamɗo Toowɗo, sabi a ardoto Joomiraaɗo oo warde faa moƴƴinanaa mo laawol, ");
INSERT INTO ffm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","faa anndinaa yimɓe makko o hisiniran ɗum'en yaafaamuya luutti. ");
INSERT INTO ffm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sabi Laamɗo men yo keewɗo yurmeende, faa o faaboroo en nannduɗo e fooyre iwrunde dow, ");
INSERT INTO ffm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","yalla ana fooynana wonɓe e nimre, fooynana wonɓe e kulol maayde, watta koyɗe men e laawol jam. ");
INSERT INTO ffm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Suka oo ana mawna, hakkille mum ana ɓeydoo. O jooɗii ley ladde jeereende faa wakkati mo o ɓannginanaa Israa'iila. ");
INSERT INTO ffm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","E ley ɗeen balɗe, Ogusta kaananke mawɗo oo, yamiri limgal waɗee e ley laamu Roma fuu. ");
INSERT INTO ffm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kanngal woni limgal aranal, forri e laamu Kiriniyas ley leydi Siriya. ");
INSERT INTO ffm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Yimɓe fuu njehi winndoyaade, gooto fuu e ngeenndi mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yuusufu duu immii Nasaraatu ley leydi Galili, faa yaha ngeenndi Daawuuda mbiyeteendi Baytilaama ley leydi Yahuudiya, sabi e leɲol Daawuuda jaati mo iwata. ");
INSERT INTO ffm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","O yehi ton winndoyaade, kanko e Mariyama cabbaaɗo makko, cowiiɗo. ");
INSERT INTO ffm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","E ley gonal maɓɓe ton, wakkati ɓeynugol Mariyama yottii, ");
INSERT INTO ffm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","o dikkii hammadi makko, o saawi ɗum e licce, o lelni ɗum ley akalaawal, sabi ɓe keƴaali e jippunde ndee. ");
INSERT INTO ffm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Durooɓe ana mbaalannoo haybude sewre mum'en baali e seraaji ɗii. ");
INSERT INTO ffm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Malaa'ika Joomiraaɗo ɓanngani ɓe, teddeengal Joomiraaɗo filii ɓe hono no fooyre nii. Kulol manngol nanngi ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nii malaa'ika oo wii ɓe: —Pati kulee! Sabi mi garɗo haalande on Kabaaru Lobbo gaddanoowo leɲol ngol fuu seyo manngo. ");
INSERT INTO ffm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Hannde on ndimanaama kisinoowo ley ngeenndi Daawuuda ndii, kanko woni Almasiihu, kanko woni Joomiraaɗo oo. ");
INSERT INTO ffm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Finnde majjum annii: on tawan cukalel keccel ana saawaa e licce, ana lelnaa ley akalaawal. ");
INSERT INTO ffm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ɗon e ɗon, higgere malaa'ika'en iwi dow kammu, tawti malaa'ika arano oo, naati e yettude Laamɗo, ana mbiya: ");
INSERT INTO ffm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Teddeengal woodanii Laamɗo Toowɗo! Jam woodanii yimɓe dow leydi, yimɓe horsuɓe e makko ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nde malaa'ika'en ɓee ceerti e maɓɓe ndee, ŋabbiti kammu. Durooɓe ɓee ndarii ana mbiyondira: —Njehen Baytilaama, ƴeewen ko waɗi, ko Joomiraaɗo anndini en koo. ");
INSERT INTO ffm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ɓe keɲii, ɓe njehi, ɓe tawi ton Mariyama e Yuusufu e cukalel keccel ngel engel lelnaa ley akalaawal. ");
INSERT INTO ffm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nde ɓe njiinoo ngel ndee, ɓe kaalti ko malaa'ika oo haalnoo e maggel koo. ");
INSERT INTO ffm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nanɓe haala durooɓe ɓee fuu, kaayɗe nanngi ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kaa Mariyama ana resi ɗum fuu e hakkille mum, o heddii omo miiloo ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Caggal ɗum, durooɓe ɓee mbirfitii ana teddina Laamɗo ana njetta ɗum, saabe ko ɓe nani e ko ɓe njii. Sabi ɗum fuu ɗum laatorike no malaa'ika oo haalanirnoo ɓe nii. ");
INSERT INTO ffm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nde ɲalooma jettaɓo pinaaɗe cukalel ngel yottinoo ndee, ngel taadaa, ngel inndiraa Iisaa. Ɗum woni innde nde malaa'ika oo haalannoo Mariyama gila reedaali ndee. ");
INSERT INTO ffm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nde laaɓugol Mariyama yottinoo, hono no Sariya Muusaa yamiri nii, ɓe naɓi cukalel ngel Urusaliima faa ɓe ɓattina ngel Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Sabi nii winndiraa e Sariya Joomiraaɗo: «Ɓiɗɗo gorko hammadiijo fuu, Joomiraaɗo woodani.» ");
INSERT INTO ffm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ɓe ngaɗi duu sadaka kirsamaajo hono no Joomiraaɗo yamiri nii: ɓiɓɓe buugaaji ɗiɗi naa ɓiɓɓe pooli maraaɗi ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gorko gooto ana wonnoo Urusaliima, ana wiyee Simeyon. Ruuhu Ceniiɗo ana e makko, o gorko pooccitiiɗo kulɗo Laamɗo, omo heɗinoo wakkati mo gonɗi Israa'iila coccetee. ");
INSERT INTO ffm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ruuhu Ceniiɗo oo anndinnoo mo e koyɗol, o maayataa o yiyaali Almasiihu Joomiraaɗo oo. ");
INSERT INTO ffm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jooni Ruuhu naanni mo ley Suudu Dewal Mawndu nduu, wakkati mo saaraaɓe ɓee ngaddi cukalel ngel faa ngaɗana ɗum ko Sariya oo yamiri koo. ");
INSERT INTO ffm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeyon nanngi ngel, tammbii ngel e juuɗe mum, darii ana yetta Laamɗo, ana wiya: ");
INSERT INTO ffm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Joomiraaɗo, fodoore maa ndee tabitii, ɓamtu maccuɗo maa e jam. ");
INSERT INTO ffm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sabi mi yiirii gite am kisindam ");
INSERT INTO ffm_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ɗam lanndinani-ɗaa yimɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kisindam ɗam yo fooyre yaaynanoore leɲi aduna oo fuu, ɗam fooyre teddinoore leɲol maa Israa'iila duu. ");
INSERT INTO ffm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ko haalaa e maggel koo, haaynii inna maggel e baaba maggel. ");
INSERT INTO ffm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeyon duwanii ɓe, wii Mariyama, inna maggel: —Ngel cukalel wardii liɓude yogaaɓe e imminde yogaaɓe ley Israa'iila. Ngel finnde nde yimɓe calotoo. ");
INSERT INTO ffm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Nii miilooji gonɗi e yimɓe ɓanngirta. Aan e hoore maa, metti suufan ɓernde maa no kaafaawi nii. ");
INSERT INTO ffm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Annabaajo debbo biyeteeɗo Anna ana ɗon kaɲum duu. O ɓii Fanu'iila, jeyaaɗo e suudu Asiira. O naywii sanne. O suddaama e surbaaku makko, o waaldii e jom suudu makko duuɓi jeɗɗi, ");
INSERT INTO ffm_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","oon maayi, o heddii o walaa gorko. Jooni duuɓi makko ana mbaara e capanɗe jetti e nay, o yaltataa Suudu Dewal Mawndu nduu fey, omo rewra Joomiraaɗo koorka e duwaawu, jemma e ɲalooma fuu. ");
INSERT INTO ffm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","E oon wakkati, o wari kanko duu, o darii omo yetta Laamɗo, omo haalana doomtuɓe coottitaari Urusaliima ɓee fuu kabaaru cukalel ngel. ");
INSERT INTO ffm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Nde Yuusufu e Mariyama ngaɗunoo huunde fuu ko Sariya Joomiraaɗo yamiri koo ndee, ɓe mbirfitii ngeenndi maɓɓe Nasaraatu ley leydi Galili. ");
INSERT INTO ffm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Cukalel ngel ana mawna, ana ɓeydoroo semmbe e hakkille. Korsa Laamɗo ana e maggel. ");
INSERT INTO ffm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Hitaande fuu, saaraaɓe Iisaa ŋabban Urusaliima so iidi Paska warii. ");
INSERT INTO ffm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nde o heɓi duuɓi sappo e ɗiɗi ndee, ɓe ŋabbi Urusaliima no ɓe mboowrunoo nii, ɓe naɓori mo. ");
INSERT INTO ffm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Iidi oo tilii, ɓe mbirfitii ɓe kooti, jaka Iisaa heddike Urusaliima, tawi ɓe anndaa, ");
INSERT INTO ffm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ɓe cikkuno omo wondi e yaaduɓe maɓɓe. Ɓe njehi ɲalooma kiɓɓo. Caggal mum, ɓe puɗɗi tewtude mo hakkunde sakiraaɓe maɓɓe e yiɓɓe maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Kaa nde wonnoo ɓe njiitaali mo ndee, ɓe mbirfitii Urusaliima tewtoyde mo. ");
INSERT INTO ffm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Balɗe tati caggal mum, ɓe tawi mo ley Suudu Dewal Mawndu, omo jooɗii hakkunde jannginooɓe, omo hettindii ɗum'en, omo lamnditoo ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Hettindiiɓe mo ɓee fuu kaaynaa hakkille makko e jaabuuji makko. ");
INSERT INTO ffm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nde saaraaɓe makko njiiti mo ndee, kaayɗe nanngi ɗum'en. Inna makko wii mo: —Ɓinngel am, ko saabii so ngaɗu-ɗaa min nii? Miin e baaba maa fuu, min cuŋlii e tewtude ma. ");
INSERT INTO ffm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","O jaabii, o wii: —Koɗum waɗi so oɗon tewta kam? Tama on anndaa ana tilsi mi wona e suudu Baabiraaɗo am? ");
INSERT INTO ffm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kaa ɓe paamaali haala ka o haalani ɓe kaa. ");
INSERT INTO ffm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Caggal ɗum, o regodii e maɓɓe, ɓe kooti Nasaraatu, o ɗowtanii ɓe. Inna makko ana resunoo kulle ɗee fuu e hakkille mum. ");
INSERT INTO ffm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Iisaa ana mawna, hakkille mum ana ɓeydoo. Laamɗo e yimɓe fuu korsini mo. ");
INSERT INTO ffm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Laamɗo loowi Yaayaa ɓii Jakariyaa oo konngol mum ley ladde jeereende. Ɗum hawrii e hitaande sappo e joyoɓerde laamu Tibeer kaananke Roma mawɗo oo, nde Pontiyu Pilaatu wonnoo goforneer Yahuudiya, Hirudus duu ana laamii Galili, mawnum Filipa ana laamii leydi Ituriya e Tarankoniti, Lisaniya duu ana laamii leydi Abileen, hawri e nde Annas e Kayafas ngonnoo hooreeɓe yottinooɓe sadaka. ");
INSERT INTO ffm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yaayaa yiilii e seraaji maayo Urdun fuu ana ooynoo yimɓe tuuba, lootee lootogal batisima yalla luutti mum'en ana njaafee. ");
INSERT INTO ffm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nii haala mum winndiraa e dewtere annabi Esaaya: «Neɗɗo ana ooynoo ley ladde jeereende ana wiya: Moƴƴinee laawol Joomiraaɗo ngol, ndartinee ɗati makko! ");
INSERT INTO ffm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Naɗɗiire fuu diɗɗete, waamnde haayre e toowondireere fuu leyɗinee, laawi ooɲiiɗi fuu ndartinee, laawi bonɗi fuu moƴƴintinee! ");
INSERT INTO ffm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Neɗɗo fuu yiyan kisindam iwroojam to Laamɗo.» ");
INSERT INTO ffm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yimɓe heewɓe ana ngarannoo to Yaayaa faa lootee lootogal batisima. Kaa omo wiya ɓe: —Ɓiɓɓe bolle! Homo jeertini on ndogon jukkungo waroowo? ");
INSERT INTO ffm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ngollee golleeji kawrooji e tuubal. Pati miilee e ɓerɗe mon: «Minen, min taaniraaɓe Ibarahiima.» Sabi miɗo wiya on: Laamɗo ana waawi waylitinde ɗee kaaƴe laatoo ɓiɓɓe Ibarahiima. ");
INSERT INTO ffm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jooni jammbere ndee huncaama faa soppa ɗaɗi leɗɗe. Ndennoo, lekki fuu ki rimataa ɓiɗɗe lobbe, soppete, wedee e yiite. ");
INSERT INTO ffm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yimɓe ɓee lamndii mo, mbii: —Koɗum min kaani waɗude? ");
INSERT INTO ffm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","O jaabii ɓe, o wii: —Neɗɗo fuu jogiiɗo saayaaji ɗiɗi, yo hokku ngoota kaa mo walaa, neɗɗo fuu jogiiɗo nguure, yo waɗu hono non. ");
INSERT INTO ffm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Duwaaɲe'en ngari kaɲum'en duu faa lootee lootogal batisima, mbii mo: —Moobbo, koɗum min kaani waɗude? ");
INSERT INTO ffm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","O jaabii ɓe, o wii: —Pati njoɓinee yimɓe ko yawti sariya. ");
INSERT INTO ffm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sordaasi'en lamndii mo kaɲum'en duu, mbii: —Minen nee, koɗum min kaani waɗude? O wii ɓe: —Pati ngarɲee fay gooto, pati kappee fay gooto fenaande, keɲɲitoree njoɓdi mon. ");
INSERT INTO ffm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tawi yimɓe fuu ana ndenngii Almasiihu, gooto e maɓɓe fuu ana miila e ɓernde mum yalla wanaa Yaayaa woni Almasiihu ya? ");
INSERT INTO ffm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yaayaa jaabii ɓe fuu, wii: —Miin, ndiyam mbatisiran-mi on. Kaa ɓurɗo kam baawɗe ana wara. Mi fotaa fay humtude ɓoggi paɗe makko. Kanko, Ruuhu Ceniiɗo e yiite o batisirta on. ");
INSERT INTO ffm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","O lanndinike faa o hennoo ɲamri makko faa laaɓa. O mooɓta ɲamri ndii ley beembal makko, kaa ɲaande ndee o duppiran ɗum yiite nge ɲifataa. ");
INSERT INTO ffm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Tawi Yaayaa ɓannginanii yimɓe kabaaru Laamɗo, o waajorike ɓe kulle keewɗe. ");
INSERT INTO ffm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kaa Hirudus kaananke oo, o feliino ɗum saabe taƴii Hirudiya jom suudu mawnum, kaɲum e kulle goɗɗe bonɗe fuu ɗe waɗannoo. ");
INSERT INTO ffm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hirudus yowi hen bonnde wonnde kasen, o uddii Yaayaa e kasu. ");
INSERT INTO ffm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ɗo yimɓe fuu lootaa lootogal batisima ɗoo, ɗoo Iisaa duu lootaa. Wakkati mo o duwotoo oo, kammu udditii, ");
INSERT INTO ffm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ruuhu Ceniiɗo jipporii e makko mbaadi wuugaandu. Daande ooynii iwde dow kammu, wii: —Aan woni Ɓiyam mo korsin-mi, aan cuɓii-mi. ");
INSERT INTO ffm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nde Iisaa fuɗɗata golle mum ndee, duuɓi mum ana njaara e capantati. E ley jate yimɓe, Iisaa yo ɓii Yuusufu. Yuusufu yo ɓii Eli, ");
INSERT INTO ffm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli ɓii Matat, Matat ɓii Lewi, Lewi ɓii Melki, Melki ɓii Yannaayi, Yannaayi ɓii Yuusufu, ");
INSERT INTO ffm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yuusufu ɓii Matatiya, Matatiya ɓii Amos, Amos ɓii Nahum, Nahum ɓii Hesili, Hesili ɓii Naggaayi, ");
INSERT INTO ffm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggaayi ɓii Maata, Maata ɓii Matatiya, Matatiya ɓii Semeyin, Semeyin ɓii Yuseka, Yuseka ɓii Yoda, ");
INSERT INTO ffm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda ɓii Yohana, Yohana ɓii Resa, Resa ɓii Jorobaabel, Jorobaabel ɓii Salaatiyel, Salaatiyel ɓii Neeri, ");
INSERT INTO ffm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neeri ɓii Melki, Melki ɓii Addi, Addi ɓii Kusama, Kusama ɓii Almadama, Almadama ɓii Eri, ");
INSERT INTO ffm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri ɓii Iisaa, Iisaa ɓii Eliyeseer, Eliyeseer ɓii Yorima, Yorima ɓii Matat, Matat ɓii Lewi, ");
INSERT INTO ffm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi ɓii Simeyon, Simeyon ɓii Yahuuda, Yahuuda ɓii Yuusufu, Yuusufu ɓii Yonam, Yonam ɓii Eliyakim, ");
INSERT INTO ffm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim ɓii Malaya, Malaya ɓii Menna, Menna ɓii Mattata, Mattata ɓii Natana, Natana ɓii Daawuuda, ");
INSERT INTO ffm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Daawuuda ɓii Yessa, Yessa ɓii Obed, Obed ɓii Bo'es, Bo'es ɓii Sala, Sala ɓii Nasuuna, ");
INSERT INTO ffm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasuuna ɓii Aminadaabu, Aminadaabu ɓii Adamin, Adamin ɓii Arni, Arni ɓii Hisuruuna, Hisuruuna ɓii Fares, Fares ɓii Yahuuda, ");
INSERT INTO ffm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahuuda ɓii Yaakuuba, Yaakuuba ɓii Isiyaaka, Isiyaaka ɓii Ibarahiima, Ibarahiima ɓii Taraha, Taraha ɓii Nahor, ");
INSERT INTO ffm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ɓii Saruku, Saruku ɓii Ragawu, Ragawu ɓii Faleka, Faleka ɓii Eber, Eber ɓii Sala, ");
INSERT INTO ffm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala ɓii Kaynam, Kaynam ɓii Arfasada, Arfasada ɓii Samu, Samu ɓii Nuuhu, Nuuhu ɓii Lamaka, ");
INSERT INTO ffm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamaka ɓii Matusala, Matusala ɓii Henok, Henok ɓii Yarada, Yarada ɓii Maleliyel, Maleliyel ɓii Kaynam, ");
INSERT INTO ffm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynam ɓii Enos, Enos ɓii Setu, Setu ɓii Aadama, Aadama ɓii Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Iisaa iwi maayo Urdun yo keewɗo Ruuhu Ceniiɗo. Ruuhu oo naɓi mo ley ladde jeereende. ");
INSERT INTO ffm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","To ley jeereende too, Ibiliisa waddi e makko balɗe capanɗe nay ana tewta seytaade mo. Fay huunde o ɲaamaali ley ɗen ɲalaaɗe fuu. Ko sakitii koo, o yolbi. ");
INSERT INTO ffm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ibiliisa wii mo: —So a Ɓii Laamɗo, yamir ndee haayre laatoo ɲaamdu. ");
INSERT INTO ffm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Iisaa jaabii mo, wii: —Ana winndii: «Wanaa ɲaamdu tan neɗɗo wuurdata.» ");
INSERT INTO ffm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ibiliisa naɓi mo nokku toowɗo, holli mo wakkati gooto laamuuji aduna oo ɗii fuu, ");
INSERT INTO ffm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","wii mo: —Mi hokkete baawɗe dow ɗum fuu, kaɲum e teddungal mum. Sabi miin hokkaa ɗum, miɗo waawi hokkude mo muuy-mi. ");
INSERT INTO ffm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","So a sujidanii kam, ɗum fuu yo aan jey. ");
INSERT INTO ffm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Iisaa jaabii mo, wii: —Ana winndii: «Joomiraaɗo maa Laamɗo tan kaan-ɗaa sujidande, kanko tan kaan-ɗaa rewde.» ");
INSERT INTO ffm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kasen Ibiliisa naɓi mo Urusaliima, darni mo dow leŋŋe-leŋŋe Suudu Dewal Mawndu, wii mo: —So a Ɓii Laamɗo, suur njippo-ɗaa e leydi, ");
INSERT INTO ffm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","sabi ana winndii: «O yamiran malaa'ika'en makko ndeene.» ");
INSERT INTO ffm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ana winndii kasen: «Ɓe njaɓɓete, pati koyngal maa gaaɲoo e haayre.» ");
INSERT INTO ffm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Iisaa jaabii mo, wii: —Ana winndii: «Pati ittu koro Laamɗo, Joomiraaɗo maa.» ");
INSERT INTO ffm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nde Ibiliisa ronkunoo seytaade mo ndee, seli e makko seeɗa. ");
INSERT INTO ffm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Iisaa wirfitii leydi Galili, semmbe Ruuhu ana e mum, kabaaru makko saakii e leydi ndii fuu. ");
INSERT INTO ffm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Omo waajoo ley cuuɗi baajorɗiYahuudiyankooɓe, yimɓe fuu ana teddini mo. ");
INSERT INTO ffm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","O yehi Nasaraatu ɗo o mawni ɗoo, o naati e ley suudu waajordu ɲalaande fowteteende no o woowiri nii. O immii faa o jannga, ");
INSERT INTO ffm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","o hokkaa dewtere annabi Esaaya, o udditi nde, o forri e nokku binndiraaɗo hono nii: ");
INSERT INTO ffm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Ruuhu Joomiraaɗo ana e am, sabi o suɓike kam faa mi anndina misikiina'en Kabaaru Lobbo. O nelii kam faa mi ooynanoo nanngaaɓe yoppiteede mum'en, e wumɓe wumtineede mum'en, e torraaɓe yoppiteede mum'en, ");
INSERT INTO ffm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","faa mi ooynoo hitaande nde Joomiraaɗo hollata moƴƴere mum ndee warii.» ");
INSERT INTO ffm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Caggal ɗum, o uddi dewtere ndee, o totti nde golloowo ley suudu waajordu nduu oo, o jooɗii. Wonnooɓe ton ɓee fuu, puttini mo gite. ");
INSERT INTO ffm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","O darii omo wiya ɓe: —Ko winndii koo, hannde ɗum tabitii ɗo nan-ɗon ɗum ɗoo. ");
INSERT INTO ffm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ɓe fuu eɓe kaala haala makko lobba, kasen duu konngi lobbi jaltuɗi e hunduko makko ɗii ana kaaynoo ɓe. Ɓe ndarii eɓe mbiya: —Wanaa oo woni ɓii Yuusufu oo naa? ");
INSERT INTO ffm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","O wii ɓe: —Miɗo anndi on kaalanan kam ngol banndol: «Cawroowo, sawru hoore maa. Ko min nani a waɗii Kafarnahum koo, waɗu ɗum ngeenndi maa ɗoo duu.» ");
INSERT INTO ffm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","O wii kasen: —Miɗo haalana on goonga: annabaajo fay gooto jaɓantaake e ngeenndi mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Miɗo haalana on, rewɓe misikiina'en ɓe worɓe mum'en maayi ana keewnoo Israa'iila e jamaanu annabi Iliyaasa, wakkati nde waadere kammu saamaali e leydi ndii duuɓi tati e lebbi jeegom. Nden yolbere mawnde waɗiino e leydi ndii fuu. ");
INSERT INTO ffm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kaa annabi Iliyaasa nelaaka e fay gooto e maɓɓe, so wanaa e debbo gooto mo gorum maayi, jeyaaɗo Sarepta leydi Sidon. ");
INSERT INTO ffm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kasen duu, seppaaɓe ana keewnoo Israa'iila e jamaanu annabi Eliisa, kaa fay gooto e maɓɓe sellinaaka, so wanaa Naaman jeyaaɗo e leydi Siriya. ");
INSERT INTO ffm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nde yimɓe wonɓe e ley suudu waajordu nduu nannoo kaa haala ndee, mettaa sanne, ");
INSERT INTO ffm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","immii, ndibbi Iisaa faa caggal ngeenndi, ngaddi ɗum faa sera waamnde haayre ɗo ngeenndi maɓɓe ndii woni ɗoo, faa mbedoo mo ley. ");
INSERT INTO ffm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kaa o seeki hakkunde maɓɓe, o witti. ");
INSERT INTO ffm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Iisaa yehi Kafarnahum ley leydi Galili, omo waajoo yimɓe e ley ɲalaande fowteteende. ");
INSERT INTO ffm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ɓe kaaynaa e waaju makko oo, sabi omo waajoroo ɓe baawɗe. ");
INSERT INTO ffm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gorko mo seyɗaani woni e mum ana ley waajordu nduu, wulli faa toowi, wii: ");
INSERT INTO ffm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Iisaa Nasaraatunke oo, koɗum hillu maa e amen? A garɗo halkude min naa? Miɗo anndi ko ngon-ɗaa, a ceniiɗo iwruɗo to Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Iisaa jahii e seyɗaani oo, wii: —Deƴƴu yaltu e makko! Seyɗaani oo liɓi neɗɗo oo hakkunde yimɓe fuu yalti e mum, tawi ɗum waɗaali neɗɗo oo fay huunde. ");
INSERT INTO ffm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ɓe fuu ɓe kaaynaa, hedde eɓe lamndondira hakkunde maɓɓe: —Ko kaa haala woni? Seyɗaani'en ɓee, omo yamira ɓe semmbe e doole ɓe njaltan! ");
INSERT INTO ffm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Innde Iisaa nanaa e seraaji ɗii fuu. ");
INSERT INTO ffm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nde o yalti suudu waajordu nduu ndee, o naati galle taalibbo makko biyeteeɗo Simon. Esii Simon debbo ana wondunoo e jontere naawnde, ɓe ndaardi mo o walla ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","O darii sera daɗɗo mum, o jahii e jontere ndee, non jontere ndee yoppi debbo oo, o selli. Debbo oo immii ɗon e ɗon, laatanii ɓe njaatigi. ");
INSERT INTO ffm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nde naange mutunoo, jogiiɗo ɲawɗo fuu waddi ɗum e makko. Ɲawɓe ɲawuuji ko ɗi tawaa fuu ngaddaa, o fawi junngo makko e maɓɓe ɓe fuu gooto gooto, o sellini ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Seyɗaani'en ana njalta e yimɓe heewɓe ana ngulla, ana mbiya: —Aan woni Ɓii Laamɗo! Omo jahoo e maɓɓe, omo wiya ɓe ndeƴƴa, sabi eɓe anndi kanko woni Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nde weetunoo ndee, Iisaa yalti, yehi nokku teelɗo. Jamaa oo tewti mo faa yiiti mo, nanngi mo pati o seerta e mum. ");
INSERT INTO ffm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kaa o wii ɓe: —Ana tilsi mi ɓanngina Kabaaru Lobbo haala Laamu Laamɗo oo e geelle goɗɗe. Sabi kammari majjum neliraa-mi. ");
INSERT INTO ffm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","O yehi, hedde omo waajoo ley cuuɗi baajorɗi leydi Yahuudiya. ");
INSERT INTO ffm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ɲannde wootere Iisaa ana darii dow fonngo weendu Genesareeti, hedde jamaa ana ɓillondira sera makko faa hettindoo konngol Laamɗo ngol. ");
INSERT INTO ffm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","O yii laanaaji ɗiɗi ana panndi e daŋŋeere weendu nduu. Awooɓe yaltuɓe e majji ɓee, ana lalla bubbi mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","O naati ngoota e laanaaji ɗii, ka Simon kaa, o ndaardi ɗum deerta ka seeɗa, ka iwa e njoorndi ndii. O jooɗii e laana kaa, omo waajoo jamaa oo. ");
INSERT INTO ffm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nde mo tilii waajaade ndee, mo wii Simon: —Njehee to luggiɗi, tippo-ɗon bubbi mon, awon. ");
INSERT INTO ffm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon jaabii, wii: —Moobbo, min mbaalii miɗen awa, min keɓaali fay huunde. Kaa so non mbii-ɗaa, mi tippoto bubbi ɗii. ");
INSERT INTO ffm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nde ɓe tippii ɗi ndee, ɓe nanngi liɗɗi faa heewi, faa bubbi maɓɓe kosi seekaade. ");
INSERT INTO ffm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɓe noddi wondiiɓe maɓɓe wonɓe e laana ngokka kaa ɓee, ngara mballa ɓe. Ɓeen ngari, ɓe kebbini laanaaji ɗiɗi ɗii fuu, faa ɗi kosi mutude. ");
INSERT INTO ffm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Nde Simon Piyeer yii ɗum ndee, diccii yeeso Iisaa, wii ɗum: —Moobbo, woɗɗitam, sabi mi neɗɗo luuttuɗo. ");
INSERT INTO ffm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ko saabii so o wii ɗum dee, kanko e wondiiɓe makko ɓee fuu, ɓe kaaynaama saabe keewal liɗɗi ɗi ɓe nanngi ɗii. ");
INSERT INTO ffm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hono non Yaakuuba e Yuhanna ɓiɓɓe Jebede reentuɓe e Simon ɓee duu kaayniraa. Kaa Iisaa wii Simon: —Pati hul, gila jooni a laatoto awoowo yimɓe. ");
INSERT INTO ffm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Nii ɓe panndi laanaaji maɓɓe ɗii, ɓe njoppi fuu, ɓe njokki e Iisaa. ");
INSERT INTO ffm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nden Iisaa ana wonnoo e ngeenndi ngootiri, faa gorko ceppaaɗo yii ɗum, diccii yeeso mum, wii: —Moobbo, so tawii a jaɓii, aɗa waawi sellinde kam. ");
INSERT INTO ffm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iisaa foocci junngo mum, memi mo, wii: —Mi jaɓii, sellu! Ɗon e ɗon ceppe ɗee iwi e makko. ");
INSERT INTO ffm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Caggal ɗum, Iisaa daalii mo pati mo haalana ɗum fay gooto, kaa wii mo: —Yaa holloy hoore maa jottinoowo sadaka, ngaɗanaa laaɓugol maa ngol sadaka mo Muusaa yamiri oo, faa anndina ɓe a sellii. ");
INSERT INTO ffm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Non innde Iisaa ɓeydii naneede. Jamaa keewɗo wari, hawriti ɗo makko faa hettindanoo mo, sellinee e ɲawuuji mum'en, ");
INSERT INTO ffm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","kaa o serindii e nokkuuje teelɗe, omo waɗa duwaawu. ");
INSERT INTO ffm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ɲannde wootere Iisaa ana waajoo. Farisa'en e jannginooɓe Sariya Muusaa, iwruɓe geelle Galili e Yahuudiya, kaɲum e Urusaliima fuu, ana njooɗii. Joomiraaɗo ana ɓanngina baawɗe mum e makko, omo sellina ɲawuuji. ");
INSERT INTO ffm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Non yogaaɓe ngaddi gorko bonnguujo ana lelnaa e dengeleewo, ana tewta naannude ɗum faa lelna ɗum yeeso makko. ");
INSERT INTO ffm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kaa nde ɓe ndonkunoo naannude mo sabaabu jamaa oo, ɓe ŋabbinoyi mo dow bene oo, ɓe kippiti ɗum, ɓe njippini bonnguujo oo e dengeleewo mum fuu hakkunde yimɓe ɓee yeeso Iisaa. ");
INSERT INTO ffm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nde o yiinoo goonɗinal maɓɓe ndee, o wii bonnguujo oo: —Giɗam, luutti maa njaafaama. ");
INSERT INTO ffm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dunkee'en Sariya ɓee e Farisa'en keddii miilde ana mbiya e ko'e mum'en: «Oo homo bonkotoo Laamɗo? Homo waawi yaafaade luutti so wanaa Laamɗo gooto oo?» ");
INSERT INTO ffm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Iisaa faami miilooji maɓɓe, jaabii ɓe, wii: —Koɗum waɗi so oɗon miiloo miilooji baaɗi nii e ɓerɗe mon? ");
INSERT INTO ffm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wiide: «Luutti maa njaafaama» e wiide: «Imma yaa», koɗum hen ɓuri newaade? ");
INSERT INTO ffm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kaa faa mi anndina on Ɓii Neɗɗo ana jogii baawɗe e aduna oo yaafaade luutti… Nden o wii bonnguujo oo: —Miɗo haalane: imma, ɓam dengeleewo maa, njahaa suudu maa. ");
INSERT INTO ffm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ɗon e ɗon, bonnguujo oo immii yeeso yimɓe fuu, ɓamti dengeleewo mum, hooti suudu mum ana yetta Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ɓe fuu ɓe kaaynaa, hedde eɓe njetta Laamɗo. Kulol nanngi ɓe, ɓe mbii: —Hannde njii-ɗen kaayeefiiji. ");
INSERT INTO ffm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Caggal ɗum, Iisaa yalti, yii duwaaɲe gooto ana wiyee Lewi ana jooɗii e duwaaɲeere mum. O wii ɗum: —Jokku e am! ");
INSERT INTO ffm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lewi yoppi fuu, immii, jokki e makko. ");
INSERT INTO ffm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lewi naɓi mo galle mum, hoocci mo koɗu mawɗo, duwaaɲe'en heewɓe e yimɓe woɓɓe ana ɲaamda e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisa'en e dunkee'en Sariya mum'en keddii ana ŋurŋurta, ana mbiya taalibaaɓe makko ɓee: —Ko saabii so oɗon ɲaamda oɗon njarda e duwaaɲe'en, kaɲum e luuttooɓe hono mum'en? ");
INSERT INTO ffm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iisaa jaabii ɓe, wii: —Wanaa celluɗo hasindini e cawroowo, ɲawɗo hasindini e cawroowo. ");
INSERT INTO ffm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wanaa noddude fooccitiiɓe waddi kam, noddude luuttooɓe faa tuuba woni ko waddi kam. ");
INSERT INTO ffm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ɓe mbii mo: —Taalibaaɓe Yaayaa ana koora ana ngaɗa duwaawu wakkati fuu, hono non taalibaaɓe Farisa'en ɓee duu ngaɗata. Kaa ɓe maa ɓee, ana ɲaama ana njara. ");
INSERT INTO ffm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","O wii ɓe: —Oɗon mbaawi hoorinde nootiiɓe kuurtungu, tawa jommbaajo gorko ana wondi e mum'en naa? ");
INSERT INTO ffm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kaa ɲalaaɗe ngaran ɗe jommbaajo gorko oo ittetee e hakkunde maɓɓe. E ɗeen ɲalaaɗe ɓe kooran. ");
INSERT INTO ffm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","O haalani ɓe banndol kasen: —Fay gooto ittataa e kaddungal kesal fetalaare, faa ɗammbira kiinngal. So ɗum waɗii, joomum bonnan kesal ngal, tawee fetalaare ittaande hen ndee yaadataa e kiinngal ngal. ");
INSERT INTO ffm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kasen duu, fay gooto loowataa peguujam kesam e sumalleeji kiiɗɗi. So ɗum waɗii, peguujam kesam ɗam fusan ɗi, yuppoo, ɗi mursee. ");
INSERT INTO ffm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Peguujam kesam e sumalleeji kesi loowetee. ");
INSERT INTO ffm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Fay gooto muuyataa peguujam kesam so yarii kiiɗɗam, sabi wiyan kiiɗɗam ɗam ɓuri welde. ");
INSERT INTO ffm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Waɗiino e ɲalaande fowteteende wootere, Iisaa ana seeka gese. Taalibaaɓe makko ana kelta butaali, ana ngoroo ana ƴakka. ");
INSERT INTO ffm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Kaa yoga e Farisa'en mbii ɓe: —Ko saabii so oɗon ngolla ko dagaaki gollude ɲalaande fowteteende? ");
INSERT INTO ffm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Iisaa jaabii ɓe, wii: —Tama on njanngaali ko Daawuuda waɗi nde yolbi, kaɲum e yimɓe mum? ");
INSERT INTO ffm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","O naati e ley hukkum ceniiɗo oo, o ɲaami buuru cakkaaɗo oo, o hokki hen yimɓe makko. Tawee nee, yottinooɓe sadaka tan nduŋanaa ɲaamde oon buuru. ");
INSERT INTO ffm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","O wii ɓe kasen: —Ɓii Neɗɗo jey ɲalaande fowteteende. ");
INSERT INTO ffm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ɲalaande fowteteende wonnde, o naati suudu waajordu omo waajoo. Gorko mo junngo mum ɲaamo waati ana tawaa ton. ");
INSERT INTO ffm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Dunkee'en Sariya e Farisa'en ana ngattani Iisaa hakkille. Ana ƴeewa yalla o anniyiiɗo sellinde gorko oo e ley ɲalaande fowteteende ndee, faa keɓa wullanaade mo. ");
INSERT INTO ffm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kaa nde wonnoo omo anndi miilooji maɓɓe, o wii mo junngo mum waati oo: —Imma, dara hakkunde yimɓe! Gorko oo immii, darii. ");
INSERT INTO ffm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Caggal ɗum, Iisaa wii ɓe: —Miɗo lamndoo on: e ley ɲalaande fowteteende ana dagoo gollude ko moƴƴi naa gollude ko boni? Danndude neɗɗo naa halkude ɗum? ");
INSERT INTO ffm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","E oon wakkati, o ƴeewi ɓe fuu, o wii mo junngo mum waati oo: —Fooccu junngo maa! Oon foocci ngo tan, ngo selli faa warti hono no wonngo ngoo nii. ");
INSERT INTO ffm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ɗum metti ɓe sanne, hedde eɓe piya dabare no ɓe kaani waɗude Iisaa. ");
INSERT INTO ffm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","E ley ɗeen ɲalaaɗe, Iisaa yalti, yehi dow waamnde haayre faa waɗa duwaawu. O waali waɗude duwaawu. ");
INSERT INTO ffm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nde weetunoo ndee, o noddi taalibaaɓe makko ɓee, o suɓii hen sappo e ɗiɗon, o inndiri ɗum'en nelaaɓe. ");
INSERT INTO ffm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Kamɓe ngoni: Simon mo o innditiri Piyeer e Andire miɲum e Yaakuuba e Yuhanna e Filipa e Bartolome ");
INSERT INTO ffm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","e Matta e Tomaa e Yaakuuba ɓii Alfaa e Simon noddirteeɗo Kiranoowo suudu baaba ");
INSERT INTO ffm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","e Yahuuda ɓii Yaakuuba e Yahuuda Isikariyota jammbotooɗo mo oo. ");
INSERT INTO ffm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","O jippodii e maɓɓe, o darii e nokku jaajuɗo, kanko e heewɓe e taalibaaɓe makko. Jamaa keewɗo iwri e ley leydi Yahuudiya fuu e Urusaliima e gure tiimuɗe maayo geeci gila Tirus faa Sidon. ");
INSERT INTO ffm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ɓe ngari hettindanaade mo e sellineede e ɲawuuji maɓɓe. Ɓe ladde torrunoo cellinaama. ");
INSERT INTO ffm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yimɓe ɓee fuu ana njiɗi memde mo, sabi baawɗe ana njalta e makko cellina ɗum'en fuu. ");
INSERT INTO ffm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","E oon wakkati fuu, o hunci gite makko o ƴeewi taalibaaɓe makko ɓee, o wii: —Onon misikiina'en, on mbelii hoore, sabi onon njey Laamu Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Onon yolbuɓe jooni, on mbelii hoore, sabi on kaaran. Onon woyooɓe jooni, on mbelii hoore, sabi on njalan. ");
INSERT INTO ffm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","On mbelii hoore so yimɓe mbaɲii on, ndibbii on, njennii on, mbonnii inɗe mon saabe Ɓii Neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ɲannde mum, ceyee, ilino-ɗon, sabi mbarjaari mawndi ana doomi on dow kammu. Hono non ɓe ngaɗunoo annabaaɓe aranndeeɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kaa bone woodanii on, onon arsukunte'en, sabi on keɓii neema mon. ");
INSERT INTO ffm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bone woodanii on, onon haarɓe jooni, sabi on njolban. Bone woodanii on, onon jalooɓe jooni, sabi on cuŋlan, on mboyan. ");
INSERT INTO ffm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bone woodanii on, so yimɓe fuu manii on, sabi hono non ɓe ngaɗunoo annabaaɓe peneeɓe ɓee duu. ");
INSERT INTO ffm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Kaa onon hettindantooɓe kam ɓee, miɗo wiya on: njiɗee konnee'en mon, tikkanɓe on ngaɗanon ɗum'en moƴƴere. ");
INSERT INTO ffm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nduwanee huɗooɓe on, torrooɓe on duu, ɲaagano-ɗon ɗum'en Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","So won piiɗo ma banaawo, accu ɗum fiye bannge goɗɗo oo duu. So won teetuɗo ma dolloke maa, pati haɗu ɗum forgo oo duu. ");
INSERT INTO ffm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Neɗɗo fuu ɲaagiiɗo ma, ndokkaa ɗum. Teetuɗo ma jawdi maa, njoppiraa ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ngaɗiranee yimɓe no njiɗ-ɗon ɓe ngaɗirana on nii. ");
INSERT INTO ffm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","So yiɗuɓe on tan njiɗaton, ɓural hongal keɓaton? Fay luuttooɓe ana njiɗi yiɗuɓe ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","So waɗanooɓe on moƴƴere tan ngaɗanton moƴƴere, ɓural hongal keɓaton? Fay luuttooɓe ɓee hono non ngaɗata. ");
INSERT INTO ffm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","So ɓe miil-ɗon heɓude e mum tan ɲamloto-ɗon, ɓural hongal keɓaton? Fay luuttooɓe ɓee ana ɲamloo luuttooɓe hono mum'en, yalla ana njoɓee ɲamaande mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Kaa onon, njiɗee konnee'en mon, ngaɗon moƴƴere tawa on ɗaminaaki hen fay huunde. Nden, on keɓan mbarjaari mawndi, on laatoto ɓiɓɓe Laamɗo Toowɗo oo, sabi oon ana neemina bonnooɓe moƴƴere ana neemina bonɓe duu. ");
INSERT INTO ffm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Laatee yurmotooɓe, no Baabiraaɗo mon oo laatorii jurmotooɗo nii. ");
INSERT INTO ffm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—Pati ɲiŋee, on ɲiŋataake. Pati njukkee, on njukkataake. Njaafee, on njaafete. ");
INSERT INTO ffm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ndokkee, on ndokkete. So on ndokkii, on cowirante saawal lobbal, kebbinaangal faa ana yuppoo, sabi ko etiranton woɓɓe koo, ɗum etirante-ɗon. ");
INSERT INTO ffm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","O ɓeydani ɓe hen banndol gonngol, o wii: —Bumɗo ana waawi ɗowde bumɗo hono mum naa? So ɗum waɗii, wanaa ɓe ɗiɗon fuu, ɓe caaman ley ngaykaare naa? ");
INSERT INTO ffm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Taalibbo ɓurataa moobbo mum, taalibbo kiɓɓuɗo laatoto hono moobbo mum. ");
INSERT INTO ffm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ko saabii so aɗa yiya kuɗol ley yitere sakiike maa, tawee aan nee, a yiyataa leggal gonngal e ley nde maa ndee? ");
INSERT INTO ffm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hono mbaawru-ɗaa wiide sakiike maa: «Sakiike, ɗal mi ittane kuɗol gonngol e yitere maa ngol», tawee aan nee, a maatataa leggal gonngal e ley nde maa ndee? Naafigi, ittu leggal gonngal e yitere maa ngal tafon, nden jiile maa laaɓata, faa keɓaa no ittiraa kuɗol gonngol e yitere sakiike maa ngol. ");
INSERT INTO ffm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Lekki lobbi rimataa ɓiɗɗe bonɗe, lekki ki wooɗaa rimataa ɓiɗɗe lobbe. ");
INSERT INTO ffm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Sabi lekki fuu ana annditiree ɓiɗɗe mum. Ibbe teɓataake e kebbe, peguuje teɓataake e gi'e. ");
INSERT INTO ffm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Neɗɗo moƴƴo, ko moƴƴi iwata e ndesaari ngonndi ley ɓernde mum. Neɗɗo bonɗo, ko boni iwata e ndesaari ngonndi ley ɓernde mum. Sabi ko woni e ɓernde, ɗum yaltata e hunduko. ");
INSERT INTO ffm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—Ko saabii so oɗon noddira kam «Moobbo», kaa on ngaɗataa ko mbii-mi? ");
INSERT INTO ffm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Neɗɗo fuu garɗo e am so hettindii haalaaji am so jokki ɗi, mi hollan on mo nanndi: ");
INSERT INTO ffm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Joomum ana nanndi e neɗɗo mahuɗo suudu, so asi leydi ndii faa yottii haayre, diidi ndu dow mayre. Nde ƴiiwoonde toɓunoo faa ilaali mbuuwi, ronki fay dimmbude ndu, sabi dow haayre ndu mahaa. ");
INSERT INTO ffm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kaa nanɗo haalaaji am so jokkaali, ana wa'i hono mahuɗo suudu dow njaareendi, mo asanaali ɗum diidol. Nde ilaali mbuuwnoo, ndu wurji e leydi ɗon e ɗon, ndu boni. ");
INSERT INTO ffm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nde Iisaa tilii waajaade hettindotooɓe ɓee ndee, yehi Kafarnahum. ");
INSERT INTO ffm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Hooreejo sordaasi'en gooto, kaadime mum korsuɗo ɲawi faa ana haɓana yonki. ");
INSERT INTO ffm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Hooreejo oo nani haala Iisaa ana haalee, neli e makko mawɓe Yahuudiyankooɓe, o wara o dannda kaadime mum oo. ");
INSERT INTO ffm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ɓe ngari e Iisaa, ɓe ndaardi ɗum sanne sanne, eɓe mbiya: —Omo haani waɗaneede ɗum, ");
INSERT INTO ffm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sabi omo yiɗi leɲol men ngol, kasen duu kanko mahi suudu men waajordu nduu. ");
INSERT INTO ffm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Iisaa yaadi e maɓɓe. Kaa nde ɓe ɓadinoo galle oo ndee, hooreejo sordaasi'en oo neli yimɓe mum e makko, wii mo: —Moobbo, pati tampin hoore maa, sabi miin, mi wanaa fay huunde, fotaa ko ngaraa galle am. ");
INSERT INTO ffm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ɗum saabii mi taykike miin e hoore am, mi haanaa yaade to maa. Kaa daɲa ko kaal-ɗaa tan, kaadime am oo sellan. ");
INSERT INTO ffm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Miin e hoore am, mi laamaaɗo, miin duu miɗo laamii sordaasi'en. So mi yamirii gooto yaha, yahan, so mi wii goɗɗo wara, waran, so mi wii kaadime am waɗa huunde, waɗan. ");
INSERT INTO ffm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nde Iisaa nani kaa haala ndee, haaynaa e hooreejo sordaasi'en oo, yeeƴii yimɓe jokkuɓe e mum ɓee, wii: —Miɗo haalana on, mi yiyaali hono ngal goonɗinal e sellude fay e Israa'iilanke. ");
INSERT INTO ffm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nde nelaaɓe ɓee mbirfitii galle too ndee, tawi kaadime oo sellii. ");
INSERT INTO ffm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Janngo mum, o yehi ngeenndi mbiyeteendi Nayin, kanko e taalibaaɓe makko e yimɓe heewɓe. ");
INSERT INTO ffm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nde o ɓadinoo damal ngeenndi ndii ndee, o hawri e mahiidi suka gorko. Oon yo bajjo, abba mum maayii, inna mum ɓamaaka kasen. Yimɓe ngeenndi ndii heewɓe ana njokki e inniraaɗo oo. ");
INSERT INTO ffm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nde Iisaa yii inniraaɗo oo ndee, yurmii ɗum, wii: —Pati woy! ");
INSERT INTO ffm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Iisaa ɓadii, memi leggal naɓirgal ngal. Roondinooɓe ɓee ndarii, o wii: —Suka jokolle, miɗo wiye: imma! ");
INSERT INTO ffm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nii maayɗo oo immii jooɗii, ana haala. Iisaa totti mo inniiko. ");
INSERT INTO ffm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kulol nanngi yimɓe ɓee fuu, hedde eɓe njetta Laamɗo, eɓe mbiya: —Annabaajo mawɗo ɓanngii e ley men! Laamɗo warii faabaade yimɓe mum! ");
INSERT INTO ffm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Oo kabaaru saakii e leydi Yahuudiya e seraaji mum fuu. ");
INSERT INTO ffm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ko waɗi koo fuu, Yaayaa narrii ɗum taalibaaɓe mum, noddi ɗiɗon maɓɓe, ");
INSERT INTO ffm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","neli ɗum'en to Iisaa, ɓe lamndoo ɗum yalla kaɲum woni garoowo oo, naa ɓe ndooman goɗɗo? ");
INSERT INTO ffm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ɓeen worɓe ɗiɗon ngari e Iisaa, mbii ɗum: —Yaayaa mo lootogal batisima neli min e maa, min lamnde yalla aan woni kaanɗo warde oo, naa min ndooma goɗɗo? ");
INSERT INTO ffm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","E oon wakkati, omo sellina yimɓe heewɓe ɲawuuji ɗi ngaldaa sii, omo ribba seyɗaani'en, omo wumtina wumɓe heewɓe. ");
INSERT INTO ffm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","O jaabii ɓe, o wii: —Njehee njantanoyee Yaayaa ko njii-ɗon e ko nan-ɗon: wumɓe ana mbumta, laƴannooɓe ana njaɓɓa faa gasa, seppaaɓe ana cellinee, faaɗuɓe ana paaɗita, maayɓe ana nguurta. Misikiina'en duu kaalanaama Kabaaru Lobbo oo. ");
INSERT INTO ffm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Oon mo salaaki goonɗinde kam, welii hoore. ");
INSERT INTO ffm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Nde nelaaɓe ɓee kooti ndee, Iisaa fuɗɗi haalande jamaa oo haala Yaayaa, o wii: —Koɗum ƴeewoyno-ɗon to ladde jeereende too? Kuɗol dimmbotoongol e henndu naa? ");
INSERT INTO ffm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Koɗum ƴeewoyno-ɗon? Neɗɗo pariiɗo naa? Ɓoornotooɓe kaddule lobbe so nguura nguurndam lobbam ɓee, e cuuɗi kaanankooɓe tawetee. ");
INSERT INTO ffm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Koɗum ƴeewoyno-ɗon ndennoo? Annabaajo naa? Goonga! Miɗo haalana on, omo ɓuri annabaajo. ");
INSERT INTO ffm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Kanko woni mo Binndi ɗii mbii e mum: «Miin Laamɗo, mi ardinante nelaaɗo am moƴƴinanoowo ma laawol.» ");
INSERT INTO ffm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Miɗo haalana on, bammbaade bammbaali ɓurɗo Yaayaa, tawee nee, ɓurɗo lo'ude e Laamu Laamɗo oo ɓuri mo teddude. ");
INSERT INTO ffm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Yimɓe hettindiiɓe mo ɓee fuu, fay duwaaɲe'en ɓee, njaɓii konngol Laamɗo ngol ko Yaayaa looti ɗum'en lootogal batisima koo. ");
INSERT INTO ffm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kaa Farisa'en e jannginooɓe Sariya mberrike faandaa Laamɗo ko ɓe calii looteede e junngo Yaayaa koo. ");
INSERT INTO ffm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ndennoo, koɗum nanndinan-mi e yimɓe oo jamaanu? Hoɓe ɓe nanndi? ");
INSERT INTO ffm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Eɓe mba'i hono sukaaɓe jooɗiiɓe e luumo, ana noddondira, ana mbiya: «Min piyanii on cereeli, on mbamaali. Min mboyanii on woondu yurminiindu, on mboyaali.» ");
INSERT INTO ffm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Sabi Yaayaa mo lootogal batisima warii, ɲaamataa ɓii jalo, yarataa doro, on mbii yo laddaaɗo. ");
INSERT INTO ffm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Kaa Ɓii Neɗɗo oo warii, ana ɲaama ana yara, on mbii ɲaamde e yarde tan woni e hakkille mum, o giɗo duwaaɲe'en e luuttooɓe hono mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kaa Laamɗo hakkilante oo, jaɓuɓe ɗum ɓee fuu njiyan goonga mum. ");
INSERT INTO ffm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Gooto e Farisa'en ɓee noddi mo bottaari. O naati galle joomum, omo ɲaamda e mum. ");
INSERT INTO ffm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Debbo pijoowo ana e ngeenndi ndii. Ko o nani Iisaa ana wottoo to galle Farisanke oo koo, o waddi faandu nebam uuroojam, ");
INSERT INTO ffm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","o heedi caggal mum sera koyɗe mum, omo woya, omo leefinira koyɗe mum ɗee gonɗi makko, omo soccira ɗe sukundu makko, omo uurnoo ɗe, omo wuja e majje nebam ɗam. ");
INSERT INTO ffm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nde Farisanke nodduɗo mo oo yii ɗum ndee, wii e ley becce mum: «Sinndo oo yo annabaajo, o anndan debbo memoowo mo oo, o annditan oon yo pijoowo.» ");
INSERT INTO ffm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Iisaa haaldi e Simon Farisanke oo, wii: —Simon, miɗo haalane huunde wootere. O jaabii: —Haal, Moobbo! ");
INSERT INTO ffm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Iisaa wii: —Ɲamlotooɗo gooto ana rewannoo yimɓe ɗiɗon, gooto oo buuɗi cardi teemeɗe joy, goɗɗo oo buuɗi cardi capanɗe joy. ");
INSERT INTO ffm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kaa nde mo anndunoo ɓe ngalaa ko ɓe njoɓira mo ndee, o yaafii ɓe ɗiɗon fuu. Jooni, homo e maɓɓe ɓuri yiɗude mo? ");
INSERT INTO ffm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon jaabii: —Miɗo miila mo o yaafii kaalisi keewɗo oo. Iisaa wii mo: —A haalii goonga! ");
INSERT INTO ffm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Caggal ɗum, o yeeƴii debbo oo, o wii Simon: —A yii oo ɗoo debbo naa? Mi naatii galle maa, fay ndiyam ko mi semmbira koyɗe am a hokkaali kam. Kaa kanko, gonɗi makko o leefiniri koyɗe am, o socciri ɗe sukundu makko. ");
INSERT INTO ffm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Aan, a ɓuuccaaki kam, kaa kanko, gila naatu-mi, o ŋoottaali ɓuuccaade koyɗe am. ");
INSERT INTO ffm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","A wujaali hoore am nebam, kaa kanko, o wujii e koyɗe am nebam uuroojam. ");
INSERT INTO ffm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ɗum saabii so miɗo wiye: luutti makko e heewde fuu njaafaama, ndennoo jilli makko ana mawni. Kaa jaafaaɗo seeɗa, jilli seeɗa hollata. ");
INSERT INTO ffm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Caggal ɗum, o wii debbo oo: —Luutti maa njaafaama. ");
INSERT INTO ffm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ɲaamdannooɓe e makko ɓee ana mbiya e ko'e mum'en: «Homo woni oo gorko jaafotooɗo fay luutti?» ");
INSERT INTO ffm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Non o wii debbo oo: —Goonɗinal maa hisinii ma. Yaa e jam. ");
INSERT INTO ffm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Caggal ɗum, Iisaa ana yiiloo e geelle e gure fuu, ana ooynoo Kabaaru Lobbo haala Laamu Laamɗo. Taalibaaɓe makko sappo e ɗiɗon ɓee ana ngondi e makko, ");
INSERT INTO ffm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kaɲum e rewɓe yogaaɓe ɓe seyɗaani'en mum'en ndibbaa, ɲawuuji mum'en cellinaa. Kamɓe ngoni Mariyama annditirteeɗo mo Magdala, mo seyɗaani'en njeɗɗon ndibbanoo iwde e mum, ");
INSERT INTO ffm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","e Yowanna jom suudu howruujo Hirudus biyeteeɗo Huja, kaɲum e Susaana e rewɓe woɓɓe heewɓe wallirannooɓe ɓe jawle mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yimɓe iwi e geelle ɗee fuu, ngari e makko. Jamaa keewɗo filii mo, o haalani ɓe ngol banndol: ");
INSERT INTO ffm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Aawoowo yalti sankoyde. E ley sankugol ngol, yoga e aawdi ndii saami e laawol, yaaɓaa, pooli ngari cuɓi ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Yoga mayri saami e korokaaƴe, fuɗi, yoori, sabi nokku oo darnataa ndiyam. ");
INSERT INTO ffm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Yoga mayri saami ɗo kebbe puɗata, kebbe ɗee cuumi ndi. ");
INSERT INTO ffm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yoga mayri saami e leydi mbelndi, fuɗi, rimi, wabbere fuu sowii cowe teemedere. Nde o haalnoo ɗum ndee, o toowni daande makko, o wii: —Jom nowru fuu yo nanu. ");
INSERT INTO ffm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Taalibaaɓe makko ɓee lamndii mo: —Koɗum ngol banndol firritata? ");
INSERT INTO ffm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","O wii ɓe: —Onon, on ndokkaama faamde goonga tedduɗo haala Laamu Laamɗo oo. Kaa woɓɓe ɓee e banndi ɓe kaalanirtee, yalla: «eɓe ƴeewa, tawa ɓe njiyataa, ɓe nana, tawa ɓe paamataa.» ");
INSERT INTO ffm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Maanaa banndol ngol annii: aawdi ndii yo konngol Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Yimɓe yogaaɓe ana nanndi e laawol. So ɓe nanii konngol ngol fuu, Ibiliisa waran itta ngol e ɓerɗe maɓɓe pati ɓe ngoonɗina, sako ɓe kisa. ");
INSERT INTO ffm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yogaaɓe ana nanndi e korokaaƴe. Ɓe nanan konngol ngol, ɓe njaɓɓoroo ngol seyo. Kaa ngol walaa ɗaɗi e maɓɓe, wakkati gooto tan ɓe ngoonɗinta. Nde soobee oo wari fuu, ɓe njoppan. ");
INSERT INTO ffm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yogaaɓe ana nanndi e nokku kebbe ɗo aawdi ndii saami ɗoo. So ɓe nanii konngol ngol tan, ɓe mbittan, sabi sugullaaji aduna e joote jawdi e giɗaaɗe yonki cuuman ngol ngol waasa ɓenndude. ");
INSERT INTO ffm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kaa ɗo aawdi ndii saami e leydi mbelndi ɗoo, ɓeen ngoni nanirooɓe konngol ngol ɓerɗe belɗe, laaɓuɗe, so kayba ngol faa ngol rima. ");
INSERT INTO ffm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Fay gooto huɓɓataa lampa so hippa hen la'al naa soorna ɗum ley leeso. Ko waɗata dee, sinndan ɗum, yalla eka yaaynana naatooɓe. ");
INSERT INTO ffm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sabi walaa fuu ko ɲooɓi ko ɓanngintaake, walaa ko suuɗii ko annditataake faa yaltinee sella. ");
INSERT INTO ffm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ndennoo, tiiɗee e no nanir-ɗon nii, sabi jogiiɗo fuu, ɓeydante. Kaa mo walaa oo, fay ko miilata ana jogii koo teetete. ");
INSERT INTO ffm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Inniiko e miɲiraaɓe makko worɓe ngari e makko, kaa ɓe keɓaali yottaade mo saabe jamaa. ");
INSERT INTO ffm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","O haalanaa inna makko e miɲiraaɓe makko ana ndarii sella ana njiɗi yiide mo. ");
INSERT INTO ffm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Nii o jaabii, o wii: —Innam e miɲiraaɓe am yo nanooɓe konngol Laamɗo ngol so ngollira ɗum ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ɲannde wootere Iisaa e taalibaaɓe mum naati laana. O wii ɓe: —Lummben weendu nduu. Ɓe ndeerti. ");
INSERT INTO ffm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","E ley lummbugol ngol, mo ɗaanii. Oon wakkati fuu, henndu mawndu immii, laana kaa heewi ndiyam, ka hosi mutude. ");
INSERT INTO ffm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ɓe ɓadii, eɓe pinndina mo eɓe mbiya: —Moobbo, Moobbo, miɗen nii kalkoo! O fini, o jahii e henndu nduu e bempeeje ɗee, non fuu wii teen! ");
INSERT INTO ffm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Caggal ɗum, o wii ɓe: —Hoto hoolaare mon woni? Ɓe kuli, ɓe cuŋli, eɓe mbiyondira e ko'e maɓɓe: —Ko oo gorko woni? Omo yamira fay henndu e ndiyam, ɗi ɗowtanto mo. ");
INSERT INTO ffm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Caggal ɗum, ɓe panndoyi leydi Gerasankooɓe, peewtondirndi e leydi Galili. ");
INSERT INTO ffm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nde o ƴeenti ndee, gorko laddaaɗo, jeyaaɗo e ngeenndi ndii, joppuɗo kaddule ko ɓooyi so tuddoyii janaale, wari e makko. ");
INSERT INTO ffm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nde o yii Iisaa ndee, o wulli, o diccii yeeso mum, o haali faa toowi, o wii: —Iisaa, Ɓii Laamɗo Toowɗo, ko njiɗ-ɗaa waɗude kam? Miɗo ɲaage, pati torram. ");
INSERT INTO ffm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Walaa ko o wiiri non, sinaa Iisaa yamirii seyɗaani oo yalta e neɗɗo oo. Oo seyɗaani ana war-wartannoo e makko cili keewɗi. Oon ana geƴƴetenoo juuɗe e koyɗe fuu, geƴƴiree calali, kaa o taƴan ɗum fuu, seyɗaani oo regina mo ngeenndi, naɓa mo ley ladde jeereende. ");
INSERT INTO ffm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Iisaa lamndii mo, wii: —Hono mbiyete-ɗaa? O jaabii: —Miɗo wiyee «Jamaa». O wii ɗum non, sabi seyɗaani'en heewɓe ana ngondi e makko. ");
INSERT INTO ffm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ɓe ndarii eɓe ndaarda Iisaa pati o yamira ɓe ɓe naatoya e iduru. ");
INSERT INTO ffm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Sewre girooji mawnde ana durannoo ɗon e hoore waamnde haayre. Seyɗaani'en ɓee ndaardi mo o duŋanoo ɗum'en naatoya e ley girooji ɗii. O duŋanii ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ɓe njalti e neɗɗo oo, ɓe naati e ley girooji ɗii. Sewre ndee fuu diiri, iwi hoore waamnde haayre too, naatoyi e ley weendu nduu, yoolii. ");
INSERT INTO ffm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nde durooɓe ɓee njii ɗum ndee, ɓe ndogi, ɓe njantanoyii ɗum yimɓe ngeenndi ndii e seraaji mum. ");
INSERT INTO ffm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ɓeen ngari ƴeewde ko waɗi koo. Nde ɓe njottii Iisaa ndee, ɓe tawi laddanooɗo oo ana jooɗii bannge makko, ana ɓoornii kaddule, yeeɗɗitii. Nii kulol nanngi ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Yiinooɓe ɗum ɓee njantanii yimɓe no laddanooɗo oo selliniraa. ");
INSERT INTO ffm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Yimɓe leydi Gerasa fuu ndaardi Iisaa yoppana ɗum'en leydi mum'en, sabi kulol manngol nanngi ɗum'en. O naati laana, o witti. ");
INSERT INTO ffm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mo seyɗaani mum ribbaa oo, ndaardi Iisaa acca o jokka e mum. Kaa Iisaa wirfintini mo, wii: ");
INSERT INTO ffm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Hootu suudu maa, kumpitaa yimɓe maa ko Laamɗo waɗan maa. O yehi, o ooynii e ngeenndi ndii fuu ko Iisaa waɗani mo koo. ");
INSERT INTO ffm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nde Iisaa wartunoo ndee, jamaa oo jaɓɓii ɗum, sabi yimɓe fuu ana ndoomunoo ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Non gorko biyeteeɗo Jayrus, hooreejo suudu waajordu, wari e makko, diccii yeeso makko, ndaardi mo o wara galle mum, ");
INSERT INTO ffm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","sabi ɓiyum debbo bajjo, mo duuɓi mum mbaarata e sappo e ɗiɗi, ana haɓana yonki. E ley yaadu Iisaa ton nduu, yimɓe ɓilli ɗum sanne. ");
INSERT INTO ffm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Debbo gooto, mo tuundi mum taƴataa ko waarata e duuɓi sappo e ɗiɗi, ana tawaa ton. Ko mo joginoo fuu mo sawrorike faa laaɓi, kaa fay gooto heɓaali sellinde mo. ");
INSERT INTO ffm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mo iwri caggal Iisaa, mo memi kommbol saaya mum. Ɗon e ɗon ƴiiƴam ɗam taƴi. ");
INSERT INTO ffm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iisaa wii: —Homo memi kam? Kaa nde wonnoo fay gooto jaabaaki, Piyeer wii: —Moobbo, hakkunde yimɓe ngon-ɗaa, eɓe ɓillu maa. ");
INSERT INTO ffm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Iisaa wii: —Won memɗo kam, sabi mi maatii won semmbe iwɗo e am. ");
INSERT INTO ffm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nde debbo oo annditinnoo ɗum suuɗataako ndee, wari ana siɲɲa, diccii yeeso makko, haali hakkunde yimɓe fuu ko saabii so memi mo e no selliri ɗon e ɗon. ");
INSERT INTO ffm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Iisaa wii mo: —Banndam debbo, goonɗinal maa danndii ma. Yaa e jam. ");
INSERT INTO ffm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iisaa tilaaki haalde, faa won iwruɗo to hooreejo suudu waajordu oo too, wii Jayrus: —Ɓiya oo heddaaki, fotaa ko tampinaa moobbo oo hankasen. ");
INSERT INTO ffm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Kaa nde wonnoo Iisaa nanii ɗum, wii hooreejo suudu waajordu oo: —Pati hul, hoolam tan, ɓiya oo daɗan. ");
INSERT INTO ffm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nde o yottii galle Jayrus ndee, o ɗalaali fay gooto naadda e makko, so wanaa Piyeer e Yuhanna e Yaakuuba e baaba suka oo e inna mum. ");
INSERT INTO ffm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yimɓe ɓee fuu ndarii ana mboya suka oo, ana conkina semmbe. O wii ɓe: —Pati mboyee! O maayaali, o ɗaaniiɗo tan. ");
INSERT INTO ffm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kaa ɓe puuytini haala makko, sabi eɓe anndi o maayii. ");
INSERT INTO ffm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Iisaa nanngi junngo suka oo, toowni daande, wii: —Suka, imma! ");
INSERT INTO ffm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yonki makko warti e makko, o immii ɗon e ɗon. Iisaa yamiri ɓe ndokka mo ko o ɲaama. ");
INSERT INTO ffm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Saaraaɓe suka oo kaaynaa. O daalii ɓe pati ɓe kaalana fay gooto ko waɗi koo. ");
INSERT INTO ffm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Iisaa noddi taalibaaɓe sappo e ɗiɗon ɓee, hokki ɗum'en semmbe, hokki ɗum'en baawɗe ribbugol seyɗaani'en e sellingol ɲawuuji. ");
INSERT INTO ffm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","O neli ɓe ɓe ooynoo Kabaaru Lobbo haala Laamu Laamɗo oo, ɓe cellina ɲawɓe. ");
INSERT INTO ffm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","O wii ɓe: —Pati naɓoree fay huunde e laawol ngol, wanaa sawru, wanaa mbasu, wanaa nguure, wanaa kaalisi. Kasen duu pati naɓoron saayaaji ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Galle mo njippi-ɗon e mum fuu, keddo-ɗon ɗon faa nde iw-ɗon ɗon. ");
INSERT INTO ffm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ngeenndi fuu ndi yimɓe mum njaɓɓaaki on, njalton ɗum, piɗɗon colla koyɗe mon, faa jeertina ɓe ko ɓe ngaɗi koo ana boni. ");
INSERT INTO ffm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ɓe mbitti, eɓe ngaɗa ngeenndi e ngeenndi, eɓe mbaajoo Kabaaru Lobbo oo, eɓe cellina ɲawɓe wonɓe e nokkuuje ɗee fuu. ");
INSERT INTO ffm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hirudus, hooreejo leydi oo, nde nannoo haala Iisaa ana haalee, hakkille mum jiiɓii. Sabi won wiyannooɓe Yaayaa mo lootogal batisima oo wuurti, ");
INSERT INTO ffm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","woɓɓe ana mbiya annabi Iliyaasa ɓanngi, woɓɓe kasen ana mbiya gooto e annabaaɓe aranndeeɓe ɓee wuurti. ");
INSERT INTO ffm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kaa Hirudus wii: —Mi taƴii hoore Yaayaa. Homo woni oo mo nanan-mi baaɗo hono nii? Omo tewta yiide ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nelaaɓe ɓee ngarti. Ɓe njantanii Iisaa ko ɓe ngaɗi koo fuu. O naɓi ɓe hedde ngeenndi mbiyeteendi Baytisayda, o teeldi e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jamaa oo nani ɗum, jokki e makko, o jaɓɓii ɓe, hedde omo haalana ɓe haala ɓanngugol Laamu Laamɗo oo, o sellini e maɓɓe hasindinɓe e sellineede ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nde hiiri ndee, sappo e ɗiɗon ɓee ɓattitii mo, mbii mo: —Yoppitin jamaa oo yaha e geelle e daakaaji piliiɗi yalla ana keɓa ɗo njippoo ɲaama, sabi oo nokku yo ladde. ");
INSERT INTO ffm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","O wii ɓe: —Onon e ko'e mon, ndokkee ɓe ko ɓe ɲaama! Ɓe mbii mo: —Buuruuje joy e liɗɗi ɗiɗi tan min njogii, naa so wanaa min coodanoyan ɓee yimɓe fuu ko ɲaama dee. ");
INSERT INTO ffm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Tawi yimɓe ɓee ana njaha e ujunaaji joy gorko. O wii taalibaaɓe makko ɓee: —Njoƴƴiniree ɓe tunaale-tunaale, wootere fuu capanɗe njoyon. ");
INSERT INTO ffm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ɓe ngaɗiri non, ɓe njoƴƴini ɓeen fuu. ");
INSERT INTO ffm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","O ɓami buuruuje joy ɗee e liɗɗi ɗiɗi ɗii, o tiggitii kammu, o yetti Laamɗo. O taƴi buuru oo e liɗɗi ɗii, o hokki taalibaaɓe makko ɓee njeɗa jamaa oo. ");
INSERT INTO ffm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ɓe fuu ɓe ɲaami faa ɓe keddi. Taalibaaɓe ɓee ndeentini taƴe keddiiɗe ɗee, kebbini cagiije sappo e ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ɲannde wootere omo teeldi e taalibaaɓe makko, omo waɗa duwaawu, kanko tan. O lamndii ɓe, o wii: —Homo yimɓe mbiyata ngon-mi? ");
INSERT INTO ffm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ɓe njaabii mo, ɓe mbii: —Won wiyooɓe a Yaayaa mo lootogal batisima, won wiyooɓe a annabi Iliyaasa, won wiyooɓe kasen gooto e annabaaɓe aranndeeɓe ɓee wuurti. ");
INSERT INTO ffm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","O lamndii ɓe: —Onon nee, homo mbiyaton ngon-mi? Piyeer jaabii mo, wii: —A Almasiihu Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","O yaggini ɓe pati ɓe kaalana ɗum fay gooto. ");
INSERT INTO ffm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","O ɓeydi hen kasen, o wii: —Ana tilsi Ɓii Neɗɗo torree torraaji keewɗi, mawɓe ɓee e hooreeɓe yottinooɓe sadaka e dunkee'en Sariya tippitoto mo, o waree, kaa mo wuurtan ɲannde tataɓere. ");
INSERT INTO ffm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Caggal ɗum, o wii ɓe fuu: —Muuyɗo jokkude kam fuu, ŋootta yurmaade hoore mum, ɓama leggal mum bardugal ɲannde fuu, jokka e am. ");
INSERT INTO ffm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sabi muuyɗo danndude yonki mum, waasan ki. Kaa baasirɗo ki sabaabu am, danndan ki. ");
INSERT INTO ffm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Koɗum heɓude aduna oo fuu nafata neɗɗo so halkii yonki mum naa mursii hoore mum? ");
INSERT INTO ffm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jaannoriiɗo kam miin e haalaaji am ɗii fuu, miin Ɓii Neɗɗo oo duu, mi yaannorto ɗum nde mi wardii e malaa'ika'en seniiɓe ley teddeengal am e ley teddeengal Baabiraaɗo am. ");
INSERT INTO ffm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Miɗo haalana on goonga: yoga e wonɓe ɗoo ɓee maayataa, tawee njiyaali Laamu Laamɗo oo ɓanngii. ");
INSERT INTO ffm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ko waarata e balɗe jetti caggal ko o haali ɗii haalaaji koo, o ŋabboyi dow waamnde haayre faa o waɗa duwaawu, o yaadi e Piyeer e Yuhanna e Yaakuuba. ");
INSERT INTO ffm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nde mo duwotoo ndee, yeeso makko waylitii, kaddule makko ndawni faa ana njalba. ");
INSERT INTO ffm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Non worɓe ɗiɗon ɓanngi, ana kaalda e makko, ɗum Muusaa e Iliyaasa. ");
INSERT INTO ffm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ɓe ɓanngidi e teddeengal, eɓe kaala haala laawol makko tabitoyoowol Urusaliima ngol. ");
INSERT INTO ffm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piyeer e wondiiɓe mum ɓee yo ɗaaninooɓe ɗoyngol teddungol, ɓe pini, ɓe njii teddeengal makko, ɓe njii worɓe ɗiɗon wonduɓe e makko ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nde yimɓe ɗiɗon ɓee ngari faa ceerta e Iisaa ndee, Piyeer wii mo: —Moobbo, gonal amen ɗoo ana moƴƴi. Ɗal min ndarna ɗoo buguuji tati: aan wooturu, Muusaa wooturu, Iliyaasa wooturu. Kanko e hoore makko, o anndaano ko o haalannoo. ");
INSERT INTO ffm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","O tilaaki haalde, faa luurde wari, suddi ɓe. Taalibaaɓe ɓee kuli sanne nde luurde ndee suddi ɓe ndee. ");
INSERT INTO ffm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Daande iwri e ley luurde ndee, wii: —Oo ɗoo yo Ɓiyam mo cuɓii-mi. Kettindee mo! ");
INSERT INTO ffm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ko daande ndee nanaa koo, Iisaa kaɲum tan gooto tawaa ton. Taalibaaɓe ɓee cuuɗi kabaaru oo. E ley ɗeen ɲalaaɗe, ɓe kaalanaali fay gooto ko ɓe njii koo. ");
INSERT INTO ffm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Janngo mum, ko ɓe njippii waamnde haayre ndee koo, higgere jamaa jaɓɓii mo. ");
INSERT INTO ffm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","E ley jamaa oo, gorko gooto eewnii, wii: —Moobbo, miɗo ɲaage, tiinna ƴeewanam ɓiyam gorko, sabi kanko tan njogii-mi. ");
INSERT INTO ffm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ladde ana nannga mo, o wulla, o siɲɲa faa hunduko makko ƴufa ngufo. Nde yoppataa mo so wanaa calɗi makko fuu taƴa. ");
INSERT INTO ffm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi ɲaagike taalibaaɓe maa ɓee ndibba nde, kaa ɓe ndonkii. ");
INSERT INTO ffm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Iisaa jaabii, wii: —Hey yimɓe jamaanu bonɗo ɓe nganaa goonɗinɓe. Faa mande tilotoo-mi e mon? Faa mande keddotoo-mi muɲande on? Ɓattin ɓiya oo ɗoo! ");
INSERT INTO ffm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nde suka oo ɓadinoo Iisaa ndee, ladde ndee liɓi ɗum e leydi, hedde ana dimmba ɗum. Nii Iisaa jahii e ladde ndee, sellini suka oo, totti ɗum baaba mum. ");
INSERT INTO ffm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Yimɓe fuu kaaynaa saabe baawɗe Laamɗo mawɗe ɗee. E ley ko jamaa oo fuu haaynaa e golleeji Iisaa ɗii koo, o wii taalibaaɓe makko ɓee: ");
INSERT INTO ffm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Onon, piɗɗee noppi mon, nanon ko kaalan-mi: Ɓii Neɗɗo oo waɗete e juuɗe yimɓe. ");
INSERT INTO ffm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kaa ɓe paamaali haala kaa, maanaa makka ana suuɗanii ɓe, faa ɓe mbaasi annditinde ka. Ɓe kulii lamnditaade mo duu. ");
INSERT INTO ffm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Non taalibaaɓe ɓee ndarii ana njeddondira ɓurɗo teddude hakkunde mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Nde wonnoo omo anndi ko woni e ɓerɗe maɓɓe, o nanngi junngo cukalel, o darni ngel bannge makko, ");
INSERT INTO ffm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","o wii ɓe: —Neɗɗo fuu jaɓɓiiɗo ngel cukalel e innde am, miin jaati o jaɓɓii. Kasen duu, jaɓɓiiɗo kam, jaɓɓike nelɗo kam oo. Sabi ɓurɗo lo'ude hakkunde mon fuu, kaɲum woni tedduɗo. ");
INSERT INTO ffm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yuhanna haali, wii: —Moobbo, min njii gorko gooto ana ribbira seyɗaani'en innde maa, min kaɗii mo, sabi o waldaa e men. ");
INSERT INTO ffm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Iisaa wii mo: —Pati kaɗee mo ɗum, sabi mo honnaaki on fuu, e mon wondi. ");
INSERT INTO ffm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nde wakkati mo Laamɗo ŋabbintinta Iisaa dow kammu ɓadinoo, Iisaa e hoore mum fellisi yahan Urusaliima, ");
INSERT INTO ffm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","neli nelaaɓe ardoo ɗum. Ɓeen nelaaɓe naati e ngeenndi Samariyankooɓe ngootiri faa ndaartana mo jippunde. ");
INSERT INTO ffm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kaa ndiin ngeenndi jaɓɓaaki mo, sabi Urusaliima o fa'i. ");
INSERT INTO ffm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nde Yaakuuba e Yuhanna njiinoo ɗum ndee, mbii: —Kalfaaɗo, aɗa yiɗi min njamira yiite iwa dow kammu duppa ɓe naa? ");
INSERT INTO ffm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Nii o yeeccitii ɓe, o ɲiŋi ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Caggal mum, ɓe njehi ngeenndi ngonndi. ");
INSERT INTO ffm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","E ley yaadu maɓɓe nduu, neɗɗo gooto wii mo: —Mi jokkete to njahataa fuu. ");
INSERT INTO ffm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Iisaa wii mo: —Doldolɗe ana njogii gayɗe, pooli duu ana njogii cuuɗi, kaa Ɓii Neɗɗo oo walaa fay ɗo soppinoo sako faa lelna hoore mum fowtinoo. ");
INSERT INTO ffm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","O wii neɗɗo goɗɗo: —Jokkam! Oon jaabii mo, wii: —Accu mi iroya baabam tafon. ");
INSERT INTO ffm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Iisaa wii mo: —Ɗal maayɓe ira maayɓe mum'en. Aan kaa, waajoya haala Laamu Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Goɗɗo kasen wii mo: —Mi jokkan e maa, Moobbo, kaa accu mi waynoyoo galle am tafon. ");
INSERT INTO ffm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Iisaa jaabii mo, wii: —Neɗɗo fuu nannguɗo jalo sari nde yeeƴii, walaa ko nafata e Laamu Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Caggal ɗum, Iisaa suɓii e ley taalibaaɓe mum capanɗe njeɗɗon e ɗiɗon, neliri ɓe ɗiɗon ɗiɗon, ɓe ardoo ɗum e ngeenndi fuu e nokku fuu ɗo o haannoo yaade, kanko e hoore makko. ");
INSERT INTO ffm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","O wii ɓe: —Gese ɓennduɗe ana keewi, kaa hettooɓe keewaa. Ndennoo, ɲaagee Jom kettal oo nelda hettooɓe to hettantee too. ");
INSERT INTO ffm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Njehee, mi nelii on no baali hakkunde pobbi nii. ");
INSERT INTO ffm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pati naɓoree fay huunde, wanaa dannga, wanaa mbasu, wanaa paɗe. Pati njowtee fay gooto e dow laawol. ");
INSERT INTO ffm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Galle mo naataton fuu, njowton joomum'en tafon, mbiyon: «Yo jam wonu e oo galle!» ");
INSERT INTO ffm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","So neɗɗo jom jam won ɗon, duwaawu mon hewtan ɗum. Kaa so walaa, duwaawu mon oo wartan e mon. ");
INSERT INTO ffm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Njippo-ɗon e oon galle. Ko ɓe ndokki on fuu ɲaamon, njaron, sabi golloowo ana haandi e njoɓdi mum. Pati ngaɗee naata-yalta e ley galleeji. ");
INSERT INTO ffm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ngeenndi fuu ndi naatu-ɗon, so on njaɓɓaama, ko ngaddane-ɗon fuu ɲaamon. ");
INSERT INTO ffm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Cellinon ɲawɓe ɓe taw-ɗon ɗon fuu, mbiyon yimɓe ngeenndi ndii: «Laamu Laamɗo ɓattiima on.» ");
INSERT INTO ffm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ngeenndi fuu ndi naatu-ɗon, so on njaɓɓaaka e mum, njalton e mbeddaaji mum, mbiyon: ");
INSERT INTO ffm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","«Min piɗɗii e mon fay colla ngeenndi mon takkinooka e koyɗe amen. Kaa ɗum e taweede, anndee Laamu Laamɗo ɓattiima.» ");
INSERT INTO ffm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Miɗo haalana on: ɲannde darngal, jukkungo ndiin ngeenndi ɓuran ngo Sodooma ngoo naawde. ");
INSERT INTO ffm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Bone woodanii ma, aan Korasin! Bone woodanii ma, aan Baytisayda! Sabi so kaayɗe gaɗanooɗe e ley mon ɗee ngaɗanooma Tirus e Sidon, nden, hoɗuɓe ton ɓee tuubanno law, tawete ɓe ɓoornike licce caakuuji, ɓe njooɗike e ndoondi, faa ɓe kollita tuubugol maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Saabe ɗum, ɲannde darngal, jukkungo mon ɓuran ngo Tirus e Sidon ngoo naawde. ");
INSERT INTO ffm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Aan duu Kafarnahum, aɗa miila a toownete faa dow kammu naa? A leyɗinte faa keedaa ley maayɓe. ");
INSERT INTO ffm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","O haalani taalibaaɓe makko kasen: —Kettindaniiɗo on fuu, miin hettindanii. Calaniiɗo on fuu, miin salanii. Calaniiɗo kam fuu, salanike nelɗo kam oo duu. ");
INSERT INTO ffm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Capanɗe njeɗɗon e ɗiɗon ɓee ngartidi e seyo, mbii: —Kalfaaɗo, fay seyɗaani'en ɓee ɗowtanike min saabe innde maa. ");
INSERT INTO ffm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","O wii ɓe: —Mi yii Ibiliisa ana iwa dow kammu, ana saamira no suraango nii. ");
INSERT INTO ffm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mi hokkii on baawɗe yaaɓude bolle e jahe, mi hokkii on jaalaade konnee fuu. Fay huunde torrataa on abada. ");
INSERT INTO ffm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kaa noo, pati ceyoree ko seyɗaani'en ɗowtanii on koo. Ceyoree ko inɗe mon mbinndaa dow kammu koo. ");
INSERT INTO ffm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Oon wakkati fuu, Ruuhu Ceniiɗo hebbini Iisaa seyo. Iisaa wii: —Baabiraaɗo jom kammu e leydi, mi yettii ma, sabi a suuɗii ɗee kulle hakkilanteeɓe e annduɓe, ɓannginan-ɗaa ɗum cukaloy. Jaati, Baabiraaɗo, hono non worri, sabi ɗum wel maa. ");
INSERT INTO ffm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Baabiraaɗo am tummbii huunde fuu e junngo am. Fay gooto anndaa Bajjo oo so wanaa Baabiraaɗo, fay gooto anndaa Baabiraaɗo oo so wanaa Bajjo oo, kaɲum e mo Bajjo oo muuyi ɓannginande ɗum fuu. ");
INSERT INTO ffm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Caggal ɗum, Iisaa yeeccitii taalibaaɓe ɓee, gunndii ɗum'en, wii: —Gite jiyooje ko njiyaton koo, mbelii hoore! ");
INSERT INTO ffm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sabi miɗo wiya on: annabaaɓe heewɓe e kaanankooɓe heewɓe njiɗiino yiide ko njiyaton koo, njiyaali, njiɗiino nande ko nanaton koo, nanaali. ");
INSERT INTO ffm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Non, jannginoowo Sariya gooto immii faa hora mo, wii: —Moobbo, hono kaan-mi waɗude faa mi heɓa nguurndam nduumiiɗam? ");
INSERT INTO ffm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Iisaa jaabii mo, wii: —Koɗum winndii e Sariya? Koɗum njanngu-ɗaa ton? ");
INSERT INTO ffm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jannginoowo Sariya oo jaabii, wii: —Yiɗir Laamɗo Joomiraaɗo maa ɓernde maa fuu e yonki maa fuu e semmbe maa fuu e hakkille maa fuu. Njiɗiraa tanaa maa no njiɗir-ɗaa hoore maa nii. ");
INSERT INTO ffm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Iisaa wii mo: —Jaabu maa moƴƴii. So a waɗii non, a heɓan nguurndam ɗam! ");
INSERT INTO ffm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kaa jannginoowo Sariya oo ana yiɗi heedude e goonga, wii mo: —Homo woni tanaa am? ");
INSERT INTO ffm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Iisaa jaabii mo, wii: —Ɲannde wootere gorko gooto iwi Urusaliima, ana fa'i Yeriko. E ley yaadu makko nduu, o hawri e yanooɓe, ɓe ɓoli mo, ɓe pii mo faa ɓe njoppi mo wanaa guurɗo mo wanaa maayɗo. ");
INSERT INTO ffm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Forri e jottinoowo sadaka gooto ana warannoo e laawol ngol. Nde o yiinoo janaaɗo oo ana lelii ndee, o woorti ɗum, o ƴaɓɓii. ");
INSERT INTO ffm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Lewinke gooto, kaɲum duu wari tawi mo ɗon, yii mo, woorti mo, ƴaɓɓii. ");
INSERT INTO ffm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Samariyanke dawɗo wari e makko, yii mo, yurminaa, ");
INSERT INTO ffm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ɓadii mo, sawriri barme makko nebam e peguujam, fiili hen licce. Caggal ɗum, o waɗɗini ɗum daaba makko, o naɓi ɗum e jippunde hoɓɓe, o hinnii ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Janngo mum, o itti buuɗi cardi ɗiɗi, o hokki njaatigi mum oo, o wii ɗum: «Hinna mo. So almusaɗɗa makko ɓurii ɗum, so mi wartii, mi tottete.» ");
INSERT INTO ffm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nde Iisaa tilii banndol ngol ndee, wii: —E miilo maa, homo e taton ɓee laatii tanaa janaaɗo oo? ");
INSERT INTO ffm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jannginoowo Sariya oo jaabii, wii: —Jurmiiɗo mo oo. Iisaa wii mo: —Aan duu, yaa, waɗoy hono non! ");
INSERT INTO ffm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","E laawol maɓɓe ngol, Iisaa faŋi ngeenndi ngootiri, debbo biyeteeɗo Marta jippini mo. ");
INSERT INTO ffm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta ana jogii miɲiraaɗo biyeteeɗo Mariyama. Oon ana jooɗii sera koyɗe Iisaa, ana nana haala mum. ");
INSERT INTO ffm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kaa Marta, no golleeji ɗii keewiri nii tan woni e hakkille mum, wari, wii: —Moobbo, a hillaaka ko miɲam oo ɗaldi kam golle oo koo naa? Wii mo o immoo, o walla kam! ");
INSERT INTO ffm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Moobbo oo jaabii mo, wii: —Marta, Marta, aɗa tampina hoore maa kulle keewɗe, aɗa jiiɓa hakkille maa. ");
INSERT INTO ffm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kaa huunde wootere tan woni ko neɗɗo hasindini e mum. Mariyama suɓike ko moƴƴi koo, o teetataake ɗum duu. ");
INSERT INTO ffm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ɲannde wootere, Iisaa ana waɗa duwaawu e nokku gooto. Nde o tilinoo ndee, gooto e taalibaaɓe makko ɓee wii mo: —Moobbo, janngin min no min nduwortoo, hono no Yaayaa jannginiri taalibaaɓe mum nii. ");
INSERT INTO ffm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","O wii ɓe: —So oɗon nduwoo, nii mbiyaton: Baabiraaɗo, yo innde maa teddine. Yo Laamu maa war. ");
INSERT INTO ffm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Hokku min ɲannde fuu ɲaamdu heƴooru min. ");
INSERT INTO ffm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Yaafa min luutti amen, sabi miɗen njaafoo tooɲuɓe min fuu. Pati accu min ceytee. ");
INSERT INTO ffm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","O wii ɓe kasen: —So gooto mon yehii to giɗo mum hejjere jemma, wii ɗum: «Giɗam, ɲamlam buuruuje tati, ");
INSERT INTO ffm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","mi heɓii koɗo jooni, mi walaa ko mi holla ɗum», ");
INSERT INTO ffm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","yalla giɗo maa oo ana jaabe to ley galle too, wiye: «Pati torram, sabi damal ngal cokaangal, sukaaɓe am duu yo leliiɓe, mi waawaa immaade faa mi hokke fay huunde»? ");
INSERT INTO ffm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Miɗo wiya on: fay so o immaaki o hokkire saabe a giɗo makko, waajibi mo immoo, mo hokke hakke ko kasindin-ɗaa e mum fuu, kammari ko tekkin-ɗaa ɲaagunde maa ndee koo. ");
INSERT INTO ffm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Miin, miɗo wiya on: ɲaagee, on keɓan, tewtee, on njiitan, calminee gila oɗon damal galle, on udditante. ");
INSERT INTO ffm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sabi ɲaagiiɗo fuu, heɓan, tewtuɗo fuu, yiitan, calminɗo fuu, udditante. ");
INSERT INTO ffm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Homo woni e mon baabiraaɗo mo ɓiyum ɲaagotoo liingu so hokka ɗum mboddi? ");
INSERT INTO ffm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Naa ɲaagoo ɗum ɓoccoonde, hokka ɗum yaare? ");
INSERT INTO ffm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","No mbonir-ɗon fuu, oɗon ndokka ɓiɓɓe mon kulle lobbe, sako Baabiraaɗo mon gonɗo dow kammu oo. Ɲaagiiɗo mo Ruuhu Ceniiɗo fuu, o hokkan ɗum mo. ");
INSERT INTO ffm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ɲannde wootere, Iisaa ana ribbana neɗɗo gooto seyɗaani muumɗinnooɗo ɗum. Nde seyɗaani oo yalti ndee, muumɗunooɗo oo watti haalde. Jamaa oo haaynaa. ");
INSERT INTO ffm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kaa yoga e maɓɓe ana wiya: —«Beelsebul», hooreejo seyɗaani'en oo o ribbirta seyɗaani'en ɓee! ");
INSERT INTO ffm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Woɓɓe ndaardi mo taagumansa kaayniiɗo iwoowo dow kammu faa itta koro makko. ");
INSERT INTO ffm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Nde wonnoo omo anndi miilooji maɓɓe, o wii ɓe: —Laamu fuu pecciiɗo ana haɓa e hoore mum, bonan, maadiiji mum fuu ngurjan e leydi. ");
INSERT INTO ffm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","So Ibiliisa e hoore mum fecciima, hono laamu mum heddortoo? Nde wonnoo on mbii «Beelsebul» ndibbiran-mi seyɗaani'en ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","So tawii «Beelsebul» ndibbiran-mi seyɗaani'en, yimɓe mon ɓee nee, homo ndibbirta ɓe? Yimɓe mon ɓee jaati kollata on ngalaa e goonga! ");
INSERT INTO ffm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Kaa so baawɗe Laamɗo ndibbiran-mi seyɗaani'en, ɗum ana holla Laamu Laamɗo warii e mon. ");
INSERT INTO ffm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Gorko jom semmbe jogiiɗo kaafaawi, so haybii galle mum, jawdi mum reenoto. ");
INSERT INTO ffm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kaa so ɓurɗo ɗum semmbe yanii e mum, jaalike ɗum, teetan joomum kaafaawi ki fawnoo hoolaare e mum kii, fecca jawdi mum ndii e woɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mo waldaa e am fuu yo gaɲo am. Mo mooɓtidataa e am fuu yo caakoowo. ");
INSERT INTO ffm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","So seyɗaani yaltii e neɗɗo, seyɗaani oo yiiloyto e nokkuuje joorɗe, tewta ɗo ŋoottinoo. So mo heɓaali, mo wiyan: «Miɗo nii wirfitoo galle am mo eggunoo-mi e mum oo.» ");
INSERT INTO ffm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","So mo wirfitike, mo tawan galle oo ana wuuwaa, ana moƴƴinaa ana paraa faa wooɗi. ");
INSERT INTO ffm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nden, mo wirfitoo, mo waddoya seyɗaani'en njeɗɗon ɓurɓe mo bonde, ɓe naata e galle oo, ɓe koɗa e mum. Nii battane oo neɗɗo ɓurdata arannde mum bonde. ");
INSERT INTO ffm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nde o haalata ɗum ndee, debbo gooto ana hakkunde jamaa oo, toowni daande mum, wii: —Debbo caawɗo ma so muynin maa, welii hoore! ");
INSERT INTO ffm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Non Iisaa jaabii, wii: —Welɓe hoore dee, nanooɓe konngol Laamɗo so njokka ngol ɓee! ");
INSERT INTO ffm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nde wonnoo jamaa oo ana ɓillondira e makko sanne, o fuɗɗi wiide: —Yimɓe jamaanu jooni yo yimɓe bonɓe. Eɓe ndaara holleede taagumansa, kaa ɓe kollataake so wanaa taagumansa annabi Yuunusa oo. ");
INSERT INTO ffm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Sabi no Yuunusa laatanorii Niniwenkooɓe taagumansa nii, hono non Ɓii Neɗɗo oo duu laatanortoo yimɓe oo jamaanu taagumansa. ");
INSERT INTO ffm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ɲannde darngal, kaananke debbo leydi ɓaleeri oo immodoto e yimɓe jamaanu jooni ɓee, liɓa ɗum'en. Sabi o iwriino faa hoore leydi, warde hettindaade haalaaji Suleymaana kebbinaaɗi hakkilantaaku ɗii. Haya, ɓurɗo Suleymaana won ɗoo! ");
INSERT INTO ffm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ɲannde darngal, yimɓe Niniwe duu immodoto e yimɓe jamaanu jooni ɓee, liɓa ɗum'en. Sabi ɓe tuubii gila nde ɓe nannoo waaju annabi Yuunusa ndee. Haya, ɓurɗo Yuunusa won ɗoo! ");
INSERT INTO ffm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Iisaa wii kasen: —Fay gooto huɓɓataa lampa so suuɗa ɗum naa hippa e mum kaakol. So lampa huɓɓaama, sinndete, yalla ana yaaynana naatooɓe. ");
INSERT INTO ffm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gite maa ngoni lampa calɗi maa. So gite maa ana moƴƴi, calɗi maa fuu pooynan. Kaa so ɗe moƴƴaa, calɗi maa fuu niɓɓan. ");
INSERT INTO ffm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ndennoo, haybu pati fooyre wonnde e maa ndee niɓɓa. ");
INSERT INTO ffm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Sabi so calɗi maa fuu keewii fooyre, tawa walaa fuu salndu maa wonndu e nimre, ɗi fuu ɗi pooyniran no lampa fooynirante nii. ");
INSERT INTO ffm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","E ley ko Iisaa waajotoo koo, Farisanke gooto noddi ɗum bottaari. O nootoyii ɗum galle mum, o jooɗii faa o ɲaama. ");
INSERT INTO ffm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisanke oo haaynaa nde yiinoo o lootaali juuɗe fade makko ɲaamde. ");
INSERT INTO ffm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","E ley ɗum, Iisaa wii mo: —Onon Farisa'en, oɗon lawƴa caggal kore looɗe e caggal lehoy, tawee nee, ɓerɗe mon ana caawi nguykaaji e boneeji! ");
INSERT INTO ffm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Jaahili'en! Tama wanaa Taguɗo dow oo tagi ley oo duu? ");
INSERT INTO ffm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ittiree sadakaaji mon ɗii ɓerɗe laaɓuɗe. Nden, ko heddii koo fuu daganto on. ");
INSERT INTO ffm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bone yanan e mon, onon Farisa'en. Sabi oɗon ittana Laamɗo jakka naanaa, oɗon ittana ɗum jakka danndi e ko tutaton fuu. Kaa oɗon njeebii fooccitaare, oɗon njeebii yiɗude Laamɗo. Tawee nee, kaɲum kaanno-ɗon waɗude tawee on njeebaaki ko heddii koo. ");
INSERT INTO ffm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Bone yanan e mon, onon Farisa'en! Sabi oɗon njiɗi joolle lobbe e ley cuuɗi baajorɗi, oɗon njiɗi salmineede calminaali teddungal e luumooji. ");
INSERT INTO ffm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bone yanan e mon. Sabi oɗon nanndi e janaale ɗe ngalaa maande, ɗe yimɓe njahata e mum, tawee anndaa. ");
INSERT INTO ffm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Gooto e jannginooɓe Sariya jaabii Iisaa, wii: —Moobbo, no kaalirtaa nii, aɗa hoyna min minen duu. ");
INSERT INTO ffm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Iisaa jaabii, wii: —Onon jannginooɓe Sariya ɓee duu, bone yanan e mon! Sabi oɗon ndonndina yimɓe donnge tedduɗe, tawee onon e ko'e mon, on memirtaa ɗe fay hoore feɗeendu mon. ");
INSERT INTO ffm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Bone yanan e mon, sabi oɗon maha janaale annabaaɓe ɓe njaatiraaɓe mon mbari ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ndennoo, onon, on ceettiima golle maɓɓe oo ana weli on. Sabi kamɓe, ɓe mbarii annabaaɓe, onon, oɗon maha janaale mum'en! ");
INSERT INTO ffm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ɗum nee, Laamɗo hakkilante oo wii: «Mi neldan ɓe annabaaɓe e nelaaɓe, ɓe mbara yoga, ɓe torra yoga.» ");
INSERT INTO ffm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ɗum waɗi so ƴiiƴam annabaaɓe njuppaaɗam gila e puɗɗooɗe aduna oo ɗam, ana yoɓtee e yimɓe oo jamaanu. ");
INSERT INTO ffm_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","So goonga dee, miɗo wiya on: ƴiiƴam gila Haabiila faa Jakariyaa baraaɗo hakkunde ittirde sadaka ndee e suudu Laamɗo nduu, ɗum fuu ɗum yoɓete e oo jamaanu. ");
INSERT INTO ffm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Bone yanan e mon, onon jannginooɓe Sariya! Sabi on teetii cokitirgal anndal, on naataali onon e ko'e mon, kasen duu on kaɗii naatooɓe ɓee naatude. ");
INSERT INTO ffm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nde Iisaa iwi ɗon ndee, dunkee'en Sariya e Farisa'en ana mettaa e mum sanne sanne. Ana lamndoo mo kulle keewɗe, ");
INSERT INTO ffm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","hedde eɓe tuufana mo faa ɓe keɓa e makko haala ka ɓe nannginira mo. ");
INSERT INTO ffm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ko foti ujunaaji ujunaaji yimɓe kawriti faa ana njaaɓondira. Nden Iisaa wii taalibaaɓe mum ɓee: —Ndeentee e ƴuufinirdi Farisa'en, ɗum woni ɓe naafigi'en. ");
INSERT INTO ffm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Walaa fuu ko suuɗii ko ɓanngintaake, walaa sirri mo saakataake. ");
INSERT INTO ffm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ɗum saabii huunde fuu ko kaal-ɗon ley nimre nantete ley fooyre. Kasen duu ko ngunndi-ɗon ley cuuɗi fuu, ooynete dow beneeji. ");
INSERT INTO ffm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Miɗo haalana on, onon giɗiraaɓe am: pati kulee warooɓe yimɓe ɓe ngalaa fuu ko mbaawi caggal majjum ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mi hollan on mo kaan-ɗon hulde: kulee baroowo neɗɗo baawɗo tippaade ɗum ley jahannama. So goonga dee, miɗo wiya on: oon kaan-ɗon hulde! ");
INSERT INTO ffm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Tama biiwuuji joy coottataake buuɗi ɗiɗi? Laamɗo yeggitataa fay gootel e majji. ");
INSERT INTO ffm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Onon, fay leeɓi ko'e mon fuu ko limaa faa laaɓi. Ndennoo, pati kulee, sabi onon ɓuri biiwuuji keewɗi teentilaade. ");
INSERT INTO ffm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Miɗo wiya on: ceettaniiɗo kam hakkunde yimɓe fuu, miin Ɓii Neɗɗo oo duu, mi seettanto ɗum yeeso malaa'ika'en Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kaa calaniiɗo kam hakkunde yimɓe, salante yeeso malaa'ika'en Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Neɗɗo fuu kaalɗo ko boni e Ɓii Neɗɗo, ana waawi yaafeede. Kaa bonkiiɗo Ruuhu Ceniiɗo oo yaafataake. ");
INSERT INTO ffm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","So on naɓaama e cuuɗi baajorɗi naa yeeso hooreeɓe naa kaanankooɓe, pati mbemmbe-ɗon ko njaaboto-ɗon, naa ko kaalaton, ");
INSERT INTO ffm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","sabi Ruuhu Ceniiɗo oo anndinan on oon wakkati fuu ko kaan-ɗon haalde. ");
INSERT INTO ffm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Won biiɗo e ley jamaa oo: —Moobbo, wii mawnam oo hokka kam ngeɗu am e ndonu amen oo. ");
INSERT INTO ffm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Iisaa jaabii mo, wii: —Hey aan! Homo waɗi kam caroowo mon naa peccoowo jawdi mon? ");
INSERT INTO ffm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","O wii jamaa oo: —Ndeentee e joote, sabi wanaa jawdi wuurnata neɗɗo fay so tawaa mo arsukunte. ");
INSERT INTO ffm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","O haalani ɓe banndol, o wii: —Arsukunte gooto, gese mum moƴƴunoo faa sanne. ");
INSERT INTO ffm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","O miilii e hoore makko: «Hono ngaɗan-mi? Sabi mi walaa fuu ɗo mi mooɓta ɲamri am ndii. ");
INSERT INTO ffm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Eyyoo! Mi wurjinan beembe am ɗee, mi maha goɗɗe ɓurɗe ɗe manngu, mi mooɓta hen ɲamri am ndii e ngalu am fuu, ");
INSERT INTO ffm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","mi wiya hoore am: A heɓii ngalu baawɗo jogaade ma duuɓi kuurɗi, hankasen fowtu, ɲaamaa, njaraa, mbelto-ɗaa.» ");
INSERT INTO ffm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kaa Laamɗo wii mo: «Pamaro hakkille! Yonki maa ittete e oo ɗoo jemma. Homo heettata e ko paggiti-ɗaa koo?» ");
INSERT INTO ffm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nii woni sifa neɗɗo fuu paggitaniiɗo hoore mum jawdi aduna, wanaa galo yeeso Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Caggal ɗum, o wii taalibaaɓe makko ɓee: —Ɗum saabii so miɗo wiya on: pati cuŋlanee e ley nguurndam mon ko ɲaamaton e ko ɓoornoto-ɗon. ");
INSERT INTO ffm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sabi nguurndam ɓuri nguure, terɗe ɓuri koltal. ");
INSERT INTO ffm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ƴeewee daawle ɗee: ɗe aawataa, ɗe kettataa, ɗe ngalaa caakuuji, ɗe ngalaa beembe, kaa Laamɗo ana ɲammina ɗe. Onon, oɗon ɓuri pooli ɗii teentilaade ɗo woɗɗi! ");
INSERT INTO ffm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Homo e mon waawi ɓeydude e balɗe mum fay ɲalooma gooto kammari sugulla mum? Walaa. ");
INSERT INTO ffm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ndennoo, so tawii on mbaawaa waɗude fey hono ɗum e famɗude, ko saabii so oɗon cuŋlana ko heddii koo? ");
INSERT INTO ffm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ƴeewee piindiiji no peertirta. Ɗi tampataa, ɗi mottataa. Haya miɗo wiya on: Suleymaana e ngalu mum fuu paroraaki no gootel e majji nii. ");
INSERT INTO ffm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Laamɗo ana holtina leggiri taweteendi ley ngesa hannde, tippeteendi e yiite janngo, sako onon, onon famɗuɓe hoolaare! ");
INSERT INTO ffm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pati kiinnee ndaartude ɲaamdu e yardu, pati mbemmbe-ɗon! ");
INSERT INTO ffm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sabi ɗee kulle fuu yimɓe aduna tan ndaarata ɗum. Kaa Baabiraaɗo mon ana anndi oɗon kasindini e majjum. ");
INSERT INTO ffm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ko kaan-ɗon waɗude dee, ndaartee Laamu Laamɗo. Ko heddii koo, on ɓeydante ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Pati kulee, onon sewre famarde, sabi Baabiraaɗo mon ana seyorii hokkude on Laamu oo. ");
INSERT INTO ffm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Coottee jawdi mon fuu, cakko-ɗon. Moƴƴinanee ko'e mon danngaaji ɗi mbonataa, njogo-ɗon jawdi ngonndi dow kammu ndi timmataa, ndi gujjo ɓadataako, mooƴu duu bonnataa. ");
INSERT INTO ffm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sabi ɗo jawdi maa woni fuu, ɗon yonki maa duu woni. ");
INSERT INTO ffm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—Kumee, kuɓɓee lampaaji mon. ");
INSERT INTO ffm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Laatee hono yimɓe lanndinaniiɓe jaɓɓaade kalfaaɗo mum'en nde wartata kuurtungu, faa udditana ɗum ɗon e ɗon so salminii. ");
INSERT INTO ffm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kaadime'en ɓe kalfaaɗo mum'en tawi ɗaanaaki, mbelii hoore. Miɗo haalana on goonga: o humoto, o joƴƴina ɓe faa ɓe ɲaama, o wara o gollana ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","So o wartirii ɗiɗaɓere jemma naa so tataɓere jemma, ɓe o tawri non ɓee, mbelii hoore. ");
INSERT INTO ffm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Paamee ɗum ɗoo: sinndo jom galle ana anndunoo wakkati mo gujjo warata, yoppataa o naata galle mum. ");
INSERT INTO ffm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Onon duu, lanndinee, sabi Ɓii Neɗɗo oo waran e wakkati mo on miilaali. ");
INSERT INTO ffm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Piyeer wii mo: —Kalfaaɗo, ngol banndol, minen tan kaaldu-ɗaa naa yimɓe fuu? ");
INSERT INTO ffm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Iisaa jaabii, wii: —Homo woni golloowo koolniiɗo, hakkilante, mo kalfaaɗo mum halfinta maccuɓe mum hokka ɗum'en nguure mum'en? ");
INSERT INTO ffm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Oon golloowo mo kalfaaɗo mum warti so tawi ana golla golle mo halfinaa oo, welii hoore. ");
INSERT INTO ffm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Miɗo haalana on goonga: kalfaaɗo oo halfinan mo jawdi mum fuu. ");
INSERT INTO ffm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kaa so golloowo oo wii e hoore mum kalfaaɗo mum oo ɓooyii wartaali, hedde ana fiya maccuɓe e horɓe, ana ɲaama ana yara ana sigira, ");
INSERT INTO ffm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","nden, kalfaaɗo oo wartiran ɲalooma mo golloowo oo anndaa e wakkati mo o miilaali, jukka mo jukkungo naawngo, watta mo hakkunde ɓe nganaa hoolniiɓe. ");
INSERT INTO ffm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Golloowo annduɗo ko kalfaaɗo mum yiɗi, mo lanndinaaki fay huunde, mo gollaali ko kalfaaɗo mum yiɗi, fiyete ɓoggi keewɗi. ");
INSERT INTO ffm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kaa golloowo mo anndaa ko kalfaaɗo mum yiɗi, so waɗii ko fiyata ɗum, fiyete ɓoggi seeɗa. Dokkaaɗo ko heewi, lamndete ko heewi. Kalfinaaɗo ko heewi, lamndete ko ɓuri heewde. ");
INSERT INTO ffm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Mi wardii wedaade yiite e leydi ndii. Miɗo heppi nge huɓɓaali! ");
INSERT INTO ffm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Won lootogal batisima naawngal ngal lootetee-mi. Miɗo heppi ɗum waɗaali. ");
INSERT INTO ffm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Oɗon miila jam ngardu-mi e leydi ndii naa? Wanaa! Miɗo wiya on: seenndude yimɓe ngardu-mi. ");
INSERT INTO ffm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gila jooni yimɓe njoyon ley galle gooto ceeran, taton ɓee kaɓa e ɗiɗon ɓee, ɗiɗon ɓee kaɓa e taton ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Baabiraaɗo haɓan e ɓiyum gorko, ɓiɗɗo gorko haɓan e baaba mum, inniraaɗo haɓan e ɓiyum debbo, ɓiɗɗo debbo haɓan e inna mum, debbo ɓamaaɗo haɓan e esum debbo. ");
INSERT INTO ffm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iisaa wii jamaa oo kasen: —So on njii luurde ana iwra hiirnaange tan, on mbiyan nde toɓan. Laatorto hono non duu. ");
INSERT INTO ffm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","So henndu ɓaleeri wibbii, on mbiyan wulan taw. Hono non laatortoo duu. ");
INSERT INTO ffm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Onon naafigi'en! Oɗon mbaawi seenndude mbaadi leydi e kammu, ko waɗi so on mbaawaa seenndude mbaadi oo ɗoo jamaanu? ");
INSERT INTO ffm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ko saabii so on mbaawaa anndande ko'e mon ko woni fooccitaare? ");
INSERT INTO ffm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","So aɗa yaada e mo kaɓu-ɗaa faa cardoyon, ndaartu rewritinde e makko gila e laawol, pati o naɓe to caroowo, so caroowo oo hokke kayboowo kasu, kayboowo kasu oo duu udde. ");
INSERT INTO ffm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Miɗo haalane: abada a yaltataa, so a yoɓaali ko ndewete-ɗaa koo faa laaɓa. ");
INSERT INTO ffm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","E oon wakkati, won warɓe so kumpiti Iisaa ko hewtii Galilinkooɓe yogaaɓe. Ɓe mbii Pilaatu jillondiriino ƴiiƴam maɓɓe e ƴiiƴam sadakaaji maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Iisaa jaabii ɓe, wii: —Oɗon miila ɓee Galilinkooɓe torraaɓe ɓuri luuttude diina Galilinkooɓe heddiiɓe ɓee naa? ");
INSERT INTO ffm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Miɗo haalana on: wanaa non. Kaa so on tuubaali, on fuu hono non kalkorto-ɗon. ");
INSERT INTO ffm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Naa oɗon miccitoo sappo e njetton ɓe suudu Silowam toowndu nduu saami e mum'en faa maayi ɓee? Oɗon miila kamɓe ɓuri Urusaliima fuu junuubu naa? ");
INSERT INTO ffm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Miɗo haalana on: wanaa non. Kaa so on tuubaali, on fuu hono non kalkorto-ɗon. ");
INSERT INTO ffm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Caggal ɗum, o waɗani ɓe ngol banndol: —Neɗɗo gooto tutiino ibbi ley ngesa mum. O wari teɓude ki, kaa o tawaali e makki fay huunde. ");
INSERT INTO ffm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Non o wii golloowo ngesa oo: «Hikka woni duuɓi tati, hitaande fuu mi waran faa mi teɓa ki, mi tawa ki rimaali. Feƴƴu ki! So walaa ko ki nafata, ko saabii so eki itta semmbe leydi ndii?» ");
INSERT INTO ffm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Golloowo oo wii mo: «Kalfaaɗo, yoppu ki ɗoo faa mawuuri. Ɗoo e nden, mi gaawtoto foomre makki, mi waɗa hen birgi. ");
INSERT INTO ffm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ana moƴƴa ki rima ɗoo e mawuuri. So ki rimaali, peƴƴaa ki.» ");
INSERT INTO ffm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Waɗiino e ɲalaande fowteteende wootere, Iisaa ana darii ana waajoo ley suudu waajordu wooturu. ");
INSERT INTO ffm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Debbo gooto mo ladde ɲawni duuɓi sappo e jetti ana tawaa ɗon. O turiiɗo tan, o waawaa dartaade fey. ");
INSERT INTO ffm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Nde Iisaa yiinoo mo ndee, noddi mo, wii mo: —Banndam debbo, a daɗii e ɲaw maa oo. ");
INSERT INTO ffm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Iisaa fawi juuɗe mum dow makko, non o dartii cot! Hedde omo yetta Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jaka hooreejo suudu waajordu oo mettaama ko Iisaa sellini neɗɗo ley ɲalaande fowteteende koo, wii yimɓe ɓee: —Balɗe jeegom kaanɗe golleede ana ngoodi. E ɗeen balɗe kaan-ɗon warde sellineede, wanaa e ɲalaande fowteteende. ");
INSERT INTO ffm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Iisaa jaabii mo, wii: —Naafigi'en! Wanaa homo e mon fuu ana humta nagge mum naa ndakiiwa mum ɲalaande fowteteende yarnoya ɗum naa? ");
INSERT INTO ffm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Oo debbo taanii Ibarahiima, mo Ibiliisa haɓɓiri duuɓi sappo e jetti, haanaa humteede ɲalaande fowteteende naa? ");
INSERT INTO ffm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nde Iisaa haalnoo ɗum ndee, wayɓe mum ɓee fuu njaagii faa walaa seese. Kaa jamaa oo fuu ana seyii e dow kaayeefiiji ɗi o waɗata ɗii. ");
INSERT INTO ffm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iisaa wii: —Hono Laamu Laamɗo wa'i? Koɗum nanndinan-moo-mi? ");
INSERT INTO ffm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Laamu Laamɗo ana nanndi e ngeeƴu buyaage mo neɗɗo ɓami, aawi e sardiŋe mum. Ngeeƴu oo fuɗi, laatii lekki faa pooli ana ɲiɓa cuuɗi e caɓe mum. ");
INSERT INTO ffm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","O wii kasen: —Koɗum nanndinan-mi e Laamu Laamɗo oo? ");
INSERT INTO ffm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Omo nanndi e ƴuufinirdi ndi debbo ɓami, so jiiɓi e saawal tati conndi alkama faa ndi fuu ndi ƴuufi. ");
INSERT INTO ffm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iisaa ana fa'i Urusaliima, ana faŋa geelle e gure fuu, ana waajoo. ");
INSERT INTO ffm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Neɗɗo gooto lamndii mo: —Moobbo, yimɓe seeɗa tan kisata naa? O wii ɓe: ");
INSERT INTO ffm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Tiinnee naatiron damal paaɗungal ngal, sabi miɗo wiya on: heewɓe njiɗan naatude, ndonka. ");
INSERT INTO ffm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","So jom galle oo immiima sokii damal ngal, onon on keedii sella oɗon calmina, oɗon mbiya: «Kalfaaɗo, udditan min!» o jaaboto on: «Mi anndaa to njeye-ɗon!» ");
INSERT INTO ffm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nden, on ndaroto oɗon mbiya: «Min ɲaamdii e maa, min njardii e maa, a waajike e daalaaje amen.» ");
INSERT INTO ffm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mo jaaboto on: «Mi anndaa to njeye-ɗon. Ngoɗɗee kam, onon ooɲiiɓe!» ");
INSERT INTO ffm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","On njiyan Ibarahiima e Isiyaaka e Yaakuuba, kaɲum e annabaaɓe fuu ley Laamu Laamɗo, tawa onon oɗon mbedaa sella. Ɲannde nden on mboyan, on ŋerƴondiran ɲiiƴe kammari mimsee mon. ");
INSERT INTO ffm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Yimɓe iwran funnaange e hiirnaange, saahal e ɓaleeri, njooɗoo ɲaamda ley Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Nden yoga e caggalaaɓe laatoto ardiiɓe, yoga e ardiiɓe laatoto caggalaaɓe. ");
INSERT INTO ffm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","E oon wakkati fuu, yoga e Farisa'en ngari, mbii mo: —Iw ɗoo, njahaa e laawol maa, sabi Hirudus kaananke oo ana tewta no warde. ");
INSERT INTO ffm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","O wii ɓe: —Njehee mbiyoyee ndoɓu oo: «Miin, mi ribban laddeeji, mi sellinan ɲawɓe hannde e janngo. Ɲalooma tataɓo oo mi timminan golle am fuu. ");
INSERT INTO ffm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kaa ana tilsi mi yaha hannde e janngo e faɓɓi-janngo, sabi annabaajo haanaa maayde so wanaa ley Urusaliima.» ");
INSERT INTO ffm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Hay yimɓe Urusaliima, on mbarii annabaaɓe, on mbardii nelaaɓe e mon kaaƴe! Cili kuurɗi njiɗu-mi hawrintinde ɓiɓɓe mon no cofal hawrintinirta ɓiɓɓe mum ley biifoole mum nii. Kaa on njaɓaali. ");
INSERT INTO ffm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ɗum nee, on ɗaldete e Suudu mon Dewal, ndu laatoo saabeere. Miɗo wiya on: on njiyataa kam so wanaa faa wakkati mo mbiyaton e mum: «Barke woodanii gardoowo e dow innde Joomiraaɗo!» ");
INSERT INTO ffm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Waɗiino e ley ɲalaande fowteteende wootere, Iisaa ana wonnoo e galle hooreejo Farisa'en gooto faa ɲaama. Tawanooɓe ton ɓee ngattani mo hakkille ");
INSERT INTO ffm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","kammari neɗɗo uppuɗo ana tawanoo ɗon. ");
INSERT INTO ffm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iisaa haaldi e jannginooɓe Sariya e Farisa'en, wii: —Sellinde ɲawɗo ley ɲalaande fowteteende, ana dagii naa dagaaki? ");
INSERT INTO ffm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ɓe fuu, ɓe mbii teen. E oon wakkati, o memi ɲawɗo oo, o sellini ɗum, o yoppiti ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Caggal ɗum, o wii ɓe: —Homo e mon ɓiyum naa ngaari mum saamata e ɓunndu waasa yaltinde ɗum ɗon e ɗon, fay so ɗum ɲalaande fowteteende? ");
INSERT INTO ffm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ɓe ndonki jaabaade mo e majjum. ");
INSERT INTO ffm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nde Iisaa yiinoo noddaaɓe ɓee ana cuɓoo joolle ɓurɗe teddude ndee, o waajii ɓe, o wii: ");
INSERT INTO ffm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—So a noddaama kuurtungu, pati jooɗa e joonnde ɓurnde teddude. Sabi ɓurɗo ma teddude ana waawi warde, ");
INSERT INTO ffm_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","nodduɗo on oo wara, wiye: «Hokku oo ɗoo joonnde ndee!» Nden, a yaagoto jooɗoyaade e joonnde ɓurnde leyɗude ndee. ");
INSERT INTO ffm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","So a noddaama kuurtungu, jooɗoya caggal, yalla nodduɗo ma oo ana wara, wiye: «Giɗo, heettu yeeso gaa!» Nden, ɗum laatante teddungal yeeso noddaaɓe ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sabi mawninkiniiɗo fuu, leyɗinte, leyɗinkiniiɗo teddinte. ");
INSERT INTO ffm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","O wii nodduɗo mo oo duu: —So aɗa nodda yimɓe bottaari naa hiraande, pati noddu giɗiraaɓe naa banndiraaɓe naa sakiraaɓe naa taakallemme'en maa tawaaɓe yo arsukunte'en. So ɓe noddite, ɗum laatoo mbarjaari maa. ");
INSERT INTO ffm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","So a waɗii waliima, noddu misikiina'en e wooyɓe e bonnguuɓe e wumɓe. ");
INSERT INTO ffm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nden, a welan hoore, sabi ɓeen ngalaa ko njoɓire, a yoɓete ɲannde immital fooccitiiɓe. ");
INSERT INTO ffm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Gooto e ɲaamooɓe ɓee, nde nani haala kaa ndee, wii mo: —Ɲaamoyoowo ley Laamu Laamɗo, welii hoore. ");
INSERT INTO ffm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Iisaa wii mo: —Gorko gooto waɗiino waliima, noddi yimɓe faa heewi. ");
INSERT INTO ffm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nde ɲaamdu nduu tilinoo ndee, o neli kaadime makko to yimɓe ɓee, wiya: «ngaree, waliima oo lanndinike.» ");
INSERT INTO ffm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ɓe fuu, gooto gooto, ɓe puɗɗi ujaade. Gooto wii: «Mi soodii ngesa, ana tilsi mi yaha mi yiyoya nga, njaafo-ɗaa kam.» ");
INSERT INTO ffm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Goɗɗo wii: «Mi soodii ga'i demooje sappo e jale sari joy. Miɗo yiɗi hornoyde ɗi, njaafo-ɗaa kam.» ");
INSERT INTO ffm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Goɗɗo kasen wii: «Mi jommbaajo, ɗum saabii so mi heɓataa warde.» ");
INSERT INTO ffm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kaadime oo warti, haaltani ɗum kalfaaɗo mum. Oon bilaa, wii mo: «Yaa law ley boli e dinngiraaji ngeenndi ndii, noddoyaa misikiina'en e wooyɓe e wumɓe e bonnguuɓe.» ");
INSERT INTO ffm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kaadime oo warti, wii: «Kalfaaɗo, ko mbii-ɗaa koo fuu waɗaama, kaa faa jooni yolannde ana heddii.» ");
INSERT INTO ffm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Kalfaaɗo oo wii kaadime oo: «Yaa dow ɗati jaajuɗi e paaɗuɗi. Mo keɓu-ɗaa fuu, ndoolɗinaa ɗum wara naata, yalla suudu am nduu ana huuɓa. ");
INSERT INTO ffm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Sabi miɗo wiya on: fay gooto e ɓe noddunoo-mi ɓee meeɗataa ɲaamdu am.» ");
INSERT INTO ffm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yimɓe heewɓe ana njaada e Iisaa. O yeeccitii, o wii ɓe: ");
INSERT INTO ffm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Garɗo e am fuu, sinaa mi ɓurana ɗum inna mum e baam mum e jom suudu mum e sukaaɓe mum e miɲiraaɓe mum e mawniraaɓe mum, mi ɓurana ɗum fay kaɲum e hoore mum. So wanaa ɗum, joomum waawaa laataade taalibbo am. ");
INSERT INTO ffm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kasen duu, mo ɓamaali leggal mum bardugal jokka e am fuu, waawaa laataade taalibbo am. ");
INSERT INTO ffm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","So won muuyɗo e mon mahude suudu toowndu, wanaa joomum jooɗoto tafon, hiisoo ko hasindini e mum, ƴeewa so ana jogii ko biltata ɗum naa? ");
INSERT INTO ffm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","So wanaa ɗum, so joomum diidii taɲɲaali, jiiɗo mo fuu jalan mo, ");
INSERT INTO ffm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","wiya: «Ƴeewee oo neɗɗo diidii, ronkii taɲɲude.» ");
INSERT INTO ffm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Kasen, so kaananke yehii faa haɓoya e kaananke goɗɗo, o miilataako tafon yalla worɓe ujunaaji sappo ana mbaawi jaɓɓaade worɓe ujunaaji noogay faa kaɓa e mum? ");
INSERT INTO ffm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","So mo waawaa jaɓɓaade ɗum, o waɗan e mum nelaaɓe gila yottaaki ɓadaaki, faa jam waɗa hakkunde maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hono non, fay gooto e mon waawaa laataade taalibbo am so yoppaali ko jogii fuu. ");
INSERT INTO ffm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Lamɗam ana moƴƴi, kaa so ɗam ŋoottii lammude, koɗum lamminta ɗam kasen? ");
INSERT INTO ffm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Walaa fuu ɗo ɗam waawata naftoreede, wanaa e leydi, wanaa e birgi. Ɗam tippete sella. Jom nowru fuu yo nanu. ");
INSERT INTO ffm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Duwaaɲe'en e luuttooɓe hono mum'en fuu ana ɓadinoo mo faa kettindanoo mo. ");
INSERT INTO ffm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisa'en e dunkee'en Sariya ana ŋurŋurta, ana mbiya: —Oo ana jaɓɓoo luuttooɓe ana ɲaamda e mum'en! ");
INSERT INTO ffm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","E ley ɗum, o waɗani ɓe ngol banndol, o wii: ");
INSERT INTO ffm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—So gooto mon ana jogii baali teemedere, majjiraama mbaalu gooto, wanaa yoppan capanɗe jeenay e jeenay ɗii fuu ley ladde tewtoya majjuɗo oo faa yiita ɗum naa? ");
INSERT INTO ffm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","So o yiitii mo, o towiran ɗum seyo. ");
INSERT INTO ffm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nde o warti galle makko fuu, o hawrintinan giɗiraaɓe makko e taakallemme'en makko, o wiya ɗum'en: «Ceyodee e am, sabi mi yiitii mbaalu am majjunooɗo oo.» ");
INSERT INTO ffm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Miɗo haalana on: hono non seyo laatortoo dow kammu so luuttoowo gooto tuubii. Engo ɓuri seyo capanɗe njeenayon e njeenayon fooccitiiɓe ɓe kasindinaa e tuubal. ");
INSERT INTO ffm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—Naa, so debbo ana jogii buuɗi cardi sappo, majjiraama hen gooto, huɓɓataa lampa, wuuwa galle oo, tewtira mbuuɗu oo hakkille faa yiita ɗum naa? ");
INSERT INTO ffm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","So o yiitii mo, o hawrintinan giɗiraaɓe makko e taakallemme'en makko, o wiya: «Ceyodee e am, sabi mi yiitii mbuuɗu am majjunooɗo oo.» ");
INSERT INTO ffm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Miɗo haalana on: hono non malaa'ika'en Laamɗo ceyortoo so luuttoowo gooto tuubii. ");
INSERT INTO ffm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iisaa wii kasen: —Gorko gooto ana joginoo ɓiɓɓe worɓe ɗiɗon. ");
INSERT INTO ffm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Miɲiraaɗo oo wii baam mum: «Baaba, hokkam ngeɗu am e jawdi ndii.» Ndennoo, baabiraaɗo oo fecci jawdi mum ndii hakkunde maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Waɗi balɗe seeɗa, miɲiraaɗo oo reentini ko jogii fuu, dawi, yehi leydi ngoɗɗundi. Ton o bonniri ngeɗu makko oo fuu e fijirde. ");
INSERT INTO ffm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nde o timminnoo ndee, yolbere bonnde waɗi e ndiin leydi, o fuɗɗi tampude. ");
INSERT INTO ffm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","O yehi o takkoyii e gorko jeyaaɗo e ndiin leydi. Oon neldi mo gese mum faa mo duranoya ɗum girooji. ");
INSERT INTO ffm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Omo muuyannoo fay ɲaamde ɲaamdu girooji ɗii, kaa fay gooto hokkaali mo. ");
INSERT INTO ffm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nde hakkille makko wartunoo ndee, o wii hoore makko: «Gollanooɓe baabam ɲaaman faa njoppa, miin miɗo maaya ɗoo yolbere. ");
INSERT INTO ffm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mi immoto, mi hoota galle baabam, mi wiya ɗum: Baaba, mi tooɲii Laamɗo, mi tooɲii ma, ");
INSERT INTO ffm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","mi haanaa fay wiyeede ɓiya. Ndennoo, jogoram no gooto e gollooɓe maa ɓee nii!» ");
INSERT INTO ffm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Oon wakkati fuu, o immii o fa'i to baabiiko. Baaba oo soynii mo to woɗɗi, ɓernde mum hecciɗi, dogi maaɓii mo. ");
INSERT INTO ffm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ɓiɗɗo oo wii mo: «Baaba, mi tooɲii Laamɗo, mi tooɲii ma, mi haanaa fay wiyeede ɓiya.» ");
INSERT INTO ffm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Non baaba oo wii gollooɓe mum: «Njaawnee, ngaddoyee saaya ɓurka fuu moƴƴude ɓoornon mo, ngaɗanon mo felfelde e feɗeendu makko, ngaɗon paɗe e koyɗe makko. ");
INSERT INTO ffm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ngaddon ngaari njarnaandi faa fayi ndii duu, kirson ɗum faa ɲaamen, mbelto-ɗen. ");
INSERT INTO ffm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sabi ɓiyam oo, o maaynooɗo o wuurtii, o kalkinooɗo o hewtaama.» Nii ɓe puɗɗi weltaare. ");
INSERT INTO ffm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","E ley ɗum, ɓiɗɗo hammadiijo oo iwri gese. Nde o ɓadinoo yottaade galle oo ndee, o nani bawɗi e dippanɗe. ");
INSERT INTO ffm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","O noddi gooto e gollooɓe ɓee, o lamndii ɗum ko ndee dillere woni? ");
INSERT INTO ffm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Oon wii mo: «Miɲa oo warti e jam, baam maa hirsanii mo ngaari payndi ndii.» ");
INSERT INTO ffm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Nii mawniraaɗo oo tikki, salii naatude galle oo. Baaba oo yalti, suri mo yalla omo naata. ");
INSERT INTO ffm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","O jaabii baabiiko, o wii: «Annii, duuɓi kuurɗi miɗo gollane, fay nde wootere mi salaaki yamiroore maa. Kaa ɗum e taweede, abada a hokkaali kam fay damngel faa miin e giɗiraaɓe am, min mbeltoroo. ");
INSERT INTO ffm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kaa ɓiya ɲaamɗo jawdi maa fuu e fugaaji so warti oo, a hirsanii ɗum ngaari payndi ndii.» ");
INSERT INTO ffm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Baabiiko wii mo: «Ɓinngel am, enen ngondi abada, ko njey-mi fuu, aan jey. ");
INSERT INTO ffm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ana haani ceyo-ɗen, mbelto-ɗen. Sabi miɲa oo, o maaynooɗo o wuurtii, o kalkinooɗo o hewtaama.» ");
INSERT INTO ffm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iisaa wii taalibaaɓe mum ɓee kasen: —Arsukunte gooto halfiniino howruujo mum jawdi. O haalanaa howruujo oo ana bonna jawdi makko. ");
INSERT INTO ffm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","O noddi ɗum, o wii: «Ko nanu-mi e maa koo, ko woni? War, hiisa ko kalfine-ɗaa koo, sabi hankasen a waawaa halfineede.» ");
INSERT INTO ffm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Howruujo oo wii e hoore mum: «Hono ngaɗan-mi? Sabi kalfaaɗo am yoppan kam golle. Mi walaa doole remde, miɗo yaagoo ɲaagaade. ");
INSERT INTO ffm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ooho! Mi anndii no ngaɗan-mi, yalla ana daɲa jaɓɓiiɓe kam e ley cuuɗi mum'en, so mi ɓoortaama.» ");
INSERT INTO ffm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Oon wakkati, o noddiri ɓe kalfaaɗo makko rewata ɓee, gooto gooto. O wii arano oo: «Hono foti kalfaaɗo am oo rewete?» ");
INSERT INTO ffm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Oon wii mo: «Bidoŋaaji teemedere nebam ndewetee-mi.» Howruujo oo wii mo: «Ɓam dewtere maa ɲamaale, yaawnu, jooɗa mbinndaa capanɗe joy.» ");
INSERT INTO ffm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","O wii goɗɗo kasen: «Aan nee, hono foti ndewete-ɗaa?» Oon wii mo: «Caakuuji teemedere gawri ndewetee-mi.» O wii oon: «Ɓam dewtere maa ɲamaale, mbinndaa caakuuji capanɗe jetti.» ");
INSERT INTO ffm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kalfaaɗo oo mani howruujo ooɲiiɗo oo saabe ƴoyre mum. Sabi yimɓe adunankooɓe ɓee ɓuri yimɓe jeyaaɓe e fooyre Laamɗo ɓee ƴoƴande yimɓe hono mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Miin, miɗo wiya on: tewtee giɗiraaɓe, tewtiree ɓe jawdi aduna yalla so ndi timmii, oɗon njaɓɓitee e ley nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Iisaa ɓeydi hen, wii: —Koolniiɗo e kulle pamare, hollan hoolaare e kulle teentiliiɗe. Jammbiiɗo e kulle pamare, jammboto e kulle teentiliiɗe duu. ");
INSERT INTO ffm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ndennoo, so on kollaali hoolaare e jawdi adunankoori ndii, homo fuu halfinta on jawdi ngoongaraari ndii? ");
INSERT INTO ffm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kasen duu so on kollaali hoolaare e jawdi jananndi, hono ndokkirte-ɗon ko njey-ɗon koo? ");
INSERT INTO ffm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Golloowo fay gooto waawaa gollande halfaaɓe ɗiɗon, sabi naa joomum waɲii gooto, yiɗii keddiiɗo oo, naa nanngondirii e gooto oo, yoppii keddiiɗo oo. On mbaawaa gollidande Laamɗo e jawdi. ");
INSERT INTO ffm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisa'en ɓee ana kettindoo ɗum fuu. Nde wonnoo ɓe yiɓɓe kaalisi, eɓe njala mo. ");
INSERT INTO ffm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","O wii ɓe: —Onon, oɗon cenna ko'e mon yeeso yimɓe, kaa Laamɗo ana humpitii ɓerɗe mon. Sabi ko yimɓe teddinta koo, ana harmi to Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sariya oo e annabaaɓe ana ngoodunoo faa e jamaanu Yaayaa. Gila e Yaayaa Kabaaru Lobbo haala Laamu Laamɗo oo ana ɓannginee. Gooto fuu ana haɓanoo naatude e makko. ");
INSERT INTO ffm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Timmugol kammu e leydi ɓuri newaade diina ittude toɓɓere wootere e ley Sariya oo. ");
INSERT INTO ffm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ceerɗo jom suudu mum so ɓami goɗɗo fuu, jeenii. Kasen duu neɗɗo fuu ɓamɗo debbo ceeraaɗo, jeenii. ");
INSERT INTO ffm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Waɗiino e ɓettaade, gorko arsukunte gooto parortonooɗo burmusuuje boɗeeje ɗaatuɗe, duuminooɗo e neema e weltaare. ");
INSERT INTO ffm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gorko uubaaɗo mo walaa fay huunde, biyeteeɗo Laajaru, ana lelinoo damal galle makko. ");
INSERT INTO ffm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ana yiɗunoo ɲaamde kedde makko, fay dawaaɗi ana ngarannoo ana mettoo uube makko ɗee. ");
INSERT INTO ffm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Misikiino oo maayi, malaa'ika'en naɓi ɗum faa to Ibarahiima. Arsukunte oo maayi kaɲum duu, iraa, ");
INSERT INTO ffm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","naati yiite. E ley jukkungo makko ngoo, o hunci gite makko, o soynii Ibarahiima to woɗɗi, Laajaru ana dow koyɗe mum. ");
INSERT INTO ffm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","O eewnii o wii: «Maamam Ibarahiima, yurmam, nel Laajaru suuwa hoore feɗeendu mum ley ndiyam, yalla ana ɓuumna ɗemngal am. Sabi mi torrike sanne ley ngee yiite.» ");
INSERT INTO ffm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kaa Ibarahiima wii: «Ɓinngel am, miccita a heɓii neema maa e ley nguurndam maa, Laajaru kaa bone heɓi. Jooni, kanko mo heɓan hinnee, aan torro-ɗaa. ");
INSERT INTO ffm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ko ɓuri ɗum fuu, ngaykaare mawnde woni hakkunde amen e mon. Ndennoo so won yiɗuɓe iwde to mon ngara ga amen, naa iwde ga amen njaha to mon, tawan mbaawaa.» ");
INSERT INTO ffm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Arsukunte oo wii: «Ndennoo maama, miɗo ɲaage, nel Laajaru galle baabam, ");
INSERT INTO ffm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","sabi mi ɗalii ton miɲiraaɓe am njoyon worɓe, faa o jeertina ɓe pati ɓe ngara e oo nokku torra.» ");
INSERT INTO ffm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Kaa Ibarahiima wii mo: «Eɓe njogii dewtere Muusaa e dewte annabaaɓe ɓee, yo ɓe kettindano ɗen.» ");
INSERT INTO ffm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","O jaabii ɗum: «Wanaa non, maamam Ibarahiima! Kaa so won iwɗo hakkunde maayɓe yehi to maɓɓe, ɓe tuuban.» ");
INSERT INTO ffm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ibarahiima wii mo: «So ɓe kettindanaaki Muusaa e annabaaɓe, fay iwɗo e hakkunde maayɓe waɗataa so ɓe ngoonɗina.» ");
INSERT INTO ffm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iisaa wii taalibaaɓe mum ɓee: —Ko fergitata yimɓe faa luutta waasataa heɓeede, kaa bone woodanii laatiiɗo sabaabu majjum. ");
INSERT INTO ffm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Haayre teddunde haɓɓee e daande joomum tippee ley geeci ɓuri moƴƴande ɗum, diina luuttinde gootel e koy ɗoo cukaloy. ");
INSERT INTO ffm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Kaybee ko'e mon: so sakiike maa luuttii, ɲiŋaa ɗum. So tuubii, njaafo-ɗaa ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","So o tooɲii ma cili jeɗɗi e ley ɲalooma gooto, o warti e maa cili jeɗɗi omo tuubane, njaafo-ɗaa mo. ");
INSERT INTO ffm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nelaaɓe ɓee mbii Moobbo oo: —Ɓeydan min goonɗinal. ");
INSERT INTO ffm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Iisaa jaabii, wii: —So goonɗinal mon famɗiriino no ngeeƴu buyaage nii, so on mbiino kii ɗoo lekki ruggitoo, daroyoo ley geeci, ki ɗowtanto on. ");
INSERT INTO ffm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Homo e mon maccuɗo mum demoowo naa duroowo mum wartata ladde so wiya ɗum ɲaamdu mum annii oon wakkati fuu? ");
INSERT INTO ffm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Walaa! A wiyan mo moƴƴinane ɲaamdu, o lanndinoo yalla omo gollane faa ɲaamaa njaraa. Caggal mum, o ɲaama kanko duu. Wanaa non worri naa? ");
INSERT INTO ffm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Yalla a yettan maccuɗo oo saabe waɗii ko njamir-ɗaa ɗum koo? ");
INSERT INTO ffm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Onon duu hono non. So on ngaɗii huunde fuu ko njamire-ɗon, mbiyee: «Min maccoy tan, ko min kaani waɗude nii min ngaɗi.» ");
INSERT INTO ffm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nde Iisaa yahannoo Urusaliima ndee, ƴaɓɓorii hakkunde leyɗe Samariya e Galili. ");
INSERT INTO ffm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","O wari faa o naata ngeenndi ngootiri, non seppaaɓe sappo worɓe peewti mo, ndarii to toowti, ");
INSERT INTO ffm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","eewnii, mbii: —Moobbo Iisaa, yurma min! ");
INSERT INTO ffm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Nde o yiinoo ɓe ndee, o wii ɓe: —Njehee, kolloyee ko'e mon yottinooɓe sadaka ɓee. E ley yaadu maɓɓe nduu, ɓe cellinaa. ");
INSERT INTO ffm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Gooto maɓɓe, nde yiinoo sellii ndee, wirfitii ana yetta Laamɗo e daande toownde. ");
INSERT INTO ffm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","O diccii yeeso Iisaa, o yetti ɗum. Oon yo Samariyanke. ");
INSERT INTO ffm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Iisaa jaɓɓitii, wii: —Tama wanaa sappo ɓee fuu cellinaama? Hoto njeenayon ɓee nee ngoni? ");
INSERT INTO ffm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Walaa miilɗo wirfitaade yetta Laamɗo so wanaa janano oo naa? ");
INSERT INTO ffm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Caggal ɗum, o wii gorko oo: —Imma yaa e laawol maa, sabi goonɗinal maa danndii ma. ");
INSERT INTO ffm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nden Farisa'en ɓee lamndii Iisaa mande Laamu Laamɗo oo warata? O jaabii ɓe, o wii: —No Laamu Laamɗo wardata nii, yiyataake. ");
INSERT INTO ffm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Fay gooto waawaa wiide omo nii naa omo naa. Anndee, Laamu Laamɗo ana hakkunde mon. ");
INSERT INTO ffm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Caggal ɗum, o wii taalibaaɓe makko ɓee: —Wakkati waran mo muuyaton e mum yiide ɲalaaɗe Ɓii Neɗɗo oo, fay so ɲannde wootere, kaa on njiyataa. ");
INSERT INTO ffm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","On mbiyete: «Omo too», naa «Omo gaa», pati njehee, pati njokkee ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sabi no majere fooynirta kammu fuu nii, hono non Ɓii Neɗɗo laatortoo ɲannde gartol mum. ");
INSERT INTO ffm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kaa ko adii ɗum, ana tilsi o torree torraaji keewɗi, yimɓe oo ɗoo jamaanu tippitoo mo. ");
INSERT INTO ffm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","No wa'unoo e wakkati Nuuhu nii, hono non kasen wa'ata e ɲalaaɗe Ɓii Neɗɗo: ");
INSERT INTO ffm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","yimɓe ana ɲaama, ana njara, ana ndewla, ana ndewlee, faa ɲannde Nuuhu naati laana kaa. Nii ilam tuufaanu ɗam wari, halkiri ɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Wa'an hono no wakkati Luuɗu nii, yimɓe ana ɲaama, ana njara, ana cooda, ana cootta, ana ndema, ana maha. ");
INSERT INTO ffm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kaa nde Luuɗu yaltunoo Sodooma ndee, Laamɗo tomni yiite e sitti, halki ɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Hono non ɲannde ɓanngugol Ɓii Neɗɗo oo duu wa'ata. ");
INSERT INTO ffm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ɲannde nden, mo ɗum tawi dow bene, tawi kaaki mum ana ley suudu, pati wiya jippanto ɗi. Mo ɗum tawi gese, pati hoota cuuɗi. ");
INSERT INTO ffm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Miccitee jom suudu Luuɗu oo. ");
INSERT INTO ffm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Neɗɗo fuu tewtuɗo danndude yonki mum, waasan ki, kaa neɗɗo fuu baasuɗo ki, danndan ki. ");
INSERT INTO ffm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Miɗo haalana on: e oon jemma, yimɓe ɗiɗon leldiiɓe e daɗɗo wooto, gooto maɓɓe naɓete, goɗɗo oo yoppee. ");
INSERT INTO ffm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Rewɓe ɗiɗon undooɓe, gooto mum'en naɓete, goɗɗo oo yoppee.  ");
INSERT INTO ffm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Taalibaaɓe ɓee njaɓɓitii, mbii mo: —Kalfaaɗo, hoto ɗum waɗata? O wii ɓe: —Ɗo jiibe ngoni fuu, ɗon dute kawritata. ");
INSERT INTO ffm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iisaa waɗani ɓe banndol faa hollita ɓe ana tilsi ɓe nduumoo e duwaawu, pati ɓe njeeboo. ");
INSERT INTO ffm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","O wii: —Caroowo gooto mo hulataa Laamɗo, yaagataako fay gooto, ana wonnoo e ngeenndi ngootiri. ");
INSERT INTO ffm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Debbo mo gorum maayi ana ley ndiin ngeenndi. Ana warannoo e caroowo oo, wiya: «Wallam faa mi hewta goonga hakkunde am e kaɓdo am oo.» ");
INSERT INTO ffm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Caroowo oo deƴƴinii faa ɓooyi. Kaa sakitii o wii hoore makko: «Fay so taweede mi hulataa Laamɗo mi yaagataako fay gooto duu, ");
INSERT INTO ffm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mi wallan debbo oo faa o hewta goonga makko, sabi omo torra kam, yalla omo sukkita noppi am.» ");
INSERT INTO ffm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Caggal ɗum, Iisaa wii: —On nanii ko caroowo ooɲiiɗo oo wii naa? ");
INSERT INTO ffm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Laamɗo nee wallataa suɓaaɓe mum wullitotooɓe ɗum jemma e ɲalooma ɓee fuu faa ɓe kewta goonga maɓɓe naa? Mo jaabantaako ɓe law naa? ");
INSERT INTO ffm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Miɗo haalana on: o wallan ɓe law. Kaa so Ɓii Neɗɗo waroyii, omo tawa goonɗinɓe mo e leydi ndii naa? ");
INSERT INTO ffm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yimɓe jogoriiɓe ko'e mum'en yo fooccitiiɓe, njataaki woɓɓe, ɓeen o waɗani ngol banndol: ");
INSERT INTO ffm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Worɓe ɗiɗon naati ley Suudu Dewal Mawndu nduu, faa ngaɗa duwaawu. Gooto oo Farisanke, goɗɗo oo duwaaɲe. ");
INSERT INTO ffm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisanke oo darii ana duworoo ley ɓernde mum hono nii: «Laamɗo, mi yettirii ma ko mi nanndaali e yimɓe heddiiɓe ɓee, ɗum woni wuyɓe e ooɲiiɓe e jeenooɓe, e ko mi nanndaali e oo ɗoo duwaaɲe koo. ");
INSERT INTO ffm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Miɗo hoora yontere fuu cili ɗiɗi, miɗo itta jakka e huunde fuu ko keɓu-mi.» ");
INSERT INTO ffm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Duwaaɲe oo nee darii to toowti, huli fay tiggitaade kammu, jurginii, ana wiya: «Laamɗo yurmam, mi luuttoowo.» ");
INSERT INTO ffm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Haya, miɗo wiya on: oo hooti yo nanngiraaɗo pooccitiiɗo, wanaa oo too. Sabi mawninkiniiɗo fuu leyɗinte, leyɗinkiniiɗo fuu toownete. ");
INSERT INTO ffm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Won waddanɓe Iisaa cukaloy keccoy, yalla omo mema koy. Kaa nde taalibaaɓe ɓee njiinoo ɗum ndee, ndarii ana njahoo e yimɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Non Iisaa noddi taalibaaɓe ɓee, wii ɗum'en: —Accee cukaloy koy ngara e am, pati kaɗee koy, sabi wa'uɓe no makkoy nii ɓee njey Laamu Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Miɗo haalana on goonga: mo jaɓiraali Laamu Laamɗo oo no cukalel nii fuu, naatataa hen! ");
INSERT INTO ffm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Gooto e hooreeɓe Yahuudiyankooɓe lamndii mo, wii: —Moobbo moƴƴo, koɗum kaan-mi waɗude faa mi heɓa nguurndam nduumiiɗam? ");
INSERT INTO ffm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Iisaa wii mo: —Ko saabii so aɗa noddira kam moƴƴo? Moƴƴo walaa so wanaa gooto, oo woni Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Aɗa anndi ɗii ɗoo sariyaaji: «Pati jeenu, pati ɲaaɗu hoore, pati wujju, pati seeda fenaande, teddin inna maa e baam maa.» ");
INSERT INTO ffm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Hooreejo oo jaabii mo, wii: —Miɗo haybi ɗum fuu gila e cukaaku am. ");
INSERT INTO ffm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nde Iisaa nanunoo ɗum ndee, wii mo: —Aɗa ɲakoraa huunde wootere: soottu ko njogi-ɗaa koo fuu, ndokkaa kaalisi oo misikiina'en. Nden, a heɓan jawdi dow kammu. Caggal ɗum, ngaraa, njokkaa kam. ");
INSERT INTO ffm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kaa nde mo nanunoo ɗum ndee, mo ɲirɓinii, sabi o arsukunte ɲolɗo. ");
INSERT INTO ffm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iisaa ƴeewi mo, wii: —Hee naatugol arsukunte e Laamu Laamɗo ana tiiɗi! ");
INSERT INTO ffm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Sabi ƴaɓɓoraade ngelooba e wuddere mesalal ɓuri newaade, diina naatugol arsukunte e Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hettindantooɓe mo ɓee mbii: —Ndennoo, homo woni kisoowo? ");
INSERT INTO ffm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Iisaa jaabii: —Ɗo yimɓe ɗum laatataako, kaa eɗum laatoo to Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piyeer jaɓɓitii, wii: —Minen, min njoppii ko min njogii fuu, min njokkii e maa. ");
INSERT INTO ffm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","O wii ɓe: —Miɗo haalana on goonga: neɗɗo fuu joppirɗo galle mum naa jom suudu mum naa sakiraaɓe mum naa saaraaɓe mum naa sukaaɓe mum saabe Laamu Laamɗo, ");
INSERT INTO ffm_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","heɓan cowe keewɗe e oo ɗoo wakkati mo ngon-ɗen e mum jooni, heɓa nguurndam nduumiiɗam e wakkati garoyoowo oo duu. ");
INSERT INTO ffm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iisaa noddi taalibaaɓe mum sappo e ɗiɗon ɓee, wii ɗum'en: —Kettinee, eɗen nii ŋabbita Urusaliima. Ko annabaaɓe mbinndunoo haala Ɓii Neɗɗo koo fuu, tabitan. ");
INSERT INTO ffm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Sabi o waɗete e juuɗe heeferɓe, ɓe njaayra mo, ɓe torra mo, ɓe tutta e makko, ");
INSERT INTO ffm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ɓe piya mo dorri, ɓe mbara mo. Kaa ɲalooma tataɓo oo, mo wuurtan. ");
INSERT INTO ffm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Taalibaaɓe ɓee paamaali haala kaa. Maanaa makka suuɗanike ɓe, ɓe anndaa ko o yiɗi wiide. ");
INSERT INTO ffm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nde Iisaa ɓadinoo Yeriko ndee, tawi bumɗo ana jooɗii sera laawol ngol, ana garbinoo. ");
INSERT INTO ffm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Oon maati jamaa ana ƴaɓɓoo, lamndii ko ɗum woni? ");
INSERT INTO ffm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ɓe mbii mo: —Iisaa Nasaraatunke oo ɓettotoo ɗoo. ");
INSERT INTO ffm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","O wulli, o wii: —Iisaa, taanii Daawuuda, yurmam! ");
INSERT INTO ffm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ardiiɓe ɓee ndarii ana njahoo e makko, ana mbiya o deƴƴinoo. Kaa o ɓeydii wullude, omo wiya: —Taanii Daawuuda, yurmam! ");
INSERT INTO ffm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iisaa darii yamiri ɓe ngadda mo e mum. Nde mo ɓadinoo ndee, Iisaa lamndii mo, wii: ");
INSERT INTO ffm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—Koɗum njiɗ-ɗaa mi waɗane? O wii: —Moobbo, mi hewta gite am! ");
INSERT INTO ffm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Iisaa wii mo: —Wumtu, goonɗinal maa danndii ma. ");
INSERT INTO ffm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ɗon e ɗon o wumti, o jokki e mum, omo yetta Laamɗo. Nde yimɓe ɓee njiinoo ɗum ndee, ndarii ana njetta Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iisaa naati Yeriko, ana seeka ngeenndi ndii. ");
INSERT INTO ffm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Gorko biyeteeɗo Jakayus ana wonnoo ton. O hooreejo duwaaɲe'en, o arsukunte duu. ");
INSERT INTO ffm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Omo yiɗunoo yiide Iisaa faa o annda ko woni, kaa o ronkii saabe ɓillondiral, nde wonnoo mo daɓɓo. ");
INSERT INTO ffm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","O dogi, o arditii, o ŋabbi lekki ɗo Iisaa ƴaɓɓortoo ɗoo faa o yiya ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nde Iisaa yottinoo nokku oo ndee, tiggitii, yii mo, wii: —Jakayus, yaawnu jippa, sabi ana haani mi jippoo galle maa hannde. ");
INSERT INTO ffm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jakayus yaawni jippii, jaɓɓorii mo seyo. ");
INSERT INTO ffm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Yiiɓe ɗum ɓee fuu keddii ana ŋurŋurta, ana mbiya: —O jippanoyike luuttoowo. ");
INSERT INTO ffm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kaa Jakayus darii yeeso Iisaa, wii: —Moobbo, mi hokkan feccere jawdi am fuu misikiina'en. So won mo teetu-mi huunde, mi yoɓan ɗum cowe nay. ");
INSERT INTO ffm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Iisaa wii mo: —Hannde, kisindam naatii e oo galle, sabi oo duu yo taanii Ibarahiima! ");
INSERT INTO ffm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Sabi Ɓii Neɗɗo warii tewtude majjuɓe faa hisina ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yimɓe ana ngondi e hettindaade haala Iisaa, faa o fawi hen banndol gonngol. Sabi o ɓadike Urusaliima, kasen duu yimɓe miilii Laamu Laamɗo ɓanngan jooni temmbu. ");
INSERT INTO ffm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","O wii: —Gorko dimo ɗor yehi leydi ngoɗɗundi faa lamminee, caggal ɗum, warta. ");
INSERT INTO ffm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","O noddi kaadime'en makko sappo, o hokki gooto maɓɓe fuu mutakal kaŋŋe, o wii ɓe: «Njaagoree faa mi warta.» ");
INSERT INTO ffm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kaa nde wonnoo yimɓe ngeenndi makko njiɗaa mo, ɓe immini nelaaɓe caggal makko, ɓe mbii: «Min njiɗaa o laamoo min.» ");
INSERT INTO ffm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Nde mo lamminaa so mo warti ndee, mo yamiri mo noddanee kaadime'en ɓe mo halfini jawdi ɓee, faa mo annda ko gooto maɓɓe fuu tinorii e jaagu mum oo. ");
INSERT INTO ffm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Arano oo wari, wii: «Kalfaaɗo, mutakal maa ngal tinike mutakal sappo.» ");
INSERT INTO ffm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","O wii ɗum: «Golle maa gasii sanne kaadime lobbo. Nde wonnoo a hoolnike e ko famɗi, mi lamminii ma geelle sappo.» ");
INSERT INTO ffm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ɗiɗaɓo oo wari, wii: «Kalfaaɗo, mutakal maa ngal tinike mutakal joy.» ");
INSERT INTO ffm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","O wii: «Aan duu, mi lamminii ma geelle joy.» ");
INSERT INTO ffm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Caggal ɗum, goɗɗo kasen wari, wii: «Kalfaaɗo, annii mutakal maa, mi piɓunooɗo ngal e fetalaare ");
INSERT INTO ffm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","sabi miɗo hule. Sabi a gorko ɲaaɗuɗo, aɗa ɓama ko a resaali, aɗa hetta ɗo a aawaali.» ");
INSERT INTO ffm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","O wii ɗum: «Dara! Haalaaji maa jaati cariran-maa-mi, aan kaadime laaliiɗo. Aɗa anndi mi gorko ɲaaɗuɗo, mi ɓaman ko mi resaali, mi hettan ɗo mi aawaali. ");
INSERT INTO ffm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ko saabii so a waɗaali jawdi am ndii e ley banki, yalla ana daɲa ko keɓu-mi hen so mi wartoyii?» ");
INSERT INTO ffm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Caggal ɗum, kalfaaɗo oo wii kaadime'en mum ɓee: «Teetee mo mutakal ngal, ndokkon ngal jogiiɗo mutakal sappo oo.» ");
INSERT INTO ffm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ɓe mbii mo: «Kalfaaɗo, kanko, omo jogii mutakal sappo.» ");
INSERT INTO ffm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","O wii: «Miɗo haalana on, jogiiɗo fuu ɓeydante, kaa mo walaa, fay seeɗa mo jogii oo teetete. ");
INSERT INTO ffm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kaa wayɓe am ɓe njiɗaa mi laamoo ɗum'en ɓee, ngaddee ɓe ɗoo, mbaron ɓe yeeso am.» ");
INSERT INTO ffm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Nde Iisaa tilinoo haalde ɗum ndee, ardii woɓɓe ɓee, ŋabbiti fa'i Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nde o ɓadinoo Baytifaaji e Baytaniya hedde waamnde haayre wiyeteende Jaytun, o neli taalibaaɓe makko ɗiɗon, ");
INSERT INTO ffm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","o wii ɓe: —Njehee, naatoyee e ngeenndi ngonndi yeeso mon ndii, on tawan mola ndakiiwa nga fay gooto waɗɗaaki abada ana haɓɓii. Kumton nga, ngaddon nga ɗoo. ");
INSERT INTO ffm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","So won biiɗo on, «Ko saabii so oɗon kumta nga?» mbiyon ɗum hono nii: «Moobbo ana haajaa nga.» ");
INSERT INTO ffm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nelaaɓe ɓee njehi, tawri no o wiiri ɗum'en nii. ");
INSERT INTO ffm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","E ley humtugol maɓɓe mola ngaa, jeyɓe mola ngaa ɓee mbii: —Ko kumtirton mola ngaa? ");
INSERT INTO ffm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɓe njaabii, ɓe mbii: —Moobbo ana haajaa nga. ");
INSERT INTO ffm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nii ɓe naɓani Iisaa mola ngaa, ɓe njappi e magga saayaaji maɓɓe, o waɗɗii. ");
INSERT INTO ffm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","No o yaarata nii, ɓe mbeerti saayaaji maɓɓe dow laawol ngol. ");
INSERT INTO ffm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Nde o faandii Urusaliima ndee, hedde jipporde waamnde haayre wiyeteende Jaytun, tawi taalibaaɓe ɓee fuu ana keewi seyo, ndarii ana njetta Laamɗo e daande toownde, saabe deental kaayɗe ɗe ɓe njiinoo ɗee. ");
INSERT INTO ffm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Eɓe mbiya: —Barke woodanii kaananke gardoowo e dow innde Joomiraaɗo! Jam dow kammu. Teddeengal woodanii Laamɗo Toowɗo! ");
INSERT INTO ffm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yoga e Farisa'en tawaaɓe e jamaa oo ɓee mbii mo: —Moobbo, haja taalibaaɓe maa ɓee! ");
INSERT INTO ffm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","O jaabii ɓe, o wii: —Miɗo haalana on, so kamɓe ɓe ndeƴƴii, kaaƴe ɗee ngattata wullude! ");
INSERT INTO ffm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nde o ɓadinoo, so o yii ngeenndi ndii ndee, o woyi ndi, ");
INSERT INTO ffm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","o wii: —So aan duu, aɗa anndunoo hannde ko hokkete jam…! Kaa jooni, ɗum suuɗaama e gite maa. ");
INSERT INTO ffm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ɲalaaɗe ngaran nde wayɓe maa moƴƴinta cuuɗorɗe, pile, ɓille, ");
INSERT INTO ffm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ngurjine, kalke aan e ɓiɓɓe maa fuu. Ɓe njoppataa e maa fay haayre wootere ana fawii dow wonnde, sabi a annditaali wakkati mo Laamɗo wari faabaade ma oo. ");
INSERT INTO ffm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Caggal ɗum, o naati daalaare Suudu Dewal Mawndu nduu, o darii omo ribba jaagotooɓe, ");
INSERT INTO ffm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","omo wiya ɗum'en: —Ana winndii: «Suudu am laatoto rewrudu Laamɗo», kaa onon, on ngaɗii ndu suuɗorde yanooɓe. ");
INSERT INTO ffm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iisaa ana waajoo ɲannde fuu ley Suudu Dewal Mawndu nduu. Hooreeɓe yottinooɓe sadaka e dunkee'en Sariya e mawɓe leɲol ngol ɓee ana ndaara no masinbinira mo, ");
INSERT INTO ffm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","kaa ɓe ndonkii heɓude laawol, sabi yimɓe ɓee ana ngattani haalaaji makko ɗii hakkille faa sanne. ");
INSERT INTO ffm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ɲannde wootere Iisaa ana janngina yimɓe ley daalaare Suudu Dewal Mawndu nduu. E ley no o jannginirta ɓe Kabaaru Lobbo oo nii, mawɓe ɓee e hooreeɓe yottinooɓe sadaka e dunkee'en Sariya ngari e makko, ");
INSERT INTO ffm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","mbii mo: —Yamiroore hende ngollirtaa ko ngollataa koo? Homo yamir maa ngollaa ɗum? ");
INSERT INTO ffm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Iisaa jaabii ɓe, wii: —Miin duu, huunde wootere tan lamndotoo-mi on. Njaabo-ɗon kam ɗum: ");
INSERT INTO ffm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","lootogal batisimaYaayaa ngal, to Laamɗo iwri naa to yimɓe? ");
INSERT INTO ffm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ɓe ndawridi hakkunde maɓɓe, ɓe mbii: —So en mbii to Laamɗo, o wiyan: «Ndennoo ko saabii so on ngoonɗinaali Yaayaa?» ");
INSERT INTO ffm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kaa so en mbii «yimɓe», jamaa oo wedoto en kaaƴe, sabi ɓe fuu eɓe taƴori Yaayaa yo annabaajo. ");
INSERT INTO ffm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Non ɓe njaabii ɓe anndaa to lootogal batisima Yaayaa iwri. ");
INSERT INTO ffm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iisaa wii ɓe: —Haya miin duu, mi haalantaa on yamiroore nde ngolliran-mi ko ngollan-mi koo. ");
INSERT INTO ffm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Iisaa fuɗɗi haalande yimɓe ngol banndol, wii: —Neɗɗo gooto tuti ngesa peguuje, hasiri nga remooɓe, dawi. O ɓooyi e dawol makko ngol. ");
INSERT INTO ffm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nde teɓugol yottinoo, o neli golloowo makko to remooɓe ɓee too, ɓe ngaddanoya mo ngeɗu makko e ɓiɓɓe peguuje ɗee. Kaa remooɓe ɓee pii nelaaɗo oo, mbirfini ɗum juuɗe teete. ");
INSERT INTO ffm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","O neli e maɓɓe golloowo goɗɗo, ɓe pii oon duu, ɓe koyni ɗum, ɓe mbirfini ɗum juuɗe teete. ");
INSERT INTO ffm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","O neli kasen golloowo tataɓo, ɓe mbarmini oon, ɓe ndibbi ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","E oon wakkati, jom ngesa oo wii: «Hono ngaɗan-mi? Ooho, mi nelan ɓiyam gorko korsuɗo oo, yaama ɓe njaagoo mo!» ");
INSERT INTO ffm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kaa nde remooɓe ɓee njiinoo ɓiɗɗo oo ndee, mbiyondiri hakkunde mum'en: «Oo woni donoowo mo, mbaren mo, keddoro-ɗen ngesa ngaa!» ");
INSERT INTO ffm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɓe mbedii mo to caggal ngesa too, ɓe mbari mo. Jooni nee, hono jom ngesa oo waddata e maɓɓe? ");
INSERT INTO ffm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","O waran, o halka remooɓe ɓee, o hasira ngesa ngaa woɓɓe. Nde yimɓe ɓee nannoo ɗum ndee, mbii: —Pati hono majjum laato! ");
INSERT INTO ffm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Iisaa ƴeewi ɓe, wii: —Ndennoo, koɗum woni maanaa ko winndii koo: «Haayre nde mahooɓe ɓee tippitii ndee, kaɲum laatii haayre ɓurnde fuu teentilaade e maadi ndii»? ");
INSERT INTO ffm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Neɗɗo fuu caamɗo e nden haayre, helan. Neɗɗo fuu mo nde saami e mum, noƴoto. ");
INSERT INTO ffm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dunkee'en Sariya e hooreeɓe yottinooɓe sadaka paamii banndol ngol e mum'en fewti. Ɓe njiɗiino nanngude mo ɗon e ɗon, kaa ɓe kulii yimɓe. ");
INSERT INTO ffm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dunkee'en Sariya e hooreeɓe yottinooɓe sadaka ngattani Iisaa hakkille, neli horooɓe nanndinkiniiɓe e moƴƴuɓe, yalla ana keɓa e haala makko laawol, ngaɗa mo e juuɗe goforneer laamiiɗo leydi ndii oo, sara ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ɓeen lamndii mo: —Moobbo, miɗen anndi ko kaalataa koo e ko mbaajoto-ɗaa koo yo goonga, miɗen anndi a ɓurdintaa yimɓe, aɗa jannginira laawol Laamɗo ngol goonga. ");
INSERT INTO ffm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Minen nee, ana dagoo min ndokka kaananke Roma mawɗo oo lampo naa dagaaki? ");
INSERT INTO ffm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nde wonnoo o faamii hiila maɓɓe kaa, o wii ɓe: ");
INSERT INTO ffm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Kollee kam mbuuɗu cardi! Natal homo e innde homo woni ɗoo? Ɓe mbii: —Kaananke Roma. ");
INSERT INTO ffm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Caggal ɗum, o wii ɓe: —Ndennoo ndokkee kaananke Roma oo ko jey, ndokkee Laamɗo duu ko jey. ");
INSERT INTO ffm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɓe ndonki heɓude laawol e ko mo haalata yeeso yimɓe koo, jaabu makko oo haaynii ɓe, ɓe ndeƴƴinii. ");
INSERT INTO ffm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Yoga e waalde Saduki'en ngari e Iisaa. Kamɓe ngoni fennuɓe immital. Ɓe lamndii mo, ɓe mbii: ");
INSERT INTO ffm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Moobbo, Muusaa yamirii en, so neɗɗo ɓamii debbo, maayii, heɓaali ɓiɗɗo, miɲum naa mawnum ɓamta debbo oo, yalla ana heɓana maayɗo oo ɓeyngu. ");
INSERT INTO ffm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Waɗiino e ɓettaade rimdaaɓe njeɗɗon. Arano oo ɓami debbo, maayi, heɓaali ɓiɗɗo. ");
INSERT INTO ffm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ɗiɗaɓo oo ɓamti debbo oo, maayi, ");
INSERT INTO ffm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","tataɓo oo jokki hen. Hono nii njeɗɗon ɓee fuu ɓamiri mo, ɗalaali ɓiɗɗo. ");
INSERT INTO ffm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Caggal maɓɓe ɓe fuu, debbo oo duu maayi. ");
INSERT INTO ffm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ndennoo, ɲannde immital, homo e maɓɓe debbo oo laatotoo jom suudu mum? Sabi ɓe njeɗɗon fuu ɓe ɓamiino mo. ");
INSERT INTO ffm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Iisaa jaabii ɓe, wii: —Yimɓe oo jamaanu ana ɓama, ana ɓamee. ");
INSERT INTO ffm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kaa haandinaaɓe e nguurndam janngo, kaɲum e immitagol ɓee, ɓamataa, ɓamataake, ");
INSERT INTO ffm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","sabi ɓe mbaawaa maayde kasen. Ɓe laatoto no malaa'ika'en nii, ɓe ɓiɓɓe Laamɗo, sabi ɓe immitike e maayde. ");
INSERT INTO ffm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Kaa ko maayɓe immitoto koo, fay Muusaa sappike ɗum e ley haala wuutuure. Sabi ton o noddiri Joomiraaɗo oo «Laamɗo Ibarahiima e Laamɗo Isiyaaka e Laamɗo Yaakuuba.» ");
INSERT INTO ffm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Laamɗo yo Laamɗo wuurɓe, wanaa Laamɗo maayɓe. Sabi banngal makko yimɓe fuu yo wuurɓe! ");
INSERT INTO ffm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yoga e dunkee'en Sariya mbii: —Moobbo, a haalii goonga. ");
INSERT INTO ffm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Caggal ɗum, ɓe cuusaali lamndaade mo fay huunde. ");
INSERT INTO ffm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iisaa wii ɓe: —Hono ɓe mbaawiri wiide Almasiihu yo taanii Daawuuda? ");
INSERT INTO ffm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Daawuuda e hoore mum wii e ley dewtere mum Jabuura: «Joomiraaɗo wii Joomam: Jooɗa ɲaamo am, ");
INSERT INTO ffm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","faa mi waɗa njaɓɓaa wayɓe maa.» ");
INSERT INTO ffm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Daawuuda «Joomam» noddirta mo, ndennoo, hono mo laatortoo taanum tan? ");
INSERT INTO ffm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nde wonnoo yimɓe ɓee fuu ana kettindanoo mo, o wii taalibaaɓe makko ɓee: ");
INSERT INTO ffm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Ndeentee e dunkee'en Sariya yiɗuɓe yiiloraade saayaaji mawɗi e jowteede ley luumooji, fooɗantooɓe joolle ɓurɗe teddude e ley cuuɗi baajorɗi e ley yanngeeji fuu. ");
INSERT INTO ffm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Eɓe teeta cuuɗi rewɓe talka'en ɓe worɓe mum'en maayi, eɓe njuutina duwaawuuji maɓɓe faa ɓe nanndinkinoo e moƴƴuɓe. Kamɓe, jukkungo naawngo ɓurata jippineede e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iisaa hunci gite, yii arsukunte'en ana ngaɗa sadakaaji mum'en e keesu sadaka oo. ");
INSERT INTO ffm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mo yii debbo misikiino mo gorum maayi, kaɲum duu ana waɗa hen buuɗi ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","E ley ɗum, o wii: —Miɗo haalana on goonga: oo debbo misikiino, ko o waɗi e ley keesu oo koo, ɓuri ko ɓee too fuu ngaɗi hen koo. ");
INSERT INTO ffm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sabi ɓe fuu, ko bonnantaa ɓe huunde tan ɓe ngaɗi hen, kaa kanko debbo oo, ko o hasindini e mum o waɗi hen, ko o jogii faa o wuurda koo fuu. ");
INSERT INTO ffm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Won yogaaɓe ana kaala haala Suudu Dewal Mawndu nduu, no ndu ŋarɗiniraa kaaƴe e kulle cakkaaɗe. Nden Iisaa wii: ");
INSERT INTO ffm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ko njiyaton koo, wakkati waran nde fay haayre wootere heddataako ɗoo ana fawii dow wonnde, fuu wurjinte. ");
INSERT INTO ffm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ɓe lamndii mo, ɓe mbii: —Moobbo, humpitin min nde ɗum waɗata. Taagumansa homo hollata waɗugol kuɗɗe ɗee fuu? ");
INSERT INTO ffm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","O wii: —Ndeentee pati on ƴoɲɲe. Heewɓe ngardan innde am, mbiya: «Miin woni kanko», «Wakkati oo ɓadike». Pati njokkee ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","So on nanii golowole e murtereeji, pati kulee. Ana tilsi ɗum waɗa tafon, kaa ɗum wanaa timmooɗe ɗon e ɗon. ");
INSERT INTO ffm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","O jokki wiide: —Leɲol haɓan e leɲol, laamu haɓan e laamu, ");
INSERT INTO ffm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","dimmbanɗe leydi mawɗe e yolbereeji ngaɗan, ɲawuuji bonɗi ngaran e nokkuuje yogaaje, kulle kulɓiniiɗe e taagumansaaji mawɗi ɓanngan dow kammu. ");
INSERT INTO ffm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kaa gila ɗum fuu ɗum waɗaali, yimɓe nanngan on, torra on cara on ley cuuɗi baajorɗi, mbede-ɗon e kasu, naɓe-ɗon yeeso kaanankooɓe e sarooɓe saabe am. ");
INSERT INTO ffm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ɗum hokkan on seettanaade kam. ");
INSERT INTO ffm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Piɓee anniya e ɓerɗe mon mbaason lanndinanaade no ndanndirton ko'e mon, ");
INSERT INTO ffm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","sabi mi hokkan on waawde haala, mi hokkan on hakkilantaaku ko wayɓe mon ɓee fuu mbaawaa salaade naa yeddude. ");
INSERT INTO ffm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Saaraaɓe mon e sakiraaɓe mon e koreeji mon e giɗiraaɓe mon, kaɲum'en njammbotoo on, mbara yoga e mon. ");
INSERT INTO ffm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yimɓe fuu mbaɲan on saabe am, ");
INSERT INTO ffm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kaa fay leembol ko'e mon majjataa. ");
INSERT INTO ffm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Muɲal mon ndanndirton yonkiiji mon. ");
INSERT INTO ffm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Nde njii-ɗon Urusaliima ana filaa konuuji fuu, anndee helde mum ɓadike. ");
INSERT INTO ffm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Oon wakkati, ɓe ɗum tawi Yahuudiya fuu, yo ndogu peewa baamle kaaƴe, ɓe ɗum tawi e ley ngeenndi ndii fuu, yo njaltu e mayri, tawaaɓe ladde duu, pati naattu ngeenndi ndii. ");
INSERT INTO ffm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sabi ɗeen ɲalaaɗe yo ɲalaaɗe yoɓtagol, faa ko winndii koo fuu tabita. ");
INSERT INTO ffm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bone woodanii haamili'en e muyninooɓe ley ɗeen ɲalaaɗe! Sabi torraaji mawɗi njanan e leydi ndii, jukkungo jippoo e leɲol ngol. ");
INSERT INTO ffm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ɓe camminirte kaafaawi, ɓe nanngee, ɓe naɓee hakkunde heeferɓe. Ɓeen ndippan e Urusaliima faa nde wakkati mum'en timmi. ");
INSERT INTO ffm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Taagumansaaji ngaɗan e naange e lewru e koode. Kulol waɗan e leydi ndii, faa leɲi ɗii fuu mbemmbee saabe dillere geeci e bempeeje mum. ");
INSERT INTO ffm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Yimɓe moɗoto saabe kulol so miilike albalaawu jippotooɗo e aduna oo, sabi fay kulle gonɗe dow kammu ɗee ndimmboto. ");
INSERT INTO ffm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","E oon wakkati, Ɓii Neɗɗo oo yiyete, ana wara e duule, ana warda baawɗe e teddeengal manngal. ");
INSERT INTO ffm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Onon, so ɗum fuɗɗii waɗude, ceyo-ɗon, njoonndoro-ɗon soottiteede mon ɓadike. ");
INSERT INTO ffm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Caggal ɗum, o haalani ɓe ngol banndol: —Taykitee ibbe e leɗɗe goɗɗe ɗee fuu. ");
INSERT INTO ffm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","So on njii ɗe mbillitii, oɗon anndi onon e ko'e mon, ndunngu ɓadike. ");
INSERT INTO ffm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hono non, so on njii ɗeen kulle ana ngaɗa, anndee Laamu Laamɗo oo ɓadike. ");
INSERT INTO ffm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Miɗo haalana on goonga: oo jamaanu timmataa, tawee kuɗɗe ɗee fuu ngaɗaali. ");
INSERT INTO ffm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kammu e leydi timman, kaa haalaaji am ɗii timmataa abada. ");
INSERT INTO ffm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—Ndeenee ko'e mon pati ɓerɗe mon metta, so kebbinoro-ɗon yaraawo faa cigiron, so cuŋlanon aduna, so ɲannde gartol Almasiihu ndee juhira on ");
INSERT INTO ffm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","no piccal nii. Sabi ende wara dow yimɓe aduna fuu. ");
INSERT INTO ffm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ndennoo, njeerto-ɗon wakkati fuu, nduwo-ɗon, yalla oɗon keɓa daɗude e ɗeen kulle gaɗooje fuu, mbaawon daraade yeeso Ɓii Neɗɗo oo. ");
INSERT INTO ffm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ɲalooma, Iisaa ana waajoo ley Suudu Dewal Mawndu nduu, jemma, o yaltan, o waaloya dow waamnde haayre wiyeteende Jaytun. ");
INSERT INTO ffm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Yimɓe fuu ana immoo, ana njaha to Suudu Dewal Mawndu too gila beetee kecco faa kettindanoo mo. ");
INSERT INTO ffm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Wakkati iidi mo buuru ƴuufinaaka biyeteeɗo Paska oo ɓadike. ");
INSERT INTO ffm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Hooreeɓe yottinooɓe sadaka e dunkee'en Sariya ɓee ana tewta no mbarda Iisaa, kaa eɓe kula yimɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nden Ibiliisa naati e Yahuuda annditirteeɗo Isikariyota, jeyaaɗo e sappo e ɗiɗon ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahuuda yehi haaldoyi e hooreeɓe yottinooɓe sadaka e haybooɓe Suudu Dewal Mawndu nduu no o waɗira Iisaa e juuɗe mum'en. ");
INSERT INTO ffm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ɓe ceyii, ɓe podani mo ɓe njeenan mo kaalisi. ");
INSERT INTO ffm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O jaɓi, omo fiya dabare no o jammbortoo Iisaa tawa yimɓe ɓee kumpitaaki. ");
INSERT INTO ffm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Iidi mo buuru ƴuufinaaka, nde ɓe mboownoo hirsude jawɗi Paska ndee, yottii. ");
INSERT INTO ffm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nden Iisaa neli Piyeer e Yuhanna, wii ɗum'en: —Njehee lanndinanee en hiraande iidi Paska faa ɲaamen. ");
INSERT INTO ffm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ɓe lamndii mo: —Hoto njiɗ-ɗaa min lanndinoyoo nde? ");
INSERT INTO ffm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","O wii ɓe: —Ƴeewee, so on naatii ngeenndi ndii, on kawran ton e gorko, ana roondii mbulku ndiyam. Njokkee e makko faa e galle ɗo mo naatata ɗoo, ");
INSERT INTO ffm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mbiyon jom galle oo: «Moobbo wii suudu hondu ɲaamdata e taalibaaɓe mum ɓee hiraande iidi Paska?» ");
INSERT INTO ffm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","O hollan on sooro manngo paraango, ton lanndinanto-ɗon en ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ɓe njehi, ɓe tawri hono no o wii ɓe nii, ɓe lanndinii hiraande Paska ndee. ");
INSERT INTO ffm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nde wakkati oo yottinoo ndee, o jooɗii kanko e sappo e ɗiɗon ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","O wii ɓe: —Miɗo yiɗi ɲaamdude e mon sanne hiraande Paska ndee, gila mi torraaka. ");
INSERT INTO ffm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Sabi miɗo wiya on: mi hiirtataako nde kasen faa ɲannde nde nde tabiti ley Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","O ɓami horde, o yetti Laamɗo, o wii: —Nanngee ɗum, peccee ɗum e hakkunde mon ");
INSERT INTO ffm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","sabi miɗo wiya on: mi yarataa peguujam kasen faa nde Laamu Laamɗo waroyi. ");
INSERT INTO ffm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kasen, o ɓami buuru, o yetti Laamɗo, o helti, o hokki ɓe, o wii: —Ɗum yo terɗe am cakkiraaɗe kammari mon, ngaɗee ɗum faa miccito-ɗon kam. ");
INSERT INTO ffm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hono non duu, nde ɓe tilii hiraande ndee, o ɓami horde peguujam, o hokki ɓe, o wii: —Ndee ɗoo horde woni aadi keyri. Aadi ndii tabintiniraama ƴiiƴam am njupportooɗam saabe mon. ");
INSERT INTO ffm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Kaa jammbotooɗo kam oo ana ɲaamda e am e la'al gootal. ");
INSERT INTO ffm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Waajibi Ɓii Neɗɗo ɗalira aduna no fodiranaa nii. Kaa bone woodanii jammbotooɗo mo oo! ");
INSERT INTO ffm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Hedde eɓe lamndondira hakkunde maɓɓe homo e maɓɓe gollata oo golle. ");
INSERT INTO ffm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nii taalibaaɓe ɓee ndarii ana njeddondira hakkunde mum'en homo ɓuri teddude. ");
INSERT INTO ffm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Iisaa wii ɓe: —Kaanankooɓe ana ndonna laamu mum'en dow leɲi mum'en. Jom'en doole e maɓɓe ɓee duu ana njiɗi noddireede sooninkooɓe. ");
INSERT INTO ffm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kaa onon, wanaa non ɗum laatortoo hakkunde mon. Ko kaan-ɗon laataade dee, ɓurɗo teddude e mon yo laato hono cukalel, ardiiɗo laatoo hono golloowo. ");
INSERT INTO ffm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Homo ɓuri teddude, jooɗiiɗo faa ɲaama naa ɓattinoowo ɲaamdu? Wanaa ɲaamoowo oo naa? Kaa miin, miɗo wa'i hakkunde mon no ɓattinoowo ɲaamdu nii. ");
INSERT INTO ffm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Onon ngoni wonduɓe e am e ley ko koro am ittetee koo fuu. ");
INSERT INTO ffm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Kammari ɗum, miin duu, mi hokkii on laamu no Baabiraaɗo am hokkiri kam laamu nii, ");
INSERT INTO ffm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","faa ɲaamden, njarden e la'al am ley laamu am, njooɗo-ɗon e dow jooɗorɗe kaanankooɓe, caron cuuɗi baaba Israa'iila sappo e ɗiɗi ɗii. ");
INSERT INTO ffm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, Ibiliisa ɲaagike faa seɗa on no alkama seɗirtee nii. ");
INSERT INTO ffm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kaa mi ɲaaganike ma pati goonɗinal maa mursee. Aan, so a wartii e am, ngaɗaa e sakiraaɓe maa ɓee semmbe. ");
INSERT INTO ffm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Piyeer wii mo: —Kalfaaɗo, mi lanndinike naɓdeede e maa kasu e wardeede e maa! ");
INSERT INTO ffm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kaa Iisaa wii: —Piyeer, miɗo haalane: fade ndontoori jogginde hannde a wiyan a anndaa kam cili tati. ");
INSERT INTO ffm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","O wii ɓe kasen: —Nde nelunoo-mi on rafi dannga e mbasu e paɗe, won ko ɲaki on naa? Ɓe mbii: —Walaa! ");
INSERT INTO ffm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","O wii ɓe: —Jooni kaa, jogiiɗo dannga ɓama, jogiiɗo mbasu naɓora, mo walaa kaafaawi, sootta saaya mum sooda ngooti. ");
INSERT INTO ffm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Sabi ana winndii mi hiisodete e bonɓe. Miɗo wiya on: ana tilsi ɗum hewtoo kam. Ko cappanaa-mi koo fuu goonɗan. ");
INSERT INTO ffm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɓe mbii: —Kalfaaɗo, kaafaaje ɗiɗi annii! O wii ɓe: —Heƴii! ");
INSERT INTO ffm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iisaa yalti, fa'i waamnde haayre wiyeteende Jaytun no o woowiri nii. Taalibaaɓe makko ɓee njokki e makko. ");
INSERT INTO ffm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Nde o yottinoo ndee, o wii ɓe: —Nduwee pati on ceyte. ");
INSERT INTO ffm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Caggal ɗum, o toowtiri ɓe ko waarata e wedannde haayre, o diccii, omo duwoo, ");
INSERT INTO ffm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","omo wiya: —Baaba, so a muuyii, woɗɗinam ndee horde bone. Kaa pati laatoo sago am, laatoo sago maa aan! ");
INSERT INTO ffm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Oon wakkati fuu, malaa'ika iwruɗo dow kammu ɓanngani mo, hokki mo semmbe. ");
INSERT INTO ffm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","O ruubi faa walaa seese, o ɓeydii tekkinde duwaawu makko, nguli makko ana toɓɓa e leydi no toɓɓe ƴiiƴam nii. ");
INSERT INTO ffm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nde o tilii duwaade ndee, o wirfitii e taalibaaɓe makko ɓee, o tawi eɓe ɗaanii saabe terɗe baatuɗe. ");
INSERT INTO ffm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","O wii ɓe: —Koɗum ɗaanoto-ɗon? Immee nduwo-ɗon, pati on ceyte! ");
INSERT INTO ffm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Omo e haala kaa faa jamaa wari. Biyeteeɗo Yahuuda, gooto e sappo e ɗiɗon ɓee, ardii ɓe. Yahuuda ɓattitii Iisaa faa ɓuuccoo ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Iisaa wii mo: —Yahuuda, ɓuccaango njammborto-ɗaa Ɓii Neɗɗo oo naa? ");
INSERT INTO ffm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nde wonduɓe e Iisaa ɓee njii ko waɗata koo ndee, mbii: —Kalfaaɗo, min coppa ɓe kaafaaje naa? ");
INSERT INTO ffm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Non gooto maɓɓe soppi golloowo Jottinoowo Sadaka Mawɗo taƴi nowru mum ɲaamuru. ");
INSERT INTO ffm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Iisaa jaabii, wii: —Ɗaldee nii! O memi nowru kaadime oo, o sellini ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iisaa haalani warɓe nanngude ɗum ɓee, mawɓe ɓee e hooreeɓe yottinooɓe sadaka e haybooɓe Suudu Dewal Mawndu ɓee, wii: —Ko ngardu-ɗon e kaafaaje e cabbi faa nanngon kam hono mi janoowo? ");
INSERT INTO ffm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ɲannde fuu miɗo wondunoo e mon ley Suudu Dewal Mawndu nduu, on pawaali e am junngo. Kaa jooni yo wakkati mon, jooni yo wakkati mo nimre laamotoo. ");
INSERT INTO ffm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ɓe nanngi Iisaa, ɓe ngusi ɗum faa ley galle Jottinoowo Sadaka Mawɗo. Piyeer jokkitii mo fali daawre hakkunde maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yiite huɓɓanooma hakkunde daalaare galle oo, Piyeer wari jooddii e jooɗiiɓe ton ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Korɗo gooto yii omo fewti e fooyre ndee, taykitii mo faa gasi, wii: —Oo duu e makko wondunoo. ");
INSERT INTO ffm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Nii Piyeer yeddi mo, wii: —Banndam debbo, mi anndaa mo fey. ");
INSERT INTO ffm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nde ɓooynoo seeɗa, goɗɗo yii mo, wii: —Aan duu e maɓɓe njeye-ɗaa! Piyeer wii oon: —Giɗo, mi jeyaaka e maɓɓe! ");
INSERT INTO ffm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Faa waɗi leer caggal mum, goɗɗo kasen immini haala kaa, wii: —Taƴoral, kanko duu omo wondunoo e makko, sabi o Galilinke. ");
INSERT INTO ffm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piyeer jaabii, wii: —Giɗo, mi faamataa ko kaalataa koo! O tilaaki haalde, faa ndontoori joggini. ");
INSERT INTO ffm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nden Iisaa yeeccitii, ƴeewi Piyeer. Non Piyeer miccitii konngol ngol Iisaa haalannoo ɗum ngol: «Fade ndontoori jogginde hannde, a wiyan a anndaa kam cili tati.» ");
INSERT INTO ffm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","O yalti sella, o darii omo woya faa omo heppiƴa. ");
INSERT INTO ffm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Yimɓe nannguɓe Iisaa ɓee ndarii ana njaayra ɗum, ana piya ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ɓe cuddi yeeso makko, eɓe lamndoo mo, eɓe mbiya: —Annditin homo fii maa! ");
INSERT INTO ffm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Hedde eɓe mbiya mo bihiile bonɗe. ");
INSERT INTO ffm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nde weetunoo ndee, waalde Saahiiɓe ndee hawriti, ɗum woni mawɓe leɲol ngol e hooreeɓe yottinooɓe sadaka e dunkee'en Sariya. Iisaa waddaa yeeso maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ɓe mbii ɗum: —So aan woni Almasiihu oo, haalan min. O wii ɓe: —Fay so mi wii on non, on njaɓataa. ");
INSERT INTO ffm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","So mi lamndike on duu, on njaabataako. ");
INSERT INTO ffm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kaa gila jooni, Ɓii Neɗɗo oo jooɗoyto ɲaamo Laamɗo, Jom Baawɗe oo. ");
INSERT INTO ffm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɓe fuu ɓe mbii: —Ndennoo a Ɓii Laamɗo naa? O wii ɓe: —No mbii-ɗon nii. ");
INSERT INTO ffm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ɓe mbii: —En kaajaaka seedee hankasen, nde wonnoo o haaldii hunduko makko, en fuu en nanii! ");
INSERT INTO ffm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Caggal ɗum, waalde Saahiiɓe ndee fuu immii, naɓi Iisaa to Pilaatu goforneer oo. ");
INSERT INTO ffm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ɓe ndarii eɓe ngullanoo mo, eɓe mbiya: —Min tawii oo ana jirkita leɲol amen, ana haɗa ɗum yoɓude kaananke Roma oo lampo, ana wiya hoore mum yo Almasiihu, ɗum woni kaananke. ");
INSERT INTO ffm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilaatu lamndii mo, wii: —Aan woni kaananke Yahuudiyankooɓe oo naa? O jaabii, o wii: —No mbii-ɗaa nii. ");
INSERT INTO ffm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilaatu jaɓɓitii, wii hooreeɓe yottinooɓe sadaka e jamaa oo fuu: —Mi yiyaali e makko daliili fuu ko jukkata mo. ");
INSERT INTO ffm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kaa ɓe cattini e haala maɓɓe faa sanne, eɓe mbiya: —Ko o waajotoo koo ana murtina yimɓe ley leydi Yahuudiya fuu, gila Galili to o fuɗɗiri too faa ɗoo. ");
INSERT INTO ffm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Nde Pilaatu nanunoo ɗum ndee, lamndii yalla o Galilinke naa? ");
INSERT INTO ffm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","O faami Iisaa e laamu Hirudus iwata, o neldi ɗum Hirudus. Sabi e ley ɗen ɲalaaɗe tawi Hirudus ana Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nde Hirudus yii Iisaa ndee, weltii hen sanne, sabi ɓooyii omo yiɗi yiide ɗum saabe ko mo nannoo e mum koo. Kasen duu omo yeloo yiide ɗum ana waɗa kaayɗe. ");
INSERT INTO ffm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","O lamndii ɗum lamndi keewɗi, kaa Iisaa jaabaaki fay huunde. ");
INSERT INTO ffm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Hooreeɓe yottinooɓe sadaka e dunkee'en Sariya ndarii ɗon, ana ngullanoo mo ko mbaawi fuu. ");
INSERT INTO ffm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hirudus duu hoyni mo, jaayri mo, kaɲum e sordaasi'en mum, ɓoorni mo saaya lobba, neltiri mo Pilaatu. ");
INSERT INTO ffm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ɲannde mum Pilaatu e Hirudus laatii giɗiraaɓe, arannde ɓe honnondirnooɓe. ");
INSERT INTO ffm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilaatu noddi hooreeɓe yottinooɓe sadaka e mawɓe ɓee e yimɓe fuu, ");
INSERT INTO ffm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","wii ɗum'en: —On ngaddanii kam oo neɗɗo jirkitoowo yimɓe. Mi lamndike mo yeeso mon, kaa ko ngullaniri-ɗon mo koo fuu, mi yiyaali hen daliili ko jukkata mo. ");
INSERT INTO ffm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hirudus duu yiyaali e makko fay huunde, sabi o neltirii en mo. Anndee, oo gorko waɗaali fay huunde ko warata ɗum. ");
INSERT INTO ffm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ndennoo, mi fiyan mo, mi yoppita mo.  ");
INSERT INTO ffm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ɓe fuu ɓe ngullidi daande wootere, ɓe mbii: —War mo, njoppitanaa min Barabas! ");
INSERT INTO ffm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas nee yo uddiranooɗo kasu saabe murtere waɗunoonde e ngeenndi ndii, e saabe war-hoore. ");
INSERT INTO ffm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilaatu haaldi e maɓɓe cilol ɗiɗaɓol dow yiɗude yoppitinde Iisaa, ");
INSERT INTO ffm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","kaa ɓe ndarii eɓe ngulla, eɓe mbiya: —Tontu mo! Tontu mo e leggal bardugal! ");
INSERT INTO ffm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilaatu wii ɓe tataɓol: —Koɗum o waɗi ko boni? Mi yiyaali e makko daliili fuu ko haani warde mo! Ndennoo, mi fiyan mo, mi yoppita mo. ");
INSERT INTO ffm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kaa ɓe ɓeydii wullude gullaali mawɗi, eɓe mbiya o tontee. Gullaali maɓɓe ɗii njaalii Pilaatu, ");
INSERT INTO ffm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","o fellisi waɗande ɓe ko ɓe ɲaagii koo. ");
INSERT INTO ffm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","O yoppitani ɓe mo ɓe ɲaagii yoppitee oo, oon yo uddiranooɗo kasu saabe murtere e war-hoore. Kaa Iisaa, o waɗi ɗum e juuɗe maɓɓe, faa ɓe ngaɗa ɗum ko weli ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nde ɓe naɓata mo ndee, ɓe nanngi gorko Sireenanke biyeteeɗo Simon, iwruɗo ley ladde. Ɓe mbakkini ɗum leggal bardugal ngal faa jokka e caggal Iisaa. ");
INSERT INTO ffm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Yimɓe heewɓe njokki hen. Rewɓe duu ana hakkunde maɓɓe, ana mboya no ɗum foti mettude ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Iisaa yeeccitii rewɓe ɓee, wii ɗum'en: —Rewɓe Urusaliima, pati mboyee kam, mboyee ko'e mon e ɓiɓɓe mon! ");
INSERT INTO ffm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sabi ɲalaaɗe ngaran nde yimɓe mbiyata: «Rewɓe rimarɓe e deeɗi ɗi caawaali abada e enɗi ɗi muyninaali, mbelii hoore!» ");
INSERT INTO ffm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nden, yimɓe mbiyan baamle kaaƴe caama dow mum'en, mbiya tule cudda ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sabi so ɓe ngaɗii nii gila caɓal ngal keccal, hono laatotoo so ngal yoorii? ");
INSERT INTO ffm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ɓe naɓidi e Iisaa yimɓe ɗiɗon yanooɓe. Ɓeen duu yo wareteeɓe. ");
INSERT INTO ffm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Nde ɓe njottinoo nokku biyeteeɗo Laalagal Hoore ndee, ɓe tonti mo e leggal bardugal, kanko e yanooɓe ɗiɗon ɓee, gooto ɲaamo makko, goɗɗo oo nano makko. ");
INSERT INTO ffm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","O wii: —Baaba, yaafa ɓe sabi ɓe anndaa ko ɓe ngaɗata. Nii ɓe pecciri kaddule makko urwa. ");
INSERT INTO ffm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yimɓe ndarii ɗon ana ƴeewa. Hooreeɓe ɓee duu ndarii ana njaayra mo, ana mbiya: —O biltii woɓɓe, o bilta hoore makko so o Almasiihu, Cuɓaaɗo Laamɗo oo! ");
INSERT INTO ffm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sordaasi'en ɓee duu njaayri mo, ngaddani mo biineegiri, ");
INSERT INTO ffm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ana mbiya: —So aan woni kaananke Yahuudiyankooɓe oo, biltu hoore maa! ");
INSERT INTO ffm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tawi ana winndii e tiimde hoore makko: OO YO KAANANKE YAHUUDIYANKOOƁE. ");
INSERT INTO ffm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Gooto e yanooɓe ɗiɗon tontidaaɓe e makko ɓee ana ɲiŋa mo, ana wiya: —Wanaa aan woni Almasiihu naa? Biltu hoore maa, mbiltaa min minen duu! ");
INSERT INTO ffm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kaa goɗɗo oo jahii e oo too, wii: —A hulataa Laamɗo naa? Aan e makko fuu, on potu jukkungo. ");
INSERT INTO ffm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Enen, en keɓii ko kaandu-ɗen, jukkeede men yo goonga jaati, sabi ko ngollu-ɗen tan njoɓete-ɗen. Kaa kanko, o waɗaali fay huunde ko dagaaki. ");
INSERT INTO ffm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Caggal ɗum, o wii: —Iisaa, miccito-ɗaa kam so a laatitike kaananke. ");
INSERT INTO ffm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Iisaa wii mo: —Miɗo haalane goonga: hannde jaati a wondoyan e am ley alijenne. ");
INSERT INTO ffm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wakkati hakkunde naange, nimre waɗi e leydi ndii fuu faa wakkati yamnde tati kiikiiɗe, ");
INSERT INTO ffm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","naange niɓɓi, heedoode faliinde ley Suudu Dewal Mawndu ndee seekii, laatii taƴe ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Iisaa wulli wullaango manngo, wii: —Baaba, mi tummbii yonki am kii e junngo maa. O haali ɗum tan, o ɗali aduna. ");
INSERT INTO ffm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Nde hooreejo sordaasi'en oo yii ko waɗi koo ndee, yetti Laamɗo, wii: —So goonga nii, oo neɗɗo yo pooccitiiɗo! ");
INSERT INTO ffm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jamaa garnooɗo ƴeewde oo fuu, nde yiinoo ko waɗi koo ndee, wirfitii terɗe mum ana mbaati. ");
INSERT INTO ffm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Kaa annduɓe mo ɓee fuu, ndarii to toowti ana ƴeewa. Rewɓe jokkunooɓe e makko gila leydi Galili ɓee ana e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Gorko gooto ana jeyaa e waalde Saahiiɓe ndee, ana wiyee Yuusufu. Omo iwa Arimatiya, ngootiri e geelle leydi Yahuudiya. O gorko moƴƴo, pooccitiiɗo, omo doomunoo ɓanngugol Laamu Laamɗo oo. O tawdaaka e waalde Saahiiɓe ndee haala e golle. ");
INSERT INTO ffm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","O yehi to Pilaatu, o ndaardi ɗum tew Iisaa, ");
INSERT INTO ffm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","o jippini ɗum leggal bardugal ngal, o fiili ɗum e kasanke, o watti ɗum e yanaande asaande ley haayre, ɗo fay gooto meeɗaali watteede. ");
INSERT INTO ffm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɗum hawri e ɲannde lanndinal tawi ɲalaande fowteteende ɓadike fuɗɗude. ");
INSERT INTO ffm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Rewɓe wondunooɓe e Iisaa gila Galili ɓee njokki e Yuusufu, njii yanaande ndee e no o wattiraa ley mayre, ");
INSERT INTO ffm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","kooti, moƴƴinoyi nebameeji uurooji. Caggal ɗum, ɓe powti ɲalaande fowteteende no yamiroore ndee wiiri nii. ");
INSERT INTO ffm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Beetee law ɲannde alan, ɓe pahi to yanaande too, tawi ɓe naɓorii nebameeji uurooji ɗi ɓe moƴƴinnoo ɗii. ");
INSERT INTO ffm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ɓe tawi haayre ndee tallitaama, ittaama e damal yanaande ndee, ");
INSERT INTO ffm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","kaa nde ɓe naatunoo ndee, ɓe tawaali ton tew Iisaa, Moobbo oo. ");
INSERT INTO ffm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","E ley no hakkille maɓɓe jirkitorii nii, worɓe ɗiɗon ndarii yeeso maɓɓe, ana ɓoornii kaddule jalbooje. ");
INSERT INTO ffm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nii kulol nanngi ɓe, ɓe tuggi tiiɗe maɓɓe e leydi. Oon wakkati worɓe ɓee mbii ɓe: —Ko saabii so oɗon tewta guurɗo hakkunde maayɓe? ");
INSERT INTO ffm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","O walaa ɗoo, o immitike. Miccitee ko o haalannoo on leydi Galili koo ");
INSERT INTO ffm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","nde o wii: «Ana tilsi Ɓii Neɗɗo oo waɗee e juuɗe luuttooɓe, tontee e leggal bardugal, immitoo ɲannde tataɓere.» ");
INSERT INTO ffm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Nii ɓe miccitii haala Iisaa kaa. ");
INSERT INTO ffm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ɓe iwi to yanaande too, ɓe mbirfitii ɓe kaalanoyi ɗum sappo e go'o ɓee e woɓɓe ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɓeen rewɓe ngoni: Mariyama mo Magdala e Yowanna e Mariyama inna Yaakuuba. Kamɓe e rewɓe wondunooɓe e maɓɓe ɓee kaalani ɗum nelaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nelaaɓe ɓee njogorii haala maɓɓe kaa yo meere, calii goonɗinde ɓe, ");
INSERT INTO ffm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","kaa Piyeer immii, dogani yanaande ndee. Nde o yuurninoo ndee, kasanke oo tan o yii. Caggal ɗum, o hooti galle maɓɓe, o bemmbaaɗo saabe ko waɗi koo. ");
INSERT INTO ffm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","E oon ɲalooma jaati, ɗiɗon e taalibaaɓe ɓee nanngi laawol wuro wiyeteengo Emmayus. Hakkunde ngoon wuro e Urusaliima ana waara e kilooji sappo e go'o. ");
INSERT INTO ffm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Eɓe ngaajodoo ko waɗi koo fuu. ");
INSERT INTO ffm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","E ley gaajaate maɓɓe ɗee eɓe ndokkondira hakkillaaji, nii Iisaa e hoore mum hewtii ɓe, waddi e maɓɓe jaadal. ");
INSERT INTO ffm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kaa heedoode waɗaa e gite maɓɓe pati ɓe anndita mo. ");
INSERT INTO ffm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","O wii ɓe: —Koɗum ngaajoto-ɗon e laawol mon ngol? Non ɓe ndarii, terɗe maɓɓe mbaati. ");
INSERT INTO ffm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Gooto e maɓɓe biyeteeɗo Kiliyopas jaabii mo, wii: —Aan tan gooto woni koɗo ley Urusaliima mo anndaa ko waɗi e ley ɲalaaɗe ɗee koo naa? ");
INSERT INTO ffm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","O wii ɓe: —Koɗum? Ɓe mbii mo: —Ko waɗi e Iisaa Nasaraatunke oo koo. O annabaajo, jom baawɗe ley haala makko e golle makko yeeso Laamɗo e yimɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kaa hooreeɓe yottinooɓe sadaka e mawɓe men ngaɗi mo e juuɗe laamu yalla omo jukkee jukkungo maayde, tonti mo e leggal bardugal. ");
INSERT INTO ffm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Miɗen njikkunoo kanko soottitotoo Israa'iila. Hannde woni ɲalooma tataɓo ko ɗum waɗi. ");
INSERT INTO ffm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kasen, yoga e rewɓe amen kaaynii min. Ɓe njehi to yanaande too beetee law, ");
INSERT INTO ffm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ɓe tawaali ton tew makko, ɓe ngarti, ɓe mbii malaa'ika'en ɓannganii ɓe, mbii omo wuuri. ");
INSERT INTO ffm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Caggal ɗum, yoga e wondiiɓe amen njaaɓe to yanaande too ɓee, tawri no rewɓe ɓee mbiiri nii, kaa kanko e hoore makko, ɓe njiyaali mo. ");
INSERT INTO ffm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Oon wakkati Iisaa wii ɓe: —Hey onon famarɓe hakkille! Ɓooyii on ngoonɗinaali haala annabaaɓe! ");
INSERT INTO ffm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Wanaa ana tilsi Almasiihu torree, naata e teddungal mum naa? ");
INSERT INTO ffm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nden o fammini ɓe ko Binndi ɗii fuu kaali haala makko, gila e Tawreeta Muusaa faa e dewte annabaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nde ɓe paandii wuro ngo ɓe immanii ngoo ndee, Iisaa waɗi hono o anniyiiɗo ɓettaade nii. ");
INSERT INTO ffm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nii ɓe ɲaagii mo, ɓe mbii: —Heddoda e amen, sabi hiirii, jemma warii. O jokki e maɓɓe, o jippanii ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nde ɓe njooɗinoo eɓe ɲaama ndee, o ɓami buuru, o yetti Laamɗo, o helti buuru oo, o hokki ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Non gite maɓɓe peerti, ɓe annditi mo. Ɗon e ɗon o iwi e gite maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gooto fuu darii ana wiya goɗɗo: —Nde o haaldata e men e laawol ngol omo fammina en Binndi ɗii ndee, wanaa ɓerɗe men ɓuuɓii naa? ");
INSERT INTO ffm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ɗon e ɗon, ɓe immii ɓe mbirfitii Urusaliima, ɓe tawtoyi ton sappo e go'o ɓee e wondiiɓe mum'en ana kawriti. ");
INSERT INTO ffm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ɓeen mbii: —Goonga, Kalfaaɗo men Iisaa wuurtii, o ɓannganii Simon. ");
INSERT INTO ffm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɗiɗon ɓee duu njantanii ɓe ko waɗunoo e laawol mum'en, e no annditiri mo nde o helti buuru ndee. ");
INSERT INTO ffm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ɓe tilaaki haalde, faa Iisaa e hoore mum darii hakkunde maɓɓe, wii ɓe: —Onon e jam! ");
INSERT INTO ffm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ɓe kuli, ɓe ɗemƴii, ɓe miili ko ɓe njii koo yo mbeelu. ");
INSERT INTO ffm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Non o wii ɓe: —Ko hulɓini on? Ko saabii so oɗon miila ɗii miilooji e ɓerɗe mon? ");
INSERT INTO ffm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ƴeewee juuɗe am e koyɗe am, ɗum miin jaati. Memee kam, ƴeewon. Sabi mbeelu walaa tew, walaa gi'e no am nii. ");
INSERT INTO ffm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nde o haalata ɗum ndee, o holli ɓe juuɗe makko e koyɗe makko. ");
INSERT INTO ffm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Nde wonnoo ɓe ndonkii goonɗinde saabe seyo e kaayɗe, o wii ɓe: —Oɗon njogii ɗoo ko ɲaametee naa? ");
INSERT INTO ffm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɓe ngaddani mo tayre liingu cahaaɗo, ");
INSERT INTO ffm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","o nanngi nde, o ɲaami yeeso maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Caggal ɗum, o wii ɓe: —Ko Tawreeta Muusaa e dewte annabaaɓe e Jabuura cappii e am koo fuu, ana tilsi ɗum goonɗa. Ɗum jaati woni ko kaalannoo-mi on nde ngondunoo-mi e mon ndee. ");
INSERT INTO ffm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Oon wakkati, o udditi hakkillaaji maɓɓe, yalla eɓe paama Binndi ɗii. ");
INSERT INTO ffm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","O wii ɓe: —Ana winndii Almasiihu oo torrete faa maaya, immitoto hakkunde maayɓe ɲalooma tataɓo. ");
INSERT INTO ffm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ana winndii kasen: saabe makko leɲi ɗii fuu ooynante faa tuuba, keɓa yaafaamuya luutti. Ɗum ana fuɗɗa gila Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Onon ngoni seettotooɓe kulle ɗee! ");
INSERT INTO ffm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Miin, mi neldan on ko Baabiraaɗo am fodi koo fuu. Kaa keddee e ngalluure ndee, faa nde baawɗe gonɗe dow ɗee njippii e mon fuu. ");
INSERT INTO ffm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Iisaa naɓi ɓe faa hedde Baytaniya, hunci juuɗe, duwanii ɓe. ");
INSERT INTO ffm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɗo o duwantoo ɓe ɗoo, o seerti e maɓɓe, o ŋabbinaa dow kammu. ");
INSERT INTO ffm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ɓe cujidani mo, caggal ɗum, ɓe mbirfodii Urusaliima e seyo manngo. ");
INSERT INTO ffm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Wakkati fuu eɓe tawee ley Suudu Dewal Mawndu nduu, eɓe njetta Laamɗo.");
INSERT INTO ffm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","E puɗɗooɗe biyeteeɗo Konngol ana woodi. Biyeteeɗo Konngol oo ana wondi e Laamɗo, o Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Omo wondi e Laamɗo gila puɗɗooɗe. ");
INSERT INTO ffm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","E makko Laamɗo tagiri huunde fuu. Fay huunde e ko woodi koo, tagaaka so wanaa e makko. ");
INSERT INTO ffm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","E makko nguurndam woni, ɗam nguurndam laatanii yimɓe fooyre. ");
INSERT INTO ffm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Fooyre ndee ana yaayna ley nimre. Nimre ndee waawaa ɲifude nde. ");
INSERT INTO ffm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Waɗiino e wakkati, Laamɗo nelii neɗɗo biyeteeɗo Yaayaa. ");
INSERT INTO ffm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","O seedee garɗo haalde haala ndeen fooyre oo, yalla yimɓe fuu ana ngoonɗinira saabe haala makko kaa. ");
INSERT INTO ffm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Wanaa kanko woni fooyre ndee, kaa o seedee garɗo haalde haala mayre oo. ");
INSERT INTO ffm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kayre woni fooyre goongaraare warnde ley aduna faa yaaynana yimɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Biyeteeɗo Konngol oo ana ley aduna, kanko woni taguɗo aduna oo, kaa aduna oo annditaali mo. ");
INSERT INTO ffm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mo warii e leɲol makko, kaa leɲol makko jaɓɓaaki mo. ");
INSERT INTO ffm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kaa jaɓɓiiɓe mo so ngoonɗini mo ɓee, o hokkii ɗum'en baawɗe laataade ɓiɓɓe Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ɓeen yo rimraaɓe ko wanaa muuyo terɗe, ko wanaa muuyo gorko, kamɓe ɓe rimraaɓe iwrude to Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Konngol ngol laatii neɗɗo. Oon hoɗidi e meeɗen, o keewɗo hinnee e goonga. Min njii teddeengal makko, teddeengal hono ngal Bajjo heɓata e baam mum. ");
INSERT INTO ffm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yaayaa seettanike mo, eewnii, wii: —Kanko woni mo kaalannoo-mi on haala mum oo, mbii-mi: «Caggal am ardiiɗo kam waran, sabi omo woodi gila mi tagaaka.» ");
INSERT INTO ffm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","No hinnee makko foti heewde, en fuu en keɓii, hinnee dow hinnee. ");
INSERT INTO ffm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Saabe Muusaa keɓir-ɗen Sariya, kaa hinnee e goonga saabe Iisaa Almasiihu heɓiraa. ");
INSERT INTO ffm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Fay gooto yiyaali Laamɗo abada. Jonnoo, Ɓiɗɗo bajjo gonduɗo e Baabiraaɗo oo, kaɲum humpiti en mo. ");
INSERT INTO ffm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","YahuudiyankooɓeUrusaliima neli Lewinkooɓe e yottinooɓe sadaka to Yaayaa lamndoo kaɲum woni homo. ");
INSERT INTO ffm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","O jaabii ɓe ko selli: —Miin, mi wanaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ɓe lamndii mo, ɓe mbii: —Aan, a homo? A annabi Iliyaasa naa? O wii: —Mi wanaa. Ɓe mbii: —A Annabaajo oo naa? O jaabii: —Mi wanaa! ");
INSERT INTO ffm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɓe mbii mo: —A homo ndennoo? Haalan min ko min kaaltanoya neluɓe min ɓee. Ko njogori-ɗaa hoore maa? ");
INSERT INTO ffm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","O jaabii, o wii: —Miin woni «ooynotooɗo ley ladde jeereende so ana wiya: moƴƴintinee laawol Joomiraaɗo», hono no annabi Esaaya wiiri nii. ");
INSERT INTO ffm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nelaaɓe ɓee to Farisa'en iwri. ");
INSERT INTO ffm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ɓe lamndii mo: —Ko saabii so aɗa loota yimɓe lootogal batisima, tawi a wanaa Almasiihu a wanaa Iliyaasa a wanaa Annabaajo oo? ");
INSERT INTO ffm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yaayaa jaabii ɓe, wii: —Miin, miɗo batisira ndiyam, kaa won dariiɗo hakkunde mon mo on anndaa. ");
INSERT INTO ffm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Kanko, o waran caggal am. Miin, mi fotaa fay e humtude ɓoggi paɗe makko. ");
INSERT INTO ffm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ɗum waɗii Baytaniya ootoo bannge maayo Urdun, ɗo Yaayaa batisannoo ɗoo. ");
INSERT INTO ffm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Janngo mum, Yaayaa yii Iisaa ana wara e mum, wii: —Annii, njawdiri Laamɗo ndoondotoondi luutti aduna. ");
INSERT INTO ffm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɗum woni ko mbiinoo-mi e makko: «Neɗɗo waran caggal am, ardiiɗo kam, sabi omo woodi gila mi tagaaka.» ");
INSERT INTO ffm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Miin, mi anndaano mo, kaa mi warii miɗo batisira ndiyam yalla omo ɓanngana Israa'iilankooɓe. ");
INSERT INTO ffm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yaayaa seettii, wii: —Mi yii Ruuhu hono wuugaandu ana jippoo iwde dow kammu faa hoɗi dow makko. ");
INSERT INTO ffm_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Miin, mi anndaano mo. Kaa nelɗo kam mi batisira ndiyam oo, kaɲum wii kam: «Oon mo njiyataa Ruuhu ana jippoo dow mum oo, kaɲum woni batisiroowo Ruuhu Ceniiɗo.» ");
INSERT INTO ffm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Miin, mi yii, mi seettike kanko woni Ɓii Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Janngo mum kasen Yaayaa ana dardii e taalibaaɓe mum ɗiɗon. ");
INSERT INTO ffm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","O yii Iisaa ana ɓettoo, o wii: —Annii, njawdiri Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Taalibaaɓe ɗiɗon ɓee nani ko o haali koo, njokkitii Iisaa. ");
INSERT INTO ffm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Iisaa yeeccitii, yii eɓe njokki e mum, wii ɓe: —Koɗum tewtaton? Ɓe njaabii, ɓe mbii: —Rabbii (ɗum woni «Moobbo»), hoto njooɗoto-ɗaa? ");
INSERT INTO ffm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","O wii ɓe: —Ngaree ƴeewee! Nden ɓe ngari, ɓe njii ɗo o jooɗotoo ɗoo. Ɓe ngondi e makko oon ɲalooma. Ɗum waɗii wakkati kiikiiɗe. ");
INSERT INTO ffm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andire miɲii Simon Piyeer oo yo gooto e ɗiɗon nanɓe haala Yaayaa so njokkitii Iisaa ɓee. ");
INSERT INTO ffm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mawniiko Simon o adii fuu hawrude, o wii ɗum: —Min njii Almasiihu. (Ɗum woni Cuɓaaɗo.) ");
INSERT INTO ffm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","O naɓi ɗum to Iisaa. Iisaa ƴeewi Simon, wii ɗum: —Aan, Simon ɓii Yuhanna mbiyete-ɗaa, caggal jooni a innditirte Kefas. (Kefas e Piyeer fuu gootum. Maanaa majjum yo haayre.) ");
INSERT INTO ffm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Janngo mum, Iisaa anniyii yaade Galili. O hawri e Filipa, o wii ɗum: —Jokkam! ");
INSERT INTO ffm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipa ana jeyaa Baytisayda, ngalluure nde Andire e Piyeer fuu njeyaa e mum ndee. ");
INSERT INTO ffm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipa hawri e Natanayel, wii ɗum: —Min tawii mo haala mum winndaa ley Tawreeta Muusaa e ley dewte annabaaɓe oo. O Iisaa Nasaraatunke ɓii Yuusufu oo. ");
INSERT INTO ffm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanayel wii mo: —Ko moƴƴi ana waawi iwrude Nasaraatu naa? Filipa jaabii mo: —War ƴeew! ");
INSERT INTO ffm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iisaa yii Natanayel ana feewi ɗum, wii: —Oo yo Israa'iilanke jaati, kutee fuu walaa e makko. ");
INSERT INTO ffm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanayel wii mo: —Hoto anndu-ɗaa kam? Iisaa jaabii mo, wii: —Mi yii ma ley ibbi gila Filipa noddaali ma. ");
INSERT INTO ffm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanayel jaabii, wii: —Moobbo, a Ɓii Laamɗo, a kaananke Israa'iila. ");
INSERT INTO ffm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Iisaa jaabii mo, wii: —Saabe mi wii mi yii ma ley ibbi koo tan ngoonɗinir-ɗaa naa? A yiyan ko ɓuri ɗum haaynaade. ");
INSERT INTO ffm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Nden o wii Natanayel: —Miɗo haalana on goonga: on njiyan kammu ana udditoo, on njiyan malaa'ika'en Laamɗo ana ŋabba ana njippoo dow Ɓii Neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Balɗe ɗiɗi caggal mum, kuurtungu waɗi ley ngalluure wiyeteende Kaana ley leydi Galili. Inna Iisaa ana tawanoo ton. ");
INSERT INTO ffm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Iisaa e taalibaaɓe mum duu noddaama ngara kawra e kuurtungu oo. ");
INSERT INTO ffm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nde peguujam maɓɓe timmunoo ndee, inna Iisaa wii: —Ɓe ngalaa peguujam. ");
INSERT INTO ffm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Iisaa jaabii mo, wii: —Tama aan haalanta kam ko kaan-mi waɗude? Wakkati am yonaali tafon. ");
INSERT INTO ffm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Inniiko wii gollooɓe ɓee: —Ko o yamiri on fuu, ngaɗon. ");
INSERT INTO ffm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kaaƴe jeegom, asiiɗe faa laatii hono pakaaje mawɗe ɗo Yahuudiyankooɓe lootetee faa laɓɓinee banngal diina, ana ngonnoo ton. Honde fuu ana naanna bulki sappo ndiyam. ");
INSERT INTO ffm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Iisaa wii ɓe: —Kebbinee pakaaje ɗee ndiyam. Ɓe kebbini ɗe faa ɗe keewi. ");
INSERT INTO ffm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","O wii ɓe: —Jooni kaa, ɲeɗee naɓanee hooreejo kuurtungu oo. Ɓe naɓi. ");
INSERT INTO ffm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nde hooreejo oo meeɗunoo ndiyam mbaylitaaɗam peguujam ɗam ndee, annditaali to ɗam ittaa. Kaa gollooɓe ɲeɗuɓe ndiyam ɗam ɓee ana anndi. O noddi jommbaajo gorko oo, ");
INSERT INTO ffm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","o wii ɗum: —Yimɓe fuu peguujam mbelɗam mboowi adoraade. Nde yimɓe cigirii, nden ɗam welaa ɗam yaretee. Kaa aan, aɗa resi mbelɗam ɗam faa jooni. ");
INSERT INTO ffm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nii Iisaa golliri haaynde mum aranndeere ley ngalluure Kaana ley leydi Galili. O ɓanngini baawɗe makko, taalibaaɓe makko ɓee ngoonɗini mo. ");
INSERT INTO ffm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Caggal ɗum, o iwi Kaana, o yehi ngalluure wiyeteende Kafarnahum, kanko e inniiko e miɲiraaɓe makko e taalibaaɓe makko. Ɓe paɓɓi ton balɗe seeɗa. ");
INSERT INTO ffm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nde iidi Yahuudiyankooɓe biyeteeɗo Paska oo ɓadinoo ndee, Iisaa ŋabbiti Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","O tawi ley daalaare Suudu Dewal Mawndu nduu julaaɓe ga'i e baali e soottooɓe buugaaji, kaɲum e weccooɓe kaalisi ana njooɗii. ");
INSERT INTO ffm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","O nanngi ɓoggi, o sowi, o ribbi ɓe fuu ɓe njalta Suudu Dewal Mawndu nduu, kamɓe e ga'i maɓɓe e baali maɓɓe. O sankiti kaalisi weccooɓe, o hippi taabe maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","O wii soottooɓe buugaaji ɓee: —Ittee ɗum ɗoo, pati ngaɗee suudu Baabiraaɗo am nduu soottirdu. ");
INSERT INTO ffm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Taalibaaɓe makko ɓee miccitii ko Binndi ɗii mbii koo: «Jilli suudu maa laatanike kam sugulla.» ");
INSERT INTO ffm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nden hooreeɓe Yahuudiyankooɓe mbii mo: —Haaynde honde kollataa min aɗa foti waɗude ko ngaɗ-ɗaa koo? ");
INSERT INTO ffm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Iisaa jaabii ɓe, wii: —Ngurjinee Suudu Dewal nduu. So on ngurjinii ndu, on njiyan miɗo mahitoo ndu ley balɗe tati. ");
INSERT INTO ffm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ɓe njaabii mo: —Nduu suudu mahiraama duuɓi capanɗe nay e jeegom. Dee aan, a mahitoto ndu ley balɗe tati naa? ");
INSERT INTO ffm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kaa Iisaa hoore mum wappiri suudu nduu. ");
INSERT INTO ffm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nde Iisaa wuurtunoo ndee, taalibaaɓe mum ɓee miccitii o haaliino ɗum. Ɓe ngoonɗini ko Binndi ɗii mbii koo e konngol o haalnoo ngol. ");
INSERT INTO ffm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nde Iisaa faɓɓoynoo Urusaliima iidi Paska ndee, heewɓe ngoonɗini mo saabe njii kaayɗe ɗe o waɗi ɗee. ");
INSERT INTO ffm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kaa Iisaa hoolaaki ɓe faa hokkita ɓe hoore mum, sabi omo anndi ɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","O hasindinaa fay gooto seettanoo mo ko woni e yimɓe, nde wonnoo omo humpitii ko woni e ɓii-aadama. ");
INSERT INTO ffm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Won gorko Farisanke biyeteeɗo Nikodemus, gooto e hooreeɓe Yahuudiyankooɓe. ");
INSERT INTO ffm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Oon gorko yehi to Iisaa jemma, wii ɗum: —Moobbo, miɗen anndi a jannginoowo iwruɗo to Laamɗo, sabi fay gooto waawaa waɗude hono kaayɗe ɗe ngaɗataa ɗee so Laamɗo wondaa e mum. ");
INSERT INTO ffm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Iisaa jaabii mo, wii: —Miɗo haalane goonga: fay gooto waawaa yiide Laamu Laamɗo tawee rimtaaka kasen. ");
INSERT INTO ffm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus wii mo: —Hono mawɗo waawiri rimtireede? Omo waawi naattude e reedu inniiko, o rimtee kasen naa? ");
INSERT INTO ffm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Iisaa jaabii: —Miɗo haalane goonga: so wanaa neɗɗo rimtiree ndiyam e Ruuhu so heɓa naatude e Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ko ɓii-aadama rimata koo yo ɓii-aadama. Ko Ruuhu oo rimata koo yo ruuhu. ");
INSERT INTO ffm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pati ɗum haayne saabe mi wii ma kinaa ndimte-ɗon kasen. ");
INSERT INTO ffm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Henndu ana wibba ɗo muuyiri fuu. Aɗa nana dillere mayru, kaa a anndaa to ndu iwri, a anndaa to ndu yahata. Hono non oon dimraaɗo Ruuhu oo worri. ");
INSERT INTO ffm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus wii mo: —Hono hen ɗum laatortoo? ");
INSERT INTO ffm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iisaa jaabii mo: —Aan, jannginoowo ley Israa'iila oo fuu, a anndaa ɗum naa? ");
INSERT INTO ffm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Miɗo haalane goonga: minen, ko min anndi min kaalata, ko min njii min ceettotoo, kaa onon, on njaɓataa seedaaku amen. ");
INSERT INTO ffm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","On ngoonɗinaali nde kaalan-mi on haala kulle leydi ndee. Hono ngoonɗinirton so mi haalanii on haala kulle dow kammu? ");
INSERT INTO ffm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Fay gooto ŋabbaali dow kammu, so wanaa oon iwruɗo dow kammu oo, ɗum woni Ɓii Neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hono no Muusaa toowniri mboddi jakawalle ley ladde jeereende nii, so wanaa Ɓii Neɗɗo oo duu toowniree hono non, ");
INSERT INTO ffm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","yalla goonɗinɗo mo fuu ana heɓa nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Sabi Laamɗo ɓamii ana yiɗa aduna oo faa hokkitiri Ɓiyum bajjo, yalla goonɗinɗo Bajjo oo fuu ana waasa naatude yiite, heɓa nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Laamɗo neliraali Ɓiyum oo e aduna faa Ɓiyum oo saroo aduna oo. Ko mo neliraa dee, faa aduna oo hisira saabe makko. ");
INSERT INTO ffm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Goonɗinɗo mo fuu sarataake. Mo goonɗinaali fuu tilike sareede, sabi goonɗinaali Ɓii Laamɗo bajjo oo. ");
INSERT INTO ffm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sariya oo annii: fooyre warii e aduna, kaa yimɓe, nimre cuɓii dow fooyre saabe golleeji mum'en bonɗi. ");
INSERT INTO ffm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bonɗo tagu yiɗaa fooyre, warataa e mayre, hulde pati golleeji mum bonɗi ɓanngu. ");
INSERT INTO ffm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kaa goongirante waran e fooyre yalla golleeji ɗi waɗiri saabe Laamɗo ɗii ana ɓannga. ");
INSERT INTO ffm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Caggal mum, Iisaa yaadi e taalibaaɓe mum leydi Yahuudiya. O faɓɓidi e maɓɓe ton, omo loota yimɓe lootogal batisima. ");
INSERT INTO ffm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yaayaa duu ana batisa to Aynon too bannge Salim, sabi cewle ana keewi ton. Yimɓe ana ngara ana mbatisee. ");
INSERT INTO ffm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Tawi Yaayaa nannganooka tafon. ");
INSERT INTO ffm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Taalibaaɓe Yaayaa ɓee njeddondiri e Yahuudiyanke haala laaɓal. ");
INSERT INTO ffm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ɓe njehi to Yaayaa, ɓe mbii ɗum: —Moobbo, gorko gondunooɗo e maa ootoo bannge maayo Urdun mo ceettani-ɗaa oo, kanko duu omo batisa, yimɓe fuu ana njaha to makko. ");
INSERT INTO ffm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yaayaa jaabii ɓe, wii: —Neɗɗo waawaa heɓude fay huunde so wanaa ko Laamɗo hokki ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Onon e ko'e mon, on seedee'en am mi wii mi wanaa Almasiihu, kaa miɗo adii mo neleede. ");
INSERT INTO ffm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Gaddanaaɗo jommbaajo debbo, kaɲum woni jommbaajo gorko. Dammbidiiɗo gorko oo ana darii, ana hettindii. So o nanii daande jommbaajo gorko oo, o seyoto sanne. Nii seyo am ngoo hiɓɓiri. ");
INSERT INTO ffm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","So wanaa kanko o toowa, so miin mi leyɗa. ");
INSERT INTO ffm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Oon iwruɗo dow, kaɲum tiimti yimɓe fuu. Iwɗo e leydi yo leydinke. Haalaaji mum duu yo haalaaji leydinkooji. Oon iwruɗo dow kammu, kaɲum tiimti yimɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ko o yii e ko o nani o seettotoo, kaa fay gooto jaɓataa seedaaku makko. ");
INSERT INTO ffm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Oon jaɓuɗo seedaaku makko, sellinii Laamɗo yo goongirante. ");
INSERT INTO ffm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Oon mo Laamɗo neli, ko Laamɗo haali haaltata, sabi Laamɗo hokkii mo Ruuhu mo walaa ɗo haaɗi. ");
INSERT INTO ffm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Baabiraaɗo oo ana yiɗi Ɓiɗɗo oo faa waɗi huunde fuu e junngo makko. ");
INSERT INTO ffm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Goonɗinɗo Ɓiɗɗo oo, heɓii nguurndam nduumiiɗam. Mo goonɗinaali Ɓiɗɗo oo, heɓataa ɗam, tikkere Laamɗo duu ana woodani ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisa'en nanii wiyaama Iisaa ana loota lootogal batisima ana heɓa taalibaaɓe faa ɓuri Yaayaa. ");
INSERT INTO ffm_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Tawi Iisaa e hoore mum kaa batisaali fay gooto. Taalibaaɓe makko ɓee tan mbatisannoo. ");
INSERT INTO ffm_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Nde Iisaa nannoo ko haalanoo e mum koo ndee, iwi leydi Yahuudiya, wirfitii leydi Galili, ");
INSERT INTO ffm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","kinaa o seeka leydi Samariya. ");
INSERT INTO ffm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","O wari e ngalluure Samariya wiyeteende Sikar bannge ngesa nga Yaakuuba hokkunoo ɓiyum Yuusufu ngaa. ");
INSERT INTO ffm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ɗon ɓunndu Yaakuuba nduu woni. Iisaa jooɗii daande ɓunndu nduu faa ŋoottinoo. Ɗum forrii e wakkati hakkunde naange. ");
INSERT INTO ffm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samariyanke debbo wari ƴoogude. Iisaa wii mo: —Hokkam ndiyam, mi yara no! ");
INSERT INTO ffm_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Tawi taalibaaɓe makko ɓee njehii to ngeenndi too soodoyde ɲaamdu. ");
INSERT INTO ffm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Debbo oo wii Iisaa: —Haa! Hono aan, Yahuudiyanke, ɲaagorto-ɗaa kam miin, Samariyanke, ndiyam njaraa? (Sabi Yahuudiyankooɓe e Samariyankooɓe yo harmondirɓe.) ");
INSERT INTO ffm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Iisaa jaabii mo: —Sinndo aɗa anndunoo no dokke Laamɗo poti e oon biiɗo ma ndokkaa ɗum ndiyam yara oo, a ɲaagotono mo, o hokke ndiyam nguurndam njaraa. ");
INSERT INTO ffm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Debbo oo wii mo: —Giɗo, a walaa cafirgal. Ɓunndu nduu ana luggiɗi. Hoto keɓataa ɗam ndiyam nguurndam? ");
INSERT INTO ffm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Aan, aɗa ɓuri njaatigi amen Yaakuuba dokkuɗo min ɓunndu nduu oo teddude naa? Kanko e ɓiɓɓe makko e daabaaji makko fuu, ɓe njarii e mayru. ");
INSERT INTO ffm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Iisaa jaabii mo: —Neɗɗo fuu jarɗo ɗam ndiyam ɗomɗan kasen, ");
INSERT INTO ffm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","kaa jarɗo ndiyam ɗam ndokkan-mi ɗum ɗam fuu, ɗomɗataa abada. Sabi ndiyam ndokkan-mi ɗum ɗam laatanto ɗum ndiyam iloojam nguurnoojam ɗum nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Debbo oo wii: —Giɗo, hokkam ɗam ndiyam pati mi ɗomɗa kasen, sako mi warta ƴoogude ɗoo kasen. ");
INSERT INTO ffm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Iisaa wii mo: —Yaa noddoy jom suudu maa, ngardon! ");
INSERT INTO ffm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Debbo oo jaabii mo: —Mi walaa jom suudu. Iisaa wii mo: —A haalii goonga ko mbii-ɗaa a walaa jom suudu koo. ");
INSERT INTO ffm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","A ɓamanooma worɓe njoyon. Gorko ngondu-ɗaa jooni oo duu, wanaa jom suudu maa. A haalii goonga. ");
INSERT INTO ffm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Debbo oo wii mo: —Moobbo, laaɓanii kam a annabaajo. ");
INSERT INTO ffm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Njaatiraaɓe amen ndewii Laamɗo e ndee waamnde haayre, kaa onon Yahuudiyankooɓe, oɗon mbiya to Urusaliima too Laamɗo haani reweede. ");
INSERT INTO ffm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Iisaa wii mo: —Banndam debbo, jaɓu ko kaalanan-maa-mi koo: wakkati waran, mo ndewaton Baabiraaɗo tawee wanaa e ndee waamnde haayre, wanaa e Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Onon Samariyankooɓe, oɗon ndewa ko on anndaa, kaa minen Yahuudiyankooɓe, ko min anndi min ndewata, sabi kisindam to Yahuudiyankooɓe iwrata. ");
INSERT INTO ffm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wakkati ana wara, mo yottike jaati, nde rewirooɓe Laamɗo goonga ɓee ndewirta ɗum Ruuhu e goonga. Hono ɓee rewooɓe Baabiraaɗo ndaarti. ");
INSERT INTO ffm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Laamɗo yo Ruuhu. Rewooɓe mo ɓee kinaa ndewira mo ruuhu e goonga. ");
INSERT INTO ffm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Debbo oo wii: —Miɗo anndi Cuɓaaɗo biyeteeɗo Almasiihu oo yo garoowo. Nde o warii, o humpitan min kulle fuu. ");
INSERT INTO ffm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Iisaa wii mo: —Miin kaaldoowo e maa oo woni kanko. ");
INSERT INTO ffm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","E dow ɗum taalibaaɓe makko ɓee njottii. Ko Iisaa haaldata e debbo oo koo haaynii ɓe, kaa fay gooto e maɓɓe wiyaali ɗum: «Ko ndaartataa? Ko kaaldataa e makko?» ");
INSERT INTO ffm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nden debbo oo yoppi mbulku mum ton, wirfitii ngeenndi haalanoyi yimɓe, wii: ");
INSERT INTO ffm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ngaree ƴeewee gorko kaaltanɗo kam ko ngannoo-mi fuu annii, yalla wanaa kanko woni Almasiihu? ");
INSERT INTO ffm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɓe njehi ƴeewoyde mo. ");
INSERT INTO ffm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Oon wakkati, taalibaaɓe ɓee ndaardi mo, ana mbiya: —Moobbo, tiinna ɲaamu! ");
INSERT INTO ffm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","O jaabii ɓe: —Miɗo jogii ko mi ɲaama ko on anndaa. ");
INSERT INTO ffm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Taalibaaɓe ɓee ana lamndondira: —Ɗum nee, won gaddanɗo mo ko ɲaametee naa? ");
INSERT INTO ffm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Iisaa wii ɓe: —Ɲaamdu am yo waɗude sago nelɗo kam oo e timminde golle makko. ");
INSERT INTO ffm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Onon, oɗon mbiya: «Faa hannde lebbi nay so kettal wara.» Kaa miin, miɗo wiya on: tippee gite mon, ƴeewee gese ɗee fuu ɓenndii, ɗe njonii hetteede. ");
INSERT INTO ffm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Kettuɗo heɓan ngeenaari, mooɓtana ɲamri ndii nguurndam nduumiiɗam, yalla aawuɗo e kettuɗo ana ceyodoo. ");
INSERT INTO ffm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ɗum tabintinta banndol biyoowol: «Gooto ana aawa, goɗɗo ana hetta.» ");
INSERT INTO ffm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mi nelii on kettoyon nga on tampanaali. Woɓɓe tampi. Onon, on ndaamitike e tampere maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samariyankooɓe heewɓe ley ndee ngalluure ngoonɗinii Iisaa saabe haala debbo ceettiiɗo so wii: «O haaltanii kam ko ngaɗunoo-mi fuu.» ");
INSERT INTO ffm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nde Samariyankooɓe ɓee njottinoo Iisaa ndee, ndaardi mo o faɓɓana ɗum'en. O waɗi ɗon balɗe ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yimɓe heewɓe ngoonɗini mo kasen faa ɓuri no arannde nii saabe konngol makko ngol. ");
INSERT INTO ffm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ɓe mbii debbo oo: —Jooni, wanaa saabe haalaaji maa ɗii tan min ngoonɗiniri. Ko min ngoonɗiniri dee, minen e ko'e amen, min nanii konngol makko, min anndi kanko jaati woni kisinoowo aduna oo. ");
INSERT INTO ffm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Caggal balɗe ɗiɗi ɗee, o iwi ton, o yehi Galili. ");
INSERT INTO ffm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Kanko e hoore makko o seettinoke: «Annabaajo teddintaake e ley suudu baam mum.» ");
INSERT INTO ffm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Nde o yottinoo Galili ndee, Galilinkooɓe njaɓɓorii mo juuɗe ɗiɗi, sabi kamɓe duu ɓe njehiino iidi Urusaliima, ɓe njiino ko o gollunoo ley iidi oo koo. ");
INSERT INTO ffm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nden Iisaa warti Kaana ley leydi Galili, ɗo mo waylitinnoo ndiyam o waɗi ɗam peguujam ɗoo. Howruujo kaananke mo ɓiyum sellaa ana ley Kafarnahum. ");
INSERT INTO ffm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nde howruujo oo nannoo Iisaa iwrii Yahuudiya wartii Galili ndee, yehi to Iisaa, ndaardi ɗum jippoo sellinoya ɓiyiiko kaɓanoowo yonki. ");
INSERT INTO ffm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Iisaa wii mo: —So on keɓaali finnde, on njiyaali kaayɗe, on ngoonɗintaa. ");
INSERT INTO ffm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Howruujo kaananke oo wii mo: —Moobbo, njehen gila ɓiyam oo maayaali. ");
INSERT INTO ffm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Iisaa wii mo: —Hootu, ɓiya oo sellii. Gorko oo goonɗini ko Iisaa wii ɗum koo, hooti. ");
INSERT INTO ffm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Gollooɓe makko kawriti e makko e laawol, kumpiti mo, mbii: —Ɓiya oo daɗii. ");
INSERT INTO ffm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","O lamndii ɓe wakkati homo suka o samtanaa. Ɓe mbii mo: —Sallifanaa keeɲen jonte ɗee njoppiti mo. ");
INSERT INTO ffm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Baaba suka oo annditi oon wakkati jaati Iisaa wiinoo ɗum: «Ɓiya oo sellii!» Nii kanko e koreeji makko fuu ɓe ngoonɗiniri Iisaa. ");
INSERT INTO ffm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ɗum woni haaynde ɗiɗaɓere nde Iisaa golli kasen leydi Galili nde iwnoo Yahuudiya. ");
INSERT INTO ffm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Caggal majjum, iidi Yahuudiyankooɓe ana waɗa. Iisaa ŋabboyi Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","To Urusaliima too, bannge dammbugal biyeteengal Dammbugal Baali ngal, luggal ndiyam ana ton. Engal wiyee Baytijata e ibaraninkoore. Danɗe joy ana pilii ngal. ");
INSERT INTO ffm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ɲawɓe heewɓe ana lelii ley ɗeen danɗe: wumɓe e wooyɓe e ɓe terɗe mum'en fuu mbaati.  ");
INSERT INTO ffm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Gorko ɲawɗo duuɓi capantati e jetti ana wonnoo ɗon. ");
INSERT INTO ffm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iisaa yii omo lelii, anndi o ɓooydii e ɲaw, lamndii mo: —Aɗa yiɗi sellude naa? ");
INSERT INTO ffm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɲawɗo oo jaabii mo, wii: —Moobbo, mi walaa fay gooto balloowo kam regaade e luggal ngal nde ndiyam ɗam jirkitike. Ɗo mbiyan-mi mi regike fuu, a tawan won adiiɗo kam jolde. ");
INSERT INTO ffm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Iisaa wii mo: —Imma, ɓamtu daɗɗo maa, yaa! ");
INSERT INTO ffm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ɗon e ɗon gorko oo selli, ɓamti daɗɗo mum fuɗɗiti yaade. Ɗum hawrii e ɲalaande fowteteende, ");
INSERT INTO ffm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","saabe majjum hooreeɓe Yahuudiyankooɓe mbii cellinaaɗo oo: —Hannde yo ɲalaande fowteteende, dagantaako ma ndoondo-ɗaa daɗɗo maa. ");
INSERT INTO ffm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","O jaabii ɓe: —Cellinɗo kam oo, kaɲum wii kam: «Ɓamtu daɗɗo maa, yaa!» ");
INSERT INTO ffm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɓe lamndii mo: —Homo woni oo neɗɗo biiɗo ma ɓamtu daɗɗo maa, yaa? ");
INSERT INTO ffm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kaa cellinaaɗo oo anndaano mo, sabi Iisaa iwii ɗon sabi yimɓe ana keewnoo e oon nokku. ");
INSERT INTO ffm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Caggal ɗum, Iisaa hawriti e makko ley Suudu Dewal Mawndu nduu, wii mo: —Ƴeew, jooni kaa, a sellii, pati luuttu kasen so ko ɓuri ɗum bonde heɓe. ");
INSERT INTO ffm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Gorko oo yehi haalanoyi hooreeɓe Yahuudiyankooɓe ɓee Iisaa woni cellinɗo ɗum oo. ");
INSERT INTO ffm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nden hooreeɓe Yahuudiyankooɓe puɗɗi torrude Iisaa sabi o waɗii ɗum e ɲalaande fowteteende. ");
INSERT INTO ffm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Iisaa wii ɓe: —Baabiraaɗo am ana golla faa jooni, miin duu, miɗo golla. ");
INSERT INTO ffm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nden hooreeɓe Yahuudiyankooɓe ɓeydi tewtude warde mo, wanaa saabe ko o bonnii ɲalaande fowteteende ndee koo tan, ko o wii kasen Laamɗo yo baam makko koo. O fonndii hoore makko e Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Iisaa wii ɓe: —Miɗo haalana on goonga: Ɓiɗɗo waawaa gollude fay huunde kaɲum tan, kinaa ko yii Baabiraaɗo ana golla. Sabi ko Baabiraaɗo oo gollata koo, ɗum Ɓiɗɗo oo duu gollata. ");
INSERT INTO ffm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Sabi Baabiraaɗo oo ana yiɗi Ɓiɗɗo oo, ana holla ɗum huunde fuu ko gollata. O hollan ɗum golleeji ɓurɗi ɗii ɗoo fuu teentilaade faa kaayne-ɗon. ");
INSERT INTO ffm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Sabi hono no Baabiraaɗo oo immintinirta maayɓe so hokka ɗum'en nguurndam nii, non Ɓiɗɗo oo duu hokkirta nguurndam mo muuyi hokkude. ");
INSERT INTO ffm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Baabiraaɗo oo, kaɲum kaa sarataa fay gooto, o waɗii sariya kaa fuu e junngo Ɓiɗɗo oo, ");
INSERT INTO ffm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","yalla yimɓe fuu ana teddinira Ɓiɗɗo oo hono no teddiniri Baabiraaɗo oo nii. Neɗɗo fuu mo teddinaali Ɓiɗɗo oo, teddinaali Baabiraaɗo nelɗo mo oo. ");
INSERT INTO ffm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Miɗo haalana on goonga: nanɗo haala am so goonɗini nelɗo kam oo heɓii nguurndam nduumiiɗam. Mo sarataake, mo diwii maayde, mo naatii e nguurndam. ");
INSERT INTO ffm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Miɗo haalana on goonga: wakkati ana wara, o yottike jaati, wakkati mo maayɓe nanata daande Ɓii Laamɗo oo. Nanɓe ɓee nguuran. ");
INSERT INTO ffm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Hono no Baabiraaɗo oo wuuriri e hoore mum nii, hono non o hokkiri Ɓiɗɗo oo duu baawɗe wuurirde e hoore mum. ");
INSERT INTO ffm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","O hokkii oon baawɗe sarde, sabi oon yo Ɓii Neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Pati ɗum haayno on. Wakkati waran mo maayɓe wonɓe ley janaale fuu nanata daande makko, ");
INSERT INTO ffm_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","njalta. Golluɓe golleeji lobbi immitanoo nguurndam, golluɓe golleeji bonɗi immitanoo sariya. ");
INSERT INTO ffm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Miin, walaa fuu ko mbaaw-mi gollirde hiini hoore am. Ko nanu-mi koo cariran-mi. Sariya am ana dartii, sabi mi jokkataa sago am, sago nelɗo kam oo njokku-mi. ");
INSERT INTO ffm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—So mi seettanike hoore am, seedaaku am sellataa. ");
INSERT INTO ffm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Won goɗɗo ceettantooɗo kam. Miɗo anndi seedaaku mo seettantoo kam oo yo goonga. ");
INSERT INTO ffm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Onon, on nelii e Yaayaa, o seettike goonga. ");
INSERT INTO ffm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Miin, mi hasindinaa e seedaaku ɓii-aadama, walaa ko mbiiru-mi seedaaku Yaayaa oo so wanaa faa kison. ");
INSERT INTO ffm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yaayaa laatike lampa kuɓɓoowa, njaaynoowa. On njaɓii weltaade wakkati gooto e fooyre makko. ");
INSERT INTO ffm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Miin, miɗo jogii seedaaku ɓurɗo mo Yaayaa oo teentilaade: golleeji ɗi Baabiraaɗo yamiri kam mi golla ɗii, kaɲum jaati ceettantoo kam Baabiraaɗo neli kam. ");
INSERT INTO ffm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kasen duu, Baabiraaɗo nelɗo kam oo hoore seettantoo kam. Abada on nanaali daande makko, abada on njiyaali mo, ");
INSERT INTO ffm_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","haala makko deembilaaki e mon, sabi on ngoonɗinaali mo o neli oo. ");
INSERT INTO ffm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Oɗon mbiɗitoo Binndi ɗii sabi on miilii on keɓan e majji nguurndam nduumiiɗam. Kanji jaati ceettantoo kam. ");
INSERT INTO ffm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kaa on njaɓaali warde e am faa keɓon nguurndam. ");
INSERT INTO ffm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Wanaa teddeengal yimɓe tewtan-mi. ");
INSERT INTO ffm_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kaa miin, miɗo anndi on, miɗo anndi jilli Laamɗo ngalaa e mon. ");
INSERT INTO ffm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Miin, mi wardii saabe Baabiraaɗo am, on njaɓɓaaki kam. Kaa so goɗɗo wardii saabe hoore mum, on njaɓɓoto ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Oɗon tottondira teddeengal, on tewtataa teddeengal iwrungal to Laamɗo gooto, hono mbaawru-ɗon goonɗinirde? ");
INSERT INTO ffm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Pati miilee miin wullantoo on to Baabiraaɗo. Muusaa, mo pawu-ɗon jikke mon dow mum oo, kaɲum wullantoo on. ");
INSERT INTO ffm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","So nii on ngoonɗiniino Muusaa, on ngoonɗinanno kam miin duu, sabi miin o sappinoo e binndi makko. ");
INSERT INTO ffm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kaa so on ngoonɗinaali ko o winndi koo, hono ngoonɗinirton haala am? ");
INSERT INTO ffm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Caggal ɗum, Iisaa lummbi weendu Galili, wiyeteendu Tiberiyas. ");
INSERT INTO ffm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jamaa keewɗo ana jokki e makko sabi ɓe njii kaayɗe ɗe o waɗunoo nde o sellinnoo ɲawɓe ɓee ndee. ");
INSERT INTO ffm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Iisaa ŋabbi dow waamnde haayre, jooddii ton e taalibaaɓe mum. ");
INSERT INTO ffm_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tawi iidi Yahuudiyankooɓe biyeteeɗo Paska oo ɓadike. ");
INSERT INTO ffm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Iisaa hunci hoore, soynii jamaa keewɗo ana fa'i ɗum. O wii Filipa: —Hoto coodaten ɲaamdu ko ɲamminta ɓee fuu? ");
INSERT INTO ffm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tawi o biiruɗo non tan faa o nana ko Filipa jaabotoo, sabi omo anndi ko o faandii gollude. ");
INSERT INTO ffm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipa jaabii mo: —Buuru teemeɗe ɗiɗi cardi heƴataa ɓe faa gooto e maɓɓe fuu heɓa hen seeɗa. ");
INSERT INTO ffm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Taalibbo makko goɗɗo, biyeteeɗo Andire miɲii Simon Piyeer, wii mo: ");
INSERT INTO ffm_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Annii, suka gorko gooto ana jogii buuruuje joy e liɗɗi ɗiɗi, koɗum ɗum nafirta yimɓe heewɓe hono ɓee? ");
INSERT INTO ffm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Iisaa wii: —Mbiyee ɓe njooɗoo! Nde wonnoo nokku oo ana heewi huɗo, ɓe njooɗii. Eɓe poti e ujunaaji joy gorko. ");
INSERT INTO ffm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iisaa ɓami buuruuje ɗee, yetti Laamɗo, hokki taalibaaɓe ɓee. Ɓeen ndokki jooɗiiɓe ɓee. Hono non liɗɗi ɗii duu. Gooto fuu heɓi ko haajaa. ");
INSERT INTO ffm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Nde ɓe kaarnoo ndee, Iisaa wii taalibaaɓe mum: —Ndeentinee kedde ɗee pati fay huunde mursee. ");
INSERT INTO ffm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ɓe kawrini kedde taƴe buuruuje joy ɗe ɲaamnooɓe ɓee keddi ɗee, ɗe kebbini cagiije sappo e ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nde yimɓe ɓee njiinoo haaynde nde Iisaa golli ndee, mbii: —Kanko jaati woni Annabaajo cappanooɗo ana wara e aduna oo. ");
INSERT INTO ffm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nde Iisaa annditinnoo eɓe njarroo nanngirde ɗum junngo ɓe ngaɗa ɗum kaananke ndee, iwi ɗon ŋabbi dow waamnde haayre kaɲum tan. ");
INSERT INTO ffm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nde hiirnoo ndee, taalibaaɓe Iisaa ɓee ndegii e weendu nduu. ");
INSERT INTO ffm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ɓe naati laana faa ɓe lummba, yaade Kafarnahum. Jemma naatii, tawi Iisaa hewtaaki ɓe. ");
INSERT INTO ffm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Henndu mawndu ana wibba, bempeeje immike. ");
INSERT INTO ffm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ɓe ngurfi laana kaa faa ɓe keɓi hono kilooji joy naa jeegom. Nden ɓe coynii Iisaa ana warda koyɗe dow weendu nduu, ana fewti ɓe. Ɓe kuli. ");
INSERT INTO ffm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Iisaa wii ɓe: —Ɗum miin. Pati kulee! ");
INSERT INTO ffm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ɓe ndaardi mo o naata laana kaa. Ɗon e ɗon ɓe panndi ɗo ɓe pa'unoo ɗoo. ");
INSERT INTO ffm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Janngo mum, jamaa keddinooɗo oo too bannge weendu nduu oo ana anndunoo laana ngoota tan wonnoo ton. Ɓe njii Iisaa naatidaali e taalibaaɓe mum laana kaa. Ɓe njii duu taalibaaɓe ɓee tan ngonnoo e makka, ndeerti, mbitti. ");
INSERT INTO ffm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Laanaaji iwruɗi Tiberiyas ngarii bannge ɗo Iisaa yettunoo Laamɗo so ɓe ɲaami buuru ɗoo. ");
INSERT INTO ffm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nde jamaa oo yiinoo Iisaa e taalibaaɓe mum fuu ngalaa ɗon ndee, naati laanaaji ɗii, peewti Kafarnahum tewtoyde Iisaa. ");
INSERT INTO ffm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nde ɓe tawnoo Iisaa oo too bannge weendu nduu ndee, ɓe mbii ɗum: —Moobbo, mande ngar-ɗaa ɗoo? ");
INSERT INTO ffm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Iisaa jaabii ɓe: —Miɗo haalana on goonga: wanaa saabe on njii kaayɗe tewtirton kam. Ko tewtirton kam dee, saabe on ɲaamii buuru on kaarii. ");
INSERT INTO ffm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Pati tampanee ɲaamdu murseteendu. Ko kaan-ɗon tampande dee, ɲaamdu heddotoondu wuurnooru yimɓe nguurndam nduumiiɗam. Nduun ɲaamdu Ɓii Neɗɗo hokkata on. Sabi Laamɗo Baabiraaɗo oo waɗii maande mum e makko. ");
INSERT INTO ffm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nden ɓe lamndii mo: —Koɗum min ngaɗata faa min ngolla golleeji ɗi Laamɗo yiɗi? ");
INSERT INTO ffm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Iisaa jaabii ɓe: —Golle mo Laamɗo yiɗi oo woni ngoonɗinon mo o neli oo. ");
INSERT INTO ffm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ɓe njaabii mo: —Haaynde honde ngaɗataa faa min njiya, min ngoonɗine? Koɗum ngollataa? ");
INSERT INTO ffm_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Njaatiraaɓe amen ɲaamii ɲaamdu wiyeteendu «maanu» ley ladde jeereende, hono no winndiraa nii: «O hokkii ɓe ɲaamdu iwrundu dow kammu faa ɓe ɲaama.» ");
INSERT INTO ffm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iisaa jaabii ɓe: —Miɗo haalana on goonga: wanaa Muusaa hokki on ɲaamdu iwrundu dow kammu. Ko selli hen dee, Baabiraaɗo am kaɲum woni dokkoowo on ɲaamdu goongaraaru iwrundu dow kammu. ");
INSERT INTO ffm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Sabi ɲaamdu ndu Laamɗo hokkata nduu woni iwrooru dow kammu, hokkooru aduna oo nguurndam. ");
INSERT INTO ffm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɓe mbii mo: —Moobbo, hokku min ɲannde fuu nduun ɲaamdu. ");
INSERT INTO ffm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Iisaa wii ɓe: —Miin woni ɲaamdu wuurnooru. Garɗo e am fuu, yolbataa abada. Goonɗinɗo kam fuu ɗomɗataa abada. ");
INSERT INTO ffm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mi wii on: on njii kam, kaa on ngoonɗinaali. ");
INSERT INTO ffm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Mo Baabiraaɗo hokki kam fuu, waran e am. Garɗo e am fuu, mi ribbataa ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Sabi wanaa faa mi waɗa sago am iwru-mi dow kammu, faa mi waɗa sago nelɗo kam oo. ");
INSERT INTO ffm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Annii sago nelɗo kam oo: pati fay gooto e ɓe o hokki kam ɓee majja, mi immintinan ɓe ɲalaande sakitotoonde. ");
INSERT INTO ffm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Annii sago Baabiraaɗo am oo: neɗɗo fuu jiiɗo Ɓiɗɗo oo so goonɗini ɗum heɓan nguurndam nduumiiɗam, mi immintinan ɗum ɲalaande sakitotoonde. ");
INSERT INTO ffm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Hooreeɓe Yahuudiyankooɓe ɓee ana ŋermitoo haala makko sabi o wii «Miin woni ɲaamdu iwrundu dow kammu nduu.» ");
INSERT INTO ffm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɓe mbii: —Oo, wanaa Iisaa ɓii Yuusufu mo anndu-ɗen inna mum e baam mum oo naa? Hono o wiirata dow kammu o iwri? ");
INSERT INTO ffm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Iisaa wii ɓe: —Pati ŋermitee hakkunde mon! ");
INSERT INTO ffm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Fay gooto waawaa warde e am so Baabiraaɗo nelɗo kam oo fooɗaali ɗum. Garɗo e am fuu, mi immintinan ɗum ɲalaande sakitotoonde. ");
INSERT INTO ffm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ana winndii ley dewte annabaaɓe: «Ɓe fuu, Laamɗo anndinan ɓe.» Neɗɗo fuu kettindiiɗo Baabiraaɗo oo so faami, waran e am. ");
INSERT INTO ffm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Fay gooto yiyaali Baabiraaɗo, so wanaa iwruɗo to makko oo. Kanko tan yii Baabiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Miɗo haalana on goonga: goonɗinɗo kam, heɓii nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Miin woni ɲaamdu wuurnooru. ");
INSERT INTO ffm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Njaatiraaɓe mooɗon ɲaamii «maanu» ley ladde jeereende. Ɗum e taweede haɗaali ɓe maayde. ");
INSERT INTO ffm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kaa ɗum ɗoo jooni yo ɲaamdu iwrundu dow kammu, yalla so neɗɗo ɲaamii ndu ana waasa maayde. ");
INSERT INTO ffm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Miin woni ɲaamdu wuurnooru iwrundu dow kammu. So neɗɗo ɲaamii nduun ɲaamdu, wuuran faa abada. Ɲaamdu ndu ndokkiran-mi saabe nguurndam aduna nduu yo terɗe am. ");
INSERT INTO ffm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Dow ɗum Yahuudiyankooɓe ana ndukida ko mbaawi fuu, ana mbiya: —Hono o waawiri hokkude en terɗe makko faa ɲaamen? ");
INSERT INTO ffm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Iisaa jaabii ɓe: —Miɗo haalana on goonga: so on ɲaamaali terɗe Ɓii Neɗɗo, on njaraali ƴiiƴam mum, nguurndam walanaa on. ");
INSERT INTO ffm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Neɗɗo fuu ɲaamɗo terɗe am so yari ƴiiƴam am heɓii nguurndam nduumiiɗam. Miin duu mi immintinan ɗum ɲalaande sakitotoonde. ");
INSERT INTO ffm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sabi terɗe am yo ɲaamdu jaati, ƴiiƴam am duu yo njaram jaati. ");
INSERT INTO ffm_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Neɗɗo fuu ɲaamɗo tew am so yari ƴiiƴam am, ɲiiɓii e am, mi ɲiiɓii e mum. ");
INSERT INTO ffm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Baabiraaɗo nelɗo kam oo yo guurɗo. E makko nguuru-mi. Hono non ɲaamɗo kam fuu wuurirta e am. ");
INSERT INTO ffm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kayru woni ɲaamdu iwrundu dow kammu: ndu waldaa e ndu njaatiraaɓe mon ɲaamunoo so maayii nduu. Ɲaamɗo nduun ɲaamdu, wuuran faa abada. ");
INSERT INTO ffm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ɗii waajuuji Iisaa waajinoo ley waajordu Kafarnahum. ");
INSERT INTO ffm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nde ɓe nannoo ɗi ndee, heewɓe e taalibaaɓe makko mbii: —Ɗii waajuuji njoorii sanne. Homo waawi hettinaade ɗi? ");
INSERT INTO ffm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Iisaa humpitii ley becce mum taalibaaɓe mum ɓee ana ŋermitoo e majjum, wii ɓe: —Ɗum huɓindanaaki on naa? ");
INSERT INTO ffm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ndennoo so on njii Ɓii Neɗɗo ŋabbitii to wonnoo too, hono ngaɗaton? ");
INSERT INTO ffm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ruuhu, kaɲum hokkata nguurndam, kaa terɗe ɓii-aadama nafataa fay huunde. Haalaaji ɗi kaalanan-mi on ɗii, kaɲum woni ruuhu, kaɲum woni nguurndam. ");
INSERT INTO ffm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ana e mon ɓe ngoonɗintaa. Nde wonnoo Iisaa ana anndi gila e puɗɗooɗe ɓe ngoonɗintaa ɗum ɓee, kaɲum e jammbotooɗo ɗum oo. ");
INSERT INTO ffm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","O ɓeydi hen: —Ɗum saabii so mbii-mi on: fay gooto waawaa warde e am so Baabiraaɗo hokkaali ɗum no warda. ");
INSERT INTO ffm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Caggal ɗum, heewɓe e taalibaaɓe makko ɓee mbitti, ŋootti jokkude e makko. ");
INSERT INTO ffm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nden Iisaa wii sappo e ɗiɗon ɓee: —Onon duu, oɗon njiɗi wittude naa? ");
INSERT INTO ffm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Piyeer jaabii mo: —Moobbo, to homo min njahata? Ɗo maa ɗoo haalaaji guurnooji neɗɗo nguurndam nduumiiɗam ngoni. ");
INSERT INTO ffm_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Min ngoonɗinii, miɗen anndi a Ceniiɗo Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Iisaa wii: —Onon sappo e ɗiɗon ɓee, wanaa miin suɓii on naa? Kaa gooto mooɗon yo seyɗaani. ");
INSERT INTO ffm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Haala Yahuuda ɓii Simon Isikariyota o haalannoo. Oo woni jammbotooɗo mo oo, haya o gooto e sappo e ɗiɗon ɓee nee. ");
INSERT INTO ffm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Caggal mum, Iisaa wonti yiilaade ley Galili. Omo teedii yiilaade ley Yahuudiya sabi hooreeɓe Yahuudiyankooɓe ana tewta no mbarda mo. ");
INSERT INTO ffm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tawi iidi Yahuudiyankooɓe biyeteeɗo iidi Buguuji oo ɓadike. ");
INSERT INTO ffm_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Miɲiraaɓe Iisaa worɓe mbii ɗum: —Eggu, njahaa Yahuudiya yalla taalibaaɓe maa ɓee ana njiya golleeji ɗi ngollataa ɗii. ");
INSERT INTO ffm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Fay gooto suuɗataa ko gollata so ana yiɗi anndeede. So aɗa golla ɗii golleeji, ɓannginan yimɓe hoore maa. ");
INSERT INTO ffm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tawi fay miɲiraaɓe makko ɓee duu ngoonɗinaali mo. ");
INSERT INTO ffm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Iisaa wii ɓe: —Wakkati am waraali tafon, kaa onon, wakkati fuu yo wakkati mon. ");
INSERT INTO ffm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yimɓe aduna mbaawaa waɲude on, kaa miin eɓe mbaɲi kam, sabi miɗo seedii golleeji maɓɓe ɗii moƴƴaa. ");
INSERT INTO ffm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Onon, njehee kawroyee e oon iidi. Miin, mi yahataa hawroyde e oon iidi sabi wakkati am yottaaki tafon. ");
INSERT INTO ffm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","O haalani ɓe ɗum tan, o heddii Galili. ");
INSERT INTO ffm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Nde miɲiraaɓe Iisaa ɓee njahunoo hawroyde e iidi oo ndee, Iisaa duu yehii ton, kaa o ɓannginaali hoore makko, o suuɗi. ");
INSERT INTO ffm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Hooreeɓe Yahuudiyankooɓe ana tewta mo ley jamaa iidi oo, ana mbiya: —Hoto o woni? ");
INSERT INTO ffm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Yimɓe heewɓe ana liddondira haala makko. Yoga ana wiya: —O neɗɗo lobbo! Woɓɓe ana mbiya: —Wanaa dee, o majjinoowo yimɓe. ");
INSERT INTO ffm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kaa fay gooto suusaali haalde haala makko faa nanee, sabi eɓe kula hooreeɓe Yahuudiyankooɓe. ");
INSERT INTO ffm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nde iidi oo feccirta, tawi Iisaa fuɗɗii waajaade ley Suudu Dewal Mawndu nduu. ");
INSERT INTO ffm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahuudiyankooɓe kaaynaa sanne, ɓe mbii: —Hono o waawiri dewte, kanko mo janngaali? ");
INSERT INTO ffm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Iisaa jaabii ɓe: —Waaju mo mbaajotoo-mi oo, iwataa e am. To nelɗo kam oo mo iwranta kam. ");
INSERT INTO ffm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","So neɗɗo muuyii gollude sago makko, annditan so konngi am ɗii to Laamɗo iwri, naa so waajuuji am ɗii e am iwi. ");
INSERT INTO ffm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Oon baajortooɗo hiini hoore mum, hoore mum teddinta. Kaa oon teddinoowo nelɗo ɗum, goonga haalata, ooɲaare walaa e mum. ");
INSERT INTO ffm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Wanaa Muusaa hokki on Sariya naa? Kaa fay gooto e mon jokkaali Sariya. Ko saabii so oɗon tewta warde kam? ");
INSERT INTO ffm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yimɓe ɓee njaabii mo: —Aan, a laddaaɗo. Homo ndaarata warde ma? ");
INSERT INTO ffm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Iisaa jaabii ɓe: —Golle gooto tan ngollu-mi, on fuu, on kaaynaama. ");
INSERT INTO ffm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Muusaa yamiri on taadagol. Taweede to njaatiraaɓe mooɗon ɗum iwrii fuu, wanaa to Muusaa. Oɗon taada neɗɗo fay ɲalaande fowteteende. ");
INSERT INTO ffm_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","So nii neɗɗo ana taadee ɲalaande fowteteende pati on luuttu Sariya Muusaa, koɗum tikkiranton kam saabe mi sellinii neɗɗo kuurɗo ɲalaande fowteteende? ");
INSERT INTO ffm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Pati cariree no njiiru-ɗon, cariree goonga. ");
INSERT INTO ffm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yoga e yimɓe Urusaliima mbii: —Wanaa oo woni mo ɓe tewtata warde oo naa? ");
INSERT INTO ffm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Omo nii darii, omo waajoo hakkunde jamaa oo. Ɓe mbiyaali mo fay huunde. Tama mawɓe ɓee cellinii kanko woni Almasiihu oo jaati? ");
INSERT INTO ffm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Oo ɗoo kaa, eɗen anndi ɗo iwata, kaa nde Almasiihu oo ana wara, fay gooto anndataa to iwrata. ");
INSERT INTO ffm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tawi Iisaa ana waajoo ley Suudu Dewal Mawndu nduu. O haali faa toowi, o wii: —Oɗon anndi kam, oɗon anndi ɗo iwan-mi? Wanaa miin waddi hoore am. Nelɗo kam oo yo goongaraajo. Onon, on anndaa mo. ");
INSERT INTO ffm_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kaa miin, miɗo anndi mo sabi to makko iw-mi. Kanko neli kam. ");
INSERT INTO ffm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Nden ɓe ndaari nanngude mo, kaa fay gooto junngo mum fawaaki e makko, sabi wakkati makko waraalino tafon. ");
INSERT INTO ffm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Heewɓe e ley jamaa oo ngoonɗinii mo, mbii: —So Almasiihu oo warii, gollan kaayɗe ɓurɗe ɗe oo gorko golli ɗee naa? ");
INSERT INTO ffm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisa'en nani ko yimɓe ɓee ngunndondirta e haala Iisaa koo. Hooreeɓe yottinooɓe sadaka e Farisa'en neli haybooɓe Suudu Dewal Mawndu nduu nannga mo. ");
INSERT INTO ffm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Non Iisaa wii: —Miin, miɗo wondi e mooɗon seeɗa tafon. Caggal mum, mi wirfitoto to nelɗo kam oo. ");
INSERT INTO ffm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","On tewtan kam, kaa on njiitataa kam, sabi on mbaawaa yaade to ngonan-mi too. ");
INSERT INTO ffm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yahuudiyankooɓe lamndondiri: —Hoto o yahata faa tawee en mbaawaa yiitude mo? O tawtoyan yimɓe men ferɓe to Yunaninkooɓe, o waajoo ɗum'en naa? ");
INSERT INTO ffm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O wii en tewtan mo, en njiitataa mo, sabi en mbaawaa yaade to mo tawetee too. Koɗum woni maanaa kaa haala? ");
INSERT INTO ffm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ɲalaande sakitotoonde teddunde e iidi, Iisaa darii, haali faa toowi, wii: —Neɗɗo fuu ɗomɗuɗo wara e am, yara. ");
INSERT INTO ffm_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Neɗɗo fuu goonɗinɗo kam, calluɗi ndiyam nguurnoojam ilan iwde e ɓernde mum, hono no winndiraa e Binndi ɗii nii. ");
INSERT INTO ffm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Tawi ɗum o haali haala Ruuhu mo goonɗinɗo mo fuu heɓata oo. Nden Ruuhu waraali, sabi Iisaa ŋabbitaali e teddeengal Laamɗo tafon. ");
INSERT INTO ffm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nde heewɓe e jamaa oo nanunoo kaa haala ndee, mbii: —Kanko jaati woni Annabaajo oo. ");
INSERT INTO ffm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yogaaɓe mbii: —Kanko woni Almasiihu oo. Woɓɓe kasen mbii: —Almasiihu, Galili iwrata naa? ");
INSERT INTO ffm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Binndi ɗii mbii e leɲol Daawuuda Almasiihu iwata, e ngeenndi Baytilaama ndi Daawuuda iwata e mum ndii. ");
INSERT INTO ffm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jamaa oo fecci saabe makko. ");
INSERT INTO ffm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Won yiɓɓe nanngude mo e maɓɓe, kaa fay gooto junngo mum fawaaki e makko. ");
INSERT INTO ffm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Non haybooɓe Suudu Dewal Mawndu ɓee ngarti to hooreeɓe yottinooɓe sadaka e Farisa'en. Ɓeen mbii ɓe: —Ko saabii so on ngaddaali mo? ");
INSERT INTO ffm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Haybooɓe ɓee njaabii: —Abada fay gooto waajoraaki no oo gorko nii. ");
INSERT INTO ffm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisa'en njaabii ɓe: —Onon duu on majjinaama naa? ");
INSERT INTO ffm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Won fuu e hooreeɓe ɓee naa e Farisa'en goonɗinɗo mo naa? ");
INSERT INTO ffm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ɓee yimɓe paamataa Sariya Muusaa, ɓe huɗaaɓe. ");
INSERT INTO ffm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Gooto e Farisa'en biyeteeɗo Nikodemus, jahunooɗo to Iisaa jemma oo, wii ɓe: ");
INSERT INTO ffm_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Sariya meeɗen ana sara neɗɗo tawee nanaaka ko haali, anndaaka ko golli naa? ");
INSERT INTO ffm_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ɓe njaabii mo: —Aan duu, a Galilinke naa? Wiɗita Binndi ɗii, a yiyan annabaajo fuu iwrataa Galili. ———————————————— ");
INSERT INTO ffm_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Caggal mum, gooto fuu hooti suudu mum. ");
INSERT INTO ffm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nden Iisaa ŋabboyi waamnde haayre wiyeteende Jaytun. ");
INSERT INTO ffm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Beetee kecco o warti ley Suudu Dewal Mawndu. Jamaa oo fuu wari. O jooɗii, omo waajoo ɓe. ");
INSERT INTO ffm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Dunkee'en Sariya e Farisa'en ngaddani mo debbo maɓɓaaɗo e jeenu. Ɓe ndarni ɗum hakkunde jamaa oo. ");
INSERT INTO ffm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ɓe mbii Iisaa: —Moobbo, oo debbo yo maɓɓaaɗo ana jeena. ");
INSERT INTO ffm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Muusaa yamirii min ley Sariya min mbarda hono ɓee rewɓe kaaƴe. Aan nee, ko mbiyataa? ");
INSERT INTO ffm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ɓe kaaldi nii faa ɓe tuufana mo, yalla eɓe keɓa ko ɓe kappira mo. Iisaa noo turii, ana diidira feɗeendu mum leydi. ");
INSERT INTO ffm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Nde wonnoo eɓe njokki e lamndaade mo ndee, Iisaa hunci hoore, wii ɓe: —Gooto mon mo luuttaali abada yo ardo wedaade mo haayre. ");
INSERT INTO ffm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","O turii kasen, omo diida e leydi. ");
INSERT INTO ffm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Nde ɓe nannoo ɗum ndee, ɓe mbittiri gooto gooto. Nayeeɓe ɓee fuu adii wittude faa heddii Iisaa tan e debbo oo. ");
INSERT INTO ffm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iisaa hunci hoore, wii mo: —Banndam debbo, hoto wullaniiɓe ma ɓee ngoni? Fay gooto jukkaali ma naa? ");
INSERT INTO ffm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","O jaabii: —Moobbo, fay gooto. Iisaa wii mo: —Miin duu, mi jukkataa ma. Yaa, pati luuttaa kasen. ———————————————— ");
INSERT INTO ffm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iisaa waajii ɓe kasen, wii: —Miin woni fooyre aduna oo. Jokkuɗo kam fuu heɓan fooyre nguurndam, yahataa ley nimre. ");
INSERT INTO ffm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nden Farisa'en mbii mo: —Aɗa seettanoo hoore maa, seedaaku maa sellataa. ");
INSERT INTO ffm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Iisaa jaabii ɓe: —Fay so mi seettanike hoore am, seedaaku am ana sella, sabi miɗo anndi ɗo iwru-mi, miɗo anndi to njahan-mi. Kaa onon, on anndaa ɗo iwru-mi, on anndaa to njahan-mi. ");
INSERT INTO ffm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Onon, no njiiru-ɗon yimɓe cardaton ɗum'en, kaa miin, mi sarataa fay gooto. ");
INSERT INTO ffm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Fay so miɗo sara, sariya am ana sella, sabi mi sarataa miin tan, Baabiraaɗo nelɗo kam oo ana wondi e am. ");
INSERT INTO ffm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Warii e Sariya mooɗon: seedaaku yimɓe ɗiɗon ana sella. ");
INSERT INTO ffm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Miin, miɗo seettanoo hoore am. Baabiraaɗo nelɗo kam oo duu, ana seettanoo kam. ");
INSERT INTO ffm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ɓe mbii mo: —Hoto Baabiraaɗo maa oo woni? Iisaa jaabii: —On anndaa kam miin, sako Baabiraaɗo am. Sinndo oɗon anndunoo kam, maa on annduno Baabiraaɗo am oo duu. ");
INSERT INTO ffm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iisaa haali ɗii haalaaji nde waajotonoo ley Suudu Dewal Mawndu, nokku ɗo keesuwal sadakaaji ngal woni ɗoo. Fay gooto nanngaali mo, sabi wakkati makko yottaaki tafon. ");
INSERT INTO ffm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iisaa wii ɓe kasen: —Miɗo nii yaha, on tewtan kam, on maaydan e luutti mon. On mbaawaa yaade to njahan-mi too. ");
INSERT INTO ffm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Non Yahuudiyankooɓe mbii: —Ɗum nee, o bartoytooɗo so o wii en mbaawaa yaade to o yahata too naa? ");
INSERT INTO ffm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Iisaa wii ɓe: —Onon, ley njeye-ɗon, kaa miin, dow njeyaa-mi. Onon, e aduna njeye-ɗon, kaa miin, mi jeyaaka e makko. ");
INSERT INTO ffm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ɗum saabii so mbii-mi on: on maaydan e luutti mon. Sabi so on ngoonɗinaali miin woni mo ngon-mi oo, on maaydan e luutti mon. ");
INSERT INTO ffm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ɓe mbii mo: —Aan homo? Iisaa jaabii: —Ko mbiinoo-mi on gila arannde koo ngon-mi. ");
INSERT INTO ffm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Miɗo joganii on ko heewi ko haaletee e ko saretee. Haya nelɗo kam oo yo goongirante. Ko narru-moo-mi kaalanan-mi aduna oo. ");
INSERT INTO ffm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ɓe paamaali haala Baabiraaɗo o haalanta ɓe. ");
INSERT INTO ffm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nden Iisaa wii ɓe: —Nde Ɓii Neɗɗo toownaa fuu, nden paamaton miin woni mo ngon-mi oo. Mi waɗirtaa fay huunde hiini hoore am, mi haalan ko Baabiraaɗo anndini kam koo. ");
INSERT INTO ffm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nelɗo kam oo ana wondi e am, o yoppaali kam mi teelɗo, sabi ko weli mo tan ngaɗan-mi wakkati fuu. ");
INSERT INTO ffm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nde Iisaa haaldunoo nii ndee, heewɓe ngoonɗini mo. ");
INSERT INTO ffm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Non Iisaa wii Yahuudiyankooɓe goonɗinɓe ɗum ɓee: —So on ɲiiɓii e konngol am, on taalibaaɓe am jaati. ");
INSERT INTO ffm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nden anndaton goonga. Goonga oo rimɗinan on. ");
INSERT INTO ffm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ɓe njaabii mo: —Minen, min iwdi Ibarahiima, abada fay gooto maraali min. Hono mbiirataa min ndimɗan? ");
INSERT INTO ffm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Iisaa jaabii ɓe: —Miɗo haalana on goonga: luuttoowo fuu yo maccuɗo luutti. ");
INSERT INTO ffm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Abada maccuɗo heddataako e galle, kaa ɓiɗɗo ana heddoo faa abada. ");
INSERT INTO ffm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","So Ɓiɗɗo rimɗinii on, on laatoto rimɓe ɗor. ");
INSERT INTO ffm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Miɗo anndi on iwdi Ibarahiima, kaa oɗon tewta warde kam sabi waaju am naataali on. ");
INSERT INTO ffm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Miin, ko njiiru-mi Baabiraaɗo am mbaajotoo-mi. Onon, ko narru-ɗon baaba mon ngaɗaton. ");
INSERT INTO ffm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ɓe njaabii mo: —Ibarahiima woni baaba amen. Iisaa wii ɓe: —Sinndo on iwdi Ibarahiima, maa on ngolluno golleeji Ibarahiima. ");
INSERT INTO ffm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kaa jooni oɗon tewta warde kam, miin kaalanɗo on goonga mo narru-mi Laamɗo oo. Ɗum Ibarahiima waɗaali. ");
INSERT INTO ffm_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Onon, golleeji baaba mon ngollaton. Ɓe mbii mo: —Minen, min nganaa ɓiɓɓe haram, baaba gooto min njogii, oo woni Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Iisaa wii ɓe: —Sinndo Laamɗo wonnoo baam mon jaati, maa on njiɗam, sabi to Laamɗo iwru-mi, so ngar-mi. Mi wardaali hiini hoore am, kanko neli kam. ");
INSERT INTO ffm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ko saabii so on paamataa haala am? Saabe on nanataa ko kaalan-mi koo. ");
INSERT INTO ffm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Onon, Ibiliisa woni baam mon. Giɗaaɗe baam mon ngollaton. O ɲaaɗii hoore gila puɗɗooɗe. O walaa e goonga sabi goonga walaa e makko. So o fenii, gikku makko tan o waɗi, sabi mo penoowo, mo inna pene. ");
INSERT INTO ffm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kaa miin, saabe miɗo haala goonga woni ko on ngoonɗiniraali kam. ");
INSERT INTO ffm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Homo e mooɗon waawi felirde kam luutti? So mi haalii goonga, ko saabii so on ngoonɗintaa kam? ");
INSERT INTO ffm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Neɗɗo Laamɗo hettintoo haala Laamɗo. Onon nee, on kettintaako sabi on nganaa yimɓe Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahuudiyankooɓe mbii mo: —Min kaalaalino goonga nde min mbiinoo a Samariyanke, a laddaaɗo ndee naa? ");
INSERT INTO ffm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Iisaa jaabii: —Mi wanaa laddaaɗo, miɗo teddina Baabiraaɗo am. Onon, oɗon koyna kam. ");
INSERT INTO ffm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Miin, mi tewtantaa hoore am teddeengal. Ana woodi tewtanoowo kam ngal. Oon woni caroowo. ");
INSERT INTO ffm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Miɗo haalana on goonga: neɗɗo fuu jokkuɗo konngol am maayataa abada. ");
INSERT INTO ffm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yahuudiyankooɓe mbii mo: —Jooni fuu tabitani min a laddaaɗo. Ibarahiima e annabaaɓe fuu maayii, kaa aan, aɗa wiya neɗɗo fuu jokkuɗo konngol maa, meeɗataa ɗeɗɗere maayde. ");
INSERT INTO ffm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Tama aɗa ɓuri baaba amen Ibarahiima teentilaade? Oon maayii, annabaaɓe duu maayii. Koɗum cikku-ɗaa ngon-ɗaa? ");
INSERT INTO ffm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Iisaa jaabii ɓe: —Miin, so hoore am teddinan-mi, teddeengal am yo meere. Baabiraaɗo am mo mbiyaton Laamɗo mon oo teddinta kam. ");
INSERT INTO ffm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","On anndaa mo. Kaa miin, miɗo anndi mo. So mi wii mi anndaa mo, naa mi laato penoowo hono mon. Miɗo anndi mo, miɗo jokki konngol makko. ");
INSERT INTO ffm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Baaba mon Ibarahiima ana seyortonoo yiide ɲalaande am. O yii nde, o seyike. ");
INSERT INTO ffm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yahuudiyankooɓe mbii mo: —Fay duuɓi capanɗe joy a heɓaali tafon, kaa a yii Ibarahiima? ");
INSERT INTO ffm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Iisaa jaabii ɓe: —Miɗo haalana on goonga: gila Ibarahiima tagaaka, miin, miɗo woodi. ");
INSERT INTO ffm_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Non, ɓe cuɓi kaaƴe faa ɓe mbedoo mo. Nden Iisaa mooltii, yalti Suudu Dewal Mawndu nduu. ");
INSERT INTO ffm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nden Iisaa ana yahannoo faa yii gorko pinduɗo e mbumndam. ");
INSERT INTO ffm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Taalibaaɓe makko lamndii mo: —Moobbo, homo luutti so mo findi e mbumndam, kanko naa saaraaɓe makko? ");
INSERT INTO ffm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Iisaa jaabii: —Wanaa kanko luutti, wanaa saaraaɓe makko. Ɗum waɗii yalla baawɗe Laamɗo ana ɓannga e makko. ");
INSERT INTO ffm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","So nii ɲalooma ana heddii, ana haani no ngollen golleeji nelɗo kam oo, sabi jemma waran nde fay gooto waawaa gollude. ");
INSERT INTO ffm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","So nii miɗo heddii e aduna oo, miin woni fooyre makko. ");
INSERT INTO ffm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Nde o haalnoo ɗum ndee, o tutti e leydi, o jiiɓiri tuttaaɗe ɗee loope, o wuji e gite bumɗo oo. ");
INSERT INTO ffm_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","O wii ɗum: —Yaa sulmoya luggal biyeteengal Silowam. (Maanaa majjum yo «nelaaɗo».) O sulmoyii, o warti omo yiya. ");
INSERT INTO ffm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Hoddiiɓe makko, kaɲum e yiyannooɓe mo omo garbinoo, mbii: —Tama wanaa oo woni jooɗinooɗo ana garbinoo oo? ");
INSERT INTO ffm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ɓee mbii: —Ɗum kanko! Ɓee mbii: —Wanaa! Nanndoore makko! Gorko oo e hoore mum wii: —Ɗum miin jaati! ");
INSERT INTO ffm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ɓe mbii mo: —Hono mbumtir-ɗaa? ");
INSERT INTO ffm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","O jaabii: —Gorko biyeteeɗo Iisaa oo jiiɓi loope, wuji e gite am, wii kam mi yaha luggal Silowam, mi sulmoyoo. Culmoyii-mi, mbumtu-mi. ");
INSERT INTO ffm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɓe mbii mo: —Hoto gorko oo woni? O wii: —Mi anndaa! ");
INSERT INTO ffm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nden ɓe naɓi bumnooɗo oo to Farisa'en. ");
INSERT INTO ffm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Nde Iisaa jiiɓunoo loope so wumtini mo ndee, yo ɲalaande fowteteende. ");
INSERT INTO ffm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Non Farisa'en duu lamndii mo: —Hono mbumtir-ɗaa? O jaabii ɓe: —O wuji loope e gite am, culmii-mi, mbumtu-mi. ");
INSERT INTO ffm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Yoga e Farisa'en mbii: —Gorko oo iwraali to Laamɗo sabi o jokkaali sariya ɲalaande fowteteende. Woɓɓe mbii: —Hono neɗɗo luuttuɗo waawiri waɗirde hono ɗee kaayɗe? Dow ɗum ɓe luurri, ɓe ceeri. ");
INSERT INTO ffm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisa'en ɓee lamndii bumnooɗo oo kasen: —Aan nee, ko mbiyataa e bumtinɗo ma oo? O jaabii: —O annabaajo. ");
INSERT INTO ffm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ɗum fuu e taweede hooreeɓe Yahuudiyankooɓe njaɓaali mo bumnooɗo so mo wumtinaa faa ɓe noddi saaraaɓe makko. ");
INSERT INTO ffm_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ɓe lamndii ɓeen: —Oo ɗoo yo ɓii mooɗon naa? Mbii-ɗon e mbumndam mo findi naa? Ndennoo hono mo wumtiri jooni? ");
INSERT INTO ffm_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Saaraaɓe ɓee njaabii: —Miɗen anndi mo ɓii amen, e mbumndam mo findi. ");
INSERT INTO ffm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kaa no o wumtiri jooni, min anndaa. Min anndaa duu homo wumtini mo. Kanko duu o mawɗo, lamndee mo! Omo waawi jaabanaade hoore makko. ");
INSERT INTO ffm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Walaa ko saaraaɓe makko mbiiri nii so wanaa kammari eɓe kula hooreeɓe Yahuudiyankooɓe. Saabe ɓeen kawrii: neɗɗo fuu cellinɗo Iisaa woni Almasiihu oo, ɓe ndibban ɗum yalta waajordu. ");
INSERT INTO ffm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ɗum saabii so saaraaɓe makko ɓee mbii: «O mawɗo, lamndee mo!» ");
INSERT INTO ffm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Farisa'en nodditi bumnooɗo oo, mbii mo: —Haalu hakkunde maa e Laamɗo! Minen kaa miɗen anndi oo gorko yo luuttuɗo. ");
INSERT INTO ffm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","O jaabii ɓe: —So o luuttuɗo duu, miin kaa, mi anndaa. Gootel tan anndu-mi: mi bumnooɗo, jooni mi wumtii. ");
INSERT INTO ffm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɓe mbii mo: —Koɗum o waɗi e maa? Hono o wumtinir ma? ");
INSERT INTO ffm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","O jaabii ɓe: —Mi haalaniino on ɗum, kaa on njaɓaali. Ko saabii so oɗon njiɗi nantude ɗum kasen? Tama onon duu, oɗon njiɗi laataade taalibaaɓe makko? ");
INSERT INTO ffm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɓeen njenni mo, mbii mo: —Aan woni taalibbo makko! Minen, min taalibaaɓe Muusaa. ");
INSERT INTO ffm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Minen, miɗen anndi Laamɗo haaldii e Muusaa, kaa kanko, min anndaa fay to mo iwata. ");
INSERT INTO ffm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Gorko oo jaabii, wii ɓe: —Hee, ko haaynii! O wumtinii kam. Onon, oɗon mbiya on anndaa to mo iwata! ");
INSERT INTO ffm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Eɗen anndi Laamɗo jaabantaako luuttooɓe, kaa omo jaabanoo kulɗo mo, gaɗoowo sago makko. ");
INSERT INTO ffm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Abada nanaaka bumtinɗo pinduɗo e mbumndam. ");
INSERT INTO ffm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Sinndo wanaa to Laamɗo oo gorko iwri, o waawataa waɗude fay huunde. ");
INSERT INTO ffm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɓe njaabii mo: —Aan, a fuu ley luutti pinu-ɗaa! Aan waajotoo min minen naa? Ɓe njaltini mo sella. ");
INSERT INTO ffm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Iisaa nani ɓe njaltinii mo, yiiti mo, lamndii mo: —Aan nee, aɗa goonɗini Ɓii Neɗɗo oo naa? ");
INSERT INTO ffm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","O jaabii: —Moobbo, homo woni kanko faa mi goonɗina mo? ");
INSERT INTO ffm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Iisaa wii mo: —A yii mo. Kaaldoowo e maa oo woni kanko. ");
INSERT INTO ffm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","O jaabii: —Moobbo, miɗo goonɗini. O sujidani ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nden Iisaa wii mo: —Sarde waddi kam e oo aduna, faa wumɓe njiya, yiyooɓe mbuma. ");
INSERT INTO ffm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisa'en tawanooɓe ɗon ɓee, nani haala kaa, lamndii mo: —Minen nee, min wumɓe naa? ");
INSERT INTO ffm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Iisaa jaabii ɓe: —Sinndo on wumɓe, on luuttataano. Kaa no mbii-ɗon jooni oɗon njiya nii, luutti mooɗon keddike. ");
INSERT INTO ffm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","—Miɗo haalana on goonga: neɗɗo fuu naatoowo hoggo baali mo naatiraali damal, kaɲum woni gujjo, kaɲum woni janoowo. ");
INSERT INTO ffm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kaa naatiroowo damal oo, kaɲum woni duroowo baali. ");
INSERT INTO ffm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kayboowo damal oo udditinan mo, baali ɗii nana daande makko. O noddira baali makko ɗii, hongu fuu innde mum, o yaltina ɗi. ");
INSERT INTO ffm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nde o yaltini ɗi fuu, o ardoto ɗi njokka e makko, sabi eɗi anndi daande makko. ");
INSERT INTO ffm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ɗi njokkataa koɗo, ko jaasi ɗum fuu, ɗi ndogan mo sabi ɗi annditataa daande hoɓɓe. ");
INSERT INTO ffm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iisaa haalani ɓe ngol tinndinol, kaa ɓe paamaali ko o muuyiri ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Iisaa wii ɓe kasen: —Miɗo haalana on goonga, miin woni damal hoggo baali. ");
INSERT INTO ffm_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Adiiɓe kam warde ɓee fuu yo wuyɓe nii e yanooɓe, baali ɗii nanataa daaɗe maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Miin woni damal. Neɗɗo fuu naatirɗo kam, hisan, naatan, yaltan, heɓan durdude. ");
INSERT INTO ffm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Gujjo wardataa so wanaa faa wujja, hirsa, bonna. Kaa miin, mi wardii faa yimɓe nguura, ɓe nguura nguurndam lobbam. ");
INSERT INTO ffm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Miin woni duroowo lobbo. Duroowo lobbo woni dokkitiroowo yonki mum saabe baali mum. ");
INSERT INTO ffm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kaa kasaaɗo mo wanaa dunkee durngol, mo walaa ko wonani ɗum e dammuli ɗii, nde yii ɲanngiri fuu, yoppan ɗi doga, ɲanngiri ndii nannga ko nanngata, keddiiɗi ɗii caakoo. ");
INSERT INTO ffm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Kasaaɗo oo dogan yoppa ɗi sabi o kasaaɗo tan, walaa ko wonani mo e majji. ");
INSERT INTO ffm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Miin woni duroowo lobbo. Hono no Baabiraaɗo oo anndiri kam so anndir-mi ɗum nii, hono non anndir-mi baali am so baali am anndi kam. Non miɗo hokkitira yonki am saabe majji. ");
INSERT INTO ffm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Miɗo jogii baali goɗɗi kasen ɗi ngalaa ley ngoo hoggo. Ɗiin duu kinaa mi wadda ɗi. Ɗi nana daande am, ɗi laatoo sewre wootere, duroowo gooto. ");
INSERT INTO ffm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Baabiraaɗo ana yiɗi kam saabe miɗo hokkitira yonki am faa mi hewta ki kasen. ");
INSERT INTO ffm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Fay gooto ittantaa kam ki. Miin e hoore am hokkitirta ki. Miɗo jogii baawɗe hokkitirde ki. Miɗo jogii baawɗe wartirde ki. E Baabiraaɗo am keɓu-mi ndee yamiroore. ");
INSERT INTO ffm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ɗii haalaaji ɓeydi waddondirde Yahuudiyankooɓe. ");
INSERT INTO ffm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Heewɓe maɓɓe ana mbiya: —O laddaaɗo o kaahaango. Ko saabii so oɗon kettindoo mo? ");
INSERT INTO ffm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kaa yogaaɓe mbii: —Ɗii waajuuji nganaa waajuuji laddaaɗo. Laddaaɗo ana waawi wumtinde bumɗo naa? ");
INSERT INTO ffm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Yiitu mawuuri heyɗintingol Suudu Dewal Mawndu nduu waɗii Urusaliima. Ɗum hawrii e dabbunde. ");
INSERT INTO ffm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ɗo Suudu Dewal Mawndu ɗoo, Iisaa ana waɗa yaha warta ley ndanki Suleymaana kii. ");
INSERT INTO ffm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nden Yahuudiyankooɓe pilii mo, mbii mo: —Faa mande keddoto-ɗaa aɗa yoppi min e wemmbere? Haalan min faa laaɓa, aan woni Almasiihu oo naa? ");
INSERT INTO ffm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Iisaa jaabii ɓe: —Mi haalanii on, on ngoonɗinaali. Golleeji ɗi ngollir-mi e innde Baabiraaɗo am ɗii, kanji ceettantoo kam. ");
INSERT INTO ffm_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kaa onon, on ngoonɗinaali sabi on nganaa baali am. ");
INSERT INTO ffm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Baali am ana nana daande am. Miɗo anndi ɗi, eɗi njokka e am. ");
INSERT INTO ffm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Miɗo hokka ɗi nguurndam nduumiiɗam, ɗi mbaatataa abada. Fay gooto ittataa ɗi e junngo am. ");
INSERT INTO ffm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Baabiraaɗo dokkuɗo kam ɗi oo ɓuri huunde fuu teddude. Fay gooto waawaa ittude ɗi e junngo Baabiraaɗo am oo. ");
INSERT INTO ffm_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Miin e Baabiraaɗo, min gooto. ");
INSERT INTO ffm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Yahuudiyankooɓe cuɓi kaaƴe kasen faa mbedoo mo. ");
INSERT INTO ffm_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Iisaa wii ɓe: —Mi gollirii baawɗe Baabiraaɗo golleeji lobbi keewɗi yeeso mon. E ley ɗii golleeji, saabe homo e majji mbedorto-ɗon kam kaaƴe? ");
INSERT INTO ffm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yahuudiyankooɓe njaabii mo: —Wanaa saabe golle lobbo min mbedorte kaaƴe, ko min mbedorte kaaƴe dee, saabe aɗa bonkoo Laamɗo. Aan a neɗɗo, a waɗii hoore maa a Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Iisaa jaabii ɓe: —Tama winndaaka ley Sariya mon too: Laamɗo wii «onon on laamɗo'en»? ");
INSERT INTO ffm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Laamɗo noddirii laamɗo'en ɓeen ɓe o haaldi. Ko Binndi ɗii mbii koo sottataa. ");
INSERT INTO ffm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Mo Baabiraaɗo suɓii so neli e aduna oo, hono mbiiraton mo bonkike Laamɗo saabe mi wii mi Ɓii Laamɗo? ");
INSERT INTO ffm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","So mi gollaali golleeji Baabiraaɗo am, pati ngoonɗinee kam. ");
INSERT INTO ffm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kaa so miɗo golla ɗi, fay so on ngoonɗintaa kam, ngoonɗinee golleeji ɗii yalla oɗon annda, ngoonɗinon miɗo e Baabiraaɗo, Baabiraaɗo ana e am. ");
INSERT INTO ffm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ɓe tewti nanngude mo kasen. O soɓɓitorii ɓe. ");
INSERT INTO ffm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","O yehi ootoo bannge maayo Urdun nokku ɗo Yaayaa lootannoo lootogal batisima arannde ɗoo kasen, o faɓɓi ton. ");
INSERT INTO ffm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Yimɓe heewɓe ngari e makko, mbii: —Yaayaa waɗaali haaynde fay wootere. Kaa ko o haali e gorko oo koo fuu goonɗii. ");
INSERT INTO ffm_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Heewɓe ngoonɗini Iisaa ton. ");
INSERT INTO ffm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gorko ɲawɗo biyeteeɗo Laajaru ana Baytaniya, kaɲum e banndiraaɓe mum rewɓe Mariyama e Marta. ");
INSERT INTO ffm_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Tawi Mariyama woni gujuɗo Moobbo oo nebam uuroojam so socciri koyɗe makko sukundu muuɗum. Laajaru ɲawɗo oo yo miɲiiko gorko. ");
INSERT INTO ffm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Banndiraaɓe rewɓe ɓee neli e Iisaa, mbii: —Moobbo, giɗo maa mo korsin-ɗaa oo ɲawii. ");
INSERT INTO ffm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Nde Iisaa nanunoo ɗum ndee, wii: —Oo ɲaw wanaa ɲaw saate. Mo ɲaw tabintinoowo teddeengal Laamɗo, yalla Ɓii Laamɗo oo ana teddiniree mo. ");
INSERT INTO ffm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iisaa ana horsini Laajaru e banndiraaɓe mum rewɓe, Marta e Mariyama, ");
INSERT INTO ffm_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","taweede o nanii Laajaru sellaa fuu, haɗaali mo faɓɓude ton balɗe ɗiɗi goɗɗe. ");
INSERT INTO ffm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Caggal ɗum, o wii taalibaaɓe makko: —Mbirfito-ɗen Yahuudiya! ");
INSERT INTO ffm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Taalibaaɓe ɓee njaabii: —Moobbo, ɓooyaa fey ko Yahuudiyankooɓe ndaari wardude ma kaaƴe, laatoo ton mbirfoto-ɗaa kasen naa? ");
INSERT INTO ffm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Iisaa jaabii: —Wanaa wakkatiiji sappo e ɗiɗi ngoni ley ɲalooma naa? Jahoowo ɲalooma fergataako sabi omo yiya fooyre aduna oo. ");
INSERT INTO ffm_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kaa jahoowo jemma fergoto sabi fooyre walaa e muuɗum. ");
INSERT INTO ffm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Caggal o haalii ɗii haalaaji, o wii ɓe: —Giɗo men Laajaru ɗaanike, mi yahan mi finndinoya mo. ");
INSERT INTO ffm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Taalibaaɓe ɓee mbii: —Moobbo, so tawii o ɗaaniiɗo, ndennoo o daɗii. ");
INSERT INTO ffm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Haala maayde Laajaru o haalannoo. Kamɓe ɓe miilii haala ɗoyngol o haali. ");
INSERT INTO ffm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Iisaa laɓɓinani ɓe: —Laajaru hedditaaki! ");
INSERT INTO ffm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Mi seyorike saabe mooɗon ko mi tawaaka ton koo yalla oɗon ngoonɗina. Kaa jonnoo, njehen to makko. ");
INSERT INTO ffm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nden Tomaa noddirteeɗo Funeeru oo wii taalibaaɓe woɓɓe ɓee: —Njehen enen duu yalla eɗen maayda e makko. ");
INSERT INTO ffm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Nde Iisaa yottinoo ndee, tawi waɗii balɗe nay ko Laajaru iriraa. ");
INSERT INTO ffm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nde wonnoo hakkunde Baytaniya e Urusaliima ɓuraa hono kilooji tati, ");
INSERT INTO ffm_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Yahuudiyankooɓe heewɓe ngarii to Mariyama e Marta duwaaru Laajaru, eɓe koomta ɗum'en e maayde miɲiiɓe gorko. ");
INSERT INTO ffm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nde Marta nannoo Iisaa warii ndee, yehi sakkitoyii mo. Mariyama kaa heddii cuuɗi. ");
INSERT INTO ffm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta wii Iisaa: —Moobbo, sinndo aɗa wonnoo ɗoo, miɲam gorko oo maayataano. ");
INSERT INTO ffm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kaa fay jooni miɗo anndi huunde fuu ko ndaardu-ɗaa Laamɗo, waɗante. ");
INSERT INTO ffm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Iisaa wii mo: —Miɲa gorko oo immitoto. ");
INSERT INTO ffm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta wii: —Miɗo anndi o immitoto ɲannde immital, ɲalaande sakitotoonde. ");
INSERT INTO ffm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Iisaa wii mo: —Miin woni immital, miin woni nguurndam. Neɗɗo fuu goonɗinɗo kam, fay so maayi, wuuran. ");
INSERT INTO ffm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Guurɗo fuu goonɗinɗo kam, maayataa abada. Aɗa goonɗini ɗum naa? ");
INSERT INTO ffm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","O jaabii: —Sanne Moobbo! Miɗo goonɗini aan woni AlmasiihuƁii Laamɗo garoowo e aduna oo. ");
INSERT INTO ffm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","E dow ɗum, o yehi noddoyde miɲiiko Mariyama, o gunndii ɗum: —Moobbo oo warii, omo nodde. ");
INSERT INTO ffm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nde Mariyama nanunoo ɗum ndee, heɲii law, nootoyii. ");
INSERT INTO ffm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Tawi fuu Iisaa naataalino ngeenndi ndii tafon. Omo heddii ɗo Marta hawrunoo e makko ɗoo. ");
INSERT INTO ffm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yahuudiyankooɓe ana ngondunoo e Mariyama ley galle, ana koomtannoo ɗum. Ɓe njii o gurbitike, o yaltii. Ɓe njokkitii mo, ɓe miili o woyoyan dow yanaande too. ");
INSERT INTO ffm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariyama yottii ɗo Iisaa woni ɗoo, yii ɗum tan, diccii yeeso muuɗum, wii ɗum: —Moobbo, sinndo aɗa wonnoo ɗoo, miɲam gorko oo maayataano. ");
INSERT INTO ffm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Nde Iisaa yiinoo Mariyama e Yahuudiyankooɓe wonduɓe e mum ɓee ana mboya ndee, yonki makko ɲawi, hakkille makko immii. ");
INSERT INTO ffm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","O wii: —Hoto ndesu-ɗon mo? Ɓe njaabii: —Moobbo, war ƴeew! ");
INSERT INTO ffm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nii Iisaa woyi. ");
INSERT INTO ffm_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yahuudiyankooɓe ɓee mbii: —Ƴeewee no o foti horsinde ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yoga e maɓɓe wii: —Bumtinɗo bumɗo waawaano haɗude Laajaru maayde naa? ");
INSERT INTO ffm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yonki Iisaa ɓeydi ɲawde, o yehi tiimoyde yanaande ndee. Yanaande ndee yo loowol uddiraangol haayre. ");
INSERT INTO ffm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Iisaa wii: —Ittee haayre ndee! Marta, banndii debbo maayɗo oo, wii mo: —Moobbo, ana haani ko tawee henndu makko waylitike, sabi hannde woni balɗe makko nay. ");
INSERT INTO ffm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Iisaa jaabii mo: —Tama mi wiyaali ma, so a goonɗinii, a yiyan teddeengal Laamɗo? ");
INSERT INTO ffm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ɓe itti haayre ndee. Iisaa tiggitii, wii: —Baabiraaɗo, miɗo yettire ko njaabani-ɗaa kam koo. ");
INSERT INTO ffm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Miin kaa, miɗo anndi ɲannde fuu aɗa jaabanoo kam. Kaa mi haaldirii nii saabe yimɓe filiiɓe kam ɓee, yalla eɓe ngoonɗina aan neli kam. ");
INSERT INTO ffm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Caggal ɗii haalaaji, o duki semmbe, o wii: —Laajaru, yaltu sella! ");
INSERT INTO ffm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Maayɗo oo yalti, juuɗe mum e koyɗe mum ana piilaa leppi, yeeso mum ana suddii. Iisaa wii ɓe: —Kumtee mo, njoppon mo o yaha! ");
INSERT INTO ffm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Heewɓe e Yahuudiyankooɓe warnooɓe to Mariyama ɓee njii ko Iisaa waɗi koo, ngoonɗini ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kaa yogaaɓe njehi to Farisa'en, kaaltani ɗum'en ko Iisaa waɗi koo. ");
INSERT INTO ffm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nden Farisa'en e hooreeɓe yottinooɓe sadaka mooɓti waalde Saahiiɓe ndee, mbii: —Oo gorko ana waɗa kaayɗe keewɗe. Hono ngaɗaten? ");
INSERT INTO ffm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","So en njoppirii mo nii, jamaa oo fuu goonɗinan mo. Nden kaa, Romankooɓe ngaran mbonna nokku men ceniiɗo oo e leɲol men ngol. ");
INSERT INTO ffm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Gooto maɓɓe biyeteeɗo Kayafas, laatinooɗo Jottinoowo Sadaka Mawɗo e nden hitaande, wii ɓe: —Onon, on anndaa fay huunde. ");
INSERT INTO ffm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","On anndaa neɗɗo gooto maayana yimɓe fuu ɓuri moƴƴande en diina leɲol meeɗen fuu halkoo. ");
INSERT INTO ffm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tawi wanaa hiini hoore makko o haaldi kaa haala, kaa nde wonnoo o Jottinoowo Sadaka Mawɗo nden hitaande, o sappike Iisaa maayanan leɲol ngol. ");
INSERT INTO ffm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kaa wanaa leɲol ngol tan o maayanta, ko o maayanta dee, faa o mooɓta ɓiɓɓe Laamɗo saakiiɓe ɓee fuu e fedde wootere. ");
INSERT INTO ffm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Gila oon ɲalooma, ɓe ndawridi faa ɓe mbara mo. ");
INSERT INTO ffm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ɗum waɗi so Iisaa ŋootti saccude hakkunde Yahuudiyankooɓe. O iwi ɗo o wonnoo ɗoo, o yehi ngalluure wiyeteende Efrayim heettunde e ladde jeereende. O jooɗodii ton e taalibaaɓe makko. ");
INSERT INTO ffm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tawi iidi Yahuudiyankooɓe biyeteeɗo Paska oo ɓadike. Heewɓe e yimɓe leydi ndii njehi Urusaliima faa cenna ko'e mum'en gila iidi oo yottaaki. ");
INSERT INTO ffm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Eɓe tewta Iisaa. Eɓe ndarii ley Suudu Dewal Mawndu nduu, eɓe kaalda: —Oɗon miila o wara e iidi oo naa on miilaali? ");
INSERT INTO ffm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tawi hooreeɓe yottinooɓe sadaka e Farisa'en njamiriino neɗɗo fuu annduɗo to mo woni yo haalu faa mo nanngee. ");
INSERT INTO ffm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Balɗe jeegom fade iidi Paska yottaade, Iisaa yehi Baytaniya ɗo Laajaru mo o wuurtinnoo oo jeyaa ɗoo. ");
INSERT INTO ffm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɗon ɓe ndefani mo ɲaamdu. Marta feccani ɓe, Laajaru yo gooto e ɲaamdooɓe e Iisaa ɓee. ");
INSERT INTO ffm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Nden Mariyama ɓami feccitere liituru nebam laaɓuɗam, uuroojam, tiiɗuɗam coggu, wuji ɗam e koyɗe Iisaa, socciri ɗe sukundu mum. Suudu nduu fuu ukkiti. ");
INSERT INTO ffm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Gooto e taalibaaɓe Iisaa ɓee, ɗum woni Yahuuda Isikariyota jammbotooɗo mo oo, wii: ");
INSERT INTO ffm_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—Ko saabii so ɗam nebam soottaaka buuɗi teemeɗe tati cardi, hokkee misikiina'en? ");
INSERT INTO ffm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Walaa ko o wiiri non so wanaa o gujjo, wanaa yurmeende misikiina'en. Kanko woni kawjotooɗo jawdi maɓɓe, omo woowi wujjitidde hen. ");
INSERT INTO ffm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Iisaa wii: —Celee e debbo oo. O resirii ɗam ɲannde iretee-mi. ");
INSERT INTO ffm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Sabi misikiina'en ana tawdee e mon ɲannde fuu. Kaa miin, mi tawdataake e mon ɲannde fuu. ");
INSERT INTO ffm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yahuudiyankooɓe heewɓe anndi Iisaa ana Baytaniya, njehi ton. Wanaa saabe Iisaa tan waddi ɓe, yalla eɓe njiya Laajaru guurtinaaɗo oo duu. ");
INSERT INTO ffm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Non hooreeɓe yottinooɓe sadaka ndawridi mbaran Laajaru duu, ");
INSERT INTO ffm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","sabi Yahuudiyankooɓe heewɓe ana njoppa ɓe ngoonɗinoya Iisaa saabe Laajaru. ");
INSERT INTO ffm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Janngo mum, jamaa keewɗo garɗo hawrude e iidi oo nani Iisaa garoowo Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ɓe ɓami caɓe tamarooje, ɓe cakkitoyii mo. Eɓe kuljina, eɓe mbiya: —Jettooje e barke ngoodanii gardoowo e dow innde Joomiraaɗo oo! Jettooje ngoodanii mo, kanko kaananke Israa'iila! ");
INSERT INTO ffm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iisaa heɓi mola ndakiiwa, waɗɗii, hono no Binndi ɗii mbiiri ɗum nii: ");
INSERT INTO ffm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Yimɓe ngalluure Siyona, pati kulee! Ƴeew, kaananke mon ana wara, ana waɗɗii mola ndakiiwa.» ");
INSERT INTO ffm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Nden taalibaaɓe makko ɓee paamaalino ko ɗum woni. Kaa caggal Iisaa teddinaama, ɓe miccitii ko mo sappananoo koo ɓe ngaɗi mo. ");
INSERT INTO ffm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jamaa tawdanooɗo e makko nde o wuurtinnoo Laajaru, o noddi ɗum iwde e yanaande ndee, kaɲum'en duu ana ceettii. ");
INSERT INTO ffm_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ɗum waɗi so yimɓe heewɓe njehi cakkitoyii mo sabi ɓe nanii o waɗii ndee haaynde. ");
INSERT INTO ffm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Non Farisa'en mbiyondiri: —On njii, walaa fuu ko mbaawan-ɗen mo, aduna oo fuu annii jokki e makko. ");
INSERT INTO ffm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Won Yunaninkooɓe tawaaɓe hakkunde warɓe Urusaliima faa ndewa ley ɲalaaɗe iidi ɗee. ");
INSERT INTO ffm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɓe ɓattitii Filipa jeyaaɗo Baytisayda ley leydi Galili, ɓe mbii ɗum: —Moobbo, miɗen njiɗi yiide Iisaa. ");
INSERT INTO ffm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipa yehi haalanoyi Andire. Ɓe njottinoyi haala kaa Iisaa. ");
INSERT INTO ffm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Iisaa jaabii ɓe: —Wakkati mo Laamɗo hollata teddeengal Ɓii Neɗɗo oo yottike. ");
INSERT INTO ffm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Miɗo haalana on goonga: so wabbere alkama yooraali aawaama e leydi, heddoto yo wabbere wootere. Kaa so nde yoorii nde aawaa fuu, nde riman faa heewa. ");
INSERT INTO ffm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Neɗɗo fuu jiɗɗo yonki mum, mursan ki, kaa jeebiiɗo yonki mum e aduna oo, damman ki, heɓan nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","So won muuyɗo gollande kam, yo jokku e am. Ɗo ngon-mi fuu, ɗoo golloowo am duu wonata. Baabiraaɗo teddinan gollanoowo kam. ");
INSERT INTO ffm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Jooni mi wemmbaama. Koɗum mbiyan-mi? Mi wiya Abba hisinam e oo wakkati naa? Mi waawaa wiide ɗum sabi kammari wakkati oo ngardu-mi. ");
INSERT INTO ffm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Abba, teddin innde maa. Daande nanaa iwrude dow kammu: —Mi teddinii nde, mi teddinan nde kasen. ");
INSERT INTO ffm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nde yimɓe darinooɓe ton ɓee nanunoo nden daande ndee, mbii ɗum riggaango kammu. Woɓɓe mbii: —Malaa'ika haaldi e makko! ");
INSERT INTO ffm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iisaa wii ɓe: —Wanaa saabe am daande ndee wardi, saabe mooɗon. ");
INSERT INTO ffm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Jooni woni sariya aduna oo. Jooni kaananke oo ɗoo aduna tippete sella. ");
INSERT INTO ffm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Miin, so mi toownaama iwde e leydi ndii, mi fooɗan yimɓe fuu warde e am. ");
INSERT INTO ffm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Tawi ɗii haalaaji o sapporii no mo maayrata nii. ");
INSERT INTO ffm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yimɓe ɓee njaabii mo: —Sariya oo anndinii min Almasiihu yo duumotooɗo. Hono aan mbiirataa kinaa Ɓii Neɗɗo oo toownee? Homo woni oo Ɓii Neɗɗo? ");
INSERT INTO ffm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Iisaa jaabii ɓe: —Fooyre ana wondi e mon wakkati seeɗa tafon. Njahon gila fooyre ana heddii e mon, pati nimre hippoo on. Jahoowo ley nimre anndaa ɗo yahata. ");
INSERT INTO ffm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ngoonɗinee fooyre gila ende e mon yalla oɗon laatoo yimɓe fooyre. Iisaa haalu ɗum tan, yehi suuɗoyii ɓe. ");
INSERT INTO ffm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Kaayɗe ɗe o waɗi yeeso maɓɓe ɗee fuu, waɗaali so ɓe ngoonɗini mo, ");
INSERT INTO ffm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","yalla haala annabi Esaaya kaa ana tabita: «Joomiraaɗo, homo goonɗini waaju amen oo? Homo ɓannginanaa baawɗe Joomiraaɗo?» ");
INSERT INTO ffm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ɓe mbaawaano goonɗinde, sabi Esaaya wii kasen: ");
INSERT INTO ffm_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«O wumnii gite maɓɓe, o helii hakkillaaji maɓɓe, pati gite maɓɓe njiya, pati hakkillaaji maɓɓe paama sako ɓe tuuba, so mi sellina ɓe.» ");
INSERT INTO ffm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ɗum Esaaya wii nde yiinoo teddeengal Iisaa, so haali haala makko ndee. ");
INSERT INTO ffm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Kaa ɗum fuu e taweede, hooreeɓe Yahuudiyankooɓe heewɓe ngoonɗinii Iisaa. Kaa saabe Farisa'en, ɓe kulii yaadirde pati ɓe njaltinee waajordu. ");
INSERT INTO ffm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ɗum woni teddineede yimɓe ɓurani ɓe teddineede Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Iisaa haali faa toowi, wii: —Goonɗinɗo kam, wanaa miin tan o goonɗini, nelɗo kam oo duu o goonɗinii ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Neɗɗo fuu jiiɗo kam, yii nelɗo kam oo. ");
INSERT INTO ffm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Miin, mi warii mi fooyre aduna oo, faa goonɗinɗo kam fuu pati heddoo ley nimre. ");
INSERT INTO ffm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","So won nanɗo waaju am jokkaali ɗum, miin, mi sarataa ɗum. Sabi mi wardaali sarde aduna oo, faa mi hisina mo ngardu-mi. ");
INSERT INTO ffm_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Oon calaniiɗo kam, so jaɓaali waajuuji am, ana jogii caroowo. Konngol ngol kaal-mi ngol sarata ɗum ɲalaande sakitotoonde. ");
INSERT INTO ffm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sabi miin, mi haaldaali hiini hoore am. Baabiraaɗo nelɗo kam oo hokki kam yamiroore ko kaalan-mi e ko mbaajotoo-mi. ");
INSERT INTO ffm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Miin, miɗo anndi yamiroore makko, kaɲum woni nguurndam nduumiiɗam. Ko kaal-mi koo, no Baabiraaɗo haalaniri kam nii kaaltir-mi. ");
INSERT INTO ffm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gila iidi Paska yottaaki, Iisaa ana anndi wakkati mo iwata e aduna so hootana Baabiraaɗo oo warii. Ga aduna gaa omo yiɗi yimɓe makko, omo yiɗi ɓe kaaddi jilli. ");
INSERT INTO ffm_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wakkati mo ɓe kirtotoo oo, Ibiliisa waɗi e ɓernde Yahuuda ɓii Simon Isikariyota jammbaade mo. ");
INSERT INTO ffm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Iisaa e hoore mum ana anndi to Laamɗo iwri to Laamɗo hootata. Laamɗo waɗii huunde fuu e junngo makko. ");
INSERT INTO ffm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","O immii e hiraande ndee, o ɓoortii saaya makko, o ɓami disawel, o fiili e makko. ");
INSERT INTO ffm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Non o wayli ndiyam e feere lootorde, o naati e lootude koyɗe taalibaaɓe makko, omo soccira ɗe disawel o fiilii ngel. ");
INSERT INTO ffm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nde o yottinoo Simon Piyeer ndee, oon wii mo: —Moobbo, aan lootata koyɗe am naa? ");
INSERT INTO ffm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Iisaa jaabii mo: —A faamaali ko ngaɗan-mi koo tafon, kaa a faamoyan caggal jooni. ");
INSERT INTO ffm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piyeer wii mo: —A lootataa koyɗe am abada! Iisaa jaabii mo: —So mi lootanaali ma, a walaa ngeɗu e am. ");
INSERT INTO ffm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Piyeer wii mo: —Moobbo! So non, pati haaɗu e koyɗe am tan, lootu juuɗe am e hoore am duu. ");
INSERT INTO ffm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Iisaa wii mo: —Lootiiɗo fuu yo laaɓuɗo. Mo hasindinaa e lootaneede kinaa koyɗe tan. Onon on laaɓuɓe, kaa wanaa on fuu. ");
INSERT INTO ffm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Tawi omo anndi jammbotooɗo mo oo. Ɗum waɗi so o wii wanaa on fuu ngoni laaɓɓe. ");
INSERT INTO ffm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nde Iisaa lootunoo koyɗe maɓɓe ndee, ɓamti saaya muuɗum, joottii, wii ɓe: —On paamii ko ngaɗu-mi on koo naa? ");
INSERT INTO ffm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Oɗon noddira kam «Moobbo» oɗon noddira kam «Kalfaaɗo». Ko mbiyaton koo ana moƴƴi, sabi ɗum ngon-mi. ");
INSERT INTO ffm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ndennoo, miin Kalfaaɗo, miin Moobbo, mi lootii koyɗe mon, waajibi onon duu gooto fuu lootana goɗɗo koyɗe mum. ");
INSERT INTO ffm_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ko ngaɗu-mi on koo yo tinndinol yalla onon duu, oɗon ngaɗondira hono ko ngaɗu-mi on koo. ");
INSERT INTO ffm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Miɗo haalana on goonga: maccuɗo ɓurataa kalfaaɗo mum teddude, nelaaɗo duu ɓurataa nelɗo ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nde wonnoo on anndii ɗum jooni, so nii on njokkirii non, on mbelan hoore. ");
INSERT INTO ffm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Wanaa haala mon on fuu kaal-mi. Miɗo anndi ɓeen ɓe cuɓii-mi, kaa kinaa ko Binndi ɗii mbii koo tabita: «Ɲaamduɗo e am latiri kam teppere muuɗum.» ");
INSERT INTO ffm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Gila jooni miɗo haalana on ɗum, fade majjum yottaade, yalla nde ɗum yottii fuu, oɗon ngoonɗina miin woni mo ngon-mi. ");
INSERT INTO ffm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Miɗo haalana on goonga: neɗɗo fuu jaɓɓiiɗo nelaaɗo am, jaɓɓike kam. Neɗɗo fuu jaɓɓiiɗo kam, jaɓɓike nelɗo kam oo duu. ");
INSERT INTO ffm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nde o haalnoo ɗum ndee, yonki makko ɲawi, o wii: —Miɗo haalana on goonga: gooto mooɗon jammboto kam. ");
INSERT INTO ffm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Taalibaaɓe ɓee ƴeewondiri. Ɓe anndaa mo o haalata haala mum. ");
INSERT INTO ffm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Gooto e taalibaaɓe ɓee, mo Iisaa horsini oo, ana jooɗinoo bannge mum. ");
INSERT INTO ffm_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Piyeer himƴi mo gite mo lamndoo Iisaa homo o haalata haala mum. ");
INSERT INTO ffm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Non taalibbo oo naayorii hedde Iisaa, wii: —Moobbo, ɗum homo? ");
INSERT INTO ffm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Iisaa jaabii: —Mo ndokkan-mi lonngere nde cuuwan-mi ndee oo. O suuwi lonngere, o hokki Yahuuda ɓii Simon Isikariyota oo. ");
INSERT INTO ffm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Caggal lonngere ndee, Ibiliisa naati e Yahuuda. Iisaa wii mo: —Waɗu ko ngaɗataa koo law! ");
INSERT INTO ffm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Tawi fay gooto e jooɗiiɓe ɗon ɓee faamaali ko Iisaa haalani mo koo. ");
INSERT INTO ffm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Nde wonnoo Yahuuda woni kawjotooɗo jawdi maɓɓe, yoga miilii Iisaa wii mo somonoyoo iidi, naa daɲa ko o hokki misikiina'en. ");
INSERT INTO ffm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yahuuda nanngu lonngere ndee tan, yalti oon wakkati fuu. Ɗum jemma. ");
INSERT INTO ffm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nde Yahuuda yaltunoo ndee, Iisaa wii: —Jooni Ɓii Neɗɗo teddinaama, Laamɗo duu teddiniraama saabe makko. ");
INSERT INTO ffm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","So Laamɗo teddiniraama saabe makko, kaɲum duu teddinan mo e hoore mum, teddinan mo law. ");
INSERT INTO ffm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Sukaaɓe am, miɗo wondi e mon seeɗa tafon. On tewtan kam. Miɗo wiya on jooni hono ko mbiinoo-mi Yahuudiyankooɓe e ɓettaade: on mbaawaa yaade to njahan-mi too. ");
INSERT INTO ffm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Miɗo hokka on yamiroore heyre: njiɗondiree! Hono no njiɗir-mi on nii, onon duu njiɗondiron hono non! ");
INSERT INTO ffm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","So on njiɗondirii, yimɓe fuu annditan on taalibaaɓe am. ");
INSERT INTO ffm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Piyeer wii mo: —Moobbo, hoto njahataa? Iisaa jaabii mo: —To njahan-mi jooni too, a waawaa jokkude e am. Kaa caggal jooni a jokkan e am! ");
INSERT INTO ffm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piyeer wii mo: —Moobbo, ko saabii so mi waawaa jokkude e maa jooni? Miɗo hokkitira yonki am saabe maa. ");
INSERT INTO ffm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Iisaa jaabii mo: —Goonga fuu, a hokkitiran yonki maa saabe am naa? Miɗo haalane goonga: fade ndontoori jogginde hannde a wiyan a anndaa kam cili tati. ");
INSERT INTO ffm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iisaa wii taalibaaɓe mum ɓee: —Pati imminee hakkille mon. Ngoonɗinee Laamɗo, ngoonɗinee kam. ");
INSERT INTO ffm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Cuuɗi keewɗi ana ley galle Baabiraaɗo am. So walaano, mi wiyanno on. Mi yahan, mi moƴƴinanoya on ton nokku. ");
INSERT INTO ffm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ndennoo, so mi moƴƴinanoyii on nokku, mi wartan kasen mi ɓamta on faa onon duu ngonon to ngonan-mi too. ");
INSERT INTO ffm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Oɗon anndi to njahan-mi too, oɗon anndi laawol mum. ");
INSERT INTO ffm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomaa wii mo: —Moobbo, min anndaa to njahataa, hono min anndirta laawol mum? ");
INSERT INTO ffm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Iisaa jaabii mo: —Miin woni laawol ngol, miin woni goonga oo, miin woni nguurndam ɗam. So wanaa saabe am fay gooto waawaa yaade to Baabiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Sinndo oɗon anndunoo kam, maa on anndu Baabiraaɗo am oo duu. Gila jooni on anndii mo, on njii mo. ");
INSERT INTO ffm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipa wii mo: —Moobbo, hollu min Baabiraaɗo, ɗum tan ana heƴa min. ");
INSERT INTO ffm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Iisaa wii mo: —No ngondir-mi e mooɗon faa ɓooyi nii fuu, Filipa, a anndaali kam naa? Jiiɗo kam, yii Baabiraaɗo. Hono mbiirataa: «Hollu min Baabiraaɗo»? ");
INSERT INTO ffm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","A goonɗinaali miɗo e ley Baabiraaɗo, Baabiraaɗo ana e am naa? Waajuuji ɗi mbaajii-mi on ɗii fuu, mi waajortaako ɗi hiini hoore am. Baabiraaɗo gonɗo e am oo gollata golleeji mum. ");
INSERT INTO ffm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngoonɗinee kam so mi wii miɗo e Baabiraaɗo, Baabiraaɗo ana e ley am. Fay so on ngoonɗinaali ɗum, ngoonɗiniron kam saabe golleeji ɗii. ");
INSERT INTO ffm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Miɗo haalana on goonga: neɗɗo fuu goonɗinɗo kam, gollan kaɲum duu golleeji ɗi ngollan-mi ɗii, gollan ko ɓuri ɗi, sabi mi kootoowo to Baabiraaɗo am. ");
INSERT INTO ffm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mi waɗanan on huunde fuu ko ɲaagori-ɗon Laamɗo saabe am. Mi waɗan ɗum yalla Baabiraaɗo oo ana teddiniree saabe Ɓiɗɗo oo. ");
INSERT INTO ffm_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","So won ko ɲaagori-ɗon Laamɗo saabe am, mi waɗanan on. ");
INSERT INTO ffm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—So oɗon njiɗi kam, on njokkan jamirooje am. ");
INSERT INTO ffm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Mi ɲaagoto Baabiraaɗo hokka on Balloowo goɗɗo, oo woni Ruuhu goonga, yalla omo wonda e mon faa abada. Aduna oo waawaa jaɓɓaade mo, sabi yiyataa mo, anndaa mo. Kaa onon, oɗon anndi mo sabi omo wondi e mon, omo e mon. ");
INSERT INTO ffm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi yoppataa on atiime'en, mi wartan e mon. ");
INSERT INTO ffm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","So ɓooyii seeɗa aduna oo yiyataa kam kasen. Kaa onon, on njiyan kam, sabi mi guurɗo, onon duu on nguuran. ");
INSERT INTO ffm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ɲannde nden on paaman miɗo e ley Baabiraaɗo, oɗon e am, miɗo e ley mon. ");
INSERT INTO ffm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Neɗɗo fuu annduɗo jamirooje am so jokki ɗe, kaɲum woni jiɗɗo kam. Jiɗɗo kam, Baabiraaɗo am yiɗan ɗum. Miin duu, mi yiɗan ɗum, mi ɓannginanan ɗum hoore am. ");
INSERT INTO ffm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahuuda, mo wanaa Yahuuda Isikariyota, jaabii mo: —Moobbo, hono ɓannginirantaa min hoore maa, tawee a ɓannganaali aduna oo? ");
INSERT INTO ffm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Iisaa jaabii mo: —So neɗɗo ana yiɗi kam, jokkan konngol am, Baabiraaɗo am yiɗan ɗum. Miin e Baabiraaɗo am oo min ngaran to mum min njooddoo e mum. ");
INSERT INTO ffm_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Neɗɗo fuu mo yiɗaa kam, jokkataa konngol am. Haala ka nanaton kaa, ka wanaa ka am, ka haala Baabiraaɗo nelɗo kam oo. ");
INSERT INTO ffm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ɗum kaalanan-mi on gila miɗo tawdaa e mon. ");
INSERT INTO ffm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ruuhu Ceniiɗo, Balloowo on mo Baabiraaɗo neldirta on saabe am oo, kaɲum anndinta on kulle fuu. O miccintinan on ko mbaajinoo-mi on koo fuu. ");
INSERT INTO ffm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Jam njoppidan-mi on, jam am ndokkan-mi on. Miin, mi hokkirtaa on no aduna oo hokkirta on nii. Pati imminee hakkille mon, pati kulee. ");
INSERT INTO ffm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","On nanii ko mbii-mi on: «mi yahan, caggal mum mi warta e mon.» Sinndo oɗon njiɗunoo kam, maa on ceyoro mi jahoowo to Baabiraaɗo, sabi Baabiraaɗo ɓuri kam teddude. ");
INSERT INTO ffm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mi haalanii on jooni gila ɗum waraali, yalla so ɗum warii, oɗon ngoonɗina. ");
INSERT INTO ffm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Haala am e mooɗon heewataa kasen, sabi kaananke oo aduna ana wara. Fay huunde o waawaa e am. ");
INSERT INTO ffm_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","No Baabiraaɗo yamiri kam nii, non ngaɗiran-mi, faa aduna oo faama miɗo yiɗi Baabiraaɗo. Immee njehen, iwen ɗoo. ");
INSERT INTO ffm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Miin woni peguuwi ngoongaraawi, Baabiraaɗo woni jom ngesa peguuje. ");
INSERT INTO ffm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Caɓal am dimaral fuu o feƴƴan ɗum, caɓal dimoowal fuu, o saltoto ɗum yalla engal ɓeydoo rimde. ");
INSERT INTO ffm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Onon, jooni on laaɓuɓe saabe waaju mo mbaajii-mi on oo. ");
INSERT INTO ffm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ɲiiɓee e am. So on ɲiiɓii e am, miin duu mi ɲiiɓan e mon! Hono no caɓal peguuwi waawaa rimde e hoore mum kinaa tawee engal ɲiiɓi e peguuwi nii, hono non onon duu, on mbaawaa rimde so on ɲiiɓaali e am. ");
INSERT INTO ffm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Miin woni peguuwi, onon ngoni caɓe. Neɗɗo fuu ɲiiɓuɗo e am, mi ɲiiɓii e mum, riman duu faa heewa. On mbaawaa waɗude fay huunde so on ngaldaa e am. ");
INSERT INTO ffm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Neɗɗo fuu mo ɲiiɓaali e am, tippete sella hono no caɓal peƴƴaangal nii, yoora. Caɓe joorɗe ɗee mooɓtete, tippee ley yiite, ɗe kuɓɓa. ");
INSERT INTO ffm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","So on ɲiiɓii e am, waaju am ɲiiɓii e mon, nden kaa ɲaagee Laamɗo ko muuy-ɗon fuu, on keɓan. ");
INSERT INTO ffm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","So on ndimii faa heewii, ɗum hollititta on laatike taalibaaɓe am, nden yimɓe njiyata teddeengal Baabiraaɗo am. ");
INSERT INTO ffm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Hono no Baabiraaɗo yiɗiri kam nii, miin duu hono non njiɗir-mi on. Ɲiiɓee e jilli am. ");
INSERT INTO ffm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","So on njokkii jamirooje am, on ɲiiɓan e jilli am, hono no njokkir-mi jamirooje Baabiraaɗo am so ɲiiɓu-mi e jilli mum nii. ");
INSERT INTO ffm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mi waajike on ɗum yalla seyo am ana ɲiiɓa e mon, seyo mon hiɓɓa. ");
INSERT INTO ffm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Annii yamiroore am: njiɗondiree hono no njiɗir-mi on nii. ");
INSERT INTO ffm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Huunde fuu ɓuraa ɗii ɗoo jilli mawnude: neɗɗo hokkitira yonki mum saabe yiɓɓe mum. ");
INSERT INTO ffm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Onon ngoni yiɓɓe am, so on ngollii ko njamir-mi on koo. ");
INSERT INTO ffm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi wiyataa on maccuɓe kasen sabi maccuɗo anndaa ko kalfaaɗo mum gollata. Miɗo wiya on yiɓɓe, sabi ko narru-mi Baabiraaɗo am koo fuu, mi anndinii on. ");
INSERT INTO ffm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wanaa onon cuɓii kam, miin suɓii on so yamiri on njahon ndimoyon ɓiɓɓe, ɓiɓɓe mon nduumoo, yalla Baabiraaɗo ana hokka on huunde fuu ko ɲaagori-ɗon saabe am. ");
INSERT INTO ffm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Njiɗondiree! Ɗum njamir-mi on. ");
INSERT INTO ffm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—So aduna oo ana waɲi on, anndee, miin o adii waɲude. ");
INSERT INTO ffm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Sinndo on laatinoke adunankooɓe, maa aduna oo yiɗu on. Kaa on nganaa adunankooɓe. Mi suɓike on mi seenndii on e aduna oo. Ɗum saabanii mo waɲude on. ");
INSERT INTO ffm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Miccitee ko mbiinoo-mi on koo: «Maccuɗo ɓurataa kalfaaɗo mum.» So ɓe torrii kam, ɓe torran on, onon duu. So ɓe njokkii konngol am, ɓe njokkan ngol mon ngol duu. ");
INSERT INTO ffm_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ɓe ngaɗiran on ɗum fuu saabe am, sabi ɓe anndaa nelɗo kam oo. ");
INSERT INTO ffm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","So mi waraalino, mi waajanooki ɓe, ɓe ɲiŋataakeno. Kaa jooni mi warii, mi waajike ɓe, ɓe ngalanaa luutti maɓɓe ɗii ujuuru fuu. ");
INSERT INTO ffm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Neɗɗo fuu baɲuɗo kam, waɲii Baabiraaɗo am oo duu. ");
INSERT INTO ffm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Sinndo mi gollaalino ɗii golleeji ɗi fay gooto meeɗaali gollude yeeso maɓɓe, ɓe ɲiŋataakeno. Kaa jooni ɓe njii ɗi fuu, eɓe keddii waɲude kam, miin e Baabiraaɗo am. ");
INSERT INTO ffm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ɗum waɗii faa tabintina ko winndaa ley Sariya maɓɓe: «Ɓe mbaɲirii kam dow meere.» ");
INSERT INTO ffm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Ruuhu goonga iwroowo to Baabiraaɗo, Balloowo on mo neldan-mi on oo, nde warii, kaɲum seettantoo kam. ");
INSERT INTO ffm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Onon duu, on ceettanto kam sabi oɗon ngondi e am gila puɗɗooɗe. ");
INSERT INTO ffm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","—Mi waajike on ɗum pati on njoppu goonɗinal. ");
INSERT INTO ffm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ɓe njaltinan on cuuɗi baajorɗi. Wakkati waroyan nde barɗo on fuu miilata rewii Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ɓe ngaɗan ɗum sabi ɓe anndaa Baabiraaɗo oo, ɓe anndaa kam miin duu. ");
INSERT INTO ffm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mi waajike on ɗum, yalla so wakkati oo warii, oɗon miccitoo mi haalaniino on ɗum. —Mi haalanaali on gila arannde sabi miɗo wondi e mon. ");
INSERT INTO ffm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jooni miɗo nii hootana nelɗo kam oo, kaa fay gooto e mon lamndaaki kam hoto njahan-mi. ");
INSERT INTO ffm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","On cunaama sanne saabe ko kaalan-mi on ɗum koo. ");
INSERT INTO ffm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ɗum fuu e taweede, miɗo haalana on goonga: yaadu am ɓuri moƴƴande on. Sabi so mi yahaali, Balloowo on oo warataa. Kaa so mi yehii, mi neldan on mo. ");
INSERT INTO ffm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","So o warii, o ɲiŋan aduna oo banngal luutti e fooccitaare e sariya. ");
INSERT INTO ffm_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Banngal luutti, sabi ɓe ngoonɗinaali kam. ");
INSERT INTO ffm_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Banngal fooccitaare, sabi miɗo hoota to Baabiraaɗo oo, on njiyataa kam kasen. ");
INSERT INTO ffm_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Banngal sariya, sabi kaananke oo ɗoo aduna saraama. ");
INSERT INTO ffm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Miɗo jogii ko heewi kasen ko mi waajoo on, kaa on mbaawtataa ɗum jooni. ");
INSERT INTO ffm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nde Ruuhu goonga oo warii fuu, ɗowan on faade e goonga fuu. Sabi o haaldataa hiini hoore makko, o haalanan on ko o nani fuu, o humpitan on ko waroyta. ");
INSERT INTO ffm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kanko, o teddinan kam, sabi o ɓaman ko njey-mi koo, o humpitira on. ");
INSERT INTO ffm_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ko Baabiraaɗo oo jogii fuu, miin jey. Ɗum saabii mbii-mi o humpitan on ko o heɓi e am koo. ");
INSERT INTO ffm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—So ɓooyii seeɗa, on njiyataa kam, so ɓooyii seeɗa kasen, njiyon kam. ");
INSERT INTO ffm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yoga e taalibaaɓe makko ɓee lamndondiri, mbii: —Koɗum woni maanaa haala makko so o wii «so ɓooyii seeɗa, on njiyataa kam e so ɓooyii seeɗa kasen, njiyon kam», o wii kasen «sabi mi jahoowo to Baabiraaɗo»? ");
INSERT INTO ffm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ɓe mbii: —«So ɓooyii seeɗa», koɗum ɗum firritata? Min paamaali ko o wii koo. ");
INSERT INTO ffm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Nde Iisaa anndunoo eɓe njiɗi lamndaade ɗum ndee, wii ɓe: —Oɗon lamndondira maanaa haala am kaa: «So ɓooyii seeɗa on njiyataa kam, so ɓooyii seeɗa kasen, njiyon kam.» ");
INSERT INTO ffm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Miɗo haalana on goonga: onon, on mboyan, on mboytoto, tawee aduna oo ana seyii. On cuŋlan, kaa sunu mon waylitoto seyo. ");
INSERT INTO ffm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","So debbo ana ŋaywa, mo suŋlan sabi wakkati makko warii. Kaa so cukalel ngel rimaama, o miccitataako naawalla ŋatawere makko, no seyo makko foti heewde dow aduna oo heɓii koɗo. ");
INSERT INTO ffm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Onon duu hono non cuŋlir-ɗon jooni, kaa mi yiitan on kasen, on ceyoto, fay gooto waawaa bonnude seyo mon. ");
INSERT INTO ffm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ɲannde nden, on lamndataako kam fay huunde. Miɗo haalana on goonga: huunde fuu ko ɲaagi-ɗon Baabiraaɗo oo, hokkiran on saabe am. ");
INSERT INTO ffm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Faa jooni, walaa fuu ko ɲaagori-ɗon saabe am. Ɲaagee, on keɓan, yalla seyo mon ana hiɓɓa. ");
INSERT INTO ffm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","—Ko kaalan-mi on jooni koo yo haala hippaaka. Wakkati waran, wakkati mo mi hippataa haala. Nden kaa mi haalanan on haala Baabiraaɗo faa laaɓa. ");
INSERT INTO ffm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ɲannde nden on ɲaagorto Laamɗo saabe am. Mi wiyaali miɗo ɲaaganoo on Baabiraaɗo, ");
INSERT INTO ffm_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","sabi Baabiraaɗo e hoore mum ana yiɗi on. O yiɗirii on saabe oɗon njiɗi kam, on ngoonɗinii to Laamɗo iwru-mi. ");
INSERT INTO ffm_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mi iwii to Baabiraaɗo, mi warii e aduna. Jooni miɗo ɗala aduna oo, mi hootana Baabiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Taalibaaɓe makko mbii mo: —Jooni kaa, a haalii faa laaɓi, walaa fuu ko kippu-ɗaa hen. ");
INSERT INTO ffm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jooni kaa, min anndii walaa fuu ko a anndaa, fay gooto hasindinaa e lamndaade ma. Ɗum saabii so min ngoonɗini a iwɗo to Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Iisaa jaabii ɓe: —Jooni, on ngoonɗinii naa? ");
INSERT INTO ffm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wakkati oo ana wara, o warii jooni, ɗo on fuu caakoto-ɗon, homo fuu hoota suudu mum, njoppon kam mi teelɗo. Kaa mi wanaa teelɗo, sabi Baabiraaɗo oo ana wondi e am. ");
INSERT INTO ffm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi haalanii on ɗum, yalla oɗon kemra jam e am. Oɗon ngondi e torra ley aduna oo. Kaa ceyo-ɗon, miin, mi jaalike aduna oo! ");
INSERT INTO ffm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nde Iisaa waajinoo waajuuji ɗii ndee, tiggitii kammu, wii: —Baabiraaɗo, wakkati oo warii, teddin Ɓiya, yalla Ɓiya oo duu ana teddine. ");
INSERT INTO ffm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sabi a hokkii mo baawɗe dow neɗɗo fuu, yalla omo hokka ɓeen ɓe ndokku-ɗaa mo ɓee fuu nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Nguurndam nduumiiɗam woni ɓe annde, aan Laamɗo goongaraajo gooto oo, ɓe annda Iisaa Almasiihu mo nel-ɗaa oo. ");
INSERT INTO ffm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mi teddinii ma e dow leydi ndii, mi yottinii golle mo ndokku-ɗaa kam mi golla oo. ");
INSERT INTO ffm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jooni kaa, Baabiraaɗo, teddinam teddeengal ngal njoginoo-mi ɗo maa ɗoo gila aduna oo tagaaka ngal. ");
INSERT INTO ffm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yimɓe ɓe ndokku-ɗaa kam e aduna oo ɓee, mi ɓannginanii ɗum'en innde maa. Aan jey ɓe, a hokkii kam ɓe, eɓe njokki konngol maa. ");
INSERT INTO ffm_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jooni kaa, ɓe anndii ko ndokku-ɗaa kam koo fuu to maa iwi, ");
INSERT INTO ffm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","sabi mi haaltanii ɓe haalaaji ɗi kaalan-ɗaa kam ɗii, ɓe njaɓii ɗi. Ɓe keɓii taƴoral to maaɗa iwru-mi, ɓe ngoonɗinii aan neli kam. ");
INSERT INTO ffm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Miɗo ɲaagore saabe maɓɓe. Mi ɲaagortaako saabe aduna oo, miɗo ɲaagoroo saabe ɓe ndokku-ɗaa kam ɓee, sabi aan jey ɓe. ");
INSERT INTO ffm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ɓe njey-mi fuu, aan jey, ɓe njey-ɗaa fuu, miin jey. Mi teddiniraama saabe maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Kamɓe, ɓe keddoto e aduna oo, kaa miin, mi heddataako e makko. To maa njahan-mi. Aan Baabiraaɗo Ceniiɗo, reenir ɓe baawɗe maaɗa ɗe ndokku-ɗaa kam ɗee, yalla eɓe laatoo gooto hono no men nii. ");
INSERT INTO ffm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nde ngondunoo-mi e maɓɓe ley aduna oo ndee, mi reenirii ɓe baawɗe maa ɗe ndokku-ɗaa kam ɗee, mi tiiɗii e maɓɓe. Fay gooto majjaali so wanaa yiitenke oo, yalla ko sappaa e Binndi ɗii koo ana tabita. ");
INSERT INTO ffm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Jooni kaa miɗo wara to maa. Miɗo haala ɗii haalaaji gila miɗo heddii e aduna oo tafon, yalla seyo am ana hiɓɓa e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mi yottinii ɓe konngol maa. Aduna oo waɲii ɓe, sabi ɓe njeyaaka e makko, hono no miin duu mi jeyiraaka e makko nii. ");
INSERT INTO ffm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi ɲaagaaki ittaa ɓe e aduna oo, kaa miɗo ɲaage ndeenaa ɓe e Ibiliisa. ");
INSERT INTO ffm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ɓe njeyaaka e aduna oo, hono no miin duu mi jeyiraaka e makko nii. ");
INSERT INTO ffm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sennir ɓe goonga maa. Konngol maa woni goonga. ");
INSERT INTO ffm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hono no nelir-ɗaa kam e oo aduna nii, miin duu non nelir-mi ɓe e makko. ");
INSERT INTO ffm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Miɗo sennira hoore am saabe maɓɓe, yalla kamɓe duu eɓe laatoo senniraaɓe goonga. ");
INSERT INTO ffm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Wanaa saabe maɓɓe tan ɲaagorto-maa-mi. Miɗo ɲaagoroo duu saabe ɓeen goonɗinirɓe kam waajuuji maɓɓe, ");
INSERT INTO ffm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","yalla ɓe fuu eɓe laatoo gooto. Hono no aan Baabiraaɗo laatori-ɗaa e am, miin duu miɗo e maa nii, yalla kamɓe duu eɓe laatoo gooto e men, yalla aduna oo ana goonɗina aan neli kam. ");
INSERT INTO ffm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mi waɗanii ɓe teddeengal ngal ngaɗan-ɗaa kam ngal, yalla eɓe laatoo gooto, hono no laatori-ɗen gooto nii. ");
INSERT INTO ffm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Miin miɗo e maɓɓe, aan aɗa e am, yalla ngootummaaku maɓɓe ana hiɓɓa, yalla aduna oo ana annda aan neli kam, mo annda duu aɗa yiɗi ɓe hono no njiɗir-ɗaa kam nii. ");
INSERT INTO ffm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Baabiraaɗo, miɗo yiɗi ɓe ndokku-ɗaa kam ɓee ngonda e am nokku fuu ɗo tawaa-mi, yalla eɓe njiya teddeengal ngal ngaɗan-ɗaa kam ngal sabi a yiɗii kam gila aduna oo diidaaka. ");
INSERT INTO ffm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Baabiraaɗo pooccitiiɗo, aduna oo anndaa ma, kaa miin noo miɗo anndu maa, ɓee ɗoo ana anndi aan neli kam. ");
INSERT INTO ffm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi anndinii ɓe ko ngon-ɗaa, mi ɓeydan anndinde ɓe, yalla jilli njiɗ-ɗaa kam ɗii ana tawee e maɓɓe, miin duu mi tawee e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nde Iisaa duworinoo nii ndee, yaadi e taalibaaɓe mum ootoo bannge callugol biyeteengol Kedoron. Ɓe naati ton e nokku keewɗo leɗɗe. ");
INSERT INTO ffm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahuuda jammbotooɗo mo oo ana anndi nokku oo, sabi Iisaa e taalibaaɓe mum ana mooɓtotonoo ton sanne. ");
INSERT INTO ffm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yahuuda ardii oorngal sordaasi'en e gollooɓe iwruɓe to hooreeɓe yottinooɓe sadaka e Farisa'en. Ɓe ngari ton, eɓe njogii cunkume kuɓɓooje e lampaaji e kaɓorɗe. ");
INSERT INTO ffm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nde wonnoo Iisaa ana anndi ko fa'i warde e mum fuu, sakkitii ɓe, wii: —Homo tewtaton? ");
INSERT INTO ffm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ɓe njaabii mo: —Iisaa Nasaraatunke oo. O wii ɓe: —Miin woni kanko! Yahuuda jammbotooɗo mo oo duu ana dardii e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Nde Iisaa wiinoo «Miin woni kanko» ndee, ɓe njaari cagga-caggarde ɓe caami e leydi. ");
INSERT INTO ffm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Iisaa lamndii ɓe kasen: —Homo tewtaton? Ɓe njaabii: —Iisaa Nasaraatunke oo. ");
INSERT INTO ffm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Iisaa wii ɓe: —Mbii-mi on, miin woni kanko! So miin tewtaton, accee ɓee kaa njaha. ");
INSERT INTO ffm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Non ɗum laatorii, yalla haala Iisaa kaa ana tabita: «Mi majjoraaka fay gooto e ɓe ndokku-ɗaa kam ɓee.» ");
INSERT INTO ffm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Piyeer ana joginoo kaafaawi, soorti ki, soppi golloowo Jottinoowo Sadaka Mawɗo e nowru ɲaamru faa ndu taƴi. Golloowo oo ana wiyee Malkus. ");
INSERT INTO ffm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nden Iisaa wii Piyeer: —Soornu kaafaawi maa kii e ŋaro mum. Aɗa miili mi yarataa horde bone nde Baabiraaɗo hokki kam ndee naa? ");
INSERT INTO ffm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ɗon sordaasi'en e kaananke mum e gollanooɓe hooreeɓe Yahuudiyankooɓe nanngi Iisaa, kaɓɓi ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ɓe naɓi mo to Annas tafon. Annas yo esii Kayafas laatiiɗo Jottinoowo Sadaka Mawɗo ley nden hitaande. ");
INSERT INTO ffm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kanko Kayafas oo dawrannoo hooreeɓe Yahuudiyankooɓe dabare, wii: ko ɓuri moƴƴude e yimɓe leɲol ngol, neɗɗo gooto maayana ɓe. ");
INSERT INTO ffm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Piyeer e taalibbo goɗɗo njokkitii Iisaa. Taalibbo oo ana anndondiri e Jottinoowo Sadaka Mawɗo oo, ɗum waɗi so o heɓi naaddude e Iisaa galle mawɗo hooreeɓe yottinooɓe sadaka oo. ");
INSERT INTO ffm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Piyeer kaa, darii damal sella too. Taalibbo anndondirɗo e Jottinoowo Sadaka Mawɗo oo, yalti haaldi e debbo doomoowo damal ngal oo, naanni Piyeer. ");
INSERT INTO ffm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Korɗo doomoowo damal oo lamndii Piyeer: —Aan nee, a wanaa gooto e taalibaaɓe gorko oo naa? Piyeer jaabii mo: —Mi wanaa! ");
INSERT INTO ffm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Nde wonnoo jaangol ana heewi, gollooɓe e doomooɓe kuɓɓiino yiite ana ƴuwloo. Piyeer duu dardii e maɓɓe ana ƴuwloo. ");
INSERT INTO ffm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nden Jottinoowo Sadaka Mawɗo oo lamndii Iisaa haala taalibaaɓe mum e waaju mum. ");
INSERT INTO ffm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Iisaa jaabii mo: —Mi ɓannginanii aduna oo waaju am. Wakkati fuu miɗo waajoo ley cuuɗi baajorɗi e ley Suudu Dewal Mawndu to Yahuudiyankooɓe fuu kawrititta too. Walaa fuu ko kaaldu-mi cuucuukka. ");
INSERT INTO ffm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ko lamndorto-ɗaa kam? Lamnda ɓeen hettindiiɓe kam. Kamɓe kaa, eɓe anndi ko mbaajii-mi koo. ");
INSERT INTO ffm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Nde Iisaa haalnoo ɗum ndee, gooto e doomooɓe ɓee fii mo banaawo, wii: —Nii jaaborto-ɗaa Jottinoowo Sadaka Mawɗo oo naa? ");
INSERT INTO ffm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Iisaa jaabii mo, wii: —So ko boni mbii-mi, haalanam ko boni e majjum. So tawii ko moƴƴi mbii-mi, ko saabii so pii-ɗaa kam? ");
INSERT INTO ffm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nden Annas neldi mo to Kayafas Jottinoowo Sadaka Mawɗo oo, omo haɓɓii. ");
INSERT INTO ffm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Piyeer ana darinoo ton ana ƴuwloo. Faa ɓe mbii mo: —Aan, a wanaa gooto e taalibaaɓe makko ɓee naa? O yeddi, o wii: —Mi wanaa! ");
INSERT INTO ffm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Gooto e gollanooɓe Jottinoowo Sadaka Mawɗo oo, sakiike mo Piyeer taƴunoo nowru muuɗum oo, wii: —Mi yiidaalino ma e makko ley nokku keewɗo leɗɗe too naa? ");
INSERT INTO ffm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Piyeer yeddi kasen, e oon wakkati fuu, ndontoori joggini. ");
INSERT INTO ffm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Caggal ɗum, ɓe itti Iisaa to Kayafas gila beetee kecco, ɓe naɓi mo to huɓeere goforneer oo. Naɓuɓe mo ɓee naataali huɓeere ndee, sabi so ɓe naatii nde, ɓe coɓan, ɓe ɲaamataa ndeendi iidi Paska ndii. ");
INSERT INTO ffm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pilaatu, goforneer oo, tawoyi ɓe sella too, wii: —Koɗum ngullaniri-ɗon oo gorko? ");
INSERT INTO ffm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɓe njaabii mo: —Sinndo o gollaalino ko boni, min ngaddataano mo ga maa. ");
INSERT INTO ffm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nden Pilaatu wii ɓe: —Naɓee mo, cardon mo sariya mooɗon. Yahuudiyankooɓe ɓee njaabii: —Min nduŋanaaka warde fay gooto. ");
INSERT INTO ffm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nii haala ka Iisaa haalnoo haala maayde mum kaa tabitiri. ");
INSERT INTO ffm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilaatu naatti galle mum, noddi Iisaa, wii ɗum: —Aan woni kaananke Yahuudiyankooɓe oo naa? ");
INSERT INTO ffm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Iisaa jaabii mo: —Aan e hoore maa wii non naa woɓɓe narru-ɗaa? ");
INSERT INTO ffm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilaatu jaabii mo: —Miin, mi Yahuudiyanke naa? Ko ngaɗu-ɗaa so leɲol maa e hooreeɓe yottinooɓe sadaka ngaddu maa ga am? ");
INSERT INTO ffm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Iisaa jaabii: —Laamu am jeyaaka e oo aduna. Sinndo omo jeyanoo e oo aduna, gollooɓe am kaɓotono pati mi naata juuɗe hooreeɓe Yahuudiyankooɓe. Kaa jooni laamu am oo wanaa mo ɗoo. ");
INSERT INTO ffm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nden Pilaatu wii mo: —Ndennoo, a kaananke? Iisaa jaabii: —No mbii-ɗaa nii, mi kaananke. Walaa fuu ko ndimiraa-mi so ngar-mi ley aduna oo so wanaa faa mi seettoo goonga. Neɗɗo fuu jiɗɗo goonga, ana nana daande am. ");
INSERT INTO ffm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilaatu wii mo: —Goonga? Koɗum woni goonga? Nde o haalnoo ɗum ndee, o yalti kasen, o tawtoyi Yahuudiyankooɓe ɓee to sella too, o wii ɓe: —Mi heɓaali feloore fay wootere e makko. ");
INSERT INTO ffm_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kaa ley aada mooɗon, iidi Paska fuu miɗo yoppitana on kasunke gooto. Oɗon njiɗi mi yoppitana on kaananke Yahuudiyankooɓe oo naa? ");
INSERT INTO ffm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ɓe fuu ɓe ngulli, ɓe mbii: —Wanaa oo, Barabas min njiɗi. Barabas nee yo janoowo. ");
INSERT INTO ffm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nden Pilaatu nanngi Iisaa, yamiri fiyee dorri. ");
INSERT INTO ffm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sordaasi'en ɓee caɲi tenngaade gi'e, kippi e hoore makko, ɓoorni mo burmusuure woɗeere. ");
INSERT INTO ffm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ɓe ɓattitii mo, eɓe mbiya: —Saɗi, kaananke Yahuudiyankooɓe! Eɓe piya mo banaaje. ");
INSERT INTO ffm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaatu yalti kasen, wii Yahuudiyankooɓe ɓee: —Mi yaltinan mo faa anndon mi heɓaali feloore fay wootere e makko. ");
INSERT INTO ffm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Non Iisaa yaltinaa ana hippii tenngaade gi'e ndee, ana ɓoornii saaya mboɗeewa kaa. Pilaatu wii ɓe: —Gorko oo annii! ");
INSERT INTO ffm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Nde hooreeɓe yottinooɓe sadaka e doomooɓe ɓee njiinoo mo ndee, ngulli mbii: —Tontu mo e leggal bardugal! Tontu mo e leggal bardugal! Pilaatu wii ɓe: —Nanngee mo onon tonton mo, sabi miin kaa, mi heɓaali feloore e makko. ");
INSERT INTO ffm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yahuudiyankooɓe njaabii mo: —O luuttii sariya amen. E ley sariya amen oo kaa waajibi o waree, sabi o waɗii hoore makko o Ɓii Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nde Pilaatu nannoo kaa haala ndee, kulol mum ɓeydii. ");
INSERT INTO ffm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","O naatti huɓeere ndee kasen o wii Iisaa: —Aan, hoto iwataa? Iisaa jaabaaki mo fay huunde. ");
INSERT INTO ffm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nden Pilaatu wii mo: —Miin muroto-ɗaa naa? Tama a anndaa miɗo waawi yoppitidde ma, miɗo waawi tontude ma? ");
INSERT INTO ffm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Iisaa jaabii mo: —So wanaa Laamɗo hokku maa baawɗe, a waawaano e am fay huunde. Ɗum saabii so gattuɗo kam e junngo maa oo ɓur maa ɲiŋinaade. ");
INSERT INTO ffm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Gila nden Pilaatu ana ndaara yoppitinde mo. Ɗum saabii so Yahuudiyankooɓe ana ngulla, ana mbiya: —So nii a yoppitii mo, a wanaa giɗo kaananke Roma mawɗo oo. Neɗɗo fuu gaɗuɗo hoore mum kaananke yo gaɲo kaananke Roma. ");
INSERT INTO ffm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Nde Pilaatu nannoo ɗii haalaaji ndee, yaltini Iisaa, jooɗii dow jooɗorgal sariya, nokku biyeteeɗo Dinngira Kaaƴe (e ibaraninkoore omo wiyee Gabbata). ");
INSERT INTO ffm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nden yo ɲannde lanndinal iidi Paska, wakkati hakkunde naange. Pilaatu wii Yahuudiyankooɓe: —Kaananke mooɗon annii! ");
INSERT INTO ffm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ɓe nduki semmbe: —War mo! War mo! Tontu mo e leggal bardugal! Pilaatu jaabii: —Mi tonta kaananke mooɗon oo naa? Hooreeɓe yottinooɓe sadaka ɓee mbii: —Min ngalaa kaananke ko wanaa kaananke Roma mawɗo oo. ");
INSERT INTO ffm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nden o hokki ɓe Iisaa faa ɓe tontoya ɗum. Nii ɓe nanngi Iisaa, ɓe naɓi ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Iisaa yalti ana roondii leggal mum bardugal faa yottii nokku biyeteeɗo Laalagal Hoore (e ibaraninkoore omo wiyee Golgata). ");
INSERT INTO ffm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ɗon ɓe tontidi mo e ɗiɗon woɓɓe: oo nano, oo ɲaamo, Iisaa ana lommbii. ");
INSERT INTO ffm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaatu winndi e alluwal: IISAA NASARAATUNKE OO, KAANANKE YAHUUDIYANKOOƁE. O yamiri ngal takkee e leggal bardugal ngal. ");
INSERT INTO ffm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yahuudiyankooɓe heewɓe njanngii binndi ɗii sabi ɗo Iisaa tontaa ɗoo woɗɗaa ngalluure ndee. Alluwal ngal winndaama e ibaraninkoore e yunaninkoore e romankoore. ");
INSERT INTO ffm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nden hooreeɓe yottinooɓe sadaka ɓee mbii Pilaatu: —Pati winndu: «Kaananke Yahuudiyankooɓe», winndu: «o wii kanko woni kaananke Yahuudiyankooɓe». ");
INSERT INTO ffm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilaatu jaabii: —Ko mbinndu-mi koo winndaama, tilike. ");
INSERT INTO ffm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nde sordaasi'en ɓee tilinoo tontude Iisaa ndee, pecci kaddule makko pecce nay. Homo fuu ɓami feccere mum. Ɓe ɓami saaya makko duu. Saaya kaa walaa ɲootol. Ka fuu ka lefol gootol. ");
INSERT INTO ffm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sordaasi'en ɓee kaaldi: —Pati ceeken saaya kaa. Ngaɗen ka urwa, ƴeewen keɓoowo ka. Ɗum waɗii, yalla ko sappaa e Binndi ɗii koo ana tabita: «Ɓe peccii kaddule am hakkunde maɓɓe, ɓe ngaɗii saaya am urwa.» Ɗum sordaasi'en ɓee ngaɗi. ");
INSERT INTO ffm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Inna Iisaa, e sakiike mum debbo, Mariyama jom suudu Kolopa, e Mariyama mo Magdala ana ndarii bannge leggal ngal Iisaa tontaa e mum ngal. ");
INSERT INTO ffm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Iisaa yii inna mum e taalibbo mum korsuɗo oo ana ndarodii, wii inna mum: —Inna, ɓiya annii! ");
INSERT INTO ffm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nden o wii taalibbo oo: —Inna maa, annii. Gila nden taalibbo oo naɓi Mariyama galle mum. ");
INSERT INTO ffm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Caggal ɗum, Iisaa anndi walaa fuu ko heddii. Yalla ko Binndi ɗii mbii koo ana tabita, o wii: —Mi ɗomɗii! ");
INSERT INTO ffm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mbulku keewɗo biineegiri ana wonnoo ɗon. Ɓe cuuwi liccere e biineegiri oo, ɓe kaɓɓi e loocol hisopiyaawol, ɓe cukki e hunduko makko. ");
INSERT INTO ffm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nde Iisaa ɓuuccinoo biineegiri oo ndee, wii: —Tilike! O turi hoore, o ɗali aduna. ");
INSERT INTO ffm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nden yo ɲannde lanndinal iidi. Hooreeɓe Yahuudiyankooɓe ndaardi Pilaatu yalla korre tontaaɓe ɓee ana kelee, ɓeen ɓamtee, pati terɗe ɗee keddoo e leɗɗe ɗee ɲalaande fowteteende. Sabi ɲalaande ndee yo teddunde. ");
INSERT INTO ffm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Non sordaasi'en ɓee ngari, keli korre worɓe ɗiɗon tontidanooɓe e Iisaa ɓee. ");
INSERT INTO ffm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kaa nde ɓe njottinoo Iisaa ndee, ɓe tawi mo maayii. Ɗum saabii ɓe kelaali korre makko. ");
INSERT INTO ffm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kaa gooto e sordaasi'en ɓee yuwi Iisaa labbo e wuttuldu. Ɗon ƴiiƴam e ndiyam mbaacii. ");
INSERT INTO ffm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Neɗɗo ceettiiɗo ɗum oo yii ɗum. Seedaaku makko duu ana sella. Kaalɗo oo ana anndi haalii goonga, yalla onon duu, oɗon ngoonɗina. ");
INSERT INTO ffm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ɗum fuu waɗii, yalla ko Binndi ɗii mbii koo ana tabita: «Fay gootal e gi'e makko helataake.» ");
INSERT INTO ffm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ɗi mbii kasen: «Ɓe njiitan oon mo ɓe njuwnoo oo.» ");
INSERT INTO ffm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Caggal mum, Yuusufu Arimatiyanke ndaardi Pilaatu yalla omo ɓamta tew Iisaa oo. Pilaatu jaɓani mo. O ɓamti oon. Tawi Yuusufu oo yo taalibbo Iisaa e cuucuukka, sabi omo hulannoo hooreeɓe Yahuudiyankooɓe. ");
INSERT INTO ffm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus jaanooɗo to Iisaa jemma oo duu wari, o jillondiri uurdiiji mbiyeteeɗi miiri e alo'e o waddori. Eɗum yaha e kilooji capantati e ɗiɗi. ");
INSERT INTO ffm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Non ɓe ɓamti tew Iisaa, ɓe nguji mo uurdi ndii, ɓe ngaɗi mo e kasanke hono no Yahuudiyankooɓe mboowiri waɗude fade mum'en irde maayɗo nii. ");
INSERT INTO ffm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nokku keewɗo leɗɗe ana wonnoo ɗo Iisaa tontanoo ɗoo. Yanaande heyre ana ley nokku oo, ɗo fay gooto meeɗaali watteede. ");
INSERT INTO ffm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ɗum hawri e wakkati lanndinal Yahuudiyankooɓe, tawi yanaande ndee ana ɓadii, ɗum waɗi so ɓe ndesi Iisaa ɗon. ");
INSERT INTO ffm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ɲannde alan, Mariyama mo Magdala hujji, yehi to yanaande too. O tawi haayre uddiranoonde yanaande ndee tallitaama. ");
INSERT INTO ffm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","O dogi, o yehi to Simon Piyeer e taalibbo mo Iisaa horsinnoo oo, o wii ɓe: —Ɓe ittii Moobbo oo e yanaande ndee, mi anndaa fuu ɗo ɓe ngaɗi mo. ");
INSERT INTO ffm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Piyeer e taalibbo oo njalti, njehi to yanaande too. ");
INSERT INTO ffm_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Eɓe ndoga ko ɓe mbaawi fuu. Taalibbo oo daɗi Piyeer, adii ɗum e yanaande ndee. ");
INSERT INTO ffm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","O yuurnii, o yii kasanke oo yo ɓolo, kaa o naataali. ");
INSERT INTO ffm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Piyeer, kaɲum kaa yottii fuu, naati, tawi kasanke oo ana jooɗii. ");
INSERT INTO ffm_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pilkol pilkanoongol e hoore Iisaa ngol tawdaaka e kasanke oo, ngol tawaama engol sowii feere maggol. ");
INSERT INTO ffm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nden taalibbo ardinooɗo warde oo, kaɲum duu naati, yii, goonɗini. ");
INSERT INTO ffm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Tawi ɓe paamaano tafon ko Binndi ɗii mbii koo, Iisaa yo immitintooɗo. ");
INSERT INTO ffm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Caggal mum, taalibaaɓe ɗiɗon ɓee kooti to mum'en. ");
INSERT INTO ffm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kaa Mariyama ana darii ɗo damal yanaande ɗoo, ana woya. O turii, o yuurnii ley yanaande ndee. ");
INSERT INTO ffm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","O yii malaa'ika'en ɗiɗon ɓe kaddule daneeje ana njooɗii ɗo tew Iisaa oo resanoo ɗoo, gooto ɗo hoore ɗoo, goɗɗo oo to koyɗe too. ");
INSERT INTO ffm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Malaa'ika'en ɓee mbii mo: —Banndam debbo, koɗum mboyataa? O jaabii ɓe: —Ɓe ittii Moobbo am ɗoo, mi anndaa fuu to ɓe ndesi ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nde o haalnoo kaa haala ndee, o yeeccitii, o yii Iisaa ana darii, kaa o annditaali ɗum. ");
INSERT INTO ffm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Iisaa wii mo: —Banndam debbo, koɗum mboyataa? Homo tewtataa? Mariyama miili golloowo nokku oo haaldata e mum, wii oon: —Giɗo, so aan itti mo ɗoo, haalanam ɗo ndesu-ɗaa mo, faa mi ɓamta mo. ");
INSERT INTO ffm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Iisaa wii mo: —Mariyama! O yeeccitii, o wii e ibaraninkoore: —Rabbunii! (Ɗum woni «Moobbo».) ");
INSERT INTO ffm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Iisaa wii mo: —Pati memam, sabi mi ŋabbitaali to Baabiraaɗo am tafon. Yaa to sakiraaɓe am, mbiyaa ɓe mi ŋabbitan to Baabiraaɗo am, Baabiraaɗo mon, Laamɗo am, Laamɗo mon. ");
INSERT INTO ffm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Mariyama mo Magdala martinoyi taalibaaɓe ɓee kumpa, wii ɓe: —Mi yii Moobbo oo. O haaltani ɓe ko Iisaa haalani mo koo fuu. ");
INSERT INTO ffm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nde kiikiiɗe alan warnoo ndee, taalibaaɓe Iisaa coki baafal dow hoore mum'en nokku ɗo ɓe kawriti ɗoo, saabe kulol hooreeɓe Yahuudiyankooɓe. Nden Iisaa wari darii hakkunde maɓɓe, wii ɓe: —Onon e jam! ");
INSERT INTO ffm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nde o jowtunoo ɓe ndee, o holli ɓe nebbe juuɗe makko e wuttuldu makko. Taalibaaɓe ɓee ceyii nde njii Joomiraaɗo oo ndee. ");
INSERT INTO ffm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Nden Iisaa wii ɓe kasen: —Onon e jam! Hono no Baabiraaɗo neliri kam nii, neliran-mi on. ");
INSERT INTO ffm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Nde o haalnoo ɗii haalaaji ndee, o fuufi e maɓɓe, o wii: —Njaɓɓee Ruuhu Ceniiɗo! ");
INSERT INTO ffm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Mo njaafi-ɗon luutti mum, yaafaama ɗi, mo on njaafaaki luutti mum, yaafataake. ");
INSERT INTO ffm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Kaa Tomaa noddirteeɗo Funeeru, gooto e sappo e ɗiɗon ɓee, walaano ɗon nde Iisaa ɓanngunoo hakkunde maɓɓe ndee. ");
INSERT INTO ffm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Taalibaaɓe ɓee mbii mo: —Min njii Moobbo men! O jaabii ɓe: —So mi yiyaali batte tontanɗe ɗee e nebbe makko, mi waɗa feɗeendu am e majje, mi waɗa junngo am e wuttuldu makko, abada mi goonɗintaa. ");
INSERT INTO ffm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Yontere wootere caggal mum, taalibaaɓe ɓee kawriti kasen. Tomaa ana wondi e maɓɓe. Baafe ɗee fuu ana cokii. Iisaa ɓanngi, darii hakkunde maɓɓe, wii: —Onon e jam! ");
INSERT INTO ffm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","O wii Tomaa: —Waddu ɗoo feɗeendu maa, ƴeew juuɗe am, waddu junngo maa, waɗu ngo e wuttuldu am. Sel sikkitaade, goonɗin tan. ");
INSERT INTO ffm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaa jaabii, wii mo: —Joomiraaɗo am, Laamɗo am. ");
INSERT INTO ffm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Iisaa wii mo: —Saabe a yii kam ngoonɗinir-ɗaa. Ɓeen ɓe njiyaali kam so ngoonɗini, mbelii hoore. ");
INSERT INTO ffm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Iisaa waɗii yeeso taalibaaɓe mum kaayɗe goɗɗe keewɗe ɗe mbinndaaka ley ndee dewtere. ");
INSERT INTO ffm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ɗee ɗoo mbinndaama, yalla oɗon ngoonɗina Iisaa woni AlmasiihuƁii Laamɗo oo, yalla so on ngoonɗinii, oɗon keɓira nguurndam saabe makko. ");
INSERT INTO ffm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Caggal ɗum, Iisaa ɓannganii taalibaaɓe mum ɓee kasen sera weendu Tiberiyas. Annii no mo ɓanngiri: ");
INSERT INTO ffm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Piyeer e Tomaa noddirteeɗo Funeeru oo e Natanayel mo Kaana leydi Galili e ɓiɓɓe Jebede worɓe ɓee e taalibaaɓe ɗiɗon woɓɓe, ɓe fuu eɓe tawdanoo ton. ");
INSERT INTO ffm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Piyeer wii ɓe: —Mi yahan awgal. Ɓe mbii mo: —Minen duu, min njaadan e maa. Ɗon e ɗon ɓe njalti, ɓe naatoyi laana. Oon jemma, ɓe keɓaali fay huunde. ");
INSERT INTO ffm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Nde fajiri feccii ndee, Iisaa darii dow daŋŋeere ndee, kaa taalibaaɓe ɓee annditaali ɗum Iisaa. ");
INSERT INTO ffm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","O wii ɓe: —Sukaaɓe, oɗon jogii ko ɲaametee naa? Ɓe mbii: —Min ngalaa! ");
INSERT INTO ffm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","O wii ɓe: —Tippee bubbol ngol bannge ɲaamo laana kaa, on keɓan. Non ɓe tippii ngol. Ɓe keɓi liɗɗi faa ɓe ndonki suutude ngol. ");
INSERT INTO ffm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Taalibbo mo Iisaa horsini oo wii Piyeer: —Ɗum Moobbo men! Nde Simon Piyeer nannoo ɗum moobbo mum'en ndee, ɓoornii saaya mum, sabi mo ɓoortinooɗo ka, mo fiyii e ndiyam ɗam. ");
INSERT INTO ffm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Taalibaaɓe heddiiɓe ɓee ngaddi laana kaa, ana ndaasa bubbol keewngol liɗɗi ngol. Ɓe ngoɗɗoraaki daŋŋeere ndee kinaa ko waarata e meeturuuji teemedere. ");
INSERT INTO ffm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nde ɓe ƴeentunoo ndee, ɓe njii liɗɗi ana pawii dow ƴulɓe yiite, ɓe njii buuru duu. ");
INSERT INTO ffm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Iisaa wii ɓe: —Ngaddee yoga e liɗɗi ɗi nanngu-ɗon jooni ɗii. ");
INSERT INTO ffm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Piyeer naati laana kaa, fooɗi bubbol ngol, ƴeŋŋini. Ngol keewngol liɗɗi mawɗi. Liɗɗi ɗii yo teemedere e capanɗe joy e tati. No ɗi poti heewde nii fuu, bubbol ngol seekaaki. ");
INSERT INTO ffm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Iisaa wii ɓe: —Ngaree, ɲaamee! Nde wonnoo ɓe fuu ɓe anndii ɗum Joomiraaɗo, fay gooto e taalibaaɓe ɓee lamndaaki mo «Aan homo?» ");
INSERT INTO ffm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nden Iisaa wari, ɓami buuru e liɗɗi, hokki ɓe. ");
INSERT INTO ffm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ngol woni cilol tataɓol ko Iisaa ɓanngani taalibaaɓe mum caggal immitagol mum. ");
INSERT INTO ffm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nde ɓe taƴunoo kooƴol ndee, Iisaa wii Simon Piyeer: —Simon ɓii Yuhanna, a ɓuraa ɓee ɗoo yiɗude kam naa? O jaabii: —Goonga, Moobbo, aɗa anndi miɗo yiɗu maa. Iisaa wii mo: —Tiiɗu e baaloy am! ");
INSERT INTO ffm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Iisaa wii mo kasen: —Simon, ɓii Yuhanna, aɗa yiɗi kam naa? O jaabii: —Sanne, Moobbo, aɗa anndi miɗo yiɗu maa! Iisaa wii mo: —Tiiɗu e baali am! ");
INSERT INTO ffm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Iisaa wii mo kasen: —Simon, ɓii Yuhanna, aɗa yiɗi kam naa? Piyeer sunaa sabi jooni woni cilol tataɓol ko Iisaa wii mo «Aɗa yiɗi kam naa?» Piyeer wii mo: —Joomiraaɗo, aɗa humpitii huunde fuu, aɗa anndi miɗo yiɗu maa. Iisaa wii mo: —Tiiɗu e baali am! ");
INSERT INTO ffm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Miɗo haalane goonga, e njokollaaku maa a ɓoornike kaddule maa, a yehii to njiɗ-ɗaa fuu. Kaa nde a naywii, a fooccan juuɗe maa, goɗɗo ɓoorne ɗe, naɓe to a yiɗaa. ");
INSERT INTO ffm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E ɗii haalaaji Iisaa sapporii no Piyeer maayrata e no teddinirta Laamɗo. Nde o haalnoo ɗum ndee, o wii ɗum: —Jokkam! ");
INSERT INTO ffm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piyeer yeeccitii, yii taalibbo mo Iisaa horsini oo ana jokki e mum'en. Kaɲum woni naayinooɗo e Iisaa nde ɓe kirtotonoo ndee, so wii: «Moobbo, homo woni jammbotooɗo ma oo?» ");
INSERT INTO ffm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Nde Piyeer yiinoo korsuɗo oo ndee, wii Iisaa: —Moobbo, hono oo nee wattinirta? ");
INSERT INTO ffm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Iisaa jaabii mo: —So miɗo muuyani mo nguurndam faa nde ngartu-mi, koɗum hillu maa hen? Aan kaa, jokkam tan. ");
INSERT INTO ffm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ngol konngol saakii hakkunde goonɗinɓe Iisaa fuu: «Taalibbo oo maayataa.» Kaa Iisaa wiyaali mo maayataa, ko o wii dee: «So miɗo muuyani mo nguurndam faa nde ngartu-mi, koɗum hillu maa hen?» ");
INSERT INTO ffm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Oo taalibbo seettii ɗee kulle so winndi ɗe, eɗen anndi duu seedaaku makko oo yo goonga. ");
INSERT INTO ffm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Iisaa waɗii kuɗɗe goɗɗe keewɗe kasen. So ɗe mbinndiranooma gootel gootel, miɗo miila ɗee dewte mbaawataano heƴude e aduna oo.");
INSERT INTO ffm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Waayam Tawfilus, e ley dewtere am aranndeere ndee, mi winndii hen ko Iisaa fuɗɗiri gollude e waajaade fuu, ");
INSERT INTO ffm_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","faa ɲannde nde mo ŋabbinaa ndee, caggal o wasike nelaaɓe ɓe o suɓorii Ruuhu Ceniiɗo ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Caggal nde o torraa ndee, o ɓannginani ɓe hoore makko, o hollirii ɓe e daliilaaji keewɗi omo wuuri. O wondi e maɓɓe balɗe capanɗe nay, omo waajoo ɓe haala Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ɲannde wootere omo ɲaamda e maɓɓe, o wasii ɓe pati ɓe ngoɗɗoo Urusaliima, ɓe kettoo fodoore Baabiraaɗo nde ɓe naniri mo ndee. O wii: ");
INSERT INTO ffm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","—Yaayaabatisirannoo ndiyam, kaa e ley balɗe seeɗa, onon, on mbatisirte Ruuhu Ceniiɗo. ");
INSERT INTO ffm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ɓe fuu ɓe kawri, ɓe lamndii mo, ɓe mbii: —Joomiraaɗo, e oo wakkati ngartirtaa laamu Israa'iila naa? ");
INSERT INTO ffm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Iisaa jaabii ɓe, wii: —On mbaawaa anndude jamaanuuji e wakkatiiji ɗi Baabiraaɗo waɗiri baawɗe mum. ");
INSERT INTO ffm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kaa so Ruuhu Ceniiɗo oo jippike e mooɗon, on keɓan baawɗe, on laatoto seedee'en am ley Urusaliima e ley leydi Yahuudiya fuu, kaɲum e Samariya, faa to leydi haaɗi. ");
INSERT INTO ffm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nde o haalnoo ɗum ndee, o ŋabbinaa. Ɓe tiggitii, eɓe ƴeewa faa luurde suddi mo. ");
INSERT INTO ffm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ɗo ɓe tiggitii kammu oo tawi omo ŋabbinee ɗoo, worɓe ɗiɗon ɓe kaddule daneeje ngari ndardii e maɓɓe, ");
INSERT INTO ffm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","mbii: —Galilinkooɓe, ko saabii so ndari-ɗon, oɗon ƴeewa kammu? Iisaa ittaaɗo e mon so ŋabbintinaa dow kammu oo wartiran hono no njiiru-ɗon omo ŋabbitira dow kammu nii. ");
INSERT INTO ffm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nde ɓe iwnoo to waamnde haayre wiyeteende Jaytun ndee, ɓe mbirfitii Urusaliima. Ton e Urusaliima ana waara e kilon gooto. ");
INSERT INTO ffm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nde ɓe njottii ndee, ɓe ŋabboyi suudu dowuuru ndu ɓe mboownoo mooɓtaade e mum nduu. Nelaaɓe ɓee ngoni: Piyeer e Yuhanna e Yaakuuba e Andire e Filipa e Tomaa e Bartolome e Matta e Yaakuuba ɓii Alfaa e Simon kiranoowo suudu baaba e Yahuuda ɓii Yaakuuba. ");
INSERT INTO ffm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɓe fuu ɓe laatii daande wootere, eɓe tiiɗi e duwaawu, kamɓe e miɲiraaɓe Iisaa e Mariyama inna Iisaa e rewɓe woɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ley ɗeen ɲalaaɗe, goonɗinɓe ko waarata e teemedere e noogay kawri. Piyeer immii, darii hakkunde maɓɓe, wii: ");
INSERT INTO ffm_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Sakiraaɓe, ko Ruuhu Ceniiɗo haaliri e hunduko Daawuuda, ko woni e Binndi ɗii koo, tabitirii no haaniri nii: o haaliino haala Yahuuda, kolluɗo nannguɓe Iisaa ɓee laawol oo. ");
INSERT INTO ffm_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","E meeɗen Yahuuda hiisetenoo, o heɓii ngeɗu makko e golle e nelal. ");
INSERT INTO ffm_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Kaalisi mo o yeenanoo e golle makko bonɗo oo, o soodi ɗum ngesa, o yehi o wartoyii ley magga, reedu makko seekii, teketi makko fuu mbaylii e leydi. ");
INSERT INTO ffm_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Yimɓe Urusaliima fuu nanii ɗum. Ɗum waɗi so ɓe inndiri ngesa ngaa Akeldama. E ley ɗemngal maɓɓe ɗum woni «Ngesa Ƴiiƴamaawa».) ");
INSERT INTO ffm_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Sabi ɗum winndii e ley dewtere Jabuura: «Yo galle makko laato saabeere, pati fay gooto hoɗu hen. Yo goɗɗo darto darnde makko.» ");
INSERT INTO ffm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Haya, worɓe yogaaɓe njaadii e men ko juuti gila nde Joomiraaɗo men Iisaa wondi e men ndee, ");
INSERT INTO ffm_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","iwde e wakkati mo Yaayaa looti mo lootogal batisima yaade e ɲalaande nde o ɓamtaa faade e kammu ndee. Joonnoo, ana tilsi gooto e maɓɓe laatidoo e men seedee immitagol Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ɓe ndarni worɓe ɗiɗon: Yuusufu noddirteeɗo Barasaba coowirteeɗo Yustus, kaɲum e Mattiyas. ");
INSERT INTO ffm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ɓe nduwii, ɓe mbii: —Joomiraaɗo, aan annduɗo ɓerɗe yimɓe fuu, fammin min mo cuɓi-ɗaa e ɓee ɗoo ɗiɗon ");
INSERT INTO ffm_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","faa roondoo golle e nelal, loomtoo Yahuuda joppuɗo ɗum so yehi to nokku mo haandi e mum oo. ");
INSERT INTO ffm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ɓe ngaɗi urwa maɓɓe. Urwa oo hawri e Mattiyas. O hiisodaa e nelaaɓe sappo e go'o ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nde iidi biyeteeɗo Pantekot warnoo ndee, goonɗinɓe Iisaa ɓee fuu mooɓtii e nokku gooto. ");
INSERT INTO ffm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Oon wakkati fuu, dillere wa'unde no henndu mawndu nii iwri dow kammu, hebbini suudu ɗo ɓe njooɗii ɗoo fuu. ");
INSERT INTO ffm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ko wa'i no ɗemɗe yiite nii ɓanngani ɓe. Ɗe peccii, ɗe pawii e gooto maɓɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ɓe fuu ɓe keewi Ruuhu Ceniiɗo, ɓe puɗɗi haalde ɗemɗe janane no Ruuhu oo hokkiri ɓe ɓe kaala nii. ");
INSERT INTO ffm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Worɓe Yahuudiyankooɓe hulɓe Laamɗo iwooɓe e tatteeji ɗii fuu ana njooɗii Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nde dillere ndee waɗunoo ndee, jamaa oo fuu hawriti, wemmbaa, sabi gooto fuu nanii ɗemngal mum ana haalee. ");
INSERT INTO ffm_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɓe fuu ɓe mbemmbaa, ɓe kaaynaa, ɓe mbiyondiri: —Ɓee haalooɓe fuu nganaa Galilinkooɓe naa? ");
INSERT INTO ffm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ɗum nee, hono hen gooto e meeɗen fuu nanirta ko ɓe kaalata e ɗemngal ngal muyni? ");
INSERT INTO ffm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","En Partiyankooɓe e Mediyankooɓe e Elamiyankooɓe, en jooɗiiɓe Mesopotamiya, kaɲum e Yahuudiya e Kappadokiya e Ponta e Asiya ");
INSERT INTO ffm_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","e Firigiya e Pamfiliya e Misira e leyɗe sera Libiya hedde Sireene. Yoga e meeɗen iwii e Roma, ");
INSERT INTO ffm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","en Yahuudiyankooɓe kaɲum e naatuɓe e diina Yahuudiyankooɓe. Yoga kasen iwii Kereta, yoga iwii leydi Arabiya. Kaa ɗum e taweede fuu, en fuu eɗen nii nana eɓe kaala e ɗemɗe meeɗen golleeji mawɗi ɗi Laamɗo waɗi ɗii! ");
INSERT INTO ffm_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɓe fuu ɓe mbemmbaa, ɓe cikkitii, ɓe mbiyondiri: —Koɗum ɗum foti laataade? ");
INSERT INTO ffm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Woɓɓe ana njaayra goonɗinɓe ɓee, ana mbiya: —Ɓe haarɓe doro so eɓe cigira! ");
INSERT INTO ffm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piyeer dardii e sappo e go'o ɓee, toowni daande muuɗum, wii jamaa oo: —Onon Yahuudiyankooɓe e onon jooɗiiɓe Urusaliima fuu, kettinee haala am yalla oɗon paama kabaaru gaɗuɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ɓee yimɓe nganaa sigirɓe hono no onon miildaton nii, sabi jooni yo ɲawlal tan. ");
INSERT INTO ffm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ɗum woni ko annabi Yo'ila wii: ");
INSERT INTO ffm_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","«Laamɗo wii: E ley ɲalaaɗe cakitotooɗe ɗee mi saakan Ruuhu am e dow tagaaɓe fuu. Ɓiɓɓe mooɗon worɓe e rewɓe kaaliran hono no annabaaɓe nii, jokolɓe mooɗon njiyan ko ƴellitii e mum'en, nayeeɓe mooɗon koyɗinte. ");
INSERT INTO ffm_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Fay gollooɓe am worɓe e gollooɓe am rewɓe, mi saakan Ruuhu am dow muuɗum'en e ley ɗeen ɲalaaɗe, ɓe kaaltan konngol ngol loow-mi e maɓɓe ngol. ");
INSERT INTO ffm_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi waɗan kaayɗe dow kammu, mi waɗan taagumansaaji dow leydi, ɗi laatoo ƴiiƴam e yiite e cuurki. ");
INSERT INTO ffm_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Fade ɲannde gartol Joomiraaɗo mawnde teddunde ndee warde, naange niɓɓan, lewru wojjan hono no ƴiiƴam nii. ");
INSERT INTO ffm_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nden, neɗɗo fuu nodduɗo innde Joomiraaɗo hisinte.» ");
INSERT INTO ffm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piyeer wii kasen: —Israa'iilankooɓe, kettinee ɗii haalaaji: Iisaa Nasaraatunke oo yo neɗɗo mo Laamɗo suɓanii on. Laamɗo hokki ɗum baawɗe, o hokki ɗum waɗude kaayɗe e taagumansaaji hakkunde mon, no onon e ko'e mon anndir-ɗon nii. ");
INSERT INTO ffm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","On ngaɗii oon neɗɗo e juuɗe bonɓe, on tontii mo e leggal bardugal, on mbaririi mo no Laamɗo muuyrunoo ɗum laatoo gila arannde nii. ");
INSERT INTO ffm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kaa Laamɗo wuurtinii mo, itti mo e naawalla maayde, sabi maayde ndee waawaanoo heddoraade mo. ");
INSERT INTO ffm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Sabi Daawuuda ana haala haala makko nde wii: «Wakkati fuu miɗo yiya Joomiraaɗo, sabi omo ɲaamo am, pati mi yeryerta. ");
INSERT INTO ffm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Saabe majjum ɓernde am seyii, ɗemngal am jaarii faa terɗe am duu mbaaltoo dow jikke, ");
INSERT INTO ffm_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","sabi a yoppataa yonki am hakkunde maayɓe, a accataa Ceniiɗo maa oo ɲola. ");
INSERT INTO ffm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A anndinii kam laawi nguurndam, miɗo seyii sabi aɗa wondi e am.» ");
INSERT INTO ffm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piyeer jokkini hen: —Sakiraaɓe, miɗo haalana on ko laaɓi haala njaati meeɗen Daawuuda: o maayii, o iraama, yanaande makko ndee ana ɗo meeɗen ɗoo faa hannde. ");
INSERT INTO ffm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","O annabaajo, omo anndi Laamɗo hunanike mo gooto e taaniraaɓe makko joottoto e bimmbeere makko laamu. ");
INSERT INTO ffm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","O adii o yii o haali haala immitagol Almasiihu, kaɲum yonki muuɗum accaaka hakkunde maayɓe, terɗe muuɗum ɲolaali. ");
INSERT INTO ffm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Oo woni Iisaa mo Laamɗo immintini, min fuu miɗen ceedii. ");
INSERT INTO ffm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Laamɗo toowni mo, heedini mo ɲaamo muuɗum, mo heɓi e Baabiraaɗo Ruuhu Ceniiɗo podananooɗo en oo, o saaki ɗum. Jooni oɗon njiya ɗum, oɗon nana ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Sabi Daawuuda meeɗaali ŋabbude dow kammu, kaa wii: «Joomiraaɗo wii Joomam: Jooɗa ɲaamo am, ");
INSERT INTO ffm_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","faa mi waɗa njaɓɓaa wayɓe maa.» ");
INSERT INTO ffm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Yo suudu baaba Israa'iila fuu taƴor Laamɗo waɗii Iisaa mo tontu-ɗon e leggal bardugal oo Joomiraaɗo, waɗii ɗum Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nde ɓe nannoo kaa haala ndee, ɓe taƴi sanne, ɓe mbii Piyeer e nelaaɓe heddiiɓe ɓee: —Sakiraaɓe, koɗum min ngaɗata? ");
INSERT INTO ffm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piyeer jaabii ɓe, wii: —Tuubee, gooto e mooɗon fuu lootiree lootogal batisima e innde Iisaa Almasiihu, yalla oɗon keɓa yaafeede luutti. Nden on ndokkete Ruuhu Ceniiɗo. ");
INSERT INTO ffm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Sabi fodoore ana woodani on, onon e ɓiɓɓe mooɗon e woɗɗuɓe fuu. Ende woodani neɗɗo mo Joomiraaɗo Laamɗo meeɗen noddi fuu. ");
INSERT INTO ffm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Caggal ɗum, Piyeer seedanike ɓe haalaaji goɗɗi keewɗi, ana waajoo ɓe, ana wiya: —Celee e ndee fedde bonnde yalla oɗon kisa. ");
INSERT INTO ffm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jaɓuɓe haala makko ɓee lootaa lootogal batisima. Ɲannde nden, ana foti ujunaaji tati neɗɗo ko naati e deental goonɗinɓe ngal. ");
INSERT INTO ffm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eɓe njokki waaju nelaaɓe ɓee, eɓe nanngondiri e deental maɓɓe ngal, eɓe taƴa buuru, kasen eɓe ngaɗida duwaawuuji. ");
INSERT INTO ffm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kulol naati e gooto fuu, sabi nelaaɓe ɓee kaɲum'en duu ana ngaɗannoo kaayɗe e taagumansaaji keewɗi. ");
INSERT INTO ffm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Goonɗinɓe ɓee fuu yo daande wootere, ɓe ngaɗi fii maɓɓe fuu foroba. ");
INSERT INTO ffm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ɓe cootti jawleele maɓɓe, ɓe ndokki gooto fuu ko hasindini e muuɗum. ");
INSERT INTO ffm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ɲannde fuu ɓe kawritan ley Suudu Dewal Mawndu nduu, ɓe laatii daande wootere, eɓe taƴa buuru, eɓe ɲaamda ley cuuɗi maɓɓe ley weltaare e seyo. ");
INSERT INTO ffm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Eɓe njetta Laamɗo, yimɓe fuu ana njiɗi ɓe. Ɲannde fuu Joomiraaɗo ana ɓeydana deental ngal hisooɓe. ");
INSERT INTO ffm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Piyeer e Yuhanna naaddi ley Suudu Dewal Mawndu nduu wakkati sallifanaa. ");
INSERT INTO ffm_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tawi gorko bonnguujo pinduɗo e bonnguwaaku ana jooɗii damal Suudu Dewal Mawndu mbiyeteengal Damal Lobbal. Ɲannde fuu yimɓe makko njoƴƴinan mo ɗon faa o garbinoo naatooɓe Suudu Dewal Mawndu ɓee sadaka. ");
INSERT INTO ffm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nde o yii Piyeer e Yuhanna ana naata ndee, o garbinii ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ɓe taykitii mo, non Piyeer wii: —Ƴeew min! ");
INSERT INTO ffm_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","O ƴeewi ɓe, sabi omo miilii heɓude e maɓɓe huunde. ");
INSERT INTO ffm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Piyeer wii: —Mi walaa kaalisi, mi walaa kaŋŋe, kaa mi hokkete ko njogii-mi koo: saabe Iisaa Almasiihu Nasaraatunke oo, imma yaa! ");
INSERT INTO ffm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","O nanngi junngo muuɗum ɲaamo, o darni ɗum. Ɗon e ɗon koyɗe muuɗum teeŋi e leydi, ");
INSERT INTO ffm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","gurbitii, darii, ana yiiloo. O naatidi e maɓɓe ley Suudu Dewal Mawndu nduu, omo yiiloo, omo fitta, omo yetta Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Yimɓe ɓee fuu njii mo, omo yiiloo, omo yetta Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ɓe annditi mo, kanko woni jooɗotonooɗo e Damal Lobbal ngal so ana garbinoo oo. Kaayɗe e wemmbere nanngi ɓe sanne saabe ko o heɓi koo. ");
INSERT INTO ffm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ɗo o jokkondirnoo e Piyeer e Yuhanna ɗoo, yimɓe ɓee fuu ndogi kawriti e maɓɓe to ndanki mbiyeteeki ndanki Suleymaana too no poti haayneede. ");
INSERT INTO ffm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nde Piyeer yiinoo ɗum ndee, wii yimɓe ɓee: —Israa'iilankooɓe, ko waɗi so oɗon kaaynee ɗum ɗoo? Ko waɗi so oɗon puttina min gite, hono baawɗe amen naa kulol amen Laamɗo waɗi so oo gorko ana yaha e koyɗe muuɗum? ");
INSERT INTO ffm_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Laamɗo Ibarahiima e Isiyaaka e Yaakuuba, Laamɗo njaatiraaɓe meeɗen, teddini kaadime muuɗum Iisaa. Kaa onon on ngaɗii mo e juuɗe laamu, on njankirii mo yeeso Pilaatu, fay so taweede Pilaatu ana yiɗunoo yoppitinde mo. ");
INSERT INTO ffm_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kaa onon, on njankirii Ceniiɗo Pooccitiiɗo oo, on ndaartii yoppitaneede barɗo hoore. ");
INSERT INTO ffm_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Gaddoowo nguurndam nduumiiɗam oo, oon mbar-ɗon. Kaa Laamɗo wuurtinii mo e maayde. Miɗen ceedii ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Gorko mo njiyaton mo anndu-ɗon oo, ko mo goonɗini Iisaa koo sellini mo yeeso mooɗon on fuu. ");
INSERT INTO ffm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Haya, sakiraaɓe, hono ko onon e hooreeɓe mooɗon ngaɗu-ɗon Almasiihu koo, miɗo anndi yo majjere tan. ");
INSERT INTO ffm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kaa hono nii Laamɗo tabintiniri ko annabaaɓe muuɗum fuu kaali koo: Almasiihu torroto. ");
INSERT INTO ffm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ndennoo tuubee, ngarton, yalla luutti mooɗon ana tosee, ");
INSERT INTO ffm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","yalla Joomiraaɗo ana waddana on wakkatiiji ceyniiɗi, nelda on Iisaa Almasiihu cuɓananooɗo on gila arannde oo. ");
INSERT INTO ffm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ana tilsi oon heddoo dow kammu faa nde Laamɗo heyɗintini kulle ɗee fuu, no annabaaɓe seniiɓe ɓee kaaldunoo haala muuɗum gila arannde nii. ");
INSERT INTO ffm_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sabi Muusaa wii: «Joomiraaɗo Laamɗo mooɗon nelan e mon annabaajo hono am, sakiike mon. Njaɓon huunde fuu ko o haalanta on. ");
INSERT INTO ffm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Neɗɗo fuu mo jaɓanaali annabaajo oo, yaltinte e suudu baaba, halkete.» ");
INSERT INTO ffm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Gila e Samuyila faa e annabaaɓe jokkuɓe e muuɗum, ɓe fuu eɓe kaalannoo haala ɗee ɲalaaɗe. ");
INSERT INTO ffm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Onon ngoni ronooɓe annabaaɓe ɓee, onon ngoni ronooɓe aadi ndi Laamɗo nanngani njaatiraaɓe men ɓee nde wii Ibarahiima: «E iwdi maa, cuuɗi baaba aduna oo fuu keɓirta barke.» ");
INSERT INTO ffm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nde Laamɗo immintinnoo Iisaa kaadime muuɗum oo ndee, e mooɗon o adii nelde ɗum, faa o waɗa e mon barke e ley ko o wartirta homo e mon fuu e makko so njoppon golle mon bonɗo. ");
INSERT INTO ffm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nde Piyeer e Yuhanna kaaldata e yimɓe ɓee ndee, yottinooɓe sadaka e mawɗo haybooɓe Suudu Dewal Mawndu oo, kaɲum e Saduki'en ngari e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Eɓe mettaa sabi Piyeer e Yuhanna ana njanngina yimɓe ɓee haala immital maayɓe, ko ɓe mbii Iisaa wuurtii koo. ");
INSERT INTO ffm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ɓe nanngi ɓeen, ɓe uddi ɗum'en e kasu faa janngo muuɗum, sabi tawii hiiriino. ");
INSERT INTO ffm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kaa heewɓe e nanɓe waaju oo ɓee ngoonɗini, faa ɓe laatii ko foti ujunaaji joy gorko. ");
INSERT INTO ffm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Janngo muuɗum, hooreeɓe maɓɓe e mawɓe e dunkee'en Sariya kawritoyi Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas Jottinoowo Sadaka Mawɗo oo e Kayafas e Yuhanna e Aleksandere e iwdi hooreeɓe yottinooɓe sadaka ndii fuu ana ton. ");
INSERT INTO ffm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Ɓe ndarni Piyeer e Yuhanna yeeso maɓɓe, ɓe lamndii ɗum'en e dow dabare honde naa alhorma homo ɓe celliniri bonnguujo oo. ");
INSERT INTO ffm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nden, Piyeer keewɗo Ruuhu Ceniiɗo oo wii ɓe: —Hooreeɓe e mawɓe, ");
INSERT INTO ffm_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","so on lamndike min hannde moƴƴere nde min ngaɗani bonnguujo oo ndee, on lamndike min no o selliri, ");
INSERT INTO ffm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","oɗon kaani anndineede ɗum, onon e Israa'iilankooɓe ɓee fuu. Saabe Iisaa Almasiihu Nasaraatunke mo tontuno-ɗon e leggal bardugal so Laamɗo wuurtini ɗum oo, kaɲum darni mo yeeso mon so sellini mo. ");
INSERT INTO ffm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Iisaa woni: «haayre nde onon mahooɓe tippiti-ɗon, laatiinde haayre ɓurnde fuu teentilaade e maadi ndii.» ");
INSERT INTO ffm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kisindam heɓirtaake e goɗɗo fey, innde wonnde duu walaa ley aduna oo fuu nde Laamɗo hokki yimɓe nde kaan-ɗen hisinireede. ");
INSERT INTO ffm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nde waalde Saahiiɓe ɓee njiinoo cuusal Piyeer e Yuhanna ndee, ɓe kaaynaa, sabi eɓe anndi ɓeen njannginaaka, ɓe baadiyankooɓe. Ɓe annditi ɓeen ana ngondunoo e Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kaa nde ɓe njiinoo gorko cellinaaɗo oo ana dardii e maɓɓe, walaa fuu ko ɓe mbaawi yeddude. ");
INSERT INTO ffm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ɓe njamiri yo ɓeen njaltu sarirde ndee, eɓe ndawrida, ");
INSERT INTO ffm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","eɓe mbiya: —Koɗum ngaɗaten ɓee ɗoo worɓe ɗiɗon? Tabitanii hoɗuɓe Urusaliima fuu, ɓe ngaɗii ɗoo haaynde maanunde, kasen duu en mbaawaa yeddude ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kaa ndaalo-ɗen ɓe, kaɗen ɓe haalande fay gooto innde Iisaa ndee pati ɗum saakoo e ley yimɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nden ɓe nodditi ɓeen kasen, ɓe njaggini ɗum'en pati mbaajoo, pati njanngina innde Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kaa Piyeer e Yuhanna njaabii ɓe, mbii: —Onon e ko'e mooɗon, ƴeewee yalla ɗowtanaade on luutta Laamɗo woni goonga. ");
INSERT INTO ffm_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Minen kaa, min mbaawaa ŋoottude haalde ko min njiiri gite amen e ko min naniri noppi amen. ");
INSERT INTO ffm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ɓe ndaalii ɓeen kasen. Caggal ɗum, ɓe njoppiti ɗum'en, tawi ɓe keɓaali fay huunde ko ɓe njukkira ɗum'en saabe yimɓe ɓee. Sabi yimɓe fuu ana njetta Laamɗo dow ko waɗi koo. ");
INSERT INTO ffm_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Celliniraaɗo haaynde ndee oo, duuɓi muuɗum ana ɓuri capanɗe nay. ");
INSERT INTO ffm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nde ɓe njoppaa ndee, Piyeer e Yuhanna mbirfitii to yimɓe muuɗum'en, njantanii ɗum ko hooreeɓe yottinooɓe sadaka e mawɓe mbii ɗum'en koo fuu. ");
INSERT INTO ffm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nde ɓeen nani ɗum ndee, ɓe fuu ɓe laatii daande wootere, ɓe eewnii Laamɗo, ɓe mbii: —Laamɗo, taguɗo kammu e leydi e geeci e ko woni e muuɗum'en fuu, ");
INSERT INTO ffm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","aan kaalirɗo dow baawɗe Ruuhu Ceniiɗo e hunduko njaati amen Daawuuda kaadime maa nde oon wii: «Ko saabanii leɲi jirkitaade? Ko saabanii yimɓe miilde miilooji ɓoli? ");
INSERT INTO ffm_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kaanankooɓe aduna ndarii, ardiiɓe mooɓtondiri faa kaɓa e Joomiraaɗo e Almasiihu muuɗum.» ");
INSERT INTO ffm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Taƴoral, e ley ndee ngalluure Hirudus e Pontiyu Pilaatu nanngondirii e Israa'iilankooɓe e leɲi goɗɗi faa kaɓa e Iisaa, kaadime maa ceniiɗo mo cuɓi-ɗaa oo, ");
INSERT INTO ffm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","yalla eɓe ngolla ko koddirno-ɗaa baawɗe maa e muuyɗe maa fuu. ");
INSERT INTO ffm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Jooni Joomiraaɗo, ƴeew gidi maɓɓe ɗii, ndokkaa gollooɓe maa waajoraade haala maa fuu cuusal, ");
INSERT INTO ffm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ɓanngin baawɗe maa, sellin ɲawɓe, waɗu taagumansaaji e kaayɗe saabe Iisaa, kaadime maa ceniiɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nde ɓe tilinoo ɲaagaade Laamɗo ndee, nokku ɗo ɓe kawritinnoo ɗoo dimmbii. Ɓe fuu ɓe kebbinaa Ruuhu Ceniiɗo, eɓe mbaajoroo konngol Laamɗo ngol cuusal. ");
INSERT INTO ffm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jamaa goonɗinɓe oo fuu yo daande wootere yo hakkille gooto. Ɓe ngaɗi ko ɓe njogii fuu foroba, fay gooto e maɓɓe wiyantaa jawdi muuɗum fay huunde. ");
INSERT INTO ffm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Baawɗe mawɗe nelaaɓe ɓee ceettortonoo immitagol Iisaa Joomiraaɗo, kasen duu moƴƴere mawnde ana e maɓɓe ɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Fay gooto e maɓɓe hasindinaa, sabi jogiiɓe gese e galleeji fuu coottan, ngadda kaalisi oo, ");
INSERT INTO ffm_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","tummba ɗum e juuɗe nelaaɓe ɓee. Nden homo e maɓɓe fuu hokkee ko hasindini e muuɗum. ");
INSERT INTO ffm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iwɗo e leɲol Lewi biyeteeɗo Yuusufu, mo nelaaɓe ɓee coowirannoo Barnabas (ɗum woni ɓii koomtoowo), pinɗo Kiprus, ");
INSERT INTO ffm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ana joginoo ngesa, sootti nga, waddi kaalisi oo, tummbi ɗum e juuɗe nelaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gorko biyeteeɗo Ananiyas ana wondi e jom suudu muuɗum Safiira. O sootti ngesa makko. ");
INSERT INTO ffm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","O suuɗi feccere e kaalisi oo, jom suudu makko oo ana anndani. O naɓi ko heddii koo, o hokki nelaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Piyeer wii: —Ananiyas, ko saabii so accu-ɗaa Ibiliisa naata e ɓernde maa faa penanaa Ruuhu Ceniiɗo, cuuɗaa yoga e coggu ngesa ngaa? ");
INSERT INTO ffm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Tama wanaa aan e hoore maa jeynoo nga? Tama nde coottu-ɗaa nga ndee, a waawaano nawtoraade kaalisi oo? Ko hewti maa so ngaɗ-ɗaa nii? Wanaa yimɓe penan-ɗaa, Laamɗo penan-ɗaa. ");
INSERT INTO ffm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Nde Ananiyas nani kaa haala ndee, taƴi, saami, maayi. Ɗum laatanii nanɓe ɗum ɓee fuu kulol manngol. ");
INSERT INTO ffm_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sukaaɓe jokolɓe immii, ngaɗi mo e kasanke, ndoondii mo, njalti sella, iri mo. ");
INSERT INTO ffm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Caggal muuɗum, ko waarata e leeruuji tati, jom suudu makko naati, tawi nanaali ko waɗi koo. ");
INSERT INTO ffm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piyeer wii mo: —Haalanam so tawii ɗum jaati coottu-ɗon ngesa mooɗon ngaa? O wii: —Ooho, ɗum jaati min cootti. ");
INSERT INTO ffm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nden Piyeer wii mo: —Hono aan e jom suudu maa kawrir-ɗon faa itton koro Ruuhu Joomiraaɗo? Muɲu, iroynooɓe jom suudu maa ana ngara, naa ɓe naɓe, aan duu! ");
INSERT INTO ffm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Oon wakkati fuu, kanko duu o taƴi, o saami yeeso Piyeer, o maayi. Jokolɓe ɓee naati, tawi o maayii, ɓe ndoondii mo, ɓe njalti sella, ɓe iri mo bannge jom suudu makko. ");
INSERT INTO ffm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kulol manngol nanngi deental goonɗinɓe ɓee e nanɓe ɗum ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nelaaɓe ɓee ana ngaɗannoo taagumansaaji e kaayɗe keewɗe hakkunde yimɓe ɓee. Goonɗinɓe ɓee fuu ana kawrita ley ndanki Suleymaana kii, ɓe fuu ɓe daande wootere. ");
INSERT INTO ffm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Fay gooto e woɓɓe ɓee suusaa takkaade e maɓɓe. Kaa ɗum e taweede yimɓe ɓee ana teddina ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Goonɗinɓe Joomiraaɗo ɓee ana ɓeydoroo yimɓe heewɓe, jamaa worɓe e rewɓe, ");
INSERT INTO ffm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","faa ɓe ndoondii ɲawɓe, ɓe njaltini ɗum'en dow mbeddaaji, eɓe lelna ɗum'en e dow leese e daage, yalla so Piyeer warii, mbeelu muuɗum ana mema yoga maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yimɓe heewɓe iwri e geelle piliiɗe Urusaliima ɗee, ngaddi ɲawɓe e laddaaɓe. Ɓeen fuu cellinaa. ");
INSERT INTO ffm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ndennoo, Jottinoowo Sadaka Mawɗo oo e tawdaaɓe e muuɗum hakkille ɓee, ɗum woni Saduki'en, haasidaaku naati e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ɓe nanngi nelaaɓe ɓee, ɓe uddi ɗum'en ley kasu. ");
INSERT INTO ffm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kaa e oon jemma, malaa'ika Joomiraaɗo udditi dame kasu oo ɗee, yaltini ɓe, wii: ");
INSERT INTO ffm_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Njehee ndaroyee ley Suudu Dewal Mawndu too, mbaajo-ɗon yimɓe haalaaji dokkooji nguurndam kesam ɗii fuu. ");
INSERT INTO ffm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nde ɓe nannoo ɗum ndee, ɓe naatoyi e Suudu Dewal Mawndu nduu gila beetee, eɓe njanngina. Non Jottinoowo Sadaka Mawɗo oo e battaa'en mum noddi waalde Saahiiɓe e mawɓe Israa'iila fuu batu. Ɓe njamiri nelaaɓe ɓee ittoyee to kasu too, ngaddee. ");
INSERT INTO ffm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kaa nde doomooɓe ɓee njottinoo ndee, tawaali ɓeen e ley kasu oo. Ɓe mbirfitii, ɓe kaaltani waalde Saahiiɓe ɓee, ɓe mbii: ");
INSERT INTO ffm_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Min tawii kasu oo ana uddii ana sokii, doomooɓe ɓee ana ndarii sella ana pewtondiri e dame ɗee, kaa nde min udditinnoo ndee, min tawaali fay gooto ley too. ");
INSERT INTO ffm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nde mawɗo doomooɓe Suudu Dewal Mawndu oo e hooreeɓe yottinooɓe sadaka ɓee nani ɗum ndee, ɓe mbemmbaa ko ɗum foti laataade. ");
INSERT INTO ffm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nden neɗɗo gooto wari, humpiti ɓe, wii: —Worɓe ɓe udduno-ɗon kasu ɓee, annii ndarii ley Suudu Dewal Mawndu too, ana njanngina yimɓe! ");
INSERT INTO ffm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nden, mawɗo doomooɓe oo yaadi e doomooɓe, ngartiri nelaaɓe ɓee. Kaa ɓe ngaɗiraali ɗum doole sabi eɓe kula pati yimɓe mbedoo ɓe kaaƴe. ");
INSERT INTO ffm_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nde ɓe ngartiri ɓeen ndee, ɓe ndarni ɗum'en yeeso waalde Saahiiɓe ɓee. Jottinoowo Sadaka Mawɗo oo lamndii ɓe, ");
INSERT INTO ffm_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","wii: —Min ndaalinoke on daaloore sattunde, pati njannginon haala gorko oo. Kaa onon on caakii waaju mooɗon oo ley Urusaliima. Kasen duu, oɗon njiɗi min ngoytiree gorko oo. ");
INSERT INTO ffm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Piyeer e nelaaɓe ɓee njaabii, mbii: —Neɗɗo ana haani ɗowtanaade Laamɗo faa ɓura no ɗowtirantoo yimɓe nii. ");
INSERT INTO ffm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Laamɗo njaatiraaɓe meeɗen wuurtinii Iisaa mo tontu-ɗon e leggal so mbar-ɗon ɗum oo. ");
INSERT INTO ffm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kanko Laamɗo teddini so toowni, so joƴƴini bannge muuɗum ɲaamo, waɗi mo hooreejo, waɗi mo kisinoowo faa o hokka Israa'iilankooɓe no tuubira, yalla ana keɓa yaafeede luutti. ");
INSERT INTO ffm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Minen ngoni seedee'en kabaaruuji ɗii, minen e Ruuhu Ceniiɗo mo Laamɗo hokki ɓeen ɗowtaniiɓe ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nde ɓe nani ɗum ndee, ɓe mbilaa sanne, ɓe ndawridi no ɓe mbarda ɓeen. ");
INSERT INTO ffm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Gorko jeyaaɗo e waalde Farisa'en biyeteeɗo Gamaliyel, jannginoowo Sariya Muusaa, tedduɗo e yimɓe fuu, immii darii hakkunde waalde Saahiiɓe ɓee, yamiri nelaaɓe ɓee njaltinee seeɗa. ");
INSERT INTO ffm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Caggal ɗum, o wii ɓe: —Israa'iilankooɓe, ndeenee ko'e mon e ɓee yimɓe e ko anniyi-ɗon waɗude koo. ");
INSERT INTO ffm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tewdas ɓanngiino ko ɓooyaali. Omo jogorinoo hoore makko won no o foti. Ko waarata e yimɓe teemeɗe nayon ana njokkunoo e makko. O waraama, jokkunooɓe e makko ɓee fuu caakike, fay gooto heddaaki. ");
INSERT INTO ffm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Caggal makko, Yahuuda Galilinke oo wariino wakkati limgal, yimɓe heewɓe njokkii e makko. O halkike kanko duu, jokkunooɓe e makko ɓee fuu caakike. ");
INSERT INTO ffm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jooni, miɗo haalana on: ngoortee ɓee yimɓe, celon e maɓɓe. Sabi so anniyaaji maɓɓe e golle maɓɓe to yimɓe iwri, firritoto. ");
INSERT INTO ffm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kaa so nii tawii to Laamɗo iwri, on mbaawaa sakkaade ɗum. Kaybee, pati on luuttu Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Waalde Saahiiɓe ɓee njaɓi dabare makko. Ɓe nodditi nelaaɓe ɓee, ɓe pii ɗum'en, ɓe ndaalii ɗum'en pati kaala haala innde Iisaa kasen, ɓe njoppiti ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nelaaɓe ɓee iwi yeeso waalde Saahiiɓe ɓee. Ɓe ceyii sabi Laamɗo ana teddini ɓe, ko yimɓe koyni ɓe saabe Iisaa koo. ");
INSERT INTO ffm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Gila ɗum waɗi, ɓe keraali e waajaade e jannginde Kabaaru Lobbo haala Iisaa Almasiihu ley Suudu Dewal Mawndu nduu e ley galleeji. ");
INSERT INTO ffm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","E ɗeen balɗe, tawi taalibaaɓe ɓee ana ɓeydoo heewde, Yahuudiyankooɓe haalooɓe yunaninkoore ngullanii Yahuudiyankooɓe haalooɓe ibaraninkoore, sabi rewɓe mum'en talka'en ɓe worɓe mum'en maayi ɓee njakkantaake hiraande so yimɓe fuu ana njakkanee. ");
INSERT INTO ffm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nelaaɓe sappo e ɗiɗon ɓee noddi jamaa goonɗinɓe oo fuu, mbii: —Minen, yoppude konngol Laamɗo, min kiinnoo jakkaade hiraande, sellantaa min. ");
INSERT INTO ffm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sakiraaɓe, cuɓee hakkunde mooɗon worɓe njeɗɗon anndiraaɓe gikku lobbo, heewɓe Ruuhu Ceniiɗo e caahu, faa min keettina ɗum'en e oon golle. ");
INSERT INTO ffm_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Minen kaa, accon min kiinnoo waɗude duwaawu e waajaade konngol Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Haala kaa weli goonɗinɓe ɓee fuu. Nden ɓe cuɓii Eciyen, gorko goonɗinɗo keewɗo Ruuhu Ceniiɗo oo, kaɲum e Filipa e Porokor e Nikanor e Timon e Parmenas e Nikolas, jeyaaɗo Antiyokiya naatuɗo e diina Yahuudiyankooɓe oo. ");
INSERT INTO ffm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ɓe ndarnaa yeeso nelaaɓe ɓee. Ɓeen pawi juuɗe muuɗum'en e dow maɓɓe, nduwanii ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Konngol Laamɗo ana yaaja yaade, taalibaaɓe ana ɓeydoo heewde sanne e ley Urusaliima. Yottinooɓe sadaka heewɓe ngoonɗini Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Eciyen, keewɗo moƴƴere e baawɗe Laamɗo oo, ana waɗannoo kaayɗe e taagumansaaji mawɗi hakkunde yimɓe. ");
INSERT INTO ffm_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Kaa won yoga e jeyaaɓe e waajordu wiyeteendu waajordu rimɗinaaɓe, kaɲum e iwɓe Sireene e Aleksandiri e Silisi e Asiya, immaniiɓe mo ana ndukida e makko, ");
INSERT INTO ffm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","kaa ɓe ndonkii jaalaade mo saabe omo haaldira e maɓɓe hakkilantaaku e Ruuhu. ");
INSERT INTO ffm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nden ɓe kaaldi e yimɓe yalla ana mbiya nanii omo yenna Muusaa e Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nii ɓe njirkitiri jamaa oo e mawɓe ɓee e dunkee'en Sariya ɓee. Nden, ɓe nanngi Eciyen, ɓe naɓi ɗum to waalde Saahiiɓe too, ");
INSERT INTO ffm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ɓe ngaddi seedee'en peneeɓe, ana mbiya: —Oo gorko ŋoottaali yennude Suudu Dewal Mawndu nduu, o ŋoottaali yennude Sariya Muusaa. ");
INSERT INTO ffm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Min nanii omo wiya Iisaa Nasaraatunke oo wurjinan suudu nduu, waylita aadaaji ɗi Muusaa ɗaldi en ɗii. ");
INSERT INTO ffm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Saahiiɓe jooɗiiɓe ton ɓee fuu puttini Eciyen gite, njii yeeso makko ana wa'i no yeeso malaa'ika nii. ");
INSERT INTO ffm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nden Jottinoowo Sadaka Mawɗo oo lamndii: —Ko ɓe mbii koo, hono non worri naa? ");
INSERT INTO ffm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Eciyen jaabii, wii: —Sakiraaɓe e baabiraaɓe, accee hakke, kettinee! Laamɗo tedduɗo oo ɓannganii njaati meeɗen Ibarahiima nde wonnoo leydi Mesopotamiya, fade muuɗum hoɗoyde Haran, ");
INSERT INTO ffm_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","wii ɗum: «Eggu e leydi maa e suudu baam maa, njahaa e leydi ndi kollan-maa-mi ndii.» ");
INSERT INTO ffm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Nden Ibarahiima iwi leydi Kaldiya, yehi hoɗoyi Haran. Caggal maayde baam mum, Laamɗo eggini ɗum ɗon, waddi ɗum e ndii ɗoo leydi, ndi koɗu-ɗon e muuɗum joonin ndii. ");
INSERT INTO ffm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Laamɗo hokkaali mo e leydi ndii fay taaɓannde, kaa fodii hokkude mo ndi, ndi laatoo halal makko, kanko e iwdi makko, fay so taweede o walaa ɓiɗɗo tafon. ");
INSERT INTO ffm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Annii ko Laamɗo wii: «Iwdi maa feran jooɗoyoo leydi jananndi, maree, torree duuɓi teemeɗe nay. ");
INSERT INTO ffm_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kaa leɲol marngol ɓe ngol, mi jukkan ɗum'en. Caggal ɗum, ɓe njaltan, ɓe ndewa kam e oo ɗoo nokku.» ");
INSERT INTO ffm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Nden Laamɗo nanngondiri e Ibarahiima aadi. Taadagol laatii finnde aadi ndii. Hono non, Ibarahiima heɓi Isiyaaka, taadi ɗum nde heɓunoo balɗe jetti. Hono non Isiyaaka taadiri Yaakuuba, hono non Yaakuuba duu taadiri ɓiɓɓe muuɗum sappo e ɗiɗon, laatiiɓe njaatiraaɓe leɲi sappo e ɗiɗi ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Njaatiraaɓe ɓee kaasidii Yuusufu, cootti ɗum Misira. Kaa Laamɗo ana wondi e makko, ");
INSERT INTO ffm_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","hinnii mo e torraaji makko fuu, hokki mo moƴƴere e hakkilantaaku yeeso Fira'awna kaananke Misira oo. Oon waɗi mo o dawranoowo galle muuɗum e Misira fuu. ");
INSERT INTO ffm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nden yolbere waɗi ley Misira e Kanaana fuu. Ɓillaare mawni faa njaatiraaɓe meeɗen ndonki nguure. ");
INSERT INTO ffm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nde Yaakuuba nannoo ɲamri ana Misira ndee, neli ton njaatiraaɓe meeɗen. Ɓe ngarti, ɓe njehi kasen. ");
INSERT INTO ffm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nden Yuusufu anndintini sakiraaɓe muuɗum ɓee hoore mum. Suudu baaba Yuusufu duu ɓanngani Fira'awna. ");
INSERT INTO ffm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nden Yuusufu neli noddanee baam mum Yaakuuba e koreeji muuɗum fuu, ɓe capanɗe njeɗɗon e njoyon neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yaakuuba nootoyii Yuusufu Misira. O maayi ton, kanko e njaatiraaɓe meeɗen ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ɓe naɓtaa Sikem, ɓe iraa e yanaande nde Ibarahiima soodunoo e ɓiɓɓe Hamor to Sikem too kaalisi cardi. ");
INSERT INTO ffm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nde fodoore nde Laamɗo fodannoo Ibarahiima ɓadinoo yottaade ndee, Ibaraninkooɓe keewi ley Misira. ");
INSERT INTO ffm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Oon wakkati, kaananke goɗɗo mo anndaano Yuusufu laamii Misira. ");
INSERT INTO ffm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Oon kaananke hiili leɲol meeɗen, torri njaatiraaɓe meeɗen faa tilsini ɓe ɓe njoppa cukaloy maɓɓe yalla ana maaya. ");
INSERT INTO ffm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ley oon wakkati, Muusaa fini, laatii moy-ŋaro sanne. O muyninaa lebbi tati e galle baam makko. ");
INSERT INTO ffm_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nde o tippaa ndee, ɓii Fira'awna debbo hoocciti mo, jogorii mo ɓiyum. ");
INSERT INTO ffm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Hono non Muusaa janngiri annde Misirankooɓe fuu, o laatii barkaani haalaaji e golleeji. ");
INSERT INTO ffm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nde Muusaa heɓunoo duuɓi capanɗe nay ndee, anniyii faabaade sakiraaɓe muuɗum ɓiɓɓe Israa'iila. ");
INSERT INTO ffm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","O yii Misiranke ana tooɲa gooto maɓɓe, o yoɓtii ko neɗɗo makko oo tooɲaa koo, o fii Misiranke oo, o wari ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","O sikkuno sakiraaɓe makko ɓee paaman Laamɗo ana hisinira ɗum'en saabe makko, kaa ɓe paamaali. ");
INSERT INTO ffm_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Janngo muuɗum o forri e ɗiɗon maɓɓe ana kaɓa. O yiɗi rewrintinde ɓe, o wii: «Giɗiraaɓe am, onon, on sakiraaɓe! Ko waddondiri on?» ");
INSERT INTO ffm_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Non tooɲuɗo tanaa muuɗum oo dunƴi mo, wii: «Homo waɗu maa hooreejo naa caroowo amen? ");
INSERT INTO ffm_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ɗum nee a muuyɗo warde kam no mbarduno-ɗaa Misiranke oo keeɲen nii?» ");
INSERT INTO ffm_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Muusaa dogiri saabe konngol ngol, feri, yehi leydi Madiyan. O heɓi ton ɓiɓɓe worɓe ɗiɗon. ");
INSERT INTO ffm_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nde mo hiɓɓinnoo ton duuɓi capanɗe nay ndee, malaa'ika ɓanngani mo e ley metangal wuutuure huɓɓoore ley ladde jeereende bannge waamnde haayre wiyeteende Siinaayi. ");
INSERT INTO ffm_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nde Muusaa yii ɗum ndee, haaynaa e ko yii koo. Omo ɓattitoo faa mo ƴeewa, nii daande Joomiraaɗo wii: ");
INSERT INTO ffm_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","«Miin woni Laamɗo njaatiraaɓe maa, Ibarahiima e Isiyaaka e Yaakuuba.» Muusaa darii ana siɲɲa, huli ƴeewde. ");
INSERT INTO ffm_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Joomiraaɗo wii mo: «Ɓoorta paɗe maa, sabi nokku ɗo ndari-ɗaa ɗoo yo leydi seniindi. ");
INSERT INTO ffm_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mi yii torra kewtiiɗo yimɓe am ɓee to Misira, no ɗum foti naawde, mi nanii boytaali maɓɓe, mi jippiima faa mi tonngita ɓe. Joonin, war mi nele Misira.» ");
INSERT INTO ffm_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Muusaa mo ɓe calanii so ɓe mbii: «Homo waɗu maa hooreejo naa caroowo?» oo Laamɗo neli, so waɗi ɗum ardiiɗo e kisinoowo, saabe malaa'ika ɓanngannooɗo ɗum e ley wuutuure oo. ");
INSERT INTO ffm_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Kanko yaltini ɓe, o waɗi kaayɗe e taagumansaaji ley leydi Misira e ley maayo Maaliya e ley ladde jeereende duuɓi capanɗe nay. ");
INSERT INTO ffm_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Oo woni Muusaa biiɗo ɓiɓɓe Israa'iila: «Laamɗo nelan e mon annabaajo hono am, sakiike mon.» ");
INSERT INTO ffm_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kanko wondi e malaa'ika kaaldunooɗo e makko to waamnde haayre wiyeteende Siinaayi, kanko wondi e njaatiraaɓe meeɗen nde ɓe mooɓtinoo ley ladde jeereende ndee, kanko heɓi konngi guurnooji faa o hokka en. ");
INSERT INTO ffm_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kaa njaatiraaɓe meeɗen njaɓaali ɗowtanaade mo. Ɓe calanii mo, hakkillaaji maɓɓe mbirfii Misira, ");
INSERT INTO ffm_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ɓe mbii Haaruuna: «Waɗan en tooruuji ardotooɗi en, sabi en anndaa ko hewtii Muusaa jaltinnooɗo en leydi Misira oo.» ");
INSERT INTO ffm_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","E ley ɗeen ɲalaaɗe ɓe tafi tooru suuriindu suura gahel, ɓe ngaɗani ndu sadaka, ɓe ceyorii golle juuɗe maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Laamɗo ɗuurtii ɓe, yoppiri ɓe rewde koode kammu, hono no winndiraa e dewtere annabaaɓe nii: «Hey suudu baaba Israa'iila! Duuɓi capanɗe nay ɗi ngaɗu-ɗon ley ladde jeereende ɗii, on ngaɗanii kam sadakaaji kirsamaaji naa? ");
INSERT INTO ffm_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","On ngaɗaali. On ndoondiima hukkum tooru Moloko, kaɲum e hoodere tooru mooɗon Refan, nate ɗe moƴƴin-ɗon faa cujidanon ɗum'en! Ɗum waɗi so miɗo eggina on, faa naɓe-ɗon caggal Baabila.» ");
INSERT INTO ffm_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Eciyen jokkini hen: —Njaatiraaɓe meeɗen ɓee ana njoginoo hukkum seedaaku ley ladde jeereende. Oon hukkum moƴƴiniraama hono no Laamɗo tinndiniri Muusaa nii. ");
INSERT INTO ffm_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Njaatiraaɓe meeɗen ndoni hukkum oo. Ɓe eggidi e makko wakkati mo Yosuwa ardii ɓe, ɓe naanni mo leydi ndi ɓe teeti leɲi ɗi Laamɗo ribbi ɗii. Ɗum worri non faa jamaanu Daawuuda. ");
INSERT INTO ffm_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Daawuuda heɓii moƴƴere Laamɗo, o ɲaagii ɗum yalla omo yarranee mo mahana Laamɗo Yaakuuba hoɗorde. O heɓaali. ");
INSERT INTO ffm_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Suleymaana, kaɲum mahi ndu. ");
INSERT INTO ffm_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Kaa Laamɗo Toowɗo oo jooɗataako e cuuɗi ɗi yimɓe ngolli, hono no annabaajo wiiri nii: ");
INSERT INTO ffm_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","«Joomiraaɗo wii: Kammu yo jooɗorgal am, leydi yo njaaɓirdi koyɗe am. Suudu hondu mahanton kam? E nokku homo powtintoo-mi? ");
INSERT INTO ffm_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tama wanaa miin tagiri kulle ɗee fuu baawɗe am?» ");
INSERT INTO ffm_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Eciyen jokkini hen, wii: —Onon tiiɗuɓe ko'e, yoorɓe ɓerɗe, pahinkiniiɓe, abada oɗon calanii Ruuhu Ceniiɗo oo hono no njaatiraaɓe mooɗon ɓee nii. ");
INSERT INTO ffm_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Homo woni annabaajo mo njaatiraaɓe mooɗon torraali ɗum? Ɓe mbarii ardinooɓe haalde haala garol Pooccitiiɗo, mo onon e ko'e mon njammbi-ɗon, so mbar-ɗon ɗum jooni oo, ");
INSERT INTO ffm_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","onon heɓuɓe Sariya Muusaa mo malaa'ika'en njippini so njokkaali ɗum ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nde Saahiiɓe ɓee nannoo ɗii haalaaji ndee, ɓe tikki faa ɓe ndarii eɓe ŋattanoo mo eɓe picca peɗeeli. ");
INSERT INTO ffm_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kaa kanko kebbinaaɗo Ruuhu Ceniiɗo oo, o tiggitii kammu, o yii teddeengal Laamɗo, o yii Iisaa ana darii ɲaamo Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","O wii: —Ƴeewee! Miɗo yiya kammu ana udditii, Ɓii Neɗɗo ana darii ɲaamo Laamɗo! ");
INSERT INTO ffm_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ɓe fuu ɓe ngulli semmbe, ɓe cukki noppi maɓɓe, ɓe ndiirani mo, ");
INSERT INTO ffm_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ɓe njaltini mo ngalluure ndee, ɓe mbedii mo kaaƴe. Seedee'en ɓee ɓoortii saayaaji muuɗum'en, njoƴƴini bannge koyɗe jokolle biyeteeɗo Sool. ");
INSERT INTO ffm_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Eɓe mbedoo Eciyen kaaƴe forri omo ɲaagoo Laamɗo omo wiya: —Iisaa Joomiraaɗo, jaɓɓa yonki am! ");
INSERT INTO ffm_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ndennoo, o diccii, o wulli faa toowi, o wii: —Joomiraaɗo, pati rewta ɓe e ɗii luutti! Nde o haalnoo ɗum ndee, o maayi. ");
INSERT INTO ffm_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sool ana yarrii ko ɓe mbari Eciyen koo. Oon ɲalooma, torra mawɗo hewtii deental goonɗinɓe to Urusaliima too. Ɓe fuu ɓe caakii ley leyɗe Yahuudiya e Samariya, so wanaa nelaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Worɓe hulɓe Laamɗo iri Eciyen, mboyi ɗum bojji mawɗi sanne. ");
INSERT INTO ffm_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kaa Sool tewtii timminde deental goonɗinɓe ngal. Omo naata cuuɗi, o nannga worɓe e rewɓe, o daasa ɗum'en, o uddoya ɗum'en kasu. ");
INSERT INTO ffm_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kaa saakinooɓe ɓee naati e yiilaade ana mbaajoo Kabaaru Lobbo oo. ");
INSERT INTO ffm_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipa yehi e ngalluure wonnde ley leydi Samariya, waajii ɓe haala Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ɓe fuu ɓe kettinii ko Filipa waajotoo koo faa gasi, ɓe njii taagumansaaji ɗi o waɗi ɗii. ");
INSERT INTO ffm_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Sabi laddaaɓe heewɓe, seyɗaani'en muuɗum'en njaltiri gullaali mawɗi. Bonnguuɓe heewɓe e laƴooɓe cellii. ");
INSERT INTO ffm_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ɗum laatanii ngalluure ndee seyo manngo. ");
INSERT INTO ffm_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Gorko biyeteeɗo Simon ana wonnoo e ngalluure ndee. Omo gollannoo ndaggadaaku, omo haayɗinannoo Samariyankooɓe sanne, omo jogorinoo hoore makko won no o foti. ");
INSERT INTO ffm_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ɓe fuu eɓe njarranii mo, gila suka faa mawɗo, ɓe mbii: —Oo gorko woni mo Laamɗo luɓii baawɗe biyeteeɗe «Baawɗe mawɗe». ");
INSERT INTO ffm_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ɓe njokkii mo ko ɓooyi saabe omo haayɗinannoo ɓe e bidiga makko. ");
INSERT INTO ffm_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kaa nde Filipa waajinoo ɓe Kabaaru Lobbo haala Laamu Laamɗo e haala Iisaa Almasiihu ndee, ɓe ngoonɗini, worɓe e rewɓe fuu lootaa lootogal batisima. ");
INSERT INTO ffm_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon e hoore muuɗum goonɗini, kaɲum duu. Nde o batisaa ndee, o takkondiri e Filipa, o haaynaa nde o yiinoo taagumansaaji e kaayɗe mawɗe gaɗaaɗe ɗee. ");
INSERT INTO ffm_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Nelaaɓe wonɓe Urusaliima ɓee nani Samariyankooɓe ngoonɗinii konngol Laamɗo. Ɓe neli e muuɗum'en Piyeer e Yuhanna. ");
INSERT INTO ffm_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Nde ɓeen njottinoo ndee, nduwanii ɓe yalla eɓe keɓa Ruuhu Ceniiɗo, ");
INSERT INTO ffm_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","sabi Ruuhu Ceniiɗo jippaaki e fay gooto e maɓɓe tafon. Saabe Iisaa Joomiraaɗo oo tan ɓe mbatisiraa. ");
INSERT INTO ffm_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nden Piyeer e Yuhanna pawi juuɗe muuɗum'en dow maɓɓe so ɓe keɓi Ruuhu Ceniiɗo. ");
INSERT INTO ffm_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nde Simon yii Piyeer e Yuhanna ana pawi juuɗe muuɗum'en dow maɓɓe ana ndokka ɓe Ruuhu Ceniiɗo ndee, waddani ɓe kaalisi, ");
INSERT INTO ffm_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","wii: —Ndokkee kam miin duu ɗeen baawɗe yalla mo paw-mi juuɗe am e dow muuɗum fuu ana heɓa Ruuhu Ceniiɗo. ");
INSERT INTO ffm_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Nii Piyeer jaabii mo, wii: —Yo Laamɗo halke, aan e kaalisi maa, sabi a miilii dokke Laamɗo ana coottitiree kaalisi! ");
INSERT INTO ffm_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","A walaa geɗal, a walaa yolannde e ley haala kaa, sabi ɓernde maa fooccitanaaki Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tuubu, iw e bonannda maa oo, ɲaago-ɗaa Joomiraaɗo yaafe ko miilataa koo. ");
INSERT INTO ffm_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sabi mi yii ma a ɓaleejo yonki, bonannda maa jaalike ma. ");
INSERT INTO ffm_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon jaabii, wii: —Ɲaaganee kam Joomiraaɗo pati fay huunde e ko mbii-ɗon koo hewtoo kam. ");
INSERT INTO ffm_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Caggal ko ɓe ceettii so ɓe mbaajii konngol Joomiraaɗo ngol koo, Piyeer e Yuhanna mbirfitii Urusaliima. E laawol ngol, ɓe mbaajii Kabaaru Lobbo oo e geelle Samariya keewɗe. ");
INSERT INTO ffm_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Malaa'ika Joomiraaɗo wii Filipa: —Imma, yaaru ɓaleeri, laawol iwrungol Urusaliima so ana fa'i Gaaja, kanngol ngol jeewnugol. ");
INSERT INTO ffm_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","O immii, o yehi. Nden o tawi gorko Ecopiyanke, howruujo kaananke debbo Ecopii biyeteeɗo Kandaake, yehiino Urusaliima juuroyaade. Kanko haybata beembal jawdi kaananke debbo oo. ");
INSERT INTO ffm_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Nde o wirfitinoo ndee, omo jooɗii e wotoro makko, omo jannga ley dewtere annabi Esaaya. ");
INSERT INTO ffm_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ruuhu wii Filipa: —Ɓatta, sawnda wotoro oo. ");
INSERT INTO ffm_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filipa dogi hewtii mo, nani omo jannga dewtere annabi Esaaya, wii mo: —Aɗa faama ko njanngataa koo naa? ");
INSERT INTO ffm_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Gorko oo jaabii, wii: —Hono paamiran-mi so fay gooto firritanaali kam? O ndaardi Filipa ŋabba jooddoo e makko. ");
INSERT INTO ffm_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ɗee aayaaje o janngannoo e dewtere ndee: «O naɓiraa hono no mbaalu kirsoyteeɗo nii. E no njawdiri deƴƴirta yeeso kesoowo ɗum nii, hono non o deƴƴiri. ");
INSERT INTO ffm_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Leyɗinkinaare makko bonni sareede makko. Homo waawi jantaade janta iwdi makko? Sabi o mursinanaama yonki makko ga aduna gaa.» ");
INSERT INTO ffm_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Howruujo oo wii Filipa: —Miɗo ndaarde, haalanam homo annabaajo oo haalata haala muuɗum, hoore muuɗum naa goɗɗo? ");
INSERT INTO ffm_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Non Filipa jaabii, ƴeewi binndi ɗii, waajii mo Kabaaru Lobbo haala Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Eɓe njokki laawol maɓɓe ngol faa ɓe njii ndiyam. Howruujo oo wii: —Ndiyam annii! Ko haɗata kam looteede lootogal batisima?  ");
INSERT INTO ffm_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","O yamiri wotoro oo daroo. Ɓe ɗiɗon fuu ɓe njippii, ɓe ndegii e ndiyam ɗam. Filipa batisi mo. ");
INSERT INTO ffm_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nde ɓe ƴeentunoo ndiyam ɗam ndee, Ruuhu Joomiraaɗo diwtii Filipa. Howruujo oo yiitaali mo kasen, jokkiri laawol muuɗum seyo. ");
INSERT INTO ffm_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipa tawoyaa Ajootus. Gila ɗon faa Kaysariya, ngeenndi fuu ndi mo wari e muuɗum, o waajoto Kabaaru Lobbo oo. ");
INSERT INTO ffm_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sool ana heddii e gidoraade taalibaaɓe Joomiraaɗo ɓee waran ɓe. O yehi to Jottinoowo Sadaka Mawɗo. ");
INSERT INTO ffm_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","O ndaardi ɗum talki yamiroore naannooji mo cuuɗi baajorɗiYahuudiyankooɓe gonɗi Damas, yalla so o tawii ton yimɓe jokkuɓe laawol Iisaa, worɓe naa rewɓe, o nannga ɗum'en, o haɓɓa, o naɓa Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nde o yahunoo faa o ɓadii Damas ndee, wakkati gooto fooyre iwri dow kammu filii mo. ");
INSERT INTO ffm_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","O saami e leydi, o nani daande ana wiya mo: —Sool, Sool, ko saabii so aɗa torra kam? ");
INSERT INTO ffm_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","O lamndii: —Aan homo, giɗo Laamɗo? Jaabu wari e makko: —Miin Iisaa mo torru-ɗaa oo. ");
INSERT INTO ffm_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Imma naatu e ley ngalluure ndee. Ɓe kaalante ko kaan-ɗaa waɗude. ");
INSERT INTO ffm_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Worɓe wonduɓe e makko ɓee, nanii daande ndee kaa njiyaali fay gooto. Ɓe ndarii, ɓe mugaa. ");
INSERT INTO ffm_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sool immii e leydi, darii ana futtini gite muuɗum, kaa yiyataa fay huunde. Nden o ɗowaa, o naannaa Damas. ");
INSERT INTO ffm_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","O waɗi balɗe tati o bumɗo, o ɲaamaali o yaraali. ");
INSERT INTO ffm_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Taalibbo biyeteeɗo Ananiyas ana wonnoo Damas. Joomiraaɗo noddi ɗum ley koyɗol, wii ɗum: —Ananiyas! O jaabii, o wii: —Haa, Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Joomiraaɗo wii mo: —Imma yaaru Bolol Dartiingol, naataa galle Yahuuda, ndaartaa gorko biyeteeɗo Sool, jeyaaɗo Tarsus, sabi jooni omo wondi e waɗude duwaawu. ");
INSERT INTO ffm_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","O yii e ley koyɗol gorko biyeteeɗo Ananiyas ana naata, ana fawa juuɗe muuɗum e makko, yalla omo wumta. ");
INSERT INTO ffm_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananiyas jaabii, wii: —Joomiraaɗo, mi narrii yimɓe heewɓe haala oo gorko e torraaji keewɗi ɗi o waɗi seniiɓe maa wonɓe Urusaliima ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","O wardii ɗoo e yamiroore hooreeɓe yottinooɓe sadaka, faa o haɓɓa noddooɓe innde maa fuu. ");
INSERT INTO ffm_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Joomiraaɗo wii mo: —Yaa waɗoy no mbii-mi nii, sabi oo gorko cuɓii-mi faa anndina yimɓe innde am. O waajoo ɗum leɲi e kaanankooɓe, kaɲum e ɓiɓɓe Israa'iila. ");
INSERT INTO ffm_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Mi hollan mo no tilsiri mo torriree torraaji keewɗi saabe am. ");
INSERT INTO ffm_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nden, Ananiyas yehi, naatoyi suudu nduu, fawi juuɗe muuɗum e makko, wii: —Sakiike am Sool, Joomiraaɗo men Iisaa ɓanngannooɗo ma e laawol ngardanno-ɗaa ngol oo, nelii kam faa mbumtaa, keewaa Ruuhu Ceniiɗo. ");
INSERT INTO ffm_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Oon wakkati fuu, huunde wa'unde no koɓɓaaje nii hoɓɓitii e gite Sool, o wumti, o immii, o lootaa lootogal batisima. ");
INSERT INTO ffm_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","O ɲaami, o warti e noone makko. O heddodii e taalibaaɓe wonɓe Damas ɓee balɗe seeɗa. ");
INSERT INTO ffm_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Sool heɲii law fuɗɗi waajaade haala Iisaa ley cuuɗi baajorɗi. O wii kaɲum jaati woni Ɓii Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Hettintonooɓe mo ɓee fuu kaaynaa, mbii: —Wanaa kanko wonnoo torrannooɗo goonɗinɓe Iisaa wonɓe ley Urusaliima ɓee naa? Wanaa faa o haɓɓa goonɗinɓe o naɓa ɗum'en to hooreeɓe yottinooɓe sadaka waddi mo ɗoo naa? ");
INSERT INTO ffm_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ana ɓooya fuu Sool ana ɓeydoroo soobee e ley waaju mum oo, faa ɗum wemmbi Yahuudiyankooɓe wonɓe Damas ɓee fuu, o laɓɓinani ɓe Iisaa woni Almasiihu oo. ");
INSERT INTO ffm_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ɲalaaɗe njehi, ngarti, Yahuudiyankooɓe ndawridi faa mbara Sool. ");
INSERT INTO ffm_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sool humpitii dabare maɓɓe oo. Jemma e ɲalooma eɓe kayba dame ngalluure ndee pati o yalta, yalla eɓe keɓa no ɓe mbarda mo. ");
INSERT INTO ffm_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jemma gooto taalibaaɓe makko ɓami mo, ngatti mo e sagiire, kaɓɓi hen ɓoggol, njawtini mo tatawol piliingol ngalluure ndee ngol. ");
INSERT INTO ffm_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Nde Sool warnoo Urusaliima ndee, yiɗi takkaade e taalibaaɓe Iisaa ɓee, kaa ɓe fuu eɓe kula mo, ɓe koolaaki yalla o laatike taalibbo Iisaa jaati jaati. ");
INSERT INTO ffm_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Nden Barnabas naɓi mo to nelaaɓe ɓee too, haalani ɗum'en no o yiiri Joomiraaɗo oo ana haalda e makko e laawol ngol, e no o waajorii haala Iisaa to Damas too e cuusal. ");
INSERT INTO ffm_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Caggal ɗum, Sool wondi e maɓɓe, ana naata ana yalta ley galleeji maɓɓe Urusaliima, ana waajoroo haala Joomiraaɗo kaa cuusal. ");
INSERT INTO ffm_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Omo haalda e Yahuudiyankooɓe haalannooɓe yunaninkoore ɓee, omo yeddondira e maɓɓe, jaka ɓeen ana tewtannoo no mbarda mo. ");
INSERT INTO ffm_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Nde deental goonɗinɓe ngal annditinnoo ɗum ndee, naɓi Sool Kaysariya. Caggal ɗum, ɓe neli mo Tarsus. ");
INSERT INTO ffm_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Nii deental goonɗinɓe ngal heɓiri jam ley Yahuudiya e Galili, kaɲum e Samariya fuu. Ngal ɲiiɓi, ngal wattiniri kulol Joomiraaɗo, ngal ɓeydorii heewde saabe ballal Ruuhu Ceniiɗo. ");
INSERT INTO ffm_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Piyeer ana yiilotonoo e ley leydi ndii fuu, o jippanii seniiɓe wonɓe Lidda ɓee duu. ");
INSERT INTO ffm_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","O tawi ton gorko ɲawɗo mo terɗe muuɗum fuu mbaati, biyeteeɗo Ayneyas. Waɗii duuɓi jetti ana lelii. ");
INSERT INTO ffm_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piyeer wii mo: —Ayneyas, Iisaa Almasiihu sellinii ma! Imma, moƴƴintin lelnde maa! Oon wakkati fuu o immii. ");
INSERT INTO ffm_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Wonɓe Lidda e feeyo Saron fuu njii mo, tuubani Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Taalibbo debbo biyeteeɗo Tabita ana wonnoo Yoppe. Tabita woni Dorkas e yunaninkoore, maanaa mum yo lewla. Omo golla golleeji lobbi, omo waɗana misikiina'en moƴƴere. ");
INSERT INTO ffm_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","E ɗeen balɗe o ɲawi, o maayi, o lootaa, o lelnaa dow sooro tafon. ");
INSERT INTO ffm_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Nde wonnoo Yoppe woɗɗondiraa e Lidda, taalibaaɓe ɓee nani Piyeer ana ton, neli worɓe ɗiɗon ndaarda mo o yottoo ɗum'en law. ");
INSERT INTO ffm_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Piyeer immii, yaadi e maɓɓe. Nde yottinoo ndee, ɓe ŋabbini ɗum dow sooro too. Rewɓe talka'en ɓe worɓe mum'en maayi ɓee fuu ɓattii ɗum ndarii ana mboya, ana kolla ɗum forgooji e dollokaaji ɗi Dorkas ɲo'unoo nde wondunoo e muuɗum'en ndee. ");
INSERT INTO ffm_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piyeer yaltini yimɓe ɓee fuu, diccii, ana duwoo. Caggal ɗum, yeeccitii e maayɗo oo, wii: —Tabita, imma! Non Tabita feerti gite muuɗum, yii Piyeer, jooɗii. ");
INSERT INTO ffm_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piyeer nanngi junngo makko, immini mo. Caggal ɗum, o noddi seniiɓe ɓee e rewɓe talka'en ɓee, o holli ɗum'en Tabita yo guurɗo. ");
INSERT INTO ffm_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ɗum nanaa e ley Yoppe fuu, heewɓe ngoonɗini Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piyeer faɓɓi Yoppe balɗe kuurɗe e galle ɲobboowo guri biyeteeɗo Simon. ");
INSERT INTO ffm_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Gorko biyeteeɗo Korneliyus ana wonnoo Kaysariya. O hooreejo konu biyeteeɗo Italiyanke. ");
INSERT INTO ffm_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","O kuppidiɗɗo e diina, kanko e koreeji makko fuu ɓe hulɓe Laamɗo. Omo sakkoo Yahuudiyankooɓe sadakaaji keewɗi, omo ɲaagoo Laamɗo wakkati fuu. ");
INSERT INTO ffm_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kiikiiɗe gooto hono wakkati sallifanaa ɓuuɓuɗo, o heɓi holleede, o yii malaa'ika ana naata ley suudu makko ana wiya mo: —Korneliyus! ");
INSERT INTO ffm_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","O huli faa gite makko paapii, o wii ɗum: —Giɗo Laamɗo, kori jam? Malaa'ika oo wii mo: —Laamɗo jaabanike ma duwaawuuji maa e sadakaaji maa. ");
INSERT INTO ffm_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nel jooni worɓe to ngeenndi Yoppe, nodda biyeteeɗo Simon, noddirteeɗo Piyeer. ");
INSERT INTO ffm_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Omo jippii galle ɲobboowo guri biyeteeɗo Simon, mo galle muuɗum heedi e maayo geeci. ");
INSERT INTO ffm_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Nde malaa'ika kaaldannooɗo e makko oo wittunoo ndee, o noddi gollooɓe makko ɗiɗon e sordaasi gooto kulɗo Laamɗo jeyaaɗo e howruuɓe makko. ");
INSERT INTO ffm_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","O haalani ɓe ko malaa'ika oo wii koo fuu, o neli ɓe Yoppe. ");
INSERT INTO ffm_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Janngo muuɗum, eɓe e laawol. Nde worɓe taton ɓee ɓattii ngeenndi ndii ndee, tawi Piyeer ŋabbii dow bene muuɗum wakkati hakkunde naange faa waɗa duwaawu. ");
INSERT INTO ffm_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","O yolbi faa sanne, omo yiɗi ɲaamde. Nde ɓe moƴƴinanta mo ɲaamdu ndee, Laamɗo holli mo, ");
INSERT INTO ffm_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","o yii kammu udditike, huunde wa'unde no daɗɗamaare mawnde, nde coɓɓuli muuɗum nay fuu kaɓɓaa, ana rennee faade e leydi. ");
INSERT INTO ffm_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Sii daabaaji fuu, ɗi koyɗe nay e ŋaarooji, kaɲum e sii pooli fuu ana e mayre. ");
INSERT INTO ffm_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Daande wii mo: —Piyeer, imma, hirsu, ɲaam! ");
INSERT INTO ffm_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Piyeer wii: —Sawra Joomiraaɗo! Abada mi ɲaamaali ko harmi naa ko soɓi. ");
INSERT INTO ffm_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Daande ndee wii mo kasen: —Pati harmin ko Laamɗo senni. ");
INSERT INTO ffm_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ɗum waɗi non cili tati. Nden daɗɗamaare ndee ŋabbintinaa dow kammu. ");
INSERT INTO ffm_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ko Piyeer hollaa koo, omo miiloo no ɗum waawi laatoraade. Tawi e oon wakkati, worɓe ɓe Korneliyus nelnoo ɓee, lamndike galle Simon. Ɓe ngari, ɓe ndarii e damal ngal. ");
INSERT INTO ffm_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ɓe noddi, ɓe lamndii yalla Simon noddirteeɗo Piyeer ɗon jippii. ");
INSERT INTO ffm_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piyeer ana heddii miilde ko yii koo, faa Ruuhu wii ɗum: —Worɓe taton ana tewte. ");
INSERT INTO ffm_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Imma, jippa, njaadaa e maɓɓe tawa a sikkitaaki, sabi miin neli ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piyeer jippii, wii worɓe ɓee: —Miɗo nii, miin woni mo tewtaton oo. Kori jam waddi on? ");
INSERT INTO ffm_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ɓe njaabii, ɓe mbii: —Korneliyus hooreejo konu neli min. O gorko dartiiɗo, kulɗo Laamɗo, mo leɲol Yahuudiyankooɓe fuu seettanii moƴƴere. Malaa'ika ceniiɗo yamirii mo min nodde, ngaraa suudu makko, yalla omo nana waaju maa. ");
INSERT INTO ffm_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Piyeer noddi ɓe, silmini ɓe, jippini ɓe galle muuɗum. Janngo muuɗum, o immii, o yaadi e maɓɓe. Yoga e sakiraaɓe jeyaaɓe Yoppe njaadi e makko. ");
INSERT INTO ffm_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Faɓɓi-janngo muuɗum ɓe njottii Kaysariya. Korneliyus ana tijjinoo ɓe, noddi sakiraaɓe muuɗum e yiɓɓe muuɗum ɓadiiɓe. ");
INSERT INTO ffm_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Nde Piyeer naatannoo ndee, Korneliyus jaɓɓii ɗum, sujidani ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Piyeer itti mo e sujuudu nduu, wii: —Imma, sabi miin duu mi neɗɗo tan. ");
INSERT INTO ffm_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Piyeer ana haalda e makko, faa ɓe naati galle oo, tawi ton yimɓe heewɓe ana mooɓtii. ");
INSERT INTO ffm_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","O wii ɓe: —Oɗon anndi dagantaako Yahuudiyanke jokkondira e mo wanaa Yahuudiyanke, naa naatude suudu muuɗum. Kaa Laamɗo hollii kam pati mi nanngira fay gooto karmuɗo naa coɓuɗo. ");
INSERT INTO ffm_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ɗum waɗi nde nelan-ɗon kam ndee, mi warii, mi ujaaki. Ɗum nee, kaalanee kam, saabe koɗum noddir-ɗon kam? ");
INSERT INTO ffm_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneliyus jaabii, wii: —Hannde woni balɗe nay, miɗo waɗa duwaawu ley suudu am e oo ɗoo wakkati, faa gorko mo kaddule jalbooje wari, darii yeeso am, ");
INSERT INTO ffm_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","wii: «Korneliyus, Laamɗo jaabanike ma duwaawuuji maa e sadakaaji maa. ");
INSERT INTO ffm_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jooni, nel e ngeenndi mbiyeteendi Yoppe, noddane-ɗaa gorko biyeteeɗo Simon, noddirteeɗo Piyeer. Omo jippii galle ɲobboowo guri biyeteeɗo Simon, mo galle muuɗum heedi e maayo geeci.» ");
INSERT INTO ffm_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ɗum waɗi so nel-mi noddoye-ɗaa oon wakkati fuu. Ko ngar-ɗaa koo gasii sanne. Jooni min fuu miɗen nii yeeso Laamɗo faa min kettinoo ko Joomiraaɗo yamir maa mbaajo-ɗaa fuu. ");
INSERT INTO ffm_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Nden Piyeer fuɗɗi waajaade, wii: —Jooni mi yii goonga jaati Laamɗo ɓurdintaa yimɓe. ");
INSERT INTO ffm_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Neɗɗo kuloowo mo, gaɗoowo ko fooccitii, o yiɗan ɗum ko leɲol muuɗum tawaa fuu. ");
INSERT INTO ffm_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Oɗon anndi konngol ngol Laamɗo neldi ɓiɓɓe Israa'iila ngol, ngol ceyniroowol jam heɓiraama saabe Iisaa Almasiihu, kaɲum woni Joomiraaɗo yimɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Oɗon anndi ngol konngol kuuɓungol leydi Yahuudiya fuu, puɗɗirngol gila Galili, caggal Yaayaa waajike yo yimɓe loote batisima. ");
INSERT INTO ffm_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Oɗon anndi no Laamɗo suɓorii Iisaa Nasaraatunke oo, no jippiniri e muuɗum Ruuhu Ceniiɗo e baawɗe. Oɗon anndi no Iisaa yiilorii e nokkuuje fuu ana golla golleeji lobbi, ana sellina wonnooɓe e margal Ibiliisa fuu sabi Laamɗo ana wondi e muuɗum. ");
INSERT INTO ffm_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Minen min seedee'en ko o golli Yahuudiya e ko o golli Urusaliima fuu. Ɓe ɓili mo e leggal bardugal, ɓe mbari mo, ");
INSERT INTO ffm_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","kaa Laamɗo wuurtinii mo ɲannde tataɓere, ɓanngintini mo hakkunde amen. ");
INSERT INTO ffm_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Kaa wanaa yimɓe fuu o ɓanngani. O ɓannganii seedee'en ɓe Laamɗo adii suɓaade ɓee, minen ɲaamduɓe e makko so njardi e makko caggal wuurtugol makko ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","O yamirii min mbaajoo yimɓe, min ceettoo kanko woni mo Laamɗo waɗi caranoowo wuurɓe e maayɓe. ");
INSERT INTO ffm_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Annabaaɓe fuu ceettanike mo, mbii goonɗinɗo mo fuu heɓan yaafeede luutti muuɗum saabe makko. ");
INSERT INTO ffm_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Nde Piyeer waajotoo waaju oo ndee, Ruuhu Ceniiɗo jippii e hettintooɓe ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yahuudiyankooɓe goonɗinɓe wardunooɓe e Piyeer ɓee fuu kaaynaa, no dokkal Ruuhu Ceniiɗo ngal saakorii e yimɓe ɓe nganaa Yahuudiyankooɓe nii. ");
INSERT INTO ffm_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Sabi eɓe nanannoo ɓeen yimɓe ana kaala e ɗemɗe janane ana njetta Laamɗo. Nden, Piyeer jaabii, wii: ");
INSERT INTO ffm_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","—Yimɓe ɓee keɓii Ruuhu Ceniiɗo hono no meeɗen nii. Homo waawi haɗude ɓe looteede lootogal batisima? ");
INSERT INTO ffm_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","O yamiri ɓe mbatisiree e innde Iisaa Almasiihu. Caggal ɗum, ɓe ndaardi mo o faɓɓana ɓe balɗe. ");
INSERT INTO ffm_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nelaaɓe ɓee e sakiraaɓe wonnooɓe Yahuudiya ɓee nani yimɓe ɓe nganaa Yahuudiyankooɓe ɓee duu keɓii konngol Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Nde Piyeer ŋabbunoo Urusaliima ndee, goonɗinɓe tilsinɓe taadagol ɓee peli ɗum, ");
INSERT INTO ffm_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","mbii: —A jippike e yimɓe ɓe taadaaki, a ɲaamdii e muuɗum'en! ");
INSERT INTO ffm_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Nden Piyeer haalani ɓe ko waɗi koo gila e puɗɗooɗe faa e timmoode, wii: ");
INSERT INTO ffm_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Ngeenndi Yoppe ngonnoo-mi, miɗo duwoo faa njii-mi huunde ƴellitike e am. Huunde wa'unde no daɗɗamaare mawnde nde coɓɓuli muuɗum nay fuu kaɓɓaa, ana rennee iwde e kammu faade e am. ");
INSERT INTO ffm_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Taykitii-mi nde faa gasi, njii-mi daabaaji fuu, ɗi koyɗe nay e kulle ladde e ŋaarooji e sii pooli fuu. ");
INSERT INTO ffm_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nanu-mi daande ana wiya kam: «Piyeer, imma, hirsu, ɲaam!» ");
INSERT INTO ffm_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Mbii-mi: «Sawra Joomiraaɗo! Abada mi ɲaamaali ko harmi naa ko soɓi.» ");
INSERT INTO ffm_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Daande dow kammu ndee jaabitii kam kasen, wii: «Pati harmin ko Laamɗo senni.» ");
INSERT INTO ffm_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ɗum waɗi non cili tati. Caggal mum, kulle ɗee fuu ŋabbintinaa dow kammu. ");
INSERT INTO ffm_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","E oon wakkati, worɓe taton nelaaɓe e am iwde Kaysariya ngari e suudu ɗo min ngonnoo ɗoo. ");
INSERT INTO ffm_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ruuhu Ceniiɗo wii kam mi yaada e maɓɓe pati mi sikkitoo fay huunde. Ɓee ɗoo sakiraaɓe njeegom njaadi e am, min naaddi suudu Korneliyus. ");
INSERT INTO ffm_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","O haalani min no o yiiri malaa'ika darinooɗo suudu makko ana wiya mo: «Nel e ngeenndi mbiyeteendi Yoppe noddane-ɗaa Simon noddirteeɗo Piyeer. ");
INSERT INTO ffm_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","O waajete waaju kisinoowo ma, aan e koreeji maa fuu.» ");
INSERT INTO ffm_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nde puɗɗu-mi waajaade ndee, Ruuhu Ceniiɗo jippii e maɓɓe hono no jipporinoo e meeɗen arannde nii. ");
INSERT INTO ffm_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Nden, miccitii-mi ngol ɗoo konngol ngol Joomiraaɗo wiinoo: «Yaayaabatisirannoo ndiyam, kaa onon, on mbatisirte Ruuhu Ceniiɗo.» ");
INSERT INTO ffm_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","So Laamɗo fonndii en e maɓɓe, hokkii ɓe ko hokkunoo en koo nde ngoonɗinno-ɗen Joommen Iisaa Almasiihu ndee, ndennoo miin, ko ngon-mi so mi haɗa Laamɗo? ");
INSERT INTO ffm_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nde ɓe nannoo ɗum ndee, ɓe ndeƴƴinii, eɓe njetta Laamɗo, eɓe mbiya: —Laamɗo tuubinii yimɓe ɓe nganaa Yahuudiyankooɓe duu yalla ana keɓa nguurndam ngoongaraajam. ");
INSERT INTO ffm_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yoga e saakiiɓe saabe torraaji gaɗuɗi caggal maayde Eciyen ɓee, njehi faa Finikiya e Kiprus e Antiyokiya. Ɓe mbaajaaki konngol ngol so wanaa Yahuudiyankooɓe. ");
INSERT INTO ffm_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kaa yoga e goonɗinɓe iwooɓe Kiprus e Sireene naati Antiyokiya ana mbaajoo Kabaaru Lobbo haala Iisaa Joomiraaɗo oo hakkunde Yunaninkooɓe. ");
INSERT INTO ffm_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Baawɗe Joomiraaɗo ana e maɓɓe. Yimɓe heewɓe ngoonɗini, tuubi, ngarti e Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Deental goonɗinɓe wonɓe Urusaliima ɓee nani kabaaru gaɗuɗo Antiyokiya oo, neli ton Barnabas. ");
INSERT INTO ffm_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nde oon yottinoo so yii e maɓɓe moƴƴere Laamɗo ndee, seyii, waajii ɓe fuu ɓe tiinnoo ɓe tabita e Joomiraaɗo ɓernde laaɓunde. ");
INSERT INTO ffm_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas yo gorko moƴƴo, kebbinaaɗo Ruuhu Ceniiɗo e goonɗinal. Jamaa keewɗo goonɗini Joomiraaɗo saabe makko. ");
INSERT INTO ffm_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Caggal ɗum, Barnabas yehi Tarsus faa tewtoya Sool. ");
INSERT INTO ffm_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Nde o yiiti ɗum ndee, o naɓi ɗum Antiyokiya. Ɓe ngondii e deental goonɗinɓe wonɓe ton ɓee hitaande hiɓɓere, ɓe njannginii yimɓe heewɓe. Taalibaaɓe wonɓe Antiyokiya ɓee adii fuu wiyeede yimɓe Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","E ɗeen balɗe, yimɓe loowaaɓe konngol Laamɗo iwruɓe Urusaliima ngari Antiyokiya. ");
INSERT INTO ffm_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Gooto e maɓɓe biyeteeɗo Agabus, immii, darii, sapporii saabe Ruuhu yolbere mawnde waɗan ley laamu Roma fuu. Nde waɗi e laamu kaananke mawɗo biyeteeɗo Kalawdiyus. ");
INSERT INTO ffm_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Taalibaaɓe ɓee anniyii hawrintinde gooto fuu ko waawi, faa ɓe nelda sakiraaɓe maɓɓe wonɓe Yahuudiya ɓee paabitoroo. ");
INSERT INTO ffm_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ɓe ngaɗi ɗum, ɓe neldi ballal ngal Barnabas e Sool tummba e juuɗe mawɓe deental ton. ");
INSERT INTO ffm_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Oon wakkati, kaananke biyeteeɗo Hirudus fuɗɗi torrude yoga e deental goonɗinɓe ngal. ");
INSERT INTO ffm_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","O yamiri Yaakuuba sakiike Yuhanna oo wardee kaafaawi. ");
INSERT INTO ffm_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nde o yiinoo eɗum weli Yahuudiyankooɓe ndee, o nanngi Piyeer duu. Ɗum hawri e wakkati iidi mo buuru ƴuufinaaka. ");
INSERT INTO ffm_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nde o nanngunoo Piyeer ndee, o uddi ɗum, o yamiri pelle nay sordaasi'en loomtondira e haybugol mum, fedde fuu yimɓe nayon. O anniyike naɓude ɗum yeeso yimɓe fuu, so iidi Paska oo ƴaɓɓike. ");
INSERT INTO ffm_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ɗum waɗi so Piyeer haybaa e ley kasu oo, kaa deental goonɗinɓe ngal ŋoottaali ɲaaganaade mo Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nde Hirudus anniyinoo naɓude mo ndee, oon jemma omo ɗaaninoo hakkunde sordaasi'en ɗiɗon, omo haɓɓiraa calali ɗiɗi. Haybooɓe damal kasu oo ɓee duu ana kayba. ");
INSERT INTO ffm_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Nii malaa'ika Joomiraaɗo wari e makko, suudu nduu fuu fooyni, memi mo, finndini mo, wii: —Heɲa law, imma! Non calali ɗii kumtii, iwi e juuɗe makko, caami. ");
INSERT INTO ffm_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Malaa'ika oo wii mo: —Huma kumorgol maa, ɓoorna paɗe maa. Piyeer waɗiri non. Malaa'ika oo wii mo: —Waanda suddamaare maa, njokkaa e am. ");
INSERT INTO ffm_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piyeer yalti, jokki e makko. O anndaa ko malaa'ika oo waɗata, ana wa'ani mo hono no koyɗol nii, kaa ɗum goonga jaati. ");
INSERT INTO ffm_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ɓe ɓettii kayboowo arano oo, kaɲum e ɗiɗaɓo oo, ɓe njottii damal njamndi pewtungal e ngalluure ndee ngal. Ngal udditi hoore maggal yeeso maɓɓe, ɓe njalti, ɓe njokki e laawol ngol. Oon wakkati, malaa'ika oo seerti e makko. ");
INSERT INTO ffm_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Hakkille Piyeer warti, o wii: —Jooni mi taƴorii Joomiraaɗo neli malaa'ika muuɗum, faa hisina kam e junngo Hirudus e ko Yahuudiyankooɓe njoonndorinoo mi waɗete fuu. ");
INSERT INTO ffm_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nde hakkille makko jippitinoo ndee, o yehi galle Mariyama, inna Yuhanna noddirteeɗo Marka, ton yimɓe heewɓe mooɓtotonoo ana ngaɗa duwaawu. ");
INSERT INTO ffm_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Nde Piyeer tappunoo damal galle too ndee, golloowo debbo biyeteeɗo Rode wari e damal ngal faa humpitoo. ");
INSERT INTO ffm_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Nde o annditinnoo daande Piyeer ndee, o yeggiti udditinde damal ngal no o foti seyaade, o dogi o naatoyi, o humpiti ɓe Piyeer darii damal sella too. ");
INSERT INTO ffm_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ɓe mbii mo: —A kaahaango! Kaa omo heddii nanngude ɗum Piyeer. Ɓe mbii kasen: —Ɗum yo malaa'ika makko. ");
INSERT INTO ffm_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Kaa ɗum fuu Piyeer ana heddii tappude. Nde ɓe udditinnoo so ɓe njii mo ndee, ɓe kaaynaa sanne. ");
INSERT INTO ffm_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","O huncani ɓe junngo yalla eɓe ndeƴƴinoo, o jantanii ɓe no Joomiraaɗo yaltiniri mo kasu, o wii: —Kaalanee ɗum Yaakuuba, kaɲum e sakiraaɓe woɓɓe ɓee. Caggal muuɗum, o yalti, o yehi nokku goɗɗo. ");
INSERT INTO ffm_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Nde finnoo beetee ndee, sordaasi'en ɓee ana lamndondira hoto Piyeer woni, ɓe mbemmbaa faa hakkillaaji maɓɓe keli. ");
INSERT INTO ffm_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nde Hirudus ndaarnoo faa nannga mo, so heɓaali mo ndee, lamndii haybooɓe ɓee no laatii, yamiri ɓe mbaree. Caggal ɗum, Hirudus regii Yahuudiya, yehi Kaysariya jooɗoyii ton. ");
INSERT INTO ffm_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hirudus tikkani yimɓe Tirus e Sidon. Ɓeen kaaldi, kawri, ngari e makko. Ɓe adorii Bilastus howruujo makko oo, ɓe keɓi hakkille muuɗum, ɓe ɲaagii yalla dewral ana waɗa hakkunde maɓɓe, sabi leydi maɓɓe ndii e leydi Hirudus etata. ");
INSERT INTO ffm_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Sarti maɓɓe oo yottii, Hirudus ɓoornii kaddule kaananke, jooɗii dow bimmbeere laamu, haaldi e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Yimɓe ɓee ngulli, mbii: —Ɗum daande laamɗo, wanaa daande neɗɗo! ");
INSERT INTO ffm_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Oon wakkati fuu, malaa'ika Joomiraaɗo fii Hirudus, sabi o jaɓii teddinireede o Laamɗo, tawi o wanaa. O ƴumi gilɗi, o maayi. ");
INSERT INTO ffm_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Kaa konngol Laamɗo ngol ana yaara yeeso, ana ɓeydoo saakaade. ");
INSERT INTO ffm_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Nde Barnabas e Sool tilinoo e golle muuɗum'en Urusaliima ndee, ɓe mbirfodii e Yuhanna noddirteeɗo Marka. ");
INSERT INTO ffm_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Annabaaɓe e jannginooɓe ana e ley deental goonɗinɓe gonngal Antiyokiya ngal. Kamɓe ngoni Barnabas e Simeyon noddirteeɗo Ɓaleejo e Lukiyus mo Sireene e Manahen, bammbidanooɗo e Hirudus hooreejo leydi oo, kaɲum e Sool. ");
INSERT INTO ffm_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ɲannde wootere eɓe ndewa Joomiraaɗo tawi eɓe ngoni e koorka, faa Ruuhu Ceniiɗo wii ɓe: —Keertanee kam Barnabas e Sool saabe golle mo noddir-mi ɓe oo. ");
INSERT INTO ffm_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Caggal ɓe koorii, ɓe nduwike, ɓe pawi juuɗe maɓɓe e dow ɓeen, ɓe njoppiti ɗum'en ndawi. ");
INSERT INTO ffm_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Nii Ruuhu Ceniiɗo neliri ɓe, ɓe ndegii e Selewkiya, ɓe naati laana geeci ɓe peewi Kiprus. ");
INSERT INTO ffm_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Nde ɓe njottinoo Salamis ndee, ɓe mbaajii konngol Laamɗo ngol ley cuuɗi baajorɗi Yahuudiyankooɓe. Eɓe ngondi e Yuhanna (noddirteeɗo Marka) ana faaboo ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Nde ɓe taccunoo ruunde ndee so ɓe njottii Pafos ndee, ɓe tawi ton daggada Yahuudiyanke biyeteeɗo Bar-Iisaa, jaaroowo yo annabaajo, ");
INSERT INTO ffm_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","howruujo Segiyus Pool. Oon yo kaananke hakkilante, caahiiɗo. O noddi Barnabas e Sool sabi ana yiɗi nande konngol Laamɗo ngol. ");
INSERT INTO ffm_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kaa Elimas daggada oo yo calaniiɗo ɓe, omo tewta bonnitidde goonɗinal kaananke oo. (Maanaa Elimas woni daggada.) ");
INSERT INTO ffm_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","E ley ɗum, Sool biyeteeɗo kasen Pool kebbinaaɗo Ruuhu Ceniiɗo oo futtini mo gite, ");
INSERT INTO ffm_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","wii: —Ɓii Ibiliisa! Aan keewɗo jammba e njiiɓdu, gaɲo ko moƴƴi fuu! A seerataa e ooɲude laawi Joomiraaɗo pooccitiiɗi ɗii naa? ");
INSERT INTO ffm_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jooni jukkungo Joomiraaɗo saaman e maa, a wuman, a yiyataa naange faa sarti cartaaɗo oo yottoo. Oon wakkati fuu, gite makko ngaɗi mbummbaalu, ɗe niɓɓi, omo wummbiloo, omo tewta ɗowoowo. ");
INSERT INTO ffm_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Nde kaananke oo yiinoo ko waɗi koo ndee, goonɗini Iisaa, haaynaa e ko nani haala Joomiraaɗo kaa koo. ");
INSERT INTO ffm_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pool e yaaduɓe e muuɗum naati laana geeci ngalluure wiyeteende Pafos, peewi Perge ley leydi Pamfiliya. Ɗon Yuhanna Marka seerti e maɓɓe, wirfitii Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ɓe ƴaɓɓii Perge, ɓe ngari Antiyokiya ley leydi Pisidiya. Ɓe naati waajorduɲalaande fowteteende, ɓe njooɗii. ");
INSERT INTO ffm_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Caggal janngeede Sariya Muusaa e annabaaɓe, hooreeɓe waajordu nduu ɓee neli e maɓɓe, mbii: —Sakiraaɓe, so won ko mbaajoto-ɗon yimɓe ɓee, kaalee. ");
INSERT INTO ffm_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pool immii, hunci junngo muuɗum, wii: —Israa'iilankooɓe e hulɓe Laamɗo woɓɓe, kettinee: ");
INSERT INTO ffm_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Laamɗo Israa'iilankooɓe oo suɓiima njaatiraaɓe meeɗen, teddinii leɲol maɓɓe nde ngol hoɗoyi leydi Misira ndee, kasen yaltiniri ɓe ton baawɗe muuɗum. ");
INSERT INTO ffm_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","O muɲanii ɓe ko foti duuɓi capanɗe nay e ley ladde jeereende. ");
INSERT INTO ffm_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Caggal o halkii leɲi jeɗɗi e ley leydi Kanaana, o hokki ndi yimɓe makko ndona ndi. ");
INSERT INTO ffm_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Eɗum waara e duuɓi teemeɗe nay e capanɗe joy. Caggal ɗum, o hokki ɓe sarooɓe faa jamaanu annabi Samuyila. ");
INSERT INTO ffm_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Nde ɗum ɓettii ndee, ɓe ɲaagii Laamɗo hokka ɓe kaananke. Laamɗo hokki ɓe Sawul ɓii Kis iwɗo e leɲol Beɲamin. Oon laamii ɓe duuɓi capanɗe nay. ");
INSERT INTO ffm_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Nden Laamɗo ɓoorti Sawul, lammini Daawuuda, mo o haali haala muuɗum so o wii: «Mi heɓii Daawuuda ɓii Yessa gorko ɓuuɓinoowo ɓernde am, gaɗoowo sago am.» ");
INSERT INTO ffm_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","E iwdi makko Laamɗo yaltini Iisaa, kisinoowo Israa'iila no fodirnoo nii. ");
INSERT INTO ffm_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Fade Iisaa warde, Yaayaa waajinoke leɲol Israa'iila fuu yo tuubu, lootee lootogal batisima. ");
INSERT INTO ffm_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Kasen, nde Yaayaa timminta golle muuɗum ndee, wiino: «Mi wanaa mo miilaton ngon-mi oo. Kaa mo mi fotaa fay e humtude ɓoggi paɗe muuɗum ana wara caggal am.» ");
INSERT INTO ffm_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Sakiraaɓe, onon iwdi Ibarahiima e ɓeen hulɓe Laamɗo wonɓe hakkunde mon! Onon neldaa oo kabaaru kisinoowo. ");
INSERT INTO ffm_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Sabi wonɓe Urusaliima ɓee e hooreeɓe muuɗum'en fuu annditaali Iisaa. Kasen duu ɓe paamaali haalaaji annabaaɓe janngetenooɗi ɲalaande fowteteende fuu ɗii. Kaa ɓe njottinii ɗiin haalaaji nde ɓe carunoo mo ndee. ");
INSERT INTO ffm_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Fay so taweede ɓe keɓaali feloore fay wootere nde ɓe pelira mo yalla omo maaya, ɓe ndaardii Pilaatu o waree. ");
INSERT INTO ffm_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Nde ɓe ngolli ko Binndi ɗii mbiinoo e makko koo faa hiɓɓi ndee, ɓe njippini mo leggal bardugal ngal, ɓe ngaɗi mo e yanaande. ");
INSERT INTO ffm_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Kaa Laamɗo wuurtinii mo. ");
INSERT INTO ffm_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Balɗe kuurɗe o ɓanngani wondunooɓe e makko ɓee gila Galili faa Urusaliima. Ɓeen ngoni seettantooɓe mo yeeso yimɓe jooni. ");
INSERT INTO ffm_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Minen, miɗen ceynira on fodoore nde njaatiraaɓe meeɗen podanaa ndee, ");
INSERT INTO ffm_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Laamɗo hiɓɓinanii en ɗum, enen ɓiɓɓe maɓɓe, nde wuurtinnoo Iisaa ndee. No winndiraa kasen e jimol Jabuura ɗiɗaɓol: «Aan, a ɓiyam, hannde ndimu-maa-mi.» ");
INSERT INTO ffm_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kasen, haala immitagol makko e hakkunde maayɓe e waasugol makko ɲolde, nii Laamɗo wii: «Mi tabintinanan on podooje ceniiɗe ɗe mbontataa, ɗe podannoo-mi Daawuuda ɗee.» ");
INSERT INTO ffm_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Ɗum waɗi so o wii e nokku goɗɗo: «A accataa Ceniiɗo maa ɲola.» ");
INSERT INTO ffm_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Daawuuda waɗii sago Laamɗo e jamaanu muuɗum. Caggal ɗum, o maayi, o mooɓtidaa e njaatiraaɓe makko, o ɲoli. ");
INSERT INTO ffm_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kaa mo Laamɗo wuurtini oo ɲolaali. ");
INSERT INTO ffm_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Sakiraaɓe, anndee saabe makko mbaajore-ɗon yaafeede luutti. ");
INSERT INTO ffm_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Sariya Muusaa waawaa waɗude neɗɗo pooccitiiɗo, kaa kanko, goonɗinɗo mo fuu, o nanngiran ɗum pooccitiiɗo. ");
INSERT INTO ffm_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ɗum nee, kaybee pati ko annabaaɓe cappinoo koo hewto on: ");
INSERT INTO ffm_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","«Onon hoynuɓe, yo on kaayne yo on kalko! Sabi miɗo nii golla golle e ley wakkati mooɗon, golle mo on ngoonɗintaa so neɗɗo haalaniino on.» ");
INSERT INTO ffm_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Caggal Pool e Barnabas njaltii waajordu nduu, jamaa oo ndaardi ɓe yo ɓe ngartu fowteteende waroore, yalla eɓe njokka e waaju maɓɓe oo. ");
INSERT INTO ffm_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Caggal mooɓtagol ngol, Yahuudiyankooɓe heewɓe e naatuɓe e diina maɓɓe njokki e Pool e Barnabas. Ɓeen ɗiɗon duu ana kaalda e maɓɓe ana mbaajoo ɓe yo ɓe ɲiiɓu e moƴƴere Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Fowteteende jokkunde hen ndee, ngalluure ndee fuu mooɓtii yalla ana hettinoo konngol Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Kaa nde Yahuudiyankooɓe ɓee njiinoo oo jamaa ndee, haasidaaku naati e muuɗum'en, eɓe njedda ko Pool waajotoo koo, eɓe njenna ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Nden Pool e Barnabas kaalaniri ɓe cuusal, mbii: —Waajibi min adoo haalande on konngol Laamɗo ngol, kaa ko tippiti-ɗon ngol so car-ɗon ko'e mooɗon on kaandaa e nguurndam nduumiiɗam koo, min njahan to yimɓe ɓe nganaa Yahuudiyankooɓe. ");
INSERT INTO ffm_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Sabi ko Joomiraaɗo yamiri en koo annii: «Mi darnii ma yalla aɗa laatanoo leɲi ɗii fooyre, faa kisinaa aduna oo fuu.» ");
INSERT INTO ffm_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Nde yimɓe leɲi goɗɗi ɗii nannoo ɗii haalaaji ndee, ceyii, teddini konngol Joomiraaɗo ngol. Ɓe Laamɗo suɓanii nguurndam nduumiiɗam ɓee fuu ngoonɗini. ");
INSERT INTO ffm_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Konngol Joomiraaɗo ngol saakii e leydi ndii fuu. ");
INSERT INTO ffm_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kaa Yahuudiyankooɓe ɓee loofi rewɓe rewooɓe Laamɗo saahiiɓe, kaɲum e mawɓe ngalluure ndee ɓee. Ɓe ndooɓi torra dow Pool e Barnabas, ɓe njaltini ɗum'en leydi maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ɓeen duu piɗɗi e maɓɓe colla koyɗe muuɗum'en, peewti Ikoniya. ");
INSERT INTO ffm_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Taalibaaɓe ɓee kebbinaa seyo e Ruuhu Ceniiɗo. ");
INSERT INTO ffm_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ley Ikoniya duu Pool e Barnabas naati e ley waajorduYahuudiyankooɓe. Eɓe mbaajoo faa Yahuudiyankooɓe e yimɓe leɲi goɗɗi heewɓe ngoonɗini. ");
INSERT INTO ffm_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kaa Yahuudiyankooɓe saliiɓe goonɗinde ɓee loofi leɲi goɗɗi ɗii, mbonni ɓerɗe muuɗum'en yalla ana mbaɲa sakiraaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ɗum e taweede haɗaali ɓe ɓooyde ton, eɓe pawi jikke maɓɓe e Joomiraaɗo, eɓe mbaajoroo cuusal. Joomiraaɗo seettii konngol hinnee muuɗum, nde hokkunoo ɓe baawɗe waɗude taagumansaaji e kaayɗe dogooje e juuɗe maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Yimɓe ngeenndi ndii ɓee peccii: yoga heedani Yahuudiyankooɓe ɓee, yoga heedani nelaaɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Yimɓe leɲi goɗɗi e Yahuudiyankooɓe e ardiiɓe muuɗum'en anniyii torrude ɓe e wardude ɓe kaaƴe. ");
INSERT INTO ffm_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Nde ɓe maatunoo ɗum ndee, ɓe ndogani Listara e Derbe e geelle seraaji muuɗum'en ley leydi Likoniya, ");
INSERT INTO ffm_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","eɓe mbaajoo ton Kabaaru Lobbo oo. ");
INSERT INTO ffm_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Gorko bonnguujo, dimdaaɗo e bonnguwaaku, mo meeɗaali daraade e koyɗe muuɗum, ana wonnoo Listara. ");
INSERT INTO ffm_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Omo hettinoo waaju Pool. Pool ƴeewi mo, yii goonɗinal makko sellinta mo, ");
INSERT INTO ffm_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","haaldi semmbe, wii: —Imma, dara e koyɗe maa! Gorko oo gurbitii, darii, ana yaha. ");
INSERT INTO ffm_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Nde yimɓe ɓee njii ko Pool waɗi koo ndee, ngulliri gullaali likoniyankoore, mbii: —Laamɗo'en nanndinkinike e yimɓe, njippiima e meeɗen! ");
INSERT INTO ffm_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ɓe inndiri Barnabas «Jewus», ɓe inndiri Pool «Hermes», sabi Pool wonnoo kaaloowo. ");
INSERT INTO ffm_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Galle ɗo Jewus rewetee ana wonnoo to naatirde ngeenndi too. Jottinoowo sadaka oo waddi ga'i pariraaɗi piindi e dame ɗee. Omo yiɗi waɗude sadaka, kanko e yimɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kaa nde Barnabas e Pool nannoo ɗum ndee, ceeki kaddule muuɗum'en, keɲanii jamaa oo ana ngulla, ");
INSERT INTO ffm_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","ana mbiya: —Worɓe, koɗum ngaɗaton ɗoo? Minen duu min yimɓe hono mooɗon. Miɗen mbaajoo Kabaaru Lobbo oo faa tuubon, iwon e ɗii golleeji laaliiɗi, ngarton e Laamɗo guurɗo, taguɗo kammu e leydi e geeci e ko woni e muuɗum'en fuu. ");
INSERT INTO ffm_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","E jamaanuuji jawtuɗi ɗii o yoppii leɲi ɗii fuu njokka laawi muuɗum'en. ");
INSERT INTO ffm_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ɗum e taweede, omo golla ko moƴƴi faa ɗum seettanoo mo, omo hokka on toɓo kammu, omo ɓenndinana on ɲamri e wakkati muuɗum, omo waaltinira hakkillaaji mon nguure e seyo. ");
INSERT INTO ffm_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ko ɓe mbaajii koo fuu, semmbe ɓe kaɗiri jamaa oo hokkude ɓe sadaka. ");
INSERT INTO ffm_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Caggal ɗum, Yahuudiyankooɓe iwi Antiyokiya e Ikoniya. Ɓe keɓi hakkillaaji yimɓe ɓee, ɓeen mbedii Pool kaaƴe, ndaasi ɗum faa naɓi ɗum caggal ngeenndi ndii, sabi miilii mo maayɗo. ");
INSERT INTO ffm_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kaa nde taalibaaɓe ɓee ngari pilii mo ndee, o immii, o naatti e ley ngeenndi ndii. Janngo muuɗum, o yaadi e Barnabas ngeenndi mbiyeteendi Derbe. ");
INSERT INTO ffm_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ɓe mbaajii ton Kabaaru Lobbo oo, ɓe keɓi taalibaaɓe faa keewi. Caggal muuɗum, ɓe mbirfitii Listara e Ikoniya, kaɲum e Antiyokiya. ");
INSERT INTO ffm_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Eɓe cuusina yonkiiji taalibaaɓe, eɓe mbaajoo ɗum'en yo ɲiiɓu e goonɗinal, eɓe mbiya: —Kinaa tampen tampereeji keewɗi so naaten e Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","E ley deente goonɗinɓe ɗee fuu, ɓe cuɓanii ɗum'en hooreeɓe. Caggal ɗum, ɓe koori, ɓe nduwii, ɓe kalfini ɗum'en Joomiraaɗo mo ɓe ngoonɗini oo. ");
INSERT INTO ffm_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nde ɓe ceekunoo Pisidiya ndee, ɓe ngari Pamfiliya. ");
INSERT INTO ffm_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ɓe mbaajii konngol ngol ley ngeenndi Perge. Caggal muuɗum, ɓe njippoyii Attaliya. ");
INSERT INTO ffm_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ton ɓe naati laana geeci, ɓe mbirfii Antiyokiya ɗo ɓe kalfinanoo moƴƴere Laamɗo faa ɓe ngolla golle mo ɓe tilii jooni oo. ");
INSERT INTO ffm_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Nde ɓe njottinoo ndee, ɓe mooɓti deental goonɗinɓe ngal, ɓe kaalani ngal ko Laamɗo waɗidi e maɓɓe fuu, no o udditirani yimɓe ɓe nganaa Yahuudiyankooɓe damal goonɗinal. ");
INSERT INTO ffm_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ɓe ngondi ɗon e taalibaaɓe ɓee faa ɓooyi. ");
INSERT INTO ffm_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Yimɓe yogaaɓe iwi Yahuudiya ngari Antiyokiya, ana njanngina sakiraaɓe ɓee, ana mbiya: —So on taadiraaka no Muusaa wiiri nii, on kisataa. ");
INSERT INTO ffm_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pool e Barnabas pooɗondiri e maɓɓe, nduddi e maɓɓe faa naawi. Ɗum waɗi so ɓe tabintini nelde Pool e Barnabas e yimɓe woɓɓe faa Urusaliima, faade e nelaaɓe ɓee e hooreeɓe ɓee, saabe haala kaa. ");
INSERT INTO ffm_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ɗum saabii so deental goonɗinɓe ngal neli ɓe. Ɓe ceeki Finikiya e Samariya, eɓe kaalana ɗum'en haala tuubugol yimɓe ɓe nganaa Yahuudiyankooɓe. Ɗum laatanii sakiraaɓe ɓee fuu seyo manngo. ");
INSERT INTO ffm_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Nde ɓe njottinoo Urusaliima ndee, deental goonɗinɓe ngal e nelaaɓe ɓee e hooreeɓe ɓee njaɓɓii ɓe. Ɓe kaalani ɗum'en ko Laamɗo waɗani ɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kaa yoga e goonɗinɓe jeyaaɓe e fedde Farisa'en immii, mbii: —Waajibi ɓe taadee, ɓe njamiree jokkude Sariya Muusaa oo. ");
INSERT INTO ffm_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Nelaaɓe ɓee e mawɓe ɓee kawriti faa ƴeewa haala kaa. ");
INSERT INTO ffm_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Caggal haali-haalti keewɗo, Piyeer immii, wii ɓe: —Sakiraaɓe, oɗon anndi Laamɗo suɓike kam e ley mooɗon gila ko ɓooyi, faa mi waajoo Kabaaru Lobbo oo hakkunde yimɓe ɓe nganaa Yahuudiyankooɓe, yalla eɓe nana ɓe ngoonɗina. ");
INSERT INTO ffm_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Laamɗo annduɗo ɓerɗe oo hollii jaɓanii ɓe, nde hokki ɓe Ruuhu Ceniiɗo oo hono no meeɗen nii. ");
INSERT INTO ffm_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Walaa fuu ko o seenndiri en e maɓɓe, nde wonnoo o laɓɓinirii ɓerɗe maɓɓe goonɗinal. ");
INSERT INTO ffm_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jooni, ko saabii so oɗon itta koro Laamɗo? Oɗon pawa e taalibaaɓe ɓee donngal, ngal enen e maamiraaɓe meeɗen en mbaawaa roondaade. ");
INSERT INTO ffm_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","E moƴƴere Joomiraaɗo men Iisaa ngoonɗinir-ɗen so kisu-ɗen, hono non kamɓe duu. ");
INSERT INTO ffm_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Deental ngal fuu deƴƴinii teen, ana hettinoo Barnabas e Pool ana njantoo no Laamɗo waɗiri taagumansaaji e kaayɗe hakkunde leɲi goɗɗi. ");
INSERT INTO ffm_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Caggal ɓe ndeƴƴinike, Yaakuuba jaɓɓitii, wii: —Sakiraaɓe, kettinanee kam! ");
INSERT INTO ffm_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon humpitii en no Laamɗo suɓorii gila e puɗɗooɗe yimɓe ɓe nganaa Yahuudiyankooɓe, faa waɗa ɗum'en yimɓe muuɗum. ");
INSERT INTO ffm_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɗum hawri e haalaaji annabaaɓe ɗii, hono no winndiraa nii: ");
INSERT INTO ffm_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","«Joomiraaɗo wii: Caggal ɗum, mi wartan, mi mahitoo suudu Daawuuda saamundu nduu, mi reentinan taƴe tuufeeje ɗee, mi darna ndu kasen, ");
INSERT INTO ffm_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","yalla yimɓe heddiiɓe ɓee ana tewta Joomiraaɗo. Ɗum woni, leɲi ɗi innde am noddaa e muuɗum'en ɗii. Joomiraaɗo tabintinɗo ɗeen kulle ");
INSERT INTO ffm_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","anndaaɗe gila huunde fuu tagaaka, wii non.» ");
INSERT INTO ffm_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ɗum saabii miin kaa ko njii-mi, pati tiiɗinanen yimɓe leɲi goɗɗi tuubuɓe so ngarti e Laamɗo ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Kaa ko haani hen, nelen e maɓɓe ɓe nantoo e ko tooruuji coɓini e jeenu e ɲaamde jiibe e ɲaamde ƴiiƴam. ");
INSERT INTO ffm_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Gila e jamaanuuji ɓooyɗi, Sariya Muusaa ana jannginee ley geelle ɗee fuu, eɓe njannga mo ɲalaande fowteteende fuu ley cuuɗi baajorɗi. ");
INSERT INTO ffm_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ɗum waɗi so nelaaɓe ɓee kaɲum e hooreeɓe ɓee e deental goonɗinɓe ngal fuu ndawridi faa cuɓoo worɓe e ley muuɗum'en faa nela ɗum'en Antiyokiya, ɓe tawta Pool e Barnabas. Ɓe cuɓii hooreeɓe ɗiɗon ley sakiraaɓe ɓee, Yahuuda noddirteeɗo Barasaba, kaɲum e Silas. ");
INSERT INTO ffm_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ɓe ndokki ɗum'en oo ɗoo ɓataaki: Minen sakiraaɓe mooɗon, nelaaɓe kaɲum e hooreeɓe, miɗen njowta on, onon sakiraaɓe amen leɲi goɗɗi wonɓe Antiyokiya e Siriya e Silisi. ");
INSERT INTO ffm_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Min nanii yimɓe iwii ga amen girƴinirii on haalaaji, njiiɓii hakkillaaji mon. Minen nee, min njamiraali ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Min ndawridii, min kawrii, min cuɓike worɓe faa min nela ɗum'en e mooɗon, ɓe tawta yiɓɓe amen Barnabas e Pool, ");
INSERT INTO ffm_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","yeebiiɓe yonkiiji muuɗum'en saabe Joommen Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ɗum waɗi so min neli Yahuuda e Silas, pammina on ko min mbinndi e mon koo hunduko e hunduko. ");
INSERT INTO ffm_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Minen e Ruuhu Ceniiɗo, min kawrii pati min njappa on ko teddi so wanaa ko tilsi koo: ");
INSERT INTO ffm_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","nanto-ɗon e kirsanaaɗi tooruuji e ƴiiƴam e jiibuɗi e jeenu. So on ndeenii ko'e mon e majji, on ngaɗii ko moƴƴi. Yo Laamɗo faabo en! ");
INSERT INTO ffm_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ɓe ndokkaa laawol, ɓe njehi Antiyokiya. Nde ɓe njottinoo ndee, ɓe mooɓti deental goonɗinɓe ngal, ɓe ndokki ngal ɓataaki oo. ");
INSERT INTO ffm_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Nde ɓeen janngunoo mo ndee, ceyii sabi haalaaji ɗii ndokkii ɗum'en semmbe. ");
INSERT INTO ffm_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yahuuda e Silas, Laamɗo loowi e mum'en konngol mum faa ɓe mbaajii sakiraaɓe waajuuji keewɗi, cuusini ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Caggal ɓe paɓɓii ton, ɓe ceerti e sakiraaɓe ɓee e dow jam, ɓe mbirfitii to nelnooɓe ɓee too.  ");
INSERT INTO ffm_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pool e Barnabas njooɗii ley Antiyokiya ana njanngina ana mbaajoo konngol Joomiraaɗo. Woɓɓe heewɓe ana mballa ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Caggal balɗe seeɗa, Pool wii Barnabas: —Mbirfo-ɗen e geelle ɗe mbaajino-ɗen konngol Joomiraaɗo ngol ɗee fuu, njippano-ɗen sakiraaɓe meeɗen ɓee, ƴeewen no ɓe ngorri. ");
INSERT INTO ffm_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas ana yiɗunoo ɓe njaada e Yuhanna noddirteeɗo Marka. ");
INSERT INTO ffm_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kaa ɗum welaali Pool sabi oon seeriino e maɓɓe Pamfiliya yaadaali e maɓɓe faa gollida e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Barnabas e Pool mettondiri faa ceerti. Homo e maɓɓe fuu suɓii neɗɗo goɗɗo. Barnabas yaadi e Marka, naati laana geeci feewi Kiprus. ");
INSERT INTO ffm_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pool suɓii Silas, yaadi e muuɗum caggal sakiraaɓe ɓee kalfinii ɗum e hinnee Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","O seeki Siriya e Silisi, omo yaha omo hokka deente goonɗinɓe ɗee semmbe. ");
INSERT INTO ffm_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pool wari Derbe, caggal ɗum, o yottii Listara. Goonɗinɗo biyeteeɗo Timote ana wonnoo ɗon. Inniiko yo Yahuudiyanke goonɗinɗo, kaa baam makko yo Yunaninke. ");
INSERT INTO ffm_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Sakiraaɓe wonɓe Listara e Ikoniya ɓee ana njetta mo. ");
INSERT INTO ffm_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pool yiɗi naɓorde mo, taadi mo, nde wonnoo Yahuudiyankooɓe hoɗuɓe e ɗeen leyɗe ɓee fuu ana anndi baam makko yo Yunaninke. ");
INSERT INTO ffm_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ley geelle ɗe ɓe ceeki ɗee, eɓe njottina goonɗinɓe ɓee sariya mo nelaaɓe e mawɓe wonɓe Urusaliima ɓee ɓami oo, eɓe njamira ɓeen yo njokku mo. ");
INSERT INTO ffm_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Hono non, deente goonɗinɓe ɗee ana ɓeydoroo semmbe banngal goonɗinal, ana ɓeydoo heewde ɲannde fuu. ");
INSERT INTO ffm_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ruuhu Ceniiɗo haɗi ɓe waajaade konngol ngol ley Asiya, saabe majjum ɓe ceeki leydi Firigiya e leydi Galaatiya. ");
INSERT INTO ffm_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Nde ɓe ngarnoo keerol Misiya ndee, ɓe tewti yaade Bitiniya, kaa Ruuhu Iisaa yarranaaki ɓe ɓe naata. ");
INSERT INTO ffm_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","E ley ɗum, ɓe ƴaɓɓii Misiya, ɓe ndegii e ngeenndi mbiyeteendi Torowas. ");
INSERT INTO ffm_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","E ley jemmaaku muuɗum won ko ƴellitii e Pool. O yii gorko Makedoniyanke ana darii, ana ndaarda mo ana wiya: —Lummbu, ngaraa Makedoniya paabo-ɗaa min! ");
INSERT INTO ffm_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Nde Pool yiinoo won ko ƴellitii e mum ndee, oon wakkati fuu min ndaari yaade Makedoniya, min taƴori Laamɗo noddi min faa min mbaajoo ɓe Kabaaru Lobbo oo. ");
INSERT INTO ffm_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Hono non, min naati laana geeci iwde Torowas, min paati ruunde Samotaras. Janngo muuɗum, min pahi Neyapolis. ");
INSERT INTO ffm_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Min iwi ɗon, min pahi Filipa, ngeenndi ɓurndi fuu teentilaade e leydi Makedoniya ndi Romankooɓe kumanii. Min ngaɗi ɗon balɗe. ");
INSERT INTO ffm_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ɲalaande fowteteende, min njaltiri ngeenndi ndii hedde daande maayo, ton Yahuudiyankooɓe mboownoo waɗude duwaawu. Min tawi ɗon rewɓe ana mooɓtii, min njooɗii, min mbaajii ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Debbo dewoowo Laamɗo, biyeteeɗo Lidiya, coottoowo kaddule boɗeeje, jeyaaɗo ngalluure wiyeteende Tiyatira, ana hettinoo. Joomiraaɗo udditi ɓernde makko yalla omo goonɗina ko Pool waajotoo koo. ");
INSERT INTO ffm_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kanko e koreeji makko fuu ɓe lootaa lootogal batisima. Caggal ɗum, o ɲaagii min, o wii: —So oɗon njogorii kam mi goonɗinɗo Joomiraaɗo, njippee suudu am. O tilsini min njippanoo mo. ");
INSERT INTO ffm_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ɲannde wootere miɗen njahannoo to nokkuure waɗirde duwaawu. Korɗo debbo bataaɗo annduɗo ko warata hawriti e amen. Halfaaɓe makko paggike kaalisi keewɗo e ndaggadaaku makko oo. ");
INSERT INTO ffm_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mo jokki e amen, minen e Pool, omo wulla, omo wiya: —Ɓee yimɓe yo gollanooɓe Laamɗo Toowɗo oo! Eɓe mbaajoo on laawol kisindam. ");
INSERT INTO ffm_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Balɗe kuurɗe omo waɗa non faa Pool mettaa, yeeccitii, wii ladde ndee: —Saabe Iisaa Almasiihu, yaltu e makko! Ladde ndee yalti oon wakkati fuu. ");
INSERT INTO ffm_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nde halfaaɓe ɓee anndunoo jikke muuɗum'en iwii e faggitoraade korɗo oo ndee, nanngi Pool e Silas, ndaasi ɗum'en faa sakoro to sarooɓe. ");
INSERT INTO ffm_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Non ɓe naɓi ɓeen to hooreeɓe ngeenndi ndii, mbii: —Ɓee worɓe ɗiɗon ɓe Yahuudiyankooɓe, eɓe nii ngadda baasi e ngeenndi meeɗen ndii. ");
INSERT INTO ffm_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Eɓe mbaajoo aadaaji ɗi ndagantaako en njaɓen naa ngollen, enen Romankooɓe. ");
INSERT INTO ffm_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Jamaa oo diirani ɓe. Hooreeɓe ɓee njamiri kaddule maɓɓe ceekee, ɓe piyee. ");
INSERT INTO ffm_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ɓe piyaa faa naawi, ɓe uddaa ley kasu. Hooreeɓe ɓee njamiri kayboowo kasu oo hayba ɓe faa gasa. ");
INSERT INTO ffm_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Oon nee, gila heɓi ndee yamiroore, naanni ɓe e ley suudu kasu hakkundeeru, o geƴƴii koyɗe maɓɓe geƴƴelle leɗɗe. ");
INSERT INTO ffm_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Nde hejjere jemma warnoo ndee, Pool e Silas ana ndewa Laamɗo, eɓe njaaroo ɗum. Kasunkooɓe woɓɓe ɓee ana kettinanoo ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Oon wakkati fuu, leydi dimmbii dimmbagol manngol faa pooɓe kasu ɗee njergi. Dame ɗee fuu udditii, geƴƴelle kasunkooɓe ɗee fuu kumtii. ");
INSERT INTO ffm_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nde kayboowo oo finnoo so yii dame kasu ɗee ana udditii ndee, soorti kaafaawi muuɗum faa wartoo, miili kasunkooɓe ɓee ndogii. ");
INSERT INTO ffm_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pool wulli faa toowi, wii mo: —Pati waɗu hoore maa fay huunde ko boni, min fuu miɗen ɗoo! ");
INSERT INTO ffm_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nde o heɓunoo fooyre ndee, o dogani kasu to Pool e Silas ngoni too, o sujidi, hedde omo siɲɲa. ");
INSERT INTO ffm_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Caggal ɗum, o yaltini ɓe, o wii ɓe: —Baabiraaɓe, hono fuu kaan-mi waɗude yalla miɗo hisa? ");
INSERT INTO ffm_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ɓe njaabii mo, ɓe mbii: —Goonɗin Iisaa Joomiraaɗo oo faa kisaa, aan e koreeji maa. ");
INSERT INTO ffm_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ɓe mbaajii mo konngol Joomiraaɗo ngol, kanko e koreeji makko fuu. ");
INSERT INTO ffm_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Oon jemma fuu o naɓi ɓe, o lootoyi barme maɓɓe. Oon wakkati fuu o lootaa lootogal batisima, kanko e koreeji makko fuu. ");
INSERT INTO ffm_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","O naanni Pool e Silas suudu makko, o hokki ɗum'en ɲaamdu. Kanko e koreeji makko fuu ɓe ceyii sabi ɓe keɓii goonɗinde Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nde weetunoo ndee, hooreeɓe Romankooɓe ɓee neli laamunkooɓe mbiya kayboowo oo yoppa worɓe ɗiɗon ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kayboowo oo haalanoyi ɗum Pool, wii: —Hooreeɓe ɓee nelii njoppite-ɗon. Njalton jooni, yo on njottoyo e jam. ");
INSERT INTO ffm_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pool jaabii, wii: —Ɓe njamirii min piyee yeeso yimɓe tawee min caraaka, ɓe naanni min e kasu. Minen worɓe ɗiɗon ɓee, min fuu min Romankooɓe. Jooni ɓe yaltinirooɓe min cuucuukka naa? Patti, ɗum waawaa laataade. Kinaa kamɓe e ko'e maɓɓe, ɓe ngara ɓe njaltina min! ");
INSERT INTO ffm_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Laamunkooɓe ɓee kaaltani hooreeɓe Romankooɓe ɓee haala kaa. Ɓeen kuli nde nannoo Pool e Silas yo Romankooɓe ndee. ");
INSERT INTO ffm_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ɓe njehi, ɓe curoyi ɓeen, ɓe njaltini ɗum'en kasu oo. Ɓe ndaardi ɗum'en njaltana ɓe ngeenndi ndii. ");
INSERT INTO ffm_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Nde Pool e Silas njaltunoo e kasu oo ndee, naati galle Lidiya. Ɓe njii sakiraaɓe ɓee, ɓe mbaaltini hakkillaaji mum'en. Caggal ɗum, ɓe mbitti. ");
INSERT INTO ffm_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pool e Silas ceeki Amfipolis e Apolloni, njottii Tesaloniiki, toon duu waajorduYahuudiyankooɓe won. ");
INSERT INTO ffm_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pool waɗi no woowri nii, naati e ley waajordu nduu. Ɲalaaɗe powteteeɗe tati omo liddondira e maɓɓe omo dallinoroo Binndi ɗii. ");
INSERT INTO ffm_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","O fammini ɓe, o holli ɓe ana tilsi Almasiihu oo torree, immintinee e maayde. O wii ɓe: —Iisaa mo mbaajotoo-mi on haala muuɗum oo, kaɲum woni Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Yoga e maɓɓe taƴori ɗum goonga, njokki e Pool e Silas, kaɲum e Yunaninkooɓe rewooɓe Laamɗo heewɓe e rewɓe saahiiɓe yonɓe. ");
INSERT INTO ffm_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Yahuudiyankooɓe ɓe nganaa goonɗinɓe ɓee konnii Pool e Silas, nanngi yimɓe laaliiɓe yiilotooɓe ley sakoro, ndeentini ɗum'en. Ɓe njirkiti ngalluure ndee fuu. Ɓe naati e galle Yason, eɓe tewta Pool e Silas faa ɓe naɓa ɗum'en to yimɓe ɓee too. ");
INSERT INTO ffm_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Nde ɓe ndonki yiitude ɓeen ndee, ɓe ndaasi Yason e yoga e sakiraaɓe ɓee faa to saranooɓe ngalluure ndee, eɓe ngulla eɓe mbiya: —Yimɓe imminooɓe baasi e aduna oo fuu ngarii ɗoo, ");
INSERT INTO ffm_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yason jippinii ɗum'en! Ɓe fuu ko ɓe ngaɗata koo ana luuttondiri e sariya kaananke Roma mawɗo oo, eɓe mbiya ana woodi kaananke goɗɗo biyeteeɗo Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ɗiin haalaaji njirkiti jamaa oo e saranooɓe ngalluure ndee ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Yason e sakiraaɓe ɓee njoɓi kaalisi, caggal muuɗum ɓe njoppitaa. ");
INSERT INTO ffm_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Oon wakkati fuu e ley jemmaaku muuɗum, sakiraaɓe ɓee neli Pool e Silas Bereya. Nde ɓe njottii ndee, ɓe njehi to waajorduYahuudiyankooɓe too. ");
INSERT INTO ffm_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ɓeen ɓuri Yahuudiyankooɓe wonɓe Tesaloniiki ɓee laaɓude ɓernde. Ɓe njaɓɓorii konngol ngol soobee, eɓe mbiɗoo Binndi ɗii ɲannde fuu faa ɓe ƴeewa yalla ko Pool waajii koo yo goonga. ");
INSERT INTO ffm_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Heewɓe e maɓɓe ngoonɗini, kaɲum e rewɓe Yunaninkooɓe saahiiɓe e worɓe Yunaninkooɓe heewɓe. ");
INSERT INTO ffm_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nde Yahuudiyankooɓe Tesaloniiki ɓee anndunoo Pool waajike konngol Laamɗo ngol ley Bereya ndee, ɓe ngari ton, ɓe njiiɓi jamaa oo. ");
INSERT INTO ffm_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Oon wakkati fuu, sakiraaɓe ɓee neli Pool faa maayo geeci, Silas e Timote keddii ɗon. ");
INSERT INTO ffm_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Liwndiiɓe Pool ɓee njaadi e muuɗum faa Ateena. Ɓe ngarti, ɓe ngaddani Silas e Timote nelal ngara to Pool law. ");
INSERT INTO ffm_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nde Pool doomannoo ɓe Ateena fade maɓɓe warde ndee, yonki muuɗum ɲawi sanne ko yii no ngalluure ndee foti heewde tooruuji nii. ");
INSERT INTO ffm_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ɗum waɗi so o haaldi e Yahuudiyankooɓe e rewooɓe Laamɗo woɓɓe ley waajordu nduu, omo haalda e ɓe o hawrannoo e mum ɲannde fuu ley sakoro ɓee duu. ");
INSERT INTO ffm_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Yoga e miijotooɓe wiyeteeɓe Epikuri'en e Sitoyko'en njaabondiri e makko. Yogaaɓe ana mbiya: —Koɗum oo ndorƴoowo haalata? Woɓɓe duu ana mbiya: —Omo nanndi e baajotooɗo haala tooruuji janani. Walaa ko ɓe mbiiri non so wanaa haala Iisaa kaɲum e immital maayɓe o waajinoo ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Nden ɓe ɓami Pool ɓe naɓi ɗum waamnde haayre wiyeteende Areyopagus, ɓe mbii ɗum: —Miɗen njiɗi anndude diina keso mo mbaajoto-ɗaa oo. ");
INSERT INTO ffm_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Sabi a toɓɓii e noppi amen haalaaji ɗi min mboowaa nande. Miɗen njiɗi anndude maanaa majji. ");
INSERT INTO ffm_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tawi Ateenankooɓe e hoɓɓe jooɗiiɓe ton ɓee ngollataa huunde fuu so wanaa haalde huunde heyre nde ɓe nani. ");
INSERT INTO ffm_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nden Pool darii hakkunde Areyopagus, wii: —Ateenankooɓe, mi yii e mon on diinankooɓe sanne, ");
INSERT INTO ffm_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","sabi nde njiilinoo-mi e ngalluure mooɗon ndee, mi yii cuuɗi mooɗon dewirɗi, mi tawii ana winndaa e ittirde sadaka wootere: «laamɗo mo anndaaka». Ndennoo, ko ndewaton ko on anndaa koo, ɗum mbaajotoo-mi on e muuɗum. ");
INSERT INTO ffm_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Laamɗo taguɗo aduna e ko woni e muuɗum fuu oo, kaɲum woni Jom kammu e leydi, o jooɗataako ley cuuɗi mahiraaɗi juuɗe. ");
INSERT INTO ffm_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","O hasindinaa e yimɓe ngollana mo fay huunde, sabi kanko hokkata tageefu oo fuu nguurndam e yonki e foofaango e huunde fuu. ");
INSERT INTO ffm_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","E neɗɗo gooto Laamɗo yaltini leɲi ɗii fuu, joƴƴini ɗum'en e aduna oo. Gila ɗum waɗaali, o darnani ɗum'en jamaanuuji e keeri hakkunde koɗorɗe muuɗum'en, ");
INSERT INTO ffm_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","yalla eɓe tewta Laamɗo, ɓe moomoo faa ɓe njiita ɗum. Ɗum e taweede o woɗɗaaki fay gooto e meeɗen. ");
INSERT INTO ffm_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","«Nguurndam e dillinaade e goodal, saabe makko keɓir-ɗen.» No yoga e yimooɓe mooɗon mbii: «Enen duu, en iwdi makko.» ");
INSERT INTO ffm_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nde wonnoo en iwdi makko, en kaanaa miijaade omo nanndi e tooru moƴƴiniraandu kaŋŋe naa kaalisi naa haayre sehaande, nde neɗɗo moƴƴinirta ɲeeɲal e hakkille. ");
INSERT INTO ffm_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Laamɗo rewtaaki yimɓe nde ngonnoo e majjere ndee. Jooni, o yamirii yimɓe fuu tuuba ɗo tawaa fuu, ");
INSERT INTO ffm_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","sabi o sartike wakkati mo o sarirta aduna oo e fooccitaare, o sarira ɗum neɗɗo mo o suɓii oo. O hollii yimɓe fuu ɗum yo goonga nde o immintini oon neɗɗo e maayde. ");
INSERT INTO ffm_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Nde ɓe nannoo Pool ana waajoo haala immital maayɓe ndee, yoga ana uƴƴoo mo, yoga ana wiya: —Min kettinante oo waaju ɲannde wonnde. ");
INSERT INTO ffm_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Non Pool iwi hakkunde maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Yoga jokkii e makko, goonɗinii. Ana jeyaa e ɓeen biyeteeɗo Diyonisiyus, jeyaaɗo e deental Areyopagus, kaɲum e debbo biyeteeɗo Damaris, e woɓɓe kasen. ");
INSERT INTO ffm_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Caggal ɗum, Pool iwi Ateena, yehi Korintu. ");
INSERT INTO ffm_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","O tawi ton Yahuudiyanke biyeteeɗo Akilas, pinɗo leydi mbiyeteendi Ponta. Ɓooyaali ko oon e jom suudu muuɗum biyeteeɗo Piriskilla iwi Italiya, sabi Kalawdiyus kaananke mawɗo oo yamiriino Yahuudiyankooɓe fuu njalta Roma. Pool yehi ƴeewoyde ɓe. ");
INSERT INTO ffm_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","O woni ɗon, omo gollida e maɓɓe sabi o moƴƴinoowo hukkummaaji no maɓɓe nii. ");
INSERT INTO ffm_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ɲalaande fowteteende fuu, Pool ana liddondira e Yahuudiyankooɓe e Yunaninkooɓe ley waajordu, yalla omo heɓa hakkillaaji maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Nde Silas e Timote iwnoo Makedoniya njottii Korintu ndee, Pool watti hakkille muuɗum fuu e waajaade, ana seettanoo Yahuudiyankooɓe ɓee Iisaa woni Almasiihu oo. ");
INSERT INTO ffm_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kaa nde wonnoo eɓe calanii mo, eɓe njennannoo mo, o fiɗɗi kaddule makko, o wii ɓe: —Yo diina mon fiito on! Mi walaa hen hannde, mi walaa hen janngo. Gila jooni mi yahan to ɓe nganaa Yahuudiyankooɓe. ");
INSERT INTO ffm_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","O iwi ɗon, o yehi to gorko dewoowo Laamɗo, biyeteeɗo Titus Yustus, mo galle muuɗum takkii e waajordu nduu. ");
INSERT INTO ffm_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kirispus, hooreejo waajordu nduu oo, kaɲum e koreeji muuɗum fuu ngoonɗini Joomiraaɗo. Heewɓe e Korintunkooɓe hettintonooɓe ɓee ngoonɗini, lootaa lootogal batisima. ");
INSERT INTO ffm_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Jemma gooto Joomiraaɗo ƴellintini e Pool, wii: —Pati hul, pati deƴƴina, waaja. ");
INSERT INTO ffm_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Miɗo wondi e maa. Fay gooto waawaa torrude ma, sabi yimɓe am ana keewi ley ndee ngalluure. ");
INSERT INTO ffm_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pool jooɗii hakkunde maɓɓe hitaande e feccere, ana janngina ɓe konngol Laamɗo ngol. ");
INSERT INTO ffm_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Nde Galliyon laaminoo leydi Akaya ndee, Yahuudiyankooɓe kaaldi, kawri, nanngi Pool, naɓi ɗum sarirde, ");
INSERT INTO ffm_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","kappi ɗum, mbii: —Oo gorko yo ƴoɲɲoowo yimɓe yalla ana ndewra Laamɗo ko waldaa e sariya oo. ");
INSERT INTO ffm_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pool anniyii faa haala, forri Galliyon wii Yahuudiyankooɓe ɓee: —Yahuudiyankooɓe, so tawii tooɲannge naa golle bonɗo, mi jaɓanan on ko ngullani-ɗon mo koo, ");
INSERT INTO ffm_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","kaa nde wonnoo ɗum jeddi dow haalaaji diina mooɗon e inɗe, kaɲum e sariya mooɗon onon tan, ɗum onon e ko'e mooɗon carata. Miin, mi sarataa ɗee kuɗɗe! ");
INSERT INTO ffm_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","O yaltini ɓe sarirde ndee. ");
INSERT INTO ffm_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Nden, ɓe fuu ɓe nanngi Sosteni, hooreejo waajordu nduu oo, ɓe pii ɗum ɗo yeeso sarirde ɗoo. Kaa fuu Galliyon ɓilaaki hen fey. ");
INSERT INTO ffm_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pool faɓɓi ɗon balɗe kuurɗe. Caggal ɗum, o waynondiri e sakiraaɓe ɓee, o naati laana, o feewi Siriya, kanko e Piriskilla e Akilas. Fade makko naatude, tawi o laɓii hoore makko nokku biyeteeɗo Kankiriya sabi o fodiino fodoore. ");
INSERT INTO ffm_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ɓe njottii Efeesu, Pool yoppi ɗon Piriskilla e Akilas, kaɲum naati waajordu ana liddondira e Yahuudiyankooɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ɓe ndaardi mo o faɓɓana ɓe, kaa o jaɓaali. ");
INSERT INTO ffm_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Nde o waynondirta e maɓɓe ndee, o wii: —Mi wartan e mooɗon so Laamɗo jaɓii. O naati laana, o iwi Efeesu, ");
INSERT INTO ffm_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","o yottii Kaysariya, o ŋabbiti Urusaliima faa o jowta deental goonɗinɓe ngal. Caggal ɗum, o yehi Antiyokiya. ");
INSERT INTO ffm_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Caggal Pool waɗii ton wakkati, o witti. O seeki leydi Galaatiya e leydi Firigiya, omo yaha omo ɓeydana taalibaaɓe cuusal. ");
INSERT INTO ffm_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Yahuudiyanke biyeteeɗo Apollos, pinɗo Aleksandiri, wari Efeesu. O gorko fasiilante haala, baawɗo Binndi ɗii, ");
INSERT INTO ffm_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","annduɗo laawol Joomiraaɗo. Omo waajoroo soobirantaaku e seyo, diina Iisaa kaa pay o jannginta. Kaa o anndaa so wanaa lootogal batisimaYaayaa ngal. ");
INSERT INTO ffm_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Omo waajoroo cuusal e ley waajordu nduu. Nde Piriskilla e Akilas kettinaninoo mo ndee, ɓe naɓi mo, ɓe pirritani mo laawol Laamɗo ngol faa ɓuri no arannde nii laaɓude. ");
INSERT INTO ffm_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Nde Apollos anniyinoo yaade leydi Akaya ndee, sakiraaɓe ɓee mballi mo, ɓe mbinndi e taalibaaɓe wonɓe ton ɓee ɓataaki njaɓɓoo mo faa gasa. Nde o yottii ton ndee, o walli goonɗinɓe ɓee e dow moƴƴere Laamɗo sanne. ");
INSERT INTO ffm_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Sabi o liɓii Yahuudiyankooɓe ɓee ngattu naawɗo hakkunde yimɓe, omo dallinoroo Binndi ɗii, omo tabintina Iisaa woni Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nde Apollos wonnoo Korintu ndee, Pool jokki laawol haayre, yehi Efeesu. O tawi ton taalibaaɓe, ");
INSERT INTO ffm_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","o lamndii ɗum'en, o wii: —Yalla on keɓiino Ruuhu Ceniiɗo oo nde ngoonɗin-ɗon ndee naa? Ɓe njaabii mo: —Min nanaali Ruuhu Ceniiɗo ana woodi duu, sako min keɓa. ");
INSERT INTO ffm_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","O lamndii ɓe, o wii: —Ndennoo, lootogal batisima hongal keɓu-ɗon? Ɓe njaabii, ɓe mbii: —Lootogal batisima Yaayaa ngal. ");
INSERT INTO ffm_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pool wii: —Yaayaa batisima tuubugol batisannoo, ana wiya yimɓe ɓee yo ngoonɗin garoowo caggal muuɗum oo, ɗum woni Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Nde ɓe nannoo ɗum ndee, ɓe mbatisiraa saabe Iisaa Joomiraaɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nde Pool fawnoo juuɗe muuɗum e maɓɓe ndee, Ruuhu Ceniiɗo jippii e maɓɓe, eɓe kaala e ɗemɗe janane, eɓe kaalta ko Laamɗo loowi e maɓɓe koo. ");
INSERT INTO ffm_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Eɓe mbaara e yimɓe sappo e ɗiɗon. ");
INSERT INTO ffm_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pool naati e ley waajordu nduu, ana waajoroo ɓe cuusal hakke lebbi tati, omo haalda e maɓɓe, omo liddondira e maɓɓe, omo haɓanoo famminde ɓe haala Laamu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kaa tiiɗuɓe ko'e ngon e maɓɓe, calii goonɗinde, ana mbonnita laawol Joomiraaɗo ngol yeeso yimɓe fuu. Ɗum waɗi so Pool seerti e maɓɓe, naɓi taalibaaɓe ɓee feere, ana waajoo ɗum'en ɲannde fuu e ley janngirde neɗɗo biyeteeɗo Tirannus. ");
INSERT INTO ffm_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","O worri non faa hiɓɓi duuɓi ɗiɗi, faa hoɗunooɓe e Asiya ɓee fuu, gila e Yahuudiyankooɓe faa e Yunaninkooɓe, nani konngol Joomiraaɗo ngol. ");
INSERT INTO ffm_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Laamɗo waɗiri juuɗe Pool kaayɗe mawɗe, ");
INSERT INTO ffm_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","fay e sarbetiiji e kaddule memnooɗe terɗe makko ana naɓee pawee e ɲawɓe, ɲawuuji muuɗum'en cella, seyɗaani'en njalta e muuɗum'en. ");
INSERT INTO ffm_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Yoga e Yahuudiyankooɓe yiilotooɓe faa ndibba seyɗaani'en, ndaarii ribbirde ɗum'en innde Iisaa, mbii: —Alhorma Iisaa mo Pool waajotoo haala muuɗum oo, njaltee! ");
INSERT INTO ffm_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Gooto e hooreeɓe yottinooɓe sadaka, Yahuudiyanke biyeteeɗo Sikewas, ɓiɓɓe muuɗum worɓe njeɗɗon ngaɗii non, ");
INSERT INTO ffm_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","faa seyɗaani jaabii ɗum'en, wii: —Miɗo anndi Iisaa, miɗo anndi Pool, kaa onon, on hoɓe? ");
INSERT INTO ffm_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Neɗɗo laddaaɗo oo haɓi e maɓɓe, jaalii ɓe, torri ɓe faa ɓe ndogi, ɓe njaltiri galle oo terɗe teete e barme. ");
INSERT INTO ffm_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kabaaru majjum saakii hakkunde Yahuudiyankooɓe e Yunaninkooɓe jooɗiiɓe Efeesu. Kulol nanngi ɓe fuu, innde Iisaa Joomiraaɗo oo teddinaa. ");
INSERT INTO ffm_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Heewɓe e goonɗinɓe ɓee ngari njaadiri, kaalti golleeji ɗi ngaɗunoo. ");
INSERT INTO ffm_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Boŋobii'en heewɓe ndeentini dewte muuɗum'en, nduppi ɗe yeeso yimɓe fuu. Ɓe kiisii coggu majje, ɓe tawi ana foti ujunaaji capanɗe joy kaalisi daneejo. ");
INSERT INTO ffm_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Hono nii, haala Joomiraaɗo kaa ɓeydorii saakaade e heewde semmbe. ");
INSERT INTO ffm_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Caggal ɗum, Pool fellisi seekude Makedoniya e Akaya faade Urusaliima. O wii: —So mi tilike ton, waajibi mi yaha Roma duu. ");
INSERT INTO ffm_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","O neli gollidooɓe makko ɗiɗon, Timote e Erasta, njaha Makedoniya. Kanko, o faɓɓi Asiya. ");
INSERT INTO ffm_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","E oon wakkati, fitina mawɗo waɗi sabaabu laawol Joomiraaɗo ngol. ");
INSERT INTO ffm_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Baylo ndaneeri biyeteeɗo Demeteriyus ana tafa cuuroy kaalisi nanndukoy e rewrudu tooru biyeteeɗo Artemis. Omo heɓa hen tino heewngo, kanko e gollooɓe makko. ");
INSERT INTO ffm_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","O reentini ɓeen e woɓɓe ɓe nanndi golle, o wii ɗum'en: —Yiɓɓe, oɗon anndi e oo ɗoo golle keɓal meeɗen ngal fawii. ");
INSERT INTO ffm_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Oɗon njiya, oɗon nana Pool majjinii yimɓe heewɓe, wanaa ley Efeesu ɗoo tan, ley leyɗe Asiya fuu. O haalani ɓe kulle deweteeɗe ɗe yimɓe moƴƴiniri juuɗe mum'en ɗee nganaa deweteeɗe. ");
INSERT INTO ffm_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","So jokkii nii, yimɓe mbonnan golle meeɗen. Wanaa ɗum tan, yimɓe ŋoottan teddinde rewrudu Artemis nduu duu, tooru men mawɗo mo hoɗuɓe Asiya e aduna oo fuu ndewata oo. ");
INSERT INTO ffm_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Nde ɓe nani ɗiin haalaaji ndee, ɓe mettaa sanne, hedde eɓe ngulla, eɓe mbiya: —Artemis Efeesunkooɓe yo mawɗo! Artemis Efeesunkooɓe yo mawɗo! ");
INSERT INTO ffm_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ngalluure ndee fuu jiiɓii. Gooto fuu dogani boowal manngal ngal. Ɓe ndaasi Gayus e Aristarka Makedoniyankooɓe, yaaduɓe Pool ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pool ana yiɗi naatude hakkunde jamaa oo, kaa taalibaaɓe ɓee kaɗi mo ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Yoga e hooreeɓe leydi Asiya, yiɓɓe makko, neli e makko ana ndaarda mo pati o naata boowal too. ");
INSERT INTO ffm_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","E oon wakkati, jamaa oo ana jiiɓii sanne. Ɓee ana ngullana ɗum ɗoo, ɓee too ana ngullana ɗum gaa. Ko ɓuri heewde e yimɓe ɓee anndaa fay ko hawrintini ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yoga e jamaa oo kaaltani haala kaa gorko biyeteeɗo Aleksandere mo Yahuudiyankooɓe ɓee ngaɗi kaaloowo muuɗum'en oo. Aleksandere huncani ɓe junngo faa jinngana yimɓe muuɗum ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kaa nde ɓe annditinnoo o Yahuudiyanke ndee, ɓe fuu eɓe ngulla ko waarata e leeruuji ɗiɗi, eɓe mbiya: —Artemis Efeesunkooɓe yo mawɗo! ");
INSERT INTO ffm_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nden binndoowo ngalluure ndee deƴƴini jamaa oo, wii: —Onon Efeesunkooɓe, homo woni mo anndaa ngalluure Efeesu ndee woni hayboore rewrudu Artemis deweteeɗo mawɗo oo, kaɲum e natal muuɗum iwrungal dow kammu ngal? ");
INSERT INTO ffm_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nde wonnoo fay gooto waawaa yeddude ɗum, oɗon kaani jippinde hakkillaaji mooɗon pati ngolliron fay huunde e heɲaare. ");
INSERT INTO ffm_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Worɓe ɓe ngaddu-ɗon ɓee, nganaa wujjooɓe kulle rewrudu, nganaa yennooɓe deweteeɗo meeɗen oo. ");
INSERT INTO ffm_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","So tawii Demeteriyus e gollooɓe wonduɓe e muuɗum ɓee won mo njiɗi wullanaade, ɲalaaɗe careteeɗe ana ndarnaa, kaanankooɓe sarooɓe ana ngoodi, yo ɓe noddondir! ");
INSERT INTO ffm_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Kaa so tawii won goɗɗum ko ndaartaton, to deental saahiiɓe ɗum saroytee. ");
INSERT INTO ffm_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Eɗen mbaawi felireede murtere waɗunde hannde ndee, sabi fitina baaɗo nii walaa fay daliili gooto. ");
INSERT INTO ffm_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Caggal ɗii haalaaji, o firriti jamaa oo. ");
INSERT INTO ffm_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nde fitina oo yawti ndee, Pool mooɓti taalibaaɓe ɓee, waajii ɗum'en. Caggal ɗum, waynii ɗum'en, feewi Makedoniya. ");
INSERT INTO ffm_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","O seeki ndiin leydi, omo waajoo yimɓe ɓee haalaaji keewɗi. Caggal ɗum, o yehi Yuunan. ");
INSERT INTO ffm_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","O waɗi ton lebbi tati. O lanndinii faa o naata laana faade Siriya. Kaa caggal nde Yahuudiyankooɓe ndawridi faa njammboo mo, o anniyii wirfitoraade laawol Makedoniya. ");
INSERT INTO ffm_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ɓee ɗoo ɗowtunoo mo: Sopater ɓii Pirrus jeyaaɗo Bereya, e Aristarka e Sekundus jeyaaɓe Tesaloniiki, e Gayus jeyaaɗo Derbe e Timote e Tikikus e Torofim jeyaaɓe leydi Asiya. ");
INSERT INTO ffm_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ɓeen ardii min, ndoomoyi min Torowas. ");
INSERT INTO ffm_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Minen, min naati laana faade Filipa caggal iidi mo buuru ƴuufinaaka. E ley balɗe joy min kewtii ɓe Torowas, min ngaɗi ɗon yontere. ");
INSERT INTO ffm_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ɲannde aranndeere e yontere, tawi miɗen mooɓtii faa min taƴa buuru. Pool ana waajoo yimɓe ɓee, nde wonnoo omo anniyii wittude janngo mum. O jokki e waaju oo faa hejjere jemma. ");
INSERT INTO ffm_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Lampaaji keewɗi ana ngonnoo e ley suudu dowuuru ndu min mooɓtinoo e muuɗum nduu. ");
INSERT INTO ffm_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Suka jokolle biyeteeɗo Ewtikus ana jooɗii dow falanteere. Ko Pool juutini waaju muuɗum oo koo, Ewtikus ɗaanii ɗoyngol teddungol. O saami iwde e falanteere sooro tataɓo ngoo. Nde ɓe ɓamti mo ndee, tawi o maayii. ");
INSERT INTO ffm_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Kaa Pool jippii, hippii e makko, ɓami mo e juuɗe muuɗum, wii: —Mbaaltee! Yonki makko wartii e makko! ");
INSERT INTO ffm_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Nii Pool ŋabbiti, taƴi buuru, ɲaami. Caggal ɗum, o jokki waaju makko faa weenndoogo, o witti. ");
INSERT INTO ffm_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Suka jokolle oo naɓtaa ana wuuri. Ɗum ɓuuɓini ɓerɗe maɓɓe sanne. ");
INSERT INTO ffm_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Minen, min adii wirfitaade, min naati laana faade Assos ɗo min kaani naatinde Pool, sabi o anniyiiɗo yaarude ton koyɗe. ");
INSERT INTO ffm_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Nde min tawondiri Assos ndee, min naanni mo laana, min peewi Mitilene. ");
INSERT INTO ffm_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Min iwi ɗon e laana, min njottoyii janngo mum yeeso ruunde Kiyos. Faɓɓi-janngo mum min ƴaɓɓorii bannge ruunde Samos, faɓɓiti-janngo mum min njottii Miletus. ");
INSERT INTO ffm_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pool fellisii ƴaɓɓoraade Efeesu, sabi o yiɗaa neeptude e leydi Asiya ndii, omo heɲoo yottaade Urusaliima ɲannde iidi Pantekot so tawii ana laatoo. ");
INSERT INTO ffm_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nde Pool wonnoo Miletus ndee, nelani hooreeɓe deental goonɗinɓe Efeesu ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Nde ɓe ngari ndee, o wii ɓe: —Oɗon anndi no ngorru-mi e mooɗon gila ɲannde koyngal am adii naatude e leydi Asiya ndii faa hannde. ");
INSERT INTO ffm_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Mi golliranii Joomiraaɗo leyɗinkinaare fuu, kaɲum e gonɗi keewɗi e torraaji Yahuudiyankooɓe kewtiiɗi kam ɗii. ");
INSERT INTO ffm_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Oɗon anndi mi suuɗaali on huunde fuu ko nafata on, mi waajike on, mi jannginii on hakkunde yimɓe kaɲum e ley galleeji mooɗon. ");
INSERT INTO ffm_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mi tinndinii Yahuudiyankooɓe e Yunaninkooɓe fuu tuubana Laamɗo, ngoonɗina Joomiraaɗo meeɗen Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Jooni, miɗo nii jokki e Ruuhu Ceniiɗo, miɗo yaha Urusaliima, mi anndaa ko hewtoytoo kam ton, ");
INSERT INTO ffm_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","so wanaa ko Ruuhu Ceniiɗo oo hollata kam: ley geelle ɗee fuu ana wiya kam geƴƴelle e torra ana ndoomi kam. ");
INSERT INTO ffm_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kaa miin, mi jataaki nguurndam am e maayde am fuu so mi heɓii yottinirde golle mo Iisaa Joomiraaɗo halfini kam oo seyo. Oon golle woni seettaade Kabaaru Lobbo haala hinnee Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Jooni, miɗo anndi on njiitataa kam kasen, onon ɓe ngondunoo-mi so miɗo waajoo ɗum'en haala Laamu Laamɗo oo ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Ɗum waɗi so miɗo seettanoo on hannde ɗum ɗoo: so tawii gooto e mooɗon halkiima, wanaa sabaabu am. ");
INSERT INTO ffm_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Sabi mi waajike on anniyaaji Laamɗo fuu, mi suuɗaali on fay huunde. ");
INSERT INTO ffm_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ndeenee ko'e mooɗon, ndeenon sewre nde Ruuhu Ceniiɗo oo ɗaldi on ndee, laato-ɗon durooɓe deental goonɗinɓe Laamɗo ngal, sabi ƴiiƴam makko o soottitorii ngal. ");
INSERT INTO ffm_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Miin, miɗo anndi caggal am yimɓe bonɓe cooroto e ley mooɗon hono no pobbi nii, kasen duu ɗi njokkan e sewre ndee. ");
INSERT INTO ffm_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Fay e ley mooɗon daɲan worɓe immiiɓe ana mbaajoo waajuuji peneeji faa pooɗa taalibaaɓe ɓee njokka caggal muuɗum'en. ");
INSERT INTO ffm_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ɗum nee, njeertee! Miccito-ɗon duuɓi tati, jemma e ɲalooma, mi ŋoottaali waajoraade gooto e mooɗon fuu gonɗi. ");
INSERT INTO ffm_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Jooni, mi halfinii on Laamɗo, kaɲum e konngol hinnee muuɗum baawngol naɓude on yeeso e ley goonɗinal, hokka on ko resani sennaaɓe ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Abada mi muuyaali fay huunde e mon, wanaa kaalisi, wanaa kaŋŋe, wanaa kaddule. ");
INSERT INTO ffm_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Onon e ko'e mooɗon, oɗon anndi juuɗe am ɗee kumti haajuuji am e haajuuji wonduɓe am. ");
INSERT INTO ffm_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mi hollii on e kabaaruuji ɗii fuu, kinaa ngolliron non, mballon lo'uɓe tawa oɗon miccitoo ɗii ɗoo haalaaji ɗi Joomiraaɗo men Iisaa haali kaɲum e hoore muuɗum: «Hokkude ɓuri mbelko'aaku diina hokkoreede.» ");
INSERT INTO ffm_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Nde Pool tilinoo haalde ɗum ndee, kaɲum e maɓɓe fuu ɓe ndiccii, ɓe nduwii. ");
INSERT INTO ffm_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ɓe fuu ɓe mboyi bojji mawɗi, ɓe kippii e Pool, ɓe caɓɓindii ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ko ɓeydi suŋlinde ɓe ko o wii ɓe njiitataa mo kasen koo. Caggal ɗum, ɓe liwndii mo faa to laana too. ");
INSERT INTO ffm_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nde min ceerti e maɓɓe ndee, min naati laana geeci, min peewi ruunde Kos. Janngo mum, min njottii ruunde Rodusa, min iwi ɗon, min peewi ngeenndi Patara. ");
INSERT INTO ffm_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Min keɓi laana lummboowa yaade Finikiya, min naati hen, min ɓettii. ");
INSERT INTO ffm_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nde min njahunoo faa min coynorii Kiprus bannge amen nano, min peewi Siriya, min njottoyii Tirus. Ɗon laana kaa jippinta kaaki muuɗum. ");
INSERT INTO ffm_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Min tawi ɗon taalibaaɓe, min ngoni ɗon balɗe jeɗɗi. Eɓe mbiira Pool ley Ruuhu Ceniiɗo pati ŋabbita Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Nde yontere ndee hiɓɓunoo ndee, min mbitti. Ɓe fuu ɓe liwndii min faa min njalti ngeenndi ndii, kamɓe e rewɓe e sukaaɓe. Min ndiccii dow fonngo maayo geeci, min nduwii. ");
INSERT INTO ffm_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nde min mbaynondirnoo ndee, minen min naati laana, kamɓe ɓe mbirfitii cuuɗi maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nde min naati laana Tirus ndee, min njottoyii Potolemayis. Min njowti sakiraaɓe, min ɲallani ɓe, min mbaali. ");
INSERT INTO ffm_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Janngo mum, min ndawi, min njottii Kaysariya, min naati suudu Filipa baajotooɗo Kabaaru Lobbo oo, min njippanii ɗum. Kanko omo jeyaa e njeɗɗon suɓaaɓe Urusaliima ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Omo jogii ɓiɓɓe rewɓe nayon ɓe ɓamaaka, haaltooɓe ko Laamɗo loowi e mum'en koo. ");
INSERT INTO ffm_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nde min paɓɓunoo ɗon ndee, gorko loowaaɗo konngol Laamɗo biyeteeɗo Agabus iwri Yahuudiya. ");
INSERT INTO ffm_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","O wari e amen, o ɓami kumorgol Pool, o haɓɓi juuɗe makko e koyɗe makko, o wii: —Ruuhu Ceniiɗo wii: nii Yahuudiyankooɓe wonɓe Urusaliima ɓee kaɓɓirta jeyɗo ngol kumorgol oo, ngaɗa ɗum e juuɗe heeferɓe. ");
INSERT INTO ffm_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nde min nani ɗum ndee, minen e jeyaaɓe ɗon ɓee fuu, min ndaardi Pool pati ŋabba Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Pool jaabii, wii: —Koɗum waɗi so oɗon mboya, oɗon taƴa ɓernde am? Miin, miɗo lanndinanii ko wanaa haɓɓeede tan, miɗo lanndinanii fay maayde Urusaliima saabe innde Iisaa Joomiraaɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nde min ndonkunoo waylitinde mo ndee, min celi e makko, min mbii: —Yo muuyɗe Joomiraaɗo laato! ");
INSERT INTO ffm_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Caggal ɗeen balɗe, min lanndinii, min ŋabbiti Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Yoga e taalibaaɓe Kaysariyankooɓe njaadi e amen, naɓi min galle gorko biyeteeɗo Manason, jeyaaɗo Kiprus, laatiiɗo taalibbo gila ko ɓooyi, yalla miɗen jippanoo ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nde min njottii Urusaliima ndee, sakiraaɓe ɓee njaɓɓorii min weltaare. ");
INSERT INTO ffm_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Janngo mum, min njaadi e Pool to Yaakuuba. Hooreeɓe deental goonɗinɓe ɓee fuu ana tawanoo ton. ");
INSERT INTO ffm_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Caggal ko o jowti ɓe koo, o haalani ɓe huunde fuu ko Laamɗo waɗani yimɓe ɓe nganaa Yahuudiyankooɓe saabe golle makko. ");
INSERT INTO ffm_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Nde ɓe nani ɗum ndee, ɓe njetti Laamɗo. Ɓe mbii Pool: —Sakiike, hono foti ujunaaji Yahuudiyankooɓe njii-ɗaa ko ngoonɗini, haya faa hannde eɓe tiinnii e jokkude Sariya Muusaa oo. ");
INSERT INTO ffm_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ɓe kaalanaama aɗa janngina Yahuudiyankooɓe wonɓe hakkunde leɲi goɗɗi njoppa Sariya Muusaa, mbii-ɗaa pati taada sukaaɓe muuɗum'en kasen, pati njokka neesuuji ɗii kasen. ");
INSERT INTO ffm_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Ndennoo, hono ngaɗaten? Sabi min taƴorii ɓe nanan a warii. ");
INSERT INTO ffm_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Waɗu ko min kaalante koo. Miɗen njogii ɗoo worɓe nayon ɓamanɓe Laamɗo fodoore. ");
INSERT INTO ffm_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Naɓu ɓe cennidaa hoore maa e maɓɓe, njoɓaa ko ɓe kaani yoɓude koo, yalla eɓe mbaawa laɓeede. Yimɓe fuu anndan ko haaletenoo e maa koo fuu wanaa goonga, ɓe anndan kasen aan e hoore maa, aɗa jokki Sariya Muusaa. ");
INSERT INTO ffm_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Goonɗinɓe iwɓe e leɲi goɗɗi ɓee, min mbinndii e mum'en ndeentoo e ko hirsanaa tooruuji e ƴiiƴam e jiibuɗi, kaɲum e jeenu. ");
INSERT INTO ffm_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Pool ɓami naɓi worɓe ɓee, yaadi e mum'en. Janngo mum, ɓe cennidaa. O naati Suudu Dewal Mawndu nduu, o haalani yottinooɓe sadaka ɲalaaɗe sennugol ɗee kiɓɓii, faa gooto e maɓɓe fuu waɗanee sadaka. ");
INSERT INTO ffm_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Nde balɗe jeɗɗi ɗee ɓadinoo hiɓɓude ndee, yoga e Yahuudiyankooɓe leydi Asiya njii Pool e ley Suudu Dewal Mawndu nduu, ɓe njirkiti yimɓe ɓee fuu, ɓe nanngi mo. ");
INSERT INTO ffm_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Eɓe ngulla, eɓe mbiya: —Israa'iilankooɓe, paabee min! Oo woni gorko jannginoowo yimɓe e ley nokkuuje ɗee fuu ana bekkisoo yimɓe leɲol meeɗen, ana bekkisoo sariya meeɗen oo, ana bekkisoo nokku ceniiɗo oo. Jooni kaa, o waddii fay Yunaninkooɓe e ley Suudu Dewal Mawndu nduu. O soɓinii oo nokku ceniiɗo! ");
INSERT INTO ffm_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Walaa ko ɓe mbiiri non so wanaa ɓe njiino Torofim Efeesunke oo ana wondi e Pool ley ngalluure ndee. Ɓe cikkiino Pool naanniino mo e ley Suudu Dewal Mawndu nduu. ");
INSERT INTO ffm_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Jirkitagol ngol huuɓi ngalluure ndee. Yimɓe ana njaltira tatteeji ɗii fuu. Ɓe nanngi Pool, ɓe ndaasi ɗum faa ɓe njaltini ɗum Suudu Dewal Mawndu nduu, ɓe uddi dame ɗee oon wakkati fuu. ");
INSERT INTO ffm_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Nde ɓe tewti faa ɓe mbara Pool ndee, tawi hooreejo sordaasi'en oo humpitike Urusaliima fuu ana darorii koyngal gootal. ");
INSERT INTO ffm_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ɗon e ɗon, o ɓami sordaasi'en e mawɓe muuɗum'en, o dogani ɓe. Nde yimɓe ɓee njii mo kanko e sordaasi'en ɓee ndee, ŋootti fiide Pool. ");
INSERT INTO ffm_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","O ɓattii Pool, o yamiri Pool nanngee, o wii haɓɓiree calali ɗiɗi, o lamndii kaɲum yo homo e koɗum waɗi? ");
INSERT INTO ffm_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Jamaa oo ana wulla. Ɓee ana ngulla geɗel, ɓee too ana ngulla gonngel. Nde wonnoo jirkitaare ndee haɗii mo faamde, o yamiri Pool naɓee to huɓeere too. ");
INSERT INTO ffm_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Nde Pool wari faa ŋabba kalikali huɓeere oo ndee, sordaasi'en ɓee ndoondii mo saabe jirkitaare jamaa oo, ");
INSERT INTO ffm_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","sabi yimɓe heewɓe ana njokki e makko ana ngulla, ana mbiya: —War mo! ");
INSERT INTO ffm_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Nde ɓe ngari faa ɓe naanna mo e damal huɓeere ngal ndee, Pool wii hooreejo oo: —Ana daganoo kam mi haalda e maa naa? Oon wii mo: —Ee? Aɗa waawi yunaninkoore naa? ");
INSERT INTO ffm_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ndennoo wanaa aan woni Misiranke gaɗuɗo murtere ko ɓooyaali, wardi e warooɓe ko'e ujunaaji nayon, naɓi ɗum'en ley ladde jeereende oo? ");
INSERT INTO ffm_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pool jaabii, wii: —Miin, mi Yahuudiyanke pinɗo Tarsus ley leydi Silisi, e ndee ngalluure nde wanaa ɲooɓunde njeyaa-mi. Miɗo ɲaage nduŋano-ɗaa kam mi haalda e yimɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","O duŋanii ɗum. Pool darii e dow ŋabbirde ndee, huncani yimɓe ɓee junngo. Nde ɓe ndeƴƴininoo ndee, o haali e ibaraninkoore, o wii: ");
INSERT INTO ffm_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","—Sakiraaɓe e baabiraaɓe, kettinee jooni faa mi fammina on mi waɗaali ko boni. ");
INSERT INTO ffm_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Nde ɓe nani ibaraninkoore o haaldata e maɓɓe ndee, ɓe ndeƴƴinii teen. O wii: ");
INSERT INTO ffm_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","—Mi Yahuudiyanke pinɗo Tarsus ley leydi Silisi. Kaa ɗo Urusaliima ɗoo mawnu-mi. Gamaliyel wonnoo moobbo am. Kanko janngini kam sariya njaatiraaɓe meeɗen oo faa paamu-mi. Miɗo jootunoo e Laamɗo hono no on fuu ngorru-ɗon hannde nii. ");
INSERT INTO ffm_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mi torrii jokkuɓe ngol ɗoo Laawol ɓee faa maayi. Mi nanngii worɓe e rewɓe, mi uddii ɗum'en kasu. ");
INSERT INTO ffm_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Jottinoowo Sadaka Mawɗo e waalde Saahiiɓe ɓee fuu ana ceettanoo kam kaɲum'en duu. Keɓu-mi e maɓɓe kasen talki faa mi holla sakiraaɓe maɓɓe wonɓe Damas ɓee, njaa-mi haɓɓoyde jokkuɓe laawol Iisaa wonɓe ton ɓee, faa mi wadda ɗum'en Urusaliima yalla ana caree. ");
INSERT INTO ffm_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Njaa-mi faa ɓadii-mi Damas, wakkati hakkunde naange, fooyre mawnde iwi dow kammu, yaayni, filii kam. ");
INSERT INTO ffm_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Caamu-mi e leydi, nan-mi daande ana wiya kam: «Sool, Sool, ko saabii so aɗa torra kam?» ");
INSERT INTO ffm_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Njaabii-mi, mbii-mi: «Aan homo, giɗo Laamɗo?» O wii kam: «Miin, Iisaa Nasaraatunke mo torru-ɗaa oo.» ");
INSERT INTO ffm_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Wonduɓe e am ɓee njii fooyre ndee, kaa ɓe nanaali daande kaalduɗo e am oo. ");
INSERT INTO ffm_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nden, mbii-mi: «Joomiraaɗo, koɗum ngaɗan-mi?» Joomiraaɗo wii kam: «Imma, yaa Damas, a haalante ton ko njamire-ɗaa ngaɗaa koo fuu.» ");
INSERT INTO ffm_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Wonduɓe e am ɓee ɗowi kam faa ley Damas, sabi fooyre ndee wumniino kam no nde sattiri yaaynude. ");
INSERT INTO ffm_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Ananiyas yo gorko kulɗo Laamɗo, jokkuɗo Sariya Muusaa, mo Yahuudiyankooɓe hoɗuɓe ton fuu ceettii moƴƴo oo, ");
INSERT INTO ffm_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","wari, darii yeeso am, wii kam: «Sool, sakiike, wumtu!» Ɗon e ɗon njii-moo-mi. ");
INSERT INTO ffm_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","O wii: «Laamɗo njaatiraaɓe meeɗen oo suɓike ma yalla aɗa annda sago muuɗum, njiyaa Pooccitiiɗo oo, nanaa haala muuɗum. ");
INSERT INTO ffm_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Sabi aan seettantoo mo yeeso yimɓe fuu ko njii-ɗaa e ko nan-ɗaa. ");
INSERT INTO ffm_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Jooni, koɗum ndoomataa? Imma, loote-ɗaa lootogal batisima, njaafire-ɗaa luutti maa e noddude innde Joomiraaɗo.» ");
INSERT INTO ffm_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Caggal mi wirfitike Urusaliima, miɗo rewa Laamɗo ley Suudu Dewal Mawndu nduu, faa won ko ƴellitii e am, ");
INSERT INTO ffm_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","nden njii-mi Joomiraaɗo, wii kam: «Heɲa law, yaltu Urusaliima, sabi ɓe njaɓataa seedaaku mo ceettanto-ɗaa kam oo.» ");
INSERT INTO ffm_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Njaabii-mi, mbii-mi: «Joomiraaɗo, eɓe anndi miɗo yahannoo ley cuuɗi baajorɗi ɗii fuu, miɗo uddannoo miɗo fiyannoo goonɗinɓe ma ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Nde ƴiiƴam Eciyen seede maa oo yuppetee ndee, miɗo darii, eɗum weli kam ko o waraa koo, miin haybannoo kaddule warɓe mo ɓee.» ");
INSERT INTO ffm_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Joomiraaɗo jaabii kam, wii: «Yaa, mi nelete to woɗɗi to yimɓe ɓe nganaa Yahuudiyankooɓe.» ");
INSERT INTO ffm_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Eɓe kettinanii mo faa o haali ngol konngol. Nden ɓe ngulli, ɓe mbii: —Ittu mo e leydi ndii! Hono oo haanaa wuurde! ");
INSERT INTO ffm_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Eɓe ngulla, eɓe mbeeynaa saayaaji maɓɓe, eɓe immina colla. ");
INSERT INTO ffm_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Hooreejo oo yamiri Pool naɓee to ley huɓeere too, lamndoree piiɗe faa ɓe annda ko saabii so jamaa oo ana wulla e makko hono nii. ");
INSERT INTO ffm_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Nde ɓe kaɓɓi mo faa ɓe piya mo ndee, o wii mawɗo gonɗo ɗon oo: —Ana daganoo on piyon Romanke sako mo saraaka naa? ");
INSERT INTO ffm_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Nde mawɗo oo nani ɗum ndee, haalanoyi hooreejo oo, wii: —Aɗa anndi ko kosu-ɗaa faa ngaɗaa naa? Gorko oo yo Romanke non! ");
INSERT INTO ffm_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Nden hooreejo oo yehi to Pool, lamndii ɗum, wii: —Haalanam, soobee fuu a Romanke naa? Pool jaabii, wii: —Kaɲum! ");
INSERT INTO ffm_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Hooreejo oo jaabii, wii: —Miin, so wanaa njoɓu-mi kaalisi keewɗo nde keɓu-mi laataade Romanke. Pool wii mo: —Miin, mi finii mi tawii mi kaɲum. ");
INSERT INTO ffm_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ɗon e ɗon anniyiiɓe fiide mo faa tilsina mo haaltude ɓee njalti. Hooreejo oo huli, sabi anndii Pool yo Romanke, haɓɓiino ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Janngo mum, kammari hooreejo oo ana yiɗunoo taƴorde ko Yahuudiyankooɓe ɓee ngullanirii Pool, humti ɗum, yamiri hooreeɓe yottinooɓe sadaka e waalde Saahiiɓe ndee fuu kawrita. Caggal ɗum, o waddi Pool, o darni ɗum yeeso maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pool ƴeewi waalde Saahiiɓe ɓee, wii: —Sakiraaɓe, hakkille baaltiiɗo nguurdu-mi yeeso Joomiraaɗo gila pinu-mi faa yottaade ɲalooma hannde oo. ");
INSERT INTO ffm_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Nii Ananiyas, Jottinoowo Sadaka Mawɗo oo, yamiri darinooɓe bannge makko ɓee piya mo e hunduko. ");
INSERT INTO ffm_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Nden, Pool wii mo: —Laamɗo fiyete, aan kokowol dawninaangol! A jooɗoto faa cariraa kam Sariya Muusaa, ko njamir-ɗaa mi fiyee koo a luuttii Sariya Muusaa. ");
INSERT INTO ffm_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Darinooɓe ɗon ɓee mbii Pool: —A yennan Jottinoowo Sadaka Mawɗo mo Laamɗo suɓii oo naa? ");
INSERT INTO ffm_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pool jaabii, wii: —Sakiraaɓe, mi anndaa o Jottinoowo Sadaka Mawɗo, sabi miɗo anndi ana winndii: «Pati yennu hooreejo leɲol maa!» ");
INSERT INTO ffm_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Nde wonnoo Pool ana anndi yoga e Saahiiɓe ɓee yo Saduki'en, yoga mum'en yo Farisa'en, duki semmbe, wii: —Sakiraaɓe, miin mi Farisanke, ɓii Farisanke. Saabe fawgol jikke e immital maayɓe carirtee-mi. ");
INSERT INTO ffm_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Nde o haalnoo ɗum ndee, Farisa'en ɓee e Saduki'en ɓee njeddondiri, deental ngal feccii. ");
INSERT INTO ffm_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Tawi Saduki'en ana mbiya immital walaa, malaa'ika'en ngalaa, ruuhuuji ngalaa, kaa Farisa'en ana ngoonɗini ɗum fuu. ");
INSERT INTO ffm_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Duko ngoo ɓeydii mawnude. Yoga e dunkee'en Sariya heedanɓe Farisa'en ɓee ndarii, immini duko manngo, ana mbiya: —Walaa fuu ko boni ko min njii e oo gorko. Ana waawi taweede ruuhu naa malaa'ika haaldi e makko! ");
INSERT INTO ffm_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Jeddi ɗii mawni faa hooreejo sordaasi'en oo huli pati Pool seekee. Ɗum waɗi so o yamiri sordaasi'en njippoo to deental too, itta Pool e juuɗe yimɓe ɓee, naɓta ɗum to huɓeere too. ");
INSERT INTO ffm_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Jemma jokkuɗo hen oo, Joomiraaɗo darii yeeso Pool, wii ɗum: —Pati hul! No ceettanori-ɗaa kam ley Urusaliima nii, ana haani ceettanoro-ɗaa kam non Roma duu. ");
INSERT INTO ffm_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Nde weetunoo ndee, Yahuudiyankooɓe ɓee ngaɗi gaddal, kunii ɲaamataa njarataa gila ɗoo faa mbara Pool. ");
INSERT INTO ffm_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Wannooɓe ngal gaddal ɓee ana ɓuri capanɗe nayon gorko. ");
INSERT INTO ffm_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ɓe njehi to hooreeɓe yottinooɓe sadaka e mawɓe, ɓe mbii: —Min kunike hunoore fay huunde min ɲaamataa min njarataa gila ɗoo faa min mbara Pool. ");
INSERT INTO ffm_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Jooni, onon e waalde Saahiiɓe ɓee, mbiyee hooreejo sordaasi'en oo waddana on Pool, mbiyon oɗon njiɗi faamtindaade ko o haalannoo koo. Minen, miɗen lanndinii faa min mbara mo gila mo yottaaki. ");
INSERT INTO ffm_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Baaɗii Pool gorko nani haala gaddal ngal, yehi to huɓeere too, naati, humpiti Pool. ");
INSERT INTO ffm_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pool noddi gooto e mawɓe sordaasi'en ɓee, wii ɗum: —Naɓu oo suka gorko to hooreejo too, sabi won ko o yiɗi haalande ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mawɗo sordaasi'en oo naɓi mo to hooreejo muuɗum too, wii ɗum: —Nanngaaɗo biyeteeɗo Pool oo noddi kam, ɲaagii kam mi wadda oo suka gorko to maa, sabi won ko oon yiɗi haalande ma. ");
INSERT INTO ffm_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Hooreejo oo nanngi junngo makko, sawdintini mo, wii: —Koɗum kaalantaa kam? ");
INSERT INTO ffm_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","O wii ɗum: —Yahuudiyankooɓe kaaldii, kawrii, ndaardete janngo yalla aɗa waddana ɗum'en Pool yeeso waalde Saahiiɓe ɓee, ɓe nanndinkinoo e yiɓɓe faamtindaade ko o haalannoo koo. ");
INSERT INTO ffm_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Pati njaɓanaa ɓe! Sabi ko ɓuri worɓe capanɗe nayon e maɓɓe ana ɲugganii mo, kunike ɲaamataa njarataa so mbaraali mo. Ɓe lanndinike, eɓe ndoomi yamiroore maa. ");
INSERT INTO ffm_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Hooreejo oo wii suka gorko oo: —Pati haalan fay gooto a haalanii kam ɗum. O yoppi ɗum witti. ");
INSERT INTO ffm_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Caggal ɗum, o noddi mawɓe sordaasi'en makko ɗiɗon, o wii ɗum'en: —Mooɓtee worɓe teemeɗe ɗiɗon e waɗɗiiɓe pucci capanɗe njeɗɗon, kaɲum e teemeɗe ɗiɗon jom'en gaawe. On fuu, lanndinee yaade Kaysariya wakkati jeenaɓo jemma. ");
INSERT INTO ffm_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kaɓɓee pucci faa naɓiron Pool e dow jam, to Filikus goforneer oo too. ");
INSERT INTO ffm_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Hooreejo oo winndi oo ɓataaki: ");
INSERT INTO ffm_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Miin, Kalawdiyus Lisiyas, miɗo jowte, aan Filikus goforneer tedduɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Gorko mo neldu-maa-mi oo, Yahuudiyankooɓe nanngunoo ɗum, anniyii warde ɗum. Nde kumpitinoo-mi o Romanke ndee, naatu-mi hen, miin e fedde sordaasi'en ndee, mbiltu-moo-mi. ");
INSERT INTO ffm_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nde wonnoo miɗo yiɗi faamde ko ɓe ngullanirii mo ndee, ngaddu-moo-mi yeeso waalde Saahiiɓe maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Taw-mi banngal sariya maɓɓe tan ɓe ngullanirii mo, kaa ko o wullanaa e muuɗum koo, waawaa waddande mo wareede naa uddeede. ");
INSERT INTO ffm_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Caggal ɗum, martu-mi kumpa Yahuudiyankooɓe ndawridii faa nannga mo. Ɗum waɗi so neldu-maa-mi mo ɗon e ɗon, njamir-mi wullaniiɓe mo ɓee duu njaha to maa. ");
INSERT INTO ffm_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sordaasi'en ɓee ngaɗi ko njamiraa koo, ɓami Pool ley jemmaaku, naɓi ɗum faa Antibatiris. ");
INSERT INTO ffm_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Janngo mum, sordaasi'en yaarannooɓe koyɗe ɓee mbirfitii to huɓeere too, ɗaldi Pool waɗɗiiɓe pucci ɓee njottinoya ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Nde ɓeen njottinoo Kaysariya ndee, ndokki goforneer oo ɓataaki oo, kolli ɗum Pool. ");
INSERT INTO ffm_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Nde kaananke oo janngi ɓataaki oo ndee, lamndii hoto o jeyaa. Nde o nani Silisi Pool jeyaa ndee, ");
INSERT INTO ffm_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","o wii ɗum: —So wullaniiɓe ma ɓee ngarii, mi nanan haala maa. O yamiri oon mooɓtoyee to suudu laamordu Hirudus too. ");
INSERT INTO ffm_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Balɗe joy caggal muuɗum, Ananiyas Jottinoowo Sadaka Mawɗo oo yottii Kaysariya ana wondi e yoga e mawɓe ɓee, kaɲum e dunkee sariyaRomankooɓe biyeteeɗo Tartulus. Ɓe ngullanii Pool to goforneer oo. ");
INSERT INTO ffm_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Nde Pool noddaa ndee, Tartulus fuɗɗi wullanaade mo yeeso kaananke oo, wii: —Filikus kaananke tedduɗo, laamu maa waddanii min jam ɓooyɗo, kasen ɲeeɲal maa waylitii leɲol ngol sanne. ");
INSERT INTO ffm_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ɗum fuu saabe maa min keɓiri tatteeji fuu, min njettii ma sanne. ");
INSERT INTO ffm_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mi yiɗaa joonnde ndee juuta, kaa miɗo ndaarde saabe moƴƴuki maa, kettinano-ɗaa min seeɗa. ");
INSERT INTO ffm_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Min tawii oo ɗoo gorko yo bonɗo sanne, gaddoowo fitina hakkunde Yahuudiyankooɓe wonɓe e aduna oo ɓee fuu. O hooreejo diina Nasaraatunkooɓe oo. ");
INSERT INTO ffm_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","O naatii e soɓinde Suudu Dewal Mawndu nduu, ɗum nee min nanngii mo.  ");
INSERT INTO ffm_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Aan e hoore maa, lamndo-ɗaa mo, paamaa ko min ngullanirii mo koo fuu. ");
INSERT INTO ffm_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Yahuudiyankooɓe tawdaaɓe e makko ɓee mbii non jaati worri. ");
INSERT INTO ffm_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Nde goforneer oo hokkunoo Pool haala ndee, jaabii: —Miɗo anndi waɗii duuɓi aɗa sara ngol leɲol. Ɗum waɗi so miɗo seyoroo liddi am ɗii. ");
INSERT INTO ffm_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ɓuraa balɗe sappo e ɗiɗi ko ngar-mi Urusaliima faa mi rewa Laamɗo. So a taykiima, aan e hoore maa, a tawan hono non worri. ");
INSERT INTO ffm_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Fay gooto tawaali kam miɗo hiitondira e neɗɗo naa miɗo jirkita jamaa, wanaa e ley Suudu Dewal Mawndu nduu, wanaa e ley cuuɗi baajorɗi, wanaa e ley ngalluure ndee. ");
INSERT INTO ffm_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ɓe mbaawaa tabintinde ko ɓe ngullanirii kam e muuɗum jooni koo. ");
INSERT INTO ffm_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Kaa miɗo jaɓi yeeso maa: miɗo rewri Laamɗo njaatiraaɓe meeɗen oo diina mo ɓe mbiyata diina peneejo oo. Miɗo goonɗini ko winndaa e Tawreeta Muusaa koo e ko winndaa e dewte annabaaɓe koo fuu. ");
INSERT INTO ffm_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Kasen duu miɗo fawi jikke am e Laamɗo mo ɓe pawi jikke maɓɓe e muuɗum kamɓe duu oo, o wuurtinan fooccitiiɓe e ɓe pooccitaaki fuu. ");
INSERT INTO ffm_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ɗum saabii so tiinnitii-mi yalla ana laatanoo kam hakkille baaltiiɗo ɲannde fuu ko waldaa e feloore yeeso Laamɗo e yeeso yimɓe. ");
INSERT INTO ffm_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Caggal duuɓi keewɗi, ngartu-mi faa mi waɗana yimɓe am dokke, mi itta sadakaaji. ");
INSERT INTO ffm_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","E ley majjum ɓe tawi kam e ley Suudu Dewal Mawndu nduu caggal mi sennaama, mi waldaa e jamaa, mi waldaa e dillere. ");
INSERT INTO ffm_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Yoga e Yahuudiyankooɓe leydi Asiya wonnooɓe ɗon, ɓeen kaannoo warde wullanaade kam yeeso maa, so tawii won ko ɓe ngullantoo kam. ");
INSERT INTO ffm_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Naa ɓee ɗoo, kaɲum e hoore mum'en kaala boofi ɗi njii e am nde ndarinoo-mi yeeso waalde Saahiiɓe ndee, ");
INSERT INTO ffm_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","so wanaa konngol gootol ngol ndarii-mi so ngullu-mi, mbii-mi: «Saabe immital maayɓe carirton kam hannde!» ");
INSERT INTO ffm_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Nde Filikus nannoo ɗum ndee, riiwti ɓe e dow no mo anndiri diina oo. O wii: —So Lisiyas hooreejo oo warii, mi saran haala mooɗon kaa. ");
INSERT INTO ffm_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","O yamiri mawɗo sordaasi'en oo hayba Pool, waɗana ɗum mosolaa, pati haɗa fay gooto e yiɓɓe muuɗum ɓee gollande ɗum naa warde e muuɗum. ");
INSERT INTO ffm_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Balɗe seeɗa caggal muuɗum, Filikus wardi e jom suudu muuɗum Yahuudiyanke biyeteeɗo Durusilla. O neli Pool waddoyee, o nanii ana haala haala goonɗinal Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kaa nde Pool haalannoo haala fooccitaare e nantaare e sariya garoowo ndee, Filikus huli, wii: —Jooni kaa, gasii, yaa! Nde keɓindii-mi fuu, mi nodditete. ");
INSERT INTO ffm_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","O miilii Pool hokkan mo kaalisi. Ɗum saabii so omo nodda ɗum cili keewɗi faa ɓe ngaajodoo. ");
INSERT INTO ffm_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Kaa nde ɗum heɓunoo duuɓi ɗiɗi ndee, Porsiyus Festus loomtii Filikus, laatii kaananke. Nde wonnoo Filikus ana yiɗi seynude Yahuudiyankooɓe ɓee, yoppi Pool e ley kasu oo. ");
INSERT INTO ffm_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Balɗe tati caggal ko Festus wari e ley leydi ndii koo, iwi Kaysariya, yehi Urusaliima. ");
INSERT INTO ffm_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ɗon, hooreeɓe yottinooɓe sadaka e mawɓe Yahuudiyankooɓe ngari to makko ngullitanii Pool. Ɓe ndaardi mo soobee ");
INSERT INTO ffm_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","o hokka ɓe Pool, ɓe ngadda ɗum Urusaliima, sabi eɓe tewta no ɓe njanira mo, ɓe mbara mo. ");
INSERT INTO ffm_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus wii Pool ana uddii kasu Kaysariya too, kanko e hoore makko o birfitotooɗo ton law. ");
INSERT INTO ffm_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","O wii: —Mawɓe mooɗon ngara njaada e am Kaysariya, ngullanoo gorko oo so tawii won ko waɗi. ");
INSERT INTO ffm_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus faɓɓidaali e maɓɓe ko ɓuri balɗe jetti naa sappo, caggal ɗum, o regii o feewi Kaysariya. Janngo mum, o jooɗoyii to sarirde too, o yamiri Pool waddee. ");
INSERT INTO ffm_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Nde Pool yottii ndee, Yahuudiyankooɓe iwɓe Urusaliima ɓee pilii ɗum, kappi ɗum kuɗɗe bonɗe keewɗe, ɗe ngalaa daliili. ");
INSERT INTO ffm_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pool jaabii, ana wiya: —Mi meeɗaali tooɲude, wanaa sariya Yahuudiyankooɓe oo, wanaa Suudu Dewal Mawndu nduu, wanaa kaananke Roma mawɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nde wonnoo Festus ana yiɗi seynude Yahuudiyankooɓe ɓee, lamndii Pool, wii: —Aɗa jaɓa yaade Urusaliima faa miin e hoore am mi saroya ton kabaaru maa oo naa? ");
INSERT INTO ffm_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pool wii: —E sarirde kaananke Roma mawɗo ngon-mi, ɗo kaan-mi sareede ɗoo. Mi tooɲaali Yahuudiyankooɓe ɓee, no aan e hoore maa anndir-ɗaa ɗum nii. ");
INSERT INTO ffm_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","So tawii miin tooɲi, mi waɗii ko foti warde kam, mi salataako wareede. Kaa so fay huunde e ko ɓe kappi kam koo wanaa goonga, fay gooto waawaa wattude kam e juuɗe maɓɓe. Sariya am ɓettinee, yaha to kaananke Roma mawɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Caggal nde Festus haaldi e howruuɓe muuɗum, jaabii, wii: —Sariya maa ɓettinee to kaananke Roma mawɗo njiɗ-ɗaa, ɗum nee, a ɓettinte yaade to kaananke Roma mawɗo! ");
INSERT INTO ffm_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Balɗe seeɗa caggal muuɗum, Agirippa kaananke oo e Barniki ngari Kaysariya jowtude Festus. ");
INSERT INTO ffm_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Nde ɓe paɓɓunoo ɗon balɗe seeɗa ndee, Festus haalani kaananke oo haala Pool, wii: —Won gorko mo Filikus yoppi ɗoo e kasu. ");
INSERT INTO ffm_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Nde njaa-mi Urusaliima ndee, hooreeɓe yottinooɓe sadaka e mawɓe Yahuudiyankooɓe kaalanii kam haala makko, ɲaagiima mi sara mo. ");
INSERT INTO ffm_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Njaabii-mi ɓe: Romankooɓe neesoraaki sarde neɗɗo tawee jooddaaki e happuɓe ɗum ɓee, jaaboo ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Nde ɓe mooɓtinoo so ɓe ngari ɗoo ndee, miin nee, mi neemtinaali fay huunde. Janngo mum, njooɗoyii-mi to sarirde too, njamir-mi gorko oo waddee. ");
INSERT INTO ffm_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Nde wullaniiɓe mo ɓee ndarii bannge makko ndee, ngaddaali fay feloore wootere e ko miilannoo-mi koo. ");
INSERT INTO ffm_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ɓe ngaddi e makko haalaaji banngal diina maɓɓe, kaɲum e gooto biyeteeɗo Iisaa maayɗo, mo Pool wiyata ana wuuri oo. ");
INSERT INTO ffm_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Miin nii, haala wa'uka nii ana wemmbi kam, ɗum waɗi so lamndi-moo-mi yalla omo jaɓa saroyeede Urusaliima naa? ");
INSERT INTO ffm_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kaa o ɲaagiima kabaaru makko wattee e juuɗe kaananke mawɗo oo, ndennoo njamir-mi o haybee ɗoo faa mi heɓa neldude mo kaananke Roma mawɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agirippa wii Festus: —Miɗo yiɗi hettinaade oo gorko, miin e hoore am. Festus wii: —A hettinto mo janngo. ");
INSERT INTO ffm_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Janngo mum, Agirippa e Barniki ngardi e fuukinaare mawnde, naati e ley sarirdu nduu, kamɓe e hooreeɓe sordaasi'en ɓee e mawɓe ngalluure ndee. Festus yamiri Pool waddee. ");
INSERT INTO ffm_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus wii: —Agirippa kaananke e deental tawaaɓe ɗoo! On njii oo gorko. Yahuudiyankooɓe fuu ngullanike mo ga am ley Urusaliima e ɗoo fuu, eɓe ngulla eɓe mbiya o haanaa yoppeede o wuura. ");
INSERT INTO ffm_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Miin e hoore am, mi tawii o waɗaali fay huunde ko haani warde mo. Kaa nde wonnoo kanko e hoore makko o ɲaagiima sariya makko ɓettinee, naɓee to kaananke Roma mawɗo oo, mi fellisii neldude mo ton. ");
INSERT INTO ffm_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mi walaa taƴoral fuu e makko ko kaan-mi winndude e kaananke oo. Ɗum waɗi so ndarnu-moo-mi yeeso mooɗon on fuu, faa ɗum teeŋa e maa, aan Agirippa kaananke oo, yalla so en kettinike haala makko, miɗo heɓa ko mi winnda. ");
INSERT INTO ffm_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Sabi ɗum gasataa no kasunke neldirtee kaananke mawɗo oo tawee ko nanngiraa koo hollitaaka faa laaɓa. ");
INSERT INTO ffm_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agirippa wii Pool: —A hokkaama haala, haal haala maa. Nden, Pool hunci junngo, jaabii, wii: ");
INSERT INTO ffm_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","—Agirippa kaananke, mi seyorike hujjaade yeeso maa hannde ko Yahuudiyankooɓe ngullanirii kam koo fuu. ");
INSERT INTO ffm_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Sabi aɗa anndi neesuuji Yahuudiyankooɓe e haalaaji muuɗum'en fuu. Saabe majjum miɗo ɲaage, muɲaa, kettinano-ɗaa kam. ");
INSERT INTO ffm_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Yahuudiyankooɓe fuu ana anndi no nguurdu-mi gila mi cukalel tusukel. Eɓe anndi no ngorrunoo-mi e ley suudu baaba am e ley Urusaliima fuu. ");
INSERT INTO ffm_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Eɓe anndi gila arannde, so ɓe njaɓii seettaade: miɗo jokki laawol diina amen ɓurngol tiiɗude ngol, miɗo hiisodaa e Farisa'en. ");
INSERT INTO ffm_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Jooni, mi darike faa mi saree saabe mi fawii jikke am dow fodoore nde Laamɗo waɗani njaatiraaɓe meeɗen ndee. ");
INSERT INTO ffm_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Leɲi meeɗen sappo e ɗiɗi ɗii ana pawi jikke muuɗum e tabital fodoore ndee, ana ndewira soobee jemma e ɲalooma. Kaananke, saabe oo jikke Yahuudiyankooɓe ngullanorii kam! ");
INSERT INTO ffm_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ko saabii so onon Yahuudiyankooɓe miil-ɗon Laamɗo waawaa immitinde maayɓe? ");
INSERT INTO ffm_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Miin e hoore am, e ɓettaade mi taƴoriino miɗo haani bonnude innde Iisaa Nasaraatunke oo, no laatorii fuu. ");
INSERT INTO ffm_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Ɗum woni ko ngaɗu-mi Urusaliima. Hooreeɓe yottinooɓe sadaka ɓee njarraninoo kam mi udda seniiɓe heewɓe e kasu. Nde ɓe caranoo ɓe wareteeɓe ndee, miɗo yarrii ɗum. ");
INSERT INTO ffm_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Mi torrii ɓe cili keewɗi e cuuɗi baajorɗi ɗii fuu, mi tilsinii ɓe mbonkoo Joomiraaɗo. Torra am e maɓɓe ana mawnunoo sanne faa miɗo tawoyannoo ɓe ley geelle janane. ");
INSERT INTO ffm_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Hono non njaaru-mi Damas nde hooreeɓe yottinooɓe sadaka ɓee njarranii kam ndee. ");
INSERT INTO ffm_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Kaananke, miɗo e laawol wakkati hakkunde naange, njii-mi fooyre ana iwa dow kammu ana filoo kam, miin e yaaduɓe e am ɓee fuu. Fooyre ndee ana ɓuri naange jalbude. ");
INSERT INTO ffm_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Min fuu, min caami e leydi, nan-mi daande ana wiya kam e ley ibaraninkoore: «Sool, Sool, ko saabii so aɗa torra kam? So ndemoori wii saloto ko nannguɗo ginol mum waɗata fuu, ɓeydan naawnaade.» ");
INSERT INTO ffm_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Njaabii-mi, mbii-mi: «Aan homo, giɗo Laamɗo?» Joomiraaɗo wii: «Miin, Iisaa mo torru-ɗaa oo. ");
INSERT INTO ffm_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Imma dara, sabi mi ɓannganii ma mi suɓike ma faa ngollanaa kam, ceedano-ɗaa kam ley ko njii-ɗaa koo e ko anniyii-mi ɓannginanoyde ma caggal hannde. ");
INSERT INTO ffm_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mi reenete e Yahuudiyankooɓe e yimɓe leɲi goɗɗi, ɓe nelan-maa-mi e muuɗum jooni ɓee, ");
INSERT INTO ffm_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","yalla aɗa feerta gite maɓɓe, ɓe iwa e nimre, ɓe ngarta e fooyre, ɓe iwa e junngo Ibiliisa, ɓe ngarta e Laamɗo, ɓe keɓa yaafeede luutti, ɓe ndonida e sennaaɓe ɓee saabe ko ɓe goonɗini kam koo.» ");
INSERT INTO ffm_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Kaananke Agirippa, ɗum waɗi so mi salaaki ɗowtanaade ko njii-mi, ko iwrani kam dow kammu koo. ");
INSERT INTO ffm_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ɓe miɗo adoo waajaade fuu yo yimɓe Damas e yimɓe Urusaliima e piilol Yahuudiya fuu. Caggal ɗum, njokkin-mi hen yimɓe leɲi goɗɗi tuuba, ngarta e Laamɗo, ngolla golleeji kollitooji ɓe tuubii. ");
INSERT INTO ffm_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Saabe ɗum Yahuudiyankooɓe nanngiri kam ley Suudu Dewal Mawndu nduu, tewti warde kam. ");
INSERT INTO ffm_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kaa faa hannde, Laamɗo ana reeni kam. Miɗo seettanoo tedduɓe e lo'uɓe. Mi waajataako fay huunde so wanaa ko annabaaɓe e Sariya Muusaa kaali waroyan koo: ");
INSERT INTO ffm_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Almasiihu torroto, adoo maayɓe immitaade. Caggal ɗum, o waajoto fooyre, ko wanaa yimɓe meeɗen tan, o waajoto leɲi goɗɗi duu. ");
INSERT INTO ffm_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Nde Pool haalata ɗum ndee, Festus jahii jahaango manngo, wii: —Pool, a haanɗii! Heewgol maa anndal ngol haanɗinii ma! ");
INSERT INTO ffm_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pool jaabii, wii: —Tedduɗo, mi haanɗaali. Ko kaalan-mi koo yo haalaaji goonɗuɗi, jogiiɗi maanaa. ");
INSERT INTO ffm_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Agirippa kaananke oo ana anndi kuɗɗe ɗee. Ɗum waɗi so miɗo hoolii haalde ɗum yeeso makko. Sabi miɗo taƴori fay huunde ɲooɓanaali mo hen, sabi ɗum waɗaali e cuucuukka. ");
INSERT INTO ffm_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Kaananke! Aɗa goonɗini annabaaɓe naa? Miɗo anndi aɗa goonɗini! ");
INSERT INTO ffm_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agirippa wii Pool: —Seeɗa tan haɗete waɗude kam neɗɗo Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pool jaabii, wii: —Yaawi taaɗi fuu, mi ɲaagoto Laamɗo faa aan e hettintooɓe kam jooni ɓee fuu laato-ɗon ko ngon-mi koo, tawee ɓoggol e calali ngalaa e mon. ");
INSERT INTO ffm_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kaananke oo e goforneer oo e Barniki e jooddinooɓe e muuɗum'en ɓee fuu immii. ");
INSERT INTO ffm_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Nde ɓe njalti suudu nduu ndee, eɓe mbiyondira: —O waɗaali ko haani warde mo naa ko haani uddude mo kasu. ");
INSERT INTO ffm_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agirippa wii Festus: —Omo waawnoo yoppiteede so o wiyaalino sariya makko ɓettinee naɓee to kaananke Roma mawɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nde yaarugol amen Italiya laana tabitinnoo ndee, Pool e kasunkooɓe woɓɓe ngaɗaa e junngo mawɗo sordaasi'en biyeteeɗo Yuliyus, jeyaaɗo e fedde sordaasi'en kaananke Roma mawɗo oo. ");
INSERT INTO ffm_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Min naati laana geeci iwka Adaramatiya njahoowa so ana faŋa ley leydi Asiya, min ndeerti. Miɗen ngondi e Aristarka gorko Makedoniyanke iwoowo Tesaloniiki. ");
INSERT INTO ffm_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Janngo mum, min njottii Sidon. Yuliyus waɗani Pool mosolaa, duŋanii ɗum yaha to yiɓɓe mum yalla ana paaboroo ɗum ko hasindini e mum. ");
INSERT INTO ffm_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nde min iwi ɗon ndee, min ɓattitii fonngo ruunde Kiprus, sabi e henndu min peewtunoo. ");
INSERT INTO ffm_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Min lummbiri maayo geeci ngoo hedde Silisi e Pamfiliya, min njottii Mira ley leydi Lisiya. ");
INSERT INTO ffm_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Ɗon, mawɗo sordaasi'en oo heɓani min laana iwka Aleksandiri ana fa'i Italiya, naanni min hen. ");
INSERT INTO ffm_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Balɗe kuurɗe laana amen kaa waɗi ana yaara seese. Semmbe e doole min njottorii daŋŋeere Kinidus. Nde wonnoo henndu nduu haɗii min yawtude ndee, min lummbiri Salmone. Gila ɗon min takkii e fonngo ruunde Kereta. ");
INSERT INTO ffm_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nde min ƴaɓɓorinoo ɗon semmbe e doole ndee, min ngari e nokku biyeteeɗo Hoɗorde Lobbere nde woɗɗaa e ngeenndi Lasiya. ");
INSERT INTO ffm_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nde wonnoo min paɓɓii sanne ndee, dawirde laana geeci hulɓiniima sabi ɲannde hooreteende ɓettike, jaangol ngol duu fuɗɗii. Pool ana jeertina ɓe, ");
INSERT INTO ffm_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","ana wiya: —Sakiraaɓe, mi yii ngol ɗoo dawol yo keewoowol kunkooji e mursee, wanaa laana kaa e kaaki ɗii tan, ana waawi laataade yonkiiji men duu. ");
INSERT INTO ffm_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Kaa mawɗo sordaasi'en oo, haala mawɗo laana oo kaɲum e joomiika ɓuri hoolaade, diina ko Pool haali koo. ");
INSERT INTO ffm_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Daŋŋeere nde ɓe ngoni e muuɗum ndee, welaa dabbunde, ɗum waɗi so ɓurɓe heewde e wonɓe e laana ɓee mbii ɓe njaha ɓe tewta yottaade Feniksa, daŋŋeere Kereta fewtunde e soɓɓundu hiirnaange ɓaleeri e soɓɓundu hiirnaange saahal, yalla eɓe ndabba ton. ");
INSERT INTO ffm_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Nde henndu iwrundu ɓaleeri fuɗɗi mooyde ndee, ɓe cikki ɓe mbaawan yottinde faandaare maɓɓe ndee. Ɓe ŋabbini torooje ɗee, ɓe takkii e fonngo Kereta, ɓe mbirfitii. ");
INSERT INTO ffm_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kaa caggal ɗum seeɗa, henndu mawndu wiyeteendu henndu funnaange saahal iwri to ruunde too, jippii. ");
INSERT INTO ffm_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Laana kaa hayti, min ndonki haɗude henndu nduu naɓude ka. Ɗum waɗi so min acci ka doya. ");
INSERT INTO ffm_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Nde min ɓettotoo duungel tusukel biyeteengel Kawda ndee, duungel ngel huuri min seeɗa e henndu, min cippiri ɗon e laanawel tusukel ngel, min kewti ngel. ");
INSERT INTO ffm_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Nde ɓe ɓamtunoo ngel ndee, ɓe ɓami ɓoggi, ɓe cacci e laana mawka kaa. Ko ɓe kuli pati ɓe njanoy e soɓɓundu Sirta koo, ɓe jippini wiir oo, ɓe njoppi eka doya. ");
INSERT INTO ffm_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Henndu nduu wibbi semmbe. Ɗum waɗi so janngo mum ɓe puɗɗi tippaade donngal laana kaa. ");
INSERT INTO ffm_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","E ɲalooma tataɓo oo, ɓe mbedorii juuɗe maɓɓe kaaki laana ɗii. ");
INSERT INTO ffm_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Balɗe kuurɗe naange e koode fuu njiyataake. No henndu nduu foti mawnude, min taƴi jikke amen fuu e hisude. ");
INSERT INTO ffm_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nde wonnoo yimɓe ɓee paɓɓii keɓaali ko ɲaama, Pool darii hakkunde maɓɓe, wii: —So on njaɓiino haala am on iwaalino Kereta, ɗii kunkooji e oo mursee hewtataakono en. ");
INSERT INTO ffm_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Jooni, miɗo haalana on: ceyee, sabi fay gooto e mooɗon yonki muuɗum mursataake, laana kaa tan mursetee. ");
INSERT INTO ffm_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Jemma hanken, malaa'ika iwrii to Laamɗo mo ndewan-mi oo warii e am, ");
INSERT INTO ffm_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","wii kam: «Pool, pati hul, a daroto yeeso kaananke Roma mawɗo oo, Laamɗo reenete aan e dawduɓe e maa ɓee fuu.» ");
INSERT INTO ffm_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Ndennoo, tiinnee, sabi miɗo hoolii ko Laamɗo haalani kam koo, hono non jaati worrata, ");
INSERT INTO ffm_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","kaa waajibi en njanoyan e ruunde. ");
INSERT INTO ffm_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","E ley jemma sappo e nayaɓo oo, nde min ndoydata e geeci Adiriyatiki ndee, wakkati hejjere jemma donnooɓe laana kaa ɓee cikki ɓadike fanndude. ");
INSERT INTO ffm_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Ɓe tippii ɓoggol kaɓɓaangol ko teddi, ɓe tawi luggeendi ndii yo hakke darɗe noogay. Ɓe njehi yeeso seeɗa, ɓe tippii kasen, ɓe tawi luggeendi ndii yo hakke darɗe sappo e joy. ");
INSERT INTO ffm_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ko ɓe kuli pati ɓe njanoy e kaaƴe koo, ɓe njippini torooje nay caggal laana kaa, eɓe ndoomi beetee. ");
INSERT INTO ffm_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Nde wonnoo donnooɓe laana kaa ɓee ana njiɗunoo soɓɓitaade, ɓe njippini laanawel pamarel ngel e ndiyam, ɓe mbii eɓe ɲiɓoya torooje to yeeso laana kaa too. ");
INSERT INTO ffm_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Pool wii mawɗo oo e sordaasi'en ɓee: —So yimɓe ɓee keddaaki e ley laana kaa, onon, on ndaɗataa. ");
INSERT INTO ffm_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Nden sordaasi'en ɓee taƴi ɓoggi nanngunooɗi laanawel pamarel ngel ɗii, njoppi ngel doyi. ");
INSERT INTO ffm_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Nde ɓadinoo weetude ndee, Pool ndaardi ɓe fuu ɓe ɲaama, wii: —Hannde woni balɗe sappo e nay oɗon kettii on ɲaamaali fay huunde. ");
INSERT INTO ffm_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Ɗum waɗi so miɗo ndaarda on ɲaamon, yalla oɗon ndaɗa, sabi fay gooto e mooɗon leeɓol hoore muuɗum solataa so saama. ");
INSERT INTO ffm_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Nde o haalnoo ɗum ndee, o ɓami buuru, o yetti Laamɗo yeeso maɓɓe ɓe fuu, o helti, o fuɗɗi ɲaamde. ");
INSERT INTO ffm_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Nden ɓe fuu ɓe ceyii, kamɓe duu ɓe ɓami ɓe ɲaami. ");
INSERT INTO ffm_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Minen wonɓe ley laana kaa ɓee, min yimɓe teemeɗe ɗiɗon e capanɗe njeɗɗon e njeegom. ");
INSERT INTO ffm_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Nde ɓe ɲaamnoo faa ɓe kaari ndee, ɓe ɓami caakuuji alkama gonɗi e laana kaa ɗii, ɓe tippii ɗi ley geeci yalla eɗum hoyfina ka. ");
INSERT INTO ffm_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Nde weetunoo ndee, ɓe coynii leydi, kaa ɓe annditaali ndi. Ɓe njii soɓɓundu e fonngo muuɗum. Ɓe kawri ɓe naɓan ton laana kaa so ɓe mbaawii. ");
INSERT INTO ffm_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Ɓe taƴi torooje ɗee, ɓe njoppi ɗe ley ndiyam ɗam, ɓe njorŋini ɓoggi kummbeeje gurfirɗe ɗee. Caggal ɗum, ɓe piilti wiir oo, ɓe ŋabbini ɗum to hoore laana too, yalla henndu nduu ana dunƴira ka yeeso. Ɓe peewi fonngo ngoo. ");
INSERT INTO ffm_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ɓe porri e siwre, laana kaa higgi. Becce makka ɲiɓii e ley njaareendi ndii faa ka ronki dillinaade, bempeeje keli laaci makka. ");
INSERT INTO ffm_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sordaasi'en ɓee anniyii warde kasunkooɓe ɓee pati fay gooto e maɓɓe yinoo so doga. ");
INSERT INTO ffm_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Kaa nde wonnoo mawɗo sordaasi'en oo ana yiɗi danndude Pool, haɗi ɓe waɗude anniya maɓɓe oo, yamiri waawɓe yinaade ɓee adoo fiyaade e ndiyam ƴeentoya, ");
INSERT INTO ffm_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","heddiiɓe ɓee, yoga muuɗum'en nanngi bamuuje laana kaa, yoga nanngi taƴe makka. Hono nii ɓe fuu ɓe njottorii njoorndi e jam. ");
INSERT INTO ffm_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nde min ndaɗi ndee, min nani ruunde ndee Malta wiyetee. ");
INSERT INTO ffm_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Hoɗuɓe ɗon ɓee njaɓɓorii min caahu mawɗo. Nde wonnoo oon wakkati kammu ana toɓa jaangol ana woodi, ɓe kuɓɓi yiite, ɓe njaɓɓii min faa min ƴuwloo. ");
INSERT INTO ffm_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pool mooɓi leɗɗe, wedii e yiite ngee. Nguleefi kii yaltini e majje mboddi, ndi soppi junngo makko. ");
INSERT INTO ffm_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nde hoɗuɓe ɗon ɓee njii mboddi ndii ana weelta e junngo Pool ndee, mbiyondiri e ko'e muuɗum'en: —Taƴoral oo gorko yo barɗo hoore, taweede o daɗii to geeci too fuu, hakkeeji makko ɗii accataa mo wuura. ");
INSERT INTO ffm_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","O ficci mboddi ndii e yiite ngee, ɗum torraali mo fay huunde. ");
INSERT INTO ffm_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Ɓe miili o ɓuutan naa o saama ɗon e ɗon o maaya. Kaa nde ɓe kettinoo faa ɓooyi ndee, ɓe njii ɗum torriraali mo fay huunde, hakkillaaji maɓɓe mbaylitii e makko, ɓe mbii o gooto e laamɗo'en ɓee. ");
INSERT INTO ffm_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Publiyus, hooreejo ruunde ndee oo, ngesa muuɗum ana e sera nokkuure ndee. O jaɓɓiima min faa gasi, o jippini min, o saahii e amen, min ngaɗi to makko balɗe tati. ");
INSERT INTO ffm_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Hawri baaba Publiyus ana lelii sellaa, jontaaɗo, reedu muuɗum ana doga ƴiiƴam. Pool yehi to makko, duwii, fawi juuɗe muuɗum e makko, sellini mo. ");
INSERT INTO ffm_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nde ɗum waɗunoo ndee, ɲawɓe wonɓe e ruunde ndee ɓee ngari, cellinaa. ");
INSERT INTO ffm_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Ɓe teddini min teddeengal manngal. Nde min njahata ndee, ɓe njooɓini min ko min kasindini e mum fuu. ");
INSERT INTO ffm_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Caggal lebbi tati, min naati e laana iwka Aleksandiri, ndabbunooka e ruunde ndee kaa, min mbitti. Eka ɲeɲaa ɲeɲugol Tooruuji Puneeji. ");
INSERT INTO ffm_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Min njottii ngeenndi mbiyeteendi Sirakusa, min ngaɗi ɗon balɗe tati. ");
INSERT INTO ffm_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Min naati ɗon, min takkii e fonngo geeci faa Regiyus. Janngo mum, henndu ɓaleeri wifi. E ley balɗe ɗiɗi min njottii Potiyoli. ");
INSERT INTO ffm_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Min tawi ton sakiraaɓe, ndaardi min paɓɓana ɗum'en yontere. Hono nii min njottorii Roma. ");
INSERT INTO ffm_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nde wonnoo sakiraaɓe wonɓe Roma ɓee nanii garol amen, ngarii faa sakoro Abiya e nokku biyeteeɗo Jippule Tati sakkitaade min. Nde Pool yiinoo ɓe ndee, yetti Laamɗo, ɓeydorii cuusal. ");
INSERT INTO ffm_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nde min njottii Roma ndee, Pool duŋanaa jippoo feere muuɗum, kaɲum e sordaasi kayboowo ɗum oo. ");
INSERT INTO ffm_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Balɗe tati caggal muuɗum, Pool noddi mawɓe Yahuudiyankooɓe. Nde ɓe mooɓtinoo ndee, o wii ɓe: —Sakiraaɓe! Mi waɗaali fay huunde ko luuttondirta kam e yimɓe meeɗen ɓee naa aadaaji njaatiraaɓe meeɗen ɗii, kaa mi nanngaama Urusaliima, mi wattaama e juuɗe Romankooɓe. ");
INSERT INTO ffm_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Nde ɓeen ƴeewi kabaaru am ndee, njiɗiino yoppude kam, sabi ɓe tawaali e am fay daliili gooto kaanɗo warde kam. ");
INSERT INTO ffm_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Kaa kammari Yahuudiyankooɓe ɓee caliima mi yoppitee, ɗum waddani kam ɲaagaade sariya am ɓettinee naɓee to kaananke Roma mawɗo oo, tawee mi happaali leɲol am ngol fay huunde. ");
INSERT INTO ffm_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Ɗum waɗi so noddu-mi on yalla miɗo yiya on mi haalana on. Miɗo haɓɓorii ɗii calali saabe mo Israa'iilankooɓe pawi jikke e muuɗum oo. ");
INSERT INTO ffm_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Ɓe mbii mo: —Min keɓaali ɓataaki iwɗo Yahuudiya kaaloowo haala maa. Kasen duu fay gooto e sakiraaɓe ɓee waraali humpita min naa haala ko boni ko ngaɗ-ɗaa. ");
INSERT INTO ffm_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kaa miɗen njiɗi kaalanaa min ko njii-ɗaa e hakkille maa, sabi miɗen anndi diina mo njokku-ɗaa oo ana luurraa ley nokkuuje ɗee fuu. ");
INSERT INTO ffm_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Ɓe cartanii mo nde ɓe ngartata. Ɲalaande ndee yottii, heewɓe ngari kawriti to jippunde makko too. Gila beetee kecco faa caggal kiraaɗe omo waajoo ɓe, omo fammina ɓe haala Laamu Laamɗo. Omo dallinoroo Tawreeta Muusaa e dewte annabaaɓe haala Iisaa. ");
INSERT INTO ffm_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Yoga e maɓɓe jaɓi ko o haali koo, yogaaɓe njaɓaali. ");
INSERT INTO ffm_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Nde ɓe caakotoo, tawi ɓe nganaa hawruɓe ndee, Pool ɓeydi hen konngol gootol, wii: —Ruuhu Ceniiɗo haalii goonga nde yottiniri haala annabi Esaaya, nde oon wii njaatiraaɓe mooɗon: ");
INSERT INTO ffm_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","«Yaa to ngol leɲol mbiyaa ɗum: On kettinto faa palon noppi, kaa on paamataa. On ƴeewan faa puttinon gite, kaa on njiyataa. ");
INSERT INTO ffm_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Sabi ngol leɲol ɓernde mum yoorii. Ɓe cukkii noppi maɓɓe, ɓe mbumnii gite maɓɓe, pati gite maɓɓe njiya, pati noppi maɓɓe nana, pati hakkillaaji maɓɓe paama, sako ɓe ngarta mi sellina ɓe.» ");
INSERT INTO ffm_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pool jokkini hen, wii: —Anndee, kisindam Laamɗo neldaama ɓe nganaa Yahuudiyankooɓe. Kamɓe ɓe kettinto!  ");
INSERT INTO ffm_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pool waɗii duuɓi ɗiɗi kiɓɓi e ley suudu hasunoo nduu. Ɗon o silminannoo warannooɓe ƴeewde mo ɓee fuu, ");
INSERT INTO ffm_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","omo waajoo Laamu Laamɗo, omo jannginira cuusal kabaaru Iisaa Almasiihu Joomiraaɗo oo, walaa kaɗuɗo mo.");
INSERT INTO ffm_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Oo ɓataaki ga am iwri, miin Pool. Mi maccuɗo Iisaa Almasiihu, mi noddaaɗo faa mi laatoo nelaaɗo mum, mi cuɓaaɗo faa mi yottina Kabaaru Laamɗo Lobbo oo. ");
INSERT INTO ffm_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Oon Kabaaru Lobbo, Laamɗo fodiriino mo gila arannde annabaaɓe mum e ley Binndi ceniiɗi ɗii. ");
INSERT INTO ffm_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Kabaaru oo haala Ɓiyiiko haalata, iwɗo e Daawuuda banngal ɓii-aadamaaku mum, ");
INSERT INTO ffm_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","banngal Ruuhu Ceniiɗo oo holliraa mo Ɓii Laamɗo Jom Baawɗe ko o immitii e maayde koo. Kanko woni Joomiraaɗo men Iisaa Almasiihu, ");
INSERT INTO ffm_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","saabe makko keɓir-mi moƴƴere laataade nelaaɗo faa goonɗinɓe ɗowtaniiɓe mo keɓee ley leɲi ɗii fuu, yalla innde makko ndee ana teddinee. ");
INSERT INTO ffm_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Onon wonɓe Roma ɓee duu, oɗon njeyaa e maɓɓe, onon ɓe Laamɗo noddi faa kaɓɓo-ɗon e Iisaa Almasiihu ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Miɗo jowta on fuu, onon ɓe Laamɗo horsini, onon ɓe Laamɗo noddi faa laato-ɗon seniiɓe. Yo on keɓu moƴƴere e jam iwde e Baabiraaɗo men Laamɗo e Joomiraaɗo men Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Ko adii fuu, miɗo yetta Laamɗo e innde Iisaa Almasiihu saabe mooɗon on fuu, sabi haala goonɗinal mon haalaama e aduna oo fuu. ");
INSERT INTO ffm_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Laamɗo mo ndewiran-mi ɓernde laaɓunde e ley ko njottinan-mi Kabaaru Lobbo haala Ɓiyiiko oo koo, o seede miɗo miccitoo on wakkati fuu ");
INSERT INTO ffm_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","e ley duwaawuuji am fuu. Miɗo ɲaagoo Laamɗo newnana kam laawol e ley muuyɗe muuɗum no mi warda to mon. ");
INSERT INTO ffm_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Sabi miɗo yiɗi yiide on sanne, yalla ana daɲa ko njottin-mi on e dokkal ngal Ruuhu hokkata ngal faa ɲiiɓina on. ");
INSERT INTO ffm_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Mi ɓeyda hen: yalla goonɗinal ngal ndeentu-ɗen e mum ngal ana hokka en fuu semmbe. ");
INSERT INTO ffm_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Sakiraaɓe, miɗo yiɗi anndon: cili kuurɗi ngaɗu-mi anniya mi waran to mon, yalla ana daɲa ɓe keɓu-mi hakkunde mon no keɓir-mi yimɓe hakkunde leɲi goɗɗi ɗii nii, kaa faa jooni mi heɓaali warde. ");
INSERT INTO ffm_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Waajibi mi yaha to yimɓe fuu, jooɗiiɓe e ferɓe, jannguɓe e ɓe njanngaali. ");
INSERT INTO ffm_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ɗum saabanii kam yiɗude yottinde on, onon Romankooɓe ɓee duu Kabaaru Lobbo haala Almasiihu oo. ");
INSERT INTO ffm_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mi yaagortaako Kabaaru Lobbo oo, sabi o baawɗe Laamɗo, omo waawi hisinde goonɗinɗo mo fuu: Yahuudiyankooɓe tafon, caggal ɗum, leɲi goɗɗi ɗii duu. ");
INSERT INTO ffm_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Sabi Kabaaru Lobbo oo ɓannginta no Laamɗo nanngirta neɗɗo pooccitiiɗo yeeso mum – goonɗinal tan waɗata ɗum, iwde e fuɗɗoode yaade e timmoode, no Binndi ɗii mbiiri nii: «Pooccitiiɗo wuurdan goonɗinal.» ");
INSERT INTO ffm_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Tikkere Laamɗo ana ɓannga iwde dow kammu ana jippoo e yedduɓe e ooɲiiɓe fuu ɓe ooɲaare mum'en ɗeɗɗata goonga oo ɓee, ");
INSERT INTO ffm_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","sabi ko neɗɗo waawi anndude e Laamɗo koo ana laaɓani ɓe, Laamɗo jaati ɓannginanii ɓe ɗum. ");
INSERT INTO ffm_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Sabi gila Laamɗo tagi aduna oo faa hannde, golle mum ana ɓanngina sifa mum mo yiyataake oo faa laaɓa, ɗum woni baawɗe makko faa abada ɗee e allankaaku makko oo. Saabe ɗum, yedduɓe mo ɓee ngalaa daɗirgal fey. ");
INSERT INTO ffm_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Fay so taweede eɓe anndi Laamɗo, ɓe teddiniraali ɗum no foti teddinireede nii, ɓe njettaali mo duu. Miilooji maɓɓe ɗii laatike ɓoli, fay ko ɓe anndi seeɗa koo duu niɓɓii. ");
INSERT INTO ffm_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Eɓe njaara ɓe hakkilante'en, kaa ɓe kaanɗii. ");
INSERT INTO ffm_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ɓe loomtinirii teddeengal Laamɗo duumiiɗo oo tooruuji nannduɗi e yimɓe maayooɓe e pooli e daabaaji ɗi koyɗe nay e ɓoggi leydi. ");
INSERT INTO ffm_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Saabe ɗum, Laamɗo ɗaldi ɓe e coɓe no yonkiiji maɓɓe ɗii njiɗiri nii faa ɓe koyni terɗe maɓɓe, kamɓe e ko'e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Ɓe loomtinirii Laamɗo goongaraajo oo fenaande, ɓe teddinii ko tagaa ɓe ndewii ɗum, ɓe njoppii Taguɗo oo. Yo jettooje ngoodan mo faa abada! Aamiina. ");
INSERT INTO ffm_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Saabe ɗum, Laamɗo ɗaldi ɓe e giɗaaɗe yonki maɓɓe kersiniiɗe. Rewɓe maɓɓe ɓee njoppii lelɗe worɓe mum'en ɗee, ndeentii e rewɓe hono mum'en faa woortondiri e no Laamɗo muuyrunoo ɗum nii. ");
INSERT INTO ffm_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Hono non worɓe ɓee duu njoppi waaldude e rewɓe faa ngatti muuyondirde. Worɓe ana ngaɗondira ko hersinii. Ɓe njukkaama kamɓe e ko'e maɓɓe jaati hakke majjere maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Saabe ko ɓe miijinoo anndude Laamɗo walaa ko nafata koo, Laamɗo ɗaldi ɓe e majjere maɓɓe, faa ɓe ngaɗi ko neɗɗo haanaa waɗude. ");
INSERT INTO ffm_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ɓe ooɲiiɓe, ɓe ɓaleeɓe yonki, eɓe keewi joote e comndam fuu, kaɲum e haasidaaku e war-hoore e pooɗondiral e jammba e anniya bonɗo. Ɓe ɲo'ooɓe yimɓe, ");
INSERT INTO ffm_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ɓe ɲiŋooɓe yimɓe, ɓe waɲuɓe Laamɗo, ɓe hoynooɓe yimɓe, ɓe mawninkiniiɓe, ɓe mantotooɓe, ɓe seeɓanɓe ko boni, ɓe murtirɓe saaraaɓe maɓɓe, ");
INSERT INTO ffm_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","ɓe ngalaa hakkille, ɓe nganaa hoolniiɓe, ɓe yoorɓe ɓerɗe, ɓe ngalaa yurmeende. ");
INSERT INTO ffm_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Fay so taweede eɓe anndi Laamɗo yamirii gaɗoowo hono ɗee kulle fuu ana haandi e maayde, ɓe kaaɗataa e waɗude ɗe tan, eɓe njaɓani duu gaɗoowo ɗe fuu. ");
INSERT INTO ffm_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ndennoo, aan peloowo woɓɓe oo, ko mbaaw-ɗaa laataade fuu a walaa daɗirgal. Sabi so a felii woɓɓe tawi golle mooɗon yo gooto, a liɓii hoore maa. ");
INSERT INTO ffm_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Eɗen anndi Laamɗo ana sarira gollirooɓe hono ɗii golleeji ɓee ko waarata e goonga oo. ");
INSERT INTO ffm_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Hey! Aan peloowo gollooɓe hono ɗii golleeji ɓee tawee hono non ngollirtaa, tama aɗa sikki a daɗan sarri jukkungo Laamɗo ngoo? ");
INSERT INTO ffm_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Naa a jawɗo moƴƴuki Laamɗo mawki kii, kaɲum e muɲal mum e sawraare mum? Tama a anndaa Laamɗo ana holle moƴƴuki mum yalla aɗa tuuba? ");
INSERT INTO ffm_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Kaa ko a joorɗo ɓernde a caliiɗo tuubude koo, aɗa waddana hoore maa tikkere Laamɗo ɲannde Laamɗo ɓannginta tikkere mum e sariya mum pooccitiiɗo oo. ");
INSERT INTO ffm_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Sabi Laamɗo barjoto gooto fuu golle mum. ");
INSERT INTO ffm_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Tewtooɓe darja e teddeengal e ko duumotoo, tewtirooɓe ɗum muɲal ley golle lobbo ɓee keɓan nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Kaa haasidi'en saliiɓe goonga so ana kaɓɓii e bonannda ɓee, jukkungo naawngo keɓata. ");
INSERT INTO ffm_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Torra e wemmbere ngoodanii gaɗoowo ko boni fuu: Yahuudiyankooɓe tafon, leɲi goɗɗi njokka hen. ");
INSERT INTO ffm_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Darja e teddeengal e jam ngoodanii gaɗoowo ko moƴƴi fuu, Yahuudiyankooɓe tafon, leɲi goɗɗi njokka hen. ");
INSERT INTO ffm_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Sabi Laamɗo ɓurdintaa yimɓe. ");
INSERT INTO ffm_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Laamɗo jukkan luuttooɓe ɓe nganaa Yahuudiyankooɓe, fay so ɓe anndaa Sariya Muusaa oo. Kasen duu luuttooɓe so tawi ana anndi Sariya Muusaa oo, carirte Sariya oo. ");
INSERT INTO ffm_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Neɗɗo nanngirtaake pooccitiiɗo yeeso Laamɗo e hettinaade Sariya tan, jokkude Sariya oo waɗata so nanngiree pooccitiiɗo. ");
INSERT INTO ffm_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Ɓe nganaa Yahuudiyankooɓe ɓee, kamɓe e waasude anndude Sariya Muusaa oo fuu, so ɓe ngaɗirii no Sariya Muusaa oo wiiri nii, ɓe kollii eɓe njogii sariya e ley hakkillaaji maɓɓe kamɓe e ko'e maɓɓe fay so ɓe ngalaa Sariya Muusaa oo. ");
INSERT INTO ffm_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Ɓe kollii ko Sariya Muusaa oo yamiri koo ana winndaa e ɓerɗe maɓɓe. Hakkillaaji maɓɓe ceediima ɗum, wakkatiiji eɓe anndi ley miilooji maɓɓe ɓe ngaɗii ko boni, wakkatiiji eɓe anndi ɓe ngaɗii ko moƴƴi. ");
INSERT INTO ffm_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ɗum woni ko ɓanngoyta ɲannde Laamɗo yamirta Iisaa Almasiihu sara ko suuɗii ley ɓerɗe koo, sarira ɗum no Kabaaru Lobbo mo mbaajotoo-mi oo wiiri nii. ");
INSERT INTO ffm_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Aan, so a wii a Yahuudiyanke, a tuugike Sariya Muusaa oo, a mantorike Laamɗo, ");
INSERT INTO ffm_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","aɗa anndi sago Laamɗo, a jannginaaɗo Sariya Muusaa oo faa mbaaw-ɗaa suɓaade ko moƴƴi, ");
INSERT INTO ffm_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","a taƴorii a ɗowoowo wumɓe, a fooyre wonɓe e nimre ɓee, ");
INSERT INTO ffm_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","aɗa waajoo ɓe njanngaali ɓee, aɗa janngina sukaaɓe saabe ko njogi-ɗaa anndal e goonga faa hiɓɓi e ley Sariya Muusaa oo koo – ");
INSERT INTO ffm_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","aɗa tinndina woɓɓe, ndennoo a tinndintaa hoore maa naa? Aɗa waajoo pati wujjee, a wujjataa naa? ");
INSERT INTO ffm_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Aɗa wiya pati jeenee, a jeenataa naa? Aɗa harmina tooruuji, a wujjataa ley to ɗi ndewetee too naa? ");
INSERT INTO ffm_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Aan mantortooɗo Sariya Muusaa oo, a luuttataa mo koynaa innde Laamɗo ndee naa? ");
INSERT INTO ffm_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Ɗum waɗi so Binndi ɗii mbii: «Onon ngaɗi so ɓe nganaa Yahuudiyankooɓe ɓee ana mbonkoo innde Laamɗo ndee.» ");
INSERT INTO ffm_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Sabi taadagol ana waawi nafude ma so aɗa haybi Sariya Muusaa oo, kaa so a yaaɓii Sariya Muusaa oo, a laatike hono mo taadaaki nii. ");
INSERT INTO ffm_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","So mo taadaaki haybii jamirooje Sariya Muusaa ɗee, yalla waasude taadaade makko hiisataake no o taadiiɗo nii naa? ");
INSERT INTO ffm_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Mo taadaaki kaybuɗo Sariya Muusaa oo ana sare aan luuttuɗo Sariya oo, fay so a taadiiɗo annduɗo Binndi ɗii. ");
INSERT INTO ffm_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Sabi wanaa ko yiyetee koo waɗata neɗɗo Yahuudiyanke jaati, wanaa ko golletee e terɗe koo woni taadagol. ");
INSERT INTO ffm_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ko yiyataake koo waɗata neɗɗo Yahuudiyanke jaati, taadagol duu ley ɓernde neɗɗo tawetee. E Ruuhu oo ɗum fawii, wanaa e binndi ɗii. Neɗɗo baaɗo non, wanaa yimɓe njettata ɗum, Laamɗo yettata ɗum. ");
INSERT INTO ffm_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ndennoo, koɗum Yahuudiyanke ɓurdi leɲi goɗɗi ɗii? Koɗum woni nafaa taadagol? ");
INSERT INTO ffm_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Nafaa taadagol ana heewi e alhaaliiji ɗii fuu. Ko adii fuu, Yahuudiyankooɓe kalfinaa konngol Laamɗo ngol. ");
INSERT INTO ffm_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Kaa so yoga maɓɓe nganaa hoolniiɓe, ɗum ana waawi bonnude ko Laamɗo yo koolniiɗo koo naa? ");
INSERT INTO ffm_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Waawaa! Fay so yimɓe fuu yo fenooɓe, Laamɗo kaa yo goongirante. Sabi nii winndorii: «Fooccitaare maa ana annditee e ko kaalataa koo, so a sardaama a liɓan.» ");
INSERT INTO ffm_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Ɗoo miɗo haalda no yimɓe nii: so ooɲaare men ana ɓeyda ɓannginde fooccitaare Laamɗo ndee, ɗum ana waɗa so mbiyen Laamɗo yo ooɲiiɗo so jippinii e men tikkere mum naa? ");
INSERT INTO ffm_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Fes! Sabi so Laamɗo yo ooɲiiɗo, hono o sarirta aduna oo? ");
INSERT INTO ffm_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","So tawii fenaande am ana ɓeyda ɓannginde goonga Laamɗo oo eɗum teddina mo, saabe koɗum carirtee-mi mi luuttoowo? ");
INSERT INTO ffm_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Won ɲo'ooɓe en wiyooɓe eɗen mbiya: «Ngaɗen ko boni yalla ko moƴƴi ana funta hen.» Ɓeen yimɓe, jukkungo mum'en ana foti e golleeji mum'en. ");
INSERT INTO ffm_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ndennoo, enen Yahuudiyankooɓe ɓee, eɗen ɓuri heddiiɓe ɓee naa? En ɓuraa. Sabi mi hollii Yahuudiyanke e mo wanaa Yahuudiyanke fuu e ley luutti ngoni, ");
INSERT INTO ffm_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","no Binndi ɗii mbiiri nii: «Walaa fuu pooccitiiɗo, fay gooto, ");
INSERT INTO ffm_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","fay gooto walaa faamu, fay gooto tewtataa Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Yimɓe fuu yo majjuɓe, fuu yo bonɓe, walaa fuu gaɗoowo ko moƴƴi, fay gooto.» ");
INSERT INTO ffm_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","«Kunduɗe maɓɓe ana mba'i no janaale udditiiɗe nii, ɗemɗe maɓɓe ana mbowla pene bonɗe. Toni maɓɓe ana caawi tooke posoke.» ");
INSERT INTO ffm_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","«Haala maɓɓe fuu yo kuddi e konngi mettuɗi.» ");
INSERT INTO ffm_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","«Koyɗe maɓɓe ana njaawani yuppude ƴiiƴam, ");
INSERT INTO ffm_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","bonannda e kunkoo ana jokki e maɓɓe to ɓe njahata fuu, ");
INSERT INTO ffm_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ɓe anndaa laawol jam.» ");
INSERT INTO ffm_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","«Kulol Laamɗo walaa e ɓerɗe maɓɓe fey.» ");
INSERT INTO ffm_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Eɗen anndi huunde fuu ko Sariya Muusaa oo wii, wonɓe e ley mum ɓee haaldi, yalla kunduɗe fuu ana muɓɓoo, yimɓe aduna fuu paama potii e jukkungo Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Sabi fay gooto nanngirtaake pooccitiiɗo yeeso Laamɗo saabe haybude mum Sariya Muusaa oo, sabi walaa ko Sariya Muusaa oo waawi so wanaa anndinde yimɓe ko woni luuttal. ");
INSERT INTO ffm_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Kaa jooni Laamɗo ɓannginii no nanngirta yimɓe fooccitiiɓe ko wanaa haybude mum'en Sariya Muusaa – no Sariya oo e dewte annabaaɓe ɗee ceedorii nii: ");
INSERT INTO ffm_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","o nanngiran goonɗinɓe ɓee fuu fooccitiiɓe saabe goonɗinal mum'en Iisaa Almasiihu. Sabi walaa ko ɓurdini yimɓe: ");
INSERT INTO ffm_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","yimɓe fuu luuttii, ngalaa ngeɗu e annoora Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Kaa Laamɗo nanngirii ɓe fooccitiiɓe meere meere kammari hinnee mum. O waɗii ɗum saabe Iisaa Almasiihu coottitiiɗo ɓe oo. ");
INSERT INTO ffm_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Oon Laamɗo fodi hokkitirde yonki mum faa yaafoo luutti goonɗinɓe ɗum, saabe ƴiiƴam mum ɗam. Hono non Laamɗo holliri fooccitaare mum, fay so jukkaalino luuttooɓe arannde ");
INSERT INTO ffm_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","saabe muɲal mum. O waɗirii ɗum faa o ɓanngina fooccitaare makko wakkati mo ngon-ɗen e mum oo, yalla omo holla o pooccitiiɗo, kasen neɗɗo fuu goonɗinɗo Iisaa, o nanngiran ɗum pooccitiiɗo. ");
INSERT INTO ffm_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ndennoo, koɗum fuu woni daliili wasu mo neɗɗo heddorii? Fay gooto! Haybude Sariya Muusaa oo saabii ɗum naa? Wanaa! Goonɗinal tan saabii ɗum! ");
INSERT INTO ffm_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Sabi miɗen anndi neɗɗo goonɗinal mum nanngirtee pooccitiiɗo, wanaa saabe haybugol mum Sariya Muusaa oo. ");
INSERT INTO ffm_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Naa Laamɗo yo Laamɗo Yahuudiyankooɓe tan? Wanaa kanko woni Laamɗo leɲi goɗɗi ɗii duu naa? Kanko jaati woni Laamɗo leɲi goɗɗi ɗii duu, ");
INSERT INTO ffm_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","sabi Laamɗo gooto woodi, nanngiroowo taadiiɓe ɓee fooccitiiɓe saabe goonɗinal mum'en, ɓe taadaaki ɓee duu o nanngiran ɗum'en fooccitiiɓe saabe goonɗinal mum'en. ");
INSERT INTO ffm_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ndennoo, min ittirooɓe Sariya Muusaa oo goonɗinal naa? Fes! Min ittaali mo, min tabintinɓe mo! ");
INSERT INTO ffm_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Koɗum mbiyaten e Ibarahiima njaati men oo? ");
INSERT INTO ffm_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","So tawiino nii mo laatike pooccitiiɗo saabe golleeji makko ɗii, nden omo waawi mantaade. Kaa mo waawaa mantaade yeeso Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Sabi Binndi ɗii mbii: «Ibarahiima goonɗinii Laamɗo, Laamɗo jatorike mo saabe majjum mo pooccitiiɗo.» ");
INSERT INTO ffm_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Golloowo, njoɓdi mum jatortaake waɗaneede moƴƴere, ɗum tilsuɗum. ");
INSERT INTO ffm_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Kaa mo fawataa jikke mum e golleeji mum lobbi, pawoowo jikke oo e goonɗinde Laamɗo baawɗo nanngirde yedduɓe fooccitiiɓe oo, kanko, Laamɗo jatorto mo saabe goonɗinal makko ngal mo pooccitiiɗo. ");
INSERT INTO ffm_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Nii Daawuuda siforii mbelko'aaku neɗɗo mo Laamɗo jatorii pooccitiiɗo tawi walaa golleeji lobbi: ");
INSERT INTO ffm_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«Ɓe boofi mum'en njaafaa, ɓe luutti mum'en tosaa, mbelii hoore. ");
INSERT INTO ffm_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Neɗɗo mo Joomiraaɗo hiisaaki luutti mum, welii hoore.» ");
INSERT INTO ffm_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Tama taadiiɓe ɓee tan njey oon mbelko'aaku? Tama ɓe taadaaki ɓee ngalaa hen? Tama wanaa saabe goonɗinal Laamɗo jatorii Ibarahiima yo pooccitiiɗo? ");
INSERT INTO ffm_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ndennoo, hono Ibarahiima worrunoo nde nanngiraa pooccitiiɗo ndee? O taadiiɗo naa o wanaa? O nanngiraama o pooccitiiɗo gila o taadaaki. ");
INSERT INTO ffm_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Taadagol makko duu yo maande holloore fooccitaare makko ndee saabe goonɗinal o heɓiri gila o taadaaki. Hono non, o laatorii njaati goonɗinɓe ɓe taadaaki ɓee fuu, yalla ɓeen duu ana njatoree yo fooccitiiɓe. ");
INSERT INTO ffm_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Kasen kanko woni baaba taadiiɓe ɓe kaaɗaali e taadagol tan, jokkuɓe laawol makko, kanko baaba men Ibarahiima goonɗinɗo Laamɗo gila taadaaki oo. ");
INSERT INTO ffm_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Laamɗo fodanii hokkude Ibarahiima e iwdi mum aduna oo. Wanaa kammari Ibarahiima ana jokki Sariya oo Laamɗo fodiri ɗum, o fodirii ɗum kammari fooccitaare nde o hokkiri Ibarahiima saabe goonɗinal mum ndee. ");
INSERT INTO ffm_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Sabi so tawii jokkude Sariya ana heƴa neɗɗo faa hokkee ko fodaa koo, goonɗinal laatike meere, fodoore ndee duu nafataa. ");
INSERT INTO ffm_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Sabi Sariya oo jukkungo Laamɗo waddata, kaa ɗo sariya walaa, boofi duu ngalaa. ");
INSERT INTO ffm_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ndennoo, fodoore Laamɗo ndee e goonɗinal fawii, yalla ende laatoo moƴƴere makko, nde tabitana iwdi Ibarahiima fuu, wanaa jokkuɓe Sariya ɓee tan, nde tabitana goonɗinirɓe no Ibarahiima goonɗiniri nii ɓee fuu. Kanko woni njaati meeɗen en fuu ");
INSERT INTO ffm_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","yeeso Laamɗo, no winndorii nii: «Mi waɗii ma baaba leɲi keewɗi.» Ibarahiima goonɗinii Laamɗo guurtinoowo maayɓe, biyoowo ko woodaa yo laato. ");
INSERT INTO ffm_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Ɗo Ibarahiima haannoo taƴude jikke ɗoo, ɗon fawi jikke goonɗini, nii laatorii baaba leɲi keewɗi no Laamɗo wiirunoo mo nii: «Hono nii iwdi maa fotata.» ");
INSERT INTO ffm_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ibarahiima duuɓi mum ana mbaara e teemedere, kaa goonɗinal makko lo'aali nde o yiinoo terɗe makko naywii, Saaratu jom suudu makko oo duu naywii yawtii rimde. ");
INSERT INTO ffm_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","O sikkitaaki fodoore Laamɗo ndee, ko laatii dee, goonɗinal makko ɓeydi heɓude semmbe, mo teddini Laamɗo, ");
INSERT INTO ffm_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","sabi o taƴorii Laamɗo ana waawi tabintinde fodoore mum. ");
INSERT INTO ffm_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Saabe ɗum, «Laamɗo jatorii mo o pooccitiiɗo.» ");
INSERT INTO ffm_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ko Binndi ɗii mbii «Laamɗo jatorii mo o pooccitiiɗo» koo, wanaa kammari makko tan winndorii, ");
INSERT INTO ffm_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","ana winndorii kammari meeɗen enen duu, enen warooɓe jatoreede en fooccitiiɓe, goonɗinɓe Laamɗo guurtinɗo Joomiraaɗo men Iisaa e hakkunde maayɓe oo, ");
INSERT INTO ffm_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","oon bardaaɗo saabe luutti men, guurtiniraaɗo yalla eɗen nanngiree en fooccitiiɓe. ");
INSERT INTO ffm_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Nde wonnoo en nanngiraama fooccitiiɓe saabe goonɗinal, jam waɗii hakkunde men e Laamɗo kammari Joomiraaɗo men Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Kanko udditani en damal hinnee Laamɗo mo ngon-ɗen e mum jooni oo, ɗum laatorike saabe goonɗinal men ngal. Eɗen ceyoroo jikke heɓude ngeɗu e annoora Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Wanaa ɗum tan, eɗen ceyoroo torraaji men duu sabi eɗen anndi torraaji ndimata muɲal, ");
INSERT INTO ffm_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","muɲal ngal rima neɗɗaaku, neɗɗaaku oo rima jikke. ");
INSERT INTO ffm_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Jikke oo noo fuurataa, sabi Ruuhu Ceniiɗo mo ndokke-ɗen oo hebbinanii en jilli Laamɗo ɗii. ");
INSERT INTO ffm_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Sabi nde en ngalaano semmbe ndee, nden Almasiihu maayani en, enen yedduɓe Laamɗo, e ley wakkati mo Laamɗo suɓii oo. ");
INSERT INTO ffm_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Ana tiiɗi neɗɗo jaɓa maayande goɗɗo fay so oon yo pooccitiiɗo, ana moƴƴa neɗɗo jaɓa maayande neɗɗo moƴƴo. ");
INSERT INTO ffm_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Kaa Laamɗo tabintinanii en jilli mum e men ko Almasiihu maayani en gila en luuttooɓe koo. ");
INSERT INTO ffm_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Jooni ko nanngira-ɗen en fooccitiiɓe saabe ƴiiƴam makko ɗam koo, taƴoral en ndaɗan e jukkungo Laamɗo ngoo saabe makko. ");
INSERT INTO ffm_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Sabi nde ngonno-ɗen en konnee'en Laamɗo ndee, Laamɗo rewrintinii en e mum saabe maayde Ɓiyum oo ndee. Ko ndewrintina-ɗen e makko jooni koo, taƴoral en kisinirte saabe nguurndam Ɓiyiiko oo ɗam. ");
INSERT INTO ffm_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Kasen duu eɗen ceyoroo Laamɗo saabe Joomiraaɗo men Iisaa Almasiihu, dewrintinɗo en e Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Jooni, saabe neɗɗo gooto luutti naatiri e aduna oo, kasen duu luutti ɗii ngaddi maayde. Non maayde ndee yottorii yimɓe fuu, sabi ɓe fuu ɓe luuttii. ");
INSERT INTO ffm_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Gila Sariya Muusaa oo jippinaaka, luutti ana ngoodi e aduna oo, kaa so sariya walaa, luutti kiisataake. ");
INSERT INTO ffm_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Gila e Aadama faa e Muusaa, walaa fuu mo maayde heerii. Fay ɓe luuttiraali no Aadama luuttuɗo yamiroore Laamɗo ɓee nii duu maayan. Oon Aadama ana nanndita e garoyoowo oo. ");
INSERT INTO ffm_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Kaa en kaanaa fonndude luuttal Aadama e dokkal Laamɗo. Goonga, yimɓe heewɓe maayii saabe luuttal neɗɗo gooto, kaa hinnee Laamɗo ɓuri fuu mawnude, kaɲum e moƴƴere nde o waɗani yimɓe heewɓe saabe neɗɗo gooto ndee, ɗum woni Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Kasen duu en kaanaa fonndude ko dokkal Laamɗo waddata koo e ko luuttal neɗɗo gooto waddata koo. Sabi sariya banngal luuttal neɗɗo gooto jukkungo waddi, kaa moƴƴere Laamɗo mawnde caggal luutti keewɗi waɗi faa yimɓe nanngiraa fooccitiiɓe. ");
INSERT INTO ffm_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ko luuttal neɗɗo gooto (ɗum woni Aadama) waddani maayde laamaade yimɓe koo, taƴoral heɓooɓe hinnee Laamɗo keewɗo hokkaaɓe fooccitaare ɓee, kaɲum'en laamoto ley nguurndam saabe neɗɗo gooto (ɗum woni Iisaa Almasiihu). ");
INSERT INTO ffm_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ndennoo, no luuttal neɗɗo gooto waddirani yimɓe fuu jukkungo nii, hono non kasen golle pooccitiiɗo mo neɗɗo gooto golli waɗirta yimɓe fuu nanngiree fooccitiiɓe hokka ɗum'en nguurndam. ");
INSERT INTO ffm_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","No salaare neɗɗo gooto waɗiri yimɓe heewɓe luuttooɓe nii, hono non ɗowtaare neɗɗo gooto duu waɗiroyta heewɓe nanngireede fooccitiiɓe. ");
INSERT INTO ffm_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Sariya Muusaa oo wardii faa luutti ɓeyda annditeede, kaa ɗo luutti keewi fuu, ɗon hinnee Laamɗo ɓurata fuu heewde. ");
INSERT INTO ffm_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Hono no luuttal laamorii saabe maayde ndee nii, hono non hinnee Laamɗo oo duu laamoroytoo saabe fooccitaare ndee faa naɓa en to nguurndam nduumiiɗam ɗam Joomiraaɗo men Iisaa Almasiihu hokkata en ɗam. ");
INSERT INTO ffm_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Ndennoo, koɗum mbiyaten? En keddoto e luuttal yalla hinnee Laamɗo oo ana ɓeydoo naa? ");
INSERT INTO ffm_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Ɗum waawaa laataade! En maayɓe banngal luutti, ɗum woni en ceertii e majji. Ndennoo hono mbaawraten kasen wuurde e ley luutti? ");
INSERT INTO ffm_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Oɗon anndi lootogal men batisima kaɓɓungal en e Iisaa Almasiihu ngal haɓɓii en e maayde mum duu. ");
INSERT INTO ffm_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ndennoo, e ley batisima oo en maaydii e makko en irdaama e makko, yalla no Almasiihu wuurtiri e hakkunde maayɓe saabe baawɗe Baabiraaɗo tedduɗe ɗee nii, enen duu eɗen nguurda non nguurndam kesam. ");
INSERT INTO ffm_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","E ley ɗum, no ndeentir-ɗen e makko maayde nanndunde e nde makko ndee nii, hono non ndeentirten e makko immital nanndungal e ngal makko ngal. ");
INSERT INTO ffm_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Sabi eɗen anndi ko hiiɗɗi ko woni ley men koo tontidaama e makko dow leggal bardugal, yalla terɗe men luuttooje ɗee ana kalkoo, tonngite-ɗen iwde e tonngoode luuttal. ");
INSERT INTO ffm_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Sabi maayɗo tonngitaama iwde e tonngoode luuttal, nanngiraama pooccitiiɗo. ");
INSERT INTO ffm_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Ko maaydu-ɗen e Almasiihu koo, eɗen koolii en nguurdan e makko duu, ");
INSERT INTO ffm_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","sabi eɗen anndi ko Almasiihu wuurti e hakkunde maayɓe koo, maayataa kasen, maayde duu jaalataako mo kasen. ");
INSERT INTO ffm_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Sabi nde o maayi ndee, o taƴii tonngoode luuttal cilol gootol keƴoowol yimɓe jamaanuuji ɗii fuu. Jooni e nguurndam makko ɗam, Laamɗo o wuurani. ");
INSERT INTO ffm_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Hono non, onon duu, laatee no maayɓe nii banngal luuttal, no wuuranɓe Laamɗo nii e haɓɓagol mon e Iisaa Almasiihu ngol. ");
INSERT INTO ffm_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ndennoo, pati accee luuttal jaaloo terɗe mon maayooje ɗee faa njokkon giɗaaɗe majje. ");
INSERT INTO ffm_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Pati ndokkee calɗi mon ɗii luuttal, pati ngaɗon ɗi kaɓorɗe ooɲaare. Ndokkee ko'e mon Laamɗo. Kammari on maaynooɓe, jooni kaa on wuurɓe, ngaɗon calɗi mooɗon ɗii kaɓorɗe fooccitaare. ");
INSERT INTO ffm_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Luuttal jaalataako on kasen, sabi on ŋoottii taweede e ley Sariya oo, ko ngon-ɗon e mum dee, e ley hinnee Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Koɗum hen, ndennoo? En luuttan saabe e ley hinnee ngon-ɗen wanaa e ley Sariya naa? Ɗum waawaa laataade! ");
INSERT INTO ffm_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Oɗon anndi so on ngaɗii ko'e mon e gollande neɗɗo faa ɗowtano-ɗon ɗum, on laatiima maccuɓe mo ɗowtanto-ɗon oo. Ndennoo, naa on laatiima maccuɓe luutti naɓooji on e maayde, naa on ɗowtaniima Laamɗo naɓoowo on e fooccitaare. ");
INSERT INTO ffm_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Kaa jettooje ngoodanii Laamɗo! Arannde e tonngoode luuttal ngonno-ɗon, kaa jooni oɗon nii ɗowtorii ɓerɗe laaɓuɗe laawol ngol njanngine-ɗon ngol. ");
INSERT INTO ffm_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","On tonngitaama iwde e tonngoode luuttal, on laatike gollooɓe ɗowtaniiɓe fooccitaare ndee. ");
INSERT INTO ffm_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Miɗo haalda ɗoo no yimɓe paamirta nii kammari on njaawaali faamde. No ngaɗirno-ɗon calɗi mon ɗii e maral tuundi e ooɲaare faa ngollu-ɗon ko boni nii, jooni ngaɗiron non calɗi mon ɗii e maral fooccitaare faa ngollon ko senii. ");
INSERT INTO ffm_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Nde ngonno-ɗon e tonngoode luuttal ndee, on laatanooki gollooɓe ɗowtaniiɓe fooccitaare. ");
INSERT INTO ffm_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Koɗum keɓuno-ɗon e majjum? Fay huunde, so wanaa ko kersirton hannde koo, sabi battane majjum yo maayde. ");
INSERT INTO ffm_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Kaa jooni, on tonngitaama iwde e tonngoode luuttal, on laatike gollanooɓe Laamɗo, oɗon nguura e senaare. Battane majjum yo nguurndam nduumiiɗam. ");
INSERT INTO ffm_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Sabi mbarjaari luuttal yo maayde, kaa moƴƴere nde Laamɗo hokkata ndee yo nguurndam nduumiiɗam e ley haɓɓagol men e Joomiraaɗo men Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Sakiraaɓe, miɗo haaldana on no yimɓe annduɓe Sariya Muusaa oo ɓee nii. Oɗon anndi faa laaɓi paca neɗɗo e ley Sariya tawetee so nii ana heddii wuurde. ");
INSERT INTO ffm_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Hono nii debbo ɓamaaɗo, sariya tonngi ɗum e gorum oo so nii gorko oo ana wuuri. Kaa so gorko oo maayii, mo tonngitaama iwde e sariya tonngunooɗo mo oo. ");
INSERT INTO ffm_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","So goɗɗo ɓamii mo e ley nguurndam goriiko oo, wiyete mo jeenoowo. Kaa so goriiko oo maayii, sariya oo yoppitan mo, mo wiyataake jeenoowo so mo ɓamondirii e gorko goɗɗo. ");
INSERT INTO ffm_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Sakiraaɓe am, onon duu on maayanii Sariya Muusaa, on iwii e ley mum kammari maayde Almasiihu ndee, on jeyaama e goɗɗo, ɗum woni Almasiihu mo Laamɗo wuurtini e hakkunde maayɓe oo yalla eɗen ngolla ko welata Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Wakkati nde ngonno-ɗen e hiini hoore men ndee, giɗaaɗe yonki bonɗe ɗe Sariya Muusaa oo tekkini ɗee ana ngolla e terɗe men faa naɓa en to maayde. ");
INSERT INTO ffm_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Kaa jooni, en tonngitaama iwde e tonngoode Sariya Muusaa, sabi en maayii banngal Sariya tonngunooɗo en oo faa mbaawen gollande Laamɗo ley nguurndam kesam tuugiiɗam e Ruuhu oo, tawee ɗam tuugaaki e Sariya kiiɗɗo binndaaɗo oo. ");
INSERT INTO ffm_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ndennoo, koɗum mbiyaten? Sariya Muusaa oo yo luuttal naa? Wanaa! Kaa noo, Sariya oo anndini kam ko woni luuttal. Sabi mi anndataano ko woni tuuyo so Sariya oo wiyaalino: «Pati tuuye-ɗaa!» ");
INSERT INTO ffm_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Luuttal ngal tuugike kaɗaaɗi ɗii, waɗi e am sii tuuyooji fuu. Sabi so Sariya walaa, luutti ɗii yo baatuɗi. ");
INSERT INTO ffm_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Arannde, nde mi anndaano Sariya oo ndee, miin, miɗo wuurnoo, kaa ko kaɗaaɗi ɗii ngari koo, luuttal laattii guurngal, ");
INSERT INTO ffm_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","miin, maay-mi. Jamirooje kaannooɗe waddande kam nguurndam ɗee, laatii naɓooje kam to maayde. ");
INSERT INTO ffm_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Sabi luuttal ngal tuugike kaɗaaɗi ɗii, ƴoɲɲi kam, wardi kam ɗi. ");
INSERT INTO ffm_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Ndennoo, Sariya Muusaa yo ceniiɗo, jamirooje ɗee duu yo ceniiɗe yo pooccitiiɗe yo moƴƴuɗe. ");
INSERT INTO ffm_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Jooni, ko moƴƴi waddanii kam maayde naa? Waddanaali! Luuttal woni ko waddani kam maayde. Hono nii ngal annditirtee ngal luuttal jaati, sabi ngal nawtorike ko moƴƴi faa rima e am maayde. Ndennoo, saabe jamirooje ɗee luuttal ngal ɓanngii ngal luuttal ƴaɓɓitiingal. ");
INSERT INTO ffm_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Eɗen anndi Sariya Muusaa oo to Ruuhu Ceniiɗo iwi. Kaa miin mi neɗɗo lo'uɗo mo luutti njaalii. ");
INSERT INTO ffm_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Sabi mi faamaali ko ngaɗan-mi koo: ko njiɗu-mi waɗude koo, mi waɗataa ɗum, kaa ko mbaɲu-mi koo, ɗum ngaɗan-mi. ");
INSERT INTO ffm_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","So miɗo waɗa ko mi yiɗaa koo, ɗum ana holla mi jaɓii Sariya Muusaa oo ana moƴƴi. ");
INSERT INTO ffm_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Joonnoo, wanaa miin waɗirta non, luuttal gonngal e am ngal waɗirta non. ");
INSERT INTO ffm_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Miɗo anndi e ley am, ɗum woni e ley terɗe am, ko moƴƴi walaa e mum. Yiɗude waɗude ko moƴƴi ana e am, kaa mi waawaa waɗude ɗum. ");
INSERT INTO ffm_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Mi waɗataa ko moƴƴi ko njiɗu-mi koo, ko boni ko mi yiɗaa koo ngaɗan-mi. ");
INSERT INTO ffm_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Kaa so mi waɗii ko mi yiɗaa, wanaa miin gollirta non, luuttal gonngal e am ngal gollirta non. ");
INSERT INTO ffm_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ko taykii-mi hen dee: wakkati fuu miɗo yiɗi waɗude ko moƴƴi, kaa ko boni koo huɓindii kam. ");
INSERT INTO ffm_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","To ley hakkille am too, Sariya Laamɗo oo ana weli kam jaati, ");
INSERT INTO ffm_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","kaa miɗo maata neesu bonɗo e ley terɗe am, ana haɓa e sariya gonɗo ley hakkille am oo. Neesu bonɗo oo ana waɗa kam maccuɗo luuttal gonngal e terɗe am ngal. ");
INSERT INTO ffm_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Hee miɗo yurminii! Homo waawi ittude kam e ɗee terɗe naɓooje kam to maayde? ");
INSERT INTO ffm_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Jettooje ngoodanii Laamɗo saabe Joomiraaɗo men Iisaa Almasiihu! Ndennoo miin, e ley hakkille am mi gollanoowo Sariya Laamɗo, kaa e terɗe am mi gollanoowo luuttal. ");
INSERT INTO ffm_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Jooni kaa, jukkungo fuu walaa e haɓɓiiɓe e Iisaa Almasiihu ɓee, ");
INSERT INTO ffm_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","sabi baawɗe Ruuhu dokkooje en nguurndam saabe Iisaa Almasiihu ɗee ittii en e baawɗe luuttal, kaɲum e maayde fuu. ");
INSERT INTO ffm_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Ko Sariya Muusaa ronki timminde saabe loore terɗe men koo, ɗum Laamɗo timmini. Faa o tosa luutti o neldi Ɓiyiiko jaati dow mbaadi nanndundi e ndi ɓiɓɓe aadama luuttooɓe ndii. E mum o jukki luuttal golloowal e ley terɗe men ngal. ");
INSERT INTO ffm_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Ɗum fuu yalla laaɓal ngal Sariya oo yamiri ngal ana hiɓɓa e meeɗen, enen jokkuɓe Ruuhu ɓe njokkaali e giɗaaɗe yonki mum'en ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Haɓɓiiɓe e giɗaaɗe yonki ɓee, giɗaaɗe yonki miilata, kaa haɓɓiiɓe e Ruuhu ɓee, ko Ruuhu jey koo miilata. ");
INSERT INTO ffm_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Miilde giɗaaɗe yonki mum tan, maayde waddanta neɗɗo, kaa noo, miilde ko Ruuhu jey koo, nguurndam e jam waddanta neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Sabi miiloowo giɗaaɗe yonki mum tan yo gaɲo Laamɗo, sabi joomum ɗowtantaako Sariya Laamɗo oo, ko selli hen dee, waawaa jaati. ");
INSERT INTO ffm_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Haɓɓiiɓe e giɗaaɗe yonki ɓee mbaawaa welde Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kaa onon, on kaɓɓataako e giɗaaɗe yonki so Ruuhu Laamɗo ana e mon, e Ruuhu oo kaɓɓoto-ɗon. Neɗɗo fuu mo walaa Ruuhu Almasiihu oo, waldaa e Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Kaa so Almasiihu wonii e mon, fay so taweede terɗe mon ɗee yo maayɗe saabe luuttal ngal, yonkiiji mon ɗii kaa yo guurɗi kammari on nanngiraama fooccitiiɓe. ");
INSERT INTO ffm_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Laamɗo guurtinɗo Iisaa Almasiihu e hakkunde maayɓe oo, so Ruuhu mum ana e mon, kaɲum jaati hokkata terɗe mon maayooje ɗee nguurndam, o hokkiran ɗum Ruuhu makko gonɗo e mon oo. ");
INSERT INTO ffm_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Jooni kaa, sakiraaɓe, so won ko tilsinte-ɗen, wanaa jokkude giɗaaɗe yonki tilsinte-ɗen. ");
INSERT INTO ffm_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","So on nguurdii no giɗaaɗe yonki ngorri nii fuu, on maayan. Kaa so on mbardii giɗaaɗe ɗee Ruuhu Laamɗo oo, on nguuran. ");
INSERT INTO ffm_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Ɓe Ruuhu Laamɗo oo ɗowata ɓee yo ɓiɓɓe Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Sabi Ruuhu mo Laamɗo hokki on oo waɗataa on maccuɓe faa wartira on e kulol. Ko keɓu-ɗon dee, Ruuhu gaɗoowo on ɓiɓɓe Laamɗo. Kanko waɗata en noddiren Laamɗo «Abba». ");
INSERT INTO ffm_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ruuhu oo jaati, kaɲum e ɓerɗe men ɗee ana ceedoo en ɓiɓɓe Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","So en ɓiɓɓe, en ronooɓe duu. So en ronooɓe ko Laamɗo fodi koo, en rondooɓe e Almasiihu. So eɗen torridee e makko, en keɓidan e makko teddeengal duu. ");
INSERT INTO ffm_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Miɗo anndi torraaji meeɗen hannde ɗii mbaawaa fonndeede e teddeengal ngal Laamɗo ɓannginanta en janngo ngal. ");
INSERT INTO ffm_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Tagoore ndee fuu ana heppi ɲalaande nde Laamɗo ɓannginta teddeengal ɓiɓɓe mum ndee. ");
INSERT INTO ffm_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Sabi tagoore ndee, baawɗe naɓooje nde e meere laamotoo nde. Wanaa e sago mayre ɗum waɗaa, Laamɗo muuyrunoo ɗum non. Kaa jikke ana woodi, ");
INSERT INTO ffm_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","sabi tagoore ndee tonngitete iwde e tonngoode ɲolgol, soottitee heɓa ngeɗu e teddeengal ngal ɓiɓɓe Laamɗo ɓee keɓata ngal. ");
INSERT INTO ffm_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Sabi eɗen anndi, faa jooni tagoore ndee fuu ana uuma ana tampi e naawalla ŋatawere. ");
INSERT INTO ffm_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Wanaa ɗum tan, enen heɓirɓe Ruuhu Laamɗo oo no dokkal Laamɗo adiingal nii ɓee duu eɗen uuma, sabi eɗen keppi Laamɗo soottitaaki terɗe men ɗee waɗa en ɓiɓɓe mum. ");
INSERT INTO ffm_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Sabi e ley jikke kisina-ɗen. Kaa jikke keɓaaɗo ŋoottii laataade jikke, sabi neɗɗo fawataa jikke e ko heɓi. ");
INSERT INTO ffm_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Kaa so eɗen pawa jikke e ko en keɓaali tafon, en ndoomiran ɗum sawraare. ");
INSERT INTO ffm_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Hono non Ruuhu oo waran walla en e loore men duu, sabi en anndaa no kaan-ɗen waɗirde duwaawu nii. Kaa Ruuhu oo e hoore mum ɲaaganto en Laamɗo, ɲaagoroo uumaali ɗi mbaawaa sifeede e haalaaji. ");
INSERT INTO ffm_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Laamɗo kumpitiiɗo ko woni ley ɓerɗe men oo duu ana anndi anniya Ruuhu, sabi e sago makko Ruuhu oo ɲaagirantoo seniiɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Eɗen anndi, yiɗuɓe Laamɗo noddiraaɓe anniya makko ɓee, Laamɗo ana waɗa huunde fuu gollida faa laatanoo ɗum'en ko moƴƴi. ");
INSERT INTO ffm_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Sabi ɓe Laamɗo anndi gila tagaaka ɓee, o hoddiranii ɗum'en nanndude e Ɓiyiiko oo, yalla Ɓiɗɗo oo ana laatoo hammadiijo sakiraaɓe heewɓe. ");
INSERT INTO ffm_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Kasen duu ɓe o hoddirani ɓee, o noddii ɗum'en, ɓe o noddi ɓee, o nanngirii ɗum'en fooccitiiɓe, ɓe o nanngiri fooccitiiɓe ɓee, o hokkii ɗum'en ngeɗu mum'en e teddeengal makko. ");
INSERT INTO ffm_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Caggal ɗum fuu, koɗum mbiyaten? So Laamɗo ana wondi e men, homo waawi honude en? ");
INSERT INTO ffm_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Kanko, fay Ɓiyiiko oo e hoore mum mo haɗaali en, o hokkitirii ɗum kammari men en fuu. Fay huunde haɗataa mo hokkude en ko moƴƴi fuu, o hokkida en ɗum e mum. ");
INSERT INTO ffm_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Homo naɓata ɓe Laamɗo suɓii ɓee sariya? Fay gooto, sabi Laamɗo nanngirii ɓe fooccitiiɓe! ");
INSERT INTO ffm_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Homo waawi liɓude ɓe e sariya? Walaa, sabi Iisaa Almasiihu maayanii en, ko ɓuri ɗum fuu, o wuurtanii en. Omo jooɗii ɲaamo Laamɗo omo ɲaaganoo en. ");
INSERT INTO ffm_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Koɗum waawi seenndude en e jilli ɗi Almasiihu yiɗi en ɗii? Ɓillaare naa, wemmbere naa, torra naa, yolbere naa, kolndam naa, farati naa, naa kaafaawi? ");
INSERT INTO ffm_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nii Binndi ɗii mbiiri: «Saabe maa miɗen nii kosa maayde ɲannde fuu, miɗen nanngiraa no baali kirsoyteeɗi nii.» ");
INSERT INTO ffm_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Ɗum fuu e taweede, eɗen keɓira jaalogal manngal saabe jiɗɗo en oo. ");
INSERT INTO ffm_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Sabi miɗo taƴori, wanaa maayde, wanaa nguurndam, wanaa malaa'ika'en, wanaa laamu, wanaa ko wari jooni, wanaa ko waroyta, wanaa semmbe, ");
INSERT INTO ffm_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","wanaa baawɗe gonɗe dow, wanaa gonɗe ley, wanaa huunde fuu ko tagaa, fay huunde waawaa seenndude en e jilli ɗi Laamɗo waɗi e men ɗii e ley haɓɓagol men e Joomiraaɗo men Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ko kaalan-mi ɗoo koo yo goonga, sabi ko ngon-mi e Almasiihu koo kaaliran-mi, mi fenataa. Hakkille am mo Ruuhu Ceniiɗo ɗowata oo, ana seedanoo kam ");
INSERT INTO ffm_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","mboy-yonki cattuɗo, kaɲum e naawalla duumiiɗo ana e am ");
INSERT INTO ffm_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","4","saabe Israa'iilankooɓe sakiraaɓe am ɓee. Miɗo yelinoo laataade kuɗaaɗo mi seerta e Almasiihu miin e hoore am so ana nafannoo leɲol am ngol. Kamɓe ngoni ɓe Laamɗo waɗi ɓiɓɓe mum, holli ɓe teddeengal mum. Kamɓe njey aadiiji ɗii e Sariya Muusaa oo. Kasen duu Laamɗo anndinii ɓe no rewirtee, waɗanii ɓe podooje mum. ");
INSERT INTO ffm_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Leɲol am yo iwdi maamiraaɓe Israa'iila aranndeeɓe ɓee, Almasiihu duu banngal ɓii-aadamaaku mum e leɲol ngol iwi, kanko woni Laamɗo, o tiimɗo huunde fuu, yo o yette faa abada. Aamiina. ");
INSERT INTO ffm_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ɗum wanaa wiide konngol Laamɗo ngol laatike meere. Sabi wanaa iwɓe e Israa'iila ɓee fuu ngoni Israa'iilankooɓe, ");
INSERT INTO ffm_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","wanaa iwɓe e Ibarahiima ɓee fuu ngoni ɓiɓɓe mum jaati. Sabi Laamɗo wii Ibarahiima: «Iwdi Isiyaaka ndii, kayri innditortoo innde maa.» ");
INSERT INTO ffm_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Ɗum woni: wanaa ɓiɓɓe Ibarahiima rimiraaɓe no yimɓe fuu ndimirtee nii ngoni ɓiɓɓe Laamɗo, rimiraaɓe saabe fodoore ndee ɓee nanngiraa no iwdi makko jaati nii. ");
INSERT INTO ffm_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Sabi Laamɗo fodii ɗii konngi wii: «Mi wartan e hono oo wakkati mawuuri, Saaratu heɓan ɓiɗɗo gorko.» ");
INSERT INTO ffm_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Wanaa ɗum tan. Rebekka duu ɓamii reedu funeeɓe. Baaba maɓɓe yo Isiyaaka, maama men oo. ");
INSERT INTO ffm_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","12","Gila ɓiɓɓe ɓee ndimaaka sako ɓe ngaɗa ko moƴƴi naa ko boni, nden Laamɗo wii Rebekka: «Mawniraaɗo oo laatoto maccuɗo miɲiraaɗo oo.» O waɗiri non faa anniya makko banngal suɓagol tabita, ɗum woni: suɓagol makko ngol fawaaki e golle yimɓe, e Laamɗo noddoowo oo ngol fawii ");
INSERT INTO ffm_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","no Binndi ɗii mbiiri nii: «Yaakuuba korsin-mi, Iisuwa koynu-mi.» ");
INSERT INTO ffm_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Ndennoo, koɗum mbiyaten? Laamɗo yo ooɲiiɗo naa? Fes! ");
INSERT INTO ffm_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Annii ko o wii Muusaa: «Mi hinnoto mo muuy-mi hinnaade, mi yurmoto mo muuy-mi yurmaade.» ");
INSERT INTO ffm_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ndennoo, suɓagol makko fawaaki e sago neɗɗo naa e golle mum, ko fawii e mum dee, dow Laamɗo jurmotooɗo oo. ");
INSERT INTO ffm_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Sabi e ley Binndi ɗii, Laamɗo wii Fira'awna: «Ko ngaɗir-maa-mi kaananke dee, faa mi hollira baawɗe am e maa, kasen duu faa innde am ooynee e aduna oo fuu.» ");
INSERT INTO ffm_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Ndennoo, Laamɗo yurmoto mo muuyi, yoornan ɓernde mo muuyi. ");
INSERT INTO ffm_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Ana moƴƴa daɲa biiɗo kam: «So non ɗum worri, koɗum Laamɗo felirta yimɓe so fay gooto waawaa salaade muuyɗe makko ɗee?» ");
INSERT INTO ffm_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Aan neɗɗo oo, koɗum ngon-ɗaa faa njeddaa Laamɗo? Loonde mahaande ana wiya mahuɗo ɗum oo: «Ko saabii so mahir-ɗaa kam nii?» ");
INSERT INTO ffm_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Mahoowo looɗe ana waawi waɗude e loope ɗee ko yiɗi fuu: e loopal gootal o maha loonde nde gollirtaake so wanaa e dow ko hensaa, o maha wonnde gollirteende ko wanaa ko hensaa. ");
INSERT INTO ffm_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Haya, fay so taweede Laamɗo muuyii ɓannginde tikkere mum kaɲum e baawɗe mum, o muɲanii ɓe o tikkani ɓee muɲal cattungal, ɗum woni haanduɓe e halkaade ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","O waɗirii nii faa o ɓanngina annoora makko mawɗo dow ɓe o yurmotoo ɓee, ɓe o lanndinanii gila ko ɓooyi yalla ana keɓa ngeɗu e annoora makko. ");
INSERT INTO ffm_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ɓeen yimɓe ngoni enen ɓe o noddi ɓee, wanaa ley Yahuudiyankooɓe ɓee tan, ley leɲi goɗɗi ɗii duu. ");
INSERT INTO ffm_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nii Laamɗo wiiri ɗum e dewtere annabi Hosee'a: «Leɲol ngol wanaa leɲol am ngol, mi noddiroyan ngol leɲol am, yimɓe ɓe korsinaaka ɓee, mi noddiroyan ɓe yimɓe am horsuɓe. ");
INSERT INTO ffm_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Kasen duu ɗo ɓe mbiyetenoo ɓe nganaa yimɓe am ɗoo, ɗon ɓe mbiyoytee ɓiɓɓe Laamɗo guurɗo oo.» ");
INSERT INTO ffm_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Annabi Esaaya duu haalii haala Israa'iilankooɓe, wii: «Fay so ɓiɓɓe Israa'iila keewiri no njaareendi geeci nii, seeɗa maɓɓe tan hisintee, ");
INSERT INTO ffm_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","sabi Joomiraaɗo tabintinan konngol mum faa hiɓɓa e leydi ndii ko yaawi.» ");
INSERT INTO ffm_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Kasen duu nii Esaaya wiirunoo gila arannde: «Sinndo Joomiraaɗo Jom Semmbe oo ɗaldaalino en iwdi, tawanno en laatike no ngeenndi Sodooma nii, en nanndii e ngeenndi Gomoora.» ");
INSERT INTO ffm_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ndennoo, koɗum mbiyaten? Ko mbiyaten annii: yimɓe ɓe nganaa Yahuudiyankooɓe ɓe tewtaalino nanngireede fooccitiiɓe yeeso Laamɗo ɓee, ɓeen keɓi fooccitaare, ɗum woni fooccitaare saabe goonɗinal. ");
INSERT INTO ffm_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Israa'iilankooɓe tewtunooɓe nanngireede fooccitiiɓe yeeso Laamɗo saabe jokkude Sariya ɓee ndonkii heɓude nanngireede fooccitiiɓe. ");
INSERT INTO ffm_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Ko saabii? Saabe ɓe tewtiraali ɗum goonɗinal, golle maɓɓe ɓe tewtiri ɗum faa ɓe pergitii e «haayre fergitoore ndee» ");
INSERT INTO ffm_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","no haala kaa hippiraa ley Binndi ɗii nii: «Mi fawan e Siyona haayre nde yimɓe pergitotoo e mum so liɓa ɗum'en. Kaa goonɗinɗo nde fuu hersataa abada!» ");
INSERT INTO ffm_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Sakiraaɓe, ko njiɗu-mi e ɓernde am jaati, e ko ɲaagotoo-mi Laamɗo: Israa'iilankooɓe kisinee. ");
INSERT INTO ffm_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Miɗo seedanoo ɓe eɓe kirana Laamɗo sanne, kaa kiram maɓɓe ɗam waldaa e faamu. ");
INSERT INTO ffm_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Ɓe paamaali fooccitaare nde Laamɗo hokkata neɗɗo ndee, faa ɓe piyani ko'e maɓɓe dabare laataade fooccitiiɓe. Hono nii ɓe ɗowtanaaki sariya mo Laamɗo darni faa nanngira neɗɗo pooccitiiɗo oo. ");
INSERT INTO ffm_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Sabi Almasiihu woni timmoode Sariya Muusaa oo, yalla goonɗinɗo Almasiihu fuu ana nanngiree pooccitiiɗo. ");
INSERT INTO ffm_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Ko Muusaa winndi banngal fooccitaare iwnde e Sariya ndee annii: «Neɗɗo fuu jokkuɗo Sariya oo, wuurdan saabe Sariya oo.» ");
INSERT INTO ffm_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Kaa ko fooccitaare iwnde e goonɗinal ndee wii koo: pati wii e ɓernde maa «Homo ŋabbata dow kammu?» Ɗum woni faa jippina Almasiihu, ");
INSERT INTO ffm_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","naa «Homo yahata laakaraa?» Ɗum woni faa immintina Almasiihu e hakkunde maayɓe. ");
INSERT INTO ffm_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ndennoo, koɗum fooccitaare iwnde e goonɗinal wiyata? Ɗum ɗoo nde wiyata: «Konngol Laamɗo ana ɓadi maa, engol e hunduko maa, engol e ɓernde maa.» Ngol konngol woni kabaaru goonɗinal ngal min mbaajotoo ngal. ");
INSERT INTO ffm_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","So a seedorike hunduko maa Iisaa yo Joomiraaɗo, a goonɗinii e ɓernde maa Laamɗo wuurtinii mo e hakkunde maayɓe, a hisinte. ");
INSERT INTO ffm_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Sabi goonɗinɗo e ley ɓernde mum, Laamɗo nanngiran ɗum pooccitiiɗo, ceedoriiɗo hunduko mum, Laamɗo hisinan ɗum ");
INSERT INTO ffm_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","no Binndi ɗii mbiiri nii: «Goonɗinɗo mo fuu hersataa.» ");
INSERT INTO ffm_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Jooni, walaa ko seenndi Yahuudiyanke e mo wanaa Yahuudiyanke, ɓe fuu ɓe Joomiraaɗo gooto, o kebbinoowo moƴƴereeji makko e noddooɓe mo ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Sabi «neɗɗo fuu nodduɗo innde Joomiraaɗo, hisinte.» ");
INSERT INTO ffm_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Kaa hono ɓe mbaawiri noddude mo so ɓe ngoonɗinaali mo? Hono ɓe mbaawiri goonɗinde mo so ɓe nanaali kabaaru makko? Hono ɓe mbaawiri nande kabaaru makko so baajotooɗo walaa? ");
INSERT INTO ffm_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Hono yimɓe mbaawiri waajaade so nelaaka? Binndi ɗii mbii: «Huunde fuu ɓuraa yiigol warooɓe yottinde Kabaaru Lobbo ɓee ngol wooɗude.» ");
INSERT INTO ffm_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Kaa wanaa yimɓe fuu njaɓani Kabaaru Lobbo oo. Annabi Esaaya wii: «Joomiraaɗo, homo goonɗini waaju amen oo?» ");
INSERT INTO ffm_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Hono nii goonɗinal heɓiraa e nande waaju, waaju duu heɓiraa e konngol Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Kaa miɗo lamndoo ɗum ɗoo: Israa'iilankooɓe nanaali naa? Ɓe nanii jaati! Nii Binndi ɗii mbii: «Daaɗe maɓɓe nanaama e aduna oo fuu, konngi maɓɓe njottiima faa hoore leydi.» ");
INSERT INTO ffm_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Miɗo lamndoo kasen: Israa'iilankooɓe paamaali naa? Ley Tawreeta Muusaa Laamɗo wii tafon: «Mi waɗan kiron ɓe laataaki leɲol ɓee, mi waɗan tikkanon leɲol ngol walaa hakkille.» ");
INSERT INTO ffm_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Nden kaa, annabi Esaaya hulaali wiide caggal mum: «Ɓe tewtaalino kam ɓee tawii kam, ɓe lamndanaaki kam ɓee, mi ɓannganii ɗum'en.» ");
INSERT INTO ffm_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Kaa banngal Israa'iila, Laamɗo wii: «Ɲannde fuu miɗo lanndinii jaɓɓaade leɲol caliingol jeddungol ngol.» ");
INSERT INTO ffm_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Ndennoo, miɗo lamndoo: Laamɗo yoppii yimɓe mum Israa'iilankooɓe ɓee naa? O yoppaali! Sabi miin e hoore am mi Israa'iilanke, mi iwdi Ibarahiima, e suudu baaba Beɲamin njeyaa-mi. ");
INSERT INTO ffm_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Laamɗo yoppaali yimɓe mum ɓe suɓinoo gila arannde ɓee. Tama on anndaa ko Binndi ɗii mbii nde annabi Iliyaasa wullantonoo Israa'iilankooɓe ɓee to Laamɗo, wii: ");
INSERT INTO ffm_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","«Joomiraaɗo, ɓe mbarii annabaaɓe maa, ɓe ngurjinii ittirɗe maa sadaka, miin tan gooto heddii, eɓe ndaara no ɓe mbarda kam.» ");
INSERT INTO ffm_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Koɗum Laamɗo jaabii mo? Ɗum ɗoo: «Mi mooɓtanii hoore am ujunaaji njeɗɗon gorko ɓe cujidanaali tooru wiyeteendu Ba'ala.» ");
INSERT INTO ffm_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Hono non, hakkunde yimɓe hannde ɓee, ana woodi yimɓe seeɗa ɓe Laamɗo suɓorii saabe hinnee mum. ");
INSERT INTO ffm_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Kaa so o suɓorike ɓe hinnee, en anndan o suɓoraaki ɓe saabe golle maɓɓe. So wanaa ɗum, hinnee Laamɗo oo heddataako laataade hinnee hankasen. ");
INSERT INTO ffm_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Ndennoo, hono laatii? Ko laatii dee, Israa'iilankooɓe ɓee keɓaali ko ndaartunoo koo, ɓe Laamɗo suɓii ɓee nii keɓi ɗum. Woɓɓe ɓee, ɓerɗe mum'en mbumnaa ");
INSERT INTO ffm_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","no winndorii nii: «Laamɗo uddii hakkillaaji maɓɓe, wumnii gite maɓɓe, faaɗinii noppi maɓɓe. Faa hannde non worri.» ");
INSERT INTO ffm_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Daawuuda duu wii: «Yo rewgol maɓɓe bonngol ngol laatano ɓe piccal kaɲum e yammbuure, laatanoo ɓe fergitere yalla eɓe njukkee. ");
INSERT INTO ffm_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Yo gite maɓɓe niɓɓine pati ɓe njiya, yo cagge maɓɓe ture faa abada!» ");
INSERT INTO ffm_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Ndennoo, miɗo lamndoo: ko Yahuudiyankooɓe ɓee pergitii koo, yalla faa ɓe caama faa abada naa? Wanaa! Kaa saabe luutti maɓɓe ɗii, yimɓe ɓe nganaa Yahuudiyankooɓe ɓee keɓiri kisindam ɗam, yalla Yahuudiyankooɓe ɓee ana kira. ");
INSERT INTO ffm_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","So luutti maɓɓe ɗii ngaddanii aduna oo ko moƴƴi, so waasude maɓɓe goonɗinde Iisaa duu waddanii ɓe nganaa Yahuudiyankooɓe ɓee ko moƴƴi, wanaa haala so Yahuudiyankooɓe ɓee fuu tuubii. ");
INSERT INTO ffm_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Jooni, onon ɓe nganaa Yahuudiyankooɓe ɓee kaaldan-mi: ko laatii-mi nelaaɗo e mooɗon koo, miɗo mantoroo golle mo ndokkaa-mi oo ");
INSERT INTO ffm_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","yaama mi heɓa waddude kiram e ley leɲol am, faa mi hisina yoga e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","So woɗɗineede Yahuudiyankooɓe rewrintinii aduna oo e Laamɗo, hono laatoytoo so ɓe njaɓɓoyaama? Walaa fuu no laatoytoo so wanaa iwde e maayde so naata e nguurndam. ");
INSERT INTO ffm_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","So tamre aranndeere sakkaama Laamɗo, tame keddiiɗe ɗee duu cakkaama. So ɗaɗi lekki cakkaama Laamɗo, caɓe ɗee duu cakkaama. ");
INSERT INTO ffm_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Jonnoo, Israa'iilankooɓe ana mba'i no maangoroowi tutaaki ki caɓe mum yogaaje caltaa. Aan mo wanaa Yahuudiyanke nannduɗo e caɓal maangoroowi ki tutaaka, a waddaama a dobaama e maangoroowi kii. Nii keɓir-ɗaa ngeɗu e ko iwata e ɗaɗi maangoroowi tutaaki kii no caɓe goɗɗe ɗee keɓiri nii. ");
INSERT INTO ffm_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Kammari majjum, pati manta yeeso caɓe caltaaɗe ɗee. Kaa so aɗa mantoo, anndaa wanaa aan wuurni ɗaɗi ɗii, ɗaɗi ɗii nguurnu maa. ");
INSERT INTO ffm_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Ana moƴƴa tawee aɗa wiya: «Caɓe caltaama yalla miɗo dobee ɗo ɗe ngonnoo ɗoo.» ");
INSERT INTO ffm_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Ana selli! Kaa ko ɗe caltiraa dee, rafi goonɗinal majje, aan aɗa heddii e dobeede saabe goonɗinal maa. Ndennoo, pati mawninkina, tawde-ɗaa e kulol Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Sabi so Laamɗo ɗalaali caɓe layliije ɗee, ɗalataa ma aan duu. ");
INSERT INTO ffm_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ndennoo, taykita moƴƴuki Laamɗo e ɲanngere mum fuu: omo ɲanngana saamɓe ɓee, kaa omo moƴƴa e maa so nii aɗa ɲiiɓi e kii moƴƴuki. So wanaa ɗum, aan duu a saltete. ");
INSERT INTO ffm_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Israa'iilankooɓe duu, so ɓe ɲiiɓaali e salaare maɓɓe ndee, ɓe ndoboyte, sabi Laamɗo ana waawi dobirde ɓe e maangoroowi kii no ɓe caltiranoo nii. ");
INSERT INTO ffm_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Ndennoo aan iwɗo e maangoroowi ki tutaaka kii oo, so a saltaama iwde e makki a dobaama e maangoroowi tutaaki kii, haala walaa caɓe iwɗe e lekki tutaaki kii, so caltanooma ana mbaawi dobeede e inna mum'en. ");
INSERT INTO ffm_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Sakiraaɓe, miɗo yiɗi anndinde on oo ɗoo sirri, pati ƴeewron ko'e mon on hakkilante'en: yoga e Israa'iilankooɓe, ko'e mum'en tiiɗinaa faa nde ɓe nganaa Yahuudiyankooɓe goonɗinoyooɓe ɓee fuu kisinaa. ");
INSERT INTO ffm_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Hono non Israa'iilankooɓe ɓee fuu kisinirtee, no Binndi ɗii mbiiri nii: «Kisinoowo oo Siyona iwrata, mo ittan iwdi Yaakuuba fuu e geddi Laamɗo.» ");
INSERT INTO ffm_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","«Ɗum woni aadi am e maɓɓe wakkati mo tosoyan-mi luutti maɓɓe ɗii fuu.» ");
INSERT INTO ffm_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Ko ɓe calii Kabaaru Lobbo oo koo, Yahuudiyankooɓe ɓee laatorii konnee'en Laamɗo kammari mon. Kaa ko Laamɗo suɓii ɓe koo, ɓe laatike yiɓɓe mum saabe maamiraaɓe maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Sabi mimsee walaa e dokkal Laamɗo, kaɲum e noddaango mum. ");
INSERT INTO ffm_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","No calorino-ɗon Laamɗo arannde, keɓu-ɗon jooni yurmeende saabe salaare Yahuudiyankooɓe nii, ");
INSERT INTO ffm_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","hono non, jooni ɓe calorii mo yalla eɓe keɓa yurmeende kamɓe duu saabe yurmeende nde ngaɗana-ɗon ndee. ");
INSERT INTO ffm_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Sabi Laamɗo uddii yimɓe fuu e ley salaare, yalla omo yurmoo ɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Hee ngalu Laamɗo ana mawni! Hakkilantaaku makko e anndal makko ana luggiɗi! Fay gooto waawaa anndude anniyaaji makko. Fay gooto waawaa faamde laawi makko. ");
INSERT INTO ffm_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Sabi nii winndorii: «Homo anndi miilooji Joomiraaɗo? Naa homo waawi laataade howruujo makko?» ");
INSERT INTO ffm_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","«Homo adii hokkude mo sako o yoɓa ɗum?» ");
INSERT INTO ffm_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Sabi, huunde fuu e makko iwi, huunde fuu saabe makko woodiri, huunde fuu kanko woodani. Yo teddeengal woodan mo faa abada! Aamiina! ");
INSERT INTO ffm_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Ndennoo sakiraaɓe, miɗo ndaarda on saabe yurmeende Laamɗo ndee, cakkee ko'e mon laatoo sadaka guurɗo, ceniiɗo, belɗo Laamɗo. Ɗum woni dewal ngal kaan-ɗon rewirde mo ngal. ");
INSERT INTO ffm_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Pati ɲemmbee aduna, kaa ɗalee Laamɗo heyɗintina hakkillaaji mon yalla ɓerɗe mon ana mbaylitoo. Nden, on mbaawan anndude muuyɗe Laamɗo: ko moƴƴi e ko weli mo e ko hiɓɓi. ");
INSERT INTO ffm_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Saabe moƴƴere nde Laamɗo hokki kam ndee, miɗo wiya gooto e mon fuu: pati naɓee ko'e mon to on njottaaki. Ko kaan-ɗon waɗude dee, ƴeewron ko'e mon miilooji hakkilantaaku baarooji e goonɗinal ngal Laamɗo etani on ngal. ");
INSERT INTO ffm_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Gooto e men fuu ana jogii calɗi keewɗi, kaa calɗi ɗii fuu ngaldaa golle. ");
INSERT INTO ffm_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Hono non, enen e heewde fuu, en neɗɗo gooto e ley haɓɓagol men e Almasiihu, en fuu eɗen njeydaa no gooto fuu jeydiri e goɗɗo nii. ");
INSERT INTO ffm_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","En ndokkaama dokke ceertuɗe ɗe Laamɗo hokkiri en moƴƴere mum. Dokkaaɗo haaltude konngol ngol Laamɗo loowi e mum, haaltira ngol no hawrirta e goonɗinal nii. ");
INSERT INTO ffm_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Dokkaaɗo gollande deental goonɗinɓe Laamɗo, golla. Dokkaaɗo tinndinde tinndina. ");
INSERT INTO ffm_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Dokkaaɗo waajaade waajoo. Dokkitiroowo oo hokkira ɓernde laaɓunde. Hooreejo fuu ardoroo soobee. Jurmotooɗo yurmoroo neɗɗo dow seyo. ");
INSERT INTO ffm_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Jilli mon ɗii laatoo ɗi ngaldaa e naafigaaku. Ngoɗɗee ko boni, tiiɗee e ko moƴƴi. ");
INSERT INTO ffm_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Njiɗondiree jilli sakiraagu, gooto fuu teddina banndum faa ɓurna ɗum hoore mum. ");
INSERT INTO ffm_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Pati laatee nattuɓe, laatee soobirante'en, ndewiron Joomiraaɗo ɓerɗe laaɓuɗe, ");
INSERT INTO ffm_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","mbeltee e ley jikke oo, muɲee torra, pati ceeree e duwaawu. ");
INSERT INTO ffm_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Mballee seniiɓe Laamɗo ɓee e haajuuji mum'en ɗii, laatee jippinooɓe hoɓɓe, ");
INSERT INTO ffm_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","nduwanee torrooɓe on ɓee, nduwo-ɗon, pati kuɗon. ");
INSERT INTO ffm_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Mbeltodee e weltotooɓe ɓee, mboydee e woyooɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Laatodee miilooji gooti, laatee leyɗinkiniiɓe, pati mawninkinee, pati njogoree ko'e mon on hakkilante'en. ");
INSERT INTO ffm_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","So won gaɗuɗo on ko boni, pati njoɓtee ɗum. Ndaaree waɗude ko yimɓe fuu miilii ana moƴƴi. ");
INSERT INTO ffm_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Nguurdee e yimɓe fuu dow jam so ana waawi laataade, dow no mbaawru-ɗon. ");
INSERT INTO ffm_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Sakiraaɓe horsuɓe, pati njoɓtanee ko'e mon, ko kaan-ɗon waɗude dee, ɗalee tikkere Laamɗo ndee yoɓtanoo on. Sabi e ley Binndi ɗii Joomiraaɗo wii: «Miin yoɓtoytoo mi yoɓoyan ɓe.» ");
INSERT INTO ffm_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Nii winndorii kasen: «So gaɲo maa yolbii ɲamminaa ɗum, so ɗomɗii njarnaa ɗum. So a waɗii nii, a waɗan o yaagoo saabe ko o waɗi ko boni koo.» ");
INSERT INTO ffm_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Pati ɗal ko boni jaale, jaalora ko boni koo moƴƴere. ");
INSERT INTO ffm_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Yo gooto fuu ɗowtano laamiiɓe ɓee, sabi laamu walaa so wanaa iwruɗo to Laamɗo oo, kasen duu laamiiɓe ɓee Laamɗo lammini ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Saabe ɗum, neɗɗo fuu calaniiɗo laamu saliima yamiroore Laamɗo, caliiɗo yamiroore Laamɗo nee jukkete. ");
INSERT INTO ffm_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Gaɗoowo ko moƴƴi walaa ko huldata hooreeɓe ɓee, kuloowo ɓe dee, gaɗoowo ko boni. Aɗa yiɗi waasude hulde laamu naa? Ndennoo, waɗu ko moƴƴi, o yette. ");
INSERT INTO ffm_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Sabi laamu yo gollanoowo Laamɗo faa nafe. Kaa so tawii ko boni ngaɗataa, hul, sabi wanaa meere laamu wakkorii kaafaawi, o gollanoowo Laamɗo faa o tabintina jukkungo mum faade e gaɗoowo ko boni fuu. ");
INSERT INTO ffm_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Ndennoo, waajibi ɗowtano-ɗon laamiiɓe ɓee, wanaa saabe hulde jukkeede tan, pati hakkillaaji mon ɲiŋa on duu. ");
INSERT INTO ffm_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ɗum saabii so oɗon njoɓa lampo, sabi laamiiɓe ɓee e ley golle mum'en nanngugol lampo ngol, ɓe gollanooɓe Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ndokkee ɓe fuu hakkeeji maɓɓe. Ndokkee lampo mo kaan-ɗon hokkude lampo, ndokkon usuru mo kaan-ɗon hokkude usuru, kulon mo kaan-ɗon hulde, teddinon mo kaan-ɗon teddinde. ");
INSERT INTO ffm_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Pati ɲamaande fuu ɓiloo hakkunde mon so wanaa ɲamaande jilli. Homo fuu rewa banndum jilli. Sabi jiɗɗo neɗɗo hono mum fuu, tabintinii Sariya Muusaa oo. ");
INSERT INTO ffm_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","E ley ɗum, ɗii ɗoo kaɗaaɗi: «Pati jeenu, pati ɲaaɗu hoore, pati wujju, pati tuuye-ɗaa», kanji e jamirooje goɗɗe ɗee fuu eɗe kawriti e ndee ɗoo yamiroore wootere: «Njiɗiraa tanaa maa no njiɗir-ɗaa hoore maa nii.» ");
INSERT INTO ffm_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Jiɗɗo tanaa mum gollataa ɗum ko boni, ndennoo, jilli tabintinta Sariya oo. ");
INSERT INTO ffm_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Oɗon anndi wakkati mo ngon-ɗen e mum. Wakkati mo kaan-ɗon finde oo yonii. Sabi jooni kisindam ɓuri ɓadaade en diina nde naatuno-ɗen e goonɗinal ndee. ");
INSERT INTO ffm_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Jemma oo woɗɗiima, ɲalooma oo ɓattiima. Ndennoo, njoppen gollude golleeji nimre ɗii, ɓamen kaɓitorɗe fooyre, ");
INSERT INTO ffm_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","nguurden no haaniri, no wonɓe e fooyre ɲalooma nii, tawee wanaa e ley wanngiyaare e sigiro e ko soɓi e njaahilaaku e pooɗondiral e haasidaaku. ");
INSERT INTO ffm_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ɓoornoree Joomiraaɗo men Iisaa Almasiihu no kaddungal nii, pati kiinnee giɗaaɗe yonki mon, pati njokkon ɗe. ");
INSERT INTO ffm_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Njaɓɓee mo goonɗinal mum lo'i tawa on ɲiŋiraali ɗum ko woni e hakkille mum. ");
INSERT INTO ffm_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","To banngal ɲaamdu, oo ana tawree goonɗinal faa waawa ɲaamde huunde fuu, tawee ootoo goonɗinal mum ana lo'i faa waasa ɲaamde tew. ");
INSERT INTO ffm_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ɲaamoowo tew oo pati yawa mo ɲaamataa tew oo. Mo ɲaamataa tew oo pati ɲiŋa ɲaamoowo tew oo, sabi Laamɗo jaɓɓiima mo. ");
INSERT INTO ffm_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Aan, koɗum ngon-ɗaa faa ɲiŋaa gollanoowo goɗɗo? Mo heddoo tarsinaade naa mo saama, yo donngal kalfaaɗo makko oo. Kaa mo tarsinto faa gasa, sabi Joomiraaɗo ana waawi ɲiiɓinde mo. ");
INSERT INTO ffm_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","To banngal ɲalaaɗe, ooɗoo ana jogorii ɲalaaɗe ɗee ana ɓurdi moƴƴude, ootoo ana jogorii ɲalaaɗe ɗee fuu potu. Gooto fuu yo heɓu taƴoral e ley hakkille mum. ");
INSERT INTO ffm_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ɓurdinɗo ɲalaaɗe ɗee oo waɗirii ɗum kammari Joomiraaɗo. Kasen duu, ɲaamoowo ko yiɗi fuu oo waɗirii ɗum kammari Joomiraaɗo, sabi o yettan Laamɗo. Mo ɲaamataa tew oo waɗirii ɗum kammari Joomiraaɗo, o yettan Laamɗo kanko duu. ");
INSERT INTO ffm_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Sabi fay gooto e men wuuranaali hoore mum, kasen duu fay gooto e men maayanaali hoore mum. ");
INSERT INTO ffm_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","So en nguurii, Joomiraaɗo oo nguuran-ɗen, so en maayii, Joomiraaɗo oo maayan-ɗen. So en nguur naa so en maay, Joomiraaɗo oo jey en. ");
INSERT INTO ffm_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Sabi Almasiihu maayii, kasen duu wuurtii faa laatanoo wuurɓe e maayɓe fuu Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Aan, ko waɗi so aɗa ɲiŋa sakiike maa goonɗinɗo oo? Naa aan, ko waɗi so aɗa yawa sakiike maa goonɗinɗo oo? En fuu, en ndaroyto yeeso sarirde Laamɗo, ");
INSERT INTO ffm_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","sabi ana winndii: «Joomiraaɗo wii: ‹ Mi hunorike baawɗe am: Koppi fuu kofanto kam, gooto fuu sellinan miin woni Laamɗo. › » ");
INSERT INTO ffm_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Nden gooto men fuu jaabanto hoore mum yeeso Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Ɗum nee, pati pelondiren e ko'e men hankasen, ɓamee anniya reentaade e huunde fuu ko waawi fergitinde sakiike mon liɓa ɗum. ");
INSERT INTO ffm_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Saabe Joomiraaɗo men Iisaa miɗo taƴori ɲaamdu fuu harmaa e hoore mum. Kaa so neɗɗo miilii won harmundu, ɗum harmanan ɗum kaɲum. ");
INSERT INTO ffm_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","So a torrii sakiike maa goonɗinɗo oo saabe ɲaamdu maa, a jokkaali laawol jilli. Pati halku mo Almasiihu maayani oo saabe ɲaamdu maa nduu. ");
INSERT INTO ffm_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Ndennoo, ko keɓu-ɗon so taw-ɗon ana moƴƴi koo, pati waddana yimɓe haalde haala mbonka. ");
INSERT INTO ffm_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Sabi Laamu Laamɗo fawaaki e ɲaamdu naa e yardu, ko fawii e mum dee, fooccitaare e jam e seyo e ley haɓɓagol men e Ruuhu Ceniiɗo oo. ");
INSERT INTO ffm_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Golliranoowo Almasiihu hono non fuu, Laamɗo welete ɗum, yimɓe ɓee duu teddinan ɗum. ");
INSERT INTO ffm_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Ndennoo, tewten ɓeydude jam hakkunde men, kasen duu homo fuu tewta ko naɓata banndum yeeso e ley goonɗinal. ");
INSERT INTO ffm_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Pati bonnitin golle Laamɗo saabe ɲaamdu. So goonga, ɲaamdu fuu ana dagii, kaa so ɲaamdu ndu ɲaamataa nduu ana liɓa sakiike maa, ɲaamde ndu moƴƴaa. ");
INSERT INTO ffm_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Ko moƴƴi dee, waasude ɲaamde tew e waasude yarde doro, kaɲum e waasude waɗude huunde fuu ko fergitata sakiike mum. ");
INSERT INTO ffm_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Huunde fuu ko ngoonɗin-ɗaa hen, yo laato hakkunde maa e Laamɗo. Mo sikkitataako ko woni e hakkille mum, welii hoore! ");
INSERT INTO ffm_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Kaa neɗɗo fuu cikkitiiɗo e ko ɲaamata, jukkete, sabi joomum ɲaamirtaa goonɗinal. Huunde fuu ko waldaa e goonɗinal yo luuttal. ");
INSERT INTO ffm_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Enen selluɓe goonɗinal ɓee, eɗen kaani wallude ɓe goonɗinal mum lo'i ɓee, mbaasen tewtude ko weli en tan. ");
INSERT INTO ffm_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Gooto e men fuu yo tewtu ko welata tanaa mum, faa oon yaara yeeso e ley goonɗinal. ");
INSERT INTO ffm_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Sabi Almasiihu tewtaalino ko weli ɗum, kaa o wii no winndorii nii: «Bonkaaji bonkiiɓe ma ɗii e am njani.» ");
INSERT INTO ffm_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Ko winndanoo arannde e ley Binndi ɗii koo fuu, faa janngina en winndiraa, yalla muɲal e ɓerɗe ɓuuɓuɗe ɗe Binndi ɗii ndokkata en ɗee ana laatanoo en jikke. ");
INSERT INTO ffm_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Yo Laamɗo Jom muɲal, ɓuuɓinoowo ɓerɗe oo, hokku on laataade miilo wooto no Iisaa Almasiihu anndiniri on nii, ");
INSERT INTO ffm_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","faa teddiniron Laamɗo anniya gooto e daande wootere. Sabi kanko Laamɗo woni Baaba Iisaa Almasiihu Joomiraaɗo men oo. ");
INSERT INTO ffm_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Njaɓɓondiree no Almasiihu jaɓɓorii on nii, faa Laamɗo teddinee. ");
INSERT INTO ffm_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Miɗo wiya on: Almasiihu warii gollande Yahuudiyankooɓe faa hollita Laamɗo yo koolniiɗo. Sabi Almasiihu tabintinii podooje ɗe Laamɗo waɗannoo njaatiraaɓe Yahuudiyankooɓe ɗee ");
INSERT INTO ffm_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","yalla leɲi goɗɗi ɗii duu ana teddinira Laamɗo saabe yurmeende mum, no Binndi ɗii mbiiri nii: «Saabe ɗum, mi jaarete hakkunde leɲi, mi yimete faa teddina innde maa.» ");
INSERT INTO ffm_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Binndi ɗii mbii kasen: «Leɲi, mbeltodee e yimɓe Joomiraaɗo ɓee.» ");
INSERT INTO ffm_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Kasen: «Onon leɲi ɗii fuu, njettee Joomiraaɗo, yo yimɓe fuu njettu mo.» ");
INSERT INTO ffm_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Annabi Esaaya duu wii: «Iwɗo e Yessa waroyan, oon immoytoo faa laamoo leɲi ɗii, ɗi pawoyan jikke majji e makko.» ");
INSERT INTO ffm_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Yo Laamɗo Jom jikke oo hebbin on seyo e jam fuu e ley goonɗinal mon, yalla oɗon ɓeydoo heewde jikke saabe baawɗe Ruuhu Ceniiɗo oo! ");
INSERT INTO ffm_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Sakiraaɓe am, miin jaati miɗo taƴori oɗon moƴƴi sanne, oɗon keewi anndal, kasen duu oɗon mbaawi waajondirde. ");
INSERT INTO ffm_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Kaa ley ɓataaki oo miɗo suusi haalande on haalaaji yogaaji faa laaɓa faa mi miccintina on ɗi. Mi haaldii non saabe moƴƴere nde Laamɗo hokki kam ");
INSERT INTO ffm_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","nde waɗi kam gollanoowo Iisaa Almasiihu e ley ɓe nganaa Yahuudiyankooɓe ndee. Ko mbaajotoo-mi Kabaaru Lobbo oo koo yo golle ceniiɗo yalla ɓe nganaa Yahuudiyankooɓe ɓee ana laatoo sadaka belɗo Laamɗo mo Ruuhu Ceniiɗo oo senni. ");
INSERT INTO ffm_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ndennoo, e haɓɓagol am e Iisaa Almasiihu, miɗo waawi mantoraade golleeji ɗi ngollan-mi Laamɗo ɗii. ");
INSERT INTO ffm_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Sabi walaa fuu ko cuusu-mi haalde so wanaa ko baawɗe Almasiihu tabintini e ley golle am faa waddana ɓe nganaa Yahuudiyankooɓe ɓee ɗowtanaade Laamɗo. Haala am e golle am duu, ");
INSERT INTO ffm_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","Laamɗo tabintinirii ɗum baawɗe taagumansaaji e kaayɗe e ley baawɗe Ruuhu Laamɗo oo. Hono non njottinir-mi Kabaaru Lobbo haala Almasiihu oo nokkuuje ɗee fuu gila Urusaliima e seraaji mum faa leydi Illiriya. ");
INSERT INTO ffm_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Kasen duu, gila arannde anniya am yo waajaade Kabaaru Lobbo oo ɗo innde Almasiihu ndee yottanooki pati mi maha dow maadi neɗɗo goɗɗo, ");
INSERT INTO ffm_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","no Binndi ɗii mbiiri nii: «Ɓe njottinanooka haala makko ɓee njiyoyan, ɓe nanaalino kabaaru makko ana haalee ɓee paamoyan.» ");
INSERT INTO ffm_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Golle am oo haɗi kam warde to mooɗon too cili keewɗi. ");
INSERT INTO ffm_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Kaa jooni golle oo huuɓii ɗee ɗoo leyɗe, kasen duu ko njiɗu-mi warde to mooɗon koo waɗii duuɓi kuurɗi jooni. ");
INSERT INTO ffm_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","Miɗo yiɗi faŋude to mon so miɗo yaha Espaniya, mi wonda e mooɗon seeɗa, njooɓinon kam ko kasindinan-mi e laawol am ngol. ");
INSERT INTO ffm_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","Kaa jooni Urusaliima njahan-mi faa mi walla seniiɓe wonɓe ton ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Sabi deente goonɗinɓe gonɗe Makedoniya e Akaya ɗee anniyike hawrintinde kaalisi faa mballa misikiina'en jeyaaɓe e seniiɓe Urusaliima ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Ɓe anniyorii ɗum ɓerɗe laaɓuɗe, kaa eɓe kaani waɗande ɓeen ɗum duu. Sabi tawii ɓe nganaa Yahuudiyankooɓe ɓee keɓii ngeɗu e moƴƴereeji ɗi Ruuhu oo hokki Yahuudiyankooɓe ɓee ɗii, ndennoo, ɓe nganaa Yahuudiyankooɓe ɓee duu ana kaani feccude jawle mum'en e Yahuudiyankooɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","So ɗum yawtii, so mi hokkii ɓe ko hawrintinaa koo, mi ƴaɓɓorto to mooɗon too so miɗo yaha Espaniya. ");
INSERT INTO ffm_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Miɗo anndi so miɗo wara to mooɗon, mi wardan e barke Almasiihu kiɓɓuɗo oo. ");
INSERT INTO ffm_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","Sakiraaɓe, saabe Joomiraaɗo men Iisaa Almasiihu e saabe jilli ɗi Ruuhu oo hokkata ɗii, miɗo ndaarda on: kaɓodo-ɗon e am e ley duwaawuuji mon faade e Laamɗo saabe am, ");
INSERT INTO ffm_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","yalla miɗo daɗa e ɓe ngoonɗinaali wonɓe Yahuudiya ɓee, kasen seniiɓe wonɓe Urusaliima ɓee njaɓɓoo ballal ngal naɓanan-mi ɗum'en ngal. ");
INSERT INTO ffm_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Hono non, so Laamɗo muuyii, mi yottorto on weltaare, kasen duu mi fowta hakkunde mon. ");
INSERT INTO ffm_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Yo Laamɗo gaddoowo jam oo wondu e mon, on fuu. Aamiina! ");
INSERT INTO ffm_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Miɗo haalana on kabaaru banndii men debbo biyeteeɗo Febe, gollanoowo deental goonɗinɓe gonngal ley Kankiriya oo. ");
INSERT INTO ffm_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","Njaɓɓoro-ɗon mo e dow innde Joomiraaɗo no seniiɓe ɓee kaani waɗude nii, kasen duu mballee mo e huunde fuu ko mo hasindini e mum, sabi kanko duu o wallii heewɓe, miin e hoore am miɗo hen. ");
INSERT INTO ffm_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Miɗo jowta Piriskilla e Akilas, gollidooɓe e am golle Iisaa Almasiihu ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","Sabi ɓe kosii mursude yonkiiji maɓɓe faa ɓe ndannda yonki am. Wanaa miin tan yettata ɓe, deente goonɗinɓe ɓe nganaa Yahuudiyankooɓe ɗee fuu ana njetta ɓe. ");
INSERT INTO ffm_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Miɗo jowta deental goonɗinɓe kawroowal galle maɓɓe ngal fuu. Miɗo jowta Epaynetus, giɗo am korsuɗo oo. Kanko adii goonɗinde Almasiihu ley leydi Asiya fuu. ");
INSERT INTO ffm_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Miɗo jowta Mariyama tampanɗo on sanne oo. ");
INSERT INTO ffm_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Miɗo jowta Andoronikus e Yuniyas, suudu baabaaɓe am worɓe ɓe uddidanoo-mi kasu ɓee. Ɓe nelaaɓe teddinaaɓe, kasen duu kamɓe adii kam goonɗinde Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Miɗo jowta Ampiliyatus mo korsinir-mi saabe Joomiraaɗo oo. ");
INSERT INTO ffm_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Miɗo jowta Urbanus, gollidoowo e men golle Almasiihu oo, kaɲum e Estakis giɗo am korsuɗo oo. ");
INSERT INTO ffm_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Miɗo jowta Apelles mo goonɗinal mum Almasiihu horaa so tawaa ana laaɓi oo. Miɗo jowta galle Aristobil. ");
INSERT INTO ffm_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Miɗo jowta Herodiyon suudu baabaajo am oo. Miɗo jowta yimɓe galle Narsisi haɓɓiiɓe e Joomiraaɗo ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Miɗo jowta Tirifena e Tirifosa, ɓeen yo rewɓe gollanooɓe Joomiraaɗo. Miɗo jowta Persis mo korsin-mi, oon yo debbo tampuɗo sanne e ley gollande Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Miɗo jowta Rufus mo Joomiraaɗo suɓii oo, miɗo jowta inna makko mo nanngir-mi no innam nii, miin duu. ");
INSERT INTO ffm_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Miɗo jowta Asinkiriti e Felegon e Hermes e Patorobas e Hermasa e goonɗinɓe Iisaa wonduɓe e maɓɓe ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Miɗo jowta Filolog e Yuliya, miɗo jowta Nere e banndum debbo, kaɲum e Olimpas, miɗo jowta seniiɓe wonduɓe e maɓɓe ɓee fuu. ");
INSERT INTO ffm_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Gooto gooto mon fuu jowtira sakiike mum jowtaango wondungo e jilli. Deente goonɗinɓe Almasiihu ɗee fuu ana njowta on. ");
INSERT INTO ffm_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Sakiraaɓe, miɗo ndaarda on, ndeento-ɗon e waddooɓe ceeraagu e pergite saabe salagol mum'en jannde nde keɓu-ɗon ndee, ngoɗɗee ɓe! ");
INSERT INTO ffm_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Sabi yimɓe wa'uɓe non ngollantaa Joomiraaɗo men Almasiihu, ko ɓe ngollanta dee, deeɗi maɓɓe ɗii. Haalaaji maɓɓe belɗi e manooje maɓɓe jaayɗe ɓe majjinirta hakkillaaji yimɓe ɓe ƴoƴaa ɓee. ");
INSERT INTO ffm_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Kaa onon, kabaaru ɗowtaare mon yottike yimɓe fuu. Saabe ɗum miɗo weltanii on, kaa miɗo muuyani on laato-ɗon hakkilante'en banngal ko moƴƴi, laato-ɗon laaɓuɓe banngal ko boni. ");
INSERT INTO ffm_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Laamɗo gaddoowo jam oo waɗan niison Ibiliisa ley teppe mon ɓooyataa. Yo hinnee Joomiraaɗo men Iisaa wonu e mon! ");
INSERT INTO ffm_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timote gollidiiɗo am oo ana jowta on. Lukiyus e Yason e Sosipatoros suudu baabaaɓe am ɓee ana njowta on. ");
INSERT INTO ffm_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Miin, Tertiyus, binndanɗo Pool oo ɓataaki oo, miɗo jowta on saabe haɓɓagol meeɗen e Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus, njaatigi am mo deental goonɗinɓe ngal hawrata galle mum oo, ana jowta on. Erasta kalfinaaɗo kaalisi ngeenndi ndii oo ana jowta on, kaɲum e Kartus sakiike men oo.  ");
INSERT INTO ffm_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Jettooje ngoodanii Laamɗo baawɗo hokkude on semmbe oo. O hokkiran on ɗum Kabaaru Lobbo haala Iisaa Almasiihu mo mbaajii-mi oo. Oon Kabaaru Lobbo yo ɓanngugol sirri Laamɗo cuuɗanooɗo gila arannde ");
INSERT INTO ffm_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","kaa jooni o ɓannginaama. Dewte annabaaɓe anndinii ɗum leɲi ɗii fuu no Laamɗo duumiiɗo oo yamiri nii, faa ɗi ngoonɗina Laamɗo ɗi ɗowtanoo ɗum. ");
INSERT INTO ffm_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Yo teddeengal woodan Laamɗo gooto hakkilante oo faa abada saabe Iisaa Almasiihu. Aamiina!");
INSERT INTO ffm_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Oo ɓataaki ga amen iwri, miin Pool, kaɲum e sakiike men Sosteni. Miin Pool, mi noddiraaɗo sago Laamɗo faa mi laatoo nelaaɗo Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","Miɗen njowta deental goonɗinɓe Laamɗo gonngal ngalluure Korintu. Laamɗo laɓɓinirii on saabe Iisaa Almasiihu, noddii on faa laato-ɗon yimɓe mum, onon e noddooɓe innde Joomiraaɗo men Iisaa Almasiihu ɗo mbaawi wonde fuu. Sabi Iisaa yo Joomiraaɗo maɓɓe, yo Joomiraaɗo men. ");
INSERT INTO ffm_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Yo on keɓu moƴƴere e jam iwde e Baabiraaɗo men Laamɗo e Joomiraaɗo men Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Miɗo yetta Laamɗo saabe mon wakkati fuu dow moƴƴere makko nde ndokkire-ɗon Iisaa Almasiihu ndee. ");
INSERT INTO ffm_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Saabe makko on keɓii arsuku fuu e ley haala e ley anndal fuu. ");
INSERT INTO ffm_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Seedaaku amen haala Almasiihu ɲiiɓii e mon jaati, ");
INSERT INTO ffm_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","ɗum waɗi so on ɲakoraaka fay dokkal Laamɗo gootal e ley doomugol mon Joomiraaɗo men Iisaa Almasiihu faa warta. ");
INSERT INTO ffm_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Kanko hokkata on semmbe faa ɗo aduna haaɗi, yalla oɗon laatoo ɓe ngalaa ɲiŋe ɲannde gartol makko, kanko Joomiraaɗo men Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Laamɗo yo koolniiɗo, kanko noddi on kaɓɓo-ɗon e Ɓiyiiko Iisaa Almasiihu Joomiraaɗo men oo. ");
INSERT INTO ffm_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Sakiraaɓe, miɗo ndaarda on ɗum ɗoo e innde Joomiraaɗo men Iisaa Almasiihu: nanngondiree, laato-ɗon daande wootere, pati ceerton, laato-ɗon hakkille gooto e anniya gooto. ");
INSERT INTO ffm_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Sakiraaɓe am, mi narrii yimɓe suudu Kolowe pooɗondiral won hakkunde mon. ");
INSERT INTO ffm_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Ko njiɗu-mi wiide dee, yogaaɓe mon ana mbiya ana ngoodani Pool, woɓɓe ana mbiya ana ngoodani Apollos, woɓɓe duu ana mbiya ana ngoodani Piyeer, woɓɓe kasen duu ana mbiya ana ngoodani Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Tama Almasiihu yo pecciiɗo? Tama Pool maayani on dow leggal bardugal, naa e innde Pool lootira-ɗon lootogal batisima? ");
INSERT INTO ffm_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Mi yettirii Laamɗo ko mi lootaali fay gooto e mon lootogal batisima koo, so wanaa Kirispus e Gayus. ");
INSERT INTO ffm_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Non, fay gooto waawaa wiide e innde am lootira-ɗon lootogal batisima. ");
INSERT INTO ffm_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ooho, goonga mi batisiino kasen duu galle Istifanas. Ko yawti ɗum, mi anndaa yalla mi batisii goɗɗo. ");
INSERT INTO ffm_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Sabi Almasiihu nelaali kam mi batisa, ko mo neli kam dee, mi haala Kabaaru Lobbo oo, tawa mi haaliraali ɗum ɲeeɲal haala, pati maayde makko dow leggal bardugal ndee laatoo meere. ");
INSERT INTO ffm_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Haala maayde Iisaa dow leggal bardugal yo safiyaaku banngal halkotooɓe ɓee, kaa banngal men enen hisinteeɓe ɓee, ka baawɗe Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Sabi ana winndii: «Mi bonnitan hakkilantaaku hakkilante'en ɓee, mi jiiɓan faamu faamuɓe ɓee.» ");
INSERT INTO ffm_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Ndennoo, hakkilante won ko woni naa? Dunkee Sariya won ko woni naa? Baawɗo haala e oo jamaanu won ko woni naa? Wanaa Laamɗo waylitii hakkilantaaku oo aduna waɗii ɗum majjere naa? ");
INSERT INTO ffm_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Yimɓe aduna oo e hakkilantaaku mum'en fuu annditaali no Laamɗo holliri hoore mum e ley hakkilantaaku mum nii. Ɗum saabii so Laamɗo yiɗi hisinirde goonɗinɓe ɗum ɓee waaju amen nannduɗo e safiyaaku oo. ");
INSERT INTO ffm_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","Yahuudiyankooɓe ana ndaarta kaayɗe, Yunaninkooɓe ana njiɗi kaɲum'en hakkilantaaku. ");
INSERT INTO ffm_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Kaa enen, kabaaru tonteede Almasiihu e leggal bardugal mbaajoto-ɗen. Banngal Yahuudiyankooɓe ɗum metti, banngal leɲi goɗɗi ɗum safiyaaku. ");
INSERT INTO ffm_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Kaa banngal noddaaɓe ɓee, Yahuudiyankooɓe e leɲi goɗɗi fuu potu, Almasiihu yo baawɗe Laamɗo yo hakkilantaaku Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Sabi golle Laamɗo mo yimɓe njogorii yo safiyaaku oo ana ɓuri hakkilantaaku neɗɗo, kasen duu ko ɓe njogorii yo loore Laamɗo koo ana ɓuri semmbirantaaku neɗɗo. ");
INSERT INTO ffm_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Ƴeewee ko'e mon, onon sakiraaɓe ɓe Laamɗo noddi: banngal yimɓe, hakkilante'en keewaa e ley mon, jom'en semmbe keewaa e ley mon, iwɓe e leɲi tedduɗi keewaa e ley mon. ");
INSERT INTO ffm_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Kaa Laamɗo suɓike ko aduna jogorii yo safiyaaku koo faa hoyna hakkilante'en ɓee, ko aduna jogorii yo loore koo faa o hoyna ko jogii semmbe koo. ");
INSERT INTO ffm_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","O suɓike ko hoyi, ko yawnii, ko jataaka e aduna oo koo faa o waɗa ko jataa koo yo meere, ");
INSERT INTO ffm_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","yalla ɓii-aadama fuu ana ronka mantaade yeeso Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Kanko haɓɓi on e Iisaa Almasiihu faa Iisaa laatanii en hakkilantaaku iwɗo e Laamɗo, laatanii en fooccitaare e senaare e coottitaari ");
INSERT INTO ffm_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","faa «mantotooɗo fuu mantoroo golle Joomiraaɗo» hono no winndorii nii. ");
INSERT INTO ffm_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Sakiraaɓe, miin, nde ngarnoo-mi to mon faa mi waajoo on goonga Laamɗo tedduɗo oo ndee, mi waajoraaki on haalaaji belɗi, mi waajoraaki on hakkilantaaku yimɓe. ");
INSERT INTO ffm_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Sabi mi fellisiino mi waajataako on fay huunde so wanaa haala Iisaa Almasiihu e tonteede mum e leggal bardugal. ");
INSERT INTO ffm_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Nde ngondunoo-mi e mon ndee, miɗo lo'i, miɗo huli, miɗo siɲɲa sanne. ");
INSERT INTO ffm_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Haala am e waaju am fawanooki e ɲeeɲal haala jaalotoongal neɗɗo. Ko ɗum fawinoo e mum dee, baawɗe ɗe Ruuhu Ceniiɗo hollata ɗee ");
INSERT INTO ffm_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","pati goonɗinal mon fawoo e hakkilantaaku yimɓe, fawoo e baawɗe Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Ɗum e taweede, miɗen mbaajoo hakkilantaaku hakkunde ɲiiɓuɓe e ley goonɗinal. Wanaa hakkilantaaku oo ɗoo aduna min mbaajotoo naa hakkilantaaku jom'en baawɗe halkotooɓe e ley oo ɗoo jamaanu – ");
INSERT INTO ffm_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","hakkilantaaku Laamɗo min mbaajotoo. Hakkilantaaku oo yo goonga tedduɗo cuuɗaaɗo yimɓe mo Laamɗo fodani en gila aduna tagaaka faa naaten e teddeengal mum. ");
INSERT INTO ffm_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Fay gooto e adunankooɓe laamiiɓe ɓee anndaa oo hakkilantaaku, sabi sinndo eɓe anndunoo mo, ɓe tontataano Joomiraaɗo tedduɗo oo. ");
INSERT INTO ffm_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Kaa nii winndorii: «Ko yitere yiyaali nowru nanaali, e ko hakkille waddaali abada, ɗum jaati woni ko Laamɗo moƴƴinani yiɗuɓe ɗum.» ");
INSERT INTO ffm_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Kaa enen, Laamɗo hollirii en ɗum Ruuhu Ceniiɗo. Oon Ruuhu ana yiya fuu, fay ko luggiɗi to Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Homo waawi anndude neɗɗo faa laaɓa so wanaa yonki wonki e mum kii? Laamɗo duu hono non, fay gooto anndaa mo faa laaɓa so wanaa Ruuhu gonɗo e makko oo. ");
INSERT INTO ffm_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Enen, wanaa adunankaaku keɓ-ɗen, Ruuhu iwɗo e Laamɗo oo keɓ-ɗen, yalla eɗen annda moƴƴere nde Laamɗo waɗani en ndee fuu. ");
INSERT INTO ffm_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","So miɗen mbaajoo ɗum, min nawtortaako haalaaji ɗi hakkilantaaku ɓiɓɓe aadama waajotoo min ɗii – haalaaji ɗi Ruuhu oo waajotoo ɗii min nawtortoo. Hono non min pamminirta heɓuɓe Ruuhu ɓee goongaaji Ruuhu ɗii. ");
INSERT INTO ffm_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Mo heɓaali Ruuhu Laamɗo oo waawataa jaɓɓaade kulle oon Ruuhu, sabi ɗe safiyaaku ɗo joomum. O waawataa faamude ɗe, sabi Ruuhu oo tan waawi hollude no kulle ɗee carirtee. ");
INSERT INTO ffm_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Neɗɗo keɓuɗo Ruuhu oo, ana waawi sarde fuu, kaa fay gooto waawaa sarde ɗum. ");
INSERT INTO ffm_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","Sabi nii Binndi ɗii mbiiri: «Homo anndi anniya Joomiraaɗo oo? Homo waawi waajaade ɗum?» Kaa enen, anniya Almasiihu oo njogi-ɗen. ");
INSERT INTO ffm_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Miin noo, sakiraaɓe, mi waawaa haalirande on hono no on heɓuɓe Ruuhu Ceniiɗo nii. No kaaliran-mi on dee, hono no on adunankooɓe nii, hono no on cukaloy keccoy e ley goonɗinal Almasiihu ngal nii. ");
INSERT INTO ffm_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Ɓiraaɗam ndokku-mi on, wanaa ɲaamdu tekkundu, sabi on mbaawanaano ndu. Fay jooni duu, on mbaawanaa ndu, ");
INSERT INTO ffm_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","sabi adunankaaku tan nguurdu-ɗon tafon. Ko haasidaaku e pooɗondiral woni hakkunde mon koo, wanaa ɗum ana holla e oo ɗoo aduna njeya-ɗon? Wanaa eɗum holla nguurndam ɓii-aadama nguur-ɗon naa? ");
INSERT INTO ffm_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","So gooto e mon wii Pool woodani, goɗɗo kasen wii Apollos woodani, wanaa ɗum ana holla miilooji oo ɗoo aduna njokku-ɗon? ");
INSERT INTO ffm_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Ko Apollos woni? Ko Pool woni? Min gollanooɓe Laamɗo tan, gooto fuu ko Joomiraaɗo hokki ɗum. E juuɗe amen ngoonɗin-ɗon. ");
INSERT INTO ffm_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Miin, mi tutii, Apollos yarnii, kaa Laamɗo woni mawninoowo. ");
INSERT INTO ffm_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Hono non, tutuɗo oo e jarnuɗo oo fuu nganaa hen fay huunde, Laamɗo mawninoowo oo tan woni fuu. ");
INSERT INTO ffm_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Tutuɗo oo e jarnuɗo oo fuu potu, homo e maɓɓe fuu barjete ko waarata e tampere mum. ");
INSERT INTO ffm_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Sabi minen min gollidooɓe e Laamɗo, onon on ngesa Laamɗo, on maadi Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Kammari moƴƴere nde Laamɗo waɗani kam ndee, mi asii gasol no mahoowo hakkilante waɗata nii, mi waɗii mahol aranol. Jooni goɗɗo ana maha e maggol. Kaa gooto fuu waɗa hakkille e no mahirta nii. ");
INSERT INTO ffm_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Sabi fay gooto waawaa waɗude mahol gonngol so wanaa aranol ngol, kanngol woni Iisaa Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Neɗɗo ana ɲiɓa e maadi aranndeeri ndii kaŋŋe naa cardi naa kaaƴe dime naa leɗɗe naa huɗo naa gawƴe. ");
INSERT INTO ffm_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","Ɲannde gartol Almasiihu, neɗɗo fuu sariya ɓannginan fayda golle mum, sabi nden, neɗɗo fuu yiite ɓannginan golle mum, holla gooto fuu fayda golle mum. ");
INSERT INTO ffm_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Mo golle mum heddii daraade dow mahol aranol ngol, heɓan mbarjaari. ");
INSERT INTO ffm_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Kaa mo yiite ngee ɲaami golle mum, waasii mbarjaari mum, kaa kaɲum hisinte, ana wa'i no coɓɓitiiɗo e yiite nii. ");
INSERT INTO ffm_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Tama on anndaa on suudu Laamɗo, kasen Ruuhu Laamɗo oo ana e mon? ");
INSERT INTO ffm_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Ndennoo, neɗɗo fuu kalkuɗo suudu Laamɗo nduu, Laamɗo halkan ɗum. Sabi suudu Laamɗo nduu yo seniindu, kasen duu onon ngoni suudu nduu. ");
INSERT INTO ffm_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Pati fay gooto jaayra hoore mum. Miilɗo e mon yo hakkilante e oo aduna fuu yo laato safi, yalla ana laatoo hakkilante jaati. ");
INSERT INTO ffm_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Sabi hakkilantaaku e oo aduna yo safiyaaku yeeso Laamɗo. Sabi ana winndii: «Laamɗo nanngiran hakkilante'en ɓee hiila mum'en.» ");
INSERT INTO ffm_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Ana winndii kasen: «Joomiraaɗo ana anndi miilooji hakkilante'en ɓee, omo anndi ɗi meere.» ");
INSERT INTO ffm_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Ndennoo, pati fay gooto mantoroo yimɓe, sabi onon njey fuu: ");
INSERT INTO ffm_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Pool e Apollos e Piyeer, kaɲum e aduna oo, nguurndam e maayde, hannde e janngo, fuu onon njey. ");
INSERT INTO ffm_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Onon, Almasiihu jey on, Almasiihu duu, Laamɗo jey ɗum. ");
INSERT INTO ffm_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Ndennoo, njogoree min min gollanooɓe Almasiihu, njogoree min min halfinaaɓe goongaaji Laamɗo tedduɗi cuuɗaaɗi ɗii. ");
INSERT INTO ffm_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Kalfinaaɗo, hoolaare tan ndaardaa. ");
INSERT INTO ffm_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Jooni, banngal am, so on pelii kam naa so mi darnaama e sarirde ɓiɓɓe aadama wiyooɓe mi wanaa koolniiɗo, walanaa kam baasi. Mi felataa hoore am duu jaati. ");
INSERT INTO ffm_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","So goonga nii, fay so mi walaa ko mi felda hoore am, ɗum waɗataa kam mi pooccitiiɗo. Joomiraaɗo woni caroowo kam. ");
INSERT INTO ffm_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Saabe ɗum, pati pelee fay gooto fade wakkati oo yottaade, fade Joomiraaɗo oo warde. Kanko yaltinta ko suuɗinoo e nimre, kanko ɓannginta ko woni e ɓerɗe yimɓe. Ɲannde nden, gooto fuu heɓan e Laamɗo jettooje ɗe foti heɓude. ");
INSERT INTO ffm_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Sakiraaɓe, haalaaji ɗii fuu mi fawii ɗum dow amen miin e Apollos kammari mooɗon, yalla miɗen laatanoo on misaalu, paamon pati njawton ko winndii koo, tawa on mawninkinaaki e jaɓande ooɗoo e salanaade ootoo. ");
INSERT INTO ffm_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Ndennoo homo ɓurnu maa woɓɓe ɓee? Koɗum njogi-ɗaa ko a hokkaaka? Ko njogi-ɗaa fuu a dokkaaɗo, ko waɗi so aɗa mantoroo ɗum hono ɗum wanaa dokke Laamɗo? ");
INSERT INTO ffm_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Woy on kaarii, woy on keɓii arsuku, woy on laamiima, minen min laamaaki! Haya miɗen njiɗi laamo-ɗon jaati, yalla miɗen mbaawa laamodaade e mon minen duu! ");
INSERT INTO ffm_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Sabi ana nanndani kam, minen nelaaɓe ɓee, Laamɗo heedini min caggal no saraaɓe wareteeɓe nii. Sabi min laatike fijirteeɓe yeeso aduna oo fuu: yeeso malaa'ika'en e yimɓe fuu. ");
INSERT INTO ffm_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Min majjuɓe saabe Almasiihu, onon on hakkilante'en e haɓɓagol mon e Almasiihu. Min lo'uɓe, onon on jom'en semmbe. Min hoynaaɓe, onon on teddinaaɓe. ");
INSERT INTO ffm_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Fay wakkati mo ngon-ɗen e mum jooni oo, min ceeraali e yolbere e ɗomka e kolndam e fiyeede, kaɲum e yiilaaru, ");
INSERT INTO ffm_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","miɗen tiinnitoo wuurdude semmbe terɗe amen. So min njennaama, min nduwoto. So min torraama, min muɲan. ");
INSERT INTO ffm_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","So min ɲo'aama, min mbaaltinan hakkillaaji joomum'en. Faa jooni miɗen njogoraa no mbuuwdi nii ley aduna oo, hono tuundi ndi yimɓe fuu mbedotoo. ");
INSERT INTO ffm_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Mi winndiraali ɗum faa mi hersina on, ko mbinndir-mi ɗum dee, faa mi jannginira on no sukaaɓe am horsuɓe nii. ");
INSERT INTO ffm_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Fay so taweede e ley haɓɓagol mon e Almasiihu oɗon njogii ɗowooɓe ujunaaji ujunaaji, on keewaa baabiraaɓe kaa. Sabi e haɓɓagol mon e Almasiihu, miin laatii baaba mon nde mbaajii-mi on Kabaaru Lobbo oo ndee. ");
INSERT INTO ffm_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Ɗum waɗi so miɗo ndaarda on ɲemmbon kam. ");
INSERT INTO ffm_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Ɗum waɗi duu so nel-mi e mon Timote ɓiyam korsuɗo koolniiɗo e ley haɓɓagol mum e Joomiraaɗo. O miccintinan on laawi ɗi njokku-mi saabe Almasiihu e no mbaajortoo-mi ɗiin laawi nii nokku fuu e ley deente goonɗinɓe ɗee fuu. ");
INSERT INTO ffm_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Won e mon mawninkiniiɓe dow jikkude mi warataa to mon. ");
INSERT INTO ffm_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Kaa ɓooyataa mi waran to mon so Joomiraaɗo jaɓii. Nden mi humpitoto ko wanaa haala mawninkiniiɓe ɓee tan, mi humpitoto baawɗe mum'en duu. ");
INSERT INTO ffm_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Sabi Laamu Laamɗo wanaa haala tan, yo baawɗe. ");
INSERT INTO ffm_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Hono njiɗ-ɗon mi warda e mon? Sawru naa jilli e newaare? ");
INSERT INTO ffm_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Haya, ko soɓi nanaama waɗii hakkunde mon. Hono ndee somnde waɗaali fay hakkunde heeferɓe: gooto e mon ana wondi e jom suudu baam mum! ");
INSERT INTO ffm_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Kasen duu oɗon mantoroo ɗum! Ko kaanno-ɗon waɗude dee, metteede ɗum, yalla oɗon itta gaɗuɗo oo golle bonɗo e hakkunde mon. ");
INSERT INTO ffm_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Miin, miɗo woɗɗorii on banngal terɗe, kaa miɗo ɓattorii on e hakkille. Gila jooni hono no mi tawaaɗo ton nii, mi sarii gaɗuɗo golle oo. ");
INSERT INTO ffm_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","So on kawritii e dow innde Joomiraaɗo men Iisaa, hakkille am ana tawdee e mon, baawɗe Joomiraaɗo men Iisaa duu ana e men, ");
INSERT INTO ffm_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","yo oon neɗɗo waɗe e juuɗe Ibiliisa, terɗe mum kalkee, yalla yonki mum ana hisinee ɲannde gartol Joomiraaɗo. ");
INSERT INTO ffm_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","So goonga dee, on ngalaa ko mantoro-ɗon fey! Tama on anndaa ƴuufinirdi seeɗa ana ƴuufina conndi farani njiiɓaandi fuu? ");
INSERT INTO ffm_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Laɓɓinee ko'e mon, itton ƴuufinirdi kiinndi ndii hakkunde mon, yalla oɗon laatoo conndi farani njiiɓaandi keyri ndi walaa ƴuufinirdi. Non ngorru-ɗon jaati, sabi layyaari men iidi Paska ndii hirsaama, ɗum woni Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Ndennoo, teddiniren iidi oo ko wanaa luutti e bone hono no ƴuufinirdi kiinndi naa ƴuufinirdi coɓundi naa mbonndi. Teddiniren mo buuru mo walaa ƴuufinirdi, buuru laaɓal kaɲum e goonga. ");
INSERT INTO ffm_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","E ɓataaki mo mbinndunoo-mi e mon oo, mi wii on e ley makko pati nawtondiron e soɓuɓe. ");
INSERT INTO ffm_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Nde mbiinoo-mi non ndee, mi faandoraakino soɓuɓe wonɓe e oo ɗoo aduna ɓee fuu, naa haasidi'en fuu naa wuyɓe fuu naa rewooɓe tooruuji fuu. So non fii worri, waajibi njalton aduna oo. ");
INSERT INTO ffm_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Ko njiɗunoo-mi wiide on, pati nawtondiron e innditortooɗo sakiike tawee yo coɓuɗo naa haasidi naa dewoowo tooruuji naa ɲo'oowo yimɓe naa jaroowo doro naa gujjo. Baaɗo hono non, pati ɲaamdon e mum duu. ");
INSERT INTO ffm_vpl VALUES ("C15_12","076_5_12","1CO","5","12","13","Sabi ɓe ngalaa e ley deental goonɗinɓe Laamɗo ngal ɓee, wanaa miin sarata ɓe, Laamɗo sarata ɓe. Kaa wonɓe ley deental goonɗinɓe Laamɗo ngal ɓee, onon carata ɗum'en. Sabi nii winndorii: «Ittee neɗɗo bonɗo oo e ley mon.» ");
INSERT INTO ffm_vpl VALUES ("C16_1","076_6_1","1CO","6","1","1","So luurral waɗii hakkunde mon, hono joomum'en cuusirta wullitaade ooɲiiɓe ɓee njoppa fooccitiiɓe ɓee? ");
INSERT INTO ffm_vpl VALUES ("C16_2","076_6_2","1CO","6","2","2","Tama on anndaa fooccitiiɓe ɓee caroyta aduna oo? Ndennoo, so onon fooccitiiɓe ɓee caroyta aduna oo, hono ndonkirton sarde kulle pamare ɗee? ");
INSERT INTO ffm_vpl VALUES ("C16_3","076_6_3","1CO","6","3","3","Tama on anndaa enen caroyta malaa'ika'en ɓee? Sako kulle ɗam ɗoo nguurndam! ");
INSERT INTO ffm_vpl VALUES ("C16_4","076_6_4","1CO","6","4","4","Ndennoo, so luurral waɗii hakkunde mon banngal kulle aduna, ko saabii so oɗon ngullitoyoo ɓe deental goonɗinɓe ngal jataaki ɓee? ");
INSERT INTO ffm_vpl VALUES ("C16_5","076_6_5","1CO","6","5","5","Faa njaago-ɗon mbiiru-mi non. Tama on ngalaa fay hakkilante gooto baawɗo sarde sakiraaɓe luurruɓe? ");
INSERT INTO ffm_vpl VALUES ("C16_6","076_6_6","1CO","6","6","6","Ee, goonɗinɗo wullanoo goonɗinɗo banndum, tawa to ɓe ngoonɗinaali! ");
INSERT INTO ffm_vpl VALUES ("C16_7","076_6_7","1CO","6","7","7","Haya, ko cardaton e mum hakkunde mon koo duu yo ayiibe bonɗo jaati. Ko saabii so on cuɓaaki muɲude tooɲannge? Ko saabii so on cuɓaaki muɲude ɓoleede? ");
INSERT INTO ffm_vpl VALUES ("C16_8","076_6_8","1CO","6","8","8","Kaa onon tooɲata, onon ɓolata fay sakiraaɓe mon. ");
INSERT INTO ffm_vpl VALUES ("C16_9","076_6_9","1CO","6","9","9","Tama on anndaa ooɲiiɓe naatataa e Laamu Laamɗo oo? Pati njaayree ko'e mon: soɓuɓe e rewooɓe tooruuji e jeenooɓe e luuɗunkooɓe ");
INSERT INTO ffm_vpl VALUES ("C16_10","076_6_10","1CO","6","10","10","e wuyɓe e haasidi'en e yarooɓe doro e ɲo'ooɓe yimɓe e yanooɓe, fay gooto e ɓee naatataa e Laamu Laamɗo oo. ");
INSERT INTO ffm_vpl VALUES ("C16_11","076_6_11","1CO","6","11","11","Yoga mon laatinoke hono non, kaa jooni on lootaama on laaɓii, on nanngiraama fooccitiiɓe saabe innde Joomiraaɗo men Iisaa Almasiihu, kaɲum e Ruuhu Laamɗo men oo. ");
INSERT INTO ffm_vpl VALUES ("C16_12","076_6_12","1CO","6","12","12","Oɗon mbiya: «Huunde fuu ana daganii kam.» Ooho, kaa wanaa fuu nafata. So goonga «huunde fuu ana daganii kam», kaa miɗo salii huunde fuu mara kam. ");
INSERT INTO ffm_vpl VALUES ("C16_13","076_6_13","1CO","6","13","13","Oɗon mbiya: «Ɲaamdu jey reedu, reedu jey ɲaamdu.» Ooho, kaa Laamɗo halkan ɗi ɗiɗi fuu. Terɗe ɓii-aadama tagiraaka kammari ko soɓi, ko ɗe tagiraa dee, faa ɗe ndewa Joomiraaɗo, Joomiraaɗo duu hayba ɗe. ");
INSERT INTO ffm_vpl VALUES ("C16_14","076_6_14","1CO","6","14","14","Laamɗo immintinɗo Joomiraaɗo men iwde e maayde oo, immintiniran en enen duu e baawɗe mum. ");
INSERT INTO ffm_vpl VALUES ("C16_15","076_6_15","1CO","6","15","15","Tama on anndaa terɗe mon ngoni calɗi Almasiihu? Ndennoo, ana dagoo mi ɓama calɗi Almasiihu ɗii mi waɗa ɗum calɗi debbo coottoowo hoore mum? Abada! ");
INSERT INTO ffm_vpl VALUES ("C16_16","076_6_16","1CO","6","16","16","Tama on anndaa piilondirɗo e debbo coottoowo hoore mum fuu, laatodike e mum terɗe goote? Sabi ana winndii: «Ɓe ɗiɗon fuu ɓe laatoto neɗɗo gooto.» ");
INSERT INTO ffm_vpl VALUES ("C16_17","076_6_17","1CO","6","17","17","Kaa kaɓɓondirɗo e Joomiraaɗo laatodike e mum ruuhu gooto. ");
INSERT INTO ffm_vpl VALUES ("C16_18","076_6_18","1CO","6","18","18","Ndogee ko soɓi! Luuttal fuu ngal neɗɗo luutti, takkataako e terɗe mum. Kaa coɓinɗo hoore mum tooɲii terɗe mum. ");
INSERT INTO ffm_vpl VALUES ("C16_19","076_6_19","1CO","6","19","19","Tama on anndaa terɗe mon ɗee ngoni suudu Ruuhu Ceniiɗo gonɗo e mon mo Laamɗo hokki on oo? Wanaa onon njey ko'e mon, ");
INSERT INTO ffm_vpl VALUES ("C16_20","076_6_20","1CO","6","20","20","sabi Laamɗo soottitorii on coggu tiiɗuɗo. Ndennoo, teddiniree Laamɗo terɗe mon ɗee. ");
INSERT INTO ffm_vpl VALUES ("C17_1","076_7_1","1CO","7","1","1","Jooni kaa miɗo yiɗi jaabaade lamndi ɗi mbinndan-ɗon kam ɗii. Goonga, ana moƴƴi e gorko waasude ɓamde debbo. ");
INSERT INTO ffm_vpl VALUES ("C17_2","076_7_2","1CO","7","2","2","Kaa pati fijirde waɗa, gorko fuu yo tawre debbo, debbo duu tawree gorko. ");
INSERT INTO ffm_vpl VALUES ("C17_3","076_7_3","1CO","7","3","3","Yo gorko hokku genndum hakke mum, debbo duu hokka gorum hakke mum. ");
INSERT INTO ffm_vpl VALUES ("C17_4","076_7_4","1CO","7","4","4","Debbo jeyaa terɗe mum, gorum jey ɗe. Gorko duu hono non, jeyaa terɗe mum, genndum oo jey ɗe. ");
INSERT INTO ffm_vpl VALUES ("C17_5","076_7_5","1CO","7","5","5","Pati fay gooto e mon salanoo goɗɗo so wanaa tawee e dow kawral mon wakkati keertaaɗo faa keɓon no ɲaagoro-ɗon Laamɗo. Kaa caggal ɗum, keddo-ɗon wuurdude no haaniri nii pati mbaason nantaade so Ibiliisa seytoo on. ");
INSERT INTO ffm_vpl VALUES ("C17_6","076_7_6","1CO","7","6","6","Ko kaalan-mi on ɗoo koo, wanaa ko tilsi, mi kolluɗo on laawol lobbol nii. ");
INSERT INTO ffm_vpl VALUES ("C17_7","076_7_7","1CO","7","7","7","Miin, miɗo yiɗi yimɓe fuu laatoo hono am, kaa gooto fuu no Laamɗo hokkiri ɗum: yoga hokkiraa nii enne, yoga hokkiraa nii too. ");
INSERT INTO ffm_vpl VALUES ("C17_8","076_7_8","1CO","7","8","8","Faade e ɓe ɓamaali e ɓe ɓamaaka, kaɲum e rewɓe ɓe worɓe mum'en maayi, miɗo wiya worrude no am nii ɓuri moƴƴude e mum'en. ");
INSERT INTO ffm_vpl VALUES ("C17_9","076_7_9","1CO","7","9","9","Kaa so tawii ɓe mbaawaa nantaade, ɓe ndewla, sabi ɗum ɓuri jooɗoraade nii tan ana maaya muuyo. ");
INSERT INTO ffm_vpl VALUES ("C17_10","076_7_10","1CO","7","10","10","Wonɓe e dewle ɓee, miɗo yamira ɗum'en ndee yamiroore nde iwaali e am, iwnde e Joomiraaɗo: debbo haanaa seerde gorum. ");
INSERT INTO ffm_vpl VALUES ("C17_11","076_7_11","1CO","7","11","11","So taweede mo seerii oon yo heddoro non, naa duu o warta e mum. Gorko duu haanaa seerde genndum. ");
INSERT INTO ffm_vpl VALUES ("C17_12","076_7_12","1CO","7","12","12","Kaa woɓɓe ɓee, miin e hoore am haalanta ɗum'en, wanaa Joomiraaɗo: so goonɗinɗo Iisaa ana jogii debbo mo goonɗinaali tawee debbo oo ana yarrii wondude e makko, pati o seera ɗum. ");
INSERT INTO ffm_vpl VALUES ("C17_13","076_7_13","1CO","7","13","13","Naa so debbo goonɗinɗo ana dewlaa gorko mo goonɗinaali tawee gorko oo yarrii wondude e makko, pati o seera ɗum. ");
INSERT INTO ffm_vpl VALUES ("C17_14","076_7_14","1CO","7","14","14","Sabi gorko mo goonɗinaali oo ana laɓɓiniree genndum, kasen duu debbo mo goonɗinaali oo ana laɓɓiniree gorum. So wanaa ɗum, ɓiɓɓe mon laatoto ɓe anndaa Laamɗo, tawee nee ɓe seniiɓe. ");
INSERT INTO ffm_vpl VALUES ("C17_15","076_7_15","1CO","7","15","15","Kaa mo goonɗinaali, so yiɗii seerde goonɗinɗo oo, yo seer. Goonɗinɗo oo kaa, so debbo so gorko, tilsinaaka e dewgal ngal, sabi Laamɗo noddii en faa nguuren e jam. ");
INSERT INTO ffm_vpl VALUES ("C17_16","076_7_16","1CO","7","16","16","Debbo goonɗinɗo, hono anndirtaa aɗa waawi hisinde gora? Gorko goonɗinɗo, hono anndirtaa aɗa waawi hisinde gennda? ");
INSERT INTO ffm_vpl VALUES ("C17_17","076_7_17","1CO","7","17","17","Ɗum nee, yo gooto fuu wuurdu no Joomiraaɗo feccirani ɗum nii, no worrunoo nde Laamɗo noddi ɗum ndee. Ɗum njamir-mi deente goonɗinɓe ɗee fuu. ");
INSERT INTO ffm_vpl VALUES ("C17_18","076_7_18","1CO","7","18","18","Tawaaɗo yo taadiiɗo nde Laamɗo noddi ɗum ndee, pati tewta bonnitidde ko taadaa koo. Noddaaɗo so tawi taadaaki, pati taado. ");
INSERT INTO ffm_vpl VALUES ("C17_19","076_7_19","1CO","7","19","19","Taadaade e waasude taadaade fuu walaa ko nafata, ko nafata dee, jokkude jamirooje Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("C17_20","076_7_20","1CO","7","20","20","Yo gooto fuu heddoro no worrunoo wakkati nde Laamɗo noddata ɗum ndee. ");
INSERT INTO ffm_vpl VALUES ("C17_21","076_7_21","1CO","7","21","21","Nde noddete-ɗaa ndee, so tawii a diimaajo, pati ɗum laatane sugulla. Kaa so a heɓii laawol no ndimɗiraa, rimɗu. ");
INSERT INTO ffm_vpl VALUES ("C17_22","076_7_22","1CO","7","22","22","Sabi maccuɗo mo Joomiraaɗo noddi, laatike coottitaaɗo Joomiraaɗo. Dimo noddaaɗo duu, laatike diimaajo Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C17_23","076_7_23","1CO","7","23","23","On coottitoraama coggu tiiɗuɗo, ndennoo pati laatee maccuɓe yimɓe. ");
INSERT INTO ffm_vpl VALUES ("C17_24","076_7_24","1CO","7","24","24","Sakiraaɓe, gooto fuu no worrunoo nde noddetee ndee, yo heddoro non yeeso Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("C17_25","076_7_25","1CO","7","25","25","Banngal yimɓe ɓe ndewlaali ɓee, mi walanaa ɓe yamiroore iwnde to Joomiraaɗo, kaa mi haalan ko woni miilo am, miin mo yurmeende Joomiraaɗo waɗi koolniiɗo oo: ");
INSERT INTO ffm_vpl VALUES ("C17_26","076_7_26","1CO","7","26","26","saabe torraaji jooni ɗii, miɗo miila neɗɗo heddoroo no worri nii ɓuri moƴƴude e mum. ");
INSERT INTO ffm_vpl VALUES ("C17_27","076_7_27","1CO","7","27","27","So dewgal won hakkunde maa e debbo, pati tewtaa taƴude ngal. So dewgal walaa hakkunde maa e debbo, pati tewtaa debbo. ");
INSERT INTO ffm_vpl VALUES ("C17_28","076_7_28","1CO","7","28","28","Kaa so a ɓamii duu, a luuttaali. Mboomri duu so ɓamaama, luuttaali. Kaa naatuɓe e dewle ɓee ɓilloto e nguurndam mum'en, mi yiɗanaa on ɗum. ");
INSERT INTO ffm_vpl VALUES ("C17_29","076_7_29","1CO","7","29","29","Sakiraaɓe, ko kaalunoo-mi koo annii: wakkati oo ɓadike. Jooni, yo ɓamɓe ɓee mba'u no ɓamaali nii, ");
INSERT INTO ffm_vpl VALUES ("C17_30","076_7_30","1CO","7","30","30","woyooɓe mba'a no mboyaali nii, weltiiɓe mba'a no mbeltaaki nii, soodooɓe mba'a no njogaaki nii, ");
INSERT INTO ffm_vpl VALUES ("C17_31","076_7_31","1CO","7","31","31","heɓooɓe e oo ɗoo aduna mba'a no meeɗaali heɓude e makko nii. Sabi oo ɗoo aduna no wa'i nii, annii yawta. ");
INSERT INTO ffm_vpl VALUES ("C17_32","076_7_32","1CO","7","32","32","Ko njiɗu-mi dee, ceerton e sugulla. Mo dewlaali, hakkille mum to kulle Joomiraaɗo yahata, ko welata Joomiraaɗo tewtata. ");
INSERT INTO ffm_vpl VALUES ("C17_33","076_7_33","1CO","7","33","33","Kaa dewluɗo, hakkille mum to kulle aduna yahata, ko welata genndum tewtata, ");
INSERT INTO ffm_vpl VALUES ("C17_34","076_7_34","1CO","7","34","34","joomum fecciima. Hono non, mo ɓamaaka, kaɲum e mboomri, hakkille mum to kulle Joomiraaɗo yahata, yalla terɗe mum e yonki mum fuu ana cenoo. Kaa ɓamaaɗo, hakkille mum to kulle aduna yahata, ko welata gorum tewtata. ");
INSERT INTO ffm_vpl VALUES ("C17_35","076_7_35","1CO","7","35","35","Faa nafa on mbiiru-mi non, wanaa faa tonnga on. Miɗo yiɗi nguurdon no kaan-ɗon wuurdude nii, kaɓɓo-ɗon e Joomiraaɗo, tawa hakkillaaji mon peccaaki. ");
INSERT INTO ffm_vpl VALUES ("C17_36","076_7_36","1CO","7","36","36","So muuyo mawnii e neɗɗo sanne faa huli pati ronka nantaade e cabbaaɗo mum, miila dewgal ngal ana haani timmineede, yo ngal timmine no joomum yiɗiri nii, luuttaali. ");
INSERT INTO ffm_vpl VALUES ("C17_37","076_7_37","1CO","7","37","37","Kaa so gorko fellisii e ɓernde mum fuu tawa tilsinaaka, faa ɓami anniya huurtintaa cabbaaɗo mum, so ana waawi nantaade, waɗii ko moƴƴi. ");
INSERT INTO ffm_vpl VALUES ("C17_38","076_7_38","1CO","7","38","38","E ley ɗum, kuurtinɗo cabbaaɗo mum waɗii ko moƴƴi, kaa mo huurtinaali cabbaaɗo mum ɓuri waɗude ko moƴƴi. ");
INSERT INTO ffm_vpl VALUES ("C17_39","076_7_39","1CO","7","39","39","Debbo ɓamaaɗo yo kaɓɓaaɗo so nii gorum ana heddii wuurde. Kaa so goriiko oo yawtii, mo o yiɗi fuu ana waawi ɓamde mo, yo tawe e laawol Joomiraaɗo ngol tan. ");
INSERT INTO ffm_vpl VALUES ("C17_40","076_7_40","1CO","7","40","40","Ɗum nee, so o heddiima e ngoortaalaaku o ɓurata welde hoore. Ɗum woni miilo am, kasen duu miɗo miila miin duu, mi heɓii Ruuhu Laamɗo. ");
INSERT INTO ffm_vpl VALUES ("C18_1","076_8_1","1CO","8","1","1","Jooni miɗo jaaboo lamndal mon banngal tew cakkanaaɗo tooruuji ɗii. Eɗen taƴori «en fuu eɗen njogii anndal». «Anndal» nee waddan mawninkinaare, jilli ngoni ko naɓata deental goonɗinɓe ngal yeeso. ");
INSERT INTO ffm_vpl VALUES ("C18_2","076_8_2","1CO","8","2","2","Neɗɗo fuu miiluɗo ana anndi huunde, anndaa tafon no haani anndirde. ");
INSERT INTO ffm_vpl VALUES ("C18_3","076_8_3","1CO","8","3","3","Kaa neɗɗo fuu jiɗɗo Laamɗo, Laamɗo ana anndi ɗum. ");
INSERT INTO ffm_vpl VALUES ("C18_4","076_8_4","1CO","8","4","4","Ndennoo e banngal ɲaamugol tew cakkanaaɗo tooruuji, eɗen anndi «so goonga, ley aduna, tooru wanaa fay huunde», «Laamɗo walaa so wanaa gooto oo». ");
INSERT INTO ffm_vpl VALUES ("C18_5","076_8_5","1CO","8","5","5","Sabi fay so ko yimɓe mbiyata reweteeɓe koo ana ngoodi dow kammu e dow leydi – so goonga, wiyeteeɓe «reweteeɓe» e «joomiraaɓe» keewii – ");
INSERT INTO ffm_vpl VALUES ("C18_6","076_8_6","1CO","8","6","6","enen, banngal men, Laamɗo gooto tan woodi, Baabiraaɗo taguɗo huunde fuu mo nguuran-ɗen oo. Kasen Joomiraaɗo gooto tan woodi, Iisaa Almasiihu mo huunde fuu laatorii oo, mo keɓir-ɗen nguurndam oo. ");
INSERT INTO ffm_vpl VALUES ("C18_7","076_8_7","1CO","8","7","7","Kaa wanaa yimɓe fuu paami ɗum tafon. Yogaaɓe woownooɓe rewde tooruuji, faa hannde eɓe ɲaama tew cakkanaaɗo tooruuji e miilde tew oo tooruuji jaati njey ɗum. Ɗum waɗata so eɓe miila ɓe coɓan, tawi ɓe mbaawaa seenndude goonga e pene. ");
INSERT INTO ffm_vpl VALUES ("C18_8","076_8_8","1CO","8","8","8","Taƴoral, ɲaamdu ɓattintaa en Laamɗo. So en ɲaamii, nafataa en fay huunde, so en ɲaamaali, bonnantaa en fay huunde. ");
INSERT INTO ffm_vpl VALUES ("C18_9","076_8_9","1CO","8","9","9","Goonga, on ndokkaama laawol faa mbaawon ɲaamde huunde fuu. Kaa ndeentee pati ngol laawol liɓa ɓe ɲiiɓaali e ley goonɗinal ɓee. ");
INSERT INTO ffm_vpl VALUES ("C18_10","076_8_10","1CO","8","10","10","Sabi aan annduɗo goonga oo, so lo'uɗo yii ma aɗa ɲaama ley suudu tooru, hakkille mum hokkataa ɗum ɲaamde tew cakkanaaɗo tooruuji kaɲum duu naa? ");
INSERT INTO ffm_vpl VALUES ("C18_11","076_8_11","1CO","8","11","11","Hono non, oon sakiike men lo'uɗo mo Almasiihu maayani oo, halkortoo saabe anndal maa ngal. ");
INSERT INTO ffm_vpl VALUES ("C18_12","076_8_12","1CO","8","12","12","So on tooɲirii non sakiraaɓe ɓe ɲiiɓaali e ley goonɗinal ɓee, so on njiiɓii hakkillaaji maɓɓe, on luuttii Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C18_13","076_8_13","1CO","8","13","13","Ɗum nee, so tawii ɲaamdu ana liɓa sakiike am, mi ɲaamataa kasen tew abada, pati mi liɓa sakiike am. ");
INSERT INTO ffm_vpl VALUES ("C19_1","076_9_1","1CO","9","1","1","Mi jeyaa hoore am naa? Mi laataaki nelaaɗo naa? Mi yiyaali Joomiraaɗo men Iisaa naa? Goonɗinal mon, wanaa e ley golle mo ngollan-mi Joomiraaɗo oo iwi naa? ");
INSERT INTO ffm_vpl VALUES ("C19_2","076_9_2","1CO","9","2","2","Fay so banngal yogaaɓe mi wanaa nelaaɗo, banngal mon onon mi nelaaɗo, sabi ko ngoonɗin-ɗon Iisaa koo ana holla Joomiraaɗo neli kam jaati. ");
INSERT INTO ffm_vpl VALUES ("C19_3","076_9_3","1CO","9","3","3","Annii ko mbiyan-mi felooɓe kam ɓee: ");
INSERT INTO ffm_vpl VALUES ("C19_4","076_9_4","1CO","9","4","4","min kaandaa e heɓude ɲaamdu e yardu e ley golle amen naa? ");
INSERT INTO ffm_vpl VALUES ("C19_5","076_9_5","1CO","9","5","5","Min kaandaa e naɓorde rewɓe amen no nelaaɓe woɓɓe ɓee nii naa? No miɲiraaɓe Joomiraaɗo ɓee nii, kaɲum e Piyeer? ");
INSERT INTO ffm_vpl VALUES ("C19_6","076_9_6","1CO","9","6","6","Naa miin e Barnabas tan ngoni haanɓe gollude faa keɓa no nguurda? ");
INSERT INTO ffm_vpl VALUES ("C19_7","076_9_7","1CO","9","7","7","Homo e mon yii sordaasi joɓoowo hoore mum? Homo woni demoowo mo ɲaamataa ko hetti e ngesa mum? Homo woni duroowo mo yarataa kosam sewre mum? ");
INSERT INTO ffm_vpl VALUES ("C19_8","076_9_8","1CO","9","8","8","Ko kaalan-mi koo, e dow miilooji yimɓe tan fawii naa? Sariya oo yamiraali ɗum naa? ");
INSERT INTO ffm_vpl VALUES ("C19_9","076_9_9","1CO","9","9","9","Sabi nii winndiraa e Sariya Muusaa: «A haɗataa ngaari aloori tappoori gawri muuɗude gawri.» Ga'i alooji ɗii tan ngoni ko Laamɗo wattani hakkille naa? ");
INSERT INTO ffm_vpl VALUES ("C19_10","076_9_10","1CO","9","10","10","Tama wanaa saabe men o haalirta? Goonga, enen mbinndanaa ngol konngol, sabi demoowo e tappoowo fuu ana ngollira jikke heɓude ngeɗu mum'en. ");
INSERT INTO ffm_vpl VALUES ("C19_11","076_9_11","1CO","9","11","11","Min aawii e mon kulle ruuhunkooje. So min kettii e mon kulle adunankooje, yalla miɗen kaawanee ɗum naa? ");
INSERT INTO ffm_vpl VALUES ("C19_12","076_9_12","1CO","9","12","12","So woɓɓe ana kaandi e heɓude ɲaamdu e junngo mon, wanaa minen ɓuri haandude hen? Kaa minen, min njokkaali ngol laawol. Miɗen muɲa huunde fuu pati min kaɗa Kabaaru Lobbo haala Almasiihu oo yaade yeeso. ");
INSERT INTO ffm_vpl VALUES ("C19_13","076_9_13","1CO","9","13","13","Tama on anndaa gollooɓe e ley Suudu Dewal Mawndu ɓee ana nguuri e kulle ɗe yimɓe ndokkata Suudu nduu ɗee? Tama on anndaa halfinaaɓe golle ittirde sadaka ɓee ana keɓa ngeɗu mum'en e mayre? ");
INSERT INTO ffm_vpl VALUES ("C19_14","076_9_14","1CO","9","14","14","Hono non, Joomiraaɗo yamirii waajotooɓe Kabaaru Lobbo ɓee nguura e Kabaaru Lobbo oo. ");
INSERT INTO ffm_vpl VALUES ("C19_15","076_9_15","1CO","9","15","15","Kaa miin, mi jokkaali hen fay laawol gootol, kasen duu mi winndiraali ɗum faa mi heɓa huunde. Maayde ɓurani kam ɲaagaade huunde. Sabi ɗum woni ko mantortoo-mi, mi jaɓataa fay gooto itta kam e majjum duu. ");
INSERT INTO ffm_vpl VALUES ("C19_16","076_9_16","1CO","9","16","16","Sabi waajaade Kabaaru Lobbo oo manataa kam, ɗum tilsuɗum kam. Bone woodanii kam so mi waajaaki Kabaaru Lobbo oo! ");
INSERT INTO ffm_vpl VALUES ("C19_17","076_9_17","1CO","9","17","17","Sinndo mi golliriino oo golle saabe miɗo fellisinnoo ɗum miin e hoore am, nden kaa mi heɓanno njoɓdi. Kaa laatike tilsere ngolliran-moo-mi, mo golle mo kalfinaa-mi. ");
INSERT INTO ffm_vpl VALUES ("C19_18","076_9_18","1CO","9","18","18","Ndennoo koɗum woni njoɓdi am? Njoɓdi am, ɗum woni seyo am ko mbaajotoo-mi Kabaaru Lobbo meere meere koo, tawti e ko mi lamndataako ko waajotooɓe Kabaaru Lobbo oo ɓee poti heɓude. ");
INSERT INTO ffm_vpl VALUES ("C19_19","076_9_19","1CO","9","19","19","Mi walaa e margal fay gooto, kaa mi waɗii hoore am maccuɗo yimɓe fuu, yalla miɗo heɓa ko ɓuri heewde e maɓɓe. ");
INSERT INTO ffm_vpl VALUES ("C19_20","076_9_20","1CO","9","20","20","E ley Yahuudiyankooɓe, mi waɗii hoore am Yahuudiyanke, yalla miɗo heɓa ɓe. E ley jokkuɓe Sariya Muusaa, mi waɗii hoore am jokkuɗo Sariya Muusaa, yalla miɗo heɓa ɓe, fay so wanaa waajibi mi jokka Sariya oo. ");
INSERT INTO ffm_vpl VALUES ("C19_21","076_9_21","1CO","9","21","21","E ley ɓe ngalaa e Sariya Muusaa ɓee, mi waɗii hoore am mo walaa e Sariya oo, yalla miɗo heɓa ɓe, fay so miin e hoore am, mi waasaali taweede e sariya Laamɗo oo, sabi ley sariya Almasiihu ngon-mi. ");
INSERT INTO ffm_vpl VALUES ("C19_22","076_9_22","1CO","9","22","22","E ley lo'uɓe, mi waɗii hoore am mi lo'uɗo, yalla miɗo heɓa ɓe. Walaa fuu no mi waɗaali hoore am kammari yimɓe fuu, yalla ana daɲa ɓe kisin-mi. ");
INSERT INTO ffm_vpl VALUES ("C19_23","076_9_23","1CO","9","23","23","Ko ngaɗan-mi fuu, mi waɗiran ɗum kammari Kabaaru Lobbo oo yalla miɗo heɓa hen ngeɗu. ");
INSERT INTO ffm_vpl VALUES ("C19_24","076_9_24","1CO","9","24","24","Tama on anndaa daɗondirteeɓe ɓee fuu yo dogooɓe, kaa gooto tan heɓata deesewal? Ndennoo, ndogiree heɓude ngal. ");
INSERT INTO ffm_vpl VALUES ("C19_25","076_9_25","1CO","9","25","25","Lanndinantooɓe ndaggu fuu, mbiiran terɗe mum'en biirugol cattungol. Ko ɓe ngaɗirta ɗum dee, faa ɓe keɓa deesewal ngal duumataako. Enen nee, faa keɓen deesewal duumotoongal. ");
INSERT INTO ffm_vpl VALUES ("C19_26","076_9_26","1CO","9","26","26","Saabe majjum mi dogiraali meere, mi wa'aali no kaɓoowo e henndu nii. ");
INSERT INTO ffm_vpl VALUES ("C19_27","076_9_27","1CO","9","27","27","Kaa miɗo biira terɗe am no naawiri miɗo jaalii ɗe, yalla miin baajotooɗo woɓɓe Kabaaru Lobbo oo, pati mi waasa yarraneede. ");
INSERT INTO ffm_vpl VALUES ("C110_1","076_10_1","1CO","10","1","1","Sakiraaɓe, miɗo yiɗi paamon faa gasa ko hewtii maamiraaɓe men jamaanu Muusaa koo. Ɓe fuu ɓe ngoniino e ley luurde ndee, ɓe fuu duu ɓe lummbiino geeci oo. ");
INSERT INTO ffm_vpl VALUES ("C110_2","076_10_2","1CO","10","2","2","E ley haɓɓagol maɓɓe e Muusaa ɓe fuu ɓe keɓii lootogal batisima e ley luurde ndee, kaɲum e ley geeci oo. ");
INSERT INTO ffm_vpl VALUES ("C110_3","076_10_3","1CO","10","3","3","Kasen duu ɓe fuu ɓe ɲaamdii ɲaamdu wooturu ruuhunkooru, ");
INSERT INTO ffm_vpl VALUES ("C110_4","076_10_4","1CO","10","4","4","ɓe fuu ɓe njardii njaram ngootam ruuhunkoojam, sabi eɓe njarannoo ɗam e haayre ruuhunkoore jokkunoonde e maɓɓe ndee. Nden haayre woni Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C110_5","076_10_5","1CO","10","5","5","Kaa ko ɓuri heewde e maɓɓe, Laamɗo welaaka ɗum'en. Ɗum saabii so ɓe kalkii ley ladde jeereende ndee. ");
INSERT INTO ffm_vpl VALUES ("C110_6","076_10_6","1CO","10","6","6","Ɗum fuu eɗum holla en pati njokken giɗaaɗe yonki bonɗe no maɓɓe nii. ");
INSERT INTO ffm_vpl VALUES ("C110_7","076_10_7","1CO","10","7","7","Pati laatee rewooɓe tooruuji no yoga maɓɓe nii, hono no winndorii nii: «Yimɓe ɓee njooɗiima ana ɲaama ana njara, kasen immii ana mboma.» ");
INSERT INTO ffm_vpl VALUES ("C110_8","076_10_8","1CO","10","8","8","Pati naaten e fijirde no yogaaɓe e maɓɓe naatiri e fijirde nii. Ɗum saabii so ujunaaji noogay e taton neɗɗo maayi ɲannde wootere. ");
INSERT INTO ffm_vpl VALUES ("C110_9","076_10_9","1CO","10","9","9","Pati itten koro Almasiihu no yoga maɓɓe nii. Ɗum saabii so bolle kalki ɗum'en. ");
INSERT INTO ffm_vpl VALUES ("C110_10","076_10_10","1CO","10","10","10","Pati ŋermitee no yoga maɓɓe nii. Ɗum saabii so malaa'ika baroowo oo halki ɓe. ");
INSERT INTO ffm_vpl VALUES ("C110_11","076_10_11","1CO","10","11","11","Ɗum fuu waɗii yalla ana laatanoo en misaalu, ɗum winndiraama faa ɗum waajoo en, enen wonɓe e cakite jamaanu ɓee. ");
INSERT INTO ffm_vpl VALUES ("C110_12","076_10_12","1CO","10","12","12","Ɗum nee, miiloowo ana darii fuu, waɗa hakkille pati boɓɓoo e leydi. ");
INSERT INTO ffm_vpl VALUES ("C110_13","076_10_13","1CO","10","13","13","Walaa torra ittoowa koro heɓuka on ka heɓaali ɓiɓɓe aadama. Laamɗo yo koolniiɗo, o ɗalataa torra koroowa ɓurka on semmbe fawee e mon. Torra fuu koroowa on, o hokkan on no mbaawron muɲude ɗum, o hokkan on laawol no njaltiron e mum. ");
INSERT INTO ffm_vpl VALUES ("C110_14","076_10_14","1CO","10","14","14","Saabe ɗum, sakiraaɓe am horsuɓe, ngoɗɗee dewal tooruuji. ");
INSERT INTO ffm_vpl VALUES ("C110_15","076_10_15","1CO","10","15","15","Miɗo haalirana on hono no on hakkilante'en nii, caree onon e ko'e mon ko mbii-mi koo. ");
INSERT INTO ffm_vpl VALUES ("C110_16","076_10_16","1CO","10","16","16","Horde hiraande seniinde nde njettaten Laamɗo kammari mum ndee, so en njarii nde, tama en ndeentaali e ƴiiƴam Almasiihu ɗam? Buuru mo taƴaten oo, so en ɲaamii mo, tama en ndeentaali e terɗe Almasiihu ɗee? ");
INSERT INTO ffm_vpl VALUES ("C110_17","076_10_17","1CO","10","17","17","Tawi buuru oo yo gooto, enen duu, enen e heewde fuu, en terɗe goote, sabi eɗen njogii ngeɗu e oon buuru gooto. ");
INSERT INTO ffm_vpl VALUES ("C110_18","076_10_18","1CO","10","18","18","Taykee leɲol Israa'iila ngol: tama yimɓe maɓɓe ɲaamooɓe sadakaaji ɓee ndeentaali e Laamɗo gaɗanaaɗo ittirde sadaka ndee oo? ");
INSERT INTO ffm_vpl VALUES ("C110_19","076_10_19","1CO","10","19","19","Miɗo yiɗi wiide tew cakkanaaɗo tooruuji won ko woni naa? Naa tooru e hoore mum won ko woni? ");
INSERT INTO ffm_vpl VALUES ("C110_20","076_10_20","1CO","10","20","20","Walaa! Ko njiɗu-mi wiide dee, ko heeferɓe ɓee cakkotoo koo, sakketee seyɗaani'en, wanaa Laamɗo. Mi yiɗaa ndeenton e seyɗaani'en. ");
INSERT INTO ffm_vpl VALUES ("C110_21","076_10_21","1CO","10","21","21","On mbaawaa yarde e horde Joomiraaɗo ndee njaron kasen e horde seyɗaani'en, on mbaawaa ɲaamde e la'al Joomiraaɗo ngal ɲaamon kasen e la'al seyɗaani'en ɓee. ");
INSERT INTO ffm_vpl VALUES ("C110_22","076_10_22","1CO","10","22","22","Naa iirtude tikkere Joomiraaɗo njiɗ-ɗen? Naa en miilii eɗen ɓuri mo semmbe? ");
INSERT INTO ffm_vpl VALUES ("C110_23","076_10_23","1CO","10","23","23","Mbii-ɗon: «Huunde fuu ana dagii.» Ooho, kaa wanaa fuu nafata. So goonga, «huunde fuu ana dagii», kaa wanaa fuu naɓata deental goonɗinɓe ngal yeeso. ");
INSERT INTO ffm_vpl VALUES ("C110_24","076_10_24","1CO","10","24","24","Pati fay gooto laatoo hammadi haaje mum tan, ndaarta nafaa woɓɓe ɓee duu. ");
INSERT INTO ffm_vpl VALUES ("C110_25","076_10_25","1CO","10","25","25","Tew cootteteeɗo luumo fuu, oɗon mbaawi ɲaamirde ɗum hakkillaaji ɗi ɲiŋataa on tawa on lamndaaki yalla ɗum tew cakkanaaɗo tooruuji naa wanaa. ");
INSERT INTO ffm_vpl VALUES ("C110_26","076_10_26","1CO","10","26","26","Sabi «leydi e ko woni e mum fuu Joomiraaɗo woodani.» ");
INSERT INTO ffm_vpl VALUES ("C110_27","076_10_27","1CO","10","27","27","So neɗɗo mo goonɗinaali noddii on, on njaɓii nootaade, ɲaamon ko ndokke-ɗon fuu, tawa hakkillaaji mon ɲiŋataa on. ");
INSERT INTO ffm_vpl VALUES ("C110_28","076_10_28","1CO","10","28","28","Kaa so won biiɗo on: «Ɗum ko sakkanaa tooruuji», nden, pati ɲaamee ɗum saabe biiɗo non oo e saabe hakkille mum ɲiŋoowo ɗum. ");
INSERT INTO ffm_vpl VALUES ("C110_29","076_10_29","1CO","10","29","29","Wanaa ko wartata e hakkillaaji mon onon kaalan-mi ɗoo, ko wartata e hakkille biiɗo non oo kaalan-mi. Kaa fotaa ko hakkille neɗɗo goɗɗo sara ndimaaku am. ");
INSERT INTO ffm_vpl VALUES ("C110_30","076_10_30","1CO","10","30","30","So miɗo yetta Laamɗo e dow ko ɲaaman-mi, ko waɗi so miɗo bonkee e nduun ɲaamdu ndu njettu-mi Laamɗo kammari mum? ");
INSERT INTO ffm_vpl VALUES ("C110_31","076_10_31","1CO","10","31","31","Ndennoo, so on ɲaaman, so on njaran naa ko ngaɗaton fuu, ngaɗiree ɗum faa Laamɗo teddinee. ");
INSERT INTO ffm_vpl VALUES ("C110_32","076_10_32","1CO","10","32","32","Pati laatanee fay gooto fergitere, wanaa Yahuudiyankooɓe wanaa ɓe nganaa Yahuudiyankooɓe wanaa deental goonɗinɓe Laamɗo ngal. ");
INSERT INTO ffm_vpl VALUES ("C110_33","076_10_33","1CO","10","33","33","Ngolliree no am nii, sabi miɗo tewta ko welata yimɓe fuu e dow huunde fuu, tawee mi tewtaali nafaa am miin tan, ko nafata heewɓe tewtan-mi, yalla eɓe kisinee. ");
INSERT INTO ffm_vpl VALUES ("C111_1","076_11_1","1CO","11","1","1","Ɲemmbee kam no ɲemmbiran-mi Almasiihu nii. ");
INSERT INTO ffm_vpl VALUES ("C111_2","076_11_2","1CO","11","2","2","Miɗo yetta on ko micciti-ɗon kam e huunde fuu koo, e ko njokku-ɗon waajuuji ɗi mbaajii-mi on ɗii koo. ");
INSERT INTO ffm_vpl VALUES ("C111_3","076_11_3","1CO","11","3","3","Kaa noo, miɗo yiɗi paamon Almasiihu woni hooreejo gorko fuu, gorko woni hooreejo debbo, kasen duu Laamɗo woni hooreejo Almasiihu. ");
INSERT INTO ffm_vpl VALUES ("C111_4","076_11_4","1CO","11","4","4","Ndennoo, gorko fuu kippiiɗo kufina so ana duwoo naa so ana haalta konngol ngol Laamɗo loowi e mum ngol, hoynii hooreejo mum oo. ");
INSERT INTO ffm_vpl VALUES ("C111_5","076_11_5","1CO","11","5","5","Kaa debbo fuu mo soomaaki so ana duwoo naa so ana haalta konngol ngol Laamɗo loowi e mum ngol, hoynii hooreejo mum oo, sabi omo wa'i hono no o laɓiiɗo nii. ");
INSERT INTO ffm_vpl VALUES ("C111_6","076_11_6","1CO","11","6","6","Sabi so debbo soomaali hoore mum, yo mesu sukundu mum. Kaa so nii mesude hoore mum naa laɓude nde ana yaannoo debbo, yo soomu hoore mum. ");
INSERT INTO ffm_vpl VALUES ("C111_7","076_11_7","1CO","11","7","7","Gorko noo haanaa hippaade kufina, sabi yo mbaadi Laamɗo, kaɲum e darja mum. Kaa debbo yo darja gorko. ");
INSERT INTO ffm_vpl VALUES ("C111_8","076_11_8","1CO","11","8","8","Sabi wanaa gorko ittaa e debbo, debbo ittaa e gorko. ");
INSERT INTO ffm_vpl VALUES ("C111_9","076_11_9","1CO","11","9","9","Wanaa gorko taganaa debbo, debbo taganaa gorko. ");
INSERT INTO ffm_vpl VALUES ("C111_10","076_11_10","1CO","11","10","10","Saabe ɗum ana wajibii e debbo soomude e hoore mum taagumansa baawɗe saabe malaa'ika'en. ");
INSERT INTO ffm_vpl VALUES ("C111_11","076_11_11","1CO","11","11","11","Kaa ɗum e taweede, e ley haɓɓagol men e Joomiraaɗo, debbo ana haɓɓii e gorko, gorko duu ana haɓɓii e debbo. ");
INSERT INTO ffm_vpl VALUES ("C111_12","076_11_12","1CO","11","12","12","Sabi no debbo ittiraa e gorko nii, hono non debbo duu rimirta gorko. Kaa ɗum fuu, to Laamɗo ɗum iwi. ");
INSERT INTO ffm_vpl VALUES ("C111_13","076_11_13","1CO","11","13","13","Caree onon e ko'e mon: yalla ana ŋarɗi e debbo rewa Laamɗo tawa soomaaki? ");
INSERT INTO ffm_vpl VALUES ("C111_14","076_11_14","1CO","11","14","14","Wanaa neesu oo e hoore mum ana anndina on sukundu juutundu ana yaaginii e gorko, ");
INSERT INTO ffm_vpl VALUES ("C111_15","076_11_15","1CO","11","15","15","kaa e debbo, yo darja? Sabi o hokkiraama sukundu juutundu yalla ana sudda hoore ndee. ");
INSERT INTO ffm_vpl VALUES ("C111_16","076_11_16","1CO","11","16","16","Muuyɗo yeddude ɗum fuu yo anndu en ngalaa oon aada, wanaa minen, wanaa deente goonɗinɓe Laamɗo ɗee. ");
INSERT INTO ffm_vpl VALUES ("C111_17","076_11_17","1CO","11","17","17","Won ko njiɗu-mi yamirde on kasen, haala no kawritirton. Haala majjum mi waawaa yettude on, sabi kawrite mon ɗee naɓataa on yeeso, to boni ɗe naɓata on. ");
INSERT INTO ffm_vpl VALUES ("C111_18","076_11_18","1CO","11","18","18","Ko adii fuu, mi nanii so on kawritii, luurral ana hakkunde mon, kasen duu won ko ngoonɗin-mi hen. ");
INSERT INTO ffm_vpl VALUES ("C111_19","076_11_19","1CO","11","19","19","Ana tilsi pelle-pelle ngaɗa hakkunde mon, y