﻿USE sofia;
DROP TABLE IF EXISTS sofia.far_vpl;
CREATE TABLE far_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES far_vpl WRITE;
INSERT INTO far_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","'Isufutai sulia sa Jesus Christ. Nia futa mai ana kwalafa sa Deved na kingi ne nia futa ana kwalafa sa Abraham. ");
INSERT INTO far_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ma na 'isufutai ne, nia safali mai ana sa Abraham. Na wele sa Abraham ne sa Aesak, sa Aesak alua sa Jakob, sa Jakob alua sa Jiuda fainia wanefuta nia ki. ");
INSERT INTO far_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Na wele sa Jiuda ki ne sa Peres fainia sa Sera. Gaa keroa satana ni Tama. Na wele sa Peres ne sa Hesron, sa Hesron alua sa Ram. ");
INSERT INTO far_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Sa Ram alua sa Aminadab, sa Aminadab alua sa Nason, sa Nason alua sa Salmon. ");
INSERT INTO far_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sa Salmon alua sa Boas, ma gaa nia satana ni Rahab. Sa Boas alua sa Obed, ma gaa nia satana ni Rut. Sa Obed alua sa Jesi. ");
INSERT INTO far_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Sa Jesi ne alua sa Deved na kingi 'i Israel. Sa Deved alua sa Solomon, ma gaa nia ne 'oruna sa Iuraea. ");
INSERT INTO far_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sa Solomon alua sa Rihoboam, sa Rihoboam alua sa Abaeja, sa Abaeja alua sa Asa. ");
INSERT INTO far_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Sa Asa alua sa Jehosafat, sa Jehosafat alua sa Joram, sa Joram alua sa Iusaea. ");
INSERT INTO far_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Sa Iusaea alua sa Jotam, sa Jotam alua sa Ehas, sa Ehas alua sa Hesikaea. ");
INSERT INTO far_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Sa Hesikaea alua sa Manase, sa Manase alua sa Emon, sa Emon alua sa Josaea. ");
INSERT INTO far_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sa Josaea alua sa Jekonaea fainia sasina ki. Kera futa ka sui na malimae kera ki ka fi ngalia wane Israel ki 'uria fere baita 'i Babilon. ");
INSERT INTO far_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","'I burina ne malimae kera ki, kera ngalia wane Israel ki 'uria 'i Babilon, sa Jekonaea ka fi alua sa Sialtiel. Ma sa Sialtiel alua sa Serababel. ");
INSERT INTO far_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Sa Serababel alua sa Abaeud, sa Abaeud alua sa Elaeakim, sa Elaeakim alua sa Aso. ");
INSERT INTO far_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sa Aso alua sa Sadok, sa Sadok alua sa Akim, sa Akim alua sa Eliud. ");
INSERT INTO far_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Sa Eliud alua sa Elaesa, sa Elaesa alua sa Matan, sa Matan alua sa Jakob. ");
INSERT INTO far_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob alua sa Josef arai ni Mary gaa sa Jesus ne kera saea ana na Christ. ");
INSERT INTO far_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ma safali mai ana sa Abraham leka ka dao ana sa Deved na kingi, akwala ma fai unita wane. Safali mai ana sa Deved na kingi leka ka dao ana kada be malimae kera ki ngalia wane Israel ki 'uria 'i Babilon, te akwala ma fai unita wane. Safali ana kada wane Israel ki kera leka 'uria 'i Babilon leka mai ka dao ana kada na Christ nia futa, te akwala ma fai unita wane lau. ");
INSERT INTO far_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Na futalana mai sa Jesus Christ nia 'uri: Kada kera alu fafia ni Mary na gaa sa Jesus fuana sa Josef, ma nao keroa nao si 'ado 'ua, ni Mary saitamana ne nia 'e kulua na sulia nikilalana Anoeru Abu. ");
INSERT INTO far_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma sa Josef, na wane ne kera alu fafia fuana, nia ka manata fua sae ka ta'ana ana, sulia nia na wane 'o'olo. Boroi ma nia nao si doria fa'ekelana maana wane ki, ma nia ka manata 'uria sae ka ta'ana agwa ana. ");
INSERT INTO far_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Boroi ma kada nia 'e manata ga 'ana 'ua sulia na ru nai, na 'ainsel God nia fatai fuana laona maleu bolee ka 'uri, “Josef 'ae, 'oe wane ana kwalafa sa Deved, 'oe nao si mau ana adelana ni Mary. Sulia nia kulua lalau sulia nikilalana Anoeru Abu. ");
INSERT INTO far_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ma nia kai fafuta te welewane, ma 'oe kai saea ana sa Jesus (ne fadalana ‘Famauri’), sulia nia kai famauria na wane nia ki fasia na abulo ta'alae kera ki.” ");
INSERT INTO far_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma na ru ne ki ka fuli fua ka famamana ru be God nia farongo mai ana 'i nao, kada be profet nia fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Te sari kai iana ma ka fafuta te welewane, ma kera kai saea ana sa Emanuel.” Na fadalana sataeru nai ne, “God nia to fai kia.” ");
INSERT INTO far_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ma kada sa Josef nia ada na, nia ka sasi sulia ru nai ki ne 'ainsel God nia saea fuana. Ma nia ka adea na ni Mary. ");
INSERT INTO far_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Boroi ma nao keroa si 'ado 'ua leka ka dao ana kada ni Mary nia fafuta na welewane nai. Ma sa Josef ka fasata ana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ana kada nai sa Herod nia 'e kingi na, sa Jesus nia ka futa 'i Betlehem, na fere laona lofaa 'i Jiudea. Ma nao si tau go 'i burina, tani wane fasia taelana sato ne kera saitamana bubulu ki, kera ka dao mai laona fere baita 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ma kera ka ledia wane ki ma kera 'uri, “'Uri ma na wele be kai kingi fuana Jiu ki, nia futa 'i fai? Kalu saitamana nia futa seki, sulia kada kalu to 'ua mai taelana sato, kalu ada to'ona na fa bubulu ne fatainia futalana mai, ma kalu leka mai fua sae kalu ka boruru, ma ka fa'inito nia.” ");
INSERT INTO far_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ma sa Herod na kingi nia manata 'abero 'asiana kada nia rongo sulia na ru nai, ma na wane 'i Jerusalem ki laugo. ");
INSERT INTO far_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ma nia ka rii 'uria na fataabu baita ki, ma na wane famanata ana taki ki, fua kera koni mai, ma nia ka ledi 'uri ada, “'Uri ma 'i fai ne na Christ be kai futa mai ana?” ");
INSERT INTO far_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ma kera olisia kera ka fata 'uri, “'I Betlehem be, na fere laona lofaa 'i Jiudea. Sulia na kekedee profet be fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem 'ae, na fere laona lofaa 'i Jiudea, nao 'oe si tu'u 'i safitana fere 'initoa ki 'i Jiudea, sulia te wane 'initoa kai leka mai fasi 'oe, fua ka talaia na wane nau ki 'i Israel.’” ");
INSERT INTO far_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ma sa Herod ka rii agwa 'uria na wane ne dao mai ki fasia taelana sato fuana faorailae agwa, fua nia ka dao to'ona kada te ne kera eta ada to'ona na fa bubulu be. ");
INSERT INTO far_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ma nia ka eresida kau 'uria 'i Betlehem, ka fata 'uri, “Mulu leka, mulu ka nani talingai 'uria na wele nai. Ma dia mulu dao to'ona, mulu ka farongo nau mai, fua nau leka laugo fuana fa'initolana.” ");
INSERT INTO far_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ma 'i burina sa Herod nia fata 'urinai ka sui, kera ka leka na 'ada. Ma ana kada kera dao na kau sulia na taale, kera ka ada to'ona lau fa bubulu be kera eta ada to'ona mai 'i taelana sato. Kera ka eele 'asiana ana kada kera ada to'ona lau. Ma fa bubulu nai ka eteta naoda leka ka dau bobola fainia na kula be sa Jesus nia tio ana. ");
INSERT INTO far_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Kera ru laona lume, ma kera ada to'ona na wele fainia gaa nia ni Mary. Kera ka boruru, ma kera ka fa'initoa na wele nai, ma kera ka 'ifingia na ngwai kera ki, ma ka kwatea ru liulana baita ki fuana: gol, ma na ru ne 'ai moko lea, ma na ngwaingwai moko lea ki. ");
INSERT INTO far_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Sui kera ka oli na 'ada sulia ta taale 'e'ete 'uria fere kera, sulia God nia lui talingai ada laona maleu bolee, ma ka saea kera nao si oli lau siana sa Herod. ");
INSERT INTO far_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ma burina wane nai ki kera oli na 'ada 'uria fere kera, 'ainsel God ka fatai fuana sa Josef laona maleu bolee, ma ka fata 'uri, “Josef 'ae, 'oe tatae, ko ngalia na wele ne fainia gaa nia, mulu ka tafi 'uria Ijip, ma mulu ka to mai senai leka ka dao ana kada ne nau kai saea mulu ka oli lau mai. Sulia sa Herod nia nani 'uria wele ne fua kai saungia.” ");
INSERT INTO far_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ma sa Josef tatae, ma ka ngalia na wele fainia gaa nia ni Mary, ma kera ka leka laona rodo nai 'uria mae fere 'i Ijip. ");
INSERT INTO far_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ma kera to senai leleka sa Herod ka mae. Ma ru nai ka famamana te be God saea fuana profet be kedea ka 'uri, “Nau ku rii mai 'uria na wele nau fasia 'i Ijip.” ");
INSERT INTO far_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Kada sa Herod na kingi nia saitamana ne wane be ki kera leka mai fasia taelana sato kera suke nia, na manatana 'e guisasu 'asiana. Ma nia ka kwatea fatalana fuana wane ni omee nia ki fua kera ka saungi tafau ana kaela welewane ki 'i Betlehem ma ana mae fere kalikalia ki tafau. Nia ka fata totongai fua kera ka saungia kaela welewane ne nao si dao 'ua ana ro fangali, dia na fatae be na wane be ki sulia kada be fa bubulu nia eta fatai ana. ");
INSERT INTO far_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","'Urinai na wane ne kera to 'i Betlehem, kera ka angi 'uria wele kera ki ne mae. Kera angi 'urinai, dia be sa Jeremaea na profet nia saea na mai 'i nao, ");
INSERT INTO far_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kera rongoa linge angiangie nai leka mai fasia na fere 'i Rama ne linge omaee baita. Ni Resel ka angisia wele tu'u nia ki. Kada nia angi, nao ta wane si gwale nia, sulia ne wele nia ki kera mae tafau.” ");
INSERT INTO far_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ma burina sa Herod 'e mae na, 'ainsel God ka fatai lau laona maleu bolee fuana sa Josef 'i Ijip, ");
INSERT INTO far_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ka fata 'uri, “Josef 'ae, tatae, 'oe ngalia na wele fainia gaa nia ni Mary, mulu ka oli na 'uria 'i Israel, sulia wane be ki kera sasi 'uria saungilana wele ne, kera mae na.” ");
INSERT INTO far_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ma sa Josef ka tatae, ma ka ngalia na wele fai gaa nia ni Mary, ma kera ka oli na 'uria 'i Israel. ");
INSERT INTO far_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Boroi ma kada sa Josef nia rongoa sa Akilas nia kingi talana maa nia sa Herod 'i Jiudea, nia ka mau ana tolae senai. Ma na 'ainsel ka saea lau fuana laona maleu bolee, fua kera ka leka 'uria na lofaa 'i Galili. ");
INSERT INTO far_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nia ne kera ka to ana fere 'i Nasaret laona lofaa 'i Galili. Ma ka famamana te be na profet ki kera fata 'uri ana, “Kera kai saea ana na wane fasia 'i Nasaret.” ");
INSERT INTO far_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma bara fangali burina, kada sa Jesus nia baita na, sa Jon wane ni Siuabu ka dao mai, ka safalia na famanatalae laona lofaa 'eke'eke 'i Jiudea, ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mulu kari abulo fasia ta'alae kamulu ki, sulia kada ne God kai gwaungai ana wane nia ki 'e karangi dao na.” ");
INSERT INTO far_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sa Jon, na wane be profet Aesaea nia fata mai sulia, ma ka 'uri, “Te wane nia akwa laona lofaa 'eke'eke, Ma nia ka 'uri, ‘Na 'Aofia kai dao mai! Mulu fasaga na taale fuana!’” ");
INSERT INTO far_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Sa Jon rufia na maku ana ifuna kamel, ma ka bitia na fosae nia salafana ana na 'ungana buluka. Ma fanga nia ne siko ki ma ngingidue kwasi ");
INSERT INTO far_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ma na wane 'oro kera leka mai siana fasia 'i Jerusalem, ma na fere ki tafau laona lofaa 'i Jiudea, ma fasia fere ki tafau karangia kafo 'i Jodan. ");
INSERT INTO far_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ma kera ka fulangainia ta'alae kera ki, ma nia ka siuabuda laona kafo 'i Jodan. ");
INSERT INTO far_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ma kada sa Jon nia ada to'ona wane 'oro ana Farasi ki ma Sadusi ki ne kera leka laugo mai siana fua sae nia ka siuabuda, nia ka fata 'uri fuada, “Mulu dia go amulu kaela baeko tolo ki! Nau nao si saea lau fua mulu ne na siuabue kai fatafi kamulu fasia na kwaekwaee God, sui boroi 'ana mulu nao si kari abulo. ");
INSERT INTO far_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mulu sasia lalau ru ki ne fatainia kamulu kari abulo na fasia abulo ta'alae kamulu ki. ");
INSERT INTO far_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ma nao mulu si manata 'uri laona liomulu, ‘Kalu wane ne futa na mai ana kwalafa sa Abraham ne. 'Afitai ta kwaekwaee fasia God ka dao to'omalu.’ Ma nau ku sae 'o'olo fua mulu, nia ngwaluda ga 'ana fua God ka ngalia tani gwa fau ana fau ne ki, ma ka saungainia ana kwalafa sa Abraham! ");
INSERT INTO far_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ana kada ne, God sasi akau na ana kwaekwaee, dia ta wane be nia dau ana irome, ka sasi akau fua tofulana 'ai ki. Ma 'ai ki tafau ne nao si fungu ana fue 'ai lea ki, nia kai tofuda ma ka 'ui 'anida laona ere. ");
INSERT INTO far_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Nau ku siuabu kamulu ana kafo fua ka fatainia ne mulu kari abulo na fasia abulo ta'alae kamulu ki. Boroi ma te wane ne kai leka mai buriku, nia kai siuabu kamulu ana na Anoeru Abu ma na ere. Ma nia talingai ka liufi nau. Nao nau si lea ka bobola fuana ngalilana tae butu nia ki. ");
INSERT INTO far_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ma nia sasi akau na fuana ketolana wane ki tafau, ka dia ta wane be nia efoa na mege ru lea ki fasia na tataeru ki. Ma nia ka konia na mege ru lea ki laona na lume ni konirue. Ma nia ka sungia na tataeru ki laona ere ne saru si mae.” ");
INSERT INTO far_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ana kada nai, sa Jesus 'e leka mai fasia lofaa 'i Galili 'uria kafo 'i Jodan siana sa Jon fua sa Jon ka siuabua. ");
INSERT INTO far_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Boroi ma sa Jon ka sasi 'uria na talalana na manatana sa Jesus, ka 'uri, “Nia bobola fainia 'oe ne kai siuabu nau, ma 'oe leka lalau mai siaku fua nau kai siuabu 'oe.” ");
INSERT INTO far_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ma sa Jesus ka olisia ka fata 'uri, “Sui boroi 'ana ka 'urinai, 'oe sasia na mai 'amu ru ne fuaku, sulia sasilana na ru ne, koro sasia ru ki tafau ne God nia doria.” Ma sa Jon ka ala na fafia. ");
INSERT INTO far_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ma kada sa Jesus nia siuabu suina, nia ka tatae mai fasia kafo. Ma na lofana salo ka 'ifi fuana, ma nia ka ada to'ona na Anoeru Abu God 'e koso mai dia ta bole, ma ka to 'i fafona. ");
INSERT INTO far_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ma te lingeru nia talo mai fasia 'i langi ma ka 'uri, “Nia na ne wele mutai nau ne nau ku kwaimani 'asiana ana, ma nau ku eele 'asiana fainia.” ");
INSERT INTO far_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ma 'i burina na ru ne, na Anoeru Abu ka talaia sa Jesus 'uria laona bali lofaa 'eke'eke fua sa Saetan kai ilito'ona. ");
INSERT INTO far_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ma sa Jesus ka abu fanga sulia fai akwala maedangi, ma fai akwala fa rodo ki, ma nia ka fiolo 'asiana. ");
INSERT INTO far_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","'Urinai, sa Saetan ka leka mai siana, ka fata 'uri, “Dia 'oe na Wele God, fata fuana gwa fau ne ki fua ka alua ta beret.” ");
INSERT INTO far_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ma sa Jesus ka olisia ka 'uri, “Na Kekedee Abu be saea, ‘Na wane nao si mauri go ana fanga taifilia. Boroi ma, nia mauri ana fatae ki tafau ne leka mai fasia God.’” ");
INSERT INTO far_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Sui sa Saetan ka talai lau sa Jesus 'uria na fere abu 'i Jerusalem, ma ka fauua ana kula 'i langi ne 'e ra 'asiana fafona na Beu Abu God. ");
INSERT INTO far_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ma ka fata 'uri fuana, “Dia 'oe na Wele God, 'oe lofo toli 'i ano fasia 'i seki, sulia na Kekedee Abu be fata 'uri, ‘God kai kwatea mai 'ainsel nia ki fuamu, ma kera kai sako 'oe, fua 'aemu si foto ana ta gwa fau.’” ");
INSERT INTO far_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ma sa Jesus ka olisia ka 'uri, “Na Kekedee Abu be fata 'uri, ‘Nao 'oe si ilito'ona God 'oe.’” ");
INSERT INTO far_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Sui sa Saetan ka talaia lau sa Jesus 'uria gwauna fa uo fane, ma ka fatainia 'initoe ki tafau ana molagali ma kwangalae kera ki fua sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ma sa Saetan ka fata 'uri, “Na ru ne ki tafau nau ku kwateda fuamu, dia 'oe boruru maana 'aeku, ma 'oe fa'inito nau.” ");
INSERT INTO far_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ma sa Jesus ka olisia ka 'uri, “Saetan 'ae, 'oe leka tau kau fasi nau! Sulia na Kekedee Abu be saea, ‘Taifilia God go ne 'oe fa'initoa, ma 'oe rao fuana.’” ");
INSERT INTO far_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sui ana kada nai, sa Saetan ka leka na fasia sa Jesus. Ma 'ainsel ki kera ka kwai'adomi 'ani nia. ");
INSERT INTO far_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kada sa Jesus rongoa ne kera alua sa Jon laona beu ni kanie, nia ka oli 'uria lofaa 'i Galili. ");
INSERT INTO far_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ma nia nao si to laona fere nia 'i Nasaret. Nia leka, ka to lalau 'ana 'i Kapaneam, na fere ninimana 'osi 'i Galili, ana lofaa 'i Sebulun ma 'i Naftali. ");
INSERT INTO far_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nia sasi 'urinai fua ka famamana fatalana profet Aesaea be 'uri, ");
INSERT INTO far_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Na gano 'i Sebulun ma gano 'i Naftali, kera to laona lofaa 'i Galili, ma kera to sulia taale 'uria 'osi baita, ma ka to te bali ana kafo 'i Jodan, kula ne nao lau wane Jiu ki kera to ana. ");
INSERT INTO far_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Na wane nai ki, kera to laona maerodo, kera kai ada to'ona madakwalae baita. Ma sa tifaida ne kera to laona rorodoe ana maea ne, madakwalae kai tala fafida.” ");
INSERT INTO far_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Safali ana kada nai, sa Jesus ka 'ainitalo ana farongoe nia ka 'uri, “Mulu kari abulo fasia ta'alae kamulu ki, sulia kada God kai gwaungai ana wane nia ki 'e dao karangi kamulu na!” ");
INSERT INTO far_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ana kada sa Jesus nia leka sulia na 'osi 'i Galili, nia ka ada to'ona sa Simon (ne nia saea laugo ana sa Pita) fainia sa Andru na wanefuta nia. Keroa ro wane dee ki. Keroa dee adaro ana furai keroa laona 'osi 'i Galili. ");
INSERT INTO far_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ma sa Jesus ka fata 'uri fuadaro, “Kamoro leka mai fai nau, kamoro ro wane dee ie ne ki, boroi ma nau kai famanata kamoro ana ngali wane ki mai fuaku.” ");
INSERT INTO far_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ma kada nai go, keroa fasia furai keroa ki, ma keroa ka leka na fainia. ");
INSERT INTO far_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sui sa Jesus ka leka lau kau, ma ka ada to'ona lau ta ro wane, sa Jemes ma sa Jon na ro wele sa Sebedi ki. Keroa to 'adaroa laona baru fainia maa keroa sa Sebedi, ma kera ka modea furai kera ki. Sa Jesus ka sae keroa. ");
INSERT INTO far_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ma ana kada nai go, keroa fasia na 'adaroa baru fainia maa keroa, ma keroa ka leka na fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sa Jesus ka leka 'uria fere laona lofaa 'i Galili ki, ma ka famanata na wane ki laona beu fuana folae Jiu ki. Ma nia ka 'ainitalo ana na Farongoe Lea sulia na 'Initoe God, ma ka gura wane ne kera matai ana mataie 'e'ete ki ne saungida. ");
INSERT INTO far_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ma na fatae ki sulia sa Jesus ka talofia fere ki tafau laona lofaa 'i Siria. Ma wane 'oro ne kera matai ana mataie 'e'ete ki, wane ki kera ngalida mai siana. Na wane ne nonida fii ki, wane anoeru ta'a ki kwaeda, wane futomae saungida ki, ma wane ne 'aeda mae, wane ki kera ngalida mai siana. Ma sa Jesus ka gurada tafau. ");
INSERT INTO far_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ma na wane 'oro ki laugo, kera leka sulia sa Jesus ana kada nai. Wane fasia lofaa 'i Galili, ma fere 'i Jerusalem, tani fere laona lofaa 'i Jiudea, ma laona lofaa 'i Dekapolis, ma fasia bali taelana sato ana kafo 'i Jodan. ");
INSERT INTO far_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ma ana kada ne sa Jesus nia ada to'ona fikue baita nai, nia ka ra 'i gwauna na kula ne ta fane, ma ka gouru 'i ano. Ma na fafurongo nia ki kera ka oku kalia, ");
INSERT INTO far_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ma nia ka safali famanatada, ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Elelae fuada wane ne kera saitamana kera siofa 'i maana God, sulia kera kai too ana ru lea ki, kada God kai gwaungai fafida. ");
INSERT INTO far_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Elelae fuada wane ne kera kwaimanatai, sulia God kai gwaleda. ");
INSERT INTO far_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Elelae fuada wane ne kera marabibi ki, sulia God kai kwatea ru lea ne nia alangainia fuada ki. ");
INSERT INTO far_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Elelae fuada wane ne kera doria 'asiana sasilana ru 'o'olo ki, sulia God kai fatolia maurilada. ");
INSERT INTO far_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Elelae fuada wane ne manataida wane 'e'ete ki, sulia God kai manataida laugo. ");
INSERT INTO far_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Elelae fuada wane ne lioda 'o'olo fuana God, sulia kera kai ada to'ona God. ");
INSERT INTO far_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Elelae fuada wane ne kera rao fuana aroaroe safitana wane ki, sulia God kai sae kera ana na wele nia ki. ");
INSERT INTO far_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Elelae fuada wane ne kera fagagaida sulia sasilana ru 'o'olo ki, God kai gwaungai fafida. ");
INSERT INTO far_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Elelae fua mulu kada ne wane ki kera fata buri amulu, ma ka famalagaigai kamulu, ma ka saea ru ta'a 'oro ki amulu sulia kamulu na ne fafurongo nau ki. ");
INSERT INTO far_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nau ku saea ru nai sulia kera kai sasia ru ta'a ki fua mulu dia laugo be wane ki kera sasia ana profet ki mai 'i nao. Mulu eele amulu, sulia God kai kwatea kwaiarae baita ne nia konia fua mulu 'i langi.” ");
INSERT INTO far_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sa Jesus inau ana fatalana ka 'uri, “Na fiko asi ne 'e falea fanga fua mulu. Ma kamulu laugo mulu dia na fiko asi fuana falealana wane ki tafau. Boroi ma dia mamasialana 'e leka fasia, nia 'afitai lau 'oe ka famamasia. Ma nao nia si lea na fuana sasilana lau ana ta ru, ma nia lea fua mulu 'ui na amulu ana 'i maa, fuana wane ki kera ka liu na 'ada 'i fafona. ");
INSERT INTO far_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Kamulu dia laugo na fa kwesu fuana wane ki tafau laona molagali. Na fere ne kera saungainia gwauna fa uo nia 'afitai ka agwa. ");
INSERT INTO far_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ma nao ta wane si fasarua fa kwesu, sui ka alua 'ana farana na tiu. Kada nia fasarua fa kwesu ka sui, nia ka ngalia, ka daurangainia ana kula 'i langi, fua ka tala fuana wane ki tafau laona lume. ");
INSERT INTO far_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ma ka 'urinai laugo, na fa kwesu kamulu ka tala kau fua wane ki tafau, fua kada kera ada to'ona ru lea ne mulu sasia ki, kera fi tangoa Maa kamulu ne to mai 'i langi. ");
INSERT INTO far_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Nao mulu si kwaisae nau ku leka mai fuana fasuilana na taki sa Moses ki ma na famanatalae na profet ki. Nau si leka lau mai fuana fasuilada, boroi ma nau ku leka lalau mai fuana famamanalana famanatalae kera ki. ");
INSERT INTO far_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nau ku saea ru mamana fua mulu, ana kada ne 'i langi ma na molagali kera to 'ua, nao ta ru tu'u ana taki ki si sui leka ka dao ana kada ru God nia saea ki kai fuli mamana. ");
INSERT INTO far_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nia ne, sa ti boroi 'ana ne nao si rosulia ta taki tu'u, ma ka famanata tani wane fua noni'elalae ana ta taki tu'u, God kai alu nia 'isi ana 'Initoe nia. Boroi ma sa ti ne rosulia taki ki ma ka famanata tani wane fua rosulilana dia nia, God kai alu nia baita laona 'Initoe nia. ");
INSERT INTO far_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nau ku saea fua mulu, dia nao mulu si sasi lea liufia wane famanata ana taki ki, ma na Farasi ki ana sasilae sulia ru ne God nia doria, nia 'afitai 'asiana mulu kai to fainia wane ne God gwaungai fafida ki. ");
INSERT INTO far_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kamulu rongoa tafau na fatae talingai ne kera saea fuana koko kia ki 'i nao be 'uri, ‘Nao 'oe si sauwanee. Dia sa ti boroi 'ana ne sauwanee, kera kai ngali nia naona na wane kwaiketoi ki.’ ");
INSERT INTO far_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Boroi ma kada ne, nau ku saea fua mulu, sa ti ne guisasu fuana wanefuta nia, kera kai ngali nia naona na wane kwaiketoi ki. Ma sa ti ne ka saea fuana wanefuta nia, ‘'Oe na ru 'o'oni ga 'ana,’ kera kai ngalia naona na wane kwaiketoi ki. Ma sa ti ne ka saea na wanefuta nia ana, ‘Ru oewanea,’ nia kai leka ana taale 'uria na ere ne saru nao si mae. ");
INSERT INTO far_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Nia ne, dia 'oe sasi akau na ana afafue 'oe fuana God fafona na fulifue, ma 'oe manata to'ona ne nao nia si fola 'ua matangamu fai na wanefuta 'oe sulia na garo lamu, ");
INSERT INTO far_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","'oe fasia basi afafue 'oe maana fulifue, 'oe oli, 'oe fata kwaimani basi fainia. Sui 'i buri, 'oe oli mai, ma 'oe fi kwatea na afafue 'oe fua God. ");
INSERT INTO far_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ma dia ta wane ka ngali 'oe fuana kwaiketoilae, 'oe fata kwaimani basi fainia, kada nao kamoro si dao 'ua. Sulia dia kamoro dao na, nia kai kwate 'oe na fuana wane kwaiketoi, ma burina nia ka keto 'oe, ma nia fi kwate 'oe lau fua wane kani wane ki, ma na wane kani wane fi alu 'oe laona beu ni kanie. ");
INSERT INTO far_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nau ku saea fuamu, dia nia 'urinai, nia 'afitai fua 'oe ka ru fasia na beu ni kanie leleka 'oe kwatea na malefo 'isi ne nia bobola fainia kwaekwaee 'oe. ");
INSERT INTO far_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Mulu rongoa na fatae talingai ki kera saea, ‘Nao 'oe si oee.’ ");
INSERT INTO far_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Boroi ma kada ne, nau ku saea fua mulu, sa ti boroi 'ana ne bubungia ta keni ana manatae wane ni oeelae, nia oee suina ana manatana. ");
INSERT INTO far_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Nia ne, dia 'oe doria fulia ta ru ta'a ana bali maa 'o'olo 'oe, 'oe lafua, 'oko 'ui 'ania fasi 'oe. Nia ta lea ga 'ana fuamu dia 'oe 'ui 'ania ta bali ana na nonimu, fasia God fi 'ui 'ania na nonimu tafau laona kula ni kwaekwaee. ");
INSERT INTO far_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ma dia 'oe doria fulia ta ru ta'a ana bali 'aba 'o'olo 'oe, siki musia ma 'oko 'ui 'ania fasi 'oe. Nia ta lea ga 'ana dia 'oe 'ui 'ania ta bali ana nonimu, fasi God fi 'ui 'ania na nonimu tafau laona kula ni kwaekwaee. ");
INSERT INTO far_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mulu rongoa suina fatae talingai ki kera saea, ‘Sa ti boroi 'ana ne lukasia na 'afe nia, nia ka kwatea kekedee ana kwailukasilae fuana.’ ");
INSERT INTO far_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Boroi ma kada ne, nau ku saea fua mulu, nao ta wane si lukasia na 'afe nia. Dia wane lukasia 'afe nia, nia ne kwatea 'afe nia ka oee. Ma dia ta wane ka adea lau na keni nai, na wane nai nia oee laugo. Te ru go ne wane saitamana ka lukasia na 'afe nia fafia, dia nia oee ana ta wane 'e'ete. ");
INSERT INTO far_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Mulu rongoa laugo na fatae talingai ki kera saea fuana wane ki 'i nao 'ua na mai, ‘Dia 'oe fangasia alangaie 'oe ana satana God, tama nao 'oe si 'oia na alangaie 'oe.’ ");
INSERT INTO far_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ma kada ne, nau ku saea fua mulu, nao 'oe si fangasia alangaie 'oe ana ta ru. Ma nao 'oe si fangasia alangaie 'oe ana 'i langi, sulia God nia gwaungai senai. ");
INSERT INTO far_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ma 'oe si fangasia alangaie 'oe ana molagali, sulia God nia gwaungai laugo 'i senai. Ma 'oe si fangasia alangaie 'oe ana 'i Jerusalem, sulia nia ne fere na kingi baita. ");
INSERT INTO far_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ma nao 'oe si fangasia alangaie 'oe ana gwaumu, sulia nia 'afitai 'oe ka saungainia tesi ifu ana gwaumu ka kwao naoma ka goa. ");
INSERT INTO far_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dia 'oe alangai, saea go, ‘Iu.’ Naoma dia 'oe si alangai, saea go ‘Nao.’ Ma dia 'oe saea lau ta ru, na ru nai leka na mai fasia sa Saetan na wane ta'a.” ");
INSERT INTO far_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Sa Jesus fata lau 'uri, “Mulu rongoa tafau na fatae talingai ki fata 'uri, ‘Dia ta wane ka falia na maana ta wane, kera kai falia laugo maana wane nai. Ma na gwa lifo laugo fuana duulana ta gwa lifo.’ ");
INSERT INTO far_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Boroi ma kada ne, nau ku saea fua mulu, nao 'oe si duua ru ne ta wane sasia ka ta'a fuamu. Dia ta wane ka fidalia na bali sate 'o'olo 'oe, alamatainia nia ka fidalia lau bali sate mauli amu. ");
INSERT INTO far_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma dia ta wane ka ngali 'oe 'uria na kwaiketoie fua ngalilana na maku lalo 'oe, alamatainia nia ngalia laugo na maku fafo baita 'oe fuana. ");
INSERT INTO far_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ma dia ta wane ka sumai 'oe fua ngalilana 'oko ru nia sulia te kada taale, 'oe ngalia lau sulia ruana kada taale. ");
INSERT INTO far_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ma 'oe kwatea fuana ta wane ne gania ta ru amu. Ma kada ta wane doria ngali langa ana ta ru amu, 'oe kwatelanga ana fuana. ");
INSERT INTO far_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mulu rongoa na fatae talingai ki fata 'uri, ‘Mulu ka kwaimani 'amulu ana wane kwaimani kamulu ki, ma mulu ka subutainia na malimae kamulu ki.’ ");
INSERT INTO far_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Boroi ma kada ne, nau ku saea fua mulu, mulu kwaimani ana malimae kamulu ki, ma mulu foa fuana sa ti ne kera famalagaigai kamulu. ");
INSERT INTO far_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Dia mulu sasi 'urinai, mulu kai alua na wele Maa kamulu 'i langi. Sulia nia saungainia na sato, ma ka tala fafia na wane ta'a ki, ma na wane lea ki tafau go, ma ka kwatea na ute fua sa tifaida ne kera fulia ru lea ki, ma fua sa tifaida ne kera fulia ru ta'a ki. ");
INSERT INTO far_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Dia mulu kwaimani go amulu fuana wane ne kera kwaimani amulu, God nao si kwaiara kamulu go. Sulia na wane ni koni malefolae ana takisi boroi, kera sasia laugo ru nai! ");
INSERT INTO far_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ma dia kamulu fata lea go amulu fainia na wane kwaimani kamulu ki, nao kamulu si 'e'ete go fasia na wane ki tafau. Sulia na wane kera ulafusia God ki boroi, kera sasia laugo ru nai! ");
INSERT INTO far_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mulu ka to 'o'olo tafau na, dia na Maa kamulu 'i langi be 'o'olo tafau.” ");
INSERT INTO far_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ma sa Jesus ka fata lau 'uri, “Mulu madafi kamulu, fasi mulu ka sasia go 'amulu ru lea ki, fua wane ki kera ka ada to'ona, ma kera ka tango kamulu fainia. Dia mulu sasi 'urinai, nao mulu si ngalia ta kwaiarae fasia Maa kamulu 'i langi. ");
INSERT INTO far_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Dia 'oe kwatea na kwatelae fuana 'afilana wane siofa ki, nao 'oe si fulangainia fuana wane ki fua sae kera ka tango 'oe fainia. Sulia na falafala nai, wane kwalabasa ki ne kera sasia. Kera kwai'adomi ana wane siofa ki laona beu fuana folae ma sulia na taale baita ki laugo, fua sae wane ki tafau ka tangoda. Ma nau ku saea fua mulu, God nao si kwatea ta kwaiarae fuada, sulia kera ngalia suina kwaiarae kera ki. ");
INSERT INTO far_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ma kada 'oe kwatea ta ru fuana kwai'adomilae, nao 'oe si fatainia fuana ta wane, ta wane kwaimani 'amu boroi nao si saitamana. ");
INSERT INTO far_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kada 'oe kwatea ta ru fuana ta wane, 'oe safungainia fasia ta wane boroi 'ana nao si ada to'ona naoma ka saitamana. Sui boroi 'ana 'oe kwate agwa ana, na Maa 'oe ne to mai langi, nia ada to'ona te ki ne 'oe sasia, ma nia kai kwatea kwaiarae fuamu.” ");
INSERT INTO far_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sa Jesus ka fata lau 'uri, “Kada kamulu foa, nao mulu si dia wane kwalabasa ne kera foa ga 'ada fua ne wane ki ka suada. Sulia kada kera foa, kera doria uulae laona beu fuana folae ki, naoma sulia taale baita ki, fua ne wane ki ka suada, ma ka fabaitada. Ma nau ku saea fua mulu, kera ngalia suina, na kwaiarae kera ki fasia na wane ne kera fabaitada ki. ");
INSERT INTO far_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ma kada 'oe foa, 'oe leka ana ta kula ne to banitai, ma 'oko to senai, ma 'oko fosia God, ne nao ta wane si ada to'ona. Sui boroi 'ana nao ta wane si ada to'omu kada 'oe foa, Maa 'oe ne to mai 'i langi ne kai suamu. Ma nia laugo ne kai kwaiara 'oe fuana te ne 'oe sasida. ");
INSERT INTO far_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ana kada mulu foa, nao mulu si dia lau wane ne kera ulafusia God. Sulia kada kera foa, kera fata gwala 'asiana, ma kera nao si saitamana madakwa ana te ki ne kera saea. Manatada fia dia kera foa gwala 'urinai, god kera ki kai rongoda. ");
INSERT INTO far_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ma nao mulu si sasi lau dia kera, sulia Maa kamulu 'i langi nia saitamana tafau te ki ne mulu bobo 'uria, sui mulu fi gania. ");
INSERT INTO far_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Iu, ana kada mulu foa, mulu fata 'uri, ‘Maa kalu 'i langi 'ae, Kalu doria wane ki tafau kera ka fabaita satamu, sulia nia 'e abu 'asiana. ");
INSERT INTO far_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Dao mai ana gwaungaie 'oe fafia maurilana wane ki tafau. Ma kwaidoria 'oe kera kai sasia 'i ano dia laugo ne kera sasia 'i langi. ");
INSERT INTO far_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","'Oe kwatea mai fua malu na fanga ne bobola fuana maedangi ne. ");
INSERT INTO far_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","'Oe manatalugea ta'alae kalu ki, dia laugo ne kalu manatalugea ta'alae wane ki tafau ne kera fulia ru ta'a ki fua malu. ");
INSERT INTO far_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","'Oe nao si ala'ani kalu fuana ilitoe ka liufi kalu. Ma 'oko susi kalu fasia sa Saetan.’ ");
INSERT INTO far_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Aia, ma dia mulu manatalugea sa ti ne fulia ru ta'a ki amulu, Maa kamulu 'i langi nia manatalugea laugo ta'alae kamulu ki. ");
INSERT INTO far_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ma dia kamulu si manatalugea sa ti ne nia fulia ru ta'a ki amulu, Maa kamulu 'i langi boroi nao si manataluge kamulu laugo.” ");
INSERT INTO far_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sa Jesus ka fata lau 'uri, “Ana kada kamulu abu fanga fuana folae nao mulu si dia wane kwalabasa ki. Sulia kada kera abu fanga, kera ada dia wane kera kwaimanatai ki fua wane ki ka ada to'ona ne kera abu fanga, ma kera ka fata lea ada. Aia, ma nau ku saea fua mulu, na wane ne ki 'afitai kera ka ngalia ta kwaiarae lau, sulia wane ki kera kwatea na kwaiarae kera ana tangolada. Ma God nao si kwatea na ta kwaiarae fuada. ");
INSERT INTO far_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Boroi ma ana kada 'oe abu fanga, 'oe sisiu 'amu, ma 'oko salaka ifu 'amu dia ne 'oe sasia sulia maedangi ki tafau, ");
INSERT INTO far_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","fua ta wane si ada saitamamu ne 'oe abu fanga. Sui boroi 'ana ta wane si ada saitamamu, Maa 'oe 'i langi nia ada ga 'ana to'omu, ma nia kai kwatea na kwaiarae fuamu sulia te ki ne 'oe sasia. Nia saitamana ka suamu sulia dangi ki, sui boroi 'ana nao 'oe si ada to'ona.” ");
INSERT INTO far_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Sui, sa Jesus ka fata lau 'uri, “Mulu si konia toorue kamulu ki 'i seki laona molagali ana kula ne subu ma furalae kai falia, ma na wane beli ki ka belia. ");
INSERT INTO far_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mulu konia na toorue kamulu ki 'i langi, kula subu ma na furalae si falia, ma na wane beli nao si belia. ");
INSERT INTO far_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Sulia kada na toorue kamulu nia to 'i langi, na maurilamulu ka agwai tafau na 'uria 'i langi. Ma kada na toorue kamulu nia to laona molagali, na maurilamulu ka agwai tafau na 'uria ru laona molagali ki. ");
INSERT INTO far_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Sulia dia maamu nia lea, 'oko to laona madakwalae ana famanatalae God, sulia maamu ne 'e dau talaia mai madakwalae laona nonimu. ");
INSERT INTO far_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Dia nao 'oe si ada to'ona na madakwalae ne, maamu ne ta'a, ma 'oko to ga 'amu laona maerodo. Mulu madafi kamulu, suli dia mulu noni'ela ana madakwalae God, laona maurilamulu nia rodoa 'asiana.” ");
INSERT INTO far_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“'Afitai ta wane ka rao fuana ro wane baita 'e'ete. Dia nia 'urinai, nia kai malimae ana ta wane baita, ma ka kwaimani ana ta wane baita. Ma nia kai rao lea fuana ta wane, ma ka luka faburi ana ta wane. Nia ne, ka 'afitai 'asiana dia ne mulu rao fuana God ma na malefo lau ana te kada. ");
INSERT INTO far_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nia ne nau ku saea fua mulu, nao mulu si manata 'abero sulia te ne mulu kai 'ania, ma mulu ka kufia, ma te ne mulu kai ofi ana fafia noni mulu. Sulia na maurie ne, nia lea liufia na fanga, ma na noni ne, nia lea liufia na maku. ");
INSERT INTO far_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ada to'ona na fa no ki laona salo, kera nao si 'abero go sulia raoe ana ta oole. Ma kera nao si konia go ta fanga, ma kera si saungainia go ta 'o'obe fuana alu fangalae. Boroi ma Maa kamulu 'i langi sangonida ga 'ana. Aia, God nia ada baita amulu ka liufia fa no ki. Nia ne, God ka sangoni kamulu. ");
INSERT INTO far_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Sui boroi 'ana mulu ka manata 'abero sulia maurie kamulu ki, nia 'afitai mulu sasia maurilamulu ka te tau tu'u lau. ");
INSERT INTO far_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ma 'uta mone ne mulu ka manata 'abero sulia na maku ki? Mulu ada to'ona basi na takana 'ai ne kera afuraga ki. Kera nao si rao go, ma kera nao si saungainia go ta maku fuada. ");
INSERT INTO far_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ma nau ku saea fua mulu, kera ada kwanga ka liufia maku ne sa Solomon na kingi nia 'afisida ki. ");
INSERT INTO far_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ma na takana 'ai ki, kera to ga 'ada sulia ka kada kokoru, ma kera ka 'ui laugo 'anida laona ere. Sui ka 'urinai boroi 'ana, God nia famasada ana ru lea ki. 'Uri ma kamulu fitala sae God nao si famasa kamulu laugo? Na fitoe kamulu ki nia tu'u. ");
INSERT INTO far_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Nia ne, nao mulu si manata 'abero 'uri, ‘Na fanga, ma na ru ni kufilana, ma na maku nau ki kai leka mai fasia 'i fai?’ ");
INSERT INTO far_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Iu, wane ne kera to manata buro ana God, kera saitamana manata 'abero sulia ru nai ki. Boroi ma, na Maa kamulu 'i langi nia saitamana suina ne mulu doria ru nai ki. ");
INSERT INTO far_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mulu ka doria lalau 'amulu na maurie ne God nia gwaungai ana fainia sasilana ru 'o'olo ki. Dia mulu sasi 'urinai, God kai kwatea ru ne mulu dorida ki. ");
INSERT INTO far_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nia ne, nao mulu si manata 'abero sulia kwaidorie fuana malakwasi. To na 'ana fuana malakwasi. Nao si bobola fuana mulu kai konia na 'aberolae malakwasi ki fainia na 'aberolae ana maedangi ta'ena laugo. Sulia maedangi ta'ena to ana 'aberolae bobola fainia ta'ena.” ");
INSERT INTO far_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ma sa Jesus ka fata lau 'uri, “Nao mulu si ketoa ta wane 'e'ete, fasia God kai keto kamulu laugo. ");
INSERT INTO far_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Dia mulu ketoa ta wane, God kai keto 'urinai laugo amulu. Ma taki te ne mulu ketoa ta wane ana, na taki nai laugo ne God kai keto kamulu ana. ");
INSERT INTO far_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","'Oe too ana ta'alae baita ki, boroi ma 'oe ngatafia ga 'amu ta wane ne nia too ana ta'alae tu'u. 'Oe dia wane ne nia ada to'ona na gegeo laona maana sa tolana, boroi ma nia si ada to'ona go ta bui ano baita ne nia laona maana tala'ana. ");
INSERT INTO far_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ma 'oe ka fata 'uri fuana wane 'e'ete, ‘'Oe fulia ru ne nia ta'a, alamatainia nau fa'o'olosia maurilamu.’ Boroi ma 'oe si manata go sulia ta'alae baita ne 'oe sasida ki. ");
INSERT INTO far_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","'Oe na wane kwalabasa. 'Oe fasia basi na ta'alae 'oe ki. Sui, 'oe fi bobola fuana kwai'adomilae kau ana ta wane 'e'ete fuana ta'alae nia ki. ");
INSERT INTO far_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ma nao mulu si kwatea ru abu ki fuana fa kui ki, fasia kera ka abulo, ma kera ka 'ala kamulu. Ma nao mulu si kwatea na gwaalaungi kamulu ki fuana boso ki, fasia kera ka liu ga 'ada fafona.” ");
INSERT INTO far_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sa Jesus ka fata lau 'uri, “Mulu ka gania God fua mulu ka ngalia ru ne mulu gani 'uria. Mulu nanisia kwaidorie kamulu ki ana God, ma nia kai 'adomi kamulu, fua mulu ka dao to'ona. Mulu ka kidikidi ana mae, ma God kai 'ifi fua mulu. ");
INSERT INTO far_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Sulia wane ne kera gani ana God, kera ngalia na ru ne kera gania. Ma wane ki ne kera nanisia ru kera doria ki ana God, kera kai dao to'ona. Ma wane ki tafau ne kera kidikidi ana mae, God kai 'ifi fuada. ");
INSERT INTO far_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“'Uri ma, sa ti amulu na maa ki, ne dia na wele 'oe nia gani 'uria fanga, ma 'oko kwatea lalau na fau fuana? ");
INSERT INTO far_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ma dia na wele 'oe nia gani 'uria ta ie, ma 'oko kwatea lalau fa tafo fuana? Nao 'asiana! ");
INSERT INTO far_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Sui boroi 'ana kamulu wane ta'a ki, mulu saitamana kwatelana na ru lea ki fuana wele kamulu ki. Boroi ma na Maa kamulu ne nia 'i langi, nia lea ka liufi kamulu. 'Urinai nia kai kwatea ru lea ki fuana wane ne kera gani nia 'urida. ");
INSERT INTO far_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Ta te ne mulu doria ana wane 'e'ete ki fua kera ka sasia fua mulu, mulu ka sasia laugo fuada. Sulia nia ne na fadalana na famanatalae ana taki sa Moses, ma na profet ki tafau.” ");
INSERT INTO far_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sa Jesus ka fata lau 'uri, “Mulu ka ru kau ana mae ne sukoni, sulia na taale ma na mae ne baita ma ka reba, nia leka 'uria na maea toto firi. Ma na lekalae sulia ka ngwaluda, ma na wane 'oro ki ne leka sulia na taale nai. ");
INSERT INTO far_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Aia, na taale ma na mae ne sukoni nia leka 'uria na maurie firi, ma lekalae sulia ka 'afitai, ma bara wane go ne kera leka sulia.” ");
INSERT INTO far_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sa Jesus ka fata lau 'uri, “Mulu ka madafi kamulu fasia na profet suke ki. Mulu madafi kamulu sulia kera ada dia wane lea ki, boroi ma manatalada ne dia kui kwasi ki ne kera doria falilamulu. ");
INSERT INTO far_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ma mulu kai ada saitamana go 'amulu na profet suke nai ki ana ru ta'a ne kera sasida ki. Kulu saitamana 'ai ki tafau ne lea naoma ka ta'a, sulia fufue ru ne kera fungu ana ki. Ma nia 'afitai ta wane ka ngeda na fufuana 'ai lea fasia na 'oko ngangara. ");
INSERT INTO far_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ma na 'ai lea nia fungu ana fueru lea ki, ma na 'ai ta'a nia fungu laugo ana fueru ta'a ki. ");
INSERT INTO far_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","'Ai lea 'afitai ka fungu ana fueru ta'a, ma 'ai ta'a 'afitai ka fungu ana fueru lea. ");
INSERT INTO far_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","'Ai ki ne nao si fungu ana ta fueru lea, kera kai tofuda, ma kai 'ui 'anida laona ere. ");
INSERT INTO far_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nia ne, nau ku saea fua mulu, mulu kai ada saitamana na profet suke ana ru ne kera sasida ki.” ");
INSERT INTO far_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Sa Jesus ka fata lau 'uri, “Nao lau wane ki tafau ne fata 'uri aku, ‘'Aofia 'ae, 'Aofia 'ae,’ ne kera kai to fainia wane ne God gwaungai fafida ki. Ma sa tifaida ne kera sasi sulia kwaidoria Maa nau 'i langi go ne, kera kai to fainia wane ne God kai gwaungai fafida ki. ");
INSERT INTO far_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ma na wane 'oro ki kera kai fata 'uri fuaku ana maedangi ana kwaiketoilae nai, ‘'Aofia 'ae, kalu fata na sulia fatalana God ana satamu, ma kalu ka ifulangainia anoeru ta'a ki ana satamu, ma kalu ka sasia ru 'oro ni kwelelae ki ana satamu.’ ");
INSERT INTO far_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Boroi ma nau kai fata madakwa 'uri fuada, ‘Nau nao si saitamamulu. Mulu na wane ta'a ki. Mulu leka tau kau fasi nau!’ ");
INSERT INTO far_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nia ne, wane ki ne kera rongoa faoraie nau ki, ma ka sasi sulia, kera dia na wane lioto ne nia saungainia lume nia fafona mae funu 'ai ki ne nia 'elida ka koso lola lao ano. ");
INSERT INTO far_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na ute baita ka to, ma kafo ki ka igwa, ma na kuburu baita ka kwaea na lume nai, boroi na lume nai nao si 'asia, sulia nia uu ngasi fafona mae funu 'ai ngasi ki. ");
INSERT INTO far_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“Ma na wane ne kera rongoa faoraie nau ki, ma nao si sasi sulia, kera dia na wane oewanea ne saungainia na lume nia fafona one, ma nao nia si 'elia mae funu 'ai ki ka koso lola. ");
INSERT INTO far_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Na ute baita ka to, ma kafo ki ka igwa, ma na kuburu baita ka kwaea na lume nai, ma na lume nai ka 'asia, ma ka takalo tafau na.” ");
INSERT INTO far_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ana kada sa Jesus famanata na wane ki ana ru ki tafau ka sui, kera ka kwele 'asiana, ");
INSERT INTO far_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","sulia sa Jesus nia famanata ana nikilalae God. Na famanatalae nia nao si dia lau famanatalae wane famanata ana taki ki. ");
INSERT INTO far_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Kada sa Jesus nia koso na mai fasia gwauna fa uo nai, na fikue baita kera leka mai sulia. ");
INSERT INTO far_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ma te wane ne kuu saungia nonina nia leka mai, ma ka boruru naofana sa Jesus, ma ka fata 'uri, “'Aofia 'ae, dia 'oe nonimabe, 'oe saitamana gura nau ga 'amu.” ");
INSERT INTO far_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sa Jesus ka taga kau na 'abana, ma ka samo to'ona nonina, ma ka fata 'uri, “Iu, nau ku nonimabe. 'Oe mafo na.” Ma 'ali'ali burina faoraie nai ki ne sa Jesus nia saea fuana, na kuu nai ka siki na fasia wane nai. ");
INSERT INTO far_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Sa Jesus ka fata 'uri fuana, “Nao 'oe si farongoa ta wane ana ru ne nau ku sasia fuamu. Boroi ma 'oe leka basi, ma 'oko fatainia nonimu fuana fataabu God, 'oko alamatainia fataabu God ka iroa nonimu. Sui 'oko kwatea afafue 'oe dia be sa Moses nia saea fua kwatelana, fua kai kwatea famamanae fuana wane ki tafau ne nonimu nia mafo na.” Ma sa Jesus ka kwatea wane nai ka leka na 'ana. ");
INSERT INTO far_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ma kada sa Jesus nia dao na ana fere 'i Kapaneam, te wane fanaonao ana wane ni omee ki fasia 'i Rom, nia leka mai siana sa Jesus, ma ka gani fua nia kai 'adomia ");
INSERT INTO far_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ma ka 'uri, “'Aofia 'ae, na wane rao nau, nia matai 'asiana, ma ka tio ga 'ana, ma ka nao si abulotainia go nonina, ma na nonina ka fii 'asiana.” ");
INSERT INTO far_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Sa Jesus ka fata 'uri fuana, “Lea ga 'ana, nau kai leka mai 'uria lume 'oe fua guralana.” ");
INSERT INTO far_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ma wane fanaonao ne ka fata lau 'uri fuana sa Jesus, “'Aofia 'ae, nau nao si bobola fua ne 'oe leka mai 'i laona lume nau. 'Oe fata go mai 'amu, ma na wane ni rao nau kai 'akwa na. ");
INSERT INTO far_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nau ku saitamana 'oe bobola ga 'amu fuana sasilana ru nai, sulia nau talaku na wane nau ku rao farana na wane baita ki, ma nau ku too ana wane ni omee ki ne kera rao farana gwaungaie nau. Ma dia nau ku fata 'uri fuana ta wane, ‘'Oe leka,’ ma nia ka leka na. Ma dia nau ku fata 'uri fuana ta wane, ‘'Oe leka mai,’ nia ka leka laugo mai. Ma dia nau ku saea ta wane rao nau, ma ku 'uri, ‘'Oe sasia ru ne,’ nia ka sasia na.” ");
INSERT INTO far_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ma kada sa Jesus rongo na ru nai, nia ka kwele 'asiana. Ma nia ka abulo fuana wane ne kera leka sulia ki, ma ka fata 'uri fuada, “Nau ku saea fua mulu, nau si ada to'ona 'ua ta wane ne nia famamana 'uri, sui boroi 'ana laona 'i Israel. ");
INSERT INTO far_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ma nau ku saea fua mulu, wane 'oro ne nao lau Jiu ki kai leka mai fasia fere 'oro laona molagali fua 'adolae fainia koko kia ki sa Abraham, sa Aesak, ma sa Jakob ana fafanga ana elelae 'i langi. ");
INSERT INTO far_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ma 'orolada Jiu ki ne tala'ana kera ka 'ado ana ru lea ki 'i langi, God kai lalida 'uria kula rorodoa. Ma kada kera to ana kula nai, kera kai angi, ma kera kai 'ala girigiri ana lifoda, sulia kera nonifi.” ");
INSERT INTO far_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ma sa Jesus ka abulo lau fuana wane baita nai, ka fata 'uri fuana, “'Oe oli kau. Nau ku sasia na ru ne 'oe gania, sulia 'oe famamana nau.” Ma ana kada nai go, na wane rao be nia ka 'akwa na. ");
INSERT INTO far_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ma ana te maedangi, sa Jesus ka leka mai 'i lume sa Pita. Kada sa Jesus ru 'i lume, nia ka ada to'ona fungo keni sa Pita nia tio ga 'ana, ne nia matai ana 'ako'akolae baita. ");
INSERT INTO far_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ma sa Jesus ka samo to'ona 'abana na keni ne. Ma ana kada nai go, na 'ako'akolae nai ka sui na fasia. Nia ka 'akwa na, ma ka tatae ka sasi fanga na fua sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ma kada nia saulafi na, wane ana fere nai kera ka ngalia mai wane 'oro ki siana ne anoeru ta'a ki rufida. Ma sa Jesus ka ifulangainia anoeru ta'a nai ki fasida ana fatalana go. Ma nia ka gura laugo wane matai ki tafau. ");
INSERT INTO far_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kada nia sasia na ru nai ki, nia famamana na fatalana na profet Aesaea be kedea ka fata 'uri, “Nia ne famauri kia fasia na mataie ki.” ");
INSERT INTO far_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ma kada sa Jesus nia ada to'ona wane 'oro kera oku mai kalikalia, nia ka fata 'uri fuana fafurongo nia ki, “Kulu tofolo 'uria bali 'osi loko.” ");
INSERT INTO far_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ana kada nai laugo, te wane famanata ana taki ki 'e leka mai siana sa Jesus ka fata 'uri, “Wane Famanata 'ae, nau doria ku leka fai 'oe 'i fai boroi 'ana ne 'oe leka 'uria.” ");
INSERT INTO far_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kada sa Jesus rongoa fatalana, nia ka fata 'uri, “Nao nia si ngwaluda. Na kui kwasi ki kera too ana na kula kera ki fuana tiolae, ma na no ki laugo kera too ana na nui kera ki. Boroi ma nau, na Wele nia Wane, nau nao si too ana ta lume fuana maleulae ana.” ");
INSERT INTO far_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ma te wane ana fafurongo nia ki, ka fata fuana sa Jesus ka 'uri, “'Aofia 'ae, 'oe alamatainia fua nau kai leka, ku to basi fainia maa nau leka nia mae, nau ku faitoli ana ka sui, nau ku fi leka kau suli 'oe.” ");
INSERT INTO far_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sa Jesus olisia ka fata 'uri, “Nao. 'Oe leka na mai fai nau ana kada nai. Alamatainia wane ne kera mae na, kera kai faitoli na 'ada ana wane mae kera ki.” ");
INSERT INTO far_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ma sa Jesus ka tae laona baru fainia fafurongo nia ki. ");
INSERT INTO far_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ma ana kada kera 'idu tau na kau, mae kuburu ka dao 'ali'ali mai, ma na asi ka lulua, ma ka magara na mai fafia na baru nai. Ma na baru nai karangi kai kuruu na. Boroi ma sa Jesus nia ka maleu ga 'ana laona baru nai. ");
INSERT INTO far_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na fafurongo nia ki kera ka faada, kera ka fata 'uri, “'Aofia 'ae! 'Oe famauri kulu! Kulu karangi mae na.” ");
INSERT INTO far_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ana kada nai sa Jesus ka fata 'uri fuada, “'Uta ne kamulu ka mau? Nau ku ada to'ona na famamanalae kamulu aku nao si baita.” Sa Jesus ka fata 'urinai fuada ka sui, nia tatae, ma ka fata nikila fuana kuburu ma na nanafo, fua kera ka aroaro. Ma ana kada nai go, na kuburu ma na nanafo ki kera ka aroaro na, ma ka fola na. ");
INSERT INTO far_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ma na fafurongo nia ki kera kwele 'asiana, ma kera fata 'uri, “Wane 'uta ne? Na kuburu ma na nanafo boroi kera ro na sulia!” ");
INSERT INTO far_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ma kada kera dao na ana bali 'osi ana mae fere 'i Gadara, sa Jesus ka dao to'ona ro wane ne anoeru ta'a ki to adaro. Ro wane ne ki keroa to mai laona mae faoda fuana alulana wane mae ki. Ma sulia keroa balubalua 'asiana, ne kwate ma nao ta wane si dao karangia go kula ne keroa to ana. ");
INSERT INTO far_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ana kada anoeru ki ne to ana ro wane nai ki, kera ada to'ona sa Jesus, kera ka akwa 'uri, “Wele God 'ae, te ne 'oe doria sasia amalu? 'Uri ma 'oe leka mai fua famalagaigai lamalu 'i naona kada ne fagaigailae kai dao?” ");
INSERT INTO far_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ana kada nai, na boso 'oro ki kera fanga karangia senai. ");
INSERT INTO far_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Na anoeru nai ki kera gania sa Jesus kera 'uri, “Dia 'oe ifulangai kalu, 'oe ala'ani kalu leka 'uria laona boso loko ki.” ");
INSERT INTO far_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ma sa Jesus ka fata 'uri fuana anoeru nai ki, “Mulu leka na!” Ma kera ka ru tafa mai, ma kera ka leka na laona boso nai ki. Ma boso nai ki kera lae toli na sulia ninimana obaraoe nai 'uria laona 'osi be. Ma kera ka mae tafau senai. ");
INSERT INTO far_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ma na wane ne kera ada sulia boso nai ki, kera ka lae 'ali'ali 'uria fere kera. Ma kera ka fata sulia ru ne sa Jesus sasia, ma na te ne nia fuli fuana ro wane be ki fainia na anoeru be ki. ");
INSERT INTO far_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ma na wane ki tafau ana mae fere nai kera ka leka mai fuana adalae to'ona sa Jesus. Ana kada kera dao siana, kera ka odua fua nia leka fasia fere kera. ");
INSERT INTO far_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Aia, sa Jesus fainia na fafurongo nia ki, kera ra laona baru, ma kera ka tofolo lau ana 'osi baita nai 'i Galili. Ma kada kera dao na ana fere nia 'i Kapaneam, ");
INSERT INTO far_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","tani wane kera ka ngalia mai te wane ne nonina mae 'i fafona 'ifitai siana sa Jesus, fua nia ka gura. Ma kada sa Jesus nia ada saitamana na famamanae kera, nia ka fata 'uri fuana wane nonina mae nai, “Nao 'oe si mau lau wele nau. Nau ku manatalugea na ta'alae 'oe ki.” ");
INSERT INTO far_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ana kada nai, tani wane famanata ana taki ki kera manata 'uri, “Taifilia God go ne saitamana manatalugea ta'alae ki. Nia fabolotania fainia God.” ");
INSERT INTO far_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ma sa Jesus nia saitamana go ana manatairu kera ki laona lioda, ma nia ka fata 'uri fuada, “Mulu si manata ta'a lau 'urinai.” ");
INSERT INTO far_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","'Urinai nia ka fata 'uri, “Dia nau ku fata 'uri fuana wane nonina mae ne, ‘Ta'alae 'oe ki, nau ku manatalugea na,’ nao mulu si ada to'ona go ne nia fuli. Boroi ma dia nau ku fata 'uri, ‘Tatae, ma 'oe fali,’ senai kamulu ka fi ada to'ona ne nikilalae 'e nia aku fuana guralae. ");
INSERT INTO far_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kada nau gura wane ne, nau fatainia fua mulu ne nau, na Wele nia Wane, nau ku too ana nikilalae fua manatalugelana na ta'alae ki.” Sui sa Jesus ka fata 'uri fuana wane nonina mae nai, “'Oe tatae, ngalia 'ifitai 'oe, ma 'oko leka na fere 'oe.” ");
INSERT INTO far_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ana kada nai go, wane nai ka tatae, ma ka oli na 'uria fere nia. ");
INSERT INTO far_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ana kada ne wane ki kera ada to'ona te ne sa Jesus nia fulia, kera kwele, ma kera mau. Ma kera ka tangoa God sulia nia kwatea na nikilalae 'urinai fuana wane ki. ");
INSERT INTO far_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ma kada sa Jesus nia leka na fasia kula nai, nia ka ada to'ona sa Matiu. Nia gouru ga 'ana ana kula fuana konilana malefo ana takisi, sulia ne nia rao senai. Ma sa Jesus ka fata 'uri fuana, “'Oe leka mai fai nau.” Ma sa Matiu tatae, ma ka leka na fainia. ");
INSERT INTO far_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ma burina ne sa Jesus nia talaia sa Matiu fuana fafurongo nia, nia ka leka fanga na 'i lume nia. Ma na tooa ni koni malefo ana takisi ki to laugo senai. Ma tani wane aburongo, kera fanga laugo fainia sa Jesus ma na fafurongo nia ki. ");
INSERT INTO far_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ma kada Farasi ki kera ada to'ona ru nai, kera ka fata fuana fafurongo nia ki kera 'uri, “Nia bobola fuana nia si fanga lau fainia wane aburongo ki.” ");
INSERT INTO far_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Sa Jesus ka rongoa ru nai, ma ka fata 'uri, “Wane ne nao kera si matai ki, kera si doria go ta wane kwaigurai, boroi ma wane ne kera matai ki, kera ka bobo 'uria wane kwaigurai. ");
INSERT INTO far_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mulu manata basi sulia fadalana Kekedee Abu be 'uri, ‘Nau dori kamulu kai kwaimanatai fuana wane ki, ma nao lau na afafue kamulu ki.’ Nau kusi leka lau mai fuana riilae 'uria wane 'o'olo ki fua kera kai kari abulo, boroi ma na wane ne abulolada ta'a ki lalau ne, nau ku leka mai fuana riilae 'uria tatala manatalae.” ");
INSERT INTO far_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Burina ru nai ki, na fafurongo sa Jon wane ni Siuabu ki, kera leka mai siana sa Jesus, kera ka fata 'uri, “Kalu fainia na Farasi ki, kalu saitamana kalu ka abu fanga. Ma 'uta mone ne fafurongo 'oe ki nao si sasi 'urinai?” ");
INSERT INTO far_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ma sa Jesus ka olisida ka 'uri, “Nia si bobola fua tooa ne kera too ana fafanga ana araie ne kera kwaimanatai. Sulia ne, kada arai falu nia ga 'ana 'ua faida, wane ki kera eele. Boroi ma kada kai dao mai kada ne kera kai talaia na arai falu fasida. 'Urinai, kera fi abu fanga, sulia ne kera kwaimanatai. Nia ne nao si bobola fua fafurongo nau ki kera ka abu fanga kada nau ku to 'ua ga 'aku faida.” ");
INSERT INTO far_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sui sa Jesus ka fata lau 'uri, “Nao ta wane si modea ta maku ne nia muu ana ta ngingisi maku falu. Sulia dia nia sasi 'urinai, na ngingisi maku falu nai ka musia na maku 'ua nai sulia maku falu nia lukuluku burina taufilana, ma nia ka sasia mae kwakwa ne 'e baita 'asiana. ");
INSERT INTO far_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ma mulu saitamana laugo, nia nao si bobola fuana ta wane ka alua waeni falu laona ngwai 'ua ana 'ungana nanigot, sulia ngwai 'ua nai si bose. Dia nia sasi 'urinai, kada na waeni nai kai torotoro go mai, nia ka musia na ngwai 'ua nai, ma na waeni nai ka 'igitai, ma na ngwai nai ka ta'a na. Nia ne wane kai alua waeni falu 'i laona ngwai falu ne nia saitamana kai bose fua ro ru nai ki nao si ta'a.” ");
INSERT INTO far_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kada sa Jesus nia fatae 'ua, te wane fanaonao ana wane Jiu ki 'e leka mai. Ma nia ka boruru 'i naona sa Jesus, ma ka fata 'uri, “Na wele keni nau fi mae go. Nau ku doria 'oe leka mai fua 'oe alua 'abamu fafia fua nia ka mauri lau.” ");
INSERT INTO far_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ma sa Jesus fainia na fafurongo nia ki kera ka leka fainia wane nai. ");
INSERT INTO far_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma ana kada kera leka 'ua ga 'ada, te 'afe ne gwa 'abu tafangia, ma nia ka matai ana sulia akwala ma ro fangali ki, nia ka leka mai burina sa Jesus, ma ka samo to'ona kakamuna maku gwala nia. ");
INSERT INTO far_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Sulia na keni ne nia manata 'uri, “Sui boroi 'ana dia nau ku samo to'ona na kakamuna maku sa Jesus, nau ku 'akwa na.” ");
INSERT INTO far_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Kada nia samo to'ona na kakamuna maku nia, sa Jesus ka abulo, ma ka ada to'ona na keni nai, ma ka fata 'uri fuana, “'Oe si manata 'abero lau. 'Oe 'akwa na, sulia 'oe famamana nau.” Ma ana kada nai go, na mataie nai ka suina fasia. ");
INSERT INTO far_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ma kada sa Jesus fainia na fafurongo nia ki kera dao, kera ru 'i lume wane fanaonao nai, kera ka ada to'ona na wane ki kera ufia na 'au ana maea, ma na wane 'oro ki lau go kera oku senai, ma kera ka angi. ");
INSERT INTO far_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ma sa Jesus ka fata 'uri fuana wane nai ki, “Kamulu tafau go mulu ru 'i maa. Wele keni ne nao si mae go, boroi ma nia maleu ga 'ana.” Kada kera rongoa sa Jesus nia fata 'urinai, kera ka waelasia lalau. ");
INSERT INTO far_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ma 'i burina na wane ki kera ka leka fasia, sa Jesus ka ru kau laona mae lume ne wele keni nai tio ana, ma ka samo 'i maana 'abana wele keni nai, ma nia ka tatae. ");
INSERT INTO far_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Burina ru ne sa Jesus nia sasia, na faoraie sulia talofia na lofaa nai tafau. ");
INSERT INTO far_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Burina sa Jesus nia leka kau fasia kula nai, na ro wane maada rodo ki keroa leka burina sa Jesus, keroa ka akwa, ma keroa ka fata 'uri, “'Oe Wele ana kwalafa sa Deved, 'oe manatai karo!” ");
INSERT INTO far_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ma ana kada sa Jesus nia ru 'i laona te lume, ro wane maada rodo nai ki keroa ka ru laugo 'i burina. Ma sa Jesus ka fata 'uri fuadaro, “'Uri ma kamoro famamana ne nau bobola fuana guralana maamoro?” Ma keroa ka olisia ka fata 'uri, “Iu, 'Aofia.” ");
INSERT INTO far_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ma sa Jesus ka samo to'ona na maadoro, ka fata 'uri, “Sulia ne kamoro famamana, ru nai ka fuli mamana na fuamoro.” ");
INSERT INTO far_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ma na maadoro ka ada na, ma sa Jesus ka fata nikila fuadaro nao keroa si farongoa ana ta wane. ");
INSERT INTO far_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Boroi ma kada keroa ru na kau, keroa fi fata na 'adaro sulia sa Jesus siana sa tifaida ne keroa dao to'ona laona lofaa nai. ");
INSERT INTO far_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aia, ma kada ro wane be ki keroa ru kau, tani wane kera ngalia lau mai te wane siana sa Jesus. Na ngiduna wane nai ato, sulia te anoeru ta'a ne rufia. ");
INSERT INTO far_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ma sa Jesus ka ifulangainia anoeru ta'a nai fasia wane nai. Sui, na wane ne ka fata laugo 'ana. Ma na wane ne kera oku ana kada nai, kera ka kwele 'asiana ana, ma kera ka fata 'uri, “Nao kulu si ada to'ona 'ua mai ta ru 'uri 'i Israel!” ");
INSERT INTO far_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Boroi ma na Farasi ki, kera ka ngengea sa Jesus, kera 'uri 'ada, “Wane gwaungai ana anoeru ta'a ki ne kwatea nikilalae fuana wane ne ka ifulangainia ana anoeru ta'a ki.” ");
INSERT INTO far_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ma kada sa Jesus nia liu ana fere baita ki ma na mae fere tu'u ki, nia ka famanata laona beu fuana folae kera ki, ma ka fulangainia na Farongoe Lea sulia 'Initoe God, ma ka gura wane ne kera matai ana mataie 'e'ete ki tafau. ");
INSERT INTO far_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ma sa Jesus nia ada to'ona na konie nai, ma ka kwaimanatai 'asiana fuada sulia kera ka manata 'abero, ma kera si bobola fua 'afilada talada. Kera dia sipsip ki ne nao ta wane fuana adalae sulida. ");
INSERT INTO far_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ma nia ne sa Jesus ka fata 'uri fuana fafurongo nia ki, “Na wane ne kera sasi akau na fuana famamanalae ana God ki, kera dia na ru 'oro ki 'i laona oole fuana konilada. Boroi ma, wane fuana konilana na ru nai ki, kera si 'oro. ");
INSERT INTO far_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Nia ne, mulu fosia God fua nia kwatea mai wane ni rao ki fai kamulu.” ");
INSERT INTO far_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sa Jesus ka saea na mai akwala ma ro wane fafurongo nia ki siana, ma ka kwatea na nikilalae fuada fuana ifulangailana na anoeru ta'a ki, ma fuana guralana na mataie 'oro 'e'ete ki tafau. ");
INSERT INTO far_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ma na satana na akwala ma ro lifurongo nia ki ne 'uri: etana, sa Simon (ne nia saea laugo ana sa Pita), ma na wanefuta nia sa Andru, ma sa Jemes ma sa Jon, ro wele sa Sebedi ki. ");
INSERT INTO far_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ma sa Filip, ma sa Batolomiu, ma sa Tomas, ma sa Matiu, na wane ni konilana malefo ana takisi, ma sa Jemes na wele sa Alfeas, ma sa Tadeas, ");
INSERT INTO far_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ma sa Simon, ta wane ana tooa Jiu ne kera doria tarilana na wane Rom ki fasia 'i Israel, ma sa Jiudas Iskariot na wane be nia 'olomaelana sa Jesus fuana malimae nia ki. ");
INSERT INTO far_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ma sa Jesus ka odua na akwala ma ro wane nai ki, ka 'uri, “Nao mulu si leka 'i safitana wane nao lau Jiu ki, ma mulu si ru 'i laona tani fere ana wane 'i Samaria ki. ");
INSERT INTO far_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Mulu leka lalau 'amulu siana wane Israel ki, ne kera dia na sipsip ki ne kera tafeo na 'ada. ");
INSERT INTO far_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ma ana kada kamulu leka, kamulu ka fulangainia 'uri, ‘Kada God kai gwaungai ana wane nia ki, nia dao karangi kamulu na!’ ");
INSERT INTO far_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ma mulu kai gura wane matai ki, ma mulu kai taea wane mae ki, ma mulu kai gura na wane ne kuu nia saungida ki, ma mulu kai ifulangainia na anoeru ta'a ki. Kamulu ngali 'o'oni ana, 'urinai ne mulu kwate 'o'oni laugo. ");
INSERT INTO far_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Na wane ni rao, nia bobola fuana wane ki ka ada sulia. Nia ne ana kada kamulu leka, nao mulu si 'abero 'uria dau fafilana ta malefo. Nao mulu si ngalia ta ngwai. Ma nao mulu si ngalia ta ro 'aba maku naoma ta ruana tae butu, naoma ta fa kubau boroi. ");
INSERT INTO far_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ma dia kamulu dao ana ta fere, mulu ada 'uria ta wane ne doria kai kwalo kamulu 'uria 'i laona lume nia. Ma mulu to fainia wane nai leka ka dao ana kada mulu leka fasia mae fere nai. ");
INSERT INTO far_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ma ana kada kamulu ru 'i laona ta lume, mulu fata 'uri fuana wane ne kera to senai, ‘God kai falea kamulu, ma na aroaroe nia kai to fai kamulu 'i laona lume ne.’ ");
INSERT INTO far_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Dia ne wane laona lume nai kera kwaimani fai kamulu, na falealae kamulu kai to laugo fai kera. Ma dia nao, na falealae nai ka oli laugo mai fua mulu. ");
INSERT INTO far_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Aia, ma dia kamulu dao ana ta fere, ma nao ta wane si nonimabe go fuana kwalo kamulu laona lume nia, naoma kera ka noni'ela ana rongolana fatalamulu, mulu leka fasia senai. Ma ana kada mulu leka fasia, mulu tafusia gegeona ano fasia 'aemulu dia na fabasue na fuada ne God kai keto kera, sulia kera noni'ela ana rongolana fatalana God. ");
INSERT INTO far_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma nau ku saea ru mamana fua mulu, ana fa dangi ne God kai ketoa na molagali, na kwaekwaee ne nia kai kwatea fuana wane nai ki kai baita liufia kwaekwaee ne God kai kwatea fuana wane ta'a be ki laona ro mae fere be 'i Sodom ma 'i Gomora ki.” ");
INSERT INTO far_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ma sa Jesus ka fata lau 'uri, “Mulu fafurongo lea, nau ku eresi kamulu kau 'uria 'afitaie, sulia kamulu leka na dia sipsip ki siana wane ta'a ki ne kera dia na kui kwasi ki ne kera doria falilamulu. Nia ne, mulu adaada lea, ma nao kamulu si sasia ta ru garo ne kera fafi kamulu ana. ");
INSERT INTO far_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mulu ada suli kamulu, sulia tani wane kera kai dau kamulu, ma kera ka talai kamulu siana wane kwaiketoi ki, ma kera namusi kamulu laona beu fuana folae kera ki. ");
INSERT INTO far_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Sulia ne mulu leka suli nau, kera kai tara kamulu siana wane fanaonao ma na kingi kera ki fuana ketolamulu. Ma ana kada kera sasi na 'urinai, mulu farongo ana na Farongoe Lea fuada ma fuana wane nao lau Jiu ki. ");
INSERT INTO far_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Kada kera ngali kamulu 'i naona wane ni kwaikefusi ki, nao mulu si manata 'abero 'uria ta te ne mulu kai saea ma mulu kai fata 'uta ana, sulia God na ne kai kwatea faoraie ki fua mulu fuana saelana ana kada nai. ");
INSERT INTO far_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Nao kamulu si fata taifili kamulu na. Na Anoeru God na Maa kamu mai langi ne kai fafata kamulu. ");
INSERT INTO far_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Wane 'oro ki, kera kai kwatea na wanefuta kera ki talada fuana saungilada. Ma na maa ki, kera kai sasi 'urinai laugo ana wele kera ki. Ma na wele ki, kera kai olisusu ma kera kai kwatea na maa fainia gaa kera ki fuana saungilada. ");
INSERT INTO far_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Na wane 'oro ki, kera noni'ela amulu sulia kamulu na fafurongo nau ki. Ma dia sa ti boroi 'ana ne ka famamana ngasi, leka ka dao ana na 'isilana kada ana 'afitaie, God kai famauri nia. ");
INSERT INTO far_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Dia wane ana te fere kera famalagaigai kamulu, mulu tafi, mulu leka fasia mae fere nai 'ali'ali, ma kamulu ka leka lalau 'amulu 'uria ta fere 'e'ete. Nau ku saea fua mulu na ru mamana, nau Wele Nia Wane, nau kai oli lau mai ana kada ne mulu nao si fasuia na raoe kamulu ana mae fere Israel ki. ");
INSERT INTO far_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Aia, na wane ne nia rongo ru ga 'ana, nia 'afitai ka baita liufia na wane ne famanata nia. Ma na wane ni rao nao si baita liufia na wane gwaungai nia. ");
INSERT INTO far_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nia ka lea fuana wane rongo ru kera kai usulia na wane famanata nia. Ma na ru ne kera sasia ana wane gwaungai, kera kai sasia laugo ana wane rao nia ki. Ma dia nau, na wane gwaungai kamulu, kera sae nau ana sa Saetan ne wane gwaungai ana anoeru ta'a ki, 'urinai ma kamulu boroi, kera kai sae kamulu ana sataeru ki ne ta'a 'asiana.” ");
INSERT INTO far_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Sa Jesus ka fata lau fuana fafurongo nia ki ka 'uri, “Nao mulu si mau ana na wane ki. Ru ki tafau ne wane ki kera safungainia, God kai fatainia. Ma na ru agwa ki tafau, God kai fata sulia. ");
INSERT INTO far_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma na ru ne nau ku saea fua mulu 'i laona rodo, mulu kai saea lau go ana dangi. Ma ru ne nau ku kwalaro ana fua mulu, mulu fata fola ana fua na wane ki tafau. ");
INSERT INTO far_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma nao mulu si maungia na wane ki ne kera saungia na noni mulu ka mae, boroi ma nia 'afitai fuana saungilana na mangomulu. Mulu maungia lalau God, sulia nia ne bobola fainia na fafunuilana na mangomulu ma na noni mulu laona kula ni kwaekwaee. ");
INSERT INTO far_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ma na no tu'u ki boroi ne, nia 'afitai fuana ta te no ada ka 'asia 'i ano dia na Maa kamulu 'i langi nao si alamatainia. ");
INSERT INTO far_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Aia, ma kamulu boroi, na ifu ana gwaumulu ki, God nia saitamana tafau go. ");
INSERT INTO far_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Nia ne nao mulu si mau, sulia God nia manata baita ana wane ki ka liufia na fa no tu'u 'oro ne ki! ");
INSERT INTO far_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Dia ta wane nia fulangainia 'i naofana wane ki ne nia na fafurongo nau, nau ku fulangainia 'urinai laugo fuana Maa nau 'i langi. ");
INSERT INTO far_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ma dia ta wane kai tofe nau 'i maana wane ki, nau kai tofea laugo fua Maa nau 'i langi.” ");
INSERT INTO far_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ma sa Jesus ka fata lau 'uri, “Nao mulu si fia lau sae nau ku leka mai fainia aroaroe fuana molagali. Nao nau si ngalia go mai aroaroe. Nau ku leka mai fua tolingilana wane ki. ");
INSERT INTO far_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Na malimae wane, nia ne ta wane go ana kwalafa nia. Sulia wele fi baita ki, kera kai fua fainia maa kera ki. Ma na keni sari ki, kera kai fua fainia gaa kera ki. Aia, na keni ne 'afe mai ki boroi, kera kai fua fainia fungo keni kera ki. ");
INSERT INTO far_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Ma sa ti boroi 'ana ne ka kwaimani ana na maa nia naoma na gaa nia ka liufi nau, nia nao si bobola ka leka buriku. Ma sa ti boroi 'ana ne ka kwaimani fuana wele nia ki ka liufi nau, nia nao si bobola ka leka buriku. ");
INSERT INTO far_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma nia 'afitai fuana ta wane ka dia ta fafurongo 'aku, sulia dia nia nao si nonimabe fuana lekalae buriku, sui boroi 'ana kada nia kai nonifi ma kai mae ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ma sa ti boroi 'ana ne noni'ela ni leka buriku sulia ni doria ka sasi 'ana sulia kwaidoria nia ki tala'ana, nia kai talafia na maurie firi. Boroi ma dia sa ti boroi 'ana ne nao nia si sasi sulia kwaidoria nia ki tala'ana, ma nia nonimabe kai mae sulia nia leka buriku, nia kai too ana maurie firi. ");
INSERT INTO far_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ma sa ti boroi 'ana ne nia kwalo kamulu, nia kwalo nau laugo. Ma sa ti boroi 'ana ne kwalo nau, nia kwaloa laugo God ne nia odu nau mai. ");
INSERT INTO far_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ma sa ti boroi 'ana ne kwaloa na profet, sulia ne wane nai nia rao fuana God, nia kai ngalia na kwaiarae dia laugo na kwaiarae ne God kwatea fuana profet. Ma sa ti boroi 'ana ne kwaloa na wane 'o'olo, sulia na wane nai nia 'o'olo, nia kai ngalia na kwaiarae dia na wane 'o'olo. ");
INSERT INTO far_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ma nau ku saea ru mamana fua mulu, dia ta wane ka kwatea ta titiui kafo gwari fuana ta te wane ana na fafurongo ne nau ki, sulia ne nia na fafurongo nau, nia kai ngalia laugo ta kwaiarae.” ");
INSERT INTO far_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Kada sa Jesus nia fata fuana akwala ma ro fafurongo nia ki ka sui, nia ka leka lau fuana 'ainitalolae ana Farongoe Lea fainia famanatalana wane ana mae fere ki kalikalia 'i Galili. ");
INSERT INTO far_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ana kada nai sa Jon wane ni Siuabu nia to 'i laona beu ni kanie, ma nia ka rongoa na raoe ne sa Jesus Christ nia sasia ki, ma nia ka kwatea tani wane ana fafurongo nia ki kera ka leka siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ma kera ledia, kera ka fata 'uri, “'Oe farongo kalu mai. 'Uri ma 'oe na ne na Christ ne sa Jon saea kai dao mai, naoma kalu ka makwalia lau amalu ta wane 'e'ete?” ");
INSERT INTO far_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ma sa Jesus ka olisida ka 'uri, “Mulu ka oli kau, ma mulu ka farongoa sa Jon ana na ru ne mulu rongoa ma mulu ka suana ki. ");
INSERT INTO far_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Na wane ne maada rodo ki, kera ka ada lau. Ma na wane ne 'aeda mae ki, kera ka fali lau. Ma na wane ne kuu saungida ki, na nonida ka mafo na. Ma na wane ne alingada 'e boko ki, kera ka rongo lau. Ma na wane ne kera mae ki, kera ka mauri lau. Ma na Farongoe Lea be, nau ku 'ainitaloa na 'ana fuana wane siofa ki. ");
INSERT INTO far_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","God kai falea na wane ki tafau ne nao kera si noni'ela 'ani nau, sulia na ru nau ku sasia ki.” ");
INSERT INTO far_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kada ne na fafurongo sa Jon ki kera oli na, sa Jesus ka fata sulia sa Jon fuana fikue nai, ka 'uri, “Ana kada kamulu leka siana sa Jon laona lofaa 'eke'eke, sa ti ne kamulu leka fuana adalae to'ona senai? Ta wane ne manata ruarua ka dia ga 'ana ta ngosa rade ne nia gelogelo ana kuburu? Nao! Sa Jon nia nao lau wane 'urinai. ");
INSERT INTO far_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","'Uri ma, te ne kamulu leka fuana adalae to'ona? Ta wane ne nia ofi ana maku ne folilana baita? Nao! Sulia wane ne kera ofi 'urinai ki, kera to 'i laona lume kingi ki. ");
INSERT INTO far_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kamulu farongo nau mai. Te ne kamulu leka kau fuana adalae to'ona? Ta profet? Iu! Nia ta profet mamana! Ma nia liufia na profet 'i nao ki tafau. ");
INSERT INTO far_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sa Jon na be kera kekede sulia laona Kekedee Abu ana kada God nia fata fuana Christ ka 'uri, ‘Ada basi, nau kai kwatea kau na wane ni ngali fatae nau 'i nao amu, fua nia kai sasi akau ana wane ki fuamu.’ ");
INSERT INTO far_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nau ku saea ru mamana fua mulu, sa Jon nia talingai ka liufia na wane ki tafau ne kera futa mai 'i laona molagali ne. Sui ka 'urinai boroi ana, na wane ne kera tu'u ki laona 'Initoe God, kera talingai ka liufia sa Jon. ");
INSERT INTO far_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Aia, safali mai ana kada sa Jon nia etangia fulangailana na Farongoe Lea leka ka dao ta'ena, na wane ta'a ki kera ka firu sualia ma falia na famanatalae sulia na 'Initoe God. ");
INSERT INTO far_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Na taki sa Moses ki, ma na profet ki tafau leka ka dao ana kada sa Jon, kera fata 'ainitaloa mai sulia daolana mai na Christ. ");
INSERT INTO far_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kera saea sa Elaeja na profet kai oli lau mai 'i naona na Christ. Ma nia lea fua mulu ka famamana ne sa Jon na ne sa Elaeja be. ");
INSERT INTO far_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Dia ta wane doria ka saitamana lea ana ru ne, nia ka fafurongo lea.” ");
INSERT INTO far_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ma sa Jesus ka fata lau 'uri fuada, “Kamulu wane kada nai, kamulu dia te? Kamulu dia na kaela wele ne kera oku 'i maana usie ana ro okue ki. Ma te bali ada ka akwa kau fua tani wele ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Kalu ufi 'au, ma mulu si ngwae go sulia. Ma kalu ka ngufia na fa ngu sulia maee fua mulu, ma mulu si kwaimanatai go.’ ");
INSERT INTO far_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kada sa Jon wane ni Siuabu dao mai, nia abu fanga, ma nao si kufia ta waeni, ma kera ka saea sae nia too ana anoeru ta'a. ");
INSERT INTO far_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sui, kada nau, na Wele nia Wane, nau ku dao mai, nau ku fanga oku, ma nau ku ku fainia wane ki, ma mulu ka fata laugo 'uri, ‘Mulu ada to'ona! Nia fanga baita, ma ka ku baita ana waeni, ma nia ka kwaimani ana wane ne kera koni malefo ana takisi ki ma wane abulolada ta'a ki laugo.’ Boroi ma, wane ne kera rosulia na liotoe God ki, kera fatainia ne God nia mamana.” ");
INSERT INTO far_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Burina sa Jesus fata 'urinai ka sui, nia ka safali ka ngatafia na mae fere be nia sasia mai na fanadae 'oro ki ana, sulia wane ana mae fere nai ki kera ulafusia kari abulo fasia ta'alae kera ki. ");
INSERT INTO far_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sa Jesus nia fata lau 'uri, “Nia ta'a 'asiana na fua mulu ne mulu to 'i Koresin. Ma kamulu ne mulu to 'i Betsaeda ka 'urinai laugo. Sulia mulu si famamana na fanadae 'oro be nau ku sasia fua mulu ki. Dia kera sasia fanadae nai ki 'i Taea ma 'i Saedon 'i nao, na wane senai ki kera ka gouru 'i ano, ma kera ka rufia maku bilia ki, ma kera ka farafua nonida ana fue, fua ne ka fatainia ne kera kari abulolae tafau na fasia abulo ta'alae kera ki. ");
INSERT INTO far_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ru mamana ne nau ku saea fua mulu, ana fa dangi God kai ketoa wane ana molagali ne, na kwaekwaee kamulu kai baita ka liufia kwaekwaee wane 'i Taea fainia Saedon ki. ");
INSERT INTO far_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Aia, kamulu na tooa 'i Kapaneam, mulu kwaesae God kai lafu kamulu 'uria 'i langi. Boroi ma, nia kai 'ui lalau ana kamulu 'i laona kula ni kwaekwaee. Sulia na fanadae be nau ku sasida 'i mae fere kamulu ki, dia nau ku sasi mai 'urinai 'i Sodom, 'urinai wane 'i Sodom ki kera ka kari abulo na, ma God nao si fafunuia fere kera ki. ");
INSERT INTO far_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nia ne, nau ku saea fua mulu, ana fa dangi ne God kai ketoa na wane ana molagali, na kwaekwaee kamulu kai baita ka liufia na wane 'i Sodom ki.” ");
INSERT INTO far_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ana kada nai, sa Jesus ka foa ka fata 'uri, “Maasi, 'oe ne 'oe gwaungai ana ru ki tafau 'i langi ma 'i ano laugo. Nau ku tango 'oe, sulia ne 'oe fatainia gwaungaie 'oe fuana wane ne kera dia wele tu'u ki, ma 'oe safungainia ru ne ki fasia wane ne fabaitada sulia kera saitamarue, ma kera ada saitamana ru 'oro ki. ");
INSERT INTO far_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iu Maasi, nia 'urinai na sulia na kwaidoria 'oe 'ua na mai 'i nao.” ");
INSERT INTO far_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ma sa Jesus ka fata 'uri fuana fikue nai, “Maa nau nia kwatea ru ki tafau na fuaku. Ma taifilia na Maa go ne nia saitamana na Wele nia. Ma taifilia laugo na Wele tala'ana ne nia saitamana Maa nia, ma taifili go wane ne na Wele nia filida fuana fatailana fuada ki, ne kera saitamana na Maa. ");
INSERT INTO far_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Na fatae talingai ne na wane famanata ana taki sa Moses ki kera alua fua mulu ki, nia kwate ma mulu ka laeororo na farada. Mulu leka mai siaku, ma nau kai lafutainia fasi kamulu. ");
INSERT INTO far_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ma mulu ro aku, ma nau kai famanata kamulu, sulia na falafala nau ki marabibi ma ka aroaro, ma mulu kai dao to'ona na mamalolae fuana mangomulu. ");
INSERT INTO far_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na kwaitalailae nau fua mulu, nia ngwaluda fua lekalae sulia.” ");
INSERT INTO far_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ma ana kada nai, ana te Sabat, sa Jesus fainia na fafurongo nia ki, kera liu folo ana te oole witi. Ma ana kada nai, na fafurongo nia ki kera fiolo, ma kera ngeda fueru ki, ma kera ka 'ania. ");
INSERT INTO far_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ma tani wane ana Farasi ki kera ada to'oda. Ma kera ka ngatafia sa Jesus kera ka 'uri, “'Oe ada to'ona! Na ru ne fafurongo 'oe ki kera sasia, nia 'oia na taki sa Moses ki, sulia kera ngeda witi ne ana Sabat!” ");
INSERT INTO far_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ma sa Jesus ka olisida ka 'uri, “Nau ku saitamana kamulu idumia laona Buko Abu ru be sa Deved na kingi nia sasia 'i nao. Ana kada nai, sa Deved fainia wane nia ki kera fiolo 'asiana, ");
INSERT INTO far_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","nia ka leka 'i laona 'O'obe Abu God, ma na 'inita fataabu ka kwatea fuana sa Deved na beret ne kera 'auabua fuana God. Ma sa Deved ka 'ania na beret nai, ma ka kwatea laugo fuana wane nia ki, ma kera ka 'ania. Boroi ma na taki kulu alamatainia fua taifilia go na fataabu God ki ne kera saitamana 'anilana. Ma nao kulu si ada to'ona laona Buko Abu ne God nia guisasu fuana sa Deved.” ");
INSERT INTO far_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ma sa Jesus ka fata lau 'uri, “Nau ku saitamana kamulu idumia laona Buko Abu, na taki ki sulia fataabu ki be kera rao laona Beu Abu God ana Sabat. Kera rao ga 'ada boroi ma God nao si keto kera go. ");
INSERT INTO far_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Aia, nau ku saea fua mulu, na wane ne nia na seki 'e baita liufia na Beu Abu God. ");
INSERT INTO far_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iu, God nia fata 'uri, ‘Nau ku dori kamulu kai kwaimanatai fuana wane ki, ma nao lau na afafue kamulu ki.’ Ma dia kamulu saitamana fadalana na ru ne, nia 'afitai fua mulu ka ketoa na wane nau ki, sulia kera nao si garo go. ");
INSERT INTO far_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Sulia ne nau, na Wele nia Wane, nau too ana na nikilalae fuana saelana ru ne wane ki kera saitamana ka sasia ga 'ada ana Sabat.” ");
INSERT INTO far_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ma kada sa Jesus nia leka fasia na kula nai, nia ka leka laona beu fuana folae kera. ");
INSERT INTO far_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ma te wane ne 'abana mae to laugo laona beu fua folae nai. Ma tani wane kera ledia sa Jesus 'uri, “'Uri ma nia bobola ga 'ana fuana guralana wane matai ki ana Sabat?” Kera ledia 'urinai fua sae kera ka dao to'ona ta ru fua kera ka fata maana sa Jesus ana 'oilana taki God. ");
INSERT INTO far_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ana kada nai, sa Jesus ka ledi kera lau ka 'uri, “Mulu farongo nau basi, dia ta wane amulu, na sipsip nia 'e 'asia laona ta kilu ana Sabat, 'uri ma nia nao si leka lafua lau fasia na kilu ana fa dangi nai? ");
INSERT INTO far_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Mulu saitamana, God ada to'ona wane ne 'e talingai ka liufia na sipsip. Aia, sulia wane ne nia talingai 'urinai, nao nia si garo go fua sasilana ta ru lea, ma 'afilana ta wane ana Sabat.” ");
INSERT INTO far_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ana kada nai go, sa Jesus ka fata 'uri fuana wane nai 'abana mae, “'Oe taga mai 'abamu.” Ma wane nai ka taga na 'abana. Ma ana kada nai go, na 'abana be mae ka lea laugo 'ana dia ruana bali 'aba. ");
INSERT INTO far_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ma ana kada na Farasi ki kera ada to'ona na ru nai, kera ka ru tafau 'i maa. Ma kera ka oku fua lokoerue fua saungilana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kada sa Jesus nia rongoa ne kera oku fua lokoerue fua saungilana, nia ka leka na fasia fere nai. Ma na wane 'oro ki, kera leka sulia sa Jesus, ma nia ka gura wane ne kera matai ki tafau. ");
INSERT INTO far_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ma sa Jesus ka fata luida kera nao si fata suli nia siana ta wane lau. ");
INSERT INTO far_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nia sasi 'urinai fua sae ka famamana na fatalana God be profet Aesaea nia saea ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Na wane rao nau ne, nau ku filia fua ka sasia raoe nau. Nau ku kwaimani 'asiana ana, ma ku eele 'asiana sulia. Nau kai kwatea kau na Anoeru nau fua ka to fainia. Aia, na wane ne nia kwatea laugo kwaiketoilae 'o'olo fuada wane ne nao lau Jiu ki. ");
INSERT INTO far_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nao nia si to ana olisusue, ma nao si akwa baita, ma nao nia si fata falea nia maana fere ki. ");
INSERT INTO far_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nao nia si luka faburi ana na wane siofa ma wane ngwatautau ki. Ma nia kai kwatea kwaiketoilae 'o'olo fuana wane ki. ");
INSERT INTO far_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Na wane ne, wane 'oro laona molagali ki tafau, kai manata ngado ana.” ");
INSERT INTO far_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sui burina, tani wane kera ngalia mai te wane siana sa Jesus fuana guralana. Wane ne, anoeru ta'a nia rufia, ma na maana ka rodo, ma na ngiduna ka ato. Ma sa Jesus ka gura na wane nai, ma nia ka ada ma ka fata lau. ");
INSERT INTO far_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Na fikue nai ka kwele, ma kera ka ledi kera kwailiu 'uri, “'Uri ma na wane be God nia filia, ma ka futa ana kwalafa sa Deved na kingi 'oto ne?” ");
INSERT INTO far_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ma kada tani Farasi kera rongoa na ru nai ki, kera ka fata 'uri, “Nao lau nia ne. Sa Jesus nia ifulangainia na anoeru ta'a ki ana nikilalae sa Saetan na 'inita anoeru ta'a.” ");
INSERT INTO far_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ma sulia ne sa Jesus nia saitamana go ana manatalada, nia ka fata 'uri fuada, “Dia tooa laona ta fere baita kera firu fai kera talada, 'urinai fere baita nai kai takalo. Ma dia ta fere, naoma na wane ma na 'afe ma na wele nia ki, kera firu fai kera talada, nia 'afitai fuana kera ka to oku. ");
INSERT INTO far_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ma na 'initoe sa Saetan ne 'urinai laugo. Dia sa Saetan kai firu fainia tooa ne kera leka sulia, 'urinai kera kai takalo kwailiu go. ");
INSERT INTO far_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Iu, ma mulu saea nau ku ifulangainia anoeru ta'a ki ana nikilalae sa Saetan. 'Urinai ma nikilalae sa ti mone ne tani fafurongo amulu kera ifulangai anoeru ta'a ki ana? Sa Saetan? Nao 'asiana! Ru nai ki, fatainia ne kamulu garo. ");
INSERT INTO far_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","“Nau ku ifulangainia anoeru ta'a ki ana nikilalae God. Ma nia ka fatainia na fua mulu ne 'Initoe God fafia wane ki dao karangi na mai siamulu. ");
INSERT INTO far_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Aia, dia ta wane doria ka ifulangainia ta anoeru ta'a, wane nai ka nikila ka liufia sa Saetan. Ka dia laugo wane ne doria kai ru laona lume na wane nikila fuana ngalilana ru nia ki. Nia ka nikila ka liufia wane nai, fua ka ngwaluda fua kanilana wane nikila nai, sui nia ka fi ngalia ru nia ki. ");
INSERT INTO far_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Aia, sa ti ne nao nia si leka mai buriku, nia na malimae nau. Ma sa ti ne nao si kwai'adomi aku fua konilana mai wane ki siana God, nia ka takalongai kera na fasia God. ");
INSERT INTO far_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Sulia nia 'urinai, nau ku saea fua mulu, God saitamana kai manatalugea ru ta'a ki tafau ne wane nia sasia ma na ru ta'a ne nia saea. Ma dia ta wane ka fata ta'a aku na Wele nia Wane, God saitamana ka manatalugea go ana. Boroi ma dia ta wane ka fata falia na raoe Anoeru Abu, God nao si manatalugea wane nai, sui boroi 'ana kada ne, naoma ta kada ne nia mai 'ua.” ");
INSERT INTO far_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sa Jesus ka fata lau 'uri, “Kamulu saitamana dia mulu too ana 'ai lea, na fueru boroi ka lea laugo. Ma dia kamulu too ana 'ai ta'a, na fueru boroi ka ta'a laugo. Dia laugo wane, sulia ru lea ki leka mai fasia na wane lea, ma ru ta'a ki leka mai fasia na wane ta'a. ");
INSERT INTO far_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ma kamulu dia go amulu kaelana fa baeko tolo ki! Ma 'afitai 'asiana mulu ka saea ta ru ka lea, sulia na manatalae kamulu ki nia ta'a. Te ne nia to laona manatana wane, nia 'e ru mai 'i maa ana fatalana. ");
INSERT INTO far_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Na wane ne lea, na fatalana boroi ka lea laugo. Ma na wane ne ta'a, na fatalana boroi ka ta'a laugo. ");
INSERT INTO far_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Nau ku saea fua mulu, kada ana kwaekwaee, God kai ketoa wane ki tafau laona molagali fua faoraie ta'a ne kera saea ki. ");
INSERT INTO far_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma God kai ketoa wane ana fatalada talada. Dia faoraie ta wane 'e lea, God kai fulangainia wane ne ni 'o'olo. Ma dia faoraie ta wane ka ta'a, God kai fulangainia na wane ne ni garo.” ");
INSERT INTO far_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Sui tani wane famanata ana taki ki ma tani Farasi, kera leka mai siana sa Jesus, kera ka fata 'uri fuana, “Wane Famanata 'ae, kalu doria 'asiana 'oko sasia ta fanadae, fua ka fatainia God ne odu 'oe mai.” ");
INSERT INTO far_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sa Jesus ka fata 'uri fuada, “Kamulu wane ta'ena, kamulu wane ta'a ki, ma nao mulu si famamana go God. Sulia mulu doria adalae to'ona fanadae ne kai fatainia nikilalae God, boroi ma nia 'afitai fua mulu fua adalae to'ona. Mulu kai ada to'ona fanadae dia na ru be nia fuli fuana sa Jona na profet be 'i nao. ");
INSERT INTO far_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Sa Jona be to laona guina gwasasu sulia olu fa dangi ma olu fa rodo ki. Aia, nau, na Wele nia Wane, kai 'urinai laugo. Nau kai to laona ano sulia olu fa dangi ma olu fa rodo ki. ");
INSERT INTO far_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma ana kada God kai ketoa wane ki, wane ne kera to 'i Ninifa, kera kai tatae fua kera ka fata sulia na garoe kamulu ki. Kera sasi 'urinai, sulia kera kari abulo na fasia na ta'alae kera ki, ana kada sa Jona 'ainitaloa fuada. Ma te wane nia talingai ka liufia sa Jona nia to na fai kamulu. Sui boroi ana, nao mulu si kari abulo go fasia ta'alae kamulu ki. ");
INSERT INTO far_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ma ana kada God kai ketoa na wane ki, na gwaungai keni 'i Siba, nia kai tatae laugo fua faorailae sulia na garoe kamulu. Na keni ne nia sasi 'urinai, sulia nia leka mai fasia fere nia ne 'e tau fua rongolana liotoe sa Solomon na kingi. Ma te wane talingai ka liufia sa Solomon nia to ga 'ana fai kamulu. Sui boroi 'ana, nao mulu si doria go rongolana.” ");
INSERT INTO far_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Sa Jesus ka fata 'uri lau, “Kada kera ifulangainia anoeru ta'a nia leka fasia ta wane, nia ka kali kwailiu laona lofaa 'eke'eke, nia ka nani 'uria ta kula fua nia kai to ana. Ma dia nia nani ma ka nao na, ");
INSERT INTO far_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nia kai manata 'uri, ‘Nau oli 'uria na wane be nau to mai ana 'i nao, ma nau ku leka mai fasia.’ Ana kada nia oli mai ka dao, nia ka ada to'ona wane be nia kwaitaboi ma ka fa'o'olosia na maurilana tafau. ");
INSERT INTO far_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Kada nia ada to'ona ne nia 'urinai, nia oli ma ka talaia lau mai ta fiu anoeru ne ta'a ka liufi nia, kera leka mai, ka to na laona wane be. Ana kada nai, na tolana wane nai fi ta'a ka liufia na 'i nao. Ma nia kai 'urinai laugo fua mulu wane ana ta'ena, mulu wane ta'a ki, ma tolamulu fi ta'a ka liufia na 'i nao.” ");
INSERT INTO far_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ana kada sa Jesus nia faorai 'ua fuana wane ki, gaa nia fainia sasina ki kera dao mai. Ma kera ka uu ga 'ada 'i maa, kera ka fata mai 'uria fua kera ka faorai fainia. ");
INSERT INTO far_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ma te wane ana wane nai ki ka fata 'uri fua sa Jesus, “Gaa 'oe fainia sasimu ki, kera uu go mai 'ada 'i maa, kera dori kai faorai fai 'oe.” ");
INSERT INTO far_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sa Jesus ledi kera ka 'uri, “Sa tifaida ne gaa nau ma sasiku ki?” ");
INSERT INTO far_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ana kada nai, sa Jesus ka fatainia na fafurongo nia ki, ma ka fata 'uri, “Mulu ada to'ona basi. Kera na ne gaa nau ki ma sasiku ki. ");
INSERT INTO far_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Sulia sa ti ne sasi sulia na kwaidoria Maa nau 'i langi, nia ne wanefuta nau, ma na waiwane nau, ma na gaa nau.” ");
INSERT INTO far_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ana maedangi nai laugo, sa Jesus ru kau fasia lume nai, ma ka leka 'i ninimana na 'osi, ma ka gouru 'i ano fuana famanatalae. ");
INSERT INTO far_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ma sulia na fikue baita kera oku kalia, nia ka ra laona te baru, ma ka gouru laona, ma na wane ki kera ka uu kau 'ae one. ");
INSERT INTO far_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Sui nia ka farongo kera ana ru 'oro ki ana fatae tarifulae ki, ka 'uri, “Te wane nia leka ka takalongainia mege witi ki laona oole nia. ");
INSERT INTO far_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma kada nia takalongainia mege witi nai ki, tani mege witi kera 'asia sulia na kakaloe, ma no ki kera lofo mai, ma kera ka 'anida tafau. ");
INSERT INTO far_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ma tani mege witi kera 'asida ana kula faula ki, kula ne ano si baita. Ma kera bulao 'ali'ali sulia ne ano nao si 'oro. ");
INSERT INTO far_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ma kada ne sato nia tae mai, nia ka satofia na witi ne masubu ki, ma kera ka kuku laugo, sulia lali ru ki nao si koso lola. ");
INSERT INTO far_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ma tani mege witi kera 'asida 'i safitana na 'oko ngangara, ma nia ka karo fafia witi ki. ");
INSERT INTO far_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ma tani mege witi lau kera 'asida 'i laona ano lea, ma kada kera tae mai, kera ka fungu ana fueru 'oro ki. Ma tani witi kera ka fungu ana te talanga fueru, ma tani witi kera fungu ana ono akwala fueru, ma tani witi lau kera fungu ana olu akwala fueru ki.” ");
INSERT INTO far_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ma sa Jesus ka fasuia fatalana ka 'uri, “Dia ta wane doria ka saitamana lea ana ru ne ki, nia ka fafurongo lea.” ");
INSERT INTO far_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Na fafurongo nia ki leka mai siana, ma kera ka ledi 'uri ana, “'Uta ne 'oe fata fuana wane ki ana fatae ana tarifulae ki?” ");
INSERT INTO far_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sa Jesus ka olisida ka 'uri, “Kada sui ki, God nao si famadakwa 'uta ne nia kai gwaungai ana wane nia ki. Boroi ma ta'ena, na madakwalae nia dao na fua mulu. Ma na wane ne nao lau fafurongo nau ki, nao nau si famadakwa fuada. ");
INSERT INTO far_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Sa ti boroi 'ana ne to ana ta madakwalae tu'u sulia 'initoe God, God kai lado gwauna, fua nia ka to ana madakwalae 'oro ka kali'afu. Boroi ma sa ti ne nao si rosulia famanatalae ne ki, ta madakwalae tu'u ne nia to ana sulia 'Initoe God, God kai olitainia fasia. ");
INSERT INTO far_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Aia, nau ku fata fuada ana tarifulae ki, sulia wane ne ada to'ona ru nau ku sasida ki, boroi ma kera nao si ada saitamana. Kera rongoa fatalaku, boroi ma kera nao si malingainia. ");
INSERT INTO far_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nia 'uri fua ka famamana fatalana sa God be sa Aesaea na profet nia kedea ka 'uri, ‘Kera kai fafurongo ma kera kai fafurongo, boroi ma kera nao si saitamana farongoe nau. Ma kera kai ada ma kera kai ada, boroi ma kera nao si ada to'ona te ne nau sasia fuada. ");
INSERT INTO far_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Sulia ne manatada ka ngasi, ma kera kai bokota na alingada, ma kera kai bokota laugo na maada. Fasia maada ka ada to'ona, ma alingada ka rongoa, ma na manatada ka malingainia fatalaku, ma kera abulo mai 'uri nau ma nau ku gurada.’” ");
INSERT INTO far_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ma sa Jesus ka fata lau 'uri, “'Oilakie fua mulu, sulia ne maamulu ada to'ona na raoe nau ku sasia ki, ma na alingamulu ka rongoa famanatalae nau ki. ");
INSERT INTO far_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ru mamana nau ku saea fua mulu, na profet 'oro ki, ma na wane 'o'olo ki 'i nao, kera doria adalae to'ona ru ne mulu ada to'ona ki, boroi ma kera nao si ada to'ona. Ma kera doria na rongolana ru ne mulu rongoa ki, boroi ma kera nao si rongoa. ");
INSERT INTO far_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Mulu fafurongo na 'uria fadalana tarifulae ne sulia na wane ne takalongainia mege witi. ");
INSERT INTO far_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tani wane ne rongoa na farongoe sulia 'Initoe God, ma kera nao si malingainia, 'urinai sa Saetan ka leka mai, ma ka laua fatalana God fasida ne kera rongoa. Kera dia mege witi ne 'asida sulia na kakaloe, ma no ki ka 'anida. ");
INSERT INTO far_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma na mege witi ne kera 'asia 'i fafona ano ne faula, kera dia wane ne kera rongoa fatalana God, ma kera ka ngalia, ma kera ka eele 'asiana. ");
INSERT INTO far_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Boroi ma fatalana God nao si lalisusu go laona maurilada. Nia ne fitoe kera ki ka mauri go sulia ka kada tu'u. Ana kada ne kera dao to'ona 'afitaie, ma na nonifilae ki sulia farongoe lea ne, kera ka fasia go na fatalana God. ");
INSERT INTO far_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma tani wane kera dia mege witi ne 'asida safitana 'oko ngangara ki. Kera rongoa fatalana God, boroi ma kera manata 'abero 'ada sulia ru ki ana maurie kera, ma kera ka manata baita ana malefo. Ma ru nai ki, nia dia 'oko ngangara ki ne karo fafia fatalana God laona maurilada. Kera nao si tatala go laona maurilada dia na witi ne nao si fungu go ana ta fueru. ");
INSERT INTO far_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma tani wane lau kera dia mege witi ne kera 'asida laona ta ano lea. Kera rongoa fatalana God, ma kera ka malingainia, ma kera fatainia tolae 'o'olo ka dia witi ne nia fungu ana fueru ki. Tani witi te talanga fueru, ma tani witi ono akwala fueru, ma tani witi olu akwala fueru.” ");
INSERT INTO far_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sa Jesus ka saea lau te tarifulae fuada, ka 'uri, “Na 'Initoe God nia dia na wane ne fasia na mege ru lea ki laona oole nia. ");
INSERT INTO far_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma ana te rodo, kada ne wane ki kera maleu, na malimae nia 'e leka mai ma ka takalongainia tani mege laue ta'a safitana mege witi ki. Sui nia ka leka na 'ana. ");
INSERT INTO far_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ma kada ne mege ru lea kera bulao mai, ma ka safali fungu, na mege laue ta'a be ki kera bulao laugo. ");
INSERT INTO far_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Na wane ni rao nia ki, kera leka mai siana, kera ka ledia 'uri, ‘Wane baita 'ae, 'oe fasia na mege ru lea ki be. Ma laue loko ki kera leka mai fasia 'i fai?’ ");
INSERT INTO far_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ma nia ka olisida ka 'uri, ‘Na malimae nau nena sasia ru nai.’ Ma wane ni rao nia ki, kera ledia 'uri, ‘'Oe doria kalu leka failia laue ta'a loko ki?’ ");
INSERT INTO far_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nia ka olisida ka 'uri, ‘Nao, fasia kada mulu failia na laue loko ki, mulu ka falia laugo tani witi. ");
INSERT INTO far_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mulu alu kera tae oku na 'ada leka ka dao ana kada ni konirue. Ma kada nai na, nau kai saea fuana wane ne kera konia ru nau ki, ku 'uri: Mulu lafua laue ki 'i nao, ma mulu kani fikuda, ma mulu ka sungida. Sui mulu fi lafua ru lea ki, ma mulu ngalia mai 'uria laona 'o'obe ni taingaie nau.’” ");
INSERT INTO far_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sui sa Jesus ka saea lau te tarifulae ka 'uri, “Na 'Initoe God nia 'uri: Te wane nia ngalia te mege 'ai tu'u ne kera saea ana mastad, ma ka fasia laona oole nia. ");
INSERT INTO far_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ma sui boroi 'ana na mege ru nai ka tu'u ana mege ru ki tafau, kada nia tae mai, nia alua na 'ai ne baita ka liufia na 'ai ki tafau laona oole nai. Ma kada na 'ai nai 'e baita ma ka ululua, ma na no ki kera saungainia nui kera ana sarana 'ai nai.” ");
INSERT INTO far_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sui sa Jesus ka fata lau ana ta tarifulae ka 'uri, “Na 'Initoe God 'e dia na isi tu'u fuana faubulana na beret, ne ta keni nia ngalia, ma ka dolalia fainia fulaoa 'oro, leka na kumu nai ka bose, ma ka fane.” ");
INSERT INTO far_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Sa Jesus 'idufa fata sulia na ru ne ki tafau ana na tarifulae ki fuana fikue nai. ");
INSERT INTO far_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Nia sasi 'urinai fua sae ka famamana na fatae God ne profet nia kedea ka 'uri, “Nau kai fata ana tarifulae ki fuana wane ki. Ma nau kai fadaa na ru ne agwa ki safali na mai ana kada nau ku saungainia na molagali.” ");
INSERT INTO far_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sui sa Jesus ka fasia na fikue nai ma ka ru laona lume. Ma na fafurongo nia ki ka dao mai siana, ma kera ka fata 'uri, “'Oe fadaa basi fua malu na tarifulae be sulia na laue nai ki laona oole.” ");
INSERT INTO far_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Nia ka olisida ka 'uri, “Na wane ne nia fasia na mege ru lea ki, na ne nau, na Wele nia Wane. ");
INSERT INTO far_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma na oole na ne molagali, ma na mege ru lea ki na ne na wane God ki farana 'Initoe nia. Ma na laue nai ki ne na wane rosulia sa Saetan ki. ");
INSERT INTO far_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma na malimae ne nia fasia na laue ki, na ne sa Saetan. Ma kada ana konirue na ne suilana na molagali, ma na wane ne kera konirue na ne na 'ainsel ki. ");
INSERT INTO far_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kada ne wane rao ki kera konia laue ki, ma kera ka sungida laona ere, nia ka dia laugo ana suilana molagali. ");
INSERT INTO far_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nau, na Wele nia Wane, kai kwatea 'ainsel nau ki, kera ka konia wane ne kera sasia ru ta'a ki, ma na wane ne kera fagaroa wane ki, ma na 'ainsel ki ka lafuda fasia 'Initoe nau. ");
INSERT INTO far_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma kera ka 'ui 'ani kera laona ere, kula ne kera kai angi, ma kera ka 'ala girigiri ana lifoda. ");
INSERT INTO far_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Aia, na wane 'o'olo ki, kera kai tala dia na sato laona 'initoe Maa kera. Dia ta wane doria ka saitamana lea ana ru ne ki, nia ka fafurongo lea.” ");
INSERT INTO far_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Sa Jesus ka fata laugo 'uri fuana fafurongo nia ki, “Na 'Initoe God nia dia na malefo baita ne kera saufinia laona oole. Ma kada ta wane nia ada to'ona, nia ka safungainia laugo 'ana. Ma nia ka eele, ma nia leka ka 'oifoli ana ru nia ki tafau, ma ka folia na oole nai, fua sae nia ka ngali 'ana malefo baita nai. ");
INSERT INTO far_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ma na 'Initoe God nia dia laugo na wane 'oifoli ne nia nani 'uria na fau ngwairoiro lea ki ne folilana baita 'asiana. ");
INSERT INTO far_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kada nia dao to'ona ka mae fau tu'u ne ngwairoiro, ma liulana 'e baita 'asiana, nia ka leka, ka 'oifoli ana ru nia ki tafau, ma nia fi folia. ");
INSERT INTO far_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Na 'Initoe God nia dia laugo na furai ne kera dee ana laona asi, ma kera ka deea ana ie 'e'ete ki tafau. ");
INSERT INTO far_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ma kada nia fungu, na wane ne kera dee ki kera tara 'i sara, ma kera ka gouru 'i ano. Sui kera ka konia na ie lea ki laona kukudu ki, ma kera ka 'ui 'ania na ie ta'a ki. ");
INSERT INTO far_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nia dia laugo suilana molagali. Na 'ainsel ki kera kai leka mai, ma kera ka efoa na wane ta'a ki fasia na wane lea ki. ");
INSERT INTO far_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ma na wane ta'a ki, kera ka 'ui 'anida laona ere, ma senai kera ka angi, ma kera ka 'ala girigiri ana lifoda.” ");
INSERT INTO far_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sui sa Jesus ka ledida ka fata 'uri, “Kamulu saitamana ru nai ki?” Ma kera olisia kera ka 'uri, “Iu.” ");
INSERT INTO far_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ma sa Jesus ka fata 'uri fuada, “Kamulu na wane ne nau ku famanata kamulu na. 'Urinai mulu ka famanata ana fatae sulia 'Initoe God. Mulu saitamana lea ana na taki sa Moses laona Alangaie 'Ua ma na fatae falu ne nau ki.” ");
INSERT INTO far_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kada sa Jesus nia fata ana tarifulae nai ki ka sui, nia ka leka na fasia mae fere nai. ");
INSERT INTO far_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ma nia ka oli lau mai ana mae fere nia 'i Nasaret. Ma nia ka leka laona beu fuana folae fua famanatalana wane ki. Ma kada wane ki kera rongoa, kera ka kwele 'asiana, ma kera ka fata 'uri, “Na nikilalae sa ti ne kwate nia ka famanata ana fatalana God 'uri, ma fainia sasilana fanadae ki? ");
INSERT INTO far_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kulu saitamana go akulu ne nia wele sa Josef ga 'ana ne, na wane saitamana saungailana ru ki ana 'ai, ma gaa nia ne ni Mary. Na wanefuta nia ki ne sa Jemes, sa Josef, sa Simon, ma sa Jiudas. ");
INSERT INTO far_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ma na waiwane nia ki, kera to ga 'ada fai kulu 'i seki. 'Uta ne nia ka saitamarue 'asiana 'uri?” ");
INSERT INTO far_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ma ana kada nai, kera ka noni'ela ana sa Jesus. Sui sa Jesus ka fata 'uri fuada, “Na profet nia 'afitai fuana wanefuta nia ki, ma na wane ana mae fere nia ki, ka fabaita.” ");
INSERT INTO far_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ma sa Jesus nao si sasia fanadae 'oro ki ana mae fere nia, sulia wane nai ki, kera noni'ela si famamana. ");
INSERT INTO far_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ana kada nai, sa Herod Antipas na kingi 'i Galili, nia rongoa farongoe sulia sa Jesus, ");
INSERT INTO far_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ma nia ka fata 'uri fuana wane ne kera rao fainia ki, “Wane ne, nia sa Jon wane ni Siuabu nia mauri lau! Nia ne ka sasia lau fanadae ki.” ");
INSERT INTO far_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ana kada sa Jon nia mauri 'ua, sa Herod nia adea ni Herodias na 'afe saoana nia sa Filip. Ma sa Jon ka ngatafia sa Herod ka 'uri, “Na taki God nia luia 'oe nao si adea 'afe saoamu.” Nia ne sa Herod ka kwatea tani wane fua kera ka daua sa Jon, ma kera ka kania, ma ka alu nia laona beu ni kanie. Sa Herod sasia ru ne sulia na 'afe nia ni Herodias ne doria. ");
INSERT INTO far_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ana kada sa Jon to laona beu ni kanie, sa Herod 'e doria 'asiana saungilana, boroi ma nia mau ana wane ki, sulia kera saea sa Jon nia ta wane ana profet ki. ");
INSERT INTO far_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Sui ana te maedangi, sa Herod 'e saungainia te fafanga baita fuana manatalae to'ona fa dangi nia futa ana. Ana fafanga nai, na sari ni Herodias nia leka mai ka ngwae fuana sa Herod fainia wane kwaimani nia ki fua kera ka ada ana. Kada sa Herod ada to'ona sari ne nia ngwae, nia 'e eele 'asiana fainia. ");
INSERT INTO far_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ma nia ka fata alangai fuana sari nai ka 'uri, “Ta te ne 'oe gania aku, nau ku kwatea fuamu.” ");
INSERT INTO far_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Aia, gaa na sari ne nia fata 'uri fuana sari nia, “'Oe gani, 'oko fata 'uri, ‘Nau ku doria 'oe kwatea mai na gwauna sa Jon wane ni Siuabu fuaku ana kada ne na. 'Oe alua mai fafona tae ru.’” Ma sari ne ka sasi na 'urinai. ");
INSERT INTO far_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ma kada sa Herod nia rongoa ru ne, nia ka kwaimanatai 'asiana. Sui boroi 'ana, nia 'e sasia na 'ana, sulia nia eta fata alangai na, ma na wane ki ne kera fanga fainia kera rongoa tafau na. ");
INSERT INTO far_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ma nia ka kwatea wane rao nia ki ka leka siki musia luana sa Jon wane ni Siuabu laona beu ni kanie. ");
INSERT INTO far_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ma kera ngalia mai gwauna sa Jon fafona tae ru, kera ka kwatea fuana sari ni Herodias. Ma nia ngalia ka kwatea fuana gaa nia. ");
INSERT INTO far_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Kada na fafurongo sa Jon ki kera rongoa na ru nai, kera leka mai, ma kera ka ngalia nonina, ma kera ka faitolia na. Sui, kera leka ka farongoa sa Jesus ana. ");
INSERT INTO far_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ana kada sa Jesus nia rongoa ru nai fuli fua sa Jon, nia ka fasia kula nai, ma ka leka taifilia laona baru 'uria kula ne nao ta wane si to ana. Na wane ki kera rongoa ru ne sa Jesus sasia, ma kera fasia na fere kera ki, kera ka leka burina sulia taale. ");
INSERT INTO far_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ma kada sa Jesus 'e koso, ma ka ada to'ona na fikue baita, nia ka kwaimanatai fuada, ma ka gura na wane ne kera matai ki. ");
INSERT INTO far_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma ana saulafi nai, na fafurongo nia ki kera leka mai siana, kera ka fata 'uri, “Kula ne, nao ta wane si to ana, ma nia karangi ka rodo na. 'Oe kwatea fikue ne kera leka na 'ada, fua kera leka 'uria na mae fere ki fua kera ka foli fanga 'ada.” ");
INSERT INTO far_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sa Jesus ka olisida ka 'uri, “Nao kera si leka. Kamulu kwatea fanga fuada fuana 'anilana.” ");
INSERT INTO far_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ma kera olisia kera ka 'uri, “Kalu to go ana lima fa beret ma ro gwa ie ki.” ");
INSERT INTO far_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ma sa Jesus ka fata 'uri fuada, “Mulu ngalia mai seki siaku.” ");
INSERT INTO far_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ma nia ka kwatea na wane ki kera gouru 'i ano fafona garasi. Sui nia ngalia na lima fa beret be ki ma ro gwa ie nai ki. Ma ka ada 'alaa 'uria 'i langi, ma ka tangoa God. Sui nia ka ngiia fa beret nai ki, ma ka kwatea fuana fafurongo nia ki, ma kera ka tolingia fuana wane nai ki. ");
INSERT INTO far_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Na wane nai ki, kera fanga leka kera ka abusu na. Sui na fafurongo nia ki kera konia na fanga ne ore ki laona te akwala ma ro kukudu, leka kera ka fungu tafau. ");
INSERT INTO far_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma na wane be kera fanga ki bobola fainia lima to'oni wane. Kera nao si tomainia go na keni ki ma na wele ki. ");
INSERT INTO far_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ma burina ru nai, sa Jesus ka odua na fafurongo nia ki kera ka eteta 'uria ta bali ana 'osi nai laona baru. Ma nia ka to buri fua ka saea fikue nai fua kera ka leka na 'ada. ");
INSERT INTO far_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ma burina ne wane ki kera oli na, nia ka ra taifilia gwauna te kula fane fua ka foa. Ma ana fa rodo nai, nia ka to 'ana taifilia senai. ");
INSERT INTO far_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ma kada nai, na baru be nia tau na fasia 'i sara, ma nanafo ki ka kwaea sulia nia fanao na fuana kuburu. ");
INSERT INTO far_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma ana kada rodo karangi 'ofodangi, sa Jesus ka leka 'i fafona kafo, ma ka leka na mai 'urida. ");
INSERT INTO far_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ma kada kera ada to'ona nia fali mai fafona na kafo, kera ka mau 'asiana. Ma kera ka akwa 'uri, “Na anoeru ru!” Ma kera ka fai ararai. ");
INSERT INTO far_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ma 'ali'ali sa Jesus ka fata fuada ka 'uri, “Nao mulu si mau lau! Nau ga 'ana ne.” ");
INSERT INTO far_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ma sa Pita ka olisia ka 'uri, “'Aofia 'ae, dia 'oe mamana na, 'oe fata mai 'uri nau fua nau kai leka kau siamu fafona na kafo ne.” ");
INSERT INTO far_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Sa Jesus ka fata 'uri, “Iu, leka mai.” Sui sa Pita ka koso fasia na baru, ma ka safali fali fafona na kafo siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ma ana kada nia ada to'ona na kuburu 'e baita, nia ka mau ma ka safali kuruu na laona kafo. Ma nia ka akwa ka 'uri, “'Aofia 'ae, 'oe famauri nau!” ");
INSERT INTO far_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ma 'ali'ali go sa Jesus ka kwate 'aba kau 'uria, ka dau nia, ma ka fata 'uri, “Na fitoe 'oe nia tu'u 'asiana. 'Uta ne 'oe fitala ani nau?” ");
INSERT INTO far_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ma kada keroa ra na laona baru, na kuburu be ka aroaro na. ");
INSERT INTO far_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","'Urinai go na wane ne kera to 'i laona baru ki, kera ka fabaita sa Jesus kera ka 'uri, “'Oe na ne Wele God mamana.” ");
INSERT INTO far_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ma kada kera tofolo ana 'osi, kera ka koso ana te mae fere kera saea ana Genesaret. ");
INSERT INTO far_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma na wane ana mae fere nai ki, kera ka ada saitamana sa Jesus. Ma kera kwate fatae fuana tani mae fere lau sulia sa Jesus, fua sae wane nai ki, kera ka talaia mai wane matai kera ki siana. Ma kera ka ngalia mai wane matai 'oro ki siana. ");
INSERT INTO far_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ma wane ki ka gania sa Jesus fua ka alamatainia na wane matai nai ki kera samo to'ona 'aena maku nia. Ma sa tifaida ne samo to'ona maku nia, kera ka 'akwa na. ");
INSERT INTO far_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sui tani Farasi ma na wane famanata ana taki ki, kera ka leka mai fasia Jerusalem siana sa Jesus fua ledilana. ");
INSERT INTO far_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Kera ka fata 'uri, “'Uta ne fafurongo 'oe ki si rosulia famanatalae ne koko kia ki alua na mai fuaka, sulia kera nao si taufia go 'abada 'i nao, ma kera fi fanga?” ");
INSERT INTO far_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sa Jesus ka olisida ka 'uri, “Kamulu laugo, 'Uta ne mulu sasi 'amulu sulia famanatae kamulu ki talamulu, ma nao mulu si sasi sulia taki God ki? ");
INSERT INTO far_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","God fata 'uri, ‘'Oe fabaita maa 'oe ma na gaa 'oe.’ Ma ‘Dia sa ti ne nia kwalangia maa nia naoma gaa nia, kera kai saungia ka mae.’ ");
INSERT INTO far_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Boroi ma, mulu famanata garo lalau 'uri, dia ta wane nia to ana tani ru ne nia saitamana kai 'adomia ana maa nia naoma gaa nia, ma ka fata lalau 'uri, ‘Nau kai kwatea na ru be ki fuana God.’ ");
INSERT INTO far_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Mulu saea, nia lea ga 'ana fua nia si 'adomia maa nia ma gaa nia ana ru be ki nia eta fata alangai na fuana God. Ma dia nia 'urinai, na famanatae ne mulu alua, nia fatu'ua na fatalana God. ");
INSERT INTO far_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ma kamulu ka saea mulu rosulia God, ma 'e nao si mamana go. Sa Aesaea nia fata mamana kada be nia fata suli kamulu, dia be nia kedea ne God fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Na tooa ne kera fabaita nau ga 'ada ana fatalada, boroi ma mangoda nia tau 'asiana fasi nau. ");
INSERT INTO far_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Kera fosi nau 'o'oni ga 'ada, sulia kera famanata ga 'ada sulia taki kera ki talada, ma kera ka saea na taki God ki na nai!’” ");
INSERT INTO far_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ma sa Jesus ka saea mai na wane 'oro ki siana, ma ka fata 'uri fuada, “Mulu fafurongo mai fuaku, fua mulu ka saitamana. ");
INSERT INTO far_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nao lau ta ru ne wane nia 'ania, ne nia kwatea na sualae fuana. Nao! Na fatae ne ru mai fasia ngiduna wane lalau ne fasua maurilana wane.” ");
INSERT INTO far_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Sui na fafurongo sa Jesus ki, kera leka mai siana, kera ka fata 'uri fuana, “Na ru be 'oe saea ki, na Farasi ki rongoa, ma manatada nao si lea sulia.” ");
INSERT INTO far_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ma sa Jesus olisida ka 'uri, “God kai falia famanatalae garo ki, sulia nia nao si leka mai fasi nia, dia ta wane ne failia ru ta'a ne kera bulao mai karangia ru ne nia fasida ki. ");
INSERT INTO far_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nao mulu si manata 'abero ana Farasi nai ki. Sulia kera dia ga 'ada na wane maa rodo ne nia talaia laugo ta wane maa rodo. Ma mulu ka saitamana laugo, dia ta wane maana rodo ma nia ka talaia laugo ta wane maana rodo, keroa kai 'asida tafau go laona kilu.” ");
INSERT INTO far_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ma sa Pita ka fata 'uri fuana sa Jesus, “'Oe fadaa basi mai fatae be 'oe fi saea go mai fua malu ki.” ");
INSERT INTO far_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sa Jesus olisia ka fata 'uri, “Kamulu fafurongo nau ki na ne, boroi ma nao manatamulu si kwatafa 'ua dia kera laugo. ");
INSERT INTO far_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","'Uta ne nao mulu si saitamana ru ne ki? Iu, na ru ne wane nia 'ania kai leka daofa liu na 'ana laona guina, ma 'i buri nia kai ru laugo mai 'ana fasia nonina. ");
INSERT INTO far_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Boroi ma ta faoraie ta'a ne nia ru mai fasia ngiduna wane, nia safali mai laona manatana wane. Na ru nai lalau ne kai fasua na maurilana wane. ");
INSERT INTO far_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ma ru ta'a ne ru mai fasia laona manatana wane ki ne 'uri: sauwanee, oeelae, sasi ta'alae fainia ta wane, sukelae fafia ta wane, belilana ru ta wane, fainia faorailae ta'a sulia ta wane. ");
INSERT INTO far_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Aia, ru nai ki saitamana ka fasua maurilana wane 'i naona God. Boroi ma na tau 'abalae naona fangalae, dia na falafala ne koko kia ki kera famanata mai ana, sui boroi 'ana ta wane nao si sasi sulia, na maurilana si ta'a go.” ");
INSERT INTO far_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sa Jesus ka leka na fasia na kula nai, ma ka leka 'uria na lofaa 'i Taea ma 'i Saedon. ");
INSERT INTO far_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma te keni ne nao lau Jiu laona tooa 'i Kenan nia leka mai siana, ma ka akwa 'uri, “'Aofia 'ae, 'oe na Wele ana kwalafa sa Deved, 'oe manatai nau mai! Na anoeru ta'a 'e rufia na wele keni nau, ma nia 'e nonifi 'asiana.” ");
INSERT INTO far_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sa Jesus nao si olisia go ana ta fatae. Ma na fafurongo nia ki ka leka mai siana sa Jesus, ma kera ka 'uri, “'Oe saea nia 'e leka kau 'ana, sulia nia leka buri kulu, ma ka alifi 'asiana.” ");
INSERT INTO far_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sa Jesus ka fata fuana keni nai ka 'uri, “God kwate nau go mai fuana wane Jiu ki ne kera dia na sipsip ne tafeo na ki.” ");
INSERT INTO far_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Sui na keni nai ka leka mai, ma ka boruru 'i maana 'aena ka 'uri, “'Aofia 'ae, 'oe kwai'adomi mai aku!” ");
INSERT INTO far_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sa Jesus ka olisia ka 'uri, “Nao nia si 'o'olo fua ngalilana fanga wele ki, ma ka 'ui 'ania fuana kui ki.” ");
INSERT INTO far_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Na keni nai ka 'uri, “Iu. Boroi ma kui ki saitamana kera 'ania ga 'ada na ngingisi fanga ne 'asia fasia na tatafe wane ne kera sangonida ki.” ");
INSERT INTO far_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sui sa Jesus olisia ka 'uri, “Keni ne 'ae, na famamanalae 'oe nia baita 'asiana! Ma na ru ne 'oe gania, nau kwatea fuamu.” Ma na wele keni nia ka 'akwa ana kada nai na. ");
INSERT INTO far_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Kada sa Jesus leka mai fasia mae fere nai, nia oli mai sulia taale ne liu ninimana 'osi baita 'i Galili. Ma nia ra gwauna te uo, ma ka gouru senai. ");
INSERT INTO far_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ma ana kada nai, wane 'oro ki kera leka mai siana. Ma kera ngalia laugo mai wane 'oro ne matai ki, tani wane 'aeda ma 'abada ki mae, tani wane maada rodo, ma tani wane ngiduda ka ato. Kera aluda maana 'aena sa Jesus, ma nia ka gurada, ma kera ka 'akwa tafau. ");
INSERT INTO far_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ma na wane ne kera oku fuana bubulae, kera kwele 'asiana kada kera ada to'ona wane ne ngiduda ato ki kera fata lau. Ma wane ne 'aeda ma 'abada mae kera lea lau. Ma ti ne kera nao si fali lea, ka fali lea na. Ma na wane maada rodo, ka ada lau. Sulia kera ada to'ona ru nai ki, kera fi fata lea ana God 'i Israel. ");
INSERT INTO far_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sui sa Jesus ka saea mai na fafurongo nia ki siana, ka 'uri fuada, “Nau ku kwaimanatai fuana wane ne ki, sulia kera to fai nau sulia olu maedangi ki, ma na fanga kera ka suina. Ma nao nau si doria olitailada 'uria fere kera ki kada kera fiolo 'uri, fasia ta wane ada ka ngwatautau ma ka maebuatamarakwa sulia taale.” ");
INSERT INTO far_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Na fafurongo nia ki olisia ka fata 'uri fuana, “Laona lofaa 'eke'eke 'uri, kulu kai dao to'ona fanga 'i fai fua ka bobola fainia wane 'oro 'uri ki?” ");
INSERT INTO far_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ma sa Jesus ledida ka 'uri, “Fita fa beret ne mulu too ana?” Fafurongo nia ki olisia ka fata 'uri fuana, “Fiu fa beret ki go, fainia bara gwa ie tu'u go ne kalu to ana.” ");
INSERT INTO far_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ana kada nai, sa Jesus saea wane ki kera gouru 'i ano. ");
INSERT INTO far_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Sui, nia ka ngalia fiu fa beret nai fainia gwa ie tu'u nai ki, ka tangoa God. Sui nia ka ngiia, ma ka kwatea fuana fafurongo nia ki, fua kera ka tolingia fuana wane nai ki. ");
INSERT INTO far_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ma wane nai ki, kera fanga tafau, ma kera ka abusu. Burina kera fanga ka sui, na fafurongo ki kera ka fafungua fiu kukudu ki ana orongana fanga ne ore. ");
INSERT INTO far_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Wane ne kera 'ania fanga nai, kera fai to'oni wane ki. Kera nao si tomainia go keni ma na wele ki. ");
INSERT INTO far_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Aia, ma burina kera fanga suina, sa Jesus fi olitainida 'uria fere kera ki. Ma nia fainia fafurongo nia ki, kera koso, ma kera ka ra laona te baru, kera ka leka 'uria mae fere kera saea ana Magadan. ");
INSERT INTO far_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Aia, tani Farasi fainia tani Sadusi, kera leka mai siana sa Jesus fua kera ka ilito'ona ga 'ada, ma kera ka gania fua nia ka fulia ta fanadae fua ka fatainia God ne odu nia mai. ");
INSERT INTO far_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sa Jesus ka olisida ka fata 'uri, “Ana kada ne sato nia su, dia mulu ada to'ona ne gwa salo ki nia meo, mulu saitamana ute nao si to malakwasi. ");
INSERT INTO far_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Iu, ma 'ofodangi, dia mulu ada to'ona gwa salo ki nia meo ma ka goa, mulu ka saitamana laugo ne ute kai 'aru. Mulu saitamana adalae to'ona salo, boroi ma nao mulu si ada saitamana ru ne God fulia ana kada ne ki. ");
INSERT INTO far_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kamulu wane ta'ena, kamulu wane ta'a ki, ma nao mulu si famamana go God. Mulu doria adalae to'ona ta fanadae. Boroi ma nao nau si sasi go ta fanadae fua mulu. Na fanadae ne nau sasia fua mulu ka ada to'ona go ne na fanadae ne fuli fuana profet Jona 'i nao.” Burina sa Jesus nia fata 'urinai, nia ka leka na fasida. ");
INSERT INTO far_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ana kada sa Jesus fainia na fafurongo nia ki kera tofolo 'uria na bali 'osi loko, na fafurongo nia ki nao si to ana ta beret, sulia kera manata buro ana ngalilana fai kera. ");
INSERT INTO far_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ma sa Jesus ka fata 'uri fuada, “Mulu kai ada lea suli kamulu fasia na isi fuana beret ana Farasi ki ma na Sadusi ki laugo.” ");
INSERT INTO far_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ma kera ka fata 'i safitada kwailiu, ma kera ka 'uri, “Nia fata 'urinai sulia ne nao kulu si ngalia mai ta fa beret.” ");
INSERT INTO far_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ma sulia sa Jesus nia saitamana go ana manatana fafurongo nia ki, nia ka fata 'uri, “'Uta ne kamulu ka fata sulia ne nao mulu si ngalia mai tani fa beret? Na famamanae kamulu ki 'e tu'u 'asiana! ");
INSERT INTO far_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nao mulu si malingainia 'ua na manatae wane laona ru ne nau ku saea fua mulu? Nao mulu si manata to'ona kada be nau ku ngiia lima fa beret be ki fuana lima to'oni wane be ki ma mulu ka fafungua kukudu 'oro ana fanga be ore ki? ");
INSERT INTO far_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Alamia mulu manata buro laugo ana fiu fa beret be nau ku sangonia ana fai to'oni wane, ma mulu ka fafungua kukudu 'oro be ana fanga ne ore ki? ");
INSERT INTO far_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","'Uta ne nao mulu si saitamana te ne nau ku fata sulia? Nao lau na beret ne nau ku fata sulia. Te ne nau ku saea na ne mulu kai madafi kamulu fasia na isi ne kai faboselana na beret Farasi ma na Sadusi ki.” ");
INSERT INTO far_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Burina nia fata 'urinai ka sui, na fafurongo ki fi saitamana te ne sa Jesus nia fata sulia. Nia fata lalau sulia famanatae Farasi ma na Sadusi ki. ");
INSERT INTO far_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kada sa Jesus nia dao ana fere 'i Sesarea Filipae, nia ka ledia na fafurongo nia ki ka 'uri, “'Uri ma wane ki kera sae nau, na Wele nia Wane, ana sa ti?” ");
INSERT INTO far_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kera olisia kera ka 'uri, “Tani wane sae 'oe ana sa Jon wane ni Siuabu ne nia mauri lau, ma tani wane sae 'oe ana sa Elaeja ne nia mauri lau. Ma tani wane lau kera sae 'oe ana sa Jeremaea naoma ta wane ana profet ki ne nia mauri lau.” ");
INSERT INTO far_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sui sa Jesus ka ledida ka 'uri, “Ma kamulu sae nau mone ana sa ti?” ");
INSERT INTO far_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ma sa Simon Pita ka olisia ka 'uri, “'Oe na Christ, na Wele God ne mauri firi.” ");
INSERT INTO far_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ma sa Jesus ka fata 'uri, “Simon na wele sa Jon 'ae, nia 'oilakie fuamu. Sulia ta wane si fatainia ru ne fuamu. Boroi ma na Maa nau 'i langi ne fatainia fuamu. ");
INSERT INTO far_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ma nau ku saea fuamu, 'oe sa Pita, ne fadalana na fau, ma fafona fau nai nau kai saungainia fikute wane famamana nau ki. Nau alu 'oe ta wane lalifu ne 'oe fanikila wane ne kera kai famamana nau ki. Ma na nikilalana maea nao si bobola fuana liufilada. ");
INSERT INTO far_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ma nau ku kwatea nikilalae fuamu ne dia na kii ana mae ana 'Initoe God. Fuana te ne 'oe luia wane ki nao si sasia laona molagali, God ka alafafia laugo fatalamu 'i langi. Ma ta te ne 'oe alamatainia wane ki ka sasi 'i laona molagali, God ka alamatainia laugo mai 'i langi.” ");
INSERT INTO far_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Sui sa Jesus ka fata talingai fuana fafurongo nia ki, fua kera nao si farongoa ta wane sae nia ne na Christ. ");
INSERT INTO far_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tala'ae ana kada nai ka leka, sa Jesus safali famadakwala fuana fafurongo nia ki ka 'uri, “Nau leka 'uria 'i Jerusalem. Ma na wane fanaonao ki, ma na fataabu baita ki, ma na wane famanata ana taki ki, kera kai fagaigai nau, ma kera kai saungi nau. Ma ana olu fa dangi, God kai tae nau lau 'uria na maurie.” ");
INSERT INTO far_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ma sa Pita ka talaia kau, ma ka ngatafia ka 'uri, “'Aofia 'ae, God luia! Na ru ne ki, nao si fuli fuamu!” ");
INSERT INTO far_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ma sa Jesus ka abulo, ma ka fata 'uri fua sa Pita, “Saetan 'ae, leka tau kau 'amu fasi nau! 'Oe tatae suali nau. Sulia manatalamu safali mai fasia na wane ki ga 'ana, ma nao lau fasia God.” ");
INSERT INTO far_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Sui sa Jesus ka fata 'uri fuana fafurongo nia ki, “Sa ti boroi 'ana ne doria kai leka buriku, nao nia si manata 'abero sulia ru nia doria ki ga 'ana talana. Nia kai leka buriku sui boroi 'ana nia kai nonifi, ma kai mae. ");
INSERT INTO far_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Sa ti boroi 'ana ne noni'ela si leka buriku sulia nia doria ka sasi 'ana sulia kwaidoria nia ki tala'ana, nia kai talafia na maurie firi. Boroi ma dia sa ti boroi 'ana ne nao nia si sasi sulia kwaidoria nia ki tala'ana, ma nia nonimabe kai mae sulia nia leka buriku, nia kai too ana maurie firi. ");
INSERT INTO far_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Dia ta wane ka too ana ru ki tafau laona molagali ne, ma nia ka mae, ma nia ka to tau fasia God, ru nai ki nao si fulia go ta lealae fuana. Nao ta wane si bobola fua folilana na maurie firi ana ta malefo. ");
INSERT INTO far_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nau ku saea ru ne sulia nau, na Wele nia Wane, nau kai leka mai fainia na 'ainsel nau ki, ana 'Initoe na Maa nau, ma nau kai kwatea na kwaiarae naoma na kwaekwaee fuana wane ki tafau, sulia na ru ne kera sasia. ");
INSERT INTO far_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ru mamana nau ku saea fua mulu, tani wane amulu kera nao si mae leka kera ka ada to'ona ne nau ku dao mai, ma nau ku gwaungai.” ");
INSERT INTO far_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Na ono fa dangi ki 'i burina, sa Jesus ka talaia sa Pita, ma ro waisasina ki sa Jemes ma sa Jon taifilida 'uria gwauna fa uo ne fane. ");
INSERT INTO far_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma kada kera ada kau, kera ka ada to'ona na maana sa Jesus nia tatala. Na maana ngwasinasina ka dia na sato, ma na maku nia ki ka kwao 'asiana. ");
INSERT INTO far_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ma na olu wane fafurongo ne ki, kera ka ada to'ona sa Moses fainia sa Elaeja keroa ka fata fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ma sa Pita ka fata kau 'uri fuana sa Jesus, “'Aofia 'ae, nia lea fua kalu ka to amalu 'i seki. Dia 'oe doria, nau saungainia ta olu 'o'obe, ta ai fuamu, ta ai fuana sa Moses, ma ta ai fuana sa Elaeja.” ");
INSERT INTO far_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma ana kada sa Pita nia fata ga 'ana 'ua, te gwa salo ngwasinasina 'e koni mai, ma nunufilana ka su fafida, ma kera ka rongoa na lingeru nia fata mai fasia laona gwa salo nai, “Nia ne na wele mutai nau ne nau ku kwaimani ana, ma ku eele fainia. Mulu rongo sulia nia!” ");
INSERT INTO far_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ma kada fafurongo nia ki kera rongoa na lingeru ne, kera ka mau 'asiana, ma kera ka tio na 'ada fafia na maada 'i ano. ");
INSERT INTO far_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ma sa Jesus dao mai siada, ma ka samo to'oda, ka fata 'uri, “Mulu tatae. Nao mulu si mau.” ");
INSERT INTO far_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ma kada kera ada kau, kera nao si ada to'ona na ta wane, boroi ma taifilia sa Jesus go. ");
INSERT INTO far_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma kada kera koso mai fasia gwauna fa uo nai, sa Jesus ka fata talingai fuada ka 'uri, “Nao mulu si farongoa ta wane ana ru ne mulu ada to'ona, leka ka dao ana kada God kai tae nau, na Wele nia Wane, fasia maea.” ");
INSERT INTO far_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Olu fafurongo nia ki ledia kera ka 'uri, “'Uta ne wane famanata ana taki ki saea sa Elaeja kai oli lau mai, sui na wane be God filia fi leka mai?” ");
INSERT INTO far_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Sa Jesus ka olisida ka 'uri, “Nia mamana. Sa Elaeja ne kai eta oli mai, fua ka 'adomia wane ki fuana sasi akaulae. ");
INSERT INTO far_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ma nau ku saea lau fua mulu, sa Elaeja nia dao mai ka suina. Boroi ma na wane ki nao si ada saitamana go. Nia ne, kera ka sasia ga 'ada ru ta'a ki 'ani nia sulia na kwaidoria kera ki. Ma kera kai sasi 'urinai laugo 'ani nau.” ");
INSERT INTO far_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ana kada olu fafurongo nai ki kera rongoa, kera fi saitamana ne sa Jesus fata fuada sulia sa Jon wane ni Siuabu. ");
INSERT INTO far_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Kada sa Jesus fainia olu fafurongo nia ki kera koso mai 'uria 'aena uo nai, na wane 'oro ki kera oku na, ma te wane ka leka mai, ka boruru maana 'aena sa Jesus, ma ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“'Aofia 'ae, 'oe manataia mai na welewane nau, sulia na futomae nia saungia. Na mataie ne sasia ma nia ka oewanea, ma kada 'oro nia 'ui 'ani nia laona ere, ma laona kafo laugo. ");
INSERT INTO far_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nau ku ngalia mai fuana fafurongo 'oe ki. Boroi ma nia 'afitai 'asiana fua kera ka gura.” ");
INSERT INTO far_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sa Jesus ka fata 'uri fuada, “Manatamulu ngasi 'asiana, ma mulu wane ta'a ki! Mulu nao si famamana nau 'ua! Nau ku noni kulu na ana abu fitoe ne kamulu. Nau ku to fai kamulu ka dao na 'uri, fulina kamulu ka famamana nau na.” Sui nia ka fata 'uri fuana wane nai, “'Oe ngalia mai na wele 'oe seki.” ");
INSERT INTO far_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ma sa Jesus ka fata talingai fuana anoeru ta'a nai, ma nia ka leka fasia wele nai. Ma na wele nai ka 'akwa na ana kada nai. ");
INSERT INTO far_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Sui, kada kera to taifilida, na fafurongo ki leka mai siana sa Jesus, ma kera ka ledia 'uri, “'Uta ne nia 'afitai fua malu fua ifulangailana anoeru ta'a be?” ");
INSERT INTO far_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ma sa Jesus olisida ka fata 'uri, “Nia 'urinai, sulia ne famamanae kamulu nia tu'u 'asiana. Ma nau ku saea fua mulu, dia na famamanae kamulu ana God ka dia boroi 'ana na mege mastad ne nia tu'u 'asiana, kamulu saitamana mulu kai sasia go 'amulu te ne nia 'afitai. Dia nia 'urinai, fa uo loko boroi, mulu ka 'idua fasia fulina ana fatalamulu. Ma dia mulu famamana nikilalae ana God, nao ta ru si 'afitai fua mulu ka sasia.” ");
INSERT INTO far_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ma ana kada fafurongo nia ki kera oku mai 'i Galili, sa Jesus ka fata 'uri fuada, “Nau, na Wele nia Wane, kera kai kwate nau fuana malimae nau ki, ");
INSERT INTO far_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","fua kera ka saungi nau. Boroi ma ana oluna fa dangi, God kai tae nau lau 'uria maurie.” Ma kada fafurongo ki kera rongoa sa Jesus nia fata 'urinai, kera ka kwaimanatai 'asiana. ");
INSERT INTO far_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ana kada sa Jesus fainia na fafurongo nia ki kera leka mai 'uria fere 'i Kapaneam, na wane kera koni malefo ana takisi fuana Beu Abu God, kera leka mai siana sa Pita, ma kera ka ledia, “'Uri ma wane famanata kamulu saitamana folia laugo malefo ne kalu liu fua konilana fuana Beu Abu God?” ");
INSERT INTO far_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ma sa Pita olisida ka 'uri, “Iu, nia folia.” Ma kada sa Pita nia ru laona lume, sa Jesus eta ledia basi ka 'uri, “Simon 'ae, 'oe manata 'uta? Tifaida ne na kingi ana molagali saitamana ka ngalia malefo fasida? Na wele kera ki talada, naoma fasia wane 'e'ete ki?” ");
INSERT INTO far_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Sa Pita olisia ka 'uri, “Fasia wane 'e'ete ki.” Ma sa Jesus ka 'uri, “Nia 'urinai, na wele kera ki nao si folia go na takisi ne. Nia ne, dia nau nao si folia boroi na takisi fuana Beu Abu na Maa nau, nia lea ga 'ana. ");
INSERT INTO far_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ma sui boroi 'ana ka 'urinai, nao nia si lea fua kulu ka falia na manatalada fua kulu. 'Oe leka la 'osi, 'oe dee mai. Na gwa ie ne 'oe eta lafua, 'oe 'ifingia ngiduna, 'oe kai ada to'ona malefo ne bobola fai koro fua folilana takisi fuana te fangali. Ngalia malefo nai, ma 'oko kwatea fuada.” ");
INSERT INTO far_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ana kada nai, na fafurongo sa Jesus ki kera leka mai siana, ma kera ka ledia ka 'uri, “'Uri kada God kai gwaungai, sa ti ana kalu ne kai 'initoa ka tasa?” ");
INSERT INTO far_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ana kada nai, sa Jesus ka saea mai te wele tu'u siana, ma ka fauua safitada. ");
INSERT INTO far_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ma nia ka fata 'uri, “Ru mamana nau ku saea fua mulu, dia mulu talana na abulolae kamulu, ma mulu ka fatu'u kamulu talamulu dia ka wele ki, mulu bobola fuana God ka gwaungai fafi kamulu. ");
INSERT INTO far_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ma sa ti ne ka fatu'ua nia 'i tala'ana dia ka wele ne, nia kai 'initoa kada God kai gwaungai. ");
INSERT INTO far_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Dia sa ti ne 'oe kwaloa ta wele 'uri sulia ne nia famamana nau, 'oe kwalo nau lau go. ");
INSERT INTO far_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Dia ta wane nia kwatea wane kera marabibi ki ka 'asia fasia fitoe kera aku, nia lea fuana kera kania ta fau baita luana, ma kera ka 'ui 'ania laona matakwa. ");
INSERT INTO far_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kwaimanatailae fuana wane laona molagali sulia ru 'oro fuana fagarolada nia kai leka firi. Boroi ma nia kai ta'a 'asiana fuana wane ne kai sasia ru nai fua sae ka kwatea wane ki ka 'asida fasia fitoe kera aku. ");
INSERT INTO far_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Ma dia 'oe doria sasia ta ru ta'a ana 'abamu, 'oe siki musia fasi 'oe. Nia ta lea ga 'ana fuamu dia 'oe to tau 'amu laona maurie 'i langi fainia na ngunguru 'aba naoma ngunguru 'ae, fasi 'oe fi koso laona kula ni kwaekwaee fainia ro 'aba naoma ro 'ae ki, kula ne ere nia saru si mae. ");
INSERT INTO far_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ma dia maamu kwate 'oko 'asi 'oe fasia fitoe 'oe aku, 'oe lafua 'amu fasi 'oe, ma 'oko 'ui 'ania. Nia ta lea ga 'ana fuamu dia 'oe ru 'i laona maurie 'i langi fainia te bali maa, fasi 'oko koso laona kula ana ere ne nao si mae fainia ro bali maa ki.” ");
INSERT INTO far_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Ma sa Jesus ka fata lau 'uri, “Nao mulu si siniulangainia na ka wele ne ki. Sulia ne 'ainsel kera ki farongoa God na Maa nau 'i langi, sulia te ne mulu sasi ada. ");
INSERT INTO far_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Ma dia ta wane nia to ana te talanga sipsip, ma te ai ada ka tafeo, te ne wane nai kai sasia? Wane nai kai fasia sikwa akwala ma sikwa sipsip ki ana toloa ne kera fanga ana, ma ka leka ka nani 'uria te sipsip ne nia tafeo ma ka naoana. ");
INSERT INTO far_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kada nia dao na to'ona, nia eele ka liufia na eelea nia ki fainia na sipsip ne kera to ga 'ada fainia. ");
INSERT INTO far_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Na Maa kamulu 'i langi, nia 'e manata laugo 'urinai, sulia nao nia si doria ta ka wele 'ana ka funu sulia abulo ta'alae nia ki.” ");
INSERT INTO far_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Sa Jesus ka fata 'uri fuana fafurongo nia ki, “Dia ne wanefuta 'oe sasia ta ru ka garo fuamu, 'oe leka siana, 'oko farongoa ana na garoe nia 'i safitamoro taifili kamoro. Ma dia nia rongo 'oe, kamoro ka kwaimani lau. ");
INSERT INTO far_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ma dia nia si rongo 'oe, 'oko talaia te wane naoma ta ro wane lau fai 'oe, fua kera ka famamana ru ne 'oe saea, fua 'oko sasi sulia na Kekedee Abu be saea, ‘Na ro wane naoma ta olu wane fua kera ka famamana na fatae ne nia saea.’ ");
INSERT INTO far_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ma dia nia nao si alafafia go fata famamanalae kera, 'oko farongoa ana na fikute wane God ki. Ma dia ne fikute wane God ki boroi, nia si rongoda go, 'oko alua 'i maa fasia fikute wane kamulu ka dia na wane kera ulafusia God, naoma ta wane ta'a ne nia konia na malefo ana takisi. ");
INSERT INTO far_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ru mamana nau ku saea fua mulu, ta te ne mulu luia wane ki nao si sasia laona molagali, God alafafia laugo 'i langi. Ma ta te ne mulu alamatainia wane ki ka sasi laona molagali, God alamatainia laugo mai 'i langi. ");
INSERT INTO far_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nau ku saea lau fua mulu, dia ta ro wane ana kamulu keroa alafafia ta ru laona molagali, ma keroa ka fo 'uria, Maa nau 'i langi nia kai kwatea fuadaro. ");
INSERT INTO far_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ma dia ta ro wane naoma olu wane kera oku ana ta kula, sulia kera famamana nau, nau ku to laugo senai fai kera.” ");
INSERT INTO far_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Sa Pita leka mai siana sa Jesus, ma ka ledia ka 'uri, “'Aofia 'ae, ta fita kada ne nau ku saitamana nau manatalugea wanefuta nau, kada nia sasia ta ru ka ta'a fuaku? Nia leka ka dao ana fiu kada ki?” ");
INSERT INTO far_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ma sa Jesus ka olisia ka 'uri, “Nau ku saea fuamu, nao lau fiu kada ki, boroi ma fiu akwala ma fiu kada ki ne 'oe manatalugea ana. ");
INSERT INTO far_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nau saea 'urinai sulia 'Initoe God dia ta kingi ne nia doria fa'o'olosilana na ngali langalae ki fainia wane rao nia ki. ");
INSERT INTO far_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Aia, na etana wane ni rao ka dao mai ne nia ngali langa ana molee malefo. ");
INSERT INTO far_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ma na wane rao nai nao si bobola na fuana duulana na ngali langalae nia, ma na kingi ka oduda fua kera ka 'oifoli ana nia, na 'afe nia, na wele nia ki, ma na ru nia ki tafau fuana duulana na ngali langalae nia. ");
INSERT INTO far_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ma na wane rao nai leka mai ka boruru 'i naona na kingi ne, ma ka amasia ka 'uri, ‘'Oe mabetu'u basi fai nau, fua nau kai duua na ru 'oe ki tafau.’ ");
INSERT INTO far_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ma na kingi nai ka kwaimanatai fuana, ma nia ka manatalugea na ngali langalae nia fua nia si duua na, ma nia ka alamatainia ka leka na 'ana. ");
INSERT INTO far_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Aia, kada wane nai nia ru kau 'i maa, nia ka dao to'ona te wane ana wane rao ki ne nia ngali langa ana bara fa malefo siana. Nia ka daua, ma ka safali 'inia na luana wane rao nai, ma ka fata 'uri, ‘'Oe duua na ru be 'oe ngali langa ana siaku ki!’ ");
INSERT INTO far_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ma wane rao nai ka boruru, ma ka amasia ka 'uri, ‘'Oe mabetu'u basi fai nau, ma nau kai duua fuamu.’ ");
INSERT INTO far_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Boroi ma nia ka noni'ela, ma ka ngali nia, ma ka alu laona beu ni kanie, leka nia ka duua na ngali langalae nai. ");
INSERT INTO far_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ma kada tani wane rao kera ada to'ona na ru nai, manatalada ka kwaimanatai 'asiana. Ma kera leka siana na kingi nai, ma kera farongoa ana ru ki tafau. ");
INSERT INTO far_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ma na kingi ka saea mai wane rao eteta nai, ma ka fata 'uri fuana, ‘'Oe na wane ta'a 'asiana! Nau ku manatalugea na ngali langalae be 'oe ki tafau, sulia 'oe amasi nau 'uria. ");
INSERT INTO far_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Tala'ana 'oe kwaimanatai go fuana wane rao nai, dia be nau ku sasia laugo fuamu.’ ");
INSERT INTO far_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ma kingi nai 'e guisasu 'asiana, ma ka kwatea fua kwaelana laona beu ni kanie, leka nia ka duua ru ki tafau ne nia ngali langa ana.” ");
INSERT INTO far_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ma sa Jesus ka fasuia na tarifulae nai ka 'uri, “Ma na ru nai laugo ne na Maa nau 'i langi kai sasia fua mulu, dia nao mulu si manataluge mamana ana tolamulu faida.” ");
INSERT INTO far_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kada sa Jesus fata ka suina, nia ka leka fasia lofaa nai 'i Galili. Ma nia ka tofolo ana kafo 'i Jodan, ma ka dao ana ta lofaa 'i Jiudea. ");
INSERT INTO far_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ma na wane 'oro kera leka sulia. Ma wane kera matai ki, sa Jesus ka gurada ma kera ka 'akwa. ");
INSERT INTO far_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ma tani Farasi kera leka go mai 'ada fuana ilitolana sa Jesus. Ma kera ka ledi 'uri ana, “'Uri ma na taki sa Moses, nia lea ga 'ana fua wane ka lukasia na 'afe nia 'uria ta ru boroi 'ana ne nia doria?” ");
INSERT INTO far_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Sa Jesus olisida ka 'uri, “'Uri ma nao mulu si manata lea sulia ru ne kamulu idumia laona Kekedee Abu? Na Kekedee Abu fata 'uri, ‘Ana safalilana mai, God nia saungainia wane ki ana welewane ma keni.’ ");
INSERT INTO far_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ma na Kekedee Abu ka fata laugo 'uri, ‘Sulia ru nai, wane ka fasia na maa nia fainia gaa nia, ma ka 'ado fainia na 'afe nia, ma keroa ka alua na te manatalae dia te wane go.’ ");
INSERT INTO far_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nao lau ta ro wane 'e'ete, boroi ma dia na te wane. Nia ne, ru God nia kani okua ka suina, nao si lea fuana ta wane ka lugea lau.” ");
INSERT INTO far_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ma na Farasi ki ka ledia lau kera ka fata 'uri, “Ma te taki sa Moses fata 'uri, ‘Sa Moses nia alamatainia ne wane kai kedea ta 'aba beba ana kwailukasilae, ma ka kwatea fuana 'afe nia fua nia ka lukasia na.’ Ma 'uta ne sa Moses ka alamatainia fuana wane ki ka sasi 'urinai?” ");
INSERT INTO far_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sa Jesus ka fata 'uri fuada, “Sa Moses nia alamatainia fua mulu Jiu ki fua lukasilana 'afe kamulu ki, sulia nia 'afitai fuana famanatalamulu, sulia manatamulu ngasi 'asiana. Sui boroi 'ana ka 'urinai, 'i nao mai ana kada God nia saungainia wane ma keni, nao nia si 'urinai. ");
INSERT INTO far_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ma nau ku saea fua mulu, dia 'afe ta wane nao si oee go, ma na arai nia ka lukasia ma ka adea lalau ta keni, na wane ne nia garo na ana oeelae.” ");
INSERT INTO far_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Burina sa Jesus ka fata 'urinai fuada, fafurongo nia ki kera 'e fata 'uri fuana, “Ma dia nia 'afitai fuana wane ka lukasia 'afe nia 'urinai, ni lea fuana wane nao si arai go.” ");
INSERT INTO far_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ma sa Jesus ka 'uri fuada, “Wane 'oro ki nao si saitamana lea ana ru mamana sulia araie. Boroi ma bara wane go ne God kwatea liatoe fuada fua kera ka malingainia famanatae ne. ");
INSERT INTO far_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nau ku saea ru ne sulia tani wane nao si arai, sulia safali ana kada kera futa mai, nao ta ru si 'o'olo laona nonida, nia ne sasia kera si bobola fuana araie. Ma tani wane nao si arai sulia na wane ki kera saungainia na nonida ne sasia kera nao si bobola na fuana araie. Ma tani wane kera nao si arai fua kera ka rao nikila fuana God. Ma wane ne kera bobola fuana arailae, alamatainia kera leka sulia na famanatae ne sulia araie.” ");
INSERT INTO far_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma burina ru ne, tani wane kera ngalia mai na kaela wele ki siana sa Jesus, fua ka alua na 'abana fafida, ma ka foa fafida. Ma na fafurongo nia ki ka balufida. ");
INSERT INTO far_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ma sa Jesus ka fata 'uri fuada, “Mulu alamatainia na kaela wele ki ka leka mai siaku, nao mulu si susida lau. Sulia God nia gwaungai ana wane ne marabibi ka dia kaela wele ne ki.” ");
INSERT INTO far_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Sui sa Jesus ka alua na 'abana fafida kaela wele nai ki, ma ka faleada. Sui, nia ka leka na 'ana. ");
INSERT INTO far_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ana te kada, te wane fi baita nia leka mai siana sa Jesus, ma ka ledi 'uri, “Wane Famanata 'ae, na ru lea te ki ne nau ku sasia fua nau ku too ana na maurie firi?” ");
INSERT INTO far_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sa Jesus ka fata 'uri fuana, “'Uta ne 'oe ledi nau sulia ru lea ki? Taifilia God go ne lea. Dia 'oe doria too ana maurie firi fainia God, 'oe rosulia na taki nia ki ne nia saea.” ");
INSERT INTO far_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ma na wane nai ka ledia lau sa Jesus ka 'uri, “Taki te ki nai?” Sa Jesus ka olisi 'uri ana, “'Oe si sauwanee, 'oe si oee, 'oe si beli, 'oe si suke fafia ta wane. ");
INSERT INTO far_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ma 'oko fabaita maa 'oe ma gaa 'oe. Ma 'oe kwaimani ana tolamu ka dia laugo ne 'oe kwaimani amu talamu.” ");
INSERT INTO far_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sui wele fi baita ne ka fata 'uri fuana sa Jesus, “Ru nai ki, nau ku sasi na mai sulia. 'Uri ma te lau ne fua nau ku sasia?” ");
INSERT INTO far_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ma sa Jesus olisia ka 'uri fuana, “Dia 'oe doria 'oe to 'o'olo tafau, leka 'oe fafoli ana ru 'oe ki tafau, ngalia malefo nai, 'oko kwatea fuana wane siofa ki, ma 'oe kai too ana toorue 'i langi. 'Urinai go, 'oe leka na mai suli nau.” ");
INSERT INTO far_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ma ana kada wele fi baita nai rongoa ru nai ki, na manatana 'e kwaimanatai 'asiana, ma nia ka leka na 'ana, sulia nia wane todaru 'asiana. ");
INSERT INTO far_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ma sa Jesus ka fata 'uri fuana fafurongo nia ki, “Nau ku saea fua mulu, nia ka 'afitai fua wane todaru ki kai ru laona maurie ne God kai gwaungai fafia. ");
INSERT INTO far_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ma nau ku saea laugo fua mulu, nia 'afitai 'asiana fua ta kamel kai ru sulia na mae kwakwa tu'u ana nile. Nia 'afitai ka liufia lau fua ta wane todaru kai ru laona maurie ne God kai gwaungai fafia.” ");
INSERT INTO far_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ma kada fafurongo nia ki kera rongoa ru nai ki, kera ka kwele 'asiana, ma kera ka fata 'uri, “Ma dia nia ka 'afitai fua wane todaru ki 'urinai, sa ti mone ne ka bobola fuana maurie firi?” ");
INSERT INTO far_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ma ana kada sa Jesus fata, nia ka ada 'o'olo kau fuana fafurongo nia ki, ma ka fata 'uri, “Nia 'afitai 'asiana fuana wane ki kai toda maurie firi, boroi ma fuana God nao nia si 'afitai go. Na ru ki tafau nia ngwaluda ga 'ana fuana God.” ");
INSERT INTO far_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ana kada nai, sa Pita ka ledia sa Jesus ka 'uri, “Ma kalu 'uta mone? Sulia kalu fasia na toorue kalu ki tafau, ma kalu ka leka na suli 'oe. Ma te ne God kai kwatea fua malu?” ");
INSERT INTO far_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ma sa Jesus ka olisia fuada ka 'uri, “Nau ku saea fua mulu, ana kada God kai alua na molagali falu, nau, na Wele nia Wane, nau kai gouru ana kula ni gourue nau fuana ketolana wane ki tafau. Ana kada nai, kamulu akwala ma ro wane fafurongo nau ki, mulu kai to fai nau ana kula ana 'initoe fuana ketolana wane ki ana akwala ma ro kwalafa ana Israel ki. ");
INSERT INTO far_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ma sa ti ne fasia lume nia, na wanefuta nia ki, na waiwane nia ki, na maa fai gaa nia, ma wele nia ki, naoma ta ano 'ana boroi, sulia nia leka suli nau, na wane nai kai ngalia ru lea 'oro ki liufia ru be nia too ana 'i nao ki. Ma God kai kwatea laugo maurie firi fuana. ");
INSERT INTO far_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ma wane 'oro ne kera eteta ana kada nai, kera kai 'isi. Ma wane 'oro ne kera 'isi, kera kai eteta.” ");
INSERT INTO far_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sa Jesus ka fata lau 'uri fuana fafurongo nia ki, “Na 'Initoe God nia 'uri: Nia dia na wane ne to ana gano, ma ka leka 'i 'ofodangi fuana laefilana wane ki fua raoe laona oole nia. ");
INSERT INTO far_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ma nia ka alafafia na folilada ana malefo ne bobola fuana te maedangi, ma ka oduda na fuana raoe laona oole nia. ");
INSERT INTO far_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Ma ana sikwana kada sato 'ofodangi, nia ka leka lau, ma ka ada to'ona tani wane ne kera uu 'o'oni ga 'ada laona usie, ma kera nao si sasia go ta ru. ");
INSERT INTO far_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ma nia ka 'uri fuada, ‘Kamulu kai leka laugo mai, fua kulu rao laona oole nau, ma nau kai foli kamulu ana ru ne bobola fainia.’ ");
INSERT INTO far_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ma kera ka leka na. “Ma tofungana asoa, ana oluna kada sato, nia ka leka lau, ma ka sasi laugo 'urinai. ");
INSERT INTO far_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma bobola fainia limana kada sato saulafi, nia ka leka ma ka dao to'ona tani wane ne kera uu 'o'oni ga 'ada maana fuli usie. Ma nia ka ledida 'uri, ‘'Uta ne kamulu ka uu 'o'oni go amulu 'i seki sulia maedangi laulau ne, ma nao mulu si sasia go ta ru?’ ");
INSERT INTO far_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ma kera olisia kera ka 'uri, ‘Nao ta wane si sae kalu go.’ “Ma nia ka fata 'uri fuada, ‘Kamulu leka ma mulu ka rao fainia wane loko kera eta rao na ki laona oole nau.’ ");
INSERT INTO far_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ma kada na sato nia su na, wane ne to ana oole, ka fata 'uri fuana wane baita ana raoe nia, ‘'Oe saea mai na wane rao ki, ma 'oe folida ana malefo kera ki. 'Oe safali ana wane be nau ku saeda 'isi, leka ka dao ana wane be nau ku eta saeda ki.’ ");
INSERT INTO far_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Na wane rao be nia saeda 'isi ki saulafi, kera dao, ma nia ka folida ana malefo ne bobola fainia te fa dangi fuana te wane. ");
INSERT INTO far_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ma kada ne wane be nia saeda mai 'i nao kera dao mai, kera kwaisae nia kai folida ka ta baita. Boroi ma kera tafau ngalia go malefo ne bobola fainia te fa dangi fuana te wane. ");
INSERT INTO far_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ma kada kera ngalia na, kera ka ngunungunu buri fuana wane ne too ana na oole, kera ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Na wane ne 'oe saeda 'isi ki, kera rao go sulia kada tu'u, ma 'oe folida ka bobola laugo fai kalu na wane ne ngali kulua ana raoe sulia maedangi laulau ne, ma na sato ka sato fifi amalu.’ ");
INSERT INTO far_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ma nia ka fata 'uri fuana te wane ada, ‘Wane nau 'ae, nau si suke 'oe go. 'Oe alafafia raoe fuana te malefo go be. ");
INSERT INTO far_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ngalia na folifolia 'oe, ma 'oko leka na 'amu. Nau ku doria kwatea fuana wane ne nau laefida 'isi mai ka dia laugo ne nau ku kwate fuamu. ");
INSERT INTO far_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ma nau ku to ana nikilalae fuana sasilana te ne nau dori sasia ana malefo nau talaku. 'Uta 'oko 'uga, sulia nau ku kwate ru baita fuana wane 'e'ete loko ki?’” ");
INSERT INTO far_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ma sa Jesus ka fata 'uri, “Nia ne, na wane ne kera 'isi ana kada nai, kera kai eteta. Ma na wane ne kera eteta ana kada nai, kera kai 'isi.” ");
INSERT INTO far_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kada sa Jesus nia leka 'uria 'i Jerusalem, nia ka talaia na fafurongo nia ki kera ka leka karangi nia taifilida, ma nia ka fata fuada taifilida ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Mulu fafurongo! Kulu ra 'alaa 'uria 'i Jerusalem, ma kera kai 'olomaelaku, na Wele nia Wane, fuana fataabu baita ki fainia na wane famanata ana taki ki. Ma kera kai keto nau fuana maelaku. ");
INSERT INTO far_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ma kera kai kwate nau fuana wane ne nao lau Jiu ki, ma kera kai 'onionga 'ani nau, ma kera ka kwae nau. Sui kera kai foto'i nau ana 'airarafolo fuana saungilaku. Aia, ma ana oluna maedangi, God kai tae nau lau fuana mauri.” ");
INSERT INTO far_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Burina ru nai, 'afe sa Sebedi fainia ro wele nia ki, sa Jemes ma sa Jon, kera dao mai fua adalae to'ona sa Jesus. Na keni nai leka mai, ka boruru naofana sa Jesus, ma ka gania 'uria sasilana ta ru fuana ro wele nia ki. ");
INSERT INTO far_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ma sa Jesus ka ledia keni ne ka 'uri, “Te ne 'oe doria?” Nia ka fata 'uri, “Nau ku doria 'oe alangai fuaku, 'oe alamatainia ro wele ne nau ki ka to karangi 'oe, ta wane ka gouru 'i bali 'o'olo amu, ma ta wane bali mauli 'amu, kada 'oe kingi laona 'Initoe 'oe.” ");
INSERT INTO far_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ana kada nai, sa Jesus ka fata 'uri fuana wele nai ki, “Ru ne kamoro gania, kamoro nao si saitamana go ana na fadalana. Kamoro bobola go 'amoro nonifilae dia ne nau kai nonifi ana?” Ma keroa ka fata 'uri, “Iu, karo bobola go 'amaro.” ");
INSERT INTO far_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sa Jesus ka fata 'uri lau fuadaro, “Nia mamana na nonifilae ne kai dao to'omoro. Boroi ma fuana ta wane ka gouru 'i bali 'o'olo aku, ma ta wane bali mauli aku dia ne kamoro doria, nao lau nau ne filia. Taifilia Maa nau mai langi go ne saitamana kwatelana fua sa tifaida ne nia filida ka suina.” ");
INSERT INTO far_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Kada na akwala fafurongo nai ki kera rongoa te ne sa Jemes ma sa Jon keroa gania, kera ka guisasu fuana ro wanefuta nai ki. ");
INSERT INTO far_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Nia ne, sa Jesus ka sae kera go mai siana, ka fata 'uri, “Kamulu saitamana na wane gwaungai ki ne kera gwaungai fuana wane ne nao lau Jiu ki, kera to ana nikilalae, ma kera saitamana usungailana wane ki fuana sasilana ru kera doria ki. ");
INSERT INTO far_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sui boroi 'ana, nao nia si 'urinai lau safitamulu. Dia ta wane amulu nia doria ka fanaonao, nia ka saitamana ne nia na wane rao kamulu. ");
INSERT INTO far_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ma dia sa ti amulu ne doria ka eteta, nia kai rao 'o'oni fuana wane ki. ");
INSERT INTO far_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nia ka sasi dia nau, na Wele nia Wane. Sulia nau nao si leka mai fua wane ki kera ka rao fuaku. Boroi ma nau ku leka lalau mai fua nau rao fuana wane ki tafau, ma nau leka mai fua ku kwatea na maurilaku fuana famaurilana na wane 'oro ki.” ");
INSERT INTO far_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ma kada sa Jesus fainia fafurongo nia ki kera leka kau 'uria 'i Jerusalem, kera ka liufia na kau mae fere 'i Jeriko. Ma kada kera leka fasia fere nai, na wane 'oro kera leka mai sulida. ");
INSERT INTO far_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ma na ro wane maada rodo ki keroa to ninimana taale. Ma kada keroa rongoa sa Jesus ne leka mai sulia taale, keroa ka akwa, keroa ka 'uri, “'Aofia 'ae. 'Oe Wele ana kwalafa sa Deved, 'oe manatai karo mai.” ");
INSERT INTO far_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ma kada ne wane ki kera rongo keroa, kera ka balufi keroa, ma kera ka 'uri, “Moro to aroaro!” Boroi ma kada kera fata 'urinai, keroa fi akwa baita lau 'uri, “'Aofia 'ae. 'Oe Wele ana kwalafa sa Deved, 'oe manatai karo mai.” ");
INSERT INTO far_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ma kada sa Jesus rongoa ne keroa akwa mai 'urinai, nia ka uu ngado, ma ka saeda mai, ma ka ledida 'uri, “Te ne kamoro doria nau sasia fuamoro?” ");
INSERT INTO far_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Keroa olisia, keroa ka 'uri fuana, “'Aofia, karo doria 'oe 'ifingia maamaro fua karo kai ada.” ");
INSERT INTO far_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","'Urinai, sa Jesus ka kwaimanatai 'asiana fuadaro, ma nia ka samo to'ona na maadoro. Ma ana kada nai go, na maadaro ka ada na, ma keroa ka leka na fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ma sa Jesus fainia na fafurongo nia ki kera dao karangia na 'i Jerusalem, ana fere 'i Betfeis, gwauna fa uo 'i Olif. Senai, sa Jesus ka kwatea ro wane ana fafurongo nia ki, keroa ka eteta 'i nao, ");
INSERT INTO far_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ma nia ka fata 'uri fuadaro, “Kamoro leka ana fere loko kamoro naofia kau. Ma kada kamoro dao 'i senai, kamoro kai dao to'ona te dongki, kera kania senai fainia na wele. Moro lugeda, ma moro ngalida mai siaku. ");
INSERT INTO far_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ma dia ta wane ka ledi kamoro, moro ka saea fuana ka 'uri, ‘Na 'Aofia ne doria.’ Ma 'urinai nia kai ala'anida fuamoro.” ");
INSERT INTO far_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ru ne nia fuli fua ka famamana te be na profet nia saea ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Mulu kai saea fuana wane 'i Jerusalem ki, mulu ka 'uri, ‘Ada to'ona basi. Na kingi kamulu, nia leka na mai siamulu. Nia ka fatu'ua, ma ka leka mai fafona na dongki. Nia ka leka mai fafona na dongki tu'u.’” ");
INSERT INTO far_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ma na ro wane ana fafurongo nia ki, keroa ka eteta na 'i nao, ma kera ka sasia ru ne ki sa Jesus saea fuadaro. ");
INSERT INTO far_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Keroa talaia mai na dongki nai fainia na wele, ma kera ka safatainia na maku kera ki fafona na sulina dongki tu'u nai, ma sa Jesus ka gouru fafona. ");
INSERT INTO far_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma na wane 'oro ki kera safatainia maku gwala kera ki sulia taale, ma tani wane ka tofua ulina niniu ki, ma kera ka safatainia sulia taale. ");
INSERT INTO far_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ma fikue ne kera eteta naona sa Jesus, ma tani ai ka 'isi kau burina, kera akwa kera ka 'uri, “Tangolae fuana wele ana kwalafa sa Deved na kingi! Ma God 'oe oilakitainia wane ne nia leka mai ana na nikilalae 'oe! Lafutainia God nia to 'i langi!” ");
INSERT INTO far_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ma kada sa Jesus nia dao 'i Jerusalem, na wane ana fere nai kera eele 'asiana, ma tani wane kera ledida ka 'uri, “Sa ti ne?” ");
INSERT INTO far_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ma na fikue nai kera ka 'uri, “Nia sa Jesus na profet, na wane fasia fere 'i Nasaret laona lofaa 'i Galili.” ");
INSERT INTO far_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kada sa Jesus leka mai ka dao laona Beu Abu God, nia ka taria wane ne kera foli ma kera fafoli senai ki. Ma nia ka kefusia na tatafe ana wane ne kera talana malefo senai ki, ma ka kefusia na ru fuana gourue na wane ne kera 'oifoli ana bole ki. ");
INSERT INTO far_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ma sa Jesus ka fata 'uri fuana wane nai ki, “Na Fatalana God laona Kekedee Abu nia fata 'uri, ‘Na Beu nau, kera saea ana na beu fuana folae.’ Boroi ma kamulu abulotainia ka alua lalau kula fuana belilana ru wane ki.” ");
INSERT INTO far_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ana kada nai, tani wane maada rodo, ma tani wane 'aeda mae, kera leka laugo mai siana sa Jesus laona Beu Abu God, ma nia ka gurada tafau. ");
INSERT INTO far_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Aia, ma na fataabu baita ki, ma na wane famanata ana taki ki, kera ka guisasu kada kera ada to'ona ru lea ne sa Jesus nia sasia ki, ma kera ka rongoa kaela wele ki kera akwa laona Beu Abu ka 'uri, “Tangolae fuana wele ana kwalafa sa Deved na kingi!” ");
INSERT INTO far_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ma na fataabu baita ki fainia na famanata ki, kera ka fata 'uri fuana sa Jesus, “'Oe rongoa te ne kera saea! 'Uta ne nao 'oe si luida?” Ma sa Jesus ka olisida ka 'uri, “Iu, nau ku rongoa. Nao mulu si idumia go fatae be laona Kekedee Abu? Nia fata 'uri, ‘God, 'oe famanata kaela wele ki fua kera ka tango 'oe.’” ");
INSERT INTO far_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sui 'i burina, sa Jesus fainia na fafurongo nia ki, kera leka na fasia 'i Jerusalem, ma kera ka leka 'uria 'i Betani. Ma kada nia rodo na, kera ka tio senai. ");
INSERT INTO far_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","'Ofodangi ana ruana maedangi, sa Jesus fainia fafurongo nia ki kera oli mai 'uria 'i Jerusalem, ma sa Jesus ka fiolo. ");
INSERT INTO far_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ma nia ka ada to'ona te 'ai figi ne uu ninimana taale, ma nia ka leka 'aena, boroi ma nao nia si ada to'ona go ta fueru ana, taifilia go ulina. Ma nia ka fata 'uri fuana 'ai figi nai, “Sulia nao 'oe si alua go ta fueru, 'urinai safali ana kada ne nao 'oe si fungu lau!” Ma kada nai go, na 'ai nai ka kuku na. ");
INSERT INTO far_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kada fafurongo ki kera ada to'ona ru nai, kera ka kwele 'asiana. Ma kera ka ledi nia, “Te ne sasi na 'ai ne ka mae 'ali'ali ga 'ana 'uri?” ");
INSERT INTO far_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ma sa Jesus olisida ka 'uri, “Nau ku saea fua mulu, dia mulu famamana ma nao mulu si fitala, kamulu saitamana mulu kai sasia go 'amulu ru baita liufia ru ne nau sasia ana 'ai figi ne. Dia mulu saea fuana fa uo ne, ‘'Oe tatae, ma 'oe 'ui 'ani 'oe talamu laona na asi,’ ru nai kai fuli go ana. ");
INSERT INTO far_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Dia mulu fosia God, ma mulu ka famamana ne God kai sasi ru ne mulu gania, nia kai sasi ga 'ana.” ");
INSERT INTO far_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Aia, ana kada sa Jesus nia oli lau laona Beu Abu God fuana famanatalana wane ki, na fataabu baita ki, ma tani wane fanaonao ana Jiu ki, kera leka mai siana. Ma kera ka ledi 'uri, “Sa ti ne saea 'oe taria wane ne ki fasia laona Beu Abu? Ma sa ti ne kwatea nikilalae fua 'oko sasia ana ru ne ki?” ");
INSERT INTO far_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ma sa Jesus ka olisida ka 'uri, “Iu, nau ku ledi kamulu basi 'uria te ru. Dia kamulu olisia, nau fi farongo kamulu ana nikilalae ne nau ku to ana fua sasilana ru ne ki. ");
INSERT INTO far_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Iu, mulu saea basi fuaku, na nikilalae ne sa Jon nia to ana fua na siuabulae, nia safali mai fasia 'i fai? Nia safali mai ana God, naoma nia safali mai ana wane ki go?” Ma kera ka safali olisusue 'i safitada kwailiu kera ka 'uri, “Te ne kulu kai saea? Dia kulu olisia ma kulu ka 'uri, ‘Fasia God,’ nia kai fata 'uri, ‘'Urinai ma 'uta mone ne mulu si famamana sa Jon?’ ");
INSERT INTO far_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ma dia kulu fata 'uri, ‘Nia safali go mai ana na wane ki,’ wane ki kera kai guisasu fua kulu, sulia na wane ki kera saea sa Jon nia ta profet”. ");
INSERT INTO far_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nia ne kera olisia ga 'ada 'uri fuana sa Jesus, “Kalu ulafusia go ti ne saea sa Jon ka siuabua wane ki.” Ma sa Jesus ka fata 'uri fuada, “Nau boroi nau kusi farongo kamulu laugo ana na nikilalae 'uta ne nau ku sasia ana ru ne ki.” ");
INSERT INTO far_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ma sa Jesus ka fata lau 'uri fuada, “Mulu manata 'uta sulia ru ne? Te wane nia to ana ro welewane ki. Ma nia ka leka siana na wele 'i nao, ma ka fata 'uri fuana, ‘'Alakwa nau 'ae, ta'ena 'oe leka, 'oko rao laona oole be kulu.’ ");
INSERT INTO far_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Ma nia ka olisia ka 'uri, ‘Nau ku ta'aku go.’ Ma sui 'i buri, nia ka talana na manatalana, ma ka leka na laona oole. ");
INSERT INTO far_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ma 'i buri, na maa ka leka lau siana ruana wele, ka saea laugo te fatae nai. Ma na wele ne olisia ka 'uri, ‘Nia lea ga 'ana nau kai leka.’ Boroi ma nia nao si leka go. ");
INSERT INTO far_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“'Uri ma sa ti 'adaro na ne sasia ru be na maa keroa nia doria?” Ma kera olisia kera ka 'uri, “Na wele be 'i nao.” Ma sa Jesus ka fata 'uri fuada, “Ru mamana nau ku saea fua mulu, na wane ta'a ki ne kera konia na malefo ana na takisi, ma na keni sesele ki, kera kai eta ru 'i laona maurie ne God nia gwaungai fafia 'i nao amulu. ");
INSERT INTO far_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Sa Jon wane ni Siuabu be dao na mai siamulu fuana fatailana tolae ne God nia doria fua mulu kai to sulia, ma nao mulu si famamana nia go. Boroi ma, na wane ta'a ne kera konia malefo ana takisi, ma keni sesele ki, kera famamana nia. Ma sui boroi 'ana mulu ada to'ona na ru nai ki, nao mulu si famamana go sa Jon, ma nao mulu si talana go manatamulu.” ");
INSERT INTO far_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sa Jesus fata lau fuada ka 'uri, “Mulu rongoa basi te tarifulae lau. Te wane baita nia fasia na oole grep. Ma nia saungainia sakali kalia, ma ka 'elia te kilu fuana mangisilana fue grep ki fua saungailana waeni, ma ka saungainia te lume fuana folo 'usia oole. Ma nia ka alua na oole nia laona 'abana wane ki ne kera rao 'i laona. 'Urinai, nia ka leka na 'ana 'uria ta mae fere tau. ");
INSERT INTO far_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ma kada ne oole nai nia maua, nia kwatea na wane rao nia ki fuana wane ne kera ada sulia na oole nia, fua ka ngalia mai tani fue grep ana 'ai ne nia fasia laona oole nai. ");
INSERT INTO far_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Ma na wane ne ada sulia na oole ki, kera daua na wane rao nia ki, ma kera ka kumua te wane, ma ruana wane kera saungia ka mae na, ma oluna wane kera 'ui fauna fua saungilana. ");
INSERT INTO far_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sui nia ka kwatea lau wane rao 'oro ki liufia 'i nao siada. Ma wane ne kera ada sulia oole nai, kera ka sasi 'urinai laugo ada. ");
INSERT INTO far_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma 'isilana, nia ka kwatea na wele mamana nia siada. Ma nia ka manata 'uri, ‘Kera kai manata baita ana na wele nau ne.’ ");
INSERT INTO far_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Boroi ma kada ne wane nai ki kera ada to'ona na wele nia, kera ka fata kwailiu fuada ka 'uri, ‘Nia na ne na wele na wane be nia too ana na oole. Kulu saungia ka mae fua kulu ka ngalia 'akulu na oole ne fuaka.’ ");
INSERT INTO far_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ma kera daua, kera ka tara 'i maa fasia oole nai, ma kera ka saungia ka mae. ");
INSERT INTO far_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“'Urinai ma kada wane ne too ana na oole nia 'e dao mai, te na ne nia kai sasia ana wane ne ada sulia oole ki?” ");
INSERT INTO far_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ma kera olisia ka 'uri, “Nia kai saungia wane ta'a ki ka mae, ma nia ka kwatea lau oole nia fuana tani wane 'e'ete ne kera kai kwatea ta bali fuana ana kada ana konirue.” ");
INSERT INTO far_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ma sa Jesus ka fata 'uri fuada, “Nia mamana mulu idumia na Kekedee Abu be fata 'uri, ‘Na fau ne wane saungai lume ki kera noni'ela ana, nia ne na fau talingai ka liufia fau ki tafau ana 'odoe. God ne fulia ru nai, ma na adalae to'ona ka lea 'asiana.’ ");
INSERT INTO far_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Ma nia ne nau ku saea fua mulu, na 'oilakie ana 'Initoe God, nia kai lafua fasi kamulu, ma ka kwatea 'ana fua wane ne rosulia ki. ");
INSERT INTO far_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ma dia sa ti ne nia lakwadora fafona fau nai, nia kai mangisi. Ma sa ti ne fau nai ka 'asia fafia, na nonina ka meme tafau na.” ");
INSERT INTO far_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ma kada ne fataabu baita ki ma na Farasi ki, kera rongoa tarifulae nai, kera saitamana ne sa Jesus nia fata sulida. ");
INSERT INTO far_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Nia ne kera doria daulana. Boroi ma kera mau, sulia na wane 'oro ne kera oku ana kada nai, kera famamana ne sa Jesus nia na profet. ");
INSERT INTO far_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Sa Jesus ka fata lau ana tarifulae fuana wane ki ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Na 'Initoe God nia 'uri: Te kingi nia saungainia na fafanga ana araie fuana wele nia ne kai arai. ");
INSERT INTO far_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ma nia ka kwatea na wane rao nia ki siana na wane ne nia laefida ki fuana fafanga nai, fua kera ka leka mai. Boroi ma kera noni'ela lalau ana lekalae mai. ");
INSERT INTO far_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Sui nia ka kwatea lau tani wane rao, ka fata 'uri fuada, ‘Mulu farongoa na wane ne nau laefida ki, na fafanga nau nia kwaimakwali na. Nau ku saungia tafau na buluka baita nau ki, ma kaela buluka nau ki, ma ru ki tafau ka kwaimakwali na. Mulu leka na mai ana fafanga nau.’ ");
INSERT INTO far_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Boroi ma kera nao si doria go rolae sulia, ma kera ka leka 'e'ete lalau 'ada. Ta wane ka leka na laona oole nia, ma ta wane ka leka na laona sitoa nia. ");
INSERT INTO far_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ma tani wane kera daua wane rao nai ki, kera ka kwaeda, ma kera saungida. ");
INSERT INTO far_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ma na kingi ne ka guisasu 'asiana, ma nia ka kwatea wane ni omee nia ki, kera ka saungia wane nai ki ne kera saungia na wane rao nia ki. Ma kera ka sungia na fere baita kera. ");
INSERT INTO far_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Sui nia ka fata 'uri fua wane rao nia ki, ‘Na fafanga kwaimakwali na, boroi ma na wane be nau ku laefida ki, kera si bobola fua lekalae mai ana na fafanga fai kalu. ");
INSERT INTO far_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Mulu leka sulia taale ki, mulu ka laefia mai na wane ki tafau ne mulu dao to'oda, kera ka leka mai ana fafanga ne.’ ");
INSERT INTO far_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ma wane rao ki kera ka leka sulia taale ki, kera ka okua mai na wane ki tafau ne kera dao to'oda. Ma na fafanga ana araie nai ka fungu ana wane lea ki ma na wane ta'a ki. ");
INSERT INTO far_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Sui kada ne na kingi nia dao mai fua adalae to'ona na wane ne kera dao ki, nia ka ada to'ona te wane ne nao si ofi go ana na maku ana na araie. ");
INSERT INTO far_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ma na kingi ka fata 'uri, ‘Nao 'oe si ofi ana na maku fuana fafanga ana araie, 'urinai nao nia si lea fua 'oko to seki.’ Ma na wane nai nao si saea na ta ru. ");
INSERT INTO far_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Sui na kingi ka saea fuana wane rao nia ki ka 'uri, ‘Mulu kania na 'abana ma na 'aena wane ne, ma mulu 'ui 'ania laona kula rorodoa 'i maa, ana kula ne wane kai angi ma ka 'ala girigiri ana lifoda, sulia kera nonifi.’” ");
INSERT INTO far_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sui sa Jesus ka fata na 'uri, “Na wane 'oro ki ne God laefida, boroi ma bara wane go ne nia filida.” ");
INSERT INTO far_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Na Farasi ki kera leka, ma kera ka lokoeru fua fagarolana sa Jesus ana ru ne nia saea ki. ");
INSERT INTO far_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ma kera kwatea fafurongo kera ki fainia tani wane 'ana sa Kingi Herod siana sa Jesus. Ma kera ka fata 'uri, “Wane Famanata 'ae, kalu saitamana ru 'oe saea ki, ru mamana tafau go. 'Oe famanata ga 'amu sulia mamanae ma kwaidoria God fuana wane ki. Ma 'oe si 'ado go fainia ta wane ana ta te ne kera manata sulia. Ma nao 'oe si manata go 'uria na 'initoe na wane. ");
INSERT INTO far_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Iu, 'oe saea basi fua malu! 'Uri ma na taki kia, nia luia kwatelana malefo ana takisi fuana kingi baita 'i Rom? 'Uri ma nia bobola fua kalu kai kwatea takisi be, naoma 'e nao?” ");
INSERT INTO far_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ma sa Jesus saitamana suina manatalae ta'a kera, ma ka fata 'uri, “Kamulu wane kwalabasa ki, 'uta ne mulu sasi 'uria fagarolaku? ");
INSERT INTO far_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mulu fatainia basi malefo ne mulu folia ana takisi.” Ma kera ka ngalia mai te seleni, kera ka fatainia fuana. ");
INSERT INTO far_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ma nia ka ledida ka 'uri, “Na nununa sa ti ne? Ma na satana sa ti mone ne?” ");
INSERT INTO far_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ma kera olisia, kera ka 'uri, “Na nununa, ma na satana na kingi baita 'i Rom.” Ma sa Jesus ka fata 'uri, “Mulu kwatea fuana kingi baita 'i Rom ru nia ki, ma mulu ka kwatea laugo ru God ki fuana God.” ");
INSERT INTO far_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ma kada kera rongoa na olisilae nai 'e lea, kera ka kwele 'asiana, ma kera ka leka na 'ada fasia. ");
INSERT INTO far_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ma ana fa dangi nai laugo, tani Sadusi kera leka mai siana sa Jesus. Na Sadusi ki kera saea na wane ki kera nao si tatae lau fasia na maea. ");
INSERT INTO far_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ma kera ka ledia sa Jesus, kera ka fata 'uri, “Wane Famanata 'ae, sa Moses nia kedea na taki fuaka ka alangai 'uri, ‘Dia ta wane nia mae, ma na 'afe nia ka mauri 'ua, boroi ma nao nia si to ana ta wele, na wanefuta nia ka adea lau na gwa 'oru nai, fua keroa ka to ana ta wele fua ka talana na wane ne nia mae na.’ ");
INSERT INTO far_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ma te kwalafa akulu Jiu ki, kera to ana fiu waisasina ki. Ma na wane 'i nao ka adea ta keni. Aia, kada keroa si to 'ua ana ta wele, wane nai ka mae na. ");
INSERT INTO far_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Na ruana wane ka adea lau keni nai. Aia, nao keroa si to laugo ana ta wele, ma nia ka mae laugo 'ana. Oluna wane ka adea lau, ma ka mae laugo. Nia 'urinai leka fiu waisasina nai, kera mae ka sui go. ");
INSERT INTO far_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Burina bara waisasina ne kera mae, keni ne boroi ka mae laugo. ");
INSERT INTO far_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","'Uri ma, ana maedangi ne God kai taea wane mae ki tafau fasia maea, sa ti ada ne na 'afe nia? Sulia na fiu waisasina nai ki be kera adea na keni nai tafau?” ");
INSERT INTO far_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sa Jesus ka olisi kera ka 'uri, “Kamulu garo na, sulia mulu si saitamana go na Kekedee Abu ki ma na nikilalae God. ");
INSERT INTO far_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Sulia, kada ne wane mae ki kera kai tatae lau fuana maurie, kera dia na 'ada na 'ainsel ki 'i langi ne kera nao si arai. ");
INSERT INTO far_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Iu, nau ku famanata kamulu sulia na tatae fasia na mae. Nau ku saitamana kamulu idumia sulia be God saea 'ua na mai ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nau na ne God sa Abraham, God sa Aesak, ma na God sa Jakob.’ God nia nao lau God fuana wane ne kera mae ki, boroi ma God fuana wane ne kera mauri ki.” ");
INSERT INTO far_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ma ana kada ne wane 'oro ki kera oku kalia sa Jesus, kera rongoa ru nai ki, ma kera ka kwele 'asiana ana famanatalae nia ki. ");
INSERT INTO far_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ana kada ne Farasi ki kera rongoa sa Jesus ne fanofoa na Sadusi ki ana na olisilae nia, kera ka oku mai siana. ");
INSERT INTO far_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ma te wane ada ne famanata ana taki ki, nia sasi 'uria ka fagaroa sa Jesus ana na ledilae ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wane Famanata 'ae, na taki te ne talingai ka liufia taki kia ki tafau?” ");
INSERT INTO far_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ma sa Jesus olisia ka 'uri, “‘'Oe kwaimani ana God 'oe, ana manatamu tafau, ana mangomu tafau, ma ana liomu tafau.’ ");
INSERT INTO far_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nia na ne taki eteta ma ka talingai 'asiana. ");
INSERT INTO far_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ma ruana taki ka dia laugo ka 'uri, ‘'Oe kwaimani ana tolamu ka dia laugo ne 'oe kwaimani amu talamu.’ ");
INSERT INTO far_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ma na taki fasia sa Moses ki tafau, ma na famanatalae profet ki kera oku tafau go ana ro taki ne ki.” ");
INSERT INTO far_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ana kada tani Farasi kera oku kalia sa Jesus, nia ledida ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Na Christ, wane ne God nia filia fua famaurilana wane ki, kamulu saea nia futa mai ana sa ti ne?” Kera ka olisi 'uri ana, “Na Christ kai futa mai ana kwalafa sa Deved na kingi.” ");
INSERT INTO far_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Sui sa Jesus ka ledi kera lau, “'Uta mone ne na Anoeru Abu nia kwatea manatae wane fuana sa Deved na Kingi ka saea nia na 'Aofia nau? Deved nia fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘God nia fata 'uri fuana 'Aofia nau: 'Oe gouru 'i bali 'o'olo aku, makwalia kada nau kai alua malimae 'oe ki farana gwaungaie 'oe.’ ");
INSERT INTO far_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Sa Deved 'ana talana ne saea na Christ ana na ‘'Aofia.’ Nia ne, na Christ nia nao lau Wele ana kwalafa sa Deved ga 'ana. Nia 'Aofia nia laugo.” ");
INSERT INTO far_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ma ana kada nai, nao ta wane ada si bobola na fuana olisilana ana ta ru. Ma burina na, nao ta wane si nonira'a na fuana ledilana sa Jesus lau. ");
INSERT INTO far_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","'I burina ru nai, sa Jesus ka fata fuana wane ne kera oku mai ki, ma na fafurongo nia ki ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Na wane famanata ana taki ki, ma na Farasi ki, kera to ana nikilalae fuana famanatalae ana taki sa Moses ki. ");
INSERT INTO far_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Nia ne, mulu rosulida, ma mulu sasia na ru ki tafau ne kera saea fua mulu. Boroi ma nao mulu si sasi lau sulia ru ne kera sasia ki, sulia kera nao si sasi go sulia ru ne kera fata sulia ki. ");
INSERT INTO far_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kera alua lau tani taki 'oro ne 'afitai fuana wane ki ka rosulia, boroi ma kera nao si nonimabe fuana kwai'adomilae ana wane ki fuana sasilae sulia taki nai ki. ");
INSERT INTO far_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Ma kera sasia ru ki tafau fuana wane ki ka suada ma ka kwaisae kera wane lea ki. Ma ru 'uri ki ne kera sasia. Kera kania maadarada, ma 'i 'abada ana reba ru baita ki ne kera kedea na Kekedee Abu ki ana. Ma kera taia na ngagamuna maku kera ki ka gwala. ");
INSERT INTO far_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma kera doria 'asiana gourue ana kula 'initoa ana fafanga ki, ma kula 'initoa ki fuana gourue laona beu fuana folae ki. ");
INSERT INTO far_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ma kera doria 'asiana tangolada maana usie ki, ma kera ka doria wane ki ka fata 'uri ada, ‘Wane Famanata nau.’ ");
INSERT INTO far_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Boroi ma nao si lea fuana ta wane ga 'ana ne ka fata 'uri amulu, ‘Wane Famanata nau,’ sulia taifili nau go ne te wane famanata kamulu, ma kamulu na bara waisasina laona fikue famamanalae. ");
INSERT INTO far_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ma nao mulu si fa'initoa ta wane famanata laona molagali ana fatae 'uri, ‘Maa kalu,’ sulia kamulu kai fa'initoa go te Maa kamulu ne nia to mai 'i langi. ");
INSERT INTO far_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ma nao si lea fuana ta wane ga 'ana ka fata 'uri amulu, ‘Wane baita,’ sulia kamulu to go ana te wane baita, ma nia na ne nau, na Christ, wane ne God nia filia fuana famaurilana wane ki. ");
INSERT INTO far_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dia ta wane doria ka baita safitamulu, nia ka dia na wane rao. ");
INSERT INTO far_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma ta wane ne ka fabaita nia talana, God kai fatu'u nia. Ma ta wane boroi 'ana ne ka fatu'u nia talana, God kai fabaita ana.” ");
INSERT INTO far_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Ma sa Jesus ka fata lau 'uri, “Nia ta'a 'asiana fua mulu na famanata ana taki ki, ma kamulu na Farasi ki, Kamulu wane kwalabasa ki! God kai kwae kamulu, sulia ne mulu bilaki 'usia na mae ana 'Initoe God fasia wane ki. Kamulu laugo nao mulu si doria go ne mulu ka ru laona 'Initoe God, ma mulu susia wane ne kera faisusu 'uria rulae. ");
INSERT INTO far_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ta'a 'asiana fua mulu na famanata ana taki ki ma kamulu na Farasi ki, na wane kwalabasa ne mulu suke ana wane ki. Aia, God kai kwae kamulu, sulia mulu ulafu 'asiana ana liufilana kula ki tafau, laona asi ma laona tolo, 'uria daolae to'ona ta wane, fua ka leka sulia na taki sa Moses ki. Aia, ma kada wane 'e leka go suli kamulu, mulu fi sasi akau lalau ana nia fuana lekalae 'uria kula ni kwaekwaee. Ma na kwaekwaee nia kai baita ka liufi kamulu sulia na abulolana 'e ta'a ka liufi kamulu tafau na. ");
INSERT INTO far_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ta'a 'asiana fua mulu, ma kamulu dia na wane maa rodo ki ne kera talaia wane ki. Nia ne, God kai kwae kamulu, sulia mulu famanata 'uri ana wane ki, ‘Sui boroi 'ana sa ti ne ka fangasia alangaie nia ana Beu Abu God, nia lea ga 'ana dia nao nia si sasia te ne nia alangai fuana. Boroi ma dia nia fangasia alangaie nia ana na gol be laona Beu Abu God, nia ne ka abu 'asiana fuana 'oilana alangailae nia.’ ");
INSERT INTO far_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mulu maa rodo, ma mulu oewanea 'asiana. Te ne baita, na gol naoma na Beu Abu God ne sasia gol ne ka abu? Na Beu Abu God ne baita liufia na gol! ");
INSERT INTO far_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ma mulu famanata laugo wane ki 'uri, ‘Sui boroi 'ana sa ti ne ka fangasia alangaie nia ana na fulifue, nia lea ga 'ana dia nao nia si sasia te ne nia alangai ana. Ma dia nia ka fangasia alangaie nia ana afafue ne to fafona fulifue, nia ne abu 'asiana fuana 'oilana alangailae be nia.’ ");
INSERT INTO far_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kamulu maa rodo. Te ne baita, afafue naoma na fulifue ne nia kwatea afafue ka abu? Na fulifue ne 'initoa ka liufia na afafue. ");
INSERT INTO far_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Sulia na fulifue ne 'initoa ka liufia na afafue, ma sa ti ne fangasia alangaie nia ana na fulifue, tama nia alangai ana na fulifue loko fainia afafue ki tafau ne kera to fafona fulifue nai. ");
INSERT INTO far_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ma sa ti boroi 'ana ne fangasia alangaie nia ana Beu Abu God, 'urinai tama nia alangai na ana God ne nia to laona Beu Abu nai. ");
INSERT INTO far_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ma dia ta wane ka fangasia alangaie nia ana 'i langi, tama nia alangai ana kula ni gourue God, ma God ne to laugo 'i langi. ");
INSERT INTO far_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ta'a 'asiana fua mulu na wane famanata ana taki ki ma kamulu na Farasi ki, Mulu na wane kwalabasa ki. God kai kwae kamulu. Mulu kwatea ta bali ana tangafuluna ru ki fuana God ana ka ru ne mulu fasida laona oole kamulu ki fua ka falea fanga kamulu ki, ma nao mulu si manata 'abero go fuana rolae sulia famanatae baita ana taki ki. Na famanatae baita ana taki ki fata 'uri, ‘Wane kai sasia na ru ki tafau ne 'o'olo fuana wane ki. Nia ka kwaimanatai fuana wane ma ka saea ru mamana ki.’ Mulu kai sasia na ru nai ki, fainia na ru tu'u ki laona taki ki laugo. ");
INSERT INTO far_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kamulu dia na wane maa rodo ne talaia na wane ki. Mulu saitamana go 'amulu manata 'abero 'uria lekalae sulia ka ru laona taki ki. Ma nao mulu si manata 'abero go ana ru baita laona taki ki. Kada mulu sasi 'urinai, ru ne nia ada dia mulu lafua go 'amulu na lango fasia te ne mulu kufia, boroi ma mulu kai onomia go 'amulu na kamel baita. ");
INSERT INTO far_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ta'a 'asiana fua mulu na famanata ana taki ki ma kamulu na Farasi ki ne mulu saitamana sasilana ru ki fua wane ki kera ka eele amulu. Aia, God kai kwae kamulu, sulia mulu madafia 'asiana taufilana nonina na titiu fuana fanga ki, boroi ma mulu fafungua ana na fanga ne mulu ngali ana wane ki sulia ogalulumilae. ");
INSERT INTO far_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kamulu na Farasi ki maamulu nia rodo! Mulu talana na manatalae kamulu ki ka falu. Dia ne manatalae kamulu ki falu, na abulolae kamulu ki boroi falu laugo. 'Urinai, na maurilamulu dia na titiu ki ne falu 'i nonina ma laona laugo. ");
INSERT INTO far_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ta'a 'asiana fua mulu na famanata ana taki ki ma kamulu na Farasi ki, mulu kwatea wane ki kera ka saea kamulu ana wane lea ki. Boroi ma God kai kwae kamulu, sulia mulu dia kilu gwau ki ne kera farafua ma adalae to'ona ka lea 'i maa, boroi ma 'i laona nia fungu ana suli fainia nonina wane mae ki, ne kera moko ngwa'a na. ");
INSERT INTO far_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ru ne nia mamana ana kamulu, sulia te ki ne mulu sasia nia ada lea 'asiana maana wane ki. Boroi ma na manatalae kamulu ki nia ta'a 'asiana, ma mulu ka saitamana sukelana wane. ");
INSERT INTO far_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","30","“Ta'a 'asiana fua mulu na famanata ana taki ki, ma kamulu laugo na Farasi ki, mulu saitamana sasilana ru ki fuana wane ki ka saea kamulu wane lea 'asiana. Boroi ma God kai kwae kamulu, sulia mulu saea dia kamulu to ana kada be 'i nao, mulu si 'adomia go koko kamulu ki fuana saungilana na profet ki. Ma ta'ena mulu alua na fau lea ki fafona kilu gwau profet nai ki, ma na wane lea ki 'i nao fuana fakwangalana. ");
INSERT INTO far_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kada mulu saea kera na koko kamulu ki, nia fatainia mulu futa olitana kwalafa koko ta'a kamulu ki ne kera saungia profet ki mai 'i nao. ");
INSERT INTO far_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aia, ma dia 'urinai, mulu fasuia na 'amulu raoe ne koko kamulu ki etangia mai 'i nao! ");
INSERT INTO far_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kamulu na ne abulolae kamulu ki dia na fa tafo ki. Ka 'afitai 'asiana fua mulu ka tafi fasia kwaekwaee ana kula ni kwaekwaee. ");
INSERT INTO far_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sulia ru nai ki, nau ku saea ru ne fua mulu, nau kai kwatea tani profet ma tani wane saitamarue ma tani famanata siamulu. Ma tani ai ada mulu kai saungida ma mulu kai foto'ida ana 'airarafolo. Tani wane ada, mulu kai dauda ma mulu kai namusida laona beu fuana folae ki, ma mulu kai tari kwailiu ada fasia laona fere kamulu ki. ");
INSERT INTO far_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nia ne kwatea God kai kwae kamulu fafia saungilana na wane lea ki, safali mai ana maelana sa Abel, na wane 'o'olo, leka ka dao ana maelana sa Sekaraea, na wele sa Barakaea ne mulu saungia karangia fulifue laona Beu Abu God. ");
INSERT INTO far_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nau ku saea fua mulu ne kwaiketoie fuana maelana wane nai ki kai to fafomulu wane ana kada ne.” ");
INSERT INTO far_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ma sa Jesus ka ada kau fuana fere 'i Jerusalem, ma ka fata 'uri, “Wane ana Jerusalem 'ae! Kamulu be 'ui fauna profet be God nia oduda mai fua mulu ki, ma mulu ka saungida. Ana kada 'oro nau ku doria mulu kai leka mai siaku fua nau ku ada suli kamulu dia ta karai nia ofia na wele nia ki 'i farana kukubana. Boroi ma nao mulu si doria go. ");
INSERT INTO far_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ma ana kada ne na, God kai leka fasi kamulu, ma ka luka faburi na ana fere kamulu. ");
INSERT INTO far_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ma nau ku saea fua mulu, nao mulu si ada to'oku lau, leka ka dao ana kada ne mulu kai fata 'uri, ‘God, 'oe oilakitainia na wane ne leka mai ana nikilalae 'oe!’” ");
INSERT INTO far_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ma 'i burina ne sa Jesus fata 'urinai ka sui, nia ka leka fasia Beu Abu God. Ma kada sa Jesus nia leka kau, na fafurongo nia ki kera leka mai siana, kera ka fata 'uri, “'Oe ada to'ona basi 'amu na lume lea ne ki laona labu 'ana Beu Abu God.” ");
INSERT INTO far_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sa Jesus ka fata 'uri fuada, “Iu, 'oe ada to'ona na lume baita ne ki. Nao ta te gwa fau seki kai tio lau 'i fulina. Kera tafau kera kai takalo 'i ano.” ");
INSERT INTO far_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Burina, sa Jesus ra gwauna fa uo 'i Olif, ma kada nia gouru 'ana, na fafurongo nia ki kera leka mai siana, ma kera gouru fainia taifilida. Ma kera ka ledi 'uri ana sa Jesus, “Kada te na ne ru ne 'oe saea fua malu ki kai dao mai? Aia, ma te ne kai dao mai fua sae kai fatainia kada 'oe fua olilae mai, fainia kada ne molagali kai sui ana?” ");
INSERT INTO far_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Sa Jesus ka olisi kera ka 'uri fuada, “Kamulu kai adaada lea, ma nao mulu si alamatainia ta wane ka talai garo amulu. Sulia ne wane 'oro ki kera kai dao mai ana sataku, ma kera ka fata 'uri, ‘Nau na ne na Christ!’ Ma kera ka talai garo ana wane 'oro ki. ");
INSERT INTO far_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ma te ru lau, mulu kai rongoa firue ki ana fere karangi ki, ma na fatae sulia firue ki ana tani fere tau laugo mai. Ka 'urinai boroi 'ana, nao mulu si manata 'abero sulia. Ru 'urinai ki kai dao mai, boroi 'ana na 'isilana ru ki tafau nao 'ua. ");
INSERT INTO far_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Na mae fere ki kera kai fualida kwailiu, ma na 'initoe ki kai fualida kwailiu. Ma na uni fioloe ma anuanu ki kai liu ana kula ki tafau. ");
INSERT INTO far_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma ru nai ki kera ne safalilana nonifie, nia 'e dia keni fafuta be nia safali ka fii wele. ");
INSERT INTO far_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ana kada nai laugo, wane ana mae fere 'e'ete kwailiu ki laona molagali, kera kai malimae amulu, sulia kamulu na wane nau ki. Ma tani wane ada kai dau kamulu, ma kai kwate kamulu fuana malimae kamulu ki fuana kwaelamulu ma fuana saungilamulu. ");
INSERT INTO far_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ma wane 'oro ne kera famamana nau, nao kera si dau ngasi ana famamanae kera ki. Ma wane ki kai malimae ana kera kwailiu. Ma kera kai kwatea wane God ki fuana malimae kera ki. ");
INSERT INTO far_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ma kada nai, profet suke 'oro ki kai dao mai, ma kai talaia, ma kai sukea wane 'oro ki, ma kera kai leka sulia na famanatae garo kera ki. ");
INSERT INTO far_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ma kera kai sasia ru garo 'oro ki. Ma sulia ru ne, kwaimanie wane 'oro ki kai ngwatautau. ");
INSERT INTO far_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sui boroi 'ana ka 'urinai, dia sa ti ne nia ngangata fuana lekalae sulia God leka ka dao suilana kada nai, nia ne God kai famauria. ");
INSERT INTO far_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma Farongoe Lea ne sulia 'Initoe God, kera kai 'ainitalo ana laona molagali fuana wane ki tafau. Suifatai, suilana molagali fi dao mai. ");
INSERT INTO far_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ma mulu kai ada to'ona na Ru Sua kai tatae mai ana kula abu. Na ru ta'a nai kai fasua na Beu Abu God, ma God kai fasia. Aia, ru ne profet Daniel eta fata na mai sulia 'i nao.” (Na faoraie fuana wane ne nia ididu nia 'uri: 'Oe malingainia lea ana na fadalana ru ne.) ");
INSERT INTO far_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Kada mulu ada to'ona ru nai ki kera dao mai, na wane ne kera to ana lofaa 'i Jiudea, kera kai tafi 'uria gwauna fa uo ki. ");
INSERT INTO far_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ana kada nai, dia ta wane ka to mai 'i maa ana lume nia, nia ka tafi 'ali'ali, ma nao nia si manata lau 'uria rulae laona lume nia 'uria ngalilana ta ru 'ana. ");
INSERT INTO far_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma sa ti ne nia to mai laona oole, nao nia si oli lau 'i lume 'uria ta maku 'ana. ");
INSERT INTO far_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ma ana fa dangi nai ki, nia kai ta'a fuana keni ki ne kera iana, sulia ne nia 'afitai fuada ne kera ka tafi, ma ka ta'a laugo fuana 'afe ki ne kera too ana na wele tu'u ki. ");
INSERT INTO far_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Iu, mulu kai foa ma mulu ka gania God, fua ru ne nao si fuli lau kada ana uni gwarie, naoma ana Sabat. ");
INSERT INTO far_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Sulia nonifilae ana fa dangi nai ki, nia kai ta'a ka liufia nonifilae ne wane laona molagali ki kera saitamana, safali 'ua mai ana safalilana kada God nia saungainia molagali ka dao ana kada ne. Ma nao ta ru 'urinai kai fuli mai burina. ");
INSERT INTO far_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ma dia God nao si fakokorua kada ana nonifilae, nia 'afitai fua ta wane kai mauri. Ma nia 'e fakokorua kada nai fuana lealana wane ne nia filida ki. ");
INSERT INTO far_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Iu, dia ta wane 'e fata 'uri fua mulu, ‘Ada to'ona basi, nia na ne na Christ,’ naoma ka fata 'uri, ‘Ada to'ona basi, nia na 'i seloko,’ nao mulu si famamana nia. ");
INSERT INTO far_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Sulia wane susuke ki kai dao mai, ma kera kai fata 'uri, ‘Nau ne na Christ,’ fainia na wane susuke ki kera kai fata 'uri, ‘Nau na profet.’ Ma kera kai sasia fanadae baita ki fua ka talaia garo ana wane ne God nia filida ki boroi ma nia 'afitai 'asiana fuada. ");
INSERT INTO far_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nia ne, sui boroi 'ana ru ne ki kera nao si dao mai 'ua, nau ku saea na fua mulu 'i nao, fua mulu ka saitamana. ");
INSERT INTO far_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","27","“Ana kada nau, na Wele nia Wane, nau ku oli mai, wane ki tafau kera kai ada to'oku. Dia laugo ne mulu saitamana adalae to'ona meamea kada nia mea mai ana bali taelana sato leka ka dao mai bali sulana sato laona mamanga. Aia, dia tani wane kera fata 'uri fua mulu, ‘Na Christ to laona lofaa 'eke'eke,’ nao mulu si leka 'uria kula nai. Dia tani wane kera fata 'uri fua mulu, ‘Na Christ kai agwa 'i seki,’ nao mulu si famamana fatae 'urinai ki. ");
INSERT INTO far_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“Na olilaku mai nao ta wane si talafia, ka dia laugo ne na gwaubalano nao si talafia ta ru mae. ");
INSERT INTO far_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“'I buri'ana kada ne nonifilae nai ki ka sui, ‘God kai susia na sato, ma na madame, ma nao keroa si tala. Ma God kai kwate na bubulu ki kera kai 'asida mai fasia mamanga. Ma God kai sasia na ru 'i langi ki, kera kai leka garo fasia fulida.’ ");
INSERT INTO far_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Burina ru ne ki, na maetoto ana olilaku mai fi fatai mai laona mamanga. Ma ana kada nai go, na wane ki tafau laona molagali, kera kai angi sulia kera kai ada to'ona ne nau, na Wele nia Wane, ku oli mai fafona gwa salo laona mamanga, ma nau kai leka mai fainia nikilalae nau ma na ngwasinasinae baita nau. ");
INSERT INTO far_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ma na 'ainsel kai ufia na bungu ka angi baita fua okulana wane nau ki tafau ne nau ku filida na. Ana kada nai, nau ku kwatea mai 'ainsel nau ki, fua kera okua mai wane nau ki fasia fere ki tafau laona molagali.” ");
INSERT INTO far_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sui, sa Jesus ka fata sulia tarifulae ka 'uri, “Mulu manata basi sulia 'ai figi ki. Kada mulu ada to'ona na ulina nia ngosa, mulu saitamana na ne kada fuana uni 'ako'akoe nia dao karangi na. ");
INSERT INTO far_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ka 'urinai laugo, kada mulu ada to'ona nonifilae nai ki tafau kera fuli mai, mulu kai saitamana ne olilaku mai nia karangi na. ");
INSERT INTO far_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ru mamana ne nau ku saea fua mulu, wane ki tafau ne kera mauri ana kada ne, kera nao si mae 'i naona ru nai ki ne kai dao mai. ");
INSERT INTO far_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Na ru ki tafau mai 'i langi ma laona molagali kera kai sui. Boroi ma na fatalaku go ne toto nao si sui. ");
INSERT INTO far_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nao ta wane si saitamana kada ne nau kai oli mai ana. Na 'ainsel ki boroi nao si saitamana laugo, ma nau, na Wele boroi, nau nao si saitamana laugo ana. God na Maa taifilia go ne nia saitamana. ");
INSERT INTO far_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Na olilaku mai kai dia ru be fuli ana kada sa Noa. ");
INSERT INTO far_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ana fa dangi be 'i nao ki, ana na igwa baita be, na wane ki kera fanga ma kera ka ku 'ada, ma na wane ki ma keni ki kera ka arai ma ka 'afe 'ada, ma kera ka kwate keni 'ada kwailiu, leka ka dao go ana fa dangi be sa Noa nia ra laona faka baita be. ");
INSERT INTO far_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Boroi 'ana, kera ulafusia 'ua na te ne kai dao mai, leka ka dao ana kada ne igwa baita be dao mai, ma ka lauda na. Ma nia kai dao laugo mai 'uri ana kada ne nau kai dao mai ana. ");
INSERT INTO far_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ana kada nai, ro wane ki keroa kai rao laona oole. Te wane God kai ngalia, ma te wane kai ore. ");
INSERT INTO far_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ma ro keni ki keroa sasi fanga oku. Te keni God kai ngalia, ma te keni kai ore. ");
INSERT INTO far_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mulu kai adaada lea, sulia mulu ulafusia fa dangi te ne nau, na 'Aofia kamulu, kai dao mai ana. ");
INSERT INTO far_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mulu ka manata to'ona ru ne, dia na wane ana lume 'e saitamana ga ana kada ne wane beli kai dao mai ana, nia ka adaada lea ma nao si alamatainia ta wane beli ka ru mai laona lume nia. ");
INSERT INTO far_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nia ne, mulu kai kwaimakwali laugo, sulia nau kai dao mai ana kada ne mulu fia nao nau si dao mai ana.” ");
INSERT INTO far_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ma sa Jesus ka fata lau 'uri fuana fafurongo ki, “Sa ti ne dia na wane rao ne nia saitamarue ma ka rao 'o'olo? Nia ne na wane baita kai alua ka ada sulia wane rao ki, ma ka kwatea fanga fuada ana kada fuana kwate fangalae. ");
INSERT INTO far_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ma 'oilakie fuana wane rao nai ne wane baita nia dao to'ona ma nia sasia ru nai ki, ana kada ne nia dao mai ana lume nia! ");
INSERT INTO far_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nau ku saea na ru mamana fua mulu, na wane baita kai alu nia ka ada sulia ru nia ki tafau. ");
INSERT INTO far_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Boroi ma, dia nia na wane rao ta'a, nia ka manata 'uri, ‘Na wane baita nau, daolana mai nia tau 'ua.’ ");
INSERT INTO far_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ma nia ka safali fuana kwaelana wane rao ki, ma nia ka to ni fanga na 'ana ma ka kufia ru bubulo ki na ana fainia wane ku bubulo ki. ");
INSERT INTO far_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Sui ma na wane baita kai dao mai ana ta maedangi ne nia nao si kwaimakwali, ma ana kada ne nia ulafusia ga 'ana. ");
INSERT INTO far_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Na wane baita kai kwatea na kwaekwaee baita fuana, ma ka alu nia fainia wane kwalabasa ki ne suke ana rolae sulia God. Ma kada nia to ana kula nai, nia kai angi ga 'ana fainia na 'ala girigiri ana lifona, sulia nia nonifi 'asiana.” ");
INSERT INTO far_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ma sa Jesus ka fata lau 'uri, “Ana kada ne nau ku oli lau mai, na 'Initoe God kai dia na akwala keni sari ne kera ngalia na fa kwesu kera ki, ma kera ka kwaimakwali ana na arai falu ne kai leka mai ka ngalida 'uria laona fafanga ana araie. ");
INSERT INTO far_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ma ta lima keni sari ada kera oewanea, ma ta lima ai ada kera ka lioto. ");
INSERT INTO far_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Na keni sari oewanea nai ki kera ngalia na fa kwesu kera ki, boroi ma kera nao si ngali go faida ta 'oele ne ka bobola fuana fasarulana fa kwesu kera ki. ");
INSERT INTO far_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ma lima keni lioto nai ki kera ngalia 'oele fuana fasarulana kwesu fainia na fa kwesu kera ki. ");
INSERT INTO far_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ma kada arai falu nai nao si dao 'ali'ali, ma keni sari nai ki maada ka maleua tafau, ma kera ka maleu na 'ada. ");
INSERT INTO far_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ma laona tofungana rodo, wane ki kera akwa ka 'uri, ‘Na arai falu nia dao na mai! Mulu leka mai fua mulu ada to'ona.’ ");
INSERT INTO far_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Na akwala keni sari nai kera ka tatae, ma kera ka fasarua na fa kwesu kera ki. ");
INSERT INTO far_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ma na keni sari oewanea nai ki kera ka fata 'uri fuana keni sari lioto nai ki, ‘Mulu 'e kwatea ta 'oele fuana sarulae amalu, sulia ne 'oele kalu ki fuana sarulae karangi ka suina.’ ");
INSERT INTO far_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ma kera olisida kera ka 'uri, ‘Nao go, sulia nao nia si bobola na fai kulu tafau. Mulu leka 'amulu ana ta lume, fua mulu ka folia ta 'oele fuana sarulae 'amulu.’ ");
INSERT INTO far_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ma kada kera leka fuana folilae, na arai falu nai ka dao na mai. Ma na sari nai ki ne kera sasi akau, kera ka leka na 'ada fainia 'uria na fafanga ana araie. Ma kera ka bilaki na 'usia na mae. ");
INSERT INTO far_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ma 'i burina na keni sari oewanea be ki, ka dao laugo mai, kera ka 'uri, ‘Wane baita 'ae! 'Oe 'ifingia kau na mae fua malu!’ ");
INSERT INTO far_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ma na arai falu nai 'e olisida ka 'uri, ‘Ru mamana nau ku saea fua mulu, nau ku ulafusi kamulu.’” ");
INSERT INTO far_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ma sa Jesus ka fasuia na tarifulae ne ka 'uri, “Nia ne, mulu kai adaada lea, sulia mulu ulafusia fa dangi naoma kada ne nau kai dao lau mai ana.” ");
INSERT INTO far_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Sui sa Jesus ka saea lau na tarifulae ne fuana fafurongo nia ki ka 'uri, “Ana kada nau kai oli mai, na 'Initoe God nia dia ta wane baita ne nia leka ana ta kula tau, ma ka saea na wane rao nia ki, ma ka kwatea kera ka ada sulia na toorue nia ki. ");
INSERT INTO far_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ma nia ka kwatea lima to'oni seleni ki fuana te wane. Ma fuana ta wane lau, nia ka kwatea ro to'oni seleni ki. Ma fuana ta wane lau, nia ka kwatea te to'oni seleni. Nia ka kwatea ka bobola na fainia na liotoe kera ki. Sui nia ka leka na 'ana ana lekalae nia. ");
INSERT INTO far_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma na wane ne ngalia na lima to'oni seleni, nia ka rao ana, ma ka to lau ana ta lima to'oni seleni. ");
INSERT INTO far_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ma na wane be ngalia na ro to'oni seleni ki, nia ka rao laugo ana, ma ka toda lau ta ro to'oni seleni. ");
INSERT INTO far_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Boroi ma na wane be ngalia te to'oni seleni, nia 'e leka, ma ka 'elia te kilu laona ano, ma ka safungainia 'ana seleni be na wane baita nia kwatea fuana. ");
INSERT INTO far_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ma burina ka kada tau, na wane baita be kera 'e oli mai, ma ka doria saitamana seleni be nia faida ki. ");
INSERT INTO far_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ma na wane be ngalia lima to'oni seleni ki, ka ngalia lau mai ta lima to'oni seleni, ma ka fata 'uri, ‘Wane baita 'ae, 'oe kwatea lima to'oni seleni ki fuaku be. 'Oe ada to'ona basi, nau ku toda lau ta lima to'oni seleni fafia.’ ");
INSERT INTO far_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ma na wane baita nia ka olisia ka 'uri, ‘'Oe wane ni rao lea nau. Nau ku saitamana, nau ku famamana 'oe! 'Oe rao lea ana ru tu'u ki, nia ne nau ku alu 'oe, 'oko baita fafia na ru 'oro ki. 'Oe leka mai, ma 'oko eele 'amu fai nau.’ ");
INSERT INTO far_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ma na wane ne ngalia ro to'oni seleni ki ka dao laugo mai. Ma ka fata 'uri, ‘Wane baita 'ae, 'oe kwatea go ro to'oni seleni ki fuaku be. 'Oe ada to'ona basi, nau ku toda lau ta ro to'oni seleni fafia.’ ");
INSERT INTO far_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ma na wane baita nia ka olisia ka 'uri, ‘'Oe wane ni rao lea nau, nau ku saitamana nau ku famamana 'oe! 'Oe rao lea ana ru tu'u ki. Nia ne nau kai alu 'oe, 'oko baita fafia na ru 'oro ki. 'Oe leka mai, ma 'oko eele 'amu fai nau.’ ");
INSERT INTO far_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Sui na wane be ngalia te to'oni seleni, ka dao mai. Ma nia ka fofone ru ga 'ana ka fata 'uri, ‘Wane baita 'ae, nau ku saitamana 'oe na wane ne fatamaudi. 'Oe saitamana ngeda ru ga 'amu ana kula ne nao 'oe si fasi ru ana. ");
INSERT INTO far_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nia ne nau 'e mau, ma nau ku leka safungainia seleni be 'oe laona ano. 'Oe ada to'ona malefo be 'oe go ne.’ ");
INSERT INTO far_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ma na wane baita nia ka olisia ka 'uri, ‘'Oe na wane rao ta'a, ma 'oe noni'ela 'asiana! 'Oe saitamana ga 'amu ne nau ku ngeda ru ana kula ne nau nao si fasi ru ana. ");
INSERT INTO far_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Dia 'oe manata 'urinai, 'uta ne nao 'oe si alua 'amu na seleni nau ki laona kula ni totodae, ma ka dao ana kada nau ku oli mai ana, nau ku ngalia na seleni nai ma na seleni tarenga ki fainia.’ ");
INSERT INTO far_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“Sui na wane baita nai ka fata 'uri fuana wane ni rao nia ki lau, ‘Mulu ngalia na seleni ne ki fasia, ma mulu ka kwatea fuana wane ne too ana te akwala to'oni seleni. ");
INSERT INTO far_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Sulia na wane ki tafau ne kera too ana ru 'oro ki, nau kai kwatea lau tani ru fuada, fua kera ka too ana ru ki ka takwala. Ma sa ti boroi 'ana nia too ana ta ru tu'u, nau kai lafua fasi nia. ");
INSERT INTO far_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma na wane ni rao ne, mulu kai 'ui 'ania 'i maa laona maerodo, kula ne wane ki kai angi ga 'ada fainia 'ala girigiri ana lifoda, sulia nia nonifi 'asiana.’” ");
INSERT INTO far_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Sa Jesus ka fata lau 'uri fuana fafurongo nia ki, “Kada nau, na Wele nia Wane, nau kai oli lau mai 'uria na kingi fainia na 'ainsel ki, nau kai gouru ana kula ni gourue na kingi. ");
INSERT INTO far_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ma na wane ki fasia fere ki tafau kera kai oku mai siaku. Ma nau kai tolingia na wane ki tafau, dia ta wane be nia ada sulia na sipsip ki ka tolingia na sipsip ki fasia na nanigot ki. ");
INSERT INTO far_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ma nau kai alua na wane 'o'olo ki 'i bali 'o'olo aku, ma na wane ta'a ki 'i bali mauli aku. ");
INSERT INTO far_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Sui nau ku fata 'uri fuana wane ne kera gouru 'i bali 'o'olo aku, ‘Kamulu na wane ne Maa nau faeele kamulu ki. Mulu kai ru mai laona 'initoe ne nia sasi akau ana fua mulu safali na mai ana safalilana na molagali. ");
INSERT INTO far_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Sulia kada nau ku fiolo ana, kamulu kwatea fanga fuaku. Ma kada nau ku maeliku ana, mulu kwatea kafo fuaku. Ma boroi 'ana nau na wane dao fasia ta fere 'e'ete, kamulu eresi nau 'uria laona lume kamulu ki. ");
INSERT INTO far_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ma kada nao 'aku ta maku, mulu kwate maku fuaku. Ma kada nau ku matai, mulu ada sulia nau. Ma kada nau ku to 'i laona beu ni kanie, mulu maa to'oku.’ ");
INSERT INTO far_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Sui na wane 'o'olo ki kera ka olisia kera ka 'uri, ‘'Aofia 'ae, kada te ne kalu ada to'ona 'oe fiolo, ma kalu ka kwate fanga fuamu? Kada te ne 'oe maeliku, ma kalu ka kwatea kafo fuamu? ");
INSERT INTO far_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ma kada te ne 'oe na wane dao fasia na fere 'e'ete, ma kalu ka eresi 'oe 'i lume, naoma kada te ne nao 'amu ta maku, ma kalu ka kwate maku 'amu? ");
INSERT INTO far_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ma kada te ne kalu ada to'ona ne 'oe matai ana, naoma 'oe to laona beu ni kanie, ma kalu ka leka maa to'omu?’ ");
INSERT INTO far_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ma nau ku olisida nau ku 'uri, ‘Ru mamana nau ku saea fua mulu, kada mulu sasia ta ru 'urinai fuana ta wane boroi 'ana ne kera nao si ada baita ana, mulu sasia na fuaku.’ ");
INSERT INTO far_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Sui nau kai fata 'uri fuada na wane ne kera to 'i bali mauli aku, ‘Mulu leka tau kau fasi nau. God kai kwae kamulu. Ma mulu leka laona ere ne toto firi, ne God nia sasi akau fuana sa Saetan ma na 'ainsel ta'a nia ki. ");
INSERT INTO far_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sulia nau ku fiolo, ma mulu si kwatea go ta fanga fuaku. Ma kada nau ku maeliku, nao mulu si kwatea go ta kafo fuaku. ");
INSERT INTO far_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ma kada nau ku dao mai, mulu si eresi nau go 'uria lume kamulu ki. Ma kada nao 'aku ta maku, nao mulu si kwate maku ga 'aku. Ma kada nau ku matai ma ku to 'i laona beu ni kanie, nao mulu si ada go suli nau.’ ");
INSERT INTO far_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ma kera ka olisia kera ka 'uri, ‘'Aofia 'ae, kada te ne kalu suamu, 'oe fiolo, naoma 'oe maeliku, naoma 'oe na wane dao, naoma ka nao 'amu ta maku, naoma 'oe matai naoma 'oe to 'i laona beu ni kanie, ma nao kalu si 'adomi 'oe go?’ ");
INSERT INTO far_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ma nau ku olisida ku 'uri, ‘Ru mamana nau ku saea fua mulu, kada kamulu si kwai'adomi ana ta wane boroi ana ne kera nao si ada baita ana, mulu sasia na fuaku.’ ");
INSERT INTO far_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Sui kera ka leka na 'ada 'uria kwaekwaee ne toto firi, ma wane 'o'olo ki kera ka leka na 'uria na maurie firi.” ");
INSERT INTO far_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kada sa Jesus nia famanata ana ru ne ki ka sui, nia ka fata 'uri fuana fafurongo nia ki, ");
INSERT INTO far_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mulu saitamana suina, Fafanga ana Daofa Liue kai fuli fafone. Ma ana kada nai, kera kai kwate nau, na Wele nia Wane, fuana malimae nau ki, fua kera kai foto'i nau ana 'airarafolo.” ");
INSERT INTO far_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ma ana te kada nai go ana, na fataabu baita ki, ma na fanaonao Jiu ki, kera oku laona lume baita na 'inita fataabu ne satana sa Kaeafas. ");
INSERT INTO far_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ma kera ka lokoeru fua kera ka dao to'ona ta kada fua kera ka dau agwa ana sa Jesus, ma kera ka saungia. ");
INSERT INTO far_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ma kera ka fata kwailiu 'uri, “Nao kulu si daua ana fa dangi ana fafanga, fasia tooa ki kera ka fuali kulu.” ");
INSERT INTO far_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma sa Jesus fainia fafurongo nia ki, kera leka 'uria 'i Betani, kera ka to laona lume sa Simon, na wane ne kuu nia saungia 'i nao. ");
INSERT INTO far_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Ana kada sa Jesus 'e fanga, te keni leka mai siana fainia na bi ngwaingwai ne kwanga 'asiana, ma ka fungu ana na ngwaingwai ne moko lea, ma na folilana ka baita 'asiana. Nia leka mai, ma ka 'igitainia ana gwauna sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ma ana kada ne fafurongo nia ki kera ada to'ona, kera ka guisasu, ma kera ka fata 'ada talada 'uri, “'Uta ne keni ne ka falia ngwaingwai lea ne? ");
INSERT INTO far_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ngwaingwai ne, dia kulu foli ana, malefo baita ne kulu kai ngalia. Ma kulu ka ngalia na malefo nai fuana 'afilana wane siofa ki!” ");
INSERT INTO far_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ma sulia sa Jesus saitamana ga 'ana te ne kera fata sulia, nia ka fata 'uri fuada, “Nao kamulu si fata falia lau. Ru lea 'asiana ne nia sasia fuaku. ");
INSERT INTO far_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Na wane siofa ki kera to tari ga 'ada fai kamulu. Boroi ma nau nao si to tau go fai kamulu. ");
INSERT INTO far_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma ana kada na keni ne nia 'igitainia na ngwaingwai ne ana noniku, nia sasi akau aku makwalia faitolilae laona kilu gwau ana fa dangi ana maelaku. ");
INSERT INTO far_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ma nau ku saea fua mulu, ana kula ki tafau laona molagali ne kera kai fata sulia na Farongoe Lea ne, kera kai fata laugo sulia ru ne nia sasia aku fuana manatalae to'ona.” ");
INSERT INTO far_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Burina ru ne ki sui, te wane ana akwala ma ro fafurongo sa Jesus ki, satana sa Jiudas Iskariot ka leka siana na fataabu baita ki. ");
INSERT INTO far_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ma ka ledi 'uri ada, “Dia nau ku kwatea sa Jesus fua mulu, te ne mulu kai kwate fuaku?” Ma kera ka tomainia olu akwala seleni ki, ma kera ka kwatea fuana. ");
INSERT INTO far_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Safali ana kada nai, sa Jiudas ka ada na 'uria ta kada lea fuana kwatelana sa Jesus fuada. ");
INSERT INTO far_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ma ana etana fa dangi ana fafanga ne kera saea ana, “Beret ne nao ta isi ana”, na fafurongo ki kera leka mai siana sa Jesus, ma kera ka ledi 'uri ana, “'I fai ne 'oe dori kalu ka sasi akau ana Fafanga ana Daofa Liue fuamu?” ");
INSERT INTO far_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ma sa Jesus ka fata 'uri fuada, “Mulu kai leka kau 'uria 'i Jerusalem. Ana kada kamulu dao siana te wane ne nau ku filia, mulu ka fata 'uri fuana, ‘Na Wane Famanata kalu, nia saea kada nia dao karangi na. Nia fainia na fafurongo nia ki kera kai 'ania na Fafanga ana Daofa Liue 'i lume 'oe.’” ");
INSERT INTO far_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ana kada ne, fafurongo ki kera leka, ma kera ka fata fainia na wane nai dia be sa Jesus saea na fuada, ma kera ka sasi akau na ana fanga 'i senai. ");
INSERT INTO far_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ma nia saulafi na, sa Jesus ka to senai fua ka fanga fainia na akwala ma ro fafurongo nia ki. ");
INSERT INTO far_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma kada kera fanga na, sa Jesus ka fata 'uri fuada, “Ru mamana nau ku saea fua mulu, te wane amulu kai kwate nau fuana malimae nau ki.” ");
INSERT INTO far_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Kada fafurongo ki kera rongoa ru nai, kera ka kwaimanatai 'asiana. Ma te te wanea ada fi safali ana ledilana sa Jesus 'uri, “'Aofia 'ae, 'uri ma 'oe fata suli nau nai?” ");
INSERT INTO far_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sui sa Jesus ka 'uri, “Te wane amulu, ne taufia lifu beret nia 'i laona tiu fai nau, nia ne kai kwate nau fuana malimae nau ki. ");
INSERT INTO far_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nau, na Wele nia Wane, nau kai mae dia na Kekedee Abu ki be fata suli nau. 'Urinai boroi ana kwaimanatai 'asiana fuana wane ne kai kwate nau fuana malimae nau ki. Nia lea fuana wane nai dia nia nao si futa go.” ");
INSERT INTO far_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ana kada nai, sa Jiudas, wane ne kai kwatea sa Jesus fuana malimae nia ki, nia ka fata 'uri, “Wane Famanata 'ae. 'Uri ma 'oe fata suli nau nai?” Ma sa Jesus ka fata 'uri fuana, “'Oe talamu na ne saea.” ");
INSERT INTO far_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ma ana kada kera fanga, sa Jesus ka ngalia fa beret, ma nia ka tangoa God, sui ka ngiia, ma ka kwatea fua fafurongo nia ki, ma ka fata 'uri, “Mulu ngalia, ma mulu ka 'ania. Nia na ne noniku.” ");
INSERT INTO far_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Sui nia ka ngalia na titiu, ma ka tangoa God, sui ka kwatea fuada, ma ka fata 'uri, “Kamulu tafau, mulu kufia. ");
INSERT INTO far_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nia na ne 'abuku ne God fangasia na alangaie falu, sulia ne 'abuku kai igwa fuana wane 'oro ki, fua God ka manatalugea na ta'alae ki. ");
INSERT INTO far_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ru mamana nau ku saea fua mulu, nau nao si kufia lau na waeni ne leka ka dao ana fa dangi nau kai kufia na waeni falu fai kamulu 'i laona 'Initoe Maa nau.” ");
INSERT INTO far_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sui kera ka ngufia fa ngu, ma kera ka leka 'uria fa uo ne kera saea ana Olif. ");
INSERT INTO far_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ma sa Jesus ka fata 'uri fuada, “Ana fa rodo ne, kamulu tafau go mulu kai tafi fasi nau. Sulia na Kekedee Abu be fata 'uri, ‘God kai saungia wane ne nia ada sulia na sipsip ki, ma sipsip ki kai takalo tafau.’ ");
INSERT INTO far_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ka 'urinai boroi ana, 'i burina nau ku tatae lau 'uria maurie, nau kai eteta 'i nao amulu 'uria 'i Galili.” ");
INSERT INTO far_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ma sa Pita ka olisia ka 'uri, “Nia 'afitai 'asiana ne nau ku leka fasi 'oe, sui boroi 'ana wane ne ki kera ka leka fasi 'oe!” ");
INSERT INTO far_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ma sa Jesus ka fata 'uri fuana sa Pita, “Nau saea fuamu, 'i naona ne karai kai angi 'i laona fa rodo ta'ena, 'oe kai sae olu ru ana ne 'oe ulafusi nau.” ");
INSERT INTO far_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ma sa Pita ka olisia ka 'uri, “Sui boroi 'ana nau kai mae fai 'oe, nia 'afitai nau ku saea ne nau ku ulafusi 'oe!” Ma na fafurongo ki tafau go, kera saea laugo te ru nai. ");
INSERT INTO far_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Sui sa Jesus ka leka fainia na fafurongo nia ki ana te kula kera saea ana 'i Getsemani, ma nia ka fata 'uri fuada, “Kamulu to 'amulu 'i seki kada nau ku leka 'i seloko fua nau ku foa.” ");
INSERT INTO far_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ma nia ka talaia sa Pita, ma na ro wele sa Sebedi ki fainia. Ma nia fi etangia kwaimanatailae baita ma liodilae. ");
INSERT INTO far_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ma nia ka fata 'uri fuada, “Na lioku nia kwaimanatai 'asiana, ma nia bobola na fua saungilaku. Mulu to 'i seki, kamulu ka ada, ma mulu ka adaada fai nau.” ");
INSERT INTO far_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Sui nia ka 'idu tu'u lau fasi kera, ma ka tio fafia maana 'i ano, ma ka foa ka 'uri, “Maasi 'ae, dia nia ngwaluda ga 'ana, 'oe lafua 'amu na nonifilae ne fasi nau. Sui boroi 'ana, nao lau na kwaidorie nau, boroi ma kwaidorie 'oe lalau.” ");
INSERT INTO far_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Sui sa Jesus ka oli siana olu fafurongo be nia ki, ma ka ada to'ona kera maleu na, ma nia ka fata 'uri fuana sa Pita, “Pita 'ae, 'uta ne mulu si ada fai nau sulia ta te kada? ");
INSERT INTO far_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Kamulu kai ada, mulu kai adaada ana folae fasia na ilitoe ka liufi kamulu. Sulia kamulu doria sasilana ru lea ki, boroi ma noni mulu nia ngwatautau 'asiana.” ");
INSERT INTO far_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Sa Jesus ka leka lau, ma ka foa ana ruana kada ka 'uri, “Maasi 'ae, dia nao si bobola fua 'oko susia na nonifilae ne fasi nau, lea ga 'ana, nau ku ro na 'aku sulia na kwaidorie 'oe.” ");
INSERT INTO far_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ma kada nia oli mai siana fafurongo nia ki, nia ada to'ona ne kera maleu lau, sulia maada 'e maleua 'asiana. ");
INSERT INTO far_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ma sa Jesus ka leka lau fasida, ma ka foa lau ana oluna kada, ka saea laugo na fatae be ki. ");
INSERT INTO far_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Sui nia ka leka lau siana olu fafurongo be nia ki, ma ka fata 'uri fuada, “Kamulu maleu 'ua ne? Ma mulu ka mamalo 'ua ne? Ada basi, kera kai kwate nau na, na Wele nia Wane, laona 'abana wane ta'a ki. Na kada be nia dao na mai! ");
INSERT INTO far_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Mulu tatae, kulu ka leka na. Ada basi, na wane be nia kwate nau fuana malimae nau ki, nia dao na mai.” ");
INSERT INTO far_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ma ana kada sa Jesus 'e fata ga 'ana 'ua, sa Jiudas, te wane ana akwala ma ro fafurongo be nia ki, 'e dao na mai. Te fikue baita ne leka mai fainia, fasia fataabu baita ki, ma fanaonao ki. Ma kera ngalia mai na naife ni sauwanee ki, fainia subi ki. ");
INSERT INTO far_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aia, sa Jiudas kwatea suina maetoto fuada ka 'uri, “Na wane ne nau ku nono'ia, nia na ne wane ne mulu doria.” ");
INSERT INTO far_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ma 'ali'ali nia ka leka 'o'olo na siana sa Jesus ma ka fata 'uri, “Wane Famanata 'ae, aroaroe to fai 'oe.” Sui nia ka nono'ia. ");
INSERT INTO far_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ma sa Jesus ka fata 'uri fuana, “Wane nau, sasia na ru ne 'ali'ali.” Sui kera ka 'idu karangi mai ana, ma kera ka daua sa Jesus, ma kera ka dau ngasi na fafia. ");
INSERT INTO far_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ma te wane ana fafurongo sa Jesus ki 'e lafua na naife ni sauwanee nia, ma ka kwaea na wane rao na 'inita fataabu, ma ka kwae musia na bali alinga 'o'olo nia. ");
INSERT INTO far_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ma sa Jesus ka fata 'uri fuana, “'Oe alua 'amu na naife 'oe fulina, sulia sa tifaida ne kera firu ana naife, kera kai mae laugo ana naife. ");
INSERT INTO far_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nau ku doria 'oko saitamana, dia nau ku gania Maa nau, nia fi kwatea mai molee 'ainsel! ");
INSERT INTO far_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ma dia nau ku saea na 'ainsel ki ka 'adomi nau 'urinai, nao nau si famamana ru ne na Kekedee Abu fata sulia na Christ kai nonifi ana ki.” ");
INSERT INTO far_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Sui sa Jesus ka fata 'uri fuana wane ki, “'Uri ma, kamulu kwaisae nau ta wane beli ne? Nia ne mulu ka dao mai fainia naife ki, ma na subi ki fua daulaku? Tau na mai, nau ku famanata kamulu 'i laona Beu Abu God, boroi ma mulu si dau nau go. ");
INSERT INTO far_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Na ru ne ki tafau ka fuli 'urinai fua ka famamana kekedee na profet ki ana Kekedee Abu.” Sui na fafurongo nia ki tafau kera ka luka faburi na ana, ma kera ka tafi na 'ada. ");
INSERT INTO far_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ma wane ne kera daua sa Jesus ki, kera talai nia 'uria laona lume sa Kaeafas, na 'inita fataabu. Ma wane famanata ana taki ki, fainia wane fanaonao ki laugo, kera oku senai. ");
INSERT INTO far_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma sa Pita nia 'isi tau na mai 'i buri, ma ka dao laugo 'i laona labate ana lume 'inita fataabu, ka ru kau laona labate, ma ka gouru fainia wane ni folo ki, fua sae nia ka ada to'ona te ne kera kai sasia ana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma na fataabu baita ki, fainia na fikute wane lokoeru, kera sasi 'uria daolae to'ona tani fatae sukee sulia sa Jesus ne bobola fuana kera ka saungi nia fafia. ");
INSERT INTO far_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sui boroi 'ana wane 'oro fata sukee ki kera leka laugo mai, kera nao si dao go to'ona ta ru. Sui 'i buri, ta ro wane sukee keroa tae mai, keroa ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“Na wane ne nia fata 'uri, ‘Nau ku saitamana okosia na Beu Abu God, ma nau ku saungai falu laugo ana laona olu fa dangi ki.’” ");
INSERT INTO far_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Sui na 'inita fataabu ka tatae, ka fata 'uri fuana sa Jesus, “'Uri ma, nao 'oe si olisia go ta ru, ana ru ta'a ne kera saea amu ki?” ");
INSERT INTO far_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Boroi ma, sa Jesus 'e nofo ga 'ana. Ma na 'inita fataabu ka fata lau 'uri, “Nau ku ledi 'oe fua 'oko kwaiagi ana satana God ne mauri, ma 'oe saea fua malu ne 'oe na ne na Christ, na Wele God, naoma 'e nao?” ");
INSERT INTO far_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Sa Jesus ka fata 'uri fuana, “Nia nena 'oe saea na. Ru mamana nau ku saea fua mulu, safali ana kada ne ka oli 'alaa, mulu kai ada to'oku, na Wele nia Wane, nau ku gouru 'i bali 'o'olo ana God ne nikila 'asiana, ma nau ku leka mai 'i fafona gwa salo ki 'i langi.” ");
INSERT INTO far_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Go na 'inita fataabu nai, ka musia na maku gwala nia talana fua ka fatainia na gwuisasue nia, ma ka fata 'uri, “Kulu si doria lau ta wane ni fata famamana! Kulu rongoa tafau na ne nia fabolotania fainia God. ");
INSERT INTO far_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Mulu manata 'uta?” Ma kera olisia ka 'uri, “Nia bobola na fuana nia kai mae.” ");
INSERT INTO far_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Sui kera ka ngisufia maana, ma kera ka kumulia. Ma tani wane kera ka fidalia, kera ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Christ 'ae, dia 'oe na ta profet, 'oe saea mai, sa ti ne fidali 'oe?” ");
INSERT INTO far_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma sa Pita ka gouru laona labate, ma te keni sari rao 'e leka mai siana ka fata 'uri, “'Oe to laugo fainia sa Jesus, na wane ne fasia 'i Galili.” ");
INSERT INTO far_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sui sa Pita ka tofe naofada ka 'uri, “Nau kusi saitamana ru ne 'oe saea.” ");
INSERT INTO far_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Sui, sa Pita leka ka gouru karangi ana mae tafa, ma te keni sari rao lau ka ada to'ona, ma ka fata 'uri fuana wane ne kera gouru senai ki, “Na wane ne to laugo fainia sa Jesus, wane ne fasia 'i Nasaret.” ");
INSERT INTO far_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ma sa Pita ka tofe lau, ma nia kwaiagi ka 'uri, “Nau kusi saitamana na wane na.” ");
INSERT INTO far_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ma nao si tau go 'i burina, na wane ne kera uu senai ki, kera leka siana sa Pita, ma kera ka fata 'uri fuana, “'Oe laugo ta wane ada mamana na, sulia na linge fatalamu ne fatai 'oe.” ");
INSERT INTO far_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Kada nai nia ka kwaiagi lau ka 'uri, “Alu God kai kwatea na kwaekwaee fuaku, dia nau si fata mamana! Nau nao si saitamana na wane nena.” Ma 'urinai go, karai ka angi na. ");
INSERT INTO far_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ma sa Pita nia manata to'ona fatae be sa Jesus saea, “'I naona na karai kai angi laona fa rodo ne ta'ena, 'oe kai saea olu ru ana ne 'oe ulafusia nau.” Kada sa Pita 'e manata to'ona ru nai, nia ka ru kau 'i maa, ma ka angi 'asiana. ");
INSERT INTO far_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ana 'ofodangi makalokalo, na fataabu baita ki tafau fainia na wane fanaonao ki, kera lokoeru na fuana saungilana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Sui kera ka kania, ma kera ka talaia na siana sa Paelat, na wane baita fasia 'i Rom. ");
INSERT INTO far_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ma sa Jiudas, na wane be kwatea sa Jesus fuana malimae nia ki, ana kada nia saitamana kera ketoa na sa Jesus fuana maelana, nia ka manata oli, ma ka oli fainia na olu akwala seleni be ki fuada na fataabu baita ki ma wane fanaonao ki, ma ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nau ku abulo ta'a na, sulia nau ku kwatea na wane 'o'olo fuana saungilana.” Sui kera olisia ka 'uri, “Nao lau 'abero kalu nena. Sulia bali nai bali 'oe lalau na.” ");
INSERT INTO far_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ma sa Jiudas ka 'ui 'ania seleni nai ki laona Beu Abu God, ma ka leka na 'ana. Nia leka kau 'i maa, ma ka lio nia na 'ana talana. ");
INSERT INTO far_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ma na fataabu baita ki, kera ngalia na seleni nai ki, ma kera ka fata 'uri, “Nia nao si bobola ana taki kulu fuana kulu ka alua na seleni ne ki fainia na malefo ana na Beu Abu God, sulia seleni ne, nia na malefo ana sauwanee.” ");
INSERT INTO far_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ma kera fata ka suina, kera ka alafafia ma kera ka folia ana te lifu gano, na gano te wane ni saungai titiu. Ma kera ka talana gano ne ana kula fua alulana wane kwaita ne mae ki ana. ");
INSERT INTO far_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Sulia ne kera folia na gano nai ana malefo ne nia ngalia fuana saungilana wane, kera ka saea gano ne ana, “Gano ana 'abu” leka ka dao go ana 'i ta'ena. ");
INSERT INTO far_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","'Urinai, kera ka famamana fatae na profet Jeremaea be fata 'uri, “Kera ngalia na olu akwala seleni be ki, na malefo be wane Israel ki kera folia ana na wane, ");
INSERT INTO far_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ma kera ka kwatea 'uri folilana na gano na wane ne saungai tiu ki, dia be God nia saea fuaku.” ");
INSERT INTO far_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ma sa Jesus ka uu 'i naona sa Paelat, na wane gwaungai fasia 'i Rom. Ma sa Paelat ka ledia ka 'uri, “'Oe na ne kingi Jiu ki?” Sa Jesus ka olisia ka 'uri, “Nia na nena 'oe saea.” ");
INSERT INTO far_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Kada ne fataabu baita ki, ma na fanaonao ki, kera fai fafia sa Jesus, nao nia si olisida ana ta fatae. ");
INSERT INTO far_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Sui sa Paelat ka fata 'uri fuana, “'Oe si rongoa go ru ta'a 'oro ne kera fai fafi 'oe ana ki?” ");
INSERT INTO far_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ma sa Jesus nao si olisida go ana ta fatae. Nia ne sa Paelat ka kwele 'asiana. ");
INSERT INTO far_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Iu, ana na Fafanga ana Daofa Liue, wane gwaungai fasia 'i Rom, nia 'idufa lugea te wane ne Jiu ki kera doria fasia na beu ni kanie. ");
INSERT INTO far_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma ana kada nai, te wane ne to laugo laona beu ni kanie ne satana sa Barabas, na wane ki tafau kera saitamana. ");
INSERT INTO far_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nia ne, kada wane ki kera oku mai, sa Paelat ka ledida ka 'uri, “Sa ti ne kamulu doria nau lugea fua mulu, sa Barabas, naoma sa Jesus ne kera saea ana na Christ?” ");
INSERT INTO far_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nia ka fata 'urinai, sulia nia saitamana ne wane fanaonao ana Jiu ki, kera kwatea sa Jesus fuana sulia kera kwaifi fuana. ");
INSERT INTO far_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ma kada sa Paelat nia gouru ana kula ni kwaiketoie, na 'afe nia ka kwatea te fatae fuana ka 'uri, “Nao 'oe si sasia ta ru ana na wane 'o'olo nena. Sulia nau ku maleu bolee, ma manataku ka isifufuli 'asiana suli nia laona fa rodo be sui.” ");
INSERT INTO far_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ma na fataabu baita ki, ma na wane fanaonao ki, kera fata alingana wane ki, fua kera ka gania sa Paelat fuana lugelana sa Barabas, ma ka alua sa Jesus fuana maea. ");
INSERT INTO far_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ma sa Paelat ka ledia na fikue nai lau ka 'uri, “Sa ti ana keroa ne mulu doria fua nau ku lugea?” Ma kera olisia kera ka 'uri, “Sa Barabas.” ");
INSERT INTO far_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Sa Paelat ka fata 'uri, “Ma te ne nau kai sasia ana sa Jesus, ne kera saea ana na Christ?” Kera tafau ka fata 'uri, “'Oe foto'ia ana 'airarafolo.” ");
INSERT INTO far_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ma sa Paelat ka fata lau 'uri, “Sulia ta te garoe na ne nia sasia?” Sui kera akwa baita kera ka 'uri, “Foto'ia ana 'airarafolo.” ");
INSERT INTO far_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ma kada sa Paelat ada to'ona nia 'afitai ka sasia na ta ru, ma na firue karangi ka safali, nia ka ngalia kafo, ma ka taufia na 'abana 'i naoda tafau, ka fata 'uri, “Nau nao si doria na maelana wane ne. Bali kamulu na nai.” ");
INSERT INTO far_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Na fikue tafau kera olisia, kera ka 'uri, “Alua maelana kai to fafi kalu, ma fafia na wele kalu ki.” ");
INSERT INTO far_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Aia, sa Paelat ka lugea kau sa Barabas fuada, ma ka kwatea wane ni omee nia ki kera ka namusia sa Jesus. Sui nia ka kwatea fuada fua kera ka foto'ia ana na 'airarafolo. ");
INSERT INTO far_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma na wane ni omee sa Paelat ki, kera talaia sa Jesus laona lume baita sa Paelat, ma na wane ni omee nai ki tafau, kera oku mai kalia sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ma kera ka lugea na maku nia, ma kera ka faofia ana maku meo bobora. ");
INSERT INTO far_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Sui kera ka ngalia na 'eregwau ana 'oko ngangara, ma kera ka duua ana gwauna, ma kera ka kwatea te sara 'ai fua nia ka dau ana 'ana bali 'aba 'o'olo nia, dia ta kingi. Ma kera ka boruru fuana, ma kera ka 'onionga, kera ka 'uri, “Na kingi Jiu ki, 'oe mauri tau amu!” ");
INSERT INTO far_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ma kera ka ngisufia, ma kera ka ngalia na sara 'ai be, ma kera ka kwaea na gwauna. ");
INSERT INTO far_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kada kera 'onionga ka sui, kera lugea lau na maku be, ma kera ka faofia lau ana maku nia ki, sui kera ka talaia kau fua foto'ilana ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ma kada kera leka na kau fasia 'i Jerusalem, kera ka ada to'ona te wane fasia 'i Saerin, ne satana sa Simon. Ma na wane ni omee ki, kera ka sumainia fua nia ngalia na 'airarafolo sa Jesus. ");
INSERT INTO far_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sui kera dao ana kula kera saea ana 'i Golgota (Na fadalana fatae Golgota, “Na kula ana lelete wane”). ");
INSERT INTO far_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","'I senai, kera kwatea na waeni ne kera dolalia fainia 'ai 'afae fua sa Jesus. Ma sa Jesus ka ku to'ona, ma nao nia si kufia go. ");
INSERT INTO far_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sui kera ka foto'ia ana na 'airarafolo, ma kera ka saketo ana na ru dia daisi fuana kera ka tolingia na maku nia ki. ");
INSERT INTO far_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Sui kera ka gouru 'i ano, ma kera ka adaada 'afia ga 'ada. ");
INSERT INTO far_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ma 'i gwauna na 'airarafolo kera alua na kekedee 'uri, “Na wane ne sa Jesus, na kingi Jiu ki.” ");
INSERT INTO far_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Sui, kera ka foto'ida laugo ro wane beli ki fainia ana na 'airarafolo ki, ta wane bali 'o'olo ana, ma ta wane ana bali mauli. ");
INSERT INTO far_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma na wane ne kera liu ki, kera kwaelangai gwauda, ma kera ka fata buri tolingai kau fuana sa Jesus, kera ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“'Oe saea 'oe okosia na Beu Abu God, ma 'oko saungai falu lau ana sulia olu fa dangi ki go. Aia, dia 'oe na Wele God, 'oe famauri 'oe basi talamu, ma 'oko koso mai fasia na 'airarafolo nena.” ");
INSERT INTO far_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ma fataabu baita ki kera 'onionga 'urinai laugo ana, fainia na wane famanata ana taki ki, ma na wane fanaonao ki, kera ka 'uri, ");
INSERT INTO far_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nia be famauria na wane 'e'ete ki, ma nia nao si famauria nia go talana. Dia nia na kingi kia wane Jiu ki, nia koso mai fasia na 'airarafolo, fua kulu ka famamana nia. ");
INSERT INTO far_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nia fito ana God, ma ka fata 'uri, ‘Nau ne na Wele God.’ Kulu adaada basi fua kulu kai ada to'ona ne God kai famauria naoma 'e nao.” ");
INSERT INTO far_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ma na ro wane ta'a ne kera foto'ida fainia ki, kera fata buri tolingai laugo 'urinai ana. ");
INSERT INTO far_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Safali ana tofungana dangi, leka ka dao ana oluna kada sato, na 'afutana bali lofaa ne nia rodoa. ");
INSERT INTO far_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma saulafi, sa Jesus ka akwa baita ka 'uri, “Eli, Eli, lama sabaktani?” Na fadalana ne 'uri, “God nau 'ae, God nau 'ae, 'uta ne 'oe lukasi faburi aku?” ");
INSERT INTO far_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ma tani wane ne to karangi nia, kera rongoa, ma kera ka fata 'uri, “Nia akwa 'uria sa Elaeja.” ");
INSERT INTO far_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ma te wane adalae 'ali'ali ka ngalia mai te lumulumu asi, ma ka kutumainia laona waeni 'afae, ma ka usufia ana mae 'ai, ma ka kwatea fuana fua nia ka kufia. ");
INSERT INTO far_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ma tani wane lau kera ka 'uri, “Mango basi, kulu ada to'ona dia sa Elaeja nia dao mai fuana famaurilana naoma 'e nao.” ");
INSERT INTO far_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Sui, sa Jesus ka akwa baita lau, ma ka mae na. ");
INSERT INTO far_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ma maku baita ne bokota na kula abu laona Beu Abu God 'e kakari ana ro bali ru, safali mai 'i gwauna leka ka dao 'i ano. Ma na anuanu ka liu, ma na fau ki ka foga, ");
INSERT INTO far_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ma tani faoda gwau kera ka 'ifi, ma na wane 'oro ana wane God ki ne kera mae na, kera ka mauri lau. ");
INSERT INTO far_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ma kera ka ru fasia faoda kera ki. Ma burina sa Jesus nia tatae oli laugo, kera ru laona fere abu 'i Jerusalem. Ma na wane 'oro ki kera suada. ");
INSERT INTO far_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ma na wane fanaonao ana wane ni omee ne kera ada sulia sa Jesus, fainia na wane ni omee nia ki, ana kada kera ada to'ona na anuanu, ma na ru 'e'ete ki tafau laugo ne fuli, kera ka mau 'asiana ma kera ka fata 'uri, “Nia mamana 'asiana, nia na Wele God.” ");
INSERT INTO far_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ma tani keni 'oro laugo ne kera leka burina sa Jesus safali mai 'i Galili ma kera 'adomia, kera to laugo senai, ma kera ka adaada tau laugo mai 'ada. ");
INSERT INTO far_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ta ai ada ne ni Mary fasia 'i Magdala, ma ni Mary na gaa sa Jemes ma sa Josef, ma 'afe sa Sebedi, ma tani keni lau. ");
INSERT INTO far_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ana kada nia saulafi na ma karangia nia rodo, te wane todaru nia leka mai. Nia te wane fasia 'i Arimetea, satana ne sa Josef. Ma nia te wane fafurongo sa Jesus laugo. ");
INSERT INTO far_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nia leka siana sa Paelat, ma ka gania nonina sa Jesus. Ma sa Paelat ka saea kera kwatea fuana. ");
INSERT INTO far_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ma sa Josef ka ngalia nonina sa Jesus, ma ka 'afua ana 'aba maku kwao falu. ");
INSERT INTO far_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Sui nia ka alua laona faoda gwau falu nia, ne kera 'elia laona fau baita. Sui nia ka gelusia te aba fau baita, ma ka bokota na maana faoda gwau nai. ");
INSERT INTO far_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ni Mary fasia Magdala, ma ta Mary lau, kera gouru 'i maa na faoda nai. ");
INSERT INTO far_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ma ana fa dangi burina, na Sabat, na fataabu baita ki, ma na Farasi ki, kera oku fuana lokoerue fainia sa Paelat. ");
INSERT INTO far_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ma kera ka fata 'uri fuana, “Wane baita 'ae, kalu manata to'ona kada wane suke ne nia mauri 'ua, nia fata 'uri, ‘Nau kai mauri lau ana oluna maedangi!’ ");
INSERT INTO far_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","'Oe farongoa wane 'oe ki kera leka, kera ka folo 'usia na faoda wane mae leka ka dao ana oluna maedangi. Nao nia si lea ne fafurongo nia ki kera ka ngalia 'ada na nonina, kera ka safungainia, ma kera ka sukea wane ki, saea sa Jesus nia mauri lau. Ma 'oe saitamana dia kera suke 'urinai, nia kai ta'a ka liufia na sukee be nia eta suke mai ana wane ki.” ");
INSERT INTO far_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ma sa Paelat ka 'uri fuada, “Aia, dia 'urinai, kamulu ne mulu filia tani wane ana wane ni omee nau ki, fua kera ka leka folo, ma kera ka folo lea 'usia na faoda nai.” ");
INSERT INTO far_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ma kada fataabu baita ki, ma na Farasi ki kera rongoa ru nai, kera ka sasi akau na, kera ka leka na 'uria na faoda nai. Ma kada kera dao ana faoda nai, kera ka alua na maetoto ana faoda nai, fua dia ta wane ka 'idua boroi na mae ana faoda, kera ka saitamana. Ana kada nai laugo, kera ka alua na wane ni folo ki. ");
INSERT INTO far_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","'I burina na Sabat, kada nia makalokalo 'ua ana Sande 'ofodangi, ni Mary fasia 'i Magdala, ma ta Mary lau, keroa leka 'uria na faoda be fua keroa ka ada to'ona. ");
INSERT INTO far_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ma tona boroi na anuanu baita ka liu, ma te 'ainsel God ka koso mai fasia 'i langi, ma ka gelusia na aba fau be fasia maana na faoda, ma ka gouru 'ana fafona. ");
INSERT INTO far_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Na adalae to'ona dia na meamea ma na maku nia ki ka kwao 'asiana. ");
INSERT INTO far_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ma ana kada ne wane ni folo ki kera ada to'ona, kera mau 'asiana, ma kera 'asida, ma kera ka lelebe, ma kera dia na 'ada na wane mae ki. ");
INSERT INTO far_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ma na 'ainsel nai ka fata 'uri fuadaro, “Nao kamoro si mau. Nau ku saitamana kamoro nani 'uria sa Jesus be kera saungia ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nao nia si to na 'i seki. Nia tatae na fasia maea dia be nia saea fua mulu. Kamoro leka mai seki, ma kamoro ka ada to'ona 'amoro kula be nia tio ana. ");
INSERT INTO far_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Aia, moro leka 'ali'ali na, ma moro ka farongo 'uri ana fafurongo nia ki, ‘Sa Jesus nia mauri na, ma nia 'e leka na 'i nao amulu 'uria 'i Galili, ma mulu kai ada to'ona na senai.’ Ma moro ka manata to'ona ru nai nau ku saea fuamoro ki.” ");
INSERT INTO far_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","'Urinai go, keroa ka leka 'ali'ali na fasia faoda ana maue. Sui boroi 'ana, keroa 'e eele 'asiana. Ma keroa ka lae 'ali'ali fua farongolana fafurongo nia ki. ");
INSERT INTO far_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ma ana kada nai, sa Jesus ka dao to'odaro, ka fata 'uri, “Na aroaroe ka to fai kamoro.” Ma keroa ka leka mai siana, keroa ka boruru fuana, ma keroa ka dau kau 'i 'aena, ma keroa ka fa'initoa nia. ");
INSERT INTO far_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ma sa Jesus ka fata 'uri fuadaro, “Nao moro si mau. Moro leka, ma moro ka farongoa na wanefuta nau ki, fua kera kai leka 'uria 'i Galili. Ma kera kai ada to'oku na 'i senai.” ");
INSERT INTO far_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ana kada ro keni ne ki keroa oli kau sulia na taale, tani wane ana wane folo nai ki, kera leka na fasia faoda gwau sa Jesus, ma kera ka oli na 'uria 'i Jerusalem. Kada kera dao ana mae fere baita nai, kera ka fata na sulia ru ki tafau ne kera ada to'ona siana fataabu baita ki. ");
INSERT INTO far_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ma kada ne fataabu baita ki, ma tani wane fanaonao lau ana Jiu ki, kera ka fata oku ka suina, kera ka kwatea malefo baita fuana wane ni folo ki. ");
INSERT INTO far_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Kada kera kwatea malefo ne fuada wane folo ki, kera ka fata 'uri, “Mulu kai suke 'uri fuana wane ki tafau, ‘Kada kalu maleu laona rodo, na fafurongo sa Jesus ki kera leka mai, ma kera ka belia na nonina.’” ");
INSERT INTO far_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ma na wane fanaonao ki, kera fata laugo 'uri, “Dia sa Paelat nia rongoa na ru ne, nao mulu si manata 'abero lau, sulia kalu ne kai fa'o'olosia fuana, fua nao nia si guisasu fua mulu.” ");
INSERT INTO far_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ma kada wane folo ne ki kera ngalia malefo nai ka suina, kera ka leka, ma kera ka sasi na 'ada sulia ru ne fataabu baita ki ma na fanaonao Jiu ki, kera saea fuada. Ma na fatae nai ana sukee ka talofia tafau na Jiu ki, leka dao 'i ta'ena. ");
INSERT INTO far_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Na akwala ma te fafurongo nia ki kera leka na 'uria 'i Galili, 'uria te fa uo ne sa Jesus saea fua kera ka leka 'uria. ");
INSERT INTO far_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ma kada kera ada to'ona sa Jesus, kera ka fa'initoa, 'urinai boroi 'ana tani wane ada kera ka manata ruarua 'ua. ");
INSERT INTO far_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ma sa Jesus ka dao mai siada, ka fata 'uri, “God nia kwate dangalu na ana nikilalae ki tafau 'i langi ma laona molagali fuaku. ");
INSERT INTO far_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nia ne, mulu ka leka, ma mulu kai famanata wane ki ana fere ki tafau, fua kera na wane fafurongo nau ki laugo. Ma mulu kai siuabuda ana satana na Maa, na Wele, ma na Anoeru Abu. ");
INSERT INTO far_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ma mulu kai famanata kera fua kera ka rosulia ru ki tafau ne nau ku famanata kamulu ana. Ma nau ku to fai kamulu leka ka dao ana suilana molagali.” ");
INSERT INTO far_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Na safalilana mai na Farongoe Lea ne sulia sa Jesus Christ na Wele nia God ne 'uri: ");
INSERT INTO far_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nia safali dia mai sa Aesaea na profet be nia kedea ru ne God nia saea fuana Christ ne 'uri, “Nau kai kwatea kau na wane ni ngali farongoe nau 'i nao amu, fua nia kai sasi akau ana wane ki fuamu. ");
INSERT INTO far_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Te wane nia akwa fuana wane ki laona na bali lofaa 'eke'eke. Ma nia ka 'uri, ‘Na 'Aofia nia kai dao mai! Kamulu ka fasaga na taale fuana!’” ");
INSERT INTO far_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","'Urinai sa Jon nia ka dao na mai laona bali lofaa 'eke'eke ne nao si bobola fainia ta wane ka to ana. Nia rufia na maku ana ifuna kamel, ma nia ka bitia salafana na fosae nia ana na 'ungana buluka. Ma nia ka 'ania na siko ki ma na ngingidue kwasi. Ma nia siuabua wane ki, ma ka fata fuana wane ki, ka fata 'uri, “Mulu kari abulo fasia ta'alae kamulu ki, ma mulu siuabu fua God ka manatalugea na ta'alae kamulu ki.” Ma na wane 'oro ki fasia na bali lofaa 'i Jiudea, ma na fere 'i Jerusalem, kera ka leka mai fuana rongolana na fatalana sa Jon. Kera ka fulangainia ta'alae kera ki, ma nia ka siuabuda laona kafo 'i Jodan. ");
INSERT INTO far_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ma sa Jon ka fata 'uri fuana wane ki, “Te wane kai leka mai 'i buriku, nia talingai ka liufi nau, ma nau kusi bobola fua ne nau 'agwaoro ma ku lugea na tae butu nia ki. ");
INSERT INTO far_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ma nau ku siuabu kamulu ga 'aku ana kafo, boroi ma nia ne kai siuabu kamulu 'ana na Anoeru Abu.” ");
INSERT INTO far_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nao nia si tau go 'i buri'ana ru nai ki, sa Jesus ka dao na mai fasia na fere 'i Nasaret laona lofaa 'i Galili. Nia ka dao na mai siana sa Jon fua kai siuabu. Ma sa Jon ka siuabua laona kafo 'i Jodan. ");
INSERT INTO far_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ana kada sa Jesus nia tatae mai fasia laona kafo, nia ka ada to'ona na lofana salo nia 'ifi, ma na Anoeru Abu ka koso mai fafia dia ta bole. ");
INSERT INTO far_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ma te lingeru nia talo mai fasia 'i langi ma ka 'uri, “'Oe na ne wele mutai nau ne nau ku kwaimani 'asiana amu, ma nau ku eele 'asiana fai 'oe.” ");
INSERT INTO far_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma ana kada nai go, na Anoeru Abu ka talaia sa Jesus 'uria laona bali lofaa 'eke'eke. ");
INSERT INTO far_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ma nia ka to 'i senai sulia fai akwala maedangi ki, ma sa Saetan ka ilito'ona. Ru 'a'ala kwasi ki, kera to laugo 'i senai, boroi ma 'ainsel ki kera ka leka mai, ma kera 'adomia. ");
INSERT INTO far_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","'I buri'ana ne kera alua sa Jon laona beu ni kanie, sa Jesus ka leka 'uria lofaa 'i Galili ma ka 'ainitalo 'ana na Farongoe Lea ne leka mai fasia God. ");
INSERT INTO far_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nia ka fata 'uri, “Kada nia karangi na mai fua ne God kai gwaungai ana wane nia ki. Mulu kari abulo fasia ta'alae kamulu ki, ma mulu famamana Farongoe Lea ne.” ");
INSERT INTO far_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ma ana kada sa Jesus nia leka sulia na 'osi 'i Galili, nia ka ada to'ona sa Simon fainia wanefuta nia sa Andru. Keroa ro wane dee ki. Keroa dee adaro ana furai kera laona na 'osi nai. ");
INSERT INTO far_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ma sa Jesus ka fata 'uri fuadaro, “Kamoro leka mai fai nau, kamoro ro wane dee ie ki, boroi ma nau kai famanata kamoro ana ngali wane ki mai fuaku.” ");
INSERT INTO far_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ma kada nai go, keroa ka fasia furai keroa ki, ma kera ka leka na fainia. ");
INSERT INTO far_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma sa Jesus ka leka tu'u lau kau, nia ka ada to'ona sa Jemes fainia sa Jon, na ro wele sa Sebedi ki. Keroa to 'adaroa laona na baru, ma keroa ka modea furai keroa. ");
INSERT INTO far_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ma kada sa Jesus nia suada go, nia ka sae keroa na, ma keroa ka fasia na maa kera sa Sebedi 'i laona na baru fainia na wane ni rao ki, ma keroa ka leka na fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sa Jesus fainia fafurongo nia ki, kera dao ana fere 'i Kapaneam. Ma ana na Sabat, sa Jesus ka ru 'i laona na beu fuana folae Jiu ki, ma ka famanata wane 'oro ki. ");
INSERT INTO far_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kada kera rongoa, kera ka kwele 'asiana ana na famanatalae nia, sulia na famanatalae nia nao si dia lau famanatalae wane famanata ana taki ki. Sa Jesus nia famanata ana nikilalae God. ");
INSERT INTO far_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ma ana kada nai laugo, te wane ne anoeru ta'a nia rufia, nia 'e akwa ma ka 'uri, ");
INSERT INTO far_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus 'ae! 'Oe na wane 'i Nasaret! Te ne 'oe sasia amalu? Alamia 'oe leka mai fua fafunu lamalu 'oto ne! Nau ku saitamamu ga 'aku, 'oe na Wane Abu God!” ");
INSERT INTO far_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ma sa Jesus ka balufia na anoeru ta'a nai ka 'uri, “'Oe nofo 'amu, ma 'oko ru mai 'i maa fasia na wane nena!” ");
INSERT INTO far_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ma na anoeru ta'a nai, nia ka akwa baita, ma ka lebetainia na wane nai, ma ka ru tafa na mai fasia. ");
INSERT INTO far_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ma na tooa ne kera oku 'i senai, kera ka kwele 'asiana, ma kera ka ledi kwailiu ada ma kera 'uri, “Na te na ne 'uri ro? Ta famanatalae falu 'oto ne? Wane ne nia fata ana na nikilalae. Nia ifulangainia anoeru ta'a ki, ma kera ka rosulia na fatalana.” ");
INSERT INTO far_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Senai go, 'ali'ali farongoe sulia sa Jesus ka talo na laona bali lofaa 'i Galili. ");
INSERT INTO far_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kada sa Jesus fainia sa Jemes, ma sa Jon, kera leka na kau fasia na beu fuana folae nai, kera ka leka 'uria lume sa Simon ma sa Andru. ");
INSERT INTO far_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Kada sa Jesus nia dao laona lume nai, kera farongoa ana fungo keni sa Simon nia matai ana 'ako'akoe, ma nia ka tio ga 'ana laona 'ifitai nia. ");
INSERT INTO far_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ma sa Jesus ka leka siana keni nai, ma ka dau 'i 'abana, ma ka taea. Ma na 'ako'akoe nai ka suina fasia, ma keni nai ka sasi fanga fuada. ");
INSERT INTO far_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma ana fa saulafi nai, kada sato nia su, na wane ki kera ngalia mai wane matai ki, ma to ne anoeru ta'a rufida ki laugo siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ma tooa ana fere nai kera ka oku tafau mai 'i maana lume nai. ");
INSERT INTO far_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ma sa Jesus ka gura na wane 'oro ki ne kera matai ana na mataie 'oro 'e'ete ki. Ma nia ka ifulangainia laugo na anoeru ta'a 'oro ki. Ma nia si alamatainia ne anoeru ta'a nai ki kera ka fata, sulia kera saitamana sui go ana ne nia Wele God. ");
INSERT INTO far_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ma ana 'ofodangi go, kada nia rorodoa 'ua, sa Jesus nia ada ka tatae, ma ka ru kau 'i maa fasia na lume nai. Ma nia ka leka foa 'ana, ana kula ne nia aroaro. ");
INSERT INTO far_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ma sa Simon fainia na wane kwaimani nia ki kera nani 'uria. ");
INSERT INTO far_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ma kada kera dao to'ona, kera ka fata 'uri fuana, “Wane ki tafau kera nani 'uri 'oe.” ");
INSERT INTO far_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ma sa Jesus ka olisida ma ka 'uri, “Nau ku saitamana, boroi ma kulu leka kau ana tani mae fere karangi laugo, fuana nau ku famanata kera laugo, sulia ru nai nia na raoe ne nau ku leka na mai fuana.” ");
INSERT INTO far_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","'Urinai go, sa Jesus nia ka leka laona mae fere ki tafau laona lofaa 'i Galili, ma ka 'ainitalo ana Farongoe lea laona beu fuana folae kera ki, ma ka ifulangainia anoeru ta'a ki fasia na wane ki. ");
INSERT INTO far_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","'Urinai lau, te wane ne kuu saungia nonina nia leka mai siana sa Jesus, ma ka boruru 'i 'aena, ma ka amasia ka 'uri, “Dia 'oko nonimabe, 'oe saitamana gura nau ga 'amu.” ");
INSERT INTO far_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ma sa Jesus ka kwaimanatai 'asiana ana, ma ka taga na 'abana kau, ma ka samo to'ona na wane nai, ka fata 'uri, “Nau ku nonimabe. 'Oe mafo na!” ");
INSERT INTO far_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ma 'ali'ali go na kuu nai ka siki na fasia, ma na nonina ka mafo tafau na. ");
INSERT INTO far_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Sa Jesus ka fata totongai fuana wane nai ka 'uri, “Nao 'oe si farongoa lau ta wane ana ru ne nau ku sasia fuamu. Boroi ma 'oe leka basi, ma 'oko fatainia na nonimu fuana fataabu God, 'oko alamatainia fataabu God ka iroa nonimu. Sui 'oko kwatea na afafue 'oe dia be sa Moses nia saea fuana kwatelana, fua ka kwatea famamanae fuana wane ki tafau ne nonimu nia 'e mafo na.” Ma sa Jesus ka kwatea wane nai ka leka na 'ana. ");
INSERT INTO far_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Boroi ma, na wane nai nia leka, ma ka fata kwailiu ana laona fere ki tafau sulia te ne sa Jesus nia sasia ana nonina ka lea na. Sulia farongoe nai talofida na ne, wane 'oro ki kera ka oku mai siana sa Jesus fua rongolana. 'Urinai ma nia ka 'afitai na fuana sa Jesus ne kai leka fatai mai laona fere kera ki, ma nia ka to ga 'ana, ana kula aroaro ki. Ka 'urinai boroi 'ana, wane laona fere ki tafau kera leka go mai 'ada siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma 'i burina bara maedangi sui, sa Jesus ka oli lau mai 'uria 'i Kapaneam. Ma kera ka farongo kwailiu ana ne nia to ga 'ana laona lume be nia 'idufa dao laona fere nai. ");
INSERT INTO far_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","'Urinai na wane 'oro ki kera ka oku na mai siana sa Jesus, leka na lume nai kera ka tofia ka fungu 'asiana, ma ka nao na ta kula ni gourue 'i laona lume nai. Ma 'i maa boroi, wane 'oro ki kera oku laugo ana. Ma sa Jesus ka fulangainia fatalana God fuada. ");
INSERT INTO far_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ma ana kada nai laugo, na fai wane ki kera leka mai, kera ka ngalia mai te wane ne nonina mae. ");
INSERT INTO far_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ma sulia ne fikue baita nai, nia ka 'afitai na fuana ngalilana kau siana sa Jesus. 'Urinai go, kera ka ra 'i fafona lume fainia na wane nai. Ma kera ka tafangia te mae kwakwa baita 'i fafona lume bobola fainia kula ne sa Jesus nia to ana, ma kera ka fakosoa na wane nai 'i fafona 'ifitai nia siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ma kada sa Jesus nia ada saitamana famamanae kera, nia ka fata 'uri fuana wane nonina mae nai, “Wele nau 'ae, nau ku manatalugea na, na ta'alae 'oe ki.” ");
INSERT INTO far_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma kada nai, tani wane famanata ana taki ki kera to laugo 'i senai, ma kera ka manata 'ada 'uri talada, ");
INSERT INTO far_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nao nia si bobola fua ne nia ka fata 'urinai. Wane ki nao si saitamana manatalugea ta'alae ki. Taifilia go God ne saitamana manatalugea ta'alae ki. Nia fabolotania na fainia God.” ");
INSERT INTO far_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Boroi ma sa Jesus ka saitamana manatalada, ma ka fata 'uri fuada, “Kamulu si manata lau 'urinai. ");
INSERT INTO far_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Dia nau ku fata 'uri fuana wane nonina mae ne, ‘Ta'alae 'oe ki nau ku manatalugea na,’ kamulu si ada to'ona go ne nia fuli. Boroi ma dia nau ku fata 'uri, ‘Tatae, ngalia 'ifitai 'oe, ma 'oko fali,’ senai kamulu ka fi ada to'ona ne nikilalae nia aku fuana gurae. ");
INSERT INTO far_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kada nau gura wane ne, nau fatainia fua mulu ne nau, na Wele nia Wane, nau ku too ana nikilalae fuana manatalugelana na ta'alae ki.” 'Urinai nia ka fata 'uri fuana wane nai ne nonina mae, ");
INSERT INTO far_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nau ku saea fuamu, 'oe tatae, ngalia na 'ifitai 'oe, ma 'oko leka na 'i fere 'oe.” ");
INSERT INTO far_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma wane nai tatae, ka ngalia na 'ifitai nia, ma ka leka na. 'Urinai, kera tafau kera ada to'ona, ma kera kwele 'asiana. Kada nai, kera ka tangoa God, ma kera ka fata 'uri, “Nao kulu si suana 'ua ta ru 'uri!” ");
INSERT INTO far_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Te kada laugo, sa Jesus nia oli lau ninimana 'osi 'i Galili. Ma fikue baita kera ka leka mai siana, ma nia safali ka famanata kera. ");
INSERT INTO far_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ma ana kada nia liu kau sulia 'osi nai, nia ka ada to'ona sa Lifae, na wele sa Alfeas. Nia gouru ga 'ana, ana kula fuana konilana malefo ana takisi, sulia ne nia rao senai. Ma sa Jesus ka fata 'uri fuana, “'Oe leka mai fai nau.” Ma sa Lifae tatae, ma ka leka na fainia. ");
INSERT INTO far_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ma 'i burina ne sa Jesus nia talaia sa Lifae fuana fafurongo nia, nia ka leka fanga na 'i lume nia. Ma na tooa ni koni malefo ana na takisi ki kera to laugo senai, ma tani “wane aburongo” laugo, kera fanga fainia sa Jesus ma na fafurongo nia ki. Na wane 'oro 'urinai ki, kera leka fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tani Farasi ne kera famanata ana taki sa Moses ki, kera ada to'ona ne sa Jesus nia fanga fainia “tooa aburongo ki” ma na tooa kera koni malefo ana takisi ki. Ma Farasi ki kera ka fata 'uri fuana fafurongo sa Jesus ki, “Nia bobola fua nia si fanga lau fainia wane aburongo ki.” ");
INSERT INTO far_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ma kada sa Jesus nia rongoa ru nai, nia ka fata 'uri fuada, “Wane ne nao kera si matai ki, kera si doria go ta wane kwaigurai, boroi ma wane ne kera matai ki, kera ka bobo 'uria wane kwaigurai. Nau kusi leka lau mai fuana riilae wane 'o'olo ki fua kera kai kari abulo, boroi ma na wane ne abulolada ta'a ki lalau ne, nau ku leka mai fuana riilae 'uria tatala manatalae.” ");
INSERT INTO far_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ana te kada, tani fafurongo ana sa Jon wane ni Siuabu, ma na fafurongo Farasi ki, kera abu fanga. Ma tani wane kera ka leka mai, ma kera ka fata fuana sa Jesus kera 'uri, “Fafurongo sa Jon ki, ma fafurongo Farasi ki, kera abu fanga. Nia nao si lea fuana fafurongo 'oe ki ne kera nao si abu fanga.” ");
INSERT INTO far_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ma sa Jesus ka olisida ka 'uri, “Nia si bobola fua tooa ne kera to ana fafanga ana araie, kera abu fanga. Sulia ne, kada arai falu nia ga 'ana 'ua faida, kera eele 'ua. Nia 'afitai fua kera ka abu fanga, sulia kera to ana fafanga. ");
INSERT INTO far_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Boroi ma kada kai dao mai, kada ne kera kai talaia na arai falu fasida. Senai, kera ka fi abu fanga lau, sulia ne kera kwaimanatai. Nia ne nao si bobola fua fafurongo nau ki ne kera ka abu fanga kada nau ku to 'ua ga 'aku fai kera.” ");
INSERT INTO far_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sa Jesus ka fata lau 'uri, “Nao ta wane si taia ta maku ne nia muu ana ta ngingisi maku ne falu. Sulia dia nia sasia ru nai, na ngingisi maku falu nai ka musia na maku 'ua nai, sulia maku falu nia lukuluku 'i burina taufilana, ma nia ka sasia na mae kwakwa ne baita. ");
INSERT INTO far_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ma kamulu saitamana laugo, ne nao nia si bobola fua ta wane ka alua na waeni falu 'i laona ngwai 'ua ana 'ungana nanigot, sulia ngwai ru 'ua nai si bose. Suli dia nia sasia ru 'urinai, kada na waeni nai kai torotoro go mai, nia ka fogea na ngwai ru 'ua nai, ma na waeni nai ka 'igitai, ma na ngwai ru nai ka ta'a na. Nia ne wane kai alua waeni falu 'i laona na ngwai ru falu ne nia saitamana kai bose.” ");
INSERT INTO far_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ana te Sabat, sa Jesus ma fafurongo nia ki, kera leka sulia na taale ne nia liu folo ana te oole witi. Ma kada kera liu ana, fafurongo nia ki kera ka ngeda fueru witi ki, ma kera ka 'ania. ");
INSERT INTO far_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ma Farasi ki kera ada to'ona, ma kera ka fata 'uri fua sa Jesus, “Ada to'ona basi! Ru ne kamulu sasia nia 'oia na taki sa Moses, sulia kamulu ngeda witi ne ana Sabat.” ");
INSERT INTO far_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ma sa Jesus ka olisida ma ka 'uri, “Nau ku saitamana kamulu idumia laona Buko Abu sulia ru be sa Deved na kingi nia sasia 'i nao, kada be sa Abiata nia 'inita fataabu. Kada be, sa Deved fainia wane nia ki kera fiolo 'asiana, sulia nao na ta fanga fuada. Ma nia ka leka 'i laona na 'O'obe Abu God, ma na 'inita fataabu ka kwatea na beret ne kera 'auabua fuana God fua sa Deved ka 'ania. Ma sa Deved ka 'ania na beret nai, ma ka kwatea laugo fuana wane nia ki, ma kera ka 'ania. Boroi ma na taki kulu alamatainia fua taifilia go fataabu God ki ne kera saitamana 'anilana. Ma nao kulu si ada to'ona laona Buko Abu ne God nia guisasu fuana sa Deved.” ");
INSERT INTO far_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sui go sa Jesus ka fata 'uri fuana Farasi ki, “God nia saungainia Sabat fuana 'afilana wane ki. Ma nao nia si saungainia lau Sabat fua wane ne kai laeororo farana. ");
INSERT INTO far_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Sulia ne nau, na Wele nia Wane, nau ku too ana na nikilalae fuana saelana ru ki fuana wane ki kera saitamana ka sasia ga 'ada ana Sabat.” ");
INSERT INTO far_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ta kada laugo, sa Jesus nia ka leka lau laona beu fuana folae ma te wane ne 'abana mae, nia to senai. ");
INSERT INTO far_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma tani Farasi senai, kera ka adaada dia sa Jesus kai gura wane nai ana Sabat. Dia 'urinai, kera ka fata maana sa Jesus ana 'oilana taki God ana gurae, ru nai kera manata sulia ne dia raoe. ");
INSERT INTO far_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma sa Jesus ka fata 'uri fuana wane ne 'abana mae, “Tatae mai 'i seki, 'oko uu 'i naona wane ki tafau.” ");
INSERT INTO far_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Go, sa Jesus ledia Farasi ki ka 'uri, “Te ne taki kulu nia alamatainia fua kulu ka sasia ana Sabat. Nia alamatainia sasilana ru lea ki, naoma sasilana ru ta'a ki? Nia alamatainia na famaurilana ta wane, naoma saungilana ta wane?” Boroi ma kera si saea go ta ru. ");
INSERT INTO far_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Sa Jesus nia ada kalikalida, ma nia ka ada guisasu, sulia ne kera nao si kwaimanatai na ana wane matai nai, ma nia ka kwaimanatai laugo fuada sulia manatada ngasi 'asiana. Sui go, nia ka fata 'uri fuana wane nai, “Taga na 'abamu.” Ma nia ka taga na, ma na 'abana ka lea na. ");
INSERT INTO far_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","'Urinai go Farasi ki kera ka ru kau 'i maa, ma kera ka fata oku fainia tani wane ana tooa sa Herod ki, ma kera ka manata 'uria saungilana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Sa Jesus fainia fafurongo nia ki, kera ka fasia tooa nai, ma kera ka leka 'uria na 'osi 'i Galili. Wane 'oro ki kera ka leka laugo 'i burida. Kera leka mai fasia lofaa 'i Galili, 'i Jiudea, ma 'i Idumea ki. Ma tani wane laugo fasia 'inita fere 'i Jerusalem, ma fasia na bali fere ana taelana sato ana kafo 'i Jodan. Ma tani wane kera ka leka mai fasia fere kalikalia 'i Taea ma 'i Saedon ki. Na fikue baita nai, kera leka mai siana sa Jesus, sulia kera rongoa ru baita ne nia fulida ki. ");
INSERT INTO far_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sulia na fikue nai baita 'asiana, sa Jesus ka saea fuana fafurongo nia ki fua kera ka sasi akau ana na baru, fasia na tooa kera ka beresia. ");
INSERT INTO far_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Nia gura wane 'oro ki ka suina, nia ne wane 'oro matai ki ka sumai kera kau, fua kai samo to'ona sa Jesus fua kera ka 'akwa. ");
INSERT INTO far_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ma kada na tooa anoeru ta'a ki nia rufida kera ada to'ona, kera ka boruru 'i naona, ma kera ka akwa ma kera 'uri, “'Oe na ne, na Wele mamana God!” ");
INSERT INTO far_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Boroi ma sa Jesus fata ka luida anoeru ta'a nai ki, fua kera si farongoa lau ta wane 'ani nia. ");
INSERT INTO far_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","'Urinai go sa Jesus ra 'alaa 'i gwauna te fa uo, ma ka talaia mai wane ne nia doria fua kera ka rao fainia. Go kera leka mai siana, ");
INSERT INTO far_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ma nia ka filia akwala ma ro wane, ma ka fasata kera ana lifurongo ki. Ma nia ka fata 'uri fuada, “Nau ku fili kamulu fua mulu to tari fai nau, ma nau ku eresi kamulu laugo fua fatalolana fatalana God fuana wane ki. ");
INSERT INTO far_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ma kamulu ka too ana na nikilalae fuana ifulangailana anoeru ta'a ki.” ");
INSERT INTO far_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nia, ne satana akwala ma ro wane ne nia filida ki: sa Simon, ne sa Jesus nia fasata laugo 'ana sa Pita, ");
INSERT INTO far_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ma sa Jemes fainia sa Jon na ro wele nia sa Sebedi ki, ne sa Jesus nia fasata keroa 'ana “Boneges”, na fadalana ne wane ne guisasu ladaro 'ali'ali dia na kwangakwanga. ");
INSERT INTO far_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ma sa Andru, sa Filip, sa Batolomiu, sa Matiu, sa Tomas, sa Jemes, wele nia sa Alfeas, sa Tadeas, ma sa Simon, ta wane ana tooa Jiu ne kera doria tarilana wane Rom ki fasia 'i Israel. ");
INSERT INTO far_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ma sa Jiudas Iskariot, na wane nia kai 'olomaelana sa Jesus fuana malimae nia ki. ");
INSERT INTO far_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","'Urinai, sa Jesus ka oli laugo laona lume be nia 'idufa dao ana. Ma wane 'oro ki, kera ka inau na mai ana fikue. 'Urinai nao na ta kada fuana sa Jesus ma fafurongo nia ki fua sasilana ta ru ma na fangalae boroi. ");
INSERT INTO far_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ma kada ne gaa nia fai sasina ki kera rongoa ru nai, kera ka leka siana fua olitailana 'uria 'i fere, sulia kera fata 'uri, “Nia oewanea 'asiana.” ");
INSERT INTO far_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma tani wane famanata ana taki sa Moses ne kera leka mai fasia 'i Jerusalem, kera ka fata 'uri, “Sa Jesus nia ifulangainia anoeru ta'a ki ana nikilalae sa Saetan, na 'inita anoeru ta'a.” ");
INSERT INTO far_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nia ne, sa Jesus ka saea mai wane ki ka fata 'uri fuada ana tarifulae ki ka 'uri, “Sa Saetan nia 'afitai ka ifulangainia anoeru ta'a nia ki fasia wane ki. ");
INSERT INTO far_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Dia tooa laona ta fere baita kera fuali kera talada, 'urinai fere baita nai kai takalo na. ");
INSERT INTO far_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ma dia ne wane, ma na 'afe nia, ma na wele keroa ki, kera fua fai kera talada, nia 'afitai fuana kera ka to oku. ");
INSERT INTO far_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ma na 'initoe sa Saetan ne 'urinai laugo. Dia sa Saetan kai firu fainia tooa ne kera leka sulia, 'urinai kera kai takalo kwailiu go, ma nikilae nia fafida ka dao ana 'isilana.” ");
INSERT INTO far_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","'I burina, sa Jesus ka saea lau te tarifulae, ka fata 'uri, “Dia ta wane doria ka ifulangainia ta anoeru ta'a, wane nai ka nikila ka liufia sa Saetan. Ka dia laugo ta wane ne doria kai ru laona lume na wane nikila fuana ngalilana ru nia ki. Nia ka nikila ka liufia wane nai, fua ka ngwaluda fuana kanilana wane nikila nai sui nia ka fi ngalia ru nia ki. ");
INSERT INTO far_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ru mamana nau ku saea fua mulu, abulo ta'alae ki, ma fata falilana God ne wane ki kera sasia, God nia manatalugea ga 'ana. ");
INSERT INTO far_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Boroi ma, dia ta wane ka fata falia na raoe Anoeru Abu, God nao si manatalugea, sulia ta'alae nai nia toto firi.” ");
INSERT INTO far_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Sa Jesus nia fata 'urinai sulia wane famanata ana taki ki, kera saea nia too ana na anoeru ta'a. ");
INSERT INTO far_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ma 'i burina ru nai ki, gaa sa Jesus ma na sasina ki, kera ka dao na. Ma kera ka uu ga 'ada 'i maa na lume, ma kera ka kwate fatae kau fuana sa Jesus, ma kera ka ledi 'uri nia. ");
INSERT INTO far_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tooa 'oro 'asiana kera gouru kalia sa Jesus, ma kera ka farongo nia 'uri, “Ga 'oe, ma na sasimu ki, kera uu mai 'i maa, kera doria ada to'omu.” ");
INSERT INTO far_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ma sa Jesus ka olisida ka 'uri, “Nau saea fua mulu ti ne gaa mamana nau, ma sasiku ki!” ");
INSERT INTO far_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Go kada nia ka ada kau fuana tooa 'oro ne kera gouru kalia, nia ka fata 'uri, “Nia na ne tooa kera dia na gaa nau ki, ma sasiku ki! ");
INSERT INTO far_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Sulia sa ti ga 'ana ne nia sasia ru ne God nia doria ki, nia na ne wanefuta nau, ma waiwane nau, ma na gaa nau.” ");
INSERT INTO far_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ana te kada lau, sa Jesus nia famanata 'i ninimana 'osi 'i Galili. Ma na fikue baita 'asiana kera ka oku kalikalia, ma nia ka ra laona te baru, ma ka gouru 'i laona, ma nia ka 'idu tu'u lau folo laona 'osi. Ma na fikue nai, kera ka uu kau 'i ninimana 'osi. ");
INSERT INTO far_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ma sa Jesus ka famanata ana ru 'oro ki fuada ana tarifulae ki ma ka 'uri, ");
INSERT INTO far_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Mulu fafurongo basi! Te wane nia leka ka takalongainia na mege witi ki 'i laona oole nia. ");
INSERT INTO far_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma kada nia takalongainia na mege witi senai, tani mege witi kera 'asia sulia na kakaloe, ma na no ki kera ka lofo mai, ma kera ka 'anida tafau. ");
INSERT INTO far_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ma tani mege witi kera ka 'asida ana kula faula ki, kula ne ano si baita. Ma kera ka bulao 'ali'ali, sulia ne ano nia si 'oro. ");
INSERT INTO far_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ma ana kada ne sato nia tae mai, nia ka satofia na witi ne masubu ki, ma kera ka kuku laugo, sulia ne lali ru ki nao si koso lola. ");
INSERT INTO far_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ma tani mege witi kera 'asida 'i safitana 'oko ngangara ki, ma 'oko nai ka nuku fafia na witi ki, ma witi nai ki nao si fungu go. ");
INSERT INTO far_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ma tani mege witi lau, kera 'asida 'i laona na ano ne nia lea, ma kada kera tae mai, kera ka fungu ana fueru 'oro ki. Ma tani witi kera ka fungu ana olu akwala fueru, ma tani witi kera ka fungu ana ono akwala fueru, ma tani witi lau kera ka fungu ana te talanga fueru ki.” ");
INSERT INTO far_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ma sa Jesus ka fasuia fatalana ka 'uri, “Dia ta wane doria ka saitamana lea ana ru ne ki, nia ka fafurongo lea.” ");
INSERT INTO far_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kada sa Jesus nia to 'ana taifilia, na akwala ma ro fafurongo be nia ki, fainia ta bali ana wane ne kera rongoa na fatalana, kera ka leka mai siana. Ma kera ka ledia fua nia ka fadaa fola ana tarifulae nai ki. ");
INSERT INTO far_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ma nia ka olisida ka 'uri, “Kada sui ki, God nao si famadakwa 'ua, 'uta ne nia kai gwaungai ana wane nia ki. Boroi ma 'i ta'ena, na madakwalae ne nia dao na fua mulu. Wane ne kera nao si doria fafurongolae aku, nau ku fata 'ana tarifulae ki ");
INSERT INTO far_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","fua, ‘Kera ka ada, ma kera kai ada, boroi ma kera nao si ada to'ona te ne God nia sasia fuada. Ma kera kai fafurongo, ma kera kai fafurongo, boroi ma kera nao si saitamana farongoe God. Sulia dia kera ada saitamana, ma kera ka rongo saitamana, 'urinai kera kai abulo mai fuana God, ma nia kai manataluge ana ta'alae kera ki.’” ");
INSERT INTO far_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","'Urinai sa Jesus ka ledi 'uri ada, “'Uri ma nao kamulu si saitamana go tarifulae ne? Dia nao kamulu si saitamana tarifulae ne, kamulu ka fi saitamana 'uta mone ana tarifulae ki? ");
INSERT INTO far_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Na wane be nia takalongainia mege witi, nia takalongainia na fatalana God be. ");
INSERT INTO far_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma tani wane ne kera rongoa na fatalana God, kera dia na mege witi ne nia 'asia sulia na kakaloe. Ma kada kera rongoa, sa Saetan nia leka mai, ma ka lafua laugo 'ana fatalana God fasida. ");
INSERT INTO far_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma tani wane lau kera dia na mege witi ne kera 'asida ana kula faula. Kada kera rongoa na fatalana God, kera ngalia, ma kera ka eele 'asiana. ");
INSERT INTO far_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Boroi ma fatalana God nao si lalisusu go laona maurilada. Nia ne fitoe kera ki ka mauri go sulia ka kada tu'u. Ana kada ne kera dao to'ona 'afitaie, ma na nonifilae ki sulia farongoe lea ne, kera ka fasia go na fatalana God. ");
INSERT INTO far_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma tani wane ne kera dia mege witi ne kera 'asida 'i safitana na 'oko ngangara ki. Kera rongoa na fatalana God, ");
INSERT INTO far_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","boroi ma kera manata 'abero 'ada sulia ru ki ana maurie kera, ma kera ka manata baita ana malefo. Ma ru nai ki, nia dia na 'oko ngangara ki ne nia nuku fafia na fatalana God laona maurilada. Kera nao si tatala go laona maurilada, ka dia na witi ne nao si fungu go ana ta fueru. ");
INSERT INTO far_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma tani wane lau ne kera dia na mege witi ne kera 'asida 'i laona ta ano lea. Kera rongoa fatalana God, ma kera ka rosulia, ma kera fatainia tolae 'o'olo, ka dia witi ne nia fungu ana fueru ki. Tani witi ne olu akwala fueru ki, ma tani witi ne ono akwala fueru, ma tani ai ne te talanga fueru.” ");
INSERT INTO far_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","'Urinai go sa Jesus ka ledi lau 'uri ada, “Nia 'uta? 'Uri ma dia ta wane ngalia mai na kwesu, nia kai alua ga 'ana 'i farana ta tiu naoma ta 'ifitai? Nao go! Nia kai alua 'i fulina 'i langi! ");
INSERT INTO far_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ta ru ne wane ki nao si saitamana mai 'i nao, kera kai saitamana. ");
INSERT INTO far_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Dia ta wane ne doria ka saitamana lea ana ru ne ki, nia ka fafurongo lea.” ");
INSERT INTO far_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ma sa Jesus ka fata lau 'uri fuada, “Mulu manata lea sulia ru ne kamulu rongoa ki. God kai kwate tatakolae ana liotoe fua mulu, suli dia kamulu rosulia famanatalae nau ki. ");
INSERT INTO far_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sa ti boroi 'ana ne to ana ta madakwalae tu'u sulia 'Initoe God, God kai lado gwauna fuana. Boroi ma sa ti ne nao si rosulia famanatalae ne ki, ta madakwalae tu'u boroi 'ana ne nia to ana sulia 'Initoe God, God kai olitainia fasia.” ");
INSERT INTO far_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sa Jesus ka fata lau 'uri fuada, “Na 'Initoe God nia dia na wane ne nia fasia ta mege 'ai 'i laona na oole nia. ");
INSERT INTO far_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nia ada, ka liliu ana asoa ki, ma ka maleu ana laona rodo ki. 'Urinai boroi 'ana, kada ne mege ru ki nia bulao, ma ka tatae na, nao lau 'abero nia. Sulia wane ne nao si saitamana laugo ana ru ne nia sasia mege 'ai ka bulao. ");
INSERT INTO far_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Na ano talana na ne nia famauria mege 'ai senai nia ka baita, ma ka fungu ana fufue ru ki. Na 'inita 'ai nia ra mai 'i nao, sui na fueru ki, 'i buri na mege ru ki ka fi ra mai. ");
INSERT INTO far_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ma kada ne mege ru nai ki nia maua, na wane nai ka safali fuana sikililana fueru ki, sulia nia dao na ana kada fua loi rulae.” ");
INSERT INTO far_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sa Jesus nia fata lau ka 'uri, “Nau fata lau kau sulia ta tarifulae ne kai fatainia na ru ne bobola fainia 'Initoe God fafia wane nia ki. ");
INSERT INTO far_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nia ka 'uri: Te wane nia ngalia na mege 'ai ne kera saea ana mastad, nia tu'u ka liufia mege 'ai ki tafau, ma nia ka fasia laona ano. ");
INSERT INTO far_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ma 'i burina ne nia fasia ka sui, na mege ru be ka tae, ma ka alua na 'ai. 'Ai nai baita ka liufia na 'ai 'oro ki. Ma nia ka too ana na sarana 'ai baita ki, ma na no ki kera ka lofo mai, ma kera ka saungainia na nui kera ki ana.” ");
INSERT INTO far_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","'Urinai ne, sa Jesus ka fata fuana wane ki ana tarifulae nai ki, ma nia ka saea ru ne nia bobola fainia kia kai saitamana. ");
INSERT INTO far_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ma nia ka fata fuada 'ana tarifulae ki. Boroi ma, kada ne nia to 'ana taifilia fainia na fafurongo nia ki, nia ka fi famadakwa ru ki tafau fuada. ");
INSERT INTO far_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nia saulafi na ana maedangi nai, sa Jesus nia ka fata 'uri fuana fafurongo nia ki, “Kulu tofolo basi 'uria bali 'osi loko.” ");
INSERT INTO far_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ma kera ka fasia na fikue nai, ma kera ka leka fainia sa Jesus 'i laona baru nai ne nia ka to 'i laona. Ma tani baru laugo leka faida. ");
INSERT INTO far_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ma na kuburu baita nia tae mai, ma na nanafo ka magara na mai laona na baru nai, ma ka karangi kuruu na. ");
INSERT INTO far_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ma sa Jesus nia maleu 'ana 'i burina na baru, ma ka alu gwau ana bogwau nia. Ma na fafurongo nia ki kera ka faada, ma kera ka fata 'uri, “'Aofia 'ae, kulu karangi mae na! 'Oe nao si manata 'abero go ne?” ");
INSERT INTO far_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ma sa Jesus ka tatae, ma ka balufia na kuburu nai ka 'uri, “'Oe aroaro na!” Ma nia ka fata laugo fuana nanafo nai ka 'uri, “Kamulu kai to aroaro na!” 'Urinai go, na kuburu be ka aroaro na, ma 'osi ka fola na. ");
INSERT INTO far_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ma nia ka fata 'uri fuana fafurongo nia ki, “'Uta ne kamulu ka mau? Kamulu nao si famamana 'ua?” ");
INSERT INTO far_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ma kera ka mau kera ka lelebe na, ma kera ka ledi kwailiu ada kera ka 'uri, “Wane 'uta na ne ro? Na kuburu ma na nanafo boroi kera ro na sulia!” ");
INSERT INTO far_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sa Jesus fainia fafurongo nia ki, kera tofolo 'uria bali 'osi 'i Galili, ma kera ka dao ana bali 'osi ne ana bali lofaa 'i Gerasa. ");
INSERT INTO far_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ma kada sa Jesus nia koso fasia na baru, te wane ne anoeru ta'a rufia, ma ka leka mai fasia na faoda fuana alulana wane mae ki, ma nia ka leka mai siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Na wane nai to laona faoda 'urinai ki, ma nao ta wane si bobola fuana kanilana 'ana ta seni. ");
INSERT INTO far_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Sulia kada 'oro ki, kera kani fafia na 'abana ma na 'aena ana na seni ki, sui nia ka musia go na seni nai ki, ma ka 'oia ga 'ana na seni nai ki 'i 'aena. Ma nao ta wane si nikila ka bobola fuana daulana. ");
INSERT INTO far_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ma na rodo ki ma na dangi ki, nia liu kwailiu safitana na faoda fua alu wane maelae ki, ma nia ka ra gwauna fa uo ki, ma nia ka akwa, ma ka kware nia talana ana naki ki. ");
INSERT INTO far_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kada nia to tau mai, nia ka ada to'ona sa Jesus, ma ka lae 'ali'ali mai, ma ka boruru 'i naofana. ");
INSERT INTO far_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Sa Jesus ka fata 'uri fuana, “Anoeru ta'a ne, 'oe ru mai 'i maa fasia na wane ne.” Ma nia ka akwa baita ka 'uri, “Jesus! 'Oe na Wele nia God ne nia nikila 'asiana. Na te ne 'oe doria 'oe sasia aku? Nau ku amasi 'oe ana satana God, 'oe si kwatea lau ta kwaekwaee fuaku!” ");
INSERT INTO far_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Sui sa Jesus ka ledia ka 'uri, “Satamu sa ti ne?” Ma nia ka olisia ka 'uri, “Sataku sa Legini, sulia kalu 'oro 'asiana.” ");
INSERT INTO far_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ma nia ka amasia lau sa Jesus fua nao nia si eresida fasia na bali fere nai. ");
INSERT INTO far_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma boso 'oro ki kera fanga ga 'ada laugo 'i babaraoa ana fa uo nai. ");
INSERT INTO far_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ma anoeru ta'a nai ki, kera amasia sa Jesus kera ka 'uri, “'Oe kwate kalu fuana boso loko ki, fua kalu ka ru amalu 'i laoda.” ");
INSERT INTO far_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ma sa Jesus ka ala'anida, ma anoeru ta'a nai ki kera ka ru mai fasia wane nai, ma kera ka leka, kera ru 'i laona na boso nai ki. Ma 'oko boso nai nia bobola fainia ro to'oni boso ki, ma kera ka lae ana obaraoe 'ato nai, ma kera ka 'asida 'i laona na 'osi nai, ma kera ku kera ka mae tafau na. ");
INSERT INTO far_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ma wane ne kera ada sulia na boso nai ki, kera ka tafi, ma kera ka farongo ana ru ne nia fuli ana boso ki 'i laona fere nai, ma na fere tu'u kalikalia ki. Ma na wane 'oro ki kera ka leka fuana adalae to'ona ru ne nia fuli. ");
INSERT INTO far_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ma ana kada kera dao siana sa Jesus, kera ka ada to'ona na wane be ne anoeru ta'a 'oro ki kera rufia, nia to na ana senai, ma nia ka 'afi na, ma nia ka manata saga na. Ma wane ki kera ka mau, kera ka kwele 'asiana. ");
INSERT INTO far_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma wane ne kera ada to'ona ru nai nia fuli, kera ka fata fuana wane ki sulia na wane anoeru ta'a ki to ana, ma kera ka fata laugo sulia na boso nai ki. ");
INSERT INTO far_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ma burina, tooa nai kera 'ingoa sa Jesus ka leka fasia na bali fere kera. ");
INSERT INTO far_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma kada sa Jesus nia ra na laona baru, na wane be na anoeru ta'a ki kera rufia 'i nao, nia ka fata 'uri fuana sa Jesus, “'Oe alamatainia nau fua nau leka fai 'oe.” ");
INSERT INTO far_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Boroi ma sa Jesus si alamatainia, ma ka fata 'uri fuana, “'Oe oli 'i fere siana wane 'oe ki, ma 'oko farongoda 'ana ru lea ki tafau ne God nia sasia fuamu, ma na kwaimanatailae nia fuamu.” ");
INSERT INTO far_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ma na wane nai nia leka, ma ka farongoa na wane ki ana bali lofaa 'i Dekapolis ana ru ki tafau ne sa Jesus nia sasia fuana. Ma wane ki tafau kera ka kwele 'asiana. ");
INSERT INTO far_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sa Jesus nia tofolo lau kau 'uria ta bali 'osi. Ma ana kada nia 'e dao na ana ta bali, wane 'oro ki kera ka oku kalia. ");
INSERT INTO far_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ma te wane ada ne wane fanaonao laona beu fuana folae ana fere nai, satana sa Jaeras, ka leka mai. Ma kada nia ada to'ona sa Jesus, nia ka boruru 'i maana 'aena, ");
INSERT INTO far_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ma nia ka amasia ma ka 'uri, “Ka sari nau nia tio na fuana maelana. 'Oe leka mai, fua 'oe alua na 'abamu fafia, fua nia ka 'akwa ma ka mauri.” ");
INSERT INTO far_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ma sa Jesus ka leka na fainia. Ma na fikue baita kera leka 'i burina, ma kera ka beresia na. ");
INSERT INTO far_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ma te 'afe ne na gwa 'abu 'e tafangia sulia te akwala ma ro fangali ki suina, nia to laugo senai. ");
INSERT INTO far_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ma nia ka nonifi 'asiana. Ma nia ka falia na malefo 'oro nia ki fuana wane kwaigurai 'oro ki, boroi ma tolana si lea go. Nia ka fi ta'a ka liufia mone. ");
INSERT INTO far_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ma kada ne nia rongoa farongoe sulia sa Jesus, nia ka leka mai 'i burina safitana na fikue nai, nia ka samo to'ona na maku gwala sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Sulia nia manata 'uri, “Dia nau ku samo to'ona boroi 'aku na maku nia, nau lea na.” ");
INSERT INTO far_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ma kada ne nia samo to'ona go maku sa Jesus, 'ali'ali na 'abu ne tafangia nia ka lalanga na, ma nia ka saitamana na nonina nia 'akwa na fasia na mataie nia. ");
INSERT INTO far_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ma ana kada nai go, sa Jesus nia saitamana ne nikilalae nia gura ta wane. Ma nia ka abulo 'i safitana na fikue nai, ma ka ledi 'uri, “Sa ti ne samo to'ona na maku nau?” ");
INSERT INTO far_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ma na fafurongo nia ki, kera ka olisia kera 'uri, “'Oe ada to'ona ga 'amu na tooa 'oro ne kera beresi 'oe na. 'Uta ne 'oko ledi 'uria sa ti ne samo to'omu?” ");
INSERT INTO far_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Boroi ma sa Jesus ka ada kwailiu fua ne ka ada to'ona sa ti ne nia sasia ru ne. ");
INSERT INTO far_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma na keni ne nia saitamana ru ne fuli fuana, ma nia ka leka lelebe mai 'ana maue, ma ka boruru 'i maana 'aena sa Jesus. Ma nia ka farongoa mamana ana ru ne nia sasia ki. ");
INSERT INTO far_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ma sa Jesus ka fata 'uri fuana, “Keni ne 'ae, God nia gura 'oe na sulia ne 'oko famamana nau. 'Oe leka na 'amu, ma 'oe si manata 'abero, ma 'oko 'akwa na fasia na mataie 'oe.” ");
INSERT INTO far_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma kada sa Jesus nia fata ga 'ana 'ua, tani wane kera ka dao mai fasia na lume sa Jaeras, ma kera ka fata 'uri fuana sa Jaeras, “Ka sari 'oe be nia mae na. 'Oe si fa'aberoa lau na wane famanata.” ");
INSERT INTO far_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ma sa Jesus nao si 'abero go sulia ru ne kera saea, ma ka fata 'uri fua sa Jaeras, “Nao 'oe si mau. 'Oe famamana nau lalau 'amu.” ");
INSERT INTO far_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ma nia nao si alamatainia ta wane ka leka fainia, taifilia go sa Pita, sa Jemes, ma sa Jon na wanefuta nia sa Jemes. ");
INSERT INTO far_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ma kada kera dao 'i lume sa Jaeras, sa Jesus ka rongoa na alifie fainia na angiangie ma na omaee nia baita 'asiana. ");
INSERT INTO far_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ma nia ka ru kau, ma ka fata 'uri fuada, “'Uta ne kamulu angi, ma mulu omaee ka 'uri na? Wele ne nao si mae, nia maleu ga 'ana ne.” ");
INSERT INTO far_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Boroi ma, kera ka fi waelasia lalau sa Jesus. Ma nia ka eresida kau 'i maa, ma ka talaia na maa nia, fainia gaa nia wele nai, ma fafurongo nia ki ne kera to fainia, ma kera ka ru laona mae lume ne wele nai nia tio ana. ");
INSERT INTO far_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ma nia ka dau ana na 'abana na wele nai, ma ka fata 'uri fuana, “Talita kum!” Na fadalana nia 'uri, “Sari 'ae, nau ku saea fuamu 'oe tatae!” ");
INSERT INTO far_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ma nia ka tatae, ma ka uu, ma ka fali. Na wele nai te akwala ma ro fangali go ne sui burina nia futa. Ma kera ka kwele 'asiana ana ru nai. ");
INSERT INTO far_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Boroi ma sa Jesus fata ka luida, fuana kera nao si farongoa lau ta wane 'ana ru nai. Ma nia ka saea kera ka kwatea fanga fuana wele nai fua nia ka 'ania. ");
INSERT INTO far_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sa Jesus fainia fafurongo nia ki, kera fasia na kula nai, ma kera ka oli lau mai ana mae fere nia 'i Nasaret. ");
INSERT INTO far_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ma ana Sabat, nia ka famanata 'i laona beu fuana folae. Ma tooa 'oro ki kera rongoa, ma kera ka kwele 'asiana. Ma kera ka ledida kwailiu ma kera 'uri, “Na nikilalae sa ti ne kwate nia ka famanata ana fatalana God 'uri, ma fainia sasilana fanadae ki? ");
INSERT INTO far_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Wane ne kulu saitamana lea ana. Nia wane saungai lume ga 'ana ne. Gaa nia be ni Mary go ana. Tani wanefuta ana be sa Jemes, sa Josef, sa Jiudas, ma sa Simon. Ma waiwane nia ki kera to ga 'ada 'i seki.” 'Urinai, kera ka noni'ela 'ani nia. ");
INSERT INTO far_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ma sa Jesus ka fata 'uri fuada, “Wane ana fere 'e'ete ki kera saitamana kera fabaita na profet. Boroi ma wane ana fere nia talana, ma wanefuta nia ki, 'afitai kera ka fabaita.” ");
INSERT INTO far_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ma nia nao si bobola na fuana sasilana lau fanadae 'oro ki senai. Ma nia ka alua na 'abana fafia bara wane ne matai ma ka gurada. ");
INSERT INTO far_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ma nia ka kwele 'asiana, sulia wane ki nao si famamana. 'Urinai sa Jesus nia leka ana mae fere ki kalikalia senai, ma ka famanata wane ki. ");
INSERT INTO far_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nia ka saea mai akwala ma ro wane fafurongo nia ki siana, ma nia ka kwatea na nikilalae fuada fuana ifulangailana anoeru ta'a ki, ma ka eresida mai tafau, ma ka alua ro wane fua kera ka leka oku. ");
INSERT INTO far_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ma sa Jesus ka fata talingai fuada ka 'uri, “Nao kamulu si ngalia ta ru fuana lekalae ne, taifilia fa kubau go ne mulu kai ngalia. Ma nao mulu si ngalia fanga, ma ta ngwai, ma ta malefo. ");
INSERT INTO far_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kamulu kai rufia tae butu ki, boroi ma mulu si ngalia lau ruana 'aba maku falu. ");
INSERT INTO far_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ma kada ta wane nia kwalo kamulu, mulu ka to fainia, leka ka dao ana kada mulu kai leka fasia na fere nai. ");
INSERT INTO far_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ma dia kamulu dao ana na fere, ma wane ki senai nao si kwalo kamulu, naoma kera ka noni'ela ana rongolana fatalamulu, mulu ka leka 'amulu fasida. Ma mulu ka tafusia gegeona ano fasia na 'aemulu dia na fabasue fuada ne God nia kai keto kera.” ");
INSERT INTO far_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ma kera ka leka, ma kera ka fulangainia fua wane ki fua kera ka kari abulo fasia ta'alae kera ki. ");
INSERT INTO far_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ma kera ka ifulangainia anoeru ta'a 'oro ki, kera ka ngwaia wane matai 'oro ki, ma kera ka gurada lau. ");
INSERT INTO far_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Iu, sa Herod na kingi nia rongoa ru ne ki sulia sa Jesus ne nia famanata ma ka gura wane ki. Ma satana sa Jesus ka talofia fere ki tafau. Ma tani wane kera ka 'uri, “Sa Jon wane ni Siuabu nia mauri lau! Nia ne ka sasia lau fanadae ki.” ");
INSERT INTO far_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ma tani wane lau kera ka fata 'uri, “Nia sa Elaeja.” Ma tani wane kera ka fata 'uri, “Nia ta profet, dia profet be 'i nao ki mai.” ");
INSERT INTO far_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ana kada sa Herod nia rongoa ru nai ki ne wane ki fata 'urinai sulia sa Jesus, nia ka fata 'uri, “Sa Jon na wane be nau ku kwatea fuana siki musilana luana, nia tatae lau fasia na maea ne.” ");
INSERT INTO far_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","'I nao mai, sa Herod nia adea ni Herodias, na 'afe saoana nia sa Filip. Ma sa Jon ka fata fatai 'uri fuana sa Herod, “Na taki God nia luia 'oe nao si adea 'afe saoana 'oe.” 'Urinai, manatana ni Herodias ka ta'a 'asiana fuana sa Jon, ma nia ka doria saungilana, boroi ma nia 'afitai 'asiana fuana, sulia sa Herod nia saitamana sa Jon nia na wane 'o'olo, ma na wane ne nia abu. Sa Herod nia maungia sa Jon, ma nia ka konia sa Jon. Sa Herod talana ne nia odua wane ki fuana daulana sa Jon, ma kera ka alua laona beu ni kanie fasia ni Herodias. Iu, sa Herod nia doria 'asiana rongolana sa Jon, boroi 'ana nia manata 'abero kada ne nia rongoa farongoe nai. ");
INSERT INTO far_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Go ma ni Herodias ka dao to'ona te kada lea nia fuana saungilana sa Jon. Ana fa dangi ne sa Herod nia fabaita maedangi ne nia futa ana, nia ka saungainia te fafanga fuana wane baita nia ki, ma na wane baita nia ki fuana firulae, ma na fanaonao ki ne kera to 'i laona lofaa 'i Galili. ");
INSERT INTO far_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ma kada ne, na sari ni Herodias nia ru mai ma ka ngwae, sa Herod fainia wane nia ki ne kera fanga fainia, kera eele 'asiana fainia. Ma sa Herod ka fata 'uri fuana keni sari nai, “'Oe gani nau mai 'uria ta te ne 'oe doria, nau ku kwatea fuamu.” ");
INSERT INTO far_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ma nia ka fata alangai fuana ka 'uri, “Ta te ne 'oe gania aku, nau ku kwatea fuamu, sui boroi 'ana ta bali ana na 'initoe nau.” ");
INSERT INTO far_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ma na keni sari nai ka ru kau 'i maa ka leka na siana gaa nia, ma ka ledi 'uri, “Ta te ne nau kai gania?” Ma gaa nia ka olisia ka 'uri, “Na gwauna sa Jon wane ni Siuabu.” ");
INSERT INTO far_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ma na keni sari nai ka oli 'ali'ali siana sa Herod, ma ka gani 'uri, “Nau ku doria 'oe kwatea mai na gwauna sa Jon wane ni Siuabu fuaku 'i fafona tae ru ana kada nai na.” ");
INSERT INTO far_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ma sa Herod ka kwaimanatai 'asiana sulia ru nai. Sui boroi 'ana, sulia na fata alangaie ne nia sasia 'i naona na wane ki ne kera fanga fainia, nia si luia na fasia. ");
INSERT INTO far_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ma nia ka kwatea te wane ni omee fuana ngalilana mai na gwauna sa Jon. Ma na wane nai ka leka 'i laona na beu ni kanie, ma ka siki musia luana sa Jon, ");
INSERT INTO far_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ma ka ngalia mai na gwauna 'i fafona na tae ru, ma ka kwatea fuana keni sari nai, ma nia ka kwatea fuana gaa nia. ");
INSERT INTO far_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ma kada ne fafurongo sa Jon ki kera rongoa ru nai, kera leka mai, ma kera ka ngalia na nonina, ma kera ka faitolia na. ");
INSERT INTO far_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lifurongo ki kera oli na mai, ma kera ka oku tafau mai siana sa Jesus, ma kera ka farongoa 'ana ru ne kera sasia, ma kera famanata sulia ki. ");
INSERT INTO far_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Sa Jesus fainia na fafurongo nia ki, kera 'abero 'asiana, sulia ne wane 'oro ki kera daofa oli ana kula ne kera to ana. Ma sa Jesus fainia na fafurongo nia ki, kera nao si to na ana ta kada fua fangalae boroi. Ma sa Jesus ka fata 'uri fuada, “Mulu leka mai fai nau 'uria ta kula buringai, fua kulu ka mamalo basi 'akulu.” ");
INSERT INTO far_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ma kera ka leka taifilida ana baru 'uria kula ne nao ta wane si to ana. ");
INSERT INTO far_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ka 'urinai boroi 'ana, wane 'oro ki fasia fere ki tafau kera suada kada kera leka, ma kera ka lae 'i naoda, ma kera ka eta dao 'ada senai. ");
INSERT INTO far_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ma kada sa Jesus nia koso fasia na baru, nia ka ada to'ona na fikue baita nai, ma nia ka kwaimanatai 'asiana fuada, sulia kera dia sipsip ki ne nao ta wane fuana adalae sulida. Ma nia ka famanata kera ana ru 'oro ki. ");
INSERT INTO far_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma kada ne na sato nia tio folo na, fafurongo nia ki kera ka leka mai siana, ma kera ka fata 'uri, “Kula ne, nao ta wane si to ana, ma nia karangi ka rodo na. ");
INSERT INTO far_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'Oe kwatea fikue ne kera leka na 'ada, fua kera ka leka ana mae fere ne kalikalia ki, fua kera ka foli fanga.” ");
INSERT INTO far_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Boroi ma nia olisida ka 'uri, “Kamulu ka kwatea fanga fuada.” Ma kera ka ledi 'uri ana, “'Uri ma 'oe doria kalu kai kwatea mai malefo 'oro ki fuana folilana beret fua ka bobola fainia fafangalana fikue ne?” ");
INSERT INTO far_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ma sa Jesus ka ledi kera ka fata 'uri, “Ta fita fa beret ne kamulu to ana? Leka mulu ka ada mai 'uria.” Ma kada kera dao to'ona, kera ka fata 'uri, “Lima fa beret ki go fainia ro gwa ie ki.” ");
INSERT INTO far_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","'Urinai sa Jesus ka saea fuana fafurongo nia ki fua kera saea fuana wane ki kera ka gouru 'i ano ana gwa tolae ki 'i fafona na garasi. ");
INSERT INTO far_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ma kera ka gouru 'i ano ana talangai wane ki, ma tani gwa tooa lima akwala wane ki. ");
INSERT INTO far_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ma sa Jesus ka ngalia lima fa beret nai ki ma ro gwa ie nai ki, ma ka ada 'alaa 'uria 'i langi, ma ka tangoa God. Ma nia ka ngiia fa beret nai ki, ma ka kwatea fuana fafurongo nia ki, fua kera ka tolingia fuana tooa ki. Ma nia ka tolingia laugo ro gwa ie nai ki fuada. ");
INSERT INTO far_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ma wane 'oro nai ki kera ka fanga, ma kera ka abusu tafau na. ");
INSERT INTO far_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Sui na fafurongo nia ki kera ka konia na orongana beret ma ie nai ki, ma kera ka fafungua te akwala ma ro kukudu ki. ");
INSERT INTO far_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Lima to'oni wane ki ne kera fanga. ");
INSERT INTO far_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ma burina ru nai, sa Jesus nia saea fua fafurongo nia ki kera ka eta 'i nao 'uria ta bali ana 'osi nai laona baru 'uria fere 'i Betsaeda. Ma nia ka to 'i buri fua ka saea fuana fikue nai kera ka leka na 'ada. ");
INSERT INTO far_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma burina nia alualu ana wane 'oro nai ki, nia ka leka 'i gwauna ta fa uo fua ka foa 'ana. ");
INSERT INTO far_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma kada nia safali ka rodo na mai, na baru be nia na laona tofungana 'osi, ma sa Jesus to ga 'ana 'ua mai gwauna fa uo. ");
INSERT INTO far_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ma nia ka ada to'ona fafurongo nia ki, kera ulafu 'asiana ana falutalae, sulia kera sualia na kuburu. Ma ana kada rodo karangi 'ofodangi, sa Jesus ka leka 'i fafona kafo, ma ka leka mai fuada. Ma nia 'e karangi kai liufida na. ");
INSERT INTO far_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ma ana kada kera ada to'ona ne 'e leka 'i fafona na kafo, kera ka kwaisae nia na anoeru. Ma kera ka akwa baita, ");
INSERT INTO far_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","sulia kera mau 'asiana, ana kada kera ada to'ona ne nia 'e leka fafona kafo. Ma sa Jesus nia ka 'ali'ali ma ka fata kau fuada ka 'uri, “Nau ga 'ana ne! Nao mulu si mau lau.” ");
INSERT INTO far_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'Urinai go, nia ka ra 'i laona na baru faida, ma na kuburu ka aroaro na. Ma kera ka kwele 'asiana na ");
INSERT INTO far_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","sulia nao kera si susulia fadalana fanadae ne sa Jesus nia sasia fua sangonilana lima to'oni wane be ki ana lima fa beret ki go. Sulia manatalada 'e dole 'asiana fuana malingailana na ru ne kera ada to'ona. ");
INSERT INTO far_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kera tofolo ana 'osi nai, ma kera ka koso ana fere 'i Genesaret, ma kera ka gwalua na baru 'i senai. ");
INSERT INTO far_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ma kada kera fasia na baru, wane senai ki, kera lae 'ali'ali kera ka ada saitamana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ma wane ki kera ka lae laona bali lofaa nai, ma kera ka ngalia mai wane matai ki fafona 'ifitai ki 'uria kula ne kera rongoa sa Jesus nia to ana. ");
INSERT INTO far_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ma kula ki tafau ne wane ki kera ngalia mai wane matai ki 'uria maana usie ki, ma kera ka gania sa Jesus fuana wane matai ki fua kera ka samo to'ona maku gwala nia. Ma na wane ki tafau ne kera samo to'ona ma kera ka 'akwa na. ");
INSERT INTO far_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na Farasi ki ma tani wane famanata ana taki ki, kera leka mai fasia 'i Jerusalem, ma kera ka oku kalia sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma kera ka ada to'ona tani wane ana fafurongo nia ki nao si taufia go 'abada 'i nao, ma kera ka fi fanga. Nao kera si taufia go 'abada dia na falafala ne Farasi ki kera saea fuana tooa Jiu ki kera kai sasi sulia. ");
INSERT INTO far_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Aia, Jiu ki ma tasa na ne Farasi ki, kera sasi sulia falafala ne koko kera ki famanata na mai ana. Nia 'afitai kera ka fanga dia nao kera si taufia 'abada dia na falafala ana tau 'abalae. ");
INSERT INTO far_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ma kada kera oli mai fasia na usie, nia 'afitai kera ka fanga, dia nao kera si tau 'aba basi sulia na falafala kera na. 'Urinai kera ka rosulia falafala 'oro kera ki, dia na taufilana titiu ki, ma fa tini ki, ma tiu ki. ");
INSERT INTO far_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","'Urinai Farasi ki, ma wane famanata ana taki ki, kera ka ledia sa Jesus ma kera ka 'uri, “'Uta ne fafurongo 'oe ki nao si rosulia na famanatalae ne koko kia ki kera alua na mai fuaka, sulia nao kera si taufia go na 'abada 'i nao sui, kera ka fi fanga?” ");
INSERT INTO far_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ma nia ka olisida ma ka 'uri, “Sa Aesaea nia fata mamana kada be nia fata suli kamulu. Kamulu na wane suke ki, dia be nia kedea ka 'uri, ‘God nia saea, na tooa ne ki, kera fabaita nau ga 'ada ana fatalada, boroi ma mangoda nia tau 'asiana fasi nau. ");
INSERT INTO far_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Kera fosi nau 'o'oni ga 'ada, sulia kera famanata ga 'ada sulia taki kera ki talada, ma kera ka saea na taki God ki na nai!’ ");
INSERT INTO far_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mulu aburongo ana taki God ki, ma mulu rosulia lalau famanatalae wane ki.” ");
INSERT INTO far_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ma sa Jesus ka fata lau 'uri fuada, “Mulu saitamana 'asiana ana noni'elalae ma talalana taki God ki, ma mulu ro lalau 'amulu sulia falafala kamulu ki talamulu. ");
INSERT INTO far_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Sulia sa Moses be nia fata 'uri, ‘'Oe fabaita na maa 'oe, ma na gaa 'oe.’ Ma, ‘Dia sa ti ne nia kwalangia na maa nia naoma gaa nia, kera kai saungia ka mae.’ ");
INSERT INTO far_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Boroi ma, mulu famanata garo 'uri, dia ta wane nia to ana tani ru ne nia saitamana kai 'adomia ana maa nia naoma gaa nia, ma ka fata lalau 'uri, ‘Nau kai kwatea na ru be ki fuana God.’ ");
INSERT INTO far_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Mulu saea, nia lea ga 'ana fuana ne nia nao si 'adomia na maa nia ma na gaa nia ana ru be ki nia eta fata alangai na fuana God. ");
INSERT INTO far_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ma dia nia 'urinai, na famanatalae ne mulu alua, nia fatu'ua na fatalana God. Ma ru 'oro ta'a 'urinai ki ne kamulu sasia.” ");
INSERT INTO far_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","'Urinai sa Jesus ka saea lau mai 'uria na okue baita nai siana, ma ka fata 'uri fuada, “Mulu fafurongo mai fuaku, fua mulu ka saitamana. ");
INSERT INTO far_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Nao ta ru ne ta wane nia kai 'ania ne nia kwatea na sualae fuana. Na ru ne sasia ta'alae ki, nia safali mai fasia na liona wane lalau, nia ne ka kwatea wane ka sua.” ");
INSERT INTO far_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ma kada sa Jesus nia fasia na fikue nai, nia ka ru laona lume, ma na fafurongo nia ki kera ka ledia fua ka fadaa na faoraie nai ki. ");
INSERT INTO far_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ma sa Jesus ka fata 'uri fuada, “'Uri ma nao kamulu si saitamana go ana ru ne ki ne? Na ru ne wane nia 'ania nao si fasua na wane 'i naona God, ");
INSERT INTO far_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","sulia na fanga nao nia si leka 'i laona na liona wane. Nia leka ga 'ana laona guina, ma 'i buri nia kai ru laugo mai 'ana fasia nonina.” Ana faoraie sa Jesus na ne, nia saea na fanga ki tafau, nia lea ga 'ana fuana 'anilana. ");
INSERT INTO far_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ma sa Jesus ka fata lau 'uri, “Te ne sakatafa mai fasia laona manatana wane ki sasia kera ka bilia 'i maana God. ");
INSERT INTO far_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sulia na manatairu ta'a ki nia mango mai fasia laona na manatana wane, ma nia ka sasia ru ta'a ki, ma nia ka beli, ma nia ka sauwanee, ma nia ka oee, ");
INSERT INTO far_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ma nia ka ogalulumi, ma nia ka sasia ru ta'a 'oro ki, ma ka sukea na wane ki, ma ka kwaifi, ma ka fata suke sulia ta wane, ma nia ka manata lafua talana, ma nia ka oewanea. ");
INSERT INTO far_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ma sulia ru 'oro ta'a nai ki tafau nia ru mai fasia na manatana, nia ka fasua na wane 'i naona God.” ");
INSERT INTO far_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sui go, sa Jesus ka leka na fasia na kula nai, ma ka leka 'uria na lofaa 'i Taea. Ma nia ka ru 'i laona te lume, sulia nao nia si doria ta wane ka saitamana ne nia to 'i senai, sui boroi 'ana nia 'afitai fuana nia ka agwa. ");
INSERT INTO far_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Ma te keni ka rongo sulia ne sa Jesus nia dao, ma nia ka leka 'ali'ali mai, ma ka boruru 'i maana 'aena sa Jesus. Ma na keni nai, nia na keni 'e'ete fasia 'i Fonisia laona bali lofaa 'i Siria, ma nia nao lau keni Jiu, ma na wele keni sari nia na anoeru ta'a 'e rufia. 'Urinai, nia ka amasia sa Jesus fua ka ifulangainia na anoeru ta'a nai fasia na wele keni sari nia. ");
INSERT INTO far_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ma sa Jesus ka fata sulia Jiu ki ne dia wele ki ka 'uri, “Kalu fafanga basi wele ki 'i nao. Nao nia si 'o'olo fua ngalilana fanga wele ki, ma ka 'ui 'ania fuana kui ki.” ");
INSERT INTO far_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ma na keni nai nia olisia ma ka 'uri, “'Aofia 'ae, kui ki boroi, kera saitamana 'ania laugo na ngingisi fanga ne 'asia farana tatafe ni fanga wele ki.” ");
INSERT INTO far_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sui sa Jesus ka fata 'uri fuana, “'Oe oli 'amu 'i fere 'oe. Na anoeru ta'a be, nia leka na fasia na wele keni sari 'oe. Sulia olisilae nai nia fatainia ne 'oe famamana.” ");
INSERT INTO far_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ma nia ka oli 'i fera, ma ka ada to'ona ne na wele keni sari be nia tio ga 'ana 'i laona 'ifitai. Ma na anoeru ta'a be 'e leka mamana na fasia. ");
INSERT INTO far_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sui sa Jesus nia fasia na bali fere 'i Taea, ma ka daofa liu fasia 'i Saedon, ma bali fere 'i Dekapolis, ma ka koso na kau fafona na 'osi 'i Galili. ");
INSERT INTO far_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ma wane ki 'i senai, kera ka ngalia mai te wane ne alingana 'e boko ma na ngiduna ka ato siana sa Jesus, ma kera ka amasia sa Jesus fua ka alua na 'abana fafia na wane nai. ");
INSERT INTO far_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ma sa Jesus ka talaia 'uria te kula taifili keroa fasia fikue nai, ma nia ka kurumainia na kakauna 'i laona na alingana wane nai. Ma nia ka ngisufia na kakauna, ma ka samo to'ona meana. ");
INSERT INTO far_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Go, nia ka ada 'alaa 'uria 'i langi, ma ka mango baita, ma ka fata 'uri fuana ana fatalana, “Efata!” Na fadalana ne 'uri, “'Ifi na!” ");
INSERT INTO far_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ma ana kada nai, alingana na wane nai ka 'ifi, ma nia ka rongo na, ma na ngiduna ka sasala na, ma nia ka safali ka fata fola na. ");
INSERT INTO far_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","'Urinai, sa Jesus ka luia na wane ki nao si farongoa lau tani wane. Sui boroi 'ana nia ka lui talingai ana, na wane ki kera ka leka fata sulia sa Jesus ne nia gura na wane nai ka leka na 'ana. ");
INSERT INTO far_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma na wane ki ne kera rongoa, kera ka kwele 'asiana, ma kera ka fata 'uri, “Nia sasia ru ki tafau ka lea 'asiana! Nia saungainia na wane ne alingana 'e boko ma ka rongo na, ma na wane ne ngiduna nia ato boroi, ka fata na.” ");
INSERT INTO far_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nao si tau go 'i burina ru nai ki, te fikue baita ka oku mai. Ma kada nai nao na ta fanga 'ada, sa Jesus ka saea mai fafurongo nia ki, ma ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nau ku kwaimanatai fuana wane ne ki, sulia kera to fai nau sulia olu maedangi ki, ma na fanga kera ka suina. ");
INSERT INTO far_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ma dia ne kera fiolo, ma nau ku olitainida 'i fera, kera kai ngwatautau ma ka maebuatamarakwa sulia taale, sulia ta bali 'ada ne fere kera ki 'e to tau.” ");
INSERT INTO far_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ma na fafurongo nia ki kera ka ledi 'uri, “Laona lofaa 'eke'eke 'uri, kulu kai dao to'ona fanga 'i fai fua ka bobola fainia wane 'oro 'uri ki?” ");
INSERT INTO far_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ma sa Jesus ledida ka 'uri, “Fita fa beret ne mulu too ana?” Ma kera olisia kera ka 'uri, “Fiu fa beret ki.” ");
INSERT INTO far_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ma sa Jesus ka saea fuana fikue nai kera ka gouru 'i ano. Go, nia ka ngalia fiu fa beret nai ki, ma ka tangoa God, sui ka ngiia ma ka kwatea fuana fafurongo nia ki, ma kera ka tolingia ana na fikue nai. ");
INSERT INTO far_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ma kera too laugo ana bara gwa ie tu'u. Ma sa Jesus ka kwatea laugo tangolae fuana God, ma ka saea fuana fafurongo nia ki kera ka tolingia laugo ana na tooa nai. ");
INSERT INTO far_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ma kera ka fanga leleka kera ka abusu tafau. Ma 'i buri, fafurongo nia ki kera ka fafungua fiu kukudu ki ana orongana fanga ne ore. ");
INSERT INTO far_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma na fikue nai, nia bobola fainia fai to'oni wane ki. Sui sa Jesus ka olitainida na 'uria fere kera ki, ");
INSERT INTO far_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ma nia fainia fafurongo nia ki, kera 'ali'ali kera ka ra 'i laona baru, ma kera ka leka 'uria na bali fere 'i Dalmanuta. ");
INSERT INTO far_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma tani Farasi kera leka mai, ma kera ka olisusu fainia sa Jesus, ma kera doria fua kera ka ilito'ona. Nia ne kera ka gania fua nia ka fulia ta fanadae, fua ka fatainia God ne odu nia mai. ");
INSERT INTO far_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","'Urinai sa Jesus ka mango baita, ma ka fata 'uri, “'Uta ne wane ki ana unita wane ne kera ka gani 'uria fanadae ki? Nau ku saea na ru mamana fua mulu, nau nao si fatainia go ta fanadae fua unita wane ne.” ");
INSERT INTO far_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ma sa Jesus ka fasida, ma ka ra laugo 'ana 'i laona baru, ma kera ka tofolo 'uria ta bali 'osi. ");
INSERT INTO far_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kada kera tofolo 'ua, na fafurongo nia ki kera manata buro ana ngalilana mai tani fa beret, boroi ma te fa beret go ne kera to ana laona na baru. ");
INSERT INTO far_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ma sa Jesus ka fabasuda ma ka 'uri, “Mulu kai ada lea suli kamulu fasia na isi fuana beret ana Farasi ki ma sa Herod laugo.” ");
INSERT INTO far_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ma kera ka fata 'i safitada kwailiu, ma kera ka 'uri, “Nia fata 'urinai sulia ne nao kulu si ngalia mai ta fa beret.” ");
INSERT INTO far_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma kada sa Jesus nia saitamana ne kera ulafusia ne nia fata sulia famanatalae ta'a Farasi ki ma sa Herod, nia ka fata 'uri fuada, “'Uta ne kamulu ka fata sulia ne nao mulu si ngalia mai tani fa beret? Nao mulu si susulia go ru be ki nau ku saea fua mulu? Nau ku ada to'ona manatamulu 'e doledole 'asiana fua mulu ka famamana. ");
INSERT INTO far_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mulu ada to'ona ma mulu ka rongoa ru 'oro ne nau ku sasia ki, boroi ma mulu nao si ada saitamana go. Nao mulu si manata to'ona ");
INSERT INTO far_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","kada be nau ku ngiia lima fa beret be ki fuana lima to'oni wane be ki? Ma ta fita kukudu be kamulu konia orongana fanga be 'i laona leleka ka fungu?” Ma kera ka olisia ka 'uri, “Te akwala ma ro kukudu.” ");
INSERT INTO far_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ma sa Jesus nia ledi lau ka 'uri, “Ma kada be nau ku ngiia fiu fa beret ki fuana fai to'oni wane ki, fita kukudu ki be mulu konia orongana fanga 'i laona leleka ka fungu?” Ma kera olisia kera ka 'uri, “Fiu kukudu ki.” ");
INSERT INTO far_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ma nia ka ledi 'uri ada, “'Uta ne nao mulu si saitamana 'ua na te ne nau ku fata sulia?” ");
INSERT INTO far_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Kera dao ana na fere 'i Betsaeda, ma wane ki kera ka ngalia mai te wane ne maana nia rodo, ma kera ka gania sa Jesus fua ka samo to'ona. ");
INSERT INTO far_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ma sa Jesus ka dau 'i 'abana na wane nai, ma ka talaia 'uria 'i maa fasia na fere nai. Ma sa Jesus ka ngisu 'i laona na maana na wane nai, ma nia ka alua na 'abana fafia. Sui, nia ledia ka 'uri, “'Oe ada to'ona ta ru?” ");
INSERT INTO far_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Go, na wane be nia ka ada 'alaa, ma ka fata 'uri, “Nau ku ada to'ona na wane ki, kera dia 'ai ki, ma kera fali.” ");
INSERT INTO far_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","'Urinai sa Jesus ka alua lau na 'abana fafia na maana na wane nai. Ma na wane nai ka ada mamana na, ma ka ada madakwa na ana ru ki tafau. ");
INSERT INTO far_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ma sa Jesus ka saea fuana, “'Oe leka na 'i lume 'oe. Nao 'oe si oli lau lao fere be.” ");
INSERT INTO far_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sui sa Jesus ma na fafurongo nia ki, kera ka leka 'uria fere ki kalikalia na fere 'i Sesarea Filipae. Ma ana kada kera leka 'ada, nia ka ledia fafurongo nia ki ka 'uri, “'Uri ma wane ki kera sae nau ana sa ti ne?” ");
INSERT INTO far_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ma kera ka olisia kera ka 'uri, “Tani wane ki kera sae 'oe ana sa Jon wane ni Siuabu ne nia mauri lau, ma tani wane kera ka sae 'oe ana sa Elaeja ne nia oli lau, ma tani wane lau kera ka sae 'oe ana ta wane ana profet be ki ne nia mauri lau.” ");
INSERT INTO far_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ma sa Jesus ledida lau ka 'uri, “Ma kamulu, sae nau mone ana sa ti?” Ma sa Pita ka olisia ka 'uri, “'Oe na Christ, na wane God nia filia fuana 'afilana wane nia ki.” ");
INSERT INTO far_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ma sa Jesus ka fata talingai fuada ka 'uri, “Nao mulu si farongoa lau ta wane suli nau.” ");
INSERT INTO far_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ma sa Jesus ka safali fuana famanatalana fafurongo nia ki ka 'uri, “Nau, na Wele nia Wane, nau kai nonifi ana ru 'oro ki. Ma fanaonao ki, fataabu baita ki, ma wane famanata ana taki ki, kera kai noni'ela aku. Ma kera kai saungi nau, ma ana oluna maedangi, nau kai tatae fasia maea.” ");
INSERT INTO far_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ma nia ka fata madakwa sulia ru nai. Ma sa Pita ka talaia tu'u kau, ma ka balufia. ");
INSERT INTO far_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Boroi ma sa Jesus nia abulo, ma ka ada fuana fafurongo nia ki, ma ka balufia sa Pita ka 'uri, “Saetan 'ae, leka tau kau fasi nau. Na manata 'oe ki, manatalana wane ki go 'ana, nia nao lau na manatairu God.” ");
INSERT INTO far_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Go 'urinai, sa Jesus ka saea mai na fikue nai ma na fafurongo nia ki siana, ma ka fata 'uri, “Sa ti boroi 'ana ne doria kai leka buriku, nao nia si manata 'abero sulia ru nia doria ki ga 'ana talana. Nia kai nonimabe fuana lekalae 'i buriku, sui boroi 'ana kada nia kai nonifi, ma kai mae ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Sa ti boroi 'ana ne noni'ela si leka buriku sulia nia doria ka sasi 'ana sulia kwaidoria nia ki tala'ana, nia kai talafia na maurie firi. Boroi ma dia sa ti boroi 'ana ne nonimabe fua ka mae fuaku ma fuana Farongoe Lea ne, nia kai too ana maurie firi. ");
INSERT INTO far_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Dia ne na wane ka too ana ru ki tafau laona molagali, ma nia mae, ma nia to tau fasia God, ru nai ki nao si fulia go ta lealae fuana. ");
INSERT INTO far_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nao ta wane si bobola fua folilana na maurie firi ana ta malefo. ");
INSERT INTO far_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma dia ta wane nia 'eke ani nau fainia fatalaku 'i laona maedangi ta'a ne ki, ne wane ki nao si fosia God, 'urinai ana kada nau ku dao mai fainia na ngwasinasinae Maa nau, ma 'ainsel abu ki, nau, na Wele nia Wane, nau kai 'eke laugo ani nia.” ");
INSERT INTO far_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Go sa Jesus ka fata lau ka 'uri, “Nau ku saea na fua mulu, tani wane amulu 'i seki laugo, kera nao si mae leka kera ka ada to'ona God ka gwaungai ana wane nia ki ana nikilae nia.” ");
INSERT INTO far_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","'I burina ono maedangi ki, sa Jesus ka talaia sa Pita, ma sa Jemes, ma sa Jon, ma kera ra 'uria gwauna te fa uo ne fane, ma kera ka to taifilida 'i senai. Ma ana kada kera ada, kera ka ada to'ona sa Jesus nia tatala 'i naoda, ");
INSERT INTO far_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ma na maku nia ka ngwasinasina, ma ka kwao 'asiana. Ma nia kwao ka liufia ta maku kwao ne ta wane laona fere ne 'i ano ne kai taufia. ");
INSERT INTO far_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ma na olu fafurongo nai ki kera ka ada to'ona sa Elaeja ma sa Moses, keroa dao fatai mai siada, ma keroa ka fata fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ma sa Pita ka fata 'uri fuana sa Jesus, “Wane Famanata 'ae, nia lea 'asiana fua kalu ka to amalu 'i seki. Alu kalu kai saungainia olu 'o'obe ki, ta ai fuamu, ta ai fuana sa Moses, ma ta ai fuana sa Elaeja.” ");
INSERT INTO far_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Sa Pita nia fata 'urinai, sulia nao nia si saitamana na ta ru ne nia kai saea, sulia kera mau 'asiana na. ");
INSERT INTO far_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ma te gwa dasa ka dao mai ma na nunufi fafida. Ma te lingeru nia talo mai fasia na gwa salo nai ma ka 'uri, “Na wele mutai nau ne nau ku kwaimani 'asiana ana. Mulu rongo sulia nia!” ");
INSERT INTO far_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma kera ka ada 'ali'ali kalikalida, ma kera si ada to'ona na ta wane faida, taifilia go sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kada kera koso na mai fasia fa uo nai, sa Jesus ka fata luida ka 'uri, “Nao mulu si farongoa ta wane ana ru ne mulu ada to'ona, leka ka dao ana kada ne nau, na Wele nia Wane, nau tatae fasia na maea.” ");
INSERT INTO far_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ma kera ka rosulia na fatalana, ma kera ka fata 'i safitada kwailiu, ma kera ka 'uri, “Na manatae wane 'uta ne nia saea, ‘Nau tatae fasia na maea?’” ");
INSERT INTO far_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ma kera ka ledia, kera ka 'uri, “'Uta ne wane famanata ana taki ki saea sa Elaeja kai oli lau mai, sui na wane be God filia fi leka mai?” ");
INSERT INTO far_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ma sa Jesus ka olisida ma ka 'uri, “Sa Elaeja ne kai eta mai 'i nao, fua ka sasi akau ana ru ki tafau. Boroi ma mulu si rongoa be na Kekedee Abu be saea ne, Wele nia Wane nia kai nonifi ma na wane ki kera kai subutainia. ");
INSERT INTO far_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nau ku saea fua mulu, sa Elaeja nia eta dao na, ma na wane ki kera sasia na ru ta'a ne kera doria kera ka sasia ana, dia Kekedee Abu be nia fata na mai sulia.” ");
INSERT INTO far_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ma kada kera dao mai fuana 'afutana fafurongo ki, kera ka ada to'ona te fikue baita kera oku kalida. Ma tani wane famanata ana taki ki kera olisusu faida. ");
INSERT INTO far_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ma kada ne wane ki kera ada to'ona sa Jesus, kera ka kwele 'asiana, ma kera ka lae kau, ma kera ka kwalo nia mai. ");
INSERT INTO far_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ma sa Jesus ka ledia fafurongo nia ki ka 'uri, “Ru 'uta ne mulu olisusu faida fafia?” ");
INSERT INTO far_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ma te wane 'i laona na fikue nai, nia olisia ka 'uri, “Famanata 'ae, nau ku ngalia mai wele fi baita nau fuamu. Na anoeru ta'a nia rufia, ma nao nia si fata na. ");
INSERT INTO far_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ma kada na anoeru ta'a nai nia dao ana, nia ka 'ui ana 'i ano. Ma na ngiduna ka ngisungisua, nia ka 'ala girigiri ana lifona, ma na nonina ka gaga'ai tafau. Nau ku gania fafurongo 'oe ki fuana ifulangailana fasia, boroi ma nia 'afitai 'asiana fuada.” ");
INSERT INTO far_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ma sa Jesus ka saea fuada ka 'uri, “Mulu nao si famamana nau 'ua! Nau ku noni kulua na ana abu fitoe ne kamulu. Nau ku to fai kamulu ka dao na 'uri, fulina kamulu ka famamana nau na. Ngalia mai na wele nai fuaku.” ");
INSERT INTO far_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ma kera ka ngalia mai na wele nai fuana sa Jesus. Ma kada ne anoeru ta'a nai nia ada to'ona sa Jesus, nia ka 'ui 'ania na wele nai 'i ano, ma ka ladalada, ma na ngiduna ka ngisungisua tafau na. ");
INSERT INTO far_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ma sa Jesus ka ledia na maa wele nai ka 'uri, “'I angita ne nia safali 'uri?” Ma nia ka olisia ka 'uri, “Nia 'ita na mai 'ua ana kada nia tu'u. ");
INSERT INTO far_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ma kada 'oro ne nia 'ui 'ania laona na ere ma 'i laona na kafo, fua ka saungia ka mae. Ma dia nia bobola ga 'ana fuamu, 'oe manatai karo mai, ma 'oko kwai'adomi 'amaro.” ");
INSERT INTO far_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ma sa Jesus ka fata 'uri, “Iu, nau ku bobola. 'Oe famamana nau! Na ru ki tafau nia ngwaluda ga 'ana fuana sa ti ne nia famamana nau.” ");
INSERT INTO far_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ma 'ali'ali go maa wele nai ka akwa ka 'uri, “Nau ku famamana! Boroi 'ana 'adomi nau mai, fua ne famamanae nau kai nikila ma ka lalifu!” ");
INSERT INTO far_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ma kada sa Jesus ada to'ona na fikue nai kera lae 'ali'ali mai 'uria kula nai, nia ka fata 'uri fuana anoeru ta'a nai, “'Oe na anoeru ne 'oe fabania alingana wele ne, ma 'oe fanofoa na ngiduna wele ne, nau ku eresi 'oko ru mai 'i maa, ma 'oe oli si rufia lau na wele ne.” ");
INSERT INTO far_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ma na anoeru ta'a ne ka akwa, ma ka lebetainia na wele nai, ma ka ru na mai 'i maa fasia. Ma na wele nai, na adalae to'ona ka dia na ne nia mae. Ma na wane 'oro kera ka fata 'uri, “Nia mae na.” ");
INSERT INTO far_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Boroi ma, sa Jesus ka dau ana 'abana na wele nai, ma ka taea, ma nia ka tatae. ");
INSERT INTO far_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ma kada sa Jesus nia ru laona lume, na fafurongo nia ki kera ka ledia kada kera to taifilida ma kera ka 'uri, “'Uta ne nia 'afitai fua malu fuana ifulangailana na anoeru ta'a be?” ");
INSERT INTO far_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ma sa Jesus ka olisida ka 'uri, “Takafilia folae go ne nia bobola fainia ifulangailana na anoeru ta'a 'uri ki, ma nao lau ta ru.” ");
INSERT INTO far_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Kada nai, sa Jesus ma na fafurongo nia ki kera fasia kula nai, ma kera ka leka ka liu na 'uria bali fere 'i Galili. Ma sa Jesus si doria ne ta wane kai saitamana kula ne kera to ana, ");
INSERT INTO far_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","sulia nia famanata fafurongo nia ki ka 'uri, “Nau, na Wele Nia wane, kera kai kwate nau fuana malimae nau ki, ma kera kai saungi nau. Ma burina olu maedangi ki, nau kai tatae lau fasia maea.” ");
INSERT INTO far_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Boroi ma fafurongo sa Jesus ki nao si saitamana na te ne nia saea, ma kera ka mau ana ledilana. ");
INSERT INTO far_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ma kada kera dao ana fere 'i Kapaneam, ma kera ka ru 'i laona lume, sa Jesus ka ledia na fafurongo nia ki ka 'uri, “Na te be kamulu olisusu mai fainia sulia na taale?” ");
INSERT INTO far_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Boroi ma kera si saea ta ru, sulia kera olisusu mai fainia sa ti ada ne kai baita ka gwaungai fafida tafau. ");
INSERT INTO far_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ma sa Jesus ka gouru 'i ano, ma ka saea mai na akwala ma ro fafurongo be nia ki siana, ma ka fata 'uri, “Dia sa ti ne nia doria kai fanaonao, nia kai alu nia ka 'isi, ma nia na wane ni rao fuana wane ki tafau.” ");
INSERT INTO far_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Sui sa Jesus ka talaia mai te wele, ma ka fauua safitada. Nia ka ofia na wele nai, ma ka fata 'uri fuada, ");
INSERT INTO far_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Dia sa ti ne kai kwaloa ta wele tu'u 'uri ana sataku, nia kwalo nau laugo. Ma dia sa ti ne nia kwalo nau, nao nia si kwalo nau lau taifili nau, boroi ma nia kwaloa laugo God ne nia odu nau mai.” ");
INSERT INTO far_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Sa Jon nia fata 'uri fuana sa Jesus, “Wane Famanata 'ae, kalu ada to'ona te wane nia ifulangainia na anoeru ta'a ki ana satamu. Ma kalu ka luia fasia sasilana, sulia nia nao lau ta wane ana tooa kulu.” ");
INSERT INTO far_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ma sa Jesus ka fata 'uri, “Nao mulu si luia lau, sulia sa ti ne nia sasia ta fanadae ana sataku, nia 'afitai ne nia kai saea lau ta ru ta'a aku. ");
INSERT INTO far_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Dia ta wane ne nao nia si uu bokota kulu, nia na wane fai kulu. ");
INSERT INTO far_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nau ku saea ru mamana fua mulu, dia ta wane ne nia kwatea ta titiui kafo fua mulu, sulia kamulu na wane nau ki, nia nai kai ngali mamanae ana kwaiarae nia. ");
INSERT INTO far_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Dia ta wane ka kwatea wane ne kera dia kale wele ki ka 'asia fasia fitoe kera aku, nia lea fua kera ka kania ta fau baita 'i luana, ma kera ka 'ui 'ania 'i laona na matakwa. ");
INSERT INTO far_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ma dia 'oe doria sasia ta ru ta'a ana 'abamu, 'oe siki musia fasi 'oe. Nia ta lea 'ana fuamu dia 'oe to tau 'amu laona maurie 'i langi fainia na ngunguru 'aba, tona 'uribe 'oe fi koso 'i laona kula ni kwaekwaee fainia ro 'aba ki, kula ne ere nia saru ma nao si mae na. ");
INSERT INTO far_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ma dia 'oe doria sasia ta ru ta'a ana 'aemu, 'oe siki musia fasi 'oe. Nia ta lea 'ana fuamu dia 'oe to tau 'amu laona maurie 'i langi fainia na ngunguru 'ae, fasi 'oe fi koso 'i laona kula ni kwaekwaee fainia na ro 'ae ki. ");
INSERT INTO far_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ma dia 'oe doria sasia ta ru ta'a ana maamu, 'oe lafua 'amu fasi 'oe. Nia ta lea 'ana fuamu dia 'oe ru 'i laona na 'Initoe God fainia ta bali maa, tona 'uribe 'oe fi koso 'i laona kula ni kwaekwaee fainia ro bali maa ki. ");
INSERT INTO far_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Na kula nai, na ngwongwa ki ne kera 'ania na wane ki, ma nao kera si mae, ma na ere ne nia sarufia wane ki nia saru firi. ");
INSERT INTO far_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Sulia kera alua na ere 'i fafona wane ki tafau, dia ne meme asi kera takalongainia laona ta fanga. ");
INSERT INTO far_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Ma na fiko asi nia lea mone, boroi ma dia ne mamasialana nia nao na fasia, nia 'afitai 'asia kera ka sasia ana ta ru fua ka mamasia lau. “'Urinai laugo, mulu ka faeelea wane ki dia laugo na meme asi ne falea na fanga. Ma mulu ka to ana aroaroe 'i safitamulu kwailiu.” ");
INSERT INTO far_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sui ma sa Jesus ka fasia 'i Kapaneam, ma ka leka 'uria na bali fere 'i Jiudea, ma ka tofolo ana kafo 'i Jodan. Ma wane 'oro ki kera ka oku mai siana, ma nia ka famanata kera, dia be nia 'ita ka famanata na mai. ");
INSERT INTO far_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ma tani Farasi kera leka go mai 'ada fuana ilitolana sa Jesus. Ma kera ka ledi 'uri ana, “'Uri ma, na taki sa Moses nia alamatainia ga 'ana ne wane kai lukasia 'afe nia?” ");
INSERT INTO far_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ma sa Jesus ka olisida ma ka 'uri, “Na te be sa Moses nia fata talingai fua mulu ana sulia ru ne?” ");
INSERT INTO far_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ma kera ka fata 'uri, “Sa Moses nia alamatainia ne wane ka kedea ta 'aba beba ana kwailukasilae, ma ka kwatea fua na 'afe nia, fua ka leka na ana fasi nia.” ");
INSERT INTO far_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ma sa Jesus ka fata 'uri, “Sa Moses nia kedea na taki ne fua mulu sulia nia 'afitai fua famanatalamulu. ");
INSERT INTO far_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Boroi ma, 'ita na mai ana kada God nia saungainia na ru ki tafau, na Kekedee Abu nia saea, ‘Nia saungainia wane ki ana welewane ma keni. ");
INSERT INTO far_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Sulia ru nai, wane ka fasia na maa nia fainia gaa nia, ma ka to 'ado fainia na 'afe nia, ");
INSERT INTO far_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ma keroa ka alua te manatairu dia te wane go.’ Nia nao lau ta ro wane 'e'ete, boroi ma dia te wane na. ");
INSERT INTO far_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nia ne, ru God nia kani okua ka suina, nao si lea fuana ta wane ka lugea lau.” ");
INSERT INTO far_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ma kada sa Jesus fainia na fafurongo nia ki kera oli 'i lume, kera ka ledia 'uria malutana ru nai. ");
INSERT INTO far_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ma nia ka olisida ka 'uri, “Ta wane boroi 'ana ne nia lukasia na 'afe nia, ma ka adea lalau ta 'afe 'e'ete, nia oee na fafia na 'afe nia. ");
INSERT INTO far_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ma nia 'urinai laugo, dia ta 'afe nia lukasia na arai nia, ma ka 'afe lau fuana ta wane 'e'ete, nia oee na fafia na arai nia.” ");
INSERT INTO far_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tani wane kera ngalia mai na kaela wele tu'u siana sa Jesus, fua ka alua na 'abana fafida ma ka faleada, boroi ma fafurongo nia ki kera ka balufida. ");
INSERT INTO far_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ma kada sa Jesus nia ada to'ona ru nai, nia ka guisasu, ma ka fata 'uri fuada, “Mulu 'e alamatainia na kaela wele tu'u kera ka leka mai siaku, ma nao kamulu si susida lau. Sulia sa ti ne nia fito ka dia wele tu'u ki, nia bobola fuana tolae laona 'Initoe God. ");
INSERT INTO far_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nau ku saea ru mamana fua mulu, dia ta wane ne nao nia si fito dia ta wele tu'u, nia 'e 'afitai 'asiana fua nia ka ru 'i laona na 'Initoe God.” ");
INSERT INTO far_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ma nia ka ofia na wele tu'u nai ki, ma ka alua na 'abana fafida, ma ka faleada. ");
INSERT INTO far_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kada sa Jesus nia safali ka leka lau kau sulia na taale, te wane nia lae mai, ma ka boruru 'i naona. Ma nia ka ledia ka 'uri, “Wane famanata lea 'ae, ta te lea ne nau ku sasia fua nau ku too ana na maurie firi?” ");
INSERT INTO far_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ma sa Jesus olisia ka 'uri, “'Uta ne 'oe sae nau ana wane lea? Nao ta wane si lea go, taifilia God go ne nia lea. ");
INSERT INTO far_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nia lea 'oe saitamana faoraie talingai God ki be 'uri, ‘'Oe si sauwanee, ma 'oe si oee, ma 'oe si beli, ma 'oe si suke fafia ta wane, ma 'oe si sukea ta wane, ma 'oe fuusi baita ana maa 'oe ma gaa 'oe.’” ");
INSERT INTO far_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ma nia ka fata 'uri, “Wane Famanata 'ae, nia safali mai ana kada nau ku tu'u, nau ku rosulia na taki nai ki tafau.” ");
INSERT INTO far_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Go, sa Jesus ka ada kau fuana ana kwaimanie, ma ka fata 'uri fuana, “Te ru go ne nia nao 'ua. 'Oe leka kau, ma 'oe fafoli ana na ru be 'oe ki tafau, ma 'oe ngalia malefo nai ki, ma 'oe kwatea fuana wane siofa ki, ma 'oe fi too ana na toorue 'i langi. 'Urinai go, 'oe leka na mai suli nau.” ");
INSERT INTO far_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ma kada ne wane nai nia rongoa go ru nai ki, na maana ka kuku na. Ma nia ka leka na 'ana fainia na kwaimanataie, sulia ne nia na wane todaru 'asiana. ");
INSERT INTO far_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sui ma sa Jesus ka ada fuana fafurongo nia ki, ma ka fata 'uri, “Nia 'afitai 'asiana fuana wane todaru ki kera kai ru laona 'Initoe God.” ");
INSERT INTO far_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ma na fafurongo nia ki kera ka kwele 'asiana ana faoraie nai ki. Sui sa Jesus ka fata lau 'uri fuada, “Wele nau ki 'ae, nia 'afitai 'asiana fua na rulae laona 'Initoe God. ");
INSERT INTO far_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Nia 'afitai 'asiana fua ta kamel kai ru sulia na mae kwakwa tu'u ana nile. Nia 'afitai ka liufia lau fuana ta wane todaru kai ru 'i laona na 'Initoe God.” ");
INSERT INTO far_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ma na fafurongo nia ki kera ka kwele 'asiana. Ma kera ledi kwailiu ada, kera ka 'uri, “'Urinai ma nao ta wane go ne kai toda maurie firi?” ");
INSERT INTO far_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ma sa Jesus ka ada fuada, ma ka fata 'uri, “Nia 'afitai fuana wane ki kai toda maurie firi, boroi ma fuana God nao nia si 'afitai go. Na ru ki tafau nia ngwaluda ga 'ana fuana God.” ");
INSERT INTO far_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ma sa Pita ka fata 'uri fuana, “Kalu fasia na toorue kalu ki tafau fua kalu ka leka suli 'oe na!” ");
INSERT INTO far_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ma sa Jesus ka olisia ka 'uri, “Iu, nau ku saea fua mulu, dia ta wane ne kai fasia na lume nia, naoma na wanefuta nia ki, naoma na waiwane nia ki, naoma na maa nia, naoma gaa nia, naoma na wele nia ki, naoma na ano nia suli nau, fainia na Farongoe Lea ne, ");
INSERT INTO far_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nia ne kai ngalia lau ru nai ki ka 'oro ka liufia kada ne. Nia ne kai ngalia ru 'oro ana na lume ki, ma na wanefuta ki, ma na waiwane ki, ma gaa ki, ma na wele ki, ma na ano. Ma nia ne kai dao to'ona laugo nonifie ki. Ma ana kada ne kai dao mai, nia kai too ana maurie firi. ");
INSERT INTO far_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Boroi 'ana na wane 'oro ne kera eteta ki, kera kai 'isi, ma na wane 'oro ne kera 'isi, kera kai eteta.” ");
INSERT INTO far_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sa Jesus fainia na fafurongo nia ki, kera leka sulia na taale 'uria 'i Jerusalem, ma sa Jesus ka eta 'i nao ada. Ma fafurongo nia ki kera ka kwele 'asiana, ma tani wane laugo ne kera leka kau 'i burida, kera ka mau 'asiana. Ma sa Jesus ka talaia na akwala ma ro fafurongo nia ki ka ta 'idu tau lau kau fasia wane ki. Ma nia ka fi farongoda ana na ru ki ne kai fuli fuana. ");
INSERT INTO far_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ma nia ka fata 'uri, “Mulu fafurongo! Kulu ra 'alaa 'uria 'i Jerusalem, ma kera kai 'olomaelaku, na Wele nia Wane, fuana fataabu baita ki fainia na wane famanata ana taki ki. Ma kera kai keto nau fuana maelaku, ma kera kai kwate nau fuana wane nao lau Jiu ki. ");
INSERT INTO far_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma na wane nai ki kera kai 'onionga 'ani nau, ma kera kai ngisufi nau, ma kera kai kwae nau, ma kera kai saungi nau. Ma ana oluna maedangi, nau kai tatae lau fasia na maea.” ");
INSERT INTO far_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","'Urinai go, sa Jemes ma sa Jon, ro wele sa Sebedi ki, kera ka leka mai siana sa Jesus, ma kera ka fata 'uri, “Wane Famanata 'ae, karo doria 'oe kwatea te ru ne karo gania amu.” ");
INSERT INTO far_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ma sa Jesus ka ledi 'uri 'adaroa, “Te ne kamoro doria nau sasia fuamoro?” ");
INSERT INTO far_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ma keroa ka olisia ka 'uri, “Kada ne 'oe kai 'inito fafia molagali fainia ru ki tafau, 'oe alamatainia ta wane 'amaro kai gouru 'i bali 'o'olo amu, ma ta wane ana bali mauli amu fuana gwaungaie fafia wane ki.” ");
INSERT INTO far_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Boroi ma sa Jesus ka fata 'uri fuadaro, “Kamoro ulafusia go ru ne kamoro gania. Kamoro bobola go 'amoro fainia nonifilae ne nau kai nonifi ana?” ");
INSERT INTO far_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ma keroa olisia ka 'uri, “Karo bobola ga 'amaro fuana sasilana.” Ma sa Jesus ka fata 'uri fuadaro, “Iu, nia mamana kamoro kai nonifi laugo dia nau, ");
INSERT INTO far_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","boroi ma nao nau si filia sa ti ne kai gouru 'i bali 'o'olo aku ma seki 'i bali mauli aku. Taifilia God go ne kai kwatea kula 'urinai ki fua sa tifaida ne nia 'e sasi akau ana makwalida.” ");
INSERT INTO far_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ma kada na akwala fafurongo nia ki kera rongoa ru nai, kera ka guisasu fua sa Jemes ma sa Jon. ");
INSERT INTO far_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ma sa Jesus nia fikuda ma ka fata 'uri fuada, “Kamulu saitamana na wane gwaungai ki ne kera gwaungai fuana wane ne nao lau Jiu ki, kera to ana nikilalae, ma kera saitamana 'asiana ana usungailana wane fuana sasilana ru kera doria ki. ");
INSERT INTO far_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sui boroi 'ana, nao nia si 'urinai lau safitamulu. Dia ta wane amulu nia doria ka fanaonao, nia ka saitamana ne nia na wane rao kamulu. ");
INSERT INTO far_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ma dia sa ti amulu ne nia doria ka eteta, nia kai rao 'o'oni fuana wane ki tafau. ");
INSERT INTO far_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Suli nau, na Wele nia Wane, nau nao si leka mai fuana wane ki kera ka rao fuaku. Boroi ma nau ku leka lalau mai fua nau ku rao fuana wane ki tafau, ma nau ku kwatea na maurilaku fuana famaurilana na wane 'oro ki.” ");
INSERT INTO far_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ana kada nai, sa Jesus fainia na fafurongo nia ki kera dao na mai ana fere 'i Jeriko. Ma kada kera fasia na fere nai fainia na fikue baita nai, te wane ne maana rodo nia to ga 'ana 'i ninimana na taale fuana ganilae. Na satana sa Batimeas, na wele sa Timeas. ");
INSERT INTO far_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ma kada nia rongoa sa Jesus, na wane 'i Nasaret, nia ka leka mai, nia ka akwa ka 'uri, “Jesus 'oe na wele ana kwalafa sa Deved, 'oe manatai nau mai.” ");
INSERT INTO far_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ma na wane ki kera ka balufia, ma kera ka saea fuana fua nia ka to aroaro. Boroi ma nia ka fi akwa ka baita 'asiana ka 'uri, “Wele ana kwalafa sa Deved 'ae, 'oe manatai nau mai!” ");
INSERT INTO far_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ma sa Jesus ka uu ngado ma ka fata 'uri, “Mulu saea mai.” Ma kera akwa 'uria sa Batimeas, kera ka 'uri, “'Oe eele na amu! Tatae na, sa Jesus nia sae 'oe na.” ");
INSERT INTO far_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Go nia ka 'ui 'ania na maku fafo baita nia, ma ka tatae 'ali'ali, ma ka leka siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ma sa Jesus ka ledia ka 'uri, “Te ne 'oe doria nau ku sasia fuamu?” Ma na wane maana rodo nai olisia sa Jesus ka 'uri, “Famanata 'ae, nau ku doria nau ada lau.” ");
INSERT INTO far_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ma sa Jesus ka fata 'uri fuana, “Leka na kau amu. God nia gura 'oe na, sulia 'oe famamana nau.” Ma 'ali'ali na maana ka ada na, ma nia ka leka fainia sa Jesus sulia na taale. ");
INSERT INTO far_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kada sa Jesus fainia na fafurongo nia ki kera dao karangia na fere 'i Jerusalem, kera dao ana fere 'i Betfeis ma 'i Betani, gwauna fa uo kera saea ana 'i Olif. Go, nia ka kwatea ta ro wane ana fafurongo nia ki, kera ka eteta 'i nao. ");
INSERT INTO far_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ma nia ka fata 'uri fuadaro, “Kamoro leka ana fere loko kamoro naofia kau. Ma kada kamoro dao 'i senai, kamoro kai ada to'ona te dongki. Kera kania ga 'ada dongki nai, ma nao ta wane si ra 'ua fafona. Kamoro ka lugea, ma kamoro ka talaia mai 'i seki. ");
INSERT INTO far_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ma dia ta wane nia ledi kamoro, ‘'Uta ne kamoro ka lugea na dongki ne?’ kamoro saea fuana, ‘Na 'Aofia nia doria, ma nia kai olitainia 'ali'ali laugo mai ana 'i seki.’” ");
INSERT INTO far_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ma kera ka leka, ma kera ka ada to'ona te ka dongki kera kania ga 'ada 'i ninimana na taale 'i maana te lume. Ma kada kera lugea na, ");
INSERT INTO far_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","tani wane ne kera uu 'i senai, kera ka ledi keroa ka 'uri, “Te ne kamoro lugea na ka dongki ne fuana?” ");
INSERT INTO far_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ma keroa ka olisida dia be sa Jesus nia saea fuadaro, ma na wane nai ki kera ka alamatainia fuadaro. ");
INSERT INTO far_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ma kera ka talaia mai na ka dongki nai siana sa Jesus, ma kera ka safatainia na 'aba maku kera ki 'i fafona, ma sa Jesus ka gouru fafona. ");
INSERT INTO far_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Na wane 'oro ki kera ka safatainia na 'aba maku gwala kera ki 'i sulia na taale, ma tani wane kera ka tofua na ulina niniu ki, ma kera ka safatainia sulia na taale. Kera sasia ru nai fuana fabaitalana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma wane ki tafau ne leka fainia, tani wane kera ka eteta 'i nao, fainia tani wane ne kera 'isi, kera akwa ma kera ka 'uri, “Lafutainia God! Ma God 'oe oilakitainia na wane ne nia leka mai ana na nikilae 'oe! ");
INSERT INTO far_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ma God 'oe oilakitainia mai daolana na 'initoe ne nia dia na 'initoe sa Deved koko kia! Lafutainia God nia to 'i langi!” ");
INSERT INTO far_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sa Jesus nia ru 'i laona na fere 'i Jerusalem, ma ka leka 'i laona na Beu Abu God. 'Urinai, nia ka ada kwailiu, ma ka ada to'ona ru ki tafau. Boroi ma sulia nia karangi rodo na, nia ka leka na 'uria 'i Betani fainia na akwala ma ro fafurongo nia ki. ");
INSERT INTO far_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ma ana fa dangi 'i buri, kada sa Jesus ma na fafurongo nia ki kera oli na mai fasia 'i Betani, sa Jesus ka fiolo. ");
INSERT INTO far_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ma nia ka ada kau, ma ka ada to'ona te 'ai ulua ne kera saea ana na figi. Ma nia ka leka karangia fua ka ada to'ona ta fueru ana. Boroi ma kada nia dao 'i 'aena, nia ka ada to'ona go ana na uli ru ki, sulia kada nai na figi ki kera uli 'ato. ");
INSERT INTO far_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ma sa Jesus ka fata 'uri fuana figi nai, “Ta wane si 'ania lau ta fueru ru amu!” Ma na fafurongo nia ki kera ka rongoa ru nai. ");
INSERT INTO far_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ma kada kera dao na 'i Jerusalem, sa Jesus ka leka laona na Beu Abu God. 'Urinai, nia ka taria na wane ki tafau ne kera foli ma kera ka fafoli ana ru fuana afafue ki. Ma nia ka kefusia na tatafe ana wane nai ki ne kera talana malefo ki, ma ka kefusia na ru fuana gourue 'ana wane ki ne kera fafoli ana na fa bole ki. ");
INSERT INTO far_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ma nao nia si alamatainia ta wane kai ngalia ta ru 'i laona na Beu Abu God. ");
INSERT INTO far_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ma nia ka famanata na wane ki, ka fata 'uri, “God nia saea 'i laona na Kekedee Abu ka 'uri, ‘Na Beu nau, kera saea ana na beu fuana folae fuana wane ana molagali ki tafau.’ Boroi ma kamulu abulotainia ka alua lalau kula fuana belilana wane ki.” ");
INSERT INTO far_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ana kada, na fataabu baita ki fainia na wane famanata ana taki ki, kera rongoa ru nai, ma kera ka safali nani 'uria ta ru kera kai sasia fuana saungilana sa Jesus. Ma kera ka maungia, sulia ne fikue nai tafau, kera kwele 'asiana ana na famanatalae nia. ");
INSERT INTO far_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nia saulafi na, sa Jesus ma na fafurongo nia ki, kera ka leka na fasia 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ana 'ofodangi ana na maedangi 'i buri, sa Jesus fainia na fafurongo nia ki kera ka leka kau sulia na taale. Kera ada to'ona na 'ai figi be nia kuku tafau na leka ka koso na sulia na lalina. ");
INSERT INTO far_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma sa Pita ka manata to'ona ru be sa Jesus nia sasia ana 'ai nai, ma ka fata 'uri fuana, “Wane Famanata 'ae, ada to'ona basi na 'ai figi be 'oe agia, nia mae na!” ");
INSERT INTO far_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ma sa Jesus nia olisia ka 'uri, “Kamulu ka manata mamana na ana God. ");
INSERT INTO far_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nau ku saea fua mulu, dia kamulu ka fata 'uri fuana fa uo ne, ‘'Oe tatae, ma 'oe 'ui 'ani 'oe talamu laona na asi,’ ma nao kamulu si manata ruarua 'i laona na liomulu, ma kamulu ka manata mamana ana ru ne kamulu saea nia kai fuli, ru nai kai fuli go ana fua mulu. ");
INSERT INTO far_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nia ne, nau ku saea fua mulu 'uri, kada kamulu foa, ma mulu ka gani 'uria ta ru, kamulu ka manata mamana dia ne kamulu ngalia na, ma God kai kwatea ga 'ana ru ne kamulu gani 'uria. ");
INSERT INTO far_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Iu, kada kamulu foa, mulu ka manataluge ana ta'alae ne ta wane nia sasia amulu, fua na Maa kamulu ne nia to mai 'i langi kai manataluge laugo ana ta'alae kamulu ki.” ");
INSERT INTO far_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Sa Jesus fainia fafurongo nia ki, kera dao lau mai 'i Jerusalem. Ma kada sa Jesus leka kau 'i laona Beu Abu God, na fataabu baita ki, ma na wane famanata ana taki ki, ma na wane fanaonao ki, kera ka leka mai siana. ");
INSERT INTO far_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ma kera ka ledi 'uri ana, “Sa ti ne saea 'oe taria wane ne ki fasia laona Beu Abu? Ma sa ti ne kwatea nikilalae fua 'oko sasia ana ru ne ki?” ");
INSERT INTO far_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ma sa Jesus ka olisida ka 'uri, “Iu, nau ku ledi kamulu basi 'uria te ru. Dia kamulu olisia, nau ku fi farongo kamulu ana na nikilalae ne nau ku to ana fuana sasilana ru ne ki. ");
INSERT INTO far_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Iu, kamulu kai saea basi fuaku, na nikilalae ne sa Jon nia to ana fuana siuabulae nia safali mai fasia 'i fai? Nia safali mai ana God, naoma nia safali mai ana na wane ki go?” ");
INSERT INTO far_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ma kera ka safali ana olisusue 'i safitada kwailiu kera ka 'uri, “Te ne kulu kai saea? Dia kulu olisia ma kulu ka 'uri, ‘Fasia mai God,’ nia kai fata 'uri, ‘'Urinai ma 'uta mone ne nao kamulu si famamana sa Jon?’ ");
INSERT INTO far_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ma nao nia si lea laugo fuana ne kulu ka fata 'uri, ‘Nia safali go mai ana na wane ki.’” Kera sasi 'uri sulia kera maungia na wane ki, sulia na wane ki tafau kera famamana sa Jon nia ta profet. ");
INSERT INTO far_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nia ne, kera olisia sa Jesus ma kera ka 'uri, “Kalu ulafusia go.” Ma sa Jesus ka fata 'uri fuada, “Nau boroi nau kusi farongo kamulu laugo ana na nikilalae te ne nau ku sasia ana ru ne ki.” ");
INSERT INTO far_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sui, sa Jesus nia fata fuana wane gwaungai Jiu be ki ana tarifulae ka 'uri, “Te wane nia fasia na oole grep. Ma nia ka saungainia sakali kalia, ma ka 'elia te kilu fuana mangisilana na fue grep ki fuana saungailana ana waeni, ma ka saungainia te lume fuana folo 'usia oole. Ma nia ka alua na oole nia laona 'abana wane ki ne kera rao 'i laona. 'Urinai, nia ka leka na 'ana 'uria ta mae fere tau. ");
INSERT INTO far_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ma kada ne oole nai nia maua, nia ka kwatea na wane ni rao nia fuana wane ne kera rao 'i laona oole nia, fua ka ngalia mai tani fue grep ana 'ai ne nia fasia laona oole nai. ");
INSERT INTO far_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Boroi ma wane ni rao nai ki kera dau ngasi ana, ma kera ka kumua, ma kera ka olitainia 'o'oni ga 'ada ana. ");
INSERT INTO far_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Go, na wane be nia too ana na oole nai ka kwatea lau ta wane ni rao. Ma na wane ni rao 'i laona oole, kera ka kwaea gwauna, ma kera ka mala ta'a 'asiana ana. ");
INSERT INTO far_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","'Urinai na wane be too ana na oole, nia ka kwatea lau ta wane ni rao, ma kera ka saungia ka mae na. Ma wane 'oro ne nia oduda 'i buri ki, kera kwaea tani wane, ma ka saungia tani wane ka mae. ");
INSERT INTO far_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Iu, ma te wane na ne nia to ana fua eresilana, te wele mutai nia na ne wane nai. Ma nia ka eresia kau, ma ka manata 'uri, ‘Kera kai manata baita ana wele nau.’ ");
INSERT INTO far_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Boroi ma, wane ne kera rao 'i laona oole, kera ka fata fuada kwailiu ma kera ka 'uri, ‘Nia na ne na wele na wane be nia too ana na oole. Kulu saungia ka mae fua kulu ka ngalia 'akulu na oole ne fuaka.’ ");
INSERT INTO far_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ma kera ka ngalia na wele nai, kera ka saungia ka mae, go kera ka 'ui 'ania na nonina 'i maa fasia laona na oole nai.” ");
INSERT INTO far_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ma sa Jesus ka ledida ka 'uri, “Te ne na wane ne nia too ana na oole nai kai sasia? Nia kai dao mai, ka saungia na wane nai ki. Sui nia kai kwatea na oole nia fuana wane 'e'ete ki. ");
INSERT INTO far_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nia mamana kamulu idumia na Kekedee Abu be nia fata 'uri, ‘Na mae fau ne na wane saungai lume ki kera noni'ela ana, nia ne na fau talingai ka liufia na mae fau ki tafau ana 'odoe. ");
INSERT INTO far_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","God ne fulia ru nai, ma na adalae to'ona ka lea 'asiana.’” ");
INSERT INTO far_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Na fanaonao Jiu ki, kera doria kera ka daua sa Jesus, sulia kera saitamana ne sa Jesus nia fata ana tarifulae nai fuana kefusilada. Boroi ma, kera mau ana fikue ne, ma kera ka fasia, ma kera ka leka na 'ada. ");
INSERT INTO far_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tani fanaonao, kera kwatea tani Farasi ma tani wane ana wane sa Herod ki fuana ledilana sa Jesus fua kera ka fagaro nia. ");
INSERT INTO far_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iu, kera dao na siana, ma kera fata 'uri, “Wane Famanata 'ae, kalu saitamana ru 'oe saea ki, ru mamana ki tafau go. 'Oe famanata ga 'amu sulia mamanae ma kwaidoria God fuana wane ki. Ma 'oe si 'ado go fainia ta wane ana ta te ne kera manata sulia. Ma na wane ki sui kera bobola ga 'ada maamu. 'Oe saea basi mai fua malu! Nia 'uta? Na taki kia, nia luia na kwatelana na malefo ana takisi fuana kingi baita 'i Rom? Nia 'uta? Nia bobola fainia kalu kai kwatea takisi be, naoma 'e nao?” ");
INSERT INTO far_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Boroi ma, sa Jesus nia saitamana ga 'ana ana sukee kera, ma nia ka olisia ka 'uri, “'Uta ne kamulu ka sasi 'uria na fagarolaku? Mulu ngalia mai ta seleni. Nau ada to'ona basi.” ");
INSERT INTO far_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ma kera ka ngalia mai te seleni, ma nia ka ledida ka 'uri, “Na nununa sa ti ne? Ma na satana sa ti mone ne?” Ma kera olisia, kera ka 'uri, “Na nununa ma na satana na kingi Rom.” ");
INSERT INTO far_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ma sa Jesus ka fata 'uri, “Kamulu kwatea fuana kingi baita 'i Rom na ru nia ki, ma kamulu kwatea laugo ru God ki fuana God.” Ma kera ka kwele 'asiana ana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sui, tani Sadusi kera leka mai siana sa Jesus. Na Sadusi ki kera saea ne na wane ki nao kera si tatae oli lau fasia na maea. Ma kera ka ledia sa Jesus kera ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Wane Famanata 'ae, sa Moses nia kedea na taki fuaka ka alangai 'uri, ‘Dia ta wane nia mae, ma na 'afe nia ka mauri 'ua, boroi ma nao nia si to ana ta wele, na wanefuta nia ka adea lau na gwa 'oru nai, fua keroa ka to ana ta wele fuana ka talana na wane ne nia mae na.’ ");
INSERT INTO far_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Iu, ma ana te kada, fiu waisasina ki kera to. Ma na wane 'i nao ka adea ta keni, ma ka nao si alua go ta wele, ma wane nai ka mae na ana. ");
INSERT INTO far_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Sui ma, ruana wane ka adea lau na keni be, ma nao nia si alua laugo ta wele, ma ka mae laugo 'ana. Sui ma oluna wane ka 'urinai laugo. ");
INSERT INTO far_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ma ka 'urinai laugo fuana ai burina ki tafau. Na fiu waisasina nai ki tafau go ne kera adea keni nai, ma ka nao kera si to go ana ta wele, ma kera ka mae tafau na. Ma 'isilana, keni nai ka mae laugo. ");
INSERT INTO far_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","'Uri ma, ana maedangi ne God kai taea wane mae ki tafau fasia maea, sa ti 'ada ne na 'afe nia? Sulia na fiu waisasina nai ki be kera adea na keni nai tafau.” ");
INSERT INTO far_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ma sa Jesus ka olisida ka 'uri, “Kamulu garo 'asiana, sulia kamulu si saitamana go na Kekedee Abu ki, ma na nikilalae God. ");
INSERT INTO far_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sulia, kada ne wane mae ki kera kai tatae lau fuana maurie, kera dia na 'ada na 'ainsel ki 'i langi ne nao kera si arai go. ");
INSERT INTO far_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Iu, nau ku famanata kamulu sulia na tataelae fasia na maea. Nau ku saitamana kamulu idumia na 'i laona na kekedea sa Moses ana kula be sulia ere be nia meafia 'ai tu'u be ana. God ka fata fuana sa Moses ka 'uri, ‘Nau na God sa Abraham, ma na God sa Aesak, ma na God sa Jakob.’ ");
INSERT INTO far_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","God nia nao lau God fuana wane ne kera mae ki, boroi ma God fuana wane ne kera mauri ki. Kamulu garo 'asiana na!” ");
INSERT INTO far_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ma te wane famanata ana taki sa Moses, nia ka rongoa faoraie nai ki. Ma nia ka saitamana na lulae lea ne sa Jesus sasia fuana Sadusi ki. Ma nia ka leka mai, ka ledia sa Jesus ka 'uri, “Na taki te ana taki sa Moses ne nia talingai ka liufia taki ki tafau?” ");
INSERT INTO far_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ma sa Jesus nia olisia ka 'uri, “Na taki talingai ka liufia taki ki tafau ne nia 'uri, ‘Wane Jiu ki, mulu ka fafurongo basi! God na 'Aofia kia, taifilia nia ne God. ");
INSERT INTO far_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","'Oe kwaimanie ana God 'oe ana manatamu tafau, ma ana mangomu tafau, ma ana liomu tafau, ma ana nikilalamu tafau.’ ");
INSERT INTO far_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ma na ruana taki ka 'uri, ‘'Oe kwaimani ana tolamu ka dia laugo ne 'oe kwaimani amu talamu.’ Nao na ta taki lau ne nia baita ka liufia na ro taki nai ki.” ");
INSERT INTO far_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ma na wane famanata ana taki sa Moses ka fata 'uri fuana sa Jesus, “Wane Famanata 'ae, na lulae 'oe nia lea 'asiana. Nia ka mamana, taifilia te God go, ma nao na ta god 'e'ete lau. ");
INSERT INTO far_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ma wane ki kera kai kwaimani ana God ana mangoda tafau, ma ana na lioda tafau, ma ana nikilalada tafau. Ma kera ka kwaimani ana tolada, ka dia laugo ne kera kwaimani ana talada. Wane ne rosulia ro taki nai ki, kera sasia ru talingai ka liufia kwatelana na afafue fua God.” ");
INSERT INTO far_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ma sa Jesus ka ada saitamana na liotoe nia, ma ka fata 'uri fuana, “'Oe karangi na fuana God kai gwaungai ana maurilamu.” Ma burina na, nao ta wane si nonira'a na fuana ledilana sa Jesus lau. ");
INSERT INTO far_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","'Urinai sa Jesus ka famanata laona na Beu Abu God, nia ka ledi 'uri, “Nia 'uta ne wane famanata ana taki sa Moses ki, kera saea na Christ ne wane ana na kwalafa sa Deved? ");
INSERT INTO far_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Na Anoeru Abu be nia fafata sa Deved ka 'uri, ‘God nia fata 'uri fuana 'Aofia nau: 'Oe gouru 'i bali 'o'olo aku, ma 'oe gwaungai fai nau, makwalia kada nau kai alua malimae 'oe ki farana gwaungaie 'oe.’ ");
INSERT INTO far_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Sa Deved 'ana talana ne nia saea na Christ ana na ‘'Aofia.’ Nia ne, na Christ nia nao lau wele ana kwalafa sa Deved ga 'ana. Nia 'Aofia nia laugo.” Na fikue baita nai, kera eele 'asiana kada kera fafurongoa sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma sa Jesus ka famanata kera ka 'uri, “Mulu ka madafi kamulu fasia na famanata ana taki sa Moses ki, sulia kera doria leka liulae fainia maku falu gwala ki. Ma kera ka doria 'asiana fua na wane ki kera ka fa'initoda, ma ka fata lea fuada 'i maana usie ki. ");
INSERT INTO far_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ma kera ka doria gourue 'i nao ana kula 'initoa ni gourue ki laona beu fuana folae ki, ma ana kula lea ki kada ana fafanga ki. ");
INSERT INTO far_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Sui boroi 'ana, wane ne ki kera belia na lume ma na ru ne gwa 'oru ki to ana. Ma kera ka foa gwala fuana wane ki ka tangoda. Iu, na wane famanata ana taki sa Moses ki ne kwaekwaee kera kai ta'a 'asiana fuada!” ");
INSERT INTO far_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sa Jesus nia to laona na Beu Abu God karangia na kufi ru fuana alulana malefo 'i laona. Nia ka ada to'ona wane ne kera kwatea malefo kera ki. Ma na wane 'oro ne kera tooru ki kera ka kwatea malefo 'oro. ");
INSERT INTO far_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Sui, nia ka ada to'ona te gwa 'oru siofa 'asiana. Nia leka mai, ma ka kwatea ro ngingisi malefo tu'u ki. ");
INSERT INTO far_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ma sa Jesus ka saea mai na fafurongo nia ki, ma ka fata 'uri fuada, “Ru mamana nau ku saea fua mulu, te ne na gwa 'oru siofa ne nia kwatea, nia baita ka liufia wane ki tafau ne kera kwate malefo baita. ");
INSERT INTO far_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Sulia wane todaru ki, kera kwatea ga 'ada ka bali tu'u ana toorue kera ki. Boroi ma, gwa 'oru siofa ne, nia kwate tafau na ana ru ne ki nia to ana fuana tolana.” ");
INSERT INTO far_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kada sa Jesus nia fasia na Beu Abu God, te wane ana fafurongo nia ki ka fata 'uri fuana, “Wane Famanata 'ae, ada to'ona basi na mae fau baita ne ki, ma na lume lea ne ki ana Beu Abu God!” ");
INSERT INTO far_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ma sa Jesus ka olisia ka 'uri, “'Oe ada to'ona lume baita ne ki? Nao ta te gwa fau 'i seki ana Beu Abu God kai tio lau 'i fulina. Kera tafau kera kai takalo 'i ano.” ");
INSERT INTO far_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma kada sa Jesus nia to gwauna fa uo 'i Olif ne nia to bobola fainia na Beu Abu God, sa Pita, ma sa Jemes, ma sa Jon, ma sa Andru taifilida, kera leka mai siana, ma kera ka ledi 'uri ana, ");
INSERT INTO far_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“'Oe saea basi fua malu, 'i angita ne ru ne ki kai dao mai? Ma te ne kai fuli, fua ka fatainia kada fuana ru ne ki tafau kai fuli, ma ka dao ana?” ");
INSERT INTO far_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ma sa Jesus ka fata 'uri fuada, “Kamulu kai adaada lea, ma nao mulu si alamatainia ta wane ka talai garo amulu. ");
INSERT INTO far_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Sulia ne wane 'oro ki kera kai dao mai ana sataku, ma kera ka fata 'uri, ‘Nau na ne na Christ!’ Ma kera ka talai garo ana wane 'oro ki. ");
INSERT INTO far_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ma kada kamulu rongoa firue ki ana fere karangi ki, ma na faoraie sulia na firue ki ana tani fere tau laugo mai, nao mulu si manata 'abero sulia. Ru 'urinai ki kai dao mai, boroi 'ana na 'isilana ru ki tafau nao 'ua. ");
INSERT INTO far_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Na mae fere ki kera kai fualida kwailiu, ma na 'initoe ki kera kai fualida kwailiu. Ma na anuanu ki kai liu ana kula 'oro, ma na uni fioloe ki kai liu. Ma ru nai ki kera ne safalilana nonifie, dia ga 'ana na keni fafuta be nia safali ka fii wele. ");
INSERT INTO far_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ma kamulu ka adaada lea. Tani wane ki kai dau kamulu, ma kera ka ngali kamulu fuana ketolamulu. Kera kai namusi kamulu 'i laona na beu fuana folae ki. Sulia kamulu famamana nau, kera kai kwate kamulu ka uu 'i naona na wane fanaonao ma na kingi ki. Kada nai mulu kai farongoda 'ani nau. ");
INSERT INTO far_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Wane ki tafau laona molagali kera kai rongoa na Farongoe Lea, sui na molagali ka sui. ");
INSERT INTO far_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ma kada kera ka dau kamulu, ma kera ka ngali kamulu 'uria na ketolamulu, nao kamulu si manata 'abero 'uria ta faoraie 'uta ne kamulu kai saea. Kamulu kai saea go 'amulu na faoraie ne Anoeru Abu nia kwatea fua mulu ana kada nai. Sulia faoraie ki ne mulu kai saea, nia nao lau na fatae talamulu. Na faoraie nai ki, nia ka leka mai fasia na Anoeru Abu. ");
INSERT INTO far_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ma na wane ki, kera ka kwatea na wanefuta kera ki talada fuana saungilada. Ma na maa ki, kera kai sasi 'urinai laugo ana wele kera ki. Ma na wele ki, kera kai olisusu ma kera kai kwatea na maa fainia gaa kera ki fuana saungilada. ");
INSERT INTO far_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ma na wane ki tafau, kera kai noni'ela amulu, sulia kamulu na wane nau ki. Sui boroi 'ana ka 'urinai, dia sa ti ne nia ngangata fuana lekalae sulia God leka ka dao suilana kada nai, nia ne God kai famauria. ");
INSERT INTO far_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ma kamulu kai ada to'ona na Ru Sua kai tatae mai ana kula abu ne fulina nao nia si uu ana. Na ru ta'a nai kai fasua na Beu Abu God, ma kai sasi fua sae God ka fasia.” (Na faoraie fuana wane ne nia ididu nia 'uri: 'Oe malingainia lea ana na fadalana ru ne.) “Kada mulu ka ada to'ona na ru ne ki kai dao mai, na wane ki ne kera to ana na bali lofaa 'i Jiudea, kera kai tafi 'uria gwauna fa uo ki. ");
INSERT INTO far_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ana kada nai, dia ta wane ka to mai 'i maa ana lume nia, nia ka tafi 'ali'ali, ma nao nia si manata lau 'uria rulae laona lume nia 'uria ngalilana ta ru 'ana. ");
INSERT INTO far_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma sa ti ne nia to mai laona oole, nao nia si oli lau 'i lume 'uria ta maku 'ana. ");
INSERT INTO far_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ma ana fa dangi nai ki, nia kai ta'a fuana keni ki ne kera iana, sulia ne nia 'afitai fuada ne kera ka tafi, ma ka ta'a laugo fuana 'afe ki ne kera too ana na wele tu'u ki. ");
INSERT INTO far_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mulu ka foa fuana God fua ru nai ki nao si dao lau mai ana kada ana uni gwarie. ");
INSERT INTO far_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Sulia na nonifilae ana fa dangi nai ki, nia kai ta'a ka liufia na nonifilae ne wane laona molagali ki kera saitamana, safali 'ua mai ana safalilana kada God nia saungainia na molagali ka dao ana kada ne. Ma nao ta ru 'urinai kai fuli mai burina. ");
INSERT INTO far_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ma dia God si fakokorua kada ana nonifilae, nia 'afitai ne ta wane ka mauri. Ma nia fakokorua kada ne fuana lealana wane ne nia filida ki. ");
INSERT INTO far_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Iu, dia ta wane nia fata 'uri fua mulu, ‘Ada to'ona basi, nia na ne na Christ,’ naoma ka fata 'uri, ‘Ada to'ona basi, nia na 'i seloko,’ nao kamulu si famamana nia. ");
INSERT INTO far_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sulia na wane susuke ki kai dao mai, kera kai fata 'uri, ‘Nau na Christ,’ fainia na wane susuke ki kera kai fata 'uri, ‘Nau na profet.’ Ma kera kai sasia fanadae ki fua ka talaia garo ana na wane ne God nia filida ki, boroi ma nia 'afitai 'asiana fuada. ");
INSERT INTO far_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Mulu kai adaada lea! Nau ku farongo kamulu na 'i nao, sui ru ne ki ka fi dao mai. ");
INSERT INTO far_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ma kada ne nonifilae nai kai sui, ‘God kai susia na sato, ma na madame, ma nao keroa si tala. ");
INSERT INTO far_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ma God kai sasia na bubulu ki, kera kai 'asida fasia mamanga. Ma God kai sasia na ru 'i langi ki, kera kai leka garo fasia fulida.’ ");
INSERT INTO far_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“'Urinai, nau na Wele nia Wane, nau ku fi dao fatai mai. Nau ku dao mai fainia na nikilalae baita, ma na ngwasinasinae baita 'i fafona na gwa salo ki. ");
INSERT INTO far_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma nau kai kwatea na 'ainsel nau ki laona molagali tafau, fua kera ka okua mai na wane ne God filida ki.” ");
INSERT INTO far_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Go, sa Jesus ka fata sulia tarifulae ka 'uri, “Kamulu kai manata basi sulia na 'ai figi ki. Kada kamulu ada to'ona na ulina nia ngosa, mulu ka saitamana na kada fuana uni 'ako'akolae nia dao karangi na. ");
INSERT INTO far_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ka 'urinai laugo, kada kamulu ada to'ona na nonifilae nai ki kai dao mai, mulu kai saitamana na olilaku mai nia karangi na. ");
INSERT INTO far_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ru mamana ne nau ku saea fua mulu, wane ki tafau ne kera mauri ana kada ne, nao kera si mae 'i naona ru nai ki tafau kai dao mai. ");
INSERT INTO far_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Na ru ki tafau mai langi ma laona molagali kera kai sui. Boroi ma na fatalaku go ne toto nao si sui. ");
INSERT INTO far_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nao ta wane si saitamana kada mamana ne nau ku oli mai ana. Na 'ainsel ki 'i langi boroi nao si saitamana, ma nau na Wele boroi, nao si saitamana laugo. God na Maa taifilia go ne nia saitamana. ");
INSERT INTO far_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mulu kai adaada lea, ma mulu ka kwaimakwali, sulia kamulu ulafusia 'i angita ne kada nai kai dao mai ana. ");
INSERT INTO far_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Na olilaku mai ne kai dia ta wane ne nia leka ana fere tau, ma ka alua na lume nia laona 'abana na wane ni rao nia ki. Nia kwatea raoe ki fuada 'e'ete kwailiu. Ma nia ka saea fuana wane ne nia ada sulia na mae fua kai adaada lea makwalia daolana. ");
INSERT INTO far_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nia ne, kamulu kai adaada lea, sulia nao kamulu si saitamana na kada ne nau kai dao mai, dia wane baita ana lume. Nia kai dao mai saulafi 'oto, naoma laona tofungana rodo, naoma makalokaloa, naoma 'ofodangi kada sato fi ra mai. ");
INSERT INTO far_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ma dia nia dao 'ali'ali go mai, nia ka ta'a 'asiana fua mulu, dia nia dao to'omulu kada ne mulu maleu. ");
INSERT INTO far_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma te ru ne nau ku saea fua mulu, na ru be nau ku saea laugo fuana wane ki tafau nia 'uri: Mulu kai adaada lea!” ");
INSERT INTO far_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ana maedangi ne, nia ro maedangi ki 'i naona na Fafanga ana Daofa Liue, ma na fafanga ne Jiu ki kera saitamana 'anilana na beret ne nia nao ta isi 'i laona. Na fataabu baita ki, ma na wane famanata ana taki ki, kera ka oku lokoeru fuana dau agwalana ma saungilana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kera fata 'uri, “Nao kulu si sasia ana kada ana fafanga, fasia na wane ki kera ka fi fuali kulu.” ");
INSERT INTO far_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ana kada sa Jesus nia to 'i laona mae fere 'i Betani, nia ka fanga 'i laona lume sa Simon na wane ne kuu nia saungia 'i nao. Ma te keni ka leka mai siana fainia na bi ngwaingwai ne kwanga 'asiana, ma nia fungu ana na ngwaingwai ne moko lea, ma na folilana ka baita 'asiana. Nia 'ifingia na maana bi ngwaingwai nai, ma ka 'igitainia na ngwaingwai moko lea nai fafona gwauna sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ma tani wane ne kera to 'i senai, kera ka guisasu, ma kera ka fata fuada kwailiu kera ka 'uri, “Tala'ana nao nia si falia na ngwaingwai moko lea ne ro! ");
INSERT INTO far_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Tala'ana nia ka fafoli ana 'uria tani malefo 'oro, fua nia ka ngalia malefo nai, ma ka kwatea fuana wane siofa ki.” Ma kera ka balufia keni nai. ");
INSERT INTO far_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","'Urinai sa Jesus nia ka rongoa, ma ka fata 'uri, “Mulu alua nia to 'ana! Nao kamulu si fata falia lau. Nia sasia raoe lea 'asiana fuaku. ");
INSERT INTO far_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Na wane siofa ki kera to tari ga 'ada fai kamulu. Ma dia mulu doria, mulu ka 'adomida go 'amulu ana ta kada. Boroi ma nau nao si to tau go fai kamulu. ");
INSERT INTO far_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nia sasia ru ne nia bobola fainia sasilana. Nia 'igitainia na ngwaingwai moko lea ne 'i noniku 'i nao ana maelaku fuana sasi akaulae fuana faitolilae aku. ");
INSERT INTO far_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ru mamana nau ku saea fua mulu, ana kula ki tafau laona molagali ne kera kai fata sulia na Farongoe Lea ne, kera kai fata laugo sulia ru ne nia sasia aku fuana manatalae to'ona.” ");
INSERT INTO far_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sui sa Jiudas Iskariot, te wane ana na akwala ma ro fafurongo nia ki, nia leka siana na fataabu baita ki, ka farongoda 'uri, “Nau kai kwatea sa Jesus fua mulu.” ");
INSERT INTO far_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ma kera ka eele 'asiana sulia ru ne nia saea, ma kera ka alangai fuana kwatelana malefo fuana. Ma sa Jiudas ka safali na fuana adalae 'uria ta kada lea fuana kwatelana sa Jesus fuada. ");
INSERT INTO far_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ana etana fa dangi ana Fafanga ana beret ne nia nao ta isi 'i laona, fa dangi nai ne kera saungia kale sipsip fuana Fafanga ana Daofa Liue. Kada nai, fafurongo sa Jesus ki kera ka ledi 'uri ana, “'I fai ne 'oe doria kalu kai leka ma kalu ka sasi akau ana na Fafanga ana Daofa Liue fuamu?” ");
INSERT INTO far_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ma sa Jesus ka fata fuana ro wane ada ka 'uri, “Kamoro ru laona 'i Jerusalem, ma te wane ne nia ngalia na fa kafo, nia kai dao to'omoro. Moro ka leka sulia ");
INSERT INTO far_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","'uria te lume 'i senai ne nia ru 'i laona. Kamoro ka ledi 'uri ana na wane ne nia to ana na lume nena, ‘Na Wane Famanata nia fata mai 'uri fuamu: 'I fai ne mae lume fuana nau kai 'ania na Fafanga ana Daofa Liue fainia fafurongo nau ki?’ ");
INSERT INTO far_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ma nia kai fatainia te mae lume baita ne nia to 'i langi fuamoro. 'I senai ru ki tafau kera sasi akau na. Ma kamoro ka sasi akau ana na ru ki tafau fua kulu 'i senai.” ");
INSERT INTO far_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","'Urinai ma, na ro fafurongo nai ki keroa leka, ma keroa ka ru na 'i Jerusalem, ma keroa ka ada to'ona na ru ki tafau nia dia ne sa Jesus nia saea fuadaro. Ma keroa ka sasi akau na ana fanga 'i senai. ");
INSERT INTO far_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ma nia saulafi na, sa Jesus ka dao mai fainia na akwala ma ro fafurongo nia ki. ");
INSERT INTO far_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma kada kera fanga, sa Jesus ka fata 'uri, “Na ru mamana nau ku saea fua mulu, te wane amulu kai kwate nau fuana malimae nau ki. Te wane amulu ne nia fanga ga 'ana fai nau ana kada ne.” ");
INSERT INTO far_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ma na fafurongo nia ki, kera ka kwaimanatai 'asiana. Ma te te wanea ada fi safali ana ledilana sa Jesus 'uri, “'Aofia 'ae, 'uri ma 'oe fata suli nau nai?” ");
INSERT INTO far_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ma sa Jesus nia olisida ka 'uri, “Nia ne ta ai na amulu na akwala ma ro fafurongo nau ki, ma nia ta wane ne kai taufia lifu beret nia 'i laona na tiu fai nau. ");
INSERT INTO far_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma nau, na Wele nia Wane, nau kai mae dia na Kekedee Abu ki be fata suli nau. 'Urinai boroi ana, kwaimanatai 'asiana fuana wane ne kai kwate nau fuana malimae nau ki! Nia lea fuana wane nai dia nia nao si futa go.” ");
INSERT INTO far_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma kada kera fanga na, sa Jesus nia ngalia te fa beret, ma ka tangoa God, sui ka ngiia. Nia ka kwatea fuana fafurongo nia ki, ka fata 'uri, “Ngalia mulu ka 'ania. Nia na ne noniku.” ");
INSERT INTO far_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Sui nia ka ngalia na titiu, ma ka tangoa God, sui ka kwatea fuada. Ma kera tafau ka ku ana. ");
INSERT INTO far_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ma nia ka fata 'uri, “Nia na ne 'abuku ne igwa fuana wane 'oro ki fuana fangasilana na alangaie falu God. ");
INSERT INTO far_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ru mamana nau ku saea fua mulu, nau nao si kufia laugo na waeni ne leka ka dao ana fa dangi nau kai kufia lau na waeni ne, kada God kai gwaungai ana wane nia ki tafau.” ");
INSERT INTO far_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Burina kera ka ngufia fa ngu, sui kera ka leka 'uria fa uo ne kera saea ana Olif. ");
INSERT INTO far_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sa Jesus ka fata 'uri fuada, “Kamulu tafau go ne mulu kai tafi fasi nau. Sulia na Kekedee Abu nia fata 'uri, ‘God kai saungia wane ne nia ada sulia na sipsip ki, ma na sipsip ki tafau kera ka takalo.’ ");
INSERT INTO far_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Ka 'urinai boroi 'ana, 'i burina nau ku tatae lau 'uria maurie, nau kai eta 'i nao amulu 'uria 'i Galili.” ");
INSERT INTO far_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ma sa Pita nia olisia ka 'uri, “Nia 'afitai 'asiana ne nau ku leka fasi 'oe, sui boroi 'ana wane ne ki kera ka leka fasi 'oe!” ");
INSERT INTO far_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ma sa Jesus ka fata 'uri fuana sa Pita, “Nau ku saea fuamu. 'I naona na karai kai angi ro ru laona rodo ne 'i ta'ena, 'oe tofe olu ru 'oe ulafusi nau.” ");
INSERT INTO far_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ma sa Pita nia fata totongai ka 'uri, “Sui boroi 'ana nau ku mae fai 'oe, nia 'afitai nau ku saea ne nau ku ulafusi 'oe!” Ma na fafurongo ki tafau go ne, kera saea laugo te ru nai. ");
INSERT INTO far_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sui sa Jesus fainia na fafurongo nia ki, kera ka leka 'uria te kula kera saea ana 'i Getsemani. Kada kera dao na, sa Jesus ka fata 'uri fuada, “Mulu to 'amulu 'i seki kada nau ku foa 'aku.” ");
INSERT INTO far_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Sui nia ka talaia sa Pita, ma sa Jemes, ma sa Jon fainia. Ma nia 'e kwaimanatai 'asiana ma ka liodila. ");
INSERT INTO far_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ma nia ka fata 'uri fuada, “Na lioku nia kwaimanatai 'asiana, ma nia bobola na fua saungilaku. Mulu ka to 'i seki, mulu ka ada, ma mulu ka adaada fai nau.” ");
INSERT INTO far_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ma nia ka 'idu tu'u kau, ma ka tio fafia maana 'i ano. Ma nia ka foa fua dia nia ngwaluda ga 'ana, kwate nao nia si liu laona kada ana nonifie. ");
INSERT INTO far_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ma nia ka foa ka 'uri, “Maasi 'ae, na ru ki tafau nia ngwaluda ga 'ana fuamu. 'Oe lafua 'amu na nonifie ne fasi nau. Sui boroi 'ana, nia nao lau na kwaidorie nau, boroi ma sulia kwaidorie 'oe lalau.” ");
INSERT INTO far_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Sui sa Jesus ka oli mai, ma ka dao to'ona na olu fafurongo nia ki, kera maleu ga 'ada. Ma nia ka fata 'uri fuana sa Pita, “Simon 'ae, 'uta ne 'oe maleu? Fulingana 'oe 'ada fai nau sulia ta te kada rodo tu'u boroi 'ana.” ");
INSERT INTO far_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ma nia ka fata 'uri fuada, “Kamulu kai 'ada, mulu ka adaada ana folae fasia na ilitoe ka liufi kamulu. Sulia kamulu doria sasilana ru lea ki, boroi ma noni mulu nia ngwatautau 'asiana.” ");
INSERT INTO far_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ma sa Jesus ka leka lau fasida, ma ka foa, ma ka saea laugo te faoraie be ki. ");
INSERT INTO far_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Sui nia ka oli lau mai siada, ma ka dao to'oda kera maleu lau, sulia ne maada 'e maleua 'asiana. Ma nao kera si saitamana ana na ru ne kera ka saea fuana. ");
INSERT INTO far_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ma kada nia oli lau mai ana oluna kada, nia ka fata 'uri fuada, “Kamulu maleu 'ua ne? Nia lea na! Ada basi, kera kai kwate nau na, na Wele nia Wane, laona 'abana na wane ta'a ki. Na kada be nia dao na mai! ");
INSERT INTO far_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tatae, kulu leka na. Ada basi, na wane be nia kwate nau fuana malimae nau ki, nia dao na mai!” ");
INSERT INTO far_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ana kada sa Jesus nia fata ga 'ana, sa Jiudas, ta wane ana na akwala ma ro fafurongo nia ki, ka dao na mai. Te fikue baita ne leka mai fainia fasia na fataabu baita ki, ma na fanaonao ki, ma na wane famanata ana taki ki. Ma kera ka ngalia mai na naife ni sauwanee ki ma na subi ki. ");
INSERT INTO far_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ma sa Jiudas, na wane ne kai kwate sa Jesus fuada, nia ka kwatea na maetoto fuana fikue nai ka 'uri, “Na wane ne nau ku nono'ia, nia na wane ne mulu doria. Kamulu 'e daua, ma mulu ka talaia na kau.” ");
INSERT INTO far_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","'Urinai, sa Jiudas nia dao, nia ka leka na kau siana sa Jesus, ma ka fata 'uri, “Wane Famanata 'ae!” Go, nia ka nono'ia na. ");
INSERT INTO far_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ma kera ka daua na sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Iu, ma ana kada nai, te wane ne nia uu karangi go ana, nia lafua na naife nia, ma ka kwae musia na alingana na wane rao 'inita fataabu. ");
INSERT INTO far_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ma sa Jesus ka ledi 'uri 'ada, “'Uri ma kamulu fia nau ta wane beli ne? Nia ne mulu dao na mai fainia na naife ki, ma na subi ki fuana daulaku? ");
INSERT INTO far_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tau na mai, nau ku famanata kamulu 'i laona na Beu Abu God, boroi ma nao mulu si dau nau go. Ma na ru ne kamulu sasia, nia famamana na Kekedee Abu.” ");
INSERT INTO far_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","'Urinai go, fafurongo nia ki tafau kera ka luka faburi na ana, ma kera ka tafi na 'ada. ");
INSERT INTO far_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ma te wane fi baita ne nia ofi go ana na 'aba maku tagataga, nia leka mai burina sa Jesus. Ana kada kera daua na wane fi baita ne, ");
INSERT INTO far_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","na 'aba maku nia ka luge na fasia, ma nia ka tafi dadara na 'ana. ");
INSERT INTO far_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","'Urinai, kera ka talaia sa Jesus 'uria lume 'inita fataabu. Ma na fataabu baita ki, ma na fanaonao ki, ma na wane famanata ana taki ki, kera oku 'i senai. ");
INSERT INTO far_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma sa Pita nia 'isi buri tau na kau, ma ka ru laugo laona labate ana lume na 'inita fataabu. Nia ka gouru 'ana 'i senai fainia na wane folo ki, ma nia ka sara 'ana 'i ninimana na ere. ");
INSERT INTO far_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Go, na fataabu baita ki, ma na fikute wane lokoeru tafau, kera ka sasi 'uria daolae to'ona ta ru ta'a fuana fafilana ana sa Jesus fua kera ka saungia, boroi ma kera si dao to'ona go ta ru ana nia. ");
INSERT INTO far_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma na wane 'oro ki, kera ka suke fafia sa Jesus, boroi ma faoraie kera ki nao si alu te ru. ");
INSERT INTO far_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ma tani wane kera tatae laugo, ma kera ka suke fafia sa Jesus kera ka 'uri, ");
INSERT INTO far_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Kalu rongoa nia fata 'uri, ‘Nau kai okosia na Beu Abu God ne wane ki kera saungainia, ma 'i laona olu fa dangi ki, nau ku saungainia lau te Beu Abu ne nao lau na wane ki ne kera saungainia.’” ");
INSERT INTO far_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma kera boroi, na faoraie kera ki nao si alua te ru. ");
INSERT INTO far_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ma na 'inita fataabu nia uu 'i naoda, ma nia ka ledia sa Jesus ka 'uri, “'Uri ma, nao 'oe si to go ana ta faoraie fuana olisilana faoraie ne ki, ne wane ne ki kera fai fafi 'oe ana?” ");
INSERT INTO far_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Boroi ma sa Jesus nofo ga 'ana, ma ka nao si olisia go. Ma na 'inita fataabu nia ledia lau ka 'uri, “'Uri ma, 'oe ne na Christ, na Wele God 'i langi?” ");
INSERT INTO far_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ma sa Jesus ka olisia ka 'uri, “Iu, nau ne nia. Ma mulu kai ada to'oku, na Wele nia Wane, nau ku gouru 'i bali 'o'olo ana God ne nikila 'asiana, ma nau ku leka mai 'i fafona gwa salo ki 'i langi.” ");
INSERT INTO far_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Go na 'inita fataabu nai nia ka musia na maku gwala nia talana ka fatainia na gwuisasue nia, ma ka fata 'uri, “Kulu si doria lau ta wane ni fata famamana! ");
INSERT INTO far_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kamulu tala rongoa na ne nia fabolotania fainia God! Mulu manata 'uta ana?” Ma kera tafau go ne, kera ka saea sae nia garo na, ma nia bobola fainia kera kai saungia na. ");
INSERT INTO far_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ma tani wane ada kera ka safali fuana ngisufilana sa Jesus, ma kera ka kani bokota na maana, ma kera ka kumua. Ma kera ka fata 'uri, “Saea basi sa ti ne nia kumuli 'oe?” Ma na wane fofolo ki kera ka talaia, ma kera ka fidalia. ");
INSERT INTO far_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Sa Pita nia to 'ua ga 'ana 'i laona labate, kada kera ketoa sa Jesus. Te keni ne rao fuana 'inita fataabu nia dao mai. ");
INSERT INTO far_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ma kada nia ada to'ona sa Pita ne nia sara 'ana, nia ka ada saga kau fuana, ma ka fata 'uri, “'Oe to laugo fainia sa Jesus, na wane be fasia na mae fere 'i Nasaret.” ");
INSERT INTO far_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ma sa Pita nia tofe ka 'uri, “Nau ku ulafusia, nau si saitamana ru ne 'oe fata sulia.” Ma nia ka 'idu karangia na mae tafa. Ma ana kada nai go, na karai ka angi na. ");
INSERT INTO far_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ma na keni rao be nia ada to'ona lau senai, ma ka fata 'uri fuana wane ki ne kera uu kalia 'i senai, “Nia ta wane laugo ada ne!” ");
INSERT INTO far_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ma sa Pita ka tofe laugo. Ma kada tu'u 'i buri'ana, na wane ki ne kera uu karangi, kera ka fata 'uri lau fuana sa Pita, “Nia 'afitai 'asiana fua 'oe ka tofe ne 'oe nao lau ta wane ada, sulia 'oe laugo ne 'oe leka mai fasia na lofaa 'i Galili.” ");
INSERT INTO far_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Sui sa Pita ka kwaiagi ka 'uri, “Alu God kai kwatea na kwaekwaee fuaku, dia nau si fata mamana! Nau nao si saitamana na wane ne kamulu fata sulia!” ");
INSERT INTO far_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ma ana kada nai go, na karai ka ruana fa angilae na. Ma sa Pita ka manata to'ona na faoraie be sa Jesus nia saea fuana be nia 'uri, “'I naona na karai ka angi ro ru, 'oe sae olu ru ki, ne 'oe ulafusia nau.” Ma kada sa Pita nia manata to'ona ru nai, nia ka angi 'asiana na. ");
INSERT INTO far_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ana 'ofodangi makalokalo, na fikute wane lokoeru kera oku 'ali'ali mai. Go na fataabu baita ki, ma na fanaonao ki, ma na wane famanata ana taki sa Moses ki, kera 'i laona fikute wane ne. Kera oku lokoeru fuana ta te ne kera kai sasia ana sa Jesus. Sui kera ka kania sa Jesus, ma kera ka talaia na siana sa Paelat, na wane baita fasia 'i Rom. ");
INSERT INTO far_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ma sa Paelat ka ledia ka 'uri, “'Uri ma 'oe na ne kingi Jiu ki?” Ma sa Jesus ka olisia ka 'uri, “Nia na nena 'oe saea na.” ");
INSERT INTO far_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Na fataabu baita ki kera ka fai fafia ana ru garo 'oro ki. ");
INSERT INTO far_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ma sa Paelat ka ledia lau ka 'uri, “'Oe rongoa basi na ru 'oro ki ne kera fai fafi 'oe na ana! 'Uri ma 'oe si olisida lau?” ");
INSERT INTO far_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Boroi ma sa Jesus nao si saea go ta faoraie, ma sa Paelat ka kwele 'asiana. ");
INSERT INTO far_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Iu, ana na Fafanga ana Daofa Liue, sa Paelat nia 'idufa lugea te wane fasia na beu ni kanie ne wane ki kera gani 'uria. ");
INSERT INTO far_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma ana kada nai, te wane ne satana sa Barabas nia to laugo 'i laona beu ni kanie, sulia nia laugo ne ta ai ana wane ta'a ne kera sauwanee ana firue fainia wane Rom ki. ");
INSERT INTO far_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","'Urinai na fikue ki kera oku mai, kera ka gania sa Paelat fuana kai lugea ta wane fasia na beu ni kanie sulia falafala ne nia 'idufa sasia mai ana kada 'urinai ki. ");
INSERT INTO far_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ma nia ka ledi kera ma ka 'uri, “'Uri ma kamulu doria nau ku lugea na kingi Jiu ki fua mulu?” ");
INSERT INTO far_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sulia sa Paelat saitamana na ne fataabu baita ki kera kwatea mai sa Jesus siana, sulia manatae wane 'ugalae kera ki ga 'ana. ");
INSERT INTO far_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Boroi ma, na fataabu baita ki kera fata alingana na fikue nai, fua kera ka gania sa Paelat fuana lugelana mai sa Barabas fuada. ");
INSERT INTO far_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ma sa Paelat ka ledi lau 'uri ana na fikue nai, “'Urinai ma te ne nau ku sasia ana na wane ne mulu saea ana kingi Jiu ki?” ");
INSERT INTO far_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ma kera ka akwa kera ka 'uri, “'Oe foto'ia ana 'airarafolo!” ");
INSERT INTO far_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ma sa Paelat nia ledida ka 'uri, “Na garoe te ne nia sasia?” Ma kera ka akwa baita lau, kera ka 'uri, “Foto'ia ana 'airarafolo!” ");
INSERT INTO far_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ma sa Paelat ka lugea kau sa Barabas fuada, sulia nia doria kai faeelea na manatana na fikue nai. Sui, nia ka kwatea sa Jesus fuana namusilana, ma ka kwatea fuana foto'ilana ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Na wane ni omee ki, kera ka talaia na kau sa Jesus 'i laona labate ana lume baita sa Paelat, ma kera ka saea mai na wane ni omee ki tafau. ");
INSERT INTO far_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ma kera ka famasa ana te maku gwala meo, ma kera ka 'erea na te 'eregwau ana 'oko ngangara, ma kera ka duua ana gwauna dia ta kingi. ");
INSERT INTO far_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Sui kera ka ilia na fabaitalana ma kera ka fata 'uri, “Na kingi Jiu ki, 'oe mauri tau amu!” ");
INSERT INTO far_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Sui kera ka kwaea gwauna 'ana lifu 'ai, ma kera ka ngisufia, ma kera ka boruru 'i naofana, dia ne kera fabaita. ");
INSERT INTO far_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ma kada ne kera aefara ka suina, kera ka lugea na maku gwala meo bobora nia be fasia. Sui kera ka famasa lau ana maku nia talana. 'Urinai kera ka talaia na fuana foto'ilana ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma ana kada kera leka kau sulia na taale, kera dao to'ona te wane satana sa Simon, maa sa Aleksanda fainia sa Rufus. Nia na wane fasia na fere 'i Saerin. Nia leka mai ma ka ru laona 'i Jerusalem fasia ta kula mai 'i maa. Ma na wane ni omee ki, kera ka sumainia fua nia ngalia na 'airarafolo sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ma kera ka talaia kau sa Jesus 'uria te kula ne kera saea ana 'i Golgota. Ma fadalana ne 'uri, “Na kula ana lelete wane.” ");
INSERT INTO far_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ma kera ka kwatea na waeni ne kera dolalia fainia ru ne kera saea ana Mira, te sului ru fuana famabelana fiie, boroi ma sa Jesus nao si kufia go. ");
INSERT INTO far_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ma kera ka foto'ia ana 'airarafolo. Ma kera ka tolingia na maku nia ki 'i safitada kwailiu. Kera ka saketo ana na ru dia daisi fua kera ka dao to'ona sa ti ada ne kai ngalia ta maku. ");
INSERT INTO far_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ana na sikwana kada sato 'ofodangi, kera fotofafia ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ma kera ka alua 'i gwauna 'airarafolo te kekedea ana kwaikefusie. Kera kedea ka 'uri, “Na kingi Jiu ki.” ");
INSERT INTO far_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Ma kera ka foto'ia laugo ro wane beli ki fafona ro 'airarafolo ki fainia sa Jesus. Ta wane 'i bali 'o'olo ana, ma ta wane 'i bali mauli ana. ");
INSERT INTO far_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma na wane ki kera liu, kera ka kwaelangai gwauda, ma kera ka fata buri tolingai kau ana sa Jesus, ma kera ka fata 'uri, “Wala 'ae! 'Oe saea 'oe okosia na Beu Abu God, ma 'oko saungai falu lau ana sulia olu fa dangi ki go! ");
INSERT INTO far_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","'Oe famauri 'oe talamu! Koso mai fasia na 'airarafolo nena!” ");
INSERT INTO far_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ma na fataabu baita ki, ma na wane famanata ana taki ki, kera ka fata laugo 'urinai. Ma kera ka fata 'onionga sa Jesus, ma kera ka fata 'uri fuada kwailiu, “Nia famauria wane 'e'ete ki, boroi ma nao nia si famauria nia talana! ");
INSERT INTO far_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kulu ada basi dia nia na Christ, na kingi Jiu ki. Nia ne kai koso go mai fasia na 'airarafolo lo, fua kulu ka famamana nia!” Ma na ro wane ne kera fotofafida ana 'airarafolo ki fainia sa Jesus, kera boroi, kera fata buri tolingai laugo ana sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Safali ana tofungana dangi, na 'afutana bali lofaa ne nia rodoa, leka ka dao ana oluna kada sato saulafi. ");
INSERT INTO far_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma ana oluna kada sato saulafi, sa Jesus nia akwa baita ma ka 'uri, “Eli, Eli, lama sabaktani?” Na fadalana ne 'uri, “God nau 'ae, God nau 'ae, 'uta na ne 'oe lukasi faburi aku?” ");
INSERT INTO far_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ma tani wane ne kera to 'i senai, kera ka rongoa, ma kera ka fata 'uri, “Nia akwa 'uria sa Elaeja.” ");
INSERT INTO far_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ma te wane adalae kau, ma ka kutumainia te lumulumu asi laona waeni 'afae, ma ka alua 'i maana te mae 'ai, ma ka kwatea kau 'i maana ngiduna sa Jesus, fua ka kufia, ma nia ka fata 'uri, “Mango basi, kulu ada to'ona dia sa Elaeja kai leka mai ma ka lafua nia mai 'i ano fasia na 'airarafolo!” ");
INSERT INTO far_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ma sa Jesus ka akwa baita, sui nia ka mae na. ");
INSERT INTO far_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ma na maku baita ne nia bokota na kula abu 'i laona na Beu Abu God nia ka kakari 'ita mai 'i gwauna leka ka dao 'i 'aena. ");
INSERT INTO far_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma wane fanaonao ana wane ni omee ki, ne nia uu 'i senai 'i 'aena 'airarafolo, nia rongoa akwalana, ma ka ada to'ona maelana, nia ka fata 'uri, “Nia mamana 'asiana, wane ne nia na Wele God na!” ");
INSERT INTO far_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ma tani keni kera to laugo 'i senai, ma kera ka ada tau na kau: Ni Mary fasia 'i Magdala, ma ni Salome, ma ni Mary ne gaa sa Jemes na wele 'i burina sa Joses. ");
INSERT INTO far_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kera leka laugo 'i burina sa Jesus ana kada nia to 'ua 'i Galili, ma kera ka kwai'adomi ana. Ma na keni 'oro ki laugo ne kera leka mai fainia 'uria 'i Jerusalem, kera to laugo 'i senai. ");
INSERT INTO far_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Ma nia ka saulafi na, sa Josef na wane fasia 'i Arimetea, nia ka leka siana sa Paelat. Nia ta wane talingai ana na fikute wane lokoeru ne nia ada kwaimakwali laugo 'uria adalae to'ona kada God kai gwaungai ana wane nia ki. Nia nonira'a, ma ka leka mai siana sa Paelat. Ma nia ka gania 'uria na nonina sa Jesus, sulia fa dangi nai ne na maedangi ana na sasi akaulae makwalia na Sabat. ");
INSERT INTO far_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ma sa Paelat ka kwele ne nia rongoa sa Jesus nia mae na. Ma nia ka akwa 'uria wane fanaonao ana wane ni omee ki, ma ka ledia dia sa Jesus mae na. ");
INSERT INTO far_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ma 'i burina ne sa Paelat nia rongoa wane baita nai nia saea ne nia mae na, nia ka fi alamatainia sa Josef ka ngalia nonina sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","'Urinai, sa Josef ka folia te 'aba maku kwao, ma ka lugea nonina sa Jesus 'i ano, ma ka 'afua ana maku nai, ma ka alua 'i laona na faoda gwau ne kera 'elia 'i laona na fau. Sui nia ka gelusia te aba fau baita, ma ka bokota na maana faoda gwau nai. ");
INSERT INTO far_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma ni Mary fasia 'i Magdala, ma ni Mary ne gaa sa Joses, keroa ada to'ona na kula ne kera faitolia sa Jesus ana. ");
INSERT INTO far_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ma 'i burina na Sabat nia suina, ni Mary keni 'i Magdala, ma ni Mary na gaa sa Jemes, ma ni Salome, kera folia mai na ru moko lea ki fuana ngwaingwailana ana nonina sa Jesus. ");
INSERT INTO far_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ana 'ofodangi makalokalo 'ua ana Sande, kada sato ni ra na, kera ka leka mai 'uria na faoda wane mae. ");
INSERT INTO far_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kada kera leka, kera ka ledida kwailiu kera ka 'uri, “Sa ti na ne kai gelusia na aba fau be fasia maana faoda be?” Sulia fau nai nia baita 'asiana. ");
INSERT INTO far_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sui, kada kera dao ana, kera ka ada to'ona ne na aba fau be nia 'e abuli na. ");
INSERT INTO far_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ma kada kera ru kau 'i laona na faoda, kera ka ada to'ona te wane fi baita nia rufia na maku kwao, ma ka gouru ana bali 'o'olo laona faoda nai. Ma kera ka mau 'asiana. ");
INSERT INTO far_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ma nia ka fata 'uri, “Nao kamulu si mau. Nau ku saitamana mulu nani 'uria sa Jesus, na wane 'i Nasaret ne kera saungia ana 'airarafolo. Nao nia si to na 'i seki. Nia tatae na fasia maea! Mulu ada to'ona na kula be kera faitoli ana! ");
INSERT INTO far_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mulu leka kau siana fafurongo nia ki fainia sa Pita, ma mulu ka farongo 'uri ada na, ‘Sa Jesus leka na 'i nao makwali kamulu 'i Galili, mulu kai ada na to'ona 'i senai, dia be nia saea na fua mulu.’” ");
INSERT INTO far_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ma na keni nai ki kera ka ru na kau 'i maa, ma kera ka lae na fasia na faoda nai, sulia kera mau, ma kera ka lebelebe 'asiana. Nao kera si saea na ta ru fuana ta wane, sulia kera mau 'asiana. ");
INSERT INTO far_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ana 'ofodangi makalokalo ana Sande, sa Jesus nia mauri lau, ma ka dao fatai fuana ni Mary keni 'i Magdala, na keni be sa Jesus nia ifulangainia na fiu anoeru ta'a be ki fasia. ");
INSERT INTO far_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ma ni Mary ka leka siana na fafurongo nia ki. Kera kwaimanatai, ma kera ka angi 'asiana. Ma ni Mary ka farongoda. ");
INSERT INTO far_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ma ana kada ne kera rongoa ne sa Jesus nia mauri, ma ni Mary ka suana na, kera nao si famamana go ni Mary. ");
INSERT INTO far_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma 'i buri lau, sa Jesus ka dao fatai laugo fuana ta ro fafurongo ana, kada kera leka na sulia na taale fasia 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ma kera ka oli mai, ma kera ka farongoa lau tani fafurongo ada, boroi ma kera si famamana go. ");
INSERT INTO far_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma 'i burina, sa Jesus ka dao fatai fuana akwala ma ta wane ana fafurongo nia ki kada kera fanga 'ada. Ma nia ka balufida sulia kera si famamana, ma sulia manatada ngasi 'asiana fuana famamanalana wane ki ne kera ada to'ona na 'i burina ne nia tatae fasia maea. ");
INSERT INTO far_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ma nia ka fata 'uri fuada, “Mulu ka leka 'i laona 'afutana na molagali, ma mulu ka 'ainitalo ana Farongoe Lea fuana wane ki tafau. ");
INSERT INTO far_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma sa ti ne nia famamana na Farongoe Lea, ma ka siuabu, nia ne kai mauri firi fainia God. Ma sa ti ne nao nia si famamana, God nia kai ketoa. ");
INSERT INTO far_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma na wane ki ne kera famamana, kera kai to ana nikilalae fuana sasilana fanadae 'uri ki: Kera ka ifulangainia anoeru ta'a ki ana na sataku, ma kera ka fata ana fatae 'e'ete ki ne kera nao si saitamana. ");
INSERT INTO far_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ma dia kera daua ta fa baeko tolo, naoma kera ka kufia boroi ta kafo ni maelilana, nao nia si falida go. Ma dia kera alua 'abada 'i fafona na wane matai ki, kera ka 'akwa na.” ");
INSERT INTO far_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","'I burina ne na 'Aofia sa Jesus nia fata fai kera, God ka ngalia na 'uria 'i langi, ma ka gouru 'i bali 'o'olo ana God fua gwaungai fainia. ");
INSERT INTO far_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma na fafurongo nia ki kera ka leka, ma kera ka lifurongo ana fatalana God, ana kula ki tafau. Ma na 'Aofia ka rao faida, ma ka kwatea na nikilalae fuada fuana sasilana fanadae ki, fua ka fatainia ne na famanatalae kera ki nia 'e mamana. ");
INSERT INTO far_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiofilas 'ae, na wane 'oro ki kera kekede sulia ru ki tafau ne sa Jesus nia fulida safitamalu. ");
INSERT INTO far_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kera kedea ru ne kalu rongoa fasia na wane ne kera ada to'ona ru nai ki. Ma wane ne kera ada to'ona ru nai ki ne fuli, kera ka fata laugo sulia na Farongoe Lea nai fua malu. ");
INSERT INTO far_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nia ne wane baita Tiofilas, nau ku manata sulia nia 'e lea, nau ku kedea ru ne ki fuamu, sulia nau ku saitamana lea ana ru ki tafau, nia safali mai ana safalilana faoraie ne. ");
INSERT INTO far_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma nau ku kede sulia ru ne ki fua 'oko saitamana na mamanalana tafau ru ne kera famanata kamulu ana. ");
INSERT INTO far_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ana na kada sa Herod nia kingi ana bali lofaa 'i Jiudea, te fataabu ne satana sa Sekaraea nia to laugo kada nai, ma nia ana fikute fataabu fuana folae sulia sa Abaeja. Na 'afe nia ni Elisabet nia leka laugo mai ana kwalafa fataabu ki ne kera safali mai ana sa Eron, wanefuta sa Moses. ");
INSERT INTO far_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Na abuloladaro 'e 'o'olo 'i maana God, sulia keroa ro lea 'asiana sulia na taki God ki fainia na faoraie talingai nia ki. ");
INSERT INTO far_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Boroi ma te ru go ne, nao keroa si to ana ta wele, sulia ni Elisabet nia 'aba'ato. Ma nia fainia arai nia sa Sekaraea boroi, keroa ngwaro na. ");
INSERT INTO far_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Te maedangi sa Sekaraea nia leka laona Beu Abu God, sulia kada nai, nia kada fuana fikute fataabu sa Sekaraea, fua ka sasia na raoe fataabu ki. ");
INSERT INTO far_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Na falafala ana fataabu ki fuana fililana ta fataabu lau fuana sungilana 'ai moko lea, ne nia 'uri: Kera 'ui 'ania ru dia daisi fuana fililana sa ti lau ne kai sasia raoe fataabu fuana sungilana 'ai moko lea fafona fulifue laona Beu Abu God. Ana kada nai, kera ka filia sa Sekaraea, ma nia ka ru 'i laona Beu Abu, ");
INSERT INTO far_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ma na wane 'oro ne kera to 'i maa ki, kera ka foa ana kada nia sungia na 'ai moko lea nai. ");
INSERT INTO far_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma te 'ainsel God ka fatai fuana, nia 'e uu 'i bali 'o'olo ana fulifue nai. ");
INSERT INTO far_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kada sa Sekaraea nia 'e ada to'ona na 'ainsel nai, nia 'e tona ma ka mau 'asiana. ");
INSERT INTO far_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Boroi ma, na 'ainsel nai ka fata 'uri fuana, “Sekaraea, nao 'oe si mau lau! God nia 'e rongoa na folae 'oe, ma na 'afe 'oe ni Elisabet kai fafuta te welewane. Ma 'oko fasata ana sa Jon. ");
INSERT INTO far_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'Oe kai eele 'asiana, ma na wane 'oro ki laugo, kera ka eele ana kada ne nia kai futa mai ana! ");
INSERT INTO far_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Sulia nia na wane talingai 'i naona God. Nao nia si kufia ta waeni naoma ta ru ni kufilana ne nikila. Ma ana kada nia fi futa mai, na Anoeru Abu ka to na fainia. ");
INSERT INTO far_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nia kai olitainia mai na wane 'oro ki 'i Israel fuana God kera. ");
INSERT INTO far_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ma nia ne kai eta na mai 'i naona na 'Aofia, ma nia kai nikila dia sa Elaeja na profet. Sa tifaida ne kera olisusu, nia kai fikuda lau, fuana maa ki, ma na wele kera ki, kera kai kwaimani fuada kwailiu. Ma nia kai talana manatana na wane aburongo ki, fua kera ka manata 'o'olo. Ma nia ne kai sasi akau ana na wane ki fuana 'Aofia, fua kera ka makwalia na daolana mai.” ");
INSERT INTO far_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sui, sa Sekaraea ka fata 'uri fuana 'ainsel nai, “Nau kai saitamana 'uta ana mamanalana ru nai? Sulia nau fainia 'afe nau, karo ngwaro tafau na.” ");
INSERT INTO far_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma na 'ainsel ka olisia ka fata 'uri, “Nau sa Gebriel ne nau ku to fainia God sulia dangi ki tafau. Ma God na ne odu nau mai, fua nau ku fata fai 'oe, ma nau ku farongo 'oe ana na farongoe lea ne. ");
INSERT INTO far_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na farongoe ne nau fata fuamu, 'oe kai ada to'ona na mamanalana ana kada ne God nia alangai fuana ru ne ka fuli ana. Ma sulia 'oe si famamana ana fatalaku, na ngidumu kai kulu, ma nao 'oe si fata tafa leka ka dao ana kada ne ru ne nau ku eta fata ana 'i nao fuamu ka mamana.” ");
INSERT INTO far_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ana kada nai na wane ne kera to makwalia sa Sekaraea ki, kera ka kwele 'asiana, sulia nia 'e to tau mai 'i laona Beu Abu. ");
INSERT INTO far_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ma kada sa Sekaraea nia leka mai 'i maa siana wane nai ki, na ngiduna 'e ato na, ma nao nia si fata na fainia na wane nai ki. 'Urinai go na wane ki tafau, kera ka manata na 'uri, “Mamana 'asiana, alamia nia 'e ada to'ona ta fataie 'i laona Beu Abu.” Sulia ne ngiduna nia ato na, ma nia ka fata go ana 'abana fuana wane ki. ");
INSERT INTO far_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ma na kada nia ki fuana raolae laona Beu Abu God 'e suina, sa Sekaraea ka fi oli lau 'uria lume nia. ");
INSERT INTO far_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma nao nia si tau go 'i burina, na 'afe nia ni Elisabet ka iana na, ma sulia lima madame ki, nia si liliu na 'i maa fasia lume kera, ");
INSERT INTO far_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ma nia ka fata 'uri, “Kada ne, God nia 'e 'adomi nau na, ma ka lafu nau na fasia 'ekelae be nau ku to mai laona 'ana 'aba'atolae 'i maana wane 'oro ki.” ");
INSERT INTO far_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kada ni Elisabet 'e iana ka to na sulia ono madame ki, God ka kwatea mai 'ainsel Gebriel 'uria te fere laona lofaa 'i Galili ne kera saea ana 'i Nasaret. ");
INSERT INTO far_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nia ka ngalia mai te farongoe fuana te wele keni ne satana ni Mary, ne kera alu fafia fuana wane ne satana sa Josef fua ka adea. Sa Josef nia futa mai olitana na kwalafa sa Deved na kingi. ");
INSERT INTO far_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Na 'ainsel nia leka mai, ka fata 'uri fuana ni Mary, “Asoa lea kau! God nia to fai 'oe ka falea 'oe, ma na kwaiofeie nia fuamu ka baita!” ");
INSERT INTO far_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Kada ni Mary 'e rongoa na fatalana 'ainsel nai, nia ka manata 'abero, ma ka nani 'uria na fadalana na farongoe nai na 'ainsel nia 'e saea fuana. ");
INSERT INTO far_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Sui na 'ainsel ka fata lau 'uri fuana, “Mary, nao 'oe si mau lau, sulia God nia 'e ofe 'oe. ");
INSERT INTO far_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","'Oe kai iana, ma 'oe kai fafuta te welewane, ma 'oe ka fasata ana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ma nia kai 'inito, ma kera ka saea ana Wele God 'i langi. God kwatea nia kai gwaungai, dia koko nia sa Deved. ");
INSERT INTO far_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ma nia kai gwaungai fuana wane Israel ki toto firi, ma na 'initoe nia nao si sui!” ");
INSERT INTO far_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ma ni Mary ka fata 'uri fuana 'ainsel nai, “Nau ku abungai nau 'ua na mai. 'Uri ma fatae ne 'oe saea fuaku kai mamana 'uta?” ");
INSERT INTO far_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma na 'ainsel nai, nia olisia ka 'uri, “Na Anoeru Abu ne kai koso mai fafi 'oe, ma na nikilalae God ka to fai 'oe. Sulia ne, na Wele Abu nai, kera kai saea ana na Wele God. ");
INSERT INTO far_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'Oe saitamana aifuta 'oe ni Elisabet, na wane ki tafau kera saea nia 'afitai na fuana nia ka to ana ta wele. Sui boroi 'ana nia ka ngwaro, 'i ta'ena nia iana ka to na sulia ono madame ki. ");
INSERT INTO far_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Sulia nao ta ru si 'afitai go fua God.” ");
INSERT INTO far_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ma ni Mary ka fata 'uri, “Nau ku doria ru ne 'oe saea fuaku ki kai fuli mamana na mai fuaku, sulia nau na keni rao God.” Kada ni Mary nia fata go 'urinai, na 'ainsel ka leka na 'ana fasia. ");
INSERT INTO far_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ana kada nai, ni Mary ka sasi akau, ma ka leka 'ali'ali na 'uria ka fere 'i tolo ana bali lofaa 'i Jiudea. ");
INSERT INTO far_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Kada nia dao, nia ka ru 'i lume sa Sekaraea, ma ka fata lea fuana ni Elisabet. ");
INSERT INTO far_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ma kada ni Elisabet nia rongoa na fatalana ni Mary, na wele ne nia iana ana tona ka gelogelo laona guina. Ma na Anoeru Abu ka sura ana ni Elisabet, ");
INSERT INTO far_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ma nia ka fata baita ma ka 'uri, “Na 'oilakie fuamu liufia na keni ki tafau, ma na 'oilakie laugo fuana wele ne 'oe iana ana. ");
INSERT INTO far_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nao nau si bobola fua ru baita ne ka fuli fuaku, fua na gaa 'Aofia nau ka leka mai fuana sualaku! ");
INSERT INTO far_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sulia kada nau ku rongoa go na fatalamu, na wele ne nau ku iana ana ka gelo na laona guiku, sulia nia eele 'asiana. ");
INSERT INTO far_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na 'oilakie fuamu sulia 'oe famamana fatalana God ne kai fuli fuamu.” ");
INSERT INTO far_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ma ni Mary ka fata 'uri, “Na manataku 'e tangoa God, ");
INSERT INTO far_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ma na mangoku nia eele sulia God ne nia famauri nau. ");
INSERT INTO far_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nau ku ngu tangoa 'aku, sulia nia manata to'oku, nau na keni ku marabibi ga 'aku, ma ku to ga 'aku fuana raolae fuana. Nia 'ita 'i ta'ena ka oli 'alaa, na wane ki tafau kera kai saea nau ku to ana 'oilakie baita, ");
INSERT INTO far_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","sulia na ru baita ki ne God nia sasia fuaku 'ana nikilalana tafau. Ma na satana God ka abu. ");
INSERT INTO far_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nia 'ita ka leka na mai sulia na unita wane ki tafau, nia fatainia kwaimanataie nia fuana wane ki tafau ne kera fuusi baita ana. ");
INSERT INTO far_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nia taga na 'abana ne nia nikila, ma ka takalongainia na wane ne kera fata lea ada 'i talada ki. ");
INSERT INTO far_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nia fakosoa na kingi nikila ki fasia na 'initoa kera ki, ma ka fa'initoa wane kera marabibi ki. ");
INSERT INTO far_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Na wane kera fiolo ki, nia sangonida ana ru lea ki, ma nia ka sasia wane todaru ki ka siofa. ");
INSERT INTO far_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nia manata to'ona na fata alangaie nia sasia fuana koko kia ki, ma ka kwai'adomi aka na wane rao nia ki 'i Israel. Nao nia si manata buro ana fatailana kwaimanataie nia eta fata alangai fuana sa Abraham, ma fuaka laugo na kwalafa nia ki toto firi!” ");
INSERT INTO far_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary nia to fainia ni Elisabet sulia olu madame ki, sui nia ka fi oli 'uria fere nia. ");
INSERT INTO far_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kada fuana ni Elisabet ka fafuta nia dao na, nia ka fafuta te welewane. ");
INSERT INTO far_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Na wane kwaimani nia ki, ma na wane go ana kwalafa nia ki, kera rongoa na ru lea ne God nia sasia fuana, ma kera ka eele 'asiana fafia. ");
INSERT INTO far_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Fiu maedangi ki sui burina futalana wele nai, kera ka rosulia na falafala Jiu ki fuana 'ole 'ungelae. Ma kera ka doria fasata ana maa nia sa Sekaraea. ");
INSERT INTO far_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Boroi ma gaa nia olisida ka 'uri, “Nao kamulu si saea ana sataeru nena! Na satana lalau ne sa Jon.” ");
INSERT INTO far_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ma na wane ki tafau kera olisia kera ka 'uri, “Nao ta wane ana kwalafa kamoro si to ana sataeru nai.” ");
INSERT INTO far_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Sui kera ka fata ana 'abada, kera ka kwatea maetoto fuana ma nia sa Sekaraea, ma kera ka ledi 'uria sataeru te ne nia doria kera kai fasata ana wele ne. ");
INSERT INTO far_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ma sa Sekaraea ka kwaikaru, ma ka gani 'uria ta aba ru fuana kekedelae, ma nia ka kedea ka 'uri, “Na satana wele ne, ne sa Jon.” Ma wane ki tafau kera ka kwele 'asiana. ");
INSERT INTO far_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma ana kada nai laugo, na ngiduna sa Sekaraea ka fata tafa, ma nia ka tangoa God. ");
INSERT INTO far_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ma na wane ki tafau go ne kera oku mai senai, kera ka kwele 'asiana, ma na farongoe sulia na ru nai ki ka talofia na wane kera to 'i tolo ki, laona bali lofaa 'i Jiudea. ");
INSERT INTO far_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma na wane ki tafau go ne kera rongoa ru nai ki, kera ka manata kalida, ma kera ka ledi 'uri, “Na wele ne kai alua ta wane 'uta ne?” Kera ledi 'urinai, sulia kera saitamana na nikilalae God nia to fainia wele nai. ");
INSERT INTO far_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ma na Anoeru Abu ka sura ana sa Sekaraea maa sa Jon. Ma sa Sekaraea ka 'ainitaloa na farongoe God ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Kulu tangoa God ne nia God ana wane Jiu ki. Nia leka mai fuana 'afilaka na wane nia ki, ma fuana famaurilaka. ");
INSERT INTO far_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Nia ka kwatea mai fuaka te Wane Famauri ne nia to ana nikilalae baita, ne nia leka mai fasia kwalafa sa Deved na kingi, na wane rao God. ");
INSERT INTO far_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nia fata alangai mai fuaka ana ru ne ki, ana fatalana profet abu ki 'i nao, ");
INSERT INTO far_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","fua nia kai famauri kia fasia na malimae kia ki ma fasia na nikilalae ana wane ne kera guisasu fuaka. ");
INSERT INTO far_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nia ka alangai mai nia kai fatainia na kwaimanataie nia fuana koko kia ki, ma nia ka manata to'ona na alangaie abu ");
INSERT INTO far_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","ne nia sasia fuana koko kia sa Abraham. Ma nia ne kai lafu kia fasia na malimae kia ki, fua kulu ka rao fuana ma nao kulu si mau, ");
INSERT INTO far_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","fua kulu ka to 'o'olo 'i maana sulia maedangi ki tafau.” ");
INSERT INTO far_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma sa Sekaraea ka fata 'uri fuana wele nia sa Jon, “Wele nau 'ae, kera kai sae 'oe ana profet God ne 'initoa fafia ru ki tafau. Ma 'oe eta 'i nao ana na 'Aofia, fua 'oko sasi akau ana taale nia. ");
INSERT INTO far_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ma 'oe farongoa na wane nia ki, ne kera kai too ana maurie kada God kai manatalugea ta'alae kera ki. ");
INSERT INTO far_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Sulia God kia, nia kwaimanatai 'asiana fuaka. Dia na sato ne ra mai fainia madakwalae, ");
INSERT INTO far_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Wane Famauri kia nia dao mai fasia God fainia madakwalae fuana ai ne kera to laona maerodo ana maea. Ma nia kwai'adomi aka, ma ka talai kia 'uria na aroaroe fainia God.” ");
INSERT INTO far_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma wele nai sa Jon ka baita ana noni, ma na manatana tafau ka nikila. Ma kada nia baita, nia ka to laona lofaa 'eke'eke, leka ka dao ana maedangi nia fatai mai fuana wane Israel ki. ");
INSERT INTO far_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ana kada nai ana tu'ulana sa Jon, na kingi baita 'i Rom ne satana sa Ogastas, nia alua te taki fuana wane ana fere ki tafau ne kera to farana 'initoe nia, fua kera ka leka 'i fere koko kera ki fuana kedelana satada. ");
INSERT INTO far_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ma nia na etana kedea ne kera sasia kada sa Kwirinias nia gwaungai fafia lofaa 'i Siria. ");
INSERT INTO far_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ma na wane ki tafau, kera ka leka fuana kedelana satada, te te wanea kai oli 'uria fere nia. ");
INSERT INTO far_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ma sa Josef ka leka laugo mai fasia na fere nia 'i Nasaret ana lofaa 'i Galili, ma ka leka 'uria bali lofaa 'i Jiudea 'uria na mae fere sa Deved na kingi ne kera saea ana 'i Betlehem, sulia sa Josef nia na wane ana kwalafa sa Deved. ");
INSERT INTO far_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Sa Josef nia leka fuana ka kedea na satana fainia ni Mary, na keni be kera alu fafia fuana. Ma ana kada nai, ni Mary nia iana na. ");
INSERT INTO far_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ma ana kada keroa to 'i Betlehem, nia 'e fii wele na fua fafutalae. ");
INSERT INTO far_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ma nia ka fafuta na wele nao nia, ma ka 'afua ana maku ki, ma ka fatioa 'i laona kula ni fanga buluka ki, sulia nao na ta lume fuana keroa ka folia keroa ka to ana. ");
INSERT INTO far_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma na wane ne kera ada sulia sipsip ki, kera to karangia laugo na fere nai, ma kera ka ada sulia na sipsip kera ki 'i laona rodo. ");
INSERT INTO far_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ma na 'ainsel God ka fatai fuada, ma na madakwalana God ka tala fafida, ma kera ka mau 'asiana. ");
INSERT INTO far_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ma na 'ainsel nai ka fata 'uri fuada, “Nao kamulu si mau lau, sulia nau ku ngalia mai farongoe lea ne nia faeelea wane ki tafau. ");
INSERT INTO far_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","'I ta'ena na Wane Famauri kamulu nia futa 'i laona mae fere sa Deved 'i Betlehem, ma nia ne na Christ na 'Aofia. ");
INSERT INTO far_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ma na maetoto fua mulu nia 'uri: Mulu kai ada to'ona ta wele tu'u ne kera 'afua ana maku ki, ma nia tio ana kula fuana fangalana buluka ki.” ");
INSERT INTO far_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tona boroi ma molee 'ainsel fasia 'i langi kera ka oku fatai lau fainia 'ainsel be, ma kera ka tangoa God kera ka 'uri, ");
INSERT INTO far_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Fa'initoa ana God 'i langi. Ma na aroaroe fuana wane ki 'i ano ne God nia eele faida.” ");
INSERT INTO far_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","'I burina ne 'ainsel ki kera oli na 'uria 'i langi, na wane ada sulia sipsip nai ki kera ka fata kwailiu fuada kera ka 'uri, “Kulu leka basi 'uria 'i Betlehem fua kulu ka ada to'ona na ru ne God nia fata sulia fuaka.” ");
INSERT INTO far_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ma kera ka leka 'ali'ali, ma kera ka dao to'ona ni Mary fainia sa Josef, ma kera ka ada to'ona na wele tu'u ne nia tio ana kula fuana fangalana buluka ki. ");
INSERT INTO far_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ma kada kera ada to'ona, kera ka fata sulia na ru ne na 'ainsel 'e saea fuada sulia na wele nai. ");
INSERT INTO far_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ma na wane ki kera ka rongoa, ma kera ka kwele 'asiana ana farongoe ne kera farongo ana. ");
INSERT INTO far_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ma ni Mary nia manata to'ona ru nai ki, ma ka konia laona maurilana ka tau. ");
INSERT INTO far_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma na wane ne kera ada sulia sipsip ki kera ka oli, ma kera ka tangoa God fafia ru ki tafau ne kera rongoa, ma kera ka ada to'ona laugo ne nia mamana ka dia ne 'ainsel nia saea fuada. ");
INSERT INTO far_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ma ana wiki 'i buri, kada ne kera 'ole 'unge ana wele nai, kera ka fasata 'ana sa Jesus, na sataeru be na 'ainsel nia saea fuana ni Mary, kada nia si iana 'ua. ");
INSERT INTO far_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ma na kada nia dao na fuana sa Josef fainia ni Mary keroa ka kwaitaboi na dia na taki be sa Moses nia saea 'i buri'ana fafutalae. 'Urinai go, keroa ka ngalia na wele nai 'uria laona Beu Abu God 'i Jerusalem fua keroa ka kwatea fuana God, ");
INSERT INTO far_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","dia be kera kedea ka suina 'i laona taki God ki kera 'uri, “Na welewane nao, kera kai kwatea fuana God.” ");
INSERT INTO far_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Keroa ka kwatea laugo na afafue 'ana ro fa kurukuru ki, naoma ta ro fa bole, dia na taki God nia doria fuana kwaitaboilana ni Mary. ");
INSERT INTO far_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ma ana kada nai, te wane satana sa Simion nia to 'i Jerusalem. Nia na wane lea, ma ka fosia God firi, ma ka to ni kwaimakwali 'uria kada God kai famauria na wane Israel ki. Ma na Anoeru Abu nia ka to ana, ");
INSERT INTO far_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ma ka saea nia kai mauri leka ka dao ana kada nia kai ada to'ona na Christ ne God nia fata alangai ana fuana famaurilana wane nia ki. ");
INSERT INTO far_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Na Anoeru Abu nia talaia sa Simion ka leka 'uria Beu Abu God, ma nia ka dao to'ona sa Josef fainia ni Mary, kada keroa ngalia mai na wele tu'u nai sa Jesus, fua keroa ka sasia na ru ki ne taki nia saea fuana sasilana. ");
INSERT INTO far_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","'Urinai go, sa Simion ka olia na wele nai, ma ka tangoa God ka 'uri, ");
INSERT INTO far_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“God 'ae, kada ne fata alangaie be 'oe nia mamana na. Nia ne, nau na wane rao 'oe, nau fi bobola na fuana maelae, ma nau ku eele 'asiana. ");
INSERT INTO far_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Sulia kada nai, nau ku ada to'ona na ana maaku na wane ne 'oe kwatea mai fua ka famauria na wane ki. ");
INSERT INTO far_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nia na wane ne 'oe sasi akau ana, fua wane ki tafau kera ka ada to'ona. ");
INSERT INTO far_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Wane Famauri ne, nia dia na kwesu, sulia nia 'e fatainia na kwaidoria 'oe fuana wane ne nao lau Jiu ki. Ma nia ka fa'initoa kalu wane Jiu ki ne wane 'oe ki.” ");
INSERT INTO far_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ma na maa nia fai na gaa nia, keroa ka kwele 'asiana kada keroa rongoa ru nai ki sa Simion nia fata sulia na wele ne. ");
INSERT INTO far_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ma sa Simion ka falea keroa. Sui, nia ka fata 'uri fua ni Mary, na gaa nia, “Na wele ne na wele God nia filia 'ua na mai, na wane 'oro ki 'i Israel kera kai too ana maurie ana nia, ma na 'orolana laugo wane ki 'i Israel maurilada mae sulia kera si famamana nia. 'Urinai nia ne na maetoto kai fatainia God fuana wane ki, ma 'orolana wane ki kera subutainia, ");
INSERT INTO far_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","'urinai nia kai fatainia na manata agwalae kera ki. Mary 'ae, na kwaimanataie baita ne kai dao to'omu, ka dia ta naife ne kai toea nonimu ka fii 'asiana.” ");
INSERT INTO far_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ma na te gwa 'oru keni nia to laugo ana kada nai, na satana ni Ana, ma nia ta profet laugo, ma nia ka ngwaro na. Nia na wele keni sa Faniuel ana kwalafa sa Asa. Ana kada nia sari, nia 'afe ma ka to fainia arai nia sulia fiu fangali ki go, ");
INSERT INTO far_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ma dao 'i ta'ena, nia kwalu akwala ma fai fangali ki. Nia to ga 'ana, ma ka 'idufa leka laona Beu Abu God fuana abu fangalae ma na fosilana God sulia dangi ma rodo. ");
INSERT INTO far_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana kada nai laugo, nia dao to'ona sa Josef fainia ni Mary, ma ka tangoa God, ma ka fata sulia na wele nai fuana wane ki tafau ne kera to ga 'ada makwalia kada God kai famauria wane Jiu ki. ");
INSERT INTO far_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kada sa Josef fainia ni Mary keroa fasuia na ru ki tafau ne taki God nia saea, keroa ka oli na 'uria fere keroa 'i Nasaret, fere ne laona lofaa 'i Galili. ");
INSERT INTO far_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Na wele nai nia baita mai, ma ka nikila, ma ka to ana liotoe. Ma kwaiofeie God ka to fainia. ");
INSERT INTO far_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ana fangali ki tafau, na maa sa Jesus ma gaa nia keroa leka 'uria fere baita 'i Jerusalem fuana fa dangi baita ana Fafanga ana Daofa Liue. ");
INSERT INTO far_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ma kada sa Jesus nia dao ana akwala ma ro fangali, kera ka leka ana fafanga nai sulia na falafala kera. ");
INSERT INTO far_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","'I burina fafanga nai nia sui, na maa nia ma gaa nia keroa ka oli na 'adaroa, ma sa Jesus ka to ga 'ana 'i Jerusalem, ma keroa si saitamana. ");
INSERT INTO far_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Keroa kwaisae nia leka na fainia na okue nai, ma keroa ka leka na 'adaroa sulia fa dangi laulau nai. Sui, keroa ka fi safali 'uria nanilae 'i safitana na wanefuta keroa ki, ma na wane kwaimani keroa ki. ");
INSERT INTO far_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ma kada keroa nani, ma keroa si ada to'ona, keroa ka oli lau 'i Jerusalem fua keroa ka nani 'uria. ");
INSERT INTO far_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ma na oluna fa dangi, keroa ka fi dao to'ona laona Beu Abu God. Nia to 'ana fainia wane famanata ana Jiu ki, ma nia ka fafarongoda, ma ka ledida sulia ru kera famanata ana. ");
INSERT INTO far_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ma na wane ki tafau ne kera rongo nia, kera ka kwele 'asiana ana saitamarue nia ma ana lulae nia ki. ");
INSERT INTO far_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ma kada sa Josef ma ni Mary keroa ada to'ona, keroa ka kwele 'asiana. Ma gaa nia ka fata 'uri fuana, “Wele nau 'ae, 'oe sasi 'uta 'amaro ne? Na maa 'oe, ma nau, karo nani mai 'uri 'oe, ma karo ka manata 'abero 'asiana.” ");
INSERT INTO far_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ma sa Jesus ka olisi keroa ka 'uri, “'Uta ne kamoro ka nani mai 'uri nau ana kula ki sui go? Tala'ana kamoro saitamana go 'amoro ne nau ku to ga 'aku 'i seki laona lume Maa nau.” ");
INSERT INTO far_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","'Urinai ma keroa si saitamana go na fadalana na faoraie ne nia saea fuadaro. ");
INSERT INTO far_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Sui, sa Jesus ka oli fai keroa 'uria 'i Nasaret, ma ka ro na 'ana suli keroa. Ma gaa nia ka manata na sulia ru nai ki tafau sulia na kada tau. ");
INSERT INTO far_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ma sa Jesus ka baita mai ana noni, ma na liotoe nia ka baita laugo, ma God fainia wane ki kera eele laugo fainia. ");
INSERT INTO far_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ana kada nai, nia dao na ana akwala ma lima fangali ne sa Taebirias nia kingi baita 'i Rom, ma sa Pontias Paelat ka 'initoa fafia 'i Jiudea, ma sa Herod nia wane 'initoa fafia 'i Galili, ma sa Filip na wanefuta nia ka ada sulia 'i Iturea ma 'i Trakonaetis, ma sa Lisanias ka ada sulia bali lofaa 'i Abilin. ");
INSERT INTO far_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kada nai laugo, sa Anas fai sa Kaeafas keroa ro 'inita fataabu ki ana fere 'i Jerusalem. Ma ana kada nai, na fatalana God 'e dao mai siana sa Jon na wele sa Sekaraea, kada nia to na 'i laona bali lofaa 'eke'eke. ");
INSERT INTO far_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ma sa Jon ka leka ana bali lofaa kalikalia kafo 'i Jodan. Ma nia ka fata 'uri fuana wane ki, “Mulu kari abulo fasia ta'alae kamulu ki, ma mulu siuabu, fua God ka manatalugea ta'alae kamulu ki.” ");
INSERT INTO far_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nia dia na be sa Aesaea na profet nia kedea ka 'uri, “Te wane nia akwa laona bali lofaa 'eke'eke ka 'uri, ‘Na 'Aofia kai dao mai! Kamulu kai fasaga na taale fuana! ");
INSERT INTO far_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ma mulu fafungua na oteotea ki, ma mulu faotea na kula fane ki ma fa uo ki. Ma mulu fasaga na taale 'e'eo ki, ma mulu fadada na taale mae kilu ki. ");
INSERT INTO far_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ma wane ki tafau kera kai ada to'ona ne God kai famaurida.’” ");
INSERT INTO far_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ma wane 'oro ki kera leka mai siana sa Jon fua nia ka siuabuda. Ma sa Jon ka fata 'uri fuada, “Kamulu dia go amulu kaelana baeko tolo ki! Nao nau si saea lau fua mulu ne na siuabulae kai fatafi kamulu fasia na kwaekwaee God, sui boroi 'ana nao mulu si kari abulo. ");
INSERT INTO far_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mulu sasia lalau ru ki ne nia fatainia kamulu kari abulo na fasia na abulo ta'alae kamulu ki! Ma nao mulu si manata 'uri 'i laona liomulu, ‘Kalu na wane kalu futa mai ana kwalafa sa Abraham ne. 'Afitai ta kwaekwaee fasia God ka dao to'omalu.’ Ma nau ku sae saga ana fua mulu, nia ngwaluda go ana fuana God ka ngalia ta gwa mae fau ana mae fau ki, ma ka saungainia ana kwalafa sa Abraham ki! ");
INSERT INTO far_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ana kada ne, God nia sasi akau na ana kwaekwaee, dia ta wane be nia dau ana ta irome, ma ka sasi akau fuana tofulana 'ai ki. Ma na 'ai ki tafau ne nao si fungu ana ta fueru 'ai lea ki, nia kai tofuda, ma ka 'ui 'anida 'i laona ere.” ");
INSERT INTO far_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sui, na wane ki kera ka ledia sa Jon kera ka 'uri, “Ta te ne kalu kai sasia fua ka fatainia ne kalu kari abulo?” ");
INSERT INTO far_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ma nia ka olisida ka 'uri, “Dia sa ti ne nia too ana ro 'aba maku ki, nia ka kwatea na ruana maku fuana ta wane ne nao nia si too ana ta maku. Ma dia ta wane ne nia too ana fanga ki, nia ka tolingia.” ");
INSERT INTO far_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ma tani wane fua konilana malefo fuana takisi, kera dao laugo mai fuana siuabulae, ma kera ledi kera ka 'uri, “Wane Famanata 'ae, ta te mone ne kalu kai sasia ka fatainia ne kalu kari abulo?” ");
INSERT INTO far_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ma sa Jon nia olisida ka 'uri, “Mulu konia go malefo ne nia bobola fainia malefo ne taki nia saea. Nao mulu si gani liufia na malefo nai.” ");
INSERT INTO far_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ma tani wane ni omee kera ka ledia laugo kera ka 'uri, “Ma kalu ne, te ne kalu kai sasia ka fatainia ne kalu kari abulo?” Ma nia ka fata 'uri fuada, “Mulu si usungailana ta wane fuana kwatelana malefo fua mulu. Ma nao mulu si fafefe ta wane. Ma mulu eele go amulu fafia na malefo ne kera foli kamulu ana.” ");
INSERT INTO far_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Wane ki kera kwaimakwali ana daolana mai na Christ, na wane ne God filia fua ka lafua wane nia ki, 'urinai ma kera fia 'uri, “Alamia sa Jon na ne na Christ.” ");
INSERT INTO far_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Boroi ma sa Jon ka fata lalau 'uri fuada, “Nau ku siuabu kamulu ga 'aku ana kafo, boroi ma wane ne kai dao mai nia talingai ka liufi nau. Ma nau nao si bobola fua ne nau ku lugea na tae butu nia ki. Ma nia ne kai siuabu kamulu 'ana Anoeru Abu ma 'ana ere. ");
INSERT INTO far_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ma nia sasi akau na fuana ketolana wane ki tafau, ka dia ta wane be nia efoa na mege ru lea ki fasia na tataeru ki. Ma nia ka konia na mege ru lea ki laona na lume ni konirue, ma ka sungia na tataeru ki laona na ere ne nao nia si mae.” ");
INSERT INTO far_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ma sa Jon ka fata sulia na Farongoe Lea fuada ana farongoe 'oro 'urinai ki, ma nia ka suraduda fua kera ka talana falafala kera ki. ");
INSERT INTO far_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma ana kada nai laugo, sa Jon ka fata nikila 'asiana fuana sa Herod, na wane ne nia gwaungai ana bali lofaa nai, sulia sa Herod nia adea ni Herodias 'afe saoana sa Filip, ma nia ka sasia na ru ta'a 'oro ki laugo. ");
INSERT INTO far_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ma ta ru lau ne ta'a ka liufia na ne, sa Herod, nia ngalia sa Jon, ma ka alua laona beu ni kanie. ");
INSERT INTO far_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ma 'i naona kada sa Jon nia to laona beu ni kanie, nia siuabua na wane 'oro ki. Sa Jesus nia leka mai, ma sa Jon ka siuabua laugo. Ma ana kada nia foa, na lofana salo ka 'ifi, ");
INSERT INTO far_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ma na Anoeru Abu nia koso mai fafia dia ta bole. Ma te lingeru nia talo mai fasia 'i langi ka 'uri, “'Oe na ne wele nau ne nau ku kwaimani 'asiana amu. Nau ku eele 'asiana fai 'oe.” ");
INSERT INTO far_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ana kada sa Jesus nia bobola na fainia olu akwala fangali burina futalana, nia safali ka leka kwailiu na fuana famanatalae. Ma na wane ki tafau, kera manata sae sa Jesus nia na wele sa Josef go ana. Boroi ma Sa Josef ne nia 'e futa mai ana sa Hilae. ");
INSERT INTO far_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Sa Hilae nia futa ana sa Matat, sa Matat ka futa ana sa Lifae, sa Lifae ka futa ana sa Melkae, sa Melkae ka futa ana sa Janae, sa Janae ka futa ana sa Josef. ");
INSERT INTO far_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Sa Josef na wele sa Matataeas, sa Matataeas ka futa ana sa Emos, sa Emos ka futa ana sa Neham, sa Neham ka futa ana sa Eslae, sa Eslae ka futa ana sa Nagae. ");
INSERT INTO far_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Sa Nagae ne wele sa Meata, sa Meata ka futa ana sa Matataeas, sa Matataeas ka futa ana sa Semein, sa Semein ka futa ana sa Josek, sa Josek ka futa ana sa Joda. ");
INSERT INTO far_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Sa Joda na wele sa Joanan, sa Joanan ka futa ana sa Risa, sa Risa ka futa ana sa Serababel, sa Serababel ka futa ana sa Sialtiel, sa Sialtiel ka futa ana sa Nirae. ");
INSERT INTO far_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Sa Nirae na wele sa Melkae, sa Melkae ka futa ana sa Adae, sa Adae ka futa ana sa Kosam, sa Kosam ka futa ana sa Elmadam, sa Elmadam ka futa ana sa Ere. ");
INSERT INTO far_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Sa Ere na wele sa Josua, sa Josua ka futa ana sa Eliesa, sa Eliesa ka futa ana sa Jorim, sa Jorim ka futa ana sa Matat, sa Matat ka futa ana sa Lifae. ");
INSERT INTO far_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Sa Lifae na wele sa Simion, sa Simion ka futa ana sa Jiuda, sa Jiuda ka futa ana sa Josef, sa Josef ka futa ana sa Jonam, sa Jonam ka futa ana sa Elaeakim. ");
INSERT INTO far_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Sa Elaeakim na wele sa Melia, sa Melia ka futa ana sa Mena, sa Mena ka futa ana sa Matata, sa Matata ka futa ana sa Netan, sa Netan ka futa ana sa Deved. ");
INSERT INTO far_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Sa Deved na wele sa Jesi, sa Jesi ka futa ana sa Obed, sa Obed ka futa ana sa Boas, sa Boas ka futa ana sa Salmon, sa Salmon ka futa ana sa Nason. ");
INSERT INTO far_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Sa Nason na wele sa Aminadab, sa Aminadab ka futa ana sa Admin, sa Admin ka futa ana sa Anae, sa Anae ka futa ana sa Hesron, sa Hesron ka futa ana sa Peres, sa Peres ka futa ana sa Jiuda. ");
INSERT INTO far_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Sa Jiuda na wele sa Jakob, sa Jakob ka futa ana sa Aesak, sa Aesak ka futa ana sa Abraham, sa Abraham ka futa ana sa Tera, sa Tera ka futa ana sa Neho. ");
INSERT INTO far_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Sa Neho na wele sa Sirag, sa Sirag ka futa ana sa Riu, sa Riu ka futa ana sa Pileg, sa Pileg ka futa ana sa Eba, sa Eba ka futa ana sa Sela. ");
INSERT INTO far_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sa Sela na wele sa Keinan, sa Keinan ka futa ana sa Afaksad, sa Afaksad ka futa ana sa Siem, sa Siem ka futa ana sa Noa, sa Noa ka futa ana sa Lamek. ");
INSERT INTO far_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Sa Lamek na wele sa Metusala, sa Metusala ka futa ana sa Enok, sa Enok ka futa ana sa Jered, sa Jered ka futa ana sa Mahelalel, sa Mahelalel ka futa ana sa Kenan. ");
INSERT INTO far_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Sa Kenan na wele sa Enos, sa Enos ka futa ana sa Set, sa Set ka futa ana sa Adam na wele God. ");
INSERT INTO far_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Na Anoeru Abu nia sura ana sa Jesus, ma sa Jesus ka oli mai fasia na kafo 'i Jodan, ma na Anoeru Abu ka talaia 'uria laona bali lofaa 'eke'eke. ");
INSERT INTO far_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ma sa Saetan ka ilito'ona senai sulia fai akwala maedangi ki. Ma sulia maedangi nai ki, sa Jesus nao si 'ania go ta fanga, ma nia ka fiolo 'asiana na. ");
INSERT INTO far_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ma sa Saetan ka fata 'uri fuana, “Dia 'oe na Wele God, 'oe fata fuana gwa fau ne fua ka alua ta lifu beret.” ");
INSERT INTO far_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ma sa Jesus ka olisia ka 'uri, “Na Kekedee Abu nia saea, ‘Na wane nao si mauri go ana fanga taifilia.’” ");
INSERT INTO far_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Sui sa Saetan ka talaia 'uria gwauna toloa ne fane 'asiana, ma ana kada tu'u go, nia ka fatainia na fuana 'initoe ki tafau ana molagali. ");
INSERT INTO far_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ma nia ka fata 'uri fuana sa Jesus, “Nau kai kwatea na 'initoe ne ki tafau, ma na ru lea ki tafau fuamu. Sulia na ru ne ki, na ru nau ki go tafau, ma nau ku saitamana kwatea tafau ga 'aku fuana ta wane ga 'ana ne nau ku filia. ");
INSERT INTO far_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma dia 'oe boruru, ma 'oe fa'inito nau, nau ku kwatea na 'initoe ne tafau go fuamu.” ");
INSERT INTO far_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ma sa Jesus nia olisia ka 'uri, “Na Kekedee Abu nia saea, ‘Taifilia God 'oe go ne 'oe fa'initoa, ma 'oe rao fuana.’” ");
INSERT INTO far_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Sui, sa Saetan ka talaia lau 'uria na fere baita be 'i Jerusalem, ma nia ka fauua ana te kula ne nia fane 'asiana 'i langi fafona na Beu Abu God. Ma nia ka fata 'uri fuana sa Jesus, “Dia 'oe na Wele God, 'oe lofo toli 'i ano fasia 'i seki. ");
INSERT INTO far_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Sulia na Kekedee Abu nia saea, ‘God ne kai kwatea mai na 'ainsel nia ki, fua kera ka susuli 'oe. ");
INSERT INTO far_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ma kera kai sako 'oe, fuana 'aemu boroi si foto ana ta gwa fau.’” ");
INSERT INTO far_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ma sa Jesus nia olisia ka 'uri, “Na Kekedee Abu nia fata laugo 'uri, ‘Nao 'oe si ilito'ona God 'oe.’” ");
INSERT INTO far_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","'I burina sa Saetan nia ilito'ona sa Jesus 'ana ru nai ki tafau, nia ka leka na fasia sa Jesus, ma ka makwalia ta kada lea ka oli. ");
INSERT INTO far_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ma na nikilalae ana na Anoeru Abu nia to fainia sa Jesus, ma nia ka oli na 'uria na lofaa 'i Galili. Ma na farongoe sulia ka talofia laona na bali lofaa nai tafau. ");
INSERT INTO far_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ma nia ka famanata laona na beu fuana folae kera ki, ma na wane ki tafau kera ka fata lea 'ani nia. ");
INSERT INTO far_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Sui sa Jesus ka leka 'uria 'i Nasaret, fere be nia baita mai laona. Ma ana Sabat, na nia ka leka 'i laona na beu fuana folae sulia na falafala nia. Ma nia ka tatae fuana idumilana na Kekedee Abu, ");
INSERT INTO far_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ma kera ka kwatea fuana, na kekedee na profet Aesaea. Ma nia ka 'ifingia, ma ka dao to'ona kula ne sa Aesaea nia kedea ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Na Anoeru ru God nia sura na aku, sulia nia fili nau fua nau ku fata sulia na Farongoe Lea fuana wane siofa ki. Ma nia ka kwate nau mai fua nau ku 'ainitaloa fuana wane ki ne kera to 'i laona beu ni kanie, kera kai aluge. Ma nau kai gura na wane ne maada rodo ki. Ma nau kai lugea na wane ki ne kera mala ta'a ada ki. ");
INSERT INTO far_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ma nau ku farongo ne kada nia dao na mai fua na 'Aofia ka famauria na wane nia ki.” ");
INSERT INTO far_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sui, nia ka lumia na kekedee nai, ma ka olitainia fuana wane ne nia ada sulia beu fuana folae ma ka gouru 'i ano ka famanata. Ma na wane ki tafau ne kera to 'i laona na beu fuana folae nai, kera ka bubu ngasi na fuana. ");
INSERT INTO far_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ma nia tala'ae ka fata fuada ka 'uri, “Kekedee Abu ne, nia fuli mamana na 'i ta'ena, ana kada ne mulu rongoa nau 'e idumia kau fua mulu.” ");
INSERT INTO far_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ma na wane ki tafau kera ka fata lea ana, ma kera ka kwele 'asiana sulia fatalana 'e lea. Ma kera ka fata 'uri, “'Uri ma nia nao lau na wele be sa Josef ne? Ma nia saea ne nia famamana na Kekedee Abu ne.” ");
INSERT INTO far_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ma sa Jesus ka fata 'uri fuada, “Nau ku saitamana kamulu kai fata 'uri fuaku, ‘Wane kwaigurai 'ae, 'oe gura 'oe basi talamu.’ Ma kamulu kai fata laugo 'uri fuaku, ‘'Oe sasia basi laona fere 'oe na ru be kalu rongoa 'oe sasia ki mai ana fere 'i Kapaneam.’” ");
INSERT INTO far_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Sui sa Jesus ka fata lau 'uri, “Nau ku saea na ru mamana fua mulu, nia 'afitai fuana kera ka kwaloa na profet 'i laona fere nia talana. ");
INSERT INTO far_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nau ku saea fua mulu, na keni 'oro Jiu ki ne kera 'oru, kera to 'i Israel ana kada sa Elaeja nia to ana. Ma kada be na ute nao si 'aru sulia olu fangali ma ono madame ki, ma na fioloe baita ka liu laugo ana fere kia ki tafau. ");
INSERT INTO far_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ma God nao si kwatea lau sa Elaeja siana gwa 'oru ne kera 'i Israel ki. Boroi ma nia kwatea lalau sa Elaeja siana te gwa 'oru ne nao lau keni Jiu ne nia to 'i Serefat, fere laona bali lofaa 'i Saedon. ");
INSERT INTO far_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma na wane 'oro Jiu ki 'i Israel na kuu nia saungida, ana kada sa Elaesa nia profet. Ma nia nao si gura go ta wane 'ada. Taifilia go sa Neman na wane ne nao lau Jiu ne leka mai fasia lofaa 'i Siria go ne sa Elaesa nia gura.” ");
INSERT INTO far_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ma kada kera rongoa ru nai, na wane ki tafau laona na beu fuana folae kera ka guisasu. Kera guisasu sulia ne sa Jesus saea God ne kai 'adomia lalau na wane ne nao lau Jiu ki, ma kera ka nao. ");
INSERT INTO far_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ma kera ka tatae, ma kera ka tara sa Jesus fasia na fere nai. Ma kera ka suikwailiu na ana 'uria gwauna fa uo ne kera saungainia na fere kera 'i fafona, fua kera ka 'ui 'ania sa Jesus 'i ano, fua nia ka mae. ");
INSERT INTO far_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Boroi ma, nia dola ga 'ana 'i safitana na okue nai, ma ka leka na 'ana fasida. ");
INSERT INTO far_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sui, sa Jesus ka leka 'uria 'i Kapaneam, ta fere ana lofaa 'i Galili. Ma ana te Sabat, nia ka famanata wane ki senai. ");
INSERT INTO far_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ma na wane ne kera oku mai siana 'i laona beu fuana folae kera kwele 'asiana ana famanatalae nia ki, sulia sa Jesus nia fata ana nikilalae God. ");
INSERT INTO far_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma te wane ne anoeru ta'a 'e rufia, nia to laugo senai. Go nia ka akwa ka 'uri, ");
INSERT INTO far_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Sa Jesus wane 'i Nasaret 'ae, nau ku saitamana 'oe na Wane Abu God. Te ne 'oe doria 'oe sasia amalu? Alamia 'oe leka mai fuana fafunu lamalu 'oto ne?” ");
INSERT INTO far_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Sa Jesus ka balufia na anoeru ta'a nai, ka 'uri, “'Oe nofo 'amu, ma 'oko ru mai 'i maa fasia wane nena!” Ma na anoeru ta'a nai ka 'ui 'ania wane nai 'i ano 'i naofana okue nai, ma ka fi ru tafa na mai fasia. Ma na wane nai nao si maala go. ");
INSERT INTO far_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Na wane ne kera oku senai ki, kera kwele 'asiana, ma kera ka ledi kwailiu ada, ma kera ka 'uri, “Na famanatalae te na ne 'uri? Wane ne nia ifulangainia na anoeru ta'a ki 'ana mamanae fainia nikilalae, ma kera ka sakatafa tafau mai 'i maa!” ");
INSERT INTO far_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ma na farongoe sulia sa Jesus ka talo ana fere ki tafau kalikalia bali lofaa nai. ");
INSERT INTO far_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Sui sa Jesus nia ka leka fasia na beu fuana folae ma ka leka 'i lume sa Simon. 'Urinai ma na fungo keni sa Simon, nia matai ana 'ako'akoe baita ana kada nai. Ma kera ka gania sa Jesus fua ka gura. ");
INSERT INTO far_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","'Urinai go sa Jesus leka ka uu 'i ninimana 'ifitai keni nai, ma nia ka fi ngatafia na 'ako'akolae nai fasia. Ma na 'afe nai ka 'akwa na, ma nia ka tatae ka sasi fanga fuada. ");
INSERT INTO far_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ana kada ne sato nia su na, wane 'oro ki kera ngalia mai siana sa Jesus, na wane kwaimani kera ki ne mataie 'e'ete ki saungida. Ma sa Jesus ka alua 'abana fafida, ma ka gurada tafau. ");
INSERT INTO far_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ka 'urinai lau, anoeru ta'a 'oro ki kera tafi fasia wane ki, ma kera ka akwa 'uri, “'Oe na Wele God!” Ma sa Jesus ka lui talingai ana anoeru ta'a nai ki nao kera si fata, sulia kera saitamana ka suina ne nia na Christ, na wane God nia filia fuana lafutailana wane nia ki. ");
INSERT INTO far_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","'Ofodangi kada nia la na, sa Jesus nia leka fasia fere 'i Kapaneam, ka leka 'uria ta kula ne aroaro. Ma na wane ki kera ka tala'ae kera nani 'uria, ma kada kera dao to'ona, kera ka fata 'uri fuana, “'Oe si leka fasia na fere ne.” ");
INSERT INTO far_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Boroi ma sa Jesus ka fata 'uri fuada, “God nia kwate nau mai fuana 'ainitaloa na Farongoe Lea, 'urinai ne nau kai leka kau laona tani fere 'e'ete laugo, fua nau ku 'ainitaloa ne God kai gwaungai ana wane nia ki.” ");
INSERT INTO far_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ma sa Jesus ka 'ainitalo ana Farongoe Lea laona beu fuana folae ki ana bali lofaa ki 'i Israel. ");
INSERT INTO far_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ana te maedangi, sa Jesus nia uu ka famanata 'i ninimana 'osi baita 'i Galili, ma na wane 'oro ki kera faisusu mai siana fuana rongolana na fatalana God. ");
INSERT INTO far_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma nia ka ada to'ona na ro baru na wane dee ki kera fasia ka to ga 'ana 'i malitakwa, ma kera ka taufia na furai kera ki. ");
INSERT INTO far_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ma sa Jesus nia ka ra 'i laona baru sa Simon, ma ka saea fuana nia ka usungai tu'u kau ana fasia 'i sara. Ma sa Jesus ka to 'i laona na baru nai, ma ka inau ana famanatalana na wane ki. ");
INSERT INTO far_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ma kada nia famanata na wane ki ka suina, nia ka fata 'uri fuana sa Simon, “Mulu usungainia lau kau na baru ne 'uria kula lola, sui kamulu ka ala 'ania na furai kamulu ki fuana deelana mai na ie ki.” ");
INSERT INTO far_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ma sa Simon ka olisia ma ka 'uri, “Famanata 'ae, kalu rao ulafu na mai sulia rodo lalau ne, boroi ma nao kalu si deea go ta ie. Boroi ma sulia fatalamu, nau ku ala 'ania na furai ne ki.” ");
INSERT INTO far_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ma kada kera ala 'ania na furai nai ki, kera ka deea na ie 'oro 'asiana, ma na furai ki karangi ka muu na. ");
INSERT INTO far_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Sui kera ka karumia mai na wane kwaimani kera ki 'i laona te baru lau, fua kera ka leka mai, kera ka kwai'adomi ada. 'Urinai kera ka dao mai, ma kera ka fafungua ro baru nai ki ana ie leka karangi kera ka kuruu go. ");
INSERT INTO far_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ma kada sa Simon Pita nia ada to'ona na ru nai, nia leka mai ka boruru 'i naona sa Jesus, ma ka fata 'uri, “'Aofia 'ae, leka kau 'amu fasi nau! Nau na wane ta'a 'asiana!” ");
INSERT INTO far_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Sa Simon fainia na wane ne kera to senai ki, kera ka kwele 'asiana ana ie 'oro ne kera deea. ");
INSERT INTO far_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ma na ro wane ne keroa rao fainia sa Simon, ne satada sa Jemes ma sa Jon, na ro wele sa Sebedi ki, keroa ka kwele laugo. Ma sa Jesus ka fata 'uri fuana sa Simon, “Nao 'oe si mau lau. 'I nao be 'oe deea ie ki, boroi ma safali 'i ta'ena ka oli 'alaa, 'oe deea lalau na wane ki fua kera ka famamana God.” ");
INSERT INTO far_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ma kada kera dao na 'i sara, kera ka fasia na baru ki sulia one, ma kera ka fasia ru ki tafau, ma kera ka leka na fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ana te maedangi, sa Jesus nia to 'i laona te fere, ma te wane ne kuu nia saungia, nia to laugo senai. Kada nia ada to'ona sa Jesus, nia leka mai siana, ka boruru 'i naona, ma ka amasia ka 'uri, “'Aofia 'ae, dia 'oe nonimabe, 'oe saitamana gura nau ga 'amu.” ");
INSERT INTO far_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Sui sa Jesus ka taga kau na 'abana, ma ka samo to'ona nonina, ma ka fata 'uri, “Iu ka, nau ku nonimabe. 'Oe mafo na.” Ma 'ali'ali burina fatae nai ki sa Jesus saea go, na kuu nai ka siki na fasia wane nai. ");
INSERT INTO far_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Sui sa Jesus ka fata totongai fuana wane nai ka 'uri, “Nao 'oe si farongoa lau ana ta wane ana ru ne ki. Boroi ma 'oe leka basi 'amu siana na fataabu, ma 'oe fatainia na nonimu fuana, fua nia kai saitamana ne 'oe 'akwa na. Sui 'oko kwatea na afafue 'oe dia be sa Moses nia saea fuana kwatelana, fua ka kwatea famamanae fuana wane ki tafau ne nonimu nia 'e mafo na.” ");
INSERT INTO far_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nia ka 'urinai boroi 'ana, na farongoe sulia ru ne sa Jesus fulia ki, nia talofia na kula 'oro ki, ma na wane 'oro ki kera ka leka mai siana fuana rongolana famanatalae nia ki, ma fua sa Jesus ka gurada laugo fasia na mataie kera ki. ");
INSERT INTO far_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ma kada 'oro, sa Jesus nia leka fasia wane ki 'uria kula aroaro ki fuana folae. ");
INSERT INTO far_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Te maedangi, kada sa Jesus nia famanata laona te lume, tani Farasi fainia wane famanata ana taki ki, kera to laugo senai. Kera leka mai fasia fere 'oro ki ana lofaa 'i Galili fainia 'i Jiudea, ma 'i Jerusalem. Ma na nikilalae God ka to fainia sa Jesus, fua nia ka gura wane ne kera matai ki. ");
INSERT INTO far_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ma tani wane ngalia mai te wane ne nonina mae, kera ngalia mai 'i fafona 'ifitai. Kera ka sasi ngangata 'uria rulae lao lume fainia, fua kera ka alua 'i naona sa Jesus, fuana nia ka gura. ");
INSERT INTO far_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Boroi ma sulia na okue nai baita 'asiana, wane kwaimani ana wane ne si bobola na fuana rulae kau 'i lume siana sa Jesus. 'Urinai kera ka ngalia wane nai, kera ka ra fainia 'i fafona lume, ma kera ka tafangia te mae kwakwa baita, kera ka fakosoa mai na wane nai 'i fafona 'ifitai nia siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ma kada sa Jesus nia ada saitamana na famamanae kera, nia ka fata 'uri fuana wane ne nonina mae, “Wane nau 'ae, nau ku manatalugea na ta'alae 'oe ki.” ");
INSERT INTO far_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ma na wane famanata ana taki ki fainia Farasi ki, kera ka ngunungunu buri fuada kwailiu ma kera ka fata 'uri, “Wala 'ae! Nia saea nia ta wane 'uta ne? Nia fabolotania fainia God. Wane ki nao si manatalugea ta'alae ki. Taifilia go God ne saitamana manatalugea ta'alae ki.” ");
INSERT INTO far_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Sa Jesus nia saitamana manatalada, ma ka fata 'uri fuada, “Kamulu si manata lau 'urinai.” ");
INSERT INTO far_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","'Urinai go nia ka fata 'uri, “Dia nau ku fata 'uri fuana wane nonina mae ne ku 'uri, ‘Ta'alae 'oe ki, nau ku manatalugea na,’ kamulu si ada to'ona go ne nia fuli. Boroi ma dia nau ku fata 'uri, ‘Tatae, ma 'oko fali,’ senai kamulu ka fi ada to'ona ne na nikilalae 'e nia aku fuana gurae. ");
INSERT INTO far_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kada nau gura wane ne, nau fatainia fua mulu ne nau, na Wele nia Wane, nau ku too ana nikilalae fuana manatalugelana na ta'alae ki.” Sui sa Jesus ka fata 'uri fuana wane nonina mae nai, “Nau ku saea fuamu, 'oe tatae na, ngalia 'ifitai 'oe, ma 'oko leka na 'i fere 'oe.” ");
INSERT INTO far_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ma na wane nai, 'ali'ali nia ka tatae na 'i naoda, go nia ka ngalia 'ifitai ne nia tio 'i fafona, ma ka oli 'i fere fainia tangolae baita fuana God. ");
INSERT INTO far_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma kera tafau kera ka kwele 'asiana, ma kera ka tangoa God. Ru ne kera ada to'ona kera kwele 'asiana, kera 'uri, “Iu ka, ru ni kwelea baita 'asiana ne kulu suana 'i ta'ena.” ");
INSERT INTO far_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Burina ru nai, sa Jesus nia leka kau 'i maa, ma ka ada to'ona sa Lifae, na wane ni konilana malefo ana takisi, nia gourue ana kula ne nia rao ana. Sa Jesus ka fata 'uri fuana, “'Oe leka mai fai nau.” ");
INSERT INTO far_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Sa Lifae ka tatae, ma ka fasi buri ana ru nia ki tafau, ma ka leka fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Sui sa Lifae ka sasia te fafanga baita fuana sa Jesus 'i lume nia. Ma ana kada nai laugo, na wane 'oro ne kera konia malefo 'ana takisi ki fainia tani wane lau, kera fanga fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Tani Farasi ma wane famanata ana taki ki kera ka guisasu, ma kera ka fata 'uri fuana fafurongo sa Jesus ki, “Nia bobola fainia nia si fanga ma ka ku lau fainia wane ni konilana malefo ana takisi ma wane ta'a 'urinai ki.” ");
INSERT INTO far_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Sa Jesus nia olisida ka fata 'uri, “Wane ne nao kera si matai ki, kera si doria go ta wane kwaigurai, boroi ma wane ne kera matai ki, kera ka bobo 'uria wane kwaigurai. ");
INSERT INTO far_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nau kusi leka lau mai fuana riilae 'uria wane 'o'olo ki fua kera kai kari abulo, boroi ma na wane ne abulolada ta'a ki lalau ne, nau ku leka mai fuana riilae 'uria talalana manatalada.” ");
INSERT INTO far_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tani wane kera fata 'uri fuana sa Jesus, “Ana kada 'oro ki, na fafurongo sa Jon ki kera abu fanga fuana folae ma na fafurongo Farasi ki kera ka 'urinai laugo. Boroi ma na fafurongo 'oe ki, kera fanga ma kera ka ku ga 'ada.” ");
INSERT INTO far_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sa Jesus olisida ka fata 'uri, “Nia si bobola fainia tooa ne kera to ana fafanga ana araie ne kera ka abu fanga. Sulia ne, kada arai falu nia to ga 'ana 'ua faida, wane ki kera eele ga 'ada 'ua. ");
INSERT INTO far_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Boroi ma kada ne kai dao mai, kada ne kera kai talaia na arai falu fasida. Senai, kera fi abu fanga lau, sulia ne kera kwaimanatai. Nia ne nao si bobola fua fafurongo nau ki kera ka abu fanga ga 'ada kada nau ku to 'ua faida.” ");
INSERT INTO far_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sui sa Jesus ka fata ana tarifulae fuada laugo 'uri, “Nia si bobola fua mulu ngali ta ngingisi maku falu fuana modelana ta maku ne nia 'ua. Dia ta wane nia sasia na ru nai, na ngingisi maku falu nai ka musia na maku 'ua nai, sulia maku falu nia lukuluku 'i burina taufilana, ma na maku falu si ada lea go fainia na maku 'ua. ");
INSERT INTO far_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ma mulu saitamana laugo ana, nao nia si bobola fuana ta wane ka alua na waeni falu 'i laona ngwai 'ua ana 'ungana nanigot, sulia ngwai ru 'ua nai nao si bose. Suli dia nia sasia na ru 'urinai, kada na waeni nai kai torotoro go mai, nia ka fogea na ngwai ru 'ua nai, ma na waeni nai ka 'igitai, ma na ngwai ru nai ka ta'a na. ");
INSERT INTO far_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nia ne wane kai alua waeni falu 'i laona na ngwai ru falu ne nia saitamana kai bose. ");
INSERT INTO far_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","“Te wane ne 'idufa kufia ga 'ana waeni 'ua, nao nia si doria na waeni falu. Sulia nia fata 'uri, ‘na waeni 'ua ne kufilana mamasia ka lea.’” ");
INSERT INTO far_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Te Sabat, sa Jesus fainia fafurongo nia ki kera leka, ma kera ka liu folo ana te oole witi. Ma kada kera liu ana, na fafurongo nia ki kera ka ngeda tani fueru, ma kera ka 'asa'asa laona 'abada, ma kera ka 'ania. ");
INSERT INTO far_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma kada wane ana Farasi ki kera ada to'ona, kera ka fata 'uri, “Ru ne kamulu sasia nia 'oia na taki sa Moses, sulia kamulu ngeda witi ne ana Sabat, maedangi ana mamalolae.” ");
INSERT INTO far_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sa Jesus ka olisida ka 'uri, “Nau ku saitamana kamulu idumia sulia laona Buko Abu na ru be sa Deved na kingi nia sasia 'i nao. Ana kada nai, sa Deved fainia wane nia ki kera fiolo 'asiana, ");
INSERT INTO far_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","nia ka leka 'i laona na 'O'obe Abu God, ma na 'inita fataabu ka kwatea fuana sa Deved na beret ne kera 'auabua fuana God. Ma sa Deved ka 'ania na beret nai, ma ka kwatea laugo fuana wane nia ki, ma kera ka 'ania. Boroi ma na taki kulu alamatainia fuana taifilia go na fataabu God ki ne kera saitamana 'anilana. Ma nao kulu si ada to'ona laona Buko Abu ne God nia guisasu fuana sa Deved.” ");
INSERT INTO far_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Sui sa Jesus ka fata na 'uri, “Nau, na Wele nia Wane, nau ku too ana na nikilalae fuana saelana ru ki fuana wane ki kera saitamana ka sasia ga 'ada ana Sabat.” ");
INSERT INTO far_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ma ana te Sabat laugo, sa Jesus ka leka laona beu fuana folae ma ka famanata. Ma te wane nia to laugo senai ne 'aba 'o'olo nia 'e mae. ");
INSERT INTO far_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ma tani wane famanata ana taki ki, ma na Farasi ki, kera ka to laugo senai, ma kera ka adaada 'uria dia sa Jesus kai gura wane nai ana Sabat. Dia 'urinai, kera ka fata maana sa Jesus ana 'oilana taki God ana gurae, ru nai kera manata sulia nia dia raoe. ");
INSERT INTO far_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ma sa Jesus nia saitamana ga 'ana manatada, ma nia ka fata 'uri fuana wane ne 'abana mae, “Tatae mai, 'oko uu mai 'i naona wane ki tafau.” Ma wane nai ka tatae, ma ka leka mai siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ma sa Jesus ka fata 'uri fuana Farasi ki, ma na wane famanata ana taki ki, “Nau ku ledi kamulu basi. Te ne taki kulu nia alamatainia fua kulu ka sasia ana Sabat? Nia alamatainia sasilana ru lea ki, naoma sasilana ru ta'a ki? Nia alamatainia na famaurilana ta wane, naoma saungilana ta wane?” ");
INSERT INTO far_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Sa Jesus nia fata 'urinai ka sui, nia ka ada kwailiu fuada, go nia ka fata 'uri fuana wane ne 'abana nia mae, “Taga na 'abamu.” Ma nia ka taga, ma na 'abana ka lea na. ");
INSERT INTO far_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ana kada kera suana, kera ka guisasu 'asiana, ma kera ka fata oku sulia te ne kera kai sasia ana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ana te kada laugo, sa Jesus ka ra 'uria gwauna fa uo fua nia ka fo. Ma laona rodo lalau nai, nia 'e fosia God. ");
INSERT INTO far_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kada nia 'ofodangi na, nia ka saea mai fafurongo nia ki siana, ma ka filia akwala ma ro wane, ma ka saeda lifurongo ki. ");
INSERT INTO far_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Na satada: sa Simon ne sa Jesus fasata 'ana sa Pita, ma sa Andru na sasina, ma sa Jemes, ma sa Jon, ma sa Filip, ma sa Batolomiu, ");
INSERT INTO far_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ma sa Matiu, ma sa Tomas, ma sa Jemes na wele sa Alfeas, ma sa Simon te wane ana wane Jiu ki be kera doria tarilana wane Rom ki fasia 'i Israel, ");
INSERT INTO far_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ma sa Jiudas na wele sa Jemes, ma sa Jiudas Iskariot na wane ne nia ne kai 'olomaelana sa Jesus fuana malimae nia ki. ");
INSERT INTO far_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Sa Jesus nia koso mai fasia 'i gwauna uo nai fainia na akwala ma ro lifurongo nia ki, ma ka uu ana kula ote fainia na okue baita nai ne tani wane lau ana fafurongo nia ki. Ma tani wane 'oro lau ne kera leka mai fasia bali lofaa 'i Jiudea, ma fainia fere baita 'i Jerusalem, ma na fere ki 'i Taea ma 'i Saedon ne kera to sulia asi, kera to laugo senai. ");
INSERT INTO far_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kera leka mai fuana rongolana sa Jesus, ma fua sa Jesus ka gurada fasia na mataie kera ki. Ma na wane ne kera to ana anoeru ta'a ki, kera leka laugo mai, ma sa Jesus ka gurada. ");
INSERT INTO far_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Na wane ki tafau kera ili 'uria samolae to'ona sa Jesus, sulia na nikilalae nia leka kau fasia fuana guralana na wane ki tafau. ");
INSERT INTO far_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sa Jesus ka ada kau fuana fafurongo nia ki ma ka fata 'uri, “Elelae fua mulu wane ne kamulu siofa ki, sulia ne God ka gwaungai fafi kamulu. ");
INSERT INTO far_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Elelae fua mulu wane ne kamulu fiolo ana kada ne ki, sulia kamulu ne kai abusu. Elelae fua mulu wane ne kamulu angi ana kada ne ki, sulia kamulu ne kai ngwaela. ");
INSERT INTO far_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Elelae fua mulu kada na wane ki kera kai famalagaigai kamulu, ma kera ka ifulangai kamulu, ma kera ka fata fali kamulu, ma ka fuusi ta'a amulu, sulia kamulu rosuli nau na Wele nia Wane. ");
INSERT INTO far_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kamulu kai eele, ma mulu ngwae sakasaka 'ana eelea baita kada ne wane ki kera kai sasi 'urinai amulu, sulia na kwaiarae baita nia makwali kamulu 'i langi. Nau ku saea ru nai sulia kera ne kai sasia laugo ru ta'a fua mulu ne koko kera ki sasia ana profet ki mai 'i nao. ");
INSERT INTO far_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Boroi ma, nia kai ta'a 'asiana fua mulu na wane ne kamulu to ana toorue ki ana kada ne, sulia totodae ne ki kamulu too ana kai sui. ");
INSERT INTO far_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Nia kai ta'a 'asiana fua mulu na wane ne kamulu fanga abusu ki ana kada ne, sulia kamulu ne kai fiolo. Nia kai ta'a 'asiana fua mulu na wane ne kamulu ngwaela ki ana kada ne, sulia kamulu ne kai omaee, ma mulu angi. ");
INSERT INTO far_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Nia ta'a 'asiana fua mulu kada ne wane ki kera fata lea amulu, sulia na koko kera ki, kera sasia laugo ru nai ki fuana profet susuke ki.” ");
INSERT INTO far_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Sa Jesus nia famanata laugo ka 'uri, “Nau ku saea fua mulu na wane ne kamulu rongo sulia fatalaku, mulu kwaimani ana na malimae kamulu ki, ma mulu sasi lea fuana wane ne kera famalagaigai kamulu ki. ");
INSERT INTO far_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ma mulu fosia God, fua nia kai falea wane ne kera agi kamulu, ma mulu fo fuana wane ne kera sasia ru ta'a amulu. ");
INSERT INTO far_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ma dia ta wane ka fidalia na satemu, 'oe alamatainia nia ka fidalia lau ta bali sate. Ma dia ta wane ka ngalia na maku gwala 'oe, 'oe alamatainia nia ka ngalia laugo na maku lola 'oe fuana. ");
INSERT INTO far_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ma 'oe kwate fua ta wane boroi 'ana ne nia kai gania ta ru amulu. Ma dia ta wane nia ngalia ta ru ana ru 'oe ki, nao 'oe si gania lau fuana olitailana fuamu. ");
INSERT INTO far_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ta te ne kamulu doria na wane 'e'ete ki kera kai sasia fua mulu, kamulu ka sasia laugo fuada. ");
INSERT INTO far_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ma dia kamulu kwaimani go amulu ana wane ne kera kwaimani amulu ki, nao kamulu si ngalia go ta kwaiarae. Sulia na wane ta'a ki boroi, kera kwaimani laugo ana wane ne kera kwaimani ada ki. ");
INSERT INTO far_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ma dia kamulu sasi lea go amulu fuana wane ne kera sasi lea fua mulu ki, nao kamulu si ngalia go ta kwaiarae. Sulia ne wane abulo ta'a ki boroi, kera sasi laugo 'urinai. ");
INSERT INTO far_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ma dia kamulu kwate ru go amulu fuana wane ne kera saitamana kera ka duua fua mulu, nao kamulu si ngalia go ta kwaiarae. Sulia ne wane abulo ta'a ki boroi, kera sasi laugo 'urinai fuana wane abulo ta'a ki, fua kera ka duua fuada. ");
INSERT INTO far_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Boroi ma kamulu kai kwaimani ana malimae kamulu ki, ma mulu sasi lea fuada, ma kamulu kai kwate ru ma nao kamulu si makwalia lau na duulana. Dia kamulu sasi 'urinai, kamulu ne kai ngalia na kwaiarae baita, ma na abulolamulu ne kai dia God na Maa kamulu ne nia 'inito ka tasa. Sulia God nia sasi lea fuana wane ta'a ki ma wane ne nao kera si eele fainia te ne nia sasia fuada. ");
INSERT INTO far_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mulu kwaimanatai ana wane ki, ka dia laugo na Maa kamulu ne nia kwaimanatai amulu. ");
INSERT INTO far_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Nao kamulu si ketoa ta wane 'e'ete, fasi God ka keto kamulu laugo. Ma nao kamulu si saea na kwaekwaee fuana tani wane 'e'ete, ma God nao si kwatea laugo na kwaekwaee fua mulu. Mulu manatalugea wane ki, ma God kai manataluge kamulu laugo. ");
INSERT INTO far_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Mulu kwate ru ki fuana wane ki, ma God kai kwate ru laugo fua mulu. Ma God ne kai kwatea na kwatea ne nia dia ta wane be nia fafungua ta ngwai ru ne nia nekea, leka nia ka fungu lea go ma ka fungu 'alama go. Ma God ne kai kwate fua mulu, dia laugo ne kamulu kwate fuana wane 'e'ete ki.” ");
INSERT INTO far_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Sa Jesus nia fata laugo sulia tarifulae fuada ka 'uri, “Ta wane ne maana 'e rodo, nia 'afitai ka talaia lau ta wane ne maana rodo. Dia nia sasi 'urinai, keroa tafau go ne kai 'asida laona kilu. ");
INSERT INTO far_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Dia, na wane ne nia ka rongo ru ga 'ana, nia 'afitai ka liufia na wane ne famanata nia. Ma dia na wane rongo ru nia ka ngali tafau ru ne wane famanata nia kwate fuana ki, nia kai dia laugo na wane ne famanata nia. ");
INSERT INTO far_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“'Oe ko too ana ta'alae baita ki, boroi ma 'oe ka ngatafia na 'amu ta wane ne nia to go ana ta'alae tu'u. 'Oe ko dia ta wane ne nia ada to'ona na gegeo 'i laona na maana wanefuta, boroi ma nia si ada to'ona go na bui ano baita ne nia laona maana talana. ");
INSERT INTO far_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ma 'oko fata 'uri fuana wane 'e'ete, ‘'Oe si sasia ta ru ne nia ta'a.’ Boroi ma 'oe si manata 'abero go ana ta'alae baita ne 'oe sasia ki. 'Oe wane kwalabasa. 'Oe fasia basi na ta'alae 'oe ki. Sui, 'oko fi bobola fuana kwai'adomilae kau ana ta wane 'e'ete fuana ta'alae nia ki.” ");
INSERT INTO far_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sa Jesus ka fata laugo ana te tarifulae fuada ka 'uri, “Na 'ai ne nia bulao ka lea, nia 'afitai ka fungu ana fueru ta'a ki. Ka dia laugo, na 'ai ne nia bulao ka ta'a, nia 'afitai ka fungu ana na fueru lea ki. ");
INSERT INTO far_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Kulu saitamana 'ai ki tafau, sulia fufue ru kera ki ne kera fungu ana. Ma nia 'afitai ta wane ka ngeda na fufuana 'ai lea fasia na 'oko ngangara. ");
INSERT INTO far_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma na wane lea nia sasia laugo na ru lea ki sulia na manatae wane sasaolia nia. Ma na wane ta'a nia sasia laugo na ru ta'a ki sulia na manatae wane bilia nia. Na ru ne nia to 'i laona na manatana wane, nia 'e ru mai 'i maa ana fatalana.” ");
INSERT INTO far_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Ma sa Jesus ka fata lau 'uri, “'Uta ne, kada kamulu fata fai nau, kamulu ka saea nau 'ana 'Aofia, boroi ma nao kamulu si sasia go sulia na ru ne nau ku saea fua mulu ki? ");
INSERT INTO far_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Sa ti boroi ana ne nia leka mai siaku, ma ka rongo sulia na fatalaku, ma ka sasi sulia, nau fatainia fua mulu na fitoe nia, ma na tolana. ");
INSERT INTO far_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nia dia na wane ne nia saungainia lume nia, ma nia ka 'elia na mae funu 'ai ki ka koso lola. Aia, ma ana kada na ute ka to, ma na kafo nia igwa mai, nia 'afitai ka okosia, sulia nia saungainia lume nia 'i fafona na mae funu 'ai ki ne nia 'elida ka koso lola. ");
INSERT INTO far_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ma na wane ne nia rongoa na fatalaku, ma nao si sasi sulia, nia dia wane ne nia saungainia lume nia fafona one, nao nia si 'elia mae funu 'ai si koso lola go. Kada kafo nia igwa mai, ma ka foto ana lume nai, nia ka 'asia, ma ka takalo tafau na.” ");
INSERT INTO far_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kada sa Jesus nia fasuia na fatalana fuana wane ki, nia ka leka na 'uria fere 'i Kapaneam. ");
INSERT INTO far_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma te wane senai, nia matai ka baita ma ka karangi mae na. Na wane nai, nia na wane rao ana te wane fanaonao ana wane ni omee ki fasia 'i Rom. Ma na wane baita nai, nia manata baita 'asiana ana na wane rao nia. ");
INSERT INTO far_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ma kada ne wane baita ana omee nai nia rongoa ne sa Jesus nia dao mai, nia ka kwatea tani wane fanaonao ana Jiu ki, fua kera ka saea sa Jesus ka leka mai, fua ka gura na wane rao nia. ");
INSERT INTO far_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kada kera dao siana sa Jesus, kera ka amasia, kera ka 'uri, “Na wane baita ana omee ne nia bobola fainia 'oe kwai'adomi ana na wane rao nia, ");
INSERT INTO far_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","sulia wane baita nai nia kwaimani 'asiana fua malu Jiu ki, ma nia ka saungainia te beu fuana folae fua malu 'i seki.” ");
INSERT INTO far_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","'Urinai sa Jesus ka leka na faida. Ma kada nia dao karangia na kau na lume, na wane fanaonao nai 'i Rom ka kwatea lau kau na wane kwaimani nia ki, fua kera ka fata 'uri fuana, “Arai baita 'ae, 'oe si 'abero lau. Nau nao si bobola fua ne 'oe leka mai 'i laona lume nau. ");
INSERT INTO far_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ma nau boroi si bobola laugo fuana lekalae kau siamu tala'aku. 'Oe fata go mai 'amu, ma na wane ni rao nau kai 'akwa na. ");
INSERT INTO far_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nau ku saitamana 'oe bobola ga 'amu fuana sasilana ru nai, sulia nau talaku na wane nau ku rao 'i farana na wane baita ki, ma nau ku too ana wane ni omee ki ne kera rao 'i farana na baita nau. Ma dia nau ku saea ta wane ku 'uri, ‘'Oe leka,’ ma nia ka leka. Ma dia nau ku saea ta wane ku 'uri, ‘'Oe leka mai,’ nia ka leka mai. Ma dia nau ku saea ta wane ni rao nau ka 'uri, ‘'Oe sasia ru ne,’ nia ka sasia na.” ");
INSERT INTO far_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ana kada sa Jesus nia rongoa ru nai, nia ka kwele 'asiana. Ma nia ka abulo, ma ka fata 'uri fuana wane ne kera leka 'i burina ki, “Nau ku saea fua mulu, nau nao si ada 'ua to'ona ta wane ne nia famamana ka 'uri, sui boroi 'ana laona 'i Israel.” ");
INSERT INTO far_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ma na wane ngali farongoe nai ki, kera ka oli 'uria 'i lume na wane baita ana omee be, ma kera ka ada to'ona na wane matai be nia 'akwa na. ");
INSERT INTO far_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ma nao nia si tau go 'i burina ru nai ki, sa Jesus fainia na fafurongo nia ki, ma wane 'oro ki laugo, kera leka 'uria te fere ne kera saea 'ana 'i Nein. ");
INSERT INTO far_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ma kada nia dao karangia maana na mae tafa ana na fere nai, tai wane kera ngalia mai te wane mae, ma kera ka leka na mai 'i maa. Na wane mae nai, nia na wele mutai te gwa 'oru. Ma na okue baita kera ka leka mai fainia fuana faitolilae ana. ");
INSERT INTO far_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ma kada sa Jesus, na 'Aofia, nia ada to'ona na gwa 'oru nai, nia ka kwaimanatai 'asiana ana, ma ka fata 'uri fuana, “'Oe si angi lau.” ");
INSERT INTO far_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Sui nia ka leka kau, ma ka samo to'ona na tatafe ne wane mae nai nia tio fafona, ma na wane ne kera ngalia wane mae nai, kera ka uu ngado. Go sa Jesus ka fata 'uri, “Wane fi baita 'ae, nau ku saea fuamu, 'oe tatae!” ");
INSERT INTO far_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ma na wane fi baita be ka tatae na, ma ka safali ka fata. Ma sa Jesus ka kwatea na fuana gaa nia. ");
INSERT INTO far_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ma na wane ne kera ada to'ona ru nai ki, kera ka kwele 'asiana, ma kera ka tangoa God, kera 'uri, “Te profet 'initoa nia sakatafa na mai 'i safitakulu. God nia dao na mai fuana 'afilakulu na wane nia ki.” ");
INSERT INTO far_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma na farongoe sulia sa Jesus, ka talofia na laona bali lofaa 'i Israel, ma na bali ana fere ki kalikalia laugo. ");
INSERT INTO far_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ana kada ne fafurongo sa Jon ki kera farongo nia ana na raolana sa Jesus, sa Jon ka saea mai ro fafurongo nia ki siana, ");
INSERT INTO far_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ma ka eresi keroa ka leka kau siana sa Jesus, na 'Aofia, 'uria ledilana kera 'uri, “'Uri ma 'oe na ne na Christ, wane ne kai dao mai, naoma kalu makwalia lau ta wane 'e'ete?” ");
INSERT INTO far_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ma ana kada keroa dao siana sa Jesus, keroa ka ledi 'uri ana, “Sa Jon wane ni Siuabu nia odu karo mai fua ledi 'oe, 'Uri ma 'oe na ne na Christ, wane ne kai dao mai, naoma kalu makwalia lau ta wane 'e'ete?” ");
INSERT INTO far_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma ana kada nai laugo, sa Jesus nia gura wane matai 'oro ki, ma nia ka ifulangainia na anoeru ta'a ki fasia na wane ki, ma ka gura na wane ne maada rodo ki. ");
INSERT INTO far_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Nia ne sa Jesus ka fata 'uri fuadaro, “Kamoro oli kau, moro ka farongoa sa Jon ana ru ne ki kamoro suana, ma kamoro ka rongoa 'i ta'ena. Wane maada rodo ki, kera ada na. Ma wane 'aeda mae ki, kera fali na. Ma na wane ne kuu nia saungida ki, kera ka mafo na. Ma wane ne alingada boko ki, kera ka rongo na. Ma wane ne kera mae ki, kera ka mauri lau. Aia, ma na Farongoe Lea, nau ku 'ainitaloa na 'ana fuana wane siofa ki. ");
INSERT INTO far_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","God kai falea na wane ki tafau ne nao kera si noni'ela 'ani nau, sulia na ru nau ku sasia ki.” ");
INSERT INTO far_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","'I burina na ro fafurongo sa Jon ki keroa oli na, sa Jesus ka fata sulia sa Jon fuana wane ne kera oku senai ki ka 'uri, “Ana kada kamulu leka siana sa Jon laona bali lofaa 'eke'eke, sa ti ne kamulu leka fuana adalae to'ona senai? Ta wane ne manata ruarua ka dia ga 'ana ta ngosa rade ne nia gelogelo ana kuburu? Nao! Sa Jon nia nao lau wane 'urinai. ");
INSERT INTO far_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","'Uri ma, te ne kamulu leka fuana adalae to'ona? Ta wane ne nia 'afisia na maku ne folilana baita? Nao! Sulia wane ne kera ofi 'urinai ki, kera 'initoa, ma kera ka to 'i laona lume kingi ki. ");
INSERT INTO far_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kamulu farongo nau mai. Te ne kamulu leka kau fua adalae to'ona? Ta profet? Iu! Nia ta profet mamana! Ma nia liufia na profet 'i nao ki tafau. ");
INSERT INTO far_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Sa Jon na be kera kekede sulia laona Kekedee Abu ana kada God nia fata 'uri, ‘Ada basi, nau kai kwatea kau na wane ni ngali farongoe nau 'i nao amu, fua nia kai sasi akau ana wane ki fuamu.’” ");
INSERT INTO far_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Sa Jesus ka fata lau 'uri, “Nau ku saea fua mulu, sa Jon nia talingai ka liufia na wane ki tafau ne kera futa mai 'i laona molagali ne. Sui ka 'urinai boroi 'ana, na wane ne kera tu'u ki laona 'Initoe God, kera talingai ka liufia sa Jon.” ");
INSERT INTO far_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Wane ki tafau ne kera rongoa fatalana, ma na wane ni konilana malefo ana takisi ki boroi, kada kera rongo sulia fatalana sa Jesus, kera ka saitamana na taale God nia saga ma ka mamana, sulia kera kari abulo, ma sa Jon ka siuabu kera tafau. ");
INSERT INTO far_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Boroi ma ana na Farasi ki fainia wane famanata ana taki ki, sulia ne kera noni'ela ana kari abulolae ma na siuabulae ana sa Jon, kera nao si doria go na rolae sulia na kwaidorie God ne nia sasi akau ana fuada. ");
INSERT INTO far_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ma sa Jesus ka fata lau 'uri fuada, “Nau ku fabolotania fua mulu wane abu famamana 'i ta'ena, kamulu dia na kaela wele ");
INSERT INTO far_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ne kera oku 'i maana usie ana ro okue ki. Ma te bali ada ka akwa kau fua tani wele ka 'uri, ‘Kalu ufi 'au, ma mulu si ngwae go sulia. Ma kalu ka ngufia na fa ngu sulia maee fua mulu, ma mulu si kwaimanatai go.’ ");
INSERT INTO far_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kada sa Jon wane ni Siuabu nia dao mai, nia abu fanga, ma nao si kufia ta waeni, ma kamulu ka saea sae nia too ana anoeru ta'a. ");
INSERT INTO far_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sui, kada nau, na Wele nia Wane, nau ku dao mai, nau ku fanga oku, ma nau ku ku fainia wane ki, ma kamulu ka fata laugo 'uri, ‘Kamulu ada to'ona! Nia fanga baita, ma ka ku baita ana waeni, ma nia ka kwaimani fainia wane ne kera koni malefo ana takisi ki ma wane abulolada ta'a ki laugo.’ ");
INSERT INTO far_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Boroi ma, wane ne kera rosulia na liotoe God ki, kera fatainia ne God nia mamana.” ");
INSERT INTO far_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Te wane ana Farasi ki ne satana sa Simon, nia laefia sa Jesus fua ne kai fanga fainia. Ma sa Jesus ka leka 'i lume nia, ma ka egwaegwa, ma ka fanga fainia. ");
INSERT INTO far_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ma te keni abulo ta'a nia to laugo 'i laona na fere nai. Ana kada ne keni nai nia saitamana sa Jesus nia fanga 'i laona lume na Farasi nai, nia ka ngalia mai te bi ngwaingwai lea ne nia fungu ana ngwaingwai ne nia moko lea 'asiana. ");
INSERT INTO far_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ma nia ka ru laona lume, ka uu mai 'i burina sa Jesus karangia 'aena, ma nia ka angi, ma ka fagwinia na 'aena sa Jesus ana na kafo ana maana. Sui, nia ka usua 'aena sa Jesus ana ifuna, ma ka nono'ia. Sui nia ka 'igitainia na ngwaingwai moko lea nai 'i fafona 'aena sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma kada ne na Farasi be nia laefia sa Jesus, nia ada to'ona na ru nai, nia ka manata 'ana 'uri, “Dia na wane ne nia na profet, nia ka saitamana abulolana keni ne nia ta'a 'asiana.” ");
INSERT INTO far_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ma sa Jesus ka saitamana na manatana na Farasi nai, ma nia ka fata 'uri fuana, “Simon 'ae! Te ru ne nau ku doria saea fuamu.” Ma sa Simon ka 'uri, “Famanata 'ae, 'oe saea mai fuaku.” ");
INSERT INTO far_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Sa Jesus ka fata 'uri fuana, “Ro wane ki keroa ngali langa ana malefo fasia te wane ne nia alamatainia wane ki kera ka ngali langa ana malefo nia ki. Ta wane nia ngalia lima talanga malefo ki, ma ta wane ka ngalia lima akwala malefo ki. ");
INSERT INTO far_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ma keroa tafau go nao keroa si bobola fainia duulana malefo nai ki, ma na wane ne nia alamatainia ngali langalae fuadaro ka manatalugea na ngali langalae keroa ki tafau. 'Uri ma sa ti adaro ne nia eele ka baita fuana, ana ro wane ne nia kwatea malefo nai ki fuadaro?” ");
INSERT INTO far_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ma sa Simon nia olisia ka 'uri, “Nau ku kwaisae na wane ne nia ngalia malefo 'oro.” Ma sa Jesus ka fata 'uri, “'Oe olisi saga na.” ");
INSERT INTO far_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Sui sa Jesus ka abulo fuana keni nai, ma ka fata 'uri fuana sa Simon, “'Oe ada to'ona basi na keni ne. Kada nau ku ru mai laona lume 'oe, 'oe si kwatea go kafo fuaku fuana taufilana 'aeku. Boroi ma, nia taufia 'aeku ana na kafona maana, ma ka usua ana na ifuna gwauna. ");
INSERT INTO far_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma 'oe si kwalo nau go ana na nono'ilaku. Boroi ma keni ne, nia safali ana kada be nau ku ru mai 'i lume, nia ka inau na ana nono'ilana 'aeku. ");
INSERT INTO far_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma 'oe si ngwaingwaia go na gwauku ana ta ngwaingwai. Boroi ma keni ne, nia 'igitainia na ngwaingwai moko lea ne ana 'aeku. ");
INSERT INTO far_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nia ne, nau ku saea fuamu, na kwaimanie baita nia, 'e fatainia ne na garoe 'oro nia ki kera aluge tafau na. Boroi ma, sa ti ne garoe nia ne kera manataluge ka tu'u, na kwaimanie nia tu'u laugo.” ");
INSERT INTO far_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Sui sa Jesus ka fata 'uri fuana keni nai, “Nau ku manatalugea na ta'alae 'oe ki.” ");
INSERT INTO far_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma tani wane ne kera to senai, kera ka guisasu fuana sa Jesus, ma kera ka fata 'uri 'i safitada kwailiu, “Na wane 'uta ne nia 'e manatalugea na ta'alae ki 'uri ro?” ");
INSERT INTO far_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sui sa Jesus ka fata 'uri fuana keni nai, “'Oe leka na, ma nao 'Oe si manata 'abero na. God nia famauri 'oe, sulia ne 'oe famamana.” ");
INSERT INTO far_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma 'i burina ru nai ki, sa Jesus ka leka daraninia na lao fere tu'u ki, ma na fere baita ki, ma nia ka 'ainitalo ana na Farongoe Lea sulia 'Initoe God. Ma na akwala ma ro fafurongo nia ki, kera leka laugo fainia, ");
INSERT INTO far_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ma tani keni laugo ne sa Jesus ifulangainia na anoeru ta'a ki, ma ka gura na mataie ki laugo fasida. Ma kera ne: ni Mary, keni 'i Magdala be sa Jesus nia ifulangainia na fiu anoeru ta'a ki fasia, ");
INSERT INTO far_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ma ni Joana, na 'afe sa Kusa na wane baita ana wane ne kera rao 'i laona na lume sa Herod na kingi, ma ni Susana, ma tani keni 'oro lau. Na keni nai ki ne kera foli ru ana malefo kera ki fuana 'afilana sa Jesus fainia fafurongo nia ki. ");
INSERT INTO far_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Na wane 'oro ki kera oku mai siana sa Jesus. Kera leka mai fasia fere 'e'ete kwailiu ki tafau. Sa Jesus fata ana tarifulae fuada ka 'uri, ");
INSERT INTO far_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Te wane nia leka ka takalongainia mege witi ki laona oole nia. Ma ana kada nia takalongainia mege witi ki, tani mege ru nia 'asia sulia na kakaloe. Ma na wane ki kera liu, ma kera ka urida, ma na no ki kera ka 'anida laugo. ");
INSERT INTO far_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Aia, tani mege ru ka 'asia fafona ano faula. Ma ana kada kera bulao mai, nia 'ali'ali go kera ka kuku na, sulia na ano nai nao nia si gwini. ");
INSERT INTO far_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ma tani mege ru ka 'asia laugo 'i safitana na 'oko ngangara ki. Ma na 'oko nai ki kera ka bulao mai fainia na mege ru lea ki, ma ka karo fafia na witi nai ki. ");
INSERT INTO far_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma tani mege ru ka 'asia laugo 'i fafona ano lea, ma kera ka bulao, ma kera ka fungu ana fueru 'oro ki.” Ma sa Jesus ka fasuia fatalana ka 'uri, “Dia ta wane doria ka saitamana lea ana ru ne ki, nia ka fafurongo lea.” ");
INSERT INTO far_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sui na fafurongo sa Jesus ki kera ka ledia 'uria na fadalana tarifulae nai, ");
INSERT INTO far_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ma nia ka olisida ka 'uri, “Kada sui ki, God nao si famadakwa 'ua 'uta ne nia ne kai gwaungai ana wane nia ki. Boroi ma ta'ena, na madakwalae ne dao na fua mulu. Fuana ta wane lau, nau ku fata ana tarifulae ki, ma nao nau si famadakwa, fua ne, ‘Kera kai ada, ma kera kai ada, boroi ma nao kera si ada to'ona te ne God sasia fuada. Kera kai fafurongo, ma kera kai fafurongo, boroi ma nao kera si saitamana farongoe God.’” ");
INSERT INTO far_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","'Urinai, sa Jesus ka fata lau 'uri, “Na fadalana na tarifulae nai: Na mege ru, nia dia na fatalana God. ");
INSERT INTO far_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Na mege ru ne kera 'asida sulia na kakaloe ki, kera dia wane ne kera rongoa fatalana God, ma sa Saetan ka leka mai ka lafua farongoe nai fasi kera. Nia ne kwate nao kera si famamana fua kera ka ngalia maurie firi. ");
INSERT INTO far_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma na mege 'ai ne kera 'asia 'i fafona ano ne nia faula, nia dia na wane ne kera rongoa fatalana God, ma kera ka ngalia, ma kera ka eele 'asiana. Boroi ma, fatalana God nao si lalisusu go laona maurilada. Kera ka famamana go sulia kada tu'u. Boroi ma kada ilitoe nia dao go mai, nao kera si famamana na. ");
INSERT INTO far_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mege witi ne kera 'asida 'i safitana na 'oko ngangara ki, nia dia wane ne kera rongo, boroi ma kera ka manata 'abero 'ada sulia ru 'e'ete ki, dia na toorue ki, ma na eelea 'o'oni laona molagali ne nia susida. Nia ne nia sasia kera si too ana ta fueru lea laona maurilada. ");
INSERT INTO far_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Na mege ru ne kera 'asida 'i fafona na ano ne nia lea, nia dia wane ne kera rongoa fatalana God ma kera ka konia laona manata wane 'o'olo ma ka lea. Ma kera ka susute ana fitoe fuana sasilana raoe 'oro lea ki.” ");
INSERT INTO far_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sa Jesus ka fata lau 'uri, “Nao ta wane si fasarua na fa kwesu, ma ka alua ga 'ana 'i farana ta tiu naoma ta 'ifitai. Boroi ma nia kai alua 'i fulina, fuana wane ne nia ru mai 'i lume nia kai ada to'ona. ");
INSERT INTO far_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“Nia ka 'urinai laugo ana na ta ru ne nia to agwa 'ana kada ne, ta maedangi nia kai sakatafa tafau mai. Ma tani farongoe ne kera sufafia, nia kai ra tafa tafau mai 'i maa. ");
INSERT INTO far_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nia ne mulu fafurongo lea, sulia God ne kai kwate tatakolae ana liotoe fua mulu, suli dia kamulu rosulia na famanatalae nau ki. Sa ti boroi 'ana ne nia to ana ta madakwalae tu'u sulia 'Initoe God, God kai lado gwauna fuana. Boroi ma sa ti ne nao si rosulia famanatalae ne ki, ta madakwalae tu'u boroi 'ana ne nia kwaisae nia to ana sulia 'Initoe God, God kai olitainia fasia.” ");
INSERT INTO far_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'I burina, gaa sa Jesus fainia na sasina ki, kera dao mai, ma kera ka doria adalae to'ona, boroi ma nia 'afitai fuada fua 'idu karangilana, sulia na wane 'oro ki kera oku kalia sa Jesus ana kada nai. ");
INSERT INTO far_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ma te wane 'i laona okue nai ka fata 'uri fuana sa Jesus, “Gaa 'oe fai sasimu ki, kera uu mai 'i maa, ma kera doria ada to'omu.” ");
INSERT INTO far_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Sa Jesus ka fata 'uri fuada tafau, “Sa tifaida ne kera rongo, ma kera ka rosulia fatalana God, kera na ne gaa nau ki, ma na wanefuta nau ki.” ");
INSERT INTO far_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Te kada, sa Jesus fainia na fafurongo nia ki, kera tae 'i laona ta baru, ma nia ka fata 'uri fuada, “Kulu tofolo basi 'uria bali 'osi loko.” Ma kera ka tala'ae, kera ka tofolo na. ");
INSERT INTO far_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma kada kera leka na kau, sa Jesus ka maleu 'ana. Ana kada nai go, na kuburu baita nia tae mai, ma na nanafo ki ka magara na mai laona na baru nai, ma na baru nai karangi kai kuruu na. ");
INSERT INTO far_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Fafurongo nia ki kera ka faada sa Jesus kera ka 'uri, “Wane baita 'ae! Kulu karangi mae na!” Sui sa Jesus ka tatae ka balufia na kuburu ma nanafo ne magara na, ma kera ka rosulia, ma na 'osi ka fola na. ");
INSERT INTO far_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sui sa Jesus ka balufia fafurongo nia ki ka 'uri, “'Uta ne kamulu si famamana nau?” Ma kera ka kwele, ma kera ka mau, ma kera ka ledi kera kwailiu kera 'uri, “Wane 'uta na ne ro? Nia fata talingai go, ma na kuburu fainia nanafo baita ki boroi, kera ka ro na sulia.” ");
INSERT INTO far_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sui sa Jesus fainia fafurongo nia ki, kera ka tofolo laona 'osi ne leka ka dao ana bali lofaa 'i Gerasa, ana bali 'osi ne tio kau bali loko fasia lofaa 'i Galili. ");
INSERT INTO far_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ana kada sa Jesus nia koso 'i sara fasia baru, nia ka dao to'ona te wane fasia kula nai. Na wane nai, na anoeru ta'a ki kera to fainia, ma nia ka todadara ga 'ana sulia kada tau na mai, ma nao nia si to laugo 'i laona ta lume. Boroi ma nia to ga 'ana 'i laona na faoda fuana alulana ana wane mae ki. ");
INSERT INTO far_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ana kada 'oro suina mai, kera kani fafia ro 'aena ki ma 'abana laugo, ma kera ka alua wane fuana fololae 'usia. Boroi ma, nia ka musia ga 'ana na seni nai ki, ma na anoeru ta'a nai ki kera ka taria na kau 'uria laona bali lofaa 'eke'eke. Ma kada nia ada to'ona go sa Jesus, nia ka akwa baita, ma ka boruru na 'i maana 'aena sa Jesus. Sa Jesus nia fata 'uri fuana, “Anoeru ta'a ne, 'oe ru mai 'i maa fasia na wane ne.” Ma wane nai ka akwa 'uri, “Jesus 'ae, 'oe Wele God ne nikila 'asiana! Te ne 'oe doria 'oe sasia 'aku? Nau ku gani 'oe, 'oe si kwatea ta kwaekwaee fuaku.” ");
INSERT INTO far_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Sa Jesus ka ledia, “Satamu sa ti?” Ma nia ka olisia ka 'uri, “Sataku sa Legini.” Nia fata 'urinai sulia na anoeru ta'a 'oro 'asiana ne kera rufia. ");
INSERT INTO far_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Na anoeru ta'a nai ki kera ka 'ingoa sa Jesus fua ne nia si eresida fua laona kiluliu ne nao 'ana ta suilae fuana kwaekwaee. ");
INSERT INTO far_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma na boso 'oro ki, kera fanga 'ada 'i raofaie ana fa uo ne karangi laugo ana kula nai. Ma na anoeru ta'a nai ki, kera ka gania sa Jesus fua kera ka rufia 'ada na boso nai ki. Ma sa Jesus ka ala'ania. ");
INSERT INTO far_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Kera ru mai 'i maa fasia na wane be, ma kera ka rufia na boso be ki tafau. Na boso be ki, kera ka lae ana obaraoe 'ato nai 'uria laona 'osi, ma kera ka ku, ma kera ka mae tafau na. ");
INSERT INTO far_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ana kada wane ne kera ada sulia 'oko boso nai kera ada to'ona ru nai, kera ka tafi, ma kera ka farongo ana laona fere nai ma na fere tu'u kalikalia ki laugo. ");
INSERT INTO far_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Na wane ki ne kera rongoa, kera ka leka mai fuana adalae to'ona ru ne nia fuli. Ma ana kada kera dao mai siana sa Jesus, kera ka ada to'ona na wane nai ne anoeru ta'a nia leka na fasia, ma nia ka gouru na 'ana 'i maana 'aena sa Jesus, ma nia ka ofi na, ma nia ka manata saga na. Ma kera tafau kera ka mau. ");
INSERT INTO far_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma wane ki kera ada to'ona kada ne sa Jesus nia ifulangainia na anoeru ta'a nai ki fasia na wane nai, kera ka fata na sulia fuana wane ne oku mai ki. ");
INSERT INTO far_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Sui wane ki tafau ne kera to ana bali lofaa nai, kera saea fuana sa Jesus fua ka leka fasida, sulia kera mau 'asiana. Sui sa Jesus ka ra na 'i laona baru ka sasi akau na fuana lekalae. ");
INSERT INTO far_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Na wane be na anoeru ta'a nia leka fasia, nia ka fata 'uri fuana sa Jesus, “'Oe alamatainia nau fua nau leka fai 'oe.” Boroi ma sa Jesus ka odua kau, ka fata 'uri fuana, ");
INSERT INTO far_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“'Oe oli 'amu 'i fere 'oe, ma 'oko farongo 'ana ru ne God nia fulia fuamu ki.” Sui, na wane nai ka oli na 'uria fere nia, ma ka fata na sulia ru ne sa Jesus nia fulia fuana ki. ");
INSERT INTO far_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sui, ana kada sa Jesus nia oli lau mai fasia bali 'osi loko, wane ki kera makwalia, ma kera ka eele 'asiana fuana adalae to'ona. ");
INSERT INTO far_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ma te wane ne satana sa Jaeras ka dao mai. Na wane nai nia ta wane fanaonao 'i laona beu fuana folae. Nia leka mai ka boruru 'i 'aena sa Jesus, ma ka ledia sa Jesus fua nia ka leka fainia 'uria lume nia. ");
INSERT INTO far_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Sulia te ka sari mutai nia ne nia matai, ma ka karangi mae na. Te akwala ma ro fangali go ne nia baita mai sulia. Ma ana kada sa Jesus nia leka fainia, na wane 'oro kera oku kalia laugo. ");
INSERT INTO far_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ma te keni ne gwa 'abu nia tafangia to laugo 'i senai. Na mataie ta'a nai nia saungia na sulia akwala ma ro fangali ki. Ma nia ka falia na toorue nia tafau fuana wane kwaigurai ki, boroi ma nao ta wane si gura go. ");
INSERT INTO far_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ma na keni nai ka leka mai 'i burina sa Jesus, ma ka samo to'ona kakamuna maku gwala sa Jesus, ma na gwa 'abu nai ka lalanga na fasia. ");
INSERT INTO far_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sa Jesus ka ledi ka 'uri, “Sa ti ne samo to'oku?” Ana kada nai, na okue nai tafau kera ka tofe ga 'ada. Ma sa Pita ka fata 'uri, “Wane baita 'ae, tooa 'oro ne kera beresi 'oe na.” ");
INSERT INTO far_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Boroi ma sa Jesus ka fata 'uri, “Ta wane nia samo to'oku, sulia nau ku saitamana kada ne na nikilalae nau nia gura te wane.” ");
INSERT INTO far_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kada keni nai 'e saitamana ne nia nao si agwa na, nia ka fali mai, ma ka lelebe, ma ka mau, ma nia ka boruru 'i 'aena sa Jesus. Ma kada tooa 'oro nai kera ada fufunu fuana, nia ka farongo kera tafau sulia te ne nia samo to'ona sa Jesus, ma ka kwatea ne nia ka 'akwa 'ali'ali na. ");
INSERT INTO far_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ma sa Jesus ka fata 'uri fuana, “Keni ne 'ae, God nia gura 'oe na, sulia ne 'oe 'e famamana nau. Leka na kau amu, ma nao 'oe si manata 'abero na.” ");
INSERT INTO far_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kada sa Jesus nia fata go ana 'ua, te wane nia dao na mai fasia lume sa Jaeras, ka farongoa sa Jaeras ka 'uri, “Ka sari 'oe be nia mae na. Nao 'oe si fa'aberoa lau na wane famanata.” ");
INSERT INTO far_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ma sa Jesus ka rongoa, ma ka fata 'uri fuana sa Jaeras, “Nao 'oe si mau. Dia 'oe famamana nau, na ka sari 'oe kai lea laugo.” ");
INSERT INTO far_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ana kada kera dao kau 'i lume, sa Jesus ka talaia sa Pita, fainia sa Jon, ma sa Jemes fainia maa fai gaa wele nai go, kera ka ru 'i lume. Sa Jesus ka luia ta wane lau nao si leka faida 'i lume. ");
INSERT INTO far_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ma na okue nai tafau, kera omaee, ma kera ka angisia na wele nai. Sui sa Jesus ka fata 'uri, “Kamulu si angi lau. Na wele ne nao nia si mae, boroi ma nia 'e maleu ga 'ana.” ");
INSERT INTO far_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ma kera ka waelasia lalau sa Jesus, sulia kera saitamana ne wele ne nia mae mamana na. ");
INSERT INTO far_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Sui sa Jesus ka dau 'i 'abana na wele nai, ma ka akwa ka 'uri, “Wele ne 'ae, tatae na!” ");
INSERT INTO far_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ma na mangona ka oli lau mai, ma nia ka tatae. Ma sa Jesus ka saea fuada fua kera ka kwatea fanga fuana. ");
INSERT INTO far_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Na gaa nia fainia na maa wele nai, keroa ka kwele 'asiana ana ru nai. Sui sa Jesus ka luida nao kera si fata lau sulia ru nai ki fuana ta wane. ");
INSERT INTO far_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sa Jesus nia saea mai na akwala ma ro fafurongo nia ki siana. Ma nia ka kwatea na nikilalae ma na gwaungailae fuana guralana mataie ki, ma na ifulangailana anoeru ta'a ki. ");
INSERT INTO far_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nia ka oduda kau fuana fulangailana na 'Initoe God, ma guralana wane matai ki. ");
INSERT INTO far_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma nia ka fata 'uri fuada, “Nao kamulu si dau sulia ta ru fuana lekalae amulu. Kamulu si ngalia ta fa kubau, ma ta ngwai, ma ta fanga, ma ta malefo, ma ta ro 'aba maku fuana tatalalae. ");
INSERT INTO far_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ma tani wane ana ta lume ne kera kwalo kamulu, mulu to babato 'i laona lume nai, leka ka dao ana kada mulu kai leka fasia na fere nai. ");
INSERT INTO far_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Dia ta wane ana ta fere ne nao kera si kwalo kamulu, mulu leka amulu fasida, ma kamulu ka tafusia gegeona ano fasia na 'aemulu dia na fabasue na fuada ne God kai keto kera, sulia kera noni'ela ana rongolana fatalana God.” ");
INSERT INTO far_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ma na fafurongo ki kera ka leka, ma kera ka liu na ana fere ki tafau fuana 'ainitalolae na Farongoe Lea sulia God, ma fainia guralana wane ki ana kula ki tafau. ");
INSERT INTO far_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ma ana kada nai laugo, sa Herod Antipas na kingi 'i Galili, nia rongoa na farongoe ki sulia ru ne sa Jesus nia sasia ki. Ma na manatana ka lae kwailiu na sulia tani wane kera saea sa Jon wane ni Siuabu ne nia mauri lau, ");
INSERT INTO far_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ma tani wane lau kera ka saea ana sa Elaeja na profet, ma tani wane lau kera ka saea nia ta profet 'ua mai 'i nao ne nia tatae lau fasia na maea. ");
INSERT INTO far_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Go ma sa Herod ka fata 'uri, “Sa Jon be nau ku kwatea na wane ni omee ka siki musia na luana! Ma na wane 'uta ne kera fata sulia 'uri?” 'Urinai, ka safali na ana kada nai, sa Herod doria 'asiana adalae to'ona sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma ana kada ne akwala ma ro lifurongo sa Jesus ki kera oli na mai fasia fulangailana na 'Initoe God ma na guralana wane matai ki, kera ka fata sulia ru ne kera sasia ki. Sui, sa Jesus fainia fafurongo nia ki, kera ka leka taifilida 'uria fere 'i Betsaeda. ");
INSERT INTO far_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Boroi ma ana kada ne, wane ki kera rongoa na sa Jesus nia liu, kera ka leka laugo sulia. Ma sa Jesus ka kwaloda, ma ka fata sulia na 'Initoe God fuada, ma ka gura na wane ne kera matai ki. ");
INSERT INTO far_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma 'i saulafi na, kada sato karangi su, na akwala ma ro fafurongo nia ki kera ka leka mai siana, ma kera ka fata 'uri, “'Oe olitainia na okue ne, fua kera ka leka 'ada ana fere ki, ma kera ka dao to'ona ta fanga fainia ta kula fuana tiolae, sulia seki kula ne nao ta wane si to go ana.” ");
INSERT INTO far_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sui sa Jesus ka fata 'uri fuada, “Kamulu ka kwatea lalau fanga fuada fua 'anilana.” Ma kera ka olisia kera 'uri, “Kalu to go ana lima fa beret ki, ma na ro gwa ie ki. 'Uri ma 'oe doria kalu kai leka folia mai fanga fuana okue baita ne?” ");
INSERT INTO far_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Na okue ne nia bobola fainia na lima to'oni wane ki ne kera to 'i seki. Sa Jesus ka fata 'uri fuana fafurongo nia ki, “Mulu saea fuada kera ka gouru 'i ano ana tani gwa tooa ana lima akwala wane ki.” ");
INSERT INTO far_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Burina ne fafurongo ki kera sasi 'urinai ka sui, na wane ki tafau kera ka gouru na 'i ano. ");
INSERT INTO far_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Sui sa Jesus ka ngalia na lima fa beret nai ki, ma na ro gwa ie nai ki, ma nia ka ada 'alaa 'uria 'i langi, ma ka tangoa God. Sui nia ka ngiia na fa beret ki, ma na ie ki, ma ka kwatea fuana fafurongo nia ki, fua kera ka tolingia ana wane ki. ");
INSERT INTO far_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ma kera tafau kera ka fanga, ma kera ka abusu tafau. Ma na fafurongo nia ki, kera ka konia na orongana fanga ne nia ore 'i laona akwala ma ro kukudu ki leka ka fungu. ");
INSERT INTO far_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Te kada sa Jesus nia foa ana taifilia, ma na fafurongo nia ki kera ka leka mai siana, ma nia ka ledida ka 'uri, “Wane ki kera saea nau ana sa ti ne?” ");
INSERT INTO far_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ma kera olisia kera 'uri, “Tani wane kera sae 'oe sa Jon wane ni Siuabu ne nia mauri lau. Ma tani wane kera sae 'oe sa Elaeja ne nia mauri lau. Ma tani wane kera sae 'oe ta wane ana na profet be 'i nao ki mai ne nia mauri lau.” ");
INSERT INTO far_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ma sa Jesus ka ledi kera ka 'uri, “Ma kamulu sae nau mone ana sa ti?” Sa Pita nia olisia ka 'uri, “'Oe ne na Christ, na wane ne God nia filia fuana 'afilana wane nia ki.” ");
INSERT INTO far_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Sui sa Jesus ka fata talingai fuada fua nao kera si farongoa lau ta wane ana ru nai. ");
INSERT INTO far_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma nia ka fata laugo 'uri, “Nau, na Wele nia Wane, nau kai nonifi ana ru 'oro ki. Ma na wane fanaonao ki, ma na fataabu baita ki, ma na wane famanata ana taki ki, kera kai noni'ela aku. Ma kera kai saungi nau, sui ana oluna maedangi, God kai tae nau fuana maurie.” ");
INSERT INTO far_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ma sa Jesus ka fata lau 'uri fuada tafau, “Sa ti boroi 'ana ne doria kai leka buriku, nao nia si manata 'abero sulia ru nia doria ki ga 'ana talana. Maedangi ki tafau nia kai nonimabe fuana lekalae 'i buriku, sui boroi 'ana kada nia kai nonifi, ma kai mae ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Sa ti boroi 'ana ne noni'ela si leka buriku sulia nia doria ka sasi 'ana sulia kwaidoria nia ki tala'ana, nia kai talafia na maurie firi. Boroi ma dia sa ti boroi 'ana ne nao nia si sasi sulia kwaidoria nia ki tala'ana, ma nia nonimabe kai mae sulia nia leka buriku, nia kai too ana maurie firi. ");
INSERT INTO far_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Dia ne na wane to ana ru ki tafau laona molagali, kada nia mae, ma nia kai to tau fasia God, ru nai si fulia go ta lealae fuana. ");
INSERT INTO far_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma dia ta wane nia 'eke ani nau fainia fatalaku, 'urinai Nau, na Wele nia Wane, nau kai 'eke laugo ana nia, ana kada nau dao mai fainia na ngwasinasinae nau, ma na ngwasinasinae Maa nau, ma na ngwasinasinae 'ainsel abu ki laugo. ");
INSERT INTO far_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nau ku saea na fua mulu, tani wane amulu 'i seki laugo, nao kera si mae leleka kera ka ada to'ona God kai gwaungai ana wane nia ki.” ");
INSERT INTO far_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Bobola fainia kwalu maedangi ki 'i burina ne sa Jesus saea ru nai ki, nia ka talaia sa Pita, sa Jon, fai sa Jemes, ma kera ka ra 'i gwauna te fa uo fuana folae. ");
INSERT INTO far_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma kada sa Jesus nia fo ana, na maana ka tatala ka ngwasinasina, ma na maku nia ki ka kwao ma ka ngwasinasina 'asiana. ");
INSERT INTO far_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ma 'ali'ali go ro wane ki keroa to laugo senai, ma keroa ka fata fainia sa Jesus. Keroa ne sa Moses ma sa Elaeja. ");
INSERT INTO far_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ma keroa ka sakatafa mai 'i laona na ngwasinasinae 'i langi, ma keroa ka fata fainia sa Jesus sulia na maelana ma lekalana fasia na molagali 'uria 'i langi ne nia kai faali'afua 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Boroi ma sa Pita ma na ro wane kwaimani nia ki, kera ka maleu na 'ada. Sui ana kada kera 'ada na, kera ka ada to'ona na ngwasinasinalana sa Jesus ma na ro wane ne keroa uu fainia ki. ");
INSERT INTO far_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ma ana kada ne ro wane nai ki keroa sasi fuana lekalae fasia sa Jesus, sa Pita ka fata 'uri fuana, “'Aofia 'ae, nia lea 'asiana fua kalu ka to amalu 'i seki. Alu kalu kai saungainia olu 'o'obe ki, ta ai fuamu, ta ai fuana sa Moses, ma ta ai fuana sa Elaeja.” (Nia ulafusia laugo 'ana ru ne nia saea.) ");
INSERT INTO far_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ma kada sa Pita nia fata go ana 'ua, te gwa dasa nia dao ma ka nunu fafida. Ma na olu fafurongo ki, kera ka mau ana kada ne gwa dasa nai nia leka mai ka dau fafida. ");
INSERT INTO far_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ma te linge fatae talo mai fasia 'i laona na gwa dasa nai ma ka 'uri, “Nia ne na wele nau. Nau ku filia na. Mulu rongo sulia!” ");
INSERT INTO far_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ma kada linge fatae nai nia suina, taifilia sa Jesus na ne nia to fainia na olu fafurongo nia ki senai. Ma kera ka nofo fafia na ru nai, ma ana kada nai nao kera si farongoa na ta wane ana ru ne kera ada to'ona. ");
INSERT INTO far_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Sui fai maedangi 'i burina ru nai ki, sa Jesus fainia olu fafurongo nia ki, kera ka koso mai fasia gwauna fa uo ne sa Jesus nia tatala ana, ma na wane 'oro ki kera ka dao to'ona sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ma te wane fasia na okue ne nia akwa ka fata 'uri, “Famanata 'ae, nau ku gani 'oe, 'oe ifulangainia kau anoeru ta'a ne fasia na wele nau, sulia nia ne te wele mutai nau na. ");
INSERT INTO far_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Na anoeru ta'a nia olofia 'ali'ali go, ma nia ka akwa baita, ma ka 'ui 'ania 'i ano ma ka lebetainia, ma na ngiduna ka ngingisu. Kada nia saungia, nia ka 'afitai 'asiana fuana suilae fasia, ma ka famalagaigaia 'asiana. ");
INSERT INTO far_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nau ku gania fafurongo 'oe ki fuana ifulangailana fasia, boroi ma nia 'afitai 'asiana fuada.” ");
INSERT INTO far_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Sa Jesus ka fata 'uri, “Kamulu manatamulu ngasi 'asiana, ma wane ta'a ki! Mulu nao si famamana nau 'ua! Nau ku noni kulua na ana abu fitoe ne kamulu. Nau ku to fai kamulu ka dao na 'uri, fulina kamulu ka famamana nau na.” Sui nia ka fata 'uri fuana wane nai, “'Oe ngalia mai na wele 'oe 'i seki.” ");
INSERT INTO far_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ana kada ne wele nai nia dao mai ana kula ne sa Jesus nia uu ana, na anoeru ta'a nai nia ka fi 'ui 'ania wele nai 'i ano, ma ka lebetainia. Ma sa Jesus ka balufia na anoeru ta'a nai, ma nia ka fi sakatafa fasia wele nai, ma na tolana wele nai ka fi lea, ma sa Jesus ka kwatea wele nai fuana maa nia. ");
INSERT INTO far_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma na wane ne kera oku ki, kera ka kwele 'asiana ana nikilalana God. Ana kada ne wane ki kera kwele ga 'ada 'ua ana ru ne sa Jesus nia fulia ki, nia ka fata 'uri fuana fafurongo nia ki, ");
INSERT INTO far_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nao kamulu si manata buro ana na ru ne nau ku saea fua mulu ki. Nau, na Wele nia Wane, kera kai kwate nau laona 'abana malimae nau ki.” ");
INSERT INTO far_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Boroi ma fafurongo nia ki kera si saitamana te ne nia fadaa ana farongoe ne nia saea. God nia safungainia na fadalana farongoe ne fasida. Ma kera mau laugo fuana ledilae 'uria fadalana farongoe nai. ");
INSERT INTO far_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ma na fafurongo nia ki kera ka olisusu 'i safitada kwailiu fuana sa ti ada ne nia talingai ka tasa. ");
INSERT INTO far_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ma sulia ne sa Jesus nia saitamana manatalada, nia ka ngalia te wele, ma ka fauua 'i matangada, ");
INSERT INTO far_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ma ka fata 'uri fuada, “Dia sa ti ne 'oe kwaloa ta wele 'uri sulia ne 'oe famamana nau, 'oe kwalo nau lau go. Ma dia sa ti ne 'oko kwalo nau, 'oe kwaloa laugo God ne nia odu nau mai, sulia sa ti ne 'oe fatu'u 'oe talamu 'i safitamulu, 'oe ne wane baita ne gwaungai fafi kamulu tafau.” ");
INSERT INTO far_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Sui sa Jon ka fata 'uri, “'Aofia 'ae, kalu ada to'ona te wane nia ifulangainia na anoeru ta'a ki ana satamu, ma kalu ka luia fasia sasilana, sulia nia nao lau ta wane ana tooa kulu.” ");
INSERT INTO far_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sa Jesus ka fata 'uri fuada, “Nao kamulu si luia lau, sulia sa ti ne nao si tatae suali kulu, nia na wane fai kulu.” ");
INSERT INTO far_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kada nia dao karangi na fuana sa Jesus kai ra 'i langi, nia ka manata baita ana lekalae 'uria 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ma nia ka kwatea wane ki kera ka eta 'i nao ana. Kera leka, ma kera ka dao ana te fere ana na bali lofaa 'i Samaria fua kera ka sasi akau ana ru ki tafau makwalia. ");
INSERT INTO far_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Boroi ana na wane ki senai nao kera si doria go kwalolana, sulia nia na wane Jiu lalau ne nia leka 'uria 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ma kada na ro wane ana fafurongo nia ki sa Jemes ma sa Jon, keroa ada to'ona ru nai, keroa ka fata 'uri fuana, “'Aofia 'ae, nia 'uta? 'Uri ma 'oe doria karo ka gani 'uria ta ere fasia mai 'i langi fua kai sarufida tafau?” ");
INSERT INTO far_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sui sa Jesus ka abulo ma ka ngatafi keroa. ");
INSERT INTO far_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma keroa ka leka na 'ada 'uria ta fere 'e'ete. ");
INSERT INTO far_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma ana kada kera leka na sulia na taale, te wane ka fata 'uri fuana sa Jesus, “Nau ku doria nau leka fai 'oe 'i fai boroi 'ana ne 'oe leka 'uria.” ");
INSERT INTO far_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sa Jesus ka fata 'uri fuana, “Nao nia ngwaluda. Na fa kui kwasi ki kera too ana na kula kera ki fuana tiolae, ma na fa no ki laugo kera ka too ana na nui kera ki. Boroi ma nau, na Wele nia Wane, nau nao si too ana ta lume fuana maleulae ana.” ");
INSERT INTO far_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ma sa Jesus ka fata 'uri fuana te wane lau, “'Oe leka mai fai nau.” Boroi ma na wane nai ka fata lalau 'uri, “'Aofia 'ae, 'oe alamatainia nau ku leka, faitoli basi ana maa nau sui nau ku fi leka kau suli 'oe.” ");
INSERT INTO far_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ma sa Jesus ka olisia ma ka 'uri fuana, “Alamatainia na wane ne kera mae ki, kera ka faitoli ada talada. Ma 'oe leka, ma 'oko 'ainitalo sulia na 'Initoe God.” ");
INSERT INTO far_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ma te wane lau ka fata 'uri, “'Aofia 'ae, nau ku leka mone 'i burimu. Boroi ma, 'oe alamatainia nau leka ma ku alualu basi ana wanefuta nau ki.” ");
INSERT INTO far_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Sa Jesus ka fata 'uri fuana, “Ta wane ne nia doria kai leka fai nau, ma nia ka manata baita sulia na ru ne nia fasia ki, nao nia si bobola fainia God ka 'initoa fafia maurilana.” ");
INSERT INTO far_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'I burina na ru nai ki, na 'Aofia sa Jesus ka filia fiu akwala ma ro wane ki, ma ka kwatea kera ka leka ro wanea fua kera ka leka 'i naona 'uria fere ki tafau go ne nia manata fua lekalae 'uria. ");
INSERT INTO far_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma nia ka fata 'uri fuada, “Na wane ne kera sasi akau na fuana famamanalae ana God ki, kera dia na ru 'oro ki 'i laona oole fuana konilada. Boroi ma, wane fuana konilana na ru nai ki, kera si 'oro. Nia ne, mulu fosia God fua nia kai kwatea mai wane ni rao ki fai kamulu. ");
INSERT INTO far_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Mulu leka na. Nau ku eresi kamulu dia na kale sipsip ki 'i safitana na fa kui kwasi ki, sulia wane 'oro ki kera doria kera ka fali kamulu. ");
INSERT INTO far_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Nao kamulu si ngalia ta malefo, ma nao ta ngwai, ma nao ta tae butu. Ma nao kamulu si 'abero ana fatalae fainia ta wane sulia taale. ");
INSERT INTO far_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ma kada kamulu ru ana ta lume, mulu fata 'uri, ‘God kai falea kamulu, ma na aroaroe nia ka to fai kamulu 'i laona na lume ne.’ ");
INSERT INTO far_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ma dia na wane ne nia to senai nia kwalo kamulu 'ana aroaroe, na falealae kamulu kai to laugo fainia na wane nai. Ma dia ka nao, na falealae nai ka oli laugo mai fua mulu. ");
INSERT INTO far_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mulu to 'i laona na lume nai, ma mulu 'ania, ma mulu kufia ta ru ne kera kwatea fua mulu. Sulia na wane ne nia rao, nia kai ngalia 'ana na folifolia nia. Kamulu kai to ngado, ma nao kamulu si lae kwailiu ana lume ki. ");
INSERT INTO far_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Ma kada kamulu dao ana ta fere, ma kera ka kwalo kamulu, mulu 'ania fanga te ne kera kwatea fua mulu. ");
INSERT INTO far_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ma mulu kai gura na wane matai ki 'i laona na fere nai, ma mulu ka fata 'uri fua na wane nai ki, ‘Kada God kai gwaungai ana wane nia ki, nia dao karangi kamulu na.’ ");
INSERT INTO far_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ma dia kamulu dao ana ta fere, ma nao kera si kwalo kamulu, mulu ka leka sulia na taale 'i laona fere nai, ma kamulu ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Na gegeona ano ana fere ne kamulu ne rarau farana 'aemalu, kalu tafusia na kau 'usi kamulu. Ne na fabasue na fua mulu ne God ne kai keto kamulu sulia mulu noni'ela ana rongolana fatalana. Kamulu ka manata to'ona ru ne: 'Initoe God nia dao karangi kamulu na.’ ");
INSERT INTO far_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nau ku saea fua mulu, ana fa dangi ne God kai ketoa na wane ana molagali, God kai kwatea na kwaekwaee fua na wane ana fere ta'a be 'i Sodom. Boroi ma nia ne kai kwatea na kwaekwaee baita 'asiana fuana wane ana fere ne ka liufia wane ana fere be 'i Sodom!” ");
INSERT INTO far_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sa Jesus nia fata 'uri, “Nia ta'a 'asiana na fua mulu ne kamulu to 'i Koresin. Ma kamulu ne mulu to 'i Betsaeda ka 'urinai laugo. Sulia mulu si famamana na fanadae 'oro be nau ku sasia fua mulu ki. Dia kera sasia fanadae nai ki 'i Taea ma 'i Saedon 'i nao, na wane senai ki kera ka gouru 'i ano, ma kera ka rufia maku bilia ki, ma kera ka farafua nonida ana fue, fua ne ka fatainia ne kera kari abulo tafau na fasia abulo ta'alae kera ki. ");
INSERT INTO far_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Aia, ana fa dangi God kai ketoda wane ana molagali ne, na kwaekwaee kamulu ne kai baita ka liufia na wane 'i Taea fainia Saedon ki. ");
INSERT INTO far_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Iu, kamulu na tooa 'i Kapaneam, mulu fia God ne kai lafu kamulu 'uria 'i langi. Boroi ma, nia ne kai 'ui 'ani kamulu 'i laona kula ni kwaekwaee.” ");
INSERT INTO far_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sui sa Jesus ka fata 'uri fuana fafurongo nia ki, “Dia sa ti ne nia rongo suli kamulu, nia rongo laugo suli nau. Ma dia sa ti ne nia noni'ela 'ani kamulu, nia noni'ela laugo 'ani nau. Ma dia sa ti ne nia noni'ela 'ani nau, nia noni'ela laugo 'ana God ne 'e odu nau mai.” ");
INSERT INTO far_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma na fiu akwala ma ro wane be kera ka leka na. Ma ana kada kera oli mai, kera ka eele 'asiana, ma kera ka fata 'uri, “'Aofia 'ae, na anoeru ta'a ki boroi kera rosuli kalu kada kalu ifulangainida ana nikilalae 'oe!” ");
INSERT INTO far_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Sa Jesus ka olisida ka 'uri, “Nau ku ada to'ona sa Saetan 'e 'asia mai fasia 'i langi dia meamea. ");
INSERT INTO far_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mulu rongo basi! Nau ku kwatea laugo na nikilalae fua mulu fua mulu ka liu boroi ana baeko tolo ki ma na fafari ki, ma nao kera si 'ala fifi amulu. Nau ku kwatea na fua mulu na nikilalae ne baita ka liufia sa Saetan na malimae kia. Nao ta ru 'ana sa Saetan si fanonifi kamulu na. ");
INSERT INTO far_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kamulu ka eele 'amulu sulia na anoeru ta'a ki kera rosuli kamulu. Boroi ma mulu ka eele amulu sulia God nia kedea laugo na satamulu 'i langi.” ");
INSERT INTO far_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma ana kada nai, Anoeru Abu ka faeelea sa Jesus, ma nia ka fata 'uri, “Maasi, 'oe ne 'oe gwaungai ana ru ki tafau 'i langi ma 'i ano laugo. Nau ku tango 'oe, sulia ne 'oe fatainia na ru ne ki fuana wane ne kera dia wele tu'u ki, ma 'oko safungainia ru ne ki fasia wane ne kera fabaitada sulia kera saitamarue, ma kera ada saitamana ru 'oro ki. Iu Maasi, na ru nai ki nia 'urinai na sulia na kwaidoria 'oe 'ua na mai 'i nao.” ");
INSERT INTO far_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sui sa Jesus ka fata 'uri, “Maa nau nia kwatea ru ki tafau na fuaku. Ma taifilia na Maa go ne nia saitamana na Wele nia. Ma taifilia laugo na Wele tala'ana ne nia saitamana Maa nia, ma taifilia go wane ne na Wele nia filida fuana fatailana fuada ki, ne kera saitamana na Maa.” ");
INSERT INTO far_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Sui sa Jesus ka abulo fuana fafurongo nia ki taifilida, ka fata 'uri fuada, “'Oilakie fua mulu, sulia kamulu ada to'ona na ru ni kwelelae ana ki 'i ta'ena. ");
INSERT INTO far_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nau ku saea fua mulu, na profet 'oro ki ma na kingi 'oro 'i nao ki, kera doria laugo adalae to'ona na ru ne kamulu ada to'ona 'i ta'ena ki, boroi ma kera nao si ada to'ona. Ma kera ka doria 'asiana rongolana na ru ne kamulu rongoa 'i ta'ena ki, boroi ma kera nao si rongoa.” ");
INSERT INTO far_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Te wane famanata ana taki ki, nia leka mai siana sa Jesus. Nia doria ka ilito'ona, ma ka fata 'uri, “Wane Famanata 'ae, ta te ne nau sasia fua nau ku too ana na maurie firi?” ");
INSERT INTO far_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ma sa Jesus ka olisia ka 'uri fuana, “Te ne na Kekedee Abu ki saea? 'Uri ma 'oe malingai 'uta ana?” ");
INSERT INTO far_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ma na wane nai nia olisia ka fata 'uri, “'Oe kwaimani ana God 'oe, ana manatamu tafau, ma ana mangomu tafau, ma ana nikilalamu tafau, ma ana liomu tafau. Ma 'oe kwaimani ana tolamu ka dia laugo ne 'oe kwaimani amu talamu.” ");
INSERT INTO far_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ma sa Jesus ka fata lau 'uri, “Na olisilae 'oe nia saga. 'Oe sasi 'urinai, fua 'oko mauri.” ");
INSERT INTO far_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Boroi ma na wane famanata nai, nia doria kai fatainia ne na tolana 'e 'o'olo ga 'ana, ma nia ka ledia lau sa Jesus ka 'uri, “Sa ti mone ne na tolaku ki ne nau ku kwaimanie fuada?” ");
INSERT INTO far_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ma sa Jesus 'e saitamana wane Jiu ki kera noni'ela ana wane 'i Samaria ma nia ka olisia ka 'uri, “Te wane Jiu nia to mai 'i Jerusalem ma ka leka 'uria 'i Jeriko. Ma kada nia leka ga 'ana 'ua sulia na taale, na wane fofolo beli ki kera ka namusia, ma kera ka ngalia na ru nia ki tafau fainia na maku nia ki. Ma kera ka kwaea leka nia ka maebuatamarakwa na, ma kera ka leka na 'ada fasia. ");
INSERT INTO far_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ma ana kada nai, te fataabu ana na Beu Abu God nia leka laugo sulia na taale nai, ma kada nia ada to'ona na wane be, nia ka gali laugo 'ana sulia ta bali taale, ma ka leka laugo 'ana fasia. ");
INSERT INTO far_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Sui, te wane rao kwai'adomi laona na Beu Abu God nia ka leka laugo mai sulia na taale nai. Ma kada nia dao senai, nia ka ada to'ona na wane be. Boroi ma nia gali laugo 'ana fasia ana ta bali taale, ma ka leka laugo 'ana fasia. ");
INSERT INTO far_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sui ta wane fasia na bali lofaa 'e'ete 'i Samaria nia leka laugo mai sulia na taale nai. Kada nia ada to'ona na wane be, nia ka kwaimanatai 'asiana fuana. ");
INSERT INTO far_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ma nia ka leka mai siana, ma ka taufia na maale nia ki ana na ngwaingwai ma na waeni, ma ka 'afua. Sui nia ka lafua 'i fafona na dongki nia, ma ka ngalia na 'uria te lume fuana folilana fuana tolae 'i laona, ma nia ka ada sulia senai. ");
INSERT INTO far_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ma ana ruana fa dangi, nia ka lafua ro ngingisi malefo ki ne bobola fainia folifolia fuana ro maedangi ki, ma ka kwatea fuana wane ne nia ada sulia na lume nai, ma ka fata 'uri fuana, ‘'Oe ada sulia na wane ne, ma ana kada ne nau oli lau mai, nau duua tafau na malefo ne 'oe 'adomia ana ki.’” ");
INSERT INTO far_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sui sa Jesus ka fata 'uri fuana, “'Oe manata 'uta? Sa ti ana olu wane nai ki kera saea ana tolana fuana wane be na wane fofolo beli ki kera kwaea?” ");
INSERT INTO far_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ma na wane famanata ana taki ki ka fata 'uri, “Na wane ne nia kwaimanatai fuana.” Ma sa Jesus ka olisia ka 'uri, “'Oe leka, ma 'oe ka sasi laugo 'urinai.” ");
INSERT INTO far_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kada sa Jesus ma na fafurongo nia ki kera leka 'uria 'i Jerusalem, kera ka dao ana te fere, ma te keni ne satana 'i Mata ka kwaloa sa Jesus 'uria 'i lume nia. ");
INSERT INTO far_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ma na sasina ni Mary ka to karangia na 'aena na 'Aofia, ma ka fafurongo 'ana fuana famanata sa Jesus ki. ");
INSERT INTO far_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma na manatana 'i Mata ka 'abero sulia nia go ne nia sasia na raoe ki tafau 'i lume. Ma nia ka leka mai siana sa Jesus, ka fata 'uri fuana, “'Aofia 'ae, 'uri ma, 'oe si manata 'abero go sulia na sasiku ne nia fasi nau ga 'ana, ma nau ku sasia ga 'aku na raoe ne ki tafau taifili nau? 'Oe saea fuana fua nia ka leka mai ka 'adomi nau!” ");
INSERT INTO far_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ma na 'Aofia olisia ka 'uri, “Mata 'ae, 'oe manata ruarua ma na manatalamu ka 'abero na sulia ru 'oro ki. ");
INSERT INTO far_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Boroi ma te ru go ne nia talingai. 'I Mary nia filia, ma nia 'afitai ta wane ka lafua na fasia.” ");
INSERT INTO far_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ana te maedangi, sa Jesus nia foa ana te kula. Ma kada nia foa ka sui go, te wane ana fafurongo nia ki ka fata 'uri fuana, “'Aofia 'ae, 'oe famanata kalu ana folae dia be sa Jon nia famanata laugo na fafurongo nia ki ana folae.” ");
INSERT INTO far_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sa Jesus ka fata 'uri fuada, “Kada kamulu foa, mulu ka fata 'uri, ‘Maasi, Kalu doria wane ki tafau kera ka fabaita na satamu, sulia nia abu 'asiana. Dao mai ana gwaungaie 'oe fafia maurilana wane ki tafau. ");
INSERT INTO far_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ma 'oe kwatea mai na fanga fua malu ne nia bobola fua malu sulia maedangi ki. ");
INSERT INTO far_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ma 'oe manatalugea na ta'alae kalu ki, dia laugo ne kalu manataluge ana ta'alae wane ki tafau ne kera sasia ru ta'a ki fua malu. Ma 'oe nao si ala'ani kalu fuana ilitoe ka liufi kalu.’” ");
INSERT INTO far_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ma sa Jesus ka fata ana te tarifulae 'uri fuana fafurongo nia ki, “Dia ta wane ana kamulu leka siana na wane kwaimani nia 'i lume nia laona tofungana rodo, ma ka fata 'uri fuana, ‘Wane nau 'ae, 'oe kwate basi mai ta olu fa beret fuaku, ");
INSERT INTO far_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","sulia te wane kwaimani nau laugo, nia to mai ana fere tau, ma nia ka dao mai siaku. Boroi ma nao nau si to ana ta fanga ne nau kwatea fuana.’ ");
INSERT INTO far_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ma na wane kwaimani nai nia laona lume ka fata 'uri, ‘Nao 'oe si fa'abero nau lau! Na mae nia bilaki na, ma na wele nau ki kalu ka maleu tafau na. Nia 'afitai nau ku tatae lau fuana kwatelana ta ru fuamu.’ ");
INSERT INTO far_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Aia, nau ku saea fua mulu, boroi 'ana dia nao nia si doria sasilana ta ru, dia na wane nai nia gani, ma ka inau ana ganilae, na wane ne 'i laona lume, nia kai tatae ma ka kwatea na ru ki tafau ne nia doria. Ma nia nao si sasia lau sulia na wane nai ne na wane kwaimani nia, boroi ma sulia ne nia inau na ana ganilae. ");
INSERT INTO far_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Nia ne nau ku saea fua mulu, kamulu ka gania God fua mulu ka ngalia ru ne kamulu gani 'uria. Kamulu ka nanisia ru ne kamulu bobo 'uria ki ana God, ma nia ka 'adomi kamulu fua mulu ka dao to'ona. Kamulu ka kidikidi ana na mae, ma God kai 'ifi fua mulu. ");
INSERT INTO far_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Sulia wane ki tafau ne kera gani ana God, kera ka ngalia na ru ne kera gania. Ma na wane ki tafau ne kera nanisia ru kera doria ki ana God, kera kai dao to'ona. Ma wane ki tafau ne kera kidikidi ana na mae, God kai 'ifi fuada. ");
INSERT INTO far_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“'Uri ma, sa ti amulu na maa ki, ne dia na wele 'oe nia gania ta ie, 'oe kwatea lalau na fa tafo fuana? ");
INSERT INTO far_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ma dia na wele 'oe nia gania ta falaka karai, 'oe kwatea lalau ta fafari fuana? Nao 'asiana! ");
INSERT INTO far_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Sui boroi 'ana kamulu tafau wane ta'a ki, kamulu saitamana kwatelana ru lea ki fuana wele kamulu ki. Boroi ma na Maa kamulu ne nia 'i langi, nia lea ka liufi kamulu. 'Urinai ne nia ka kwatea na Anoeru Abu fuana wane ki ne kera gani nia 'uria!” ");
INSERT INTO far_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ana te kada, sa Jesus nia ifulangainia te anoeru ta'a fasia te wane ne ngiduna nia 'e ato. Ma kada anoeru ta'a ne nia tafi fasia, nia ka fata lau. Ma na tooa 'oro ne kera oku senai, kera ka kwele. ");
INSERT INTO far_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ma tani wane ada kera ka fata 'uri, “Sa Jesus ifulangainia na anoeru ta'a ki ana nikilalae sa Saetan, na 'inita anoeru ta'a.” ");
INSERT INTO far_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma tani wane ada, kera doria kera ka ilito'ona sa Jesus. Ma kera ka gania fua nia ka fulia ta fanadae fua ka fatainia God ne odu nia mai. ");
INSERT INTO far_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ma sulia ne sa Jesus nia saitamana go ana na manatalada, nia ka fata 'uri fuada, “Dia tooa laona ta fere baita kera fualia kera talada, 'urinai na fere baita nai kai takalo na. Ma dia ne wane, ma na 'afe, ma na wele nia ki, kera fua fai kera talada, nia 'afitai fuana kera ka to oku. ");
INSERT INTO far_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ma na 'initoe sa Saetan ne 'urinai laugo. Dia sa Saetan kai fua fainia tooa ne kera leka sulia, 'urinai kera kai takalo kwailiu go. Nau ku saea ru nai ki, sulia kamulu saea nau ku ifulangainia anoeru ta'a ki ana nikilalae sa Saetan. ");
INSERT INTO far_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Aia, ma kamulu saea nau ku ifulangainia anoeru ta'a ki ana nikilalae sa Saetan. 'Urinai ma nikilalae sa ti mone ne tani fafurongo amulu ifulangainia anoeru ta'a ki ana? Sa Saetan? Nao 'asiana! Sulia ru nai ki, nia fatainia ne kamulu garo. ");
INSERT INTO far_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nau ku ifulangainia anoeru ta'a ki ana nikilalae God. Ma nia ka fatainia fua mulu ne 'Initoe God fafia wane ki 'e dao karangi na mai siamulu.” ");
INSERT INTO far_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Sa Jesus ka fata lau sulia te tarifulae ka 'uri, “Dia ta wane ramo nia sasi akau ana raunge nia ki fuana firue, ma ka folo lea 'usia na lume nia, nia 'e 'afitai ta wane ka belia na ru nia ki 'i laona lume nia. ");
INSERT INTO far_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Boroi ma dia ta wane ne nia nikila ka liufia, nia leka mai, ma ka fua fainia, nia ka fi liufia nia, ma na wane nai ka fi ngali tafau na 'ana raunge nia ki ne nia fito'ona ki, ma ka tolingia tafau na ru nia ki fuana wane kwaimani nia ki. ");
INSERT INTO far_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ma sa ti ne nao nia si leka mai buriku, nia na malimae nau. Ma sa ti ne nao si kwai'adomi aku fuana konilana mai wane ki siana God, nia ka takalongai kera fasia God.” ");
INSERT INTO far_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Sa Jesus ka fata lau 'uri, “Kada kera ifulangainia anoeru ta'a nia leka fasia ta wane, nia ka kali kwailiu laona lofaa 'eke'eke, ma ka nani 'uria ta kula fua nia kai to lau ana. Ma dia nia nani ma ka nao na, nia kai manata 'uri, ‘Nau oli 'uria na wane be nau ku to mai ana 'i nao, ma nau ku leka mai fasia.’ ");
INSERT INTO far_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ana kada nia oli mai ka dao, nia ka ada to'ona wane be nia kwaitaboi ma ka fa'o'olosia na maurilana tafau. ");
INSERT INTO far_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kada nia ada to'ona ne nia 'urinai, nia ka oli, ma ka talaia lau mai ta fiu anoeru ne ta'a ka liufi nia, kera ka leka mai, ma kera ka to na 'i laona wane be. Ana kada nai, na tolana wane nai ka fi ta'a ka liufia na 'i nao.” ");
INSERT INTO far_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kada sa Jesus nia saea ru nai ki fuada tafau, te 'afe 'i laona okue nai ka akwa 'uri, “Na keni ne nia fafuta 'oe ma ka fasusufi 'oe mone nia eele ka baita.” ");
INSERT INTO far_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Boroi ma sa Jesus nia olisia ka fata 'uri, “Mamana 'asiana. Boroi ma wane ne kera rongoa fatalana God, ma kera ka rosulia, kera lalau ne kera eele ka baita.” ");
INSERT INTO far_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma kada ne tooa 'oro kera koni kalikalia mai sa Jesus, nia ka fata 'uri fuada, “Kamulu wane ta'ena, kamulu wane ta'a ki. Sulia kamulu doria adalae to'ona ta fanadae ne kai fatainia nikilalae God, boroi ma nia ka 'afitai fua mulu fuana adalae to'ona. Kamulu kai ada to'ona go amulu na fanadae dia na ru be nia fuli fuana sa Jona na profet. ");
INSERT INTO far_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Na ru ne fuli fuana sa Jona, nia dia ta maetoto ne fatainia fuana tooa 'i Ninifa ki ne nia leka mai fasia God. Na ru ne fuli fuaku nia dia ta maetoto ne fatainia laugo ne God kwate nau mai, na Wele nia Wane, fuana wane ki ana kada ne. ");
INSERT INTO far_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ma ana kada God kai ketoa na wane ki, na gwaungai keni 'i Siba, nia kai tatae laugo fua faorailae sulia na garoe kamulu. Na keni ne nia sasi 'urinai, sulia nia leka mai fasia fere nia ne 'e tau fua rongolana liotoe sa Solomon na kingi. Ma te wane talingai ka liufia sa Solomon nia to ga 'ana fai kamulu. Sui boroi 'ana, nao mulu si doria go rongolana. ");
INSERT INTO far_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma ana kada God kai ketoa wane ki, wane ne kera to 'i Ninifa, kera kai tatae fua kera ka fata sulia na garoe kamulu ki. Kera sasi 'urinai, sulia kera kari abulo na fasia na ta'alae kera ki, ana kada sa Jona 'ainitaloa fuada. Ma te wane nia talingai ka liufia sa Jona nia to na fai kamulu. Sui boroi ana, nao mulu si kari abulo go fasia ta'alae kamulu ki.” ");
INSERT INTO far_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sa Jesus fata 'uri, “Nao ta wane si fasarua na fa kwesu, ma nia ka saufinia naoma ka alua 'ana farana ta tiu. Kada nia fasarua fa kwesu ka sui, nia ka alua na ana kula fuana daurangailana na kwesu, fua sa ti ne nia ru mai laona lume, nia saitamana ka ada to'ona madakwalana. ");
INSERT INTO far_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Dia nao 'oe si ada to'ona na madakwalae ne, maamu ne ta'a, ma 'oe to ga 'amu laona maerodo. Sulia dia na maamu 'e lea ma 'oe to laona na madakwalae ne, na maamu ne dau talaia mai madakwalae laona nonimu. ");
INSERT INTO far_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mulu ka madafi kamulu suli dia mulu noni'ela ana na madakwae nau, ma laona maurilamulu nia 'e rodoa. ");
INSERT INTO far_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Dia kamulu fungu ana madakwalae, nao na ta kula lau ana noni mulu ne ka susia na madakwalae, 'urinai ne nia ka dia ne kamulu to ana kula ne kwesu nia saru fola ana.” ");
INSERT INTO far_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ana kada sa Jesus nia fata ka suina, te wane ana Farasi ki ka laefia fuana fangalae 'i lume nia. Sa Jesus ka leka fainia, ma ka fanga fainia. ");
INSERT INTO far_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ma na Farasi ne ka kwele 'asiana, sulia nia ada to'ona sa Jesus nao nia si taufia go na 'abana 'i naona na fangalae. ");
INSERT INTO far_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ma na 'Aofia ka fata 'uri fuana, “Kamulu Farasi ki, mulu manata 'abero 'asiana fuana taufilana na ru ki ana bali 'i maa ana titiu ni ku ki, ma na ru ni fangalae kamulu ki. Boroi ma 'i laona na maurilamulu kera fungu ana ru ta'a ki tafau. ");
INSERT INTO far_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Kamulu oewanea 'asiana! God nia saungainia na bali 'i maa ana ru ki tafau, nia laugo ne saungainia laona ru ki. ");
INSERT INTO far_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Aia, mulu kwatea te ki ne nia laona titiu ni ku kamulu ki, fainia te ki ne nia fafona tae ru kamulu ki fuana wane siofa ki, fua ru kamulu ki tafau kai falu 'i maana God. ");
INSERT INTO far_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ta'a 'asiana fua mulu Farasi ki, sulia kamulu kwatea go amulu fuana God ta bali ana tangafuluna ngingisi fanga kamulu ki ne kamulu fasia 'i laona oole kamulu ki. Boroi ma nao mulu si manata 'abero go fuana fa'o'olosilana tolae kamulu ki fainia tolamulu faida, ma na kwaimanie kamulu ki fuana God. Nia lea ne mulu sasia ka ru ana kwatelana tangafuluna ngingisi fanga kamulu ki fuana God, boroi ma mulu manata to'ona laugo na ru baita ana kwaimanie ana God ma na tolamulu ki tafau. ");
INSERT INTO far_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ta'a 'asiana fua mulu Farasi ki, sulia kada kamulu leka laona beu fuana folae mulu doria gouru ana kula ni gourue fuana wane baita ki. Ma kada mulu leka 'i maana usie ki, mulu doria wane ki kera ka fa'inito kamulu. ");
INSERT INTO far_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ta'a 'asiana fua mulu Farasi ki, sulia kamulu dia na kilu gwau ki ne kera nao si 'uia ta sulufaua 'i fafona, ma kada wane ki kera liu 'i fafona, kera nao si ada saitamana na ru moko ngwa'a ne nia 'i laona.” ");
INSERT INTO far_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Sui te wane famanata ana taki ki ka fata 'uri, “Famanata 'ae, kada 'oe fata 'urinai, 'oe fata fali kalu laugo.” ");
INSERT INTO far_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ma sa Jesus ka fata 'uri, “Ta'a 'asiana fua mulu famanata ana taki ki, sulia mulu saungainia taki 'afitai 'oro ki fuana wane ki, ma ka 'afitai 'asiana fuada fua rolae sulida, ma nao mulu si kwai'adomi ada. ");
INSERT INTO far_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ta'a 'asiana laugo fua mulu, sulia kamulu fakwanga fafona kilu gwau profet ki ka ada lea 'asiana, na profet be koko kamulu ki kera saungida. ");
INSERT INTO far_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Sulia ru nai ki, ne nia fatainia ne mulu alafafia sasilae ta'a ne koko kamulu ki kera sasi ada. Sulia kera saungida, ma mulu ka fakwanga kilu gwau kera ki. ");
INSERT INTO far_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Ma sulia ru nai, God ana liotoe nia, 'e fata 'uri, ‘Nau kai kwatea kau tani profet, ma tani wane ni lifurongo ki fuada, boroi ma kera kai saungia tani ai ada, ma kera kai famalagaigaia laugo tani ai ada.’ ");
INSERT INTO far_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Sulia nia 'urinai, na wane ki ana unita wane ne, God kai keto kera fafia na saungilana profet ki tafau, safali na mai ana safalilana molagali ne, ");
INSERT INTO far_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","safali mai ana maelana sa Abel leka ka dao ana maelana sa Sekaraea na wane be kera saungia laona Beu Abu God 'i safitana fulifue ma na kula abu. Ru mamana ne nau ku saea fua mulu, na wane ki ana unita wane ne, God kai keto kera fafia maelana wane nai ki. ");
INSERT INTO far_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ta'a 'asiana fua mulu famanata ana taki ki, sulia kamulu saufinia na mamanae God, fua wane ki nao si saitamana lau. Nao mulu si famamana laugo ana, ma mulu ka susia na wane ki fasia susulilana.” ");
INSERT INTO far_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma ana kada sa Jesus nia leka na fasia fere nai, na wane famanata ana taki ki, ma na Farasi ki, kera ka safali fua ngengelana, ma kera ka ledia na ru 'oro ki. ");
INSERT INTO far_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ma kera ka sasi 'uria sukelana sa Jesus fuana daolae to'ona ta te ne nia saea ka garo. ");
INSERT INTO far_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Ana kada nai laugo, fikute wane bobola fainia molee ana to'oni wane, kera oku mai fuana rongolana sa Jesus. Fikute wane nai baita 'asiana ne kera urida kwailiu na. 'I nao sui sa Jesus nia fi fata fuana wane nai ki, nia eta fata basi 'uri fuana fafurongo nia ki, “Mulu kai madafi kamulu fasia rolae sulia manatae wane ta'a Farasi ki, sulia kera wane kwalabasa ki. ");
INSERT INTO far_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ta te ne wane nia safungainia, God kai fasakatafa. Ma na ru agwa ki, kera kai saitamana laugo ana. ");
INSERT INTO far_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ma te ne mulu saea 'i laona maerodo, kera kai rongoa laona dangi fola. Ma te ne mulu kwalaro ana laona alingana ta wane ana ta kula banitai taifili kamoro, kera kai farongoa ana wane ki tafau fua kera ka rongo fola ana.” ");
INSERT INTO far_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Sa Jesus ka fata lau 'uri, “Nau ku saea fua mulu wane kwaimani nau ki 'ae, nao kamulu si maungia sa ti ne kai saungia na noni mulu, ma 'i burina nao kera si ilia go ta ru ta'a lau ana mangomulu. ");
INSERT INTO far_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Boroi ma nau ku fatainia ti ne mulu kai maungia, mulu maungia God. Sulia nia na ne nia saitamana kai saungia noni mulu, ma nia ka too laugo ana nikilalae fuana 'ui 'ani lamulu laona kula ni kwaekwaee. Iu, nau ku saea lau fua mulu, God taifilia go ne mulu maungia. ");
INSERT INTO far_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Na lima fa no tu'u ki, kera folida go ana ka ro ngingisi malefo tu'u ki. Fa no tu'u ki kera ka tu'u boroi 'ada, God nao si manata buro go ana ta ai ada. ");
INSERT INTO far_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Na ifu ana gwaumulu ki boroi, God susulia go ana tafau. Nia ne nao kamulu si mau, sulia God nia manata baita ana wane ki ka liufia na fa no tu'u 'oro ne ki.” ");
INSERT INTO far_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Sui sa Jesus ka fata lau 'uri, “Nau ku saea fua mulu, dia ta wane nia fulangainia 'i naofana wane ki ne nia na fafurongo nau, 'urinai nau, na Wele nia Wane boroi, nau kai fulangainia laugo 'i naona 'ainsel God ki. ");
INSERT INTO far_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ma dia ta wane kai tofe nau 'i maana wane ki, nau kai tofe nia laugo fafia wane nai 'i naona 'ainsel God ki. ");
INSERT INTO far_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Ma dia ta wane ka fata fali nau, God saitamana ka manatalugea ga 'ana. Boroi ma dia ta wane ka fata falia na raoe Anoeru Abu, God nao si manatalugea na wane nai. ");
INSERT INTO far_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Ma kera kai ngali kamulu 'uria ketolamulu 'i laona beu fuana folae naoma 'i naona wane 'initoa ki. Ana kada nai, nao kamulu si mau, ma nao kamulu si manata 'abero 'uria ta faoraie 'uta ne mulu kai saea, ma mulu kai olisi kera ana. ");
INSERT INTO far_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sulia kada nai, na Anoeru Abu nia kai famanata kamulu ana ru ne mulu kai saea ki.” ");
INSERT INTO far_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Te wane 'i laona na okue nai, nia fata 'uri fuana sa Jesus, “Famanata 'ae, 'oe saea fuana ai nao ku kai tolingia na toorue karo ki ne maa karo nia fasia fuamaro.” ");
INSERT INTO far_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ma sa Jesus olisia ka 'uri, “Wane nau 'ae, sa ti ne nia kwatea na nikilalae fuaku fuana ketolana ma fuana tolingilana na ru 'uri ki 'i matangamoro?” ");
INSERT INTO far_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ma nia ka fata 'uri fuada tafau, “Mulu manata lea, fasi kamulu ka fi ogalulumi ana ru ki. Sulia na maurie mamana wane, nia 'e nao lau ana malefo naoma toorue nia ki.” ");
INSERT INTO far_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","'Urinai sa Jesus ka fata ana tarifulae fuada ka 'uri, “Te wane tooru nia to ana te ano lea ne nia fasia ru ki 'i laona, ma ka ngeda na ru lea 'oro ki ne nia fasida 'i laona. ");
INSERT INTO far_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ma nia ka gouru ka manata 'ana sulia nia talana ma ka 'uri, ‘Te ne nau kai ilia ro? Sulia nao nau si to na ana ta kula fuana taingailana na ru nau ki. ");
INSERT INTO far_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Iu, nau kai sasi 'uri, nau ku okosia na 'o'obe ne nau ku koni ru 'i laona ka sui, nau ku saungainia lau tani 'o'obe falu ne baita. Ma nau ku fi konia mai na fueru nau ki ma tani ru lau 'i seki. ");
INSERT INTO far_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Sui nau kai fi fata lau 'uri fuaku talaku, 'oilakie 'asiana fuamu! 'Oe to na ana ru lea 'oro ki ne 'oe doria fuana fangali 'oro ki. 'Oe gouru ko keso 'ae na 'amu! 'Oe fanga lea 'amu, ma 'oe ku na 'amu, ma 'oe sasia na 'amu ru ne fuana kai faeelea maurilamu.’ ");
INSERT INTO far_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Boroi ma God nia fata 'uri fuana, ‘'Oe oewanea 'asiana! Laona fa rodo ne ta'ena go ne 'oe mae, ma 'oe si saitamana sa ti ne kai too ana na ru ne 'oe konia fuamu talamu ki.’” ");
INSERT INTO far_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ma sa Jesus ka fasuia na famanatalae nai ka 'uri, “Nia kai fuli 'urinai laugo fuana wane ne kera koni ru tafau fuada talada ki, boroi ma 'i naona God kera siofa 'asiana.” ");
INSERT INTO far_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Sui sa Jesus ka fata 'uri fuana fafurongo nia ki, “Nau ku saea fua mulu, nao mulu si manata 'abero sulia te ne kamulu kai 'ania, ma te ne kamulu kai ofi fafia noni mulu. ");
INSERT INTO far_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Sulia na maurie ne, nia lea ka liufia na fanga, ma na noni ne nia lea ka liufia na maku ni ofi. ");
INSERT INTO far_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ada to'ona na fa no ki, nao kera si 'abero go sulia raoe ana ta oole. Ma nao kera si ngeda go ta fanga, ma kera si saungainia go ta 'o'obe fuana alu fangalae. Boroi ma God nia sangonida ga 'ana. Ma God nia ada baita 'asiana amulu ka liufia fa no ki. Nia ne, God kai sangoni kamulu ga 'ana. ");
INSERT INTO far_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Sui boroi 'ana kamulu ka manata 'abero sulia maurie kamulu ki, nia 'afitai 'asiana mulu ka ilia maurilamulu ka tau tu'u lau. ");
INSERT INTO far_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ma dia nao mulu si bobola go fainia sasilana ka ru fuana fataulana maurilamulu, 'uta ne mulu kai manata 'abero lalau ana ru 'e'ete ki? ");
INSERT INTO far_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Mulu ada to'ona basi na takana 'ai ne ki. Nao kera si rao go, ma nao kera si saungainia go ta maku fuada. Ma nau ku saea fua mulu, kera ada kwanga ka liufia maku ne sa Solomon na kingi nia 'afisida ki. ");
INSERT INTO far_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ma na takana 'ai ki kera to ga 'ada sulia ka kada kokoru, ma kera ka 'ui laugo 'anida laona ere. Sui ka 'urinai boroi ana, God nia famasada ana ru lea ki. 'Uri ma kamulu fitala sae God nao si famasa kamulu laugo? Na fitoe kamulu ki nia tu'u. ");
INSERT INTO far_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Ma nao kamulu si manata 'abero 'asiana sulia te ne mulu kai 'ania, ma te ne mulu kai kufia. ");
INSERT INTO far_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sulia na wane ne kera to manata buro ana God ki ne kera saitamana kera ka manata 'abero sulia ru nai ki. Ma kamulu, na Maa kamulu nia saitamana ka suina ne kamulu bobo 'uria ru nai ki. ");
INSERT INTO far_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mulu kai manata go sulia na maurie ne God nia gwaungai ana, fua nia kai kwatea fua mulu na ru ne kamulu dorida ki.” ");
INSERT INTO far_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Sui sa Jesus ka fata lau 'uri, “Kamulu wane nau ki, sui boroi 'ana kamulu ka dia na sipsip tu'u ki, nao kamulu si mau, sulia God na Maa kamulu, nia eele 'asiana fuana kwatelana 'Initoe nia fua mulu. ");
INSERT INTO far_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mulu fafoli ana ru kamulu ki, ma mulu kwatea malefo fuana wane siofa ki. Dia kamulu kai sasi 'urinai, mulu kai to ana gwa sukele fuana koni malefolae ki 'i langi ne nia 'afitai ka fura. Kamulu kai konia na toorue kamulu ki 'i langi, ana kula ne nia 'afitai kera ka fasuia, ma na kula ne wane beli ki nao si dao ana, ma nao ta subu si falida. ");
INSERT INTO far_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Sulia kada na toorue kamulu nia to 'i langi, na maurilamulu nia agwai tafau na 'uria 'i langi. Ma kada na toorue kamulu nia to laona molagali, na maurilamulu ka agwai tafau na 'uria ru laona na molagali ki. ");
INSERT INTO far_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Mulu to adaada makwalia te ne kai dao mai. Ma mulu rufia na maku kamulu ki, ma mulu fasarua na kwesu kamulu ki, ");
INSERT INTO far_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","dia wane rao ki ne kera makwalia na wane 'initoa kera ne kai oli mai fasia ta fafanga ana araie. Kada nia dao mai ma ka malafo, kera 'ali'ali go kera 'ifingia na mae fuana. ");
INSERT INTO far_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","'Oilakie fua na wane rao nai ki ne wane 'initoa kera nia dao to'oda, ma kera ada ga 'ada 'ua, ma kera makwalia kada nia oli mai ana. Nau ku saea na ru mamana fua mulu, nia kai sasi akau, ma ka fagouruda tafau, ma ka sangonida. ");
INSERT INTO far_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'Oilakie fuada dia nia dao to'oda kera kwaimakwali, dia nia kai dao mai laona tofungana rodo, naoma kada rodo 'i 'ofodangi! ");
INSERT INTO far_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Ma mulu ka manata to'ona ru ne, dia na wane ana lume nia saitamana ga ana kada ne wane beli kai dao mai ana, nia 'afitai na wane beli ka ru laona lume nia. ");
INSERT INTO far_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Kamulu laugo, mulu kai to ni kwaimakwali aku, na Wele nia Wane. Sulia nau kai dao mai ana kada ne mulu fia nao nau si dao mai ana.” ");
INSERT INTO far_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Sa Pita ka fata 'uri, “'Aofia 'ae. 'Uri ma 'oe saea na tarifulae ne fua malu go ne, naoma fuana wane ki tafau?” ");
INSERT INTO far_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Na 'Aofia nia olisia ka 'uri, “Mulu kai dia na wane rao ne nia saitamarue ma nia ka rao 'o'olo. Ma na wane baita kai alu nia ka ada sulia na wane rao ki, ma ka kwatea na fanga fuada ana kada fua kwate fangalae. ");
INSERT INTO far_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ma 'oilakie fuana wane rao nai ne wane baita nia dao to'ona, ma nia sasia ru nai ki ana kada ne nia dao mai ana lume nia! ");
INSERT INTO far_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Nau ku saea na ru mamana fua mulu, na wane baita kai alu nia ka ada sulia ru nia ki tafau. ");
INSERT INTO far_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Boroi ma, ka ta'a 'asiana dia na wane rao nai ka manata 'uri, ‘Na wane baita nau, daolana mai nia tau 'ua,’ ma nia ka safali fua kwaelana wane rao ki, ma na keni rao ki, ma nia ka to ni fanga na 'ana ma ka ku bubulo na leleka gwauna ka bubulo na. ");
INSERT INTO far_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Sui ma na wane baita ka dao mai ana ta maedangi ne nia nao si kwaimakwali ana, ma ana kada ne nia ulafusi ga 'ana. Na wane baita kai kwatea na kwaekwaee baita fuana, ma ka alua ana na kula fua wane ne nao si famamana ki. ");
INSERT INTO far_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ma na wane rao ne nia saitamana te ne na wane baita nia doria nia ka ilia, boroi ma nia nao si sasi akau ma si ilia go na ru ne na wane baita nia doria, kera kai kwatea kwaekwaee baita fuana. ");
INSERT INTO far_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Boroi ma na wane ni rao ne nao nia si saitamana na ru ne wane baita nia doria, ma nia ka ilia ru ne bobola fainia kera kwaea fainia, kera kai kwatea kwaekwaee tu'u go fuana. “Dia God nia kwate takwala ana ru ki fuana ta wane, God nia doria wane nai ka olitainia tatakolae laugo ana ru ki fuana. Ma dia God nia kwatea ru 'oro ki fuana ta wane, nia ka doria laugo ru 'oro ki fasia wane nai.” ");
INSERT INTO far_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sa Jesus ka fata lau 'uri, “Nau ku leka mai fuana ukunilana na ere laona molagali ne, ma nau ku doria na ere nai kai safali saru na! ");
INSERT INTO far_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Nau kai ru laona fiie baita, ma manataku si ngado leka fiie nai ka kali'afu. ");
INSERT INTO far_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","'Uri ma kamulu kwaisae nau ku dao mai fainia aroaroe fuana molagali? Nao 'asiana! Boroi ma nau ku dao laugo mai fainia daroe. ");
INSERT INTO far_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Safali ana kada ne ka oli 'alaa, na lume ne lima wane ki kera to 'i laona, kera kai daro suli nau. Olu wane ki ana ta bali, ma ro wane ki ana ta bali. ");
INSERT INTO far_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Na maa ki kera kai olisusu fainia na wele fi baita kera ki, ma na wele fi baita ki kera kai olisusu fainia na maa kera ki. Ma na gaa ki kera kai olisusu fainia na wele keni sari kera ki, ma na wele keni sari ki kera kai olisusu fainia na gaa kera ki. Ma na fungo keni ki kera kai olisusu fainia na keni folia kera ki, ma na keni folia ki kera ka olisusu fainia na fungo keni kera ki.” ");
INSERT INTO far_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sa Jesus ka fata lau fuana fikute wane ka 'uri, “Dia kamulu ada to'ona gwa dasa ki kera ra mai fasia sulana sato, mulu saitamana na ute kai to. Ma nia kai to mamana na. ");
INSERT INTO far_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ma dia na oru nia ra 'alaa mai, mulu saitamana laugo nia kai 'ako'ako. Ma nia kai 'ako'ako mamana na. ");
INSERT INTO far_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Kamulu na wane kwalabasa ki! Sulia kamulu saitamana adalae to'ona mamanga fainia na molagali, boroi ma nao mulu si ada saitamana ru ne God fulia ana kada ne ki.” ");
INSERT INTO far_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sa Jesus nia fata lau ka fata 'uri, “'Uta ne nao mulu si filia 'amulu ru 'o'olo ki fuana sasilana? ");
INSERT INTO far_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Dia ta wane kai ngali 'oe fuana kwaiketoilae, 'i naona ne kamoro ka fata laona kwaiketoilae, 'oe ili 'uria fa'o'olosilana ru ki 'i matangamoro. Sulia dia nao 'oe si sasi 'urinai, ma nia ka ngali 'oe siana wane kwaiketoi, ma 'i burina nia ka keto 'oe, nia fi kwate 'oe lau fuana wane kani wane ki, ma na wane kani wane ki fi alu 'oe lau laona beu ni kanie. ");
INSERT INTO far_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ma nau ku saea fua mulu, dia nia 'urinai, nia 'afitai 'asiana fua 'oe ru fasia na beu ni kanie, leka 'oe kwatea na malefo 'isi 'oe ne nia bobola fainia kwaekwaee 'oe.” ");
INSERT INTO far_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma ana kada nai laugo, tani wane ne kera to 'i senai, kera farongoa sa Jesus ana na wane fasia 'i Galili ki ne sa Paelat nia saungida ka mae, kada kera fosia God. ");
INSERT INTO far_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ma sa Jesus ka ledi kera 'uri, “'Uta? Sulia ne tooa nai kera ka mae na 'urinai, mulu kwaisae na tooa nai, ta'alae kera ki nia baita ka liufia tani wane lau 'i Galili? ");
INSERT INTO far_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nao 'asiana! Ma nau ku saea fua mulu, dia nao mulu si kari abulo fasia na ta'alae kamulu ki, kamulu tafau go ne mulu kai mae laugo di kera. ");
INSERT INTO far_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mulu manata 'uta sulia na akwala ma kwalu wane be ki laona fere 'i Saelom ne lume baita nia 'asia fafida, ma kera ka mae tafau? 'Uri ma, mulu kwaisae ru nai nia fatainia ne kera na ne wane ta'a ki, ka liufia na wane ne kera to 'i laona fere 'i Jerusalem ki? ");
INSERT INTO far_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nao! Nau ku saea fua mulu, dia nao mulu si kari abulo fasia na ta'alae kamulu ki, kamulu tafau mulu kai mae laugo di kera.” ");
INSERT INTO far_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Sui sa Jesus ka fata fuada ana tarifulae ne ka 'uri, “Te wane nia fasia te 'ai ne kera saea ana na figi 'i laona na oole nia. Ana te kada, nia leka ma ka nani 'uria tani fueru 'i gwauna 'ai nai, ma nao nia si ada to'ona go ta fueru ana. ");
INSERT INTO far_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ma nia ka fata 'uri fuana wane ne rao 'i laona na oole nia, ‘Ada to'ona basi, olu fangali ki nau ku adaada mai 'uria na fueru ki, ma nao nau si ada to'ona go ta fueru ana. 'Uri 'oe tofua na 'amu! 'Uta ne nia ka to ga 'ana fuana susilana na ano fuana raoe?’ ");
INSERT INTO far_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Boroi ma na wane ni rao nai nia olisia ka fata 'uri, ‘Wane baita 'ae, 'oe alamatainia na 'ai ne ka to basi 'ana sulia lau ta te fangali. Nau kai 'elia ta kakaloe kalikalia, ma nau ku alua tafu ki 'i 'aena, fua ka falea na ano ne. ");
INSERT INTO far_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma dia na 'ai ne ka fungu ana fueru ki ana fangali lo mai, nia lea. Ma dia ka nao, 'oko tofua na 'amu.’” ");
INSERT INTO far_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ana te Sabat, sa Jesus nia famanata 'i laona te beu fuana folae. ");
INSERT INTO far_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma te keni nia to 'i senai ne na anoeru ta'a nia dosia na sulina ka bu, ma nia ka matai sulia akwala ma kwalu fangali ki, ma nao nia si bobola fua ne nia uu 'o'olo. ");
INSERT INTO far_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ma kada sa Jesus nia ada to'ona, nia saea mai siana ka fata 'uri fuana, “'Oe 'akwa na fasia na mataie ne saungi 'oe.” ");
INSERT INTO far_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ma nia ka alua 'abana 'i fafona sulina, ma ana kada nai go, na keni nai ka tatae 'o'olo, ma ka tangoa God. ");
INSERT INTO far_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ma kada fanaonao ana beu fuana folae nai nia ada to'ona sa Jesus ne 'e gura na keni ne ana Sabat, nia oli ma ka guisasu 'asiana, ma nia ka fata 'uri fuana wane nai ki, “Ono maedangi ki ne fuana sasilana raoe kamulu ki. Ma ana maedangi nai ki laugo ne, mulu leka mai fuana gurae. Nao mulu si leka mai fuana gurae ana Sabat.” ");
INSERT INTO far_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ma na 'Aofia nia olisia ka fata 'uri, “Kamu wane kwalabasa ki! Sulia kamulu 'idufa sasia go raoe ki kada kamulu lugea na buluka ma dongki kamulu ki, ma mulu ka talaida 'uria kafo fuana fakufilada ana Sabat. ");
INSERT INTO far_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ma na keni ne, nia ana kwalafa koko kia sa Abraham laugo, ma sa Saetan ka kani mai fafia ana mataie sulia akwala ma kwalu fangali ki. Ma nia lea fuana nau ku gura na mataie ne fasia ana Sabat.” ");
INSERT INTO far_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kada sa Jesus nia fata 'urinai, na malimae nia ki kera ka 'eke 'asiana, ma na wane ki kera fi eele lalau, sulia ru ni kwelelae ki ne sa Jesus nia sasia. ");
INSERT INTO far_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Sa Jesus fata lau ka fata 'uri, “Nau ka fata na tarifulae ne kai fatainia na ru ne bobola fainia 'initoa God fafia wane nia ki. ");
INSERT INTO far_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nia ka 'uri: Te wane nia ngalia na mege 'ai tu'u ne kera saea ana mastad, ma nia ka fasia laona oole nia. Sui nia ka bulao mai, ma ka alua na 'ai baita, ma na no ki kera ka leka mai, ma kera ka to, ma kera ka saungainia na nui kera ki ana sarana 'ai nai.” ");
INSERT INTO far_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ma sa Jesus ka fata lau 'uri, “Nau fata lau kau sulia te ne kai fatainia na ru ne 'e bobola fainia 'initoe God fafia wane nia ki. ");
INSERT INTO far_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nia dia na isi tu'u fuana faubulana na beret ne ta keni nia ngalia, ma ka dolalia fainia fulaoa 'oro, leka na kumu nai ka bose, ma ka fane.” ");
INSERT INTO far_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kada sa Jesus leka 'uria 'i Jerusalem, nia ka liu daraninia na mae fere baita ki, ma na mae fere tu'u ki, ma ka famanata wane 'oro ki. ");
INSERT INTO far_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ma te wane nia ledia ma ka 'uri, “'Aofia 'ae. 'Uri ma ta bara wane go ne God kai famaurida?” Sa Jesus olisia ma ka 'uri, ");
INSERT INTO far_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Nau ku saea fua mulu, mulu kai sasi ngangata, fua mulu ka ru ana mae ne sukoni, ne leka 'uria 'i langi. Sulia na wane 'oro kera kai sasi 'uria na rulae, ma nia 'afitai 'asiana fuada sulia na mae kai bilaki 'usida. ");
INSERT INTO far_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kada wane baita ana lume 'i langi nia ka tatae, ma ka bilaki 'usia na mae, mulu kai uu mai 'i maa, ma mulu kidikidi ana mae, ma mulu fata 'uri, ‘'Aofia 'ae, 'oe 'ifi kau fua malu.’ Boroi ma nia ka olisia ma ka 'uri, ‘Nao nau si saitamamulu, ma nao nau si saitamana kula ne kamulu leka mai fasia.’ ");
INSERT INTO far_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Sui mulu kai olisi 'uri ana, ‘Kalu fanga fai 'oe, ma kalu ka ku laugo fai 'oe, ma 'oe famanata na 'i laona na fere kalu ki.’ ");
INSERT INTO far_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Boroi ma nia kai fata 'uri, ‘Kamulu na wane ta'a ki, mulu leka tau kau fasi nau. Nau si saitamamulu, ma nao nau si saitamana kula ne mulu leka mai fasia.’ ");
INSERT INTO far_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Ma kada mulu ada to'ona sa Abraham, ma sa Aesak, ma sa Jakob, ma profet ki tafau 'i laona 'initoa God, God kai 'ui 'ani kamulu 'i maa, mulu kai kwaimanatai, mulu angi, ma mulu guisasu fainia 'ala girigiri ana lifomulu! ");
INSERT INTO far_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ma na wane ki kera kai dao mai fasia taelana sato, ma 'i sulana sato, ma fasia gwauna fere, ma 'i 'aena fere, ma kera ka oku ana fangalae 'i laona 'Initoe God. ");
INSERT INTO far_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sulia na wane ne kera 'isi ana kada nai, kera kai eteta. Ma na wane ne kera eteta ana kada nai, kera kai 'isi.” ");
INSERT INTO far_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ana kada nai, tani Farasi kera leka mai siana sa Jesus, ma kera ka fata 'uri fuana, “'Oe leka fasia 'i seki 'uria ta fere 'e'ete, sulia sa Herod na kingi nia doria saungilamu.” ");
INSERT INTO far_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ma sa Jesus ka fata 'uri, “Sa Herod nia dia na kui kwasi, sulia nia na wane susuke 'asiana. Mulu leka saea fuana, ta'ena fainia malakwasi, nau sasia na raoe nau ana ifulangailana anoeru ta'a ki, ma guralana wane matai ki. Ma ana oluna maedangi, nau ku fi fasuia na raoe nau. ");
INSERT INTO far_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sui ka 'urinai boroi 'ana, nau ku daofa liu na 'aku 'uria 'i Jerusalem 'i ta'ena, ma 'i malakwasi, ma laona maedangi loki lau. Sulia nao si bobola fuana kera kai saungia na profet ana ta fere 'e'ete, boroi ma laona 'i Jerusalem go.” ");
INSERT INTO far_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ma sa Jesus ka fata lau 'uri, “Wane ana 'i Jerusalem 'ae! Mulu ka 'ui fauna profet be ki God nia oduda mai fua mulu ki, ma mulu saungida. Ana kada 'oro nau ku doria mulu leka mai siaku, fua nau ada suli kamulu dia ta karai nia ofia na wele 'i farana kukubana. Boroi ma nao mulu si doria go. ");
INSERT INTO far_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ma ana kada ne na, God kai leka fasi kamulu, ma ka luka faburi na ana fere kamulu. Ma nau ku saea fua mulu, nao mulu si ada to'oku lau, leka ka dao ana kada ne mulu kai fata 'uri, ‘God 'oe oilakitainia na wane ne nia leka mai ana na nikilalae 'oe!’” ");
INSERT INTO far_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ana te Sabat, sa Jesus 'e leka ka fanga ana lume te wane fanaonao ana Farasi ki. Ma ana kada nai, na wane ki kera ka adaada 'uria adalae to'ona te ne nia kai ilia. ");
INSERT INTO far_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma te wane ne ro 'abana, ma na ro 'aena ki kera ubu 'asiana, nia leka mai siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ma sa Jesus ka ledia na Farasi ki ma na famanata ana taki ki ka 'uri, “'Uri ma na taki kia alamatainia kulu ka gura go 'akulu ta wane matai ana Sabat, naoma 'e nao?” ");
INSERT INTO far_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Boroi ma nao kera si olisia go. Sui sa Jesus ka samo to'ona wane matai nai, ma nia ka 'akwa na, ma sa Jesus ka alamatainia ka leka na 'ana. ");
INSERT INTO far_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Sui sa Jesus ka ledida ka 'uri, “'Uri ma dia ta wele amu naoma ta buluka amu, nia 'asia 'i laona ta kilu ana na Sabat, 'oe saitamana 'oe leka lafua ga 'amu?” ");
INSERT INTO far_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ma ana kada sa Jesus nia ledi 'urinai, nao ta wane si olisia go. ");
INSERT INTO far_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ma kada sa Jesus nia ada to'ona na wane ki ne kera dao mai fuana fangalae, ma kera ka filia 'ada kula 'initoa ki fuana gourue, nia ka fata 'ana tarifulae ne fuada ka 'uri, ");
INSERT INTO far_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kada ta wane nia laefi 'oe fuana ta fafanga ana araie, nao 'oe si gouru lau ana kula ni gourue fuana wane fanaonao ki, fasi kera ka laefia laugo ta wane ne nia talingai ka liufi 'oe. ");
INSERT INTO far_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ma na wane ne nia laefi kamoro mai ka dao, ma ka fata 'uri fuamu, ‘'Oe tatae basi, fuana wane ne ka gouru 'i sena.’ 'Urinai 'oe ka fi 'eke lalau nai, sulia kera 'idu 'oe ma 'oko gouru na 'amu ana kula 'i ano fuana wane siofa ki. ");
INSERT INTO far_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Aia, dia kada ta wane nia laefi 'oe, gouru lalau 'amu ana ta kula 'i ano, ma kada na wane ne nia laefi 'oe mai nia dao, nia ka fata 'uri fuamu, ‘Wane nau 'ae, 'oe 'idu mai 'uria ta kula ne lea.’ 'Urinai, nia ka fabaita 'oe 'i naofana na wane ne mulu oku 'i senai ki. ");
INSERT INTO far_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Sulia na wane ne nia fabaita nia talana, God kai fatu'u nia. Ma na wane ne nia fatu'u nia talana, God kai fabaita nia.” ");
INSERT INTO far_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Sui sa Jesus ka fata 'uri fuana wane ne nia saungainia na fafanga nai, “Kada 'oe saungainia ta fafanga, nao 'oe si laefia ga 'amu mai na wane kwaimani 'oe ki, ma na wanefuta 'oe ki, naoma na wane todaru ki ne kera to karangi 'oe. Sulia kera saitamana kera kai saungainia laugo ta fangalae 'urinai, ma kera ka laefi 'oe laugo fuana duulana na ru ne 'oe sasia fuada. ");
INSERT INTO far_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Boroi ma kada 'oe saungainia ta fafanga, 'oe laefia mai na wane siofa ki, ma na wane ne 'aeda, ma 'abada mae ki, ma na wane maada rodo ki. ");
INSERT INTO far_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Dia 'oe sasia 'urinai, nia 'oilakie fuamu. Sui boroi 'ana nao kera si duua fuamu, God ne kai duua fuamu, ana kada ne wane 'o'olo ki kera tatae lau fasia na maea.” ");
INSERT INTO far_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ma ana kada nai, te wane ana tooa ne kera gouru fuana fangalae, nia rongoa te ne sa Jesus nia saea, nia ka fata 'uri, “Na 'oilakie fuana wane ne kera kai fanga ana fafanga 'i laona 'Initoe God.” ");
INSERT INTO far_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ma sa Jesus ka fata 'uri, “Ana te kada, te wane nia saungainia te fafanga baita, ma ka laefia mai wane 'oro ki fuana fangalae. ");
INSERT INTO far_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ma ana kada ru ki tafau nia kwaimakwali na, nia ka kwatea wane rao nia ka leka fuana saelana mai wane ne nia laefida fua kera ka leka mai. Nia fata 'uri, ‘Kamulu leka na mai sulia na ru ki nia kwaimakwali tafau na.’ ");
INSERT INTO far_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Boroi ma kera tala'ae kera ka fofone ru, kera ka saea ru ki nia susida ne kera nao si leka mai. Te wane nia fata 'uri, ‘Nau ku folia te lifu ano, ma nau ku doria leka ada to'ona basi. 'Oe farongoa, nau ku kwaimanatai 'asiana.’ ");
INSERT INTO far_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ma ruana wane ka fata 'uri, ‘Nau ku folia akwala buluka ana kada nai, ma nau ku doria nau leka ilito'oda basi, alamia kera rao lea naoma 'e nao. 'Oe farongoa, nau ku kwaimanatai 'asiana, nau si leka go kau.’ ");
INSERT INTO far_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ma oluna wane ka fata 'uri, ‘Nau ku fi arai go, ma nia ka 'afitai 'asiana fuaku fuana lekalae kau. 'Oe farongoa, nau ku kwaimanatai.’ ");
INSERT INTO far_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kada ne wane rao nia oli mai, ma ka farongoa wane baita nia ana ru nai ki, wane baita ne nia guisasu 'asiana, ma ka fata 'uri fuana wane rao nia, ‘'Oe leka 'ali'ali sulia taale baita ki, ma sulia taale tu'u ki, 'oko talaia mai na wane siofa ki, ma na wane ne 'aeda naoma 'abada mae ki, ma na wane ne maada rodo ki, ma fainia tai wane laugo ne nonida ta'a.’ ");
INSERT INTO far_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kada wane rao nai nia oli mai, nia ka fata 'uri fuana wane baita nia, ‘Ru be 'oe saea fuaku ki, nau ku sasia tafau na, ma kula ni gourue ana fafanga 'oe, nao nia si fungu 'ua ana wane ki.’ ");
INSERT INTO far_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wane baita ne ka fata lau 'uri, ‘'Oe leka lau sulia ka taale ki ne kera to tau, 'oe laefida, ma 'oe 'ingoa lau mai tai wane fuana lume nau ka fungu. ");
INSERT INTO far_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ma nau ku saea fuamu, nia 'afitai 'asiana fuana ta wane ana wane be nau ku laefida mai 'i nao ki, kera kai fanga ana fafanga nau.’” ");
INSERT INTO far_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ana te kada, na okue baita kera leka fainia sa Jesus. Ma nia ka abulo ka fata 'uri fuada, ");
INSERT INTO far_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ta wane ne nia doria kai leka buriku, nia ka kwaimani aku ka liufia na maa nia, na gaa nia, na 'afe nia, na wele nia ki, na wanefuta nia ki, na waiwane nia ki, ma nia talana laugo. ");
INSERT INTO far_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nia 'afitai fuana ta wane ka dia ta fafurongo aku, suli dia nia si nonimabe fuana lekalae 'i buriku, sui boroi 'ana kada nia kai nonifi, ma kai mae ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Dia ta wane amulu nia doria kai saungainia ta lume baita, nia kai gouru, ma ka manata basi sulia ta fita malefo ne nia to ana fuana kai bobola fainia fasuilana na lume nai. ");
INSERT INTO far_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Dia nia si sasi 'urinai, ma nia ka alua na fangadolana lume nai tafau, ma na wane ki kera ada to'ona ne nao nia si to ana malefo ne nia bobola fuana fasuilana, kera kai 'onionga ana, ma kera ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Na wane ne nia tala'ae na ana fauulana na lume ne, boroi ma nia nao si bobola fua nia ka fasuia.’ ");
INSERT INTO far_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ma dia ta kingi ne nia leka fainia te akwala to'oni wane nia ki fuana firulae fainia ta kingi mone ne nia leka mai fainia ro akwala to'oni wane nia ki fuana firulae, nia kai gouru basi 'i ano ka manata 'ana sulia fasi nao nia si nikila ka bobola go fuana fualilana wane omee ki fainia kingi nai. ");
INSERT INTO far_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ma dia nia nao go, nia kai kwatea ta wane ana, fuana kai leka, ma ka gani 'uria aroaroe 'i safitadaro, ana kada kera to tau 'ua mai. ");
INSERT INTO far_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ka 'urinai laugo, kamulu ka eta manata lea basi sulia nonifie ne kamulu kai dao to'ona kada ne kamulu kai leka buriku. Dia ta wane amulu ne nao nia si fasi faburi ana ru nia ki tafau, nia 'afitai 'asiana nia kai leka buriku.” ");
INSERT INTO far_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sa Jesus ka fata lau 'uri, “Na fiko asi nia na ru lea. Sui boroi 'ana, dia mamasia nia dalakwai na fasia, nia 'afitai 'asiana 'oe kwate nia ka mamasialana lau. ");
INSERT INTO far_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma nao nia si lea na fuana sasilana ana ta ru. Nao nia si lea na fuana ano ma fuana 'afilana ta ru. Ma nia bobola fainia kera ka 'ui 'ania ga 'ada. Dia ta wane doria ka saitamana lea ana ru ne, nia ka fafurongo lea.” ");
INSERT INTO far_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ana te kada, na wane 'oro ne kera rao ana konilana na malefo ana na takisi, ma na wane ne kera fia kera wane ta'a 'urinai ki laugo, kera dao fuana rongolana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Na Farasi ki ma na wane famanata ana taki ki, kera etangia ngunungunue kera ka 'uri, “Na wane ne nia kwaloa na wane ta'a ki ma ka fanga ga 'ana fai kera!” ");
INSERT INTO far_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nia ne sa Jesus ka fata 'ana na tarifulae ki fuada ka 'uri, ");
INSERT INTO far_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Dia ta wane amulu nia to ana te talanga sipsip, ma te ai ada ka naoana, te ne wane nai kai sasia? Nia kai fasia na sikwa akwala ma sikwa sipsip senai, ma nia ka leka ka nani 'uria te ai ne nia naoana, leka nia ka dao go to'ona. ");
INSERT INTO far_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ma kada ne nia dao to'ona, nia ka eele 'asiana, ma ka ngalia 'i gwauna 'abana, ");
INSERT INTO far_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ma ka ngalia mai 'i fera. Sui nia ka akwa mai 'uria wane kwaimani nia ki, ma na wane ana fere nia ki, fuana kera ka oku mai, ma nia ka fata 'uri fuada, ‘Nau ku eele 'asiana, sulia nau ku dao to'ona na sipsip nau be nia naoana. Nia ne mulu eele fai nau!’” ");
INSERT INTO far_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ma sa Jesus ka fata lau 'uri, “Nau ku saea fua mulu, na eelea baita 'urinai laugo 'i langi fafia te wane ne ta'a ma nia ka kari abulo. Na eelea fainia ka liufia na eelea fafia sikwa akwala ma sikwa wane ne kera 'o'olo ki.” ");
INSERT INTO far_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ma sa Jesus ka fata lau ana tarifulae ka 'uri, “Dia ta keni ne nia to ana ta akwala seleni, ma ta te seleni ka naoana, te ne nia kai sasia? Nia kai fasarua ta kwesu, ma ka salofia na lume nia, ma ka nani ana kula ki tafau leka nia ka dao go to'ona. ");
INSERT INTO far_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ma kada nia dao na to'ona, nia ka rii na 'uria wane kwaimani nia ki, ma na wane ana fere nia ki kera ka oku mai siana, ma nia ka fata 'uri fuada, ‘Nau ku eele 'asiana, sulia nau ku dao na to'ona na seleni be nau be naoana. Nia ne mulu eele 'amulu fai nau!’” ");
INSERT INTO far_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ma sa Jesus ka fata lau 'uri, “Nau ku saea fua mulu, ru nai kai 'urinai laugo 'i langi. Na 'ainsel God ki fainia God, kera eele 'asiana fafia te wane ne nia abulo ta'a, ma nia kari abulo mai.” ");
INSERT INTO far_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ma sa Jesus ka fata lau 'ana te tarifulae ka 'uri, “Te wane nia to ana ro welewane ki. ");
INSERT INTO far_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Na wele 'i buri nia fata 'uri fuana maa nia, ‘Maasi, 'oe kwatea na mai bali nau ana na toorue kulu.’ 'Urinai go, na wane nai ka tolingia na, na toorue kera 'i safitana na ro wele nia ki. ");
INSERT INTO far_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ma 'i burina bara fa asoa sui, na wele be 'i buri ka foli na ana bali nia ana toorue kera, ma ka leka na 'ana fainia malefo nia. Ma nia ka leka na 'ana 'uria na fere tau, ma ka falia tafau na 'ana na malefo nia ki ana na tolae ta'a. ");
INSERT INTO far_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ma 'i burina ne nia fasuia na, na malefo nia ki, na fioloe baita ka liu ana bali fere nai, ma nao nia si to na ana ta ru. ");
INSERT INTO far_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ma nia ka leka siana te wane ana fere nai ka ledi 'uria ta raoe, ma na wane nai ka kwate fuana raoe bilia ana adalae sulia na boso nia ki. ");
INSERT INTO far_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ma nia ka doria ka 'ania tani ngingisi fanga ana na fanga boso ki, sulia ta wane 'i senai si kwatea go ta fanga fuana. ");
INSERT INTO far_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Boroi ma kada nia manata lea, nia ka fata 'uri fuana talana, ‘Na wane ni rao maa nau ki, kera fanga lea tafau ga 'ada kada nai, ma kera ka abusu, ma nau ne nau ku fiolo ga 'aku fuana maelaku! ");
INSERT INTO far_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nia lea fuana nau ku oli siana maa nau, ma nau ku fata 'uri fuana, Maasi 'ae, nau ku garo 'asiana na 'i maana God, ma 'i maamu laugo. ");
INSERT INTO far_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nau nao si bobola fuana ne 'oe sae nau lau ana na wele 'oe. 'Oe alamatainia nau ku rao na 'aku fuamu dia ta wane ni rao 'oe.’ ");
INSERT INTO far_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ma nia ka tatae, ma ka oli siana maa nia. “Ma kada nia dao tau 'ua kau, na maa nia ka ada kau, ma ka ada to'ona. Ma nia ka kwaimanatai 'asiana ana na wele nia. Ma nia ka lae 'ali'ali kau, ma ka ofia mai na wele nia, ma ka nono'ia. ");
INSERT INTO far_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ma na wele nai ka fata 'uri fuana, ‘Maasi, nau ku garo 'asiana na 'i maana God ma 'i maamu laugo. Nau nao kusi bobola fuana ne 'oe sae nau lau ana wele 'oe.’ ");
INSERT INTO far_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Boroi ma na maa nia ka rii 'uria na wane rao nia ki ka 'uri, ‘Mulu 'ali'ali! Mulu ngalia mai na maku gwala, ma ka kwanga, ma mulu farufia 'ania. Ma kamulu ka alua fa kome ana 'abana, ma kamulu ka alua na tae butu ki 'i 'aena. ");
INSERT INTO far_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sui, kamulu ka leka, mulu saungia mai na ka buluka kobu be fua kulu ka saungainia na fafanga ma kulu ka eele 'akulu. ");
INSERT INTO far_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Sulia na wele nau, nia dia ne nia mae na, boroi ma nia ka mauri lau. Ma nia ka dia ne nia naoana, boroi ma nau ku ada to'ona lau. Ma na fafanga nai ka tala'ae na. ");
INSERT INTO far_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ma ana kada nai, na wele 'i nao be nia to 'ua mai 'ana 'i laona na oole. Ma kada ne nia oli mai ma nia ka dao karangia na mai na lume, nia ka rongoa lingena na sasoe ma na ngwaelae. ");
INSERT INTO far_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ma nia ka karumia mai te wane ana wane rao ki, ma ka ledi 'uri ana te fu kera ngwae fainia. ");
INSERT INTO far_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ma na wane ni rao nai nia olisia ka 'uri, ‘Na sasimu be nia oli na mai 'i fere, ma na maa 'oe ka saungia na ka buluka kobu be, sulia na sasimu nia mauri, ma ka oli mai ka dao na.’ ");
INSERT INTO far_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ma na wele 'i nao ka guisasu 'asiana, nao nia si ru na kau laona lume. Ma na maa nia ka ru mai 'i maa, ma ka 'ingoa fuana nia ru kau laona lume. ");
INSERT INTO far_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ma nia ka olisia na maa nia ma ka fata 'uri, ‘Ada to'ona basi, nau ku rao fuamu dia na wane rao 'o'oni 'oe sulia fangali 'oro ne ki, ma nau ku rosulia na fatalamu. Sui boroi 'ana, 'oe si kwatea go ta ka nanigot fuaku, fua nau ku sasi 'aku ta fafanga fainia na wane kwaimani nau ki! ");
INSERT INTO far_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Boroi ma na wele ne 'oe, nia falia na toorue 'oe ana na keni sesele ki, ma kada nia oli mai ka dao 'i fere, 'oe saungia na ka buluka kobu baita lea be fuana!’ ");
INSERT INTO far_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ma na maa nia ka olisia ka 'uri, ‘Wele nau 'ae, 'oe to tari na fai nau, ma na ru nau ki tafau, ne ru 'oe ki laugo. ");
INSERT INTO far_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sui boroi 'ana, kulu sasia na 'akulu na fafanga ne, ma kulu ka eele 'akulu, sulia na sasimu dia nia mae na, boroi ma nia ka mauri go ana. Ma nia ka naoana na, ma kada ne kulu ada to'ona lau.’” ");
INSERT INTO far_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Sa Jesus ka fata lau 'ana tarifulae fuana fafurongo nia ki ka 'uri, “Te wane 'initoa nia to ana te wane ni rao ne nia alua ka baita fuana toorue nia ki. Ma na wane ki kera ka saea fuana wane 'inito nai ne na wane rao nia, nia 'aurafu, ma ka falia ga 'ana na toorue nia ki. ");
INSERT INTO far_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ma na wane 'inito nai ka saea mai wane rao nia ma ka ledia ka 'uri, ‘Na te ne nau ku rongoa amu? 'Oe kedea na fita malefo nau ki tafau ne 'oe rao ana, sulia ne nao 'oe si baita na ana toorue nau ki.’ ");
INSERT INTO far_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Ma na wane rao 'aurafu nai ka manata 'uri, ‘Na wane baita nau nia kai fasui nau na fasia na raoe nau. 'Uri ma te ne nau kai sasia fuana nau to ana ta raoe falu? Nau si nikila na fuana 'elilana kilu ki, ma nau ku 'eke 'asiana ana ganilae. ");
INSERT INTO far_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nau ku saitamana ru ne nau kai sasia fuana kada nau ku sui fasia na raoe nau, na wane ki kera ka kwalo nau laona lume kera ki.’ ");
INSERT INTO far_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Ma nia ka akwa mai 'uria na wane ne kera ngali langa fasia na wane baita nia, ma nia ka fata 'uri fuana etana wane, ‘Fita ru ne 'oe ngali langa ana fasia na wane baita nau?’ ");
INSERT INTO far_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nia ka olisia ka 'uri, ‘Kwalu talanga galono 'oele.’ Ma na wane rao 'aurafu nai ka fata 'uri fuana, ‘Na 'aba beba ana na ngali langalae 'oe be ne, 'oe gouru, ma 'oe kedea fai talanga galono.’ ");
INSERT INTO far_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ma nia ka fata 'uri fuana ruana wane, ‘Ma 'oe ta fita ru ne 'oe ngali langa ana?’ Ma nia ka olisia ka 'uri, ‘Na te talanga ngwai fulaoa fua beret.’ Ma na wane rao 'aurafu nai ka fata 'uri fuana, ‘Na 'aba beba ana na ngali langalae 'oe ne, 'oe kedea kwalu akwala ngwai.’ ");
INSERT INTO far_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ma na wane baita nia ka tangoa na wane rao 'aurafu nai fuana liotoe ne nia to ana. Sulia ne na wane ne ki laona molagali kera lioto ana ru lao molagali ne, ka liufia na wane ana na madakwalae ki. ");
INSERT INTO far_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Nau ku saea fua mulu, mulu kwatea na toorue kamulu ki fuana 'afilana wane 'e'ete ki. Ma kada na malefo kamulu nia sui, God kai kwalo kamulu 'uri 'i langi. ");
INSERT INTO far_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Dia sa ti ne nia rao lea ana toorue tu'u ki, nia ka rao lea laugo ana toorue baita ki. Ma dia sa ti ne nia rao noni'ela ana toorue tu'u ki, nia ka rao noni'ela laugo ana toorue baita ki. ");
INSERT INTO far_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ka 'urinai laugo, dia nao kamulu si rao lea ana na toorue ki laona molagali, God nao si famamana kamulu laugo fainia na toorue mamana. ");
INSERT INTO far_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ma dia kamulu si rao lea ana ru ta wane 'e'ete, God nao si kwatea laugo ru ki fua mulu 'i langi. ");
INSERT INTO far_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Nao ta wane rao si rao fuana ta ro wane baita 'e'ete ki. Dia nia 'urinai, nia kai malimae ana ta wane baita, ma ka kwaimani ana ta wane baita. Ma nia ka rao lea fuana ta wane, ma ka faburi ana ta wane. Nia 'afitai 'asiana dia ne mulu rao lau fuana God, ma na malefo lau ana te kada.” ");
INSERT INTO far_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ma kada Farasi ki kera rongoa ru nai, kera ka 'onionga sa Jesus, sulia kera wane ogalulumi 'asiana ana malefo ki. ");
INSERT INTO far_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sa Jesus ka fata 'uri fuada, “Kamulu sasia ru lea ki 'i naona wane ki, fua kera ka tango kamulu. Boroi ma God nia saitamana ga 'ana mangomulu. Sulia te ne na wane nia manata baita ana, God nao si manata baita go ana.” ");
INSERT INTO far_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Sa Jesus ka fata lau 'uri, “Na taki sa Moses ki, ma na kekedee na profet ki, nia rao ka talai kamulu mai leka ka dao ana kada sa Jon wane ni Siuabu nia dao ana. Ma nia ka safali mai ana sa Jon nia 'ainitaloa na Farongoe Lea sulia God ne kai gwaungai ana wane nia ki, na wane 'oro ki kera eele fuana rulae 'i laona na maurie ne God kai gwaungai ana. ");
INSERT INTO far_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Boroi ma nao ta ru tu'u ana taki sa Moses kai sui. Na salo ma na molagali kai sui, boroi ma na nikilalana na taki ki ka to tari nao si sui. ");
INSERT INTO far_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Dia ta wane kai lukasia na 'afe nia ma ka adea lau ta keni 'e'ete, nia oee na. Ma dia ta wane ka adea na 'afe ne arai nia lukasia, nia oee laugo.” ");
INSERT INTO far_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Sa Jesus ka fata lau 'uri, “Te wane tooru ne nia ofi ana na 'aba maku lea ki ne folilana baita, nia ka to ana tolae lea sulia asoa ki tafau. ");
INSERT INTO far_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ma te wane siofa ne maale 'oro ki nia ana nonina, ne satana sa Lasaros, nia gouru 'i ano 'aena na mae ana lume na wane tooru nai. ");
INSERT INTO far_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ma sa Lasaros doria ka 'ania orongana na fanga ne 'asia fasia na tatafe ni fangalae na wane tooru nai. Ma kada sa Lasaros nia gouru 'i ano, na kui ki boroi, kera dao mai, ma kera ka melia na maale nia ki. ");
INSERT INTO far_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sa Lasaros ka mae, ma na 'ainsel ki kera ka ngalia 'alaa siana sa Abraham 'uria na fafanga baita 'i langi. Ma na wane tooru nai ka mae laugo, ma kera ka faitoli na ana. ");
INSERT INTO far_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ma nia ka to laona kula fuana wane mae ki ana na nonifie baita. Ma nia ka ada kau 'alaa, ma ka ada to'ona sa Abraham ma sa Lasaros keroa 'ado 'ada. ");
INSERT INTO far_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ma nia ka akwa kau fuana sa Abraham ma ka 'uri, ‘Koko Abraham 'ae, 'oe manatai nau mai. Kwatea mai sa Lasaros, fua ka kutumainia mai na kakauna laona kafo, ma ka fagwaria na meaku, sulia nau ku to na ana na nonifie 'i laona na ere ne.’ ");
INSERT INTO far_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Boroi ma sa Abraham ka fata 'uri fuana, ‘Wele nau 'ae, 'oe manata to'ona basi 'amu kada be 'oe mauri, 'oe too ana na ru lea 'oro ki, ma sa Lasaros ka too go ana na ru ta'a ki. Boroi ma ana kada ne, nia ka to na laona eelea 'i seki, ana kada ne 'oe to 'amu laona na nonifilae. ");
INSERT INTO far_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ma ta ru lau, God nia alua te kilu baita 'i safitakulu, ma nao si bobola fainia ta wane ka tofolo kau 'uria bali nena. Ma ka nao si bobola laugo fuana ne ta wane ka tofolo mai siamalu.’ ");
INSERT INTO far_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ma nia ka olisia ka 'uri, ‘Koko, nau ku amasi 'oe kau fuana 'oe kwatea sa Lasaros 'uria lume maa nau, ");
INSERT INTO far_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","fuana nia ka fabasua na lima wanefuta nau ki, fasia kera ka leka laugo mai ana kula ni nonifilae ne.’ ");
INSERT INTO far_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ma sa Abraham nia olisia ka fata 'uri, ‘Na kekedee sa Moses, ma na profet ki nia to tafau ga 'ana faida. Nia bobola fuana kera ka rosulida.’ ");
INSERT INTO far_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ma nia ka fata 'uri, ‘Koko Abraham 'ae, nao go. Dia ta wane ne nia mae ma ka mauri lau, ma nia ka leka siada, kera ka kari abulo fasia na ta'alae kera ki.’ ");
INSERT INTO far_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ma sa Abraham ka fata 'uri fuana, ‘Dia kera nao si rosulia na kekedee sa Moses ma na profet ki, nia 'afitai go fuana kera ka famamana, sui boroi 'ana dia ta wane ka tatae lau fasia na maea.’” ");
INSERT INTO far_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sa Jesus fata 'uri fuana fafurongo nia ki, “Na ru ne ki kwatea ma wane ki kera ka abulo ta'a, nia kai fuli. Boroi ma nia kai ta'a 'asiana fuana wane ne nia kwatea ma ru nai ki ka fuli! ");
INSERT INTO far_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dia ta wane nia kwatea wane ne kera marabibi ki ka 'asia fasia fitoe kera ki aku, nia lea fuana kera ka kania ta mae fau baita 'i luana, ma kera ka 'ui 'ania 'i laona matakwa. ");
INSERT INTO far_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mulu madafi kamulu! “Dia na wanefuta 'oe nia abulo ta'a, 'oe ngatafia. Dia nia kari abulo, 'oe manatalugea ta'alae nia ki. ");
INSERT INTO far_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ma dia na abulolana nia ta'a fuamu ana fiu kada ki laona te asoa, ma nia ka leka mai siamu burina fiu kada nai ki, ma ka fata 'uri, ‘Nau ku kari abulo na,’ 'oe manataluge nia na.” ");
INSERT INTO far_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Na lifurongo nia ki kera ka fata 'uri fuana na 'Aofia, “'Oe fanikila na fitoe kalu ki.” ");
INSERT INTO far_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ma sa Jesus olisida ka 'uri, “Dia kamulu to ana fitoe tu'u boroi 'ana ka dia ta mege mastad ne nia tu'u 'asiana, kamulu saitamana saea go amulu fuana ta 'ai baita, ‘Lafu fa lalimu, ma 'oe 'idu kau 'i lao asi.’ Ma nia kai ro ga 'ana sulia na fatalamulu. ");
INSERT INTO far_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Dia ta wane amulu nia ka to ana ta wane ni rao ne nia 'elia na ano, naoma ka ada sulia na sipsip ki, ma kada nia oli mai fasia na oole, na te ne 'oe saea fuana? 'Oe saea fuana nia kai leka 'ali'ali mai, ma ka fanga basi? ");
INSERT INTO far_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nao! 'Oe fata lalau 'uri fuana, ‘'Oe ngarea basi mai na fanga nau ki, ma 'oe ka ofi falu, sui 'oe ka fi ngali fanga mai. Buri'ana nau fanga, 'oe fi fanga, ma 'oe fi ku 'amu.’ ");
INSERT INTO far_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ma na wane gwaungai ne nao si fata lea go ana na wane rao nia, sulia nia sasi sulia na ru nia saea fuana. ");
INSERT INTO far_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ka 'urinai laugo fua mulu. Kada kamulu sasia ru ki tafau ka sui ne God nia sae kamulu fua sasilana, mulu ka fi fata 'uri, ‘Kalu wane rao ki ga ana ne, kalu sasia go raoe ne 'oga kalu ki.’” ");
INSERT INTO far_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sa Jesus nia leka 'uria 'i Jerusalem, ma ka liu safitana bali lofaa 'i Samaria ma 'i Galili. ");
INSERT INTO far_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma kada nia dao ana te mae fere, nia ka dao to'ona te akwala wane ne kuu nia saungida. Kera uu tau mai, ");
INSERT INTO far_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ma kera ka akwa baita mai kera 'uri, “Jesus na wane baita 'ae, 'oe manatai kalu mai!” ");
INSERT INTO far_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ma kada sa Jesus nia suada, nia ka fata 'uri fuada, “Kamulu kai leka, mulu ka fatainia noni mulu fuana fataabu God ki, fuana kera ka famamana ne na noni mulu 'e mafo na.” Ma kada kera leka na, na nonida 'e mafo tafau na. ");
INSERT INTO far_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kada te wane ada nia ada to'ona ne nonina 'e mafo na, nia ka oli mai, ma ka akwa baita, ma ka tangoa God. ");
INSERT INTO far_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ma nia ka boruru na 'i maana 'aena sa Jesus ma ka tangoa. Nia nai nao lau na wane Jiu, nia lalau fasia 'i Samaria. ");
INSERT INTO far_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ma sa Jesus ka fata 'uri, “Na akwala wane be nau ku gurada ma na nonida ka mafo na. Ma ta sikwa wane lau, kera nia 'i fai? ");
INSERT INTO far_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","'Uta ne wane be ki tafau nao si oli mai fuana tangolana God, boroi ma taifilia go na wane ne nao lau na Jiu ne oli mai?” ");
INSERT INTO far_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ma sa Jesus ka fata 'uri fuana, “Tatae, 'oko leka na 'amu. God nia gura 'oe na sulia 'oe famamana nau.” ");
INSERT INTO far_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tani Farasi kera ledi 'uri 'ana sa Jesus, “Kada 'uta ne God kai gwaungai ana molagali ne?” Ma sa Jesus olisida ka 'uri, “Na kada ne God kai gwaungai ana wane nia ki, nao kamulu si ada to'ona ana ta maetoto baita. ");
INSERT INTO far_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ma nao ta wane si fata 'uri, ‘Ada to'ona basi, na gwaungaie God nia 'i seki!’ Naoma ka 'uri, ‘Nia na seloko!’ Sulia kula God gwaungai ana nia lalau 'i laona maurilana wane.” ");
INSERT INTO far_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Sui sa Jesus ka fata 'uri fuana fafurongo nia ki, “Na kada kai dao mai, kada mulu doria adalae to'ona na asoa nau, na Wele nia Wane. Boroi ma nao kamulu si ada to'ona. ");
INSERT INTO far_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ma tani wane kera kai fata 'uri fua mulu, ‘Ada basi, na Christ nia na 'i seloko!’ Naoma kera ka 'uri, ‘Ada basi, nia na 'i seki!’ 'Urinai boroi, nao kamulu si leka fuana adalae 'uria. ");
INSERT INTO far_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Sulia na olilaku mai, na Wele nia Wane, nia kai dia na meamea ne nia madakwa 'i lofana salo, ma na madakwalana kai tala laona salo tafau, ma wane ki tafau kai ada to'ona. ");
INSERT INTO far_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Boroi ma 'i naona olilaku mai, nau kai nonifi, ma na wane ki kera ka noni'ela 'ani nau. ");
INSERT INTO far_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Kada nau ku oli mai ana, nia kai dia laugo kada be sa Noa. ");
INSERT INTO far_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ana kada sa Noa, na wane ki kera fanga, ma kera ka ku, ma wane ki fainia keni ki kera ka 'afe ma kera ka arai. Go kera ka tona na sulia kada sa Noa nia ra laona faka baita, ma na kafo ka fungu mai, ma ka kuruuda tafau na. ");
INSERT INTO far_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ma kada nau kai oli mai ana, nia dia laugo na kada be sa Lot, sulia wane ki kera fanga, ma kera ka ku, ma kera ka foli, ma kera ka 'oifoli, kera ka fasi fanga, ma kera ka saungai lume. ");
INSERT INTO far_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ana kada ne sa Lot nia leka fasia 'i Sodom, kera tona, ma na ere ma na mae fau 'ako'ako ki ka 'asia na mai fasia 'i langi ma ka sarufida tafau. ");
INSERT INTO far_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nia kai dia laugo na maedangi nau kai oli mai ana. ");
INSERT INTO far_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ma ana maedangi nai, na wane ne nia to 'i maa ana lume nia, nao nia si oli lau mai laona fuana ngalilana ru nia ki. Ka 'urinai laugo fuana wane ne nia laona oole, nao nia si oli lau mai 'i lume. ");
INSERT INTO far_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mulu manata to'ona ru ne fuli fuana 'afe sa Lot. ");
INSERT INTO far_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Dia sa ti ne nia doria kai dau sulia na maurilana fuana talana, nia kai mae. Ma dia sa ti ne ka lukasia na maurilana sulia nia leka buriku, nia kai mauri mamana na. ");
INSERT INTO far_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nau ku saea fua mulu, ana fa rodo nai, ro wane ne keroa maleu laona te 'ifitai, te wane God kai ngalia, ma te wane kai ore. ");
INSERT INTO far_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ro keni ki keroa sasi fanga oku, te keni God kai ngalia, ma te keni kai ore.” ");
INSERT INTO far_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ma na fafurongo nia ki ka ledi 'uri, “'Aofia 'ae, 'i fai mone ne na ru nai ki nia kai fuli ana?” Ma sa Jesus olisida ka 'uri, “Na olilaku mai nao ta wane si talafia ka dia laugo ne na gwaubalano nao si talafia ta ru mae.” ");
INSERT INTO far_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sa Jesus nia fata fuana fafurongo nia ki ana tarifulae ne, fua kai fatainia fuada ne kera kai foa sulia maedangi ki tafau, ma kera nao si fitala. ");
INSERT INTO far_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nia ka fata 'uri, “Te wane ni kwaiketoi, nia to ana te fere, ma nao nia si fa'initoa God, ma nao nia si fuusi baita go ana ta wane. ");
INSERT INTO far_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ma te gwa 'oru 'i laona na fere nai, nia leka mai sulia dangi ki siana fuana 'ingolana ma ka fata 'uri, ‘Nau ku doria 'oko kwatea kwaiketoilae 'o'olo fuaku susia na malimae nau ki.’ ");
INSERT INTO far_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ma sulia kada tau na, na wane ni kwaiketoi nai si ala go fafia. 'I buri, nia ka manata 'uri fuana nia talana, ‘Sui boroi 'ana nao nau si fa'initoa God, ma nao nau si fuusi baita go ana ta wane, ");
INSERT INTO far_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","nau kwate na 'aku kwaiketoilae 'o'olo fuana gwa 'oru ne, nia fa'abero nau 'asiana ana lekalae mai siaku, fasi nia ka faulafu nau ana 'idufa lekalae mai siaku!’” ");
INSERT INTO far_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ma na 'Aofia ka fata 'uri, “Mulu rongo basi na ru ne wane kwaiketoi ta'a nai nia saea. ");
INSERT INTO far_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","'Urinai boroi nia kwatea na kwaiketoie 'o'olo fuana, nia ne nao mulu si manata ruarua ana God ne ka kwatea 'o'oloe fuana wane nia ki, ne kera gania suli rodo ma dangi. God nao si dole fuana 'adomilada. ");
INSERT INTO far_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nau ku saea fua mulu, God kai 'adomida fua 'olosilana 'afitai 'e kera ki 'ali'ali. Ma kada nau, na Wele nia Wane, kai oli mai laona molagali, 'uri ma nau kai dao to'ona wane 'oro ki ne kera famamana nau, naoma 'e nao go?” ");
INSERT INTO far_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Sa Jesus nia fata ana tarifulae fuana tani wane ne kera famamana kera talada sae kera 'o'olo ma kera ka ada toli ana tani wane, ka 'uri, ");
INSERT INTO far_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Ro wane ki keroa leka 'i laona na Beu Abu God fua keroa ka foa. Te wane ne na Farasi, ma ta wane ne nia rao ana konilana malefo ana takisi. ");
INSERT INTO far_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Farasi nai nia uu taifilia, ma ka foa 'uri, ‘God 'ae, nau ku tango 'oe sulia nao nau si dia na wane 'e'ete ki tafau. Sulia kera beli, ma kera ka ilia ru ta'a ki, ma kera ka oee. Nao nau si dia na wane ta'a loko ne nia konia na malefo ana takisi. ");
INSERT INTO far_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nau ku abu fanga ana ro maedangi 'i laona te wiki, ma nau ku kwatea na tangafuluna toorue nau ki fuamu.’ ");
INSERT INTO far_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Boroi ma na wane ne nia konia na malefo ana takisi, nia uu tau mai 'ana. Ma nia si taea go maana 'uria 'i langi, sulia nia 'eke 'asiana. Ma nia ka fatainia na olikokorue nia ana fidalilana na ruruna, ma ka fata 'uri, ‘God 'ae, manatai nau mai, nau na wane abulo ta'a!’” ");
INSERT INTO far_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ma sa Jesus ka fata laugo 'uri, “Nau ku saea fua mulu, na wane ne nia olikokoru na ne, God nia fa'o'oloa ana kada nia ru kau 'i maa, ma nao lau na Farasi. Sulia na wane ki ne kera fabaita kera talada, God kai fatu'u kera. Ma na wane ne kera fatu'u kera talada, God kai fabaita kera.” ");
INSERT INTO far_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tani wane kera ngalia mai na kaelana wele tu'u siana sa Jesus, fua ka alua na 'abana fafida ma ka faleada. Ma kada fafurongo nia ki kera ada to'ona, kera ka balufida. ");
INSERT INTO far_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Boroi ma sa Jesus ka saea mai kaelana wele nai ki siana, ma ka fata 'uri fuada, “Mulu alamatainia na kaela wele tu'u kera ka leka mai siaku, ma nao mulu si susida lau. Sulia sa ti ne nia famamana ka dia wele tu'u ki, nia bobola fuana tolae laona 'Initoe God. ");
INSERT INTO far_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nau ku saea ru mamana fua mulu, dia ta wane ne nao si famamana dia ta wele tu'u, nia 'afitai 'asiana fua nia ka ru 'i laona na 'Initoe God.” ");
INSERT INTO far_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Te wane fanaonao ana Jiu ki, nia ledia sa Jesus ka fata 'uri, “Wane famanata lea ne 'ae, ta te lea ne nau ku sasia fua nau ku too ana na maurie firi?” ");
INSERT INTO far_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ma sa Jesus olisia ka 'uri, “'Uta ne 'oe sae nau ana wane lea? Nao ta wane si lea go, taifilia God go ne lea. ");
INSERT INTO far_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nia lea 'oe saitamana faoraie talingai God ki be 'uri, ‘'Oe si sauwanee, 'oe si oee, 'oe si beli, 'oe si suke fafia ta wane, ma 'oe fuusi baita ana maa 'oe ma gaa 'oe.’” ");
INSERT INTO far_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Wane nai nia olisia ka fata 'uri, “Nia safali mai ana kada nau ku tu'u, nau rosulia na taki nai ki tafau leka ka dao 'i ta'ena.” ");
INSERT INTO far_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ma kada sa Jesus nia rongoa ru nai, nia ka fata 'uri fuana, “Te ru go ne nia nao 'ua. 'Oe fafoli ana na ru 'oe ki tafau, ma 'oe ngalia malefo nai ki, ma 'oko kwatea fuana wane siofa ki, ma 'oe fi too ana na toorue 'i langi. 'Urinai go, 'oe leka na mai suli nau.” ");
INSERT INTO far_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ma kada wane nai nia rongoa ru nai, na manatana ka kwaimanatai 'asiana, sulia nia na wane todaru 'asiana. ");
INSERT INTO far_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ma kada sa Jesus nia ada to'ona wane nai, na manatana nia ka kwaimanatai, nia ka fata 'uri, “Nia 'afitai 'asiana fuana wane todaru ki kera ka ru laona 'Initoe God. ");
INSERT INTO far_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Nia 'afitai 'asiana fua ta kamel kai ru sulia na mae kwakwa tu'u ana nile. Nia 'afitai ka liufia lau fuana ta wane todaru kai ru laona na 'Initoe God.” ");
INSERT INTO far_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Aia, kada wane ki kera rongoa na faoraie nai, kera ka ledia 'uri, “'Urinai ma nao ta wane si toda go mauri firi?” ");
INSERT INTO far_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ma sa Jesus ka olisia ka 'uri, “Na ru nai nia 'afitai 'asiana fuana wane, boroi ma fua God nao nia si 'afitai go.” ");
INSERT INTO far_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ma sa Pita ka fata 'uri fuana sa Jesus, “Kalu fasia na toorue kalu ki tafau fua kalu ka leka na suli 'oe!” ");
INSERT INTO far_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Sa Jesus ka fata 'uri, “Iu. Nau ku saea fua mulu, dia sa ti ne nia fasia na lume nia, na 'afe nia, na wanefuta nia ki, na maa nia ma na gaa nia, ma na wele nia ki, sulia 'Initoe God, ");
INSERT INTO far_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nia kai too ana ru 'oro ki laona molagali ne liufia ru be nia fasia ki. Ma ana mauri falu ne nia leka mai, wane nai kai too na ana mauri firi.” ");
INSERT INTO far_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ma kada sa Jesus nia leka fainia fafurongo nia ki taifili kera, nia ka fata 'uri fuada, “Kulu leka 'uri 'i Jerusalem fua kera kai faali'afua ru be na profet ki kera kekede mai sulia nau, na Wele nia Wane. ");
INSERT INTO far_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Kera kai kwate nau laona 'abana wane ne nao laugo Jiu ki, fua kera ka 'onionga, ma ka fata buri tolingai aku, ma kera ka ngisufi nau. Kera ka kwae nau, ma kera ka saungi nau. ");
INSERT INTO far_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ma ana oluna maedangi, nau kai tatae lau fasia na maea.” ");
INSERT INTO far_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Boroi 'ana fafurongo ki kera nao si saitamana go na faoraie nai ki ne sa Jesus nia saea fuada, sulia manatalada ngasi 'asiana fuana malingailana na ru ne sa Jesus fata sulia. Nia ne kwate ma kera nao si saitamana te ne sa Jesus nia fata sulia. ");
INSERT INTO far_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kada sa Jesus nia dao karangia mae fere 'i Jeriko, te wane maana rodo nia to 'i ninimana taale. Ana maedangi ki nia gani malefo ana wane ki. ");
INSERT INTO far_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ma kada nia rongoa wane 'oro ki kera liu, nia ka ledi kera ka fata 'uri, “Te ne 'uri?” ");
INSERT INTO far_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ma kera olisia kera ka fata 'uri, “Sa Jesus na wane be 'i Nasaret ne nia leka mai.” ");
INSERT INTO far_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ma wane maana rodo nai ka akwa ma ka fata 'uri, “Jesus 'oe na Wele ana kwalafa sa Deved, 'oe manatai nau mai!” ");
INSERT INTO far_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ma wane ne kera eteta 'i naona kera ka balufia, ma kera ka saea nia ka to aroaro. Boroi ma nia fi akwa baita lau, ma ka fata 'uri, “'Oe na wele ana kwalafa sa Deved, 'oe manatai nau mai!” ");
INSERT INTO far_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ma sa Jesus ka uu ngado ma ka saea fuada fua kera ka talaia mai siana. Ma kada nia dao karangi, sa Jesus ka ledia, ");
INSERT INTO far_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Te ne 'oe doria nau sasia fuamu?” Ma wane maana rodo nai ka fata 'uri, “'Aofia 'ae, nau ku doria nau ada lau.” ");
INSERT INTO far_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Sa Jesus ka fata 'uri fuana, “'Oe ada na. God nia gura 'oe na, sulia 'oe famamana nau.” ");
INSERT INTO far_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ma 'urinai go nia ka ada na, ma nia ka leka na fainia sa Jesus, ma nia ka tangoa God. Ma kada wane ki kera ada to'ona, kera ka tangoa laugo God. ");
INSERT INTO far_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Sa Jesus nia dao 'i Jeriko, ma ka liu lao fere nai. ");
INSERT INTO far_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma te fanaonao ana wane kera ka koni malefo ana takisi, ne satana sa Sakias, nia wane todaru 'asiana. ");
INSERT INTO far_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ma nia ka sasi 'asiana 'uria adalae to'ona sa Jesus. Boroi ma ka 'afitai, sulia nia wane kokoru 'asiana, ma nao nia si ada to'ona sa Jesus, sulia na okue nai 'e susia. ");
INSERT INTO far_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ma nia ka lae 'ali'ali kau 'i naofana okue nai, ma ka ra 'i gwauna te 'ai ne kera saea ana Sikamo, fua ka ada to'ona sa Jesus ne nia leka mai sulia taale. ");
INSERT INTO far_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Kada sa Jesus nia dao ana kula nai, nia ka ada 'alaa 'i gwauna 'ai nai, ma ka ada to'ona sa Sakias, ma ka fata 'uri fuana, “Sakias 'ae, koso 'ali'ali mai, sulia nau kai to 'i lume 'oe ta'ena.” ");
INSERT INTO far_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sa Sakias ka eele 'asiana, ma ka koso 'ali'ali mai, ma ka kwaloa sa Jesus laona lume nia. ");
INSERT INTO far_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na wane ki tafau kera ada to'ona ru nai, ma kera ka ngunungunu buri ana, kera 'uri, “Sa Jesus nia leka na fuana ka to fainia na wane ta'a ne.” ");
INSERT INTO far_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ma sa Sakias tatae, ma ka fata 'uri fuana sa Jesus, “'Aofia 'ae, nau kai kwatea ta bali ana na toorue nau fuana wane siofa ki. Ma dia nau ku ngali liufia tani ru ana wane ki, nau kai duu fai ru ana fuana.” ");
INSERT INTO far_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ma sa Jesus ka fata 'uri fuana, “Ta'ena God nia famauria laugo na gourue ne, sulia wane ne nia famamana God dia famamanae be na koko kia sa Abraham. ");
INSERT INTO far_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nau, na Wele nia Wane, nau ku leka mai fuana nanisilana na wane ne kera leka garo ki, fua nau ku famaurida laugo.” ");
INSERT INTO far_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na okue baita ne kera fafurongoa ru ki tafau ne sa Jesus saea. Sulia nia dao karangia na 'i Jerusalem, nia saea na tarifulae ne fua ka fa'o'olosia manatada, sulia kera kwaisae 'Initoe God kai fuli 'ali'ali go. ");
INSERT INTO far_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nia ne kwate sa Jesus ka fata 'uri fuada, “Te wane ana gourue 'initoa, nia sasi akau fua ka leka siana te kingi baita ne nia to tau mai, fua nia ka gani 'uria na gwaungaie ma na 'initoe fua kada nia kai oli mai, nia ka kingi fuana fere nia. ");
INSERT INTO far_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma 'i naona ne nia leka, nia saea mai akwala wane rao nia ki siana, ka kwatea na malefo baita fuada, ka fata 'uri, ‘Mulu rao ana malefo ne ki, fua mulu ka ngalia laugo tani malefo maana makwalia nau.’ ");
INSERT INTO far_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Boroi ma wane ana fere wane 'initoa nai, kera subutainia, ma kera ka kwatea tani wane fua kera ka faorai fainia kingi nai, sulia kera nao si doria go ne na wane nai ka kingi fuada. ");
INSERT INTO far_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ka 'urinai boroi 'ana, na kingi nia alua wane nai ka kingi na fuada, ma ana kada nia oli mai, nia ka saea fuana wane ni rao nia ki be nia kwate malefo fuada, fua nia ka dao to'ona ta fita malefo lau ne kera toda maana malefo be nia kwatea fuada. ");
INSERT INTO far_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Na etana wane rao nia leka mai, ka fata 'uri, ‘Wane baita 'ae, nau ku to ana te akwala malefo lau fainia malefo be 'oe kwatea fuaku.’ ");
INSERT INTO far_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ma wane 'initoa nai ka fata 'uri fuana, ‘'Oe wane rao lea. Sulia nau ku saitamana nau ku fito'omu ana ru tu'u ki, 'urinai nau ku alua 'oe ada sulia akwala mae fere ki.’ ");
INSERT INTO far_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","'Urinai ma ruana wane ni rao leka mai ma ka fata 'uri, ‘Wane baita 'ae, nau ku to ana lau ta lima malefo fainia na malefo be 'oe kwatea fuaku ki.’ ");
INSERT INTO far_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ma wane 'initoa nai ka fata 'uri fuana, ‘'Oe kai ada sulia lima mae fere ki.’ ");
INSERT INTO far_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Burina, oluna wane ni rao ka leka lau mai, ka fata 'uri, ‘Wane baita 'ae, malefo 'oe ki be nau ku ngalida, nau ku 'afu ngingiri fafia ana 'aba maku. ");
INSERT INTO far_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Sulia nau ku mau amu wane fatamaudi. 'Oe dia ta wane ne saitamana ka ngalia ga 'ana ru wane 'e'ete ki, ma 'oe saitamana ngalia laugo fanga fasia oole wane ki.’ ");
INSERT INTO far_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Sui wane 'initoa nai ka fata 'uri fuana, ‘'Oe na wane rao ta'a! Nau kai keto 'oe ana faoraie 'oe ki talamu. 'Oe sae nau wane fatamaudi, ma nau ku dia ta wane ne ngalia ru ne nao lau ru nau ki, ma nau ku ngalia fanga fasia oole tani wane ki. ");
INSERT INTO far_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Dia 'oe manata 'urinai, 'uta ne nao 'oe si ngalia na malefo nau, ma 'oe alua 'amu laona kula ni totodae, fuana kada nau ku oli mai, nau ku ngalia tani malefo tarenga 'i maana?’ ");
INSERT INTO far_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","'Urinai go wane 'initoa nia ka fata 'uri fuana wane ne kera uu 'i senai, ‘Mulu ngalia malefo ne fasia, ma mulu kwatea fuana wane ne nia to ana akwala malefo.’ ");
INSERT INTO far_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kera ka fata 'uri, ‘Wane baita 'ae, nia to na ana akwala malefo.’ ");
INSERT INTO far_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ma wane 'initoa nai olisia ka 'uri, ‘Nau ku saea fua mulu dia sa ti ne nia rao lea ana ru ne nau kwatea fuana, nau kai kwatea lau tani ru 'oro fuana. Boroi ma dia sa ti ne nao si rao lea ana ta te ne nau ku kwatea fuana, sui boroi 'ana ta ru tu'u ne nia to ana, nau kai lafua fasia. ");
INSERT INTO far_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Boroi ma fuana malimae nau ki be kera noni'ela 'ani nau kingi fuada, talaida mai, mulu ka saungida 'i seki 'i naoku.’” ");
INSERT INTO far_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Burina sa Jesus nia fata 'urinai ka sui, nia ka leka kau 'i naoda 'uria 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ma kada nia dao karangia fere 'i Betfeis, ma 'i Betani siana fa uo kera saea ana 'i Olif, nia ka kwatea ro fafurongo nia ki 'i nao, ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Kamoro leka ana fere loko kamoro naofia kau. Ma kada kamoro dao 'i senai, moro kai ada to'ona te dongki. Kera kania ga 'ada 'i senai, ne nao ta wane si tae 'ua fafona. Kamoro ka lugea, ma moro ka talaia mai 'i seki. ");
INSERT INTO far_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ma dia ta wane nia ledi kamoro, ‘'Uta ne moro ka lugea na dongki ne?’ Moro saea fuana, ‘Na 'Aofia nia doria.’” ");
INSERT INTO far_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Aia, ro wane nai ki keroa leka, ma keroa ka dao to'ona, dia be sa Jesus nia saea. ");
INSERT INTO far_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kada keroa lugea na dongki nai, na wane ne kera to ana dongki nai, kera ka fata 'uri, “Te ne moro lugea na dongki ne fuana?” ");
INSERT INTO far_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Keroa ka fata 'uri, “Na 'Aofia nia doria.” ");
INSERT INTO far_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ma keroa ka talaia na mai siana sa Jesus, ma keroa ka alua maku keroa ki 'i fafona sulina na dongki nai, ma keroa ka 'adomia sa Jesus fua ka gouru 'i fafona. ");
INSERT INTO far_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma kada sa Jesus nia leka kau sulia taale, wane ki kera ka safatainia maku gwala kera ki. ");
INSERT INTO far_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ma ana kada nia dao karangia 'i Jerusalem ana kula ne taale nia koso toli 'uria fa uo 'i Olif, ne wane 'oro ana fafurongo nia ki kera to 'i senai, ma kera ka safali fua tangolana God ana te akwalae baita, sulia na fanadae baita ki ne kera suada. ");
INSERT INTO far_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ma kera ka fata 'uri, “God 'oe falea na kingi ne nia leka mai ana na nikilalae 'oe! Ma na aroaroe fainia God. Kulu kai tangoa God ne gwaungailae nia 'e tasa!” ");
INSERT INTO far_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tani Farasi ki kera to laugo 'i senai, ma kera ka fata 'uri fuana sa Jesus, “Famanata 'ae, 'oe saea fuana fafurongo 'oe ki, kera to aroaro.” ");
INSERT INTO far_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ma sa Jesus ka olisida ka 'uri, “Nau ku saea fua mulu, dia kera to aroaro, na fau ne ki kera kai akwa ana tangolana God.” ");
INSERT INTO far_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ma ana kada sa Jesus nia dao karangia 'i Jerusalem, nia ka ada kau, ma ka ada to'ona na mae fere nai, ma nia ka angi, sulia na manatana nia kwaimanatai fuana wane ne kera to 'i senai ki. ");
INSERT INTO far_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ma ka fata 'uri, “Nia lea dia kamulu saitamana 'i ta'ena na ru ne nia talaia wane 'uria aroaroe. Boroi ma ta'ena, kamulu ulafusi go. ");
INSERT INTO far_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na kada kai dao mai, fuana malimae kamulu ki, kera leka mai, kera ka fuali kamulu, ma kera ka susi kamulu, ma ka 'afitai fua mulu ka ru 'i maa. ");
INSERT INTO far_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ma kera kai takalongainia fere kamulu ma na wane ki tafau 'i laona. Ma ta te gwa fau boroi si tio na ana kula ne kera tio ana 'i nao. Kera ka falia fere kamulu, sulia nao mulu si saitamana kada God leka mai fuana famaurilamulu.” ");
INSERT INTO far_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kada sa Jesus nia ru kau laona na Beu Abu God, nia ka taria na wane ne kera 'oifoli ki. ");
INSERT INTO far_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ma nia ka fata 'uri fuada, “Ana kekedee 'ua mai laona Kekedee Abu, God nia fata 'uri, ‘Na Beu nau, na beu ni foa.’ Boroi ma kamulu abulotainia ka alua lalau kula fuana belilana ru wane ki.” ");
INSERT INTO far_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma ana maedangi ki tafau, sa Jesus nia famanata 'i laona Beu Abu God. Ma na fataabu baita ki, ma wane famanata ana taki ki, ma tani fanaonao ana Jiu ki, kera sasi 'uria saungilana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Boroi ma kera ka nao si saitamana ililana ta ru, sulia wane ki kera to fainia sulia dangi ki fuana rongolana famanatalae nia. ");
INSERT INTO far_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ana te maedangi, sa Jesus nia famanata wane ki 'i laona Beu Abu God. Ma nia ka 'ainitalo laugo ana Farongoe Lea. Ma ana kada nai, na fataabu baita ki, ma wane famanata ana taki ki, ma tani fanaonao laugo, kera leka mai siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ma kera ka ledi 'uri ana, “Sa ti ne saea 'oe taria wane ne ki fasia laona Beu Abu? Ma sa ti ne kwatea nikilalae fua 'oko sasia ana ru ne ki?” ");
INSERT INTO far_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sui sa Jesus ka fata 'uri fuada, “Iu, nau ku ledi kamulu basi 'uria te ru. ");
INSERT INTO far_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Iu, kamulu saea basi fuaku, na nikilalae sa Jon to ana fua siuabulae, nia safali mai fasia 'i fai? Nia safali mai ana God, naoma nia safali mai ana na wane ki go?” ");
INSERT INTO far_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ma kera ka safali olisusue 'i safitada kwailiu kera ka 'uri, “Te ne kulu kai saea? Dia kulu olisia ma kulu ka 'uri, ‘Fasia mai God,’ nia kai fata 'uri, ‘Ma 'uta mone ne nao kamulu si famamana sa Jon?’ ");
INSERT INTO far_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ma nao nia si lea laugo fua kulu ka fata 'uri, ‘Nia safali go mai ana na wane ki,’ sulia na wane ki kera kai 'ui fau kulu, ma kera ka saungi kulu, sulia kera famamana sa Jon nia ta profet.” ");
INSERT INTO far_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","'Urinai, kera ka olisia sa Jesus ma kera ka 'uri, “Kalu ulafusia go.” ");
INSERT INTO far_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ma sa Jesus ka fata 'uri lau fuada, “Nau boroi nao si farongo kamulu go ana na nikilalae ti ne nau ku sasia ana ru ne ki.” ");
INSERT INTO far_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","'I burina, sa Jesus ka farongo kera laugo ana te tarifulae ka 'uri, “Te kada, te wane nia fasia te oole grep, ma nia ka alua tani wane rao kera ka ada sulia oole nai. Ma wane baita ana oole ne ka leka ana te fere tau, ma nao si oli 'ali'ali mai. ");
INSERT INTO far_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Leleka ka dao na ana kada ne oole nai maua, wane baita nai ka kwatea te wane ni rao nia, fua ka ngalia mai tani fue grep ana 'ai ne nia fasia laona oole nai. Boroi ma kada wane ni rao nai nia dao laona oole nai, na wane rao ne ada sulia oole nai, kera ka kumua, sui kera ka olitai 'o'oni ana siana wane baita nia. ");
INSERT INTO far_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ma na wane baita nai ka kwatea lau ruana wane ni rao. Boroi ma wane rao ne ada sulia oole nai, kera ka kwaea laugo, ma kera ka fata ta'a na ana, ma kera ka olitai 'o'oni laugo ana. ");
INSERT INTO far_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","'Urinai, wane baita nai ka kwatea lau oluna wane rao nia, ma kera ka kwae maala laugo ana, ma kera ka taria fasia kula nai. ");
INSERT INTO far_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","'I burina, na wane baita nai ka manata 'uri, ‘Te lau ne nau kai sasia? Nau kwatea na 'aku na welewane nau ne, nau ku kwaimani 'asiana ana. Ma alamia nia ne wane rao ne ada sulia oole kai manata baita ana.’ ");
INSERT INTO far_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Kada wane ne kera rao ana oole nai, kera ada to'ona na wane nai, kera ka fata fuada kwailiu ma kera ka 'uri, ‘Nia na ne na wele na wane be nia too ana na oole. Kulu saungia ka mae fua kulu ka ngalia 'akulu na oole ne fuaka.’ ");
INSERT INTO far_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'Urinai go kera ka tara wane nai 'i maa fasia laona oole be, ma kera saungia ka mae na.” Ma sa Jesus ka ledida ka 'uri, ");
INSERT INTO far_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","“Te ne na wane ne nia too ana na oole nai kai sasia? Nia kai dao mai, ka saungia na wane nai ki. Sui nia ka kwatea na oole nia fuana wane 'e'ete ki.” Kada wane ki kera rongoa na faoraie ne sa Jesus, kera ka fata 'uri, “Nao 'asiana, nia 'afitai ka 'urinai!” ");
INSERT INTO far_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sui sa Jesus ka ada nikila fuada, ka fata 'uri, “Dia nao nia si 'urinai, te ne fadalana faoraie be laona Kekedee Abu be nia fata 'uri, ‘Na fau ne na wane saungai lume ki kera noni'ela ana, nia ne na fau talingai ka liufia na fau ki tafau ana 'odoe.’ ");
INSERT INTO far_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Ma dia sa ti ne nia lakwadora fafona fau nai, nia kai mangisi. Ma dia sa ti ne fau nai ka 'asia fafia, na nonina ka meme tafau na.” ");
INSERT INTO far_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ana kada nai, na fataabu baita ki fainia na wane famanata ana taki ki, kera fi ada saitamana faoraie sa Jesus nia faorai suli kera, ma kera dori daua ana kada nai. Boroi ma kera mau laugo 'ada ana wane ki. ");
INSERT INTO far_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ma na fanaonao ki kera ka sasi 'uria daolae to'ona ta kada lea fuana daulana sa Jesus. Ma kera ka folia tani wane fua kera ka suke ana ledilana sa Jesus. Sulia kera doria kera fai fafia ana ta ru ne nao si 'o'olo, fua ka bobola fainia kwatelana kau fuana gwaungai 'i Rom ne ada sulia 'i Jiudea. ");
INSERT INTO far_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kera dao siana, ma kera ka fata 'uri, “Wane Famanata 'ae, kalu saitamana 'oe famanata, ma 'oe saea na ru mamana ki. Ma 'oe si 'ado go fainia ta wane ana te ne kera manata sulia. 'Oe famanata ga 'amu sulia mamanae ma kwaidoria God fuana wane ki. ");
INSERT INTO far_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Saea mai fua malu, 'Uri ma nia bobola ga 'ana fua kulu ka kwatea malefo ana takisi fuana kingi baita 'i Rom, naoma 'e nao?” ");
INSERT INTO far_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ma sa Jesus ka ada saitamana na sukee kera, ma nia ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Fatainia basi mai te seleni fuaku.” Ma kada kera ngalia mai te seleni fuana, nia ledida ka 'uri, “Na nununa sa ti ne 'i fafona seleni ne? Ma na satana sa ti ne?” Ma kera olisia kera ka 'uri, “Na kingi Rom.” ");
INSERT INTO far_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ma sa Jesus ka fata 'uri fuada, “Dia 'urinai, kamulu ka kwatea fua kingi baita 'i Rom na ru nia ki, ma mulu kwatea laugo ru God ki fua God.” ");
INSERT INTO far_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ma kera ka to aroaro, sulia kera kwele 'asiana ana olisilae sa Jesus. Ma kera nao si bobola na fuana ne kera ka dao to'ona ta sukee lau fuana sa Jesus 'i maana wane ki. ");
INSERT INTO far_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sui, tani Sadusi kera leka mai siana sa Jesus. Na Sadusi ki kera saea ne na wane ki nao si tatae lau fasia na maea. Ma kera ledi 'uri ana sa Jesus, ");
INSERT INTO far_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Wane Famanata 'ae, sa Moses nia kedea na taki fuaka ka alangai 'uri, ‘Dia ta wane nia mae, ma na 'afe nia ka mauri 'ua, boroi ma nao nia si to ana ta wele, na wanefuta nia ka adea lau na gwa 'oru nai, fua keroa to ana ta wele fua ka talana na wane be nia mae.’ ");
INSERT INTO far_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Iu ma, ana te kada, fiu waisasina ki kera to. Ma na wane 'i nao ka adea ta keni, ma nao si alua go ta wele, ma wane nai ka mae na ana. ");
INSERT INTO far_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","“Ma na ruana wane ka adea lau na gwa 'oru nai, ma nia ka mae laugo. ");
INSERT INTO far_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Sui oluna wane ka 'urinai laugo. Ma ka 'urinai laugo fuana ai burina ki tafau. Na fiu waisasina nai ki tafau go, kera adea keni nai, ma kera nao si to go ana ta wele, ma kera ka mae tafau na. ");
INSERT INTO far_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma 'isilana, keni nai ka mae laugo. ");
INSERT INTO far_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","'Uri ma, ana maedangi ne God kai taea wane mae ki tafau fasia maea, sa ti ada ne na 'afe nia? Sulia na fiu waisasina nai ki tafau go be kera adea keni nai.” ");
INSERT INTO far_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ma sa Jesus nia olisida ka 'uri, “Kada ne, na wane ki ma na keni ki, kera arai ma kera ka 'afe. ");
INSERT INTO far_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Boroi ma ana kada ne nia mai 'ua, na wane ki ma na keni ki ne kera bobola fainia na tataelae fasia na maea, ma kera ka to na ana na mauri firi 'i langi, kera nao si arai ma kera si 'afe na, ");
INSERT INTO far_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","sulia kera dia na 'ada na 'ainsel ki, ma kera nao si mae na. Kera na wele God ki na, sulia kera tatae na fasia na maea. ");
INSERT INTO far_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“'Urinai, ma na kekedee sa Moses nia famadakwa na fuaka ne na wane mae ki, kera kai mauri lau. Sulia kada be God nia fatainia fuana sa Moses ana ere be meafia 'ai tu'u be, sa Moses nia saea God ana, ‘God sa Abraham, God sa Aesak, ma God sa Jakob.’ ");
INSERT INTO far_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Na fadalana 'uri: Tani wane ne kera mae na, kera fosia ga 'ada God, sulia kera mauri na fainia.” ");
INSERT INTO far_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ma tani wane ada, wane famanata ana taki ki, kera fata 'uri, “Wane Famanata 'ae, na olisilae 'oe nia lea 'asiana!” ");
INSERT INTO far_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma kera ka mau na fua ledilana lau. ");
INSERT INTO far_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sui sa Jesus ka ledi 'uri ada, “Nia 'uta, ne kera saea na Christ ne wane ana na kwalafa sa Deved? ");
INSERT INTO far_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Sa Deved be fata 'uri ana laona Kekedee Psalm ki, ‘God nia fata 'uri fuana 'Aofia nau: 'Oe gouru 'i bali 'o'olo aku, ma 'oe gwaungai fai nau, ");
INSERT INTO far_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","makwalia kada nau kai alua malimae 'oe ki farana gwaungaie 'oe.’ ");
INSERT INTO far_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Sa Deved 'ana talana ne nia saea na Christ ana na ‘'Aofia.’ Nia ne, na Christ nia nao lau Wele ana kwalafa sa Deved ga 'ana. Nia 'Aofia nia laugo.” ");
INSERT INTO far_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kada wane 'oro ki kera fafurongoa, sa Jesus ka fata 'uri fuana fafurongo nia ki, ");
INSERT INTO far_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Mulu madafi kamulu fasia na wane famanata ana taki sa Moses ki, sulia kera doria leka liulae fainia maku falu gwala ki. Ma kera ka doria laugo fua wane ki kera ka fa'initoda, ma ka fata lea fuada 'i maana usie ki. Ma kera ka doria gourue 'i nao ana kula 'initoa ni gourue ki laona beu fuana folae ki, ma ana kula lea ki kada ana fafanga ki. ");
INSERT INTO far_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Sui boroi 'ana, wane ne ki kera belia na lume ma na ru gwa 'oru ki to ana. Ma kera ka foa gwala, fuana wane ki ka fata lea sulida. Iu, na wane famanata ana taki sa Moses ki, kwaekwaee kera kai ta'a 'asiana fuada!” ");
INSERT INTO far_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kada sa Jesus nia to 'ua laona Beu Abu God, nia ka adaada, ma ka ada to'ona wane todaru ki kera leka mai fuana kwate malefoe laona na kufi ru fuana alu malefolae. ");
INSERT INTO far_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ma nia ka ada to'ona laugo te gwa 'oru ne nia siofa 'asiana. Nia leka mai, ma ka kwatea ro ngingisi malefo tu'u ki. ");
INSERT INTO far_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ma sa Jesus ka fata 'uri, “Ru mamana nau ku saea fua mulu, na kwatea ne gwa 'oru siofa ne nia kwatea, nia baita ka liufia wane ki tafau ne kera kwate malefo baita ki. ");
INSERT INTO far_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Sulia wane todaru ki, kera kwatea ga 'ada ka bali tu'u ana toorue kera ki. Boroi ma gwa 'oru siofa ne, nia kwate tafau na ana ru ki ne nia to ana fuana tolana.” ");
INSERT INTO far_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ma tani fafurongo ana sa Jesus, kera ka tangoa na Beu Abu God, sulia ne adalae to'ona nia kwanga lea 'asiana ana gwa fau lea ne kera laungia ana ki ma ana kwatea ki laugo ne kera kwatea fuana God. Sui sa Jesus ka fata 'uri fuada, ");
INSERT INTO far_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ru ne ki tafau ne mulu suada na, na maedangi nia kai dao mai ne nao ta gwa fau si tio 'i fulina, boroi ma kera tafau kera kai takalo 'i ano!” ");
INSERT INTO far_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ma kera ka ledi kera ka 'uri, “Wane Famanata 'ae, angita ne ru nai ki kai dao? Ma te ne kai fuli fua ka fatainia kada fuana ru ne ki tafau ka fuli ma ka dao ana?” ");
INSERT INTO far_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ma sa Jesus nia olisida ka 'uri, “Kamulu kai adaada lea, ma nao mulu si alamatainia ta wane ka talai garo amulu. Sulia ne wane 'oro ki kera kai dao mai ana sataku, ma kera kai fata 'uri, ‘Nau na ne na Christ!’ Ma kera kai fata laugo 'uri, ‘Na kada 'olea nia dao na!’ Nao mulu si leka sulida. ");
INSERT INTO far_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ma nao mulu si mau ana kada mulu rongoa na firue ki, ma na faoraie sulia na firue ki, sulia ru nai ki kai fuli basi 'i nao. Sui boroi 'ana ru nai ki ka fuli, na 'isilana kada nao si karangi 'ua.” ");
INSERT INTO far_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Sui sa Jesus ka fata lau fuana fafurongo nia ki ka 'uri, “Na mae fere ki kera kai fualida kwailiu, ma na 'initoe ki kera kai fualida kwailiu. ");
INSERT INTO far_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ma na anuanu baita ki kai dao, ma na uni fioloe ki, ma na mataie baita ki kai liu ana fere ki tafau, ma ru baita 'e'ete fuana maungilana ki, ma na maetoto kai sakatafa mai fasia lofana salo. ");
INSERT INTO far_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ma suifatai ru nai ki ka fi fuli, kera kai fulia ru ta'a ki amulu, sulia mulu rosuli nau. Kera kai kani kamu, ma kera kai fanonifi kamulu, ma kera kai ngali kamulu laona beu fuana folae ki fuana ketolamulu, ma kera kai alu kamulu 'i laona na beu ni kanie, ma kera kai tara kamulu siana wane fanaonao ma na kingi kera ki fuana ketolamulu. ");
INSERT INTO far_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ka 'urinai ma na kada ne lea na fua mulu fuana faorailae sulia na Farongoe Lea God nai. ");
INSERT INTO far_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ma mulu si manata 'abero lau 'uria te ne mulu olisida ana. ");
INSERT INTO far_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Sulia nau kai kwate tafau na fua mulu na faoraie ana na liotoe, ma nao ta malimae amulu ne kai fata olisi kamulu, naoma ka fata aefara ru ne mulu saea ki. ");
INSERT INTO far_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ma na maa kamulu ki, ma gaa kamulu ki, ma sasimulu ki, ma wanefuta kamulu ki, ma na wane kwaimani kamu ki, kera kai kwate kamu fuana fanaonao ki. Ma tani wane amulu kera kai saungida. ");
INSERT INTO far_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Na wane ki tafau kera kai sulangai kamu osingaku. ");
INSERT INTO far_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ka 'urinai boroi 'ana, 'afitai ta te ifu tu'u ana gwaumulu ka naoana. ");
INSERT INTO far_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Mulu uu ngasi ana famamanae kamulu ki, ma mulu kai mauri firi.” ");
INSERT INTO far_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ma sa Jesus ka fata lau 'uri fuada, “Kada mulu ada to'ona na wane ni omee ki, kera alasia 'i Jerusalem, mulu kai saitamana kera kai takalongainia na fere baita ne. ");
INSERT INTO far_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ma ana kada nai, wane ne kera to 'i Jiudea, kera kai tafi tafau 'uria gwauna fa uo ki. Ma wane ne kera to laona mae fere baita ne, kera kai tafi fasia. Ma na wane ne kera to kalikalia mai kera nao si oli lau mai 'uria fere baita ne. ");
INSERT INTO far_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Sulia kada ne, kada fua kwaiketoilae, fua ne te ki be kera kedea sulia 'i laona Kekedee Abu kai dao mamana na mai. ");
INSERT INTO far_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ma ana fa dangi nai ki, nia kai ta'a fuana keni ki ne kera iana, sulia ne nia 'afitai fuada ne kera ka tafi, ma ka ta'a laugo fuana 'afe ki ne kera too ana na wele tu'u ki. Ma na kwaimanatailae baita kai dao to'ona wane ana fere ne, sulia God kai kwaea na wane 'i senai ki. ");
INSERT INTO far_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tani wane kera kai saungida ana naife ni sauwanee. Ma tani wane kera kai dauda, ma kera kani fafida, ma kera ka ngalida 'uria fere 'e'ete ki. Ma wane ne nao lau Jiu ki, kera falia fere baita 'i Jerusalem leka ka dao ana 'isilana kada kera ki. ");
INSERT INTO far_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ru 'e'ete ki kai fuli fuana sato, ma na madame, ma na bubulu ki. Ma wane ana na mae fere baita ki tafau 'i laona molagali, kera kai fitala, ma kera ka mau ana kurulana ma na ralana asi, ma fa nanafo ki. ");
INSERT INTO far_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ma na wane ki kera kai maebuatamarakwa sulia kera mau 'asiana, kada kera makwalia na daolana mai ru nai fafia molagali tafau. Sulia na ru 'i lofana salo ki, kera kai leka garo. ");
INSERT INTO far_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","'Urinai, nau na Wele nia Wane, ku fi dao fatai mai. Nau kai dao mai fainia na nikilalae baita, ma na ngwasinasinae baita 'i fafona na gwa salo ki. ");
INSERT INTO far_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ma kada na ru nai ki nia safali kai fuli, mulu uu, ma mulu ada 'alaa, sulia kada God kai famauri kamulu, nia dao karangi na mai.” ");
INSERT INTO far_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Sui sa Jesus ka fata sulia na tarifulae fuada ka 'uri, “Mulu manata basi sulia 'ai kera saea ana figi fainia 'ai ki tafau. ");
INSERT INTO far_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kada mulu ada to'ona na ulina nia ngosa, mulu ka saitamana na kada fuana uni 'ako'akoe nia karangi na. ");
INSERT INTO far_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ka 'urinai laugo, ana kada mulu ada to'ona ru nai ki nia fuli, mulu ka saitamana na kada fua God kai gwaungai, nia dao karangi na. ");
INSERT INTO far_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ru mamana 'asiana nau ku saea fua mulu, ru nai ki tafau kai dao mai suifatai wane ne kera mauri ana kada nai, kera fi mae. ");
INSERT INTO far_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Na ru ki tafau mai langi ma laona molagali kera kai sui. Boroi ma na fatalaku go ne toto nao si sui. ");
INSERT INTO far_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mulu kai adaada lea. Nao mulu si ro ana fangalae baita ki, ma na ku bubulolae ki, ma na manata 'aberolae ki ana na maurie seki laona molagali. Dia mulu sasi 'urinai, fa dangi nai ka dao fatona kamulu dia ta maniito. ");
INSERT INTO far_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Sulia maedangi nai kai dao mai fafia na wane ki, ana kula ki tafau 'i laona molagali ne. ");
INSERT INTO far_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mulu kai adaada lea, ma mulu kai foa ana kada ki tafau, fua mulu kai too ana na nikilalae fuana maurie 'i laona ru nai ki ne kai fuli. Ma fua mulu si 'eke lau kada mulu kai uu 'i maaku, na Wele nia Wane.” ");
INSERT INTO far_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ana maedangi ki tafau, sa Jesus nia famanata wane ki laona Beu Abu God. Ma saulafi ki nia leka ka maleu gwauna fa uo 'i Olif. ");
INSERT INTO far_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ma na 'ofodangi makalokaloa ki tafau, wane 'oro ki kera ka leka mai laona Beu Abu God fuana rongolana fatalana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Na kada fua Fafanga ana Daofa Liue Jiu ki, nia karangi na. Ana fafanga ne, kera saitamana 'anilana beret ne nao ta isi ana. ");
INSERT INTO far_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ma na fataabu baita ki, ma na wane famanata ana taki ki, kera ka manata 'uria saungi agwalae ana sa Jesus, sulia kera maungia na wane ki. ");
INSERT INTO far_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ma sa Saetan ka dao mai 'i laona manatana sa Jiudas Iskariot, ta wane ana akwala ma ro fafurongo be sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Nia ne sa Jiudas ka leka kau siana fataabu baita ki, ma na fanaonao ki ana wane ne kera ada sulia Beu Abu God, ma ka saea fuada nia saitamana kai kwai'adomi na fuana daulana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ma kera ka eele 'asiana, ma kera kai kwate malefo fuana. ");
INSERT INTO far_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Sa Jiudas ka alafafia, ma ka safali ada na 'uria ta kada ne nao ta wane si to fainia sa Jesus, fua ka kwatelana sa Jesus fuada. ");
INSERT INTO far_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","'Urinai, na maedangi nai na wane Jiu ki fuana 'anilana beret ne nao ta isi 'i laona, nia dao na. Maedangi nai, kera saungia laugo kaelana sipsip ki, ma kera ka sasi akau ana fanga fuana Fafanga ana Daofa Liue. ");
INSERT INTO far_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ma sa Jesus ka kwatea sa Pita fainia sa Jon ka fata 'uri fuadaro, “Kamoro leka sasi akau ana fanga fuaka fua 'anilana na Fafanga ana Daofa Liue.” ");
INSERT INTO far_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Keroa ka ledi 'uri ana sa Jesus, “'I fai ne 'oe doria karo kai sasi akau ana kula fuana fafanga na?” ");
INSERT INTO far_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Sa Jesus olisi keroa ka fata 'uri, “Kada kamoro ru laona 'i Jerusalem, moro kai dao to'ona te wane nia ngalia na fa kafo. Moro leka sulia 'uria lume ne nia leka 'uria. ");
INSERT INTO far_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Moro fata 'uri fuana wane ne lume nia, ‘Na Wane Famanata nia fata mai 'uri fuamu: 'I fai ne mae lume fuana nau kai 'ania na Fafanga ana Daofa Liue fainia fafurongo nau ki?’ ");
INSERT INTO far_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ma na wane nai kai fatainia mae lume baita ana lume nai ne 'e to 'i langi, kula ne ru ki kera sasi akau na ana, ma 'i senai kamoro kai sasi akau ana fanga ki.” ");
INSERT INTO far_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","'Urinai, keroa ka leka na, ma keroa ka dao to'ona ru ki tafau dia be sa Jesus nia saea fuadaro. Ma keroa ka sasi akau na ana fanga 'i senai. ");
INSERT INTO far_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nia dao na ana kada fuana 'anilana na Fafanga ana Daofa Liue, ma sa Jesus fainia na lifurongo nia ki, kera ka to na ana kula ni fangalae. ");
INSERT INTO far_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ma nia ka fata 'uri fuada, “Nau ku doria 'asiana 'anilana na Fafanga ana Daofa Liue fai kamulu, sui nau ku fi nonifi 'aku. ");
INSERT INTO far_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ma nau ku saea fua mulu, nia 'afitai nau ku 'ania lau na Fafanga ana Daofa Liue fai kamulu, leka ka dao ana kada ana famamanalana ana kada God kai gwaungai.” ");
INSERT INTO far_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Sui sa Jesus ka ngalia na titiu, ma ka tangoa God. Sui nia ka fata 'uri fuada, “Mulu ngalia, ma mulu ka 'ado ana 'i safitamulu. ");
INSERT INTO far_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nau ku saea fua mulu, safali 'i ta'ena ka oli 'alaa, nau si kufia lau na waeni ne, leleka dao ana kada 'Initoe God ka dao mai.” ");
INSERT INTO far_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Sui sa Jesus ka ngalia na beret, ma ka tangoa God, sui nia ka ngiia, ma ka kwatea fuada. Ma ka fata 'uri, “Na noniku ne nau ku kwate 'uria kamulu ne. Mulu kai 'ania fuana manatalae to'oku.” ");
INSERT INTO far_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","'I burina na fangalae, nia ngalia laugo na titiu, ka fata 'uri, “Nia na ne 'abuku ne nia igwa fua mulu. Ana 'abuku, God ka fangasia na alangaie falu. ");
INSERT INTO far_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ada to'ona basi! Na wane ne kai kwate nau fuana malimae nau ki, nia to ga 'ana fai nau 'i seki ana kula ni fanga. ");
INSERT INTO far_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Sulia nau, na Wele nia Wane, nau kai mae dia God nia doria fuaku. Boroi ma nia ta'a 'asiana fuana wane ne nia kwate nau fuana malimae nau ki!” ");
INSERT INTO far_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ma kera ka safali fuana ledi kwailiulae 'i safitada 'uria sa ti ada ne kai sasia ru nai. ");
INSERT INTO far_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ma na fafurongo nia ki kera ka olisusu 'i safitada kwailiu fuana sa ti ada ne nia talingai ka tasa. ");
INSERT INTO far_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ma sa Jesus ka fata 'uri fuada, “Kamulu saitamana na wane gwaungai ki ne kera gwaungai fuana wane nao lau Jiu ki, kera to ana nikilalae, ma kera saitamana 'asiana ana usungailana wane fuana sasilana ru kera doria ki. Ma kera ka doria na wane ki ka saeda ana na wane talingai ki. ");
INSERT INTO far_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sui boroi 'ana, nao mulu si sasi lau 'urinai 'i safitamulu. Ma sa ti amulu ne nia na wane ni kwaitalai, nia na wane marabibi. Ma na wane ne nia talingai, nia kai dia na wane ni rao. ");
INSERT INTO far_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","'Uri ma sa ti ne kera saea ne nia wane talingai, na wane ne nia to go ana fuana fangalae, naoma na wane ne nia rao fuana? Na wane ne nia to go ana fua fangalae ne nia talingai. Boroi ma nau ku to 'i safitamulu dia na wane ne nia rao. ");
INSERT INTO far_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Mulu to na fai nau 'i laona ilitoe nau ki tafau. ");
INSERT INTO far_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Dia na Maa nau nia kwatea tafau na gwaungailae fuaku, nau boroi nau ku kwatea laugo na gwaungailae fua mulu, ");
INSERT INTO far_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","fua mulu ka fanga fai nau, ma mulu ka ku fai nau 'i laona 'Initoe nau. Ma mulu kai gouru ana kula ni gourue ana na gwaungaie ki, ma mulu kai gwaungai ana na akwala ma ro fui wane be 'i Israel ki.” ");
INSERT INTO far_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Sui sa Jesus ka fata 'uri fuana sa Pita, “Simon Pita 'ae! 'Oe 'e fafurongo basi. God nia alamatainia na sa Saetan, fua kai sasi 'uria kai takalongai kamulu tafau fasi nau, dia wane ne nia rao 'i laona oole fuana efolana mege ru lea ki fasia na tataeru ta'a ki. ");
INSERT INTO far_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ka 'urinai boroi ana Simon, nau ku foa fuamu, fua ne nao 'oe si luka faburi ana fitoe 'oe. Ma ana ta kada ne 'oe 'e manata oli lau mai 'uri nau, 'oko fanikila na wane ne kera famamana nau ki.” ");
INSERT INTO far_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ma sa Pita nia olisia ka 'uri, “'Aofia 'ae, nau ku kwaimakwali ga 'aku fuana lekalae fai 'oe 'i laona beu ni kanie ma fuana maelae fai 'oe!” ");
INSERT INTO far_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ma sa Jesus nia olisia ka 'uri, “Pita 'ae, nau ku saea fuamu, 'i ta'ena laona fa rodo ne, 'i naona na karai kai angi, 'oe olu fa tofe laku ne 'oe ulafusi nau.” ");
INSERT INTO far_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Sui sa Jesus ka ledi 'uri ana fafurongo nia ki, “'Uri ma kada be nau ku odu kamulu kau, ma nao mulu si to ana ta malefo, naoma ta ngwai, naoma ta tae butu, 'uri ma kamulu olikokoru ana ta ru be?” Ma kera olisia kera ka 'uri, “Nao go.” ");
INSERT INTO far_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ma sa Jesus ka fata 'uri, “Boroi ma ana kada ne, dia sa ti ne nia to ana ta malefo naoma ta ngwai, nia ka ngalia 'ana. Ma sa ti ne nao si to ana ta naife ni sauwanee, nia kai foli ana na maku lola nia, ma ka folia ta naife 'ana. ");
INSERT INTO far_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nau ku saea ru ne fua mulu, sulia ne Kekedee Abu be fata suli nau 'uri, ‘Kera oku fainia na wane ta'a ki.’ Ru nai kai fuli na fuaku, sulia na kekedee ki tafau go suli nau kai fuli mamana na.” ");
INSERT INTO far_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ma na fafurongo nia ki kera ka fata 'uri, “'Aofia 'ae, ada to'ona basi, kulu to na ana ro naife ni sauwanee 'i seki!” Ma nia ka olisida ka 'uri, “Nia lea na.” ");
INSERT INTO far_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sa Jesus fainia na fafurongo nia ki, kera fasia na fere baita nai, ma kera ka leka na 'uria fa uo kera saea ana 'i Olif, dia be kera 'idufa leka ana. ");
INSERT INTO far_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma kada kera dao ana kula nai, nia ka fata 'uri fuada, “Mulu kai foa, fasia na ilitoe ki ka liufi kamulu.” ");
INSERT INTO far_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Sui sa Jesus nia leka tu'u lau kau fasida ka bobola fainia kula ne 'uilae ana na fau nia dao ana, ma ka boruru 'i ano, ma ka foa. ");
INSERT INTO far_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nia ka fata 'uri, “Maasi 'ae, dia 'oe nonimabe, 'oe lafua 'amu na nonifie ne fasi nau. Sui boroi 'ana, nao lau na kwaidorie nau, boroi ma sulia kwaidorie 'oe lalau.” ");
INSERT INTO far_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ma te 'ainsel fasia 'i langi nia dao mai, ma ka fanikila nia. ");
INSERT INTO far_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ma kada nai, manatana nia fii 'asiana, nia ka foa nikila lau. Ma na 'i'ida ne 'i nonina 'e udu ma ka 'asia 'i ano dia ta guira 'abu. ");
INSERT INTO far_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ma kada nia tatae fasia na folae nia ka oli siana fafurongo nia ki. Kera maleu 'ada, sulia kera ngwatautau 'asiana sulia kwaimanataie. ");
INSERT INTO far_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ma sa Jesus ka fata 'uri fuada, “'Uta ne kamulu maleu ro? Mulu tatae, ma mulu ka foa, fasia na ilitoe ka liufi kamulu.” ");
INSERT INTO far_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kada sa Jesus nia fata 'ua ga 'ana faida, te okue baita kera dao mai. Ma te wane ana fafurongo nia ki, ne satana sa Jiudas, nia talaida mai. Ma nia ka dao mai siana sa Jesus, ma ka nono'ia. ");
INSERT INTO far_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Boroi ma sa Jesus ka fata 'uri fuana, “Jiudas 'ae, 'oe kwate nau, na Wele nia Wane, fuana malimae nau ana nono'ilaku!” ");
INSERT INTO far_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ma kada fafurongo ki kera to fainia sa Jesus, kera ka ada to'ona ru nai, kera ka fata 'uri, “'Aofia 'ae! 'Uri ma kalu kai kumuda ana naife ni sauwanee ne kalu ki?” ");
INSERT INTO far_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ma te wane ada, ka kwaea te wane ni rao na 'inita fataabu, ma nia ka kwae musia na bali alinga 'o'olo ana. ");
INSERT INTO far_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Go sa Jesus ka fata 'uri, “Mango na!” Ma nia ka samo to'ona na alingana na wane nai, ma ka gura na. ");
INSERT INTO far_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sui sa Jesus ka fata fuana fataabu baita ki, ma wane ne kera folo 'usia na Beu Abu God, ma wane fanaonao ki ne kera leka mai senai fuana daulana, nia ka 'uri, “'Uri ma, nau ta wane beli ne, fua mulu ka dao mai 'uri nau fainia naife ki ma subi ki? ");
INSERT INTO far_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nau ku to ga 'aku siamulu 'i laona Beu Abu God sulia maedangi 'oro ki, boroi ma nao mulu si sasi go 'uria daulaku. Boroi ma kada kamulu na ne, fua mulu ka rao na ana na nikilae sa Saetan, na wane ne gwaungai ana maerodo.” ");
INSERT INTO far_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sui kera ka daua na sa Jesus, ma kera ka talaia na 'i laona lume na 'inita fataabu. Ma sa Pita ka leka daudau na mai burida ana ta kada taale ne tau laugo fasida. ");
INSERT INTO far_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ma te ere kera ukunia 'i tofungana na labate ana lume, ma sa Pita ka to na fainia na wane ne kera gouru kalia na ere nai. ");
INSERT INTO far_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ma kada te wele keni sari ni rao, nia ada to'ona sa Pita ne gouru 'i senai karangia na ere, nia ka ada filoa ma ka fata 'uri, “Na wane ne nia to laugo fainia sa Jesus.” ");
INSERT INTO far_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Boroi ma sa Pita 'e tofe ka 'uri, “Keni ne 'ae, nau kusi saitamana na wane na!” ");
INSERT INTO far_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma nao si tau laugo 'i burina, te wane ka ada to'ona sa Pita ma ka fata 'uri, “'Oe ta wane laugo ada ne!” Boroi ma sa Pita nia olisia ka 'uri, “Nau nao lau ta wane ada.” ");
INSERT INTO far_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma bolofainia ka kada tu'u lau 'i burina, te wane lau ka fata nikila ka 'uri, “Nia mamana. Na wane ne nia to laugo fainia sa Jesus, sulia nia laugo na wane fasia 'i Galili!” ");
INSERT INTO far_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Boroi ma sa Pita nia olisia ka 'uri, “Wala, nau ku ulafusia na ru ne 'oe fata sulia!” Ma kada nia fata go 'urinai, na karai ka angi na. ");
INSERT INTO far_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ma na 'Aofia ka abulo, ma ka ada 'o'olo kau fua sa Pita. Ma sa Pita ka manata to'ona faoraie be na 'Aofia nia saea fuana be 'uri, “'I naona karai ka angi, 'oe kai olu fa tofe nau ne 'oe ulafusi nau.” ");
INSERT INTO far_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ma sa Pita ka ru kau 'i maa, ma ka angi 'asiana. ");
INSERT INTO far_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma na wane ni omee ki ne kera folo kalia sa Jesus, kera 'onionga, ma kera ka kumua. ");
INSERT INTO far_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ma kera ka kani bokota maana, ma kera ka ledi 'uri ana, “'Oe saea basi sa ti ne kumuli 'oe?” ");
INSERT INTO far_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ma kera ka saea faoraie ta'a 'oro ki laugo ana. ");
INSERT INTO far_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ma 'ofodangi kada nia la na, wane fanaonao Jiu ki, ma na fataabu baita ki, ma na wane famanata ana taki ki, kera fata oku. Ma wane ni omee ki kera ka talaia mai sa Jesus fuada. ");
INSERT INTO far_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ma kera ka fata 'uri fuana, “'Oe saea fua malu. 'Uri ma 'oe na Christ, na wane ne God nia filia fuana famaurilamalu?” Ma nia olisida ka 'uri, “Dia nau ku saea fua mulu, nia 'afitai mulu ka famamana nau. ");
INSERT INTO far_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ma dia nau ku ledi kamulu 'uria ta ru, nia 'afitai mulu ka olisia. ");
INSERT INTO far_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Boroi ma nia safali ana kada ne ka oli 'alaa, nau, na Wele nia Wane, nau kai to 'i bali 'aba 'o'olo ana God ne nia nikila 'asiana, ma nau ku gwaungai fainia.” ");
INSERT INTO far_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ma kera tafau go kera ledia kera ka 'uri, “'Uri ma 'oe na ne na Wele God?” Ma nia olisida ka 'uri, “Nia na nai mulu tala saea.” ");
INSERT INTO far_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ma kera ka fata 'uri, “Nao kulu si doria lau ta wane ni fata famamana! Sulia kulu rongoa tafau na ana fatalana ne nia saea nia Wele God!” ");
INSERT INTO far_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ma na okue ana wane fanaonao senai ki, kera tatae, ma kera ka talaia sa Jesus siana sa Paelat fua ketolana. ");
INSERT INTO far_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ma kera ka safali fua fai fafilana ana ru garo ki, ma kera ka 'uri, “Kalu dao to'ona na wane ne nia fata alingana wane kalu ki. Ma ka saea fua kera nao si kwatea lau na malefo ana na takisi fua kingi baita 'i Rom, ma nia ka saea nia ne na Christ, na wane ne God nia filia fuana kingi.” ");
INSERT INTO far_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ma sa Paelat ka ledia ka 'uri, “'Uri ma 'oe ne kingi wane Jiu ki?” Ma sa Jesus ka olisia ka 'uri, “Nia na nena 'oe saea.” ");
INSERT INTO far_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Sui sa Paelat ka fata 'uri fuana fataabu baita ki, ma na okue nai, “Nau kusi dao go to'ona ta garoe ana wane ne fua saungilana.” ");
INSERT INTO far_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ma kera ka fata nikila ma ka 'uri, “Boroi ma laona bali lofaa 'i Jiudea tafau, nia kusu firue ana famanatae nia. Safali mai 'i Galili leka ka dao na 'i seki.” ");
INSERT INTO far_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ma kada sa Paelat nia rongoa ru nai, nia ka ledida ka 'uri, “'Uri ma na wane ne nia leka mai fasia 'i Galili ne?” ");
INSERT INTO far_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ma kada nia saitamana ne sa Jesus nia leka mai fasia na kula ne sa Herod nia gwaungai ana, nia ka kwatea sa Jesus siana sa Herod. Sulia sa Herod nia to laugo 'i Jerusalem ana kada nai. ");
INSERT INTO far_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ma kada sa Herod nia ada to'ona sa Jesus, nia ka eele 'asiana, sulia nia rongoa na faoraie sulia, ma ka kwaimakwali fua adalae to'ona ka tau na mai. Ma nia doria adalae to'ona sa Jesus fua sasilana ta fanadae. ");
INSERT INTO far_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Sa Herod nia ledia ru 'oro ki ana, boroi ma sa Jesus nao si olisia go ana ta ru. ");
INSERT INTO far_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ma fataabu baita ki, ma wane famanata ana taki ki, kera uu laugo 'i senai, ma kera ka fata ngangata fua kefusilana sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ma sa Herod fainia wane ni omee nia ki, kera ka 'onionga sa Jesus, ma kera ka fata ta'a ana. Ma kera ka faofia ana te maku gwala lea, ma kera ka oli lau fainia siana sa Paelat. ");
INSERT INTO far_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ma nia safali ana fa dangi nai, sa Herod ma sa Paelat keroa fi oku kwaimani. 'I nao, keroa ro malimae ki. ");
INSERT INTO far_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sa Paelat ka konia fataabu baita ki, ma wane fanaonao ki, ma wane ki. ");
INSERT INTO far_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ma ka fata 'uri fuada, “Kamulu kwatea mai wane ne siaku, mulu saea nia talai garo ana wane ki fasia na lekalae burina gwaungai 'i Rom. Ma ada basi, nau ku ledia 'i maamulu, ma nao nau si dao go to'ona ta garoe ana, fainia ru ne kamulu kefusia fainia ki. ");
INSERT INTO far_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ma sa Herod boroi si dao go to'ona ta garoe ana, nia ne nia ka olitainia laugo mai 'ana. Na wane ne nao si sasia go ta ru ne nia garo fua nia ka mae. ");
INSERT INTO far_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Nia ne, nau ku kwatea go kau fua kera kai kwaea. Sui nau ku kwatea ka leka na 'ana.” ");
INSERT INTO far_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Boroi ma kera tafau go ne kera akwa kera ka 'uri, “Mulu saungia wane ne ka mae! Ma mulu lugea lalau mai sa Barabas fua malu!” ");
INSERT INTO far_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Sa Barabas kera alua laona beu ni kanie, sulia nia etangia na firue baita 'i laona fere baita nai, ma nia na wane sauwanee. ");
INSERT INTO far_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Sa Paelat nia doria kai lugea sa Jesus, ma nia ka ledia lau na okue nai. ");
INSERT INTO far_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Boroi ma kera ka inau ana akwalae ma kera ka 'uri, “Mulu saungia ka mae! Mulu foto'ia ana na 'airarafolo!” ");
INSERT INTO far_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ma sa Paelat ka fata 'uri fuada ana oluna kada, “Ma ta garoe te ne nia sasia? Nao nau si dao go to'ona ta ru ne nia sasi fua nia kai mae. Nia ne nau kwatea kau fua kera kwaea, sui nau lugea, ma nia kai leka na 'ana.” ");
INSERT INTO far_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Boroi ma kera akwa ma kera ka inau na ana, ma kera ka suusuu fuana foto'ilana sa Jesus ana 'airarafolo. Ma na akwae ka liufia na. ");
INSERT INTO far_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ma sa Paelat ka kwatea na kwaekwaee ne kera suusuu fainia sulia na ganilae kera. ");
INSERT INTO far_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ma nia ka lugea sa Barabas na wane be kera doria, na wane be kera alua 'i laona beu ni kanie fuana safalilana na firue baita, ma sauwanee ki. Sui sa Paelat ka kwatea sa Jesus fuada, sulia na kwaidoria kera. ");
INSERT INTO far_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ma wane ni omee ki, kera ka talaia na sa Jesus fuana maelae. Ma kada kera leka kau, kera ka dao to'ona te wane ne satana sa Simon, fasia na fere 'i Saerin. Kera daua sa Simon kada nia leka mai ma ka ru laona fa labu 'i Jerusalem fasia te kula mai 'i maa. Ma kera ka alua na 'airarafolo 'i gwau 'abana, ma kera ka sumainia fua nia ka ngali buri sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ma te okue baita kera leka 'i burina. Ma tani keni laona okue nai kera omaee, ma kera ka angisia. ");
INSERT INTO far_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sa Jesus nia abulo fuada ma ka fata 'uri, “Keni 'i Jerusalem ki 'ae! Nao mulu si angi nau lau. Mulu angi kamulu talamulu, ma wele kamulu ki. ");
INSERT INTO far_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Sulia nia kai dao ana fa dangi ne wane ki kera fata 'uri, ‘'oilakie fua keni ne kera 'aba'ato ki, ma na keni ne nao kera si fafuta ki, ma kera nao si fasusu ki!’ ");
INSERT INTO far_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ma kada nai wane ki kera kai fata 'uri fuana fa uo ki, ‘Mulu 'asia mai fafi kalu.’ Ma kera ka fata 'uri fuana toloa ki, ‘Mulu ofo mai fafi kalu.’ ");
INSERT INTO far_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Sulia dia kera sasia ru nai ki aku, na wane ne nau ku 'o'olo, kera kai sasia ru ne nia ta'a 'asiana ana wane ne kera too ana na ta'alae ki.” ");
INSERT INTO far_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ma kera ka ngalia laugo ro folo beli ki fuana saungilada fai sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ma kada kera dao ana kula ne kera saea ana “Na kula ana lelete wane”, kera ka foto'ia sa Jesus ana na 'airarafolo. Ma ro folo beli be ki, kera foto'ida laugo ana ro 'airarafolo ki, te wane ana bali 'o'olo ana sa Jesus, ma ta ai ana bali mauli. ");
INSERT INTO far_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ma sa Jesus ka fata 'uri, “Maasi, 'oe manatalugeda, sulia kera ulafusia ru ne kera sasia.” Ma wane ni omee ki kera ka saketo ana na ru dia daisi fua kera ka dao to'ona sa ti ada ne kai ngalia maku sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Na wane ne kera uu 'i senai, kera ada to'ona, ma wane fanaonao ana Jiu ki, kera ka 'onionga ma kera ka 'uri, “Nia famauria wane 'e'ete ki. Dia nia na Christ, na wane ne God nia filia, nia bobola fua nia ka famauria nia talana.” ");
INSERT INTO far_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ma wane ni omee ki, kera ka 'onionga, ma kera ka leka kau siana, ma kera ka kwatea na waeni 'afae fuana. ");
INSERT INTO far_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ma kera ka fata 'uri, “Dia 'oe na kingi Jiu ki, 'oe famauri 'oe talamu!” ");
INSERT INTO far_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ma kera ka kedea na faoraie 'uri gwauna na 'airarafolo, “Nia na kingi Jiu ki.” ");
INSERT INTO far_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ma te wane ana ro wane be kera foto'ida fainia sa Jesus, nia ka fata buri tolingai ana ka 'uri, “'Uri ma 'oe ne na Christ? 'Oe famauri 'oe talamu ma karo laugo!” ");
INSERT INTO far_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Boroi ma na ruana wane ka balufia ka 'uri, “'Uri ma, 'oe si maungia go kwaekwaee God? Kulu bobola tafau go, sulia kera kwatea go te kwaekwaee fuaka. ");
INSERT INTO far_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ma koro ne, na kwaekwaee ne nia bobola ga 'ana, sulia koro ngalia na 'i maana ru ta'a ne koro sasini ki. Boroi ma nao nia si sasia go ta ru garo.” ");
INSERT INTO far_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ma nia ka fata 'uri, “Jesus 'ae, 'oe manata to'oku, kada 'oe kai oli mai ana 'Initoe 'oe.” ");
INSERT INTO far_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ma sa Jesus ka fata 'uri fuana, “Nau ku saea na ru mamana fuamu, 'i ta'ena 'oe kai to fai nau 'i langi.” ");
INSERT INTO far_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nia safali tofungana dangi, na sato ka rorodoa, ma bali lofaa nai tafau ka rorodoa, leka ka dao ana oluna kada sato saulafi. ");
INSERT INTO far_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ma na maku baita ne nia bokota na kula abu 'i laona Beu Abu God ka kakari ana ro bali ru ki. ");
INSERT INTO far_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ma sa Jesus ka akwa baita ka 'uri, “Maasi, nau ku kwatea na kau na mangoku fuamu.” Nia ka fata 'urinai ka sui go, nia ka mae na. ");
INSERT INTO far_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ma na fanaonao ana wane ni omee ki nia ada to'ona ru nai, ma nia ka tangoa God ka 'uri, “Nia mamana, nia na wane 'o'olo!” ");
INSERT INTO far_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ma kada na wane nai ki kera oku, ma kera bubungia, kera ada to'ona maelana sa Jesus ka sui, kera tafau oli na 'ada 'i fere kera ki. Ma kera ka fidalia maruruda fua fatailana na kwaimanataie kera ki. ");
INSERT INTO far_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ma na wane ki tafau ne kera saitamana sa Jesus, fainia na keni ne kera leka 'i burina fasia 'i Galili ki, kera uu tau ga 'ada, ma kera ka ada to'ona ru nai ki tafau. ");
INSERT INTO far_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ma te wane fasia 'i Arimetea laona bali lofaa 'i Jiudea, ne satana sa Josef, nia to laugo 'i senai. Ma nia na wane 'o'olo, ma na wane lea, ma nia ka kwaimakwali laugo fuana adalae to'ona ne God kai gwaungai ana wane nia ki. Ma sui boroi 'ana nia ta wane ana na fikute wane lokoeru Jiu ki, nia si ala go fafia ru ne kera saea, ma kera sasi ana sa Jesus ki. ");
INSERT INTO far_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nia ka leka siana sa Paelat, ma ka gani 'uria nonina sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ma nia ka lugea na nonina sa Jesus fasia na 'airarafolo, ma ka 'afua ana na 'aba maku kwao. Ma nia ka alua 'i laona faoda falu fuana faitolilae wane mae ki ne kera 'elia 'i laona fau baita. ");
INSERT INTO far_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma fa dangi fuana sasi akaulae fuana Sabat, nia karangi safali na. ");
INSERT INTO far_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Na keni ne kera leka mai burina sa Jesus fasia 'i Galili ki, kera leka laugo fainia sa Josef. Ma kera ka ada to'ona na faoda nai, ma kera ka ada to'ona na faitolilana sa Jesus 'i laona. ");
INSERT INTO far_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Sui kera ka oli 'i fere, ma kera ka sasi akau ana ngwaingwai ki, ma na ru moko lea ki fua ngwaingwailana nonina sa Jesus. Boroi ma ana Sabat, kera ka mamalo na, dia na taki nia saea. ");
INSERT INTO far_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ma ana Sande 'ofodangi makalokalo, keni be kera ngalia ngwaingwai moko lea ki ne kera sasi akau ana, ma kera ka leka na 'i maana faoda nai. ");
INSERT INTO far_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma kera ka ada to'ona faoda nai nia 'ifi na, sulia na aba fau nao si to na 'i maana na faoda nai. ");
INSERT INTO far_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ma kera ka ru kau, boroi ma kera nao si ada na to'ona nonina na 'Aofia sa Jesus. ");
INSERT INTO far_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ma kada kera manata ga 'ada 'ua sulia ru nai, ro 'ainsel ne keroa rufia maku ne ngwasinasina ki, keroa ka sakatafa mai, ma keroa ka uu sulida. ");
INSERT INTO far_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Keni nai ki kera ka mau 'asiana, ma kera ka gwautoli 'i ano. Boroi ma na ro wane nai ki, keroa fata 'uri fuada, “'Uta ne kamulu nani 'uria na wane ne nia mauri 'i laona kula fuana wane mae ki? ");
INSERT INTO far_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nao nia si to na 'i seki. Nia tatae na fasia maea. Kamulu manata to'ona basi ru be nia farongo kamulu tafau ana, kada be nia to 'ua fai kamulu 'i Galili. Nia fata 'uri, ");
INSERT INTO far_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Kera kai kwate nau, na Wele nia Wane, fuana wane ta'a ki, ma kera kai saungi nau ana na 'airarafolo, sui ana oluna maedangi, nau kai mauri lau.’” ");
INSERT INTO far_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Sui keni nai ki kera ka manata to'ona na fatalana. ");
INSERT INTO far_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ma kera ka oli na fasia na faoda, ma kera ka farongoa na akwala ma te lifurongo nia ki, ma tani wane fafurongo lau ne kera dao to'oda. ");
INSERT INTO far_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Keni ne kera farongoa lifurongo nia ki, ne ni Mary fasia 'i Magdala, ma ni Joana, ma ni Mary na gaa sa Jemes, ma tani keni lau. ");
INSERT INTO far_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Boroi ma lifurongo ki kera kwaisae na keni nai ki kera fata oewanea ga 'ada, ma kera nao si famamana go fatalada. ");
INSERT INTO far_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Boroi ma sa Pita nia tatae, ma ka lae 'ali'ali 'uria maana faoda. Ma nia 'agwaoro, ma ka ada to'ona go maku kwao ki ne tio 'i senai. Sui nia ka oli, ma ka kwele 'asiana ana ru ne nia fuli. ");
INSERT INTO far_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ana fa dangi nai, ta ro wane ana fafurongo sa Jesus ki, keroa leka 'uria na fere 'i Emeas. Nia bobola fainia te akwala ma te kada taale fasia 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ma keroa ka fata 'adaroa sulia ru nai ki tafau ne nia fuli. ");
INSERT INTO far_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ma kada keroa fata 'adaroa, sa Jesus nia leka karangi keroa mai, ma ka leka laugo fai keroa. ");
INSERT INTO far_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Keroa ka ada to'ona go 'adaroa, boroi ma God nao si alamatainia fua keroa ka ada saitamana. ");
INSERT INTO far_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ma sa Jesus ka fata 'uri fuadaro, “Te ne kamoro fata mai sulia kada ne kamoro leka mai ana?” Ma keroa ka uu aroaro, ma manataladoro ka kwaimanatai. ");
INSERT INTO far_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ma te wane 'adaroa ne satana sa Kleopas, nia fata 'uri, “Alamia 'oe go ne te wane to 'i Jerusalem, ma 'oko ulafusi ru ne fuli laona maedangi ne ki.” ");
INSERT INTO far_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ma sa Jesus nia ledida ka 'uri, “Ru 'uta ki nai?” Ma keroa olisia ka 'uri, “Ru ne kera sasia ana sa Jesus, na wane be 'i Nasaret. Wane nai, nia na profet, na wane fuana faoraie ana fatalana God, sulia God, ma na wane ki kera saitamana na fatalana nia nikila, ma na raolana ka talingai 'asiana. ");
INSERT INTO far_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na fataabu baita kalu ki, ma wane fanaonao ki, kera kwatea fuana saungilana, ma kera ka foto'ia ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma kalu ka manata amalu sulia sae nia ne kai lugea wane Israel ki. Ma ta'ena oluna maedangi 'i burina ru ne ki nia fuli. ");
INSERT INTO far_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ma kalu ka kwele 'asiana, sulia tani keni ana okue kalu, kera leka dao ana na faoda. ");
INSERT INTO far_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Boroi ma kera nao si ada to'ona na nonina. Ma kera ka oli mai, kera ka saea ne kera ada to'ona na 'ainsel ki ne farongoda ana ne nia mauri lau. ");
INSERT INTO far_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ma tani wane lau ana okue kalu, kera leka laugo ana na faoda nai, ma kera ka dao to'ona nia mamana na, dia be keni nai ki kera saea. Boroi ma kera ka si ada to'ona na nonina sa Jesus.” ");
INSERT INTO far_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ma sa Jesus ka fata 'uri fuadaro, “Kamoro oewanea 'asiana! Ma na manatamoro si 'ali'ali fuana famamanalana ru be na profet ki kera saea na mai 'i nao. ");
INSERT INTO far_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Na Christ kai nonifi basi, sui nia ka fi gwaungai ana 'initoe baita.” ");
INSERT INTO far_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ma sa Jesus ka famanata keroa ana ru be kera saea sulia na Christ 'i laona Kekedee Abu ki. Nia safali ana na kekedee sa Moses ki ma na kekedee Profet ki. ");
INSERT INTO far_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ma kada kera dao karangia na fere ne kera leka 'uria, sa Jesus ka sasi dia ne nia kai liu daofa liu adaro. ");
INSERT INTO far_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ma keroa luia, ma keroa ka fata 'uri, “'Oe to basi mai 'amu fai karo, sulia bali ana dangi nia liu na, ma karangia nia kai rodo na.” Ma nia ka leka na 'ana faidaro. ");
INSERT INTO far_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kada nia to na fuana fangalae fai keroa, nia ka ngalia lifu beret, ma ka tangoa God, sui ka ngiia na beret nai, ma ka kwatea fuadaro. ");
INSERT INTO far_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kada keroa ada to'ona ru nai, God ka ala'ani keroa ka fi ada saitamana, ma nia ka naoana na fasidaro. ");
INSERT INTO far_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ma keroa ka fata kwailiu fuadaro, keroa ka 'uri, “Kada be nia faorai fai koro sulia taale, ma ka famanata koro ana Kekedee Abu ki, koro eele 'asiana.” ");
INSERT INTO far_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ma ana kada nai go, keroa tatae, keroa ka oli lau 'uria 'i Jerusalem. Ma keroa ka dao to'ona na akwala ma te lifurongo ne kera oku ga 'ada, fainia tani wane lau. ");
INSERT INTO far_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ma wane ki laona okue nai ka farongoda 'uri, “Na 'Aofia nia mauri, mamana na! Nia dao fatai fuana sa Simon!” ");
INSERT INTO far_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ma keroa faorai sulia na ru be nia fuli sulia na taale, ma kada keroa ada saitamana nia ngiia na lifu beret. ");
INSERT INTO far_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kada ro wane nai ki keroa faorai go 'adaro fuada, sa Jesus nia dao fatai, ma ka uu 'i safitada, ma ka fata 'uri fuada, “Na aroaroe ka to fai kamulu.” ");
INSERT INTO far_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ma kera ka tona, ma kera mau 'asiana, sulia kera kwaisae kera ada to'ona ta anoeru. ");
INSERT INTO far_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ma sa Jesus ka fata 'uri, “Te ne sasi kamulu ka mau? Nao mulu si manata ruarua! ");
INSERT INTO far_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nau go, aku ne. Mulu ada to'ona ro 'aba nau ki fainia na ro 'ae nau ki. Mulu samo to'ona basi mai na noniku, fua mulu ka saitamana, sulia ne anoeru nao si to ana ta suli fainia ta fasio, dia ne kamulu ada to'ona nau ku to ana.” ");
INSERT INTO far_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Burina ne nia saea ru nai ki ka sui, nia ka fatainia na fulina mae nila be ki ana ro 'abana ma na ro 'aena ki fuada. ");
INSERT INTO far_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ma kera ka eele 'asiana fainia kwelelae. Sui boroi 'ana, kera manata ruarua ga 'ada, sulia kera nao si saitamana lea 'ua ana. Ma sa Jesus ka fata 'uri fuada, “Mulu kwate ta fanga fuaku.” ");
INSERT INTO far_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ma kera ka kwatea te lifu ie fuana. ");
INSERT INTO far_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ma nia ka ngalia, ma ka 'ania naoda. ");
INSERT INTO far_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sui nia ka fata lau 'uri fuada, “Ru ne ki nau ku saea 'ua na mai fua mulu, kada nau ku to 'ua mai fai kamulu. Ru ne ki tafau be kera kedea suli nau laona taki sa Moses ki, ma 'i laona kekedee Profet ki, ma 'i laona Psalm ki, kera kai dao mamana na mai.” ");
INSERT INTO far_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Sui sa Jesus ka 'ifingia manatada fua kera ka saitamana na Kekedee Abu. ");
INSERT INTO far_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nia ka fata 'uri fuada, “Kera kede suli nau, na Christ, ne kai nonifi, ana oluna maedangi, nau kai tatae lau fasia na maea. ");
INSERT INTO far_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma nia ka safali mai 'i Jerusalem leka ka dao laona fere ki tafau, mulu kai fata sulia na kari abulolae ma na manatalugelae ana ta'alae ki ana na sataku. ");
INSERT INTO far_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ma kamulu na ne mulu kai farongo ana ru ne ki. ");
INSERT INTO far_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma nau talaku, nau kai kwatea fua mulu na Anoeru Abu ne Maa nau nia eta fatae ana. Ma mulu kai kwaimakwali 'i Jerusalem, leka na nikilalae fasia 'i langi ka koso mai fafi kamulu.” ");
INSERT INTO far_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Sui ma nia ka talaida na fasia 'i laona fere baita nai, leka kera ka dao ana fere 'i Betani, ma nia ka taea na 'abana 'i langi, ma ka faleada. ");
INSERT INTO far_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ma kada nia falea kera ga 'ana 'ua, nia ka fasi kera, ma ka oli na 'ana 'uria 'i langi. ");
INSERT INTO far_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma kera ka fa'initoa, sui kera ka oli na 'ada 'i Jerusalem fainia na eelea baita. ");
INSERT INTO far_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ma ana kada 'oro ki kera to ga 'ada 'i laona Beu Abu God fuana tangolana God. ");
INSERT INTO far_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Safali 'ua na mai 'i naona ne God nia saungainia na molagali, na ru ne kera saea ana na Fata nia to na, ma nia ka to na mai fainia God. Ma na Fata nai, nia ne God. ");
INSERT INTO far_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ana safalilana, na Fata ne nia to na mai fainia God. ");
INSERT INTO far_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ma God ka saungainia na ru ki tafau ani nia. Iu, na ru ki tafau ne God nia saungaida, nia saungaida ana na Fata. ");
INSERT INTO far_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ma na maurie ka safali mai fasia na Fata ne. Ma na maurie nai ne na madakwalae mamana ne famadakwa ru ki sulia God fuana wane ki. ");
INSERT INTO far_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma na madakwalae nai ka tala laona maerodo, ma na maerodo ka nao si famaea. ");
INSERT INTO far_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","God ka kwatea mai te wane ne satana sa Jon wane ni Siuabu, ");
INSERT INTO far_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ka leka mai fuana farongolana na wane ki sulia na madakwalae ne. Nia ka leka mai ka farongo kera ana, fua wane ki tafau kera ka rongoa ma kera ka famamana. ");
INSERT INTO far_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ma sa Jon 'ana talana nao lau na madakwalae, nia leka lalau mai fua ne ka farongo ana na madakwalae nai. ");
INSERT INTO far_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Sui, na madakwalae mamana nai fi leka mai laona molagali, ma ka tala fafia wane ki tafau. ");
INSERT INTO far_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ma Fata ne nia to na laona molagali. God ka saungainia na molagali ne ani nia, boroi ma na wane ki kera nao si ada saitamana go. ");
INSERT INTO far_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nia ka dao mai laona fere nia, boroi ma wane nia ki nao si kwaloa go. ");
INSERT INTO far_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Boroi ma tani wane kera ka kwaloa, ma kera ka famamana nia, ma nia ka kwatea na mamanae fuada fua ka rokisida ana na wele God ki. ");
INSERT INTO far_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kera futa falu dia wele God ki! Futalae falu ne fuli mai ana God. Nao nia si fuli sulia manatae wane ana molagali, naoma ka futa ana wane laona molagali. ");
INSERT INTO far_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Na Fata ne ka alu na wane, ma ka to na fai kia. Kalu ada to'ona na 'initoe nia ne nia to ana, sulia nia ne wele mutai God na Maa. Na lealae ma na mamanae God ki tafau koso mai fuaka ani nia. ");
INSERT INTO far_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sa Jon wane ni Siuabu ka farongo sulia nia, kada be nia akwa ka fata 'uri, “Nia na wane be nau ku fata sulia ana kada be nau ku fata 'uri, ‘Na wane ne nia leka mai 'i buriku, nia talingai 'asiana liufi nau, sulia nia to 'ua na mai 'i naona ne nau ku futa.’” ");
INSERT INTO far_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ma sulia na kwaiofei baita nia, Christ ka kwatea na ru lea ki tafau fuaka sulia dangi ki. ");
INSERT INTO far_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","God ka kwatea laugo na taki nia ki fuaka ana sa Moses. Boroi ma nia kwatea mai na kwaiofei nia ma na mamanae nia ana sa Jesus Christ. ");
INSERT INTO far_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma nao ta wane si ada to'ona God. Taifilia go na Wele God, ne nia bobola fainia God na Maa, ma ka to fainia, nia ne ka fatainia God fuaka. ");
INSERT INTO far_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Na wane fanaonao ki ana wane Jiu ki 'i Jerusalem, kera ka kwatea na fataabu ki, ma na wane kwai'adomi ana fataabu ki, fua kera ka ledia sa Jon 'uri, “'Uri ma 'oe sa ti ne?” ");
INSERT INTO far_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ma sa Jon ka olisi madakwa ada ka 'uri, “Nau nao lau na Christ, na wane be God filia fuana famaurilana wane ki.” ");
INSERT INTO far_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ma kera ka ledia lau kera ka 'uri, “Aia, ma 'oe sa ti ne? 'Oe sa Elaeja?” Ma nia ka olisida lau ka 'uri, “Nao.” Ma kera ledia lau kera ka 'uri, “'Uri ma 'oe ne na Profet ne kalu makwalia?” Ma sa Jon ka olisida ka 'uri, “Nao.” ");
INSERT INTO far_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ma kera ka ledi 'isi lau ana, kera ka 'uri, “Aia, 'urinai ma 'oe sa ti lalau ne? 'Oe saea mai ta ru fua malu, fua ne kalu ka farongoa ana na wane ne kera odu kalu mai. Ta te ne 'oe saea mai suli 'oe talamu?” ");
INSERT INTO far_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ma sa Jon ka olisida ana fatae be sa profet Aesaea nia kedea ka 'uri, “Nau na wane be akwa laona lofaa 'eke'eke ka 'uri, ‘Na 'Aofia kai dao na mai! Mulu kai fasaga na taale fuana.’” ");
INSERT INTO far_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma na wane ne leka mai fasia na Farasi ki, ");
INSERT INTO far_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kera ledia lau kera ka 'uri, “Ma 'uta ne 'oko siuabua na wane ki, sulia dia ne 'oe nao lau na Christ, naoma sa Elaeja, naoma na Profet?” ");
INSERT INTO far_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ma sa Jon ka olisida ka 'uri, “Nau ku siuabu ga 'aku ana na kafo. Boroi ma te wane ne mulu ulafusia, nia to ga 'ana 'i safitamulu. ");
INSERT INTO far_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ma nia ne na wane ne kai leka mai 'i buriku, boroi ma nao nau si bobola fua ne nau ku lugea na tae butu nia ki.” ");
INSERT INTO far_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ma ru ne ki tafau ka fuli 'i Betani, na fere 'i bali 'uria taelana sato ana kafo 'i Jodan, kula be sa Jon nia siuabua wane ki ana. ");
INSERT INTO far_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ana fa asoa 'i buri, sa Jon ka ada to'ona sa Jesus 'e leka mai siana, ma nia ka saea fuana wane ki, “Mulu ada to'ona, nia ne na wane ne na kale sipsip God ne ngalia abulo ta'alae wane ki laona molagali fasida. ");
INSERT INTO far_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nia na wane be nau ku fata sulia kada be nau ku fata 'uri, ‘Te wane kai leka mai 'i buriku. Nia 'e talingai ka liufi nau, sulia nia to 'ua na mai 'i naona suifatai nau fi futa.’ ");
INSERT INTO far_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","'I nao mai, nao nau si ada saitamana 'ua ana ta wane 'uta ne nia, 'urinai boroi 'ana nau ku leka mai, ma nau ku siuabu ana kafo fua wane Israel ki kera ka saitamana.” ");
INSERT INTO far_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ma sa Jon ka fata lau 'uri, “Nau ku ada to'ona na Anoeru Abu nia koso mai fasia 'i langi dia ta bole, ma ka to 'i fafona. ");
INSERT INTO far_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Nao nau si ada saitamana 'ua ana. Boroi ma God be kwate nau mai fua ne nau ku siuabu ana na kafo, nia ka fata 'uri fuaku, ‘'Oe kai ada to'ona na Anoeru Abu kai koso mai, ma ka to 'i fafona te wane. Nia na ne na wane ne kai siuabu ana na Anoeru Abu.’” ");
INSERT INTO far_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ma sa Jon ka fata lau 'uri, “Nau ku ada to'ona na, ma nau ku saea fua mulu, nia na ne Wele God.” ");
INSERT INTO far_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ma ana te fa dangi lau 'i buri, sa Jon ka uu laugo 'i senai fainia ta ro wane ana fafurongo nia ki. ");
INSERT INTO far_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ana kada sa Jesus nia liu, sa Jon ka ada to'ona, ma nia ka fata 'uri, “Nia na Ka Sipsip God.” ");
INSERT INTO far_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ma na ro wane fafurongo nia ki, keroa rongoa ru nai, ma keroa ka leka na 'adaro sulia sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ma sa Jesus ka abulo, ma ka ada to'ona ne keroa leka suli nia, ma nia ka ledi keroa ka 'uri, “Na te ne kamoro nani 'uria?” Ma keroa olisia keroa ka 'uri, “Rabae 'ae, 'oe to 'i fai?” Na fadalana Rabae ne, “wane famanata.” ");
INSERT INTO far_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ma nia ka olisi keroa ka 'uri, “Kamoro leka mai, fua kamoro ka ada to'ona.” Kada nai nia bobola na fainia fai kada sato saulafi. Ma ro fafurongo nai ki keroa leka ka ada to'ona kula ne sa Jesus nia 'idufa to ana. Ma keroa ka to mai fainia leka ka rodo. ");
INSERT INTO far_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ma te wane 'adaro ne sa Andru, na sasina sa Simon Pita. ");
INSERT INTO far_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ma sa Andru fi leka ma ka dao to'ona sa Simon na wanefuta nia, ma ka farongo nia ka 'uri, “Karo dao na to'ona na Mesaea.” Na fadalana fatae nai ne na “Christ.” ");
INSERT INTO far_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ma sa Andru ka talaia sa Simon siana sa Jesus. Ma sa Jesus ka bubungi ana, ma ka fata 'uri, “'Oe sa Simon, na wele sa Jon, nau ku fasata 'oe na ana sa Sifas.” Na sataeru nai ne kera saea laugo ana sa Pita, ma na fadalana ne, “Na Fau.” ");
INSERT INTO far_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Sui ana ruana fa dangi, sa Jesus ka manata 'uria lekalae 'uria lofaa 'i Galili, ma nia ka dao to'ona sa Filip, ma ka fata 'uri fuana, “'Oe leka mai fai nau.” ");
INSERT INTO far_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ma sa Filip na wane fasia 'i Betsaeda, na mae fere sa Andru ma sa Pita. ");
INSERT INTO far_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Aia, sa Filip ka dao to'ona sa Nataniel, ma ka farongo nia ka 'uri, “Kalu dao to'ona na wane be sa Moses kekede sulia laona taki ki, ma na profet ki laugo be kera kekede sulia. Nia sa Jesus na wele sa Josef fasia 'i Nasaret.” ");
INSERT INTO far_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ma sa Nataniel ka fata 'uri, “'Oe fia ta ru lea ka leka mai fasia 'i Nasaret?” Ma sa Filip ka olisia ka fata 'uri fuana, “Leka mai 'oko tala ada to'ona 'amu.” ");
INSERT INTO far_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Kada sa Jesus nia ada to'ona sa Nataniel nia leka mai siana, nia ka fata sulia ka 'uri, “Na wane ne nia bobola 'asiana fuana kera ka saea nia ana wane Jiu mamana, sulia nao na ta sukee ani nia!” ");
INSERT INTO far_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Sa Nataniel ka olisia ka 'uri, “'Oe susuli 'uta aku?” Ma sa Jesus ka olisia ka fata 'uri fuana, “Nau ku ada to'omu 'i 'aena 'ai figi 'i naona ne sa Filip nia sae 'oe.” ");
INSERT INTO far_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ma kada sa Nataniel 'e rongoa na ru ne, nia ka fata 'uri, “Wane Famanata 'ae, 'oe na Wele God! 'Oe na Kingi wane Israel ki!” ");
INSERT INTO far_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Sa Jesus ka 'uri fuana, “'Oe fi famamana go nai, sulia be nau ku saea nau ku ada to'omu 'aena 'ai figi? Ma nau ku saea fuamu, 'oe kai ada to'ona ru baita ki liufia na ru ne.” ");
INSERT INTO far_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Sui sa Jesus ka fata lau 'uri fuada, “Ru mamana nau ku saea fua mulu, mulu kai ada to'ona 'i langi kai 'ifi, ma mulu kai ada to'ona laugo na 'ainsel God ki kera kai ra 'alaa 'uria 'i langi, ma kera kai koso mai fafi nau, na Wele nia Wane.” ");
INSERT INTO far_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Burina ro maedangi ki sui, te araie ka fuli ana te mae fere ne satana 'i Kena 'i laona lofaa 'i Galili. Ma gaa sa Jesus ka to laugo 'i senai ana kada nai. ");
INSERT INTO far_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma kera ka laefia laugo mai sa Jesus fainia fafurongo nia ki 'uria na araie nai. ");
INSERT INTO far_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma kada ne wane ki kera ku, ma na waeni kera ka sui, gaa sa Jesus ka fata 'uri fuana, “Kera nao si to na ana ta waeni.” ");
INSERT INTO far_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ma sa Jesus ka olisia ka 'uri, “Gaa 'ae, nao 'oe si sae nau fuana sasilana ta ru, sulia na kada nau nia nao 'ua.” ");
INSERT INTO far_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ma gaa sa Jesus ka fata 'uri fuana wane rao ki, “Mulu sasi sulia ru ne nia kai saea fua mulu.” ");
INSERT INTO far_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Na ono kufi ru baita ki fuana ngali kafolae ne kera saungainia ana fau kera 'i senai, fuana wane ki ka taufia 'abada ana ma tae ru kera ki sulia na falafala Jiu ki. Te kufi ru nia bobola fainia ka ngalia ro akwala galono kafo. ");
INSERT INTO far_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ma sa Jesus ka fata 'uri fuana wane rao ki, “Mulu ongia kufi ru ne ki ana kafo.” Ma kera ka ongida leka ka fungu. ");
INSERT INTO far_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sui nia ka fata 'uri fuada, “Mulu ongia kafo, ma mulu ka kwatea fuana wane baita ana fafanga ne.” Ma kera ka kwatea fuana, ");
INSERT INTO far_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ma nia ka ku to'ona kafo nai, ne 'e alu na waeni. Ma nao nia si saitamana waeni ne nia leka mai fasia 'i fai. Boroi ma na wane rao ne kera ongia mai kafo nai go ne kera saitamana tafau. 'Urinai na wane baita ne ka akwa mai 'uria na arai falu nai, ");
INSERT INTO far_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ma ka fata 'uri fuana, “Na wane ki tafau kera kwatea waeni lea 'i nao, ma 'i burina wane ki kera ku ka suina, nia fi kwatea na waeni ne 'afae. Boroi ma 'oe konia na waeni lea ne leka ka dao na ana kada ne!” ");
INSERT INTO far_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Nia na ne etana fanadae ne sa Jesus nia sasia. Nia sasia laona fere 'i Kena laona lofaa 'i Galili. Senai nia ka fatainia na 'initoe nia, ma na fafurongo nia ki kera ka famamana nia na. ");
INSERT INTO far_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ma 'i buri, sa Jesus fai gaa nia, ma na wanefuta nia ki, ma na fafurongo nia ki, kera ka leka na 'uria na fere 'i Kapaneam. Ma kera ka to senai sulia bara maedangi. ");
INSERT INTO far_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aia, ma karangia na Fafanga ana Daofa Liue na wane Jiu ki, sa Jesus ka leka 'uria na fere baita 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ma senai laona Beu Abu God, nia ka ada to'ona na wane ne kera 'oifoli ana buluka ki, ma sipsip ki, ma na bole ki fuana afafue. Ma nia ka ada to'ona laugo wane ne kera talana na malefo ki, kera gouru 'ada 'i ninimana tatafe kera ki. ");
INSERT INTO far_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ma nia ka saungainia ru fuana kwaelae ana kwalo ki, ma ka taria na buluka ki, ma na sipsip ki, ma na ru ki tafau fasia laona Beu Abu God. Ma nia ka kefusia na tatafe wane ne kera talana malefo ki, ma ka takalongainia malefo kera ki. ");
INSERT INTO far_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ma nia ka kwaetarida sulia na wane ne kera 'oifolie ana na bole ki ka 'uri, “Mulu ngalia ru ne ki 'i maa! Nao mulu si fabilia lau na Beu Maa nau ana kula ni usie!” ");
INSERT INTO far_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ma na fafurongo nia ki kera ka manata to'ona na Kekedee Abu be nia fata 'uri, “God 'ae, kada ki tafau go ne nau ku manata baita ana Beu 'oe ka dia na ere ne 'ako'ako laona mangoku.” ");
INSERT INTO far_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sui na wane gwaungai Jiu ki kera ka ledia sa Jesus kera ka 'uri, “Sa ti ne kwatea mamanae fuamu fuana sasilana ru nai ki? Dia God ne kwatea mamanae fuamu, fatainia ta fanadae fua ne kalu ka famamana 'oe!” ");
INSERT INTO far_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ma sa Jesus ka olisida ka 'uri, “Dia mulu kai okosia boroi na Beu Abu ne, nau kai fauua lau laona olu maedangi ki.” ");
INSERT INTO far_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ma kera ledi nia lau kera ka 'uri, “'Uri ma 'oe kai fauua lau laona olu maedangi ki go? Na Beu Abu God ne, kera saungainia sulia fai akwala ma ono fangali ki!” ");
INSERT INTO far_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Boroi ma na Beu Abu ne sa Jesus nia fata sulia ne na nonina lalau 'ana. ");
INSERT INTO far_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ma ana kada God tae nia fasia maea na ne na fafurongo nia ki fi manata to'ona ne nia saea na ru ne, ma kera ka fi famamana na Kekedee Abu ma na ru ne sa Jesus saea. ");
INSERT INTO far_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma ana kada sa Jesus nia to 'i Jerusalem ana na Fafanga ana Daofa Liue, na wane 'oro ki kera famamana nia, sulia kera ada to'ona fanadae ki ne nia sasia. ");
INSERT INTO far_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sui ka 'urinai boroi 'ana, sa Jesus nao si famamana kera go, sulia nia saitamana tafau go ada. ");
INSERT INTO far_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Sui boroi 'ana ta wane nao si farongo nia ana ta ru sulia na wane, nia saitamana ga 'ana ana ru ki tafau laona manatalada. ");
INSERT INTO far_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","2","Ana te kada, te wane fanaonao Jiu ki, nia leka mai siana sa Jesus. Na wane nai satana sa Nikodimas, nia ta wane ana Farasi ki. Nia leka mai siana sa Jesus laona rodo, ma ka fata 'uri fuana, “Famanata 'ae, kalu saitamana 'oe na wane famanata ne God kwatea mai, sulia ru fanadae ki ne 'oe fulida, 'afitai ta wane ka sasia dia God nao si to fainia.” ");
INSERT INTO far_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Sa Jesus ka olisia ka fata 'uri fuana, “Ru mamana nau ku saea fuamu, 'afitai ta wane ka ada to'ona maurie ne God gwaungai ana, dia nao nia si futa falu lau.” ");
INSERT INTO far_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ma sa Nikodimas ka ledia sa Jesus ka 'uri, “Na wane ne baita na, nia futa 'uta lau mai? 'Afitai 'asiana fuana wane ne ka oli lau laona guina gaa nia, ma ka futa lau mai!” ");
INSERT INTO far_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Sa Jesus ka fata 'uri fuana, “Ru mamana nau ku saea fuamu. 'Afitai 'asiana fua ta wane ka ru laona maurie ne God gwaungai ana, dia nao nia si futa ana kafo ma na Anoeru Abu. ");
INSERT INTO far_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Kada wane nia futa ana na maa nia fainia na gaa nia, nia alua ana wane. Ma sa ti ne ka futa ana Anoeru Abu God, nia futa falu mai fasia 'i langi. ");
INSERT INTO far_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nao 'oe si kwele, sulia nau ku saea fuamu, mulu kai futa falu. ");
INSERT INTO far_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Na Anoeru Abu nia dia na sasaule. Sui boroi 'ana 'oko rongoa na sasaule, nao 'oe si ada to'ona go ne nia leka mai fasia 'i fai, naoma ka leka 'uria 'i fai. Ma na Anoeru Abu laugo, nao 'oe si ada to'ona nia ka talana 'uta ana wane fua ka alua na wane falu.” ");
INSERT INTO far_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Sa Nikodimas ka ledia lau ka 'uri, “'Uri ma na ru ne ki kai mamana 'uta?” ");
INSERT INTO far_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Sa Jesus ka olisia ka 'uri fuana, “'Oe ne na wane famanata 'initoa Jiu ki na. Ma 'uta ne nao 'oe si saitamana go ana na fadalana ru ne ki? ");
INSERT INTO far_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ru mamana nau ku saea fuamu, kalu farongo ana na ru ne kalu saitamana ki, ma kalu ka fata sulia na ru ne kalu ada to'oda ki. Ma nao ta wane amulu si famamana go. ");
INSERT INTO far_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Aia, ma dia nao mulu si famamana na ru ne nau ku farongo kamulu ana sulia ru ana molagali ne, mulu ka fi famamana 'uta aku dia nau ku farongo kamulu ana na ru mai langi ki? ");
INSERT INTO far_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ma nau, na Wele nia Wane, go ne nau ku saitamana ru 'i langi ki, sulia nau ku koso mai fasia 'i langi. Ma ka nao lau ta wane ne ka koso mai fasia 'i langi. ");
INSERT INTO far_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Ana kada be 'i nao, sa Moses nia saungainia na fa tafo ana na barasi be laona bali lofaa 'eke'eke, ma ka fauua 'i langi gwauna na 'ai be. Ma ka 'urinai laugo, kera kai fauua na Wele nia Wane 'i langi gwauna na 'ai, ");
INSERT INTO far_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","fua ne sa tifaida ne kera famamana nau, kera kai mauri firi. ");
INSERT INTO far_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","God fatainia na kwaimanie baita nia fuana wane ki tafau laona molagali ne 'uri, nia ka kwatea mai te Wele mutai nia, fua ne sa ti ne kera famamana nia, kera nao si funu, boroi ma kera kai mauri firi. ");
INSERT INTO far_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","God nao si kwatea mai na Wele nia laona molagali fuana ketolana na wane ki, boroi ma nia kwatea lalau mai fuana famaurilada. ");
INSERT INTO far_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Ma sa ti boroi 'ana ne famamana na Wele nia, nao God si ketoa. Ma sa ti boroi 'ana ne nao si famamana nia, God ketoa ka suina, sulia nia nao si famamana te Wele mutai nia. ");
INSERT INTO far_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","God kai keto kera sulia ne na madakwalae nia dao na mai 'i laona molagali, boroi ma wane ki, kera kwaimani lalau ana maerodo, ma nao kera si kwaimani ana madakwalae, sulia falafala kera ki ta'a. ");
INSERT INTO far_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Sulia sa ti ne abulolana nia ta'a, nia ka noni'ela ana madakwalae, ma nao nia si doria lekalae mai fuana madakwalae, sulia nao nia si doria abulo ta'alae nia ki ka fatai. ");
INSERT INTO far_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Boroi ma sa ti boroi 'ana ne sasia ru 'o'olo, nia leka mai fuana madakwalae, fua madakwalae ka fatainia na ru ne nia sasia ki nia leka sulia kwaidorie God.” ");
INSERT INTO far_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma burina, sa Jesus fainia na fafurongo nia ki kera leka 'uria 'i Jiudea, ma kera ka to 'i senai. Ma kera ka siuabua na wane ki 'i senai. ");
INSERT INTO far_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma ana kada nai laugo, sa Jon ka siuabua na wane ki ana mae fere 'i Aenon karangia 'i Salim. Sa Jon ka siuabuda 'i senai, sulia kula ne kafo nia 'oro ana. Aia, ma wane 'oro ki laugo kera ka leka siana fuana siuabulae. ");
INSERT INTO far_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ana kada nai, kera nao si alua 'ua sa Jon laona beu ni kanie.) ");
INSERT INTO far_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma ana kada nai, tani wane ana fafurongo sa Jon ki, kera olisusu fainia te wane ana Jiu ki sulia falafala Jiu ki ana taufilana nonida, fua ne kera ka falu 'i naona God. ");
INSERT INTO far_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ma fafurongo sa Jon ki kera leka siana sa Jon, ma kera ka ledia kera ka 'uri, “Wane Famanata 'ae, 'oe saitamana na wane be nia uu fai 'oe bali kafo loko 'i Jodan, ne 'oe saea ru lea ki sulia? Ana kada ne, nia siuabua na wane ki, ma wane 'oro ki, kera leka tafau na siana!” ");
INSERT INTO far_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ma sa Jon olisida ka 'uri, “Ta wane nia too go ana na rao ne God kwatea fuana. ");
INSERT INTO far_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Kamulu rongoa tafau na be nau ku saea fua mulu, nau nao lau na Christ, na wane ne God filia. Nau wane nau ku leka mai 'i nao fuana nau 'ainitalo ana farongoe sulia nia. ");
INSERT INTO far_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Na Christ nia dia na wane be nia arai falu. Ma nau ku dia na wane kwaimani na arai falu. Ma na wane kwaimani na arai falu nai, nia eele 'asiana kada ne wane arai falu nia dao fuana araie nia. Ma ka 'urinai laugo fuaku. Nau ku eele 'asiana ana kada nai, sulia sa Jesus nia dao na. ");
INSERT INTO far_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","God doria nia kai 'idu 'alaa ma fua nau ku koso toli. ");
INSERT INTO far_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Iu, ma na Christ leka mai fasia 'i langi, nia talingai 'asiana liufia wane ki tafau. Ta wane ana molagali ne, nia na wane ana molagali ne ga 'ana, ma nia ka saitamana fatae sulia ru ne fuli laona molagali ne. Boroi ma na wane ne, nia na Christ ne leka mai fasia 'i langi, nia talingai ka liufia wane ki tafau. ");
INSERT INTO far_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nia fata madakwa sulia te ne nia ada to'ona, ma ka rongoa. Sui ka 'urinai boroi 'ana, nao ta wane si doria go famamanalae ana te ki ne nia saea. ");
INSERT INTO far_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ma na wane ne nia famamana te ki ne God saea, na wane nai nia fatainia ru God saea ki kera mamana. ");
INSERT INTO far_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma na Christ ne God kwatea mai fasia 'i langi, nia ka 'ainitalo ana fatalana God, sulia God kwatea na Anoeru Abu fua ka fungulia tafau. ");
INSERT INTO far_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ma God na Maa ka kwaimani 'asiana fuana Wele nia, ma ka alua nia ka gwaungai fuana ru ki tafau. ");
INSERT INTO far_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ma sa ti boroi 'ana ne ka famamana na Wele ne, nia kai mauri firi. Ma sa ti ne nao si famamana Wele ne, nia kai mae, sulia ne nia to tari na farana kwaiketoie God.” ");
INSERT INTO far_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Sa Jesus fainia na fafurongo nia ki, kera leka fasia 'i Jiudea, ma kera ka leka 'uria 'i Galili. Kera leka, sulia sa Jesus nia saitamana ne Farasi ki kera rongoa sae nia sasia na wane 'oro ki kera ka leka sulia ka liufia sa Jon Wane ni Siuabu, ma liufia lau ne siuabulada. Sa Jesus nao si siuabua go ta wane. Boroi ma na fafurongo nia ki lalau ne kera sasi 'urinai. ");
INSERT INTO far_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma ana kada kera leka kau 'uria 'i Galili, kera ka liu ana bali lofaa 'i Samaria. ");
INSERT INTO far_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ma kera ka dao ana te mae fere ne satana 'i Saeka laona lofaa 'i Samaria, ne nia to karangia na ano ne sa Jakob nia kwatea fuana sa Josef na wele nia 'i nao 'ua mai. ");
INSERT INTO far_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ma na mae kafo 'elia sa Jakob ka to laugo 'i senai. Ma sa Jesus ka noni kulua ana na lekalae, ma nia ka gouru 'ana ninimana mae kafo 'elia nai. Ma ana kada nai, nia bobola na fainia tofungana asoa. ");
INSERT INTO far_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ma na fafurongo nia ki, kera ka leka 'i fere nai fua kera kai foli fanga. Ma te keni fasia 'i Samaria ka leka mai fua ne ka ongi kafo. Ma sa Jesus ka fata 'uri fuana, “'Oe kwatea mai ta kafo, nau ku basi.” ");
INSERT INTO far_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ma na keni nai ka olisia ka 'uri, “'Oe na wane Jiu, ma nau na keni 'i Samaria. 'Uta ne 'oe gani nau 'uria kafo fuana kulae?” Nia fata 'urinai, sulia ne wane Jiu ki kera nao si kwaimani fainia wane Samaria ki. ");
INSERT INTO far_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ma sa Jesus olisia ka 'uri, “Dia 'oe saitamana te ne God kwatea, ma 'oko saitamana sa ti ne gani 'oe 'uria kafo, alamia 'oe gani nau lalau 'amu, ma nau ku kwatea kafo ana maurie fuamu.” ");
INSERT INTO far_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ma keni nai ka fata 'uri fuana, “Wane baita 'ae, nao 'amu ta ru ni ufilana kafo, ma na mae kafo ne boroi 'e lola 'asiana laugo. 'Oe kai dao to'ona mone na kafo ana maurie nai 'i fai? ");
INSERT INTO far_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Na koko kia sa Jakob ne nia kwatea mae kafo 'elia ne fuaka. Ma nia, fainia na wele nia ki, ma na ru sarelana nia ki ne to ana 'aeda, kera ku laugo ana mae kafo 'elia ne. 'Uri ma 'oe kwaisae 'oe ne talingai ka liufia sa Jakob?” ");
INSERT INTO far_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ma sa Jesus ka fata 'uri, “Sa ti ne nia kufia kafo ne, nia saitamana kai maeliku lau. ");
INSERT INTO far_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Boroi ma sa ti boroi 'ana ne kufia na kafo ne nau ku kwatea, nao nia si maeliku lau. Ma kafo ne nau ku kwatea fuana ka alu na maebusu ne kwatea maurie firi fuana.” ");
INSERT INTO far_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ma na keni ne ka fata 'uri, “'Oe kwatea na kafo nena fuaku, fua nau nao si maeliku lau, ma nao nau si leka lau mai seki fuana ngali kafolae.” ");
INSERT INTO far_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ma sa Jesus ka fata 'uri fuana, “'Oe leka, 'oko saea mai na arai 'oe, ma kamoro ka oli mai 'i seki.” ");
INSERT INTO far_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ma na keni ne ka olisia ka 'uri, “Nao nau si too ana ta arai.” Sa Jesus ka fata 'uri, “'Oe fata mamana ana kada ne 'oe saea nao 'oe si too ana ta arai. ");
INSERT INTO far_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Sulia 'oe too ana lima arai ki, ma na wane nena 'oe to fainia kada ne, nia nao lau na arai mamana 'oe. Na ru mamana nena 'oe saea fuaku.” ");
INSERT INTO far_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ma na keni ne ka olisia ka 'uri, “Wane baita 'ae, nau ku saitamana 'oe ta profet. ");
INSERT INTO far_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na koko kalu ki 'i Samaria, kera fosia God gwauna fa uo ne. Ma kamulu wane Jiu ki, mulu saea kula fuana fosilana God ne 'i Jerusalem na. 'Uri ma 'i fai ana ro kula ne ki ne mamana?” ");
INSERT INTO far_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ma sa Jesus ka fata fuana ka 'uri, “Keni ne 'ae, 'oe famamana nau, na kada kai dao mai fuana wane ki ne kera nao si fosia na Maa 'i gwauna fa uo ne naoma 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Kamulu wane 'i Samaria ki, mulu ulafusia go 'amulu sa ti ne mulu fosia. Boroi ma kalu na wane Jiu ki, kalu saitamana sa ti ne kalu fosia, ma kalu saitamana 'ainitaloa ana taale ne God famauria wane ki. ");
INSERT INTO far_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Boroi ma ta kada kai dao mai, ma nia safali na, kada na Anoeru ka fatainia mamanae God, nia kwatea ka ngwaluda fua wane ki kera kai fosia God ana kula ki tafau. God ne na Anoeru, ma na wane ki ne kera kai fosia, kera ka futa falu ana na Anoeru ana Mamanae. Na wane 'urinai ki ne saitamana kera kai fosia na Maa.” ");
INSERT INTO far_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ma na keni nai ka fata 'uri fuana, “Nau ku saitamana na wane ne God nia filia ne kera saea ana na Christ kai dao mai. Ma ana kada ne nia kai dao mai, nia kai farongo kalu ana na ru ki tafau.” ");
INSERT INTO far_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sa Jesus ka olisia ka 'uri, “Nau na ne.” ");
INSERT INTO far_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ma ana kada nai, na fafurongo nia ki kera ka dao na mai, ma kera ka kwele 'asiana, sulia kera ada to'ona sa Jesus nia fata 'ana fainia na keni ne. Boroi ma nao ta wane ada si ledia go na keni ne, “Na te ne 'oe doria?” Ma kera nao si ledia go sa Jesus, “'Uta ne 'oe fata fainia na keni ne?” ");
INSERT INTO far_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ma na keni be ka alua 'i ano na ru ni ufi kafolae nia, ma ka oli 'i fere, ma ka fata 'uri fuana wane 'i senai ki, ");
INSERT INTO far_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Mulu leka mai, fua mulu ka ada to'ona 'amulu na te wane ne nia farongo nau ana ru ki tafau ne nau ku sasia. Alamia nia na Christ, na wane be God filia 'oto ne?” ");
INSERT INTO far_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ma kera ka fasia na mae fere be, ma kera ka leka mai siana sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ma ana kada nai, na fafurongo nia ki kera ledia sa Jesus kera ka 'uri, “Wane Famanata 'ae, 'ania basi ta fanga!” ");
INSERT INTO far_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ma sa Jesus olisida ka 'uri, “Nau ku to ana na fanga ni 'anilana nau ne mulu ulafusia.” ");
INSERT INTO far_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ma na fafurongo nia ki, kera ka ledi kera kwailiu kera ka 'uri, “Alamia ta wane ngali fanga mai fuana 'oto ne?” ");
INSERT INTO far_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ma sa Jesus ka fata 'uri fuada, “Na fanga nau na ne rolae sulia fatalana God ne nia kwate nau mai, ma na fasuilana raoe nia ki ne nia kwatea fuaku fuana sasilana. ");
INSERT INTO far_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aia, ma mulu saitamana suina fatae be nia 'uri, ‘Burina fai madame ki ne fueru witi ki ka fi maua fuana ngedalada.’ Boroi ma nau ku saea fua mulu, mulu ada lea basi to'ona oole ne ki. Kera maua na, ma ka kwaimakwali na fuana ngedalada. ");
INSERT INTO far_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma na wane ne nia ngeda ru laona oole, nia kai ngalia folifolie nia. Ma na fueru nai na ne wane ne kera dao to'ona maurie mamana ne nao si sui. Na wane ne fasia oole, ma wane ne ka loi ru, keroa kai eele tafau. ");
INSERT INTO far_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ma na tarifulae ka mamana ana ne nia fata 'uri, ‘Te wane nia fasi ru, ma ta wane ka ngeda.’ ");
INSERT INTO far_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nau ku eresi kamulu fuana ngedalana laona oole ne nao mulu si rao ana. Sulia tani wane lalau ne kera rao ana ma kamulu kai konia fueru ki.” ");
INSERT INTO far_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ma wane 'oro ki laona fere ne ana bali lofaa 'i Samaria, kera famamana sa Jesus, sulia na keni ne nia farongoda 'uri, “Nia farongo nau ana ru ki tafau ne nau ku sasia.” ");
INSERT INTO far_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ma ana kada kera leka mai siana sa Jesus, kera ka 'ingoa fua ne nia ka to lau 'ana faida. Ma sa Jesus ka to lau senai sulia ro maedangi ki. ");
INSERT INTO far_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ma na wane 'oro ki lau ne kera ka famamana sa Jesus, sulia kera tala rongoa na fatalana sa Jesus ki. ");
INSERT INTO far_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ma kera ka saea fuana keni ne ma kera ka 'uri, “Kalu famamana na nai, ma nao lau sulia ru be 'oe saea fua malu ki, boroi ma sulia lalau ne kalu tala rongoa 'amalu na fatalana laugo. Ma kalu ka saitamana ne nia mamana na ne Wane Famauri fuana wane ki tafau.” ");
INSERT INTO far_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Burina sa Jesus fainia fafurongo nia ki kera to ana mae fere ne sulia ro maedangi ki sui, kera ka fi leka 'uria 'i Galili. ");
INSERT INTO far_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Sa Jesus 'ana talana ne nia fata 'uri, “Na wane ki nao kera si fuusi baita go ana ta profet laona fere nia talana.” ");
INSERT INTO far_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ma kada sa Jesus nia oli mai 'uria 'i Galili, na wane nai ki kera kwalo nia, sulia kera leka laugo 'i Jerusalem ana Fafanga ana Daofa Liue, ma kera ka ada to'ona na ru ne sa Jesus nia fulida 'i senai ki. ");
INSERT INTO far_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sui sa Jesus ka oli lau 'uria 'i Kena na fere 'i Galili, na kula be nia talana kafo ka alu waeni. Ma ana kada nia to senai, na wele fi baita te wane 'initoa fasia 'i Kapaneam, nia matai ka baita 'asiana. ");
INSERT INTO far_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ma kada wane ne rongoa sa Jesus nia leka na fasia 'i Jiudea ma ka oli lau mai 'uria 'i Galili, nia ka leka mai siana sa Jesus, fua ka 'ingoa nia fuana lekalae fainia 'uria 'i Kapaneam, fua ka gura na wele fi baita nia, sulia nia matai ka karangi mae na. ");
INSERT INTO far_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Burina wane ne fata 'urinai ka sui, sa Jesus ka fata 'uri fuana, “Mulu doria ga 'amulu adalae to'ona na fanadae ki ma na ru ni kwelelae ana ki, suifatai mulu fi famamana nau.” ");
INSERT INTO far_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Sui boroi 'ana sa Jesus ka fata 'urinai, na wane ne nia inau ga 'ana fuana fatae 'uri fuana sa Jesus, “'Aofia, 'oe leka basi mai fai nau, dia nao na wele nau nia mae na nai.” ");
INSERT INTO far_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sui sa Jesus ka fata 'uri fuana, “'Oe oli 'amu, na wele fi baita 'oe nia 'akwa na.” Ma na wane ne ka leka, sulia nia famamana na fatalana sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ma kada nia leka kau 'ua sulia taale, tani wane rao nia ki, kera dao to'ona, ma kera ka fata 'uri, “Wane baita 'ae, na wele be 'oe, nia 'akwa na, ma ka mauri na!” ");
INSERT INTO far_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ma na wane 'initoa nai ka ledida, “Kada asoa te ne na wele fi baita nau nia 'akwa ana?” Ma kera olisia kera ka fata 'uri, “Na 'ako'akolae sui fasia 'i rokini ana etana kada sato 'i asoa.” ");
INSERT INTO far_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ma na maa wele ne ka saitamana kada asoa be sa Jesus saea na fatae be ki nai. Ma 'i burina ru ne, na wane 'initoa ne fainia na wane ki tafau laona lume nia, kera ka famamana sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ma ru nai na ruana fanadae ne sa Jesus fulia kada nia oli mai fasia 'i Jiudea 'uria 'i Galili. ");
INSERT INTO far_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","'I burina ru nai ki, sa Jesus nia leka 'uria 'i Jerusalem, ana te fafanga Jiu ki. ");
INSERT INTO far_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","'I Jerusalem, te mae namo baita ana kafo nia to karangia na kula ne kera saea ana mae tafa ana sipsip. Aia, ma ana fatae wane Jiu, kera saea na mae namo nai ana 'i Betsata. Ma na lima taofa gwala ki ne kera to 'i ninimana na mae namo nai. ");
INSERT INTO far_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Wane 'oro 'asiana ki ne kera tio laona taofa nai ki. Wane ne kera matai ana kwalukaela mataie 'e'ete ki kwailiu: wane maada ka rodo, wane 'aeda mae ki ma nonida mae ki. ");
INSERT INTO far_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ma te wane ne tio fai kera 'i senai, nia matai na sulia olu akwala ma kwalu fangali ki. ");
INSERT INTO far_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ma sa Jesus ka ada to'ona ne nia tio ga 'ana ana kula nai, ma nia ka saitamana ne nia matai ka tau 'asiana, ma nia ka ledia na wane nai ka 'uri, “'Uri ma 'oe doria 'oko 'akwa?” ");
INSERT INTO far_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ma na wane matai nai ka olisia sa Jesus ka 'uri, “Wane baita 'ae, nao ta wane fuana ka ngali nau kau 'uria laona mae namo ana kada ne kafo 'e gelogelo. Ana kada ki tafau, kada nau ku sasi fuana lekalae laona kafo ne, ta wane leka na 'ana 'i nao fasi nau.” ");
INSERT INTO far_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ma sa Jesus ka fata 'uri, “Tatae, 'oe ngalia 'ifitai 'oe, ma 'oko fali na 'amu.” ");
INSERT INTO far_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ma ana kada nai go, na wane nai ka lea na, ma nia ka tatae, ma ka ngalia 'ifitai nia, ma ka fali na 'ana. Ma na maedangi nai na Sabat. ");
INSERT INTO far_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Nia ne na fanaonao Jiu ki, kera ka fata 'uri fuana wane ne nia 'akwa na, “Ta'ena nia na Sabat, ma 'e abu 'asiana ana taki kia ki fua 'oko ngalia 'ifitai 'oe.” ");
INSERT INTO far_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Wane nai ka fata 'uri fuada, “Na wane ne nia gura nau ne nia saea nau ku ngalia 'ifitai nau, ma nau ku fali.” ");
INSERT INTO far_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ma kera ka ledia lau kera ka 'uri, “Wane te ne saea 'oe sasia ru nai?” ");
INSERT INTO far_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Boroi ma na wane ne 'e ulafusia laugo 'ana sa Jesus, sulia wane 'oro ki 'asiana ne kera to ana kula nai. Ma sa Jesus ka leka na 'ana 'i safitada. ");
INSERT INTO far_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ma 'i burina na, sa Jesus ka fi dao to'ona laona Beu Abu God, ma ka fata 'uri fuana, “'Oe fafurongo basi, ana kada ne, 'oe lea na. Ma 'oko kari abulo fasia abulo ta'alae 'oe ki, fasia ta ru ta'a 'asiana ka fi saungi 'oe lau 'i buri. Ma ru nai kai ta'a ka liufia ru ne eta saungi 'oe 'i nao.” ");
INSERT INTO far_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ana kada wane ne nia ru na 'i maa fasia na Beu Abu God, nia ka leka siana fanaonao Jiu ki, ma ka fata 'uri fuada, “Sa Jesus be nia gura nau, ma nau ku 'akwa lau.” ");
INSERT INTO far_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ma ana kada nai, kera ka safali malimae na ana sa Jesus, sulia nia gura na wane ne ana na Sabat. ");
INSERT INTO far_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ma sa Jesus ka fata 'uri fuada, “Dia ne Maa nau nia rao sulia maedangi ki tafau, nau boroi nau ku rao laugo.” ");
INSERT INTO far_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Na fatae nai ki, kada fanaonao Jiu ki kera rongoa, kera manata ngangata fua kera saungia sa Jesus ka mae na. Kera dori saungia sulia nia nao si manata baita ana taki sulia Sabat, ma ka saea laugo Maa nia ne God. Ma sulia ne nia 'urinai, nia fatainia sae nia bobola go ana fainia God. ");
INSERT INTO far_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ma sa Jesus ka olisida ka 'uri, “Ru mamana nau ku saea fua mulu. Nau, na Wele God, 'afitai nau ku sasia ta ru talaku. Nau ku saitamana ne nau sasia go ru ne nau ku ada to'ona Maa nau nia sasia. Ma te ne Maa nau 'e sasia, nia laugo ne nau ku sasia. ");
INSERT INTO far_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Maa nau nia kwaimani aku, ma nia ka fatainia fuaku na ru ki tafau ne nia 'e sasida. Ma nia kai fatainia laugo fuaku na raoe baita ki lau ne liufia guralana na wane ne, ma mulu kai kwele 'asiana ana ru ne ki nau ku sasida. ");
INSERT INTO far_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Maa nau nia saitamana ka taea wane mae ki ma ka famaurida. Ma ru 'urinai laugo ne nau na Wele nia, nau kai sasia laugo. Nau ku kwatea maurie laugo fuana sa tifaida ne nau ku filida. ");
INSERT INTO far_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Maa nau taifilia nao si ketoa ta wane, sulia nia kwatea na mamanae fuana kwaiketoilae fuana Wele nia. ");
INSERT INTO far_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nia kwatea ru ne fuaku fuana wane ki tafau kera ka fuusi baita aku, dia laugo ne kera fuusi baita ana na Maa nau. Ma sa ti ne nao si fuusi baita aku, nia nao si fuusi baita laugo ana Maa nau ne nia odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ru mamana nau ku saea fua mulu. Dia sa ti ne nia rongoa na fatalaku, ma ka famamana God ne nia odu nau mai, nia ka too ana maurie firi. Nao nau si keto nia na. Ma nia daofa liu na fasia maea, ma ka ru na laona maurie mamana. ");
INSERT INTO far_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ru mamana nau ku saea fua mulu, kada kai dao mai, ma nia ka dao na mai, fuana sa ti ne kera mae na ki, kera kai rongo lingeku, na Wele God. Ma sa ti ne kera rosuli nau, kera kai mauri. ");
INSERT INTO far_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Maa ne na ne, maurie mamana nia safali mai ana, ma nia ka kwatea maurie mamana ka safali laugo mai ana Wele nia. ");
INSERT INTO far_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ma nia ka kwatea na mamanae fuaku, fua nau ku ketoa na wane ki, sulia ne nau na Wele nia Wane. ");
INSERT INTO far_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Nao mulu si kwele ana ru ne, kada kai dao mai fuana wane ne kera mae na ki, kera kai rongo nau, ");
INSERT INTO far_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ma kera ka ru mai fasia na kilu gwau kera ki, fua sa ti ne kera sasia ru lea ki, kera ka tatae mai, ma kera ka maurie firi. Ma sa ti ne kera sasia ru ta'a ki, kera ka tatae mai, ma kera kai to laona kwaiketoilae firi. ");
INSERT INTO far_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Nao nau si sasia ta ru sulia manataku talaku. Nau ku saitamana nau ku ketoa wane sulia te ne nau ku rongoa God nia saea fuaku. Na kwaiketoilae nau nia 'o'olo tafau, sulia God eresi nau mai, ma nau ku sasi sulia na te ki ne nia doria, ma nao nau si sasi sulia na kwaidoria nau talaku. ");
INSERT INTO far_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Dia nau ku farongo ana ru suli nau talaku ki, nao ta wane si famamana go farongoe nau. ");
INSERT INTO far_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Boroi ma te wane ne nia to ga 'ana, nia lalau ne ka farongo ana te ne nia saitamana suli nau. Ma nau ku saitamana te ne nia farongo ana suli nau nia mamana tafau. ");
INSERT INTO far_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Aia, ma kamulu be kwatea kau wane kamulu ki siana sa Jon, ma nia ka farongo kamulu ana ru mamana ki suli nau. ");
INSERT INTO far_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Nao nau si rere go ana ta wane ne ka fata famamana lea suli nau, sui boroi 'ana nau ku fata sulia fata famamanalae sa Jon fua ka 'adomi kamulu 'uria maurie falu. ");
INSERT INTO far_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ma sa Jon nia usulia ta fa kwesu ne tala lea. Aia, ma sulia kada tu'u, mulu ka eele sulia te ki ne nia saea. ");
INSERT INTO far_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Boroi ma nau ku to laugo ana ru fuana fata famamanalae suli nau ne talingai ka liufia na fatae famamanalae sa Jon: na famanatalae nau ki fainia na fanadae ne nau ku fulida ki. Ma na ru nai ki na ne na raoe ne nau ku sasia sulia na Maa ne nia kwatea fuaku nau ku sasia. Na raoe nau ki ne fatainia ne Maa nau ne odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma na Maa ne odu nau mai 'ana talana laugo ne fata famamana ani nau. Nao mulu si rongoa lingena, ma nao mulu si ada to'ona, ");
INSERT INTO far_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ma nao mulu si kwaloa go fatalana laona maurilamulu, ma nao mulu si famamana nau, na wane ne nia 'e odua mai. ");
INSERT INTO far_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mulu 'idufa idumia Kekedee Abu ki, sulia ne kamulu kwaisae mulu kai too ana na maurie firi sulia. Ma na Kekedee Abu nai ki nia fatainia ru mamana ki tafau suli nau. ");
INSERT INTO far_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Iu, nia 'urinai boroi 'ana, nao mulu si doria go lekalae mai siaku fua nau ku famauri kamulu. ");
INSERT INTO far_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ma nau ne, nao si nani 'uria ta wane fua ka fuusi baita aku. ");
INSERT INTO far_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Boroi ma nau ku sai amulu ne nao mulu si to go ana ta kwaimanie fuana God. ");
INSERT INTO far_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nau ku leka mai fainia na mamanalae Maa nau, boroi ma nao mulu si kwalo nau go. Aia, ma dia ta wane nia leka mai 'ana fainia mamanalae nia talana, mulu ka eele fuana kwalolana. ");
INSERT INTO far_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Nia 'urinai sulia ne mulu doria wane ki kera ka tango kamulu. Boroi ma nao mulu si doria go na sasilana ru lea ki fua ne God ka tango kamulu. Ma dia nia 'urinai, nia 'afitai 'asiana fuana kamulu ka famamana nau. ");
INSERT INTO far_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nao lau nau ne nau kefusi kamulu 'i naona Maa nau. Sa Moses be nia kedea na taki ki ne mulu famamana, nia lalau ne kai kefusi kamulu. ");
INSERT INTO far_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Dia kamulu famamana sa Moses na, fulina kamulu ka famamana nau laugo, sulia nia be kekede mai suli nau. ");
INSERT INTO far_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Aia, ma sulia nao mulu si famamana te ne sa Moses nia kedea suli nau, nia 'afitai 'asiana fua mulu ka famamana te ki ne nau ku saea fua mulu.” ");
INSERT INTO far_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma 'i buri sa Jesus ka tofolo 'uria ta bali ana na 'osi 'i Galili ne kera saea laugo ana 'osi 'i Taebirias. ");
INSERT INTO far_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ma te okue baita kera leka 'i burina, sulia kera ada to'ona ru fanadae ki ne nia sasia ana guralana wane matai ki. ");
INSERT INTO far_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ma sa Jesus ka ra 'i gwauna te kula ne fane, ma ka gouru 'i ano fainia na fafurongo nia ki. ");
INSERT INTO far_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ana kada nai, na Fafanga ana Daofa Liue na Jiu ki nia karangi na. ");
INSERT INTO far_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Sa Jesus ka ada kali nia, ma ka ada to'ona na okue baita 'asiana kera dao mai siana, ma ka fata 'uri fuana sa Filip, “'I fai ne kulu kai folia ta fanga fua ka bobola fuana kulu sangonia ana okue ne ki tafau?” ");
INSERT INTO far_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nia fata 'uri ana na ru ne fua ka ilito'ona sa Filip, sui boroi 'ana nia saitamana na ru ne nia kai sasia. ");
INSERT INTO far_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ma sa Filip olisia ka 'uri, “Ta ro talanga malefo boroi si bobola go fuana folilana fanga fua sae kera ka fanga tu'u boroi 'ada.” ");
INSERT INTO far_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ma te wane ana fafurongo nia ki sa Andru, na wanefuta sa Simon Pita, nia ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Te welewane nia 'i seki, ne too go ana ka lima fa beret fainia ro gwa ie ki. Boroi ma nia 'afitai ka bobola fuana wane 'oro ne ki.” ");
INSERT INTO far_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ma sa Jesus ka saea fuada ka 'uri, “Mulu saea fuana wane ki, kera gouru 'i ano.” 'I senai garasi nia 'oro 'asiana ana. Ma na wane ki tafau kera ka gouru 'i ano. Ma laona okue nai nia bobola fainia lima to'oni wane ki. ");
INSERT INTO far_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ma sa Jesus ka ngalia fa beret nai ki, ma ka tangoa God, ma ka tolingia fuana wane ki ne kera gouru 'i senai. Ma nia ka sasi 'urinai laugo ana gwa ie nai ki. Ma kera tafau kera ngali ka bobola fainia ne kera doria tafau. ");
INSERT INTO far_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ma kada kera abusu na, nia ka fata 'uri fuana fafurongo nia ki, “Mulu konia na ngingisi fanga ne ore, fua ne nao kulu si fali ta fanga.” ");
INSERT INTO far_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ma kera ka koni tafau ana, ma kera ka fafungua te akwala ma ro kukudu ki ana na ngingisi fanga ne ore ana na lima fa beret be kera 'anida ki. ");
INSERT INTO far_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ma ana kada ne wane ki kera ada to'ona fanadae ne sa Jesus nia sasia, kera ka fata 'uri, “Na Profet be nia kai dao mai laona molagali, mamana na ne!” ");
INSERT INTO far_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ma sa Jesus ka leka na kau 'ana taifili nia fasi kera 'uria na kula ne fane, sulia nia 'e saitamana kera karangi leka na mai fuana sumailana fua ne nia ka kingi fuada. ");
INSERT INTO far_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ma kada na sato karangi ka su na, na fafurongo nia ki kera ka koso na 'ada ninimana 'osi nai. ");
INSERT INTO far_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ma na rodo ka rodo na mai. Sa Jesus nao si dao 'ua siada. Ma kera ka taelia te baru, ma kera ka tofolo ana 'osi nai 'uria na mae fere kera saea ana 'i Kapaneam. ");
INSERT INTO far_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ma ka dao ana kada nai ne kuburu 'e dao mai, ma nanafo ka magara 'asiana. ");
INSERT INTO far_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ma ana kada kera faluta ka dao bolofainia ta lima naoma ta ono kilomita, kera ada kau, ma kera ka ada to'ona sa Jesus nia fali mai fafona 'osi, ma ka dao karangia na mai na baru. Ma na fafurongo nia ki kera ka mau 'asiana. ");
INSERT INTO far_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ma sa Jesus ka fata 'uri kau fuada, “Nao mulu si mau! Nau ga 'ana ne!” ");
INSERT INTO far_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ma kera ka eele fua ngalilana fai kera laona baru. Ma ana kada nai laugo, kera dao na ana mae fere ne kera leka 'uria. ");
INSERT INTO far_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","Ma kada nia dangi falu na mai, na wane 'oro ne kera to 'ua ana bali 'osi loko, kera nani 'uria sa Jesus ana kula be sa Jesus tangoa God fafia na fanga be ki, ma ka fi kwatea fuana wane 'oro be ki. Ma kera ka ada saitamana te baru ga 'ana ne to 'i senai. Ma kera ka susulia laugo ne sa Jesus nao si leka go fainia na fafurongo nia ki laona baru nai. Ma kera ka susulia laugo ne fafurongo nia ki kera leka ga 'ada taifilida. Ma tani baru dao mai fasia 'i Taebirias, kera leka mai, kera ka olo 'i senai. ");
INSERT INTO far_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma ana kada ne okue nai si ada to'ona na sa Jesus ma na fafurongo nia ki, kera taelia na baru ki, kera ka leka nani 'uria 'i Kapaneam. ");
INSERT INTO far_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ma kada kera dao to'ona ana bali 'osi nai, kera ka ledi 'uri ana, “Wane famanata, kada te go ne 'oe leka laugo mai 'i seki?” ");
INSERT INTO far_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ma sa Jesus olisida ka 'uri, “Ru mamana nau ku saea fua mulu, kamulu nani 'uri nau, sulia ne mulu 'ania fa beret be ki ma mulu ka abusu, ma nao lau sulia ne mulu malingainia na fadalana fanadae be nau ku sasia ki. ");
INSERT INTO far_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nao mulu si rao ulafu lau 'uria na fanga ne kai funu ga 'ana. Mulu kai rao lalau 'uria na fanga ne ka kwatea maurie firi fua mulu. Nau, na Wele nia Wane ne, nau kai kwatea fua mulu na fanga nai, sulia God na Maa nia kwatea nikilalae fuaku.” ");
INSERT INTO far_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nia ne wane ki kera ka ledi nia kera ka 'uri, “Na te ne kalu kai sasia fua kalu ka sasia na raoe ne God nia doria fua malu?” ");
INSERT INTO far_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ma sa Jesus olisida ka 'uri, “Na kwaidoria God nia 'uri: Mulu kai famamana na wane ne nia 'e kwatea mai.” ");
INSERT INTO far_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ma kera ka ledi lau 'uri ana, “Ta fanadae 'uta ne 'oe kai fulia, fua kalu ka ada to'ona ma kalu ka famamana 'oe? Ta te ne 'oe sasia? ");
INSERT INTO far_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Na koko kia ki kera 'ania na beret be kera saea ana ‘mana’ 'i laona lofaa 'eke'eke, dia be kera kedea na 'uri, ‘Sa Moses nia kwatea na beret fasia 'i langi fuada fua 'anilana.’” ");
INSERT INTO far_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ma sa Jesus ka fata 'uri fuada, “Ru mamana nau ku saea fua mulu, sa Moses nao lau be kwatea na beret fasia 'i langi fua mulu. Na Maa nau lalau ne kwatea na beret mamana fasia 'i langi fua mulu. ");
INSERT INTO far_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Na beret mamana ne God nia kwatea, nia na wane ne koso mai fasia 'i langi, ma ka kwatea na maurie fuana wane ki tafau laona molagali.” ");
INSERT INTO far_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ma kera ka fata 'uri fuana, “Wane baita 'ae, safali 'i ta'ena ka oli 'alaa, 'oe kwatea na beret ne fua malu.” ");
INSERT INTO far_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Sui sa Jesus ka fata 'uri, “Nau na ne beret ana maurie. Ma sa ti boroi 'ana ne ka leka mai siaku, nia 'afitai ka fiolo lau. Ma sa ti boroi 'ana ne ka famamana nau, nia 'afitai ka maeliku lau. ");
INSERT INTO far_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Iu, ma nau ku saea fua mulu ka suina, sui boroi 'ana ne mulu ka ada to'oku, nao mulu si famamana nau go. ");
INSERT INTO far_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Wane ki tafau go ne Maa nau nia kwateda fuaku, kera kai leka tafau go mai siaku. Ma sui boroi 'ana sa ti ne nia doria lekalae mai siaku, nao nau si noni'ela ana. ");
INSERT INTO far_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nia 'urinai, sulia nau ku koso mai fasia 'i langi, ka nao lau fua sasilana ru sulia kwaidoria nau ki talaku. Nau ku leka mai fuana sasilana lalau ru ne God doria, ma ka odu nau mai fuana. ");
INSERT INTO far_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Te ne God nia doria ne nau ku dau sulia na wane ki tafau ne nia kwateda fuaku, ma ta te ai boroi si naoana, fua ne ana maedangi 'isi nau ku fi taeda 'uria na maurie firi. ");
INSERT INTO far_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","God na Maa nau nia doria sa tifaida ne kera ada saitamaku, ma kera ka famamana nau, kera ka mauri firi. Ma nau kai taeda 'uria maurie ana maedangi 'isi.” ");
INSERT INTO far_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ma na wane ki ka safali ngunungunu buri ani nia, sulia ne nia fata 'uri, “Nau na ne beret ne koso mai fasia 'i langi.” ");
INSERT INTO far_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ma kera ka fata 'uri fuada kwailiu, “Na wane ne sa Jesus na wele sa Josef ga 'ana ne, ma kulu saitamana ga 'akulu ana maa nia, ma na gaa nia. Ma 'uta ne nia saea sae nia koso mai fasia 'i langi?” ");
INSERT INTO far_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ma sa Jesus ka olisida ka 'uri, “Mulu kai sui fasia na ngunungunue 'i safitamulu. ");
INSERT INTO far_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Maa nau ne odu nau mai. Ma taifilia go na wane ne Maa nau talaida mai 'uri nau ki ne kera kai leka mai siaku. Ma nau kai taeda 'uria maurie ana fa dangi 'isi. ");
INSERT INTO far_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na profet ki kera kekede kera ka 'uri, ‘God nia famanata na wane ki tafau go.’ Ma sa ti boroi 'ana ne ka rongoa na Maa, ma ka ngalia na saitamarue fasi nia, kera ka leka mai siaku. ");
INSERT INTO far_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma nao ta wane si ada to'ona na Maa. Taifilia go na wane ne safali mai fasia God go ne nia ada to'ona na Maa. ");
INSERT INTO far_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ru mamana nau ku saea fua mulu, sa ti ne nia famamana nau, nia too ana maurie mamana ne nao si sui. ");
INSERT INTO far_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma nau na ne beret ana na maurie. ");
INSERT INTO far_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Na koko kamulu ki kera 'ania na beret be kera saea ana ‘mana’ laona lofaa 'eke'eke, ma kera ka mae ga 'ada. ");
INSERT INTO far_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Boroi ma na beret ne koso mai fasia 'i langi, ta wane boroi 'ana ne nia 'ania, 'afitai nia ka mae. ");
INSERT INTO far_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ma nau na ne beret ana na maurie fasia 'i langi. Dia ta wane ka 'ania na beret ne, nia kai mauri firi. Ma na beret nai na ne fasiku, ne nau ku kwate fua wane ki laona molagali kera ka mauri suli nau.” ");
INSERT INTO far_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma na wane ki kera ka safali olisusu safitada kwailiu, ma kera ka fata 'uri, “Na wane ne kwate 'uta ana na fasina fua kulu ka 'ania ne?” ");
INSERT INTO far_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ma sa Jesus ka fata 'uri fuada, “Ru mamana nau ku saea fua mulu, dia nao mulu si 'ania na fasiku, ma nao mulu si kufia na 'abuku, nia 'afitai 'asiana mulu kai mauri firi. ");
INSERT INTO far_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ma sa ti ne ka 'ania na fasiku, ma ka kufia na 'abuku, nia ka too ana na maurie firi, ma nau kai taea ana fa dangi 'isi. ");
INSERT INTO far_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Sulia na fasiku na ne beret mamana, ma na 'abuku na ne ru ni kufilana mamana. ");
INSERT INTO far_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ma sa ti ne ka 'ania na fasiku, ma ka kufia na 'abuku, nia ka to tari aku, ma nau ku to tari ana. ");
INSERT INTO far_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","God ne kwatea maurie, nia ne kwate nau mai. Ma nau ku mauri laugo osingana. Ka 'urinai laugo sa ti ne kai 'ania fasiku, nia kai mauri laugo osingaku. ");
INSERT INTO far_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ma nia na ne beret ne koso mai fasia 'i langi. Ma nia nao si dia lau na beret be na koko kia ki, kera 'ania, ma kera ka mae na. Boroi ma sa ti boroi 'ana ne ka 'ania na beret ne, nia kai mauri firi.” ");
INSERT INTO far_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sa Jesus saea na ru ne ki kada nia famanata laona beu fuana folae 'i Kapaneam. ");
INSERT INTO far_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ma na fafurongo 'oro nia ki ne kera rongoa ru ne sa Jesus saea ki, ma kera ka fata 'uri, “Na famanatae ne nia 'afitai 'asiana. Nao ta wane si nonimabe go fua gwalingelana.” ");
INSERT INTO far_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ma sa Jesus ka saitamana na fafurongo nia ki kera ngunungunu buri ana sulia ru ne, ma nia ka fata 'uri fuada, “'Uri ma na fatae nai nia fali kamulu? ");
INSERT INTO far_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Nia 'uta dia ne mulu ada to'oku, na Wele nia Wane, nau ku oli 'uria na kula be nau ku to mai ana 'i nao? ");
INSERT INTO far_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Na ru ne kwatea na maurie ne na Anoeru Abu. Ma na nikilalae wane, nia ru 'o'oni ga 'ana. Ma na fatae ne nau ku saea fua mulu ki ne kwate mulu ka too ana na Anoeru Abu ne kwatea na maurie. ");
INSERT INTO far_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sui ka 'urinai boroi 'ana, tani wane amulu nao si famamana go.” Sulia safali 'ua na mai 'i nao, sa Jesus nia saitamana tafau na sa ti ada ne nao si famamana, ma sa ti ne kai kwate nia fuana malimae nia ki. ");
INSERT INTO far_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ma nia ka fata lau 'uri sulia ne tani wane ada nao si famamana, “Nia be nau ku saea na fua mulu ne nao ta wane si leka mai siaku, dia Maa nau nao si alamatainia fua nia ka leka mai siaku.” ");
INSERT INTO far_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ma safali ana kada nai, na fafurongo 'oro nia ki, kera leka 'e'ete na 'ada, ma kera nao si leka na fainia. ");
INSERT INTO far_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ma sa Jesus ka ledia na akwala ma ro wane fafurongo nia ki ka 'uri, “'Uri ma kamulu doria mulu kai leka laugo fasi nau?” ");
INSERT INTO far_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ma sa Simon Pita ka olisia ka 'uri, “'Aofia 'ae, 'urinai sa ti lau ne kalu ka leka siana? 'Oe na ne too ana na fatae ana na maurie firi ki. ");
INSERT INTO far_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma kalu famamana, ma kalu ka saitamana 'oe na ne Wane Abu ne 'oe leka mai fasia God.” ");
INSERT INTO far_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ma sa Jesus ka fata 'uri, “Nau ne nau ku fili kamulu na akwala ma ro wane ki. Ma sui boroi 'ana ka 'urinai, te wane ana kamulu nia dia na anoeru ta'a.” ");
INSERT INTO far_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ana kada sa Jesus nia fata 'urinai, nia fata sulia sa Jiudas, na wele sa Simon Iskariot. Sui boroi 'ana nia ta wane ana akwala ma ro fafurongo nia ki, nia kai kwatea sa Jesus fuana malimae nia ki. ");
INSERT INTO far_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma 'i burina ru ne ki, sa Jesus ka liu kalia ga 'ana mae fere 'i Galili ki, sulia nao nia si doria 'ua lekalae 'uria 'i Jiudea, sulia na fanaonao Jiu ki kera doria saungilana 'i senai. ");
INSERT INTO far_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma te fafanga Jiu ki nia karangi na. Ma na fafanga nai kera saea ana “Fafanga ana 'O'obe ki.” ");
INSERT INTO far_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Aia, na wanefuta sa Jesus ki, kera leka mai siana, ma kera ka fata 'uri fuana, “'Oe leka 'uria 'i Jiudea, fua 'oko fatainia lau tani fanadae, fua fafurongo 'oe ki kera ka ada to'ona. ");
INSERT INTO far_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Sulia dia ta wane nia doria na wane ki kera ka rongoa na satana ma kera ka saitamana, nao nia si sasi agwa ana ta ru. Dia 'oe sasia ru baita 'oro ki, nia lea fuana 'oe leka 'oko sasi fatai ana, fua ne na molagali tafau kera ka saitamana.” ");
INSERT INTO far_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Na wanefuta nia ki kera fata 'urinai fuana, sulia kera boroi nao si famamana nia laugo. ");
INSERT INTO far_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ma sa Jesus ka fata 'uri fuada, “Nao nia si dao 'ua ana kada fua nau leka. Boroi ma mulu saitamana mulu ka leka go 'amulu ana ta kada boroi 'ana. Na kada ki tafau nia bobola ga 'ana fua mulu. ");
INSERT INTO far_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Na wane laona molagali ne ki nao si too ana ta ru fua kera ka malimae amulu. Boroi ma nau ne, kera malimae aku, sulia nau ku sae fatai ana te ki ne kera sasia ka ta'a. ");
INSERT INTO far_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mulu leka 'amulu ana fafanga. Nau nao si leka go, sulia nia nao si dao 'ua ana kada nau.” ");
INSERT INTO far_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Nia fata 'urinai ka sui, ma nia ka to lau 'ana 'i Galili. ");
INSERT INTO far_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","'I burina na ai burina sa Jesus ki kera leka na 'ada ana fafanga baita nai 'i Jerusalem, sa Jesus ka leka 'i burida. Ma nia ka leka agwa ga 'ana, fasi ta wane ka saitamana. ");
INSERT INTO far_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ma na fanaonao Jiu ki, kera ka nani 'uria laona fafanga nai, ma kera ka ledi 'uri ana wane ki, “Na wane be nia na 'i fai?” ");
INSERT INTO far_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ma wane 'oro 'asiana, kera faorai agwa suli nia. Tani wane kera fata 'uri, “Nia wane lea be.” Boroi ma tani wane kera ka saea, “Nia sasia wane 'oro fua kera leka sulia sukee nia ki.” ");
INSERT INTO far_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sui boroi 'ana kera ka fata 'urinai, nao ta wane ada si fata tafa go ana manatalae kera ki sulia sa Jesus, sulia kera mau ana fanaonao Jiu ki. ");
INSERT INTO far_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Burina tani maedangi, kada kera karangi dao na tofungana fafanga ne, sa Jesus nia ka leka laona Beu Abu God ma ka famanata wane ki. ");
INSERT INTO far_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ma na wane fanaonao ki, kada kera rongoa, kera ka kwele 'asiana ana famanatae nia. Ma kera ka 'uri, “Wane ne nao si rongo ru go mai ana ta fere. Ma 'uta ne nia ka saitamana ru ki tafau?” ");
INSERT INTO far_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ana kada sa Jesus nia rongo kera, nia ka olisida ka fata 'uri, “Famanatae nau 'e nao lau na ru nau, nia na ru God 'ana ne nia odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ti ne doria ka sasia na kwaidorie God, nia kai saitamana te ne nau ku famanata ana fuana wane ki, dia nia leka mai fasia God, naoma na manatalae nau ki ga 'ana talaku ne nau ku farongo ana. ");
INSERT INTO far_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Dia wane nia farongo ga 'ana ana ru sulia na manatalae nia ki talana, nia doria ga 'ana fuana wane ki ka tango nia. Boroi ma na wane ne nia doria wane ki kera ka tangoa na wane ne nia odu nia mai ne na wane mamana, ma nao nia si saitamana sukee.” ");
INSERT INTO far_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Sui sa Jesus ka fata lau 'uri, “Sa Moses be kwatea taki ki fua mulu. Ma nao ta wane amulu si sasi go sulia taki nai ki. Ma 'uta ne mulu dori kai saungi nau?” ");
INSERT INTO far_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ma na wane ne kera oku ana kula nai, kera ka fata 'uri, “'Oe nena na anoeru ta'a nia to amu! Sa ti ne doria ka saungi 'oe?” ");
INSERT INTO far_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Sa Jesus olisi kera ka 'uri, “Nau ku gura te wane ana Sabat, ma mulu ka kwele 'asiana ana. ");
INSERT INTO far_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","23","Ma mulu saitamana sa Moses kwatea te taki fua mulu, fua ka welewane kamulu ki kera ka 'ole 'unge. (Ma nao lau sa Moses ne etangia, boroi ma na koko kamulu ki lalau mai 'i nao.) Sulia dia kada lea fua mulu ka 'ole 'unge ana wele kamulu ki nia fuli na ana na Sabat, mulu ka sasia, sui boroi 'ana ana Sabat fua ne mulu si 'oia na taki sa Moses sulia 'ole 'ungelae. Dia nia lea fuana mulu ka 'ole 'unge ana Sabat, ma 'uta mone ne mulu ka guisasu fuaku kada be nau gura na wane be ana Sabat? ");
INSERT INTO far_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nao mulu si keto nau lau sulia na manatae wane ana ru kamulu ada to'ona go 'amulu 'i maa ki. Boroi ma mulu kwaiketoi lalau ana 'o'oloe.” ");
INSERT INTO far_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ma tani wane 'i Jerusalem kera ka fata 'uri, “Na wane ne go be wane fanaonao ki kera doria saungilana! ");
INSERT INTO far_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ada basi! Wane ne nia fata fatai ga 'ana, ma nao kera si olisia nia go ana ta ru. Alamia kera saitamana nia na Christ, na wane be God filia fua famaurilana wane ki 'oto ne? ");
INSERT INTO far_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Boroi ma kada na Christ kai leka mai, nao ta wane si saitamana na kula ne nia leka mai fasia. Ma na wane ne, kulu saitamana go 'akulu na kula ne nia leka mai fasia.” ");
INSERT INTO far_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Aia, ma ana kada nai, sa Jesus ka famanata na wane ki laona Beu Abu God. Ma nia ka fata baita ka 'uri, “'Uri ma mulu saitamana mamana aku, ma mulu ka saitamana kula ne nau ku leka mai fasia? Boroi ma nao nau si leka mai ana na mamanae nau talaku! Ma na wane ne nia odu nau mai, nia saea ru mamana ki tafau, ma nao mulu si saitamana go nia. ");
INSERT INTO far_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Boroi ma nau ku saitamana, sulia nia ne odu nau mai, ma nau ku leka mai fasia.” ");
INSERT INTO far_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ana kada nai, wane fanaonao ki kera doria daulana, boroi ma ka 'afitai, sulia kada nia nao si dao 'ua fua kera ka sasi 'urinai ana. ");
INSERT INTO far_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sui boroi 'ana kera ka doria sasilana na ru nai, 'orolana wane laona okue nai kera famamana nia. Ma kera ka fata 'uri, “Taifilia na Christ go ne saitamana ka fulia na fanadae ne nia fulida ki.” ");
INSERT INTO far_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ma kada ne Farasi ki kera rongoa wane ki kera kwalaro 'ada 'urinai sulia sa Jesus, kera fainia na fataabu baita ki, kera ka kwatea kau tani wane folo ne kera folo 'afia Beu Abu God, fua ne kera ka daua ana kada nai. ");
INSERT INTO far_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ma sa Jesus ka fata 'uri, “Nau kai to ga 'aku fai kamulu sulia ka kada kokoru, ma nau kai oli laugo 'aku siana na wane ne nia odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Sui mulu kai nani 'uri nau, ma kai 'afitai fua mulu ka dao to'oku. Sulia nia 'afitai fua mulu ka dao ana kula ne nau kai to ana.” ");
INSERT INTO far_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ma na fanaonao Jiu ki ka ledi kera kwailiu 'uri, “Wane ne kai leka 'uria 'i fai ne nao kulu si ada to'ona? 'Uri ma nia ka leka 'uria fere wane ne kera nao lau Jiu, na kula ne tani wane akulu kera to mai ana, fua ne ka famanata kera tafau? ");
INSERT INTO far_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ma nia ka saea laugo kulu kai nani 'uria, ma nao kulu si ada to'ona, sulia nao kulu si saitamana daolae ana kula ne nia kai to ana. Aia, ma na te ne to laona manatana ana kada nia fata 'urinai?” ");
INSERT INTO far_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aia, ma ana maedangi 'isi ana fafanga ne, nia fa dangi 'initoa 'asiana. Ma ana fa dangi nai, sa Jesus tatae ka uu, ma ka fata baita ka 'uri, “Sa ti boroi 'ana ne nia maeliku, nia leka mai siaku ka ku 'ana. ");
INSERT INTO far_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ma sa ti boroi 'ana ne famamana nau, nia kai dia te be na Kekedee Abu nia saea, ‘Na kafo mauri kai igwa mai fasia na maurilana.’” ");
INSERT INTO far_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ma sa Jesus ka saea ru ne, sulia na Anoeru Abu ne kai leka mai fua sa ti ne kera famamana. Aia ana kada nai, God nao si kwatea 'ua mai na Anoeru Abu siana sa ti ne kera famamana, sulia sa Jesus nao si ra 'ua fua ne ka oli 'uria laona 'initoe nia. ");
INSERT INTO far_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tani wane ana okue ne, kera rongoa fatalana sa Jesus, kera ka 'uri, “Wane ne nia na Profet 'initoa ne kulu makwalia!” ");
INSERT INTO far_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ma tani wane kera ka saea, “Nia na Christ, na wane be God filia fuana famaurilana wane ki!” Aia, ma tani wane lau, kera ka saea, “Na Christ nao si leka lau mai fasia 'i Galili! ");
INSERT INTO far_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Sulia na Kekedee Abu nia saea na Christ kai futa mai ana kwalafa sa Deved na kingi, ma ka futa 'i Betlehem, mae fere ne sa Deved nia baita laugo mai ana.” ");
INSERT INTO far_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ma na wane ne ki, kera nao si alua go te manatae sulia sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ma bali ana wane kera doria 'asiana kera ka daua sa Jesus, boroi ma nao ta wane si sasia go ta ru ana. ");
INSERT INTO far_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Na wane folo be ki kera nao si daua go sa Jesus, ma kera oli kau siana na fataabu baita ki, ma na Farasi ki. Ma kada kera dao na, na fataabu baita ki, ma na Farasi ki, kera ka fata 'uri, “'Uta ne nao mulu si ngalia mai?” ");
INSERT INTO far_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ma kera ka olisida 'uri, “Kalu kwele 'asiana ani nia, sulia nao ta wane si fata 'urinai dia nia.” ");
INSERT INTO far_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Na Farasi ki ka fata 'uri fuada, “Alami kamulu famamana laugo 'amulu ana sukee nia ki 'oto? ");
INSERT INTO far_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nao ta wane ana fanaonao kulu ki naoma ta Farasi, kera si famamana go ana! ");
INSERT INTO far_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Na okue nai ga 'ana ne kera famamana nia. Ma kera nao si saitamana go na taki sa Moses ki. Nia 'urinai ma God kai kwaeda.” ");
INSERT INTO far_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Aia, ma te wane ana na Farasi ki satana sa Nikodimas be nia leka mai siana sa Jesus 'i nao, nia ka fata 'uri fuana Farasi ki, ");
INSERT INTO far_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Na taki kulu ki be saea nao kulu si ketoa ta wane sulia dia nao kulu si rongo lea ana fatalana ka sui kulu fi ngalia mai fua ketolana.” ");
INSERT INTO far_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ma kera ka fata 'uri fua sa Nikodimas, “'Uri ma 'oe ta wane laugo fasia 'i Galili ne? Dia 'oe idumia lea ana Kekedee Abu, 'oe ada to'ona talamu. Nao ta profet si leka go mai fasia 'i Galili!” ");
INSERT INTO far_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aia, wane ki tafau kera oli na 'uria na lume kera ki. ");
INSERT INTO far_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Sa Jesus nia ra 'uria gwauna fa uo ne kera saea ana Olif. ");
INSERT INTO far_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma 'i 'ofodangi makalokalo ana fa dangi 'i buri, nia ka oli lau 'uria laona Beu Abu God. Ma na okue baita 'asiana, kera oku kali nia, ma nia ka gouru 'i ano, ma ka famanatada. ");
INSERT INTO far_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ma na wane famanata ana taki ki, ma na Farasi ki, kera ka ngalia mai te keni ne kera daua fainia oeelae. Ma kera ka fauua 'i nao ada. ");
INSERT INTO far_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ma kera ka fata 'uri fuana sa Jesus, “Wane Famanata 'ae, na keni ne kalu daua fainia oeelae. ");
INSERT INTO far_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Aia, ma 'i laona taki ne sa Moses nia kwatea fuaka ki, nia saea ne keni 'uri, kera 'ui fauna fua nia ka mae. Ma te na ne 'oe saea ana na keni ne?” ");
INSERT INTO far_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kera saea ru ne fua kera ka ilito'ona fua kera ka dao to'ona ta ru, fua kera ka fai fafia ana sa Jesus. Ma sa Jesus ka 'agwaoro 'i ano, ma ka kekede ana kakauna fafona saegano. ");
INSERT INTO far_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ma kada kera ledi ga 'ada, nia ka tatae, ma ka fata 'uri fuada, “Sa ti amulu ne nao si sasia ta ru ta'a, nia eta 'ui fauna.” ");
INSERT INTO far_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Sui, nia ka 'agwaoro lau, ma ka kekede lau fafona saegano. ");
INSERT INTO far_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ma kada kera rongoa ru ne, kera ka leka na 'ada, te te wanea, safali ana wane ngwaro ki. Ma kera ka fasia sa Jesus ka to na taifilia fainia na keni be ne nia uu ga 'ana 'i senai. ");
INSERT INTO far_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ma nia ka tatae uu 'o'olo, ma ka fata 'uri, “Keni ne 'ae, na wane be ki, kera na 'i fai? Nia 'uta? Nao ta wane ada si ore na fua ne nia keto 'oe?” ");
INSERT INTO far_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ma nia ka olisia ka 'uri, “Wane baita 'ae, nao na ta wane.” Ma sa Jesus ka fata 'uri fuana, “Ma nau boroi, nao nau si keto 'oe laugo. 'Oe leka na 'amu, ma safali ta'ena nao 'oe si sasia na ta ru ta'a lau.” ");
INSERT INTO far_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Sa Jesus ka fata lau 'uri fuana Farasi ki, “Nau ne na madakwalae fuana wane ki laona molagali ne. Wane ne nia leka mai suli nau, nao nia si liu laona rorodoe, boroi ma nia kai to ana madakwalae ne kwatea maurie.” ");
INSERT INTO far_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ma na Farasi ki kera ka fata 'uri fuana, “'Oe 'amu talamu ne 'oe farongo ani 'oe. Na fatalamu suli 'oe talamu nao si mamana.” ");
INSERT INTO far_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Sa Jesus ka fata 'uri, “Nao go. Sui boroi 'ana nau ku farongo ana nau talaku, te ne nau ku saea ki nia mamana, sulia nau ku saitamana kula ne nau leka mai fasia, ma 'i fai ne nau kai leka 'uria. Ma nao mulu si susulia go kula ne nau ku leka mai fasia, ma kula ne nau kai leka 'uria. ");
INSERT INTO far_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mulu ketoa ru ki sulia manatae wane laona molagali ga 'ana. Aia, ma nao nau si ketoa ta wane. ");
INSERT INTO far_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Boroi ma dia nau ku ketoa ta wane, nau ku keto sulia manatalae 'o'olo. Nau nao si ketoa ta wane taifili nau, karo tafau go Maa, wane ne nia odu nau mai ne rao fai nau. ");
INSERT INTO far_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na taki kamulu ki saea ka suina, dia ro wane ki keroa alangai fafia ta ru, te ne keroa saea nia mamana. ");
INSERT INTO far_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Nau ku farongo ana nau talaku, ma na Maa ne nia odu nau mai laugo ne 'e farongo ani nau.” ");
INSERT INTO far_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Sui, kera ka ledia sa Jesus kera ka 'uri, “'Uri ma maa 'oe nia 'i fai?” Ma sa Jesus olisi kera ka 'uri, “Mulu nao si saitamaku naoma na Maa nau boroi. Dia kamulu saitamaku, mulu ka saitamana laugo na Maa nau.” ");
INSERT INTO far_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sa Jesus saea na ru ne ki ana kada nia famanata wane ki laona Beu Abu God, karangia kula na kufi ru fuana alulana malefo laona. Ma ana kada nai, nao ta wane si daua go, sulia nia nao si dao 'ua ana kada nia. ");
INSERT INTO far_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Sa Jesus ka fata 'uri lau fuada, “Nau kai leka, ma mulu kai nani 'uri nau. Ma mulu kai mae, ma God nao si manataluge go ana ta'alae kamulu ki. Ma nia 'afitai mulu ka leka ana kula ne nau kai leka 'uria.” ");
INSERT INTO far_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ma na fanaonao Jiu ki kera ka fata 'uri, “Nia saea nia 'afitai go kulu ka leka 'uria kula ne nia kai leka 'uria. 'Uri ma nia kai saungi nia 'ana talana 'oto?” ");
INSERT INTO far_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sa Jesus olisi kera ka fata 'uri, “Kamulu to go 'amulu lao fere ne 'i ano, boroi ma nau ku leka mai fasia 'i langi. Kamulu fasia na molagali ne, boroi ma nau nao lau fasia na molagali ne. ");
INSERT INTO far_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nia ne, nau ku saea ka suina mulu kai mae, ma God nao si manataluge ana ta'alae kamulu ki. Nia mamana na, dia nao mulu si famamana ne Nau Ne, God nao si manataluge ana ta'alae kamulu ki.” ");
INSERT INTO far_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Sui kera ledia kera ka 'uri, “'Uri ma 'oe sa ti ne?” Ma sa Jesus olisida ka fata 'uri, “Nau ne dia be nau ku eta saea na fua mulu laona famanatalae nau ki. ");
INSERT INTO far_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nau ku too ana na ru 'oro 'asiana ne nau saitamana nau ku fata sulia fuana ketolamulu. Wane ne nia odu nau mai, nia ne na wane mamana. Aia, ma te ne nia saea fuaku, nia ne nau ku saea fuana wane ki tafau.” ");
INSERT INTO far_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ma kera nao si susulia go ne sa Jesus nia fata sulia Maa nia mai 'i langi. ");
INSERT INTO far_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Nia ne, nia ka fata 'uri fuada, “Kada mulu kai alu nau, na Wele nia Wane, fafona 'airarafolo, mulu kai saitamaku ne ‘Nau Ne’. Ma ana kada nai, mulu kai saitamana ne nao nau si sasia ta ru sulia na manataku talaku. Boroi ma nau ku saea go ru ne Maa nia famanata nau ana, nia ne nau ku saea fua mulu. ");
INSERT INTO far_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Iu, na Maa ne nia odu nau na mai, nia ka to fai nau sulia dangi ki. Nao nia si lukasi nau, sulia nau ku sasia ru ne faeele nia ki sulia dangi ki.” ");
INSERT INTO far_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ma wane 'oro ki kera ka famamana sa Jesus, kada kera rongoa nia saea ru nai ki. ");
INSERT INTO far_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Sui sa Jesus ka fata 'uri fuana wane ne kera famamana nia ki, “Dia mulu kai sasi sulia na famanatae nau ki, mulu na wane fafurongo mamana nau ki na. ");
INSERT INTO far_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ma mulu kai saitamana ru mamana ki sulia God, ma na ru mamana sulia God ki ne kwatea mulu ka to aluge.” ");
INSERT INTO far_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Kera olisia sa Jesus, kera ka 'uri, “Kalu na wane ana kwalafa sa Abraham ki na. Nao kalu si rao 'o'oni lau fuana ta wane. 'Uta ne 'oe saea kalu kai to aluge?” ");
INSERT INTO far_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sa Jesus ka fata 'uri lau fuada, “Ru mamana nau ku saea fua mulu. Wane ne kera rosulia na falafala ta'a ki, na falafala ta'a nai ki ne gwaungai fafida, ma kera ka rao 'o'oni na 'ada 'i farana. ");
INSERT INTO far_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na wane ne nia to aluge, nia ne na wane ne nia futa ana kwalafa, ma ka too ana mamanae fuana to firi laona lume maa nia. Ma na wane ne ka rao 'o'oni ga 'ana, nia nao si to mamana ana kwalafa. ");
INSERT INTO far_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Nia ne, dia nau, na Wele God, nau ku fasakwadola kamulu, mulu fi aluge mamana. ");
INSERT INTO far_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nau ku saitamana kamulu na wane ana kwalafa sa Abraham. Sui boroi 'ana, mulu doria saungilaku, sulia nao mulu si doria go sasilae sulia na famanatae nau ki. ");
INSERT INTO far_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nau ku fata sulia te ne Maa nau nia fatainia fuaku. Aia, ma mulu ka sasia te ki ne maa kamulu nia saea fua mulu.” ");
INSERT INTO far_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Kera olisia sa Jesus kera ka 'uri, “Maa kalu na ne sa Abraham!” Sa Jesus ka 'uri fuada, “Dia kamulu na kwalafa sa Abraham ki mamana, mulu ka sasia laugo na ru ne nia sasida ki. ");
INSERT INTO far_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Aia, ma nau ku saea go 'aku ru mamana ne nau ku rongoa na mai fasia God fua mulu. Boroi ma mulu ka doria go 'amulu saungilaku. Boroi ma sa Abraham nao si sasia go ta ru 'urinai. ");
INSERT INTO far_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mulu sasia go 'amulu na ru ne maa kamulu nia sasia ki.” Kera ka fata 'uri fuana, “Taifilia God go ne Maa kalu, ma kalu ne na wele mamana nia ki.” ");
INSERT INTO far_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sa Jesus olisida ka fata 'uri, “Dia God ne maa kamulu mamana, mulu ka kwaimani aku, sulia ne nau ku leka mai fasia God, ma nau ku to fai kamulu 'i seki. Nao nau si leka mai sulia na mamanae nau talaku. God ne odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","'Uta ne nao mulu si rongo saitamana fatalaku? Nia 'urinai sulia nao mulu si doria go rongolana. ");
INSERT INTO far_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Aia, ma kamulu na, na maa kamulu na ne sa Saetan. Nia ne, mulu ka doria sasilana ru ki dia laugo ne nia sasida. Sa Saetan ne nia na wane fuana sauwanee, sulia nia safali ka sasia 'ua na mai. Ma nia ka ulafusia na mamanalae, sulia nao nia si too ana ta te ne mamana ani nia. Kada nia suke 'ana ta wane, na falafala nia na nai, sulia nia ne wane fuana sukee na, ma nia ne na maa wane suke ki tafau. ");
INSERT INTO far_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ma ru mamana nau ku saea fua mulu, ru nai ne sasia nao mulu si doria go famamanae aku. ");
INSERT INTO far_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ma sa ti amulu ne saitamana ka fatainia na te ne nau ku sasia ka ta'a ana? Nao! Aia, ma 'uta ne nao mulu si famamana nau, kada nau ku saea ru mamana ki fua mulu? ");
INSERT INTO far_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Aia, sa ti ne kera safali mai siana God, kera saitamana ka rongo sulia na fatalana. Ma kamulu ne, nao mulu si safali mai ana God. Ma nia ne sasia nao mulu si fafurongoa.” ");
INSERT INTO far_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sui, kera ka fata 'uri fuana sa Jesus, “Na ru be kalu saea suli 'oe nia mamana be kalu saea 'oe wane fasia Samaria, ma 'oko too ana na anoeru ta'a.” ");
INSERT INTO far_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Sa Jesus olisida ka fata 'uri, “Nao go, nao nau si to ana ta anoeru ta'a. Ma nau ku fa'initoa na Maa nau, boroi ma nao mulu si fa'inito nau go. ");
INSERT INTO far_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma nao nau si doria go ne na wane ki ka fa'initoa nau. Maa nau lalau ne nia doria fuana wane ki kera ka fa'initoa nau. Ma nia laugo ne kai kwaiketoi ana 'o'oloe. ");
INSERT INTO far_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ru mamana nau ku saea fua mulu, sa ti ne nia sasi sulia famanatae nau, nao nia si mae.” ");
INSERT INTO far_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Sui kera olisia sa Jesus kera ka fata 'uri, “Kalu fi saitamamu, ne 'oe too ana anoeru ta'a! Sulia koko kia sa Abraham nia mae na, ma na profet ki laugo kera ka mae. 'Uta ne 'oe saea dia wane sasi sulia famanatae 'oe, nao nia si mae? ");
INSERT INTO far_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Koko kia sa Abraham nia na wane 'initoa, boroi ma nia mae na. Ma 'oe ne, 'oe kwaisae 'oe 'initoa ka liufia sa Abraham? Ma na profet ki laugo be kera mae na. 'Urinai ma 'oe sae 'oe mone ana sa ti?” ");
INSERT INTO far_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Sa Jesus ka olisida ka 'uri, “Dia nau ga 'ana ne nau fa'initoa nau talaku, 'urinai 'initoe nau nia ru 'o'oni ga 'ana. Aia, ma na wane fua ka fa'initoa nau ne Maa nau ne mulu saea nia ne God kamulu. ");
INSERT INTO far_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Sui boroi 'ana, nao mulu si saitamana go God. Ma nau ku saitamana nia. Boroi ma dia nau ku saea nao nau si saitamana, nau ku dia laugo kamulu ne mulu saitamana 'asiana ana sukee. Aia, ma nau ku saitamana lea 'asiana ana, ma nau ku sasi sulia fatalana. ");
INSERT INTO far_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ma na koko kamulu sa Abraham nia eele 'asiana, sulia nia ada to'ona na daolaku mai. Ma nia ka ada to'ona na, ma ka eele 'asiana sulia.” ");
INSERT INTO far_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ma kera ka fata lau 'uri fuana, “Lima akwala fangali ki si sui 'ua fafia futalamu, ma 'oko saea 'oe ada to'ona sa Abraham?” ");
INSERT INTO far_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Sa Jesus olisida ka fata 'uri, “Ru mamana nau ku saea fua mulu: Kada sa Abraham nao si futa 'ua, Nau Ne, nau ku to na.” ");
INSERT INTO far_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ana kada nai, kera ngalia na fau ki fua 'uilana, sulia nia fata 'urinai. Sui, nia ka agwa na fasi kera, ma ka leka na fasia na Beu Abu God. ");
INSERT INTO far_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Kada sa Jesus nia liliu 'ana, nia ka ada to'ona te wane ne maana rodo safali na mai ana kada nia futa ana. ");
INSERT INTO far_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ma na fafurongo nia ki kera ledi nia 'uri, “Wane Famanata 'ae, na ta'alae sa ti ne sasia na maana wane ne ka rodo safali na mai ana futalana? Na abulo ta'alae nia 'ana talana naoma na abulo ta'alana na maa nia ma na gaa nia?” ");
INSERT INTO far_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ma sa Jesus ka olisida ka 'uri, “Na maa rodo ne saungia, nao lau sulia na abulo ta'alae nia 'ana talana, ma nao lau na abulo ta'alana na maa nia naoma gaa nia. Na maana 'e rodo fua ne mulu kai ada to'ona na nikilalae God ne rao ani nia. ");
INSERT INTO far_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ana kada nia dangi 'ua, kulu kai sasia na raoe God ne nia kwate nau mai fuana. Sulia na rodo nia karangi na, kada be nao ta wane si rao na. ");
INSERT INTO far_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Kada nau ku to 'ua 'i laona molagali, nau ne na madakwalae fuana wane ana molagali.” ");
INSERT INTO far_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ma burina sa Jesus nia saea ru ne, nia ka ngisu laona ano, ma ka mukia mamako ana ngisuna, ma ka usua ana na maana na wane nai. ");
INSERT INTO far_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ma sa Jesus ka fata 'uri fuana, “'Oe leka 'oko taufia na maamu laona mae namo 'i Saelom.” (Sataeru ne, na fadalana ne, “Alungainia.”) Ma na wane nai leka ka taufia na maana, ma kada nia oli na 'i fera nia ka ada na. ");
INSERT INTO far_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ma na wane ana fere nia, ma na wane ne kera ada to'ona be nia gani ru ga 'ana 'i nao, kera ka ledida kwailiu, “Nia na wane be nia gouru ma ka gani ru ga 'ana ne?” ");
INSERT INTO far_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ma tani wane kera ka 'uri, “Nia na ne.” Ma tani wane lau kera ka fata 'uri, “Nao lau nia ne, boroi ma adalae to'ona dia na wane be.” Ma na wane nai 'ana talana ka fata 'uri, “Nau na wane be na ne.” ");
INSERT INTO far_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ma kera ka ledia, “'Uta ne na maamu ka 'ifi na 'urinai?” ");
INSERT INTO far_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ma nia ka olisida ka 'uri, “Na wane ne satana sa Jesus ne nia mukia mamako, ma ka usua ana maaku. Ma nia ka saea fua nau ku leka ku taufia na maaku laona mae namo 'i Saelom. Sui nau ku leka, ma kada nau ku taufia na maaku go ne maaku ka ada na.” ");
INSERT INTO far_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ma kera ka ledia lau 'uri ana, “Ma nia na 'i fai?” Ma nia ka olisida ka 'uri, “Nau ku ulafusia.” ");
INSERT INTO far_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ma 'i buri, kera ka talaia na wane be siana Farasi ki. ");
INSERT INTO far_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Aia, ma fa dangi nai sa Jesus saungainia na mamako ma ka gura na maana wane nai, nia na Sabat. ");
INSERT INTO far_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ma na Farasi ki kera ka ledia lau na wane nai, “'Uta ne nia sasia 'oko ada na.” Ma nia ka saea ka 'uri fuada, “Sa Jesus nia alua mamako fafia na maaku. Sui nau ku taufia na maaku, ma na maaku ka ada na.” ");
INSERT INTO far_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ma tani wane ada ne Farasi ki kera ka fata 'uri, “Na wane ne nia sasia ru ne, nao nia si leka lau mai fasia God, sulia nia 'oia na taki ana Sabat, ana guralana na wane ne ana Sabat.” Ma tani wane lau kera ka 'uri, “Nao, ma 'uta mone ne na wane abulo ta'a 'uri ka fulia na fanadae baita 'urinai ki?” Ma kera nao si 'ado go sulia na ru nai. ");
INSERT INTO far_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Sui Farasi ki kera ka ledi 'uri lau ana na wane nai, “'Oe saea sa Jesus ne gura na maamu, na te ne 'oe saea ana?” Ma nia ka 'uri, “Nia ta profet.” ");
INSERT INTO far_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ma na wane fanaonao ana Jiu ki, kera ka noni'ela ana famamanalana ne maana nia rodo na mai 'i nao. Ma kera ka saea mai na maa nia fainia gaa nia. ");
INSERT INTO far_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ma kera ka ledi keroa 'uri, “Na wele kamoro ne? Kamoro saea sae na maana nia rodo na, ana kada nia futa mai ana. Ma te ne sasia nia ka ada na ana kada ne?” ");
INSERT INTO far_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma na maa nia fainia gaa nia keroa olisida kera ka 'uri, “Karo saitamana nia na wele karo, ma karo ka saitamana ne maana nia rodo 'ua na mai kada nia futa ana. ");
INSERT INTO far_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Boroi ma karo ulafusia laugo te ne kwatea ma nia ka ada na, naoma sa ti ne ka 'ifingia maana. Mulu ledi nia na kau, sulia nia baita na, ma nia ka tala fata na 'ana talana!” ");
INSERT INTO far_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Na maa nia fainia gaa nia keroa saea ru ne sulia keroa mau ana wane fanaonao ana Jiu ki. Sulia kera alafafia ka suina, fua dia ta wane ne ka saea sa Jesus ne na Christ, na wane be God nia filia, kera nao si alamatainia ka ru laona beu fuana folae ki. ");
INSERT INTO far_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nia ne maa nia fainia gaa nia keroa ka saea, “Nia baita na. Mulu ledia na kau!” ");
INSERT INTO far_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Sui kera ka saea lau mai na wane be na maana nia rodo 'i nao, ma kera ka fata 'uri fuana, “'Oe fata alangai naona God ne 'oe saea na ru mamana ki! Kalu saitamana na wane ne nia na wane ta'a.” ");
INSERT INTO far_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ma na wane ne ka olisida ka 'uri, “Nau ku ulafusia nia na wane ta'a naoma ka nao. Te ru nau ku saitamana go 'aku ne 'uri, na maaku nia rodo 'i nao, boroi ma kada ne nau ku ada na.” ");
INSERT INTO far_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ma kera ka ledi lau 'uri ana, “Na te ne nia sasia amu? Ma nia ka gura 'uta ana maamu?” ");
INSERT INTO far_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ma na wane ne ka olisida ka 'uri, “Nau ku saea ka suina fua mulu be, boroi ma nao mulu si rongoa go. 'Uta ne mulu doria lau rongolana? Alamia mulu doria mulu ka famamana ma mulu ka leka laugo suli nia.” ");
INSERT INTO far_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Kera fata buri tolingai fuana ma kera ka 'uri, “'Oe ne wane fafurongo nia. Boroi ma kalu na wane fafurongo sa Moses ki lalau. ");
INSERT INTO far_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Sulia kalu saitamana God nia fata fuana sa Moses. Ma na wane ne, kalu ulafusia nia leka mai fasia 'i fai!” ");
INSERT INTO far_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ma na wane ne ka olisida ka 'uri, “Nau ku kwele 'asiana ana kamulu. Sulia nia 'ifingia na maaku, boroi ma mulu ka saea ne nao mulu si saitamana go 'amulu 'i fai ne nia leka mai fasia. ");
INSERT INTO far_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kulu tafau, kulu saitamana God nao si rongoa na wane ta'a ki. Nia rongoa lalau na wane ne kera fa'initoa ana ki, ma kera ka sasia na ru ne nia doria fua kera ka sasida. ");
INSERT INTO far_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ka safali 'ua na mai ana safalilana na molagali, nao kulu si rongoa 'ua ta wane ne ka 'ifingia maana ta wane ne rodo safali ana kada nia futa mai ana. ");
INSERT INTO far_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ma dia na wane ne nao si leka mai fasia God, nia 'afitai nia ka sasia ta ru 'urinai.” ");
INSERT INTO far_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ma kera ka fata 'uri fuana, “'Oe baita mai laona ta'alae safali na mai ana futalamu! 'Urinai 'oe nao si famanata kalu ana ta famanatalae” Sui kera ka tari nia fasia laona beu fuana folae ki. ");
INSERT INTO far_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Sui sa Jesus ka rongoa ne kera sasi 'urinai ana wane nai. Ma nia ka dao to'ona ma ka fata 'uri, “'Uri ma 'oe famamana na Wele nia Wane?” ");
INSERT INTO far_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ma na wane ne ka olisia ka 'uri, “Wane baita 'ae, 'oe farongo nau, nia sa ti nai, fua ne nau ku famamana nia?” ");
INSERT INTO far_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ma sa Jesus ka fata 'uri fuana, “'Oe ada to'ona ka suina, ma nia na ne 'oe fata fainia ana kada ne.” ");
INSERT INTO far_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ma na wane ne ka saea, “'Aofia 'ae, nau ku famamana 'oe.” Ma nia ka boruru 'i ano 'i naona 'aena sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Sa Jesus ka fata 'uri, “Nau ku leka mai fua nau tolingia wane ana molagali ana ro fikute wane ki. Ta fikute wane dia wane maa rodo ki sulia kera nao si saitamana ru mamana sulia God. Wane ne ki, nau ku kwatea kera kai ada saitamana ru mamana sulia God. Ma wane ne kera saea kera ada to'ona ru mamana ki sulia God, kera kai saitamana ne maada rodo mamana.” ");
INSERT INTO far_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ma tani wane ada Farasi ki ne kera to laugo 'i senai fainia, kera rongoa nia saea ru nai, ma kera ka ledia, “'Uri ma 'oe saea ne sae maamalu rodo laugo ne?” ");
INSERT INTO far_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ma sa Jesus olisida ka 'uri, “Dia maamulu nia rodo mamana, kamulu si garo go nai. Boroi ma kamulu saea ne mulu ada, ne fatainia mulu garo.” ");
INSERT INTO far_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Sa Jesus ka fata 'uri, “Ru mamana nau ku saea fua mulu, na wane ne nao si ru ana na mae ana na ba fua sipsip ki, ma ka ra go mai 'ana 'i burina na ba sipsip, nia na wane beli. ");
INSERT INTO far_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma na wane ne nia ru mai ana mae, nia na ne na wane mamana ne ka ada sulia na sipsip ki. ");
INSERT INTO far_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Na wane folo ana mae ka 'ifingia na mae ana ba fuana, ma na sipsip ki kera ka rongo saitamana na lingena, ma kera ka leka mai siana. Nia ka saea satana na sipsip nia ki, ma ka talaida 'i maa. ");
INSERT INTO far_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ma kada nia talaia na sipsip nia ki tafau 'i maa, nia eteta 'i naoda, ma kera ka leka 'i burina, sulia kera rongo saitamana na lingena. ");
INSERT INTO far_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma nia 'afitai kera ka leka 'i burina ta wane 'e'ete. Kera kai tafi fasia, sulia nao kera si rongo saitamana na lingena.” ");
INSERT INTO far_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ana kada sa Jesus nia fata ana na tarifulae ne fuada, kera nao si saitamana go na fadalana. ");
INSERT INTO far_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Nia ne, sa Jesus ka fata lau 'uri, “Ru mamana nau ku saea fua mulu, nau ne na mae fuana sipsip ki ka ru ana. ");
INSERT INTO far_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Na wane be kera dao mai 'i nao aku, kera dia na wane beli ki, ma na sipsip ki nao si ro go sulida. ");
INSERT INTO far_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Nau na ne mae fuana ba sipsip ki. Sa ti boroi 'ana ne nia ru mai ani nau, God kai famauria. Nia kai dia sipsip ne ru mai fua tolae, ma ka ru kau 'i maa fuana nani fangalae 'ana. ");
INSERT INTO far_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na wane beli nia leka go mai 'ana fua belilana sipsip ki, ma fuana falilada ma ka saungilada. Boroi ma nau ku dao mai fua ne mulu kai too ana na maurie ne nia lea ka tasa. ");
INSERT INTO far_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Nau na wane ne nia ada lea sulia sipsip ki. Ma nau ku nonimabe fuana maelae 'usia na sipsip nau ki. ");
INSERT INTO far_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma na wane ne nia rao go fuana folifolie, ma sipsip ki nao lau ru nia ki, kada nia ada to'ona na kui kwasi 'e leka mai, nia fasia na sipsip ki, ma ka tafi na 'ana. Ma na kui kwasi ka leka mai ma ka saungia na sipsip ki, ma ka takalongainida. ");
INSERT INTO far_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Na wane nai ka tafi na 'ana sulia nia rao ga 'ana fuana folifolie, ma nao nia si kwaimani go ana sipsip ki. ");
INSERT INTO far_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nau na wane ku ada lea sulia na sipsip ki, ma nau ku nonimabe fuana maelae 'usia na sipsip nau ki. Ma kera ka saitamaku, ma nau ku saitamada laugo, dia laugo ne Maa nia saitamaku, ma nau ku saitamana nia laugo. ");
INSERT INTO far_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ma tani sipsip aku laugo ne nao kera si to 'ua laona ba, nau kai ngalida laugo mai. Ma kera kai rongo saitamana lingeku. Ma kera kai 'ado laona te ba sipsip nau fainia na sipsip ne kera eta to na 'i seki. Nau kai ada sulida tafau. ");
INSERT INTO far_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Na Maa nia kwaimani aku, sulia nau ku nonimabe fua nau ku mae, fua ne nau ku mauri lau. ");
INSERT INTO far_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nao ta wane si saungi nau, dia nao nau si lukasia fuana. Ma nia na ne kwaidorie nau. Nau ku to ana nikilalae fuana kwatelaku talaku fuana maelae ma fuana maurie laugo. Na ru ne na Maa nau nia saea fua nau sasia nai.” ");
INSERT INTO far_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ma ana kada nai, wane Jiu ki kera nao si alua na te manatae sulia sa Jesus sulia ru ne nia saeda ki. ");
INSERT INTO far_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","'Orolada kera saea, “Wane ne nia oewanea, ma ka to ana anoeru ta'a. Nao mulu si rosulia!” ");
INSERT INTO far_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Boroi ma tani wane ada kera ka fata 'uri, “Na wane ne nia too ana anoeru ta'a, 'afitai nia ka fata 'uri! Ma na wane ne to ana anoeru ta'a, nia 'afitai ka gura wane maada rodo ki, ma kera ka ada lau!” ");
INSERT INTO far_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ana kada ana uni gwarie, na wane Jiu ki kera oku 'i Jerusalem fuana Fafanga ana Faabulana Beu Abu God. ");
INSERT INTO far_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ma sa Jesus ka to laugo laona Beu Abu nai, ma ka liu kwailiu ga 'ana laona Taofa sa Solomon. ");
INSERT INTO far_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Aia, kada wane ki kera ada to'ona, kera ka oku mai siana, ma kera ka ledia 'uri, “Kalu kwaimakwali ka tau 'asiana. 'Oe sae 'o'olo ana fua malu! 'Uri ma 'oe ne na Christ, na wane be God filia fua ka 'adomia na wane ki, naoma 'e nao?” ");
INSERT INTO far_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Sa Jesus olisida ka 'uri, “Nau ku saea fua mulu ka suina, boroi ma nao mulu si doria go famamana laku. Na raoe ne nau ku sasia ki, na Maa nau ne saea nau ku sasia, ma kera ka fatainia nau na. ");
INSERT INTO far_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Boroi ma mulu si famamana nau go, sulia ne kamulu nao lau na sipsip nau ki. ");
INSERT INTO far_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Na sipsip nau ki ne kera rongo saitamana na lingeku, ma nau ku saitamada, ma kera ka leka 'i buriku. ");
INSERT INTO far_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ma nau ku kwatea na maurie firi fuada, ma kera nao si mae. Ma ka 'afitai ta wane ka lauda fasi nau. ");
INSERT INTO far_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Na Maa nau ne kwatea na sipsip ne ki fuaku, nia 'e nikila ka liufia na ru ki tafau. Ma ka 'afitai ta wane ka laua na sipsip ne ki fasi nia. ");
INSERT INTO far_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nau fainia na Maa, karo te ru go.” ");
INSERT INTO far_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ma ana kada nai, na wane ki kera ka koni fau lau mai, fua kera ka 'uia sa Jesus ka mae. ");
INSERT INTO far_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ma sa Jesus ka ledi kera 'uri, “Kamulu ada to'ona ka suina raoe lea 'oro ne nau ku sasia fasia na Maa. 'Uri ma na raoe 'uta ana raoe ne ki ne mulu doria saungilaku fafia?” ");
INSERT INTO far_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ma kera olisia kera ka 'uri, “Kalu si 'ui 'oe lau fafia na raoe lea ne 'oe sasia ki. Kalu doria 'ui 'oe lalau fafia ne 'oe fata buri tolingai ana God. Sulia 'oe na wane ga 'ana, ma 'oko saea 'oe God!” ");
INSERT INTO far_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sa Jesus ka olisida lau ka 'uri, “Na fatae ki nia to na laona Kekedee Abu kamulu, God nia saea fuana fanaonao ki ka 'uri, ‘Kamulu na god ki.’ ");
INSERT INTO far_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ma kulu saitamana ru ki laona Kekedee Abu, nia mamana tafau na sulia kada ki. Ma God nao si garo kada nia fata fuana koko kia ki, ma ka saeda ana god ki. ");
INSERT INTO far_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ma nau na wane ne God nia fili nau, ma ka odu nau mai laona molagali ne. Ma 'uta ne mulu saea nau ku fata buri tolingai ana God, kada nau ku saea nau ana Wele nia God? ");
INSERT INTO far_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Dia nao nau si sasia raoe ne ki ne Maa nau doria fua nau ku sasida, nao mulu si famamana nau go. ");
INSERT INTO far_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Boroi ma sulia dia nau ku sasia na raoe ne na Maa nia doria ki, mulu ka famamana 'amulu ana raoe nai ki, sui boroi 'ana nao mulu si famamana ru ne nau ku saea fua mulu ki. Dia mulu sasia na ru ne ki, mulu kai saitamana lea ana ne na Maa nia 'ado aku, ma nau ku 'ado laugo ana na Maa.” ");
INSERT INTO far_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ma ana kada nai laugo, kera doria ka daua sa Jesus, boroi ma nia leka na 'ana fasida. ");
INSERT INTO far_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ma sa Jesus ka oli lau ana bali kafo 'i Jodan, ma nia ka to 'i senai ana kula be sa Jon nia siuabua wane ki ana 'i nao. ");
INSERT INTO far_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ma na wane 'oro 'asiana kera leka mai siana sa Jesus, ma kera ka fata fuada kwailiu kera ka 'uri, “Sa Jon nao si sasia go tani fanadae, boroi ma na ru ne nia fata sulida ki ana wane ne, nia mamana tafau go.” ");
INSERT INTO far_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ma na wane 'oro ki ana kula ne kera ka famamana sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Te wane satana sa Lasaros nia matai. Ma nia ka to ana fere 'i Betani fainia na ro waiwane nia ki, ni Mary ma ni Mata. Ni Mary nai be nia 'igitainia na ngwaingwai moko lea ana 'aena sa Jesus na 'Aofia, ma ka usua ana na ifuna. ");
INSERT INTO far_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ma na ro keni nai ki keroa kwate fatae 'uria sa Jesus keroa ka 'uri, “'Aofia 'ae, na wane ne 'oe kwaimani 'asiana ana nia matai.” ");
INSERT INTO far_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ma kada sa Jesus rongoa na ru nai, nia ka fata 'uri fuana fafurongo nia ki, “Sa Lasaros nao si mae ana mataie nai. Na mataie ne saungia fua ka fatainia na 'initoe God, ma fua wane ki ka fa'initoa nau, na Wele nia God.” ");
INSERT INTO far_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ma sa Jesus ka kwaimani 'asiana ana sa Lasaros, ma na ro waiwane nia ki ni Mata ma ni Mary. ");
INSERT INTO far_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","'Urinai boroi 'ana, kada sa Jesus nia rongoa sa Lasaros nia matai na, nia ka to lau 'ana ana kula nai nia to ana, sulia ro maedangi ki. ");
INSERT INTO far_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Sui sa Jesus ka fata 'uri fuana fafurongo nia ki, “Kulu oli lau 'uria 'i Jiudea.” ");
INSERT INTO far_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ma na fafurongo nia ki kera olisia kera ka 'uri, “Wane Famanata 'ae, nao nia si tau go be, na wane Jiu ki kera doria saungilamu ana 'ui fau lamu. Ma 'oe doria laugo 'oe oli lau 'i senai?” ");
INSERT INTO far_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ma sa Jesus ka fata 'uri, “Ana te fa dangi na sato ka sato safali 'i 'ofodangi leka ka dao 'i saulafi. Dia ta wane liu ana kada ne sato nia sato, 'afitai nia ka lakwadora, sulia nia ada to'ona na madakwalana molagali ne. ");
INSERT INTO far_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Boroi ma dia ta wane ka galo laona rodo, nia kai lakwadora, sulia nao ta madakwalae fuana.” ");
INSERT INTO far_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ma sa Jesus ka fata lau 'uri, “Na wane kwaimani be kulu sa Lasaros, nia maleu na, ma nau kai leka, fua ku faada.” ");
INSERT INTO far_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ma na fafurongo nia ki kera olisia kera ka 'uri, “'Aofia 'ae, dia ne nia maleu ga 'ana, nia kai lea go.” ");
INSERT INTO far_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Na fadalana na fatae sa Jesus saea sa Lasaros nia mae na. Boroi ma kera kwaisae nia maleu mamana ga 'ana. ");
INSERT INTO far_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nia ne, sa Jesus ka farongo madakwa ana fuada ka 'uri, “Sa Lasaros nia mae na. ");
INSERT INTO far_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Boroi ma fua lealae kamulu, nau ku eele ne nao nau si to fainia, fua ne mulu ka famamana nau. Aia, kulu leka siana.” ");
INSERT INTO far_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Sa Tomas (ne kera saea ana Na 'I'iu) ka fata 'uri fuana fafurongo ki, “Kulu leka 'akulu fainia na wane famanata, fua ne kulu ka mae laugo fainia!” ");
INSERT INTO far_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ma kada sa Jesus dao, fai maedangi ki ne suina 'i burina ne kera alua sa Lasaros laona faoda. ");
INSERT INTO far_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Na fere 'i Betani to karangia 'i Jerusalem, ka bobola fainia olu kilomita go. ");
INSERT INTO far_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ma wane 'oro 'i Jiudea ki kera dao mai siada ni Mata ma ni Mary, 'uria na gwale ladaro, sulia waiwane keroa nia mae. ");
INSERT INTO far_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ma kada ni Mata rongo sa Jesus nia dao mai, nia ka leka 'uri adalae to'ona. Boroi ma ni Mary ka to ga 'ana 'i lume. ");
INSERT INTO far_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ni Mata ka fata 'uri fuana sa Jesus, “'Aofia 'ae, dia sae 'oe to ga 'amu 'i seki, 'urinai na waiwane nau si mae go. ");
INSERT INTO far_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Boroi ma nau ku saitamana kada ne boroi 'ana, God saitamana ka kwatea ga 'ana ta te boroi 'ana ne 'oe gani 'uria.” ");
INSERT INTO far_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ma sa Jesus ka fata 'uri fuana, “Na waiwane 'oe kai mauri lau.” ");
INSERT INTO far_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ma nia ka fata fuana sa Jesus ka 'uri, “Nau ku saitamana nia kai mauri lau ana fa dangi 'isi.” ");
INSERT INTO far_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ma sa Jesus ka fata 'uri fuana, “Nau na ne taea wane mae ki, ma ku kwatea lau na maurie fuada. Sa ti boroi 'ana ne nia famamana nau, nia kai mauri lau, sui boroi 'ana nia ka mae na. ");
INSERT INTO far_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ma sa ti boroi 'ana ne kera famamana nau ki, kera kai too ana maurie firi, ma kera nao si mae. 'Uri ma 'oe famamana ru ne?” ");
INSERT INTO far_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ma nia ka olisia ka 'uri, “Iu 'Aofia. Nau ku famamana 'oe na ne na Christ, na Wele nia God ne nia leka mai laona molagali.” ");
INSERT INTO far_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ma burina ne ni Mata saea ru nai, nia ka oli, ma ka kwalaro fuana sasina nia ni Mary, ma ka fata 'uri fuana, “Na wane famanata dao na, ma nia doria ka ada to'omu.” ");
INSERT INTO far_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ma kada ni Mary nia rongoa ru ne, nia ka tatae, ma ka leka 'ali'ali siana. ");
INSERT INTO far_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ma sa Jesus nao si dao 'ua mai fere, boroi ma nia to 'ua ga 'ana mai ana kula be ni Mata nia dao to'ona ana. ");
INSERT INTO far_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ma na wane ki ne kera to 'i lume fainia ni Mary fuana gwalelana na manatana, kera leka laugo 'i buri'ana kada kera ada to'ona nia tatae ma ka leka 'ali'ali kau 'i maa. Kera kwaisae ne nia leka 'i maana na faoda gwau ne ka angi 'i senai. ");
INSERT INTO far_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ma kada ni Mary 'e dao ana kula ne sa Jesus nia to ana, nia ka ada to'ona, ma ka boruru 'i naona 'aena, ma ka fata 'uri, “'Aofia 'ae, dia 'oe to ga 'amu 'i seki 'urinai, na waiwane nau nao si mae go.” ");
INSERT INTO far_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ma sa Jesus ka ada to'ona ni Mary nia angi, ma na wane ki ne kera leka mai fainia kera angi laugo, ma nia ka kwaimanatai, ma manatana ka ta'a 'asiana. ");
INSERT INTO far_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ma sa Jesus ka ledi kera ka 'uri, “'I fai ne mulu alua ana?” Kera ka olisi 'uri ana, “'Aofia 'ae, leka mai, ma 'oko ada to'ona 'amu.” ");
INSERT INTO far_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ma sa Jesus ka angi. ");
INSERT INTO far_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ma tooa loko ki kera ka fata fuada kwailiu kera ka 'uri, “Mulu ada to'ona na kwaimanie baita nia fuana sa Lasaros!” ");
INSERT INTO far_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ma tani wane ada lau kera ka fata 'uri, “Nia gura na wane maada rodo ki. 'Uri ma nao nia si luia sa Lasaros fasia na maea?” ");
INSERT INTO far_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Sa Jesus ka kwaimanatai 'asiana lau, ma ka leka 'i maana na faoda gwau. Na faoda gwau nai, ne na faoda ne te gwa fau baita ne kera alua 'i maana. ");
INSERT INTO far_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ma sa Jesus ka fata totongai fuada ka 'uri, “Mulu gelusia na fau ne!” Ma ni Mata na waiwane na wane ne mae, ka olisia ka 'uri, “'Aofia 'ae, na fai maedangi ki ne suina 'i burina ne kera faitolia. Dao 'urinai, nia moko ngwa'a na!” ");
INSERT INTO far_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ma sa Jesus ka fata 'uri fuana, “Nau ku saea ka suina fuamu be dia 'oe famamana nau, 'oe kai ada to'ona na 'Initoe God.” ");
INSERT INTO far_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ma kera ka gelusia na fau nai. Sui sa Jesus ka ada 'alaa 'i langi ma ka foa 'uri, “Maasi 'ae, nau ku tangoa 'oe sulia 'oe fafurongo na mai fuaku. ");
INSERT INTO far_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nau ku saitamana ne 'oe rongo nau sulia dangi ki. Nau ku saea ru ne, fua ne wane ne ki kera ka famamana ne 'oe odu nau mai.” ");
INSERT INTO far_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ma 'i burina ne nia saea fatae nai, nia ka akwa baita ka 'uri, “Lasaros 'ae, 'oe ru mai 'i maa!” ");
INSERT INTO far_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ma na wane ne mae na ka mauri lau, ma ka ru na mai 'i maa. Ma na ro 'ae nia ki, ma na ro 'aba nia ki, kera 'afua ana na maku fuana 'afulana na wane mae ki, ma na maana kera 'afua laugo. Ma sa Jesus ka fata 'uri fuada, “Mulu lugea na maku ne ki fasia, ma mulu ka alamatainia nia leka ana.” ");
INSERT INTO far_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ma na wane 'oro ki ne kera dao mai siana ni Mary, kera ada to'ona ru ne sa Jesus sasia, ma kera ka famamana nia. ");
INSERT INTO far_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Boroi ma tani wane ada, kera oli siana Farasi ki, ma kera ka fata suli ru ne sa Jesus nia sasia. ");
INSERT INTO far_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ma na Farasi ki, ma na fataabu baita ki, kera ka oku lokoeru fainia na wane fanaonao ki, ma kera ka fata 'uri, “Te ne kulu kai sasia ana wane ne? Sulia ru fanadae 'oro ki na ne nia fulida. ");
INSERT INTO far_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ma dia kulu alamatainia wane ne ka sasi ga 'ana 'uri, na wane 'oro ki kera ka famamana. Sui, na wane gwaungai ki fasia 'i Rom, kera kai guisasu na fua kulu. Ma leka ka 'uri na, wane Rom ki kai okosia na Beu Abu God, ma kera ka falia na tooa kia!” ");
INSERT INTO far_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ma te wane ada satana sa Kaeafas na 'inita fataabu ana kada nai ka fata 'uri, “Nao mulu si susulia go ta ru! ");
INSERT INTO far_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tala'ana mulu saitamana ne nia lea go fuana te wane ne ka mae, fua ne kera nao si saungia wane ki tafau?” ");
INSERT INTO far_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aia, ma na fatae ne sa Kaeafas nia saea na, nao lau na ru 'i manatana taifilia. Sulia nia ne 'inita fataabu ana kada nai, ma nia ne God ka alua na manatalae nai 'i manatana. Ma fatae ne nia saea sulia sa Jesus kai mae fuana 'afilana wane Jiu ki. ");
INSERT INTO far_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ma nao nia si mae fuana wane Jiu ki go taifilida. Nia mae fuana wele God ki tafau ne kera to ana fere ki tafau, kera ka oku fainia na Jiu ki, fua ne ka alua te okue. ");
INSERT INTO far_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ma safali ana fa dangi ne sa Kaeafas nia saea fatae nai ki, na fanaonao Jiu kera safali loko manatae wane fua saungilana sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sulia ru nai, sa Jesus nao si liu fatai na ana bali lofaa 'i Jiudea. Ana kada nai, nia ka leka fasia kula nai, ma ka leka fainia fafurongo nia ki kera leka ka to ana fere 'i Efrem ne karangia na lofaa 'eke'eke. ");
INSERT INTO far_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ana kada nai, nia karangia na maedangi ana Fafanga ana Daofa Liue Jiu ki. Ma na wane 'oro ki kera ka leka kau 'uria 'i Jerusalem naona na Fafanga ne, fuana kwaifataboilada fuana fafanga sulia na falafala kera ki. ");
INSERT INTO far_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ma na wane ki kera ka nani 'uria sa Jesus. Ma ana kada nai, kera oku tafau mai laona Beu Abu God, kera ka ledi kera kwailiu kera ka 'uri, “'Uri ma kamulu fia nia kai dao mai ana na Fafanga ne? Alamia nao go 'oto!” ");
INSERT INTO far_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kera fata 'urinai sulia na fataabu baita ki, ma na Farasi ki, kera fata totongai siana wane ki 'uri, “Dia ta wane nia saitamana kula ne sa Jesus nia to ana, nia farongo kalu ana fua ne kalu ka daua.” ");
INSERT INTO far_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ma ono maedangi ki naona Fafanga ana Daofa Liue, sa Jesus fainia fafurongo nia ki kera oli lau 'uria 'i Betani, na mae fere sa Lasaros be sa Jesus nia famauria fasia na maea. ");
INSERT INTO far_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Kera sasi akau ana fanga ki fuana sa Jesus. Sa Lasaros ta wane laugo ana na wane ne kera laefida mai 'uria fanga fikulae fainia sa Jesus. Ma ni Mata ka ngali fanga mai fuada. ");
INSERT INTO far_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ma ni Mary ka ngalia mai te bi ngwaingwai ne kera saea ana “nad” ne folilana 'e baita 'asiana. Ni Mary ka ngalia mai ka 'igitainia 'i fafona 'aena sa Jesus fua fa'initolana. Sui ni Mary ka usua 'aena sa Jesus ana ifuna. Ma ana kada nai, na lume ne ka fungu ana moko na ngwaingwai moko lea ne. ");
INSERT INTO far_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Boroi ma sa Jiudas Iskariot, na fafurongo be kai kwatea sa Jesus fuana malimae nia ki, nia fata kau ka 'uri, ");
INSERT INTO far_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“'Uta nao nia si 'oifoli ana na ngwaingwai lea ne? Na ngwaingwai ne dia nia 'oifoli ana, nia kai ngalia malefo ne bobola fainia na folifolie ne te wane ka rao 'uria sulia te fangali. Ma malefo nai fulina nia ngalia ka kwatea fuana wane siofa ki.” ");
INSERT INTO far_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sa Jiudas nia saea na ru ne, nao lau sulia ne nia manata 'uria 'afilana wane ne kera siofa ki, boroi ma sulia lalau ne nia ta wane beli. Ma nia ne na wane fuana adalae sulia na ngwai malefo kera. Ma kada ki tafau, nia saitamana ka falia ga 'ana malefo ne fua nia talana. ");
INSERT INTO far_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ana kada nai, sa Jesus ka fata 'uri, “Mulu alua nia to 'ana! Nia konia 'ana na ngwaingwai ne fuana usulana noniku kada ana faitolilae. ");
INSERT INTO far_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma wane ne kera siofa ki, kera to ga 'ada fai kamulu sulia dangi ki. Boroi ma nao nau si to tau go fai kamulu.” ");
INSERT INTO far_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Wane 'oro ki kera rongoa sa Jesus nia to 'i Betani, ma kera ka leka mai siana. Kera si leka lau mai sulia sa Jesus taifilia go ne to 'i fere nai, boroi ma kera leka laugo mai fua adalae to'ona sa Lasaros wane be sa Jesus nia famauria fasia maea. ");
INSERT INTO far_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Ma na 'orolana wane Jiu ki, kera leka na fasia na fataabu baita ki, ma kera ka famamana na 'ada sa Jesus sulia nia famauria sa Lasaros fasia na maea. Nia ne, na fataabu baita ki kera ka lokoa laugo na saungilana sa Lasaros dia laugo ne kera lokoa saungilana sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Sui ana ruana maedangi, wane 'oro ne kera leka mai 'ana Fafanga ana Daofa Liue, kera rongoa sa Jesus ne karangi kai dao na 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kera leka, kera ka ngalia mai ulina niniu ki, ma kera ka leka mai fua kera ka dao to'ona sa Jesus. Ma kera ka akwa kera ka 'uri, “Tangoa God! God 'oe oilakitainia na wane ne nia leka mai ana na nikilalae 'oe! God kai falea na kingi kia 'i Israel.” ");
INSERT INTO far_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ana kada nai, sa Jesus ngalia te dongki, ma ka ra mai 'i fafona. Na ru ne nia famamana ga 'ana na ru be Kekedee Abu saea ka 'uri, ");
INSERT INTO far_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mulu wane 'i Jerusalem ki, nao mulu si mau! Mulu ada to'ona na kingi kamulu ne nia leka mai 'i fafona ka dongki.” ");
INSERT INTO far_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ma ana kada nai, na fafurongo ki kera nao si susulia 'ua na ru ne. Sui 'i burina ne sa Jesus nia mauri lau ma ka oli 'uria 'i langi, kera fi manata to'ona na Kekedee Abu sulia nia, ma na ru ne kera ka sasia ana. ");
INSERT INTO far_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Na wane ne kera to fainia sa Jesus ana kada nia saea mai sa Lasaros fasia laona faoda wane mae ma ka kwatea nia ka mauri lau, kera farongo ana ru nai fuana wane 'oro ki. ");
INSERT INTO far_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nia ne sasi ma wane 'oro ki ka leka mai, kera ka dao to'ona sa Jesus. Kera leka sulia kera rongoa tafau ne sa Jesus fulia na ru fanadae nai. ");
INSERT INTO far_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ma ana kada nai, na Farasi ki kera ka fata 'uri ada fuada kwailiu, “Mulu ada to'ona! Sui boroi 'ana kulu ka lokoa manatae wane 'oro ki, nia 'afitai na. Sulia wane 'oro ki kera leka na 'ada sulia na wane ne!” ");
INSERT INTO far_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tani wane ne nao lau Jiu ki, kera to laugo safitana na wane ne kera leka mai 'uria 'i Jerusalem fuana folae ana Fafanga ana Daofa Liue. ");
INSERT INTO far_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kera leka siana sa Filip, na wane fasia 'i Betsaeda laona lofaa 'i Galili, ma kera ka fata 'uri fuana, “Wane baita 'ae, kalu doria kalu kai ada to'ona sa Jesus.” ");
INSERT INTO far_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Sui sa Filip leka ka farongoa sa Andru, ma keroa leka ka farongoa sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ma sa Jesus olisida ka 'uri, “Na kada nia dao na fuana God ka fatainia na 'initoa laku, na Wele nia Wane. ");
INSERT INTO far_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ru mamana nau ku saea fua mulu. Dia ta te mege witi nia 'asia laona ano ma ka mae, na witi falu kai bulao ma nia kai too ana fueru witi 'oro. Boroi ma dia mege witi nai nao si 'asia laona ano ma ka mae, te mege witi go ne kai to taifilia. ");
INSERT INTO far_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ma dia ta wane ka manata baita ana na maurilana 'ana talana, nia kai mae ga 'ana. Boroi ma dia ta wane nao si ada baita ana maurilana laona molagali ne, nia kai too ana maurie firi. ");
INSERT INTO far_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ma ta wane boroi 'ana ne nia doria ka rao fuaku, nia ka leka suli nau, fua ne nia na wane rao mamana nau, ma ka to ana na kula ne nau ku to ana. Ma na Maa nau kai fa'initoa na wane ne nia rao fuaku. ");
INSERT INTO far_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ma na kada ne, na lioku nia isifufuli, ma ta te ne nau kai saea? Nau kai fata 'uri, ‘Maasi 'ae, 'oe si alamatainia kada ne ka dao mai fafi nau.’ Nao. Sulia nia na ne na ru ne nau ku leka mai fuana, fua ne nau ku liu ana kada ne ana na nonifilae. ");
INSERT INTO far_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Maasi 'ae, 'oe fa'initoa satamu.” Ma ana kada nai, te lingeru fatae ka fata mai fasia 'i langi ka 'uri, “Nau ku fa'initoa sataku, ma nau kai sasia lau.” ");
INSERT INTO far_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ma na okue ne kera uu 'i senai, kera rongoa na lingeru nai, ma tani wane ada ka saea ana gwa kukurue. Ma tani wane kera ka fata 'uri, “Ta 'ainsel nena fata mai fuana!” ");
INSERT INTO far_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Sui sa Jesus ka fata 'uri fuada, “Na lingeru ne nia fata mai, nao lau fuana 'adomilaku, boroi ma nia fata lalau mai fuana 'adomilamulu. ");
INSERT INTO far_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ma kada ne dao na fuana God ka ketoa na wane ki laona molagali ne. Ma ana kada ne, God ka liufia na sa Saetan, na wane gwaungai ana na molagali ne. ");
INSERT INTO far_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma ana kada kera kai lafutai nau ana 'airarafolo, nau kai talaia mai na wane ki tafau siaku.” ");
INSERT INTO far_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","(Ma ana na fatae ne ki, nia ka fatainia ga 'ana na maea 'uta ne nia kai mae ana.) ");
INSERT INTO far_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ma na wane ki kera ka fata 'uri, “Na Kekedee Abu kia nia saea ne na Christ kai mauri firi. 'Urinai ma 'uta 'oe saea kera kai lafutainia na Wele nia Wane ana 'airarafolo? Ma sa ti na ne na Wele nia Wane ne?” ");
INSERT INTO far_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Sa Jesus ka olisida ka 'uri, “Fua ka kada tu'u go ne madakwalae kai to fai kamulu. Nia ne mulu liu kwailiu 'amulu kada madakwalae nia 'ua fai kamulu fasia maerodo nia dao fafi kamulu. Wane ne nia leka laona maerodo nia ulafusia ga 'ana kula ne nia leka 'uria. ");
INSERT INTO far_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kada ne na madakwalae nia to 'ua fai kamulu, mulu famamana, fua ne kamulu na wele ana madakwalae ki.” Sa Jesus nia saea na ru ne ki, sui nia ka leka na 'ana, ma ka agwa na fasida. ");
INSERT INTO far_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Sui boroi 'ana sa Jesus ka sasia fanadae 'oro ki ma kera ka ada to'ona, kera nao si famamana nia go. ");
INSERT INTO far_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Na ru ne ki nia 'urinai, fua ka famamana na fatae sa Aesaea na profet be nia saea na mai 'i nao, be nia fata 'uri, “'Aofia, kera nao si famamana go ana fatae ne kalu 'ainitalo ana ki. Ma kera nao si ada saitamana laugo ana na nikilalae 'oe ne 'oe fatainia fuada.” ");
INSERT INTO far_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ma sulia kada ne kera nao si saitamana famamanalae ana, na fatalana God ne sa Aesaea na profet ne farongo 'ua na mai ana 'i nao ne nia fi mamana. ");
INSERT INTO far_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Laona Kekedee Abu, God nia fata 'uri, “Nau ku bokota na maada fua ne kera nao si ada to'ona te ne nau ku sasia fuada. Nau ku fangasia na manatalada fua ne kera nao si saitamana te ne nau ku sasia fuada. Nau ku sasi 'urinai ada fua ne kera nao si saitamana kari abulolae lau mai 'uri nau, fua nau kai famauri kera.” ");
INSERT INTO far_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Sa Aesaea ka saea ru ki sulia nia ada to'ona na 'initoe sa Jesus, ma nia ka fata sulia. ");
INSERT INTO far_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sui boroi 'ana ka 'urinai, wane fanaonao 'oro Jiu ki ne kera famamana sa Jesus. Boroi ma kera nao si fata go sulia fuana wane 'e'ete ki, sulia kera maungia na Farasi ki, fasia kera ka luida fasia rulae laona beu fuana folae kera ki. ");
INSERT INTO far_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kera manata 'abero 'asiana sulia sasilana ru fuana wane ga 'ana ne ka eele fafia. Boroi ma kera nao si manata 'abero go sulia sasilana ru fuana God ne nia eele fafia. ");
INSERT INTO far_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ma sa Jesus ka fata baita ma ka 'uri, “Dia ta wane boroi 'ana ne famamana nau, nia famamana laugo God ne odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ma dia ta wane nia ada to'oku, nia ada to'ona na God ne nia odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nau ku leka mai laona molagali ne dia madakwalae fuana wane ki, fua ne sa tifaida ne famamana nau, kera nao si to laona maerodo. ");
INSERT INTO far_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ma sa ti boroi 'ana ne ka rongoa fatalaku, ma nao si sasi sulia, nao nau si ketoa, sulia nao nau si leka lau mai laona molagali ne fuana kwaiketoilae. Ma nau ku leka lalau mai fuana famaurilana wane ki. ");
INSERT INTO far_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Wane nao si doria nau, ma nao si doria sasilana ru nau ku saea ki, na ru nia to na fuana ketolana na wane nai. Na fatae nau ki ne na ru ne kai ketoa nia ana maedangi 'isi. ");
INSERT INTO far_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na ru ne nia mamana, sulia kada nau ku fata ana, nao nau si fata sulia na ru sulia manatalaku talaku. Boroi ma Maa nau ne nia odu nau mai, nia saea fuaku na fatae totongai ki fua nau ku saea, ma nau ku fata sulida. ");
INSERT INTO far_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ma nau ku saitamana, na fatae totongai Maa nau ki ne kwatea mauri firi fuana wane ki. Ma na te ne nau ku saea, nia na ne ru ne Maa nau nia saea fuaku, fua ne nau ku 'ainitalo ania.” ");
INSERT INTO far_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Te fa dangi naona na Fafanga ana Daofa Liue, sa Jesus nia saitamana ne na kada nia 'e karangi dao na fua nia ka leka na fasia na molagali ne, ma ka leka siana Maa nia. Ma nia kwaimani fuana fafurongo nia ki ne kera to na laona molagali ne, ma nia kwaimani fuada leka ka dao ana kada nia mae. ");
INSERT INTO far_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ma sa Jesus fainia na fafurongo nia ki, kera fanga 'ada 'i saulafi. Ma sa Saetan ka alua na manatalae laona manatana sa Jiudas, na wele sa Simon Iskariot, fua ka kwatea sa Jesus fuana malimae nia ki. ");
INSERT INTO far_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ma sa Jesus ka saitamana ne Maa nia kwatea ka suina nikilalae ki tafau fuana. Ma nia ka saitamana laugo, ne nia leka mai fasia God, ma nia kai oli laugo siana God. ");
INSERT INTO far_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nia ne sa Jesus ka tatae fasia na tatafe ana fangalae, ma ka lugea na maku fafo nia, ma ka bitia na 'aba maku ni usu noni 'i salafana. ");
INSERT INTO far_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Sui nia ka 'igitainia kafo laona tiu, ma ka taufia na 'aena fafurongo nia ki, ma ka usua ana na 'aba maku ne nia bitia 'i salafana. ");
INSERT INTO far_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ma kada nia dao ana sa Simon Pita, nia ka fata 'uri fuana sa Jesus, “'Aofia 'ae, 'uri ma 'oe taufia laugo 'aeku ne?” ");
INSERT INTO far_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ma sa Jesus olisia ka 'uri, “Ana kada ne, 'oe ulafusia 'ua na ru ne nau ku sasia amu, boroi ma 'oe kai saitamana 'i buri.” ");
INSERT INTO far_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ma sa Pita ka fata 'uri, “Nau ne, nao 'asiana 'oe si taufia 'aeku!” Ma sa Jesus olisia ka 'uri, “Dia nau nao si taufia 'aemu, 'oe nao lau na fafurongo nau.” ");
INSERT INTO far_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ma sa Pita ka olisia ka 'uri, “'Aofia 'ae, nao 'oe si taufia lau 'aeku taifilia go. Boroi ma 'oe taufia laugo na 'abaku, ma na gwauku!” ");
INSERT INTO far_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sa Jesus ka fata 'uri, “Sa ti ne siu ka suina, na nonina nia falu tafau na, ma nao nia si siufia lau na nonina tafau. Nia ka taufia go na 'aena. Kamulu falu tafau na, boroi ma te wane go amulu ne nao si falu.” ");
INSERT INTO far_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Sa Jesus nia saitamana ka suina sa ti ne kai 'olomaelana fuana malimae ki, ma nia ne nia ka fata 'uri, “Kamulu falu tafau na, ma te wane go amulu ne nao si falu.” ");
INSERT INTO far_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ana kada sa Jesus nia taufia 'aeda ka sui, nia ka rufia lau na maku fafo nia sui, nia ka oli ka gouru fai kera. Ma nia ka ledida ka 'uri, “'Uri ma kamulu saitamana fadalana na ru ne nau sasia fua mulu? ");
INSERT INTO far_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Na fadalana nia 'uri: Kamulu sae nau ana wane famanata fainia na 'Aofia kamulu, ma ka bobola 'asiana fuana mulu ka sae nau 'urinai, sulia nau ne na wane famanata ma na 'Aofia kamulu. ");
INSERT INTO far_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma sui boroi 'ana nau na wane famanata ma na 'Aofia kamulu, nau ku fi taufia go na 'aemulu. Nia ne kamulu ka taufia 'aemulu kwailiu laugo. ");
INSERT INTO far_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nau ku sasia ru nai fua mulu fua ne kamulu laugo mulu kai sasia laugo dia ne nau ku sasia amulu. ");
INSERT INTO far_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ru mamana nau ku saea fua mulu, na wane rao nao nia si 'initoa ka liufia wane baita nia. Ma na wane ne ka ngali farongoa, nao si 'initoa liufia na wane ne odua. ");
INSERT INTO far_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mulu saitamana lea ana na ru ne nau ku saea fua mulu ki. Ma dia mulu kai sasi laugo sulia, mulu kai eele mamana. ");
INSERT INTO far_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Nau ku saea na ru ne ki nao lau fua mulu tafau. Nau ku saitamana ga 'aku sa tifaida ne nau ku filida. Ma nau ku saitamana te wane amulu kai 'olomaelaku fuana malimae nau ki, fua ne ka famamana Kekedee Abu be fata 'uri, ‘Na wane ne karo fanga oku, nia laugo ne na malimae nau.’ ");
INSERT INTO far_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Na ru ne nao si dao 'ua mai, ma nia lea fua nau ku saea fua mulu ana kada ne, fua dia ana kada nia dao boroi mai, mulu ka famamana ne Nau Ne. ");
INSERT INTO far_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ru mamana nau ku saea fua mulu, sa ti boroi 'ana ne kwaloa sa ti ne nau ku oduda kau, nia kwalo nau laugo. Ma sa ti boroi 'ana ne ka kwalo nau, nia kwaloa laugo God ne nia odu nau mai.” ");
INSERT INTO far_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Burina sa Jesus nia fata 'urinai ka sui, nia ka kwaimanatai 'asiana. Ma nia ka farongo madakwa na ana fuana fafurongo nia ki ka 'uri, “Ru mamana nau ku saea na fua mulu. Te wane amulu nia kai 'olomaelaku fuana malimae nau ki.” ");
INSERT INTO far_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ana kada nai, na fafurongo ki kera ka bubu kwailiu na fuada, sulia kera nao si saitamana sa ti ne sa Jesus nia fata sulia. ");
INSERT INTO far_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ma te wane ana fafurongo nia ki be sa Jesus nia kwaimani ana, nia ne gouru karangia sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ma sa Simon Pita ka fatai ana na 'abana fuana fafurongo nai, fua nia ka ledia sa Jesus 'uria sa ti ne nia fata sulia. ");
INSERT INTO far_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Na fafurongo ne ka 'idu karangia kau sa Jesus, ma ka kwalaro fuana ka 'uri, “'Aofia 'ae, sa ti ne na wane nai 'oe fata sulia?” ");
INSERT INTO far_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Sa Jesus ka olisia ka 'uri, “Na wane ne nau kai taufia na beret laona tiui sulu, ma nau ku kwatea fuana. Wane ne nau ku sasia ru nai fuana, nia na ne na wane nai.” Go sa Jesus nia taufia na beret laona tiui sulu, sui ka kwatea fuana sa Jiudas wele sa Simon Iskariot. ");
INSERT INTO far_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ana kada nai sa Jiudas nia ngalia na beret nai, sa Saetan ka rufia na. Ma sa Jesus ka fata 'uri fuana, “'Oe 'ali'ali fainia na ru ne 'oe sasia.” ");
INSERT INTO far_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ma na fafurongo ki ne kera gouru kalia na tatafe ni fanga nai, kera ka ulafusia te ne sa Jesus nia fata 'urinai ana fua sa Jiudas. ");
INSERT INTO far_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ma sulia sa Jiudas nia na wane ne ada sulia na ngwai malefo kera, tani wane ana na fafurongo ki kera kwaisae sa Jesus nia saea fuana sa Jiudas, ne nia leka ka folia mai tani fanga ne kera bobo 'uria fuana fafanga nai, naoma nia leka ka ngalia mai tani ru fua ne kera ka kwatea fuana wane siofa ki. ");
INSERT INTO far_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Burina sa Jiudas ngalia na fanga be, nia ka ru 'ali'ali na 'i maa. Ma ana kada nai nia 'e rodo na. ");
INSERT INTO far_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Kada sa Jiudas nia leka na, sa Jesus ka fata 'uri, “Kada fuana fa'initolaku, na Wele nia Wane, nia dao na. Ma God kai ngalia fa'initolae sulia ru ne fuli fuaku ki. ");
INSERT INTO far_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ma dia fa'initolana God kai fatai ani nau, 'urinai God na ne kai tala fatainia 'ali'ali na fa'initolaku ani nia talana. ");
INSERT INTO far_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Wele nau ki 'ae, nao nau si to tau go fai kamulu. Mulu kai nani 'uri nau, boroi ma nau ku saea na fua mulu na ru be nau ku saea na fuana wane fanaonao ana Jiu ki be 'uri, ‘'Afitai mulu kai leka ana kula ne nau ku leka ana.’ ");
INSERT INTO far_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ma na taki falu nau ku kwatea fua mulu ne 'uri: Mulu kai kwaimani amulu kwailiu, dia laugo ne nau ku kwaimani fua mulu. ");
INSERT INTO far_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ma dia mulu kai to ana na kwaimanie fua mulu kwailiu, na wane ki tafau kera kai saitamana ne kamulu na fafurongo nau ki.” ");
INSERT INTO far_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Sui sa Simon Pita ka ledia sa Jesus ka 'uri, “'Aofia 'ae, 'i fai ne 'oe kai leka 'uria?” Sa Jesus olisia ka 'uri, “Kula ne nau kai leka 'uria, nao mulu si saitamana lekalae fai nau 'uria. Boroi ma ta maedangi, mulu kai leka mai buriku.” ");
INSERT INTO far_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Sui sa Pita ka ledi lau ka 'uri, “'Aofia 'ae, te ne kai kwate ma ka 'afitai fua malu fuana lekalae fai 'oe ana kada ne? Sulia nau ku sasi akau na fuana maelae 'usi 'oe.” ");
INSERT INTO far_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Sa Jesus olisia ka fata 'uri fuana, “'Uri ma 'oe sasi akau mamana fuana maelae 'usi nau? Ru mamana nau ku saea fuamu. 'I naona na karai ka angi, 'oe tofe olu ru 'oe ulafusi nau.” ");
INSERT INTO far_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Sa Jesus ka fata 'uri fuana fafurongo nia ki, “Nao mulu si manata 'abero ma na manatalamulu si 'asia. Mulu famamana God, ma mulu ka famamana nau laugo. ");
INSERT INTO far_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Sulia kula 'oro ni tolae ki nia laona lume Maa nau. Aia, ma nau ku leka fua ne nau sasi akau ana kula fua mulu. 'Afitai nau ku saea na ru ne fua mulu, dia nao nia si mamana. ");
INSERT INTO far_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ma kada ne nau ku leka, ma ku sasi akau ana kula fua mulu, nau kai oli mai ma nau ku talai kamulu fuaku talaku, fuana kula ne nau kai to ana, mulu kai to laugo ana. ");
INSERT INTO far_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ma kamulu saitamana go 'amulu na taale ne leka 'uria na kula ne nau kai leka 'uria.” ");
INSERT INTO far_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ma sa Tomas ka fata 'uri, “'Aofia 'ae, kalu ulafusia na kula ne 'oe leka 'uria. 'Uri ma kalu kai saitamana 'uta ana na taale nai?” ");
INSERT INTO far_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ma sa Jesus olisia ka 'uri, “Nau na ne na taale fuana fatailana ru mamana sulia God, ma ka kwatea na maurie fuana wane ki. Nao ta wane si leka siana God na Maa dia nia nao si leka suli nau. ");
INSERT INTO far_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ma dia mulu saitamana mamana na aku, tama mulu saitamana laugo Maa nau. Safali ana kada ne ka oli 'alaa, kamulu saitamana na Maa nau, ma mulu ka ada to'ona na.” ");
INSERT INTO far_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ma sa Filip ka fata 'uri, “'Aofia 'ae, kalu doria 'oe fatainia basi na Maa fua malu.” ");
INSERT INTO far_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ma sa Jesus ka olisia ka 'uri, “Filip 'ae, nau ku to fai kamulu ka tau na, ma 'oe si saitamaku 'ua ne? Ma sa ti boroi 'ana ne nia ada to'oku, nia ada to'ona laugo na Maa. Ma 'uta ne 'oe saea fua nau ku fatainia na Maa fua mulu? ");
INSERT INTO far_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","'Uri ma nao 'oe si famamana go ne nau ku to ani na Maa, ma na Maa ka to ani nau laugo? Fata ne nau ku saea fua mulu ki, nao lau na fatae nau ki talaku. Na Maa ne nia to aku nia ne sasia na raoe nia ki ani nau. ");
INSERT INTO far_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mulu famamana ru ne, nau to fainia na Maa, ma na Maa ka to fai nau. Dia nao, mulu ka famamana sulia na raoe ne nau ku sasia ki. ");
INSERT INTO far_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ru mamana nau ku saea fua mulu, dia sa ti boroi 'ana ne famamana nau, nia kai sasia laugo na raoe ne nau ku sasia ki. Ma nia kai sasia lau na raoe baita ki, sulia ne nau ku leka siana na Maa. ");
INSERT INTO far_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ma ta te boroi 'ana ne mulu kai gania ana na Maa, sulia mulu na fafurongo nau ki, nau kai sasia, fua ne ana kada wane ki kera ada to'ona, kera ka ada saitamana na Maa ne talingai ka tasa. ");
INSERT INTO far_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ta te boroi 'ana ne mulu kai gani nia 'uria sulia mulu wane nau ki, nau kai sasia fua mulu.” ");
INSERT INTO far_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Sa Jesus ka fata lau 'uri, “Dia mulu kwaimani aku, mulu ka rosulia na taki nau ki. ");
INSERT INTO far_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nau kai gania na Maa, ma nia kai kwatea mai na Wane ni Kwai'adomi fua mulu, ma nia kai to tari fai kamulu. ");
INSERT INTO far_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nia na Anoeru Abu ne fatainia na mamanae sulia God. Ma na wane ne kera nao si famamana ki, kera nao si kwalo nia go, sulia kera nao si ada to'ona, ma kera nao si saitamana nia go. Boroi ma mulu saitamana nia na, sulia nia to fai kamulu, ma nia kai to laona maurilamulu. ");
INSERT INTO far_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Kada nau kai leka, 'afitai nau ku fasi kamulu dia na wele inomae ki. Nau kai oli laugo mai siamulu. ");
INSERT INTO far_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ana kada tu'u go, na wane ne kera nao si famamana, nao kera si ada to'oku lau. Boroi ma kamulu ne, mulu kai ada to'oku laugo amulu. Ma sulia nau ku mauri, mulu kai mauri laugo. ");
INSERT INTO far_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ma ana kada ne nau kai mauri lau, mulu kai saitamana ne nau ku 'ado ana na Maa nau, ma kamulu kai 'ado fai nau, ma nau ku 'ado fai kamulu. ");
INSERT INTO far_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Ma sa ti boroi 'ana ne rosulia na taki nau ki, nia ne na wane ne nia kwaimani aku Ma sa ti boroi 'ana ne kwaimani aku, Maa nau kai kwaimani laugo ana, ma nau boroi nau ku kwaimani laugo ana, ma nau ku fatai nau talaku fuana.” ");
INSERT INTO far_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Sa Jiudas (nao lau sa Iskariot) ka ledia ka 'uri, “'Aofia 'ae, 'uta ne kalu go ne saitamana kai ada to'omu, ma na wane ne kera nao si famamana kera nao si ada to'omu?” ");
INSERT INTO far_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Sa Jesus olisia ka 'uri, “Dia ta wane ne kwaimani aku, nia ka rosulia na famanatalae nau ki. Ma na Maa nau kai kwaimani ana, ma na Maa nau, karo ka leka mai siana, ma ka to fainia. ");
INSERT INTO far_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma sa ti boroi 'ana ne nao si kwaimani aku, nia si rosulia na famanatae nau ki. Ma na famanatalae nau ki ne mulu rongoa, nao lau na ru nau ki talaku. Sulia nia safali mai fasia na Maa, ne nia odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Nau ku saea na ru ne ki fua mulu ana kada nau ku to 'ua fai kamulu. ");
INSERT INTO far_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Na Maa nau kai kwatea mai na Anoeru Abu ana sataku, fua ne nia ka 'adomi kamulu. Nia kai famanata kamulu ana na ru ki tafau, ma ka famanata oli amulu ana na ru ki tafau ne nau ku farongo kamulu na ana 'i nao. ");
INSERT INTO far_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Nau ku fasia na aroaroe nau fua mulu. Na aroaroe nau ne nau ku kwatea fua mulu, nao nia si dia na aroaroe laona molagali. Nia ne, nao mulu si manata 'abero, ma nao mulu si mau. ");
INSERT INTO far_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Mulu rongoa tafau na fatalaku be 'uri, ‘Nau kai leka, ma nau kai oli laugo mai siamulu.’ Dia mulu kwaimani aku, mulu kai eele sulia nau ku leka siana Maa, sulia nia talingai 'asiana liufi nau. ");
INSERT INTO far_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nau ku saea na ru ne ki, sui nia ka fi dao mai, fua ne ana kada nia dao mai, mulu ka fi famamana. ");
INSERT INTO far_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nao nau si fata tau lau fai kamulu, sulia sa Saetan na wane gwaungai ana molagali ne, nia karangi dao na mai. Boroi ma nia nao si gwaungai fafi nau. ");
INSERT INTO far_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ma nau talaku, nau ku sasia ru ki tafau sulia te ne Maa nau nia saea fuaku fuana sasilana, fua wane ana molagali ne, kera ka saitamana ne nau ku kwaimani ana Maa nau. “Aia, kulu tatae, kulu ka leka na fasia kula ne.” ");
INSERT INTO far_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Sa Jesus ka fata 'uri lau fuana fafurongo nia ki, “Nau na ne 'inita grep mamana, ma na Maa nau ne wane rao ana na oole. ");
INSERT INTO far_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ma nia saitamana ka tofua na sara 'ai ki fasi nau ne kera nao si fungu, ma ka lufusia na sara 'ai ki ne kera fungu, fua ne kera ka fungu lea. ");
INSERT INTO far_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma kamulu falu tafau na ana na famanatalae nau ki fua mulu. ");
INSERT INTO far_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mulu kai 'ado fai nau, fua nau ku 'ado fai kamulu. Na sara 'ai nia 'afitai ka fungu 'ana talana, dia nao nia si 'ado ana na 'inita grep. Ma nia 'urinai laugo fua mulu, nia 'afitai mulu kai sasia na ru lea ki, dia nao mulu si 'ado aku. ");
INSERT INTO far_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nau na ne 'inita grep, ma kamulu na ne sara 'ai ki. Ma dia sa ti ne ka 'ado aku, nau ku 'ado ani nia, nia saitamana ka fungu ana fue grep 'oro ki. Ma dia nao mulu si 'ado aku, nia 'afitai mulu kai sasia ta ru lea. ");
INSERT INTO far_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma dia sa ti ne nao si 'ado aku, nia dia ta sara 'ai ne kera 'ui 'ania ma ka mae. Ma na sara 'ai 'urinai ki, kera ngalida, ma kera ka 'ui 'anida laona ere fua ka sungida. ");
INSERT INTO far_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ma dia mulu kai to 'ado aku, ma na fatalaku ka to ngado amulu, mulu kai gania ta ru boroi 'ana ne mulu doria, nau kai kwatea fua mulu. ");
INSERT INTO far_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ma na raoe lea 'oro ne mulu sasia, nia ka fatainia na 'initoe na Maa nau. Ma nia 'urinai ka fatainia laugo ne kamulu na fafurongo nau ki. ");
INSERT INTO far_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nau ku kwaimani amulu dia laugo Maa nau ne kwaimani aku. Nia ne, mulu kai 'ado laona kwaimanie nau. ");
INSERT INTO far_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ma dia mulu ka rosulia na taki nau ki, mulu kai 'ado laona kwaimanie nau, dia laugo ne nau ku rosulia na taki Maa nau ki, ma nau ku 'ado laugo laona kwaimanie nia. ");
INSERT INTO far_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nau ku saea ne mulu rosulia taki nau ki, ma mulu ka 'ado laona kwaimanie nau fua ne mulu kai to ana eele baita, dia laugo na eele nau, ma na eele kamulu ka nao si sui. ");
INSERT INTO far_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ma na taki nau fua mulu, nia 'uri: Mulu kai kwaimani amulu kwailiu, dia laugo ne nau ku kwaimani amulu. ");
INSERT INTO far_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nao ta kwaimanie si liufia na kwaimanie ne wane ka kwatea na maurilana fuana kwaimani nia ki, fua ne ka famaurida. ");
INSERT INTO far_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ma kamulu ne wane kwaimani nau ki, dia mulu sasia na ru ne nau ku saea fua mulu. ");
INSERT INTO far_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ma nao nau si sae kamulu lau ana na wane rao ki, sulia na wane rao nao si saitamana ru ne na wane gwaungai nia sasia. Nau ku sae kamulu ana na wane kwaimani nau ki lalau, sulia nau ku farongo kamulu na ana ru ki tafau ne nau ku rongoa mai fasia na Maa nau. ");
INSERT INTO far_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ma nao mulu si fili nau, nau lalau ne fili kamulu, fua ne mulu kai sasia na ru lea 'oro ki, dia na 'ai ne nia fungu ana fueru lea ki ne to firi. Ma na Maa kai kwatea ta te boroi 'ana ne mulu kai gani 'uria, sulia kamulu na fafurongo nau ki. ");
INSERT INTO far_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ma na taki nau fua mulu ka 'uri: Mulu kai kwaimani amulu kwailiu. ");
INSERT INTO far_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Dia na wane laona molagali ne kera subutai kamulu, mulu manata to'ona ne kera eta subutai nau laugo 'i nao. ");
INSERT INTO far_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Dia mulu to mala wane laona molagali ne, kera ka kwaimani amulu, sulia mulu dia kera laugo. Boroi ma nau ku fili kamulu tafau na, fua ne mulu ka 'e'ete fasia wane ta'a ki laona molagali. Nao mulu si to lau dia kera, ma nia ne sasia kera nao si dori kamulu. ");
INSERT INTO far_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mulu ka manata to'ona te ki be nau ku saea ka suina fua mulu, ‘Na wane rao nia nao si 'initoa ka liufia wane baita nia.’ Ma sulia ne kera famalagaigai nau, kera kai famalagaigai kamulu laugo. Ma tani wane kera rosulia na fatalaku, ma 'urinai tani wane kai ro laugo sulia fatalamulu. ");
INSERT INTO far_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ma kera kai famalagaigai kamulu, sulia ne kamulu na wane nau ki. Kera ka sasi 'urinai laugo sulia kera nao si saitamana God ne nia odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma dia nao nau si leka mai laona molagali, ma nao nau si farongo kera 'urinai, kera nao si 'eke go fafia ta'alae kera ki. Ma ana kada ne, nia 'afitai fua kera ka saea ne kera nao si garo sulia nau ku saea ka suina fuada. ");
INSERT INTO far_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma sa ti ne subutai nau, nia subutai laugo ana Maa nau. ");
INSERT INTO far_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma nau ku fulia na ru ne nao ta wane si fulia 'i nao. Kera ada to'ona ne nau ku fulia na ru ne ki, nia ne kera ka 'eke fafia ta'alae kera ki, ma kera ka subutai nau ma fainia Maa nau laugo. ");
INSERT INTO far_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ru ne nia dao mai, fua Kekedee ana Taki kera ki ka mamana ana fatae be nia 'uri, ‘Kera subutai 'o'oni ga 'ada aku.’ ");
INSERT INTO far_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Na Anoeru Abu kai leka mai ma ka 'adomi kamulu. Ma nia kai fatainia ru mamana ki sulia God. Nau kai kwatea mai siamulu fasia na Maa nau. Ana kada nia leka mai, nia ka fata famamana suli nau fua mulu. ");
INSERT INTO far_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma kamulu laugo mulu kai fata famamana suli nau, sulia kulu 'ado safali na mai ana kada nau ku safalia raoe nau.” ");
INSERT INTO far_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Sa Jesus ka fata lau 'uri, “Nau ku saea na ru ne ki fua mulu, fua famamanalae kamulu kai ngasi. ");
INSERT INTO far_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kera kai susi kamulu fasia rulae laona beu fuana folae kera ki. Ma nia kai dao ana kada ne, dia ta wane ka saungi kamulu, nia kwaisae nia sasia na ru ne God nia doria. ");
INSERT INTO far_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Na wane ne ki, kera kai sasia ru nai ki amulu, sulia nao kera si saitamana na Maa nau, ma nao kera si saitamaku laugo. ");
INSERT INTO far_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Boroi ma nau ku saea na 'aku ru ne ki fua mulu, fua ne ana kada kera safali fua sasilana ru ne ki amulu, mulu kai manata to'ona na fatae be nau ku saea na fua mulu ki.” Sa Jesus ka fata lau 'uri, “Nau nao kusi saea na ru ne ki fua mulu mai 'i nao, sulia nau ku to 'ua fai kamulu. ");
INSERT INTO far_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Boroi ma ana kada ne, nau ku karangi oli na siana God ne nia odu nau mai. Ka 'urinai boroi 'ana, nao ta wane amulu si ledi nau 'ua 'uria 'i fai ne nau kai leka 'uria. ");
INSERT INTO far_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Ana kada ne, na liomulu 'e kwaimanatai 'asiana, sulia nau ku saea ru ne ki fua mulu. ");
INSERT INTO far_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Boroi ma nau ku saea ru mamana fua mulu, nia lea 'asiana fua mulu ne nau kai leka fasi kamulu 'urinai. Sulia dia nao nau si leka, na Anoeru Abu ne kai leka mai fuana 'adomilamulu, nia nao si leka go mai siamulu. Boroi ma kada nau leka, nau kai odua mai siamulu. ");
INSERT INTO far_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ma kada nia dao mai, nia kai fatai fola ana fua wane laona molagali, ne kera too ana manatae wane garo sulia ti ne kwatea abulo ta'alae, ma sulia ti ne nia 'o'oloe maana God, ma sulia ti ne God kai ketoa. ");
INSERT INTO far_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kera to ana manatae wane garo sulia ti ne kwatea abulo ta'alae, sulia kera nao si nonimabe fua famamanae aku. ");
INSERT INTO far_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ma kera too ana manatae wane garo sulia ti ne nia 'o'olo maana God, sulia nau kai leka siana na Maa ne, ma nao mulu si ada to'oku lau. ");
INSERT INTO far_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ma kera too ana manatae wane garo sulia ti ne God kai ketoa, sulia God nia ketoa sa Saetan suina, wane ta'a ne nia gwaungai ana na molagali ne. ");
INSERT INTO far_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Nau ku too ana na ru 'oro 'asiana ki fuana saelana fua mulu, boroi ma nao kamulu si bobola fua rongolada tafau na 'i kada nai. ");
INSERT INTO far_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Boroi ma ana kada ne na Anoeru Abu kai dao mai, nia kai famanata kamulu ana na mamanae, ma nia kai fatainia na ru ki tafau fua mulu. Ma nia nao si fata ana talana, boroi ma nia kai fata sulia na ru ne nia rongoa ki fasia God. Ma nia kai fata sulia ru ne kai dao mai ki. ");
INSERT INTO far_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nia kai fa'inito nau, sulia nia kai ngalia na fatae nau ki, ma ka farongo kamulu ana. ");
INSERT INTO far_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ma na ru Maa nau ki tafau ne, na ru nau ki laugo. Nia be nau ku saea ne na Anoeru Abu kai ngalia mai na fatae nau ki ma ka farongo kamulu ana.” ");
INSERT INTO far_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Sa Jesus ka fata lau 'uri, “Ana kada tu'u, nao mulu si ada to'oku. Sui ana ka kada tu'u laugo, mulu kai ada to'oku lau.” ");
INSERT INTO far_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ma tani wane ana na fafurongo nia ki kera ledi kera kwailiu, kera ka 'uri, “Te ne manatalae ana fatae ne nia saea, ‘Ana kada tu'u nao mulu si ada to'oku, ma ana ka kada tu'u laugo, mulu kai ada to'oku lau?’ Ma nia ka saea lau, ‘Nao mulu si ada to'oku sulia nau kai leka siana na Maa.’” ");
INSERT INTO far_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ma na fafurongo nia ki kera ka ledi kera kwailiu lau 'uria, “Te ne manatalae ana fatae ne, ‘Ana kada tu'u?’ Kulu ulafusia te ne nia fata sulia.” ");
INSERT INTO far_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Sui sa Jesus ka saitamana ne kera doria kai ledia, ma nia ka fata 'uri fuada, “Mulu manata sulia ru be nau ku saea, ‘Ana kada tu'u, nao mulu si ada to'oku. Ma ana ka kada tu'u laugo, mulu kai ada to'oku nau.’ 'Uri ma na ru nai ne mulu ledi kamulu talamulu 'uria? ");
INSERT INTO far_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ru mamana nau ku saea fua mulu. Ana kada nai, mulu kai angi ma mulu kai omaee. Boroi ma wane ta'a ana molagali ki, kera kai eele 'ada. Mulu kai kwaimanatai, sui 'i burina na liodilae kamulu kai sui, mulu kai eele lau. ");
INSERT INTO far_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kamulu saitamana kada ne na keni nia karangi fafuta, nia 'e kwaimanatai, sulia nia dao na ana kada ana nonifie. Boroi ma kada nia fafuta na wele ka sui, nia ka manata buro na ana nonifie be, sulia nia eele na 'ana sulia na wele nia 'e futa na. ");
INSERT INTO far_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kamulu 'urinai laugo. Ana kada ne go ne mulu kwaimanatai. Boroi ma nau kai ada to'omulu lau, ma laona maurilamulu mulu kai eele 'asiana. Ma na eelelae ne nao ta wane si bobola ne kai laua na fasi kamulu. ");
INSERT INTO far_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ana kada nai, nao mulu si gani nau na 'uria ta ru lau. Ru mamana nau ku saea fua mulu, dia ta ru boroi 'ana ne mulu kai gania siana na Maa sulia kamulu na fafurongo nau ki, nia kai kwatea fua mulu. ");
INSERT INTO far_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Safali 'ua mai leka ka dao 'i ta'ena, nao mulu si gania go ta ru ana Maa nau ana sataku. Mulu kai gania Maa nau, nia kai kwatea fua mulu, fua ne mulu kai eele.” ");
INSERT INTO far_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Sa Jesus ka fata lau 'uri, “Nau ku saea ru ne ki fua mulu ana tarifulae ki. Boroi ma kada kai dao mai ne nao nau si fata lau ana tarifulae ki, boroi ma nau ku fata fola ga 'aku sulia Maa fua mulu. ");
INSERT INTO far_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ana kada nai, mulu kai tala gania na God ana sataku. Ma nau ku saea fua mulu ne nao nau si gani na 'uria ta ru fua mulu. ");
INSERT INTO far_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Nia kai 'urinai na sulia na Maa 'ana talana ne nia kwaimani amulu, sulia kamulu kwaimani aku, ma mulu famamana ne nia ne odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","'I nao, nau ku leka mai fasia na Maa 'uria laona molagali ne. Ma ana kada ne, nau ku leka na fasia na molagali, ma nau ku oli lau siana na Maa nau.” ");
INSERT INTO far_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","'Urinai fafurongo nia ki kera ka fata 'uri fuana, “Ana kada ne 'oe fi fata madakwa na fua malu, sulia nao 'oe si fata na ana tarifulae ki. ");
INSERT INTO far_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kada ne, kalu fi saitamana ne 'oe saitamana ru ki tafau, dia ta wane nao si ledi 'oe boroi, 'oe saitamana te ne nia 'i laona manatana. Ma nia ne kwatea ma kalu ka famamana ne God nia odu 'oe mai.” ");
INSERT INTO far_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ma sa Jesus ka fata 'uri fuada, “'Uri ma kamulu famamana na nai? ");
INSERT INTO far_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Na kada nia dao na ne mulu kai takalo tafau fasi nau. Ma mulu kai tafi 'uria fere kamulu ki, sulia ru ne kera kai sasia aku. Boroi ma nao nau si to taifili nau, sulia na Maa ne nia to fai nau. ");
INSERT INTO far_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nau ku saea na ru ne ki fua mulu, fua ne mulu kai too ana aroaroe laona maurilamulu, sulia ne kamulu 'ado fai nau. Sui boroi 'ana mulu ka to laona molagali ma kera kai famalagaigai kamulu, nao mulu si mau, sulia nau ku liufia na nikilalae na molagali ne ka suina.” ");
INSERT INTO far_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Kada sa Jesus nia fata 'urinai ka sui, nia ka ada 'alaa 'i langi, ma ka fata 'uri, “Maasi 'ae, nia dao na ana kada fua ne 'oko fa'inito nau, fua nau ku fa'inito 'oe. ");
INSERT INTO far_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Sulia 'oe kwatea na nikilalae fuaku fafia na wane ki tafau, fua nau ku 'adomia wane ne 'oe kwateda fuaku ki fua kera kai mauri firi. ");
INSERT INTO far_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aia, ma na maurie firi ne nia 'uri: Dia wane ki kera saitamamu ne te God mamana, ma kera ka saitamaku, sa Jesus Christ, ne 'oe odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nau ku fatainia na 'initoe 'oe laona molagali, sulia nau ku fasuia na raoe be 'oe odu nau mai fuana sasilana. ");
INSERT INTO far_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Maasi 'ae, kada ne, 'oe fa'initoa nau lau ana 'initoe ne nau ku to mai ana fai 'oe, 'i naona mai saungailana na molagali. ");
INSERT INTO far_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Nau ku famanata suli 'oe fuana wane ki ne 'oe kwateda mai fuaku laona molagali ne. Kera ne wane 'oe ki, ma 'oko kwateda na mai fuaku. Kera ro na sulia na fatalamu. ");
INSERT INTO far_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma kada ne, kera saitamana ru ki tafau ne 'oe kwatea fuaku, nia leka tafau mai fasi 'oe. ");
INSERT INTO far_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nau ku saea na fuada fatae ki ne 'oe kwatea fuaku, ma kera ka famamana na. Ma kera ka saitamana mamana na ana ne nau ku leka mai fasi 'oe, ma kera ka famamana ne 'oe ne odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ma nau ku foa fuada. Nao nau si foa lau fuana wane ne nao lau wane 'oe ki, boroi ma nau ku foa lalau 'aku fuana wane ne 'oe kwateda mai fuaku, sulia kera na wane 'oe ki. ");
INSERT INTO far_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na wane nau ki tafau ne, kera na wane 'oe ki lau go. Ma wane 'oe ki tafau, kera na wane nau ki lau go. Ma kera kai fatainia na 'initoe nau ana tolada. ");
INSERT INTO far_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Nau si to tau na laona molagali, nau kai leka na kau siamu. Boroi ma kera go ne kera ka to 'ua laona molagali. Maasi Abu 'ae, susulida ana nikilalae be 'oe kwatea fuaku, fua ne kera ka alua na te ru, dia ne koro te ru laugo. ");
INSERT INTO far_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ma kada be nau ku to faida, nau ku susulida ana na nikilalae be 'oe kwatea fuaku. Nau ku gonida, ma nao ta wane ada si funu, taifilia go na wane ta'a be na Kekedee Abu saea nia kai funu. ");
INSERT INTO far_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nau kai leka kau siamu, ma nau ku saea ru ne ki ana kada nau ku to 'ua laona molagali, fua ne kera ka eele dia na eelelae nau. ");
INSERT INTO far_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ma nau ku farongoda suina ana fatae be 'oe saea fuaku ki. Wane ne ki laona molagali, kera subutainia wane nau ki, sulia kera nao lau wane fasia molagali ne, dia laugo ne nau nao lau wane fasia molagali ne. ");
INSERT INTO far_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nao nau si gani 'oe fua 'oko lafuda fasia laona molagali, boroi ma nau ku gani 'oe fua 'oko susulida fua sa Saetan nao si falilada. ");
INSERT INTO far_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Kera nao lau wane laona molagali, dia laugo ne nau nao lau wane laona molagali. ");
INSERT INTO far_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","'Oe faabuda fuamu ana na mamanae. Na fatalamu na ne mamanae. ");
INSERT INTO far_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nau ku odu kera fua famanatalana wane ki, dia laugo ne 'oe odu nau mai 'uria laona molagali. ");
INSERT INTO far_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ma fuana lealada, nau ku faabu nau talaku fuamu, fua ne kera laugo kera ka faabu mamana ada talada fuamu. ");
INSERT INTO far_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Nau si foa go fuada taifilida. Boroi ma nau ku foa laugo fuana wane ne kera kai famamana nau sulia na farongoe kera. ");
INSERT INTO far_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ma nau ku foa fua ne kera ka alua te ru go. Maasi 'ae, kera ka 'ado fai koro, dia laugo ne 'oe 'ado aku, ma nau ku 'ado amu. Kera ka alua na te ru, fuana wane laona molagali ki kera ka famamana ne 'oe odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nau ku kwatea fuada na 'initoe be 'oe kwatea laugo fuaku, fua ne kera ka alua te ru, dia laugo ne koro te ru go. ");
INSERT INTO far_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Fadalana ru ne nia 'uri: Nau ku 'ado ana kera, ma 'oe 'ado aku, fua ne kera ka te ru tafau, ma fuana wane ki laona molagali kera ka saitamana ne 'oe odu nau mai, ma 'oe kwaimani ada, dia laugo ne 'oe kwaimani aku. ");
INSERT INTO far_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Maasi 'ae, nau ku doria wane ne 'oe kwateda fuaku ki, kera ka to fai nau ana kula ne nau ku to ana, fua ne kera ka ada to'ona na 'initoe nau ne 'oe kwatea fuaku. 'Oe kwatea 'initoe ne fuaku, sulia ne 'oe kwaimani aku 'i naona na saungailana na molagali. ");
INSERT INTO far_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Maasi 'ae, 'oe wane ana 'o'oloe. Na wane ta'a ki laona molagali ne kera nao si saitamamu, boroi ma nau ku saitamamu ga 'aku, ma wane fafurongo nau ki, kera saitamana ne 'oe odu nau mai. ");
INSERT INTO far_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nau ku farongo kera na ani 'oe. Ma nau ku inau ga 'aku ana, fua ne kwaimanie 'oe fuaku ka to laugo laona maurilada, ma nau boroi, nau ku to tari laugo faida laona maurilada.” ");
INSERT INTO far_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Burina sa Jesus nia foa ka suina, nia fainia fafurongo nia ki, kera ka leka kau, ma kera ka tofolo ana ododoe kera saea ana Kidron. Ma kera leka kau 'uria kula ne na oole 'ai ki nia ana. ");
INSERT INTO far_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma sa Jiudas, na wane ne kai 'olomaelana sa Jesus fuana malimae nia ki, nia saitamana na ana kula nai. Sulia kada 'oro sa Jesus fainia na fafurongo nia ki, kera 'idufa leka senai. ");
INSERT INTO far_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Nia ne sa Jiudas ka talaia kau wane ni omee ki fasia Rom fainia wane ne kera folo kalia na Beu Abu God. Na fataabu baita ki, ma Farasi ki ne, kera oduda kau. Aia, wane ne leka mai ki, kera dau ana kwesu ki, ma raunge fuana firulae ki. ");
INSERT INTO far_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ma sulia sa Jesus nia saitamana ka suina ru ne kai dao to'ona ki, nia ka fali kau 'usida, ma ka ledida ka 'uri, “Ti ne mulu nani 'uria?” ");
INSERT INTO far_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kera olisia kera ka 'uri, “Kalu nani 'uria sa Jesus, na wane be fasia 'i Nasaret.” Ma sa Jesus ka fata 'uri, “Nau na ne.” Aia, ma sa Jiudas na wane be nia talaida kau siana sa Jesus, nia uu laugo senai faida. ");
INSERT INTO far_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ana kada sa Jesus nia fata 'uri, “Nau na ne”, na wane nai ki kera dudu faburi, ma kera ka 'asida 'i ano. ");
INSERT INTO far_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Sui sa Jesus ka ledi kera lau ka 'uri, “Ti ne mulu nani 'uria?” Ma kera ka 'uri lau, “Kalu nani 'uria sa Jesus, na wane be fasia 'i Nasaret.” ");
INSERT INTO far_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Sa Jesus ka fata 'uri fuada, “Nau ku saea ka suina fua mulu, ‘Nau na ne.’ Sulia nau na ne mulu nani 'uri nau mai, 'urinai mulu alamatainia wane ne ki kera leka 'ada.” ");
INSERT INTO far_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Sa Jesus saea ru nai fua ka famamana te ne nia saea ka suina mai suli kera, be nia fata 'uri, “Maasi 'ae, nao ta wane ana wane nau ki ne 'oe kwateda fuaku kera ka funu.” ");
INSERT INTO far_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ma sa Simon Pita to ana te naife ni sauwanee, nia lafua, ma ka kwae ana, ma ka kwae musia bali alinga 'o'olo ana te wane rao na 'inita fataabu. Na wane rao nai satana sa Malakas. ");
INSERT INTO far_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ma sa Jesus ka fata 'uri fua sa Pita, “'Oe alua 'amu na naife nena fulina! 'Uri ma 'oe fia ne nao nau si ru laona kada ana nonifilae ne Maa nau kwatea fuaku?” ");
INSERT INTO far_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Sui na wane folo ki, ma wane ni omee ki, fainia wane fanaonao kera, kera daua sa Jesus, ma kera ka kani fafia ro 'abana ki. ");
INSERT INTO far_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ma kera ka eta talaia kau sa Jesus siana sa Anas, sulia nia ne fungo sa Kaeafas, na 'inita fataabu ana fangali nai. ");
INSERT INTO far_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ma sa Kaeafas be saea fuana wane fanaonao kera Jiu ki 'uri, “Nia lea go fuana te wane kai mae, fua ne kera nao si saungia wane ki tafau.” ");
INSERT INTO far_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Sa Simon Pita fainia te fafurongo lau, kera leka sulia sa Jesus. Ma na ruana fafurongo, na 'inita fataabu nai saitamana lea ana. Ma na ruana fafurongo nia ka leka burina sa Jesus, leka ka to mai laona labate ana lume na 'inita fataabu. ");
INSERT INTO far_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Sa Pita nia uu ga 'ana mai 'i maa. Sui na ruana fafurongo nia ka ru kau 'i maa, ma ka fata fuana keni ne nia folo 'afia na mae, fua ni ka talaia mai sa Pita laona. ");
INSERT INTO far_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ana kada sa Pita nia ru mai, na keni nai ka fata 'uri fuana, “Alamia 'oe ta wane laugo ana fafurongo na wane ne kera ngalia mai 'oto ne!” Sa Pita olisia ka fata 'uri, “Nau nao!” ");
INSERT INTO far_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Sulia kada nai kada ana uni gwarie, ne wane rao ki fainia na wane folo ki, kera ka okua na ere neneo, ma kera ka uu 'ada kalia, ma sa Pita ka uu laugo faida senai, ma ka sara laugo 'ana. ");
INSERT INTO far_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na 'inita fataabu ka ledia sa Jesus ka 'uri, “Tifaida ne na fafurongo 'oe ki? Ma na te ki ne 'oe famanata kera ana?” ");
INSERT INTO far_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ma sa Jesus ka olisia ka 'uri, “Nau ku fata sulia ru ki tafau fuana wane ki ne kera ka rongoa tafau. Nao nau si safungainia go ta ru, kada nau ku famanata wane ki. Nau ku sasia ru nai ana maedangi ki tafau laona beu fuana folae ki, ma 'i laona Beu Abu God fua ne kada wane ki kera oku mai, kera ka rongoa. Ma nao nau si fata agwa go ana ta ru. ");
INSERT INTO far_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","'Uta ne 'oe ledi nau 'urinai? 'Oe ledia lalau 'amu wane ne kera rongoa ru ne nau ku saea fuada ki. Kera ne saitamana ru ne nau ku saea fuada ki.” ");
INSERT INTO far_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kada sa Jesus fata go 'urinai, te wane ana wane folo ki leka mai, ma ka fidalia, ma ka fata 'uri, “'Uta ne 'oe fata 'urinai fuana 'inita fataabu?” ");
INSERT INTO far_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Sa Jesus olisia ka 'uri, “Dia nau ku saea ta ru ne nia garo, 'oe saea na ru ne nau ku garo ana. Ma dia nao nau si saea go ta ru garo, 'uta ne 'oe fidali nau?” ");
INSERT INTO far_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Burina ru nai sa Anas ka kwatea na kau sa Jesus siana sa Kaeafas, na 'inita fataabu. Ma 'abana ki kera kani 'ua fafida. ");
INSERT INTO far_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma kada sa Pita nia uu, ma ka sara 'ana, na wane ne kera uu senai fainia, kera fata 'uri fuana, “'Oe ta wane ana fafurongo na wane ne kera ketoa ne?” Ma sa Pita nia tofe, ma ka fata 'uri, “Nao 'asiana, nau nao!” ");
INSERT INTO far_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ma te wane ana wane rao 'inita fataabu nia to laugo senai. Na wane nai nia na wanefuta na wane rao be sa Pita nia kwae musia na alingana, ma nia ka fata 'uri, “Kada be kera daua sa Jesus laona oole be, nau kwaisae nau ada to'omu laugo fainia?” ");
INSERT INTO far_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ma sa Pita ka fata 'uri, “Nao! Nao lau nau be.” Ana kada nai go na karai ka angi na. ");
INSERT INTO far_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ma ana makalokalo 'i 'ofodangi, kera ka talaia sa Jesus fasia lume sa Kaeafas, 'uria lume baita sa Paelat, na wane gwaungai ana kula nai. Kada nai, fanaonao Jiu ki kera uu ga 'ada kau 'i maa, sulia dia kera ru laona lume wane ne nia nao lau na wane Jiu, kera fia ne kera kai sua naona God. Ana kada nai, kera doria kera ka to falu makwalia 'anilana na Fafanga ana Daofa Liue. ");
INSERT INTO far_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ma sa Paelat ka ru kau siada 'i maa, ma ka ledi 'uri, “Ru 'uta ne mulu fai fafia ana wane ne fuana ketolana?” ");
INSERT INTO far_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kera olisia kera ka fata 'uri, “Wane ne nia sasia na ru ta'a ki ne kalu ka talaia mai siamu. Dia nao, nia 'afitai kalu ka talaia mai siamu.” ");
INSERT INTO far_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Sa Paelat ka fata 'uri fuada, “Dia ni 'urinai, mulu talaia kau, mulu ka ketoa sulia te ne taki kamulu ki saea.” Kera ka fata 'uri, “Na taki kamulu ki 'i Rom ne kalu to farana, nia luia nao kalu si saungia ta wane.” ");
INSERT INTO far_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nia 'urinai, fua ka famamana te ki be sa Jesus nia saea ka suina sulia na maelana. Sulia na wane fasia 'i Rom ki, kera saungia wane ki ana na 'airarafolo. ");
INSERT INTO far_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Sa Paelat ka oli lau 'uria laona lume nia, ma ka saea mai sa Jesus siana, ma ka ledia ka 'uri, “'Uri ma 'oe ne na kingi wane Jiu ki ne?” ");
INSERT INTO far_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ma sa Jesus olisi ka 'uri, “'Uri ma na ledilae ne nia leka mai fasi 'oe talamu, naoma tani wane ne kera farongo 'oe suli nau?” ");
INSERT INTO far_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ma sa Paelat ka fata lau ka 'uri, “Nau nao lau na wane Jiu ne! Na wane 'oe ki, ma na fataabu baita ki talada ne, kera talai 'oe mai siaku. Na te ta'a ne 'oe sasia?” ");
INSERT INTO far_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ma sa Jesus olisia ka 'uri, “Na 'Initoe nau nao lau fasia molagali ne. Ma dia na 'Initoe nau ne ru laona molagali, na wane nau ki kera ka firu 'usi nau fasia na kwatelaku fua fanaonao Jiu ki. Na 'Initoe nau, nao lau ru laona molagali ne go.” ");
INSERT INTO far_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ma sa Paelat ledia ka 'uri, “'Uri ma 'oe ta kingi ne?” Ma sa Jesus olisia ka 'uri, “'Oe ne 'oe saea nau na kingi. Nau ku futa, ma nau ku dao mai laona molagali ne fuana te ru go, fua nau fata sulia na ru mamana. Ma sa ti ne doria na ru mamana, nia rosuli nau.” ");
INSERT INTO far_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Sui sa Paelat ka ledia lau ka 'uri, “'Uri ma na te ne mamanae?” Ma sa Paelat ka oli lau 'i maa siana wane ki, ma ka fata 'uri fuada, “Nao nau si dao go to'ona ta ta'alae ana wane ne. ");
INSERT INTO far_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Boroi ma sulia na falafala kamulu, nau ka 'idufa lugea te wane fua mulu ana kada ana Fafanga ana Daofa Liue. 'Uri ma kamulu doria nau lugea na kingi Jiu ki fua mulu?” ");
INSERT INTO far_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ma kera ka akwa koko kera ka fata 'uri, “Nao! Na wane ne nao 'oe si lugea! Kalu doria 'oe lugea mai sa Barabas!” Aia, sa Barabas nia na wane beli. ");
INSERT INTO far_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","'Urinai go sa Paelat ka kwatea na sa Jesus fuana wane ni omee ki, ma ka saea kera ka namusia. ");
INSERT INTO far_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ma kera ka 'erea na te 'eregwau ana 'oko ngangara, ma kera ka alua ana gwauna sa Jesus. Sui kera ka famasa ana na maku meo, dia ta kingi. ");
INSERT INTO far_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sui kera ka leka mai siana, ma kera ka 'uri, “Kalu fabaita 'oe, na kingi wane Jiu ki.” Ma kera ka fidalia. ");
INSERT INTO far_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ma sa Paelat ka ru lau kau siana wane 'oro ne kera oku ki, ka fata 'uri, “Nau kai ngalia mai na wane ne siamulu, fua mulu ka saitamana ne nao nau si dao to'ona go ta ta'alae ani nia.” ");
INSERT INTO far_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Sui, sa Jesus ka ru mai 'i maa, ma ka sengia na 'eregwau ana 'oko ngangara, ma na maku meo. Ma sa Paelat ka fata 'uri fuada “Ada to'ona basi na wane ne!” ");
INSERT INTO far_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ma ana kada fataabu baita ki, ma na wane ne kera folo 'usia na Beu Abu God, kera ada to'ona, kera fi akwa baita lau, ma kera ka 'uri, “'Oe saungia! Foto'ia ana 'airarafolo!” Sa Paelat ka fata 'uri, “Dia 'urinai, kamulu ka ngalia, ma mulu kai foto'ia ana 'airarafolo. Sulia nao nau si dao to'ona go ta ta'alae ani nia.” ");
INSERT INTO far_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Na wane ki kera ka fata 'uri fuana sa Paelat, “Kalu too ana na taki fuana wane 'uri nia ka mae, sulia nia saea ne nia na Wele God.” ");
INSERT INTO far_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kada sa Paelat nia rongoa ru nai, nia ka mau 'asiana liufia 'i nao. ");
INSERT INTO far_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ma nia ka oli lau 'i lume ka ledia sa Jesus ka 'uri, “'Oe wane fasia 'i fai ne?” Ma sa Jesus nao si saea go ta ru. ");
INSERT INTO far_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Sa Paelat ka fata lau 'uri fuana, “'Uri ma nao 'oe si doria go fatalae fai nau? Nao 'oe si saitamana go ne, nau ku too ana nikilalae fuana saelana fua kera ka luge 'oe, naoma kera ka saungi 'oe ana 'airarafolo?” ");
INSERT INTO far_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Sa Jesus olisia ka fata 'uri, “Nia mamana 'oe too ana nikilalae fua 'oko sasi 'urinai aku. Boroi ma God go ne nia kwatea na nikilalae nai fuamu. Nia ne na wane ne nia kwate nau fuamu, nia sasia na ru ne ta'a 'asiana ka liufia na ru 'oe sasia.” ");
INSERT INTO far_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ana kada sa Paelat nia rongoa fatalana sa Jesus, nia ka nani 'uria ta ru fua nia ka lugea. Boroi ma na Jiu ki, kera akwa baita kera ka 'uri, “Dia 'oe lugea wane ne, 'oe nao lau wane kwaimani kingi baita 'i Rom. Sulia dia ta wane saea nia ne na kingi, nia susia na kingi baita 'i Rom.” ");
INSERT INTO far_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kada sa Paelat nia rongoa na fatae nai ki sui, nia ka talaia kau sa Jesus 'i maa, ka gouru ana kula ni kwaiketoie ne kera saea ana “Tatafe fau”, ma na fatae Jiu ne “Gabata.” ");
INSERT INTO far_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ana kada nai, nia tofungana asoa na ana maedangi fua sasi akaulae ana ru ki fuana Fafanga ana Daofa Liue. Ma sa Paelat ka fata 'uri fuana wane Jiu ki, “Ada to'ona basi na kingi kamulu.” ");
INSERT INTO far_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ma na wane ki kera akwa, kera ka fata 'uri, “Saungia! Saungia! Foto'ia ana 'airarafolo!” Sa Paelat ka ledida lau ka 'uri, “'Uri ma kamulu doria nau foto'ia na kingi kamulu ana 'airarafolo?” Ana kada nai, na fataabu baita ki olisia kera ka 'uri, “Nia nao lau na kingi kalu. Te kingi ne 'i Rom go ne na gwaungai kalu!” ");
INSERT INTO far_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ma sa Paelat ka kwatea sa Jesus fuana wane ni omee ki, fua ne kera ka foto'ia ana 'airarafolo. Ma kera ka talaia na kau sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ma nia leka ka ngalia na 'airarafolo nia talana 'uria na kula ne kera saea ana 'i Golgota ana fatae wane Jiu. (Na fadalana sataeru nai ne “Na kula ana lelete wane.”) ");
INSERT INTO far_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ma senai kera ka foto'ia ana 'airarafolo. Ma na ro wane ki laugo ne kera foto'ida senai, te wane ana bali mauli ma ta wane ana bali 'o'olo, ma kera ka foto'ia sa Jesus ana 'airarafolo ne uu 'i safitadaro. ");
INSERT INTO far_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ma sa Paelat ka kedea na fatae, ma kera ka alua 'i gwauna 'airarafolo sa Jesus. Na fatae nai ki nia kedea ka 'uri, “Sa Jesus fasia 'i Nasaret, na kingi Jiu ki.” ");
INSERT INTO far_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Kula ne kera alua na 'airarafolo ne kera foto'ia sa Jesus ana, nao si tau go fasia 'i Jerusalem. Ma wane 'oro ana Jiu ki kera idumia fatae ne. Ma na fatae ne kera kedea laugo ana olu fatae 'e'ete ki: Fatae wane Jiu ki, fatae wane Rom ki, ma na fatae wane Grik ki laugo. ");
INSERT INTO far_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ma na fataabu baita ki, kera ka fata 'uri fua sa Paelat, “Nao 'oe si kedea lau na ‘Kingi Jiu ki!’ Boroi ma 'oe kedea lalau 'uri, ‘Nia 'ana talana ne fata 'uri, nau na kingi wane Jiu ki.’” ");
INSERT INTO far_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Sui sa Paelat ka olisida ka fata 'uri, “Te ne nau ku kedea ka suina, nia ka to na 'ana 'urinai.” ");
INSERT INTO far_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ma 'i burina ne wane ni omee ki kera foto'ia sa Jesus ana 'airarafolo ka sui, kera ka ngalia na maku nia ki, ma kera ka tolingia ana na fai bali ru ki fuana fai wane nai ki. Ma na maku fafo baita nia, ne nao ta tai ladolana, kera saungainia ga 'ada ana te maku baita ne gwala. ");
INSERT INTO far_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ma na wane ni omee ki kera ka fata 'uri fuada kwailiu, “Nao kulu si musia falia lau na maku ne. Kulu daisi 'uria, dia sa ti ne daisi ka dao na ana, nia ne kai ngalia.” Nia 'urinai fuana ka famamana Kekedee Abu be nia 'uri, “Kera tolingia na maku nau ki fuada, ma kera ka daisi 'uria maku fafo baita nau.” Na ru ne ki na wane ni omee ki ne kera sasia. ");
INSERT INTO far_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Na gaa sa Jesus, ma na ai keni futa gaa sa Jesus, ma ni Mary 'afe sa Klopas, fainia ni Mary fasia 'i Magdala ne kera uu 'aena na 'airarafolo sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ma na fafurongo be sa Jesus nia kwaimani fuana, nia uu laugo 'i senai fainia gaa sa Jesus. Kada sa Jesus nia ada to'ona gaa nia fainia na fafurongo ne nia kwaimani fuana kera uu karangia, nia ka fata 'uri fuana gaa nia, “Gaa 'ae, na wele 'oe na nena.” ");
INSERT INTO far_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Sui, nia ka fata 'uri lau fuana fafurongo nai, “Na gaa 'oe na nena.” Ma ka safali ana kada asoa nai, na fafurongo nai ka talaia na gaa sa Jesus 'uria lume nia fua nia ka ada sulia. ");
INSERT INTO far_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","'I burina ru ne ki sui, sa Jesus saitamana ne na raoe nia ki, nia sui tafau na. Ma nia ka fata 'uri, “Nau ku maeliku” fua ka famamana fatae laona Kekedee Abu. ");
INSERT INTO far_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ma ana kula nai, kera alua te tiu ne fungu ana waeni 'afae. Ma kera ngalia te lumulumu asi, ma kera ka kutumainia laona waeni nai, sui kera ka alua maana na mae 'ai kera saea ana “hisop”, kera ka kwate 'uria maana ngiduna sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ana kada sa Jesus nia ku to'ona sui, nia ka fata 'uri, “Nia suina.” Burina nia saea fatae nai ki sui go, nia ka gwautoli na, ma ka mae na. ");
INSERT INTO far_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ma 'i burina ru ne ki sui, fanaonao Jiu ki kera leka mai, kera ka ledia sa Paelat fua ka alamatainia fua wane ni omee ki kera leka, ka 'oia 'aena olu wane ne kera foto'ida ana 'airarafolo ki, fua ne kera ka mae 'ali'ali. Sulia kera doria ka lafua na nonida fasia 'airarafolo ki ana fa dangi nai. Sulia fa dangi ne nia na fa dangi fua sasi akaulae Jiu ki makwalia maedangi ana Sabat. Ma kera nao si doria ne wane mae ki ka daukukulu ana 'airarafolo ana Sabat. Sulia Sabat nai, nia na maedangi 'initoa 'asiana. ");
INSERT INTO far_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ma wane ni omee ki kera leka mai, kera ka 'oia 'aena ro wane be kera foto'ida fainia sa Jesus ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Boroi ma kada kera dao to'ona sa Jesus, kera ka ada to'ona nia mae suina. Nia ne, kera nao si 'oia 'aena sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sui ka 'urinai boroi 'ana, te wane ada ne nia doria ka famamana lea ana, nia ngalia na sue, ma ka labua kakaraona sa Jesus. Ma kera ka ada to'ona 'abu fainia kafo 'e igwa mai. ");
INSERT INTO far_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nau ku ada to'ona ru nai, ma nau ku fata sulia, fua ne kamulu tafau mulu kai famamana laugo. Na ru ne nau ku saea nia mamana, ma nau ku saitamana na fatalaku nia mamana laugo. ");
INSERT INTO far_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ma ru nai ki ka 'urinai, fua ne ka famamana Kekedee Abu be fata 'uri, “Te suli boroi 'ana nao si mo'oi go.” ");
INSERT INTO far_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ma ta bali Kekedee Abu laugo nia 'uri, “Na wane ki kera kai bubungia wane ne, kera labua na nonina.” ");
INSERT INTO far_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ma burina ru nai ki, sa Josef na wane fasia 'i Arimetea, nia leka mai ka gania sa Paelat 'uria nonina sa Jesus, fua kera ka ngalia. Sa Josef, nia ta wane ana fafurongo sa Jesus ki laugo, boroi ma nia nao si doria wane ki ka saitamana, sulia nia mau ana fanaonao Jiu ki. 'Urinai sa Paelat ka alamatainia, ma nia leka mai ka ngalia. ");
INSERT INTO far_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ma sa Nikodimas be nia leka siana sa Jesus laona rodo, nia leka fainia sa Josef, ma ka ngalia olu akwala kilo 'ana ru moko lea ki fuana alulana fainia nonina wane mae. Na satana ru ne “mira” fainia “alos.” ");
INSERT INTO far_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ro wane ne ki, keroa ngalia nonina sa Jesus, ma keroa ka 'afua ana 'aba maku kwao lea fainia na ru moko lea nai ki. Keroa sasia ru ne sulia falafala Jiu ki ana sasi akaulae ana wane mae ki fuana alulana laona faoda gwau. ");
INSERT INTO far_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ma te oole nia to karangia kula ne kera saungia sa Jesus ana. Ma te faoda fuana alulana nonina wane mae ki to laugo ana kula nai. Ma na faoda nai ne ru falu ga 'ana, kera nao si alua 'ua ta wane 'i laona. ");
INSERT INTO far_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ma sulia maedangi nai nia na maedangi fuana sasi akaulae fua Sabat, ma na faoda nai nia to karangida laugo, keroa leka ka alua nonina sa Jesus 'i laona faoda nai. ");
INSERT INTO far_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","'I 'ofodangi ana Sande kada rorodoa 'ua, ni Mary fasia 'i Magdala ka leka 'i maana na faoda, ma ka ada to'ona na fau be kera alua bokota na maana, nia abuli ka suina. ");
INSERT INTO far_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ma nia ka lae 'ali'ali siana sa Simon Pita, ma na fafurongo be sa Jesus nia kwaimani ana, ma ka fata 'uri fuadaro, “Tani wane kera ngalia na nonina na 'Aofia fasia faoda be, ma kalu ka ulafusia 'i fai ne kera alua ana.” ");
INSERT INTO far_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Sui sa Pita ma na fafurongo be, keroa ka leka na 'uria na faoda gwau nai. ");
INSERT INTO far_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ma keroa ka lae tafau, ma na fafurongo nai ka lae 'ali'ali ka liufia sa Pita, ma ka eta dao maana faoda. ");
INSERT INTO far_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ma nia ka 'agwaoro, ma ka ada to'ona na maku kwao be ki tafau, ma nao nia si ru go laona. ");
INSERT INTO far_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ma sa Simon Pita ka dao mai 'i buri, ma ka leka daofa liu na 'uria laona faoda nai. Nia ka ada to'ona na maku kwao be nia tio go ana 'i senai, ");
INSERT INTO far_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","fainia na 'aba maku be kera 'afua ana gwauna sa Jesus. Na 'aba maku nai nao si tio lau fainia na 'aba maku kwao be ki, boroi ma nia lukuma, ma ka tio na 'ana taifilia. ");
INSERT INTO far_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","'Urinai na wane be eta dao maana faoda ka ru laugo kau 'i laona. Nia ka ada to'ona, ma ka famamana. ");
INSERT INTO far_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma nao kera si saitamana 'ua na Kekedee Abu be saea nia kai mauri lau fasia maea. ");
INSERT INTO far_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ma 'i burina ru ne, na ro fafurongo nai ki, keroa ka oli na 'adaro. ");
INSERT INTO far_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ma ni Mary ka uu 'ua maana faoda, ma ka angi ga 'ana. Ma kada nia angi, nia 'agwaoro ka ada kau laona faoda gwau. ");
INSERT INTO far_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ma nia ka ada to'ona ro 'ainsel ki, keroa rufia maku kwao ki. Ma na ro 'ainsel nai ki, keroa gouru ana kula be nonina sa Jesus tio ana, ta ai ana gwauna tio, ma ta ai ana kula ne 'aena tio ana. ");
INSERT INTO far_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Na ro 'ainsel nai ki, keroa ka ledi 'uri ana ni Mary, “Keni ne 'ae, 'uri ma 'oe angisia te ne?” Ma nia ka olisidaro ka 'uri, “Na nonina na 'Aofia nau ne kera ngalia fasia 'i seki, ma nau ku ulafusia 'i fai ne kera alua ana.” ");
INSERT INTO far_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ma 'i burina nia fata 'urinai ka sui, nia kari abulo, ma ka ada to'ona te wane nia uu ga 'ana, ma nao nia si ada saitamana go ne wane ne nia sa Jesus. ");
INSERT INTO far_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ma sa Jesus ka ledia ka 'uri, “Keni ne 'ae, 'uta ne 'oe angi? Ma sa ti ne 'oe nani 'uria?” Ma ni Mary ka kwaisae nia na wane ne ada sulia na oole nai. Ma nia ka 'uri fuana, “Dia 'oe ngalia na nonina 'Aofia nau, nau doria 'oe farongo nau ana 'i fai ne 'oe alua ana, fua ne nau leka ku ngalia.” ");
INSERT INTO far_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Sui, sa Jesus ka fata 'uri fuana, “Mary 'ae!” Ma ni Mary ka abulo, ma ka ada kau, ma ka ada saitamana, ma ka fata 'uri fuana, “Raboni 'ae!” Ma na fatae ne “Raboni” ana fatae wane Jiu ki fadalana ne “Wane Famanata.” ");
INSERT INTO far_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ma sa Jesus ka fata 'uri fuana, “Nao 'oe si dau lau fafi nau, sulia nau si oli 'ua siana na Maa 'i langi. 'Oe oli siana na wanefuta nau ki, ma 'oe farongoda, nau ku leka na siana Maa nau, ma na Maa kera. Nia ne na God nau, ma na God kera.” ");
INSERT INTO far_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Sui ni Mary fasia 'i Magdala ka oli, ma ka farongoa na fafurongo ki ne nia ada to'ona na 'Aofia. Ma ni Mary ka fata laugo fuada sulia na ru ne sa Jesus nia saea fuana. ");
INSERT INTO far_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ma 'i saulafi ana Sande, na fafurongo ki kera oku 'i laona te lume, ma kera ka bilaki 'usia na mae ki. Ma kera sabia laugo mae ki, sulia kera mau ana wane fanaonao 'i Jiu ki. Ma sa Jesus ka sakatafa, ma ka uu 'i safitada, ma nia ka fata 'uri, “Na aroaroe ka to fai kamulu.” ");
INSERT INTO far_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ma 'i burina ne nia saea na fatae nai, nia ka fatainia ro 'abana ki ma na kakaraona fuada. Ma na fafurongo ki kera eele 'asiana ana kada kera ada to'ona na 'Aofia. ");
INSERT INTO far_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ma sa Jesus ka fata 'uri lau fuada, “Na aroaroe ka to fai kamulu. Dia na Maa be nia odu nau mai, nau ku odu kamulu laugo.” ");
INSERT INTO far_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sa Jesus ka saea fatae ne, sui ka mangofida, ma ka fata 'uri, “Mulu ngalia na Anoeru Abu. ");
INSERT INTO far_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Dia mulu kai manataluge ana ta'alae na wane ki, God kai manataluge laugo ada, ma na ta'alae kera ki kai aluge fasida. Ma dia nao mulu si manatalugeda, God boroi nao si manataluge laugo ada, ma na ta'alae kera ki boroi nao si aluge laugo fasida.” ");
INSERT INTO far_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma te wane ana akwala ma ro fafurongo nai ki ne satana sa Tomas ne kera saea laugo ana na 'I'iu, nao nia si to faida ana kada ne sa Jesus dao ana. ");
INSERT INTO far_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ma na fafurongo ne kera to ki, kera ka fata 'uri fuana sa Tomas, “Kalu ada to'ona na 'Aofia.” Sui sa Tomas ka fata 'uri fuada, “Dia nau ku ada to'ona na sisibe be fulina nila ki 'i 'abana, ma nau ku samo to'ona na sisibe nai ki ana 'abaku, ma nau ku alua na 'abaku laona fulina mae maale be kakaraona, nau ku fi famamana. Ma dia nao nau si sasi go 'urinai, nao nau si famamana go.” ");
INSERT INTO far_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ma ana fiuna maedangi 'i buri, na fafurongo be ki kera oku laugo laona lume be, ma sa Tomas ka to na faida. Ma kera ka sabi 'usia laugo na mae ki. Sui sa Jesus ka dao mai, ma ka uu 'i safitada, ma ka fata 'uri, “Aroaroe ka to fai kamulu.” ");
INSERT INTO far_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","'Urinai sa Jesus ka fata 'uri fuana sa Tomas, “Tomas 'ae, 'oe alua na kakaumu 'i seki laona 'abaku, ma 'oe ada to'ona laugo na ro 'abaku ki. Sui 'oe taga mai na 'abamu, ma 'oko alua 'i laona fulina mae maale ne 'i kakaroku. Nao 'oe si manata ruarua, boroi ma 'oe famamana na!” ");
INSERT INTO far_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ma sa Tomas ka olisia ka 'uri, “'Oe na 'Aofia nau, ma na God nau.” ");
INSERT INTO far_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ma sa Jesus ka fata 'uri fuana, “'Oe famamana ga 'amu, sulia 'oe ada to'oku. Na 'oilakie fua sa ti ne nao si ada to'oku, boroi ma kera famamana ga 'ada ani nau.” ");
INSERT INTO far_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Na fanadae 'oro ki ne sa Jesus sasia lau maana na fafurongo nia ki, boroi ma nao nau si kedea go laona buko ne. ");
INSERT INTO far_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nau ku kedea na ru ne ki, fua ne mulu kai famamana sa Jesus ne na Christ, na wane be God nia filia fua 'adomilana wane ki, ma nia na ne na Wele God. Ma sulia na famamanalae kamulu ana sa Jesus, mulu kai too ana na maurie firi. ");
INSERT INTO far_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","'I buri'ana ru ne, sa Jesus ka fatai lau fuana fafurongo nia ki ninimana 'osi 'i Galili. Ma ru nai ka fuli 'uri: ");
INSERT INTO far_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Sa Simon Pita, ma sa Tomas ne kera saea ana na 'I'iu, ma sa Nataniel na wane fasia 'i Kena laona lofaa 'i Galili, na ro wele sa Sebedi ki, ma ta ro fafurongo lau, kera oku. ");
INSERT INTO far_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ma sa Simon Pita ka fata 'uri fuana wane nai ki, “Nau leka dee ie na 'aku.” Ma kera saea fuana kera ka 'uri, “Kalu doria leka laugo mai fai 'oe.” Ma kera leka, ka taelia na baru. Boroi ma ana fa rodo nai, kera nao si deea go ta te gwa ie. ");
INSERT INTO far_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ma 'ofodangi kada nia la na, sa Jesus ka uu na ninimana 'osi. Ma fafurongo nia ki, kera nao si ada saitamana nia go. ");
INSERT INTO far_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Sui sa Jesus ka fata kau fuada ka 'uri, “Kwaimani nau ki 'ae, 'uri ma kamulu deea ta ie?” Ma kera olisia kera ka 'uri, “Nao go!” ");
INSERT INTO far_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ma nia ka fata 'uri, “Mulu ka 'ui 'ania na furai kamulu 'i bali 'o'olo ana na baru, ma kamulu kai deea tani ie.” Ma kera ka 'ui 'ania na furai, ma ka 'afitai 'asiana fua lafutailana mai, sulia ie ki kera 'oro 'asiana. ");
INSERT INTO far_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Sui na fafurongo be sa Jesus nia kwaimani fuana, ka fata 'uri fuana sa Pita, “Na 'Aofia loko!” Ma kada sa Simon Pita nia rongoa na ru ne, nia ka ofi ana na maku gwala nia, sulia nia lugea na maku nia, ma ka lofo laona kafo. ");
INSERT INTO far_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma na fafurongo ki keroa ka 'e leka mai 'i sara ana na baru. Ma keroa ka tara mai na furai seki fungu ana ie, sulia keroa ne nao si to tau go fasia 'i sara, ka bobola go ana fuana te talanga falie. ");
INSERT INTO far_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ma kada kera koso 'i sara, kera ka ada to'ona te ere nanaola na ma ie ki ka nia laona fainia lifu beret ki laugo. ");
INSERT INTO far_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ma sa Jesus ka fata 'uri fuada, “Mulu ngalia mai tani gwa ie ana ie ne mulu deea ki.” ");
INSERT INTO far_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Sa Simon Pita ka leka kau laona baru, ma ka tara mai na furai nai 'i sara. Na furai nai ka fungu ana ie baita ki tafau go, te talanga ma lima akwala ma olu gwa ie. Sui boroi 'ana na ie ka 'oro, na furai nai nao si foga go. ");
INSERT INTO far_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ma sa Jesus ka fata 'uri fuada, “Leka mai, mulu fanga 'amulu.” Boroi ma nao ta wane ada si ledi go 'uri, “'Oe sa ti ne?” Sulia kera saitamana ga 'ada ne nia na 'Aofia. ");
INSERT INTO far_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ma sa Jesus leka ka ngalia na beret, ma ka kwatea fuana fafurongo nia ki, ma ka sasi 'urinai laugo ana gwa ie ki. ");
INSERT INTO far_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Na oluna kada na ne sa Jesus nia fatai fuana fafurongo nia ki 'i burina ne nia tatae fasia na maea. ");
INSERT INTO far_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ma kada kera fanga ka suina, sa Jesus ka fata 'uri fuana sa Simon Pita, “Simon na wele sa Jon 'ae, 'uri ma 'oe kwaimani aku ka liufia fafurongo ne kera kwaimani aku ki ne?” Ma nia olisia ka 'uri, “Iu, 'Aofia. 'Oe saitamana ga 'amu ne nau ku kwaimani amu.” Ma sa Jesus ka fata 'uri fuana, “'Oe ada sulia na kaela sipsip nau ki.” ");
INSERT INTO far_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ma sa Jesus ka fata 'uri lau fuana ruana kada, “Simon na wele sa Jon 'ae, 'uri ma 'oe kwaimani aku?” Ma nia ka olisia ka 'uri, “Iu, 'Aofia. 'Oe saitamana ga 'amu ne nau ku kwaimani amu.” Sui sa Jesus ka fata 'uri fuana, “'Oe ada sulia na sipsip nau ki.” ");
INSERT INTO far_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ma sa Jesus ka fata lau 'uri ana oluna kada, “Simon na wele sa Jon 'ae, 'Oe kwaimani fuaku?” Ma sa Pita ka liodila na, sulia sa Jesus nia ledi olu ru na ana ka 'uri, “'Uri ma 'oe kwaimani fuaku?” Ma sa Pita ka fata 'uri fuana, “'Aofia 'ae, 'oe saitamana ru ki tafau na, ma 'oe saitamana ga 'amu ne nau ku kwaimani amu.” Ma sa Jesus ka fata 'uri fuana, “'Oe ada sulia na sipsip nau ki. ");
INSERT INTO far_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ru mamana nau ku saea fuamu, kada 'oe fi baita ana, 'oe ofi 'amu talamu, ma 'oko leka 'amu talamu ana kula ne 'oe doria lekalae 'uria. Boroi ma ana kada 'oe kai ngwaro, 'oe taga na 'abamu, ma ta wane 'e'ete ne ka kani fafi 'oe, ma ka talai 'oe kau 'uria kula ne nao 'oe si doria lekalae 'uria.” ");
INSERT INTO far_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sa Jesus ka saea ru ne, fua ka fatainia na maea ne sa Pita kai mae ana, ne nia kai fa'initoa God ana. Sui sa Jesus ka fata 'uri fuana, “'Oe leka mai buriku.” ");
INSERT INTO far_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ma sa Pita abulo, ma ka ada to'ona na fafurongo be sa Jesus nia kwaimani ana. (Nia wane ne nia to karangia sa Jesus ana kada kera fanga, ma ka ledia 'uri, “'Aofia 'ae, sa ti ne kai 'olomaelamu?”) ");
INSERT INTO far_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","'Urinai kada sa Pita ada to'ona, nia ledia sa Jesus ka 'uri, “'Aofia 'ae, te mone ne fuana wane ne?” ");
INSERT INTO far_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Sa Jesus ka olisia ka 'uri, “Sulia dia nau ku doria na wane ne kai mauri 'ana, leka ka dao ana kada nau ku oli mai, nia nao lau na 'aberolae 'oe nai. Ma 'oe leka lalau mai 'amu suli nau.” ");
INSERT INTO far_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aia, te ununue ka talofia matangana wane famamana ki. Kera saea na fafurongo nai nao nia si mae. Boroi ma sa Jesus nao si saea lau ne na wane ne nao si mae. Nia fata ga 'ana 'urinai, “Dia nau ku doria na wane kai mauri 'ana, leka ka dao ana kada nau ku oli mai, nia nao lau na 'aberolae 'oe nai.” ");
INSERT INTO far_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ma na fafurongo ne sa Pita ka ledia sa Jesus sulia, nia go ne fata sulia ru ne ki tafau, ma ka kedea. Ma kalu saitamana na ru ne nia fata sulia, nia mamana na. ");
INSERT INTO far_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Sa Jesus sasia ru 'oro ki lau. Ma dia kera kekede sulida tafau, nau fia alamia na molagali ne boroi, nao si bobola fuana daulae fafia na buko ki ne kera kedea ru nai ki laona. ");
INSERT INTO far_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Fuamu Tiofilas 'ae, laona etana kekedee be nau, nau ku kekede sulia ru ki tafau ne sa Jesus sasia, ma ka famanata ana, ");
INSERT INTO far_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","leka ka dao ana fa dangi be God ngalia 'uria 'i langi. 'I naona ne nia ra 'uria 'i langi, nia ka kwatea fatae talingai ki ana Anoeru Abu fuana wane ne nia filida fuana lifurongo nia ki. ");
INSERT INTO far_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ma sulia fai akwala fa dangi ki lau burina maelana, ana kada 'oro ki nia fatainia talana fuana lifurongo ki, ma nia ka fulia ru ki, fua sae ka famamana ne nia mauri. Kera ka ada to'ona, ma nia ka fata faida sulia na falafala ne God kai gwaungai ana fafia wane nia ki. ");
INSERT INTO far_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma ana te kada ana okulae kera fainia sa Jesus, nia kwatea na fatae talingai fuada ka 'uri, “Nao mulu si leka fasia 'i Jerusalem. Mulu kai makwalia na kwatea be Maa nau eta fatae ana. Kamulu rongoa na be nau ku fata na mai sulia ka 'uri, ");
INSERT INTO far_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","‘Sa Jon nia siuabua go wane ki ana kafo, ma nao si tau, God kai siuabu kamulu ana na Anoeru Abu.’” ");
INSERT INTO far_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ma ana kada ne lifurongo ki kera oku lau fainia sa Jesus, kera ledia kera ka fata 'uri, “'Aofia 'ae, 'uri ma, kada te na ne 'oe kai 'ui 'ania 'initoe 'i Rom, ma 'oko olitainia na 'initoe be fua malu wane Israel ki?” ");
INSERT INTO far_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Ma sa Jesus ka olisida ka 'uri, “Nao lau ta ru fua mulu ka saitamana fa dangi ma na kada 'urinai ki, sulia Maa nau ne alua tafau kada fuana ru ne ki kai dao mai. ");
INSERT INTO far_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Boroi ma kamulu ne, kada Anoeru Abu kai dao mai fafi kamulu, mulu kai too ana nikilalae. Ma mulu kai fata suli nau seki 'i Jerusalem, ma ana fere ki tafau 'i Jiudea ma 'i Samaria, ma ka dao ana fere ki tafau laona molagali.” ");
INSERT INTO far_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ma burina ne nia saea ru ne ki tafau, God ka ngalia na 'uria 'i langi. Ma kada kera bubu ga 'ada 'ua, te gwa salo ka susia, ma kera nao si ada to'ona na. ");
INSERT INTO far_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma kada kera bubu talingai ga 'ada 'alaa 'uria 'i langi fuana adalae to'ona, kada ne nia ra, na ro wane keroa ofi ana maku kwao ki 'ali'ali mai, keroa ka uu na faida. ");
INSERT INTO far_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ma keroa ledida keroa ka 'uri, “Kamulu wane 'i Galili ki, 'uta ne kamulu uu go 'amulu 'i seki, ma mulu ka adaada 'alaa go 'amulu 'uria laona mamanga? Sa Jesus be God ngalia fasi kamulu 'uria 'i langi, kai oli laugo mai, dia be mulu ada to'ona nia ra 'uria 'i langi.” ");
INSERT INTO far_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sui na wane ni lifurongo ki, kera ka oli 'uria 'i Jerusalem fasia gwauna fa uo ne kera saea ana Olif, ne bobola fainia te kilomita fasia 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ma kada kera dao na 'i Jerusalem, kera ka ra 'uria na mae lume ne kera to ana 'i langi. Ma satana wane nai ki ne: sa Pita, sa Jon, sa Jemes, sa Andru, sa Filip, sa Tomas, sa Batolomiu, sa Matiu, sa Jemes na wele sa Alfeas, sa Simon ta wane ana wane be kera doria tarilana wane Rom ki fasia 'i Israel, ma sa Jiudas na wele sa Jemes. ");
INSERT INTO far_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ma kera 'idufa oku 'urinai sulia te manatae wane fuana folae fainia tani keni laugo, ma ni Mary na gaa sa Jesus, fainia na wanefuta sa Jesus ki. ");
INSERT INTO far_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ma ana te kada kera oku senai, te telenge ma ro akwala wane famamana ki ne kera oku mai. Ma sa Pita tae uu ka fata 'uri fuada, ");
INSERT INTO far_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Wane kwaimani nau ki 'ae, na Kekedee Abu sulia sa Jiudas fuli mamana na, sulia na Anoeru Abu be fata ana sa Deved sulia sa Jiudas. Sa Jesus be filia laugo sa Jiudas fua nia ta te wane akulu fuana sasilana na raoe ne fuana lifurongolae, boroi ma sa Jiudas be talaia mai wane ki fua daulana sa Jesus.” ");
INSERT INTO far_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","('Urinai sa Jiudas ka ngalia malefo be kera foli nia ana fua nia ka 'olomaelana sa Jesus, ma ka folia ana na lifu gano. Ma laona gano nai, nia 'e 'asia, ma na guina ka foga, ma na guina ka busu tafa na 'i maa. ");
INSERT INTO far_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ma na wane ne kera to 'i Jerusalem, kera rongoa ru ne fuli fuana sa Jiudas, ma kera ka saea na gano nai ana fatae kera “Akeldama.” Ma fadalana na fatae nai ne na “Gano Ana 'Abu.”) ");
INSERT INTO far_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ma sa Pita ka fata lau 'uri, “Ru ne fuli dia be kera kedea laona buko Psalm ki nia 'uri, ‘Na lume nia ka gwau, ma nao ta wane si to laona.’ Ma te kekedee laugo be nia 'uri, ‘Nia lea fuana ta wane lau ne kai talana fua kai ngalia raoe be nia.’ ");
INSERT INTO far_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Nia 'e lea fuana kulu kai filia lau ta wane fua kai rao oku fai kalu na lifurongo ki fuana fatae sulia tataelana na 'Aofia sa Jesus fasia maea. Na wane ne kulu kai filia, nia ta wane ana fikute wane be kera leka oku fai kulu ana kada be sa Jesus nia to 'ua fai kulu, safali mai ana kada be sa Jon siuabua sa Jesus, leka mai ka dao ana fa dangi be God ngalia na sa Jesus fasi kulu 'uria 'i langi.” ");
INSERT INTO far_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ma kera ka filia ro wane ki. Ma satana ta wane ne sa Josef, ne kera saea ana sa Basabas, ma kera ka saea laugo ana sa Justus. Ma satana ruana wane ne sa Mataeas. ");
INSERT INTO far_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","'Urinai kera foa kera ka 'uri, “'Aofia 'ae, 'oe ne 'oe saitamana manatana wane ki tafau. Aia, 'oko fatainia mai fua malu ana kada ne sa ti ana ro wane ne ki ne 'oe filia, ");
INSERT INTO far_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","fua kai ngalia raoe ne ana lifurongolae be sa Jiudas lukasia ma ka leka na 'ana 'uria kula ne bobola fua nia kai to ana.” ");
INSERT INTO far_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ma burina ne kera foa tafau, kera ka saketo ana ru dia daisi, fua kera ka dao to'ona sa ti ana ro wane ne ki ne God filia, ma kera ka filia sa Mataeas fua ka rao fainia akwala ma te wane ni lifurongo nai. ");
INSERT INTO far_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ma na fa dangi baita Jiu ki ne kera saea ana Pentekos nia dao na mai, ma na wane ne kera famamana ki, kera oku ana te kula laona fere baita 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tona boroi ma te lingeru dia na kuburu baita, nia dao mai fasia 'i langi, ma ka talofia na lume ne kera to ana. ");
INSERT INTO far_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ma kera ka ada to'ona na ru dia meamea ere ki, ma na ru nai ka takalo ma ka dau fafona wane ki tafau ne kera to senai. ");
INSERT INTO far_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ma na Anoeru Abu ka sura ada tafau, ma kera ka etangia fatae ana fatae 'e'ete ki, dia ne Anoeru Abu fafata kera ana. ");
INSERT INTO far_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ma ana kada nai, na wane Jiu ki ne kera fosia God, kera to laugo 'i Jerusalem. Kera leka mai fasia na mae fere 'e'ete baita ki laona molagali. ");
INSERT INTO far_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ma kada kera rongoa na lingeru nai, wane 'oro ki kera oku. Ma kera ka kwele 'asiana, sulia ne wane famamana ki, kera fata ana fatae kera ki tafau. ");
INSERT INTO far_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ma sulia kera kwele 'asiana, kera ka fata 'uri fuada talada, “Na wane ne kera fata 'uri ki, kera wane 'i Galili ki tafau go. ");
INSERT INTO far_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ma 'uta ne kalu rongo kera fata na ana fatae kalu ki? ");
INSERT INTO far_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Sulia kalu leka mai fasia fere 'i Patia, ma 'i Media, ma 'i Elam, ma 'i Mesopotemia, ma 'i Jiudea, ma 'i Kapadosia, ma 'i Pontus, ma 'i Esia, ");
INSERT INTO far_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ma fasia 'i Frigia, ma 'i Pamfilia, ma 'i Ijip, ma fasia fere ki 'i Libia karangia 'i Saerin, ma tani wane kalu leka mai fasia 'i Rom. (Aia, ma tani ai amalu kera wane Jiu ki, ma tani ai amalu lau kera fi ru go mai 'i Jiu 'i buri.) ");
INSERT INTO far_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ma tani wane kera leka mai fasia 'i Krit, ma fasia 'i Arabia, ma kulu ka rongoa wane ne ki kera fata sulia na ru ni kwelelae ana ki ne God nia sasia, ma kulu ka rongo saitamana fatae kera ki ne fatae mamana kia go talaka!” ");
INSERT INTO far_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kera ka kwele 'asiana, ma kera ulafusia na ru ne kera ada to'ona. Ma kera ka ledi kera talada kera ka 'uri, “Te na ne 'uri?” ");
INSERT INTO far_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ma tani wane ada ka fata 'onionga ana kera ka 'uri, “Alamia kera ku baita ana waeni 'oto ne, ma gwauda ka garo.” ");
INSERT INTO far_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sui sa Pita ka uu fainia akwala ma te wane ni lifurongo nai ki, ma ka fata baita fuana okue nai ka 'uri, “Mulu na sasiku wane Jiu ki, ma mulu wane ki tafau ne mulu to 'i Jerusalem, mulu kai fafurongo basi mai fuaku, fua nau ku farongo kamulu ana fadalana ru ne. ");
INSERT INTO far_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Na wane ne ki nao kera si oewanea lau ana kufilana waeni ne, dia ne mulu manata to'ona. Sulia nia fi dao go ana sikwana kada sato 'i 'ofodangi. ");
INSERT INTO far_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Aia, ma na ru ne be sa Joel na profet 'e fata 'ua na mai sulia be 'uri, ");
INSERT INTO far_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘God ka fata 'uri, Ana maedangi 'isi ki, nau kai kwate dangalu ana na Anoeru Abu nau fuana wane nau ki tafau. Ma na wele fi baita kamulu ki, ma na sari kamulu ki, kera kai farongo ana fatalaku. Ma na wele fi baita kamulu ki kera kai ada to'ona na fataie ki, ma na wane ngwaro kamulu ki kera kai ada to'ona ru ki ana maleu bolee kera ki. ");
INSERT INTO far_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ana kada nai ki, nau kai kwatea laugo na Anoeru Abu nau fuana wane ma keni nau ki ne kera rao 'o'oni ma kera ka famamana, fua kera laugo kai farongo ana fatalaku. ");
INSERT INTO far_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ma nau kai fulia na ru ni kwelelae ana ki laona mamanga 'i langi, ma nau ku sasia fanadae ki 'i ano laona molagali. Laona molagali na wane ki kera kai ada to'ona ne na wane ki kera kai mae, ma na ere, ma na sasu ki. ");
INSERT INTO far_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ma 'i langi na wane ki kera kai ada to'ona na sato kai rodoa, ma na madame kai meo dia ta 'abu. 'Urinai ka sui fa dangi 'initoa nai fi dao mai, ne God kai ketoa na wane ki tafau. ");
INSERT INTO far_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sa ti boroi 'ana ne gani 'uria kwai'adomilae ana 'Aofia, nia kai famauria.’” ");
INSERT INTO far_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ma sa Pita ka fata lau 'uri, “Mulu wane Israel ki, mulu kai fafurongoa na fatae ne ki! Sa Jesus wane fasia 'i Nasaret, nia na wane ne God odua mai. God ka fatainia fua mulu ana fanadae, ma na ru ni kwelelae ana ki ne nia sasia mai ania sa Jesus. Mulu talamulu kai saitamana tafau ru ne ki ne fuli 'i safitamulu. ");
INSERT INTO far_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aia, ma God ka saitamana, ma nia ka naia na sa Jiudas ne kai kwatea sa Jesus fua mulu, ma mulu ka saungia, sulia mulu alamatainia fuana wane ne nao lau Jiu ki, kera ka foto'ia ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Boroi ma God 'e taea lau fasia maea, ma ka lugea fasia nikilalae ana maea, sulia nia 'afitai fuana maea ka dau sulia sa Jesus. ");
INSERT INTO far_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","'I nao mai sa Deved be fata 'uri suli nia, ‘Nau ku ada to'ona God ana kada ki tafau ne nia to fai nau, ma nao nau si mau, sulia nia to karangi aku. ");
INSERT INTO far_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ma sulia ru ne, nau ku eele 'asiana, ma na fatalaku ka fungu ana eelelae. Nau kai fito'ona God, ");
INSERT INTO far_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","sulia nao 'oe si alamatai nau 'uria na kula ana maea, ma nao 'oe si ala'ani nau, na Wane Abu 'oe ka fura laona kilu gwau. ");
INSERT INTO far_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ma 'oe fatainia fuaku ne nau kai mauri lau. Ma ana tolamu fai nau, 'oe kai fafungu nau ana eelea.’” ");
INSERT INTO far_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ma sa Pita nia fata nonira'a lau ka 'uri, “Wane kwaimani nau ki 'ae, nau ku fata madakwa fua mulu sulia na koko kia sa Deved na kingi. Nia mae, ma kera ka faitolia na. Ma na kilu gwau nia ka to karangi kulu ga 'ana 'i seki ta'ena. ");
INSERT INTO far_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Sa Deved nao si fata lau sulia nia talana kada nia saea ru ne. Nia ta profet, ma nia ka saitamana ga 'ana na fata alangaie God fuana. God fata alangai kai alua ta wane ana kwalafa sa Deved na kingi, nia kai gwaungai dia nia. ");
INSERT INTO far_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Sa Deved ka ada to'ona tafau na te ne God kai sasia, ma sa Deved ka fata sulia na tataelana na Christ, na wane filia God fasia na maea. God nao si lukasia laona kula ni maee, ma na nonina nao si fura. ");
INSERT INTO far_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Sa Jesus be, God taea fasia na maea, ma kalu tafau go ne kalu ada to'ona, ma kalu ka fata famamana 'urinai sulia. ");
INSERT INTO far_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","God nia fa'initoa sa Jesus ana fagourulana fua nia ka gwaungai fainia, ma God ka kwatea na Anoeru Abu fuana, dia be nia eta fata ana. Aia, ma na ru ne mulu ada to'ona, ma mulu ka rongoa ta'ena na ne sa Jesus kwate dangalu mai ana na Anoeru Abu fua malu. ");
INSERT INTO far_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Sulia nao lau sa Deved ne ra 'uria 'i langi. Boroi ma sa Deved fata lalau 'uri, ‘God nia fata 'uri fuana 'Aofia nau: 'Oe gouru 'i bali 'o'olo aku, ma 'oe gwaungai fai nau, ");
INSERT INTO far_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","makwalia kada nau kai alua malimae 'oe ki farana gwaungaie 'oe.’ ");
INSERT INTO far_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nia ne kamulu, wane Israel ki, nau ku doria mulu kai saitamana lea ana sa Jesus ne nau ku fata sulia, be mulu foto'ia ana 'airarafolo, ma God ka alua sa Jesus fua famaurilana wane ki ma ka gwaungai!” ");
INSERT INTO far_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ma ana kada ne wane ki kera rongoa ru nai, manatada ka ngwatautau 'asiana. Ma kera ka fata 'uri fuana sa Pita fainia na wane ni lifurongo ki, “Wane kwaimani nau ki 'ae, te ne kalu kai sasi fua God ka manataluge amalu?” ");
INSERT INTO far_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Sa Pita olisida ka 'uri, “Kamulu tafau, mulu kari abulo fasia ta'alae kamulu ki, ma kalu kai siuabu kamulu, sulia mulu famamana sa Jesus Christ fua God ka manataluge ana ta'alae kamulu ki, ma God kai kwatea na Anoeru Abu nia fua mulu. ");
INSERT INTO far_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God kia nia eta fatae kai kwatea na Anoeru Abu fuana wane ne nia rii 'urida fuana talana. Na eta fatalae ne nia 'afuta mulu na fainia wele kamulu, ma na wane ne kera to tau ki laugo.” ");
INSERT INTO far_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Sa Pita ka saea na ru ne ki fuada, ka raduda ka 'uri, “Mulu kai ada lea suli kamulu talamulu fasia na kwaekwaee ne kai leka mai fuana wane ta'a ki!” ");
INSERT INTO far_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ma na wane 'oro ki, kera ka famamana fatalana, ma kera ka siuabu. Ma ana fa dangi nai, bobola fainia olu to'oni wane ki ne kera ru lau mai laona fikute wane famamana nai. ");
INSERT INTO far_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ma ana maedangi ki tafau, kera fafurongoa na famanatae lifurongo ki, ma kera 'idufa to oku, ma kera ka fanga kwaimani, ma kera ka foa oku. ");
INSERT INTO far_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ma na lifurongo ki, kera fulia ru fanadae 'oro ki ma na ru ni kwelelae ana ki, ma na wane ki tafau kera ka kwele. ");
INSERT INTO far_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ma na wane ne kera famamana sa Jesus ki, kera ka 'ado fainia okue kwaimani, ma kera ka tolingia safitada kwailiu toorue kera ki. ");
INSERT INTO far_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ma tani kada kera ka 'oifoli laugo ana na alurue kera ki, ma na ano kera ki, ma kera ka tolingia malefo kera ngalia ki safitada kwailiu, ka bobola fainia kwaidorie te te wanea adalu ne doria. ");
INSERT INTO far_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ma kera ka oku ana maedangi ki tafau laona fa labu ana Beu Abu God. Ma kera ka fanga oku kwaimani laona lume kera ki, ma kada kera oku 'urinai, kera ka eele 'asiana fainia na gwarimabelae laona maurilada. ");
INSERT INTO far_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ma kera ka tangoa God, ma na wane ki tafau 'i Jerusalem ka eele faida. Ma ana maedangi ki tafau, na 'Aofia ka famauria tani wane lau, ma kera ka ru mai laona fikute wane famamana ne. ");
INSERT INTO far_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ana te maedangi, sa Pita ma sa Jon, keroa leka 'uria Beu Abu God ana oluna kada sato saulafi, sulia kada sato nai, kada Jiu ki fua folae. ");
INSERT INTO far_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ana maedangi ki tafau, wane ki kera 'idufa ngalia mai te wane 'aena mae safali mai ana kada ana futalana. Ma kera ka alua mana tafa ana Beu Abu God. (Na tafa nai, kera saea ana “Mae Tafa Kwanga.”) Ana maedangi ki tafau, nia to senai, fua ka gani malefo ana wane ne kera ru kau laona Beu Abu God. ");
INSERT INTO far_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ma kada nia ada to'ona sa Pita fainia sa Jon keroa ru kau, nia ka gani keroa fua keroa ka kwatea ta ru fuana. ");
INSERT INTO far_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ma keroa ka bubu tete fuana, ma sa Pita ka fata 'uri fuana, “Ada mai fuamaro.” ");
INSERT INTO far_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ma nia ka bubungi keroa, ka manata 'ana fua keroa ka kwatea ta ru fuana. ");
INSERT INTO far_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ma sa Pita ka fata 'uri fuana, “Nao nau si to go ana ta malefo. Boroi ma nau kwate fuamu na ru ne nau ku to ana. Nau ku saea fuamu, ana satana sa Jesus Christ wane 'i Nasaret 'oe tatae, ma 'oko fali.” ");
INSERT INTO far_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Go sa Pita ka dau ana 'aba 'o'olo nia, ma ka taea. Ma 'ali'ali go 'aena tafau ka nikila na, ");
INSERT INTO far_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ma nia ka lofo, ma ka uu ana ro 'aena ki, ma nia ka fi safali ka fali kwailiu. Ma nia ka ru kau fai keroa 'uria laona fa labu ana Beu Abu God, ka fali, ma ka ngwae sakasaka ma ka tangoa God. ");
INSERT INTO far_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ma kada wane nai ki, kera ada to'ona nia fali, ma ka fata lea ana God, ");
INSERT INTO far_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","kera ada saitamana ne nia na wane gani be leka ru kai to mana tafa ana Beu Abu God. Ma kera ka kwele 'asiana ana ru ne fuli fuana wane nai. ");
INSERT INTO far_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kada nai, wane ne ka dau ngasi na ana sa Pita fai sa Jon, na wane 'oro ki kera ka kwele 'asiana, ma kera ka lae 'ali'ali siada laona kula ana Beu Abu God ne kera saea ana “Taofa sa Solomon.” ");
INSERT INTO far_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Kada sa Pita ada to'ona na wane nai ki, nia ka fata 'uri fuada, “Mulu wane Israel ki, 'uta ne mulu ka kwele ana ru ne, ma mulu ka bubungi karo na 'amulu 'uri? Alami kamulu kwaisae na nikilalae karo talamaro, ma na tolae abu karo ne karo gura ana na wane ne ma nia ka fali? ");
INSERT INTO far_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","God ne sa Abraham, sa Aesak, ma sa Jakob kera fosia, God be koko kia ki, nia tala fa'initoa na wane rao nia sa Jesus. Boroi ma mulu ka kwatea lalau sa Jesus fuana fanaonao ki. Ma kada sa Paelat nia ketoa, kamulu noni'ela 'ani nia, ma mulu ka fata falia 'asiana kada be sa Paelat saea fua lugelana. ");
INSERT INTO far_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Sa Jesus na wane abu, ma ka 'o'olo be God filia fuana famaurilana wane nia ki, boroi ma mulu noni'ela ana, ma mulu ka 'ingoa lalau sa Paelat fua lugelana wane ne sauwanee. ");
INSERT INTO far_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ma mulu ka saungia sa Jesus na safalie ana maurie. Boroi ma God ka taea fasia na maea, ma karo ka ada to'ona mamanalana ru ne. ");
INSERT INTO far_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mulu ada to'ona na wane ne, ma mulu ka ada saitamana. Nia famamana na nikilalae sa Jesus ne ka famauria. Fitoe ana sa Jesus ne kwate wane ne ka 'akwa ne mulu ka ada to'ona tafau na. ");
INSERT INTO far_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“'Urinai wanefuta nau ki 'ae, nau ku saitamana kamulu fainia fanaonao ki mulu sasi 'urinai ana sa Jesus, sulia mulu ulafusi ru. ");
INSERT INTO far_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Boroi ma God saea na mai 'ua 'i nao ana na profet ki fua na wane filia nia kai nonifi. Ma nia 'urinai fua ka famamana na fatalana God. ");
INSERT INTO far_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","'Urinai mulu kai kari abulo na, ma mulu ka abulo 'uria God, fua nia ka manatalugea abulo ta'alae kamulu ki, ma fua God ka faeelea na maurilamulu, ");
INSERT INTO far_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ma nia ka kwatea mai sa Jesus Christ wane be nia filia na fua mulu. ");
INSERT INTO far_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Nia to mai 'ana 'i langi leka ka dao ana kada God kai fafalua ru ki tafau, dia be nia saea mai 'ua na ana profet abu nia ki. ");
INSERT INTO far_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sulia sa Moses fata sulia na 'Aofia ka 'uri, ‘God kamulu kai kwatea kau te profet siamulu, dia laugo ne nia eresi nau mai. Nia ta wane amulu wane Jiu ki. Mulu kai rosulia na te ki ne nia saea fua mulu. ");
INSERT INTO far_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Sa ti boroi 'ana ne nao si rosulia na te ne na profet nai saea, God kai efoa nia ka to 'e'ete fasia wane nia ki ma ka saungia.’ ");
INSERT INTO far_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Sa Samuel, ma na profet ki tafau ne kera leka mai 'i buri, kera to ana na farongoe ne fasia God, kera ka 'ainitaloa laugo 'ana te ne nia fuli na ana kada ne. ");
INSERT INTO far_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Na fata alangaie God ki fua mulu nia dao mai ana na profet nia ki. Ma mulu 'ado laugo ana fainia na koko kamulu ki ana alangaie God fuada, dia nia saea fuana sa Abraham ka 'uri, ‘Nau kai falea wane ki tafau laona molagali, sulia na wane ne nia futa olitamu.’ ");
INSERT INTO far_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nia ne, God ka filia mai ma ka kwatea mai na wane rao nia sa Jesus siamulu, fua nia ka falea kamulu, ana kada mulu kari abulo fasia ta'alae kamulu ki.” ");
INSERT INTO far_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ana kada sa Pita fainia sa Jon keroa faorai 'ua ga 'ada fua tooa ki, tani fataabu, ma tani Sadusi, ma na fanaonao ana wane ne kera folo 'usia Beu Abu God, kera dao mai siada. ");
INSERT INTO far_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Kera guisasu, sulia na ro lifurongo ne ki keroa famanata wane ki ne sa Jesus nia tatae na fasia maea, ma ka fatainia ne na wane ne kera mae ki boroi kera kai tatae laugo fasia maea. ");
INSERT INTO far_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Nia ne kwatea kera ka dauda, ma kera ka aluda laona beu ni kanie, ma keroa ka to senai makwalia ruana maedangi, sulia nia saulafi na. ");
INSERT INTO far_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ma wane 'oro ne kera rongoa fatae keroa ki, kera ka famamana. Ma na wane ne kera famamana na farongoe lea kada nai, nia bobola fainia lima to'oni wane ki. ");
INSERT INTO far_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ana maedangi 'i buri, wane fanaonao Jiu ki, ma wane famanata ana taki ki, kera oku 'i Jerusalem. Kera na fikute wane lokoeru. ");
INSERT INTO far_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kera oku fainia sa Anas na 'inita fataabu, ma sa Kaeafas, sa Jon, sa Aleksanda fainia tani wane lau ana kwalafa ana 'inita fataabu. ");
INSERT INTO far_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Sui kera ka fauua sa Pita fainia sa Jon 'i naofada tafau, ma kera ka ledida ka 'uri, “Kamoro gura 'uta ana na wane 'aena 'e mae ne? Na mamanae te ne kamoro too ana, ma na nikilalae ana sa ti ne kamoro gura ana?” ");
INSERT INTO far_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ma na Anoeru Abu ka sura ana sa Pita ma nia ka fata 'uri fuada, “Kamulu wane fanaonao ki, ma na wane gwaungai ki, ");
INSERT INTO far_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","mulu ledi karo ta'ena sulia na ru lea ne karo sasia fuana wane 'aena 'e mae, ma te ne kwate nia ka lea. ");
INSERT INTO far_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Karo dori kamulu fainia wane ki tafau 'i Israel mulu ka saitamana ru ne, na wane ne mulu ada to'ona, nia 'akwa, ma ka uu na fai kamulu, nia 'akwa ana na nikilalae sa Jesus Christ na wane fasia 'i Nasaret be kamulu saungia ana 'airarafolo ma God ka taea fasia na maea. ");
INSERT INTO far_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Na Kekedee Abu be fata sulia sa Jesus ka 'uri, ‘Nia na fau ne mulu na wane saungai lume ki, mulu noni'ela ana. Nia ne na fau ne talingai ka liufia na fau ki tafau ana 'odoe.’ ");
INSERT INTO far_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Taifilia nia go ne saitamana ka famauria wane ki, nao na ta wane lau laona molagali, ne God kwatea fua ka famauri kia.” ");
INSERT INTO far_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ma fikute wane lokoeru, kera ka kwele 'asiana ana sa Pita ma sa Jon, sulia nao keroa si mau ana fata nonira'alae. Ma kera ka kwele laugo ana saitamarue keroa, ro wane ne ki nao keroa si susuli ru go. Ma kera saitamana keroa ro wane dee ie ki go. Ma kera ka saitamana ne keroa ro wane be liu oku laugo fainia sa Jesus. ");
INSERT INTO far_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ma kera ka ulafusia na saelana lau ta ru, sulia na wane be keroa gura nia uu laugo fai kera. ");
INSERT INTO far_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","'Urinai ne kera ka kwatea sa Pita, ma sa Jon, fainia na wane nai, kera ka ru kau 'i maa fasia kula ni okulae nai. Sui, kera fata basi 'ada sulia te ne kera kai sasia ana sa Pita ma sa Jon. ");
INSERT INTO far_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ma kera ka fata 'uri, “Te ne kulu kai sasia ana ro wane ne ki? Sulia na wane ki tafau ne kera to 'i Jerusalem, kera saitamana tafau go na fanadae ne keroa sasia, ma nao kulu si bobola fua tofelana. ");
INSERT INTO far_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Boroi ma fua ru ne ka nao si talo fuana tani wane lau, kulu saea fuada nao keroa si fata lau sulia sa Jesus fuana tani wane lau.” ");
INSERT INTO far_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Sui kera ka saeda lau mai 'uria sa Pita ma sa Jon, kera ka fata talingai 'uri fuada, “Nao kamoro si fata lau ana ma nao moro si famanata na sulia sa Jesus.” ");
INSERT INTO far_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ma sa Pita fainia sa Jon keroa olisida ka 'uri, “Kamulu manata basi, na te ne 'o'olo maana God, na rolae suli kamulu, naoma rolae sulia God? ");
INSERT INTO far_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nao karo si mango na fasia fatae sulia te ne karo tala ada to'ona, ma karo ka rongoa.” ");
INSERT INTO far_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ma na fikute wane lokoeru, kera ka fata nikila lau fuada. Sui kera ka lugeda, fasi wane ki ka fualida fafia kwae ladaro, sulia wane ki tafau, kera tangoa God fafia te ne keroa fulia. ");
INSERT INTO far_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Sulia wane ki saitamana taifilia God go ne ka gura wane ne matai na sulia fai akwala fangali ma ka tarenga ana maurilana. ");
INSERT INTO far_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kada kera alamatainia fua keroa ka leka na 'ada sa Pita ma sa Jon, ka oli lau siana fikute wane keroa, ma keroa farongoda ana ru ne fataabu baita ki ma wane fanaonao ki kera saea. ");
INSERT INTO far_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ana kada kera rongoa, kera ka fosia God kera ka 'uri, “God 'initoa 'ae, 'oe ne saungainia na mamanga, na molagali, na asi, ma na ru mauri ki tafau 'i seki. ");
INSERT INTO far_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ma 'oe kwatea na Anoeru Abu 'oe fuana koko kalu sa Deved na wane rao 'oe, fua ka fata 'uri, ‘Na wane ne nao lau Jiu ki, kera guisasu fuaku, ma kera ka tatae suali nau sulia manatae wane oewanea kera ki. ");
INSERT INTO far_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Na kingi ki kera sasi akau 'ada talada ma na wane 'initoa ki kera ka oku fua firue fainia God ma Christ na wane filia nia.’ ");
INSERT INTO far_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Sulia ru ne fuli kada sa Herod Antipas ma sa Pontias Paelat, keroa oku laona fere nai fainia wane ne nao lau Jiu ki ma na wane Israel ki laugo. Kera oku fuana ketolana sa Jesus, na wane rao abu 'oe ne 'oe filia na. ");
INSERT INTO far_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kera oku fuana famamanalana ma sasilana na ru ki tafau, dia be 'oe naia na mai, sulia ana nikilalae 'oe, ma na kwaidoria 'oe fua ka fuli 'urinai. ");
INSERT INTO far_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ma ana kada ne God 'ae, 'oe ada to'ona basi fatae talingai kera ki, ma 'oe kwatea mai na nikilalae 'oe fua malu na wane rao 'oe ki, fua kalu fata nonira'a ana fatalamu. ");
INSERT INTO far_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","'Oe fatainia mai nikilalae ma 'oe gura wane ki, fua kera ka ada to'ona fulilana ru fanadae ki, ma na ru ni kwelea ki, ana satana wane rao abu 'oe sa Jesus.” ");
INSERT INTO far_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ma ana kada kera foa ka sui go, kula ne kera oku ana ka gelogelo na. Ma na Anoeru Abu ka sura adalu tafau, ma kera ka fata nonira'a na ana fatalana God. ");
INSERT INTO far_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ma wane ki ne kera famamana, kera oku ana te manatae wane. Ma nao ta wane si to ana ta ru ne nia kai saea ana ru nia talana, boroi ma kera tolingia 'i safitada na ru kera ki tafau. ");
INSERT INTO far_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ma na lifurongo ki ka 'ainitaloa nonira'a sulia tataelana na 'Aofia sa Jesus fasia na maea, ma God ka falea kera tafau. ");
INSERT INTO far_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ma nao ta wane laona fikute wane ana tooa kera ne ka bobo 'uria ta ru, sulia tani kada ne kera bobo, tani wane ada ne kera to ana gano naoma ta lume, kera ka 'oifoli 'anida. Sui kera ka ngalia mai malefo nai ki, ");
INSERT INTO far_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kera ka kwatea fuana lifurongo ki, kera ngalia, kera ka tolingia fuada tafau sulia bobolae kera ki. ");
INSERT INTO far_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ma sa Josef te wane ana kwalafa sa Lifae be futa 'i Saeprus be lifurongo ki kera saea ana sa Banabas (fadalana ne Wane ana Kwairadui), ");
INSERT INTO far_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","nia 'e 'oifoli ana te lifu gano nia, ka ngalia malefo nai, ka kwatea fuana lifurongo ki. ");
INSERT INTO far_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Boroi ma te wane ne satana sa Ananaeas, fainia 'afe nia ni Safaera, keroa to laugo fainia na fikute wane famamana nai. Ma keroa ka 'oifoli laugo ana ta bali ana gano keroa. ");
INSERT INTO far_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ma sa Ananaeas ka alua ta bali ana malefo nai fuada, ka ngalia go mai 'ana ta bali ana malefo nai ka kwatea fuana lifurongo ki, ma nia ka saea nia tafau na nai. Ma na 'afe nia boroi ka ala laugo fafia sukee nai. ");
INSERT INTO far_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","'Urinai sa Pita ka ledi 'uri ana, “Ananaeas 'ae, 'uta ne 'oe alamatainia sa Saetan ka talai 'oe, ma ka sasia 'oko sukea na Anoeru Abu ana agwatailana ta bali ana malefo be kamoro ngalia? ");
INSERT INTO far_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'I naona ne 'oe foli ana na gano be, nia ne ru 'oe. Ma burina 'oe foli ana, malefo 'oe ngalia 'uria ru nena, 'oe ne 'oe baita fuana, ma 'oe saitamana sasia 'amu ana ta ru sulia na kwaidoria 'oe. 'Uta ne 'oe manata 'urinai laona manatalamu? Nao 'oe si sukea go wane ki, 'oe sukea lalau God!” ");
INSERT INTO far_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kada sa Ananaeas nia rongoa na ru nai, nia ka 'asi 'i ano, ma ka mae na. Ma na wane ne kera rongoa ru nai, kera mau 'asiana. ");
INSERT INTO far_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ma tani wele fi baita ki kera ru mai, kera ka 'afua nonina. Ma kera ka ngalia 'i maa, ma kera ka faitoli na ana. ");
INSERT INTO far_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bobola fainia ta olu kada sato 'i burina, na 'afe nia ka ru mai laona lume ana kula ne sa Pita nia to ana, ma nao nia si saitamana laugo ana te ne fuli fuana arai nia. ");
INSERT INTO far_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ma sa Pita ka ledi 'uri ana, “Farongo nau basi mai, 'uri ma na malefo be tafau na ne arai 'oe fai 'oe moro ngalia 'uria na gano be kamoro 'oifoli ana?” Ma nia olisia ka 'uri, “Iu, nia tafau na be.” ");
INSERT INTO far_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Go sa Pita ka ledi lau 'uri ana, “'Uta ne arai 'oe fai 'oe, moro ka sukea na Anoeru Abu God, ma kamoro kwaisae nia si keto kamoro go? Na wane be kera faitolia na arai 'oe, kera uu ga 'ada 'i 'aena mae ana kada ne. Ma kera kai ngali 'oe laugo fua kera ka faitoli amu.” ");
INSERT INTO far_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ma 'urinai go ni Safaera ka 'asia laugo 'i ano maana 'aena sa Pita, ma ka mae na. Ma na wele fi baita be ki kera ru mai, ma kera ka ada to'ona ne nia mae na, kera ka ngalia 'i maa, ma kera ka leka faitolia laugo ninimana arai nia. ");
INSERT INTO far_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Na wane famamana ki, ma wane ki tafau laugo ne kera rongoa ru nai, kera mau 'asiana. ");
INSERT INTO far_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Na lifurongo ki, kera fulia ru 'oro ni kwelelae ana ma na fanadae ki safitana na wane ki. Ma wane famamana ki tafau, kera oku laona Beu Abu God ana kula ne kera saea ana Taofa sa Solomon. ");
INSERT INTO far_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ma ta wane ne nao si famamana, nao nia si nonira'a fuana ka oku faida, sui boroi 'ana wane ki ka tangoa na wane famamana ki ma ka saea kera lea. ");
INSERT INTO far_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Boroi ma wane 'oro ki, ma keni 'oro ki laugo, kera famamana na 'Aofia, ma kera ka oku laugo laona fikute wane nai. ");
INSERT INTO far_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ma sulia ru ne lifurongo ki kera fulida, na wane senai ki kera ngalia wane matai ki, ma kera ka aluda sulia na taale fafona 'ifitai kera ki, fua kada sa Pita nia liu, na nununa boroi ka liu fafida, ma kera ka 'akwa. ");
INSERT INTO far_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ma na wane 'oro ki kera leka mai fasia na fere ki kalia 'i Jerusalem, kera ngalia mai wane kera ki ne kera matai fainia wane ne anoeru ta'a ki fafida, ma na lifurongo ki kera ka gurada, ma kera tafau kera ka 'akwa laugo. ");
INSERT INTO far_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ma na 'inita fataabu, fainia wane nia ki ne kera to laona fikute wane Sadusi ki, kera kwaifi 'asiana fuana lifurongo ki. ");
INSERT INTO far_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ma kera dauda, kera ka aluda laona beu ni kanie. ");
INSERT INTO far_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Boroi ma ana fa rodo nai, na 'ainsel God dao mai, ma ka 'ifingia mae ki ana beu ni kanie nai, ka talaida 'i maa, ma ka fata 'uri fuada, ");
INSERT INTO far_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mulu leka, mulu ka uu laona Beu Abu God, mulu ka farongoa wane ki sulia na maurie falu ne.” ");
INSERT INTO far_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Na lifurongo ki kera ka rosulia na 'ainsel nai, ma 'i 'ofodangi makalokalo, kera ka leka na laona Beu Abu God, ma kera ka safali na ana famanatalae. Na 'inita fataabu fainia wane nia ki, kera ka akwa mai 'uria na wane fanaonao ana Jiu ki fua fikute wane lokoeru, fua kera ka filoa na lifurongo ki. Ma kera ka kwate fatae fuana wane ni omee ki, kera ka talaia mai lifurongo ki fasia laona beu ni kanie siada. ");
INSERT INTO far_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Boroi ma kada ne wane ni omee ki kera dao kau, kera nao si ada to'ona na ta te wane ana lifurongo ki laona beu ni kanie. Ma kera oli kera ka farongoa wane fanaonao ki kera ka 'uri, ");
INSERT INTO far_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Kada kalu dao kau laona beu ni kanie, kalu ada to'ona ne wane ni folo ki kera bilaki ngasi 'asiana ana mole'ana mae loko ki, ma kera ka folo ga 'ada maana mae ki. Boroi ma kada kalu 'ifi, kalu ka ada kau laona, nao kalu si ada to'ona go to'ona ta te wane ana lifurongo ki.” ");
INSERT INTO far_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Kada ne fataabu baita ki, ma na wane fanaonao ana na wane ni folo ki ana Beu Abu God, kera rongoa ru ne, kera ka filoda kwailiu 'uria te lau ne kai fuli. ");
INSERT INTO far_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","'Urinai te wane 'e ru mai, ma ka fata 'uri fuada, “Mulu fafurongoa basi, na wane be mulu aluda laona beu ni kanie, kera uu na 'ada laona Beu Abu God, ma kera ka famanata na wane ki!” ");
INSERT INTO far_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ma na wane gwaungai ana wane ni folo ki fainia na wane nia ki, kera leka, kera ka oli mai fainia na lifurongo ki. Kera nao si kwae laelae lau sulida fuana olilae mai, sulia kera mau ana wane ki, fasia kera ka 'ui fauda lalau. ");
INSERT INTO far_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ma kada kera talaia mai na lifurongo ki, ma kera ka fauuda naofana na fikute wane lokoeru ne kera oku mai, na 'inita fataabu ka fata fuada ka 'uri, ");
INSERT INTO far_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Kalu lui talingai ana nao kamulu si famanata lau ana sa Jesus. Boroi ma na famanatae kamulu talofia na laona fere 'i Jerusalem. Ma kamulu ka 'ui fafi kalu sae kalu lalau ne saungia sa Jesus ka mae!” ");
INSERT INTO far_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Sui sa Pita fainia lifurongo ki kera olisida kera ka 'uri, “Kalu rosulia God ma nao lau wane ki. ");
INSERT INTO far_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ma burina ne mulu saungia sa Jesus ana na 'airarafolo ka mae, God be koko kia ki ne taea fasia maea. ");
INSERT INTO far_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ma God taea nia ka gwaungai fainia fua nia ka kwaitalai ma ka famauri, ma ka kwatea kada fuana wane Israel ki, fua kera kai kari abulo, ma nia ka manatalugea ta'alae kera ki. ");
INSERT INTO far_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kalu ada to'ona ru ne fuli fuana sa Jesus ki, ma kalu fainia na Anoeru Abu ka fata ana famamanalae sulia. God kwatea mai na Anoeru Abu fuana sa tifaida ne kera rosulia.” ");
INSERT INTO far_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ma kada ne wane laona fikute wane lokoeru kera rongoa ru ne, kera ka guisasu 'asiana, ma kera dori saungia lifurongo nai ki. ");
INSERT INTO far_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Boroi ma te wane ana fikute wane lokoeru nai, ma nia ta wane laugo ana fikute wane na Farasi ki ne satana sa Gamaliel, na wane famanata ana taki ki, ne wane ki kera fabaita ana, nia tatae ka saea kera ka olitainia basi 'ada na lifurongo ne ki 'i maa fua kada tu'u. ");
INSERT INTO far_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Sui, nia ka fata 'uri fuana wane fanaonao nai ki, “Kamulu wane Israel ki, mulu manata lea sulia na ru ne mulu sasia ana wane ne ki. ");
INSERT INTO far_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Sulia nao si tau go kau, sa Tedas leka mai ka saea nia ta wane 'inito, ma ka bobola fainia fai telenge wane ki ne kera leka sulia. Ma nao si tau go, wane ni omee Rom ki kera ka saungia, ma na fafurongo nia ki kera ka takalo tafau, ma na raoe be nia sasia ka sui laugo 'ana. ");
INSERT INTO far_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Sui burina, sa Jiudas na wane 'i Galili ka leka lau mai ana kada kera kedea satana wane ki tafau. Ma wane 'oro ki ne kera leka sulia ma kera ka fualia wane 'i Rom ki, boroi ma wane ni omee 'i Rom ki kera ka saungia laugo. Ma na fafurongo nia ki ka takalo laugo 'ada. ");
INSERT INTO far_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ma sulia na ru ne fafurongo sa Jesus ki kera sasia, nau ku saea fua mulu, nao mulu si sasia ta ru ada. Mulu ala'anida kera ka leka kau 'ada ma mulu ka leka fasida. Dia na manatalae ma na raoe ne kera sasia ne ru go ana wane, nia kai funu laugo 'ana. ");
INSERT INTO far_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ma dia nia leka mai fasia God, nia 'afitai fua mulu ka tatae sualida, ma mulu kai dao to'ona ne mulu firu fai God.” Ma na fikute wane lokoeru nai, kera ka rosulia fatalana sa Gamaliel. ");
INSERT INTO far_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Sui kera oli lau mai fainia na wane ni lifurongo ki, ma kera ka saea fuana wane ni folo ki ka namusida. Ma kera ka luida nao kera si fata lau sulia sa Jesus. Sui, kera ka lugeda. ");
INSERT INTO far_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ma kada ne lifurongo ki kera leka na fasia fikute wane lokoeru nai, kera ka eele 'asiana, sulia God nia alafafida ne kera bobola fuana nonifilae sulia sa Jesus. ");
INSERT INTO far_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ma ana maedangi ki tafau, na lifurongo ki kera leka 'i laona Beu Abu God, ma 'i laona lume wane ki, ma kera ka famanata, ma kera ka 'ainitalo ana Farongoe Lea ne sa Jesus nia na Christ, na wane filia God. ");
INSERT INTO far_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ma ana kada nai, wane ne kera famamana sa Jesus ki, kera 'oro na. Ma na 'ugalae ka tatae safitana Jiu ne kera fata ana na fatae Jiu fainia Jiu ne kera fata ana fatae Grik. Tani ai ada ne kera fata ana fatae Grik, kera 'uga, sulia Jiu ne kera fata ana fatae Jiu nao kera si 'adomia go na gwa 'oru kera ki ne fata ana fatae Grik, ka bobola laugo fainia gwa 'oru Jiu ne kera fata ana fatae Jiu, ana na fanga ma na malefo ne kera tolingia ana maedangi ki tafau. ");
INSERT INTO far_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ma na akwala ma ro lifurongo ne ki, kera ka akwa mai 'uria wane famamana ki tafau, kera ka fata 'uri, “Nao nia si lea ne kalu 'abero lau ana tolingilana malefo kulu ki, ma kalu ka manata buro na amalu ana fatalolana fatalana God. ");
INSERT INTO far_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nia 'urinai wanefuta nau ki 'ae, mulu filia mai ta fiu wane lea safitamulu ne mulu saitamana na Anoeru Abu nia sura ada, ma kera ka saitamaru, fua kera ka ada sulia na raoe ne. ");
INSERT INTO far_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma kalu ka rao te bali na amalu ana folae ma na 'ainitalolae fatalana God.” ");
INSERT INTO far_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ma na wane nai ki, kera oku, kera eele kada kera rongoa ru nai, ma kera ka filia sa Stefen, wane ne Anoeru Abu talaia, ma na famamanae nia ka nikila. Ma kera ka filia laugo sa Filip, sa Prokorus, sa Nikano, sa Timon, sa Pamenas, ma sa Nikolaus na wane fasia 'i Antiok ne nia dau sulia famanatalae wane Jiu ki, boroi 'ana nia nao si futa lau mai ana ta wane Jiu. ");
INSERT INTO far_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sui, na fikute wane famamana nai, kera talaia mai fiu wane nai ki siana na lifurongo ki, ma na lifurongo nai ki kera ka foa fai kera, ma kera ka alua 'abada fafia gwauda. ");
INSERT INTO far_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ma na fatalana God ka talofia na 'i Jerusalem ma na wane famamana 'i Jerusalem ki, kera 'oro 'asiana mai, ma na fataabu 'oro ki laugo, kera ka famamana. ");
INSERT INTO far_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Sa Stefen na wane ne God falea, ma ka kwate nikilalae fuana sasilana fanadae 'oro ki ma na ru ni kwelelae ana ki 'i safitana wane ki. ");
INSERT INTO far_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ma tani wane ne kera noni'ela ana sa Stefen, kera to laugo laona fikute wane kera saea ana “Na beu fuana folae 'ana wane kera to sakwadola ki.” Tani wane ada kera Jiu ne leka mai fasia 'i Saerin, ma 'i Aleksandria. Kera fainia tani Jiu fasia lofaa 'i Silisia, ma 'i Esia ki, kera etangia olisusue fainia sa Stefen. ");
INSERT INTO far_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ma na Anoeru Abu ka kwatea saitamarue fuana sa Stefen, fua kada nia fata ana, 'afitai ta wane ka olisia. ");
INSERT INTO far_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Sui kera ka foli agwa ana tani wane fua kera ka saea, “Kalu rongoa nia fata buri tolingai sa Moses fainia God.” ");
INSERT INTO far_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","'Urinai na wane ne ki kera ka suradua tooa ki, fainia fanaonao ki, ma na famanata ana taki ki, ma kera ka guisasu 'asiana, ma kera leka mai siana sa Stefen, ma kera ka daua, ma kera ka talaia mai siana na fikute wane lokoeru. ");
INSERT INTO far_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Sui kera ka akwa mai 'uria tani wane fua kera ka suke fafia. Kera fata 'uri, “Sulia maedangi ki, na wane ne nia fata buri tolingai ana Beu Abu God, fainia na taki sa Moses ki. ");
INSERT INTO far_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kalu rongoa nia saea sa Jesus wane 'i Nasaret nia kai okosia na Beu Abu God, ma kai talana laugo na falafala kia ki ne sa Moses kwatea na fuaka.” ");
INSERT INTO far_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ma na wane ne kera to laona fikute wane lokoeru ne, kera ka alu maada ana sa Stefen, ma kera ka ada to'ona ne na maana 'e ngwasinasina ka dia na ta 'ainsel. ");
INSERT INTO far_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","'Urinai na 'inita fataabu ka ledia sa Stefen ma ka fata 'uri, “'Uri ma ru ne kera fai fafi 'oe ana ki, nia mamana ne?” ");
INSERT INTO far_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sa Stefen olisida ka 'uri, “Wane kwaimani nau ki, ma maa nau ki 'ae, mulu fafurongo nau basi! God ne 'initoa ma ka nikila, nia fatai fuana koko kia sa Abraham kada nia to 'ua 'i Mesopotemia, sui nia fi leka to 'i Haran. ");
INSERT INTO far_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","God fata 'uri fuana, ‘'Oe tatae fasia na fui wane 'oe, ma na fere 'oe, 'oko leka 'uria na gano ne nau ku saea 'oe kai leka 'uria.’ ");
INSERT INTO far_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Sui nia ka leka fasia lofaa nia 'i Kaldia, ma ka leka to 'i Haran. Ma burina na maa sa Abraham nia mae, God ka sae nia ka 'idu mai 'uria na gano ne mulu to na ana 'i ta'ena, ne kera saea 'i nao ana 'i Kenan. ");
INSERT INTO far_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Aia, God nao si kwatea go ta bali ana gano ne fuana sa Abraham, ta bali tu'u boroi fua sae sa Abraham ka to ana 'e nao laugo. Boroi ma God nia eta fatae fua sa Abraham ne nia kai kwatea na gano nai fua gano nia na 'ana, fainia na olitana kwalafa nia. Ma kada God nia eta fatae fuana, sa Abraham nao nia si to 'ua ana ta wele. ");
INSERT INTO far_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","'I buri God ka fata 'uri fuana, ‘Na olitamu kai to ana gano ne nao lau gano kera, ma 'i senai kera kai rao 'o'oni. Ma na wane ki kera kai famalagaigaida sulia fai talanga fangali ki. ");
INSERT INTO far_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Boroi ma nau ku kwatea kwaekwaee fuana wane ne kera rao fuada ki. Ma 'i buri, na olitamu kera kai sakatafa mai fasia fere nai, ma kera kai fosi nau laona kula ne.’ ");
INSERT INTO far_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“God eta fatae fuana sa Abraham ma ka saea fuana, dia na wane nia ki kera 'ole 'unge, kera alafafia na alangaie nia. Nia ne sa Abraham ka 'ole 'unge ana sa Aesak, fiu maedangi ki 'i burina ne nia futa. 'Urinai laugo, sa Aesak ka 'ole 'unge ana wele nia sa Jakob, ma sa Jakob ka 'ole 'unge ana akwala ma ro wele nia ki ne kera na ne na koko kia ki. ");
INSERT INTO far_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Sa Josef ne ta wane na ana akwala ma ro wele nai sa Jakob fafutada ki. Na saoana ki tafau lioda kwaifi fuana, ma kera ka foli ana fuana wane ne kera leka 'uria 'i Ijip ki, fua sae nia kai rao 'o'oni 'i senai. Boroi ma God nia to fainia, ");
INSERT INTO far_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ma ka tagi sulia laona 'afitaie nia ki. Kada sa Josef nia dao siana na kingi 'i Ijip, God kwatea na saitamarue fuana, ma ka kwai'adomi ana ne kwate ma na kingi ka doria, ma ka alu nia ka gwaungai ana tooa 'i Ijip, ma ka alua nia ka ada laugo sulia na toorue nia ki tafau. ");
INSERT INTO far_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ma kada nai laugo ne na uni fioloe baita ka liu laona lofaa 'i Ijip ma 'i Kenan, ne ka kwatea na 'afitaie baita fuana wane ki. Ma kada nai, nia 'afitai 'asiana fuana sa Jakob fainia wele nia ki ka dao to'ona ta fanga. ");
INSERT INTO far_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nia ne kada sa Jakob rongoa ne na fanga 'e 'oro 'i Ijip, nia ka kwatea wele nia ki (ne koko kia ki), kera ka eta leka dao 'i senai. ");
INSERT INTO far_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","'Urinai ana ruana kada ne kera leka lau mai, sa Josef ka fata madakwa 'ani nia fuana saoana ki ma kera fi ada saitamana. Ma na kingi boroi ka saitamana laugo fui wane sa Josef ne kera to 'i Kenan. ");
INSERT INTO far_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ma sa Josef ka kwate fatae 'uria na maa nia sa Jakob, ma ka sae nia fai na kwalafa nia tafau kera ka leka mai 'uria 'i Ijip. Ma kera na fiu akwala ma lima wane ki. ");
INSERT INTO far_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Sa Jakob ka leka 'uria 'i Ijip fainia wele nia ki, ma kera ka to leka kera mae na 'i senai. ");
INSERT INTO far_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kera ka ngalia nonida kera ka faitoli ada 'i Sekem fere laona lofaa 'i Kenan, na gano be sa Abraham folia fasia na kwalafa sa Hamor. ");
INSERT INTO far_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Ma na kada karangi na fuana God ka famamana na fata alangaie ne nia sasia fuana sa Abraham, na wane kulu ki ne kera to 'i Ijip, kera 'oro 'asiana. ");
INSERT INTO far_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ana kada nai, na kingi falu, ne nao si saitamana ta falafala sulia sa Josef, nia safali ka gwaungai ana 'i Ijip. ");
INSERT INTO far_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Nia ka sukeda na koko kia ki, ma ka famalagaigaida, ma ka fata totongai fuada, fua kera ka alua wele kera ki 'i maa, fua kera ka saungida. ");
INSERT INTO far_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ma ana kada sa Moses nia futa mai ana, nia na wele sualana lea 'asiana. Ma gaa nia ka ada sulia go sulia olu madame ki laona lume nia. ");
INSERT INTO far_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ma kada kera alua sa Moses 'i maa, na sari na kingi 'i Ijip ngalia, ka sangonia, ma ka ada sulia dia na 'ana wele nia. ");
INSERT INTO far_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Wane 'i Ijip ki kera famanata sa Moses ana ru 'oro ne wane saitamaru 'i Ijip ki kera saitamana. Ma nia ka baita na, ma nia ta wane talingai ana fatalana ma na abulolana. ");
INSERT INTO far_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Ma kada sa Moses nia baita mai ka dao ana fai akwala fangali ki, nia manata 'uria kai dao siana wane nia ki ana kwalafa sa Israel. ");
INSERT INTO far_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ma kada nia dao, nia ka ada to'ona te wane Jiu ne wane Ijip nia mala ta'a 'asiana ana. Ma nia leka kau ka 'adomia, ma ka duua ana saungilana wane Ijip nai. ");
INSERT INTO far_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Nia ka kwaisae na wane nia ki fulina kera ka saitamana ne God 'e filia nia fuana talailada fasia na famalagaigailada 'i Ijip, boroi ma na wane ki tafau nao kera si saitamana go. ");
INSERT INTO far_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ma ana te maedangi lau, nia ada to'ona ro wane Jiu ki keroa firu, ma nia ka sasi 'uria kwatelana aroaroe safitadaro ma nia ka fata 'uri, ‘Kamoro rongo basi, kamoro na ro wane Israel ki go na. Tala'ana nao moro si firu lau.’ ");
INSERT INTO far_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ma te wane ana keroa ne mala ta'a ana tolana ka suia sa Moses, ka fata 'uri, ‘Sa ti ne alua 'oko gwaungai fuamaro, ma 'oe to ni wane kwaiketoi 'i safitamaro? ");
INSERT INTO far_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","'Oe doria 'oe saungi nau laugo, dia be 'oe saungia na wane be 'i Ijip 'i roki?’ ");
INSERT INTO far_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kada sa Moses nia rongoa ru nai, nia ka tafi fasia 'i Ijip, ma ka leka to na 'ana 'i Midia, ma nia ka arai na 'i senai, ma na 'afe nia ka fafuta ro welewane ki. ");
INSERT INTO far_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ma 'i burina ne sa Moses nia to na 'i senai sulia fai akwala fangali ki, na 'ainsel ka fatai fuana laona meamea ana ere ne meafia na 'ai tu'u ne uu karangia toloa 'i Saenae, 'i laona lofaa 'eke'eke ne nao si bobola fuana ta wane ka to ana. ");
INSERT INTO far_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Sa Moses ka kwele 'asiana ana ru ne nia ada to'ona, ma ka 'idu karangia kau na 'ai nai, fua sae nia ka ada lea to'ona. Boroi ma nia rongoa lalau lingena God ");
INSERT INTO far_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","ne 'uri, ‘Nau na God koko 'oe ki, God sa Abraham, sa Aesak, ma sa Jakob.’ Ma sa Moses ka lelebe, ma ka noni'ela ada na kau, sulia nia mau 'asiana. ");
INSERT INTO far_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ma God ka fata 'uri fuana, ‘'Oe lugea tae butu 'oe ki fasia 'aemu, sulia kula ne 'oe uu ana, nia na gano abu. ");
INSERT INTO far_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nau ku ada to'ona na famalagaigaie ta'a 'asiana ne kera sasi ana wane nau ki ne kera to 'i Ijip, ma nau ku rongoa lingena na angilae kera ki. Nia ne nau ku koso mai fuana nau ku lafuda fasia. 'Oe leka na kau 'i Ijip, sulia nau ku fili 'oe na.’ ");
INSERT INTO far_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Sa Moses na wane be wane Israel ki kera noni'ela ana, ma kera ka fata 'uri fuana, ‘Ti ne alua 'oe fua 'oko gwaungai fafi kalu, ma 'oe uu fuana keto lamalu?’ Nia be God ka kwatea mai fua sae ka gwaungai, ma ka lugeda fainia kwai'adomilae fasia na 'ainsel be nia fatai fuana ana 'ai tu'u be na ere 'e meafia. ");
INSERT INTO far_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ma sa Moses ka talaia wane Jiu ki fasia 'i Ijip, ma ka fulia fanadae ki ma ru ni kwelelae ana ki 'i Ijip, ma laona asi ne kera saea ana ‘Asi Meo,’ ma 'i laona lofaa 'eke'eke sulia fai akwala fangali ki. ");
INSERT INTO far_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Sa Moses laugo be nia fata 'uri fuana wane Israel ki, ‘God kai kwatea mai te profet siamulu, dia ne nia odu nau mai siamulu, ma nia ta wane ga 'ana, ana wane kamulu ki.’ ");
INSERT INTO far_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ma sa Moses ka to fainia wane Israel ana okue be laona lofaa 'eke'eke, nia ka to fainia koko kia ki, ma fainia na 'ainsel ne fata fainia 'i gwauna toloa be 'i Saenae. Ma nia ka ngalia na farongoe sulia maurie fasia God fua ka kwatea fuaka. ");
INSERT INTO far_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Boroi ma na koko kia ki, kera 'e noni'ela 'asiana ana rolae sulia sa Moses. Ma kera ka abulo 'ada fasia, ma kera doria 'asiana olilae 'uria 'i Ijip. ");
INSERT INTO far_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Kada sa Moses to 'ua gwauna toloa, kera ka fata 'uri fuana sa Eron, ‘'Oe saungainia mai tani nunuiru ne dia tani god fua malu, fua sae kera kai talai kalu. Sulia kalu ulafusia na te ne sasia ma sa Moses, na wane be talai kalu mai fasia 'i Ijip, ka dole mai gwauna toloa lo.’ ");
INSERT INTO far_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ma kera ka saungainia na nunuiru adalae to'ona dia na buluka fuana fosilana 'ada, ma na sungilana afafue ki fuana, ma kera ka sasia na fanga fuana fabaitalana ru ne kera saungainia 'ada talada. ");
INSERT INTO far_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Sulia ne kera sasi 'urinai, God ka abulo fasida, ma ka fasida fua kera ka fosia na 'ada na sato, na madame, ma na bubulu ki 'i langi, dia be na profet ki kera kedea ka 'uri, ‘Kamulu wane Israel ki, nao mulu si saungia lau ru mauri kamulu ki, ma na afafue ne mulu ka sasia sulia fai akwala fangali ne ki laona lofaa 'eke'eke, nao mulu si sasia lau fuaku. ");
INSERT INTO far_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na 'o'obe ne mulu ngalia fai kamulu, ru fuana nunuiru Molok. Mulu ngalia laugo fai kamulu nunuiru dia na bubulu ne kera saea ana Refan, keroa ne nunuiru kamulu saungaida ki fuana fosilada. Ma sulia ru nai ki, nau ku eresi kamulu kau fasia 'i Israel ka daofa liu 'uria fere 'i Babilon.’ ");
INSERT INTO far_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Na koko kia ki boroi, kera ngalia laugo na 'O'obe Abu God fai kera laona lofaa 'eke'eke. Kera saungainia na 'o'obe Abu ne sulia te ne God saea ma ka fatainia fuana sa Moses. ");
INSERT INTO far_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","'I burina, na koko kia ki kera ngalia na 'o'obe ne fasia na maa kera ki. Kada kera leka fainia sa Josua, kera ngalia kau na 'o'obe. Kada nai ne God taria wane ki fasia na gano kera, ma na wane Israel ki ka ngalia na fuada. Ma na 'o'obe nai ka to 'i senai, leka ka dao ana kada sa Deved nia kingi. ");
INSERT INTO far_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ma God ka eele fainia sa Deved, ma nia ka gania God ka alamatainia fua nia ka saungainia ta beu fuana God ne sa Jakob fosia. ");
INSERT INTO far_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Boroi ma sa Solomon lalau ne saungainia na beu fuana. ");
INSERT INTO far_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Boroi ma God ne 'initoa 'asiana, nao si to 'i laona 'o'obe ne wane ki kera saungaida. Dia na profet Aesaea be kedea fatalana God fuana wane Jiu ki ka 'uri, ");
INSERT INTO far_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Nau ne nau ku gwaungai mai 'i langi fafia ru ki tafau, ma na molagali ne na kula fuana alulana 'aeku ana. Nao mulu si bobola fuana ne mulu ka saungainia ta lume ne lea ka dia kula ne nau ku to ana. Ma nao mulu si bobola fuana ne mulu ka saungainia ta lume ne baita ka bobola fuana nau ku to 'i laona. ");
INSERT INTO far_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Sulia nau ne saungainia ru ne ki tafau 'i langi ma laona molagali.’” ");
INSERT INTO far_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ma sa Stefen ka fata lau ka 'uri, “Sui boroi 'ana mulu na wane Jiu ki, na maurilamulu ngasi ka dia lalau na wane ne nao si doria rolae sulia God, ma na maurilamulu ka rodoa. Nia ne kwatea ma nao mulu si doria rongolana ma kwairoilae ana fatalana God. Mulu dia na koko kamulu ki, sulia mulu sasi laugo 'uria aburongoe ana Anoeru Abu. ");
INSERT INTO far_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Na koko kamulu ki kera famalagaigaia profet ki tafau. Sulia 'i nao mai be kera saungia wane ne 'ainitaloa God ki, ne kera farongo ana lekalana mai na Christ, na wane 'o'olo. Ma ana kada nai, mulu ka kwate nia fuana malimae nia ki, ma mulu ka saungia ka mae. ");
INSERT INTO far_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Iu, ma kamulu be ngalia taki God ki be 'ainsel ki kera kwatea mai fua mulu, boroi ma nao mulu si ro go sulia taki nai ki!” ");
INSERT INTO far_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ma ana kada ne wane fanaonao ki laona okue ne kera rongoa sa Stefen, na manatalada ka ngengela 'asiana, ma kera ka 'ala girigiri ana lifoda, sulia kera guisasu 'asiana. ");
INSERT INTO far_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Na Anoeru Abu nia sura na ana sa Stefen, nia ada 'alaa 'uria 'i langi, ma ka ada to'ona God 'initoa ma ka nikila, ma ka ada to'ona laugo sa Jesus nia uu ana bali 'aba 'o'olo ana. ");
INSERT INTO far_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ma sa Stefen ka fata 'uri, “Ada basi! Nau ku ada to'ona fere 'i langi nia 'ifi, ma na Wele nia Wane ka uu 'i bali 'aba 'o'olo ana God!” ");
INSERT INTO far_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ma kada ne wane fanaonao ki kera rongoa ru ne, kera ka bokota na alingada, ma kera ka akwa koko, ma kera ka afururu na fafia. ");
INSERT INTO far_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ma kera ka suilofotainia 'uria 'i maa fasia 'i laona fere, ma kera ka safali 'uilana ana fau ki. Ma wane ne kera 'uia sa Stefen ana fau ki, kera ka lugea na maku gwala kera ki, ma kera ka aluda 'aena te wane fi baita ne satana sa Saul. ");
INSERT INTO far_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ma kada kera 'uia, sa Stefen foa ka 'uri, “Jesus, 'Aofia nau 'ae, 'oe ngalia na mangoku.” ");
INSERT INTO far_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ma nia ka boruru 'i ano, ma ka fata baita ka 'uri, “'Aofia, 'oe manatalugeda fua saungilaku!” Burina ne nia saea ru ne ki tafau, nia ka mae na. ");
INSERT INTO far_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Ma sa Saul ka alafafia maelana sa Stefen. Ma tani wane ne fitoe kera ki nikila, kera ngalia nonina sa Stefen, ma kera ka faitolilana, ma kera ka angi 'asiana 'uria. Ma ana fa dangi nai laugo, na wane famamana ki 'i Jerusalem kera safali kera ka ru na laona 'afitaie, sulia ne famalagaigaie nia baita 'asiana. Ma wane ki tafau ne kera famamana kera ka takalo tafau na 'uria fere ki laona lofaa 'i Jiudea ma 'i Samaria, boroi ma nao lau na lifurongo ki. ");
INSERT INTO far_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Sa Saul ka sasi ngangata 'asiana 'uria fafunuilana na wane famamana ki. Ma nia ka ru laona lume ki 'uria daulana sa tifaida ne kera famamana sa Jesus, wane ki ma na keni ki laugo, ma ka aluda laona beu ni kanie. ");
INSERT INTO far_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ma na wane ne kera famamana, kera ka takalo ana fere ki tafau. Ma kada kera liu kau, kera ka 'ainitaloa ana Farongoe Lea sulia sa Jesus. ");
INSERT INTO far_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Sa Filip ka leka 'uria te mae fere baita laona lofaa 'i Samaria, ma ka 'ainitalo ana sa Jesus, na wane famauri, fuana wane ki 'i senai. ");
INSERT INTO far_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kada wane senai ki kera rongoa na fatalana sa Filip, ma kera ka ada to'ona laugo fanadae ki ne nia fulida, kera ka fafurongo mamana ana ru ne sa Filip nia saea ki. ");
INSERT INTO far_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nia ifulangainia anoeru ta'a ki fasia wane 'oro ki, ma kera ka akwa, ana kada kera ru mai fasida. Ma na wane ne nonida mae, naoma 'aeda mae ki, nia ka gurada tafau. ");
INSERT INTO far_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ma na wane 'i Samaria ki, kera eele 'asiana. ");
INSERT INTO far_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ma laona fere nai, te wane ne to laugo ne satana sa Simon, ma tau na mai na wane 'i Samaria ki ka kwele 'asiana ana raoe ne nia sasia ana na lufina ngwai. Ma nia ka saea ne nia ta wane talingai 'asiana. ");
INSERT INTO far_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ma na wane ki tafau laona fere nai, na wane baita ki, ma kaela wele tu'u ki laugo, kera ka fafurongoa, ma kera ka saea nia na wane ne to ana nikilalae fasia God, ma kera ka saea ana “Nikilalae Baita.” ");
INSERT INTO far_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kera rosulia ka tau na mai, sulia nia sasia raoe nai ki ana lufina ngwai. ");
INSERT INTO far_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Boroi ma kada kera rongoa sa Filip nia fata sulia na Farongoe Lea sulia na 'Initoe God ma sa Jesus Christ, kera ka famamana, ma wane ma keni ki kera siuabu. ");
INSERT INTO far_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Sa Simon boroi ka famamana laugo, ma ka siuabu. 'I burina, nia ka leka na fainia sa Filip 'uria kula ne nia leka 'uria. Ma kada nia ada to'ona sa Filip fulia ru fanadae ki, ma na ru ni kwelelae ki, nia ka kwele 'asiana. ");
INSERT INTO far_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na lifurongo ki ne kera to 'i Jerusalem, ana kada nai kera rongoa wane 'i Samaria ki kera famamana laugo na fatalana God, go kera ka kwatea sa Pita fainia sa Jon ka leka siada. ");
INSERT INTO far_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kada kera dao, kera ka foa fuana wane ne famamana ki, fua kera ka too ana na Anoeru Abu. ");
INSERT INTO far_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kera tafau kera siuabu na kada kera famamana sa Jesus na 'Aofia, boroi ma na Anoeru Abu nao si koso 'ua fafia ta wane ada. ");
INSERT INTO far_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","'Urinai sa Pita ma sa Jon, kera ka alua 'abada fafida, ma kera fi too ana na Anoeru Abu. ");
INSERT INTO far_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ana kada nai, sa Simon ka ada to'ona ne lifurongo ki kera alua 'abada fafida, ma na Anoeru Abu ka leka mai fafida, nia ka ngalia malefo ka sasi 'uria kwatelana fuana sa Pita ma sa Jon, ");
INSERT INTO far_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","ka fata 'uri, “Kamoro kwatea laugo na nikilalae nena fuaku, fua dia nau ku alua boroi na 'abaku fafia ta wane, nia kai too laugo ana Anoeru Abu.” ");
INSERT INTO far_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Boroi ma sa Pita 'e olisia ka 'uri, “Nia bobola fuana malefo 'oe fai 'oe kamoro kai funu, sulia 'oe kwaisae ne na kwatea God na ru lalau fuana folilana ana malefo. ");
INSERT INTO far_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Nao 'oe si bobola go fuana raoe fai kalu, sulia na manatalamu nao si 'o'olo naona God. ");
INSERT INTO far_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","'Oe kari abulo fasia manatalae ta'a 'oe ki, ma 'oko fosia God fua nia kai manataluge 'oe fasia manatalae ta'a ne 'oe ki. ");
INSERT INTO far_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Sulia nau ku ada to'ona ne 'oe 'uga ka ta'a 'asiana, ma 'oko laeororo na farana ta'alae 'oe ki.” ");
INSERT INTO far_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Sui sa Simon ka fata 'uri fuana sa Pita ma sa Jon, “Kamoro fosia God ka 'adomi nau, fua ta ru ana ru ne kamoro saea ki si dao to'oku.” ");
INSERT INTO far_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ma 'i burina, sa Pita fainia sa Jon keroa fata sulia te ki ne kera saitamana sulia sa Jesus, ma kera ka fata sulia fatalana na 'Aofia. Sui keroa ka oli 'uria 'i Jerusalem. Ma ana olilae kera, kera ka 'ainitalo ana Farongoe Lea ana mae fere 'oro ki 'i Samaria. ");
INSERT INTO far_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ma te 'ainsel na 'Aofia ka fata fuana sa Filip ka 'uri, “'Oe sasi akau, 'oko leka toli suli taale ne safali 'i Jerusalem ka leka 'uria 'i Gasa sulia taale ne liu laona lofaa 'eke'eke.” ");
INSERT INTO far_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ma sa Filip ka sasi akau ma ka leka. Ma te wane 'initoa fasia 'i Etiopia 'e leka laugo mai sulia taale nai, ka oli 'uria fere nia. Na wane ne, nia ada sulia malefo na keni ne Kuini 'i Etiopia. Nia to mai 'i Jerusalem fuana fosilana God, sui nia ka oli na fere nia laona ru ni lekalae nia ne hos tara. Ma kada nia leka, nia ka idumia na buko sa Aesaea na profet nia kedea. ");
INSERT INTO far_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Go na Anoeru Abu ka fata 'uri fua sa Filip, “'Oe leka karangia na wane loko.” ");
INSERT INTO far_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ma sa Filip ka lae 'ali'ali kau siana, ma ka rongoa nia idumia na buko sa Aesaea na profet, ma nia ledia ka 'uri, “'Oe saitamana na ru nena 'oe idumia?” ");
INSERT INTO far_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ma na wane 'initoa nai ka olisia ka 'uri, “Nau saitamana 'uta ana, dia nao ta wane si famanata nau ana?” Ma nia ka saea mai sa Filip, fua ka ra kau siana ma ka gouru fainia. ");
INSERT INTO far_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Na Kekedee Abu ne nia idumia, nia 'uri, “Wane ki talaia fuana saungilana, ka dia ne wane ki talaia na sipsip fua saungilana, ma nao nia si saea go ta fatae, ma ka dia na kale sipsip ne nia to aroaro kada kera sufia ifuna. ");
INSERT INTO far_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ma kera ka 'onionga ana, ma kera ka ketoa ana sukee ki. Ma nia nao si too ana ta kwalafa, sulia kera saungia ka mae.” ");
INSERT INTO far_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Go na wane 'initoa ne ka fata 'uri fuana sa Filip, “Farongo nau basi mai, 'uri ma sa ti ne na profet ne fata sulia? Suli nia talana, naoma sulia ta wane 'e'ete lalau 'ana?” ");
INSERT INTO far_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ma sa Filip ka safali fata fuana sulia na Farongoe Lea sulia sa Jesus, nia safali ana Kekedee Abu nai. ");
INSERT INTO far_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Ma ana kada keroa leka sulia taale, keroa ka liu ana te kafo. Ma na wane 'initoa nai ka fata 'uri fuana sa Filip, “Na kafo go ne! Te ne susi nau fasia siuabue?” ");
INSERT INTO far_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Sui na wane 'initoa ne ka saea na hos nia ka uu ngado, ma sa Filip keroa ka koso laona kafo, ma sa Filip ka siuabu nia na. ");
INSERT INTO far_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ana kada keroa ra mai fasia laona kafo, na Anoeru God fi leka mai ka laua sa Filip. Sui boroi 'ana na wane 'initoa nai nao si ada to'ona lau sa Filip, nia 'e leka na 'ana fainia na eelea baita. ");
INSERT INTO far_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Boroi ma sa Filip tona ma nia lalau na 'i Asotus, ma ka liu daraninia mae fere nai ki fainia 'ainitaloa na Farongoe Lea ana fere nai ki, leka ka dao ana fere 'i Sesarea. ");
INSERT INTO far_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma ana kada nai laugo, sa Saul sasi ngangata na fainia fatae nia ki fuana saungilana fafurongo na 'Aofia ki. Ma nia ka leka siana na 'inita fataabu, ");
INSERT INTO far_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ma ka gania sae nia ka kedea ta fatae fuana wane fanaonao ki ana beu fuana folae ki 'i Damaskas, fua kera ka alamatainia fua nia nani 'uria na wane ne kera leka sulia “Taale na 'Aofia”, ma dia nia dao to'ona ta wane naoma ta keni 'urinai, nia kai dauda, ma kai oli mai faida 'uria 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ma ana kada nia leka 'uria 'i Damaskas, ma ka dao karangia na 'i fera, tona boroi na madakwalae fasia laona mamanga tala na fafi nia. ");
INSERT INTO far_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ma nia ka 'asia 'i ano, ma nia ka rongoa te linge fatae ne fata 'uri fuana, “Saul, Saul! 'Uta lau ne 'oe famalagaigai nau?” ");
INSERT INTO far_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sui sa Saul ka olisia ka 'uri, “'Aofia 'ae, 'oe sa ti ne?” Ma na linge fatae nai olisia ka 'uri, “Nau sa Jesus, na wane ne 'oe famalagaigaia. ");
INSERT INTO far_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","'Oe tatae, 'oko leka 'i fera, fua kera ka farongo 'oe ana te ne 'oe kai sasia.” ");
INSERT INTO far_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ma na wane ne kera leka fainia sa Saul ki, kera ka uu aroaro, ma kera nao si saea na ta fatae, kera rongoa na linge fatae nai, boroi ma nao kera si ada to'ona go ta wane. ");
INSERT INTO far_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sui sa Saul ka tatae mai, ma ka ili 'uria adalae, boroi ma nao nia si ada to'ona go ta ru. Ma kera ka dau ana 'abana, kera ka talaia 'uria 'i Damaskas. ");
INSERT INTO far_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ma sa Saul nao si ada to'ona ta ru, sulia maana rodo na sulia olu maedangi ki. Ma nao nia si 'ania laugo ta fanga, ma nao si kufia ta kafo. ");
INSERT INTO far_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ma na te fafurongo sa Jesus laugo ne satana sa Ananaeas, nia to laugo 'i Damaskas, ma nia ka ada to'ona na 'Aofia ana fataie. Ma na 'Aofia ka fata 'uri fuana, “Ananaeas 'ae!” Ma sa Ananaeas ka olisia ka 'uri, “'Aofia 'ae, nau ne.” ");
INSERT INTO far_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Na 'Aofia ka fata 'uri fuana, “'Oe sasi akau, 'oko leka 'uria na taale ne kera saea ana ‘Taale 'o'olo,’ ma 'oe leka 'uria lume sa Jiudas, 'oe ledia 'uria te wane fasia 'i Tasas ne satana sa Saul. Nia fo 'ana 'i senai, ");
INSERT INTO far_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ma nia ka suamu ana fataie ne 'oe ru mai siana, ma 'oe alua na 'abamu fafia, fuana ro maana ki ka ada lau.” ");
INSERT INTO far_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Sa Ananaeas olisia ka 'uri, “'Aofia 'ae, wane 'oro ki kera farongo nau sulia wane ne ma na ru ta'a 'oro nia sasia fuana wane 'oe ki 'i Jerusalem. ");
INSERT INTO far_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ma nia ka leka na mai 'i seki 'i Damaskas, fua nia kai daua sa tifaida ne kera fosi 'oe, sulia na fataabu baita ki ne kera alamatainia fuana.” ");
INSERT INTO far_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Boroi ma na 'Aofia olisia ka fata 'uri fuana, “'Oe leka 'amu, sulia nau ku filia na fua nia kai rao fuaku, ma kai 'ainitalo suli nau fuana wane ne nao lau Jiu ki, ma na kingi kera ki, ma fuana wane Israel ki laugo. ");
INSERT INTO far_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ma nau talaku ne nau kai fatainia fuana te ki ne nia kai nonifi ana kada nia kai 'ainitalo ani nau.” ");
INSERT INTO far_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","'Urinai sa Ananaeas ka leka, ka ru laona lume nai, ma ka alua 'abana fafona sa Saul, ma ka fata 'uri, “Wane kwaimani nau Saul 'ae, sa Jesus na 'Aofia talana ne odu nau mai. Nia be fatai fuamu sulia taale, ana kada be 'oe leka mai 'i seki. Nia ka odu nau mai, fua 'oe ada lau, ma na Anoeru Abu ka koso mai fafi 'oe.” ");
INSERT INTO far_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ma 'ali'ali go na ru dia na 'efona ie ki ka 'asia fasia na maana sa Saul, ma nia ka ada lau. Sui nia ka tatae, ma ka siuabu. ");
INSERT INTO far_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ma burina nia fanga ka suina, nonina fi nikila lau. Ma sa Saul ka to fainia na fafurongo ki 'i Damaskas sulia bara maedangi. ");
INSERT INTO far_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ma nia ka leka 'ali'ali 'uria beu fuana folae ki, ma ka safali ana fatae sulia sa Jesus ka 'uri, “Nia ne na Wele God.” ");
INSERT INTO far_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ma tifaida ne kera rongo nia, kera kwele 'asiana, ma kera ka ledi kwailiu safitada kera ka 'uri, “Na wane ne be to 'i Jerusalem, ma ka famalagaigaia wane ne kera fosia sa Jesus ki. Ma nia leka mai 'i seki, fua ka dauda, ma ka talaida siana fataabu baita ki.” ");
INSERT INTO far_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Na fatalana sa Saul ka nikila 'asiana. Ma sa Saul ka fatainia laona Kekedee Abu sulia sa Jesus ne nia na wane ne God filia. Ma ka 'urinai, wane Jiu ki ne kera to 'i Damaskas, kera ulafusia na olisilana ana ta ru. ");
INSERT INTO far_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ma 'i burina maedangi 'oro ki ka sui, wane Jiu ki kera ka oku fuana lokoerue fuana saungilana sa Saul. ");
INSERT INTO far_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sulia dangi ma na rodo, kera ka folo 'usia maana sakae ana fere nai fua kera ka saungia. Boroi ma sa Saul 'e rongoa na manatalae kera ki. ");
INSERT INTO far_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ma ana te fa rodo, na fafurongo nia ki kera ngalia, kera ka fakosoa laona kukudu baita 'uria 'i maa sulia mae kwakwa tofungana sulufau ne kera 'ui kalia na fere nai. ");
INSERT INTO far_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sui sa Saul ka leka 'i Jerusalem, ma ka sasi 'uria leka okulae fainia wane ne kera famamana sa Jesus ki. Ma kera nao si famamana ne nia ta fafurongo laugo ana sa Jesus, ma kera ka maungia. ");
INSERT INTO far_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Go sa Banabas leka mai, ka talaia siana lifurongo ki, ma ka farongo kera ana ne sa Saul nia ada to'ona na 'Aofia sulia taale, ma na 'Aofia ka fata laugo fuana. 'Urinai nia ka farongo kera laugo ana sa Saul ne nia fata nonira'a sulia sa Jesus 'i Damaskas. ");
INSERT INTO far_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ma kera fi famamana, ma sa Saul fi to na faida, ma ka liu laona 'afutana 'i Jerusalem, ma ka fata nonira'a sulia sa Jesus. ");
INSERT INTO far_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ma nia ka fata ma ka olisusu fainia wane Jiu ki ne kera fata ana fatae Grik, ma kera ka sasi 'uria saungilana. ");
INSERT INTO far_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ma kada na wane ne kera famamana ki kera rongoa ru nai, kera ka talaia sa Saul 'uria 'i Sesarea, ma kera ka kwatea 'uri fere nia 'i Tasas. ");
INSERT INTO far_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ma na wane famamana ki laona lofaa 'i Jiudea, ma 'i Galili, ma 'i Samaria ki, kera fi to na ana aroaroe ana kada nai. Ma na fikute wane famamana nai ka nikila, ma ka baita lau ana wane 'oro ne kera famamana. Nia 'urinai, sulia na Anoeru Abu kwai'adomi ada, ma kera ka fabaita na 'Aofia. ");
INSERT INTO far_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ma sa Pita ka leka ana mae fere 'oro ki, ma ana te kada nia ka leka 'i Lida fua nia ka maa to'ona na wane God ki ne kera to 'i laona mae fere nai. ");
INSERT INTO far_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ma 'i senai, nia ka dao to'ona te wane satana sa Aeneas ne nonina mae ma nao nia si tatae na fasia na 'ifitai nia sulia kwalu fangali ki. ");
INSERT INTO far_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ma sa Pita ka fata 'uri fuana, “Aeneas 'ae, sa Jesus Christ nia gura 'oe na ana kada ne. 'Oe tatae, ko lumia na 'ifitai 'oe.” Ma 'ali'ali go sa Aeneas ka tatae. ");
INSERT INTO far_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ma na wane ki tafau ne kera to 'i Lida ma 'i Saron, kera ada to'ona, ma kera ka famamana na 'Aofia. ");
INSERT INTO far_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ana fere 'i Jopa, te keni ne famamana, nia to laugo 'i senai, ne satana ni Tabita. (Ana fatae Grik nia ni Dokas.) Nia ka sasia ru 'oro lea 'asiana ki, ma ka kwai'adomi ana wane ne kera siofa ki laugo. ");
INSERT INTO far_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ma ana kada nai, nia matai, ma ka mae. Ma kera taufia nonina ka sui, kera ka 'afua, ma kera ka ngalia 'uria mae lume 'i langi, kera ka egwala 'i senai. ");
INSERT INTO far_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ma na fere 'i Jopa nao si tau go fasia 'i Lida, ma kada ne wane famamana ki kera rongoa sa Pita ne nia to 'i Lida, kera ka kwatea ro wane ki siana fainia na fatae 'uri, “'Oe leka 'ali'ali mai siamalu.” ");
INSERT INTO far_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","'Urinai sa Pita ka leka fai keroa. Ma kada nia dao, kera ka talaia 'uria mae lume nai 'i langi. Na gwa 'oru ki tafau go ne, kera oku siana sa Pita 'i senai, ma kera ka angi. Ma kera ka fatainia na maku 'oro ne keni nai nia taida ana kada nia mauri 'ua. ");
INSERT INTO far_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Sui sa Pita ka eresida tafau, kera ka ru 'i maa fasia mae lume nai, ma nia ka boruru, ka foa. Sui nia ka abulo fuana noni ru nai, ka fata 'uri fuana, “Tabita 'ae, 'oe tatae.” Ma na keni nai ka ada, ma kada nia ada kau, nia ka ada to'ona sa Pita, ma nia ka sulatatae ma ka gouru. ");
INSERT INTO far_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ma sa Pita ka dau ana na 'abana, ma ka 'adomi nia fua ka tatae uu. Sui nia ka akwa mai 'uria gwa 'oru be ki, fainia wane ne kera famamana ki, ma ka fatainia ni Dokas ne nia mauri na. ");
INSERT INTO far_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Na fatae sulia na ru ne ka talofia 'afutana fere 'i Jopa tafau, ma wane 'oro ki kera ka famamana ana na 'Aofia. ");
INSERT INTO far_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ma sa Pita ka to 'i Jopa sulia maedangi 'oro ki fainia na wane ne satana sa Simon, na wane ne raoe nia fuana saungailana ru ki ana 'ungana buluka ki. ");
INSERT INTO far_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Ma te wane 'i Sesarea ne satana sa Konelias, na wane fanaonao ana omee ki 'i Rom ne kera saea ana “Fikute wane 'i Itali.” ");
INSERT INTO far_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Nia fainia na wane laona lume nia ne kera nao lau Jiu ki, boroi ma kera fa'initoa God. Ma sa Konelias ka sasia laugo ru lea 'oro ki fuana 'adomilana wane Jiu ki ne kera siofa. ");
INSERT INTO far_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Aia, ana te fa dangi, bobola fainia oluna kada sato saulafi, nia 'e ada to'ona te fataie ne fatai madakwa ana na 'ainsel God nia leka mai, ma ka fata 'uri fuana, “Konelias 'ae!” ");
INSERT INTO far_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ma nia ka alua maana ana 'ainsel nai, ma ka mau, ma ka 'uri, “Wane baita nau 'ae, te ne 'oe doria?” Ma na 'ainsel nai ka olisia ka 'uri, “God nia eele 'asiana fai 'oe, ma ka alafafia folae 'oe ki fainia na raoe lea ne 'oe sasia fuana 'adomilana wane siofa ki, ma God kai kwaiara 'oe sulia ru nai ki. ");
INSERT INTO far_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ana kada ne na, 'oe kwatea tani wane leka 'uria 'i Jopa fua kera ka saea mai te wane ne satana sa Simon Pita. ");
INSERT INTO far_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nia to laona lume te wane saungai ru ana 'ungana buluka ki, satana sa Simon be na lume nia to sulia asi.” ");
INSERT INTO far_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na 'ainsel ne ka fata 'urinai fuana ka sui, nia ka leka na 'ana. Ma sa Konelias ka saea mai ro wane ki ana wane ne kera rao 'i laona lume nia, fainia te wane ni omee, ne fosia laugo God. ");
INSERT INTO far_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ma nia ka farongo kera ana na ru ne nia ada to'ona ma ka rongoa. Sui nia ka odu kera kau 'uria 'i Jopa. ");
INSERT INTO far_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ana maedangi 'i buri, kada wane nai ki kera leka 'ua kau, ma kera ka karangi dao na ana mae fere 'i Jopa, sa Pita ana kada nai laugo, nia ra fafona lume, fua ka foa 'ana 'i asoa. ");
INSERT INTO far_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ma nia ka fiolo, ma nia dori fanga. Ma ana kada kera sasi akau 'ua ana fanga ki, nia ka ada to'ona te fataie. ");
INSERT INTO far_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Nia ka ada to'ona 'i langi 'e 'ifi, ma ka ada to'ona ru dia 'aba maku reba ne kera fakosoa mai 'i ano ana fai susuui ru ki. ");
INSERT INTO far_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ma laona 'aba maku nai na ru ana fai 'ae ki, ru angoango ki, ma na no kwasi ki. Na ru nai ki, taki sa Moses luia nao ta wane si 'anida. ");
INSERT INTO far_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Sui nia ka rongoa te lingeru ne fata 'uri fuana, “Pita, tatae, saungida, ma 'oko 'anida.” ");
INSERT INTO far_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ma sa Pita olisia ka fata 'uri, “'Aofia 'ae, nao 'asiana, sulia nau nao si 'ania 'ua ta ru ne sua ma ka bilia.” ");
INSERT INTO far_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","'Urinai na lingeru nai ka fata lau 'uri fuana, “Nao 'oe si saea ta ru ne sua ma ka bilia ana te ne God 'e saea nia lea, ma ka falu fuana 'anilana.” ");
INSERT INTO far_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Olu kada ki ne ru nai nia fatai 'urinai ana ka sui, kera olitainia laugo 'ada na 'aba maku be fainia na ru ki tafau 'uria 'i langi. ");
INSERT INTO far_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ma sa Pita ka manata sulia fadalana fataie ne nia ada to'ona. Ma ana kada nai laugo ne wane be sa Konelias oduda mai ki, kera ledi 'uria lume sa Simon, ma kera ka dao na maana mae tafa. ");
INSERT INTO far_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ma kera ka ledi 'uri, “'Uri ma te wane satana sa Simon Pita nia to 'i seki?” ");
INSERT INTO far_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ma kada nai, sa Pita 'e manata ga 'ana 'ua sulia na fataie ne nia ada to'ona, sulia nia doria ka saitamana na fadalana. Ma na Anoeru Abu ka fata 'uri fuana, “Fafurongo basi, na olu wane ki kera dao 'i seki, ma kera ka nani 'uri 'oe. ");
INSERT INTO far_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Tatae, 'oko koso kau siada, ma nao 'oe si manata ruarua 'uria lekalae fai kera, sulia nau oduda mai.” ");
INSERT INTO far_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Sui sa Pita ka koso kau siada, ka fata 'uri, “Nau na wane be mulu nani na 'uria ne. 'Uri ma mulu leka 'uta mai ne?” ");
INSERT INTO far_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Kera olisia kera ka fata 'uri, “Sa Konelias na wane fanaonao ana omee ne odu kalu mai. Nia na wane lea, ma ka fosia laugo God. Ma na wane Jiu ki tafau kera ka fabaita 'asiana. Ma te 'ainsel God ka saea fua nia ka sae 'oe 'uria lume nia, ma nia doria ka rongoa te ne 'oe saea.” ");
INSERT INTO far_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ma sa Pita ka kwaloa wane nai ki 'i lume ne nia to ana, fua kera ka to basi fainia ana rodo nai. Sui 'ofodangi ana ruana maedangi, sa Pita ka sasi akau, ma ka leka faida ma tani wane lau 'i Jopa ne kera famamana. ");
INSERT INTO far_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ana fa dangi 'i buri, kera ka dao na 'i Sesarea, na kula be sa Konelias makwalia ana. Ma na wanefuta nia ki, ma na wane kwaimani nia ki ne nia laefida mai, kera makwalia sa Pita fai sa Konelias. ");
INSERT INTO far_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ma kada sa Pita ru go kau, sa Konelias ka dao to'ona, ma ka 'asia 'i maana 'aena sa Pita, ma ka fabaita. ");
INSERT INTO far_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Boroi ma sa Pita 'e taea ka fata 'uri, “'Oe tatae, sulia nau na wane dia 'oe laugo.” ");
INSERT INTO far_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ma sa Pita ka fata fainia sa Konelias, ma keroa ka ru na kau laona lume. Ma nia ka ada to'ona wane 'oro 'asiana kera oku. ");
INSERT INTO far_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ma nia ka fata 'uri fuada, “Kamulu saitamana lea ana tafau go ne na taki kalu Jiu ki, nia luia nao kalu si ru laona lume kamulu ki, ma nao kalu si 'ado fai kamulu wane ne nao lau Jiu ki. Boroi ma God fatainia fuaku nao nau si saea ta wane ana wane bilia ma ka sua. ");
INSERT INTO far_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Nia ne kwate ma nau ku leka mai kada ne 'oe sae nau, ma nao nau si leka mai fainia ta manata ruarualae. 'Urinai nau ledi kamulu, 'uta ne mulu ka laefi nau fua lekalae mai?” ");
INSERT INTO far_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Sa Konelias ka olisia ka 'uri, “Olu maedangi ki suina toli, nau ku foa 'aku laona lume nau ana oluna kada sato 'i saulafi dao 'urinai, tona ma te wane ofi ana maku ngwasinasina, nia uu na 'i naofaku, ");
INSERT INTO far_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","ma ka fata 'uri, ‘Konelias 'ae, God rongoa folae 'oe, ma ka ada to'ona na raoe lea 'oe ki ana 'adomilana na wane siofa ki. ");
INSERT INTO far_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","'Oe kwatea tani wane kera leka 'i Jopa fua kera ka saea mai te wane satana sa Simon Pita. Nia to fainia sa Simon, na wane be rao ana na 'ungana buluka ki, ma na lume nia to sulia asi.’ ");
INSERT INTO far_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nia ne, nau ku 'ali'ali ku laefi 'oe mai. Ma nia lea 'asiana ne 'oe leka mai. Iu, God to fai kulu tafau, ma kalu ka kwaimakwali fua rongolana ta te ne God doria 'oko saea.” ");
INSERT INTO far_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Sa Pita fata 'uri, “Nau ku saitamana lea ana ne God nia ada to'ona wane ki tafau ka bobola go, ma nao nia si efaefa go ana wane ki. ");
INSERT INTO far_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ma sa ti boroi 'ana ne nia fabaita God, ma ka sasia ru 'o'olo ki, nia ne na wane ne God kai kwaloa, sui boroi 'ana ta kwalafa te ne nia leka mai fasia. ");
INSERT INTO far_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nau ku saitamana kamulu rongo na sulia na Farongoe Lea fuana Jiu ki ne aroaroe fainia God sulia sa Jesus Christ na wane ne 'Aofia fuana wane ki tafau. ");
INSERT INTO far_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mulu ka saitamana laugo ne na ru baita ki be fuli 'i Israel, safali mai 'i Galili, burina be sa Jon famanata ka saea ne wane ki kera ka kari abulo fasia ta'alae kera ki ma kera ka siuabu. ");
INSERT INTO far_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ma mulu ka saitamana laugo ne sa Jesus na wane 'i Nasaret, ma mulu ka saitamana laugo ne God kwatea na Anoeru Abu ma na nikilalae fuana. Sa Jesus ka leka ana kula 'oro ki, ma ka sasia ru lea ki, ma ka gura wane ne kera to farana nikilalae sa Saetan. Sa Jesus sasia ru nai ki, sulia God to fainia. ");
INSERT INTO far_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Kalu ada to'ona na ru ne sa Jesus nia fulida ki 'i Israel ma 'i Jerusalem. Sui kera ka saungia ka mae ana foto'ilana ana 'airarafolo. ");
INSERT INTO far_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Boroi ma, God ka taea fasia maea ana oluna maedangi, ma ka fatainia fua malu. ");
INSERT INTO far_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Nao nia si fatai lau fuana wane ki tafau, boroi ma nia fatai ga 'ana fua malu na wane ne God fili kalu ka ada to'ona, ma kalu ka fata famamana sulida. Ma kalu ne fanga ma ka ku fainia 'i burina ne nia tatae fasia maea. ");
INSERT INTO far_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ma sa Jesus ka fata totongai fua malu, fua kalu ka fata famamana ma ka 'ainitalo ani nia, na wane ne God filia fua kai ketoa wane mauri ki fainia wane ne mae ki. ");
INSERT INTO far_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Ma na profet ki tafau ne kera fata sulia na Christ, ma ka saea na wane ne kera famamana nia, God kai manatalugea ta'alae kera ki, sulia ru ne na Christ nia sasia fuada.” ");
INSERT INTO far_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ma kada sa Pita nia fata ga 'ana 'ua, na Anoeru Abu ka koso fafia wane ne kera fafurongoa na fatalana. ");
INSERT INTO far_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ma na wane Jiu ne kera famamana sa Jesus, ma kera leka mai fasia 'i Jopa fai sa Pita, kera ka kwele 'asiana, sulia God nia kwate dangalu na ana na Anoeru Abu fafia wane ne nao lau Jiu ki. ");
INSERT INTO far_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Iu, kera rongoa wane ne nao lau Jiu ki, kera fata laugo ana fatae 'e'ete ki, ma kera ka fa'initoa God. Ma sa Pita ka fata 'uri, ");
INSERT INTO far_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Na wane ne ki, kera too laugo ana na Anoeru Abu dia kalu. Ma nao ta wane si bobola fuana ne ka luida fasia siuabue ana kafo.” ");
INSERT INTO far_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ma sa Pita ka saea kera ka siuabu, ana satana sa Jesus Christ. Sui kera gania fua nia ka to lau faida sulia ta bara maedangi. ");
INSERT INTO far_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Na lifurongo ki fainia wane ne kera famamana ki ne kera to 'i Jiudea, kera rongoa na wane ne nao lau Jiu ki kera famamana laugo fatalana God. ");
INSERT INTO far_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ma ana kada sa Pita nia dao 'i Jerusalem fasia 'i Sesarea, na wane Jiu ne kera famamana sa Jesus, kera ka ngatafia sa Pita, ");
INSERT INTO far_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","kera ka fata 'uri, “'Oe ru laona lume wane ne nao lau Jiu ki ne kera nao si 'ole 'unge, ma 'oko fanga ga 'amu faida!” ");
INSERT INTO far_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ma sa Pita ka fata fuada sulia ru ne fuli ki tafau ka 'uri, ");
INSERT INTO far_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ana kada nau ku to ana fere 'i Jopa, nau ku foa, ma nau ku ada to'ona te fataie. Nau ku ada to'ona ru dia 'aba maku reba ne kera fakosoa mai fasia 'i langi, dia tani wane kera dau ana fai susuui nia ki, ma nia ka koso mai siaku. ");
INSERT INTO far_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ma nau ku ada laona, ma nau ku ada to'ona ru ana fai 'ae ki, ru angoango ki, ma na no kwasi ki. ");
INSERT INTO far_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","'Urinai, nau ku rongoa na lingeru 'uri, ‘Pita tatae, 'oe saungida, ma 'oko 'anida!’ ");
INSERT INTO far_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Boroi ma nau ku fata 'uri, ‘'Aofia 'ae, nao, sulia nau nao si 'ania 'ua ta ru ne sua ma ka bilia, na ru ne taki sa Moses luia nao ta wane si 'anida.’ ");
INSERT INTO far_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Sui na lingeru ne fasia langi ka fata lau 'uri, ‘Nao 'oe si saea ta ru nia sua ma ka bilia ana ru ne God saea nia falu na.’ ");
INSERT INTO far_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Na ru nai ka 'urinai 'ana olu kada sui, kera ka olitainia laugo 'ada 'i langi. ");
INSERT INTO far_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ana kada nai, na olu wane ki ne te wane 'e oduda mai siaku fasia 'i Sesarea, kera dao na 'i maana lume ne nau ku to ana. ");
INSERT INTO far_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ma na Anoeru Abu ka saea fuaku, fua nau ku leka faida, ma nao nau si manata ruarua sulia ne kera nao lau wane Jiu ki. Ma na ono wane ne kera famamana ma kera to 'i Jopa, kera ka leka laugo fai nau 'uria 'i Sesarea, ma kalu ka ru laona lume sa Konelias. ");
INSERT INTO far_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ma nia ka farongo kalu ne nia ada to'ona na 'ainsel 'e uu laona lume nia ma ka saea fuana, ‘'Oe odua tani wane 'uria 'i Jopa fua ka saea mai wane ne satana sa Simon Pita. ");
INSERT INTO far_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nia kai saea na fatae ki fuamu, fua 'oe fainia na kwalafa 'oe mulu ka mauri firi.’ ");
INSERT INTO far_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Ana kada nau ku safali fata go fuada, na Anoeru Abu ka koso na mai fafida, dia laugo be nia koso mai fafi kulu ana maedangi ana Pentekos. ");
INSERT INTO far_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ma nau ku manata to'ona ru be na 'Aofia nia saea be 'uri, ‘Sa Jon nia siuabua wane ki go ana na kafo, boroi ma God kai siuabu kamulu ana na Anoeru Abu.’ ");
INSERT INTO far_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","God ka kwatea laugo na Anoeru Abu fua wane ne nao lau Jiu ki, dia laugo ne nia kwatea fuaka, ana kada be kulu famamana 'Aofia sa Jesus Christ. 'Urinai ne nao nau si bobola fuana ne nau luia God, kada nia alafafia na wane ne ki!” ");
INSERT INTO far_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ma ana kada kera rongoa na ru nai, na 'ugalae kera ki ka suina, ma kera ka tangoa God, kera ka 'uri, “God alamatainia na wane ne nao lau Jiu ki laugo, fua kera kai kari abulo fasia ta'alae kera ki, ma kera ka mauri firi!” ");
INSERT INTO far_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ma sulia na famalagaigaie ana kada be kera saungia sa Stefen nia baita 'asiana, nia ne kwate ma wane ne kera famamana ki kera ka takalo. Ma tani ai ada kera leka 'uria lofaa 'i Fonisia, ma 'uria bubunga 'i Saeprus, ma fere baita 'i Antiok, ma kera ka 'ainitalo ana Farongoe Lea fuana wane Jiu ki go taifili 'ada. ");
INSERT INTO far_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ma tani wane ne kera famamana ne kera leka mai fasia bubunga 'i Saeprus, ma te fere baita 'i Saerin, kera leka laugo 'uria 'i Antiok, ma kera ka 'ainitalo laugo ana Farongoe Lea sulia na 'Aofia sa Jesus fuana wane ne nao lau Jiu ki. ");
INSERT INTO far_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ma na nikilalae God ka to fainia wane ne kera famamana ki, ma na wane 'oro ki, kera ka famamana, ma kera ka abulo 'uria na 'Aofia. ");
INSERT INTO far_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Na farongoe sulia na ru nai ki ka talofia na fikute wane famamana 'i Jerusalem ma na wane fanaonao kera ki, ma kera ka kwatea sa Banabas 'uria 'i Antiok. ");
INSERT INTO far_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ma ana kada nia dao, nia ka ada saitamana ne God falea wane senai ki, ma nia ka eele 'asiana, ma ka fata fangadoda tafau fua kera ka uu ngasi ana famamanae kera ki ana 'Aofia. ");
INSERT INTO far_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Sa Banabas nia wane lea, ma na famamanae nia ka nikila, ma na Anoeru Abu ka sura ana. Ma sulia sa Banabas, wane 'oro ki kera ka safali famamana na 'Aofia. ");
INSERT INTO far_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","'Urinai sa Banabas ka leka 'uria 'i Tasas, ka nani 'uria sa Saul. ");
INSERT INTO far_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ma kada nia dao to'ona, nia ka talaia, keroa ka leka 'uria 'i Antiok. Ma keroa ka to senai sulia te fangali. Ma keroa ka oku fainia wane 'oro ne kera famamana senai ki, ma keroa ka famanata kera. Ma 'i Antiok ne wane ki kera safalia saelana na wane