﻿USE sofia;
DROP TABLE IF EXISTS sofia.fad_vpl;
CREATE TABLE fad_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES fad_vpl WRITE;
INSERT INTO fad_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O danah naŕi Tiofilus, danah kuŕum la os ag tatam keŕ keŕ ig gamnigwa beko atan qeri né ene yeg. ");
INSERT INTO fad_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ag né qe danahas ig mariweg duet qe sillah ole yeg. Danahas qe digumakwa Yesus keŕ keŕ sew amlagwa peg qe, dimba ag Tiwurdi Néri kuak danah beg. ");
INSERT INTO fad_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Da Luk da né qe digumakwa arereg ban qe peko kepaŕko kouturin. Qeri da ole né ene keŕ keŕ kunum ban qe dimlamurko yarildi kena elle qe yin. ");
INSERT INTO fad_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Danah naŕi Tiofilus, na né ismireg qe, né meŕe qe doka ot mourdig. ");
INSERT INTO fad_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sén qewa Herod nug king delle Yudia gumewew, pris os wénih Sakaraia daré. Nug pris ameg Abiya qewari, am nug waw Elisabet ole a olele pris Aron fuŕuh. ");
INSERT INTO fad_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","A olele Naŕinahri Ŕo am Né ole kunum dimlamurdap, qeri ge Tiwur a danahas mangunah qere piatan. ");
INSERT INTO fad_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Gam a keinmanah am a nir kawa, keŕdi Elisabet nug owa nir kawa. ");
INSERT INTO fad_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Sén os pris ameg Sakaraia nug daré ole qe asilag sén kekuakri dewew ge, deŕ os pris Sakaraia nug Tiwur nohwa kekuan. ");
INSERT INTO fad_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pris ag koulagwa wenlag ker masawa yeksi touŕweg ge, Sakaraia wénih ban. Wénih bew ge, nug kepŕurweg Tiwur Lougwa noko ker ahu os kew kas muŕdig kena ole Tiwurdi mandigri nuan. ");
INSERT INTO fad_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ker ahu os kew kas muŕdig kena be ole qe nug manewew ge, danahas kunum dimdim qagleksi unuqoreg. ");
INSERT INTO fad_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sén qewa Tiwurdi doup Sakaraia gumurko doko, qaŕéw ker ahu os muŕdig kena ole aŕelle dian qe séku kenariwa sirko dian. ");
INSERT INTO fad_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Dewew ge, Sakaraia aminko doup qe peko ge, nug wawtuŕko ole faŕan. ");
INSERT INTO fad_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gam Tiwurdi doup amegwa anan. “Sakaraia, na aw faŕwen. Tiwur unuqorak nasip duan. Na wat Elisabet nug nir danah memanko mirdig, am na nir qe wénih Yon kataŕ. ");
INSERT INTO fad_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Geisah nug dow, na ot gamag naŕi asdig. Am nug durig qeri danahas la kuŕum ole olag gamag asdig. ");
INSERT INTO fad_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Keŕdi nug Tiwur nohwa danah wénih ole darig. Nug wain am le gagrag la qe ole ospi lew, am nug anig owa niewew, sén qewa ole Koulli Gun nug ole wittew dessa omaldig. ");
INSERT INTO fad_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Nug anuqko Israel danahas kuŕum omlarew ag olag buliew asilag Naŕinah Tiwur gumdeksi dolag. ");
INSERT INTO fad_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Profet Elaisa gagragsak morew kekuan qe sillah Yon Naŕinah noh oko anuqko attig. Atewew ge, nug sew nir memelgar ole ag olag usih nirig. Am nug danahas Tiwur nohwa tapewnak sési qe omlarew olag buliew Tiwur o nie sillah diakri dahmelag. Qewa ge, nug sew Naŕinah uŕirigri qeri danahas olag bawressi dalag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakaraia Tiwurdi doup koŕmoran, “Da qe areg ol meŕe mérig? Keŕdi da wal ole i keinmanah am i nir ole makri sén eŕtan.” ");
INSERT INTO fad_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tiwurdi doup nug koŕewa oko anan, “Da doup Gebrel. Da Tiwur nohwa deina ole. Nug da meŕilew nasip né kena ene oko na amenwa andildi uŕiyém. ");
INSERT INTO fad_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Na doka koutor. Gei ole na né kaŕdew né ospi mariwen, keŕdi na dasil né ot meŕe pi mé. Na dawe atew nir nasip dow am bulika né maririp. Da keŕ aném qe sén nusig morakwa bérig.” ");
INSERT INTO fad_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sén qewa danahas Sakaraia dimdim bérigri ameg méksi dessi dahmak kuŕum og. “Aregri Tiwur Lougwa gun awen owa wagamnah de?” ");
INSERT INTO fad_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sén nug dimdim ban ge, nug né mariakri olele kawa. Ag nug Tiwur Lougwa kowol os pian ge, nug ewegwa ih sew peksi olag mouran, keŕdi nug né kaŕdan. ");
INSERT INTO fad_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nug pris kuakri sén nusig qe malako ge, buliko lougwa atan. ");
INSERT INTO fad_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Qe dimba ge, waw Elisabet o ole meko, nug kalam tanig ole qe louw ih daré. ");
INSERT INTO fad_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Elisabet anan, “Naŕinah dasil o niew, nug sew da nir ole mein. Géri danahas nolagwa uŕa nak dorém ge, nug sew kawa man.” ");
INSERT INTO fad_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kalam 6 qere Elisabet nirdi weiewew, Tiwur doup nusig wénih Gebrel qe meŕorew taun nagur wénih Nasaret qewa atan. Taun qe Galili atu owa de. ");
INSERT INTO fad_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Tiwurdi doup nug Tiwurdi né oko as magun os danah ole ospi weiyes ole qe dowa atan. Nug danah os wénih Yosep king Dewit fuŕuhwari qeri fég oŕweg. As magun qe wénih Maria. ");
INSERT INTO fad_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tiwurdi doup nug gumurko atko amegwa anan, “Maria, na kena te dana? Tiwur nasip o naŕi nie. Tiwur na ole dasa.” ");
INSERT INTO fad_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria doupri né qe doko wawtuŕko katat qew ge dahman, “Keŕ digurinah né ene ané.” ");
INSERT INTO fad_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Gam Tiwurdi doup anan, “Maria, na aw faŕwen. Tiwur nasip o nie. ");
INSERT INTO fad_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Geisah na ot ole meka nir danah os memanka am nug wénih Yesus kataŕ. ");
INSERT INTO fad_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tiwur sew nug binag naŕi ole bérig am nug wénih Tiwur Karannah Bega éksi anlag. Naŕinah Tiwur sew nug king beko alag dugiah Dewit king daré sillah darig. ");
INSERT INTO fad_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nug Yakop fuŕuh gumarelle king sansan darig. Kingdom nusig ge ospi kawa mew,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria Tiwurdi doup amegwa anan, “Da danah ole ospi weiyeŕ gam, aregnah kowol qere dagnéwa bérig?” ");
INSERT INTO fad_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tiwurdi doup koŕewa oko anan, “Koulli Gun neko na tonirew gagragsak Tiwur Karannahri na qanŕirdig. Qeri nir gunnah na memandip qe wénih Tiwur Bega éksi anlag. ");
INSERT INTO fad_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na doka koutor. Na liap Elisabet ole nug keinmanah, nug owa nir kawa éksi andéw, gam gei nug kalam 6 qere nirdi weiye, géri nug nir ole darig. ");
INSERT INTO fad_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Keŕdi Tiwur nug keŕ os sakri ane ge, qe mou bérig.” ");
INSERT INTO fad_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria Tiwurdi doup koŕewa oko anan, “Da Naŕinahri kuak as, na né anam qe sillah bar.” Qere anew ge, Tiwurdi doup nug munurko atan. ");
INSERT INTO fad_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Qe dimba wagam ole kawa, Maria bawarko usihri teko Yudia atu owa taun os qoukuwa, Sakaraia Elisabet ole des qewa atan. ");
INSERT INTO fad_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Atko Sakaraia lougwa wanew Elisabet peko sumdew ge, Maria ole Elisabet sumdan. ");
INSERT INTO fad_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Sumdewew ge, nir Elisabet owa nian qe ole kawqan. Koulli Gun Elisabet wittew dessa dahmak moran. ");
INSERT INTO fad_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elisabet qalko Mariari anan, “Tiwur na as la kunum eŕarak wittak kena miran, am Tiwur nir na otwa nie qe wittak kena moran. ");
INSERT INTO fad_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Da ol gamagnah ase, keŕdi Naŕinah dasil anig peiŕdigri uŕiyé. ");
INSERT INTO fad_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Na sumŕam qe dueppi ole nir da olwa ene gamag asew kawqé. ");
INSERT INTO fad_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Tiwur na wittak miran, keŕdi na nug anan qe beko mou murdigri ot meŕe man,” eko Elisabet Maria anoran. ");
INSERT INTO fad_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria anan, “Da ol dahmak ole kunum Naŕinah morko binag meina. ");
INSERT INTO fad_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Da Tiwurdi ol gamag naŕi ase, keŕdi nug da hipunin dasil noh uwindi seko buliko wiŕan. ");
INSERT INTO fad_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Da Tiwurdi kekuak as sam, gam nug da dahmiŕko koutoran. Qeri gei digumak am dimba dimba ole danahas anlag, ‘Tiwur as qe wittak kena moran,’ éksi anlag. ");
INSERT INTO fad_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Keŕdi Tiwur Gagragsak Digu, nug dagrowa kowol danah sakri kawa qe sew ban. Nug wénih gunnah. ");
INSERT INTO fad_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nug sew danahas nug faŕursi ole qe ag alalgar dugialgar ole ag nusig o duak owa dalag. ");
INSERT INTO fad_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nusig gagragsakwa kowol danah sakri kawa qe san. Nug sew danah ag agégé binlag meg qe kum qétieg. ");
INSERT INTO fad_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nug king binlagri seréw qe dilag gagragsak sew kawa meweg, am danah binlag kawa sam daréw qe sew ag nug nohwa naŕi beg. ");
INSERT INTO fad_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nug danahas ke kawa qe ke kena nusigwa begaran am sew danahas kehlag ole qe ewlag sam qere ateg. ");
INSERT INTO fad_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nug kuak nir nusgur Israel danahas kehnaran. Keŕdi nug Abraham am algur dugiahur ole o duak nusig owa sansan diakri né fagqan qe dahmorko, ig alangar dugiangar agop ole qere sérig,” eko Maria Tiwur binag man. ");
INSERT INTO fad_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria nug Elisabet ole kalam kiam sillah dessa, am buliko kawagwa Nasaret atan. ");
INSERT INTO fad_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetri nir memnak sén dow ge, nug nir danah memnan. ");
INSERT INTO fad_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nug gému ole asilaswari am leilti ag Elisabet nug Naŕinahri o duak naŕi owa dian qe dueksi, uŕiweg nug ole aŕié olag gamag asan. ");
INSERT INTO fad_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Deŕ 8wa ge nir féŕu gone kotŕakri sén dew, ag uŕiyeg. Ag memeg Sakaraia wélqorlagri seg. ");
INSERT INTO fad_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Gam nir anig anaran, “Kawa, nir wénih Yon kataŕnig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Anew ge, ag Elisabet anoreg, “Asilag atérwari ounté os wénih qere ole kawa.” ");
INSERT INTO fad_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Am ag Sakaraia nir wénih oun kataŕdig qe dolagri ewlagwa nug perigri kowol seg. ");
INSERT INTO fad_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Seweg ge, nug keke os morweg yarigri ewegwa ih sew uksi morweg ge, “Nug wénih Yon,” yew peksi dorlag nan. ");
INSERT INTO fad_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Sén qewa ih Sakaraia nug koŕe koptew digumeko né mariyelle Tiwur binag suman. ");
INSERT INTO fad_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Danahas aŕié daréw ole qe né qe kunum duessi wawtuŕeg. Yudia atu kunum qoukuwari danahas ag ole kowol qe neihwah marieg. ");
INSERT INTO fad_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Danahas kowol qeri né duessi olag meweg te meweg new ge aneg, “Nir ene keŕ danahnah bérig?” éksi aneg. Keŕdi Naŕinah eweg Yon dowa dian. ");
INSERT INTO fad_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Koulli Gun Yon memeg Sakaraia wittew des, géri nug Tiwurdi né qe oko marian. ");
INSERT INTO fad_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Naŕinah Israel isanig Tiwur binag ménig. Nug danahas nusgur kehnardigri uŕiko kegeŕ asilgar ewlagwari buliko diaran. ");
INSERT INTO fad_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Tiwur kéhnigak danah os gagragsak naŕi ole ignéwa mew uŕiyan. Nug Naŕinahri kuak danah king Dewit fuŕuh. ");
INSERT INTO fad_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Algu Tiwur sew profet gun ag nusig né qe uksi marieg. ");
INSERT INTO fad_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nug danah qe gagragsak naŕi ole ig kéhnigrigri mew uŕirig. Nug isanig kegeŕ am danahas are ag ig nouni dahmigsi ole qe ewlagwari buliko wigrig. ");
INSERT INTO fad_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Tiwurdi o duak ig alangar dugiangar ole deg am nug titwanak gun qe doug ospi katian. ");
INSERT INTO fad_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tiwur nug alnig dugianig Abraham dowa né qe fagqan. ");
INSERT INTO fad_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","Nug ig kegeŕ isangar ewlagwari wigrigri né fagqan. Qeri ig pi faŕhut, nug nohwa onig kunum morettu sansan mangu weiyettu gun dettu nug binag ménig. ");
INSERT INTO fad_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Am nir dasil Yon, na geisah Tiwur sew na Tiwur Karannahri profet éksi aniŕlag. Keŕdi na Naŕinah noh oka anuqka atenna ih nusig oŕdip. ");
INSERT INTO fad_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Na danahas nusgur anardip: Naŕinah hipunin asilag kusuqko buliko diardig. ");
INSERT INTO fad_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Keŕdi Tiwur isanig o duak naŕi nie, qewa ge kem be sillah Naŕinah kéhnigrigri saw kappari uŕirig. ");
INSERT INTO fad_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Danahas gattuwa dasi am mousakri faŕakwa dasi qe agop sonŕelle nug ih ismigew Tiwurdi maror ihwa atnig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nir qe dahmak am o mourak kena ole kena man. Nug atu meiŕak danah kawawa daré, gam dimba Israel danahas gumarko wanan. ");
INSERT INTO fad_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sén qewa Ogastus nug Rom atu qe kunum dilag king delle, nug ŕo os man: Danahas kunum atu qewa daréw ag wenlag yalagri ŕo qe man. ");
INSERT INTO fad_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kurinius nug Siriari kuri danah naŕi delle ge, wenlag yakri ŕo qe diguman. ");
INSERT INTO fad_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Am danahas kunum ag kawlag awen awen wenlag yalagri aseksi ateg. ");
INSERT INTO fad_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Géri Yosep nug ole Galili owa taun Nasaret qewari am Dewitri taun Betlehem Yudia atu qewa atan. Keŕdi nug Dewit fuŕuh. ");
INSERT INTO fad_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nug Maria ole aŕié wenlas yalasri ates. Maria nug Yosep uŕigri fég oŕwak dewew am Maria nir uŕigri sén unaka dewew ole ates. ");
INSERT INTO fad_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","A Betlehem qewa dessa ge, Mariari nir memnak sén duan. ");
INSERT INTO fad_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Sén qewa nug nir danah memnan. Nug ge nir anqakri. Maria nir qe lamen naŕiwa saputko ge, doŕ dilag kelak awen qewa awen bawarko mew nian. Keŕdi ŕo danah niakri lo qe ambew ag awen ole kawa. ");
INSERT INTO fad_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sipsip gumarak danah ag Betlehem kaw qe mourak awen gisgaŕ olewa sipsip asilgar gumareksi tuqan qewa deg. ");
INSERT INTO fad_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tiwurdi doup nug ag gumarko gamlagwa now ge, Naŕinahri kamsahlak sonaŕko talilaran. Talilarew, olag naŕinah faŕan. ");
INSERT INTO fad_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Am Tiwurdi doup nug ag anaran, “Ag aw faŕweg. Da asilag né kenanah os oko uŕiyém. Né qe sew danahas kunum olag gamag naŕi asdig. ");
INSERT INTO fad_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gei deŕ ewa Dewitri taunwa as os nir danah memanko maré. Nir qe hipunin noh asilag owegri seko buliko diarak danah am nug Naŕinah Kristus. ");
INSERT INTO fad_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ag nir qe peksi olag mourdigri ge kowol os ere pelag: Nir anig nug lamenwa saputko doŕ dilag kelak awenwa mew niewew pelag,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tiwurdi doup nug né qe mariko malwew ge, usihri saw karan Tiwurdi doup ameg naŕi doweg qagleksi Tiwur binag sumessi kasi iŕeg. ");
INSERT INTO fad_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Tiwur karannah nug kamsahlak gun olewa de. Am danahas wanwa Tiwur asilag o nie ole qe ag maror nusig owa dasi.” ");
INSERT INTO fad_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sén Tiwurdi doup ag minareksi saw karan atweg ge, sipsip gumarak danah qe ag agégé né marieg. “Ig Betlehem atektu Naŕinah anigé ole am keŕ bé qe penig.” ");
INSERT INTO fad_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Géri usihri atessi ge, Maria Yosep ole am nir yu qe doŕ dilag kelak awenwa niewew mariareksi piareg. ");
INSERT INTO fad_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ag nir qe peksi ge, nir qeri né dueg ole qe danah la os taun qewari ole amlagwa aneg. ");
INSERT INTO fad_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Danahas ag né qe dueksi dahmak lanah qere og. ");
INSERT INTO fad_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Gam Maria keke kunum béksi ateg qe owa ih dewew dahmak naŕi oré. ");
INSERT INTO fad_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Am sipsip gumarak danah olag gamag asewew Tiwur binag karan sumessi am binag messi bulieksi ateg. Keŕdi ag keke kunum Tiwurdi doup anan qe sillah amlagwa peg am doulagwa dueg. ");
INSERT INTO fad_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Deŕ 8wa Yosep Maria ole nir yu féŕu gone kotŕak sén dow ge, wénih Yesus katŕes. Nug anig o ole pi mak Tiwurdi doup wénih qe moran. ");
INSERT INTO fad_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Sén a Mosesri Ŕo yakwa gun kowol qe dimlamdeksa malweksa ge, a nir oksa Yerusalem Tiwur Lougwa Tiwur ewegwa melasri ates. ");
INSERT INTO fad_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Naŕinahri Ŕo yakwa de ge, “Nir memeg anig ole nir danah anqakri memanlas qe Tiwur ewegwa melas.” ");
INSERT INTO fad_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Am Maria ofa oko Tiwur murdigri qe ole ses. Keŕdi Tiwurdi Ŕo yakwa ane, “Kuhŕil naŕi aŕit kawa ge, kuhŕil nounu masiksik fou kena mak aŕit os pris mores.” ");
INSERT INTO fad_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Sén qewa, danah os wénih Simion Yerusalem qewa daré. Nug Tiwur nohwa mangu weiré am Tiwurwa ih daré. Nug Tiwur Israel kug asilagwari buliko diardigri qe ameg meré. Koulli Gun nug ole darap. ");
INSERT INTO fad_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Koulli Gun sew nug duan ge, nug Naŕinah dowari Kristus uŕiyew peko tatam am mousdig. ");
INSERT INTO fad_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Koulli Gun sew nug Tiwur Lougwa teko qewa dewew, Yosep waw ole Ŕo yakwa ane qe dimlamdeksa nir asilas Yesus oksa qewa tes. ");
INSERT INTO fad_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion nir qe oko momowa oŕako Tiwur binag sumko anan. ");
INSERT INTO fad_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O Naŕinah, na atu kunum gumna ole, na né fagqen ge, na sewe nasip kuak danah da ol marorwa mousko attil. ");
INSERT INTO fad_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Keŕdi da amelwa danahas buliko diardigri danah uŕiyan qe piém. ");
INSERT INTO fad_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Na nug kepŕurka bawrurka mewe uŕiyan. Qeri danahas kuŕum atu kunumba nug pelag. ");
INSERT INTO fad_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nug Yuda danahas kawa la qe am danahas naspar Israel dilag ole Tiwurdi kamsahlak gun ole oko uŕirig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nir memeg anig ole Simion nirdi anan qeri dorlas nan. ");
INSERT INTO fad_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion wittak marko am nir anig Mariari anan. “Nir ene Israel danahas kuŕum sew tolalag am gagrag dalagri ole am nug Tiwurdi ih ismardigri toqoran. Gam danahas kuŕum nug dimorlag. ");
INSERT INTO fad_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Qeri danahas kunum dilag dahmak olagwa nie qe ambo mérig am na otwa qoum yako qetko attig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Am as profet os wénih Anna. Nug Fanuel aŕeg am Aser ateŕ qewari. Nug keinmanah am nug gému ole nug oksa makaŕ 7 qer dessa, gému mousan. ");
INSERT INTO fad_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Géri nug qehŕas dew uŕiyew makaŕ 84 qer ban. Nug sansan tuqan kémun ole Tiwur Lougwa noko Tiwur binag mérigri kurdelle am unuqordé. ");
INSERT INTO fad_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sén qewa ih nug Yosep Maria ole am nir asilas ole gumarko doko nir qeri Tiwur kena sam eko anan. Anelle ge, nir qe Yerusalem danahas kug owari buliko diardigri ameg meg qe anaran. ");
INSERT INTO fad_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yosep waw Maria ole Tiwurdi Ŕo yak de qe dimlamdeksa kuak kunum malweksa ge, a kawlas diguwa Nasaret, Galili atu qewa bulieksa ates. ");
INSERT INTO fad_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nir asilas qe gagragsak ole kena man. Nug dahmak kena ole ban am Tiwur wittak kena mordé. ");
INSERT INTO fad_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Makaŕ dorog Yesus anig memeg ole a Yerusalem Nanŕurak Deŕdi mallenwa attap. ");
INSERT INTO fad_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sén nug makaŕ 12 qer dewew ge, ag koulag qe dimlamdeksi Yerusalem mallenwa ateg. ");
INSERT INTO fad_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Sén mallen qe kawa mew, nug anig memeg ole bulieksa kawlagwa ateppes ge, nalas Yesus nug Yerusalem qewa dian, gam a qe pi dues. ");
INSERT INTO fad_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A danahas ole aŕié atsi essa deŕ usih ge ates. Deŕ oswa ge a digumeksa Yesus mariessa asilaswari am leilti koŕmares. ");
INSERT INTO fad_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sén nug ospi peksa, a nug marilasri bulieksa Yerusalem ates. ");
INSERT INTO fad_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Deŕ kiam qewa, a nug Tiwur Lougri kaŕ owa Tiwurdi Néri duak marak danah qe olagwa dewew pes. Nug ag né marieg qe doko ge koŕmaran. ");
INSERT INTO fad_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ag kunum ole nusig duak marian qe am koŕmak buliko noh man qe ole dueksi dorlag nan. ");
INSERT INTO fad_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Sén anig memeg ole nug peksa ge, a ole katat aqatan. Anig anoran, “Nir dasil, na keŕdi i qere sitam? Na memen am da ole i dahmak naŕi nasip ollu mariyirah,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Nug a koŕmatan, “A keŕdi da mariyiŕsa? A pi te dosa da Mem Lougwa deina?” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Gam nug né anatan ge, a olas ospi mouran. ");
INSERT INTO fad_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Yesus nug a dimlamatew bulieksi Nasaret ateg. Nug anig memeg ole koŕlas dimlamurdé. Gam Maria nug keŕ keŕ beko atan qe owa ih dahmelle daré. ");
INSERT INTO fad_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesus nug dahmak kena ole kena man. Tiwur am danahas ole nusig olag gamag asdé. ");
INSERT INTO fad_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Makaŕ 15 owa Taiberias nug Rom atu qe kunum dilag king daré. Pontius Pailot nug Yudia wan atu qe gumdé, Herod Antipas nug Galili atu qe gumdé, am kamag Filip nug wan atu aŕit Ituria am Trakonitis ole gumatdé. Am Lisanias nug Abilene wan atu qe gumdé. ");
INSERT INTO fad_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anas am Kaiafas ole a pris dilag kuri darap. Sén qewa Sakaraia nag Yon atu meiŕak danahas kawawa dewew, Tiwurdi Né nugrowa uŕiyan. ");
INSERT INTO fad_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yon nug atu le naŕi Yordan mourak qe kunumba weiyelle né kuswelle danahas dilag anan. “Tiwur hipunin asilag kusuqrigri ge, ag olag buliew le luak os.” ");
INSERT INTO fad_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Qe sillah profet Aisaiari Né yakwa algu anan, “Danah os atu meiŕakwa qalko uŕurig. ‘Naŕinah uŕirigri ih bawres. Ih mangu mores. ");
INSERT INTO fad_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ollu kunum meglares am qouku nounu am qouku wagé wagé qe ole kunum mangu marweg uŕemqes. Ih méŕiak qe kunum mangu mares, am ih goto goto qe bawres. ");
INSERT INTO fad_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Danahas kunum Tiwur asilag kugwari buliko diardig qe pelag,’ ” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Danahas ameg naŕi Yon le luardigri gumdeksi ateg. Atweg ge, Yon anaran, “Ag mat nou bégur. Oun anew ag Tiwurdi uhŕibak uŕirigri unaka de qe eŕdeksi kum atsi? ");
INSERT INTO fad_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ag meŕenah olag buliew pe, mou kena qe seweg bar. Am ag agégé ‘Ig Abraham fuŕuh,’ éksi aw anweg. Da ag anarina, Tiwur qar nisi ene oko sew Abraham fuŕuh belag olele. ");
INSERT INTO fad_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Palangis qe ker kuardigri iŕil diglagwa bawrak de. Ker are os mou kena ospi niweg pe, kuarko kewba touŕardig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yon qere anew ge, danahas kuŕum ag koŕmoreg. “Am ig aregnah sénig?” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yon koŕlagwa oko anan. “Danah siot aŕit ole ge os ge danah siot kawa ole qe morar. Am danah oun nug ke ole ge nug ole qere ih sar.” ");
INSERT INTO fad_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis wak danah os ole le luarakri Yon gumdeksi uŕiyeksi koŕmeg. “Duak marak danah, am ig ge aregnah sénig?” ");
INSERT INTO fad_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yon koŕlagwa oko anaran, “Ag qarég takis wakri anak qe ih mangu os am aw qe éŕurweg,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Fan danah os ole koŕmoreg. “Am ig ge areg sénig?” Yon koŕlagwa oko anaran, “Ag danah aw keigarweg faŕareksi qarég marweg. Am ag danah aw yagoŕ mareksi qarég oweg, ag kuak asilag noh mangu olag gamag asakwa os,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Danahas ag Kristus ameg méksi daréw, géri ag dahmak kuŕum og. Qewa ge ag kunum olagwa ih ere dahmeg. “Yon nug Kristus qenan te?” éksi dahmeg. ");
INSERT INTO fad_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Géri Yon danahas kunum koŕlagwa oko anan. “Da lewa ih le luarina, gam geisah danah os da eŕlak nug gagragsak ole uŕirig. Da danah kena kawa am nug fég gaŕa darér kusqakri olele kawa. Nug Koulli Gunwa am kew aŕikwa luardig. ");
INSERT INTO fad_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Danah qe nug iŕil kekuakri bawré de. Nug darweh owa reis mou ge, kepaŕko qagulko nug lougwa mérig. Gam reis gaŕa ge kew pi qouse ole qewa mandig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yon nug né la kuŕumba danahas doulag patelle am Né Kena ole kusuan. ");
INSERT INTO fad_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gam sén Herod atu qe gumewew, Yon Herodri hipunin uŕa kopatko gaŕa moran. Keŕdi nug kamag waw Herodias kaŕurko am nug hipunin la kuŕum os ole san. ");
INSERT INTO fad_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Am Herod nug hipunin nusig la os qe tuŕurko sew kuak danah nusig Yon uksi kalabuswa yaneg. ");
INSERT INTO fad_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sén Yon kalabuswa pi atak delle danahas kuŕum le luarelle, Yesus ole le louran. Le lourak qe oko malako unuqorewew saw matlan. ");
INSERT INTO fad_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Saw matlew ge, Koulli Gun kuhŕil sillah Yesus dowa new am Tiwur fag saw karandi anan. “Na nir dasilnah. Da nasip ol mouse am ol gamag ase,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Sén Yesus makaŕ nusig 30 keke qere dewew, kekuak nusig diguman. Danahas dahmeg ge nug Yosep nag éksi aneg. Yosep nug Heli nag. ");
INSERT INTO fad_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Am Heli nug Matat nag, am Matat nug Liwai nag, Liwai nug Melki nag, Melki nug Yanai nag, Yanai nug Yosep nag. ");
INSERT INTO fad_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Am Yosep nug Matatias nag, am Matatias nug Amos nag, am Amos nug Nahum nag, am Nahum nug Esli nag, Esli nug Nagai nag. ");
INSERT INTO fad_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai nug Mat nag, Mat nug Matatias nag, Matatias nug Semen nag, Semen nug Yosek nag, am Yosek nug Yoda nag. ");
INSERT INTO fad_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Am Yoda nug Yoanan nag, Yoanan nug Resa nag, Resa nug Serubabel nag, Serubabel nug Sialtiel nag, Sialtiel nug Neri nag. ");
INSERT INTO fad_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Am Neri nug Melki nag, Melki nug Adi nag, Adi nug Kosam nag, Kosam nug Elmadam nag, am Elmadam nug Er nag. ");
INSERT INTO fad_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Am Er nug Yosua nag, Yosua nug Elieser nag, Elieser nug Yorim nag, Yorim nug Matat nag, Matat nug Liwai nag. ");
INSERT INTO fad_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Am Liwai nug Simion nag, Simion nug Yuda nag, am Yuda nug Yosep nag, am Yosep nug Yonam nag, Yonam nug Eliakim nag. ");
INSERT INTO fad_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Am Eliakim nug Melea nag, Melea nug Mena nag, Mena nug Matata nag, am Matata nug Natan nag, am Natan nug Dewit nag. ");
INSERT INTO fad_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Am Dewit nug Yesi nag, Yesi nug Obet nag, Obet nug Boas nag, Boas nug Salmon nag, Salmon nug Nason nag. ");
INSERT INTO fad_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Am Nason nug Aminadap nag, Aminadap nug Atmin nag, Atmin nug Arni nag, Arni nug Hesron nag, Hesron nug Peres nag, Peres nug Yuda nag. ");
INSERT INTO fad_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Am Yuda nug Yakop nag, Yakop nug Isak nag, Isak nug Abraham nag, am Abraham nug Tera nag, Tera nug Nahor nag. ");
INSERT INTO fad_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Am Nahor nug Seruk nag, Seruk nug Reu nag, am Reu nug Pelek nag, Pelek nug Eber nag, Eber nug Sela nag. ");
INSERT INTO fad_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Am Sela nug Kainan nag, Kainan nug Arpaksat nag, Arpaksat nug Sem nag, am Sem nug Noa nag, Noa nug Lamek nag. ");
INSERT INTO fad_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Am Lamek nug Metusela nag, Metusela nug Inok nag, Inok nug Yaret nag, Yaret nug Mahalalel nag, Mahalalel nug Kenan nag. ");
INSERT INTO fad_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Am Kenan nug Inos nag, Inos nug Set nag, Set nug Adam nag, Adam nug Tiwur nag. ");
INSERT INTO fad_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesus Yordan le minko atew, sén qewa Koulli Gun nug owa olele morew dessa Yesus omalko atu meiŕak danah kawawa atan. ");
INSERT INTO fad_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Omalko atew ge, Yesus deŕ 40 qere dewew, nou memeg qepian. Am sén qewa Yesus nug kité ospi lan, géri deŕ qe malwew ge nug laké qan. ");
INSERT INTO fad_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Qew ge, nou memeg Yesusri anan, “Na Tiwur Bega daka pe, qar ene anwe ke buliar,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Anew ge, Yesus anan, “Tiwurdi Né yakwa ane, ‘Danahas kewa ih fou pi dasi,’ ” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Anew ge, nou memeg Yesus omalko atu qoukuwa teko usihri Yesus wan atu kunum ismuran. ");
INSERT INTO fad_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ismurko anan, “Da na gagragsak mirwi wan atu e kunum gumdip am da séwi binam naŕi ole darip. Keŕdi keke ene kunum ge da miŕak. Qeri da danah os murdildi ge da murdil. ");
INSERT INTO fad_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Qeri na da nolwa duk noka binal mérip ge keke kunum nasip darig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesus koŕewa oko anan. “Tiwurdi Né yakwa ane, ‘Na Naŕinah nasip Tiwur ih binag me am kallowa da,’ ” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Anew ge, nou memeg Yesus omalko Yerusalem atko sew Tiwurdi Lo koŕgo karannah qewa tew anoran. Na Tiwur Bega daka pe, olka wanap no. ");
INSERT INTO fad_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Keŕdi Tiwurdi Né yakwa ere ane, “Tiwur doup nusgur anew na dahmireksi koutorlag.” ");
INSERT INTO fad_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ag ewlagwa na uŕwirlag géri na fén qar ospi yew, eko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Anew ge, Yesus koŕewa oko anan, “Tiwurdi Né ane, ‘Na Naŕinah Tiwur nasip aw mena pewen,’ ” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Nou memeg nug ih kuŕumba Yesus qepian malako ge, Yesus munurko am sén os qeperigri ameg man. ");
INSERT INTO fad_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Sén qewa Koulli Gundi gagragsakwa Yesus buliko Galili atu qewa atko dian, am nug neihwah atu qe kunumba tualan. ");
INSERT INTO fad_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nug Yuda dilag binag mak lo kuŕumba danahas Tiwurdi Néri duak mardé. Danahas kuŕum nug binag sumdéw. ");
INSERT INTO fad_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesus nug nir nagurwa delle kena man ole kaw Nasaret qewa atan. Am nug Sabatwa sansan seré sillah Yuda dilag binag mak lo owa noko, Tiwurdi Né ewqerigri asan. ");
INSERT INTO fad_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Asew ge, binag mak lori kuak danah profet Aisaiari Né yak qe nug moreg. Morweg kolako ge, né os ere anko yak qe mariko peko ewqan. ");
INSERT INTO fad_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Naŕinahri Koulli ge dagnéwa de. Keŕdi nug da danahas o duak agop Né Kena kusurildi kurilwa goŕen gogoŕko toqiŕan. Tiwur nug da Né Kena qe kuswelle danah kalabuswa qagrakwa dasi qe da séwi kusqak olagri am danah amlag gaŕu qe séwi bulieksi aminlagri meiŕew uŕiyin. Tiwur nug da danah kug owa dasi qe séwi kusqak olagri meiŕew uŕiyin. ");
INSERT INTO fad_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Am sén uŕiyew, da Naŕinah danahas nusgur buliko diardigri né qe kusurildi meiŕew uŕiyin.” ");
INSERT INTO fad_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ewqeko malako ge, Yesus Né yak qeko buliko kuak danah qe morko, am nug Né digu kusurigri dian. Dewew ge, danahas kunum Yuda dilag binag mak lowa deg qe amlag atew nug keŕ eko anew dolagri kittureksi deg. ");
INSERT INTO fad_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Am nug digumeko Né ewqan qe kusuan. “Gei Tiwurdi Né ewqewi iŕil duéw ene meŕenah bé,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Danahas kunum dueksi nug binag sumeg. Ag nug koŕewa né kenanah ban qeri dahmak kuŕum ossi am aneg. “Danah uni Yosep nag, gam areg?” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Qere anweg ge, Yesus anan. “Meŕenah, ag geisah nun né dasil ene anlag. ‘Dokta, na nagégé féŕun sewe pasaorar. Kowol are na Kapernaum sewe ig duet ole qe ih na kawan diguwa ewa ole qere se,’ éksi aniŕlag.” ");
INSERT INTO fad_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Qere anaŕelle anan, “Da meŕenah amlagwa anina. Profet nug kawag diguwari danahas ag nug pi sumursi. ");
INSERT INTO fad_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Am da ag amlagwa anina. Elaisari sénwa saw megalko gu kawa makaŕ kiam am kalam 6 qere laké naŕi Israel atu kunumba nian. Sén qe as qehŕas kuŕum Israel daréw. ");
INSERT INTO fad_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Gam Tiwur nug Elaisa mew Israel as qehŕas usih os kéhnurdigri pi atan. Nug Elaisa mew Sarefat Saidon atu qewa as qehŕas os kéhnurdigri atan. ");
INSERT INTO fad_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Qe sillah sén profet Elisari sénwa Israel danah kuŕum lepra waŕe ole daréw. Gam olagwa Elisa danah usih os waŕe nusig qe pi sew kawa man. Gam Naman Siriarer qe ih sew pasaoran,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Qere anew ge, danah Yuda dilag binag mak lowa deg ole ge né qe dueksi olag uhŕi nounah ban. ");
INSERT INTO fad_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Uhŕilag bew aseksi, Yesus beŕweksi kawlag qoukuwa de qe dougwa waneg. Waneksi qouku sékuwa béwa touŕweg nurigri qere seg. ");
INSERT INTO fad_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Gam qer seppeg, nug buliko gamlagwa wanko ole ih nusig oko atan. ");
INSERT INTO fad_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Dimba ge, Yesus Nasaret minko noko Galili atu qe owa Kapernaum qewa atan. Qewa atko ge, Sabat deŕ oswa ge Yuda dilag binag mak lo owa danahas Tiwurdi Né ismaran. ");
INSERT INTO fad_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ismarew ge, ag nusig né qe dueksi dahmak kuŕum og, keŕdi né nusig ge gagragsak am kuakri wittak ole. ");
INSERT INTO fad_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Am danah os féŕuwa koulli nou ole Yuda dilag binag mak lowa qewa dian. Nug qalko uŕwan. ");
INSERT INTO fad_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ei! Yesus Nasaretrer, na ig keŕ sigripri uŕiyam? Na sewe ig paral ménigri te uŕiyam? Da na duirina. Na Tiwurdi Gun Danah,” eko uŕuko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Uŕuko anew ge, Yesus koulli nou qe gagrag anoran. “Na torka danah qe paŕoka beka eit.” Qere anew ge, koulli nou danah qe paŕwurko beko atelle, touŕew danahas nolagwa atko qewew beko atan. Gam nug gurak ospi moran. ");
INSERT INTO fad_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Danahas kunum doŕlag new, ag agégé né marieksi aneg. “Uni ge keŕ nénah? Nug kuakri wittak ole am gagragsak olewa koulli nou né mare. Qeri ag dueksi ole paŕwureksi atsi,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Qewa ge, Yesus neihwah Galili atu kunumba tualan. ");
INSERT INTO fad_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesus Yuda dilag binag mak lo qe minko danah os wénih Saimon lougwa atan. Qewa ge Saimon numia féŕu gagŕak naŕinah doko niewew, Yesus waŕe qe sew pasaurdigri anoreg. ");
INSERT INTO fad_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Géri nug wanko duk noko delle waŕe gaŕa morew ge, as qe waŕe pasaoran. Pasaorew ge, as qe usihri asko ke asilag bawardigri dian. ");
INSERT INTO fad_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kem nowew ge, danahas leilgar waŕe digu kowol kowol ole qe diaressi Yesus dowa uŕiyeg. Uŕiweg ge, nug danahas kunum waŕe asilag usih usih qere feŕlag oŕwelle kunum ole sew pasaoreg. ");
INSERT INTO fad_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Am qe ih kawa, koulli nou danahas kuŕum paŕwaressi atessi ole Yesusri uŕweg, “Na Tiwur Bega!” éksi aneg. Gam nug gaŕa marew koŕlag qamteksi né ospi marieg. Keŕdi ag dueg ge nug Kristus. ");
INSERT INTO fad_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kuagŕewew ge, Yesus awen os danah kawawa unuqurdigri atan. Atew ge, danahas nug marieksi atessi peg. Peksi ge, nug minarko atewri dagoreg. ");
INSERT INTO fad_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Gam nug anan, “Da Né Kena Tiwur danahas nusgur dilag king delle gumare né qe kusuwi kaw lalawa ole dolag. Keŕdi da kuak qe sérildi anew uŕiyin,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Qewa ge, nug Né Kena kuswelle, Yuda dilag binag mak lo kuŕumba Yudia atu owa weiré. ");
INSERT INTO fad_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Deŕ os Yesus Genesaret le koŕe kawa ŕanwa asko dewew, danahas kuŕumnah nug Tiwurdi Né mariew dolagri omoreksi deg. ");
INSERT INTO fad_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Deppeg nug ŕanwa kuh aŕit os deppes piatan. Sén qewa, kaké wak danah ag kuh minatweg deppes usu isaressi deppeg piaran. ");
INSERT INTO fad_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesus nug olko kuh oswa tan, kuh qe Saimonri. Teko Saimon kuh nakok bitlew ŕan minko lewa nurigri amegwa anan. Now ge, Yesus kuhwa delle danahas doulag patan. ");
INSERT INTO fad_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nug doulag patko malako ge, Saimonri anan. “Kuh palniwe nagur le gamagwa wanew, usu kaké wakri paŕwarweg nos,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Anew Saimon koŕewa oko anan, “Danah naŕi, ig tuqan usu touŕehut kuagŕé, gam kaké ospi wam. Gam na anam qeri usu buliko paŕwarwi nolag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Qere séksi ge, kaké kuŕumnah diarweg usu tataŕlag seg. ");
INSERT INTO fad_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Qere sew ge, leilgar kuak usih kuh oswa deg qe dolagri ewta qarweg, duksi kehnarweg beŕweg. Beŕwarweg beweg ge, kuh aŕit olele kaké yanweg ambew, torieksa lewa nolasri ses. ");
INSERT INTO fad_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Sén Saimon wénih os ge Pita qere peko ge, unaka Yesus fégwa gatewa yako duk noko ge anan. “Naŕinah, da hipunin danah. Qeri na da paŕwilka eit,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Keŕdi nug leigur kunum ole kaké huhak diareg qe peksi dorlag nan. ");
INSERT INTO fad_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimon leikuŕ Yems, Yon ole Sebedi békuŕ qe a ole dorlas nan. Géri Yesus Saimonri anan, “Na aw faŕwen. Na gei digumak danah diardip,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Qere anew ge, kuh beŕwatweg ŕanwa tewes, ken kunum mineksi ge, Yesus dimlamdeg. ");
INSERT INTO fad_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Sén os Yesus nug taun oswa dewew, danah os féŕu kunum lepra waŕe ole qe gumurko duan. Nug doko Yesus peko ge, gatewa yako duk noko Yesus nuqurko anan. “Naŕinah, na ot sew pe, na da féŕulwa waŕe ene sewe kena mar,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Anew ge, Yesus eweg tiorko danah qe féŕuwa meko anan. “Da ol de. Waŕe nasip pasaorar,” eko anew ge, usihri lepra waŕe qe mundan. ");
INSERT INTO fad_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Qe dimba, Yesus danah qe gagrag anoran, “Na danah os amegwa awnah anwen. Mosesri Ŕo yakwa ane qe sillah atka féŕun pris os ismurenna am doŕ os oka mor. Qeri danahas kunum dolag na waŕe nasip sew pasaoran,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Gam Yesus neihwah qe atu kuŕumba tualan. Tualew dueksi ge, danahas nusig né dolagri am waŕe asilgar kusuqko mardigri kuŕumnah uŕiyeksi qagleg. ");
INSERT INTO fad_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Gam Yesus sén kuŕum minarko atko awen danah kawawa delle unuqordé. ");
INSERT INTO fad_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Deŕ os Yesus danahas doulag patelle dewew, Farisi os am Mosesri Ŕo duak danah ole qewa deg. Ag kaw kuŕumbari Galiliri Yudiari am Yerusalemri ole uŕiyeg. Am Tiwurdi gagragsak waŕe danah sew pasaorakri qe Yesus dowa dian. ");
INSERT INTO fad_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Sén qewa danah os ag danah eweg fég mousak ole os qaŕqaŕwa méksi maweg. Ag maweksi lo owa nuksi Yesus nohwa melagri seg. ");
INSERT INTO fad_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Gam danahas kuŕumnah, géri awen amban. Ambew ge, waŕe danah qe uksi owa nolagri seg, gam ih ospi peg. Géri qaŕqaŕ ole maweksi lo koŕgowa teg. Téksi ge, lo koŕgo siŕeksi oŕe qewa qaŕqaŕ ole paŕoweg now danahas gamlagwa Yesus nohwa meg. ");
INSERT INTO fad_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Meweg ge, Yesus olag meŕe mak qe peko anan. “Lal, hipunin nasip kusqém,” eko anoran. ");
INSERT INTO fad_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Anew ge, Ŕo duak danah am Farisi agégé né kuŕum marieksi aneg. “Danah uni nug kér danah qeri Tiwur pihlure? Danah ounté la os hipunin kusuqrigri olele kawa. Qe Tiwur nugé nusig kuak,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesus asilag dahmak qe duan, géri amlagwa anan, “Ag keŕdi olagwa dahmak qere usi? ");
INSERT INTO fad_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Keŕ né andil qe kug kawa? ‘Hipunin nasip kusqém,’ te kawa ‘Na aska wei,’ eko andil qe te kug kawa? ");
INSERT INTO fad_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gam ag ere dolag. Tiwur nug Danah Bega wan enewa hipunin kusuqrigri kepaŕko kuakri wittak moran,” eko anan. Yesus buliko ge danah eweg fég kunum mousak ole qe amegwa anan. “Na aska qaŕqaŕ nasip oka mouka ole louw eit,” eko anoran. ");
INSERT INTO fad_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Anew ge, usihri danah qe nolagwa asan. Asko qaŕqaŕ nug nian ole qe oko mouko, Tiwur binag sumelle lougwa atan. ");
INSERT INTO fad_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Qeri danahas kunum dorlag new Tiwur binag sumessi am ag Tiwurdi gagragsak faŕdeksi aneg. “Ig gei kowol founah os piam,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Qe dimba ge, Yesus atko takis wak danah os wénih Liwai takis wak lowa dewew pian. Peko ge, amegwa anan, “Na doka da dimlamiŕ.” ");
INSERT INTO fad_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Qere anew ge, Liwai keke kunum minelle asko Yesus dimlamdan. ");
INSERT INTO fad_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dimba ge, Liwai nug lougwa Yesusri ke naŕi san. Sew ge, takis wak danah kuŕum am danah la os ole a ole ninaqiŕeksi dessi ke qe leg. ");
INSERT INTO fad_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Gam Farisi am Ŕo duak danah Farisi dilag ag dougwa piareksi deg qe aseksi Yesus bégur agop né né kuŕum marieg. “Ag takis wak danah am hipunin danah la ole ke am le ole ospi lelew sillah,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Anweg ge, Yesus amlagwa anan, “Danahas waŕe kawa ge dokta dowa pi atsi. Gam danahas waŕe ole qe ih dokta dowa atsi. ");
INSERT INTO fad_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Da danahas mangu diardildi pi uŕiyin. Gam da hipunin danahas anwi olag bulirigri uŕiyin,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sén qewa, danah qe Yesus ere amegwa aneg. “Le Luarak danah Yon bégur ge sén kuŕum kurdessi unuqursi. Am Farisi begalgar ag ole qere sési. Gam na begpar ge qere ospi sési ag ke le ole lési,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Géri nug né tonak ene anaran, “Danah os as owew, ag nug leigur ke gun marlag olele te? Sén nug qe ole deppeg, kawa. ");
INSERT INTO fad_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gam dimba geisah danah qe uksi atlag, géri nug foula leigur ole pi daweg. Sén qewa ge, leigur qe ke gun melag,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesus nug né tonak os anaran. “Danah ounté nug lamen fou ge parilko sarih nagur os oko am lamen alag oŕe pi titie. Am danah os qere sérig ge, nug lamen fou qe sew nou mérig. Am lamen sarih fou qe lamen alag qe ole amnak usih kawa. ");
INSERT INTO fad_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Am danah ounté os nug wain fou bawrak le witakri doŕ gaŕa alagwa pi yane. Am danah os qere sérig ge, wain fou doŕ gaŕa parilko wain wanwa gogoŕdig. Am wain fou doŕ gaŕa le witakri qe ole sew nou mérig. ");
INSERT INTO fad_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Danah nug wain fou ge doŕ gaŕa fouwa ih yanar. ");
INSERT INTO fad_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Am danah nug wain alag tatam le ole ge, nug wain fou bawrak qeri ospi sew. Nug ane, ‘Wain alag ge kena,’ ” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Sabat deŕ oswa Yesus bégur ole reis dar owa nuksi ateg. Atessi ge, nug bégur reis qieksi ewlagwa mou oŕoleksi damqéksi leg. ");
INSERT INTO fad_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Qere seweg ge, Farisi os piareksi koŕmareg, “Sabat deŕwa qere sakri ge gun, gam ag keŕdi qere séw,” éksi koŕmareg. ");
INSERT INTO fad_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesus Farisi koŕlagwa oko anan, “Ag Dewit danah nusgur ole laké aqarew seg qeri, Né yak nie ge ospi te ewqéksi dosi? ");
INSERT INTO fad_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Dewit Tiwur Loug owa noko, Tiwur nohwari ke beret qe wan. Beret qe gun, danah balbal kunum dilag kawa, pris dilag mangu. Gam Dewit nug beret qe leko am danah nusgur qe ole marew leg. Ag Né yak qe ospi te ewqeg?” ");
INSERT INTO fad_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesus buliko anaran, “Danah Bega nug Sabat deŕ gume,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Sabat deŕ oswa Yesus nug Yuda dilag binag mak lowa noko danahas Tiwurdi Néri duak maran. Am danah os eweg kenari mousak ole qewa dian. ");
INSERT INTO fad_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ŕo duak danah am Farisi os ole ag keŕ ihwa os Yesus yagoŕ morlagri ih marieg. Géri ag Yesus Sabat deŕwa waŕe danah kusqarew pelagri kaŕéordéw. ");
INSERT INTO fad_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Gam Yesus asilag dahmak qe iŕil duan. Doko ge, danah eweg mousak ole qe amegwa anan. “Aska danahas gamlagwa sirka da,” eko anoran. Géri danah qe asko sirko dian. ");
INSERT INTO fad_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Dewew ge, Yesus koŕmaran, “Ag dosi ge, kowol are ge Ŕo dimlamdak? Ig Sabat deŕwa danah kowol kena te sarnig, kawa ig gurak te marnig? Ig danah kena dalagri te kehnarnig, kawa ig danah sarhut paral te melag?” eko koŕmaran. ");
INSERT INTO fad_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nug amnew weiyew danah kunum piarko ge, danah qe anoran. “Ewen tior,” eko anoran. Anew danah qe qere sew ge, eweg sew buliko pasaorko koutoran. ");
INSERT INTO fad_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Gam ag uhŕilag bew ge, ag Yesus aregnah sorlagri qe ag agéagé marieg. ");
INSERT INTO fad_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Qe dimba sén os ge, Yesus Tiwurdi unuqurdigri qoukuwa tan. Teko ge, tuqan usih qe unuqorelle dewew kuagŕan. ");
INSERT INTO fad_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kuagŕew furuwa ge, nug bégur anew qagleg. Qagulweg ge, nug 12 qere kepŕarko ag wenlag aposel maran. ");
INSERT INTO fad_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Os ge wénih Saimon, Yesus wénih Pita katŕan. Am Endru, nug Saimon kamag. Yems am Yon ole. Am Filip, Batolomiu ole. ");
INSERT INTO fad_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu am Tomas ole. Am Yems nug Alfius nag. Am Saimon, nug Silot danah ameg qewari. ");
INSERT INTO fad_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Am Yudas, nug Yems nag. Am Yudas Iskariotrer, nug dimba geisah Yesus kegeŕ ewlagwa mérig. ");
INSERT INTO fad_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesus Bégur 12 ole nuksi ge, nug wanko wan uŕemba asko dian. Nug bégur kuŕumnah ole deg. Am danahas kuŕumnah Yudia atu kunumbari am Yerusalem taun qewari am Tair, Saidon ole ŕanwari qe kunum ole deg. ");
INSERT INTO fad_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ag nusig né dolagri am nug feŕlagwa waŕe kusuqrigri ole uŕiyeg. Danahas koulli nou sarew nou marak ole ge, Yesus kusqaran. ");
INSERT INTO fad_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yesusri gagragsak wanko danah kunum kusqaran, qeri danahas kuŕumnah nug féŕu oŕalagri seg. ");
INSERT INTO fad_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesus nug bégur piarko delle anaran, “Danah ag gei o duak dasi, ag olag gamag asar. Keŕdi Tiwurdi kingdom ge asilag. ");
INSERT INTO fad_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Danah ag gei laké dasi, ag olag gamag asar. Keŕdi dimba Tiwur sew ag kutuk ospi meweg. Danah ag gei kunnessi dassi, ag olag gamag asar. Keŕdi dimba ag imlag. ");
INSERT INTO fad_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ag Danah Bega dimlamdeppeg, qeri séksi danah ag kegeŕ maressi uksi uksi aqsi am geŕaressi am wenlag seweg nou mew ge, ag olag gamag asar. ");
INSERT INTO fad_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ag asilag qere seweg pe, ag sén qewa gamlag asakwa olessi des. Keŕdi qe noh asilag saw kappa ge naŕinah. Algu alalgar profet dilag ole qere seréw. ");
INSERT INTO fad_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Gam danah kehlag ole ag kug os pelag. Ag keke sew olag kena diakri iŕil oweg olele moran. ");
INSERT INTO fad_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Danah gei ke léksi koutursi, ag kug os pelag. Ag dimba laké aqardig. Danah ag gei imsi, ag ole geisah Tiwurdi uhŕibak pelag. Dimba ag olag nou mew kuanak naŕi selag. ");
INSERT INTO fad_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ag danah kunum binlag sumbeg ge, ag kug os pelag. Algu alalgar profet darmak dilag ole qere seréw,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesus doulag patelle anaran. “Gam ag né dasil dosi ole ag anarina. Ag kegeŕ asilgar dilag olag mousar. Danah os kowol nouni sarweg ge, ag kowol kena sares. ");
INSERT INTO fad_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ag danah os wittak nou marweg ge, ag Tiwur koŕmorweg wittak kena marar. Am danah nouni sarweg ge, ag asilag unuqores. ");
INSERT INTO fad_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Danah os na siwen leis ge korew pe, leis ole buliwe korar. Am danah os lamen nasip ow ge, minwe kasuk nasip qe ole war, aw gagansi owen. ");
INSERT INTO fad_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Am danah os na kekeri koŕmirew ge, na mor. Am danah os nasip keke ow ge, na buliko mirdigri wagé meka aw sewen. ");
INSERT INTO fad_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Danah la ag kowol kena sarlagri olag nie qe sillah, ag ole qere sares. ");
INSERT INTO fad_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ag danah asilag olag mouse ole qe dilag ih olag mousew pe, oun ge ag danah kena eko anardig? Hipunin danah ag ole danah are asilag olag mouse ole qe dilag ih olag mouse. ");
INSERT INTO fad_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Am ag kowol kena danah os asilag sési ole qe dilag ih seweg pe, oun ge ag danah kena eko anardig? Hipunin danah ole ag kowol qere ih sési. ");
INSERT INTO fad_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Am ag danah keke marsi qe noh marlagri olele duessi marweg pe, oun ge ag danah kena eko anardig? Hipunin danah ole ag hipunin danah leilgar keke marsi qe ag keke noh olele bulieksi marlagri duessi marsi. ");
INSERT INTO fad_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Gam ag kegeŕ asilag dilag olag mousar am ag nouni aw sarweg. Ag keke mareksi am noh olagri aw dahmeweg. Ag qere seppeg ge, ag noh naŕi mardig am ag Tiwur Karannah bégur dalag, keŕdi nug danah nou am danah keke marew kena sam éksi pi ansi qe ole nouni pi sare. ");
INSERT INTO fad_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ag danah dilag olag duar, Memlag Tiwur o duak nie ole qe sillah.” ");
INSERT INTO fad_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ag danahas dilag kowol nou aw kepŕessi am nou arweg. Qere seweg ge, Tiwur ole asilag qere sérig. Ag danahas kowol nou asilag noh olagri aw anweg. Qere seweg ge, Tiwur ole asilag qere sérig. Ag danah os nouni sarweg ge, hipunin asilag kusuqqeg, Tiwur ole asilag hipunin kusuqrig. ");
INSERT INTO fad_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ag danah la qe keke mares am Tiwur geisah ag keke mardig. Geisah Tiwur keke yanew ambeko letewew mardig. Ag keke gane danah marsi qe sillah Tiwur ag ole mardig,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Anko ge, Yesus né tonak os ole amlagwa anan. “Danah os ameg gaŕu nug ameg gaŕu lia omaldigri olele te? Kawa, geisah a olele tolweksa moŕwa nolas. ");
INSERT INTO fad_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sulnir nug duak nusig duak morak danah nusig pi eŕde. Sulnir are nug duak morak danah nusig dowari duak kunum oko malako ge, duak morak danah nusig qe sillah bérig. ");
INSERT INTO fad_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Areg na liap amegwa kinkak nagurnah de qeri aminna? Gam na amenwa ker masa naŕi de ge, pite dahmorna? ");
INSERT INTO fad_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na nagégé amenwa ker masa naŕi de ge pite penna am areg liap anorna, ‘Lal, da na amenwa kinkak nagurnah de ge uŕil seina.’ Na darmak gaŕanwa ih Tiwur dimlamdak danah! Na tatam na nagégé amenwa ker masa naŕi ge oka, amen kena mew aminka koutorka ge, na kinkak nagurnah liap amegwa de qe uŕipri olele.” ");
INSERT INTO fad_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ker kena nug mou kena nie. Qe sillah ker nou nug mou nou nie. ");
INSERT INTO fad_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Danah ag ker mou tatam peksi ge, ker qe kena te, ker qe nou te ge ag dosi. Danah ag guŕaw mou darér qoum olewari pi usi. Am ag peipé mou ker nagurnah qoum olewari pi tuqsi. ");
INSERT INTO fad_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Danah kena nug dahmak kena kuŕum owa nie. Qeri nug kowol kena se. Qe sillah danah nou nug dahmak nou kuŕum owa nie. Qeri nug kowol nou se. Keŕdi nug dahmak nou owa ambak nie qe, koŕewa bew ane.” ");
INSERT INTO fad_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Keŕdi ag dasil ‘Naŕinah, Naŕinah,’ éksi ansi, gam ag da koŕel ospi dimlamursi? ");
INSERT INTO fad_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Danah os da gumiŕko doko, am da fal doko dimlamurdig ge, da kowol nusig qe mariwi ag dolag. ");
INSERT INTO fad_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nug danah os lo fuan qe sillah. Tatam ge, nug moŕ pesorko oko, wandor lagko kétum qeko koutorko ge lo fuan. Dimba le kue neko lo qe yepian, gam qiakri olele kawa. Keŕdi nug fuko koutoran. ");
INSERT INTO fad_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Am danah nug da fal doko pi dimlamde ge, nug danah os moŕ oko, wandor diguwa kétum pi qak lo fuan qe sillah. Géri dimba lo qe le kue neko yepew ge, qiko neko ole kaduŕko nou meko koutoran,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sén Yesus nug danahas né qene marko malako ge, nug Kapernaum taunwa atan. ");
INSERT INTO fad_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Qewa ge, Romdi fan kuri danah nug kekuak nir os ole daré. Kuak nir qeri o naŕi niré ole qe waŕe meko mousdigri malwak nian. ");
INSERT INTO fad_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Fan kuri danah nug Yesus qewa dian né qe doko ge, nug Yuda dilag kuri danah meŕarew ateg. Ateksi ge, Yesus amegwa anweg uŕiko kuak nir nusig qe sew waŕe pasaurdigri anoreg. ");
INSERT INTO fad_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yesus dowa ateksi gagragnah ere aneg, “Danah qe kenanah. Na kéhnurdipri olelenah. ");
INSERT INTO fad_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nug ig Yuda isanig o niew binag mak lo isanig fuan.” ");
INSERT INTO fad_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Géri Yesus ag ole ateksi, fan kuri danah qe loug mourak waneppeg ge, nug leigur os meŕarew Yesusri né uksi ateksi ere aneg. “O naŕinah, na aw kekuak naŕi sewen. Na da loul owa neripri olele kawa, keŕdi da danah kenanah kawa. ");
INSERT INTO fad_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Qeri da duina ge, da na gumirko wanakri olele kawa. Na qere denna am né ih anwe, dasil kekuak nir waŕe pasaorar. ");
INSERT INTO fad_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Keŕdi da ole danah wénih ole kekuak miŕe qe kallowa deina. Am da ole fan danah os da kallolwa dasi. Am da usih os amegwa anina, ‘Na eit,’ eko anwi ge, nug ate. Am da la amegwa anina, ‘Na doka,’ eko anwi ge, nug do. Am da dasil kekuak nir qe amegwa anina, ‘Na kekuak ene se,’ eko anwi ge, nug qe se.” ");
INSERT INTO fad_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sén Yesus né qe doko ge, danah qeri o meŕe mak peko wawtuŕko ole o gamag asan. Asew ge, nug buliko danahas ameg naŕi dimlamdeg qe anaran, “Da ag anarina. Israel olagwa danah usih os o meŕe mak ere ole ospi pégin.” ");
INSERT INTO fad_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Qe dimba, fan kuri danah leigur meŕarew ateg ge, bulieksi louw uŕiyeksi, kekuak nir qe iŕil sew pasaoran peg. ");
INSERT INTO fad_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nagur dimba Yesus taun os wénih Nain qewa atan. Nug bégur am danahas ameg naŕi qe ole nug dimlamdeg. ");
INSERT INTO fad_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nug atko taun ihŕam naŕi qe mourak wanewew ge, danah mousak os mawessi dog. Danah mousak qe anig nug nag usih qe ih ole am nug as qehŕas. Danahas ameg naŕi taun qewari asessi as qe ole aŕié dog. ");
INSERT INTO fad_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Naŕinah nug as qe peko ge, o naŕi dow, nug as qe amegwa anan. “Na aw kuanwen.” ");
INSERT INTO fad_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Qere anelle ge, unaka wanko danah mousak nian ole qaŕqaŕ qewa eweg man. Eweg mew ge, danah qaŕqaŕ maweg qe asessi deppeg, Yesus anan. “Nir geiŕ, da anirina, na as,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Anew ge, danah mousak qe buliko asko delle ge, digumeko né marian. Yesus nir qe paŕwew anig dowa wanan. ");
INSERT INTO fad_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Géri danahas kunum faŕeksi nou méksi Tiwur binag meg. Ag aneg, “Profet naŕi os onigwa bé. Tiwur danah nusgur kehnardigri uŕié,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Danahas Yesusri né qe Yudia wanwa am atu lala talilorak nie qe kunumba mariweg tualan. ");
INSERT INTO fad_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yon nug bégur ag keke kunum dueg am peg qe nug amegwa anweg, nug békuŕ aŕit uŕwatan. ");
INSERT INTO fad_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nug Naŕinah ere koŕmorlasri anew ates. “Na enan te Tiwur uŕiripri anan, kawa ig danah la te ameg ménig?” ");
INSERT INTO fad_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Sén danah aŕit qe Yesus dowa ateksa ge, amegwa anes. “Le Luarak danah Yon anew i na koŕmirnitti gumdekŕu uŕiah. Nug ere ané, ‘Na enan te Tiwur uŕiripri anan, kawa ig danah la te ameg ménig?’ ” eksa koŕmores. ");
INSERT INTO fad_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sén qewa ih Yesus danahas kuŕum waŕe digu digu ole sew pasaoreg am koulli nou danah feŕlagwari kuŕum geŕaran. Am danah amlag gaŕu ole kuŕum sew amlag kena mew bulieksi amneg. ");
INSERT INTO fad_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Am danah aŕit qe amlaswa anan, “Bulieksa ateksa Yon keke piap am duap ole qe amegwa anes. Amlag gaŕu ge bulieksi aminsi, félag mousak ge bulieksi weisi, lepra danah ge feŕlag buliko pasaore, doulag itwak ge bulieksi né dosi, danah mousak ge bulieksi assi, am o duak danah ag Né Kena dossi. ");
INSERT INTO fad_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Am danah os o meŕe mak gagrag dewew da pi dimiŕdig ge, Tiwur nug wittak murdig.” ");
INSERT INTO fad_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Danah aŕit Yonri né oksa uŕies ole qe mundeksa atwes ge, Yesus digumeko danahas amlagwa Yonri anaran. “Ag awen danah kawawa keŕnah pelagri Yon gumdeksi ateg? Ag ulas qaweŕ os oŕwew ulle qe te pelagri ateg? ");
INSERT INTO fad_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Kawa ge, ag keŕ qewa pelagri ateg? Ag danah bala kena ole te pelagri ateg? Kawa, danah bala kena kena mési am danah kehlag ole qe king lougwa dasi. ");
INSERT INTO fad_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gam ag keŕ pelagri ateg? Ag profet te pelagri ateg? Yo, da amlagwa anina. Nug profet la kunum eŕarak. ");
INSERT INTO fad_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Danah Yon eneri ih Tiwurdi Né yakwa ane. ‘Da dimba geisah meŕ danah dasil méwi atko na nom oko anuqko nasip ih bawardig.’ ");
INSERT INTO fad_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Da ag amlagwa anina. Yon nug danah wanwa dasi qe kunum eŕarak. Gam danah nug Tiwurdi Kingdomwa nagurnah de qe nug Yon eŕdak,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Danahas kunum takis wak danah ole Yesusri né dueksi olag usihwa “Tiwur ge mangunah,” éksi dahmeg. Keŕdi ag atweg Yon le luaran. ");
INSERT INTO fad_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Gam Farisi am Mosesri Ŕo duak danah ole Tiwur ag ih ismaran qe dimoreg, keŕdi ag Yon le luarak mineg.) ");
INSERT INTO fad_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesus buliko anaran. “Da keŕ né tonakwanah os danahas geiri ismardil? Kowol asilag ge aregnah? ");
INSERT INTO fad_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ag nir nounu sillah. Kaw gamagwa dessi nir nounu la uŕwaressi dasi sillah. ‘Ig asilag dumdum yaltu ge, ag kasi sak minéw. Am ig ginanig kuktu iŕtu, gam ag kuanak minéw,’ éksi ansi. ");
INSERT INTO fad_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Le Luarak danah Yon nug uŕiyan am nug ke wain ole ospi leré. Qeri ag aneg, ‘Koulli nou nug féŕuwa de.’ ");
INSERT INTO fad_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Danah Bega uŕiyan, nug ke wain ole lewew, ag ansi, ‘Danah ene pes. Nug ke wain ole naŕinah lelle de. Nug takis wak danah am hipunin danah ole liam patak dasi,’ éksi ansi. ");
INSERT INTO fad_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Gam danahas Tiwurdi duak usi ole kowol asilagwa ismigsi ge, duak qe keke meŕenah,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi os nug Yesus ole ke lelasri anew ge, Yesus Farisi qe lougwa atko ninaqiŕko dian. ");
INSERT INTO fad_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Hipunin as os taun qewa daré. Nug Yesus Farisi qe lougwa ke lelle dian né qe doko ge, nug goŕen muŕdig kenanah ole siné ambak oko uŕiyan. ");
INSERT INTO fad_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Sén nug wanko Yesus dimugwa fég mourak kunnelle dewew ge, amŕi gogoŕko noko Yesus fég lourew ge, kuri uŕugwa uŕtian. Uŕtielle ge fég kis morko goŕenwa fég waŕwuran. ");
INSERT INTO fad_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farisi Yesus nug lougwa uŕiyan ole qe, kowol qe peko ge, owa ih anan. “Danah uni nug profetnah wen, nug as uni keŕ as nugnéwa eweg me qe dolo am nug as qe hipunin as qe ole dolo.” ");
INSERT INTO fad_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Géri Yesus nug danah qeri dahmak doko ge, amegwa anan, “Saimon, da né os ole na amenwa andildi.” Anew ge, Saimon anan, “Aria, duak marak danah, né nasip ge an.” ");
INSERT INTO fad_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesus anan, “Danah aŕit os ateksa danah qarég ole qe dowa waneksa qarég os anwes matan. Danah os ge anew 10,000 kina moran am danah os ge anew 100 kina ih moran. ");
INSERT INTO fad_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Danah aŕit qe qarég qe buliko morakri olele kawa, géri danah nugnéwa qarég os ole qe nugégé kug asilas qe duew doug katian. Qeri danah aŕit qe olaswa oun nug danah qe o kunum ole murdig?” ");
INSERT INTO fad_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon anan, “Arté, danah qarég naŕi wan ole qe.” Yesus amegwa anan, “Né noh nasip qe mangu.” ");
INSERT INTO fad_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Am Yesus buliko as qe peko delle ge, Saimon amegwa anan. “Na as ene pena te? Da na lout owa ném, am na da fél isdilri le ospi miŕam. Gam as ene ge nug amŕiwa fél uhŕu oko am kuri uŕugwa uŕtié. ");
INSERT INTO fad_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na da kis ospi miŕam. Gam sén da owa ném am uŕiyew geisah e patak as ene da fél bulibuli kis moré. ");
INSERT INTO fad_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na ig kounigwa da kurilwa oliw goŕen nagur ospi waŕwuram, gam as ene goŕen muŕdig olewa da fél waŕwuré. ");
INSERT INTO fad_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Qeri da na amenwa anina. Nug o naŕinah miŕe, qeri da hipunin nusig kuŕumnah kusqém. Gam danah os nug hipunin nagur se eko ane qe kusuqwi ge, nug o nagur ih miŕe.” ");
INSERT INTO fad_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Qe dimba Yesus as qe amegwa anan, “Hipunin nasip kusqém.” ");
INSERT INTO fad_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Danah nug ole ke lessi deg qe agégé nug koŕmorew wane morew duak séssi aneg, “Danah ene ounnah qeri nug hipunin kusqe?” ");
INSERT INTO fad_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesus as qe amegwa anan, “Na dasil ot meŕe mé qewa buliko wirém! Na aska ot kenawa ih eit,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Qe dimba nagur os dessi ge, Yesus taunwa am kappa ole weiyelle Tiwurdi Né Kena kusuko anan. “Tiwur danahas nusgur dilag king delle gumardigri sén uŕiyé.” Nug Bégur 12 qe am as os ole aŕié ateg. ");
INSERT INTO fad_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","As qe tatam Yesus koulli nou feŕlagwari geŕaran am waŕe ole deppeg sew pasaoreg. Os ge wénih Maria taun Makdalari. Tatam Yesus koulli nou 7 qere féŕuwari geŕaran. ");
INSERT INTO fad_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Am Yoana, nug gému Kusa ge Herod loug qeri kuakri kuri danah. Susana am as la kuŕum os ole ateg. As qe ag asilag kekewa Yesus bégur ole kehnareg. ");
INSERT INTO fad_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Danahas kuŕumnah taun lalawari uŕiyessi Yesus dowa qagleg. Qagulweg ge, Yesus né tonak os amlagwa anan. ");
INSERT INTO fad_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Danah os atko dara ke saŕeg touŕan. Nug touŕelle atewew ge, ke saŕeg os ihwa tolweg. Tolwessi neweg ge danah tapareg am kunum é diareksi lareg. ");
INSERT INTO fad_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Am ke saŕeg os ge wan qarqar olewa tolweg. Tolweksi qaŕa beg, gam wan qe le ole kawa, géri ke qaŕa wagam kawa ole meiŕeg. ");
INSERT INTO fad_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Am ke saŕeg os ge meŕ qoum ole gamlagwa tolweg, géri aŕié béksi meŕ qoum ole ke qaŕa tonarweg meiŕeg. ");
INSERT INTO fad_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gam ke saŕeg os ge wan kenawa tolweg. Ag béksi mou kuŕumnah nieg. Mou ge 100 eŕdak qere.” Yesus qere anko ge uŕuko anan, “Danah oun os doug né duakri ole dew pe, né ene doko koutorar.” ");
INSERT INTO fad_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesus nug bégur né tonak qe diguri koŕmoreg. ");
INSERT INTO fad_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Géri nug anan, “Tiwurdi Kingdomri duak qe algu lariak daré, gam gei nug sew ag duak lugmak qe dosi. Gam, danahas lala qe duak lugmak qe da né tonakwa anarina. Qeri Né yak qe mou bérig. ‘Ag aminsi gam ospi peweg. Am né qe dosi gam digu ge olag ospi mourew,’ ” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Yesus anaran, “Né tonak ene digu ge ere, ke saŕeg ge Tiwurdi Né. ");
INSERT INTO fad_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ke saŕeg os ge ihwa tolasi, qe ge danah né dosi gam dimba nou memeg doko né qe olagwari o. Keŕdi nug qere sew ag olag meŕe pi mew ge, hipunin asilag noh ospi éŕurweg. ");
INSERT INTO fad_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Am ke saŕeg os wan qarqar olewa tolweg ge, danah né qe dueksi uksi olag gamag ase. Gam ag ke qaŕa diŕi wan kunuk pi no sillah. Qeri ag olag meŕe mak sén kutuk ih de, gam qepiak uŕiyewew ge, ag tolasi. ");
INSERT INTO fad_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Am ke saŕeg os meŕ qoum ole gamlagwa tolasi qe sillah ge, danah né dossi gam ag sén kuŕum asilag kug kowol kowolri dahmési, ag wan ewa kehlag ole am o gamag asakwa dalagri, dahmak qe Tiwurdi Né tone. Qeri ag olag meŕe mak mou ole kawa. ");
INSERT INTO fad_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Am ke saŕeg wan kirag olewa tolwe qe sillah ge, danah olag kena am dahmak mangu ole Tiwurdi Né dueksi gagrag oŕwessi, am ag olag meŕe mak gagrag dewew mou kuŕum nisi.” ");
INSERT INTO fad_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesus buliko né marian. “Danah os lam kamutko wawa pi tone am qaŕqaŕ kallowa pi me. Kawa, nug karan eisew nie. Qeri danah lo owa nuksi ge, sarmeŕ qe pelag. ");
INSERT INTO fad_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Keŕ keŕ lugmak dasi ge, dimba Tiwur ambo mérig. Am keŕ keŕ tonak ge, dimba qe ole ambo mew dolag. ");
INSERT INTO fad_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Qeri dosi koutores. Danah are nug né doko oŕwe ge, Tiwur sew nug o mourew geisah naŕi qere murdig. Gam danah are nug né pi duelle ‘da duina,’ eko ane ge, nug nagur os due qe Tiwur buliko kaŕurdig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Sén qewa Yesus anig am kamgur ole pelagri uŕiyeg. Gam danah kuŕumnah qagleg, qeri ag nug gumdeksi unaka wanakri olele kawa. ");
INSERT INTO fad_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Danah os Yesus anoran, “Na anin am kampar ole peirlagri dimdim ewa aséw dasi.” ");
INSERT INTO fad_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesus buliko anaran, “Da anil am kamlar ge danahas Tiwurdi Né dueksi am dimlamursi ole qe,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Deŕ os Yesus bégur dilag anan. “Doweg, ig le koŕe kawa séku leis uwa atet.” Qere anew ge, kuh oswa olessi téksi ateg. ");
INSERT INTO fad_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kuhwa atessi ge, Yesus usameg new nian. Niewew ge, ulas gagrag le koŕe kawawa bew, le koŕ koŕ naŕi qeko kuhwa noko ambew kug naŕi owa deg. ");
INSERT INTO fad_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Yesus bégur gumdessi wanessi qaqressi aneg. “Danah naŕi, Danah naŕi, ig torinigri sétu.” Géri Yesus asko ulas koŕkoŕ uhŕi naŕi ole gaŕa matew tores. Torwes ge, le ameg mousko nian. ");
INSERT INTO fad_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesus bégur dilag anan, “O meŕe mak asilag arewa de?” Gam ag faŕessi dahmak kuŕum uksi agéagé aneg. “Danah ene oun? Nug ulas le ole gagrag anatew, né nusig dimlamdap,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesus bégur ole kuhwa ateksi Gerasa waneg. Atu qe Galili le koŕe kawa nie qe séku leis de. ");
INSERT INTO fad_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesus kuh minko pitiyewew, danah os féŕuwa koulli nou ole taun os owari nug Yesus gumurko duan. Sén welah nug lamen ospi tagré am louw ospi daré, nug matmatwa ih niré. ");
INSERT INTO fad_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Sén kuŕum koulli nou danah qe pi paŕwurdé. Danah kuŕum nusig sansan amneksi koutordéw, am nug sen darér olewa qagdéw. Gam nug sen darér ole qe tatŕardé. Koulli nou souorew awen danah kawawa atté. Danah qe Yesus peko ge, qalko uŕwelle unaka fégwa wanwa qere tolwan. Tolwew peko ge, Yesus koulli nou danah qe paŕwurdigri gagrag anoran. Qeri nug fag gogwa uŕuko anan, “Yesus, na Tiwur Karannah Bega. Na keŕdi dagrowa uŕiyam? Da gurak aw miŕwen.” ");
INSERT INTO fad_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesus koŕmoran, “Na wénim oun?” Eko anew am nug anan, “Ameg naŕi.” Keŕdi koulli nou kuŕum nug féŕuwa nog. ");
INSERT INTO fad_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Koulli nou qe qagleksi uŕweksi Yesus bulibuli koŕmoreg. “Na ig aw geŕigwe moŕ aminweg atko kutuk mewa nuhut.” ");
INSERT INTO fad_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Fo kuŕum qouku nagur os qewa ke lessi deg. Qeri koulli nou qe ag Yesus dowa qagleksi uŕwessi aneg. “Na ig minigwe fo uni feŕlagwa wanet.” ");
INSERT INTO fad_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Am Yesus anew koulli nou ag danah qe mundeksi fo feŕlagwa waneg. Fo qe gueksi waneksi béwa tolweksi le koŕe kawa qewa nuksi le léksi mouseg. ");
INSERT INTO fad_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Fo gumarak danah ag kowol qe peksi kum atessi taunwa am kaw lalawa ole mariweg tualan. ");
INSERT INTO fad_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Géri danahas ag keŕ ban qe pelagri taun paŕweksi ateg. Ateksi Yesus dowa waneksi ge, danah koulli nou paŕwureksi ateg qe, dahmak qaorew am lamen tako Yesus nohwa ninapiŕko dewew pessi faŕeg. ");
INSERT INTO fad_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Danah os keke qe amlagwa peg ole ge, ag danahas la danah koulli nou ole dewew Yesus areg sew kena man qeri mariweg dueg. ");
INSERT INTO fad_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Géri danahas kunum Gerasa atu qewari Yesus minarko attigri sinanah anoreg. Keŕdi ag olag nouninah faŕan. Géri Yesus buliko attigri kuhwa olko tan. ");
INSERT INTO fad_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Danah koulli nou paŕwureg ole qe Yesus nuqurko anan, “Da na ole atnit,” eko anan. Gam Yesus anew buliko atewew ge anoran. ");
INSERT INTO fad_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Na bulika kawanwa atka, Tiwur keke kunum nasip san qe mariwe dues.” Géri danah qe taun kunumba atko danahas amlagwa Yesus keke kunum san qe kusuko marian. ");
INSERT INTO fad_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesus buliko le koŕe kawa séku leis atew ge, danahas kunum nug felqoreg. Keŕdi ag kunum nug ameg méksi deg. ");
INSERT INTO fad_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Sén qewa danah os wénih Yairus nug Yesus gumurko wanan. Nug Yuda dilag binag mak lo osri kuri danah. Nug Yesus nohwa gatewa yako gagrag nuquran. “Na da ole loulwa atnit olele te?” eko koŕmoran. ");
INSERT INTO fad_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Keŕdi nug nir as usihnah ole am nug makaŕ nusig 12 keke qere qe mousdig malwak nian. Géri Yesus wanko atewew ge, danahas ameg naŕi duksi nug omorweg ateg. ");
INSERT INTO fad_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Am as usih os nug makaŕ 12 qere as dilag waŕe qe ole daré. Am nug kéhu kunum dokta agop malwan. Gam danah ounté os sew waŕe nusig ospi pasaoran. ");
INSERT INTO fad_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","As qe Yesus dimugwa doko, Yesusri lamen noh oŕwew ole waŕe nusig usihri kawa man. ");
INSERT INTO fad_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesus koŕman, “Oun da uŕwilé?” Eko anew, kunum aneg. “Ig kawa, ig kawa.” Éksi anweg Pita anan, “Danah naŕi, danahas ameg naŕi na omiressi qataoréw dasi.” ");
INSERT INTO fad_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Gam Yesus anan, “Ounte da uŕwilé. Keŕdi da gagragsak dasil os paŕwilko atew dahmorém.” ");
INSERT INTO fad_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","As qe duan ge, nug lugumdigri olele kawa. Géri nug sahŕelle Yesus nohwa doko wanwa duk noko, danahas kunum nolagwa nug keŕdi Yesus dowa eweg man qe kopatko amegwa anan. “Waŕe dasil ge usihri sew pasaoré.” ");
INSERT INTO fad_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesus as qe anoran, “Nir dasil, na dasil ot meŕe mé qewa na féŕun sew kena mé. Na aska ot kena ih dewew eit.” ");
INSERT INTO fad_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesus né marielle dewew, Yuda dilag binag mak lori kuri danah Yairus qe lougwari meŕ danah os uŕiyan. Uŕiko ge, Yairus anoran, “Na aŕen ge iŕil mousé. Na duak marak danah aw kug morwen.” ");
INSERT INTO fad_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Gam sén Yesus qe doko ge, Yairus amegwa anan, “Na aw faŕwen. Na dasil ot meŕe mew, geisah aŕen séwi kena mérig.” ");
INSERT INTO fad_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesus nug Yairus lougwa atko ge, nug danah la os minarew nug ole lo owa pi nog. Gam Yesus nug, Pita, Yon, Yems, am nir as qe memeg anig ole ag ih owa nog. ");
INSERT INTO fad_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Danahas kunum nir as qeri masieppeg ge, Yesus amlagwa anan. “Ag aw masiweg. Nir qe pi mousé, nug usnie,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Anew ge, ag dueg nir qe iŕil mousan, qeri ag nug imdeg. ");
INSERT INTO fad_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Gam Yesus lo owa noko nir qe ewegwa oŕako qalko anan, “Nir dasil, na as.” ");
INSERT INTO fad_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Anko malwew, nir qeri koulli buliko féŕuwa uŕiyew foumak oko usihri asan. Yesus amlagwa anan, “Ag ke os morweg lar.” ");
INSERT INTO fad_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nir qe memeg anig ole dorlas new ole faŕes. Gam Yesus gagrag anatan. “A ounté os aw keke eneri amegwa anwes,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesus Bégur 12 qe uŕwarew dog. Doweg ge, nug koulli nou kunum geŕarlagri am waŕe kowol kowol ole kusqarlagri gagragsak am kuakri wittak ole maran. ");
INSERT INTO fad_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Am nug Né Kena “Tiwur king delle danahas nusgur gumardigri” qe kusulagri am waŕe danah seweg pasaorlagri ole anew ateg. ");
INSERT INTO fad_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yesus amlagwa anan, “Ag weiyakri sénwa kité os aw oweg. Ag durqak sokét, baram, ke, qarég am siot aŕit os aw oweg. ");
INSERT INTO fad_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ag lo arewa diarweg nuksi pe, ag qewa ih dessi ole taun qe mineksi ates. ");
INSERT INTO fad_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Gam danahas ag fel pi qaressi diareksi loulagwa pi atweg pe, ag taun qe mineksi atessi ge félagwari usuŕ qeqlessi ates. Ag kowol qe peksi ge, kowol nou asilag qe olag mourdig.” ");
INSERT INTO fad_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Géri Yesus Bégur ateksi kaw kunumba weiyessi, Né Kena kuswessi am waŕe danah atu kunumbari seweg pasaoŕeg. ");
INSERT INTO fad_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herod Antipas nug Galili dilag king. Nug Yesus Bégur ole kuak seg qeri né doko katat qan. Keŕdi danah os ge aneg, “Le Luarak danah Yon buliko siran.” ");
INSERT INTO fad_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Am os ge aneg, “Elaisa gumarko duan.” Am la os aneg, “Profet os algunah mousan qe buliko siran.” ");
INSERT INTO fad_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Géri Herod anan, “Da anwi Yon fag iŕil kotŕeg. Gam danah qe ounnah nusig kuak am kowol ole mariweg duina?” eko anan. Géri nug Yesus perigri dahman. ");
INSERT INTO fad_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesusri aposel bulieksi uŕiyeksi keke kunum seg qeri nug amegwa marieg. Qe dimba ge, nug omlarew, danah la minareksi ag agé kaw os wénih Betsaida qewa ateg. ");
INSERT INTO fad_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Gam danahas dueksi ge, nug dimlamdeksi ateg. Ag nugnéwa atweg ge, nug felqarelle Tiwur king delle danahas nusgur gumardigri né qe kuswew dueg. Am danah os waŕe ole qe sew pasaoŕeg. ");
INSERT INTO fad_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kem noko tueh manew ge, Bégur 12 qe duksi Yesus amegwa aneg. “Na danahas anwe atares. Ag kaw naŕi am kaw nounu unaka dassi qewa ateksi niak awen am ke lakri os ole maries. Awen ig datu ole ene ge danah kawa,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Anweg ge, Yesus buliko anaran, “Ag agégé ke mares.” Gam Bégur 12 qe aneg, “Ig ke kuŕum ole kawa, beret tanig ole am kaké aŕit ole ih de. Ig atektu danahas ene kunum dilag ke daren te méktu marnig?” ");
INSERT INTO fad_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(5,000 danah keke qere qewa deg.) Yesus nug bégur amlagwa anan, “Ag danahas amlagwa anweg, qaglak ameg 50, 50 qere qagleksi des.” ");
INSERT INTO fad_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesus nug anan sillah, bégur né nusig dimlamdeksi anweg danahas kunum ninapiŕessi deg. ");
INSERT INTO fad_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yesus beret tanig ole am kaké aŕit qe ole oko saw karan amnelle kena sam elle keri unuqoran. Malako ge, temelle bégur danahas agop panilagri maran. ");
INSERT INTO fad_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Géri danahas kunum ke léksi olag oŕwew ge, ke big big minareg qe Yesus Bégur diareksi kaleg 12 qere yanareg. ");
INSERT INTO fad_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Deŕ os Yesus bégur ole dessi am nug nugé kepaŕko unuqorewew, am bégur gumdeksi doweg koŕmaran. “Danahas dasil ge oun éksi ansi?” ");
INSERT INTO fad_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nug bégur aneg, “Os ge Le Luarak danah Yon éksi ansi. Am os ge Elaisa éksi anirsi. Am la os ge profet os algunah mousan qe buliko siran éksi ansi.” ");
INSERT INTO fad_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Anweg ge, Yesus bégur koŕmaran, “Gam ag ge dasil oun éksi ansi?” Pita anan, “Na Tiwurdi Kristus, Tiwur danahas nusgur bulika diardipri toqiran.” ");
INSERT INTO fad_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Géri né qe danah os amegwa anwegri Yesus bégur gun qaran. ");
INSERT INTO fad_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Am Yesus amlagwa anan, “Meŕenah, danah Bega geisah gurak kuŕum morlag. Kuri danah am pris dilag anqak danah ole am Mosesri Ŕo duak danah ole geisah nug dimoreksi, am qeweg mousdig. Gam deŕ kiamba ge buliko sirdig.” ");
INSERT INTO fad_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Anko ge, buliko danahas kunum anaran, “Danah os da dimlamiŕdigri dew ge, nug nugégé nusig sak am o mourak ole qe dimorko, am ker mawanak nusig deŕ dorog mouko ge da dimlamŕar. ");
INSERT INTO fad_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Danah os nug nugégé nusig sak am o mourak ole dimlamurko ge, nug foumak ospi ow. Gam danah os nug da dimlamŕelle mousko ge, foumak oko sansan darig. ");
INSERT INTO fad_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Am danah nug wan kénih ole delle mousew ge, keke qe ospinah kéhnurweg. ");
INSERT INTO fad_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Am danah os dasil am né dasildi uŕa new pe, sén Danah Bega nug nusig kamsahlak gun olewa am Memegriwa am Tiwurdi doup gun dilagwa uŕirig ge, danah qeri uŕa nérig. ");
INSERT INTO fad_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Da ag amlagwa meŕenah anina. Danah os ewa aséw dasi ge, geisah ag pi mousak, Tiwur king delle danahas nusgur gumarewew pelag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesus né qe anko malwew, deŕ 8 keke qere atew ge, nug unuqurdigri Pita, Yon am Yems ole diarew qoukuwa teg. ");
INSERT INTO fad_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Nug unuqorelle dewew ge, nug kitŕu ge buliko sonŕewew am nug féŕu bala qe ole ampiŕ sillah sonŕan. ");
INSERT INTO fad_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Usihri danah aŕit Moses Elaisa ole kamsahlak gun olewa dowes nug ole né marieg. ");
INSERT INTO fad_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yesus nug wagam kawa Tiwurdi Né dimlamurko olele morko Yerusalem mousdigri danah aŕit qe ole marieg. ");
INSERT INTO fad_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita leikuŕ aŕit qe ole amlag kug morew nilag seg. Gam sén amlag fou mew ge, danah aŕit qe am Yesus ole aseksi kamsahlak gun ole qe owa deppeg piareg. ");
INSERT INTO fad_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Danah aŕit qe Yesus mundeksa ateppes, Pita Yesus amegwa anan. “Danah naŕi, ig ewa dalom ge kena. Ig laklak kiam os sénig, os nasip am os Mosesri, am os Elaisari.” (Pita nug o pi mourak né qe anan.) ");
INSERT INTO fad_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nug né qe anewew ge, fur os doko tonarew owa dessi olag faŕan. ");
INSERT INTO fad_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tiwur fur owa anan, “Ene nir dasilnah. Da nug algu toqurin. Ag nug fag duessi dimlamdes.” ");
INSERT INTO fad_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tiwur né qe anko malwew ge, ag Yesus nugé dewew peg. Am bégur ag sén qe keke peg qeri né ospi marieg, asilag dahmakwa ih dian. ");
INSERT INTO fad_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Deŕ qe dimba ge, Yesus am bégur kiam qe ole qoukuwari noppeg, danahas ameg naŕi uŕiyeksi Yesus ihwa peg. ");
INSERT INTO fad_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Am danah os danahas ameg naŕi qe olagwa uŕwan, “Duak marak danah, na da nal ene peripri nuqrina. Da nir danah usihnah enan ih. ");
INSERT INTO fad_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Koulli nou os nir qe owa now ge, gelelle ole usihri atko kauŕko kawqelle sihŕu newew nie. Koulli nou qe nir ofeŕ ospi paŕwe, am féŕu sew nounah me. ");
INSERT INTO fad_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Da na begpar koulli nou ene geŕurlagri nuqarin, gam ag sakri olele kawa.” ");
INSERT INTO fad_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Géri Yesus anan, “Danahas geiri, ag olag meŕe mak ole kawa am olag ge mangu kawa. Sén gane da ag ole dettu olag meŕe mérigri amlag méril?” elle ge anan, “Nir nasip oka ere do,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nir nag qe Yesus gumurko dowew ge, koulli nou qe touŕew atko wanwa qeko kawqelle nian. Géri Yesus koulli nou qe nir qe paŕorigri gaŕa morko geŕdan. Geŕurko nir qe sew kena mew ge, buliko memeg moran. ");
INSERT INTO fad_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Géri danahas kunum Tiwurdi gagragsak qe peksi dorlag nan. Danahas qe Yesus keŕ keŕ kunum san qe peksi dorlag new seppeg, nug bégur anaran. ");
INSERT INTO fad_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Né andil seina, ene dossi koutores! Danah os Danah Bega kegeŕ ewlagwa mérig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Gam bégur ag né qe olag pi mouran. Tiwur sew né digu qe larian, qeri ag olag ospi mouran. Am ag Yesus né qeri koŕmorakri faŕeg. ");
INSERT INTO fad_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesus bégur ag koŕlagwa ih oun nug naŕi asilag qeri kareg. ");
INSERT INTO fad_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesus dahmak asilag qe doko ge, nir nag os oko doko nug dianwa man. ");
INSERT INTO fad_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Meko ge, nug amlagwa anan. “Oun os nug da wénilwa nir nag ene sillah oko dahmore ge, nug da dahmiŕe. Keŕdi nug dasil o meŕe me qeri qere se. Am oun nug da wiŕe ge, nug Tiwur da anew uŕiyin qe o. Géri oun ag kallolagwa de qe, nug naŕi.” ");
INSERT INTO fad_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yon anan, “Danah naŕi, ig danah os na wénimba koulli nou geŕarew pektu anurhut minan. Keŕdi nug ig ole pi weitu.” ");
INSERT INTO fad_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Gam Yesus anaran, “Ag nug aw dagorweg. Oun nug ag kegeŕ pi mare ge, nug ag leilag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesus wan minko saw kappa attigri sén durmurew ge, Yesus o kunum morko ole Yerusalem attigri atan. ");
INSERT INTO fad_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Am nug danah os meŕarew anqeksi kaw os Samaria qewa keke dalagri am ke lelagri qe kunum bawarlagri ateg. ");
INSERT INTO fad_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Gam danah kaw qewari ag dueg ge nug Yerusalem attigri atan qeri Yesus uksi loulagwa atakri mineg. ");
INSERT INTO fad_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesus békuŕ Yems Yon ole, a né qe dueksa anes. “Naŕinah, na ot niew pe, i kew saw karandi anhuŕ aŕelle neko danah uni aŕardig!” eksa anes. ");
INSERT INTO fad_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Gam Yesus buliko aŕit qe gaŕa matan. ");
INSERT INTO fad_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Qe dimba ge, Yesus bégur ole kaw lawa ateg. ");
INSERT INTO fad_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ag ihwa ateksi ge, danah os Yesusri anan, “Na arewa attip ge, da na dimlamirwi ole atnit.” ");
INSERT INTO fad_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesus danah qe koŕewa oko anan, “Qé déguŕ ag wan oŕewa nisi am é ag teŕlag ole. Gam Danah Bega nug ge niakri lo ole kawa.” ");
INSERT INTO fad_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nug danah la os amegwa anan, “Na doka da dimlamiŕ,” eko anan. Gam danah qe anan, “Naŕinah, na minwe tatam ge da atko mem mousan suhumko am dimlamirdil,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesus danah qe amegwa anan, “Danah mousak qe minwe agé agé mousak leilgar qe suhmares. Gam na atka Tiwurdi Kingdomri Né kusu.” ");
INSERT INTO fad_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Am danah la os Yesusri anan, “Naŕinah, da na dimlamirdil. Gam tatam na minwe da louw atwi ke séktu léktu ewlag oŕako am na dimlamirdil.” ");
INSERT INTO fad_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Gam Yesus danah qe anoran, “Danah palangis digumeko toŕelle am sansan nug buliko dimugwa amne ole qe, nug Tiwurdi Kingdom owa kekuakri olele kawa,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Dimba ge, Naŕinah nug Bégur 12 qe am danah la os ole kepŕarko 72 danah qere anew awen are nug attigri ole qe kunumba aŕit aŕit nug noh uksi anqeksi ateg. ");
INSERT INTO fad_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nug ere eko anaran, “Ke lep kuŕum nie, gam ke lep qe tuqakri kuak danah kuŕum kawa. Qeri ag dar memegri unuqorweg nug sew kekuak danah la os ateksi dar nusigwa ke lep tuqlag. ");
INSERT INTO fad_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ag ates! Da séwi ag sipsip nagur sillah qé déguŕ olagwa atsi. ");
INSERT INTO fad_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ag asilag qarég yanakri sogot am keke yanakri baram aw oweg, am félag gaŕa la os ole aw diarweg. Am ag ihagwa danahas piareksi ge, aw félag yeksi né marweg. ");
INSERT INTO fad_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ag danah os diarko lougwa now ge, ere tatam anares, ‘Tiwur o maror ag ole dalag.’ ");
INSERT INTO fad_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Am lo qe memeg o kenawa diarew pe, Tiwurdi kena sak lo qewa darig. Gam pi diarew pe, Tiwurdi kena sak lo qewa pi dew buliko agrowa durig. ");
INSERT INTO fad_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ag lo qewa ih deppeg keŕ marlag ge, lessi des. Keŕdi kekuak danah nug kekuak nusig qe noh urig olele. Ag lo oswari am oswa aw weiweg. ");
INSERT INTO fad_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ag taun oswa noweg, felqareksi diareksi am keŕ ke bawresi marlag ge, ag les. ");
INSERT INTO fad_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Waŕe danah os taun qewa dalag ge, ag seweg waŕe pasaorar. Am ag Tiwurdi Kingdom agrowa uŕiyé unaka de qe anweg dues. ");
INSERT INTO fad_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Gam ag taun oswa noweg fel pi qarweg ge, taun qeri ihwa aseksi dessi anes. ");
INSERT INTO fad_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ig fénigwa usuŕ asilag taunwari de, qe ag pelagri qeqalhut ne. Gam ag dahméksi koutores: Tiwur danahas nusgur dilag king delle gumardigri sén unaka de.’ ");
INSERT INTO fad_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Da ag amlagwa anina, Tiwurdi uhŕibak deŕwa geisah Tiwur Sodom kaw kug moran qe eŕdak ag kug naŕi pelag. ");
INSERT INTO fad_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Korasin am Betsaida ole ag olag duak! Ag geisah kug naŕi pelag. Keŕdi da mirakel os agnéwa sein qe Tair Saidon ole selem ben, ag algu olag bulilo. Ag asilag hipunin qeri nouni dueksi neko aqarew am usuŕ luessi dessi olag bulilo. ");
INSERT INTO fad_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Gam Tiwurdi uhŕibak deŕwa Tair Saidon ole kug olas qe eŕdak ge ag olag. ");
INSERT INTO fad_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Am Kapernaum, ag te os Tiwur ag binlag karan sumdig? Kawa. Ag ole Tiwur touŕarew nuksi paral melag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Am Yesus buliko anaran, “Oun os nug asilag né dorig ge, nug dasil né due. Am oun os nug ag dimardig ge, nug da dimiŕe. Gam danah da dimiŕe ge, nug Tiwur anew da uŕiyin qe dimore,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","72 danah qe bulieksi uŕiyeksi olag gamag asakwa aneg. “Naŕinah, ig na wénimba anektu, koulli nou geŕarhut né dueksi ateg.” ");
INSERT INTO fad_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Géri Yesus koŕlagwa oko anaran, “Da Satan saw karandi ampiŕ sillah usihri tolwewew pégin. ");
INSERT INTO fad_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ag dues. Da ag mat am kappiép ole qaŕlagwa tapeksi oŕollarlagri gagragsak marin. Am kegeŕ asilagri gagragsak kunum qe seweg kéwsi kawa mérigri gagragsak marin. Qeri ag kité ospi sarew nou meweg. ");
INSERT INTO fad_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Gam koulli nou ag koŕlag dimlamdeg qeri ag aw olag gamag asew. Ag Tiwur saw kappa iŕil wenlag yan qeri olag gamag asar.” ");
INSERT INTO fad_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sén qewa Koulli Gun nug sew Yesus o gamag asew anan, “Mem, na wan saw oleri Naŕinah. Da binam sumina. Keŕdi na keke ene duak danah dowegri sewe larian, gam danah nir nounu sillah ge ismaren. Meŕenah, Mem na ere séripri ot nian ole qe sen. ");
INSERT INTO fad_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Mem gagragsak am keke kunum ole da ewelwa man. Tiwur Bega ge oun qe ounté ospi due, gam Mem ih due. Am Mem ge oun qe ounté ospi due, gam Bega ge due. Am danah are da kepŕarko ismarin qe ag ole Mem dossi.” ");
INSERT INTO fad_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Géri Yesus buliko bégur ih dolagri anan, “Danah keke ag pesi ole qe pesi, qe ag olag gamag asdig. ");
INSERT INTO fad_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Da ere anarina keŕdi ge, algu profet am king kuŕum ole keke ag gei pesi ole qe pelagri seg, gam ag pi peg. Am né ag gei dossi ole qe dolagri seg, gam ag ospi dueg,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Deŕ os Ŕo duak danah os asko Yesus sew perigri seko koŕmoran. “Duak marak danah, da areg seko ge foumak sansan diakri uril?” ");
INSERT INTO fad_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Géri Yesus koŕewa oko anan, “Mosesri Ŕo yakwa keŕ eko ane? Na dona ge areg?” ");
INSERT INTO fad_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Géri danah qe anan, “Ŕo ane: Naŕinah nasip Tiwurdi ot mousew, ot kunum ole, kitton ole, gagragsak nasip kunum ole am dahmak nasip kunum ole Tiwur mor. Am na nagégé nasip ot mouse qe sillah liapri ole qere ot mousar.” ");
INSERT INTO fad_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Géri Yesus danah qe koŕewa oko anan, “Na meŕe anam. Na qere seka ge, foumak owe Tiwur ole sansan dalas,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Gam danah qe nug da mangu elle qeri Yesus koŕmoran. “Am oun ge da lial?” eko koŕmoran. ");
INSERT INTO fad_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Am Yesus amegwa anan, “Danah os Yerusalemri noko Yeriko atewew, yawsen danah ihwa oŕweksi féŕu balla nusig kunum uŕdeksi keke nusig kunum kaŕdeksi, mouŕaweg ameg taŕiew niewew ateg. ");
INSERT INTO fad_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Niewew ge, pris danah os ih qe dimlamurko noko nug danah qe peko ge, ih séku leis wanko nanŕurko atan. ");
INSERT INTO fad_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Qe sillah, Liwai danah os ole qere noko peko, nug ole ih leis wanko nanŕurko atan. ");
INSERT INTO fad_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Gam Samaria danah os ih unari uŕiko danah qe nianwa doko qere peko ge, o duan. ");
INSERT INTO fad_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","O dow ge, nug danah qe gumurko wanko isiwa goŕen am wain ole gogŕew now isi witan. Malako ge, danah qe sumew donki nusigwa tew oko ŕo lo oswa atko qewa meko guman. ");
INSERT INTO fad_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kuagŕew ge, qarég silwa aŕit ipko ŕo lo gumak danah qe morko anan. ‘Na danah ene dahmoreppe da buliko uŕiko ge na qarég gane tourdip qe noh méril,’ eko anan.” ");
INSERT INTO fad_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Am Yesus Ŕo duak danah qe koŕmoran, “Danah kiam ene na dona ge danah are ge yawsen danah mouŕweg ole qe lia?” eko koŕmoran. ");
INSERT INTO fad_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Koŕmorew ge, nug koŕewa oko anan, “Danah o dow kéhnuran ole qe.” Géri Yesus danah qe anoran, “Na ole atka qere ih se,” eko anoran. ");
INSERT INTO fad_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yesus bégur ole Yerusalem atlagri atessi kaw oswa waneg. Yesus kaw qewari as os wénih Mata qe lougwa atew, Mata felqoran. ");
INSERT INTO fad_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nug mageg os wénih Maria, qe Naŕinah fégwa delle né marian qe duelle dian. ");
INSERT INTO fad_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Gam Mata ge ke bawrakri sik nou qan. Géri nug doko Yesusri anan, “Naŕinah, da magel ene minŕew kekuak dagé seina, qe na areg dona? Na anwe nug ole da kéhniŕar,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Gam Naŕinah anoran, “O Mata, na keke kuŕumrinah ot sik qew ot nou me. ");
INSERT INTO fad_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Gam keke usihri qe na kutuk. Qeri Maria nug keke kenanah kepaŕko se. Am ounté os nug keke kepré qe pi kaŕdew,” eko anoran. ");
INSERT INTO fad_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Deŕ os Yesus awen oswa unuqoran. Sén nug unuqorko malwew ge, nug bega os anoran. “Naŕinah, Le Luarak danah Yon bégur unuqorakri ismaran sillah, ig ole ismig.” ");
INSERT INTO fad_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Géri Yesus anaran, “Sén ag unuqoressi ge, ere anes: ‘Ig Mémnig, na wéhnim gun ole karan sumnig. Na uŕika king denna danahas gumardip. ");
INSERT INTO fad_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Na ig deŕ dorog ke mig. ");
INSERT INTO fad_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ig ole oun nouni sige qe kusqektu dohut dounig katie qe sillah, hipunin isanig kusuqka mig. Am ig aw paŕwigwe qepiakwa tolahut.’ ” ");
INSERT INTO fad_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Am Yesus bégur dilag anan. “Olagwa usih os tuqan tugamag lia lougwa atko qaqurko koŕmurdig. ‘Lal, beret kiam os miŕdip olele te? ");
INSERT INTO fad_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Keŕdi da lial os weiko uŕiko loulwa dué. Gam da ke nug morakri ole kawa.’ ");
INSERT INTO fad_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Géri danah lo owa ge andig, ‘Na da aw kekuak miŕwen. Ihŕam iŕil maném, am da nir dahlar ole niak awenwa nitu. Da asko keke mirakri olele kawa.’ ");
INSERT INTO fad_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Da ag anarina. Nug lia qeri nug asko keke ospi morew. Gam nug pi faŕak koŕmurdig qeri nug asko keke qe murdig. ");
INSERT INTO fad_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Qeri da ag amlagwa anina. Ag koŕmeweg, Tiwur ag mardig. Mariweg ge, nug ismardig. Ag ihŕam qouqou orweg, nug ihŕam matuldig. ");
INSERT INTO fad_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Qeri oun os Tiwur koŕmurdig ge, nug urig. Oun os maririg ge, nug ismurew perig. Am oun os ihŕam qouqou orew ge, nug ihŕam matulko murdig. ");
INSERT INTO fad_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Oun os nug nir memeg ge, nir kaké murdigri koŕmew ge, mat nou os murdig te? ");
INSERT INTO fad_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Am maru owah murdigri koŕmew ge, kappiép os oko murdig te? ");
INSERT INTO fad_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Qeri hipunin danah ag ole nir keke kena marlagri qe dueksi koutursi. Am Mem saw kappari danah are koŕmési ge meŕenah Koulli Gun mew uŕirig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Deŕ os Yesus danah os koŕe kunum féŕuwa koulli nou qe sew koŕe kunum daré qe geŕdan. Geŕdew atew ge, danah qe né buliko mariew danahas peksi dorlag nan. ");
INSERT INTO fad_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Gam olagwa danah os ge aneg, “Nug koulli nou dilag kuri Belsebulri gagragsakwa koulli nou geŕare.” ");
INSERT INTO fad_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Am olagwa danah la os Yesus mirakel os sérigri koŕmoreg. Keŕdi ag nug meŕenah Tiwur dowari te uŕiyan qe pelagri koŕmoreg. ");
INSERT INTO fad_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Gam Yesus nug asilag dahmak qe doko ge, amlagwa anan. “Danah kaw usihwari ag kopatweg aŕit patew fan selag ge, geisah kaw qe paral mérig. Am danah os ag ateŕ usihwari ag kopatweg aŕit patew fan selag ge, geisah ateŕ qe kawa mérig. ");
INSERT INTO fad_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Am Satan leigur ole kopatweg aŕit patew fan selag ge, gagragsak nusig kawa mew ag paral melag. Ag ansi ge da Belsebulri gagragsakwa koulli nou geŕarina, qeri da ere anina. ");
INSERT INTO fad_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Da Belsebulri gagragsakwa koulli nou geŕarwi pe, asilgar danah ge oundi gagragsakwa koulli nou geŕarsi? Qeri asilgar danah ih qewa ismigsi ge ag darmési. ");
INSERT INTO fad_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gam da meŕe Tiwurdi gagragsakwa koulli nou geŕarwi pe, Tiwur danahas nusgur gamlagwa king delle gumardigri agrowa uŕiyan.” ");
INSERT INTO fad_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Am Yesus né tonak os anaran. “Danah os gagragsak ole nug fan sakri keke bawarko loug kaŕiah wite ge, keke nusig kunum kena dasi. ");
INSERT INTO fad_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Gam danah gagragnah os beko fan seko éŕurko ge, fan sakri keke kunum gagrag qore qe urig. Am nug keke kunum urig qe danah la agop panirig. ");
INSERT INTO fad_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Oun nug da lial kawa ge, nug dasil kegeŕ. Oun nug da pi kéhniŕew sipsip qaglarŕu ge, nug sipsip lamarew pihŕaursi,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yesus anaran, “Sén koulli nou danah os féŕuwari géŕurweg doko atko ge, atu meiŕakwa sik oko darigri awen mariko weiye. Am nug awen os pi peko ge, ane. ‘Da lo minko uŕiyin qewa buliko attil,’ eko ane. ");
INSERT INTO fad_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Géri nug buliko atko danah qe owa lo qe kinkak ekaŕko bawarko koutorak pe. ");
INSERT INTO fad_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Peko ge, nug atko am koulli nou la nug eŕdak nounah 7 qere diarew uŕiyeksi qewa dasi. Géri danah qe tatam dian qe éŕurko ole nounah me,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesus né qe anewew, as os danahas ameg naŕi qe olagwa uŕuko anoran, “As na mémnirko ouma mirelle begran ole qe nug o gamag ase.” ");
INSERT INTO fad_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Gam Yesus anan, “Danah areg Tiwurdi né dueksi dimlamursi ge, ag olag gamag asak naŕiwa dalag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sén danahas kuŕum qaglessi omorweg ge, Yesus anaran, “Danahas geiri ag olagwa sak nouninah ambak. Ag da mirakel séwi pelagri koŕmési. Gam da mirakel usih ospi séwi peweg. Ag profet Yona féŕuwa kowol nian qe sillah ih pelag. ");
INSERT INTO fad_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Niniwe danahas kowol Yona dowa ban qe peksi ge, Tiwur nug mew atan qe ag dueg. Qe sillah danahas geiri ag ole Danah Bega qere peksi ge ag dolag. ");
INSERT INTO fad_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Dimba Tiwurdi uhŕibak deŕwa kenariwari kuin sirko danahas geiri ole aseksi dessi asilag sak nou qe ambo marko ismarew pelag. Keŕdi kuin qe wan atko patakwari Solomonri duak kena qe dorigri uŕiyan. Gam ag olagwa danah os Solomon eŕdak ge ewa de, am ag nusig né duak minsi. ");
INSERT INTO fad_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Sén Tiwurdi uhŕibak deŕwa Niniwe danahas sireksi geiri danahas ole aseksi dessi geiri danahas dilag sak nou qe ambo melag. Keŕdi ag Yona né kuswew olag bulian. Gam gei ge danah os Yona eŕdak ge ewa de, am ag olag buliak minsi,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesus anan, “Danah os lam kamutko pi lariew, am wawa pi tone. Kawa, nug karan eisew nie. Géri danah lo owa nuksi ge, lam aŕe qe pesi. ");
INSERT INTO fad_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na amen ge na féŕundi lam sillah. Na amen kena dew ge, féŕun kunum ole kamsahlakwa darig. Gam na amen nou ge, féŕun kunum ole gattuwa darig. ");
INSERT INTO fad_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Qeri kamsahlak otwa de qe gattu tonewri na dahmeka koutor. ");
INSERT INTO fad_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Qeri na féŕun kunum kamsahlakwa darig am gattu nagur ospi féŕunwa darig ole ge, féŕun kunum kamsahlelle darig. Lam aŕko atko féŕunwa kamsahle qe sillah,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesus né mariko malwew ge, Farisi os nug lougwa atew ke lelasri anoran. Géri Yesus nug lougwa atko ninaqiŕko dian. ");
INSERT INTO fad_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisi qe Yesus eweg tatam pi isak ke lew peko ge, nug dorog nan. ");
INSERT INTO fad_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Géri Naŕinah anan, “Farisi, ag asilag kap am plet ole dimdim ih issi, gam ag olagwa ge ameg qak am kowol nounah ole ambak. ");
INSERT INTO fad_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ag né tapewnak danah! Tiwur féŕnig ih te kawian? Am onig owa ole pi te san? ");
INSERT INTO fad_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gam asilag kap am plet ole owa keŕ keŕ dassi qe o duak danah kehnaressi mares. Ag qere selag ge, Tiwur amegwa ag olag isak perig. ");
INSERT INTO fad_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Gam Farisi ag dahmes! Ag kug os pelag. Keŕdi ag danahas agop sak mangu ospi sési am Tiwurdi olag pi mouse. Ag qané, lombu am darari kes kowol kowol ge watiweg ameg 10 qere new ameg usih qe Tiwur mursi. Gam ag qere séssi am ole Tiwurdi olag mousewew am danahas agop sak mangu ses. ");
INSERT INTO fad_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisi ag dahmes! Ag kug os pelag. Keŕdi ag binag mak lowa danah wenlag ole dilag diak awen qewa ih dalagri séssi am ag qaglak awenwa felqareppeg ih weilagri olag naŕi de. ");
INSERT INTO fad_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ag dahmes! Ag kug os pelag. Keŕdi ag matmat bala pi kehak qe sillah, danahas pi duak qaŕewa tapeksi weisi,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ŕo duak danah os anan, “Duak marak danah, na Farisi dilag né anna qe, na sewe ig ole uŕnig ne.” ");
INSERT INTO fad_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Qeri Yesus né noh meko anan, “Ŕo duak danah, ag ole dahmes! Ag kug os pelag. Ag Ŕo kug ole danahas qaŕlagwa mési, géri ag mawakri kug aqare. Gam ag mawakri kehnareksi ewlag ospi marsi. ");
INSERT INTO fad_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ag dahmes! Ag kug os pelag. Keŕdi ag alalgar profet qe aqareg am ag profet dilag matmatwa bala kehareksi bawarsi. ");
INSERT INTO fad_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kowol asilag qewa danah ismarsi ge, ag alalgar algu profet aqareg qe kowol kena seg essi ag matmatwa bala keharsi. ");
INSERT INTO fad_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Qeri Tiwurdi duak kena qewa nug iŕil anan, ‘Da profet am aposel ole anwi atlag. Ag os ge nouni sarlag am gurak marlag. Am la os ge ag aqarweg mouslag.’ ");
INSERT INTO fad_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Qeri kug algu wan digumakwa profet aqareppeg uŕiyew gei patak qe noh danahas geiri ag olag. ");
INSERT INTO fad_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Algu Abel qakwari uŕiyew pris Sakaraia ge Tiwurdi doŕ manko morakri qaŕéw mourak am Tiwur Loug gamagwa ole qeg. Da meŕe anarina. Kug qe kunum noh qe danahas geiri ag olag. ");
INSERT INTO fad_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ŕo duak danah, ag dahmes! Ag kug os pelag. Keŕdi ag danahas Tiwur dowegri dagareg. Am ag agégé Tiwur duak mineksi ge danahas Tiwur dolagri seppeg ag dagareg,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Sén Yesus lo qe minko attig sew ge, Farisi am Ŕo duak danah ole uhŕilag bew, kegeŕ moreksi diguméksi gurgur koŕmoreg. ");
INSERT INTO fad_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ag Yesus né nouni os anew dueksi oŕalagri kaŕéordéw. ");
INSERT INTO fad_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sén qewa ih danahas kuŕumnah 1,000 eŕdak ag Yesus pelagri qagleksi agégé nug tapeksi seppeg, Yesus bégur dilag tatam anan. “Ag Farisi danah dilag yis qeri dahméksi koutores. Yis qe darmak gaŕlagwa ih Tiwur dimlamdak kowol. Qe sillah aw seweg. ");
INSERT INTO fad_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ag keŕ keŕ larieksi tonak nie ge Tiwur sew ambo melag. Am keŕ lariakwa sési qe ole sew kunum pelag am dolag. ");
INSERT INTO fad_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Qeri keŕ ag gattuwa lugmeksi agé marilag ge, dimba kémunwa danahas kunum dolag. Am keŕ kutiptip kurugwa marisi ge, dimba tamniakwa mariew kunum dolag.” ");
INSERT INTO fad_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Da leilar, ag anarina. Ag danah feŕlag qelag seweg qeri aw faŕarweg. Keŕdi ag dimba kité la os pi seweg. ");
INSERT INTO fad_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Gam da ag oun faŕurlagri qe anwi dolag. Ag Tiwur ih faŕdes. Nug ge koulli kaŕwarew mouslagri am ole dimba touŕarew kew pi qouse olewa nolagri gagragsak ole. Meŕenah, da buliko anarina, ag Tiwur ih faŕdes. ");
INSERT INTO fad_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Ag dossi, danah ag é reis anig tanig ole qarég nagurnah usihwa irar mési. Gam Tiwur nug reis anig usih ospi doug katie. ");
INSERT INTO fad_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Am meŕenah Tiwur ag kurlag uŕug kunum ge gane qe nug due. Qeri ag aw faŕweg. Am nug asilag o nie ge, é nounou kuŕum dilag dahme qe eŕdak.” ");
INSERT INTO fad_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Da ag anarina. Oun os nug danahas amlagwa nug da dimlamŕeri andig ge, Danah Bega Da ole geisah Tiwurdi doup amlagwa nug danah dasil eko andil. ");
INSERT INTO fad_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Gam ounté os danahas amlagwa nug da dimiŕew ge, da ole geisah Tiwurdi doup amlagwa nug danah dasil kawa eko andil. ");
INSERT INTO fad_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Danah oun os pi duak Danah Begari nouni andig ge, Tiwur hipunin nusig kusuqrig. Gam oun os nug duelle Koulli Gun oko oko qurdig ge, Tiwur hipunin nusig qe ospi kusqew. ");
INSERT INTO fad_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Ag da dimlamiŕsi qeri danah os ag oŕwareksi diareksi Yuda dilag binag mak lowa am kuri danah wagé wagé am danah kuakri wittak marak ole qe nolagwa atweg ge, keŕ né am areg anlagri aw dahmak kuŕum oweg. ");
INSERT INTO fad_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Keŕdi ag keŕ éksi anlagri ge sén qewa Koulli Gun ag ismardig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Danah usih os danahas ameg naŕi qe olagwa nug Yesus amegwa anan, “Duak marak danah, na da awal amegwa anwe nug keke i memnitdi ge wasaŕko dasil sillah qe miŕar.” ");
INSERT INTO fad_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Gam Yesus né qe noh meko anan, “Lal, oun da asilas ken watiko mattildi kepŕak danah toqiŕan?” ");
INSERT INTO fad_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Elle ge nug kunum amlagwa anan, “Ag dahméksi koutores! Ag keke kunumdi aw amlag qew. Danah kénih naŕi ole ge, kénih qe sew nug kena ospi dew.” ");
INSERT INTO fad_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Am Yesus nug né tonak usih os amlagwa anan, “Danah kéhu ole os dar seko ke kehew mou kuŕumnah nian. ");
INSERT INTO fad_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Qewa ge, nug nugégé dahman, ‘Da ke ene oko mew diakri awen olele kawa. Qeri da aregnah séril?’ ");
INSERT INTO fad_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Am nug anan, ‘Da ere séril. Geisah da ke makri lo kunum logŕarko am lo wagé wagé fuarko ge, ke kunum am keke dahlar kunum ole qewa mardil. ");
INSERT INTO fad_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Am da dagégé dasil ere andil, da ke am keke la kunum qe makaŕ kuŕum uŕwildigri olele qaglin. Aria, da sam delle ke lelle am ke naŕi selle gamal asakwa daril.’ ");
INSERT INTO fad_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Gam Tiwur nug amegwa anan, ‘Na né tapewnak danah! Gei tuqan ewa na mousdip. Am keke kunum bawren de ene ge geisah oun memeg mérig?’ ");
INSERT INTO fad_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Géri danah keke kuŕumnah wan ewari nugé nusig qagle ole qe dowa qere bérig, gam Tiwur nohwa ge nug keke kawa,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesus bégur dilag anan, “Qeri da ag amlagwa anina. Ag wan enewa fou diakri aw dahmak kuŕum oweg. Ag ke lessi fou dalagri am feŕlag balari ole dahmak kuŕum aw oweg. ");
INSERT INTO fad_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ag fou dasi qe ke eŕdak am ag feŕlag qe feŕlagri bala qe eŕdak. ");
INSERT INTO fad_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ag kalog dilag dahmes. Ag ke pi kéhsi am ke uksi qagleksi louw pi mési, gam Tiwur ke mare. Tiwur é dahmare qe eŕdak ge ag dahmare. ");
INSERT INTO fad_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ounté os olagwa dahmak kuŕum ow fou darigri sén deŕ usih yako terigri olele té? ");
INSERT INTO fad_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Géri ag keke nagur usih os sakri olele kawa ge, keŕdi ag dahmak kuŕumnah keke lari usi? ");
INSERT INTO fad_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ag bala areg besi qe dahmores. Ag teret pi sési am lamen asilag pi sési. Gam da anarina. Bala qe asilag amnak ge king Solomon féŕu bala kenanah qe eŕdak. ");
INSERT INTO fad_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gisgaŕ nug gei de am keŕew ih danah kotaŕko kewba touŕew aŕdig. Gisgaŕ sam qe Tiwur nug bala mare. Qeri Tiwur ag gumardig qe gisgaŕ gumare eŕdak gumardig. Ag danahas olag meŕe mak kutuk ole! ");
INSERT INTO fad_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Qeri ag keŕ ke am le ole lelagri aw dahmak kuŕum oweg. ");
INSERT INTO fad_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Wan ewa danah Tiwur pi dosi ole ag keke qeri marieksi sik aqare. Gam ag ge, Memlag Tiwur ag keke qeri olag nie qe nug iŕil doko malwe. ");
INSERT INTO fad_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Qeri ag Tiwurdi Kingdom meweg anqew dimlamurweg ge, nug keke qe ole mardig.” ");
INSERT INTO fad_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ag da beglar kuŕum kawa, gam ag aw faŕweg. Ag Memlag Tiwur nug o gamag asakwa Kingdom nusig mardig. ");
INSERT INTO fad_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ag keke asilgar daren marweg qarég uksi o duak danah mares. Qe ge saw kappa keke kena asilag qe qaglak darig. Am qarég yanakri sogot saw kappari ge oŕe ole kawa. Asilag keke kena qe ospi kawa mew qe darig, yawsen danah ospi yawsen oweg am diruŕ ospi seweg nou mew. ");
INSERT INTO fad_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Asilag keke kenanah arewa de qewa ih ag olag am dahmak asilag kunum ole qewa darig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Yesus anaran, “Ag lamen asilag kutuk mappieksi tageksi am lam kamutweg aŕewew bawressi des. ");
INSERT INTO fad_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ag kuak nir dilag danah naŕi danah as wakri mallenwa uŕirigri ameg méksi dasi qe sillah bawressi des. Géri sén nug uŕiko ihŕam qouqou orew ge, usihri ihŕam nusig matleksi morlag. ");
INSERT INTO fad_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kekuak nir are ag danah naŕi asilag uŕirigri bawreksi us aw niweg ameg méksi deppeg buliko uŕiko piarew ge, ag olag gamag asdig. Da meŕe anarina. Nug nugégé lamen tagko sew ag daweg ke bawarko mardig. ");
INSERT INTO fad_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Nug tuqan tugamag té kuagaŕdigri maru gelleppeg té uŕiko kuak nir ameg méksi deppeg piarew ge, ag olag gamag asdig. ");
INSERT INTO fad_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Am ag né dasil oŕwes: Lo memeg os yawsen danah nug lougwa uŕirigri sén qe iŕil duewew ge, yawsen danah qe loug ospi logaŕko owa now. ");
INSERT INTO fad_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Qe sillah, ag ole sansan bawressi des. Keŕdi ag Danah Bega da keŕ sénwa buliko uŕiril qe ag pi dosi,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesus né qe anko malwew ge, Pita koŕmoran. “Naŕinah, na ig amnigwa ih te né tonak ene marina, kawa danahas kunum ole amlagwa te marina?” ");
INSERT INTO fad_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Naŕinah koŕewa oko anan, “Oun ge kekuak nir kena duak kena ole qe danah naŕi nusig nug toqorew kuak nir la qe gumarelle ke marak sénwa ke wasaŕko mardig? ");
INSERT INTO fad_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dimba danah naŕi nusig qe buliko uŕiko am kuak nir qe kekuak mangu ih sewew perig ge, kuak nir qe nug o gamag asdig. ");
INSERT INTO fad_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Meŕenah anarina, danah naŕi qe geisah sew kuak nir qe keke nusgur kunum ole gumardig. ");
INSERT INTO fad_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gam kuak nir os ere dahmelo, ‘Danah naŕi dasil ofeŕ ospi buliko uŕiyew,’ elle nug kuak nir am kuak as la qe digumeko mouŕwarko ke naŕi seko lelle am le gagrag qe leko gar qelo. ");
INSERT INTO fad_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Danah naŕi qe deŕ kuak nir qe pi dahmurdig ole qewa am sén os nug pi dorigwa uŕiko kuak nir qere peko ge, nug kotŕew new danah olag meŕe pi me dalag awen qewa touŕew nurig. ");
INSERT INTO fad_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kuak nir nug danah naŕi nusig keŕdi o nie qe duelle pi bawarko dimlamdew pe, danah naŕi nusig sew nouninah qelag. ");
INSERT INTO fad_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gam kuak nir nug danah naŕi nusig keŕdi o nie qe pi duelle nouni sew pe, danah naŕi nusig naŕi pi qew. Tiwur danah are ag naŕi mare ge, ag naŕi morlag. Am danahas are ag keke naŕi gumlagri mare ge, nug ag naŕi bulieksi morlagri koŕmardig.” ");
INSERT INTO fad_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Da wan ewa kew méril uŕiyin, am da ol se ge kew qe iŕil digumeko aŕan. ");
INSERT INTO fad_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Am da le lourak oswa nuril. Qeri da kug naŕi iwŕewew atew sén qe durig. ");
INSERT INTO fad_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ag dahmési ge diak kena te darigri wan ewa uŕiyin? Kawa. Da anarina, da danahas olagwa koptak bérigri uŕiyin. ");
INSERT INTO fad_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Gei digumak lo usihwa danahas tanig ole qe watieksi, kiam ge aŕit dilas olag usih ospi dew am aŕit ge kiam qe dilag olas usih ospi dew. ");
INSERT INTO fad_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ag watieksi memeg nug nag ole olas usih ospi dew am nag nug memeg ole olas usih ospi dew. Anig ge aŕeg ole olas usih ospi dew am aŕeg nug anig ole olas usih ospi dew. Am anig nug aswa ole olas usih ospi dew am aswa nug anig ole olas usih ospi dew,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesus danahas kuŕum amlagwa anan, “Ag fur kem nuakwa qaglew peksi ge, ofeŕ ole ansi. ‘Gu nérigri se.’ Am qe meŕe, gu ne. ");
INSERT INTO fad_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Am sén ag ulas kenariwa yalew ge, ag ansi. ‘Geisah kem gagaŕdig.’ Am qe meŕe kem gagŕe. ");
INSERT INTO fad_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ag darmak gaŕlagwa ih Tiwur dimlamdak danah! Ag wanwa am saw karan sén kitŕu peko anakri ge dosi koutursi. Gam keŕdi ag gei sén ewa keŕ keŕ beko ate qe peksi digu olag ospi moure? ");
INSERT INTO fad_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Keŕdi ag agégé kowol mangu ih sakri ospi kepŕeksi dimlamursi? ");
INSERT INTO fad_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Na danah os na kitéri yagoŕ mirew pe, kugri né kepŕak lowa pi wanak ih umuwa né qe bawreksa olas usih melasri mena pe. Kawa ge, nug na kepŕak danah dowa wirko wanew ŕo danah ewlagwa meirew kalabuswa yanirlag. ");
INSERT INTO fad_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Da na anirina. Na kug noh qarég makri anak qe kunum mewe atew am nagurnah ospi meka malarip ge, na kalabuswari dimdim ospi dowen,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Danah os Yesus ole sén qewa dessi Yesus anoreg. Galili danah os doŕ manko Tiwur morak qe seppeg, Pailot anew aqarweg mousweg karlag noko doŕ karag qe ole kawlian. ");
INSERT INTO fad_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesus anan, “Ag dosi ge, Galili danah mouseg ole qe hipunin asilag ge Galili danah la kunum dilag hipunin qe eŕdak nouninah, qeri te ag kug qe og? ");
INSERT INTO fad_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kawa! Da ag anarina, ag olag pi buliew pe, ag ole qere ih paral melag. ");
INSERT INTO fad_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Am danah 18 qere Siloam lo welah naŕi karan uwa qiko aqarew mouseg qe, ag dosi ge, ag qe Yerusalem danahas la eŕareksi hipunin nouninah te seg? ");
INSERT INTO fad_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kawanah! Da anarina, ag olag buliar. Kawa ge, ag ole qere ih paral melag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Am Yesus né tonak ene amlagwa marian. “Danah os wain dar nusig owa guŕaw ker os kehew dian. Géri dimba ge, guŕaw qe mou niew perigri atan, gam mou usihnah ospi niew pian. ");
INSERT INTO fad_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Géri nug dar gumak danah nusig qe anoran, ‘Da makaŕ kiam qere guŕaw ene mou niew perildi sén kuŕum uŕirém, gam mou usih ospi niew pégin. Qeri na kowe qiar. Keŕdi nug awen oko delle wan kirag pi malwew.’ ");
INSERT INTO fad_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Gam dar gumak danah qe koŕewa oko anan, ‘Danah naŕi, minwe makaŕ usih la os ole dew. Am da diguwa wan kapatko mol morelle am kinkak ole diguwa méril. ");
INSERT INTO fad_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Makaŕ os uwa mou niew pe, qe kena. Gam mou ospi niew pe, kuwi qirig,’ ” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Sabat deŕwa Yesus Yuda dilag binag mak lowa danahas Tiwurdi Néri duak maran. ");
INSERT INTO fad_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Am as os qewa dian ge koulli nou sew nug makaŕ 18 qere gumi tupiak, géri nug gumi mangu morakri olele kawa daré. ");
INSERT INTO fad_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Sén Yesus as qe peko ge, uŕwurew dow anoran, “As, da waŕe nasip séwi pasaoré.” ");
INSERT INTO fad_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Yesus qere anelle eweg as qe gumiwa mew, usihri asko mangu delle Tiwur binag suman. ");
INSERT INTO fad_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesus Sabatwa as qe sew kena man, qeri kuri danah Yuda dilag binag mak lori qe Yesusri uhŕibew danahas dilag anan, “Ag kekuak deŕ la qewa ge uŕiyeksi anweg waŕe asilag sew pasaorar, gam Sabat deŕwa uŕiyeksi ge ag aw anweg waŕe asilag sew pasaorew,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Géri Naŕinah kuri danah qe anoran, “Ag darmak gaŕlagwa ih Tiwur dimlamdak danah! Ag Sabat deŕwa makau am donki ole asilgar le marlagri pi te kusqareksi diareksi atsi? ");
INSERT INTO fad_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Qeri as Abraham fuŕuh ene Satan waŕewa dagorew makaŕ 18 qere dian. Nug Sabatwa kusqak murdil ge nouni te?” ");
INSERT INTO fad_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Sén Yesus qere anew ge, danah nug kegeŕ moreg qe ag uŕlag nan. Gam danahas ge nug kuak kunum kenanah san qeri olag gamag asan. ");
INSERT INTO fad_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Géri Yesus anaran, “Tiwurdi Kingdom ge kité sillah? Da qe kité sillah eko andil? ");
INSERT INTO fad_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Qe ker os wénih mastet ég sillah qe danah os oko dar nusigwa kehan. Ker qe beko naŕi mew ewegwa é kuŕum uŕiyeksi sik uksi dasi,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Am nug buliko anaran, “Da Tiwurdi Kingdom ge kité sillahnah eko andil? ");
INSERT INTO fad_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Qe yis sillah. As os yis oko palawa naŕiwa gogrew now kawlian. Yis qe sew palawa titiŕko naŕi me qe sillah,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesus Yerusalem attigri atelle taun am kaw eŕaran ole qe danahas doulag patelle atan. ");
INSERT INTO fad_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Danah os koŕmoran, “Naŕinah, danah usih usih te foumak uksi sansan dalag?” Qere anew ge, Yesus anaran. ");
INSERT INTO fad_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ag ihŕam nagur qewa nolagri gagrag mes. Da anarina, danahas kuŕum ihŕam qewa nolagri selag, gam ospi noweg. ");
INSERT INTO fad_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Sén lo memeg asko ihŕam manew ge, ag dimdim aseksi dessi ihŕam qouqou oressi anlag, ‘Danah naŕi, ihŕam matulwe ig ole not,’ éksi anlag. Gam nug koŕlagwa oko andig, ‘Da ag pi duarina am ag arewari uŕiyéw.’ ");
INSERT INTO fad_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Qere anew ge, ag anlag, ‘Ig na ole ke am le ole let am na ig kawnigwa dounig paten ole qe,’ éksi anlag. ");
INSERT INTO fad_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Gam nug koŕlagwa oko andig, ‘Da ag pi duarina am ag arewari uŕiyéw. Ag kunum kowol nou sak danah, ag uwa wanes! ");
INSERT INTO fad_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Sén qewa ge Abraham, Aisak, Yakop am profet kunum saw kappa deppeg piarlag. Gam ag ge minarak dimdim dessi, qeri olag nou mew kuanessi élag gaŕmessi dalag. ");
INSERT INTO fad_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Geisah danahas kem bakwari, kem nuakwari, kenariwari am nanettiwari am wan atu kunumbari ole uŕiyeksi awen asilag uksi saw kappa mallen naŕi qewa dalag. ");
INSERT INTO fad_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Meŕenah, danahas gei ag wenlag kawa dasi ge Tiwurdi Kingdom owa ag wenlag ole dalag. Am danahas gei ag wenlag ole dasi ge ag wenlag kawa dalag,’ ” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Sén qewa ih Farisi os duksi Yesusri aneg, “Na awen ene minka awen oswa eit, keŕdi king Herod Antipas na iwirdigri se.” ");
INSERT INTO fad_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Géri nug koŕlagwa oko anan, “Ag ateksi qé déguŕ qe ere anores, ‘Da gei keŕew ole am atak ge danahas feŕlagwa koulli nou geŕardil am waŕe danah séwi waŕe pasaorlag. Am sén dasil uŕiyew ge kekuak dasil malaril.’ ");
INSERT INTO fad_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Areg darig ge da gei, keŕew, am éŕul attil. Keŕdi Tiwurdi profet ge Yerusalem ih aqarweg moussi! ");
INSERT INTO fad_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Yerusalem, Yerusalem! Ag ih Tiwurdi profet agrowa uŕiyeg ge, qar touŕeg am aqarweg mouseg. Sén kuŕum da maru anig nagur sougwa qaglarko tonare qe sillah, nir asilgar qaglardil sein, gam ag mineg. ");
INSERT INTO fad_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ag qere dues! Gei Tiwur ag minarko loulag dimurdig. Da ag amlagwa anina. Ag da bulieksi ospi peiŕweg atew sén uŕiyew ag ere anlag, ‘Ig Naŕinah Tiwur wénihwa Danah uŕirig qe binag ménig,’ éksi anlag,” eko Yesus anan. ");
INSERT INTO fad_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat deŕ oswa Yesus Farisi dilag naŕi os lougwa ke lakri atan. Atew ag nug kaŕéoreksi koutoreg. ");
INSERT INTO fad_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Qewa ge, nug nohwa aminko danah os waŕe féŕu titŕarak ole qe dewew pian. ");
INSERT INTO fad_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesus Farisi am Ŕo duak danah ole koŕmaran. “Sabatwa waŕe danah sew kena mak ge Ŕo dimlamdak te?” ");
INSERT INTO fad_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Gam ag né kawa deg. Géri Yesus danah qe oŕako sew kena mew ge anorew atan. ");
INSERT INTO fad_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Atewew ge, Yesus koŕmaran, “Ag eneri olagwa usih os nag te kawa makau nusig te os Sabat deŕwa moŕ oŕewa tolako now pe, ag ofeŕ pi te béŕuweg bew?” ");
INSERT INTO fad_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Am ag né ospi aneg. ");
INSERT INTO fad_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Sén Yesus danah mallenwa ke lakri uŕieg qe danah wenlag ole dilag awen qewa dalagri seweg peko ge, né tonak ene anaran. ");
INSERT INTO fad_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Sén danah os ag nug wakri mallenwa atakri anew ateksi ge, ag danah wenlag ole dilag awen qewa aw daweg. Keŕdi danah os wénih naŕi ole na eŕdak uŕwurweg uŕirig ge na pi dona. ");
INSERT INTO fad_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Qere dew ge, mallen memeg a aŕié uŕwattig ole qe doko anirdig. ‘Na danah ene awen mor,’ eko anew uŕan newew atka danah wenlag kawa dasiwa darip. ");
INSERT INTO fad_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Gam sén na anew atka ge, awen danah wenlag kawa dasi qewa deppe, mallen memeg doko anirdig, ‘Lal, na aska atka awen kena danah wenlag ole dasiwa da,’ eko anirdig. Qe ge danah mallen qewa uŕilag ole leipar qe nolagwa na wénim sumdig. ");
INSERT INTO fad_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Danah oun os nug nugégé wénih sumdig ge, Tiwur danah qe wénih qew nérig. Am danah oun os nug nugégé wénih pi sumdig ge, Tiwur nug wénih karan sumdig.” ");
INSERT INTO fad_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Géri Yesus mallen memeg qe amegwa anan, “Sén na ke naŕi os seka ge, na leipar, awnar kampar ole, nasipwari am leipar kehlag ole na mourirak dasi qe aw uŕwarwen. Na qere sérip ge, ag ke séksi noh méksi na uŕwirlag. ");
INSERT INTO fad_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Gam na ke naŕi seka ge, o duak danah, danah ewlag félag nou ole am amlag gaŕu ole qe uŕwarwe ates. ");
INSERT INTO fad_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Qere sérip ge, ag noh makri olele kawa. Gam sén danahas mangunah ag Tiwur nohwa sirlag ge, Tiwur na noh mirko wittak mirdig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Danah os ke lelle Yesusri né qe doko ge anan, “Danah os mallen naŕi Tiwurdi kingdom owa ke lérig ge, nug Tiwur wittak kena morew o gamag asdig.” ");
INSERT INTO fad_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesus né qe noh meko anan, “Danah os mallen naŕi oŕwelle danah kuŕum uŕwaran. ");
INSERT INTO fad_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Sén keke kunum bawarko malako ge kekuak nir anew atko danah uŕwaran qe anaran, ‘Keke kunum bawrakra doweg atet,’ eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Danah uŕwaran ole qe kunum ole ag kekuak la ole, géri ospi atweg éksi aneg. Danah anqak qe anan, ‘Da wan fou os daren mein, géri minwe da atko wan qe kitalko peril,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Os ge nug anan. ‘Da tuménah makau 10 qere daren marin. Géri ag areg kekolag qe seweg peril qeri da ospi attil,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Am la os ge anan, ‘Da tuménah as win, géri ospi attil,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Kekuak nir qe buliko atko lo memeg qe amegwa anan. Anew ge, lo memeg qe uhŕibew kuak nir nusigri anan, ‘Ofeŕnah atka taunwa ih naŕi am nounu olewa o duak danah, ewlag félag nou ole am amlag gaŕu ole qe diarka uŕi,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kekuak nir qe qere seko ge anan, ‘Danah naŕi, na aniŕam sillah sém, gam lo ospi ambé.’ ");
INSERT INTO fad_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Géri mallen memeg kekuak nir nusigri anan. ‘Na atka taun dimdim ih naŕiwa am nounuwa ole keigarwe uŕiweg da loul ambar. ");
INSERT INTO fad_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Da anarina, da danah tatam uŕwarwi mineg ole qe kunum mallen dasilwa ke nagurnah ospi leweg,’ eko anan,” Yesus qere anaran. ");
INSERT INTO fad_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Danahas ameg naŕi Yesus dimlamdeppeg, nug buliko danahas qe anaran. ");
INSERT INTO fad_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Oun os dagrowa durigri dew pe, nug dasil o naŕi mousar. Am nug memegri am anigri, wawri, nir nusgur dilag, awgur kamgur dilag, am kéwingur dilag am nugégé nusig o naŕi niew pe, nug da begal diakri olele kawa. ");
INSERT INTO fad_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Am oun os nug nugégé nusig ker mawanak ospi mouko am da pi dimlamiŕko pe, nug da begal diakri olele kawa. ");
INSERT INTO fad_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Am ag olagwa danah usih os lo welah am karan os furigri ge, nug dako qarég gane touŕko lo fuko malarigri qe dahmeko peko am digumérig. ");
INSERT INTO fad_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Keŕdi nug digumeko lo lagko am pi malarig ge, danah kunum lo qe peksi siwegkoleksi ere anlag. ");
INSERT INTO fad_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Danah ene lo digumeko fuan gam nug malwakri olele kawa,’ éksi anorlag. ");
INSERT INTO fad_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Am king os 10,000 fan danah ih ole nug king os 20,000 fan danah ole fan selasri ge, nug lia qe éŕurdigri ge delle dahmeko koutorko peko digumeko fan sérig. ");
INSERT INTO fad_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nug olele kawa dew pe, king os qe lawaŕ dewew danah os anarew keŕ ihwa olas usih melasri koŕmorlagri atlag. ");
INSERT INTO fad_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Am ih qewa, ag oun os nug keŕ keŕ nusig qe kunum pi dimorko pe, nug da begal diakri olele kawa.” ");
INSERT INTO fad_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Sol ge keke kena, gam nug mumda kawa mew ge, areg seweg am buliko mumda ole darig? Kawa. ");
INSERT INTO fad_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sol mumda ole kawa qe nug ker os diguwa wanwa meko ker ke morakri kawa, nug kekuak ole kawa. Qeri sol qe touŕweg ate. Oun os doug né duakri ole dew pe, né ene doko koutorar,” eko Yesus anaran. ");
INSERT INTO fad_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Deŕ os takis wak danah am hipunin danahas ole qe ag Yesus né mariew dolagri uŕiyeksi qagleg. ");
INSERT INTO fad_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Gam Farisi am Mosesri Ŕo duak danah ole né né marieksi aneg, “Danah ene hipunin danah ole liam pateksi aŕié ke lési.” ");
INSERT INTO fad_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Géri Yesus né tonak ene anaran. ");
INSERT INTO fad_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ag olagwa danah os nug sipsip 100 qere ole darig am sipsip usih os lariew ge, nug areg sérig? Nug 99 qe minarew awen gisgaŕ olewa deppeg am nug atko sipsip usih larie qe pi te mariko pew? ");
INSERT INTO fad_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Am sén nug peko ge, o gamag asew sipsip qe sumko guqawa meko mouko louw ate. ");
INSERT INTO fad_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Atko ge, nug leigur am nusigwari qe ole uŕwarew uŕiyeksi qagulweg anare. ‘Ig onig gamag asar. Keŕdi da sipsip dasil usih larian qe peko buliko wém.’ ");
INSERT INTO fad_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Da anarina. Kowol qewa ih, hipunin danah os o buliew ge, saw kappa ole olag gamag asak naŕinah nie am danah mangu 99 olag buliakri olele kawa qe dilag olag gamag ase qe eŕdak.” ");
INSERT INTO fad_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Qe sillah, as os qarég silwa 10 qere ole am usih os lariew pe, nug areg sérig? Nug lam kamutko louw kinkak ekŕelle yamorko mariko mariko peko urig. ");
INSERT INTO fad_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Am sén nug peko oko ge, leigur am nusigwari qe ole uŕwarew uŕiweg anare. ‘Ag da ole onig gamag asar, keŕdi qarég silwa dasil larian qe peko buliko wém.’ ");
INSERT INTO fad_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Da anarina. Kowol qewa ih, hipunin danah os o buliew ge, Tiwurdi doup qe ag ole olag gamag ase,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesus né ene buliko anaran, “Danah os békuŕ aŕit ole daré. ");
INSERT INTO fad_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Géri nag dimbari ge memegri anan, ‘Mem, na keke wasaŕka dasil sillah qe miŕ.’ Géri memeg keke kunum nakuŕ dilas wasaŕko matan. ");
INSERT INTO fad_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Wagam ole kawa, nag dimbari qe keke nusig kunum qaglew daren meg. Meweg qarég oko oŕwelle atu os una qewa atan. Atko qewa delle ge, nug o mourakwa ih nouwa qarég sew kawa man. ");
INSERT INTO fad_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kawa mew dimba ge, atu qewa laké naŕi nian. Niew ge, nug digumeko qagrakwa dian. ");
INSERT INTO fad_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Géri nug atu qewari danah os dowa kekurigri atew ge, danah qe sew atko awen qewa fo nusig ke marelle gumardé. ");
INSERT INTO fad_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nug laké qew fo tounam gone mardé ole qe lérigri o naŕi daré, gam ounté kité ospi mordé. ");
INSERT INTO fad_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Sén dahmak kena nugrowa uŕiyew ge, nug nugégé anan, ‘Da memri kekuak nir ge ag ke olele, gam da ge ewa lakéri mousdil seina. ");
INSERT INTO fad_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Da mem dowa buliko atko andil, “Mem, da Tiwur nohwa am na nomba ole hipunin sein. ");
INSERT INTO fad_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Da na nam eka aniŕdipri olele kawa, gam sewe da kekuak nir nasip de,” ’ eko andil, eko anan. ");
INSERT INTO fad_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Géri nug asko buliko memeg dowa atan. Gam nug ih una uŕiyewew memeg peko nusig o dow guko atko qagru oŕako gamnurko kis moran. ");
INSERT INTO fad_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Géri nag memegri anan, ‘Mem, da Tiwur nohwa am na nomba ole hipunin sein. Da na nam diakri olele kawa.’ ");
INSERT INTO fad_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Gam memeg kekuak nir nusgur dilag anan, ‘Ag ofeŕ féŕu bala kenanah qe uksi méksi mores. Eweg doŕohwa ring oŕaweg now am fég gaŕa méksi mores. ");
INSERT INTO fad_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Am makau yu titŕaknah qe qéksi ke naŕi seweg lettu onig gamag asar. ");
INSERT INTO fad_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Keŕdi ig da nal ene mousko malwan qere dahmet, gam buliko uŕiyé. Nug larian, gam buliko peko wém.’ Géri ag olag gamag asakwa ke naŕi qe leg. ");
INSERT INTO fad_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Sén qe, nag digam nug dara dian. Nug uŕiko lo mourko dolle ge, kasi seppeg uttulag duan. ");
INSERT INTO fad_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Géri nug kekuak nir os uŕwurew wanew ge, koŕmoran, ‘Uni keŕ sessi sési?’ ");
INSERT INTO fad_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kekuak nir qe anan, ‘Na kamap ge buliko uŕiyé. Am na memen makau yu titŕaknah qe qew ke naŕi sam. Keŕdi nug nag larian qe gurak ospi wan kena ih buliko uŕiyew o gamag asew sé,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Gam awag ge uhŕibew lo owa nuak minan. Géri memeg dimdim wanko lo owa nurigri sinanah koŕmoran. ");
INSERT INTO fad_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Gam nug memegri anan, ‘Na pe! Da makaŕ kuŕum nasip kekuak sam sein am né nasip ospi tappi nan. Gam qeri na meme yu usih ospi miŕwe da leilar ole ke nag ospi séktu let. ");
INSERT INTO fad_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sén na nam ene qarég nasip naŕi oko atko o mourakwa ih nouwa am ihwari as feŕlagwa sew kawa mew, am buliko louw uŕiyew ge, na makau yu titŕaknah qeka moŕam,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Géri memeg anan, ‘Da nal, na sansan da ole daŕu. Am keke dasil kunum qe nasip. ");
INSERT INTO fad_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Gam ig ke lettu onig gamag asé, keŕdi na kamap ene mousan gam fouman. Nug larian gam buliko kappa uŕiyew ge, ig buliektu piam,’ eko anan,” Yesus qere anaran. ");
INSERT INTO fad_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesus bégur anaran, “Sén os danah kéhu oleri kuak nir dilag anqak danah keke nusig kunum gumardé ole qe daré. Deŕ os danah os atko danah kéhu ole qe amegwa kekuak nir nusgur dilag anqak danah qe qarég nusig sew kawa meré qeri anoran. ");
INSERT INTO fad_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Géri nug uŕwurew now koŕmoran, ‘Danah nasip marisi qe meŕe te? Keŕdi na kuak qewari malwirdil, na qarég areg gumen qe kunum ole yaka miŕ,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Géri kekuak gumak danah qe nugégé anan, ‘Danah naŕi da gumŕe ge kuakwari géŕildig, géri da aregnah séril? Da dar kekuakri gagragsak ole kawa am da nuqak uŕal ne. ");
INSERT INTO fad_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Sén da kekuak ewari malwiŕew ge, aregnah séwi danahas wiŕweg loulagwa danigri ge da duina,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Géri nug né mew danah naŕi nusig qeri qarég noh makri danah qe usih usih uŕiyeg. Anuqko uŕiyan qe koŕmoran, ‘Na keke gane bulika noh meka danah naŕi dasil murdip?’ ");
INSERT INTO fad_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Danah qe né noh meko anan, ‘Oliw goŕen siné 100 qere.’ Kuak gumak danah anoran, ‘Na pepa bulika noh makri ene oka ofeŕ qere daka siné 50 ih qere ya,’ eko anoran. ");
INSERT INTO fad_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Qe dimba am danah os dow koŕmoran, ‘Am na ge keke gane noh mérip?’ Danah qe koŕmak noh meko anan, ‘Reis bek 100 qere.’ Kuak gumak danah anoran, ‘Pepa bulika noh makri nasip enan da oka 80 bek ih qere ya.’ ");
INSERT INTO fad_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Qeri danah naŕi qe kekuak gumak danah kena kawa qeri ‘Kena sam. Na duak kena ole,’ eko anoran. Keŕdi danah wan ewari ag keke gumarakri duak qe ag dosi koutursi, danah kamsahlak owari dilag duak qe eŕarak. ");
INSERT INTO fad_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Da amlagwa anina. Keke wan ewariwa ag leilgar kehnares, geisah keke qe ole diakri sén olele morew, Tiwur ag sumarew saw kappa awen ole dalag. ");
INSERT INTO fad_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Oun os nug keke nagur pesorko gumdig ge, nug keke naŕi ole pesorko gumdig. Am oun os nug keke nagur nouni gumdig ge, nug keke naŕi qe ole nouni gumdig. ");
INSERT INTO fad_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Géri wan kéhu nouni gumarlag ge, oun nug saw kaw kéhu meŕenah qe gumlagri mardig? ");
INSERT INTO fad_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Am ag danah osri keke nouni gumarlag ge, oun nug keke asilagnah qe mardig? Kawa. ");
INSERT INTO fad_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Kekuak nir os danah naŕi aŕit dilas sén usihwa kekuakri olele kawa. Nug os ge dimorelle am osri ih o nirig. Nug os ge dimlamdelle am os ge mindig. Qe sillah ag Tiwur méŕiwanessi am keke wan ewari ole méŕiwanakri olele kawa,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Qere anew ge, Farisi qarégri olag niré ole qe dueksi Yesusri né siwkolessi aneg. ");
INSERT INTO fad_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Né siwkolessi anweg ge, nug anaran. “Ag ansi, ‘Danah amlagwa ig mangunah,’ gam Tiwur ge ag olag pe am due. Danah ag keŕ kekeri olag naŕi nie ole ge, Tiwur amegwa keke qe nouninah.” ");
INSERT INTO fad_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Mosesri Ŕo am profet dilag né kusweppeg uŕiyew Yonwa patan. Qe dimba ge, Tiwurdi Kingdomri né kena qeri kusweppeg uŕiye. Am danahas kunum qewa nolagri kekuak naŕi sési. ");
INSERT INTO fad_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wan saw ole ge kawa mérigri kug kawa, gam Tiwurdi Ŕo Yak ge nagurnah ospi kawa mew. ");
INSERT INTO fad_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Danah oun os waw munurko am as la urig ge, nug doŕ dilag kowol qe sérig. Am danah os as gému mundak urig qe ole nug doŕ dilag kowol qe sérig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesus né marielle am né ene ole anaran. “Danah os kéhu ole am nug féŕu bala kena kenanah meré. Nug deŕ dorog keke kunum olele daré. ");
INSERT INTO fad_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nusig kaŕ ihŕamba ge o duak danah os wénih Lasarus qe niré. Lasarus nug féŕu kunum isi olele morak. ");
INSERT INTO fad_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Am nug danah kéhu ole qe lougwari ke le minak biŕa os lelemba daré. Am o duak danah ge qé isi meŕweppeg daré. ");
INSERT INTO fad_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Sén dow o duak danah Lasarus mousew, Tiwurdi doup maweksi ateksi awen kena Abraham dianwa Abraham waŕutqorweg des. Danah kéhu ole qe ole mousew suhmeg. ");
INSERT INTO fad_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nug kew pi qouse olewa gurak naŕinah olle delle amnew tew ge, Abraham unanah uwa pian. Lasarus ole waŕutqorak dewew pian. ");
INSERT INTO fad_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Géri nug Abraham uŕwuran, ‘Mem Abraham, da nuqrina. Na dasil ot dow Lasarus anwe eweg guŕ noh lewa meko lémŕul oug mérigri mar. Keŕdi da kew ewa gurak naŕinah wina,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Gam Abraham noh meko anan, ‘Nir dasil, na dahmor. Na wanwa keke kena ot nian ole qe kunum on, gam Lasarus ge keke nou qe diaran. Gam gei ge nug gamag asewew ewa de am na ge gurakwa dana. ");
INSERT INTO fad_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Am ole, ig gamnigwa kuhaŕ naŕinah nie, géri oun ewari agrowa wanakri olele kawa am qewari ole igrowa ewa mataŕko duakri olele kawa.’ ");
INSERT INTO fad_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Danah kéhu ole ge Abrahamri anan. ‘Da nuqrina, mem! Lasarus anwe da memel lougwa atar. ");
INSERT INTO fad_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Keŕdi da awlar kamlar tanig ole ena dasi. Nug gagrag anarew da gurak duina awen enewa ag aw uŕiweg,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham noh meko anan, ‘Mosesri Ŕo am profet dilag né yak nie, géri minwe ag qe dues.’ ");
INSERT INTO fad_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Géri nug anan, ‘Kawa, mem Abraham. Qe olele kawa. Danah os mousko am buliko asko atko amlagwa andig qe ih ge, ag dueksi olag bulirig.’ ");
INSERT INTO fad_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham nug anoran, ‘Ag Moses am profet ole dilag né dueksi pi dimlamurlag ge, danah mousko am sirko anarew qe ole ospi dueksi dimlamurweg,’ ” eko Yesus anan. ");
INSERT INTO fad_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesus bégur anaran, “Sak o kowol seweg danahas hipuninwa tolalagri qe uŕilag, gam danah qe sérig ole ge nug kug os perig. ");
INSERT INTO fad_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Danah qe sew nir nagur ene os hipunin sew pe, nug fagwa qar naŕi eiseksi touŕweg iwba nurig olelenah. ");
INSERT INTO fad_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Qeri dahméksi koutores. Na liap nagrowa hipunin sew pe, gaŕa morwe buliko aw sew. Am nug o buliew kowol qe minko dimorew ge, hipunin noh nusig kusuqka dowe dout katiar. ");
INSERT INTO fad_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Am nug deŕ usihwa nagrowa hipunin seko 7 qere patko am buliko sén 7 qere patak uŕiko ‘Kowol qe nouni sém,’ elle o buliew pe, hipunin nusig kusuqka dowe dout katiar,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Aposel Naŕinah anoreg, “Na sewe ig nasip onig meŕe mak naŕi mar.” ");
INSERT INTO fad_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nug noh meko anaran, “Ag olag meŕe mak nagurnah kapis ég sillah darig ge, ag ker naŕi giŕam eneri anlag, ‘Na siŕka atka iwba diŕin noka be,’ éksi anweg nug dimlamurko qere sérig.” ");
INSERT INTO fad_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Né os anwi dolag. Ag olagwa usih os nug kuak nir nusig wan kopattig am sipsip gumardig. Sén nug kuak awenwari uŕiyew ge, danah naŕi nusig ‘Na ere daka ke le,’ eko anurdig te? ");
INSERT INTO fad_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kawa. Nug ere andig, ‘Na le loka bawarka ke dasil se. Na amel meka deppe da ke lewi tatam, am na ke le.’ ");
INSERT INTO fad_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kuak nir nusig né dimlamurko keke kunum sérig, qeri danah naŕi nusig ‘Kena sam,’ eko ospi anew. ");
INSERT INTO fad_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Géri ag ole Tiwur keŕ sakri ane qe kunum séksi malweksi ge, ag anes, ‘Ig kuak nir nasip sam. Ig kekuak migak qe sam,’ éksi anes,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sén Yesus Yerusalem attigri atelle Samaria atu uŕiko patak qe dimlamurko atan. ");
INSERT INTO fad_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nug atko kaw oswa nowew, danah 10 qere leprasi ole peksi unaka pi waneg lawaŕ deg. ");
INSERT INTO fad_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Dessi ge, ag uŕweksi anoreg. “O danah naŕi, Yesus! Na isanig ot duar!” ");
INSERT INTO fad_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sén nug piarko ge anaran, “Ag ateksi feŕlag pris ismares.” Ag atessi ge, ihwa feŕlag pasaorew peg. ");
INSERT INTO fad_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Danah 10 qe kunum feŕlagwa leprasi pasaorew peg. Gam danah usih os sén féŕu pasaorew peko ge, fag naŕiwa qalko Tiwur binag sumelle buliko uŕiyan. ");
INSERT INTO fad_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nug atko Yesus nohwa ole fégwa gatewa yako duk noko “Kenanah sam,” eko anoran. Am nug ge Samaria danah. ");
INSERT INTO fad_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesus koŕman, “Danah 10 qere séwi feŕlag pasaoré. Am danah 9 qere ge arewa dasi? ");
INSERT INTO fad_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aregri uŕiyak danah usih ene ih Tiwur binag mérigri buliko uŕiyé?” ");
INSERT INTO fad_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Qere anelle Samariarer qeri anan, “Aska eit, na ot meŕe mak qewa Tiwur féŕun sew pasaoré,” eko anoran. ");
INSERT INTO fad_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Deŕ os Farisi danah Yesus koŕmoreg. “Ganeh Tiwur king beko danahas nusgur gumardig?” Yesus noh meko anaran, “Tiwurdi Kingdom digumeko bérig ge ag amlagwa peppeg pi bew. ");
INSERT INTO fad_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Danahas ‘Enan de,’ am ‘Unan de,’ éksi ospi anweg. Keŕdi Tiwurdi Kingdom iŕil uŕiyan danahas gamlagwa de,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesus bégur dilag anan, “Sén qe uŕirig qewa ag da Danah Bega deŕ usih os peiŕlagri selag, gam ag ospi peiŕweg. ");
INSERT INTO fad_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Danah anarlag, ‘Mesaia nug unan de,’ am ‘Nug enan de,’ éksi anlag. Gam ag aw gueksi dimlamareksi atweg. ");
INSERT INTO fad_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Keŕdi Danah Bega da uŕirildi deŕwa saw karan ampiŕ oko atu kunum olele more qe sillah peksi ge dolag. ");
INSERT INTO fad_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gam tatam ge, da gurak naŕi uril am geiri danahas dimiŕlag. ");
INSERT INTO fad_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nuari sénwa danahas kowol nou seréw qe sillah Danah Begari uŕiyak sénwa ole qere ih selag. ");
INSERT INTO fad_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Danahas ke leg, le leg, danahas nug oppeg atew atew ole Nua kuh naŕinah qe owa nuan. Sén qewa gu naŕi neko le kue naŕi bew paral meg. ");
INSERT INTO fad_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Qe sillah Lotri sénwa ole qere seréw. Danahas ke lessi, le lessi, keke darendi maressi, keke fou daren maressi, ke keharessi am lo fuaressi daréw. ");
INSERT INTO fad_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Gam Lot Sodom minko atewew sén qewa ge, Tiwur sew kew am qar aŕelle saw karandi gu sillah neko aŕarew kunum ole paral meg. ");
INSERT INTO fad_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Qe sillah danahas pi bawrak deppeg deŕ qewa Danah Bega kamsahlak gun olewa uŕirig. ");
INSERT INTO fad_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Deŕ qewa danah os loug dimdim darig ge, lo owa keke nusgur diardigri pi now. Qe sillah danah os dara darig ge, lougwa keke diardigri buliko ospi atew. ");
INSERT INTO fad_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Keŕ ihwa Lot waw paral man qe dahmores. ");
INSERT INTO fad_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Oun os nug nugégé kowol kunum nusig dimlamurko ge, foumak sansan diakri ospi ow. Gam oun os kowol kunum nusig dimorko da dimlamŕelle mousdig ge foumak sansan diakri urig. ");
INSERT INTO fad_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Da anarina. Danah Bega uŕirig sén qewa danah aŕit os tuqan aŕié nieppes ge, os ge olle am os ge munurdig. ");
INSERT INTO fad_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","As aŕit os aŕié ke sagŕessa dalas ge, os ge olle am os ge munurdig.” ");
INSERT INTO fad_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Danah aŕit os aŕié dar usihwa dalas ge, os ge olle am os ge munurdig.) ");
INSERT INTO fad_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesus né mariko malwew, ag koŕmoreg. “Naŕinah, qe arewanah bérig?” Nug koŕmak noh meko anaran. “Awen arewa doŕ mousak os niewew ge, tum qewa qagulsi. Qe sillah, da lugmak ospi uŕiwin ag dueppeg uŕiril,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Am Yesus nug Bégur 12 unuqorak pi minweg sansan unuqorlagri né tonak ene amlagwa anan. ");
INSERT INTO fad_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nug anan, “Né kepŕak danah os taun oswa daré. Nug Tiwur pi faŕurdé am danah dilag ole pi dahmeré. ");
INSERT INTO fad_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Am as qehŕas os taun qewa daré. Nug bulibuli né kepŕak danah qe dowa atko nuqurko andé. ‘Kegeŕ dasil nouni siŕan. Qeri na da dimulwa daka né dasil kepaŕ,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Sén welah né kepŕak danah qe kité ospi san, gam dimba nug nugégé anan. ‘Da Tiwur pi faŕdina am danah dilag ole pi dahmeina. ");
INSERT INTO fad_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Gam as ene bulibuli dagnéwa uŕiyew séŕiag iwŕe, géri né nusig kepaŕko mangu murdil. Keŕdi nug sew da kéwsil kawa ospi mew!’ eko anan.” ");
INSERT INTO fad_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Am Yesus anan, “Né kepŕak danah mangu kawa nug keŕ eko anan qe dues. ");
INSERT INTO fad_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Am Tiwur nug danahas nusgur kepŕaran qe dilag kug tuqan kémun ole unuqorakwa mursi ge, asilag seko pi te mangu morko mare? Nug qere duelle te darig? Kawa. ");
INSERT INTO fad_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Da anarina. Nug ofeŕdi mangu morko mardig. Gam sén Danah Bega da wan ewa buliko uŕiko ge, o meŕe mak danah os piardil te?” eko koŕmaran. ");
INSERT INTO fad_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Danah os ag dueg ge ag mangu essi am la kunum ge sam sillah duardéw qeri Yesus né tonak ene anaran. ");
INSERT INTO fad_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Danah aŕit os unuqorlasri Tiwur Lougwa ates. Os ge Farisi danah am os ge takis wak danah. ");
INSERT INTO fad_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi danah qe asko lawaŕ delle nug unuqoran. ‘Tiwur, da na kena sam eko anirina, keŕdi da danah la kunum sillah kawa. Da yawsen danah kawa, sak nou sak danah kawa, danah la walgar diko weiyak danah kawa, am takis wak danah ene sillah kawa. ");
INSERT INTO fad_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Da kuha usihwa kurdako aŕit patina am keke kunum wina ge watiwi ameg 10 qere new ameg usih qe na mirina,’ elle unuqoran. ");
INSERT INTO fad_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gam takis wak danah ge lawaŕ asko delle saw karan os ole pi amnan, gam eweg damkowa meko delle unuqoran, ‘Tiwur, da hipunin danah. Na dasil ot dow hipunin dasil kusuqka miŕ,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Da anarina. Takis wak danah qe Tiwur hipunin nusig noh kusqew Tiwur nohwa danah mangu delle lougwa atan. Gam Farisi danah ge qere kawa. Keŕdi oun due nug wénih ole ge, Tiwur sew nug wénih kawa darig. Am oun nug due nug wénih kawa ge, Tiwur sew nug wénih ole darig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Danahas Yesus nir yu feŕlagwa eweg meko wittak kena mardigri dieksi dog. Sén Yesus bégur ag piareksi ge, gaŕa mareg. ");
INSERT INTO fad_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Gam Yesus nir nounu uŕwarew nugrowa doweg ge anan. “Nir nounu paŕwarweg dagrowa dos. Ag aw dagarweg. Keŕdi danahas nir nounu ene sillah qe Tiwurdi Kingdom ge asilag. ");
INSERT INTO fad_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Da meŕenah anarina. Danahas are nir nounu ene sillah ag Tiwur kallowa pi dalag ge, ag Tiwurdi Kingdom owa ospi noweg,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yuda dilag kuri danah os Yesus koŕmoran, “Duak marak danah kena, da aregnah seko foumak sansan diakri uril?” ");
INSERT INTO fad_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesus koŕewa oko anan, “Na keŕdi dasil kena eka anam? Ounté kena os kawa. Tiwur nug nugé ih kena. ");
INSERT INTO fad_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na Tiwurdi Ŕo 10 dona: ‘Na watnah dewew as la ole aw weiwes, danah aw dug kowen, yawsen aw sewen, né dar aw mewen, am anin memen ole kallolaswa denna koŕlas dimlamur,’ ” eko anoran. ");
INSERT INTO fad_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Anew kuri danah qe anan, “Ŕo qe kunum ole da nir nagurwa delle dimlamurwi uŕiyan,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Sén Yesus né qe doko ge anoran, “Na ih usih os tuqren. Na kéhun kunum anwe daren meweg am qarég oka o duak danah marka ge, na saw kappari wittak kena qe urip. Qere seka ge, doka da dimlamiŕ,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Gam nug danah kéhu naŕi ole géri, sén Yesus qere anew doko ge neko qan. ");
INSERT INTO fad_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Géri Yesus danah qe neko qew peko anan, “Danah kéhu ole os keke nusig kunum minko Tiwurdi kingdomwa nurigri ge kug ole. ");
INSERT INTO fad_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Meŕenah, doŕ naŕi wénih kamel ge keke titiyakri nil oŕewa nurigri ge kug ole, gam danah kéhu ole ge Tiwurdi kingdomwa nurigri ge kug qe eŕdak.” ");
INSERT INTO fad_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Danahas né qe dueksi Yesus koŕmoreg, “Am oun ge foumak sansan diakri urig olele?” ");
INSERT INTO fad_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesus koŕmak noh meko anaran, “Keŕ os danah sakri olele kawa ge, Tiwur ge sérig olele,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Anew Pita anoran, “Ig na dimlamirnigri keke isangar kunum minaret,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Anew Yesus anaran, “Da meŕenah anarina. Danah os nug Tiwurdi kingdomri seko loug minko, waw minko awgur kamgur minarko, anig memeg ole am nir nusgur minarko asdig ge, ");
INSERT INTO fad_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nug sén wan ewa dewew saw kappari wittak kena kuŕum tatam moran qe eŕdak murdig am keŕew né foumak sansan diakri ole murdig,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesus Bégur 12 qe uŕwarew wanweg agé dessi anaran, “Ig Yerusalem tehut ge, Danah Begari né profet yeg qe kunum mou bérig. ");
INSERT INTO fad_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Danah ag Danah Bega uksi Yuda danahas kawa la qe ewlagwa melag. Meweg ag geisah nug siwegkolessi uksiuksi qoressi sunu qessi qisleksi am qeweg mousdig. ");
INSERT INTO fad_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Gam deŕ kiamba ge nug buliko asdig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nug Bégur ag né qe kunum dueg, gam olag ospinah mouran. Né digu lugman, géri ag nug keŕ eko marian ge sam sillah dueg. ");
INSERT INTO fad_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesus Yeriko wandigri wanewew, danah os ameg gaŕu ole ih dougwa ninapiŕko delle nuqran. ");
INSERT INTO fad_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Sén nug danahas ameg naŕi duksi eŕdeksi ateppeg uttulag doko koŕman, “Areg sé?” ");
INSERT INTO fad_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Danah os anoreg, “Yesus Nasaretrer qe doko wane,” éksi anoreg. ");
INSERT INTO fad_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Anweg ge, nug uŕuko anan, “Yesus, Dewit fuŕuh, na dasil ot dow pe kéhniŕ!” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Danah anqeksi waneg qe gaŕa moreksi, “Na torka da,” éksi anoreg. Gam nug qalko uŕwan, “Dewit fuŕuh, na dasil ot duar!” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesus fég yako delle nuqak danah qe omalko nugrowa duakri anan. Unaka dow Yesus koŕmoran. ");
INSERT INTO fad_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Na da keŕ sérildi ot nie?” eko anan. Anew danah ameg gaŕu ge anan, “Naŕinah, da amindil ol nie,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Anew Yesus anoran, “Na amin. Na ot meŕe mak qewa Tiwur sew kena mam.” ");
INSERT INTO fad_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Usihri nug ameg koptew ole Tiwur binag melle Yesus dimlamdan. Sén danah kunum qe peksi ge, ag ole Tiwur binag meg. ");
INSERT INTO fad_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesus Yeriko taun owa noko ih dimlamurko atan. ");
INSERT INTO fad_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Danah os wénih Sakias nug qewa dian. Nug takis wak danah qe dilag kuri am nug kéhu ole. ");
INSERT INTO fad_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nug Yesus ge oun qe perigrinah san gam olele kawa. Keŕdi nug danah kutuk am danah kuŕum am qataorak. ");
INSERT INTO fad_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Géri nug anuqko guko atko guŕaw ker naŕi os teko Yesus qere wanew perigri qewa ameg meko dian. ");
INSERT INTO fad_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sén Yesus awen qewa wanko amnew tew peko ge anoran, “Sakias, na ofeŕ ne. Keŕdi da gei ole na loutwa daril.” ");
INSERT INTO fad_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Géri Sakias usihri neko gamag asakwa Yesus gamnurelle omlew lougwa ates. ");
INSERT INTO fad_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Danahas kunum qere peksi Yesusri né né marieg, “Nug aregri hipunin danah enenah lougwa ŕo até,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Louw ge Sakias asko Naŕinahri anan, “Naŕinah, na né ene doka. Da keke dasil kunum gamagwa watiko leis ge o duak danah mardil. Am da oun os darmakwa qarég kaŕdin ge waŕos patak noh meko murdil,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesus anoran, “Gei ole Tiwur na fénarwa ole dilag hipunin noh kusqé. Am danah ene ole Abraham fuŕuh. ");
INSERT INTO fad_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Qeri Danah Bega nug oun os gattu owa de qe mariko peko buliko ow Tiwurdi uhŕibak éŕurdigri uŕiyan,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yesus né qe mariew dueppeg, nug Yerusalem mourak nuan am danahas ag Tiwurdi Kingdom usihri wanwa bérig éksi dahmeg. Géri Yesus né tonak ene anaran. ");
INSERT INTO fad_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Danah binlag ole qe fuŕuh os atu una oswa atew king darigri wittak morew uŕirigri atan. ");
INSERT INTO fad_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Géri nug kekuak nir nusgur 10 qere anew noweg usih usih qarég gol mina awen awen qere maran. Marko ge anan, ‘Qarég ene uksi kekuak moreppeg da buliko uŕiril,’ eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Gam danah nusgur os danah naŕi qeri olag pi nian ole qe danah la os nug dimugri meŕarweg danah naŕi qe atanwa ateksi, ‘Ig danah ene king isanig diakri onig pi nie,’ ellagri ateg. ");
INSERT INTO fad_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Gam nug king beko buliko kawagwa uŕiyan. Uŕiko ge, kekuak nir nusgur 10 qere qarég maran ole qe dilag né man. ‘Ag qarégwa kekuak areg seg?’ qe dorigri koŕmaran. ");
INSERT INTO fad_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kekuak nir anuqko duan qe anan. ‘Danah naŕi, qarég na miŕen qe kekuak murwi qarég gol mina 10 la ole qaŕewa ban,’ eko anoran. ");
INSERT INTO fad_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Anew king nusig doko ge anan, ‘Kena sen. Na kekuak nir dasil kena. Na qarég nagurwa kekuak kena sen, géri gei na taun ten qere gumardipri anina.’ ");
INSERT INTO fad_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Am aŕit patak qe doko anan, ‘King dasil, qarég nasip kekuak murwi qarég gol mina tanig ole la qaŕewa ban,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Anew ge king nusig anoran, ‘Na taun tanig ole gumardip.’ ");
INSERT INTO fad_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Am kekuak nir kiam patak qe doko anan, ‘King dasil, qarég gol mina usih nasip na miŕen ge enan. Da lamen qariwa saputko pesorko méwi dian. ");
INSERT INTO fad_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Na danah gagŕan ole. Keŕ os na pi kehna qe na funa, am danah la os keke mési qe ole na ona. Qeri da na faŕirko qere sein.’ ");
INSERT INTO fad_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","King nusig qe koŕewa oko anoran, ‘Na kekuak nir nou am né nasip dimlamdak ge séwi noh urip. Na duen ge da danah gagŕal ole am danah la os keke mési qe da wina am danah la kéhsi qe ole da fuina. ");
INSERT INTO fad_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na keŕdi qarég dasil buliko uŕiko qaŕewa noh la ole olem, gam na qarég lougwa pi men?’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Anko ge, danah aseksi deg qe dilag anan, ‘Qarég nusig kaŕdeksi danah qarég gol mina 10 la qaŕewa sew ban ole qe mores.’ ");
INSERT INTO fad_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘King naŕi, nug qarég gol mina 10 ge iŕil wé,’ éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Anweg anaran, ‘Da anarina, oun os keŕ os pesorko gumdig ge, fou la ole urig. Gam oun os keŕ nagur ole am nouni gumdig ge, da nug qe kaŕurdil. ");
INSERT INTO fad_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Gam kegeŕ dasil da king asilag diakri mineg ole qe diareksi duksi da nolwa aqares,’ ” eko Yesus anaran. ");
INSERT INTO fad_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesus qere anko ge, Yerusalem attigri anuqko atan. ");
INSERT INTO fad_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yesus kaw aŕit Betfage am Betani ole Oliw qouku éksi ansi qe sékuwa dasa qe mouratak wanan. Wanko ge, békuŕ aŕit meŕ atew anqeksa ateppes anatan. ");
INSERT INTO fad_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“A kaw uniwa ateksa waneksa ge, donki os fou kena mak ounté os pi teko weiyan ole qe qagak dewew pelas. Peksa ge, kusqeksa oksa uŕiyes. ");
INSERT INTO fad_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Oun os a keŕdi donki kusuqsa eko koŕmew ge anores. ‘Naŕinah kekuak murdigri kusuqŕu,’ eksa anores,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Békuŕ aŕit qe ateksa ge nug anan qe sillah ole pes. ");
INSERT INTO fad_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","A donki fou kena mak qe kusqeppes donki memeg koŕmateg. “A keŕdi donki kusuqsa?” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","A koŕmak noh meksa anes. “Naŕinah kekuak murdigri,” eksa anares. ");
INSERT INTO fad_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Géri donki oksa Yesus dowa uŕiyeksa ge, siot asilas qaŕewari qe uŕeksa donki qaŕewa duqessa, Yesus eweg oŕawes teko donki karan dian. ");
INSERT INTO fad_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yesus donkiwa atewew, danahas siot asilag qaŕewari uŕeksi ihwa duqareppeg nug qaŕewa atan. ");
INSERT INTO fad_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Sén nug Oliw qouku minko nuakri ih qewa dowew ge, nug bégur dimlamdeg qe kunum ole olag gamag asakwa diguméksi qaleksi Tiwur binag sumeg. Keŕdi ag Yesus mirakel sew piareg. ");
INSERT INTO fad_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“King Tiwur Naŕinah wénihwa uŕiye ge nug wittak more. Saw kappa Tiwur ole maror nirig am Tiwur karannah nug binag karan sumnig.” ");
INSERT INTO fad_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Am Farisi la os danah ameg naŕi qe owa deg qe Yesusri aneg, “Duak marak danah, na begpar gaŕa marwe mines,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesus noh meko anaran, “Da anarina. Danah ene torweg ge, qar koŕlag koptew uŕwessi binag sumlag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Sén Yesus atko unaka wanko Yerusalem taun naŕi qe peko ge, o dow kuanelle anan. ");
INSERT INTO fad_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","“Yerusalem danahas, ag olag duaknah! Ag Tiwurdi maror owa kena diakri qe dollewri kenanah. Gam ag amlag gaŕwé dasi. ");
INSERT INTO fad_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Sén qe uŕiyew ge, kegeŕ asilag fanlag uŕiyeksi kaŕ asilag taliloreksi wan qagulweg tew, o mareksi dalag. ");
INSERT INTO fad_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Am taun asilag logŕeksi ag aqeksi keke kunum ole seweg nou mérig. Am qar usih os minweg lia qaŕewa ospi dew. Keŕdi ag sén Tiwur agrowa uŕiyan ge, peksi olag pi mouran,” elle kuanan. ");
INSERT INTO fad_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesus Yerusalem noko Tiwur Lougri kaŕ owa atko qewa danah keke irardi méksi deppeg nug piarko ge digumeko lamaran. ");
INSERT INTO fad_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nug ere anelle lamaran, “Tiwurdi Né yak ere ane, ‘Da loul ge unuqorakri lo.’ Gam ag seweg yawsen danah dilag lariak awen sillah beko se,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nug sansan Tiwur Lougri kaŕ owa danahas doulag patté. Gam pris dilag anqak danah, Mosesri Ŕo duak danah am Yuda dilag kuri danah ole ag Yesus qeweg mousdigri ih mariréw. ");
INSERT INTO fad_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Gam ag ih ospi peg, keŕdi danahas kunum né nusig dolagri seréw. ");
INSERT INTO fad_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Deŕ os Yesus Tiwur Lougri kaŕ owa danahas duak marelle am Né Kena kuswewew, pris dilag anqak danah, Mosesri Ŕo duak danah am Yuda dilag kuri danah ole duksi anoreg. ");
INSERT INTO fad_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Na anwe ig duet. Na kuakri wittak arwari oka Tiwur Lougwa kuak ene sena? Na oun kuakri wittak qe mirew sena?” ");
INSERT INTO fad_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nug koŕlagwa oko anan, “Da ole ag koŕmardil. ");
INSERT INTO fad_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ag anweg due, Yon le luaran ge kuakri wittak Tiwur dowari te, kawa danah dowari te oko san?” ");
INSERT INTO fad_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ag agégé marieksi aneg, “Saw kappari ektu annig ge nug koŕmigdig. ‘Ag keŕdi nusig kuak qeri olag meŕe pi man?’ ");
INSERT INTO fad_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Am ig Yonri kuakri wittak danah agopri éktu annig ge danahas uni kunum qar uksi kuiglag, keŕdi ag olag meŕe me ge Yon ge Tiwurdi profet.” ");
INSERT INTO fad_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Géri ag Yesusri aneg, “Arewari té ge ig pi dotu.” ");
INSERT INTO fad_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Qeri Yesus anan, “Da ole oun kuakri wittak miréw kekuina ge ospi anwi doweg,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Am Yesus né tonak ene danahas amlagwa anan. “Sén danah os wain dar naŕi kehko am nug danah os wain dar nusig gumeksi morlagri mine marelle ge, nug atu una oswa atko wagam darigri atan. ");
INSERT INTO fad_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wain mou wegak sénwa nug sew kekuak nir nusig os wain dar gumak danah qe agop wain mou os morlagri atan. Gam wain dar gumak danah qe mouŕweksi anweg eweg sam buliko atan. ");
INSERT INTO fad_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nug kekuak nir la anew atan, gam qe ole mouŕweksi nouni sorweg eweg sam am buliko atan. ");
INSERT INTO fad_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Wain dar memeg kiam patak kekuak nir os mew atew ge, mouŕweksi karag moreksi keigorweg dar dimdim atan. ");
INSERT INTO fad_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Géri wain dar memeg anan. ‘Da aregnah séril? Da nir dasil ol mouse ole qe attig ge, né nusig dueksi dimlamurlag té,’ elle anew wain dar gumak danah qe agop atan. ");
INSERT INTO fad_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Gam sén wain dar gumak danah dar memeg nag qe peksi ge, ag agégé né qageksi aneg. ‘Danah ene wain dar memeg mérig. Doweg qéhut mousew dar qe isanig darig,’ éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Géri keigoreksi beŕweksi dar dimdim ateksi qeweg mousan. Qeri wain dar memeg ge aregnah sardig? ");
INSERT INTO fad_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nug uŕiko wain dar gumak danah qe sew aqarweg mousweg am dar oko danah la gumlagri mardig,” eko anan. Sén danahas né tonak qe dueksi ge aneg, “Qere aw bew.” ");
INSERT INTO fad_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesus kittarko delle koŕman, “Qere ge Né yak ene digu areg? ‘Lo fuak danah wandor mineksi geŕdeg ole qe lo memeg wandor qe oko gamagwa lagew delle lo mawe.’ ");
INSERT INTO fad_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Danah wandor qe qaŕewa tolalag ole ge, kunum ole kaduŕlag. Am wandor qe oun os qaŕewa tolarig ge, maduŕew nounu nérig. Qe sillah, oun os nug da dimiŕdig ge nug paral mérig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mosesri Ŕo duak danah am pris dilag anqak danah ole ag dueg ge, né tonak qe asilag nou qe uŕameko marian. Géri sén qewa ih ag ih os peksi oŕalagri seg, gam ag danahas dilag faŕeg. ");
INSERT INTO fad_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mosesri Ŕo duak danah am pris dilag anqak danah ole ag Yesus kaŕéordéw. Géri ag danah os darmak danah anweg danah mangu sillah ateksi yawsen amneksi Yesus pelag ateg. Ag nug keŕ os nouni anew qewa oŕweksi wan atu dilag kuri danah kuakri wittak morak am gagragsak ole qe ewegwa melagri ateg. ");
INSERT INTO fad_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Géri yawsen amnak danah qe Yesus koŕmoreg. “Duak marak danah, ig dotu ge na né mangu ih marina, ismigna am na danah kunum nouni ospi sarna. Am na né meŕe Tiwur danahas areg dalagri o nie qe ismarna. ");
INSERT INTO fad_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Na an, ig sétu sillah Sisari takis touŕnig kena te, kawa te?” ");
INSERT INTO fad_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesus darmak dahmak asilag qe doko anaran. ");
INSERT INTO fad_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Qarég silwa os seweg pewi. Oun dorogrog am wénih ole qewa de?” eko koŕmaran. ");
INSERT INTO fad_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ag koŕewa uksi aneg. “Sisa dorogrog am wénih ole.” Nug anaran, “Aria! Sisari ge Sisa mores, am Tiwurdi ge Tiwur mores,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ag Yesus né nouni os anew dolagri dahmeg, gam sén nug danahas ole dessi nug né nouni usih ospi anew dueg. Ag nug né noh man, qeri dorlag new ole toreksi deg. ");
INSERT INTO fad_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sadusi os danah mouseksi am bulieksi pi asweg éksi andéw ole qe uŕiyeksi Yesus koŕmoreg. ");
INSERT INTO fad_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Duak marak danah, Moses Ŕo isanig yan ge danah os mousko as nir kawa mundew ge, kamag as qe oko awagri nir os memandig. ");
INSERT INTO fad_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Sén os awag kamag 7 qere daréw, géri awlag digam as os wan, gam as qe nir kawa dewew gému qe mousan. ");
INSERT INTO fad_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mousew am dimugwari qe wan, am qe ole as nir kawa dewew mousan. ");
INSERT INTO fad_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Qe sillah kiam patak am atko 7 patak qe kunum ole as qe og, gam nir kawa dewew mouseg. ");
INSERT INTO fad_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Qe dimba as qe ole mousan. ");
INSERT INTO fad_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Am buliko sirak sénwa as qe awag kamag 7 qe kunum og, géri as qe oun waw darig?” éksi koŕmoreg. ");
INSERT INTO fad_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesus né qe noh meko anan, “Danahas wan ewa dasi ag nug usi. ");
INSERT INTO fad_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Gam Tiwur sew danahas mousak sireksi foumak olag ole qe nug wak ospi niew. ");
INSERT INTO fad_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ag saw doup sillah dalag, géri ag ospi mousweg. Ag Tiwurdi nir dalag, keŕdi ag Tiwur sew sireksi foumak olag. ");
INSERT INTO fad_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Am Moses ole ker nagur os aŕakri né yakwa ismige ge, mousak bulieksi sirlag. Qeri nug Naŕinah Tiwurdi ere anan, ‘Abrahamri Tiwur, Aisakri Tiwur am Yakopri Tiwur ole,’ eko anan. ");
INSERT INTO fad_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Géri ig Mosesri né qewa dotu ge Abraham, Aisak am Yakop ge Tiwur ole fou dasi. Keŕdi mousak danah Tiwur binag pi mési, gam danah fou dasi qe Tiwur binag mési. Keŕdi nug nohwa danahas nusgur ge kunum fou dasi,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mosesri Ŕo duak danah os Yesusri aneg, “Duak marak danah, na né noh mangu anam.” ");
INSERT INTO fad_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Qeri ounté koŕmak fou la ole ospi san. ");
INSERT INTO fad_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Am Yesus kuri danah qe koŕmaran, “Aregri ere ansi Kristus ge Dewit fuŕuh? ");
INSERT INTO fad_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","King Dewitri Kasi Yakwa ere ane, ‘Naŕinah Tiwur, Naŕinah dasil Kristusri anan: Na ewel kenariwa deppe, ");
INSERT INTO fad_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","da kegeŕ nasip taparko séwi nuksi na kallonwa dalag,’ eko ane. ");
INSERT INTO fad_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dewit nug ‘Naŕinah,’ eko anore, gam areg nug Dewit fuŕuh darig?” eko koŕmaran. ");
INSERT INTO fad_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Danahas kunum dueppeg Yesus bégur dilag anan. ");
INSERT INTO fad_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ag Mosesri Ŕo duak danah dilag dahmes. Ag feŕlag bala welah kena méksi maket awenwa weiyeppeg danahas piareksi felqarlagri sési. Am Yuda dilag binag mak lowa danah wenlag ole dasiwa dalagri sési. Am mallen sénwa danah wenlag ole dilag diak awenwa dalagri sési. ");
INSERT INTO fad_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ag as qehŕas dilag keke kunum darmak ihwa memeg mési am qe tonlagri dessi unuqorak welah welah sési. Danah qere ge sak nou noh asilag qe nouninah mardig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesus Tiwur Lougwa delle danah kehlag ole Tiwurdi ofa mak awenwa qarég meppeg piaran. ");
INSERT INTO fad_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Am nug as qehŕas os o duak ole qarég 10 toia aŕit ih ole mewew pian. ");
INSERT INTO fad_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Peko ge nug anan. “Da meŕenah anarina. As qehŕas uni o duak, gam nug qarég ofa mé ge, danahas uni kunum eŕarak naŕi mé. ");
INSERT INTO fad_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Danahas la kunum ge qarég asilag naŕi dewew am qarég siŕin ge méw, gam as uni ge o duak as gam nug keŕ os oko lellori sillah ge qarég qe kunum ole mé,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sén qewa nug bégur os aneg. “Tiwur Loug ene qar kena kenawa fueg am Tiwurdi ofa meg qewa bala moreksi koutoreg,” éksi aneg. Gam Yesus anan. ");
INSERT INTO fad_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Sén os uŕiyew ge, keke kunum pesi qe qiko neko kadduŕdig am qar usih os lia qaŕewa ospi dewew peweg,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ag koŕmoreg, “Duak marak danah, na anam keke qe ganehnah bérig? Ig keŕnah pektu am donig ge qe bérigri sén unaka de?” ");
INSERT INTO fad_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesus anan, “Geisah ag darmarwegra, dahméksi koutores. Geisah danah kuŕum da wénilwa béksi ‘Da Kristus,’ am ‘Geiri kuagŕak sén uŕiko malwé,’ éksi anlag. Gam danah qe aw dimlamarweg. ");
INSERT INTO fad_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Sén ag wan atu oswa fan neihwah am karak neihwah dueksi ge, ag aw faŕweg. Keke qe tatam belag, gam malwakri sén qe ofeŕ ospi bew.” ");
INSERT INTO fad_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yesus buliko anaran, “Wan atu os asweg wan atu la ole fan selag am king os asew king la ole fan selas. ");
INSERT INTO fad_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mim naŕi atu kuŕumba nérig am atu kuŕum laké naŕi niewew kousarlag am waŕe nouni ole belag. Am saw karan faŕakri keke am kowol wagé wagé ole béksi atlag. ");
INSERT INTO fad_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Gam keke qe kunum pi bak dewew, ag da dimlamiŕlag qeri oŕwareksi beŕwareksi Yuda dilag binag mak lo owa nolag am gurak maressi nouni saressi kalabuswa yanarlag. Am ag dieksi king am wan atu dilag kuri danah agop ole wanlag. ");
INSERT INTO fad_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sén qewa ag dasil olag meŕe me qe ag anarlagri sén darig. ");
INSERT INTO fad_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Qeri ag olag meŕe mak gagrag diar. Ag keŕ éksi anarlagri tatam aw dahmeweg. ");
INSERT INTO fad_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Da ag kegeŕ asilgar dilag né noh melagri né am dahmak kena ole mardil. Qeri ag kegeŕ asilgar né asilag ospi qeweg new am ospi kotaŕweg. ");
INSERT INTO fad_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sén qewa ag da dimlamiŕlag, qeri ag memelgar anilgar am awalgar kamalgar am leilgar ole kegeŕ marlag. Am geisah ag la os ge aqarweg mouslag. ");
INSERT INTO fad_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ag da dimlamiŕlag, qeri danahas kuŕum asilag olag nou mew kegeŕ marlag. ");
INSERT INTO fad_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Gam ag kurlag uŕug usihnah ospi lariewra, qeri ag aw faŕweg. ");
INSERT INTO fad_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ag da dahuhul dalag ge, ag foumak sansan diakri olag.” ");
INSERT INTO fad_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Sén ag fan danah uŕiyeksi Yerusalem o morweg peksi ge, ag dolag ge wagam kawa nug logaŕlag. ");
INSERT INTO fad_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sén qewa danahas Yuda dalag ge, kum oleksi qoukuwa ates. Am danahas taun qewa dalag ge, taun qe mineksi kum ates. Am areg os taun dimdim dalag ge, aw bulieksi owa noweg. ");
INSERT INTO fad_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Keŕdi sén qe Tiwur Yerusalem danahas kug asilag qe noh mardig am Tiwurdi Né yakwa nie qe kunum ole mou bérig. ");
INSERT INTO fad_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sén qewa ge, as olag ole am nir yu ole ge kug naŕinah pelag, keŕdi ag kum atakri olele kawa. Keŕdi kug narinah atu qewa bérig am Tiwurdi uhŕibak danahas qewari dilag qe noh meko mardig. ");
INSERT INTO fad_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Danahas os ge fan barinwa kotŕarlag. Am os ge oŕwareksi diareksi wan atu la kunumba kalabuswa atlag. Am Yerusalem taun ge Yuda danah kawa danah la qe tutuweg atew Tiwur sén moran qewa pattig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesus buliko anaran. “Sén qewa kowol os kemba kalamba am soŕwéwa ole beweg piarlag. Wanwa danahas kunum iw koŕkoŕ naŕi qelle urwag nérig qe dueksi olag faŕew am dahmak kaŕwarew kité ospi seweg. ");
INSERT INTO fad_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Danahas kuŕum wan ewa keŕ bérig qe peksi olag faŕew amlag taŕirig. Keŕdi saw karan keke gagragsak naŕi ole qe kunum sahaŕlag. ");
INSERT INTO fad_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Sén qe ge Danah Bega da lombigwa gagragsak naŕi ole am kamsahlak naŕi gun olewa uŕiyeppi kunum peiŕlag. ");
INSERT INTO fad_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Sén keke qe kunum digumeko bewew ge, ag gagrag méksi aminweg karan tew des, keŕdi Tiwur ag gattu owari buliko diarko kusqak mardigri sén unaka durig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesus né tonak ene bégur anaran. “Guŕaw ker am ker la ole piares. ");
INSERT INTO fad_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Sén ker qere lounweg ge, ag agégé dolag qe kem sén durig malwe. ");
INSERT INTO fad_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Qe sillah, da aném qere bew peksi ge ag dues. Wagam kawa ge Tiwurdi Kingdom bérig. ");
INSERT INTO fad_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Da meŕenah anarina. Geiri danahas pi mousak deppeg keke aném qe kunum bérig. ");
INSERT INTO fad_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Wan saw ole ge qeroŕdig, gam né dasil ge nagurnah ospi kawa mew.” ");
INSERT INTO fad_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Dahmessi des! Ag ke lelle am le leko gar qakri aw dahmeweg. Ag wan ewa kena diakri naŕi aw dahmeweg. Ag kowol qere séssi dalag ge, da agrowa pi dueppeg uŕiril. Keŕdi dasil uŕiyak deŕ qe pelem sillah darig. ");
INSERT INTO fad_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Geisah wanwari danahas kunum kug qewa dessi pelag. ");
INSERT INTO fad_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Dahméksi koutoressi am bulibuli Tiwurdi unuqorweg gagrag qarar. Qewa ge, kug belag qe eŕdessi deppeg Danah Bega da uŕiwi nolwa sirlag,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Yesus kemunwa deŕ dorog Tiwur Lougwa duak mardé. Am tuqan ge nug atko Oliw qoukuwa daré. ");
INSERT INTO fad_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Danahas kunum furwanah Tiwur Lougwa Yesus duak mardigri qaguldéw. ");
INSERT INTO fad_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yuda dilag mallen beret yis kawa oleri wénih Nanŕurak Deŕ qe unaka duan. ");
INSERT INTO fad_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Am pris dilag anqak danah am Mosesri Ŕo duak danah ole ag danahas faŕareksi larieksi Yesus oŕweksi qeweg mousdigri ih marieg. ");
INSERT INTO fad_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Sén qewa ge, nou memeg Satan, Yesus Bégur 12 qe olagwa usih os wénih Yudas Iskariotrer qe owa nuan. ");
INSERT INTO fad_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Now ge Yudas atew pris dilag anqak danah am Tiwur Loug gumakri felag tutu dilag kuri danah ole Yesus areg ag ewlagwa mérigri né marieg. ");
INSERT INTO fad_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Qeri ag olag gamag asew Yudas qarégwa daren morlagri né fag qeg. ");
INSERT INTO fad_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudas ag aneg qeri o niew digumeko ih are os peko, danahas pi dueppeg Yesus ag ewlagwa mérigri ih marian. ");
INSERT INTO fad_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Yuda dilag mallen beret yis kawa oleri qe duan. Deŕ qewa ge Yuda danahas Nanŕurak Deŕdi sipsip yu aqeksi mallen qewa lelagri sén. ");
INSERT INTO fad_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesus Pita Yon ole meŕatko anatan. “A ateksa Nanŕurak Deŕdi ke lakri isanig bawres,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Gam a koŕmores, “Naŕinah, i ke arewa bawarnit?” ");
INSERT INTO fad_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesus anatan, “A Yerusalem taunwa noksa ge danah os le witko mouko wanew pelas. Peksa ge, dimlamurwes lo nug nurig ole qewa nos. ");
INSERT INTO fad_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Sén a lo qewa noksa ge, lo memeg ere koŕmores. ‘Duak marak danah nasip ere ané: Da Beglar 12 qe ole kurug arewa Nanŕurak Deŕdi ke lenig?’ eksa anes. ");
INSERT INTO fad_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Lo memeg ge lo karan awen naŕi os tewol ole keke kunum bawrak ismattig. Qewa ge, ig Nanŕurak Deŕdi ke lenigri bawres,” eko anatan. ");
INSERT INTO fad_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","A ateksa ge, Yesus anan qe sillah keke kunum pes. Peksa ge, Nanŕurak Deŕdi ke qewa bawres. ");
INSERT INTO fad_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sén Nanŕurak Deŕdi ke qe lakri dow ge, Yesus aposel nusgur 12 qe ole lo qe karan ke bawres awen qewa tewol o moreksi ninaqiŕeksi deg. ");
INSERT INTO fad_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Dessi ge, nug anan. “Da ol naŕi nie ge ag ole Nanŕurak Deŕdi ke ene léktu tatam am da gurak oko mousdil. ");
INSERT INTO fad_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Da anarina. Da Nanŕurak Deŕdi ke fou la ospi léwin atew ole mallen ene digu ambo meko Tiwurdi Kingdomwa bérig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Anko malako ge, Yesus wain kapwa qériak oko, Tiwurdi kena sam elle unuqorko Bégur dilag anan. “Ene uksi aŕié les. ");
INSERT INTO fad_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Da anarina. Gei digumak da buliko wain ospi léwin atew sén uŕiyew Tiwur wan eneri King bérig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Am Yesus beret os oko, Tiwurdi kena sam elle unuqorko temew nounu new marko anan. “Ene ge da féŕul. Da asilag seko mardil. Ag ere sesissi da dahmires,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ke léksi malweksi ge, Yesus kap wain ole os oko ge anaran. “Wain kap owa ene da karal. Qewa Tiwur titwanak fou danahas dilag sérig. Da karal qe asilag seko gogoŕdig. ");
INSERT INTO fad_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Gam ag peksi! Danah da kegeŕ ewlagwa meiŕdig ole qe da ole tewol usihwa aŕié ke leŕu. ");
INSERT INTO fad_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Danah Bega ge Tiwur ih man qewa mousdig. Gam danah oun nug kegeŕ ewlagwa mérig ole qe ge nug kug os perig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Sén Bégur ag né qe dueksi ge, ag agégé ounnah qere sérig essi koŕmeweg wane meweg duan. ");
INSERT INTO fad_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesus Bégur ag agégé oun asilag naŕi qeri néwa ih kareg. ");
INSERT INTO fad_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Karweg ge, Yesus anaran. “King wan eneri ge gagragsak asilagwa danahas gumaressi bilagwa qesi. Am wan ewa danah gagragsak ole qe ag danahas kehnarak danah éksi anarlagri feŕlag mési. ");
INSERT INTO fad_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Gam ag ge qere aw seweg. Oun os asilag naŕi de ge, nug danah sam sillah ag kallolagwa diar. Am danah oun ag gumardig ole ge nug asilag kekuak nir sillah diar. ");
INSERT INTO fad_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Qeri da koŕmarina. Oun ge danah naŕi? Danah tewolwa sam dewew ke bawreksi morweg le ole qe te? Kawa, danah ke bawre ole qe te? Ag dosi ge danah tewolwa de qe ge danah naŕi. Gam da ge enan. Ag olagwa danah ke bawarko mare ole qe sillah deina. ");
INSERT INTO fad_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ag da ole kug dasil kunumba datu. ");
INSERT INTO fad_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Géri Mem da king delle danahas gumardilri kekuakri gagragsak miŕan. Qe sillah ag ole danahas gumarlagri kekuakri gagragsak marina. ");
INSERT INTO fad_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Qeri Kingdom dasil owa ag ole tewol dasilwa aŕié dettu ke am le ole léksi am kingri sia awen awenwa dessi Israel ateŕ 12 qe gumarlag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesus Saimonri anan. “Saimon, Saimon, na doka. Reis ulaswa gogreppeg kéwsi am kar ole yalew ate qe sillah Satan o meŕe mak asilag qeperigri koŕman. ");
INSERT INTO fad_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Gam Saimon, da na ot meŕe mak pi tolwewri unuqurin. Géri sén na ot buliew dagnewa bulika doka ge, kuak usih leipar olag meŕe mak gagrag qor,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Anew, Pita anoran. “Naŕinah, da na dimlamirwi ole aŕié kalabuswa atnit am mousnitri ole bawrém deina.” ");
INSERT INTO fad_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesus koŕewa oko anan, “Pita, da anirina. Na keŕew furwa maru pi gelak, na kiam patak da pi duiŕna eka andip,” eko anoran. ");
INSERT INTO fad_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Qe dimba Yesus Bégur dilag anan. “Sén tatam da kuak marwi ateg ge, ag qarég yanakri sogot, baram, am félag gaŕa aw oweg eko anin. Sén qewa ag kitéri os qagreg te?” “Kawa,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesus anaran, “Gam gei ge oun os sogotwa qarég ole ge war am baram ole os. Am oun os fan barin kawa ole ge siot qaŕewari qe qarégri mew oweg am fan barin os daren mar. ");
INSERT INTO fad_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tiwurdi Né yakwa ane, ‘Danahas nug ŕo tapewnak danah sillah peg.’ Am Né yakwa dasil ane qe olele murdig am dasil Né yakwa ane qe sén mou bérigri qe unaka do,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Anew nug Bégur aneg, “Naŕinah, fan barin aŕit enan,” éksi anweg am Yesus anan. “Malwew, qe olele,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesus sansan seré sillah Oliw qoukuwa atewew Bégur ole dimlamurweg aŕié ateg. ");
INSERT INTO fad_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ateksi ge, Bégur anaran. “Ag qepiakwa pi tolaweg qeri Tiwurdi unuqores,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nug Bégur minarko nagur lawaŕ qar touŕweg atko qe, qe sillah wanko ge gatewa yako delle unuqoran. ");
INSERT INTO fad_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Unuqorko anan, “Mem, na ot niew pe, na kug naŕinah wiŕdig ene moutina miŕ. Gam da ol mourak aw dimlamurwen, na ot mourak qe dimlamur,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Anew ge, saw kappari Tiwurdi doup os gumurko doko nug gagrag qoran. ");
INSERT INTO fad_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesus kug naŕinah doko gagrag unuqoran. Unuqorewew ge séŕi qeko karag sillah katŕe katŕe wanwa nan. ");
INSERT INTO fad_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nug unuqorak malako asko ge, buliko Bégur agop wanan. Wanko ge, ag olag kug qew usnieppeg piaran. ");
INSERT INTO fad_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Piarko ge anan, “Ag keŕdi usnisi? Aseksi qepiak uŕiyew tolawegra unuqores,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesus né mariewew, danah ameg naŕi teg. Yesus Bégur qe olagwa usih os wénih Yudas qe omlarew teg. Nug Yuda koulagwa Yesus kiss murdigri unaka wanan. ");
INSERT INTO fad_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wanew Yesus anoran, “Yudas, na Danah Bega da kegeŕ ewlagwa méiŕdipri te kiss miŕdip sena?” ");
INSERT INTO fad_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Sén Yesus Bégur ag kug bérig sew peksi ge, koŕmoreg. “Naŕinah, ig fan barinwa fan sénig te?” ");
INSERT INTO fad_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Bégur qe usih os fan barinwa pris dilag kuri danahri kekuak nir doug kenari qe seiyan. ");
INSERT INTO fad_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesus qere peko ge anan, “Aw! Malwam genan,” elle doug oko meko lamsiew buliko duŕduan. ");
INSERT INTO fad_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesus pris dilag anqak danah, Tiwur Lougri felag tutu am Yuda dilag kuri danah ole nug oŕalagri uŕiyeg qe dilag anan. “Ag tapewnak danah te oŕalagri fan barin am ker qetak ole kahweksi uŕiyew? ");
INSERT INTO fad_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Da ag ole deŕ dorog Tiwur Lougwa daram, gam ag da ospi uŕwileg. Am gei ge asilag sén gatturi gagragsak ag gumare,” eko anaran. ");
INSERT INTO fad_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Anko malwew ge, Yesus oŕweksi omleksi pris dilag kuri danah qe lougwa ateg. Ateppeg ge, Pita nug dimqeko nagur lawaŕ qere dimlamaran. ");
INSERT INTO fad_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Danah os kaŕ owa lo ihŕamba kew yaleksi uŕgessi deppeg, Pita ole wanew qere kew o moreksi deg. ");
INSERT INTO fad_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Lo qewari kekuak as os Pita kew uŕgelle dewew peko kitturko de de ge anan. “Danah ene ole Yesus dimlamdak weiréw,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Gam Pita anan, “Kawa, da danah qe pi duina,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Am wagam kawa danah os peko anan, “Na os ole enan,” eko anan. Anew Pita anan, “Kawa, da ole kawa.” ");
INSERT INTO fad_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kem ameg usih keke qere atew ge, danah os gagrag anan. “Meŕenah! Danah ene Galilirer, qeri nug Yesus ole weiréw,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Anew Pita noh meko anan, “Na kitéri té marina ge da pi duina,” eko anewew ole maru gelan. ");
INSERT INTO fad_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Sén qewa ole Naŕinah buliko mangu ole Pita amegwa amnan. Pew ge Pita Naŕinah ere anoran qe dahmoran. “Na keŕew furwa maru pi gelak, na kiam patak na da pi duiŕna eka andip,” eko anan qe dahmoran. ");
INSERT INTO fad_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita dimdim wanko delle ge, owa qetko atew qalko kuanan. ");
INSERT INTO fad_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Tiwur Lougri felag tutu Yesus gumessi deg qe nug diguméksi siwegkolessi am koreg. ");
INSERT INTO fad_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ag Yesus lamenwa ameg qageksi koreksi am koŕmoreg. “Na profet daka pe, anwe duet. Oun na kuiré?” ");
INSERT INTO fad_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ag né nouni kowol kowol Yesusri aneg. ");
INSERT INTO fad_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kuagŕew ge Yuda dilag kuri danah, pris dilag anqak danah am Mosesri Ŕo duak danah ole qagulweg ge, Yesus omleksi qaglak qewa waneg. ");
INSERT INTO fad_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Kuri danah wagé wagé qe Yesus koŕmoreg. “Na anwe duet. Na Kristus qenan te?” éksi aneg. Yesus koŕlagwa oko anan, “Da anwi ge, ag dasil olag meŕe ospi mew. ");
INSERT INTO fad_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Am da os ag koŕmardil ge, ag né qe noh ospi meweg. ");
INSERT INTO fad_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Gam gei digumeko atak Danah Bega Da Tiwur gagragsak ole eweg kenariwa daril,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Anew danah wagé wagé qe kunum bulieksi koŕmoreg. “Qenan géri na Tiwur Bega te?” éksi anweg, nug anan. “Ag anéw ge da qenan.” ");
INSERT INTO fad_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Qewa danah wagé wagé aneg, “Ig né gagrag qorakri né la ospi marihut. Ig igégé nou nusig qe nug koŕewa duam qe olele,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Yudari kuri danah wagé wagé qe kunum qaglakwari aseksi Yesus omleksi Pailot dowa ateg. ");
INSERT INTO fad_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Qewa ge nug diguméksi yagoŕ moreksi aneg. “Ig danah ene danahas isangar nouni omlardig sew pet. Am Sisari takis pi touŕwegri doulagwa nolle am ole nug ane, ‘Da Kristus am da king,’ eko anew oŕwektu uktu uŕiyam,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Géri Pailot Yesus koŕmoran, “Meŕe te na Yuda danah dilag king?” Yesus né noh meko anan, “Na anam qenan.” ");
INSERT INTO fad_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailot pris dilag anqak danah am danah ameg naŕi ole dilag anan. “Da danah ene piém ge nug kité nouni ospi san.” ");
INSERT INTO fad_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gam ag duessi bulibuli gagrag aneg. “Nug Yudia atu kunumba weiyelle né mariyelle danahas olag ye. Nug Galili tatam diguman am gei ge ewa uŕiyan se,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Sén Pailot qere doko ge nug koŕmaran. “Danah ene Galilirer te?” ");
INSERT INTO fad_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ag koŕewa uksi aneg, “Yo, nug Galilirer.” Pailot qe doko ge, ag Yesus uksi king Herod dowa ates eko anaran. Keŕdi Herod nug Galili gumdé am sén qewa Herod nug ole Yerusalem dian. ");
INSERT INTO fad_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Sén nug Yesus peko ge, o gamag naŕi asan. Keŕdi nug Yesus neihwah maŕiweg doko sén welah perigri o nian. Am nug Yesus mirakel os sew piardigrinah dahmeré. ");
INSERT INTO fad_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Qeri Herod Yesus koŕkoŕ moran, gam Yesus koŕewa ospi wan. ");
INSERT INTO fad_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pris dilag anqak danah am Mosesri Ŕo duak danah ole qewa dessi ge, Yesus gagragnah yagoŕ moreg. ");
INSERT INTO fad_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Qe dimba Herod fan danah nusgur ole Yesus uksiuksi qoressi siwegkolessi kingri bala kena uŕwurweg now uksi Pailot dowa bulieksi ateg. ");
INSERT INTO fad_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tatam ge Herod am Pailot ole a olas usih pi daré, gam deŕ qewa ih ole a liam pates. ");
INSERT INTO fad_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailot anew pris dilag anqak danah, danahas gumarak danah am danahas ole qagleg. ");
INSERT INTO fad_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Qagulweg nug anaran, “Ag danah ene uksi dagnéwa uŕiyeksi anéw, ‘Nug danahas isangar nouni omlardigri olagwa ye,’ éksi anéw. Gam da ag nolagwa koŕmorko piém ge, ag yagoŕ moreksi aneg sillah nug kité nouni ospi san. ");
INSERT INTO fad_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Qeri Herod ole qere peko mew buliko ignéwa uŕiyé. Danah ene anwi qeweg mousdigri sillah kité nouni ospi san piém. ");
INSERT INTO fad_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Qeri da anwi siwiŕwa qisleksi am paŕoweg attig.” ");
INSERT INTO fad_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Pailot qere anan, keŕdi sansan Nanŕurak Deŕwa kalabus danah usih os danahas ag nusig olag nie ole qe paŕoweg doko dimdim ate.) ");
INSERT INTO fad_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Gam danahas kunum uŕweksi aneg. “Danah qe qewe mousar! Barabas matulwe do migar!” ");
INSERT INTO fad_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas nug sew Yerusalem taun gumak danah Yuda dilag danahas ole karak naŕi seg am nug danah os ole qew mousan. Qeri nug kalabuswa yaneg. ");
INSERT INTO fad_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailot nug Yesus mundew attigri o dian, qeri buliko danahas koŕmaran. ");
INSERT INTO fad_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Gam danahas bulibuli uŕweksi aneg, “Ker mawanakwa katul! Ker mawanakwa katul!” ");
INSERT INTO fad_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailot kiam patak danahas anaran, “Kitéri? Nug keŕ kugnah san, qeri anwi qeweg mousdig? Danah ene qeweg mousdigri sillah kité nouni ospi san piém. Géri qisleksi am paŕoweg attig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Gam gagragnah uŕweksi Yesus ker mawanakwa katlakri aneksi Pailotri né qeweg nan. ");
INSERT INTO fad_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Géri Pailot minko ag aneg qe dimlamurko Yesus qeweg mousdigri anan. ");
INSERT INTO fad_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Yuda aneg sillah, Pailot anew tapewnak danah Barabas nug sew Yerusalem taun gumak danah Yuda dilag danahas ole karak naŕi seg am nug danah os ole qew mousan, qeri kalabus dian qe matlew duan. Am Yuda olag nian sillah, Yesus ge qelagri Rom fan danah ewlagwa man. ");
INSERT INTO fad_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Qewari ge ag Yesus uksi taun dimdim ateppeg danah os wénih Saimon Sairinirer qe uŕiko taun owa nurig sewew oŕweg. Oŕweksi keigoreksi ker mawanak sumeksi guqawa meweg mouko Yesus dimlamdan. ");
INSERT INTO fad_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Danahas ameg naŕi Yesus dimlamdeg. Qe olagwa as os Yesusri kunnessi dimlamareg. ");
INSERT INTO fad_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesus piarko anaran. “Yerusalem as, ag dasil aw kuanweg. Ag agégé asilag am nir nounou asilgar ole dilag kuanes. ");
INSERT INTO fad_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Keŕdi geisah sén os uŕiyew danahas anlag, ‘As olagwa nir kawa, as nir pi memnak am as ouma asilag nir ospi lak ole qe ge kena.’ ");
INSERT INTO fad_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sén qewa danahas qouku wagé wagé am nounu dilag ole anlag, ‘Ag néksi tonigweg mouset,’ éksi anlag. ");
INSERT INTO fad_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Keŕdi ag da kité nouni ospi séwi am qere siŕlag ge, ag ge nouninah sarlag,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Sén qewa Rom fan danah tapewnak danah aŕit os Yesus ole aŕié ker mawanakwa katlarlagri diareksi ateg. ");
INSERT INTO fad_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ateksi awen os wénih mousak danah kuri kéwsi éksi ansi qewa ge Yesus ker mawanakwa katleg. Am tapewnak danah aŕit qe os ge kenariwa katleksi am la os ge nanettiwa katleg. ");
INSERT INTO fad_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesus unuqorko anan, “O Mem, hipunin asilag kusuq. Keŕdi danah ene duessi pi sési,” eko unuqoran. Danah ameg naŕi amneksi deppeg fan danah ag oun Yesus féŕu bala qe urigri ker masawa namba yeksi touressi sagoŕweg. ");
INSERT INTO fad_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Am Yuda dilag kuri danah Yesusri né siwkolessi aneg. “Nug danahas la ge kehnarko kusqaran. Géri gei ge nug meŕenah Kristus Tiwur toqoran dako pe, nug nugégé kusqak urig,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Fan danah ole Yesusri né siwkolessi unaka waneksi wain qew morlagri seg. ");
INSERT INTO fad_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Qere séssi aneg, “Na Yuda dilag king daka pe, na nagégé kusqak o,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Karan kuriwa ker mawanakwa ker masa oswa né os ere yak qe dian. “Ene Yuda Dilag King.” ");
INSERT INTO fad_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Danah nou os aŕié ker mawanakwa katlareg ole qe Yesus okoko qorko anan. “Na Kristus meŕe Tiwur toqiran dew pe, na nagégé kusqak oka am i ole sewe kusqak oŕ.” ");
INSERT INTO fad_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Gam tapewnak danah os ge lia gaŕa morko anoran, “Na nug mousdig sillah ih usih qewa mousdip, qeri na Tiwur pi te faŕurna? ");
INSERT INTO fad_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","I ge isanit sak nou qe ih noh mawekŕu mousnit, gam nug ge kité nouni ospi san,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Anko ge Yesusri anan, “Yesus na king beka ge, da dahmiŕ.” ");
INSERT INTO fad_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesus koŕewa oko anan, “Da meŕenah anirina. Na gei da ole paradaiswa danit,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kémun kem ameg 12wa keke qere usihri atu qe kunumba gattu tonko niewew atko tueh kem ameg 3wa keke qere malwan. ");
INSERT INTO fad_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Kem ameg oŕwew gattu tonko niewew, Tiwur Lougwa gun awen owa lamen naŕi eisak nian ge gamagwa karilko neko aŕit patan. ");
INSERT INTO fad_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Géri Yesus gagrag uŕuko anan, “O Mem, da koullil na ewenwa meina,” elle ole mousan. ");
INSERT INTO fad_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Sén Rom fan danah dilag kuri qe kunum peko ge Tiwur binag meko anan, “Meŕenah, danah ene mangunah,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Am danahas kunum qe pelagri uŕiyeg ge peksi olagwa qetko atew bulieksi loulgarwa ateg. ");
INSERT INTO fad_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Gam danahas Yesus doréw qe kunum ole am as Galiliri dimlamdeksi uŕiyeg qe ole lawaŕ asessi dessi keŕ keŕ beko atan qe kunum ole peg. ");
INSERT INTO fad_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Danah os wénih Yosep nug Yudia atu owa taun Arimatearer am nug ole Yuda dilag kuri danah qaglak qewa delle kug kepaŕdé. Nug danah kena am danah mangu am nug Tiwur king delle danahas nusgur gumardigri sén qe ameg meré. ");
INSERT INTO fad_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nug ole Yuda dilag kuri danah qagleksi kug peréw qewa daré. Gam nug kuri danah la aneg am seg qeri o olele ospi dian. ");
INSERT INTO fad_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nug Pailot dowa atko Yesus gaŕa oko suhumdigri koŕmorew, Pailot mundew wan. ");
INSERT INTO fad_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Géri nug Yesus gaŕa ker mawanakwari oko neko lamen kena sagahwa saputko am oko atko matmat os qar oŕe kutlak qewa man. Matmat qe fou am danah gaŕa la ospi mak ole. ");
INSERT INTO fad_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Deŕ qe Sabatri keke bawrak sén, am Sabat digumerigri sén unaka duan. ");
INSERT INTO fad_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","As Yesus dimlamurweg Galiliri uŕiyeg qe Yosep dimlamurweg matmatwa ateg. Ag Yesus gaŕa areg matmatwa meg qe pelagri ateg. ");
INSERT INTO fad_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Peksi ag bulieksi loulagwa ateksi ge, goŕen muŕdig kena ole qe Yesus gaŕa waŕwurlagri bawreg. Malaweg ge Sabat diguman. Géri Mosesri Ŕo dimlamdak ag sik og. ");
INSERT INTO fad_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Kuhawa furwanah as os goŕen muŕdig kena ole bawreg qe uksi matmatwa ateg. ");
INSERT INTO fad_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ateksi qewa ge, matmat koŕe megleg qar naŕi qe bitlew dougwa wanak dewew peg. ");
INSERT INTO fad_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Peksi ole ag owa nog, gam Naŕinah Yesus gaŕa qewa ospi peg. ");
INSERT INTO fad_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Qeri ag katat aqarew aseksi deppeg ge, usihri danah aŕit bala ampiŕ sonŕe sillah mak ole qerlagwa aseksa des. ");
INSERT INTO fad_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","As qe faŕeksi nou méksi duk nuksi gatlagwa yeksi wan kittureksi deppeg ge, danah aŕit qe anes. “Ag danah gei fou de ge keŕdi mousak danah dilag awenwa marisi? ");
INSERT INTO fad_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nug ewa os kawa. Nug mousan gam buliko asan. Nug Galili dessi keŕ eko anaran qe dahmores. ");
INSERT INTO fad_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nug anan, ‘Danah Bega hipunin danah ewlagwa meweg ker mawanakwa katulweg mousdig, gam deŕ kiamba buliko asdig,’ eko anan.” ");
INSERT INTO fad_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Qewa ge, ag Yesus anan ge bulieksi dahmoreg. ");
INSERT INTO fad_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","10","As qe Maria Makdalarer, Yoana am Maria Yems anig am as la os ole aŕié matmatwa ateg. Ag bulieksi matmatwari louw ateksi ge, Bégur 11 qe am danahas la Yesus dimlamurdéw ole qe kunum keŕ keŕ ban qe anweg dueg. ");
INSERT INTO fad_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Gam ag as né aneg qe ulas né essi olag meŕe ospi man. ");
INSERT INTO fad_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Gam sén Pita asko guko atko duk noko amnew matmat oŕe owa now ge, lamen sapteksi meg ole qe ih qewa niewew pian. Peko ge, keŕ keŕ ban qeri dahmew te mew newew buliko louw atan. ");
INSERT INTO fad_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Deŕ qewa ih Yesus dimlamdak danah aŕit os Emeus kappa atlasri ates. Yerusalemri Emeus atak ge 11 kilomita sillah. ");
INSERT INTO fad_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","A até até keŕ keŕ Yerusalem ban qe kunum mariessa ates. ");
INSERT INTO fad_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","A qeri mariessa suŕiessa ateppes ge, Yesus nugégé dow ole aŕié ateg. ");
INSERT INTO fad_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","A pes, gam nug oun qe a olas ospi mouran. ");
INSERT INTO fad_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nug koŕmatan, “A kitérinah né mariessa atsa?” A olasnah dow kilas nou mew aseksa des. ");
INSERT INTO fad_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Danah os ge wénih Kliopas qe asko koŕmoran. “Na Yerusalemri uŕina, gam na nagé té deŕ gane atan qewa keŕ keŕ ban qe ospi duen?” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Anew ge, nug koŕmatan. “Keŕnah ban?” eko anew, a koŕewa oksa anes. “Nasaretrer Yesusri né mariŕu. Nug gagragsak naŕi ole né marian am keŕ keŕ san. Qewa ge, Tiwur amegwa am danahas amlagwa ole nug profet gagragsak ole. ");
INSERT INTO fad_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Gam pris dilag anqak danah am gumarak danah isanig ole oŕweksi ewlagwa meweg ker mawanakwa qeweg mousan. ");
INSERT INTO fad_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ig Israel nug ig kug owari buliko wigrigri onigwa niewew dahmoretu weiram. Gam qenan ih kawa, qeweg mousan am gei ole deŕ kiam ate, gam kité ospi be. ");
INSERT INTO fad_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Am as isangar os gei furwanah matmat nusigwa ateksi am bulieksi uŕiyeksi seweg durnig new katat iqé. ");
INSERT INTO fad_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ag Yesus gaŕa qewa ospi niewew piéw, gam Tiwurdi doup piatweg Yesus buliko asé eksa anap. ");
INSERT INTO fad_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Danah isanig os matmatwa ateksa ge, as anéw qe sillah ole Yesus gaŕa qewa ospi piap,” eksa anap. ");
INSERT INTO fad_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Géri Yesus anan, “A dahmak kutuk ole. Profet dilag né yak algurer nie, gam ag nagur olag meŕe ospi me. ");
INSERT INTO fad_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ag pite dosi ge Kristus kug naŕi ene oko mousko tatam am buliko asko ge kamsahlak gun olewa darig?” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Am nug digumeko Mosesri am profet la kunum dilag Né yakwa nugégé nusig yeg qe kunum a dolasri nug digu kusuko ismatan. ");
INSERT INTO fad_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ag kaw ateg ole qe mourak waneksi ge, Yesus nug kaw qe éŕurko attigri san. ");
INSERT INTO fad_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Gam danah aŕit qe gagrag meksa anes, “Na i ole ninig, keŕdi ene gattu mane am kem noko malwé,” eksa anes. Géri nug a ole nilagri louw ateg. ");
INSERT INTO fad_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ag ke lelagri aŕié dessi ge, Yesus beret os oko Tiwurdi kena sam elle unuqorko temko matan. ");
INSERT INTO fad_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Qere sew ge, usihri a amlas fur kougwew peksa olas mouran ge nug Yesus. Gam a sén qewa nug ospi peppes ole qeroŕan. ");
INSERT INTO fad_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","A atété né marieksa anes. “Ig ihwa uŕiyettu nug Tiwurdi Né yak digu kusuko marié ge kuŕunit koré,” eksa anes. ");
INSERT INTO fad_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Géri a usihri aseksa ole Yerusalem bulieksa ates. Ateksa qewa ge Yesus Bégur 11 qe am leilgar la ole qagulweg piares. ");
INSERT INTO fad_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Qewa ge aneg, “Meŕe! Naŕinah buliko asan am ole Pita gumurko wanew nug pian,” éksi aneg. ");
INSERT INTO fad_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Am danah aŕit Emeusri qe a attowa keŕ keŕ ihwa san qe marieksa am beret temko matew ge peksa olas mouran qeri anes. ");
INSERT INTO fad_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Sén ag né qeri marieppeg, Yesus nugégé gumarko doko olagwa qere asko delle anan. “Tiwur o maror ag ole dalag.” ");
INSERT INTO fad_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ag peksi ole dore piam essi olag faŕko nou man. ");
INSERT INTO fad_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Gam Yesus anan, “Ag keŕdi faŕessi am olag aŕit ole de? ");
INSERT INTO fad_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Da ewel fél ole duŕfal ene pes. Da enan! Uŕwileksi pes, da dore os kawa. Keŕdi dore ge téhu am kéwsi ole kawa.” ");
INSERT INTO fad_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nug qere anko ge eweg am fég ole ismaran. ");
INSERT INTO fad_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ag olag gamag asewew dahmak kuŕum og, qewa ag olag meŕe ospi man. Qeri Yesus koŕmaran, “Ag kité lakri ewa os de te?” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Anew ge ag kaké aŕak os uksi moreg. ");
INSERT INTO fad_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Morweg ge, nug oko ag peppeg ole lan. ");
INSERT INTO fad_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nug anaran, “Da ag ole dettu anarin. Mosesri Ŕo yakwa, profet dilag Né yakwa am Dewitri Kasi Yakwa dasil ane qe kunum meŕenah mou bérig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Anko ge, nug Tiwurdi Né yak olag mourdigri sew dahmak asilag matlan. ");
INSERT INTO fad_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Nug anaran, “Tiwurdi Né yakwa ane, ‘Kristus qe nug kug naŕi oko mousko am deŕ kiamba ge buliko asdig. ");
INSERT INTO fad_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Danahas olag buliew Tiwur dowa doweg am hipunin asilag kusuqrigri né qe nug wénihwa danahas kunum agop ag Né Kena qe kusulag. Am qe Yerusalem digumelag,’ eko ane. ");
INSERT INTO fad_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ag qe ih keŕ keŕ ban peg qe kunum ole mariweg dues. ");
INSERT INTO fad_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Da Mem né fagqan qe dimlamurko Koulli Gun méwi uŕirig. Am ag taun ewa ih daweg atew Tiwur gagragsak mardig,” eko anan. ");
INSERT INTO fad_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Qe dimba Yesus bégur omlarew taun paŕweksi Betani mourak ateksi eweg sumko wittak maran. ");
INSERT INTO fad_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nug wittak marewew Tiwur sumko oko tew minarko saw kappa atan. ");
INSERT INTO fad_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Géri ag Yesus binag méksi am olag gamag asak naŕiwa bulieksi Yerusalem ateg. ");
INSERT INTO fad_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Am ag Tiwur Lougwa dessi Tiwur binag sumdéw.");
ALTER TABLE fad_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
