﻿USE sofia;
DROP TABLE IF EXISTS sofia.faa_vpl;
CREATE TABLE faa_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES faa_vpl WRITE;
INSERT INTO faa_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Éparahamemo aporo ira wainepe pesa á Yasu faserepesane oyapo. Yasu Keresomo makasa kaua kekemane Téfetepo. Téfetemo makasa kaua kekemane Éparahamepo. ");
INSERT INTO faa_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Éparahamemo ipi maeyane Aísakepo. Aísakemo ipi maeyane Yákopepo. Yákopemo aporo hokosa hokono murisiapo. Hokono murisiane meta Yútapo. ");
INSERT INTO faa_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yútamo ipi hinamo Téma arumaka aporo hokosa teta hokono maresane meta Sérapo, meta Péresepo. Péresemo ipi maeyane Héseronepo. Héseronemo ipi maeyane Rámepo. ");
INSERT INTO faa_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rámemo ipi maeyane Amínatapepo. Amínatapemo ipi maeyane Násonepo. Násonemo ipi maeyane Saómonepo. ");
INSERT INTO faa_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saómonemo ipi hinamo Réhape arumaka aporo hokosa hokono maresane Póasepo. Póasemo hinamo Rúte arumaka aporo hokosa hokono maresane Opetepo. Opetemo ipi maeyane Yésepo. ");
INSERT INTO faa_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yésemo ipi maeyane Téfetepo. Téfete ane ipi unihaeaka reapo. Téfetemo Yurayamo hinamo yaroane arumaka hokosa hokono maresane Sóromonepo. ");
INSERT INTO faa_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sóromonemo ipi maeyane Ríapomepo. Ríapomemo ipi maeyane Apaísapo. Apaísamo ipi maeyane Ésapo. ");
INSERT INTO faa_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ésamo ipi maeyane Yihósafatepo. Yihósafatemo ipi maeyane Yóramepo. Yóramemo ipi maeyane Usáyapo. ");
INSERT INTO faa_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usáyamo ipi maeyane Yótamepo. Yótamemo ipi maeyane Éhasepo. Éhasemo ipi maeyane Hesekáyapo. ");
INSERT INTO faa_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekáyamo ipi maeyane Manásapo. Manásamo ipi maeyane Émonepo. Émonemo ipi maeyane Yosáyapo. ");
INSERT INTO faa_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosáyamo ipi maeyane Yakóyakinipo. Arirakano Yosáyamo aporo hokosa metakira soko hokono murisiapo. Yosáyamo hokosa hokono murisia maiya amo Isiraya aporo ane tipura keako Pápirone hauaka á karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Karikia pusuakipoko Yakóyakinimo ipi maeya hokono maresane Siátiopo. Siátiomo ipi maeyane Serápapeopo. ");
INSERT INTO faa_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serápapeomo ipi maeyane Apiútepo. Apiútemo ipi maeyane Eraíyakimepo. Eraíyakimemo ipi maeyane Ésopo. ");
INSERT INTO faa_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ésomo ipi maeyane Sétokepo. Sétokemo ipi maeyane Ékimepo. Ékimemo ipi maeyane Eriútepo. ");
INSERT INTO faa_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriútemo ipi maeyane Ereásapo. Ereásamo ipi maeyane Mátanepo. Mátanemo ipi maeyane Yákopepo. ");
INSERT INTO faa_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yákopemo ipi maeyane Yósefepo. Yósefemo ipi hinamoane Maríapo. Maríamo hokosa takapesane Yasupo. Yasu ipi unihaeaka rekeasimo Kotimo máfaraka maresasamo ipi yano motosa Keresopo. ");
INSERT INTO faa_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Asiamo Eparahamemo aporo ira wainepe pusuane menorape pukua, senakiane (14) Tefetepo. Tefetemo aporo ira wainepe pusuane menorape pukua, senakiane (14) Pápirone hauaka á tipura keako pusua maiya amo aporo hokosa hokono maresa ayapo. Pápirone hauaka á tipura keako pusua aeyaka kepomarekea menorape pukua, senakiane (14) Keresopo. ");
INSERT INTO faa_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yasu Kereso takapesane oyapo. Ipi kaīyia Maria ane Yosefemo arumakasiraka fairaka rea maiya amo, Maria tua Ho Kotesamo hokosa makerakano umisapo. ");
INSERT INTO faa_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Umirakano asekea Maria faisa aporo Yosefeane ipi tau reke, somemane motosane kekemaraka tau keneamo reasasamo epo hemakapuraka, “Maria aporo metayaki purakanareapo. Asiamo eaki kára hukuruane aporo suamo e makaiyanapaka faisane tau metakariakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Aíyaka hemakapukua reakipoko, kituamo Unihae Kotimo hepene aporo peraka Yosefeaki someraka, “Tefetemo aporo ira Yosefeo. Ní hinamo Mariane arumako karekekea metakariakopo. Ni apea Mariane karikia punie. Ipi umisa akayane Ho Kotesamo hokosa eaki makesapo. ");
INSERT INTO faa_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Hokosane aporo hokosa takapeakosapo. Takaperakano e yano motoraka Yasu yano motoanie. Yasu yano motosa kepoamo Isiraya aporo hinamomo makata watikisane rakiraka risikino, i fanasinapaka epo mafasiakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","25","Airakano Yosefe turikia puraka Unihae Kotimo hepene aporomo somesane kakimaka, Mariane ipi apea karikia pusuapo. Pukua Maria hokosa takapeasiraka kaya maiya amo, Yosefe eyaki hakāsa yao pusuafapo. Maria umiraka kayane aporo hokosa takaperakano asekea hokosane yano motoraka Yasu yano motosapo. Yasu pesane, makata ane su ayiakasiraka, wate fana porofete aporomo Kotimo someane kaikia sawia popasapo. Sawia popasane oyapo. “Kaisie, hinamo sakora umiraka kakakosapo. Umiraka kaina aporo hokosa takapeakosapo. Takaperakano e yano motoraka Emánio yano motoanie,” aíyaka Unihae Kotimo somerakano porofete aporomo kaikia popahoareapo. Popasane faserepesa ayareapo. Arirakano namo meaka Emánio yano motosa kepoane, Kotiane isuyaki rekenapo. Aíyaka yano motosapo. ");
INSERT INTO faa_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herote unihaeaka rea maiya amo, Yutía hauaka á Petereheme taonea Yasu takapesapo. Takapesa maiya amo, maiya apera taku aeyaka ti makata asera aporo Yarusarame sitia pesapo. ");
INSERT INTO faa_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Pekea ipu someraka, “Hokosa kawe takapesane Yu aporo unihaeaka rekeakosane mayare? Maiya apera takua ti makata haku kumuku fasereperakano asekea isiapo hemakapuraka, ‘Yu aporomo unihaeane takapereapo.’ Aíyaka hemakapukua eaki kekerehoko isu perakayiapo.” ");
INSERT INTO faa_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Airakano Herotemo kaikia unihae metamo e hurutapirapaka mahisisapo. Mahisisane Yarusarame aporomo kairaka fofasapo. ");
INSERT INTO faa_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Arirakano Herotemo mahisiraka reke, pirisiti aporo kárane soko, Kotimo somemane tisa aporoane soko, e rea sarimahoko peaesapo. Perakano asekea Herotemo someraka, “Kotimo unihaeaka rekeasimo murikimasa aporo Kereso pusiehokosaposane, hauaka ma takapeakosaposare?” ");
INSERT INTO faa_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Airakano ipu someraka, “Yutía hauaka á Petereheme taonea takapeakosaposapo.” Aíyaka takapeakosaposane wate fana porofete aporomo poparaka, ");
INSERT INTO faa_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Yutía hauaka á Petereheme taone kisiane ape wakasemapo. Wakasema nina apea Unihae takapeakosasamo apeane fanahokosapo. Unihaeamo Isiraya aporo hinamo su Kotimo murikimasane epo asekea rekeakosapo.” Aíyaka porofete aporomo popahoareapo. Aíyaka ipu Heroteaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Someaka farakano Herotemo kaikia i pusiesapo. I pusuakipoko Herote ipi haku reke, ti makata asera aporoane peaesapo. Perakano iaki someraka, “Repo ti makatane sere mamo asesare?” ");
INSERT INTO faa_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Airakano ipu ti makata asesa sereane somesapo. Somerakano Herotemo kaikia someraka, “Petereheme taonea hokosa takapesane kope pusie. Pukua hokosa takapesane kokoa aseraka, anoaki somehoko poparipeanie. Nōmo soko hokosane kekerehoko pukusakipoko, anoaki somehoko poparipeanie.” ");
INSERT INTO faa_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Aíyaka Herotemo somerakano ipu kaikia pusuapo. Puraka fana i maiya apera takua risike ti makata asesane ti makata hakása nine efera hunia rekeno asesapo. Aseane ti makatane fanaraka purakano ipu asepe pusuapo. Ti makatane hokosa takapesa apea erekeraka rekeno ");
INSERT INTO faa_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","aseraka kára sesasapo. ");
INSERT INTO faa_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Seseraka pukua apea yorokoa aseane, hokosa ipi kaīyia Mariayaki kakeno asesapo. Aseraka i kakuna porokoa toke hokosaki kekeresapo. Ipu makata mahimuraka taesane mokoa pekea, hokosaki yaku kasapo. Karaka eke koróto soko, ira pi wape yamona yano motosa ferekesese soko, ira pi meta wape yamona yano motosa mua soko makatane mokoa pesane yaku kasapo. ");
INSERT INTO faa_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Kaka marekea i namina apea poparipuraka, Heroteaki somehoko pusuafapo. Asiamo kituamo “Herote aseako pukupo.” Airakano kaikia, Herotemo apeane koaraka ikia kara meta aeyaka i namina apea pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Aporo pesane pusuakipoko, Yosefemo kituamo Unihae Kotimo ipi hepene aporomo Yosefeaki someraka, “Ne takahikia pusie. Hokosane rusua kukusakipoko Herotemo kokoa aseakosapo. Aserapaka hokosane soko, hokosamo ipi kaīyiane soko, karikia, Iyipi hauaka teketarikia pusie. Pukua hauaka á risike nōmo poparipeaerakano peanie.” ");
INSERT INTO faa_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Aíyaka hepene aporomo makokorotaerakano kaikia, ere yiamo Yosefe takahikia hokosa soko, ipi kaīyia soko, karikia, Iyipi hauaka á risikiako teketarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Pukua Herote kukusiraka hitafe rea maiya amo i Iyipi hauaka á risiapo. Iyipi hauaka á risikiako pusiraka, wate fana Kotimo somerakano porofete aporomo kaikia poparaka, “Iyipi hauaka aeyaka nōmo hokosa peaerakano peakosapo.” Aíyaka Kotimo somerakano porofete aporomo kaikia popasane faserepesa ayareapo. ");
INSERT INTO faa_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Asiamo ti makata asera aporoane Herote rea poparipeanafonorakano Herotemo hemakapuraka, “Aporoamo anoaki kotafe hokoa rureapo.” Aíyaka hemakapuraka ipi kára sapesapo. Saperaka reke epo hemakapuraka, “Aporo kimisi pesamo ti makata asesa sere ane, somesa sere hakasa yiamo Isiraya aporomo unihaeane takapereapo. Takapesa sere ane menorape pekea, sere o pauanane hokosa kapokararakasiapo.” Aíyaka Herotemo hemakapuraka someraka, “Hokosa kapokarasane soko, apapusane soko suane rukua fahoanie. Petereheme taonea soko, Petereheme taone makeraka á risiane soko, aporo hokosa suane rukua fahoanie.” Airakano kaikia aporo hokosa suane rukua fasapo. ");
INSERT INTO faa_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Rusuane rusiraka wate fana porofete aporo Yaremayamo popasane yaiya faserepesa ayareapo. Porofete aporoamo popasane oyapo. ");
INSERT INTO faa_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Aporomo kaiyiáne Rama apea hinamomo kára hiripurakano kaiyakosapo. Hinamo ipi yano motosa Reseremo ipi hokosapoko kára hiripurakano kaiyakosapo. Hokosa su rukua fasakipoko e mauwaraka somehoane soko epo kakipayarakano aseakosapo.” Aíyaka porofete aporomo wate fana popasane kakaro yaiya faserepesa ayareapo. ");
INSERT INTO faa_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Keseke Herote kurakano asekea, Yosefe Iyipi hauaka reakipoko kituamo Unihae Kotimo hepene aporo pekea Yosefeaki someraka, ");
INSERT INTO faa_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Ne takahisie. Aporo hokosa kukusimo rukusapoko hemakapukua rea aporoane kusuapo. Kusuasamo hokosa soko, hokosamo ipi kaīyia soko, karikia hisie. Hikia Isiraya hauaka á risikiako poparihisie.” ");
INSERT INTO faa_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Airakano Yosefe turikia pukua, takahikia hokosa soko, hokosamo ipi kaīyia soko, karikia, Isiraya hauaka á poparihisiapo. ");
INSERT INTO faa_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Poparihinaka kaiyiáne Herotemo maeya Akerease ipi ata finihaoa reke, Yutía hauaka á unihaeaka rekenapakano kaisiapo. Kaikia Yosefe Yutía hauaka á pukusane karekekea reapo. Karekekea reakipoko kituamo Yutía hauaka á hiakoporakano, Kariri hauaka á pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Pukua Nasare apea risikiako pusuapo. Risikiako pusuane pusiraka, wate fana porofete aporo metakiramo somesane oyapo. “E Nasare aporopo, aíyaka aporo suamo aihokosapo.” Aíyaka porofete aporomo somesane faserepesa ayareapo. ");
INSERT INTO faa_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wakasema risina keseke, Yutía hauaka ima yaoa Yone he tapukumarerane pekea aporo hinamoaki some karáka, ");
INSERT INTO faa_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Kotimo unihaeaka asekea rekeakosa maiyane makesasamo, repo makata watikisane metakarikia eaki risikiako parihoanie. Epo re asekea rekeasimo eaki risikiako parihoanie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aisa aporoane wate fana porofete aporo Aesayamo poparaka, “Aporo ima yaoa rekeakosapo. Reke epo sakepamo someraka, ‘Unihae peakosane ikia kára makotehoanie. Ikia kárane hahaesekeno maereketaehoanie.’ Aíyaka ima yaoa aporoamo somehokosapo.” Aíyaka Aesayamo popasane Yone ane popasapo. ");
INSERT INTO faa_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ima yaoa Yone rea maiya amo saro kamo iti pasu pesa osoraka, saro kau terakae hikia, kitaro kesē asia nekea, sao he wapesa asia nekea ayiáka reapo. ");
INSERT INTO faa_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","E rea hauaka á aporo hinamo Yarusarame siti aeyaka soko, Yutía hauaka aeyaka soko, he Yotane makeraka aeyaka soko, aporo hinamo yakai pesapo. ");
INSERT INTO faa_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Pekea ipu makata watikisane hufitaerakano, Yonemo iane he Yotanea tapukumurisiapo. ");
INSERT INTO faa_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Yonemo hea tapukumuriraka reke aseane Ferese aporo soko, Satusi aporo soko, i metakira hea tapukumuriasimo perakano asekea, Yonemo iaki someraka, “Re su heseke ayireapo. Kotimo reaki kára saperaka fanasinapaka epamo reaki somerakano, re teketarikia perakanare? ");
INSERT INTO faa_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Arirakano ira kotesamo wate koteaka perapo. Aina ayiáka repo himu watikisane metakarikia risikiako parisane asekeasimo koteaka susu risikianie. ");
INSERT INTO faa_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ayiáka risikiafunusa nine repo hemakapuraka, ‘Isu Eparahamemo aporo irasasamo Kotimo aporoane isupo. Asiamo isu siaraka risikinapo.’ Aíyaka hemakapukupo. Eparahamemo aporo ira parihoasimo Kotimo eke ane maka, aporomano parihoane sia aporomano maparihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Asiamo aporomo ira tokorakosakipoko kapi máfaraka area ayiáka, maiya omo Kotimo fanasina motoakosane ayiáka makeraka rekenapo. Ira wate koteaka peanafonona ira ane tokoraka mokoateraka iramo inakasimo paiyakosapo. ");
INSERT INTO faa_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Repo himu watikisane metakarikia risikiako parirakano, nōmo reane he hákasa tapukumurirakanapo. Ano reakipoko keseke aporo kára meta peakosapo. Peraka epo Ho Kotesa soko, ira rufi soko re muriakosapo. E aporo kárasasamo aporo raipamo epo tamaka ososane fisiraka maka apura ayiáka nōmo maka puane siahoasifareapo. E aporo kárasasamo nōmo epoko raiparaka rakiako ayiane, ano wakasemasasamo nōmo rakiane siahoasifareapo. Ano eyaki siasafapo. ");
INSERT INTO faa_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Aporo kára ane peraka epo sipete asia foke maka peakosapo. Maka peraka hauaka moroa witi hae taesane fokemo fauhoane, witi namo ane ereketae hurupeperakano, ane mokoa apea taehokosapo. Witi kau ane fofomo mokoa pukua takua hurupeperakano, ane mokoateraka ira rufi kopakapunafonona á paiyakosapo.” Aíyaka Yonemo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yone ima yaoa rea maiya amo, Yasu Kariri hauaka metakarikia Yonemo e hea tapukumareasimo he Yotanea pesapo. ");
INSERT INTO faa_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Perakano Yonemo waeraka someraka, “Nómo ano hea tapukumareane siahoasireapo. Nōmo ne hea tapukumareane siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Airakano Yasumo someraka, “Wae. Nōmo someane nómo kakimasie. Kotimo makata koteaka rakiniesane etapo makata su koteaka rakikia rosaka taehoko yumo nómo ano hea tapukumaresie.” Airakano Yonemo aoraka Yasuane hea tapukumaresapo. ");
INSERT INTO faa_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Hea tapukumareraka hea sokoperaka ima yapura hianine, tiane kikisi aka kikisi rorakano aseane, Kotimo Ho Kotesa mena nume asia apera ayiáka pekea, Yasua karaporakano asesapo. ");
INSERT INTO faa_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Asekea risia maiya amo hepene aeyaka someraka, “Eane nōmo nī hokosapo. E nōmo himu tumurumo kára hemakapukua seserakanapo.” Aíyaka somerakano kaisiapo. ");
INSERT INTO faa_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yasu hea tapukumarekea faraka reakipoko Satanemo Yasuaki mokopipihoasimo Ho Kotesamo Yasu ima yaoa karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pukua sere foti (40) su reámo, sere soko ereamo soko Yasumo makata nesafapo. Nena himu raru reke sere foti ane (40) fahoane e namo kakaro kára meamosapo. ");
INSERT INTO faa_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Meamoraka reakipoko Satanemo Yasu kau aseakosakipoko mokopipiraka someraka, “Ne Kotimo hokosasamo, nómo eke atoane maka ní nakosakipoko farawa maparisie.” ");
INSERT INTO faa_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Airakano Yasumo someraka, “Wae. Kotimo sawia popasane oyapo. ‘Aporomano koteaka rekeako, farawa hákasa nenaka koteaka rerafapo. Koteaka rekeako Kotimo somesane kakimarakano koteaka rerapo.’ Aíyaka Kotimo sawia popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Aíyaka somerakano Satanemo Yasuane Yarusarame sitia karikia hikia Kotimo ape kopo yapura karikia hikia risike someraka, ");
INSERT INTO faa_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Ne Kotimo hokosasamo, ní yia hauaka atura hurupesie. Huruperakano Kotimo hepene aporoaki ‘E ararerasie,’ airakano ne korakea ekemo kareakohoamo hepene aporomo hokonomo ne máfaraka maka rekeakosapo.” Aíyaka Kotimo sawia popahoareapo. ");
INSERT INTO faa_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Airakano Yasumo someraka, “Wae. Kotimo some meta Kotimo sawia popasane oyapo. ‘Ni Unihae Kotiane kau aseakosakipoko ayiakakopo.’ Aíyaka Kotimo sawia popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Aíyaka somerakano Satanemo Yasu karikia ūri kára terayia hisiapo. Hikia risike kamani kekepomo hauaka kekepoa unihaeaka asekea risiane soko, hauaka sua makata namo kakaro kotesa suane soko, Yasuaki tarisiapo. ");
INSERT INTO faa_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tariraka Yasuaki someraka, “Nómo ano rea kako pekea kake kakuna porokoa anoaki kekererakano, makata su aserane nómo unihaeaka asekea rekeasimo né mareakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Airakano Yasumo someraka, “Satane ne pusie. Kotimo sawia popasane oyapo. ‘Nómo Unihaeane Kotipo. Koti ipiaki hákasa kekerehoanie. Epoko hákasa rakinie.’ Aíyaka Kotimo sawia popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Aíyaka Yasumo somerakano Satane pusuapo. Pusuakipoko hepene aporo peraka Yasuane arareraka asekea risiapo. ");
INSERT INTO faa_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yonemo unihae Heroteaki ayiakakopo, airakano Herotemo Yoneane tipura makesapo. Yone tipura makesapakano kairaka Yasu hauaka ane metakarikia, Kariri hauaka á pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pukua Nasare apea waka reane metakarikia pukua, Kapaneame taonea waka reapo. Arirakano he Kariri he fua Sépuru aporo iramo hauaka soko, Nafatari aporo iramo hauaka soko hauaka á Kapaneame taone kisiapo. Taone kisia á Yasu waka reapo. ");
INSERT INTO faa_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Waka rekeasiraka wate fana porofete aporo Aesayamo popasane faserepesa ayareapo. Aesayamo popasane oyapo. ");
INSERT INTO faa_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sépuru aporo iramo hauaka á soko, Nafatari aporo iramo hauaka á soko, he Yotane yaoraka á soko, he Kariri makeraka hauaka á soko, Yu aporo akiyaki Yu aporohoanafonosa ");
INSERT INTO faa_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ane ereraka risiapo. Ereraka risia aporo hinamoamo Kotimo faesane aseakosapo. Arirakano kurámo mataisa hauaka á aporomano risiane, sere maiyamo faena ayiáka faehokosapo.” Aíyaka popasane faserepesa ayareapo. ");
INSERT INTO faa_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yasu Kapaneame taonea pusua maiya amo epo makata rakirane kepomaresapo. Kepomarekea some karaka, “Koti unihaeaka rekeakosa maiyane faserepesapo. Faserepesasamo repo himu watikisane metakarikia eaki risikiako parirasie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Yasu he Kariri fua pukua aseane Saemone ipi mamanea Enitu tetā asesapo. Arirakano Saemone ipi yano motosa meta Pitapo. Ipi soko, ipi mamanea Enitu soko tetapō makata rakirane pokoa pisinisi rakirapo. Rakiraka risike, tetapō pokoa mokoako hea kasipu kokomarerakano, asesapo. ");
INSERT INTO faa_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Asiamo Yasumo tetāki someraka, “Ano patera asesie. Ano patera aserakano tetápo pokoa amora ayiáka aporo hinamo anoa paohokosane pasimokoasimo, nōmo teto murikimarakanapo.” ");
INSERT INTO faa_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Aíyaka somerakano tati kasipuane wate foakayia metakarikia, Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wakasema pukua Yasumo aseane aporo tetá meta risikino asesapo. Asesane Sepetemo hokosa tetá, meta Yamese meta ipi mamanea Yone, tetā wafayayaki kasua risike, kasipu potakahesa petokoraka risikino asesapo. Aseraka tetāne peasimo Yasumo wásapo. ");
INSERT INTO faa_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wárakano wate foaka tetapō wafayane soko, kasuane soko, metakarikia, tati Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kariri hauaka ape sumu sua Yasu koraka reke, Yu aporomo sarimana ape sua Kotimo some kotesane some karáka, Koti unihaeaka reane some kasapo. Some karáka aporomano makata kára tasane soko makata wakasema tasane soko, makata tasa kekepo suane Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yasumo aporo makata tasane mafasapakano Siria aporomo kairaka Yasu rea aporomano makata tasa su karikia pesapo. Aporomano makata tasa kekepo tape pusuane karikia pesapo. Karikia pesane metakira kau teraka, metakira yatafumo ho mokoa, metakira masuaraka, metakira kau soko, hokono soko, nariraka korosakataesa aporo su ayiáka makata tape pusuane Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ayiáka mafarakano asekea aporo hinamo yakaimo Yasu asekehaerape pusuapo. Pusuane Kariri hauaka aeyaka soko, Tekáporisi hauaka aeyaka soko, Yarusarame siti aeyaka soko, Yutía hauaka aeyaka soko, he Yotane yaoraka hauaka taku aeyaka soko, aporo hinamo yakai pekea Yasu asekehaerape pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aporo hinamo yakai pesane Yasumo asekea, ūri terayia hikia kayapo. Kayakipoko ipi aporo hakāsa pura pekea eyaki hakāsa toke ");
INSERT INTO faa_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Yasumo iaki someraka, ");
INSERT INTO faa_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Aporo hinamo metakiramo someraka, ‘Kotimo menane ano forokoa reasasamo, Kotimo hemakapusua ayiáka nōmo hemakapukusakipoko seseripo.’ Aisa aporo hinamoane Kotimo unihaeaka asekea rerapo. Asekea reke Kotimo aporo hinamoane makoterakano i seseraka risirapo. ");
INSERT INTO faa_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Arirakano aporo hinamo metakiramo hihiripuraka risikino Kotimo iane kukunameaka mauanapo. Mauaraka ayiáka makoterakano i seseraka risirapo. ");
INSERT INTO faa_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Arirakano aporo hinamomo naminane makáraraka rupiaka somehoanafonoraka, naminane mawakasemaraka auaraka risikino, namina hauaka wo makatane asekea risikiasimo Kotimo i murikimaka marerapo. Murikimaka ayiáka makoterakano i seseraka risirapo. ");
INSERT INTO faa_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Arirakano aporo hinamo metakiramo meamoraka risike makata nakosa soko, he soko nako seséna ayiáka, Kotimo ereketae hemakapurane ayiáka seseraka risikino, seséna aporo hinamoaki Kotimo ereketae hemakapurane siaraka karápo. Kaka ayiáka makoterakano i seseraka risirapo. ");
INSERT INTO faa_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Arirakano aporo hinamo metakiramo, aporo hinamo metaki kamenakaraka hemakapurakano, kamenakana aporo hinamoane, Kotimo kamenakaraka hemakapurapo. Kamenakaraka hemakapukua ayiáka makoterakano, i seseraka risirapo. ");
INSERT INTO faa_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Arirakano aporo hinamomo makata watikiaka hemakapusuane kosoraka, koteaka susu hemakapura aporo hinamoamo Kotiane aseakosapo. Aseakosa aporo hinamoane Kotimo ayiáka makoterakano i seseraka risirapo. ");
INSERT INTO faa_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Arirakano metamo metaki saperaka rekeno, sapesane mafahoasimo aporo hinamo metamo maroporakano, eaki Kotimo someraka, ‘Ne nōmo hokosapo.’ Aírapo. Asiamo aporo hinamoane Kotimo ayiáka makoterakano i seseraka risirapo. ");
INSERT INTO faa_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Arirakano aporo hinamo metakiramo Kotiane kekemaraka, ereketae susu rakisiasamo, iane aporo metamo mokoatikirakano, iane Kotimo unihaeaka asekea rerapo. Asekea reke Kotimo iane ayiáka makoterakano, i seseraka risirapo. ");
INSERT INTO faa_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Asiamo repo ano patera asesasamo reaki aporo metakiramo ekeneraka, rukua mokoatikiraka, kotafe topakamarakano, reane Kotimo makoterakano seséraka risikianie. ");
INSERT INTO faa_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Seséraka risike hepene yapura repo makata ropo kotesa kára toasasamo, kakaro kára seseraka risikianie. Asiamo wate fana aporomo Kotimo some kará porofete aporoane mokoatikisa ayiáka, re soko ayiáka mokoatikihokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yasumo someraka, “Makata torenapaka kifiri rukua taesa atoa ayiáka, aporomo makata watikisane hauaka sua suakataehokohoamo kifirimo rusua pórasa asiane repo. Arirakano kifiri wapesane farakano, efera hunia mawapenafapo. Kifiri wape fasa néna taehoane siahoasifasekeno, kifiriane mokoatenapo. Mokoatesane aporo puraka korakemo fininapo. ");
INSERT INTO faa_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Arirakano hauaka wo katorakano sere maiyamo faena ayiáka faena asíane repo. Arirakano ape ūri terayia kisiane kakamasakipoko makata metamo matainafapo. ");
INSERT INTO faa_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Arirakano aporomo nafa pakimaka motokoa taramomo karotapirafapo. Nafa pakimaka apea waremaresa faerakano aporo hinamo suamo aserapo. ");
INSERT INTO faa_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Nafa pakimaka waremaresa kára faeraka area ayiáka, repo ayiáka koteaka rakiraka risikino aporo hinamo suamo aseraka, repo Ata hepene yapura areaki kekerehokosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Yasumo someraka, “Repo hemakapuraka, ‘Fana Kotimo somemane motosane soko, Kotimo some kará porofete aporoamo somesane soko, Yasumo rukupateraka metakariakosapo.’ Aíyaka hemakapukupo. Kotimo somemane motosane soko, porofete aporomo somesane soko, rukupateraka metakariakosakipoko, ano pesafapo. Kotimo somemane motosane soko, porofete aporomo somesane soko hakása nine siaraka ayiakakosakipoko, ano pesapo. ");
INSERT INTO faa_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Hao, kaisie. Nōmo some one kakaro somerakaripo. Hepene yapurane soko, hauaka kára one soko, fahoasiraka area maiya amo, Kotimo somemane ane soko rekeakosapo. Somemane popasane hakása meta soko metakariakosafapo. Ayiakakosapo aíyaka popasane, su kakaro yaiyakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Asiamo aporo metamo hemakapuraka, ‘Kotimo somemane metane fanapo. Metane kesekepo. Kesekeane metakariane siahoasireapo.’ Aíyaka hemakapuraka, aporo metakiramo soko, Kotimo somemane wakasemane metakarisimo, epo some karakano, some akara aporoane Kotimo unihaeaka asekea rea aporo kesekeane epo. Arirakano aporomo Kotimo somemane suane kakimaka, aporo metakiramo soko kakimakasimo some karakano, some akara aporoane Kotimo unihaeaka asekea rea aporo fanane epo. ");
INSERT INTO faa_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Hao, kaisie. Nōmo some one kakaro somerakaripo. Ferese aporomo soko, Kotimo somemane tisa aporomo soko, ipu namina ereketaeraka hemakapukua rakiraka risiane, repo marokeraka ereketaeraka hemakapunafonorakanone re Kotimo unihaeaka rea hauaka á hiakosafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yasumo someraka, “Wate fana repo makasa kaua kekemaki somesane somepe pekea repo soko kaisiapo. Kaisiane oyapo. ‘Aporo kukusimo rukupo. Aporo meta nómo rusua kurakanone, né hukurukua fanasihokosapo.’ Aíyaka somehoareapo. ");
INSERT INTO faa_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Somesa nine nōmo reaki some meta one somerakanapo. Aporo metamo ipi aporo tákeaki saperakano, e fanasihoasimo hukurura apea hukurukusapo. Arirakano aporo metamo ipi aporo tákeaki saperaka hikumisia ekenerakano, Yarusarame sitia hukurura kepo kaira aporo káramo maropohoasimo karikia pukusapo. Arirakano aporo metamo ipi aporo tákeaki mokoatikiraka saperaka someraka, ‘Ne himu rekerifapo.’ Aíyaka yakasa ho mareraka mokoatikaraka somesa kasá aporoane heao hauaka ira rufia pusiehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Asiamo maiya metamo Kotiaki makata yaku akaramo nómo hemakapuraka, ‘Nōmo aporo tákemo anoaki mahisiraka rekenapo.’ Aíyaka hemakapukua ");
INSERT INTO faa_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Kotiaki makata yaku kakakosane haru karafaraka fore teporoa taeraka nómo ní tákemo neaki mahisisane fana hokono mokoa mafahoko punie. Pukua titi hokono mokoa mafaraka pariperaka makata yaku kakakosapoko taesane kakanie. ");
INSERT INTO faa_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Arirakano aporo metamo neaki someraka, ‘Nómo ano apihoanie.’ Aíyaka ne hukuruko ikia kara puraka risike, nómo eaki mahisisane metakarinie. Metakarikia api kaka, tetápo titi makata watikisane mafahoanie. Mafahoanafonorakanone hukuarura maiya amo hukurura kepo kaira aporomo terakaiyamosaki ne tarikia someraka, ‘Aporoane tipura makeanie.’ ");
INSERT INTO faa_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Airakano neaki api kakaniesane siaraka kakanafonorakanone, ne tipura makesane tonotaehokosafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yasumo someraka, “Makata fana somesesuane repo kaisiapo. Kaisiane oyapo ‘Hinamo hakimakopo.’ Aíyaka somesesupo. ");
INSERT INTO faa_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Somesa nine nōmo some meta one somerakanapo. Aporomo hinamo aseraka himu puraka, ‘Hinamo ane hakimakaripi,’ aíyaka hemaka apura yiamo hinamoane himumo hakimarakanapo. ");
INSERT INTO faa_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Asiamo ne hi tumurumo makata watikisane rakisimo kirimarakano, hiane pokomaka mamakatehoanie. Hi wakasema hakásamo ne kau suane heao hauaka á karikia purapaka, hi wakasema hakásane pokomayane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Arirakano ne hokono tumurumo watikiaka rakirakano hokonoane patekemaka mamakatehoanie. Hokono tumuruamo kau su kirimaraka heao hauaka á karikia purapaka, hokono hakásane patekemaka mamakatehoane siahoasireapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Yasumo someraka, “Makata fana some kasesuane oyapo. ‘Aporomo ipi asea fimaresane aporo suamo asekea hemakapusimo hinamoaki sawi poparaka karáka, “Ne fimarerakanapo.” Aíyaka sawi poparaka kakanie.’ Aíyaka some kasesupo. ");
INSERT INTO faa_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Some kasa nine nōmo reaki some meta one somerakanapo. Aporomo ipi hinamo arumasane aporo metayaki mokome punafonorakano yia, fimarerakanone aporoamo raraporakanapo. Hinamo fimaresane aporo metamo arumarakano Kotimo asekea hemakapuraka, ‘Hinamoane aporo rea pura hinamoreapo. Arirakano aporoamo hinamoane hakimarakanapo.’ Aíyaka Kotimo hemakapurapo. Asiamo rarapo kepoane hinamo fimaresa aporo ayapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yasumo someraka, “Wate fana repo makasa kaua kekemaki somesane somepe pekea repo soko kaisiapo. Kaisiane oyapo. ‘Nómo makata rakiakosapo, aíyaka aumaraka somesane metakariakopo. Unihaemo asekeasimo nómo aumaraka someraka ayiakakosaposane kakaro ayiakanie,’ aíyaka somehoareapo. ");
INSERT INTO faa_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Makasa kaua kekemamo somesa nine, nōmo reaki some meta one somerakanapo. Makata meta yano hokoa aumahokopo. Hepene yapura Koti unihaeaka sea kára kayasasamo, hepene yapurane yano hokoa aumahokopo. ");
INSERT INTO faa_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Arirakano Koti ipi hepene yapura kake, hauaka kára one epo korakemo finiraka kayasasamo, hauaka kara one soko, yano hokoa aumahokopo. Arirakano Yarusarame sitiane soko yano hokoa aumahokopo. Yarusarame sitiane Unihae Káramo sitipo. ");
INSERT INTO faa_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Arirakano repo wamoane soko yano hokoa aumahokopo. Wamoa uni itiane hakesane soko, eresane soko, repo aporomanomo marerafapo. ");
INSERT INTO faa_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Asiamo some kakarorakae aihoasimo oroko makata aumarane soko, yátafu aumarane soko, Kotiaki hokono soneraka aumarane soko, su kepoane Satanepo. Asiamo makata ane yano hokoa aumaraka aumahokopo. Aohoko hemakapuraka kakaro aohoanie. Waehoko hemakapuraka kakaro waehoanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Yasumo someraka, “Makata fana somesesuane repo kaisiapo. Kaisiane oyapo. ‘Aporomo ne hi rukua faurakano, e soko hi fauhoasimo rukua ropohoanie. Aporomo ne akaia ruraka mere rukurokorakano, e soko mere rukurokohoasimo nómo rukuropohoanie.’ Aíyaka somesesuane repo kaisiapo. ");
INSERT INTO faa_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ipu somesa nine nōmo reaki some meta one somerakanapo. Aporo watikisamo ne mokoatikirakano nómo eaki ropo mokoatikihokopo. Aporomo ne akai pare tumurua rurakano, nómo rukuroponafaraka akai pare kasakai takua soko rusimo tarinie. ");
INSERT INTO faa_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Arirakano hukurura kepo kaira aporomo kaiyisimo aporo watikisamo neaki hukurukua someraka, ‘Nómo pasu ososane ano makasie.’ Airakano pasu ososane e karaka, pasu ososa metane soko e kakanie. ");
INSERT INTO faa_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Arirakano kamani aporomo neaki paroaka someraka, ‘Nōmo makata fato tame yia yaku maka pusie.’ Airakano nómo seseraka e arareraka yamenoa soko yaku maka punie. ");
INSERT INTO faa_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Asiamo aporomo neaki makasierakano nómo kakanie. Aporomo neaki makata fore makasierakano kakanie. Waehokopo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Yasumo someraka, “Makata fana somesesuane repo kaisiapo. Kaisiane oyapo. ‘Aporo tákemo neaki himu tumurumo hemakapurakano nómo soko eaki himu tumurumo hemakapunie. Aporomo neaki hisirakano nómo soko eane hisihoanie.’ Aíyaka fana somesesupo. ");
INSERT INTO faa_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Somesa nine nōmo reaki some meta one somerakanpo. Aporo metamo né mokoatikirakano, nómo eaki himu tumurumo hemakapunie. Eane Kotimo ararehoasimo kurikurihoanie. ");
INSERT INTO faa_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Eane hemakapukua kurikuriraka reke, repo Ata hepene yapura reamo makata rakira ayiáka, reane ipi hokosa pariraka ayiáka rakirakanapo. Asiamo aporo watikisamo hauaka á soko, aporo kotesamo hauaka á soko, ipu suamo hauaka á sere maiyamo faehoasimo, Kotimo sere maiyane makarapo. Arirakano kotafe somera aporo soko, kakaro somera aporo soko, ipu suamo hauaka á yao peasimo Kotimo makarapo. ");
INSERT INTO faa_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Aporo tákemo ne himu tumurumo hemakapurakano, nómo soko eane ropo himu tumurumo hemakapusuakipoko, ‘Kotimo anoaki makata ropo kakakosapo.’ Aíyaka hemakapurane siahoasireare? Wae, siahoasifareapo. Nómo ropo himu tumurumo hemakapukua rekeno, ne takese mora aporo area ayiáka rekenapo. Aporo watikisamo hemaka apura ayiáka repo ayiáka hemakapurakanapo. Arirakano repo aporo tákeane soko hemakapuraka yia, aporo metakirane soko himu tumurumo hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nómo ni aporo ira ane hákasa makoteraka, aporo metane asekepayaraka makefehoane siahoasireare? Wae, ane siahoasifareapo. Nómo ní aporo ira hákasaki makoteraka, aporo metane asekepayaraka makeferaka rekeno, ne nena aporo area ayiáka rekenapo. ");
INSERT INTO faa_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Asiamo nómo Ata hepene yapura reamo koteaka reke aporo hinamo suane himu tumurumo hemaka apura ayiáka, ne soko koteaka reke, aporo hinamo suane himu tumurumo hemakapunie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yasumo someraka, “Nómo Kotiaki patera asekea rakirane aporo suamo asekea ne makáraraka kekerehoasimo rakiakopo. Nómo ní yia makáraraka rupiraka sikiraka rakiakopo. Nómo Kotiaki patera asekea rakiraka, aporo suamo asekea ne makáraraka kekerehoasimo rakirakano, nómo Ata hepene yapura reamo neaki makata ropo kakakosapoko asiane, nómo ní yiamo aiyanamo, nómo makata ropoane huruperakanapo. ");
INSERT INTO faa_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Asiamo aporo makata forokoa reane nómo asekea makata akara maiya amo, tau kakanie. Aporo suamo asekea ne makáraraka kekerehoasimo, aporo su hikumisia kakakopo. Aporo su hikumisia akará ayiáka, aporo himu tetáraka hemakapukua reamo ayiáka makata karápo. Ipu makata karáne Yu aporomo sarimana apea soko, ikia kára soko, makata karápo. Ayiáka makata karakano, aporomo asekea kekereraka, ‘Epo makata kára akare.’ Airakanone, aporoamo makata ropoane sia amara ayapo. Asiamo nōmo reaki kakaro somerakaripo. ");
INSERT INTO faa_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Arirakano aporo makata forokoa reane nómo makata karáka, tau kakanie. Aporo metakiramo aseakohoamo, i hikumisia kakakopo. Arirakano aporo metakiramo kaiyakohoamo, somehokopo. ");
INSERT INTO faa_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Faremarekea kakakosakipoko ayiáka kakanie. Akara maiya amo titi haku toke karakano, nómo faremarekea rakisiane nómo Ata hepene yapura reamo aseraka epo ne makotehokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yasumo someraka, “Nómo kurikuriraka aporo himu tetáraka reamo kurikurisane kaikia, ayiáka kekemaraka kurikurihokopo. Aporo metamo ikia kara reke kurikuriraka, anakano aporo metamo Yu aporomo sarimana apea aporo suamo kaiyisimo kurikuriraka anapo. Arirakano, aporo suamo aseraka someraka, ‘E aporo kotesapo.’ Airakanone aporoamo makata ropoane sia amara ayapo. Asiamo nōmo reaki kakaro somerakaripo. ");
INSERT INTO faa_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Arirakano nómo kurikuriraka nómo ní apea ní haku pukua ikia koro mapirikia reke, kurikurihoanie. Nómo ní haku kurikuriraka reke, ní Ata aporomanomo asekeanafonosane fararekeno eaki kurikurihoanie. Kurikurinane ní Atamo kaikia ne makotehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Nena aporomo hemakapuraka, ‘Kára kurikurirakano Kotimo kaiyakosapo.’ Aíyaka hemakapuraka, ipu some kára waseremaka some nokone pukua kurikurinapo. ");
INSERT INTO faa_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ipu kurikurina ayiáka, nómo kekemaraka kurikurihokopo. Nómo makata siaraka tokoanafonosane soko, himu siaraka rekeanafonosane soko, nómo kurikurihoasiraka, ní Ata hepene yapura reamo fana hemakapurakayiapo. ");
INSERT INTO faa_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Asiamo repo kurikuriraka úyaka kurikurihoanie. ‘Atao. Ne isiapo Ata hepene yapura rekenapo. Ne yano motosa kakaro kára haku kotesa susuane makama fanahoasimoripo. ");
INSERT INTO faa_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Aporo sumo himua ne unihaeaka rekeasimo hemakapurakaripo. Hepene yapura nómo ní hemakapusua aina ayiáka, hauaka wo soko ayiakasimo hemakapurakaripo. ");
INSERT INTO faa_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Pipu makata nakosane pipu yia nasimo, siaraka makanie. ");
INSERT INTO faa_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aporo metamo isuaki mokoatikirakano, isiapo ropo mokoatikinane mafaraka mamerarurakano asekea, isiapo watikisane soko, nómo mafaraka mameraruhoanie. ");
INSERT INTO faa_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Isu kau aseakosane peakohoamo nómo isu asekea rekeanie. Satanemo isu mokopipihokohoamo isu mafasinie.’ Aíyaka kurikurihoanie. ");
INSERT INTO faa_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Asiamo aporomo neaki watikiaka rakisiane, nómo ropo mokoatikihoanafonoraka metakarirakano, nómo Ata hepene yapura reamo nómo watikisane soko metakariakosapo. ");
INSERT INTO faa_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Arirakano aporomo neaki watikiaka rakisiane, nómo ropo mokoatikinane metakarianafonorakano, nómo watikisane soko, nómo Ata hepene yapura reamo metakariakosafapo.” Aiyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yasumo someraka, “Makata nakosa sokoairaka aporo himu tetáraka risiamo sokoaiana ayiáka, nómo ayiáka sokoaihokopo. Ipu hi kumisi yuyukuraka risike, ipu makata nakosa sokoaisane, aporo suamo hemakapusimo, meamoraka koraka risirapo. Meamoraka koraka risiane aporo suamo asekea kekererakano, ipu makata ropoane sia amara ayapo. ");
INSERT INTO faa_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Arirakano nómo Kotimo seséhoasimo makata nakosa sokoairaka aporo suamo hemakapukohoamo, ní hi kumisi kusuraka, uni iti unisakemo rakinie. ");
INSERT INTO faa_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Rakikia aporo suamo aseakohoamo tau makata nakosa sokoairakano, nómo faremarekea sokoaisane nómo Ata ipi hákasamo aserakanapo. Aseraka epo ne makotehokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Yasumo someraka, “Hauaka wo makata mahimuraka taesane metane mopenapo. Metane surisurimo nenapo. Metane hakimora aporomo ape ikia koro mapirisiane soko, roparaka hakimorapo. Anapaka hauaka wo makatane mahimuraka taehokopo. ");
INSERT INTO faa_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nómo makata mahimuna ane hepene yapura taehoasimo rakinie. Hepene yapura makata taesane aporo metamo hakimorafapo. Surisurimo soko nenafapo. Moperaka soko mopenafapo. ");
INSERT INTO faa_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Asiamo nómo hauaka wo makatane mahimuraka sarimaraka taeraka rekeno hauaka wo makatane hákasa hemakapukusapo. Arirakano hepene yapura makata mahimuna ane sarimaraka taeraka rekeno hepene yapura makata taesane hákasa hemakapukua rekeakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Yasumo someraka, “Ní kaumo nafa asiane ní hipo. Ní himo makata su koteaka asekea takékea rekeno ní kauane faeraka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Asiāne ne hi meraka reke, ne kauane soko, katoraka rekeakosapo. Katosakipoko faesa reane katosamo suaka taehokosapo. Suaka taerakano katosane kárahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Yasumo someraka, “Aporo posesa tetápoko aporo raipa hakásamo rakirafapo. Aporo raipa hakásamo aporo posesa tetápoko rakiraka, metaki seseraka rakiraka, metaki hisiraka rakiakosapo. Aina ayiáka aporomo Kotipoko hemakapukua rakirane soko, monepoko hemakapukua rakirane soko, tetáraka rakiane siahoasifareapo. ");
INSERT INTO faa_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Asiamo nōmo some one neaki somerakanapo. Ne hitaferaka rekeako he soko, makata nakosane soko, makata akipoko kára himu nekea hemakapukupo. Patera yase risirapaka pasu osohokosane, kára himu nekea hemakapukupo. Hitafe areamo makata nená hákasa ayare? Kaua pasu osohokosa hákasa ayare? Wae, hákasa ayafapo. Kotimo neaki himu ha kasasamo makata nakosane soko, neaki kakasifareare? Ao, epo neaki sia kakakosapo. Neaki kauane kasasamo pasu osohokosane soko, epo neaki kakasifareare? Ao, epo sia kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mená koraka torane asekeanie. Menámo makata nakosa pororafapo. Witi hae surakano menámo popatenafapo. Witi hae keseke nakosakipoko apea taenafapo. Taehoanafonorakano menáki nómo Ata hepene yapura reamo makata nakosa karakanapo. Menáki karásasamo aporomanoaki kakasifareare? Ao. Aporomanoane ipi kará hemakapukua kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Arirakano aporomanomo ipi himu hemakapuramo, ‘Ano kukusane hisiripo.’ Aíyaka himu nekea rekeno, e kukusa sere motosane marokehokosare? Wae, marokehokosafapo. ");
INSERT INTO faa_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Arirakano pasu makosakipoko himu nekea rekeakopo. Sako wemeane hemakapunie. Sako wemeane taneheakosakipoko sako wememo namina yia makata rakirare? Wae, makata rakirafapo. Sako weme suhoasimo sako wememo pasu susane maka irinare? Wae, sako wememo ipi hemakapukua wateane sunapo. ");
INSERT INTO faa_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Hao, kaisie. Wate fana Soromone aporo kára unihaeaka reke, ipi pasu kotesa ososapo. Soromonemo pasu ososane kotesa nine, sako weme wateane namo kakaro kotesapo. ");
INSERT INTO faa_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Arirakano asane tanehekea risiane Kotimo makoteraka wate karápo. Karakano asane pipu tanehekea risiane, wakasema keseke iramo paiyiane kukua kerapo. Kukua kesane, maiya wakasemamo tanehekea risia nine, Kotimo asekea rerapo. Kotimo asane asekea area ayiáka, nómo pasuane fahokohoamo, Kotimo neane ayiáka asekea rekenapo. Kotimo ne asekea rekeno yia, nómo Kotiaki himumo hakása wakasemaraka hemakapurakanapo. ");
INSERT INTO faa_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kotimo reane asekea rerasamo úyaka hemakapukupo, ‘Makata nakosa ma mokoakosare? He ma takamakosare? Pasu fasekeno ma mokoakosare?’ Aíyaka himu nekea kára hemakapukupo. ");
INSERT INTO faa_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Arirakano nena aporomo maiya suamo makata nakosane soko, pasuane soko, kára himu tumurumo hemakapurapo. Arirakano makata nakosane soko, pasu osohokosane soko, farakano mokoakosane nómo Ata hepene yapura reamo hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Asiamo Kotimo ne unihaeaka asekea rekeasimo matumuruhoanie. Kotiane ereketaeraka area ayiáka ereketaeraka rekeako himu tumurumo ayiáka hemakapunie. Ayiáka hemakapukua rekeno makata nakosa soko, pasu soko, siaraka mokoakosapo. ");
INSERT INTO faa_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Asiamo rau ayiakakosane rau yia hemakapunie. Pipu hemakapukupo. Pipu waforohokosane pipu sere ayapo. Rau waforohokosane rau sere ayapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Yasumo someraka, “Nómo aporo metane mawakasemahoasimo hokomaka someraka, ‘E watikiaka are. Ano koteaka rekenapo. E area ayiáka ano rekenafapo.’ Aihokopo. Aihoanafonorakano aporo metakiramo soko, Kotimo soko, neaki ayiáka somehokosafapo. ");
INSERT INTO faa_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nómo aporo meta ayiáka mawakasemaraka hokomaka somerakano, aporo metakiramo soko, neaki ayiáka mawakasemaraka hokomaka somehokosapo. Arirakano nómo someane parakuraka akara ayiáka, neaki aporo metakiramo soko, ayiáka parakuraka neaki kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Nómo ní maemo hia makata pepeno wakasema akayane nómo aseraka yia, nómo ní hia makata pepeno kára akayane, marirakano asekepayarakanare? ");
INSERT INTO faa_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Asekepayaraka yia ní maeaki someraka, ‘Ne hia makata pepeno wakasema akayane, nōmo maka mamakatehokosapo.’ Aíyaka somerakanone ne aporo himu tetáraka rekenapo. Fana nómo ní hia makata pepeno kára akayane maka mamakatehoanie. Mamakateraka faraka, ní maemo hia makata pepeno wakasema akayane maka mamakatehokosakipoko koane nómo ní himo sia koteaka aseakosapo. ");
INSERT INTO faa_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Arirakano Kotiaki makata yaku kakakosane kásaki kakakopo. Arirakano saro perakano saro hikumisi neneme yia, sekete kokomareakopo. Kokomarerakano seketeane saromo finiraka reke, oropatea kenetapikia marekea, neane kekemaraka rukua motokoa nakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Yasumo someraka, “Makata makosakipoko Kotiaki kurikurihoanie. Kurikurirakano Kotimo neaki makakosapo. Himo aseako koanie. Korakano kokoa aseraka makosapo. Ikia koro ropakamakasimo paroparohoanie. Paroparorakano Kotimo ropakamakosapo. ");
INSERT INTO faa_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Asiamo makata mako Kotiaki kurikurirakano makosapo. Makata aseako himo korakano kokoa aseakosapo. Nómo ikia koroa paroparorakano, Kotimo ropakamakosapo. ");
INSERT INTO faa_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Arirakano nómo ní hokosamo someraka, ‘Atao, ano asipa makasie.’ Airakano nómo ní hokosaki eke kakakosare? Wae, eke kakakosafapo. ");
INSERT INTO faa_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Arirakano hokosamo someraka, ‘Ano pokoa makasie.’ Airakano nómo eaki yapakā kakakosare? Wae, yapakā kakakosafapo. ");
INSERT INTO faa_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Asiamo ne himu watikisa yiamo nómo hokosaki makata kotesa karápo. Akara ayiáka, nómo Ata hepene yapura reamo soko, repo makata makasie aisa aporo hinamoaki Atamo makata namo kakaro kotesane kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Asiamo aporo metamo ne ayiakasimo nómo hemakapuraka, nómo soko aporo metaki ayiakanie. Asiamo ropo aina someane Mosesemo somemaneane soko, porofete aporomo somesane soko, some kepoane hakása yiyareapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Yasumo someraka, “Fanasina hauaka ikia kara kuru parauasakipoko aporo pukusane mawetenafapo. Mawetehoanafonorakano aporo yakai ikia kara á purapo. Arirakano ne yaiya rera hauaka á hiakosakipoko ikia kara makoropasa á hinie. ");
INSERT INTO faa_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Makoropasasamo maweteraka wafororaka yorokoa yaiya rera hauaka á hiakosapo. Ikia karane wakasemasasamo aporo hukusimo kokoa asekea hirapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Yasumo someraka, “Kotafe porofete aporomo Kotimo some kará porofete aporo pariraka some karápo. Ipu someane repo kakimarakarihoamo, kotafe hokokekea somehokosapo. Asiamo kotafe porofete aporo ayarihoamo, koteaka asekeanie. Saro wofe irirasane kotafe saro sipi pariraka risikirihoamo, koteaka asekea takeanie. ");
INSERT INTO faa_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","‘Kotimo some kará aporore? Kotimo some kará apororakapo.’ Aíyaka takekea hemakapukusakipoko, epo makata rakirane asekea takeanie. Aporomo makata rakirane, sako wate asiapo. Sako utumua sako karepe wate pekerisia tumarafapo. Arirakano kiāne ira foke wate pekerisia tumarafapo. ");
INSERT INTO faa_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ira kotesamo wate kotesa susu perapo. Ira watikisamo wate watikisa susu perapo. ");
INSERT INTO faa_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ira kotesamo wate watikisa perafapo. Ira watikisamo wate kotesa perafapo. ");
INSERT INTO faa_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Iramo wate kotesa peanafononane, aporomo tokoraka mamakateraka, iramo inakasimo pairapo. ");
INSERT INTO faa_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Asiamo kotafe Kotimo some kará aporo pariraka rakirakano asekeanie. Asekea hemakapuraka, ‘E Kotimo some kará aporofapo.’ Aíyaka hemakapunie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Yasumo someraka, “Aporo metakiramo anoaki someraka, ‘Unihae, Hokopusuo,’ aíyaka kaumo wára aporoane Kotimo ipi unihaeaka asekea rea aporomano akiyaki paohokosafapo. Asiāne nōmo Ata hepene yapura reamo hemakapusua kekemaraka rakira aporo hinamoane, i hákasa paohokosapo. ");
INSERT INTO faa_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Hukurura sere amo aporo hinamo yakaimo anoaki someraka, ‘Unihae, Hokopusuo, ne yano motosa makárahoasimo, Kotimo someane isiapo kaikia someane some kasapo. Ne yano hokoa yatafuaki metakarikia pusierakano, i pusuapo. Ne yano motosa kárasasamo isiapo wakapuaka rakirakano, aporo metakiramo asekea fofasapo.’ ");
INSERT INTO faa_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Airakano nōmo someraka, ‘Reane nōmo aserafapo. Re aporo watikisasamo ano metakarikia re pusie,’ aihokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Yasumo someraka, “Aporomo koteaka hemakapukua hauaka parosakipoko ape kisia paroaka area ayiáka, nōmo some kakimasa aporoane ayiáka rerapo. ");
INSERT INTO faa_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ape kisiakipoko atifo yaoyaki kára peraka, he huku puraka, hauaka parosa á ape kisiasamo rakarimaka purafapo. ");
INSERT INTO faa_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Arirakano aporo koteaka hemakapurafaraka hauaka sakipua ape kisia area ayiáka, nōmo some kakipayasa aporoane ayiáka rerapo. ");
INSERT INTO faa_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ape kisiakipoko yao kára atifoyaki kára peraka, he huku purapo. Puraka ape hauaka sakipua kisiane rakarimaka puraka anu airapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Someane some kaka farakano aporo hinamo yakaimo kaikia himu faraka fofasapo. ");
INSERT INTO faa_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kotimo somemane tisa aporomo some akara ayiáka Yasumo ayiáka some kasafapo. Epo wakapuaka some karakano kairaka, “Someane enahoasifareapo.” Aíyaka aporo hinamo fofasapo. ");
INSERT INTO faa_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yasu ūri terayia hikia kayane pariperakano, aporo yakaimo epo makata rakirane asekehaerape pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Asekehaerape puraka aporo toropakesa Yasu rea peraka, Yasu ipi yano motosa kárapo, aíyaka hemakapukua kakuna porokoa kake someraka, “Unihaeo, nómo ano mafahoko seseraka soko metao, seserire?” ");
INSERT INTO faa_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Airakano Yasumo ipi hokono máfaraka aporoane sakairaka someraka, “Ao, ano seseripo. Ne makata takamasane farasie.” Aihoanine aporo toropakesane wate foaka fasapo. ");
INSERT INTO faa_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Farakano asekea Yasumo someraka, “Ne fasane aporo metakiraki somehokopo. Pirisiti aporo rea pukua, ne kau toropakesa fasane pirisiti aporoaki tarinie. Tarikia, Mosesemo somemanemo ayiakanie aisane kekemaraka, makata yaku Kotiaki ayiáka kakanie. Ne fasane aporo hinamo suamo asekea hemakapusimo ayiáka kakanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yasu pukua Kapaneame taonea perakano, Rome aporo terakaiyamosa satini peraka Yasuaki someraka, ");
INSERT INTO faa_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Nōmo aporo raipa makata kára takamaraka, kau nariraka korosakataeraka apea warekenapo.” ");
INSERT INTO faa_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Airakano Yasumo someraka, “Ano nī peraka e mafahokosapo.” ");
INSERT INTO faa_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Airakano aporo terakaiyamosa satinimo someraka, “Unihaeo, ano aporo wakasemasasamo ne aporo kárasasamo iti siasafapo. Asiasamo nōmo apea ne peane siahoasifareapo. Ne aporo makata takamasa warea punafonoraka o reke, aporo makata takamasane farasie aisie. Nómo farasie airakano nōmo aporo raipa makata takamasane fahokosapo. ");
INSERT INTO faa_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Arirakano ano asekea rea aporoamo anoaki rakisierakano nōmo rakirapo. Arirakano nōmo aporo asekea reaki pusierakano ipi purapo. Peaerakano ipi perapo. Nōmo aporo raipaki rakisierakano, epo rakirapo. Nōmo aira ayiáka, nómo soko aporo makata takamasane farasierakano, e fahokosapo.” ");
INSERT INTO faa_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Airakano someane Yasumo kaikia sesesapo. Seseraka asekehaerape pesa aporoaki someraka, “Nōmo reaki kakaro somerakaripo. Rome aporo terakaiyamosa satini ane Yu aporofapo. Yu aporohoanafonosa reamo anoaki himu hakásaraka hemaka apura ayiáka, Isiraya hauaka Yu aporo metamo anoaki ayiáka himu hakásaraka hemakapurafareapo. ");
INSERT INTO faa_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Hao, kaisie. Koti unihaeaka rea hauaka á Eparahame soko, Aisake soko, Yakope soko, iyaki hakāsa toke makata nakosakipoko, Yu aporohoanafonosane yakai hiakosapo. Arirakano maiya apera hauaka taku aeyaka soko, maiya apura hauaka taku aeyaka soko, i yakai hiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Arirakano Yu aporo hinamo Koti unihaeaka rea hauaka á hiakosapoko asiāne, ipu anoaki himu hakásaraka hemakapunafonorakano, iane Kotimo kakaro metakariakosapo. Katosa hauaka á pusiehokosapo. Pusierakano pukua á risike, i hihiripuraka saperaka akai kirisihokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Asiamo Rome aporo terakaiyamosa satiniaki Yasumo someraka, “Ní apea paripusie. Nómo anoaki himu hakásaraka hemaka apura yaiya nōmo rakirakanapo.” Aíyaka somehoanine aporo raipa makata takamasane fasapo. ");
INSERT INTO faa_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yasu pukua Pitamo apea yorokoa aseane, Pitamo ipi aseamo kaīyia makata takamasa kau sisipuraka warekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Aseraka hinamoamo hokonoa Yasumo sakaihoane, makata takamaraka kau sisipusane fasapo. Farakano asekea, hinamoane takahikia makata nakosa paikia Yasuaki kasapo. ");
INSERT INTO faa_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Arirakano wakasema nina samapu yao nene horamo, aporo hinamo yakai yatafumo ho mosane Yasu rea aporo metakiramo karikia pesapo. Karikia perakano yatafuaki Yasumo ipi akaimo hákasa some hora yiamo yatafuane metakarikia pusuapo. Arirakano aporo hinamo makata tasane soko suane Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mafasane mafahoasiraka wate fana porofete aporo Aesayamo popasapo. Popasane oyapo, “Isiapo makata tasane wakasema soko kára soko epo mafanapo.” Aíyaka popasane faserepesa ayareapo. ");
INSERT INTO faa_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aporo hinamo yakai Yasu yaki sarimasane Yasumo asekea, ipi aporo hakāsa puraki someraka, “Isu kasua ripaka he Kariri taku ra purakapo.” ");
INSERT INTO faa_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Airakano e rea Kotimo somemane tisa aporo meta peraka Yasuaki someraka, “Tisao, ne taku ra purakano soko, taku ro purakano soko, sapeaka hinakano soko, ano neyaki hakāsa koraka rekeakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Airakano aporoane kau aseakosakipoko Yasumo eaki someraka, “Yákasa ipi hauaka rapia warápo. Mena ipi usia warápo. Ipu ape waráne risikinapo. Arirakano Ano Aporomanomo Tákeane ape wará uni katane rekenafapo.” ");
INSERT INTO faa_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Airakano aporo hakása meta Yasuyaki hakāsa puraka ipi someraka, “Unihaeo, ano neyaki peakosapoko asiāne, fana nōmo nī ata kurakano hauaka marekea faraka, neyaki peakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Airakano Yasumo someraka, “Ní ata metakarikia, anoyaki peanie. Aporo ano patera asekeanafonosamo aporo kusuane hauaka mareakosapo. Aporo ano patera asekeanafonosane i aporo kusua asiapo. Aporo kusua asiasamo ipu aporo kusuane hauaka muriane siahokosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yasu kasua ripaka ipi aporo hakāsa pura soko, eyaki hakāsa kasua ripaka pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ripaka puraka Yasuane kasua wasápo. Wasakipoko yao foaka peraka atifoyaki he kupayaki kára pesapo. He kupa kára peraka, kasu tua he wakekeraka, kasu kenepesahopo. ");
INSERT INTO faa_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kenepeakorakano asekea, aporo hakāsa puramo Yasu maturikia someraka, “Unihaeo, isu araresie. Kasu keneperaka isu he nasireapo.” ");
INSERT INTO faa_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Airakano Yasumo iaki someraka, “Repo marirakano namorakanare? Anoaki kakaro himu hakásaraka kára hemakapurakanafareapo. Wakasemaraka hemakapureapo.” Aíyaka Yasu takahikia atifoaki soko, he kupaki soko, “Farasie,” airakano, atifo soko, he kupa kára pesane soko, foaka fasapo. Faraka he auasapo. ");
INSERT INTO faa_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","He auarakano asekea, aporo hakāsa puramo fofaraka someraka, “Yasumo someane atifomo soko, he kupamo soko, kakimaraka fane. Fasasamo aporoane eparakapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","He kekea kaya kasu rokoa hikia, Katára hauaka á kasu karimarekea hikia aseane, aporo tetá yatafumo ho mosa aporo kusua taena kunikia aeyaka perakano asesapo. Aporo tetane irirasasamo tetapō kunikia makeraka aporo meta purafapo. ");
INSERT INTO faa_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Asiamo Yasu kasua ripaka pekea kasu matapea karikimarerakano asekea, aporo tetane Yasu rea pesapo. Peraka Yasuaki poaeraka someraka, “Ne Kotimo hokosapo. Nómo eto mayiakakosare? Fanasihokosa maiyane haru faserepeasiraka nómo etoaki fanasiraka kau teraka yaiya rerane kakako perakayiare?” ");
INSERT INTO faa_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aíyaka aseane saro yakai makeraka makata nenaka risikino asesapo. ");
INSERT INTO faa_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Asekea yatafumo Yasuaki someraka, “Nómo isu pusierakane saro tua risikiako pusiesie.” ");
INSERT INTO faa_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Airakano iaki Yasumo someraka, “Re pusie,” airakano yatafu pukua saro tua risiapo. Saro tua risikirakano saro su ūri kakafae aeyaka foaka sosonoraka peraka, he fesere mosakipoko aeyaka eteraka he numua hurupeperaka saro suane he nekea kukua kesapo. ");
INSERT INTO faa_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kukua kerakano asekea, saro asekea risia aporoane apea teketarikia hisiapo. Hinaka aporo yatafumo ho mosa mafasane soko, saro kukua kesane soko, makata asesane su somesapo. ");
INSERT INTO faa_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Somerakano ape aeyaka aporo suamo Yasu aseako pesapo. Peraka himu faraka Yasuaki someraka, “Isiapo hauakane ne metakarikia pusie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yasumo Katára hauakane metakarikia, kasu ripaka poparipekea ipi taonea fosāpo. ");
INSERT INTO faa_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fōkoa risike aseane, aporo korosakataesane fefeneakua makekea ira paka maka perakano asesapo. Maka pesa aporoamo aporo korosakataesane Yasumo mafahoasimo Yasuaki himu hakásaraka hemakapukua maka perakano asekea, Yasumo aporo korosakataesaki someraka, “Hameo, mapiraraka hemakapunie. Nómo himu watikisane nōmo mafarakanapo.” ");
INSERT INTO faa_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Airakano Kotimo somemane tisa aporo metakiramo namina susu hemakapuraka, “Aporo himu watikisa mafarakanapo airakane Kotimo airaka sikirakae. Epo Kotiane mawakasemarakae.” ");
INSERT INTO faa_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Aíyaka hemakapurakano ipu hemakapusuane Yasumo aseraka someraka, “Repo marirakano ano mahokoparirakanare? ");
INSERT INTO faa_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aporomo himu watikisa mafanane kárare? Aporo makata takamasa mafanane wakasemare? Meta mane kárare? Meta mane wakasemare? Wae, tati siasapo. ");
INSERT INTO faa_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Aporomanomo Tákeane anopo. Hauaka wo aporo himu watikisane nōmo mafahoasimo Kotimo ano murikimaka maresapo. Maresasamo repo asekeasimo aporo korosakataesaki nōmo takahisierakanapo.” Aíyaka aporo korosakataesaki Yasumo someraka, “Ne takahisie. Takahikia ní asakapuane maweroraka maka nómo ní apea pusie.” ");
INSERT INTO faa_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Airakano aporoane takahikia ipi apea pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Purakano aporo hinamo sarimasamo aseraka fofasapo. Fofaraka ipu hemakapuraka, “Makata watikisa mafana wakapuane Kotimo aporoaki kayereapo.” Aíyaka hemakapuraka ipu Kotiaki kekeresapo. ");
INSERT INTO faa_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yasumo hauakane metakarikia puraka aseane, takese mora aporo yano motosa Matiu, takese mora oposea kakeno asesapo. Aseraka Matiuaki Yasumo someraka, “Ne ano patera aseako peae.” Airakano Matiu takahikia Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pukua Matiumo apea pauraka ape namoa yorokoa toke, Yasu soko ipi aporo hakāsa pura soko toke, iyaki takese mora aporo metakira soko, aporo himu watikisa soko, sarimaraka toke, makata nesapo. ");
INSERT INTO faa_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","I suane hakāsa toke makata nenakano, Ferese aporomo aseraka, Yasumo aporo hakāsa puraki someraka, “Marirakano repo tisane takese mora aporoyaki aporo himu watikisayaki hakāsa toke makata nenakanare?” ");
INSERT INTO faa_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aíyaka ipu somerakano Yasumo kairaka iaki someraka, “Aporo koteaka reane mitikoromo mafahoko purafapo. Aporo makata takamasane mitikoromo mafahoko purapo. ");
INSERT INTO faa_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Asiamo aporo himu watikiaka risiamo watikisane metakarikia risikiako parihoasimo iaki peaehoko ano perakayiapo. Aporo kotesane peaehoko ano perakayiafapo. Asiamo Kotimo sawia popasane enomako hemakapunie. Kotimo someraka, ‘Anoaki makata rukua paikia yaku karakano asekea nōmo wakasema sesenapo. Arirakano aporo metaki kamenakaraka himu purakano asekea nōmo kára sesenapo.’ Aíyaka popasamo kepoane hemakapukusakipoko koanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Yasu rea Yone he tapukumareramo aporo hakāsa pura peraka Yasuaki someraka, “Kotimo asekeasimo isiapo soko, Ferese aporomo soko, maiya metakiramo makata nakosa nekea, maiya metakiramo makata nakosa sokoainapo. Nómo aporo hakāsa puramo maiya suamo makata nakosa nenaka risikinapo. Ipu makata nakosa sokoaihoanafononane mainakanonare?” ");
INSERT INTO faa_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Airakano Yasumo ipiane takumeaka someraka, “Aporomo hinamo arumarakano aporo suamo hokono keraka seseaka makata nenapo. Makata nenaka aporo hinamo kawe apia iyaki hakāsa rekeno, i himu hisihoanafonoraka seseraka risike, makata nakosa sokoainafapo. Arirakano aporo hinamo kawe apiane aporo metakiramo waseremaka apura maiya amo, ipu himu hisiraka makata nakosane sokoaihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Arirakano pasu paté koasakipoko pasu kawe paremarekea irisane, pasu kaweane kuruhenaka pasu patéane fe taku aeyaka hatirirurapo. Hatiriruraka kára koahokosapo. Anapaka pasu patéyaki pasu kaweyaki sarimaraka irinafapo. ");
INSERT INTO faa_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Arirakano nanikose kau aporomo maka petoro irinapo. Waene he kawe metekesane petoro patéa takamanafapo. Takamarakano waene he kaweamo ponoponoraka petoro patéane faurakosapo. Fauraka petoro kakeraka waene he sakuriakosapo. Sakuriraka waene he soko petoro soko tetákara fahokosapo. Arirakano waene he kawe metekesane petoro kawea takamarakano petoro faunafapo. Fauhoanafonoraka, tetákara tati siaraka risikiakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yone he tapukumareramo aporo hakāsa puraki Yasumo someraka rea maiya amo, Yu aporomo sarimana ape asekea rea aporo metane pesapo. Pekea kakuna porokoa kake Yasuaki someraka, “Nōmo hinamo hokosa kawe kusuapo. Kusua nine ne peraka, e sakaihoane turikia pukua hitaferaka kakakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Airakano Yasu takahikia eyaki hakāsa pusuapo. Puraka ipi aporo hakāsa pura soko, eyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Purakano asekea hinamo meta patera aeyaka pekea, ipi himumo hemakapuraka, “Ano keremisi keno sumo wake apea makama yiaraka kayapo. Kayasasamo, Yasumo pasua nōmo sakaihoane ano wake apea makama yiaraka kayane fahokosapo.” Aíyaka hemakapukua Yasu purakano asekea, e patera aeyaka pekea Yasumo pasu ke huhua sakaisapo. ");
INSERT INTO faa_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Sakairakarakano Yasumo kaikia rekeako pariraka, hinamoaki someraka, “Hinamo ne karekekea kakakopo. Mapiraraka kakanie. Nómo anoaki himu hakásaraka hemaka apura yiamo, ne makata takamasane mafarakayiapo.” Aihoanine hinamoane makata takamasane wate foaka fasapo. ");
INSERT INTO faa_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Farakano i pukua Yu aporomo sarimana ape asekea rea aporomo apea pauraka, ape namoa yorokoa pukua aseane, hokosa kusuakipoko hinamomo hihiripuraka, metakiramo kamenakaraka hihiripurakano asekea, ");
INSERT INTO faa_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Yasumo iaki someraka, “Re su yaoa pusie. Hinamo hokosane kusuafapo. E wayereapo.” Airakano aporo hinamo suamo Yasuaki hokomarekea keasapo. ");
INSERT INTO faa_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kearaka i yaoa purakano asekea, hokosa kusua warea apea Yasu yorokoa pukua, hokosa hokonoa maka máfaraka maturikia taesapo. ");
INSERT INTO faa_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Maturikia taerakano asekea, hokosa ane maturikia taesane hauaka makea aporo hinamo suaki somepe pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yasu puraka kaiyiáne aporo tetá hi fausamo Yasu kekemarape peraka Yasuaki wáraka, “Tefetemo aporo ira Yasuo, nómo eto kamenakaraka araresie.” ");
INSERT INTO faa_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Airakano Yasu apea pekea yorokoa reke aseane, aporo tetá hi fausane perakano asekea, Yasumo tetāki someraka, “Tetápo hemakapuraka, ‘Eto hi fausane nōmo mafahoasimosapo,’ aíyaka hemakapurakanare?” Airakano tetapō someraka, “Ao, Unihaeo, nómo eto mafahoasimo hemakapurakaripo.” ");
INSERT INTO faa_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Airakano tetā hia epo sakairaka someraka, “Tetápo hemakapuraka eto mafahoasimosapo, aíyaka hemakapusuasamo teto mafarakanapo.” ");
INSERT INTO faa_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Aihoanine tetā hi fausane faraka koteaka asesapo. Farakano asekea Yasumo tetāki paroaka someraka, “Tetápo hi fausa mafasane aporo hinamo metaki somehokopo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Airakano yia tetapō Yasumo rakisiane aporo hinamo suaki somepe pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aporo tetá hi fausa mafasane pusuakipoko, aporo meta yatafumo ho masa me fasane aporo metakiramo karikia pesapo. ");
INSERT INTO faa_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Karikia perakano Yasumo yatafuaki someraka, “Ne metakarikia pusie.” Airakano yatafuane pusuapo. Purakano aporo me fasamo koteaka somesapo. Somerakano aporo sarimasamo kaikia fofaraka someraka, “Epo rakirane hakureapo. Isiraya hauaka wo isiapo aporo metamo ayiáka rakirakano fana isiapo asesafapo.” ");
INSERT INTO faa_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Aíyaka somerakano Ferese aporomo someraka, “Wae, yatafu metakarikia pusiehoasimo, yatafumo unihae Satanemo wakapuane Yasumo maka yatafu pusierakano apure,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Taone sua soko, ape sumu wakasema á soko, Yasu koraka reke, Yu aporomo sarimana ape sua Yasumo some kotesa some kape pusuapo. Epo some karáka, “Koti unihaeaka rekenapo,” aíyaka some kotesane some kasapo. Some karáka rea maiya amo, aporo metakira makata kára tasane soko, wakasema tasane soko, suane Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mafaraka reke aporo hinamo suane Yasumo asekea hemakapuraka, “Saro sipi wafaya fasekeno saro sipi mokome pusua, hasaka korapo. Arirakano saro sipi metakira fafaoraka risirapo. Aina ayiáka aporo hinamo arisiane ayiáka risikinapo.” Aíyaka Yasumo aporo hinamo supoko kamenakaraka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Kamenakaraka hemakapukua aporo yakaiane, aporo hakása metamo ararehoanafonosakipoko, Yasumo ipi aporo hakāsa puraki takumeaka someraka, “Ira wate sūsane kárareapo. Asiāne ira wateane tuakosane aporo hukusireapo. ");
INSERT INTO faa_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Asiamo ira wate sūsane aporo raipamo tuako pusiehoasimo hemo wafayaki kurikurihoanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yasumo ipi aporo hakāsa pura keno suaki peaerakano pesapo. Perakano ipu yatafuane metakarikia pusiehoasimo, i murikimaka wakapu kasapo. Ipu aporo makata kára tasane soko, wakasema tasane soko, ipu mafahoasimo, iaki Yasumo wakapu kasapo. ");
INSERT INTO faa_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ayiáka Yasumo aporo kenosu murikimaka iaki tarira aporo yano motosapo. Ipu yano taesane oyapo. Saemone ipi yano motosa meta Pita, arirakano meta Saemonemo ipi mamanea Enitu, arirakano meta Sepetemo maeya Yamese, arirakano meta Yamesemo ipi mamanea Yone, ");
INSERT INTO faa_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","arirakano meta Firipi, arirakano meta Patóromiu, arirakano meta Tomase, arirakano meta takese mora aporo Matiu, arirakano meta Afiasemo maeya Yamese, arirakano meta Tátiase, ");
INSERT INTO faa_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","arirakano meta Rome kamanimo Yu aporo asekea reane metakariakosakipoko hemakapura aporo Saemone, arirakano meta Yasu parakehokosa aporo Yutase Isekerio, ayiáka Yasumo aporo kenosuane murikimasapo. Murikimasane tarira aporo ayapo. ");
INSERT INTO faa_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Aporo keno suaki Yasumo someraka, “Re uyáka punie. Puraka Yu aporohoanafonosamo apea pukupo. Sameria aporomo apea pukupo. ");
INSERT INTO faa_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Saro sipi rosaka tarikia arisia ayiáka Isiraya aporo hinamoane ayiáka risikinapo. Iaki somehoko pusie. ");
INSERT INTO faa_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Pukua some karáka, ‘Koti unihaeaka rekeakosa maiyane faserepesapo.’ Aíyaka somehoanie. ");
INSERT INTO faa_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Aporo hinamo makata takamasane mafahoanie. Arirakano aporo hinamo kusuane maturikia taehoanie. Arirakano aporo hinamo toropakesane mafahoanie. Arirakano yatafumo aporo hinamo ho mosane yatafuane metakarikia pusiehoanie. Aíyaka mafana wakapuane repo yaku mosasamo, repo aporo hinamo suane yaku mafahoanie. ");
INSERT INTO faa_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Asiamo re puraka, mone sawi soko, siufa mone hae soko, mone kusua soko, mone suane pausia kesane mokoa pukupo. ");
INSERT INTO faa_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Re kimisi puraka aku soko, pasu meta soko, mokoa pukupo. Tamaka soko, tatia soko, makata suane mokoa pukupo. Asiamo repo makata rakirane rakisiakipoko repo araresa aporomo reaki makata nakosa kayane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Re kimisi pukua apea pauraka repo kairaka, ‘Koteaka rera aporo epare?’ Aíyaka kaiyinie. Kaiyiáne tarirakano, apea yorokoa ape hakása yia waka risikianie. Ape sumu meta pukusakipoko ape ne wasa aeyaka punie. ");
INSERT INTO faa_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ape wará tarirakano á pukua, ape wafaya hokono maka eaki someraka, ‘Ano perakayiapo. Kotimo ne makoterakano ne auaraka rekeasimo hemakapurakaripo.’ Aíyaka some kakanie. ");
INSERT INTO faa_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Some kasane ape wafayamo kaikia peaerakano, puraka auaraka rerane eaki some kakanie. Arirakano ape wafayamo peakoporakano auaraka rerane apea some kakakopo. Apeane metakarikia punie. ");
INSERT INTO faa_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Arirakano aporo metakiramo reaki terehoanafonoraka, repo someane kakipayarakano, taoneane metakarikia punie. Puraka namina hisisasamo aporoaki Kotimo seserakanafapo. Aíyaka ipu hemakapusimo yapakeraka korakea kokotonomosane rerakatapikia marekea metakarikia punie. ");
INSERT INTO faa_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Hao, kaisie. Nōmo reaki kakaro somerakaripo. Hukuarura maiya amo aporo hinamo Sotome taonea soko Komora taonea soko watikiaka rakiraka risiane fanasihokosane kárahokosapo. Arirakano repo some kayane kakipayasa taonea aporo hinamo risiane fanasihokosane namo kakaro kárahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Aporo hakāsa puraki Yasumo someraka, “Kaisie. Reane saro sipi auasa asíapo. Aporo watikisane saro wofe irirasa asía risiakipoko nōmo re saro sipi asíane pusierakanapo. Arirakano kuyare tau apura ayiáka re tau punie. Aporomo re mokoatikinapaka tau punie. Arirakano mena numemo makata meta mokoatikihoanafonona ayiáka, repo soko ayiáka aporo meta mokoatikihokopo. ");
INSERT INTO faa_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aporomo re mokoatikinapaka asekeanie. Re aporo metakiramo waseremokoa hukurura apea hukurukua, ayiáka Yu aporomo sarimana apea ira faimo reane rukusapo. ");
INSERT INTO faa_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Arirakano repo ano patera asesasamo, kamani aporomo soko, aporo unihaemo soko, reane hukurusimo aporo metakiramo reane waseremokoakosapo. Waseremokoa hukururakano repo iaki soko, Yu aporohoanafonosaki soko, anoane makáraraka somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Reane hukururakano repo somehokosane karekeakopo. Asiamo re somehokosane repo himura mahemakapurakarakano repo somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Repo namina metamo hemakapusua somehokosafapo. Atamo Ho Kotesamo reaki some karakano, epo some kasa hakása nine, repo somehokosapo. Repo siaraka somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Arirakano aporomo ipi mamaneane aporo metamo rusimo parakehokosapo. Arirakano wafayamo ipi hokosane aporo metamo rusimo parakehokosapo. Arirakano hokosamo ipi wafaya kaīyia tetāne aporo metamo rusimo parakehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Re ano patera asesasamo reane aporo suamo hisihokosapo. Hisirakano yia aporo hinamomo anoaki patera asesane metakarirafaraka yaiya anoaki hemakapuraka risikino, aporo hinamoane Kotimo mafasiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Taone meta á re mokoatikirakano takaripukua taone meta á punie. Taonea soko ipu reane mokoatikirakano yaiya takaripukua taone meta á punie. Nōmo some one kakaro somerakaripo. Aporomanomo Tákeane anopo. Repo Isiraya hauaka taone sua nōmo someane some kape pukua, some kaka fahoasiraka, taone hukusi metakira some karaka arisiamo ano paripeakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Yasumo someraka, “Sukuru aporomo ipi tisane marokenafapo. Arirakano aporo raipamo ipi wafayane marokenafapo. ");
INSERT INTO faa_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tisa area yaiya sukuru hokosa soko yaiya kekemaraka risike siahoasireapo. Arirakano makata rakira wafaya area yaiya aporo raipa soko, yaiya kekemaraka risike siahoasireapo. Arirakano ape wafaya asiane anopo. Aporo metakiramo anoaki mokoatikiraka someraka, ‘Ne Satane Piaósipupo,’ airakasupo. Aísa ayiáka anoa paosa aporo hinamoaki soko, ayiáka kára mokoatikiraka aihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Asiamo reane mokoatikihokosa aporoaki namohokopo. Makata faremaresane mafekemahokosapo. Makata mahamesane hufitaehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nōmo reaki hákasa somerakano, re katosa arisia, aiyaka risiane keseke someamo kepoane repo hemakapuraka, faeana ayiáka faehokosapo. Faesane aporo suamo kaiyisimo nōmo somesane iaki somehoanie. Nōmo reaki tau somesane aporo suamo kaiyisimo ape kára á sakepamo somehoanie. ");
INSERT INTO faa_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aporomo ne kau kukusimo rurakano aporoaki namohokopo. Arura aporoamo ne hoane makurafapo. Arirakano ne kau soko, ho soko, mokoatikiraka heao hauaka á pusie, aira Kotiaki namohoanie. ");
INSERT INTO faa_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Arirakano maketea mena muri asia aporomo roponapo. Roporaka mena muri asiane tetá mone hae kusua hakásamo (1 toea) roponapo. Mena muri asiane hakása kurakanone, repo Atamo aserapo. Repo Atamo aohoanafonorakano mena muri asiane hakása huruperaka kurafapo. ");
INSERT INTO faa_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Mena muri wakasemane Kotimo asekea rerapo. Mena muri wakasemane asekea rerasasamo, re aporomanoane Kotimo namo kakaro kára hemakapukua asekea rekenapo. Asekea reke re uni iti suane epo hakása hakásaraka menoaka hemakapukua fasapo. Uni iti menoraka asekea rerasasamo re namohokopo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Yasumo someraka, “Aporo hinamo suamo kaiyisimo aporo metamo someraka, ‘Ano Yasu patera aserakanapo.’ Aíyaka somerakano, nōmo Ata hepene yapura reamo kaiyisimo nōmo someraka, ‘Ano patera asesa aporo ane ayapo,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Arirakano aporo hinamo suamo kaiyisimo aporo metamo someraka, ‘Ano Yasu patera aseako hisiripo.’ Aíyaka somerakano, aporoane nōmo Ata hepene yapura reamo kaiyisimo nōmo someraka, ‘Aporoane ano patera asesafapo. Ano patera asekeanafonosasamo eane nōmo metakarirakanapo,’ aihokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yasumo someraka, “Repo hemakapuraka, ‘Yasu pesasamo hauaka wo aporo su tákeraka tau auaraka risikiakosapo,’ aíyaka hemakapukupo. Ano pesasamo aporo hinamo su tákeraka tau auaraka risikiakosafapo. Aporo hinamo metakiramo anoaki himu hakásaraka hemakapukua, arirakano aporo hinamo metakiramo anoaki himu hakásaraka hemakapunafonosasamo tau auaraka risikiakosafapo. Ano wo pesasamo aporo hinamo namina yia fasikia yunuraka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Asiamo ano pesasamo aporomo ipi wafaya tati rakumarekea risikiakosapo. Arirakano hinamomo ipi kaīyia tati rakumarekea risikiakosapo. Arirakano hinamomo ipi apiamo kaīyia tati rakumarekea risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Arirakano aporomo ipi aporo ira hakāsayaki, ipi ape hakāsa risia namina rakumarekea yunuraka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Arirakano aporomo ipi wafaya soko metao, ipi kaīyia soko metao, himu matumururaka hemakapuraka ano makama kesekearaka hemakapurakano, aporoane anoyaki siaraka rekenafapo. Arirakano aporo metamo ipi aporo hokosa soko metao, ipi hinamo hokosa soko metao, matumururaka hemakapuraka ano makama kesekearaka hemakapurakano, aporoane anoyaki siaraka rekenafapo. ");
INSERT INTO faa_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ano ira matopesa paremareraka kukusakipoko ira matopesane nōmo nī maka pura ayiáka, repo soko, hauaka wo makatane su makama kesekearaka ira matopesa maka, ano finihaoa fini kafo kepe peanafonorakano, re anoyaki siaraka rekenafapo. ");
INSERT INTO faa_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Aporomanomo hauaka wo areamo hitaferaka rekeakosane hákasa hemakapurakano, aporoamo Kotiyaki yaiya rerane kokoa makosafapo. Arirakano aporomo anoaki hemakapuraka, hauaka wo kau hitaferaka rekeakosane makama kesekearaka hemakapurakano, aporoamo Kotiyaki yaiya rerane kokoa makosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Aporo kenosu kimisi pukorakano Yasumo someraka, “Re apea peane aporomo re tereraka pasimorakano ane, ano pasimarakanapo. Ano pasimarakano ane, ano pusiesa Kotiane soko pasimarakanapo. ");
INSERT INTO faa_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Arirakano porofete aporoane Kotimo some kará aporopo. Kotimo some kará aporosasamo, some kará aporoane aporo metamo tereraka pasimarakano some kará aporo kimisi pesaki Kotimo makata ropo akara yaiya, aporo meroaki soko, makata ropo hakása nineraka kakakosapo. Arirakano aporo ereketaeraka rerasasamo aporo metamo e pasimarakano, aporo ereketaeraka reraki Kotimo makata ropo akara yaiya, pasimasa aporoaki soko, makata ropo hakása nineraka kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Arirakano anoa paosa aporo wakasemaki aporo metamo someraka, ‘Ne Yasu patera asesasamo nōmo ne he nasimo karakanapo.’ Aisa aporoaki Kotimo makata ropo kakakosapo. Nōmo some one kakaro somerakaripo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Aporo hakāsa puraki Yasumo some kaka faraka, apeane metakarikia ape sumu metakira ape makeraka risia á Yasumo some kakako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yone tipura reke kaiyiane, “Keresomo Kotimo wakapuyaki rakirakanapo.” Airakano epo kairaka ipi aporo hakāsa pura metakiraki someraka, “Yasu rea kaiyako pusie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Pusierakano i pukua Yasuaki kairaka, “Kotimo aporo pusierakano peakosapo airakasuane nere? Aporo metare? Aporo meta perakarihoamo isu kau risikiaere?” ");
INSERT INTO faa_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Airakano iaki Yasumo someraka, “Re pukua repo makata kaisiane soko, makata asesane soko, Yoneaki somehoanie. ");
INSERT INTO faa_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Amano hi fausane mafasa koteaka aserakanapo. Arirakano amano korake matipusane maraesa koteaka purakanapo. Arirakano amano toropakesane mafasa koteaka risikinapo. Arirakano amano senaki tisane mafasa koteaka kairakanapo. Arirakano amano kusuane mafareasa turikia tarikia risikinapo. Arirakano amano makata forokoa risiaki soko, Kotimo some kaiyanafonosa aporo hinamoaki soko, Kotimo some kotesa some karakanapo. ");
INSERT INTO faa_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Asiamo anoaki himu hakásaraka hemakapurane metakarirafaraka yaiya hemakapuraka risikino, aporo hinamoane Kotimo makotenapo. Aíyaka makata suane repo Yoneaki somehoanie.” Aíyaka aporo pesaki Yasumo some kasapo. ");
INSERT INTO faa_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Some kaka faraka aporoane paripurakano asekea Yasumo aporo yakai sarimasaki someraka, “Yonemo ima yaoa some karakano, repo ima yaoa yakapa aseako pusuare? Fofako atifomo mahohoanane aseako pusuare? Wae, fofako atifomo mahohoanane aseako pusuafapo. ");
INSERT INTO faa_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Repo fofako aseako punafonoraka yakapa aseako pusuare? Aporo kau rakisiane aseako pusuare? Wae, aporo kau rakisiane unihaemo apea rerapo. Aporo kau rakikia ima yaoa rerafapo. ");
INSERT INTO faa_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Asiane repo yakapa aseako pusuare? Kotimo some kará porofete aporo aseako pusuare? Ao, repo Kotimo some kará porofete aporo kárane asesapo. ");
INSERT INTO faa_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Wate fana Kotimo sawia Kotimo some kará porofete aporo metamo popasane oyapo. Mafasira aporoaki Kotimo someraka, ‘Ne pusiraka aporo metamo fana some kakako nōmo pusiehokosapo. Aporoamo ne ikia kara pukusane makotehokosapo.’ Aíyaka Kotimo somerakano Kotimo some kará porofete aporomo kaikia popasapo. Arirakano Kotimo aporo fana pusiehokosane Yoneane popasapo. ");
INSERT INTO faa_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nōmo some one kakaro somerakaripo. Nōmo some kakasiraka aporo su wainepe pusuamo aporo makama fanasane Yone he tapukumarera ipipo. Arirakano ano perakano aporo metamo someraka, ‘Ano aporo wakasemane Unihae Yasumo ano asekea rekenapo,’ Aira aporoamo ‘Unihae peakosapo,’ aíyaka somesa aporoane makama kesekenapo. ");
INSERT INTO faa_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Aporo hinamo ape kakarua hiakosakipoko ikia koro mapirisikino rukuropaka taeana ayiáka, Koti unihaeaka rea hauaka hiakosakipoko aporo hinamomo ikia koro rukuropakataehokosakipoko wakapurakanapo. Yone he tapukumarera rea maiyamo asia ayiáka, yumo soko anakanapo. ");
INSERT INTO faa_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yone he tapukumareramo some kakasiraka, Unihae peakosane Kotimo some kará porofete aporomo popasapo. Arirakano Kotimo somemane popasane hakása nineraka popasapo. ");
INSERT INTO faa_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Asiamo ipu somesane repo kairakanone nōmo someane soko kaiyinie. Iraíya paripeakosapo aisane Yonepo. ");
INSERT INTO faa_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Re senaki risiamo kairaka koteaka kaisie. ");
INSERT INTO faa_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Maiya omo aporo hinamo risiane nōmo mayiáka somehokosare? Nōmo takumeaka somerakanapo. Hokosamo hauaka moroa enaraka namina yia hokosa metakiramo hokosa metakiraki someraka, ");
INSERT INTO faa_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Isiapo wiroko takiane repo seseaka paoraka hakāsa kesarakarifapo. Isiapo hiripuhoane repo soko paoraka hiripurakarifapo,’ aisapo. Asiamo i arisia ayiáka, re soko ayiáka risikinapo. ");
INSERT INTO faa_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ayiáka risiamo kepoane oyapo. Yone he tapukumarerane peraka makata nakosa sokoairaka, waene he soko nesafapo. Nanafonorakano asekea, repo someraka, ‘Yoneane yatafumo ho mayereapo,’ aisapo. Aíyaka re Yonea paosafapo. ");
INSERT INTO faa_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Arirakano Aporomanomo Táke ano peraka, makata nakosa soko waene he soko nenapo. Nenakano asekea repo someraka, ‘Yasumo nako fitiraka sapekeamo nenareapo. Waene he soko kára nenareapo. Arirakano aporo takese morane soko, aporo metakira himu watikisane soko ipi tákereapo.’ Aíyaka someraka re anoa paosafapo. Paohoanafonosa nine Kotimo hemakapusuane nōmo kekemaraka rakirakano, aporomo asekea hemakapuraka, ‘Kotimo hemakapusuane ereketaehoareapo,’ aíyaka hemakapukusapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Korasini taonea soko, Pesaita taonea soko, Kapaneame taonea soko, Kotimo wakapumo hemakapukua rakira Yasumo makata yakai rakirakano, aporo hinamo risiamo asesapo. Asekea yia ipu himu watikisane metakarikia risikiako parisafapo. Risikiako parihoanafonorakano Yasumo iaki hukurukua someraka, “Re yaiya watikiaka risikinapo. ");
INSERT INTO faa_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Uao. Enahoasifareapo. Korasini aporo hinamo reo, Pesaita aporo hinamo reo, repo aseraka yia repo makata watikisane metakarianafonorakano, re kára fanasihokosapo. Repo taonea Kotimo wakapumo hemakapukua rakirane nōmo rakisiapo. Rakisiane Yu aporohoanafonosamo Taia taonea soko, Saetone taonea soko, nōmo rakisia satiki, ipu makata watikisane wate fana metakariafunupo. Metakarikia ipu makata watikiaka rakisiasamo i kaíyaraka risike, kaua ororomo paikia pasu pitikini makafirikia arupekea ayiáka tokoafunupo. Ayiáka toke ipu makata watikisane metakarikia risikiako parihoafunupo. Asiāne nōmo rakisiane ipu asesafapo. ");
INSERT INTO faa_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Kaisie. Takekea hukurukua fanasina maiya amo Taia aporo hinamoane soko, Saetone aporo hinamoane soko, wakasema kára fanasihokosapo. Repo aseraka yia risikiako parihoanafonosakipoko re kára fanasihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kapaneame aporo, repo hemakapuraka, ‘Isu hokopukua risikiakoripo.’ Aíyaka hemakapukua hepene taone yapurane máfana ayiáka repo namina yano motosa máfahoko hemaka apure. Asiamo keseke heao hauaka atura re mokoasuhokosapo. Asiamo Kapaneame aporo, repo taonea nōmo makata wakapuaka rakisia ayiáka, Sotome taonea Kotimo some kará porofete aporomo wakapuaka rakisia satiki Sotome aporomo ipu makata watikisane metakarikia risikiako parihoafunupo. Asiamo Kotiaki risikiako parisa satiki, Sotome taoneane Kotimo pakimareafunufapo. ");
INSERT INTO faa_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Kaisie. Kotimo hukuarura maiya amo Sotome aporo hinamoane Kotimo wakasema kára fanasinane motoakosapo. Repo asekea yia makata watikisa metakarikia risikiako parihoanafonosakipoko, re namo kakaro kára fanasinane motoakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Maiya amo Yasumo Kotiaki seseraka someraka, “Atao, hepene yapura soko, hauaka wo soko, nómo unihaeaka asekea rekenapo. Asekea reamo aporomo makata su enomasaki nómo ní faremaresa makata ane mafekemaraka tarirakanafapo. Asiāne nómo ní hokosa asíaki nómo makata faremaresane mafekemaraka tarirakanapo. Tarirakano nōmo neaki suserakanapo. ");
INSERT INTO faa_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Atao, nómo ní hemakapusua aporoaki tarirakanapo.” Aíyaka Yasumo kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kurikuriraka faraka aporoaki Yasumo someraka, “Makata kepo suane nōmo Atamo anoaki tarisiapo. Arirakano nōmo hemakapusuane soko, nōmo ainane soko, nōmo Atamo ipi hákasamo aseraka hemakapurapo. Arirakano nōmo Atamo hemakapusuane soko epo ainane soko, nōmo nī hákasamo aseraka hemakapurapo. Hemakapukua nōmo nī aporo hinamo hemakapusuaki Atamo ainane soko, hemakapurane soko tarirakano, aporo hinamoamo aseraka hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Repo makata rakikia hisiraka yoferaka, makata umisa kára maka pukua hisiraka, wakapu faraka yoferakano, ano area fenekea kakako peanie. Perakano né koteaka auamaka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Arirakano saro ponomakau tetámo makata hakása rakipe pusimo kesoa ira motokoa taponapo. Ira motokoa tapoana ayiáka repo anoaki someraka, ‘Nómo irane ano kinua motokoa taporasie,’ aihoanie. Arirakano nōmo makata atarirane repo enomakanie. Ano auaraka keneamo reasasamo nōmo ainane repo enomakanie. Enomarakano repo hoane yofenafaraka wakapuaka rekeakosapo. Yasumo someamo kepoane oyapo. Ferese aporomo somemaneane umisapo. Asiāne Yasumo somemaneane ofosapo. ");
INSERT INTO faa_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Asiamo anoyaki makata rakipe pusimo ne kinua nōmo irane motokoa taponane siasapo. Makata rakira umisane nōmo maofonapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Fenena maiya hakása metamo witi hemoa Yasu soko, ipi aporo hakāsa pura soko pusuapo. Puraka aporo hakāsa purane meamorakano, witi hae sūsane tukua nesapo. ");
INSERT INTO faa_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nenakano Ferese aporomo aseraka, Yasuaki someraka, “Nómo aporo hakāsa puramo makata arakirane asesie. Ipu makata rakiraka, fenena maiya yaposane mamosoane.” ");
INSERT INTO faa_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Airakano Yasumo someraka, “Wate fana Tefete soko epo ipi aporo hakāsa pura soko kára meamorakano, Tefeteane Kotimo apea yorokoa Kotipoko farawa taesane maka nesapo. Arirakano Kotipoko farawa taesane Tefetemo soko, ipi aporo hakāsa puramo soko nakohoamo yaposapo. Asiamo pirisiti aporomo namina hákasamo nenane yaposafapo. Asiane Tefete ipi pirisiti aporohoanafonosa yiamo farawa yaposane nesapo. Aíyaka Kotimo sawia popahoareapo. Popasane repo menoraka kepo hemakapurakarire? Wae, repo hemakapurakarifapo. ");
INSERT INTO faa_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Arirakano fenena maiyamo Kotimo apea pirisiti aporomo Kotiaki makata kakayia rukua paikia kaka, ayiáka ipu makata rakirapo. Ayiáka rakirakano, Kotimo iane hukururafapo. Aíyaka Kotimo sawia somemane popasane repo menoraka kepo hemakapurakarifapo. ");
INSERT INTO faa_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Hao, kaisie. Repo hemakapuraka, ‘Kotimo apeane fanareapo.’ Aíyaka hemakapusua nine, Kotimo apeane kesekeraka rekenapo. Ano wo areane fanaraka rekenapo. ");
INSERT INTO faa_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Asiamo nōmo aporo hakāsa puramo watikiaka rakianafonosa nine, repo iane hukurusuapo. Asiamo Kotimo sawia popasane oyapo. Kotimo someraka, ‘Nōmo somemane maresane repo kaumo kekemaraka, anoaki makata yaku karakano nōmo seserakanafapo. Asiamo aporo hinamo metakirane repo kamenakaraka ararehoasimoripo.’ Aíyaka Kotimo somerakano popasane kepoane repo hemakapurakarifapo. Repo hemakapusua satiki ane repo nōmo aporo hakāsa purane hukurufunufareapo. ");
INSERT INTO faa_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Aporomanomo Tákeane anopo. Yape fenena maiyamo makata ayiakanie aíyaka marerane, nōmo unihaeaka asekea rekenapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yasumo someaka faraka, Yasu pukua Yu aporomo sarimana apea yorokoa aseane ");
INSERT INTO faa_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","aporo hokono narisa rekeno asesapo. Yasumo hasaka somerakarihoamo hukurukusakipoko, Ferese aporomo someraka, “Fenena maiya amo aporo hinamo makata tasane, aporo metamo mafarakanone, aporoamo Kotimo somemane mamosorakanare?” ");
INSERT INTO faa_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Airakano iaki Yasumo someraka, “Fenena maiya amo repo namina aporo metamo saro sipi hauaka kutua huruperakano, saro sipiane nómo ketaka maka máfahokosare? Ao, máfahokosapo. ");
INSERT INTO faa_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Asiamo saro sipiane aporomo hakása wakasemaraka hemakapurapo. Anakano aporo hinamoane Kotimo namo kakaro kára hemakapukua ararenapo. Asiamo fenena maiyamo aporo hinamo arareana amo, Kotimo somemaneane mamosorakanafapo.” ");
INSERT INTO faa_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Aíyaka Yasumo Ferese aporoaki someaka faraka, aporo hokono narisaki someraka, “Ne hokono raerasie.” Airakano epo hokonoane raesapo. Raeraka hokono taku meta koteaka area ayiáka, hokono narisane soko faraka koteaka reapo. ");
INSERT INTO faa_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Koteaka rekeno asekea Ferese aporoane pukua namina susu someaka marakā, “Yasuane kukusimo isiapo rukusapo. Asiamo mayiáka runarakapo.” Aíyaka Ferese aporomo someaka masapo. ");
INSERT INTO faa_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ferese aporomo hemakapusuane Yasumo aseraka, taoneane metakarikia pusuapo. Puraka aporo hinamo yakai eyaki hakāsa pusuapo. Pukua aporo hinamo makata tasa suane Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Mafaraka iaki someraka, “Anoane aporo hinamo suaki somehokopo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Aisane aihoasiraka Kotimo some kará porofete aporo Aesayamo Kotimo sawia Yasuane popasapo. Popasane oyapo. Kotimo eane someraka, ");
INSERT INTO faa_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nōmo aporo raipane epo. Eane nōmo murikimasapo. Murikimaka nōmo eaki himu tumurumo kára hemakapukua seserakanapo. Eaki nōmo Ho Kotesa mareakosapo. Marerakano, nōmo ereketae maroponane Yu aporo hinamohoanafonosaki epo somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Epo tafatafahokosafapo. Epo kára me rukusafapo. Ikia kara á aporo hinamo suamo kaiyisimo, epo sapekeamo wáhokosafapo. ");
INSERT INTO faa_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Fofako kokomesa hakása soko, epo pateketaehokosafapo. Nafa pakimaka kokoraka kopakapuko makerakano, epo kopakataehokosafapo. Aporo hinamo suane epo arareraka rakipe pukua, ayiáka ereketae maroponane epo makama fanahokosapo. ");
INSERT INTO faa_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Makama fanahokosasamo eaki Yu aporohoanafonosamo hemakapukusapo. Hemakapukua Kotimo ayiakakosaposane aseakosakipoko, kau risikinapo.” Aíyaka Kotimo somerakano Aesayamo popasapo. ");
INSERT INTO faa_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Maiya amo aporo meta yatafumo ho maraka, hi fauraka, mé fasane aporo metakiramo Yasu rea karikia pesapo. Karikia pesane Yasumo aporoane mafarakano, ipi mé fasane faraka koteaka someaka, anakano ipi hi fausane soko faraka koteaka asekea ásiapo. ");
INSERT INTO faa_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Anakano aporo hinamo suamo asekea fofaraka someraka, “Mafana aporoane Tefetemo aporo ira wainepe pesa aporo meta fasere peakosaporakasuane, érakanareapo.” ");
INSERT INTO faa_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Aíyaka somesane Ferese aporomo kairaka someraka, “Yatafumo unihae yano motosa Piaósipu e Yasuyaki rekenapo. Reasasamo Piaósipumo wakapuamo yatafu pusierakano apure.” ");
INSERT INTO faa_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aíyaka somerakano ipu hemakapusuane Yasumo aseraka takumeaka someraka, “Aporo namina hauaka hakása risia yiamo parakuraka weraka, aporoane koaka tarikia, kekepo kekeporaka risike, hauakane kauanehokosapo. Arirakano aporo ape sumu hakása namina parakuraka weraka arupukusapo. Arirakano aporo ira hakása namina soko parakuraka weraka arupukusapo. ");
INSERT INTO faa_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Aina ayiáka Satanemo yatafuaki pusie satiki, ane ipi táke tati awera ayiáka weafunupo. Satanemo ipi aporo tákeyaki parakuraka wera satiki i arupufunupo. ");
INSERT INTO faa_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Asiamo repo someraka, ‘Piaósipu anoyaki reasasamo epo wakapumo yatafuaki pusierakano pusuapo,’ aíyaka repo somerakanapo. Arirakano repo namina aporo metakiramo yatafuaki pusiehokosakipoko, epa iyaki paoraka reare? Epamo wakapumo yatafuaki pusiesare? Repo someraka, ‘Piaósipumo wakapumo ásiapo.’ Aíyaka repo some paripeakosafapo. ‘Kotimo wakapumo ásiapo.’ Aíyaka repo somehokosapo. Asiamo nōmo rakisimo wakapuamo kepoane hemakapukusakipoko, repo namina aporoamo ainane hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Arirakano yatafu pusiehoasimo Kotimo Ho Kotesa anoyaki reasasamo, epo wakapumo pusierapo. Yatafu purakano asekea, repo úyaka hemakapunie. ‘Kotimo unihaeaka asekea rekeakosa maiyane faserepesapo.’ Aíyaka hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Arirakano aporo metamo aporo waremo makata kemoane hakimokoariraka, fana aporo wareane sakomo taporaka motokoa marekea, epo apea yorokoa makata hakimorapo. Aporo wareane tapohoasiraka, e yaiya wareraka rekeno asekea, epo apea hakimokoako yororafapo. ");
INSERT INTO faa_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Arirakano ano patera asekeanafonoraka risia aporo hinamoamo, anoaki yunuraka rekenapo. Arirakano anoa paosa aporo hinamo repo, aporo hinamo metakira pasimokoanafonorakanone, aporo hinamoane repo mapakataerakanapo. ");
INSERT INTO faa_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Asiamo nōmo reaki kakaro somerakaripo. Aporo hinamomo watikiaka rakirane soko, aporo hinamo meta mawakasemaraka somerane soko, Kotimo mafahoasireapo. Arirakano Ho Kotesane aporo hinamo metamo mawakasemarakano, Kotimo mafahokosafapo. ");
INSERT INTO faa_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Arirakano Aporomanomo Tákeane anopo. Anoaki aporo hinamo metamo himeteraka mawakasemaraka somerakano, Kotimo eane mafahoasireapo. Arirakano Ho Kotesamo wakapuane metamo aseraka someraka, ‘Ane Satanemo wakapupo.’ Aíyaka Ho Kotesane mawakasemarakano, aporo hinamo ane, yumo hauaka wo areamo soko, keseke maturikia taena maiya amo soko, Kotimo mafahokosafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yasumo someraka, “Ira kotesamo ira wate kotesa perapo. Arirakano ira watikisamo ira wate watikisa perapo. Ira wate aseraka ira namoane hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Asiamo re heseke ayireapo. Re watikiaka risike repo mayiáka koteaka somehokosare? Aporo hinamomo himua makesane akai aeyaka tonoherapo. ");
INSERT INTO faa_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mahimura makatane himumo hemakapurapo. Aporo kotesamo himumo koteaka hemakapuraka akaimo kekemaraka koteaka somerapo. Aporo watikisamo himumo watikiaka hemakapuraka, akaimo kekemaraka watikiaka somerapo. ");
INSERT INTO faa_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Asiamo hukurukua takekea parakuna maiya amo, aporo hinamomo nenakamaka somesa akipoko Kotimo aporo hinamoaki kaiyakosapo. Kaikia iane parakuhokosapo. ");
INSERT INTO faa_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Parakuanamo aporo hinamo metakiramo ipi some ana yiamo, eaki fanasina hauaka á pusiehokosapo. Arirakano aporo hinamo metakiramo soko ipi akaimo some ana yiamo, hepene yapura hisiehokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kotimo somemane tisa aporomo soko, Ferese aporomo soko, Yasuaki someraka, “Tisao, ne Koti aeyaka pesarihoamo isiapo hemakapukusakipoko, Kotimo wakapumo hemakapukua rakirane nómo rakinie. Rakirakano isiapo aseakoripo.” ");
INSERT INTO faa_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Airakano Yasumo someraka, “Maiya omo aporo hinamo watikiaka risike Kotiaki himu hakásaraka hemakapurafaraka metaki mokome hemakapuraka someraka, ‘Isiapo aseako Kotimo wakapumo hemakapukua rakirane nómo rakikitakae.’ Airakano repo someane nōmo kakimaka rakiakosafapo. Yonaki makata tarisiane hákasa reaki tariakosapo. ");
INSERT INTO faa_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Asiamo Kotimo some kará porofete aporo Yona pokoa kára tūa, sere isiamo soko, ere isiamo soko, kayapo. Yona pokoa tua kaya ayiáka Aporomanomo Táke anoane hauaka atura sere isiamo soko, ere isiamo soko, ayiáka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Arirakano Yonamo Kotimo someane some karakano, Ninefa aporo hinamomo namina watikisane metakarikia risikiako parisapo. Asiakipoko Kotimo hukuarura maiyamo, Ninefa aporo hinamoamo, aporo hinamo maiya omo watikiaka risiasamo ipu watikisane tarikia somehokosapo. Asiamo repo makata watikisane metakarianafonosakipoko, ipu reane hukurukusapo. Arirakano Yona makama kesekesane anopo. Ano pekea some karakano, maiya omo aporo hinamomo makata watikisane metakarirakarifapo. ");
INSERT INTO faa_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Arirakano Soromonemo koteaka hemakapukua somesane kaiyako, ketayia takua hauaka yameno aeyaka hinamo kuini ane pesapo. Asiakipoko Kotimo hukuarura maiya amo, aporo hinamo maiya omo risiamo nōmo someane kakimakanafonosa aki, hinamo kuiniamo iane hukurukusapo. Arirakano Soromone makama kesekesane anopo. Ano maiya yumo aporo hinamoyaki hakāsa reke, Kotimo someane some kayane repo kairakarifapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Yasumo someraka, “Yatafumo aporo ho masane metakarikia pukua hauaka porasakipoko á koraka rerapo. Koraka reke e ape wakakosa soko, e fenekea kakakosa soko, koane fasekeno ");
INSERT INTO faa_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ipi hemakapuraka, ‘Aporo tūra ape ayiáka waka reane metakarikia pusuasamo, á rekeako paripurakapo.’ Aíyaka paripekea aseane aporo tūra ape ayiáka feaosa kakamasa makata su kotesekeno aserapo. ");
INSERT INTO faa_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Asekea ipi yatafu táke yatipinusu pasimorapo. Yatafu yatipinusu pasimosa amo, yatafu fana reamo watikisane marokeraka, ipu namo kakaro kára watikiaka rakirapo. Iane pasimokoa pekea, aporoamo tūra apea ayorora ayiáka yorokoa risirapo. Risikirakano aporoane namo kakaro watikiaka rerapo. Fana yatafu hakása rea maiya amo, aporoamo watikisane wakasemanapo. Arirakano kari suane pekea risikirakano, aporoamo watikisane káranapo. Aina ayiáka maiya omo aporo hinamo risiamo watikiaka rakirakano iaki ayiakakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yasumo aporo suaki some karaka rea maiya amo, ipi kaīyia soko, ipi mamanea soko pesapo. Pekea hauaka moroa risike ipu someraka, “Isiapo Yasuaki makata somehokoripo.” ");
INSERT INTO faa_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Aíyaka somerakano aporo metamo kaikia Yasu ape kakarua reakipoko someraka, “Nómo ní amamo soko, ní maemo soko, neaki makata somehoko pekea, hauaka moro atura arisie.” ");
INSERT INTO faa_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Airakano Yasumo eaki someraka, “Nōmo ama epare? Nōmo mae epare?” ");
INSERT INTO faa_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Aíyaka Yasu ipia paosa aporo hinamo sarimasaki hokonomo tariraka someraka, “Nōmo ama soko, nōmo mae soko, re atoa ayapo. ");
INSERT INTO faa_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Asiamo aporo hinamomo nōmo Ata hepene yapura reamo hemakapusuane kekemaraka rakirakano aporo hinamoane nōmo mae, nōmo papā, nōmo ama ayapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sere amo Yasu apeane metakarikia pukua he fua kayapo. ");
INSERT INTO faa_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kayakipoko, aporo hinamo yakai sarimaraka hauaka taperakano, Yasu takahikia pukua kasua kake, aporo he fua risiaki makata somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Some yakai takumeaka epo somesapo. Epo someraka, “Aporomo makata mano poterape pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Poterape pusua maiya amo, makata mano metakira ikia kara hurupepesapo. Hurupepesane menamo nesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Arirakano makata mano metakira eke kima hauaka wakasemasakipoko hurupepesane, foaka tanehekea pikinu koteaka pusuafapo. ");
INSERT INTO faa_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pikinu koteaka punafonoraka, maíyamo ruraka sisipuraka yoferaka kukua kesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Arirakano makata mano metakira, makata mano keta risia arakarua hurupepesapo. Hurupepesane makata mano keta risia akiyaki hakāsa tanehesapo. Tanehenaka makata keta risiane popakeraka makata manoane karotapiraka serekesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Arirakano makata mano metakira hauaka kotesakipoko hurupepesane tanehekea wate pesapo. Wate peraka, metakira wate wane harote su (100) pekea, metakira wate sekeseti su (60) pekea, metakira wate teti su (30) pekea, ayiáka pesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Re senaki risiamo kairaka koteaka kaisie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Aporo hakāsa pura pekea Yasuaki kairaka, “Marirakano nómo aporo suaki takume susu somerakanare?” ");
INSERT INTO faa_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Airakano Yasumo someraka, “Repo kaiyisimo Koti unihaeaka rea mahamesane some kepoane yumo reaki hufitaeaka somerakanapo. Arirakano aporo suaki some kepoane hufitaeaka somerakanafapo. ");
INSERT INTO faa_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Koti unihaeaka reane some kepoane repo hemakapurakanapo. Hemakapurakano reaki makata meta soko tariakosapo. Tarirakano repo hemakapusuane karahokosapo. Arirakano aporomo kepo hemakapunafonoraka, fana kaisiane soko meraruhokosapo. ");
INSERT INTO faa_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ipu himo aseraka asekea, kepoane koteaka hemakapurafapo. Ipu senakimo kairaka kaikia, himumo koteaka hemakapurafapo. Asiamo iaki takume susu somerakanapo. ");
INSERT INTO faa_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ipu hemakapunafonoraka kakipayasane kakipayahoasiraka wate fana Kotimo some kará porofete aporo Aesayamo someraka, ‘Ipu kairaka kaiyakosapo. Kaisia nine kepoane hemakapukusafapo. Ipu aseraka aseakosapo. Asesa nine kepoane koteaka hemakapukusafapo. ");
INSERT INTO faa_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Asiamo aporo hinamo suane himu mahimeteraka risikinapo. Ipu himo aserapaka hikumisiapo. Ipu senakimo kairane kaiyako hisiraka senaki tisapo. Ipu himumo hemakapuko hisiraka koteaka hemakapurakanafapo. Ipu himu watikisane nōmo mafahoasimo i anoaki risikiako parirakanafapo.’ Aíyaka Aesayamo somesane faserepesa ayareapo. ");
INSERT INTO faa_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Arirakano repo himo aseraka asekea hemakapurakanapo. Repo senakimo kairaka kaikia hemakapurakanapo. Asiasamo seseraka risikianie. ");
INSERT INTO faa_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nōmo reaki kakaro somerakaripo. Repo makata asesane Kotimo some kará porofete aporo yakaimo soko, Koti hemakapura aporo ereketaeraka risiamo soko, ipu aseakoripo aisa nine, ipu asesafapo. Repo makata kaisiane ipu kaiyakoripo aisa nine, ipu kaisiafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Yasumo someraka, “Repo hemakapusimo makata mano potesa takume kepoane oyapo. ");
INSERT INTO faa_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Makata mano ikia kara hurupepesa asíane oyapo. Aporo hinamoane Kotimo unihaeaka asekea rekenapo, aisane aporomo kaikia kepoane koteaka hemakapunafonorakano, some kaisiane Satanemo foaka hakimarapo. ");
INSERT INTO faa_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Arirakano makata mano eke kima hurupepesa pikinu ");
INSERT INTO faa_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","koteaka punafonona asiane oyapo. Aporo hinamomo Kotimo someane wate foaka kaikia seserakao ayiáka, namo kakaro kakimarafapo. Kakimakanafonoraka maiya wakasemamo kakimaka risiakipoko, keseke makata watikisa fasereperakano soko metao, aporo metakiramo Kotimo some kakimasa aporo hinamoaki mokoatikirakano soko metao, arirakano asekea Kotimo some kaisiane foaka metakarirapo. ");
INSERT INTO faa_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Arirakano makata mano keta risiakipoko arakarua makata mano hurupepesa, wate koteaka peanafonosa asíane oyapo. Aporo hinamomo Kotimo someane kairaka yia, hauaka wo makata tomekesa hemakapuramo soko, makata kemo kára mokoa seseraka hemakapuramo soko, tetá amo Kotimo someane karotapirapo. ");
INSERT INTO faa_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Arirakano makata mano hauaka kotesakipoko hurupepesa wate sakepamo pesa asíane oyapo. Aporo hinamomo Kotimo someane kakimaka namo kakaro himu hakásaraka hemakapukua risikino, ira wate wane harote su (100) apera ayiáka risirapo. Arirakano metakira sekeseti su (60), arirakano metakira teti su (30) ayiáka apera ayiáka, aporo hinamoane ayiáka risirapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yasumo aporo hinamo suaki takumeaka someraka, “Kotimo unihaeaka asekea rea asíane oyapo. Aporomo koane mano kotesa hemoa potesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Poteraka marekea ereamo aporo su wasakipoko yunu aporo peraka koane potesakipoko kerewa hae poteraka marekea pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pusuakipoko makata mano potesane tanehekea wate apera maiya amo aseane, kerewa soko koaneyaki hakāsa tanehekea wate perakano asesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Aseraka aporo raipamo pekea hemo wafayaki someraka, ‘Unihaeo, nómo hemoa koane mano hákasa potesare? Koane mano hákasa potesakipoko mayiáka kerewane hakāsa tanehesare?’ ");
INSERT INTO faa_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Airakano hemo wafayamo someraka, ‘Yunu aporomo tau pekea kerewa hae ane, koane hemoa potehoareapo.’ Airakano aporo raipamo hemo wafayaki kairaka, ‘Kerewane fikia mokoatehoare? Kerewane mayiakaere?’ ");
INSERT INTO faa_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Airakano hemo wafayamo someraka, ‘Wae, repo kerewane fikia mokoateraka, koane ane hasaka rakare mokoatenapaka kerewane fiakopo. ");
INSERT INTO faa_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Hakāsa su yaiya risikiasimo metakarinie. Keseke namosekeno nako tuamora maiya amo, aporo raipaki nōmo someraka, “Kerewane fana popateraka faturaka ira paiyako taeraka marekea, koane namoane tukua apea taerasie,” ’ aihokosapo.” Aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Aporo hinamo suaki Yasumo takume meta someraka, “Aporo hinamo Kotimo unihaeaka asekea reane, ira maseta hae aporo metamo ipi hemoa maposa asíapo. ");
INSERT INTO faa_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Maseta hae kakaro wakasema yiamo, pauaka henaka hemoa makata porosane marokeraka ira pariraka káranapo. Káraraka reakipoko ira eya mena koraka torane pekea, menamo ape kirapo. Aina ayiáka aporo hinamo Kotimo unihaeaka asekea reane asíapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yasumo takume meta someraka, “Aporo hinamo Kotimo unihaeaka asekea reane, farawa pirira asíapo. Hinamomo farawa paiyakosakipoko farawa tarámo hakása maka makata pirirayaki sarimaraka kekero kekerorakano, makata piriramo farawane hemakapukua pirirapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yasumo somesa maiya amo aporo hinamo yakai sarimasaki Yasumo takumeaka someraka, kakaro hufitaeraka somesafapo. Takumeaka susu somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Somehoasiraka wate fana Kotimo some kará porofete aporomo Yasuane somesane oyapo. Unihaemo ipi someraka, “Aporo suaki nōmo takumeaka somehokosapo. Hauaka kepomaresa maiya amo makata mahamesane, yumo some kepo su kakaro feakataeraka somerakanapo,” Aisane faserepesa ayareapo. ");
INSERT INTO faa_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aporo hinamo yakai sarimasane, Yasumo metakarikia pukua apea yorosapo. Yororakano aporo hakāsa pura pekea Yasuaki someraka, “Hemoa kerewa soko, koaneyaki hakāsa tanehesa takume someamo kepoane isuaki hufitaeraka somesie.” ");
INSERT INTO faa_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Airakano Yasumo someraka, “Koane mano kotesa hemoa potena aporoane anopo. Aporomanomo Tákeane anopo. ");
INSERT INTO faa_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Asiamo hemo asíane hauaka kára oyapo. Koane mano kotesa asíane Koti unihaea paosa aporo hinamopo. Kerewa hae asíane Satanea paosa aporo hinamopo. ");
INSERT INTO faa_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yunu aporomo kerewa hae potesa asíane Satanepo. Wate namosekeno tuamora ayiáka, hauaka one fa ana sere amo ayiakakosa ayapo. Aporo raipamo kerewane popateraka, koane namoane tukua apea taehokosa aporoane hepene aporopo. ");
INSERT INTO faa_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Kerewa faturaka iramo apaira ayiáka, keseke hauaka one fa ana maiya amo ayiáka paiyakosapo. ");
INSERT INTO faa_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Aporomanomo Tákeane anopo. Nōmo hepene aporo pusierakano peraka, aporomo watikiaka rakisimo kirimana aporoane soko, watikiaka rakira aporoane soko, su mokoa iramo inakasimo ira á mokoasuhokosapo. ");
INSERT INTO faa_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mokoasusa á i fanasiraka risike hihiripuraka akai kirisiraka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Maiya amo sere maiya sesakereraka faeana ayiáka ereketaeraka risia aporo hinamoane Ata unihaeaka reamo hauaka á ayiáka faehokosapo. Re senaki risiamo kairaka koteaka kaisie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yasumo takume meta someraka, “Kotimo aporo unihaeaka asekea reane, makata namo kakaro kotesa mahimuna makatane maua kekea, hemoa kokomaresa asíapo. Aporo meraruamo peane, makata namo kakaro mahimuna makatane asekea, himu faraka epo yia mokosekesapo. Mokosekeraka marekea pukua, kára seseraka ipi makata kemo su mokoa aporo metaki roporaka mone mosapo. Mone mokoa moneamo hemoane roposapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Arirakano Yasumo takume meta soko someraka, “Kotimo unihaeaka asekea reane, pisinisi aporomo sekete kotesa ropohoko kope pura asiapo. ");
INSERT INTO faa_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pisinisi aporoamo sekete kope pukua sekete namo kakaro kotesa aseraka ropohoko, ipi makata kemo su mokoa aporo metaki roporaka mone mosapo. Mone mokoa moneamo seketeane roposapo.” Aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Yasumo takume meta someraka, “Kotimo unihaeaka asekea reane kasipu pokoa mora asíapo. Pokoa mokoakosakipoko kasipu hea kokomaresapo. Kokomaresa á pokoa kekepo kekepo suane kesekeno mosapo. ");
INSERT INTO faa_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mosane komarusekeno aporomo kasipuane maka, he fea motokoa marekea toke, pokoane parakusapo. Parakuraka pokoa kotesane mokoa kasu tisia taeraka, pokoa watikisa nanafononane mokoatesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Asia ayiáka keseke hauaka one fa ana maiya amo ayiakakosapo. Aporo kotesayaki watikisayaki suasuaraka risiane hepene aporomo parakuhokosapo. Aporo hinamo watikisane parakuraka mokoa, iramo inakasimo mokoasuhokosapo. ");
INSERT INTO faa_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Mokoasusane fanasina hauaka á risike hihiripuraka akai kirisiraka risikiakosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Asiamo Yasumo ipi aporo hakāsa puraki someraka, “Nōmo reaki somesane su hemakapurakarire?” Airakano ipu “Ao, hemakapurakaripo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Airakano Yasumo some meta someraka, “Nōmo Koti unihaeaka asekea reane somerakano, Kotimo somemane tisa aporomo kakimaka anoa paosa aporoane ape wafaya asíapo. Asiamo ape wafayamo makata kemo kotesa taesane mokoa, kawe taesane soko, fana taesane soko, mokoa aporoaki karápo. Akara ayiáka Kotimo somemane tisa aporomo kakaro some kawe kaisiane soko, fana kaisiane soko some karápo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yasumo aíyaka takumeaka someaka faraka Kapaneame taoneane metakarikia, ");
INSERT INTO faa_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nasare apea ipi pusuapo. Pukua á reke Yu aporomo sarimana apea makata some karakano, aporo hinamomo kairaka fofasapo. Fofaraka ipu someraka, “Kotimo hemakapura some kotesane epo ma kaisiarakapo. Epo Kotimo wakapumo hemakapukua arakirane ma enomasarakapo. ");
INSERT INTO faa_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Aporoane ipi kapenetamo hokosapo. Ipi kaīyiane Mariapo. Arirakano ipi mamaneane Yamese soko, Yosefe soko, Saemone soko, Yutase soko ipo. ");
INSERT INTO faa_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ipi ifia isuyaki hakāsa tokenapo. Ipu taka ayiáka rakirakarifapo. Epo hákasa wakapuaka arakirane ma enomasarakapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aíyaka ipu Yasuaki himu hakásaraka hemakapunafonoraka fasikia risiapo. Fasikia risikino Yasumo iaki someraka, “Kotimo some kará porofete aporomo ipi ape sumu aporo hakāsa risia amo soko, ipi ape wará aporo hakāsa risia amo soko, eane makama fanaraka hemakapurafapo. Hemakapunafonorakano yia, ape sumu meta á aporo hinamo metakiramo Kotimo some kará porofete aporoane makama fanaraka hemakapurapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Someraka ipi apea aporo hinamomo eaki himu hakásaraka hemakapunafonosasamo Yasumo Kotimo wakapumo hemakapukua rakirane kára rakisiafapo. ");
INSERT INTO faa_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Yasu ipi Kariri hauaka á some karaka rea maiya amo, Kariri hauaka asekea rea aporoane Herotepo. ");
INSERT INTO faa_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Arirakano Yasumo wakapuaka rakiraporakano, Herotemo kairaka, ipi aporo raipaki someraka, “Aporo wakapuaka rakirane Yone he tapukumarera ayarakanareapo. E rusua kusuane maturikia taerakanareapo. Maturikia taesasamo wakapuaka arakirane Yonemo wakapuaka rakirakanareapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Herote Kariri hauaka asekea rea aporomo ipi mamanea Firipipo. Firipimo asea Herótiaseane Herotemo hakimaraka rekeno asekea, Yonemo Heroteaki hukurukua someraka, “Hinamoane nómo hakimaraka areane somemane motosane mamosoane.” Airakano Herotemo Yoneane tipura makeako aporo terakaiyamosaki someraka, “Yoneane waseremasie.” Airakano aporo terakaiyamosamo Yoneane waseremaka hokonoa taporaka tipura makesapo. ");
INSERT INTO faa_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tipura makekea, Yone kukusimo rukusapoko asiane, Yu aporo metakiramo someraka, “Yoneane Kotimo some kará porofete apororeapo.” Airakano kaikia Herotemo hemakapuraka, “Nōmo Yone rusua kurakanone, aporo yakaimo anoaki sapehoasireapo.” Aíyaka hemakapuraka aporomo eaki sapenapaka namoraka reke, Yone rukusapoko asiāne, metakarisiapo. ");
INSERT INTO faa_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Metakarikia Heroteane ipi takapesa serea paurakano hemakapuko hokono keraka, aporo suamo asekeasimo Herótiasemo ipi faraya hinamo sakoramo taneseraka kesasapo. ");
INSERT INTO faa_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Taneseraka kesarakano asekea, Herotemo seseraka hinamo sakoraki someraka, “Nómo makata makasierakano, nōmo neaki makakosapo. Nōmo kakaro somehoanafonorakano soko Kotimo aseakosapo.” Aíyaka aumaraka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Somerakano Herótiasemo ipi farayaki hokokaka someraka, “Yone he tapukumarerane wamo patekemaka, merakia motokoa, anoaki makasiehoanie. E kakaro rusua kusuane aseako ipi wamoane makasiehoanie.” Airakano someane ipi farayamo kakimaka Heroteaki yaiya somesapo. ");
INSERT INTO faa_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Somerakano unihae Herotemo kaikia mahisiraka reapo. Mahisiraka reke epo hemakapuraka, nōmo makakosapo aíyaka aumaraka somesane, aporo hokono akera sarimasa suamo kaisiasamo, wamo patekemakaniesane metakariane, kaíyanapaka epo somesane metakarisiafapo. ");
INSERT INTO faa_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Metakarirafaraka aporo terakaiyamosamo Yone wamo pateketaehoasimo tipura apea pusiesapo. ");
INSERT INTO faa_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Airakano tipura apea pukua Yone wamo pateketaeraka merakia motokoa maka pekea hinamo sakoraki kasapo. Karakano maka ipi kaīyia Herótiaseaki kasapo. ");
INSERT INTO faa_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Arirakano Yonemo ipi aporo hakāsa pura peraka Yone oto susuane maka pukua hauaka marekea Yasuaki Yone rusua kusuane somehoko pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yone he tapukumarerane rusua kusuaporakano Yasumo kairaka, Yasu kasua ripaka pukua, ima yaoa aporo fasakipoko ipi haku fore rekeako pusuapo. Pusuaporakano kairaka aporo hinamo yakai ipu namina apeane metakarikia, Yasu kekemarape he fe ikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pukua sarimasakipoko Yasu pekea kasu karimarekea aseane aporo hinamo su sarimasekeno asesapo. Aseraka iane kamenakasapo. Kamenakaraka hemakapukua, aporo hinamo makata tasane epo mafasapo. ");
INSERT INTO faa_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mafaraka reke samapu maiya tuakeramo Yasuaki ipi aporo hakāsa puramo someraka, “Hauaka wo ima yaosakipoko aporo hinamo risikinafapo. Maiya tukesasamo aporo hinamo sarimasaki ipu namina makata nakosa ropohoko apea poparipusiesie.” ");
INSERT INTO faa_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Airakano Yasumo someraka, “I pusierakane marirakanore? Repo namina iaki makata nakosa kakanie.” ");
INSERT INTO faa_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Airakano aporo hakāsa puramo someraka, “Makata nakosa farawa kakoreasu, pokoa tetá ayiáka tokenapo. Makata meta kakenafapo.” ");
INSERT INTO faa_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Airakano Yasumo someraka, “Makata nakosane anoaki makasie.” ");
INSERT INTO faa_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Aíyaka aporo hinamo suaki Yasumo someraka, “Re su asanea toae.” Aíyaka i toakipoko farawa kakoreasu pokoa tetá mokoa reke, hepene yapura asekea, Kotiaki suseraka kurikuriraka faraka, farawa mosoraka aporo hakāsa puraki karakano, aporo hakāsa puramo aporo hinamo suaki kasapo. ");
INSERT INTO faa_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Karakano aporo hinamo suamo siaraka nesapo. Nekea faraka farawa soko pokoa soko momo yia tokeno, aporo hakāsa puramo mate kenosua kekea komarusuapo. ");
INSERT INTO faa_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Aporo makata nesa susuane menoraka fae taosenepo (5,000). Hinamo soko hokosa soko i suane menosafapo. I menohoanafonosamo soko, ipu suamo nesapo. ");
INSERT INTO faa_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Aporo hinamo suamo makata nekea farakano, Yasumo ipi aporo hakāsa puraki someraka, “Re fana kasua ripaka he fe taku ra hisie. Arirakano aporo hinamo sarimasane ipu namina apea poparipusie, aihoko ano fore o rekenapo.” Airakano i kasua ripaka hisiapo. ");
INSERT INTO faa_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Hisiakipoko aporo hinamo su sarimasane soko namina apea poparipusuapo. Poparipusuakipoko Yasu ipi haku ūria kurikurihoko hisiapo. Hikia ereamo Yasu ipi haku kurikuriraka reapo. ");
INSERT INTO faa_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kurikuriraka reakipoko aporo hakāsa pura kasua ripaka he numua puane, he kupamo kasu unia ruraka he kupa atifoyaki kára peraka kasu maka paripurakanoraka kasu roane pusuafapo. ");
INSERT INTO faa_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kasu roraka risike, yao fia makehoramo Yasu ane kasu tapukurea makeraka he kima finirape pesapo. ");
INSERT INTO faa_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Perakano aporo hakāsa puramo asekea namo kakaro himu faraka toke kokoaeraka wáraka, “Yakasa ho apere.” ");
INSERT INTO faa_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Aíyaka namoraka wárakano iaki Yasumo wate foaka someraka, “Anopo. Re namohokopo. Namoraka himu haruhokopo. Paroaka risikianie.” ");
INSERT INTO faa_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Airakano Pitamo someraka, “Unihaeo, nere? Nesekeno nómo anoaki he kima finirape peaesie.” ");
INSERT INTO faa_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Airakano Yasumo someraka, “Ne peae.” Aíyaka somerakano Pitamo kasu metakarikia, Yasu rea he kima finirape puraka ");
INSERT INTO faa_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","kaiyiáne, atifomo e kaua rurakarakano kaisiapo. Kairaka namoraka e hea keneperakarakano wáraka, “Unihaeo, ano masie.” ");
INSERT INTO faa_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Airakano wate foaka Yasumo hokonomo Pita maka someraka, “Nómo anoaki himumo hakasa wakasemaraka hemakapureapo. Nómo hemakapuraka, ‘Sia puraka soko metao, hea keneperaka soko metao ayakanarakapo.’ Aíyaka marirakano himu tetáraka hemakapurakanare?” ");
INSERT INTO faa_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Aíyaka tetā kasua parohoane atifo fasapo. ");
INSERT INTO faa_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Farakano asekea aporo kasua toamo Yasuaki kekereraka someraka, “Né kakaro Kotimo hokosapo.” Aíyaka kekereraka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","He kekea kaya kasu rokoa teraporaka, Yasu soko, Yasumo ipi aporo hakāsa pura soko, kasu rokoa pukua, Kenésare hauaka á pausapo. ");
INSERT INTO faa_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Paurakano aporomo aseraka hemakapuraka, “Ane Yasureapo.” Aíyaka hemakapukua some mareraka, “Yasu pesane hauaka makea somehoko pusie.” Aíyaka some marerakano pukua somesapo. Somerakano kaikia aporo hinamo su makata tasane Yasumo mafahoasimo karikia pesapo. ");
INSERT INTO faa_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Karikia pesa aporoamo Yasuaki someraka, “Aporo hinamo makata tasamo nómo pasu ke huhua sakaihoane siahoasisekeno aosie.” Airakano Yasumo aosapo. Aoraka epo pasu huhuane aporo hinamo makata tasamo sakaihoane ipu makata tasane fasapo. ");
INSERT INTO faa_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ferese aporomo soko, somemane tisa aporomo soko, Yarusarame sitiane metakarikia Yasu rea pekea kairaka, ");
INSERT INTO faa_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Marirakano nómo aporo hakāsa puramo isiapo makasa kauamo ayakanie, aíyaka somepe pesane koaretaeraka risikinare? Koaretaeraka, ipu makata nakosakipoko hokono kusurakarifapo. Hokono kusunafaraka makata maka anene.” ");
INSERT INTO faa_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Airakano Yasumo iaki kairaka, “Marirakano repo makasa kaua kekemamo ayiakanie, aíyaka somepe pesane mafanahokosakipoko, repo Kotimo somemane koaretaeraka risikinare? ");
INSERT INTO faa_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kaisie. Kotimo somemane motosane oyapo. Kotimo someraka, ‘Ni Atape ama tetāne koteaka hemakapukua makotehoanie,’ aisapo. Kotimo somemane meta soko someraka, ‘Aporomanomo ipi atane soko metao, ipi amane soko metao, yakasa ho mareraka ekenerakano e kakaro kukusimo runie.’ Aíyaka Kotimo somesa nine ");
INSERT INTO faa_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","repo someraka, ‘Aporomo ipi ataki soko metao, ipi amaki soko metao, someraka, “Nōmo tetoaki makata yaku kakakosapoko asiāne, nōmo metakarikia Kotiaki karakanapo.” Aisa aporoamo ipi ata ama tetāne makotehoanie aíyaka Kotimo somemane motosane metakarikia koaretaenane siareapo.’ Aíyaka repo Kotimo somemane ane mawakasemarakanapo. ");
INSERT INTO faa_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Aíyaka repo namina makasa kaua kekemamo ayiakanie, aíyaka somepe pesane mafanahokosakipoko, Kotimo somemaneane repo some sesekeraka akaye. Some sesekeraka kake, repo atape ama tetāne asekea rekeakosane metakarirakanapo. ");
INSERT INTO faa_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Re himu tetáraka arisie. Wate fana Kotimo some kará porofete aporo Aesayamo reane kakaro somesapo. Somesane oyapo. ");
INSERT INTO faa_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kotimo someraka, ‘Aporoamo anoaki akaimo kekereraka yia himumo anoaki hemakapurakanafapo. ");
INSERT INTO faa_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Himumo anoaki hemakapunafonoraka, nena akai susuamo anoaki kekerenapo. Ipu namina aporomanomo hemakapusuane some karakanapo. Some karakayia nōmo somemaneane ipu some karakanafapo.’ Aíyaka Kotimo somerakano Aesayamo popasapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Aporo hinamo su sarimahoasimo Yasumo peaeaka perakano iaki someraka, “Kaisie. Kaikia hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aporomo soko, hinamomo soko ipi akaimo makata anenamo ipi yia mawatikinafapo. Arirakano akai aeyaka some watikisa tonoaheramo ipi yia mawatikinapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Keseke e rea ipi aporo hakāsa pura pekea eaki someraka, “Nómo some karakasuane, Ferese aporomo kaikia mahisisapakae. Nómo kaisiare?” ");
INSERT INTO faa_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Airakano Yasumo someraka, “Makata mano porosane nōmo Ata hepene yapura reamo poroanafonosane su fiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Asiamo aporo hi taku tetákara fausamo ikia kara atarira ayiáka, Ferese aporomo ayiáka tarirakanapo. Aporo hi taku tetákara fausamo aporo hi taku tetákara fausa metane karikia purakano, tetā tetákara kutua etehokosapo. Anapaka re Ferese aporoyaki paohokopo.” ");
INSERT INTO faa_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Airakano Pitamo someraka, “Takume kepoane isuaki somesie.” ");
INSERT INTO faa_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Airakano Yasumo someraka, “Repo kepoane yaiya hemakapurakarifare? ");
INSERT INTO faa_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Makata nesane katukunua pukua katukunu aeyaka fako otoa pukua fakonapo. ");
INSERT INTO faa_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Arirakano himumo watikiaka hemakapusuane akaimo soko watikiaka someanamo, ipi yia mawatikinapo. ");
INSERT INTO faa_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Asiamo aporo hinamo himua makata watikiaka hemakapukua risirane oyapo. Watikiaka hemakapurane soko, aporomano rusua kukuko hemakapurane soko, hinamo hakimako hemakapurane soko, aporo rea puko hemakapurane soko, makata kemo hakimako hemakapurane soko, kotafe topakamaraka somehoko hemakapurane soko, aporomano hokomaka somehoko hemakapurane soko, makata ane himua risiane akaimo somerapo. ");
INSERT INTO faa_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Makata amo aporomano ipiane mawatikinapo. Asiamo makata nako hokono kusuhoanafononamo aporomano ipiane mawatikinafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yasumo soko ipi aporo hakāsa puramo soko, apeane metakarikia puraka, Yu aporohoanafonosamo hauaka á, pukua Taia taoneane soko, Saetone taoneane soko, makeraka pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Pukua á reakipoko Yu aporohoanafonosa hinamo, Kenane aporo ira wainepe pesa hinamo ane kayapo. Hinamoane Yasu rea peraka paroaka someraka, “Tefetemo aporo ira Unihaeo, nómo ano kamenakaraka ararerasie. Nōmo hinamo hokosa yatafumo ho masa mokoatikisane kárapo.” Aíyaka hinamoamo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aíyaka somerakano yia Yasumo eaki makata meta somesafapo. Somehoanafonoraka Yasu purakano, ipi aporo hakāsa pura pekea eaki efera hunia soko, efera hunia soko paroaka someraka, “Hinamoane isu kekemerape peraka wáka kikirape apere. Hinamoamo hokosane ararerasie airakane nómo ararerasie. Arareraka ipi paripusiesie.” ");
INSERT INTO faa_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Airakano Yasumo someraka, “Yu aporo suane saro sipi rosaka tarisia asíapo. Asiasamo Yu aporo hinamo hákasa ararehoko Kotimo ano pusierakasupo. Yu aporohoanafonosane ararehoko ano pusierakasufapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Somerakano Yasu rea hinamoane pekea kakuna porokoa kake someraka, “Unihaeo, ano ararerasie.” ");
INSERT INTO faa_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Airakano Yasumo someraka, “Hokosamo makata nakosane kásamo nasimo mamakatehoane siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Airakano hinamoamo someraka, “Unihaeo, kakarorakae. Asiāne ape wafayamo ape teporo aeyaka makata nenaka momo hurupeperakano, kásamo soko nenapo.” ");
INSERT INTO faa_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Airakano Yasumo someraka, “Hinamo, nómo anoaki himu hakásaraka hemakapurane kárapo. Nómo hemaka apura ayiáka nōmo ayiakakosapo.” Aihoanine hinamo hokosa yatafumo ho masane fasapo. ");
INSERT INTO faa_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yasumo Yu aporohoanafonosamo hauakane metakarikia pukua, he Kariri he fua pusuapo. Pukua ūria hikia kayapo. ");
INSERT INTO faa_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kayakipoko aporomano yakai peraka, aporomano korake matipusa soko, aporomano hokono narisa soko, aporomano hi fausa soko, aporomano me fasa soko, aporomano metakira makata tasane soko mokoa pesapo. Mokoa pekea Yasu rea kumisi nenemea mokoa pekea taerakano, Yasumo asekea aporo hinamo makata tasa suane epo mafasapo. ");
INSERT INTO faa_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Asiamo aporomano me fasa mafasamo koteaka somesapo. Hokono narisa mafasane hokono koteaka raesapo. Korake matipusa mafasane koteaka koraka risiapo. Hi fausa mafasamo koteaka asesapo. Ayiáka aporomano suane Yasumo mafasapo. Mafarakano aporomano sarimasamo asekea fofaraka yia sesesapo. Seseraka Isiraya aporo hinamomo Kotiane kekeresapo. ");
INSERT INTO faa_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yasumo ipi aporo hakāsa puraki makata somehoko peaeraka perakano, iaki someraka, “Sere isiamo aporo hinamo yakai anoyaki sarimaraka risike, makata nakosane fapo. Fasasamo nōmo iane kamenakaripo. Iane himu raru ikia kara meamoraka yofenapaka pusiehoko hisiripo.” ");
INSERT INTO faa_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Airakano aporo hakāsa puramo someraka, “Isu arisia one ima yaosasamo aporomano sarimasaki farawa siaraka nasimo kakakosane ma mokoakosare?” ");
INSERT INTO faa_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Airakano Yasumo iaki kairaka, “Repo farawa yakapusu tokenare?” Airakano ipu someraka, “Farawa yatipinusu pokoa fete hukusi tokenapo.” Aíyaka ipu somesapo. ");
INSERT INTO faa_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Aíyaka somerakano aporo hinamo suaki Yasumo someraka, “Re su hauaka á toae.” ");
INSERT INTO faa_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Aíyaka i tokeno, farawa yatipinusu, pokoa hukusi soko Yasumo mokoa, Kotiaki suseaka kurikuriraka faraka, farawa mosoraka aporo hakāsa puraki karaka rekeno, ipu aporo hinamo su sarimasaki takupe pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Takupe pukua faraka aporomano su sarimasamo siaraka nesapo. Nekea siarakano farawa momoane aporo hakāsa puramo mokoa, mate yatipinusua kekea komarusuapo. ");
INSERT INTO faa_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Arirakano aporo farawa nesa susuane menosane fo taosenepo (4,000). Arirakano hinamo soko, hokosa fete soko, iane menosafapo. I menohoanafonosamo soko makata ane nesapo. ");
INSERT INTO faa_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nekea faraka aporomano yakai sarimasane Yasumo pusiesapo. I purakano Yasu kasua ripaka kasu rokoa Mákatane hauaka á pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yasu reakipoko Ferese aporo soko, Satusi aporo soko pekea, ipu Yasu kau aseakosakipoko Yasuaki mokopipiraka somesapo. Ipu someraka, “Kotimo murikimasane nereapo aihoko nómo rakirane isiapo aseako nómo rakikitakae. Kotimo hepene yapura makata ainane isiapo aseako nómo rakikitakae.” ");
INSERT INTO faa_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Airakano Yasumo someraka, “Samapu maiya tuakeramo ti surakano aseraka repo someraka, ‘Kupa kakasireapo,’ airapo. Arirakano sere metamo mituru fiarakano aseane ti kokorasakipoko katorakano aseraka repo someraka, ‘Pipu yao peasireapo,’ airapo. ");
INSERT INTO faa_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aíyaka repo ti aseraka yao peakosane soko, yao kotehokosane soko, repo aseraka takekea hemakapurapo. Ane aseraka hemakapura yaiya maiya omo Kotimo wakapumo hemakapukua rakirane rakirakano asekea, ‘Kotimo murikimasa aporoane ereapo.’ Aíyaka repo hemakapurakarifapo. ");
INSERT INTO faa_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Aporomanomo someraka, “Kotimo murikimasa aporoane nesekenone, isiapo aseako Kotimo wakapumo hemakapukua rakirane rakikitakae. Ayiáka rakirane aseako kope apura maiya amo aporo hinamo risiane watikiaka risikinapo. Aporo hinamoamo Kotiaki hemakapurakanafapo. Arirakano Yonamo Kotimo rakira rakisimo Kotimo murikimasapo. Murikimasane aporo hinamo suamo asekea hemakapusimo Yonaki asia ayiáka anoaki soko ayiakakosapo. Ayiakakosa hákasane repo asekeasimo tariakosapo. Makata meta reaki tariakosafapo.” Aíyaka someaka faraka Yasu rukunekeraka pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yasu soko, ipi aporo hakāsa pura soko, kasua ripaka rokoa teraporaka hikia, he fe taku ra risike someraka, “Isiapo farawa mokoa pesafapo. Isiapo merarusapo.” ");
INSERT INTO faa_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Airakano iaki Yasumo someraka, “Ferese aporomo soko, Satusi aporomo soko, ipu makata pirira asíane repo mokoakohoamo asekeanie.” ");
INSERT INTO faa_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aíyaka Yasumo takumeaka somerakano some kepoane ipu himeteraka me rukua someraka, “Isiapo farawa mokoa peanafonosekeno airakae.” ");
INSERT INTO faa_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Airakano ipu hemakapusuane Yasumo aseraka someraka, “Repo anoaki himumo hákasa wakasemaraka hemaka apure. Marirakano repo namina susu me rukua someraka, farawa fareaporakanare? ");
INSERT INTO faa_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nōmo some kepoane repo yaiya mahimeterire? Aporo fae taosene (5,000) sarimasaki farawa kakoreasu kaka faraka, farawa momo yia tokeno mate kenosua kekea komarusuane, repo hemakapurakarifare? ");
INSERT INTO faa_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Arirakano aporo fo taosene (4,000) sarimasaki farawa yatipinusu kaka faraka, farawa momo yia tokeno mate yatipinusua kekea komarusuane repo hemakapurakarifare? ");
INSERT INTO faa_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nōmo reaki namo kakaro farawa ane somehoanafonosasamo, nōmo someamo kepoane repo hemakapurakarifapo. Nōmo some kepoane úyaka somerakanapo. Ferese aporomo soko, Satusi aporomo soko, ipu makata pirira asíane mokoakohoamo asekeanie.” ");
INSERT INTO faa_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Airakano Yasumo someamo kepoane aporo hakāsa puramo hemakapuraka, “Ferese aporope Satusi aporo ipu someane makata pirira asíapo. Ipu someane isiapo kakimakohoamo Yasumo airakae. Kakaro farawa makata pirirane mokoakohoamo epo somerakarifapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yasu Sisaría Firipai taone makea peraka, ipi aporo hakāsa puraki someraka, “Aporomanomo Táke anoane aporo metakiramo epapakasure?” ");
INSERT INTO faa_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Airakano ipu someraka, “Aporo metakiramo someraka, ‘Ne Yone he tapukumarerane turikia pureapo.’ Airakano aporo metakiramo someraka, ‘Ne Iraíyareapo.’ Airakano aporo metakiramo someraka, ‘Ne Yaremayareapo.’ Airakano aporo metakiramo someraka, ‘Ne porofete aporo metareapo.’ airakasupo.” ");
INSERT INTO faa_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Airakano Yasumo someraka, “Repo namina hemakapusuane ano epapaka hemakapurakanare?” ");
INSERT INTO faa_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Airakano Saemone Pitamo someraka, “Koti yaiya reramo hokosane nepo. Kotimo Unihaeaka rekeasimo murikimasa aporo Keresoane nereapo.” ");
INSERT INTO faa_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Airakano Yasumo someraka, “Yonemo hokosa Saemoneo, Kotimo ne makoterakanapo. Makoterakano seseaka rekeanie. Nómo hemakapukua somesane aporomanomo neaki some kasane nómo somerakanafapo. Nōmo Ata hepene yapura reamo neaki tarirakano, nómo aíyaka somerakae. ");
INSERT INTO faa_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Hao, kaisie. Pita, nómo yano motosa amo kepoane ekepo. Arirakano nómo anoane somesane eke asiapo. Nómo anoane somesa ayiáka, aporo hinamo metakiramo ayiáka kakimaka somerakanone, iane nōmo pasimokoakosapo. Aporo hinamoane anoa paosa aporo hinamo ayapo. Asiamo Hetisi hauaka aeyaka, kuramo wakapumo anoa paosa aporo hinamoane marutaehokosafapo. ");
INSERT INTO faa_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Arirakano aporo hinamo Kotimo asekea reane ipu hemakapusimo, nómo ikia koro ropakamakosapo. Ikia koro kimo ropaka amara ayiáka, nómo anoane some kakasimo nōmo ne murikimarakanapo. Asiamo hauaka wo aporomo watikiaka rakirakano, nómo asekea maroporaka, ‘Metakarisie,’ airakano, hepene yapura soko Kotimo ‘Metakarisie,’ airakanapo. Arirakano hauaka wo aporomo koteaka rakirakano, nómo asekea, ‘Kotehoareapo,’ airakano, hepene yapura soko Kotimo, ‘Kotehoareapo,’ airakanapo.” ");
INSERT INTO faa_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Aíyaka Yasumo ipi aporo hakāsa puraki me paroaka someraka, “Ano Keresoane aporo suaki somehokopo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Maiya amo ipi aporo hakāsa puraki Yasumo someraka, “Ano ayiakaniesasamo, Yarusarame sitia hinaka, Yu aporo sisimamo soko, pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, ano mokoatikirakano, himu nekea kau teraka ayiáka rusua kukusapo. Rusua kusuane sere isiamo ano maturikia taehokosapo.” ");
INSERT INTO faa_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Airakano aporo hakāsa pura sarimaraka risiane metakarikia, Pitamo Yasuane karikia wakasema pukua Yasuaki matasoraka sikiraka someraka, “Unihaeo, Neane rusua kukusapo, aíyaka somehokopo. Kotimo ne ararehoasimoripo. Nómo airakane ayiakakohoamoripo.” ");
INSERT INTO faa_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Airakano Yasumo rekeako pariraka Pitaki someraka, “Sataneo. Né ano patera takua pusie. Satanemo somera aíyaka nómo somehokopo. Kotimo hemakapusuane kekemaraka hemakapunafonoraka, aporomanomo hemakapurane nómo kekemaraka hemaka apure. Aíyaka hemakapuraka ikia kara pukusa matasona kepoane nepo.” ");
INSERT INTO faa_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Airakano aporo hakāsa puraki Yasumo someraka, “Repo ano patera aseako ano ira paremareraka kukusimo ira matopesa nōmo nī makatiraka apura ayiáka, re soko, repo hemakapusuane metakarikia ira matopesa makatiraka puraka, ano finisa re soko fini kafo kepe punie. ");
INSERT INTO faa_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aporomano hauaka wo areamo hitaferaka rekeakosane hákasa hemakapukua rakiraka rekeno, aporoane Kotiyaki yaiya rekeakosafapo. Arirakano aporomano metamo someraka, ‘Yasupoko ano kuane soko siahoasireapo. Epoko hákasa rakikia rekeakosapo.’ Aíyaka hemakapukua, kurane namonafaraka rekeno, aporoane Kotiyaki yaiya rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Arirakano aporomanomo hauaka kára wo makata kemo suane mokoa sarimaraka reke, Kotiyaki yaiya rerane epo metakarikia rekeno, akura maiya amo makata yakapamo e ararehokosare? Yaiya rerane ropohoko yakapamo roponare? Wae. Yaiya rerane roponafapo. ");
INSERT INTO faa_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Atamo faesayaki hepene aporoyaki ayiáka Aporomanomo Táke anoane paripeakosapo. Pariapera maiya amo aporo suamo makata rakisiane asekea takeakosapo. Takekea aporo koteaka rakisiaki makata ropo kotesa kakakosapo. Aporo watikiaka rakisiaki makata ropo watikisa kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nōmo reaki kakaro somerakaripo. Re metakira yumo risiane kukusiraka aseane, Aporomanomo Táke anoane peraka unihaeaka rekeno aseakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sere namasu faraka Yasumo Pita soko, Yamese soko, Yamesemo ipi mamanea Yone soko, i karikia ūri terayia hisiapo. Hikia namina hakāsa risike ");
INSERT INTO faa_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","aseane Yasu kau hakuraka reke sere maíyamo faeana ayiáka, Yasumo hikumisiane faeraka reke, ipi pasu ososane soko namo kakaro pakaeraka faesapo. ");
INSERT INTO faa_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Faeraka rekeno ipu aseane, Mosesepe Iraíya tetā Yasuyaki hakāsa risike somerakano asesapo. ");
INSERT INTO faa_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Aseraka Pitamo Yasuaki someraka, “Unihaeo, Isu o pesane kotesapo. Nómo, ‘Ao, seseripo,’ airakanone nōmo ape mano isia kiakosapo. Meta nepoko, meta Mosesepoko, meta Iraíyapoko ayiáka kiakosapo. Ne seserire?” ");
INSERT INTO faa_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Aíyaka Pitamo someraka rea yiamo, ako kára faesamo wate foaka iane karotapisiapo. Ako karotapisia arakaru aeyaka someraka, “Eane nōmo nī hokosapo. E nōmo himu tumurumo kára hemakapukua seserakanapo. Epo someane kaikia hemakapukua risikianie.” Aíyaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Aíyaka somerakano aporo hakāsa puramo kaikia, hauaka uaka peperaka fofaraka namosapo. ");
INSERT INTO faa_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Namorakano i warisia Yasu pekea i kaua sakairaka someraka, “Re turikitarirasie. Namohokopo.” ");
INSERT INTO faa_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Aíyaka somerakano, i turikitariraka himo kokoa, ra asekea, ro asekea aseane, aporo meta rekeanafonoraka Yasu hákasa rekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Arirakano i ūri terayia aeyaka peraka risike Yasumo paroaka someraka, “Aporomanomo Tákeane anopo. Ano kukua maturikia taehoasiraka repo kituamo asera ayiáka asesane aporo hinamo metaki somehokopo.” ");
INSERT INTO faa_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Airakano aporo hakāsa puramo someraka, “Kotimo somemane tisa aporomo someraka, ‘Kereso peasiraka Iraíya fana peakosapo.’ Aisane marirakano ipu aisare?” ");
INSERT INTO faa_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Airakano Yasumo someraka, “Kotimo somemane tisa aporomo someraka, ‘Iraíya fana peraka makata su makotehokosapo.’ Aisane kakaro aisapo. ");
INSERT INTO faa_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Arirakano nōmo some one kakaroripo. Iraíya peakosaposane fana pesapo. Pesane ipu asekea hemakapuraka, ‘Iraíya peakosaposane ereapo.’ Aíyaka hemakapusuafapo. Hemakapurafaraka ipu hemakapusua rakiraka eane mokoatikisapo. Mokoatikisa ayiáka Aporomanomo Táke anoane soko kau tehoasimo mokoatikihokosapo.” ");
INSERT INTO faa_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Airakano aporo hakāsa puramo hemakapuraka, “Iraíya peakosaposane, Yone he tapukumarera ayareapo, aiyaka Yasumo somerakae.” Aiyaka ipu hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yasu soko, ipi aporo hakāsa pura Pita soko, Yamese soko, Yone soko i pukua, aporo hinamo yakai sarimaraka risiakipoko á pausapo. Pauraka Yasu rea aporo meta peraka, kakuna porokoa kake someraka, ");
INSERT INTO faa_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Unihaeo, nōmo aporo hokosane efera hunia masuaraka rukumotoraka káranapo. Maiya metamo ira paisia huruperapo. Maiya metamo hea huruperapo. Anasasamo nómo e kamenakaraka ararerasie. ");
INSERT INTO faa_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Asiamo nómo aporo hakāsa pura risiakipoko, nōmo hokosane karikia peane ipu mafarakasafapo.” ");
INSERT INTO faa_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Airakano Yasumo someraka, “Aporo hinamo maiya yumo risiamo Kotiaki himu hakásaraka hemakapukua riskianafonoraka watikiaka risikinapo. Maiya suamo repo hasaka hemakapukua risikino, nōmo repoko maiya suamo yaiya wafororaka rakiraka rekeakosare? Reyaki ano maiya káramo rekeno yia, repo anoaki himu hakásaraka hemakapukua risikirifapo. Ano rea wo hokosane karikia peae.” ");
INSERT INTO faa_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Airakano hokosa karikia pesapo. Karikia perakano yatafuaki Yasumo paroaka someraka, “Ne metakarikia pusie.” Aihoanine yatafu metakarikia pusuapo. Yatafu purakano hokosane fasapo. ");
INSERT INTO faa_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Yasumo hokosa mafarakano aporo hakāsa puramo asekea, keseke i Yasu rea pekea hakāsa toke Yasuaki someraka, “Isiapo yatafuane metakarikia pusierakano punafonosane marirakanonare?” ");
INSERT INTO faa_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Airakano Yasumo someraka, “Repo Kotiaki hemakapusuane namo kakaro wakasemasasamo yatafuaki someraka, ‘Ne metakirikia pusie,’ airakano pusuafapo. Nōmo some one kakaro somerakaripo. Repo Kotiaki himu hakásaraka hemakapusuane ira maseta hae tati siasekenone, ūriaki someraka, ‘Ūri ne hauaka one metakarikia, hauaka meta rekeako pusie,’ airakano pukusapo. Makata rakira hakása meta repo rakiane siahoasifapo, aisa meta kakenafapo. ");
INSERT INTO faa_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Asiamo yatafu one metakarikia pusie, airakano yatafu pusimo makata nakosa sokoairaka kake Kotiaki kurikurihoanie. Kurikuriraka makata nakosa sokoaihoanafonoraka, yatafu one metakarikia pusierakano pukusafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yasu soko, ipi aporo hakāsa pura soko, i Kariri hauaka risiakipoko Yasumo iaki someraka, “Aporomanomo Tákeane anopo. Ano rusua kukusimo aporomo ano parakehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Parakeraka ano waseremaka kukusimo rukusapo. Ano rusua kusuane sere isia faraka maturikia taehokosapo.” Airakano aporo hakāsa puramo kairaka himu fasapo. ");
INSERT INTO faa_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yasu soko, ipi aporo hakāsa pura soko, Kapaneame taonea pesapo. Pekea Pita rea Kotimo apepoko takese mora aporo pekea, Pitaki kairaka, “Nómo tisamo Kotimo apepoko takese mone motorare?” ");
INSERT INTO faa_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Airakano Pitamo aosapo. Aoraka Pita apea pariperakano, Pitamo somehoasiraka Yasumo Pitaki fana somesapo. Yasumo someraka, “Saemoneo, hauaka wo aporo unihaemo aporo epaki takese mone makasierakanare? Unihaemo ipi hokosaki takese mone makasierakanare? Aporo hinamo metakiraki takese mone makasierakanare? Nómo hemakapusuane yakapare?” ");
INSERT INTO faa_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Airakano Pitamo someraka, “Aporo hinamo metakiraki takese mone makasie, airapo.” Airakano Yasumo someraka, “Ao, Unihae Kotimo soko ipi hokosaki takese mone motosie, airafapo. ");
INSERT INTO faa_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aina ayiáka nōmo metakariafununine, takese mora aporomo mahisihokohoamo, nōmo takese mone motoakosapo. Pita, ne pukua kímamo he motokoa pokoa makosapo. Pokoa fana masa á kíma fatirimaraka, mone hae pokoa akai matoa kesaka rekeno aseakosapo. Asekea mone haeane maka, eto itiaki Kotimo apepoko takese taehoaniesasamo, moneane takese mora aporoaki kakanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Maiya amo aporo hakāsa puramo Yasuaki someraka, “Kotimo unihaeaka asekea rea paosa aporoane epa fanāreare?” ");
INSERT INTO faa_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Airakano i risiakipoko hokosa mano Yasumo peaeraka perakano Yasumo hokosaki someraka, “Isu hikumisi erekea reae.” Aíyaka ipi aporo hakāsa puraki someraka, ");
INSERT INTO faa_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Nōmo some one kakaro somerakaripo. Hokosa manomo e ipiane makáraraka hemakapurafapo. Repo namina ane makáraraka hemakapurane rukupateraka metakarikia, hokosa mano ayiáka risikianie. Hokosa mano ayiáka risikianafonorakanone, Kotimo unihaeaka asekea rea hauaka á hiakosafapo. ");
INSERT INTO faa_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Hokosa e ipiane makárahoanafonoraka area ayiáka, aporomano e ipiane makárahoanafonoraka ayiáka rekeno asekea, eane Kotimo unihaeaka asekea rea paosa aporo fana ane épo. ");
INSERT INTO faa_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aporomanomo e ipiane makárahoanafonoraka anoaki hemakapukua rea aporoamo hokosa asíane ararerakanone ane, ano soko ararerakanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Yasumo someraka, “E ipi makárahoanafonoraka rea aporomo watikiaka rakisimo, aporomo mokopipirakano, mokopipina aporoane mawia eke kára kita humarekea maka, he tawara numua he nasimo makasuhoane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Aporomo watikiaka rakisimo kirimana aporo hinamo ane fanasihokosane enahoasifareapo. Makata watikisane fasereperapo. Mataka watikisa faserepeasimo kirimana aporo hinamo ane fanasihokosane enahoasifareapo. ");
INSERT INTO faa_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Arirakano nómo hokonomo watikiaka rakiraka nómo ní himuane mawatikinapo. Mawatikinapaka hokono takuane patekemaka mamakatehoanie. Hokono tetákara reke ira kopakapunafonona hauaka á makasuhokohoamo, hokono hakása takuane patekemaka mamakateraka, hokono hakása reke, yaiya rerane kepomarekea rakiraka reke siahoasireapo. Arirakano nómo korakemo watikiaka rakiraka, nómo ní himuane mawatikinapo. Mawatikinapaka korake takuane patekemaka mamakatehoanie. Korake tetákara reke ira kopakapunafonona hauaka á makasuhokohoamo, korake takuane patekemaka mamakateraka, korake hakása reke yaiya rerane kepomarakea rakiraka reke siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Nómo himo makata asekea watikiaka rakiraka, ni himuane mawatikinapaka, hi takuane pokomaka mamakatehoanie. Hi tetákara reke heao hauaka á ira rufia makasuhokohoamo, hi takuane pokomaka mamakateraka, yaiya rerane kepomarekea rakiraka reke siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","E ipi makárahoanafonoraka rea aporoane hokomakopo. Aporoane hepene aporomo asekea risikinapo. Asekea risike nōmo Ata hepene yapura rea á, Atamo hikumisi nenemea risikinapo. ");
INSERT INTO faa_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Aporomanomo Tákeane anopo. Aporo himu watikisane nōmo mafasiako ano pesapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Yasumo someraka, “Reaki nōmo takume one somerakano repo mayiáka hemakapukusare? Aporo metamo ipi saro sipi risiane menoraka wane harote (100) ayiáka risiapo. Risiane hakása meta ipi haku rosaka pusua hasaka kosapo. Hasaka kosane aporoamo metakarisiare? Wae. Metakarisiafapo. Saro sipi sarimaraka risiakipoko menoraka naeneti naene (99) risiapo. Naeneti naene (99) risikino aseraka naeneti naeneane ūria yia risikiasimo metakarikia, hakása rosaka pusuane koako hisiapo. ");
INSERT INTO faa_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Koako hikia kokoa aseraka kára sesesapo. Asiamo nōmo kakaro somerakaripo. Saro sipi naeneti naene (99) risiane saro sipi wafayamo aseraka sesenapo. Saro sipi hakása meta rosaka pusuane kokoa aseraka namo kakaro kára sesenapo. ");
INSERT INTO faa_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Aina ayiáka nōmo Ata hepene yapura reamo hemakapuraka, ‘E ipi makárahoanafonosa aporo hakása meta hasaka koane siahoasifareapo.’ Aíyaka Atamo hemakapurapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Yasumo someraka, “Kakimara aporo ni maemo neaki mokoatikirakanone, mokoatikisane metakarisimo titi hakāsa risike eaki somehoanie. Somehoane epo kakimaka, epo neaki mokoatikisane metakarikia, teto titi koteaka maeaka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Asiāne aporoamo nómo someane kakipayarakano, nómo aporo metakira pasimokoa somehoko punie. Aporo hakása soko metao, aporo tetá soko metao pasimokoa somehoko punie. Pukua eaki hukururaka somerakano kairaka, someane kakarorakae aihoasimo, aporo tetámo soko metao, aporo isiamo soko metao, ayiáka somehoane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Asiane ipu someane aporoamo yaiya kakipayarakano anoa paosa aporo suaki somehoanie. Somehoane taka someane koaretaerakano, eane metakarikia kikisiraka risikianie. Metakarikia Yu aporohoanafonosa soko, takese mora aporo soko, re kikisiraka kekeporaka arisia ayiáka, aporoane ayiáka kikisiraka risikianie. ");
INSERT INTO faa_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nōmo someraka one kakaro somerakaripo. Hauaka wo aporomo watikiaka rakirakano, nómo asekea maroporaka, ‘Metakarisie,’ airakano, hepene yapura soko Kotimo, ‘Metakarisie,’ airakanapo. Arirakano hauaka wo aporomo koteaka rakirakano, nómo asekea, ‘Kotehoareapo,’ airakano, hepene yapura soko Kotimo, ‘Kotehoareapo,’ airakanapo. ");
INSERT INTO faa_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nōmo some meta one soko somerakanapo. Kakimara aporo tetámo himu hakásaraka someaka maka hemakapukua aíyaka Kotiaki kurikurirakano, nōmo Ata hepene yapura reamo kairaka makata aiyakaniesane, hakása nineraka rakiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Repo aporo tetámo soko metao, aporo isiamo soko metao, ano yano motosane hemakapukua sarimarakano ano soko pekea reyaki hakāsa rekeakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Yasu reakipoko Pita pekea kairaka, “Unihaeo, kakimara aporo nōmo maemo maiya suamo ano mokoatikirakano, ropo eaki paripurafaraka yape yakapusumo nōmo mameraruhokosare? Yape yatipinusumo mameraruhoane siahoasireare?” ");
INSERT INTO faa_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Airakano Yasumo someraka, “Yape yatipinusumo mameraruhoane siahoasifareapo. Nómo menonafaraka epo neaki mokoatikisane nómo kára mameraruhoanie. Mameraruhokosane hokono u susuane u senaki sumo mameraruhoanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Yasumo someraka, “Kotimo aporo hinamo unihaeaka asekea rea asíane oyapo. Aporo unihaeaka reamo ipi aporo raipaki someraka, ‘Nōmo reaki mone ropo mako kasane pipu mone ropo mokoa peae.’ ");
INSERT INTO faa_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Airakano aporo raipa metamo mone kára tene mirione kina (K10,000,000) ropo kakasimo aporo metakiramo karikia pesapo. Aporo raipa karikia pesamo mone ropo kakasimo namo kakaro kara ropo kakafunusa nine ");
INSERT INTO faa_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","mone fareapo, aisapo. Airakano aporo unihaemo someaka mareraka, ‘Aporo raipa mone kakanafonosamo ipi makata kemoane ropohoanie. Roporaka e ipi soko, epo ipi asea soko, epo ipi hokosa soko su ropohoanie. Ipu suamo nena raiparaka rakisimo aporo metamo iane roporaka mone mosane anoaki mokoa peanie.’ ");
INSERT INTO faa_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Aíyaka someaka marerakano aporo raipa amo kaikia kakuna porokoa kake kukunameaka someraka, ‘Unihaeo, haru ayiakakopo. Wakasema nina keseke mone suane nōmo néaki kakakosapo.’ ");
INSERT INTO faa_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Airakano aporo unihaemo kamenakaraka hemakapukua someraka, ‘Mone namo kakaro kára ane nómo anoaki kakafunusa nine, nōmo metakarirakanapo. Keseke nōmo soko neaki makasie, aihokosafapo. Pipu nōmo mamerarurakanapo.’ ");
INSERT INTO faa_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Aíyaka somerakano kaikia, aporo raipane pukua aporo raipa meta mawia mokotenekeraka someraka, ‘Fana nōmo neaki tene kina (K10) ropo mako kasane pipu ní makasie.’ ");
INSERT INTO faa_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Airakano ipi aporo raipa tákeane kakuna porokoa kake kukunameaka someraka, ‘Wakasema nina keseke nōmo neaki kakakosapo.’ ");
INSERT INTO faa_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Airakano aporo raipa amo waesapo. Waeraka ipi aporo raipa tákeane hukurukua tipura makesapo. Makerakano asekea someraka, ‘Fana neaki mone kasá akipoko, nómo mone ropo kakanafonorakano né tipura yaiya rekeakosapo.’ Aíyaka ipi aporo raipa tákeane tipura makerakano, ");
INSERT INTO faa_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","aporo raipa metakiramo asesapo. Aseraka kára mahisiraka ipu makata asesane aporo unihaeaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Somerakano aporo unihaemo ipi aporo raipa peaesapo. Perakano aporo unihaemo someraka, ‘Né aporo raipa watikisapo. Nómo anoaki, “Haru ayiakakopo,” aisasamo nómo anoaki mone ropo kakafunusa nine nōmo mamerarusapo. ");
INSERT INTO faa_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mameraruraka nōmo néaki kamenakaraka hemaka apura ayiáka, nómo soko ní aporo raipa tákeaki ayiáka kamenakaraka hemakapufunureapo.’ ");
INSERT INTO faa_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aíyaka aporo unihaemo epo aporo raipaki saperaka tipura makesapo. Makekea someraka, ‘Ne kau tehoasimo tipura asekea rea aporomo né ruraka kau tehokosapo. Anoaki mone ropo kakanafonorakano tipura yaiya rekeakosapo. Anoaki mone karakano ne tonotaehokosapo,’ aisapo.” ");
INSERT INTO faa_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Aíyaka Yasumo takumeaka someaka faraka, ipi aporo hakāsa puraki someraka, “Repo namina aporo tákemo re mokoatikirakano, repo himu mahisisane fana mafaraka mameraruhoanafonorakano, ane unihaemo ipi aporo raipaki rakisia ayiáka, nōmo Ata hepene yapura reamo reaki ayiáka rakiakosopo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yasumo someaka faraka Kariri hauakane metakarikia pukua, he Yotane yaoraka taku ra Yutía hauaka á reapo. ");
INSERT INTO faa_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Reakipoko aporo hinamo yakai Yasu kekemarape perakano asekea aporo hinamo makata tasane Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Mafaraka Yasu reakipoko Ferese aporo peraka, Yasu kau aseakosakipoko ipi hasaka somehoasimo, ipu mokopipiraka someraka, “Aporomo ipi hinamo fimareakosane kepo kakeno fimareane siahoasireare? Kepo kakeno fimareane somemaneane mamosohoasireare?” ");
INSERT INTO faa_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","5","Airakano Yasumo someraka, “Wate fana kepomaresa maiya amo Kotimo aporo soko hinamo soko tetákara rakisiapo. Rakiraka Kotimo someraka, ‘Aporomo ipi kaīyia ipi wafaya metakarikia hinamo arumaraka, ipi hinamoyaki hakāsa paoraka tati kau hakásaraka risikinapo.’ Aíyaka Kotimo somerakano Kotimo sawia popasane repo asesare? Ao, repo asesapo. ");
INSERT INTO faa_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Asiamo aporomo hinamo arumaka tati kau hakásaraka risirasamo tetáraka risikinafapo. Tati hakásapo. Asiamo aporo hinamo tati Kotimo masarimasane aporo metamo maparakuhoane siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Airakano Ferese aporomo Yasuaki someraka, “Fana Mosesemo someraka, ‘Hinamo arumasa fimareako hinamoaki sawi poparaka kakanie.’ Aisane marirakano Mosesemo aoraka fimareane siareapo aisare?” ");
INSERT INTO faa_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Airakano Yasumo someraka, “Aporomo Kotimo someane koaretaesasamo Mosesemo aporoaki, ‘Hinamo fimareane siahoasireapo,’ aisapo. Asiāne Kotimo kepomarekea rakisia maiya amo Kotimo aisafapo. ");
INSERT INTO faa_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nōmo reaki some one somerakanapo. Aporomo hinamo arumasane, hinamoane ipi aporo metayaki punafonoraka koteaka kakeno yia, ipi apiamo hisiraka e fimarekea hinamo meta arumarakano, aporoamo hinamo metane hakimarakanapo.” ");
INSERT INTO faa_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Aíyaka Yasumo somerakano, ipi aporo hakāsa puramo Yasuaki someraka, “Nómo aporomo hinamo arumara someane kakaro hosekenone aporomo hinamo arumarafaraka nena risike siahoasireapo.” ");
INSERT INTO faa_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Airakano Yasumo someraka, “Repo airaka ane aporo suamo kakimakasifareapo. Kotimo aporo metakira nena risikiasimo ararerakano hinamo arumako hemakapurane fasapo. ");
INSERT INTO faa_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kaisie. Aporo suamo hinamo arumarafapo. Aporo metakira haku hakusa risirapo. Arirakano aporo metakira makeposa hinamo arumakasifa asia takaperapo. Ipi kaīyiamo takaperaka yia anapo. Arirakano aporo metakirane aporo metakiramo mokoatikiraka maropakeraka risike hinamo arumarafapo. Arirakano aporo metakiramo hemakapuraka, ‘Koti unihaemo makata rakirane rakiakosakipoko nōmo hinamo arumakosafapo.’ Aíyaka hemakapukua hinamo arumarafapo. ‘Hinamo arumakosafapo.’ Aíyaka hemakapurane himura siarakano hinamo metakarinie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Yasu reakipoko hokosa karikia pesapo. Hokosa karikia pesane Yasumo hokonomo sakairaka Kotiaki kurikurihoasimo karikia pesapo. Karikia pesa aporo hinamoaki Yasumo aporo hakāsa puramo himu mahisiraka someraka, “Hokosa karikia peakopo.” ");
INSERT INTO faa_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Airakano Yasumo someraka, “Ano rea hokosa peane siahoasireapo. Perakano matasohokopo. Hao, kaisie. Aporo hinamo e ipiane makáranafaraka hokosa mano ayiáka risiane, Kotimo unihaeaka asekea rekenapo.” ");
INSERT INTO faa_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Aíyaka someaka hokosane Yasumo hokonomo sakaisapo. Sakairaka faraka Yasumo i metakarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Yasu reakipoko aporo meta peraka someraka, “Tisao, ano Kotiyaki yaiya rekeakosakipoko, nōmo makata kotesa yakapa rakiakosare?” ");
INSERT INTO faa_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Airakano Yasumo someraka, “Makata kotesane anoaki marirakano kairakanare? Koti ipi hákasa kotesapo. Ne Kotiyaki yaiya rekeakosakipoko, pipu paohoko hemakapuraka Kotimo somemane kakimaka rekeanie.” ");
INSERT INTO faa_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Airakano aporoamo someraka, “Somemane meta mane kakimaka rekeakosare?” Airakano Yasumo someraka, “Aporo kukusimo rukupo. Hinamo hakimakopo. Makata meta hakimakopo. Aporo metaki kotafe topakamahokopo. ");
INSERT INTO faa_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ní ata soko ní ama soko koteaka hemakapukua makotehoanie. Nómo níane himu tumurumo hemaka apura ayiáka, ní aporo táke metane ayiáka himu tumurumo hemakapunie.” ");
INSERT INTO faa_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Airakano aporoamo someraka, “Somemaneane nōmo kakimaka yaiya reapo. Makata meta yakapa rakiakosare?” ");
INSERT INTO faa_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Airakano Yasumo someraka, “Ne sia koteaka susu rekeako nómo makata kemo suane ropohoko pusie. Pukua makata kemoane roporaka marekea, mone mosane aporo makata forokoa risiaki kakanie. Kaka farakano nómo makata mahimunane hepene yapura tokoakosapo. Asiamo nómo ní makata kemo kaka faraka ano patera aseako peanie.” ");
INSERT INTO faa_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Airakano aporo raua amo kairaka ipi makata kemoane kárasasamo aporo metakiraki kakako hisiraka, Yasuane metakarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Purakano asekea Yasumo ipi aporo hakāsa puraki someraka, “Nōmo reaki kakaro somerakaripo. Makata kemo káraraka rea aporoane Koti unihaeaka rea paohokosane namo kakaro waforonapo. ");
INSERT INTO faa_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Some one nōmo kakaro somerakaripo. Pasu irina nitoro kakarua saro kamo kokoro puane tapenapo. Aina ayiáka makata kemo káraraka rea aporoane Koti unihaeaka rea paohokosane namo kakaro waforonapo.” ");
INSERT INTO faa_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Airakano aporo hakāsa puramo kairaka fofaraka someraka, “Aporo makata kemo kárasane Koti unihaeaka rea paohokosane, namo kakaro waforonapo, airakae. Asiamo aporo epa Kotimo unihaeaka asekea rekeako mafasiakosare?” ");
INSERT INTO faa_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Airakano Yasumo ipi aporo hakāsa purane asekea someraka, “Aporoane Kotimo unihaeaka asekea rekeasimo, aporomo ipi yiamo mafasirafapo. Mafasirane Koti ipi hákasa siapo.” ");
INSERT INTO faa_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Airakano Pitamo someraka, “Isiapo makata kemo su metakarikia, ne patera aseako pesapo. Asiasamo isiapo makata yakapa mokoakosare?” ");
INSERT INTO faa_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Airakano Yasumo someraka, “Hao, kaisie. Some one kakaroripo. Aporomanomo Tákeane anopo. Keseke makata su makawena maiya amo ano unihaeaka rekeakosapo. Uniheaka reke sea kára faesa susu á kakakosapo. Kakeno re soko anoyaki sarimaraka sea metakira keno sua re tokoakosapo. Toke, Isiraya aporo ira keno suane repo koteaka asekea risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aporo hinamo suamo hakása hakásaraka anoaki hemakapuraka nōmo rakirane rakiakosakipoko, ipi ape metakarikia, mae metakarikia, papā metakarikia, apu metakarikia, ata metakarikia, ama metakarikia, hokosa metakarikia, hauaka metakarikia, ayiáka makata su metakarikia rea aporo hinamoamo makata ropo kára mokoa Kotiyaki yaiya rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Asiamo yumo aporo hinamo yakai fanaraka risiane kesekehokosapo. Aporo hinamo yakai yumo kesekea risiane fanahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yasumo someraka, “Aporo hinamoane Kotimo unihaeaka asekea rea asíane oyapo. Mituru fiarakano hemo wafaya koraka reke, sako karepe hemoa aporomo rakisimo, aporo pasimokoako koraka reapo. ");
INSERT INTO faa_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Koraka reke makata rakira aporoane aseraka iaki someraka, “Repo sere hakásamo rakirakano reaki yokotae wane kina (K1) hakása hakásaraka kakakosapo.” Aíyaka somehoane ipu aorakano hemo wafayamo kaikia iaki someraka, “Re makata rakiako pusie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pusiesakipoko maiya tokonamo hemo wafaya efera hunia koraka reke, hauaka moroa aseane aporo metakira nena risikino asesapo. ");
INSERT INTO faa_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Aseraka iaki someraka, “Re hemoa rakiako pusie. Nōmo hemakapusuane makata ropo siahoasisekeno reaki kakakosapo.” Airakano i makata rakiako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pusuakipoko maiya tipi maiya kenomo soko, samapu maiya isiamo soko, hemo wafayamo aporo metakiramo hemoa rakisimo makata ropo fana somesa hakása yaiya somesapo. Somerakano i makata rakiako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Samapu maiya kakoreamo hemo wafaya efera hunia pukua hauaka moroa aporo nena risikino aseraka iaki someraka, “Repo maiya suamo marirakano nenakamaka risikinare?” ");
INSERT INTO faa_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Airakano ipu someraka, “Hemo asekea rea aporoamo isuaki rakinie, aisafapo.” Airakano hemo wafayamo someraka, “Re pukua sako hemoa rakinie,” aisapo. Aíyaka somerakano i makata rakiako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ererakano hemo wafayamo hemo asekea rea aporoaki someraka, “Hemoa rakiraka risia aporoane su peaehoanie. Perakano asekea iaki makata ropo kakanie. Karaka aporo samapu pesane fana kakanie. Amo patera aporo mituru maíyamo pesane kakanie. Amo patera aporo fiarakano pesane kesekea kakanie.” ");
INSERT INTO faa_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Aiyaka hemo wafayamo somerakano aporo maiya kakoreamo pesaki yokotae wane kina (K1) hakása hakásaraka kasapo. ");
INSERT INTO faa_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ayiáka karakano asekea aporo mituru fiarakano pesamo hemakapuraka, ‘Iaki yokotae wane kina (K1) akarane, isuaki yokotae wane kina (K1) kakakosaposane meta ripakamarekea kakakosapo.’ Aiyaka hemakapusuane iaki soko, yaiya yokotae wane kina (K1) kasapo. ");
INSERT INTO faa_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Karakano ipu hemo wafayaki mahisiraka someraka, ");
INSERT INTO faa_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Aporo maiya kakoreamo pesamo wakasema rakisiapo. Isu mituru fiarakano pekea rakipe pukua samapu metakarisiapo. Isu maiyamo sisipuraka kikipuraka rakikia hisiraka kára waforosapo. Aporo maiya kakoreamo pesaki soko isuaki soko hakasa yineraka kayane siahoasifareapo.’ ");
INSERT INTO faa_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Airakano aporo mituru fiarakano pesa metaki hemo wafayamo someraka, ‘Hao, kaisie. Nōmo reane pasimosa maiya amo nōmo reaki makata ropo yokotae wane kina (K1) kakakosapo. Aihoane nómo aorakano kaisiapo. Asiamo etapo iti someaka masane nōmo mamosorakanafapo. ");
INSERT INTO faa_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Yokotae wane kina (K1) hakása nine maka pusie. Yokotae wane kina (K1) one nómo ní makata ropo ayapo. Nōmo hemakapusuane aporo fana pesane soko, aporo keseke pesane soko, makata ropo hakása yineraka kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nōmo nī menane nōmo nī hemakapukua kayane siahoasireapo. Asiamo aporo metakiraki nōmo hemakapuraka mone kára karakano nómo anoaki mahisirakanare?’ Aíyaka hemo wafayamo somesapo.” ");
INSERT INTO faa_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Somesamo kepoane oyapo. “Aporo kesekeraka risiane fanahokosapo. Aporo fanaraka risiane kesehokosapo.” Aíyaka Yasumo someapo. ");
INSERT INTO faa_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yasu Yarusarame sitia hinaka aporo su metakarikia ipi aporo hakāsa pura keno suyaki wakasema hikia iaki hakāsa someraka, ");
INSERT INTO faa_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Hao, kaisie. Isu Yarusarame sitia hinakanapo. Yarusarame sitia aporo metakiramo, Aporomanomo Táke anoane hukurusimo parakeraka wasere maka karikia pukusapo. Pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, hukurusimo ano karikia pukusapo. Karikia pukua ipu ano kukusimo ira paremaresie, aihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Aíyaka ano kukusimo Yu aporohoanafonosamo ano ira paremareakosakipoko karikia pukusapo. Karikia purakano Yu aporohoanafonosamo ano mokoatikiraka mahokoparihokosapo. Ano kaua rukua ira matoperaka paremareakosapo. Paremarerakano ano kukusapo. Kurakano sere isiamo Kotimo ano maturikia taehokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sepetemo aseamo ipi hokosa Yamesepe Yone tetāyaki hakāsa Yasu rea pekea, hinamoamo kakuna porokoa kake Yasuaki someraka, “Nōmo someane nómo kakimaka ayiáka rakisimoripo.” ");
INSERT INTO faa_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Airakano Yasumo someraka, “Nōmo ayiáka yakapa rakisimore?” Airakano hinamoamo someraka, “Ne unihaeaka area maiya amo, nōmo hokosa meta ne hokono tumuru takua kayae, anakano hokosa meta ne hokono kasakai takua kayae, aihoasimoripo.” ");
INSERT INTO faa_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Airakano Yasumo someraka, “Nómo somerakane kepoane nómo ní hemakapurakarifapo. Mokome somerakae.” Aíyaka Yasumo tetāki someraka, “Nōmo kapo he nena tetápo soko nasireare?” Airakano tetapō someraka, “Ao, etapo nakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Airakano Yasumo someraka, “Nōmo kapo he nena hakāsa yia tetápo kakaro nakosapo. Arirakano ano hokono tumuru takua kakakosane soko, hokono kasakai takua kakakosane soko, nōmo kayae aihokosafapo. Nōmo nī hemakapusua aeyaka murikimakosafapo. Nōmo nī Atamo ipi hemakapusua aeyaka sia maroporaka murikimasapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Arirakano aporo hakāsa pura kaeyakosumo kairaka mamanea tetāki hisisapo. ");
INSERT INTO faa_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Hisirakano aporo hakāsa pura suaki Yasumo peaesapo. Perakano asekea Yasumo iaki someraka, “Yu aporohoanafonosamo namina aporo unihaemo aporo metakiraki kára masamasarapo. Aporo unihaeane ipi káraraka reasasamo, aporoaki masamasarapo. ");
INSERT INTO faa_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Aina ayiáka re ayiáka risikiakopo. Repo namina aporo metamo hemakapuraka, ‘Ano aporo káraraka rekeariripo.’ Aíyaka hemakapuraka aporo wakasemamo arakira ayiáka repo aporo supoko arareraka rakinie. ");
INSERT INTO faa_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Asiamo aporo metamo hemakapuraka, ‘Ano aporo fanaraka rekeariripo.’ Aiyaka hemakapuraka aporoamo aporo raipamo arakira ayiáka rakinie. ");
INSERT INTO faa_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Aporomanomo Tákeane anopo. Asiamo aporo raipamo arakira ayiáka aporomo anopoko ayiáka rakisimo ano pesafapo. Aporomano supoko aporo raipamo arakira ayiáka nōmo rakiako ano pesapo. Aporomanomo namina watikisapoko fanasihokohoamo nómo farimaka ano kukuko pesapo.” Aiyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yariko taoneane i metakarikia purakano, aporo hinamo yakai Yasuyaki hakasa puraka ikia kara asekehaerape pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pusua maiya amo aporo tetá hi taku tetákara mesa, ikia kara fea toke Yasu perakarakano kairaka, sakepamo wáraka, “Tefetemo aporo irao, Unihaeo, nómo etoane kamenakaraka ararerasie.” ");
INSERT INTO faa_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Airakano aporo yakaimo paroaka someraka, “Wáhokopo. Me fasie.” Airakano tetapō efera hunia sakepamo wáraka, “Unihaeo, ne Tefetemo aporo irao, etoane kamenakaraka ararerasie.” ");
INSERT INTO faa_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Airakano Yasumo kairaka e pesane wasuaka rukua asekea reapo. Asekea reke tetāki Yasumo someraka, “Tetápo sesehoasimo nōmo mayiakasimore?” ");
INSERT INTO faa_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Airakano tetapō someraka, “Unihaeo, etapo himo koteaka aseako seseripo.” ");
INSERT INTO faa_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Airakano Yasumo tetāne kamenakaraka tetā hia sakaihoane wate foaka faraka tetapō himo koteaka asekea Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aporo hinamo yakai Yasuyaki hakāsa ikia kara hisiapo. Hikia Yarusarame siti makeraka pesapo. Yarusarame sitiane makeraka ūri Orofe rekenapo. Ūri Orofe makeraka Péfasi ape kisia á i pausapo. Pauraka Yasumo aporo hakāsa pura tetáki ");
INSERT INTO faa_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","someraka, “Teto ape tameyia pusie. Pukua aseane ape fari yia saro toki kaīyia humaresa, manoyaki risikino aseakosapo. Aseraka saro tokiane kaīyia manoyaki tetákara fatarimaka ano rea wo karikia peanie. ");
INSERT INTO faa_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Arirakano aporo metamo tetoaki someraka, ‘Tetápo marirakanonare?’ Airakano tetápo eaki someraka, ‘Saro toki aeyaka Unihaemo makata rakiakosapo. Epo aisasamo saro one etapo karikia purakanapo.’ Airakano aporoamo tetoaki, ‘Ao, siareapo. Maka pusie,’ aihokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yasumo aíyaka somehoasiraka wate fana Kotimo some kará porofete aporomo somesane oyapo. ");
INSERT INTO faa_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Aporo hinamo Saeone sitia risiaki someraka, ‘Asesie. Repo Unihae kárane apere. Repo Unihae auaraka reane saro toki matia ripaka apere. Saro toki matia ripasane saro tokiane manopo.’ aihokosapo.” Aisane fasere apera ayareapo. ");
INSERT INTO faa_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Asiamo tetā pukua Yasumo somesa hakása yine kakimaka rakisiapo. ");
INSERT INTO faa_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Rakiraka saro toki kaīyia manoyaki tetákara karikia pesapo. Karikia perakano aporo yakaimo ipu pasuane saro toki matia furumurikia marekea, Yasu á ripasapo. ");
INSERT INTO faa_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ripaka kakeno aporo hinamo yakai ipu suamo ikia kara á ipu pasu ifunusapo. Arirakano aporo hinamo metakiramo makata ku popateraka ikia kara á ifunusapo. ");
INSERT INTO faa_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ifunusakipoko Yasu peraka aporo hinamo metakira fanaraka, metakira kesekeraka ayiáka pesapo. Ipu wárape peraka, “Tefetemo aporo ira wainepe pesa aporo né kárapo. Unihae Kotimo né pusierakano pesane, Kotimo makoterakanapo. Né namo kakaro fanaraka rekenapo.” Aíyaka ipu Yasuane kekeresapo. ");
INSERT INTO faa_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kekereraka i su Yarusarame sitia wárape perakano aporo hinamo á risiamo asekea himu faraka someraka, “Aporo aperane epare?” ");
INSERT INTO faa_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Airakano aporo hinamo yakaimo someraka, “Aporo aperane porofete aporopo. Kotimo some kará aporo Yasupo. Kariri hauaka Nasare apea reane epo.” Aiyaka aporo hinamo yakaimo Yasuane kekeresapo. ");
INSERT INTO faa_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kotimo ape makeraka, rurusa tua Yasu yorokoa puraka aseane, aporomo makata roporaka risikino asekea, i suane Yasumo rukuhoaeraka pusiesapo. Arirakano aporo metakiramo teporoa mone taeraka sanasiraka risiakipoko, Yasu peraka ipu teporo suane maparitaesapo. Arirakano mena nume asia roporaka risia aporoamo sea ane soko Yasumo maparitaesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Maparitaeraka iaki Yasumo someraka, “Kotimo sawia Kotimo somesane porofete aporomo popasane oyapo. Nōmo apeane aporo hinamomo someraka, ‘Kotimo apeane Kotiaki wára kurikuri apepo,’ airapo. Aira nine Kotimo ape one repo hakimora aporomo kunikia pariraka amarere.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kotimo apea Yasu reakipoko aporo hinamo hi fausa soko, korake matipusa soko, perakano Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Arirakano hokosa fetemo Yasuaki kekereraka wáraka, “Tefetemo aporo ira wainepe pesa aporo, né kárapo,” aíyaka wásapo. Wárakano kaikia pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko mahisiraka sapesapo. Arirakano Kotimo wakapumo hemakapukua rakirane Yasumo rakirakano asekea ipu mahisiraka sapesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Saperaka Yasuaki ipu kairaka, “Hokosa fetemo wárakane nómo kairakarire?” Airakano Yasumo someraka, “Ao, nōmo kairakaripo. Hokosa fetemo wárakane Kotimo sawia popasane repo menosafare? Kotimo sawia popasane oyapo. ‘Hokosa fete suamo anoaki seseraka kekerehoasimo, sesenane iaki Kotimo kakakosapo.’ Aíyaka popasapo.” ");
INSERT INTO faa_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Aíyaka Yasumo someraka faraka aporo hinamo Kotimo apea sarimasane soko, Yarusarame sitiane soko, epo metakarikia pukua Petene apea wasápo. ");
INSERT INTO faa_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mituru Yasu Yarusarame sitia hinaka meamosapo. ");
INSERT INTO faa_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Meamorakano ira foke ikia kara rekeno, foke wate nakosakipoko tumako peraka, aseane ira foke namo ku susu rekeno asesapo. Asekea Yasumo someraka, “Ira foke one watē efera hunia peakosafapo.” Aihora yiamo ira fokeane wate foaka porasapo. ");
INSERT INTO faa_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Porarakano aporo hakāsa puramo asekea fofaraka someraka, “Ira fokeane mayiáka wáte foaka porarakanare?” ");
INSERT INTO faa_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Airakano Yasumo someraka, “Nōmo reaki some one kakaro somerakaripo. Repo himu tetáraka hemakapukua risikianafonoraka Kotiaki himu hakásaraka hemakapukua risikianie. Ayiáka risikino, nōmo ira fokeaki somesa ayiáka repo ira fokeaki soko, ūriaki soko, ayiáka somerakano ayiakakosapo. Repo ūri aseraka someraka, ‘Ūri ne takahikia he tawara sokoperasie.’ Airakano ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Asiamo repo Kotiaki himu hakásaraka hemakapukua risike, makata metapoko hemakapukua Kotiaki kurikurirakano Kotimo ayiáka rakiakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Kotimo ape rurusa tua Yasu yorokoa pukua some karaka rea maiya amo pirisiti aporo káramo soko, Yu aporo sisimamo soko, e rea pekea someraka, “Nómo arakirane epamo maresare? Neaki epamo ayiáka rakinie aisare?” ");
INSERT INTO faa_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Airakano Yasumo iaki someraka, “Nōmo soko, reaki makata hakása meta akai kairakanapo. Kaiyiáne repo anoaki some pariperakano, kaikia anoaki rakiniesane nōmo reaki somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yonemo aporo hinamo hea tapukumurianiesane epamo ayiakaniesare? Kotimo ayiakaniesare? Aporomo ayiakaniesare? Repo anoaki somesie.” Airakano aporo ipu namina susu tafatafaraka someraka, “Isiapo Yasuaki yakapa somehoanarakapo. Isiapo someraka, ‘Kotimo ayiakaniesapo,’ aíyaka somerakanone, Yasumo isuaki someraka, ‘Marirakano Yonemo someane kakipayasare?’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Arirakano isiapo someraka, ‘Aporomo ayiakaniesapo,’ aiyaka somerakanone, aporo hinamo suamo isuaki mahisiraka sapehokosapo. Asiamo aporo hinamo suamo hemakapuraka, ‘Yone ipi porofete aporopo. Ipi Kotimo some kará aporopo.’ Aíyaka ipu hemakapusuasamo iaki namorakanapo. Asiamo aporo hinamo suamo isuaki sapehokohoamo isiapo Yasuaki some paripukusafapo.” ");
INSERT INTO faa_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Aíyaka namina tafatafaraka Yasuaki someraka, “Yonemo aporo hinamo hea tapukumurianiesane epamo ayiakaniesarakapo. Isu himeteripo.” Airakano Yasumo someraka, “Repo anoaki some paripeanafonosasamo anoaki rakiniesa kepoane nōmo reaki somerakanafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Pirisiti aporo kára soko, Yu aporo sisima soko risiaki Yasumo takumeaka someraka, “Aporo hakásamo aporo hokosa tetá reapo. Asiamo hokosa fanaki wafayamo someraka, ‘Hokosao, pipu ne sako karepe hemoa makata rakiako pusie.’ ");
INSERT INTO faa_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Airakano hokosa amo someraka, ‘Ano hisiripo. Pukusafapo.’ Aisa nine keseke ipi hemakapuraka, ‘Nōmo fana hisisane metakarikia, efera makata rakiako pukusapo,’ Aíyaka hemakapukua rekeako parisapo. ");
INSERT INTO faa_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Arirakano hokosa kesekeaki wafayamo someraka, ‘Hokosao, pipu ne sako karepe hemoa makata rakiako pusie.’ Airakano hokosa amo someraka, ‘Ao, ano pukusapo.’ Aisa nine e pusuafapo.” ");
INSERT INTO faa_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Aíyaka Yasumo iaki akai kairaka, “Hokosa meta mamo ipi wafayamo someane kakimasare? Repo mayiáka hemakapurakanare?” Airakano ipu someraka, “Hokosa fanamo kakimasapo.” Airakano Yasumo iaki someraka, “Some one kakaroripo. Koti unihaeaka rea paonane, takese mora aporo soko, aporo rea pura hinamo soko fana paorakanapo. Re kesekenapo. ");
INSERT INTO faa_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Asiamo re ereketaeraka risikiasimo, Yonemo reaki some karakano repo kakimasafapo. Arirakano takese mora aporomo soko, aporo rea pura hinamomo soko kakimasapo. Kakimaka risikino repo aseraka yia, Yonemo someane repo kakimakosakipoko asiāne himu hakásaraka hemakapukua risikisufapo.” Aiyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yasumo pirisiti aporo káraki soko, aporo sisimaki soko, someraka, “Kaisie. Nōmo reaki takume meta somerakanapo. Hemo wafayamo sako karepe hemoa porokoa rurusapo. Rurusa tua sako wate nenekeaneraka he pusimo eke karoraka maua asia rakisiapo. Arirakano aporomo hemoane koteaka asekea rekeasimo huturu ape kisiapo. Kikimarekea hemoane aporo metakiramo asekea risikasimo epo murikimasapo. Murikimaka faraka hemo wafayamo ipi hemoane metakarikia hauaka meta á pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Pusuakipoko sako karepe wateane ikia ahera maiya amo, hemo asekea risia aporomo sako karepe wateane parakuraka, metakira hemo wafayaki kakasimo, hemo wafayamo aporo raipa metakiraki mokoako pusiesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pusiesane hemoa perakano hemo asekea risia aporomo aporo raipa metane ira faimo rukua, anakano aporo raipa metane namo kakaro rusua kukua, anakano aporo raipa metane ekemo karekea asiapo. ");
INSERT INTO faa_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Arirakano fana hemo wafayamo aporo raipaki sako wate mokoako pusiesane aporo hukusipo. Efera hunia mokoako pusiesane aporo yakai pusiesapo. Pusierakano pusuane aporo fana pusiesane hemo asekea risia aporomo mokoatikisa ayiáka, aporo kesekea pusiesane soko, ayiáka mokoatikisapo. ");
INSERT INTO faa_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Arirakano keseke hemo wafayamo hemakapuraka, ‘Hemo asekea risia aporomo nōmo hokosane mokoatikihokosafapo. Eane ipu hemakapukua makotehokosapo.’ Aíyaka hemakapukua reasasamo hemo wafayamo ipi hokosane pusiesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pusiesane hemoa perakano aseraka, hemo asekea risia aporomo namina susu someraka, ‘Hemo wafayamo hokosa apere. Asiamo keseke ipi wafayane kusuakipoko finihaoa e reke, hemo one epo asekea rekeasireapo. Anapaka isiapo eane rukusapo. Rusua kurakano hemo one isiapo isina wafayaraka asekea risikiakosapo.’ ");
INSERT INTO faa_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Aíyaka hokosane waseremaka ruru tapikia tama takua makasuraka rusua kusuapo.” Aiyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Aíyaka someraka faraka epo aporo suaki akai kairaka, “Hemo wafaya perakano hemo asekea risia aporoane mayiakakosare?” ");
INSERT INTO faa_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Airakano aporo suamo Yasuaki someraka, “Hemo wafayamo hemo asekea risia aporo watikisane kakaro mokoatikiraka rusua kukusapo. Rusua kurakano, aporo metakiramo hemoane koteaka asekea risikiasimo muriakosapo. Murisiamo sako karepe wate ikia aheramo sako wate mokoa hemo wafayaki kakakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Airakano iaki Yasumo someraka, “Some one Kotimo sawia popasane repo menosafare? Kotimo sawia popasane oyapo. ‘Ape kira aporomo ira warupi mamakatesane aporo metamo maka pekea tipia mapohoareapo. Mapohoareane Kotimo ipi ayiáka rakireapo. Ayiáka rakisikeno isiapo aseraka, “Ane kotehoareapo,” airapo.’ Aíyaka Kotimo sawia popahoareapo. ");
INSERT INTO faa_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Asiamo nōmo reaki kakaro somerakaripo. Koti unihaeka asekea reane Yu aporomo hisisasamo Kotimo iane metakariakosapo. Metakarirakano aporo hinamo suamo Kotiaki himu hakásaraka hemakapukua risikiakosane Kotimo unihaeaka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Asiamo ira warupia aporo hinamo metakira terafaka ruraka kakaro etehokosapo. Arirakano ira warupi maposane huruperaka ruraka kakaro rukutaihokosapo.” Aíyaka Yasumo ipi yine ira warupi ayiáka takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Arirakano pirisiti aporo káramo soko Ferese aporomo soko Yasumo takumeaka somerakano kairaka hemakapuraka, “Yasumo someraka ane isuane somerakae.” ");
INSERT INTO faa_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Aíyaka hemakapuraka Yasu waseremakosapoko asiāne metakarisiapo. Asiamo aporo hinamo suamo hemakapuraka, “Yasu porofete aporo Kotimo some kará apororeapo.” Aíyaka hemakapusuasamo ipu Yasu waseremayane, aporo hinamo suamo iaki mahisiraka sapenapaka metakarisiapo. ");
INSERT INTO faa_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yasumo aporoaki efera hunia takumeaka someraka, ");
INSERT INTO faa_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kotimo unihaeaka asekea rea asíane oyapo. Aporo unihaeaka reamo ipi hokosamo hinamo arumara maiya amo hokono keakosakipoko, makata nakosa sarimaraka taesapo. ");
INSERT INTO faa_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Taeraka aporo fana murikimasaki yumo peaniehoko, pusie aíyaka ipi aporo raipaki somesapo. Somerakano i pukua, aporo fana murikimasaki peaesapo. Peaehoane aporoane namina hisiraka pesafapo. ");
INSERT INTO faa_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Peanafonorakano asekea, aporo unihaemo aporo raipa metakiraki someraka, ‘Aporo peaesaki efera hunia someraka, “Yumo peae. Makata nakosa su sarimaraka taesapo. Saro ponomakau soko, saro ponomakau mano kaniamo soko rukua taeraka, makata su sarimaraka taesapo.” Aíyaka somehoko pusie.’ ");
INSERT INTO faa_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Airakano aporo raipa pukua peaehoane, aporo peaesa amo kakipayaraka, aporo metamo ipi hemoa rakiako pukua, arirakano aporo metamo ipi pisinisi rakiako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Arirakano aporo peaesa metakiramo aporo raipane waseremokoa mokoatikiraka rusua kusuapo. ");
INSERT INTO faa_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Rusua kurakano aporo unihaemo kaikia saperaka ipi ame aporoaki peaesapo. Perakano asekea aporo unihaemo iaki someraka, ‘Aporo rusua kusua aporoane kukusimo runie. Ipu apeane soko inakasimo paiyinie.’ Airakano aporo unihaemo ame aporo puraka aporo unihaemo somesa hakása nine ipu ásiapo. ");
INSERT INTO faa_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Arirakano aporo raipa metakiraki aporo unihaemo someraka, ‘Makata nako makata su sarimasapo. Sarimaraka aporo peaesane i watikiaka risike i siaraka risikianafonosasamo, iane nōmo metakarirakanapo. ");
INSERT INTO faa_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Asiasamo re pukua ikia akoa aporo hinamo metakira soko perakano aseraka hokono akera peaehoanie.’ ");
INSERT INTO faa_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Airakano aporo raipa ikia akoa puraka, aporo hinamo su watikisa soko, kotesa soko, aseraka peaesapo. Peaeraka karikia pekea, makata pakinakosa apea yorokoa sarimahoane apeane tapesapo. ");
INSERT INTO faa_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ape taperakano aporo hinamo apea kesane, aporo unihaemo aseako pesapo. Pekea aseane hinamo aruamara a sarimaraka, aporo hinamo suamo hinamo arumara pasu kotesa osoraka, aporo hakása meta hinamo arumara pasu kotesane osohoanafonosekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Aseraka aporoaki aporo unihaemo someraka, ‘Ne hinamo arumara pasu kotesa metakarikia osohoafareapo. Ne kaíyanafaraka, manakano mapiraraka pesare?’ Airakano aporoane me kauraka reapo. ");
INSERT INTO faa_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Asiamo aporo raipaki aporo unihaemo someraka, ‘Aporoane korakea soko hokonoa soko taporaka katosa hauaka takua makasuhoanie. Arirakano katosa hauaka á aporo hinamo arisiamo hiripuraka saperaka akai kikitihokosapo,’ aisapo. ");
INSERT INTO faa_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Hao, kaisie. Aporo hinamo yakai peaesa nine aporo hinamo hukusiane takekea pasimorakanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ferese aporomo sarimaraka someraka, “Yasumo hasaka somehoasimo isiapo e makosakipoko isu mahoperape pukua, úyaka somehokosapo.” Aíyaka ipu tau me rukua someaka masapo. ");
INSERT INTO faa_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Me rukua someaka maka faraka, Ferese aporo metakira soko Heroteaki patera asesa aporo metakira soko, Yasu rea pusie, aisapo. Airakano pukua Yasu rea pekea, Yasuaki ipu someraka, “Tisao, nómo someane namo kakaro somerakae, aíyaka isiapo hemakapurakaripo. Aporo koteaka risikiasimo kakaro Kotimo ainane nómo some karakarakae. Aporomo neaki mokoatikihokosane nómo hemakapurafaraka kakaro somerakae. Aporo kárane sesehoasimo nómo some karakarifapo. ");
INSERT INTO faa_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Asiamo isiapo neaki makata hakása kairakanapo. Isiapo Yu aporomo Rome aporo unihaeaki takese mone kayane siahoasirare? Kayane Kotimo somemaneane mamosohoasireare?” ");
INSERT INTO faa_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Airakano ipu yapake someane Yasumo kaisiapo. Arirakano ipu Yasu mokoatikihokosakipoko mahoperape pesane Yasumo aseraka, iaki someraka, “Re aporo himu tetáraka arisie. Nōmo hasaka somerakano nōmo nī some yiamo kakinumo maká arura ayiáka, ano nīane rusimo repo aíyaka somerakae. ");
INSERT INTO faa_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takese mone hae motoakosane nōmo aseako maka peae.” Airakano mone hae maka perakano asekea ");
INSERT INTO faa_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yasumo someraka, “Epa hikumisi mone haea rekerire? Epa yano motosa popahoareare?” Airakano ipu someraka, “Rome aporo unihae Sisa hikumisireapo. Ipi yano motosa popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Airakano Yasumo someraka, “Rome aporo unihaemo menane ipiaki kakanie. Kotimo menane Koti ipiaki kakanie.” ");
INSERT INTO faa_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Airakano ipu kaikia fofaraka Yasu metakarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sereamo Yasu rea Satusi aporo peraka, Yasuaki makata akai kaiyako pesapo. Arirakano ipu hemakapusuane aporo kusua ipi kauyaki hoyaki kakaro kusuane maturikia taenafapo. Aíyaka hemakapukua ipu Yasuaki someraka, ");
INSERT INTO faa_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tisao, Mosesemo somesane oyapo. ‘Aporomo hokosa hokono mareanafonoraka kurakano, epo hinamo yaroane ipi mamaneamo arumarapo. Aporo kusua amo hokosa wainenaka sikiraka wainasimo, hinamo yaroane ipi mamaneamo arumarapo.’ Aíyaka Mosesemo somesesupo. ");
INSERT INTO faa_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Asiamo hauaka wo mamanea yatipinusu risiapo. Mamanea fanamo hinamo arumasane hokosa hokono mareanafonoraka kurakano, ");
INSERT INTO faa_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","mamanea kusuamo patera yiamo hinamo yaroane arumasapo. Epo hokosa hokono mareanafonoraka e soko kusuapo. Kurakano epo patera yiamo hinamo yaroane arumasapo. Arumasane epo hokosa hokono mareanafonoraka kurakano, ayipe pukua mamanea yatipinu suamo hinamo yaro hakásane arumaraka hokosa hokono maresafapo. ");
INSERT INTO faa_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Keseke hinamo manokonomasane kusuapo. ");
INSERT INTO faa_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kusuane maturikia taeana maiya amo hinamoane epamo hinamore? Eane aporo yatipinusumo arumasapo.” ");
INSERT INTO faa_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Airakano Yasumo someraka, “Kotimo some sawia popasane soko, Kotimo wakapuane soko repo himeteraka hasaka hemaka apure. ");
INSERT INTO faa_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aporo kusua maturikia taerakano, hepene aporo arisia ayiáka risikiakosapo. Ayiáka arisia maiya amo aporo kusua maturikia taesamo hinamo kusua maturikia taesane arumarafapo. ");
INSERT INTO faa_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Arirakano aporo kusua maturikia taena amo kepoane nōmo reaki somerakanapo. ");
INSERT INTO faa_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Kotimo sawia popasane Kotimo someraka, ‘Eparahamemo Kotiane anopo. Aisakemo Kotiane soko anopo. Yakopemo Kotiane soko anopo.’ Aíyaka popasane repo menoraka kepoane re himeteane. Kepoane oyapo. Kotiane aporo kusua maturikia taeraka hitafe arisiamo Kotipo. Eparahame soko Aisake soko Yakope soko kakaro kukua hitaferaka risikianafonorakanone, ‘Ipu Kotiane anopo,’ aíyaka Kotimo aihoafunufareapo.” ");
INSERT INTO faa_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Aíyaka Yasumo somerakano aporo yakaimo kairaka himu faraka fofasapo. ");
INSERT INTO faa_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Satusi aporomo somesane, Yasumo someamo hurutapikia somesapo. Somerakano ipu kaikia me kauraka risiapo. Me kauraka risikino asekea, Ferese aporomo sarimaraka someraka, “Isiapo mayiáka Yasu hurutapiakosare?” Aíyaka me rusuapo. ");
INSERT INTO faa_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Me rukua faraka, ipu aporo hakása somemane kaira aporoamo, Yasumo hasaka somehoasimo mahoperaka someraka, ");
INSERT INTO faa_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tisao, Kotimo somemane meta mane fanare?” ");
INSERT INTO faa_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Airakano Yasumo someraka, “Koti ane nómo unihaepo. Unihaeaki nómo himu tumurumo hemakapunie. Nómo homo soko eaki hemakapunie. Nómo himu hemakapuramo soko eaki hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ane somemane namo kakaro fanapo. ");
INSERT INTO faa_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Arirakano somemane metāne soko hakása yinesane oyapo. Nómo níane himu tumurumo hemaka apura ayiáka nómo aporo tákeane ayiáka himu tumurumo hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Asiamo somemane tetáne nōmo reaki somerakane porofete aporomo somesane soko, Mosesemo somemane popasane soko kepoane hakása yiyapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ferese aporo sarimaraka risia maiya amo, Yasumo iaki makata akai kairaka, ");
INSERT INTO faa_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Keresoane repo mayiáka hemakapurakarire? Epamo wainepe pekea Keresoane faserepeakosare?” Airakano ipu someraka, “Tefetemo wainepe pesa aporo ira á Keresoane faserepeakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Airakano Yasumo someraka, “Keresoaki Tefetemo someraka, ‘Nōmo Unihaepo.’ Aíyaka Ho Kotesamo tarirakano somesapo. Somesane wate fana Kotimo sawia popasane oyapo. ");
INSERT INTO faa_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Tefetemo someraka, ‘Nōmo Unihaeaki, Unihae Kotimo someraka, “Ne ano hokono tumuru takua kayae. Hokono tumuru takua aporo hokopusua akaya ayiáka kayae. Kakeno nómo yunuane nōmo rukumosakatapiakosapo,” aisapo.’ Aíyaka Kotimo somesane Tefetemo popahoareapo. ");
INSERT INTO faa_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Asiamo Tefetemo Keresoaki ‘Ne nōmo Unihaepo,’ aisane marirakano aisare? Arirakano makasa kauamo ipi hokosa wainepe pukusaki Unihaepo, airafapo. Asiamo Tefetemo Keresoaki Unihaepo, aisasamo, Tetefe takapeasiraka keresoane wate fana yaiya reapo. Asiāne repo someraka, ‘Tefetemo wainepe pesa á Kereso faserepeakosapo,’ airakae.” ");
INSERT INTO faa_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Airakano ipu kaikia some paripesafapo. Maiya amo aporo hakása metamo Yasuaki efera hunia makata akai kaisiafapo. Ipu someane Yasumo hurutapirakano asekea ipu makata meta efera hunia akai kaisiafapo. ");
INSERT INTO faa_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sereamo aporo hinamo yakai sarimasaki soko ipi aporo hakāsa puraki soko Yasumo someraka, ");
INSERT INTO faa_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Somemane Mosesemo some kasane Kotimo somemane tisa aporomo soko Ferese aporomo soko some kepoane some karápo. Some karáka tisa aporomo wakapuaka some akara ayiáka, ipu ayiáka some karápo. ");
INSERT INTO faa_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ipu some akarane repo kakimakanie. Asiamo i arisia ayiáka re risikiakopo. Asiamo ipu aporo metakiraki some karakano yia someane ipu namina kekemaraka rakirafapo. ");
INSERT INTO faa_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Aporo metakiramo makata fato umisa makatihoasimo ipu taporaka aporoamo kinua makatiraka marerapo. Makatiraka marekea ipu wakasema soko ararenafapo. ");
INSERT INTO faa_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ararenafaraka namina yiamo aporomo asekeasimo mafekemaraka rakirapo. Asiamo Kotimo some sawia, popasane weroraka hokonoa soko taporaka, hikumisia soko taeraka, wakasema popake tumuraka taenapo. Arirakano ipu pasu ososane, pasu ke huhu hohoroposa osonapo. ");
INSERT INTO faa_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ipu makata sesenane oyapo. Hokono akera maiya amo aporomo i makáraraka hokopusuamo sea i tokoako seane iaki tarisimo sesenapo. Arirakano Yu aporomo sarimana apea pukua aporo hinamo su sarimaraka toakipoko, i kumisi neneme sapea sea tokoako sesenapo. ");
INSERT INTO faa_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Arirakano aporo hinamo sarimaraka risiakipoko i purakano, aporomo i hokono mokoasimo sesenapo. Hokono moraka iaki makáraraka someraka, ‘Tisao,’ aihoasimo Ferese aporomo kára sesenapo. ");
INSERT INTO faa_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Arirakano aporo metamo reane makáraraka someraka, ‘Tisao,’ aihoasimo rakiakopo. Asiamo repo tisane ano hákasapo. Re su kakimara aporo hinamo hakása yineraka risikinapo. ");
INSERT INTO faa_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Isiapo Ata Koti hákasa hepene yapura rekenapo. Asiasamo hauaka wo aporo meta makáraraka repo Ata Koti area ayiáka rekeasimo makárahokopo. ");
INSERT INTO faa_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aporo metamo reane makáraraka someraka, ‘Unihaeo,’ aihoasimo rakiakopo. Repo unihae hakása rekenapo. Eane Keresopo. Kotimo eane unihaeaka rekeasimo murikimasapo. ");
INSERT INTO faa_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Arirakano re namina aporo meta fanaraka reke aporoamo aporo wakasemamo arakira ayiáka aporo supoko arareraka rakinie. ");
INSERT INTO faa_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Asiamo aporomo e ipiane makárarakano aporoane Kotimo mawakasemahokosapo. Arirakano aporomo ipiane mawakasemarakano aporoane Kotimo makárahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yasumo someraka, “Kotimo somemane tisa aporo re soko, Ferese aporo re soko enahoasifareapo. Re asekeanie. Re su aporo himu tetaraka arisie. Aporo hinamo Koti unihaeaka asekea rea paohokohoamo iane repo matasonapo. Asiamo re Koti unihaeaka asekea rea paohoanafonoraka hisiraka risikinapo. Aporo hinamo metakira Kotiaki paohoko sesesane repo matasoraka risikinapo. ");
INSERT INTO faa_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kotimo somemane tisa aporo re soko, Ferese aporo re soko enahoasifareapo. Re asekeanie. Re su aporo himu tetaraka arisie. Repo hinamo yaromo ape soko, makata kemo soko hakimorapo. Hakimoraka yia, Kotiaki kurikuriana maiya amo some nokone pukua kurikurinapo. Aporomo aseraka, ‘E kotehoareapo,’ aihoasimo aíyaka kurikurinapo. Ana akipoko re fanasihokosane kárahokosapo. ");
INSERT INTO faa_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kotimo somemane tisa aporo re soko, Ferese aporo re soko enahoasifareapo. Re asekeanie. Re su aporo himu tetaraka arisie. Ferese aporohoanafonosa hakása Ferese aporohoasimo repo pasimako kimisi kára purapo. Pukua hauaka kára koraka nina, hea soko yaoraka ayiáka koraka risirapo. Koraka risike aporo hakása pasimarakano, aporoane Ferese aporo pariraka, aporoane repo yiamo heao hauaka pusierakanapo. Asiamo aporoamo watikiaka rakirakano, ipi watikiaka arakiramo repo watikisane marokehokosapo. Asiamo aporoamo watikiaka rakisimo, tarira kepoane repo. ");
INSERT INTO faa_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Aporo hi taku tetákara fausamo aporo metakiraki ikia kara atarira ayiáka repo ayiáka atarire. Re asekeanie. Aporo reo, enahoasifareapo. Repo someraka, ‘Aporomo aumaraka someraka, “Kotimo apepo.” Aíyaka yano hokoa ipi aumaraka somesane metakariane sihoasireapo. Arirakano Kotimo apea koróto taesane aporomo aumaraka someraka, “Korótopo.” Aíyaka yano hokoa ipi aumaraka somesane parosa yaiya kakakosapo.’ Aíyaka repo somerapo. ");
INSERT INTO faa_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Aporo hi taku tetákara fausane himu maparitaesa arisia ayiáka, re ayiáka risikinapo. Asiamo meta mane fanare? Koróto fanare? Kotimo ape fanare? Asiamo koróto Kotimo apea taesasamo Kotimo apeane namo kakaro kotesapo. ");
INSERT INTO faa_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Arirakano repo someraka, ‘Aporomo aumaraka someraka, “Eke karoraka taesapo.” Aíyaka yano hokoa ipi aumaraka somesane metakariane siahoasireapo. Arirakano eke karosa kima Kotiaki makata yaku kakakosakipoko taesane, aporomo aumaraka someraka, “Makata taesa ayapo.” Aíyaka yano hokoa ipi aumaraka somesane parosa yaiya kakakosapo.’ Aíyaka repo somerapo. ");
INSERT INTO faa_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Aporo hi taku tetákara fausane himu maparitaesa arisia ayiáka re ayiáka risikinapo. Asiamo meta mane fanare? Eke karosa kima Kotiaki makata yaku kakakosakipoko makata taesane fanare? Ekeane fanare? Asiamo eke taehoanafonosa Kotiaki makata yaku kakakosane mayiáka paiyakosare? Paiyanafonoraka mayiáka Kotiaki kakakosare? Pairakano makata yakuane haku kotesa susu parihokosapo. Kotesa susu parihokosasamo ekeane fanare? ");
INSERT INTO faa_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Asiamo aporomo aumaraka someraka, ‘Eke karoraka taesapo.’ Aíyaka someraka eke karoraka taesane soko, eke karosa kima makata taesane soko, suane aumarapo. ");
INSERT INTO faa_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Arirakano aporomo aumaraka someraka, ‘Kotimo apepo.’ Aíyaka aumaraka somerakano, Kotimo apeane soko, Kotimo apea makata risiane soko, aumarapo. ");
INSERT INTO faa_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Arirakano aporomo aumaraka someraka, ‘Hepene yapura ayapo.’ Aíyaka somerakano Koti unihaeaka rea amo sea ane aumaraka, Koti ipiane sea á kayasamo Kotiane soko aumarakanapo. ");
INSERT INTO faa_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kotimo somemane tisa aporo re soko, Ferese aporo re soko enahoasifareapo. Re asekeanie. Re su aporo himu tetaraka arisie. Repo sereto asia kaeyako su mosane, tokonasu namina moraka, kaeyako hakásane Kotiaki karápo. Makata wakasemane repo karakayia, somemane kára metakira kakipayanapo. Koteaka takekea hemakapuniesane repo hemakapurafapo. Aporo meta kamenakaraka hemakapuniesane repo hemakapurafapo. Kotiaki himu hakásaraka hemakapuniesane soko, repo ayiáka hemakapurafapo. Asiamo makata kaeyako hakása Kotiaki karáne soko, somemane metakira kakipayasane soko, su kakimakafunureapo. ");
INSERT INTO faa_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Aporo hi taku tetákara fausamo aporo metakiraki ikia kara atarira ayiáka repo tarirakanapo. Re risiane uyáka risikinapo. He nakosa saro inini huruperakano makata wakasemane repo maka mamakatenapo. Mamakateraka yia repo saro kamo asia kára ane neketurapo. ");
INSERT INTO faa_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kotimo somemane tisa aporo re soko, Ferese aporo re soko enahoasifareapo. Re asekeanie. Re su aporo himu tetaraka arisie. Repo kapo soko, meraki soko, kima takua hákasa kusuraka, kakarua kusuhoanafonona ayiáka reane asiapo. Re kaumo siaraka risikiako ayiane, re himua makata watikisa komarukua risike ayiane. Ayiáka risike repo makata hakimokoako, hemakapukua arirakano repo namina hemakapusuane soko, kekemaraka ayiáka re risikinapo. ");
INSERT INTO faa_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ferese aporo re, aporo hi taku tetákara fausa arisia ayiáka risikinapo. Kapo kakaruane soko, meraki tuane soko, fana kusuhoanie. Kakaruane kusuraka faraka, kima takuane soko kotehokosapo. Aina ayiáka repo himu hemakapurane fana makotehoanie. Makoterakano re sia koteaka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kotimo somemane tisa aporo re soko, Ferese aporo re soko enahoasifareapo. Re asekeanie. Re su aporo himu tetaraka arisie. Aporo kusua hauaka murisiane kima yapura pene pakaesamo pairapo. Paisiane kima yapura kotesa nine, tamo atura aporo kusua toresa kikiane tokenapo. Aina ayiáka re ayiáka risikinapo. ");
INSERT INTO faa_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Arirakano aporomo re aseraka hemakapuraka, ‘I aporo kotesapo.’ Aíyaka hemakapusua nine, re himu tetáraka hemakapurane soko himu watikisane soko risikinapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Yasumo efera hunia someraka, “Kotimo somemane tisa aporo re soko, Ferese aporo re soko enahoasifareapo. Re asekeanie. Re su aporo himu tetaraka arisie. Kotimo some kará porofete aporo soko, Kotiaki hemakapukua risira aporoane soko, rusua kusua hauaka murisiane repo rakikia makotenapo. ");
INSERT INTO faa_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Makoteraka repo someraka, ‘Isiapo makasa kaua kekema risia maiya amo, isu risiasa satiki, makasa kaua kekema arareraka, Kotimo some kará porofete aporoane rufunufapo.’ Aíyaka repo somerapo. ");
INSERT INTO faa_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Repo namina kepoane hufitaeraka somerakae. Repo makasa kaua kekemamo Kotimo some kará porofete aporoane rusua kusuapo. Arirakano makasa kaua kekema hakasamo wainepe pesane repo. Repo ainane soko hakása yiyapo. ");
INSERT INTO faa_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Asiamo repo makasa kaua kekemamo ayiakanafonosane repo ayiakanie. ");
INSERT INTO faa_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Re heseke ayireapo. Repo makasa kaua kekema heseke asía amo wainepe pesane pesasamo re soko, heseke ayireapo. Heao hauaka á re pusiehokosane mayiáka metakariakosare? Metakariakosafapo. ");
INSERT INTO faa_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Asiamo repo kaiyisimo Kotimo some kará porofete aporomo soko, koteaka hemakapukua takekea somera aporomo soko, Kotimo somemane tisa aporomo soko some kakako nōmo pusiehokosapo. Perakano repo aporo metakira ira matopesa paremarekea rusua kukusapo. Aporo metakira Yu aporomo sarimana apea sako patesamo rukusapo. Rukua mokoatikirakano aporoane teketarikia pukusapo. Pukua ape meta pukua, apea soko mokoatikirakano, teketarikia pukua, ape meta ayiáka teketarikia koraka tokoakosapo. ");
INSERT INTO faa_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Asiamo Kotiaki hemakapukua rea aporo, Aepo fana rusua kusuakipoko, amo patera aporo metakira soko rusua kusuapo. Keseke Perekayamo maeya Sekaráya Kotimo apea rusua kusuapo. Eke karosa taesane makama taku raraka Kotipoko ape rumu kikisisane makama taku roraka tipia reane e rusua kusuapo. Asiamo repo makasa kaua kekemamo watikiaka hemakapukua rakisia ayiáka, repo soko watikiaka rakiako hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nōmo reaki kakaro somerakaripo. Aporo su koteaka risiane rusua kusuasamo, aporo hinamo maiya omo risiane Kotimo fanasihokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Yasumo someraka, “Yarusarame aporo hinamo reo, repo Kotimo some kará porofete aporoane rusua kurakasupo. Kotimo pusiesa aporoane repo ekemo karerakasupo. Yarusarame aporo hinamo reo, mena kaīyiamo mena mano sarimaraka auamo mafainapo. Aina ayiáka efera hunia soko, efera hunia soko, nōmo re sarimaraka ayiakakosapoko asiane, repo anoaki hisisapo. ");
INSERT INTO faa_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Hao, kaisie. Yarusarame aporo hinamo reo, repo ape kamaka risikiakosapo. Apea aporo hinamo waka risikiakosafapo. ");
INSERT INTO faa_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nōmo reaki kakaro somerakaripo. Repo ano efera hunia aseakosafapo. Arirakano keseke repo someraka, ‘Kotimo pusiesa aporo aperane Kotimo makotehoasimoripo,’ aíyaka somerakano maiya amo repo ano aseakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yasumo Kotimo apeane metakarikia purakano, ipi aporo hakāsa puramo Kotimo apeane somehokosakipoko Yasuaki tarisiapo. ");
INSERT INTO faa_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tarirakano Yasumo someraka, “Kotimo apeane repo aserakarire? Hao, kaisie. Nōmo reaki kakaro somerakaripo. Apeane eke ripaka kisiane ekeane ipu kokoromokotesa hakása hakásaraka tokoakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Yasu ūri Orofea hikia kayakipoko ipi aporo hakāsa pura pekea, namina hakāsa toke Yasuaki akai kairaka, “Masinaka Kotimo eke apeane kokorotaehokosare? Arirakano ne paripeakosane makata yakapamo isuaki tariakosare? Arirakano maiya fahokosane makata yakapamo tariakosare?” ");
INSERT INTO faa_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Airakano Yasumo someraka, “Aporo metamo reaki kotafe somerakano someane kakimarapaka asekeanie. ");
INSERT INTO faa_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aporo yakai peakosapo. Pekea ipu kotafe someraka, ‘Ano Keresopo. Unihae makárasane anopo.’ Aíyaka ano yano hokoa kotafe somerakano, someane aporo hinamo yakaimo kakimakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aporo metakiramo aporo metakirayaki werakanaporakano, repo kaiyakosapo. Arirakano aporo metakiramo aporo metakirayaki werakanapo, aíyaka kotafe tokomako pukua somerakano, repo kaiyakosapo. Repo kairaka himu fahokopo. Aporomo weakosane fana faserepeakosapo. Arirakano fahokosa maiyane haru faserepeakosafapo. ");
INSERT INTO faa_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Arirakano aporo hauaka metamo aporo hauaka metayaki wekea, arirakano kamani metamo kamani metayaki werakano ayiakakosapo. Arirakano hauaka kekepoa makata nakosa farakano aporo hinamo kára meamohokosapo. Arirakano hauaka kekepoa momani yakai peakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Asiamo hinamo ipi himura hokosa kayane takapeakosakipoko kára mokoweraka mati tuaka pukua aina ayiáka momani perakano soko, makata nakosa farakano soko, yunu werakano soko, makata umisane kepomareraka ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Maiya amo aporo watikisamo re mokoatikihoasimo waseremokoa karikia pukusapo. Karikia pukua re rusua kukusapo. Re ano patera asesakipoko aporomano hauaka sua risiamo reaki hisihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Hisirakano ano patera asesa aporo hinamo yakaimo ano metakarikia poparitariakosapo. Poparitarikia metakiramo metakira parakehokosapo. I namina yia, metamo metaki hisi, arirakano metamo metaki hisi ayiáka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Arirakano kotafe some kará porofete aporo yakai fasereperaka some karakano, aporo hinamo metakiramo kotafe someane kakimakosapo. Kakimaka hasaka hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Arirakano aporo hinamomo watikiaka rakirane kárahokosapo. Káraraka anoaki patera asesa aporo hinamo yakaimo himu hakásaraka hemakapukua sesenane fahokosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Arirakano aporo hinamo Kotiaki patera asesane metakarirafaraka, yaiya hemakapukua risike, rakipe pukua rosaka taerakano, aporo hinamoane Kotimo mafasiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ano unihaeaka reane aporomano hauaka sua risiamo kaiyisimo, hauaka sua anoaki patera asesa aporo hinamo suamo some kotesane some kakakosapo. Some kasakipoko, fahokosa maiyane faserepeakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Yasumo someraka, “Wate fana Kotimo some kará porofete aporo Taniomo someraka, ‘Koti mawakasemahokosakipoko Kotimo apea aporomo makata watikisane mareakosapo.’ Aíyaka Taniomo somesane faserepeakosapo. Arirakano makata watikisane fasereperakano repo sawi one menona aporo hinamomo aseraka Yasumo someane repo hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Asiamo Yutía aporo hinamo reo, makatane fasereaperamo re teketarikia ūria hinie. ");
INSERT INTO faa_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Maiya amo aporo ape kopoa reane ipi ape kakarua makata kemo mokoako puane siahoasifareapo. Asiamo ipi ape kopo rea aeyaka foaka takaripunie. ");
INSERT INTO faa_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Aporo meta ipi hemo tipia reane apea pasu mako puane siahoasifareapo. ");
INSERT INTO faa_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Hinamo umisa soko, hinamo hokosa kiri kaīyia soko, teketarikia hiane kára waforohokosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yakimo soko metao, fenena maiya amo soko metao, teketarikia pukusa maiyane fasereperapaka kurikurihoanie. ");
INSERT INTO faa_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Re teketarikia pukua arisia maiya amo mokoatikihokosane kárahokosapo. Hauaka kara one kepomaresa maiya amo soko, yumo soko mokoatikihokosane fana asiafapo. Arirakano mokoatikiraka faraka, keseke ayiáka mokoatikihokosafapo. ");
INSERT INTO faa_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Arirakano mokoatikihokosa maiya fasereaperamo, yaiya mokoatikiraka risikinone, aporo hinamo suane kukua keakosapo. Kukua kerapaka Kotimo murikimasa aporo hinamoane hemakapuraka, mokoatikihokosa maiya sapeane Kotimo rukupateraka makitakehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Arirakano aporo metamo reaki someraka, ‘Hao, kaisie. Aporo one Unihae makárasane epo. E Keresopo,’ aihokosapo. Arirakano aporo metamo reaki someraka, ‘Hao, kaisie. Kereso pekea, rekenapo,’ aihokosapo. Asiamo aporo metakiramo aiyaka somerakanone, ipu someane kakimakopo. ");
INSERT INTO faa_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Aporo metakira kotafe Kereso pariraka faserepeakosapo. Arirakano aporo metakira kotafe porofete aporo pariraka faserepeakosapo. Fasereperaka aporo hinamomo i patera asekeasimo ipu makata wakapu rakira kára rakiakosapo. Rakirakano aporo hinamomo asekea fofahokosapo. Kotimo murikimasa aporo hinamomo ipu makata ainane kau aseako kirimaraka rakiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kaisie. Maiyane faserepeasiraka makata ayiakakosane nōmo reaki somerakanapo. ");
INSERT INTO faa_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Asiamo aporomo reaki someraka, ‘Kereso ima yaoa rekenapo,’ Airakano kakimaka aseako pukupo. Arirakano aporo metamo someraka, ‘Kereso apea fararekenapo.’ Airakano kakimakopo. ");
INSERT INTO faa_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Arirakano maiya apera takua yamakereraka faesane, maiya apura takua soko faenapo. Aina ayiáka ano aperamo ayiáka peakosapo. Aporomanomo Tákeane anopo. ");
INSERT INTO faa_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Arirakano makata kusua kakeno mena sakarekepomo sarimanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Yasumo someraka, “Mokoatikihokosa maiyane faraka wate foaka sere maíyamo erehokosapo. Ere maíyamo faehokosafapo. Ti makata hepene yapunaka hauaka wo hurupepehokosapo. Hepene yapura makata kára risiane mahohohokosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Maiya amo hepene yapunaka Aporomanomo Táke ano paripeakosane makata wakapu kára metamo tariakosapo. Makata tarirakano hauaka kara wo aporomano su risiamo aseraka hihiripuhokosapo. Hihiripuraka aseane ano hepene yapunaka ti pakae a wakapuyaki faesa kárayaki perakano aseakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Aserakano pikoro rukusapo. Rurakano hepene aporo yakai nōmo pusierakano peraka, nōmo murikimasa aporo hinamo hauaka sua risiane pasimokoakosapo. Nōmo murikimasa aporo hinamo patera takua risiane soko, ketayia takua risiane soko, ketayia takua risiane soko, kumisi neneme takua risiane soko, hauaka sua nōmo murikimasa aporo hinamoane pasimokoa sarimahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yasumo someraka, “Ira foke takumeane oyapo. Ira foke parusane yoaerakano repo aseraka hemakapuraka, ‘Kupa kakako makerakanapo.’ Aíyaka repo hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Aina ayiáka nōmo makata ayiakakosaposane fasereperakano aseraka repo hemakapuraka, ‘Yasu peako makerakanapo,’ aíyaka hemakapunie. Arirakano, ‘Aporo ape kakarua yoroako ikia koro makeraka area ayiáka, Yasu ayiáka peako makerakanapo.’ Aíyaka repo hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nōmo reaki kakaro somerakaripo. Aporo hinamo maiya hakása yiamo hokono murisiane i kukusiraka hitaferaka arisiamo, nōmo ayiakakosaposane fasereperakano aseraka, ayiana ayareapo. Aíyaka aseakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Asiamo ti yapurane soko hauaka kára one soko fahokosapo. Arirakano nōmo someane fahokosafapo. Yaiya rekeakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yasumo someraka, “Ano peakosa sereane soko maiya hi awane soko aporomanomo hemakapurafapo. Hepene aporomo soko Kotimo hokosa nōmo soko hemakapurafapo. Nōmo Atamo ipi hákasamo hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Arirakano Noa rea maiya amo aporo hinamo risia ayiáka ano paripeakosa maiya amo aporo hinamo ayiáka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noa rea maiya amo he peasiraka aporo hinamomo makata nakosa soko, he soko nekea aporomo hinamo arumokoa, hinamomo aporo pukua ayiáka risiapo. Ayiáka risiakipoko Noa kasua ripasapo. ");
INSERT INTO faa_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Riparakano aporo hinamo suane meraruamo risiakipoko he hukupesapo. He hukuperaka makata su mokoa pusuapo. Asiamo Aporomanomo Táke anoane pariapera maiya amo Noa rea maiya amo asia ayiáka ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ano pariapera maiya amo, aporo tetá hemoa risiane meta nōmo pasimaraka, meta yia metakariakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hinamo tetámo makata rakiraka toane, meta nōmo pasimaraka, meta yia metakariakosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ayiakakosasamo repo asekea risikianie. Repo unihae paripeakosa sereane repo hemakapurafaraka asekea risikianie. ");
INSERT INTO faa_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Arirakano aporo makata hakimoramo aporo metamo apea makata kemo hakimokoako perapo. Makata kemo hakimokoako peakosane, maiya hi awane ape wafayamo hemakapurafapo. Ere wakopemo soko metao, ere tipiamo soko metao, fia makeanamo soko metao, hakimora aporo apea tau peakosane, ape wafayamo hemakapurafapo. Hemakapunafononasamo sere soko, ereamo soko, warafaraka ape asekea rerapo. ");
INSERT INTO faa_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Aina ayiáka repo soko ayiáka asekea risikianie. Aporomanomo Táke anoane paripeakosa maiyane soko, maiya teane soko, maiya hi awane soko, repo hemakapunafonosasamo re asekea risikianie.” Aiyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Yasumo someraka, “Aporo raipamo koteaka hemakapuraka ipi wafayaki himu hakásaraka hemakapukua uyáka rerapo. Wafayamo eaki someraka, ‘Nōmo ape asekea rekeanie. Aporo apea risiaki makata nakosa sia kakanie. Yapa marekea kakakopo.’ Aíyaka someaka marekea pukua, ");
INSERT INTO faa_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","keseke pariperaka aseane aporo raipamo rakiniesane rakirakano asekea kára sesehokosapo. Seseraka e makotehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ape wafayamo ipi aporo raipane makáraraka eaki someraka, ‘Nōmo makata kemo suane asekea rekeanie,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Arirakano aporo raipa watikisa uyáka rerapo. Aporo raipa watikisamo hemakapuraka, ‘Ape wafaya pusua haru paripeakosafapo.’ ");
INSERT INTO faa_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Aíyaka hemakapuraka aporo raipa metakira he watikisa nekea himu maparitaeraka, amano rura aporoakiyaki hakāsa toke, he watikisa nenapo. ");
INSERT INTO faa_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ayiáka reke ipi wafaya paripeakosa sereane soko, maiya hi awane soko, hemakapunafonoraka reakipoko, ipi wafayane pariperapo. ");
INSERT INTO faa_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pariperaka aporo raipa fanasiraka rukua marekea eaki someraka, ‘Ne pusie. Aporo himu tetáraka risia akiyaki rekeako pusie. Hauaka á i risike hihiripuraka akai kirisiraka risikinapo. Á ne soko rekeako pusie.’ Aíyaka ape wafayamo somehokosapo.” Aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yasumo someraka, “Unihae paripeakosa maiya amo, Koti unihaeaka asekea areamo asia ayiáka, ayiakakosane oyapo. Hinamo sakora kaeyako sumo nafa mokoa ape metakarikia aporo hinamo kawe arumasane ikia kara sapenako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Hinamo kaeyako suamo kakoreasu metamo koteaka hemakapusuafapo. Arirakano hinamo kakoreasu metamo koteaka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Asiamo koteaka hemakapunafonosa hinamomo nafa hákasa mokoa puraka, keresene petoroa takamaraka mokoa pusuafapo. ");
INSERT INTO faa_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Arirakano koteaka hemakapusua hinamomo nafa mokoa keresene soko petoroa takamaraka mokoa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Arirakano aporo hinamo kawe arumasane haru peanafonorakano hinamo kaeyakosu pusuane wakakorakano wasápo. ");
INSERT INTO faa_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Waka kesakipoko ere tipiamo aporo metamo wáraka, ‘Aporo hinamo kawe arumakosane apere. Repo soko aseako peae.’ Aíyaka wásapo. ");
INSERT INTO faa_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wárakano hinamo kaeyako suane turikia tarikia nafa pakimokoa, ");
INSERT INTO faa_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","koteaka hemakapunafonosa hinamomo koteaka hemakapusua hinamoaki someraka, ‘Isiapo nafane kopaka apure. Repo keresene isiapo nafa wakasema takamarasie.’ ");
INSERT INTO faa_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Airakano koteaka hemakapusua hinamomo someraka, ‘Wae, isiapo reaki takamahoane siahoasifareapo. Isu supoko kereseneane siahoanarakapo. Keresene fanapaka re namina sitaoa pukua haku roporasie.’ ");
INSERT INTO faa_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Airakano ipu keresene ropohoko pusuapo. Pusuakipoko aporo hinamo kawe arumakosane pesapo. Perakano keresene siaraka takamokoa pesa hinamoane eyaki namina hakāsa makata nakosa apea yorokoa hisiapo. Hinakano ikia koro mapirisiapo. ");
INSERT INTO faa_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Mapirisiakipoko koteaka hemakapunafonosa hinamo kakorea suane kesekea peraka hauaka moro aeyaka wáraka, ‘Unihaeo, Unihaeo, ikia koro ropakamasie. Isu peakoripo.’ ");
INSERT INTO faa_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Airakano unihaemo someraka, ‘Nōmo kakaro somerakaripo. Reane nōmo aserafapo.’ Aíyaka epo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ayiakakosasamo repo asekea risikianie. Asiamo ano paripeakosa maiya teane soko, maiya hi awane soko, repo hemakapunafonoraka asekea risikianie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yasumo someraka, “Unihae paripeakosa maiya amo ayiakakosane oyapo. Hemo wafaya kimisi pukusakipoko ipi aporo raipamo ipi moneane asekea risikiasimo peaerakano pesapo. ");
INSERT INTO faa_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Asiamo aporo raipamo ainane hemo wafaya amo aseraka, iaki makata hakása yinesa kasafapo. Aporo hakása metamo namo kakaro wakapuaka rakisiasamo eaki fae taosene kina (K5,000) asekea rekeasimo kasapo. Arirakano aporo hakása metamo wakapuaka rakisiasamo eaki tu taosene kina (K2,000) asekea rekeasimo kasapo. Arirakano aporo hakása metamo wakasema wakapuaka rakisiasamo eaki wane taosene kina (K1,000) kasapo. Kaka marekea ipi kimisi pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kimisi pusuakipoko fae taosene kina mosa aporoamo pisinisi rakiraka, fae taosene kina meta soko, mokoa akiyaki sarimasapo. ");
INSERT INTO faa_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Arirakano tu taosene kina mosa aporoamo pisinisi rakiraka, tu taosene kina meta soko, mokoa akiyaki sarimasapo. ");
INSERT INTO faa_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Arirakano wane taosene kina mosa aporoamo hauaka rakea, ipi asekea rea aporoamo wane taosene kina kasane kokomaresapo. ");
INSERT INTO faa_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Asiamo maiya kára faraka aporo raipamo sia rakisiarihoamo, hemo wafayamo aseako paripesapo. ");
INSERT INTO faa_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pariperakano fae taosene kina mosa aporoamo fae taosene kina meta soko mokoa akiyaki sarimasane, hemo wafayaki kasapo. Karaka epo someraka, ‘Unihaeo, nómo anoaki fae taosene kina karakano, nōmo pisinisi rakiraka fae taosene kina meta soko, mosane nepoko mone suane taesa ayapo.’ ");
INSERT INTO faa_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Airakano hemo wafayamo someraka, ‘Koterakae. Ne aporo raipa kotesapo. Nómo anoaki himu hakásaraka hemakapukua koteaka rakireapo. Nōmo neaki wakasema asekea rekeasimo maresane nómo koteaka rakisiasamo, nómo makata kára asekea rekeasimo nōmo mareakosapo. Nómo unihaeane anopo. Nōmo neaki seseripo. Nómo soko sesehoanie. Iti hakāsa seseaka risikiakosapo,’ aisapo. ");
INSERT INTO faa_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Arirakano tu taosene kina mosa aporoamo hemo wafaya rea pekea someraka, ‘Unihaeo, nómo anoaki tu taosene kina karakano, nōmo pisinisi rakiraka tu taosene kina meta soko mosane nepoko taesa ayapo.’ ");
INSERT INTO faa_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Airakano hemo wafayamo someraka, ‘Koterakae. Ne aporo raipa kotesapo. Nómo anoaki himu hakásaraka hemakapukua koteaka rakireapo. Nōmo neaki wakasema asekea rekeasimo maresane nómo koteaka rakisiasamo, nómo makata kára asekea rekeasimo nōmo né mareakosapo. Nómo unihaeane anopo. Nōmo neaki seseripo. Nómo soko sesehoanie. Iti hakāsa seseaka risikiakosapo,’ aisapo. ");
INSERT INTO faa_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Arirakano wane taosene kina mosa aporoamo hemo wafaya rea pekea someraka, ‘Unihaeo, nōmo hemakapuraka, “Ne aporo warepo. Ne ni hemo wafaya rekeno yia, aporo raipamo nepoko nómo hemoa makata porosane, wate perakano, nómo makasie, airapo.” Aíyaka nōmo hemakapusuakipoko ");
INSERT INTO faa_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ano namoraka reke nómo moneane hauaka rakea kokomaresapo. Kokomaresane kefomaka nómo ní menane neaki karakanapo.’ ");
INSERT INTO faa_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Airakano hemo wafayamo someraka, ‘Ne aporo raipa namo kakaro watikisapo. Ne kau hisiraka rakikia are. Nómo hemakapuraka, “Nōmo hemo poroanafonoraka makata nakosa morapo.” ");
INSERT INTO faa_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Aíyaka hemakapuraka nōmo moneane nómo pánikia motoafunureapo. Motorakano mone wakasema meta soko kima ripaka mareafunupo. Ano pariperaka mone umuraka taesane soko, mone wakasema ripasane soko, mokoafunupo,’ aisapo. ");
INSERT INTO faa_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Asiasamo hemo wafayamo aporo metakiraki someraka, ‘Wane taosene kina ipiaki asekea rekeasimo kasane fimasie. Fimaka tene taosene kina mosa aporoaki wane taosene kinane kakanie. ");
INSERT INTO faa_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Asiamo aporomo makata meta toaki, makata meta soko kakakosapo. Karakano ipi menane kára tokoakosapo. Arirakano makata meta tokoanafonosa aporoamo makata meta kakeno fimakosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aporo raipa watikisane yao eresa hauaka takua makasurasie. Hauaka á aporo hinamo hihiripuraka mere kirisiraka risikiakosapo.’ Aíyaka hemo wafayamo somesapo.” Aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yasumo someraka, “Aporomanomo Tákeane anopo. Ano peraka faesayaki hepene aporo suyaki hakāsa peakosapo. Peraka ano unihae kárasamo sea faesa susu á kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Kakeno ano kumisi nenemea aporo hinamo hauaka su aeyaka karikia perakano sarimahokosapo. Sarimasane nōmo takekea parakuhokosapo. Asiamo saro sipiyaki saro nanikoseyaki suasuaraka risiane, saro sipi wafayamo takekea parakuhokosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Parakuraka saro sipi hokono tumuru takua murikia, saro nanikose hokono kasakai takua murikia, ayiáka parakuhokosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Arirakano ano unihaeaka reke ano hokono tumuru takua, amano takekea murisiaki úyaka somehokosapo. ‘Nōmo Atamo re makotesane peae. Re Kotimo hokosasamo reane nōmo unihaeaka asekea rekeakosapo. Anoyaki risikiako peae. Wate fana hauaka kara one kepomaresa maiya amo, re anoyaki risikiakosane Kotimo maroporaka maresapo. ");
INSERT INTO faa_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Arirakano ano meamorakano repo anoaki makata nakosa karakasupo. Ano he narirakano repo ano he nasimo karakasupo. Ano kumuku perakano repo apea ano peaeaka pasimarakasupo. ");
INSERT INTO faa_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ano makata forokoa reke pasu fasekeno, repo ano arareraka pasu karakasupo. Ano makata takamaka warekeno, repo ano ararerakasupo. Ano tipura makerakano, repo ano ararehoko perakasupo.’ Aíyaka nōmo somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Aíyaka somerakano Kotiaki ereketae hemakapusua aporo hinamomo anoaki úyaka somehokosapo. ‘Unihaeo, ne meamorakano, masinaka isiapo neaki makata nakosa karakasure? Né he narirakano, masinaka isiapo né he nasimo karakasure? ");
INSERT INTO faa_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Né masinaka kumuku perakano, isiapo né peaeaka pasimarakasure? Né pasu fasekeno, isiapo masinaka neaki pasu karakasure? ");
INSERT INTO faa_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Né makata takamaka warekeno, masinaka isiapo né ararerakasure? Né tipura makerakano, masinaka isiapo né aseako perakasure?’ Aíyaka Kotiaki ereketae hemakapusua aporo hinamoamo somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Aíyaka somerakano nōmo iaki úyaka some paripukusapo. ‘Nōmo reaki kakaro somerakaripo. Nōmo nī mae parisa soko, nī papā parisa soko, hakása meta wakasemaraka reane repo ararerakasuane ano araresapo,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Arirakano ano hokono kasakai takua aporo hinamo murisiaki úyaka somehokosapo. ‘Re su watikisapo. Satanepoko soko, Satanemo aporo raipapoko soko, ira kopakapunafononane maroporaka maresapo. Re soko ano metakarikia á pusie, aihokosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Asiamo ano meamorakano repo anoaki makata nakosa karakasufapo. Ano he narirakano repo anoaki he nasimo karakasufapo. ");
INSERT INTO faa_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ano kumuku perakano, repo ano peaeaka pasimarakasufapo. Ano makata forokoa reke pasu fasekeno, repo anoaki pasu karakasufapo. Ano makata takamaka warekeno, repo ano araresafapo. Ano tipura makerakano repo ano aseako perakasufapo.’ Aíyaka nōmo somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Aíyaka somerakano, ipu anoaki úyaka somehokosapo. ‘Unihaeo, né meamoraka rekeno soko, he nariraka rekeno soko, kumuku perakano soko, pasu fasekeno soko, makata takamaka rekeno soko, tipura makerakano soko, masinaka isiapo né asekepayarakasure?’ Aíyaka ipu somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Aíyaka somerakano nōmo iaki úyaka some paripukusapo. ‘Nōmo reaki kakaro somerakaripo. Aporo hinamo wakasemaraka rea hakása meta, repo ararehoanafonoraka, asekepayarakasuane anopo. Repo ano asekepayarakasupo.’ Aíyaka nōmo some paripukusapo. ");
INSERT INTO faa_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Asiamo i yaiya fanasihokosakipoko taku atura purakano, Kotiaki ereketae hemakapusua aporo hinamoane Kotiyaki risikiakosakipoko, taku yapura hiakosapo,” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yasumo makata ayiakakosane someaka faraka ipi aporo hakāsa puraki someraka, ");
INSERT INTO faa_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Yape tetá faraka, Ape Farimaresa Hemakapuko Hokono Keakosapo. Hokono akera maiya amo, Aporomanomo Táke anoane ira matopesa paremarekea rusua kukusapo. Rusua kukusimo aporomo ano parakehokosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Arirakano pirisiti aporo fanane ipi yano motosa Kaiafasepo. Epo apea pirisiti aporo kára soko, Yu aporo sisima soko su sarimasapo. ");
INSERT INTO faa_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Sarimaraka ipu me rukua someraka, “Yasuane mahoperaka waseremaka rusua kukusimo rukusapo. ");
INSERT INTO faa_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Asiamo hokono akera maiyamo, Yasu waseremayane siahoasifareapo. Aporo yakai sarimasamo isuyaki werapaka isiapo waseremakosafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Petene apea Saemone toropakesa fasamo apea, Yasu reakipoko ");
INSERT INTO faa_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","hinamo meta peraka eke kotesa petoro pariraka rakisiane maka pesapo. Petoro maka pesa á wera namo kakaro wape yamona, mone káramo roponane kesapo. Kesane Yasu teporo makeraka kake makata nenaka kakeno, hinamoamo wera wape yamona Yasu wamoa rekemaresapo. ");
INSERT INTO faa_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Rekemarerakano asekea, aporo hakāsa puramo saperaka namina susu someraka, “Hinamoamo werane marirakano nenakamakayia rekemarekea farakanare? ");
INSERT INTO faa_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Werane aporo metaki roporaka mone kára mokoafunureapo. Mone mosane aporo makata forosaki kakafunureapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Airakano ipu hemakapusuane Yasumo asekea someraka, “Marirakano hinamoane mahisihoasimo aíyaka somerakanare? Hinamoamo ano wamoa wera rekeamarerane makata rakira kakaro kotesane ayapo. ");
INSERT INTO faa_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Asiamo aporo makata forosane maiya suamo reyaki hakāsa risikiakosapo. Asiāne ano maiya suamo reyaki hakāsa rekeakosafapo. ");
INSERT INTO faa_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ano kau kunikia motoakosakipoko hinamoamo wera wape yamona ano kau makoteraka rekemareakosane murikimaka rekemarerakasapo. ");
INSERT INTO faa_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Hao, kaisie. Nōmo reaki kakaro somerakaripo. Hauaka kara wo aporomo anoane some akara maiya amo hinamoamo wera rekemaresane soko aporo hinamomo hemakapusimo ipu somehokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aporo hakāsa pura hakása meta yano motosa Yutase Isekerio ipi pirisiti aporo kára risiakipoko puraka, ");
INSERT INTO faa_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","hokokaraka someraka, “Nōmo Yasuane parakerakanone repo anoaki yakapa kakakosare?” Airakano ipu Yutaseaki someraka, “Isiapo neaki siufa mone hae teti (30) kakakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Aíyaka karakano Yutasemo, “Yasu mayiáka parakehoaepi,” aíyaka Yasu parakehokosa ikia karane kosapo. ");
INSERT INTO faa_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Farawa Pirianafonona Nakosakipoko hokono kera kepoamarera maiya amo Yasu rea aporo hakāsa pura pekea someraka, “Ape Farimaresa Hemakapuko Hokono Keraka makata nakosane, ape ma sarimaraka taehokosare?” ");
INSERT INTO faa_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Airakano Yasumo someraka, “Yarusarame sitia puraka aporo metaki úyaka somehoanie. Tisamo someraka, ‘Ano kukusa maiyane makerakanapo. Makesasamo Ape Farimaresa Hemakapuko Hokono Keakosakipoko nómo apea nōmo aporo hakāsa purayaki makata nakosapo.’ Aíyaka Yasumo somerakasapo, aihoanie.” Aíyaka Yasumo someaka marerakano, ");
INSERT INTO faa_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","somesane yaiya kekemaraka aporo hakāsa pura pukua makata nakosa sarimaraka taesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Samapu Yasu ipi aporo hakāsa pura kenosuyaki apea pusuapo. Pukua teporo makeraka ");
INSERT INTO faa_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","makata nenaka toa maiya amo Yasumo someraka, “Nōmo reaki kakaro somerakaripo. Repo aporo hakása metamo ano parakehokosapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Airakano ipu himu sesenafaraka mahisiraka, namina kaipe puraka, “Unihaeo, Né parakehokosane anore?” Aíyaka kaipe pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Kaipe purakano Yasumo someraka, “Nōmo farawa maka he waira kokoamarera yiamo, aporo metamo soko kokomarerakano aporo ayapo. Aporoamo ano parakehokosapo. ");
INSERT INTO faa_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Aporomanomo Tákeane anopo. Ano aporomanomo ayiakakosane Kotimo sawia porofete aporomo poparaka maresane yaiya ayiakakosapo. Ano parakeana aporoane fanasihokosane itifiakosafapo. Aporoane hokono mareanafonosa satiki ane kotehoafunureapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Airakano Yutase Yasu parakehokosa aporoamo Yasuaki someraka, “Tisao, né parakehokosane anore?” Airakano Yasumo Yutaseaki someraka, “Ao, nómo somesa ayapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ipu makata nenaka toa maiya amo Yasumo farawa maka Kotiaki suseaka kurikurisapo. Kurikuriraka faraka epo farawa maka mosoraka, ipi aporo hakāsa puraki kaka someraka, “Farawa one repo maka nesie. One ano kaupo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Arirakano kapo he maka Kotiaki suseaka kurikuriraka faraka iaki karaka someraka, “Repo suamo nesie. ");
INSERT INTO faa_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","He one ano yapipo. Kotimo aporo hinamoyaki kawe someaka masane hemakapusimo, ano yapi pukusa ayapo. Aporo hinamo yakaimo himu watikisane yapiamo mafahokosapo. ");
INSERT INTO faa_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Hao, kaisie. Waene he one nōmo efera hunia hauaka wo nakosafapo. Ata unihaeaka reamo hauaka á reyaki hakāsa sarimaraka waene he kaweane nakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Aíyaka somerakano ipu Kotiaki kekereraka kesasapo. Kesaraka faraka apeane metakarikia ūri Orofea hisiapo. ");
INSERT INTO faa_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Aporo hakāsa puraki Yasumo someraka, “Pipu ereamo ano anakano asekea, repo suamo anoaki himu hakásaraka hemakapurafaraka ano metakariakosapo. Arirakano Kotimo sawia Kotimo somesa popasane oyapo. ‘Saro sipi wafayane nōmo kukusimo rurakano, saro sipi suane teketariakosapo.’ Aíyaka popasane ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ayiakakosa nine ano maturikia taerakano Kariri hauaka á ano fana pusuakipoko, re keseke pekea isina hakāsa sarimahokosapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Airakano Pitamo Yasuaki someraka, “Ipu suamo neane metakarirakano, nōmo ne kakaro metakariakosafapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Airakano Yasumo Pitaki someraka, “Nōmo kakaro somerakaripo. Pipu ereamo kokorokomo mehoasiraka nómo ‘Yasu aserafapo,’ aíyaka yape isiamo nómo kotafe somehokosapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Airakano Pitamo someraka, “Wae. Ano neyaki hakasa kuraka, Maiyaka néane aserafapo, aihokosare?” Airakano aporo hakāsa pura suamo Pitamo someane hakasa nine kekemaraka somesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yasu aporo hakāsa purayaki Kesemane hauaka á puraka, Yasumo iaki someraka, “Re o toae. Ano wakasema pukua kurikurihokosapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Aíyaka Yasumo Pita soko, Sepetemo maeya tetá soko karikia puraka, Yasu ipi kára himu nekea mahisiraka sesenafaraka reapo. ");
INSERT INTO faa_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ayiáka reke Yasumo iaki someraka, “Ano himu kára mahisiraka reke ano kukusireapo. Re o toae. Anopoko hemakapukua o toae. Re wakakopo.” ");
INSERT INTO faa_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Aíyaka Yasumo someaka marekea wakasema pukua, uakapekea hikumisimo hauaka nanireke kurikuriraka, “Atao, nómo anoaki makata umisa maresapo. Maresane siasekenone makata umisane nómo masie. Asiāne nōmo hemakapusua aeyaka ayiakakopo. Nómo ní hemakapusua aeyaka ayiakanie.” ");
INSERT INTO faa_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Aíyaka kurikuriraka faraka aporo hakāsa pura isiane toakipoko peraka, aseane i wakakesekeno asesapo. Asekea i maturikia taeraka Pitaki someraka, “Re maiya hi awa hakásamo anoyaki hakāsa turikia asekea risikiasifareapo. ");
INSERT INTO faa_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Asiamo re mokopipirakano repo watikiaka rakipe purapaka hitafe risike kurikurihoanie. Repo himumo kurikurihoko seseraka, asiane kaumo yoferaka wakakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Aíyaka Yasu yape tetá pukua kurikuriraka, “Nōmo Atao, makata umisane nómo anoaki makasapo. Makasane nōmo makanafonorakano fahokosafapo. Makata umisane fahoasimo nōmo makosapo. Nómo hemakapusua aeyaka nōmo ayiakakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Aíyaka kurikuriraka faraka aporo hakāsa pura toakipoko, Yasu peraka aseane i wakakesekeno asesapo. Anakano i wakako hi kumikia nekeraka kakaro wakakesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Wakakesekeno metakarikia, Yasu wakasema pukua yape isiamo kurikurisapo. Kurikuriraka fana kurikurisa hakása yine kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Kurikuriraka faraka aporo hakāsa pura toakipoko Yasu pariperaka someraka, “Re yaiya wakakesare? Re su turisie. Aporomanomo Táke anoane parakeraka aporo watikisamo ano waseremakosa maiyane maiya yuyapo. ");
INSERT INTO faa_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Re su takahisie. Takahikia isu purakapo. Aporo ano parakehokosane apere,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yasumo somesa maiya amo aporo hakāsa pura meta yano motosa Yutase peraka, aporo yakai eyaki hakāsa pesapo. Aporo pesane aporo metakiramo poke mokoa pekea, aporo metakiramo ira rokopa menane mokoa pekea, aporo metakiramo ferepe menane mokoa pesapo. Aporo pesane pirsiti aporo káramo soko, Yu aporo sisimamo soko, iane pusierakano pesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aporoane peasiraka parakena aporo Yutasemo fana someraka, “Aporo nōmo makanurakano aporo ayapo. Eane waseremakanie.” ");
INSERT INTO faa_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aisasamo Yasu rea Yutase ereketae pekea someraka, “Tisao,” aíyaka epo Yasuane makanusapo. ");
INSERT INTO faa_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Makanurakano Yasumo someraka, “Hameo, nómo ayiakakosane ayiakanie.” Airakano aporo yakai peraka Yasu waseremasapo. ");
INSERT INTO faa_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Waseremarakano Yasumo aporo hakāsa pura aporo hakása metamo ipi ferepe teaka maka, pirisiti aporo fanamo aporo raipa meta senaki rukusakaretapisiapo. ");
INSERT INTO faa_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Rukusakaretapirakano Yasumo someraka, “Nómo ferepe terakaea rusaka maresie. Aporomanomo ferepemo werakano ferepemo eane rukusapo. ");
INSERT INTO faa_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Aporomo ano mokoatikina maiya amo nōmo Ataki wárakano Atamo hepene aporo hokono u yakai menohoasifa asia amo ano ararehoko pusiehokosapo, aíyaka Atamo hepene aporo ane pusiehokosane repo himeterire? ");
INSERT INTO faa_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Arirakano ano kukusaposane Kotimo sawia popasane ayiakasimo hepene aporo pusiehokosafapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aíyaka Yasumo aporo su sarimasaki someraka, “Repo ferepe mokoa pekea, poke mokoa pekea, ano waseremako pekea arisiane ano hakimora apororeare? Maiya suamo Kotimo apea ano reke some karakano, repo ano waseremarakasufapo. ");
INSERT INTO faa_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Asiamo Kotimo sawia Kotimo some kará porofete aporomo poparaka anoaki ayiakakosaposane fasereapera ayapo.” Aíyaka somerakano Yasumo ipi aporo hakāsa pura suamo e metakarikia teketarisiapo. ");
INSERT INTO faa_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pirisiti aporo fanane Kaiafasepo. Kaiafasemo apea Yasu waseremasa aporoamo eane karikia pusuapo. Apea Kotimo somemane tisa aporo soko, Yu aporo sisima soko, Kaiafaseyaki sarimaraka risiakipoko ipu Yasuane karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Karikia purakano Pita wakasema yamenoa kekemarape pusuapo. Kekemarape puraka pirisiti aporo fanamo ape hauaka moroa pauraka aporo terakaiyamosa toakipoko Pita soko kayapo. Kake Yasuaki makata hukuarurane aseako kayapo. ");
INSERT INTO faa_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Arirakano pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, Yu aporo sisimamo soko, ipu aporo metakiraki peaesapo. Pekea aporoamo Yasuaki hukurukua topakamaraka somehoko peaesapo. Ipu hemakapuraka, “Aporo metakiramo Yasu hukururakano Yasu fanasiraka rusua kukusapo.” Aíyaka topakamaraka somehoasimo kosapo. ");
INSERT INTO faa_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kosa maiya amo aporo metakiramo Yasuaki kotafe topakamaraka somesa nine, ipu someane kairaka Yasu rusua kukunie, aíyaka somehoasimo ipu tafaraka siasafapo. ");
INSERT INTO faa_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Keseke aporo tetá peraka someraka, “Aporoamo someraka, ‘Kotimo ape nōmo rakaritaeraka sere isia faraka efera hunia kiakosapo.’ Aisane etapo kaisiapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Airakano pirisiti aporo fanaraka reane takahikia Yasuaki someraka, “Nómo some paripukusare? Néaki makata hukurusuane kepo yakapare?” ");
INSERT INTO faa_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Airakano Yasumo makata somehoanafonorakano pirisiti aporo fanamo someraka, “Koti yaiya reasasamo nōmo neaki akai kairakano nómo aumaraka some paripeanie. Kotimo ne unihaeaka rekeasimo murikimasa aporo Keresoane nére? Kotimo hokosa ane nére? Nómo somesie.” ");
INSERT INTO faa_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Airakano Yasumo someraka, “Ao, nómo ní someraka ayapo. Hao, kaisie. Koti ipi namo kakaro wakapuaka rekenapo. Asiamo keseke Aporomanomo Táke anoane Kotimo hokono tumuru takua kakeno repo aseakosapo. Ano hepene aeyaka akoyaki perakano repo aseakosapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Airakano pirisiti aporo fanamo kaikia mahisiraka, ipi pasu makoaraka someraka, “Aporoamo Kotiane mawakasemarakae. Epo yiamo Koti mawakasemarakano e hukuruko aporo meta peaehokosafapo. Ipi yiamo Kotiane mawakasemarakano repo akaire. ");
INSERT INTO faa_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kairaka repo hemakapusuane yakapare? Isiapo Yasuane mayiakakosare?” Airakano ipu someraka, “E rusua kukunie.” ");
INSERT INTO faa_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Aíyaka Yasu hikumisia torofaeraka, aporo metakiramo hokono mamuraka ruraka, aporo metakiramo hokono namamo ruraka someraka, ");
INSERT INTO faa_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ne Keresosasamo ne arurane epamo rurakarire? E yano hosie. Asiamo Kotimo porofete aporoaki somesa ayiáka, ne mokoatikiana aporoane Kotimo yano honakano kaikia nómo yano hosie.” Aíyaka ipu somesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Hauaka moroa Pita kakeno hinamo raipa meta peraka eaki someraka, “Ne Kariri aporo Yasuyaki hakāsa purapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Airakano Pitamo waeraka aporo suamo kaiyisimo someraka, “Nómo somerakane ano himeteripo. Ano Kariri aporo Yasuyaki hakāsa purafapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Airakano Pita ape tarua hikia rekeno, hinamo raipa metamo aporo toaki Pitane tarikia someraka, “Aporoane Nasare aporo Yasuyaki hakāsa pusuapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Airakano Pitamo aumaraka someraka, “Aporoane nōmo aserafapo.” ");
INSERT INTO faa_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Airakano wakasema tuina aporo risiamo Pita rea pekea someraka, “Nómo me isiapo kaiyiáne Kariri aporomo merakae. Yasumo someane isiapo kairasasamo nómo someane soko isiapo kaiyiáne, Yasumo aporo hakāsa puramo somerakae.” ");
INSERT INTO faa_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Airakano Pitamo ekeneraka aumaraka someraka, “Aporoane nōmo aserafapo. Nōmo kotafe somerakano Kotimo ano fanasihoane siahoasireapo.” Aihoanine wate foaka yia mena kokorokomo mesapo. ");
INSERT INTO faa_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Merakano kaikia Yasumo fana somesane Pitamo hemakapusuapo. Hemakapuraka ape metakarikia yaoa pukua kára hiripusapo. Asiamo fana Yasumo someraka, “Mena kokorokomo mehoasiraka nómo yape isiamo ‘Yasuane nōmo aserafapo,’ aihokosapo.” Aíyaka Yasumo somesane Pitamo hemakapukua kára hiripusapo. ");
INSERT INTO faa_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Mituru fiarakano pirisiti aporo kára soko, Yu aporo sisima soko i sarimaraka, Yasu rusua kukusane me rukua someraka risiapo. ");
INSERT INTO faa_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ipu someraka risina me rukua someaka faraka, Yasu sakomo taporaka marekea, Pairate rea Yasu karikia pusuapo. Arirakano Yutía hauaka ane Rome kamani aporo Pairatemo asekea reapo. ");
INSERT INTO faa_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yasuane Pairate rea hukurusimo karikia purakano asekea, Yasu parakesa aporo Yutasemo aseraka ipi himu kára nekea hemakapuraka, “Katuaka yia parakehoae. Siufa mone hae teti (30) kasane nōmo fimakakosapo.” Aíyaka hemakapuraka pirisiti aporo kára soko Yu aporo sisima soko i risiakipoko pekea someraka, ");
INSERT INTO faa_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nōmo watikiaka rakisiapo. Yasumo watikiaka rakianafonosa nine, nōmo e parakesapo.” Airakano ipu someraka, “Kepo nipo. Isiapo menafapo.” ");
INSERT INTO faa_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Airakano mone hae mokoa pesane fikia Kotimo ape asikurua mokoasuraka, metakarikia pukua, Yutase ipi mawia sakomo kita humarekea huruperaka kusuapo. ");
INSERT INTO faa_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Kurakano pirisiti aporo káramo mone fimokoasusane mokoa, me rukua someraka, “Aporo rusua kukusimo mone one kasasamo, Kotimo apea mone taesa akiyaki mone one sarimahoane siahoasifareapo.” Aíyaka ipu somesapo. ");
INSERT INTO faa_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Aíyaka someraka mone ane mokoa, hauakamo orotipi rakira aporomo hauakane roposapo. Arirakano hauaka roposane aporo kimisi pesa kurakano hauaka á muriasimo roposapo. ");
INSERT INTO faa_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Asiamo hauakane yano motoraka Yapi Hauakapo. Aíyaka yano taerape pusuane, sawi one popana maiya amo soko, aíyaka hauakane yano hosapo. ");
INSERT INTO faa_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Asiamo hauaka ane ropohoasiraka porofete aporo Yaremayamo popasane oyapo. “Eane ropohoko Yu aporo káramo someraka, ‘Siufa mone hae teti (30) ane siahoasireapo.’ Aíyaka someaka masakipoko mone hae teti (30) ane mokoa ");
INSERT INTO faa_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","hauakamo orotipi rakira aporomo hauakane roposapo. Roposane Kotimo ayiakakosaposane ásiapo.” Aíyaka Yaremayamo popasane faserepesa ayareapo. ");
INSERT INTO faa_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Rome aporo unihaeaka rea hikumisi nenemea Yasu rekeno Yasuaki akai kairaka, “Yu aporomo unihaeane nere?” Airakano Yasumo someraka, “Nómo someraka ayapo.” ");
INSERT INTO faa_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Airakano pirisiti aporo káramo soko, Yu aporo sisimamo soko, Yasuaki hukurukua somerakano Yasumo some paripesafapo. Ipi watikiaka rakianafonosa nine, epo táfaraka some paripesafapo. ");
INSERT INTO faa_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Some paripeanafonorakano Pairatemo someraka, “Ipu makata kára hukuarurane nómo kairakarire?” ");
INSERT INTO faa_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Aihoane Yasumo some paripeanafonorakano asekea Rome aporo unihaemo hemakapuraka, “Me kauraka asekea areane manakanarakapo,” aíyaka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","19","Pairatemo hemakapuraka, “Yu aporomo Yasuaki kakanakeraka rusua kukusimo ano rea karikia pesapo,” aíyaka hemakapusuapo. Hemakapukua Yasu hukuarura maiya amo Yasumo someane Pairatemo kairaka rekeno, Pairatemo aseamo Pairate rea aporo meta pusiesapo. Pusierakano aporoane pukua Pairateaki someraka, “Nómo ní hinamomo someaka maresane oyapo. ‘Pipu nōmo kituamo aporo kotesa Yasuane asesasamo himumo kára hemakapukua rekenapo. Asiasamo somemane mamosohoanafonona aporo kotesane fanasihokopo. Metakarinie,’ airakasapo.” Aíyaka aporo pesamo somerakano Pairatemo kaisiapo. Arirakano Ape Farimaresa Hemakapuko Hokono Akera maiya amo tipura makesa aporo hakása metane Rome kamani aporo unihaemo tonotaenapo. Tipura makesa aporo hakása metane tonotaehoasimo Yu aporomo murikimaraka, “Aporoane tonotaehoanie,” aíyaka murikimarakano kamani unihaemo tonotaenapo. Asiamo Yasu hukuarura maiya amo aporo kakaro watikisa yano motosa Parápase tipura makesa rekeno asekea, Yu aporo yakai sarimasaki Pairatemo someraka, “Aporo tonotaehokosane epa tonotaehoko hemakapurakanare? Parápase soko metao, Yasu Kereso soko metao, epa tonotaehokosare?” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Arirakano pirisiti aporo káramo soko, Yu aporo sisimamo soko, ipu aporo su sarimasaki hokokaraka someraka, “Yasuane rusua kuraka Parápase tonotaehoanie, aihoanie.” ");
INSERT INTO faa_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Aisakipoko Rome kamani aporo unihae Pairatemo someraka, “Aporo tetáne epa tonotaehoko hemakapurakanare?” Airakano ipu someraka, “Parápase tonotaehoanie.” ");
INSERT INTO faa_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Airakano Pairatemo someraka, “Yasu Keresoane maiyakaere?” Airakano ipu suamo someraka, “E ira matopesa paremarekea rusua kukunie.” ");
INSERT INTO faa_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Airakano Pairatemo someraka, “Marirakano rusua kukunierakanare? Epo watikiaka makata yakapa rakisiare?” Airakano ipu sakepamo wáraka, “E ira matopesa paremarekea rusua kukunie.” ");
INSERT INTO faa_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aíyaka ipu sakepamo wáraka risiapo. Ayiáka risikino aporomo weakosane Pairatemo asekea hemakapuraka, “Nōmo someane ipu kakipayarakanapo.” Aíyaka aporo suamo asekeasimo aporo su hikumisia reke, hemo ipi hokono kusuraka someraka, “Aporoane rusua kurakano nōmo kererefapo. Repo kererepo. Ano hokonoa makata parareane kusuraka fana ayapo.” ");
INSERT INTO faa_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Airakano aporo hinamo suamo someraka, “Yasuane rurakano kerereane isiapo menapo. Isiapo hokosamo soko menapo.” ");
INSERT INTO faa_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Airakano Parápase Pairatemo tonotaeraka, Yasu matia sakomo runiesapo. Rurakano asekea someraka, “Yasu ira matopesa paremareako karikia punie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Kamani aporo unihaemo ame aporo peraka, Yasuane kamanimo apea karikia pukua, Yasu rea ame aporo su sarimasapo. ");
INSERT INTO faa_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sarimaraka Yasumo pasuane su hororaka, pasu susa osoraka marekea, ");
INSERT INTO faa_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","hati kotesa unihae káramo karotapira ayiáka karotapikia maresapo. Asiane hati karotapisiane kakaro hatifapo. Yasu mainamareraka sako keta risia hati pariraka rakiakosakipoko, kita apera ayiáka pekea weroraka rakisiapo. Rakisiane Yasu wamoa karotapikia maresapo. Karotapikia Yasu hokono tumuru takua kepayia patekemasa hokono sikinia marekea kakuna porokoa mahokopariraka someraka, “Yu aporomo unihaeo, né aporo kárapo.” ");
INSERT INTO faa_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Aíyaka Yasu kaua torofaeraka, kepayia hokonoa maresane maka Yasu wamoa rusuapo. ");
INSERT INTO faa_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Rukua mahokopariraka faraka, pasu susa kau rakisiane horomaka, ipi pasuane osoraka marekea ira matopesa paremareako karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Yasu karikia puraka aseane Sairíni aporo ipi yano motosa Saemone perakano asekea, ira matopesane maka pusiesapo. ");
INSERT INTO faa_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Maka pusierakano i pukua Kokóta hauaka á pausapo. Arirakano Kokóta hauakane namo meaka Uni Kiki hauakapo. ");
INSERT INTO faa_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Kokóta hauaka á pauraka risike Yasumo nasimo waene he soko munamuna asíayaki sarimaraka kekeroraka kasapo. Karakano Yasumo sareraka nesafapo. ");
INSERT INTO faa_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nanafonorakano ame aporomo Yasu ira paremareraka, Yasumo pasuane parakuraka mokoakosakipoko ipu kase enana ayiáka enasapo. ");
INSERT INTO faa_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Enaraka toke Yasuane aporo metamo ararehokohoamo asekea toapo. ");
INSERT INTO faa_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ame aporomo Yasu uni kima yapura eaki hukurusuane ira tumusakipoko poparaka paremaresapo. Poparaka paremaresane oyapo. “Aporo one Yasupo. Yu aporomo Unihae epo.” Aíyaka poparaka paremaresapo. ");
INSERT INTO faa_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Maiya amo hakimora aporo tetá Yasuyaki hakāsa ira matopesa paremurisiapo. Meta Yasu hokono tumuru takua paremarekea maporaka, meta Yasu hokono kasakai takua paremarekea maporaka, Yasu tipia paremarekea maposapo. ");
INSERT INTO faa_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yasu paremaresa rekeno, aporo metakira e paremaresa makeraka puraka mainamareraka siraraka, unia rokoraka someraka, ");
INSERT INTO faa_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Nómo fana someraka, ‘Kotimo ape rakaritaeraka yape isia faraka efera hunia kikimakosapo,’ airakasupo. Aisasamo nómo ní yia ararerasie. Né Kotimo hokosasekenone ira matopesane metakarikia o peae.” ");
INSERT INTO faa_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Airakano pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, Yu aporo sisamamo soko, Yasuane ayiáka mainamareraka someraka, ");
INSERT INTO faa_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Yasumo aporo metakirane araresapo. Araresa nine ipiane ararehoasifareapo. Ipi Isiraya aporo unihaepo. Ipi ira matopesa metakarikia o perakanone, isiapo eaki himu hakásaraka hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ipi Kotiaki himu hakásaraka hemakapukua reke someraka, ‘Ano Kotimo hokosapo.’ Airakano Kotimo eane seseraka arareraka soko metao eane ararehoafunureapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Airakano hakimora aporo Yasu takua ira matopesa paremurisia amo soko Yasuaki yaisapo. ");
INSERT INTO faa_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Hauaka sua sere tuaro (12) korokomo kepomarekea eresapo. Ereraka reane samapu maiya isiamo faesapo. ");
INSERT INTO faa_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Samapu maiya isia makenamo, Yasumo Yu aporo meaka sakepamo wáraka, “Irae, Irae, rama sapakatani.” Aíyaka namo meaka someraka, “Nōmo Kotio, nōmo Kotio, nómo ano marirakano metakarisiare?” ");
INSERT INTO faa_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Airakano kaikia aporo metakira makeraka risiamo someraka, “Epo Iraíyaki warakae.” ");
INSERT INTO faa_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Airakano aporo hakása meta foaka pukua he watera asía he kisa a kokomarekea fofako turua tapomarekea Yasumo nasimo makama yapurasapo. ");
INSERT INTO faa_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Aporo metakiramo someraka, “Harufapo. Iraíyamo Yasuane ararehoko perakarihoamo, isiapo kau risikinapo.” ");
INSERT INTO faa_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Airakano Yasumo efera hunia sakepamo wáraka, epo hemakapuraka, “Ano ho puane siahoasireapo,” aíyaka hemakapukua kusuapo. ");
INSERT INTO faa_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yasu kusua maiya amo Kotimo apea pasu waremaresane yapunaka koarape atura pusuapo. Koarape pukua taku haku taku hakusapo. Ayiaka momani soko kára peraka, eke hemakapukua koaraka ");
INSERT INTO faa_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","aporo kusua motosa kunikia ekemo mapirisiane hemakapukua ropaka pusuapo. Ropaka puraka aporo Kotiaki himu hakásaraka hemakapukua risia kusuane Kotimo maturikia taesapo. ");
INSERT INTO faa_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Aporo maturikia taesane Yasu maturikia taesakipoko iane soko kunikia metakarikia Yarusarame sitia purakano aporo yakaimo iane asesapo. ");
INSERT INTO faa_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Arirakano ame aporo soko satiniyaki Yasu asekea risia amo aseane momani peraka makata su anakano asekea himu faraka someraka, “Aporoane kakaro Kotimo hokosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Arirakano hauaka wakasema tame yia hinamo yakai asekea risiapo. Asiamo Yasu Kariri hauaka koraka rekeno hinamoamo Yasu araresapo. Arareraka Yasu Yarusarame sitia perakano i soko pesapo. Peraka Yasu pipu yia ira matopesa paremarerakano, wakasema tame yia risike asesapo. ");
INSERT INTO faa_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Asesa hinamoane yano taesane oyapo. Meta, Makatara hinamoane Mariapo. Meta, Maria Yamesepe Yosefe tetapō kaīyiapo. Meta Sepetemo hokosamo kaīyiapo. I isiane soko, hinamo metakira soko ipu makata suane asesapo. ");
INSERT INTO faa_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Samapu maiya tuakeramo Arimatía aporo pesapo. Ipi makata kemo kára toapo. Ipi yano motosa Yosefepo. Eane Yasu patera asesapo. ");
INSERT INTO faa_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","E Pairate rea pukua someraka, “Yasu kusuane nōmo kunikia motoako maka puaere?” Airakano Pairatemo ame aporoaki someraka, “Yasu kusuane fatarimaka Yosefeaki kakanie.” Aíyaka someaka maresapo. ");
INSERT INTO faa_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Someaka marerakano kairaka, Yasuane fatarimaka Yosefeaki kasapo. Karakano Yosefemo Yasu kusuane pasu pakaesa kotesamo taposapo. ");
INSERT INTO faa_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Taporaka Yosefemo maka pukua ipi eke kunikia fana rasa á, aporo meta fana motoanafonosakipoko, á Yasu motosapo. Motokoa marekea kunikia kakaru mapiriakosakipoko, eke kára tafeasa keperemarape pukua, kunikia kakarua mapirikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Arirakano Makatara hinamo Maria soko, Maria meta soko, kunikia makeraka ereketaeraka toapo. ");
INSERT INTO faa_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Fenena maiya á pauhokosakipoko kakoreamo, makata su sarimaraka taesapo. Taesa sereane faraka pirisiti aporo kára soko, Ferese aporo soko, Pairate rea sarimaraka someraka, ");
INSERT INTO faa_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“Unihaeo, Isiapo makata one hemakapurakanapo. Kotafe hora aporo Yasuane kukusiraka epo someraka, ‘Ano kusuane yape isia faraka maturikia taehokosapo,’ airakasupo. ");
INSERT INTO faa_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Aisasamo yape isia omo kunikiane kakaro mapiriasimo nómo someaka mareanie. Airakano Yasu kusua kunikia motosane ipi aporo hakāsa pura pekea, tau hakimaka aporo suaki someraka, ‘Yasuane Kotimo maturikia taesapo.’ Aíyaka somerakanone aporo suamo kakimakosapo. Kakimaka ipu kotafe hora amo kotafe hora fanane marokehokosapo. Ayiakakohoamo kunikia ane kakaro mapirinie. Aiyaka someaka mareanie.” ");
INSERT INTO faa_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Airakano Pairatemo someraka, “Aporo terakaiyamosamo asekea risikiako pusiehokosapo. Re pukua eke tafea mapirisiane repo kakaro koteaka mapirinie.” ");
INSERT INTO faa_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Airakano i pukua eke tafea mapirisiane ropakamarapaka ororomo fea tipe pusuapo. Ayiáka mapirikia faraka aporo terakaiyamosamo asekea risikiasimo murisiapo. ");
INSERT INTO faa_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Fenena maiya farakano yatipunumo yao kawe fiarakano mituru Makatara hinamo Maria soko, Maria meta soko kunikia aseako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Maiya amo wate foaka momani kára peraka, hepene yapunaka Unihae Kotimo hepene aporo pekea eke tafea kunikia ikia koro mapirisiane keperemafearaka, eke kima yapura asekea kayapo. ");
INSERT INTO faa_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Yamakeremo faeana ayiáka hepene aporo hikumisia ayiáka faesapo. Ipi pasuane ako kakaro pakaesa asíapo. ");
INSERT INTO faa_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Hepene aporoane aporo terakaiyamosamo aseraka kára namoraka fofaraka hamisisiraka ku pesapo. ");
INSERT INTO faa_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Arirakano hepene aporomo hinamoaki someraka, “Hinamo teto namohokopo. Nōmo hemakapuane tetápo Yasu ira paremarekea rusua kusuane aseako kope apere. ");
INSERT INTO faa_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yasu o rekerifapo. Epo ipi someraka, ‘Ano maturikia taehokosapo,’ aisane yasiapo. E kau motosa fasane aseako teto peae. ");
INSERT INTO faa_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Asekea faraka ipi aporo hakāsa puraki somehoko foaka pusie. Puraka úyaka somehoanie. ‘Yasu maturikia taesapo. E fana Kariri hauaka á pukua reakipoko, re kesekea peraka Kariri hauaka á e aseakosapo.’ Aíyaka somehoanie. Asiamo nōmo tetoaki some ane somehoko pesapo.” ");
INSERT INTO faa_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Airakano hinamo tetāne fofaraka kára seseraka kunikiane metakarikia, aporo hakāsa puraki somehoko fofoaka pusuapo. ");
INSERT INTO faa_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Purakano asekea Yasumo tetāne sapenekea peraka someraka, “Mituru, teto auaraka risikianie.” Airakano tetā pekea kakuna porokoa toke Yasuane korakea maka e kekeresapo. ");
INSERT INTO faa_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Kekererakano Yasumo someraka, “Teto namohokopo. Nōmo nī mae parisaki úyaka somehoanie. ‘Kariri hauaka á pusie. Hauaka á ano aseakosapo.’ Aíyaka somehoko pusie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Hinamo tetāne pusuakipoko aporo terakaiyamosa kunikia asekea risiane, aporo metakira Yarusarame sitia puraka, makata su ásiane pirisiti aporo káraki somesapo. ");
INSERT INTO faa_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Somesane pirisiti aporo káramo Yu aporo sisimayaki toke me rusuapo. Me rukua someaka maka aporo terakaiyamosaki mone karáka someraka, ");
INSERT INTO faa_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Aporo hinamo suaki úyaka somehoanie. ‘Ereamo isu wakakesakipoko Yasu kusua kunikia motosane ipi aporo hakāsa puramo hakimasesapo.’ Aíyaka kotafe somehoanie. ");
INSERT INTO faa_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Airakano kamani aporo unihaemo kairaka re hukurukohoamo, isiapo reane farimaka, eane matasohokosapo.” ");
INSERT INTO faa_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Airakano aporo terakaiyamosamo mone mokoa ayiáka pirisiti aporo káramo somesane ipu kakimasapo. Kakimaka kotafe somesane some koaka marekea somerakano, arirakano nōmo sawi one popana maiya amo soko, someane yaiya kotafe somerakano Yu aporo hinamomo kakimarakanapo. ");
INSERT INTO faa_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yasumo ipi aporo hakāsa pura Kariri hauaka á pusuapo. Fana Yasumo someraka ūria hiniesa á aporo hakāsa pura kinusu hikia, ");
INSERT INTO faa_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yasu aseraka kára kekeresapo. Kekereraka yia i metakiramo aseraka namina susu someraka, “Aporoane Yasureare?” Aíyaka himu tetáraka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Aíyaka hemakapukua i risiakipoko Yasu pekea someraka, “Hepene yapuramo hemakapura wakapu suane soko, hauaka omo hemakapura wakapu suane soko, anoaki kasapo. ");
INSERT INTO faa_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kasasamo hauaka sua re puraka aporo hinamomo ano patera asekeasimo some kakanie. Some kayane kakimarakano, kakimasa aporo hinamoane Ata Koti yano motosa soko, Kotimo hokosa ano yano motosa soko, Ho Kotesa yano motosa soko, isu yano motosa á paorakano, aporo hinamoane hea tapukumurianie. ");
INSERT INTO faa_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Nōmo reaki ayiakaniesane repo iaki some kakanie. Nōmo ayiakaniesane tisa aporomo somera ayiáka repo somehoanie. Hao, kaisie. Maiya suamo ano reyaki rekenapo. Maiya fa ana maiyamo soko ano reyaki yaiya rekeakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kotimo hokosa Yasu Keresoane hemakapusimo some kotesa kepomaresane oyapo. ");
INSERT INTO faa_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Wate fana Kotimo somerakano porofete aporo Aesayamo kaikia popahoareapo. Popasane oyapo. Kotimo ipi hokosaki someraka, “Hao, kaisie. Né pusiraka aporo metamo fana some kakako nōmo pusiehokosapo. Aporoamo ne ikia kara pukusane maropohokosapo. Ikia kara maropoana ayiáka aporo hinamomo himu hemakapusuane maropohokosapo. Ipu neane hemakapusimo some kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","E ima yaoa rea maiya amo aporo hinamomo kaiyako perakano epo wakapuaka someraka, ‘Unihae peakosane ikia kara makotehoanie. Ikia karane hahaesekeno maereketaehoanie,’ aihokosapo.” Aíyaka Kotimo somerakano wate fana Yasu peasiraka Aesayamo kaikia popahoareapo. ");
INSERT INTO faa_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Popasa hakása nine keseke Yone he tapukumarerane ima yaoa pukua rea ayareapo. Faserepekea reke aporo hinamoaki someraka, “Repo makata watikisane Kotimo mafahoasimo, makata watikisane metakarinie. Metakarikia eaki risikiako parirakano, re nōmo hea tapukumuriakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Aísa maiya amo, Yone rea hauaka á Yutía hauaka aeyaka soko, Yarusarame siti aeyaka soko, aporo hinamo yakai pesapo. Pekea ipu makata watikiaka rakisiane hufitaerakano i Yonemo he Yotanea tapukumurisiapo. ");
INSERT INTO faa_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Maiya amo Yonemo saro kamo itimo pasu pesane osoraka saro narikose kau terakae hikia, kitaro kesē asia nekea, wakaiyia he metekeraka nekea, ayiáka reapo. ");
INSERT INTO faa_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Reke epo some karaka, “Ano reakipoko keseke aporo kára meta peakosapo. Peraka epo ano marokehokosapo. E namo kakaro kárapo. E aporo kárasasamo, aporo raipamo epo tamakane fisina ayiáka, ano kako pekea epo tamakane nōmo fisihoane siahoasifareapo. E aporo kárasasamo, nōmo epoko raiparaka rakiako ayiane soko, ano wakasemasasamo, nōmo rakiane siahoasifareapo. Ano eyaki siasafapo. ");
INSERT INTO faa_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nōmo re hea hákasa tapukumurirakanapo. Arirakano epo re himua Ho Kotesa muriakosapo,” aíyaka Yonemo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Yasu Kariri hauaka Nasare ape aeyaka Yone rea pesapo. Perakano Yonemo e he Yotanea tapukumaresapo. ");
INSERT INTO faa_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Hea tapukumaresane ropaka hekea ima yapura hianine, tiane kikisi aka, kikisi rorakano, aseane Ho Kotesa mena nume asia ti yapunaka pekea Yasu rea pesapo. ");
INSERT INTO faa_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Perakano, ipu aseraka risiakipoko, hepene aeyaka Kotimo someraka, “Né, nōmo nī hokosapo. Néane nōmo himu tumurumo hemakapukua seserakanapo.” Aíyaka somerakano kaisiapo. ");
INSERT INTO faa_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ho Kotesamo Yasuaki someraka, “Ne ima yaoa rekeako pusie,” airakano pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pukua sere foti amo (40) Yasu ima yaoa reakipoko, Satanemo e mokopipihokosakipoko perakano asesapo. Arirakano yasaro soko, yákasa soko pesapo. Perakano yia hepene aporomo e arareraka asekea risiapo. ");
INSERT INTO faa_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Herotemo Yone tipura makesakipoko Yasu Kariri hauaka á pukua Kotimo some kotesane some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Some karaka, “Kotimo murikimasa maiyane fasereperakanapo. Yumo Koti ipi unihaeaka asekea rekeakosa maiya ane fasereperakanapo. Asiasamo repo himu watikisane metakarikia eaki risikiako parirasie. Kotimo some kotesane kakimasie,” aísapo. ");
INSERT INTO faa_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yasu he Kariri fua pukua reke aseane Saemone soko ipi mamanea Enitu soko tetapō pokoa mokoako hea kasipu kokomareraka risikino asesapo. Arirakano tetapō makata rakirane pokoa pisinisi rakirapo. ");
INSERT INTO faa_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Asiamo Yasumo tetāki someraka, “Ano patera asesie. Ano patera aserakano tetápo pokoa amora ayiáka aporo hinamo anoa paohokosane pasimokoasimo nōmo teto murikimarakanapo.” ");
INSERT INTO faa_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Aíyaka somerakano tati kasipuane wate foakayia metakarikia Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Wakasema pukua Yasumo aseane Sepetemo maeya Yamesepe ipi mamanea Yone tetā kasua risike kasipu potakahesa petokoraka risikino asesapo. ");
INSERT INTO faa_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Aseraka tetāne peasimo Yasumo wásapo. Wárakano tetapō wafaya Sepeteane soko, ipi aporo raipane soko, i namina kasu yia risikino metakarikia, tetā Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Kapaneame taonea pauraka fenena maiya amo, Yu aporomo sarimana apea pukua Yasumo some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Some karakano aporo hinamomo kaikia fofaraka himu fasapo. Kotimo somemane tisa aporomo some akara ayiáka, aporomanomo hemaka apura ayiáka, Yasumo some kasafapo. Aporo yano motosa fanamo some akara ayiáka some karakano kaikia, “Someane enahoasifareapo,” aíyaka aporo hinamo kára fofasapo. ");
INSERT INTO faa_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Arirakano Yu aporomo sarimana apea, aporo hakása yatafumo e ho masa reke ");
INSERT INTO faa_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","epo wáraka, “Yasu né Nasare aporopo. Nómo isu yatafuane mayiakakosare? Isu mokoatikirako pesare? Né nōmo aserapo. Ne Kotimo pusiesane né Kotimo ipi hokosasamo namo kakaro kotesane népo.” ");
INSERT INTO faa_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Airakano Yasumo yatafuaki someraka, “Wae, nómo mehokopo. Nómo aporo ho masane metakarikia pusie.” ");
INSERT INTO faa_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Airakano yatafumo aporo ho masane mahamisisiraka marekea, aporo ho masane metakarikia ipi kokoaeraka wárape pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Purakano asekea aporo hinamo su risiane fofaraka, namina susu someraka, “Ane marirakanarakapo. Some akarane some kawereapo. Aporo hokopusuamo some akara ayiáka some akare. Kotimo ipi ayiakaniesane kekemaraka yatafu pusierakano yatafumo kakimaka apure,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Aíyaka aporo hinamo Kariri hauaka sua pukua, Yasumo makata rakisiane aporo hinamo suaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yu aporomo sarimana apeane Yasumo metakarikia pukua Enitupe Saemone tetapō apea pukua yororakano, Yamesepe Yone tetā soko apea yorokoa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Puane ipu Yasuaki foakayia someraka, “Saemonemo ipi aseamo kaīyia kau sisipuraka makata takamaka warekenapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Airakano hinamo makata takamasa warea á Yasu pukua hinamoane hokonoa maka e máfahoane kau sisipusane fasapo. Farakano hinamoamo ipoko makata nakosa paikia kasapo. ");
INSERT INTO faa_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Arirakano wakasema nina maiya tuakeramo aporo hinamo metakira makata tasane soko, aporo hinamo metakira yatafumo i ho mosane soko, Yasu rea karikia pesapo. ");
INSERT INTO faa_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Karikia perakano aporo hinamo yakai Saemonemo ape ikia koroa sarimaraka kau risiakipoko ");
INSERT INTO faa_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Yasumo aporo hinamo yakai makata tasa kekepoane mafasapo. Yatafu yakaiaki metakarikia pusierakano pusuapo. Yatafumo Yasuane hemakapusuasamo, Yasumo iaki someraka, “Repo mehokopo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mituru fiahoko makeanamo Yasu takahikia pukua, ima yaoa aporo fasakipoko á kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Kurikurihoko pusuakipoko Saemone soko, ipi aporo táke soko, ipu Yasu koako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Pukua ipu Yasuane kokoa aseraka someraka, “Né aporo suamo korakanapo.” ");
INSERT INTO faa_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Airakano iaki Yasumo someraka, “Ape sumu metakira soko ano purakapo. Pukua apea nōmo Kotimo someane some kakakosapo. Asiamo Kotimo someane some kakako ano hauaka kára wo pesapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Yasu Kariri hauaka ape sumu sua koraka reapo. Koraka reke Yu aporomo sarimana apea some kakako pukua, Yu aporomo sarimana ape meta soko some kakako pukua, Yu aporomo sarimana ape meta soko, some kakako pukua asiapo. Yatafuaki soko Yasumo pusierakano pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yasu rea aporo toropakesa pesapo. “Yasuane yano motosa kárapo,” aíyaka hemakapukua e kakuna porokoa kake someraka, “Nómo ano mafahoko seseraka soko metao seserire?” ");
INSERT INTO faa_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Airakano aporoane Yasumo kamenakaraka ipi hokono máfaraka e sakairaka someraka, “Ao, ano seseripo. Né makata takamasane farasie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Aihoanine aporo toropakesane wate foaka fasapo. ");
INSERT INTO faa_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Faraka e siaraka rekeno asekea Yasumo aporo toropakesaki me paroaka someraka, “Né pusie. ");
INSERT INTO faa_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ne toropakesa fasane aporo metakiraki somehokopo. Piriape aporo rea á né pukua, kau toropakesa fasane piriape aporoaki tarinie. Tarikia Mosesemo somemaneane kekemaraka makata yaku Kotiaki kakaniesane yaiya kakanie. Makata kakakosane piriape aporomo Kotipoko taehokosapo. Taena maiya amo né kau toropakesane kakaro fasapo, airakano aporo hinamo suamo kaikia hemakapukusapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Somerakano yia, aporo toropakesa fasamo kakipayaraka pukua aporo hinamo suaki somesapo. Someaka haerakano aporo hinamo suamo kaisiapo. Yasu reakipoko aporo hinamo su peraka, taperapaka taone sua Yasu pusuafapo. Yasuane ima yaoa reapo. Ima yaoa rekeno aporo hinamo yakai peraka, sape akayaka soko, sape royaka soko, taku rayaka soko, taku atura aeyaka soko, aporo hinamo su Yasu rea pesapo. ");
INSERT INTO faa_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sere hakása soko metao, sere tetá soko metao farakano, Yasu Kapaneame taonea paripesapo. Yasuane paripesapakano aporo hinamo suamo kaisiapo. ");
INSERT INTO faa_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Kaikia aporo hinamo yakai pekea sarimaraka ape tapesapo. Ape taperaka ikia koroa kausekeno, Yasu ape kakaru tipia reke, aporoaki some kotesane some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Some karaka rekeno aporo kitafasumo aporo korosakataesane fefeneakua makekea, maka pekea ");
INSERT INTO faa_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","aseane, aporo hinamo kára sarimasakipoko, Yasu rea pusifasekeno, aporo korosakataesane maka ape kopo yapura maka hikia, Yasu ipi rea unia kima aeyaka ape kopo feteketaeraka, ape kopo aeyaka fefeneaku tau metafirirakano metafirirakanoraka, asukuru Yasu rea á motosapo. ");
INSERT INTO faa_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Motoraka aporo korosakataesa maka pesa aporo kitafasuamo Yasuaki himu hakásaraka hemakapurakano asekea, Yasumo aporo korosakataesaki someraka, “Hameo, né himu watikisane nōmo mafarakanapo.” ");
INSERT INTO faa_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Airakano Kotimo somemane tisa aporo metakira á toamo namina susu hemakapuraka, ");
INSERT INTO faa_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Koti ipi hákasamo aporo himu watikisane mafánapo. Aporomanomo mafánafapo. Asiamo Yasumo Kotiane mawakasemarakae. Epo aíyaka somehoane siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Aíyaka ipu hemakapurakano, wate foaka ipu hemakapusuane Yasumo aseraka iaki someraka, “Repo marirakano ano mahokoparirakanare? ");
INSERT INTO faa_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aporo korosakataesaki nōmo someraka, ‘Né himu watikisane nōmo mafarakanapo,’ airane wafororakanafapo. Himu watikisa faraka soko metao, fahoanafonoraka soko metao, repo aserafapo. Asiāne nōmo someraka, ‘Né makata takamasane nōmo mafarakanapo,’ airane wafororakanapo. Aporo korosakataesa takahirane repo aserakanapo. ");
INSERT INTO faa_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Aporomanomo Tákeane anopo. Hauaka wo aporo hinamomo himu watikisane nōmo mafahoasimo, Kotimo ipi anoaki ayiakaniesapo. Ayiakaniesa hakása yine nōmo maka, repo asekeasimo aporo korosakataesaki nōmo takahisierakanapo.” Aíyaka Yasumo aporo korosakataesaki someraka, ");
INSERT INTO faa_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Takahikia, asakapu maweroraka ní apea maka pusie.” ");
INSERT INTO faa_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Airakano aporoane takahikia ipi asakapu wate foakayia maweroraka maka pusuapo. Maka purakano aporo hinamo suamo asekea himu faraka, Kotiaki kekereraka someraka, “Fana makata aina ane isiapo asesafapo. Pipu makata hakureapo,” aíyaka ipu suamo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yasu he kekea kaya á pukua he fua reke aseane, aporo hinamo yakai sarimarakano, Yasumo iaki some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Some kaka faraka pukua Yasumo aseane, Afiasemo maeya Rífai ane ipi takese mora oposea kakeno asesapo. Asekea someraka, “Né ano patera aseako peae.” Airakano Rífai takahikia Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pukua Rífaimo apea pauraka, ape namoa yorokoa Yasu soko, ipi aporo hakāsa pura soko, toke iyaki aporo himu watikisa soko, takese mora aporo metakira soko, sarimaraka namina hakāsa makata nenaka toapo. Aporo yakai toane metakira Yasuane kekemaraka pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kekemaraka pusua aporoane metakira aporo watikisa soko, takese mora aporo soko, i Yasuyaki hakāsa toke makata nenakano, Ferese aporomo namina somemane tisa aporomo asesapo. Aseraka ipu Yasumo aporo hakāsa puraki someraka, “Takese mora aporoyaki aporo himu watikisayaki Yasu hakāsa toke makata anenane kakaro watikirareapo.” ");
INSERT INTO faa_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aírakano Yasumo kaikia iaki someraka, “Aporo koteaka reane mitikoromo mafahoasimo purafapo. Aporo makata takamasane mitikoromo mafahoasimo purapo. Asiamo aporo hinamomo himu watikiaka risiane, ipu watikisane metakarikia risikiako parihoasimo, iaki peaehoko ano perakayiapo. Aporo kotesane peaehoko ano perakayiafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Maiya metamo Yone he tapukumareramo ipi aporo hakāsa puramo soko, Ferese aporomo soko, makata nakosa sokoairaka risiapo. Sokoairaka risia maiya amo aporo metakiramo Yasuaki someraka, “Nómo aporo hakāsa puramo makata nakosa sokoaihoanafononane mainakanonare? Yonemo ipi aporo hakāsa puramo makata nakosa sokoainapo. Ferese aporomo ipu aporo hakāsa puramo makata nakosa sokoainapo. Asiāne nómo aporo hakāsa puramo makata nakosa sokoainafapo.” ");
INSERT INTO faa_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Airakano Yasumo takumeaka someraka, “Aporomo hinamo arumarakano, aporo suamo hokono keraka seseaka makata nenapo. Makata nenaka aporo hinamo kawe apia iyaki hakāsa rekeno, i himu hisihoanafonoraka i seseraka risike, makata nakosane sokoainafapo. ");
INSERT INTO faa_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Arirakano aporo hinamo kawe apia aporo metakiramo waseremaka apura maiya amo, himu hisiraka makata nakosane sokoaihokosapo. ");
INSERT INTO faa_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Arirakano pasu paté koasakipoko pasu kawe paremarekea irisane, pasu kaweane kuruhenaka pasu patéane fe taku aeyaka hatirirurapo. Hatiriruraka kára koahokosapo. Anapaka pasu patéyaki pasu kaweyaki sarimaraka irinafapo. ");
INSERT INTO faa_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Arirakano nanikose kau aporomo maka petoro asia ayiáka irinapo. Waene he kawe metekesane petoro patéa takamanafapo. Takamarakano waene he kawemo ponoponoraka petoro patéane faurakosapo. Fauraka petoro kakeraka waene heane sakuriakosapo. Sakuriraka waene he soko, petoro soko, tetákara fahokosapo. Arirakano waene he kawe metekesane petoro kawea takamarakano, petoroane faunafapo.” Aíyaka Yasumo ipi some kawe kasane soko, ipu fana somesane soko, tetane sarimaraka kekemahoane siahoasifareapo, aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Fenena maiya hakása metamo, witi hemoa Yasu soko, ipi aporo hakāsa pura soko i pusuapo. Puraka aporo hakāsa puramo witi hae susane tukua nesapo. ");
INSERT INTO faa_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nenakano Ferese aporomo aseraka Yasuaki someraka, “Nómo ní aporo hakāsa puramo makata aturane asesie. Ipu makata arakirane fenena maiyamo yaposapo. Yaposane mamosoanane mairakanonare?” ");
INSERT INTO faa_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Airakano asekea, Yasumo ipu hasaka hemakapusuane tariakosakipoko, Tefeteane Kotimo sawia popasane iaki someraka, “Wate fana pirisiti aporo kára ipi yano motosa Apiata, e rea maiya amo, Tefete soko ipi aporo hakāsa pura soko meamosapo. Meamosa maiya amo, Tefete ipi Kotimo apea yorokoa aseane, Kotipoko farawa taesane Apiatamo karakano Tefetemo nenaka, ipi aporo hakāsa puraki soko, farawa taesane kasapo. Kasáne Kotipoko farawa taesane aporo hinamo ipu nakohoamo yapo motosapo. Pirisiti aporomo namina hákasa makata nenáne yaposafapo. Asiāne Tefete ipi pirisiti aporohoanafonosa yiamo farawa yaposane nesapo. Aíyaka Kotimo sawia popahoareapo. Popasane repo menoraka kepoane hemakapurakarire? Wae, repo hemakapurakarifapo. ");
INSERT INTO faa_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Arirakano aporo ararehokosakipoko fenena maiyane Kotimo maresapo. Fenena maiyane makotehokosakipoko aporoane maresafapo. ");
INSERT INTO faa_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Aporomanomo Tákeane anopo. Yape fenena maiya amo makata aina ane ano unihaeaka rekenapo.” Aíyaka Yasumo Ferese aporoaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Efera hunia Yu aporomo sarimana apea Yasu yorokoa aseane, aporo hokono narisane rekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Arirakano fenena maiya amo aporo hokono narisa Yasumo mafarakarihoamo, Ferese aporomo asekea risisapo. Fenena maiya amo Yasumo rakirakano asekea hukurukusakipoko, asekea risiapo. ");
INSERT INTO faa_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Asekea risikino, Yasumo aporo hokono narisaki someraka, “Né pekea tipi o reae,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aíyaka epo Ferese aporoaki someraka, “Fenena maiyámo koteaka rakiane soko metao, watikiaka rakiane soko metao, makata rakira meta mamo Kotimo somemaneane mamosorakarire? Aporo meta kurapaka ararenane soko metao, aporo meta rurane soko metao, makata meta mamo Kotimo somemane mamosorakarire?” Airakano ipu me kausapo. ");
INSERT INTO faa_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Me kaurakano asekea, Yasumo saperaka iane asekehaesapo. Aseane ipu himumo kakimako hisirakano asekea Yasumo iaki himu mahisisapo. Asiāne epo aporo hokono narisaki someraka, “Né hokono máfaraka raerasie.” Airakano hokono raehoane narisane fasapo. ");
INSERT INTO faa_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Aporoane hokono narisane farakano asekea, Ferese aporoane Yu aporomo sarimana apeane metakarikia pukua, wate foaka Kini Herotemo ipi aporo raipayaki namina susu someaka maraka, “Yasuane kukusimo isiapo rukusapo. Isiapo mayiáka rukusare?” aíyaka someaka masapo. ");
INSERT INTO faa_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yasu ipi aporo hakāsa pura soko, pukua he kekea kaya á pusuapo. Purakano iyaki aporo yakai asekehaerape pusuapo. Pusuane Kariri hauaka aeyaka soko, Yutía hauaka aeyaka soko, ");
INSERT INTO faa_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Yarusarame siti aeyaka soko, Itumea hauaka aeyaka soko, he Yotane yaoraka hauaka taku aeyaka soko, Saetone taone aeyaka soko, Taia taone aeyaka soko, aporo hinamo yakaimo kaiyiane Yasumo aporo hinamo makata takamasane mafasapakano kaikia, ī é rea pesapo. ");
INSERT INTO faa_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Aporo hinamo pesane ī yakai makata tasane Yasumo mafasapo. Mafarakano asekea aporo hinamo makata tasa suamo Yasuane kaua sakaihoko pesapo. Pekea ipi kaua ipu suamo sakairakano asekea Yasumo ipi aporo hakāsa puraki someraka, “Aporo hinamo kára peraka taperipo. Asiamo ano kasua kakakosapo. Kasu he fea sakomo kita humareanie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Airakano aporo hinamo tua yatafu risiamo Yasuane asera yiamo Yasu hikumisia hurupekea wareke wáraka, “Né Kotimo hokosapo.” ");
INSERT INTO faa_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Airakano Yasumo yatafuaki someraka, “Aporo hinamo suamo kaiyakohoamo ano Kotimo hokosapo, aihokopo.” Aíyaka Yasumo paroaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yasu ūria hinaka, Yasumo ipi aporo sesesa susuane peaesapo. ");
INSERT INTO faa_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Perakano asekea, aporo kenosu murikimasapo. Murikimasane i tarira aporopo, aisapo. Murikimasane eyaki kikinaraka hakāsa pukusakipoko murikimaka, arirakano epo someane some kakakosakipoko murikimaka, ");
INSERT INTO faa_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","arirakano yatafuane metakarikia pusie aihokosakipoko murikimaka ayiáka rakisimo iaki wakapuane kasapo. ");
INSERT INTO faa_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Asiamo aporo kenosu murikimasane oyapo. Saemone ipi yano motosa metane Pita, aíyaka Yasumo yano motosapo. ");
INSERT INTO faa_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Arirakano meta Sepetemo maeya Yamese, arirakano meta Yamesemo ipi mamanea Yone tetā ane Poanesi, aíyaka Yasumo yano motosapo. Ipu Poanesi yano motosa kepoane namo meaka Yao Kikirira aíyaka yano motosapo. ");
INSERT INTO faa_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Arirakano meta Enitu, arirakano meta Firipi, arirakano meta Patóromiu, arirakano meta Matiu, arirakano meta Tomase, arirakano meta Afiasemo maeya Yamese, arirakano meta Tátiase, arirakano meta Rome kamanimo Yu aporo asekea reane metakariakosakipoko hemakapura aporo Saemone, ");
INSERT INTO faa_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","arirakano meta Yasu parakehokosa aporo Yutase Isekerio, ayiáka Yasumo aporo kenosu murikimasapo. Murikimaka faraka Yasu ipi apea pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Efera hunia Yasu reakipoko aporo yakai sarimaraka kárasekeno maiya suamo Yasumo makata rakiraka reke, epo soko ipi aporo hakāsa puramo soko, ipu makata nesafapo. ");
INSERT INTO faa_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Makata nesafapakano, Yasumo ipi aporo iramo kaisiapo. Yasu masuasapakae, aisasamo ipu Yasu pasimako pesapo. ");
INSERT INTO faa_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Arirakano Kotimo somemane tisa aporo Yarusarame siti aeyaka pekea ipu someraka, “Yatafumo unihae yano motosa Piaósipumo, Yasu ho maka, e Yasuyaki hakāsa reasasamo, Piaósipumo wakapuane Yasumo maka yatafu pusierakano apure.” ");
INSERT INTO faa_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Airakano Yasumo iaki someraka, “Re su peae.” Aíyaka perakano asekea Yasumo iaki takumeaka someraka, “Satanemo ipi yia aporo raipane mayiáka pusierare? ");
INSERT INTO faa_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Aporo namina hauaka hakása risia yiamo parakuraka weraka aporoane koaka tarikia kekepo kekepoaka risike ape kauanehokosapo. ");
INSERT INTO faa_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Arirakano aporo ira hakása namina parakuraka weraka arupukua fahokosapo. ");
INSERT INTO faa_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aina ayiáka Satanemo yatafuaki pusie satiki, ipi táke tati awera ayiáka weafunupo. Satanemo ipi aporo tákeyaki parakuraka wera satiki, i arupukua fahoafunupo. ");
INSERT INTO faa_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Arirakano aporo metamo aporo warēmo apea makata kemo hakimokoariraka, fana aporo warēane sakomo taporaka motokoa marekea, ipi apea yorokoa makata hakimorapo. Aporo warēane tapohoasiraka, ipi yaiya warēraka rekeno asekea ipi apea hakimokoako yorokoa purafapo. ");
INSERT INTO faa_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Asiamo nōmo reaki kakaro somerakaripo. Aporo hinamomo kekepo watikiaka rakirapo. Watikiaka rakirane soko, Kotiane mawakasemaraka somerane soko, Kotimo mafahokosapo. ");
INSERT INTO faa_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Asiāne Ho Kotesane aporo hinamomo mawakasemarakano, yumo soko, keseke soko, Kotimo kakaro mafahokosafapo. Aporo hinamomo Ho Kotesane mawakasemaraka somesasamo, makata watikisane iyaki yaiya rekeakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Asiamo ipu someraka, “Yatafumo Yasu ho masasamo Yasumo wakapuaka arakire.” Aisa akipoko Yasumo iaki aíyaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Yasumo ipi kaīyia soko, ipi mamanea soko pesapo. Pekea hauaka moroa risike someraka, “Yasu peaehoanie.” ");
INSERT INTO faa_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Airakano aporo hinamo yakai Yasuyaki hakāsa sarimaraka toamo Yasuaki someraka, “Nómo ní ama soko, ní mae soko, ní papā soko, hauaka moro atura risike, né peaerakae.” ");
INSERT INTO faa_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Airakano Yasumo someraka, “Nōmo ama soko, nōmo mae soko, kepoane kaisie.” ");
INSERT INTO faa_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Aíyaka eaki himu hakásaraka hemakapura aporo hinamo toane Yasumo asekehaeraka someraka, “Nōmo ama asíane soko nōmo mae asíane soko repo. ");
INSERT INTO faa_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Asiamo aporomo soko, hinamomo soko, Kotimo hemakapusuane kekemaraka rakirakano aporo hinamoane nōmo mae nōmo papā nōmo ama asíapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yasu he fea pukua efera hunia iaki some kasapo. Some karaka reke aseane aporo hinamo yakai sarimarakano asekea, ipi takahikia pukua kasu hea tapuku reakipoko e kasua reke, aporo hinamo he fua risiaki some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Some yakai takumeaka some kasapo. Ipu hemakapusimo someraka, ");
INSERT INTO faa_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Hao, kaisie. Aporomo makata mano poterape pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Poterape pusua maiya amo makata mano metakira ikia kara hurupepesapo. Hurupepesane menamo nesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Arirakano makata mano metakira eke kima hauaka wakasemasakipoko hurupepesane foaka tanehesa nine, pikinu koteaka pusuafapo. ");
INSERT INTO faa_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pikinu koteaka punafonosasamo maíyamo ruraka sisipuraka kuane yoferaka kukua kesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Arirakano makata mano metakira makata mano keta risia arakarua hurupepesapo. Hurupepesane makata mano keta risia akiyaki hakāsa tanehesapo. Tanehenaka makata keta risiane popakeraka, makata manoane karotapiraka serekeraka wate pesafapo. ");
INSERT INTO faa_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Arirakano makata mano metakira hauaka kotesakipoko hurupepesane tanehekea wate pesapo. Wate peraka, metakira wate teti su (30) pekea, metakira wate sekeseti su (60) pekea, metakira wate wane harote su (100) ayiáka pesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Re senaki risiamo kairaka koteaka kaisie. Kaikia hemakapunie.” Aíyaka Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Aporo hinamo yakai pukua fasekeno aporo hukusi Yasuyaki risike, aporo kenosu fana murikimasane Yasuyaki risike ipu Yasuaki someraka, “Takume kepoane yakapare?” ");
INSERT INTO faa_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Airakano Yasumo iaki someraka, “Repo kaiyisimo Koti unihaeaka rea mahamesane pipu yumo some kepoane reaki hufitaeraka somerakanapo. Asiāne nōmo murikimakanafonosa aporoaki takumeaka susu somerakanapo. ");
INSERT INTO faa_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kotimo sawia poparaka ayiakakosapo, aisa amo kepoane porofete aporomo kakaro popahoareapo. Popasane oyapo. ‘Aporo hinamomo himo aseraka aseakosapo. Asesa nine kepoane koteaka hemakapurafapo. Ipu senakimo kairaka kaiyakosapo. Kaisia nine kepoane koteaka hemakapurafapo. Ipu himumo koteaka hemakapukusane hisiraka risirapo. Asiamo ipu himu watikisane metakarikia Kotiaki risikiako parisa satiki, Kotimo ipu watikisane mafahoafunureapo.’ Aíyaka porofete aporo Aesayamo popahoareapo.” Aíyaka Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Yasumo ipi aporo hakāsa puraki someraka, “Repo takume some one kairakarifare? Takume some one hemakapunafonoraka repo takume suane mayiáka kepoane hemakapukusare? ");
INSERT INTO faa_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Hao, kaisie. Makata mano poterape pura aporo asiane, Kotimo some kará aporopo. Makata mano asiane, Kotimo somepo. ");
INSERT INTO faa_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Makata mano ikia kara hurupepesa asiane, aporo ikia kara fea risiamo Kotimo someane some kasane kairakano, Satane wate foaka pekea someane hakimarapo. ");
INSERT INTO faa_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Arirakano eke kima hurupepesa asiane oyapo. Aporomo Kotimo someane kairaka wate foaka someane seseaka kaikia hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pikinu koteaka punafonona ayiáka koteaka kakimaka rerafapo. Makata watikisa fasereperakano soko metao, Kotimo some kakimasa aporoaki mokoatikirakano soko metao, Kotimo someane maiya wakasema kaisia nine, foaka metakarirapo. ");
INSERT INTO faa_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Arirakano makata mano keta risia arakarua makata mano hurupepesa asiane oyapo. Aporomo Kotimo someane kaikia yia ");
INSERT INTO faa_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","hauaka wo makata tomekesa kára hemakapurane soko, mone kára mokoako seseraka hemakapurane soko, hauaka wo makata ane mokoako totoraka hemakapurane soko, makata isia amo Kotimo someane karotapiraka wate koteaka perafapo. Wate peanafonosa ayiáka, aporo hinamo metakiramo Kotiane hemakapusimo soko, Kotimo sesehoasimo soko, ayiáka rakiako hemakapurafapo. ");
INSERT INTO faa_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Arirakano hauaka kotesakipoko hurupepesa asiane oyapo. Aporomo Kotimo someane kaikia kakaro kakimaka risikino, wate apera ayiáka perapo. Wate perane metakira teti su (30), metakira sekeseti (60), metakira wane harote su (100) ayiáka wate tumokoasimo kára perapo.” Aíyaka Yasumo takume amo kepoane somesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yasumo ipi aporo hakāsa puraki someraka, “Nafa pakimaka motokoa taramomo karotapirare? Nafane ape wara pete petaua motorare? Wae, nafa pakimaka apea waremarerapo. ");
INSERT INTO faa_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Aina ayiáka Kotimo some faremaresane kakamaraka mafekemahokosapo. Makata mahamesane hufitaehokosapo. ");
INSERT INTO faa_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Re senaki risiamo kairaka, koteaka kaisie. ");
INSERT INTO faa_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Nōmo someane koteaka kaikia hemakapunie. Repo makata akara ayiáka reaki kakakosapo. Makata meta soko ripaka marekea kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aina ayiáka repo nōmo someane koteaka hemakapuko, kepoane kope pukua hemakapurakano, some meta kepoane soko hemakapusimo Kotimo né ararehokosapo. Asiāne nōmo someane koteaka kokoa hemakapunafonosasamo, fana makata kaisiane soko meraruhokosapo.” Aíyaka Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yasumo someraka, “Aporo hinamomo Kotiane hemakapusuasamo Kotimo iane unihaeaka asekea rerapo. Asekea rera asiane oyapo. Aporomo koane hae poteraka marekea, ");
INSERT INTO faa_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","apea hikia ereamo waka mituru fiarakano turikia pukua, maiya suamo ariraka rekenone makata mano potesane taneherapo. Sere soko ereamo soko taneherapo. ‘Mayiáka pauaka herare?’ Aíyaka aporoamo mahimeteraka, ");
INSERT INTO faa_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","arirakano makata mano ipi hemakapukua hauaka aeyaka pauaka hekea, fana ku murikia, amo tipia huhu murikia, amo keseke koane namo nakosane torapo. ");
INSERT INTO faa_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Koane namo nakosane namoraka parosekeno, aporomo tumarapo. Marirakano tumarare? Namo nakosa maiya á pausekeno tumarapo.” Aíyaka Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yasumo someraka, “Kotimo unihaeaka asekea reane makata yakapa asíare? Repo hemakapusimo takume somehokosane yakapa somehoasimore? ");
INSERT INTO faa_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kotimo aporo hinamo unihaeaka asekea rea asíane oyapo. Ira máseta hae aporomo ipi hemoa potesa asiapo. Máseta haeane namo kakaro wakasemapo. Hae meta wakasema ayiáka anafapo. ");
INSERT INTO faa_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Máseta hae kakaro wakasema yiamo, pauaka henaka hemoa makata porosane marokeraka ira pariraka káranapo. Káraraka reakipoko ira eya á mena koraka torane pekea menamo ape kirapo. Aina ayiáka fana Kotimo aporo hinamo hukusiane unihaeaka asekea rea nine, keseke aporo hinamo kárane unihaeaka asekea rekeakosapo.” Aíyaka Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yasumo ipi someane aporo hinamomo hemakapusimo epo takume yakai some kasapo. Some kasane ipu sia kairakano, some takume metakirane soko some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Aporo suaki epo takumeaka hakāsa somesapo. Arirakano ipi aporo hakāsa pura namina hákasa risike some kepoane hufitaeraka somesapo. ");
INSERT INTO faa_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Maiya hakása yiamo samapu yao nene horamo, Yasumo ipi aporo hakāsa puraki someraka, “Isu he Kariri taku ra purakapo.” ");
INSERT INTO faa_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Airakano aporo su sarimasane metakarikia, Yasu kasua kakeno i soko, kasu yia ripaka pusuapo. Kasu meta soko aporo metakiramo rokoa hakāsa purakano asekea ");
INSERT INTO faa_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yasu kasu kenoa kake uni kata motokoa wareapo. Wasakipoko yao peraka atifo soko, he kupayaki kára pesapo. He kupa kára peraka, kasu tua he wakekeraka, kasu kenepesahopo. ");
INSERT INTO faa_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kenepeakorakano asekea, aporo hakāsa puramo Yasu maturikia someraka, “Tisao, isu he nekea kukua keasireapo. Nómo isu hemakapurakarire?” ");
INSERT INTO faa_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Airakano Yasu turikia pukua atifoaki soko, he kupaki soko someraka, “Farasie. Auarasie.” Airakano atifo soko, he kupa kára pesane soko fasapo. ");
INSERT INTO faa_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Farakano asekea Yasumo iaki someraka, “Repo marirakano namorakanare? Repo anoaki kakaro himu hakásaraka hemakapurakanafareapo.” ");
INSERT INTO faa_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Airakano i fofaraka namina yia someraka, “Yasumo someane atifomo soko, he kupamo soko, kakimaraka fane. Ayiáka arakirane e aporo eparakapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","He Kariri kekea kaya kasu rokoa hikia, Kerasa hauaka á kasu karimarekea ");
INSERT INTO faa_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","hikia aseane, yatafumo aporo ho masa sapenako pesapo. ");
INSERT INTO faa_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Aporoane aporo kusua taena kunikia á reke, eane aporo metakiramo tapohoane soko siasafapo. E mokowerakano waya hatisamo soko tapohoane siasafapo. ");
INSERT INTO faa_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Fana maiya káramo aporo ho masane wayamo epo hokono soko korake soko taposapo. Taposane ipi warēraka wakapuraka wayane marutusapo. Maruturakano aporomo e mako ayiane soko, ipi wakapu siasafapo. ");
INSERT INTO faa_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ereamo soko, sere soko, e kunikia reke, ūria hikia nenakamaka wirisusuraka koraka reapo. Ipi kaua ekemo rusuane yokoaemosususapo. ");
INSERT INTO faa_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yameno anaka epo Yasuane aseraka foaka Yasu rea pekea kakuna porokoa kake Yasuaki kekeresapo. ");
INSERT INTO faa_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Kekererakano asekea Yasumo yatafuaki someraka, “Yatafu né ho watikisapo. Né aporoane metakarikia pusie,” aisapo. Airakano yatafumo aporo ho masane tura reke sakepamo wáraka someraka, “Yasuo, ne namo kakaro unihae Kotimo hokosao, nómo ano mayiakakosare? Nómo ano fanasiraka kau teraka yaiya rerane kakakopo.” ");
INSERT INTO faa_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Airakano Yasumo someraka, “Né yano motosa epare?” Airakano yatafumo someraka, “Isu mukisakipoko ano yano motosa Mukisapo. ");
INSERT INTO faa_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Hauaka one metakariako hisiripo. Hauaka one metakarikia pusiehokopo.” ");
INSERT INTO faa_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aíyaka ipu aseane saro yakai ūri kakafaea makata nenakano aseraka someraka, ");
INSERT INTO faa_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","“Nómo isu pusierakane saroane tua risikiako pusiesie.” ");
INSERT INTO faa_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Airakano Yasumo someraka, “Ao. Ayisie.” Airakano yatafumo aporo ho masane metakarikia pukua saro tua risiapo. Risikirakano saro su tu taosene ane (2,000) ūri kakafae aeyaka foaka sosonoraka peraka, he fesere mosakipoko aeyaka eteraka, he numua hurupeperaka saro suane he nekea kukua kesapo. ");
INSERT INTO faa_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kukua kerakano asekea, saro asekea risia aporoane teketarikia apea hikia, apea risia aporoaki soko, ima risia aporoaki soko someraka, makata su asesane somesapo. Somerakano aporo suamo makata ásiane aseako pesapo. ");
INSERT INTO faa_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Pekea Yasu rea aseane, aporo ho yatafu mukisamo fana masane, koteaka reke pasu osoraka koteaka hemakapukua rekeno asesapo. Aseraka namosapo. ");
INSERT INTO faa_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Asesa aporoamo aporo yatafumo ho masa mafasane soko, saro kukua kesane soko, makata su asesane somesapo. ");
INSERT INTO faa_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Somerakano aporo suamo Yasuaki someraka, “Isiapo hauaka one metakarikia, ne pusie.” ");
INSERT INTO faa_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Airakano Yasu kasu ripaka pukusakipoko rekeno, aporo ho masa mafasamo someraka, “Ano neyaki hakāsa perakapo.” ");
INSERT INTO faa_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Airakano Yasumo waesapo. Waeraka epo someraka, “Ní apea parihikia, ní aporo tákeaki Unihaemo né araresane somehoanie. Unihaemo ne kamenakaraka hemakapukua araresane somehoanie.” ");
INSERT INTO faa_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Airakano aporoane paripukua, ape sumu kaeyakosu yano motosa Tekáporisi á someraka, “Yasumo ano uyáka araresapo.” Airakano aporo su fofasapo. ");
INSERT INTO faa_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yasu kasua ripaka pukua he Kariri kekea kaya taku ra poparipukua aseane, aporo hinamo yakai sarimaraka risikino asekea Yasu he fea reapo. ");
INSERT INTO faa_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Reke aseane Yu aporomo sarimana ape asekea rea aporoane pekea, ipi yano motosa Yairasepo. Yairase pekea Yasu aseraka kakuna porokoa kake epo ");
INSERT INTO faa_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Yasuaki someraka, “Nōmo hinamo hokosa kukusireapo. Asiasamo nómo hokonomo e sakairako peae. Sakairakano e makata tasane faraka e kukusafapo.” ");
INSERT INTO faa_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Airakano Yasu eyaki hakāsa pusuapo. Tetāyaki aporo hinamo yakai hakāsa kafukua pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Kafukua purakano, hinamo meta patera aeyaka pekea, ipi keremisi kenosumo wake apea makama yiaraka kayapo. ");
INSERT INTO faa_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Maiya káramo mitikoro aporo metakiramo rakiane soko hinamoane ipi fasafapo. Epo mone suane mitikoro aporoaki kaka, asiāne soko fahoanafonoraka ipi makata takamasane kárasapo. ");
INSERT INTO faa_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Makata takamasa káraraka kake, Yasumo aporo hinamo makata tasa mafarakanapakano kaikia, hinamoamo ipi himumo hemakapuraka, “Yasumo pasua nōmo sakaihoane, ano wake apea makama yiaraka kayane fahokosapo.” Aíyaka hemakapukua Yasu patera aeyaka pekea ipi pasua sakaisapo. ");
INSERT INTO faa_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Sakaihoane wate foaka ipi wake apea makama yiaraka kayane fasapo. Farakarakano kaisiapo. ");
INSERT INTO faa_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Arirakano Yasu ipi meraruamo puraka reke kaiyiáne, ipi wakapu purakarakano kaisiapo. Kaikia ipi pariaseraka, aporo hinamo suaki someraka, “Epamo nōmo pasua sakairakayiare?” ");
INSERT INTO faa_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Airakano ipi aporo hakāsa puramo someraka, “Wae. Aporo hinamo yakaisakipoko nómo mayiáka aseakosare? Ipu né kaua hisirimaka purakayiapo. Pasua sakaianane marirakano airakanare?” ");
INSERT INTO faa_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Airakano Yasumo pariaseraka ipi pasua epamo sakaisarihoamo aseako pariaseane, ");
INSERT INTO faa_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","hinamoane ipi wake apea makama yiaraka kayane farakarakano, kaikia fofaraka hamisisiraka, kakuna porokoa kake makata su asiane Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Somerakano Yasumo kaikia eaki someraka, “Hinamo neo, nómo anoaki himu hakásaraka hemaka apura yiamo ne makata takamasane mafarakayiapo. Ní tau koteaka kakanie. Ní makata takamasane kakaro fasapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Aisa maiya amo aporo metakira pekea, Yu aporomo sarimana ape asekea rea aporomo ape aeyaka pekea, Yairaseaki someraka, “Nómo hinamo hokosa namo kakaro kusuapo. Kusuasamo tisaki efera hunia somehokopo. Metakarisie.” ");
INSERT INTO faa_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Airakano someane Yasumo kaikia kakipayaraka, Yu aporomo sarimana ape asekea rea aporoaki someraka, “Himu fahokopo. Anoaki himu hakásaraka hemakapunie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Aíyaka Yasumo Pita soko, Yamese soko, ipi mamanea Yone soko, karikia pukua aporo suaki peakopo, aisapo. ");
INSERT INTO faa_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Aíyaka i pukua, Yu aporomo sarimana ape asekea rea aporomo apea pauraka aseane, aporo hinamo yakai sarimaraka, hokosa kusuapoko kára yaiya hihiripuraka tokeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Asekea Yasu apea yorokoa aporo hinamo suaki someraka, “Marirakano hihiripurakanare? Hokosane wayereapo. Kusuafapo.” Aíyaka hokosa ane maturikia taehokosane epo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Aíyaka somerakano aporo hinamo suamo Yasuaki hokomarekea keasapo. Kearakano asekea Yasumo i suaki someraka, “Re su yao hauaka moro atura pusie,” aisapo. Purakano asekea hokosa amo kaīyia soko, wafaya soko, Yasumo karikia pukua, aporo isia eyaki hakāsa pesane soko karikia hokosa warea apea yorokoa, ");
INSERT INTO faa_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","hokosa hokonoa Yasumo maka ipi meaka someraka, “Tarita kumi,” aíyaka somesapo. Arirakano namo meaka, “Masira, né turikia pusie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Aíhoane hinamo hokosa ane turikia pusuapo. Turikia pukua koraka reapo. Arirakano masira turikia pusua ane keremisi kenosu fasapo. Masira ane koraka rekeno aseraka i su fofasapo. ");
INSERT INTO faa_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Fofarakano Yasumo iaki someraka, “Aporo hinamo metakiraki somehokopo. Hokosane makata nakosa kakanie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yairasemo apeane metakarikia Yasu ipi apea paripusuapo. Paripukua ipi aporo hakāsa purane soko, namina eyaki hakāsa poparipusuapo. ");
INSERT INTO faa_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Poparipuraka risike, fenena maiya amo Yu aporomo sarimana apea pukua, Yasumo some karakano, aporo hinamo metakiramo kaikia fofasapo. Fofaraka ipu someraka, “Epo makata suane ma kaisiare? Kotimo hemakapusua some kotesa somerakano ma kaisiarakapo. Epo Kotimo wakapumo hemakapukua arakirane epo hokonomo rakisiane ma enomasarakapo. ");
INSERT INTO faa_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Eane kapeneta aporopo. Eane Mariamo maeyapo. Epo ipi mamanea ane Yamese soko, Yosefe soko, Yutase soko, Saemone soko, suane isiapo aserapo. Epo ipi ifiane isina hakāsa tokenapo.” Aíyaka ipu Yasuaki himu hakásaraka hemakapunafonoraka hisiraka risiapo. ");
INSERT INTO faa_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Hisiraka risikino Yasumo iaki someraka, “Kotimo some kará porofete aporomo ipi ape sumu aporo hakāsa risia amo soko, ipi aporo iramo soko, ipi amámo kepomo soko, ipi ape wará aporo hakāsa risiamo soko, eane makama fanaraka hemakapurafapo. Hemakapunafonorakano yia, ape sumu meta á aporo hinamo metakiramo Kotimo some kara porofete aporoane makama fanaraka hemakapurapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yasumo makata wakasema rakiraka, aporo hukusi makata tasa hokonomo sakaihoane fasa nine, Kotimo wakapumo hemakapukua rakirane ipi kára rakisiafapo. Aporo hinamomo Yasuaki himu hakásaraka hemakapunafonorakano, kára rakisiafapo. ");
INSERT INTO faa_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Eaki himu hakásaraka hemakapunafonosane Yasumo ipi himu nekea kára hemakapusuapo. Ape sumu fete sua Yasu pukua some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Some karaka Yasumo ipi aporo kenosu murikimasane peaesapo. Perakano asekea aporo tetá tetáka hauaka meta pukua, arirakano yaiya aporo tetá meta hauaka meta pukua, ayiakasimo murikimasapo. Murikimaka ipu yatafumo aporo ho masane metakarikia pusiehoasimo iaki wakapu kasapo. ");
INSERT INTO faa_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Kaka someraka, “Kimisi puraka makata kára mokoakopo. Tatia maka puane siahoasireapo. Arirakano makata nakosa soko, ku soko, mone hae soko, makata ane mokoa pukupo. ");
INSERT INTO faa_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tamaka osohoane siahoasireapo. Arirakano pasu tetá osohokopo. ");
INSERT INTO faa_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Re puraka ape sumu á pauraka, apea yorokoa ape hakása yia waka risikianie. Ape wafaya mahisihokohoamo ape meta wakako mokome pukupo. Ape sumu meta pukusakipoko, ape ne wasa aeyaka punie. ");
INSERT INTO faa_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ape meta á aporomo reaki terehoanafonoraka, repo someane kaiyako hisirakano asekea apeane metakarikia punie. Korakea kokotonomosane rerakatapikia marekea metakarikia punie. Kokotonomosane iyaki hakāsa yaiya rekeasimo aina ayiáka, ipu watikisane iyaki yaiya rekenapo. Aíyaka repo tarinie.” Aíyaka Yasumo aporo kenosuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Arirakano aporo kenosu pukua some karaka, “Aporo hinamo repo makata watikiaka rakisiane metakarikia Yasuaki risikiako parihoanie,” aíyaka some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yatafuaki soko ipu pusierakano pusuapo. Wera maka aporo makata tasa kaua sisihoane fasapo. ");
INSERT INTO faa_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Yasumo wakapumo hemakapukua rakiraporakano Yasu yano motosa Herotemo kairaka aporo metakiramo someraka, “Yasu ipi Yone he tapukumarera ayareapo. Yone he tapukumarerane maturikia taerakano e pukua wakapuaka rakirakanapo.” ");
INSERT INTO faa_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Airakano aporo metakiramo someraka, “Yasuane Iraíya fana reane paripeareapo.” Airakano aporo metakiramo someraka, “Yasuane porofete aporo meta reapo. Wate fana Kotimo some kará porofete aporo rea ayiáka e are.” ");
INSERT INTO faa_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Airakano Herotemo kaikia someraka, “Yone nōmo mawi pateketaerasiesane Kotimo maturikia taesapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kariri hauaka asekea rea aporoane Herotepo. Herotemo ipi mamanea yano motosa Firipipo. Firipimo ipi asea yano motosa Herótiasepo. Herótiaseane, Herotemo haki arumaka rekeno asekea ");
INSERT INTO faa_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yonemo Heroteaki hukurukua someraka, “Ní maemo hinamoane nómo haki arumaka areane, somemane motosane nómo mamosoane.” ");
INSERT INTO faa_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Aisasamo hinamo Herótiasemo kaikia Yoneaki hisiraka kake, e kukusimo ruko seseaka hemakapusuapo. Hemakapusua nine e rusua kusuafapo. ");
INSERT INTO faa_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Arirakano Herotemo Yoneaki namoraka reke, Yone waseremaka hokonoa taporaka tipura makeaniesapo. Tipura makesa rekeno asekea, Herotemo hemakapuraka, “Yone ipi ereketaeraka reke ipi Kotiaki hemakapukua are.” Aíyaka Herote namoraka reke, Yone rusuafapo. Arirakano aporo metakiramo soko Yone rukusaporakano, Herotemo waesapo. Maiya metakiramo, Yonemo someane Herotemo kaikia seséaka kaisia nine himetesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herote ipi takapesa serea paurakano hokono keraka, Herotemo ipi kamani aporo soko, ame aporo satini soko, Kariri hauaka aporo kára soko, i suaki hokono keako peaesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Perakano asekea Herótiasemo ipi faraya pekea Herotemo apea taneseraka kesasapo. Taneseraka kesarakano asekea Herotemo seséraka, aporo su pesamo soko sesésapo. ");
INSERT INTO faa_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Asiamo hinamo hokosa sakoraki Herotemo someraka, “Nómo makata makasierakano nōmo neaki makakosapo. Nōmo makata asekea rea sapeane neaki makakosapo. Nōmo kakaro somehoanafonorakano soko, Kotimo aserakanapo,” aíyaka aumaraka somesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Somerakano Herótiasemo faraya pukua, ipi kaīyiaki someraka, “Nōmo yakapa makasiehokosare?” Airakano Herótiasemo someraka, “Yone he tapukumareramo wamoane makasiehoanie. E kakaro rusua kusuane aseako ipi wamoane makasiehoanie.” ");
INSERT INTO faa_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Airakano Herótiasemo farayane wate foaka pukua, unihae Heroteaki someraka, “Yone he tapukumareramo wamoane patekemaka, tísia motokoa anoaki makasie.” ");
INSERT INTO faa_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Airakano unihae Herotemo kaikia mahisiraka reapo. Mahisiraka reke makakosapo, aíyaka aumaraka somesane, aporomo hokono akera maiya ámo suamo kaisiasamo, patekemakaniesane metakariane kaiyanapaka ipi somesane kekemasapo. ");
INSERT INTO faa_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kekemaraka wate foaka aporo terakaiyamosamo Yone wamo pateketaehoasimo tipura apea pusiesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Airakano tipura apea pukua, Yone wamo patekemaka tísia motokoa maka pekea hinamo sakoraki kasapo. Karakano maka ipi kaīyia Herótiaseaki kakako maka pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Arirakano Yonemo ipi aporo hakāsa pura peraka Yone oto susuane maka pukua kunikia motosapo. ");
INSERT INTO faa_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yasumo ipi tarira aporo murikimasane e rea paripekea ipu makata rakisiane soko, ipu some kasane soko, makata suane Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Someraka risike aporo hinamo yakai perakano purakano, perakano purakano, ariraka risike tarira aporomo makata nena maiyane fasapo. Asiamo Yasumo tarira aporoaki someraka, “Re hákasa anoyaki nena yaoa peae. Maiya wakasemamo fenako peae.” ");
INSERT INTO faa_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Airakano i hákasa pukua nena yao taku ra pukusakipoko kasua ripaka rokoa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Purakano aporo hinamo yakaimo asekea hemakapuraka, “I taku ra apure,” aíyaka hemakapukua, i korakemo taku ra fofoaka pusuapo. Puraka ape sumu fete su aeyaka pusuapo. Pukua Yasu soko, ipi aporo hakāsa purane soko, i peasiraka, aporo hinamo yakai he fe ikia kara anaka pusuane, fana pauraka sarimasapo. ");
INSERT INTO faa_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sarimasakipoko i kasua ripaka pesane, ima foraka aseane aporo hinamo yakai risikino asekea iane Yasumo kára kamenakasapo. Saro sipimo namina wafaya fasekeno mahimeteraka arisia ayiáka, i mahimeteraka risikinapo, aíyaka Yasumo hemakapuraka, ipu koteaka hemakapusimo Yasumo iaki some meta some kaka, some meta soko some kaka, ayiáka makata kára iaki some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Arirakano yao nenehoramo Yasumo ipi aporo hakāsa pura pekea Yasuaki someraka, “Hauaka wo ima yaosakipoko aporo hinamo risikinafapo. ");
INSERT INTO faa_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Maiya tukerapaka aporo hinamo sarimasamo ipu namina makata nakosa ropohoko apea poparipusiesie. Ima ape manoa soko ape sumu wakasema soko á makata nakosa ropohoko poparipusiesie.” ");
INSERT INTO faa_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Airakano Yasumo someraka, “Repo namina makata nakosa iaki kasie.” Airakano ipu someraka, “Aporo hinamo suamo makata nakosane isu pukua, tu harote kinamo (K200) farawa roporaka iaki kakakosare? Asiamo isiapo tu harote kina ane (K200) fasasamo, mayiáka mokoakosare?” aíyaka ipu Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aíyaka somerakano Yasumo iaki someraka, “Farawa yakapasu tokenare? Aseako pusie.” Airakano ipu kope pukua, paripekea Yasuaki someraka, “Makata nakosane farawa kakoreasu, pokoa tetá ayiáka tokesapo.” ");
INSERT INTO faa_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Airakano Yasumo someraka, “Aporo hinamo parakuraka su metakira taku rā asane kotesakipoko á toaesie. Arirakano i metakira sarimaraka taku rō asane kotesakipoko á toaesie.” ");
INSERT INTO faa_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Airakano i parakuraka toke, aporo hinamo metakira fifiti (50) sarimaraka taku ra toke, aporo hinamo metakira wane harote (100) sarimaraka taku ro toke ayiáka i su asanea toapo. ");
INSERT INTO faa_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tokeno asekea Yasumo farawa kakoreasu, pokoa tetá mokoa reke, hepene yapura asekea súseraka kurikurisapo. Kurikuriraka faraka farawa mosoraka, aporo hakāsa puraki kaka, aporo hinamo suane kakasimo Yasumo iaki kasapo. Pokoa tetáne soko, aporo hinamo suaki kakasimo Yasumo kasapo. ");
INSERT INTO faa_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Karakano ipu aporo hinamo hokosa suamo siaraka mokoa nesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nekea faraka farawa soko, pokoa soko, momo yia tokeno, aporo hakāsa puramo mate kenosua kekea komarusuapo. ");
INSERT INTO faa_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Arirakano aporo makata nesa suane menoraka fae taosenepo (5,000). Hinamo soko, hokosa soko, iane menosafapo. I menohoanafonosamo soko makatane sia nesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Aporo hinamo suamo makata nekea farakano Yasumo ipi aporo hakāsa puraki someraka, “Re fana kasua ripaka he fe taku ra hisie. Hikia Pesaita taonea hinie. Arirakano aporo hinamo sarimasane i namina apea poparipusie, aihoko ano fore o rekenapo.” Airakano i kasua ripaka hisiapo. ");
INSERT INTO faa_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Hisiakipoko aporo hinamo su sarimasane soko namina apea poparipusuapo. Poparipusuakipoko Yasu ipi haku ūria kurikurihoko hisiapo. ");
INSERT INTO faa_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Hikia ereamo Yasu ipi haku ūria reke kurikuriraka reapo. Reke aseane aporo hakāsa pura kasua ripaka rokoa purakano asesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Aseane he kupa atifoyaki kára peraka, kasu maka paripurakanoraka kasu roane punafonorakano asesapo. Yao fia makehoramo kasu tapukurea á Yasu he kima finirape pesapo. Finirape pekea, kasu marokeraka pukusapoko asiāne, ");
INSERT INTO faa_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","e he kima finirape perakano, i kasua toamo aseraka hemakapuraka yakasa horihoamo hemakapukua kokoaeraka wásapo. Wárakano Yasumo iaki foaka someraka, “Anopo. Re namohokopo. Namoraka himu fahokopo. Paroaka risikianie.” ");
INSERT INTO faa_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Aíyaka kasu i toa á Yasu parohoane atifo fasapo. Farakano asekea aporo kasua toane kára fofasapo. ");
INSERT INTO faa_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Fana farawa kakoreasu Yasumo mosoraka karakano, aporo hinamo hokosa yakaimo katu siaraka nesane mahimetesapo. Ipu himo asesa nine himumo kepoane hemakapusuafapo. Kakaro mahimetesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","He Kariri kekea kaya kasu rokoa teraporaka Yasu soko, Yasumo ipi aporo hakāsa pura soko, Kenesare hauaka hisiapo. Hikia kasu matapea pauraka kasu kita hukumaresapo. ");
INSERT INTO faa_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Hukumarekea ima fokoa pukua, wate foaka aporo hinamo ipu hemakapuraka, “Ane Yasureapo.” ");
INSERT INTO faa_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Aíyaka hemakapukua apea fofoaka pukua, aporo hinamo makata tasa fefeneakua makekea, Yasu á rekenapakano kaikia, e area mokoa pesapo. ");
INSERT INTO faa_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Yasu koraka rea ape sumu wakasema á soko, ape sumu kára á soko, ima yaoa ape manoa soko, perakano asekea hauaka rusua kakamasakipoko aporo hinamo makata tasane á taesapo. Taeraka ipu Yasuaki someraka, “Nómo pasu ke huhua isiapo sakaihoane siahoasisekeno ane nómo aosie.” Airakano Yasumo aosapo. Aorakano pasu huhu á ipu sakaihoane aporo hinamo makata tasane foakayia fasapo. ");
INSERT INTO faa_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ferese aporo soko, Kotimo somemane tisa aporo soko Yarusarame siti aeyaka pekea Yasu rea sarimasapo. ");
INSERT INTO faa_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Sarimaraka aseane, Yasumo ipi aporo hakāsa pura metakiramo hokono kusuhoanafonoraka makata nenakano asekea hemakapuraka, “Aporoamo hasaka arakire. Ayiáka arakiramo ipu himuane mokoatikiane. Ipu Yu aporo sisimamo somemane ane mamosoane.” aíyaka Ferese aporomo hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Arirakano Yu aporo sisimamo soko, Ferese aporomo soko ainane hokono kari aeyaka rotoraka kusuhoanafonoraka, makata maka nenafapo. Yu aporo sisima makasa kauamo ayiakanie, aisane kekemaraka, hokono kusuraka makata nenapo. ");
INSERT INTO faa_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Makata ropona ape aeyaka pekea, fana i kau kusuraka faraka makata nenapo. Makata nakosakipoko hokono kusuna ayiáka, kapo soko orotipi soko meraki soko kusunapo. ");
INSERT INTO faa_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Asiamo Ferese aporope Kotimo somemane tisa aporo ipu Yasuaki someraka, “Marirakano nómo aporo hakāsa puramo isiapo makasa kauamo ayiakanie, aíyaka somepe pesane koaretaeraka risikinare? Koaretaeraka ipu makata nakosakipoko hokono kusurakarifapo. Hokono kusuhoanafonoraka makata maka anene.” ");
INSERT INTO faa_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Airakano Yasumo iaki someraka, “Re himu tetáraka arisiane porofete aporo Aesayamo kakaro somehoareapo. Somesane Kotimo sawia popasane oyapo. Kotimo someraka, ‘Aporoamo anoaki akaimo kekereraka himumo anoaki hemakapurakanafapo. ");
INSERT INTO faa_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Himumo anoaki hemakapunafonoraka nena akai susuamo anoaki kekerenapo. Ipu namina hemakapusuane some karakanapo. Some karaka yia, nōmo somemane ane metakarikia ipu namina aporomanomo somemane ane some karakanapo.’ Aíyaka Kotimo somerakano Aesayamo popahoareapo. ");
INSERT INTO faa_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Asiamo repo Kotimo somemaneane koaretaeraka makasa kaua kekemamo ayiakanie aíyaka somepe pesane kakimarakanapo,” aíyaka Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Efera hunia Yasumo iaki someraka, “Repo makasa kauamo ayiakanie aíyaka somepe pesane makama fanaraka, repo Kotimo somemane koaretaenane oyapo. ");
INSERT INTO faa_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kotimo ipi somemane Moseseaki someaka mareraka, ‘Ní atape ní ama tetāne koteaka hemakapukua makotehoanie,’ aihoareapo. Some meta soko someraka, ‘Aporo hinamo metamo ipi atane soko metao, ipi amane soko metao, yakasa ho mareraka ekenerakano, e kakaro kukusimo runie,’ aíyaka Kotimo someaka maresane Mosesemo aporo suaki somehoareapo. ");
INSERT INTO faa_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Somesa nine repo someraka, ‘Aporomo soko, hinamomo soko, ipu namina ataki soko metao, ipu namina amaki soko metao someraka, “Tetoaki makata yaku kakakosapoko asiāne metakarikia, Kotiaki karakanapo.” Aíyaka re Ferese aporomo aporo hinamoaki some karakanapo.’ ");
INSERT INTO faa_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Some karakano aporo hinamomo ipi ata ama tetā ararehokosapoko asiane, metakarirakanapo. Asiamo ama ata ararenane repo matasorakanapo. ");
INSERT INTO faa_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Makata matasona yakai metakira soko repo rakirakanapo. Asiamo repo namina makasa kaua kekemamo ayiakanie aíyaka somepe pesane mafanahokosakipoko, Kotimo somemaneane repo mokosekeraka arisie. Makasa kaua kekemamo someane repo kakimaka ayiakanie airakae,” aíyaka Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aporo hinamo su sarimahoasimo Yasumo peaeaka perakano, iaki someraka, “Repo suamo kaisie. Kaikia hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Makata yao aeyaka pekea aporo hinamo tua apuramo ipi yia mawatikinafapo. Tu aeyaka yaoa tono apuramo ipi yia mawatikinapo. ");
INSERT INTO faa_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Repo senakimo kairaka koteaka kakimakanie.” ");
INSERT INTO faa_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Aíyaka Yasumo someaka faraka, aporo hinamo sarimasane metakarikia, apea yorokoa purakano, Yasumo ipi aporo hakāsa puramo someraka, “Aporomano tua mawatikina takume kepoane yakapare?” ");
INSERT INTO faa_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Airakano Yasumo someraka, “Repo soko kepoane yaiya hemakapurakarifare? Makata yao aeyaka pekea aporo hinamo tua apuramo ipi himu yia mawatikinafapo. ");
INSERT INTO faa_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Makata yao aeyaka himua purafapo. Katukunua pukua, katukunu aeyaka fako otoa pukua katisokopo apea purapo. Asiamo makata nena suamo re himuane mawatikinafapo,” aíyaka Yasumo ipi somesapo. ");
INSERT INTO faa_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yasumo efera hunia someraka, “Aporomanomo himu aeyaka tonoaheramo ipi yia mawatikinapo. ");
INSERT INTO faa_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Himu aeyaka aporo hinamo ipu himumo makata watikisa hemakapurane oyapo. Watikiaka rakiako hemakapurane soko, makata kaíyasa rakiako hemakapukua aporo hokosa takēyaki puko hemakapurane soko, makata kemo hakimako hemakapurane soko, aporomano rusua kukuko hemakapurane soko, hinamo hakimako hemakapurane soko, aporo rea puko hemakapurane soko, ");
INSERT INTO faa_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","aporo meta menane makaripi aíyaka hemakapurane soko, watikiaka rakiako hemakapurane soko, kotafe somehoko hemakapurane soko, hinamo rea puko hemakapurane soko, e area ayiáka ano ayiáka rekearipi aíyaka hemakapurane soko, kotafe topakamaraka somehoko hemakapurane soko, e ipi makama fanaraka rekeako hemakapurane soko, mokome rakiako hemakapurane soko, makata suane himua risirapo. ");
INSERT INTO faa_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Himua risia makatane tū aeyaka tonoaheramo, aporomano ipi yia mawatikinapo.” Aíyaka Yasumo ipi somesapo. ");
INSERT INTO faa_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Apeane Yasumo metakarikia puraka, Yu aporohoanafonosamo hauaka á pukua, Taia taone á soko, Saetone taone á soko makeraka pusuapo. Pukua aporomo e aserapaka e apea yorokoa ape kakarua pusuapo. Pusua nine e aporomo asesapo. ");
INSERT INTO faa_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Yasu perakasaporakano wate foaka Yu aporohoanafonosa hinamomo kaisiapo. Hinamoamo hauakane Siria hauaka ayapo. Siria hauaka parakurakano sape á ipi takapesa hauaka yano motosane Finísia hauakapo. Hinamoamo ipi hokosa wakasema nine, yatafumo ho marakano asekea hinamoane pekea Yasu korake á kakuna porokoa kake someraka, “Nōmo hinamo hokosa yatafumo ho masapo. Yatafuaki nómo pusiehoanie.” ");
INSERT INTO faa_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Airakano Yasumo hinamoaki takumeaka someraka, “Fana hokosamo nasimo kayane siahoasireapo. Makata nakosa hokosapoko taesane kásaki kayane siahoasifareapo. Fana hokosamo nasimo karakanapo.” ");
INSERT INTO faa_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Airakano hinamoane ipi Yu hinamohoanafonosa nine, Kotimo e ararehoasimo himu hakásaraka hemakapusuasamo, Yasuaki someraka, “Unihaeo, kakarorakae. Asiāne hokosamo makata nenaka momo hurupeperakano, kása teporo petaua risiamo nenapo.” ");
INSERT INTO faa_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Airakano Yasumo someraka, “Nómo makata somerakasakipoko né ní apea seseaka pusie. Nómo ní hinamo hokosa yatafumo ho masane yatafu metakarikia pusuapo.” ");
INSERT INTO faa_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Airakano hinamoane ipi apea paripukua aseane, ipi hinamo hokosa yatafumo ho masane, yatafu metakarikia puraka, hinamo hokosane ipi koteaka apea warekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Taia taone hauakane metakarikia pukua Saetone taone ane soko marokeraka pukua, he Kariria pukusakipoko taone kaeyako su yano motosa Tekáporisia pukua ");
INSERT INTO faa_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","aseane, aporo senaki tisa aru tapaya mesa aporo metamo karikia, Yasu rea peraka Yasuaki someraka, “Nómo hokonomo aporoane sakairasie.” ");
INSERT INTO faa_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Airakano aporo senaki tisane Yasumo karikia aporo hinamo yakai sarimasane metakarikia, tetā hákasa wakasema pukua, tati haku risike, Yasumo ipi hokonomo aporo senaki tisa taku tetákara paremarekea faraka, Yasu ipi hokonoa torofaeraka aporo aru tapaya mesane arua sakaisapo. ");
INSERT INTO faa_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sakairaka reke ipi hepene yapura asekea aporoane kamenakaraka, kaiyáraka someraka, aporo senaki tisaki someraka, “Né senaki tisane ropakapusie,” aisapo. Aíyaka Yasumo ipi meaka someraka, “Efata.” ");
INSERT INTO faa_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Aihoane aporo senaki tisane faraka koteaka kairaka, aru tapaya mesane soko faraka ipi koteaka somerakano, asekea ");
INSERT INTO faa_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yasumo ipi aporo suaki someraka, “Anoane aporo metakiraki somehokopo,” aisapo. Airakano ipu kakipayaraka ipu makata asesane kára somesapo. Efera hunia Yasumo iaki somehokopo aisane, ipu kakipayaraka kára somerakano ");
INSERT INTO faa_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","kairaka, aporo hinamo metakiramo Yasuaki kára sesésapo. Seséraka someraka, “Epo makata su koteaka rakirareapo. Aporo senaki tisamo koteaka kaiyisimo epo mafahoareapo. Aporo aru tapaya mesamo soko koteaka somehoasimo epo mafahoareapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Efera hunia aporo hinamo su Yasu rea pekea sarimaraka, makata nakosa fasekeno, Yasumo ipi aporo hakāsa puraki someraka, ");
INSERT INTO faa_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Sere isiamo aporo hinamo yakai anoyaki hakāsa sarimaraka risike, makata nenane fasapo. Fasasamo nōmo iane kára kamenakaripo. ");
INSERT INTO faa_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Iane himu raru puraka ikia kara meamoraka yofehokosapo. I metakira yameno aeyaka pesapo.” ");
INSERT INTO faa_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Airakano aporo hakāsa puramo someraka, “Isu arisia one ima yaosasamo aporo sarimasaki farawa siaraka nasimo kayane siahoasifareapo. Kakakosane ma mokoakosare?” ");
INSERT INTO faa_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Airakano Yasumo someraka, “Repo farawa yakapasu tokenare?” Airakano ipu someraka, “Farawa yatipinusu tokenapo.” ");
INSERT INTO faa_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Airakano Yasumo aporo suaki someraka, “Re hauaka á toae.” Aíyaka i tokeno asekea, Yasumo farawa yatipinusu mokoa reke Kotiaki suseaka kurikuriraka, faraka farawa mosoraka, aporo hinamo suaki kakasimo ipi aporo hakāsa puraki karaka someraka, “Farawa one aporo hinamo su sarimasaki takupe pusie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Aíyaka keseke pokoa fete hukusi tokeno asekea, Yasumo Kotiaki suseaka kurikurisapo. Kurikuriraka faraka, aporo hakāsa puraki someraka, “Aporo hinamo suaki takusie,” airakano takupe pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Takukua aseane aporo hinamo ipu suamo siaraka nenakano asekea, farawa momoane aporo hakāsa puramo mokoa maté yatipinusua kesapo. ");
INSERT INTO faa_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Arirakano aporo farawa nesa su sarimaraka menosane fo taosenepo (4,000). Arirakano hinamo soko, hokosa fete soko, menosafapo. I menohoanafonosamo soko, makata sia nesapo. ");
INSERT INTO faa_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Aporo hinamo su sarimaraka farawa nesane Yasumo pusiesapo. I purakano Yasu kasua ripaka aporo hakāsa pura soko kasua ripaka, kasu rokoa Taomanuta hauaka á pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ferese aporo pekea Yasuaki tafatafaraka someraka, “Kotimo murikimasane nesekenone, nómo makata rakirane isiapo aseako nómo rakikitakae. Kotimo hepene yapura makata ainane isiapo aseako nómo rakikitakae.” aíyaka someraka Yasuane ipi kau aseakosakipoko epo rakisimo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Somerakano, Yasu ipi himu mahisiraka someraka, “Aporo hinamo maiya omo arisiamo ipu ano kau aseakosakipoko someraka, ‘Kotimo murikimasane nesekenone, nómo rakirane isiapo aseako nómo rakikitakae,’ airakane mainakano airakare? Nōmo kakaro somerakaripo. Maiya omo aporo hinamo arisia omo asekeasimo Kotimo wakapumo hemakapukua rakirane nōmo rakiakosafapo.” ");
INSERT INTO faa_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Aíyaka marekea, Yasumo iane metakarikia kasua ripaka, he yaoraka taku ra pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Aporo hakāsa purane Yasuyaki kasu rokoa pukua ipu farawa mokoa peakosane meraruraka pesapo. Pekea kasua risike aseane farawa hakása kasua kakeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Arirakano Yasumo iaki takumeaka someraka, “Ferese aporomo soko, Herotemo soko, ipu watikiaka hemakapurane farawa pirira asíapo. Asía ane repo morapaka asekeanie. Ipu watikiaka hemakapurane kárahoarea ayiáka, reane ayiakakohoamo asekeanie.” ");
INSERT INTO faa_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Aiyaka Yasumo somerakano, some kepoane ipu himeteraka namina susu me rukua someraka, “Isiapo farawa mokoa peanafonosasamo airakae.” ");
INSERT INTO faa_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Airakano ipu hemakapusuane Yasumo aseraka someraka, “Marirakano repo namina susu me rukua someraka, farawa fareaporakanare? Nōmo some kepoane repo yaiya mahimeteraka risikiakosare? Repo himumo koteaka hemakapurakarifare? ");
INSERT INTO faa_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Repo himo aseraka yia, koteaka aserakarifapo. Senakimo kairaka yia, koteaka kairakarifapo. Nōmo makata rakisiane repo meraruraka arisie. ");
INSERT INTO faa_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Aporo yakai fae taosene (5,000) sarimasa amo, farawa kakoreasuane nōmo mosoraka kaka faraka, farawa momo yia tokeno maté yakapasua repo kesare?” Airakano ipu someraka, “Maté kenosua kesapo.” ");
INSERT INTO faa_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Airakano Yasumo someraka, “Aporo yakai fo taosene (4,000) sarimasaki nōmo farawa yatipinusu kaka faraka, farawa momo yia tokeno maté yakapasua repo kesare?” Airakano ipu someraka, “Maté yatipinusua kesapo.” ");
INSERT INTO faa_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Airakano Yasumo someraka, “Ane repo yaiya himeterire? Farawa fasekeno himu fahokopo, kára hemakapukopo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yasu ipi aporo hakāsa purayaki Pesaita taonea pekea aseane, aporo metakiramo aporo hi fausa karikia pekea Yasuaki someraka, “Eane sakairasie.” ");
INSERT INTO faa_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Airakano asekea Yasumo aporo hi fausane hokono maka taone metakarikia pukua ruru tapikia yao takua karikia pukua, Yasumo aporo hi fausa hia torofaeraka eane sakairaka someraka, “Nómo himo yakapa aserakarire?” ");
INSERT INTO faa_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Airakano aporo hi fausamo someraka, “Nōmo aseane aporomanoane ira asera ayiáka aseraka sikiripo. Ira asera ayiáka aporomanoane ayiáka apure.” ");
INSERT INTO faa_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Airakano efera hunia aporo hi fausane Yasumo sakaihoane, hi fakarikia makata su koteaka asesapo. Hi fausane kakaro mafarakano, koteaka aseke waperaka asesapo. ");
INSERT INTO faa_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Koteaka aserakano, Yasumo eaki someraka, “Ní apea pusie. Pesaita taone yia paripukupo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yasu soko, ipi aporo hakāsa pura soko, i pukua, Sisaría Firipai taone makeraka pusuapo. Á pusua maiya amo, Yasumo ipi aporo hakāsa puraki someraka, “Aporo hinamo suamo anoane epapakasure?” ");
INSERT INTO faa_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Airakano ipu someraka, “Aporo metakiramo someraka, ‘Né Yone he tapukumarerane turikia pureapo.’ Aíyaka somerakasupo. Arirakano aporo metakiramo someraka, ‘Né porofete aporo Iraíyareapo.’ Aíyaka somerakasupo. Arirakano aporo metakiramo someraka, ‘Né porofete aporo metareapo.’ airakasupo.” ");
INSERT INTO faa_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Airakano Yasumo someraka, “Repo namina hemakapusuane, ano epapaka hemakapurakanare?” Airakano Pitamo someraka, “Kotimo Unihaeaka rekeasimo murikimasa aporo Keresoane nereapo.” ");
INSERT INTO faa_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Airakano Yasumo someraka, “Ano Keresoane aporo suaki somehokopo.” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aporo hakāsa puramo hemakapusimo Yasumo iaki tariraka some kasane oyapo. Yasu ipi Aporomanomo Tákehokosakipoko hauaka wo pesapo. Asiāne ipi kára himu nasimo aporomo é mokoatikihokosapo. Yu aporo sisimamo soko, pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko eane hisiraka patera tariakosapo. Patera tarikia eane kukusimo rukusapo. Sere isia farakano maturikia taehokosapo. Aíyaka ayiakakosane, Yasumo ipi aporo hakāsa puraki some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Some kasane kakaro hufitaeraka somesapo. Hufitaeraka somerakano, Pitamo Yasuane karikia, wakasema pukua someraka, “Neane rusua kukusapo, aíyaka somehokopo.” ");
INSERT INTO faa_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Airakano Yasu rekeako pariraka, ipi aporo hakāsa purane asekea Pitaki someraka, “Satanemo somera aíyaka nómo somehokopo. Kotimo hemakapurane kekemaraka hemakapunafonoraka, aporomanomo hemakapurane nómo kekemaraka hemaka apure. Sataneo, né ano patera sapea pusie.” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yasumo aporo suane soko, ipi aporo hakāsa purane soko, peaesapo. Perakano asekea epo someraka, “Repo ano patera aseako, ano kuraka ira matopesa paremareakosane, nōmo makatiaka apura ayiáka, re soko, repo hemakapusuane metakarikia, ira matopesa maka punie. Ano finisa á, re soko fini kafo kepe peanie. ");
INSERT INTO faa_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aporomano hauaka wo areamo hitaferaka rekeakosane hákasa hemakapukua rakiraka rekeno, keseke aporoane Kotiyaki yaiya rekeakosafapo. Arirakano aporomano metamo someraka, ‘Yasupoko ano kuane soko siahoasireapo. Arirakano Yasumo some kotesa kakako ano kuane siahoasireapo.’ Aíyaka kurane hemakapurafaraka rekeno, aporoane Kotiyaki yaiya rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Arirakano aporomanomo hauaka kara wo makata kemo suane mokoa sarimaraka reke, Kotiyaki yaiya rerane epo metakarikia rekeno, akura maiya amo makata yakapamo e ararehokosare? Makata metamo e ararehokosane kakenafapo. ");
INSERT INTO faa_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Yaiya rerane ropohoko makata yakapamo roponare? Yaiya rerane makata metamo roponafapo. ");
INSERT INTO faa_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Maiya omo arisiamo aporo hinamo watikiaka risike, aporomo ipi hinamo metakarikia, hinamo metayaki apura ayiáka, ano metakarikia puraka, nōmo someane soko metakarikia risikino, keseke Aporomanomo Táke anoane pariapera maiya amo, ano metakarisia aporo hinamoane, nōmo soko iane metakariakosapo. Nōmo Atamo faesayaki, hepene aporo kotesa susuyaki pariapera maiya amo, aporo hinamomo ano metakarisiakipoko, iane soko nōmo metakariakosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yasumo ipi aporo hakāsa puraki someraka, “Nōmo reaki kakaro somerakaripo. Re metakira yumo risiane kukusiraka risike aseane, Kotimo aporo hinamoane unihaeaka asekea reke ipi wakapuaka rakiraka rekeno aseakosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sere namasu faraka Yasumo Pita soko, Yamese soko, Yone soko, i karikia ūri terayia hisiapo. Hikia namina hakāsa risike aseane, Yasu kau hakuraka, ");
INSERT INTO faa_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ipi pasu ososane soko, namo kakaro pakaeraka faerakano asesapo. Hauaka wo sopomo pasu kususa pakaena asiafapo. ");
INSERT INTO faa_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ipi namo kakaro faesa rekeno asesapo. Aseane wate fana risia porofete aporo Iraíyape Mosese tetā risike, tetapō Yasuyaki makata someraka risikino asesapo. ");
INSERT INTO faa_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Aseraka Pitamo Yasuaki someraka, “Tisao, isu o pesane kotesapo. Isiapo ape mano isia kiakosapo., Ape meta népoko, ape meta Mosesepoko, ape meta Iraíyapoko ayiáka kiakosapo.” ");
INSERT INTO faa_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aíyaka Pitamo Yasuaki somesapo. Ipu yakapa somehoasifasekeno i suane kakaro himu faraka namoraka risiapo. ");
INSERT INTO faa_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","I risiane akomo iane karotapisiapo. Ako karotapisia arakaru aeyaka someraka, “Eane nōmo nī hokosapo. E nōmo himu tumurumo hemakapurakanapo. Epo someane kaikia hemakapukua risikianie.” aíyaka somerakano ipu kaisiapo. ");
INSERT INTO faa_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kairaka ipu wate foaka aseane Yasu ipi hákasa yia iyaki reke, aporo tetá metane fasekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","I ūri terayia aeyaka peraka risike, Yasumo iaki paroaka wakapuaka someraka, “Aporomanomo Tákeane anopo. Keseke ano kukusapo. Ano kusuane maturikia taehoasiraka, repo pipu makata asesane haru somehokopo.” ");
INSERT INTO faa_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Airakano ipu makata asesane aporo hinamo metakiraki somesafapo. Ipu namina someraka, “Maturikia taehokosa kepoane yakapare?” aíyaka ipu namina me rukua kára somesapo. ");
INSERT INTO faa_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Aporo hakāsa pura isiamo Yasuaki someraka, “Kotimo somemane tisa aporomo someraka, ‘Kereso peasiraka Iraíya fana peakosapo,’ aisa amo kepoane makata yakapare?” ");
INSERT INTO faa_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Airakano Yone he tapukumareramo Keresopoko ikia kara maroponane Yasumo hemakapukua someraka, “Iraíya fana peraka Keresopoko makata su makotehokosapo, aisane kakaro yasiapo. Keresoane hemakapusimo makata meta soko popasane oyapo. ‘Aporomanomo Tákeane ipi himu nasimo aporo metakiramo eane mokoatikiraka mainamareraka patera tariakosapo,’ aíyaka popasa ane soko hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Arirakano nōmo someana one kakaro somerakaripo. Iraíya peakosaposane kakaro perakasupo. E perakasuane ipu namina yia hemakapukua eane mokoatikisapo. Asiamo Kotimo sawia poparaka ayiakakosapo aisane kakaro yasiapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aporo hakāsa pura isia Yasuyaki ūri terayia hisiane metakarikia peraka aseane, aporo hakāsa pura metakirayaki aporo hinamo yakai sarimaraka risikino asesapo. Ayiáka risike Kotimo somemane tisa aporo metakiramo, aporo hakāsa purayaki tafatafaraka somerakano asesapo. ");
INSERT INTO faa_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Aporo hinamo suamo Yasuane aseraka kára seseraka eane sapenako perakano asekea, ");
INSERT INTO faa_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yasumo iaki someraka, “Repo nōmo aporo pasimosaki makata yakapa me rukua somerakanare?” ");
INSERT INTO faa_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Airakano aporo hakása metamo someraka, “Tisao, nómo ararehoasimo nōmo hokosa karikia pesapo. Yatafumo hokosa ane ho maraka epo makata somerafapo. ");
INSERT INTO faa_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Yatafumo ho masa maiya ámo hokosa ane hauaka atura rukumakasuraka, akai momotoro káraraka, akai kikitiraka, kiki wakapuraka korosakataesapo. Asiamo né peanafonosamo, nómo aporo hakāsa puraki nōmo someraka, ‘Yatafu pusiesie.’ Airakano ipu pusiehoane yatafuane pusuafapo.” ");
INSERT INTO faa_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Airakano Yasumo iaki someraka, “Aporo hinamo maiya omo risiamo Kotiaki himu hakásaraka hemakapukua risikirifapo. Maiya suamo repo makata hasaka hemakapukua risikino, nōmo repoko maiya suamo yaiya wafororaka rakiraka rekeakosare? Ano reyaki maiya káramo rekeno yia repo anoaki himu hakásaraka hemakapukua risikirifapo. Ano rea wo hokosane karikia peae.” ");
INSERT INTO faa_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Airakano hokosane Yasu rea karikia pesapo. Karikia perakano yatafumo Yasuane aseraka, hokosane yatafumo wate foaka mahamisisiraka hauaka atura rukumakasusapo. Rukumakasuhoane, hokosane mokowepe puraka akai momotoro kamusakae kárasapo. ");
INSERT INTO faa_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Arirakano Yasumo hokosa wafayaki someraka, “Masinaka yatafumo hokosane ho masare?” Airakano hokosa wafayamo someraka, “Hokosa kiri yiamo asiapo. ");
INSERT INTO faa_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Maiya suamo nōmo hokosane yatafumo ira rufia soko makasunapo. Hea soko makasunapo. Kukusimo ainapo. Asiamo nómo siahoasisekenone eto kamenakaraka nómo ararerasie.” ");
INSERT INTO faa_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Airakano Yasumo someraka, “Marirakano siahoasireare airakanare? Aporomo anoaki himu hakásaraka rekeno, makata su nōmo rakiane siahoasireapo.” ");
INSERT INTO faa_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Airakano hokosa wafayamo wate foaka someraka, “Nōmo neaki himu hakásaraka hemakapurakanapo. Himu hakásaraka hemakapurane wakasemapo. Wakasemasane kárahoasimo nómo ano ararerasie.” ");
INSERT INTO faa_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Airakano Yasumo aseane, aporo hinamo yakai sarimahoko foaka perakano asekea, yatafu watikisaki epo someraka, “Yatafu nómo hokosane senaki matisane soko, me mahimetesane soko, né metakarikia pusie. Hokosane efera hunia ho mako paripeakopo.” ");
INSERT INTO faa_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Airakano yatafumo kaikia sakepamo wáraka hokosane kára mahamisisiraka marekea, hokosane yatafumo ho masane metakarikia purakano, hokosane kuraka sikisapo. Hokosa kuraka sikirakano aporo hinamo suamo aseraka someraka, “Akure,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Airakano Yasumo hokosa hokonoa maka máfarakano, hokosa turikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Arirakano Yasu apea yorokoa perakano, ipi aporo hakāsa puramo someraka, “Isiapo yatafuane metakarikia pusiehoane punafonorakasane, mairakayiarakapo.” ");
INSERT INTO faa_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Airakano Yasumo someraka, “Yatafu ayiáka risiane pusimo, Kotiaki kurikuriraka reke, yatafu pusierakano pukusapo. Makata metamo pusierakano pukusafapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Hauaka ane ipu metakarikia, Kariri hauaka á pukua, hauaka ane marokeraka, i namina pusuane aporo suamo kaiyakohoamo, Yasu tau pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ipi aporo hakāsa puramo hemakapusimo, some kakako tau pusuapo. Yasumo some karaka, “Aporomanomo Tákeane anopo. Ano rusua kukusimo aporomo ano parakehokosapo. Parakeraka ano waseremaka kukusimo rukusapo. Ano rusua kusuane sere isiamo maturikia taehokosapo.” ");
INSERT INTO faa_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Airakano someane i himetesapo. Himeteraka karekekea namoraka risike ipu Yasuaki “Some kepoane yakapare?” aíyaka somesafapo. ");
INSERT INTO faa_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yasu soko ipi aporo hakāsa pura soko pukua, Kapaneame taonea pauraka, apea yorokoa iaki Yasumo someraka, “Re ikia kara peraka repo namina susu makata yakapa somerakayiare?” ");
INSERT INTO faa_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Airakano ipu me kauraka risiapo. Arirakano i ikia kara puraka risike ipu someraka, “Isu aporo fanane epare?” aíyaka somesasamo kaíyaraka ipu Yasuaki makata somesafapo. ");
INSERT INTO faa_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Somehoanafonorakano, Yasu ipi kake aporo hakāsa pura keno suane peaesapo. Perakano asekea epo someraka, “Aporomo ano aporo kárapo, aíyaka otoa maka, makapororaka hemakapuraka, ‘Ano fanaraka rekeako seseripo,’ aíyaka repo hemakapukupo. Repo namina makama kesekehoanie. Repo aporo supoko rakinie.” ");
INSERT INTO faa_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Aíyaka someraka hokosa metane epo pasimaka i namina hikumisi nenemea reaesapo. Rekeno eane Yasumo hokonomo hokosane ketakamaka paua motokoa, i aporo keno suaki someraka, ");
INSERT INTO faa_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aporo metamo ano himu tumurumo hemakapusuasamo hokosa wakasema asíane ararena ayiáka, ano soko ararerakanapo. Ano arareraka ano hákasa ararerakanafapo. Atamo ano pusiesane soko ararerakanapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yonemo Yasuaki someraka, “Tisao, isiapo aseane aporo metamo né yano hokoa, aporo meta yatafumo ho masane pusierakano pusuapo. Purakano asekea isiapo aporoaki someraka, ‘Ne Yasumo aporo hakāsa purayaki paosafapo. Paohoanafonosasamo yatafu pusiehokopo.’” ");
INSERT INTO faa_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Airakano Yasumo iaki someraka, “Repo aporoane matasoraka somehokopo. Aporomo Kotimo makata wakapuaka rakira rakiakosakipoko ano yano hokoa, ipi wate foaka ano hokomaka somehokosafapo. ");
INSERT INTO faa_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Asiamo aporomo ipi isuyaki weanafonoraka isu ararerakanapo. ");
INSERT INTO faa_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nōmo some one kakaro somerakaripo. Aporo metamo someraka, ‘Né Keresoa paosa aporopo. Asiamo nōmo ne he nasimo karakanapo.’ Aisa aporoaki Kotimo makata ropo kakakosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Yasumo ipi aporo hakāsa puraki someraka, “Hokosamo e ipiane makárahoanafonona ayiáka, anoaki himu hakásaraka hemakapura aporomo watikiaka rakisimo, aporo metamo mokopipirakano, mokopipina aporoane Kotimo kára fanasihokosapo. Mokopipina aporoane, ipi mawia eke kára kita humarekea maka he tawara numua he nasimo makasuhoane siahoasireapo. Ane fanasihokosane wakasemapo. Kotimo fanasihokosane kárahokosapo. ");
INSERT INTO faa_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Arirakano nómo hokonomo makata watikiaka rakiraka rekeno, nómo ní himuane mawatikinapo. Mawatikinapaka, hokono takuane patekemaka mamakatehoanie. Hokono tetákara reke ira kopakapunafonona hauaka heao hauaka á makasuhokohoamo, hokono hakása takuane patekemaka mamakatehoanie. Hokono taku hakása reke yaiya rerane kepomarekea rakiraka reke siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Arirakano heao hauaka á fifita kurafapo. Ira soko kopakapurafapo. ");
INSERT INTO faa_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Arirakano nómo korakemo watikiaka rakiako watikisa taku á puraka reke, nómo ní himuane mawatikinapo. Mawatikinapaka, korake takuane patekemaka mamakatehoanie. Korake tetákara reke heao hauaka á makasuhokohoamo korake takuane patekemaka mamakatehoanie. Korake hakása reke yaiya rerane kepomarekea rakiraka reke siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Arirakano heao hauaka á fifita kurafapo. Ira soko kopakapurafapo. ");
INSERT INTO faa_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Arirakano nómo himo makata watikisane aseraka reke, ní himuane mawatikinapo. Mawatikinapaka, hi takuane pokomaka mamakatehoanie. Hi tetákara reke heao hauaka á makasuhokohoamo, hi takuane pokomaka mamakateraka hi taku hakása reke Kotimo unihaeaka asekea rera á paohoane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Arirakano heao hauaka á fifitaraka reke kurafapo. Ira soko kopakapurafapo. ");
INSERT INTO faa_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Asiamo kifirimo makata makotena ayiáka, aporomo makata watikisa himura kayane ira paikimarekea faraka, himuane makotenapo. ");
INSERT INTO faa_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Arirakano kifiri waperapo. Asiane kifiri wapesane farakano efera hunia waperafapo. Wapehoanafonona ayiáka repo, ‘Aporo fanaraka reane epare?’ aíyaka tafatafana maiya amo aporo metane ararenafapo. Asiamo fanaraka rekeako tafatafahokopo. Aporo hinamo suaki hemakapukua tau auaraka risikianie,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yasu ipi Kariri hauaka ane metakarikia pukua, he Yotane yaoraka taku ra, Yutía hauaka á reapo. Reakipoko aporo hinamo yakai Yasu rea perakano asekea, Yasumo iaki some kasapo. Sere suamo epo some akara ayiáka, i perakano asekea, epo ipi ayiáka some kasapo. ");
INSERT INTO faa_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Yasu reakipoko Ferese aporo peraka, Yasu kau aseakosakipoko epo hasaka somerakarihoamo, ipu eaki someraka, “Aporomo ipi hinamo fimareane siahoasireare? Fimareane somemaneane mamosohoasireare?” ");
INSERT INTO faa_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Airakano Yasumo ipi someraka, “Mosesemo somemanemo yakapa someaka motosare?” ");
INSERT INTO faa_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Airakano ipu aporo hakása metamo someraka, “Fana Mosesemo someraka, ‘Hinamo arumasa fimareako hinamoaki sawi poparaka kakanie,’ aisapo.” ");
INSERT INTO faa_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Airakano Yasumo someraka, “Repo Kotimo someane koaretaesasamo Mosesemo aporoaki someraka, ‘Hinamo fimareane siahoasireapo,’ aísapo. ");
INSERT INTO faa_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Asiāne wate fana kepomaresa maiya amo, Kotimo aporo soko, hinamo soko, tetákara rakisiapo. ");
INSERT INTO faa_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Rakiraka Kotimo someraka, ‘Aporomo ipi kaīyia ipi wafaya metakarikia, hinamo arumaraka ipi hinamoyaki hakāsa paoraka, ");
INSERT INTO faa_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","tati kau hakásaraka risikinapo.’ Tati kau hakásaraka risirasamo tetáraka risikinafapo. Hakásapo. ");
INSERT INTO faa_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Asiamo Kotimo hinamo aporo tati masarimasane, aporo metamo maparakuhoane siahoasifareapo.” Aíyaka Yasumo Ferese aporoaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Someaka faraka Yasu apea pukua reakipoko, aporo hakāsa puramo Yasuaki someraka, “Someane kepoane yakapare?” ");
INSERT INTO faa_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Airakano Yasumo iaki someraka, “Aporomo hinamo arumasane ipi apiamo hisiraka, e fimarekea hinamo meta arumarakano, aporoamo hinamo metane haki arumarakanapo. ");
INSERT INTO faa_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Arirakano hinamo aporo pusuane ipi aporo hisiraka metakarikia, aporo meta purakano, hinamoamo aporo metane haki purakanapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yasu reakipoko hokosa karikia pesapo. Karikia pesane Yasumo hokonomo sakairaka makotehoasimo karikia pesapo. Karikia pesa aporo hinamoaki Yasumo ipi aporo hakāsa puramo himu mahisiraka iaki someraka, “Hokosa karikia peakopo.” ");
INSERT INTO faa_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Airakano Yasumo kairaka mahisiraka someraka, “Ano rea hokosa peane siahoasireapo. Perakano matasohokopo. Aporo hinamo e ipiane makáranafaraka, hokosa mano ayiáka risiane, Kotimo unihaeaka asekea rekenapo. ");
INSERT INTO faa_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Hokosa manomo ipi wafaya kaīyiamo eane koteaka asekea rekeasimo, himu hakásaraka hemakapura ayiáka, aporo hinamomo Kotiaki himu hakásaraka hemakapurakano, Kotimo iane asekea rekenapo.” ");
INSERT INTO faa_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Aíyaka someaka marekea hokosane Yasumo fatuaka maka, i kaua ipi hokonomo sakairaka i koteaka risikiasimo, koteaka risirane iaki kasapo. ");
INSERT INTO faa_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kimisi pukusa maiya amo, aporo hakása meta foaka pekea Yasu hikumisi nenemea kakuna porokoa kake someraka, “Tisa kotesao, ano Kotiyaki yaiya rekeakosakipoko nōmo makata yakapa rakiakosare?” ");
INSERT INTO faa_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Airakano Yasumo someraka, “Nómo anoaki marirakano, ‘Tisa kotesao,’ airakanare? Kepoane hemakapunie. Koti ipi hákasa kotesapo. Aporo meta kotesa rekenafapo. ");
INSERT INTO faa_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kotimo somemaneane nómo hemaka apure. Somemane ane oyapo. ‘Aporo kukusimo rukupo. Hinamo hakimakopo. Makata meta hakimakopo. Aporo metaki kotafe topakamahokopo. Makata ropo sapeane hakimakopo. Ní ata soko, ní ama soko, koteaka hemakapukua makotehoanie.’ Aíyaka somemane motosane nómo kaisiapo.” ");
INSERT INTO faa_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Airakano aporoamo someraka, “Tisao, ano hokosa rea maiya amo, somemane ane kakimaka yaiya reapo.” ");
INSERT INTO faa_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Airakano Yasumo e aseraka, eaki himu tumurumo hemakapuraka someraka, “Nómo makata hakása meta siasafapo. Nómo makata kemo su ropohoko pusie. Pukua makata kemoane roporaka marekea, mone mosane aporo makata forokoa risiaki kakanie. Kaka farakano amo, nómo makata mahimunane hepene yapura tokenapo. Ní makata kemo kaka faraka, ano patera aseako peanie.” ");
INSERT INTO faa_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Airakano aporoamo kaikia ipi makata kemo kárasasamo, aporo metakiraki kakako hisiraka, ipi hikumisi yuyukuraka Yasu metakarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Purakano asekea, Yasu rekeako pariraka, ipi aporo hakāsa puraki someraka, “Makata kemo káraraka rea aporoane, Koti unihaeaka rea paohokosane, namo kakaro waforonapo.” ");
INSERT INTO faa_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Airakano aporo hakāsa puramo kaikia fofaraka risikino asekea Yasumo efera hunia someraka, “Hameo, Kotimo ré unihaeaka asekea rekeasimo paohokosane namo kakaro waforonapo. ");
INSERT INTO faa_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pasu irina nitoro kakarua saro kamo kárasasamo kokoro puane tapenapo. Aina ayiáka makata kemo kára mora aporoane Koti unihaeaka rea paohokosane namo kakaro waforonapo.” ");
INSERT INTO faa_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Airakano ipu kára fofaraka mahimeteraka eaki someraka, “Aporo makata kemo kárasane Kotimo unihaeaka asekea rekeasimo aohokosane namo kakaro waforonapo, airakae. Asiamo Kotimo aporoane mafasiasimo aporo epa paohokosare?” ");
INSERT INTO faa_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Airakano Yasumo i asekea someraka, “Aporoane Kotimo unihaeaka asekea rekeasimo aporomo ipi yiamo mafasirafapo. Makata su rakiakosane Kotimo ipi hákasa hemakapukua rekenapo. Asiamo aporo hinamoane Kotimo mafasiakosane Koti ipi hákasa siasapo.” ");
INSERT INTO faa_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Airakano Pitamo someraka, “Isiapo menane su metakarikia né patera aseako pesapo.” ");
INSERT INTO faa_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Airakano Yasumo someraka, “Nōmo kakaro somerakaripo. Aporo hinamo suamo hakása hakásaraka anoaki hemakapuraka, nōmo rakirane rakiakosakipoko, nōmo some kotesane some kakakosakipoko, ipi ape metakarikia, ipi mae metakarikia, papā metakarikia, apu metakarikia, ama metakarikia, ata metakarikia, hokosa metakarikia, hauaka metakarikia, ayiáka makata su metakarikia rea aporoamo ");
INSERT INTO faa_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","hauaka wo makata kára mokoakosapo. Mokoakosane oyapo. Ape soko, hauaka soko mokoakosapo. Aporo hinamo metakirane nómo ní mae, ní papā, ní apu, ní ama, ní hokosa ayiáka risikiakosapo. Arirakano aporo metakiramo ne mokoatikihoko ayiane, keseke né Kotiyaki yaiya rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Asiamo yumo aporo yakai fanaraka risiane kesekehokosapo. Aporo yakai yumo kesekea risiane fanahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yasu Yarusarame sitia fana hisiakipoko, ipi aporo hakāsa pura kesekea hinaka, himumo kára hemakapupe hisiapo. Arirakano aporo hinamo metakira kesekea kekemarape hinaka, “Yarusarame sitia pauna maiya amo, yakapa ayiakanarakapo,” aíyaka kára hemakapukua hisiapo. Hisia maiya amo aporo keno suane Yasumo karikia, wakasema hikia keseke Yasu ipiaki makata ayiakakosane iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Yasumo someraka, “Isu Yarusarame sitia hinakanapo. Yarusarame sitia aporo metakiramo Aporomanomo Táke anoane parakehokosapo. Parakerakano pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, ano kukusimo ira paremaresie aihokosapo. Aíyaka ano kukusimo Yu aporohoanafonosamo ano ira paremareakosakipoko karikia pukusapo. ");
INSERT INTO faa_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Karikia purakano, Yu aporohoanafonosamo ano mokoatikiraka mahokoparihokosapo. Mahokopariraka anoaki torofaeraka, ano kaua rukua, ano rusua kukusapo. Rusua kurakano sere isiamo Kotimo ano maturikia taehokosapo,” aíyaka Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sepetemo hokosa Yamesepe Yone tetā Yasu rea peraka Yasuaki someraka, “Tisao, etapo hemakapusuane nómo ayiakasimoripo.” ");
INSERT INTO faa_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Airakano Yasumo tetāki someraka, “Nōmo tetopoko makata yakapa ayiakasimore?” ");
INSERT INTO faa_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Airakano tetapō someraka, “Né unihaeaka faesa area maiya amo, eto meta né hokono tumuru takua kayae, arirakano eto meta né hokono kasakai takua kayae aihoasimoripo.” ");
INSERT INTO faa_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Airakano Yasumo someraka, “Tetápo somerakane kepoane tetápo hemakapurakarifapo. Nōmo kapo he nená tetápo soko nasireare? Arirakano aporo hea tapukumarera ayiáka anoane umisamo karo tapiakosapo. Ano umisamo karotapira ayiáka teto soko umisamo karotapiane siahoasireare?” Aíyaka Yasu ipiane mokoatikiraka rusua kukusane somesapo. ");
INSERT INTO faa_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Airakano tetapō someraka, “Ao, eto siahokosapo.” Airakano Yasumo tetāki someraka, “Nōmo kapo he nená hakása yia tetápo kakaro nakosapo. Ano hea tapukumarerakano, teto soko hea tapukumuriakosapo. ");
INSERT INTO faa_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Arirakano ano hokono tumuru takua kakakosane soko, hokono kasakai takua kakakosane soko, nōmo kayae aihokosafapo. Nōmo nī Atamo ipi hemakapusua aeyaka seā maroposane murikimasapo.” ");
INSERT INTO faa_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Airakano aporo hakāsa pura kaeyako sumo kairaka, Yamesepe Yone tetāki hisisapo. ");
INSERT INTO faa_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Hisirakano aporo hakāsa pura suaki Yasumo peaesapo. Perakano asekea Yasumo iaki someraka, “Yu aporohoanafonosamo ipu namina aporo unihaemo aporo metakiraki kára masamasanapo. Aporo unihae e ipi káraraka reasasamo aporoaki masamasaraka matewanapo. ");
INSERT INTO faa_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Aina ayiáka re ayiáka risikiakopo. Repo namina aporo metamo hemakapuraka, ‘Ano aporo káraraka rekeariripo.’ Aíyaka hemakapuraka aporo wakasemamo arakira ayiáka, aporo supoko arareraka rakinie. ");
INSERT INTO faa_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aporo metamo hemakapuraka, ‘Ano aporo fanaraka rekeariripo.’ Aíyaka hemakapura aporoamo aporo raipamo arakira ayiáka, aporo supoko rakinie. ");
INSERT INTO faa_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Aporomanoaki tákehoko ano hauaka wo pesapo. Aporo raipamo arakira ayiáka, aporomo anopoko ayiáka rakisimo, ano pesafapo. Aporomano supoko aporo raipamo arakira ayiáka rakiako ano pesapo. Aporomanomo namina watikisapoko i fanasihokohoamo nōmo farimaka kukuko pesapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yasu soko ipi aporo hakāsa pura soko pekea, Yariko taoneane marokeraka purakano, ipi aporo hakāsa pura soko, aporo hinamo yakai Yasuyaki hakāsa puraka aseane, aporo hakása meta Tímiasimo maeya ipi yano motosa Pataméase, ipi hi taku tetákara mesa, ikia kara fea mone kakasimo kakeno asesapo. Ayiáka kake Pataméasemo kaiyiáne, ");
INSERT INTO faa_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nasare aporo Yasuane perakarakano kaikia, ipi sakepamo wáraka, “Yasuo, Tefetemo aporo irao, anoane kamenakaraka ararerasie.” ");
INSERT INTO faa_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Airakano aporo hinamo metakiramo eaki paroaka someraka, “Wáhokopo. Me fasie.” Airakano Pataméasemo efera hunia sakepamo wáraka, “Tefetemo aporo irao, anoane kamenakaraka ararerasie.” ");
INSERT INTO faa_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Airakano Yasumo kairaka e pesane wasuaka rukua asekea reapo. Asekea reke Yasumo someraka, “Aporoane wo peae.” Airakano ipu aporo hi mesaki someraka, “Ne wo peaerakae. Asiamo né karekeakopo. Ne takahisie.” ");
INSERT INTO faa_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Airakano aporo hi mesamo ipi pasu horomaka foakayia takahikia, Yasu rea pesapo. ");
INSERT INTO faa_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Perakano Yasumo eaki someraka, “Nómo sesehoasimo nōmo mayiakasimore?” Airakano aporo hi mesamo someraka, “Tisao, nōmo himo koteaka aseakoripo. Hiane makotehoanie.” ");
INSERT INTO faa_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Airakano Yasumo someraka, “Nómo anoaki himu hakásaraka hemaka apura yiamo, né hi mesane mafarakayiapo. Né pusie.” Aihoane aporo hi mesane faraka ipi koteaka asesapo. Koteaka aseraka Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Aporo hinamo yakai Yasuyaki hakāsa ikia kara hisiapo. Hikia Yarusarame sitiane makeraka pausapo. Yarusarame sitiane makeraka ūri Orofe rekenapo. Ūri Orofe makeraka Péfasi ape soko, Petene ape soko kisia á i pausapo. Pauraka Yasumo aporo hakāsa pura tetáki ");
INSERT INTO faa_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","someraka, “Teto ape tameyia pusie. Pukua aseane ape fari yia saro toki mano humaresa ipi matia aporo meta ripakanafonosa kita humaresa rekeno aseakosapo. Aseraka kita fatarimaka ano rea karikia peanie. ");
INSERT INTO faa_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Arirakano aporo metamo tetoaki someraka, ‘Tetápo marirakanonare?’ Airakano tetápo someraka, ‘Unihaemo saro tokiane karikia peaniesasamo, etapo karikia purakanapo. Epo saro tokiyaki makata rakikia faraka, karikia paripusierakano, saro tokiane karikia paripeakosapo,’ aíyaka somehoanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Aíyaka somerakano aporo hakāsa pura tetā pukua aseane saro toki mano ikia koro makeraka hauaka moroa ikia kara á kita humaresekeno asesapo. Asekea saro tokiane tetapō fatarimasapo. ");
INSERT INTO faa_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Fatarimarakano, aporo risiamo someraka, “Mainakano saro toki manoane fatarimarakanare?” ");
INSERT INTO faa_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Airakano tetapō Yasumo somesane iaki somesapo. Somerakano aporoamo someraka, “Ao, karikia pusie.” ");
INSERT INTO faa_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Airakano tetapō karikia pukua, Yasu rea saro toki manoane karikia pesapo. Karikia perakano aseraka, aporo yakaimo pasuane saro toki matia furumurikia marekea, Yasu á ripasapo. ");
INSERT INTO faa_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ripaka perakano asekea, “Yasu ipi aporo hokopusuareapo,” aíyaka aporo hinamo yakai ipu suamo pasu ikia kara á ifunusapo. Arirakano aporo hinamo metakiramo makata kū hemoa popatesane, ikia kara á ifunusapo. ");
INSERT INTO faa_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ifunusakipoko Yasu perakano aporo hinamo metakira fanaraka, i metakira kesekeraka ayiáka pesapo. Peraka ipu wárape peraka, “Hosana. Isiapo né pasimarakanapo. Né pesane aporo kárapo. Unihae Kotimo né pusiesamo epo né makotesapo. ");
INSERT INTO faa_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Isiapo makasa kaua kekema Tefetemo unihaeaka asekea rea ayiáka, nómo unihaeaka asekea rekeakosapo. Unihaeaka asekea rekeakosane Kotimo makoterakanapo. Asiamo Koti hepene apea reane isiapo kekererakanapo. Hosana.” ");
INSERT INTO faa_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Aíyaka ipu wárape hikia Yasu Yarusarame sitia hikia pauraka, Kotimo apeane aseako pusuapo. Pukua makata suane asekehaesapo. Maiya tuakeramo Yasumo Kotimo apeane metakarikia aporo hakāsa pura kenosuyaki Petene apea pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ere hakása waka mituru fiarakano, Petene ape metakarikia hikia Yasu meamorakano ");
INSERT INTO faa_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","aseane wakasema yamenoa ira foke namo ku susu rekeno asesapo. Aseraka ira foke kepoa pukua ira wate tumakosakipoko aseane, ira foke wate ikia heanafonoraka kū susu rekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Asekea Yasumo iraki someraka, “Efera hunia ne wate peakosafapo. Keseke aporomo wate nasimo peraka, ne wateane nakosafapo,” aíyaka somesapo. Aíyaka somesane ipi aporo hakāsa puramo kaisiapo. ");
INSERT INTO faa_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Yasu ipi aporo hakāsa purayaki Yarusarame sitia hikia pauraka, Kotimo apea Yasu yorokoa puraka, Yasumo aseane, aporo metakiramo makata roporaka risikino, asekea rukuhoaeraka pusiesapo. Aporo metakiramo mone sanasiraka risikino, teporoane maparitaesapo. Aporo metakiramo mena nume asia roporakano, i sea toane soko maparitaesapo. ");
INSERT INTO faa_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Maparitaeraka Yasumo iaki someraka, “Kotimo apea makata mokoa perakano purakano ayiakakopo. ");
INSERT INTO faa_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Arirakano Kotimo sawia fana porofete aporo Aesayamo popasane oyapo. Kotimo someraka, ‘Aporo hinamo hauaka sua risiamo someraka, “Isiapo Kotiaki somehokosakipoko, Kotimo apea peraka kurikurihokosapo,” airapo.’ Aira nine Kotimo ape one repo hakimora aporomo kunikia mapariane.” ");
INSERT INTO faa_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Airakano pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, ipu Yasumo someane kairaka Yasu kukusimo ruko hemakapusuapo. Yasumo some karane aporo suamo kaikia, “Kotehoareapo,” airakano asekea, pirisiti aporo káramo kakanakeraka risike, Yasu rukusapoko asiāne i namoraka karekesapo. ");
INSERT INTO faa_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Yao nenehoramo Yasu soko, ipi aporo hakāsa pura soko, Yarusarame sitiane metakarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mituru i poparihikia aseane ira foke fana asesane pikinu soko porasekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Asekea Pitamo Yasumo somesane hemakapukua, Yasuaki someraka, “Tisao, asesie. Nómo fana someraka ira fokeane efera hunia aporomanomo wate nakosafapo, airakasuane porahoareapo. Nómo asesie.” ");
INSERT INTO faa_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Airakano Yasumo someraka, “Kotiaki himu hakásaraka hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nōmo reaki some one kakaro somerakaripo. Repo aporo hinamo metamo someraka, ‘Ūri né takahikia he tawara sokoperasie.’ Aíyaka himu tetáraka hemakapurafaraka kakaro himu hakásaraka hemakapukua, ayisierakano ayiakakosapo. Aíyaka hemakapukua rekeno Kotimo ayiáka rakiakosapo. ");
INSERT INTO faa_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Asiamo repo kurikurina maiya amo, Kotiaki makata kairaka kakaro Kotimo anakanapo, aíyaka hemakapukua kurikurirakano, makatane kakaro ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kurikurina maiya amo, nómo aporo metaki mahisiraka reane mafarasie. Nómo watikisane Kotimo mafahoasimo nómo aporo metaki hisisane soko mafarasie. Aíyaka kurikurirakano Kotimo nómo watikisane mafahokosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Arirakano Yasumo some meta someraka, “Nómo hisisane soko ropo mokoatikinane soko metakarianafonorakano, nómo watikisane soko nómo Ata hepene yapura reamo metakariakosafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yarusarame sitia Yasu ipi aporo hakāsa purayaki hunia poparihikia, Yasu Kotimo ape makeraka koraka reakipoko pirisiti aporo kára soko, Kotimo somemane tisa aporo soko, aporo sisima soko, i su pekea ");
INSERT INTO faa_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yasuaki someraka, “Nómo arakirane epamo maresare? Nómo ayiáka rakisimo epamo néaki ayiáka rakinie, aisare?” ");
INSERT INTO faa_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Airakano Yasumo iaki someraka, “Nōmo reaki makata hakása meta akai kairakanapo. Kaiyiane repo anoaki some pariperakano, kaikia anoaki rakiniesane nōmo reaki somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yonemo aporo hinamo hea tapukumurianiesane Kotimo aisare? Aporomo aisare? Epamo aisare? Repo anoaki somesie.” ");
INSERT INTO faa_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Airakano namina susu tafatafaraka someraka, “Isiapo Yasuaki yakapa somehoanarakapo. Isiapo someraka, ‘Kotimo aisapo,’ aíyaka somerakanone, Yasumo isuaki someraka, ‘Mairakano Yonemo someane kakipayasare?’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Arirakano isiapo someraka, ‘Aporomo aisapo,’ aíyaka somerakanone, aporo hinamo suamo isuaki mahisiraka sapehokosapo. Aporo hinamo suamo hemakapuraka, ‘Yone ipi kakaro porofete aporopo. Ipi kakaro Kotimo some kara aporopo.’” Aíyaka ipu hemakapusuasamo iaki namorakanapo. ");
INSERT INTO faa_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Asiamo namina tafatafaraka Yasuaki someraka, “Yonemo aporo hinamo hea tapukumurianiesane epamo aisarakapo. Isu himeteripo.” Airakano Yasumo someraka, “Repo anoaki some paripeanafonosasamo, anoaki rakiniesa kepoane reaki somehokosafapo,” aíyaka Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yasumo takumeaka someraka, “Hemo wafayamo sako karepe hemo ane porokoa marekea, keseke rurusapo. Rururaka sako wate nenekeaneraka he pusimo, eke karoraka maua asia rakisiapo. Rakiraka aporomo hemoane koteaka asekea rekeasimo, huturu ape kisiapo. Kikimarekea hemoane aporo metakiramo asekea risikiasimo aporo metakira murikimaka murisiapo. Murikimaka faraka, hemo wafayamo aporoane soko, ipi hemoane soko metakarikia, hauaka meta á pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Pusuakipoko sako karepe wateane ikia ahera maiya amo, hemo asekea risia aporomo sako karepe wateane tumusapo. Tumokoa parakuraka hemo wafayamo somesane kaikia taehoko asiāne, ipu koaretaeraka hemakapukua, hemo wafayapoko taesafapo. Arirakano hemo wafayamo ipi aporo raipaki someraka, ‘Sako karepe wateane anopoko taesane nómo mokoako pusie,’ aisapo. Airakano aporo raipamo mokoako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","E pukua hemoa perakano, hemo asekea risia aporomo e rukua, sako karepe wate soko kakanafonoraka nena pusiesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Arirakano efera hunia sako karepe wate mokoako hemo wafayamo aporo raipa metane pusiesapo. Pusiesane hemoa perakano, hemo asekea risia aporomo e wamoa rukua e mokoatikiraka mainamaresapo. ");
INSERT INTO faa_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Rukua mokoatikiraka mainamaresane asekea hemo wafayamo aporo raipa metaki sako karepe wate mokoako pusiesapo. Pusiesane hemoa perakano, hemo asekea risia aporoamo e rusua kusuapo. Aporo raipa metakira soko yasiapo. Aporo raipa metakira rukua, arirakano aporo raipa metakira kakaro rusua kusuapo. ");
INSERT INTO faa_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Arirakano hemo wafayamo hemakapuraka, ‘Aporo hakása meta rekenapo. E nōmo hokosapo. Eane nōmo kára himu tumurumo hemakapukua rekenapo. Eane nōmo hokosasamo ipu mokoatikihokosafapo.’ Aíyaka hemakapukua ipi hokosaki someraka, ‘Sako karepe wate mokoako pusie,’ airakano hokosa ane ipi pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pusuane hemoa perakano, hemo asekea risia aporomo someraka, ‘Hemo wafayamo hokosane apere. Arirakano keseke ipi wafayane kusuakipoko finihaoa e reke, hemo one epo asekea rekeasireapo. Anapaka e rukusapo. Rusua kurakano hemo one isiapo isina makosapo. Asiamo isiapo isina wafayaraka asekea risikiakosapo.’ ");
INSERT INTO faa_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Aíyaka hokosa ane ipu waseremaka rusua kurakano, hemo ruru tapikia tama takua makasusapo. ");
INSERT INTO faa_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Asiamo keseke hemo wafaya aperamo hemo asekea risia aporoane mayiakakosare? E pekea epo hemo asekea risia aporoane rusua kukusapo. Rusua kurakano aporo metakiramo hemoane koteaka asekea risikiasimo murikimakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Arirakano Yasumo aporo hinamo suaki someraka, “Kotimo sawia some one popasane repo menosafare? Kotimo sawia popasane oyapo. ‘Ape kira aporomo ira warupi mamakatesane efera hunia maka pekea tipia mapohoareapo. ");
INSERT INTO faa_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Mapohoareane Kotimo ipi ayiáka rakireapo. Ayiáka rakisikino isiapo aseraka someraka, “Ane kotehoareapo,” airapo.’ Aíyaka popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Aíyaka Yasumo somerakano, Ferese aporomo kaikia hemakapuraka, “Yasumo isuane hukurukua marekea takumeaka somerakae.” Aíyaka hemakapukua, Yasu tipura makeasimo waseremakosakipoko asiāne, aporo hinamo ipu suamo iaki saperapaka, Yasuane metakarikia i pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ferese aporomo soko, Heroteaki patera asesa aporomo soko, Yasu rea aporo metakirane pusiesapo. Yasumo hasaka somerakarihoamo, mahoperaka akai kaiyako pusiesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pusierakano i pukua, Yasu rea pekea someraka, “Tisao, nómo someane namo kakaro somerakae. Aíyaka isiapo hemakapurakaripo. Arirakano aporomo néane mokoatikihokosane nómo ní hemakapurafaraka nómo kakaro somerapo. Aporo kárane sesehoasimo nómo hokokaraka somerafapo. Kotimo ainane nómo kakaro some akare. Asiamo neaki isiapo akai kairakanapo. Isiapo Yu aporomo Rome aporo unihaeaki takese mone kayane siahoasireare? Kayane Kotimo somemaneane mamosohoasireare? Mayiakasireare? ");
INSERT INTO faa_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Isiapo takese mone motoakosare? O metakariakosare?” Airakano ipu himu tetáraka hemakapukua risike, ipu some yapake somesane Yasumo ipi aseraka iaki someraka, “Nōmo hasaka somerakano nōmo nī some yiamo kakinumo maká arura ayiáka, ano nīane rusimo repo aíyaka somerakae. Nōmo hasaka somerakano repo ano tipura makeako somerakae. Asiamo mone haeane nōmo aseako maka peae.” ");
INSERT INTO faa_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Airakano ipu mone hae maka pesapo. Maka perakano Yasumo asekea iaki someraka, “Aporo epa hikumisi mone haea rekerire? Epa yano motosa popahoareare?” Airakano ipu someraka, “Rome aporo unihae Sisa hikumisireapo. Ipi yano motosa popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Airakano Yasumo someraka, “Rome aporo unihaemo menane ipiaki kakanie. Kotimo menane Koti ipiaki kakanie.” Airakano ipu kairaka himu fasapo. ");
INSERT INTO faa_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Satusi aporo Yasu rea peraka ipu hemakapuraka, aporo kusuane maturikia taenafapo. Aíyaka hemakapukua ipu Yasuaki someraka, ");
INSERT INTO faa_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tisao, Mosesemo someaka popasane oyapo. ‘Aporo metamo ipi mamaneamo hokosa hokono mareanafonoraka kurakano asekea, ipi mamaneamo hinamo yaroane arumarapo. Aporo kusua amo hokosa wainenaka sikiraka wainasimo hinamo yaroane ipi mamaneamo arumarapo.’ Aíyaka Mosesemo someaka popasane isiapo menosapo. Asiamo isiapo neaki akai kairakanapo. ");
INSERT INTO faa_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aporo yatipinusu risiane namina mamanea hakāsapo. Mamanea fanamo hinamo arumasane hokosa hokono mareanafonoraka kurakano, ");
INSERT INTO faa_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","mamanea kusuamo patera yiamo, hinamo yaroane arumasapo. Epo soko hokosa hokono mareanafonoraka e kusuapo. Kurakano epo patera yiamo hinamo yaroane arumasapo. Arumasane epo soko hokosa hokono mareanafonoraka kurakano, ");
INSERT INTO faa_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ayipe pukua, mamanea yatipinusuamo hinamo yaro hakásane arumape pukua, hokosa hokono maresafapo. Keseke hinamo manokonomosane kaina keseke e kusuapo. ");
INSERT INTO faa_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kusua maturikia taeana maiya amo, hinamo ane epamo hinamore? Hinamoane aporo yatipinusumo arumasapo.” ");
INSERT INTO faa_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Airakano Yasumo someraka, “Kotimo someane porofete aporomo sawia popahoareapo. Popasane soko, Kotimo ipi wakapuane soko, repo himeteraka hasaka hemaka apure. ");
INSERT INTO faa_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aporo kusua maturikia taerakano hepene aporo arisia ayiáka risikiakosapo. Ayiáka arisia maiya amo aporo kusua maturikia taesamo hinamo kusua maturikia taesane arumarafapo. ");
INSERT INTO faa_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Arirakano aporo kusua maturikia taena amo kepoane Mosesemo popasane oyapo. Ira fete kokosususakipoko arakaru aeyaka ira rufiraka rea maiya amo, Kotimo Moseseaki someraka, ‘Eparahamemo Kotiane anopo. Aisakemo Kotiane soko anopo. Yakopemo Kotiane soko anopo.’ Aíyaka somerakano Mosesemo popasane repo menoraka kepoane repo himeteane. ");
INSERT INTO faa_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Popasa amo kepoane oyapo. Koti ipiane aporo hitafe arisiamo Kotipo. Ipi aporo kukua kesamo Kotifapo.” Aíyaka Yasumo somesa amo kepoane oyapo. Eparahame soko, Aisake soko, Yakope soko kusua nine, i yaiya hitaferaka risikinapo. Asiamo Yasumo Satusi aporoaki someraka, “Satusi aporo repo fana somerakasane hasaka somerakae,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kotimo somemane tisa aporo hakása meta pekea aseane, Satusi aporomo Yasuaki me rukua somesa maiya amo, ipu someane Yasumo hurutapirakano asekea, aporo pesa amo Yasuaki someraka, “Kotimo somemane meta mane fanare?” ");
INSERT INTO faa_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Airakano Yasumo someraka, “Isiraya aporo repo kaisie. Isiapo Unihae Koti ipi hákasa unihaeaka rekenapo. ");
INSERT INTO faa_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Asiamo repo Unihae Kotiaki himu tumurumo hemakapunie. Repo homo soko eaki hemakapunie. Repo himu hemakapuramo soko eaki hemakapunie. Repo wakapumo soko eaki kataka mareanie. ");
INSERT INTO faa_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Arirakano Kotimo somemane metane oyapo. Nómo níane himu tumurumo hemaka apura ayiáka, aporo metane soko ayiáka himu tumurumo hemakapunie. Ayiáka somemane tetá ane kakaro fanapo. Some meta fanafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Airakano Kotimo somemane tisa aporomo someraka, “Tisao, nómo somerakane kakarorakae. Koti ipi hákasapo. Unihae Koti meta rekenafapo. Nómo airakane kakarorakae. ");
INSERT INTO faa_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Eaki himu tumurumo hemakapuramo soko, wakapuaka hemakapuramo soko, nómo níane himu tumurumo hemaka apura ayiáka, nómo aporo metane ayiáka himu tumurumo hemakapunie. Airakane kakarorakae. Kotimo sesehoasimo somemane tetá ane kekemaraka rakirane kakaro fanapo. Kotiaki makata rukua paikia karáne kesekepo.” ");
INSERT INTO faa_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Airakano epo koteaka hemakapukua somesakipoko, Yasumo eaki someraka, “Kotimo né unihaeaka asekea rekeakosa maiyane makepo,” aisapo. Airakano ipu Yasuaki makata kaiyakosapoko asiāne, ipu some ane hurutapirakano, efera hunia makata meta akai kaisiafapo. ");
INSERT INTO faa_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Aporomo hemakapusimo Kotimo ape makeraka taku meta á Yasumo someraka, “Kotimo somemane tisa aporomo someraka, ‘Keresoane Tefetemo aporo ira wainepe pesa amo apororeapo,’ airakasupo. Airakane marirakanore? ");
INSERT INTO faa_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wate fana Ho Kotesamo Tefeteaki mahemakapurakarakano Tefetemo someraka, ‘Nōmo Unihaeaki Unihae Kotimo someraka, “Ne ano hokono tumuru takua kayae. Hokono tumuru takua aporo hokopusua akaya ayiáka kayae. Kakeno nómo yunuane nōmo rukumosakatapiakosapo,” aisapo.’ Aíyaka Kotimo somesane Tefetemo popahoareapo. ");
INSERT INTO faa_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Asiamo Tefetemo Keresoaki someraka, ‘Ne nōmo Unihaepo,’ aisane marirakano aisare? Arirakano makasa kauamo ipi hokosa wainepe pukusaki ‘Unihaepo,’ airafapo. Asiamo Tefetemo Keresoaki ‘Unihaepo’ aisasamo, Tefete takapeasiraka Keresoane wate fana yaiya reapo. Asiāne repo someraka, ‘Tefetemo wainepe pesa á Kereso faserepeakosapo,’ airakae. Airakane marirakanore?” Aíyaka Kotimo somemane tisa aporomo someane Yasumo hurutapikia somerakano, aporo hinamo suamo kaikia kakaro sesesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yasumo some kasa maiya amo some kasane oyapo. Epo someraka, “Kotimo somemane tisa aporomo arakira ayiáka, repo soko ayiáka rakiakopo. Ipu pasu horopokara osoraka pukua aporo hinamo sarimaraka risiakipoko i puraka, aporomo i hokono moraka i makáraraka someraka, ‘Tisa karao,’ aihoasimo kára sesenapo. ");
INSERT INTO faa_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Arirakano Yu aporomo sarimana apea pukua, aporo hinamo su sarimaraka toakipoko, i hikumisi neneme sapea sea tokoako sesenapo. Hokono akera maiya amo aporomo i makáraraka, aporo unihae hokopusua káramo sea á tokoako sesenapo. ");
INSERT INTO faa_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Arirakano hinamo yaromo mone soko, makata kemo soko, iaki kakasimo hinamo yaroane manamorapo. Ipu hakimakosakipoko ayiáka manamorapo. Manamoraka yia aporomo i kotehoareapo, aihoasimo ipu kurikuriraka risike, some horopo some nokone pukua kurikurinapo. Asiasamo i suane fanasihokosane kakaro kárahokosapo.” Aíyaka Kotimo somemane tisa aporomo ainane Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kotimo apea maua motosakipoko, taku ra Yasu kake aseane, aporo hinamomo mone mokoa pekea Kotiaki kakako maua kesapo. Makata kemo kára toa aporo hinamo ipu suamo mone kára kesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Arirakano hinamo yaroane makata forokoa kayasasamo ipi mone hae kusua tetá makesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Mone hae kusua tetá makerakano asekea, Yasumo ipi aporo hakāsa purane peaesapo. Perakano asekea Yasumo iaki someraka, “Aporo hinamo ipu suamo mone kesane, hinamo yaromo mone makesa amo marokesapo. ");
INSERT INTO faa_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ipu mone kaka faraka mone metakira yia tokenapo. Arirakano hinamo yaroane ipi makata forokoa kayasasamo mone wakasema kayane su maka pekea kasapo. Mone meta ipi apea kakenafapo.” Aíyaka Yasumo ipi aporo hakāsa puraki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kotimo apeane Yasumo metakarikia pusua maiya amo, ipi aporo hakāsa pura hakásamo eaki someraka, “Tisao, Kotimo apeane asesie. Ekemo ape kisiane namo kakaro kotehoareapo. Asiamo apeane namo kakaro kotesapo.” ");
INSERT INTO faa_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Airakano Yasumo eaki someraka, “Kotimo ape etapo aserane, eke ripape hikia, ape kisiane keseke kokoromokoteraka hakása hakásaraka tokoakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yasu ūri Orofea hikia ūri kakafae aeyaka aseane, Kotimo ape rekeno asekea kake, Pita soko, Yamese soko, Yone soko, Enitu soko pekea, namina hakāsa risike Yasuaki ipu someraka, ");
INSERT INTO faa_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nómo somerakane masinaka ayiakakosare? Kotimo ipi makata su ayiakakosane maiya mamo ayiakakosare? Isiapo hemakapusimo makata yakapamo isuaki tariakosare?” ");
INSERT INTO faa_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Airakano Yasumo someraka, “Asekeanie. Keseke makata ayiákakosane oyapo. Aporo metakiramo reaki kotafe somerakano ipu someane kakimarapaka asekeanie. ");
INSERT INTO faa_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aporo yakai peakosapo. Pekea ipu kotafe someraka, ‘Ano Keresopo. Unihae makárasane anopo.’ Aíyaka ipu ano yano hokoa kotafe somerakano, some ane aporo yakaimo kakimakosapo. Asiamo repo asekeanie. ");
INSERT INTO faa_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Arirakano aporomo ape sumu metayaki werakanaporakano, repo kaiyakosapo. Ape sumu makea soko, ape sumu yamenoa soko werakanapo, aíyaka some tokomako pukua somerakano soko repo kaiyakosapo. Kaikia himu fahokopo. Aporomo weakosane fana faserepeakosapo. Arirakano Kotimo makata su ayiakakosane haru faserepeakosafapo. ");
INSERT INTO faa_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Aporo hauaka metamo aporo hauaka metayaki werakano, kamani metamo kamani metayaki werakano, ayiakakosapo. Hauaka kekepoa momani kára peakosapo. Arirakano hauaka kekepoa makata nakosa farakano aporo hinamo kára meamohokosapo. Hinamo ipi hokosa kaiyako aheramo kára mokoweraka mati soko, himu soko, kára tenapo. Tena kepoamarera ayiáka momani kára aperamo soko, makata nakosa farakano soko, yunu aweramo soko, ayiáka aporo hinamoaki makata umisane kepomareakosapo. ");
INSERT INTO faa_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Maiya amo re huruperapaka asekeanie. Re aporo metakiramo waseremokoa hukurura aporomo reane hukururaka, arirakano Yu aporomo sarimana apea aporo metakiramo reane ira faimo rukusapo. Asiamo repo ano patera asesasamo, reane ape asekea risia aporoamo soko, aporo unihaemo soko, re hukurusimo aporo metakiramo re waseremokoako pusiehokosapo. Waseremokoa hukuarura sere amo, repo iaki anoane makáraraka somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Fahokosa maiyane faserepeasiraka anoane hemakapusimo, some kotesane hauaka sua aporo hinamo suaki nōmo kakimara aporo hinamomo some kakakosapo. ");
INSERT INTO faa_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Arirakano reane waseremokoa hukuarura maiya amo, repo somehokosane karekeakopo. Hukuarura maiya yiamo somehokosane re himura Kotimo mahemakapurakarakano, repo somehokosapo. Repo namina hemakapusuane somehokosafapo. Ho Kotesamo hemakapusuane repo somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Arirakano aporomo ipi mamaneane, aporo metamo rusua kukusimo parakehokosapo. Arirakano wafayamo ipi hokosa aporo metamo rusua kukusimo parakehokosapo. Arirakano hokosamo ipi wafaya kaīyia tetāne aporo metamo rusua kukusimo parakehokosapo. ");
INSERT INTO faa_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Asiamo re ano patera asesasamo reane aporo hinamo suamo hisihokosapo. Asiamo reane Kotimo mafasiasimo re Kotiaki patera asesane metakarirafaraka, yaiya hemakapukua risike, rakipe pukua rosaka taehoanie,” aíyaka Yasumo somesapo ");
INSERT INTO faa_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Yasumo iaki someraka, “Repo aseane Kotiane mawakasemahokosakipoko, Kotimo apea makata watikisa motorakano, repo makata ane asekea hemakapunie. Amo re Yutía hauaka risiane teketarikia ūria hinie. ");
INSERT INTO faa_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Arirakano re aporo metakira ape kopoa risiane re ape kakarua makata kemo mokoako pukupo. ");
INSERT INTO faa_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Arirakano re aporo metakira hemo tipia risiane, repo apea pasu mako pukupo. ");
INSERT INTO faa_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Maiya amo hinamo umisa soko, hokosa kiri kaīyia soko, teketarikia hiane waforohokosapo. ");
INSERT INTO faa_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Teketarikia hiakosa maiya amo yao kára aperamo teketarikia hiane kakaro waforohokosapo. Yao kára apera maiya amo, teketarirapaka kurikurihoanie. ");
INSERT INTO faa_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Teketarikia hikia arisia maiya amo, makata umisa faserepeakosane kárahokosapo. Kotimo hauaka kára one kepomaresa maiya amo soko, pipu yumo soko, makata umisa faserepeakosa ane fana asiafapo. Makata umisa faserepeakosane faraka keseke ayiáka umisa faserepeakosafapo. ");
INSERT INTO faa_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Makata umisa fasere apera maiya amo, mokoatikiraka risira satiki aporomano suane kukua kekea fahoafunupo. Kukua kekea fanapaka Kotimo murikimasa aporo hinamoane hemakapuraka mokoatikihokosa maiya sapeane rukupateraka makinakehokosapo. ");
INSERT INTO faa_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Arirakano aporo metamo reaki someraka, ‘Repo suamo wó asesie. Aporo ane ipi Unihae kárapo. E Keresopo.’ Airakano aporo metamo reaki someraka, ‘Repo suamo aka asesie. Aporoane ipi Unihae kárapo. E Keresopo,’ aíyaka ipu somerakano, someane repo kakimakopo. ");
INSERT INTO faa_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Asiamo aporo metakira, kotafe Kereso pariraka peakosapo. Arirakano aporo metakira, kotafe some kará porofete aporo pariraka peakosapo. Peraka aporo hinamo suamo iaki patera asekeasimo, ipu makata wakapuaka rakira kára meta rakiakosapo. Rakirane Kotimo wakapuane iaki kasapo, aíyaka aporo hinamo suane fofaraka iaki hemakapusimo rakiakosapo. Kotimo murikimasa aporo hinamo ipu makata ainane, kau aseako kirimaraka rakiakosapo. Ipu hemakapuraka, ‘Nōmo someane kairaka soko metao, kaiyanafonoraka soko metao, iaki murikimaka somehokosapo,’ aíyaka ipu hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Asiamo makata ane faserepeasiraka, makata ayiakakosane nōmo reaki somerakanapo. Nōmo someraka one repo kakaro kakimakanie.” aiyaka Yasumo aporo hakāsa puraki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Yasumo someraka, “Mokoatikihokosa maiya ane faraka amo patera, ‘sere maiyamo soko ere maiyamo soko faehokosafapo. ");
INSERT INTO faa_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ti makata hepene yapunaka hurupepehokosapo. Arirakano hepene yapura makata kára risiane mahohohokosapo.’ ");
INSERT INTO faa_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Maiya amo aporo hinamo ipu aseane Aporomanomo Táke anoane perakano aseakosapo. Ti pakae á wakapuyaki faesayaki ano peakosapo. Ano perakano aporo hinamo suamo aseakosapo. ");
INSERT INTO faa_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ano apera maiya amo aporo hinamo nōmo murikimasane nōmo hepene aporo yakaimo pasimokoako pusiehokosapo. Pusierakano i peraka hauaka sua, patera takua risiane soko, ketayia takua risiane soko, ketayia takua risiane soko, hikumisi neneme takua risiane soko, hauaka sua nōmo aporo hinamo murikimosane hepene aporomo pasimokoa sarimahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yasumo someraka, “Ira foke amo takume kepoane hemakapunie. Ira foke ku paruraka yoaerakano asekea repo hemakapuraka, ‘Kupa kakako makerakanapo,’ aíyaka repo hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hemakapura ayiáka repo aseane, makata umisa faserepeakosapo aisane fasereperakano aseraka, nōmo makata su ayiakakosaposane makerakanapo, aíyaka repo hemakapukusapo. Aporo ape kakarua yoroako ikia koro makeraka apera ayiáka makerakanapo, aíyaka repo hemakapunie. ");
INSERT INTO faa_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nōmo reaki kakaro somerakaripo. Aporo hinamo maiya hakása yiamo hokono murisiane, i kukusiraka hitafe arisia yiamo, nōmo ayiakakosaposane fasereperakano aseraka ipu someraka, ‘Makata ayiakakosaposane ayana ayareapo,’ aíyaka repo asekea hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Asiamo ti yapurane soko, hauaka one soko fahokosapo. Arirakano nōmo someane fahokosafapo. Nōmo someraka one kakaro ayiakakosapo,” aíyaka Yasumo ipi somesapo. ");
INSERT INTO faa_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yasumo ipi someraka, “Ano peakosa sereane soko, maiya hi awane soko, aporo hinamomo hemakapurafapo. Hepene aporomo soko, Kotimo hokosa nōmo soko, hemakapurafapo. Atamo ipi hákasamo hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Asiasamo repo asekea risikianie. Ano pari peakosa maiyane repo hemakapunafononasamo asekea risikianie. ");
INSERT INTO faa_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ano paripeakosa maiya amo ayiakakosane oyapo. Aporo kimisi pukusakipoko ipi apeane aporo raipamo asekea risikiasimo marerapo. Ipu makata rakirane soko epo marerapo. Ikia koro asekea rera aporoaki epo someraka, ‘Koteaka asekea rekeanie,’ airapo. ");
INSERT INTO faa_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ape asekea rera aporo pariperakarihoamo asekea risikianie. Ipi maiya tuakeramo soko metao, ere titipiamo soko metao, mena me horamo soko metao, mituru fiarakano soko metao, e perakarihoamo asekea risikianie. ");
INSERT INTO faa_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","E wate foaka peraka aseane, re wakakesekeno aseakohoamo re asekea risikianie. ");
INSERT INTO faa_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Aíyaka nōmo re aporo hakāsa puraki someana one aporo hinamo suaki somerakanapo. Someane oyapo. Re suane waráfaraka asekea risikianie.” Aíyaka Yasumo ipi somesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sere tetá faraka, sere metamo hokono keakosapo. Wate fana Iyipi hauaka metakarikia pusuakipoko, Ape Farimaresa Hemakapuko Hokono Keakosapo. Hokono keraka farawa pirianafonona nenapo. Maiya amo pirisiti aporo kára soko, Kotimo somemane tisa aporo soko, ipu me rukua some maraka, “Yasuane rusua kukusimo eane maiyaka mahoperaka waseremakosare? ");
INSERT INTO faa_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yumo hokono akera maiya amo Yasu waseremayane siahoasifareapo. Asiamo aporo yakai sarimasasamo isuyaki werapaka, yumo e waseremakosafapo.” Aíyaka pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, someaka masapo. ");
INSERT INTO faa_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Petene apea aporo meta yano motosa Saemone fana toropakesa reane fasapo. Asiamo Saemoneamo apea Yasu pukua, teporo makeraka sea kayakipoko, hinamo meta peraka eke kotesa petoro pariaka rakisiane maka pesapo. Petoro maka pesa á, wera namo kakaro wape yamonane kesa, mone káramo roponane kesapo. Kesane petoro tofene ropakataeraka Yasu wamoa rekemaresapo. ");
INSERT INTO faa_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Rekemarerakano aporo metakira risiamo asekea saperaka namina susu someraka, “Hinamoamo werane marirakano nenakamakayia rekemarekea farakanare? ");
INSERT INTO faa_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wera ane mone káramo roporaka, keremisi hakásapoko makata rakira ropo ane asiapo. Wera ane aporo metaki roporaka mone kára mokoa aporo makata forosaki kakafunureapo.” Aíyaka ipu hinamoaki someraka, “Nómo aporo makata forosane ararerafare? Marirakano wera ane rekemarekea farakanare?” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Airakano Yasumo someraka, “Hinamoamo ipi rakiako hemakapusuane marirakano repo makaíya marekea somerakanare? Asiamo repo aihokopo. Hinamoamo ano wamoa wera rekeamarerane kakaro kotesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Asiamo aporo makata forosane maiya suamo reyaki hakāsa risikiakosapo. Asiāne ano maiya suamo reyaki hakāsa rekeakosafapo. Maiya metamo repo hemakapukua iane makotehoane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Hinamoamo rakiane siahoasisekeno ipi rakirakanapo. Ano kau ane kunikia motoakosakipoko, hinamoamo wera wape yamona ano kauane makoteraka rekemareakosane murikimaka rekemaresapo. ");
INSERT INTO faa_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Hao, kaisie. Nōmo reaki kakaro somerakaripo. Hauaka kara wo aporomo anoane hemakapusimo some karaka, hinamoamo wera rekemaresane soko, aporo hinamomo hemakapusimo ipu somehokosapo. Aíyaka somerakano hinamoane aporo hinamo yakaimo hemakapukusapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aporo hakāsa pura hakása meta yano motosa Yutase Isekeriopo. E pirisiti aporo kára risia á Yasuane parakehokosakipoko somehoko pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Pukua somerakano ipu seseaka kaikia eaki someraka, “Isiapo neaki mone kakakosapo,” aisapo. Airakano Yutasemo someraka, “Yasu mayiáka parakehoaepi,” aíyaka hemakapukua Yasu parakehokosa ikia karane kosapo. ");
INSERT INTO faa_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Arirakano hokono keraka Farawa Pirianafonona Nená kepomaresa maiya amo, saro sipi mano rusuapo. Maiya amo aporo hakāsa puramo Yasuaki someraka, “Ape Farimaresa Hemakapuko Hokono Keraka makata nakosane isiapo ape ma sarimaraka taehokosare?” ");
INSERT INTO faa_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Airakano aporo hakāsa pura tetá pusimo Yasumo murikimaka someraka, “Teto ape sumua pusie. Pukua aseane aporo metamo he petoroa takamaka makatiraka perakano, tetápo e asekea sapenakosapo. Sapenekea e purakano, eyaki hakāsa punie. ");
INSERT INTO faa_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pukua e apea yorokoa purakano, apeane wafayaki someraka, ‘Tisamo someaka maresane oyapo. Ape Farimaresa Hemakapuko Hokono Keakosakipoko, nōmo aporo hakāsa purayaki sarimaraka, ape kakaru sape ma sarimaraka makata nakosare? Aporo kimisi pesa akipoko ape sape mayare?’ ");
INSERT INTO faa_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Airakano epo tetoane karikia, ape huturua hikia ape rumu kára tariakosapo. Ape á sea soko, teporo soko, toane tariakosapo. Tarirakano ape á makata nakosa sarimaraka taehoanie.” ");
INSERT INTO faa_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Aíyaka Yasumo someaka marerakano, aporo hakāsa pura tetane pukua apea pauraka Yasumo ayiakakosaposane, ayiáka rakirakano tetapō asesapo. Ape Farimaresa Hemakapuko Hokono Keakosakipoko tetapō makata nakosa sarimaraka taesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Sarimaraka taerakano asekea maiya tuakeramo, Yasu apea pekea, ipi aporo hakāsa pura keno suyaki hakāsa sarimaraka toapo. ");
INSERT INTO faa_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ipu makata nenaka toa maiya amo, Yasumo someraka, “Nōmo reaki kakaro somerakaripo. Repo aporo hakása metamo anoyaki hakasa toke makata anena yiamo, repo hakása metamo ano parakehokosapo,” aísapo. ");
INSERT INTO faa_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Airakano ipu mahisiraka namina hakása hakásaraka Yasuaki someraka, “Ne parakehokosane anore,” aíyaka namina yia fofaraka somerape pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Somerape purakano Yasumo someraka, “Re aporo atoa yiamo ano parakehokosapo. Nōmo farawa maka he waira á kokoamarera yiamo, aporo metamo soko, anoyaki hakāsa tukurakano aporo ayapo. Epo ano parakehokosapo. ");
INSERT INTO faa_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Aporomano Tákehokosakipoko ano hauaka wo pesapo. Ano ayiakakosane Kotimo some kará porofete aporomo, Kotimo sawia poparaka maresa, hakása nine kekemaraka ayiakakosapo. Aporomanomo Tákeane anopo. Ano parakena aporoane ipi fanasihokosane kakaro itifiakosafapo. Aporoane e ipi hokono mareanafonosa satiki ane kotehoafunureapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ipu makata nenaka atoa maiya amo, Yasumo farawa maka Kotiaki suseaka kurikurisapo. Kurikuriraka faraka farawa mosoraka aporo hakāsa puraki hakása hakásaraka karaka someraka, “Farawa one masie. One ano kaupo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Arirakano kapo he soko, maka Kotiaki suseaka kurikuriraka faraka, iaki karakano ipu suamo nesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nenakano asekea Yasumo iaki someraka, “Waene he one ano yapipo. Ano yapi pukusa amo aporo hinamo suamo himu watikisane mafahokosapo. Ano yapimo aporo hinamo suane mafasiakosakipoko Kotimo ipi kawe someaka marakanapo. ");
INSERT INTO faa_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nōmo reaki kakaro somerakaripo. Waene he one nōmo efera hunia hauaka wo reyaki hakāsa nakosafapo. Keseke Koti unihaeaka rea hauaka á nōmo waene he one reyaki hakāsa toke nakosapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Aíyaka Yasumo somerakano, ipu Kotiaki kekereraka kesasapo. Kesaraka faraka, apeane metakarikia ūri Orofea hisiapo. ");
INSERT INTO faa_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Aporo hakāsa puraki Yasumo someraka, “Repo suamo anoane metakariakosapo. Metakariakosane Kotimo sawia popasane oyapo. ‘Saro sipi wafayane nōmo rurakano saro sipi suane teketariakosapo,’ aíyaka Kotimo sawia popasane kakaro yaiya ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ayiakakosa nine, keseke ano maturikia taerakano, Kariri hauaka á ano fana pusuakipoko, re keseke pekea isina hakāsa sarimahokosapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Airakano Pitamo Yasuaki someraka, “Ipu suamo neane metakarirakano, nōmo ne kakaro metakariakosafapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Airakano Yasumo Pitaki someraka, “Nōmo kakaro somerakaripo. Pipu ereamo kokoroko yape tetá mehoasiraka nómo someraka, ‘Yasu nōmo aserafapo,’ aíyaka yape isiamo kotafe somehokosapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Airakano Pitamo paroaka someraka, “Wae, ano neyaki hakāsa rusua kuraka soko metao, nōmo ‘Yasuane aserafapo,’ aihokosafapo.” Airakano aporo hakāsa pura suamo Pitamo some hakása nine kekemaraka somesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yasu ipi aporo hakāsa purayaki Kesemane hauaka á puraka Yasumo iaki someraka, “Ano kurikuriraka area maiya amo re wo tokoanie.” ");
INSERT INTO faa_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Aíyaka Yasumo Pita soko, Yamese soko, Yone soko, karikia puraka, Yasu ipi kára himu nekea, mahisiraka sesenafaraka reapo. ");
INSERT INTO faa_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ayiáka reke Yasumo iaki someraka, “Ano himu kára nekea mahisiraka reke, ano kukusireapo. Asiamo re wo toae. Re wakakopo,” aísapo. ");
INSERT INTO faa_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Aíyaka someaka marekea Yasu ipi wakasema pukua, uakapekea hikumisimo hauaka nanireke kurikuriraka, eaki makata umisane mafahoasimo kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kurikuriraka someraka, “Atao, nómo makata su rakiane sianapo. Asiamo nómo makata umisa anoaki makasane siasekenone makata umisane nómo metakarisie, aíyaka nōmo hemakapurakaripo. Asiāne nōmo hemakapusua aeyaka ayiakakopo. Nómo hemakapusua aeyaka ayiakanie.” ");
INSERT INTO faa_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Aíyaka Yasumo kurikuriraka faraka, aporo hakāsa pura isiane toakipoko peraka aseane, i wakakesekeno asesapo. Asekea i maturikia Pitaki someraka, “Saemoneo, ne maiya hi awa hakásamo asekea reafareapo. ");
INSERT INTO faa_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Reaki aporo metamo mokopipirakano, repo watikiaka rakipe purapaka, turikia pukua reke kurikurihoanie. Wakakopo. Repo himumo koteaka hemakapukua kurikurihoko sesesa nine, kaumo yoferaka wakakosapo,” aísapo. ");
INSERT INTO faa_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Aíyaka Yasu efera hunia wakasema pukua kurikuriraka, fana kurikurisa hakása yaiya kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kurikuriraka faraka, aporo hakāsa pura toakipoko peraka aseane, i su wakakesekeno asesapo. Arirakano i waka keako hi kumikia nekenekeraka kakaro wakakesapo. Wakakesakipoko, epo iane maturikia taeraka somerakano, ipu Yasuaki some paripukusane kakaro kára mahimetesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yape isiamo Yasu pukua pariperaka iaki someraka, “Re yaiya wakakesare? Wakakesane yaiya wakakeanie. Kurikurihokosa maiyane fasapo. Aporomanomo Táke anoane parakeraka aporo watikisamo ano waseremakosa maiyane pipu maiya yuyapo. ");
INSERT INTO faa_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Re su takahisie. Takahikia isu purakapo. Aporomo ano parakehokosane apere,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yasumo somesa maiya yiamo aporo hakāsa pura meta yano motosa Yutase peraka eyaki aporo yakai hakāsa pesapo. Aporo pesane aporo metakiramo poke mokoa pekea, aporo metakiramo ira rokopa mokoa pekea, arirakano aporo metakiramo ferepe mokoa pesapo. Aporo pesane pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, Yu aporo sisimamo soko, iane pusierakano pesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Aporoane peasiraka parakena aporo Yutasemo fana someraka, “Aporo nōmo makanurakano aporo ayapo. Eane waseremaka karikia punie.” ");
INSERT INTO faa_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Aíyaka marekea Yasu rea Yutase ereketae pekea someraka, “Tisao,” aíyaka epo Yasuane makanusapo. ");
INSERT INTO faa_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Makanurakano aporo suamo Yasuane waseremasapo. ");
INSERT INTO faa_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Waseremarakano ipi aporo hakāsa pura meta makeraka reamo epo ferepe teaka maka, pirisiti aporo fanamo aporo raipa senaki ferepemo rukusakaretapisiapo. ");
INSERT INTO faa_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Rukusakaretapirakano Yasumo iaki someraka, “Repo ferepe mokoa pekea, poke mokoa pekea, ano waseremako aperane ano hakimara aporore? ");
INSERT INTO faa_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Maiya suamo Kotimo apea isina hakāsa risike nōmo some karakano repo ano waseremarakasufapo. Asiāne Kotimo sawia poparaka ayiakakosaposane fasere apera oyareapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Airakano aporo hakāsa pura suamo Yasu metakarikia teketarisiapo. ");
INSERT INTO faa_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Arirakano hokosa raua ipi pasu pakaesa osoraka, ipi Yasu fana pusuakipoko, e kesekea pusuapo. Pusuane aporo metakiramo e waseremarakano asekea ");
INSERT INTO faa_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","hokosa raua ipi pasu pakaesane metakarikia patera yase takaripusuapo. ");
INSERT INTO faa_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Aporomo Yasu karikia pukua pirisiti aporo káramo apea, karikia pukua aseane, apea pirisiti aporo fanane soko, Yu aporo sisima soko, Kotimo somemane tisa aporo soko, sarimaraka tokeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Yasu karikia purakano, Pitamo wakasema yamenoa kekemarape pusuapo. Kekemarape puraka pirisiti aporo fanamo ape hauaka moroa pauraka, aporo terakaiyamosa toakipoko Pita soko kayapo. Ira paisiakipoko Pita ira haka kayapo. ");
INSERT INTO faa_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kayakipoko pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, Yu aporo sisimamo soko, ipu aporo metakiraki peaesapo. Aporoamo Yasuaki hukurukua topakamaraka somehoko peaesapo. Ipu hemakapuraka, “Aporo metakiramo Yasu hukururakano Yasu fanasiraka rusua kukusapo,” Aíyaka aporomo topakamaraka somehoko ipu kosapo. Asiāne ipu hukurukusane siahoasifareapo, aisapo. ");
INSERT INTO faa_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Aporo yakaimo topakamaraka somesa nine ipu some hakása somesa ayafapo. Aporo metakiramo some meta topakamaraka some, arirakano aporo metakiramo soko, some meta topakamaraka some ayiáka some kekepo somepe pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Somepe purakano aporo metakira takahikia kotafe hukurukua someraka, ");
INSERT INTO faa_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Isiapo kaisiane oyapo. Epo someraka, ‘Kotimo apeane aporomo hokonomo kisiane nōmo rakaritaeraka, sere isia faraka Kotimo ape metane nōmo kiakosapo. Ape kiakosane aporomo hokonomo kinafonoraka, nōmo hemakapukua kiakosapo,’ aíyaka somerakasuane isiapo kaisiapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Aíyaka somesa nine, ipu somesa hakása somesa ayafapo. Some kekepo kekepoaka somesapo. ");
INSERT INTO faa_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Someraka risina pirisiti aporo fana takahikia Yasuaki someraka, “Neaki makata hukuruarurane nómo yakapa some paripukusare?” ");
INSERT INTO faa_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Airakano Yasumo ipi makata somesafapo. Somehoanafonoraka rekeno pirisiti aporo fanamo someraka, “Unihae máfaraka maresa Keresoane nére? Kotimo hokosane nere?” ");
INSERT INTO faa_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Airakano Yasumo someraka, “Nómo airaka ane anopo. Nómo aseane Aporomanomo Táke anoane Koti ipi wakapumo hokono tumuru takua ano kakeno repo aseakosapo. Hepene aeyaka ako faesayaki ano perakano repo aseakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Airakano pirisiti aporo fanamo kaikia saperaka ipi pasu ososane makoaraka someraka, “E hukuruko aporo meta peaehokosafapo. ");
INSERT INTO faa_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Epo ipi yiamo someraka Kotiane soko, eane soko, tati hakása yiyareapo, airakae. Airakane repo hemakapusuane yakapare? Isiapo Yasuane mayiakakosare?” airakano ipu someraka, “E Koti tati siasapo airakano e rusua kukunie.” ");
INSERT INTO faa_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Airakano aporo metakiramo Yasuane torofaeraka, arirakano aporo metakiramo Yasu hia pasumo taporaka e ruraka someraka, “Ne arurane epamo rurakarire? E yano hosie.” Airakano pirisiti aporo káramo aporo terakaiyamosamo ipu hokonomo e ruraka risiapo. ");
INSERT INTO faa_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yasu hukurusua maiya amo, hauaka moroa Pita kakeno pirisiti aporo fanamo hinamo raipa hakása meta peraka aseane, ");
INSERT INTO faa_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pita ira paisia á ira haraka kakeno asekea, hinamoamo someraka, “Nasare aporo Yasuyaki hakāsa purane nereapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Airakano Pitamo waeraka someraka, “Nómo somerakane ano himeteripo. Ano eyaki hakāsa purafapo.” Aíyaka Pita takahikia pukua ikia koroa pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pukua rekeno kokorokomo mesapo. Hinamo raipamo e aseraka, efera hunia aporo suamo kaiyisimo someraka, “Aporoane Yasuyaki hakāsa pusuapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Airakano efera hunia Pitamo waesapo. Waeraka wakasema kaina, aporo makéraka risiamo Pitaki someraka, “Nómo mehoane Kariri aporomo meane somerakae. Asiamo né Kariri aporopo. Ne Yasuyaki hakāsa purareapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Airakano Pitamo ekeneaka aumaraka someraka, “Yasuane nōmo aserafapo. Nōmo kotafe somerakano soko Kotimo ipi ano fanasihokosapo.” ");
INSERT INTO faa_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Aihoanine yape tetámo mena kokorokomo mesapo. Merakano kaikia Yasumo some kasane Pitamo ipi hemakapusuapo. Arirakano fana Yasumo someraka, “Mena kokoroko yape tetá mehoasiraka, nómo yape isiamo ‘Yasuane nōmo aserafapo,’ aihokosapo,” aisane Pitamo kára hemakapukua himu nekea hiripusapo. ");
INSERT INTO faa_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mituru fiarakano pirisiti aporo kára soko, Yu aporo sisima soko, Kotimo somemane tisa aporo soko, i su Kanisoro aporoane sarimaraka Yasu rusua kukusane me rukua somesapo. Someaka faraka Yasu sakomo taporaka marekea, Rome aporo ipi yano motosa Pairate rea Yasu karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pairatemo Yasuaki someraka, “Yu aporomo unihaeane nere?” Airakano Yasumo someraka, “Ao, nómo someraka ayapo.” ");
INSERT INTO faa_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Airakano pirisiti aporo káramo Yasuane hokorēraka kotafe topakamaraka somesapo. ");
INSERT INTO faa_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Asiamo efera hunia Pairatemo Yasuaki someraka, “Ipu makata kára hukuarurane nómo kairakarire? Nómo some paripeakosare?” ");
INSERT INTO faa_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Airakano Yasumo makata somesafapo. Somehoanafonoraka me kaurakano asekea Pairatemo hemakapuraka, “Manakano me kaunaka rekenarakapo,” aíyaka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","8","Fana aporo metakiramo Rome kamaniyaki wesa maiya amo aporo metakirane rusua kusuapo. Aporo hakása ipi yano motosa Parápasepo. Parápasemo aporo meta rusua kusuapo. Rusua kurakano asekea e tipura makesapo. Tipura reakipoko aporo yakaimo Pairateaki someraka, “Ape Farimaresa Hemakapuko Hokono Akera maiya amo tipura makesa aporo hakása meta isiapo hemakapusua aeyaka tonotaerasie, airakano nómo tonotaenapo. Keremisi suamo anapo. Pipu ayiakakosakipoko aporo hakása tonotaehoanie,” aísapo. ");
INSERT INTO faa_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Airakano Pairatemo hemakapuraka, “Pirisiti aporo káramo Yasuaki kakanakeraka hemakapusuasamo, e hukurusimo karikia pekea a risie.” Aíyaka Pairatemo hemakapuraka epo iaki someraka, “Yu aporo unihaeane tonotaehokosare?” ");
INSERT INTO faa_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Airakano pirisiti aporo káramo aporo su sarimasaki hokokekea someraka, “Parápase tonotaerasie, aísie.” Airakano ipu suamo wáraka, “Parápase tonotaerasie,” aíyaka ipu sakepamo wásapo. ");
INSERT INTO faa_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Airakano Pairatemo iaki someraka, “Repo Yu aporomo unihaeane mayiakaere?” ");
INSERT INTO faa_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Airakano ipu sakepamo wáraka, “E ira matopesa paremarekea rusua kukunie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Airakano Pairatemo someraka, “Marirakano e rusua kukunierakanare? Epo watikiaka makata yakapa rakisiare?” Airakano ipu efera hunia sakepamo wáraka, “E ira matopesa paremarekea rusua kukunie.” ");
INSERT INTO faa_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Airakano aporo yakai ane masesehoasimo, Pairatemo ipu someane kekemaraka Parápase tonotaeraka, Yasuane matia sakomo rusie, aisapo. Rurakano asekea someraka, “Yasu ira matopesa paremareako karikia pusie,” aísapo. ");
INSERT INTO faa_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ame aporo peraka Yasuane kamanimo ape kára á karikia pusuapo. Karikia pukua ape kára á pauraka, ame aporo su sarimahoko peaesapo. ");
INSERT INTO faa_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Perakano asekea, ipu Yasuane pasu susa osoraka marekea, mainamareraka, sako keta risia hati pariraka rakiakosakipoko, kita apera ayiáka pekea weroraka rakisiapo. Rakisiane Yasu wamoa karotapisiapo. ");
INSERT INTO faa_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ayiáka eane mahokopariraka unihaepo, aíyaka hemakapukua eaki suruturaka someraka, “Yu aporomo unihaeo. Ne aporo kárapo.” ");
INSERT INTO faa_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Aíyaka Yasu wamoa kepayiamo rukua, Yasu kaua torofaeraka, eane maunihaeraka sikiraka, pekea kakuna porokoa kake, ipu Yasuaki kotafe kekeresapo. ");
INSERT INTO faa_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ayiáka mainamarekea faraka, pasu susa kau rakisiane horomaka, epo ipi pasuane osoraka marekea ira matopesa paremareako karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Yasu ira matopesa paremareako karikia puraka aseane, ikia kara á aporo hakása meta ipi yano motosa Saemone, Sairíni taone aeyaka Yarusarame sitia perakano asesapo. Arirakano Saemonemo hokosa tetá, meta Arekesáta, meta Rúfase, aíyaka yano motosapo. Asiamo ame aporomo Saemoneaki someraka, ira matopesane maka pusiesapo. ");
INSERT INTO faa_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Aíyaka ipu Yasu karikia pukua Kokóta hauaka á pausapo. Arirakano Kokóta hauakane namo meaka Uni Kiki hauakapo. ");
INSERT INTO faa_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Kokóta hauaka á pauraka risike Yasu kau kára tenapaka waene he munamuna asíayaki sarimaraka kekero kekeroraka Yasumo nasimo kasapo. Karakano Yasumo nesafapo. ");
INSERT INTO faa_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Arirakano ame aporomo Yasuane ira paremaresapo. Paremarekea maporaka marekea, Yasumo pasuane parakuraka mokoakosakipoko ipu kase enana ayiáka enasapo. ");
INSERT INTO faa_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mituru maiya hi naene korokomo ipu Yasuane ira matopesa paremaresapo. ");
INSERT INTO faa_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Paremarekea Yasu uni kima yapura e ipi hukurusuane ira tumusakipoko poparaka úyaka popasapo. “Yu aporomo Unihaeane epo.” Aíyaka poparaka paremaresapo. ");
INSERT INTO faa_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Arirakano hakimora aporo tetá Yasuyaki hakāsa ira tetá meta paremurisiapo. Paremuriraka meta Yasu hokono tumuru takua paremarekea maporaka, meta Yasu hokono kasakai takua paremarekea maporaka asiapo. ");
INSERT INTO faa_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Wate fana Yasu peasiraka Kotimo sawia popasane oyapo. “Makata watikiaka rakira aporo akiyaki eane hakása ninesapo.” Aíyaka Kotimo sawia popahoareapo. Popasa hakása nine faserepesa ayareapo.  ");
INSERT INTO faa_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Arirakano Yasu ira paremaresa makeraka aporo metakira pukua, eaki mainamareraka siráraka unia rokoraka someraka, “Sirá, nómo fana someraka, ‘Kotimo ape rakaritaeraka, yape isia faraka efera hunia kikimakosapo,’ airakasupo. ");
INSERT INTO faa_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Aisasamo ní yia ararerasie. Ira matopesa paremaresane metakarikia o peae,” aísapo. ");
INSERT INTO faa_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Aíyaka pirisiti aporomo soko, Kotimo somemane tisa aporomo soko, ipu namina susu Yasuaki ayiáka mainamaresapo. Mainamareraka someraka, “Yasumo aporo metakirane araresapo. Araresa ayiáka e ipi nine ayiáka ararehoasifareapo. ");
INSERT INTO faa_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","E ipi kakaro Keresomo rakirane rakira satiki, ane Isiraya aporo amo unihae ane e ipi satiki, e ira matopesa paremaresane metakarikia peafunureapo. Perakano aseraka epo ipi somesane kakaro somehoareapo aihoafunupo.” Aíyaka ipu Yasu mainamareraka risiapo. Arirakano Yasuyaki hakāsa paremaresa aporoamo soko Yasuane mainamareraka somesapo. ");
INSERT INTO faa_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Hauaka sua sere tuaro (12) korokomo kepomarekea eresapo. Ereraka reke maiya hi awa isia amo ereraka reapo. ");
INSERT INTO faa_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nina samapu maiya hi isia fahoko makeanamo Yasumo Yu aporo meaka sakepamo wáraka, “Irae, irae, rama sapakatani.” Aíyaka namo meaka someraka, “Nōmo Kotio. Nōmo Kotio. Nómo ano marirakano metakarirakanare?” aísapo. ");
INSERT INTO faa_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Airakano kaikia aporo metakira makeraka risiamo someraka, “Kaisie. Ipi Iraíyaki warakae.” ");
INSERT INTO faa_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Airakano aporo hakása meta foaka pukua he watera asía he kisa á kokomarekea fofako turua tapomarekea, Yasumo nasimo makama yapurasapo. Makama yapuraraka epo someraka, “Harufapo. Porofete aporo Iraíyamo Yasuane fataritaehoko perakarihoamo, isu yu kau risikipo.” ");
INSERT INTO faa_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Airakano aseane Yasumo sakepamo wása yiamo Yasu ipi himu kikiraka kakaro himu rumaka kusekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Arirakano Kotimo apea pasu waremaresane yapunaka koarape atura pusuapo. Koaraka taku haku, taku hakusapo. ");
INSERT INTO faa_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Arirakano ame aporo satini ipi Yasu hikumisi erekea reke aseane Yasu kurakano asekea someraka, “Nōmo kakaro somerakaripo. Aporoane kakaro Kotimo ipi hokosapo,” aíyaka epo somesapo. ");
INSERT INTO faa_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Arirakano hauaka wakasema tame yia hinamo metakira soko asekea toapo. Asekea toa hinamo ane meta Makatara hinamo Mariapo. Arirakano meta Maria, Yamesepe Yosefe tetapō kaīyiapo. Arirakano meta hinamo Sarómepo. ");
INSERT INTO faa_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Arirakano fana Yasu Kariri hauaka pusua maiya ámo, hinamo isiane eyaki hakāsa pukua, eane makata nakosa paikia kasapo. Arirakano Yasu Yarusarame sitia pesa maiya amo, eyaki hakāsa pesa hinamo metakiramo soko, hemakapukua asekea toapo. ");
INSERT INTO faa_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Arimatía aporo Yosefeane ipi Ferese aporoyaki Kotimo somemane tisa aporo akiyaki hakāsa sarimaraka makata rakisiapo. Makata rakiraka ipi yano motosane kárasapo. Arirakano Kotimo unihaeaka asekea rekeakosa maiya ane faserepeasimo Yosefe kau reapo. Epo hemakapuraka, “Pipu samapu maiya tuakeramo rau fenena maiyane kepomareakosapo. Kepomareakosasamo fenakosakipoko yumo makata su mokoa sarimarakanapo.” Aíyaka hemakapukua ipi karekekea namonafaraka Pairate rea pukua someraka, “Yasu kusuane kunikia motoako nōmo maka puaere?” ");
INSERT INTO faa_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Airakano Pairatemo ipi himumo hemakapuraka, “Yasu kakaro kusuare?” Aíyaka epo ame aporo satiniaki peaesapo. Perakano asekea Pairatemo eaki someraka, “Yasu kakaro kusuare?” ");
INSERT INTO faa_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Airakano satinimo someraka, “Ao, kakaro kusuapo.” Airakano kaikia Pairatemo Yosefeaki someraka, “Yasu kusuane nómo maka puane siahoasireapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Airakano Yosefe pukua pasu pakae kotesa roporaka maka, Yasu ira paremaresane fatarimaka, maka pukua, pasu pakae kotesa roposa amo Yasu taporaka maka pukua, eke kunikia fana rasa á Yasu motosapo. Motokoa marekea, kunikia kakaru mapiriakosakipoko, eke kára tafeasa keperemarape pukua, kunikia kakarua mapirisiapo. ");
INSERT INTO faa_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mapirirakano Makatara hinamo Maria soko, Yosefemo kaīyia Maria soko, tetapō Yasuane kunikia motorakano asesapo. ");
INSERT INTO faa_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Fenena maiya farakano Makatara hinamo Maria soko, Yamesemo kaīyia Mariane soko, Saróme soko, ipu Yasu kaua wera wape yamona rekemareako werane roposapo. ");
INSERT INTO faa_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Fenena maiyane faraka, sokō kawe kepoamarera maiya amo mituru fiaraka, maiya kawe ropaka aheramo hinamo isiane Yasu kunikia motosa á aseako pusuapo. ");
INSERT INTO faa_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Puraka risike, hinamo isia amo namina susu someraka, “Eke kunikia mapirisiane epamo isupoko kepere mafearaka ropakataehoanare?” ");
INSERT INTO faa_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Aíyaka hemakapupe pukua aseane, eke tafea kára ane kepere mafeasa yao takua hererekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Asekea hinamo isia ane kunikia kakarua yorokoa aseane, hepene aporo raua pasu pakaesa osoraka, hokono tumuru takua kakeno asekea hinamo isia ane fofasapo. ");
INSERT INTO faa_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Fofarakano epo iaki someraka, “Fofahokopo. Nasare aporo Yasu ira matopesa paremarekea rusua kusuane, repo aseako apere. E maturikia taerakano turikia pusuapo. E wo warekenafapo. E kau motosa fasane aseako peae. ");
INSERT INTO faa_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Asiamo ipi aporo hakāsa puraki soko, Pitaki soko repo somehoko pusie. Yasu fana Kariri hauaka á pukua reakipoko re kesekea peraka, Kariri hauaka á repo e aseakosapo. E kukusiraka epo fana some kasa hakása nine ayiakakosapo.” ");
INSERT INTO faa_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Aíyaka hepene aporo rauamo somerakano, hinamo isia amo kunikia ane metakarikia, foforaka puraka, hamisisiraka himu faraka pusuapo. Puraka risike namoraka aporo hinamo metakiraki makata meta somesafapo. ");
INSERT INTO faa_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yatipinu sere amo Yasu turikia pukua aporo hinamo metakiramo e asekeasimo e pesapo. Makatara hinamo Maria fana yatafu yatipinusumo e ho masa, Yasumo yatafu pusierakano, yatafu pusuapo. Hinamo Maria amo e asekeasimo e rea Yasu faserepesapo. ");
INSERT INTO faa_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Fasereperakano hinamoamo e asesapo. Asekea pukua Yasumo aporo hakāsa pura i risiakipoko hinamoane pausapo. Pauraka ipi aseane ipu Yasupoko himu nekea kára hihiripurakano asesapo. Asekea, hinamoamo iaki someraka, “Yasu turikia pusikeno nōmo aserakayiapo.” ");
INSERT INTO faa_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Airakano ipu kaikia yia kakarorakae, aíyaka hemakapusuafapo. ");
INSERT INTO faa_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Arirakano aporo tetá Yarusarame siti metakarikia yaoa purakano, tetapō e asekeasimo Yasu ipi kau hakusa pesapo. Perakano tetapō e asesapo. ");
INSERT INTO faa_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Asekea, tetā Yarusarame sitia poparipuraka aporo hakāsa puraki Yasu asesane tetapō somesapo. Somerakano ipu kakimasafapo. ");
INSERT INTO faa_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Keseke aporo hakāsa pura kinusu teporoa tokeno, asekea ipu e asekeasimo Yasu i toa pesapo. Asiamo aporo hinamo metakiramo Yasu maturikia taesane asesapo aisane, ipu kakimakanafonosasamo Yasumo iaki someraka, “Re masiare? Repo kakimako hisinane manakanonare?” aisapo. ");
INSERT INTO faa_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aíyaka Yasumo efera hunia iaki someraka, “Hauaka sua re pukua, aporo hinamo suaki ano hemakapusimo, some kotesane some kakanie. ");
INSERT INTO faa_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Some karakano aporo hinamo metakiramo kakimaka, i hea tapukumurirakano, i Kotiyaki yaiya risikiasimo, Kotimo i mafasikia pasimakosapo. Arirakano aporo hinamomo kakimakanafonorakano Kotimo iane fanasihokosapo. ");
INSERT INTO faa_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Arirakano kakimara aporo hinamoaki Kotimo wakapu kakakosane oyapo. Anoaki himu hakásaraka hemakapukua, nōmo yano motosane wakapusasamo, ano yano hokoa yatafu pusierakano pukusapo. Arirakano Kotimo wakapuyaki me meta, repo fana kaiyanafonona meane somehokosapo. ");
INSERT INTO faa_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Arirakano Kotimo wakapu meta kakakosane oyapo. Heseke ane hokonomo meraruamo masa nine, hesekemo nesa kukusafapo. Arirakano Kotimo wakapu meta kakakosane oyapo. Aporomo he hawai nenakano makata takamakosafapo. Arirakano Kotimo wakapu meta kakakosane oyapo. Kakimara aporo hinamomo hokonomo aporo hinamo makata tasane sakairakano, i makata tasane fahokosapo.” Aíyaka Kotimo wakapu kakakosaposane Yasumo iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Unihae Yasumo iaki makata someaka farakano, e hepene yapunaka Kotimo pasimasapo. Pasimasasamo e Kotimo hokono tumuru takua rekenapo. ");
INSERT INTO faa_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Arirakano aporo hakāsa purane pukua, Yasumo someane hauaka sua aporo hinamo suaki some kasapo. Ipu some karakano Unihae Yasumo iane araresapo. Ipu Kotimo wakapumo hemakapukua rakisimo, Unihae Yasumo iane arareraka wakapuane iaki kasapo. Asiamo ipu wakapuaka rakirakano, aporo hinamo suamo asekea hemakapuraka, “Kotimo iaki wakapu kasasamo Kotimo someane ipu some akarane, kakaro somereapo,” aíyaka hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiaforaseo, né aporo kárapo. Nōmo neane hemakapuraka, sawi one poparaka makerakanapo. Isu arisia wo Kotimo makata ayiakakosaposane faserepesapo. Makata faserepesane aporo metakiramo asekea sawia popasapo. ");
INSERT INTO faa_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Makata faserepesane kepomaresa maiya amo aporo metakiramo asesapo. Makata asesane ipu kakama somesapo. Asiamo aporoamo Kotimo someane some kasapo. Ipu some kasane isuaki soko some kasapo. Somerakano isiapo kaisiapo. Arirakano some hakása nine aporo metakiramo soko sawia popasapo. ");
INSERT INTO faa_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Asiamo, Tiaforase, nómo koteaka hemakapusimo some kepoane nōmo koteaka kokoa, makata faserepesane kepomaresa aeyaka, kekemarape pekea, pipu wo pauraka, nōmo kokoa asekea neaki ereketaeraka poparakanapo. ");
INSERT INTO faa_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Asiamo aporo metakiramo neaki some karakano someane nómo kaisiapo. Someane nómo kaikia kakarorakae, aíyaka hemakapusimo, nōmo néaki sawi one poparaka makerakanapo. ");
INSERT INTO faa_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yutía hauaka Herote unihaeaka rea maiya amo, pirisiti aporo hakasa meta reane, ipi yano motosa Sekaráyapo. Arirakano pirisiti aporo suane parakuraka, aporo ira meta yano motoraka Apaísa aíyaka yano motosapo. Aíyaka pirisiti aporo ira yano motosa Apaísa á Sekaráya ipi soko hakāsa paoraka reke, pirisiti aporomo rakirane rakiraka reapo. Arirakano epo hinamo arumasane Eronemo aporo ira hinamoane arumasapo. Epo hinamoane yano motosa Irísapetepo. ");
INSERT INTO faa_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Arirakano Kotimo hikumisia Sekaráyape Irísapete tetā koteaka ereketae risiapo. Koteaka ereketaeraka risike, Unihae Kotimo somemaneane tetapō kakaro kekemasapo. Somemane hakása meta soko tetapō metakarisiafapo. ");
INSERT INTO faa_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Metakarianafonoraka risike yia, Irísapete manokonomoraka, epo hokosa hokono maresafapo. Hokosa hokono mareanafonoraka risike teta tati sisimasapo. ");
INSERT INTO faa_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Arirakano maiya hakása metamo, Apaisa aporo ira anaka pirisiti aporomo makata rakira maiya amo, Sekaráya ane murikimaka Kotimo asekeasimo kakama rakisiapo. ");
INSERT INTO faa_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ayiáka rakiraka pirisiti aporo hakása metamo makata wape yamonane paiyakosakipoko, pirisiti aporo su yano taesane poparaka taeraka hakása meta masapo. Maka aseane, Sekaráya ipi yano motosane popasekeno asekea e murikimasapo. Murikimarakano Sekaráyane Kotimo ape kakarua yorokoa hikia makata wape yamonane paisiapo. ");
INSERT INTO faa_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Pairaka rea maiya amo, Yu aporo hinamo yakai hauaka moroa risike kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ipu kurikuriraka risikino Sekaráyamo makata wape yamona teporo asia maresa kima yapura makata pairaka reke aseane, hokono tumuru taku aeyaka, Unihae Kotimo hepene aporo pekea rekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Asekea himu faraka namosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Namorakano hepene aporomo someraka, “Sekaráyao, né namohokopo. Nómo kurikurisane Kotimo kaisiapo. Kaisiasamo nómo hinamomo aporo hokosa hokono mareakosapo. Nómo aporo hokosa hokono marerakano, Yone yano motoanie. ");
INSERT INTO faa_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Hokosa aki nómo kára sesehokosapo. Ipi taka apera maiya amo aporo hinamo metakiramo soko e asekea kara sesehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ayiáka repo asekea seserakano, Unihae Kotimo soko hokosa ane ipi yano motosa makárahokosapo. Arirakano nómo hokosamo waene he soko, he watikisane soko neane siahoasifareapo. Ipi kaīyiamo tua kaya maiya amo, Ho Kotesane e himua marerakano, Ho Kotesa eyaki yaiya káraraka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Arirakano Isiraya aporo hinamomo Unihae Koti metakarisiane efera hunia risikiako parihoasimo epo iane ararehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Unihae peasiraka e fana peakosapo. Pekea Ho Kotesamo wakapuamo Iraíyane araresa ayiáka, Ho Kotesamo wakapuamo eane soko ararehokosapo. Ararerakano hokosa wafayamo ipi hokosaki hisiraka rekeno, tetápo koteaka hemakapusimo, epo maropohokosapo. Arirakano ereketae aina aporo koteaka ereketaeraka hemaka apura ayiáka Kotimo someane koaretaena aporomo ayiáka hemakapusimo, epo maropohokosapo. Arirakano Unihae keseke peasimo, aporo hinamomo makata watikisane, epo fana maropohokosapo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aíyaka hepene aporomo somerakano Sekaráyamo hepene aporoaki someraka, “Nómo somerakane kakarore? Nōmo mayiáka hemakapukusare? Ano soko nōmo hinamo soko eto tetákara sisimapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Airakano hepene aporomo someraka, “Ano yano motosa Keiporopo. Ano Kotimo makata rakira hepene aporopo. Ano Koti makeraka reasasamo neaki some kotesa somehoko epo ano pusierakano ano perakayiapo. ");
INSERT INTO faa_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Hao, nómo kaisie. Pipu nōmo neaki some akara one keseke murikimasa sere hakasa yiamo ayiakakosapo. Pipu nōmo some akara one nómo kakimakanafonosakipoko né mé faraka rekeakosapo. Ne mé faraka reke, nōmo nī someraka, makata aiyakakosapo, aisa maiya ane fasere aperamo, nómo efera hunia somehokosapo.” Aíyaka hepene aporomo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Somesa maiya amo aporo hinamo hauaka moroa risike, Sekaráya peasimo asekea risiane, e peanafonorakano ipu hemakapuraka, “Marirakano Sekaráyane maiya káramo Kotimo apea rekenarakapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Aíyaka ipu hemakapurakano, Sekaráya ape kakaru anaka yaoa pariperaka, ipi me fasasamo iaki makata somesafapo. Makata somehoanafonorakano ipu hemakapuraka, “Kotimo apea kituamo asera ayiáka asereapo.” Aíyaka hemakapurakano asekea, e me fasamo hokono susumo rakisiapo. ");
INSERT INTO faa_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Arirakano Kotimo apea ipi makata rakirane rakikia faraka ipi apea paripusuapo. ");
INSERT INTO faa_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Pukua, ipi apea wakasema nina, Irísapete umisapo. Umiraka kake ere maiya kakoreasumo ipi apea kayapo. ");
INSERT INTO faa_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Apea kake ipi someraka, “Kotimo ano araresapo. Arirakano aporo hinamo metakiramo anoaki someraka, ‘E manokonomosapo.’ Ipu anoaki airakano ano kakaro kara kaiyaraka kayane Kotimo ano arareraka mafasapo.” Aíyaka Irísapetemo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Irísapete umiraka kake ere maiya nama amo hepene aporo meta yano motosa Keiporoaki Kotimo someraka, “Né Kariri hauaka Nasare apea pusie. ");
INSERT INTO faa_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pukua, ape á Unihae Tefetemo aporo ira wainepe pesa a Yosefe faserepekea rekenapo. Yosefemo hinamo faisa Mariaki somehoko pusie.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Airakano Maria akaya á hepene aporo pekea someraka, “Maria, neyaki Kotimo tau auaraka rerane kakenapo. Kotimo neane kára arareraka makotesasamo seseaka kakanie. Kotiane neyaki hakāsa rekenapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Airakano Mariamo kaikia fofaraka hemakapuraka, “Airakane kepoane yakaparakapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Aíyaka hemakapurakano, hepene aporomo someraka, “Maria, né namohokopo. Kotimo neane arareraka makoterakanapo. ");
INSERT INTO faa_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Né arareraka makoteraka ne hokosa umihokosapo. Umiraka kaina aporo hokosa takapeakosapo. Hokosa takapeakosaposane, takaperakano e Yasu yano motoanie. ");
INSERT INTO faa_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ipi yano motosane namo kakaro káraraka rekeakosapo. Yasuane Namo Kakaro Koti Unihae Káramo hokosapo, aporo hinamo suamo aihokosapo. Aíyaka Yasumo ipi makasa kaua kekema Tefete unihaeaka rea ayiáka, e soko unihaeaka rekeasimo Unihae Kotimo e mareakosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ayiáka marerakano Yakopemo aporo ira wainepe pesa á, e takapekea unihaeaka yaiya rekeakosapo. Unihaeaka reane fahokosafapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Airakano hepene aporoaki Mariamo someraka, “Ano aporoyaki punafonoraka kake yia, mayiáka ano umihokosare?” ");
INSERT INTO faa_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Airakano hepene aporomo eaki someraka, “Ho Kotesa né akaya á peakosapo. Peraka, Namo Kakaro Koti Káramo wakapuamo ne karotapikia rekeakosapo. Karotapirakano nómo aporo hokosa takapeakosapo. Takapekea e Kotiyaki paoraka kotesa taku a susu kikisiaka rekeakosapo. Ayiáka rekeno Kotimo someraka, ‘Né, nōmo nī hokosapo,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Arirakano makata one soko nómo hemakapunie. Nómo ní aeya, Irísapeteane kakaro sisimaraka kayane, aporo hokosa takapeako umirakanapo. Fana manokonomoraka kayane, pipu yumo ere maiya namasumo umiraka kakenapo. ");
INSERT INTO faa_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Asiamo Kotimo ipi makata su siaraka rakirapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Airakano Mariamo someraka, “Ano Kotimo makata rakira hinamopo. Nómo anoaki ayiakakosaporakane kakaro ayiakanie.” Airakano hepene aporomo e metakarikia hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Maiya amo Maria takahikia Yutía hauaka á, ape ūria kisiakipoko á foaka hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ayiáka hikia Sekaráyamo apea pauraka, ape tua yorokoa, Irísapeteaki someraka, “Ano né aseako perakayiapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Airakano Irísapetemo kaikia, e hokosa umisa kake, himura mahohorakarakano kaisiapo. Arirakano Ho Kotesa Irísapete tua káraraka rekeno, ");
INSERT INTO faa_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Irísapetemo sakepamo wáraka someraka, “Hinamo suane Kotimo aseraka yia, néane namo kakaro kára arareraka makoterakanapo. Nómo hokosa takapeakosane aporo hinamo suamo eane makararaka kekerehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ano hinamo wakasemapo. Ano sesehoasimo nōmo apea, nōmo Unihaemo ama ane pekea a akaye. ");
INSERT INTO faa_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nómo someraka, ‘Ano né aseako perakayiapo.’ Airakano kaikia, nōmo hokosa tura kake seseraka mahohorakae. ");
INSERT INTO faa_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Arirakano Kotimo makata ayiakakosaposane nómo kakimaka kakarorakae aisapo. Nómo aisasamo ne kara seseraka kakanie.” Aíyaka Irísapetemo Mariaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariamo someraka, “Nōmo himumo hemakapuraka, ‘Unihae ipi kárapo,’ aíyaka hemakapukua kakenapo. ");
INSERT INTO faa_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kotimo ano mafasisiakipoko, nōmo homo kára seserakanapo. ");
INSERT INTO faa_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Epo makata rakira hinamo wakasema anoane, epo hemakapusuasamo, nōmo himumo hemakapuraka, ‘Unihae ipi kárapo,’ aíyaka nōmo eaki seserakanapo. Unihae Koti Káramo anopoko makata kára rakisiapo. Kara rakisiasamo aporo hinamo pipu arisia omo soko, keseke aporo hinamo wainepe pukusamo soko, ipu suamo anoane someraka, ‘Hinamoane Kotimo makotesapo,’ aihokosapo. Unihae Koti Kárane ipi yano motosa haku kikisiraka kotesa susupo. ");
INSERT INTO faa_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Maiya yumo soko, keseke soko, aporo hinamomo Kotiane makárarakano epo iane kamenakaraka kara ararenapo. ");
INSERT INTO faa_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kotimo ipi wakapuaka makata rakirapo. Arirakano rupiaka makapororaka koaretaena aporoane teketarikia pusimo Kotimo wakapumo hoaenapo. ");
INSERT INTO faa_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Aporo unihaeaka risiane Kotimo mawakasemanapo. Aporo hokopunafonoraka risiane Kotimo makáranapo. ");
INSERT INTO faa_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aporo hinamo makata forokoa risiaki, epo makata kotesa susuane siaraka karápo. Aporo hinamo makata kemo káraraka risiaki, makata kakanafonoraka nena hokono mitiki pusierapo. ");
INSERT INTO faa_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Arirakano Eparahameane soko epo hokosamo hokosa wainepe pusua suane soko Kotimo kamenakasapo. Kamenakasane Kotimo hemakapuraka isiapo makasa kaua kekemaki ayiakakosapo, aisasamo Isiraya aporo hinamo suane epo araresapo. Arirakano Isiraya aporo hinamomo epoko raiparaka rakirapo.” Aíyaka Mariamo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Aíyaka someaka faraka, Mariane Irísapetemo apea kake, ere maiya isia farakano, ipi apea paripusuapo. ");
INSERT INTO faa_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Arirakano keseke Irísapeteane ipi hokosa takapeakosakipoko hokosa kaiyako heraka kayapo. Kaina ipi aporo hokosa takapesapo. ");
INSERT INTO faa_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Hokosa takaperakano asekea, Irísapete ipi kara seseraka kayapo. Arirakano eane Kotimo kára kamenakaraka araresasamo, Irísapetemo ipi aporo iramo soko, ipi apiamo aporo iramo soko, ipi hinamo ape hakása toamo soko, namina suamo kara sesesapo. ");
INSERT INTO faa_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Hokosa takapesa sereane menorape hikia yape karimo, hokosane kau hahaeraka paterakano, aporo sarimasamo someraka, “Ipi wafayamo yano motosa Sekaráyane yano motoakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Aiyaka yano motoakosapoko asiane ipi kaīyiamo someraka, “Wae, Yone yano motorakanapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Airakano aporoamo someraka, “Nómo ní aporo ira, Yone yakosa meta reafapo. Ipi wafayamo aporo irane soko, Yone yakosa meta reafapo.” ");
INSERT INTO faa_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Aíyaka ipi wafayaki hokono susumo rakikia kairaka, “Nómo ní hokosane, epa yano motoakosare?” Aíyaka aseane, Sekaráya ipi senaki tiraka, mé soko fasasamo, hokono susuamo tarisiapo. ");
INSERT INTO faa_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tariraka, “Penesoroyaki pepayaki makasie.” Aíyaka tarirakano asekea, penesoro pepayaki eaki kasapo. Kaka aseane, epo poparaka, “Epo yano motosane Yonepo.” Aíyaka poparakano aporo suamo asekea fofasapo. ");
INSERT INTO faa_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Maiya yiamo Sekaráya mé fasane efera hunia koteaka somesapo. Koteaka somerakano ipi Kotiaki kara kekeresapo. ");
INSERT INTO faa_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kekeresa maiya yiamo aporo hinamo ape hakāsa risiamo aseraka someraka, “Manakanarakapo. Makata hakuane,” aíyaka somesapo. Someraka, aporo metāki soko, aporo metāki soko, makata su asesane, somepe pukua Yutía aporo metakira ūria risiaki soko, somepe pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Somerakano ipu kaikia, kára hemakapukua fofaraka someraka, “Manoamo keseke mayiakanarakapo.” Aíyaka ipu suamo hemakapukua somesapo. Arirakano Unihae Kotimo wakapuane manoakiyaki rekenareapo, aíyaka ipu hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Maiya amo Sekaráya ipi himua Ho Kotesa káraraka reke Sekaráyamo Kotimo someane someraka, ");
INSERT INTO faa_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isiapo Isiraya aporo hinamomo Koti Unihae Kárane nōmo makáraraka kekererakanapo. Isu tipura arisia ayiáka risiane, isu arareraka tonotaehoko e perakanapo. ");
INSERT INTO faa_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Arirakano Kotimo makata rakira aporoane Tefetepo. Tefetemo aporo ira amo wainepe pesa anaka, pipu yumo epo isuane farimaka rakiakosakipoko fasereperakanapo. ");
INSERT INTO faa_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Wate fana Kotimo porofete aporomo someraka, ");
INSERT INTO faa_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Re yunu aporomo rukuhoamo Kotimo mafaihokosapo. Aporomo reaki hisiraka mokoatikirakano Kotimo mafasiakosapo.’ ");
INSERT INTO faa_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Aíyaka porofete aporomo somerakano, isiapo makasa kaua kekemane kotimo kamenakaraka araresapo. ");
INSERT INTO faa_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Wate fana isiapo makasa kaua kekema Eparahameaki Kotimo someaka masapo. Epo aumaraka someraka, ");
INSERT INTO faa_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Nómo someaka masane kakaro ayiakakosapo. Eparahame, nómo aporo ira wainakosane yunu aporomo rukua fahokohoamo nōmo mafaihokosapo. Mafairaka nómo aporo ira wainakosane namina namonane nōmo mafahokosapo. Namonane mafaraka repo anopoko rakisimo nōmo ararehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Maiya suamo ereketaeraka risike koteaka susu risikiasimo nōmo ararehokosapo.’ Aíyaka Kotimo Eparahameaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Arirakano nōmo hokosa one, Koti Káramo ipi porofete apororaka rekeakosapo. Epo Unihaepoko epo ikia kára fana maroporape pukusapo. ");
INSERT INTO faa_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Puraka isu Yu aporo hinamo suaki someraka, ‘Keseke aporo meta aperamo re mafasiakosapo. Mafasikia repo himu watikisane epo mafahokosapo.’ Aiyaka hokosa omo some kakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Arirakano Kotimo isupoko kára hemakapukua kamenakarakanapo. Hepene yapunaka faesane isu risia wo peakosapo. ");
INSERT INTO faa_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Aporo katoraka risiaki faesane kakakosapo. Arirakano aporo kukuko makeraka risiane, faesamo kokoa aseakosapo. Isu auaraka risikiasimo ikia kara kotesa á pusimo epo tariakosapo.” Aíyaka Sekaráyamo some kasapo. ");
INSERT INTO faa_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Arirakano Yoneane ipi sisimaraka hokosa raua reke koteaka hemakapukua reapo. Reke ipi hoane soko koteaka wakapuaka reapo. Isiraya aporo hinamoaki some kakako pusiraka, fana ipi ima yaoa reapo. ");
INSERT INTO faa_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Maiya amo Rome aporo hinamo suamo kamani unihae kárane, epo ipi yano motosa Sisa Okásatasepo. Epo Yu aporo hinamo soko i suane, unihaeaka asekea reapo. Aporo hinamo su yano motosa popahokosakipoko epo someraka, “Re su namina apea punie.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Aisa maiya amo aporo hinamo su yano motosa kamanimo popanane kepomaresapo. Maiya amo kamani aporo Kuiríniasemo Siria hauaka hákasane asekea reapo. ");
INSERT INTO faa_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Asekea rea maiya amo aporo su namina apea yano popahoasimo pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Asiamo Yosefe soko, Kariri hauaka, Nasare apeane metakarikia, Yutía hauaka á hisiapo. Petereheme taonea wate fana unihae Tefete takapesa ape á Yosefe hikia, Yosefe ipi Tefetemo aporo ira wainesasamo ipi aporo ira kayakipoko, Petereheme taonea hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Hinaka ipi hinamo faisa Maria umiraka kayane soko, yano motosa popahoasimo tati hakasa hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hinaka Maria ipi hokosa takapeakosa maiya amo Petereheme taonea kayapo. ");
INSERT INTO faa_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Kimisi peraka wará apeane tapesekeno asekea tetá saro ponomakaumo apea toapo. Toakipoko ipi hokosa fanane aporo hokosa takapesapo. Takaperakano saro ponomakaumo asane nasimo kesea taesakipoko, hokosa pasumo taporaka kesea motosapo. ");
INSERT INTO faa_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Maiya amo Petereheme taoneane makeraka, ereamo, saro sipi wafayamo namina saro sipiane yaoa asekea risiapo. ");
INSERT INTO faa_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Namina ayiáka asekea risike, aseane, Kotimo hepene aporo i risia á peraka Kotimo faesane fasereperaka, kára faerakano asekea i namoraka risiapo. ");
INSERT INTO faa_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Namoraka risikino hepene aporomo someraka, “Re namohokopo. Repo sesehoasimo some kotesane nōmo reaki some kakakosapo. Someane aporo hinamo suamo kairaka sesehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pipu, Tefetemo taone, Petereheme taonea, aporo hokosa takapesa amo aporo hinamo re suane mafasiakosapo. Unihae Keresoane epo. ");
INSERT INTO faa_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Asiamo nōmo someraka one repo asekea hemakapuraka, kakarohoareapo, aihokosapo. Asiamo re puraka makata aseakosane nōmo somerakanapo. Makata aseakosane oyapo. Saro ponoakaumo apea asane nasimo taesakipoko á, hokosa pasumo taporaka motosa warekeno, repo aseakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Airakano hepene aporo yakai metakira soko pekea Kotiaki kekereraka kesasapo. ");
INSERT INTO faa_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Kesaraka, “Koti ipi kárapo. Ipi hepene yapura rekenapo. Hauaka wo aporoane epo aseraka sesenapo. Aporoane auaraka risikiasimo epo makoterakanapo.” ");
INSERT INTO faa_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aíyaka kesaraka faraka i metakarikia hepene yapura poparihisiapo. Poparihinakano saro sipi wafaya namina susu someraka “Makata suane Kotimo isuaki somerakasane isiapo aseako Petereheme taonea purakapo.” ");
INSERT INTO faa_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Aíyaka i fofoaka pukua Mariape Yosefe tetā kope pusuapo. Kope pukua tetā asesapo. Asiamo saro ponomakaumo apea asane taesakipoko, hokosa motosa warekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Aseraka Mariape Yosefe tetāki ipu someraka, “Hokosa one hepene aporomo isuaki somerakasapo.” ");
INSERT INTO faa_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Aíyaka somerakano aporo hinamo metakiramo kaikia fofasapo. ");
INSERT INTO faa_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Fofarakano Mariamo ipu somesane hemakapukua kayapo. Epo merarusafapo. ");
INSERT INTO faa_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Arirakano hokosane saro sipi wafaya amo asekea Kotiane makáraraka kesarape poparipusuapo. “Kotimo makata ayiakakosaposane kakaro yasiapo. Kakaro yasiane isiapo asesapo. Makata asesane soko, makata kaisiane soko, seserakanapo.” Aíyaka ipu kesarape poparipusuapo. ");
INSERT INTO faa_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Sokō hakása farakano, sere karimo kau hahaeraka patesa maiya amo, hokosane, Yasu yano motosapo. Maria umihoasiraka fana kaya maiya amo, hepene aporomo yano motoaniesane, yano motosapo. ");
INSERT INTO faa_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Mosesemo somemane karáka, “Aporo hokosa fana takapesane Kotimo menapo. Aíyaka hemakapuraka mena nume mano tetá soko metao, mena korofe tetá soko metao, Kotiaki kakako pirisiti aporomo eke kima paiyakosapo.” Aíyaka Mosesemo some kasapo. Some kasane Yasumo ipi kaīyiape ipi karikinesa wafaya tetapō kakimaka, hokosane maka Yarusarame sitia hisiapo. Hokosa fanane Kotimo ipi menapo. Aíyaka hemakapukua mena mano tetá paikia Kotiaki kasapo. ");
INSERT INTO faa_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Arirakano Yarusarame sitia aporo yano motosa Símione reapo. E ereketaeraka reke Kotimo someane kakimaka reapo. Isiraya aporoane Kotimo ararehokosapo aisane aseako, epo kau reke, Ho Kotesane eyaki hakasa reapo. Ho Kotesamo eaki someraka, “Né kukusiraka reke, mafasira aporo Keresoane Unihae Kotimo pusiehokosapo. Aisane nómo aseakosapo.” Airakano Símionemo kakimaka reapo. ");
INSERT INTO faa_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","E reakipoko Ho Kotesamo e himua someraka, “Kotimo apea né hisie.” Airakano kaikia, Kotimo apea hikia pauraka aseane, Yosefepe Maria tetapō tati hokosane maka perakano asesapo. Kotimo somemane motosane rakiako hemakapukua Kotimo apea maka perakano, ");
INSERT INTO faa_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","hokosane Símionemo ketaka maka, Kotiaki susesapo. ");
INSERT INTO faa_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Epo Kotiaki suseaka someraka, “Kotio, nómo anoaki some karakasuane mano ane oyapo. Yumo ano kuane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Isu Isiraya aporo hinamo farimakosa aporoane pipu nōmo himo aserakanapo. ");
INSERT INTO faa_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","32","E ipi hákasa faesapo. Epo faesane soko, Koti neane soko, hokosa omo Yu aporohoanafonosaki tariakosapo. Isu Yu aporoane makárahoasimo nómo hokosa pusiesapo. Makata one aporo suamo hemakapusimo nómo ayiáka arakire.” ");
INSERT INTO faa_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Aíyaka somerakano Símionemo someane hokosa amo karikinesa wafayape kaīyia tetapō kairaka, “Kepoane yakaparakapo.” Aíyaka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Aíyaka hemakapurakano Kotimo tetāne makotehoasimo Símionemo tetāki some kasapo. Some kaka faraka Mariaki Símionemo someraka, “Hokosa one Kotimo murikimasapo. Epo Kotiane aporo hinamoaki tariasimo e Kotimo pusiesapo. Pusiesane perakano aporo metakiramo eaki hisiraka mainamarekea mokoatikihokosapo. Asiamo e pesasamo Isiraya aporo hinamo metakirane Kotimo farimakosapo. Arirakano metakirane marutaehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Aporomo mainamarekea ipu namina hemakapukua mahamekea risiane mafekemarakano epo aseakosapo. Ayiáka rakirakano, Maria, né, taremo karesa tena ayiáka, ipu mainamarekea mokoatikirakano, nómo aseraka, ne himu kára nekea hemakapukua hisiraka himu tehokosapo.” Aíyaka Símionemo Mariaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Arirakano Kotimo someane kaira porofete hinamo yano motosa Ana kayapo. Anamo ipi wafaya yano motosa Fanuopo. Ipi aporo ira yano motosa Ásapo. Fana e aporomo arumaka kake, keremisi yatipinusu faraka ipi apiane kusuapo. ");
INSERT INTO faa_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kurakano e yaro kake keremisi aiti fo amo (84) e yaro kayapo. Ayiáka Ana ipi kake sisimaraka, Kotiane merarusafapo. Ereamo soko, maíyamo soko, epo Kotiaki kekerenapo. Arirakano maiya suamo epo makata nakosane sokoairaka kake, Kotiaki kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Arirakano Yarusarame aporo hinamomo someraka “Isu mafasiakosa aporo Kotimo pusiehokosapo.” Aíyaka ipu hemakapukua kau risiapo. Arirakano Mariape Yosefe tetapō Kotimo apea hokosane maka pesa maiya amo, hinamo Ana Kotimo apea pekea iane aseraka Kotiaki susesapo. Suseraka Anamo hokosa ane tariraka someraka, “Isu mafasiakosane hokosa oyapo.” Aíyaka Anamo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Unihae Kotimo somemane kasane Mariape Yosefe tetapō kakimaka rakikia faraka, Yarusarame sitiane metakarikia Kariri hauaka poparipukua, tetapō tati ape Nasare apea poparipusuapo. Apea poparipukua risiapo. ");
INSERT INTO faa_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Apea risike Yasu ipi hokosa kara reapo. Ipi wakapuaka reke ipi koteaka hemakapurakano eane Kotimo makotesapo. ");
INSERT INTO faa_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Keremisi suamo Yarusarame sitia Ape Farimaresane Hemakapuko Hokono Kerapo. Asiasamo Yasumo ipi kaīyia soko, ipi karikinesa wafaya soko, tetā sarimahoko hirapo. ");
INSERT INTO faa_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Hikianasamo Yasu ipi keremisi kenosu rea maiya amo Yasu soko karikia hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Yasumo ipi kaīyiape ipi karikinesa wafaya tetā hokono kekea soraka apea poparipusuapo. Poparipurakano Yasu ipi Yarusarame siti yia pariraka kayapo. ");
INSERT INTO faa_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kayakipoko ipi kaīyiape ipi karikinesa wafaya tetapō hemakapuraka, “E fana purakasiapo.” Aíyaka hemakapukua tetā pusuapo. Pukua yao nenehoramo Yasuane wáraka kosapo. Kokoa fasekeno ipi aporo iraki soko, ipi aporo tákeaki soko, kairaka, “Yasuane repo asesare?” Airakano aporo ipu someraka, “Isiapo eane asesafapo.” ");
INSERT INTO faa_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Airakano ipi kaīyiape ipi karikinesa wafaya tetā efera hunia Yarusarame sitia Yasuane kope poparihisiapo. ");
INSERT INTO faa_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Poparihikia yape tetá waka, yape isiamo Kotimo apea hikia aseane, Yu aporo tisa aporoyaki hakāsa Yasuane kakeno asesapo. Aseane, tisa aporomo makata somerakano, Yasumo kairaka kakeno asesapo. Arirakano epo soko tisa aporoaki akai kairaka kayapo. ");
INSERT INTO faa_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Yasumo nenakamaka mokome somehoanafonoraka, koteaka somerakano, aporo su toamo kairaka fofasapo. ");
INSERT INTO faa_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Aíyaka somerakano asekea, ipi kaīyiape ipi karikinesa wafaya tetā fofasapo. Fofaraka ipi kaīyiamo eaki someraka, “Mano neao, né wo marirakano parisare? Ní ata etapo ne koane fasekeno himu fasapo.” ");
INSERT INTO faa_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Airakano epo someraka, “Marirakano mokome kope pusuare? Fana yia nōmo Atamo ape wo aseako peafokore? Nōmo Atamo ape wo aseako pesa satiki ano kakeno asekeafunupo.” ");
INSERT INTO faa_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Airakano epo someane ipi karikinesa wafayape ipi kaīyia tetapō, koteaka hemakapusuafapo. ");
INSERT INTO faa_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Arirakano Yasu ipi kaīyia ipi karikinesa wafayayaki hakāsa Nasare apea poparipusuapo. Tetapō someane Yasumo koaretaesafapo. Anakano makata su asesane ipi kaīyiamo merarusafapo. ");
INSERT INTO faa_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Asiamo Yasuane káraraka ipi himumo hemakapusuane soko koteaka hemakapukua, ipi kauane soko koteaka káraraka, ayiáka rekeno, aporomo aseraka eaki kara sesesapo. Arirakano Kotimo soko eaki kara sesesapo. ");
INSERT INTO faa_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Unihae Sisa Taipiriasemo Rome aporo hinamo suane asekea reke, e unihae káraraka reapo. E unihaeraka reamo, Keremisi senaki suane (14) faraka, Keremisi pare amo (15) Yutía hauakane Potiase Pairatemo ipi unihae wakasemaraka asekea reapo. Arirakano Kariri hauakane Herotemo ipi unihae wakasemaraka asekea reapo. Arirakano Ituria hauakane soko, Tekonaitisi hauakane soko, Herotemo mamanea Firipimo unihae wakasemaraka asekea reapo. Arirakano Apirini hauakane Riseniasemo unihae wakasemaraka asekea reapo. ");
INSERT INTO faa_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Arirakano maiya amo Anasepe Kaiafase tetā pirisiti aporo fanaraka risiapo. Maiya amo Sekaráyamo maeya Yoneane, ima yaoa reke, Kotimo somerakano kaisiapo. ");
INSERT INTO faa_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kaikia he Yotane fu hauaka a koraka reapo. Koraka reke epo some karáka, “Repo himu watikisane Kotimo mafahoasimo makata watikisane metakarikia, eaki risikiako parirasie. Risiako parirakano, nōmo re hea tapukumuriakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Aisane aihoasiraka wate fana porofete aporo Aesayamo sawia popasane oyapo. “Aporo meta yao kauanea rekeakosapo. Á reke epo sakepamo someraka, ‘Unihae peakosane ikia kara makotehoanie. Ikia kara hahaesekeno maereketaehoanie. ");
INSERT INTO faa_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Harusekeno suahoanie. Ūri wakasema soko, ūri kára soko rekeno, pateketaehoanie. Hahaesekeno maereketaehoanie. Eke soko ira pikinu soko tokeno takikia mokoatehoanie. ");
INSERT INTO faa_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ayiáka rakirakano reane Kotimo mafasiakosapo. Mafasirakano aporo hinamo suamo aseakosapo.’ Aíyaka aporoamo some kakakosapo.” Aíyaka some kakakosa aporoane Aesayamo Kotimo sawia popasane Yone ipipo. ");
INSERT INTO faa_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yone reakipoko aseane, aporo yakai Yonemo i hea tapukumuriasimo perakano, asekea, Yonemo iaki someraka, “Re su heseke ayireapo. Kotimo re suane saperaka fanasihokosapo. Kotimo fanasinapaka epamo reaki somerakano, re teketarikia perakanare? ");
INSERT INTO faa_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Arirakano ira kotesamo wate koteaka perapo. Ira wate koteaka apera ayiáka, repo himu watikisane metakarikia, risikiako parisane asekeasimo koteaka susu risikianie. Ayiáka hemakapukua risikiafunusa nine repo hemakapuraka, ‘Isu Eparahamemo aporo ira risiasamo Kotimo aporoane isupo. Asiamo isu siaraka risikinapo.’ Repo aíyaka hemakapukupo. Re Kotimo aporofapo. Eparahamemo ainane kotesapo. Repo ainane watikihoareapo. Asiamo Eparahamemo aporo ira parihoasimo, eke one Kotimo aporomano maparihoane, sia aporomano parihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Asiamo aporomo ira tokohokosakipoko kapi máfaraka area ayiáka, maiya omo Kotimo fanasihokosane soko, ayiáka makeraka rekenapo. Ira wate koteaka peanafonona irane, tokoraka, mokoateraka iramo inakasimo ira paiyakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Aíyaka Yonemo somerakano aporo yakai sarimasamo someraka, “Isiapo yakapa rakiakosare?” ");
INSERT INTO faa_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Airakano Yonemo someraka, “Repo aporo metamo pasu tetá toamo, pasu hakása meta maka, aporo meta pasu fasane kakanie. Arirakano repo aporo metamo makata nakosa tokeno, parakuraka, aporo makata nakosa fasane kakanie.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Airakano takese mora aporo hea tapukumuriasimo peraka someraka, “Tisao, isiapo yakapa rakiakosare?” ");
INSERT INTO faa_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Airakano Yonemo someraka, “Takese mone mora yaiya mokoanie. Mone meta hakimakopo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Airakano aporo terakaiyamosamo someraka, “Isiapo yakapa rakiakosare?” Airakano Yonemo someraka, “Mone hakimokoako aporo rukupo. Mone hakimokoako kotafe topakamaraka hukurukupo. Makata rakisiapoko makata ropo karakáno, repo seseaka makanie. “Makata ropo one siahoasifareapo.” Aihokopo.” ");
INSERT INTO faa_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Aíyaka Yonemo somerakano, kaikia, aporo hinamomo hemakapuraka, “Mafasira aporo, Kereso peakosaposane apera ayare?” Aíyaka hemakapukua asekea toapo. ");
INSERT INTO faa_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Asekea toakipoko aporo hinamo suaki Yonemo someraka, “Re nōmo hea hákasa tapukumurirakanapo. Hea tapukumurisiakipoko aporo kára meta keseke peakosapo. Aporoane aperamo epo re Ho Kotesa soko ira rufi soko muriakosapo. Arirakano aporo káramo tamaka ane aporo raipamo fisinapo. Fisina ayiáka ano wakasemasasamo epo tamaka ane nōmo fisihoane siahoasifareapo. E aporo kárasasamo nōmo epoko raiparaka rakiako ayiane soko, ano wakasemasasamo, nōmo rakiane siahoasifareapo. Ano eyaki siasafapo. ");
INSERT INTO faa_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Aporo kárane peraka, epo sipete asia foke maka peakosapo. Maka peraka hauaka moroa witi hae taesane fokemo fauhoane witi namoane ereketae hurupeperakano ane mokoa apea taehokosapo. Witi kauane fofomo mokoa pukua takua hurupeperakano ane mokoa ira rufi kopakapunafonona a paiyakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Aíyaka Yonemo some kasá ayiáka, some meta soko some kaka, hunia soko some kaka, hunia soko some kaka, ayiáka Kotimo some kotesane epo aporo hinamoaki some kasapo. Ipu koteaka hemakapusimo some kasapo. ");
INSERT INTO faa_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Arirakano Herotemo Kariri hauaka asekea rea maiya amo, ipi mamanea Firipimo asea, Herótiase ane, Herotemo haki arumaka reapo. Epo makata watikisa suane rakirakano, asekea, Yonemo saperaka someraka, “Ne watikirareapo. Ayiakakopo.” ");
INSERT INTO faa_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Airakano Herotemo ipi fana watikiaka rakisia, yaiya efera hunia soko, watikiaka rakiraka, Yoneane tipura makesapo. ");
INSERT INTO faa_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yone tipura makeasiraka rea maiya amo, aporo hinamo su Yonemo hea tapukumurisiapo. Aporo hinamo suane hea tapukumurikia faraka, Yasu soko hea tapukumaresapo. Hea tapukumarerakano Yasumo kurikuriraka reke, aseane, tiane kikisi akā kikisi rorakano asekea reakipoko, ");
INSERT INTO faa_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ho Kotesa mena nume asia, Yasu rea pesapo. Perakano hepene aeyaka Kotimo someraka, “Né, nōmo nī hokosapo. Né nōmo himu tumurumo kára hemakapukua seserakanapo.” Aíyaka hepene aeyaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yasu reke Keremisi tuaneti naene su (29) faraka, Keremisi teti (30) amo makata rakirane kepomaresapo. Aporomo hemakapuraka Yasumo ipi atane Yosefepo. Aíyaka hemakapusuapo. Yosefeane Hiraimo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hiraiane Mátatemo hokosapo. Mátateane Rífaimo hokosapo. Rífaiane Méaokaimo hokosapo. Méaokaiane Yánaimo hokosapo. Yánaiane Yosefemo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosefeane Matataíasemo hokosapo. Matataíaseane Emosemo hokosapo. Emoseane Neamemo hokosapo. Neameane Esiraimo hokosapo. Esiraiane Nákaimo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nákaiane Méatamo hokosapo. Méatane Matataíasemo hokosapo. Matataíaseane Sémenemo hokosapo. Sémeneane Yósekemo hokosapo. Yósekeane Yótamo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yótane Yóananemo hokosapo. Yóananeane Résamo hokosapo. Résane Serápapeomo hokosapo. Serápapeoane Siátiomo hokosapo. Siátioane Néraimo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Néraiane Méaokaimo hokosapo. Méaokaiane Etaimo hokosapo. Etaiane Kosamemo hokosapo. Kosameane Eremétamemo hokosapo. Eremétameane Eamo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eane Yosuamo hokosapo. Yosuane Eriésamo hokosapo. Eriésane Yórimemo hokosapo. Yórimeane Mátatemo hokosapo. Mátateane Rífaimo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Rífaiane Símionemo hokosapo. Símioneane Yutamo hokosapo. Yutane Yosefemo hokosapo. Yosefeane Yonamemo hokosapo. Yonameane Eraíyakimemo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eraíyakimeane Méreamo hokosapo. Méreane Ménamo hokosapo. Ménane Mátatamo hokosapo. Mátatane Nétanemo hokosapo. Nétaneane Tefetemo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Tefeteane Yésemo hokosapo. Yéseane Opetemo hokosapo. Opeteane Póasemo hokosapo. Póaseane Saómonemo hokosapo. Saómoneane Násonemo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Násoneane Amínatapemo hokosapo. Amínatapeane Ataminimo hokosapo. Ataminiane Anaimo hokosapo. Anaiane Héseronemo hokosapo. Héseroneane Péresemo hokosapo. Péreseane Yutamo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yutane Yakopemo hokosapo. Yakopeane Aisakemo hokosapo. Aisakeane Eparahamemo hokosapo. Eparahameane Teramo hokosapo. Terane Nahoremo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahoreane Serakemo hokosapo. Serakeane Riyumo hokosapo. Riyuane Perekemo hokosapo. Perekeane Ipamo hokosapo. Ipane Siramo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sirane Kenanemo hokosapo. Kenaneane Afasatemo hokosapo. Afasateane Sememo hokosapo. Semeane Noamo hokosapo. Noane Remekemo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Remekeane Metuseramo hokosapo. Metuserane Inokemo hokosapo. Inokeane Yaretemo hokosapo. Yareteane Maharariomo hokosapo. Mahararioane Kenanemo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenaneane Inosimo hokosapo. Inosiane Setemo hokosapo. Seteane Atamemo hokosapo. Atameane Kotimo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yasuane hea tapukumarekea reakipoko, Ho Kotesane Yasu ipi himua káraraka komarukua reke, he Yotane ane metakarikia pariperakano, Ho Kotesamo e karikia pukua, ");
INSERT INTO faa_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ima yaoa sere foti amo (40) karikia reapo. Rea maiya amo Satanemo Yasuane mokopipisapo. Arirakano sere foti amo Yasumo makata nesafapo. Nena himu raru reke sere fotiane (40) fahoane Yasuane namo kakaro kára meamosapo. ");
INSERT INTO faa_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Meamoraka reakipoko Satanemo Yasu kau aseakosakipoko mokopipiraka someraka, “Né Kotimo hokosasamo nómo eke akayane maka, ní nakosakipoko farawa maparisie.” ");
INSERT INTO faa_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Airakano Yasumo someraka, “Wae, Kotimo sawia popasane oyapo. ‘Aporomano koteaka rekeako, farawa hákasa nenaka koteaka rerafapo.’ Aíyaka Kotimo sawia popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Aíyaka somerakano, Satanemo Yasuane ūria karikia hisiapo. Hikia ūri terayia risike, kamani kekepomo hauaka kekepoane unihaeaka asekea risia hauaka suane foakayia Yasuaki tarisiapo. ");
INSERT INTO faa_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tariraka someraka, “Hauaka suane soko hauaka á makata su namo kakaro kotesane soko, anoaki kasapo. Kasane nōmo nī hemakapukua aporo metaki kakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Asiasamo nómo anoaki kekererakano, makata ane su nōmo néaki kakakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Airakano Yasumo someraka, “Wae, Kotimo sawia popasane oyapo. ‘Nómo Unihaeane Kotipo. Koti ipiaki hákasa kekerehoanie. Epoko hákasa rakinie.’ Aíyaka Kotimo sawia popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Aíyaka Yasumo somerakano, Satanemo Yasuane Yarusarame sitia karikia hikia, Kotimo ape kopo yapura karikia hikia risike someraka, “Né Kotimo hokosasamo, ní yia hauaka atura hurupesie. ");
INSERT INTO faa_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Huruperakano Kotimo hepene aporoaki someraka, ‘E ararerasie,’ airakano ipu né mafairaka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Né korakea ekemo kareakohoamo hepene aporomo hokonomo né máfaraka maka rekeakosapo. Aíyaka Kotimo sawia popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Airakano Yasumo someraka, “Kotimo some meta Kotimo sawia popasane oyapo. ‘Ní Unihae Kotiane kau aseakosakipoko ayiakakopo.’ Aíyaka Kotimo sawia popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Aíyaka Yasumo somerakano, Satanemo Yasuaki mokopipisane metakarikia pusuapo. Pukua Satanemo hemakapuraka, “Maiya metamo nōmo e mokopipiraka aseakonapo.” Aíyaka Satanemo hemakapukua pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yasu ipi himua Ho Kotesane káraraka reke, Yasu Kariri hauaka á paripusuapo. Yasu Kariri hauaka pukua reke, Yasumo uyáka rakirakanaporakano kaikia, Kariri hauaka aeyaka aporo hinamo suamo kaisiapo. ");
INSERT INTO faa_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Arirakano Yu aporomo sarimana ape yakaia Yasumo some karakano, aporo hinamo suamo kaikia eaki kekeresapo. ");
INSERT INTO faa_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nasare taonea Yasu ipi hokosa mano reane, ape á reke yia, ipi káraraka hokosa raua reapo. Arirakano Nasare taonea Yasu paripusuapo. Fenena maiya suamo, Yu aporomo sarimana apea Yasu pukuanasamo, Yasu Nasare taonea puraka, Yu aporomo sarimana apeá soko, e pusuapo. Pukua, Kotimo sawi menohoko takahiane, ");
INSERT INTO faa_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","eaki porofete aporo Aesayamo sawi popasane eaki karakano epo maka, mafisiraka menosapo. Popasane úyaka menosapo. ");
INSERT INTO faa_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Yasumo menoraka, “Unihae Kotimo ano murikimasasamo epo Ho Kotesane anoaki karakano ano himua rekenapo. Aporo makata forosaki some kotesane nōmo some kakasimo Kotimo ano murikimasapo. Arirakano aporo hinamo tipura kesa, ‘Re tonotaehokosapo.’ Aíyaka somehoko pusierakano ano pesapo. Aporo hinamo hi fausane faraka, efera hunia koteaka asekeasimo ano pusierakano pesapo. Aporo hinamo metakira yunu aporomo karikia pusuane pasimokoako pusierakano ano pesapo. ");
INSERT INTO faa_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Keremisi omo Kotimo aporo hinamoane makotehokosapo.’ Aíyaka nōmo somehoko pusierakano ano pesapo.” Aíyaka popasane Yasumo menosapo. ");
INSERT INTO faa_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Menoraka faraka sawiane takosapo. Takosane sawiane Yu aporomo sarimana apeane asekea rea aporoaki kaka marekea, e asekea kayapo. Kakeno aporo hinamo suamo Yasumo yakapa somerakarihoamo e aseraka risiapo. ");
INSERT INTO faa_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Aseraka risikino Yasumo i asekea someraka, “Sawiane nōmo menorakano repo kaikia arisiamo makata ayiakakosapo, aíyaka popasane, pipu yumo faserepeareapo.” ");
INSERT INTO faa_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Airakano aporo hinamo ipu someraka “Ao, koterakae,” aisapo. Ayiáka ipu namina himumo hemakapuraka, “Epo some akarane some kotesapo. Some kotesane maiyakanarakapo,” aíyaka namina susu hemakapusuapo. Arirakano ipu someraka, “E Yosefemo hokosafae?” ");
INSERT INTO faa_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Airakano Yasumo iaki someraka, “Repo anoaki yapake someraka, ‘Mitikoro, nómo ní makata takamasane fana mafahoanie.’ Aíyaka repo anoaki some meta someraka, ‘Kapaneame taonea nómo makata rakisiapakano isiapo kairaka, nómo ní ape wo soko ayiáka rakinie.’ Aíyaka repo anoaki somehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Arirakano nōmo reaki kakaro somerakaripo. Kotimo some kará porofete aporomo someane ipi ape sumu á aporo hinamo hakāsa risiamo kakimarafapo. ");
INSERT INTO faa_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Hao, kaisie. Nōmo reaki kakaro somerakaripo. Some kepoane oyapo. Fana Iraíya rea maiya amo, Yu hinamo yaro yakai toapo. Maiya amo keremisi isia faraka, keremisi kitafa amo, ere maiya namasu amo, kupa kára karaka hauaka sua makata nakosane fasapo. ");
INSERT INTO faa_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Makata nakosa farakano asekea, Iraíyane Yu aporomo hauaka á aporo hinamo ararehoko Kotimo pusiesafapo. Yu hinamo yaro yakai toane ararehoko pusiesafapo. Yu aporohoanafonosamo hauaka meta pusiesapo. Saetone hauaka á pukua, Sarefa apea hinamo yaro kayane ararehoko pusiesapo. ");
INSERT INTO faa_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Arirakano fana porofete aporo Iraísa rea maiya amo, Isiraya hauaka á Yu aporo risiane aporo toropakesa yakai risiapo. Risiane i suane mafasafapo. Arirakano Yu aporohoanafonosamo hauaka Siria aporo hakása meta, yano motosa Neamane, e toropakesa rekeno e hakása mafasapo.” ");
INSERT INTO faa_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Aíyaka Yasumo somerakano aporo hinamo su Yu aporomo sarimana apea toamo kairaka, ipu kakaro kara sapesapo. ");
INSERT INTO faa_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Saperaka takahihiraka, Yasuane waseremaka karikia pukua, apeane metakarikia ūri faea hikia ūri terayia aeyaka, feseremosa á Yasu makasuhokosakipoko ");
INSERT INTO faa_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","asiane, Yasumo ipi aseraka, ipi yia rea nine puraka fasapo. ");
INSERT INTO faa_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yasu pukua Kariri hauaka Kapaneame taonea pausapo. Pauraka fenena maiya amo some kasapo. ");
INSERT INTO faa_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Some karakano aporo hinamomo kaikia himu faraka fofasapo. Epo wakapuaka some karakano kaikia “Someane enahoasifareapo.” Aíyaka aporo hinamo suane fofasapo. ");
INSERT INTO faa_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Arirakano Yu aporomo sarimana apea aporo hakása meta, yatafumo e ho masa reke, epo sakepamo wáraka someraka, ");
INSERT INTO faa_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ae, ae, Yasu né Nasare aporopo. Nómo isu mayiakakosare? Isu mokoatikihoko pesare? Né nōmo aserapo. Né Kotimo pusiesane, né ipi hokosa namo kakaro kotesapo.” ");
INSERT INTO faa_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Airakano Yasumo yatafuaki someraka, “Nómo mehokopo. Nómo aporo ho masane metakarikia né pusie.” Airakano aporo hinamo risia arakaru tipia, yatafumo aporo ho masane hauaka atura makasuraka marekea aporoane kakaro mokoatikihoanafonoraka, aporo ho masane yatafumo metakarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Purakano aporo hinamo su sarimaraka risiamo asekea, fofaraka namina susu someraka, “Someane marirakanarakapo. Aporo káramo somera ayiáka epo wakapuaka someraka, yatafu pusierakano, yatafumo kakimaka apure,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ayiáka rakirakano asekea hauaka makea aporo hinamo risia suaki “Yasumo uyáka rakisiapo.” Airakano aporo hinamo suamo kaisiapo. ");
INSERT INTO faa_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yasu takahikia Yu aporomo sarimana apeane metakarikia pukua, Saemonemo apea yorosapo. Yoroane Saemonemo ipi aseamo kaīyia kau kára sisipuraka, makata takamarakano, e mafahoasimo ipu Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Somerakano hinamo makata takamasa warea á Yasu pukua asekea, reke, e kau kara sisipusaki Yasumo wakapuaka someraka, “Kau sisipu, né metakarikia pusie.” Airakano kau sisipuane fasapo. Faraka, wate foaka hinamo ane takahikia, ipoko makata nakosa paikia kasapo. ");
INSERT INTO faa_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Arirakano wakasema nina maiya tuakeramo, aporo hinamomo namina aporo hinamo táke metakirane makata tasa Yasu rea karikia pesapo. Karikia perakano i makata tasa suane Yasumo hokonomo sakaihoane su fasapo. ");
INSERT INTO faa_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Arirakano aporo hinamo yakai yatafumo i ho mosane, yatafumo iane metakarikia wárape puraka someraka, “Né Kotimo hokosapo.” Airakano Yasumo iaki sakepamo someraka, “Repo mehokopo,” aisapo. Ipu “Aporo hinamo suane mafasiasimo, Yasuane Kotimo murikimasapo. Asiamo e Keresopo.” Aíyaka ipu hemakapusuasamo Yasumo iaki “Mehokopo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mituru fiarakano Kapaneame taoneane Yasumo metakarikia, kamaka nena yaoa aporo fasakipoko pusuapo. Pusuakipoko ipu Yasuane kokoa, aseraka someraka, “Isiapo apeane metakarikia pukupo.” ");
INSERT INTO faa_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Airakano Yasumo someraka “Ano ape metakira á soko some kotesane some kakako pukusapo. Koti unihaeaka reane some kakako Kotimo ano pusiesapo.” ");
INSERT INTO faa_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Aíyaka Yasu pukua Yutía hauaka koraka reke, ape sumu meta Yu aporomo sarimana apea some kaka, ape sumu meta á soko Yu aporomo sarimana apea some kaka, ayiáka some kape puraka reapo. ");
INSERT INTO faa_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","He kekea kaya, he Kenesarete fua Yasu rea maiya amo, aporo hinamo suamo Kotimo someane kaiyako pesapo. Kaiyako peraka aporo hinamo su sarimaraka, hauaka á taperakano, metakira kekefokekeforaka, metakiramo hokonomo koaka taeraka pekea, kaikia risikino asesapo. ");
INSERT INTO faa_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Arirakano Yasumo aseane pokoa mora aporoamo ipu namina kasuane metakarikia, kasipuane kusuraka risike, kasu tetákara karikimaresekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Arirakano Yasuane Saemonemo kasua ripaka reapo. Ripaka reke Saemoneaki Yasumo someraka, “He fe wakasema makeraka rokoa pusie,” aisapo. Aíyaka puraka Yasu kasu tua kake, aporo hinamo he fua risiaki some kasapo. ");
INSERT INTO faa_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Some kaka faraka, Saemoneaki Yasumo someraka, “He numu aeyaka rokoa pusie. Puraka risike pokoa mokoako repo kasipuane mokoa hea kokomurisie.” ");
INSERT INTO faa_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Airakano Saemonemo someraka, “Tisao, pipu ereamo isiapo kasipuane mokoa hea kokomuriraka risike, yao fiasane pokoa mosafapo. Pipu ereamo isu fenesafapo. Pokoa mokoanafonosa nine nómo ayisierakano isiapo kakimaka kasipuane mokoa hea kokomurirakanapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Aíyaka kasipuane hea kokomurikia, kihoane pokoa yakai kára hatirimaka pusuane su kasipua kesapo. Keraka umiraka kasipu ane potakaheakorakano asekea, ");
INSERT INTO faa_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","kasu meta ipu namina moremo kasuane tapukurekeno aseraka, hokono haesapo. Hokono haerakano, kasuane soko rokoa pekea, kasu tetákara pokoamo komarusuapo. Komaruraka umiraka, kasu hea kenepesahopo. ");
INSERT INTO faa_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Arirakano kasu pokoamo komarusuane Saemone Pitamo aseraka, Yasu rea kakuna porokoa kake someraka, “Unihaeo, ano himu watikisapo. Né anoyaki hakāsa reke siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Aíyaka epo soko namina suamo pokoa sakepamo mosane aseraka kara fofasapo. ");
INSERT INTO faa_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Arirakano Sepetemo maeya Yamesepe Yone tetā Saemoneyaki hakāsa makata rakira aporopo. Tetā soko fofasapo. Arirakano Saemoneaki Yasumo someraka, “Ne namohokopo. Nómo pokoa amora ayiáka, aporo hinamo ane ano patera asekeasimo nómo ayiáka pasimokoakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Arirakano i kasu rokoa, he fea pukua kasu matapea kasuane karimarekea, makata su yia metakarikia i Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Arirakano maiya metamo Yasuane ape meta reakipoko, aporo toropakesa pekea, Yasu ipi yano motosane kárapo, aíyaka hemakapukua, kakuna porokoa kake someraka, “Unihaeo, nómo ano mafahoko seseraka soko metao, ne seserire?” ");
INSERT INTO faa_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Airakano Yasumo ipi hokono raeraka sakairaka someraka, “Ano seseripo. Né makata takamasane farasie.” Aihoanine aporo toropakesane wate foakayia fasapo. ");
INSERT INTO faa_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Farakano Yasumo someraka, “Aporo metakiraki somehokopo. Pirisiti aporo rea pukua, né kau toropakesa fasane, pirisiti aporoaki tarinie. Tarikia, Mosesemo somemanemo ayiáka kakaniesane yaiya kakanie. Né mafasasamo makata yaku ayiáka kakanie. Ne fasane aporo hinamo suamo asekea hemakapusimo nómo ayiáka kakanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Asiakipoko Yasumo makata rakisiane aporo metamo asekea, aporo metaki someaka, arirakano aporo metamo aporo metaki someaka, aíyaka hauaka sua somepe pusuapo. Somerakano kaikia hauaka su aeyaka Yasumo someane kaiyakosakipoko aporo hinamo yakai pesapo. Arirakano aporo hinamo yakai makata tasane soko mafahoasimo pesapo. Perakano iane Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mafáraka rea maiya amo, Yasu ipi haku ima yaoa pukua reke, Kotiaki kurikurihoko puraka rerapo. ");
INSERT INTO faa_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Maiya metamo Yasumo some karakano Ferese aporo soko, Kotimo somemane tisa aporo soko, Kariri hauaka ape su aeyaka soko, Yutía hauaka ape su aeyaka soko, Yarusarame siti aeyaka soko, ape sumu su aeyaka pekea toapo. Aporo makata tasane Yasumo mafahoasimo Kotimo ipi wakapuane Yasuyaki hakasa reapo. ");
INSERT INTO faa_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Arirakano aporo metakiramo aporo korosakataesane fefeneakua makekea maka pekea, Yasu rea apea maka pesapo. Maka pekea ape kakarua maka pukua Yasu hikumisi nenemea motoako pukusakipoko ");
INSERT INTO faa_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","aseane, aporo hinamo yakai sarimaraka ape tapesekeno metakarisiapo. Metakarikia, ape kopoa maka hisiapo. Maka hikia ape kopoane feteketaeraka, aporo fefeneakua makesane ape kakarua Yasu rea, tau yia hurutapisiapo. ");
INSERT INTO faa_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Arirakano aporo korosakataesane maka pesa aporo kitafasuamo, aporo korosakataesane Yasumo mafahoasimo, ipu Yasuaki himu hakásaraka hemakapusuapo. Ipu himu hakásaraka hemakapukua maka perakano, Yasumo asekea, aporo fefeneakua makesaki someraka, “Né himu watikisane nōmo mafarakanapo.” ");
INSERT INTO faa_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Airakano Ferese aporomo soko, Kotimo somemane tisa aporomo soko, namina susu someraka, “Aporo himu watikisane mafarakanapo, airakane Kotimo ipi airaka sikirakae. Epo Kotiane mawakasemarakane, e epare? Aporo himu watikisane aporomo mafanafapo. Kotimo ipi hákasa mafanapo.” ");
INSERT INTO faa_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Airakano ipu hemakapusuane Yasumo aseraka someraka “Repo marirakano ano mahokoparirakanare? ");
INSERT INTO faa_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aporo himu watikisane mafanane kárare? Aporo makata takamasa mafanane wakasemare? Meta mane kárare? Meta mane wakasemare? Wae, tetákara hakása yinesapo. ");
INSERT INTO faa_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Hao, kaisie. Aporomanomo Tákeane anopo. Hauaka wo aporo himu watikisane nōmo mafahoasimo, Kotimo ano murikimaka maresapo. Maresasamo repo asekeasimo, aporo korosakataesaki nōmo takahisierakanapo.” Aíyaka aporo korosakataesaki Yasumo someraka, “Ne takahisie. Takahikia nómo ní asakapuane maweroraka maka, né ní apea pusie.” ");
INSERT INTO faa_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Airakano i hikumisia aporoane wate foaka takahikia ipi asakapuane maweroraka maka, ipi apea paripusuapo. Ipi puraka, Kotiaki kekererape pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Purakano aporo hinamo sarimasamo aseraka fofasapo. Fofaraka someraka, “Pipu makata haku aserakaripo.” Aíyaka Kotiaki kara kekereraka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aporo korosakataesane mafaraka, Yasu pukua aseane, takese mora aporo yano motosa Rífai takese mora oposea kakeno asesapo. Aseraka Yasumo Rífaiaki someraka, “Né, ano patera aseako peae.” ");
INSERT INTO faa_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Airakano Rífaiane takahikia makata su metakarikia, Yasu patera asekea tati hakasa pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Puraka Rífaimo someraka, “Yasu né, nōmo apea makata nako peae.” Airakano aporo takese mora watikiaka risiane soko, aporo metakira himu watikiaka risiane soko, sarimaraka, Yasuyaki hakāsa Rífaimo apea makata nako sarimaraka toapo. ");
INSERT INTO faa_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Toke makata nenakano, Ferese aporomo soko ipu Yasumo aporo hakāsa puraki someraka, “Aporo takese mora aporo soko aporo himu watikisa akiyaki, marirakano re iyaki hakāsa toke makata nenakanare?” ");
INSERT INTO faa_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Airakano Yasumo someraka “Aporo koteaka reane mitikoromo mafahoko e rea purafapo. Aporo makata takamasane mitikoromo mafahoko e rea purapo. ");
INSERT INTO faa_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Aporo himu watikiaka risiamo himu watikisane rukupateraka metakarisimo, nōmo mafahoko ano perakayiapo. Aporo kotesane nōmo mafahoko ano perakayiafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Aporo metakiramo Yasuaki someraka, “Yone hea tapukumareramo ipi aporo hakāsa puramo makata nakosane sokoairaka Kotiaki kurikurinapo. Efera hunia soko, efera hunia soko, Ferese aporoaki patera asesa aporoamo soko makata nakosane sokoainapo. Arirakano nómo aporo hakāsa puramo he soko, makata nakosane soko sokoairakarifapo. Airakane marirakanore?” ");
INSERT INTO faa_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Airakano Yasumo takumeaka someraka, “Isiapo Yu aporomo ainane oyapo. Aporomo hinamo arumarakano, aporo suamo hokono keraka, seseraka, makata nenapo. Nenaka aporo hinamo kawe apia iyaki hakāsa rekeno, aporo hinamo suamo himu hisihoanafonoraka, iyaki hakāsa seseraka risike, makata nakosa sokoainafapo. ");
INSERT INTO faa_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Arirakano aporo, hinamo kawe apia ane, aporo metakiramo waseremaka apura maiya amo, i himu hisiraka ipu makata nakosane sokoaihokosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Asiamo makata kawe rakirane soko, makata paté fana rakirane soko, sarimahokohoamo Yasumo takume meta someraka, “Pasu paté koasakipoko, pasu kawe resakamaka paremarekea irinafapo. Pasu kaweane koahoane siahoasifareapo. Pasu kawe resakamaka, pasu patéa paremarekea irihoane, tati sianafapo. Tatī kekeponapo. ");
INSERT INTO faa_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Arirakano saro nanikose kau aporomo maka petoro irinapo. Iriraka waene he kawe metekesane, petoro patéa takamanafapo. Petoro patea takamarakano waene he kawemo ponoponoraka, petoro patéane fauhokosapo. Fauraka petoro kakeraka fetefeteraka, waene heane sakuriakosapo. Sakuriraka waene he soko, petoro soko, tetákara yi fahokosapo. ");
INSERT INTO faa_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Asiamo waene he kawe metekesane petoro kawea takamakanie. ");
INSERT INTO faa_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Aporomo someraka, ‘Waene he patéane kotehoareapo. Ane seseripo,’ airapo.” Aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Fenena maiya hakása metamo witi hemoa Yasu pusuapo. Pukua witi haeane ipi aporo hakāsa puramo tukua hokonomo sosokeraka nesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nenakano, Ferese aporomo asekea someraka, “Fenena maíya yaposane marirakano repo mamosorakanare?” ");
INSERT INTO faa_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","4","Airakano Yasumo someraka, “Wate fana, Tefete soko, ipi aporo hakāsa pura soko, kára meamorakano, Tefeteane ipi Kotimo apea yorokoa pukua, Kotipoko farawa taesane maka nesapo. Nekea ipi aporo hakāsa puraki soko nasimo kasapo. Kotiaki farawa kasá taesane aporo hinamo ipu suamo nakohoamo yaposapo. Arirakano pirisiti aporo ipu namina hákasamo nenane yaposafapo. Asiāne Tefete ipi pirisiti aporohoanafonosa yiamo nesapo. Aíyaka Kotimo sawia popahoareapo. Popasane repo menoraka, some kepoane hemakapurakarifapo. ");
INSERT INTO faa_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Fenena maiya amo makata aina marerane ano unihaeaka rekenapo. Aporomanomo Tákeane anopo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Fenena maiya metamo Yasu Yu aporomo sarimana apea yorokoa some kasapo. Some kasa maiya amo, aporo hokono tumuru takuane narisa rekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Arirakano Kotimo somemane tisa aporo soko, Ferese aporo soko, ipu Yasumo fenena maiya amo aporo hokono narisa mafarakarihoamo asekea risiapo. Fenena maiya amo Yasumo mafarakano asekea, ipu Yasuaki hukurukusakipoko asekea risiapo. ");
INSERT INTO faa_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Asekea risikino, ipu hemakapusuane Yasumo aseraka, aporo hokono narisaki someraka, “Né, takahikia pekea tipi wo reae.” Airakano aporoane takahikia asekea reapo. ");
INSERT INTO faa_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Asekea rekeno, Yasumo Kotimo somemane tisa aporoaki soko, Ferese aporoaki soko someraka, “Fenena maiya amo koteaka rakirane soko metao, watikiaka rakirane soko metao, rakira meta mamo Kotimo somemane mamosorakanare? Aporo meta kurapaka ararenane soko metao, aporo meta rurane soko metao makata rakira meta mamo Kotimo somemeane mamosorakanare?” ");
INSERT INTO faa_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Aíyaka i aporo suane Yasumo asekea, aporo hokono narisaki someraka, “Ne hokono raerasie.” Airakano hokono raehoane, hokono narisane fasapo. ");
INSERT INTO faa_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Hokono narisane farakano asekea, Ferese aporo soko, Kotimo somemane tisa aporo soko, ipu kára saperaka namina susu me rukua someraka, “Yasuane kukusimo isiapo rukusapo. E mayiáka isiapo runarakapo.” Aíyaka me rukua somesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Yasu ūria kurikurihoko hisiapo. Hikia ere hakásamo e warafaraka, Kotiaki kurikuriraka reke, yao fiasapo. ");
INSERT INTO faa_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Fiarakano aporo hakāsa pura murikimakosakipoko, peaerakano, i su pesapo. Aporo su pesane, epo aporo kenosu murikimaka, iaki yano motoraka tarira aporo yano motosapo. ");
INSERT INTO faa_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tarira aporo murikimasane yano taesane oyapo. Saemone ipi yano motosa meta Pitapo. Arirakano meta Saemonemo ipi mamanea Enitupo, arirakano meta Yamesepo, arirakano meta Yonepo, arirakano meta Firipipo, arirakano meta Patóromiupo, ");
INSERT INTO faa_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","arirakano meta Matiupo, arirakano meta Tomasepo, arirakano meta Afiasemo maeya Yamesepo, arirakano meta Rome kamanimo Yu aporo asekea reane metakarisimo hemakapura aporo Saemonepo, ");
INSERT INTO faa_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","arirakano meta Yamesemo maeya Yutasepo, arirakano meta Yasuane parakehokosa aporo Yutase Isekeriopo. I su Yasumo murikimasane ayapo. ");
INSERT INTO faa_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yasuane aporo kenosuyaki ūri aeyaka pekea punua pausapo. Hauaka á eyaki aporo hinamo hakāsa pukua, kára sarimasapo. Arirakano Yutía hauaka su aeyaka aporo yakai pekea sarimaraka, Yarusarame siti aeyaka soko pekea sarimasapo. Arirakano ipu Yasumo someane soko kaiyako peraka yia, ipu aporo hinamo makata tasane soko mafahoasimo karikia pesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Aporo yatafumo ho mosane soko perakano Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Yasumo wakapuamo aporo hinamo makata tasa suane mafarakano ipu namina suamo Yasuane sakaihoko pesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yasumo ipi aporo hakāsa purane asekea someraka, “Repo someraka, ‘Kotimo menane ano forokoa reasasamo, Kotimo hemakapusua ayiáka, nōmo hemakapukusakipoko seseripo.’ Aisa aporo hinamoane Kotimo unihaeaka asekea rekenapo. Asekea reke Kotimo reane makoterakano, re seseraka risikianie. ");
INSERT INTO faa_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Arirakano yumo re meamoraka risike, seseraka risikianie. Keseke repo siaraka makata nakosapo. Arirakano yumo re hihiripuraka risike seseraka risikianie. Keseke re kara seseraka takuhokosapo. ");
INSERT INTO faa_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Arirakano repo Aporomanomo Táke anoane patera asesasamo, reaki aporo metakiramo hisiraka re patera tarikia, re ekeneraka someraka, ‘Re aporo watikirareapo.’ Airakano re seseraka risikianie. ");
INSERT INTO faa_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kára seseraka hokono potepoteraka risikianie. Hepene yapura repo makata ropo kára tokenapo. Asiamo porofete aporoane ipu makasa kaua kekemamo mokoatikisa ayiáka, re soko ayiáka mokoatikihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Arirakano makata kemo kárasa aporo re asekeanie. Repo makata kemo su hauaka wo siaraka mosapo. ");
INSERT INTO faa_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Arirakano yumo repo makata nakosa kára nenaka re asekeanie. Keseke re meamohokosapo. Arirakano yumo re takuraka risikino re asekeanie. Keseke re hihiripuhokosapo. ");
INSERT INTO faa_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Arirakano reaki aporo suamo kekereraka somerakano re asekeanie. Fana namina makasa kaua kekemamo kotafe porofete aporoaki kekeresa ayiáka, ipu reaki soko ayiáka kekererakano asekeanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yasumo someraka, “Repo kaikia risikino nōmo reaki somerakanapo. Aporo metamo ne mokoatikirakano, nómo eaki himu tumurumo hemakapunie. Aporo metamo neaki hisirakano, nómo eane makotehoanie. ");
INSERT INTO faa_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Aporo metamo neaki yakasa ho marerakano, aporoane nómo makotena someane eaki some kakanie. Aporo metamo neaki some watikisa somerakano, nómo epoko farimaka kurikurihoanie. ");
INSERT INTO faa_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Aporo metamo ne akai parea rurakano, nómo rukuroponafaraka, akai pare takua soko rusimo tarinie. Aporomo nómo pasu osonane maka, nómo pasu osona metane soko marakano, waehokopo. ");
INSERT INTO faa_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aporomo neaki makasierakano, nómo kakanie. Aporomo nómo makata kemoane marakano eaki, ‘Nōmo makata kemoane nī fímakasie,’ aihokopo. ");
INSERT INTO faa_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Arirakano nómo hemakapuraka, ‘Aporo metamo anoaki makoteraka ararehoasimo, ano seseripo,’ aíyaka nómo hemakapurakanone, nómo fana aporo aki nómo makoteraka rakinie. ");
INSERT INTO faa_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Aporo metamo neaki himu tumurumo hemakapurakano, nómo soko eaki ropo himu tumurumo hemakapukua someraka, ‘Kotimo ano makotehokosapo,’ aíyaka hemakapuane siahoasifareapo. Nómo aina ayiaka aporo watikiaka reramo soko ainane hakása yiyapo. Arirakano aporo metamo aporo watikiaka rerane himu tumurumo hemakapurakano, epo soko neane ropo himu tumurumo hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Arirakano aporo metamo né makoterakano, nómo soko e makotena akipoko, nómo hemakapuraka, ‘Kotimo ano makotehokosapo.’ Aíyaka hemakapukupo. Asiamo nena aporomo soko hakása yineraka rakirapo. ");
INSERT INTO faa_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Nómo aporo meta mone arareraka, nómo takekea hemakapuraka, ‘Aporo aki nōmo mone yāno karakano, moneane epo anoaki parikakakosapo.’ Aíyaka hemakapukua eaki mone karaka, nómo hemakapuraka, ‘Nōmo koteaka rakisiasamo Kotimo ano makotehokosapo.’ Aíyaka hemakapurakanone ane siahoasifareapo. Nena aporomo ayiáka hemakapurapo. Ipu hemakapuraka, makata kasáne ropo makosakipoko karápo. Repo makata arakiramo nena aporomo rakirane marokehoanie. ");
INSERT INTO faa_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Asiamo aporo metakiramo reane mokoatikirakano, aporoane repo himu tumurumo hemakapunie. Aporo metakirane makotehoanie. Aporo metakiraki makata yaku kakanie. Makata yaku kasane nómo ní keseke makosakipoko hemakapukupo. Ayiáka koteaka risikino, Unihae Koti Káramo reane ipi hokosapo, aihokosapo. Aíyaka reane epo karikia nakosapo. Arirakano reaki makata ropo kára kakakosapo. Arirakano suse aihoanafonona aporoane soko Kotimo ararenapo. Arirakano makaripi aira aporoane soko, Kotimo makotenapo. ");
INSERT INTO faa_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Asiamo repo Ata Kotimo aporo hinamo su kamenakana ayiáka, repo soko aporo hinamo suane ayiáka kamenakahoanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Yasumo someraka, “Nómo aporo metane hokomaka someraka, ‘E watikiaka are. Ano koteaka rekenapo. E area ayiáka ano rekenafapo.’ Aihokopo. Nómo hokomaka somehoanafonorakano, aporo metakiramo soko, Kotimo soko, neaki ayiáka hokomaka somehokosafapo. Arirakano nómo someraka, ‘E fanasirasie.’ Aihokopo. Aihoanafonorakano neaki soko, ‘Fanasirasie.’ Aihokosafapo. Arirakano aporo metamo ne mokoatikirakano eaki nómo himumo mahisisane mafahoanie. Mafarakano Kotimo soko nómo watikisane mafahokosapo. ");
INSERT INTO faa_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nómo makata karakano neaki soko makata kakákosapo. Karáka kára komarukua kakakosapo. Komarurakano pipiraka kapusuraka sakopepehoasimo kakakosapo. Nómo makata akara ayiáka, neaki soko yaiya kakakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yasumo iaki takumeaka someraka “Aporo hi fausamo aporo meta hi fausa hokonoa maka karikia puane siahoasireare? Wae, tati tetákara kutua eteraka hurupepehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tisa aporo ipi fanaraka rerapo. Ipi aporo hakāsa purane kesekenapo. Aporo hakāsa puraki kakaro koteaka tarikia sukururakano asekea, ipu makata su koteaka enomaka risike, tisa aporomo ipi hemakapukua area ayiáka, aporo hakāsa puramo soko ayiáka, hemakapukua risirapo. ");
INSERT INTO faa_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Arirakano nómo ní maemo hia makata pepeno wakasema kayane aserapo. Aseraka yia nómo ní hia makata pepeno kára kayane marirakano asekepayarakanare? ");
INSERT INTO faa_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Asekepayaraka yia nómo ní maeaki someraka, ‘Maeo, né hia makata pepeno wakasema akayane, nōmo maka mamakatehokoripo.’ Aíyaka nómo somerakanone, né aporo himu tetáraka rekenapo. Fana nómo ní hia makata pepeno wakasema akayane maka mamakatehokosakipoko, nómo ní korakano siaraka kokoa aseakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yasumo someraka, “Ira kotesamo wate watikisa perafapo. Ira watikisamo wate kotesa perafapo. ");
INSERT INTO faa_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ira wate aseraka ira namo hemakapurapo. Sako utumua, foke wate pekerea tumarafapo. Sako keta risia sako karepe wate tumarafapo. ");
INSERT INTO faa_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Mahimuna makatane, himumo hemakapurapo. Aporo hinamo kotesamo himumo koteaka hemakapukua, akaimo soko koteaka somerapo. Koteaka hemakapukua koteaka rakirapo. Arirakano aporo hinamo watikisamo himumo watikiaka hemakapukua akaimo soko kekemaraka watikiaka somerapo. Watikiaka hemakapukua watikiaka rakirapo. Aporo hinamomo himumo makata hemakapusuane akai aeyaka somerapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yasumo someraka, “Repo anoaki, ‘Unihaeo, Unihaeo,’ airaka yia, nōmo makata rakiniesane rakianafononane marirakanonare? ");
INSERT INTO faa_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Arirakano aporomo ape kiakosakipoko hauaka parosa á ira kesa poroako hauaka rakea kuturaka ira kesa porokoa ape kisiapo. Ape kisiakipoko he huku puraka, ape koteaka kisiasamo rakarimaka pusuafapo. Rakarimaka punafonosa ayiáka, aporo hinamo ano rea pekea, nōmo someane kakimaka rakira aporo hinamoane asíapo. ");
INSERT INTO faa_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Arirakano aporo metamo hauaka sakipu kima ape kiraka, hauaka wakasema kima susu rakea, ira kesa porokoa ape kisiane, he huku puraka, ape hauaka sakipusa kisiasamo, wate foakayia rakarimaka pusuapo. Rakarimaka puraka anusapo. Ape hauaka sakipua kisia hemo rakarimaka pusua ayiáka, nōmo some kakipayaraka rakianafonona aporo hinamoane asiapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Aporo hinamo ipu suamo kaiyisimo, Yasumo some kaka faraka ipi Kapaneame taonea pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kapaneame taonea Rome aporo terakaiyamosa satini reapo. Epo ipi aporo raipane kára hemakapukua sesenapo. Asiane epo aporo raipane makata takamasa kukuko makesapo. Kukuko makerakano satinimo kaiyiáne, “Yasumo aporo makata takamasa mafanapo.” Airakano kaisiapo. ");
INSERT INTO faa_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Kairaka Yu aporo sisimaki someraka, “Yasumo nōmo aporo raipa makata takamasane mafahoasimo, Yasu pasimako pusie.” Airakano aporo sisimane pukua ");
INSERT INTO faa_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Yasu rea pauraka kukunameaka someraka, “Rome aporo satiniane ipi aporo kotesapo. E nómo ararehoane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Epo isu Yu aporoane hemakapurapo. Epo isupoko Yu aporomo sarimana apeane epo máfaraka kisiapo. Asiamo nómo e ararehoane siahoasireapo.” ");
INSERT INTO faa_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Airakano Yasuane iyaki hakasa pusuapo. Pukua satinimo ape ane makeraka pesapo. Yasu perakano satinimo asekea ipi aporo tákeaki someraka, “Né pukua Yasuaki somehoanie. Nōmo some akara one nómo eaki uyáka some kakanie. ‘Unihaeo, né peraka wafororareapo. Ano aporo wakasemapo. Né aporo kárasasamo iti siasafapo. Asiamo nōmo apea né peane siahoasifareapo. ");
INSERT INTO faa_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ano wakasemasamo né rea ano pesafapo. Né yia reke, nómo someraka ipi aporo makata takamasane farasie, aihoanie. Farasierakano nōmo aporo raipa makata takamasane fahokosapo. ");
INSERT INTO faa_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Arirakano ano asekea rea aporoamo, anoaki makata rakisierakano nōmo rakirapo. Arirakano nōmo aporo asekea reaki pusierakano e purapo. Peaerakano e perapo. Nōmo aporo raipaki makata rakisierakano epo rakirapo. Nōmo aira ayiáka, nómo soko aporo makata takamasane farasierakano, e fahokosapo.’ Aíyaka repo Yasuaki somehoanie.” ");
INSERT INTO faa_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Airakano i pukua satinimo someaka maresane Yasuaki ipu somesapo. Somerakano Yasumo kaikia sesesapo. Seseraka eyaki aporo hinamo hakāsa pesaki someraka, “Yu aporohoanafonosa aporo terakaiyamosa satinimo anoaki himu hakásaraka hemakapukua reareapo. Satinimo anoaki himu hakásaraka hemaka apura ayiáka, Isiraya hauaka Yu aporo metamo anoaki ayiáka himu hakásaraka hemakapurafareapo.” ");
INSERT INTO faa_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Airakano satinimo ipi aporo tákemo Yasuane metakarikia, satinimo apea popariperaka aseane, aporo raipa makata takamasane fasekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Sere metamo Yasu Naine taonea pusuapo. Epo ipi aporo hakāsa pura soko, aporo metakira soko, eyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Pukua ape ruru ikia koro makeraka aseane hokosa raua kusuane fefeneakua makekea kunikia motoakosakipoko maka perakano asesapo. Hokosa kusuane hinamo yaromo aporo hokosa hakása yiyapo. Ape aeyaka hinamo yaroyaki aporo hinamo yakai perakano asesapo. ");
INSERT INTO faa_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Asekea Yasumo hinamo yaroane kamenakaraka someraka, “Né hiripuhokopo.” ");
INSERT INTO faa_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Aíyaka aporomo fefeneakua hokosa kusuane makekea ira paka pusuane fenekea risikino fefeneakua Yasumo sakairaka someraka, “Hokosa rauao, né turikia pukua takahisie.” ");
INSERT INTO faa_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Airakano hokosa raua fefeneakua wareane, foakayia turikia pukua asekea kayapo. Asekea kake makata somesapo. Somerakano asekea, hinamo yaroaki Yasumo someraka, “One nómo ní hokosapo. Ní apea karikia pusie.” ");
INSERT INTO faa_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Airakano aporo hinamo suamo aseraka himu fasapo. Himu faraka Kotiaki kekereraka someraka, “Porofete aporo kára isu arisia fasereapere. Kotimo ipi aporo hinamoane ararehoko apere.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Arirakano Yutía aporo hinamomo soko, Yutía hauaka makeraka aporo risiamo soko, Yasumo aporo kusuane maturikia taesapakano kaisiapo. ");
INSERT INTO faa_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yasumo makata rakisiane, Yonemo ipi aporo hakāsa puramo Yoneaki somesapo. Somerakano kaikia, Yonemo ipi aporo hakāsa pura tetá peaerakano aporo tetá Yone rea pesapo. ");
INSERT INTO faa_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Perakano Yonemo someraka, “Teto pusie. Teto pukua, Unihae Yasuaki kaiyinie. Kairaka, ‘Aporo meta Kotimo pusierakano peakosapo airakasuane nere? Aporo metare? Aporo meta perakarihoamo isu kau risikiaere?’ Aíyaka tetápo Yasuaki kaiyinie.” ");
INSERT INTO faa_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Airakano tetā Yasu rea pukua someraka, “Yone he tapukumareramo eto pusierakano perakayiapo. Etapo neaki makata kairakanapo. Asiamo Yonemo someraka, ‘Aporo meta Kotimo pusierakano peakosapo airakasuane nere? Aporo metare? Aporo meta perakarihoamo isu kau risikiaere?’ Aíyaka Yonemo somerakano etapo neaki kaiyako perakayiapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Airakano kaisia maiya amo, aporo hinamo makata tasa yakaiane Yasumo mafasapo. Aporo hinamo yatafumo ho masane Yasumo metakarikia pusiehoane, yatafu purakano aporo hinamo yatafumo ho mosane mafasapo. Aporo hinamo metakira hi fausamo, efera hunia makata koteaka asekeasimo, hi fausane Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Mafaraka risike, Yonemo ipi aporo hakāsa puraki Yasumo someraka, “Re poparipukua, makata asesane soko, makata kaisiane soko, Yoneaki somehoanie. Aporo hinamo hi fausane, mafasa koteaka aserakanapo. Aporo hinamo korake matipusane, maraesa koteaka purakanapo. Aporo hinamo toropakesane, mafasa koteaka risikinapo. Aporo hinamo senaki tisane, mafasa koteaka kairakanapo. Aporo hinamo kusuane, mafarearaka turikia tarikia risikinapo. Aporo hinamo makata forokoa risiaki soko, Kotimo some kaiyanafonosa aporo hinamoaki soko, Kotimo some kotesane nōmo some karakanapo. ");
INSERT INTO faa_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Asiamo aporo hinamomo anoaki himu hakásaraka hemakapurane metakarirafaraka, yaiya hemakapuraka risikino, aporo hinamoane Kotimo makotenapo.” Aíyaka aporo tetá pesaki Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Aíyaka Yasumo somerakano, Yonemo aporo tetá pusiesane tati apea poparipusuapo. Poparipurakano, Yasumo aporo hinamo su sarimasaki someraka, “Yonemo ima yaoa some karakano repo yakapa aseako pusuare? Fofako atifomo mahohoanane aseako pusuare? Wae. Fofako atifomo mahohoanane aseako pusuafapo. ");
INSERT INTO faa_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Repo yakapa aseako pusuare? Aporo kau rakisiane aseako pusuare? Wae. Aporo kau rakisiane makata su siaraka unihaemo apea rerapo. Aporo kau rakikia yaoa rerafapo. ");
INSERT INTO faa_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Repo yakapa aseako pusuare? Porofete aporo aseako pusuare? Ao. Repo porofete aporo kárane asesapo. Asesane wate fana Kotimo sawia porofete aporomo popasane Yonepo. ");
INSERT INTO faa_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Wate fana Kotimo sawia porofete aporo metamo popasane oyapo. Mafasira aporoaki Kotimo someraka, ‘Né pusiraka aporo metamo fana some kakako nōmo pusiehokosapo. Aporoamo né ikia kara pukusane makotehokosapo.’ Aíyaka Kotimo somerakano, porofete aporomo popahoareapo. Aíyaka popahoareane Yoneane popasapo. ");
INSERT INTO faa_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Nōmo some kakasiraka aporo su wainepe pesa amo aporo metamo Yoneane marokesafapo. Arirakano ano peraka some karaka, ‘Koti unihaeaka rekenapo.’ Airakano aporo hinamomo Kotimo someane kakimaka anoa paoraka someraka, ‘Ano wakasemapo,’ aisa aporo hinamoamo Yoneane makamakesekenapo.” ");
INSERT INTO faa_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Aíyaka Yasumo somerakano aporo hinamo suamo soko, aporo takese mora aporoamo soko Yasumo someane kakimasapo. Kakimaka someraka, “Someane kakarorakae. Kotimo hemakapusuane ereketaerareapo. Asiamo Yonemo isu hea tapukumuriane siahoasireapo.” ");
INSERT INTO faa_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Airakano Yonemo aporo hinamo hea tapukumurisia maiya amo, Ferese aporomo soko, Kotimo somemane tisa aporomo soko, ipu someraka, “Isu hea tapukumuriako hisiripo.” Airakano Yonemo iane hea tapukumurisiafapo. Asiamo i hea tapukumurianafonosasamo ipu Kotimo someane koaretaesapo. ");
INSERT INTO faa_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Arirakano Yasumo someraka, “Maiya omo aporo hinamo risiane nōmo mayiáka somehokosare? Nōmo takumeaka somerakanapo. ");
INSERT INTO faa_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Hokosamo hauaka moroa enaraka, namina yia hokosa metakiramo hokosa metakiraki someraka, ‘Isiapo wiroko takiane, repo seseaka paoraka hakāsa kesarakarifapo. Isiapo hiripuhoane, repo soko paoraka hiripurakarifapo,’ aisapo. Asiamo i risia ayiáka, re soko ayiáka risikinapo. ");
INSERT INTO faa_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ayiáka risiamo kepoane oyapo. Yone hea tapukumarerane peraka, makata nakosa farawane soko, waene he soko, sokoairaka nesafapo. Nanafonorakano asekea, repo someraka, ‘Yoneane yatafumo ho mayereapo,’ aisapo. Aíyaka re Yonea paosafapo. ");
INSERT INTO faa_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Arirakano Aporomanomo Táke ano peraka, makata nakosa soko waene he soko nenapo. Nenakano asekea, repo someraka, ‘Yasumo nako fitiraka sapekeamo nenareapo. Waene he soko kára nena reapo. Arirakano aporo takese morane soko, aporo himu watikisane soko ipi tákereapo,’ aíyaka someaka anoa paosafapo. ");
INSERT INTO faa_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Arirakano Kotimo hemakapusuane nōmo kekemaraka somesane, kakimara aporo hinamomo ipu hemakapuraka, ‘Kotimo hemakapusuane ereketaehoareapo,’ aíyaka ipu hemakapukusapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ferese aporomo Yasuaki someraka, “Né nōmo apea makata nako peae,” airakano Yasu pusuapo. Pukua apea makata nakosakipoko asekea kayapo. ");
INSERT INTO faa_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Arirakano ape sumu hakása yia hinamo watikisa hakása kayapo. Hinamoane ipi kake kaiyiane, Ferese aporomo apea Yasu pusuapakano hinamoamo kaikia, he wape yamona petoroa takamaka, apea maka pesapo. Arirakano eke kotesane maka petoro rakisiakipoko, petoro á, he wape yamonane takamaka pesapo. ");
INSERT INTO faa_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Peraka Yasu kayakipoko patera aeyaka pekea hiripusapo. Hiripuraka, hiripu heane Yasu korakea raposapo. Hinamoamo ipi uni itimo Yasu korakea hesane hokeraka, Yasu korakea makanusapo. He wape yamona maka pesane, Yasu korakea resapo. ");
INSERT INTO faa_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Rerakano Yasuane peae, aisa Ferese aporoamo ipi hemakapuraka, “Yasuane porofete aporo satiki hinamoane watikiaka kakeno asekeafunureapo. Porofete aporo rakanafareapo.” Aíyaka ape wafayamo hemakapurakano, ");
INSERT INTO faa_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yasumo asekea someraka, “Saemoneo, néaki nōmo makata somerakanapo.” Airakano Saemonemo someraka, “Ao, Tisa, nómo somesie.” ");
INSERT INTO faa_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Airakano Yasumo takumeaka someraka, “Aporomo aporo tetáki mone fore kasapo. Aporo metaki mone wane harote kina asia (K100) kasapo. Aporo metaki mone tene kina asia (K10) kasapo. ");
INSERT INTO faa_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Karakano, keseke tetapō someraka, ‘Moneane nómo etoaki kasane fasekeno, ropo kakakosafapo.’ Airakano aporo mone kasámo tetāki someraka, ‘Ao, metakarisie. Teto nōmo mone kasane ropo anoaki kakakopo. Nōmo mamerarurakanapo. Ane siareapo.’ Aíyaka aporo mone kasámo somesapo. Asiamo Saemoneo, makata ropo metakarisiasamo, epamo aporo mone kasane kára seseraka hemakapukusare? Aporo mone kára masamo mone kasá wafayane kára seseraka hemakapukusare? Mone wakasema masamo aporo mone kasá wafayane kára seseraka hemakapukusare?” ");
INSERT INTO faa_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Aíyaka Yasumo somerakano Saemonemo someraka, “Aporo mone kára masamo, mone kasá wafayane, kára seseraka hemakapukusapo.” Airakano Yasumo someraka, “Ao, kakarorakae.” ");
INSERT INTO faa_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Aíyaka hinamoane Yasumo aseako kakopariraka Saemoneaki efera hunia someraka, “Hinamoane nómo asesie. Ano nómo apea peane, nómo ano korake kususafapo. Hinamoamo ipi hiripu hemo ano korake kusuane. Kusuraka ipi uni itimo ano korake hokeane. ");
INSERT INTO faa_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ano peane, nómo ano makanusafapo. Hinamoamo hákasa ano korakea makanuraka akaye. ");
INSERT INTO faa_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nómo ano uni itia wera resafapo. Hinamoamo he wape yamonamo ano korakea arere. ");
INSERT INTO faa_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Asiamo hinamoane ipi kára watikiaka kakeno asekea, makata watikisa kárane nōmo mafasapo. Mafasasamo anoaki kára hemaka apure. Arirakano aporo metamo makata watikisa wakasemasane mafarakano, anoaki wakasema hemakapurapo.” ");
INSERT INTO faa_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Aíyaka hinamoaki Yasumo someraka “Né himu watikisane nōmo mafasapo.” ");
INSERT INTO faa_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Airakano aporo metakira teporoa toke namina susu someraka “Aporomano himu watikisa mafana aporoane epare?” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Arirakano hinamoaki Yasumo someraka “Nómo anoaki himu hakásaraka hemaka apura yiamo ne nōmo mafasirakayiapo. Ní koteaka kakako punie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Maiya wakasema farakano, Koti unihaeaka reane, Yasumo aporo hinamo metakiraki some kakako ape meta á pukua, arirakano aporo hinamo metakiraki soko, some kakako pusuapo. Pukua, ape meta á soko pukua, ayiáka some kape pusuapo. Yasumo ipi aporo hakāsa pura kenosuane Yasuyaki hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Arirakano hinamo metakira soko Yasuyaki hakāsa pusuapo. Pusua hinamoane metakira makata tasane Yasumo mafasapo. Hinamo metakirane yatafumo ho masane soko Yasumo mafasapo. Arirakano hinamo i yano taesane oyapo. Makatara hinamo Maria ane, yatafu yatipinusumo ipi ho masane Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Meta, Kúsamo ipi asea Yoánapo. Yoánamo ipi apiamo Herotemo apea makata rakisiapo. Arirakano hinamo meta Susánapo. Hinamoamo soko, hinamo metakiramo soko, Yasuane arareraka eaki mone kasapo. Yasuane soko karaka, ipi aporo hakāsa purane soko kasapo. ");
INSERT INTO faa_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yasu rea á, taone aeyaka aporo hinamo yakai pekea sarimarakano asekea Yasumo takumeaka someraka, ");
INSERT INTO faa_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Aporomo makata mano poterape pusuapo. Poterape pusua maiya amo, makata mano metakira ikia kara á hurupepesapo. Hurupepesane aporomo finiraka finirakosapo. Metakira hurupepesane menamo nesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Arirakano makata mano metakira eke kima á hurupepesane, tanehekea risiane, makata otoa he kesaka rekeanafonosasamo, koteaka taneheanafonoraka kukua kesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Arirakano makata mano metakira keta risiakipoko arakarua hurupepesapo. Hurupepesane makata mano keta risia akiyaki hakāsa tanehesapo. Tanehenaka makata keta risiane popakeraka, makata manoane karotapiraka serekesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Arirakano makata mano metakira hauaka kotesakipoko hurupepesane tanehekea, wate wane harote (100) ayiáka pesapo.” Aíyaka somesa maiya amo Yasumo someraka, “Re senaki risiamo kairaka, koteaka kaisie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yasumo aporo hakāsa puramo eaki someraka, “Takume kepoane yakapare?” ");
INSERT INTO faa_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Airakano Yasumo someraka, “Koti unihaeaka reane mahamesane, repo kaiyisimo some kepoane yumo nōmo reaki hufitaeraka somerakanapo. Arirakano aporo hinamo metakiraki some kepoane nōmo hufitaeraka somehoanafonoraka, takumeaka susu somerakanapo. Asiamo ipu himo aseraka asekea yia, kepoane koteaka hemakapurafapo. Ipu senakimo kairaka kaikia yia, himumo koteaka hemakapurafapo. Asiamo nōmo iaki takumeaka susu somerakanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Arirakano Yasumo ipi aporo hakāsa puraki someraka, “Takume kepoane oyapo. Makata mano asiane Kotimo some ayapo. ");
INSERT INTO faa_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ikia kara á hurupepesa asiane oyapo. Kotimo someane aporomo kaikia hemakapuraka, ‘Kotimo isu mafasiasimosapo.’ Aíyaka hemakapukua, Kotimo someane kakaro kakimakohoamo Satane ipi pekea Kotimo someane hakimarapo. ");
INSERT INTO faa_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Arirakano eke kima á hurupepesa asiane, aporomo Kotimo someane seseraka kaikia, asiane pikinu koteaka punafonona ayiáka, ipu maiya wakasemamo kakimaka risina, keseke i kau aseako mokopipirakano asekea, ipu Kotimo someane metakarirapo. ");
INSERT INTO faa_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Arirakano makata keta risia tanehesakipoko, arakarua makata mano hurupepesa asiane, aporomo Kotimo someane kaikia risikiyia, hauaka wo makata tomekesa hemakapuramo soko, hauaka wo makata kemo mokoako hemakapuramo soko, hauaka wo seseraka hemakapuramo soko, makata isia amo Kotimo someane karotapirapo. Karotapiraka, wate pesane koteaka sunafapo. ");
INSERT INTO faa_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Arirakano hauaka kotesa á hurupepesa asiane, aporomo Kotimo someane senakimo koteaka kaikia, himumo koteaka susu hemakapukua, kakaro kakimaka, himu hakásaraka hemakapuraka risikino, ira wate kara apera ayiáka pekea risikiakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yasumo someraka, “Nafa pakimaka motokoa taramomo karotapirafapo. Nafa pakimaka ape wará pete petaua motorafapo. Aporo metakira ape á yorokoa peraka faeane asekeasimo, nafane pakimaka apea waremarerapo. ");
INSERT INTO faa_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Arirakano makata faremaresane keseke mafekemahokosapo. Arirakano makata mahamesane keseke makakamahokosapo. ");
INSERT INTO faa_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Asiamo someane maíyaka kaikia kakimarakanare? Ayiáka hemakapukua risikianie. Repo someane kaikia kakimarakano, makata meta soko reaki somerakano, repo sia kakimakosapo. Arirakano someane repo kakimakanafonorakano, fana repo makata kaisiane soko meraruhokosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yasumo ipi kaīyia soko, ipi mamanea soko, Yasu aseako pesane, aporo hinamo yakai sarimaraka, ape tapesekeno ape kakarua Yasuane aseako pusuafapo. ");
INSERT INTO faa_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pusifasekeno aporo metamo Yasuaki someraka, “Nómo ní ama soko, ní mae soko né aseako pekea, hauaka moro atura arisie.” ");
INSERT INTO faa_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Airakano Yasumo aporo hinamo sarimasaki someraka, “Kotimo someane kakimaka rakira aporo hinamoane nōmo amapo, nōmo maepo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Sere metamo Yasu soko, ipi aporo hakāsa pura soko, kasua ripaka Yasumo someraka, “He kekea kaya taku ra kasu rokoa purakapo.” Aíyaka kasu rokoa pukua ");
INSERT INTO faa_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","he numua pauraka Yasu ipi wasápo. Wasakipoko, atifo kára peraka kasu tua he wakekeraka kasuane kenepesahopo. ");
INSERT INTO faa_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kenepeakorakano asekea, aporo hakāsa puramo Yasu maturikia someraka, “Unihaeo, Unihaeo, kasu keneperaka isu he nekea kukua keasireapo.” Airakano Yasu turikia pukua atifoaki soko, he kupaki soko someraka, “Farasie,” airakano atifo soko, he kupa soko, faraka he auasapo. ");
INSERT INTO faa_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Auarakano asekea, Yasumo iaki someraka, “Marirakano repo anoaki kakaro himu hakásaraka hemakapurakanafare?” Airakano i namoraka fofaraka, namina susu someraka, “Yasumo someane atifomo soko he kupamo soko kakimaka fáne,” aisapo. Farakano asekea ipu someraka, “Aporoane eparakapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kariri hauaka aeyaka he kekea kaya á ipu kasu rokoa hikia, taku ra Kerasa hauaka á pausapo. ");
INSERT INTO faa_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Á pauraka, kasu yia kita hukumarekea, metakarikia hisiapo. Arirakano ape make tameyia aporo meta yatafumo ipi ho masane reapo. Arirakano Yasu hinaka reke aseane, apea yatafumo aporo ho masamo Yasu sapenako perakano asesapo. Aseane, aporoane maiya káramo pasu osohoanafonoraka reke, apea wakanafonoraka aporo kusua taena kunikia á waká reapo. Maiya káramo aporoane yatafumo ho maka, efera hunia soko ho maka, asiane aporoane aporo metakiramo asekea risike, senemo hokonoa taporaka, korakea soko taporaka, asiane ipi kara wakapuraka seneane mokorutusapo. Mokoruturaka nena yaoa yatafumo e karikia pusuapo. Pusua yao aeyaka e perakano asekea, Yasumo yatafuaki someraka, “Aporo one nómo metakarikia, né pusie.” Airakano aporoamo Yasu asesa maiya yiamo aporoane himura yatafu rekerakano epo sakepamo wáraka, “Yasuo, né namo kakaro Unihae Kotimo hokosapo. Nómo ano mayiakakosare? Nómo anoaki kau terane kakakopo.” ");
INSERT INTO faa_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Airakano Yasumo eaki someraka, “Ne yano motosa epare?” Airakano aporoane yatafu mukisamo e ho masasamo, yatafumo someraka, “Ano yano motosa Mukisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Hauaka watikisa kutu matoa isu pusiehokopo.” ");
INSERT INTO faa_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Airakano aseane saro yakai ūri kakafaea risike makata nenaka risikino asekea someraka, “Nómo isu pusierakane saro tua isu risikiako pusiesie.” Airakano Yasumo someraka, “Ao, ayisie.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Airakano yatafumo aporo ho masane i metakarikia pukua, saro tua risiapo. Saro tua risikirakano, saro su ūri kakafae aeyaka foforaka sosonoraka peraka, he fesere mosakipoko aeyaka eteraka he numua hurupeperaka he nekea kukua kesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kukua kerakano asekea saro asekea risia aporoane teketarikia pukua, aporo taonea risiaki soko, aporo ape kekepoa risiaki soko, makata su ipu asesane somesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Somerakano aporo hinamo suamo makata somesane aseako pesapo. Yasu rea i peraka aseane, yatafumo aporo ho masa mafasane Yasu korake makeraka tameyia kake, koteaka hemakapukua, pasu osoraka kakeno asesapo. Aseraka yia i namosapo. ");
INSERT INTO faa_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Asiamo asekea aporo hinamo i poparipuraka, aporo hinamo metakiraki someraka, “Yatafumo aporo ho masane Yasumo uyáka mafasapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Aisane Kerasa hauaka risia aporo hinamo suamo kaikia ipu namo kakaro namoraka Yasuaki someraka “Isiapo hauakane metakarikia pusie.” Airakano Yasu paripukusakipoko kasua ripasapo. ");
INSERT INTO faa_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Riparakano aporo ho masa mafasa amo someraka, “Ano néyaki hakāsa peakoripo.” Airakano Yasumo someraka, ");
INSERT INTO faa_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wae, né ní apea paripusie. Kotimo né ararerakasane somehoanie.” Airakano aporoane paripukua, ipi apea aporo hinamo suaki someraka, “Yasumo ano uyaka araresapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yasu pariperakarihoamo aporo hinamo yakai sarimaraka kau risiapo. Kau risiakipoko Yasu pariperakano asekea ipu sesésapo. ");
INSERT INTO faa_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Arirakano Yu aporomo sarimana ape asekea rea aporo ipi yano motosa Yairasepo. Epo ipi hinamo hokosa hakása nine kayapo. Masira ane ipi kake keremisi kenosu faraka, ipi makata takamaraka kukuko makerakano asekea, Yairasemo Yasuaki somehoko pesapo. Pekea Yasu korake kekenoyia, kakuna porokoa kake someraka, “Nōmo apea né peae.” Airakano Yasu Yairasemo apea pukusakipoko, puraka reke, aporo hinamo yakai sarimasakipoko, Yasu puraka taperaka kafukua pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Pusua maiya amo hinamo meta iyaki hakāsa pusuapo. Hinamo pusuane keremisi keno sumo wake apea makama yiaraka makata takamasa kayapo. Kaya ane mitikoromo soko sia mafasafapo. ");
INSERT INTO faa_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hinamoane Yasu patera aeyaka pekea, Yasumo pasu kea sakaisapo. Sakaihoane wake ape makama yiaraka kayane wate foakayia fasapo. ");
INSERT INTO faa_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Farakano Yasumo someraka, “Ano sakairakahoane epamo sakairakayiare?” Airakano ipu suamo someraka, “Wae, né isiapo sakairakayiafapo.” Airakano Pitamo someraka, “Aporo hinamo yakaisakipoko ne hisirimaka purakayiapo.” ");
INSERT INTO faa_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Airakano Yasumo someraka, “Ano wakapuane purakarakano kaikia, aporo metamo ano sakairakahoapo.” ");
INSERT INTO faa_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Airakano hinamoamo hemakapuraka, “Yasumo ipi makata su hemakapurapo. Nōmo mahameane siahoasifareapo.” Aíyaka hemakapuraka ipi hamisisiraka, Yasu rea kakuna porokoa kake, aporo hinamo suamo kaiyisimo someraka, “Ano makata takamasane mafahoasimo, Yasumo pasua sakairakayiapo. Sakaihoane ano makata takamasane wate foakayia fasapo.” ");
INSERT INTO faa_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Airakano Yasumo someraka, “Hinamo neo, nómo anoaki himu hakasaraka hemaka apura yiamo, né makata takamasane mafarakayiapo. Né tau koteaka kakako pusie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Aisa maiya amo Yu aporomo sarimana ape asekea rea aporo Yairasemo ape aeyaka aporo meta pekea eaki someraka, “Nómo ní hinamo hokosane kusuapo. Asiasamo Tisaki efera hunia somehokopo.” ");
INSERT INTO faa_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Airakano Yasumo kaikia Yairaseaki someraka, “Namohokopo. Anoaki himu hakásaraka hemakapukua rekeanie. Nómo ní hokosa makata takamasane nōmo mafahokosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Asiamo Yasu pukua apea pauraka aseane, hokosa kusuakipoko ipu kara hihiripuraka risikino asekea, iaki Yasumo someraka, “Hihiripuhokopo. Hokosa ane kusuafapo. Ipi wasápo.” Airakano ipu hokosa kakaro kusikeno asekea, ipu Yasuaki hokomarekea keasapo. Kearakano asekea, Yasumo iaki apea yorokoa peakopo, aisapo. Yasumo ipi aporo hakāsa pura Pita soko, Yone soko, Yamese soko, hokosa wafaya soko, kaīyia soko, hakāsa karikia apea forosoraka ape tua pukua, ");
INSERT INTO faa_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","hokosa kusuane hokonoa maka someraka, “Masira, ne turikia pusie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Airakano ipi hoane ipi kaua paripekea paoraka ipi turikia pusuapo. Turikia purakano asekea, Yasumo someraka, “Hokosaki makata nakosa kasie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Airakano hokosa amo ipi wafayape kaīyia tetā kakaro kara fofasapo. Fofarakano Yasumo tetāki someraka, “Aporo hinamo suaki tetápo makata asesane somehokopo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yasumo ipi aporo kenosumo ipu makata rakirane rakisimo, wakapu kakakosakipoko, iaki peaesapo. Perakano asekea, ipu yatafumo aporo ho masane metakarikia pusiehoasimo iaki wakapu kasapo. Arirakano aporo makata tasane soko mafahoasimo iaki wakapu kasapo. ");
INSERT INTO faa_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wakapu karakano i pukusakipoko, Yasumo iaki someraka, “Aporo hinamo suaki úyaka somehoanie. ‘Kotimo aporo hinamo unihaeaka asekea rekenapo,’ aihoanie. Arirakano aporo hinamo makata tasane soko mafahoanie.” ");
INSERT INTO faa_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Aíyaka Yasumo iaki some meta someraka, “Re kimisi puraka makata mokoa pukupo. Tatia soko, ku soko, makata nakosa soko, mone soko, mokoa pukupo. Pasu tetá mokoa pukupo. Pasu hakása maka puane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Re pukua taonea pauraka, ape wafayamo reane pasimaka ipi apea karikia purakano apea yorokoa, ape á waka risikianie. Waka risike, ape meta mokome wakako pukupo. Waka risia ape aeyaka, taone meta punie. ");
INSERT INTO faa_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Arirakano taone meta peane ape wafayamo re tereraka pasimakanafonorakano, taoneane repo metakarikia puraka, namina hisisane Kotimo asekea sesenafapo. Aíyaka ipu hemakapusimo, yapakeraka korakea kokotonomosane rerakatapikia marekea metakarikia punie.” Aiyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Arirakano i pukua, ape sumu kekepo sua pukua, Yasumo some kotesane some karaka, aporo hinamo makata tasane mafasapo. Ape sumu sua ayiáka rakipe pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Arirakano Yasumo makata wakapuaka rakisiane, Herote Kariri hauaka asekea rea aporomo kaisiapo. Aporo metakiramo someraka, “Yone kusuane maturikia taesapo.” Arirakano aporo metakiramo soko kaikia someraka, “Makata wakapuaka rakisiane, Yone kusuane maturikia taeraka epo wakapuaka rakirakanareapo.” Airakano some ane Herotemo kaikia mahimeteraka reke, kepoane koteaka hemakapusuafapo. ");
INSERT INTO faa_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Arirakano makata wakapuaka rakisiane aporo metakiramo kaikia someraka, “Iraíya pariperakanareapo.” Airakano kaikia aporo metakiramo kaikia someraka, “Wate fana porofete aporo kusuane hakása meta mafarearaka rekenareapo.” Airakano Herotemo kaikia mahimeteraka ");
INSERT INTO faa_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","epo someraka, “Yone mawiane nōmo patekemasie, airakano patekemasapo. Aporomo makata wakapuaka rakisiapakasuane epare? Eane nōmo aseakoripo.” Aíyaka Herotemo hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yasumo ipi tarira aporo popariperaka, ipu makata rakisiane Yasuaki somesapo. Someaka farakano, aporo hinamo suane yia metakarikia, Yasumo ipi aporo hakāsa purane hákasa karikia, Pesaita taonea pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","I pusuapakano aporo hinamo metakira keseke kekemarape pusuapo. I pusuakipoko keseke kekemarape perakano Yasumo asekea peaesapo. Perakano asekea Yasu seseraka reke Kotimo aporo hinamo unihaeaka asekea reane, i suaki somesapo. Aíyaka someaka aporo hinamo metakira makata tasane soko Yasumo mafasapo. ");
INSERT INTO faa_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Samapu maiya tuakeramo, Yasuaki ipi aporo hakāsa puramo someraka, “Aporo hinamo yakai pesane pusie, aisie. Ape sumu fetea soko metao, ima yaoa ape manoa soko metao á pusie, aisie. Asiamo one yao kauanesasamo wo ape rekenafapo. Asiamo namina ape fetea waráka makata nakosa mokoako, namina ape wasá á pusie, aisie.” ");
INSERT INTO faa_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Airakano Yasumo someraka, “Repo iaki makata nakosa kakanie.” Airakano aporo hakāsa puramo someraka, “Isiapo makata nakosane farawa kakoreasu, pokoa tetá ayiáka tokenapo. Makata nakosa meta kakenafapo. Aporo suamo makata nakosane isiapo ropohoko pusimo nómo hemakapurakarire?” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Asiamo aporo ane aseane, fae taosene ane (5,000) risikino asekea, aporo hakāsa puraki Yasumo someraka, “Aporo fifiti (50) kikisiraka taku á toaesie. Aporo fifiti (50) meta kikisiraka taku á toaesie. Su ayiáka tokoasimo somesie.” ");
INSERT INTO faa_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Airakano aporo hakāsa puramo aporo fifitiaki (50) someraka, “Re su toae.” Airakano toapo. ");
INSERT INTO faa_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Su tokeno asekea, farawa kakoreasu pokoa tetá ane Yasumo maka reke, hepene yapura asekea, Kotiaki suseraka kurikuriraka, faraka, mosoraka, aporo hakāsa puraki karaka someraka, “Aporo suane takusie.” ");
INSERT INTO faa_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Airakano ipu takusuapo. Takurakano, aporo hinamo suamo katu nekea, siarakano, farawa momo yia tokeno, mate kenosua kekea komarusuapo. ");
INSERT INTO faa_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Maiya metamo Yasu ipi haku reke, kurikurirakano, aporo hakāsa pura suane pesapo. Perakano Yasumo iaki someraka, “Aporo hinamo suamo anoane epapakasure?” ");
INSERT INTO faa_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Airakano aporo hakāsa puramo someraka, “Aporo metakiramo someraka, ‘Né, Yone he tapukumarerane turikia pureapo.’ Aíyaka somerakasupo. Arirakano aporo metakiramo someraka, ‘Né, Iraíyareapo,’ aíyaka somerakasupo. Arirakano aporo metakiramo someraka, ‘Né, porofete aporo fana kusua hakása meta mafarearaka paripereapo,’ airakasupo.” ");
INSERT INTO faa_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Airakano iaki Yasumo someraka, “Repo hemakapusuane, ano epapaka hemakapurakarire?” Airakano Pitamo someraka, “Kotimo Unihaeaka rekeasimo murikimasa aporo, Keresoane nereapo.” ");
INSERT INTO faa_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Airakano aporo hakāsa puraki Yasumo someraka, “Ano Keresoane, aporo metaki hufitaeraka somehokopo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yasumo ipi aporo hakāsa puraki someraka, “Aporomanomo Tákeane anopo. Keseke ano kau kára teraka himu nakosapo. Yu aporo sisimamo soko, pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, anoane hisiraka anoaki patera tarikia ano kukusimo rukusapo. Rusuane, sere tetá farakano, sere isiamo ano maturikia taehokosapo.” Aíyaka Yasumo iaki some kasapo. ");
INSERT INTO faa_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Arirakano Yasumo aporo hinamo suaki someraka, “Repo ano patera aseakone, ano kukusimo ira matopesa paremareakosane nōmo nī makatiraka apura ayiáka, repo soko maíya suamo repo namina hemakapusuane metakarikia, ira matopesa maka puraka ano finihaoa re soko fini kafo kepe punie. ");
INSERT INTO faa_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Asiamo aporo hinamo hakasa meta hauaka wo areamo hitaferaka rekeakosane hákasa hemakapukua rakiraka rekeno, eane Kotiyaki yaiya rekeakosafapo. Arirakano aporo hinamo hakása metamo someraka, ‘Yasupoko ano kuane soko siahoasireapo.’ Aíyaka kurane hemakapurafaraka rekeno, e ipiane Kotiyaki yaiya rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Arirakano aporo hinamo hakása meta, hauaka kara wo makata kemo suane mokoa sarimaraka reke, Kotiyaki yaiya rerane epo metakarikia rekeno, eane akura maiya amo makata yakapamo e ararehokosare? Wae. Makata metamo e ararehokosane kakenafapo. ");
INSERT INTO faa_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Arirakano aporo hinamo hakása metamo ano metakarikia, arirakano nōmo someane soko metakarikia rekeno, Aporomanomo Táke ano nī pariapera maiya amo, eane soko nōmo metakariakosapo. Ano faesayaki, nōmo Atamo faesayaki, hepene aporo kotesa susuyaki pariapera maiya amo aporo hinamomo ano metakarirakano iane soko nōmo metakariakosapo. ");
INSERT INTO faa_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nōmo reaki kakaro somerakaripo. Re metakira yumo risiane kukusiraka arisia amo, aporo hinamomo Kotiaki himu hakásaraka hemakapukua risiane Kotimo unihaeaka asekea rekeno, i aseakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Sere karisu faraka, Yasumo kurikurihoko ūri terayia hinaka Pita soko, Yone soko, Yamese soko, i karikia ūria hikia kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yasu kurikuriraka rekeno, ipu Yasu kaua aseane Yasu ipi hikumisiane hakuraka reke, arirakano ipi pasu ososane namo kakaro pakaesapo. Pakaesane aseraka i hi kakanosapo. ");
INSERT INTO faa_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Arirakano Mosesepe Iraíya tetā soko faesayaki wate foakayia faserepekea risike, tetapō Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yasumo Kotimo hemakapusuane su rakikia maraka, Yarusarame sitia kukusapo. Asiamo Yasumo hauaka one metakariakosane tetapō Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Somerakano, Pita, Yamese, Yone, i su wakako nekeraka toane, kakaro wakakesapo. Wakakesane turikia tarikia aseane Yasu faesayaki rekeno asesapo. Aseane aporo tetá Yasuyaki hakāsa risikino asesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Aporo tetā ane Yasu metakarikia hiakorakano, Pitamo someraka, “Yasuo, isu isina o pesane kotesapo. Isiapo ape mano isia kiakosapo. Meta nepoko, meta Mosesepoko, meta Iraíyapoko, ayiáka kiakosapo.” Aíyaka Pitamo somesapo. Pitamo nenakamaka mokome somesapo. Koteaka hemakapukua somesafapo. ");
INSERT INTO faa_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pitamo somesa maiya amo, ako peraka iane karotapisiapo. Akomo karotapirakano, Yasumo ipi aporo hakāsa purane namoraka himu fasapo. ");
INSERT INTO faa_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Himu farakano, ako karotapisia arakaru aeyaka memo someraka, “Eane nōmo nī hokosapo. Nōmo murikimaka pusiesane epo. Asiamo epo someane repo kakimakanie.” ");
INSERT INTO faa_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Aíyaka makata someaka faraka Yasu ipi haku yia rekeno asesapo. Asiamo makata asesa maiya amo, Yasumo ipi aporo hakāsa puramo mahamekea somesafapo. ");
INSERT INTO faa_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Mituru fiarakano aporo isia Yasuyaki ūriane metakarikia pusuapo. I peraka, aporo hinamo yakaimo Yasuane sapenako pesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Aporo hinamo yakai arakarua aporo hakasa metamo wáraka, “Tisao, nōmo nī aporo hokosa yatafumo ho masapo. Nōmo nī aporo hokosa meta rekenafapo. Hokosa hakasa nine yatafumo ho masapo. ");
INSERT INTO faa_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yatafumo e ho marakano ipi wáraka wiriraka, mokoweraka, akai momotoroyaki, akai kamusakaeyaki, mokowekea kara mokoatikiraka haru metakarirafapo. ");
INSERT INTO faa_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Asiamo nómo ní aporo hakāsa puraki nōmo someraka, ‘Yatafuane ipi pusiesie.’ Airakano ipu pusiehoane yatafuane pusuafapo. Yaiya rekenapo.” ");
INSERT INTO faa_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Airakano aporo suaki Yasumo someraka, “Aporo hinamo maiya omo arisiamo Kotiaki himu hakásaraka hemakapukua risikirifapo. Maiya suamo repo hasaka hemakapukua risikino, nōmo repoko maiya suamo wafororaka rakiraka rekenapo. Nómo hokosa wo karikia peae.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Asiamo hokosane karikia perakano aseane, yatafumo ho maka hauaka atura rukumakasuraka wareke mokowerakano asesapo. Asekea yatafuaki Yasumo pusiesapo. Airakano yatafu metakarikia pusuapo. Purakano asekea, hokosa mafasane Yasumo maka ipi wafayaki kaka someraka, “Nómo ní hokosapo. Ní masie.” ");
INSERT INTO faa_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Airakano aporo suamo aseraka fofaraka someraka, “Koti ipi kárapo. Ipi wakapu kára rekenapo,” aisapo. Arirakano aporo hinamo su fofaraka risikino, aporo hakāsa puraki Yasumo someraka, ");
INSERT INTO faa_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nōmo some kakakoana one, repo meraruhokopo. Aporomanomo Tákeane anopo. Keseke ano rusua kukusimo aporomo ano parakehokosapo.” ");
INSERT INTO faa_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Airakano ipu kaikia hemakapunafonorakano kepoane Kotimo tarisiafapo. Tarianafonorakano ipu himetesapo. Kepoane hemakapukusakipoko Yasuaki ipu kaiyakosane karekesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Aporo hakāsa puramo namina yia tafatafaraka someraka, “Ano fanapo.” Airakano metamo someraka, “Wae, ano fanapo.” Aíyaka tafatafaraka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ayiáka somerakano ipu hemakapusuane Yasumo asesapo. Asekea hokosa hakása meta eane makeraka rekeasimo, Yasumo ipi karikia pekea someraka, ");
INSERT INTO faa_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","“Aporomo ano hemakapukusakipoko hokosa asíane ararerakanone, anoane soko ararerakanapo. Ano arareraka maseserakanone, ano pusiesa Kotiane soko maseserakanapo. Asiamo aporo meta ipi kesekea rekenone aporoane ipi fananapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yonemo someraka, “Tisao, isiapo aseane aporo metamo né yano hokoa aporo meta yatafumo ho masane pusierakano pusuapo. Purakano asekea, isiapo someraka, ‘Né Yasumo aporo hakāsa purayaki paosafapo. Paohoanafonosasamo yatafu pusiehokopo,’ aisapo.” ");
INSERT INTO faa_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Airakano Yasumo someraka, “Repo aihokopo. Aporo metamo isuyaki weanafonoraka isu ararerakanapo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yasu hepene yapura hiako makeraka rea maiya amo, Yasumo wakapuaka hemakapuraka, “Ano Yarusarame sitia hinakapo.” Aíyaka hemakapukua, hinaka aporo metakiraki Yasumo someraka, ");
INSERT INTO faa_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","“Re fana hikia, Sameria hauaka á, taone meta hikia, ape wakako maropohoko hisie. Hikia ape maroposakipoko ano kesekea peakosapo.” Airakano i ape marepohoko Sameria hauaka á hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Hikia taonea paurakano, Sameria aporomo someraka, “Re Yarusarame sitia hiakosapakae. Re á hiakosakipoko ape wo wayáne siahoasifareapo.” Aíyaka Yu aporoane soko, Yarusarame sitiane soko Sameria aporomo hisisapo. ");
INSERT INTO faa_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Hisirakano asekea Yonepe Yamese tetapō someraka, “Unihaeo. Aporoane hepene aeyaka ira rufimo inaka kukusimo wáhoaere?” ");
INSERT INTO faa_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Airakano Yasu rekeako pariraka tetaki wakapuaka someraka, “Aíyaka somehokopo. Tetápo watikiaka hemaka apure.” ");
INSERT INTO faa_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Aíyaka ipu taoneane metakarikia taone meta á hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Namina ikia kara hisia maiya amo, ikia otoa aporo metamo Yasuaki someraka, “Né taku ra purakano soko, taku ro purakano soko, sapeaka hinakano soko, ano neyaki hakāsa puraka rekeakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Airakano aporoane ipi kau aseakosakipoko Yasumo someraka, “Yákasa ipi hauaka rapia warápo. Mena ipi usi huturua warápo. Ipu ape waráne risikinapo. Arirakano ano Aporomanomo Tákeane anopo. Nōmo ape wará soko uni katane soko rekenafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Aporo metaki Yasumo someraka, “Ano patera asesie.” Airakano aporoamo someraka, “Ano haru peakosafapo. Nōmo nī ata kurakano, hauaka marekea keseke néyaki peakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Aíyaka epo ipi hemakapusuane rakiakosakipoko, Yasumo someane kaisia fasikiraka metakarisiapo. Asiamo Yasumo someraka, “Aporo ano patera asekeanafonosane, e aporo kusua asiapo. Asiamo aporo kusua asiasamo epo ipi aporo kusuane hauaka mareane siahoasireapo. Asiamo ne ano patera aseako hemakapuraka, né pukua, aporo hinamo suaki someraka, ‘Kotimo ipi aporo hinamo suane unihaeaka asekea rekenapo.’ Aíyaka somehoko pusie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Airakano aporo metamo Yasuaki someraka, “Yasuo, ano né patera aseakosapoko asiane, fana amaki soko, ataki soko, papāki soko, maeaki soko, i suaki ayapahoko apea pukusapo. Ayaparaka marekea keseke paripekea néyaki hakāsa pukusapo.” ");
INSERT INTO faa_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Airakano Yasumo someraka, “Aporomo irawae maka kasu táriraka, rokoa puraka, maiya suamo patera takua pariaseane siahoasifareapo. Aporo patera pesa sapea pariaserakanone ane, Kotimo unihaeaka asekea rekeakosafapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Yasumo aporo metakira seweneti tumo (72) ipi someane some kape pusimo i murikimasapo. Murikimaka epo someraka, “Re fana pusie. Taone metakira soko, hauaka metakira soko, re tetá tetákara pusie. Arirakano re fana pusuakipoko ano keseke peakosapo. ");
INSERT INTO faa_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Hao, kaisie. Ira wate sū kárareapo. Asiane ira wate namo tuakosane aporo hukusireapo. Asiamo ira wate susane aporo raipamo tuako pusiehoasimo, hemo wafayaki kurikurihoanie. ");
INSERT INTO faa_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Repo makata rakiako pusie. Reane saro sipi auasa asiapo. Aporo watikisane saro wofe irirasa asia risiakipoko, nōmo re saro sipi auasa asiane pusierakanapo. ");
INSERT INTO faa_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Asiamo re puraka, pausia mone makesane mokoa pukupo. Aku soko, tamaka soko, mokoa pukupo. Re ikia kara apuramo aporo meta sapenenaka e hokono mokoa maíya káramo yia risikiakopo. Nōmo makata rakirane himu hakásaraka hemakapukua rakinie. ");
INSERT INTO faa_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Arirakano re pukua apea pauraka fana úyaka somehoanie. ‘Aporo ape wafaya né tau auaraka rekeasimo Kotimo né ararehokosapo.’ ");
INSERT INTO faa_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Aíyaka somehoane aporo ane tau auaraka rekeanafonorakano asekea, nómo tau auaraka rerane aporo akiyaki rekeakosafapo. Metakarikia, ipi néyaki rekeako paripeakosapo. ");
INSERT INTO faa_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Arirakano ape hakása á waka reke aseane, aporo meromo néaki makata nakosa soko, he soko, karakano asekea nanie. Makata rakira aporomo makata rakisiakipoko, ipi makata ropoane makata nakosa akara ayapo. Ape meta á soko, ape meta á soko, ayiáka mokome pukupo. Ape sumu meta á pukusakipoko né ní ape wasá aeyaka punie. ");
INSERT INTO faa_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Pukua taone meta á pauraka aseane, aporo ape wafayamo né pasimaka tereraka, makata nakosa karakano, makata ane nanie. ");
INSERT INTO faa_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Aporo makata tasa mafahoanie. Mafaraka someraka, ‘Koti unihaeaka reane, reyaki makeraka rekenapo.’ Aihoanie. ");
INSERT INTO faa_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Arirakano né pukua, taone meta á pauhoane, aporo ape wafayamo né tereraka pasimakanafonorakano, né hauaka moroa pukua á reke someraka, ");
INSERT INTO faa_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Repo taone wo kokotonomosane ano korakea pararisiane rerakatapikia marerakanapo. Repo namina hisirakane Kotimo seserakanafapo. Aíyaka repo hemakapusimo kokotonomo rerakatapikia marerakanapo. Asiamo Koti unihaeaka reane nōmo reaki somehoko pesapo. Asiane repo koaretaesasamo ano taone meta purakanapo.’ Aihoanie. ");
INSERT INTO faa_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Hao, kaisie. Hukuarura maiya amo Sotome aporo hinamo iane hukurukusane wakasema kárahokosapo. Asiamo taone meta á repo some kayane aporo hinamomo kakipayaraka risikinone, taoneane hukurukusane namo kakaro kárahokosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Arirakano Yasumo someraka, “Uao, enahoasifareapo. Korasini aporo hinamo reo, Pesaita aporo hinamo reo, repo taonea Kotimo wakapumo hemakapukua rakirane nōmo rakisiapo. Repo aserakayia repo makata watikisane metakarianafonorakano, reane kára fanasihokosapo. Arirakano Taia taonea soko, Saetone taonea soko, Yu aporohoanafonosa taonea risiamo nōmo makata rakirakano ipu asesa satiki, makata watikisane wate fana metakariafunupo. Metakarikia ipu makata watikiaka rakisiasamo i kaiyaraka risike, kaua ororomo paikia pasu pitikini makafirikia arupekea ayiáka tokoafunupo. Ayiáka toke ipu makata watikisane metakarikia risikiako parihoafunupo. Asiane ipu nōmo makata rakisiane aseafareapo. ");
INSERT INTO faa_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Asiamo hukuarura maiya amo Taia aporo hinamo soko, Saetone aporo hinamo soko, wakasema kára hukurukua fanasihokosapo. Arirakano repo aserakayia risikiako parihoanafonosakipoko, reane namo kakaro kára hukurukua fanasihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kapaneame aporo hinamo reo, repo hemakapuraka, ‘Isu hokopukua risikiakoripo.’ Aíyaka hemakapukua, hepene yapurane máfana ayiáka repo namina yano motosa hákasa máfahoko hemaka apure. Asiamo keseke re fanasiraka heao hauaka atura re mokoasuhokosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yasumo aporo seweneti tuaki (72) someraka, “Repo someane aporomo kairakano ane, nōmo someane kairakanapo. Reaki patera tarirakano, ane anoaki soko, patera tarirakanapo. Anoaki patera tarirakano, ano pusiesa aporoaki soko, patera tarirakanapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Aporo seweneti tu (72) pusuane seseaka popariperaka someraka, “Unihaeo, né yano hokoa yatafu pusierakano pusuapo. Isiapo someamo iane hurutapisiapo.” ");
INSERT INTO faa_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Airakano Yasumo iaki someraka “Satane hauaka wo huruperaka yamakere piakaena ayiáka huruperakano nōmo asesapo. ");
INSERT INTO faa_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Hao, kaisie. Nōmo reaki wakapu kára kasapo. Asiamo hesekea repo finihoane rukunesa kukusafapo. Hanutanomo re rukunesa kupeakosafapo. Satanemo wareane repo hurutapiakosapo. Makata hakása metamo soko re mokoatikihokosafapo. ");
INSERT INTO faa_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Repo yatafu pusierakano pusuane wakasema sesehoanie. Arirakano hepene yapura repo yanoane poparaka maresasamo re kakaro kára sesehoanie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Maiya amo Ho Kotesamo Yasuane masesesapo. Maseserakano epo someraka, “Atao, hepene yapura soko, hauaka wo soko, nómo unihaeaka asekea rekenapo. Asiamo aporomo makata su enomasaki nómo makata faremaresane mafekemaraka tarirafapo. Asiane nómo ní hokosa asia aki hákasa nōmo ní makata namo faremaresane mafekemaraka tarirapo. Asiamo neaki suserakanapo. Atao, nómo ní hemakapusua aporo aki tarirapo.” Aíyaka Yasumo kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Arirakano Yasumo someraka, “Makata suamo kepoane nōmo Atamo anoaki tarisiapo. Nōmo hemakapusuane soko, nōmo ainane soko nōmo Atamo ipi hakásamo asekea hemakapurapo. Arirakano nōmo Atamo hemakapusuane soko, epo ainane soko, nōmo nī hákasamo asekea hemakapurapo. Arirakano aporo hinamo metaki nōmo nī tariako hemakapukua, tarirakano, epo Atamo ipi ainane soko, hemakapurane soko, asekea hemakapukusapo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yasumo ipi aporo hakāsa puraki asekea someraka, “Repo namina himo asesasamo, reane seseaka risikianie. ");
INSERT INTO faa_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Repo makata asesane Kotimo some kará porofete aporo yakaimo soko, kamani aporo unihaemo soko, aseakoripo, aisa nine asesafapo. Repo kaisiane ipu kaiyakoripo, aisa nine kaisiafapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Maiya metamo Kotimo somemane kaira aporo Yasu rea peraka, Yasumo hasaka somehoasimo kau aseakosakipoko someraka, “Tisao, ano yaiya rekeakosakipoko makata yakapa rakiakosare?” ");
INSERT INTO faa_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Airakano Yasumo someraka, “Kotimo somemane popasane yakapa popasare? Nómo yakapa menosare?” ");
INSERT INTO faa_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Airakano epo someraka, “Kotiane nómo unihaepo. Unihaeaki nómo himu tumurumo hemakapunie. Nómo homo soko eaki hemakapunie. Nómo wakapumo soko eaki kataka mareanie. Nómo himu hemakapuramo soko eaki hemakapunie. Arirakano nómo níane himu tumurumo hemaka apura ayiáka, nómo ní aporo tákeane soko, ayiáka himu tumurumo hemakapunie.” Aíyaka popahoareapo. ");
INSERT INTO faa_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Airakano Yasumo someraka, “Kakarorakae. Nómo someraka ane kakimaka ayiáka rakirakanone ane, né yaiya rekeakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Airakano aporoamo ipi nine makáraraka sikiraka someraka, “Nōmo aporo tákeane epare?” ");
INSERT INTO faa_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Airakano Yasumo taku meaka someraka, “Aporo hakása meta Yarusarame sitiane metakarikia, Yariko taonea pukusakipoko, ikia kara á puane hakimora aporomo e rusuapo. Rukua motokoa pasu ososane horomaka, kukuko makerakano e metakarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Pusuakipoko aporo rusuane kukurakano wareakipoko, pirisiti aporo ipi nenakamaka meraruamo peraka aseane, aporo rusuane ikia kara fe takua warekano, pirisiti aporoane ipi koaraka ikia kara fe taku aeyaka pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Pirisiti aporo pusuakipoko, Rífai aporo meta, Kotimo apea raiparaka makata rakisia aporoane pekea aseane, aporo rusuane warekeno asekea, ipi asekepayaraka metakarikia koaraka, ikia kara fe taku aeyaka pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Arirakano Rífai aporo pusuakipoko, Sameria aporo kesekea peraka aseane aporo rusua warekeno epo asekea kamenakaraka, ");
INSERT INTO faa_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","aporo rusuane warekeno asekea, wera waene heyaki munamuna asia sarimaraka, aporo rusuane kaua rekemarekea, pasumo taporaka, aporoane maka, epo ipi saro toki matia ripaka marekea ikia kara pusuapo. Pukua ikia kara tipia ape wará reakipoko ape a pukua, ape kakarua yorokoa pusuapo. Pukua aporo rusuane motokoa asekea wasápo. ");
INSERT INTO faa_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Mituru fiarakano Sameria aporoane ipi puraka, ape wafayaki siufa mone hae tetá karaka, someraka, ‘Ano purakanapo. Aporo rusuane nómo asekea rekeanie. Asekea reke nómo epoko makata roposa akipoko ano pariapera maiya amo nōmo ne makata ropo kakakosapo.’ Aíyaka Sameria aporomo somesapo.” ");
INSERT INTO faa_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Aíyaka Yasumo takumeaka someaka faraka, somemane kaira aporoaki someraka, “Aporo rusua amo tákeane epare? Aporo isia pesane epo aporo tákeane epare?” ");
INSERT INTO faa_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Airakano aporoamo someraka, “E araresane ipi aporo tákeane ayapo.” Airakano Yasumo someraka, “Né puraka, aporo ayiáka tákeraka rekeanie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yasu ipi aporo hakāsa purayaki pukua, apea pauraka aseane, hinamo Matamo e tererakano asekea Matamo apea makata nako pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Pukua apea yorokoa, Matamo ipi apu Maria pekea, Yasumo someane kaiyakosakipoko Yasu kayakipoko e korake kekeno maresayia kayapo. ");
INSERT INTO faa_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Kakeno asekea, Matamo himu mahisiraka, ipi makata nakosa kára pairaka reke, makatane hákasa kára hemakapusuapo. Hemakapukua Yasu kayakipoko peraka someraka, “Unihaeo, nōmo nī haku makata nakosa pairakanapo. Nōmo nī hákasa rakirakano, nómo hemakapurakarire? Nōmo apumo ano ararehoko pusiesie.” ");
INSERT INTO faa_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Airakano Yasumo someraka, “Matao, Matao, nómo makata nakosa hákasa akipoko kára hemakapuraka himu mahisinane kárareapo. ");
INSERT INTO faa_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Anakano makata hakása meta, né forokoa akaye. Makata kotesane Mariamo hemaka apure. Makata kotesane etapo eaki matasohoane siahoasifareapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yasu hauaka meta reke ipi kurikuriraka reapo. Kurikuriraka farakano, ipi aporo hakāsa pura hakása metamo someraka, “Unihaeo. Isiapo koteaka kurikurihoko isuaki kurikurinane some kasie. Kurikurinane Yone he tapukumareramo ipi aporo hakāsa puraki some kasesupo. Asia ayiáka nómo soko isuaki some kasie.” ");
INSERT INTO faa_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Airakano Yasumo iaki someraka, “Repo kurikuriraka úyaka kurikurihoanie. Atao, né yano motosa kakaro kára, haku kotesa susuane makama fanahosimoripo. Aporo su himua ne unihaeaka rekeasimo hemakapurakaripo. ");
INSERT INTO faa_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Pipu makata nakosane siaraka nasimo kakanie. Ayiáka sere suamo nómo karáka rekeanie. ");
INSERT INTO faa_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Aporo metamo isuaki mokoatikirakano, isiapo ropo mokoatikinane mafaraka mamerarurakano asekea, isiapo watikisane soko nómo mafaraka mameraruhoanie. Isu kau aseakosane peakohoamo nómo isu asekea rekeanie. Aíyaka kurikurihoanie.” Aíyaka Yasumo iaki kurikurinane some kasapo. ");
INSERT INTO faa_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Asiamo ipi aporo hakāsa puraki Yasumo takumeaka someraka, “Ere tipiamo re hakása meta hikia, ní moremo apea someraka, ");
INSERT INTO faa_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Moreo, nōmo apea aporo kimisi pesapo. Nōmo farawa fareapo. Asiamo nómo farawa isia ano makasie.’ ");
INSERT INTO faa_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Airakano ape wafaya wareke someraka, ‘Ikia koro mapirikia, roko motokoa, ano warekenapo. Nōmo hokosa soko, ano nīyaki hakāsa wakakesapo. Wakakesasamo neaki makata kakako, ano turikia pukua takahisifareapo. Né ní metakarikia pusie.’ Airakano efera hunia soko someraka, ‘Ano makasie.’ Aíyaka efera hunia soko, ‘Ano makasie.’ Aíyaka nómo ní moreaki aufirakano makarápo. ");
INSERT INTO faa_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Titi moresakipoko epo makaráfapo. Aufirakano makarápo. ");
INSERT INTO faa_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Hao, koteaka kaisie. Makosakipoko ní akaimo kaiyinie. Kairakano Kotimo neaki makakosapo. Aseako koanie. Korakano kokoa aseraka makosapo. Ikia koro ropakamakasimo paroparohoanie. Paroparorakano ropakamakosapo. ");
INSERT INTO faa_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Asiamo makata mako akaimo kairakano makosapo. Makata aseako korakano kokoa aseakosapo. Nómo ikia koroa paroparorakano ropakamakosapo. ");
INSERT INTO faa_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Repo aporomano hakasa metamo ní hokosamo someraka, ‘Atao, ano pokoa makasie.’ Airakano nómo ní hokosaki yapakā kakakosare? Wae. Repo hokosaki yapakā kakakosafapo. ");
INSERT INTO faa_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Arirakano nómo ní hokosamo someraka, ‘Ano mena hae makasie.’ Airakano hanutano kakakosare? Wae. Repo hokosaki hanutano kakakosafapo. ");
INSERT INTO faa_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Asiamo né himu watikisa yiamo nómo ní hokosaki makata kotesa karápo. Makata kotesa akara ayiáka, nómo Ata hepene yapura reamo soko makata kakakosane, kakaro kara marokeraka kakakosapo. Nómo eaki Ho Kotesa makasie, airakano epo néaki Ho Kotesa kakakosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aporo yatafumo ho maraka me fasa amo koteaka somehoasimo, Yasumo yatafuaki metakarikia pusierakano pusuapo. Purakano asekea, aporo me fasamo koteaka somesapo. Somerakano aporo hinamo sarimasamo kairaka fofaraka someraka, “Siahoasifasa ane, epo ayiane. E aporo eparakapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Arirakano aporo metakiramo someraka, “Yatafumo unihae yano motosa Piaósipuane Yasuyaki hakāsa rekenareapo. Reasasamo Piaósipumo wakapuamo yatafu pusierakano apure,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Arirakano aporo metakiramo Yasumo rakirane kau aseakosakipoko Yasuaki mokopipiraka somesapo. Ipu someraka, “Kotimo murikimasane nésekenone, nómo rakirane isiapo aseako nómo rakikitakae. Kotimo hepene yapura makata ainane isiapo aseako nómo rakikitakae,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Airakano ipu hemakapusuane Yasumo aseraka someraka, “Aporo namina ape sumu hakása risia, aporoamo namina yia parakuraka weraka, aporoane koaka tarikia, kekepo kekeporaka risike, ape kauanehokosapo. Arirakano aporo ira hakása namina yia parakuraka weraka arupukusapo. ");
INSERT INTO faa_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Aina ayiáka Satanemo yatafuaki ipi táke tati yia awera ayiáka weafunureapo. Satanemo ipi aporo tákeyaki parakuraka wera satiki i arupufunupo. Asiamo repo someraka, ‘Piaósipu anoyaki hakāsa reasasamo, epo ipi wakapumo yatafuaki pusierakano pusuapo,’ airakae. ");
INSERT INTO faa_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Asiamo reane kekemana aporomo yatafu pusiesane, epa iyaki paoraka reare? Epamo wakapumo yatafuaki pusiesare? Nōmo reaki somerakane, repo anoaki paripekea someraka, ‘Kotimo wakapumo pusiesapo,’ aihokosapo. ‘Piaósipumo wakapumo pusiesapo.’ Aíyaka repo some paripeakosafapo. Asiamo kepoane repo hemakapukusakipoko, repo namina kekemana aporomo ainane hemakapunie. ");
INSERT INTO faa_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Arirakano yatafu pusiehoasimo Kotimo wakapu aeyaka nōmo pusierakano yatafu i metakarikia pusuapo. Asiamo Kotimo wakapuane repo asekea hemakapuraka, ‘Isuane Kotimo unihaeaka asekea rekeakosa maiya ane faserepesapo.’ Aíyaka hemakapunie. ");
INSERT INTO faa_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Arirakano aporo waremo ipi makata kemo ape kakarua taeraka, aporo metamo hakimakohoamo tare maka, ira rokopa pokeyaki maka, ikia koroa matasoraka asekea rekeno, epo makata kemoane aporo metamo hakimarafapo. ");
INSERT INTO faa_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Arirakano aporo meta namo kakaro ware yao aeyaka peraka, tati wekea, aporo yao aeyaka pesane ipi namo kakaro waresasamo, aporo ape wafayane marokenapo. Marokeraka aporo ape kakarua rea amo tare, ira rokopa, pokeyaki mahimuraka mokoa reane wasekemokoateraka apea forosoraka, makata kemo taesane soko morapo. Mokoa pukua ipi parakuraka morapo. ");
INSERT INTO faa_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Asiamo ano patera asekeanafonoraka risia aporo hinamo amo, anoaki yunuraka risikinapo. Arirakano anoa paosa aporo hinamo repo, aporo hinamo metakiramo anoaki himu hakásaraka hemakapusimo, repo pasimokoanafonorakanone, ane, aporo hinamo ane repo mapakataerakanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Yasumo someraka, “Yatafumo aporo ho masa metakarikia pukua, hauaka porasakipoko á koraka rerapo. Koraka reke e ape wakakosane soko, e fenekea kakakosa soko, koane fasekeno ipi hemakapuraka, ‘Aporomanomo tura, ape ayiáka waka reane metakarikia pesasamo á rekeako paripurakapo,’ airapo. ");
INSERT INTO faa_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ayiáka paripekea aseane, aporomanomo tura ape ayiáka feaosa makata su makotesekeno aserapo. ");
INSERT INTO faa_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Asekea, ipi yatafu táke yatipinusu pasimorapo. Yatafu yatipinisu pasimosa amo yatafu fana reamo watikiaka rakisiane marokeraka, ipu namo kakaro kára watikiaka rakirapo. Iane pasimokoa pekea aporoamo tura apea yorokoa arisia ayiáka, yorokoa risirapo. Yorokoa arisiamo aporoane namo kakaro watikiaka rerapo. Fana yatafu hakása rea maiya amo, aporoamo watikiaka rakisiane wakasemasapo. Arirakano yatafu kari suane pekea arisiamo, aporoamo watikiaka rakirane, namo kakaro káranapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Arirakano aporo hinamo yakai sarimasa amo, hinamo hakása metamo Yasuaki someraka, “Né ní amamo harepayaki kaina takaperakano, néaki hoko pi kasá hinamoane, Kotimo makoterakano, ipi seseraka kakenapo.” ");
INSERT INTO faa_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Airakano Yasumo someraka, “Kotimo someane kakimara aporo hinamoane Kotimo makoterakano iane seseaka risirapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aporo hinamo yakai pekea sarimarakano asekea Yasumo someraka, “Maiya omo aporo hinamo watikiaka risiamo someraka, ‘Kotimo ne pusierakano pesekenone ane, isiapo aseako Kotimo wakapumo hemakapukua rakirane nómo rakikitakae.’ Airakae. Airakano nōmo rakiakosafapo. Makata hakása meta nōmo tariakosapo. Repo hemakapusimo, Yonaki asia ayiáka ano soko ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Kotimo Yona pusiesane, Ninefa aporo hinamomo hemakapusimo Kotimo Yonaki makata asiane Kotimo iaki tarisiapo. Tarisia ayiáka, Aporomanomo Táke anoane, maiya yumo aporo hinamo arisiaki nōmo tariakosapo. ");
INSERT INTO faa_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Arirakano Soromonemo koteaka hemakapukua somesane hinamo meta unihae Kuinimo kaiyako pesapo. Arirakano hinamo Kuiniane hauaka namo kakaro yameno aeyaka pesapo. Arirakano maiya yumo aporo hinamo ano makeraka risiamo nōmo someane kakipayarakanapo. Asiasamo keseke Kotimo hukuarura maiya amo, aporo hinamo maiya yumo arisiane hinamo Kuini amo hukurukusapo. Arirakano Soromone ipi aporo kára rea nine, re risia titipi á ano reke Soromoneane marokeraka, ano namo kakaro káraraka rekenapo. ");
INSERT INTO faa_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Arirakano Yonamo Kotimo someane some karakano, Ninefa aporo hinamomo namina watikisane metakarikia risikiako parisapo. Namina risikiako parisa nine, aporo hinamo maiya yumo risiamo makata watikisane metakarianafonoraka risikiako parisafapo. Asiasamo keseke Kotimo hukuarura maiya amo, Ninefa aporo hinamomo, aporo hinamo maiya yumo risiaki hukurukusapo. Repo makata watikisane metakarianafonosakipoko ipu reane hukurukusapo. Arirakano Yona ane ipi Kotimo some kará aporopo. Asiane re risia titipi á, ano reke Yona ane marokeraka rekenapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yasumo takumeaka someraka, “Aporomo nafa pakimaka hauaka rasa kutua motorafapo. Arirakano taramomo karotapirafapo. Nafa pakimaka apea waremaresa faerakano, aporo hinamo metakira pekea apea yororaka aseane, nafamo faerakano aserapo. ");
INSERT INTO faa_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Né kaumo nafa asia ane né hipo. Nómo himo makata su koteaka asekea takékea, ne kauane faeraka rekeakosapo. Asiane né hi meraka reke, né kauane soko katoraka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Asiamo nómo faesane kopakapurapaka asekeanie. ");
INSERT INTO faa_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Né katoraka rekeanafonoraka, né faesa susu reke nafa faena ayiáka né kára faeraka rekeakosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Some kasá maiya amo, Ferese aporo metamo Yasuaki someraka, “Nōmo apea makata nako peae.” Airakano Yasu pukua apea yorokoa teporo makeraka á kayapo. ");
INSERT INTO faa_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Á kake makata nakosakipoko ipi hokono kusuhoanafonorakano, Ferese aporomo aseraka fofaraka hemakapuraka, “Epo ane marirakanarakapo. Isiapo Ferese aporomo somemaneane epo ipi kekemarakarifapo.” ");
INSERT INTO faa_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Aíyaka hemakapurakano Yasumo someraka, “Ferese aporo reo, repo kapo soko meraki soko kima takuane hákasa kusuna ayiáka, re soko ayiáka risikinapo. Repo kauane hákasa siaraka risikiako ayiane re himua makata watikisa komarukua arisie. Repo aporo hinamo makata forosane asekepayaraka, namina yia makata kára mokoako hemakapukua risike, arirakano aporo hinamoane mokoatikihoko hemaka apure. ");
INSERT INTO faa_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Re aporo masuasa ayireapo. Kotimo re kauane soko rakikia re himuane soko rakisiapo. Asiamo Kotimo re himuane asekea repo koteaka hemakapunafonoraka, aporomo re kau hákasa ane asekeasimo repo ayiane. ");
INSERT INTO faa_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Asiamo repo makata kemo kára tokenone, aporo hinamo makata forokoa risiane arareraka yaku kakanie. Ayiáka karakano re Ferese aporomo hemakapuraka, ‘Isiapo merakiane kima takuane soko tu takuane soko kusurakanapo,’ aíyaka repo hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Asiamo Ferese aporo re asekeanie. Uao, enahoasifareapo. Repo hemo makata nena sereto asia kaeyakosu mosane, tokonasu namina moraka, kaeyako hákasane Kotiaki yaku karápo. Karaka yia, aporo hinamoaki koteaka takekea hemakapunie, aíyaka somemane motosane repo hemakapurafapo. Arirakano Kotiaki repo himu tumurumo hemakapunie, aíyaka somemane motosane repo hemakapurakarifapo. Asiamo makata kaeyako hákasane Kotiaki kakanie, aíyaka somemane motosane ayiáka kekemaraka reke, somemane metakirane soko, kekemaraka rakiraka risikianie. Somemane metakirane metakariakopo. ");
INSERT INTO faa_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Asiamo Ferese aporo re asekeanie. Uao, enahoasifareapo. Yu aporomo sarimana apea re pukua aporo hinamo su sarimaraka toakipoko, i hikumisi neneme sapea, sea a re tokoako sesenapo. Arirakano aporo hinamo makata ropona apea sarimaraka risiakipoko, re purakano aporomo re hokono mokoasimo repo sesenapo. ");
INSERT INTO faa_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Asiamo aíyaka rakira aporo re asekeanie. Uao, enahoasifareapo. Reane aporo kusua hauaka maresa asiapo. Aporo kusua hauaka maresakipoko, asane tanehekea, hauaka maresane mosekeraka, nena hauaka parisakipoko aporo metamo asekeanafonosamo, meraruamo peraka aporo kusua hauaka maresa kima, finiraka purapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Aíyaka Yasumo somerakano, Kotimo somemane tisa aporo hakása metamo someraka, “Tisao, nómo somerakane nómo isu soko makaiyaraka hukurukua somerakae.” ");
INSERT INTO faa_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Airakano Yasumo someraka, “Kotimo somemane tisa aporo re asekeanie. Uao, enahoasifareapo. Aporo metakiramo makata fato umisa asiane makatihoasimo, repo iaki makatiraka marerapo. Makatiraka marekea repo iane wakasema soko ararenafapo. ");
INSERT INTO faa_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Asiamo aporo reo, uao, enahoasifareapo. Kotimo some kará porofete aporoane repo makasa kaua kekemamo rusua kusuapo. Rusua kurakano kunikia motosane repo makoteane. ");
INSERT INTO faa_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Asiamo repo makata arakiramo repo makasa kaua kekemamo rakisiane repo kekemaraka arakire. Repo makasa kaua kekemamo rusua kusuasamo, repo seseraka kunikia motosane makoteraka arakire. ");
INSERT INTO faa_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Asiamo Kotimo koteaka hemakapukua sawia popasane oyapo. Kotimo someraka, ‘Repo kaiyisimo nōmo porofete aporo soko, tarira aporo soko, pusiehokosapo. Perakano asekea, i metakirane repo rusua kukusapo. I metakirane repo mokoatikihokosapo,’ aíyaka popahoareapo. ");
INSERT INTO faa_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Asiamo hauaka one kepomaresa maiya amo, porofete aporo rusua kurane kepomarekea, rupe pekea pipu maiya wo pauraka, aporo hinamo risiane Kotimo hukurukusapo. Hukuarura maiya amo ipu umisane makosapo. ");
INSERT INTO faa_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Fana Aepo rusua kusuapo. Rusua kusuakipoko, amo patera aporo metakira soko rusua kusuapo. Aiyipe pekea kesekea Sekaráya Kotimo apea rusua kusuapo. Eke karoraka taesane makama taku raraka, Kotipoko ape rumu kikisisane makama taku roraka, Sekaráya tipia reane e rusua kusuapo. Rusua kusuasamo, pipu maiya omo aporo hinamo risiane Kotimo hukurukusapo. ");
INSERT INTO faa_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Asiamo Kotimo somemane tisa aporo re asekeanie. Uao, enahoasifareapo. Aporo hinamomo makata koteaka kaikia hemakapusimo, ape ikia koro repo kimo ropakamasafapo. Repo soko makata koteaka kaikia hemakapuko, ape kakarua yorosafapo. Aporo metakiramo soko makata kaiyako ape kakarua yoroako perakano, repo matasosapo.” Aíyaka Yasumo apeane takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Aíyaka Yasumo someaka faraka Ferese aporomo apeane metakarikia purakano, Kotimo somemane tisa aporomo soko, Ferese aporomo soko ipu Yasuaki makata kotafe topakamaraka saperaka somesapo. Epo akaimo hasaka somerakarihoamo eaki some meta somerakano, some meta somerakano asiapo. ");
INSERT INTO faa_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ipu Yasuane mahoperaka asekehaesapo. Makata kakayia kakinumo rusimo amarera ayiáka, ipu makata somehoramo kakinu amarera asiapo. Yasumo hasaka some pariperakano, e hukurukusakipoko, epo makata somerane ipu kaikia asekehaesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Aporo hinamo taosene yakai sarimasakipoko hauaka taperaka, aporo hinamo kafukua puraka meta korakea meta korake takerupe pusuapo. Maiya amo Yasumo ipi aporo hakāsa puraki someraka, “Ferese aporomo ainane, makata pirira asiapo. Ipu himu tetáraka hemakapusuane repo mokoakohoamo asekeanie. ");
INSERT INTO faa_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Arirakano makata faremaresane mafekemahokosapo. Makata mahamesane makakamaraka tariakosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Re katosa á risike repo somesane, keseke faesa á risike repo somerakano aporo suamo kaiyakosapo. Re namina hakāsa sarimaraka ape sapea risike, makata tau mahamekea somesane yaiya mahamekea rekeakosafapo. Keseke aporo suamo kaiyisimo, hufitaeraka sakepamo wáraka somehokosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Arirakano Yasumo some meta someraka, “Maeo, reaki nōmo kakaro somerakaripo. Aporomo né kau kukusimo rurakano aporoaki namohokopo. Aporoamo nómo hoane rukusafapo. ");
INSERT INTO faa_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Asiamo né rusua kurakano né hoane heao hauaka á pusie, aihokosa Kotiaki namohoanie. Nōmo kakaro somerakaripo. Kotiaki namohoanie. Repo hemakapusimo nōmo reaki kakaro somerakaripo. ");
INSERT INTO faa_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Arirakano maketea mena muri asia aporomo roponapo. Roporaka mena muri asiane kakoreasu mone hae kusua tetámo (2 toea) roponapo. Mena muri asia hakása soko Kotimo merarunafapo. ");
INSERT INTO faa_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mena muri wakasemane Kotimo asekea rerasasamo, re aporomanoane, Kotimo namo kakaro kára hemakapukua asekea rekenapo. Asekea reke re uni iti suane epo hakása hakásaka menoraka hemakapukua fasapo. Asiasamo re namohokopo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Arirakano Yasumo someraka, “Aporo suamo kaiyisimo aporo metamo someraka, ‘Ano Yasu patera aserakanapo.’ Aíyaka somerakano Kotimo hepene aporomo kaiyisimo, Aporomanomo Tákemo someraka, ‘Ano patera asesa aporoane epo,’ aihokosapo. Aporomanomo Tákeane anopo. ");
INSERT INTO faa_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Arirakano aporo suamo kaiyisimo, aporo metamo someraka, ‘Ano Yasu patera aseako hisiripo. Nōmo Yasuane metakarirakanapo.’ Aíyaka somerakano, aporoane Kotimo hepene aporomo kaiyisimo nōmo someraka, ‘Aporoane ano patera asesafapo. Ano patera asekeanafonosasamo e nōmo metakarirakanapo,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Arirakano Aporomanomo Tákeane anopo. Anoaki aporo hinamo metamo mawakasemarakano, epo watikiaka somesane Kotimo mafahoasireapo. Arirakano Ho Kotesamo wakapuane, aporo hinamo metamo asekea someraka, ‘Ane Satanemo wakapureapo.’ Aíyaka Ho Kotesane hokomaka mawakasemarakano, Kotimo epo makata watikisane mafahokosafapo. ");
INSERT INTO faa_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Arirakano re waseremaka Yu aporomo sarimana apea hukuruko karikia apura maiya amo, hukurura aporomo soko, aporo unihaemo soko, re hukururakano, repo hemakapuraka, ‘Isiapo maiyaka meakataeraka somehoanarakapo. Maiyaka some paripunarakapo.’ Aiyaka hemakapukupo. ");
INSERT INTO faa_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Asiamo hukuarura maiya yiamo, repo koteaka somehoasimo, Ho Kotesamo reaki some kakakosapo,” aiyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Aporo yakai sarimasakipoko aporo hakása metamo Yasuaki someraka, “Tisao, nōmo nī ata kusuakipoko, nōmo maemo makata kemo parakuraka ano kakanie, aihoanie.” ");
INSERT INTO faa_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Airakano Yasumo someraka, “Makata hukurukua maroponane nōmenafapo. Makata kemo parakunane nōmenafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Aíyaka aporo suaki Yasumo someraka, “Repo someraka, ‘Ano makasie. Makasie.’ Aíyaka someraka kára sakepamo mokoaripi airapaka asekeanie. Asiamo makata kemo káramo ne hitaferaka rerane kakakosafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Aíyaka Yasumo efera hunia yapakeaka someraka, “Aporomo makata kemo kára moraka reapo. Ipi hauaka á koáne mano kosapo. Kosane káraraka tanehekea namo nakosane kikísekeno tusuapo. ");
INSERT INTO faa_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Turakano asekea aporoamo hemakapuraka, ‘Koáne nakosane kára tusuapo. Arirakano koáne tusuane ape wakasemasamo taehoane siahoasifareapo. ");
INSERT INTO faa_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ape kisiane wakasemasekeno nōmo kotahokosapo. Kotaraka ape kára meta kiakosapo. Ape kára ane kikimaka, koáne nako tusuane ape kawea taehokosapo. Nōmo makata kemo soko, su apea taehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Apea makata kemo taesakipoko, nōmo nī yiamo úyaka hemakapukusapo. Nōmo makata kemo sia taesapo. Keremisi kára farakano makata nakosa soko, makata kemo soko, fahokosafapo. Asiamo yumo ano fenekea makata rakiakosafapo. Ano fenekea reke, makata nakosa soko waene he soko nekea, ayiáka maiya suamo seseaka rekeakosapo. Aíyaka nōmo hemakapukusapo.’ ");
INSERT INTO faa_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Aíyaka aporoamo hemakapurakano eaki Kotimo someraka, ‘Né masuasamo hemakapura ayireapo. Nómo himu koteaka hemakapurane fareapo. Asiamo pipu ereamo ne kukusapo. Nómo makata kemo umuraka taesane epamo mokoakosare? Nómo ní mokoa pukusafapo.’ Aíyaka Kotimo somesapo.” ");
INSERT INTO faa_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Aíyaka yapake some kepoane Yasumo someraka, “Aporo hinamomo namina makata kemoane hákasa kara hemakapukua, makata kemo kára sarimaraka, mahimuraka taerakano, Kotimo asekea someraka, ‘Hepene yapura makata ainane hemakapunafonorakano, né forokoa rekenapo.’ aihokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yasumo ipi aporo hakāsa puraki someraka, “Né hitaferaka rekeako, hauaka wo makata nakosa hákasa akipoko, kára himu nekea hemakapukupo. Patera yase risirapaka pasu osohokosane, kára himu nekea hemakapukupo. ");
INSERT INTO faa_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Hitaferaka areamo makata nena hákasa ayare? Kaua pasu osohokosa hákasa ayare? Wae, hákasa ayafapo. Kotimo néaki himuha kasasamo, makata nakosane soko néaki kakasifareare? Ao. Epo sia kakakosapo. Néaki kau kasasamo kaua pasu osohokosane soko néaki kakasifareare? Ao, sia kakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Mena ane asekeanie. Menamo ipi makata nakosane pororafapo. Ira wate susekeno menamo tukua mokoa pukua apea keseke nakosakipoko taenafapo. Taehoanafonosa nine menane Kotimo makata nakosa karápo. Menaki karásasamo, aporomanoane epo sia kakasifareare? Ao, aporomanoane ipi kára hemakapukua makata nakosane karápo. ");
INSERT INTO faa_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Arirakano aporomanomo ipi himumo hemakapuraka, ‘Ano kukusane hisiripo.’ Aíyaka himu nekea rekeno, e kukusa sere motosane marokehokosare? Wae, marokehokosafapo. ");
INSERT INTO faa_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kukusa sere motosane marokehoanafonorakano yia, marirakano makata meta akipoko kara himu nekea risikinare? ");
INSERT INTO faa_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Repo sako wemeane hemakapunie. Sako wemeane taneheakosakipoko sako wememo namina yia makata rakirare? Wae, makata rakirafapo. Sako weme wate suhoasimo sako wememo pasu susane maka irinare? Wae, sako wememo ipi hemakapukua wateane sunapo. Arirakano wate fana Soromone aporo kára unihaeaka reke, ipi pasu kotesa ososapo. Soromonemo pasu ososana kotesa, asiane sako weme wateane namo kakaro kára kotesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Arirakano asane tanehekea arisiane, Kotimo makoteraka wate peasimo karápo. Karakano asane pipu tanehekea arisiane, keseke maiya wakasemamo iramo paiyiane inaka fanapo. Inaka faraka kukua kesane maiya wakasemamo tanehekea risirapo. Maiya wakasemamo tanehekea risia nine Kotimo asekea rerapo. Kotimo asekea area ayiáka nómo pasuane osohokosane Kotimo ipi ayiáka asekea rekenapo. Kotimo ne asekea rekeno yia nómo akipoko himu kara nekea rekenone, ane, nómo Kotiaki himu hakásaraka hemakapurane wakasemareapo. ");
INSERT INTO faa_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Asiamo Kotimo reane asekea reasasamo uyaka hemakapukupo. Makata nakosa mane nakosare? He mane nakosare? Aíyaka himu nekea kára hemakapukupo. ");
INSERT INTO faa_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Arirakano nena aporo hinamo hauaka sua risiamo maiya suamo makata nakosane soko, pasuane soko, kára himu tumurumo hemakapurapo. Asiamo makata nakosane soko, pasu osohokosane soko, makata su re fasane, repo sia mokoasimo repo Ata Kotimo ipi hemakapukua rekenapo. ");
INSERT INTO faa_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Asiamo Kotimo re unihaeaka asekea rekeakosane, makama fanaraka hemakapunie. Aíyaka hemakapukua risikinone, makata nakosane soko, pasuane soko, siaraka mokoakosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Aporo hinamo reane saro sipi mano sarimasa asiapo. Re himu fahokopo. Kotimo re asekea rekeako epo kára seserakanapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Yasumo someraka, “Repo makata kemoane roporaka mone mosane aporo makata forosaki kakanie. Pausi kaweane maka hepene yapura mahimuna makatane pausi tua keasimo ayiakanie. A mahimuna makata taesane paténafapo. Metamo hakimorafapo. Arirakano surisurimo soko nenafapo. ");
INSERT INTO faa_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Asiamo hauaka kara wo repo mahimuna makatane toasasamo, repo himu hemakapurane soko, hauaka wo kakenapo. Arirakano repo hepene yapura mahimuna makatane taesekeno, repo himu hemakapurane soko, hepene yapura kakenapo,” aiyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Arirakano Yasumo someraka, “Aporo raipamo rakikia maresa wafayamo hinamo fitu karáka hokono keakosakipoko pusuapo. Pusuane ereamo pariperapaka foaka ikia koro ropakamako ipi aporo raipamo pasu korake yatipinu atura faisa pusifasekeno, pasu kakuna fairaka kenare weraka, saro kau terakae hikia, arirakano nafa pakimaka asekea risirapo. Asekea risira ayiáka, re soko ayiáka asekea risikianie. ");
INSERT INTO faa_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Arirakano hokono kekea faraka, aporo raipamo ipi wafayane peraka ikia koroa paroparorakano, aporo raipamo ikia koro foakayia ropakamarapo. Foaka ropaka amara ayiáka, repo soko ayiáka ropakamako hemakapukua risikianie. ");
INSERT INTO faa_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Aporo raipamo ipi wafaya pariapera maiya amo aseane, aporo raipa wakanafonoraka turikia tarikia makata rakiraka risikino aserapo. Anakano aporo raipa ane seseaka risikiakosapo. Asiamo nōmo reaki kakaro somerakaripo. Aporo raipamo ipi wafayamo aseane aporo raipa asekea risikino asekea someraka, ‘Re teporo makeraka toae. Re makata nakosa nōmo nī kakakosapo.’ Aíyaka ipi pasu kenare weraka saro kau terakae hikia ayiáka reke, iaki makata nakosa kakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Anakano ere titipiamo soko, mena me horamo soko, aporo raipamo wafaya pariperapaka, aporo raipane waráfaraka asekea risiakipoko, aporo raipamo wafayane pariperakano aporo raipamo sesehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Asiamo some one hemakapunie. Makata hakimora aporomo aporo metamo apea makata kemo hakimokoako perapo. Makata kemo hakimokoako peakosane maiya hi awane ape wafayamo hemakapusua satiki ipi turikipukua asekea rekeafunupo. Ipi apea aporo metamo makata hakimako perakano asekea ipi matasohoafunupo. ");
INSERT INTO faa_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Asiamo re soko rereraka maroporaka asekea risikianie. Aporomanomo Tákeane anopo. Ano paripeakosa maiya hi awane soko repo hemakapunafonoraka, re meraruamo risiakipoko ano paripeakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Airakano Pitamo Yasuaki someraka, “Unihaeo, takumeane isuaki hakasa somerakanare? Aporo suaki soko somerakanare?” ");
INSERT INTO faa_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Airakano Yasumo someraka, “Aporo raipa metamo ipi wafayaki himu hakásaraka hemakapukua reke, ipi wafayamo someane kaikia, koteaka hemakapukua rakira aporoaki nōmo somerakanapo. ");
INSERT INTO faa_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Aporo raipamo ipi wafaya fore hinaka, ipi aporo raipaki makata rakisimo kasane, rakiraka risiakipoko, ipi wafayane pariperakano, aporo raipa ane sesehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Asiamo aporo raipa kotesaki, ipi wafayamo someraka, ‘Nōmo hauaka soko, ape soko, makata kemo suane, nómo asekea rekeanie,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Arirakano aporo raipa metamo hemakapuraka, ‘Ano asekea rera aporo hisiane haru paripeakosafapo.’ Aíyaka hemakapukua epo aporo raipa metakirane soko rukua, hinamo raipa metakirane soko rukua, arirakano makata nakosane hákasa nekea, he watikisa nekea, himu maparitaeraka ayiáka reke, ");
INSERT INTO faa_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","e ipi asekea rea wafaya paripeakosa sereane soko, maiya hi awane soko, hemakapunafonoraka meraruamo reakipoko, e ipi asekea rea wafayane paripeakosapo. Pari apera maiya amo aporo raipaki saperaka e fanasiraka, koaretaena aporo hinamo akiyaki rekeako pusie, aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Arirakano aporo raipamo ipi wafayamo hemakapusuane aseraka tiki asesaneo, epo ipi hemakapusuane kekemaraka rakianafonoraka risikinone, aporo raipane hukurukua kára rukusapo. ");
INSERT INTO faa_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Arirakano aporo raipa metamo ipi wafayamo hemakapusua ayiáka hemakapunafonoraka watikiaka rakirakano, eane hukurukua rufunupo. Rufunusa nine e himeteraka watikiaka rakisiasamo wakasema rukusapo. Asiamo aporo raipa metamo makata kára rakisimo kasaki ipi siaraka koteaka rakisiarihoamo ipi wafayamo aseako peakosapo. Asiamo aporo yakaimo aporo hakásaki makata kara rakisimo karakano, keseke ipi kasane rakisiarihoamo epo ipi aseako peakosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yasumo someraka, “Hauaka wo ira paiyakosakipoko ano pesapo. Ira rufihoasimo pairakano ane, kotehoasireapo. ");
INSERT INTO faa_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Arirakano ano kukusimo ira matopesa paremarerakano, kukusane Kotimo maresapo. Kukusa maiya ane haru faserepeanafonorakano ano himu nekea rekenapo. ");
INSERT INTO faa_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Arirakano repo hemakapuraka, ‘Yasu pesasamo hauaka wo aporo su tákeraka tau auaraka risikiakosapo.’ Aíyaka hemakapukupo. Ano wo pesasamo aporo hinamo repo namina yia fasikia risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pipu kepomarekea pukua, keseke soko, ape hakása á aporo hinamo kakoreasu risiane namina yia parakuraka, aporo hinamo isiamo aporo hinamo tetáki namina yia rakumarekea risikiakosapo. Aporo hinamo tetámo aporo hinamo isiaki namina yia rakumarekea risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Aina ayiáka aporo hokosamo ipi wafayaki rakumarekea, arirakano wafayamo ipi hokosaki rakumarekea risiakosapo. Arirakano kaīyiamo ipi farayaki rakumarekea, arirakano farayamo ipi kaīyiaki rakumarekea risikiakosapo. Arirakano hinamomo ipi hokosamo aseaki rakumarekea, arirakano hinamomo ipi apiamo kaīyiaki rakumarekea ayiáka risikiakosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yasumo aporo hinamo su sarimasaki someraka, “Maiya apura taku á repo ti yapura ti pakae aseraka, repo someraka, ‘Ti pakaeane fahokoane farakano, ane yao peasireapo,’ airapo. Aíyaka hemakapukua somesane yao perapo. ");
INSERT INTO faa_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Arirakano ketayia taku aeyaka atifo kára perakano repo someraka, ‘Pipu yao peasifareapo.’ Airakano kakaro yaiya yao perafapo. ");
INSERT INTO faa_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Asiamo re aporo himu tetáraka hemakapusuane, repo hauaka wo makata ainane soko, ti yapura makata ainane soko, asekea hemakapurapo. Asiāne maiya omo makata ayiakakosane, repo ayiáka hemakapurakarifapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Arirakano Yasumo ipi some meta someraka, “Repo makata kotesane takekea hemakapufununine marirakanosare? ");
INSERT INTO faa_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Anakano aporo metamo né hukuruko, hukurura some kepo kaira aporo rea karikia purakano, titi ikia kara puraka risike, sapesane titi maroporaka mafahoanie. Mafahoanafonorakanone, epo né hukuruko, hukurura some kepo kaira aporo rea karikia pukua, aporoamo ne kotoraka hukurukusapo. Yasemo né hukurukua aporo terakaiyamosayaki pusierakano aporo terakaiyamosamo né tipura makeakosapo. ");
INSERT INTO faa_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Né tipura makerakano haru tonotaehokosafapo. Nómo api kakanafonorakano haru tonotaehokosafapo. Api suane karakano né tonotaehokosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Maiya metamo aporo metakira pekea Yasuaki someraka, “Kariri aporomo saro sipi rukua paikia Kotiaki yaku karaka risiakipoko kamani aporo unihae Pairatemo ipi aporo terakaiyamosaki someraka, ‘Aporoamo saro sipi rukua paikia Kotiaki yaku akarane rusua kukunie.’ Airakano aporoane rusua kurakano ipu yapiane makata kakayia yapi akiyaki sarimaraka suasuasapo.” Aíyaka aporo metakiramo Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Somerakano Yasumo iaki someraka, “Kariri aporoane namina himu watikisakipoko rusua kusuare? Arirakano Kariri aporo metakira himu kotesakipoko yia metakarisiare? ");
INSERT INTO faa_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wae, aporo hinamo su himu watikisa susupo. Repo soko makata watikisane metakarianafonorakano i mokoatikisa ayiáka re soko ayiáka mokoatikihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Arirakano Siroame huturu ape rakaripuraka aporo terayiasu (18) rusua kusuapo. Namina himu watikisakipoko rusua kusuare? Yarusarame aporo metakira himu kotesakipoko metakarisiare? ");
INSERT INTO faa_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wae, aporo su himu watikisa susupo. Repo makata watikisane metakarianafonorakano, i kusua ayiáka, re soko su ayiáka kukusapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yasumo iaki takumeaka someraka, “Hemo wafayamo sako karepe hemoa ira foke maposa reapo. Reane keseke hemo wafayamo ira foke wateane pesarihoamo tumako peane, ira foke wate peanafonosekeno asekea ipi hemo asekea rea ");
INSERT INTO faa_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","aporo raipaki someraka, ‘Ira fokeane tokorasie. Keremisi isia faraka nōmo aseako peane wate peafareapo. Asiasamo ira fokeane tokorasie. Hauaka kotesakipoko ira wate peanafononane hauaka kotesa a ira foke nena reke siahoasifareapo.’ ");
INSERT INTO faa_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Airakano hemo asekea rea aporo raipamo someraka, ‘Aporo fanao, harufapo. Keremisi hakásamo ira kepoa hauaka mosoraka taeraka, asane soko taehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Asane taeraka asekea nina ira wate peanafonorakano tokorasie, aihoanie. Ira wate perakano tokohokopo, aihoanie.’ Aíyaka hemo asekea rea aporo raipamo somesapo.” Aíyaka Yasumo taku meaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Fenena maiya metamo Yasu Yu aporomo sarimana apea pukua some kasapo. Some karaka reke aseane ");
INSERT INTO faa_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","yatafumo hinamo meta ho masa keremisi terayiasumo (18) makata takamaka kayane asesapo. Ipi mati roporaka purafapo. Maiya suamo arupekea susu koraka rerapo. ");
INSERT INTO faa_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Arirakano Yasumo someraka, “Hinamo neo, né nōmo mafarakanapo.” ");
INSERT INTO faa_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Aíyaka hinamoane Yasumo sakaihoane foakayia ipi makata takamasane faraka matiane ropōraka takahisiapo. Takahikia hinamoamo Kotiaki kekeresapo. ");
INSERT INTO faa_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Arirakano fenena maiya amo hinamo makata takamasane Yasumo mafarakano asekea, Yu aporomo sarimana ape asekea rea aporomo saperaka aporo hinamo suaki someraka, “Makata rakira maiyane sere namasu ayapo. Sere namasuane makata rakira maiyasasamo, aporo hinamo re makata tasa mafahoasimo peanie. Fenena maiya amo aporo hinamo re makata tasane mafahoasimo peakopo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Airakano Yasumo someraka, “Re himu tetáraka hemaka apure. Repo saro ponomakau soko metao, saro toki soko metao, apea kita hukumaresane fenena maiyamo, he nasimo, kita fitikimaka karikia purapo. ");
INSERT INTO faa_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Hinamoane Eparahamemo aporo irapo. Satanemo hinamo ane keremisi terayia sumo (18) asekea reareapo. Pipu fenena maiyamo mafahoane siahoasireapo.” ");
INSERT INTO faa_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Airakano Yasuaki mahisisa aporomo kairaka mahimetesapo. Yasumo wakapuaka rakisiakipoko aporo hinamo suamo aseraka kára sesésapo. ");
INSERT INTO faa_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yasumo someraka, “Unihae Kotimo aporo hinamo asekea reane yakapa asiare? ");
INSERT INTO faa_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ira máseta hae wakasema ane aporomo maka ipi hemoa maposa asiapo. Maposane pauaka hekea keseke kárakara ira parinapo. Ira pariraka rea ira eya á mena pekea menamo ape kirapo. Aina ayiáka Kotimo aporo hinamo unihaeaka asekea reane asiapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Efera hunia Yasumo someraka, “Aporo hinamo Kotimo unihaeaka asekea reane yakapa asíare? ");
INSERT INTO faa_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kotimo unihaeaka asekea rea aporo hinamoane makata pirira asíapo. Farawa paiyakosakipoko makata pirirane wakasema maka, farawa tarámo kesa yia, makata pirirane hakāsa sarimaraka kekerorakano, farawa suane piriraka káranapo. Aina ayiáka aporo hinamo i suane Kotiaki risikiako parirane asíapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yarusarame sitia ahira maiya amo ape meta some kaka ape meta soko some kaka, ayiáka Yasumo some kape hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Hinakano aporo metamo someraka, “Unihaeo, aporo hinamo hukusi Kotimo mafasiakosare? Aporo hinamo yakai Kotimo mafasiakosare?” Airakano Yasumo someraka, ");
INSERT INTO faa_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Re ikia koro makoropasa á yorokoa pukusakipoko koteaka hemakapukua koraká rekeanie. Aporo metakira ikia koro makoropasa yorokoa pukusapoko asiāne, pusifasekeno poparipukusapo. ");
INSERT INTO faa_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ape wafaya takahikia ikia koro mapirirakano repo ikia koroa paroparoraka someraka, ‘Unihaeo, ikia koro ropakamasie.’ Airakano ape wafayamo someraka, ‘Re epare? Re nōmo aserafapo,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Airakano repo someraka, ‘Né isina hakāsa toke makata nenakasupo. Isiapo apea nómo some karakasupo.’ ");
INSERT INTO faa_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Airakano epo someraka, ‘Repo ape mayare? Re nōmo aserafapo. Aporo hinamo watikisao, re ano metakarikia pusie.’ Aíyaka ape wafayamo somehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Someahora maiya amo repo yao anaka aseane Eparahame, Aisake Yakope porofete aporo i suane Koti unihaeaka rea hauaka á hakāsa risikino asekea, re kára hihiripuhokosapo. Hihiripuraka akai kirisiraka kára himu nakosapo. ");
INSERT INTO faa_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Arirakano aporo maiya apera anaka soko, maiya apura anaka soko, ketayia anaka soko, ketayia taku anaka soko, su sarimahokosapo. Sarimaraka Koti unihaeaka rea hauaka á su teporo makeraka hakasa toke makata nakosapo. ");
INSERT INTO faa_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Asiamo yumo aporo hinamo metakira fanaraka risiane kesekehokosapo. I metakira kesekea risiane fanahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Maiya amo Ferese aporo pekea Yasuaki someraka, “Né Herotemo rukusapakae. Asiamo hauaka one metakarikia pusie.” ");
INSERT INTO faa_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Airakano Yasumo someraka, “Kotafe somehaeraka wera aporoaki some one some kakanie. Pipu soko, rau soko, aporo ho yatafumo mosane soko, aporo makata tasane soko nōmo mafarakanapo. Sere isiamo nōmo makata rakikia makosapo. ");
INSERT INTO faa_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pipu soko, rau soko, rawai soko, nōmo makata rakirane rakikia mako ano Yarusarame sitia hiakosapo. Yarusarame sitia porofete aporoane rusua kurapo. Rusua kurane hauaka meta á kakenafapo. Asiamo ano Yarusarame sitia ipu namina rusua kukusimo ano hiakosapo. ");
INSERT INTO faa_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yarusarame aporo hinamo reo, repo Kotimo some kará porofete aporoane rusua kusuapo. Kotimo pusiesa aporoane repo ekemo karesapo. Yarusarame aporo hinamo reo, mena kaīyiamo mena mano sarimaraka auāmo kafoko tapikia mafainapo. Aina ayiáka nōmo reane efera hunia soko, efera hunia soko, sarimaraka ayiakakosapoko asiane repo anoaki hisiane. ");
INSERT INTO faa_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yarusarame aporo hinamo reo, repo apeane kauanehokosapo. Apea aporo hinamo waka risikiakosafapo. Nōmo reaki kakaro somerakaripo. Repo ano efera hunia aseakosafapo. Arirakano keseke ano peakosa maiya amo repo asekea someraka, ‘Kotimo pusiesa aporo aperane, Kotimo makotehoasimoripo,’ aihokosapo. Aíyaka somehora maiya amo anoane repo aseakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Fenena maiya metamo Ferese aporo káramo apea Yasu ipi makata nako pusuapo. Maiya suamo Yasuane Ferese aporomo maserapi asekehaesapo. ");
INSERT INTO faa_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Arirakano aporo meta hokono pirikia korake soko pirikia ayiáka makata takamasa apea wareapo. ");
INSERT INTO faa_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ayiáka warekeno Kotimo somemane tisa aporoaki soko, Ferese aporoaki soko, Yasumo someraka, “Fenena maiya amo aporo makata takamasane mafarakanone, ane Kotimo somemaneane metakarirakanare?” ");
INSERT INTO faa_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Aihoane ipu makata somesafapo. Some paripeanafonorakano makata takamasane Yasumo mafasapo. Mafaraka marekea aporo makata takamasa mafasane Yasumo pusiesapo. ");
INSERT INTO faa_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Asiamo aporo suaki Yasumo someraka, “Fenena maiya amo nómo ní hokosa soko metao, saro ponomakau soko metao, he kafa hurupesane, nómo ní foaka marafare?” ");
INSERT INTO faa_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Airakano aporo suamo makata somerafaraka me kauraka asekea risiapo. ");
INSERT INTO faa_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yasumo ipi aseane aporomo makata nakosakipoko teporo makeraka a tokeno asesapo. Arirakano aporo metakira, “Ano yano kárapo,” aíyaka hemakapukua namina aporo hokopusuamo sea a tokoakosakipoko wate foaka pukua tokeno Yasumo i asesapo. Asekea Yasumo takumeaka someraka, ");
INSERT INTO faa_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Hinamo aruamara maiya amo, aporo meromo hokono keraka né peaerakano, puraka aporo hokopusuamo sea á né kakakopo. ");
INSERT INTO faa_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Aporo meta hokopusua peraka kakakosakipoko aporo meromo someraka, ‘Né takahikia aporo wakasemamo sea á kakako pusie.’ Airakano né takahinaka kaiyahokosapo. ");
INSERT INTO faa_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Arirakano aporo wakasemamo sea á né fana kayane aporo meromo someraka, ‘Hameo, né takahikia aporo hokopusuamo sea á kakako peae.’ Aíyaka né makárarakano aporo suamo aseakosapo. ");
INSERT INTO faa_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Aporomo epo ipiane makárarakano keseke e mawakasemahokosapo. Arirakano aporomo epo ipiane mawakasemarakano keseke e makárahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Arirakano aporo meroaki Yasumo someraka, “Hokono akera maiya amo ní more soko, ní mae soko, ní aporo táke soko, aporo makata kemo káraraka reane soko, iane peaehokopo. Nómo peaerakano peaesakipoko né soko ropo yaiya peaehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Arirakano hokono akera maiya amo aporo makata forosa soko, aporo hokono matipusa soko, aporo korake matipusa soko, aporo hi fausa soko, i suane nómo peaehoanie. ");
INSERT INTO faa_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Aporoane nómo peaerakano aporoamo soko né ropo peaehokosafapo. Arirakano nómo aporo metakira araresakipoko né seseaka rekeanie. Keseke aporo hinamo ereketaesane maturikia taena maiya amo Kotimo néane makata ropo kára kakakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Aporo hakása meta teporo makeraka kayamo, Yasumo somesane kaikia someraka, “Koti unihaeaka reamo apea hokono keraka, aporo hinamo makata nekea tokoakosa aporo hinamoane yumo seseaka risikinapo.” ");
INSERT INTO faa_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Airakano Yasumo takumeaka someraka, “Aporo metamo hokono kára keakosakipoko aporo yakai peaniesapo. ");
INSERT INTO faa_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Hokono akeramo makata nakosane sarimasapo. Aporo su peasimo ipi aporo raipaki someraka, ‘Aporo su yumo peaehoanie,’ aisapo. Airakano aporo raipamo iane peaesapo. ");
INSERT INTO faa_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Peaerakano pesafapo. Aporo suamo peakosafapo, aíyaka meaka sekesapo. Aporo metamo aporo raipaki someraka, ‘Hauaka nōmo kawe roposane aseako purakanapo. Ano peakosafapo.’ ");
INSERT INTO faa_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Airakano aporo metamo someraka, ‘Saro ponomakau kaeyakosu (10) nōmo kawe roposane aseako purakanapo. Ano peakosafapo.’ ");
INSERT INTO faa_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Airakano aporo metamo someraka, ‘Ano hinamo kawe arumasasamo peakosafapo.’ ");
INSERT INTO faa_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Airakano aporo raipane paripukua ipu makata somesane ipi wafayaki somesapo. Somerakano aporo ape meromo saperaka, aporo raipaki someraka, ‘Ikia kara fea ape mukisapo. A foaka pukua, aporo makata forosaki someraka, “Re peae,” aíyaka aporo hokono matipusaki soko, aporo hi fausaki soko, aporo korake matipusaki soko, “Re su peae,” aihoanie.’ ");
INSERT INTO faa_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Airakano aporo raipamo iane pasimokoako pusuapo. Puane i su perakano asekea, aporo raipamo ipi wafayaki someraka, ‘Aporo unihaeo, nómo peanie, aisane nōmo i suaki somesapo. Somerakano i sú pesapo. I pesane ape tapesafapo.’ ");
INSERT INTO faa_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Airakano aporo raipaki ipi wafayamo someraka, ‘Ape one metakarikia, yaoa ikia kara metakira kára soko, metakira wakasema soko, á pukua aporomano peaehoanie. Ape tapehoasimo aporo hinamo yakai peaehoanie. ");
INSERT INTO faa_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Hao, kaisie. Nōmo kakaro somerakaripo. Hokono akera wo, aporo fana peaehoane hisisane, nōmo metakariakosapo. Iane hakāsa makata nakosafapo,’ aisapo.” Aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Yasuyaki aporo hinamo yakai pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Puraka iaki Yasumo pariasekea someraka, “Aporo hinamo metamo ano patera aseako ipi ata, ipi ama, ipi hinamo, ipi hokosa, ipi mae, ipi papā, ipi kau soko, makata suane mokoma kesekehoanafonona aporo hinamoane, ano patera asesa aporo hinamofapo. ");
INSERT INTO faa_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Aporo hinamo metamo ipi ira matopesa makatiraka maka punafonona aporo hinamoane ano patera asesa aporo hinamofapo. ");
INSERT INTO faa_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Arirakano aporomo huturu ape (tu sitori) kiakosakipoko fana ipi moneane menonapo. Ape kikimakosane mone siahoasirihoamo mone menonapo. ");
INSERT INTO faa_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Arirakano mone menohoanafonoraka ape takuma ira kesa hákasa porokoa kikifai tetá hákasane taeraka mone farakano huturu yapurane metakariakosapo. ");
INSERT INTO faa_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Metakarirakano aporo metakiramo aseraka hokomaka someraka, ‘Ape kikimayafareapo,’ aíyaka somehokosapo. Aíyaka somehokohoamo fana mone menohoanie. ");
INSERT INTO faa_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Arirakano aporo unihae kini wakasemamo ipi aporo terakaiyamosa ame aporoane yakai tene taosenepo (10,000). Aporo unihae wakasema amo ipi aporo unihae kini kara aki yunuraka weakosakipoko pesapo. Arirakano aporo unihae kini karamo yunu aporomo aporo terakaiyamosa ame aporoane, kara yakai tuaneti taosenepo (20,000). Arirakano aporo unihae kini wakasemamo yunu weasiraka fana hemakapuraka, ‘Isu weraka rukua koakataehoasireare? Rukua koakataehoanafonorakano isina weakosapo. Arirakano rukua koakataerakano isiapo metakariakosapo,’ aisapo. ");
INSERT INTO faa_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Aíyaka ipi takekea hemakapuraka, ‘Wae, isu aporo hukusisamo rukua koakataehoasireapo. Nōmo weakosapoko asiane metakarirakanapo.’ Aíyaka hemakapukua ipi aporo raipaki someraka, ‘Aporo unihae kini kara wo peakohoamo, né i arisia pusie. Weakosane metakariakosakipoko nómo somehoko pusie. Puraka úyaka somehoanie. “Isu aporo hukusipo. Reane aporo karapo. Asiamo isina weane siahoasifareapo. Weakosane metakariakosakipoko isiapo re api kayaere?” Aíyaka iaki somehoanie.’ Aíyaka unihae kini wakasemamo someaka maresapo. ");
INSERT INTO faa_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Asiamo hauaka wo makata kemo metakarianafonona aporo hinamoane ano patera asesa aporo hinamofapo. Aporo hinamo metamo ipi makata kemoane metakarirakano aporo hinamoane ano patera asesa aporo hinamopo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yasumo some meta someraka, “Kifiriane wapesa kotesapo. Kifiri wape farakano efera hunia wapehoasimo yakapa rakirare? Wae, wapehoasimo makata meta rakirafapo. Efera hunia wapehokosafapo. Asiamo kifiri wapesa fasane. Nena yaoa mamakatenapo. ");
INSERT INTO faa_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Arirakano makata mano koteaka taneheasimo hemo wafayamo kifiri wapesane hauaka kokomarerapo. Arirakano saro ponomakau fakosa akiyaki kifiri yaki sarimaraka makata porosa hauaka á taenapo. Taerakano makata porosane koteaka taneherapo. Arirakano kifiri wapesane fasekeno makata rurafapo. Nena yaoa mamakatenapo. Asiamo re senaki risiamo koteaka kaiyinie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Maiya metamo takese mora aporo soko, aporo watikisa metakira soko, su Yasu rea pekea, epo someane kaiyako pesapo. ");
INSERT INTO faa_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Perakano asekea Ferese aporomo soko, Kotimo somemane tisa aporomo soko, saperaka someraka, “Aporo watikisane Yasumo ipi tereraka pasimaka iyaki hakāsa toke makata anene,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Airakano Yasumo takumeaka someraka, ");
INSERT INTO faa_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Re aporo hakása metamo saro sipi wane harote (100) risiane hakása meta yaoa rosaka purakano repo asekepayanare? Wae. Saro sipi naeneti naene (99) yia sarimaraka risiane metakarikia, hakása rosaka pusuane kope purapo. Kokoa kokoa hisiraka aserapo. ");
INSERT INTO faa_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Aseraka seseraka ketakamaka makatiraka apea maka purapo. ");
INSERT INTO faa_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Apea maka pekea ipi aporo táke soko, ipi ape hakása risia aporoane soko peasimo wárapo. Wáraka perakano iaki someraka, ‘Saro sipi rosaka pusuane, nōmo kokoa masapo. Asiasamo repo soko sesehoanie.’ airapo. ");
INSERT INTO faa_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sesesa ayiáka aporo hakása metamo ipi makata watikisane hufitaeraka, makata watikisane metakarikia, koteaka rekeako pariraka rekeno, hepene aporomo soko Kotimo soko aseraka, namo kakaro kára sesenapo. Arirakano aporo naeneti naenemo (99) hemakapuraka, ‘Isiapo himu koteaka susu hemakapukua risiane, marirakano isu risikiako parihokosare?’ Aíyaka hemakapurakano, koteaka risia aporoane hepene aporomo asekea sesenapo.” Aíyaka Yasumo somesane Ferese aporomo hemakapusimo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yasumo takume meta someraka, “Hinamo hakása metamo ipi suifa mone hae kaeyakosu toapo. Toane mone hae kaeyako hakása ane hurupesekeno asekepayanare? Wae. Ipi nafa paikia ape feaoraka, mone haeane kokoa hisiraka, ");
INSERT INTO faa_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","kokoa maraka, hinamoamo sesenapo. Seseraka ipi hinamo táke soko, ipi ape hakása toa hinamoane soko, sarimahoasimo wáraka su sarimarakano someraka, ‘Nōmo mone hae hakása hurupesa hasaka kosane, nōmo nī kokoa masapo. Masekeno repo soko sesehoanie,’ airapo. ");
INSERT INTO faa_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sesena ayiáka aporo hinamo hakása metamo makata watikisane hufitaeraka, watikisane metakarikia Kotiaki rekeako parirakano, Kotimo soko hepene aporomo soko aseraka sesenapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yasumo takume meta someraka, “Aporo metamo aporo hokosa tetá risiapo. ");
INSERT INTO faa_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Hokosa kesekemo ipi wafayaki someraka, ‘Atao, né finihaoa eto risikiako nómo makata kemoane parakurasie. Parakuraka ano kakakosane, ano nīaki yumo kasie.’ Airakano ipi wafayamo makata kemoane parakuraka hokosa tetáki kasápo. ");
INSERT INTO faa_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Karakano wakasema nina hokosa kesekemo ipi makata mosane sarikekea maka pukua, ipi wafayamo hauakane metakarikia hauaka yamenoa pusuapo. Pukua hauaka á pauraka reapo. Hauaka á reke ipi makata watikiaka rakiraka reapo. Watikiaka rakiraka reke ipi moneane aporo hinamo metakiraki mokome karáka reapo. ");
INSERT INTO faa_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Mokome karáka reke ipi mone ane fasapo. Arirakano maiya amo hauaka á makata nakosane fasapo. Makata nakosane fasa maiya amo e kára meamosapo. ");
INSERT INTO faa_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Meamorakano e pukua hauaka mero aporoaki someraka, ‘Nepoko nōmo makata rakiaere? Nepoko nōmo makata rakiakoripo.’ Airakano aporo hauaka meromo someraka, ‘Nōmo saroane nómo asekea rekeanie.’ ");
INSERT INTO faa_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Airakano saroane epo asekea reke saromo makata nakosane epo asekea hemakapuraka, ‘Saromo makata nenane ano nariripo.’ Aíyaka epo hemakapurakano aporo metamo eane makata nakosa kasafapo. ");
INSERT INTO faa_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Kakanafonorakano wakasema nina, ipi koteaka hemakapusuapo. Ipi hemakapuraka, nōmo atamo aporo raipamo makata sia nenakasupo. Pipu soko ipu makata siaraka nenakanapo. Ipu makata siaraka nenakao, ano hauaka wo reke namo kakaro kara meamoraka kukuripo. ");
INSERT INTO faa_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Asiamo ano takahikia atamo apea purakapo. Puraka ataki nōmo uyaka somehokosapo. ‘Atao, Kotiane nōmo mawakasemasapo. Ata ne soko nōmo mawakasemasapo. ");
INSERT INTO faa_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nómo yumo anoane, “Nōmo nī hokosapo.” Aihokopo. Anoane “Nōmo aporo raipapo.” Aihoanie.’ ");
INSERT INTO faa_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aíyaka ipi ataki somehoko hemakapukua takahikia ipi atamo apea paripusuapo. Paripukua yamenoa perakano ipi wafayamo aseraka, ‘Nōmo hokosa wate rosaka pusuane apere.’ Aíyaka kamenakaraka foaka pukua ipi hokosane fatuaka maka makanusapo. ");
INSERT INTO faa_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Makanurakano hokosamo someraka, ‘Atao, Kotiane nōmo mawakasemasapo. Né soko nōmo mawakasemasapo. Nómo anoaki “Nōmo nī hokosapo,” aihokopo.’ ");
INSERT INTO faa_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Airakano wafayamo ipi aporo raipa wáraka someraka, ‘Pasu kotesa epo osohoasimo foaka maka peae. Tamaka osohoasimo maka peae. Kau rakisimo waya hokonoa hira maka peae. ");
INSERT INTO faa_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Saro ponomakau mano kaniamosekeno e nasimo rukua paiyinie. Pipu yumo isina e karikia seseaka makata paikinakosapo. ");
INSERT INTO faa_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nōmo hokosa kurakanareapo, aisane pipu nōmo aserakaripo. Wate fana e rosaka pusuane pipu apere. Asiamo pipu nōmo nī hokosapoko saro ponomakau mano maka rusie. Hokosapoko makata pakinakosapo.’ Airakano aporo raipamo saro ponomakau mano maka rukua paisiapo. Paikia nekea namina kesasapo. ");
INSERT INTO faa_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kesasa maiya amo hokosa fanane hemoa rea peraka, ape makeraka kaiyiáne kesarakano kaisiapo. ");
INSERT INTO faa_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Kairaka ipi aporo raipaki someraka, ‘Kesaraka sikirakae. Mairakarirakapo.’ ");
INSERT INTO faa_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Airakano aporo raipamo someraka, ‘Nómo ní mae kesekeane kurafaraka ipi pariperakasapo. Asiasamo ni atamo seseraka saro ponomakau kaniamosa rukua, epoko makata paikinenaka kesaraka ayapo.’ ");
INSERT INTO faa_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Airakano hokosa fanamo ipi kakaro kara saperaka, ‘Apea ano pukusafapo,’ aisapo. Airakano ipi ata pekea kukunameaka someraka, ‘Apea ne peae.’ ");
INSERT INTO faa_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Airakano hokosa fanamo someraka, ‘Maiya suamo nepoko aporo raipamo arakira ayiáka, nōmo rakisiapo. Nómo someane nōmo kakimasapo. Nómo anoaki makata yakapa kasare? Nómo ano makata kasafapo. Saro nanikose mano hakása soko, nōmo aporo tákeane karikia paikinasimo karakasufapo. ");
INSERT INTO faa_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nómo ní hokosa kesekemo hinamo hakimaraka reapakasupo. Nómo makata kemoane ipi mokoa pusuapo. Mokoa pusuane ipi hinamo hakimaraka moneane hinamo kaka fasapakasupo. E pariperakano, epoko nómo saro ponomakau mano kaniamosa rukua e karikia makata paikia anene.’ ");
INSERT INTO faa_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Airakano ipi wafayamo someraka, ‘Né anoyaki hakāsa reapo. Nōmo makata kemoane su nómenapo. ");
INSERT INTO faa_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Asiamo nómo ní mae kesekeane kurakanareapo aisane pipu asesapo. Wate fana e rosaka pusuane pipu apere. Perakano seseaka makata paikinenakanapo.’ Aíyaka wafayamo somesapo.” Aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aporo hakāsa puraki Yasumo takumeaka someraka, “Ape wafayamo makata kemo kárasekeno, aporo metamo ipi makata kemoane asekea rekeasimo murikimaka maresapo. Maresane aporo metamo aporo ape wafayaki hokoreraka someraka, ‘Nómo makata ropoane nómo aporo asekea reamo koteaka asekea rekenafapo. Ipi mokome karaka makata ropoane farakanapo.’ ");
INSERT INTO faa_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Airakano ape wafayamo aporo asekea reane peaesapo. Perakano eaki someraka, ‘Nómo makata koteaka rakisiapakare? Nōmo makata ropoane nómo mokome karakánapakae. Né makata rakisiane pipu metakarirakanapo. Né metakariasiraka nómo makata rakisia ropo kará sawiane nōmo aseako pipu yia maka peae.’ ");
INSERT INTO faa_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Airakano aporo asekea reamo hemakapuraka, ‘Ano pipu metakarirakanapo. Keseke nōmo yakapa rakiakosare? Nōmo hauaka meta makata rakiako kaiyako ayiane ano sia wakapuhoasifareapo. Arirakano ape sua ano mone makasie, aíyaka kaiyako ayiane ano kaiyahoasireapo. ");
INSERT INTO faa_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ano metakarirakano keseke aporomo ano ararehoasimo nōmo uyáka rakiakosapo.’ ");
INSERT INTO faa_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Aíyaka hemakapuraka aporo suamo ape wafayaki makata ropo kakanafonosa nine makata ropo kakakosakipoko i su hakása hakásaraka peaesapo. Aporo hakása meta fana perakano, eaki kairaka, ‘Nómo makata yakapasu ape wafayaki kakafunure?’ ");
INSERT INTO faa_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Airakano epo someraka, ‘Orofe wera tarámo wane harote (100) suane kakafunupo.’ Airakano aporo asekea reamo someraka, ‘Nómo wane harote (100) suane kakakosapoko asiāne, nōmo metakarikia sanasirakanapo. Asiamo nómo wane harote ane kosoraka, fifiti ane (50) kakakosakipoko sawia poparasie.’ ");
INSERT INTO faa_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Aíyaka aporo metaki aporo asekea reamo someraka, ‘Nómo ape wafayaki makata yakapa su kakafunure?’ Airakano epo someraka, ‘Witi hae pakia kesane wane harote suane (100) kakafunupo.’ Airakano aporo asekea reamo someraka, ‘Nómo wane harote kakakosapoko asiāne, nōmo metakarikia sanasirakanapo. Asiamo nómo wane harote (100) kosoraka aíti su (80) kakakosakipoko sawia poparasie.’ Aíyaka aporoamo keseke e ararehoasimo aporo asekea reamo somesapo. Ayiáka fana makata ropo kára kakakosaposane metakarikia, makata ropo wakasema kakakosapo, aíyaka popasapo. ");
INSERT INTO faa_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Asiasamo ape wafayamo aporo asekea reamo kotafe rakisiaporakano, eaki kekereraka sikiraka someraka, ‘Keseke aporomo né ararehoasimo ipu makata ropo anoaki kakafunusa nine nómo sape meta rukupatesasamo iane araresapo.’ Aíyaka ape wafayamo somesapo.” Aíyaka Yasumo somesapo. Arirakano takume amo kepoane Yasumo someraka, “Nena aporo hinamomo someraka, ‘Keseke makata ropo kakasimo pipu népoko nōmo yaku rakirakanapo.’ Aíyaka nena aporomo wate foaka hemakapukua rakirapo. Arirakano Kotimo ikia kara faesa á risia aporo hinamomo wate foaka ayiáka rakirafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Aíyaka Yasumo efera hunia someraka, “Keseke hepene yapura ne hinaka Kotimo neaki someraka, ‘Nómo makata kemoane soko, moneane soko, koteaka asekea reapo.’ Aihoasimo hauaka wo makata kemoane soko moneane soko, koteaka asekea reke, moneamo aporo hinamoane ararehoanie. Koteaka ararerakanone, hauaka wo makatane fahoramo, keseke hepene yapura ahiramo Kotimo someraka, ‘Nómo makata koteaka rakisiapo. Yumo né hepene ape wo peae,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Arirakano repo aporo hinamo metamo makata wakasemane koteaka asekea rekeno, ane makata kárane soko, koteaka asekea rekeakosapo. Arirakano makata wakasemane koteaka asekea rekeanafonorakano, ane makata kárane soko, koteaka asekea rekeakosafapo. ");
INSERT INTO faa_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Asiamo hauaka wo makata kemo soko, mone soko, koteaka asekea rekeanafonorakano, ane nómo Kotimo makata namo kakaro kotesane koteaka asekea rekeakosare? Wae, koteaka asekea rekeakosafapo. ");
INSERT INTO faa_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Arirakano aporo metamo menane nómo koteaka asekea rekeanafonorakano, ane né makata ropoane kakakosare? Wae, kakakosafapo. ");
INSERT INTO faa_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Arirakano wafaya tetápoko aporo raipa hakásamo rakiane siahoasifareapo. Wafaya tetápoko rakiraka metaki hisiraka rakiakosapo. Metaki seseraka rakiakosapo. Wafaya hakása makáraraka seseraka rakiraka, wafaya metaki hisiraka patera tariakosapo. Asiamo himu metamo Kotiaki hemakapukua, himu metamo yokotae moneaki hemakapukua, ayiáka himu tetáraka hemakapukua rakiane siahoasifareapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yasumo somesane Ferese aporomo kairaka, namina mone kára hemakapukua risike, Yasuane asekea hokomaresapo. ");
INSERT INTO faa_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Hokomarerakano Yasumo someraka, “Aporo suamo reane aseraka, ‘Ferese aporoane aporo kotesapo.’ Aihoasimo repo kaumo aina ayiáka arakire. Asiāne repo watikiaka hemakapukua rakisiane, himua mahamekea risiane, Kotimo ipi aserapo. Asiamo aporo hinamomo hauaka wo makata aki makáraraka hemakapukua risiane, Kotimo makáranafapo. Asiāne makata ane Kotimo aseraka, nenakamaka makata ayireapo, airapo. ");
INSERT INTO faa_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Yone he tapukumarerane peasiraka Mosesemo somemane soko porofete aporomo some popasane soko, aporo hinamo suamo kaisisupo. Asiamo somemane amo iane asekea reasusupo. Asiane Yone he tapukumarerane peraka, Koti unihaeaka reane epo some kasapo. Asiamo maiya omo Kotimo aporo hinamo asekea rea someane nōmo some karakanapo. Aporo hinamo yakaimo Kotimo iane asekea rekeasimo, ipu namina seseraka kairakanapo. Aporo hinamo yakaiane Kotimo ape tua hiakosakipoko makata hufitaehoramo, ikia koroa wakapuaka arura ayiáka ruraka risikinapo. ");
INSERT INTO faa_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Hepene yapurane soko, hauaka one soko fahokosane makata wakasemapo. Arirakano Kotimo somemaneane fahokosafapo. Ane, makata kárapo. ");
INSERT INTO faa_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Arirakano aporomo ipi asea fimarekea hinamo meta arumarakano aporoamo hinamoane haki arumarakanapo. Hinamo fimaresane aporo metamo arumarakano hinamoane haki arumarakanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yasumo someraka, “Aporo hakása metamo ipi mone kára sarimaraka reapo. Ipi pasu mone káramo roponapo. Maiya suamo pasu kotesa susu osoraka, makata nakosa kotesa susu nenapo. ");
INSERT INTO faa_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Arirakano aporo meta yano motosa Rásarase makata forokoa reke, ipi kauane neketasi sususapo. Maiya suamo aporo kára reamo apea ");
INSERT INTO faa_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","makata nenaka momoane teporo petaua atura hurupepesane Rásarasemo nakosakipoko mumiraka ikia koro makeraka asekea kayapo. Asekea kayane ipi kauane neketasisususane kásamo sarerakano asesapo. ");
INSERT INTO faa_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Asiamo wakasema nina keseke Rásarase ipi kurakano hepene aporomo e karikia, Eparahame kayakipoko karikia hisiapo. Hisiakipoko, keseke aporo kárane kusua hauaka maresapo. ");
INSERT INTO faa_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Maresane e Hétisi hauaka atura puraka kau teraka himu nekea reapo. Ayiáka reke yameno yapura aseane Eparahame kayakipoko Rásarase kakeno asekea ");
INSERT INTO faa_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","wáraka, ‘Ata Eparahameo, Rásarasemo hokonomo he inusa sakairaka ano arua motoako e pusiesie. Hauaka wo ira rufia ano reke kára sisipuripo. Ano kau kára teripo. Rásarase ipi ano ararehoko pusiesie.’ ");
INSERT INTO faa_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Airakano Eparahamemo someraka, ‘Hokosao, ní hitaferaka rea maiya amo makata kotesa susu ní marakasupo. Ane, nómo meraruhokopo. Rásarase fana makata forokoa reane, yumo ipi seseaka rekenapo. Ne fana káraraka reane, yumo tēsa hauaka á rekenapo. ");
INSERT INTO faa_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Arirakano tipia hao kára kayasasamo né area isu peasifareapo. Né soko isu arisia wo peasifareapo.’ ");
INSERT INTO faa_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Airakano aporo káramo someraka, ‘Atao, nōmo nī mae kakoreasu atamo apea risikinapo. ");
INSERT INTO faa_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ano area hauaka wo tēsa hauakapo. Hauaka wo iane peakohoamo Rásarasemo somehoko pusiesie.’ ");
INSERT INTO faa_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Airakano Eparahamemo someraka, ‘Ne tēsa rea hauaka á nómo mae pukohoamo Mosesemo soko, porofete aporomo soko, some kasane ipu kaikia kekemahoafunureapo.’ ");
INSERT INTO faa_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Airakano aporo káramo someraka, ‘Eparahameo, Mosesemo some kasane ipu kakimarakarifapo. Ane siahoasifareapo. Arirakano aporo kusua turikia pusua amo iaki some karakanone, ane ipu kairaka makata watikisane metakarikia risikiako parihokosapo.’ ");
INSERT INTO faa_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Airakano Eparahamemo someraka, ‘Mosesemo some kasane soko, porofete aporomo some kasane soko, ipu kakipayaraka risiamo aporo kusua turikia puraka somerakano soko, ipu kakimakosafapo.’ Aíyaka Eparahamemo somesapo.” Aiyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yasumo ipi aporo hakāsa puraki someraka, “Re hauaka wo makata rakisimo aporo metakiramo reaki hokokakakosapo. Repo watikiaka rakisimo reaki hokokakakosapo. Hokokasa aporoane Kotimo hukuarura maiya amo e hukurukusane itifiakosafapo. ");
INSERT INTO faa_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Aporoane eke káramo mawia kita hukumarekea he tawara numua makasuanane wakasema fanasirakanapo. Asiane aporomano meta kawe ano patera asesane epo watikiaka rakisimo aporo metamo hokokarakano, hokokasá aporoane ipi kára fanasiraka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Asiamo re asekeanie. Ní maemo né mokoatikirakano eane maroporaka someraka, ‘Nómo makata watikiaka rakiakopo.’ Airakano ipi makata watikisane metakarikia someraka, ‘Nōmo ne mokoatikisane nōmo kakaro kara hasaka rakireapo.’ Airakano epo watikisane nómo mafaraka mameraruhoanie. ");
INSERT INTO faa_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Pipu maiya hakása yiamo nómo ní maemo neane mokoatikisane epo neaki someraka, ‘Neaki nōmo hasaka hemakapukua rakireapo. Asiane nómo mameraruhoane siahoasireare?’ Airakano nómo mafaraka mameraruhoanie. Maiya hakása yiamo yape yatipinusu ayiáka mokoatikiraka rakiraka nōmo hasakasapo, airakano nómo mafaraka mameraruhoanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yasumo tarira aporomo eaki someraka, “Isiapo Kotiaki himu hakásaraka hemakapurane nómo mawakapuraka makárahoanie.” ");
INSERT INTO faa_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Airakano Yasumo someraka, “Ira máseta hae namo kakaro wakasemapo. Repo Kotiaki himu hakásaraka hemakapurane wakasema ayiria ayiáka risikinone, ane repo ira káraki someraka, ‘Kepo pikinuyaki su fimaka, he tawara numua rekeako pusie.’ Airakano iramo kairaka ipi fikia pukua, he tawara numua rekeako pukusapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yasumo takumeaka someraka, “Repo aporo hakása metamo hauaka asekea rekenone, nómo aporo raipaki someraka, ‘Nōmo hemoane nómo hauaka mosorako hinie. Arirakano nōmo saro sipi soko, nómo asekea rekeanie,’ airapo. Arirakano maiya amo aporo raipamo hauaka mosorako, hemoa hikia samapu apea perakano nómo eaki someraka, ‘Né makata nako peae,’ aíyaka nómo somerare? ");
INSERT INTO faa_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wae. Nómo aíyaka somerafapo. Nómo someraka, ‘Fana nōmo makata nakosane nómo paikia, inasekeno ano akaya teporo wo maka peanie. Nōmo makata nakosa fana nekea farakano, né keseke makata nako punie.’ Aíyaka nómo somerapo. ");
INSERT INTO faa_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Arirakano hauaka asekea rea aporomo ipi aporo raipaki, nómo makata rakiniesane, epo rakisekeno ane, ipi asekea rea aporomo eaki kekereraka susehokosare? Wae. Aporo raipaki rakiniesane kakimaka rakisia hákasa akipoko kekerenafapo. ");
INSERT INTO faa_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Arirakano aina ayiaka neaki ayiakaniesane nómo kakimaka rakikia maraka nómo someraka, ‘Ano aporo raipapo. Aporo raipamo makata rakira ayiáka nōmo rakisiapo. Nómo kekerehoasimo nōmo rakisiafapo.’ Aíyaka somehoanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yasu Yarusarame sitia pukusakipoko Kariri hauakane makama taku raraka, Sameria hauakane makama sape roraka, ikia tipia wareakipoko Yasu á pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pukua apea perakano aporo toropakesa kaeyakosu e sapenako pekea, wakasema fasikia fe takua risike ");
INSERT INTO faa_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","wáraka, “Unihae Yasuo, nómo isu kamenakaraka ararerasie.” ");
INSERT INTO faa_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Airakano Yasumo asekea someraka, “Pirisiti aporomo re kau asekeasimo pusie.” Airakano i ikia kara puane toropakesane fasapo. ");
INSERT INTO faa_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Arirakano aporo hakása metamo ipi kauane aseane toropakesane fasekeno, ipi seseraka pariperaka Kotiaki sakepamo kekererape pesapo. ");
INSERT INTO faa_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Pekea Yasu rea kakuna porokoa kake susesapo. Arirakano aporoane ipi Sameria aporopo. ");
INSERT INTO faa_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Aporo hakása amo ipi suseaka perakano Yasumo someraka, “Aporo kaeyakosu nōmo mafasapo. Kaeyakoane népo. Aporo tokona suane mayare? ");
INSERT INTO faa_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Aporo hakása meta ipi hauaka haku meta reamo Kotiaki susehoko pekea are. Aporo tokona suamo Kotiaki susehoko perakarifapo.” ");
INSERT INTO faa_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Aíyaka aporoaki Yasumo someraka, “Nómo anoaki himu hakásaraka hemaka apura yiamo, ne toropakesane mafarakayiapo. Né takahikia pusie.” Aíyaka Yasumo eaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yasuaki Ferese aporomo someraka, “Koti unihaeaka rekeakosane masinaka unihaeaka rekeakosare?” Airakano Yasumo iaki someraka, “Koti unihaeaka reane aporomo himo asekeasimo ayiáka unihaeaka rekenafapo. ");
INSERT INTO faa_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Arirakano aporo metamo someraka, ‘Sape aka asesie. Koti unihaeaka rekenapo.’ Airakano aporo metamo someraka, ‘Sape ro asesie. Koti unihaeaka rekenapo.’ Aíyaka somehoane siahoasifareapo. Asiamo re arisia yia Koti ipi unihaeaka rekenapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Aíyaka aporo hakāsa puraki Yasumo someraka, “Keseke repo someraka, ‘Yape hakása Yasu Aporomanomo Tákeane isiapo aseakoripo.’ Aíyaka repo somehokosapo. Repo aíyaka someraka tiki somerakao, asiane, repo ano aseakosafapo. ");
INSERT INTO faa_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Reaki aporo metakiramo someraka, ‘Ano Aporomanomo Tákeane pesapo. Repo sape ro asesie.’ Airakano aporo metakiramo someraka, ‘Ano Aporomanomo Tákeane pesapo. Repo sape aka asesie.’ Aíyaka somerakanone repo kakimakopo. Someane repo hemakapukua kekemahokopo. ");
INSERT INTO faa_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Asiamo ano Aporomanomo Tákeane pariaperamo repo someraka, ‘Isiapo aserakarifapo,’ aíyaka somehokosafapo. Ano pariaperamo yamakere faena ayiáka ano paripeakosapo. Yamakereraka foaka ti yapura faena ayiáka ano paripeakosapo. ");
INSERT INTO faa_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ano paripeasiraka pipu yumo aporo hinamo arisiamo nōmo someane koaretaeraka ano kau mokoatikihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Aporomanomo Táke ano pariaperamo Noa rea maiya amo asia ayiáka ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noa rea maiya amo he peasiraka, aporo hinamomo makata nakosane hákasa hemakapukua, aporomo hinamo arumokoakosa hákasa hemakapukua ayiáka risiapo. Ayiáka risiakipoko Noa kasua ripasa maiya amo he peraka aporo hinamo suane he nekea kukua kekea fasapo. ");
INSERT INTO faa_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Arirakano Rote rea maiya amo asia ayiáka ano pariaperamo ayiakakosapo. Rote rea maiya amo aporomo makata nekea, makata roporaka, makata porokoa, ape kikia, ayiáka rakiraka risiapo. ");
INSERT INTO faa_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sotome taone ane Rotemo metakarisia maiya amo, hepene aeyaka ira rufiyaki ekeyaki yao asia sarimaraka peraka, aporo hinamo su rukua fasapo. ");
INSERT INTO faa_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Asia ayiáka, Aporomanomo Táke anoane fasere aperamo ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ano pariapera maiya amo aporo yaoa reane ipi makata kemo mako ape kakarua puane siahoasifareapo. Ano foakayia peakosasamo, aporo apea puane siahoasifareapo. ");
INSERT INTO faa_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Asiamo Rotemo hinamoaki asiane koteaka hemakapunie. Rotemo hinamomo pariasesa ayiáka repo soko anapaka asekeanie. ");
INSERT INTO faa_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Asiamo aporo hinamo hauaka wo arisiamo hitaferaka risikiakosa hákasane, aíyaka hemakapurakano, aporo hinamoane Kotiyaki yaiya risikiakosafapo. Arirakano aporo hinamomo anoaki hemakapuraka hauaka wo kau hitaferaka risikiakosane makama kesekeraka, aíyaka hemakapurakano, aporo hinamoane Kotiyaki yaiya risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Hao, kaisie. Ereamo apea aporo tetá hakāsa wakakesane, meta nōmo pasimaraka, meta yia metakariakosapo. ");
INSERT INTO faa_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Arirakano hinamo tetá hakāsa asipa araka risiane, meta nōmo pasimaraka, meta yia metakariakosapo. ");
INSERT INTO faa_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Aporo tetá yaoa risiane meta nōmo pasimaraka meta yia metakariakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Airakano aporo hakāsa puramo Yasuaki someraka, “Unihaeo, ma ayiakakosare?” Airakano Yasumo someraka, “Makata kusua kayakipoko mena sakarekepo asia sarimanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Maiya suamo aporo hinamomo kurikurihoasimo, kurikurinane metakariakohoamo, Yasumo takumeaka somesane oyapo. ");
INSERT INTO faa_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Ape meta hukurura kepo kaira aporo reke, epo Kotiane soko, ipi aporo tákeane soko koteaka hemakapurafapo. ");
INSERT INTO faa_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Arirakano ipi ape sumu á hinamo yaro hakása kayapo. Hinamo yaroane aporo metamo mokoatikirakano hinamo yaroane hukurura kepo kaira aporo rea á peraka, hinamoamo someraka, ‘Aporo metamo ano mokoatikirakano, nómo eane maroporaka, keseke ano ararehoanie.’ Aíyaka maiya suamo maroporaka ararehoanie, aisapo. ");
INSERT INTO faa_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Airakano maiya káramo hukurura kepo kaira aporoamo kakipayasapo. Asiane keseke epo ipiyia hemakapukua someraka, ‘Kotiane nōmo hemakapurafapo. Aporo tákeane soko nōmo hemakapurafapo. ");
INSERT INTO faa_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Asiamo hinamoamo anoaki maiya suamo someraka, “Maroporaka ararehoanie.” Airakano nōmo maiya suamo kaikia hisiripo. Efera hunia perakano e nōmo arareraka maropohokosapo. Maropohoanafonorakano maiya suamo ano rea perakano epo someane nōmo kaikia hisiraka ano wafororipo.’ Aíyaka hemakapukua hukurura kepo kaira aporomo somesapo.” Aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Asiamo some kepoane hemakapusimo Yasumo efera hunia someraka, “Hukurura kepo kaira aporo watikiaka rea yiamo, hinamo yaroane epo arareraka eane mokoatikisane maroposapo. ");
INSERT INTO faa_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Hao, kaisie. Koti ipi koteaka susu rerasamo reane mokoatikisane epo maropohokosapo. Ereamo soko maíyamo soko Kotimo murikimasa aporo hinamomo eaki kurikurirakano, Kotimo kairaka maropohokosare? Epo haru maropohoanafonoraka keseke maropohokosare? ");
INSERT INTO faa_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ao, iane mokoatikisane Kotimo ipi foaka maropohokosapo. Ano Aporomanomo Tákeane pariaperamo aporo hinamomo Kotiaki himu hakásaraka hemakapukua kurikuriraka risiarihoamo nōmo aseakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Aporomo ipiane hakása kekereraka sikiraka someraka “Ano kotesapo. Ano ereketaeraka sia rekenapo.” Aíyaka reke aporo metane makeferaka rerapo. Aporo ayiáka makáraraka risiaki Yasumo takumeaka someraka, ");
INSERT INTO faa_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Aporo tetá Kotimo apea kurikurihoko hisiapo. Kurikurihoko hisiane, meta ipi Ferese aporopo. Metane ipi takese mora aporopo. Tetā Kotimo apea hikia ");
INSERT INTO faa_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ferese aporo ipi haku fasikia reke epo yano motosa makáraraka e ipiyia kurikuriraka, ‘Kotio, aporo metakiramo makaripi ayiáka risikino, kotafe horakano, arirakano makata hakimarakano anapo. I arisia ayiáka ano rekenafapo. Takese mora aporo e area ayiáka ano rekenafapo. ");
INSERT INTO faa_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Arirakano sokō hakásamo yape tetá né sesehoasimo makata nakosane nōmo sokoainapo. Nōmo mone soko parakuraka tokonasu nōmo nī maraka, kaeyako hakása néaki karápo.’ Aíyaka Kotiaki Ferese aporomo kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Arirakano takese mora aporo wakasema yamenoa reke, epo ipi yano motosa mawakasemaraka, wamo arupekea reke kurikuriraka, ‘Kotio, aporo watikisane anopo. Ano kamenakahoanie.’ Aíyaka takese mora aporomo kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Aíyaka kurikurisa aporoamo Kotiaki makata watikisane maroporaka marekea aíyaka kurikurisane, Kotimo kaikia makotesapo. Asiamo keseke aporoane ipi apea paripusuapo. Arirakano Ferese aporomo asiafapo. Aporoamo epo ipiane makárarakano, keseke e mawakasemahokosapo. Arirakano aporomo epo ipiane makama kesekerakano, keseke e makárahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Hokosa feteane Yasumo sakairaka makotehoasimo Yasu rea karikia pesapo. Karikia perakano Yasumo aporo hakāsa puramo someraka, “Hokosane karikia peakopo.” ");
INSERT INTO faa_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Airakano Yasumo hokosaki peaeraka someraka, “Hokosa ano rea wo karikia peane siahoasireapo. Iane repo matasohoane siahoasifareapo. Asiamo aporo hinamo reane, hokosa fete asikeno Kotimo unihaeaka asekea rerapo. ");
INSERT INTO faa_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Arirakano Koti unihaeaka area a hokosa apera ayiáka, peanie. Ayiáka peanafonorakano, Koti unihaeaka area a paohokosafapo. Nōmo reaki kakaro somerakaripo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yu aporo káramo Yasuaki someraka, “Tisa kotesao, ano Kotiyaki yaiya rekeakosakipoko, pipu nōmo yakapa rakiakosare?” ");
INSERT INTO faa_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Airakano Yasumo someraka, “Nómo anoaki marirakano kotesapo, airakanare? Koti ipi hákasa kotesapo. Aporo meta kotesa rekenafapo. ");
INSERT INTO faa_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kotimo somemaneane nómo hemakapurapo. Somemaneane oyapo. Hinamo hakimakopo. Aporo kukusimo rukupo. Aporo metamo makata kemoane hakimakopo. Aporo metaki kotafe topakamaraka somehokopo. Ní ata soko, ní ama soko, koteaka hemakapukua makotehoanie. Aisane nómo kaisiapo.” ");
INSERT INTO faa_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Airakano aporoamo someraka, “Ao, ano hokosa rea maiya amo someane nōmo kakimaka reane, pipu yumo soko, yaiya kakimaka rekenapo.” ");
INSERT INTO faa_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Airakano Yasumo someraka, “Né makata hakása meta siasafapo. Nómo makata kemo su roporaka, mone mosane aporo makata forokoa risiaki kakanie. Kaka farakanone, nómo ní mahimuraka taena makata ane hepene yapura tokoakosapo. Ní makata kemo kaka faraka ano patera aseako peanie.” ");
INSERT INTO faa_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Airakano aporoamo ipi kaikia ipi makata kemo kára toane metakariasisekeno asekea, ipi himu mahisiraka someane kakimasafapo. ");
INSERT INTO faa_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Kakimakanafonorakano Yasumo e asekea someraka “Makata kemo káraraka rea aporo ane, Koti unihaeaka rea paohokosane, namo kakaro kára waforohokosapo. ");
INSERT INTO faa_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Saro kamo pasu irina nitoro kakaru asia, kokoropuane tapenapo. Aina ayiáka makata kemo káraraka rea aporoane Kotimo e unihaeaka rekeasimo e paohokosane namo kakaro wafororaka paohokosapo.” ");
INSERT INTO faa_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Airakano aporomo soko, hinamomo soko, ipu kaikia someraka, “Aporo epa Kotimo asekea rekeako pasimakosare?” ");
INSERT INTO faa_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Airakano Yasumo someraka, “Aporomo someraka ‘Siahoasifareapo.’ Aisa nine Kotimo ipi rakiane siahokosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Arirakano Pitamo someraka, “Isu neyaki hakāsa pukusakipoko, isiapo apeane metakarisiapo.” ");
INSERT INTO faa_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Airakano Yasumo someraka, “Nōmo reaki kakaro somerakaripo. Aporo suamo hakása hakásaraka, Koti unihaeaka rea paohokosakipoko, ipi ape soko, ipi hinamo soko, ipi mae soko, ipi ata soko, ipi ama soko, ipi hokosane soko, su metakarikia rekeno ");
INSERT INTO faa_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ipi hauaka wo areamo makata kára yasia meta mokoakosapo. Arirakano keseke Kotiyaki kakaro yaiya rekeakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yasumo ipi aporo kenosu murikimasane karikia wakasema pukua risike someraka, “Hao, kaisie. Isu Yarusarame sitia hinakanapo. Ano Aporomanomo Tákeane porofete aporomo popasane kakaro ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Anoane parakeraka karikia pukua Yu aporohoanafonosaki kakakosapo. Karakano namina ano mahokopariraka mokoatikiraka, ano kaua torofaeraka ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ayiáka marekea ano sakomo rukusapo. Ano rusua kukusapo. Rusua kusuane yape isiamo ano turikia pukusapo.” ");
INSERT INTO faa_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Aíyaka Yasumo somesane ipi aporo hakāsa puramo himetesapo. Some kepoane faremaresakipoko someane ipu himetesapo. ");
INSERT INTO faa_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yasu Yariko taone makeraka perakano aporo hi taku tetakara mesane aporo metakiramo e mone kakasimo ikia kara fea mumiraka kayapo. ");
INSERT INTO faa_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","E kake kaiyiáne aporo yakai perakarakano kaikia someraka “Perakarakane epare?” ");
INSERT INTO faa_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Airakano ipu someraka “Nasare aporo Yasu apere.” ");
INSERT INTO faa_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Airakano aporo hi mesamo wáraka, “Yasuo, né Tefetemo aporo irao, nómo ano kamenakaraka ararerasie.” ");
INSERT INTO faa_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Airakano aporo fanaraka pesamo someraka, “Nómo Yasuane wahokopo, me fasie.” Airakano aporo hi mesamo sakepamo wáraka “Tefetemo aporo irao, nómo ano kamenakaraka ararerasie.” ");
INSERT INTO faa_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Airakano Yasumo kairaka wasuaka rukua asekea reapo. Asekea reke epo someraka, “Aporoane ano are wo karikia peae.” Airakano e karikia pesapo. Karikia perakano Yasumo someraka, ");
INSERT INTO faa_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nómo sesehoasimo nōmo ne mayiákasimore?” Airakano aporoamo ipi someraka, “Unihaeo, nōmo himo makata koteaka aseakoripo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Airakano Yasumo eaki someraka, “Nómo koteaka asesie. Nómo anoaki himu hakásaraka hemaka apura yiamo, né hi mesane mafarakayiapo.” ");
INSERT INTO faa_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Yasumo ipi aihoane, aporo hi mesa amo ipi himo wate foaka koteaka aserakano, e Yasuyaki hakāsa puraka Kotiaki kekererape pusuapo. Kekererape purakano, aporo hi mesa mafasane aporo hinamo suamo aseraka Kotiaki kara kekeresapo. ");
INSERT INTO faa_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yasu ipi Yariko taonea pauraka koraka reapo. ");
INSERT INTO faa_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Arirakano taonea aporo hakása meta rea ipi yano motosa Sakiásepo. Sakiásemo ipi makata rakirane takese mora aporoane asekea reapo. Arirakano ipi makata kemo kara sakepamo toapo. ");
INSERT INTO faa_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Asiāne Sakiáse ipi Yasu rea pukua Yasu aseako ayiane, aporo hinamo yakai sarimasakipoko mataisekeno epo Yasuane asesafapo. E aporo kinakesasamo, aporo hinamo metakirane hohoroposasamo Yasuane mataisakipoko epo asesafapo. ");
INSERT INTO faa_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Asekeanafonorakano Sakiáse ipi foaka pukua aporo yakai sarimasane marokeraka pukua, Yasu perakano aseakosakipoko ira foke asia reakipoko ira huturua hikia asekea kayapo. ");
INSERT INTO faa_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Sakiáse ipi ira huturua hikia asekea kakeno, Yasu pekea reke huturua asekea someraka, “Sakiáseo, né peae. Nómo apea ano pukusapo. Asiamo né foaka peae,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Airakano Sakiáse ira huturu yapura kayane, Yasumo peaerakano Sakiáse foakayia sosonoraka peraka someraka, “Ao, nōmo apea ne peae.” Aíyaka epo Yasuaki seseraka tati hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Arirakano Sakiásemo apea tati purakano, aporo hinamo su sarimasamo aseraka kakanakeraka someraka, “Aporo watikisamo apea Yasu kimisi apure,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Airakano Yasu ipi Sakiásemo apea pusuapo. Pukua apea yorokoa kakeno, Sakiáse ipi takahikia Yasuaki someraka, “Unihaeo, né kárapo. Hao, kaisie. Nōmo makata kemo kára taesapo. Kára taesane parakuraka tetákara hakása yineraka metakirane aporo makata forosaki kakakosapo. Anakano fana aporo metakiramo makatane nōmo hakimosakipoko, ropo kakakosapo. Aporoamo makatane hakása nōmo hakimasakipoko, nōmo makata ropo kitafa susu ayiáka kakakosapo. Aporo suamo makata kemo nōmo hakimosakipoko, nōmo makata ropo kitafa susuaka kakakosapo.” Aíyaka Sakiásemo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Airakano Yasumo someraka, “Né ereketaeraka rekeako parisasamo, pipu ne kakaro Eparahamemo aporo ira rekenapo. Sakiáse nómo Kotiaki hemakapusuasamo, nómo ní hokosamo soko, nómo ní hinamomo soko, nómo ní apea aporo risiamo, ipu suamo Kotiaki hemakapusimo, pipu Kotimo re mafasirakanapo. ");
INSERT INTO faa_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Arirakano Aporomanomo Tákeane anopo. Aporo hinamo himu watikisane nōmo kope pekea iane mafasiakosakipoko ano pesapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Yasu Yarusarame siti makeraka reke epo aporo hinamoaki some karakano ipu kaisiapo. Kaikia hemakapuraka, “Yarusarame sitia wate foaka Koti unihaeaka rekeakosane pipu makeane.” Aíyaka hemakapurakano Yasumo takumeaka someraka, ");
INSERT INTO faa_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Aporo kára metane unihaeaka mareasimo e hauaka yamenoa ");
INSERT INTO faa_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","pukusakipoko reke, ipi aporo raipa kaeyako suaki peaeaka, perakano epo someraka, ‘Reaki mone sawi tuaneti kina (K20) hakása hakásaraka nōmo karakanapo. Ano pusuakipoko mone akara one, mone metakira soko ripaka mokoakosakipoko, pisinisi rakinie.’ Aíyaka e pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","E purakano ipi aporo hakāsa risiamo eaki hisiraka, aporo metakiraki someraka, ‘E kekemarape pusie. Puraka úyaka somehoanie. “Isiapo hauaka wo ne unihaeaka areane hisiripo.” Aíyaka somehoanie.’ Airakano aporo pusiesane pukua, aporo káraki somesapo. Someaka faraka namina apea paripesapo. Paripesakipoko ");
INSERT INTO faa_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","wakesema nina, aporo unihaeaka maresane ipi hauaka paripesapo. Pariperaka aporo raipa kaeyakosu mone kasaki peaesapo. I perakano aporo unihaeamo someraka, ‘Mone nōmo reaki kasane repo pisinisi makata yakapa rakisiare? Pisinisi rakikia mone meta ripaka marekea mosare?’ ");
INSERT INTO faa_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Airakano aporo meta fana pekea someraka, ‘Unihaeo, ano mone tuaneti kina (K20) kasapo. Amo pisinisi rakikia mone tuaneti kina (K20) kaeyakosuraka ayiáka sarimaraka, tu harote kina (K200) mosapo.’ ");
INSERT INTO faa_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Airakano aporo unihaemo someraka, ‘Ao, kotehoareapo. Nómo koteaka rakireapo. Nōmo néaki wakasema kasane, nómo himu hakásaraka rakisiakipoko ape sumu kaeyakosu nómo asekea rekeasimo nōmo né marerakanapo,’ aisapo. ");
INSERT INTO faa_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Arirakano aporo raipa metamo someraka, ‘Unihaeo, nómo anoaki mone tuaneti kina (K20) kasapo. Moneamo pisinisi rakikia mone tuaneti kina kakoreasuraka ayiáka sarimaraka, wane harote kina (K100) mosapo.’ ");
INSERT INTO faa_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Airakano aporoaki, aporo unihaemo someraka, ‘Taone kakoreasu nómo asekea rekeasimo, nōmo neaki marerakanapo,’ aisapo. ");
INSERT INTO faa_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Arirakano aporo raipa metamo someraka, ‘Hao, kaisie. Nómo mone tuaneti kina (K20) anoaki kasane oyapo. Nōmo pasumo taporaka faremaresapo. ");
INSERT INTO faa_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Né aporo waresasamo ano namoraka, moneane pasumo taporaka faremaresapo. Nómo makata motoanafonosa nine, makata ane nómo morapo. Nómo hemoa makata nakosa poroanafonosa nine, makata nakosane nómo morapo.’ ");
INSERT INTO faa_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Airakano eaki aporo unihaemo someraka, ‘Né aporo watikihoareapo. Nómo anoaki someraka akipoko né hukurukusapo. Nómo someraka, “Anoane aporo warepo,” airakae. “Nōmo makata motoanafonosane nōmo morapo,” airakae. “Nōmo hemoa makata nakosa poroanafonosane nōmo morapo,” airakae. ");
INSERT INTO faa_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Asiamo nómo pisinisi rakianafonohoareane mone ane pasepukua motoafunureapo. Asiamo moneane nómo pasepukua motosa satiki mone metane ripaka marekea mokoafunureapo. Asiamo ano pariperaka mone su siaraka nōmo mokoafunureapo,’ aisapo. ");
INSERT INTO faa_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Arirakano aporo unihaemo aporo risiaki someraka, ‘Eaki mone tuaneti kina (K20) nōmo kasane repo maka, aporo raipa mone tu harote kina (K200) mosa aporoaki kakanie.’ ");
INSERT INTO faa_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Airakano ipu someraka, ‘Aporo raipa amo mone tu harote kina (K200) sia kakenapo. Ipi mone kárapo. Mone meta mayane siahoasifareapo.’ ");
INSERT INTO faa_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Airakano aporo unihaemo iaki someraka ‘Wae, aporomo makata kakeno meta soko kakakosapo. Aporo metamo makata wakasemasekeno wakasemane fimakosapo. ");
INSERT INTO faa_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Arirakano ano unihaeaka rekeakosaporakano aporo metakiramo hisisapo. Hisisa aporoamo anoyaki yunusapo. Asiamo hisisa aporoane ano rea karikia peae. Nōmo hikumisi neneme yia iane rusua kukunie.’ Aíyaka aporo unihaemo somesapo.” Aíyaka Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yasumo some kaka faraka Yarusarame sitia hiakosakipoko ipi fana hikia reapo. ");
INSERT INTO faa_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ayiáka hinaka reke Péfasi apeane soko, Petene apeane soko, makeraka ūri Orofe kikiripoa pauraka ipi aporo hakāsa pura tetáki ");
INSERT INTO faa_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Yasumo someraka “Teto ape tameyia pusie. Pukua aseane ape fariyia saro toki mano humaresa ipi matia aporo meta ripakanafonosa kita humaresa rekeno, aseakosapo. Aseraka kita fatarimaka ano area wo karikia peanie. ");
INSERT INTO faa_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Airakano aporo metamo tetoaki someraka, ‘Saro toki kita humaresane marirakano fatarimarakanare?’ Airakano tetápo someraka, ‘Saro tokiane Unihaemo makata rakiakosakipoko karikia peanie aisasamo etapo karikia purakanapo.’ Aíyaka somehoanie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Arirakano tetā hinaka, Yasumo fana tetāki makata somesane tetapō yaiya asesapo. ");
INSERT INTO faa_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Asekea saro toki mano kita humaresane tetapō fatarimarakano, saro toki wafayamo someraka, “Marirakano fatarimarakanare?” ");
INSERT INTO faa_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Airakano tetapō someraka, “Unihaemo karikia peaniesasamo etapo karikia purakanapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Asiamo saro toki manoane Yasu rea tetapō karikia pusuapo. Karikia puraka saro toki matia ipu pasu furumurikia, Yasu á ripaka maresapo. ");
INSERT INTO faa_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Arirakano Yasu saro tokia ripaka ikia kara hinakano, aporo hinamo ipu pasu mokoa pesane, ikia kara á ifunurape hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Arirakano Yarusarame siti makeraka ūri Orofe kakafaea perakano, aporo hinamo su Yasuyaki namina hakāsa sarimaraka peraka, Kotiaki suseaka kekeresapo. Ipu kekereraka someraka, “Epo Kotimo wakapuaka rakirane rakirakano, isiapo asesapo. ");
INSERT INTO faa_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Eane Unihae Kotimo hepene yapunaka pusierakano, Kotimo wakapuyaki apere. E yano motosa makama fanaraka reke Kotimo eane makotehoasimoripo. Kotimo isu mafasiakosane, hepene yapura risiamo soko, seseraka risikinapo. Kotiane isiapo makararakanapo.” Aíyaka hokono potepoteraka seseraka aporo hinamo suamo Kotiaki kekeresapo. ");
INSERT INTO faa_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kekererakano, aporo hinamo su sarimasakipoko, Ferese aporo iyaki hakasa risiamo Yasuaki someraka, “Aporo hinamo néyaki hakāsa pesaki mehokopo, aisie.” ");
INSERT INTO faa_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Airakano Yasumo someraka, “Namina himumo sesesane mayiáka metakariakosare? Ipu kekerehoanafonosa satiki, ekemo kekerehoafunupo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yarusarame sitiane makeraka pekea reke, Yasumo sitiane asekea kamenakaraka kára hemakapukua hiripusapo. ");
INSERT INTO faa_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Yasu hiripuraka reke someraka, “Yarusarame aporo hinamo reo, maiya yumo tau auaraka risikiakosakipoko, ikia kara kotesa kekemahokosane repo hemakapusua satiki, re koteaka risikiafunureapo. Asiamo maiya yumo makatane farareasasamo repo aseakosafapo. ");
INSERT INTO faa_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Keseke yunu aporo fasereperaka repo ape kaua kauraka hahaeraka topere motokoa, aporo su peraka reane rukua fahokosapo. ");
INSERT INTO faa_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Re soko, repo hokosa soko, ape kakarua risiane waseremokoa hauaka atura mokoasuraka, rusua kukukeakosapo. Arirakano ape ekemo kisiane, ekeane kotahoane ape fahokosapo. Maiya yumo Kotimo re mafasiakosapoko asiane, repo kakimakanafonosasamo mafasiakosa maiyane fasapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kotimo apea Yasu ipi yorokoa aseane, aporomo makata roporaka risikino asekea, Yasumo i rukuhoaeraka pusiesapo. ");
INSERT INTO faa_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Iaki Yasumo someraka, “Kotimo sawia popasane oyapo. ‘Nōmo apeane anoaki someaka wára kurikuri ape ayapo.’ Aíyaka Kotimo sawia popahoareapo. Asiane repo Kotimo ape one hakimora aporo risira kunikia asia maparihoareapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Arirakano maiya suamo Kotimo apea Yasumo some kasapo. Anakano Pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, aporo sisimamo soko, Yasu rusua kukusapoko ");
INSERT INTO faa_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","asiane Yasumo someane aporo hinamo suamo kakaro kaikia risikino asekea ipu someraka, “Aporo hinamo kara risia wo, mayiáka Yasuane kukusimo rukusare?” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Sere metamo Kotimo ape rurusa tua Yasu pekea, aporo hinamoaki epo some kotesane some kasapo. Some kasá maiya amo pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, aporo sisimamo soko Yasu rea pekea ");
INSERT INTO faa_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","eaki someraka, “Nómo arakirane epamo maresare? Néaki epamo ayiáka rakinie, aisare?” ");
INSERT INTO faa_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Airakano Yasumo iaki someraka, “Nōmo soko reaki makata hakása meta akai kairakanapo. ");
INSERT INTO faa_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yonemo aporo hinamo hea tapukumurianiesane Kotimo aisare? O aporomo aisare? Repo anoaki somesie.” ");
INSERT INTO faa_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Airakano ipu namina susu me rukua someraka, “Isiapo Yasuaki yakapa somehoanarakapo. Isiapo someraka, ‘Kotimo aisapo,’ aíyaka somerakanone, Yasumo isuaki someraka, ‘Marirakano Yonemo someane kakipayasare?’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Arirakano isiapo someraka, ‘Aporomo aisapo,’ aíyaka somerakanone aporo hinamo suamo isuaki mahisiraka sapehokosapo. Asiamo aporo hinamo suamo hemakapuraka, ‘Yone ipi Kotimo some kará porofete aporopo.’ Ipu aíyaka hemakapusuasamo isiapo ‘Aporomo aisapo,’ aíyaka somerakanone, isu ekemo kareakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Aíyaka namina susu tafatafaraka ipu Yasuaki someraka, “Yoneaki hea tapukumurianiesane epamo aisarakapo. Isu himeteripo.” ");
INSERT INTO faa_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Airakano Yasumo someraka, “Repo anoaki some paripeanafonosasamo, anoaki makata rakiniesa kepoane soko, reaki somehokosafapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yasumo aporo hinamoaki takumeaka someraka, “Hemo wafayamo sako karepe hemoa porokoa, aporo metakiramo asekea risikiasimo murikimasapo. Murikimaka faraka hemo wafaya hauaka meta pusuapo. Pukua ipi wate foaka paripeakosafapo, aíyaka hemakapukua hauaka meta á pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pusuakipoko sako karepe wate ikia ahera maiya amo, hemo asekea risia aporomo sako karepe wateane tumosapo. Tumokoa parakuraka hemo wafayamo somesane kaikia taehoko asiane, ipu koaretaeraka hemakapukua, hemo wafayapoko taesafapo. Arirakano hemo wafayamo ipi aporo raipaki someraka, ‘Sako karepe wateane anopoko taesane nómo mokoako pusie,’ aisapo. Pusierakano e pusuapo. Pukua hemoa perakano hemo asekea risia aporomo e rusuapo. Rukua e sako karepe wateane kakanafonoraka, nena paripusierakano e paripesapo. ");
INSERT INTO faa_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Pariperakano asekea hemo wafayamo aporo raipa metaki pusiesapo. Arirakano aporo meta kesekea pusiesane soko, hemo asekea risia aporomo rukua mokoatikiraka, sako karepe wateane kakanafonoraka nena paripusierakano paripesapo. ");
INSERT INTO faa_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pariperakano asekea yape isiamo hemo wafayamo aporo raipa metane pusiesapo. Pusiesane hemo asekea risia aporomo e rukumakasusapo. ");
INSERT INTO faa_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Arirakano asekea hemo wafayamo someraka, ‘Nōmo mayiakakosare? Nōmo nī hokosa himu tumurumo hemakapusuane pusiehokosapo. Nōmo hokosane namina mokoatikihokosafapo.’ Aíyaka epo ipi hokosa pusiesapo. ");
INSERT INTO faa_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pusierakano hokosa ane hemoa pesapo. Perakano hemo asekea risia aporomo someraka, ‘Hemo wafayamo hokosa apere. Keseke ipi wafayane kusuakipoko finihaoa e reke, hemo one epo asekea rekeasireapo. Anapaka e isina rukusapo. Rusua kurakano hemo one isiapo isina makosapo.’ ");
INSERT INTO faa_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Aíyaka hokosane ipu waseremaka ruru tapikia yao takua rukumakasuraka rusua kusuapo. Ipi hokosa rusua kurakano hemo wafayamo hemo asekea risia aporoane mayiakakosare? ");
INSERT INTO faa_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","E pekea hemo asekea risia aporoane rusua kukusapo. Rusua kurakano aporo raipa metakiramo hemoane asekea risikiasimo murikimakosapo.” Aíyaka Yasumo somerakano, aporo suamo kaikia someraka, “Uao, Epo enahoko somerakarifapo. Kakaro somerakae,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Arirakano Yasumo aporo hinamo i suane asekea someraka, “Kotimo sawia popasane oyapo. ‘Ape kira aporomo ira warupi mamakatesane maka pekea tipia maporareapo.’ Aíyaka Kotimo sawia popahoareapo. Asiamo Kotimo sawia popasane kepoane repo hemakapurakarire? ");
INSERT INTO faa_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","arirakano ira warupia aporo hinamo terafaka ruraka kakaro etehokosapo. Arirakano ira warupi maposane huruperaka rurakano kakaro rukutaihokosapo.” Aíyaka Yasumo ipi yine ira warupi ayiáka takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko someraka, “Yasumo isuane takumeaka somerakae. Asiamo yumo isiapo e waseremakoripo.” Aisa nine e haru waseremasafapo. Aporo hinamo suamo iaki sapenapaka Yasu metakarisiapo. ");
INSERT INTO faa_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Asiamo ipu Yasuane asekehaeraka aporo metakiraki maserapi pusiesapo. Pusiesane kotafe Yasu patera asesa aporo pariraka, Yasuaki maiya suamo kaikihaeraka, Yasumo hasaka somerakarihoamo, yapake akai kaisiapo. Akai kaikia epo hasaka somerakano, e waseremaka kamani unihae rea karikia pukusakipoko kaikihaesapo. ");
INSERT INTO faa_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kaikihaeraka Yasu rea aporo metakira maserapi pusuapo. Pukua ipu Yasuaki someraka, “Tisao, nómo kakaro ereketaeraka somerapo. Aporo hinamo koteaka risikiasimo nómo Kotimo someane some akare. Aporomo someane nómo some karakarifapo. Aporo hokopusuane sesehoasimo nómo some karakarifapo. Aporomo neaki mokoatikihokosane nómo hemakapurafaraka nómo kakaro some akare. Kotimo ainane nómo kakaro some akare. ");
INSERT INTO faa_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Asiamo isiapo Yu aporomo Rome aporo unihaeaki takese mone kayane siahoasireare? Kayane Kotimo somemaneane mamosohoasireare? Mayiakasireare?” ");
INSERT INTO faa_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Airakano ipu yapake someane Yasumo kairaka someraka, “Mone hae maka peae. ");
INSERT INTO faa_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Mone haeá epa hikumisi rekerire? Epa yano motosane popahoareare?” Airakano mone hae maka pesane ipu aseraka someraka, “Rome aporo unihae Sisa hikumisireapo. Sisa ipi yano motosa popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Airakano Yasumo someraka, “Rome aporo unihaemo menane ipiaki kakanie. Arirakano Kotimo menane Koti ipiaki kakanie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yasumo hasaka somehoanafonorakano, maserapi pesa aporoane fofasapo. Ipu someraka, “Yapake somesane Yasumo hemaka apure. Aporo suamo kaiyisimo epo hasaka somerakarihoamo yapake kaisiapo. Asiane yapake someane epo hemakapuraka hasaka somesafapo.” Aíyaka namina fofaraka makata meta Yasuaki somesafapo. ");
INSERT INTO faa_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Satusi aporomo hemakapuraka, “Aporo kusuane maturikia taenafapo,” aíyaka hemakapusuapo. Asiamo Yasu rea Satusi aporo i pekea someraka ");
INSERT INTO faa_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tisao, Mosesemo somemane popasane oyapo. Aporo metamo ipi mamaneamo hokosa hokono mareanafonoraka kurakano asekea, hinamo yaroane aporo kusuamo ipi mamaneamo arumarapo. Aporo kusua amo hokosa wainenaka sikiraka wainasimo, hinamo yaroane, ipi mamaneamo arumarapo. Aíyaka somemaneane Mosesemo popahoareapo. ");
INSERT INTO faa_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Arirakano aporo ipi mamanea yatipinusu risiapo. Mamanea fanamo hinamo arumasane, hokosa hokono mareanafonoraka kurakano, ");
INSERT INTO faa_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","mamanea kusuamo patera yiamo hinamo yaroane arumasapo. Epo soko hokosa hokono mareanafonoraka e kusuapo. ");
INSERT INTO faa_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kurakano epo patera yiamo hinamo yaroane arumasapo. Epo soko hokosa hokono mareanafonoraka kusuapo. Ayipe pukua mamanea yatipinu suamo hinamo yaro hakásane arumape pukua, hokosa hokono maresafapo. ");
INSERT INTO faa_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Keseke hinamo manokonomasane kusuapo. ");
INSERT INTO faa_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kusua maturikia taeana maiya amo, hinamoane epamo hinamore? Eane aporo mamanea yatipinu suamo arumasapo.” ");
INSERT INTO faa_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Airakano Yasumo someraka, “Hauaka wo aporomo hinamo arumarapo. ");
INSERT INTO faa_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Arirakano keseke kusua maturikia taeana maiya amo Kotimo someraka, ‘Ne anoyaki hakāsa rekeako peae.’ Airakano aporoane hepene yapura hinaka hinamo arumakosafapo. ");
INSERT INTO faa_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Namina hepene aporo arisia ayiáka risikiakosapo. Arirakano kurafapo. Aporo kusua maturikia taerakano i kakaro Kotimo hokosapo. ");
INSERT INTO faa_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Arirakano aporo kusua maturikia taena kepoane Mosesemo hemakapusuapo. Ira fete reakipoko arakarua ira rufisa nine, irane iramo inasafapo. Inakanafonorakano Mosesemo aseako puraka, Kotiaki someraka, ‘Unihaeo, ne Eparahamemo Kotipo. Ne Aisakemo Kotipo. Ne Yakopemo Kotipo.’ ");
INSERT INTO faa_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aíyaka Mosesemo somesa amo kepoane oyapo. Aporo kusuane maturikia taehoanafonosane, ane, Mosesemo someraka, ‘Ne Eparahame, Aisake, Yakope ipu Kotipo,’ aihokosafapo. Asiamo Kotiane aporo hinamo hitafe risiamo Kotipo. Aporo hinamo kukua kesamo Kotifapo. Kotiaki hemakapukua reane eyaki yaiya rekeakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Aíyaka Yasumo somerakano Kotimo somemane tisa aporomo someraka, “Tisao, nómo someane kakarorakae.” ");
INSERT INTO faa_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Aíyaka Yasuaki akai kaiyakosapoko asiāne ipu someane epo hurutapirakano asekea, eaki efera hunia makata meta akai kaisiafapo. ");
INSERT INTO faa_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yasumo iaki someraka “Keresoane, Tefetemo aporo ira amo wainakosapo, airakane marirakanore? ");
INSERT INTO faa_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Same púkua Tefetemo popasane oyapo. Nōmo Unihaeaki Unihae Kotimo someraka, ‘Né ano hokono tumuru takua kayae. Hokono tumuru takua aporo hokopusua akaya ayiáka kayae. ");
INSERT INTO faa_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Kakeno nómo yunuane nōmo rukumosaka tapiakosapo.’ Aíyaka Kotimo somesane Tefetemo popahoareapo. ");
INSERT INTO faa_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Asiamo Tefetemo Keresoaki someraka, ‘Ne nōmo Unihaepo,’ aisane marirakano aisare? Arirakano makasa kauamo ipi hokosa wainepe pukusaki ‘Unihaepo,’ airafapo. Asiamo Tefetemo Keresoaki ‘Unihaepo’ aisasamo, Tefete takapeasiraka Keresoane wate fana yaiya reapo. Asiāne repo someraka, ‘Tefetemo wainepe pesa á Kereso faserepeakosapo,’ airakae. Airakane marirakanore?” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Aporo hinamo suamo kaiyisimo, Yasumo ipi aporo hakāsa puraki someraka, ");
INSERT INTO faa_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Kotimo somemane tisa aporomo arakira ayiáka, repo soko ayiáka rakiakopo. Ipu pasu horopokara osoraka pukua, aporo hinamo sarimaraka risiakipoko á i pukua, aporomo i hokono maraka iane makáraraka someraka, ‘Tisa kárao,’ aihoasimo namina kára sesenapo. Arirakano Yu aporomo sarimana apea soko i pukua aporo hinamo su sarimaraka toakipoko, i kumisi neneme sapea sea tokoako sesenapo. Arirakano hokono akera maiya amo, aporomo i makárahoasimo aporo hokopusuamo sea tokoako sesenapo. ");
INSERT INTO faa_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Arirakano hinamo yaromo ape soko makata kemo soko Kotimo somemane tisa aporomo hakimorapo. Hakimoraka yia i kotehoareapo, aihoasimo ipu kurikuriraka risike some nokone pukua kurikurinapo. Asiasamo iane fanasihokosane kárahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Kotimo apea maua motosakipoko aporomo mone Kotipoko kakakosane maua á kesapo. Yasumo aseane makata kemo kára toa aporo hinamo ipu suamo mone kára kerakano asesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Arirakano hinamo yaro hakása meta makata forokoa kayasasamo, ipi mone hae kusua tetá makerakano asesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Makerakano asekea Yasumo someraka, “Aporo hinamo suamo mone kesane, hinamo yaroamo mone makesamo kakaro marokesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Arirakano aporo hinamo suamo namina mone kára tokeno yia sapeane Kotiaki kasapo. Arirakano hinamo yaro ipi makata forokoa kayasasamo, mone wakasema kaya ane su maka pekea kasapo. Epo ane su karaka, ipu moneane parakuraka sape metakira namina ape yia taesapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Maiya amo aporo metakiramo Kotimo apeane aseraka someraka, “Kotimo apeane namo kakaro kotesapo. Kotimo apeane eke káramo kisiapo. Arirakano aporomo makata yaku taeraka apeane kau rakikia makotesapo.” ");
INSERT INTO faa_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Airakano Yasumo someraka, “Pipu repo aserane makata kotesane repo aserakanapo. Arirakano keseke maiya metamo, apeane eke ripaka kisiane, ekeane kokoro mokoteraka hakása hakásaraka tokoakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Airakano ipu someraka, “Tisao, nómo somerakane masinaka ayiakakosare? Ayiakakosane isiapo hemakapusimo makata yakapamo isuaki tariakosare?” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Arirakano Yasumo someraka, “Aporo metakiramo reaki kotafe somerakano, someane kakimarapaka asekeanie. Aporo yakaimo ano yano hokoa peakosapo. Pekea ipu kotafe someraka, ‘Ano Keresopo. Ano unihae kara rekeasimo murikimasa aporoane anopo. Asiamo fahokosa maiyane makepo.’ Airakano someane repo kakimakopo. ");
INSERT INTO faa_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Asiamo aporomo ape sumu metayaki werakanaporakano repo kairaka namohokopo. Arirakano aporomo kamani aporoaki hisiraka yunu weakosapo. Werakanaporakano repo kairaka namohokopo. Makata ane fana peakosapo. Asiamo fahokosa maíya ane haru faserepeakosafapo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Aíyaka efera hunia Yasumo someraka, “Aporo hauaka meta á risiamo, aporo hauaka meta á risiaki yunu werakano, arirakano kamani metamo, kamani metayaki yunu werakano ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Arirakano hauaka kekepoa momani kára peakosapo. Hauaka kekepoa makata nakosa faraka aporo hinamo kára meamohokosapo. Hauaka kekepoa makata tasa kára ikia peakosapo. Arirakano ti yapura makata meta haku tarirakano aporo hinamomo asekea namohokosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Arirakano makata ane suane faserepeasiraka re waseremokoa, rukua mokoatikihokosapo. Waseremokoa Yu aporomo sarimana apea karikia pukua, hukurukua tipura keakosapo. Asiamo anoaki himu hakásaraka risiakipoko re waseremokoa, kamani aporo unihae rea á soko, arirakano hauaka asekea risia aporo risia á soko, re karikia pukua hukurukusapo. ");
INSERT INTO faa_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Reaki hukuarura maiya amo repo anoane makáraraka somehokosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Re waseremarakano re himu fahokopo. ‘Isu hukururakano isiapo maíyaka somehoaere?’ Aíyaka hemakapukopo. ");
INSERT INTO faa_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Asiamo repo koteaka hemakapukua somehoasimo, koteaka hemakapurane soko, koteaka somerane soko, nōmo reaki karakano repo koteaka somehokosapo. Repo koteaka somerakano, hukurura kepo kaira aporomo reaki someraka, ‘Nómo paroaka somerakano, nōmo yakapa some paripeasifareapo,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Arirakano reane hukurukusakipoko, ní amamo, ní atamo, ní maemo, ní aporo tákemo, ní moremo, re waseremokoasimo parakehokosapo. Namina yia metamo metane rusua kukusapo. ");
INSERT INTO faa_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Re ano patera asesasamo reane aporo suamo hisihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Asiamo repo uni iti hakása soko fipukusafapo. ");
INSERT INTO faa_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Arirakano repo anoaki himu hakásaraka yaiya hemakapuraka risikino fareanane repo makosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Arirakano Yasumo some meta someraka, “Yunu aporo peraka Yarusarame siti kaua aporo kauraka hahaeraka toperemotokoa, ape tipia marerakano, maiya amo repo asekea hemakapuraka, ‘Maiya omo Yarusarame siti marakaritaeraka aporo su rukumarutaehokosapo,’ aíyaka repo hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Asiamo maiya amo re Yutía hauaka á risiane teketarikia ūria hinie. Arirakano re Yarusarame sitia risiane apeane metakarikia punie. Maiya amo re yaoa risiane Yarusarame sitia poparipeakopo. ");
INSERT INTO faa_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Asiamo makata ane fasereperakano repo asekea hemakapuraka, ‘Kotimo sawia popasane oyapo. Kotimo maropohokosa maiya ane fasere peakosapo, aíyaka popasane kakaro faserepesapo,’ aíyaka repo hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Arirakano hinamo hokosa umisa soko, hinamo hokosa kiri kaīyia soko, teketarikia puane waforohokosapo. Asiamo hauaka wo aporo hinamo risiaki makata kára mokoatikihokosane soko, Kotimo kára sapenane soko faserepeakosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Arirakano yunu aporo metakiramo Yu aporo hinamoane ferepemo karekea rukutaehokosapo. Arirakano pekea Yu aporo hinamo metakira waseremokoa hauaka kekepoa karikia pukusapo. Arirakano Yu aporohoanafonosamo Yarusarame sitiane rakaritaeraka i mokome koraka risikiakosapo. Koraka risina hisiraka keseke metakariakosa maiya ane paurakano Yu aporohoanafonosamo Yarusarame sitiane metakarikia poparipukusapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yasumo someraka, “Ti yapura sere maiyane soko, ere maiyane soko, ti makata soko, hakuraka risikiakosane Kotimo tarirakano, aporo hinamo suamo aseakosapo. Arirakano he tawara kupa kára peraka urakano, aporo hinamomo kairaka fofaraka, arirakano aporo hinamo hauaka kekepoa risiamo soko, kairaka kára fofaraka himu fahokosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Arirakano hauaka sua makata haku fasereperakano aporo hinamomo aseraka kára fofaraka namoraka hamisisiraka ku peakosapo. Arirakano Hepene yapura makata kára risiane soko mahohohokosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Maiya amo aporo hinamo ipu aseane Aporomanomo Táke anoane pariperaka, ti pakaea wakapuyaki faesayaki perakano aseakosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Asiamo nōmo makata someraka one kepomarekea fasereperakano, ereketaeraka risike mapiraraka asekea risikianie. Re mafasikia pasimokoakosa maiyane makerakanapo.” Aiyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Aporo hakāsa puraki Yasumo takumeaka someraka, “Ira foke soko ira suane asekea hemakapunie. ");
INSERT INTO faa_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ira kuane konokoarakano repo asekea someraka, ‘Kupa kakako makerakanapo.’ Aíyaka repo somerapo. ");
INSERT INTO faa_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Repo ira ku konokoasa asera ayiáka, nōmo ayiakakosaposane kepomarekea fasereperakano, repo asekea hemakapuraka, ‘Kotimo unihaeaka rekeakosa maiyane makerakanapo.’ Aíyaka hemakapunie. ");
INSERT INTO faa_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Hao, kaisie. Nōmo reaki kakaro somerakaripo. Aporo hinamo maiya hakása yiamo hokono murisiane i kukusiraka, nōmo makata ayiakakosaposane kepomarekea fasereperakano, ipu yaiya kakaro aseakosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Arirakano ti yapurane soko, hauaka one soko, keseke fahokosapo. Arirakano nōmo someane fahokosafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yasumo someraka, “Repo hasakanapaka asekeanie. Repo makata nako fitiraka, he watikisa nekea, hauaka wo makata aki kára hemakapukua, ayiáka risikiakopo. Watikiaka risikiakopo. Ano peakosa maiya amo ano foaka peakosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Asiamo makata kakayia kakinumo foaka arura ayiáka, hauaka sua aporo hinamo suane hukuarura maiya amo, foaka ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ayiakakosa maiya ane himetenapaka hemakapukua risikianie. Re kára wakakopo. Makata umisa perakano, wakapuaka risikiako kurikuriraka risikianie. Aporomanomo Tákeane anopo. Ano rea hikumisi nenemea re namonafaraka kaiyanafaraka mapiraraka risikiako maiya suamo kurikurihoanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Maíyamo Kotimo apea Yasumo some kaka, ereamo ūri Orofea hikia reapo. ");
INSERT INTO faa_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mituru fiarakano Kotimo apea paripuraka aporo hinamo suamo Yasumo someane kaiyako perakano epo some kasapo. Ayiáka sere suamo kaiyako perakano Yasumo some kasapo. ");
INSERT INTO faa_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ape Farimaresa Hemakapuko Hokono Keraka, Yu aporo hinamomo Farawa Pirianafononane paikia nesapo. Hokono akera maiya ane makerakano ");
INSERT INTO faa_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","pirisiti aporo káramo soko, Kotimo somemane tisa aporomo soko, ipu hemakapuraka, “Yasu mayiáka rusua kukusare?” Aíyaka ipu hemakapuraka, aporo hinamo su sarimasane aseraka i namoraka risiapo. ");
INSERT INTO faa_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Aporo hakāsa pura hakása meta yano motosa Yutase Isekeriopo. Yutase Isekerio ane Satanemo e ho marakano asekea, e pukua ");
INSERT INTO faa_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","pirisiti aporo kára soko, Kotimo ape asekea risira Yu aporo terakaiyamosa satini soko, i risiakipoko epo someraka, “Yasu ane nōmo uyaka parakehokosapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Airakano ipu kaikia seseraka someraka, “Parakehoasimo isiapo neaki mone kakakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Airakano epo aosapo. Epo hemakapuraka, “Aporo hinamo su pukua fasakipoko Yasuane nōmo parakehokosapo.” Aíyaka hemakapuraka parakehokosa ikia karane kosapo. ");
INSERT INTO faa_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Farawa Pirianafonona paikia anena maiya amo Yu aporomo saro sipi mano rurapo. ");
INSERT INTO faa_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Maiya amo Yasumo Pitape Yone tetāki someraka, “Ape Farimaresa Hemakapuko Hokono Keraka, isiapo makata nakosane tetápo sarimaraka taehoanie.” ");
INSERT INTO faa_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Airakano tetapō someraka, “Ape ma sarimaraka taehokosare?” ");
INSERT INTO faa_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Airakano Yasumo someraka, “Teto Yarusarame sitia pusie. Pukua aseane aporo metamo he petoroa takamaka makatiraka maka perakano tetápo sapenakosapo. E sapenekea purakano tetápo kekemarape punie. Pukua e apea yorokoa purakano, teto soko apea yorokoa pukua, tetápo ");
INSERT INTO faa_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ape wafayaki someraka, ‘Tisamo someaka maresane oyapo. Ape Farimaresa Hemakapuko Hokono Keakosakipoko nōmo aporo hakāsa purayaki sarimaraka, ape kakaru sape ma sarimaraka makata nakosare? Aporo kimisi pesa akipoko ape rumu mayare?’ ");
INSERT INTO faa_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Airakano ape wafayamo, teto ape huturua karikia hikia, ape rumu kára tariakosapo. Apea sea soko, teporo soko, toane tariakosapo. Tarirakano ape á tetápo makata nakosa sarimaraka taehoanie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Asiamo Yasumo someaka marerakano tetā pukua, apea pauraka Yasumo ayiakakosapo aisane yaiya rakirakano asesapo. Aseraka hokono keakosakipoko makata nakosa sarimasapo. ");
INSERT INTO faa_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Sarimarakano keseke maiya tuakeramo Yasu soko ipi aporo hakāsa pura soko, ape á pekea, teporoa makeraka sea á sú sarimaraka toapo. ");
INSERT INTO faa_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Arirakano i makata nenaka toa maiya amo, Yasumo iaki someraka, “Ano kau teraka himu nakosane, nasiraka hokono keraka isina hakāsa toke makata nenaka seserakanapo. ");
INSERT INTO faa_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ape Farimaresa Hemakapuko Hokono Keraka makata nakosane nōmo efera hunia hauaka wo hokono keakosafapo. Koti unihaeaka rea hauaka á hokono akera maiya amo, hokono kera kepoane repo kakaro hemakapukua nakosapo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Asiamo waene heane kapoa takamasane, Yasumo maka Kotiaki suseaka rumaraka aporoaki someraka, “Kapo he one masie. Maka repo fete feteaka nesie. ");
INSERT INTO faa_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Waene heane hauaka wo nōmo efera hunia nakosafapo. Koti unihaeaka reamo hauaka á nakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Aíyaka Yasumo farawa maka Kotiaki suseraka faraka, farawa mosoraka aporo hakāsa puraki kaka someraka, “One ano kaupo. Repoko ano kau kakakosapo. Ano kukusane hemakapuko nesie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","I toke makata nekea faraka, Yasumo kapoane maka reke someraka, “Aporomanoaki Kotimo some kawe someaka marakanapo. Someaka marane aporo hinamo suamo kakimaka kekemahoanie. Asiamo Kotimo aporo hinamo suane arareraka mafasiakosakipoko, ano kuraka ano yapi pukusapo. Ano yapi purakano repo aseraka hemakapuraka, ‘Kotimo someaka masane ayiane,’ aíyaka hemakapunie. ");
INSERT INTO faa_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Asiane ano parakehokosa aporoane anoyaki hakāsa teporoa kakenapo. ");
INSERT INTO faa_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Arirakano Aporomanomo Tákeane anopo. Ano ayiakakosane wate fana Kotimo someaka maresapo. Someaka maresasamo hakása yine ayiakakosapo. Uao. Ano parakeana aporoane enahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Airakano ipu namina susu someraka, “Isu hakása meta epamo eane parakehokosare?” Aíyaka namina susu me rukua somesapo. ");
INSERT INTO faa_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yasumo ipi aporo hakāsa puramo namina tafatafaraka someraka, “Isu aporo arisia one epa fanare?” Airakano aporo metamo someraka, “Ano fanapo.” Airakano aporo metamo someraka, “Wae, né fanafapo. Ano fanapo,” aíyaka tafatafasapo. ");
INSERT INTO faa_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tafatafarakano, Yasumo iaki someraka, “Yu aporohoanafonosa ipu namina aporo unihaemo kára masamasarapo. Masamasarakano unihaeaki ipu someraka, ‘Aporo hinamo ararenane éreapo,’ airapo. ");
INSERT INTO faa_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Asiamo repo ayiáka masamasahokopo. Ne fanaraka unihaeraka reane hokosa raua pariraka rekeanie. Né káraraka reane aporo raipa pariraka rekeanie. ");
INSERT INTO faa_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Aporo fanane epare? E teporo makeraka kayane fanare? Arirakano epo makata nakosa paikia mokoa pekea teporoa taesa aporoane fanare? Repo hemakapuraka, ‘E teporoa makeraka kayane fanapo,’ repo airapo. Asiane ano reyaki reke makata rakiraka rekenapo. ");
INSERT INTO faa_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ano kau aseakosakipoko mokoatikirakano, repo ano metakarisiafapo. Anoyaki hakāsa yaiya risikinapo. ");
INSERT INTO faa_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nōmo unihaeaka asekea rekeasimo, nōmo Atamo ano murikimasa ayiáka, re unihaeaka asekea risikiasimo, nōmo re murikimarakanapo. ");
INSERT INTO faa_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Murikimaka ano unihaeaka rea hauaka á nōmo reaki someraka, ‘Makata nakosa soko, he soko, nasimo nōmo teporo makeraka toae. Isiraya aporo ira kenosu makata hukurura kepo kaira aporomo rakira ayiáka repo rakisimo aporo hokopusuamo sea toae.’ Nōmo aihokosapo. Makata hukurura kepo kaira aporomo rakira ayiáka repo rakisimo pipu murikimarakanapo.” Aíyaka Yasumo ipi aporo hakāsa pura keno suaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yasumo someraka, “Saemoneo, Saemoneo, kaisie. Hemo wafayamo witi hae tumosane kau kikisiraka haku taeraka, namoane kikisiraka haku taena ayiáka Satanemo re kau aseakosakipoko epo ayiáka rakiakosapo. ");
INSERT INTO faa_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Asiane rakiakorakano nepoko nōmo kurikurisapo. Anoaki soko, Kotiaki soko, nómo yaiya himu hakásaraka hemakapusimo nōmo kurikurisapo. Nómo ano metakarikia, efera hunia rekeako parihokosapo. Rekeako pariraka ní maemo ano koteaka hemakapusimo ararehoanie.” ");
INSERT INTO faa_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Airakano Pitamo Yasuaki someraka “Né tipura purakano, ano soko neyaki hakāsa tipura pukusapo. Né kurakano, ano soko neyaki hakāsa kukusapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Airakano Yasumo someraka, “Nōmo kakaro somerakaripo. Kokoroko mehoasiraka nómo yape isiamo ‘Yasu nōmo aserafapo,’ aihokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yasumo aporo hakāsa pura keno suaki someraka, “Fana nōmo reaki someraka, ‘Pausi soko, ku soko, tamaka soko metakarikia pusie.’ Airakano re pusua sereamo makata su siasare? Makata meta fesenosare?” Airakano ipu someraka, “Wae, makata su siasapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Airakano Yasumo someraka, “Pipu yumo re puraka pausi kakeno maka punie. Ku soko maka punie. Poke fasekeno pasu roporaka mone masamo poke ropohoanie. ");
INSERT INTO faa_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Asiamo Kotimo sawia anoane popasane kakaro ayiakakosapo. Aíyaka popasane oyapo. ‘Aporo watikisa rusua kurakano ano iyaki hakāsa rusua kukusapo.’ Aíyaka popasane pipu ayiakakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Airakano aporo hakāsa puramo someraka, “Unihaeo, asesie. Poke teta kakenapo.” Airakano Yasumo someraka “Siareapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Apeane Yasumo metakarikia, ūri Orofea hisiapo. Á ipi hikianasamo aporo hakāsa pura soko, e kekemarape hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Hikia hauaka á pauraka, Yasumo iaki someraka, “Re kau aseakosa makata umisa fasereperakano ane, kekemaraka watikiaka rakipe purapaka kurikurihoanie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Asiamo aporomo wakasema yamenoa eke makasuna ayiáka, Yasu wakasema yamenoa pukua, kakuna porokoa kake kurikuriraka, ");
INSERT INTO faa_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Atao, nómo anoaki makata umisa maresapo. Makata umisa metakariakosane siasekenone, nómo metakarisie. Asiamo nōmo hemakapusuane ayiakakopo. Nómo hemakapusuane ayiakanie.” ");
INSERT INTO faa_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Aíyaka kurikuriraka rekeno, hepene aporo pekea Yasuane wakapu kaka maresapo. ");
INSERT INTO faa_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Wakapu kaka marerakano, Yasu ipi himu kára nekea kára kurikuriraka, ipi kaua kikipu apura ayiáka yapi pusuapo. Yapi pukua hauaka hurupesapo. ");
INSERT INTO faa_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Arirakano kurikuriraka faraka Yasu takahikia aporo hakāsa pura toakipoko peraka aseane, i himu nekea wakakesekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Asekea i maturikia someraka, “Marirakano re waka kerakanare? Turikia tarikia re kau aseakosakipoko makata watikiaka rakirapaka kurikurisie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Arirakano Yasumo somesa maiya yiamo aseane, Yasumo ipi aporo hakāsa pura aporo hakása meta yano motosa Yutasemo aporo yakai karikia, Yutase ipi fanaraka perakano asesapo. Pekea Yasuane makanurakorakano ");
INSERT INTO faa_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yasumo someraka, “Yutaseo, nómo ano parakehoko makanurakanare?” ");
INSERT INTO faa_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Airakano aporo hakāsa puramo makata fasere peakosane hemakapukua someraka, “Unihaeo, isiapo ferepemo ruaere?” ");
INSERT INTO faa_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Aíyaka aporo hakāsa pura metamo ferepe teaka maka, pirisiti aporo fanamo ipi aporo raipa senaki tumuru takuane, ferepemo rukusakaretapisiapo. ");
INSERT INTO faa_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Rukusakaretapirakano Yasumo someraka, “Ayiakakopo.” Aíyaka Yasumo aporo raipane senaki sakairaka mafasapo. ");
INSERT INTO faa_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mafaraka aseane pirisiti aporo kára soko, Kotimo apeane asekea risia aporo terakaiyamosa soko, Yu aporo sisima soko e waseremako perakano asekea Yasumo iaki someraka, “Repo ferepe mokoa, poke mokoa aperane, repo ano aporo hakimarasekeno asekea waseremako perakanare? ");
INSERT INTO faa_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sere káramo Kotimo apea ano reke somerakano repo ano waseremasafapo. Asiane yumo ere susuamo suaka taeraka reke, repo makata watikiaka rakiakosa maiyane fasere apera oyareapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Aporo yakai pesamo Yasu waseremaka pirisiti aporo fanamo ipi apea karikia pusuapo. Karikia purakano Pita kesekea kekemarape pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kekemarape pukua pirisiti aporo fanamo apea pauraka hauaka moro tipia aporomo ira paikia haraka toakipoko Pita pekea iyaki hakasa kayapo. ");
INSERT INTO faa_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ira paisia rufiraka faerakano aseane, Pita kakeno hinamo raipa metamo hi susuamo koteaka asekea takekea someraka, “Aporoane soko Yasuyaki hakāsa purapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Airakano Pitamo someraka, “Wae, hinamo neo, Yasuane nōmo aserafapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Airakano asekea wakasema tuina, aporo metamo Pita asekea someraka, “Yasumo aporo hakāsa pura meta nepo.” Airakano Pitamo someraka, “Wae, anofapo. Eane nōmo aserafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aíyaka wakasema tuina wane awa farakano, aporo metamo Pita asekea someraka, “Aporoane fana Yasuyaki hakāsa pusuapo. E Yasumo aporo hakāsa purareapo. Namo kakaroripo. E Kariri aporopo.” ");
INSERT INTO faa_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Airakano Pitamo someraka “Wae, ape neo, nómo somerakane ano himeteripo.” Aíyaka somehora maiya yiamo, kokoroko mesapo. ");
INSERT INTO faa_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kokoroko merakano, Unihae Yasumo pariaseraka Pitane hi susuamo asesapo. Aserakano, ipi somesane Pitamo hemakapusuapo. Hemakapuraka, “Pipu kokoroko mehoasiraka nómo ano aserafapo, aihokosapo,” aisane Pitamo hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ayiáka hemakapuraka Pita ipi takahikia pukua himu kára nekea kára hiripusapo. ");
INSERT INTO faa_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Arirakano Kotimo ape asekea risia aporo terakaiyamosa metakiramo Yasu mainamarekea rusuapo. ");
INSERT INTO faa_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Rukua Yasu hia pasumo taporaka someraka, “Ne epamo rurakarire? Porofete aporomo makata asekeanafonosane somerapo. Somera ayiáka, nómo soko ayiáka somesie.” ");
INSERT INTO faa_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Aíyaka Yasuaki some watikisa metakira soko someraka, e mokoatikisapo. ");
INSERT INTO faa_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Mituru fiarakano Yu aporo sisima soko, pirisiti aporo kára soko, Kotimo somemane tisa aporo soko, namina sarimasa ape á Yasu karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Karikia pukua ipu someraka, “Unihae máfaraka maresa Keresoane nere? Nómo hufitaeraka somesie.” Airakano Yasumo someraka, “Nōmo reaki somehokosapoko asiane, repo kakimakasifareapo. ");
INSERT INTO faa_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nōmo reaki makata akai kairakanone, repo anoaki some sia paripeasifareapo. ");
INSERT INTO faa_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pipu kepomarekea pukua, keseke Aporomanomo Táke anoane Koti Káramo hokono tumuru takua kakeno, repo aseakosapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Airakano ipu someraka, “Kotimo hokosane nere?” Airakano epo someraka “Repo namina someraka ayapo.” ");
INSERT INTO faa_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Airakano ipu someraka, “E hukuruko aporo meta peaehokosafapo. Epo ipi yiamo Koti mawakasemaraka somerakano isiapo kairakaripo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Aporo su sarimasane takahihiraka Pairate rea Yasuane karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Karikia pukua Pairate rea pauraka Yasuane hukurukua someraka, “Isiapo Yu aporomo hasaka rakisimo Yasumo kirimasapo. Epo isu kirimaraka some kasane oyapo. ‘Kamani unihae Sisaki takese mone kakakopo. Ano Unihaepo. Ano Keresopo.’ Aíyaka epo somerakasupo.” ");
INSERT INTO faa_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Airakano Pairatemo Yasuaki someraka “Yu aporomo unihaeane nere?” Airakano Yasumo someraka “Nómo ní someraka ayapo.” ");
INSERT INTO faa_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Airakano Pairatemo pirisiti aporo káraki soko, aporo hinamo yakai su sarimasa iaki soko someraka, “Aporoamo makata watikiaka rakisia nōmo hemakapurakarifapo.” ");
INSERT INTO faa_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Airakano ipu wakapuaka someraka, “Yutía hauaka soko, Kariri hauaka soko, epo hauaka wo soko, aporo hinamo suamo Rome kamaniaki saperaka weasimo kirimaraka somerakasupo. Epo someane aporo hinamo suamo kaikia, Rome kamaniaki mahisiraka rakumarekea risiapo.” Aíyaka kotafe topakamaraka Yasuane hukurusuapo. ");
INSERT INTO faa_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Aporo su sarimasamo someane Pairatemo kairaka someraka “Aporoane Kariri aporore?” Airakano ipu suamo aosapo. ");
INSERT INTO faa_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aorakano Pairatemo someraka, “Kariri hauakane nōmo asekea rekenafapo. Herotemo asekea rekenapo. Herote rea karikia pusie.” Airakano Herote Yarusarame sitia kimisi pekea reakipoko, Yasu karikia á pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Asiamo fana Yasu Kariri hauaka rea maiya amo, epo makata rakisiane Herotemo kairaka hemakapuraka, “Yasumo wakapumo hemakapukua rakirane aseakoripo.” Aíyaka Herotemo hemakapuraka reakipoko, e rea Yasu karikia perakano Yasuane Herotemo aseraka sesesapo. ");
INSERT INTO faa_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Arirakano Yasuaki Herotemo hunia kaikia, efera hunia soko kaikia, ayiane Yasumo makata meta somesafapo. ");
INSERT INTO faa_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Somehoanafonoraka me kauraka rekeno, pirisiti aporo kára soko Kotimo somemane tisa aporo soko i makeraka risiamo Yasuaki memo iriraraka hukurusuapo. ");
INSERT INTO faa_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hukururakano Herotemo soko ipi aporo terakaiyamosamo soko Yasuane mainamareraka kearaka, Yasuane pasu kára kotesane osoraka marekea someraka, “Pairate rea paripusie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Aisa sereamo, Herotepe Pairate tati moresapo. Fana tati mahisiraka risiane sereamo, mahisiraka risiane faraka tati moresapo. ");
INSERT INTO faa_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pairatemo someraka, “Re aporo su peae. Pirisiti aporo soko aporo kára soko re su peae.” Aíyaka aporo su Pairate kayakipoko pekea sarimarakano ");
INSERT INTO faa_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Pairatemo someraka, “Repo fana aporoane karikia pekea someraka, ‘Isiapo watikiaka rakisimo epo tarirapo.’ Aíyaka repo hukururakano nōmo eaki hunia soko, hunia soko, kaisiapo. Re risiakipoko re hikumisi yia Yasu pekea rekeno, nōmo eaki kaisiapo. Kaiyiáne repo somesa ayiáka, epo rakisiafapo. Aíyaka nōmo hemakapurakaripo. ");
INSERT INTO faa_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herotemo soko someraka, ‘E karikia paripusie.’ Aisasamo Yasumo makata watikiaka rakisiane Herotemo asesafapo. Asiamo Yasuane rusua kuane siahoasifareapo. E rusua kukusapo airakane, epo makata meta watikiaka rakisiafapo. ");
INSERT INTO faa_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Asiamo sako patesamo e rukua farakano, e nōmo tonotaehokosapo.” ");
INSERT INTO faa_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","19","Aíyaka Pairatemo somerakano, aporo suamo someraka, “Wae, e kukusimo runie. Parápase tonotaehoanie,” aisapo. Aihoasiraka fana aporo suamo weasimo Parápasemo kirimasapo. Epo aporo meta rusua kusuapo. Rusua kurakano, Parápase tipura makesapo. Arirakano Ape Farimaresa Hemakapuko Hokono Akera maiya amo, aporo tipura kesane hakása tonotaenapo. Ainasasamo Parápase tonotaehoasimo, aporo suamo Parápase yano hokoa wásapo. ");
INSERT INTO faa_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Yano hokoa warakano, Pairatemo Yasuane tonotaehokosakipoko hemakapukua, efera hunia aporo hinamo suaki somerakano, ");
INSERT INTO faa_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ipu suamo someraka, “Wae, Yasu ira matopesa paremarekea rusua kukunie. Ira matopesa paremarekea rusua kukunie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Airakano efera hunia yape isiamo Pairatemo aporo hinamo suaki someraka, “Marirakano e rusua kukunie, airakanare? E rusua kukunie airakane, epo watikiaka rakisiafapo. E rusua kuane siahoasifareapo. E kamaka nena yia rurakano eane nōmo tonotaehokosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Airakano aporo hinamo suamo sakepamo wakapuaka someraka, “E ira matopesa paremarekea rusua kukunie. Metakariakopo.” Aíyaka Pairatemo someane ipu rukutopakatapikia namina someane hákasa wakapusapo. ");
INSERT INTO faa_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wakapurakano ipu namina hemakapusua ayiakasimo Pairatemo aporoaki someraka, “Yasu rusua kukunie. ");
INSERT INTO faa_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Parápasemo aporo suamo weasimo kirimaraka, aporo meta rusua kurakano asekea, e tipura makesane tonotaerasie. Yasu karikia punie. Repo namina Yasu rusua kukuniesasamo, nōmo aporo terakaiyamosaki Yasu rusua kukunie, airakanapo.” Aíyaka Pairatemo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Rome aporo terakaiyamosamo Yasu karikia, ikia otoa puraka risiakipoko, aporo hauaka meta, Sairíni aporo yano motosa Saemone, yao aeyaka ikia otoa perakano asekea, Yasumo ira matopesane epo maka pusimo makatiraka maresapo. Makatiraka marerakano Saemonemo ira matopesane makatiraka Yasu patera pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Saemone patera aporo hinamo yakai pusuapo. Puraka hinamo metakiramo Yasupoko hihiripurape pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Hihiripurape perakano, Yasu rekeako pariraka aseraka iaki someraka, “Yarusarame hinamo reo, anopoko hihiripuhokopo. Re naminapoko hihiripuhoanie. Repo hokosapoko hihiripuhoanie. ");
INSERT INTO faa_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Asiamo keseke mokoatikina maiya amo faserepeakosapo. Maiya amo hinamo hokosa kiri kaīyiane teketakarikia puko ayiane hokosa kirimo nekenekeraka sia teketakarikia pukusafapo. Maiya amo aporo hinamomo someraka, ‘Hinamo manokonomosa seseaka tokenapo. Hinamo hokosa hokono mareanafonosane seseaka tokenapo. Namina sia teketarikia pukusapo,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sere amo watikihokosa maiya fasereperakano aporo hinamomo kakaro kára namoraka ūriaki someraka, ‘Uri nómo isu matairasie.’ Aíyaka ūri feteaki soko someraka, ‘Isu mokosekehoanie.’ Aíyaka keseke mokoatikina maiya ane fasere aperamo repo aihokosapo. ");
INSERT INTO faa_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Arirakano ira hitafe pateraka pairakano ira porasane mayiakakosare?” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Someaka farakano aporo wera tetá Yasuyaki hakāsa ira matopesa paremareasimo karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Karikia pukua hauaka yano motosa Uni Kiki hauaka á pauraka, Yasuane ira matopesa paremaresapo. Aporo tetáne soko ira matopesa paremarekea, meta Yasu hokono kasakai takua maporaka, meta Yasu hokono tumuru takua maposapo. Maporaka Yasuane tipia ira matopesa paremarekea maposapo. ");
INSERT INTO faa_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Maporakano Yasumo someraka, “Atao, pipu ipu makata arakira one ipu koteaka hemakapurakarifapo. Ipu himeteraka arakire. I himu watikiaka arakirane nómo mafahoanie.” Aíyaka Yasumo somesapo. Arirakano Yasumo pasuane mokoakosakipoko ipu kase asia enasapo. ");
INSERT INTO faa_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Arirakano aporo hinamo suamo asekea risiapo. Asekea risike Yu aporo káramo hokomarekea someraka, “Epo aporo hinamo metakira araresapo. Kotimo e máfaraka Unihae Kereso murikimasa satiki, epo ipi yia ararehoafunureapo. Ira matopesa metakarikia o peafunureapo.” ");
INSERT INTO faa_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Airakano aporo terakaiyamosamo e mainamareraka he kīsa karakáno Yasumo nesafapo. ");
INSERT INTO faa_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Nanafononakano namina someraka, “Ne Yu aporomo unihaesekenone ira matopesane metakarikia o peae,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Arirakano Yasu unia kima yapura ira tumusakipoko poparaka paremaresapo. Poparaka paremaresane oyapo. “Yu aporomo unihaeane epo.” Aíyaka poparaka paremaresapo. ");
INSERT INTO faa_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Arirakano somemane koaretaena aporo meta ira paremaresa amo Yasuaki mokoatikiraka someraka, “Unihae Kereso máfaraka maresane nere? Ne ni yia arareraka mafasisie. Eto soko nómo arareraka mafasisie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Aisa aporoaki aporo meta ira paremaresa amo someraka, “Nómo Kotiaki namoraka hemakapurakarifapo. Yasu fanasina ayiáka eto soko fanasirakanapo. ");
INSERT INTO faa_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Eto kuane siareapo. Etapo fana watikiaka risiasamo ropo kuane siahoasireapo. Arirakano Yasumo makata watikiaka rakisiafapo. Epo watikiaka rakianafonosasamo e kuane siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Aíyaka epo Yasuaki someraka, “Yasuo, né unihaeaka rea maiya amo nómo ano hemakapunie.” ");
INSERT INTO faa_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Airakano Yasumo someraka, “Ao, né anoyaki hakāsa pipu ape kotesa á rekeakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Hauaka sua sere maiya tuaro korokomo (12) kepomarekea eresapo. Ereraka reane samapu maiya isiamo faesapo. ");
INSERT INTO faa_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Sere maiya faehoanafonorakano, Kotimo apea pasu waremaresane yapunaka koarape atura pusuapo. Koarape pukua taku haku, taku hakusapo. ");
INSERT INTO faa_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Arirakano Yasumo wáraka, “Atao, ano ho nómo masie,” aíyaka ipi kusuapo. ");
INSERT INTO faa_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Kusua maiya amo aporo terakaiyamosa satinimo aseraka Kotiaki kekereraka someraka, “Aporo kusuane kakaro kotesapo. E aporo kárapo.” ");
INSERT INTO faa_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","49","Airakano Yasu patera asesa aporomo soko, Kariri hinamomo soko, wakasema yameno aeyaka risike asesapo. Yasu ira matopesa paremaresane aporo hinamo suamo asekea faraka apea poparipuraka, aporo hinamo suamo namina kāwa ruraka, “Isu mahisiripo. Isu himu nenakaripo.” Aíyaka namina apea poparipuraka kāwa rupe pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Yu aporomo taone hakása meta yano motosa Arimatíapo. Arimatía aporo Yosefe ipi Ferese aporoyaki, Kotimo somemane tisa aporoyaki hakāsa sarimaraka rakisiapo. Rakiraka e ereketaeraka koteaka susu reke, ");
INSERT INTO faa_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","aporo metakiramo Yasu rusua kukusane me rurakano epo waesapo. Kakaro rusua kurakano soko, epo waesapo. Aporoane Kotimo unihaeaka asekea rekeakosa maiya ane faserepeasimo, Yosefe kau reapo. Yosefeane Pairate rea pukua Pairateaki someraka, “Yasu kusuane kunikia motoako nōmo maka puaere?” ");
INSERT INTO faa_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Airakano Pairatemo aosapo. Aorakano Yosefe pukua Yasu kusuane fatarimaka, pasu pakae kotesamo Yasuane taporaka, maka pukua kunikia fana rasa á Yasu motosapo. Kunikia á aporo meta fana kusuane motosafapo. ");
INSERT INTO faa_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yasu kusua kunikia motosa maiya ane aporo hinamomo makata sarimana maiyamo éane motosapo. Sarimana maiya faraka maiya tuakeramo fenena maiya kepomaresapo. ");
INSERT INTO faa_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Arirakano Kariri hinamo Yasuyaki hakāsa pesamo, Yasu ira paramaresa kusuane, Yosefemo fatarimaka pukua kunikia motorakano, hinamo ipu soko aseako, Yosefeyaki hakāsa pusuapo. Pukua Yasu kunikia motorakano asekea ");
INSERT INTO faa_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","namina apea poparipukua wera wape yamona soko, pauta asia soko, Yasu kaua paiyiakosakipoko sarimasapo. Sarimaraka pukusakipoko asiane ereraka maiya fasapo. Asiamo fenena maiya paurakano makata rakiako asiane metakarikia fenesapo. Kotimo somemane motoraka fenena maiya amo fenanie, aisasamo i fenesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Yatipinumo mituru yao kawe fiarakano, hinamomo Yasu kunikia motosane aseako puraka, pauta asia sarimasane mokoa pukua, kunikia pauraka ");
INSERT INTO faa_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","aseane, eke tafea kunikia ikia koroa mapirisiane kepere mafeasekeno asekea, ");
INSERT INTO faa_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","kunikia kakarua yorokoa pukua aseane, Yasu kunikia motosane fasekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Fasekeno asekea mahimeteraka asekea risike, aseane aporo tetá pasu pakaesa ho piakaepiakaesa ososane fasereperakano asekea, ");
INSERT INTO faa_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","hinamo i namoraka arupepesapo. Arupeperaka risikino aporo tetapō someraka, “Aporo hitafe reane marirakano aporo kusua taena kunikia aseako perakanare? ");
INSERT INTO faa_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","E o rekerifapo. E maturikia taerakano pusuapo. Fana e Kariri hauaka koraka rea maiya amo, e ipi kukua turikia pukusapo, aíyaka somesane hemakapunie. ");
INSERT INTO faa_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Asiamo epo somesane oyapo. Aporo watikisaki e karakáno, e ira matopesa paremarekea kurakano, maka pukua kunikia motosane, sere tetámo wanina isiamo turikia pukusapo. Aisane hemakapunie.” ");
INSERT INTO faa_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aíyaka tetapō somerakano hinamo ipu hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aíyaka ipu hemakapuraka kunikia metakarikia poparipuraka, aporo tetá amo somesane, aporo kinu suaki soko, aporo metakiraki soko, somesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Arirakano hinamoane meta Makatara hinamo Mariapo. Arirakano meta Yoánapo. Arirakano meta Yamesemo kaīyia Mariapo. Ipu soko, hinamo metakiramo soko, aporo hakāsa pura kinu suaki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ayiáka somerakano aporoamo hemakapuraka, “Some koaka murikia kotafe somerakae.” Aíyaka hemakapukua hinamo ipu someane kakimasafapo. ");
INSERT INTO faa_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Arirakano Pita takahikia kunikia aseako foaka pusuapo. Pukua kunikia kakarua weaka aseane, Yasu pasumo taporaka motosane pasu hakása yia kake, Yasu fasekeno asesapo. Fasekeno asekea Pita apea paripuraka, ikia otoa hemakapupe pusuapo. “Yasu masiarakapo,” aíyaka hemakapupe pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sere hakása yiamo aporo tetá Emease apea pusuapo. Arirakano apeane Yarusarame sitiane wakasema yamenopo. ");
INSERT INTO faa_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yamenosakipoko tetā puraka, makata asesane tetapō tati susu somepe pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Somepe purakano asekea, Yasu ikia otoa faserepekea namina hakāsa pusuapo. ");
INSERT INTO faa_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Puraka aporo tetá amo Yasuane himetesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Himeterakano Yasumo tetāki someraka, “Tetápo somepe apurane makata yakapa somerakanare?” Airakano aporo tetāne fenekea risike hikumisi hiripuhoko ayiana ayiáka risiapo. ");
INSERT INTO faa_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ayiáka risike aporo hakása yano motosa Kiriopasemo someraka, “Maiya omo aporo hinamo yakai Yarusarame sitia kimisi pesapo. Asiamo nómo ní hákasamo makata asíane ní hemakapurakarifare?” ");
INSERT INTO faa_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Airakano Yasumo someraka, “Makata asíane yakapare?” Airakano aporoamo someraka, “Nasare aporo Yasuane asíapo. E porofete apororeapo. Aporo hinamo hikumisia soko, Kotimo hikumisia soko, epo wakapumo rakira rakikia some kaka, asiasamo e porofete apororeapo. ");
INSERT INTO faa_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Arirakano isiapo pirisiti aporo soko, isiapo aporo káramo soko, ipu e karikia pukua Rome kamani unihaemo e rusua kukunie, aíyaka mareasimo Rome kamaniaki e kasapo. Karakano ipu e ira matopesa paremarekea maposapo. ");
INSERT INTO faa_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Arirakano isiapo hemakapusuane isu Yu aporo hinamoane epo tonotaehoafunureapo. Rome kamanimo isu asekea risiane metakarikia isiapo isina kamani unihaeaka asekea rekeasimo, máfaraka mareafunureapo. Asiane máfaraka maresafapo. Makata meta soko faserepesapo. E kusuane sere tetá faraka, pipu sere isíapo. ");
INSERT INTO faa_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pipu isiapo hinamo metakiramo makata asesane isuaki somerakano, isiapo kaikia himu fasapo. Mituru fiarakano i Yasu motosa kunikia aseako hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Hikia kunikia pauraka aseane, Yasu fasekeno asesapo. Asekea poparipekea ipu isuaki someraka, ‘Kunikia á hepene aporo risikino ipu asesapo. Hepene aporomo someraka, “E hitaferaka rekenapo,” airakasapakasupo.’ ");
INSERT INTO faa_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aíyaka hinamomo somerakano, isiapo aporo metakiramo kunikia aseako pusuapo. Pukua aseane hinamo ipu aisa hakása yine asesapo. Yasuane ipu asesafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Aíyaka aporo tetámo somerakano, Yasumo tetāki someraka, “Tetápo koteaka hemakapurafaraka mokome somerakae. Porofete aporomo somesane tetápo koteaka hemakapukua kakimaka somerakarifapo. ");
INSERT INTO faa_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kereso kárahokosakipoko, aporomo e mokoatikirakano, e kau teraka himu nekea reke, makata su ayiakakosaposane ásiapo.” ");
INSERT INTO faa_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Aíyaka Kotimo sawia popasa kepoane tetāki Yasumo some kasapo. E ipiane popasane some kasapo. Mosesemo kepomarekea popasane, Yasumo tetāki somesapo. Mosesemo popasa maiya amo, patera porofete aporo yakaimo popasane tetāki somesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Somepe pukua i Emease apea pauraka, Yasu ape meta pukusakipoko tetāne marokeraka puko ayiane ");
INSERT INTO faa_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","tetapō someraka, “Né pukupo. Etoyaki hakāsa peae. Yao ererakanapo,” aisapo. Arirakano Yasu iyaki namina hakāsa apea hikia, asekea toapo. ");
INSERT INTO faa_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Namina hakāsa toke makata nakosakipoko, Yasumo farawa maka Kotimo makotehoasimo kurikuriraka mamosoraka tetāki kasapo. ");
INSERT INTO faa_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Karakáno tetapō himo koteaka asekea someraka, “Ne Yasureapo.” Aíyaka hemakapuanine Yasuane ipi yia kaya nine fasapo. ");
INSERT INTO faa_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Farakano asekea tetapō tati yia someraka, “Isu ikia otoa peraka Kotimo sawia popasane epo etoaki some karakasapo. Amo etapo hemakapuraka, ‘Some ane namo kakaro kotehoareapo.’ Aíyaka eaki himu hakásaraka hemakapuafapo. Katuyia mahimetehoapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Arirakano tetā takahikia Yarusarame sitia poparihisiapo. Poparihikia apea yorokoa aseane aporo hakāsa pura kinu suane soko, ipu aporo tákeyaki namina hakāsa sarimaraka tokeno asesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Arirakano ipu aporo tetá pesaki someraka, “Isiapo unihaeane kakaro turikia pusuapo. E turikia pusuane Saemonemo asesapo.” ");
INSERT INTO faa_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Airakano aporo tetá kawe pesamo soko someraka, “Eto ikia otoa puraka risiakipoko aseane Yasu peraka etoaki makata somerakasapo. Ikia otoa some karakano etapo eane koteaka hemakapusuafapo. Asiane apea isina hakāsa makata nakosakipoko toke epo farawa mosoraka etoaki karakano, amo etapo eane koteaka asekea hemakapusuapo.” Aíyaka aporo tetá amo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Aporo tetapō someana maiya yiamo Yasu faserepekea, iyaki hakāsa reke someraka, “Koteaka auaraka risikianie.” ");
INSERT INTO faa_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Airakano namina fofaraka namoraka someraka, “Yakasa horeapo.” ");
INSERT INTO faa_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Airakano Yasumo someraka, “Marirakano re namorakanare? Marirakano himu tetáraka hemakapukua risikinare? ");
INSERT INTO faa_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ano hokono asesie. Ano korake asesie. Kakaro anopo. Kakaro anoreapo, aíyaka repo hemakapuko ano hokonoa sakairasie. Yakasa ho kiki rerafapo. Ano kiki rekeno repo aserakanapo. Yakasa ho kau rerafapo. Ano kau rekeno repo aserakanapo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aisane hokono soko, korake soko, tarirakano ipu asesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Asekea namina kakaro seseraka someraka, “Erakapo. E masiarakapo.” Aíyaka ipu asesa nine Yasu kakaro reane ipu koteaka hemakapusuafapo. Asiasamo Yasumo someraka, “Makata nakosa tokenare?” ");
INSERT INTO faa_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Airakano ipu pokoa paisia inasane e karakano ");
INSERT INTO faa_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ipu asekeasimo Yasumo pokoane nesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nekea faraka Yasumo someraka, “Ano fana reyaki rea maiya amo, makata ayiakakosane fana nōmo reaki somesapo. Nōmo somesane kakaro yasiapo. Fana Mosesemo anoane ayiakakosapo, aíyaka popasane soko, anakano porofete aporomo anoane ayiakakosapo, aíyaka popasane soko, anakano Same púkua popasane soko, anoane ayiakakosaposane kawe asia ayareapo.” Yasumo aisapo. ");
INSERT INTO faa_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","I namina himeterakano ipu hemakapusimo Yasumo Kotimo sawia popasane iaki tarikia mahemakapusuapo. Asiamo Kotimo sawia popasane ipu hemakapusimo epo some karaka, ");
INSERT INTO faa_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","“Kotimo sawia popasane oyapo. Keresoane kau teraka himu nekea rusua kusuane, yape tetá faraka yape isiamo turikia pukusapo, aíyaka popasapo. ");
INSERT INTO faa_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Asiamo ano turikia pusuakipoko Keresoane yano hokoa some karakano, aporo hinamomo kaikia ipu makata watikisane metakarikia, eaki risikiako parirakano, namina makata watikisane Keresomo mafahokosapo. Keresomo makata watikisane mafahokosa someane hauaka sua aporo hinamo suaki some kakanie. Yarusarame sitia some kaka, Yarusarame siti aeyaka kepomarekea somepe pukua, hauaka sua aporo hinamo suaki some kakanie. ");
INSERT INTO faa_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Asiamo repo makata su asesane somehoanie. ");
INSERT INTO faa_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nōmo Atamo makata kakakosaposane, nōmo reaki kaka mareakosapo. Hepene yapunaka wakapuane re himua peasimo Yarusarame siti yia re su kau tokanie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yasumo i karikia Yarusarame sitiane metakarikia, Petene ape makeraka hisiapo. Hikia risike, Yasumo ipi hokono tetákara máfaraka, iane makoteraka some kasapo. ");
INSERT INTO faa_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Makoteraka some kasá maiya amo, Yasumo iane metakarikia, Kotimo e hepene yapura karikia hisiapo. ");
INSERT INTO faa_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yasu hinakano asekea ipu eane kekereraka Yarusarame sitia seseraka poparihisiapo. ");
INSERT INTO faa_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Maiya suamo Kotimo apea hikia Kotiaki kekeresapo. ");
INSERT INTO faa_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Makata su kepomaresa maiya amo, ipi yano motosa Someane wate yaiya reapo. Someane Kotiyaki hakāsa reapo. Someane ipi Kotipo. ");
INSERT INTO faa_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Makata su kepomaresa maiya amo e Kotiyaki hakāsa yaiya reapo. ");
INSERT INTO faa_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","E aeyaka makata suane kepomaresapo. E metakarikia makata su kepomaresafapo. E aeyaka kepomaresapo. ");
INSERT INTO faa_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yaiya reramo kepoane e ipipo. Yaiya reramo faesane aporomanoaki karápo. ");
INSERT INTO faa_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Faesa amo katosa arakaru tipia kára faeraka rekenapo. Katosamo faesane kopakataenafapo. ");
INSERT INTO faa_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Asiamo faesane somehoko aporo hakása meta Kotimo pusiesapo. Pusierakano pesane ipi yano motosa Yonepo. Aporo suamo kakimakasimo epo somehoko pesapo. ");
INSERT INTO faa_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Faesane éfapo. Faesane epo somehoko pesapo. ");
INSERT INTO faa_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Arirakano kakaro faesamo kepoane Yasu ipipo. Ipi hauaka wo aporo suane mafaehoko pesapo. ");
INSERT INTO faa_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Arirakano wate fana epo hauaka one soko aporomano ane soko rakisiapo. Epo ipi rakisia nine e hauaka kara wo pesa maiya amo aporo hinamomo eane himetesapo. Kotimo eane pusierakano, pesane aporo hinamomo hemakapusuafapo. ");
INSERT INTO faa_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ipi aporo iramo apea perakano ipu eane teresafapo. ");
INSERT INTO faa_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Asiane aporo hinamo metakiramo eane tereraka epo ipi yano motosa paoraka eaki himu hakásaraka hemakapurakano iaki epo someraka, “Re Kotimo hokosapo,” aíyaka somesapo. ");
INSERT INTO faa_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kotimo hokosapo, aisane aporomo hinamo arumaka hokosa hokono amarera ayafapo. Aporomo hinamo arumaka hokosa hokono maresa hokosane aporomo ipi hemakapusua ayapo. Kotimo hokosa risikiasimo Kotimo ipi hemakapukua someraka, “Neane nōmo nī hokosapo.” Aíyaka ipi hokosa risikiasimo murisiapo. ");
INSERT INTO faa_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Arirakano Somemo isiapo aporomanomo kauane maka, hauaka wo pekea isuyaki reapo. Epo isu hemakapuraka arareraka, kakaro someane some kasapo. Some akaramo Yasumo wakapu faesane isiapo asesapo. Ipi wakapu faesane ipi Kotimo hokosa hakása yinesasamo Kotimo wakapuane faesa ayapo. ");
INSERT INTO faa_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Arirakano Kotimo hokosa ane Yonemo somesapo. Yonemo paroaka someraka, “Aporo keseke peakosane e ipi namo kakaro fanapo. Ano takapeasiraka e fana yaiya reapo. Fana yaiya reasasamo e ipi namo kakaro kárapo. Ano wakasemapo,” aíyaka Yonemo somesakipoko aseane Yasu perakano asesapo. ");
INSERT INTO faa_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Yasumo isu su yaku kára araresapo. Efera hunia soko, efera hunia soko yaku arareraka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kotimo somemaneane Mosesemo aporoaki some kasapo. Arirakano yaku ararenane soko, kakaro somerane soko, Yasu Keresomo isuaki kasapo. ");
INSERT INTO faa_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Aporomo Kotiane aserafapo. Asiāne ipi hokosa hakása yine tati hakāsa risiasamo, hokosa amo Kotimo ainane tariako pesapo. ");
INSERT INTO faa_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yu aporo sisimamo pirisiti aporoaki soko, Rífai aporoaki soko someraka, “Re Yarusarame siti metakarikia Yoneaki makata kaiyako punie.” Airakano i pukua Yone rea pekea someraka, “Ne epare? Kotimo pusiesa aporoane nere?” ");
INSERT INTO faa_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Airakano Yonemo mahamesafapo. Epo hufitaeraka someraka, “Ano Keresofapo. Aporo Unihaeaka rekeasimo murikimasa aporo keresoane anofapo.” ");
INSERT INTO faa_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Airakano ipu someraka, “Ne eparakapo. Ne Iraíyare?” Airakano epo someraka, “Wae, ano Iraíyafapo.” Airakano ipu someraka, “Porofete aporo kárane nere?” Airakano epo someraka, “Anofapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Airakano ipu someraka, “Ne epare? Isu pusiesa aporoaki isiapo somehokosakipoko nómo somesie.” ");
INSERT INTO faa_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Airakano epo someraka, “Ima yaoa sakepamo somehokosa aporoane anopo. Unihae peakosane ikia kara hahaesekeno maereketaehoanie aihokosa aporoane anopo. Anoane Aesayamo popahoareapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Airakano Ferese aporomo pusiesa aporoamo someraka ");
INSERT INTO faa_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Keresoane soko, Iraíya ane soko, arirakano porofete aporo karane soke nefareapo. Asiamo marirakano nómo aporo hinamoane hea tapukumurirakanare?” ");
INSERT INTO faa_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Airakano Yonemo someraka, “Re nōmo hea hákasa tapukumurirakanapo. Ano reakipoko aporo hakása meta peakosapo. E peakosane reyaki rekenapo. Ayiáka repo eane hemakapurakanafapo. E aporo kárasasamo aporo raipamo epo tamaka ane fisina ayiáka nōmo fisihoane siahoasifareapo. E aporo kárasasamo nōmo epoko raiparaka rakiako ayiane soko ano wakasemasasamo nōmo rakiane siahoasifareapo. Ano eyaki siasafapo.” Aíyaka Yonemo Petene apea somesapo. ");
INSERT INTO faa_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","He Yotane taku ra Petene ape rekenapo. He Yotanea Yonemo aporo hinamo hea tapukumurisiapo. ");
INSERT INTO faa_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ere hakása waka, mituru Yonemo aseane Yasu perakano aseraka someraka, “Kotimo saro sipi manoane apere. Aporomo himua makata watikisane epo mafahokosakipoko saro sipi arura ayiáka e rukusapo. ");
INSERT INTO faa_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Fana eane nōmo reaki somerakasu ayapo. Asiamo ano fana pesakipoko aporo meta kesekea peakosaposane apera ayareapo. Asiamo aporoane ano hokono mareasiraka e ipi wate fana yaiya reapo. Asiamo aporoane ipi namo kakaro fanapo. ");
INSERT INTO faa_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Fana aporo meta Kotimo pusiehokosaposane nōmo kairaka epa peanarakapo, aíyaka hemakapukua ano himetesapo. Asiane Isiraya aporo hinamo repo eane hemakapusimo reane nōmo hea tapukumurirakanapo. Hea tapukuamuriramo eane atarira ayiáka tarirakanapo,” aíyaka Yonemo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Aíyaka efera hunia Yonemo someraka, “Fana Kotimo anoaki hea tapukumuriako pusiesapo. Kotimo some kasa yiamo someraka, ‘Ho Kotesa pekea aporo hakása meta á karaporakano epo ipi yiamo Ho Kotesane aporo hinamo suaki muriakosapo.’ Aíyaka Kotimo somesakipoko aporoane fasere perakano fana e nōmo himetesapo. Himetesane Ho Kotesa mena nume asia ea karaporakano aseraka nōmo hemakapuraka, ‘Kotimo fana somesane ereapo,’ aíyaka nōmo hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Hemakapukua eane nōmo himo asekea someraka, ‘Eane kakaro Kotimo hokosapo. Kotimo murikimasa aporoane ereapo,’ aíyaka nōmo someraka rekenapo.” Aíyaka Yonemo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ere hakása waka, mituru Yone ipi aporo hakása pura tetáyaki risike, epo aseane ");
INSERT INTO faa_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Yasu purakano asekea wáraka someraka, “Asesie. Kotimo saro sipi mano e apure.” ");
INSERT INTO faa_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Aíyaka wárakano Yonemo aporo hakása pura teta amo kaikia Yoneane metakarikia Yasuane kekemarape pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Kekemarape perakarakano Yasumo patera pariaseane tetā kekemarape perakano asekea someraka, “Teto yakapa aseako perakanare?” Airakano tetapō someraka, “Tisao, né ape ma warakánare?” ");
INSERT INTO faa_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Airakano Yasumo someraka, “Aseako peae.” Airakano tetā Yasuyaki hakāsa pukua epo ape waráne asesapo. Asesa sere yiamo Yasuyaki hakāsa risiapo. Yasuyaki hakāsa risia sere ane samapu maiya kitafapo. ");
INSERT INTO faa_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yonemo someane kakimaka Yasu kekemaraka pusua aporo tetāne meta yano motosa Enitupo. Enituane e Saemone Pitamo mamaneapo. ");
INSERT INTO faa_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Fana Enitu ipi mamanea Saemone ane kope pusuapo. Pukua e kokoa asekea someraka, “Aporo Kotimo pusiehokosaposane Kereso perakasapo. Isiapo asesapo. Keresoane Kotimo Unihae murikimaka maresa ayasesapo.” ");
INSERT INTO faa_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Aíyaka Enitumo Saemone ane karikia Yasu rea pesapo. Perakano Yasumo e asekea someraka, “Né Yonemo hokosa Saemonereapo. Yumo nōmo neane yano motoraka Sifase yano motorakanapo,” aíyaka Yasumo somesapo. Arirakano Sifase yano motosane Kiriki meaka Pita yano motosapo. Namo meaka Eke, aíyaka yano motosapo. ");
INSERT INTO faa_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ere hakása waka, mituru Yasu Kariri hauaka pusuapo. Pukua Firipi aseraka someraka, “Ano patera asesie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Arirakano Firipi ipi Pesaita taonea reapo. Enitu soko, Pita soko i Pesaita taonea hakāsa risiapo. ");
INSERT INTO faa_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Firipi pukua Natanio asekea eaki someraka, “Mosesemo somemane sawia poparaka maresa aporoane isiapo asesapo. Porofete aporomo soko eane popasane isiapo asesapo. E Yosefemo hokosa Yasupo. Epo apeane Nasare apepo.” ");
INSERT INTO faa_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Airakano Nataniomo someraka, “Nasare ape aeyaka aporo kotesa perafapo.” Airakano Firipimo someraka, “Aseako peae,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Aíyaka tetā pukua Natanio perakano Yasumo asekea someraka, “Isiraya aporo kotesane ereapo. Epo makata kotafe somerafapo.” ");
INSERT INTO faa_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Airakano Nataniomo someraka, “Nómo ano mayiáka hemakapukua asekea somerakanare?” Airakano Yasumo someraka, “Firipimo néaki peaehoasiraka né ira foke kepoa kakeno nōmo né asesapo.” ");
INSERT INTO faa_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Airakano Nataniomo someraka, “Tisao, Kotimo aporo hokosane nereapo. Né Isiraya aporomo unihaereapo.” ");
INSERT INTO faa_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Airakano Yasumo someraka, “Né ira foke kepoa kakeno nōmo asesapo. Asiasamo nómo anoaki himu hakásaraka hemakapurakanapo. Asiane nōmo makata someana one wakasemapo. Keseke makata kára meta nómo aseakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Aíyaka efera hunia Yasumo someraka, “Nōmo kakaro somerakaripo. Ti kikisi akaraka, kikisi roraka, Aporomanomo Táke ano unia kima yapura Kotimo hepene aporoane pekea parihinakano repo asekeakosapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Sere teta faraka, sere isiamo aporo metamo hinamo arumaraka hokono kesapo. Kariri hauaka á Kena taonea hokono kesapo. Hokono akera apea Yasumo ipi kaīyia pukua kayapo. ");
INSERT INTO faa_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Arirakano Yasu soko, ipi aporo hakāsa pura soko, iaki aporo meromo peaerakano i pukua á risiapo. ");
INSERT INTO faa_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Arirakano aporo hinamo su risiamo waene heane nekea farakano, Yasumo ipi kaīyiamo eaki someraka, “Waene heane ipu suamo nekea fahoareapo.” ");
INSERT INTO faa_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Airakano Yasumo ipi kaīyiaki someraka, “Amao, marirakano nómo anoaki somerakanare? Nōmo maíyane harufapo.” ");
INSERT INTO faa_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Airakano Yasumo ipi kaīyiamo aporo meromo aporo raipaki someraka, “Yasumo reaki makata rakisimo somerakano, hakása yine kakimaka rakinie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Airakano aseane petoro namasu tarámo kára asia toane asesapo. Arirakano Yu aporo sisimamo hemakapuraka, “Kotimo isuaki sesehoasimo isiapo hokono kusunapo.” Aíyaka hemakapusuasamo hokono kusuhoko eke petoroa he taka apea taesapo. Apea taesane tarámo kára asia petoro kárane taesa tokeno asesapo. ");
INSERT INTO faa_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Aseraka aporo meromo aporo raipaki, Yasumo someraka, “Petoro kárane komarusimo he taka kesie.” Airakano ipu he taka kekea komarusuapo. ");
INSERT INTO faa_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Komarurakano asekea Yasumo aporo raipaki someraka, “Petoro kára á he kesane, takamaka aporo hokono akera hokono meromo nasimo takamaka pusie.” ");
INSERT INTO faa_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Airakano ipu takamaka pukua, aporo hokono meroaki karakáno epo nesapo. Namo heane waene he maparisane epo hemakapusuafapo. Arirakano aporo raipa he tasamo ipu hákasa hemakapusuapo. Aporo meroamo waene heane nenaka aporo hinamo kawe arumasa apiane peaesapo. ");
INSERT INTO faa_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Perakano epo someraka, “Isiapo ainane oyapo. Waene he namo kakaro kotesa wapesane fana aporo hinamo hokonoa pesaki karápo. Fana kasane ipu siaraka nenakano asekea, waene he wakasema wapesane kesekea karápo. Arirakano nómo waene he wakasema wapesane fana akare. Kakaro wapesane kesekea akare,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Arirakano aporomo hemakapusimo Yasumo Kotimo wakapumo hemakapukua rakira fanane oyapo. Namo heane waene he maparihoasimo rakisiapo. Kariri hauaka á Kena taonea epo rakisiapo. Epo wakapu kára ane aporo hinamo suamo asekeasimo epo wakapuaka rakisiapo. Rakirakano ipi aporo hakāsa puramo aseraka eaki himu hakásaraka hemakapukua risiapo. ");
INSERT INTO faa_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Arirakano hokono kekea soraka Yasu soko, Yasumo ipi kaīyia soko, ipi mamanea soko, ipi aporo hakāsa pura soko, i su pukua Kapaneame taonea pukua sere hukusimo waka risiapo. ");
INSERT INTO faa_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ape Farimaresa Hemakapuko Hokono Akera maiya ane makerakano, Yasu Yarusarame sitia hisiapo. ");
INSERT INTO faa_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Hikia Kotimo ape ruru kakarua yorokoa aseane aporomo saro ponomakau soko, arirakano saro sipi soko, arirakano mena soko roporaka risikino asekea, aporo metakira teporoa toke mone sanasirakano asesapo. ");
INSERT INTO faa_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Asekea Yasumo sako kita toane maka, kita pekea, kita amo aporo soko, namina saro ponomakau soko, saro sipi soko, Kotimo apea karikia pesane teketarikia pusimo rukuhoaesapo. Rukuhoaeraka aporomo mone sanasiraka toa amo teporoane maparitaeraka mone rukukoakataesapo. ");
INSERT INTO faa_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Rukukoakataeraka aporo mena roporaka risiaki Yasumo someraka, “Mena ane mokoa pusie. Nōmo Atamo ape one makata ropona ape mapariraka ayiakakopo.” ");
INSERT INTO faa_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Airakano kaikia epo ipi aporo hakāsa puramo Kotimo sawia popasane hemakapusuapo. Popasane oyapo. “Kotio, nómo apeane namo kakaro kotesa susuane nōmo hemaka apuramo fanaraka hemakapurakanapo.” Aíyaka popasane Yasumo ipi aporo hakāsa puramo hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Arirakano Yu aporo sisimamo Yasuaki someraka, “Né epa asiamo arirakayiare? Né fanaraka reane isiapo aseako tarinie. Kotimo wakapumo hemakapukua rakirane nómo rakinie.” ");
INSERT INTO faa_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Airakano Yasumo someraka, “Kotimo ape one rakaritaeraka yape isia faraka efera hunia nōmo kikimakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Airakano ipu someraka, “Ape one kiraka risike keremisi foti sekese (46) faraka kikimasapo. Asiane mayiáka yape isia yiamo nómo ape one kikimakosare?” ");
INSERT INTO faa_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Airakano Yasumo ipi homo apeane ipi kauane takumeaka ape kiakosane somesapo. ");
INSERT INTO faa_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Aíyaka somesane Yasu ipi kukua turikia pusua maiya amo somesa kepoane ipi aporo hakāsa puramo hemakapusuapo. Maiya amo Kotimo sawia popasane soko Yasumo somesane soko kakimasapo. ");
INSERT INTO faa_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Arirakano Ape Farimaresa Hemakapuko Hokono Akera maiya amo Yasu Yarusarame sitia reke, Kotimo wakapumo hemakapukua rakirane epo rakisiapo. Rakirakano aporo hinamo yakaimo aseraka eaki himu hakásaraka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Arirakano aporomano himumo hemakapusuane Yasumo aseraka epo iaki himu hakásaraka hemakapusuafapo. ");
INSERT INTO faa_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Aporomo hemakapusuane aporo metamo Yasuaki someaka tarisiafapo. Yasumo ipi yiamo aporomo himuane asesapo. ");
INSERT INTO faa_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Yu aporo hakása meta yano motosa Nikitímasepo. Ipi Yu aporo sisima unihaeaka reane ipi Ferese aporopo. ");
INSERT INTO faa_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ereamo Yasu rea e pekea someraka, “Tisao, Koti néyaki hakása reasasamo nómo Kotimo wakapumo hemakapukua rakirane rakirakanapo. Asiamo tisaraka rakisimo Kotimo pusiesane népo. Aíyaka nōmo hemakapurakaripo.” ");
INSERT INTO faa_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Airakano Yasumo someraka, “Nōmo kakaro somerakaripo. Aporo efera hunia makaweraka rekeanafonorakano, aporoane Kotimo unihaeaka asekea rekeakosafapo.” ");
INSERT INTO faa_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Airakano Nikitímasemo someraka, “Aporo sisimane mayiáka efera hunia makaweraka takapeakosare? Hokosa pariraka kaīyiamo tuanaka efera hunia takapeane siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Airakano Yasumo someraka, “Ho Kotesamo aporoane hokono mareanafono, arirakano hea tapukumareanafono asiane Kotimo unihaeaka asekea rea aporoakiyaki paohokosafapo. ");
INSERT INTO faa_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Aporo hinamomo hokosa hokono marerane kau, kiki, maīya, hokono marerane kaumo mena ayapo. Arirakano aporo hinamo namina ho makawehoasimo, Ho Kotesamo mena ayapo. ");
INSERT INTO faa_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nōmo neaki someraka, ‘Re makaweraka risikianie,’ airakasane nómo kaikia fofahokopo. ");
INSERT INTO faa_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Arirakano atifo purakarakano senakimo hákasa kairapo. Himo aserafapo. Atifomo makata meta mahohorakano, himo aserapo. Atifo manaka perakanarakapo. Pekea ma purakanarakapo. Aira ayiáka aporo hinamomo himura Ho Kotesa rekerakano epo arakirane aporo metamo aserapo.” ");
INSERT INTO faa_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Airakano Nikitímasemo someraka, “Nómo somerakane mayiáka ayiakakosare? Ano himeteripo.” ");
INSERT INTO faa_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Airakano Yasumo someraka, “Nikitímase, Isiraya aporomo tisane nepo. Kotimo sawia popasamo kepoane nómo some karapo. Asiane nōmo some kepoane nómo hemakapurakarifare? ");
INSERT INTO faa_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Hao, kaisie. Nōmo neaki kakaro somerakanapo. Isiapo makata kakaro hemakapusua hákasane somerapo. Arirakano isiapo makata asesa hákasane somerapo. Somesa nine repo kakimarakarifapo. ");
INSERT INTO faa_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Hauaka wo makata rakirane nōmo somerakano repo kakimarafapo. Arirakano hepene yapura makata rakirane nōmo somerakano repo kakimakosare? Wae, kakimakosafapo. ");
INSERT INTO faa_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Asiamo hepene yapura makata rakirane aseako aporo meta hepene yapura hikia, hauaka wo somehoko pesafapo. Ano nī hákasa hepene aeyaka pekea, Aporomanomo Táke anoane hauaka wo somehoko pesapo. ");
INSERT INTO faa_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Arirakano fana ima yaoa Mosesemo rete asiamo heseke pariraka rakikia ira maporaka heseke paremaresa ayiáka, Aporomanomo Táke anoane ayiáka paremareakosapo. ");
INSERT INTO faa_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ano paremarerakano aporo hinamomo anoaki himu hakásaraka hemakapukua risiane yaiya risikiakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Asiamo hauaka wo aporo hinamo su risiane Kotimo himu tumurumo hemakapusuasamo ipi hokosa hakása yine pusiesapo. Pusierakano ipi hokosa pesapo. Perakano aporo hinamomo eaki himu hakásaraka hemakapukua risiane eyaki yaiya risikiakosapo. Iane hurupukusafapo. ");
INSERT INTO faa_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kotimo ipi hokosamo aporomano fanasihokosakipoko pusiesafapo. Aporomano mafasiakosakipoko pusiesapo. ");
INSERT INTO faa_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Asiamo Kotimo hokosamo someane aporo hinamomo kakimarakano iane fanasihokosafapo. Arirakano Kotimo hokosamo someane kakimakanafonorakano, fanasihokosane fana yaiya murikimaka maresapo. Asiamo Kotimo ipi hokosa hakása yiamo somesane kakimakanafonosasamo fanasihokosane fana yaiya murikimaka maresapo. ");
INSERT INTO faa_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","20","Fanasihokosa kepoane oyapo. Faesa hauaka wo pesapo. Faesa pesane aporo hinamomo hisiraka namina watikiaka rakiako katosa yia risirapo. Aporo hinamomo namina watikiaka rakisiane aporo metamo aserapaka faesa á perafapo. Faesane kakaro hisiraka, faesa á risikiako perafapo. ");
INSERT INTO faa_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Arirakano namo kakaro koteaka rakira aporo hinamoane faesa á risikiako perapo. Asiamo ipu Kotimo someane kairaka kekemaraka rakiraka risirane aporo suamo asekeasimo i faesa á rakiraka risirapo. ");
INSERT INTO faa_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Yasu ipi aporo hakāsa purayaki Yutía hauaka pusuapo. Á pukua risike ipu aporo hinamo hea tapukumurisiapo. ");
INSERT INTO faa_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Arirakano Inone apeane Sarime taonea makeraka, he kára pekereakipoko aporo hinamo perakano iane Yonemo hea tapukumurisiapo. ");
INSERT INTO faa_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Yonemo hea tapukuamurisia maiya amo e tipura haru makesafapo. ");
INSERT INTO faa_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Arirakano Yu aporo hakása metamo Yonemo ipi aporo hakāsa pura metakiraki makata watikisa fahokosakipoko hea tapukumuriane tafatafaraka somesapo. ");
INSERT INTO faa_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tafatafaraka somerakano Yonemo aporo hakāsa pura suane Yone rea pekea someraka, “Tisao, he Yotane yaoraka ne rea takua aporo pesane hemakapurakarire? E peakosa ikia karane maropohoko nómo some karakasupo.” Airakano Yonemo, “Ao. Eane nōmo hemakapurakaripo.” Airakano ipu someraka, “Aporoamo aporo hinamo metakirane hea tapukumurirakanapo. Asiamo aporo hinamo suamo né metakarikia e rea purakanapakae.” ");
INSERT INTO faa_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Airakano Yonemo someraka, “Kotimo karakano hakása yine aporomo marapo. Kotimo kakanafonorakano aporomo marafapo. ");
INSERT INTO faa_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Fana nōmo someraka, ‘Ano Keresofapo. Kereso peakosa ikia karane nōmo maropohokosakipoko ano fana pesapo.’ Aíyaka nōmo somerakasuane repo kaisiapo. ");
INSERT INTO faa_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Arirakano aporomo hinamo faisane aporo metamo arumarafapo. Hinamo faisane aporoamo ipi yiamo arumarapo. Hinamo arumakosa aporoamo somerakano ipi maemo kairaka sesenapo. Ipi mae sesena ayiáka ano kára seseraka rakiraka rekenapo. ");
INSERT INTO faa_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yasu ipi káraraka hokopukua rekeakosapo. Ano wakasemaraka rekeakosapo.” Aíyaka Yonemo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Arirakano aporo hepene yapunaka pesane ipi namo kakaro fanaraka rekenapo. Arirakano hauaka wo takapesa aporoane ipi hauaka menapo. Ipi hauaka wo makata rakirane somerapo. ");
INSERT INTO faa_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Asiamo e hepene yapunaka pesasamo hepene yapura makata asesane soko, makata kaisiane soko, epo somerapo. Someane aporo metakiramo kakimakanafonorakano yia, epo makata asesane soko kaisiane soko yaiya somerapo. ");
INSERT INTO faa_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Arirakano aporo metakiramo epo somesane kakimaka risike someraka, “Ao, Kotimo someane kakarohoareapo,” airapo. ");
INSERT INTO faa_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Arirakano e Kotimo pusierakano pekea Kotimo someane some karakanapo. Ho Kotesa fete feteaka Kotimo eaki kasáfapo. Kára komarukua kasápo. ");
INSERT INTO faa_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ata Káramo ipi hokosa ane himu tumurumo hemakapukua reke, ipi hokosamo makata su asekea rekeasimo murikimaka maresapo. ");
INSERT INTO faa_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Asiamo Kotimo ipi hokosamo somesane aporo hinamomo kakimarakano iane Kotiyaki yaiya risikikosapo. Kotimo hokosamo somesane koaretaerakano iane Kotiyaki yaiya risikiakosafapo. Aporo hinamomo kakipayasaki Kotimo yaiya saperaka rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Aporo hinamoane Yasumo hea tapukumurisiafapo. Arirakano ipi aporo hakāsa puramo hea tapukumurisiapo. Aporo metakiramo asekea someraka, “Yasu patera asesa aporo hinamo yakaiane Yasumo ipi aporo hakāsa puramo hea tapuku amurire. Asiamo Yasu patera asesa aporo hinamoane yakairaka kárarakanapo. Arirakano Yonemo hea tapukumurisia aporo hinamoane hukusipo. Yasumo aporo hinamo hea tapukumurisia amo Yonemo aporo hinamo hea tapukumurisiane marokeane.” Aíyaka somerakano Ferese aporomo kaisiapo. Asiamo Yasumo hemakapuraka, “Nōmo makata rakirane aporomo somerakano Ferese aporomo kairakayiapo.” Aíyaka hemakapuraka Yasu Yutía hauaka metakarikia Kariri hauaka efera paripukusakipoko ");
INSERT INTO faa_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","5","pekea Sameria hauaka tipia pauraka á reapo. Sameria hauaka tipia Saika taone á rekenapo. Saika taone makeraka hauaka ane Yakopemo ipi hokosa Yosefeaki wate fana tarisiapo. ");
INSERT INTO faa_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakopemo he keasimo hauaka rasa á Yasu pukua kayapo. Maiya tipiamo ipi korakemo finiraka pesasamo ipi sosekenaraka kayapo. ");
INSERT INTO faa_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Kayakipoko ipi aporo hakāsa puramo makata nakosa ropohoko taonea pusuapo. Pusuakipoko Yasu rea Sameria hinamo he takamako perakano Yasumo someraka, “Ano he takamakasie.” ");
INSERT INTO faa_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Airakano Sameria hinamoamo hemakapuraka, “Yu aporo Sameria aporo tati hakāsa sarimanafapo. Yu aporomo Sameria aporoane arare, arirakano Sameria aporomo Yu aporo arare anafapo.” Aíyaka hemakapukua hinamoamo someraka, “Marirakano nómo anoaki he takamakasie airakanare? Né Yu aporopo. Ano Sameria hinamopo. Marirakano nōmo né ararerakasimo somerakanare?” ");
INSERT INTO faa_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Airakano Yasumo hinamoaki someraka, “Kotimo makata yaku karane soko, nómo hemakapukua, arirakano nómo anoane soko asekea, ereapo, aíyaka hemakapusua satiki, nómo anoaki aíyaka somehoafunufapo. Nōmo neaki someraka, ‘Ano he takamakasie,’ airakano nómo ano asekea hemakapusua satiki nómo anoaki someraka, ‘Ano he takamakasie,’ aihoafunureapo. Airakano nōmo né he fuakataena kakafunupo.” ");
INSERT INTO faa_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Airakano hinamoamo someraka, “Hauaka rasa kutusasamo takamakosane nómo petoro fareapo. He fuafuana mayiáka takamakosare? ");
INSERT INTO faa_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Isiapo makasa kaua kekema Yakopemo hauaka one rasapo. Wate fana epo soko ipi hokosamo soko ipi saro sipimo soko hauaka rasa he kesa hákasane nesapo. Yakope kurakano epo hauakane soko he rasane soko isiapo asekea risikinapo. Hauaka wafaya makasa kaua kekema Yakopeane aporo wakasemare? Nómo he haku fuakataena kakaro kotesa kakakosaporakane ne ní hákasane aporo fanarakanare? Yakopeane makamakesekerakanare?” ");
INSERT INTO faa_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Airakano Yasumo someraka, “Hauaka rasa he kesane aporo hinamomo nesane efera hunia soko ‘He nariripo,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Nōmo he takamaka karakano aporo hinamomo nenaka efera hunia, ‘He nariripo,’ aihokosafapo. Nōmo he akarane he fuafuana ayiáka ne tua fuafuahokosapo. Asiamo né yaiya rekeakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Airakano hinamoamo someraka, “Aporo fanao, he fuafuanane anoaki makasie. Makarakáno efera hunia, “He nariripo,” aihokosafapo. Arirakano efera hunia nōmo takamako peakosafapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Airakano Yasumo someraka, “Ní makapinu pasimaka peanie.” ");
INSERT INTO faa_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Airakano hinamoamo someraka, “Nōmo aporo rekenafapo.” Airakano Yasumo someraka, “Kakarorakae. ");
INSERT INTO faa_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Aporo kakorea sumo ne arumasapo. Asiane yumo ne aporoyaki kake, ne kakaro aporomo arumasafapo. Ne mokome aporoyaki purareapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Airakano hinamoamo someraka, “Aporo fanao, nōmo ainane nómo hemakapukua somesasamo né porofete apororeapo. ");
INSERT INTO faa_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Repo Yu aporomo someraka, ‘Yarusarame sitia Kotiaki kekerehoanie.’ Aíyaka repo somesa nine, isiapo makasa kaua kekema Sameria hauaka ūria hikia a ipu Kotiaki kekeresapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Airakano Yasumo someraka, “Keseke fasereapera sereamo Ata Káraki kekerenane Sameria hauaka ūria soko, Yarusarame sitia soko tetá hákasa aeyaka hákasa kekerehokosafapo. Hauaka su aeyaka kekerehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","E kekeresane repo Sameria aporo hinamomo kakaro koteaka hemakapurakanafapo. Mafasira aporo hauaka wo takapeasimo Yu aporo irane Kotimo murikimarakano, Yu aporo ira aeyaka hauaka wo takapesapo. Yu aporo ira aeyaka takapesasamo e kekeresane isiapo Yu aporomo hemakapurakanapo. ");
INSERT INTO faa_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Arirakano keseke soko yumo soko aporo hinamomo kaumo hemakapukua kekerenafaraka himumo Kotiaki kakaro koteaka hemakapukua kekerehokosapo. Aporo hinamomo homo soko kekerehokosapo. Kakaro hemakapukua kekerena aporo hinamoane Kotimo sesenapo. ");
INSERT INTO faa_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kotiane ipi hopo. Hosasamo e kekerena aporo hinamomo homo kekerenapo. Himumo soko kakaro koteaka hemakapukua kekerenapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Airakano hinamoamo someraka, “Kotimo unihaeaka rekeasimo murikimasa aporo Keresoane peakosapo. Aíyaka nōmo hemakapurakaripo. E peraka makata suane isuaki somehokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Airakano Yasumo someraka, “Nómo somerakane, anopo. Nómo someraka yiamo neaki somerakanapo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Arirakano Yasumo aporo hakāsa pura popariperaka aseane Yasumo hinamoaki somerakano asekea, fofaraka makata meta somesafapo. “Marirakano hinamoaki somerakanare? Makata yakapa makasierakanare?” Aiyaka soko ipu somesafapo. ");
INSERT INTO faa_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Arirakano hinamoamo ipi petoroane metakarikia, apea foaka paripukua aporo hinamoaki someraka, ");
INSERT INTO faa_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Nōmo fana kake makata su rakisiane aporoamo anoaki somerakasapo. Fana epo ano asekeanafonosa nine nōmo aina suane somerakasapo. E aseako peae. Keresoane erakapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Airakano aporo hinamomo namina ape metakarikia Yasu rea aseako pesapo. Ikia kara peraka arisiamo ");
INSERT INTO faa_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yasumo aporo hakāsa puramo eaki someraka, “Tisao, makata nesie.” ");
INSERT INTO faa_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Airakano Yasumo someraka, “Nōmo makata nenane repo hemakapurakarifapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Airakano aporo hakāsa puramo namina yia someraka, “Aporo metamo makata nakosa maka pekea eaki karakasare?” ");
INSERT INTO faa_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Airakano Yasumo someraka, “Epo ano pusiesamo epo hemakapusuane nōmo kekemaraka, ipi makata rakirane nōmo rakikia marakano nōmo makata nena asiane ayapo. ");
INSERT INTO faa_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Arirakano repo someraka, ‘Ere maiya kitafasu faraka witi hae susekeno tumokoakosapo.’ Airakano nōmo someraka, Hemoane asesie. Witi hae tumokoasimo yumo surareapo. ");
INSERT INTO faa_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Witi hae tumora aporomo makata ropo yumo morakanapo. Witi hae tumora ayiáka aporo Yasuyaki yaiya risikiasimo pasimorakanapo. Witi hae potena aporo soko, arirakano witi hae tumora aporo soko, tetā tatī sesehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Fana aporo metamo someraka, ‘Aporo metakiramo makata mano potenapo. Arirakano aporo metakiramo tumorapo.’ Aíyaka somesane kakaro somehoareapo. ");
INSERT INTO faa_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Arirakano aporo metakiramo makata mano poteraka asekea nina, makata mano potesane taneheheraka hemoa wate pesane repo tumokoako nōmo pusierakanapo. Aporo metakiramo wafororaka rakisia nine wate pesane repo tumorakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aíyaka Yasumo ipi aporo hakāsa puraki takumeaka someraka reakipoko hinamoamo ipi apea someraka, “Ano fana kake makata su rakisiane anoaki somerakasapo.” Aisasamo Sameria aporo hinamo yakaimo Yasuaki himu hakásaraka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ipu namina ape metakarikia Yasu rea pekea someraka, “Ne isiapo apea waka rekeako peae.” Airakano Yasu ipu apea pukua iyaki yape tetá waka reapo. ");
INSERT INTO faa_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Waka reke epo some karakano aporo yakai metakiramo soko epo somesane kakimasapo. ");
INSERT INTO faa_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kakimaraka hinamoaki ipu someraka, “Nómo somesa hákasa kaikia eaki himu hakásaraka hemakapuraka asiafapo. Yasumo ipi soko somerakano kaikia isiapo eaki himu hakásaraka hemakapurakanapo. Epo aporo hinamo su mafasiako apere, aíyaka isiapo hemakapurakaripo,” aíyaka ipu somesapo. ");
INSERT INTO faa_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Sere tetá faraka, aporo hinamo ipu ape Saika apeane Yasumo metakarikia Kariri hauaka á pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Pukua Yasumo iaki someraka, “Kotimo some kará porofete aporomo ipi ape sumu aporo hakāsa risia amo soko, ipi ape wará aporo hakāsa risia amo soko, eane makama fananafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Asia nine e Kariri hauaka perakano asekea Kariri aporomo e teresapo. Fana Ape Farimaresa Hemakapuko Hokono Akera maiya amo i namina Yarusarame sitia hikia aseane Yasumo makata su rakirakano asesapo. Asesasamo Yasuaki teresapo. ");
INSERT INTO faa_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Arirakano Kariri hauaka á Kena taonea Yasu paripusuapo. Fana Kena taonea epo namo heane waene he maparisapo. Arirakano Kena taonea kamania makata rakisia aporo Kapaneame taone aeyaka kimisi pesapo. Ipi apea ipi hokosa makata takamasa warekeno metakarikia Kena taonea kimisi pesapo. ");
INSERT INTO faa_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Kimisi pekea rea maiya amo kaiyiáne, Yasu Yutía hauakane metakarikia Kariri hauaka wo pesapakano kaikia, e Yasu rea pekea someraka, “Nōmo aporo hokosa kára makata takamasa kukusipo. Hokosane mafahoko Kapaneame taonea peae.” ");
INSERT INTO faa_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Airakano Yasumo someraka, “Kotimo wakapumo hemakapukua rakira asekeanafonorakano repo anoaki himu hakásaraka hemakapukusafapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Airakano kamania makata rakisia aporoamo someraka, “Aporo fanao, nōmo hokosa kukukohoamo nōmo apea peae.” ");
INSERT INTO faa_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Airakano Yasumo someraka, “Né pusie. Nómo hokosa koteaka rekenapo.” Airakano someane kamani aporoamo kakimaka ipi apea pukua ");
INSERT INTO faa_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ikia kara peane, ipi aporo raipamo e sapenekea someraka, “Ní hokosa fasapo. Koteaka rekenapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Airakano kamania makata rakisia aporoamo someraka, “Fasane masinaka fasare?” Airakano ipu someraka, “Rau samapu wane korokomo ipi kau sisipusane fasapo.” ");
INSERT INTO faa_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Airakano hokosamo ipi atamo hemakapuraka, “Rau samapu wane korokomo Yasumo someraka, ‘Ní hokosa koteaka rekenapo.’ Aisa maiya amo kau sisipusane fahoareapo.” Aíyaka hemakapukua ipi soko ipi aseamo soko, ipi hokosamo soko, ipu namina suamo Yasuaki himu hakásaraka hemakapukua risiapo. ");
INSERT INTO faa_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Asiamo Yasu Yutía hauaka metakarikia Kariri hauaka paripesa maiya amo, hokosa mafasa ane Kotimo wakapumo hemakapukua rakira yape tetáne ayapo. ");
INSERT INTO faa_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wakasema nina Yu aporomo Kotiaki kekerehoko hokono kesapo. Hokono akera maiya amo Yasu Yarusarame sitia hisiapo. ");
INSERT INTO faa_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yarusarame sitia ekemo rurusane ikia koro yakai otoro mosapo. Ikia koro hakása metane yano motosa Saro Sipi Ikia Koropo. Arirakano ikia koroane makeraka he kafa kesapo. Yu aporomo Hipuru meaka he kafa ane yano motosa Petésata yano motosapo. He kafa he fea ape mano kakoreasu kisiakipoko á aporo yakai makata tasa warisiapo. ");
INSERT INTO faa_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Warisiane aporo metakira hi fausa soko, aporo metakira kakuna masa soko, aporo metakira korosakataesa soko i warisike, hea makakayahoasimo warisiapo. ");
INSERT INTO faa_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Warisike aseane Unihaemo hepene aporo pekea he kafa makakayarakano, aporo makata tasa warisiane hakása meta fana pukua, he kakayarakano he tapuane ipi makata takamasane farakano anapo. ");
INSERT INTO faa_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Airakipoko aporo hakása meta keremisi teti aitimo (38) makata takamasa reke, ape manoa warekeno, ");
INSERT INTO faa_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yasumo asekea hemakapuraka, “Aporoane maiya káramo makata takamasa wareareapo.” Aíyaka hemakapukua Yasumo aporoaki someraka, “Ne makata takamasane fahoasimo hemakapurakarire?” ");
INSERT INTO faa_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Airakano aporoamo someraka, “He kakaya ana maiya amo ano hea pukusakipoko asiane, aporo metamo ano hea maka pusuafapo. Ano maka punafonorakano kakape puraka reakipoko, aporo meta fana pukua hea tapusesapo.” ");
INSERT INTO faa_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Airakano Yasumo someraka, “Ne takahisie. Ní asakapu maweroraka maka pusie.” ");
INSERT INTO faa_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Aihoanine aporoane wate faraka takahikia ipi asakapuane maweroraka maka pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Fenena maiya amo aporoamo asakapu maka purakano, Yu aporo sisima unihae suamo aporo makata takamasa mafasaki someraka, “Pipu fenena maiyapo. Fenena maiya amo asakapu maka pukupo. Aíyaka fana somemane motosusupo.” ");
INSERT INTO faa_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Airakano aporoamo someraka “Aporo ano mafasa amo someraka, ‘Ní asakapu maka pusie,’ airakasapo.” ");
INSERT INTO faa_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Airakano ipu someraka, “Asakapu maka pusiesane aporo epamo aíyaka somerakasare?” ");
INSERT INTO faa_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Airakano aporo hinamo yakai sarimasakipoko Yasu kokororaka pusuapo. Pusuakipoko aporo makata takamasa mafasamo someraka, “Aporoane eparakapo. Ano himeteripo. E pureapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Aíyaka wakasema nina Yasu Kotimo apea koraka reke, epo aporo mafasane aseraka someraka, “Ní makata takamasane farareapo. Makata watikisa rakirane efera hunia rakiakopo. Makata takamasa káranapaka makata watikisane kakaro metakarinie.” ");
INSERT INTO faa_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Airakano aporoane pukua Yu aporo sisima suaki someraka, “Yasumo ano mafasapo.” ");
INSERT INTO faa_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Airakano ipu hemakapuraka fenena maiya amo Yasumo aporo makata tasane mafasapo. Aíyaka hemakapusuasamo ipu Yasuane mokoatikisapo. Yasumo fenena maiya amo rakisiasamo ipu Yasuane hukurusuapo. ");
INSERT INTO faa_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ipu hukururakano Yasumo someraka, “Maiya suamo nōmo Atamo rakiraka rekenapo. Nōmo soko rakiraka rekenapo.” ");
INSERT INTO faa_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Aíyaka somerakano Yu aporo sisima suamo, “Yasu rusua kukusapo,” aíyaka hemakapusuapo. Fenena maiya yaposane Yasumo metakarikia, arirakano epo someraka, “Kotiane nōmo Atapo.” Aíyaka Yasumo ipi yia máfaraka, ano Koti asiapo airakae. Airakasakipoko Yasuane rusua kukusapo, aíyaka Yu aporo sisima suamo hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yu aporo sisima suamo Yasuaki hukururakano Yasumo iaki some paripuraka, “Nōmo reaki kakaro somerakaripo. Ano Kotimo hokosasamo, nōmo nī hemakapusua aeyaka rakirafapo. Nōmo Atamo rakirane asekea hakása yineraka rakirapo. Nōmo Atamo rakira ayiáka, nōmo soko hakása yineraka rakirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Atamo himu tumurumo anoane hemakapukua epo ipi makata rakira suane anoaki tarirakanapo. Tarisiane marokeraka makata kára meta tariakosapo. Tarirakano nōmo makata kárane rakiakosapo. Rakirakano repo asekea someraka, ‘Uao, itifisiafapo,’ aihokosapo. ");
INSERT INTO faa_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Arirakano Atamo aporo kusua maturikia taeraka yaiya rerane akara ayiáka, nōmo soko ayiáka yaiya rera kakakosapo. Nōmo nī hemakapusua aporo murikimasaki yaiya rerane kakakosapo. ");
INSERT INTO faa_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Arirakano Atamo aporo hinamoane fanasihoko hukururafapo. Epo ipi hokosa anoaki someraka, ‘Aporo hinamo fanasihokosane nómo hukurunie,’ aisapo. ");
INSERT INTO faa_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Aisasamo aporomo Koti makárana ayiáka Kotimo ipi hokosa makárahoasimo, ‘Nómo hukurunie,’ aíyaka Kotimo ipi hokosane murikimaka maresapo. Aporomo Kotimo hokosane makárahoanafonorakano, hokosa pusiesa amo ipi Ata Kotiane soko makáranafapo. ");
INSERT INTO faa_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Hao, kaisie. Nōmo reaki kakaro somerakaripo. Nōmo somesane aporo hinamomo kakimaka, arirakano ano pusiesa aki himu hakásaraka hemakapukua risira aporo hinamoane yaiya risike fahokosafapo. Iane hukurukua fanasihokosafapo. Kura faraka farearaka rera takua risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Hao, kaisie. Nōmo kakaro somerakaripo. Aporo hinamomo Kotiaki himu hakásaraka hemakapunafonosane kusua ayiáka risikinapo. Aporo hinamo kusua ayiáka risia amo nōmo meane kaikia kekemarakano, keseke maturikia taena maiya amo i yaiya risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yaiya rera kepoane nōmo Atapo. Nōmo Atamo yaiya rerane ipi hokosa anoaki kasapo. Kasasamo yaiya rera kepoane ano sokopo. ");
INSERT INTO faa_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Aporomanomo Tákeane anopo. Asiasamo hukuarura maiya amo aporomanoane parakuhoasimo Atamo ipi hokosa ano murikimaka maresapo. ");
INSERT INTO faa_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Fofahokopo. Keseke aporo hinamo su kusua hauaka murisia amo soko, nena yaoa kukua kesa amo soko, ipu suamo nōmo meane kaikia, ");
INSERT INTO faa_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","hauaka murisiane metakarikia turikia tariakosapo. Aporo hinamo hitaferaka risia maiya amo koteaka risia aporo hinamoane turikia tarirakano iaki nōmo someraka, ‘Anoyaki yaiya risie,’ aihokosapo. Arirakano aporo hinamo hitaferaka risia maiya amo watikiaka rakiraka risia aporo hinamoane turikia tarirakano iaki nōmo someraka, ‘Reane fanasinane nōmo motorakanapo,’ aihokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Arirakano Yasumo someraka, “Nōmo nī hemakapusuane nōmo kekemaraka rakirafapo. Kotimo, ‘Ayiáka hukurunie,’ airakano nōmo ayiáka hukururapo. Epo ano pusiesamo epo hemakapusua ayiáka nōmo soko ayiáka hemakapukua rakirapo. Nōmo hemakapusua ane makama kesekenapo. Asiasamo nōmo koteaka ereketaeraka hukurukua maroponapo. ");
INSERT INTO faa_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nōmo nī ainane nōmo nī yiamo somehoane siahoasifareapo. Nōmo nī ainane nōmo nī hákasa somerakano repo kotaferakae, aihokosapo. ");
INSERT INTO faa_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Arirakano Koti ipi wikinisi meta reke, nōmo ainane somehokosapo. Nōmo ainane Kotimo somerakano epo kakaro somerapo, aíyaka nōmo hemakapurakanapo. ");
INSERT INTO faa_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Fana Yu aporo sisíma répo aporo metakiraki someraka, ‘Yonemo some kepoane kaiyako pusie.’ Airakano Yone rea ipu kaiyako pusuapo. Pukua Yone rea perakano Yonemo anoane kakaro somesapo. ");
INSERT INTO faa_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yonemo somesane nōmo kaiyisimo Yonemo somesafapo. Repo kaiyisimo Yonemo somesapo. Asiamo re mafasiakosakipoko nōmo reaki mahemakapukua somerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Arirakano nafa faena ayiáka, Yonemo maropohoko pekea some kasámo, nafa faena ayiáka faesapo. Faesa á re maiya wakasemamo risike epo somesane seseaka kaisiapo. ");
INSERT INTO faa_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Arirakano nōmo makata ayianamo Yonemo somesane marokerakanapo. Asiamo nōmo atamo rakiniesane nōmo wakapuaka rakirakano repo asekea hemakapuraka, ‘E Kotimo pusiehoareapo.’ Aíyaka repo hemakapusimo rakirakanapo. Arakiramo Kotimo ano pusiesane reaki tarirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Arirakano Kotimo soko nōmo ainane asekea tarirakanapo. Epo ipi ano pusiesamo nōmo ainane somerakanapo. Somerakano ipi meane repo kairakarifapo. Ipi hikumisiane repo aserakarifapo. ");
INSERT INTO faa_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Epo pusierakano pesa aporoaki repo himu hakásaraka hemakapurakarifapo. Hemakapunafonoraka epo pusiesamo someane soko repo hemakapurakarifapo. ");
INSERT INTO faa_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yaiya risikiakosakipoko repo Kotimo sawia popasane kokoa menoanane. Kotimo sawia popasa amo anoane tarikia somerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Somerakano yia yaiya risikiakosakipoko ano rea re perakarifapo. ");
INSERT INTO faa_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","Repo himuane nōmo aserakaripo. Aseane repo Kotiaki himu tumurumo hemakapunafonorakano aserakaripo. Asiamo repo ano makáraraka soko metao, mawakasemaraka soko metao, ane nenakamaka makata asiapo. ");
INSERT INTO faa_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Arirakano nōmo atamo hemakapusuane nōmo kekemaraka, ipi yano motosa aeyaka ano pesapo. Ano pesane repo patera atarire. Arirakano aporo metamo epo ipi hemakapusua rupiaka rakipe peraka, epo ipi yano motosa máfarakano eaki repo patera asere. ");
INSERT INTO faa_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Aporomo re asekea someraka, ‘Aporoane kotesapo,’ aihoasimo repo namina yia kaumo arakire. Arirakano Kotimo re aseraka, ‘Aporoane kotesapo,’ aihoasimo repo rakirafapo. Rakianafonorakano Kotimo someane soko repo kakimakasifareapo. Koti ipi hákasapo. Koti meta rekenafapo. ");
INSERT INTO faa_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","47","Repo someraka, ‘Isiapo Mosesemo somemaneane kekemaraka risikino Kotimo isu pasimokoakosapo.’ Aíyaka hemakapurane kotafe hemakapurakanapo. Fana Mosesemo anoane popasapo. Popasane repo kakimasa satiki, nōmo someane soko kakimakafunureapo. Epo someane repo kakaro kakimakanafonosasamo nōmo someane soko kakimakosafapo. Epo someane kakimakanafonosakipoko epo re pasimokoa Kotiaki hukurukusapo. Nōmo re pasimokoa Ataki hukurukusafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","4","Ape Farimaresa Hemakapuko Hokono Keakosa maiyane makerakano, Yasu paripukua, he Kariri teraporaka taku ra pusuapo. He Kariri ane yano motosa meta he Taipiriasepo. Aporo hinamo makata tasane Yasumo mafarakano aporo hinamo yakaimo asesasamo Yasu patera kekemarape perakano, Yasu ūria hikia ipi aporo hakāsa purayaki toke ");
INSERT INTO faa_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","aseane, aporo hinamo yakai perakano asekea Firipiaki Yasumo someraka, “Aporo hinamo suamo makata nakosane isiapo ma ropohokosare?” ");
INSERT INTO faa_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Aíyaka Firipiane kau aseakosakipoko Yasumo somesapo. Asiamo Yasumo ipi ayiakakosane hemakapukua reke Firipiaki kaisiapo. ");
INSERT INTO faa_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Kairakano Firipimo someraka, “Aporo hinamo yakaisakipoko ipu suamo feteaka nasimo mone tu harote kinamo (K200) ropohoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Airakano aporo hakāsa pura hakása meta Saemone Pitamo mamanea Enitumo someraka, ");
INSERT INTO faa_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Aporo hokosa metamo farawa parosane kakoreasu, arirakano pokoa tetá ayiáka atoae. Asiamo aporo yakaisakipoko sia nasifareapo.” ");
INSERT INTO faa_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Airakano Yasumo aporo hakāsa puraki someraka, “Aporo hinamo su toaesie.” Airakano asane sususakipoko a toapo. Aporo á toa susuane menosane fae taosene (5,000) ayiáka menosapo. ");
INSERT INTO faa_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Arirakano Yasumo farawa maka Kotiaki suseaka kurikuriraka rumaraka aporo toaki kasiesapo. Pokoa soko maka suseaka kurikuriraka rumaraka aporo toaki kasiesapo. Kasierakano aporo hakāsa puramo kasapo. Karakano aporo suamo siaraka nesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Siaraka nenakano aporo hakāsa puraki Yasumo someraka, “Farawa nekea siarakano metakira yia tokeno mosie. Nenakamaka yaoa mokoatehokopo.” ");
INSERT INTO faa_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Airakano i pukua farawa yia tokeno mokoa, mate keno sua kekea komarukua taesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Arirakano farawa hukusi kakorea suane Yasumo makáraraka ayiáka, Kotimo wakapumo hemakapukua rakirane rakirakano aporomo asekea someraka, “Porofete aporo kára hauaka wo peakosaposane ereapo.” ");
INSERT INTO faa_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Airakano Yasumo hemakapuraka, “Aporo suamo anoane maka Rome kamani aporoane marokeraka unihaeaka asekea rekeasimo mareakosakipoko hemaka apure.” Aíyaka Yasumo hemakapukua ipu ayiakakohoamo ipi haku ūria hisiapo. ");
INSERT INTO faa_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Samapu maiya tuakeramo aporo hakāsa pura he Kariria pukua, ");
INSERT INTO faa_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","kasu ripaka Kapaneame taone taku ra poparipukusakipoko, kasu rokoa puraka risiapo. Kasu rokoa puraka risikiyia yao eresapo. Ereamo Yasu peanafonorakano kasu rokoa puraka risiapo. ");
INSERT INTO faa_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Rokoa puraka risike atifo he kupayaki kára pesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Perakano he numu tipia rokoa puraka risike aseane kasu erekeraka Yasu he kima finirape perakano asekea, i kara namoraka himu fasapo. ");
INSERT INTO faa_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Himu farakano Yasumo someraka, “Anopo. Namohokopo.” ");
INSERT INTO faa_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Airakano ipu someraka, “Ao, kasua ripasie.” Airakano Yasu kasua parorakano aseane kasuane he fe taku ra foakayia paurakano asesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mituru fiarakano aporo hinamo yia popariraka risiamo hemakapuraka, “Kasu hakása humaresa Yasumo aporo hakāsa pura ripaka pusuapo, Yasu iyaki hakāsa ripaka pusuafapo. Yasu masiarakapo.” Aíyaka hemakapukua ");
INSERT INTO faa_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","aseane kasu metakira Taipiriase taone aeyaka pekea karimaresane asesapo. Arirakano Unihae Yasumo farawa soko, pokoa soko, Kotiaki suseaka someaka, makata siaraka nesa hauaka ane makeraka kasu metakirane karimarerakano asesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Arirakano ipu Yasu soko Yasumo aporo hakāsa purane soko koane fasekeno asekea, kasu karimaresa á i ripaka, ipu Yasu kope Kapaneame taone taku ra rokoa pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Arirakano aporoamo kasu rokoa pukua taku ra pauraka ipu Yasuane kokoa aseraka someraka, “Tisao, ne masinaka pesare?” ");
INSERT INTO faa_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Airakano Yasumo someraka, “Nōmo kakaro somerakaripo. Repo farawa siaraka nesakipoko repo ano kope apere. Nōmo Kotimo wakapumo hemakapukua rakirane rakirakano repo asekea hemakapukua kope perakayiafareapo. ");
INSERT INTO faa_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Hauaka wo makata nenane torehokosapo. Makata akipoko rakiakopo. Re yaiya rera makata nena makosakipoko rakinie. Makata nenane nōmo reaki kakákoripo. Aporomanomo Tákeane anopo. Yaiya rera makata nenane reaki kakákoripo. Kakasimo nōmo Ata Koti ipi yiamo ano murikimaka maresapo.” ");
INSERT INTO faa_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Airakano ipu someraka, “Kotimo makata rakirane isiapo yakapa rakiaere? Kotimo makata yakapa sesenare?” ");
INSERT INTO faa_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Airakano Yasumo someraka, “Kotimo makata rakira sesenane oyapo. Kotimo e pusierakano pesa aporoaki himu hakásaraka hemakapukua risikianie.” ");
INSERT INTO faa_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Airakano ipu someraka, “Isiapo neaki himu hakásaraka risikiako, nómo Kotimo wakapumo hemakapukua rakirane nómo rakikitakae. Isiapo neaki hemakapusimo nómo makata yakapa wakapuaka rakiakosare? ");
INSERT INTO faa_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Wate fana ima yaoa makata nakosa hurupeperakano isiapo makasa kamumamo nesapo. Kotimo sawia poparaka, ‘Hepene yapunaka epo makata nakosa kasapo.’ Aíyaka popasane isiapo menosapo. Mosesemo makata rakisia ayiáka nómo rakiasireare?” ");
INSERT INTO faa_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Airakano Yasumo someraka, “Nōmo kakaro somerakaripo. Hepene yapunaka makata nená kasáne Mosesemo kasafapo. Arirakano yumo hepene yapunaka kakaro makata nenane nōmo Atamo karápo. ");
INSERT INTO faa_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Asiamo Kotimo kakaro makata nena karáne e hepene yapunaka perakano hauaka wo aporo hinamo suaki yaiya rerane karápo.” ");
INSERT INTO faa_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Airakano ipu someraka, “Aporo fanao, makata nenane isuaki yaiya karáka rekeanie.” ");
INSERT INTO faa_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Airakano Yasumo someraka, “Kakaro yaiya rekeakosa makata nenane anopo. Anoaki himu hakásaraka hemakapukua risike, hunia ‘meamoripo,’ aihokosafapo. Nōmo someane kakimaka risike, ‘he nariripo,’ aihokosafapo. ");
INSERT INTO faa_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Repo ano aseraka, asekea ayiáka repo anoaki himu hakásaraka hemakapurakarifapo. Hemakapunafonorakano nōmo reaki someraka ayapo. ");
INSERT INTO faa_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Aporo hinamo nōmo Atamo anoaki karakano, i ano rea peakosapo. Perakano iaki nōmo peakopo aihokosafapo. ");
INSERT INTO faa_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nōmo nī hemakapusua rakiako pesafapo. Nōmo Atamo ano pusiesamo hemakapusuane nōmo rakiako pesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nōmo Atamo ano pusiesapo. Epo hemakapusuane oyapo. Aporo hinamo epo anoaki kasáne, hakása soko hasaka koakohoamo, suane nōmo metakariakosafapo. Fa ana sere amo iane nōmo maturikia taehoasimo, aíyaka Kotimo hemakapukua someaka maresapo. ");
INSERT INTO faa_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Asiamo nōmo Atamo hemakapusuane oyapo. Aporo hinamo metakiramo Kotimo hokosa anoane aseraka someraka, ‘E Kotimo hokosapo,’ aíyaka someraka, ipu Kotimo hokosa anoaki himu hakásaraka hemakapukua risikino, yaiya rerane mokoakosapo. Asiamo fa ana sere amo iane nōmo maturikia taehokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Aíyaka somerakano Yu aporo sisima suamo kaikia mahisisapo. Arirakano Yasumo someraka, “Hepene yapunaka pesa makata nenane anopo,” aisane ipu kaikia mahisisapo. Mahisiraka someraka, ");
INSERT INTO faa_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Aporo ane Yasupo. Ipi Yosefemo hokosapo. Ipi wafaya ipi kaīyia isiapo aserapo. Mayiáka hepene yapunaka pesaporakanare?” ");
INSERT INTO faa_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Airakano Yasumo someraka, “Repo namina susu hisiraka somehokopo. ");
INSERT INTO faa_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Aporomo hemakapuraka, ‘Nōmo Yasuaki himu hakásaraka hemakapukua rekeakosapo,’ aíyaka hemakapura ane nōmo Atamo eaki karakáno, aporoamo ano patera aseakosapo. Patera aserakano fa ana sere amo aporoane nōmo maturikia taehokosapo. Arirakano aporomo anoaki himu hakásaraka hemakapurane nōmo Atamo aporoaki kakanafonorakano aporoamo ano patera aseakosafapo. ");
INSERT INTO faa_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Arirakano porofete aporo suamo poparaka, ‘Aporo suamo enomakasimo Kotimo tarirapo,’ aíyaka popahoareapo. Asiamo Atamo someane aporo hinamomo kakimaka, anoaki risikiako pariraka, anoaki himu hakásaraka hemakapukua risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Arirakano Kotimo hauaka aeyaka pesa aporo hákasamo Ata ane asesapo. Aporo metamo Ata ane asesafapo. ");
INSERT INTO faa_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nōmo kakaro somerakaripo. Kakimara aporo hinamoane Kotiyaki yaiya risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yaiya rera makata nenane anopo. ");
INSERT INTO faa_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wate fana ima yaoa makata nenane repo makasa kaua kekemamo nenaka, wakasema risina, keseke kukua kesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Hepene yapunaka makata nená pesane repo maka nenakano yaiya risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yaiya rera makata nená hepene yapunaka pesane anopo. Makata nena ane aporo hinamomo nenakano yaiya risikiakosapo. Aporo hinamo su yaiya risikiasimo makata nená kakakosane ano kaupo.” ");
INSERT INTO faa_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Airakano Yu aporo sisima suamo kairaka saperaka tafatafaraka someraka, “Isiapo nasimo epo kau isuaki mayiáka kakakosare?” ");
INSERT INTO faa_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Airakano Yasumo iaki someraka, “Nōmo reaki kakaro somerakaripo. Ano Aporomanomo Táke reke, ano kau ano yapi repo nanafonorakano yaiya rerane re tua kepomaresafapo. ");
INSERT INTO faa_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ano kau, ano yapi, aporomo nenaka, yaiya rerane re tua kepo amarera ayapo. Fa ana sere amo nōmo re maturikia taerakano yaiya risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Makata nena kepoane ano kaupo. He nena kepoane ano yapipo. ");
INSERT INTO faa_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ano kau soko, ano yapi soko nenakano, né ano tua rekenapo. Ano soko né tua rekenapo. ");
INSERT INTO faa_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Atamo ano pusierakano pekea, epo wakapua nōmo kataka marekea rekenapo. Asiamo repo soko anoane nenakano nōmo wakapua repo kataka marekea risikinapo. ");
INSERT INTO faa_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kakaro makata nená hepene yapunaka pesane anopo. Aporo hinamomo nenakano Kotiyaki yaiya risikiakosapo. Arirakano makata nená isiapo makasa kaua kekemamo nesane hakása yiyafapo. Makata ane ipu nekea risina kusuapo. Asiane hepene yapunaka pesa makata nená ane nenakano Kotiyaki yaiya risikiakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Aíyaka Kapaneame Yu aporomo sarimana apea Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Arirakano Yasumo somerakano ipi patera asesa aporo metakiramo kaikia someraka, “Someane umihoareapo. Mayiáka kakimakosare?” ");
INSERT INTO faa_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Aíyaka ipu himumo hemakapusuane Yasumo asekea someraka, “Marirakano re hisiraka risikinare? ");
INSERT INTO faa_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ano Aporomanomo Tákeane pekea nina, fana rea hauaka á parihinakano repo asekea yakapa hemakapukusare? ");
INSERT INTO faa_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Arirakano Kotiyaki yaiya risikiakosane Ho Kotesamo karápo. Aporomo kaumo wakapuamo karáfapo. Nōmo someraka one Ho Kotesamo wakapuane soko, yaiya risikiakosamo wakapuane soko someraka ayapo. ");
INSERT INTO faa_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Aíyaka somerakano repo metakiramo kairaka kaisianeo, kakimarakarifapo.” Aíyaka Yasumo somesapo. Arirakano kepomaresa maiya amo Yasumo aporo su asekea hemakapuraka, “Kakimakanafonosa aporoane ayapo. Ano parakehokosa aporoane ayapo.” Aíyaka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Efera hunia Yasumo someraka, “Anoaki himu hakásaraka hemakapukua rekeakosapo, aíyaka hemakapurane Kotimo kakanafonorakano aporoamo anoaki himu hakásaraka hemakapukua rekeakosafapo. Aíyaka nōmo someraka ayapo.” ");
INSERT INTO faa_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Aíyaka Yasumo somerakano eyaki aporo hakāsa pura yakaimo e metakarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Metakarikia purakano Yasumo ipi aporo hakāsa pura keno suaki someraka, “Repo soko ano metakariakosare?” ");
INSERT INTO faa_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Airakano Saemone Pitamo someraka, “Unihaeo, meta epayaki isu pukusare? Yaiya rera kepoane nómo some akare. ");
INSERT INTO faa_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Some karakano isiapo kakimarakanapo. Né Kotimo hokosa murikimaka pusiesapo. Makata watikisane kikisiraka kotesa susu rerane nepo. Aíyaka isiapo hemakapurakaripo.” ");
INSERT INTO faa_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Airakano Yasumo someraka, “Re aporo kenosu ane nōmo murikimasapo. Kenoane Satanemo aporo irapo.” ");
INSERT INTO faa_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Aíyaka Isekerio aporo Saemonemo hokosa Yutaseane Yasumo somesapo. Aporo hakāsa pura kenoane Yutasepo. Yasu ipiane parakehokosane somesapo. ");
INSERT INTO faa_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Yasu Kariri hauaka koraka nina Yutía hauaka aeyaka Yu aporo sisima risiamo someraka, “Yasu rusua kukusapo,” aisapakano Yasu Yutía hauaka á hisiafapo. ");
INSERT INTO faa_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Wate fana Ape Fete Kikia Risia maiyane Yu aporo hinamomo Hemakapuko Hokono Kesapo. Hokono keako makeanamo ");
INSERT INTO faa_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Yasumo ipi mamaneamo eaki someraka, “Né patera asesa aporo hinamo Yutía hauaka risiamo nómo wakapuaka rakirane asekeasimo, hauaka one metakarikia Yutía hauaka a hinie. ");
INSERT INTO faa_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Aporomo hokopukua rekeakosakipoko ipi makata rakirane faremarekea rakirafapo. Aporo hinamo suamo asekeasimo mafekemaraka rakirapo. Asiamo nómo wakapuaka rakirane aporo hinamo suamo asekea neaki himu hakásaraka hemakapusimo rakinie.” ");
INSERT INTO faa_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aíyaka ipi mamaneamo Yasuaki himu hakásaraka hemakapunafonoraka aíyaka mahokopariraka somesapo. ");
INSERT INTO faa_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Aíyaka somerakano Yasumo someraka, “Aporo hinamo suamo asekeasimo makata rakiakosa maiya ane pipu oyafapo. Maiya suamo repo rakiane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yumo soko keseke soko repo rakirane aporomo aseraka hisihokosafapo. Anoaki hákasa hisirakanapo. Nōmo kakama someraka, ‘Repo watikiaka rakirakanapo.’ Airakano aporomo anoaki mahisirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Re namina hokono keako hisie. Yumo ano hiakosafapo. Pipu repo maiyapo. Nōmo maiyane harufapo.” ");
INSERT INTO faa_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aíyaka e Kariri hauaka yia parisapo. ");
INSERT INTO faa_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yasumo ipi mamanea fana Yarusarame sitia hisiakipoko, Yasu wakasema asekea nina, keseke aporo hinamo suamo aserapaka e tau kesekea papaterarape hisiapo. ");
INSERT INTO faa_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Arirakano Yarusarame sitia Yu aporo sisima metakiramo someraka, “Yasu masiare?” aíyaka hokono kesa apea kope pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Arirakano aporo metakira sarimaraka namina susu tau someraka, “Yasu ipi aporo kotesareapo.” Airakano aporo metakiramo someraka, “Wae, epo aporo hinamo ikia kara hasaka pusimo karikia tarirakanapo.” Aíyaka aporo yakaimo tau me rusuapo. ");
INSERT INTO faa_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Me rukua tau meakamaka somesane Yu aporo sisimamo kaikia hukururapaka ipu sakepamo hufitaeaka somesafapo. ");
INSERT INTO faa_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Arirakano hokono keraka risikiyia fahoko makerakano Yasuane Kotimo apea pukua some kasapo. ");
INSERT INTO faa_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Some karakano Yu aporo sisimamo fofaraka someraka, “Sawi menonane epo mayiáka enomasarakapo. Eane isiapo somemane tisa aporo káramo sukurusafapo.” ");
INSERT INTO faa_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Airakano Yasumo someraka, “Kotimo ano pusiesamo anoaki some kasane nōmo reaki some karakanapo. Nōmo nī hemakapusuane some karakanafapo. ");
INSERT INTO faa_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nōmo nī hemakapusua hákasane nōmo some karakano soko metao, Kotimo hemakapusuane nōmo some karakano soko metao, mayiáka repo hemakapukusare? Kotimo hemakapusua kekemaraka rakiako hemakapura aporoamo nōmo somesane takekea kepo hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Arirakano aporomo ipiane makárahokosakipoko ipi hemakapusuane some karápo. Arirakano ano pusiesa aporoane makárahoko hemakapuraka nōmo kakaro koteaka some karápo. Ano niane makáraraka some karáfapo. Kotafe some karáfapo. ");
INSERT INTO faa_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Arirakano Mosesemo somemaneane reaki some kasa nine repo kekemaraka hemakapukua rakirafapo. Marirakano repo ano rusua kukuko hemakapurakanare?” ");
INSERT INTO faa_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Airakano aporo suamo someraka, “Ne masuarareapo. Epamo neaki rusua kukusapakasare?” ");
INSERT INTO faa_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Airakano Yasumo someraka, “Fenena maiya hakása metamo nōmo hemakapukua wakapuaka rakirakano repo someraka, ‘Epo marirakanare? Fenena maiya yaposane epo koaretaerakanapo,’ airakasupo. ");
INSERT INTO faa_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Asiane repo namina makasa kaua kekemamo aporo hokosa takaperakano, hokosa takapesa hokono ane menorape hikia karimo aporo hokosa kau hahaeraka patehoanie, aíyaka repo namina makasa kaua kekemamo somemane motosapo. Ipu somesane Mosesemo soko ayiakaniesapo. Asiamo fenena maiya yiamo sere karia paurakano aporo hokosa kauane hahaeraka patenapo. ");
INSERT INTO faa_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Asiamo Mosesemo somemaneane koaretaenapaka fenena maiyamo soko, repo aporo hokosa kauane hahaeraka patenapo. Mosesemo ásia ayiáka fenena maiyamo nōmo aporo makata takamasa mafasane marirakano repo saperakanare? ");
INSERT INTO faa_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Wakasema asekea foaka hukuruane siahoasifareapo. Kepoane koteaka hemakapunie. Kepo kakaro hemakapukua ereketae takekea hukuruane siahoasireapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yarusarame aporo metakiramo Yasuane aseraka someraka “Aporo rusua kukusaposane ere? ");
INSERT INTO faa_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aporo suamo kaiyisimo hauaka kakamasakipoko á epo some akare. Epo someane aporo metamo hurutapirakanafapo. Epo someane hurutapirafaraka Kotimo unihaeaka rekeasimo murikimasa aporo Keresoane erakapo,” aíyaka ipu hemakapukua somesapo. ");
INSERT INTO faa_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Arirakano “Kereso fasereperakano ipi faserepesa kepoane isiapo hemakapukusafapo. Asiane Yasu ipi takapesa apeane isiapo asesapo. Asesasamo e Keresofapo.” Aíyaka Yarusarame aporo metakiramo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Airakano Kotimo apea Yasumo sakepamo someraka, “Repo ano kakaro aserapo. Ano takapesa apeane soko repo aserapo. Repo asesa nine nōmo kakaro kepoane repo himeteraka hemakapurakanafapo. Arirakano ano ni hemakapusua aeyaka kekemaraka pesafapo. Metamo ano pusierakano ano pesapo. Eane repo himeteraka, ");
INSERT INTO faa_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","arirakano nōmo eane hemakapurapo. Epo ano pusierakano e aeyaka ano pesapo.” ");
INSERT INTO faa_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Airakano Yasuane ipu waseremakosapoko asiane, waseremakosa maiyane haruhoanafonosekeno e waseremasafapo. ");
INSERT INTO faa_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Arirakano aporo hinamo yakaimo Yasumo someane kakimaka someraka, “Yasumo wakapu rakirane namo kakaro kara kotesapo. Yasumo makata rakisiane aporo meta fasere aperamo rakikia marokehoasifapo. Asiasamo Yasuane Kotimo unihaeaka rekeasimo murikimasa aporoane, e kereso reapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Arirakano aporo yakaimo someane kaikia koaka purakano Ferese aporomo kaikia, ipu soko, pirisiti aporo káramo soko, Kotimo apea sikiriti aporo asekea risiaki someraka, “Repo Yasu waseremako pusie.” Airakano Yasu rea sikiriti aporo pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Perakano Yasumo someraka, “Maiya wakasema metamo ano reyaki rekeakosapo. Wakasema nina epo ano pusiesamo hauaka yia ano parihiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Hisiakipoko repo ano koane fasekeno aseakosapo. Ano hiakosa hauaka á re soko hiakosane siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Airakano Yu aporo sisima suamo Yasumo someane himeteraka namina susu someraka, “Isiapo eane aseakosafapo, airakane e ma hiakosarakapo. Yu aporohoanafonosamo apea hiakosarakapo. Á hinaka Yu aporo metakira risiaki soko, Yu aporohoanafonosa risiaki soko, somehoko hiakosarakanareapo. ");
INSERT INTO faa_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Epo someraka, ‘Ano koane aseakosafapo. Ano hiakosa hauaka á re hiane siahoasifareapo,’ airakane, some kepo ane mairakarirakapo.” Aíyaka Yu aporo sisima suamo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Hokono akera maiya amo sere kesekeane sere kárapo. Sereamo Yasu takahikia sakepamo someraka, “He narirakano ano rea he nako peae. Kakimara aporo reo, re ano rea pekea he nesie. ");
INSERT INTO faa_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Arirakano Kotimo sawia popasane oyapo. He kafa fuafuana ayiáka anoaki himu hakásaraka hemakapura aporo ane himua yaiya rera heane komarukua sakopeperaka rekeakosapo.” Aíyaka popasane Yasumo takumeaka somesapo. ");
INSERT INTO faa_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Asiamo Yasumo somesamo kepoane oyapo. Aporomo Yasuaki himu hakásaraka hemakapukua risikino Ho Kotesa i himua komarukua muriakosapo. Arirakano Yasumo somesa maiya amo Kotimo faesa hauaka yapura Yasu hiasiraka reke, Ho Kotesa hauaka wo haru pesafapo. ");
INSERT INTO faa_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Yasumo someane aporo yakai sarimasamo kaikia someraka “Aporoane kakaro porofete apororeapo.” ");
INSERT INTO faa_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Airakano aporo metakiramo someraka, “Keresoane epo.” Airakano aporo metakiramo someraka, “Kariri hauaka aeyaka Kereso perafapo. ");
INSERT INTO faa_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Arirakano Kotimo sawia popasane oyapo. Tefetemo aporo iramo Kereso takapeakosapo. ‘Tefetemo ipi ape sumu Petereheme taonea takapeakosapo.’ Aíyaka popahoareapo.” ");
INSERT INTO faa_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Aíyaka somerakano aporo sarimasamo kekepo hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ipu metakiramo, “E tipura makeanie,” aisapo. Aisane kakaro tipura makesafapo. ");
INSERT INTO faa_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Arirakano Kotimo ape asekea risira sikiriti aporomo Yasuane metakarikia pariperakano, pirisiti aporo káramo soko, Ferese aporomo soko, ipu someraka, “Yasu karikia peanafonosane mainakano asiare?” ");
INSERT INTO faa_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Airakano sikiriti aporomo someraka, “Epo somera ayiáka aporo metamo fana somesafapo. Epo somera ayiáka fana somerakano isiapo kaisiafapo.” ");
INSERT INTO faa_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Airakano Ferese aporomo someraka, “Yasumo re mahoperaka epo kotafe somerakano, repo soko kakimarakanare? ");
INSERT INTO faa_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Isiapo isina suamo Yu aporo sisimamo soko, Ferese aporomo soko suamo epo somerakasane kakipayarakanapo. Isiapo hakása metamo soko kakimarakanafapo. ");
INSERT INTO faa_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Aporo hinamo yakai sarimasamo Mosesemo somemaneane koteaka hemakapurakarifapo. Hemakapunafonorakano iane fanasina hauaka pukusapo.” ");
INSERT INTO faa_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Airakano Ferese aporo namina yia Nikitímase ipi fana Yasuaki somesa epo Ferese aporo suaki someraka, ");
INSERT INTO faa_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Isiapo somemane motosakipoko, somemane ane aporomo koaretaeraka watikiaka rakisiaporakano ipiaki fana kairapo. Kaikia kakaro yasikino asekea, fanasinane marerapo. Aporoaki kaiyasiraka, fanasinane marerafapo.” ");
INSERT INTO faa_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Airakano ipu someraka, “Né soko Kariri aporore? Kotimo sawi koteaka menohoanie. Porofete aporoane Kariri hauaka aeyaka perafapo. E porofete apororakanafareapo.” Aíyaka ipu hemakapukua somesapo. ");
INSERT INTO faa_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Aíyaka someaka marekea aporo su namina apea pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Aporo namina apea purakano Yasu ipi haku ūri Orofea hisiapo. ");
INSERT INTO faa_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Mituru fiarakano Kotimo apea Yasu paripukua, aporo yakai e rea sarimarakano e kake some kasapo. ");
INSERT INTO faa_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Some karaka reakipoko, hinamo aporo asea aporo metayaki mokome purakano aporo metakiramo asekea, hinamoane karikia pekea, Kotimo somemane tisa aporomo soko, Ferese aporomo soko e karikia Yasu rea pesapo. Pekea aporo su sarimaraka risiakipoko aporo suamo asekeasimo hinamoaki someraka, “Aporo su hikumisia né á reae,” aíyaka hukurusuapo. ");
INSERT INTO faa_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Hukurukua ipu Yasuaki someraka, “Tisao, hinamoane aporo metayaki mokome purakano aporo metakiramo asesapo. ");
INSERT INTO faa_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Fana Mosesemo somemane motosane oyapo. Hinamo aporo metayaki mokome purakanone, hinamoane ekemo kareasimo makasuhoanie. Aíyaka Mosesemo somemane motosapo. Somemane motosasamo nómo mayiáka hemakapurakanare?” Aíyaka ipu Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Aíyaka somehoane Yasumo hasaka somerakarihoamo, ipu Yasu kau aseako aíyaka mahoperaka eane hukurukusakipoko somesapo. Aíyaka somerakano Yasu arupekea titiwaruraka kake, hokonomo hauaka poparaka kayapo. ");
INSERT INTO faa_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kakeno ipu namina efera hunia kaikia, efera hunia kaikia airakano Yasu arupekea kaina takahikia someraka, “Repo aporo hakása metamo makata watikiaka rakianafononamo, ekeane maka nómo ní fana kareanie.” ");
INSERT INTO faa_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aíyaka Yasu efera hunia arupekea titiwaruraka kake hauaka poparaka kayapo. ");
INSERT INTO faa_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Poparaka kayakipoko aporo sisima fana pusuakipoko, aporo hakása hakásaraka pukua fasekeno, hinamoane hákasa yia rekeno Yasumo asesapo. ");
INSERT INTO faa_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yasu arupekea kaina takahikia hinamoaki someraka, “Hinamo neo, aporo su masiare? Aporo hakása metamo né hukuruko yia rekenare?” ");
INSERT INTO faa_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Airakano hinamoamo someraka, “Wae, su pukua fahoareapo.” Airakano Yasumo someraka, “Nōmo soko ne hukurukusafapo. Né pusie. Puraka keseke efera hunia watikiaka rakiraka kakakopo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aporo hinamo sarimarakano Yasumo efera hunia someraka, “Hauaka wo aporo hinamo risiamo faesamo kepoane anopo. Aporo hinamomo ano patera asekea risiane i katosa pukusafapo. Yaiya rera faesa pukusapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Airakano Ferese aporomo someraka, “Nómo ní airaka yiamo nómo ní yine somerakaripo. Nómo ní airaka yiamo isuaki somehoane siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Airakano Yasumo someraka, “Nōmo nī somerakane kakaro somerakaripo. Ano pesa hauakane soko ano hiakosa hauakane soko nōmo nī hákasa hemakapurakanapo. Asiane repo hemakapuraka, ‘E pesane mayiáka pesarakapo. E hiakosane mayiáka hiakosarakapo.’ Aíyaka repo himeteraka hemaka apure. ");
INSERT INTO faa_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Aporomo ipi hemakapusua hukuarura ayiáka repo hukururakanapo. Asiane Yumo nōmo reane hukururakanafapo. ");
INSERT INTO faa_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Arirakano nōmo hukururakanone koteaka hukurukua maroponapo. Hukurukua maroponane nōmo nī hemakapusua aeyaka hukurukua maroponafapo. Atamo ano pusiesa amo hemakapusuane nōmo kekemaraka hukurukua maroponapo. ");
INSERT INTO faa_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Arirakano repo somemane sawia poparaka, ‘Wikinisi aporo tetámo makata asesa hakása yineraka somerakano, kakarorakae airapo.’ Aíyaka popahoareapo. ");
INSERT INTO faa_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Arirakano nōmo nī somerakane soko, nōmo Atamo ano pusiesamo epo anoane somerakane soko, etapo wikinisi tetámo hakása yineraka somerakayiapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Airakano ipu someraka, “Ní Ata mayare?” Airakano Yasumo someraka, “Ano soko nōmo Ata soko repo himeteane. Repo ano hemakapusua satiki, nōmo Atane soko repo hemakapufunureapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Aíyaka Yasumo Kotimo apea some kasápo. Arirakano ape rumua mone kera maua taesa ane makeraka Yasu reke some kasapo. Arirakano ipu Yasuaki saperakano yia e kukusa maiya fasere peanafonosasamo e hukurukua waseremasafapo. ");
INSERT INTO faa_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yasumo efera hunia someraka, “Nōmo reane metakarikia hiakosapo. Ano hisiakipoko repo ano kokoa aseakosafapo. Re watikiaka yaiya rakiraka risina kukua keakosapo. Ano hiakosa hauaka á re hiane siahoasifareapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Airakano Yu aporo sisimamo someraka, “Epo someraka, ‘Ano hiakosa hauaka á re hiane siahoasifareapo,’ airakae. Airakane kepoane yakaparakapo. Ipi yia makukusarakapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Airakano Yasumo someraka, “Re hauaka wo risikinapo. Ano yapunaka pesapo. Re kakaro hauaka aporopo. Hauaka one kakaro nōmo hauakafapo. ");
INSERT INTO faa_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nōmo fana somesane efera hunia somerakanapo. Re watikiaka yaiya rakiraka risina kukua keakosapo. Ano ni yaiya rerapo. Asiamo some one repo kakimakanafonorakanone re yaiya watikiaka rakiraka risina kukua keakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Airakano ipu someraka, “Né epare?” Airakano Yasumo someraka, “Nōmo fana reaki some kasa yine, anopo. ");
INSERT INTO faa_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Repo makata ainane nōmo reaki some kakakosane kára kakenapo. Reaki hukurukusane kára rekenapo. Nōmo Atamo ano pusiesamo ipi kakaro somerapo. Epo someane nōmo kakimaka aporo hinamo suaki somerakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aíyaka ipi Ata Kotiane Yasumo somerakano ipu kairaka himetesapo. ");
INSERT INTO faa_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Himeterakano Yasumo someraka, “Aporomanomo Tákeane anopo. Ano ira matopesa paremarekea máfaraka mapoana maiya amo ano ni yaiya rerapo, aíyaka repo hemakapukusapo. Maiya amo repo someraka, ‘Epo ipi hemakapusuane rakiafareapo. Ipi Atamo somerakano someane somehoareapo.’ Aíyaka repo somehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Arirakano epo ano pusiesamo ano metakarirafapo. E anoyaki rekenapo. E sesehoasimo nōmo rakirakano epo ano metakarirafapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Airakano aporo hinamo yakaimo Yasumo someane kakimaka eaki himu hakásaraka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Arirakano Yasumo someane Yu aporo hinamomo kakimarakano iaki Yasumo someraka, “Nōmo someane kakimaka risikino, re kakaro ano patera asesa aporo hinamoane risikinapo. ");
INSERT INTO faa_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kakaro someane repo kakimarakano kakaro someamo re tonotaehokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Airakano ipu someraka, “Isu tonotaehokosapo, airakane kepoane yakaparakapo. Eparahamemo aporo ira wainepe pesane isupo. Aporo metakiramo isu roporakano isu tipura arakira ayiáka isiapo aporo metakirapoko raiparaka rakisiafapo. Isu raiparaka rakisimo aporo metamo ropohoanafonosasamo epo isu tonotaehokosapo, aisane mayiáka tonotaehokosare?” ");
INSERT INTO faa_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Airakano Yasumo someraka, “Nōmo kakaro somerakaripo. Aporomo watikiaka rakira amo wafayane makata watikisa ayapo. Makata watikisa amo someraka, ayiakanie, airakano aporomo kakimaka raiparaka rakirapo. ");
INSERT INTO faa_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Arirakano atamo ipi hokosane metakarirafapo. Aporo metaki hokosane roponafapo. Asiane aporo raipa roposa wafayamo ipi hemakapuraka aporo raipane metakarikia aporo metaki roponapo. ");
INSERT INTO faa_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Arirakano makata watikisamo reane tipura kesaka risiane, Kotimo hokosamo re tonotaerakano, re kakaro tonotaesa risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Re Eparahamemo aporo ira wainepe pesane nōmo hemakapurakaripo. Eparahamemo aporo ira wainepe pesa yiamo ano rusua kukuko hemaka apure. Nōmo someane repo kakimakanafonosasamo ano rusua kukuko hemaka apure. ");
INSERT INTO faa_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Asiamo nōmo Atamo anoaki makata tarisiane nōmo nī reaki somerakanapo. Someane repo kakipayarakano, repo namina atamo somesane kakimarakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Airakano ipu someraka, “Isiapo atamo wainepe pesa Eparahamepo.” Airakano Yasumo someraka, “Re Eparahamemo hokosa wainesa satiki Eparahamemo rakisia ayiáka repo rakiafunureapo. ");
INSERT INTO faa_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Rakiafunusa nine repo ano rusua kukuko hemaka apure. Kotimo kakaro someane nōmo kaikia reaki some kasapo. Some karakano repo ano rukusakipoko hemaka apure. Ayiáka Eparahamemo hemakapusuafapo. ");
INSERT INTO faa_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Asiamo repo namina atamo hemakapusuane repo arakire.” Airakano ipu someraka, “Ikia oto hokosane isufapo. Isiapo Ata hákasa Koti ipipo.” ");
INSERT INTO faa_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Airakano Yasumo someraka, “Repo Koti Ata hemakapusua satiki repo himu tumurumo ano hemakapufunureapo. Koti rea hauaka aeyaka ano pesapo. Ano nī hemakapusua aeyaka ano pesafapo. Kotimo ano pusierakano pesapo. ");
INSERT INTO faa_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nōmo someane kaikia hemakapunafononane marirakanonare? Nōmo someane repo kakimako hisiraka risiasamo, nōmo someane repo kaikia hemakapurakarifapo. ");
INSERT INTO faa_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Repo atane Satanepo. Repo atamo hemakapusuane repo seseaka kekemaraka rakirakanapo. Aporo rusua kukusimo kepomaresane epo kepomaresapo. Arirakano kakaro somerane epo rukupateraka metakarisiasamo epo kotafe somerane hákasa hemakapurapo. Kakaro someane hakása soko Satane ipia kakenafapo. Kotafe someane susu e himua komarukua rekenapo. E himu aeyaka kotafe someane susu some karaka rerapo. Kotafe someamo kepoane Satanepo. ");
INSERT INTO faa_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nōmo nī someane kakaro susu somerapo. Kakaro susu somerakano repo kakimarakarifapo. ");
INSERT INTO faa_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nōmo watikiaka hemakapukua rakirano repo asesare? Wae. Repo asesafapo. Nōmo kakaro somerakano yia marirakano repo kakipayaraka risikinare? ");
INSERT INTO faa_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Kotimo someane ipi hokosamo kairapo. Re Kotimo hokosahoanafonosasamo Kotimo someane repo kaiyako hisiane,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Airakano Yu aporo sisimamo someraka, “Né Sameria aporopo. Yatafumo né ho masapo. Isiapo kakaro somerakaripo.” ");
INSERT INTO faa_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Airakano Yasumo someraka, “Yatafumo ano ho masafapo. Aíyaka repo somerakane repo kakaro somerakarifapo. Nōmo Atane nōmo makama fanaraka makárarakanapo. Arirakano repo ano makama kesekeraka mawakasemarakanapo. ");
INSERT INTO faa_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Arirakano nōmo ni yia yano motosa makáraraka somehoko hemakapurakarifapo. Kotimo ano yano motosane makárahokosapo. Ano makárahokosane Kotimo makárahokosapo. Epo aporo hinamo suane takekea parakuhokosapo. ");
INSERT INTO faa_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Arirakano nōmo reaki kakaro somerakanapo. Nōmo someane aporo hinamomo kakimarakano ane, i kakaro kukusafapo. Iane yaiya risikiakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Airakano Yu aporo sisimamo someraka, “Yatafumo né hoane kakaro mayereapo. Asiamo né masuaraka himu mahimeteraka somerakae. Eparahame kusuapo. Porofete aporo soko kusuapo. Asiāne nómo someraka, ‘Nōmo someane kakimara aporo hinamoane kukusafapo. Yaiya risikiakosapo.’ ");
INSERT INTO faa_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Aisa nine Eparahame kusuane nómo hurutapirakanare? Né aporo unihae kárare? Porofete aporo soko kusuapo. Né epapaka hemakapurakanare?” ");
INSERT INTO faa_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Airakano Yasumo someraka, “Ano nī yia makáraraka somesa satiki nenakamaka rupiaka somehoafunureapo. Asiane nōmo Atamo ano makáraraka marerakanapo. Nōmo Ataki repo Kotipo airapo. Nōmo Atane repo Koti hakása yiyapo. Koti hakása yiamo ano makárarakanapo. ");
INSERT INTO faa_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Eane repo kakaro koteaka hemakapusuafapo. Eane nōmo kakaro hemakapurakanapo. Asiamo nōmo e asekeanafonoraka nōmo somesa satiki nōmo kotafe somehoafunupo. Repo kotafe somera ayiáka nōmo somerafapo. Nōmo eane hemakapuraka epo someane nōmo kakaro kaikia kekemarapo. ");
INSERT INTO faa_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Arirakano ano hauaka wo peakosane repo makasa kaua kekema Eparahamemo hemakapusuapo. Ano peakosane hemakapukua seseraka reapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Airakano Yu aporo sisimamo Yasuaki someraka, “Eparahameane nómo asesare? Né keremisi fifiti (50) ayiáka né reafapo. Né sisimafapo. Nómo mayiáka Eparahame asesare?” ");
INSERT INTO faa_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Airakano Yasumo someraka, “Nōmo kakaro somerakaripo. Eparahame hokono mareasiraka ano yaiya reapo.” ");
INSERT INTO faa_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Airakano Yu aporo sisimamo Yasuane kareakosakipoko eke morakano asekea Yasu fararererape pukua Kotimo apeane metakarikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yasu ikia kara puraka aseane aporo meta hi mesa rekeno asesapo. Aporoane ipi kaīyiamo takapesa maiya amo hi mesapo. ");
INSERT INTO faa_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Aporo hi mesane asekea aporo hakāsa puramo Yasuaki someraka, “Tisao, aporo hi mesane epamo watikiaka rakisiakipoko e fanasiraka hi mesare? Epo ipi watikiaka rakisiakipoko e fanasisare? Ipi kaīyiape wafaya tetapō watikiaka rakisiakipoko e fanasisare? Epamo watikiaka rakisiakipoko e fanasisare?” ");
INSERT INTO faa_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Airakano Yasumo someraka, “Epo ipi watikiaka rakisiakipoko e fanasiraka hi mesafapo. Ipi wafayape kaīyia tetapō watikiaka rakisiakipoko e fanasiraka hi mesafapo. Kotimo wakapuamo e hi mafarakano aporo suamo asekeasimo e takapesa maiya amo hi mesapo. ");
INSERT INTO faa_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Arirakano erehoasirakayia maiya faena yiamo nōmo makata rakirakanapo. Kotimo ano pusiesasamo epo makata rakirane isiapo rakiane siahoasireapo. Ereamo nōmo soko repo soko makata rakiakosafapo. Erehoko makerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ano hauaka wo areamo aporo hinamo hauaka wo risiamo faenane anopo.” ");
INSERT INTO faa_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Aíyaka Yasumo someaka ororoa torofaeraka, hokonomo sosokeraka maka, aporo hi mesane hia paisiapo. ");
INSERT INTO faa_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ororomo paikia marekea Yasumo eaki someraka, “Ne pukua he Siroame kafa á ne hikumisiane kusuhoko pusie.” Airakano he Siroameane namo meaka he rakemása aíyaka yano motosapo. He kafa á aporoane pukua, hikumisi kusuhoane himo koteaka asesapo. ");
INSERT INTO faa_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aserakano aporo ipi tákemo soko, fana mone kakasimo kakeno asesa aporoamo soko someraka, “Aporo fana mone kakasimo kakesuane ere?” ");
INSERT INTO faa_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Airakano aporo metakiramo someraka, “Ao, aporo ayapo.” Airakano aporo metakiramo someraka, “Érakanafareapo. Aporo meta e hikumisi yaisia rekenapo. Aporo ayarakanareapo.” Airakano aporo hi mesa fasamo someraka, “Ao, mone kakasimo kakesuane anopo.” ");
INSERT INTO faa_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Airakano ipu someraka, “Mayiáka né hi fasare?” ");
INSERT INTO faa_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Airakano epo someraka, “Aporo meta ipi yano motosa Yasumo ororoa torofaeraka, ano hia paikia someraka, ‘Né pukua he Siroame kafa kusuhoko pusie.’ Airakano ano pukua he kafa kusuhoane koteaka asesapo.” ");
INSERT INTO faa_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Airakano ipu someraka, “Yasu ma rekenare?” Airakano aporoamo someraka, “Ano himeteripo. E ma pusuarakapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Arirakano fenena maiya amo aporo hi mesane Yasumo mafasapo. Mafarakano ipu e karikia Ferese aporo risia á karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ferese aporo risia á karikia perakano, Ferese aporomo aporo hi mesa mafasaki someraka, “Né hi mesane mayiáka fasare?” Airakano epo someraka, “Aporo metamo ororo maka ano hia paisiane hemo kusuhoane fasapo. Faraka koteaka aserakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Airakano Ferese aporo metakiramo someraka, “Fenena maiya amo epo makata rakiasiasamo e Kotimo pusierakano pesa aporo ayafareapo.” Airakano aporo metakiramo someraka, “Epo wakapuaka rakirane nena aporo watikiaka rea aporomo ayiáka wakapuaka rakirafapo.” Aíyaka namina himumo kekepo hemakapukua tafatafasapo. ");
INSERT INTO faa_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tafatafaraka aporo hi mesa mafasaki Ferese aporomo efera hunia someraka, “Né hi mafasa aporoane nómo epapaka hemakapurakanare?” Airakano aporo hi mesa mafasamo someraka, “E porofete apororeapo.” ");
INSERT INTO faa_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Airakano Yu aporo sisimamo someraka, “Aporoane ipi kaīyiamo takapesa maiya amo e hi mesarakapo. Kakaro hi mesa mafasarakapo.” Aíyaka hemakapuraka ipi kaīyiape wafaya tetā peaesapo. ");
INSERT INTO faa_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Peaerakano pesapo. Perakano Yu aporo sisima amo someraka, “Aporoane tetápo titi hokosare? Hi mesa takapesare? Yumo koteaka aserane mayiáka koteaka aserakanare?” ");
INSERT INTO faa_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Airakano ipi kaīyiape wafaya tetapō someraka, “Eane etapo hokosapo. Takapesa maiya amo e hi mesapo. ");
INSERT INTO faa_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yumo koteaka aserane mayiáka aserakanarakapo. E hi mafasane aporo eparakapo. Eaki kaiyinie. E ipi aporo rauasasamo ipi yiamo hemakapurakanarakayiapo. Epo somehoane siahoasireapo.” Aíyaka tetapō somesapo. ");
INSERT INTO faa_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tetapō Yu aporo sisima ane namoraka risiasamo aíyaka somesapo. Tetapō somehoasiraka fana Yu aporo sisimamo someraka, “Aporo metamo someraka, ‘Yasu ipi Keresopo,’ airakanone aporoaki Yu aporomo sarimana apea peakopo, aihokosapo.” Aíyaka Yu aporo sisimamo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Aíyaka somesasamo ipi kaīyiape wafaya tetapō hemakapuraka, “Etoaki peakopo, aihoasireapo.” Aíyaka hemakapuraka tetapō someraka, “Aporo hi mesa mafasane aporo rauasasamo e ipiaki kaiyinie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Arirakano efera hunia Yu aporo sisimamo aporo hi mesa mafasaki peaesapo. Peaerakano pesapo. Perakano ipu someraka, “Kotimo kaiyisimo nómo kakaro aumaraka somehoanie. Koti makama fanahoanie. Yasumo himu watikiaka reane isiapo hemakapurakaripo.” ");
INSERT INTO faa_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Airakano aporoamo someraka, “E himuane nōmo aserafapo. E himuane kotesarakapo. E himuane watikisarakapo. Ane nōmo hemakapurakanafapo. Asiāne nōmo makata hakása hemakapusuane oyapo. Ano fana hi mesa reane, yumo nōmo koteaka aserakanapo. Ane nōmo hemakapurakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Airakano ipu someraka, “Epo mayiáka né hi mafasare?” ");
INSERT INTO faa_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Airakano epo someraka, “Nōmo reaki pipu somerakasafare? Somerakasane repo kakimarakarifapo. Marirakano efera hunia anoaki kairakanare? Repo eane patera asekea risikiakosakipoko somerakanare?” ");
INSERT INTO faa_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Airakano ipu saperaka eaki mainamarekea someraka “Aporoane patera asesa aporoane nepo. Isu Mosese patera aserakanapo. ");
INSERT INTO faa_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kotimo Moseseaki somesapo, aíyaka isiapo hemakapurakaripo. Aporo ane maeyaka pesarakapo, aíyaka isiapo hemakapurakaripo.” ");
INSERT INTO faa_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Airakano aporo hi mesa mafasamo someraka, “Repo mairakare? Re yaiya himeterire? Repo someraka, ‘Aporoane maeyaka pesarakapo,’ aíyaka repo somerakasa, aporoamo ano hi mafasapo. ");
INSERT INTO faa_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Aporo himu watikiaka hemakapukua reamo Kotiaki wárakano Kotimo kairafapo. Kotiaki kekereraka Kotimo hemakapusua rakirane rakiraka reamo wárakano, Kotimo kairapo. Ane isiapo hemakapurakanapo. ");
INSERT INTO faa_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Wate fana hauaka kara one kepomaresa maiya amo soko, aporo wainepe pesa makasa kamuma risia maiya amo soko, makasa kaua risia maiya amo soko, ata rea maiya amo soko, aporo ipi kaīyiamo taka apera maiyamo hi mesa takapesane aporo metamo mafasapakano isiapo kairafapo. Fana ayiáka mafasafapo. ");
INSERT INTO faa_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kotimo makata rakirane rakiako pusiehoanafonosa satiki, aporoamo ayiáka mafahoafunufapo.” ");
INSERT INTO faa_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Airakano ipu someraka, “Ní atane soko ní amane soko himu watikiaka reke, né soko himu watikiaka takapesapo. Né kotesapaka isuaki some karakánare? Isiapo nómo someane kaiyakosafapo. Yu aporomo sarimana ape one metakarikia pusie.” Airakano e pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Pusuakipoko aporo hi mesa mafasaki hukurukua pusiesane Yasumo kaikia, aporoane kokoa aseraka someraka, “Aporomanomo Tákeaki nómo himu hakásaraka hemakapurakanare?” ");
INSERT INTO faa_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Airakano aporoamo someraka, “Ape neo, eaki himu hakásaraka hemakapuko anoaki tarikia somesie. Eane epare?” ");
INSERT INTO faa_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Airakano Yasumo someraka, “Nómo yumo aserakasane anopo. Nōmo néaki somerakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Airakano aporoamo someraka, “Unihaeo, nōmo neaki himu hakásaraka hemakapurakanapo.” Aíyaka epo kekereaka somerakano ");
INSERT INTO faa_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yasumo someraka, “Aporo hinamo Kotiaki himu hakásaraka risiane soko, aporo hinamo Kotiaki himu hakásaraka risikianafonosane soko, parakuhoko ano hauaka wo pesapo. Aporo metamo someraka, ‘Nōmo makata su aserafapo,’ aisa aporoane hi faeraka rekeakosapo. Arirakano aporo metakiramo someraka, ‘Ano siapo. Nōmo himo makata su aserapo,’ aisa aporoane hi katoraka rekeakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Airakano Ferese aporo makeraka risiamo kaikia someraka, “Isu hi mesa risikino nómo asekea somerakanare?” ");
INSERT INTO faa_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Airakano Yasumo someraka, “Repo someraka, ‘Isu hi mesa risikinapo,’ aíyaka hufitaesa satiki, re himu watikisane nōmo mafahoafunureapo. Asiāne repo hufitaerakarifapo. Repo someraka, ‘Isiapo makata su hemakapukua, arirakano makata su asekea siaraka risikinapo.’ Aíyaka somerakane re himu watikisane yaiya risikinapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yasumo aporo hinamoaki efera hunia someraka, “Nōmo reaki kakaro somerakaripo. Saro sipi rurusa aporo ikia koro aeyaka peanafonoraka, ruru tipi aeyaka tapikia perakano aporoamo saro sipiane mokoatikiraka hakimako perapo. ");
INSERT INTO faa_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Aporo ipi ikia koro aeyaka perakano saro sipi asekea rera aporo ayapo. ");
INSERT INTO faa_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Saro sipi asekea rera aporoane ruru kakarua peasimo, ikia koro asekea rea aporomo ikia koroane ropakamarapo. Ropakamarakano saro sipi asekea rera aporomo saro sipi yano taesane yano hokoa wáhoane, saro sipi su perakano namina asekea rera aporomo karikia yaoa purapo. ");
INSERT INTO faa_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Asekea rera aporo fanaraka purakano, epo meane ipu kaikia kekemarape purapo. ");
INSERT INTO faa_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Saro sipi asekea rekeanafononane, ipu kekemarape purafapo. Me kaiyiáne me meta kairakarakano teketarirapo.” ");
INSERT INTO faa_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Aíyaka Yasumo takumeaka somerakano, ipu some kepoane himetesapo. ");
INSERT INTO faa_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Aihoane i himeterakano efera hunia Yasumo someraka, “Nōmo reaki kakaro somerakaripo. Saro sipi keasimo rurusa ikia koro asiane anopo. ");
INSERT INTO faa_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Fana aporo pesane hakimora aporopo. Ipu kotafe wárakano, ipu meane saro sipimo kaiyiáne, kumuku kairakarakano, kekemarape pusuafapo. ");
INSERT INTO faa_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ikia koro asiane anopo. Saro sipi ikia koroa yorokoa pesa susuane nōmo asekea rekenapo. I ikia koroa yorokoa pesa susuane makata metamo mokoatikinapaka nōmo mafairaka asekea rekenapo. Ikia koro aeyaka pekea yaoa asane kotesa nako purapo. Aina ayiáka anoaki paosa aporo hinamoane nōmo asekea reke mafasiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Asiamo hakimara aporomo makata hakimokoa rukua mokoatikiraka ayiakako perapo. Arirakano aporo hinamo Kotiyaki koteaka risikiasimo ano pesapo. Yumo i su hauaka wo arisiamo Kotimo iane makoterakano hemakapukua, makata su siaraka risike, seseraka ayiáka koteaka risikiasimo ano pesapo. ");
INSERT INTO faa_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Saro sipi asekea rera aporo kotesane anopo. ‘Saro sipi koteaka risikiasimo asekea rera aporoane kuane siahoasireapo,’ aíyaka saro sipi asekea rera aporo kotesamo hemakapurapo. ");
INSERT INTO faa_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Arirakano aporo metamo saro sipi asekea reke mone makosakipoko raiparaka rakirapo. Aporoamo saro sipiane kakaro epo ipi menahoanafonosasamo epo aseane, saro wofe perakano asekea saro sipiane metakarikia takaripurapo. Takaripurakano saro wofemo saro sipi metakirane rukunenakano, metakirane yaoa teketarikia rosaka tarirapo. ");
INSERT INTO faa_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Asiamo aporomo mone hákasa hemakapukua raiparaka rakiraka saro sipiane ipimenahoanafonosasamo koteaka hemakapukua asekea rerafapo. ");
INSERT INTO faa_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Arirakano saro sipi asekea rera aporo kotesane anopo. Nōmo Atamo anoaki hemakapukua, nōmo Ataki hemakapukua area ayiáka, nōmo saro sipiane hemakapukua, saro sipimo anoaki hemakapukua ayiáka risirapo. Nōmo saro sipipoko ano kuane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Arirakano saro sipi metakira ruru wo keanafonosane soko nōmenapo. Iane soko nōmo karikia peakosapo. Saro sipi nena yaoa risiamo soko, nōmo someane kakimarakano, karikia peakosapo. Yaoa risiane soko, ruru kakarua risiane soko, rurua hakāsa kekea su sarimaraka risikiakosapo. Asiamo asekea rera aporoane ano hákasapo. ");
INSERT INTO faa_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ano turikia pukusakipoko kukusapo. Ayiakakosasamo Atamo anoane himu tumurumo hemakapurakanapo. ");
INSERT INTO faa_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Aporomo hemakapusua aeyaka ano rusua kukusafapo. Nōmo aohoanafonorakanone ane ano rusua kukusifareapo. Nōmo nī hemakapusuane aosasamo ano rusua kukusireapo. Aporomo ano rusua kukusimo nōmo nī hemakapusua aeyaka ano kauane kakakosapo. Ano kukua efera hunia turikia apuramo wakapuaka turikia pukusapo. Aíyaka nōmo Atamo hemakapukua maresapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aíyaka Yasumo somerakano Yu aporo sisimamo kaikia himumo kekepo hemakapukua tafatafasapo. ");
INSERT INTO faa_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tafatafaraka aporo metakiramo someraka, “Yatafumo e ho masasamo epo airakae. E masuarakanareapo. Marirakano epo someane repo kairakanare?” ");
INSERT INTO faa_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Airakano aporo metakiramo someraka, “Yatafumo aporomano ho masamo aíyaka somerafapo. Aporo hi mesane yatafumo mafanafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wate fana Kotimo Ape Kikimasane Kotiaki Suseraka Hemakapuko Hokono Keakosa maiya ane makesapo. Hokono keakosakipoko yaki ikia aperamo Yu aporo Hinamo Yarusarame sitia sarimasapo. ");
INSERT INTO faa_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kotimo apea Yasu pukua ape taru yano motosa Soromone ape tarua koraka reakipoko ");
INSERT INTO faa_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yu aporo sisima sarimaraka ipu Yasuaki someraka, “Isiapo neane aseraka himu tetáraka risikinapo. Masinaka isuaki kakama somehokosare? Ne Keresopo airakane nómo isuaki kakama hufitaeraka somehoanie.” ");
INSERT INTO faa_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Airakano Yasumo someraka, “Fana nōmo reaki somerakasuamo repo kakimarakasufapo. Atamo yanoane máfaraka ipi wakapumo hemakapukua rakira amo anoane reaki tarirakanapo. Tarirakano yia repo koteaka hemakapurakarifapo. ");
INSERT INTO faa_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Asiane reane nōmo saro sipirakanafareapo. Repo nōmo someane kakimarakarifapo. ");
INSERT INTO faa_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","28","Arirakano nōmo someane nōmo saro sipimo kakimaka kekemarape perakano, nōmo iane hemakapuraka kakaro yaiya risirane karápo. Karakano i hasaka koakosafapo. Iane aporo metamo wasekemaka hakimakosafapo. Saro sipiane nōmo Atamo anoaki kasapo. ");
INSERT INTO faa_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ata ipi kakaro kárapo. Aporo metamo e hurutapirafapo. Saro sipiane ipi asekea rekenapo. Ipi asekea rerasamo aporo metamo hakimakosafapo. ");
INSERT INTO faa_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ata eto iti hakása yiyapo.” ");
INSERT INTO faa_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Airakano kaikia Yu aporo sisimamo ekemo kareako mosapo. ");
INSERT INTO faa_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Morakano Yasumo someraka, “Repo asekeasimo Atamo anoaki rakiniesane makata kára nōmo rakisiapo. Nōmo makata yakapa hasaka rakirakano repo ekemo ano kareakonare?” ");
INSERT INTO faa_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Airakano Yu aporo sisimamo someraka, “Nómo koteaka rakirakano isiapo ne ekemo kareafunufapo. Asiāne nómo someraka, ‘Koti eto iti hakása yiyapo,’ airakasa akipoko ne ekemo kareakosapo. Nómo someraka, ‘Ano Kotipo,’ airakae. Asiāne né kakaro aporomanopo.” ");
INSERT INTO faa_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","35","Airakano Yasumo someraka, “Kotimo sawia popasane kakaro yasiane popahoareapo. Popasa ane metakariakopo. Fana popasane oyapo. Kotimo ipi some kaira aporoaki someraka, ‘Kotio,’ aisane popasapo. ");
INSERT INTO faa_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Kotimo aisa yiamo ano murikimaka pusierakano ano hauaka wo pesapo. Pekea someraka, ‘Ano Kotimo hokosapo.’ Airakano repo someraka, ‘Epo Kotiane mawakasemarakae.’ Aíyaka repo somerakane mairakare? ");
INSERT INTO faa_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Atamo makata rakirane nōmo rakianafonosa tiki nōmo someane repo kakipayahoane siahoasireapo. ");
INSERT INTO faa_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Atamo makata wakapuaka rakirane nōmo rakirakano, makata rakirane asekea repo himu hakásaraka hemakapunie. Anoaki himu hakásaraka hemakapunafonoraka, nōmo rakirane asekea himu hakásaraka hemakapunie. Ano Atayaki hakāsa reke, arirakano Atane anoyaki hakāsa reke, ayiáka rekeno repo asekea hemakapukusapo.” ");
INSERT INTO faa_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Airakano ipu e tipura makeako wasere makorakano Yasu ipi rea nine fasekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Arirakano Yasu pukua, he Yotane yaoraka taku ra pukua, Yonemo aporo hea tapukumurisia hauaka á pukua reapo. ");
INSERT INTO faa_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Rekeno aporo hinamo yakai peraka namina susu someraka, “Isiapo asekeasimo Kotimo wakapumo hemakapukua rakirane Yonemo rakisiafapo. Asiāne Yasumo ainane Yonemo somesane namo kakarohoareapo.” ");
INSERT INTO faa_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Aíyaka aporo hinamo yakaimo Yasumo someane kakimasapo. ");
INSERT INTO faa_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Aporo hakása meta ipi yano motosa Rásarase, Petene apea reapo. Ape hakása yia Maria soko ipi yapaya Mata soko tetā toapo. Rásarase ipi makata takamasa wareapo. ");
INSERT INTO faa_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Arirakano fana Mariamo makata wape yamonane Yasumo korakea rekemarekea, ipi uni itimo hokesapo. Hinamoamo ipi ifia Rásaraseane makata takamasapo. ");
INSERT INTO faa_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Takamarakano Mariape Mata tetapō aporo metaki someaka mareraka, “Nómo Unihae Yasuaki somehoko pusie. Nómo úyaka somehoanie. Unihaeo, nómo ní aporo táke Rásaraseane makata takamasa warekenapo, aihoanie.” Airakano aporoane pukua tetapō someaka maresane Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Somerakano Yasumo kaikia someraka, “E kukusapoko makata takamasafapo. Aporo hinamomo Kotiaki hemakapukua kekerehoasimo makata takamasapo. Aporomanomo Tákeane anopo. Anoaki soko hemakapukua kekerehoasimo e makata takamasapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Arirakano Yasumo Mata soko, ipi yapaya maria soko Rásarase soko, i suaki himu tumurumo hemakapuraka, ");
INSERT INTO faa_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Rásarase makata takamasapakano yia, Yasu ipi rea hauaka á yape tetá wasápo. Epo aseako pusuafapo. ");
INSERT INTO faa_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Yape tetá waka yape isiamo Yasumo someraka, “Yutía hauaka á isu paripukusapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Airakano ipi aporo hakása puramo someraka, “Tisao, kawe né kukusimo Yutía hauaka á Yu aporo sisimamo ekemo kareakorakasu yia, né efera hunia kareasimo paripurakanare?” ");
INSERT INTO faa_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Airakano Yasu ipi kukusa maiyane haru faserepeanafonorakano ipu hemakapusimo Yasumo someraka, “Sere hakása tuaro (12) awa faenapo. Maíyamo faesakipoko himo asekea puraka terafaka ruraka etenafapo. ");
INSERT INTO faa_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ereamo puraka katosakipoko terafaka ruraka etenapo. ");
INSERT INTO faa_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Isiapo aporo táke Rásaraseane ipi wasápo. Wasáne nōmo maturikia taehoko pukusapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Aíyaka takumeaka somerakano, ipi aporo hakása puramo himeteaka risike someraka, “Unihaeo, e makata takamasa warekerakane fahokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Aíyaka Rásarase nena makata takamasa warekenapakasiki hemakapukua, Rásarase ipi kakaro kusuane Yasumo takumeaka somerakano, ipu himetesapo. ");
INSERT INTO faa_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Himeteraka risikino aseraka Yasumo hufitaeraka someraka, “Rásarase kusuapo. ");
INSERT INTO faa_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","E makata takamaka warea ano pusuafapo. E kusua kunikia motosapakano aseako pukusapo. Sereamo nōmo makata rakirakano, repo anoaki himu hakásaraka hemakapukusapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Airakano Tomase ipi yano motosa meta Titimase, epo aporo hakása pura metakiraki someraka, “Eyaki isu su pukusapo. Eyaki isu kukuko pukusapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","19","Yasu ipi aporo hakāsa purayaki Petene apea perakano aporo metakiramo someraka, “Rásarase kusua kunikia motosane pipu kitafapo,” aisapo. Airakano kaikia aseane Petene apea Matape Maria tetapō ipi ifia Rásarasepoko himu nekea torapaka mapirahoasimo, Yu aporo hinamo yakaimo ararehoko pekea risikino asesapo. Petene apeane Yarusarame siti aeyaka makesakipoko aporo soko, hinamo soko, yakai pesapo. ");
INSERT INTO faa_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Arirakano Yasu apererakano Matamo e sapenako puraka, Maria ape yia kakeno, Mata pukua Yasuaki someraka, ");
INSERT INTO faa_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","“Unihaeo, né wo reasatiki nōmo papāne kukufunufapo. Asiamo e kusuapo. ");
INSERT INTO faa_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Asiane yumo nómo Kotiaki wáraka ayiakanierakano epo ayiáka rakiakosapo, aíyaka nōmo hemakapurakaripo.” ");
INSERT INTO faa_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Airakano Yasumo someraka, “Ní papā maturikia taehokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Airakano Matamo someraka, “Fa ana maiya amo aporo hinamo su maturikia taerakano e soko maturikia taehokosapo, aíyaka nōmo hemakapurakaripo.” ");
INSERT INTO faa_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Airakano Yasumo someraka, “Yaiya rekeasimo maturikia taena aporoane anopo. Aporomo anoaki himu hakásaraka rekeno, aporoane kuraka tiki kusuaneo, asiāne turikia pukua yaiya rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Anoyaki yaiya reke anoaki himu hakásaraka hemakapukua rea aporoane kakaro kukusafapo. Someane nómo kakimarakanare?” ");
INSERT INTO faa_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Airakano Matamo someraka, “Ao, Unihaeo, nōmo kakimarakanapo. Kotimo hokosa nereapo. Arirakano Kotimo ne unihaeaka rekeasimo murikimasa aporo Keresoane nereapo, aíyaka nōmo hemakapurakaripo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Matamo someaka faraka ipi apea paripuraka aporo hinamo suamo kaiyakohoamo Matamo Mariaki tau someraka, “Tisa pesa rekesapo. Né aseako wárakasapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Airakano Mariamo kaikia foaka takahikia puane ");
INSERT INTO faa_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yasu apea perafaraka, fana Matamo Yasu sapenekea asesa yia Yasu rekeno aseako pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Purakano Yu aporo hinamomo Mariane mapirahoasimo arareraka toamo aseane Maria foaka takahikia purakano asesapo. Asekea hemakapuraka, “Maria kunikia hiripuhoko apure,” aíyaka ipu hemakapukua kekemarape pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Arirakano Yasu rea Maria pekea kakuna porokoa kake someraka, “Unihaeo, né wo reasatiki nōmo papā kukufunufapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Airakano Yasumo aseane Mariamo hiripurakano Yasumo aseane Yu aporo hinamo kekemaraka pesamo soko hiripurakano asekea, Yasumo himu kára nekea someraka, ");
INSERT INTO faa_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Rásarase kusuane kunikia ma motosare?” Airakano ipu someraka, “Unihaeo, aseako peae.” ");
INSERT INTO faa_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Airakano Yasumo hiripusapo. ");
INSERT INTO faa_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Hiripurakano Yu aporo sisima metakiramo asekea someraka, “Epo aporo tákeane kára hemakapuraka hiripuane.” ");
INSERT INTO faa_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Airakano Yu aporo sisima metakiramo someraka, “Aporo hi mesa mafasasamo Rásarase soko kukukohoamo mafahoafunureapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yasu himu kára nekea kunikia pukua aseane kunikia kakarua ekemo mapirisikino asekea ");
INSERT INTO faa_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","someraka, “Ekemo mapirisiane kotomaka kepere mafearasie.” Airakano aporo kusuamo ipi ifia Matamo someraka, “Unihaeo, kunikia motosane pipu kitafapo. Pipu toreraka ikiki yamohokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Airakano Yasumo someraka, “Nōmo néaki fana someraka, ‘Nōmo someane kakimarakano Kotimo wakapu faesa aseakosapo.’ Aíyaka nōmo somesapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Airakano ekemo mapirisiane kotomafearakano asekea Yasumo yapura asekea someraka, “Atao, nōmo néaki wásane nómo kakimarakano néaki suserakanapo. ");
INSERT INTO faa_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Maiya suamo nōmo someane nómo kakimarakano nōmo hemakapurakaripo. Aporo hinamopoko ano pusiesane népo. Aíyaka ipu hemakapusimo nōmo néaki wárakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Aíyaka kurikuriraka faraka sakepamo someraka, “Rásarase né wo peae.” ");
INSERT INTO faa_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Airakano aporo kusuane pekea, pasumo hokono soko korake soko wamo soko taporaka perakano Yasumo someraka, “E pusimo pasuane fisisie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Arirakano Yu aporo sisima metakiramo Maria ararehoko pesamo Yasumo Rásarase kusua maturikia taerakano aseraka, ipu Yasuaki himu hakásaraka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Arirakano Yu aporo sisima metakira Ferese aporo risia pukua, Yasumo rakisiane somesapo. ");
INSERT INTO faa_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Somerakano Ferese aporo soko, pirisiti aporo soko, namina sarimaraka someraka, “Yasuane isiapo mayiakakosare? Epo kakaro wakapuaka rakirakanapo. Isiapo eane matasohoko mayiáka rakiakosare? ");
INSERT INTO faa_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Epo someane rukupatehoanafonorakano, aporo suamo epo someane kakimakosapo. Kakimarakano Rome kamani aporomo Kotimo apeane rakaritaehokosapo. Rakaritaeraka isu Yu aporo hinamo su rusua kukusapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Airakano aporo meta ipi yano motosa Kaiafasepo. Keremisi amo Kaiafase pirisiti aporo fanaraka reapo. Kaiafasemo someraka, “Re himeteraka arisie. ");
INSERT INTO faa_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Aporo hinamo su kukua keane siahoasifareapo. Aporo hinamo supoko aporo hakása kuane siahoasireapo.” ");
INSERT INTO faa_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aíyaka somesane Kaiafasemo ipi hemakapusua anaka somesafapo. Keremisi amo e pirisiti aporo fanaraka reasamo Kotimo makata keseke ayiakakosane tarirakano somesapo. Keseke ayiakakosane Yasu ipi Yu aporo hinamo supoko farimaka kukusane somesapo. ");
INSERT INTO faa_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Yu aporo hinamo hákasapoko kukusane somesafapo. Aporo hinamo metakira soko Kotiaki himu hakásaraka risiane kekepo rosaka tarisia ane sarimahoasimo e kukusapo, aisapo. ");
INSERT INTO faa_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aisa sereamo Ferese aporope pirisiti aporo namina Yasu rusua kukusakipoko hemakapukua ikia kosapo. ");
INSERT INTO faa_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Asiamo Yu aporo hinamo risiakipoko Yasu kakamaraka koraka reafapo. Yao kauane makeraka Eferaime taonea pukua wakareapo. Apea ipi aporo hakása purayaki waka risiapo. ");
INSERT INTO faa_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yu aporomo Ape Farimaresa Hemakapuko Hokono Keakosa maiyane makerakano Yu aporo hinamo yakai namina himu watikisa mafahoasimo namina hauaka metakarikia Yarusarame sitia hisiapo. ");
INSERT INTO faa_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Hikia Kotimo apea yororakano pirisiti aporo káramo soko Ferese aporomo soko someraka, “Repo Yasu aseraka isuaki somehoanie.” Aíyaka ipu Yasu tipura makeako somerakano aporo suamo Yasu aseako kokoa namina susu me rukua someraka, “Hokono akera wo Yasu peanarakapo. Repo metakiramo mayiáka hemakapurakanare?” Aíyaka namina susu me rukua somesapo. ");
INSERT INTO faa_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ape Farimaresa Hemakapuko Hokono Keakosakipoko sere namasu rekeasimo Yasu Petene apea pusuapo. Pukua Rásarase kusuane Yasumo maturikia taesa reamo apea Yasu pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Pukua Rásarasemo apea Yasu perakano, Yasupoko makata nakosa paisiapo. Paikia Rásarasepe Yasu tetā aporo metakirayaki teporo makeraka tokeno, Matamo makata nakosa paikia kasapo. ");
INSERT INTO faa_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Arirakano Mariamo petoroa makata wape yamona yano motosa nate kesane maka pekea, Yasu korakea makata wape yamonane mone káramo roposane rekemarekea, Mariamo ipi uni itimo hokesapo. Hokerakano aporo suamo makata wape yamonane yamosapo. ");
INSERT INTO faa_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yamorakano Yasumo aporo hakása pura hakása meta Yutase Isekerio epo keseke Yasuane parakehokosa aporoamo someraka, ");
INSERT INTO faa_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Mone siufa tiri harotemo (300) makata wape yamona petoroa kesane roporaka aporo makata forosaki kakafokore.” ");
INSERT INTO faa_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Aisane aporo makata forosaki kakaro kakakosapoko hemakapukua somesafapo. Yutaseane ipi hakimora aporo reasamo somesapo. Arirakano aporo hakása pura suamo moneane sarimaraka pausia kekea, Yutasemo asekea reapo. Asekea reke mone metakira epo tau hakimosapo. ");
INSERT INTO faa_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Arirakano Yasumo Yutaseaki someraka, “Hinamoamo ipi rakiako hemakapusuane rakirie. Makata wape yamonane ano kukusa kauane makotehoko rekeamarere. Ano kukusane hemakapukua murikimaka rekeamarere. ");
INSERT INTO faa_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Maiya suamo aporo makata forosane reyaki hakāsa yia risikiakosapo. Arirakano maiya suamo ano reyaki hakāsa rekeakosafapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Yasu Petene apea rekenapakano aporo hinamo yakaimo kairaka aseako pusuapo. Ipu Yasuane soko, Rásarase kusua maturikia taesane soko, aseako pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Purakano pirisiti aporomo someraka, “Rásarase soko rusua kukusapo.” Aíyaka hemakapukua risiapo. ");
INSERT INTO faa_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Rásarase maturikia taesakipoko, Yu aporo sisima yakaimo pirisiti aporomo someane metakarikia, Yasuaki patera aserakano, pirisiti aporomo saperaka Rásaraseane rusua kukusapo, aisapo. ");
INSERT INTO faa_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ere hakása waka Yarusarame sitia hokono keakosakipoko aporo yakai sarimasa amo Yasu apererakano kaikia ");
INSERT INTO faa_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","namina hiriki pateke mokoa e aseako pukua, e perakano asekea, sakepamo wáraka, “Isiapo Kotiaki kekererakanapo. Unihae Kotimo ne pusiesamo epo né yano motosane makárarakanapo. Yu aporomo Unihae kárane népo.” ");
INSERT INTO faa_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Airakano Yasu saro tokia ripaka pusuapo. Wate fana Kotimo sawia poparaka, ");
INSERT INTO faa_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Saeone apea risia aporo hinamo re namohokopo. Repo Unihaeane saro toki matia ripaka peakosapo.” Aíyaka wate fana popasane apera ayareapo. ");
INSERT INTO faa_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yasu saro toki matia ripaka pesa maiya amo aporo hakāsa puramo fana Kotimo sawia popasa amo kepoane hemakapusuafapo. Asiāne Yasu hepene yapura hisiakipoko ipu hemakapuraka, “Fana Kotimo sawia poparaka aporo Unihae ayiáka peakosapo, aisane Yasu perakasu ayareapo.” Aíyaka Yasu hepene yapura hisiakipoko keseke ipu hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Arirakano Yasu Yarusarame sitia apererakano aporo hinamo yakaimo aseako pusuapo. Yasumo Rásarase kusuane maturikia taerakano, aporomo soko hinamomo soko ipu metakiramo asesamo pekea somerakano, aporo hinamo metakiramo kaikia Yasu apererakano aseako pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kotimo wakapuaka rakirane rakisiapakano Yasuane aseako pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Purakano Ferese aporomo asekea namina susu someraka, “Isiapo someane aporo hinamo suamo metakarikia, Yasumo someane kakimaka e patera asere. Yasumo isiapo hemakapusuane marakoane.” Aíyaka Ferese aporomo namina susu somesapo. ");
INSERT INTO faa_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Hokono keasiraka risia maiya amo Kiriki aporo metakira Yarusarame sitia Kotiaki kekerehoko hisiapo. ");
INSERT INTO faa_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Hikia Firipiaki somesapo. Firipimo ipi ape sumuane Pesaita taonepo. Ipi hauakane Kariri hauakapo. Firipiaki ipu someraka, “Isiapo Yasu aseako pukuripo.” ");
INSERT INTO faa_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Airakano Firipi pukua Enituaki someaka, tati hakāsa pukua Yasuaki somesapo. ");
INSERT INTO faa_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Somerakano Yasumo someraka, “Aporomanomo Tákeane anopo. Kotimo nōmo yanoane makáraraka mareasimo ano kukusa maiyane maiya yuyapo. ");
INSERT INTO faa_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nōmo kakaro somerakaripo. Makata mano kokomaresane, kauane hauaka toreraka, namo pauaka herapo. Pauaka hekea amo wate sakepamo perapo. Kokomaresane kau torehoanafonoraka namo pauaka herafapo. ");
INSERT INTO faa_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Makata mano aina ayiáka re soko ayiakakakosapo. Hauaka wo aporomo ipi kaumo rakirane mahimuraka rekeno, ipi namo kakaro yaiya rekeakosane metakarirakanapo. Hauaka wo kaumo rakirane metakarikia, patera tarirakano, ipi namo kakaro yaiya rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Aporo hinamo hakása metamo nōmo arakira ayiáka rakiako hemakapurakanone ane, anoaki patera asekea kekemahoanie. Asiamo ano rea nōmo makata rakira aporo hinamo ane anoyaki hakāsa risikiakosapo. Nōmo makata rakira aporo hinamo ane Kotimo makárahokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yasumo someraka, “Ano kukusane hemakapukua himu nenakaripo. Ataki maíyaka somehoanarakapo. Atao, maiya yumo ano kurapaka ararehoanie, aíyaka somehokosafapo. Kukusakipoko ano hauaka wo pesapo. ");
INSERT INTO faa_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Atao, aporomo né kekerehoasimo ní yano motosa máfahoanie.” Airakano hepene aeyaka Kotimo someraka, “Aporomo ano kekerehoasimo nōmo yano motosa fana máfasapo. Efera hunia soko nōmo yano motosa máfahokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aíyaka hepene aeyaka somerakano aporo hinamo su sarimaraka risiamo kairaka, “Kikirirakae,” airakano ipu metakiramo someraka, “Wae, hepene aporomo eaki makata somerakae.” ");
INSERT INTO faa_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Airakano Yasumo someraka, “Nōmo kaiyisimo hepene aeyaka somerakarifapo. Repo kaiyisimo somerakae. ");
INSERT INTO faa_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Hauaka wo aporo hinamomo makata watikiaka rakisiakipoko Kotimo hukurukusapo. Arirakano hauaka wo Satane unihaeaka reane epo wakapuane rukumosaka tapiakosapo. Asiamo Kotimo ayiakakosane pipu maiya yumo kepo marerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Arirakano ano ira matopesa paremarekea máfaraka mapoana maiya amo aporo hinamo suamo anoaki himu hakásaraka hemakapusimo nōmo kirimahokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Aíyaka e aporomo ira matopesa paremarerakano kukusane Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Aíyaka somerakano aporo sarimasamo someraka, “Kotimo sawia popasane oyapo. ‘Kotimo unihaeaka rekeasimo murikimasa aporo Keresoane yaiya rekeakosapo.’ Aíyaka popasa nine nómo someraka, ‘Aporomanomo Tákeane ira matopesa paremareakosapo.’ Airakane marirakano aíyaka somerakanare? Aporomanomo Tákeane epare?” ");
INSERT INTO faa_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Airakano Yasumo someraka, “Faesane reyaki maiya wakasema rekeakosapo. Faesa reyaki area sereamo koteaka punie. Katorakano koteaka purafapo. Katosa amo ikia kara pukusane mahimeteraka risirapo. ");
INSERT INTO faa_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ano faesa rekeno faesa aki himu hakásaraka hemakapukua risikinone, re su faeraka risikiakosapo.” Aíyaka Yasumo some kaka faraka, e tau pukua ipu aseakohoamo farareapo. ");
INSERT INTO faa_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yasumo ipi wakapumo hemakapukua rakirakano yia, ipu himo asekea asekepayasapo. Asekepayaraka eaki himu hakásaraka hemakapusuafapo. ");
INSERT INTO faa_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Aesayamo someraka ayiakakosaposane kakaro yanakano yia ipu asekepayasapo. Fana Aesayamo someraka, “Unihaeo, nómo someane isiapo some kasane ipu kakimasafapo. Unihae, nómo wakapumo hemakapukua rakirane isuaki tarisiane ipu asekepayasapo.” ");
INSERT INTO faa_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Aíyaka Aesayamo someraka kakipayana kepoane hemakapusimo some meta some kasapo. Some metane oyapo. ");
INSERT INTO faa_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Asekepayasa aporo hinamoamo himo aseakohoamo hiane Kotimo makatosapo. Himumo hemakapukohoamo himu mahimetenapo. Fana Kotimo some kakipayaraka ipu keseke someraka, ‘Kotimo isiapo makata watikisane mafahoasimosapo.’ Aíyaka hemakapukua risikiako parinapaka i himuane Kotimo mahimetesapo. I hiane makatosapo.” ");
INSERT INTO faa_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aíyaka Aesayamo somesapo. Fana Yasu peasiraka Yasumo faesane Aesayamo asekea aíyaka somesapo. Yasumo someane aporo hinamomo kakipayahokosane Aesayamo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Arirakano aporo hinamo metakiramo soko, Yu aporo fanaraka risia aporo metakiramo soko Yasumo someane kakimasapo. Kakimarakano Ferese aporomo kairaka iaki hukururapaka i namoraka risiapo. Ferese aporomo iaki someraka, “Yu aporomo sarimana apea peakopo,” airapaka Yasuaki risikiako parisane aporo suaki hufitaeraka somesafapo. ");
INSERT INTO faa_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aporo metakiramo “Ne kotesafapo,” airapaka hufitaeraka somesafapo. Aporo metakiramo “Ne kotesapo,” aihoasimo aporomo someane makama fanasapo. Kotimo “Né kotesapo,” aihoasimo someane makama fanasafapo. ");
INSERT INTO faa_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Aporo hinamo suamo kaiyisimo Yasumo sakepamo someraka, “Aporo hinamomo anoaki himu hakásaraka hemakapukua risikinone, Kotimo ano pusiesa aporoaki soko himu hakásaraka hemakapukua risikinapo. ");
INSERT INTO faa_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Repo ano aseraka ano pusiesa Kotiane soko repo aserakanapo. ");
INSERT INTO faa_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Hauaka wo ano faeraka pesapo. Faeraka perakano aporomo nōmo someane kakimaraka katosane metakarikia faeraka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Aporo hinamo suane mafasiako ano pesapo. Aporo hinamoane hukuruko ano pesafapo. Arirakano aporo hinamomo nōmo someane kaikia kakipayarakano, aporo hinamoane nōmo parakuraka hukurukusafapo. ");
INSERT INTO faa_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Aporo hinamomo anoaki patera tarikia, nōmo someane kakipayasa, some yiamo iane hukurukusapo. Pipu nōmo somesane ipu kakipayasakipoko hukuarura maiya amo somesa ane fasereperaka somesa amo iane hukurukusapo. ");
INSERT INTO faa_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nōmo someane nōmo nī hemakapusua aeyaka somerakanafapo. Atamo ano pusiesamo someaka maresane nōmo somerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Someane aporo hinamomo kakimarakano i yaiya risikiakosapo, ayiáka nōmo hemakapurakaripo. Asiamo Atamo anoaki someaka maresane nōmo reaki some karakanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ape Farimaresa Hemakapuko Hokono Keakosa maiya ane raupo, aíyaka Yasumo hemakapuraka, “Hauaka one metakarikia Ata rea hauaka yapura hiakosa maiya ane makerakanapo.” Aíyaka hemakapukua, ipi aporo hakāsa purane himu tumurumo hemakapusuapo. Ipi himu tumurumo hemakapusuane tipia metakarisiafapo. ");
INSERT INTO faa_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ereamo Yasu ipi aporo hakāsa purayaki makata nekea toapo. Makata nekea tokoasiraka Satane pekea Isekerio aporo Saemonemo hokosa Yutase himua someraka, “Nómo Yasu parakehoanie,” aíyaka Yutaseaki somesapo. Somesakipoko keseke namina hakāsa toke makata nesapo. ");
INSERT INTO faa_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Makata nekea toakipoko Yasumo hemakapuraka, “Atamo wakapu suane anoaki karakano ano siaraka rekenapo. Ano Koti rea aeyaka pesapo. Koti rea yia parihiakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Aíyaka hemakapukua ipi takahikia pasu kima ososane horomaka, tawero maka otoa sotakamaka, ");
INSERT INTO faa_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","tisia he takamaka pukua aporo hakāsa purane korake kusuraka, tawero otoa sotakamasane fatarimaka hokesapo. Aporo raipamo korake kusuraka hokena ayiáka, Yasumo kusuraka hokesapo. ");
INSERT INTO faa_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Saemone Pita rea perakano Saemone Pitamo someraka, “Unihaeo, ano korake kusuhokosare?” ");
INSERT INTO faa_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Airakano Yasumo someraka, “Korake kusuana kepoane repo yumo himeteane. Keseke hemakapukusapo.” ");
INSERT INTO faa_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Airakano Pitamo someraka, “Yumo soko keseke tipiamo soko, ano korake nómo kusuhokosafapo.” Airakano Yasumo someraka, “Né korake kusuhoanafonorakanone né anoyaki hakāsa rekeakosafapo.” ");
INSERT INTO faa_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Airakano Saemone Pitamo someraka, “Unihaeo, Korake hákasa kusuhokopo. Korake kusuraka, hokono soko, wamo soko, su kusuhoanie.” ");
INSERT INTO faa_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Airakano Yasumo someraka, “He tapuraka kau pikirisane fasekeno, efera hunia kau susu he tapurafapo. Korake hákasa kusunapo. Re su pikirisane faraka, aporo hakása meta pikirisa yaiya are.” ");
INSERT INTO faa_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Aíyaka somesane Yasu ipi parakehokosa aporoane hemakapukua somesapo. ");
INSERT INTO faa_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Korake kusuraka faraka Yasumo ipi pasu kima ososa horomaka motosane, efera hunia osoraka teporo makeraka kake someraka, “Nōmo re korake kusurakasane kepoane repo hemakapurakanare? ");
INSERT INTO faa_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Repo anoaki, ‘Tisao, Unihaeo,’ airakasuane anopo. Repo kakaro airapo. ");
INSERT INTO faa_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Repo tisane soko, repo unihaeane soko, anopo. Asiane ano aporo raipa pariraka re korakeane kususapo. Asiamo repo soko namina yia meta korakeane kusuhoanie. ");
INSERT INTO faa_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nōmo ainane reaki tarirakayiapo. Asiamo nōmo repoko raiparaka rakirakasa ayiaka, repo soko aporo hinamo metakirapoko raiparaka rakinie. ");
INSERT INTO faa_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Asiamo nōmo kakaro somerakaripo. Aporo raipamo ipi wafayane marokenafapo. Arirakano somehoko pusierakano pesa aporoamo ipi pusiesa aporoane marokenafapo. ");
INSERT INTO faa_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yumo kakaro somesane repo hemaka apure. Hemakapukua ayiáka rakirakano re seseaka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Re suane nōmo somerakanafapo. Yasumo i suaki somerakano yia, Yutasemo Yasumo someane kakimasafapo. Re su nōmo pasimosane repo hemakapusuane nōmo hemakapurakanapo. Asiane fana Kotimo sawia popasane kakaro ayiakakosapo. Aíyaka Kotimo sawia popasane oyapo. ‘Anoyaki hakāsa toke makata nesa aporoamo himu meta fasereperaka anoaki hisiraka yunuraka reapo.’ Aíyaka fana popasane pipu yanakanapo. ");
INSERT INTO faa_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Keseke ayiakakosane pipu nōmo reaki somerakanapo. Áyiana maiya amo repo asekea hemakapuraka, ‘E kakaro Keresopo. E yaiya rerapo.’ Aíyaka hemakapusimo keseke ayiakakosane pipu nōmo reaki somerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nōmo kakaro somerakaripo. Nōmo someane some kakako pusiesa aporoane peraka some karakano, aporo metamo kakimaka, nōmo someane soko kakimarakanapo. Arirakano ano pusiesa Kotiamo someane soko kakimarakanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yasu ipi aporo hakāsa purayaki toakipoko ipi himu nekea kake someraka, “Nōmo kakaro somerakaripo. Repo hakása metamo ano parakehokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Airakano aporo hakāsa pura toamo namina susu asekea someraka, “Eparakapo.” ");
INSERT INTO faa_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Aíyaka himeteaka tokeno, aporo hakāsa pura hakása metaki Yasumo himu tumurumo hemakapusuane Yasu makeraka kayapo. ");
INSERT INTO faa_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Kakeno Saemone Pitamo hi pipiraka, “Nómo Yasuaki kaisie. Aporoane epare? Aíyaka kaisie.” ");
INSERT INTO faa_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Aíyaka hi pipirakano, Yasumo hemakapusua aporo hakásane tati hakāsa karoraka toke, wamohae hákasa uaka hikia Yasu senakia someraka, “Unihaeo, aporo hakása nómo somerakasane epare?” ");
INSERT INTO faa_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Airakano Yasumo someraka, “Nōmo farawa maka he waira kokomarekea karakano, aporo ayapo.” Aíyaka epo farawa maka he waira kokomarekea, Isekerio aporo Saemonemo hokosa Yutaseaki kasapo. ");
INSERT INTO faa_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Karakano farawane Yutasemo masapo. Masa maiya amo Satane pekea epo himuane maparitaesapo. Maparitaerakano Yasumo someraka, “Nómo rakiakosane foaka rakinie.” ");
INSERT INTO faa_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Airakano aporo hakāsa pura Yasuyaki hakāsa toamo someane kaikia himetesapo. Ipu metakiramo himeteraka hemakapuraka, ");
INSERT INTO faa_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","“Yutasemo mone pausi asekea reasamo, Yasumo eaki hokono keakosakipoko makata nakosa ropohoko pusierakae.” Aíyaka hemakapusuapo. Arirakano ipu metakiramo himeteaka hemakapuraka, “Aporo makata forosaki mone kakako pusierakae.” Aíyaka i himeteraka toapo. ");
INSERT INTO faa_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Himeteraka hemakapurakano, farawane Yutase maka foaka takahikia, ere yiamo yaoa pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yutase pusuakipoko Yasumo someraka, “Aporomanomo Tákeane anopo. Nōmo wakapuane repo asekeasimo yumo nōmo reaki tariakosapo. Ano aeyaka Kotimo wakapuane soko reaki tariakosapo. ");
INSERT INTO faa_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Asiamo Kotimo wakapuane tarirakano nōmo wakapuane soko Kotimo tariakosapo. Yumo tariakosa maiya ane makerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Hokosa reo, maiya suamo reyaki ano rekeakosafapo. Wakasema nina keseke repo ano kope pukusapo. Ano hinakano re anoyaki hakāsa hiane siahoasifareapo. Some one fana nōmo Yu aporo sisimaki somesapo. Somesa hakása yine nōmo reaki somerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Asiamo somemane kawe haku nōmo reaki some karakanapo. Re namina susu himu tumurumo hemakapukua risikianie. Nōmo re himu tumurumo hemakapukua area ayiáka repo namina yia ayiáka himu tumurumo hemakapukua risikianie. ");
INSERT INTO faa_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ayiáka hemakapukua risikino aporo metakiramo asekea someraka, ‘I Yasu patera asesa aporo ayareapo,’ aíyaka somehokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saemone Pitamo someraka, “Unihaeo, né ma hiakosare?” Airakano Yasumo someraka, “Ano hiakosa á yumo né kekemarape hiane siahoasifareapo. Keseke né hiakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Airakano Pitamo someraka, “Marirakano ano yumo kekemarape hiakosafaporakanare? Nōmo né hemakapuraka népoko ano kukuko hisirakanafapo.” ");
INSERT INTO faa_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Airakano Yasumo someraka, “Né anopoko kakaro kukusare? Hao, kaisie. Nōmo neaki kakaro somerakaripo. Kokoroko mehoasiraka nómo ‘Yasuane nōmo aserafapo.’ Aíyaka nómo yape isiamo kotafe somehokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yasumo ipi aporo hakāsa puraki someraka, “Repo kara hemakapukua himu fahokopo. Kotiaki himu hakásaraka hemakapukua risikianie. Anoaki soko himu hakásaraka hemakapukua risikianie. ");
INSERT INTO faa_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nōmo atamo apea, ape rumu yakai risikinapo. Ape rumu yakai risikianafonosa satiki nōmo reaki aíyaka somehoafunufapo. Re hepene yapura hinaka risikiakosa apeane ano fana hinaka repoko maropohoko hiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ano hikia repoko ape maroporaka, siaraka marekea keseke ano rea hauaka isina hakāsa risikiakosakipoko re pasimokoako ano paripeakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Asiamo ano rea hauaka hiakosa ikia karane repo hemakapurapo.” ");
INSERT INTO faa_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Airakano Tomasemo someraka, “Unihaeo, né rekeakosa hauakane isu himeteripo. Ikia kara soko, isu himeteripo.” ");
INSERT INTO faa_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Airakano Yasumo someraka, “Ikia karane anopo. Kakaro somerane anopo. Yaiya rera kepoane soko anopo. Re Ata rea hauaka hiakosane ano koaraka hiakosafapo. Anoaki himu hakásaraka risiane hiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Repo ano aseraka nōmo Ata soko aserakanapo. Pipu yumo Ata repo asekea hemakapurakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Airakano Firipimo someraka, “Unihaeo, Atane isuaki tarisie. Tarirakano isiapo aseraka someraka efera hunia tarisie aihokosafapo.” ");
INSERT INTO faa_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Airakano Yasumo someraka, “Maiya káramo ano reyaki reapo. Asiane Firipio, nómo ano hemakapurakarifare? Repo ano aseraka nōmo Ata soko aserakanapo. Mayiakako Ata tarisie, airakanare? ");
INSERT INTO faa_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ano Atayaki rekenapo. Atane anoyaki rekenapo. Iti sarimaraka hakása yineraka risikinapo. Firipio, makata ane nómo hemakapurakarifare?” Aíyaka ipi aporo hakāsa pura susuaki Yasumo someraka, “Reaki makata some akara one nōmo nī hemakapusua aeyaka reaki some karakanafapo. Ata anoyaki reke epo wakapuaka rakirane tarirakano nōmo rakirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nōmo Ataki kataka marekea, Atamo anoaki kataka marekea, ayiáka iti hakása yineraka risikinapo. Nōmo someraka one kakimakanie. Repo kakimakanafonorakano ane, nōmo wakapuaka arakirane repo himo asekea, anoaki himu hakásaraka hemakapunie. Hemakapukua nōmo someane soko kakimakanie. ");
INSERT INTO faa_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nōmo kakaro somerakaripo. Aporo hinamomo nōmo someane kakimaka himu hakásaraka risike, nōmo arakira ayiáka aporo hinamoamo ayiáka rakiakosapo. Ano Ata rea yapura hinaka, Ho Kotesa pusierakano, Ho Kotesa hauaka wo peraka, Ho Kotesamo reaki wakapu karakano, repo nōmo makata rakirane marokeraka repo makata kára rakiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Repo anoaki himu hakásaraka risike ano yano motosa mafanahoko hemakapukua kurikuriraka makata ayiakanie, airakano, nōmo ayiakakosapo. Atamo wakapu kárane aporo suamo asekeasimo repo ayiakanie airakano, ipi hokosa nōmo ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Repo anoaki himu hakásaraka risike ano yano motosa mafanahoko hemakapuraka makata su ayiakanie, airakano makata suane nōmo ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Repo anoaki himu tumurumo hemakapukua risikinone nōmo somemaneane soko repo kaikia kekemaraka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Kekemaraka risikino nōmo Ataki someraka, re ararehoko Ho Kotesa pusiehoanie, aihokosapo. Airakano Ho Kotesamo re ararehoko Atamo pusiehokosapo. Pusierakano peakosapo. Peraka Ho Kotesa reyaki yaiya rekeakosapo. Ho Kotesane Kakaro Somera Hoane epo. ");
INSERT INTO faa_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ho Kotesane nena aporo hinamomo, ‘Isuyaki hakāsa reae,’ airafapo. Epo ainane ipu aserafapo. Arirakano eane ipu hemakapurafapo. Arirakano repo Ho Kotesane hemakapurapo. Yumo Ho Kotesa reyaki rekenapo. Keseke re himua hakása hakásaraka Ho Kotesane rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Arirakano réane karaiya hokosa ayiáka risikiasimo nōmo re metakariakosafapo. Ano paripeakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Arirakano maiya wakasema nina kakimakanafonona aporo hinamoamo ano efera hunia aseakosafapo. Arirakano repo anoane aseakosapo. Ano yaiya rekeakosasamo, re soko yaiya risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Maiya amo ano Atayaki reke, arirakano re anoyaki reke, arirakano ano reyaki reke, ayiáka isina su hakāsa risike repo hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nōmo somemane kaikia kekemara aporo hinamoamo anoaki himu tumurumo hemakapurapo. Anoaki himu tumurumo hemakapusua aporo hinamoane nōmo Atamo himu tumurumo hemakapukusapo. Aporo hinamoaki, nōmo soko himu tumurumo hemakapukusapo. Ipu ano kakaro koteaka hemakapusimo nōmo ainane iaki tariakosapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Airakano Yutasemo Yasuaki makata somesapo. Arirakano Isekerio aporo Yutase Yasu parakesa ayafapo. Epo ipi yako Yutase metamo someraka, “Unihaeo, nómo ainane isuaki hákasa tarikia, nena aporo hinamoaki tariakosafapo, airakane mairakare?” ");
INSERT INTO faa_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Airakano Yasumo someraka, “Aporo hinamomo anoaki himu tumurumo hemakapurakano nōmo someane soko aporo hinamoamo kaikia kekemahokosapo. Kakimara aporo hinamoaki nōmo Atamo soko himu tumurumo hemakapukusapo. Aporo hinamo akiyaki Ata eto risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Arirakano aporo hinamomo anoaki himu tumurumo hemakapunafonorakano, aporo hinamoamo nōmo someane kakimakosafapo. Nōmo some karakano repo kaisiane nōmo nī hemakapusuane reaki some kasafapo. Atamo ano pusiesamo epo hemakapusuane nōmo reaki some kasapo. ");
INSERT INTO faa_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Yumo ano reyaki areamo some karakanapo. ");
INSERT INTO faa_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Keseke Atamo ano yano motosa mafanaraka re ararehoko Ho Kotesa pusiehokosapo. Pusierakano re himua Ho Kotesa peakosapo. Peraka repo makata su enomaka hemakapusimo epo some kakakosapo. Nōmo somerakano repo kaisiane efera hunia hemakapusimo repo himura Ho Kotesamo mahemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Arirakano nōmo tau auaraka rerane reaki karakanapo. Hauaka wo aporomo tau auaraka rerane reaki ayiáka karafapo. Nōmo auaraka rerane reaki karakano re himu faraka namoraka risikiakopo. ");
INSERT INTO faa_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nōmo fana someraka, ‘Nōmo reane metakarikia ano hikia, keseke re arisia paripeakosapo.’ Aisane repo kaisiapo. Repo himu tumurumo anoaki hemakapuraka, nōmo Ata rea hiakosaposane kaikia seseaka hemakapunie. Atane namo kakaro fanaraka reke, Ata patera ano rekenapo. E rea ano hiakosapo aisane repo kaikia seseaka hemakapunie. ");
INSERT INTO faa_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ano hiasiraka area omo reaki somerakanapo. Nōmo someane repo kakimakasimo keseke ayiakakosane, yumo nōmo reaki somerakanapo. Ano hinakano repo aseraka nōmo someane kakimakosapo. ");
INSERT INTO faa_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Arirakano reaki somehokosa maiyane fahoko makerakanapo. Hauaka omo unihae Satane peako makeraka rekenapo. Satanemo ipi wakapumo ano hurutapirafapo. Epo anoaki ayiakanierakano nōmo kakimarafapo. ");
INSERT INTO faa_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Atamo ayiakanierakano nōmo kakimarapo. Ataki nōmo himu tumurumo hemakapurapo. Nōmo Ataki himu tumurumo hemakapukua reane aporo hinamo suamo hemakapusimo, nōmo Atamo ayiakanierakano nōmo kakimarapo. Arirakano yumo nōmo someane yiyapo. Re su takahisie. Isu purakapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yasumo someraka, “Kakaro sako karepe kepo asíane anopo. Sako karepe hemo wafayane nōmo Atapo. ");
INSERT INTO faa_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Anoa eyamo kataka marekea reke wate peanafonosane, hemo wafayamo eya ane popateraka mokoatenapo. Arirakano eyamo kataka marekea reke wate pesane efera hunia peasimo eyane horoposane hako kepo tipia popatenapo. Popateraka kepo aeyaka efera hunia susuniraka wate yakai koteaka perapo. ");
INSERT INTO faa_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Asiamo repo nōmo someane kakimasasamo repo makata watikisane nōmo someamo popateraka mokoatesapo. ");
INSERT INTO faa_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Re anoyaki reke, ano soko, reyaki reke, ayiáka isina hakāsa sarimaraka risikiakosapo. Sako karepe eya foanepekea hauaka kake ipi hemakapukua wate perafapo. Sako karepe eyamo kepoa kataka marekea rekeno wate perapo. Wate pekea area ayiáka repo anoaki himu hakásaraka kataka marekea risike koteaka rakipe puraka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Sako karepe kepo asíane anopo. Sako karepe eya asíane repo. Repo anoaki kataka marekea risikino, nōmo kepo aeyaka sisipuane eya pukua, wate pekea arisia ayiáka re ayiáka risikiakosapo. Anoaki kataka marekea risikianafonoraka, wate peanafonoraka arisia ayiáka re ayiáka risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Anoaki kataka marekea risikianafonosa aporo hinamoane sako karepe eya pateke mokoatesa asiapo. Pateke mokoatesane yoferaka poranapo. Porasa mokoatesane su sarimaraka faturaka ira paikimarerapo. ");
INSERT INTO faa_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Repo anoaki himu hakásaraka hemakapukua risike, nōmo someane repo kakimaka hemakapukua kekemaraka rakipe puraka, repo anoaki ayiakanierakano nōmo ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Arirakano wate apera ayiáka nōmo some kakimara aporo hinamoane namo kakaro koteaka risikiakosapo. Ayiaka risikino aporo hinamo metakiramo asekea nōmo Atane makarahokosapo. ");
INSERT INTO faa_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Atamo anoaki himu tumurumo hemakapukua area ayiáka, nōmo soko reane ayiáka himu tumurumo hemakapukua rekenapo. Nōmo himu tumurumo hemakapusuane repo metakariakopo. Yaiya maka risikianie. ");
INSERT INTO faa_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Atamo someane nōmo kakimarakano Atamo ano yaiya himu tumurumo hemakapukua rekenapo. Hemakapukua area ayiáka, nōmo somemane soko repo kakimarakano, re soko, nōmo yaiya himu tumurumo hemakapukua rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nōmo sesenane reyaki risikiasimo nōmo reaki somerakanapo. Nōmo someane kakimaraka repo kára seseraka mapiraraka siaraka mokoasimo hemakapurakaripo. ");
INSERT INTO faa_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nōmo somemane oyapo. Nōmo re himu tumurumo hemaka apura ayiáka, repo namina yia ayiáka himu tumurumo hemakapunie. ");
INSERT INTO faa_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Aporomo ipi aporo tákepoko farimaka kurane ane, himu tumurumo hemakapusuane namo kakaro fanapo. ");
INSERT INTO faa_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nōmo somemane repo kaikia kekemarakano reane nōmo tákepo. ");
INSERT INTO faa_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yumo reaki nōmo aporo raipapo, airakanafapo. Asiamo aporo raipaki wafayamo ipi hemakapusuane somerafapo. Arirakano Atamo anoaki somesane makata su reaki nōmo somerakanapo. Aporo tákeaki somera ayiáka nōmo reaki somerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Repo ano murikimaka pasimasafapo. Nōmo reane murikimaka pasimosapo. Asiamo sako wate pekea arisia ayiáka re ayiakasimo nōmo reane pasimokoa murikimaka makata rakiako pusiesapo. Wate yaiya peraka risikiasimo murikimaka makata rakiako pusiesapo. Pusierakano repo ano yano motosa mafanaraka hemakapukua risike, Ataki ayiakanierakano epo ayiakakosapo. ");
INSERT INTO faa_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Arirakano nōmo reaki somemane akara oyapo. Repo namina yia metamo metane himu tumurumo hemakapukua, arirakano metamo metane himu tumurumo hemakapukua ayiáka risikianie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Arirakano Yasumo someraka, “Aporomo reaki hisirakanone, anoaki fana hisisane, repo hemakapunie. ");
INSERT INTO faa_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Re nena aporoyaki paosa satiki ipu reaki himu tumurumo hemakapufunupo. Arirakano nōmo re pasimokoa murikimasasamo re nena aporoyaki paosafapo. Re iyaki hakāsa yinehoanafonosasamo ipu reaki hisihokosapo. ");
INSERT INTO faa_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Fana nōmo reaki somesane meraruhokopo. Somesane oyapo. ‘Aporo raipamo ipi wafayane marokenafapo.’ Aíyaka fana nōmo somesapo. Asiamo nena aporomo ano mokoatikira ayiáka, re soko mokoatikihokosapo. Arirakano nōmo someane ipu kakimarakano, repo someane soko kakimakosapo. ");
INSERT INTO faa_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Repo ano patera asesasamo ipu re mokoatikihokosapo. Kotimo ano pusiesane namina hemakapurakanafapo. ");
INSERT INTO faa_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ano hauaka wo peraka makata watikiaka rakirane kakama somesapo. Somesasamo ipu makata watikiaka rakisiane hufitaeraka metakariafunupo. Asiāne nōmo someane ipu kaikia, makata watikiaka rakisiane metakarirafaraka, yaiya asekepayarakano, ipu makata watikisa amo iane hukurukusapo. Aporo hinamomo makata watikiaka rakisiane metakarisimo, nōmo somehoko peanafonosa satiki ipu makata watikisane meraruamo yaiya rakiafunupo. ");
INSERT INTO faa_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Arirakano anoaki hisisa aporo hinamomo nōmo Ataki soko hisirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nōmo wakapuaka rakisia ayiáka, fana aporo hakása metamo ayiáka wakapuaka rakisiafapo. Nōmo wakapuaka rakianafonosa satiki aporo hinamo metakiramo hemakapuraka, ‘Wakapuaka rakirane isiapo asesafapo,’ aihoafunupo. Asiāne nōmo wakapuaka rakisiane ipu asekea asekepayaraka, ipu makata watikiaka rakisiane metakarisiafapo. Metakarianafonosasamo ipu makata watikisa amo iane hukurukusapo. Nōmo wakapuaka rakisiane aporo hinamomo asesapo. Asekea yia anoaki soko, Ataki soko, hisiraka risikinapo. ");
INSERT INTO faa_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Arirakano fana Kotimo sawia popasane oyapo. ‘Ipu namina anoaki nenakamakayia hisihokosapo.’ Aíyaka fana poparaka ayiakakosaposane yumo yainakanapo. ");
INSERT INTO faa_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Arirakano Ho Kotesa re ararehoko peakosane Ata rea aeyaka peakosapo. Kakaro someane aporo hinamomo hemakapusimo some kaka, arirakano tarikia, ayiakako peakosapo. Ano Ata rea yapura hinaka Ho Kotesamo re ararehoasimo nōmo Ataki someraka, Ho Kotesa pusiehoanie, aihokosapo. Airakano Atamo pusiehokosapo. Pusierakano peakosapo. Peraka anoane kakaro tarikia some kakakosapo. ");
INSERT INTO faa_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Arirakano hauaka wo koraka reke nōmo makata kepomarekea rakisia maiya amo re anoyaki hakāsa risiapo. Maiya suamo isina hakāsa risirasamo ano asesane repo aporo hinamo metakiraki some kakanie.” Aíyaka Yasumo ipi aporo hakāsa puraki somesapo. ");
INSERT INTO faa_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Yasumo ipi aporo hakāsa puraki someraka, “Repo anoaki himu hakásaraka hemakapusuane metakarirapaka, keseke ayiakakosane yumo nōmo reaki some akara oyapo. ");
INSERT INTO faa_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Keseke ano patera asekeanafonosa aporoamo reaki someraka, ‘Yu aporomo sarimana apea Kotiaki kekerehoko peakopo,’ aihokosapo. Ipu re kukusimo rukusapo. Rukua someraka, ‘Isiapo Kotimo rakirane rakiraka reane rurakanapo,’ aíyaka somehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Aporoamo Kotiane soko anoane soko hemakapunafonosasamo reane mokoatikihokosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mokoatikihokosane nōmo yumo someraka one keseke re mokoatikiana maiya amo nōmo somesane repo hemakapukusapo. Hemakapukua risikiasimo keseke ayiakakosane yumo nōmo reaki somerakanapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yasumo someraka, “Fana isina hakāsa risikisuamo some one nōmo reaki somesafapo. Asiamo Kotimo ano pusiesa amo hauaka hiakosakipoko yumo nōmo reaki somerakanapo. Somerakano repo anoaki someraka, ‘Ne ma hiakosare?’ airakarifapo. ");
INSERT INTO faa_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nōmo somerakano repo kairaka kára hemakapukua himu nekea atoae. ");
INSERT INTO faa_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Asiamo nōmo kakaro somerakaripo. Re makotehokosakipoko ano hinakanapo. Ano hianafonorakanone, Ho Kotesamo re ararehoko peakosafapo. Ano hinaka Ho Kotesaki pusierakano Ho Kotesamo re ararehoko peakosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Peraka aporo hinamo su hauaka wo risiaki hakása hakásaraka someraka, ‘Nómo watikiaka rakisiane ayapo. Arirakano makata ereketae aina susuane ayapo. Arirakano aporo hinamomo watikiaka rakisiane Kotimo hukurukusapo.’ Aíyaka Ho Kotesamo tarikia somehokosapo. Arirakano aporo hinamomo hasaka hemakapusuane Ho Kotesamo tariakosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","‘Asiamo aporo hinamomo anoaki himu hakásaraka hemakapukua risikianafonorakano ane makata watikisamo kepoane ayapo.’ Aíyaka makata watikisamo kepoane Ho Kotesamo tarikia somehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Arirakano kakaro ereketae somera aporoane anoreapo, aíyaka hemakapusimo Ho Kotesamo reaki tariakosapo. Asiamo ano makáraraka marerakano, Ata rea ano hinakano repo ano aseakosafapo. Asekeanafonona maiya amo ereketae somera aporoane ano reapo, aíyaka repo hemakapukusapo. Hemakapusimo Ho Kotesamo tarikia somehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Arirakano hukurukusa amo kepoane Ho Kotesamo reaki tariakosapo. Ano hauaka wo pesasamo hauaka wo unihae Sataneane Kotimo rukumosakatapisiapo. Rukumosakatapisiane Ho Kotesamo reaki tarikia somehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Arirakano makata metakira soko nōmo somehokosapoko asiane some kárasasamo repo hemakapusifareapo. ");
INSERT INTO faa_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Arirakano Ho Kotesa aperamo kakaro some kepoane repo hemakapusimo epo kakaro some susuane reaki some kakakosapo. Epo hemakapusua aeyaka somehokosafapo. Nōmo someane soko Atamo someane soko epo kaisiane reaki somehokosapo. Keseke ayiakakosane soko somehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Epo ano makárahokosapo. Nōmo ainane epo reaki somehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Atamo menane nōmenapo. Asiamo nōmo ainane repo hemakapusimo Ho Kotesamo reaki somehokosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yasumo ipi aporo hakāsa puraki someraka, “Wakasema risina repo ano aseakosafapo. Arirakano wakasema risina repo anoane efera hunia aseakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Airakano aporo hakāsa puramo namina susu someraka, “Yasumo ipi someraka, ‘Wakasema risina repo ano aseakosafapo. Wakasema risina repo ano efera hunia aseakosapo.’ Aíyaka Yasumo some meta someraka, ‘Ata rea ano hiakosasamo repo ano aseakosafapo.’ airakane kepoane yakaparakapo. ");
INSERT INTO faa_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yasumo someraka, ‘Wakasema risina,’ aíyaka somerakane kepoane yakaparakapo. Isu himeteripo.” ");
INSERT INTO faa_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Airakano Yasumo someraka, “Wakasema risina repo anoane aseakosafapo. Arirakano wakasema risina repo anoane efera hunia aseakosapo, aíyaka nōmo somehoane repo namina susu me arure. ");
INSERT INTO faa_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Nōmo reaki kakaro somerakaripo. Ano rusua kurakano hauaka wo anoaki hisiraka risia aporo hinamomo kára sesehokosapo. Asiāne repo anopoko hemakapuraka hihiripuhokosapo. Repo hihiripusane faraka sesehokosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Arirakano hokosa takapeakosakipoko hinamo kau teraka karápo. Takapekea hokosa maka kake, kau tesane soko, kau nenakasane soko, faraka, meraruraka, seseraka karápo. Aporo hokosa takapesasamo seseraka karápo. ");
INSERT INTO faa_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Aina ayiáka yumo re soko himu nekea risikinapo. Wakasema risina ano maturikia taeraka re aseako perakano, re seseraka risikiakosapo. Repo sesenane yaiya risikiakosapo. Aporo metamo re mokoatikianamo soko, makata umisa fasere aperamo soko, repo sesenane yaiya risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","24","Ano turikia pukua hepene yapura ahira maiya amo repo anoaki kaiyakosafapo. Ataki kaikia kurikurihokosapo. Repo ano yano motosane makama fanaraka hemakapukua Ataki ayiakanierakano epo ayiakakosapo. Fana soko yumo soko ano yano motosane makama fanaraka hemakapukua repo Ataki ayiakaniesafapo. Kára seseraka mapiraraka risikiakosakipoko Ataki ayiakanierakano epo ayiakakosapo. Nōmo reaki kakaro somerakaripo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Yasumo ipi aporo hakāsa puraki someraka, “Fana nōmo reaki takumeaka somesapo. Asiamo keseke Atane nōmo kakama hufitaeraka somehokosa maiyane makerakanapo. ");
INSERT INTO faa_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Maiya amo repoko nōmo Ataki kaiyakosafapo. Repo ano yano motosa makama fanaraka hemakapukua risike, repo namina yiamo Ataki kaiyakosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ano Koti aeyaka pesane repo kakimaka, arirakano repo anoaki himu tumurumo hemakapukua asiasamo Kotimo reane himu tumurumo hemakapukua rekenapo. ");
INSERT INTO faa_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ata rea aeyaka ano hauaka wo pesapo. Pekea wakasema nina hauaka one metakarikia Ata rea yapura parihiakosapo.” ");
INSERT INTO faa_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Airakano aporo hakāsa puramo someraka, “Nómo takumeaka somesane metakarikia, yumo isuaki kakama hufitaeraka somerakae. ");
INSERT INTO faa_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Makata suane nómo hemaka apure. Isiapo neaki kaiyakosane, kaiyasiraka nómo ní hemakapukua somerapo. Asiamo né kakaro Kotimo pusiesapo, aíyaka isiapo hemakapurakaripo.” ");
INSERT INTO faa_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Airakano Yasumo someraka, “Repo anoaki kakaro himu hakásaraka hemakapukua risikinare? ");
INSERT INTO faa_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Maiya wakasemamo risina, repo ano metakarikia repo namina ape kekepoa teketarikia pukusapo. Teketarikia purakano ano ni haku rekeakosapoko asiane Ata anoyaki rekeakosapo. ");
INSERT INTO faa_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Repo anoaki himu hakásaraka risike namonane faraka, mapiraraka risikiasimo, keseke ayiakakosane nōmo somerakanapo. Hauaka wo aporomo re mokoatikihokosapo. Mokoatikirakano yia, namonafaraka paroaka risikianie. Hauaka wo anoaki yunuraka risia aporo hinamoane nōmo wakapumo rukumosakatapisiapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yasumo ipi aporo hakāsa puraki someaka faraka, hepene yapura asekea kurikuriraka, “Atao, nómo fana ayiakakosaposane maiya omo ainakanapo. Nōmo né makárahoasimo nómo ní hokosa anoane makáraraka mareanie. ");
INSERT INTO faa_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Aporo hinamo suane nōmo unihaeaka asekea rekeasimo nómo ano maresapo. Asiamo aporo hinamo nómo murikimaka anoaki kasane nōmo iane asekea reke, yaiya risirane iaki kasapo. ");
INSERT INTO faa_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Asiamo yaiya risirane kepoane oyapo. Atao, kakaro Koti hákasane népo. Arirakano Yasu Kereso hauaka wo pusiesane anopo. Anoaki soko néaki soko himu hakásaraka hemakapukua risia aporo hinamoane etoyaki hakāsa yaiya risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nómo anoaki ayiáka rakiniesane nōmo rakikia masapo. Rakikia masasamo né kararaka reane aporo hinamomo hemakapusimo nōmo tarisiapo. ");
INSERT INTO faa_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Atao, hauaka one kepomareasiraka ano neyaki kararaka faesa reapo. Kararaka faesa rea ayiáka efera hunia soko, ayiáka kararaka faesa rekeako nómo anoaki kakanie. ");
INSERT INTO faa_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Hauaka wo aporo su risiane nómo asekea, metakira nómo murikimaka pasimokoa anoaki kasapo. Asiamo nómo anoaki kasá aporoane nómo ní ainane hemakapusimo, nōmo tarisiapo. Aporo ane fana nómo aporo risiapo. Asiamo nómo aporoane anoaki kasapo. Kasá aporoamo nómo someane kakaro kakimaka rakisiapo. ");
INSERT INTO faa_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Arirakano nōmo wakapuaka arakirane kepoane né aeyaka pesasamo ipu hemakapurakanapo. ");
INSERT INTO faa_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nómo someaka maresane nōmo iaki some kasapo. Some karakano ipu kakimasapo. Ano néyaki fana reane soko, nómo ano pusiesane soko, ipu kakimaka hemakapurakanapo. ");
INSERT INTO faa_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iane nómo ararehoasimo nōmo kurikurirakanapo. Arirakano neaki hisisa aporo akipoko nōmo kurikurirakanafapo. Nómo aporo pasimokoa anoaki kasáne nómo ní menasasamo ipoko nōmo kurikurirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Nómomenane etapo iti menapo. Arirakano nōmomenane soko etapo iti menapo. Ano patera asesa aporomo nōmo yano motosane makararaka tarirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","I hauaka wo risikiakosapo. Arirakano ano hauaka one metakarikia, né rea peakosapo. Ata Kotesao, nómo anoaki kasá aporoamo néaki himu hakásaraka hemakapukua risikiasimo, nómo iane asekea rekeanie. Etapo iti himu hakāsaraka hemaka apura ayiáka, ipu soko ayiáka himu hakāsaraka hemakapukua risikiasimo ararehoanie. ");
INSERT INTO faa_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ano iyaki rea maiya amo iane nōmo mafairaka asekea reapo. Ipu nómo ainane hemakapusimo nōmo iane asekea reapo. Asekea rekeno iane paripusuafapo. Asiāne aporo hakása meta ipi hemakapusua aeyaka paripusuapo. Nómo sawia poparaka ayiakakosapo, aisane kakaro hakása yine fasereperaka ayiane. ");
INSERT INTO faa_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Asiamo ano né rea peakosapo. Ano seseraka area ayiáka iane soko kára seseraka risikiasimo nōmo néaki kurikurirakanapo. Ano hauaka wo area yumo nōmo ipoko kurikurirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nómo someane nōmo iaki some karakano ipu kakimasapo. Ipu kakimaraka hauaka wo makata rakira hemakapusuane metakarisiasamo, nena aporomo iaki hisirakanapo. Arirakano hauaka wo makata rakira nōmo hemakapunafonona ayiáka ipu soko hemakapurakanafapo. Asiamo iaki nena aporomo hisiraka risikinapo. ");
INSERT INTO faa_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","I hauaka one metakarisimo nómo pasimokoanie, aíyaka nōmo kurikurirakanafapo. Hauaka wo Satanemo i asekea rekeakohoamo nómo mafairaka asekea rekeanie, aíyaka nōmo kurikurirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hauaka wo makata rakira nōmo hemakapunafonona ayiáka ipu soko ayiáka hemakapurakanafapo. ");
INSERT INTO faa_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nómo someane kakaro somepo. Kakaro someane kakimaka risikiasimo nómo iane ararehoanie. Kakaro some á hákasa risikiasimo ararehoanie. ");
INSERT INTO faa_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Aporo hinamo hauaka wo risiaki some kakako nómo ano pusiesa ayiáka, ipu soko aporo hinamoaki some kakako nōmo iane pusierakanapo. ");
INSERT INTO faa_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ipu namina ainane neaki kakasimo, nōmo nī ainane néaki karakanapo. Asiamo ipu nómo kakaro someane kakimaka risikiasimo, nōmo nī hemakapusua aeyaka ano rusua kukusapo. ");
INSERT INTO faa_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Asiamo ipoko hákasa nōmo kurikurirakanafapo. Ipu some karakano aporo hinamomo kakimaka, anoaki himu hakásaraka risikiakosa aporo hinamo akipoko soko nōmo kurikurirakanapo. ");
INSERT INTO faa_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Arirakano ipu namina metamo metaki hemakapukua, metamo metaki hemakapukua ayiáka himu hakásaraka risikiasimo ararehoanie. Atao, néane anoyaki reke, arirakano anoane néyaki reke, ayiáka eto iti himu hakása yineraka arisia ayiáka, ipu etoaki himu hakásaraka kataka marekea ayiáka risikiasimo ararehoanie. Asiamo kakimara aporo hinamomo himu hakásaraka hemakapukua risikino, kakimakanafonosa aporo hinamomo asekea hemakapuraka, ‘Kotimo Yasuaki hauaka wo pusiehoareapo.’ Aíyaka ipi hemakapukusapo. ");
INSERT INTO faa_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nómo wakapu ainane anoaki kasane, nōmo some kakimara aporo hinamoaki wakapu aina hakása yine kasapo. Iti hakasa yineraka arisia ayiáka ipu soko namina hakasa yineraka ayiáka risikiasimo nómo wakapu ainane iaki kasapo. ");
INSERT INTO faa_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Né anoyaki reke, ano iyaki reke, ayiáka isina himu hakásaraka risikinapo. Himu hakásaraka risiane kakimakanafonosa aporo hinamomo asekea someraka, ‘Kotimo Yasuane hemaka apura ayiáka, kakimara aporo hinamoane soko, Kotimo hemakapurakanapo. Asiamo Kotimo Yasu hauaka wo pusiesapo, aisane kakarohoareapo,’ aíyaka ipu hemakapusimo himu hakásaraka hemakapurane kakimara aporo hinamoaki kakanie. ");
INSERT INTO faa_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Atao, nómo anoaki aporo hinamo kasane anoyaki hakāsa risikiasimoripo. Hauaka one kepo mareasiraka nómo anoaki himu tumurumo hemakapusuapo. Hemakapuraka nómo wakapu faesa kotesane anoaki kasapo. Wakapu faesa kotesa anoaki kasane ipu asekeasimo anoyaki hakāsa risikiasimoripo. ");
INSERT INTO faa_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Atao, Ereketae aina kepoane népo. Asiamo nómo some hisisa aporo hinamomo néane hemakapurakanafapo. Néane nōmo hemakapurakanapo. Nómo ano pusiesane nōmo aporo hakāsa puramo hemaka apure. ");
INSERT INTO faa_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Néane ipu hemakapusimo nōmo iaki tarisiapo. Tarisiane yaiya tariraka rekeakosapo. Asiamo nómo anoaki himu tumurumo hemaka apura ayiáka, himu tumurumo hemakapurane i himua mahemakapunie. Arirakano ano soko iyaki hakāsa rekeakosapo.” Aíyaka Yasumo kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yasumo kurikuriraka faraka Yasu takahikia apeane metakarikia, ipi aporo hakāsa purayaki pukua, he wakasema yano motosa he Kitorone yaoraka hikia, ira orofe hemoa hikia toapo. ");
INSERT INTO faa_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Asiamo Yasu ipi aporo hakāsa purayaki hemoa tokoako hikianasamo, hemoa efera hunia tokoakosakipoko hisiapo. Arirakano hemoane Yasu parakehokosa aporo Yutasemo aserapo. ");
INSERT INTO faa_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Aserasamo hemoa Rome kamani ame aporo soko, arirakano Kotimo apea sikiriti aporo asekea risiane soko Yutasemo karikia hisiapo. Arirakano fana pirisiti aporope Ferese aporo ipu sikiriti aporoaki someraka, “Re Yutaseyaki paoraka hisie.” Airakano iane Yutasemo karikia, Yasu parakehokosakipoko hemoa hikia, ipu ira rokopa soko, kapi soko, sari soko, wera makatane mokoa, nafa paikia, arirakano sapa paikia ayiáka hisiapo. ");
INSERT INTO faa_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Hikia perakano, Yasumo aseraka eaki makata ayiakakosane epo ipi hemakapusuapo. Yasumo ipi aporo hakāsa purayaki hakāsa toane, iane yia metakarikia, aporomo e waseremako pesa sapea pusuapo. Puraka Yutasemo aporo karikia pesaki Yasumo someraka, “Repo epa kope perakanare?” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Arirakano e parakehokosa aporo Yutaseane iyaki hakāsa yia rekeno, ipu suamo someraka, “Nasare aporo Yasuane isiapo kope perakanapo.” Airakano Yasumo someraka, “Anopo.” ");
INSERT INTO faa_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Airakano i suane fofaraka wakasema fimiti pukua, hauaka atura hurupeperaka warisiapo. ");
INSERT INTO faa_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Warisikino Yasumo efera hunia someraka, “Repo epa kope perakanare?” Airakano ipu someraka, “Nasare aporo Yasuane isiapo kope perakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Airakano Yasumo someraka, “Reaki nōmo somerakasa ayapo. Repo ano kope peraka, nōmo aporo hakāsa purane pusimo metakarisie. Purakano matasohokopo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Arirakano fana ipi Kotiaki someraka, “Aporoane nómo anoaki kasane, hakása meta hasaka kosafapo.” Aíyaka Kotiaki somesasamo waseremako pesa aporoaki Yasumo someraka, “Aporo hakása meta repo rukupo. Metakarisie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Airakano Saemone Pitamo ipi ferepemo pirisiti aporo fanamo aporo raipa senaki tumuru takuane rukusakare tapisiapo. Aporo raipa amo yano motosane Maokase, ipi senaki rukusakare tapisiapo. ");
INSERT INTO faa_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Rukusakare tapirakano Yasumo Pitaki someraka, “Ferepeane nómo ferepe makera pausi terakae hisia á rusakamaresie. Atamo ano kukusane maresasamo himu nekea, kau teraka kukusapo. Kukusane metakariakosafapo.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Arirakano ame aporo soko, satini soko, sikiriti aporo soko, ipu Yasuane hokono tetákara taporaka waseremaka, ");
INSERT INTO faa_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anasemo apea karikia pusuapo. Anasemo ipi farayane Kaiafasemo arumasapo. Keremisi amo Kaiafase ipi pirisiti aporo fanaraka reapo. ");
INSERT INTO faa_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Arirakano fana Kaiafasemo Yu aporoaki someraka, “Aporo hinamo supoko aporo hakása kuane siahoasireapo.” Aíyaka Kaiafasemo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Yasu fana karikia purakano, Saemone Pita soko, aporo hakāsa pura meta soko, kesekea kekemarape pusuapo. Pukua pirisiti aporo fanamo apea pauraka, aporo hakāsa pura tetá pesa amo aporo hakása metamo pirisiti aporo fanane aserapo. Aserasamo ape ruru ikia koro aeyaka yorokoa pukua, Yasuyaki hakāsa ape hauaka moroa pukua risiapo. ");
INSERT INTO faa_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita kumuku pekea, ikia koro yao takua rekeno, aporo hakāsa pura meta fana pusuane ikia koroa paripesapo. Paripekea ruru ikia koro asekea rea hinamoaki someraka, “Pita peasimo ikia koro ropaka mayane siahoasireare?” Airakano hinamoamo aoaka, ikia koroane ropaka masapo. Ropakamaka Pita perakano ");
INSERT INTO faa_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","hinamoamo eaki someraka, “Yasumo aporo hakāsa pura metane nere?” Airakano Pitamo kotafe someraka, “Anofapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Arirakano sikiriti aporo soko, pirisiti aporo raipa soko inurakano ira kau asia paikia rufirakano, hokono ira tarikia asekea risiakipoko, Pita soko ira hakakosakipoko pekea, iyaki hakāsa risiapo. ");
INSERT INTO faa_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pitane aporo metakirayaki sarimaraka ira haraka risiakipoko, pirisiti aporo fanamo Yasuaki someraka, “Nómo ní aporo hakāsa pura epare? Aporomo hemakapusimo nómo yakapa somesare?” Aíyaka Yasuaki kairakano ");
INSERT INTO faa_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yasumo someraka, “Aporo suamo kaiyisimo nōmo kakama somesapo. Yu aporomo sarimana apea soko, Kotimo apea soko, á Yu aporo pekea sarimarakano some kasapo. Tau mahamekea somesafapo. ");
INSERT INTO faa_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Marirakano nómo anoaki kairakanare? Nōmo some kasane kaisia aporoaki kaiyinie. Nōmo somesane ipu kaikia hemakapukua risikinapo. Iaki kaiyinie.” ");
INSERT INTO faa_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Airakano sikiriti aporo hakása metamo Yasu rusuapo. Ruraka someraka, “Nómo pirisiti aporo fanaki aíyaka somehokopo.” ");
INSERT INTO faa_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Airakano Yasumo someraka, “Nōmo watikiaka somerakano nómo kaisiane aporo suamo kaiyisimo somesie. Nōmo kakaro somerakano yia marirakano nómo ano rurakanare?” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Arirakano Yasu ipi hokonoa taposane yaiya rekeasimo yia, Anasemo sikiriti aporoaki someraka, “Aporoane pirisiti aporo fana Kaiafasemo hukurusimo karikia pusie.” Aíyaka Anasemo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Anasemo aíyaka somesa maiya yiamo Pita ira haraka rekeno aporo metakiramo eaki someraka, “Aporoamo aporo hakāsa pura pasimasane nére?” Airakano Pitamo kotafe someraka, “Anofapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Airakano pirisiti aporo fanamo aporo raipa ipi senaki Pitamo rukusakare tapisiamo ipi tákemo someraka, “Ne ira orofe hemoa aporoakiyaki kakeno nōmo asesane nere?” ");
INSERT INTO faa_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Airakano Pitamo waesapo. Waehoanine mena kokorokomo mesapo. ");
INSERT INTO faa_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Mituru fiarakano yia, Kaiafasemo apeane ipu metakarikia kamani aporo fanaraka reamo apea Yasuane karikia pusuapo. Karikia pukua aporoane Yu aporohoanafonosasamo, ipi apea Yu aporo yorosafapo. Ape Farimaresa Hemakapuko Hokono Keakosakipoko Yu aporomo hemakapuraka, “Yu aporohoanafonosayaki ape hakāsa sarimaraka toke, keseke hokono akera maiya amo makata neane siahoasifareapo.” Aíyaka hemakapuraka kamani aporomo apea yorosafapo. ");
INSERT INTO faa_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Yu aporo yorokoa peanafonorakano Pairate takahikia ipi apeane metakarikia aseako pusuapo. Pukua iaki someraka, “Aporoaki repo makata hukuarurane, makata yakapapoko hukururakanare?” ");
INSERT INTO faa_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Airakano ipu someraka, “Epo watikiaka rakianafonosa satiki né rea karikia peafunufapo.” ");
INSERT INTO faa_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Airakano Pairatemo someraka, “Repo namina somemane kakenapo. Asiamo repo namina yia eane hukurunie.” Airakano Yu aporomo someraka, “Re Rome kamanimo someraka, ‘Aporo rusua kukusane repo Yu aporomo menafapo. Isu Rome aporomo menapo.’ Aíyaka repo somesasamo repo eane ira paremareasimo karikia perakanapo.” Aíyaka Yu aporomo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ipu somehoasiraka fana Yasumo someraka, “Keseke ano ira matopesa paremarerakano rusua kukusapo.” Aisane yumo kakaro yanakanapo. ");
INSERT INTO faa_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Airakano Pairate ipi apea paripuraka Yasuaki peaesapo. E perakano Pairatemo someraka, “Yu aporomo unihaeane nere?” ");
INSERT INTO faa_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Airakano Yasumo someraka, “Nómo ní hemakapusua aeyaka, ‘Né unihaere?’ aíyaka kairakanare? Aporo metamo néaki somerakano nómo anoaki kairakanare?” ");
INSERT INTO faa_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Airakano Pairatemo someraka, “Ano Yu aporofapo. Nōmo né fanasihoasimo nómo ní aporo ira Yu aporomo soko, pirisiti aporo káramo soko, né karikia pesapo. Nómo watikiaka rakisiane, makata yakapa watikiaka rakisiare?” ");
INSERT INTO faa_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Airakano Yasumo someraka, “Hauaka wo aporoane nōmo unihaeaka asekea rekenafapo. Hauaka aporo ane nōmo asekea unihaeaka rea satiki ano waseremakohoamo, nōmo aporo hakāsa puramo Yu aporo sisimayaki weafunupo. Weakosapoko asiane hauaka wo ano unihaeaka rekeanafonosamo wesafapo.” ");
INSERT INTO faa_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Airakano Pairatemo someraka, “Unihaeane tiki nerakanareapo.” Airakano Yasumo someraka, “Ano unihaeane nómo someraka ayapo. Nómo somerakane anoane somerakae. Kakaro some kakako ano hauaka wo pesapo. Kakaro some takua risia aporo hinamoamo nōmo someane kakimarakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Airakano Pairatemo someraka, “Kakaro someane yakapare?” aisapo. Pairatemo ipi apeane metakarikia pukua, Yu aporo sisimaki someraka, “E fanasihokosapoko asiane epo watikiaka rakisiafapo. ");
INSERT INTO faa_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ape Farimaresa Hemakapuko Hokono Akera maiya suamo aporo tipura kesa hakása meta nōmo tonotaenapo. Tonotaenasamo nōmo tonotaehokosapo. Yumo repo Yu aporomo unihaeane tonotaehoare?” ");
INSERT INTO faa_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Airakano ipu sakepamo wáraka, “Wae. E tonotaehokopo. Parápase hákasa tonotaehoanie,” aisapo. Arirakano makata hakimokoakosakipoko aporo meta rurane Parápasepo. ");
INSERT INTO faa_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pairatemo Yasu karikia ipi apea pukua, ame aporoaki rusierakano sakomo rusuapo. ");
INSERT INTO faa_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Arirakano unihae káramo hati kotesa karotapirapo. Asiamo Rome ame aporomo Yasuane mainamareraka sako keta risia weroweroraka hahaeraka unihae káramo hati murikimaka rakisiane Yasu wamoa karotapikia maresapo. Arirakano unihaemo pasu susa kotesane Yasu osoraka marekea ");
INSERT INTO faa_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","mainamareraka someraka, “Yu aporomo unihaeane népo. Neane isiapo makararakanapo.” Aíyaka someaka eane ipu hokonomo rusuapo. ");
INSERT INTO faa_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Rurakano Pairatemo ipi apeane metakarikia, aporo sarimasaki someraka, “Repo asekeasimo efera hunia nōmo Yasuane karikia perakanapo. Eane fanasihokosapoko asīane epo watikiaka rakiafareapo.” ");
INSERT INTO faa_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Aihoane Yasu sako keta risiamo wamoa karotapikia marekea, unihaemo pasu susa osoraka marekea, ayiáka Pairatemo apeane metakarikia yao takua perakano, Pairatemo someraka, “E aperane asesie. Kára ayiáka mayiakako asiare?” ");
INSERT INTO faa_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Airakano pirisiti aporo káramo soko, sikiriti aporomo soko Yasu aseraka sakepamo wáraka, “Eane ira matopesa paremarekea maporasie. Eane ira matopesa paremarekea maporasie.” Airakano Pairatemo someraka, “Repo namina eane karikia pusie. Karikia pukua repo namina eane ira matopesa paremarekea maporasie. Epo watikiaka rakisiane nōmo hemakapurakarifapo.” ");
INSERT INTO faa_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Airakano Yu aporo sisimamo someraka, “Isiapo somemane motoraka, ‘Koti mawakasemaraka somera aporoane rusua kukunie.’ Aíyaka somemane motosasamo Yasumo someraka, ‘Ano Kotimo hokosapo,’ aisakipoko eane rusua kukunie.” ");
INSERT INTO faa_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Aíyaka somerakano Pairatemo kairaka, kára namoraka reapo. Yasumo ipi someraka, “Ano Kotimo hokosapo,” aisapakano Pairate namoraka reapo. ");
INSERT INTO faa_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Namoraka reke Yasu karikia ipi apea paripukua Yasuaki someraka, “Né hauaka maeyaka pesare?” Airakano Yasumo makata somerafaraka me kausapo. ");
INSERT INTO faa_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Me kaurakano Pairatemo someraka, “Nómo anoaki makata somerakarifapo. Marirakanonare? Ne rusua kukusane soko né tonotaehokosane soko nōmo ayiakakosapo. Ane nōmo maroponapo. Nómo hemakapurakarifare?” ");
INSERT INTO faa_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Airakano Yasumo someraka, “Nómo ayakakosane nómo ni hemakapusua aeyaka ayiakakosapo. Kotimo aorakano nómo ayiakakosapo. Nómo ano hukurukua fanasihoasimo aporomo ano karikia pesane ipu watikisane kakaro kárapo.” ");
INSERT INTO faa_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Airakano Pairatemo kaikia, Yasuane tonotaehoko hemakapusuapo. Tonotaehokosapo airakano, Yu aporo suamo wáraka, “Wae. Tonotaerakano Rome kamani unihae Sisamo né tákehokosafapo. Aporoamo someraka, ‘Ano unihaeaka rekenapo.’ Aisa aporoane Sisayaki yunuraka rekenapo. Asiamo aporoane nómo farimarakano Sisamo néaki yunuhokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Airakano Pairatemo kaikia Yasu karikia ipi apeane metakarikia, fanasihokosakipoko hukurura aporomo sea kayapo. Hukurura aporomo sea kaya ane, Yu aporo meaka yano motoraka Kapata yano motosapo. Namo meaka semenesepo, aíyaka yano motosapo. ");
INSERT INTO faa_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Arirakano Ape Farimaresa Hemakapuko Hokono Keakosane rau ayiakakosasamo pipu aporo hinamo suamo makata su maroponapo. Asiamo maropoana maiya amo maiya tuaro (12) koroko paurakano Pairatemo Yu aporoaki someraka, “Repo unihaeane épo.” ");
INSERT INTO faa_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Airakano ipu sakepamo wáraka, “E rusie. E rusie. Rukua ira matopesa paremaresie.” Airakano Pairatemo someraka, “Repo unihaeane ira matopesa paremaresie, aíyaka nōmo somehoasimore?” Airakano pirisiti aporo káramo someraka, “Isiapo unihae kárane kamani unihae Sisa ipi hákasapo.” ");
INSERT INTO faa_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Airakano Pairatemo someraka, “Yasu ira matopesa paremareako karikia pusie.” Airakano ipu Yasu karikia pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yasu karikia puraka ira matopesane Yasumo ipi maka pusuapo. Pukua uni kiki hauaka á pauraka risiapo. Hauaka ane Hipuru meaka yano motosa Kokóta hauakapo. ");
INSERT INTO faa_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hauaka á Yasu ira matopesa paremarekea maposapo. Maporaka aporomano rura aporo tetáne soko ira paremarekea, meta Yasu hokono tumuru takua maposapo. Meta Yasu hokono kasakai takua maposapo. Maporaka Yasuane tipia maposapo. ");
INSERT INTO faa_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Maporaka marekea Pairatemo makata popasapo. Popasane oyapo. “Yasuane Nasare aporopo. Yu aporomo unihaeane épo.” Aíyaka Pairatemo popasane ipi ame aporomo maka, Yasu unia kima yapura paremaresapo. ");
INSERT INTO faa_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yasu ira paremarekea maposane Yarusarame siti makeraka maposapo. Yarusarame siti makeraka paremaresasamo aporo hinamo yakaimo aseako peraka, popasane menosapo. Popasane Hipuru meaka soko, Rome aporo meaka soko, Kiriki aporo meaka soko me isiane su popasapo. ");
INSERT INTO faa_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Popasane Yu aporo pirisiti aporo káramo menoraka Pairateaki someraka, “Yu aporomo unihaeane épo, aíyaka popahokopo. Úyaka popahoanie. ‘Ipi yiamo someraka, “Yu aporomo unihaeane anopo,” aíyaka somerakasuane épo.’ Aíyaka popahoanie.” ");
INSERT INTO faa_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Airakano Pairatemo someraka, “Nōmo popasane siapo. Kosohokosafapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Yasu ira matopesa paremaresa yia rekeno, ame aporomo Yasumo pasuane mokoa parakuraka i kitafasuaki kasapo. Yasumo pasu horopokarane yaiya weroraka rakisia irihoanafonosa pasuane makosakipoko ");
INSERT INTO faa_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ame aporomo someraka, “Pasuane koahoane siahoasifareapo. Asiamo pasuane aporo hakásamo mako, isiapo kaseraka enana ayiáka makata fete mokoasuraka napane asekea enahokosapo,” aisapo. Arirakano fana Kotimo sawia poparaka ayiakakosaposane aina ayapo. Fana popasane oyapo. “Nōmo pasuane mokoako aporomo parakuhokosapo. Arirakano nōmo pasu kara meta aporomo mako kaseraka enana ayiáka enahokosapo.” Aíyaka popasane kakaro aina ayapo. ");
INSERT INTO faa_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Arirakano Yasu ira matopesa maposane makeraka ipi kaīyia soko, ipi aeya soko, Koropasemo hinamo Mariane soko, Makatara hinamo Mariane soko, i su pekea asekea risiapo. ");
INSERT INTO faa_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Asekea risikino Yasumo ipi kaīyia soko, ipi aporo hakāsa pura hakása metane Yasumo himu tumurumo hemakapukua rea aporoane soko aseraka ipi amaki Yasumo someraka, “Hinamo neo, nómo ní hokosa hemaka apura ayiáka, aporoane nómo hemakapunie.” ");
INSERT INTO faa_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Aíyaka ipi aporo hakása puraki Yasumo someraka, “Nómo ní ama asekea area ayiáka, nōmo amane nómo asekea rekeanie.” Aíyaka Yasu kusua maiyamo aporo hakása puramo Yasumo kaīyiane ipi apea karikia pukua asekea reapo. ");
INSERT INTO faa_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Arirakano Yasumo makata rakirane fasapo, aiyaka hemakapusuasamo Yasumo ipi someraka, “Ano he nariripo.” Aíyaka Kotimo sawia popasa yine aina ayapo. ");
INSERT INTO faa_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Asiamo merakia waene he kisa takamasane he watera asia waene hea kokomarekea, ira turua taporomarekea Yasumo akai kiria motosapo. ");
INSERT INTO faa_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Motorakano Yasumo sareraka someraka, “Yiyapo.” Aíyaka Yasu ipi kukuko makehoramo wamo arupekea hemakapuraka, “Ano ho puane siahoasireapo.” Aíyaka hemakapukua kusuapo. ");
INSERT INTO faa_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Yu aporo sisimamo Pairateaki someraka, “Ira matopesa paremurisiane fatari mokoakosakipoko aporoane korake rukumosorasiehoanie. Arirakano Ape Farimaresa Hemakapuko Hokono Keakosakipoko pipu makata nakosa sarimarakanapo. Asiamo rau fenena maiyamo aporo ira matopesa paremurisiane yia risiane siahoasifareapo.” Aíyaka aporoamo hemakapuraka Pairateaki somesapo. ");
INSERT INTO faa_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Aíyaka somerakano Pairatemo someraka, “Aporoane foaka kukusimo korakeane rukumosorasie,” aisapo. Airakano ame aporo pukua aporo takua paremaresane korake rukumosoraka, arirakano takua paremaresane soko korake rukumosoraka, ");
INSERT INTO faa_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","arirakano Yasuane korake rukumosorako aseane Yasu kakaro kusikeno asekea, ipi korakeane rukumososafapo. ");
INSERT INTO faa_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ame aporo hakása metamo ferepemo Yasu ketayia karesapo. Kareane yapi soko he soko pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Purakano aporomo asesapo. Asesa aporoamo sawi one popasapo. Epo asesasamo kakaro someaka popasapo. Repo kakimakasimo epo popasapo. ");
INSERT INTO faa_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","37","Arirakano fana Kotimo sawia popasane oyapo. “E kiki suane hakása meta soko rukumosohokosafapo.” Aíyaka popasapo. Arirakano makata meta soko poparaka, “E ketayia karesane aporomo aseakosapo.” Aíyaka ayiakakosapo, aíyaka popasane yasiapo. ");
INSERT INTO faa_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Arirakano Arimatía aporo yano motosa Yosefemo Yasu kukusiraka rea maiya amo, e Yasu patera asesapo. Yu aporomo aserapaka namoraka tau Yasu patera asesapo. Yosefe pukua Pairateaki someraka, “Yasu kusuane kunikia nōmo motoaere?” Airakano Pairatemo aosapo. Aorakano Yosefe pukua Yasu kusuane fatarimaka pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Arirakano Nikitímase fana ereamo Yasu aseako pusuane Yosefeyaki pukua, pauta wape yamona, meta yano motosa mua, meta yano motosa arose, tetapō mokoa pusuapo. Pauta sakepamo mokoa pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Aporo tetá amo Yasu kusuane maka, pauta wape yamosane kaua soaeraka, pasumo taporaka, Yu aporomo aporo kusua kunikia motoakosakipoko tapona ayiáka taposapo. ");
INSERT INTO faa_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Arirakano ira matopesa maposane makeraka orofe hemo reapo. Hemo á kunikia reapo. Kunikia á fana aporo kusua motosafapo. ");
INSERT INTO faa_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yu aporomo yape fenena maiya makeraka taki awara maiyamo, kunikia makeraka reakipoko Yasu kusuane motosapo. ");
INSERT INTO faa_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Yatipinumo mituru fiahoko makehoramo Makatara hinamo Mariane pukua, Yasu kunikia motosa aseako pusuapo. Pukua aseane, eke tafeamo kunikia mapirisiane ropakataesekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Aseane Yasu fasekeno aseraka foaka parihikia, Saemone Pitape Yasumo ipi aporo hakāsa pura hakása metane Yasumo himu tumurumo hemakapusua aporoane soko, Mariamo tetāki someraka, “Unihae kusua kunikia motosane, aporo metakiramo maka pusesapo. Ma maka pusuarakapo.” ");
INSERT INTO faa_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Airakano tetā kunikia aseako foaka pukua, ");
INSERT INTO faa_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","aporo hakāsa pura metamo Pitane marokeraka fana foaka pukua kunikia pausapo. ");
INSERT INTO faa_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Kunikia yao taku aeyaka reke, weaka aseane, Yasu kusua pasumo taposane pasu hákasa yia wareke, Yasu fasekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Arirakano Pita kesekea foaka pesa nine kunikia kakarua aseako forosoraka pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Forosoraka pukua aseane pasumo e taposane yia wareke, arirakano pasu metamo wamoa taposane soko yia warekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Arirakano aporo hakāsa pura meta fana pesane soko kunikia forosoraka pukua, pasuane aseraka ipi hemakapuraka, “Yasu kakaro turikia pureapo,” aiyáka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Arirakano Kotimo sawia poparaka, “E kusuane turikia pukusapo.” Aisane fana tetapō koteaka hemakapusuafapo. Asekeasiraka hemakapusuafapo. ");
INSERT INTO faa_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Yasu kunikia motosane fasekeno tetā apea poparihisiapo. ");
INSERT INTO faa_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kunikia yao takua Maria hiripuraka reke weaka aseane, ");
INSERT INTO faa_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","hepene aporo tetá pasu pakae ososa Yasu kusua motosa á, meta korake sapea, arirakano meta wamo sapea ayiáka tokeno asesapo. ");
INSERT INTO faa_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Aserakano tetapō someraka, “Hinamo neo, marirakano hiripurakanare?” Airakano Mariamo someraka, “Unihae kunikia motosane ipu maka pusesapo. Ma maka pusuarakapo.” ");
INSERT INTO faa_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Aíyaka someaka faraka, ipi patera pariaseane Yasu rekeno asesapo. Aseraka, “Yasureapo,” aíyaka hemakapusuafapo. ");
INSERT INTO faa_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Asekea hemakapunafonorakano Yasumo someraka, “Marirakano hiripurakanare? Epa kope perakanare?” Airakano hinamoamo hemakapuraka, “Hemo wafayareapo,” aíyaka hemakapukua someraka, “Nómo e maka pukua ma motosare? Maka pukua motosane anoaki somesie. Nōmo e mako pukusakipoko anoaki tarisie.” ");
INSERT INTO faa_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Airakano Yasumo someraka, “Maria.” Airakano Yasumo meane hinamoamo kairaka rekeako pariraka aseane Yasu rekeno asesapo. Aseraka, “Tisao,” aisapo. Aíyaka somerakane Yu aporomo Hipuru meaka Raponai airapo. ");
INSERT INTO faa_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Airakano Yasumo someraka, “Ano kaua sakiraka maka rekeakopo. Ata rea hauaka ano hianafonosasamo, nómo ano maka rekeakopo. Nōmo aporo hakāsa pura, nōmo nī mae asiaki úyaka somehoanie. ‘Ata rea ano parihiakosapo. Nōmo Atane soko repo Atane soko hakása yiyapo. Nōmo Kotiane soko repo Kotiane soko hakása yiyapo. E rea ano parihiakosapo.’ Aíyaka iaki somehoanie.” ");
INSERT INTO faa_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Airakano Maria parihikia aporo hakāsa puraki someraka, “Yasuane nōmo asesapo.” Aíyaka Yasumo someaka maresane soko iaki some kasapo. ");
INSERT INTO faa_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sere hakása niné yatipinumo ereamo, Yasumo ipi aporo hakāsa puramo Yu aporo sisima perapaka namoraka ikia koro mapirikia toapo. Toakipoko ape á Yasu pekea iaki someraka, “Mapiraraka risikianie.” ");
INSERT INTO faa_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aíyaka ipi hokono tetá ikokosa umuruane tarikia, arirakano ipi ketayia karesa umuruane tarirakano ipi aporo hakāsa puramo aseraka Unihaereapo, aíyaka hemakapukua sesesapo. ");
INSERT INTO faa_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Seserakano Yasumo efera hunia someraka, “Seseraka auaraka risikianie. Atamo ano pusiesa ayiáka, nōmo reane pusie airakanapo.” ");
INSERT INTO faa_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Aíyaka Yasumo himu haraka i toakipoko akai fofoane makama asapo. Makama araka Yasumo someraka, “Ho Kotesane re himua rekeasimo masie. ");
INSERT INTO faa_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Aporomo watikiaka rakisia himu ra kayane hufitaerakano watikisane repo someraka, ‘Watikisane farakanapo.’ Airakano watikisane kakaro fanapo. Repo someraka, ‘Watikisane fasafapo.’ Airakano watikisane fanafapo.” Aíyaka Yasumo someaka faraka Yasu ipi yia reanine fasekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Aporo hakāsa pura keno suane meta Tomase, ipi yano motosa meta Titimase, e iyaki hakāsa tokoanafonosasamo Yasuane asesafapo. ");
INSERT INTO faa_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","I toakipoko Tomase perakano ipu someraka, “Yasuane isiapo asesapo.” Airakano Tomasemo someraka, “Someane nōmo kakimakosafapo. Yasu hokono umuruane nōmo sakairaka ipi, ketayia umuruane sakairaka, nōmo himu hakásaraka hemakapukusapo,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Arirakano soko hakása faraka, sere karimo i efera hunia sarimaraka apea toapo. Maiya amo Tomase soko iyaki hakāsa toapo. Ikia koro mapirikia toakipoko Yasu pekea iaki someraka, “Seseraka auaraka risikianie.” ");
INSERT INTO faa_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Aíyaka Yasumo Tomaseaki someraka, “Nómo ano hokono asesie. Hokono umuruane sakairasie. Ketayia umuruane sakairasie. Himu tetáraka hemakapusuane metakarikia, himu hakásaraka hemakapukua rekeanie.” ");
INSERT INTO faa_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Airakano Tomasemo someraka, “Nōmo Unihaeo. Nōmo Kotio.” ");
INSERT INTO faa_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Airakano Yasumo someraka, “Nómo ano asesasamo himu hakásaraka hemakapukua rekenapo. Arirakano aporo hinamo metakiramo ano asekeanafonosa aporo hinamoamo anoaki himu hakásaraka hemakapukua risike, i kakaro seseraka risikiakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Maiya metamo aporo hakāsa puramo asekeasimo Yasumo makata wakapuaka rakira metakirane soko rakisiapo. Rakirakano aporo hakāsa puramo asesapo. Makata rakisia metakirane sawi wo popasafapo. ");
INSERT INTO faa_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Arirakano Kotimo unihaeaka rekeasimo murikimasa aporoane épo. Yasu ipiane Keresopo. E Kotimo hokosapo. Aíyaka repo kakimakasimo sawi one popasapo. “Yasu ipi Keresopo. Ipi Kotimo hokosapo.” Aíyaka repo hemakapukua kakimaka, Yasu yano motosane makama fanaraka hemakapurakano re yaiya risikiakosapo. ");
INSERT INTO faa_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Aporo hakāsa puramo efera hunia asekeasimo Yasu he Taipiriase fua pesane oyapo. ");
INSERT INTO faa_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saemone Pita soko, Tomase ipi yano motosa meta Titimaseane soko, Natanio ipi Kariri hauaka Kena taone aeyaka pesane soko, Sepetemo hokosa tetāne soko, Yasumo aporo hakāsa pura tetá metane soko, i su he fua risiapo. ");
INSERT INTO faa_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Risike Saemone Pitamo iaki someraka, “Pokoa mokoako purakapo.” Airakano ipu someraka, “Neyaki isu perakanapo,” aisapo. Aíyaka i kasua ripaka, rokoa hikia he numua kasipu makasuraka, kiraka mayane kasipua pokoa kesafapo. Ere hakása yiamo airaka risike, pokoa hakása soko masafapo. ");
INSERT INTO faa_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","5","Mituru fiarakano maíya kawe aperamo, Yasu he fua pekea reke someraka, “Hameo, pokoa kasipua kesare?” Airakano ipu Yasureapo, aíyaka hemakapunafonoraka ipu someraka, “Wae, kesafapo.” ");
INSERT INTO faa_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Airakano Yasumo someraka, “Hokono tumuru takua kasipu makasuhoane pokoa keakosapo.” Airakano ipu hokono tumuru taku aeyaka kasipuane makasuraka, kihoane pokoa kára kesamo umirakano kihoasifareapo. ");
INSERT INTO faa_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kihoasifasekeno aporo hakāsa pura hakása meta Yasumo himu tumurumo hemakapusua aporoamo Pitaki someraka, “Isiapo Unihaereapo.” Airakano Saemone Pitamo pasu horomasane maka, osoraka hea makasuraka he tapukua pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Purakano aporo hakāsa pura metakiramo kasipu kiraka mokoa risike, kasu rokoa he fe makesakipoko wane harote mita (100) rokoa pusuapo. ");
INSERT INTO faa_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Rokoa pukua he fea karimarekea, kita humarekea, kasu yia metakarikia peraka aseane Yasumo ira paikia rufirakano pokoa paikia, farawayaki taesekeno asesapo. ");
INSERT INTO faa_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Aserakano Yasumo someraka, “Pokoa kasipua kawe kesane metakira mokoa peae.” ");
INSERT INTO faa_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Airakano Saemone Pita paripukua, kasipuane waseremaka he fea kirape hisiapo. Kasipua pokoa popake kesane menoraka wane harote fifiti tiri (153) ayiáka kesekeno menosapo. Pokoa kára kesa nine kasipu potakahesafapo. ");
INSERT INTO faa_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Arirakano Yasumo someraka, “Makata nako peae.” Airakano ipu “Ne epare?” aisafapo. “Unihaereapo,” aíyaka hemakapusuapo. ");
INSERT INTO faa_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Hemakapurakano Yasumo farawa taesane mokoa, pokoayaki kasapo. ");
INSERT INTO faa_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Kasá sereamo Yasuane ipi aporo hakāsa puramo asekeasimo, yape tetá fana tarisiakipoko, yape isiane sereamo tarisia ayapo. ");
INSERT INTO faa_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Makata nekea farakano Yasumo Saemone Pitaki someraka, “Yonemo hokosa Saemoneo. Nómo pokoa morane himu tumurumo hemakapurakanapo. Anoaki nómo himu tumurumo fanaraka hemakapurakanare?” Airakano Pitamo someraka, “Unihaeo, nōmo né himu tumurumo hemakapusuane nómo ní hemaka apure.” Airakano Yasumo someraka, “Nōmo saro sipi manoane nómo makata nakosa kakanie.” ");
INSERT INTO faa_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Aíyaka efera hunia yape tetámo Yasumo someraka, “Yonemo hokosa Saemoneo. Nómo ano himu tumurumo hemakapurakanare?” Airakano Pitamo someraka, “Unihaeo, ao, nōmo né himu tumurumo hemakapusuane nómo ní hemaka apure.” Airakano Yasumo someraka, “Nōmo saro sipiane koteaka asekea rekeanie.” ");
INSERT INTO faa_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Aíyaka efera hunia yape isiamo Yasumo someraka, “Yonemo hokosa Saemoneo, nómo ano himu tumurumo hemakapurakanare?” Aíyaka Yasumo yape isiamo somerakano asekea Pita ipi sesenafaraka someraka, “Unihaeo. Makata su nómo hemakapurapo. Nōmo né himu tumurumo hemakapusuane nómo ní hemaka apure.” Airakano Yasumo someraka, “Nōmo saro sipiane makata nakosa kakanie. ");
INSERT INTO faa_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Nōmo kakaro somerakaripo. Né hokosa raua rea maiya amo, pasu kenare weraka terakae hikia, ni hemakapusua aeyaka pusuapo. Arirakano né sisimana maiya amo né hokono máfarakano aporo metamo neane taporaka, kiraka maka pukusapo. Kiraka maka purakano né hisihokosapo.” ");
INSERT INTO faa_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Aíyaka Yasumo takumeaka some kasapo. Pita ipi ira matopesa paremarerakano kukusane takumeaka some kasapo. Pita ira matopesa paremarekea kurakano, aporo hinamomo asekea Kotiane makarahokosapo. Asiamo Yasumo Pitaki someraka, “Ano patera asesie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pitamo patera pariaseane aporo hakāsa pura Yasumo himu tumurumo hemakapusua aporoane kekemarape perakano asesapo. Yasu kukusiraka ipu makata nenaka toa maiya amo, aporo hakāsa pura meta uaka hikia Yasuaki someraka, “Unihaeo, epamo né parakehokosare?” Aíyaka somesa aporoane Pitamo asesapo. ");
INSERT INTO faa_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Asekea Pitamo Yasuaki someraka, “Unihaeo, aporoane mayiakakosare?” ");
INSERT INTO faa_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Airakano Yasumo someraka, “E ayiakakosane nómo somehoane siahoasifareapo. Ano hikia pariaperamo ipi yia rekeno soko metao, ipi rekeanafonorakano soko metao, nómenafapo. Né ano patera asesie.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Aíyaka somerakano aporo hakāsa pura metamo metaki some, arirakano metamo metaki some, arirakano metamo metaki some aíyaka namina yia somepe pukua tipia Yasumo somesane metakarikia, “Aporoane kukusafapo.” Aíyaka some koaka marekea namina somepe pusuapo. Asiāne Yasumo someraka, “E kukusafapo,” aisafapo. “Ano pariapera maiya amo aporoane yia reke soko metao, rekeanafonoraka soko metao, nómenafapo,” aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Yasumo somesane ano Yonemo kaisiapo. Arirakano Yasumo rakisiane soko nōmo aseraka sawi one popasapo. Popasane isiapo menoraka hemakapuraka, “Makata su popasane kakarohoareapo,” aíyaka isiapo hemakapurakanapo. ");
INSERT INTO faa_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Arirakano Yasumo makata metakira soko rakisiapo. Makata su epo rakisiane aporomo popasafapo. Yasumo makata rakisiane hakása hakásaraka popasatiki sawi mukihoafunupo. Mukiraka hauaka wo sawi taesane siahoafunufapo. ");
INSERT INTO faa_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Fana Tiaforase néaki nōmo sawi meta popasapo. Popasane Yasu hauaka wo reke ipi makata rakiraka reane soko, some karaka reane soko, keseke e rusua kusuane Kotimo maturikia taeraka hepene yapunaka pasimarakano hisiane soko, makata su nōmo neaki poparaka makesapo. ");
INSERT INTO faa_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Arirakano Yasuane hepene yapura Kotimo pasimakasiraka Yasu hauaka wo rea maiya amo tarira aporoaki someaka maresapo. Someaka maresane ipu makata rakiakosane Ho Kotesamo someaka marerakano tarira aporoaki somesapo. Arirakano tarira aporoane fana Yasumo aporo hakāsa pura murikimasa ayapo. ");
INSERT INTO faa_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Arirakano Yasu kusuane Kotimo maturikia taerakano turikia pukua sere foti amo (40) tarira aporomo e asekeasimo e pekea pukua efera hunia soko pekea pukua ayiáka yape yakai iaki e kakaro maturikia taesane tariako pesapo. Ipu hemakapuraka, “Yasu maturikia taesane turikia pukua rekenarakapo.” Aíyaka hemakapurapaka i risiakipoko tariako peraka, Kotimo unihaeaka asekea reane iaki somesapo. ");
INSERT INTO faa_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Iyaki hakasa sarimaraka rea maiya amo epo someraka, “Yarusarame sitiane metakarikia pukupo. Atamo makata kakakosaposane mokoako Yarusarame siti yia kau tokoanie. Makata kakakosaposane nōmo reaki somesapo. ");
INSERT INTO faa_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yonemo ré hea hákasa tapukumurisiapo. Arirakano maiya wakasema risina Ho Kotesa re himua muriakosapo.” Aíyaka Yasumo somesapo. ");
INSERT INTO faa_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Tarira aporo suane sarimaraka risike ipu Yasuaki someraka, “Unihaeo, fana isiapo isina Yu aporomo unihaeaka asekea risia ayiáka, maiya yumo Isiraya hauaka ane isiapo isina unihaeaka asekea risikiasimo nómo mareakosare?” ");
INSERT INTO faa_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Airakano Yasumo iaki someraka, “Ayiakakosa maiyane nōmo Atamo hákasa hemakapukua marerapo. Marerane repo hemakapurafapo. Ayiakakosa maiya ane repomenafapo. ");
INSERT INTO faa_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Arirakano Ho Kotesane re himua murirakano maiya amo epo wakapuane repo mokoakosapo. Epo wakapuane repo mokoa risike, anoane repo some kakakosapo. Nōmo some kasane soko, repo some kakakosapo. Yarusarame sitia soko, Yutía hauaka á soko, Sameria hauaka á soko, hauaka sua repo ano asesane some kape pukusapo.” ");
INSERT INTO faa_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Aíyaka someaka farakano, ipu aseane Yasu hepene yapura hinakano asesapo. Asekea risiakipoko Yasuane akomo matairaka maka hinakano asekea fasisiapo. ");
INSERT INTO faa_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yasu hinakano aporomo ti yapura asekea risiakipoko, hepene aporo tetá pasu pakaesa osoraka wate foaka pekea ");
INSERT INTO faa_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","iaki someraka, “Kariri aporo reo, repo marirakano ti yapura asekea risikinare? Yasuane Kotimo pasimarakano hinakasa ayiáka, keseke soko yaiya paripeakosapo. E hinakano repo aserakasa ayiáka Yasu efera hunia paripeakosapo,” aíyaka hepene aporomo somesapo. ");
INSERT INTO faa_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Tarira aporo i ūri Orofeane metakarikia Yarusarame sitia poparipusuapo. Arirakano Yarusarame siti aeyaka ūri Orofe ane make tamiyiyapo. ");
INSERT INTO faa_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Arirakano i Yarusarame sitia pauraka huturu apea i risira á hisiapo. Aporo apea poparipusua susuane yano taesane oyapo. Pita soko, Yone soko, Yamese soko, Enitu soko, Firipi soko, Tomase soko, Patóromiu soko, Matiu soko, Afiasemo maeya Yamese soko, kamaniaki patera asesa aporo Saemone soko, Yamesemo maeya Yutase soko, i su á sarimaraka toapo. ");
INSERT INTO faa_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Namina su sarimaraka himu hakásaraka hemakapukua Kotiaki kurikurisapo. Ipu kurikuriraka toa a hinamo metakira soko, Yasumo kaīyia Maria soko, Yasumo mamanea soko, iyaki hakāsa sarimaraka toke kurikurisapo. ");
INSERT INTO faa_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Maiya amo Keresoa paosa aporo hinamo sarimasane wane harote tuaneti su (120) sarimasapo. Sarimarakano Pita takahikia iaki someraka ");
INSERT INTO faa_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Maeo, Yutasemo Yasu parakehokosane, wate fana Ho Kotesamo Tefeteaki some karakano, Tefetemo popahoareapo. Kakaro ayiakakosapo aíyaka popasane faserepesa ayareapo. Yutasemo aporo metakira pasimokoa e fanaraka pukua, Yasu parakeraka, ipu Yasu waseremasapo. ");
INSERT INTO faa_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Arirakano fana isiapo Yasumo makata rakirane rakisimo, Yasumo isu soko murikimaka, Yutase soko murikimasapo. ");
INSERT INTO faa_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Murikimasa nine Yutasemo mone maraka Yasuane parakesapo. Wakasema nina, é kuraka hauaka harepa ikia huruperaka fako fausapo. Faurakano asekea, hauaka á Yutasemo ipi mone mosa amo hauaka ane roposapo. ");
INSERT INTO faa_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Fako fausaporakano Yarusarame aporo suamo kaikia, hauaka roposane Yu aporo meaka yano motoraka Akeramapo. Namo meaka yano motoraka Yapi Pusua hauakapo. ");
INSERT INTO faa_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Asiamo wate fana Kotimo sawia Tefetemo popasane oyapo. ‘Aporomo ipi apeane kauanehokosapo. Ipi apea aporo metakira risikiakosafapo,’ aíyaka popahoareapo. Maiya metamo Tefetemo poparaka, ‘Ipi rakirane aporo metamo rakiakosapo,’ aíyaka popasane Yutasemo ayiakakosane Tefetemo popahoareapo. ");
INSERT INTO faa_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Aíyaka popasasamo aporo metamo isuyaki hakāsa rakisimo isiapo murikimakosapo. Aporo murikimakosane oyapo. Yasu isuyaki koraka rea maiya amo, aporo meta isuyaki hakāsa pusuane e murikimakosapo. ");
INSERT INTO faa_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Arirakano Yonemo kepo marekea aporo hinamo hea tapukumurisia maiya amo, nina, Yasu kusua maturikia taerakano, turikia pukua hepene yapura hinakano, asesa aporo isuyaki hakāsa pusua aporoane isiapo murikimakosapo. Yasu kusuane maturikia taerakano turikia pusuane asesa aporoamo isina hakāsa somehokosakipoko murikimakosapo.” ");
INSERT INTO faa_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Aíyaka Pitamo somerakano aporo tetá nenakamaka murikimaraka, meta yano motosa Yosefe Pásapase, ipi aporo ira yano motosane Yásatase eane murikimaka, arirakano aporo meta yano motosa Matiase ipu murikimasapo. ");
INSERT INTO faa_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Murikimaka faraka ipu kurikuriraka, “Unihaeo, aporo tetá one isiapo nenakamaka murikimasapo. Murikimarakano tetapō himuane nómo aserapo. Aporo tetá yano motosa popasane, hakása meta nómo murikimaka isuaki tarinie. ");
INSERT INTO faa_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Yutasemo tarira aporomo rakirane metakarikia, watikiaka rakisiakipoko watikisamo ropo mara hauaka á pusuapo. Tarira aporomo rakirane epo metakarisiane, aporo metamo rakisimo nómo murikimaka isuaki tarinie,” aisapo. ");
INSERT INTO faa_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Airakano aporo Kotimo murikimasane asekea hemakapuko, aporo tetá yano motosane poparaka petoro kakarua makekea, mahohoraka sawi hakása huruperakano aseane, Matiase yano motosa huruperakano aseraka Matiaseane ipu pasimasapo. Tarira aporoane kinusu risiakipoko kenoane Matiase paoraka sarimaraka, tarira aporoane keno su risiapo. ");
INSERT INTO faa_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Yasu hisiakipoko Penekose hokono kesapo. Hokono akeramo kakimara aporo su ape hakása sarimaraka toapo. ");
INSERT INTO faa_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Toakipoko wate foaka ti yapunaka makata kára urakano kaikia toakipoko, atifo kára apera ayiáka peraka, i toa ape kakarua pesapo. ");
INSERT INTO faa_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Perakano ipu namina yia aseane, ira rufi asia i namina su wamoa hakása hakásaraka kataka risikino asesapo. ");
INSERT INTO faa_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Aseane, Ho Kotesa pekea i namina su himua káraraka komarukua risike, Ho Kotesamo i himua me meta somerakarakano ipu me kekepo kekepoaka somesapo. ");
INSERT INTO faa_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Arirakano Yu aporo metakiramo Kotiaki kekerehoko hemakapusua aporoane, hauaka su anaka kimisi pekea Yarusarame sitia risiapo. ");
INSERT INTO faa_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Risike kaiyiáne makata kára uaka perakarakano, aporo yakaimo aseako peraka kaiyiáne, aporo sarimasamo me kekepo somerakano ipu kaikia someraka, “Mairakarirakapo.” Aíyaka hauaka su anaka aporo pesamo kaiyiáne aporo sarimasamo ipu me kekepoane somerakano kaisiapo. ");
INSERT INTO faa_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kaikia fofaraka aporo kimisi pesamo someraka, “Ane mairakarirakapo. Aporoamo me kekepo somerakane iane Kariri aporosamo Kariri meaka somehoafunureapo. ");
INSERT INTO faa_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Isiapo me kekepoane ipu somerakano kairakaripo. Mairakariakapo. ");
INSERT INTO faa_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Isu aporo sarimasane Patía hauaka aeyaka soko, Mítia hauaka aeyaka soko, Írame hauaka aeyaka soko, Mesopotémea hauaka aeyaka soko, Yutía hauaka aeyaka soko, Kapatósia hauaka aeyaka soko, Pónetase hauaka aeyaka soko, Ésea hauaka aeyaka soko, ");
INSERT INTO faa_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firísia hauaka aeyaka soko, Pamefíria hauaka aeyaka soko, Iyipi hauaka aeyaka soko, Sairíni taone makeraka Rípia hauaka aeyaka soko, Rome siti aeyaka soko, Yarusarame siti wo kimisi pesapo. ");
INSERT INTO faa_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Isu aporo kimisi pesane metakira Yu aporo soko, metakira Yu aporohoanafonosamo Yu aporo sisimamo somemane kakimasane soko, isu metakira Kiríti hauaka aeyaka soko, Arépea hauaka aeyaka soko, isu hauaka su aeyaka, isiapo isina hauakane metakarikia pekea, Yarusarame siti wo risikinapo. Asiane isiapo me kekepoane ipu somerakae. Kotimo wakapumo hemakapukua rakiraka, isiapo me kekepoaka somerane ipu kaiyanafononane, ipu me kekepo kekepoaka somerakae.” ");
INSERT INTO faa_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Airakano aporo suamo himu faraka mahimeteraka ipu namina yiamo someraka, “Makata hakuane mairakarirakapo.” ");
INSERT INTO faa_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Airakano aporo metakiramo mainamareraka someraka, “Ipu namina waene he kawe metekesane nareapo. Nesasamo himu maparitaeraka me kekepoaka somerakae.” Aisapo. ");
INSERT INTO faa_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita soko tarira aporo kinu suane soko takahikia aporo yakai pesaki paroaka someraka, “Yu aporo soko, arirakano Yarusarame sitia kimisi pekea risia aporo repo soko, nōmo some one kaisie. ");
INSERT INTO faa_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Repo someraka, ‘Aporoamo waene he kawe metekesane nekea himu maparitaerareapo,’ airakae. Ane repo hasaka hemakapukua somerakae. Yumo mituru maiya tokonamo aporo himu maparitaenafapo. Aporo reo, some one kaisie. ");
INSERT INTO faa_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Pipu mituru repo kairakasane wate fana porofete aporo Yoremo popasane pipu fasere apera oyareapo. Yoremo popasane oyapo. ");
INSERT INTO faa_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kotimo someraka, ‘Maiya fahoko makeanamo nōmo uyáka rakiakosapo. Aporo suaki nōmo Ho Kotesa muriakosapo. Murirakano repo aporo hokosamo soko, hinamo hokosamo soko, porofete aporomo some akara ayiáka, nōmo someane kaikia, ayiáka some kakakosapo. Repo hokosa rauamo soko, aporo sisimamo soko, kituamo asera ayiáka aseakosapo. ");
INSERT INTO faa_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Arirakano maiya amo nōmo aporo raipaki soko, arirakano hinamo raipaki soko, Ho Kotesa muriakosapo. Murirakano porofete aporomo some akara ayiáka, ipu nōmo someane kaikia, ayiáka some kakakosapo. ");
INSERT INTO faa_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Arirakano aporomo asekea fofahoasimo, ti yapura makata wakapu kára nōmo rakiakosapo. Hauaka wo soko aporomo asekeasimo nōmo makata wakapu meta soko rakiakosapo. Yapi soko, ira rufi soko, ira musu kára soko, nōmo muriakosapo. ");
INSERT INTO faa_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Arirakano Unihae Yasu paripeakosakipoko, fana sere maiya ane katorakosapo. Ere maiyamo faeane yapi asia susu faehokosapo. Fahoko makeana maiya amo ayiakakosapo. Unihae pariapera maiya amo epo wakapuane soko, faesane soko repo aseakosapo. ");
INSERT INTO faa_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Asiamo aporo metamo Unihaeaki ararehoasimo kurikurirakano aporoane Unihaemo mafasiakosapo.’ Aíyaka Kotimo somerakano Yoremo popahoareapo. ");
INSERT INTO faa_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Arirakano Isiraya aporo repo suamo kaisie. Nasare aporo Yasuane nōmo somerakanapo. Repo hemakapusimo e hauaka wo Kotimo pusiesapo. Kotimo wakapumo hemakapukua rakirane aporomo aseraka, ‘Kotimo rakira ayareapo,’ aihoasimo Yasu pekea rakisiapo. Re risiakipoko epo pekea rakirakano, repo asesasamo repo hemakapurakanapo. ");
INSERT INTO faa_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Arirakano wate fana Yasuane ayiakakosane Kotimo ipi hemakapukua reapo. Hemakapukua reasamo Yasuane reaki karakano repo e rusua kusuapo. Aporo watikisamo e ira matopesa paremarerakano repo soko aosapo. Repo aosasamo repo namina yiamo eane rusua kusuapo. ");
INSERT INTO faa_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Rusua kurakano Yasuane Kotimo maturikia taesapo. Kura namonane Kotimo mafaraka Yasuane maturikia taesapo. Yasu kakaro kuane siahoasifasekeno Kotimo Yasuane maturikia taesapo. ");
INSERT INTO faa_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Arirakano Yasuane Tefetemo popasane oyapo. Tefetemo someraka, ‘Nōmo hemakapuraka maiya suamo Unihae Kotiane anoyaki rekenapo. Eane ano makeraka reasasamo ano namorakanafapo. ");
INSERT INTO faa_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Asiamo nōmo himumo seseraka mapiraraka somerakanapo. An