﻿USE sofia;
DROP TABLE IF EXISTS sofia.ewe_vpl;
CREATE TABLE ewe_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ewe_vpl WRITE;
INSERT INTO ewe_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Le gɔmedzedzea me la, Mawu wɔ dziƒo kple anyigba. ");
INSERT INTO ewe_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Anyigba nɔ nyamaa, nɔnɔme aɖeke meli nɛ o. Ele ƒuƒlu, eye viviti do ɖe tsi gbana la dzi, eye Mawu ƒe Gbɔgbɔ nɔ agba sam le tsia dzi. ");
INSERT INTO ewe_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Mawu gblɔ be, “Kekeli nedo.” Eye kekeli do. ");
INSERT INTO ewe_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mawu kpɔ be kekeli la nyo, eye wòma kekeli la tso viviti la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mawu yɔ kekeli la be “ŋkeke,” eye wòyɔ viviti la be “zã.” Ale zã do, eye ŋu ke. Esiae nye ŋkeke gbãtɔ. ");
INSERT INTO ewe_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Mawu gblɔ be, “Lilikpo nedo, eye wòama tsi si le lilikpo la te kple esi le lilikpo la tame la me. Eye wòva eme nenema.” ");
INSERT INTO ewe_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ale Mawu wɔ lilikpo, eye wòma tsi si le lilikpo la te la ɖa tso esi le lilikpo la tame la gbɔ, eye wòva eme. ");
INSERT INTO ewe_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mawu yɔ lilikpo la be “dziƒo.” Zã do, eye ŋu ke. Esiae nye ŋkeke evelia. ");
INSERT INTO ewe_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mawu gblɔ be, “Mina tsi si le lilikpo la te la naƒo ƒu ɖe teƒe ɖeka be anyigba ƒe ƒuƒuiƒe nadze.” Eva eme nenema. ");
INSERT INTO ewe_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mawu yɔ ƒuƒuiƒe la be “anyigba,” eye wòyɔ tsi siwo ƒo ƒu la be, “atsiaƒuwo.” Mawu kpɔe be enyo. ");
INSERT INTO ewe_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Mawu gblɔ be, “Mina nuwo namie ɖe anyigba la dzi: ati tsekuwo kple ati siwo tsena, eye ku nɔa tsetseawo me wotɔxɛwotɔxɛe la.” Eva eme nenema. ");
INSERT INTO ewe_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tete nuwo mie ɖe anyigba la dzi: ati siwo tsea ku wotɔxɛwotɔxɛe, eye Mawu kpɔe be enyo. ");
INSERT INTO ewe_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Zã do, eye ŋu ke. Esiae nye ŋkeke etɔ̃lia. ");
INSERT INTO ewe_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mawu gblɔ be, “Mina akaɖiwo nanɔ dziŋgɔli la me be woama ŋkeke ɖa tso zã gbɔ, eye woanye dzesi siwo afia ɣeyiɣiwo, ŋkekewo kple ƒewo, ");
INSERT INTO ewe_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","eye woanye akaɖiwo le dziŋgɔli la me be woana kekeli anyigba.” Eye wòva eme nenema. ");
INSERT INTO ewe_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Mawu wɔ nu keklẽ gã eve: ɣe kple ɣleti, be woaklẽ ɖe anyigba dzi. Eɖoe be nu keklẽ gãtɔ si nye ɣe la naklẽ le ŋkeke me, eye suetɔ si nye ɣleti la naklẽ le zã me. Ewɔ ɣletiviwo hã. ");
INSERT INTO ewe_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mawu tsɔ wo ɖo lilikpo la ŋu, be woana kekeli anyigba, ");
INSERT INTO ewe_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","aɖu zã kple ŋkeke dzi, eye woama kekeli ɖa tso viviti gbɔ. Nu sia dze Mawu ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ale zã do, eye ŋu ke. Esiae nye ŋkeke enelia. ");
INSERT INTO ewe_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mawu gblɔ be, “Tɔmelãwo nedzi ɖe tsiawo me, eye xeviwo nedzo le yame le dziŋgɔli la ƒe ŋkume.” ");
INSERT INTO ewe_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ale Mawu wɔ ƒumelã gãwo kple nu gbagbe siwo tana, eye wonɔa tsi me la ƒomevi vovovowo kple xevi siwo dzona la ƒomeviwo katã. Mawu kpɔe be enyo. ");
INSERT INTO ewe_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Mawu yra wo gblɔ be, “Midzi ne miasɔ gbɔ, miayɔ atsiaƒuwo me, eye miana xeviwo nasɔ gbɔ le anyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Eye zã do, eye ŋu ke. Esiae nye ŋkeke atɔ̃lia. ");
INSERT INTO ewe_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Mawu gblɔ be, “Anyigba nedzi lã kple nu gbagbe ɖe sia ɖe ƒomevi: nyiwo, nu tatawo kple gbemelã ɖe sia ɖe tɔgbi.” Eye wòva eme nenema. ");
INSERT INTO ewe_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Mawu wɔ lã wɔadãwo, nyi kple nu tatawo dometɔ ɖe sia ɖe tɔgbi. Eye Mawu kpɔ be enyo. ");
INSERT INTO ewe_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Mawu gblɔ be, “Mina míawɔ ame ɖe míaƒe nɔnɔme me, wòaɖi mí, eye wòaɖu ƒumelãwo, dziƒoxewo, aƒemelãwo kple gbemelãwo katã kpakple nu gbagbe siwo katã tana le anyigba dzi la dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ale Mawu wɔ ame ɖe eya ŋutɔ ƒe nɔnɔme me. Mawu ƒe nɔnɔme me wòwɔ ame ɖo; ŋutsu kple nyɔnu wòwɔ. ");
INSERT INTO ewe_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mawu yra wo gblɔ na wo be, “Midzi miayɔ anyigba blibo la dzi, eye miaɖu edzi; miawoe nye tɔmelãwo, dziƒoxewo kple lã siwo katã tana le anyigba dzi la dzi ɖulawo.” ");
INSERT INTO ewe_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Mawu gagblɔ be “Metsɔ nu miemie siwo tsea ku le anyigba blibo la dzi kple ati tsekuwo na mi abe miaƒe nuɖuɖu ene. ");
INSERT INTO ewe_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Metsɔ gbewo kple atiwo katã na lãwo kple xeviwo kple nu siwo katã tana, siwo me agbe le, le anyigba dzi abe woƒe nuɖuɖu ene.” Eye wòva me nenema. ");
INSERT INTO ewe_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Mawu lé ŋku ɖe nu siwo katã wòwɔ la ŋu, eye wòkpɔe be wonyo ŋutɔ. Zã do, eye ŋu ke. Esiae nye ŋkeke adelia. ");
INSERT INTO ewe_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ale Mawu wu dziƒo kple anyigba kpakple nu siwo katã le xexea me la wɔwɔ nu. ");
INSERT INTO ewe_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Eya ta le ŋkeke adrelia gbe, esi Mawu wu eƒe dɔwɔwɔwo nu la, edzudzɔ eɖokui tso eƒe dɔwɔnawo katã me. ");
INSERT INTO ewe_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Mawu yra ŋkeke adrelia, eye wòwɔe kɔkɔe, elabena eyae nye ŋkeke si dzi wòdzudzɔ xexea me wɔwɔ le. ");
INSERT INTO ewe_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Esiawoe nye dziƒo kple anyigba ƒe dzɔdzɔmenyawo, le wo wɔwɔ me le ɣeyiɣi si me Yehowa Mawu wɔ anyigba kple dziƒo. ");
INSERT INTO ewe_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Do ŋgɔ la, atiwo kple gbewo memie ɖe anyigba dzi haɖe o, elabena Yehowa Mawu meɖo tsidzadza ɖa haɖe o, eye ame aɖeke hã menɔ anyi ade agble ɖe anyigba la dzi o. ");
INSERT INTO ewe_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Gake tsi dzi tso anyigba ƒe tume le teƒe aɖewo, eye wòtsa le anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Azɔ Yehowa Mawu tsɔ anyi me amegbetɔ, eye wògbɔ agbegbɔgbɔ ɖe eƒe ŋɔtime, eye wòzu luʋɔ gbagbe. ");
INSERT INTO ewe_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Esia megbe la, Yehowa Mawu wɔ abɔ aɖe ɖe Eden le ɣedzeƒe lɔƒo, eye wòtsɔ ame si wòwɔ la da ɖe abɔ la me. ");
INSERT INTO ewe_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Yehowa Mawu do ati siwo nya kpɔna la ƒomeviwo katã ɖe abɔ la me. Ati siawo tsea ku viviwo. Agbeti kple ati si nana wodzea si nyui kple vɔ̃ la le abɔ la titina. ");
INSERT INTO ewe_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Tɔsisi aɖe tso Eden ƒe anyigba dzi tsa to abɔ la me hede tsii. Tɔsisi la ma ɖe alɔdze ene me. ");
INSERT INTO ewe_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Alɔdze gbãtɔ ŋkɔe nye Pison. Etsa to Havilanyigba blibo la dzi, afi si sika le. ");
INSERT INTO ewe_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(Sika la nyo ŋutɔ. Resin kple onikskpe hã le afi ma.) ");
INSERT INTO ewe_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Alɔdze evelia ŋkɔe nye Gihon. Etsa to Kus ƒe anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Alɔdze etɔ̃lia ŋkɔe nye Tigris. Etsa to Asiria ƒe ɣedzeƒe lɔƒo. Alɔdze eneliae nye Frat tɔsisi la. ");
INSERT INTO ewe_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Yehowa Mawu tsɔ ame la da ɖe Edenbɔ la me abe abɔdzikpɔla ene. ");
INSERT INTO ewe_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Yehowa Mawu de se na ame la be, “Èkpɔ mɔ aɖu ati sia ati le abɔ sia me, ");
INSERT INTO ewe_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","gake mèkpɔ mɔ aɖu ati si nana wodzea si nyui kple vɔ̃ ya o, elabena ne èɖui la, ku kee nàku.” ");
INSERT INTO ewe_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Yehowa Mawu gblɔ be, “Menyo be ame la ɖeka ko nanɔ anyi o. Mawɔ kpeɖeŋutɔ si asɔ ɖe eŋu la nɛ.” ");
INSERT INTO ewe_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Azɔ Yehowa Mawu tsɔ anyi wɔ gbemelãwo katã kple dziƒoxeviwo katã. Ekplɔ wo va ame la gbɔe be yeanya ŋkɔ si wòana ɖe sia ɖe, eye ale si ame la yɔ nu gbagbe ɖe sia ɖee la zu ŋkɔ nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ale ame la na ŋkɔ nu gbagbeawo, aƒemelãwo, dziƒoxeviwo kple gbemelãwo katã. Ke amea ya mekpɔ kpeɖeŋutɔ si asɔ nɛ o. ");
INSERT INTO ewe_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tete Yehowa Mawu na ŋutsu la dɔ alɔ̃ yi eme ʋĩi. Emegbe la, eɖe ame la ƒe axaƒuti ɖeka, eye wòxe teƒe si wòɖee tsoe la. ");
INSERT INTO ewe_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Yehowa Mawu tsɔ axaƒuti si wòɖe le amea me la wɔ nyɔnu, eye wòkplɔe va ame la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Tete ame la do dzidzɔɣli be, “Ɛhɛ̃! Esiae nye ƒu tso nye ƒu me kple lã tso nye lãme. Woayɔe be ‘nyɔnu’, elabena ŋutsu me woɖee tsoe.” ");
INSERT INTO ewe_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Esia ta ŋutsu gblẽa fofoa kple dadaa ɖi, eye wòkuna ɖe srɔ̃a ŋu ale gbegbe be ame eveawo zua ame ɖeka. ");
INSERT INTO ewe_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Togbɔ be Adam kple srɔ̃a nɔ amama hã la, ŋu mekpea wo dometɔ aɖeke o. ");
INSERT INTO ewe_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Da nye lã si dze aye wu lã bubu siwo katã Yehowa Mawu wɔ la. Da va nyɔnu la gbɔ, eye wòbiae be, “Ɖe wònye nyateƒe be Mawu de se na mi be migaɖu ati siwo katã le abɔa me la dometɔ aɖeke ƒe tsetsea oa?” ");
INSERT INTO ewe_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Nyɔnu la gblɔ na da la be, “Míate ŋu aɖu ati ɖe sia ɖe si le abɔ sia me la ƒe tsetse, ");
INSERT INTO ewe_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","gake Mawu gblɔ be, ‘Migaɖu ati si le abɔ la titina ƒe tsetse o, migaka asi eŋu hã o, ne menye nenema o la, miaku.’ ” ");
INSERT INTO ewe_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Da la gblɔ be, “Miele kuku ge akpɔ o! ");
INSERT INTO ewe_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mawu nya nyuie be ne mieɖui ko la, miazu abe ye ene, elabena miaƒe ŋkuwo aʋu, eye mianya nyui kple vɔ̃.” ");
INSERT INTO ewe_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Esi nyɔnu la kpɔ be ati la ƒe tsetse nyo na ɖuɖu, eye wònya kpɔ, eye wònana wodzea nunya la, egbe ɖe ɖu. Ena ɖe srɔ̃a si le egbɔ la hã wòɖu. ");
INSERT INTO ewe_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Esi woɖu kutsetsea ko la, wodze sii enumake be yewole amama, eye ŋu de asi wo kpekpe me. Ale wotɔ aŋgbawo hesa ɖe ali. ");
INSERT INTO ewe_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Gbe ma gbe ƒe ɣetrɔ la, amea kple srɔ̃a se Yehowa Mawu ŋkɔ wònɔ tsa ɖim le abɔ la me. Ale woɣla wo ɖokuiwo ɖe atiawo dome. ");
INSERT INTO ewe_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Yehowa Mawu yɔ amea, eye wòbiae bena, “Afi ka nèle?” ");
INSERT INTO ewe_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adam ɖo eŋu be, “Mese ŋkɔwò nègbɔna, vɔvɔ̃ ɖom, eye nyemedi be nàkpɔm manɔ amama o, eya ta meɣla ɖokuinye.” ");
INSERT INTO ewe_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Mawu biae be, “Ame kae gblɔ na wò be èle amama? Ɖe nèɖu ati si ŋu mede se na mi le la ƒe tsetsea?” ");
INSERT INTO ewe_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Amea ɖo eŋu be, “Ɛ̃, nyɔnu si nèwɔ nam lae na kutsetsea ƒe ɖem meɖu.” ");
INSERT INTO ewe_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Yehowa Mawu bia nyɔnu la be, “Nu ka ta nèwɔ nu sia ɖo?” Nyɔnu la ɖo eŋu be, “Da lae blem.” ");
INSERT INTO ewe_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Eya ta Yehowa Mawu gblɔ na da la be, “Ɖe nu si nèwɔ ta la, “Maƒo fi ade wò ɖeka le aƒemelã kple gbemelã siwo katã le anyigba dzi la dome! Wò ƒodo dzi nàzɔ eye ʋuʋudedi anye wò nuɖuɖu le wò agbemeŋkekewo katã me. ");
INSERT INTO ewe_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Tso azɔ dzi la, made fuléle wò kple nyɔnu la dome, eye fuléle ma ke anɔ wò dzidzime kple nyɔnu la tɔ dome. Eya la agbã ta na wò, eye wò la àɖu afɔkpodzi nɛ.” ");
INSERT INTO ewe_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Mawu gblɔ na nyɔnu la be, “Àdzi vi le fukpekpe kple vevesese geɖe me, gake srɔ̃wò ƒe nu aganyo ŋuwò kokoko, eye srɔ̃wò anye aƒetɔ na wò.” ");
INSERT INTO ewe_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Mawu gblɔ na Adam be, “Esi nèɖo to srɔ̃wò, eye nèɖu kutsetse si ŋu mede se na mi le ta la, meƒo fi de anyigba ɖe tawò. “Le wò agbemeŋkekewo katã me la, àku kutri be yeakpɔ nuɖuɖu tso anyigba me. ");
INSERT INTO ewe_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Anyigba ana ŋuwo kple aŋɔkawo namie na wò, eye nàɖu woƒe gbewo. ");
INSERT INTO ewe_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Àdze agbagba le wò agbemeŋkekewo katã me hafi akpɔ abolo aɖu va se ɖe esime nàku. Agatrɔ azu anyi, nu si wotsɔ wɔ wòe la; elabena anyi wotsɔ wɔ wòe, eye anyi ke nàgatrɔ azu.” ");
INSERT INTO ewe_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ŋutsu la na ŋkɔ srɔ̃a be Eva si gɔmee nye “Agbenala,” elabena egblɔ be, “Eyae azu amegbetɔƒome blibo la dzila.” ");
INSERT INTO ewe_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Yehowa Mawu wɔ lãgbalẽwu do na Adam kple srɔ̃a. ");
INSERT INTO ewe_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Yehowa Mawu gblɔ be, “Esi ame la zu abe míawo ene, eye wònya nyui kple vɔ̃ la, nya kae adzɔ ne aɖu agbeti la, eye wòanɔ agbe tegbetegbe?” ");
INSERT INTO ewe_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Esia ta Yehowa Mawu nyae ɖa tso Edenbɔ la me, eye wòɖoe ɖa be wòayi aɖade agble ɖe anyigba si me woɖee tsoe la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ale Mawu nya ame la, eye wòtsɔ mawudɔla sesẽ siwo wòde yi dadzowo asi na la da ɖe Edenbɔ la ƒe ɣedzeƒe lɔƒo be woadzɔ mɔ woato aɖo ta agbeti la gbɔ la nu. ");
INSERT INTO ewe_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam dɔ kple srɔ̃a, Eva, eye wòfɔ fu dzi Kain. Eva gblɔ be, “To Yehowa ƒe amenuveve me la, medzi ŋutsu.” ");
INSERT INTO ewe_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Eva gadzi ŋutsuvi bubu, eye wòna ŋkɔe be Abel. Abel nye lãnyila, eye Kain nye agbledela. ");
INSERT INTO ewe_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Le nuŋeɣi la, Kain tsɔ eƒe agblemenukuwo sa vɔ na Yehowa, ");
INSERT INTO ewe_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","eye Abel hã tsɔ eƒe alẽvi damitɔ sa vɔ nɛ. Yehowa xɔ Abel ƒe vɔsa, ");
INSERT INTO ewe_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","gake mexɔ Kain tɔ o. Nu sia na Kain xa nu, eye wòdo dɔmedzoe heɖo adã. ");
INSERT INTO ewe_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yehowa bia Kain be, “Nu ka ta nèdo dɔmedzoe vevie, eye nèyɔ mo ɖo? ");
INSERT INTO ewe_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Wò mo ate ŋu akɔ kple dzidzɔ ne ɖe nèwɔ nu si wòle be nàwɔ la! Ke esi nèwɔ vɔ̃ ta la, nu vɔ̃ le wò ʋɔtru nu le lalawòm be yeaɖu dziwò. Ke dze agbagba be nàɖu edzi!” ");
INSERT INTO ewe_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Gbe ɖeka la, Kain gblɔ na nɔvia, Abel be, “Na míayi gbedzi.” Esi woyi gbea dzi la, Kain wu nɔvia, Abel. ");
INSERT INTO ewe_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Emegbe la, Yehowa bia Kain be, “Afi ka nɔviwò, Abel le?” Kain ɖo eŋu be, “Nyemenya o. Nɔvinyeŋudzɔlae menyea?” ");
INSERT INTO ewe_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Yehowa gblɔ nɛ be, “Nu kae nye esi nèwɔ? Kpɔ ɖa, nɔviwò ƒe ʋu do ɣli tso anyigba dzi va ɖo gbɔnye na hlɔ̃biabia. ");
INSERT INTO ewe_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ke fifia fiƒode le dziwò, eye menya wò ɖa tso anyigba si nèdo gui kple nɔviwò ƒe ʋu la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Anyigba maganyo nuku na wò o, ne èku kutri le edzi vevie gɔ̃ hã! Azɔ la, àzu tsaglãlatsala kple godzela le anyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain ɖo eŋu na Yehowa be, “Nye tohehe kpe wu tsɔtsɔ nam, ");
INSERT INTO ewe_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","elabena ènyam ɖa tso nye agble kple wò ŋutɔ gbɔ, èwɔm tsaglãlatsala kple godzela, eye ame sia ame si akpɔm la, adi be yeawum.” ");
INSERT INTO ewe_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Yehowa gblɔ nɛ be, “Womawu wò o, elabena mada wò tohehe teƒe adre ɖe ame si awu wò la dzi.” Ale Yehowa de dzesi tɔxɛ Kain ŋu si ana be ame aɖeke mawui o. ");
INSERT INTO ewe_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ale Kain dzo le Yehowa ƒe ŋkume, eye wòyi ɖanɔ Nodnyigba si le Edenbɔ ƒe ɣedzeƒe lɔƒo la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kain srɔ̃ fɔ fu, eye wòdzi ŋutsuvi. Ena ŋkɔe be Enɔk. Esia ta esi Kain tso du aɖe la, etsɔ via ƒe ŋkɔ nɛ be Enɔk. ");
INSERT INTO ewe_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enɔk nye Irad fofo, Irad nye Mehuyael fofo, Mehuyael nye Metusael fofo, Metusael nye Lamek fofo. ");
INSERT INTO ewe_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek ɖe srɔ̃ eve, Ada kple Zila. ");
INSERT INTO ewe_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada dzi Yabal. Eyae zu nyikplɔla kple ame siwo nɔa avɔgbadɔwo me la dometɔ gbãtɔ. ");
INSERT INTO ewe_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Nɔvia ŋutsu ŋkɔe nye Yubal, eye wònye ame gbãtɔ si wɔ kasaŋku kple dze. ");
INSERT INTO ewe_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamek srɔ̃ evelia, Zila dzi Tubal Kain. Eyae zu gbede gbãtɔ, eye wòtua nuwo kple akɔbli kple gayibɔ. Tubal Kain nɔvinyɔnue nye Naama. ");
INSERT INTO ewe_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Gbe ɖeka la, Lamek gblɔ na Ada kple Zila be, “Srɔ̃nyewo, miɖo tom. Mewu ame aɖe si de abi ŋunye, ɖekakpui aɖe si wɔ nuvevim. ");
INSERT INTO ewe_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ne woahe to na ame si awu Kain zi adre la, ekema ele be woahe to na Lamek zi blaadre-vɔ-adre!” ");
INSERT INTO ewe_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Emegbe la, Adam kple srɔ̃a nɔ anyi eye Eva gadzi ŋutsuvi, eye wòna ŋkɔe be Set si gɔmee nye “Teƒeɖoɖo,” elabena Eva gblɔ be, “Mawu tsɔ ŋutsuvi bubu ɖo Abel, ame si Kain wu la teƒe nam.” ");
INSERT INTO ewe_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Esi Set tsi la, edzi ŋutsuvi, eye wòna ŋkɔe be Enos. Le ɣe ma ɣi me la, amewo de asi Yehowa ŋkɔ yɔyɔ me. ");
INSERT INTO ewe_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Esiae nye Adam ƒe dzidzimeviwo ƒe ŋkuɖodzigbalẽ. Esi Mawu wɔ amegbetɔ la ewɔe ɖe eya ŋutɔ ƒe nɔnɔme. ");
INSERT INTO ewe_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Mawu wɔ ŋutsu kple nyɔnu, eye wòyra wo. Eyɔ wo tso gɔmedzedzea be “Ame.” ");
INSERT INTO ewe_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam xɔ ƒe alafa ɖeka kple blaetɔ̃ (130) esi wòdzi Set. Ŋutsuvi sia ɖi fofoa ŋutɔ le go ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Le Set dzidzi megbe la, Adam ganɔ agbe ƒe alafa enyi (800). Egadzi ŋutsuviwo kple nyɔnuviwo. ");
INSERT INTO ewe_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Exɔ ƒe alafa asiekɛ kple blaetɔ̃ (930) hafi ku. ");
INSERT INTO ewe_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set xɔ ƒe alafa ɖeka kple atɔ̃ (105) hafi dzi Enos. ");
INSERT INTO ewe_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Eganɔ agbe ƒe alafa enyi kple adre (807), eye wògadzi ŋutsuviwo kple nyɔnuviwo. ");
INSERT INTO ewe_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Exɔ ƒe alafa asiekɛ kple wuieve (912) hafi ku. ");
INSERT INTO ewe_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Esime Enos xɔ ƒe blaasiekɛ la, ezu fofo na Kenan, ");
INSERT INTO ewe_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","eye esi wòdzi Kenan megbe la, Enos ganɔ agbe ƒe alafa enyi wuiatɔ̃ (815), eye wodzi ŋutsuvi kple nyɔnuvi bubuwo nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos ƒe agbenɔƒewo katã nye ƒe alafa asiekɛ kple atɔ̃ (905), eye wòku. ");
INSERT INTO ewe_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan xɔ ƒe blaadre hafi dzi Via ŋutsuvi Mahalalel. ");
INSERT INTO ewe_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan ganɔ agbe ƒe alafa enyi kple blaene (840) le Mahalalel kple Kenan dzidzi vɔ megbe. Edzi ŋutsuviwo kple nyɔnuviwo bubuwo hã emegbe. ");
INSERT INTO ewe_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan ku esi wòxɔ ƒe alafa asiekɛ kple ewo (910). ");
INSERT INTO ewe_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel xɔ ƒe blaade-vɔ-atɔ̃ esi wòdzi Via ŋutsuvi Yared. ");
INSERT INTO ewe_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Esi Mahalalel dzi Yared megbe la, eganɔ agbe ƒe alafa enyi kple blaetɔ̃ (830). Edzi ŋutsuviwo kple nyɔnuviwo, ");
INSERT INTO ewe_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","eye wòku esi wòxɔ ƒe alafa enyi blaasiekɛ-vɔ-atɔ̃ (895). ");
INSERT INTO ewe_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yared xɔ ƒe alafa ɖeka blaade-vɔ-eve (162) esi wòdzi Via ŋutsuvi Enɔk. ");
INSERT INTO ewe_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Eganɔ agbe ƒe alafa enyi (800). Edzi ŋutsuviwo kple nyɔnuviwo. ");
INSERT INTO ewe_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yared ku esi wòxɔ ƒe alafa asiekɛ blaade-vɔ-eve (962). ");
INSERT INTO ewe_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enɔk xɔ ƒe blaade-vɔ-atɔ̃ esi wòdzi Metusela. ");
INSERT INTO ewe_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Eganɔ agbe ƒe alafa etɔ̃ (300), eye wòzɔ nyuie kple Mawu. Edzi ŋutsuviwo kple nyɔnuviwo. ");
INSERT INTO ewe_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enɔk xɔ ƒe alafa etɔ̃ blaade-vɔ-atɔ̃ (365), ");
INSERT INTO ewe_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","eye esi wògazɔ kple Mawu kplikplikpli ta la, ebu vĩi, elabena Mawu kɔe dzoe. ");
INSERT INTO ewe_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela xɔ ƒe alafa ɖeka blaenyi-vɔ-adre (187) hafi dzi Via ŋutsuvi Lamek. ");
INSERT INTO ewe_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Eganɔ agbe ƒe alafa adre blaenyi-vɔ-eve (782). Edzi ŋutsuviwo kple nyɔnuviwo. ");
INSERT INTO ewe_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela ku esi wòxɔ ƒe alafa asiekɛ blaade-vɔ-asiekɛ (969). ");
INSERT INTO ewe_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek xɔ ƒe alafa ɖeka kple blaenyi-vɔ-eve (182) hafi wòdzi Via ŋutsuvi Noa. ");
INSERT INTO ewe_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamek na ŋkɔe be Noa si gɔmee nye “Gbɔdzɔe,” elabena egblɔ be, “Ame sia ahe gbɔdzɔe vɛ na mí tso agbledɔ sesẽ si wɔm míele le anyigba si Mawu ƒo fi dee dzi la me.” ");
INSERT INTO ewe_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek ganɔ agbe ƒe alafa atɔ̃ blaasiekɛ-vɔ-atɔ̃ (595) le Noa dzidzi megbe. Edzi ŋutsuviwo kple nyɔnuviwo. ");
INSERT INTO ewe_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek ku esi wòxɔ ƒe alafa adre blaadre-vɔ-adre (777). ");
INSERT INTO ewe_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa xɔ ƒe alafa atɔ̃ (500), eye wòdzi ŋutsuvi etɔ̃: Sem, Ham kple Yafet. ");
INSERT INTO ewe_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Amewo dzi, eye wosɔ gbɔ ŋutɔ ɖe anyigba dzi. Le ɣeyiɣi sia me la, ");
INSERT INTO ewe_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","mawu viwo kpɔ be amegbetɔwo ƒe nyɔnuwo dze tugbe, eye woɖe wo dometɔ siwo nyo wo ŋu la. ");
INSERT INTO ewe_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Tete Yehowa gblɔ be, “Mele be nye Gbɔgbɔ naganɔ amegbetɔwo me tegbee o, elabena amegbetɔwo wɔ nu vɔ̃ le goawo katã me. Woƒe agbemeŋkekewo anye ƒe alafa ɖeka kple blaeve.” ");
INSERT INTO ewe_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Le ɣe ma ɣi me kple emegbe gɔ̃ hã la, esime mawu viwo ɖea amegbetɔwo ƒe nyɔnuwo la, wo viwo zua ame dzɔatsuwo, eye ŋutinya geɖewo nɔ wo ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Esime Yehowa kpɔ ale si gbegbe amegbetɔwo vɔ̃ɖie, eye wòkpɔ be woƒe agbenɔnɔ ɖo ta nu vɔ̃ wɔwɔ ko gbɔ la, ");
INSERT INTO ewe_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","evee ŋutɔ be yewɔ amegbetɔ. Nu sia gbã dzi nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tete Yehowa gblɔ be, “Matsrɔ̃ amegbetɔƒome blibo si mewɔ la ɖa le anyigba dzi. Ɛ̃, matsrɔ̃ lãwo, xewo kple nu gbagbe siwo tana la hã, elabena evem be mewɔ wo.” ");
INSERT INTO ewe_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ke Yehowa kpɔ ŋudzedze le Noa ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noa ƒe ŋutinya yi ale: Noa nye ame dzɔdzɔe kple ame maɖifɔ le ame siwo nɔ anyi le eŋɔli la dome, eye wòzɔ kple Mawu. ");
INSERT INTO ewe_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ŋutsuvi etɔ̃ nɔ esi: Woawoe nye Sem, Ham kple Yafet. ");
INSERT INTO ewe_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Azɔ la, nu vɔ̃ wɔwɔ ganɔ edzi yim wu tsã le xexea me godoo, eye Mawu kpɔ be nu vlo wɔwɔ na xexea me gblẽ keŋ. ");
INSERT INTO ewe_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Mawu kpɔ ale si xexea me va gblẽe, elabena ame siwo katã nɔ xexea me la ƒe zɔzɔme gblẽ le anyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Ale Mawu gblɔ na Noa be, “Mele ameawo katã tsrɔ̃ ge, elabena woƒe nu vlo wɔwɔ xɔ anyigba la dzi. Matsrɔ̃ wo kple anyigba la siaa. ");
INSERT INTO ewe_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tsɔ dzati kpa aɖakaʋu, eye nàsi aŋɔ nɛ. Wɔ yaxɔƒewo ɖe eŋu kpe ɖo, eye nàwɔ nudzraɖoƒewo ɖe eme ƒe afi sia afi. ");
INSERT INTO ewe_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Na wòadidi mita alafa ɖeka blaene (140), akeke mita blaeve-vɔ-etɔ̃, akɔkɔ mita wuietɔ̃ kple afã. ");
INSERT INTO ewe_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ɖe fesre mita afã ɖe xɔ gbagbã la te ƒo xlã aɖakaʋu la. Wɔ dzisasã etɔ̃, etetɔ, titinatɔ kple etametɔ ɖe aɖakaʋu la me, eye nàde ʋɔtru ɖeka tɔdziʋu la ƒe axadzi. ");
INSERT INTO ewe_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Kpɔ ɖa, mana tsi naɖɔ ɖe anyigba la dzi, eye wòatsrɔ̃ nu sia nu si me agbegbɔgbɔ le la. Nu sia nu si le anyigba dzi la atsrɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","“Ke mele nu blam kpli wò be makpɔ tawò le aɖakaʋu la me nànɔ dedie kple srɔ̃wò kple viwò ŋutsuwo kple wo srɔ̃wo. ");
INSERT INTO ewe_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Nàtsɔ nu gbagbe ɖe sia ɖe ƒomevi eveve, atsu kple asi ade aɖakaʋu la me be woanɔ agbe le gbɔwò. ");
INSERT INTO ewe_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Xevi ƒomevi ɖe sia ɖe, eveve, lã ƒomevi ɖe sia ɖe eveve kple nu gbagbe ɖe sia ɖe si tana la eveve ava gbɔwò be nàde wo aɖakaʋu la me. ");
INSERT INTO ewe_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Dzra nuɖuɖu si woawo kple miawo siaa miahiã la ɖo ɖe aɖakaʋu la me.” ");
INSERT INTO ewe_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Eye Noa wɔ nu sia nu abe ale si Mawu ɖoe nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yehowa gblɔ na Noa be, “Yi aɖakaʋu la me kple wò ƒometɔwo katã, elabena le anyigbadzinɔlawo katã dome la, wò koe nye ame dzɔdzɔe le nye ŋkume. ");
INSERT INTO ewe_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","“Kplɔ lãwo hã de eme, atsu kple asi, negbe esiwo metia da ɖi be woaɖu kple esiwo woatsɔ asa vɔe ko. Tsɔ wo dome adre, atsu kple asi, ");
INSERT INTO ewe_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","eye nàgatsɔ xevi ɖe sia ɖe ƒe atsu kple asi adre. Ale nu gbagbe ɖe sia ɖe agate ŋu adzi le tsiɖɔɖɔ la megbe. ");
INSERT INTO ewe_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Le kɔsiɖa ɖeka megbe tso egbe sia dzi la, mana tsi nadza ŋkeke blaene kple zã blaene, eye matsrɔ̃ nu gbagbe siwo katã mewɔ ɖe anyigba dzi la.” ");
INSERT INTO ewe_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ale Noa wɔ nu sia nu si Yehowa di tso esi be wòawɔ la. ");
INSERT INTO ewe_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa xɔ ƒe alafa ade esi tsiɖɔɖɔ ɖe anyigba la. ");
INSERT INTO ewe_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ege ɖe aɖakaʋu la me kple srɔ̃a, via ŋutsuwo kple wo srɔ̃wo be woasi le tsiɖɔɖɔ la nu. ");
INSERT INTO ewe_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Lã ɖuɖua kple lã maɖumaɖua ɖe sia ɖe ƒomevi eveve, xeviwo eveve kple lã siwo katã tana la, ");
INSERT INTO ewe_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","atsu kple asi va Noa gbɔ, eye woge ɖe aɖakaʋu la me abe ale si Mawu ɖo na Noa ene. ");
INSERT INTO ewe_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Le ŋkeke adre megbe la, tsi dza ɖe anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Le ɣleti evelia ƒe ŋkeke wuiadrelia gbe le Noa ƒe ƒe alafa ade xɔxɔ me la, anyigba ƒe tumetsi gãwo katã ŋɔ, eye dziƒo nu ʋu gbe ma gbe. ");
INSERT INTO ewe_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tsi de asi dzadza me sesĩe, eye tsi dzidziwo ŋɔ tso tome va anyigba dzi ŋkeke blaene kple zã blaene. ");
INSERT INTO ewe_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ke Noa yi aɖakaʋu la me gbe ma gbe kple srɔ̃a kple viawo, Sem, Ham kple Yafet kple wo srɔ̃wo. ");
INSERT INTO ewe_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Lã wɔadã ɖe sia ɖe ƒomevi, aƒemelã ɖe sia ɖe ƒomevi, lã siwo tana ɖe sia ɖe ƒomevi kple xevi siwo dzona ɖe sia ɖe ƒomevi kple esiwo medzona o siaa yi kpli wo. ");
INSERT INTO ewe_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Nuwɔwɔ sia nuwɔwɔ si me agbegbɔgbɔ le la ƒomevi ɖe sia ɖe, atsu kple asi va Noa gbɔ, eye woge ɖe aɖakaʋu la me. ");
INSERT INTO ewe_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Woge ɖe aɖakaʋu la me eveve, atsu kple asi abe ale si Mawu ɖo na wo ene. Tete Yehowa tu ʋɔtru la ɖe wo nu. ");
INSERT INTO ewe_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Tsiɖɔɖɔ la nɔ edzi ŋkeke blaene sɔŋ. Exɔ anyigba dzi, eye wòtsɔ aɖakaʋu la do ɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Esi tsi la nɔ ɖɔɖɔm ɖe edzi, eye wònɔ aɖakaʋu la dom ɖe dzi ɣe sia ɣi wu tsã la, aɖakaʋu la nɔ dedie le tsi la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mlɔeba la, tsi la ɖɔ kɔkɔ gbɔ to kɔkɔwo katã ŋu le lilikpo la te, ");
INSERT INTO ewe_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","eye aɖakaʋu la ƒe nɔƒe kɔkɔ mita blaadre-vɔ-eve, alo wu nenema gɔ̃ hã. ");
INSERT INTO ewe_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Nu gbagbe siwo katã nɔ anyigba dzi, xeviwo, aƒemelãwo, gbemelãwo, nu gbagbe siwo katã tana kple amegbetɔƒome blibo la katã tsrɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Nu sia nu si me agbe nɔ, eye wònɔ anyigba ƒuƒui dzi tsã la tsrɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Anyigbadzinu gbagbewo katã, amegbetɔwo kple lãwo siaa, nu gbagbe siwo tana kple xeviwo katã ƒe agbe nu tso. Mawu tsrɔ̃ wo katã, negbe Noa kple ame siwo nɔ egbɔ le aɖakaʋu la me kple nu bubu siwo nɔ wo gbɔ le aɖakaʋu la me ko tsi agbe. ");
INSERT INTO ewe_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tsiɖɔɖɔ la nɔ anyigba dzi ŋkeke alafa ɖeka blaatɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Mawu meŋlɔ Noa kple lã siwo katã nɔ aɖakaʋu la me be o. Ena ya aɖe ƒo to tsi la dzi, eye tsiɖɔɖɔ la de asi miemie me, ");
INSERT INTO ewe_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","elabena tsi si ŋɔ tso tome la nu tso, eye tsidzadza la ke. ");
INSERT INTO ewe_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Tsi la de asi miemie me vivivi le anyigba dzi. Le ŋkeke alafa ɖeka blaatɔ̃lia ƒe nuwuwu la, tsi la mie keŋ, ");
INSERT INTO ewe_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","eye le ɣleti adrelia ƒe ŋkeke wuiadrelia gbe la, aɖakaʋu la va tɔ ɖe Ararat toawo tame. ");
INSERT INTO ewe_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Le ɣleti ewolia ƒe ŋkeke gbãtɔ gbe, esime tsiɖɔɖɔ la ganɔ miemiem ɖe edzi kokoko la, to bubuwo hã tame de asi dzedze me. ");
INSERT INTO ewe_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Le ŋkeke blaene bubu megbe la, Noa ʋu aɖakaʋu la ƒe fesre ɖeka, ");
INSERT INTO ewe_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","eye wòɖe asi le akpaviã ɖeka ŋu. Akpaviã la dzo tso afii yi afi mɛ va se ɖe esime anyigba ƒu. ");
INSERT INTO ewe_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Noa ɖo ahɔnɛ aɖe ɖa be ate ŋu akpɔ anyigba ƒuƒui mahã. ");
INSERT INTO ewe_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ke ahɔnɛ la mekpɔ anyigba ƒuƒui aɖeke, afi si wòadze ɖo o, ale wòtrɔ gbɔ, elabena tsi ganɔ anyigba dzi ko. Ale Noa do asi ɖa, eye wòlé ahɔnɛ la gade aɖakaʋu la me. ");
INSERT INTO ewe_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Le ŋkeke adre megbe la, Noa gaɖe asi le ahɔnɛ la ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Azɔ la, ahɔnɛ la trɔ gbɔ le fiẽ me, eye wòlé amitiŋgba ɖe nu. Ale Noa dze sii be esusɔ vie tsi la namie keŋkeŋ. ");
INSERT INTO ewe_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Egaɖe asi le ahɔnɛ la ŋu le kɔsiɖa ɖeka megbe, eye ahɔnɛ la megatrɔ gbɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ŋkeke blaeve-vɔ-asiekɛ va yi. Noa ʋu aɖakaʋu la, eye wòkpɔ be tsi la mie keŋkeŋ azɔ. ");
INSERT INTO ewe_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kɔsiɖa enyi gava yi. Anyigba ƒu azɔ mlɔeba. ");
INSERT INTO ewe_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Tete Mawu gblɔ na Noa be, ");
INSERT INTO ewe_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Wò kple srɔ̃wò kple viwò ŋutsuawo kple wo srɔ̃wo mido le aɖakaʋu la me. ");
INSERT INTO ewe_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ɖe nu gbagbe bubu ɖe sia ɖe si le gbɔwò: xeviawo, lãawo kple nu gbagbe siwo tana la katã do go le aɖakaʋu la me, ale be woagate ŋu adzi asɔ gbɔ ɖe anyigba la dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ale Noa do go kple srɔ̃a kple via ŋutsuawo kple wo srɔ̃awo. ");
INSERT INTO ewe_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Lãawo katã kple nu gbagbe siwo tana kple xevi ɖe sia ɖe kple nu sia nu si ʋãna le anyigba dzi la do go tso aɖakaʋu la me ɖe wo nɔewo yome hamehame. ");
INSERT INTO ewe_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Esia megbe la, Noa ɖi vɔsamlekpui, eye wòsa vɔ le edzi na Yehowa kple lã kple xevi siwo dzi Yehowa da asi ɖo hena vɔsasa la dometɔ aɖewo. ");
INSERT INTO ewe_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Yehowa kpɔ ŋudzedze le vɔsa la ŋu, eye wògblɔ na eɖokui be, “Nyemagaƒo fi ade anyigba o, eye nyemagatsrɔ̃ nu gbagbewo katã le edzi azɔ o, togbɔ be amegbetɔ ƒe dzɔdzɔme henɛ dea nu vɔ̃ me tso keke eƒe ɖevime ke, eye wòwɔa nu vɔ̃wo tsyo ƒomevi gɔ̃ hã. ");
INSERT INTO ewe_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Zi ale si anyigba aganɔ anyi ko la, nuƒãɣi kple nuŋeɣi, vuvɔŋɔli kple fifiawɔɣi, pepime kple dzomeŋɔli, ŋkeke kple zã aganɔ anyi kokoko.” ");
INSERT INTO ewe_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Mawu yra Noa kple viawo, eye wògblɔ na wo be, “Midzi ne miasɔ gbɔ ayɔ anyigba blibo la dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Vɔvɔ̃ aɖo anyigbadzilãwo katã kple dziƒoxevi ɖe sia ɖe kple lã ɖe sia ɖe si tana kple ƒumelãwo katã ɖe mia ŋu, eye metsɔ wo de asi na mi. ");
INSERT INTO ewe_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Nu sia nu si le agbe, eye woʋãna la anye nuɖuɖu na mi. Abe ale si metsɔ amagbewo na mi kpɔ ene la, nenema ke mele nu sia nu tsɔm le asi dem na mi fifia. ");
INSERT INTO ewe_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Ke mele be miaɖu lã si me ʋu metsyɔ le la o. ");
INSERT INTO ewe_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Mabia akɔnta mi tso ʋu si le mia me la ŋu. Mabia akɔnta tso lã sia lã ŋu, eye mabia akɔnta ame sia ame hã tso nɔvia ƒe agbe ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Ame sia ame si akɔ ame ƒe ʋu ɖi la, ame akɔ eya hã ƒe ʋu ɖi, elabena Mawu ƒe nɔnɔme me Mawu wɔe ɖo. ");
INSERT INTO ewe_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ɛ̃, midzi ne miasɔ gbɔ fũu, mikpe xexe blibo la me ɖo, eye miaɖu edzi.” ");
INSERT INTO ewe_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Mawu gblɔ na Noa kple via ŋutsuwo be, ");
INSERT INTO ewe_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Azɔ la, mebla nu kple wò kple wò dzidzimeviwo ");
INSERT INTO ewe_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kpakple nu gbagbe ɖe sia ɖe si nɔ gbɔwò, xeviawo, aƒemelãawo, lã wɔadãawo katã, nu sia nu si do go tso aɖakaʋu la me kple wò, nu gbagbe ɖe sia ɖe si le anyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Mebla nu kpli wò. Tsiɖɔɖɔ magatsi agbe nu na nu gbagbewo azɔ o. Tsi magaɖɔ, agatsrɔ̃ anyigba akpɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Metsɔ dzesi sia tre nubabla sia nu: ");
INSERT INTO ewe_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Metsɔ nye anyieʋɔ de lilikpowo me abe nye nubabla ƒe dzesi na wò kple anyigbadzitɔwo katã ene va se ɖe xexea me ƒe nuwuwu. ");
INSERT INTO ewe_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ne mena lilikpowo tsyɔ anyigba dzi la, woakpɔ anyieʋɔ le lilikpoawo me, ");
INSERT INTO ewe_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ekema maɖo ŋku nye nubabla kpli wò kple nu gbagbe ɖe sia ɖe dzi be tsiɖɔɖɔ magava atsrɔ̃ nu gbagbewo azɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ɣe sia ɣi si anyieʋɔ ado ɖe lilikpo me la, makpɔe, eye maɖo ŋku nubabla mavɔ si le Mawu kple nu gbagbe ɖe sia ɖe si le anyigba dzi dome la dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Eye Mawu gblɔ na Noa be, “Esiae nye nubabla si mewɔ kple nu gbagbe siwo katã le xexea me la ƒe dzesi.” ");
INSERT INTO ewe_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa ƒe vi etɔ̃awo ƒe ŋkɔwoe nye Sem, Ham kple Yafet. (Ham nye Kanaantɔwo fofo.) ");
INSERT INTO ewe_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Amegbetɔƒome blibo la do tso Noa ƒe viŋutsu etɔ̃ siawo me. ");
INSERT INTO ewe_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa, ame si nye agbledela la de waingble. ");
INSERT INTO ewe_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Esi wòno wain la ƒe ɖe la, emu aha, eye wòɖe amama mlɔ anyi ɖe eƒe agbadɔ me. ");
INSERT INTO ewe_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham, ame si nye Kanaantɔwo fofo la kpɔ fofoa ƒe amame, eye wòyi ɖagblɔe na nɔvia eveawo. ");
INSERT INTO ewe_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ale Sem kple Yafet lé avɔ aɖe ɖe abɔta, trɔ kɔ ɖe adzɔge, zɔ megbemegbe yi avɔgbadɔ la me, eye wotsɔ avɔ la tsyɔ na wo fofo. ");
INSERT INTO ewe_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Esime Noa ƒe ŋkume kɔ, eye wòse nu si Via ŋutsu suetɔ wɔ ɖe eŋu la, ");
INSERT INTO ewe_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","egblɔ be, “Woaƒo fi ade Kanaan; ànye kluvi gblɔetɔ na nɔviwòwo.” ");
INSERT INTO ewe_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Eyi edzi be, “Woayra Yehowa, Sem ƒe Mawu. Kanaan nazu kluvi na Sem. ");
INSERT INTO ewe_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Mawu nekeke Yafet ƒe anyigba ɖe edzi. Yafet nanɔ Sem ƒe agbadɔwo me, eye Kanaan nanye eƒe kluvi.” ");
INSERT INTO ewe_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Noa ganɔ agbe ƒe alafa etɔ̃ blaatɔ̃ (350) le tsiɖɔɖɔ megbe. ");
INSERT INTO ewe_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Exɔ ƒe alafa asiekɛ blaatɔ̃ (950) hafi ku. ");
INSERT INTO ewe_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa ƒe viwo, Sem, Ham kple Yafet dzi viŋutsuwo le tsiɖɔɖɔ la megbe. Woƒe dzidzimeviwo yi ale: ");
INSERT INTO ewe_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafet ƒe viwoe nye: Gomer, Magog, Madai, Yavan, Tubal, Mesek kple Tiras. ");
INSERT INTO ewe_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer ƒe viŋutsuwoe nye: Askenaz, Rifat kple Togarma. ");
INSERT INTO ewe_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yavan ƒe viŋutsuwoe nye: Elisa, Tarsis, Kititɔwo kple Dodanitɔwo. ");
INSERT INTO ewe_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","(Woƒe dzidzimeviwo va zu ƒutadukɔwo le anyigba vovovowo dzi, eye woƒe gbegbɔgblɔwo to vovo tso wo nɔewo gbɔ.) ");
INSERT INTO ewe_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham ƒe viŋutsuwoe nye: Kus, Egipte, Put kple Kanaan. ");
INSERT INTO ewe_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kus ƒe viŋutsuwoe nye: Seba, Havila, Sabta, Raama kple Sabteka. Raama ƒe viŋutsuwoe nye: Seba kple Dedan. ");
INSERT INTO ewe_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus ƒe dzidzimevie nye Nimrɔd, ame si va zu kalẽtɔ gã aɖe le anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Enye adela xɔŋkɔ aɖe si Yehowa yra, eye ame geɖewo kafunɛ. Amewo ɖia ɖase tso ame bubuwo ŋu be wole “abe Nimrɔd, adela xɔŋkɔ si Yehowa yra la ene.” ");
INSERT INTO ewe_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Eɖu Babel, Erek, Akad kple Kalne si nɔ Sinarnyigba la dzi gbã. ");
INSERT INTO ewe_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Tso anyigba ma dzi la, eyi Asiria, afi si wòtu Ninive, Rehobot Ir, Kala ");
INSERT INTO ewe_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","kple Resen ɖo; Resen le Ninive kple Kala dome, eye eyae nye du gã la. ");
INSERT INTO ewe_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ame siwo nye Egipte ƒe dzidzimeviwo lae nye: Ludimtɔwo, Anamimtɔwo, Lehabitɔwo, Naftuhitɔwo, ");
INSERT INTO ewe_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusitɔwo, Kasluhitɔwo (ame siwo me Filistitɔwo dzɔ tso) kple Kaftoritɔwo. ");
INSERT INTO ewe_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaan ƒe viwo dometɔ aɖewoe nye: Sidon, ame si nye eƒe ŋgɔgbevi kple Het. ");
INSERT INTO ewe_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanaan ƒe dzidzimeviwoe nye: Yebusitɔwo, Amoritɔwo, Girgasitɔwo, ");
INSERT INTO ewe_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivitɔwo, Arkitɔwo, Sinitɔwo, ");
INSERT INTO ewe_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvaditɔwo, Zemaritɔwo kple Hamatitɔwo. (Kanaan ƒe dzidzimeviwo kaka ");
INSERT INTO ewe_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","tso Sidon yi Gerar va Gaza, Sodom, Gomora, Adma kple Zeboyim va se ɖe Lasa.) ");
INSERT INTO ewe_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ame siawoe nye Ham ƒe dzidzimeviwo. Wonɔ anyigba geɖewo dzi, eye wonye dukɔ geɖewo. Gbegbɔgblɔ vovovowo nɔ wo si. ");
INSERT INTO ewe_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, ame si nye Yafet nɔvi tsitsitɔ ƒe vie nye Eber. ");
INSERT INTO ewe_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sem ƒe dzidzimeviwoe nye: Elam, Asur, Arfaxad, Lud kple Aram. ");
INSERT INTO ewe_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Aram ƒe dzizimeviwoe nye: Uz, Hul, Geter kple Mas. ");
INSERT INTO ewe_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaxad ƒe vie nye Sela, ame si dzi Eber. ");
INSERT INTO ewe_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Vi eve nɔ Eber si: woawoe nye Peleg kple Yoktan. Peleg gɔmee nye “Memama,” elabena eƒe agbenɔɣi mee woma anyigba na gbe vovovoawo gblɔlawo. ");
INSERT INTO ewe_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktan ƒe viwoe nye: Almodad, Selef, Hazarmavet, Yera, ");
INSERT INTO ewe_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram, Uzal, Dikla, ");
INSERT INTO ewe_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO ewe_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila kple Yobab. Ame siawo katã nye Yoktan ƒe viŋutsuwo. ");
INSERT INTO ewe_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","(Yoktan ƒe dzidzimevi siawo nɔ teƒe si tso Mesa va do ɖe Sefar ƒe ɣetoɖoƒewo gbɔ.) ");
INSERT INTO ewe_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ame siawoe nye Sem ƒe dzidzimeviwo. Woɖo wo ɖe woƒe dukɔwo, gbegbɔgblɔwo kple woƒe nɔƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ame siwo katã woyɔ va yi la nye Noa ƒe dzidzimeviwo, to dzidzime geɖewo me, eye wonɔ dukɔ vovovo siwo dzɔ le tsiɖɔɖɔ megbe la me. ");
INSERT INTO ewe_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Le ɣe ma ɣi me la, amegbetɔƒome blibo la doa gbe ɖeka ko. ");
INSERT INTO ewe_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Esi amewo de asi agbɔsɔsɔ ɖe edzi me la, woɖo ta ɣedzeƒe lɔƒo, eye woke ɖe anyigba aɖe si sɔ la ŋu le Sinar. Eteƒe medidi kura hafi amewo sɔ gbɔ ɖe afi sia o. ");
INSERT INTO ewe_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Wogblɔ na wo nɔewo be, “Miva, mina míame anyikpewo, míaƒo dzo wo nyuie.” Wowɔ anyikpe ŋu dɔ ɖe kpe ŋutɔ teƒe kple aŋɔ yibɔ ɖe anyi teƒe. ");
INSERT INTO ewe_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Woyi edzi gblɔ be, “Miva, mina míatso du na mía ɖokui, eye míawɔ gbetakpɔxɔ kɔkɔ aɖe wòayi aɖatɔ dziƒo, be míaƒe ŋkɔ nade du ne míagakaka ɖe anyigba katã dzi o.” ");
INSERT INTO ewe_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Ke esi Yehowa va kpɔ dua kple mɔ si tum amegbetɔviwo nɔ la, ");
INSERT INTO ewe_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","egblɔ be, “Ne woate ŋu awɔ nu siawo katã fifia, esi wònye azɔ koe wodze sii be gbe ɖeka gblɔm yewole, eye dukɔ ɖeka yewonye la, mibu nu si woava wɔ emegbe la ŋu kpɔ! Naneke meli si woado kpo wɔwɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Mina míaɖi ayi anyigba dzi, eye míatɔtɔ woƒe gbe ale be womagase wo nɔewo gɔme o!” ");
INSERT INTO ewe_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ale Yehowa ka wo katã hlẽ ɖe anyigba blibo la dzi. Ale du la tsotso nu tso. ");
INSERT INTO ewe_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Eya ta wona ŋkɔ du ma be Babel si gɔmee nye, “Tɔtɔ,” elabena afi ma Yehowa tɔtɔ gbe na amewo le, eye wokaka ɖe afi sia afi le anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Esiae nye Sem ƒe ŋutinya. eve le tsiɖɔɖɔ megbe, esime Sem xɔ ƒe alafa ɖeka la, edzi Arfaxad. ");
INSERT INTO ewe_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Esi wòdzi Arfaxad megbe la, eganɔ agbe ƒe alafa atɔ̃ (500), eye wògadzi viŋutsu kple vinyɔnu bubuwo. ");
INSERT INTO ewe_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Esi Arfaxad xɔ ƒe blaetɔ̃ vɔ atɔ̃ la, edzi Sela. ");
INSERT INTO ewe_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Eye esi wòdzi Sela megbe la, Arfaxad ganɔ agbe ƒe alafa ene kple etɔ̃ (403), eye wòdzi viŋutsu kple vinyɔnu bubuwo. ");
INSERT INTO ewe_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Esi Sela xɔ ƒe blaetɔ̃ la, edzi Eber, ");
INSERT INTO ewe_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","eye esi wòdzi Eber megbe la, Sela ganɔ agbe ƒe alafa ene kple etɔ̃ (403), eye wòdzi viŋutsu kple vinyɔnu bubuwo. ");
INSERT INTO ewe_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Esi Eber xɔ ƒe blaetɔ̃-vɔ-ene la, edzi Peleg. ");
INSERT INTO ewe_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Esi wòdzi Peleg la, Eber ganɔ agbe ƒe alafa ene blaetɔ̃ (430), eye wògadzi viŋutsu kple vinyɔnu bubuwo. ");
INSERT INTO ewe_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Esi Peleg xɔ ƒe blaetɔ̃ la, edzi Reu. ");
INSERT INTO ewe_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Eye esi wòdzi Reu la, Peleg ganɔ agbe ƒe alafa eve kple asiekɛ (209), eye wògadzi viŋutsu kple vinyɔnu bubuwo. ");
INSERT INTO ewe_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Esi Reu xɔ ƒe blaetɔ̃-vɔ-eve la, edzi Serug. ");
INSERT INTO ewe_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Eye esi wòdzi Serug la, Reu ganɔ agbe ƒe alafa eve kple adre (207), eye wògadzi viŋutsu kple vinyɔnu bubuwo. ");
INSERT INTO ewe_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Esi Serug xɔ ƒe blaetɔ̃ la, edzi Nahor. ");
INSERT INTO ewe_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Eye esi wòdzi Nahor megbe la, Serug ganɔ agbe ƒe alafa eve (200), eye wògadzi viŋutsu kple vinyɔnu bubuwo. ");
INSERT INTO ewe_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Esi Nahor xɔ ƒe blaeve-vɔ-asiekɛ la, edzi Tera. ");
INSERT INTO ewe_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Eye esi wòdzi Tera la, Nahor ganɔ agbe ƒe alafa ɖeka kple wuiasiekɛ (119), eye wògadzi viŋutsu kple vinyɔnu bubuwo. ");
INSERT INTO ewe_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Esi Tera xɔ ƒe blaadre la, edzi Abram, Nahor kple Haran. ");
INSERT INTO ewe_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera ƒe dzidzimeviwo ŋutinya enye si. Tera dzi Abram, Nahor kple Haran; eye Haran dzi Lot. ");
INSERT INTO ewe_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ke Haran ku kaba le anyigba si dzi wodzii ɖo la dzi si nye Ur le Kaldea le esime fofoa Tera ganɔ agbe ko. ");
INSERT INTO ewe_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ɖe fofoa ƒe vi Sarai le esime nɔvia Nahor ɖe Haran si ku la ƒe vi, Milka. Nɔviŋutsu si nɔ Milka sie nye Yiska. ");
INSERT INTO ewe_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ke Sarai medzi vi aɖeke o. ");
INSERT INTO ewe_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera kplɔ via Abram, eƒe tɔgbuiyɔvi Lot, ame si nye Haran ƒe vi la kple via Abram srɔ̃, Sarai, eye wodzo le Ur le Kaldea be yewoayi Kanaanyigba dzi. Ke wotɔ, eye wotso kɔƒe ɖe Haran. ");
INSERT INTO ewe_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera ku le Haran esi wòxɔ ƒe alafa eve kple atɔ̃ (205). ");
INSERT INTO ewe_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Le Abram fofo ƒe ku megbe la, Yehowa gblɔ na Abram be, “Ʋu le mia de, gblẽ wò ƒometɔwo ɖi, eye nàyi anyigba si mafia wò la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ne èwɔ esia la, mana nàzu dukɔ gã aɖe fofo. Mayra wò, eye mana nàxɔ ŋkɔ. Gawu la, àhe yayra vɛ na ame geɖewo. ");
INSERT INTO ewe_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Mayra ame siwo ayra wò la, eye maƒo fi ade ame sia ame si aƒo fi ade wò la. Woayra xexea me blibo la ɖe tawò.” ");
INSERT INTO ewe_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ale Abram ʋu le wo de abe ale si Yehowa gblɔ nɛ ene. Ekplɔ Lot ɖe asi. Ɣe ma ɣi la, Abram xɔ ƒe blaadre-vɔ-atɔ̃ esi wòdzo le Haran. ");
INSERT INTO ewe_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ekplɔ srɔ̃a, Sarai kple eƒe tɔgãyɔvi Lot ɖe asi, eye wòtsɔ kesinɔnu siwo katã wòkpɔ le Haran, nyiwo kple kluviwo siaa dzoe heyi Kanaan. ");
INSERT INTO ewe_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Esime wonɔ mɔ zɔm to Kanaanyigba dzi la, woɖo teƒe aɖe le Sikem gbɔ. Wotɔ ɖe ati gã aɖe te le More. Kanaantɔwo nɔ anyigba la dzi ɣe ma ɣi. ");
INSERT INTO ewe_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yehowa ɖe eɖokui fia Abram, eye wògblɔ be, “Matsɔ anyigba sia ana wò dzidzimeviwo.” Abram ɖi vɔsamlekpui aɖe ɖe afi ma hena ŋkuɖoɖo ale si Yehowa ɖe eɖokui fiae le afi ma la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Le esia megbe la, Abram dzo le afi sia, eye wòɖo ta anyigbeme lɔƒo, heyi tonyigba si le Betel le ɣetoɖoƒe kple Ai le ɣedzeƒe la dome. Etu agbadɔ kple vɔsamlekpui ɖe afi sia, eye wòdo gbe ɖa na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ale wòyi mɔzɔzɔ dzi ɖɔɖɔɖɔ henɔ anyigbeme yim, henɔ tɔtɔm ɖe teƒewo ɖo ta Negeb. ");
INSERT INTO ewe_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Dɔwuame sesẽ aɖe nɔ anyigba la dzi ɣe ma ɣi, ale Abram yi be yeanɔ Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ke esi wògogo Egipte la, egblɔ na Sarai be wòagblɔ na ame sia ame be ye nɔvinyɔnue yenye! “Èdze tugbe ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Ne Egiptetɔwo kpɔ wò la, woagblɔ be, ‘Srɔ̃ae nye nyɔnu sia, mina míawu ŋutsu la ekema míaxɔ nyɔnu la aɖe!’ ");
INSERT INTO ewe_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ke ne ègblɔ be nɔvinyee yenye la, Egiptetɔwo axɔm nyuie le tawò, eye womawum o!” ");
INSERT INTO ewe_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Le nyateƒe me esi woɖo Egipte la, ame sia ame ɖi ɖase le eƒe tugbedzedze ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Esi fia ƒe subɔlawo kpɔe la, wokafu eƒe tugbedzedze na Fia Farao, eye wokplɔe yi ɖe Farao ƒe aƒe me. ");
INSERT INTO ewe_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Farao tsɔ nunana geɖewo, alẽwo, nyiwo, tedziwo, kluviwo, kosiwo kple kposɔwo na Abram ɖe srɔ̃a Sarai ta. ");
INSERT INTO ewe_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ke Yehowa na dɔvɔ̃ sesẽ aɖe va ge ɖe Farao ƒe aƒe me le Abram srɔ̃ Sarai ƒe aƒea me nɔnɔ ta. ");
INSERT INTO ewe_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ale Farao yɔ Abram va eɖokui gbɔ, eye wòka mo nɛ gblɔ be, “Nu kae nye esi nèwɔ ɖe ŋunye? Nu ka ta mègblɔ nam be ye srɔ̃e o ɖo? ");
INSERT INTO ewe_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Nu ka ta nèɖe mɔ nam be maɖee, eye nègblɔ nam be ye nɔvie ɖo? Kpɔ ɖa, kplɔ srɔ̃wò dzoe le afi sia enumake!” ");
INSERT INTO ewe_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ale Farao nya wo, eye wòna asrafowo dzɔ Abram, srɔ̃a kple woƒe amewo kple woƒe kesinɔnuwo katã ŋu va se ɖe esime wodo go le eƒe anyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ale Abram ʋu le Egipte kple srɔ̃a kpakple Lot kpe ɖe nu siwo katã nɔ wo si la ŋu, eye wozɔ mɔ to Egipte ƒe dzigbeme yi Negeb. ");
INSERT INTO ewe_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram nye kesinɔtɔ gã aɖe: lãwo, klosalo kple sika nɔ esi fũu. ");
INSERT INTO ewe_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Tso Negeb gbegbe la, etso teƒe yi teƒe va se ɖe esime wòva ɖo Betel, teƒe si le Betel kple Ai dome, afi si wòtu agbadɔ ɖo kpɔ ");
INSERT INTO ewe_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","kple afi si wòɖi vɔsamlekpui ɖo kpɔ la. Afi ma Abram yɔ Yehowa ƒe ŋkɔ le. ");
INSERT INTO ewe_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot ame si hã dze Abram yome la nye kesinɔtɔ gã aɖe: alẽwo, nyiwo kple subɔlawo bɔ ɖe esi. ");
INSERT INTO ewe_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ke anyigba la melolo na Abram kple Lot ƒe nyiwo kple alẽwo o: lãawo sɔ gbɔ fũu wu lãnyiƒe la. ");
INSERT INTO ewe_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ale dzre dzɔna ɖe Abram kple Lot ƒe lãkplɔlawo dome enuenu togbɔ be Kanaantɔwo kple Perizitɔwo nɔ anyigba la dzi, eye woate ŋu aho aʋa ɖe Abram kple Lot ŋu gɔ̃ hã hafi. ");
INSERT INTO ewe_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Le esia ta Abram gblɔ na Lot be, “Ele be dzre si dzɔna enuenu ɖe míaƒe amewo dome la nu natso. Mele be memama nanɔ míaƒe ƒomewo dome o. Ele be ɖekawɔwɔ nanɔ mí ame siwo nye ƒometɔwo la dome boŋ. ");
INSERT INTO ewe_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tia anyigba la ƒe akpa si dze ŋuwò la, eye míaklã mɔ. Ne ètia ɣedzeƒe lɔƒo la, ekema manɔ afi sia si nye ɣetoɖoƒe gome. Alo ne ètia ɣetoɖoƒe lɔƒo la, ekema mayi ɣedzeƒe lɔƒo.” ");
INSERT INTO ewe_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot lé ŋku ɖe gbadzaƒe si le Yɔdan tɔsisi la gbɔ la ŋu; tsi bɔ ɖe afi ma. Nya sia dzɔ do ŋgɔ na Yehowa ƒe Sodom kple Gomora tsɔtsrɔ̃. Teƒe la ɖi Edenbɔ la kple anyigba nyui si ƒo xlã Zoar le Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ale Lot tia Yɔdan ƒe balime heɖo ta ɣedzeƒe lɔƒo. Eʋu yi afi ma kple eƒe lãwo kple eƒe subɔlawo, ale eya kple Abram klã mɔ. ");
INSERT INTO ewe_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram tsi Kanaanyigba la dzi esime Lot nɔ du gã siwo nɔ gbadzaƒe la dome; etso nɔƒe ɖe teƒe aɖe si te ɖe Sodom ŋu la. ");
INSERT INTO ewe_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ame siwo nɔ Sodom la nye ame vɔ̃ɖiwo, eye wowɔ nu vɔ̃ geɖewo ɖe Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Le Lot ƒe ʋuʋu megbe la, Yehowa gblɔ na Abram be, “Nye kɔ nàkpɔ didiƒe, tso anyiehe yi dziehe, tso ɣedzeƒe yi ɣetoɖoƒe, afi si nàte ŋu akpɔ aƒo xlã ɖokuiwò, ");
INSERT INTO ewe_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","elabena matsɔ afi sia katã ana wò kple wò dzidzimeviwo. ");
INSERT INTO ewe_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Mana wò dzidzimeviwo nasɔ gbɔ abe ʋuʋudedi ene, ame aɖeke mate ŋu axlẽ wo o! ");
INSERT INTO ewe_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ɖi tsa le anyigba yeye si mele nawòm la ƒe afi sia afi, eye nàlé ŋku ɖe nuwo ŋu.” ");
INSERT INTO ewe_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ale Abram ho eƒe agbadɔ, eye wòyi ati gã siwo le Mamre la gbɔ, teƒe si te ɖe Hebron ŋu, eye wòɖi vɔsamlekpui na Yehowa ɖe afi ma. ");
INSERT INTO ewe_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Azɔ la, aʋa dzɔ le anyigba la dzi. Amrafel, Sinar fia, Ariok, Elasar fia, Kedolaoma, Elam fia kple Tidal, Goyim fia, ");
INSERT INTO ewe_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ho aʋa ɖe Bera, Sodom fia, Birsa, Gomora fia, Sinab, Adma fia, Semeber, Zeboyim fia kple Bela fia (si woyɔna be Zoar la) ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Fia siwo tso Sodom, Gomora, Adma, Seboyim kple Bela la na woƒe aʋakɔwo ƒu asaɖa anyi ɖe Sidom balime si nye (Dzeƒu la ƒe balime.) ");
INSERT INTO ewe_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Wonye Fia Kedolaoma teviwo ƒe wuieve sɔŋ, ke wotso ɖe fia sia ŋu le ƒe wuietɔ̃lia me. ");
INSERT INTO ewe_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Le ƒe wuienelia me la, Kedolaoma kple fia siwo kpe ɖe eŋu la yi ɖasi Refaimtɔwo le Asterot, Karnaimtɔwo kple Zuzitɔwo le Ham, Emitɔwo le Save Kiriataim ");
INSERT INTO ewe_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","kple Horitɔwo le Seir ƒe tonyigba dzi heyi keke El Paran, afi si te ɖe gbegbe la ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Wotrɔ azɔ yi En Misfat (afi si woyɔna egbegbe be Kades la), eye woɖu Amalekitɔwo kple Amoritɔwo, ame siwo nɔ Hazazon Tamar la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Tete fia siwo tso Sodom, Gomora, Adma, Zeboyim kple Bela (si nye Zoar) la yi ɖaƒu asaɖa anyi ɖe Sidim Balime, ");
INSERT INTO ewe_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ɖe Kedolaoma, Elam fia, Tidal, Goyim fia, Amrafel, Sinar fia kple Ariok, Elasar fia ŋu. Fia ene kpe aʋa kple fia atɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ke aŋɔʋe geɖewo nɔ teƒe ma, eye esi Sodom kple Gomora fiawo si yina la, wo dometɔ aɖewo ge dze aŋɔʋeawo me. Ame mamlɛawo si yi toawo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Dziɖulawo ha Sodom kple Gomora ƒe kesinɔnuwo kple nuɖuɖuwo katã heɖo ta aƒe kpli wo. ");
INSERT INTO ewe_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Wolé Lot, ame si nye Abram ƒe tɔgãyɔvi si nɔ Sodom la, eye wokplɔe dzoe kple eƒe kesinɔnuwo katã. ");
INSERT INTO ewe_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ame siwo si la dometɔ ɖeka va ka nya la ta na Abram, Hebritɔ la, esime wònɔ asaɖa me le Mamre si nye Amoritɔ la ƒe ati gãwo te. Mamre nye Eskol kple Aner, ame siwo nɔ Abram dzi la nɔvi. ");
INSERT INTO ewe_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Esi Abram se be woɖe aboyo Lot la, eƒo ƒu ame alafa etɔ̃ kple wuienyi (318) siwo nye aʋawɔlawo la tso eƒe aƒe me, eye wòkplɔ aʋakɔ la ɖo va se ɖe Dan. ");
INSERT INTO ewe_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Wodze aʋakɔ la dzi le zã ma me, eye wonya wo va se ɖe Hoba le Damasko ƒe anyiehe lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Abram xɔ futɔwo ƒe kesinɔnuwo, Lot kple eƒe kesinɔnuwo hekpe ɖe Lot ƒe nyɔnuwo kple ame bubu siwo katã wolé le aʋa la me la ŋu le futɔwo si. ");
INSERT INTO ewe_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Esi Abram trɔ gbɔna tso aʋa si wòho ɖe Kedolaoma kple fia bubuawo ŋu le Save balime (si wogayɔna be Fia ƒe Balime) la, Sodom fia va kpee, ");
INSERT INTO ewe_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","eye Salem fia Melkizedek, ame si nye Mawu, Dziƒoʋĩtɔ la ƒe nunɔla la tsɔ abolo kple wain vɛ nɛ, ");
INSERT INTO ewe_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","eye wòyra Abram gblɔ be, “Mawu Dziƒoʋĩtɔ, dziƒo kple anyigba wɔla nayra Abram, ");
INSERT INTO ewe_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","eye woakafu Mawu Dziƒoʋĩtɔ la, ame si tsɔ wò futɔwo de asi na wò la.” Tete Abraham tsɔ nuawo katã ƒe ewolia nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom fia gblɔ na Abram be, “Ɖe asi le nye ame siwo nèlé la ko ŋu nam, eye nàtsɔ kesinɔnu siwo nèha tso nye du me la faa.” ");
INSERT INTO ewe_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram ɖo eŋu nɛ be, “Mele adzɔgbe ɖem na Yehowa, Mawu Dziƒoʋĩtɔ, ame si wɔ dziƒo kple anyigba la ");
INSERT INTO ewe_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","be nyemaxɔ ɖetika ɖeka gɔ̃ hã le asiwò o, ne menye nenema o la, àva gblɔ be, ‘Abram zu kesinɔtɔ le nu si menae la ta.’ ");
INSERT INTO ewe_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Nu si maxɔ koe anye nu si ɖekakpui siawo ɖu. Ke tsɔ kesinɔnuawo ƒe akpa aɖe na Aner, Eskol kple Mamre, ame siwo kpe ɖe ŋunye le aʋa la wɔwɔ me.” ");
INSERT INTO ewe_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Le nya siawo megbe la, Yehowa ƒo nu na Abram le ŋutega me gblɔ nɛ be, “Mègavɔ̃ o, Abram, elabena nyee nye wò akpoxɔnu, maʋli tawò, eye makɔ yayra geɖewo ɖe dziwò.” ");
INSERT INTO ewe_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ke Abram gblɔ be, “O, Aƒetɔ Yehowa, nu ka nàte ŋu anam esi vi mele asinye o, eye ame si anyi nye domee nye Eliezer tso Damasko?” ");
INSERT INTO ewe_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Eye Abram gblɔ be, “Mèna vi aɖekem o, eya ta nye subɔlae anyi nye dome.” ");
INSERT INTO ewe_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yehowa gblɔ nɛ be, “Ao, ame bubu aɖeke manyi wò dome o, elabena àdzi ŋutsuvi, ame si anyi wò dome.” ");
INSERT INTO ewe_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yehowa kplɔ Abram va xexe le ɣletiɖiɖi nu, eye wògblɔ nɛ be, “Kpɔ dziƒo ɖa, eye nàxlẽ ɣletiviawo, ne àte ŋu axlẽ wo ko. Nenema tututue wò dzidzimeviwo anɔ; ame aɖeke mate ŋu axlẽ wo o!” ");
INSERT INTO ewe_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram xɔ Yehowa dzi se, eye Yehowa bui dzɔdzɔenyenye nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Eye wògblɔ nɛ be, “Nyee nye Yehowa, ame si kplɔ wò tso Ur le Kaldea be matsɔ anyigba sia ana wò tegbetegbe.” ");
INSERT INTO ewe_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ke Abram biae be, “O, Aƒetɔ Yehowa, aleke mawɔ aka ɖe edzi be àtsɔe nam?” ");
INSERT INTO ewe_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Eɖo eŋu nɛ gblɔ be, “Tsɔ nyinɔ si xɔ ƒe etɔ̃, gbɔ̃nɔ si xɔ ƒe etɔ̃, agbo si xɔ ƒe etɔ̃, akpakpa kple ahɔnɛ siwo metsi o la vɛ.” ");
INSERT INTO ewe_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram tsɔ lãawo kple xeawo vɛ nɛ. Efe lãawo me ɖe akpa eve, eye wòtsɔ lãawo ƒe afãwo ɖo ɖe wo nɔewo ŋu le fli ene me, gake mefe xeviawo yame o. ");
INSERT INTO ewe_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Esi akagawo va lãawo ɖu ge la, Abram nya wo. ");
INSERT INTO ewe_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Esi ɣe nɔ to ɖom la, Abram dɔ alɔ̃ yi eme ʋĩi, eye wòkpɔ ŋutega dziŋɔ aɖe. ");
INSERT INTO ewe_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Le ŋutega me la, Yehowa gblɔ nɛ be, “Medi be nànyae kɔtɛe be, woate wò dzidzimeviwo ɖe to abe amedzroviwo ene eye woasubɔ ame mawo le dzronyigba dzi ƒe alafa ene sɔŋ. ");
INSERT INTO ewe_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ke mahe to na dukɔ ma si awɔ wo kluviwoe. Emegbe la, woado le dukɔ ma te kple kesinɔnu geɖewo. ");
INSERT INTO ewe_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Wò la, àku le ŋutifafa me, ne ètsi xɔ ƒe geɖe. ");
INSERT INTO ewe_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Le dzidzime ene megbe la, wò dzidzimeviwo agbɔ ava anyigba sia dzi, elabena ɣe ma ɣi koe Amoritɔwo, ame siwo le anyigba sia dzi fifia la ƒe nu vɔ̃wo asɔ gbɔ na tohehe.” ");
INSERT INTO ewe_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Esi ɣe ɖo to, eye viviti do la, Abram kpɔ ze aɖe si me dzudzɔ nɔ dodom tso kɔlikɔli kple akakati aɖe si nɔ lã kuku fefeawo dome tom. ");
INSERT INTO ewe_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ale Yehowa wɔ nubabla sia kple Abram gbe ma gbe gblɔ be, “Metsɔ anyigba sia si le Egipte tɔsisi la kple Frat tɔsisi gã la dome la na wò dzidzimeviwo. ");
INSERT INTO ewe_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Metsɔ dukɔ siawo hã na wò: Kenitɔwo, Kenizitɔwo, Kadmonitɔwo, ");
INSERT INTO ewe_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hititɔwo, Perizitɔwo, Refaimtɔwo, ");
INSERT INTO ewe_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoritɔwo, Kanaantɔwo, Girgasitɔwo kple Yebusitɔwo.” ");
INSERT INTO ewe_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Vi aɖeke menɔ Sarai kple Abram si o. Ke Egipte nyɔnudɔla aɖe nɔ Sarai si. Eŋkɔe nye Hagar. ");
INSERT INTO ewe_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ale Sarai gblɔ na Abram be, “Yehowa te vim. Yi nàdɔ nye kosi gbɔ, ɖewohĩ mado ƒome to edzi.” Abram lɔ̃ ɖe nya si Sarai gblɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ale esi Abram nɔ Kanaan ƒe ewo megbe la, srɔ̃a, Sarai, tsɔ eƒe Egipte kosi, Hagar na srɔ̃ŋutsua be wòanye srɔ̃a. ");
INSERT INTO ewe_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ale Abram dɔ Hagar gbɔ, eye wòfɔ fu. Esi Hagar kpɔ be yefɔ fu la, dadagbɔgbɔ aɖe va ɖo eme, eye megabua eƒe aƒenɔ Sarai o. ");
INSERT INTO ewe_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Le esia ta Sarai gblɔ na Abram be, “Wò vodadae na be nye kosi la doa vlom, togbɔ be nye ŋutɔe tsɔe na wò hã. Yehowa nadrɔ̃ ʋɔnu le nye kpli wò dome.” ");
INSERT INTO ewe_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram ɖo eŋu be, “Meɖe mɔ na wò be nàhe to na kosi la ale si nèbu be edze.” Ale Sarai wɔ funyafunya Hagar ale gbegbe be wòsi dzo. ");
INSERT INTO ewe_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yehowa ƒe dɔla aɖe kpɔe wòtsi tsitre ɖe vudo aɖe to le Sur mɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ale wòbiae be, “Hagar, Sarai ƒe kosi, afi ka nètso, eye afi ka yim nèle?” Hagar ɖo eŋu be, “Sisim mele le nye aƒenɔ nu.” ");
INSERT INTO ewe_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Yehowa ƒe dɔla la yi edzi gblɔ nɛ be, “Trɔ nàyi wò aƒenɔ gbɔ, eye nàbɔbɔ ɖokuiwò nɛ, ");
INSERT INTO ewe_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","elabena mana dukɔ gã aɖe nado tso mewò. ");
INSERT INTO ewe_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Fifia, èfɔ fu; àdzi ŋutsuvi. Na ŋkɔe be Ismael, si gɔmee nye, ‘Mawu see,’ elabena Yehowa se wò konyifafa. ");
INSERT INTO ewe_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Viwò sia anye vi dzeaglã aɖe, eye wòawɔ nu glalaglalã abe tedzi dzeaglã ene! Atsi tsitre ɖe ame sia ame ŋu, eye nenema ke ame sia ame hã atsi tsitre ɖe eŋu. Ke hã la, anɔ teƒe ɖeka kple nɔvia bubuawo.” ");
INSERT INTO ewe_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hagar bia eɖokui be, “Ɖe mekpɔ Mawu ŋkume kple ŋkume hafi gale agbe be maƒo nu tso eŋua?” Eya ta eyɔ Yehowa ame si ƒo nu kpli la be, “Mawu si kpɔa nu.” ");
INSERT INTO ewe_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Emegbe la, wona ŋkɔ vudo ma be Beer Lahai Roi si gɔmee nye, “Ame si le agbe, eye wòkpɔm la ƒe vudo.” Ele Kades kple Bered dome. ");
INSERT INTO ewe_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hagar dzi ŋutsuvi na Abram, eye Abram na ŋkɔe be Ismael. ");
INSERT INTO ewe_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram xɔ ƒe blaenyi-vɔ-ade esi Hagar dzi Ismael nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Esi Abram xɔ ƒe blaasiekɛ-vɔ-asiekɛ la, Yehowa ɖe eɖokui fiae gblɔ nɛ be, “Nyee nye Mawu Ŋusẽkatãtɔ la. Ɖo tom, eye nànɔ agbe abe ale si dze ene. ");
INSERT INTO ewe_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Maɖo kpe nubabla si le nye kpli wò dome la dzi, eye miadzi ɖe edzi fũu.” ");
INSERT INTO ewe_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abram tsyɔ mo anyi, eye Mawu gblɔ nɛ be, ");
INSERT INTO ewe_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nye la, esiae nye nye nubabla kpli wò: ànye dukɔ geɖewo fofo.” ");
INSERT INTO ewe_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Mawu yi edzi be, “Wò ŋkɔ maganye Abram o, ke boŋ ezu Abraham, elabena meɖo wò dukɔ geɖewo fofoe. ");
INSERT INTO ewe_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Mana dzidzimevi akpe akpewo wò, eye woazu dukɔ geɖewo! Fiawo anɔ wò dzidzimeviwo dome! ");
INSERT INTO ewe_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Mana nye nubabla nazu nubabla mavɔ le nye kpli wò kple wò dzidzimeviwo dome hena dzidzime siwo gbɔna la, be manye wò Mawu kple Mawu na wò dzidzimeviwo. ");
INSERT INTO ewe_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kanaanyigba blibo la, afi si nèle fifia abe amedzro ene la, matsɔe na wò wòanye tɔwò kple wò dzidzimeviwo tɔ tegbetegbe, eye manye woƒe Mawu.” ");
INSERT INTO ewe_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Eye Mawu gblɔ na Abraham be, “Ele na wò be nàlé nye nubabla me ɖe asi, wò kple wò dzidzimeviwo le dzidzime siwo ava la me. ");
INSERT INTO ewe_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Esia nye nye nubabla kpli wò kple wò dzidzimeviwo, nubabla si mialé be na le mia dome lae nye be: Woatso aʋa na ŋutsu sia ŋutsu le mia dome. ");
INSERT INTO ewe_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Woaɖe miaƒe aʋanuyiwo ɖa. Esia anye dzesi be wò kple wò dzidzimeviwo siaa miexɔ nubabla sia. ");
INSERT INTO ewe_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Woatso aʋa na ŋutsuvi ɖe sia ɖe le gbe si gbe wodzii la ƒe ŋkeke enyia gbe. Woatso aʋa na wò kluvi siwo nèƒle kple ga alo wo ƒe viwo kple wò ŋutɔ wò dzidzimeviwo siaa. Esia nye nubabla ƒe akpa si anɔ anyi tegbee, eye wòanye dɔdeasi na wò dzidzimeviwo katã. ");
INSERT INTO ewe_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ele be woatso aʋa na ame sia ame. Ele be woato mɔ sia nu ade dzesi miaƒe ŋutilã be mianye gomekpɔlawo le nye nubabla mavɔ la me. ");
INSERT INTO ewe_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Woaɖe ame sia ame si metso aʋa o la ɖa le eƒe ƒometɔwo dome, elabena mewɔ nye nubabla la dzi o.” ");
INSERT INTO ewe_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Mawu yi edzi gblɔ na Abraham be, “Womagayɔ srɔ̃wò be Sarai o, ke boŋ woayɔe azɔ be, ‘Sara’ si gɔmee nye ‘Fiavinyɔnu.’ ");
INSERT INTO ewe_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Mayrae, eye mana wòadzi ŋutsuvi na wò! Ɛ̃, makɔ yayra geɖe ɖe edzi, eye mana wòazu dukɔ geɖewo dada! Fia geɖewo anɔ miaƒe dzidzimeviwo dome.” ");
INSERT INTO ewe_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Esi Abraham se nya siawo la, etsyɔ mo anyi ɖe Yehowa ŋkume. Eko nu le eɖokui me le dzimaxɔse ta, hebia eɖokui be, “Ɖe nye ame si xɔ ƒe alafa ɖeka la, magate ŋu azu fofo, eye Sara ame si xɔ ƒe blaasiekɛ la agate ŋu adzi via?” ");
INSERT INTO ewe_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham gblɔ na Mawu be, “Meɖe kuku, yra Ismael nam ko!” ");
INSERT INTO ewe_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mawu ɖo eŋu be, “Ao, menye nenemae megblɔ o. Sara adzi ŋutsuvi na wò, eye miana ŋkɔe be, Isak si gɔmee nye ‘Nukoko.’ Mabla nu kple eya kple eƒe dzidzimeviwo tegbetegbe. ");
INSERT INTO ewe_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Melɔ̃ be mayra Ismael hã abe ale si nèbiae ene. Mana wòadzi asɔ gbɔ, eye wòazu dukɔ gã aɖe. Fiavi ŋutsuvi wuieve anɔ eƒe dzidzimeviwo dome. ");
INSERT INTO ewe_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ke nye nubabla le nye kple Isak dome, ame si Sara adzi na wò le ƒe si gbɔna la ƒe ɣe aleawo ɣi.” ");
INSERT INTO ewe_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ale Abraham kple Mawu ƒe dzeɖoɖo wu enu, eye Mawu dzo. ");
INSERT INTO ewe_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Gbe ma gbe ke la, Abraham tso aʋa na via, Ismael kple ŋutsuvi bubu ɖe sia ɖe si wodzi ɖe eƒe aƒe me alo ƒle kple ga va eƒe aƒe me abe ale si Mawu ɖo nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Le ɣe ma ɣi me la, Abraham xɔ ƒe blaasiekɛ-vɔ-asiekɛ hafi wotso aʋa nɛ, ");
INSERT INTO ewe_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","eye Via ŋutsuvi, Ismael, xɔ ƒe wuietɔ̃ hafi wotso aʋa nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Wotso aʋa na Abraham kple Via ŋutsuvi, Ismael, le ŋkeke ɖeka ma dzi. ");
INSERT INTO ewe_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Eye wotso aʋa na ŋutsu ɖe sia ɖe le Abraham ƒe aƒe me, ame si wodzi le eƒe aƒe me kple kluvi si woƒle le amedzro aɖe si siaa. ");
INSERT INTO ewe_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Yehowa gaɖe eɖokui fia Abraham esime Abraham nɔ ati gãwo te le Mamre. Le dzomeŋɔli ƒe ɣetrɔ aɖe, esime xexea me xɔ dzo la, Abraham nɔ eƒe agbadɔ ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Kasia ekpɔ ŋutsu etɔ̃ gbɔna egbɔ. Etsi tsitre enumake, ƒu du yi ɖakpe wo, eye wòdo dzaa na wo. ");
INSERT INTO ewe_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Egblɔ be, “Ne miave nunye la, nye aƒetɔ, ekema migato miaƒe dɔla ŋu yi o. ");
INSERT INTO ewe_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Mina woaku tsi vi aɖe vɛ miaklɔ afɔe, eye miaɖi ɖe eme sẽe le ati sia te, ");
INSERT INTO ewe_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","eye madi nane na mi miaɖu be wòado ŋusẽ mi. Mitɔ vie hafi miagayi miaƒe mɔzɔzɔ dzi.” Amedzroawo ɖo eŋu be, “Enyo; wɔ abe ale si nègblɔ ene.” ");
INSERT INTO ewe_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham ƒu du yi eƒe agbadɔ me, eye wògblɔ na Sara be, “Netsɔ! Tɔ tatalĩ! Kɔ wò wɔ nyuitɔ, eye nàtɔ tatalia wòasu na wo ame etɔ̃!” ");
INSERT INTO ewe_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Emegbe la, eƒu du yi nyihawo me, lé nyivi dami aɖe, eye wògblɔ na eƒe subɔla aɖe be wòawui enumake. ");
INSERT INTO ewe_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Eteƒe medidi o, etsɔ notsi babla kple notsi tsitɔ kple nyilã meme ɖo akɔme na wo. Enɔ atiawo te le amedzroawo gbɔ esime wonɔ nua ɖum. ");
INSERT INTO ewe_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Wobiae be, “Afi ka srɔ̃wò, Sara le?” Abraham ɖo eŋu be, “Ele agbadɔ me.” ");
INSERT INTO ewe_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Wo dometɔ ɖeka gblɔ be, “Yehowa gblɔ be, ‘Le ƒe si gbɔna me la, srɔ̃wò Sara adzi ŋutsuvi’ ” Sara nɔ agbadɔ me le Abraham megbe nɔ nya siawo sem. ");
INSERT INTO ewe_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Azɔ la, Abraham kple Sara tsi ŋutɔ, eye Sara ƒe vidziɣi va yi xoxoxo. ");
INSERT INTO ewe_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Nu sia na Sara ko nu le ta me, eye wògblɔ na eɖokui be, “Nyɔnu tsitsi abe nye ene nagadzi vi kple srɔ̃nye tsitsi sia?” ");
INSERT INTO ewe_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Yehowa gblɔ na Abraham be, “Nu ka ta Sara ko nu ɖo? Nu ka ta wògblɔ be, ‘Ɖe nyɔnu tsitsi abe nye ene ate ŋu adzi via?’ ");
INSERT INTO ewe_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ɖe nane sesẽ akpa na Yehowa? Le ƒe si gbɔna me, abe ale si megblɔ na wò xoxo ene la, Sara adzi ŋutsuvi.” ");
INSERT INTO ewe_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ke Sara da alakpa be, “Nyemeko nu o,” elabena evɔ̃. Ke egblɔ nɛ be, “O! Èko nu.” ");
INSERT INTO ewe_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Le esia megbe la, ameawo dze mɔ ɖo ta Sodom, eye Abraham dze wo yome ɖaɖo wo ɖa. ");
INSERT INTO ewe_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yehowa gblɔ le eɖokui me be, “Ɖe maɣla nye ɖoɖowo ɖe Abraham mahã? ");
INSERT INTO ewe_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Eyae azu dukɔ gã aɖe, eye wòahe yayra vɛ na dukɔwo katã le anyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Kpe ɖe esia ŋu la, metiae be eƒe dzidzimeviwo nanye mawuvɔ̃lawo, ame siwo anye ame dzɔdzɔewo kple nuteƒewɔlawo, ale be mate ŋu awɔ nu siwo katã ŋugbe medo nɛ la.” ");
INSERT INTO ewe_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ale Yehowa gblɔ na Abraham be, “Mese be Sodomtɔwo kple Gomoratɔwo nye nu vɔ̃ wɔlawo, eye nu sia nu si woawɔ la nye nu vɔ̃ɖi. ");
INSERT INTO ewe_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Mele teƒe mawo yim be manya ne nya siawo nye nyateƒe alo aʋatso. Ekema manya nu si mawɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ameawo trɔ ɖo ta Sodom, ke Abraham ya tɔ ɖe Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Tete Abraham te ɖe eŋu hebiae be, “Ɖe nàtsrɔ̃ ame dzɔdzɔewo kpe ɖe ame vɔ̃ɖiwo ŋua? ");
INSERT INTO ewe_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ne àkpɔ ame dzɔdzɔe blaatɔ̃ le dua me ɖe, ɖe nàtsrɔ̃ du blibo la, eye màkpɔ nublanui le ame dzɔdzɔe blaatɔ̃awo ta oa? ");
INSERT INTO ewe_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Esia masɔ o! Meka ɖe edzi be màwɔ nu ma tɔgbi, awu ame dzɔdzɔewo kple ame vɔ̃ɖiwo siaa o! Nu ka ta nàhe to na ame dzɔdzɔewo kple ame vɔ̃ɖiwo siaa ɖekae ɖo? Eme kɔ ƒãa be màwɔ nenema o! Ɖe xexea me blibo la ƒe Ʋɔnudrɔ̃la mawɔ nu dzɔdzɔe oa?” ");
INSERT INTO ewe_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Yehowa ɖo eŋu be, “Ne makpɔ ame dzɔdzɔe blaatɔ̃ le Sodom dua me la, ekema mave du blibo la nu ɖe ame dzɔdzɔeawo ta.” ");
INSERT INTO ewe_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham gagblɔ be, “Togbɔ be menye ʋuʋudedi kple afi ko hã la, esi medze nuƒoƒo kple wò Aƒetɔ la gɔme xoxo ta la, ɖe mɔ nam mayi edzi ko. ");
INSERT INTO ewe_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ne àkpɔ ame blaene-vɔ-atɔ̃ ko ɖe, ɖe nàtsrɔ̃ du la ɖe ame atɔ̃ makpɔmakpɔ ta?” Yehowa gblɔ be, “Ne makpɔ ame dzɔdzɔe blaene-vɔ-atɔ̃ la, nyematsrɔ̃ du la o.” ");
INSERT INTO ewe_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Tete Abraham gayi edzi be, “Ne ame dzɔdzɔe blaene koe li ɖe?” Yehowa ɖo eŋu be, “Ne makpɔ ame dzɔdzɔe blaene la, nyematsrɔ̃ du la o.” ");
INSERT INTO ewe_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham gblɔ be, “Meɖe kuku, mègana dzi naku wò o; ɖe mɔ nam maƒo nu. Nenye ame blaetɔ̃ koe nàkpɔ le afi ma ɖe?” Yehowa ɖo eŋu be, “Ne makpɔ ame dzɔdzɔe blaetɔ̃ pɛ ko la, nyematsrɔ̃ du la o.” ");
INSERT INTO ewe_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abraham yi edzi be, “Zi ale si medo dzi ƒo nu kple Yehowa ko la, na mayi edzi ko. Nenye ame blaeve koe ɖe?” Yehowa ɖo eŋu be, “Ekema nyematsrɔ̃ du la o, ɖe ame blaeve mawo ta.” ");
INSERT INTO ewe_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Mlɔeba la, Abraham gblɔ be, “O, Yehowa, mègado dɔmedzoe o; nya ɖeka sia pɛ koe gale asinye, nenye be ame dzɔdzɔe ewo pɛ ko nàkpɔ ɖe?” Yehowa ɖo eŋu be, “Ekema le ame ewo mawo ta la, nyematsrɔ̃ du la o.” ");
INSERT INTO ewe_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Esi Yehowa wu nya siawo gbɔgblɔ kple Abraham nu la, edzo, eye Abraham trɔ yi eƒe agbadɔ me. ");
INSERT INTO ewe_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Gbe ma gbe ke ƒe fiẽ la, mawudɔla eveawo va ɖo Sodom ƒe agbo nu, eye Lot nɔ afi ma ɣe ma ɣi. Esi Lot kpɔ wo la, etsi tsitre be yeakpe wo, eye wòdo dzaa na wo. ");
INSERT INTO ewe_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Egblɔ na wo be, “Nye amegãwo, miva dze gbɔnye le zã sia me, eye miaklɔ miaƒe afɔwo ŋu. Miate ŋu ayi miaƒe mɔzɔzɔ dzi etsɔ ŋdi kanya.” Wogblɔ be, “Ao, akpe na wò, míadzudzɔ le ablɔ dzi le afi sia ko.” ");
INSERT INTO ewe_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ke Lot ƒoe ɖe wo nu va se ɖe esime woyi eƒe aƒe me, eye wòɖo kplɔ̃ gã aɖe na wo kple abolo si wowɔ teti kple amɔ maʋamaʋã. Esi woɖu nu vɔ, ");
INSERT INTO ewe_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","eye wodi be yewoaɖo xɔ la, Sodom ŋutsuwo, ɖekakpuiwo kple ame tsitsiwo siaa tso dua ƒe akpa sia akpa va ƒo xlã aƒe la, ");
INSERT INTO ewe_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","eye woɖe gbe na Lot be, “Kplɔ ŋutsu mawo vɛ na mí be míadɔ kpli wo.” ");
INSERT INTO ewe_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot tu ʋɔ ɖe amedzroawo nu, eye wòyi wo gbɔ ");
INSERT INTO ewe_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ɖaɖe kuku na wo be, “Nɔvinyewo, migawɔ nu baɖa sia tɔgbi o. ");
INSERT INTO ewe_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Mikpɔ ɖa, ɖetugbi eve siwo menya ŋutsu haɖe o la le asinye. Maɖe asi le wo ŋu na mi be miawɔ nu sia nu si adze mia ŋu la kpli wo. Ke migawɔ naneke amedzro siawo ya o, elabena nye dzikpɔkpɔ te wole.” ");
INSERT INTO ewe_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Wodo ɣli sesĩe be, “He ɖa le afi ma! Ame kae nèbu be yenye? Míeɖe mɔ na Lot be wòanɔ mía dome abe amedzro ene, ke azɔ la, ele didim be yeagblɔ nu si míawo míawɔ la na mí! Míawɔ nu vevi wò wu nu si míawɔ ame mawo.” Wolũ ɖe Lot dzi, eye wode asi ʋɔtrua gbagbã me. ");
INSERT INTO ewe_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ke mawudɔla eveawo ʋu ʋɔa, do asi ɖa, he Lot va xɔa me, tu ʋɔa, ");
INSERT INTO ewe_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","eye wona Sodomtɔwo ƒe ŋkuwo dzi tsyɔ sẽe, ale be womegate ŋu kpɔ ʋɔtru la o. ");
INSERT INTO ewe_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Mawudɔlawo bia Lot be, “Wò ƒometɔ kawoe le du sia me? Na woawo ŋutɔ, wo viŋutsuwo, wo vinyɔnuwo, wo toyɔviwo kple lɔ̃xoyɔviwo kple woƒe ƒometɔ bubuawo katã nadzo le du sia me, ");
INSERT INTO ewe_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","elabena míele du sia tsrɔ̃ ge keŋkeŋ. Nutsotso tso teƒe sia ŋu va ɖo dziƒo, eya ta Yehowa ɖo mí ɖa be míatsrɔ̃e.” ");
INSERT INTO ewe_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Nu sia na Lot ɖe abla yi ɖagblɔ na viawo srɔ̃wo be, “Netsɔ na mi miado go le du sia me, elabena Yehowa le du sia tsrɔ̃ ge.” Ke toawo bui ko abe ahatso kam wòle ene. ");
INSERT INTO ewe_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Le fɔŋli la, mawudɔlawo gblɔ na Lot be, “Netsɔ na wò, nàkplɔ srɔ̃wò kple viwò nyɔnuvi eve siwo le afi sia la, eye miasi adzo, ne menye nenema o la, miatsrɔ̃ le du sia tsɔtsrɔ̃ me.” ");
INSERT INTO ewe_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Esi Lot nɔ hehem ɖe megbe la, mawudɔlawo lé eya ŋutɔ, srɔ̃a kple viawo ƒe alɔnu, eye wohe wo yi dua godo, afi si woanɔ dedie le, elabena Yehowa kpɔ nublanui na wo. ");
INSERT INTO ewe_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Mawudɔlawo gblɔ na wo be, “Miɖe abla miaɖe miaƒe agbe, eye migakpɔ megbe o. Misi yi toawo dzi, miganɔ gbadzaƒe le afi sia o. Ne menye nenema o la, miatsrɔ̃.” ");
INSERT INTO ewe_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Lot gblɔ na wo be, “O, nye Aƒetɔwo, meɖe kuku na mi. ");
INSERT INTO ewe_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Esi mieve nunye alea, eye mieɖe nye agbe ta la, mina masi ayi du sue kemɛ ɖa me boŋ, elabena mele vɔvɔ̃m be dzɔgbevɔ̃e aɖe ava ɖi kpem le toawo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kpɔ ɖa, du la medidi tso afi sia kura o, eye du sue aɖe koe. Meɖe kuku mina mayi afi ma boŋ. Miekpɔ ale si wònye du sue aɖe oa? Matsi agbe le afi ma.” ");
INSERT INTO ewe_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mawudɔlawo dometɔ ɖeka gblɔ be, “Enyo, mexɔ wò nya la, eye nyematsrɔ̃ du sue ma o. ");
INSERT INTO ewe_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Gake miɖe abla! Elabena nyemate ŋu awɔ naneke o, va se ɖe esime miaɖo afi ma.” (Tso gbe ma gbe dzi la, woyɔa du sue ma be Zoar ɖe ƒe suẽnyenye ta.) ");
INSERT INTO ewe_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ɣe nɔ dzedzem esi Lot ɖo Zoar. ");
INSERT INTO ewe_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tete Yehowa na dzo kple aŋɔ xɔdzo dza tso dziƒo ɖe Sodom kple Gomora dzi, ");
INSERT INTO ewe_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","gblẽ wo kple du gã kple du sue siwo nɔ gbadzaƒe la, eye amewo, atiwo kple lãwo siaa tsrɔ̃ keŋkeŋ. ");
INSERT INTO ewe_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ke Lot srɔ̃ nye kɔ kpɔ megbe, eye wòtrɔ zu dzekɔ. ");
INSERT INTO ewe_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Gbe ma gbe ŋdi la, Abraham fɔ kaba, eye wòɖe abla yi teƒe si wòtsi tsitre ɖe Yehowa ƒe ŋkume le la. ");
INSERT INTO ewe_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ekpɔ Sodom kple Gomora lɔƒo ɖa, eye wòkpɔ be dzudzɔ nɔ tutum kɔlikɔli tso afi ma abe kpodzo gã aɖe me wònɔ dodom tso ene. ");
INSERT INTO ewe_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ale Mawu se Abraham ƒe kukuɖeɖe, ena Lot nɔ dedie, eye wòɖee tso ku kple tsɔtsrɔ̃ siwo ƒo xlã Sodom, Gomora kple du siwo ƒo xlã wo la me. ");
INSERT INTO ewe_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Emegbe la, Lot dzo le Zoar, elabena enɔ afi ma tɔwo vɔ̃m, eye wòyi ɖanɔ agado aɖe me le toawo dzi kple via nyɔnuvi eveawo. ");
INSERT INTO ewe_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Gbe ɖeka la, nyɔnuvi tsitsitɔ gblɔ na nɔvia be, “Ŋutsu aɖeke kura mele anyigba sia ƒe akpa sia lɔƒo si mía fofo alɔ̃ be míaɖe o. Kpe ɖe esia ŋu la, esusɔ vie mía fofo natsi akpa na vidzidzi. ");
INSERT INTO ewe_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Na míana mía fofo nano wain amu, eye wòadɔ mía gbɔ, ale be míate ŋu adzi vi, eye míaƒe dzidzime nu matso o.” ");
INSERT INTO ewe_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ale wona wain wo fofo wòno hemu. Nyɔnuvi tsitsitɔ yi ɖamlɔ fofoa gbɔ, eye fofoa dɔ kplii, gake fofoa menya o. ");
INSERT INTO ewe_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Le ŋdi me la, nyɔnuvi tsitsitɔ gblɔ na nɔvia be, “Medɔ fofonye gbɔ le zã si va yi la me. Na míagana ahae wòagano amu, eye wò hã nàyi aɖamlɔ egbɔ, ale be míaƒe ƒome la nadzi ɖe edzi.” ");
INSERT INTO ewe_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ale wona wo fofo gamu aha gbe ma gbe fiẽ hã, eye nyɔnuvi suetɔ hã yi ɖamlɔ egbɔ. Fofoa dɔ eya hã gbɔ, ke fofoa menya o. ");
INSERT INTO ewe_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ale nɔvi eveawo fɔ fu na wo fofo Lot. ");
INSERT INTO ewe_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nyɔnuvi tsitsitɔ dzi ŋutsuvi, eye wòna ŋkɔe be Moab; eyae nye Moab dukɔa tɔgbui. ");
INSERT INTO ewe_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nyɔnuvi suetɔ hã dzi ŋutsuvi, eye wòna ŋkɔe be Ben Ami; eyae nye Amonitɔwo tɔgbui. ");
INSERT INTO ewe_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Azɔ Abraham ʋu tso Negeb yi dziehe lɔƒo, eye wòyi ɖanɔ Kades kple Sur dome. Gbe ɖeka esi wòɖi tsa yi Gerar du me la, ");
INSERT INTO ewe_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","egblɔ be ye nɔvinyɔnue nye Sara! Gerar fia Abimelek na wokplɔ Sara vɛ nɛ le eƒe fiasã me. ");
INSERT INTO ewe_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ke le zã ma me la, Mawu ɖe eɖokui fia Abimelek le drɔ̃e me hegblɔ nɛ be, “Èle kuku ge godoo, elabena nyɔnu si wokplɔ vɛ na wò la, ame srɔ̃e.” ");
INSERT INTO ewe_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ke Abimelek medɔ Sara gbɔ haɖe o, eya ta wògblɔ be, “Aƒetɔ, ɖe nàwu ame dzɔdzɔea? ");
INSERT INTO ewe_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham gblɔ nam be, ‘Nɔvinye nyɔnue,’ eye nyɔnu la hã gblɔ nam be, ‘Ɛ̃, nɔvinye ŋutsue.’ Nyemedi kura be mawɔ nu vɔ̃ o.” ");
INSERT INTO ewe_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mawu ɖo eŋu be, “Ɛ̃, menyae nenema, eya ta mekpɔ egbɔ be mèwɔ nu vɔ̃ ɖe ŋunye o. Esia tae nyemeɖe mɔ na wò be nàka asi eŋu o ɖo. ");
INSERT INTO ewe_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Gbugbɔe ɖo ɖe srɔ̃a kaba! Srɔ̃a ado gbe ɖa ɖe tawò, elabena nyagblɔɖilae, ekema ànɔ agbe. Ke ne mèɖoe ɖe srɔ̃a o la, ekema nyae be mi kple aƒewòmetɔwo katã miaku.” ");
INSERT INTO ewe_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Fia Abimelek fɔ ŋdi kanya, yɔ eŋume veviwo katã ƒo ƒui, eye wòka nya la ta na wo. Vɔvɔ̃ ɖo ame sia ame le ƒuƒoƒea. ");
INSERT INTO ewe_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelek yɔ Abraham, eye wògblɔ be “Nu kae nye esi nèwɔ ɖe mía ŋu? Aleke gbegbe meda voe ɖe ŋuwò be nèna fɔɖiɖi gã sia va nye kple nye fiaɖuƒe dzi? Èwɔ nu si womewɔna o la ɖe ŋunye.” ");
INSERT INTO ewe_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Eye Abimelek bia Abraham be, “Nu ka ta nèwɔ nu sia ɖo?” ");
INSERT INTO ewe_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham ɖo eŋu be, “Megblɔ na ɖokuinye be, ‘Eme kɔ ƒãa be Mawuvɔvɔ̃ aɖeke mele afi sia o, eye woawum ɖe srɔ̃nye ta.’ ");
INSERT INTO ewe_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Kpe ɖe esia ŋu la, nɔvinye nyɔnu tututue, fofonye vie, ke menye danye vie o, eye wònye srɔ̃nye hã. ");
INSERT INTO ewe_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Esi Mawu ɖo nam be maʋu le mía de la, megblɔ na srɔ̃nye be, ‘Afi sia afi si míaɖo la, ve nunye nàgblɔ be nɔvinye nyɔnue yenye.’ ” ");
INSERT INTO ewe_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Fia Abimelek tsɔ alẽwo, nyiwo kple dɔlaŋutsuwo kple dɔlanyɔnuwo na Abraham, eye wògbugbɔ srɔ̃a, Sara, nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Fia Abimelek gblɔ na Abraham be, “Lé ŋku ɖe nye fiaɖuƒe la ŋu, eye nàtia afi sia afi si nàdi be yeanɔ la.” ");
INSERT INTO ewe_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Emegbe la, etrɔ ɖe Sara ŋu gblɔ nɛ be, “Kpɔ ɖa, metsɔ klosalo akpe ɖeka na ‘nɔviwò ŋutsua’ be makpatae, eye maɖe ŋukpe ɖa le mo na wò le gbɔwòviwo katã ŋkume. Fifia dzɔdzɔenyenye va aƒe.” ");
INSERT INTO ewe_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abraham do gbe ɖa be Mawu nayɔ dɔ Abimelek srɔ̃ kple eƒe dɔlanyɔnuwo ale be woate ŋu adzi vi azɔ, ");
INSERT INTO ewe_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","elabena Yehowa xe woƒe vidzidɔwo be yeahe to na Abimelek ɖe ale si wòxɔ Abraham srɔ̃ Sara la ta. ");
INSERT INTO ewe_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Azɔ Yehowa ve Sara nu abe ale si wògblɔ ene, eye Yehowa wɔ eƒe ŋugbedodo dzi na Sara. ");
INSERT INTO ewe_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara fɔ fu, eye wòdzi ŋutsuvi na Abraham le eƒe amegãkuku me ɖe ɣeyiɣi si dzi tututu Mawu do ŋugbe nɛ la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham na ŋkɔ ɖevi si Sara dzi nɛ la be, Isak si gɔmee nye, “Nukoko.” ");
INSERT INTO ewe_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Esi via, Isak, xɔ ŋkeke enyi la, Abraham tso aʋa nɛ abe ale si Mawu ɖo nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham xɔ ƒe alafa ɖeka esi wodzi Isak nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tete Sara gblɔ be, “Mawu do nukokoe nam. Ame sia ame si ase nye nya sia la akpɔ dzidzɔ kplim. ");
INSERT INTO ewe_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Elabena ame kae abui kpɔ be nye Sara hã madzi vi? Ke medzi ŋutsuvi na Abraham le eƒe tsitsime!” ");
INSERT INTO ewe_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Ɖevi la tsi, eye wotso no nɛ. Gbe si gbe wotso no na Isak la, Abraham ɖo kplɔ̃ gã aɖe le dzidzɔɣeyiɣi sia dzi. ");
INSERT INTO ewe_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ke esi Sara kpɔ Ismael, Abraham kple Egipte nyɔnu, Hagar ƒe vi wònɔ Isak kom la, ");
INSERT INTO ewe_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","egblɔ na Abraham be, “Na kosivi ma kple via nadzo le afi sia. Via manyi wò dome kple vinye Isak gbeɖegbeɖe o.” ");
INSERT INTO ewe_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Nu sia na Abraham tɔtɔ ŋutɔ, elabena via kee nye Ismael hã. ");
INSERT INTO ewe_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ke Mawu gblɔ na Abraham be, “Mègatɔtɔ o, eye mègaxa nu le ŋutsuvi la kple srɔ̃wò kosi la ta o. Wɔ nu si Sara ɖo na wò la, elabena Isak me wò dzidzimeviwo adzɔ tso. ");
INSERT INTO ewe_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ke mana nyɔnu kosivi ƒe vi la hã ƒe dzidzimeviwo nazu dukɔ gã aɖe, elabena viwò eya hã nye.” ");
INSERT INTO ewe_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ale Abraham fɔ ŋdi kanya, tsɔ nuɖuɖu kple tsi na Hagar, eye wòdo mɔ eya kple wo vi Ismael. Hagar zɔ mɔ kple via yi gbedzi le Beerseba. Menya afi si tututu wòyina o. ");
INSERT INTO ewe_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Esi tsia vɔ la, etsɔ ɖevi la mlɔ ati kpɔyɔe aɖe te, ");
INSERT INTO ewe_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","eye wòyi ɖanɔ anyi ɖe adzɔge abe abɔ alafa ɖeka lɔƒo ene tso ɖevi la gbɔ. Egblɔ be, “Nyemedi be manɔ ɖevi la kpɔm wòaku o,” eye wòde asi avifafa me hehehe. ");
INSERT INTO ewe_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Tete Mawu se ɖevi la ƒe avifafa, eye mawudɔla aɖe yɔ Hagar tso dziƒo gblɔ nɛ be, “Hagar, nya kae dzɔ? Mègavɔ̃ o! Mawu se ɖevi la ƒe avifafa le afi si wòmlɔ la. ");
INSERT INTO ewe_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Yi nàtsɔ ɖevi la, eye nàfa akɔ nɛ, elabena mawɔ eƒe dzidzimeviwo woazu dukɔ gã aɖe.” ");
INSERT INTO ewe_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Mawu ʋu Hagar ƒe ŋkuwo, eye wòkpɔ vudo aɖe le afi ma. Eku tsi ɖe eƒe tsigolo me, eye wòna ɖe ɖevi la wòno. ");
INSERT INTO ewe_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Mawu nɔ kple ɖevi la, eye wòtsi. Enɔ gbedzi, eye wòzu aŋutrɔdala. ");
INSERT INTO ewe_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Esi wònɔ Paran Gbegbe la, dadaa ɖe srɔ̃ nɛ tso Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Le ɣeyiɣi sia me la, Fia Abimelek kple eƒe aʋafia Pixol va Abraham gbɔ gblɔ nɛ be, “Eme kɔ ƒãa be Mawu li kpli wò le nu sia nu si nèwɔna la me. ");
INSERT INTO ewe_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ka atam nam le Mawu ŋkume be yemaba nye ŋutɔ alo vinye ŋutsu alo nye tɔgbuiyɔvi o, ke boŋ be yeanɔ anyi kple nye dukɔ le nɔvilɔlɔ̃ me abe ale si mele ɖe ŋuwò ene.” ");
INSERT INTO ewe_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham ɖo eŋu be, “Enyo, meka atam sia!” ");
INSERT INTO ewe_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham na nutsotso fia Abimelek tso ale si fia la ƒe subɔlawo xɔ vudo aɖe le eƒe subɔlawo si sesẽtɔe la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Fia Abimelek ɖi vo, eye wògblɔ be, “Esiae nye zi gbãtɔ si mese nya aɖe tso nu sia ŋu, eye nyemenya ame si wɔ nu sia hã o. Nu ka ta mègblɔe nam kpɔ o?” ");
INSERT INTO ewe_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham tsɔ alẽwo kple nyiwo na Fia Abimelek abe vɔsa ene hetsɔ ɖo kpe woƒe nubabla la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham ɖe alẽvi adre tso eƒe lãhawo me ɖe aga, ");
INSERT INTO ewe_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","eye Abimelek bia Abraham be, “Alẽvi adre siawo nèɖe ɖe aga la gɔme ɖe?” ");
INSERT INTO ewe_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham ɖo eŋu be, “Esiae nye nye nunana na wò be wòanye kpeɖodzi le amewo ŋkume be nyee ɖe vudo sia.” ");
INSERT INTO ewe_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ale tso gbe ma gbe dzi la, woyɔa vudo la be Beerseba si gɔmee nye “Atamvudo,” elabena afi ma woka atam, eye wowɔ woƒe nubabla la le. ");
INSERT INTO ewe_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Le atamkaka le Beerseba megbe la, Fia Abimelek kple eƒe aʋakplɔla, Pixol trɔ yi aƒe. ");
INSERT INTO ewe_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham do ati aɖe ɖe Beerseba eye wòdo gbe ɖa na Yehowa Mawu mavɔ la be wòanye ɖasefo le nubabla sia me. ");
INSERT INTO ewe_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Eye Abraham nɔ Filistitɔwo ƒe anyigba dzi ɣeyiɣi didi aɖe. ");
INSERT INTO ewe_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Le ɣeyiɣi aɖe megbe la, Mawu do Abraham kpɔ. Eyɔe be, “Abraham!” Etɔ nɛ be, “Nyee nye esi.” ");
INSERT INTO ewe_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tete Mawu gblɔ be, “Kplɔ viwò ŋutsuvi ɖekɛ la, Isak, ame si gbɔ mèlɔ̃a nu le o la, ne miayi Moria nuto me. Tsɔe sa numevɔe le afi ma le toawo dometɔ ɖeka si mafia wò la dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Le fɔŋli la, Abraham dze nake hena dzododo ɖe vɔsamlekpui la dzi. Edo agba na eƒe tedzi, eye wòkplɔ via Isak kple ɖekakpui eve siwo nye eƒe subɔlawo la ɖe asi heɖo ta teƒe si Mawu gblɔ nɛ be wòayi la. ");
INSERT INTO ewe_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Le ŋkeke ene ƒe mɔzɔzɔ megbe la, Abraham kpɔ teƒe la le adzɔge ʋĩi. ");
INSERT INTO ewe_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Egblɔ na ɖekakpuiawo be, “Minɔ afi sia kple tedzi la; nye kple Isak míayi ŋgɔ vie aɖado gbe ɖa. Míatrɔ agbɔ fifi laa.” ");
INSERT INTO ewe_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham tsɔ vɔsanake la ɖo ta na Isak, eye eya ŋutɔ tsɔ hɛ la kple dzosinu ɖe asi. Ale wo ame eveawo dze mɔ. ");
INSERT INTO ewe_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Isak bia fofoa Abraham be, “Papa!” Eɖo eŋu nɛ bena “Nyee nye si, vinye!” Ke Isak bia be, “Nake kple dzosinu le mía si, ke afi ka agbo si míatsɔ asa vɔe ya le?” ");
INSERT INTO ewe_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham ɖo eŋu be, “Vinye, Mawu akpɔ ema gbɔ na mí hena vɔsa la.” Ale woyi mɔzɔzɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Esi woɖo teƒe si Mawu fia Abraham be wòayi la, Abraham ɖi vɔsamlekpui, eye wòɖo nakeawo ɖe edzi nyuie. Ebla Isak, eye wòkɔe mlɔ nakeawo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Abraham tsɔ eƒe hɛ be yeawu Isak. ");
INSERT INTO ewe_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Le ɣe ma ɣi me tututu la, Yehowa ƒe dɔla aɖe do ɣli tso dziƒo be, “Abraham, Abraham!” Abraham tɔ be, “Nyee nye esi.” ");
INSERT INTO ewe_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mawudɔla la gblɔ nɛ be, “Tsɔ hɛ la de aku me; mègawɔ nu vevi aɖeke ɖevi la o, elabena menya be Mawu xɔ teƒe gbãtɔ le wò agbenɔnɔ me; mèhe viwò lɔlɔ̃a gɔ̃ hã ɖe megbe tso gbɔnye o.” ");
INSERT INTO ewe_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Enumake Abraham kpɔ agbo aɖe si ƒe dzowo avekawo bla la le avekɔe aɖe me. Ale wòlé agbo la, eye wòtsɔe sa vɔe ɖe ɖevi la teƒe abe numevɔsa ene le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham na ŋkɔ teƒe la be, “Yehowa naa nu,” eye ŋkɔ sia tsi eŋu va se ɖe egbe. ");
INSERT INTO ewe_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yehowa ƒe dɔla la gayɔ Abraham tso dziƒo, ");
INSERT INTO ewe_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","eye wògblɔ nɛ be, “Nye, Yehowa, meka atam na wò le nye ŋkɔ dzi be esi nèɖo tom, eye mègbe viwò ŋutsuvi lɔlɔ̃a tsɔtsɔ nam o ta la, ");
INSERT INTO ewe_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","makɔ yayra manyagblɔwo ɖe dziwò, eye mana wò dzidzimeviwo nasɔ gbɔ fũu abe ɣletivi siwo le dziƒo alo ƒutake ene. Wò dzidzimeviwo aɖu woƒe futɔwo dzi, ");
INSERT INTO ewe_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","eye woanye yayra na dukɔwo katã le anyigba dzi. Esiawo katã ava eme, elabena èɖo tom.” ");
INSERT INTO ewe_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ale Abraham gatrɔ va ɖekakpuiawo gbɔ, eye wogatrɔ yi Beerseba, eye Abraham nɔ Beerseba. ");
INSERT INTO ewe_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Le ɣeyiɣi aɖe megbe la, wogblɔ na Abraham be, “Milka hã zu vinɔ, edzi viŋutsuwo na nɔviwò ŋutsu, Nahor. ");
INSERT INTO ewe_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz nye via gbãtɔ, Buz dzɔ ɖe Uz yome, kplɔɖoae nye Kemuel (ame si nye Aram fofo). ");
INSERT INTO ewe_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Bubuawoe nye Kesed, Hazo, Pildas, Yidlaf kple Betuel.” ");
INSERT INTO ewe_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel nye Rebeka fofo. Milka dzi ŋutsuvi enyi siawo na Abraham nɔvi ŋutsu, Nahor. ");
INSERT INTO ewe_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Eƒe ahiãvi si ŋkɔe nye Reuna la hã dzi viŋutsu siawo: Teba, Gaham, Tahas kple Maaka nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara tsi xɔ ƒe alafa ɖeka blaeve-vɔ-adre. ");
INSERT INTO ewe_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Eku le Kiriat Arba (si nye Hebron) le Kanaanyigba dzi. Abraham yi be yeafa konyi, eye yeafa avi nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Esime wòtsi tsitre ɖe srɔ̃a kukua gbɔ la, egblɔ na Hititɔwo be, ");
INSERT INTO ewe_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Amedzro menye le dzronyigba sia dzi; teƒe aɖeke mele asinye maɖi srɔ̃nye ɖo o. Meɖe kuku, midzra anyigba aɖe nam ne maɖi srɔ̃nye ɖe afi ma.” ");
INSERT INTO ewe_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hititɔ la ɖo eŋu na Abraham be, ");
INSERT INTO ewe_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Amegã, ɖo to mí. Ènye fiavi ŋusẽtɔ aɖe le mía dome. Ɖi wò ame kukuwo ɖe míaƒe yɔdo nyuitɔwo me. Mía dometɔ aɖeke magbe eƒe yɔdo nana wò na wò ame kukuwo ɖiɖi o.” ");
INSERT INTO ewe_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abraham tsi tsitre, eye wòde ta agu na Hititɔwo hegblɔ be, ");
INSERT INTO ewe_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Zi ale si wònye nenema miedii ko la, mive nunye, miaɖe kuku na Efrɔn, Zoha ƒe vi nam ");
INSERT INTO ewe_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","be wòadzra eƒe kpeto Makpela si le eƒe anyigba ƒe seƒe lɔƒo la nam. Maxe ga home si dzi míalɔ̃ ɖo la katã nɛ, eye wòazu ameɖiƒe na ƒonyemetɔwo tegbee.” ");
INSERT INTO ewe_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efrɔn nɔ ameawo dome. Eƒo nu, ɖo Abraham ƒe nya la ŋu le Hititɔwo katã ŋkume. Egblɔ na Abraham be, ");
INSERT INTO ewe_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Amegã, meɖe kuku, ɖo tom. Matsɔ kpeto la kple anyigba la ana wò, eye nyemaxɔ naneke ɖe wo ta o. Metsɔ wo na wò faa le nye ame siwo le afi sia la ƒe ŋkume. Yi nàɖi wò ame kuku la ɖe edzi.” ");
INSERT INTO ewe_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham gade ta agu na Hititɔwo, ");
INSERT INTO ewe_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","eye wòɖo nya la ŋu na Efrɔn esime ame sia ame nɔ to dzi be, “Ao, na maƒlee ko. Na maxe ga home si anyigba la xɔ la, ekema maɖi nye ame kukuwo ɖe edzi.” ");
INSERT INTO ewe_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efrɔn ɖo eŋu na Abraham be, ");
INSERT INTO ewe_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Ɖo tom, nye aƒetɔ; anyigba la ƒe asie nye klosalo kilogram atɔ̃. Ke nu kae nye ga home ma le nye kple wò dome? Ɖi wò ame kuku.” ");
INSERT INTO ewe_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abraham lɔ̃ ɖe klosalo kilogram atɔ̃ si Efrɔn bia le Hititɔwo dome la dzi, eye wòxee nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Ale Efrɔn ƒe anyigba si le Makpela si te ɖe Mamre ŋu, anyigba la kple kpeto si le eme la siaa kple ati siwo le anyigba la ƒe liƒowo me la trɔ zu ");
INSERT INTO ewe_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abraham tɔ le Hititɔ siwo va du la ƒe agbo nu la katã ƒe ŋkume. ");
INSERT INTO ewe_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Emegbe la, Abraham ɖi srɔ̃a Sara ɖe kpeto si le Makpela si te ɖe Mamre ŋu la me. Teƒe sia le Hebron le Kanaanyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ale Hititɔwo wɔ agbalẽ ɖe anyigba la kple kpeto si le edzi la dzi na Abraham be wòanye eƒe ameɖiƒe. ");
INSERT INTO ewe_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham tsi ŋutɔ azɔ, eye Yehowa yrae le mɔ sia mɔ nu. ");
INSERT INTO ewe_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Gbe ɖeka la, Abraham gblɔ na eƒe aƒedzikpɔla, ame si nye eƒe subɔla tsitsitɔ be, ");
INSERT INTO ewe_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","“Tsɔ wò asiwo de nye ata te, eye nàka atam nam le Yehowa, dziƒo kple anyigba ƒe Mawu ŋkume be màna vinye naɖe Kanaan nyɔnuvi siawo dometɔ aɖeke o, ");
INSERT INTO ewe_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ke boŋ àyi nye denyigba dzi kple ƒonyemetɔwo dome, eye nàɖe srɔ̃ nɛ le afi ma.” ");
INSERT INTO ewe_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Aƒedzikpɔla la biae be, “Ke ne nyemate ŋu kpɔ ɖetugbi aɖeke si alɔ̃ be yeava teƒe didi sia o ɖe, ekema ɖe makplɔ Isak ayi afi ma boŋ, ale be wòanɔ ƒowòmetɔwo domea?” ");
INSERT INTO ewe_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham ɖo eŋu be, “Gbeɖe! Kpɔ nyuie be màwɔ nenema gbeɖe o, ");
INSERT INTO ewe_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","elabena Yehowa, Mawu si le dziƒo la gblɔ nam be magblẽ anyigba ma kple ƒonyemetɔwo ɖi, eye wòdo ŋugbe nam be yeatsɔ anyigba sia na nye kple nye dzidzimeviwo. Ana mawudɔla aɖe nanɔ ŋgɔ na wò, eye wòakpɔ egbɔ be èkpɔ nyɔnuvi aɖe tso afi ma wòazu vinye srɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ke ne medze edzi nenema o la, ekema atam sia megabla wò o, gake mègakplɔ vinye yi be, wòatsi afi ma gbeɖegbeɖe o.” ");
INSERT INTO ewe_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ale aƒedzikpɔla la tsɔ eƒe asiwo de Abraham ƒe ata te, eye wòka atam be yeawɔ eƒe ɖoɖowo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ekplɔ Abraham ƒe kposɔ ewo ɖe asi, eye wòdo agba na wo kple nu nyui siwo katã le eƒe aƒetɔ si la ƒe ɖe. Ezɔ mɔ yi Aram Naharaim, eye wòyi Nahor ƒe du me. ");
INSERT INTO ewe_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ena kposɔawo tsyɔ akɔ anyi ɖe dua godo le vudo aɖe to. Esi ɣe trɔ la, dua me nyɔnuwo va nɔ tsi kum. ");
INSERT INTO ewe_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Aƒedzikpɔla la do gbe ɖa be, “O, Yehowa, nye aƒetɔ ƒe Mawu, kpɔ nublanui na nye aƒetɔ Abraham, eye nàna be nye asi nasu nu si ta meva afi sia ɖo la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kpɔm ɖa, mele tsitre ɖe vudo sia to, ɖetugbiwo tso dua me va le tsi kum. ");
INSERT INTO ewe_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Nu si mebia wò lae nye ɖetugbi si mabia be wòana tsim, eye wòagblɔ be, ‘Yoo, mana tsi wò kple wò kposɔwo siaa’ la, na be eya tututu nanye nyɔnu si wò ŋutɔ nètia be wòanye Isak srɔ̃. To esia me madze sii le be ève nye aƒetɔ nu.” ");
INSERT INTO ewe_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Hafi wòawu gbedodoɖa la nu la, Rebeka va do kple eƒe tsikuze si wòlé ɖe abɔta la. Enye Betuel ƒe vinyɔnu. Betuel nye Milka ƒe viŋutsu, ame si nye Abraham srɔ̃ nɔviŋutsu Nahor. ");
INSERT INTO ewe_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ɖetugbi la dze tugbe ŋutɔ. Menya ŋutsu haɖe o. Eva tsikuƒe la, ku tsi ɖe eƒe tsikuze me, eye wògado go. ");
INSERT INTO ewe_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Aƒedzikpɔla la ɖe abla te ɖe eŋu, eye wògblɔ nɛ be, “Meɖe kuku, na tsi vi aɖem tso wò tsikuze la me mano.” ");
INSERT INTO ewe_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ɖetugbi la ɖo eŋu be, “Mana tsi wò faa, nye aƒetɔ.” Eku tsi na aƒedzikpɔla la enumake, ");
INSERT INTO ewe_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","eye wògblɔ be, “Mana wò kposɔwo hã va se ɖe esime woaɖi kɔ!” ");
INSERT INTO ewe_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Ale Rebeka ku tsi kɔ ɖe lãwo ƒe tsinonu me. Egatrɔ yi ɖaku tsi le vudoa me zi geɖe va se ɖe esime kposɔawo no tsi wòsu wo. ");
INSERT INTO ewe_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Aƒedzikpɔla la megagblɔ nya aɖeke o, ke boŋ eda ŋku ɖi be yeakpɔ be Yehowa wɔ ɖe nu siwo katã yebiae la dzi mahã. ");
INSERT INTO ewe_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Esi kposɔawo no tsi heɖi kɔ vɔ la, etsɔ sikatogɛ kple sikalɔnugɛ na Rebeka. ");
INSERT INTO ewe_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ebiae be, “Ɖetugbi, ame ka ƒe vi nènye? Teƒe le fofowò si wòana míadze le zã sia mea?” ");
INSERT INTO ewe_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Eɖo eŋu be, “Fofonyee nye Betuel si nye Milka si nye Nahor srɔ̃ la ƒe vi. ");
INSERT INTO ewe_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ɛ̃, nuɖuɖu le mía si sɔ gbɔ na kposɔawo, eye amedzrodzeƒe hã li.” ");
INSERT INTO ewe_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Aƒedzikpɔla la tsi tsitre ɖe afi ma sẽe, de ta agu, eye wòkafu Yehowa gblɔ be, ");
INSERT INTO ewe_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Yehowa Mawu, nye aƒetɔ Abraham ƒe Mawu, meda akpe na wò be nève nye aƒetɔ nu, eye nèwɔ wò ŋugbedodo dzi nɛ be nèkplɔm tẽe va do ɖe nye aƒetɔ ƒe ƒometɔwo dome.” ");
INSERT INTO ewe_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Ɖetugbi la ƒu du yi aƒe me be yeaka nya la ta na yeƒe amewo. ");
INSERT INTO ewe_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Nɔviŋutsu aɖe nɔ Rebeka si. Eŋkɔe nye Laban. ");
INSERT INTO ewe_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Esi wòkpɔ togɛ la kple alɔnugɛ la le nɔvia nyɔnu ƒe abɔ, eye wòse Rebeka ƒe ɖaseɖiɖi tso nya si ŋutsu la gblɔ nɛ ŋuti ko la, eɖe abla yi ŋutsu la gbɔ le tsikuƒe la. Ekpɔe wòtsi tsitre ɖe kposɔawo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Egblɔ na ŋutsu la be, “Va, wò ame si Yehowa yra. Nu ka ta nèle tsitre ɖe afi sia ɖo? Medzra teƒe ɖo ɖe aƒea me na wò kple wò kposɔawo.” ");
INSERT INTO ewe_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ale aƒedzikpɔla la dze Laban yome yi aƒe me, eye woɖe agba na kposɔawo. Laban na gbe ƒuƒu aƒedzikpɔla la be wòana kposɔawo. Emegbe la, ena tsi aƒedzikpɔla la kple ŋutsu siwo kplɔe ɖo la be woaklɔ afɔ. ");
INSERT INTO ewe_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Wona fiẽnuɖuɖu wo, ke aƒedzikpɔla la gblɔ be, “Nyemedi be maɖu naneke o va se ɖe esime magblɔ nu si ta meva afi sia ɖo la na mi.” Laban gblɔ be, “Enyo, ka nya la ta na mí.” ");
INSERT INTO ewe_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Egblɔ be, “Abraham ƒe subɔlae menye. ");
INSERT INTO ewe_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yehowa kɔ yayra geɖewo ɖe nye aƒetɔ dzi, eye wòzu amegã aɖe le anyigba si dzi wòle la. Mawu na alẽwo, nyiwo, klosalo, sika, kluviwo, kposɔwo kple tedziwoe. ");
INSERT INTO ewe_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Azɔ esi nye aƒetɔ srɔ̃, Sara, tsi ŋutɔ la, edzi viŋutsu na nye aƒetɔ, eye nye aƒetɔ tsɔ eƒe nu sia nu nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nye aƒetɔ na medo ŋugbe nɛ heka atam ɖe nya si wògblɔ nam dzi be, ‘Megaɖe srɔ̃ na vinye tso Kanaantɔ, siwo ƒe anyigba dzi mele la ƒe nyɔnuviwo dome o, ");
INSERT INTO ewe_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ke boŋ yi nye ƒometɔwo gbɔ le teƒe bubu, eye nàkplɔ ɖetugbi aɖe tso afi ma vɛ na vinye wòaɖe.’ ");
INSERT INTO ewe_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Mebia nye aƒetɔ hã be, ‘Ke ne nyemekpɔ ɖetugbi si alɔ̃ be yeava o ɖe?’ ");
INSERT INTO ewe_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Eɖo eŋu nam be, ‘Ɖetugbi la alɔ̃ be yeava, elabena Yehowa, ame si ŋkume mezɔ le la ana eƒe dɔla nazɔ kple wò, eye wòana nu si ta nèyi la naka asiwò. Ɛ̃, di ɖetugbi aɖe tso nye amewo dome, tso nɔvinyeŋutsua ƒe aƒemetɔwo dome. ");
INSERT INTO ewe_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Le wò atamkaka ta la, ele na wò be nàyi aɖabia. Ne womaɖo ame aɖeke ɖa o la, ekema èvo tso wò atamkaka la me.’ ");
INSERT INTO ewe_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ɣetrɔ sia, esi meva ɖo vudo la to la, medo gbe ɖa be, ‘O, Yehowa, nye aƒetɔ Abraham ƒe Mawu, ne èdi be nye asi naka nu si ta meva afi sia ɖo la, meɖe kuku, kplɔm ale. ");
INSERT INTO ewe_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Mele afi sia, le vudo sia to. Magblɔ na ɖetugbi aɖe si ava tsi ku ge la be, “Meɖe kuku, na tsim mano,” ");
INSERT INTO ewe_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","eye wòaɖo eŋu nam be, “Mana tsi wò faa, eye mana tsi wò kposɔawo hã!” Na ɖetugbi ma nanye esi wò Yehowa, nètia be wòanye nye aƒetɔ ƒe vi srɔ̃.’ ");
INSERT INTO ewe_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Esi menɔ nya siawo gblɔm la, Rebeka gbɔna ɖaa, tsikuze nɔ abɔta nɛ. Eyi ɖaku tsi le vudo la me ɖe tsikuze la me. Megblɔ nɛ be, ‘Meɖe kuku, na tsim mano.’ ");
INSERT INTO ewe_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Eɖiɖi tsikuze la ɖe anyi enumake be manoe, eye wògblɔ be. ‘Amegã, mana tsi wò kposɔwo hã!’ Ke menoe, eye wòna nye kposɔwo hã. ");
INSERT INTO ewe_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Mebiae be, ‘Ame ka ƒe vie nènye?’ “Egblɔ nam be, ‘Fofonyee nye Betuel, Nahor kple srɔ̃a Milka ƒe vi.’ “Eya ta metsɔ asigɛ kple alɔnugɛwo nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Emegbe la, mede ta agu, eye mekafu Yehowa, nye aƒetɔ Abraham ƒe Mawu la, elabena ekplɔm to mɔ nyuitɔ dzi be meke ɖe ɖetugbi aɖe ŋu tso nye aƒetɔ nɔviŋutsu ƒe vinyɔnuwo dome, ");
INSERT INTO ewe_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","eya ta migblɔ nu si dzi mieɖo kpee la nam. Ɖe miave nye aƒetɔ nu loo alo miave enu awɔ nu si dze la oa? Ne mieɖo eŋu nam la, ekema manya afɔ si magaɖe, ato miame loo alo ɖusime.” ");
INSERT INTO ewe_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban kple Betuel ɖo eŋu be, “Eme kɔ ƒãa be Yehowa ŋutɔe kplɔ wò va afi siae, eya ta nya aɖeke mele mía si o. ");
INSERT INTO ewe_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Kplɔe yi, eye wòazu wò aƒetɔ ƒe vi srɔ̃ abe ale si Yehowa gblɔe ene.” ");
INSERT INTO ewe_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Le ŋuɖoɖo sia ta la, Abraham ƒe aƒedzikpɔla dze klo ɖe Yehowa ŋkume, eye wòsubɔe. ");
INSERT INTO ewe_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Emegbe la, eɖe sikanuwo kple klosalonuwo kpakple awu nyuiwo na Rebeka, eye wòtsɔ nunana xɔasi vovovowo na dadaa kple nɔvia ŋutsu hã. ");
INSERT INTO ewe_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Emegbe la, woɖu nu, no nu dzidzɔtɔe eye Abraham ƒe aƒedzikpɔla la kple eƒe amewo tsi afi ma dɔ. Ke esi ŋu ke ŋdi kanya la, aƒedzikpɔla la gblɔ na wo be, “Mina matrɔ ayi nye aƒetɔ gbɔ!” ");
INSERT INTO ewe_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Rebeka dada kple nɔvia gblɔ be, “Míedi be Rebeka naganɔ mía gbɔ ŋkeke ewo lɔƒo teti, ekema ate ŋu ayi.” ");
INSERT INTO ewe_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ke aƒedzikpɔla la ɖe kuku be, “Migaxe mɔ na nye tɔtrɔ o. Yehowa ŋutɔ na nu si ta meva la dze edzi nam, eye medi be mayi aɖana akɔnta nye aƒetɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Wogblɔ be, “Enyo, míayɔ ɖetugbi la abia gbee.” ");
INSERT INTO ewe_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ale woyɔ Rebeka, eye wobiae be, “Èlɔ̃ be yeadze ŋutsu sia yomea?” Rebeka ɖo eŋu be, “Ɛ̃, mayi.” ");
INSERT INTO ewe_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Ale wodo hedenyui nɛ, eye woɖe nyɔnu si kpɔ edzi tso ɖevime la kpe ɖe eŋu, hekpe ɖe Abraham ƒe dɔla kple eŋumewo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Le kaklãɣi la, woyrae kple nya siawo: “Mía nɔvi lɔlɔ̃a, nadzi ame akpe akpewo wò dzidzimeviwo naɖu woƒe futɔwo katã dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ale Rebeka kple eƒe dɔlanyɔnuwo de kposɔawo dzi, eye wodzo kple Abraham ƒe aƒedzikpɔla la. ");
INSERT INTO ewe_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Fifia Isak, ame si ƒe aƒe le Negeb la, trɔ va Ber Lahai Roi. ");
INSERT INTO ewe_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Gbe ɖeka fiẽ esi wònɔ tsa ɖim le gbedzi nɔ gbe dom ɖa la, ekpɔ kposɔwo gbɔna ɖa. ");
INSERT INTO ewe_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebeka kpɔe ɖa, eye wòɖi enumake le kposɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Rebeka bia aƒedzikpɔla la be, “Ame kae ma le zɔzɔm le gbedzi gbɔna mía kpe ge?” Eɖo eŋu be, “Nye aƒetɔ ƒe viŋutsue!” Ale Rebeka tsɔ motsyɔnu tsyɔ mo. ");
INSERT INTO ewe_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tete aƒedzikpɔla la gblɔ ŋutinya blibo la na Isak. ");
INSERT INTO ewe_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Isak kplɔ Rebeka de dadaa ƒe agbadɔ me, eye wòzu srɔ̃a. Isak lɔ̃ srɔ̃a ŋutɔ, eye Rebeka zu akɔfafa tɔxɛ nɛ le dadaa ƒe ku megbe. ");
INSERT INTO ewe_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham gaɖe srɔ̃ bubu, ame si ŋkɔe nye Ketura. ");
INSERT INTO ewe_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Edzi Zimram, Yoksan, Medan, Midian, Isbak kple Sua na Abraham. ");
INSERT INTO ewe_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoksan dzi Seba kple Dedan. Dedan ƒe viŋutsuwoe nye: Asurim, Letusim kple Leunim. ");
INSERT INTO ewe_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian ƒe viŋutsuwoe nye: Efa, Efer, Hanok, Abida kple Elda. Woawoe nye Abraham kple srɔ̃a evelia, Ketura ƒe dzidzimeviwo. ");
INSERT INTO ewe_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abraham tsɔ eƒe nuwo katã na Isak; ");
INSERT INTO ewe_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","ke ena nu vi siwo eƒe ahiãviwo dzi nɛ la hã, eye wòɖo wo ɖe ɣedzeƒe lɔƒo, ale be womanɔ teƒe ɖeka kple Isak o. ");
INSERT INTO ewe_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham ƒe agbenɔƒewo katã nɔ ƒe alafa ɖeka blaadre-vɔ-atɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abraham mia nu, eye eƒe agbe nu tso le ƒe geɖe xɔxɔ megbe. Enɔ agbe wòde edeƒe, eye wòyi ɖe tɔgbuiawo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Via ŋutsuwo, Isak kple Ismael, ɖii ɖe kpeto la me le Makpela si te ɖe Mamre ŋu, le Hititɔ Efron, Zoha ƒe vi ƒe anyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Teƒe siae Abraham ƒle le Hititɔ la si; afi mae woɖi Abraham kple srɔ̃a ɖo. ");
INSERT INTO ewe_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Le Abraham ƒe ku megbe la, Mawu kɔ yayra geɖewo ɖe Isak dzi. Fifia Isak ʋu yi ɖanɔ Beer Lahoi Roi. ");
INSERT INTO ewe_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Esia nye Ismael, Abraham ƒe viŋutsu, ame si Hagar, Egiptetɔ si nye Sara ƒe dɔlanyɔnu dzi na Abraham la ƒe ŋutinya. ");
INSERT INTO ewe_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ismael ƒe viwoe nye: Nebayɔt, ame si nye via tsitsitɔ, Kedar, Adbel, Mibsam, ");
INSERT INTO ewe_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO ewe_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad, Tema, Yetur, Nafis kple Kedema. ");
INSERT INTO ewe_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Viŋutsu wuieve siawo nye Ismael vi siwo va zu fia na to wuieveawo, eye wotsɔ woƒe ŋkɔwo na toawo. ");
INSERT INTO ewe_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Mlɔeba la, Ismael va ku le esime wòxɔ ƒe alafa ɖeka blaetɔ̃-vɔ-adre, eye woɖii ɖe tɔgbuiawo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismael ƒe dzidzimevi siawo kaka ɖe anyigba dzi tso Havila va se ɖe Sur si te ɖe Egipte ƒe liƒowo ŋu le Asiria gome. Wowɔa aʋa edziedzi kple wo nɔewo. ");
INSERT INTO ewe_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraham ƒe vi Isak ƒe dzidzimeviwo ƒe ŋutinya yi ale. Abraham ye dzi Isak. ");
INSERT INTO ewe_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isak xɔ ƒe blaene esi wòɖe Rebeka, ame si nye Betuel, Arameatɔ tso Padan Aram, Laban nɔvinyɔnu ƒe vi. ");
INSERT INTO ewe_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isak ɖe kuku na Yehowa be wòana vi ye kple Rebeka, elabena le ƒe geɖewo ƒe srɔ̃gbenɔnɔ me la, womedzi vi o. Mlɔeba la, Rebeka va fɔ fu. ");
INSERT INTO ewe_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Edze na Rebeka abe ɖevi evee nɔ avu wɔm le eƒe dɔ me ene! Egblɔ be, “Nyemate ŋu ado dzi anɔ te ɖe nu sia nu o.” Ale wòbia gbe Yehowa tso eŋu. ");
INSERT INTO ewe_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yehowa gblɔ nɛ be, “Viŋutsu eve siwo le dɔ me na wò la azu dukɔ eve siwo aʋli ho kple wo nɔewo. Ɖeka asesẽ wu evelia, eye tsitsitɔ azu subɔla na ɖevitɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Le nyateƒe me la, edzi evenɔviwo. ");
INSERT INTO ewe_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ɖa dzĩ nɔ gbãtɔ ŋu abe lãfuwue wòdo ene! Ale woyɔe be “Esau.” ");
INSERT INTO ewe_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Wodzi ɖevi evelia wòlé Esau ƒe afɔkpodzi ɖe asi. Nu sia tae wona ŋkɔe be Yakob si gɔmee nye, “Nuhala” ɖo. Isak xɔ ƒe blaade esi wòdzi evenɔviawo. ");
INSERT INTO ewe_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Esi ɖeviawo tsi la, Esau zu adela xɔŋkɔ aɖe, ke Yakob ya zu ame fafa aɖe si lɔ̃a aƒemenɔnɔ. ");
INSERT INTO ewe_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ɖeviawo dometɔ si Isak lɔ̃ wu lae nye Esau, le adelã si wòtsɔna vaa aƒe mee ta; ke esi Rebeka lɔ̃ wu lae nye Yakob. ");
INSERT INTO ewe_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Gbe ɖeka la, Yakob nɔ detsi ƒom esime Esau gbɔ tso adegbe. ");
INSERT INTO ewe_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Esau bia Yakob be, “Nɔvinye, dɔ le wuyem vevie. Na wò akplẽdzĩ aɖem maɖu.” Esia ta wona megbeŋkɔe be “Edom” si gɔmee nye “Akplẽdzĩ.” ");
INSERT INTO ewe_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yakob ɖo eŋu be, “Enyo, ekema tsɔ wò ŋgɔgbevinyenye nam, eye nàxɔ akplẽdzĩ la.” ");
INSERT INTO ewe_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau gblɔ be, “Ne dɔ le ame aɖe wum wòɖo kudo nu ɖe, viɖe kae gale eƒe ŋgɔgbevinyenye ŋu nɛ?” ");
INSERT INTO ewe_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yakob xɔ edzi gblɔ be, “Enyo, ekema ka atam na Mawu be ŋgɔgbevinyenye la zu tɔnye.” Esau ka atam, eye wòto esia me dzra eƒe ŋgɔgbevinyenye la na nɔvia suetɔ, ");
INSERT INTO ewe_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","eye Yakob tsɔ abolo, ayi kple dedetsi na Esau wòɖu, no tsi ɖe edzi, eye wòyi eƒe wɔnawo dzi. Ke Esau metsɔ ɖeke le eme be yeɖe asi le yeƒe ŋgɔgbevinyenye ŋuti nenema o. ");
INSERT INTO ewe_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Dɔ gã aɖe to ɖe anyigba la dzi abe ale si wòto le Abraham ŋɔli ene. Ale Isak ʋu yi Gerar, afi si Abimelek, Filistitɔwo ƒe fia nɔ. ");
INSERT INTO ewe_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Yehowa ɖe eɖokui fiae le afi ma gblɔ nɛ be, “Mègayi Egipte o. ");
INSERT INTO ewe_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Wɔ nu si magblɔ na wò la, eye nànɔ afi sia le anyigba sia dzi. Ne èwɔ nye gbe dzi la, manɔ kpli wò, eye mayra wò. Matsɔ anyigba sia katã ana wò kple wò dzidzimeviwo abe ale si medo ŋugbe na fofowò, Abraham ene. ");
INSERT INTO ewe_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Mana wò dzidzimeviwo nasɔ gbɔ abe ɣletiviwo ene! Matsɔ anyigba siawo katã ana wò, eye wòanye yayra na dukɔwo katã le xexea me. ");
INSERT INTO ewe_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Mawɔ esia, elabena Abraham wɔ nye sewo kple ɖoɖowo katã dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Eya ta Isak nɔ Gerar. ");
INSERT INTO ewe_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Esi Gerar ŋutsuwo bia gbee tso Rebeka ŋu la, egblɔ be, “Nɔvinye nyɔnue!” Ewɔ esia, elabena evɔ̃ be ne yeʋu eme be ye srɔ̃e la, woawu ye be yewoaxɔe, elabena edze tugbe ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ke le ɣeyiɣi aɖe megbe la, Abimelek, Filistitɔwo ƒe fia do mo ɖe fesre nu, eye wòkpɔ ale si Isak kple Rebeka nɔ fefe fem. ");
INSERT INTO ewe_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelek dɔ ame ɖe Isak, eye wòhe nya ɖe eŋu be, “Srɔ̃wòe nye Rebeka! Nu ka ta nègblɔ be ye nɔvie ɖo?” Isak ɖo eŋu be, “Elabena mevɔ̃ be woava wum, axɔ Rebeka aɖe.” ");
INSERT INTO ewe_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelek biae be, “Aleke nàte ŋu awɔ nu sia ɖe mía ŋu? Ame aɖe ate ŋu awɔ ahasi kplii le esime menya be srɔ̃tɔe o, eye wòahe dzɔgbevɔ̃e va mía dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimelek ɖe gbeƒã be, “Ame sia ame si awɔ nu masɔmasɔ aɖe ɖe ame sia alo srɔ̃a ŋu la aku.” ");
INSERT INTO ewe_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Le ƒe ma me la, Isak ƒe nukuwo ʋã ŋutɔ; nuku ɖe sia ɖe si wòƒã la tse ku geɖe, elabena Yehowa yrae. ");
INSERT INTO ewe_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ezu kesinɔtɔ gã aɖe, eye eƒe kesinɔnuwo ganɔ dzidzim ɖe edzi ko. ");
INSERT INTO ewe_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Eƒe lãhawo sɔ gbɔ ŋutɔ, eye subɔla geɖewo hã nɔ esi. Ale Filistitɔwo de asi ŋuʋaʋãe me. ");
INSERT INTO ewe_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Woxe eƒe vudo siwo katã fofoa Abraham ƒe subɔlawo ɖe la. ");
INSERT INTO ewe_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Fia Abimelek nya Isak le eƒe anyigba dzi. Egblɔ nɛ be, “Dzo yi teƒe bubu, elabena èzu kesinɔtɔ eye ŋusẽ le asiwò wu mí azɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ale Isak ʋu yi Gerar ƒe balime, eye wònɔ afi ma koŋ. ");
INSERT INTO ewe_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Isak gbugbɔ fofoa Abraham ƒe vudo siwo Filistitɔwo xe le fofoa ƒe ku megbe la ɖe, eye wògbugbɔ ŋkɔ siwo fofoa na wo la tsɔ na wo. ");
INSERT INTO ewe_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Eƒe alẽkplɔlawo hã ɖe vudo yeye aɖe ɖe Gerar ƒe balime, eye woke ɖe tsi dzidzi ŋu le anyigba ƒe tume. ");
INSERT INTO ewe_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ke alẽkplɔla siwo nye Gerartɔwo la dze go ɖe vudoa dzi. Wohe nya kple Isak ƒe alẽkplɔlawo gblɔ be, “Míaƒe anyigba kple míaƒe vudoe.” Ale wona ŋkɔ vudoa be, “Nyahehevudo.” ");
INSERT INTO ewe_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Isak ƒe amewo gaɖe vudo bubu, ke ʋiʋli gaɖo esia hã ŋu, eya ta wona ŋkɔ vudo la be, “Dɔmedzoevudo.” ");
INSERT INTO ewe_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Isak ɖe asi le vudo sia hã ŋu, eye wògaɖe bubu. Ke afi ma tɔwo megabia nya aɖekee o. Nu sia na wona ŋkɔ vudo sia be Rehobot si gɔmee nye “Teƒe Li Na Mí Azɔ.” Eya ta egblɔ be, “Elabena mlɔeba la, Yehowa di teƒe na mí, eye míaɖe ɖɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Esi wòyi Beerseba la, ");
INSERT INTO ewe_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yehowa ɖe eɖokui fiae le zã si me wòɖo afi ma la, eye wògblɔ nɛ be, “Nyee nye fofowò Abraham ƒe Mawu, mègavɔ̃ o, elabena meli kpli wò, eye mayra wò. Mana wò dzidzimeviwo nasɔ gbɔ ale gbegbe be woazu dukɔ gã aɖe le nye ŋugbedodo na Abraham, ame si ɖo tom la ta.” ");
INSERT INTO ewe_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Isak ɖi vɔsamlekpui, eye wòsubɔ Yehowa. Eʋu va tsi afi ma, eye eƒe subɔlawo ɖe vudo ɖi. ");
INSERT INTO ewe_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Gbe ɖeka la, Isak xɔ amedzro aɖewo tso Gerar. Ame siawo nye Fia Abimelek kple eƒe aɖaŋudela Ahuzat kple eƒe aʋafia Pixol. ");
INSERT INTO ewe_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isak bia wo be, “Nu ka ta mieva gbɔnye ɖo? Esi mienyam le miaƒe anyigba dzi ɖe madzɔmadzɔ dzi ɖe, nu ka wɔ ge mieva.” ");
INSERT INTO ewe_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Woɖo eŋu be, “Míekpɔe dze sii kɔtɛe be Yehowa le yrawòm. Míedi be atamkaka nanɔ mía dome. ");
INSERT INTO ewe_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Do ŋugbe na mí be yemawɔ nuvevi mí abe ale si míewɔ nuvevi wò ene o. Le nyateƒe me la, nyui ko míewɔ na wò; ɖeko míena nèdzo le ŋutifafa me. Míeyra wò le Yehowa ƒe ŋkɔ me.” ");
INSERT INTO ewe_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Ale Isak ɖo kplɔ̃ gã aɖe na wo, woɖu nu, no nu abe dzadzraɖo na nubabla la ƒe wɔnawo ene. ");
INSERT INTO ewe_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Esi ŋu ke ŋdi kanya la, woka atam na wo nɔewo be yewomatsi tsitre ɖe yewo nɔewo ŋu o. Emegbe Isak do mɔ wo, eye wodzo yi aƒe kple dzidzɔ. ");
INSERT INTO ewe_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Gbe ma gbe ke Isak ƒe subɔlawo va gblɔ nɛ be, “Míeke ɖe tsi ŋu le vudo si ɖem míele la me.” ");
INSERT INTO ewe_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Eya ta Isak na ŋkɔ vudo la be, “Atamvudo.” Eya ta woyɔa du si wotso ɖe afi ma la be Beerseba va se ɖe egbe. ");
INSERT INTO ewe_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esi Esau xɔ ƒe blaene la, eɖe Hititɔ Beeri ƒe vinyɔnu Yudit, eye wògaɖe Hititɔ Elon ƒe vinyɔnu Basemat. ");
INSERT INTO ewe_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ke Isak kple Rebeka mekpɔ dzidzɔ le Esau ƒe srɔ̃ siawo ɖeɖe ŋu o. ");
INSERT INTO ewe_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Esi Isak tsi ku amegã belibeli, eye megate ŋu nɔ nu kpɔm tututu o la, eyɔ via tsitsitɔ Esau gbe ɖeka. Eyɔe be, “Vinye.” Esau tɔ be, “Nyee nye esi.” ");
INSERT INTO ewe_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Isak yi edzi gblɔ be, “Fifia metsi, eye menya be mate ŋu aku ɣe sia ɣi tso fifia dzi. ");
INSERT INTO ewe_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tsɔ wò da kple datiwo nàyi gbe me, eye nàwu lã aɖe tsɔ gbɔe. ");
INSERT INTO ewe_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Ne ègbɔ la, nàɖa nu nyui si tɔgbi melɔ̃a ɖuɖu la nam. Tsɔe vɛ nam maɖu, be mayra wò, vinye ŋutsuvi gbãtɔ hafi maku.” ");
INSERT INTO ewe_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ke Rebeka fi nya si Isak gblɔ na via Esau la se. Ale esi Esau dzo yi adegbe be yeadi lã aɖe awu la, ");
INSERT INTO ewe_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeka yɔ via Yakob, eye wògblɔ nɛ be, “Mese fofowò gblɔ na nɔviwò be, ");
INSERT INTO ewe_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Di adelã nàɖa nui nam maɖu, eye mayra wò le Yehowa ŋkume hafi maku.’ ” ");
INSERT INTO ewe_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Rebeka yi edzi gblɔ be, “Vinye, ɖo tom, eye nàwɔ nu si magblɔ na wò la tututu. ");
INSERT INTO ewe_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Yi lãhawo me, eye nàlé gbɔ̃ eve siwo metsi tututu o la vɛ nam ne matsɔ wo aɖa nu si vivia fofowò nu la nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Àtsɔ nuɖuɖu la ayi na fofowò wòaɖu. Ne eɖui vɔ la, ayra wò boŋ ɖe fowò Esau teƒe hafi aku.” ");
INSERT INTO ewe_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ke Yakob gblɔ na dadaa be, “Enyo pɛ, gake fonye Esau to fu ɖe ŋuti, ke nye la, nye ŋutigbalẽ zrɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Nya kae adzɔ ne fofonye ali asi ŋunye? Abu be ɖe medi be mado lã ye, eye wòaƒo fi adem le esime wòayram teƒe!” ");
INSERT INTO ewe_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Rebeka gblɔ na via be, “Vinye lɔlɔ̃a, na eƒe fiƒode nava dzinye. Wò ya wɔ nu si megblɔ na wò la. Yi nàlé gbɔ̃awo vɛ.” ");
INSERT INTO ewe_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ale Yakob zɔ ɖe dadaa ƒe ɖoɖowo dzi. Ewu gbɔ̃awo, ko wo nyuie, eye dadaa tsɔ lã la ɖa nu si vivia Isak nu. ");
INSERT INTO ewe_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Le esia megbe la, Rebeka tsɔ Esau ƒe awu nyuitɔwo, eye wòna Yakob do wo. ");
INSERT INTO ewe_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Etsɔ gbɔ̃awo ƒe agbalẽwo wɔ asiwuiwo, eye wòtsɔ gbɔ̃gbalẽ la ƒe ɖe wɔ kawo tsi ɖe asiwuiawo ŋu heku kɔ na Yakob. ");
INSERT INTO ewe_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Etsɔ lã si nɔ ʋeʋẽm lĩlĩlĩ kple abolo si wome teti la nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yakob tsɔ nuɖuɖua yi na fofoa hegblɔ be, “Fofonye.” Eɖo eŋu bena, “Nyee nye si, vinye kae nye ema?” ");
INSERT INTO ewe_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yakob ɖo eŋu be, “Nye Esau, viwò tsitsitɔe. Mewɔ nu si nèɖo nam be mawɔ la. Nuɖuɖu nyui si nèdi lae nye esi. Fɔ nàɖui eye nàyram.” ");
INSERT INTO ewe_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Enumake Isak gblɔ be, “Vinye, aleke nèwɔ hafi wò asi ka lã kaba ale?” Yakob ɖo eŋu be, “Yehowa, wò Mawu lae kpe ɖe ŋunye.” ");
INSERT INTO ewe_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Isak gblɔ na Yakob be, “Te ɖe ŋunye. Medi be mali asi ŋuwò, ale be maka ɖe edzi be Esau tututue!” ");
INSERT INTO ewe_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yakob te ɖe fofoa ŋu, eye wòli asi eŋu. Isak gblɔ na eɖokui be, “Gbe la nye Yakob tɔ, gake asiawo nye Esau tɔ!” ");
INSERT INTO ewe_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Isak di be yeayra Yakob, gake egabia be, ");
INSERT INTO ewe_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“Woe nye Esau nyateƒea?” Ke Yakob ɖo eŋu be, “Nyee!” ");
INSERT INTO ewe_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isak gblɔ be, “Vinye, ekema tsɔ nuɖuɖu la vɛ nam. Ne meɖui vɔ la, ekema mayra wò.” Yakob tsɔ nuɖuɖu la na fofoa wòɖu, eye wòno wain si Yakob tsɔ kpe ɖe nuɖuɖua ŋu la. ");
INSERT INTO ewe_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Emegbe Isak gblɔ be, “Vinye, te ɖe ŋunye, eye nàgbugbɔ nu nam!” ");
INSERT INTO ewe_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yakob te ɖe fofoa ŋu, eye wògbugbɔ eƒe alɔgo. Ʋeʋẽ si Isak se le awu siwo Yakob do me la na wòbu be Esaue. Eyrae hegblɔ be, “Ehɛ̃, Vinye ƒe ʋeʋẽ sɔ kple ʋeʋẽ nyui si dona tso anyigba kple agble si Yehowa yra la ene. ");
INSERT INTO ewe_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Mawu nana dziƒozãmu nadza ɖe wò nukuwo dzi ɣe sia ɣi, eye wòana bli kple wain yeye nasɔ gbɔ na wò. ");
INSERT INTO ewe_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Dukɔ geɖewo nazu kluviwo na wò. Àzu aƒetɔ ɖe nɔviwòwo dzi. Wò ƒometɔwo katã nade ta agu na wò. Woaƒo fi ade ame sia ame si aƒo fi de wò la, ke woayra ame sia ame si ayra wò la.” ");
INSERT INTO ewe_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Esi Isak yra Yakob vɔ teti, eye Yakob do go le fofoa ƒe xɔ me la, Esau gbɔ tso adegbea. ");
INSERT INTO ewe_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Eya hã ɖa nu si fofoa lɔ̃a ɖuɖu la, eye wòtsɔe yi nɛ. Esau gblɔ be, “Fofonye, metsɔ nuɖuɖu la vɛ na wò. Fɔ nàɖu nua, eye nàyram!” ");
INSERT INTO ewe_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Isak bia be, “Wò ame kae?” Esau ɖo eŋu be, “Nyee! Nye Esau, viwò ŋutsu tsitsitɔe!” ");
INSERT INTO ewe_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isak de asi ƒoƒo me kpakpakpa. Egblɔ be, “Ekema ame kae tsɔ nuɖuɖu vɛ nam fifi laa meɖu, eye meyrae kple yayra si womagate ŋu aɖe ɖa o la?” ");
INSERT INTO ewe_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esau de asi avifafa me hehehe. Egblɔ be, “Oo fofonye, yram! Yra nye hã!” ");
INSERT INTO ewe_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isak ɖo eŋu be, “Nɔviwò va flum, eye wòxɔ wò yayra.” ");
INSERT INTO ewe_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau gblɔ kple vevesese be, “Nu sia tututu tae woyɔe be Yakob si gɔmee nye ‘Amebala’ ɖo. Exɔ nye ŋgɔgbevinyenye le asinye, eye wògafi nye yayra hã. Oo, fofonye, yayra aɖeke megale asiwò nànam oa?” ");
INSERT INTO ewe_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isak ɖo eŋu gblɔ be, “Mewɔe wòzu aƒetɔ ɖe dziwò, metsɔ nɔviawo katã wɔ eƒe dɔlawoe, eye metsɔ bli kple wain hã nɛ. Nu kae gali matsɔ ana wò.” ");
INSERT INTO ewe_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esau xɔ nya la dzi gblɔ na fofoa be, “Yayra aɖeke mesusɔ nàtsɔ nam oa? Oo, fofonye yra nye hã!” Esau gade asi avifafa me, ke fofoa meke nu o. ");
INSERT INTO ewe_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Mlɔeba la, Isak gblɔ na Esau be, “Manɔ anyigba wɔnuku aɖeke dzi o, eye zãmu hã madza na wò akpɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Wò yi anyi wò eye àsubɔ nɔviwò va se ɖe ɣeyiɣi aɖe, ke emegbe la, àva do le ete, eye nàkpɔ ablɔɖe.” ");
INSERT INTO ewe_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Ale Esau lé fu nɔvia Yakob ɖe eƒe yayra si fofoa tsɔ nɛ la ta. Egblɔ na eɖokui be, “Esusɔ vie fofonye naku, ekema mawu Yakob.” ");
INSERT INTO ewe_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ke ame aɖe va nya nu tso Esau ƒe tameɖoɖo ŋu, eye wòɖo afɔ afɔta na Rebeka. Eya ta Rebeka yɔ Yakob, eye wògblɔ nɛ be, “Esau le nugbe ɖom ɖe wò agbe ŋuti.” ");
INSERT INTO ewe_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Rebeka yi edzi be, “Nu si nàwɔ fifia lae nye be nàsi ayi nyruiwò Laban gbɔ le Haran. ");
INSERT INTO ewe_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Nɔ afi ma va se ɖe esime nɔviwò ƒe dɔmedzoe nu nafa, ");
INSERT INTO ewe_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","eye wòaŋlɔ nu si nèwɔ ɖe eŋu la be. Ekema maɖo du ɖe wò, elabena manyo be mi ame evea siaa miabu ɖem gbe ɖeka o.” ");
INSERT INTO ewe_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Emegbe la, Rebeka gblɔ na Isak be, “Hiti ɖetugbiwo ƒe nya tim. Malɔ̃ be maku tsɔ wu be makpɔ Yakob wòaɖe wo dometɔ ɖeka.” ");
INSERT INTO ewe_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Isak yɔ Yakob, yrae, eye wògblɔ nɛ be, “Mègaɖe Kanaan nyɔnu siawo dometɔ aɖeke o, ");
INSERT INTO ewe_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","ke boŋ yi Padan Aram enumake, eye nàge ɖe tɔgbuiwò Betuel ƒe aƒe me, eye nàɖe nɔviwò siwo nye nyruiwò, Laban vinyɔnuwo la dometɔ ɖeka. ");
INSERT INTO ewe_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Mawu Ŋusẽkatãtɔ nayra wò, ana viwòwo nasɔ gbɔ, eye nàzu dukɔ gã aɖe! ");
INSERT INTO ewe_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Mawu nana yayra gã siwo ŋugbe wòdo na Abraham la nava wò kple wò dzidzimeviwo dzi. Anyigba si dzi míele fifia abe amedzrowo ene la nazu tɔwò, elabena Mawu tsɔe na Abraham.” ");
INSERT INTO ewe_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Ale Isak na Yakob yi Padan Aram be wòakpɔ nyruia Laban, ame si nye Betuel Arameatɔ la ƒe viŋutsu eye wòganye Yakob kple Esau dadaa Rebeka nɔviŋutsu la ɖa. ");
INSERT INTO ewe_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau kpɔ be ye fofo Isak yra Yakob, eye wòɖoe ɖe Padan Aram be wòaɖe srɔ̃ le afi ma, ke ede se na Yakob be, “Megaɖe Kanaan nyɔnu o.” ");
INSERT INTO ewe_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yakob ɖo to fofoa kple dadaa, eye wòyi Padan Aram. ");
INSERT INTO ewe_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esau de dzesii be Kanaan nyɔnuawo medze ye fofo Isak ŋu o. ");
INSERT INTO ewe_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ale Esau yi etɔgã, Ismael ƒe ƒome me, eye wòɖe srɔ̃ bubu eve tso afi ma kpe ɖe srɔ̃ siwo nɔ esi xoxo la ŋu. Srɔ̃ yeye siawo dometɔ ɖekae nye Mahalat, Nebayɔt nɔvi kple Ismael si nye Abraham ƒe viŋutsu la ƒe vinyɔnu. ");
INSERT INTO ewe_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yakob dzo le Beerseba, eye wòɖo ta Haran. ");
INSERT INTO ewe_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Esi zã do la, etsi teƒe aɖe dɔ, eye wòziɔ kpe aɖe abe suɖui ene be yeadɔ alɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Eku drɔ̃e kpɔ atsrɔe aɖe si didi tso anyigba yi ɖatɔ dziƒo, eye wòkpɔ mawudɔlawo nɔ eliam ganɔ ɖiɖim. ");
INSERT INTO ewe_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ekpɔ Yehowa wònɔ atsrɔe la tame, eye wògblɔ be, “Nyee nye Yehowa, Abraham ƒe Mawu kple fofowò Isak ƒe Mawu. Anyigba si dzi nèmlɔ la, matsɔe ana wò kple wò dzidzimeviwo, ");
INSERT INTO ewe_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","elabena wò dzidzimeviwo asɔ gbɔ abe ʋuʋudedi ene! Woakaka ɖe anyigba dzi tso ɣedzeƒe yi ɣetoɖoƒe, tso anyiehe yi dziehe, eye woayra dukɔwo katã le xexea me to wò kple wò dzidzimeviwo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Gawu la, meli kpli wò, makpɔ tawò le afi sia afi si nàyi la, eye makplɔ wò nàgbɔ ava anyigba sia dzi dedie. Manɔ kpli wò va se ɖe esime matsɔ nu siwo katã ŋugbe medo na wò la ana wò.” ");
INSERT INTO ewe_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Esime Yakob nyɔ tso alɔ̃ me la, egblɔ be, “Vavã, Yehowa le afi sia, gake nyemenya o.” ");
INSERT INTO ewe_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Egblɔ be, “Aleke gbegbe teƒe sia dzi ŋɔe! Teƒe sia menye teƒe bubu aɖeke wu Mawu ƒe aƒe o. Esiae nye dziƒogbo la.” ");
INSERT INTO ewe_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yakob fɔ ŋdi kanya, ɖi kpe si wòziɔ la abe ŋkuɖodzikpe ene, eye wòkɔ ami ɖe edzi. ");
INSERT INTO ewe_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ena ŋkɔ teƒea be Betel si gɔmee nye “Mawu ƒe Aƒe.” Tsã la, woyɔ du si te ɖe afi ma ŋu la be Luz. ");
INSERT INTO ewe_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yakob ɖe adzɔgbe na Mawu be, “Ne Mawu ave nunye, akpɔ tanye le nye mɔzɔzɔ sia me, ana nuɖuɖu kple nutatam, ");
INSERT INTO ewe_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","eye wòakplɔm magbɔ ava fofonye gbɔ dedie la, ekema matia Yehowa abe nye Mawu ene! ");
INSERT INTO ewe_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ŋkuɖodzikpe sia azu mawusubɔƒe, eye matsɔ nu sia nu si nànam la ƒe ewolia ana wò!” ");
INSERT INTO ewe_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yakob yi eƒe mɔzɔzɔ dzi, eye wòva ɖo ɣedzeƒenutowo me. ");
INSERT INTO ewe_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ekpɔ alẽha etɔ̃ wotsyɔ akɔ anyi ɖe gbe dzi le vudo aɖe to, nɔ lalam be woana tsi yewo yewoano. Ke wotsɔ kpe gã aɖe tu vudoa nu. ");
INSERT INTO ewe_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Enye woƒe kɔnu be womahe kpea ɖa o va se ɖe esime alẽhawo katã nava ɖo afi ma. Ne wona tsi alẽhawo katã wono vɔ la, wogamlia kpe la ɖoa vudo la nu. ");
INSERT INTO ewe_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yakob te ɖe alẽkplɔlawo ŋu, eye wòbia wo be, “Nɔvinyewo, afi ka míetso?” Woɖo eŋu be, “Míetso Haran.” ");
INSERT INTO ewe_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yakob bia be, “Mienya ame aɖe si woyɔna be Laban, eye wònye Nahor ƒe via?” Woɖo eŋu be, “Ɛ̃, míenyae.” ");
INSERT INTO ewe_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Egabia wo be, “Eli nyuiea?” Woɖo eŋu be, “Ɛ̃, eli nyuie, eye nuwo dze edzi nɛ. Kpɔ ɖa, via nyɔnu, Rahel kplɔ alẽwo gbɔnae.” ");
INSERT INTO ewe_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yakob gabia wo be, “Nu ka ta miana tsi alẽawo ale be woate ŋu agatrɔ ayi gbeɖuƒe o ɖo? Elabena zã medo haɖe o; ne mieƒo ƒu wo ɖe afi sia fifia la, dɔ awu wo.” ");
INSERT INTO ewe_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Woɖo eŋu nɛ be, “Míemlia kpea ɖa o va se ɖe esime alẽhawo kple alẽkplɔlawo katã va ƒo ƒu ɖe afi sia.” ");
INSERT INTO ewe_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Esi wonɔ nya siawo gblɔm la, Rahel va ɖo kple fofoa ƒe alẽwo, elabena alẽkplɔla wònye. ");
INSERT INTO ewe_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Esi Rahel nye Yakob dadaa nɔviŋutsu Laban ƒe vi, eye alẽawo nye Yakob nyrui tɔ ta la, Yakob yi vudo la gbɔ, mli kpea ɖa, eye wòna tsi nyruia ƒe alẽwo. ");
INSERT INTO ewe_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yakob gbugbɔ nu na Rahel, eye Yakob de asi avifafa me. ");
INSERT INTO ewe_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yakob gblɔ na Rahel be fofoa ƒe ƒometɔ kple Rebeka ƒe viŋutsu yenye. Ale Rahel ƒu du yi ɖagblɔ nya la na fofoa. ");
INSERT INTO ewe_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Esi Laban se nya sia tso Yakob, nɔvia nyɔnu ƒe viŋutsu ŋu la, eɖe abla yi ɖakpee. Ekpla asi kɔ nɛ, gbugbɔ nu nɛ, kplɔe yi aƒe me, eye Yakob gblɔ nyawo katã nɛ le afi ma. ");
INSERT INTO ewe_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban gblɔ be, “Kpɔ ɖa, nye ŋutɔ nye ŋutilã kple ʋue nènye.” Esi Yakob nɔ Laban gbɔ ɣleti ɖeka la, ");
INSERT INTO ewe_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban gblɔ nɛ gbe ɖeka be, “Menye esi nye kple wò míenye ƒometɔwo ta nàwɔ dɔ nam dzodzro o. Ho neni maxe na wò?” ");
INSERT INTO ewe_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Vinyɔnu eve nɔ Laban si. Tsitsitɔ ŋkɔe nye Lea, eye ɖevitɔ ŋkɔe nye Rahel. ");
INSERT INTO ewe_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea ƒe ŋkuwo nya kpɔna, eye Rahel ya dze tugbe ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Rahel ƒe nu nyo Yakob ŋu, eya ta Yakob gblɔ na Laban be, “Ne àtsɔ Rahel nam maɖe la, ekema mawɔ dɔ na wò ƒe adre.” ");
INSERT INTO ewe_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ɖo eŋu be, “Melɔ̃. Enyo nam be matsɔe na wò boŋ wu be matsɔe na ame bubu aɖe si medo ƒome kplim o.” ");
INSERT INTO ewe_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Ale Yakob subɔ ƒe adre ɖe Rahel ta. Ke ƒe adreawo ɖi ŋkeke ʋɛ aɖewo ko le eŋkume, elabena elɔ̃ Rahel ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Mlɔeba la, ɣeyiɣi la de be wòaɖee. Yakob gblɔ na Laban be, “Mewɔ nu si nèɖo nam la, eya ta ele na wò azɔ be nàɖe asi le srɔ̃nye ŋu nam madɔ kplii.” ");
INSERT INTO ewe_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ale Laban ɖo kplɔ̃ gã aɖe, eye wòkpe ŋutsu siwo katã nɔ dua me la be woakpɔ dzidzɔ kple Yakob. ");
INSERT INTO ewe_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Emegbe le zã me la, Laban kplɔ Lea yi na Yakob, eye Yakob dɔ egbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban tsɔ eƒe kosi Zilpa na Lea be wòanye eƒe dɔlanyɔnu. ");
INSERT INTO ewe_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ke esi ŋu ke la, Yakob kpɔ be Lea boŋ wona yeɖe! Yakob do dɔmedzoe, eye wòbia Laban be, “Amefuflu ka tɔgbie nye esia? Mesubɔ ƒe adre ɖe Rahel ta! Nu sia gɔme ɖe?” ");
INSERT INTO ewe_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ɖo eŋu be, “Mesɔ ɖe míaƒe kɔnyinyi nu be woaɖe ɖetugbi suetɔ gbã hafi woaɖe tsitsitɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Lala ne wò srɔ̃ɖeɖe ƒe kɔsiɖa gbãtɔ nava yi, ekema àte ŋu aɖe Rahel hã ne àgasubɔm ƒe adre bubu ko!” ");
INSERT INTO ewe_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yakob lɔ̃ be yeagasubɔ ƒe adre bubu, ale Laban tsɔ Rahel hã nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban tsɔ eƒe kosivi Bilha na Rahel be wòasubɔe. ");
INSERT INTO ewe_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ale Yakob dɔ Rahel hã gbɔ. Elɔ̃ Rahel sãa wu Lea, eye wògasubɔ ƒe adre bubu. ");
INSERT INTO ewe_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ke esi Yakob melɔ̃ Lea tututu o ta la, Yehowa na vi Lea, eye wòna Rahel tsi ko. ");
INSERT INTO ewe_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Ale Lea fɔ fu, eye wòdzi ŋutsuvi. Ena ŋkɔe be Ruben si gɔmee nye “Yehowa kpɔ nye xaxa,” elabena egblɔ be, “Yehowa kpɔ nye xaxa; azɔ la, srɔ̃nye alɔ̃m.” ");
INSERT INTO ewe_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Eteƒe medidi hafi Lea gafɔ fu o. Egadzi ŋutsuvi, eye wòna ŋkɔe be Simeon si gɔmee nye “Yehowa see,” elabena egblɔ be, “Yehowa see be womelɔ̃m o, eya ta wògana ŋutsuvi bubum.” ");
INSERT INTO ewe_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Egafɔ fu, eye wògadzi ŋutsuvi. Ena ŋkɔe be Levi si gɔmee nye “Kuku ɖe ame ŋu,” elabena egblɔ be, “Azɔ ya la, esi medzi ŋutsuvi etɔ̃ sɔŋ nɛ ta la, srɔ̃nye alɔ̃m kokoko.” ");
INSERT INTO ewe_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lea gafɔ fu, gadzi ŋutsuvi, eye wòna ŋkɔe be Yuda si gɔmee nye “Kafukafu,” elabena egblɔ be, “Azɔ makafu Yehowa!” Emegbe la, Lea megadzi vi bubu aɖeke o. ");
INSERT INTO ewe_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Esi Rahel kpɔ be yemele vi dzim o la, eʋã ŋu nɔvia nyɔnu. Egblɔ na Yakob be, “Na madzi vi, ne menye nenema o la, maku.” ");
INSERT INTO ewe_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yakob do dɔmedzoe, eye wòbiae be, “Alo nyee nye Mawu, ame si na nètsi koa?” ");
INSERT INTO ewe_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rahel gblɔ nɛ be, “Metsɔ nye subɔla Bilha na wò, dɔ egbɔ ne wòadzi vi, eye viawo nazu vinyewo.” ");
INSERT INTO ewe_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Ale wòtsɔ Bilha nɛ wòzu srɔ̃a, eye wòdɔ egbɔ; ");
INSERT INTO ewe_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","efɔ fu, eye wòdzi ŋutsuvi na Yakob. ");
INSERT INTO ewe_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rahel na ŋkɔe be Dan si gɔmee nye “Afiatsotso,” elabena egblɔ be, “Mawu tso afia nam, ese nye gbedodoɖa, eye wòna ŋutsuvim.” ");
INSERT INTO ewe_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Bilha, Rahel ƒe subɔla gafɔ fu, eye wòdzi ŋutsuvi evelia na Yakob. ");
INSERT INTO ewe_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rahel na ŋkɔe be Naftali si gɔmee nye “Hoʋiʋli,” elabena egblɔ be, “Mele ho ʋlim sesĩe kple nɔvinye, eye mele dzi ɖum!” ");
INSERT INTO ewe_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Azɔ esi Lea kpɔ be yemegale fu fɔm o la, etsɔ eƒe subɔla Zilpa na Yakob wòɖe. ");
INSERT INTO ewe_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Le ɣeyiɣi kpui aɖe megbe la, Lea ƒe kosi Zilpa dzi ŋutsuvi na Yakob. ");
INSERT INTO ewe_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea na ŋkɔe be Gad si gɔmee nye “Dzɔgbenyui ɖi kpem!” ");
INSERT INTO ewe_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Zilpa dzi ŋutsuvi evelia na Yakob, eye Lea na ŋkɔe be Aser si gɔmee nye “Dzidzɔ”, ");
INSERT INTO ewe_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","elabena egblɔ be, “Dzi dzɔm ale gbegbe! Nyɔnu bubuwo abu be woyram vavã!” ");
INSERT INTO ewe_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Gbe ɖeka le lũŋeɣi la, Ruben gbe agbitsa aɖewo tso gbe me vɛ na dadaa Lea. Rahel ɖe kuku na Lea be wòana agbitsa la ƒe ɖe ye. ");
INSERT INTO ewe_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ke Lea ɖo eŋu nɛ kple dɔmedzoe be, “Èxɔ srɔ̃nye le asinye sesẽtɔe! Ɖe esia mesɔ gbɔ na wò oa? Azɔ ɖe nèdi be yeagaxɔ vinye ƒe agbitsa hã?” Rahel gblɔ nublanuitɔe be, “Ne àna agbitsa la ƒe ɖem la, mana mɔ srɔ̃nye wòadɔ gbɔwò ɖe agbitsa la nu.” ");
INSERT INTO ewe_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Gbe ma gbe fiẽ, esi Yakob tso gbedzi gbɔna la, Lea yi ɖakpee, gblɔ nɛ be, “Egbe la, nye gbɔe nàdɔ, elabena metsɔ agbitsa siwo vinye gbe vɛ la na Rahel ɖe tawò!” Ale Yakob dɔ Lea gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mawu se Lea ƒe gbedodoɖa, eye wòfɔ fu dzi ŋutsuvi atɔ̃lia nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lea na ŋkɔe be Isaka si gɔmee nye “Fetu,” elabena egblɔ be, “Mawu tu fe nam, elabena metsɔ nye kosivi na srɔ̃nye wòɖe.” ");
INSERT INTO ewe_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Egafɔ fu, eye wòdzi ŋutsuvi adelia na Yakob. ");
INSERT INTO ewe_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ena ŋkɔe be Zebulon si gɔmee nye “Nunana,” elabena egblɔ be, “Mawu tsɔ nu nyuiwo to dzinye na srɔ̃nye. Azɔ la, srɔ̃nye abum, elabena medzi ŋutsuvi ade nɛ.” ");
INSERT INTO ewe_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Emegbe la, edzi nyɔnuvi, eye wòna ŋkɔe be Dina. ");
INSERT INTO ewe_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Tete Mawu ɖo ŋku Rahel dzi le eƒe xaxa me, eye wòse eƒe gbedodoɖa heʋu eƒe vidzidɔ nu. ");
INSERT INTO ewe_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Efɔ fu, dzi ŋutsuvi, eye wògblɔ be, “Mawu ɖe nye ŋukpe ɖa.” ");
INSERT INTO ewe_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ena ŋkɔ ɖevi la be Yosef, eye wògblɔ be, “Yehowa natsɔ ŋutsuvi bubu akpee nam.” ");
INSERT INTO ewe_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Esi Rahel dzi Yosef vɔ megbe teti ko la, Yakob gblɔ na Laban be, “Medi be matrɔ ayi aƒe. ");
INSERT INTO ewe_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Na makplɔ srɔ̃nyewo kple vinyewo ɖe asi, elabena wò ŋutɔ ènya ale si mesubɔ wò ɖe wo tae.” ");
INSERT INTO ewe_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laban gblɔ nɛ be, “Meɖe kuku, mègadzo le gbɔnye o, elabena to nukaka me la, menya be wò afi sia nɔnɔe na mekpɔ yayra geɖe siawo. ");
INSERT INTO ewe_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ho neni mada ɖe fetu dzi na wò be nàganɔ gbɔnye? Ho sia ho si wòanye la, maxee na wò.” ");
INSERT INTO ewe_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yakob ɖo eŋu be, “Ènya ale si mesubɔ wò anukwaretɔe le ƒe geɖe siawo me kple ale si wò lãwo dzii, ");
INSERT INTO ewe_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","elabena nu sue aɖe koe nɔ asiwò hafi meva gbɔwò. Fifia wò kesinɔnuwo dzi ɖe edzi ŋutɔ. Yehowa yra wò to nu sia nu si mewɔ la me! Ke ɣe ka ɣi nye ya manɔ ɖokuinye si awɔ dɔ na srɔ̃nyewo kple vinyewo?” ");
INSERT INTO ewe_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban gabiae be, “Nu ka mana wò?” Yakob ɖo eŋu nɛ be, “Mègana nanekem o. Ke ne àwɔ nu ɖeka sia nam la, mayi wò lãwo dzi kpɔkpɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Na matsa le wò lãhawo katã me egbe, eye maɖe alẽ siwo katã le ŋɔtaŋɔta la kple alẽvi ɖe sia ɖe si le yibɔ kple gbɔ̃ siwo le ŋɔtaŋɔta la. Woawoe anye nye fetu. ");
INSERT INTO ewe_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ekema ɣe sia ɣi si nàkpɔ gbɔ̃ ɣi alo alẽ ɣi aɖe le tɔnyewo dome la, nànya be ɖe mefi wo tso tɔwòwo dome!” ");
INSERT INTO ewe_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban lɔ̃ ɖe edzi be, “Enyo; míawɔe abe ale si nègblɔe ene!” ");
INSERT INTO ewe_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Gbe ma gbe ke la, eɖe gbɔ̃tsu siwo katã ŋu fli le alo le ŋɔtaŋɔta kple gbɔ̃nɔ siwo katã ŋu fli le, esiwo katã le ɣie kple alẽvi siwo katã le yibɔ la ɖe aga, eye wòtsɔ wo de via ŋutsuwo ƒe dzikpɔkpɔ te. ");
INSERT INTO ewe_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ena eya ŋutɔ kple Yakob dome didi abe ŋkeke etɔ̃ ƒe azɔlizɔzɔ ene, eye Yakob yi Laban ƒe lãwo dzi kpɔkpɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yakob lã atilɔ fɛ̃ aɖewo, kpa tsro le akpa aɖewo ŋu, ale be wozu ŋɔtaŋɔta, eye fli to ɖewo me. ");
INSERT INTO ewe_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Etsɔ wo da ɖe lãwo ƒe tsinoƒe, ale be lãwo nakpɔ wo ne wova tsinoƒe, afi si lãtsuwo yɔa asi lãnɔwo le la. ");
INSERT INTO ewe_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Lãtsuawo yɔa asi le atilɔawo gbɔ, eye lãnɔawo dzia vi siwo le ŋɔtaŋɔta alo esiwo ŋu fli le la. ");
INSERT INTO ewe_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Eye Yakob ɖe lãviawo ɖa le tsitsiawo ŋu, ke ena bubuawo dze ŋgɔ lã siwo le ŋɔtaŋɔta kple esiwo le yibɔɔ henye Laban tɔ. Ewɔ lãha aɖe na eɖokui, eye mena wotɔtɔ kple Laban ƒe lãwo o. ");
INSERT INTO ewe_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Kpe ɖe esia ŋu la, ne ekpɔ be lã sesẽwo le asi yɔm la, etsɔa atilɔ siwo wòŋlɔ la dana ɖe tsinoƒea be woafɔ fu ɖe ati ŋɔŋlɔawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ke ne lã beliwo le asi yɔm la, eɖea ati ŋɔŋlɔawo ɖa. Ale alẽ siwo ƒe lãme mesẽ tututu o la zua Laban tɔ, eye esiwo le lãmesẽ me la zua Yakob tɔ! ");
INSERT INTO ewe_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Esia ta Yakob ƒe alẽwo dzi ɖe edzi kabakaba, eye wòzu hotsuitɔ gã aɖe. Subɔlawo, kposɔwo kple tedziwo sɔ gbɔ ɖe esi fũu. ");
INSERT INTO ewe_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yakob va nya be Laban ƒe viwo nɔ liʋĩliʋĩ lĩm be, “Nu sia nu si le esi la do tso mía fofo ƒe nuwo me. Eƒe kesinɔnuwo katã tso mía fofo gbɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yakob de dzesii be Laban megakɔa ŋkume ɖe ye o. ");
INSERT INTO ewe_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Yehowa ƒo nu na Yakob gblɔ be, “Trɔ nàyi fofowò ƒe anyigba dzi, nànɔ wò ƒometɔwo dome le afi ma, eye manɔ kpli wò.” ");
INSERT INTO ewe_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Eya ta gbe ɖeka Yakob ɖo du ɖe Rahel kple Lea be woava kpɔ ye le alẽhawo gbɔ le gbedzi, ");
INSERT INTO ewe_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ale be yewoalé nya aɖewo kpɔ. Yakob gblɔ na wo be, “Mia fofo tso ɖe ŋunye, ke fofonyewo ƒe Mawu va ƒo nu nam. ");
INSERT INTO ewe_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Mienya ale si mewɔ dɔ sesĩe na mia fofo, ");
INSERT INTO ewe_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ke mewɔ nu dzɔdzɔe ɖe ŋunye o; eda le ɖoɖo siwo míewɔ ɖe nye fetu ŋu la dzi zi geɖe. Ke Mawu meɖe mɔ nɛ be wòawɔ nuvevi aɖekem o! ");
INSERT INTO ewe_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Elabena ne egblɔ be lã ŋɔtaŋɔtawo nanye tɔnye la, ekema lã siwo wodzi la nɔa ŋɔtaŋɔta. Esi wòtrɔ ɖoɖo la hegblɔ be lã siwo me fli to nazu tɔnyewo la, fli nɔa lãawo katã ŋuti. ");
INSERT INTO ewe_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ale Mawu na mezu hotsuitɔ to mia fofo ƒe lãha si wòxɔ tsɔ nam ta. ");
INSERT INTO ewe_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Le lãawo ƒe asiyɔɣi la, meku drɔ̃e, eye mekpɔ be gbɔ̃tsu siwo katã nɔ asi yɔm la nye lã siwo me fli to kple esiwo nɔ ŋɔtaŋɔta la. ");
INSERT INTO ewe_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mawudɔla aɖe yɔm le drɔ̃ea me be, ‘Yakob,’ eye metɔ be, ‘Nyee nye esi.’ ");
INSERT INTO ewe_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Eye wògblɔ nam be mana gbɔ̃tsu siwo me fli le kple esiwo le ŋɔtaŋɔta la nayɔ asi gbɔ̃nɔ ɣiawo.” Egblɔ be, “Elabena mekpɔ nu siwo katã Laban wɔ ɖe ŋuwò la. ");
INSERT INTO ewe_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Nyee nye Mawu si ɖe ɖokuinye fia wò le Betel, afi si nèkɔ ami ɖe kpe dzi le, eye nèɖe adzɔgbe be yeasubɔm. Azɔ la, ele na wò be nàdzo le afi sia, eye nàyi afi si wodzi wò ɖo la.” ");
INSERT INTO ewe_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rahel kple Lea ɖo eŋu be, “Nu sia nyo na mí! Naneke mele afi sia na mí o; mía fofo ƒe kesinɔnuwo dometɔ aɖeke mazu domenyinu na mí o! ");
INSERT INTO ewe_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ele nuwo wɔm ɖe mía ŋu abe amedzrowo míenye ene. Etsɔ mí dzra, eye nu si wòxɔ ɖe mía ta hã megali o. ");
INSERT INTO ewe_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Le sea nu la, kesinɔnu siwo Mawu tsɔ na wò to mía fofo dzi la nye mí kple mía viwo tɔ, eya ta wɔ nu sia nu si Mawu be nàwɔ la.” ");
INSERT INTO ewe_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yakob kɔ viawo kple srɔ̃awo ɖo kposɔwo dzi, eye wodzo. ");
INSERT INTO ewe_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ke ena wokplɔ eƒe lãhawo do ŋgɔe kpe ɖe nunɔamesi siwo katã wòkpɔ le Padan Aram la ŋuti ɖo ɖe fofoa Isak le Kanaanyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Esi Laban yi ɖe fu ko ge na eƒe alẽwo la, Rahel fi fofoa ƒe aklamakpakpɛwo tsɔ dzoe. ");
INSERT INTO ewe_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Gawu la, Yakob flu Laban, Arameatɔ la, eye meklãe hafi dzo o. ");
INSERT INTO ewe_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ale wòsi kple eƒe nunɔamesiwo katã. Esi wòtso Frat tɔsisi la, eɖo ta Gilead ƒe tonyigbawo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ŋkeke etɔ̃ va yi hafi Laban nya nu tso Yakob ƒe sisi ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ekplɔ ame aɖewo ɖe asi, eye wodze eyome kple du heva tui le ŋkeke adre megbe le Gilead to la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Gbe ma gbe la, Mawu ɖe eɖokui fia Laban Arameatɔ le drɔ̃e me, eye wògblɔ nɛ be, “Kpɔ nyuie le nu si nàgblɔ na Yakob la ŋuti. Mègayrae o, eye mègaƒo fi dee hã o.” ");
INSERT INTO ewe_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Laban va tu Yakob esime Yakob tu agbadɔ ɖe Gilead to la dzi. Laban hã tu eƒe agbadɔ ɖe to la te. ");
INSERT INTO ewe_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban bia Yakob be, “Nu kae nye esi nèwɔ hesi dzo le adzame ale? Ɖe vinyenyɔnuwo nye aboyome siwo wolé le aʋa me, eya ta nèkplɔ wo si dzoe alea? ");
INSERT INTO ewe_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Nu ka ta mèna mɔnukpɔkpɔm be maɖo kplɔ̃ na mi, eye hadzidzi, ʋuƒoƒo kple kasaŋkuƒoƒo nanɔ anyi o ɖo? ");
INSERT INTO ewe_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Nu ka ta mèna megbugbɔ nu na nye tɔgbuiyɔviwo hedo hedenyui na wo o ɖo? Nu sia nye nu trama aɖe si nèwɔ. ");
INSERT INTO ewe_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Mate ŋu awɔ nuvevi wò hafi, gake fofowò ƒe Mawu la ɖe eɖokui fiam le zã si va yi la me, eye wògblɔ nam be, ‘Kpɔ nyuie be màklẽ ŋku ade Yakob o.’ ");
INSERT INTO ewe_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ke esi nèkpɔ be ele be yeadzo, eye aƒe nɔ dzrowòm vevie nenema ɖe, nu ka ta nèfi nye aklamakpakpɛwo dzoe ɖo?” ");
INSERT INTO ewe_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yakob ɖo eŋu na Laban be, “Mesi dzo, elabena menɔ vɔvɔ̃m. Megblɔ na ɖokuinye be, ‘Àva xɔ viwò nyɔnuwo le asinye sesẽtɔe.’ ");
INSERT INTO ewe_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ke le wò aklamakpakpɛwo gome la, woaƒo fi ade ame si fi wo la, eye wòaku! Ka nye nuwo katã me le mía nɔviawo ƒe ŋkume kpɔ be wò nane le wo me mahã. Ne èkpɔ wò nane si mefi dzoe la, ekema tsɔe.” Ke Yakob menya be Rahel fi aklamakpakpɛawo o. ");
INSERT INTO ewe_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban yi ɖaka Yakob ƒe agbadɔ me gbã; emegbe eyi ɖaka Lea kple kosi eveawo ƒe agbadɔ me, gake mekpɔ aklamakpakpɛawo o. Esia megbe la, eyi ɖaka Rahel tɔ me azɔ. ");
INSERT INTO ewe_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rahel nye ame si fi aklamakpakpɛawo. Etsɔ wo ɣla ɖe eƒe kposɔ ƒe akpa te, eye wònɔ anyi ɖe wo dzi. Togbɔ be Laban ka agbadɔawo me abe ale si wòate ŋui ene hã la, mete ŋu kpɔ aklamakpakpɛawo o. ");
INSERT INTO ewe_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rahel gblɔ na fofoa be, “Papa, tsɔe kem be nyemate ŋu atsi tsitre o, elabena mekpɔ dzinu.” ");
INSERT INTO ewe_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yakob do dɔmedzoe ɖe Laban ŋu, eye wòbiae be, “Nu vɔ̃ ka mewɔ? Vo ka meda si ta nànɔ fu ɖem nam ale? ");
INSERT INTO ewe_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Azɔ esi nèka nye nuwo katã me ɖe, nu ka nèkpɔ si nye tɔwò? Tsɔe da ɖe wò ƒometɔwo kple tɔnyewo ŋkume, eye nàna woadrɔ̃ ʋɔnu le nye kpli wò dome. ");
INSERT INTO ewe_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Menɔ gbɔwò ƒe blaeve sɔŋ. Le ɣeyiɣi ma katã me la, mekpɔ wò alẽnɔwo kple gbɔ̃nɔwo dzi, ale be wodzi vi lãmesesẽtɔwo na wò, eye nyemewu wò agbo ɖeka pɛ gɔ̃ hã ɖa ɖu o. ");
INSERT INTO ewe_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ne lã wɔadãwo wu ɖewo la, ɖe metsɔa wo fiaa wò be nàɖe wo tso wò lãwo domea? Ao, meɖoa eteƒe na wò. Èna mexe fe ɖe wò lã ɖe sia ɖe si wofi tso wò lãhawo me la ta, eɖanye nye vodada, alo menye nye vodada o! ");
INSERT INTO ewe_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","“Mewɔ dɔ na wò, ŋdɔkutsu ɖum le ŋkeke me, eye vuvɔ wɔm le zã me, eye nyemedɔa alɔ̃ o. ");
INSERT INTO ewe_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ɛ̃, mewɔ dɔ na wò ƒe blaeve sɔŋ: ƒe wuiene be mate ŋu aɖe viwò nyɔnu eve, ƒe ade be lãha sia naka asinye! Gawu la, èɖe nye fetu dzi zi ewo. ");
INSERT INTO ewe_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Nyateƒe, ne menye tɔgbuinye Abraham ƒe Mawu kple fofonye Isak ƒe Mawu ƒe amenuveve tae o la, anye ne èdo mɔm asi ƒuƒlu, pesewa ɖeka pɛ gɔ̃ hã manɔ asinye o! Ke Mawu kpɔ wò ŋutasesẽ kple nye nuteƒewɔwɔ, eya ta wòɖe eɖokui fia wò le zã si va yi me.” ");
INSERT INTO ewe_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban ɖo eŋu na Yakob be, “Vinyewoe nye nyɔnu siawo; ɖevi siawo hã tɔnyewoe. Lãha siawo kple nu siwo katã le asiwò la, tɔnyee wonye, eya ta nu ka ta mawɔ nuvevi nye ŋutɔ vinyewo kple nye tɔgbuiyɔviwo ɖo? ");
INSERT INTO ewe_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Na míabla ŋutifafanu kple mía nɔewo, eye mía dometɔ ɖe sia ɖe nazɔ ɖe nubabla sia ƒe ɖoɖowo dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Ale Yakob ɖi kpe aɖe abe ŋkuɖodzikpe ene, ");
INSERT INTO ewe_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","eye wògblɔ na eƒe amewo be woafɔ kpewo ali kɔ ɖe kpe la dzi. Emegbe Yakob kple Laban ɖu nu ɖekae le kpeawo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban yɔe be Yegar Sahaduta, eye Yakob yɔe be Galed. ");
INSERT INTO ewe_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban gblɔ be, “Kpoƒuƒu sia nye ɖasefo le nye kpli wò dome egbea.” Eya ta woyɔe be Galed. ");
INSERT INTO ewe_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Eya ta woyɔe hã be “Mizpa” si gɔmee nye “Nuŋudzɔla,” elabena Laban gblɔ be, “Aƒetɔ la nakpɔ egbɔ be ne míegale mía nɔewo gbɔ o hã la, míazɔ ɖe nubabla sia dzi. ");
INSERT INTO ewe_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kpe ɖe esia ŋu la, ne èwɔ fu vinyewo alo ègaɖe srɔ̃ bubuwo la, nyemanya o, gake Mawu ya akpɔe.” ");
INSERT INTO ewe_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laban gblɔ na Yakob be, “Kpekɔ sia le afi sia, eye sɔti sia si metu ɖe nye kpli wò dome la hã le afi sia. ");
INSERT INTO ewe_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Kpekɔ sia nye ɖasefo, eye sɔti sia hã nye ɖasefo be nyemava to kpekɔ sia ŋu be mava wò akpa dzi ava wɔ nuvevi aɖeke wò o, eye be wò hã màto kpekɔ kple sɔti sia ŋu ava nye akpa dzi be nàva wɔ nuvevi aɖekem o. ");
INSERT INTO ewe_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Meyɔ Abraham kple Nahor kpakple wo fofowo ƒe Mawu la be wòatsrɔ̃ mía dometɔ si mawɔ nubabla sia ƒe ɖoɖowo dzi o la.” Ale Yakob ka atam le fofoa Isak ƒe Mawu, Ŋusẽkatãtɔ la ŋkume be yealé ŋku ɖe liƒo la ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Tete Yakob sa vɔ na Mawu le to la tame, eye wòɖo kplɔ̃ na eƒe amewo. Etsi wo gbɔ dɔ le to la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban fɔ ŋdi kanya, gbugbɔ nu na viawo kple eƒe tɔgbuiyɔviawo, yra wo, eye wòtrɔ yi wo de. ");
INSERT INTO ewe_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yakob kple eƒe amewo gadze mɔ, eye mawudɔlawo va do goe. ");
INSERT INTO ewe_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Esi Yakob kpɔ wo la, edo ɣli be, “Mawu ƒe asaɖae nye esia!” Eya ta ena ŋkɔ teƒea be Mahanaim. ");
INSERT INTO ewe_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yakob dɔ amewo ɖe foa Esau gbɔ le Edom le Seirnyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Egblɔ na wo bena, “Ale miagblɔ na nye aƒetɔ Esau enye si: ‘Nye Wò dɔla Yakob, meyi ɖanɔ mía nyrui, Laban gbɔ va se ɖe egbe. ");
INSERT INTO ewe_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Fifia nyiwo, tedziwo, alẽwo kple subɔla geɖewo, ŋutsuwo kple nyɔnuwo siaa le asinye. Mele ame siawo ɖom ɖa be woana nyanya wò nye aƒetɔ be megbɔna, eye mele mɔ kpɔm be àxɔ mí nɔvitɔe.’ ” ");
INSERT INTO ewe_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ame dɔdɔawo trɔ tso Esau gbɔ va gblɔ na Yakob be Esau gbɔna Yakob kpe ge kple ame alafa ene! ");
INSERT INTO ewe_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Vɔvɔ̃ ɖo Yakob. Ema eƒe amewo kple lãhawo kpakple kposɔwo ɖe akpa eve, ");
INSERT INTO ewe_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","elabena egblɔ be, “Ne Esau adze hatsotso ɖeka dzi la, ɖewohĩ hatsotso evelia me tɔwo ate ŋu asi.” ");
INSERT INTO ewe_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Tete Yakob do gbe ɖa be “O, tɔgbuinye Abraham kple fofonye Isak ƒe Mawu, O, Yehowa, wò ame si gblɔ nam be matrɔ va nye ƒometɔwo ƒe anyigba dzi, eye nèdo ŋugbe be yeawɔ nyui nam la, ");
INSERT INTO ewe_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","nyemedze na wò amenuveve si nèɖena fiaam edziedzi abe ale si nèdo ŋugbe nam ene o, elabena esi metso Yɔdan la, naneke menɔ asinye wu atizɔti ɖeka o! Ke azɔ la, mezu aʋakɔ eve! ");
INSERT INTO ewe_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O, Yehowa, meɖe kuku na wò, ɖem tso tsɔtsrɔ̃ me le fonye Esau ƒe asi me, elabena mele vɔvɔ̃m ŋutɔ be ava ho aʋa ɖe nye ŋutɔ, srɔ̃nyewo kple vinyewo ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ke èdo ŋugbe be yeawɔ nyui nam, eye yeana nye dzidzimeviwo nasɔ gbɔ abe ƒutake ene, eye womate ŋu axlẽ wo o.” ");
INSERT INTO ewe_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Etsi afi ma dɔ, eye wòtia nu siwo nɔ esi la ƒe ɖe na foa Esau: ");
INSERT INTO ewe_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","gbɔ̃nɔ alafa eve kple gbɔ̃tsu blaeve, alẽnɔ alafa eve kple agbo blaeve, ");
INSERT INTO ewe_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","kposɔnɔ blaetɔ̃ kple wo viwo, nyinɔ blaene kple nyitsu ewo, tedzinɔ blaeve kple tedzitsu ewo. ");
INSERT INTO ewe_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Egblɔ na eƒe subɔlawo be woadze ŋgɔ kple lãha siawo, lãha ɖe sia ɖe nanɔ eɖokui si, eye dometsotso nanɔ wo dome. ");
INSERT INTO ewe_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Egblɔ na ame siwo le lãha gbãtɔ kplɔm la be ne wodo go Esau, eye wòbia wo be, “Afi ka yim miele? Ame ka ƒe subɔlawo mienye? Ame ka ƒe lãwoe nye esiawo?” la, ");
INSERT INTO ewe_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","woaɖo eŋu be, “Wò subɔla, Yakob ƒe lãwoe. Wonye nunana na eƒe aƒetɔ Esau! Ele mía yome gbɔna!” ");
INSERT INTO ewe_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yakob gblɔ nya mawo ke na lãkplɔla bubuawo hã be woagblɔ na Esau. ");
INSERT INTO ewe_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Yakob ƒe tameɖoɖoe nye be yeakpata Esau kple nunanawo hafi yeado goe ŋkume kple ŋkume! Yakob kpɔ mɔ be, “Ɖewohĩ axɔ mí nyuie.” ");
INSERT INTO ewe_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ale wòɖo nunanawo ɖa do ŋgɔ, eye Yakob gatsi asaɖa me dɔ. ");
INSERT INTO ewe_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Le zã me la, Yakob fɔ, eye wòkplɔ srɔ̃a eveawo, eƒe kosi eveawo kple via wuiɖekɛawo, eye wotso Yɔdan tɔsisi la le tɔtsoƒe si ŋkɔe nye Yabok. ");
INSERT INTO ewe_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ale wòkplɔ wo tso tɔ lae kple eƒe nunɔamesiwo katã. ");
INSERT INTO ewe_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yakob trɔ va asaɖa la me, eye eya ɖeka nɔ afi ma. Ŋutsu aɖe te kame kplii va se ɖe fɔŋli. ");
INSERT INTO ewe_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Esi ŋutsu la kpɔ be yemate ŋu aɖu Yakob dzi o la, etɔ asi Yakob ƒe aligo, eye ƒuawo gli le enu. ");
INSERT INTO ewe_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Tete ŋutsu la gblɔ nɛ be, “Ɖe asi le ŋunye mayi, elabena ŋu le kekem.” Ke Yakob ɖo eŋu be, “Nyemele asi ɖe ge le ŋuwò o, negbe ɖeko nàyram hafi.” ");
INSERT INTO ewe_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ŋutsu la biae be, “Ŋkɔwò ɖe?” Eɖo eŋu be, “Yakob.” ");
INSERT INTO ewe_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ŋutsu la gblɔ nɛ be, “Womagayɔ wò azɔ nenema o! Woayɔ wò azɔ be Israel, ame si te kame kple Mawu. Esi nète kame kple Mawu ta la, àɖu amewo dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yakob biae be, “Wò hã ŋkɔwò ɖe?” Ŋutsu la ɖo eŋu be, “Nu ka ta nèbia ŋkɔnye ta ɖo.” Eye wòyrae le afi ma. ");
INSERT INTO ewe_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yakob na ŋkɔ teƒea be “Peniel” si gɔmee nye “Mawu ƒe ŋkume,” elabena egblɔ be, “Mekpɔ Mawu ŋkume kple ŋkume, gake metsi agbe.” ");
INSERT INTO ewe_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Esi wògadze mɔ ko la, ɣe dze. Le eƒe aligoƒu si gli ta la, ede asi tɔtɔ me. ");
INSERT INTO ewe_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Esia ta Israelviwo meɖua ka titri si to lãwo ƒe aligo dzi o, elabena wotɔ asi ka si le Yakob ƒe aligokpeƒe la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yakob kpɔ Esau le adzɔge ʋĩi wògbɔna kple eƒe ame alafa ene. Ke ema ɖeviawo na Lea, Rahel kple kosi eveawo. ");
INSERT INTO ewe_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ena eƒe kosiwo kple wo viwo nɔ ŋgɔ, Lea kple viawo nɔ eyome, eye Rahel kple Yosef nɔ wo katã megbe. ");
INSERT INTO ewe_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yakob dze wo katã ŋgɔ. Egogo foa, eye wòde ta agu nɛ zi adre. ");
INSERT INTO ewe_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esau ƒu du yi ɖakpee, kpla asi kɔ nɛ lɔlɔ̃tɔe, eye wògbugbɔ nu nɛ. Wo ame eveawo fa avi hehehe! ");
INSERT INTO ewe_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau kpɔ nyɔnuawo kple ɖeviawo, eye wòbia be, “Ame kawoe nye esiawo le ŋuwò?” Yakob ɖo eŋu be, “Vinyewoe, Mawue na ɖevi siawo nye wò subɔla to eƒe amenuveve me.” ");
INSERT INTO ewe_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kosiawo kple wo viwo va ŋgɔ, eye wode ta agu nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Emegbe Lea kple etɔwo va, eye woawo hã de ta agu nɛ. Azɔ Rahel kple Yosef va, eye woawo hã de ta agu nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau bia be, “Lãha kawoe nye esiwo kpɔm mele?” Yakob ɖo eŋu be, “Woawoe nye nye nunanawo na wò nye aƒetɔ be nàve nunye.” ");
INSERT INTO ewe_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau ko nu gblɔ be, “Nɔvinye, lãwo sɔ gbɔ ɖe asinye xoxo; tɔwòwo nenɔ asiwò ko!” ");
INSERT INTO ewe_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yakob yi edzi be, “Ao, xɔ nunanawo nam ko, elabena wò alɔgbɔnu si nèko xɔlɔ̃tɔe nam la na nya la kɔ le dzinye! Vɔvɔ̃ ɖom le ŋutiwò abe Mawu ƒe ŋkumee mekpɔ ene. ");
INSERT INTO ewe_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Meɖe kuku, xɔ nye nunanawo ko, elabena Mawu yram, eye nu geɖe le asinye.” Yakob ƒoe ɖe enu, eye Esau lɔ̃ xɔ nunanawo. ");
INSERT INTO ewe_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau gblɔ be, “Enyo, mina míadze mɔ. Nye kple nye amewo, míanɔ mia ŋu, eye míadze ŋgɔ na mi.” ");
INSERT INTO ewe_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Ke Yakob ɖo eŋu be, “Nye aƒetɔ, ɖeviawo dometɔ aɖewo metsi o, eye nenema ke vidzĩwo le lãwo dome. Ne míedo du wo akpa la, woaku, ");
INSERT INTO ewe_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","eya ta nye aƒetɔ, miawo mido ŋgɔ, eye míawo míadze mia yome ɖɔɖɔɖɔ ava tu mi le Seir.” ");
INSERT INTO ewe_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esau gblɔ be, “Enyo, mana nye ame aɖewo nakpe ɖe mia ŋu, eye woanye kplɔlawo na mi.” Yakob gbe be, “Ao, nye aƒetɔ, míanɔ edzi ɖɔɖɔɖɔ ava tu mi. Meɖe kuku, na wòanɔ abe ale si megblɔ ene.” ");
INSERT INTO ewe_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Ale Esau trɔ ɖo ta Seir gbe ma gbe ke. ");
INSERT INTO ewe_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yakob kple eƒe amewo yi ɖaɖo Sukɔt. Etu agbletaxɔ kple lãkpowo ɖe afi ma, eya ta woyɔa teƒe ma be Sukot si gɔmee nye “Agbletaxɔwo.” ");
INSERT INTO ewe_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Emegbe la, Yakob tso Padan Aram va ɖo Sekem le Kanaanyigba dzi dedie, eye wònɔ du la godo. ");
INSERT INTO ewe_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Eƒle anyigba si dzi wònɔ la le Sekem fofo, Hamor ƒe ƒometɔwo si klosalo alafa ɖeka. ");
INSERT INTO ewe_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Etu vɔsamlekpui aɖe ɖe afi ma, eye wòna ŋkɔe be, “El-Elohe-Israel” si gɔmee nye “Vɔsamlekpui na Israel ƒe Mawu.” ");
INSERT INTO ewe_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Gbe ɖeka la, Dina, Lea ƒe vinyɔnu si wòdzi na Yakob la ɖi tsa be yeakpɔ ye xɔlɔ̃ ɖetugbi aɖewo ɖa. ");
INSERT INTO ewe_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ke esi Fia Hamor, Hivitɔ ƒe viŋutsu, Sekem kpɔe la, elée hedɔ egbɔ sesẽtɔe. ");
INSERT INTO ewe_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekem lɔ̃ Dina si nye Yakob ƒe vinyɔnu vevie, eye wòdze agbagba be eya hã nalɔ̃ ye to enubeble me. ");
INSERT INTO ewe_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sekem gblɔ na fofoa Hamor be, “Medi be maɖe ɖetugbi sia, eya ta ɖee nam.” ");
INSERT INTO ewe_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Nu si Sekem wɔ ɖe Dina ŋu la va ɖo Yakob ƒe to me. Esi via ŋutsuwo nɔ nyi kplɔm le gbedzi hafi wòse nya la ta la, mewɔ naneke tso nya la ŋu o va se ɖe esime via ŋutsuawo trɔ gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Tete Sekem fofo, Hamor do go be yeaƒo nu kple Yakob. ");
INSERT INTO ewe_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Azɔ la, Yakob ƒe viŋutsuwo gbɔ tso gbedzi esime wose nya si dzɔ la. Vevesese kple dziku yɔ wo me, elabena Sekem wɔ ŋukpenanu le Israel esime wòdɔ Yakob ƒe vinyɔnu gbɔ sesẽtɔe, nu si mele be wòawɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor gblɔ na Yakob be, “Vinye Sekem lɔ̃ viwò Dina ŋutɔ, eye wòdi vevie be wòazu ye srɔ̃. Meɖe kuku, ɖe mɔ nɛ wòaɖee. ");
INSERT INTO ewe_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mina míaɖe srɔ̃ le mía nɔewo dome; mitsɔ miaƒe vinyɔnuwo na mí, eye míawo hã míatsɔ míaƒe vinyɔnuwo na mi miaɖe. ");
INSERT INTO ewe_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Miate ŋu atsi mía dome; anyigba la li faa na mi. Minɔ edzi, mitsa asi le edzi, eye miakpɔ viɖe le edzi.” ");
INSERT INTO ewe_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Emegbe la, Sekem gblɔ na Dina fofo kple nɔvia ŋutsuwo be, “Meɖe kuku, mive nunye, eye miana Dina nazu srɔ̃nye. Mana nu sia nu si miabia la mi. ");
INSERT INTO ewe_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Tabianu alo nunana ka ke miabia la, mana mi; mina wòazu srɔ̃nye ko!” ");
INSERT INTO ewe_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Yakob ƒe viŋutsuwo ble Sekem kple Hamor; wowɔ nu madzɔmadzɔ sia ɖe nu si Sekem wɔ ɖe wo nɔvinyɔnu Dina ŋu ta. ");
INSERT INTO ewe_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Wogblɔ be, “Míate ŋui gbeɖe o, elabena mietso aʋa o. Anye ŋukpe na mía nɔvinyɔnu la be wòaɖe bolobolotɔ. ");
INSERT INTO ewe_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nu si míawɔ lae nye be ne miaƒe ŋutsuwo dometɔ ɖe sia ɖe atso aʋa la, ");
INSERT INTO ewe_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ekema miaɖe míaƒe nyɔnuwo, eye míaƒe ŋutsuwo hã aɖe miaƒe nyɔnuwo, míanɔ mia gbɔ, eye míawɔ ɖeka kpli mi, míazu dukɔ ɖeka. ");
INSERT INTO ewe_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","“Ne mielɔ̃ ɖe edzi eye wotso aʋa na mi o la, ekema míaxɔ mía nɔvinyɔnu la, eye míaʋu le mia gbɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Nya sia trɔ na Hamor kple Via ŋutsu Sekem. ");
INSERT INTO ewe_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ɖekakpui la, ame si nye bubume wu ame bubuawo katã le fofoa ƒe aƒe me la wɔ ɖe ɖoɖo si wowɔ la dzi enumake, elabena elɔ̃ Yakob ƒe vinyɔnu la. ");
INSERT INTO ewe_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ale Hamor kple Sekem wɔ takpekpe kple dua me ŋutsuwo katã le dua ƒe agbo nu, eye wòtsɔ nya la ɖo wo ŋkume. ");
INSERT INTO ewe_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Hamor kple Sekem gblɔ be, “Ameawo nye mía xɔlɔ̃wo. Mina míana woatsi afi sia, anɔ mía dome, eye woawɔ woƒe dɔ, elabena míaƒe anyigba lolo; woakpɔ teƒe le edzi, woaɖe srɔ̃ tso mía dome, eye míawo hã míaɖe wo viwo. ");
INSERT INTO ewe_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Ke hafi esia nate ŋu ava eme la, nu ɖeka koe wobia; eyae nye be míaƒe ŋutsu ɖe sia ɖe natso aʋa abe woawo ene. ");
INSERT INTO ewe_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","“Ne míewɔ esia la, ekema woƒe lãhawo, kesinɔnuwo kple dɔwɔlã siwo nye wo tɔ la azu mía tɔ, eye kesinɔnuwo ava míaƒe dukɔa me. Mina míalɔ̃ ɖe woƒe biabia sia dzi, ale be woanɔ mía dome.” ");
INSERT INTO ewe_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ke Ŋutsu siwo katã va ƒo ƒu ɖe dua ƒe agbo nu la, ɖo to Hamor kple via Sekem eye wolɔ̃, wotso aʋa na wo katã. ");
INSERT INTO ewe_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ke le ŋkeke etɔ̃ megbe esi abia le wo vem la, Yakob ƒe viŋutsu eve, Simeon kple Levi siwo nye Dina nɔviwo la tsɔ woƒe yiwo, ge ɖe dua me, eye wowu ŋutsu ɖe sia ɖe. ");
INSERT INTO ewe_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Wowu Hamor kple Sekem hã, eye wokplɔ Dina tso Sekem ƒe aƒe me hetrɔ yi wo nɔƒe. ");
INSERT INTO ewe_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Emegbe Yakob ƒe viwo katã yi dua me, eye woha nuwo le dua me ɖe esi wogblẽ wo nɔvinyɔnu la ta. ");
INSERT INTO ewe_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Wolé woƒe alẽwo, nyiwo kple tedziwo kpakple nu siwo katã dzi woƒe asi su le dua me kple woƒe agblewo me la hã. ");
INSERT INTO ewe_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Wokplɔ woƒe nyɔnuwo kple ɖeviwo siaa dzoe, eye woha kesinɔnu ɖe sia ɖe ƒomevi. ");
INSERT INTO ewe_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yakob gblɔ na Levi kple Simeon be, “Miena medze agɔ le anyigba sia dzi tɔwo katã, Kanaantɔwo kple Perizitɔwo siaa dzi. Míesɔ gbɔ o, eya ta ne woho aʋa ɖe mía ŋu la, woafiti mí, eye woawu mí katã.” ");
INSERT INTO ewe_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Woɖo eŋu be, “Ɖe wònyo be Sekem nabu mía nɔvinyɔnu la abe gbolo enea?” ");
INSERT INTO ewe_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Mawu gblɔ na Yakob be, “Ʋu le afi sia nàyi aɖanɔ Betel, eye nàɖi vɔsamlekpui, asubɔ Mawu si ɖe eɖokui fia wò le esime nèsi le fowò Esau nu la!” ");
INSERT INTO ewe_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Eya ta Yakob gblɔ na eŋumewo katã be woagblẽ aklamakpakpɛ siwo katã wotsɔ ɖe asi vɛ la ɖi, woale tsi, eye woaɖɔli woƒe awuwo. ");
INSERT INTO ewe_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Eyi edzi be, “Elabena míele Betel yim, eye maɖi vɔsamlekpui aɖe ɖe afi ma na Mawu si se nye gbedodoɖawo le nye xaxaɣi, eye wònɔ anyi kplim le nye mɔzɔzɔ me la.” ");
INSERT INTO ewe_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Ale wotsɔ woƒe aklamakpakpɛwo kple togɛwo katã na Yakob, eye wòɖi wo ɖe ati gã aɖe te le Sekem. ");
INSERT INTO ewe_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Emegbe la, wodze mɔ. Mawu na vɔvɔ̃ dze du siwo katã me woto la dzi, ale be womeho aʋa ɖe wo ŋu o. ");
INSERT INTO ewe_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Mlɔeba la, Yakob kple eƒe amewo va ɖo Luz si wogayɔna hã be Betel le Kanaan. ");
INSERT INTO ewe_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yakob ɖi vɔsamlekpui ɖe afi ma, eye wòna ŋkɔe be, “Vɔsamlekpui na Betel ƒe Mawu,” elabena Betel ƒe Mawu ɖe eɖokui fiae le esime wònɔ sisim le Esau nu. ");
INSERT INTO ewe_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Eteƒe medidi o la, Debora, ame si kpɔ Rebeka dzi le ɖevime la ku, eye woɖii ɖe ati gã aɖe si le balime si le Betel ƒe anyigbe lɔƒo la te. Tso gbe ma gbe dzi la, woyɔa teƒe ma be, “Konyifafa ƒe ati.” ");
INSERT INTO ewe_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Esime Yakob va ɖo Betel le eƒe mɔzɔzɔ tso Padan Aram me la, Mawu gaɖe eɖokui fiae, eye wòyrae. ");
INSERT INTO ewe_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Mawu gblɔ nɛ be, “Wò ŋkɔe nye Yakob, gake womagayɔ wò azɔ be Yakob si gɔmee nye ‘Amebala’ o, ke boŋ woayɔ wò azɔ be Israel si gɔmee nye ‘Ame si te kame kple Mawu.’ ");
INSERT INTO ewe_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Nyee nye Mawu Ŋusẽkatãtɔ. Mana nàdzi fũu, eye nàzu dukɔ gã aɖe. Dukɔ geɖewo kple fia geɖewo ado tso wò dzidzimeviwo me. ");
INSERT INTO ewe_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Mana anyigba si metsɔ na Abraham kple Isak la nazu tɔwò, eye wòava zu wò dzidzimeviwo tɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Eye Mawu dzo le egbɔ, afi si wòƒo nu kplii le la. ");
INSERT INTO ewe_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yakob tsɔ kpe tu sɔti aɖe ɖe teƒe si Mawu ƒo nu kplii le la, eye wòwɔ nunovɔsa ɖe edzi; ekɔ ami hã ɖe edzi. ");
INSERT INTO ewe_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yakob na ŋkɔ teƒea be Betel si gɔmee nye, “Mawu ƒe Aƒe,” elabena afi ma Mawu ƒo nu kplii le. ");
INSERT INTO ewe_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Emegbe la, wodzo le Betel, eye woɖo ta Efrat alo Betlehem lɔƒo. Ke Rahel de asi kuléle me le esime azɔli didi aɖe ganɔ ŋgɔ na wo. ");
INSERT INTO ewe_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Via dzidzi sesẽ na Rahel. Mlɔeba la, vixela la do ɣli be, “Mègabu mɔkpɔkpɔ o, elabena esia hã ganye ŋutsuvi!” ");
INSERT INTO ewe_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Esime Rahel nɔ kudɔ ƒom la, ena ŋkɔ ɖevi la be, “Ben Oni” si gɔmee nye “Nye Konyifafa ƒe Vi,” eye wòku. Yakob ya na ŋkɔ ɖevi la be “Benyamin” si gɔmee nye “Nye Nuɖusi ƒe Vi.” ");
INSERT INTO ewe_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ale Rahel ku, eye woɖii ɖe mɔ si yi Efrat alo Betlehem la to. ");
INSERT INTO ewe_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yakob tu ŋkuɖodzikpe si gali va se ɖe egbe la ɖe Rahel ƒe yɔdo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israel gayi mɔzɔzɔ dzi, eye wòtu agbadɔ ɖe Eder mɔ godo. ");
INSERT INTO ewe_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Esi wònɔ afi ma la, Ruben dɔ kple fofoa ƒe kosi, Bilha, eye ame aɖe fi tofi na Israel. Yakob ƒe viŋutsu wuieveawo ƒe ŋkɔwoe nye: ");
INSERT INTO ewe_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea ƒe viŋutsuwo: Ruben, Yakob ƒe viŋutsu tsitsitɔ, Simeon, Levi, Yuda, Isaka kple Zebulon. ");
INSERT INTO ewe_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rahel ƒe viŋutsuwo: Yosef kple Benyamin. ");
INSERT INTO ewe_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bilha, Rahel ƒe kosi ƒe viwo: Dan kple Naftali. ");
INSERT INTO ewe_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zilpa, Lea ƒe kosi ƒe viwo: Gad kple Aser. Wodzi vi siawo katã nɛ le Padan Aram. ");
INSERT INTO ewe_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Mlɔeba la, Yakob va ɖo fofoa, Isak gbɔ le Mamre le Kiriat Arba (teƒe si wogayɔna be Hebron), afi si Abraham hã nɔ. ");
INSERT INTO ewe_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isak nɔ agbe ƒe alafa ɖeka blaenyi (180). ");
INSERT INTO ewe_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Etsɔ eƒe gbɔgbɔ na, eye wòyi tɔgbuiawo gbɔ. Enɔ agbe wòde edeƒe, eye via ŋutsuwo, Esau kple Yakob ɖii. ");
INSERT INTO ewe_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esau (ame si wogayɔna hã be Edom) la ƒe dzidzimeviwo yi ale: ");
INSERT INTO ewe_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau ɖe Kanaan nyɔnu etɔ̃: Ada, Hititɔ Elon ƒe vi, Oholibama, Ana ƒe vi kple Hivitɔ Zibeon ƒe tɔgbuiyɔvi kpakple ");
INSERT INTO ewe_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Basemat, Ismael ƒe vinyɔnu si nye Nebayɔt nɔvinyɔnu. ");
INSERT INTO ewe_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esau kple Ada dzi viŋutsu ɖeka si ŋkɔe nye Elifaz. Esau kple Basemat dzi viŋutsu si ŋkɔe nye Reuel. ");
INSERT INTO ewe_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Esau kple Oholibama dzi viŋutsu siwo ƒe ŋkɔwoe nye Yeus, Yalam kple Korah. Wodzi vi siawo katã na Esau le Kanaanyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau kplɔ srɔ̃awo, viŋutsuwo kple vinyɔnuwo kpakple subɔla siwo le eƒe aƒe me, kple lãhawo kple kesinɔnu siwo katã wòkpɔ le Kanaanyigba dzi la, eye wòʋu le nɔvia Yakob gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Woƒe nunɔamesiwo sɔ gbɔ ale gbegbe be womagate ŋu anɔ teƒe ɖeka o. Anyigba si dzi wole la megalolo na wo ame eveawo o le woƒe lãhawo ta. ");
INSERT INTO ewe_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ale Esau, ame si wogayɔna be Edom la yi ɖanɔ tonyigba dzi le Seir. ");
INSERT INTO ewe_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esau ƒe dzidzimeviwo, Edomtɔwo, ame siwo wodzi nɛ le Seir to dzi la ƒe ŋkɔwo yi ale: ");
INSERT INTO ewe_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esau ƒe viŋutsuwo: gbãtɔe nye Elifaz si Ada dzi nɛ, eveliae nye Reuel si Basemat dzi nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaz ƒe viŋutsuwoe nye: Teman, Omar, Zefo, Gatam kple Kenaz. ");
INSERT INTO ewe_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna si nye Elifaz, Esau ƒe viŋutsu ƒe ahiãvi la dzi Amalek. Ame siawoe nye Ada, Esau srɔ̃ ƒe viwo. ");
INSERT INTO ewe_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reuel ƒe viŋutsuwoe nye: Nahat, Zera, Sama kple Miza. Ame siawoe nye Esau ƒe tɔgbuiyɔviwo to srɔ̃a Basemat dzi. ");
INSERT INTO ewe_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau srɔ̃ Oholibama, Ana ƒe vinyɔnu kple Zibeon ƒe mamayɔvi si wodzi na Esau la dzi Yeus, Yalam kple Korah. ");
INSERT INTO ewe_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Ame siawoe nye fiawo le Esau ƒe dzidzimeviwo dome. Elifaz, ame si nye Esau ƒe viŋutsu gbãtɔ, Teman, Omar, Zefo kple Kenaz, ");
INSERT INTO ewe_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam kple Amalek. Ame siawo nye fia siwo dzɔ tso Elifaz me le Edom. Wonye Ada ƒe mamayɔviwo. ");
INSERT INTO ewe_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Hlɔ̃ siwo gbɔna la, nye Reuel, ame si Esau kple srɔ̃a Basemat dzi le esime wonɔ Kanaan la ƒe dzidzimeviwo: Amegã Nahat, Amegã Zera, Amegã Sama kple Amegã Miza. Woawoe nye amegã siwo dzɔ tso Reuel me le Edomnyigba dzi, eye wonye Esau srɔ̃ Basemat ƒe viwo. ");
INSERT INTO ewe_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau srɔ̃ Oholibama ƒe viŋutsuwo nye fia siawo: Yeus, Yalam kple Korah. Wodzɔ tso Esau srɔ̃ Oholibama, Ana ƒe vinyɔnu me. ");
INSERT INTO ewe_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ame siawo nye Esau alo Edom ƒe viŋutsuwo, eye ame siawoe nye woƒe fiawo. ");
INSERT INTO ewe_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ame siawo nye Seir, Horitɔ la ƒe viŋutsuwo, ame siwo nɔ nuto la me: Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO ewe_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dison, Ezer kple Disan. Wonye viŋutsuwo na Horitɔ Seir le Edom, eye wonye fiawo. ");
INSERT INTO ewe_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan ƒe viwoe nye, Hori kple Heman. Timna nye Lotan nɔvinyɔnu. ");
INSERT INTO ewe_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal ƒe viŋutsuwoe nye: Alvan, Manahat, Ebal, Sefo kple Onam. ");
INSERT INTO ewe_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon ƒe viwoe nye: Aya kple Ana. (Eyae fɔ tsi dzidzi xɔdzo aɖe ƒe vudo le gbegbe esime wònɔ fofoa ƒe tedziwo kplɔm.) ");
INSERT INTO ewe_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana ƒe viwoe nye: Dison kple Oholibama. ");
INSERT INTO ewe_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison ƒe viwoe nye: Hemdan, Esban, Itran kple Keran. ");
INSERT INTO ewe_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer ƒe viwoe nye: Bilhan, Zaavan kple Akan. ");
INSERT INTO ewe_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan ƒe viŋutsuwoe nye: Uz kple Aran. ");
INSERT INTO ewe_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Ame siawoe nye Horitɔwo ƒe fiawo. Lotan, Sobal, Zibeon, Ana, ");
INSERT INTO ewe_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dison, Ezer kple Disan. Ame siawoe nye Horitɔwo ƒe fiawo le woƒe tokɔ vovovoawo nu le Seirnyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ame siwo ɖu fia le Edom hafi woɖo Israel fiaɖuƒe la gɔme anyi la woe nye: ");
INSERT INTO ewe_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor ƒe vi Bela si ɖu fia le Edom. Du si me wònɔ la ŋkɔe nye Dinhaba. ");
INSERT INTO ewe_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Esi Bela ku la, Yobab, Zera ƒe vi si tso Bozra la zu fia. ");
INSERT INTO ewe_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Esi Yobab ku la, Husam si tso Temanitɔwo ƒe anyigba dzi la ɖu fia ɖe eteƒe. ");
INSERT INTO ewe_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hadad, Bedad ƒe vi, ame si ɖu Midiantɔwo dzi le Moabnyigba dzi la ɖu fia le Husam ƒe ku megbe. Eƒe fiadue nye Avit. ");
INSERT INTO ewe_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Esi Hadad trɔ megbe la, Samla tso Masreka ɖu fia ɖe eteƒe. ");
INSERT INTO ewe_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Le Samla ƒe ku megbe la, Siaul tso Rehobot, du si le tɔsisi aɖe ŋu la ɖu fia ɖe eteƒe. ");
INSERT INTO ewe_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Le Siaul ƒe ku megbe la, Baal Hanan, Akbor ƒe vi ɖu fia ɖe eteƒe. ");
INSERT INTO ewe_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Esi Baal Hanan, Akbor ƒe viŋutsu la hã ku la, Hadad ɖu fia ɖe eteƒe, eye eƒe fiadue nye Pau. Srɔ̃a ŋkɔe nye Mehetabel, Matred ƒe vinyɔnu kple Mezahab ƒe mamayɔvi. ");
INSERT INTO ewe_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esiawoe nye fia siwo dzɔ tso Esau me la ƒe ŋkɔwo ɖe woƒe towo kple nutowo ƒe ɖoɖo nu: Timna, Alva, Yetet, ");
INSERT INTO ewe_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholibama, Ela, Pinon, ");
INSERT INTO ewe_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO ewe_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel kple Iram. Esiawoe nye Edom fiawo le ɖoɖo si me wonɔ le anyigba dzi la nu. Wonye Esau, Edomtɔwo fofo ƒe dzidzimeawo. ");
INSERT INTO ewe_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ale Yakob gatso aƒe ɖe Kanaan, afi si fofoa nɔ la. ");
INSERT INTO ewe_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Esiae nye Yakob ƒe dzidzimeviwo ŋutinya. Fifia Yakob ƒe vi Yosef xɔ ƒe wuiadre. Eya kple fofoviawo, ame siwo nye fofoa srɔ̃wo Bilha kple Zilpa ƒe viwo ƒe dɔe nye be woakpɔ wo fofo ƒe lãwo dzi. Yosef gblɔa nu madzemadze siwo nɔviawo wɔna la na wo fofo. ");
INSERT INTO ewe_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel lɔ̃ Yosef wu via bubuawo, elabena wodzi Yosef nɛ esime wònye amegãɖeɖi. Ale gbe ɖeka Yakob tɔ awu ʋlaya nyui aɖe nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Yosef nɔviwo de dzesi lɔlɔ̃ tɔxɛ si wo fofo tsɔ nɛ la, eya ta wolé fui, eye womeƒoa nu nɛ kple nɔvilɔlɔ̃ ƒe gbe o. ");
INSERT INTO ewe_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Gbe ɖeka la, Yosef ku drɔ̃e, eye wòlĩi na nɔviawo. Nu sia gadzi nɔviawo ƒe fuléle ɖe edzi! ");
INSERT INTO ewe_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Egblɔ be, “Miɖo to miase nye drɔ̃e la ɖa. ");
INSERT INTO ewe_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Míeyi ɖanɔ mɔlu blam le gbedzi; tete nye mɔlu babla tsi tsitre, eye mia tɔwo katã va ƒo xlãe, eye wode ta agu nɛ.” ");
INSERT INTO ewe_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Nɔviawo gblɔ nɛ fewuɖutɔe be, “Ekema ɖe nèdi be yeazu fia ɖe mía dzia?” Ale wogalé fui ɖe edzi wu le eƒe drɔ̃e la kple eƒe nyawo ta. ");
INSERT INTO ewe_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yosef gaku drɔ̃e bubu, eye wògalĩi na nɔviawo be, “Mise nye drɔ̃e si megaku la ɖa. Ɣe, ɣleti kple ɣletivi wuiɖekɛ de ta agu nam!” ");
INSERT INTO ewe_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Azɔ ya la, elĩ drɔ̃e la na fofoa kple nɔviawo siaa, ke fofoa ka mo nɛ hebiae be, “Drɔ̃e ka tɔgbie nye esia? Ɖe nye kple dawò kple nɔviwòwo míava de ta agu na wò gbe ɖekaa?” ");
INSERT INTO ewe_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nɔviawo ʋã ŋui ɖe edzi wu, gake fofoa ya de ŋugble le nya la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Gbe ɖaka la, Yosef nɔviwo kplɔ wo fofo ƒe alẽwo yi gbedzi le Sekem. ");
INSERT INTO ewe_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israel gblɔ na Yosef be, “Abe ale si nènyae ene la, nɔviwòwo le alẽawo dzi kpɔm le teƒe si te ɖe Sekem ŋu. Va madɔ wò ɖe nɔviwòwo gbɔ.” Yosef ɖo eŋu be, “Enyo.” ");
INSERT INTO ewe_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ale wògblɔ nɛ be, “Yi nàkpɔe ɖa be nu sia nu le edzi yim nyuie na nɔviwòwo kple woƒe lãwo hã, eye nàva gblɔe nam.” Ale wòɖoe ɖa le Hebron ƒe Balime. Esime Yosef ɖo Sekem la, ");
INSERT INTO ewe_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ŋutsu aɖe kpɔe le gbea dzi, eye wòbiae be, “Ame ka dim nèle?” ");
INSERT INTO ewe_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosef ɖo eŋu be, “Nɔvinyewo kple woƒe alẽwo dim mele; èkpɔ wo nama?” ");
INSERT INTO ewe_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ŋutsu la ɖo eŋu be, “Ɛ̃, womegale afi sia o; mese nɔviwòwo nɔ gbɔgblɔm be yewoayi Dotan.” Ale Yosef dze wo yome yi Dotan, eye wòkpɔ wo le afi ma. ");
INSERT INTO ewe_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ke esi wògbɔna la, wodze sii tso adzɔge ke, eye woɖo be yewoawui! ");
INSERT INTO ewe_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Wogblɔ na wo nɔewo be, “Drɔ̃ekula ma gbɔna ɖaa! ");
INSERT INTO ewe_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Mina míawui atsɔ eƒe ŋutilã aƒu gbe ɖe vudo siawo dometɔ ɖeka me, eye míagblɔ be lã wɔadã aɖee vuvui. Ekema míakpɔ nu si ado tso eƒe drɔ̃ekuku la me ɖa.” ");
INSERT INTO ewe_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Esi Ruben se nya sia la, edze agbagba be yeaɖee tso woƒe asi me. Egblɔ be, “Migana míawui o. ");
INSERT INTO ewe_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Migakɔ ʋu aɖeke ɖi o. Midae ɖe vudo sia me le gbegbe la, gake migade asi eŋu o.” Ruben gblɔ nya sia be yeaɖee tso woƒe asi me, eye yeakplɔe ayi na fofoa. ");
INSERT INTO ewe_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Eya ta esi Yosef ɖo nɔviawo gbɔ la, woɖe eƒe awu ʋlaya la le eŋu, ");
INSERT INTO ewe_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","eye wolée da ɖe vudo aɖe si me tsi menɔ o la me. ");
INSERT INTO ewe_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Wonɔ anyi, ɖu nu; kasia wokpɔ kposɔ aɖewo le didiƒe gbɔna wo gbɔ. Wonye Ismaeletɔ asitsala siwo tso Gilead la, eye wotsɔ aŋe, lifi kple kotoklobo yina ɖe Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yuda gblɔ na nɔviawo be, “Viɖe ka míakpɔ ne míewu mía nɔvi, eye míetsyɔ nu eƒe ʋu dzi? ");
INSERT INTO ewe_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","“Mina míadzrae na Ismaeletɔwo, eye míade asi eŋu o, elabena mía nɔviŋutsue; míawo ŋutɔ míaƒe ŋutilã kple ʋue.” Nɔviawo lɔ̃ ɖe edzi. ");
INSERT INTO ewe_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ale esi Midiansitsalawo va ɖo wo gbɔ la, woɖe Yosef le vudo la me, dzrae na Ismaeletɔwo klosalo blaeve, eye wokplɔe yi Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruben menɔ anyi hafi nɔviawo dzra Yosef o. Emegbe esi wòtrɔ gbɔ la, eyi be yeaɖe Yosef le vudo la me, ke esi wòkpɔ be Yosef megale vudoa me o la, evee ŋutɔ, eye wòdze eƒe awuwo. ");
INSERT INTO ewe_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Efa avi hegblɔ na nɔviawo be, “Ɖevi la megale vudo la me o; ke afi ka nye ya mayi fifia?” ");
INSERT INTO ewe_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nɔviawo wu gbɔ̃ aɖe, eye wotsɔ Yosef ƒe awuwo bliba ɖe gbɔ̃ la ƒe ʋu me. ");
INSERT INTO ewe_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Wotsɔ awu la yi na wo fofo be wòakpɔ ɖa be ame ka tɔe mahã. Wogblɔ nɛ be, “Míekpɔ awu sia le gbedzi. Yosef tɔe loo alo menye etɔe oa?” ");
INSERT INTO ewe_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Wo fofo kpɔe dze sii enumake. Efa avi gblɔ be, “Ɛ̃, vinye ƒe awue. Lã wɔadã aɖee lée; eme kɔ ƒãa be lã wɔadã aɖe vuvu Yosef.” ");
INSERT INTO ewe_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Israel dze eƒe awuwo, ta akpanya, eye wòfa konyi le via ƒe ku ta kɔsiɖa geɖewo. ");
INSERT INTO ewe_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ƒometɔwo katã dze agbagba be yewoafa akɔ nɛ do kpoe. Egblɔna be, “Medi be maku le vinye la fafa me,” eye wògawoa avi hehehe! ");
INSERT INTO ewe_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Midiantɔwo kplɔ Yosef yi Egipte, eye wodzrae na Potifar, ame si nye Egipte fia, Farao ƒe aƒedzikpɔla kple eŋudzɔsrafowo ƒe amegã. ");
INSERT INTO ewe_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Le ɣe ma ɣi me la, Yuda ʋu le nɔviawo gbɔ heyi Adulam, eye wònɔ ŋutsu aɖe si ŋkɔe nye Hira la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Yuda do go Kanaan nyɔnu aɖe si nye Sua ƒe vi la le afi ma, eye wòɖee. ");
INSERT INTO ewe_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Efɔ fu, eye wòdzi ŋutsuvi, eye wòna ŋkɔe be Er. ");
INSERT INTO ewe_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Egafɔ fu, dzi ŋutsuvi, eye wòna ŋkɔe be Onan. ");
INSERT INTO ewe_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Egadzi ŋutsuvi ake, eye wòtsɔ ŋkɔ nɛ be Sela; teƒe si wodzii le lae nye Kezib. ");
INSERT INTO ewe_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Esi via Er tsi la, Yuda na wòɖe nyɔnuvi aɖe si ŋkɔe nye Tamar. ");
INSERT INTO ewe_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ke Er, Yuda ƒe ŋgɔgbevi nye ŋutsu vɔ̃ɖi aɖe, eya ta Yehowa wui. ");
INSERT INTO ewe_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yuda gblɔ na Er nɔviŋutsu Onan be, “Ele be nàɖe Tamar abe ale si míaƒe se di tso ame kuku nɔviŋutsu si be wòawɔ ene, ale be Tamar ƒe vi siwo wòadzi na wò la nanyi nɔviwò kukua ƒe dome.” ");
INSERT INTO ewe_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Ke Onan medi be yeadzi vi si womabu abe ye ŋutɔ tɔ ene o, eya ta togbɔ be eɖe Tamar hã la, ɣe sia ɣi si wòadɔ Tamar gbɔ la, enana eƒe ŋutsutsi la duduna ɖe aba la dzi, ale be Tamar mafɔ fu adzi vi si anye nɔvia kukua tɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Le Yehowa gbɔ la, enye nu vɔ̃ Onan wɔ be wògbe be yemadzi vi na ye nɔvi kukua o, eya ta Yehowa wu eya hã. ");
INSERT INTO ewe_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Eya ta Yuda gblɔ na toyɔvia, Tamar be megaɖe srɔ̃ azɔ le ɣe ma ɣi me o, ke boŋ wòatrɔ ayi wo de le edzilawo gbɔ, eye wòanye ahosi va se ɖe esime ye vi suetɔ, Sela natsi ate ŋu aɖee. Ke Yuda meɖo le nyateƒe me be Sela naɖee o, gake egblɔ nenema, elabena evɔ̃ be Mawu ava wu eya hã abe ale si wòwu foa eveawo ene. Ale Tamar yi wo de le edzilawo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Le ɣeyiɣi aɖe megbe la, Yuda srɔ̃ ku. Le kunuwɔwɔ nɛ vɔ megbe la, Yuda kple exɔlɔ̃, Hira, Adulamtɔ la yi Timna be woakpɔ fukoko na alẽwo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Esi ame aɖe gblɔ na Tamar be toa dze Timna mɔ dzi hegbɔna fu ko ge na alẽawo, ");
INSERT INTO ewe_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","eye esi wònya azɔ kɔtɛe be womaɖe mɔ yeaɖe Sela o, togbɔ be Sela tsi azɔ hã la, eɖe eƒe ahovɔ da ɖi, eye wòtsɔ motsyɔvɔ tsyɔ mo, ale be womagadze si ye o. Enɔ anyi ɖe mɔ to le Enaim si le Timna mɔ dzi la ƒe agbo nu. ");
INSERT INTO ewe_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda kpɔe esime wòva yina, eye wòbu be gboloe le eƒe motsyɔvɔ la ta. ");
INSERT INTO ewe_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ale Yuda gogoe hebiae be wòana yeadɔ egbɔ, ke menya be ye ŋutɔ yeƒe toyɔvie o. Tamar biae be, “Ho neni nàxe nam?” ");
INSERT INTO ewe_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yuda do ŋugbe nɛ be, “Maɖo gbɔ̃vi aɖe ɖe wò tso nye lãwo dome.” Tamar biae be, “Nu ka nàtsɔ ade awɔba, ale be maka ɖe edzi be àɖo gbɔ̃vi la ɖem?” ");
INSERT INTO ewe_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda biae be, “Enyo, awɔbanu kae nèhiã?” Tamar ɖo eŋu be, “Tsɔ wò ŋkɔsigɛ si nètsɔna dea dzesi wò nuwo kple wò atizɔti nam.” Ale Yuda tsɔ wo nɛ. Tamar lɔ̃ Yuda dɔ egbɔ, eye wòfɔ fu. ");
INSERT INTO ewe_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Le esia megbe la, Tamar gade asi eƒe ahovɔ la tata me abe tsã ene. ");
INSERT INTO ewe_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yuda gblɔ na exɔlɔ̃ Hira, Adulamtɔ la be wòalé gbɔ̃vi la ayi na Tamar, eye wòaxɔ awɔbanuawo vɛ, ke Hira mete ŋu ke ɖe Tamar ŋu o. ");
INSERT INTO ewe_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hira bia dua me ŋutsuwo be, “Afi ka gbolo si nɔa ŋutsuwo dim le mɔ to le Enaim dua ƒe agbonu la le?” Woɖo eŋu be, “Gbolo aɖeke menɔ afi sia kpɔ o.” ");
INSERT INTO ewe_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Ale wòtrɔ va Yuda gbɔ, gblɔ nɛ be yemete ŋu ke ɖe eŋu o, eye wògblɔ nya si dua me ŋutsuwo gblɔ nɛ la na Yuda. ");
INSERT INTO ewe_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yuda gblɔ be, “Ekema awɔbanuawo netsi egbɔ faa! Míedze agbagba ale si míate ŋui. Ne míegale eyome tim kokoko la, dua me tɔwo ako mí. Meɖo gbɔ̃tsu la ɖee, ke mèkpɔe o.” ");
INSERT INTO ewe_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Le ɣleti etɔ̃ megbe la, woɖo du ɖe Yuda be toyɔvia Tamar fɔ fu le gbolowɔwɔ ta. Yuda do ɣli be, “Mihee vɛ, eye miatɔ dzoe!” ");
INSERT INTO ewe_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ke esi wohee yina wuwu ge la, eɖo du ɖe toa be, “Ame si tɔ ŋkɔsigɛ kple eŋuti ka kple atizɔti sia nye la, eya tututue nye ɖevi si dzi ge megbɔna la fofo. Ènya nane tso ŋkɔsigɛ kple atizɔti sia ŋua?” ");
INSERT INTO ewe_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yuda lɔ̃ be ye tɔwoe, eye wògblɔ be, “Etɔ dzɔ, elabena megbe be nyemawɔ ŋugbedodo dzi atsɔe na vinye, Sela wòaɖe o.” Tso ema dzi la, megadɔ kplii kpɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Eƒe vidziɣi ɖo, eye wòdzi evenɔvi siwo nye ŋutsuviwo. ");
INSERT INTO ewe_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Esi wònɔ ɖeviawo dzim la, vixela la sa ka dzĩ aɖe ɖe ɖevi si do gbɔna gbã la ƒe alɔnu, ");
INSERT INTO ewe_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","ke ɖevi la he asi ɖe megbe yi dadaa ƒe dɔ me, eye wodzi ɖevi evelia gbã. Vixela la bia be, “Nu ka ta nèdo ŋgɔ na nɔviwòa ɖo?” Tso gbe ma gbe dzi la, woyɔa ɖevi sia be Perez si gɔmee nye “Ŋgɔdodo.” ");
INSERT INTO ewe_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Eteƒe medidi hafi wodzi ɖevi si ƒe alɔnu ka dzĩ la le la o. Wona ŋkɔe be Zera. ");
INSERT INTO ewe_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Esi Ismaeletɔwo kplɔ Yosef yi Egipte la, wodzrae abe kluvi ene na Potifar, ame si nye Egipte fia, Farao ŋumewo dometɔ ɖeka. Eganye Farao ŋu dzɔlawo ƒe amegã kple aƒedzikpɔlawo ƒe amega hã. ");
INSERT INTO ewe_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yehowa yra Yosef le eƒe aƒetɔ si nye Egiptetɔ la ƒe aƒe me ale gbegbe be nu sia nu si wòwɔna la dzea edzi. ");
INSERT INTO ewe_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potifar de dzesii be Yehowa li kple Yosef le mɔ tɔxɛ aɖe nu, ");
INSERT INTO ewe_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","eya ta Potifar lɔ̃ Yosef. Etsɔe ɖo eƒe aƒemenuwo kple eƒe dɔwɔnawo dzi kpɔkpɔ nu. ");
INSERT INTO ewe_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Enumake Yehowa de asi Potifar yayra me ɖe Yosef ta. Eƒe aƒemenyawo katã tsɔ afɔ nyuie; eƒe agblemenukuwo ʋã nyuie, eye eƒe lãwo hã dzi ɖe edzi, ");
INSERT INTO ewe_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","eya ta Potifar tsɔ nu siwo katã nɔ esi la dzi kpɔkpɔ de esi. Zi ale si Yosef li ko la, megatsia dzi ɖe naneke ŋu o, negbe nu si wòadi be yeaɖu ko! Ke Yosef nye ɖekakpui dzeɖekɛ aɖe. ");
INSERT INTO ewe_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Le ɣeyiɣi siawo me la, Potifar srɔ̃ de asi ahiãmoɖoɖo na Yosef me, eye gbe ɖeka la, egblɔ na Yosef be wòadɔ kpli ye. ");
INSERT INTO ewe_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Yosef gbe hegblɔ nɛ be, “Kpɔ ɖa, nye aƒetɔ ka ɖe dzinye, eye wòtsɔm ɖo eƒe aƒemenuwo katã nu. ");
INSERT INTO ewe_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ŋusẽ megale esi wum le aƒe sia me o! Meɖe naneke le nye dzikpɔkpɔ te o, negbe wò ko, elabena srɔ̃e nènye. Aleke mate ŋu awɔ nu vɔ̃ɖi, ŋutasẽnu sia tɔgbi? Anye nu vɔ̃ gã aɖe mawɔ ɖe Mawu ŋu.” ");
INSERT INTO ewe_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ke Potifar srɔ̃ ganɔ nya la ƒom ɖe Yosef nu kokoko gbe sia gbe, gake Yosef do tokui, eye wòdea axa nɛ ale si wòate ŋui. ");
INSERT INTO ewe_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Gbe ɖeka esi Yosef nɔ eƒe aƒemedɔwo wɔm, eye ame bubu aɖeke menɔ afi ma lɔƒo o la, ");
INSERT INTO ewe_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potifar srɔ̃ va lé awu ɖe Yosef ŋu, eye wògblɔ nɛ be, “Dɔ gbɔnye!” Yosef ʋli le esi, ke le ʋiʋlia me la, eƒe dziwui tsi nyɔnu la si. Yosef si do le xɔa me. ");
INSERT INTO ewe_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Esi Potifar srɔ̃ kpɔ be eƒe awu tsi ye si, eye wòsi dzo la, ");
INSERT INTO ewe_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","eyɔ eƒe subɔlawo, eye wògblɔ na wo be, “Mikpɔ ɖa, wokplɔ Hebri ɖekakpui sia vɛ be wòado ŋukpe mí! Eva afi sia be yeadɔ kplim, ke medo ɣli. ");
INSERT INTO ewe_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Esi wòse medo ɣli be amewo nava xɔ nam la, egblẽ eƒe awu ɖe gbɔnye, eye wòsi do go le aƒea me.” ");
INSERT INTO ewe_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Etsɔ awu la dzra ɖo, eye esi srɔ̃a gbɔ fiẽ ma la, ");
INSERT INTO ewe_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","egblɔ nya blibo la nɛ be, “Hebri kluvi ma si nèkplɔ va afi sia la di be yeadɔ gbɔnye sesẽtɔe. ");
INSERT INTO ewe_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Nye ɣlidodo koe ɖem tso eƒe asi me. Esi dzo hegblẽ eƒe awu ɖe megbe!” ");
INSERT INTO ewe_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Esi Potifar se nya sia la, edo dɔmedzoe. ");
INSERT INTO ewe_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Elé Yosef de gaxɔ me, afi si wodea ga fia Farao ƒe gaxɔmenɔlawo ɖo. ");
INSERT INTO ewe_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ke Yehowa ganɔ kple Yosef le afi ma hã; eve enu, eye wòna gaxɔdzikpɔlawo ƒe amegã ƒe dɔ me trɔ ɖe eŋu. ");
INSERT INTO ewe_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Eteƒe medidi o la, gaxɔdzikpɔlawo ƒe amegã la tsɔ gaxɔa dzi kpɔkpɔ de asi na Yosef, eye gaxɔmenɔla bubuawo katã nɔ ete. ");
INSERT INTO ewe_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Gaxɔdzikpɔlawo ƒe amegã megatsia dzi ɖe naneke ŋuti o, elabena Yosef kpɔa nu sia nu dzi nyuie. Yehowa nɔ kplii, eye nu sia nu dze edzi nɛ nyuie. ");
INSERT INTO ewe_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Le ɣeyiɣi aɖe megbe la, Egipte fia ƒe ahakula kple aboloƒola da vo ɖe woƒe aƒetɔ ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Farao do dɔmedzoe ɖe dɔwɔla eve siawo, ahakulawo ƒe amegã kple aboloƒolawo ƒe amegã ŋu, ");
INSERT INTO ewe_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","eye wòlé wo ame eveawo de gaxɔ si me Yosef nɔ le Potifar, ame si nye fiaŋumewo ƒe amegã la ƒe mɔ me. ");
INSERT INTO ewe_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Wonɔ afi ma eteƒe didi, eye Potifar ɖoe na Yosef be wòakpɔ wo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Le zã aɖe me la, ame eve siawo dometɔ ɖe sia ɖe, fia ƒe ahakula kple abolomela ku drɔ̃e vovovowo. Drɔ̃e ɖe sia ɖe kple egɔmeɖeɖe. ");
INSERT INTO ewe_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Esi ŋu ke la, Yosef kpɔ be wolé blanui. ");
INSERT INTO ewe_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Yosef bia wo be, “Nu ka tututue le mia wɔm?” ");
INSERT INTO ewe_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Woɖo eŋu be, “Mí ame evea míeku drɔ̃e le zã si va yi la me, ke ame aɖeke mele afi sia aɖe drɔ̃eawo gɔme na mí o.” Yosef gblɔ na wo be, “Mawue ɖea drɔ̃e gɔme; ke milĩ drɔ̃eawo nam kpɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Ale ahakulawo ƒe amegã la lĩ eƒe drɔ̃e la na Yosef. Egblɔ nɛ be, “Mekpɔ wainka aɖe le ŋgɔnye le nye drɔ̃e la me, ");
INSERT INTO ewe_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","eye alɔ etɔ̃ nɔ wainka la ŋu. Esi wode asi dzedze kple seƒoƒo me ko la, woƒe tsetsewo de asi ɖiɖi me. ");
INSERT INTO ewe_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Melé Farao ƒe ahakplu ɖe asi, ale megbe waintsetseawo, eye mefia wo ɖe kplu la me hetsɔ na fia la be wòano.” ");
INSERT INTO ewe_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yosef gblɔ nɛ be, “Mese wo drɔ̃e la gɔme. Alɔdze etɔ̃awo fia ŋkeke etɔ̃! ");
INSERT INTO ewe_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Le ŋkeke etɔ̃ megbe la, Farao aɖe wò tso gaxɔ me, eye wòana nàgayi wò dɔ dzi abe ahakula ene. ");
INSERT INTO ewe_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ne ègatrɔ yi wò dɔ me, eye mi kple Farao dome gava nyo la, meɖe kuku na wò be nàve nunye, aɖo ŋku dzinye na Farao be wòaɖem le gaxɔ me, ");
INSERT INTO ewe_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","elabena woƒlem dzoe tso nye amewo, Hebritɔwo dome; kpe ɖe esia ŋu la, meva le gaxɔ me le afi sia le esime nyemewɔ naneke si dze na gaxɔmenɔnɔ o.” ");
INSERT INTO ewe_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Esi aboloƒolawo ƒe amegã kpɔ be nya nyui le drɔ̃e gbãtɔ ƒe gɔmeɖeɖe me la, eya hã lĩ eƒe drɔ̃e la na Yosef hegblɔ be, “Le nye drɔ̃ekuku me la, melé abolokusi etɔ̃ ɖe ta; ");
INSERT INTO ewe_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","abolo ƒomevi vovovowo le kusi edzitɔ me na Farao, ke xeviwo va ɖu wo keŋkeŋ.” ");
INSERT INTO ewe_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosef gblɔ nɛ be, “Drɔ̃e la gɔmee nye be kusi etɔ̃awo fia ŋkeke etɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Le ŋkeke etɔ̃ megbe la, Farao atso ta le nuwò, ahe wò ɖe ati ŋu, eye xeviwo aɖu wò lã.” ");
INSERT INTO ewe_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Le ŋkeke etɔ̃ megbe la, Farao ɖu eƒe dzigbezã, eye wòɖo kplɔ gã aɖe na eŋumewo kple eƒe aƒemetɔwo. Ena wokplɔ ahakula la kple aboloƒolawo ƒe amegã la tso gaxɔ me vɛ. ");
INSERT INTO ewe_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tete wògatsɔ ahakulawo ƒe amegã ƒe dɔ nɛ; ");
INSERT INTO ewe_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","ke etso kufia na aboloƒolawo ƒe amegã ya be woatɔ eƒe ŋutilã ɖe ati nu abe ale si Yosef gblɔe do ŋgɔ tututu ene. ");
INSERT INTO ewe_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ke Farao ƒe ahakulawo ƒe amegã la ŋlɔ Yosef be enumake, eye megabua eŋu kura o. ");
INSERT INTO ewe_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Le ƒe eve megbe la, Farao ku drɔ̃e gbe ɖeka le zã me be yetsi tsitre ɖe Nil tɔsisi la to. ");
INSERT INTO ewe_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Tete nyi dami adre do tso tɔsisi la me, eye wonɔ gbe ɖum. ");
INSERT INTO ewe_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Emegbe nyi bubu adre do tso tɔsisi la me, ke woawo ɖi ku glãŋuiglãŋui, eye woƒe axaƒutiwo do. Woyi ɖatsi tsitre ɖe nyinɔ dami adreawo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nyi ɖikuawo lé nyinɔ damiawo mi! Tete Farao nyɔ! ");
INSERT INTO ewe_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Egayi alɔ̃ me kaba, eye wògaku drɔ̃e bubu. Azɔ ya la, ekpɔ bli adre siwo ʋã nyuie la le bliti ɖeka dzi. ");
INSERT INTO ewe_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Enumake bli bubu adre gado ɖe bliti la dzi, ke esiawo ya meʋã kura o, eye ɣedzeƒeya na woyrɔ. ");
INSERT INTO ewe_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Bli yɔyrɔe siawo mi bli ʋaʋãwo! Farao ganyɔ, eye wòdze sii be drɔ̃e sɔŋ ko wonye. ");
INSERT INTO ewe_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Esi ŋu ke, eye wòbu drɔ̃eawo ŋu la, etsi dzimaɖi ŋutɔ le nu si drɔ̃eawo ate ŋu aɖe afia la ŋu. Eyɔ afakalawo kple nunyalawo katã le Egiptenyigba dzi ƒo ƒu, eye wòlĩ drɔ̃eawo na wo, ke wo dometɔ aɖeke mete ŋu ɖe wo gɔme o. ");
INSERT INTO ewe_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tete fia ƒe ahakula gblɔ na Farao be, “Egbe la, meɖo ŋku nye nu vɔ̃ dzi. ");
INSERT INTO ewe_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Ɣe aɖe ɣi va yi esi nèdo dɔmedzoe ɖe mí ame eve ŋu, eye nède nye kple aboloƒola gaxɔ me le ŋuwòdzɔlawo ƒe amegã ƒe mɔ me la, ");
INSERT INTO ewe_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","nye kple aboloƒola míeku drɔ̃e gbe ɖeka le zã me. ");
INSERT INTO ewe_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Míelĩ drɔ̃eawo na Hebri ɖekakpui aɖe, ame si nye ŋuwòdzɔlawo ƒe amegã la ƒe kluvi le gaxɔa me, eye wòɖe drɔ̃eawo gɔme na mí. ");
INSERT INTO ewe_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","“Eye nu sia nu va eme tututu abe ale si wògblɔe ene; nye ahakudɔ gaka asinye, wotso ta le aboloƒola nu, eye wotɔ eƒe ŋutilã ɖe ati nu.” ");
INSERT INTO ewe_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Farao ɖo du ɖe Yosef enumake. Woɖee le gaxɔa me kaba; eko ta, di awu bubuwo do alɔtsɔtsɔe, eye wòdo ɖe Farao ŋkume. ");
INSERT INTO ewe_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Farao gblɔ na Yosef be, “Meku drɔ̃e aɖe le zã si va yi la me, gake ame siawo dometɔ aɖeke mete ŋu ɖe egɔme nam o. Ke mese be ètea ŋu ɖea drɔ̃ewo gɔme, eya ta mena woyɔ wò nam.” ");
INSERT INTO ewe_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yosef gblɔ na Farao be, “Nyemate ŋu aɖe drɔ̃e la gɔme le ɖokuinye si o, ke Mawu ya ate ŋu aɖe drɔ̃ea gɔme na wò!” ");
INSERT INTO ewe_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ale Farao lĩ drɔ̃e la nɛ be, “Metsi tsitre ɖe Nil tɔsisi la to; ");
INSERT INTO ewe_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","tete nyi dami siwo ƒe lãme nyo nyuie la do tso tɔsisi la me, eye wode asi gbeɖuɖu me le tɔsisi la to. ");
INSERT INTO ewe_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ke nyi bubu adre do tso tɔsisi la me. Woawo ɖi ku glãŋuiglãŋui; nyemekpɔ nyinɔ ɖiku mawo tɔgbi kpɔ le Egiptenyigba dzi o. ");
INSERT INTO ewe_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nyi ɖiku siawo lé nyinɔ dami siwo do tso tɔsisi la me gbã la mi, ");
INSERT INTO ewe_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","eye emegbe la, wogaɖi ku glãŋuiglãŋui abe ale si tututu wonɔ tsã la ene, eye menyɔ! ");
INSERT INTO ewe_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Eteƒe medidi kura hafi megaku drɔ̃e bubu o. Azɔ ya la, bli adre nɔ bliti ɖeka dzi; bliawo katã ʋã nyuie. ");
INSERT INTO ewe_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Bli adre bubuwo gado ɖe bliti ma ke dzi, ke woawo meʋã o, ke boŋ woyrɔ. ");
INSERT INTO ewe_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Bli yɔyrɔawo mi bli ʋaʋãwo. “Megblɔ esiawo katã na nye afakalawo, ke wo dometɔ aɖeke mete ŋu ɖe wo gɔme nam o.” ");
INSERT INTO ewe_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosef gblɔ na Farao be, “Gɔmeɖeɖe ɖeka koe le drɔ̃e eveawo si. Mawu nɔ nu si wòava wɔ le Egiptenyigba dzi la gblɔm na wò. ");
INSERT INTO ewe_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nyi dami adreawo kple bli ʋaʋã adreawo fia be le ƒe adre siwo gbɔna me la, nuɖuɖu abɔ ɖe anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nyi ɖiku adreawo kple bli maʋamaʋã yɔyrɔ adreawo fia be ƒe adre ƒe dɔwuame adze ƒe adre siwo me nuɖuɖu abɔ la yome. ");
INSERT INTO ewe_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Ale Mawu ɖe nu si wɔ ge wòala la fia wò. ");
INSERT INTO ewe_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nuɖuɖu abɔ ɖe Egiptenyigba blibo la dzi le ƒe adre gbãtɔ siwo gbɔna la me. ");
INSERT INTO ewe_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ke le ƒe mawo yome la, dɔwuame ava ƒe adre, eye enu asesẽ ale gbegbe be nuɖuɖu si bɔ tsã la avɔ, woaŋlɔ woƒe bɔbɔ kpɔ be le Egipte, eye dɔwuame agblẽ anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","“Dɔwuame la nu asesẽ ale gbegbe be ame aɖeke magaɖo ŋku edzi be nuɖuɖu bɔ kpɔ o. ");
INSERT INTO ewe_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Drɔ̃e eve siawo le nu eve fiam Farao; wofia be nya siwo megblɔ na mi la le eme va ge kokoko, elabena Mawu ɖo wo da ɖi, eye woava eme kaba. ");
INSERT INTO ewe_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Susu si mado ɖa lae nye be Farao nadi nunyala gãtɔ kekeake le Egipte, eye nàtsɔe aɖo agbledede ƒe ɖoɖowo nu le anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Mina Farao natia dɔdzikpɔla ɖe anyigba la dzi be woaxɔ Egipte ƒe nuŋeŋe ƒe atɔ̃lia ɖeka le ƒe adreawo me. ");
INSERT INTO ewe_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Woaƒo nuɖuɖuawo nu ƒu le ƒe nyui siwo gbɔna la me, eye woadzra wo ɖo ɖe avawo me le duwo me na Farao, ");
INSERT INTO ewe_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ale be nuɖuɖu nasɔ gbɔ ate ŋu akplɔ mí to ƒe adre siwo dɔwuame anɔ anyi le Egipte la me. Ne menye nenema o la, tsɔtsrɔ̃ ava anyigba la dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Farao kple eƒe kpeɖeŋutɔwo xɔ Yosef ƒe nyawo. ");
INSERT INTO ewe_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Esi wode ŋugble tso ame si woahiã na dɔ sia ŋu la, Farao gblɔ be, “Ame kae ate ŋu awɔ dɔ vevi sia nyuie wu Yosef? Elabena enye ame si yɔ fũu kple Mawu ƒe Gbɔgbɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Farao trɔ ɖe Yosef gbɔ gblɔ nɛ be, “Zi ale si Mawu ɖe drɔ̃eawo gɔme fia wò ko la, wòe nye nunyala gãtɔ le dukɔa me, ");
INSERT INTO ewe_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","eya ta metsɔ wò ɖo dɔ blibo la nu. Nya sia nya si nàgblɔ la, woawɔ edzi le Egiptenyigba blibo la dzi. Nye ɖeka koe aganye amegã na wò.” ");
INSERT INTO ewe_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ale Farao gblɔ na Yosef be, “Meto esia me tsɔ wò ɖo Egiptenyigba blibo la nu.” ");
INSERT INTO ewe_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Tete Farao ɖe eƒe ŋkɔsigɛ le asi hetsɔ de na Yosef; edo aklala biɖibiɖi ƒe awu nɛ, eye wòde sikakɔsɔkɔsɔ kɔ nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Emegbe la, Farao tsɔ tasiaɖam si kplɔ fia tɔ ɖo la na Yosef, eye afi sia afi si wòyi ko la, ɣli ɖina be, “Midze klo!” ");
INSERT INTO ewe_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Farao gblɔ na Yosef be, “Nye, Egipte fia, meka atam na wò be, ànɔ Egiptenyigba blibo la nu le go sia go me.” ");
INSERT INTO ewe_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Farao tsɔ ŋkɔ yeye na Yosef be Zafenat Paneah. Ŋkɔ sia gɔmee nye “Amewo ƒe agbeɖela, Mawu ƒe ŋusẽ tɔgbi ɖe ku kple agbe dzi.” Farao tsɔ nyɔnuvi aɖe si ŋkɔe nye Asenat, eye wònye Potifera, ame si nye On nunɔla la, ƒe vinyɔnu na Yosef wòɖe. Ale Yosef zu ame xɔŋkɔ aɖe le Egiptenyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Exɔ ƒe blaetɔ̃ esi wòge ɖe Farao, Egipte fia ƒe dɔ me. Yosef dzo le Farao gbɔ, eye wòde asi tsatsa me le anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Vavã, le ƒe adre gbãtɔwo me la, nukuwo wɔ nyuie ŋutɔ le afi sia afi. ");
INSERT INTO ewe_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Le ƒe mawo me la, Yosef de se be woatsɔ nuku ɖe sia ɖe si woaxa le Egipte la ƒe akpa aɖe ana dziɖuɖu, eye woadzra wo ɖo ɖe avawo me le du gãwo me. ");
INSERT INTO ewe_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Le ƒe adrea ƒe nuwuwu la, avawo yɔ, eye nuɖuɖu si wodzɔ na dziɖuɖu la sɔ gbɔ ale gbegbe be ame aɖeke meganya akɔnta le eŋu o. ");
INSERT INTO ewe_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Le ɣeyiɣi sia me, hafi dɔwuame ƒe ƒe gbãtɔ naɖo la, Asenat, Potifera si nye On nunɔla ƒe vinyɔnu la dzi vi eve na Yosef. ");
INSERT INTO ewe_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ena ŋkɔ gbãtɔ be Manase si gɔmee nye “Meŋlɔ be.” Nu si Yosef di be yeafia lae nye be Mawu ve ye nu ale gbegbe be yeŋlɔ yeƒe ɖekakpuimefuwo kple yeƒe dzodzo le yewo de be. ");
INSERT INTO ewe_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ena ŋkɔ Via ŋutsu evelia be Efraim si gɔmee nye “Kutsetse,” elabena egblɔ be, “Mawu na metse ku le teƒe sia, afi si menye kluvi le.” ");
INSERT INTO ewe_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ale ƒe adre siwo me nuɖuɖu bɔ le Egipte la wu enu, ");
INSERT INTO ewe_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","eye dɔwuame ƒe ƒe adreawo dze egɔme abe ale si Yosef gblɔe da ɖi ene. Nukuwo gblẽ le dukɔ siwo ƒo xlã wo la me, ke nuɖuɖu bɔ ɖe avawo me le Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Dɔ de asi Egipte dukɔ la wuwu me. Woɖe kuku na Farao be wòana nuɖuɖu yewo. Eɖo wo ɖe Yosef gbɔ kple nya siawo be, “Miwɔ nu sia nu si wòagblɔ na mi be miawɔ la.” ");
INSERT INTO ewe_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Esi dɔwuame kaka ɖe anyigba blibo la dzi la, Yosef ʋu avawo, eye wòdzra nuɖuɖu na Egiptetɔwo, elabena dɔwuame la nu sesẽ le anyigba la katã dzi. ");
INSERT INTO ewe_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Eye amewo tso dukɔwo katã me va Egipte be yewoaƒle bli le Yosef gbɔ, elabena dɔwuame la nu sesẽ le xexea me katã. ");
INSERT INTO ewe_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Esi Yakob se be bli nɔ Egipte la, egblɔ na viawo be, “Nu ka ta miele afi sia le mia nɔewo kpɔm ɖo? ");
INSERT INTO ewe_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Mese be bli le Egipte. Miyi afi ma miaƒle bli vɛ hafi dɔ nawu mí míaku.” ");
INSERT INTO ewe_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ale Yosef nɔviŋutsu ewo yi Egipte be yewoaƒle bli. ");
INSERT INTO ewe_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ke Yakob mena Yosef nɔvi suetɔ Benyamin yi kpli wo o, elabena evɔ̃ be nya aɖe ava adzɔ ɖe edzi abe ale si wòdzɔ ɖe Yosef dzi ene. ");
INSERT INTO ewe_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ale Israel ƒe viwo kple ame bubuwo tso anyigba geɖewo dzi va ɖo Egipte be yewoaƒle bli, elabena dɔwuame la nu sesẽ le Kanaan abe teƒe ɖe sia ɖe ene. ");
INSERT INTO ewe_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Esi wònye Yosef tututue nye dziɖula le Egipte katã, eye wònye eyae le blia dzi kpɔm ta la, eya gbɔe nɔviawo yi, eye wodze klo, de ta agu nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosef dze si wo enumake, gake ewɔ abe ɖe menya wo kura o ene. Eblu ɖe wo ta kple biabia sia be, “Afi ka mietso?” Woɖo eŋu be, “Míetso Kanaanyigba dzi; míeva bli ƒle ge.” ");
INSERT INTO ewe_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Togbɔ be Yosef kpɔ nɔviawo dze sii hã la, woawo ya mekpɔe dze sii o. ");
INSERT INTO ewe_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tete wòɖo ŋku eƒe drɔ̃e siwo wòku tso wo ŋu la dzi, eye wògblɔ na wo be, “Ŋkutsalawoe mienye! Ɖe mieva be yewoakpɔ afi si toƒe le le anyigba la ŋu.” ");
INSERT INTO ewe_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Wogblɔ be, “Kpao! Amegã, nuɖuɖu ƒle ge ko míeva; ");
INSERT INTO ewe_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","nɔviwo mí katã míenye. Nuteƒewɔlawo míenye. Menye ŋkutsalawoe míenye o!” ");
INSERT INTO ewe_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Etee ɖe wo dzi be, “Ɛ̃, ŋkutsalawoe mienye. Mieva be yewoakpɔ ale si nu te mía ŋui la ɖa.” ");
INSERT INTO ewe_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Woɖe wo ɖokuiwo nu be, “Amegã, míele nɔviŋutsu wuieve; mía fofo le Kanaan. Mía nɔviŋutsu suetɔ le afi ma le mía fofo gbɔ, eye mía nɔviŋutsu ɖeka ku.” ");
INSERT INTO ewe_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosef yi edzi be, “Nenema? Nu ka esia fia? Efia be ŋkutsalawoe mienye. ");
INSERT INTO ewe_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Mɔ si dzi mato ado miaƒe nya la ƒe nyateƒenyenye kpɔe nye esi: meta Farao ƒe agbe na mi be miadzo le Egipte akpɔ o va se ɖe esime mia nɔvi suetɔ nava afi sia. ");
INSERT INTO ewe_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Mia dometɔ ɖeka neyi wòakplɔ mia nɔvia vɛ! Made mi ame mamlɛawo gaxɔ me. Ekema míanya ne miaƒe nya la nye nyateƒe alo aʋatso. Ne eva eme be nɔviŋutsu suetɔ aɖeke mele mia si o la, ekema manya be ŋkutsalawoe mienye.” ");
INSERT INTO ewe_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ale wode wo gaxɔ me ŋkeke etɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Le ŋkeke etɔ̃a gbe la, Yosef gblɔ na wo be, “Mawuvɔ̃lae menye. Mana mɔnukpɔkpɔ mi be miana nyateƒe la nadze. ");
INSERT INTO ewe_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Metsɔe be mienye nuteƒewɔlawo; mia dometɔ ɖeka koe atsi gaxɔ me le afi sia; ame bubuawo atsɔ bli ayi mia de na miaƒe ƒometɔwo. ");
INSERT INTO ewe_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Ke ele be miakplɔ mia nɔvi suetɔ vɛ nam be manya nenye nyateƒe tom miele, eye makpɔ nublanui na mi.” Wolɔ̃ ɖe ɖoɖo sia dzi. ");
INSERT INTO ewe_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Wogblɔ na wo nɔewo be, “Vavãe wole to hem na mí ɖe nu si míewɔ ɖe mía nɔvia ŋuti la ta. Míekpɔ ale si wòxaxae esi wònɔ kuku ɖem na mí ɖe eƒe agbe ta, gake míedo tokui, eya tae xaxa sia va mía dzi ɖo.” ");
INSERT INTO ewe_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruben gblɔ be, “Nyemegblɔe na mi be migawɔe oa? Miegbe toɖoɖom. Azɔ la, míele kuku ge, elabena míewui.” ");
INSERT INTO ewe_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Womenya be Yosef se nya siwo gblɔm yewole le esime wòtsi tsitre ɖe wo gbɔ la gɔme o, elabena eƒoa nu na wo to nyagɔmeɖela aɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Edzo le wo gbɔ yi teƒe aɖe, afi si wòate ŋu afa avi le. Esi wòtrɔ gbɔ la, etɔ asi Simeon dzi, eye wòna woblae le eŋkume. ");
INSERT INTO ewe_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Emegbe la, Yosef ɖe gbe na eƒe subɔlawo be woade bli ameawo ƒe kotokuwo me, ke egagblɔ na wo le adzame be woatsɔ fe si wo dometɔ ɖe sia ɖe xe la ade eƒe nuɖuɖu dzi le kotokua me! Etsɔ nu si woaɖu le mɔa dzi la hã na wo. ");
INSERT INTO ewe_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Ale wodo agba na woƒe tedziwo, eye wodze aƒemɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ke esi wotɔ ɖe afi aɖe, eye wo dometɔ ɖeka ʋu eƒe kotoku be yeaɖe blia ƒe ɖe na tedziawo la, ekpɔ eƒe ga le eƒe kotokua me! ");
INSERT INTO ewe_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Edo ɣli gblɔ na nɔviawo be, “Mikpɔ nam ɖa! Nye gae nye esi le kotokua me!” Vɔvɔ̃ ɖo wo. Wode asi dzodzo me nyanyanya, eye wogblɔ na wo nɔewo be, “Nu kae nye esi Mawu wɔ na mí?” ");
INSERT INTO ewe_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ale wova ɖo wo fofo, Yakob gbɔ le Kanaan, eye wogblɔ nu siwo katã dzɔ la nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Wogblɔ nɛ be, “Fia la ƒe kpeɖeŋutɔ blu ɖe mía ta, eye wòtsɔ mí abe ŋkutsalawo ene. ");
INSERT INTO ewe_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Míegblɔ nɛ be, ‘Gbeɖe, nuteƒewɔlawo míenye, menye ŋkutsalawo míenye o. ");
INSERT INTO ewe_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Míegagblɔ nɛ hã be nɔviŋutsu wuievee míenye, fofo ɖeka ƒe viwo; ɖeka ku, eye suetɔ le mía fofo gbɔ le Kanaanyigba dzi.’ ");
INSERT INTO ewe_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Ŋutsu la gblɔ na mi be, ‘Mɔ si dzi mato anya ne mienye nu si miebe yewonye le nyateƒe me lae nye esi: Migblẽ mia nɔvi ɖeka ɖe gbɔnye le afi sia, eye miatsɔ bli ayi aƒee na miaƒe ƒometɔwo, ");
INSERT INTO ewe_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","gake mikplɔ mia nɔvi suetɔ vɛ nam. Ekema manya nenye ŋkutsalawo mienye loo alo nuteƒewɔlawo mienye. Ne miete ŋu ɖe nu si miebe yewonye fia la, ekema maɖe asi le mia nɔvia ŋu na mi, eye miate ŋu ava aƒle bli le afi sia ɣe sia ɣi si mielɔ̃ la.’ ” ");
INSERT INTO ewe_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Esi wotrɔ bli la le kotokuawo me la, wokpɔ ga si woxe ɖe blia ta le kotokuawo me! Vɔvɔ̃ ɖo wo kple wo fofo siaa. ");
INSERT INTO ewe_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tete Yakob do ɣli be, “Miena vinyewo le bubum ɖem. Yosef metrɔ gbɔ o; Simeon hã yi, eye azɔ miedi be yewoakplɔ Benyamin hã ayii! Nu sia nu tsi tsitre ɖe ŋunye!” ");
INSERT INTO ewe_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruben gblɔ na fofoa be, “Ne nyemekplɔ Benyamin gbɔe o la, ekema, wu vinye ŋutsuvi eveawo. Makpɔ Benyamin dzi wòanɔ dedie.” ");
INSERT INTO ewe_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ke Yakob ɖo eŋu be, “Vinye Benyamin mayi kpli mi o, elabena nɔvia Yosef ku, eye Benyamin koe nye dadaa ƒe vi si susɔ. Ne nane wɔe la, ku ko maku.” ");
INSERT INTO ewe_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Ke dɔwuame sesẽ la nu mebɔbɔ kura le anyigba la dzi o. ");
INSERT INTO ewe_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Esi bli si wotsɔ tso Egipte nɔ vɔvɔm la, wo fofo gblɔ na wo be, “Migayi ne miaƒle nuɖuɖu sue aɖe vɛ na mí.” ");
INSERT INTO ewe_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ke Yuda gblɔ nɛ be, “Ŋutsu la te gbe ɖe edzi na mí be, ‘Miagakpɔ nye ŋkume o, negbe ɖeko mia nɔvi la anɔ mia ŋu hafi! ");
INSERT INTO ewe_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ne míakplɔ mía nɔvi ayii la, ekema míayi aɖaƒle nuɖuɖu vɛ na wò. ");
INSERT INTO ewe_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Míate ŋu ayi o, negbe ɖeko nàna Benyamin nayi kpli mí hafi.’ ” ");
INSERT INTO ewe_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israel fa konyi be, “Nu kae dɔ mi ɖa be miagblɔ nɛ be nɔviŋutsu bubu gale yewo si? Nu ka ta miawɔm alea ɖo?” ");
INSERT INTO ewe_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Wogblɔ nɛ be, “Ŋutsu la bia nya mí tsitotsito tso míaƒe ƒome ŋu. Edi be yeanya ne mía fofo le agbe, eye wòbia be nɔvi bubu gale mía si mahã? Nu sia tae míegblɔe nɛ ɖo. Aleke míate ŋu anya be agblɔ be, ‘Mikplɔ mia nɔvi suetɔ vɛ nam’?” ");
INSERT INTO ewe_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yuda gblɔ na fofoa Israel be, “Ɖe asi le ɖevi la ŋu nam ne míadze mɔ; ne menye nenema o la, dɔ awu mí katã míaku, menye míawo ɖeɖe koe aku o: wò ŋutɔ hã kple mía vi suewo siaa aku. ");
INSERT INTO ewe_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Makpɔ eƒe dedinɔnɔ gbɔ. Ne nyemekplɔe gbɔe na wò o la, ekema na fɔɖiɖi la nanɔ dzinye tegbee. ");
INSERT INTO ewe_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nenye ɖe nèɖe asi le eŋu nam la, anye ne míede gbɔ xoxo.” ");
INSERT INTO ewe_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ale wo fofo, Israel gblɔ na wo mlɔeba be, “Ne wòanɔ nenema kokoko la, ekema nu suetɔ si miawɔ la koe nye be miado agba na miaƒe tedziwo kple nu nyuitɔ siwo le míaƒe anyigba dzi la: lifi, anyitsi, ami ʋeʋĩ, kotoklobo, ayedee kple newo, eye miatsɔ wo ayi ɖana ŋutsu la. ");
INSERT INTO ewe_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Mitsɔ ga teƒe eve ɖe asi, ale be miate ŋu axe ga si wogbugbɔ de miaƒe kotokuwo me la, elabena ɖewohĩ ame aɖe ƒe vodadae, ");
INSERT INTO ewe_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","eye miakplɔ mia nɔvia ayii! ");
INSERT INTO ewe_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Mawu Ŋusẽkatãtɔ la nave mia nu le ŋutsu la ŋkume, ale be wòaɖe asi le Simeon ŋu, eye wòana Benyamin natrɔ gbɔ. Ne ava eme kokoko be wòaku, eye maxa nu hã la, ekema nenɔ nenema ko faa.” ");
INSERT INTO ewe_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ale wotsɔ nunanawo kple ga home teƒe eve kpe ɖe Benyamin ŋu yi Egipte, eye wodo ɖe Yosef ŋkume. ");
INSERT INTO ewe_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Esi Yosef kpɔ be wokplɔ Benyamin vɛ la, egblɔ na eƒe aƒedzikpɔla be, “Ame siawo aɖu nu kplim ŋdɔ sia; kplɔ wo yi aƒe me, eye nàdzra ɖo ɖe kplɔ̃ gã aɖe ɖoɖo ŋu.” ");
INSERT INTO ewe_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ale aƒedzikpɔla la wɔ nu si wogblɔ nɛ la, eye wòkplɔ wo yi Yosef ƒe fiasã me. ");
INSERT INTO ewe_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Esi wokpɔ teƒe si wokplɔ wo yinae la, vɔvɔ̃ ɖo wo ŋutɔ. Wogblɔ be, “Ga si wogbugbɔ de míaƒe kotokuawo me la tae. Edi be wòadze abe ɖe míefi ga la ene, ale be yeawɔ mí kluviwo, eye yeaxɔ míaƒe tedziwo.” ");
INSERT INTO ewe_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Esi woɖo fiasã la ƒe agbo nu la, wote ɖe Yosef ƒe aƒedzikpɔla ŋu, ");
INSERT INTO ewe_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","eye wogblɔ nɛ be, “Amegã, esi míeva Egipte va ƒle nuɖuɖu zi gbãtɔ, ");
INSERT INTO ewe_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","eye esi míetrɔ yina aƒe la, míetsi afi aɖe dɔ, eye míeʋu míaƒe kotokuwo nu. Kasia míekpɔ be ga si míexe ɖe blia ta la le míaƒe kotokuawo me. Ga lae nye esi míetrɔ vɛ, ");
INSERT INTO ewe_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","kpe ɖe ga si míatsɔ aƒle bli fifia la ŋu. Ale si tututu ga la wɔ hafi ge ɖe míaƒe kotokuwo me la, míenya o.” ");
INSERT INTO ewe_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Aƒedzikpɔla la gblɔ na wo be, “Migatsi dzi ɖe eŋu o; miaƒe Mawu, ɛ̃, mia fofowo ƒe Mawu ŋutɔe anya tsɔ ga la de miaƒe kotokuawo me, elabena míawo míexɔ ga la le mia si pɛpɛpɛ.” Eɖe Simeon le gaxɔ me, eye wòkplɔe va nɔviawo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Azɔ wokplɔ wo yi Yosef gbɔ le fiasã la me. Wona tsi wo be woaklɔ afɔ, eye wona nuɖuɖu woƒe tedziwo. ");
INSERT INTO ewe_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nɔviawo nɔ klalo be yewoatsɔ nunanawo ana Yosef ne eva le ŋdɔ me, elabena wogblɔ na wo be wole nu ɖu ge le afi ma. ");
INSERT INTO ewe_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Esi Yosef va la, wotsɔ nunanawo nɛ, eye wode ta agu nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ebia woƒe agbe ta, eye wòbia wo be, “Aleke mia fofo, amegãɖeɖi si ƒe nya miegblɔ nam la le? Egale agbea?” ");
INSERT INTO ewe_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Woɖo eŋu be, “Ɛ̃, ele agbe, eye eli nyuie hã.” Wogade ta agu nɛ abe tsã ene. ");
INSERT INTO ewe_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ekpɔ dadavia, Benyamin dũu, eye wòbia be, “Mia nɔvi suetɔ si ƒe nya miegblɔ nam lae nye esia?” Egblɔ na Benyamin be, “Vinye, èfɔa? Mawu nave nuwò.” ");
INSERT INTO ewe_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Tete Yosef tso kpla, eye wòdo go le xɔa me, elabena eƒe lɔlɔ̃ na dadavia, Benyamin ʋuʋu eƒe dzi ale gbegbe be wònɔ nɛ be wòado go aɖafa avi. Eyi eƒe xɔ gã me, eye wòfa avi hehehe. ");
INSERT INTO ewe_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Le esia megbe la, efu mo, eye wòdo go. Eɖu eɖokui dzi hegblɔ be, “Mina míaɖu nu.” ");
INSERT INTO ewe_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Yosef ɖeka nɔ kplɔ̃ ŋu, nɔviawo nɔ kplɔ̃ bubu ŋu, eye Egiptetɔwo hã nɔ kplɔ bubu sãa ŋu, elabena Egiptetɔwo doa vlo Hebritɔwo, eye womeɖua nu kpli wo o. ");
INSERT INTO ewe_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yosef fia teƒe si nɔviawo anɔ le woƒe kplɔ̃ ŋu la wo, eye wòɖo wo ɖe tsitsi nu, tso tsitsitɔ dzi va se ɖe ɖevitɔ dzi. Nu sia wɔ nuku na wo ŋutɔ! ");
INSERT INTO ewe_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ena woka nuɖuɖu na wo tso eya ŋutɔ ƒe kplɔ̃ dzi. Ena wona nuɖuɖu Benyamin wòsɔ gbɔ zi atɔ̃ wu ame bubuawo tɔ. Emegbe la, wona aha wo wono. Dzi dzɔ wo ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Esi nɔviawo ƒe dzodzoɣi ɖo la, Yosef gblɔ na eƒe aƒedzikpɔla la be wòade bli woƒe kotokuwo katã me, ɖe sia ɖe nayɔ abe ale si wòate ŋu atsɔ ene, eye wòatsɔ ga si ame sia ame xe ɖe blia ta la ade eƒe kotoku me! ");
INSERT INTO ewe_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Egblɔ nɛ hã be wòatsɔ ye ŋutɔ yeƒe klosalokplu ade Benyamin ƒe kotoku me, kpe ɖe bliƒlega la ŋu. Ale aƒedzikpɔla la wɔ ɖe nu siwo Yosef gblɔ nɛ la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Nɔviawo fɔ fɔŋli, eye wodze mɔ kple woƒe tedziawo. ");
INSERT INTO ewe_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ke esi wodo go le dua me teti ko la, Yosef gblɔ na eƒe aƒedzikpɔla la be, “Dze wo yome kaba; na woatɔ, eye nàbia wo be nu ka ta wowɔ nu sia tɔgbi esime menyo dɔ me na wo nenema mahã? ");
INSERT INTO ewe_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bia wo be, ‘Nu ka ta miefi nye aƒetɔ ƒe klosalokplu si me wònoa nu le, eye wògawɔa eŋu dɔ hena nukaka mahã? Nu vɔ̃ɖi kae nye esi miewɔ?’ ” ");
INSERT INTO ewe_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Aƒedzikpɔla la yi ɖatu wo, eye wòƒo nu na wo abe ale si woɖo nɛ tututu ene. ");
INSERT INTO ewe_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Wobiae be, “Ao, aƒetɔ, nya ka tututu gblɔm nèle? Nu sia wɔwɔ nade megbe xaa tso wò dɔlawo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ɖe míetrɔ ga si míekpɔ le míaƒe blikotokuwo me le Kanaan la vɛ oa? Nu ka ta míafi klosalo alo sika le wò aƒetɔ ƒe aƒe me ɖo? ");
INSERT INTO ewe_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ne èkpɔ eƒe kplu le mía dometɔ aɖe ƒe kotoku me la, ekema na ame ma naku, eye nàna mí ame mamlɛawo katã miazu kluviwo na wò aƒetɔ tegbetegbe.” ");
INSERT INTO ewe_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Aƒedzikpɔla la gblɔ be, “Enyo nenema, gake ame si fii la koe azu kluvi, eye ame bubuawo ate ŋu adzo faa.” ");
INSERT INTO ewe_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Woɖe woƒe kotokuawo le woƒe tedziwo dzi kaba, eye woʋu wo nu. ");
INSERT INTO ewe_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Edze kplua didi le kotokuawo me gɔme tso nɔvi tsitsitɔ dzi nɔ yiyim ɖe tsitsi nu va se ɖe esime wòva ɖo ɖevitɔ dzi. Tete wòkpɔ kplu la le Benyamin ƒe kotoku me! ");
INSERT INTO ewe_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Wodze woƒe awuwo le dziɖeleameƒo ta. Wogado agba na woƒe tedziwo, eye wogatrɔ yi dua me. ");
INSERT INTO ewe_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yosef ganɔ eƒe aƒe me esime Yuda kple nɔviawo trɔ va ɖo, eye wodze klo de ta agu nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosef bia be, “Nu ka miete kpɔ be yewoawɔ? Ɖe mienya be ame abe nye ene anya ame si fii oa?” ");
INSERT INTO ewe_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yuda gblɔ be, “O, nu ka magblɔ na nye aƒetɔ? Kuku ka míate ŋu aɖe? Aleke míate ŋu aɖe míaƒe fɔmaɖimaɖi afiae? Mawu le to hem na mí ɖe míaƒe nu vɔ̃wo ta. Aƒetɔ, mí katã míetrɔ va be míazu wò kluviwo, míawo kple ame si ƒe kotoku me wokpɔ kplu la le siaa.” ");
INSERT INTO ewe_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yosef gblɔ be, “Ao, ame si fi kplu la koe anye nye kluvi. Mi ame mamlɛawo ya, miyi mia de le mia fofo gbɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tete Yuda te ɖe eŋu gblɔ be, “O, nye aƒetɔ, ɖe mɔ nam magblɔ nya ɖeka sia ko na wò. Gbɔ dzi ɖi nam vie, elabena menya be àte ŋu awɔ nu sia nu le aɖabaƒoƒo ɖeka me abe wòe nye Farao ene. ");
INSERT INTO ewe_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","“Aƒetɔ, èbia mí be mía fofo alo mía nɔvi aɖe li mahã, ");
INSERT INTO ewe_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","eye míegblɔ be, ‘Ɛ̃, mía fofo, amegãɖeɖi li, eye eƒe tsitsimevi, ŋutsuvi sue aɖe hã li. Dadavia ɖekɛ la ku; eya koe susɔ le dadaa ƒe viwo dome, eye fofoa lɔ̃e ŋutɔ.’ ");
INSERT INTO ewe_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ègblɔ na mí be, ‘Mikplɔe va afi sia be makpɔe ɖa.’ ");
INSERT INTO ewe_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ke megblɔ na wò be, ‘Aƒetɔ, ɖevi la mate ŋu adzo le fofoa gbɔ o, elabena eƒe dzodzo ana fofoa naku.’ ");
INSERT INTO ewe_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ke ègblɔ na mí be, ‘Ne mia nɔvi suetɔ manɔ mia dome o la, ekema migava afi sia azɔ o.’ ");
INSERT INTO ewe_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ale míetrɔ yi wò dɔla mía fofo gbɔ, eye míegblɔ nu si wò nye aƒetɔ gblɔ la nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Esi wògblɔ na mí be, ‘Migayi miaƒle nuɖuɖu vɛ’ la, ");
INSERT INTO ewe_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","míegblɔ be, ‘Míate ŋu ayi o, negbe ɖeko nàɖe mɔ na mí míakplɔ mía nɔvi suetɔ ɖe asi hafi. Eya ko hafi míate ŋu ayi.’ ");
INSERT INTO ewe_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Ale mía fofo gblɔ na mí be, ‘Mienya be viŋutsu evee dadaa dzi nam, ");
INSERT INTO ewe_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","eye ɖeka megatrɔ gbɔ o: lã aɖe anya lée kokoko; nyemegakpɔe kpɔ tso ɣe ma ɣi o. ");
INSERT INTO ewe_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ne miegakplɔ nɔvia hã dzoe le gbɔnye, eye nane wɔe la, maku kple nuxaxa.’ ");
INSERT INTO ewe_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ke azɔ la, aƒetɔ, ne matrɔ ayi fofonye gbɔ, nyemakplɔ ɖevi la ɖe asi o, esi menya be fofonye melɔ̃a nu le ɖevi la gbɔ o, ");
INSERT INTO ewe_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ne ekpɔ be ɖevi la megbɔ kpli mí o la, mía fofo aku, eye wòazu be míawoe na wòyi yɔ me kple nuxaxa. ");
INSERT INTO ewe_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Aƒetɔ, meɖe adzɔgbe na fofonye be makpɔ ɖevi la dzi nyuie. Megblɔ nɛ be, ‘Ne nyemekplɔ ɖevi la gbɔe o la, fɔɖiɖi sia nanɔ dzinye tegbee!’ ");
INSERT INTO ewe_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Meɖe kuku na wò, na matsi afi sia abe wò kluvi ene ɖe ɖevi la teƒe, eye nàna ɖevi la natrɔ kple nɔvia bubuawo. ");
INSERT INTO ewe_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Aleke mate ŋu atrɔ ayi fofonye gbɔ esime nyemakplɔ ɖevi la ɖe asi o? Nyemate ŋu akpɔ nu si nu sia awɔe la teƒe o.” ");
INSERT INTO ewe_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosef magate ŋu aɖu eɖokui dzi azɔ o. Eɖe gbe na eŋumewo katã be, “Ame sia ame nado go.” Ale eya kple nɔviawo koe susɔ. ");
INSERT INTO ewe_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Tete wòde asi avifafa me sesĩe. Egiptetɔwo se eƒe avifafa le fiasã la me, eye eƒe avifafa ƒe nya ɖo Fia Farao ƒe fiasã me enumake. ");
INSERT INTO ewe_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Egblɔ na nɔviawo be, “Nyee nye Yosef! Fofonye gale agbea?” Ke nɔviawo lulũ ale gbegbe be womete ŋu ke nu o. ");
INSERT INTO ewe_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Egblɔ na wo be, “Mite va gbɔnye.” Ale wote ɖe eŋu. Egagblɔ na wo be, “Nyee nye Yosef, mia nɔvi, ame si miedzra wokplɔ dzoe yi Egipte! ");
INSERT INTO ewe_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Gake migado dɔmedzoe ɖe mia ɖokuiwo ŋu be yewowɔ nu sia ɖe ŋunye o, elabena Mawue wɔe! Eɖom ɖe afi sia do ŋgɔ na mi, ale be mate ŋu aɖe miaƒe agbe. ");
INSERT INTO ewe_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ƒe eve koe nye esia dɔwuame la va, eye anɔ anyi wòade ƒe adre esime nuƒaƒã alo nuŋeŋe manɔ anyi o. ");
INSERT INTO ewe_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Mawu ɖom ɖe afi sia be mana miawo kple miaƒe ƒometɔwo miatsi agbe, ale be miate ŋu azu dukɔ gã aɖe. ");
INSERT INTO ewe_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Ɛ̃, Mawue ɖom ɖe afi sia, menye miawoe o. Ewɔm aɖaŋuɖolae na Farao, eye wòna mezu dzikpɔla na dukɔ la katã kple Egiptenyigba blibo la dzi ɖula. ");
INSERT INTO ewe_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Miɖe abla miayi fofonye gbɔ, eye miagblɔ nɛ be viwò Yosef be, ‘Mawu ɖom amegãe ɖe Egiptenyigba blibo la dzi. Va gbɔnye fifi laa! ");
INSERT INTO ewe_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ànɔ Gosen ƒe anyigba dzi, ale be wò kple viwòwo katã, wò tɔgbuiyɔviwo, wò lãwo kple nu siwo katã le asiwò la, miate ɖe ŋunye. ");
INSERT INTO ewe_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Makpɔ dziwò le afi ma, elabena ƒe atɔ̃ ƒe dɔwuame gale mía ŋgɔ. Ne menye nenema o la, wò kple wò aƒemetɔwo kple ame siwo katã nye tɔwòwo la, miazu dɔwuitɔwo.’ ");
INSERT INTO ewe_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Miawo ŋutɔ miate ŋu akpɔe, eye nenema ke nɔvinye Benyamin hã, be nye tututue nye ame si le nu ƒom na mi la. ");
INSERT INTO ewe_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","“Migblɔ ŋusẽ si le asinye le Egipte kple ale si ame sia ame ɖoa tom la na mía fofo, eye miakplɔe vɛ nam kaba.” ");
INSERT INTO ewe_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Tete wòde asi dzidzɔvifafa me. Ekpla asi kɔ na Benyamin, eye eya hã de asi avifafa me. ");
INSERT INTO ewe_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Egbugbɔ nu na nɔviawo dometɔ ɖe sia ɖe, eye wògafa dzidzɔvi. Azɔ ko hafi nɔviawo te ŋu ƒo nu. ");
INSERT INTO ewe_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Nya la ɖo Farao gbɔ be, “Yosef nɔviwo va.” Esi Farao kple eŋumewo se nya sia la, dzi dzɔ wo ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Farao gblɔ na Yosef be, “Gblɔ na nɔviwòwo be woado agba na woƒe tedziwo enumake, atrɔ ayi wo de le Kanaan kaba, ");
INSERT INTO ewe_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","eye woakplɔ mia fofo kple miaƒe ƒometɔwo katã ava Egipte, ale be woanɔ afi sia. Gblɔ na wo be, ‘Farao ana teƒe nyuitɔ kekeake wo le Egipte. Mianɔ agbe ɖe anyigba sia ƒe nu nyuiwo dzi!’ ");
INSERT INTO ewe_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Gblɔ na nɔviwòwo be woatsɔ tasiaɖamwo tso Egipte be woakɔ wo srɔ̃wo kple ɖeviwo, eye woakplɔ wo fofo va afi sia. ");
INSERT INTO ewe_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Migatsi dzi ɖe nu siwo le mia si la ŋu o, elabena Egipte ƒe anyigba nyuitɔ zu mia tɔ.” ");
INSERT INTO ewe_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Yosef tsɔ tasiaɖamwo na Israel ƒe viwo abe ale si Farao gblɔ ene, eye wòtsɔ nu si woaɖu le mɔzɔzɔ me la hã na wo. ");
INSERT INTO ewe_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Etsɔ awu yeyewo na wo dometɔ ɖe sia ɖe, ke etsɔ awudodo atɔ̃ kple klosalo alafa atɔ̃ na Benyamin. ");
INSERT INTO ewe_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ena tedzi ewo tsɔ nu nyui siwo le Egipte la yi na fofoa, eye wògana tedzi ewo bubu tsɔ bli kple nuɖuɖu vovovowo yi nɛ be wòaɖu le mɔa dzi. ");
INSERT INTO ewe_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ale wòdo mɔ nɔviawo. Nya mamlɛtɔ si Yosef gblɔ na nɔviawo lae nye, “Migawɔ dzre le mɔa dzi o hee!” ");
INSERT INTO ewe_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Ale wodzo le Egipte trɔ yi Kanaanyigba dzi le wo fofo Yakob gbɔ. ");
INSERT INTO ewe_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Wodo ɣli gblɔ na wo fofo be, “Yosef le agbe, eye wòzu Egiptenyigba blibo la dzi ɖula!” Ke nya la wɔ moya na Yakob ale gbegbe be mexɔe se o. ");
INSERT INTO ewe_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ke esi wogblɔ nya siwo Yosef be woagblɔ nɛ, eye wòkpɔ tasiaɖam siwo me nuɖuɖu si Yosef ɖo ɖee le la, Yakob ƒe dzi ɖo eme azɔ. ");
INSERT INTO ewe_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israel gblɔ be, “Nyateƒee, vinye Yosef le agbe, mayi aɖakpɔe ɖa hafi aku.” ");
INSERT INTO ewe_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ale Israel dze mɔ kple eƒe nuwo katã, eye esi wòva ɖo Beerseba la, esa vɔ na fofoa Isak ƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Le zã me la, Mawu ƒo nu na Israel le ŋutega me. Mawu yɔe be, “Yakob! Yakob!” Yakob tɔ be, “Nyee nye esi.” ");
INSERT INTO ewe_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Gbe la gblɔ be, “Nyee nye Mawu, fofowò ƒe Mawu, mègavɔ̃ na Egipte yiyi o, elabena mana nàzu dukɔ gã aɖe le afi ma. ");
INSERT INTO ewe_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Mayi Egipte kpli wò, eye magakplɔ wò agbɔe godoo, eye Yosef ŋutɔ ƒe asi amia wò ŋkuwo.” ");
INSERT INTO ewe_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ale Yakob dzo le Beerseba, eye Israel ƒe viwo kɔe kple wo viwo kpakple wo srɔ̃wo ɖe tasiaɖam siwo Farao na wo la me yi Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Wotsɔ woƒe lãwo kple nu siwo katã wokpɔ le Kanaanyigba dzi la ɖe asi yi Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Wokplɔ Yakob kple via ŋutsuwo, via nyɔnuwo, tɔgbuiyɔvia ŋutsuwo kple tɔgbuiyɔvia nyɔnuwo siaa yi Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israel alo Yakob ƒe viwo kple eƒe tɔgbuiyɔvi siwo yi Egipte kplii la woe nye: Ruben, Yakob ƒe viŋutsu tsitsitɔ. ");
INSERT INTO ewe_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ruben ƒe viwo: Hanok, Palu, Hezron kple Karmi. ");
INSERT INTO ewe_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon ƒe viŋutsuwo: Yemuel, Yamin, Ohad, Yakin, Zohar kple Saul. Kanaan nyɔnu aɖee nye Saul dada. ");
INSERT INTO ewe_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi ƒe viŋutsuwo: Gerson, Kohat, Merari. ");
INSERT INTO ewe_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yuda ƒe viŋutsuwo: Er, Onan, Sela, Perez, Zera. (Ke Er kple Onan ku le Kanaan do ŋgɔ na Israel ƒe ʋuʋu yi Egipte.) Perez ƒe viŋutsuwoe nye: Hezron kple Hamul. ");
INSERT INTO ewe_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isaka ƒe viŋutsuwo: Tola, Puva, Yob, Simrɔn. ");
INSERT INTO ewe_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulon ƒe viŋutsuwo: Sered, Elon, Yahlil. ");
INSERT INTO ewe_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Esiawoe nye viŋutsu siwo Lea dzi na Yakob le Padan Aram, kpe ɖe via nyɔnuvi Dina ŋu. Viŋutsu kple vinyɔnu siawo katã le blaetɔ̃-vɔ-etɔ̃. ");
INSERT INTO ewe_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad ƒe viŋutsuwoe nye: Zefon, Hagi, Suni, Ezbon, Eri, Arodi kple Areli. ");
INSERT INTO ewe_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Aser ƒe viŋutsuwoe nye: Imna, Isva, Isvi kple Beria. Wo nɔvinyɔnu ŋkɔe nye Sera. Beria ƒe viŋutsuwoe nye: Heber kple Malkiel. ");
INSERT INTO ewe_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ame wuiade siawo nye Yakob kple Zilpa, kosi si Lea fofo Laban tsɔ na Lea la ƒe viŋutsuwo. ");
INSERT INTO ewe_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Esiawoe nye Yakob ƒe viŋutsu siwo srɔ̃a Rahel dzi nɛ: Yosef kple Benyamin. ");
INSERT INTO ewe_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosef ƒe viŋutsu siwo wòdzi le Egipte la woe nye: Manase kple Efraim. Wo dadae nye Asenat, Potifera, ame si nye nunɔla na On ƒe vinyɔnu la. ");
INSERT INTO ewe_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyamin ƒe viŋutsuwo: Bela, Beker, Asbel, Gera, Naaman, Ehi, Ros, Mupim, Hupim kple Ard. ");
INSERT INTO ewe_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Woawoe nye viŋutsu siwo Rahel dzi na Yakob; wo katã le ame wuiene. ");
INSERT INTO ewe_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan ƒe viŋutsue nye: Husim. ");
INSERT INTO ewe_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naftali ƒe viŋutsuwoe nye: Yaziel, Guni, Yezer kple Silem. ");
INSERT INTO ewe_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Esiawoe nye Bilha, kosi si Laban tsɔ na via nyɔnu Rahel la ƒe viŋutsu siwo wòdzi na Yakob—wo katã le ame adre. ");
INSERT INTO ewe_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ale ame siwo katã yina Egipte, eye wonye Yakob ƒe dzidzimeviwo, ne Yakob ƒe viŋutsuwo srɔ̃wo mele eme o la, wode ame blaade-vɔ-ade. ");
INSERT INTO ewe_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ne Yosef ƒe viŋutsu eveawo kpee la, Yakob ƒe aƒemetɔwo de blaadre le Egipte. ");
INSERT INTO ewe_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yakob na Yuda do ŋgɔ be wòagblɔ na Yosef be yewole mɔa dzi gbɔna, eye esusɔ vie yewoaɖo Gosen. Eteƒe medidi o la, woɖo Gosen. ");
INSERT INTO ewe_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosef dzo ge ɖe eƒe tasiaɖam me, eye wòyi ɖakpe fofoa Israel le Gosen. Wokpla asi kɔ na wo nɔewo, eye wofa avi ɣeyiɣi didi aɖe. ");
INSERT INTO ewe_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israel gblɔ na Yosef be, “Azɔ la, mate ŋu aku faa, elabena megakpɔ wò agbagbee.” ");
INSERT INTO ewe_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yosef gblɔ na nɔviawo kple woƒe aƒemetɔwo katã be, “Mayi aɖagblɔ na Farao be mieva ɖo, eye mietso Kanaanyigba dzi be miava anɔ afi sia kplim. ");
INSERT INTO ewe_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mana wòanya be, ‘Ame siawo nye alẽkplɔlawo. Wova kple woƒe lãwo kple nu siwo katã le wo si la.’ ");
INSERT INTO ewe_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Eya ta ne Farao yɔ mi, eye wòbia be dɔ ka miewɔna hã la, ");
INSERT INTO ewe_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","migblɔ nɛ be, ‘Míenye alẽkplɔlawo tso keke míaƒe ɖekakpuime ke abe ale si mía fofowo hã nye alẽkplɔlawo ene.’ Ne miegblɔ nɛ alea la, ana mianɔ Gosenyigba dzi le afi sia, elabena wodoa vlo alẽkplɔlawo, eye wolé fu wo le Egipte ƒe akpa bubuawo.” ");
INSERT INTO ewe_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Esi wova ɖo la, Yosef yi Farao gbɔ, eye wògblɔ nɛ be, “Fofonye kple nɔvinyewo tso Kanaan va ɖo afii kple woƒe lãwo kpakple woƒe nuwo katã. Wodi be yewoanɔ Gosenyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Ekplɔ nɔvia ŋutsu atɔ̃ ɖe asi, eye wòɖe wo fia Farao. ");
INSERT INTO ewe_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Farao bia wo be, “Dɔ ka miewɔna?” Woɖo eŋu be, “Míenye alẽkplɔlawo abe mía tɔgbuiwo kple mía fofowo ene. ");
INSERT INTO ewe_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Míeva be míanɔ Egipte, elabena gbeɖuƒe mele Kanaanyigba dzi na míaƒe lãwo o; dɔwuame la nu sesẽ le afi ma ŋutɔ. Míele mɔ biam be nàna míanɔ Gosenyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Farao gblɔ na Yosef be, “Fofowò kple nɔviwò ŋutsuwo va gbɔwò, ");
INSERT INTO ewe_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","eye Egiptenyigba le ŋkuwò me. Na fofowò kple nɔviwò ŋutsuwo nanɔ anyigba la ƒe akpa nyuitɔ dzi. Na woanɔ Gosen. Ne ènya wo dometɔ aɖe si ŋu ŋutete tɔxɛ aɖe le la, nàna wòakpɔ nye ŋutɔ nye lãhawo dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Emegbe la, Yosef kplɔ fofoa, Yakob va Farao gbɔ, eye Yakob yra Farao. ");
INSERT INTO ewe_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Farao bia Yakob be, “Ƒe neni nèxɔ?” ");
INSERT INTO ewe_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yakob ɖo eŋu be, “Mexɔ ƒe alafa ɖeka blaetɔ̃, meto nu sesẽ geɖewo me, eye nyemetsi abe fofonyewo ene haɖe o.” ");
INSERT INTO ewe_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Yakob gayra Farao hafi dzo. ");
INSERT INTO ewe_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Ale Yosef tsɔ anyigba nyuitɔ le Egipte, afi si nye Ramesesnyigba la na fofoa kple nɔviawo abe ale si Farao gblɔe ene. ");
INSERT INTO ewe_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yosef na nuɖuɖu wo ɖe ame siwo dzi kpɔm wole la ƒe xexlẽme nu. ");
INSERT INTO ewe_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Dɔwuame la nu ganɔ sesẽm ɖe edzi kokoko le Egipte kple Kanaan siaa. ");
INSERT INTO ewe_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yosef xɔ ga siwo katã le ame siwo le Egipte kple Kanaan la si, eye wòna nuɖuɖu wo ɖe woƒe ga teƒe. Etsɔ ga la de Farao ƒe gadzraɖoƒe. ");
INSERT INTO ewe_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Azɔ ga vɔ keŋkeŋ le ameawo si, gake wogava Yosef gbɔ kple kukuɖeɖe be wòagana nuɖuɖu yewo. Wogblɔ nɛ be, “Míaƒe ga vɔ keŋkeŋ, gake na nuɖuɖu mí, elabena mele be míaku o.” ");
INSERT INTO ewe_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosef ɖo eŋu na wo be, “Enyo, mitsɔ miaƒe lãwo nam ne miaxɔ nuɖuɖu ɖe wo teƒe.” ");
INSERT INTO ewe_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Ale wotsɔ woƒe nyiwo vɛ na Yosef, eye woxɔ nuɖuɖu ɖe wo teƒe. Le ɣeyiɣi kpui aɖe megbe la, Egiptetɔwo ƒe sɔwo, alẽwo, nyiwo kple tedziwo katã zu Farao tɔ. ");
INSERT INTO ewe_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Esi ƒe trɔ la, wogayi Yosef gbɔ, eye wogblɔ nɛ be, “Aƒetɔ, míate ŋu aɣla nya aɖeke ɖe wò o. Míaƒe ga vɔ, eye míaƒe lãhawo zu tɔwò; míaƒe nu siwo susɔ la koe nye míaƒe ŋutilãwo kple míaƒe agblenyigbawo. ");
INSERT INTO ewe_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nu ka ta míaku ɖo? Ƒle mí kple míaƒe agblenyigbawo, eye míawo kple míaƒe agblenyigbawo siaa míazu Farao tɔ. Míadzra mía ɖokuiwo na wò axɔ nuɖuɖu, ekema míatsi agbe, eye anyigba la matsi yame o.” ");
INSERT INTO ewe_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Ale Yosef ƒle Egiptetɔwo ƒe agblenyigbawo katã na Farao. Egiptetɔwo katã dzra woƒe anyigbawo, elabena dɔwuame la nu sesẽ ŋutɔ. Ale anyigba la zu Farao tɔ. ");
INSERT INTO ewe_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ale Egiptetɔwo katã zu awɔbamewo na Farao. ");
INSERT INTO ewe_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Anyigba si meƒle o la koe nye esi nye nunɔlawo tɔ, elabena Farao naa nuɖuɖu wo, eye mehiã be woadzra woƒe anyigba o. ");
INSERT INTO ewe_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yosef gblɔ na ameawo be, “Meƒle miawo ŋutɔ kple miaƒe anyigbawo na Farao. Blie nye esi, miyi miade agble. ");
INSERT INTO ewe_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Mima nu sia nu si miaxa la ɖe akpa atɔ̃ me; ɖeka nanye Farao tɔ. Akpa ene nanye mia tɔ, wòanye nuƒaƒã le ƒe si gbɔna la me kple nuɖuɖu na miawo ŋutɔ miaƒe aƒemetɔwo kple mia viwo.” ");
INSERT INTO ewe_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ameawo gblɔ be “Èɖe míaƒe agbe! Aƒetɔ, ne àlɔ̃ la, míanye awɔbamewo na Farao.” ");
INSERT INTO ewe_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Eya ta Yosef wɔe wòzu se le Egiptenyigba blibo la dzi va se ɖe egbegbe be woadzɔ agblemenukuwo katã ƒe akpa atɔ̃lia na Farao. Nuku siwo woƒã ɖe nunɔlawo ƒe anyigba dzi la koe mele eme o. ");
INSERT INTO ewe_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ale Israel nɔ Gosenyigba dzi le Egipte. Nuwo de asi nyonyo me na Israelviwo kabakaba, eye wodzi sɔ gbɔ fũu. ");
INSERT INTO ewe_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yakob ganɔ agbe ƒe wuiadre esime wòva ɖo Gosen, ale exɔ ƒe alafa ɖeka blaene-vɔ-adre hafi ku. ");
INSERT INTO ewe_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Esi Israel ƒe kuɣi gogo la, eyɔ via Yosef gblɔ nɛ be, “Ka atam nam be yeawɔ nye didi mamlɛtɔ dzi nam: Mègaɖim ɖe Egipte o. ");
INSERT INTO ewe_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ne meku la, tsɔm dzoe le Egipte, eye nàɖim ɖe tɔgbuinyewo xa.” Yosef ka atam sia. ");
INSERT INTO ewe_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Israel ƒoe ɖe enu be, “Ka atam nam be yeawɔe.” Yosef ka atam la. Tete Israel gamlɔ eƒe aba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Le nya siawo megbe la, wova gblɔ na Yosef be fofoa ƒe lãmegbegblẽ la nu nɔ sesẽm ɖe edzi kokoko. Ale wòkplɔ Via ŋutsuvi eveawo, Manase kple Efraim, eye woyi ɖakpɔe ɖa. ");
INSERT INTO ewe_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Eye wogblɔ na Yakob bena, “Kpɔ ɖa viwò Yosef va gbɔwò.” Tete Israel do ŋusẽ nu fɔ henɔ anyi ɖe abatia dzi be yeado gbe nɛ, ");
INSERT INTO ewe_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","eye wògblɔ na Yosef be, “Mawu Ŋusẽkatãtɔ ɖe eɖokui fiam le Luz, le Kanaanyigba dzi, eye wòyram. ");
INSERT INTO ewe_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Egblɔ nam be, ‘Mawɔ wò nàzu dukɔ gã, eye matsɔ Kanaanyigba sia ana wò kple wò dzidzimeviwo, wòanye mia tɔ tegbetegbe.’ ");
INSERT INTO ewe_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Azɔ le viwò eve siawo, Efraim kple Manase, ame siwo wodzi le Egiptenyigba dzi hafi meva la, mele woawo ya xɔm abe nye ŋutɔ vinyewo ene, eye woanyi nye dome abe Ruben kple Simeon ke ene. ");
INSERT INTO ewe_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ke viwò bubu ɖe sia ɖe ya la, anye wò ŋutɔ tɔ, eye woanyi Efraim kple Manase ƒe dome tso gbɔwò le wò ŋutɔ wò nuwo gome. ");
INSERT INTO ewe_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Elabena dawò Rahel dzi vi eve ko, eye wòku esi metso Padan gbɔna Kanaan. Ke esi míegogo Efrat la, meɖii ɖe mɔ to le Efrat” (si nye Betlehem). ");
INSERT INTO ewe_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israel lé ŋku ɖe Yosef ƒe ŋutsuviawo ŋu, eye wòbia be, “Ŋutsuviawoe nye esiawoa?” ");
INSERT INTO ewe_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosef ɖo eŋu be, “Ɛ̃, esiawoe nye ŋutsuvi siwo Mawu nam le afii le Egipte.” Israel gblɔ be, “Kplɔ wo te ɖe ŋunye ne mayra wo.” ");
INSERT INTO ewe_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Israel ƒe tsitsi na eƒe ŋkuwo tsi afã kple afã, eye megatea ŋu kpɔa nu tututu o. Ale Yosef kplɔ viawo te ɖe eŋu kpokploe. Egbugbɔ nu na wo, eye wòkpla asi kɔ na wo. ");
INSERT INTO ewe_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israel gblɔ na Yosef be, “Nyemebu tsã be magakpɔ wò o, ke azɔ Mawu na mekpɔ viwòwo hã.” ");
INSERT INTO ewe_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tete Yosef ɖe wo ɖa le Israel ƒe atata, eye wòde ta agu, tsyɔ mo anyi. ");
INSERT INTO ewe_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Eye Yosef tsɔ wo ame eveawo; Efraim yi ɖe ɖusime be wòanɔ Israel ƒe miame, eye Manase yi ɖe miame be wòanɔ Israel ƒe ɖusime, eye wòkplɔ wo te ɖe Israel ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ke Israel tso ga eƒe abɔwo esime wòdi be yeada yeƒe asiwo ɖe ɖeviawo ƒe tawo dzi. Ale eƒe ɖusi nɔ Efraim, ame si nye ɖevitɔ, eye wònɔ eƒe miame la ƒe ta dzi, eye eƒe miasi nɔ Manase, ame si nye tsitsitɔ, eye wònɔ eƒe ɖusime la ƒe ta dzi. ");
INSERT INTO ewe_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Eyra Yosef kple nya siawo be, “Mawu, fofonye Abraham kple Isak ƒe Mawu, ame si kplɔm le nye agbenɔɣi katã me la nayra ŋutsuvi siawo nukutɔe. ");
INSERT INTO ewe_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Mawudɔla si ɖem tso xaxa ɖe sia ɖe me la nayra ɖevi siawo, woade bubu nye ŋkɔ ŋu, eye woade bubu fofonye Abraham kple Isak ƒe ŋkɔwo ŋu. Mawu naɖi ne woazu dukɔ gã aɖe.” ");
INSERT INTO ewe_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ke Yosef tɔtɔ, eye mekpɔ ŋudzedze le ale si fofoa da eƒe nuɖusi ɖe Efraim ƒe ta dzi la ŋu o. Ale wòɖe fofoa ƒe nuɖusi ɖa be yeadae ɖe Manase boŋ tɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Egblɔ be, “Ao, fofonye, ètsɔ wò nuɖusi da ɖe ame si ƒe ta dzi mele be nàdae ɖo o la! Ame si le afi sia lae nye tsitsitɔ. Da wò nuɖusi ɖe eya boŋ dzi!” ");
INSERT INTO ewe_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ke fofoa gbe hegblɔ nɛ be, “Vinye, menya nu si wɔm mele. Manase hã azu dukɔ gã aɖe, ke nɔvia suetɔ azu dukɔ gã wu.” ");
INSERT INTO ewe_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ale Yakob yra ɖeviawo gbe ma gbe ale: “Israelviwo nayra wo nɔewo agblɔ be, ‘Mawu nana nuwo nadze edzi na wò abe Efraim kple Manase ene!’ ” Ale wòtsɔ Efraim ɖo tsitsi na Manase. ");
INSERT INTO ewe_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Israel gblɔ na Yosef be, “Mele kuku ge kpuie, ke Mawu anɔ kpli wò, eye wòagakplɔ wò ayi Kanaan, fofowòwo ƒe anyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Metsɔ Sekemnyigba si metsɔ nye yi kple dati xɔ le Amoritɔwo si la na wò ɖe nɔviwòwo teƒe be wòanye wò gome.” ");
INSERT INTO ewe_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yakob yɔ via ŋutsuwo katã ƒo ƒu, eye wògblɔ na wo be, “Miƒo ƒu ɖe ŋunye, eye magblɔ nu siwo ava adzɔ ɖe mia dzi le ɣeyiɣi si gbɔna me la na mi. ");
INSERT INTO ewe_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Miɖo tom, Yakob ƒe viwo, miɖo to Israel, mia fofo. ");
INSERT INTO ewe_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, wòe nye nye viŋutsu tsitsitɔ, nye ɖekakpuimevi. Wòe nye ta le tsitsi kple bubu nu. ");
INSERT INTO ewe_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ke mèdzea akɔ anyi o; èle abe ƒutsotsoe nyanyra ene; màgadze gbãtɔ azɔ o. Maɖiɖi wò, elabena ède asi srɔ̃nyewo dometɔ ɖeka ŋu, eye nèto esia me ɖi gbɔ̃m. ");
INSERT INTO ewe_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon kple Levi ƒe nɔnɔme sɔ. Wonye ame siwo wɔa sesẽnu kple nu madzɔmadzɔ. ");
INSERT INTO ewe_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","O, nye luʋɔ, ɖe ɖa le ame siawo ŋu. Nyematɔ ɖe woƒe nu vɔ̃ɖiwo dzi gbeɖe o. Elabena wowu ame aɖe le woƒe dɔmedzoe me, eye wode abi nyiwo ŋu dzodzro abe fefenu ene. ");
INSERT INTO ewe_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Woaƒo fi ade woƒe dɔmedzoe, elabena enu sesẽ, eye wòvɔ̃ɖi. Mama wo ɖe Yakob ƒe viwo dome, eye makaka woƒe dzidzimeviwo le Israel. ");
INSERT INTO ewe_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yuda, nɔviwòwo akafu wò; àtsrɔ̃ wò futɔwo. Fofowòviwo ade ta agu na wò. ");
INSERT INTO ewe_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda nye dzatavi; si wu nu si wòlé la ɖuɖu nu. Etsyɔ akɔ anyi abe dzatatsu ene; eye abe dzatanɔ ene–ame kae ake atse anyɔe? ");
INSERT INTO ewe_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Atamkayi maɖe ɖa le Yuda o va se ɖe esime ame si tututu tɔ wònye la nava, ame si amewo katã abu. ");
INSERT INTO ewe_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ede ka eƒe tedzivi ɖe wainti nyuitɔ ŋu, eye wònya eƒe awuwo le wain me. ");
INSERT INTO ewe_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Eƒe ŋkuwo biã wu wain, eye eƒe aɖuwo fu wu notsi. ");
INSERT INTO ewe_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulon anɔ ƒuta, eye wòanye tɔdziʋuwo dzeƒe. Eƒe anyigba akeke ade keke Sidon. ");
INSERT INTO ewe_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isaka nye tedzi agbatsɔlã sesẽ aɖe si le dzudzɔm le lãkpowo dome. ");
INSERT INTO ewe_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Esi wòkpɔ ale si teƒea nya kpɔna kple ale si anyigba la nyoe la, elɔ̃ dze dɔ la dzi, eye wòsubɔ eƒe aƒetɔ kple ŋusẽ. ");
INSERT INTO ewe_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan aɖu eƒe amewo dzi abe Israel ƒe to bubu ɖe sia ɖe ene. ");
INSERT INTO ewe_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Anye da si ɖua afɔkpodzi na sɔ le mɔ dzi, eye sɔdola dzea anyi la. ");
INSERT INTO ewe_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yehowa, wò ɖeɖe la ko mele mɔ kpɔm na. ");
INSERT INTO ewe_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Adzoblasuwo ƒe ha adze Gad dzi, ke eya anya wo ɖe du nu. ");
INSERT INTO ewe_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aser la, nuɖuɖu siwo nyo na fiawo la aʋã nɛ fũu. ");
INSERT INTO ewe_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naftali nye zinɔ si ɖea abla, eye wògblɔa nya viviwo la. ");
INSERT INTO ewe_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yosef nye kutsetseti aɖe si le tsi dzidzi to, eɖe alɔwo, eye wòɖo vɔvɔli ɖe gliwo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ame siwo da aŋutrɔe, eye woti eyome la wɔ nuvevii. ");
INSERT INTO ewe_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Gake eƒe asi li ɖe eƒe dati ŋu goŋgoŋ eye eƒe asi le tsɔtsɔm elabena Yakob ƒe Mawu Ŋusẽkatãtɔ, alẽkplɔla la kple Israel ƒe Agakpe ");
INSERT INTO ewe_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Mia fofowo ƒe Mawu, Ŋusẽkatãtɔ la nakɔ dziƒoyayrawo kple anyigbadziyayrawo ɖe dziwò duu, wòana nàdzi asɔ gbɔ, ");
INSERT INTO ewe_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","wòana nuɖuɖu kple seƒoƒowo nawɔ na wò fũu, eye wòatsɔ yayra siwo ade kekeke togbɛ siwo anɔ anyi tegbee ƒe liƒowo dzi la na wò. Yayra siawoe ava Yosef, ame si woɖe aboyoe le nɔviawo dome la dzi. ");
INSERT INTO ewe_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benyamin nye amegaxi si léa nu. Evuvua eƒe futɔwo le ŋdi, eye wòmaa nu si wòlé la le fiẽ.” ");
INSERT INTO ewe_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Esiawoe nye yayra siwo wo fofo Israel kɔ ɖe via wuieveawo dzi. ");
INSERT INTO ewe_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Eye wòɖo nu siawo na wo: “Esusɔ vie mayi tɔgbuinyewo gbɔ. Miɖim ɖe fofonyewo gbɔ ɖe kpeto la me le Efrɔn, Hititɔ la ƒe anyigba dzi, ");
INSERT INTO ewe_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ɖe kpeto si le Makpela ƒe anyigba si te ɖe Mamre ŋu le Kanaanyigba dzi la. Abraham ƒle teƒe sia abe ameɖiƒe ene le Efrɔn, Hititɔ la gbɔ kpe ɖe anyigba la ŋu. ");
INSERT INTO ewe_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Afi ma woɖi Abraham kple srɔ̃a Sara ɖo. Afi ma woɖi Isak kple srɔ̃a Rebeka ɖo, eye afi ma ke meɖi Lea hã ɖo. ");
INSERT INTO ewe_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Enye kpeto si tɔgbuinye Abraham ƒle le Het ƒe viŋutsuwo si.” ");
INSERT INTO ewe_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Esi Yakob wu eƒe nyagblɔɖiawo na viawo nu la, emlɔ anyi azɔ ɖe eƒe abati dzi, eye wòku. ");
INSERT INTO ewe_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yosef tsɔ eɖokui ƒu fofoa ƒe kukua dzi, fa avi ɖe edzi, eye wògbugbɔ nu nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Emegbe la, eɖe gbe na eƒe atikewɔlawo be woasi atike na ye fofo Israel. Ale atikewɔlawo si atike nɛ. ");
INSERT INTO ewe_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Atikesisi la xɔ ŋkeke blaene, eye Egipte dukɔ blibo la ƒe konyifafa xɔ ŋkeke blaadre. ");
INSERT INTO ewe_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Esi konyifaɣi la va yi la, Yosef te ɖe Farao ŋumewo ŋu, eye wòɖe kuku na wo be woaƒo nu na Farao na ye. ");
INSERT INTO ewe_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Egblɔ na wo be, “Migblɔ na fia la be Yosef fofo na Yosef ka atam be yeatsɔ ye fofo ƒe kukua ayi Kanaanyigba dzi, eye yeaɖii ɖe afi ma. Mibia mɔfiala nam be wòaɖe mɔ mayi aɖaɖi fofonye. Mika ɖe edzi nɛ nam be matrɔ agbɔ enumake.” ");
INSERT INTO ewe_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Farao lɔ̃ hegblɔ be, “Yi nàɖi fofowò abe ale si nèka atam ene.” ");
INSERT INTO ewe_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Ale Yosef yi kple Farao ƒe aɖaŋudelawo kple kpeɖeŋutɔwo ");
INSERT INTO ewe_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","kple Yosef nɔviŋutsuwo kple woƒe ƒometɔwo. Ke wogblẽ wo vi suewo kple woƒe lãwo ɖe Gosenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Ale tasiaɖamwo kple sɔdola geɖewo kpakple ameha gã aɖe kplɔ Yosef yii. ");
INSERT INTO ewe_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Esi woɖo Atad, teƒe si le Yɔdan tɔsisi la ƒe ɣetoɖoƒe lɔƒo, eye wòte ɖe Yeriko ŋu la, wode kusɔleme, eye wofa konyi ŋkeke adre sɔŋ le Yakob ƒe ku ta. ");
INSERT INTO ewe_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kanaantɔwo na ŋkɔ bubuteƒe si le afi si te ɖe Yɔdan ŋu la be, Abel Mizraim si gɔmee nye “Konyifalawo tso Egipte,” elabena wogblɔ be, “Teƒe sia Egiptetɔwo fa konyi le vevie.” ");
INSERT INTO ewe_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ale Yakob ƒe viwo wɔ nu siwo wòɖo na wo la. ");
INSERT INTO ewe_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Wotsɔe yi Kanaanyigba dzi, eye woɖii ɖe kpeto si le Makpela ƒe anyigba dzi si te ɖe Mamre ŋu, abɔ si Abraham ƒle le Efrɔn, Hititɔ la si be wòanye ameɖiƒe la me. ");
INSERT INTO ewe_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosef trɔ va Egipte kple nɔviawo kpakple ame siwo katã yi wo fofo ƒe kuteƒe la. ");
INSERT INTO ewe_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ke esi wo fofo ku azɔ la, Yosef nɔviwo de asi vɔvɔ̃ me. Wogblɔ be, “Azɔ la, Yosef aɖo nu vɔ̃ si míewɔ ɖe eŋu la teƒe na mí.” ");
INSERT INTO ewe_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Ale woɖo ame ɖe Yosef be, “Fofowò gblẽ ɖoɖo siawo ɖi hafi ku. ");
INSERT INTO ewe_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Nya si miagblɔ na Yosef lae nye: Mebia tso asiwò be nàtsɔ nɔviwòwo ƒe nu vɔ̃ kple vodada siwo wowɔ ɖe ŋuwò la ake wo.’ Azɔ míeɖe kuku, tsɔ nu vɔ̃ ke fofowò ƒe Mawu la ƒe dɔlawo.” Esi nya siawo va ɖo Yosef gbɔ la, efa avi. ");
INSERT INTO ewe_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Tete nɔviawo va dze klo, de ta agu nɛ, eye wogblɔ nɛ be, “Míenye wò kluviwo.” ");
INSERT INTO ewe_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ke Yosef gblɔ na wo be, “Migavɔ̃ o, Mawue menye be madrɔ̃ ʋɔnu mi, ahe to na mia? ");
INSERT INTO ewe_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Le nye ɖeka gome la, Mawu trɔ nu si mieɖo be wòanye nu vɔ̃ la wòzu nu nyui, elabena etsɔm ɖo teƒe kɔkɔ si mele egbe la be mate ŋu aɖe ame geɖewo ƒe agbe. ");
INSERT INTO ewe_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Migavɔ̃ o, nye ŋutɔ makpɔ miawo kple miaƒe ƒometɔwo dzi.” Eƒo nu na wo kple gbe bɔbɔe, eye wòde dzi ƒo na wo. ");
INSERT INTO ewe_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Ale Yosef kple nɔviawo kpakple woƒe ƒometɔwo ganɔ Egipte. Yosef xɔ ƒe alafa ɖeka kple ewo hafi ku. ");
INSERT INTO ewe_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Enɔ agbe, kpɔ via Efraim ƒe viwo kple Makir, Manase ƒe vi ƒe viwo, ame siwo fena le Yosef ƒe afɔ nu. ");
INSERT INTO ewe_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yosef gblɔ na nɔviawo be, “Esusɔ vie maku, ke Mawu ava aɖe mi tso Egiptenyigba sia dzi, eye wòakplɔ mi, miatrɔ ayi anyigba si ŋugbe wòdo na Abraham, Isak kple Yakob ƒe dzidzimeviwo la dzi.” ");
INSERT INTO ewe_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Emegbe Yosef na Israel ƒe viwo ka atam nɛ be, “Mawu akpe ɖe mia ŋu be miatsɔ nye kukua tso afi sia ayi Kanaan.” ");
INSERT INTO ewe_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Ale Yosef ku esi wòxɔ ƒe alafa ɖeka kple ewo. Wosi atike na eƒe kukua, eye wodee aɖaka me le Egipte.");
INSERT INTO ewe_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Israel ƒe viŋutsu siwo kplɔ Yakob ɖo yi Egipte kple woƒe ƒometɔwoe nye: ");
INSERT INTO ewe_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben, Simeon, Levi, Yuda, ");
INSERT INTO ewe_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isaka, Zebulon, Benyamin, ");
INSERT INTO ewe_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naftali, Gad kple Aser. ");
INSERT INTO ewe_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ame siwo katã kplɔ Yakob ɖo yi Egipte la anɔ ame blaadre. Yosef ya nɔ afi ma xoxo. ");
INSERT INTO ewe_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Le ɣeyiɣi aɖe megbe la, Yosef kple nɔviawo katã ku, eye dzidzime ma nu tso. ");
INSERT INTO ewe_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Azɔ la, Israelviwo ƒe dzidzimeviwo dzina kabakaba. Wodzi sɔ gbɔ ale gbegbe be le ɣeyiɣi kpui aɖe megbe la, wozu dukɔ gã aɖe, eye woyɔ anyigba la dzi fũu. ");
INSERT INTO ewe_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Eva eme be fia yeye aɖe va ɖu Egipte dzi, ame si menya Yosef o. ");
INSERT INTO ewe_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Fia sia gblɔ na eƒe amewo be, “Kpɔ ɖa, Israelvi siawo sɔ gbɔ wu mí akpa. ");
INSERT INTO ewe_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Mina míato ayemɔ aɖe dzi atsi nu sia nu. Ne míetsi nu sia nu o, eye aʋa dzɔ la, woade míaƒe futɔwo dzi, awɔ aʋa kpli mí asi adzo le anyigba la dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ale Egiptetɔwo wɔ Israelviwo woƒe kluviwoe. Wotsɔ dɔdzikpɔla ŋutasẽlawo ɖo wo nu be woana woawɔ dɔ sesẽ, woatu nudzraɖoƒe gãwo ɖe Pitom kple Rameses na Farao. ");
INSERT INTO ewe_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Togbɔ be Egiptetɔwo nɔ fu wɔm Israelviwo, eye wonɔ wo tem ɖe to wu tsã gɔ̃ hã la, Israelviwo ganɔ dzidzim ɖe edzi kokoko! Nu sia gado ŋɔdzi na Egiptetɔwo wu ");
INSERT INTO ewe_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","eye wogazi wo dzi wu tsã. ");
INSERT INTO ewe_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Wona agbenɔnɔ ti wo to dɔ sesẽ wɔwɔ le anyikpewo meme kple agbledɔwo wɔwɔ me. Egiptetɔwo na wowɔ dɔ sesẽ siawo katã nublanuimakpɔmakpɔtɔe. ");
INSERT INTO ewe_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Egipte fia gblɔ na Hebri nyɔnu siwo nye vixelawo, ame siwo ŋkɔwoe nye Sipra kple Pua be, ");
INSERT INTO ewe_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Ne miekpe ɖe Hebri nyɔnu aɖe ŋu wòdzi vi, eye miekpɔ le vidziƒea be ŋutsuvi wòdzi la, miwu ɖevi la enumake, gake ne nyɔnuvi wòdzi la, mina ɖevia natsi agbe.” ");
INSERT INTO ewe_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Ke vixela siawo vɔ̃a Mawu, eye womewɔ ɖe Egipte fia la ƒe se la dzi o, wona ŋutsuviawo hã tsi agbe. ");
INSERT INTO ewe_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Fia la yɔ vixelawo, eye wòbia wo be, “Nu ka ta miegbe nye se la dzi wɔwɔ, eye miena ŋutsuviawo hã le agbe tsim ɖo?” ");
INSERT INTO ewe_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Woɖo eŋu na Farao be, “Aƒetɔ, Hebri nyɔnuwo ƒe vidzidzi tsɔna ale gbegbe be, míeɖoa wo gbɔ hafi wodzia vi le wo ɖokuiwo si o. Woawo ƒe vidzidzi mexɔa ɣeyiɣi abe míaƒe Egipte nyɔnuwo tɔ ene o!” ");
INSERT INTO ewe_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Le esia ta Mawu yra vixelawo. Ale Israelviwo dzi ɖe edzi, eye wokpɔ ŋusẽ ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Esi vixelawo vɔ̃a Mawu ta la, Mawu na viwo woawo hã. ");
INSERT INTO ewe_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Fia Farao va de se na eƒe amewo katã be, “Miatsɔ ŋutsuvi ɖe sia ɖe si woadzi la aƒu gbe ɖe Nil tɔsisi la me, ke miana nyɔnuviwo ya natsi agbe.” ");
INSERT INTO ewe_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ŋutsu aɖe si nye Levitɔ la ɖe nyɔnu aɖe si hã nye Levitɔ. ");
INSERT INTO ewe_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Nyɔnu la fɔ fu, eye wòdzi ŋutsuvi. Esi nyɔnu la kpɔ be ye viŋutsu la dze ɖeka ŋutɔ la, eɣlae ɖe aƒe me ɣleti etɔ̃. ");
INSERT INTO ewe_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ke esi wòkpɔ be yemagate ŋu aɣlae wòadidi wu nenema o la, etsɔ aƒla lɔ̃ kusi, eye wòsi aŋɔ ɖe eme ale be tsi mate ŋu age ɖe eme o. Ekɔ ɖevi la mlɔ kusi la me, eye wòtsɔe ɣla ɖe aƒla siwo le Nil tɔsisi la to la me. ");
INSERT INTO ewe_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Ena vidzĩ la nɔvinyɔnu nɔ adzɔge vie ale be wòakpɔ nu si ava dzɔ ɖe ɖevi la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Nu si va dzɔe nye be Fia Farao ƒe vinyɔnu, va tsi le ge le Nil tɔsisi la me. Esi eya kple eƒe dɔlanyɔnuwo nɔ zɔzɔm le tɔsisi la to la, ekpɔ kusi la le aƒlawo me. Edɔ eƒe dɔlanyɔnuawo dometɔ ɖeka ɖa be wòakɔe vɛ. ");
INSERT INTO ewe_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Eʋu kusi la, eye wòkpɔ vidzĩ la le eme! Ɖevi la nɔ avi fam, nu sia wɔ dɔ ɖe fiavinyɔnu la dzi, eye wògblɔ be, “Ɖevi sia nye Hebri ŋutsuviawo dometɔ ɖeka.” ");
INSERT INTO ewe_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Vidzĩ la nɔvinyɔnu te ɖe fiavinyɔnu la ŋu, eye wòbiae be, “Mayi ɖayɔ Hebri nyɔnuawo dometɔ ɖeka wòanyi ɖevi sia na wòa?” ");
INSERT INTO ewe_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Fiavinyɔnu la ɖo eŋu be, “Ɛ̃, yi!” Ale nyɔnuvi la ƒu du yi aƒe me, eye wòyɔ vidzĩa dadaa vɛ! ");
INSERT INTO ewe_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Fiavinyɔnu la gblɔ na vidzĩa dadaa be, “Kɔ vidzĩ sia yi aƒe me, na noe nam, eye maxe fe si adze ŋuwò la na wò!” Ale vidzĩ la dada kɔe yi aƒe me, eye wòkpɔ edzi nyuie. ");
INSERT INTO ewe_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Esi ɖevi la tsi la, dadaa kɔe yi na Farao ƒe vinyɔnu la, eye wòzu Via ŋutsuvi. Ena ŋkɔe be Mose, si gɔmee nye “Tɔ mee woɖee tsoe,” elabena egblɔ be tsi mee yeɖee tsoe. ");
INSERT INTO ewe_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Esi Mose tsi, eye wòzu ɖekakpui la, eɖi tsa gbe ɖeka be yeakpɔ ye nɔvi Hebritɔwo ɖa. Ekpɔ fuwɔame kple teteɖeanyi si te wonɔ. Ekpɔ Egiptetɔ aɖe wòƒo nɔvia Hebritɔ aɖe ƒu anyi. ");
INSERT INTO ewe_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mose tsa ŋku mlamlamla be yeaka ɖe edzi be ame aɖeke menɔ ye kpɔm o. Ewu Egiptetɔ la, eye wòɖii ɖe ke me. ");
INSERT INTO ewe_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ke esi ŋu ke la, Mose gaɖi tsa be yeaɖakpɔ ye nɔvi Hebritɔwo ɖa. Ekpɔ Hebritɔ eve wonɔ kɔ dam, eye wòbia ame si di ge la be, “Nu kae nye esi wɔm nèle, hele wò ŋutɔ nɔviwò Hebritɔ ƒom ale?” ");
INSERT INTO ewe_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Ŋutsu sia biae be, “Ame kae ɖo wò fia kple ʋɔnudrɔ̃la ɖe mía nu? Ɖe nèle didim be yeawu nye hã abe ale si nèwu Egiptetɔ ma etsɔ enea?” Vɔvɔ̃ ɖo Mose, elabena ebu xaa be, “Ɖewohĩ nu si mewɔ la le nyanya me na amewo.” ");
INSERT INTO ewe_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Farao se nya la, eye wòɖe gbe be woalée, awui. Ke Mose si le Farao nu yi ɖe Midianyigba dzi, eye wònɔ anyi ɖe vudo aɖe to. ");
INSERT INTO ewe_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ɖetugbi adre, ame siwo nye Midian nunɔla ƒe vinyɔnuwo la va be yewoaku tsi ana yewo fofo ƒe alẽha. ");
INSERT INTO ewe_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ke alẽkplɔla aɖewo va nya wo. Ale Mose tsi tsitre va xɔ na wo, eye wòna tsi woƒe alẽhawo. ");
INSERT INTO ewe_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Esi ɖetugbiawo trɔ yi aƒe me la, wo fofo, Reuel bia wo be, “Nu kae na miekpɔ tsi na alẽwo egbe ya kaba nenema?” ");
INSERT INTO ewe_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Woɖo eŋu nɛ be, “Egiptetɔ aɖee xɔ mí le alẽkplɔla mawo ƒe asi me, eye wòku tsi na míaƒe alẽhawo.” ");
INSERT INTO ewe_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Wo fofo gblɔ na wo be, “Nu ka ta miegblẽe ɖe afi ma ɖo? Miyi miakplɔe vɛ wòaɖu nu kpli mí.” ");
INSERT INTO ewe_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mose xɔ Reuel ƒe kpekpe la, eye wòlɔ̃ be yeanɔ egbɔ. Reuel tsɔ via si woyɔna be Zipora la nɛ wòɖe. ");
INSERT INTO ewe_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Wodzi ŋutsuvi ɖeka si wona ŋkɔe be Gersom si gɔmee nye “Amedzro,” elabena Mose gblɔ be, “Amedzroe menye le dzronyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Le ƒe aɖewo megbe la, Egipte fia la ku. Israelviwo nɔ konyi fam henɔ hũu ɖem le woƒe kɔkutiwo te le woƒe kluvinyenye ta, eye wonɔ avi fam vevie le Mawu ŋkume. Woƒe avifafa ɖo Mawu gbɔ le dziƒo. ");
INSERT INTO ewe_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Mawu se woƒe konyifafa, eye wòɖo ŋku eƒe ŋugbedodo na Abraham, Isak kple Yakob dzi. ");
INSERT INTO ewe_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Ale Mawu kpɔ Israelviwo ƒe nublanui, eye wòtsɔ ɖe le eme na wo. ");
INSERT INTO ewe_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Gbe ɖeka la, Mose nɔ toa Reuel, ame si wogayɔna be Yetro, ame si nye Midian nunɔla la ƒe alẽwo dzi kpɔm le gbedzi si te ɖe Horeb, Mawu ƒe to la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Tete Yehowa ƒe dɔla aɖe ɖe eɖokui fiae le ŋuve aɖe si nɔ bibim, gake menɔ fiafiam o la me. Esi Mose kpɔ be ŋuve la nɔ bibim, gake menɔ fiafiam o la, ");
INSERT INTO ewe_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mose ɖo ta me be, “Mayi makpɔ nu wɔnuku sia, nu si ta ŋuve la menɔ fiafiam o la ɖa.” ");
INSERT INTO ewe_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Esi Yehowa kpɔ be Mose yi be yeakpɔe ɖa la, Mawu yɔe tso ŋuve bibi la me be, “Mose, Mose!” Eye Mose tɔ be, “Nye nye esi.” ");
INSERT INTO ewe_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Mawu gblɔ nɛ be, “Mègate va afi sia o. Ɖe wò afɔkpawo da ɖi, elabena anyigba kɔkɔe dzie nèle tsitre ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Nyee nye fofowòwo ƒe Mawu, Abraham ƒe Mawu, Isak ƒe Mawu kple Yakob ƒe Mawu.” Mose tsyɔ mo anyi, elabena enɔ vɔvɔ̃m na Mawu kpɔkpɔ. ");
INSERT INTO ewe_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yehowa gblɔ nɛ be, “Mekpɔ nye amewo ƒe fukpekpe le Egipte, mese woƒe avifafa le woƒe dɔnunɔlawo ƒe ŋutasesẽ ta. Metsɔ ɖe le woƒe fukpekpe la me, ");
INSERT INTO ewe_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","eya ta meɖi va be maɖe wo tso Egiptetɔwo ƒe asi me, eye makplɔ wo adzoe le Egiptenyigba dzi, woayi anyigba nyui, gã aɖe dzi, afi si notsi kple anyitsi bɔ ɖo la. Anyigba sia dzie Kanaantɔwo, Hititɔwo, Amoritɔwo, Perizitɔwo, Hivitɔwo kple Yebusitɔwo le fifia. ");
INSERT INTO ewe_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ɛ̃, Israelviwo ƒe konyifaɣliwo ɖi va ɖo gbɔnye le dziƒo. Mekpɔ dɔ sesẽ siwo Egiptetɔwo ɖona na wo hetsɔ tea wo ɖe toe. ");
INSERT INTO ewe_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Fifia mele dɔ wò ge ɖe Farao gbɔ be nàna be wòaɖe asi le nye dukɔ Israelviwo ŋu, eye nàkplɔ wo ado goe le Egipte.” ");
INSERT INTO ewe_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mose gblɔ na Mawu be, “Ame ka menye aɖatsi tsitre ɖe Farao ŋkume, agblɔ nɛ be meva Israelviwo ɖe ge tso Egipte?” ");
INSERT INTO ewe_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Mawu gblɔ nɛ be, “Manɔ anyi kpli wò, eye esia anye dzesi si afia be nyee nye ame si le dɔwòm. Ne èkplɔ Israelviwo do goe le Egiptenyigba dzi la, miasubɔ Mawu le to sia dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ke Mose biae be, “Ne meyi Israelviwo gbɔ, eye megblɔ na wo be, ‘Mia fofowo ƒe Mawue ɖom ɖa’ la, woabia be, ‘Mawu sia ŋkɔ ɖe?’ Ekema nya ka magblɔ na wo?” ");
INSERT INTO ewe_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mawu ɖo eŋu na Mose be, “Menye ame si Menye. Gblɔ na Israelviwo ko be, ‘Menyee dɔm ɖa.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Mawu gblɔ kpe ɖe eŋu na Mose be, “Gblɔ na Israelviwo be, ‘Yehowa, mia fofowo ƒe Mawu, Abraham kple Isak kple Yakob ƒe Mawue dɔm ɖe mia gbɔ.’ “Esiae nye nye ŋkɔ tegbee, ŋkɔ si woayɔ nam tso dzidzime yi dzidzime si ŋu dɔ woawɔ. ");
INSERT INTO ewe_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Mawu yi edzi be, ‘Yɔ Israel ƒe ametsitsiwo katã ƒo ƒu, eye nàƒo nu na wo tso ale si Yehowa, mia fofowo ƒe Mawu, Abraham, Isak kple Yakob ƒe Mawu la ɖe eɖokui fia wò le afi sia gblɔ be, Mekpɔ mi ɖa. Mekpɔ nu si le dzɔdzɔm ɖe mia dzi le Egipte. ");
INSERT INTO ewe_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mele ŋugbe dom be maɖe mi tso miaƒe fukpekpewo me le Egipte, eye makplɔ mi ayi anyigba si dzi Kanaantɔwo, Hititɔwo, Amoritɔwo, Perizitɔwo, Hivitɔwo kple Yebusitɔwo le fifia la dzi, anyigba si dzi anyitsi kple notsi bɔ ɖo.’ ");
INSERT INTO ewe_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Israelviwo ƒe dumegãwo axɔ wò nya la, ekema woakplɔ wò ayi Egipte fia Farao gbɔ, eye nàgblɔ nɛ be, ‘Yehowa, Hebritɔwo ƒe Mawu, va do go mí, eye wòbia tso mía si be míazɔ mɔ ŋkeke etɔ̃ ayi gbedzi aɖasa vɔ na Yehowa, míaƒe Mawu la le afi ma.’ ");
INSERT INTO ewe_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Ke menya be Egipte fia mana mɔ mi be miayi o, negbe ɖeko asi sesẽ aɖe zi edzi hafi. ");
INSERT INTO ewe_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Eya ta mado nye asi ɖa ɖe Egipte ŋu, atsrɔ̃ wo kple nye nukunu siwo mawɔ le wo dome, ekema ana miayi. ");
INSERT INTO ewe_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Makpɔ egbɔ be Egiptetɔwo tsɔ nunanawo na mi gleglegle le miaƒe dzodzoɣi ale be miadzo kple asi gbɔlo o! ");
INSERT INTO ewe_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Nyɔnu ɖe sia ɖe axɔ klosalo, sikanuwo kple avɔ nyuiwo le eƒe amegã, Egiptetɔ, srɔ̃a kple eŋumewo si. Miado Egiptetɔwo ƒe nu nyuitɔwo kekeake na mia viŋutsuwo kple mia vinyɔnuwo! Ale miaha Egiptetɔwo.” ");
INSERT INTO ewe_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ke Mose gblɔ be, “Womaxɔ dzinye ase o! Womawɔ nu si magblɔ na wo be woawɔ o. Woagblɔ be, ‘Yehowa meɖe eɖokui fia wò o!’ ” ");
INSERT INTO ewe_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yehowa biae be, “Nu kae nye ema le asiwò?” Mose ɖo eŋu be, “Alẽkplɔla ƒe atikplɔe.” ");
INSERT INTO ewe_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Yehowa gblɔ nɛ be, “Ɖe asi le eŋu da ɖe anyigba.” Mose ɖe asi le eŋu da ɖe anyigba, eye wòtrɔ zu da; tete Mose si le egbɔ. ");
INSERT INTO ewe_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yehowa gblɔ nɛ be, “Lé eƒe asike!” Mose lé da la ƒe asike, eye wògazu atikplɔ ɖe esi! ");
INSERT INTO ewe_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yehowa gblɔ nɛ be, “Wɔ esia ekema woaxɔ dziwò ase, ekema woadze sii be Yehowa, wo fofowo, Abraham, Isak kple Yakob ƒe Mawue ɖe eɖokui fia wò nyateƒe.” ");
INSERT INTO ewe_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Azɔ Yehowa gblɔ be, “Tsɔ wò asi de wò axatome.” Eye Mose tsɔ eƒe asi de axatome. Esi wòɖe asi ɖa la, eƒe asi dze kpodɔ hefu kpĩi. ");
INSERT INTO ewe_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yehowa gagblɔ nɛ be, “Gatsɔ wò asi de wò axatome.” Esi wògawɔ esia, eye wògaɖe asi ɖa la, dɔvɔ̃ɖi la bu le eŋu; eƒe asi ganɔ abe tsã ene! ");
INSERT INTO ewe_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yehowa gblɔ be, “Ne womexɔ nukunu gbãtɔ dzi se o la, woaxɔ evelia dzi ase. ");
INSERT INTO ewe_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ne womeɖo to wò le dzesi eve siawo megbe o la, ekema ku tsi tso Nil tɔsisi la me kɔ ɖe anyigba ƒuƒui dzi, eye wòatrɔ azu ʋu.” ");
INSERT INTO ewe_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ke Mose ɖe kuku na Yehowa be, “O, nye Aƒetɔ, nyemeƒoa nu nyuie o. Nyemeƒo nu nyuie kpɔ o; nyemenye nuƒola nyui aɖeke fifia hã o, togbɔ be èƒo nu nam gɔ̃ hã, elabena nye aɖe metrɔna ɖe nya ŋu tututu o.” ");
INSERT INTO ewe_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Yehowa biae be, “Ame kae wɔ nuwo na amewo? Menye nye, Yehowae oa? Ame kae wɔ aɖetututɔ alo tokunɔ, alo nukpɔla, alo ŋkuagbãtɔ? Alo menye nye Yehowae oa? ");
INSERT INTO ewe_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Azɔ la, yii, elabena makpe ɖe ŋuwò be nàƒo nu nyuie, eye magblɔ nu si nàgblɔ la na wò.” ");
INSERT INTO ewe_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ke Mose gagblɔ be, “Aƒetɔ, meɖe kuku, ɖo ame bubu aɖe ɖa.” ");
INSERT INTO ewe_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Tete Yehowa do dɔmedzoe ɖe Mose ŋu, eye wògblɔ nɛ be, “Enyo, nɔviwò Aron, Levitɔ la, ƒoa nu nyuie, egbɔna ava di wò le afi sia. Akpɔ dzidzɔ ŋutɔ ne ekpɔ wò, ");
INSERT INTO ewe_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","eya ta magblɔ nu si nàgblɔ nɛ la na wò. Makpe ɖe mi ame evea ŋu be miaƒo nu nyuie, eye magblɔ nu si miagblɔ la na mi. ");
INSERT INTO ewe_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Eyae anɔ tewòƒe, eye wòaƒo nu na ameawo. Wò la, ànɔ nɛ abe Mawu ene, ");
INSERT INTO ewe_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","gake tsɔ wò atikplɔ la ɖe asi ale be nàte ŋu awɔ nukunu siwo mefia wò la kplii.” ");
INSERT INTO ewe_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mose trɔ yi aƒe me; edzro nya la me kple toa, Yetro, hegblɔ nɛ be, “Meɖe kuku, ɖe mɔ nam matrɔ ayi nye ƒometɔwo gbɔ le Egipte ne makpɔe ɖa be wogale agbe mahã?” Yetro ɖo eŋu be, “Yi faa, nye yayrawo le yowòme.” ");
INSERT INTO ewe_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Hafi Mose nadzo le Midian la, Yehowa gblɔ nɛ be, “Trɔ nàyi Egipte, elabena ame siwo katã di be yewoawu wò la, ku xoxo.” ");
INSERT INTO ewe_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ale Mose kplɔ srɔ̃a kple via ŋutsuviwo da ɖe tedzi dzi, eye wòdze mɔ yina ɖe Egipte. Elé “Mawu ƒe atikplɔ” la ɖe asi goŋgoŋgoŋ! ");
INSERT INTO ewe_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yehowa gblɔ nɛ be, “Ne èɖo Egipte la, ele na wò be nàdo ɖe Farao ŋkume, eye nàwɔ nukunu siwo mena ŋusẽ wò be nàwɔ. Ke mana wòasẽ dzi me: maɖe asi le ameawo ŋu be woadzo o. ");
INSERT INTO ewe_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ekema, ele na wò be nàgblɔ na Farao be, ‘Yehowa be, Israel dukɔ lae nye nye ŋutsu ŋgɔgbevi. ");
INSERT INTO ewe_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Meɖoe na wò be nàna wòadzo aɖasubɔm, ke ègbe toɖoɖo. Kpɔ ɖa, mawu wò ŋgɔgbevi.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Esi Mose kple srɔ̃a kpakple wo viwo nɔ mɔa zɔm la, wotsi teƒe aɖe dɔ. Yehowa ɖe eɖokui fia Mose, eye wòdo ŋɔdzi nɛ be yeawui. ");
INSERT INTO ewe_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ke Zipora tsɔ kpe ɖaɖɛ aɖe lã via ƒe aʋanuyi, eye wòtsɔe ka Mose ƒe afɔwo ŋu hegblɔ be, “Nyateƒee, ènye ʋuŋugbetɔsrɔ̃ nam.” ");
INSERT INTO ewe_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Ale Yehowa ɖe asi le eŋu. (Ɣe ma ɣie Zipora gblɔ be, “Ʋuŋugbetɔsrɔ̃,” eye nu si gblɔm wòle lae nye aʋatsotso.) ");
INSERT INTO ewe_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Azɔ la, Yehowa gblɔ na Aron be, “Yi gbedzi ne nàkpe Mose.” Ale Aron zɔ mɔ yi Mawu ƒe to, Horeb gbɔ ɖado go Mose le afi ma, eye wògbugbɔ nu nɛ. ");
INSERT INTO ewe_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mose gblɔ nu siwo Yehowa ɖo na wo be woawɔ kple nya siwo woagblɔ la na Aron. Eƒo nu tso nukunu siwo woawɔ le Farao ŋkume la hã ŋu nɛ. ");
INSERT INTO ewe_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ale Mose kple Aron wotrɔ va Egipte. Wowɔ takpekpe kple Israel ƒe dumegãwo. ");
INSERT INTO ewe_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aron gblɔ nu siwo Yehowa gblɔ na Mose la na wo, eye Mose wɔ nukunuawo wokpɔ. ");
INSERT INTO ewe_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Dumegãwo xɔe se be Yehowae ɖo wo ɖa nyateƒe. Esi wose be Yehowa va kpɔ wo ɖa, kpɔ woƒe nublanuitɔnyenye, eye wòɖo ta me be yeaɖe wo la, wode ta agu, eye wosubɔe. ");
INSERT INTO ewe_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Le takpekpe wɔwɔ kple Israel ƒe dumegãwo vɔ megbe la, Mose kple Aron woyi Farao gbɔ. Wogblɔ nɛ be, “Ale Yehowa, Israel ƒe Mawu la gblɔe nye esi: ‘Ɖe asi le nye amewo ŋu woayi gbedzi aɖaɖu ŋkekenyui nam.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Farao bia be, “Ame kae nye Yehowa be maɖo toe, eye maɖe asi le Israel ŋu? Nyemenya Yehowa o, eye nyemaɖe asi le Israel ŋu o.” ");
INSERT INTO ewe_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mose kple Aron woƒoe ɖe Farao nu be, “Hebritɔwo ƒe Mawu la do go mí, ele be míayi aɖanɔ gbedzi ŋkeke etɔ̃, eye míasa vɔ na Yehowa, míaƒe Mawu la le afi ma. Ne míeɖo to eƒe gbe o la, dɔvɔ̃ awu mí alo míatsi futɔwo ƒe yi nu.” ");
INSERT INTO ewe_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Ke Egipte fia gblɔ be, “Mose kple Aron, nu ka ta miele ameawo ɖem ɖa tso woƒe dɔ gbɔ? Mitrɔ yi miaƒe dɔ gbɔ!” ");
INSERT INTO ewe_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Farao gagblɔ be, “Kpɔ ɖa, amewo sɔ gbɔ le anyigba la dzi, eye miele wo ɖem ɖa le woƒe dɔwo gbɔ.” ");
INSERT INTO ewe_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Gbe ma gbe la, Farao ɖe gbe na dɔdzikpɔla kple dɔnunɔla siwo le ameawo nu be, ");
INSERT INTO ewe_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Migana gbe ƒuƒu Israelviwo azɔ na anyikpeawo meme o; mina woayi aɖadi woawo ŋutɔ ƒe gbe ƒuƒu. ");
INSERT INTO ewe_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ke mina woagame anyikpe xexlẽme si womena tsã la; migaɖe edzi na wo o. Kuviatɔwo wonye, eya ta wole ɣli dom be, ‘Mina míayi aɖasa vɔ na míaƒe Mawu’ ");
INSERT INTO ewe_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Mina woƒe dɔ nagasẽ na wo wu tsã ale be woagayi dɔwɔwɔ dzi. Migaɖo to woƒe alakpanyawo o.” ");
INSERT INTO ewe_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ale dɔdzikpɔlawo kple dɔnunɔlawo yi ɖagblɔ na ameawo be, “Nya si Farao gblɔe nye, ‘Nyemagana gbe ƒuƒu mi azɔ o. ");
INSERT INTO ewe_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Miyi ne miawo ŋutɔ miadi gbe ƒuƒu le afi sia afi si miakpɔe le, ke womaɖe miaƒe dɔ dzi kpɔtɔ le go aɖeke me o.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ale Israelviwo kaka ɖe Egiptenyigba la katã dzi henɔ gbe ƒuƒu dim. ");
INSERT INTO ewe_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Dɔdzikpɔlawo sẽa ŋuta le wo ŋu, woɖea gbe na wo be, “Mime anyikpewo woasɔ gbɔ gbe sia gbe abe tsã ene.” ");
INSERT INTO ewe_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Woƒoa Israelviwo ƒe dɔnunɔla siwo Farao ɖo wo nu, eye wobluna ɖe wo ta be, “Nu ka ta mieme anyikpe xexlẽme si wòle be miame etsɔ alo egbe abe tsã ene o?” ");
INSERT INTO ewe_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ale Israelviwo ƒe dɔnunɔlawo yi Farao gbɔ heƒo koko nɛ be, “Nu ka ŋuti nèle wò dɔlawo wɔm alea? ");
INSERT INTO ewe_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Womeganaa gbe ƒuƒu wò dɔlawo o, ke wobia tso mía si be, ‘Mime anyikpewo!’ Woƒoa wò dɔlawo le esime vodada la tso wò ŋutɔ wò amewo gbɔ, wònye miaƒe dɔdzikpɔlawoe le dɔ manyatanu ɖom na mí.” ");
INSERT INTO ewe_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Farao ɖo eŋu be, “Kuviatɔwo mienye, eya ta miele gbɔgblɔm be, ‘Mina míayi aɖasa vɔ na Yehowa.’ ");
INSERT INTO ewe_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Mitrɔ yi miaƒe dɔwo gbɔ, womana gbe ƒuƒu aɖeke mi o, gake ele be miame anyikpe xexlẽme si miemena gbe sia gbe tsã la kokoko!” ");
INSERT INTO ewe_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israelviwo ƒe dɔnunɔlawo kpɔe be nu sesẽwo ɖi kpe yewo nyateƒe be womaɖe yewoƒe gbe sia gbe kpememe la dzi na yewo o. ");
INSERT INTO ewe_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Mose kple Aron wonɔ wo lalam le fiasã la godo esi me wodzo le Farao gbɔ. Esi wodo go wo la, ");
INSERT INTO ewe_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","wogblɔ na Mose kple Aron be, “Yehowa nadrɔ̃ ʋɔnu mi be miena míeɖi nu ʋeʋĩwo le Farao kple eŋumewo ŋkume, eye be miena mɔnukpɔkpɔ wo be woawu mí.” ");
INSERT INTO ewe_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Tete Mose gatrɔ yi Yehowa gbɔ hegblɔ nɛ be, “O, Yehowa, nu ka ta nèhe fukpekpe sia va ame siawo dzii? Esia tae nèdɔm ɖoa? ");
INSERT INTO ewe_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Tso esime megblɔ wò gbedeasi la na Farao ko la, ɖeko wògale ŋuta sẽm le ameawo ŋu wu tsã; mèɖe wo tso woƒe fukpekpewo me kura o!” ");
INSERT INTO ewe_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yehowa gblɔ na Mose be, “Azɔ la, àkpɔ nu si mawɔ Farao. Le nye alɔ sesẽ la ta, anya wo ado goe, eye le nye asi sesẽ la ta, ado mɔ wo.” ");
INSERT INTO ewe_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mawu gagblɔ na Mose be, “Nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Meɖe ɖokuinye fia Abraham, Isak kple Yakob abe Mawu Ŋusẽkatãtɔ la ene, ke nye ŋkɔ, Yehowa la, nyemeyɔe na wo o. ");
INSERT INTO ewe_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Mewɔ nubabla tɔxɛ aɖe kpli wo. Le nubabla sia ƒe ɖoɖowo nu la, medo ŋugbe be matsɔ Kanaanyigba, afi si wonɔ abe amedzrowo ene la na wo. ");
INSERT INTO ewe_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","“Gawu la, mese Israelviwo ƒe konyifafa esi wonye kluviwo fifia le Egipte. Meɖo ŋku nye nubabla la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Eya ta gblɔ na Israel ƒe dzidzimeviwo be, ‘Nyee nye Yehowa, maɖe mi le Egiptetɔwo ƒe kɔkuti te, mana ablɔɖe mi tso kluvinyenye na wo me, eye maɖe mi kple alɔ sesẽ kple nukunu triakɔwo. ");
INSERT INTO ewe_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Maxɔ mi abe nye amewo ene, manye miaƒe Mawu, mianyae be nyee nye Yehowa, miaƒe Mawu, ame si ɖe mi tso Egiptetɔwo ƒe asi me, ");
INSERT INTO ewe_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","eye makplɔ mi ayi anyigba si mekɔ asi dzi ka atam be matsɔ na Abraham, Isak kple Yakob la dzi. Matsɔe na mi wòazu mia tɔ. Nyee nye Yehowa.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mose gblɔ nya siawo na Israelviwo, ke womeɖo toe o, le woƒe dziɖeleameƒo kple ŋutasesẽ kple kluvimenɔnɔ ta. ");
INSERT INTO ewe_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Yehowa gaƒo nu na Mose, gblɔ nɛ bena, ");
INSERT INTO ewe_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Gayi Farao, Egipte fia gbɔ eye nàgblɔ nɛ be, ele be wòaɖe asi le Israelviwo ŋu woadzo le eƒe anyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Ke Mose ɖe ɖeklemi Yehowa hegblɔ be, “Kpɔ ɖa, ne Israelviwo maɖo tom o la, aleke Farao ya aɖo tom, elabena nyemenye nuƒola nyui hã o.” ");
INSERT INTO ewe_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Tete Yehowa ɖe gbe na Mose kple Aron tso Israelviwo kple Farao, Egipte fia ŋu gblɔ na wo be woakplɔ Israelviwo ado goe tso Egipte. ");
INSERT INTO ewe_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ame siwo nye ƒometatɔ na Israel ƒe to vovovoawoe nye: Ruben, Israel ƒe viŋutsu tsitsitɔ ƒe viwo: Hanok, Palu, Hezron, Karmi. Esiawoe nye Reuben ƒe towo. ");
INSERT INTO ewe_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon ƒe viwoe nye: Yemuel, Yamin, Ohad, Yakin, Zohar, Saul, ame si dada nye Kanaan nyɔnu. Esiawoe nye Simeon ƒe towo. ");
INSERT INTO ewe_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ame siwo nye ƒometatɔ na Levi ƒe ƒome la ƒe ŋkɔwoe nye esiawo le woƒe tsitsi nu. Gerson, Kohat kple Merari. Levi nɔ agbe ƒe alafa ɖeka blaetɔ̃-vɔ-adre (137). ");
INSERT INTO ewe_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gerson ƒe viwoe nye: Libni, Simei kple woƒe hlɔ̃wo. ");
INSERT INTO ewe_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohat ƒe viwo: Amram, Izhar, Hebron kple Uziel. Kohat nɔ agbe ƒe alafa ɖeka blaetɔ̃-vɔ-etɔ̃ (133). ");
INSERT INTO ewe_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari ƒe viwo: Mahli kple Musi. Ame siwo ŋkɔ woyɔ va yi la tso Levi ƒe ƒome me, eye woɖo wo ɖe tsitsi nu. ");
INSERT INTO ewe_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram ɖe Yoxebed, fofoa nɔvinyɔnu; wo viwoe nye Mose kple Aron. Amram nɔ agbe ƒe alafa ɖeka blaetɔ̃-vɔ-adre (137). ");
INSERT INTO ewe_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhar ƒe viwo: Korah, Nefeg kple Zikri. ");
INSERT INTO ewe_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uziel ƒe viwo: Misael, Elzafan kple Sitri. ");
INSERT INTO ewe_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aron ɖe Eliseba, Aminadab ƒe vinyɔnu kple Nahson nɔvinyɔnu. Wo viwoe nye, Nadab, Abihu, Eleaza kple Itamar. ");
INSERT INTO ewe_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korah ƒe viwoe nye: Asir, Elkana kple Abiasaf. Ame siawoe wɔ ƒome siwo tso Korah ƒe hlɔ̃ me. ");
INSERT INTO ewe_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aron ƒe viŋutsu, Eleaza, ɖe Pituel ƒe vinyɔnuwo dometɔ ɖeka, eye Finehas nye viawo dometɔ ɖeka. Esiawoe nye Levitɔwo ƒe ƒomewo ƒe tatɔwo ƒe ŋkɔwo katã kple ƒome siwo nɔ hlɔ̃awo me. ");
INSERT INTO ewe_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aron kple Mose, siwo ƒe ŋkɔwo woyɔ ɖe dzidzimegbalẽ sia me la nye: Aron kple Mose, ame siwo Yehowa gblɔ na be, “Mikplɔ Israelviwo katã dzoe le Egiptenyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Woawoe yi Egipte fia Farao gbɔ be yewoabia mɔ hena Israelviwo kpɔkplɔ dzoe le Egiptenyigba la dzi, wonye Mose kple Aron. ");
INSERT INTO ewe_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Azɔ esi Yehowa ƒo nu na Mose le Egipte la, ");
INSERT INTO ewe_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","egblɔ nɛ be, “Nyee nye Yehowa. Gblɔ nya sia nya si megblɔ na wò la na Egipte fia Farao.” ");
INSERT INTO ewe_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ke Mose gblɔ na Yehowa be, “Aleke Farao aɖo tom esi nyemenya nuƒoƒo o?” ");
INSERT INTO ewe_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yehowa gblɔ na Mose be, “Kpɔ ɖa, mewɔ wò abe Mawu ene na Farao, eye nɔviwò ŋutsu Aron abe wò nyagblɔɖila ene. ");
INSERT INTO ewe_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Gblɔ nu sia nu si ƒe se mede na wò la na Aron. Eya agblɔe na Farao, eye wòabia be Farao naɖe asi le Israelviwo ŋu woadzo le Egipte. ");
INSERT INTO ewe_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ke mana Farao nasẽ dzi me, agbe. Ekema magawɔ dzesi dziŋɔ geɖewo le Egiptenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Ke le esiawo megbe hã la, Farao maɖo to wò o. Ekema mana nye asi nava Egiptetɔwo dzi, mabu fɔ wo kple nukudɔ geɖewo, eye makplɔ nye amehawo, nye dukɔ, Israel, adzoe le Egiptenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ekema Egiptetɔwo adze sii be le nyateƒe me la, nyee nye Yehowa, ne meɖe nye ŋusẽ fia Egiptetɔwo, eye mekplɔ Israelviwo dzoe le wo dome.” ");
INSERT INTO ewe_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mose kple Aron wowɔ nu si Yehowa ɖo na wo. ");
INSERT INTO ewe_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Mose xɔ ƒe blaenyi, eye Aron xɔ ƒe blaenyi-vɔ-etɔ̃ le ɣeyiɣi sia me, esi wodo ɖe Farao ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yehowa gblɔ na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Ne Farao abia be, ‘Miawɔ nukunu aɖe la,’ ekema gblɔ na Aron be, ‘Tsɔ wò atikplɔ la da ɖe anyigba le Farao ŋkume,’ eye wòatrɔ azu da.” ");
INSERT INTO ewe_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ale Mose kple Aron woyi Farao gbɔ, eye wowɔ nukunu la abe ale si Yehowa ɖo na wo ene. Aron ɖe asi le eƒe atikplɔ ŋu da ɖe anyigba le Farao kple eŋumewo ŋkume, eye wòzu da. ");
INSERT INTO ewe_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Tete Farao yɔ eƒe nunyalawo kple afakalawo kple Egipte ƒe akunyawɔlawo. Woawo hã te ŋu wɔ nu ma ke kple woƒe akunyawɔwɔ! ");
INSERT INTO ewe_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Woawo hã ƒe atikplɔwo trɔ zu dawo esi wotsɔ wo da ɖe anyigba. Ke Aron ƒe atikplɔ lé woƒe atikplɔwo mi. ");
INSERT INTO ewe_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Farao gasẽ dzi me kokoko, eye meɖo to wo o, abe ale si Yehowa gblɔ do ŋgɔe ene. ");
INSERT INTO ewe_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yehowa gblɔ na Mose be, “Farao ƒe dzi me sẽ, eye wògbe be yemaɖe asi le ameawo ŋu woadzo o. ");
INSERT INTO ewe_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","“Togbɔ be nuwo anɔ alea hã la, gbugbɔ yi Farao gbɔ le ŋdi me, esime wòanɔ tɔsisi la to yim. Tsi tsitre ɖe tɔsisi la to, eye nàdo goe le afi ma; nàlé wò atikplɔ si zu da la ɖe asi. ");
INSERT INTO ewe_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Gblɔ nɛ be, ‘Yehowa, Hebritɔwo ƒe Mawu la, gaɖom ɖa be mana nàɖe asi le yeƒe amewo ŋu woayi aɖasubɔ ye le gbedzi.’ Gake va se ɖe fifi meɖo tom o. ");
INSERT INTO ewe_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Azɔ la, Yehowa gblɔ be, ‘Èle si dze gee be nyee nye Yehowa, elabena megblɔ na Mose be wòatsɔ eƒe atikplɔ la aƒo Nil tɔsisi la ƒe tsi dzi, eye tɔsisi la atrɔ azu ʋu! ");
INSERT INTO ewe_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Tɔmelãwo aku, eye tsi la aʋẽ ale be Egiptetɔwo magalɔ̃ be yewoanoe o.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Emegbe Yehowa gblɔ na Mose be, “Gblɔ na Aron be, ‘Tsɔ wò atikplɔ do ɖe Egipte tsiwo katã dzi ekema Egipte tɔsisiwo, tɔʋuwo, tawo, tsi si woku da ɖi katã atrɔ zu ʋu! Ʋu anɔ afi sia afi le Egiptenyigba dzi, anɔ tsitɔkpowo kple kpezɔwo gɔ̃ hã me.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mose kple Aron wowɔ nu si Yehowa ɖo na wo be woawɔ. Aron ƒo Nil tɔsisi la kple eƒe atikplɔ la, eye tɔsisi la trɔ zu ʋu le Farao kple eŋumewo katã ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Tɔmelãwo katã ku, tsi la ƒaƒã ale be, Egiptetɔwo megate ŋu noe o. Ʋu xɔ Egiptenyigba ƒe akpa sia akpa dzi. ");
INSERT INTO ewe_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Egiptetɔwo ƒe akunyawɔlawo hã wɔ woƒe nunya ɣaɣlawo ŋu dɔ, eye woawo hã wotrɔ tsi wòzu ʋu. Nu sia na Farao ƒe dzi me gasẽ kokoko. Meɖo to Mose kple Aron o, abe ale si Yehowa gblɔe do ŋgɔ ene tututu. ");
INSERT INTO ewe_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Mose kple Aron ƒe wɔnawo mewɔ dɔ aɖeke ɖe edzi o; etrɔ yi eƒe fiasã me. ");
INSERT INTO ewe_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Egiptetɔwo ɖe vudowo ɖe tɔsisi la to be yewoakpɔ tsi nono, elabena womate ŋu ano tɔsisi la me tsi o. ");
INSERT INTO ewe_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nil tɔsisi la trɔ zu ʋu ŋkeke adre sɔŋ esi Yehowa gblẽe. ");
INSERT INTO ewe_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Yehowa gblɔ na Mose be, “Gayi Farao gbɔ, eye nàgblɔ nɛ be, ‘Ale Yehowa gblɔe nye si. Ɖe asi le nye amewo ŋu woayi aɖasubɔm. ");
INSERT INTO ewe_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ne ègbe la, maɖo akpɔkplɔwo ƒe hatsotso gãwo ɖa woava xɔ wò anyigba la dzi tso liƒo ɖeka dzi yi bubu dzi. ");
INSERT INTO ewe_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Akpɔkplɔwo asɔ gbɔ ɖe Nil tɔsisi la me. Woava ge ɖe wò fiasã la me, age ɖe wò xɔdɔme me, woage ɖe wò abati dzi, woage ɖe wò dumegãwo ƒe aƒewo me, eye woage ɖe abolokpowo kple amɔzewo me. ");
INSERT INTO ewe_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Akpɔkplɔawo ata le wò ŋutɔ, wò amewo kple ŋuwòmewo katã dzi.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Yehowa gblɔ na Mose be, “Gblɔ na Aron be wòado eƒe atikplɔ ɖe tɔsisiwo, tɔʋuwo kple tawo katã dzi le Egipte.” ");
INSERT INTO ewe_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aron wɔ nu sia, eye akpɔkplɔwo xɔ anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ke akunyawɔlawo hã tsɔ woƒe ayemenuwɔwɔwo wɔ nenema, eye woawo hã na akpɔkplɔwo do ɖe anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Tete Farao yɔ Mose kple Aron, heƒo koko na wo be, “Miɖe kuku na Yehowa be wòaɖe akpɔkplɔawo ɖa, ekema maɖe asi le ameawo ŋu woayi aɖasa vɔ nɛ.” ");
INSERT INTO ewe_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose gblɔ be, “Ve nunye, eye nàgblɔ ɣeyiɣi si nàna woayi la nam ekema mado gbe ɖa be akpɔkplɔawo naku le ɣeyiɣi si dzi tututu nàtɔ asii la dzi. Akpɔkplɔawo aku le afi sia afi negbe le tɔsisi la me ko.” ");
INSERT INTO ewe_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Farao ɖo eŋu nɛ be, “Wɔe etsɔ si gbɔna.” Mose yi edzi be, “Enyo, ava eme abe ale si nègblɔ ene, ekema ànya be, ame aɖeke mede Yehowa, mía Mawu la nu o. ");
INSERT INTO ewe_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Akpɔkplɔawo katã atsrɔ̃ negbe esiwo le tɔsisi la me ko.” ");
INSERT INTO ewe_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ale Mose kple Aron wodzo le Farao gbɔ. Mose ɖe kuku na Yehowa le akpɔkplɔ siwo wòɖo ɖa la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Yehowa wɔ ɖe ŋugbe si Mose do na Farao la dzi. Akpɔkplɔ kukuwo yɔ duwo godo kple aƒewo me siaa. ");
INSERT INTO ewe_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Woli kɔ wo gleglegle, eye wohe ʋeʋẽ sẽŋu aɖe va anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ke esi Farao kpɔ be woɖe akpɔkplɔawo ɖa ko la, egasẽ dzi me, eye wògbe asiɖeɖe le ameawo ŋu abe ale si Yehowa gblɔe do ŋgɔ ene. ");
INSERT INTO ewe_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yehowa gblɔ na Mose be, “Gblɔ na Aron be, ‘Tsɔ wò atikplɔ ƒo anyigba, eye ke siwo katã le Egiptenyigba dzi la atrɔ azu muwo.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Mose kple Aron wowɔ nu si Mawu ɖo na wo la. Tete muwo xɔ Egiptenyigba blibo la dzi enumake, eye woƒo kɔ ɖe amewo kple woƒe lãwo katã dzi. ");
INSERT INTO ewe_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Akunyawɔlawo dze agbagba be yewo hã yewoawɔ nu ma ke kple woƒe nunya ɣaɣlawo, gake azɔ ya la, womete ŋui o, eye muawo ɖu amewo kple lãwo siaa. ");
INSERT INTO ewe_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Akunyawɔlawo gblɔ na Farao be, “Esia nye Mawu ƒe asinudɔ.” Ke Farao gasẽ dzi me kokoko: meɖo to wo o, abe ale si Yehowa gblɔe do ŋgɔ ene. ");
INSERT INTO ewe_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Le esia megbe la, Yehowa gblɔ na Mose be, “Fɔ etsɔ ŋdi kanya, nàdo go Farao esime wòyina tsi le ge le tɔsisi la me. Gblɔ nɛ be, ‘Ale Yehowa gblɔe nye esi: ɖe asi le nye amewo ŋu woayi aɖasubɔm. ");
INSERT INTO ewe_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ne ègbe la, maɖo togbatowo ƒe ha gã aɖe ɖa woava Egiptenyigba blibo la dzi, axɔ wò kple wò dumegãwo kple wò amewo ƒe aƒewo me. Ale Egiptetɔwo ƒe aƒewo me ayɔ fũu kple togbatowo, eye woayɔ anyigba la ƒe afi sia afi. ");
INSERT INTO ewe_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Gake gbe ma gbe la, mana nuwo nato vovo le Gosenyigba dzi, afi si nye amewo le. Togbatowo ƒe ha manɔ afi ma ya o. Ale nànyae be nye Yehowa mele anyigba sia dzi, ");
INSERT INTO ewe_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","elabena made vovototo wò amewo kple nye amewo dome. Dzesidede siawo katã ava eme etsɔ.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Yehowa wɔ abe ale si wògblɔ ene. Togbatowo ƒe ha gã aɖe nye zi ge ɖe Farao ƒe fiasã la me kple eƒe dumegãwo ƒe aƒewo me, eye togbatoawo gblẽ nu le Egiptenyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Farao yɔ Mose kple Aron enumake hegblɔ na wo be, “Enyo; miyi miasa vɔ na miaƒe Mawu la, gake misa vɔ la le afii, le anyigba sia dzi, migayi gbedzi o.” ");
INSERT INTO ewe_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ke Mose ɖo eŋu be, “Eya masɔ o! Egiptetɔwo lé fu míaƒe vɔsawo. Ne míasa vɔ na Yehowa míaƒe Mawu le woƒe ŋkuta la, woawu mí. ");
INSERT INTO ewe_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ele be míayi aɖanɔ gbedzi ŋkeke etɔ̃, asa vɔ na Yehowa, míaƒe Mawu la le afi ma, abe ale si wòɖo na mí ene.” ");
INSERT INTO ewe_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Farao ɖo eŋu be, “Enyo, maɖe mɔ na mi be miayi aɖasa vɔ na Yehowa, miaƒe Mawu la, gake migayi didiƒe sãa o. Azɔ la, miɖe abla miaɖe kuku na miaƒe Mawu la ɖe tanye.” ");
INSERT INTO ewe_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose lɔ̃ ɖe edzi hegblɔ be, “Ne medzo le gbɔwò la, mabia Yehowa be wòana togbatoawo katã nabu. Ke mele nya gbem na wò be mègable mí azɔ, ado ŋugbe na mí be yeaɖe asi le ameawo ŋu, eye emegbe nàgatrɔ susu o.” ");
INSERT INTO ewe_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mose dzo le Farao gbɔ, eye wòɖe kuku na Yehowa be wòaɖe togbatoawo ɖa. ");
INSERT INTO ewe_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Eye Yehowa wɔ nu si Mose bia. Togbatoawo dzo le Farao kple eŋumewo kple eƒe amewo gbɔ; wo dometɔ ɖeka pɛ gɔ̃ hã meganɔ anyi o. ");
INSERT INTO ewe_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ke fifia gɔ̃ hã la, Farao gasẽ dzi me, eye melɔ̃ be yeaɖe asi le ameawo ŋu woadzo o. ");
INSERT INTO ewe_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Yehowa gblɔ na Mose be, “Trɔ nàyi Farao gbɔ, eye nàgblɔ nɛ be, ‘Yehowa, Hebritɔwo ƒe Mawu la be nàɖe asi le yeƒe amewo ŋu woayi aɖasubɔ ye. ");
INSERT INTO ewe_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ne miegbe asiɖeɖe le wo ŋu, eye miezi wo dzi la, ");
INSERT INTO ewe_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ekema Yehowa ƒe asi ahe dɔvɔ̃ dziŋɔ aɖe ava miaƒe lãha siwo le gbedzi la dzi, ava miaƒe sɔwo, tedziwo, kposɔwo, nyiwo kple alẽwo kple gbɔ̃wo siaa dzi. ");
INSERT INTO ewe_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Gake Yehowa ade vovo Israelviwo kple Egiptetɔwo ƒe lãhawo dome, ale be Israelviwo ƒe lã aɖeke maku o.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yehowa ɖo ɣeyiɣi, eye wògblɔ be, “Etsɔ si gbɔna la, Yehowa awɔ nu sia le anyigba sia dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Eye Yehowa na wòva eme. Esi ŋu ke ŋdi la, Egiptetɔwo ƒe lãwo katã de asi kuku me, ke Israelviwo tɔwo dometɔ ɖeka pɛ gɔ̃ hã meku o. ");
INSERT INTO ewe_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Farao dɔ ame ɖa be woakpɔe be Israelviwo ƒe lãwo ya tsi agbe mahã. Togbɔ be woɖi ɖase nɛ be nyateƒee hã la, metrɔ eƒe tameɖoɖo la o. Egagbe asiɖeɖe le ameawo ŋu kokoko! ");
INSERT INTO ewe_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yehowa gblɔ na Mose kple Aron be, “Milɔ dzowɔ asiʋlo aɖewo tso kpo me, eye Mose nawui ɖe yame le Farao ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Dzowɔ la akaka abe ʋuʋudedi ene ɖe Egiptenyigba blibo la dzi, eye wòana ƒoƒoe nate amewo kple lãwo siaa le anyigba blibo la dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ale woɖe dzowɔ tso kpo me, eye woyi Farao gbɔ. Esi Farao nɔ wo kpɔm la, Mose wu dzowɔ la ɖe yame, eye wòzu ƒoƒoe te amewo kple lãwo siaa le anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Akunyawɔlawo mete ŋu tɔ ɖe Mose ŋkume o, le ƒoƒoeawo ta, elabena ƒoƒoeawo te Egiptetɔwo katã. ");
INSERT INTO ewe_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ke Yehowa gana Farao ƒe dzi me gasẽ kokoko, ale wògagbe nusese abe ale si Yehowa gblɔe na Mose da ɖi ene. ");
INSERT INTO ewe_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Azɔ la, Yehowa gblɔ na Mose be, “Fɔ ŋdi kanya, nàdo ɖe Farao ŋkume, eye nàgblɔ nɛ be, ‘Ale Yehowa, Hebritɔwo ƒe Mawu la gblɔe nye si, Ɖe asi le nye amewo ŋu woayi aɖasubɔm. ");
INSERT INTO ewe_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ne menye nenema o la, fifia ya la, maɖo nye dɔvɔ̃ ɖe mia dome kple ŋusẽ blibo, wòagblẽ nu le wò ŋutɔ, wò dumegãwo kple wò amewo ŋuti ale be mianyae be ame aɖeke megale anyigba blibo la dzi abe nye ene o. ");
INSERT INTO ewe_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Anye ne le ɣeyiɣi sia me la, medo nye asi ɖa, gblẽ nu le wò kple wò amewo ŋu kple dɔvɔ̃ aɖe si ate ŋu atsrɔ̃ mi katã ɖa le anyigba la dzi hafi. ");
INSERT INTO ewe_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Gake meɖe miaƒe agbe le susu sia ta be maɖe nye ŋusẽ afia mi, eye woaɖe gbeƒã nye ŋkɔ le anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ke ègatsi tsitre ɖe nye ameawo ŋu kokoko, eye nègbe be yemaɖe asi le wo ŋu woadzo o, ");
INSERT INTO ewe_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","eya ta le etsɔ ɣeyiɣi sia tututu la, maɖo kpetsi vɔ̃ɖitɔ ɖa wòadza ɖe dukɔ blibo la dzi. Kpetsi sia tɔgbi medza kpɔ tso esime woɖo Egipte gɔme anyi o. ");
INSERT INTO ewe_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ɖe gbe na ameawo azɔ be, woakplɔ wò lãhawo kple nu siwo katã le asiwò le gbedzi la ava de kpo me, elabena kpetsi la adza ɖe amewo kple lã siwo womekplɔ va aƒe me o la siaa dzi, eye wo katã woaku.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Yehowa ƒe nya siawo do ŋɔdzi na Egiptetɔ aɖewo ale gbegbe be wokplɔ woƒe lãwo kple kluviwo de xɔ me. ");
INSERT INTO ewe_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ke ame siwo mebu Yehowa ƒe nya nanekee o la gblẽ woƒe lãwo ɖe gbedzi. ");
INSERT INTO ewe_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Yehowa gagblɔ na Mose be, “Fia asi dziƒo, eye nàna kpetsi la nadza le Egiptenyigba blibo la dzi, ɖe amewo, atiwo kple lãwo siaa dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Ale Mose do asi ɖe dzi, eye Yehowa ɖo dziɖegbe kple kpetsi kple dzikedzo ɖa. ");
INSERT INTO ewe_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Nu sia dzi ŋɔ wu gbɔgblɔ, kpetsi sia tɔgbi medza kpɔ le Egiptenyigba blibo la dzi esi wòzu dukɔ o. ");
INSERT INTO ewe_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Nu geɖewo gblẽ le Egipte. Nu sia nu si tsi gbedzi, amewo kple lãwo siaa woku; atiwo ta ŋe, eye agblemenuwo katã gblẽ. ");
INSERT INTO ewe_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Teƒe ɖeka pɛ si ko dzi kpetsi la medza ɖo o, le Egiptenyigba blibo la dzie nye Gosen, afi si Israelviwo nɔ. ");
INSERT INTO ewe_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Farao ɖo du ɖe Mose kple Aron, eye wòʋu eme na wo be, “Medze si nye vodada azɔ, Yehowa tɔ dzɔ. Nye kple nye amewo míeda vo tso gɔmedzedzea va se ɖe fifia. ");
INSERT INTO ewe_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Miɖe kuku na Yehowa be, wòatsi dziɖegbe kple kpetsi dziŋɔ sia nu, ekema mana miadzo enumake.” ");
INSERT INTO ewe_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose ɖo eŋu be, “Enyo, ne medo le dua me teti ko la, make nye abɔwo me do ɖe Yehowa gbɔ, ekema dziɖegbe la kple kpetsi la nu atso. Esia afia wò be Yehowae le xexea me dzi ɖum. ");
INSERT INTO ewe_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ke le wò ŋutɔ kple ŋuwòmewo gome la, menya be fifia gɔ̃ hã la, mieɖoa to Yehowa Mawu o.” ");
INSERT INTO ewe_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Kpetsi la gblẽ ɖetifu kple lu o, elabena lu la ɖi, eye ɖetifu la hã ƒo se xoxo hafi, ");
INSERT INTO ewe_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ke lu kple bli ya megblẽ o, elabena woawo metse haɖe o.) ");
INSERT INTO ewe_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Ale Mose dzo le Farao gbɔ. Esi wòdo go le dua me la, edo eƒe asiwo ɖe dziƒo na Yehowa. Dziɖegbe kple kpetsi la nu tso, eye tsi hã dzudzɔ dzadza. ");
INSERT INTO ewe_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Esi Farao kpɔ be tsidzadza, kpetsi kple dziɖegbe la tɔ la, egawɔ nu vɔ̃; eya kple eƒe dumegãwo sẽ woƒe dzi me. ");
INSERT INTO ewe_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ale Farao ƒe dzi me gasẽ, eye wògbe asiɖeɖe le Israelviwo ŋu abe ale si Yehowa gblɔe to Mose dzi ene. ");
INSERT INTO ewe_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Le esia megbe la, Yehowa gblɔ na Mose be, “Gayi Farao gbɔ, eye nàgatsɔ wò biabia la ɖo eŋkume. Ke mana eya kple eƒe aɖaŋudelawo ƒe dzi me nagasẽ kokoko ale be mate ŋu awɔ nukunu bubuwo, eye maɖe nye ŋusẽ afia. ");
INSERT INTO ewe_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Esiawo anye ŋutinya siwo nàgblɔ na viwòwo kple wò tɔgbuiyɔviwo tso nukunu siwo mele wɔwɔm le Egipte la ŋu! Miƒo nu na wo tso ale si mewɔ Egiptetɔwo wozu abunɛtɔwo kple ale si meɖee fia mi bena nyee nye Yehowa la ŋuti.” ");
INSERT INTO ewe_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ale Mose kple Aron wogayi Farao gbɔ, eye wogblɔ nɛ be, “Yehowa, Hebritɔwo ƒe Mawu la le biabiam be, ‘Zi neni nàgbe toɖoɖom? Ɖe asi le nye amewo ŋu ale be woate ŋu ayi aɖasubɔm. ");
INSERT INTO ewe_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ne ègbe asiɖeɖe le ameawo ŋu la, mahe ʋetsuviwo va wò anyigba la dzi etsɔ. ");
INSERT INTO ewe_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Woatsyɔ anyigba la dzi ale gbegbe be anyigba la magadze o. Woaɖu numiemie sue siwo susɔ le kpetsi la megbe kple ati ɖe sia ɖe si le tsitsim le agble dzi. ");
INSERT INTO ewe_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Woayɔ wò aƒewo me, wò dumegãwo ƒe aƒewo me kple Egiptetɔwo katã ƒe aƒewo me, nu si mia fofowo loo alo mia tɔgbuiwo mekpɔ kpɔ, tso gbe si gbe wova anyigba sia dzi va se ɖe fifia o.’ ” Ale Mose trɔ dzo le Farao ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Farao ƒe aɖaŋudelawo va Farao gbɔ azɔ, eye wobiae be, “Ɖe nèdi be yeatsrɔ̃ mí gbidigbidia? Ɖe mènya be fifia gɔ̃ hã la, nu sia nu gblẽ le Egipte oa? Ɖe asi le ameawo ŋu woayi aɖasubɔ Yehowa, woƒe Mawu la.” ");
INSERT INTO ewe_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Wokplɔ Mose kple Aron va Fia Farao gbɔ. Farao gblɔ na wo azɔ be, “Enyo, miyi miasubɔ Yehowa, miaƒe Mawu la. Ke ame kawoe miedi be woayi kpli mi?” ");
INSERT INTO ewe_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose ɖo eŋu be, “Míayi kple mía viŋutsuwo, mía vinyɔnuwo kple míaƒe lãwo, elabena ŋkekenyui ɖu ge míeyina na Yehowa.” ");
INSERT INTO ewe_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Farao yi edzi be, “Yehowa naɖi na mi, nyemaɖe asi le mia kple mia viwo ŋu miayi o. Eme kɔ ƒãa be nu gbegblẽ aɖee mieɖo ɖe ta me. ");
INSERT INTO ewe_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Mi ŋutsuwo ɖeɖe ko, miyi miasubɔ Yehowa, elabena eyae nye nu si miebia.” Ale wonya wo ɖa le Farao ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Yehowa gblɔ na Mose be, “Keke wò asiwo ɖe Egiptenyigba la dzi, ne ʋetsuviwo nado, woaxɔ anyigba blibo la dzi, eye woaɖu nu sia nu si kpetsi la gblẽ ɖi.” ");
INSERT INTO ewe_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mose do eƒe atikplɔ ɖe dzi, eye Yehowa na ɣedzeƒeya aɖe ƒo le ŋkeke kple zã blibo la me. Esi ŋu ke la, ɣedzeƒeya la he ʋetsuviwo vɛ. ");
INSERT INTO ewe_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ʋetsuviawo xɔ anyigba la dzi tso liƒo dzi yi liƒo dzi. Esiae nye ʋetsuviwo ƒe vava vɔ̃ɖitɔ le Egipte ƒe ŋutinya blibo la me, eye etɔgbi magava akpɔ o, ");
INSERT INTO ewe_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","elabena ʋetsuviawo xe anyigba la ƒe ŋkume, eye woxe ɣe hã ƒe ŋkume; ale viviti do ɖe anyigba la dzi. Gawu la, woɖu ati kple gbe ɖe sia ɖe si kpetsi la gblẽ ɖi, ale be nu mumu si nye ati alo gbe la ƒe ɖeke kura meganɔ Egiptenyigba blibo la dzi o. ");
INSERT INTO ewe_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Farao ɖo du sesẽ aɖe ɖe Mose kple Aron enumake, eye wògblɔ na wo be, “Mewɔ nu vɔ̃ ɖe Yehowa, miaƒe Mawu kple miawo ŋutɔ hã ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Migatsɔ nye nu vɔ̃ kem zi mamlɛtɔ sia ko, eye miaɖe kuku na Yehowa, miaƒe Mawu la be wòaɖe fukpekpe vɔ̃ɖi sia ɖa le dzinye.” ");
INSERT INTO ewe_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Le esia ta Mose dzo le Farao gbɔ, eye wòɖe kuku na Yehowa, ");
INSERT INTO ewe_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","eye Yehowa ɖo ɣetoɖoƒeya sesẽ aɖe ɖa, eye wòkplɔ ʋetsuviawo katã yi ɖakɔ ɖe Ƒu Dzĩ la me. Ʋetsuvi ɖeka pɛ gɔ̃ hã megasusɔ ɖe Egiptenyigba dzi o! ");
INSERT INTO ewe_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ke Yehowa gana Farao ƒe dzi me gasẽ kokoko, eye meɖe asi le Israelviwo ŋu o. ");
INSERT INTO ewe_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yehowa gblɔ na Mose be, “Do wò asi ɖe dziƒo ekema viviti tsiɖitsiɖi ado ɖe Egiptenyigba la dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mose wɔ alea, eye blukɔ tsiɖitsiɖi aɖe do ɖe Egiptenyigba blibo la dzi ŋkeke etɔ̃. ");
INSERT INTO ewe_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Le ɣeyiɣi siawo katã me la, Egiptetɔwo megatea ŋu ʋãna o, le esime kekeli nɔ Israelviwo gbɔ abe tsã ene. ");
INSERT INTO ewe_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Farao yɔ Mose, eye wògblɔ nɛ be, “Miyi miasubɔ Yehowa, gake miagblẽ miaƒe lãwo ɖe afi sia. Miate ŋu akplɔ mia viwo gɔ̃ hã ayii.” ");
INSERT INTO ewe_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mose ɖo eŋu be, “Kpao, ele be míakplɔ míaƒe lãwo hã ayi hena vɔsa kple numevɔsa na Yehowa, míaƒe Mawu la. ");
INSERT INTO ewe_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Míagblẽ lã aɖeke ɖi o, eye lã aɖeke ƒe afɔkli gɔ̃ hã matsi anyi o, elabena ele be míasa vɔ na Yehowa, míaƒe Mawu la, eye míate ŋu anya lã siwo wòatia o, va se ɖe esime míaɖo afi ma.” ");
INSERT INTO ewe_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ale Yehowa gana Farao ƒe dzi me gasẽ, eye meɖe asi le ameawo ŋu o. ");
INSERT INTO ewe_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Farao blu ɖe Mose ta be, “Bu le afi sia kaba! Mègana makpɔ wò mo azɔ gbeɖegbeɖe o. Gbe si gbe nàgado ɖe nye ŋkume la, ku kee nàku.” ");
INSERT INTO ewe_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose ɖo eŋu be, “Enyo; mesee. Nyemagado ɖe wò ŋkume azɔ o.” ");
INSERT INTO ewe_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Yehowa gblɔ na Mose be, “Magaɖo fuwɔame ɖeka pɛ ko ɖe Farao kple eƒe anyigba la dzi. Le esia megbe la, Farao aɖe asi le mia ŋu miadzo. Le nyateƒe me la, atsi dzi be miadzo ale gbegbe be wòanya mi le eƒe anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Gblɔ na Israel ŋutsuwo kple nyɔnuwo be woadzra ɖo hena sikanuwo kple klosalonuwo ɣeɣe le wo xɔlɔ̃ siwo nye Egiptetɔwo la si.” ");
INSERT INTO ewe_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Elabena Yehowa na Egiptetɔwo lɔ̃ Israelviwo, eye Mose nye amegã aɖe le Egiptenyigba dzi; Farao ŋumewo kple Egiptetɔ bubuawo siaa bunɛ. ");
INSERT INTO ewe_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Azɔ la, Mose na nyanya Farao be, “Yehowa be, ‘Mato Egiptenyigba la katã dzi le zãtitina. ");
INSERT INTO ewe_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ŋutsuvi tsitsiwo katã aku le ƒome ɖe sia ɖe me le Egipte, tso Farao ƒe viŋutsu tsitsitɔ, ame si aɖu fia ɖe eteƒe la dzi va se ɖe eƒe kluvi gblɔetɔ kekeake ƒe viŋutsu tsitsitɔ dzi. Gawu la, lãwo gɔ̃ hã ƒe ŋgɔgbeviwo hã aku. ");
INSERT INTO ewe_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Konyifaɣli aɖi to Egiptenyigba blibo la dzi. Konyifafa sia tɔgbi menɔ anyi kpɔ o, eye etɔgbi magadzɔ akpɔ o. ");
INSERT INTO ewe_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","“ ‘Ke avu aɖeke mawó gɔ̃ hã ɖe Israelviwo dometɔ aɖeke ŋu o, eye woƒe lã aɖeke hã maku o.’ Ekema mianya be Yehowa de vovototo Egiptetɔwo kple Israelviwo dome! ");
INSERT INTO ewe_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Wò aɖaŋudela siawo katã aƒu du ava tum, woade ta agu, eye woaƒo koko be, ‘Míeɖe kuku, midzo enumake, eye mikplɔ miaƒe amewo katã dzoe.’ Nya sia koe adzɔ hafi madzo!” Mose do dɔmedzoe, eye wòdzo le fiasã la me. ");
INSERT INTO ewe_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yehowa gblɔ na Mose do ŋgɔ be, “Farao maɖo to wò o. Nu sia ana mɔnukpɔkpɔm be mawɔ nukunu gãwo atsɔ aɖe nye ŋusẽ afia le Egipte.” ");
INSERT INTO ewe_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ale togbɔ be Mose kple Aron wowɔ nukunu siawo le Farao ŋutɔ ƒe ŋkuta gɔ̃ hã la, Yehowa gana Farao gasẽ dzi me kokoko, ale be mena Israelviwo dzo le anyigba la dzi o. ");
INSERT INTO ewe_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Yehowa gblɔ na Mose kple Aron le Egipte be, ");
INSERT INTO ewe_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Tso azɔ dzi yina la, ɣleti siae anye gbãtɔ kple ɣleti vevitɔ wu na mi le ƒea me. ");
INSERT INTO ewe_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Miɖe gbeƒã na Israelviwo katã be le ɣleti sia ƒe ŋkeke ewolia dzi la, ŋutsu ɖe sia ɖe nalé alẽvi ɖeka na eƒe ƒome, alẽ ɖeka ɖe aƒekɔ ɖeka ɖe sia ɖe nu. ");
INSERT INTO ewe_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ne aƒekɔ aɖe le sue akpa na alẽvi blibo ɖeka ɖuɖu la, woama alẽvi la kple woƒe aƒelika si te ɖe wo ŋu wu le woƒe agbɔsɔsɔ nu. Ele be miabu alẽvi siwo ŋu dɔ woawɔ la ŋu le ameawo ƒe agbɔsɔsɔ nu, ɖe nu si ame sia ame aɖu la nu. ");
INSERT INTO ewe_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Alẽ alo gbɔ̃ sia anye atsu si xɔ ƒe ɖeka, eye naneke megblẽ le eƒe akpa aɖeke ŋu o. ");
INSERT INTO ewe_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Miakpɔ wo dzi va se ɖe ɣleti sia ƒe ŋkeke wuienelia dzi, esi Israelviwo katã awu woƒe lãwo le fiẽ me, ");
INSERT INTO ewe_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","woatsɔ woƒe ʋu asi na woƒe ʋɔtrua ƒe axadziti eveawo kple ʋɔtrua ƒe tameti le aƒe ɖe sia ɖe si me woaɖu alẽviawo le. ");
INSERT INTO ewe_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Le zã ma ke me la, woame lã la aɖu kple amagbe veve kple abolo maʋamaʋã. ");
INSERT INTO ewe_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Migaɖui mumu alo aɖae hafi aɖu o, ke boŋ mimee dɔnogoe, ta kple afɔwo siaa. ");
INSERT INTO ewe_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Migagblẽ lã la ƒe ɖeke ɖi ŋu nake ɖe edzi o. Ne miete ŋu ɖu wo katã gbe ma gbe ƒe fiẽ o la, ele be miatɔ dzo esi susɔ. ");
INSERT INTO ewe_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ale si mianɔ hafi aɖui nye esi: mido miaƒe awuwo, miabla wo dzi kple alidziblaka. Mido miaƒe atokotawo ɖe afɔ, eye mialé miaƒe atizɔtiwo ɖe asi. Miɖui abe sisilawo ene, elabena Yehowa ƒe Ŋutitotoŋkeke wònye. ");
INSERT INTO ewe_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Elabena mato Egiptenyigba la dzi le zã sia me, eye mawu ŋgɔgbevi ɖe sia ɖe, amewo kple lãwo tɔwo siaa. Madrɔ̃ ʋɔnu Egipte mawuwo katã, elabena nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ʋu si miesi ɖe ʋɔtrutiwo ŋu la anye dzesi be mieɖoa tom. Ne mekpɔ ʋua la, mato mia ŋuti. Nyemawu viŋutsu gbãtɔwo ne meyina Egiptetɔwo tɔwo wu ge o. ");
INSERT INTO ewe_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Ele be miaɖu ŋkekenyui sia na Yehowa ƒe sia ƒe be wòaɖo ŋku zã si me Egiptetɔwo ƒe ŋutsuvi gbãtɔwo ku la dzi. Esia zu se si me woalé ɖe asi tegbetegbe. ");
INSERT INTO ewe_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Miaɖu ŋkekenyui sia ŋkeke adre. Le ŋkeke adreawo katã me la, ele be miaɖu abolo si wowɔ kple amɔ maʋamaʋã ko. Woaɖe ame sia ame si agbe se sia dzi wɔwɔ le ŋkeke adreawo dometɔ ɖeka pɛ gɔ̃ hã me la le Israelviwo ƒe hame. ");
INSERT INTO ewe_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Le ŋkekenyui sia ƒe ŋkeke gbãtɔ kple mamlɛtɔ dzi la, ameha la katã ade takpekpe kɔkɔe aɖe. Womawɔ dɔ aɖeke le ŋkeke siawo dzi o, negbe nuɖaɖa ko. ");
INSERT INTO ewe_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“ ‘Abolo Maʋamaʋã Ŋkekenyui’ sia ɖuɖu ƒe sia ƒe ana miaɖo ŋku ŋkeke sia dzi abe gbe si gbe meɖe mi tso Egiptenyigba dzi ene, eya ta ezu se mavɔ be miaɖu ŋkekenyui sia ƒe sia ƒe, tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Abolo si wowɔ kple amɔ maʋamaʋã la ko woaɖu tso ɣleti la ƒe ŋkeke wuienelia ƒe fiẽ va se ɖe ŋkeke blaeve-vɔ-ɖekɛlia ƒe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Mele be amɔʋãtike aɖeke nanɔ miaƒe aƒewo me le ŋkeke adre siawo me o. Woaɖe ame sia ame si aɖu nu si wowɔ kple amɔ ʋaʋã le ɣeyiɣi sia me la le Israelviwo ƒe hame. Ele be amedzro siwo le mia dome kple dzɔleaƒeawo siaa nalé se sia me ɖe asi. ");
INSERT INTO ewe_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Megale egblɔm be, le ŋkeke adre mawo me la, mele be miaɖu nu si wowɔ kple amɔ ʋaʋã la ƒe ɖeke o: miɖu nu si wowɔ kple amɔ maʋamaʋã la ko le afi sia afi si mianɔ.” ");
INSERT INTO ewe_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ale Mose yɔ Israelviwo ƒe ametsitsiwo ƒo ƒu, eye wògblɔ na wo be, “Miyi mialé alẽwo tso miaƒe alẽhawo dome. Aƒekɔ ɖeka nalé alẽ ɖeka; aƒekɔ sue eve nalé alẽ ɖeka. Esia aku ɖe ame siwo le aƒeawo me ƒe agbɔsɔsɔ ŋu. Miwu Ŋutitotolẽvi la. ");
INSERT INTO ewe_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Mitsyɔ alẽvi la ƒe ʋu ɖe gagbɛ aɖe me. Minyrɔ kakle ɖe ʋu la me, eye miatsɔe asisi ʋu la ɖe ʋɔtruti la tame kple eƒe axawo dzi, ale be ʋu nanɔ ʋɔtrutiawo ŋu. Mia dometɔ aɖeke mado go le xɔ me le zã ma me o. ");
INSERT INTO ewe_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","“Elabena Yehowa ato anyigba la dzi, eye wòawu Egiptetɔwo. Ke ne ekpɔ ʋu le ʋɔtruti la tametɔ kple eƒe axadzitɔwo ŋu la, ato ʋɔtru la ŋu, eye maɖe mɔ na nugblẽla wòage ɖe eme awu miaƒe ŋutsuvi gbãtɔwo o. ");
INSERT INTO ewe_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Miɖo ŋku edzi be esia nye se si anɔ anyi tegbetegbe na miawo ŋutɔwo kple miaƒe dzidzimeviwo. ");
INSERT INTO ewe_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ne mieva ɖo anyigba si Yehowa ana mi dzi abe ale si wòdo ŋugbee na mi ene, ne miele Ŋutitotoŋkekenyui la ɖum, ");
INSERT INTO ewe_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","eye mia viwo bia mi be, ‘Nu ka ta miele ŋkekenyui sia ɖum mahã?’ la, ");
INSERT INTO ewe_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","miaɖo eŋu be, ‘Enye Yehowa ƒe mía ŋuti toto ƒe vɔsa, elabena eto Israelviwo ƒe aƒewo ŋuti, eye wòwu Egiptetɔwo.’ ” Ameawo katã de ta agu, eye wosubɔ Mawu. ");
INSERT INTO ewe_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Israel wɔ abe ale si Yehowa ɖo na Mose kple Aron ene. ");
INSERT INTO ewe_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Le zã ma me, le zãtitina tututu la, Yehowa wu ŋutsuvi gbãtɔwo le Egiptenyigba la dzi, tso Farao ƒe viŋutsuvi gbãtɔ si le eƒe zi dzi la dzi va se ɖe gaxɔmenɔla ƒe viŋutsuvi gbãtɔ dzi. Ewu lãwo ƒe vi siwo nye atsu la ƒe gbãtɔwo hã. ");
INSERT INTO ewe_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Farao kple eƒe aɖaŋudelawo kple Egiptetɔwo katã fɔ le zã ma me. Avifafa nɔ Egiptenyigba blibo la dzi, elabena aƒe aɖeke menɔ anyi esi me ame meku le o. ");
INSERT INTO ewe_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Farao yɔ Mose kple Aron le zã ma me, eye wògblɔ be, “Netsɔ, midzo le mía gbɔ, míeɖe kuku, mi katã midzo! Mia ŋutɔwo kple Israelviwo; miyi miasubɔ Yehowa abe ale si miebia ene. ");
INSERT INTO ewe_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Mikplɔ miaƒe alẽwo kple nyiwo, eye miadzo. Miyram eye miadzo.” ");
INSERT INTO ewe_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egiptetɔwo ƒo du ɖe Israelviwo nu be woadzo le anyigba la dzi kaba, abe ale si woate ŋui ene, elabena wogblɔ be, “Ne menye nenema o la, mí katã míele kuku ge.” ");
INSERT INTO ewe_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Israelviwo tsɔ woƒe amɔ maʋamaʋã ɖe asi. Wobla woƒe amɔkpakuwo ɖe woƒe avɔ mamlɛawo me heda ɖe abɔta. ");
INSERT INTO ewe_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israelviwo wɔ abe ale si Mose gblɔ na wo ene. Woɣe klosalonuwo kple sikanuwo kple awuwo le Egiptetɔwo si. ");
INSERT INTO ewe_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yehowa na Egiptetɔwo nyo dɔ me na Israelviwo ale gbegbe be wotsɔ nu sia nu si Israelviwo bia wo la na wo. Ale Egiptetɔwo ƒe nu sia nu kloe yi Israelviwo gbɔ! ");
INSERT INTO ewe_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israelviwo dzo le Rameses le zã ma me heɖo ta Sukɔt. Ŋutsu akpe alafa ade kple nyɔnuwo kple ɖeviwo dze mɔ kple afɔ. ");
INSERT INTO ewe_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Amedzro geɖewo hã dze mɔ kpli wo. Woho kple alẽha kple nyiha gã aɖewo. ");
INSERT INTO ewe_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Ne wotɔ hena nuɖuɖu la, wowɔa abolo kple amɔ maʋamaʋã si wotsɔ ɖe asi la ŋu dɔ. Amɔ la meʋã o, elabena ɖe wonya wo le Egipte, eye womekpɔ ɣeyiɣi aɖeke ana woƒe amɔ naʋã woatsɔ ɖe asi na mɔzɔzɔ la o. ");
INSERT INTO ewe_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israelviwo nɔ Egipte ƒe alafa ene blaetɔ̃ (430). ");
INSERT INTO ewe_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Le ƒe alafa ene blaetɔ̃ (430) lia ƒe nuwuwu, le ŋkeke ma dzi tututu la, Yehowa ƒe amewo katã ʋu le Egipte. ");
INSERT INTO ewe_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Yehowa tia zã sia be yeaɖe yeƒe amewo tso Egiptenyigba dzi, eya ta wòna zã sia zu gbe si gbe Israelviwo katã aɖu ale si Yehowa ɖe woe la ƒe ŋkekenyui ƒe sia ƒe. ");
INSERT INTO ewe_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yehowa gblɔ na Mose kple Aron be, “Esiawoe nye se siwo le Ŋutitotoŋkekenyui la ɖuɖu ŋuti. “Amedzro aɖeke maɖu alẽvi la ƒe lã o, ");
INSERT INTO ewe_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","gake kluvi si mieƒle hetso aʋa na la ate ŋu aɖui. ");
INSERT INTO ewe_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Agbatedɔwɔla alo amedzro si le mia gbɔ la, mekpɔ mɔ aɖui o. ");
INSERT INTO ewe_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Mi ame siwo katã aɖu alẽvi ɖeka la, miaɖui le aƒe ɖeka me: miatsɔ ɖeke ado goe o, eye miagbã ƒu aɖeke hã o. ");
INSERT INTO ewe_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Israelviwo katã aɖu ŋkekenyui sia le ɣeyiɣi ɖeka dzi. ");
INSERT INTO ewe_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Ne amedzro siwo le mia gbɔ di be yewoaɖu Yehowa ƒe Ŋutitotoŋkekenyui la kpli mi la, mina woƒe ŋutsuwo katã natso aʋa, ekema woate ŋu aɖui kpli mi. Ekema woazu abe ɖe wodzi wo ɖe mia dome ene. Ke bolotɔ aɖeke mekpɔ mɔ aɖu ŋutitotolẽvi la o. ");
INSERT INTO ewe_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Se ɖeka ma kee akplɔ Israelvi dzɔleaƒeawo kple amedzro siwo le mia dome.” ");
INSERT INTO ewe_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Israelviwo wɔ se siwo katã Yehowa de na wo to Mose kple Aron dzi la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Gbe ma gbe kee Yehowa kplɔ Israelviwo do goe tso Egiptenyigba dzi, le woƒe to vovovoawo me. ");
INSERT INTO ewe_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yehowa gblɔ na Mose bena, ");
INSERT INTO ewe_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Kɔ Israelviwo ƒe ŋutsuvi gbãtɔ ɖe sia ɖe kple lãwo ƒe atsu gbãtɔwo ŋu nam; eɖanye ame alo lã o, tɔnyewoe!” ");
INSERT INTO ewe_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mose gblɔ na ameawo be, “Ele be gbe si gbe miedzo le Egipte, eye miedo le kluvinyenye me la, nanye ŋkeke aɖe si dzi miaɖo ŋkui tegbetegbe, elabena Yehowa ɖe mi kple nukunu gãwo. Migaɖu naneke si me amɔʋãtike le la o. ");
INSERT INTO ewe_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Egbe, ɣleti Abib me, miele ʋuʋum. ");
INSERT INTO ewe_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ne Yehowa kplɔ mi va Kanaantɔwo, Hititɔwo, Amoritɔwo, Hivitɔwo kple Yebusitɔwo ƒe anyigba si wòka atam na mia fofowo be yeatsɔ ana mi, anyigba ‘si dzi notsi kple anyitsi bɔ ɖo’ dzi la, ekema miaɖu ŋkeke sia le dzinu sia me. ");
INSERT INTO ewe_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Hena ŋkeke adre la, miaɖu abolo maʋamaʋã, eye le ŋkeke adrelia gbe la, miaɖu ŋkekenyui na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Miaɖu abolo maʋamaʋã le ŋkeke adre mawo me; womakpɔ naneke si ʋã la le mia dome o alo akpɔ amɔʋãtike le miaƒe liƒowo me o. ");
INSERT INTO ewe_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Le gbe ma gbe la, migblɔ na mia viŋutsuwo be, ‘Mele esia wɔm ɖe nu si Yehowa wɔ nam, esi medo go le Egipte la ta.’ ");
INSERT INTO ewe_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ŋkeke sia ɖuɖu anɔ na mi abe dzesi ene le miaƒe asiwo kple ŋkuɖodzinu le miaƒe ŋgonu, ale be Yehowa ƒe se la anɔ miaƒe nu me, elabena Yehowa kplɔ mi do goe le Egipte kple asi sesẽ. ");
INSERT INTO ewe_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Eya ta miɖo ŋku nuɖoanyi sia dzi le ɣeyiɣi ɖoɖi la dzi ƒe sia ƒe. ");
INSERT INTO ewe_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Ne Yehowa kplɔ mi yi anyigba si ŋugbe wòdo na mia fofowo ƒe geɖewo nye esi va yi, afi si Kanaantɔwo le fifia dzi la, miɖo ŋku edzi be, ");
INSERT INTO ewe_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","miaƒe viŋutsuvi gbãtɔwo katã kple lãtsu siwo katã aʋu dɔ nu na miaƒe lãwo la katã nye Yehowa tɔ. Ele be miatsɔ wo nɛ. ");
INSERT INTO ewe_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Miate ŋu atsɔ agbo alo gbɔ̃tsu aɖɔli tedzitsu. Ke ne ame aɖe medi be yeawɔ alea o la, ele na amea be wòawu tedzi la. Ke ele be miaƒle viŋutsuvi ŋgɔgbeviwo katã ta. ");
INSERT INTO ewe_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Ne mia viwo abia mi be, ‘Nu ka ta miewɔa nu siawo ɖo?’ la, ele be miagblɔ na wo be, ‘Yehowa tsɔ nukunu gãwo ɖe mí tso kluvinyenye me, tso Egiptenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Farao meɖe mɔ na mí be míadzo o, eya ta Yehowa wu woƒe ŋgɔgbeviwo katã, amegbetɔwo kple lãwo tɔwo siaa le Egipte, eya ta míetsɔa atsu sia atsu, si ʋu dɔ nu na dadaa, amegbetɔwo kple lãwo siaa naa Yehowa. Ke woƒlea ŋutsuvi tsitsitɔwo katã ta.’ ");
INSERT INTO ewe_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Megale egblɔm na mi be ele be ŋkekenyui sia ɖuɖu nade dzesi mi abe Yehowa ƒe amewo ene, abe ɖe wòtsɔ eƒe nutɔnyenye ƒe dzesi ɖo ŋgonu na mi ene. Enye ŋkuɖodzi be Yehowa tsɔ ŋusẽ gã aɖe ɖe mi tso Egiptenyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Esi Farao ɖe asi le ameawo ŋu be woadzo mlɔeba la, Mawu mekplɔ wo to Filistitɔwo ƒe anyigba dzi o, togbɔ be eyae nye mɔ kpuitɔ hafi, elabena Mawu gblɔ be ne aʋa dzɔ ɖe wo kple Filistitɔwo dome la, woatrɔ ta me be yewoatrɔ, agbugbɔ ayi Egipte. ");
INSERT INTO ewe_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ale Mawu kplɔ wo to gbegbemɔ la dzi ɖo ta Ƒu Dzĩ la nu. Israelviwo ʋu tso Egipte, nɔ akpababla me hena aʋawɔwɔ. ");
INSERT INTO ewe_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose tsɔ Yosef ƒe ƒuwo ɖe asi, elabena Yosef na Israelviwo ka atam le Mawu ƒe ŋkume be yewoatsɔ eƒe ƒuwo ɖe asi ne Mawu akplɔ yewo adzoe tso Egipte, abe ale si wòka ɖe edzi be Mawu awɔe ene. ");
INSERT INTO ewe_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Esi wodzo le Sukɔt la, woƒu asaɖa anyi ɖe Etam le gbegbe la to. ");
INSERT INTO ewe_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yehowa kplɔa wo kple lilikpo dodo aɖe le ŋkeke me. Le zã me la, ekplɔa wo kple dzo bibi aɖe. Ale wotea ŋu zɔa mɔ le ŋkeke me kple zã me siaa. ");
INSERT INTO ewe_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Lilikpo dodo la kple dzo bibi la siaa mebuna ɖe wo ɣe aɖeke ɣi o. ");
INSERT INTO ewe_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Azɔ la, Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Gblɔ na Israelviwo be woatrɔ aɖo ta Pi Hahirɔt, le Migdol kple atsiaƒu la dome le Baal Zefon ŋgɔ, eye woaƒu asaɖa anyi ɖe ƒu la nu, ");
INSERT INTO ewe_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","elabena Farao abu be, ‘Israelvi mawo xaxa ɖe ƒu la kple gbegbe la dome!’ ");
INSERT INTO ewe_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Magana Farao nagasẽ dzi me, eye wòati mia yome. Mewɔ ɖoɖo sia ale be makpɔ bubu kple ŋutikɔkɔe gã ɖe Farao kple eƒe aʋakɔ dzi. Ale Egiptetɔwo anya be nyee nye Yehowa.” Ale woƒu asaɖa anyi ɖe afi si Mose fia wo la. ");
INSERT INTO ewe_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Esi Egipte fia se be Israelviwo meɖo ta me be yewoagbugbɔ va Egipte le ŋkeke etɔ̃ megbe o, ke boŋ yewoayi mɔzɔzɔ dzi la, Farao kple eŋumewo ƒe mo nyra, eye dzi gaɖo wo ƒo. Wobia be, “Nu kae nye esi míewɔ be míeɖe asi le Israelviwo ŋu wodzo eye míebu woƒe subɔsubɔdɔ nyuitɔwo?” ");
INSERT INTO ewe_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Ale Farao na wodzra eƒe tasiaɖam ɖo nɛ, eye wòkplɔ eƒe aʋakɔ ɖe asi. ");
INSERT INTO ewe_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Etia tasiaɖam nyuitɔ alafa ade kpe ɖe tasiaɖam bubu siwo katã nɔ Egipte la ŋu, eye wòtsɔ asrafomegãwo ɖo ɖe sia ɖe nu. ");
INSERT INTO ewe_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Yehowa na Egipte fia Farao ƒe dzi me sẽ ɖe edzi, ale wòti Israelvi siwo nɔ azɔli dzi dzideƒotɔe la yome. ");
INSERT INTO ewe_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Wowɔ Farao ƒe sɔwo, tasiaɖamwo, sɔdolawo kple aʋawɔla bubuawo katã ŋu dɔ le wo yometiti me. Egiptetɔwo va tu Israelviwo, esi woƒu asaɖa anyi ɖe ƒu la to, te ɖe Pi Hahirɔt ŋu le Baal Zefon ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Esi Egiptetɔwo ƒe aʋakɔ gbɔna la, Israelviwo kpɔ wo ɖaa le adzɔge ke, eye vɔvɔ̃ ɖo wo ŋutɔ. Wodo ɣli na Yehowa be wòakpe ɖe yewo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Wotrɔ ɖe Mose gbɔ helĩ liʋĩliʋĩ be, “Ɖe nèkplɔ mí va afi sia be míaku ɖe gbedzi, elabena yɔdowo mele Egipte oa? Nu kae nye esi nèwɔ be nèkplɔ mí do goe tso Egipte? ");
INSERT INTO ewe_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","“Menye esiae míegblɔ na wò esime míenɔ Egipte la be, ‘Ɖe asi le mía ŋu kpoo ne míasubɔ Egiptetɔwo’ oa? Anyo na mí be míasubɔ Egiptetɔwo wu be míaku ɖe gbegbe!” ");
INSERT INTO ewe_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ke Mose ɖo eŋu na wo be, “Migavɔ̃ o, minɔ te ɖe afi si miele la ko, milé ŋku ɖe nuwo ŋu, eye miakpɔ nukumɔ si dzi Yehowa aɖe mi toe egbe la ɖa. Egiptetɔ siwo kpɔm miele fifia la, miagakpɔ wo akpɔ o. ");
INSERT INTO ewe_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Yehowa awɔ aʋa na mi; miawo ya mizi kpoo nɛ ko.” ");
INSERT INTO ewe_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Yehowa gblɔ na Mose be, “Nu ka ŋuti nèle ɣli dom nam? Gblɔ na Israelviwo be woaɖe zɔ, ayi ŋgɔ ");
INSERT INTO ewe_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Do wò atikplɔ la ɖe dzi, eye nàdo wò asi ɖe atsiaƒu la dzi be atsiaƒutsi la nama ɖe eve, ale be Israelviwo nato atsiaƒu la me ayi le anyigba ƒuƒui dzi. ");
INSERT INTO ewe_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Mana Egiptetɔwo ƒe dzi me nasẽ be woadze Israelviwo yome, eye makɔ nye ŋkɔ ŋuti to Farao kple eƒe aʋakɔwo kple tasiaɖamwo kple sɔdolawo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Egiptetɔwo anya be nyee nye Yehowa, ne mekɔ nye ŋkɔ ŋuti to Farao, eƒe tasiaɖamwo kple eƒe sɔdolawo dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Mawudɔla si nɔ Israelviwo kplɔm la trɔ yi Israelviwo megbe, nenema ke lilikpo dodo si nɔ wo ŋgɔ la hã trɔ yi wo megbe, ");
INSERT INTO ewe_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ale wòtɔ ɖe Egipte ƒe aʋakɔwo kple Israelviwo dome. Le zã blibo la me la, lilikpo la na viviti do ɖe akpa ɖeka, eye kekeli do ɖe akpa kemɛ, ale wo dometɔ aɖeke mete ɖe nɔvia ŋu le zã blibo la me o. ");
INSERT INTO ewe_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Tete Mose tsɔ eƒe asi do ɖe ƒu la dzi. Ale zã blibo la Yehowa tutu atsiaƒu la ɖe megbe to ɣedzeƒeya sesẽ aɖe dzi, eye wòna anyigba ƒuƒui dze. Tsi la ma ɖe akpa eve, ");
INSERT INTO ewe_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","eye Israelviwo zɔ to atsiaƒu la me le anyigba ƒuƒui dzi, ale tsi la zu gli ɖe woƒe ɖusime kple miame. ");
INSERT INTO ewe_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Egiptetɔwo, Farao ƒe sɔwo, tasiaɖamwo kple sɔdolawo dze wo yome to atsiaƒu la ƒe gliwo me, eye woawo hã wonɔ atsiaƒu la ƒe ƒuƒuiƒe zɔm. ");
INSERT INTO ewe_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ke le ŋdi kanya la, Yehowa kplɔ Egiptetɔwo ƒe aʋakɔ la to dzo bibi la me, eye wòde tɔtɔ wo dome. ");
INSERT INTO ewe_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Woƒe tasiaɖamwo ƒe afɔwo de asi dodo me le wo te. Ale woƒe tasiaɖamwo de asi anyigbatete me. Egiptetɔwo do ɣli be, “Mina míadzo le Israel nu. Yehowa le aʋa wɔm kpli mí na wo!” ");
INSERT INTO ewe_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Yehowa gblɔ na Mose be, “Gada wò asi ɖe atsiaƒu la dzi ale be tsigliawo namu adze Egiptetɔwo, woƒe tasiaɖamwo kple woƒe sɔdolawo dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mose wɔ alea, eye esi ŋu ke la, atsiaƒu la gazu abe ale si wònɔ tsã ene. Egiptetɔwo dze agbagba be yewoasi, ke Yehowa na atsiaƒutsi la ŋe tsyɔ wo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Ale tsi la gbugbɔ yi enɔƒe hetsyɔ tasiaɖamwo, sɔdolawo kple Farao ƒe aʋakɔ blibo la, si dze Israelviwo yome ge ɖe atsiaƒu la me dzi. Wo dometɔ ɖeka pɛ gɔ̃ hã metsi agbe o. ");
INSERT INTO ewe_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Israelviwo zɔ anyigba ƒuƒui dzi hetso ƒu la, esime tsi la trɔ zu gli ɖe woƒe ɖusime kple miame. ");
INSERT INTO ewe_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ale Yehowa ɖe Israelviwo gbe ma gbe tso Egiptetɔwo ƒe asi me. Israelviwo kpɔ Egiptetɔwo woku, eye atsiaƒu la ɖe woƒe kukuawo ƒu gbe ɖe gota. ");
INSERT INTO ewe_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Esime Israelviwo kpɔ nukunu triakɔ si Yehowa wɔ na wo ɖe Egiptetɔwo ŋu la, wovɔ̃, wode bubu Yehowa ŋu, eye woxɔ eya kple eƒe dɔla Mose dzi se. ");
INSERT INTO ewe_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mose kple Israelviwo dzi kafukafuha sia na Yehowa be, “Madzi ha na Yehowa, elabena wodo eya amea ɖe dzi bobobo. Etsɔ sɔ kple sɔdola siaa de atsiaƒu la me. ");
INSERT INTO ewe_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Yehowae nye nye ŋusẽ kple xɔnametɔ, eya gbɔ ɖeɖe tso va nam. Eyae nye nye Mawu, eya ta makafui. Eyae nye fofonye ƒe Mawu, eya ta madoe ɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Yehowa nye aʋawɔla, Ɛ̃, eŋkɔe nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ede Farao ƒe tasiaɖamwo kple aʋakɔwo ƒu, eye wònyrɔ wo ɖe atsiaƒu la me. Farao ƒe aʋakplɔla xɔŋkɔwo nyrɔ ɖe Ƒu Dzĩ la me. ");
INSERT INTO ewe_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Atsiaƒutsi la tsyɔ wo dzi. Wodze to ɖe atsiaƒu la te abe kpe ene. ");
INSERT INTO ewe_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","O, Yehowa, wò nuɖusibɔ wɔ kalẽ. O, Yehowa, wò nuɖusibɔ kaka futɔwo hlẽ. ");
INSERT INTO ewe_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Le wò fianyenye ƒe gãnyenye me, ètsɔ ame siwo tsi tsitre ɖe ŋuwò la ƒu anyi. Èɖe asi le wò dziku bibi la ŋu, eye wòfia wo abe gbe ƒuƒu ene. ");
INSERT INTO ewe_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Wò ŋɔtimegbɔgbɔ do, eye wòna tsiawo ƒu kpo. Tsi sisi la nɔ te, eye wòlé akpa aveawo ɖe te abe gli ene, eye tsi goglo la zi ɖoɖoe le atsiaƒu la titina. ");
INSERT INTO ewe_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Futɔ la gblɔ dadatɔe be, ‘Mati wo yome, matu wo, mama woƒe afunyinuwo. Mana nye didi ɖe wo ŋuti nava eme. Maɖe nye yi tso aku me, eye nye asi atsrɔ̃ wo.’ ");
INSERT INTO ewe_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ke wò la, ègbɔ wò gbɔgbɔ, eye ƒu la ŋe tsyɔ wo dzi. Wodze to abe asabukpe ene ɖe tsi gã la te. ");
INSERT INTO ewe_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“O, Yehowa, ame kae le abe wò ene le mawuwo dome? Ame kae le abe wò ene le kɔkɔenyenye kɔkɔtɔ me, le ŋutikɔkɔe ƒe ŋɔdzi me, eye wòwɔa nukudɔwo? ");
INSERT INTO ewe_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Èdo wò nuɖusi ɖa, eye anyigba mi wo. ");
INSERT INTO ewe_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Àkplɔ ame siwo nèɖe la le wò lɔlɔ̃ mavɔ la ƒe ŋusẽ me. Le wò ŋusẽ me, àkplɔ wo ayi wò nɔƒe kɔkɔe lae. ");
INSERT INTO ewe_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Dukɔwo ase nya si dzɔ, woadzo nyanyanya; vɔvɔ̃ aɖo Filistitɔwo. ");
INSERT INTO ewe_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ŋɔdzi alé Edom fiawo, eye Moab ƒe kplɔlawo anɔ dzodzom nyanyanya, Kanaantɔwo hã ƒe dzi alolõ. ");
INSERT INTO ewe_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ŋɔdzi kple vɔvɔ̃ adze wo dzi. Woatrɔ azu kpe, le wò abɔ ƒe ŋusẽ ta, va se ɖe esime wò amewo atso eme ava ayi. O, Yehowa, va se ɖe esime wò ame siwo nèƒle la, atso eme ava yi. ");
INSERT INTO ewe_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Wò la, àkplɔ wo aɖo wo te le wò to si nye wò domenyinu la dzi. O, Yehowa, teƒe si nèwɔ be wòanye wò nɔƒe la, Aƒetɔ, Kɔkɔeƒe si nètsɔ wò ŋutɔ wò asiwo wɔe la. ");
INSERT INTO ewe_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Yehowa aɖu fia tegbetegbe!” ");
INSERT INTO ewe_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Farao ƒe sɔwo, eƒe sɔdolawo kple woƒe tasiaɖamwo kplɔ wo ɖo to atsiaƒu la me. Ke Yehowa na tsigliawo mu gbagbã tsyɔ wo dzi, le esime Israelviwo zɔ ƒuƒuiƒe to wo me. ");
INSERT INTO ewe_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nyagblɔɖila Miriam, Aron nɔvinyɔnu ƒo axatsɛ, eye wònɔ ŋgɔ na nyɔnuawo woɖu ɣe. ");
INSERT INTO ewe_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Eye Miriam dzi ha sia: “Midzi ha na Yehowa, elabena eɖu dzi ŋusẽtɔe. Ede sɔ kple sɔdola atsiaƒu la me.” ");
INSERT INTO ewe_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Azɔ la, Mose kplɔ Israelviwo to Ƒu Dzĩ la nu, eye woyi Sur gbedzi. Wonɔ afi ma ŋkeke etɔ̃, ke womekpɔ tsi woano o. ");
INSERT INTO ewe_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Esi wova ɖo Mara la, womete ŋu no tsi le afi ma o, elabena tsi la le vevem. (Esia ta woyɔa teƒe ma be Mara.) ");
INSERT INTO ewe_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Israelviwo lĩ liʋĩliʋĩ le Mose ŋu. Wobiae be, “Ɖe míaku le tsikɔwuame taa?” ");
INSERT INTO ewe_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mose ɖe kuku na Yehowa be wòakpe ɖe yewo ŋu. Yehowa fia ati aɖee wòtsɔ da ɖe tsi la me, eye tsi veve la trɔ zu tsi nyui. Le Mara la, Yehowa de se siawo na wo be yeado woƒe ɖokuitsɔtsɔ na ye akpɔ. ");
INSERT INTO ewe_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Ne miaɖo to Yehowa, miaƒe Mawu la ƒe gbe, miawɔ nu si dza le eƒe ŋkume, eye miawɔ eƒe sewo kple ɖoɖowo dzi la, ekema nyemana dɔléle siwo mena wova Egiptetɔwo dzi la nava mia dzi o, elabena nyee nye Yehowa, nyee daa gbe le mia ŋu.” ");
INSERT INTO ewe_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Wova ɖo Elim, afi si vudo wuieve kple deti blaadre le. Woƒu asaɖa anyi ɖe afi sia ɖe vudoawo to. ");
INSERT INTO ewe_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Azɔ la, Israel ƒe ha blibo la dzo le Elim, eye woyi Sin, gbegbe si le Elim kple Sinai to la dome. Woɖo afi ma le ɣleti evelia ƒe ŋkeke wuiatɔ̃lia dzi le woƒe dzodzo le Egipte megbe. ");
INSERT INTO ewe_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Le afi sia hã la, dukɔ la katã galĩ liʋĩliʋĩ le Mose kple Aron ŋuti vevie. ");
INSERT INTO ewe_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israelviwo gblɔ na wo be, “Ɖe wòanyo ŋutɔ ne míaku ɖe Yehowa ƒe asi me le Egipte! Le teƒe ma la, míenɔa anyi ƒoa xlã lã siwo míeɖa la ƒe zewo, eye míeɖua nu si míedi la, gake miekplɔ mí va gbegbe afi sia be dɔ nawu mí míaku.” ");
INSERT INTO ewe_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yehowa gblɔ na Mose be, “Kpɔ ɖa, mana abolo nadza tso dziƒo na wo. Ame sia ame ate ŋu ado go gbe sia gbe, eye wòafɔ nuɖuɖu si wòhiã. Mado wo kpɔ le nu sia me akpɔ be woawɔ ɖe nye ɖoɖowo dzi mahã. ");
INSERT INTO ewe_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Gblɔ na wo be, woafɔ nuɖuɖu si wofɔna gbe sia gbe la ƒe teƒe eve le kɔsiɖa ɖe sia ɖe ƒe ŋkeke adelia dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mose kple Aron wowɔ takpekpe kple Israelviwo katã. Wogblɔ na wo be, “Egbe fiẽ la, miadze sii be Yehowae kplɔ mi tso Egiptenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Le ŋdi la, miakpɔ eƒe ŋutikɔkɔe geɖe wu, elabena ese miaƒe liʋĩliʋĩlilĩ le eya, Yehowa ŋu, elabena menye míawo ŋue mielĩ liʋĩliʋĩ le o. Ame kawo míenye?” ");
INSERT INTO ewe_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mose gblɔ hã be mianya be, “Yehowae na lã mi le fiẽ me, eye wòna abolo si miehiã la mi le ŋdi me, elabena ese miaƒe liʋĩliʋĩlilĩwo le eŋuti. Ame kawoe mienye? Menye míawo ŋu miele liʋĩliʋĩ lĩm le o, ke boŋ Yehowa ŋue.” ");
INSERT INTO ewe_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ale Mose gblɔ na Aron be, “Gblɔ na Israelviwo katã be, ‘Miva Yehowa ŋkume, elabena ese miaƒe liʋĩliʋĩlilĩ.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Esi Aron nɔ nu ƒom na Israelviwo ƒe ha bliboa la, wonye kɔ kpɔ gbegbe lɔƒo, eye le afi ma wokpɔ Yehowa ƒe ŋutikɔkɔe wònɔ keklẽm le aliliwo me. ");
INSERT INTO ewe_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Mese woƒe liʋĩliʋĩlilĩ. Gblɔ na wo be, ‘Le fiẽ sia la, lã aka mia si; le ŋdi la, miaxɔ abolo, eye mianya be nyee nye Yehowa, miaƒe Mawu.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Gbe ma gbe fiẽ la, tegliwo ƒe ha gã aɖe va do, eye woxe asaɖa la tame. Le ŋdi la, afu do ƒo xlã asaɖa la, ");
INSERT INTO ewe_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","eye esi xexeme kɔ ŋdi la, nu ɣi nogonogoewo nɔ anyigba abe kpetsi ene. ");
INSERT INTO ewe_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Esi Israelviwo kpɔ wo la, wobia wo nɔewo be, “Nu kawoe nye esiawo?” Elabena womenya nu si wonye o. Mose gblɔ na wo be, “Esiawoe nye abolo si Yehowa na mi be miaɖu. ");
INSERT INTO ewe_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Yehowa gblɔ be, ame sia ame nafɔ agbɔsɔsɔ si ade eƒe aƒemetɔwo nu abe lita eve ƒe dzidzeme ene ɖe aƒea me tɔ ɖe sia ɖe nu.” ");
INSERT INTO ewe_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ale Israelviwo yi ɖafɔ wo abe ale si Mose gblɔ na wo ene; ame aɖewo fɔe fũu, ke ame aɖewo hã mefɔe fũu o. ");
INSERT INTO ewe_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Esi wotrɔ wo ɖe dzidzenu la me la, woyɔ dzidzenu la ɖe ame sia ame nu. Ame si ƒoa ƒu nuwo fũu hã mekpɔa ɖeke ɖe edzi o, ke ame si ƒo ƒu sue aɖe hã la, naneke mehiãnɛ o! Aƒe ɖe sia ɖe me tɔwo kpɔ esi ade wo nu tututu. ");
INSERT INTO ewe_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mose gblɔ na wo be, “Migana ŋu nake ɖe wo dzi o.” ");
INSERT INTO ewe_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Ame aɖewo meɖo to o: wona ŋu ke ɖe wo dzi. Kasia woakpɔ wo ɖa la, wodze nyẽ henɔ ʋeʋẽm kũu. Mose do dɔmedzoe ɖe wo ŋu vevie, ");
INSERT INTO ewe_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","eya ta azɔ la, wofɔa nuɖuɖu la ŋdi sia ŋdi, eye aƒe sia aƒe fɔa esi wòhiã la ko. Ne ŋdɔ ʋu, eye anyigba xɔ dzo la, abolo la lolõna, eye wòbuna. ");
INSERT INTO ewe_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Le ŋkeke adelia dzi la, wofɔa agbɔsɔsɔ si wofɔna gbe sia gbe la ƒe teƒe eve. Wofɔa lita ene ɖe ame sia ame nu, ɖe lita eve teƒe. Kplɔlawo bia Mose be nu ka ta wòde se ma na yewo mahã. ");
INSERT INTO ewe_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mose gblɔ na wo be, “Yehowa tɔ asi etsɔ dzi be wòanye dzudzɔgbe, wòanye ŋkeke kɔkɔe na Yehowa, eye wòle be míadzudzɔ tso míaƒe gbe sia gbe dɔwo wɔwɔ me, eya ta miɖa nu wòasɔ gbɔ abe ale si miedi ene egbe, eye midzra esi asusɔ la ɖo ŋu nake ɖe edzi.” ");
INSERT INTO ewe_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Esi ŋu ke la, nuɖuɖu la nɔ nyuie: megadze nye o eye megaʋẽ hã o, abe ale si Mose gblɔe na wo ene. ");
INSERT INTO ewe_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose gblɔ be, “Esiae nye miaƒe egbe ƒe nuɖuɖu, elabena egbee nye dzudzɔgbe na Yehowa, eye nuɖuɖu aɖeke maganɔ anyigba miafɔ egbe o. ");
INSERT INTO ewe_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Mifɔ nuɖuɖu la ŋkeke ade, ŋkeke adrelia nye Dzudzɔgbe. Nuɖuɖu aɖeke manɔ anyigba miafɔ gbe ma gbe o.” ");
INSERT INTO ewe_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ke ame aɖewo ya gayi nuɖuɖu la fɔ ge, togbɔ be gbe ma gbee nye ŋkeke adrelia, ke nuɖuɖu aɖeke menɔ anyigba wofɔ o. ");
INSERT INTO ewe_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yehowa bia Mose be, “Va se ɖe ɣe ka ɣie miagbe toɖoɖo nye sewo kple ɖoɖowo? ");
INSERT INTO ewe_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Miɖo ŋku edzi be, Yehowae na Dzudzɔgbe ŋkeke la mi; esia tae wòna ŋkeke eve ƒe abolo mi le ŋkeke adelia gbe. Ame sia ame nenɔ afi si wòle le ŋkeke adrelia gbe; ame aɖeke megado go o.” ");
INSERT INTO ewe_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Ale Israelviwo dzudzɔ wo ɖokuiwo le ŋkeke adrelia gbe. ");
INSERT INTO ewe_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israelviwo yɔa abolo la be, “mana.” Ele ɣie abe bliku ene, eye wòvivina abe akpɔnɔvivi si me wode anyitsii ene. ");
INSERT INTO ewe_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose gblɔ be, “Ale Yehowa de see nye esi, ‘Tsɔ mana lita ɖeka, dzrae ɖo hena dzidzime siwo ava dzɔ, ale be woate ŋu akpɔ abolo si mena mi mieɖu le gbedzi, esi mekplɔ mi do goe le Egipte.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ale Mose gblɔ na Aron be, “Tsɔ ze aɖe, eye nàdzidze mana lita ɖeka akɔ ɖe eme. Ekema, nàtsɔe ɖo Yehowa ŋkume be woadzrae ɖo hena dzidzime siwo ava dzɔ.” ");
INSERT INTO ewe_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aron wɔ esia abe ale si Yehowa bia tso Mose si ene. Emegbe la, Aron tsɔe da ɖe nubablaɖaka la ŋgɔ le agbadɔ la me be wòanɔ dedie le afi ma. ");
INSERT INTO ewe_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Ale Israelviwo ɖu “mana” ƒe blaene va se ɖe esime woɖo Kanaanyigba ƒe liƒo dzi, afi si agblemenukuwo nɔ woaɖu. ");
INSERT INTO ewe_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Dzidzenu si wotsɔna dzidzea mana la anɔ abe lita eve ene.) ");
INSERT INTO ewe_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Azɔ la, le Yehowa ƒe gbeɖeɖe nu la, Israelviwo dzo le Sin gbegbe la. Wonɔ tɔtɔm ɖe teƒeteƒewo va se ɖe esime woɖo Refidim. Ke esi woɖo afi ma la, tsi aɖeke menɔ anyi o! ");
INSERT INTO ewe_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Esia ta Israelviwo he nya ɖe Mose ŋu be, “Na tsi mi!” Mose blu ɖe wo ta be, “Mizi ɖoɖoe! Ɖe miele didim be yewoado Yehowa ƒe dzigbɔɖi na mi akpɔa?” ");
INSERT INTO ewe_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Ke le tsikɔwuame la ƒe sesẽ ta la, dukɔ la lĩ Mose ŋu gblɔ be, “Nu ka tututue na nèkplɔ mí dzoe le Egipte? Nu ka ta nèkplɔ mí va afi sia be míaku kple mía viwo kple míaƒe lãwo?” ");
INSERT INTO ewe_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mose ɖe kuku na Yehowa be, “Nu ka mawɔ? Wole klalo be yewoaƒu kpem.” ");
INSERT INTO ewe_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yehowa ɖo eŋu na Mose be, “Dze ŋgɔ na dukɔ la, kplɔ Israel ƒe ametsitsi aɖewo ɖe asi. Tsɔ atikplɔ si netsɔ ƒo Nil tɔsisi la ɖe asi, eye nàyi. ");
INSERT INTO ewe_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Mado go wò le agakpe la gbɔ le Horeb. Ƒo agakpe la kple wò atikplɔ si nètsɔ ƒo Nil tɔsisi lae. Tsi ado bababa, asu na ame sia ame.” Mose wɔ abe ale si Mawu gblɔ nɛ ene le Israel ƒe ametsitsiawo ƒe ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mose na ŋkɔ teƒe la be Masa si gɔmee nye “Míete Yehowa kpɔ be wòawu mí.” Woyɔnɛ hã be Meriba si gɔmee nye “Nyahehe” kple “Dzrewɔwɔ,” elabena afi mae Israelviwo he nya ɖe Yehowa ŋu le, eye wotee kpɔ be wòawu yewo esi wogblɔ be, “Ɖe Yehowa le mía dzi kpɔ ge loo alo agblẽ mí ɖia?” ");
INSERT INTO ewe_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Azɔ la, Amalekitɔwo ho aʋa ɖe Israelviwo ŋu le Refidim. ");
INSERT INTO ewe_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mose gblɔ na Yosua be wòana Israelviwo nadzra ɖo, akpe aʋa kple Amalekitɔwo. Mose gblɔ nɛ be, “Etsɔ la, matsi tsitre ɖe togbɛ la dzi. Mawu ƒe atikplɔ anɔ asinye!” ");
INSERT INTO ewe_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Ale Yosua kple eƒe amewo yi be yewoawɔ aʋa kple Amalekitɔwo ƒe aʋakɔ le esime Mose, Aron kple Hur woyi to la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ne Mose kɔ atikplɔ la ɖe dzi ko la, Israelviwo ɖua futɔwo dzi. Ke ne eɖiɖi abɔ be yeadzudzɔ sẽe ko la, Amalekitɔwo ɖua Israelviwo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Abɔwo va ku ɖe Mose ŋu ale gbegbe be, magate ŋu alé atikplɔ la ɖe dzi azɔ o. Ale Aron kple Hur womli kpe aɖe vɛ, eye Mose nɔ edzi. Ame ɖeka nɔ Mose ƒe miame, eye evelia nɔ eƒe ɖusime. Wolé Mose ƒe abɔwo do ɖe dzi va se ɖe esime ɣe ɖo to. ");
INSERT INTO ewe_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Le esia ta Yosua kple eƒe aʋakɔ la ɖu Amalekitɔwo ƒe aʋakɔ dzi kple yi. ");
INSERT INTO ewe_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Yehowa gblɔ na Mose be, “Ŋlɔe da ɖi, wòanɔ anyi ɖaa, woaɖo ŋku edzi tegbetegbe, eye nàɖe gbeƒã na Yosua be matutu Amalekitɔwo ƒe ŋkɔ ɖa keŋkeŋ.” ");
INSERT INTO ewe_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mose tu vɔsamlekpui aɖe ɖe afi ma, eye wòna ŋkɔe be “Yehowa Nisi” si gɔmee nye “Yehowae nye nye aflaga.” ");
INSERT INTO ewe_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Mose gblɔ be, “Elabena wodo aflaga ɖe dzi le Yehowa ƒe fiazi la ŋgɔ, Yehowa anɔ aʋa wɔm kple Amalekitɔwo tso dzidzime yi dzidzime.” ");
INSERT INTO ewe_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetro, si nye Mose to, ame si nye Midian nunɔla la, se nu tso nukunu siwo Mawu wɔ na eƒe dukɔ Israel kple Mose kple ale si Yehowa ɖe wo tso Egipte la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Esia ta Yetro kplɔ Mose srɔ̃ Zipora yi nɛ, elabena Mose ɖo srɔ̃a ɖe fofoa gbɔ. ");
INSERT INTO ewe_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Ekplɔ Mose ƒe viŋutsu eveawo hã yii. Via ŋutsuvi Gersom ƒe ŋkɔ gɔmee nye, “Amedzro,” elabena esi wodzii la, Mose gblɔ be, “Menɔ tsaglalã tsam le dzronyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Via ŋutsuvi evelia, Eliezer, ƒe ŋkɔ gɔmee nye, “Mawue nye nye xɔnametɔ,” elabena esi wodzii la, Mose gblɔ be, “Fofonyewo ƒe Mawue nye nye xɔnametɔ, eye wòɖem tso Farao ƒe yi nu.” ");
INSERT INTO ewe_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetro, Mose to kple Mose ƒe viŋutsuwo kple srɔ̃a wova Mose gbɔ le gbegbe, afi si woƒu asaɖa anyi ɖo, le Mawu ƒe to la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetro dɔ ame ɖo ɖe Mose gbɔ be woagblɔ nɛ be, “Nye towò, Yetro kple srɔ̃wò kple viwò ŋutsu eveawo míegbɔna gbɔwò.” ");
INSERT INTO ewe_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mose yi ɖakpe toa, eye wòxɔe dzidzɔtɔe. Wobia wo nɔewo ƒe agbe ta, eye woyi ɖe Mose ƒe agbadɔ me hena nya aɖewo ŋu bubu. ");
INSERT INTO ewe_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose gblɔ nu siwo katã dzɔ kple nu siwo Yehowa wɔ Farao kple Egiptetɔwo, ale be yeate ŋu aɖe Israelviwo, nukpekeame siwo nɔ mɔ me na Israelviwo kple ale si Yehowa ɖe wo tso wo katã me la na toa. ");
INSERT INTO ewe_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetro kpɔ dzidzɔ ŋutɔ le nu sia nu si Yehowa wɔ na Israelviwo kple ale si wòkplɔ wo dzoe le Egipte la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yetro si nye Mose to la gblɔ be, “Mikafu Yehowa, elabena eɖe mi tso Egiptetɔwo kple Farao ƒe asi me, eye wòɖe Israel. ");
INSERT INTO ewe_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Menya azɔ be Yehowa tri akɔ wu mawu bubu ɖe sia ɖe, elabena eɖe eƒe amewo tso Egiptetɔwo, ame siwo nye dadalawo kple ame vɔ̃ɖiwo la ƒe asi me.” ");
INSERT INTO ewe_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yetro sa numevɔsa kple akpedavɔsawo na Mawu. Emegbe la, Aron kple Israelviwo ƒe ametsitsiwo va do gbe na Yetro, eye wo katã woɖu vɔsalã la le Mawu ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Esi ŋu ke la, Mose nɔ anyi abe ale si wòwɔna ɣe sia ɣi ene, tso ŋdi va se ɖe fiẽ be yeadrɔ̃ ʋɔnu le ameawo dome. ");
INSERT INTO ewe_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Esi Mose to kpɔ ɣeyiɣi si ʋɔnudɔdrɔ̃ la xɔna nɛ la, egblɔ nɛ be, “Nu ka ta nèle agbagba dzem be ye ɖeka yeawɔ nu siawo katã, le esime amewo le tsitre le afi sia ŋkeke blibo la katã be nàkpe ɖe yewo ŋuti?” ");
INSERT INTO ewe_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose ɖo eŋu nɛ be, “Elabena dukɔ la va gbɔnye be woabia Mawu ƒe lɔlɔ̃nu. ");
INSERT INTO ewe_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ne nya dzɔ ɖe ameawo dome la, wotsɔnɛ vɛ nam, medrɔ̃nɛ na wo, eye megblɔa Mawu ƒe sewo kple ɖoɖowo na wo.” ");
INSERT INTO ewe_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mose to, Yetro gblɔ nɛ be, “Nu si wɔm nèle la menyo o. ");
INSERT INTO ewe_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Èle ɖeɖiteameŋu kple dɔléle he ge ava ɖokuiwò dzi. Ne eva eme alea ɖe, nu kae wò amewo awɔ? Mose, dɔ sia sẽ akpa be nàvu ɖe eŋu be ye ɖeka yeawɔ. ");
INSERT INTO ewe_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ɖo tom, ne maɖo aɖaŋu na wò, eye Mawu anɔ kpli wò, Ànɔ dukɔ la teƒe le Mawu ŋkume, eye nàtsɔ woƒe nyawo ɖo eƒe ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Fia Mawu ƒe seawo kple ɖoɖoawo wo, eye nàfia ale si woanɔ agbee kple woƒe dɔdeasiwo wo. ");
INSERT INTO ewe_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","“Di ame zazɛ̃ aɖewo, ame siwo vɔ̃a Mawu, ame siwo gblɔa nyateƒe eye wotsri zãnuxɔxɔ. Tia wo, eye nàɖo wo ʋɔnudrɔ̃lawo ɖe ameawo dzi. Ame aɖewo ɖe ame akpe nu, Ame aɖewo ɖe ame alafa nu, Ame aɖewo ɖe ame blaatɔ̃ nu eye Ame aɖewo ɖe ame ewo nu. ");
INSERT INTO ewe_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Na ame siawo nadrɔ̃ nya kukluiwo na ameawo ɣe sia ɣi. Nya veviwo kple nya sesẽwo koe woatsɔ va gbɔwòe. Ne èto mɔ sia dzi la, nuwo abɔbɔ na wò, elabena àma nyadɔdrɔ̃ ƒe agba kple nyadrɔ̃lawo. ");
INSERT INTO ewe_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ne èzɔ ɖe aɖaŋu sia dzi, eye Mawu lɔ̃ la, àte ŋu anɔ te ɖe dɔ sesẽ sia nu, eye tomefafa kple nusɔsɔ anɔ asaɖa la me.” ");
INSERT INTO ewe_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose xɔ toa ƒe aɖaŋu, eye wòzɔ ɖe eƒe nyawo nu. ");
INSERT INTO ewe_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Etia ame zazɛ̃wo le Israelviwo katã dome. Ena wozu ʋɔnudrɔ̃lawo ɖe ameawo dzi. Ame aɖewo adrɔ̃ ʋɔnu na ame akpewo, bubuwo na alafawo, bubuwo na blaatɔ̃wo kple ewowo. ");
INSERT INTO ewe_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Wonɔa anyi ɣe sia ɣi na nyadɔdrɔ̃. Wotsɔa nya sesẽwo vaa Mose gbɔ, ke wodrɔ̃a nya kukluiwo le wo ɖokuiwo si. ");
INSERT INTO ewe_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Le ɣeyiɣi kpui aɖe megbe la, Mose na toa trɔ yi wo de. ");
INSERT INTO ewe_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Le Israelviwo ƒe dzodzo le Egipte ƒe ɣleti etɔ̃ megbe la, wova ɖo Sinai gbedzi. ");
INSERT INTO ewe_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Esi woho tso Refidim la, wova ɖo Sinai gbegbe la, eye Israel ƒu asaɖa anyi ɖe afi ma le to la te. ");
INSERT INTO ewe_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose lia to la yi Mawu gbɔ, eye Yehowa yɔe tso to la dzi gblɔ nɛ be, “Gblɔ na Yakob ƒomeawo, eye ale nàɖe gbeƒãe na Israelviwoe nye esi, ");
INSERT INTO ewe_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Miawo ŋutɔ miekpɔ nu si mewɔ Egiptetɔwo kple ale si mekplɔ mi va ɖokuinye gbɔ abe ɖe metsɔ mi ɖe hɔ̃ ƒe aʋalãwo dzi ene. ");
INSERT INTO ewe_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Azɔ la, ne miaɖo tom, eye miawɔ nye nubabla dzi la, mianye nye ame tiatiawo le xexemedukɔwo katã dome, elabena tɔnyee nye xexea me katã. ");
INSERT INTO ewe_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Gawu la, mianye nunɔlawo ƒe fiaɖuƒe kple dukɔ kɔkɔe aɖe nam.’ Nya siawo nàgblɔ na Israelviwo.” ");
INSERT INTO ewe_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Esi Mose trɔ gbɔ tso to la dzi la, eyɔ kplɔlawo ƒo ƒu, eye wògblɔ nya si Yehowa gblɔ nɛ la na wo. ");
INSERT INTO ewe_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Wo katã wolɔ̃ ɖe edzi kple gbe ɖeka be, “Míawɔ nu sia nu si wòadi tso mía si be míawɔ.” Mose gblɔ nya si ameawo gblɔ la na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Yehowa gblɔ na Mose be, “Mele gbɔwò va ge le lilikpo dodo aɖe me, ale be ameawo ŋutɔ nate ŋu ase nye gbe ne mele nu ƒom na wò, ekema woaxɔ dziwò ase ɣe sia ɣi.” Eye Mose gblɔ dukɔ la ƒe nyawo na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Eye Yehowa gblɔ na Mose be, “Yi dukɔ la gbɔ, eye nàkpɔ be ameawo le klalo na nye vava. Kɔ wo ŋuti egbe kple etsɔ, eye nàna woanya woƒe awuwo. ");
INSERT INTO ewe_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Ekema ŋkeke etɔ̃a gbe la, maɖi tso Sinai to la dzi le ame sia ame ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ɖo liƒo siwo ŋu ameawo magbɔ o la na wo. Gblɔ na wo be, ‘Mikpɔ nyuie be mialia to la alo aka asi eŋu gɔ̃ hã o. Ame sia ame si da le se sia dzi la dze na ku. ");
INSERT INTO ewe_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ame aɖeke maka asi sedzidala sia ŋu o, ke boŋ woaƒu kpee alo woatee kple da wòaku. Woawɔ amegbetɔwo kple lãwo siaa nenema.’ Migate ɖe toa ŋu kura o va se ɖe esime miase lãdzokpẽ aɖe ƒe ɖiɖi zi ɖeka sesĩe. Ekema miaƒo ƒu ɖe to la te!” ");
INSERT INTO ewe_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Ale Mose ɖi tso to la dzi va ameawo gbɔ. Ekɔ wo ŋuti, eye wonya woƒe awuwo. ");
INSERT INTO ewe_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mose gblɔ na wo be, “Midzra ɖo na Mawu ƒe vava le ŋkeke eve megbe. Migadɔ kple nyɔnu aɖeke o.” ");
INSERT INTO ewe_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Le ŋkeke etɔ̃lia ƒe ŋdi la, dzi de asi gbeɖeɖe kple dzokeke me ŋɔdzitɔe. Lilikpo dodo gã aɖe va dze ɖe to la dzi. Kpẽ aɖe ɖi sesĩe ɣeyiɣi didi aɖe abe lãdzokpẽ ene, eye ame sia ame dzo nyanyanya kple vɔvɔ̃. ");
INSERT INTO ewe_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose kplɔ wo tso woƒe agbadɔwo me be woado go Mawu; ena wotsi tsitre ɖe to la te. ");
INSERT INTO ewe_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Dzudzɔ tsyɔ Sinai to blibo la dzi, elabena Yehowa ɖi ɖe edzi le dzo ƒe nɔnɔme me. Dzudzɔ la yi dzi ʋĩi abe kpodzo gã aɖe ƒe dzudzɔ ene. To blibo la ʋuʋu kpekpekpe. ");
INSERT INTO ewe_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Esi kpẽ la ƒe ɖiɖi ganɔ sesẽm ɖe edzi la, Mose ƒo nu, eye Mawu ɖo eŋu nɛ kple gbe sesẽ aɖe. ");
INSERT INTO ewe_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Yehowa ɖi va Sinai to la tame. Eyɔ Mose be wòava to la dzi, eye Mose lia to la yi egbɔ. ");
INSERT INTO ewe_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Yehowa gblɔ na Mose be, “Ɖi nàyi ameawo gbɔ, eye nàde se na wo be ame aɖeke mekpɔ mɔ agbɔ liƒoawo dzi o. Mele be woava afi sia, adze agbagba be yewoakpɔm o. Ame si ake atse la aku. ");
INSERT INTO ewe_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ele na nunɔla siwo ate ɖe Yehowa ŋu gɔ̃ hã be woakɔ wo ɖokuiwo ŋuti; ne menye nenema o la, Yehowa atsrɔ̃ wo.” ");
INSERT INTO ewe_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mose ɖo nya sia ŋu na Yehowa be, “Ameawo mava Sinai toa dzi o, elabena ède se na wo be womekpɔ mɔ ava o. Ègblɔ nam be maɖo liƒowo ƒo xlã to la, eye mana ameawo nanya be womekpɔ mɔ ada ata liƒoawo o, elabena wotso teƒe si le liƒoawo godo la ɖi na wò.” ");
INSERT INTO ewe_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ke Yehowa gagblɔ na Mose be, “Ɖi nàyi, eye nàkplɔ Aron ɖe asi vɛ. Mègaɖe mɔ be nunɔlawo kple ameawo nagbɔ liƒoawo dzi be yewoava afi sia o. Ne wotee kpɔ la, matsrɔ̃ wo.” ");
INSERT INTO ewe_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Ale Mose ɖi yi ameawo gbɔ, eye wògblɔ nya si Mawu gblɔ nɛ la na wo. ");
INSERT INTO ewe_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Eye Mawu gblɔ nya siawo be: ");
INSERT INTO ewe_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Nyee nye Yehowa, wò Mawu, si ɖe wò tso kluvinyenye me le Egiptenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Mawu bubu aɖeke meganɔ asiwò kpe ɖe ŋunye o. ");
INSERT INTO ewe_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Mègawɔ legba aɖeke na ɖokuiwò ɖe nu siwo le dziƒo alo le anyigba dzi alo le atsiaƒu me la ƒe nɔnɔme me o. ");
INSERT INTO ewe_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Mègade ta agu na wo alo asubɔ wo o, elabena nye Yehowa, wò Mawu la, Mawu ʋãŋue menye. Mehea to na ame siwo léa fum la ƒe viwo va se ɖe dzidzime etɔ̃lia kple enelia dzi, ");
INSERT INTO ewe_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Ke meɖea nye lɔlɔ̃ fiaa dzidzime akpe nane siwo lɔ̃am, eye wowɔa nye seawo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mègayɔ Yehowa, wò Mawu la ƒe ŋkɔ dzodzro o, elabena Yehowa magbe tohehe na ame siwo yɔa eƒe ŋkɔ dzodzro la o. ");
INSERT INTO ewe_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ɖo ŋku Dzudzɔgbe la dzi, eye nàwɔe kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Wɔ wò dɔwo katã le ŋkeke ade me. ");
INSERT INTO ewe_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Ke ŋkeke adrelia nye dzudzɔgbe le Yehowa, wò Mawu la ŋkume. Mele be wò ŋutɔ, viwò ŋutsu alo viwò nyɔnu, wò kluvi alo wò kosi, wò nyi alo wò amedzro gɔ̃ hã nawɔ dɔ aɖeke ƒomevi gbe ma gbe o, ");
INSERT INTO ewe_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","elabena le ŋkeke ade mee Yehowa wɔ dziƒo, anyigba, atsiaƒu kple nu siwo katã le wo me, eye wòdzudzɔ le ŋkeke adrelia gbe, eya ta Yehowa yra Dzudzɔgbe la, eye wòwɔe kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Bu fofowò kple dawò be nànɔ agbe didi le anyigba si Yehowa, wò Mawu la ana wò la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Mègawu ame o. ");
INSERT INTO ewe_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Mègawɔ ahasi o. ");
INSERT INTO ewe_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Mègafi fi o. ");
INSERT INTO ewe_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Mègaɖi aʋatsoɖase ɖe hawòvi ŋuti o. ");
INSERT INTO ewe_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Mègabiã ŋu ɖe hawòvi ƒe aƒe, alo srɔ̃a alo eƒe dɔlaŋutsu alo dɔlanyɔnu alo eƒe nyiwo alo eƒe tedziwo loo alo nu sia nu si nye etɔ la ƒe ɖeke ŋu o.” ");
INSERT INTO ewe_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Ameawo katã kpɔ dzikedzo kple dzudzɔ si nɔ tutum le to la me. Wose dziɖegbe la kple kpẽkuku didi dziŋɔ la. Wotsi tsitre ɖe adzɔge henɔ dzodzom nyanyanya kple vɔvɔ̃. ");
INSERT INTO ewe_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Wogblɔ na Mose be, “Wò boŋ gblɔ nya si Mawu le gbɔgblɔm la na mí, eye míawɔ edzi. Ke mègana Mawu ŋutɔ naƒo nu na mí o; ne menye nenema o la, ava wu mí.” ");
INSERT INTO ewe_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mose gblɔ na wo be, “Migavɔ̃ o, elabena Mawu va le nɔnɔme sia me be yeaɖe yeƒe ŋusẽ dziŋɔ la afia mi, ale be tso azɔ dzi yina la, miagawɔ nu vɔ̃ o.” ");
INSERT INTO ewe_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Le esime ameawo le tsitre ɖe adzɔge la, Mose ge ɖe blukɔ si me Mawu nɔ la me. ");
INSERT INTO ewe_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yehowa gblɔ nya siawo na Mose be, “Gblɔ na Israelviwo be, ‘Miawo ŋutɔ miekpɔe be meɖe nye lɔlɔ̃nu fia mi tso dziƒo. ");
INSERT INTO ewe_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Miɖo ŋku edzi be miekpɔ mɔ awɔ legba aɖeke kple klosalo alo sika alo kple nu bubu aɖeke asubɔ o! ");
INSERT INTO ewe_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Mitsɔ anyi ɖi vɔsamlekpuiwo nam. Miwɔ miaƒe numevɔsawo kple akpedavɔsawo kple alẽwo kple nyiwo le wo dzi nam. Miɖi vɔsamlekpuiwo ɖe teƒe siwo mafia mi la ko, eye mava yra mi le teƒe mawo. ");
INSERT INTO ewe_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Miate ŋu aɖi vɔsamlekpuiwo kple kpewo hã, gake miwɔ kpe siwo womekpa alo fu o la ko ŋu dɔ. Migakpa kpeawo kple dɔwɔnu aɖeke o, elabena ne miekpa wo la, womagadze be woawɔ wo ŋu dɔ hena vɔsamlekpuiɖiɖi nam o. ");
INSERT INTO ewe_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Mègawɔ atrakpuiwo ɖe vɔsamlekpui la ŋu o. Ne èwɔ wo, eye nèlia wo la, ame aɖe ate ŋu awu mo dzi, eye wòakpɔ wò amame to wò awu ʋlaya la te.’ ");
INSERT INTO ewe_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Se bubu siwo dzi miawɔ la woe nye: ");
INSERT INTO ewe_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ne Hebri ŋutsu aɖe nyi fe le asiwò, mete ŋu xee o, eye wòto esia me zu wò kluvi la, ekema ele be wòasubɔ wò ƒe ade ko. Magaxe fe aɖeke o, ke boŋ azu ablɔɖeme le ƒe adrelia me. ");
INSERT INTO ewe_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","“Ne ezu wò kluvi hafi va ɖe srɔ̃ la, ekema eya ɖeka koe azu ablɔɖeme. Ke ne eɖe srɔ̃ hafi va zu wò kluvi la, ekema eya ŋutɔ kple srɔ̃a siaa azu ablɔɖemewo le ŋkeke ɖeka ma dzi. ");
INSERT INTO ewe_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ke ne aƒetɔ aɖe ɖe srɔ̃ na eƒe kluvi, eye wodzi viŋutsuwo kple vinyɔnuwo la, ekema srɔ̃nyɔnu la kple wo viwo aganye aƒetɔ la tɔ, le esime kluvi la ya azu ablɔɖeme. ");
INSERT INTO ewe_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Ke ne kluvi la ɖe gbeƒã be, ‘Melɔ̃ nye aƒetɔ, srɔ̃nye kple vinyewo, eya ta nyemedi be mazu ablɔɖeme o’ la, ");
INSERT INTO ewe_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ekema ele be aƒetɔ la nakplɔe va ʋɔnudrɔ̃lawo ŋkume, aŋɔ to nɛ kple nuŋɔnui le amewo ŋkume, ekema azu kluvi azɔ tegbetegbe. ");
INSERT INTO ewe_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Ne fofo aɖe dzra via nyɔnu wòzu kosi la, mazu ablɔɖeme le ƒe ade megbe abe ŋutsuwo ene o. ");
INSERT INTO ewe_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ne kosi la ƒe nu meganyo eƒe aƒetɔ ŋu o la, ekema aƒetɔ la ate ŋu ana ame bubu naƒlee. Ke aƒetɔ la mekpɔ mɔ adzra kosi la na dukɔ bubu me tɔwo o, elabena eda vo ɖe kosi la ŋu le esime megadi be wòaganye ye srɔ̃ o ta. ");
INSERT INTO ewe_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ne aƒetɔ la na eya ŋutɔ Via ŋutsu ɖe Hebri kosi aɖe la, ekema magabu nyɔnu la abe kosi ene o, ke boŋ alé be nɛ azɔ abe eya ŋutɔ via nyɔnu ene. ");
INSERT INTO ewe_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ne aƒetɔ la ŋutɔ ɖe kosi la, eye wògaɖe nyɔnu bubu kpe ɖe eŋu la, mele be wòaɖe kosi la ƒe nuɖuɖu alo nutata dzi akpɔtɔ loo alo agbe egbɔdɔdɔ abe srɔ̃a ene o. ");
INSERT INTO ewe_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ne ŋutsu la gbe nu etɔ̃ siawo dometɔ ɖeka wɔwɔ la, ekema kosi la kpɔ mɔ adzo, eye maxe fe aɖeke o.” ");
INSERT INTO ewe_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Ne ame aɖe ƒo ame aɖe sesĩe ale gbegbe be wòku la, ekema ele be woawui. ");
INSERT INTO ewe_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Ke ne amea meɖo be yeawu ame o, gake Mawu ɖe mɔ wòva eme la, ekema mafia teƒe aɖe wòasi ayi, eye wòakpɔ sitsoƒe. ");
INSERT INTO ewe_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Gake ne ame aɖe dze nɔvia dzi kple tameɖoɖo be yeawui la, ekema ne ele nye vɔsamlekpui ŋgɔ gɔ̃ hã la, ele be miahee ado goe, awui. ");
INSERT INTO ewe_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Ele be woawu ame sia ame si aƒo fofoa alo dadaa. ");
INSERT INTO ewe_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Ne ame aɖe fi ame la, ele be woawui ne wokpɔ ame si wòfi la le egbɔ loo alo ne edzrae abe kluvi ene xoxo. ");
INSERT INTO ewe_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Ele be woawu ame sia ame si ado vlo dadaa alo fofoa alo aƒo fi ade wo dometɔ aɖe. ");
INSERT INTO ewe_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Ne ame eve le avu wɔm, eye ɖeka ƒu kpe nɔvia alo tu kɔe, eye wòwɔ nuvevii wòle be wòatsi aba dzi, gake meku o, ");
INSERT INTO ewe_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ne egate ŋu zɔ emegbe kple atizɔti gɔ̃ hã la, womahe to aɖeke na ame si ƒoe la o, ɖeko woana wòaxe fe ɖe ɣeyiɣi si wògblẽ la ta va se ɖe esime eƒe lãme nasẽ nyuie; ele be wòaxe eƒe dɔdaƒe hã. ");
INSERT INTO ewe_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Ne ame aɖe ƒo eƒe kluvi alo kosivi wòku ɖe eƒe asi me la, woahe to nɛ kokoko. ");
INSERT INTO ewe_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ke ne kluvi la alo kosivi la meku le ŋkeke ʋɛ aɖewo megbe o la, ekema mele be woahe to aɖeke na aƒetɔ la o, elabena eya ŋutɔ tɔe nye kluvi la alo kosi la. ");
INSERT INTO ewe_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Ne ŋutsu eve le avu wɔm, eye le avu la wɔwɔ me la, avuwɔla ɖeka wɔ nuvevi funɔ aɖe, eye fua gblẽ nɛ, gake meku o la, ekema woana ŋutsu la naxe fe sia fe si funɔ la srɔ̃ abla nɛ, eye ʋɔnudrɔ̃lawo alɔ̃ ɖe edzi nɛ. ");
INSERT INTO ewe_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Ke ne nuveviwɔame aɖe ana funɔ la naku la, woawu ame si wɔ nuvevi lae. ");
INSERT INTO ewe_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","“Ŋku ɖe ŋku teƒe, aɖu ɖe aɖu teƒe, asi ɖe asi teƒe, afɔ ɖe afɔ teƒe, ");
INSERT INTO ewe_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","dzobi ɖe dzobi teƒe, abi ɖe abi teƒe, kabi ɖe kabi teƒe. ");
INSERT INTO ewe_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Ne ame aɖe ƒo ŋku na eƒe kluvi alo kosi, eye ŋku la tsi la, ekema kluvi la alo kosi la azu ablɔɖeme le eƒe ŋku la ta. ");
INSERT INTO ewe_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ne aƒetɔ aɖe ŋe aɖu na eƒe kluvi la, ele be wòaɖe asi le kluvi la ŋu le eƒe aɖu si ŋe la ta. ");
INSERT INTO ewe_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Ne nyi aɖe tu dzo ŋutsu aɖe alo nyɔnu aɖe wòku la, woaƒu kpe nyi la wòaku; womaɖu eƒe lã o, eye womabia nya aɖeke ame si ƒe nyi wònye o. ");
INSERT INTO ewe_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ke ne amewo nya be nyi la nɔa dzo tum ame, eye wona nyanya nyitɔ la, gake mekpɔ nyi la dzi nyuie o la, ekema ne nyi la wu ame aɖe la, woaƒu kpe nyi la wòaku, eye woawu nyitɔ la hã. ");
INSERT INTO ewe_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ke ne ƒometɔwo lɔ̃ la, woaxe fe si dzi ʋɔnudrɔ̃lawo alɔ̃ ɖo, ekema womagawu nyitɔ la o. ");
INSERT INTO ewe_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“Woazɔ ɖe se sia ke dzi ne nyi aɖe wu ŋutsuvi alo nyɔnuvi. ");
INSERT INTO ewe_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ke ne nyi la wu kluvi alo kosivi la, ekema woaxe klosalo blaetɔ̃ na kluvi la alo kosi la ƒe aƒetɔ, eye woaƒu kpe nyi la wòaku. ");
INSERT INTO ewe_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Ne ame aɖe ɖe vudo, metu nu enu o, eye ame aɖe ƒe nyi alo tedzi ge ɖe eme la, ");
INSERT INTO ewe_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ekema ame si ƒe vudo wònye la axe fe na nyitɔ ɖe lã la ta, eye lã kuku la azu vudotɔ tɔ. ");
INSERT INTO ewe_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Ne ame aɖe ƒe nyitsu tu dzo ame bubu ƒe nyitsu wòku la, ekema nyitɔ eveawo adzra nyi gbagbe la, ama ga la, eye woama nyi kuku la hã ƒe lã sɔsɔe. ");
INSERT INTO ewe_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ke ne amewo nya be nyi la tua dzo nyi bubuwo, eye wona nyitɔ la nya, gake mekpɔ nyi la dzi nyuie o la, ekema nyitɔ la maxɔ ga si wokpɔ tso nyi gbagbe la dzadzra me ƒe ɖeke o, ke boŋ axe fe ɖe nyi kuku la ta, eye wòazu etɔ.” ");
INSERT INTO ewe_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Ne ame aɖe fi nyi alo alẽ, eye wòwui alo dzrae la, ele be fiafitɔ la natsɔ nyi atɔ̃ aɖo nyi ɖeka si wòfi la teƒe, eye wòatsɔ alẽ ene aɖo alẽ ɖeka teƒe. ");
INSERT INTO ewe_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Ne wolé fiafitɔ aɖe wònɔ gegem ɖe ame aɖe ƒe aƒe me be yeafi fi le zã me, eye wowui la, amewula la medze agɔ o. ");
INSERT INTO ewe_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ke ne nya sia dzɔ le ŋkeke me la, ekema woatsɔe abe amewuwu ene, eye ame si wui la dze agɔ. “Ne wolé fiafitɔ aɖe la, ele be wòaɖo nu si wòfi la teƒe pɛpɛpɛ. Ne mete ŋui o la, ekema ele be woadzrae wòazu kluvi ɖe fe la nu. ");
INSERT INTO ewe_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Ne wolée wòle nyi, tedzi, alẽ alo nu bubu aɖe fim la, ele be wòaxe nu si fim wòle la ƒe home teƒe eve. ");
INSERT INTO ewe_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Ne ame aɖe nya hafi ɖe asi le eƒe lã aɖe ŋu wòge ɖe ame bubu ƒe waingble me alo wòna wòyi ame bubu ƒe lãwo ƒe gbeɖuƒe la, ele be wòatsɔ eƒe agblemenuku nyuitɔwo aɖo nu siwo eƒe lã la gblẽ la teƒe wòasɔ gbɔ ade nugbegblẽ la nu. ");
INSERT INTO ewe_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Ne ame aɖe tɔ dzo gbe le eƒe anyigba dzi, eye dzo la yi ɖabi agblemenuku siwo woxa da ɖi loo alo esiwo womexa haɖe o le ame bubu ƒe agble me la, ele be ame si tɔ dzo gbea la naxe fe ɖe nu siwo katã dzo la gblẽ la ta. ");
INSERT INTO ewe_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Ne ame aɖe tsɔ ga alo adzɔnuwo na ame aɖe be wòadzra ɖo na ye eye wofi wo la, ne wolé fiafitɔ la la, ele be wòaxe nu si wòfi la ƒe home teƒe eve. ");
INSERT INTO ewe_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ke ne womenya fiafitɔ la o la, ekema woakplɔ ame si si wotsɔ ga la alo adzɔnuawo dee la ayi Mawu ŋkume be Mawu naɖee afia nenye eya ŋutɔe fi nɔvia ƒe nuawo loo alo menye eyae o. ");
INSERT INTO ewe_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“Le go ɖe sia ɖe si me ne nyi, tedzi, alẽ, awu, avɔ alo nu bubu aɖe bu, eye nutɔ xɔe se be yekpɔe le ame bubu aɖe si eye amea sẽ nu la, ame eve siawo ado ɖe Mawu ŋkume be Mawu natso nya me. Ame si Mawu bu fɔe la axe nu bubu la ƒe fe teƒe eve na ame evelia. ");
INSERT INTO ewe_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Ne ame aɖe tsɔ tedzi, nyi, alẽ alo lã bubu aɖe na nɔvia be wòakpɔ edzi na ye, eye lã la ku, alo nuvevi wɔe alo wòsi, eye ame aɖeke menya nu si tututue wɔe, eye woate ŋu aɖi ɖase le eŋu o la, ");
INSERT INTO ewe_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ekema lã la dzi kpɔla aka atam na Yehowa be menye yee fii o. Ele na nutɔ la be wòaxɔ atamkaka sia, eye teƒeɖoɖo aɖeke manɔ anyi o. ");
INSERT INTO ewe_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ke nenye ɖe wofi lã la alo nua la, ekema ele be dzikpɔla la naɖo eteƒe na nutɔ. ");
INSERT INTO ewe_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Nenye lã wɔadã aɖee wui la, ekema ele be dzikpɔla la natsɔ lã la ƒe kukua vɛ abe ɖaseɖiɖi kple kpeɖodzi ene. Ekema teƒeɖoɖo aɖeke mahiã o. ");
INSERT INTO ewe_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Ne ame aɖe ɣe nɔvia ƒe lã alo nu bubu aɖe, eye nuvevi wɔ lã la alo wòku la, ne nutɔ menɔ afi ma ɣe ma ɣi o la, ekema ele be ame si ɣee la naxe fe ɖe eta. ");
INSERT INTO ewe_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ke ne nutɔ le teƒea la, womaxe fe aɖeke nɛ o. Nenye be ɖe wòɣe lã la be yeanɔ fe xem ɖe eta la, ekema mele be wòaxe fe bubu aɖeke na nutɔ o, elabena wobu lã la ƒe ku kple nuvevi si ate ŋu awɔe la ŋu hafi ƒo asi la. ");
INSERT INTO ewe_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Ne ŋutsu aɖe dɔ nyɔnuvi aɖe si ŋugbe womedo na ŋutsu aɖeke o gbɔ la, ele be ŋutsu la natsɔ tabianuwo na edzilawo, eye wòaɖe nyɔnuvi la. ");
INSERT INTO ewe_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ke ne nyɔnuvi la fofo gbe gbidigbidi be ye vi maɖe ŋutsu la o hã la, ele be ŋutsu la nana tabianuawo kokoko. ");
INSERT INTO ewe_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Ele be woawu nyɔnu si nye nukala la. ");
INSERT INTO ewe_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Ele be woawu ŋutsu si dɔ lã aɖe gbɔ la kokoko. ");
INSERT INTO ewe_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Ele be woawu ame sia ame si sa vɔ na mawu, si menye Yehowa o la godoo. ");
INSERT INTO ewe_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Mele be miate amedzro aɖeke ɖe to le go aɖeke me o; miɖo ŋku edzi be miawo hã mienye amedzrowo kpɔ le Egiptenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Mele be miaba ahosiwo kple tsyɔ̃eviwo o. ");
INSERT INTO ewe_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Ne mieba wo le mɔ aɖe nu, eye wodo ɣli bia nye kpekpeɖeŋu la, makpe ɖe wo ŋu godoo. ");
INSERT INTO ewe_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ekema mado dɔmedzoe ɖe mia ŋu, eye mana futɔwo ƒe aʋakɔwo nawu mi ale be mia srɔ̃wo nazu ahosiwo, eye mia viwo nazu tsyɔ̃eviwo. ");
INSERT INTO ewe_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ne nɔviwò Hebritɔ aɖe le xaxa me, eye nèdo ga nɛ la, mele be nàxɔ deme le esi abe ale si nàxɔ le ame bubu si ene o. ");
INSERT INTO ewe_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ne èxɔ eƒe avɔ abe awɔbanu ene la, ele be nàgbugbɔe nɛ le fiẽ me, ");
INSERT INTO ewe_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","elabena ɖewohĩ avɔ ma koe nye vuvɔxenu le esi. Aleke wòate ŋu adɔ alɔ̃e ne avɔ la mele esi o? Ne mètrɔ avɔ la nɛ o, eye wòdo ɣli bia nye xɔname la, masee, eye mave enu, elabena amenuvelae menye. ");
INSERT INTO ewe_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Mègado vlo wò Mawu o eye mègaƒo fi de wò dukɔ ƒe kplɔlawo o. ");
INSERT INTO ewe_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Ele be nàtsɔ wò agblemenukuwo kple wò wain ƒe ewolia nam. “Nàƒle wò viŋutsuvi ŋgɔgbetɔ ta. Mègahe nu siawo wɔwɔ ɖe megbe o. ");
INSERT INTO ewe_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","“Na wò nyiwo kple alẽwo ƒe ŋgɔgbeviwo nanɔ wo dadawo gbɔ ŋkeke adre, eye nàtsɔ wo nam le ŋkeke enyilia gbe. ");
INSERT INTO ewe_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Esi miele kɔkɔe, eye mienye nye dukɔ tɔxɛ ta la, migaɖu lã aɖeke si lã wɔadã aɖe wu o. Migblẽ lã sia ƒe kukua ɖi na avuwo woaɖu.” ");
INSERT INTO ewe_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Mègakaka aʋatsonyawo o, eye mègaɖu aʋatsoɖasefo na ame vɔ̃ɖi o. ");
INSERT INTO ewe_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Mègadze amehawo yome le nu vɔ̃ wɔwɔ me o, eye ne woyɔ wò ɖasefoe le nya aɖe me la, mègatrɔ nyateƒe la ƒe ta tu be ne yeadze amehawo ŋu o, ");
INSERT INTO ewe_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","eye mègaɖe ami ɖe nya la be ne wò ɖaseɖiɖi la nade ame aɖe dzi le eƒe amedahenyenye ta o. ");
INSERT INTO ewe_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Ne èkpɔ wò futɔ aɖe ƒe nyi alo tedzi si tra mɔ la, ele be nàkplɔe ayi na nutɔ. ");
INSERT INTO ewe_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ne agba te wo futɔ ƒe tedzi ɖe to, eye nèkpɔ wò futɔ wòle agbagba dzem be yeado alɔ tedzi la wòatsi tsitre la, mele be nàtso eme adzo o, ke boŋ ele be nàkpe ɖe eŋu. ");
INSERT INTO ewe_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Mègana ame aɖeke ƒe ahedada nana nàtrɔ eƒe nya dzɔdzɔe wòazu nya gbegblẽ o. ");
INSERT INTO ewe_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“Mègada alakpa ɖe ame aɖeke si be ewɔ vɔ̃ o. Mègana woawu ame maɖifɔ gbeɖe o. Nyemalɔ̃ ɖe nuwɔna vɔ̃ɖi sia dzi o. ");
INSERT INTO ewe_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Mègaxɔ zãnu o, elabena zãnuxɔxɔ nana be màdze si nu si le dzedzem gãa o. Zãnuxɔxɔ gblẽa nu le ame si ƒe nya dzɔ la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Mègate amedzrowo ɖe to o, wò ŋutɔ ènya nu si amedzronyenye nye. Ɖo ŋku wò nuteƒekpɔkpɔwo le Egipte dzi. ");
INSERT INTO ewe_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Miƒã nu, eye miaŋe nu ƒe ade, ");
INSERT INTO ewe_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ke migblẽ anyigba la ɖi wòadzudzɔ le ƒe adrelia me. Mina ame dahe siwo le mia dome la naxa nuku siwo mieɖe le miaƒe agble dzi le wo ɖokuiwo si, eye migblẽ nuku siwo susɔ la ɖi na lãwo woaɖu. Se sia ke ku ɖe miaƒe waingblewo kple amitivewo hã ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Miwɔ dɔ ŋkeke ade ko, eye miadzudzɔ le ŋkeke adrelia dzi. Miwɔ alea ale be miana dzudzɔ miaƒe nyiwo kple tedziwo kple miaƒe aƒemetɔwo, kluviwo kple amedzrowo siaa. ");
INSERT INTO ewe_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Mikpɔ egbɔ be miewɔ se siawo katã dzi. Miɖo ŋku edzi, migayɔ mawu bubu aɖeke ƒe ŋkɔ le gbedodoɖa alo atamkaka me o.” ");
INSERT INTO ewe_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Mawusubɔsubɔ ƒe ŋkekenyui etɔ̃e li wòle be miaɖu ƒe sia ƒe. ");
INSERT INTO ewe_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Gbãtɔe nye Abolo Maʋamaʋã ƒe Ŋkekenyui. Migaɖu abolo si wowɔ kple amɔ ʋaʋã o ŋkeke adre abe ale si mede se na mi kpɔ ene. Ŋkekenyui sia ɖuɖu anɔ edzi ƒe sia ƒe le Tedoxe si nye ɣleti si me miedzo le Egipte. “Ame sia ame asa vɔ nam le ɣeyiɣi sia me. ");
INSERT INTO ewe_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Eveliae nye Nuŋeŋeŋkekenyui. Ele be miatsɔ miaƒe agblemenuku gbãtɔwo vɛ nam. “Etɔ̃liae nye Ƒuƒoƒo Nukuwo ƒe Ŋkekenyui si miaɖu le nuŋeɣi ƒe nuwuwu. ");
INSERT INTO ewe_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Le ŋkekenyui etɔ̃ siawo katã ɖuɣiwo, le ƒe sia ƒe me la, ele be Israel ŋutsu ɖe sia ɖe nado ɖe Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Megakpe nye vɔsalãwo ƒe ʋu ɖe abolo si woƒo kple amɔ ʋaʋã la ŋu o. “Megana vɔsalã aɖeke ƒe ami natsi anyi ŋu nake ɖe edzi o. ");
INSERT INTO ewe_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Ne èxa wò agblemenukuwo la, ele be nàtsɔ wò ŋkeke gbãtɔ ƒe nuku nyuitɔwo ƒe ɖe va Yehowa, wò Mawu ƒe aƒe me. “Mègaɖa gbɔ̃vi le dadaa ƒe notsi me o. ");
INSERT INTO ewe_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Kpɔ ɖa, mele Mawudɔla aɖe dɔm ɖe ŋgɔwò be wòakplɔ wò dedie ayi anyigba si medzra ɖo ɖi na wò la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Vɔ̃e, eye nàwɔ eƒe ɖoɖowo katã dzi. Mègadze aglã ɖe eŋu o, elabena matsɔ wò nu vɔ̃wo ake wò o. Eyae nye nye teƒenɔla, eye nye ŋkɔ le eŋu. ");
INSERT INTO ewe_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ke ne èɖɔ ŋu ɖo, ɖo toe, eye nèwɔ nye Sewo katã dzi la, ekema manye futɔ na wò futɔwo, ");
INSERT INTO ewe_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","elabena nye Dɔla adze ŋgɔ na wò, akplɔ wò ayi Amoritɔwo, Hititɔwo, Perizitɔwo, Kanaantɔwo, Hivitɔwo kple Yebusitɔwo ƒe anyigba dzi be mianɔ afi ma. Matsrɔ̃ dukɔ siawo ɖa le ŋgɔwò. ");
INSERT INTO ewe_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“Mègasubɔ dukɔ bubu siawo ƒe mawu alo asa vɔ na wo le mɔ aɖeke nu o, eye mègadze trɔ̃subɔdukɔ siawo ƒe kpɔɖeŋu vɔ̃ɖiwo yome o. Ele na wò be nàɖu wo dzi, eye nàgbã woƒe legbawo. ");
INSERT INTO ewe_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","“Subɔ Yehowa, wò Mawu la ɖeɖe ko, ekema mayra wò kple nuɖuɖu kple tsi, eye maɖe dɔléle ɖa le mia dome. ");
INSERT INTO ewe_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Fu mage le nyɔnuwo ƒo o, kotsitsi manɔ anyigba blibo la dzi o, eye ànɔ agbe ŋkeke ale si meɖo na wò. ");
INSERT INTO ewe_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Mana vɔvɔ̃ si le ŋunye la nalé dukɔ siwo katã ƒe anyigba ŋu miaho aʋa ɖo, woasi le mia ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Maɖo nudzodzoe teamewo ɖa woanya Hivitɔwo, Kanaantɔwo kple Hititɔwo ɖa le ŋgɔwò. ");
INSERT INTO ewe_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Nyemawɔ esiawo katã le ƒe ɖeka me o. Ne menye nenema o la, anyigba la ava zu gbedadaƒo, eye lã wɔadãwo ava sɔ gbɔ akpa. ");
INSERT INTO ewe_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ke manɔ wo nyam ɖa vivivi va se ɖe esime wò amewo adzi axɔ anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Mana wò anyigba ƒe liƒowo natso Ƒu Dzĩ la nu ayi Filistitɔwo ƒe ƒu la nu, eye wòagatso gbegbe siwo le anyigbeme va se ɖe Frat tɔsisi la nu. Mana nàɖu ame siwo katã le anyigba la dzi fifia la dzi, eye mana woasi le ŋgɔwò. ");
INSERT INTO ewe_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“Mègawɔ nubabla aɖeke kpli wo loo alo nàna kadodo aɖeke nanɔ wò kple woƒe mawuwo dome o. ");
INSERT INTO ewe_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Mègana woanɔ mia dome o, elabena menya be woana miadze woƒe mawuwo subɔsubɔ ƒe nu vɔ̃ me; esia anye mɔtetre na mi, eye wòahe dzɔgbevɔ̃e gã va mia dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Azɔ la, Yehowa gblɔ na Mose be, “Kplɔ Aron, Nadab kple Abihu kple Israel ƒe ametsitsi blaadre, eye mialia to la. Ame mamlɛawo anɔ adzɔge, eye woasubɔm. ");
INSERT INTO ewe_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Wò, Mose, koe ate ɖe ŋunye. Ɖo ŋku edzi be Israelvi bubuawo mekpɔ mɔ alia to la kura o.” ");
INSERT INTO ewe_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mose ɖe gbeƒã se kple ɖoɖo siwo katã Yehowa de asi nɛ la na dukɔ la. Ameawo katã ɖo eŋu kple gbe ɖeka be, “Míawɔ seawo katã dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mose ŋlɔ Yehowa ƒe seawo katã da ɖi. Esi ŋu ke ŋdi kanya la, etu vɔsamlekpui aɖe ɖe to la te, eye wòɖo dzesidekpe wuieve ƒo xlã vɔsamlekpui la, elabena to wuievee wɔ Israel dukɔ la. ");
INSERT INTO ewe_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Le esia megbe la, eɖo Israelvi ɖekakpui aɖewo ɖa be woasa numevɔsa eye woatsɔ nyitsuwo awɔ akpedavɔsa na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mose kɔ vɔsalã siawo ƒe ʋu ƒe afã ɖe zewo me, eye wòhlẽ afã mamlɛa ɖe vɔsamlekpui la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Mose tsɔ agbalẽ si me nublanyawo le eye wòxlẽe na ameawo, eye ameawo gagblɔ be, “Míawɔ nu sia nu si Yehowa gblɔ na mi la, eye míalé eme ɖe asi.” ");
INSERT INTO ewe_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mose ku lãwo ƒe ʋu tso zeawo me hlẽ ɖe ameawo dome hegblɔ be, “Ʋu sia ɖo kpe nubabla si Yehowa wɔ kpli mí to Se siawo nana mí me la dzi, eye wòtre nubabla la nu.” ");
INSERT INTO ewe_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Le esia megbe la, Mose, Aron, Nadab, Abihu kple Israel ƒe ametsitsi blaadreawo lia to la. ");
INSERT INTO ewe_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Wokpɔ Israel ƒe Mawu la. Teƒe si wòtsi tsitre ɖo la dze abe safirkpe keklẽ siwo me kɔ abe dziŋgɔli me la ene. ");
INSERT INTO ewe_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Togbɔ be Israel ƒe ametsitsiwo kpɔ Mawu hã la, metsrɔ̃ wo o. Emegbe la, woɖu nu kple wo nɔewo le eŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Eye Yehowa gblɔ na Mose be, “Va gbɔnye le to la dzi, eye nànɔ afi ma va se ɖe esime matsɔ Se siwo meŋlɔ ɖe kpewo dzi la ana wò, ale be nàte ŋu akpɔ wo dzi, afia seawo dukɔ la.” ");
INSERT INTO ewe_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ale Mose kple eƒe kpeɖeŋutɔ, Yosua lia Mawu ƒe to la. ");
INSERT INTO ewe_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mose gblɔ na ametsitsiawo be, “Minɔ afi sia, eye mialala mí va se ɖe esime míatrɔ agbɔ. Ne nya sesẽ aɖe ado ta ɖa la, ekema mitsɔ nya la ɖo Aron kple Hur ŋkume.” ");
INSERT INTO ewe_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mose lia to la, eye wòbu ɖe lilikpowo me le to la tame. ");
INSERT INTO ewe_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Yehowa ƒe ŋutikɔkɔe dze ɖe Sinai to la dzi, eye lilikpo la tsyɔ to la dzi ŋkeke ade. Le ŋkeke adrelia gbe la, Yehowa yɔ Mose tso lilikpo la me. ");
INSERT INTO ewe_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Israelvi siwo nɔ to la te la kpɔ nu dziŋɔ sia teƒe. Yehowa ƒe ŋutikɔkɔe dze na wo le toa tame abe dzo bibi ene. ");
INSERT INTO ewe_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mose bu ɖe lilikpo si tsyɔ to la tame la me, eye wònɔ afi ma ŋkeke blaene kple zã blaene. ");
INSERT INTO ewe_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Gblɔ na Israelviwo be ame sia ame si alɔ̃ la, natsɔ nunana siawo dometɔ aɖewo vɛ nam. ");
INSERT INTO ewe_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Sika, klosalo, akɔbli, ");
INSERT INTO ewe_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","avɔ si nye blɔtɔ, avɔ dzĩ, aklala, gbɔ̃fuwo, ");
INSERT INTO ewe_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","agbogbalẽ si wode ama dzĩ, gbɔ̃gbalẽ, akasiati, ");
INSERT INTO ewe_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ami na akaɖiwo, amiʋeʋĩ hena amisisi kple numeme ʋeʋĩ, ");
INSERT INTO ewe_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","onikskpe siwo woatsɔ aɖo kɔmewu kple akɔtaɖonu ŋu, ");
INSERT INTO ewe_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","elabena medi be Israelviwo natu nɔƒe kɔkɔe aɖe nam, afi si manɔ le wo dome. ");
INSERT INTO ewe_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","“Nye nɔƒe sia anye agbadɔ. Mafia ale si nàtui kple nu siwo nàtsɔ aɖo atsyɔ̃ nɛ la wò. ");
INSERT INTO ewe_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Tsɔ akasiati nàkpa aɖaka wòadidi sentimita alafa ɖeka kple ewo, wòakeke sentimita blaade-vɔ-ade, eye wòakɔ sentimita blaade-vɔ-ade. ");
INSERT INTO ewe_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Fa sika nyuitɔ ɖe eme kple egodo siaa, eye nàtsɔ sika nyuitɔ ke amli ɖe aɖaka la togawo kpe ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Wɔ sikagagɔdɔ̃e ene siwo anɔ abe asigɛ ene, eye nàklã wo ɖe dzogoe ene siwo le ete la ŋu; sikagagɔ̃dɔ̃e eve nanɔ aɖaka la ƒe axa ɖe sia ɖe. ");
INSERT INTO ewe_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Tsɔ akasiati kpa kpo didiwo, eye nàfa sika nyuitɔ ɖe wo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Tsɔ wo ƒo ɖe asigɛ eve siwo le aɖaka la ƒe axa ɖeka dzi la me hena aɖaka la tsɔtsɔ. ");
INSERT INTO ewe_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Womaɖe ati siawo le sikasigɛawo me o, ke boŋ woanɔ wo me ɖaa. ");
INSERT INTO ewe_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Ekema nàtsɔ nubabla si matsɔ na wò la ade aɖaka la me. ");
INSERT INTO ewe_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Tsɔ sika nyuitɔ wɔ nublanuikpɔkpɔzikpui si adidi sentimita alafa ɖeka kple ewo, eye wòakeke sentimita blaadre-vɔ-ade. ");
INSERT INTO ewe_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Tsɔ sika wɔ kerubi eve, eye nàklã wo ɖe nutunu la ƒe didime ƒe nuwo. ");
INSERT INTO ewe_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Wɔ kerubi ɖeka kple amenuvevezikpui la, eye ɖeka anɔ nutunu la ƒe didime ƒe nu ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kerubiawo adze ŋgɔ wo nɔewo, eye woanɔ amenuvevezikpui la gbɔ kpɔm. Woakeke woƒe aʋalãwo ɖe sikanutunu la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Tsɔ nutunu la tu aɖaka la nu, eye nàtsɔ kpe siwo dzi woŋlɔ seawo ɖo siwo matsɔ na wò la de aɖaka la me. ");
INSERT INTO ewe_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Mado go wò le afi ma, aƒo nu kpli wò le amenuvevezikpui la tame, le kerubi eve siwo le nubablaɖaka tame la dome, eye matsɔ nubablakpe siwo dzi meŋlɔ nye sededewo na Israelviwo ɖo la na wò. ");
INSERT INTO ewe_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Emegbe la, nàtsɔ akasiati akpa kplɔ̃ wòadidi sentimita blaenyi-vɔ-enyi, akeke sentimita blaene-vɔ-ene, eye wòakɔ sentimita blaade-vɔ-ade. ");
INSERT INTO ewe_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Fa sika nyuitɔ ɖe edzi, eye nàfa sika ɖe eto. ");
INSERT INTO ewe_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Tsɔ akasiati si keke milimita blaadre-vɔ-atɔ̃ la ɖo kplɔ̃ la to kpe ɖo, eye nàtsɔ sika afa ɖe akasiati la to. ");
INSERT INTO ewe_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Wɔ sikasigɛ ene na kplɔ̃ la, eye nàklã wo ɖe kplɔ̃ la ƒe axa eneawo dzi, woate ɖe afɔti eneawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Asigɛawo nate ɖe kplɔ̃ la ƒe to lɔƒo be woatsɔ atiwo ade asigɛawo me hena kplɔ̃ la kɔkɔ. ");
INSERT INTO ewe_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Tsɔ akasiati wɔ kplɔ̃kɔtiawo, eye nàfa sika ɖe wo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Wɔ sikagbawo, sikagatsiwo, nutɔgbawo, goewo kple trewo, nu siwo ŋu dɔ wowɔna le kplɔ̃a dzi, ");
INSERT INTO ewe_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","eye nàtsɔ Ŋkumeɖobolo tɔxɛ ada ɖe kplɔ̃ la dzi le nye ŋkume ɣe sia ɣi. ");
INSERT INTO ewe_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Tsɔ sika nyuitɔ wɔ akaɖiti lae. Na akaɖiti blibo la nanye nu ɖeka; ele be woatu akaɖiti la ƒe afɔwo, eƒe titinati diditɔ, akaɖiawo kple seƒoƒoawo nanye nu blibo ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“Alɔ ade nanɔ akaɖiti la ƒe axawo dzi, etɔ̃ nanɔ akaɖiti la ƒe axawo kple eve dzi. ");
INSERT INTO ewe_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kplu etɔ̃ siwo wowɔ abe yevuzi ƒe seƒoƒo siwo do, eye woke ene la nanɔ alɔdze ɖeka ŋu, etɔ̃ nanɔ alɔdze bubu ŋu. Nenema ke wòanɔ na alɔdze adeawo siwo katã le akaɖiti la kɔgo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Kplu ene siwo wowɔ abe yevuzi ƒe seƒoƒo si do, eye wòke ene la nanɔ akaɖiti la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Seƒoƒo ɖeka kple eƒe tamekuku nanɔ alɔdze eve ƒe kpeƒe; ɖeka nanɔ alɔdze eve siwo kplɔ gbãtɔ ɖo la ƒe kpeƒe, eye ɖeka hã nanɔ etɔ̃lia ƒe kpeƒe, ale be alɔdzeawo nanye ade. ");
INSERT INTO ewe_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ele be woawɔ atsyɔ̃ɖonuawo kple alɔdzeawo kple titinati didi la siaa kple sika nyuitɔ woanye nu blibo ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Le esia megbe la, wɔ akaɖi adre na akaɖiti la, eye nàna woaklẽ ɖe ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Tsɔ sika nyuitɔ wɔ ɖovulãnuwo, eye nàtsɔ eya ke awɔ agba vi siwo me woada wo ɖo la. ");
INSERT INTO ewe_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Sika nyuitɔ si ŋu dɔ woawɔ na akaɖiti la kple eŋunuwo la ƒe kpekpeme nade kilogram blaetɔ̃ vɔ atɔ̃. ");
INSERT INTO ewe_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","“Kpɔ egbɔ be nu sia nu sɔ ɖe nu si mele fiawòm le toa dzi la dzi tututu.” ");
INSERT INTO ewe_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Tsɔ avɔ ewo siwo wolɔ̃ kple ka nyuiwo, aɖabɛka blɔtɔ kple dzĩtɔ kple ka dzĩ la wɔ agbadɔ la, eye nàlɔ̃ Kerubiwo aɖaŋutɔe ɖe eme. ");
INSERT INTO ewe_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Avɔ ɖe sia ɖe nadidi mita wuieve, eye wòakeke mita eve. ");
INSERT INTO ewe_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Woatɔ avɔ atɔ̃, didime ɖe didime nu woazu avɔ ɖeka na agbadɔ la ƒe axa ɖeka. Woawɔ nenema ke kple avɔ atɔ̃ bubuawo hã. ");
INSERT INTO ewe_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tɔ aɖabɛka blɔtɔ kpuikpuikpui blaatɔ̃ ɖe xɔgbãvɔ ɖe sia ɖe ƒe axa ɖeka ƒe didime, na be gbãtɔ ƒe kawo nasɔ ɖe evelia tɔwo nu. ");
INSERT INTO ewe_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Tɔ ka kpuikpuikpui blaatɔ̃ ɖe avɔ la ƒe go eve me, eye ka siwo le avɔwo me la nasɔ ɖe wo nɔewo dzi le go eveawo me. ");
INSERT INTO ewe_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Tsɔ sika tu gavi blaatɔ̃ nàtsɔ ku avɔ eveawo ƒe nuwo ƒo ƒui ale be agbadɔ la, si nye Mawu ƒe nɔƒe la, nazu nu blibo ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Tsɔ avɔ titri siwo wolɔ̃ kple gbɔ̃fu la ƒe teƒe wuiɖekɛ gbã agbadɔ la. ");
INSERT INTO ewe_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Avɔ wuiɖekɛawo katã nasɔ; ɖe sia ɖe nadidi mita wuietɔ̃, eye wòakeke mita eve. ");
INSERT INTO ewe_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Tɔ gbɔ̃fuvɔ atɔ̃ woazu avɔ keke ɖeka, eye nàgatɔ ade mamlɛawo hã woazu avɔ keke ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ŋlɔ gbɔ̃fuvɔ adelia ɖe akpa eve le agbadɔ la ŋgɔ. Tɔ avɔ kpuikpuikpui blaatɔ̃ ɖe to na agbadɔ la ƒe axa ɖeka, eye nàgawɔe nenema ke ɖe axa evelia to le akpa kemɛ. ");
INSERT INTO ewe_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tu gavi blaatɔ̃ kple akɔbliga, eye nàtsɔ wo de ka kpuiwo me ate avɔawo akpe be avɔ keke eveawo nazu avɔ keke gã ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ke hena avɔ si le agbadɔ la megbe la, woatsɔ avɔ afã si susɔ la atsi ɖe agbadɔ la megbe. ");
INSERT INTO ewe_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Agbadɔwɔvɔ la nadidi mita eve le axa eveawo dzi, akpa mamlɛa naxe agbadɔ la ƒe axawo dzi be woaxe teƒeawo. ");
INSERT INTO ewe_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tsɔ agbogbalẽ siwo woɖa kple ama dzĩ la tsyɔ gbɔ̃fuvɔawo dzi, eye nàgatsɔ gbɔ̃gbalẽwo atsyɔ alẽgbalẽawo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Tsɔ akasiati wɔ agbadɔ la ƒe ʋuƒowo, axadzitiwo kple daɖedziwo. ");
INSERT INTO ewe_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ʋuƒo siwo woatu anyi la nadidi mita ene, eye woakeke sentimita blaade-vɔ-ade. ");
INSERT INTO ewe_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ɖe do ɖe atiawo ƒe nugbɔwo ale be woate ŋu atɔ ati eve ɖe wo nɔewo nu nyuie. ");
INSERT INTO ewe_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ʋuƒo blaeve nanɔ agbadɔ la ƒe dziehe lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Woatsɔ klosalo awɔ afɔti blaene ɖe atiawo te: afɔti eve nanɔ ati ɖe sia ɖe te. ");
INSERT INTO ewe_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Sɔti blaeve nanɔ agbadɔ la ƒe anyiehe gome hã. ");
INSERT INTO ewe_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Zɔ blaene siwo wotu kple klosaloga la nanɔ sɔtiawo te, eve nanɔ ɖe sia ɖe te. ");
INSERT INTO ewe_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Sɔti ade nanɔ agbadɔ la ƒe ɣetoɖoƒe lɔƒo. Afi siae nye agbadɔ la megbe, ");
INSERT INTO ewe_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","eye sɔti eve nanɔ dzogoe ɖe sia ɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Woatsɔ sikasigɛwo alé sɔtiawo kple dzogoedzitɔwo siaa ɖekae le eƒe dzigbe kple anyigbe siaa. ");
INSERT INTO ewe_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ale sɔti enyi nanɔ agbadɔ la ƒe akpa ma lɔƒo: klosalofɔti wuiade nanɔ wo te. Ale klosalofɔti eve nanɔ ʋuƒo ɖe sia ɖe te. ");
INSERT INTO ewe_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Dze akasiati tsɔ ɖo sɔtiawo ŋu. Atɔ̃ nanɔ agbadɔ la ƒe axa ɖeka dzi; ");
INSERT INTO ewe_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","gameti atɔ̃ hã na sɔti siwo le agbadɔ la ƒe akpa evelia kple gameti atɔ̃ na ʋuƒo siwo le ɣetoɖoƒe lɔƒo le agbadɔ la ƒe ŋgɔgbe ɖaa. ");
INSERT INTO ewe_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Na daɖedzi titinatɔwo nade nu wo nɔewo me aƒo xlã agbadɔ blibo la. ");
INSERT INTO ewe_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Fa sika ɖe ʋuƒoawo ŋu nàtsɔ sika awɔ gaviwo be woalé ʋuƒoawo, eye nàfa sika ɖe daɖedziawo hã ŋuti. ");
INSERT INTO ewe_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tu agbadɔ la ɖe nɔnɔme si mefia wò le to la dzi la nu pɛpɛpɛ. ");
INSERT INTO ewe_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Tsɔ avɔ si wolɔ̃ kple aɖabɛ blɔtɔ kple dzĩtɔ ƒe ka kple ka dzĩ kple ɖetika ɣi la wɔ xɔmetsovɔ, eye nàna aɖaŋudɔwɔla nyuitɔ nalɔ̃ Kerubiwo ɖe eme. ");
INSERT INTO ewe_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Tsi xɔmetsovɔ sia ɖe sɔti ene siwo ŋu wofa sika ɖo la ŋu, ɖe sikagatagbadzɛ ene ŋu. Na sɔti ɖe sia ɖe nanɔ afɔti ene siwo wowɔ kple klosalo la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Tsi xɔmetsovɔ la ɖe sikagatagbadzɛ eneawo ŋu. Tsɔ Aɖaka si me kpe siwo dzi woŋlɔ Mawu ƒe seawo ɖo la da ɖe xɔmetsovɔ sia megbe. Xɔmetsovɔ la ama Kɔkɔeƒe la ɖa tso Kɔkɔeƒe Ƒe Kɔkɔeƒe la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","“Azɔ la, tsɔ amenuveve ƒe nutsyɔnu si nye Aɖaka la ƒe sikanutunu la da ɖe Kɔkɔeƒe Ƒe Kɔkɔeƒe la. ");
INSERT INTO ewe_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Tsɔ kplɔ̃ la da ɖe xɔmetsovɔ la godo le agbadɔ la ƒe anyiehe gome, eye akaɖiti la nadze ŋgɔe le dziehe gome. ");
INSERT INTO ewe_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Tsɔ avɔ si wolɔ̃ aɖaŋutɔe kple aɖabɛ blɔtɔ kple dzĩtɔ ƒe ka, ka dzĩ kple ɖetika ɣi la wɔ xɔmemɔnuvɔ na agbadɔ kɔkɔe la. ");
INSERT INTO ewe_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Tsi xɔmemɔnuvɔ sia ɖe akasiati la ƒe sɔti atɔ̃ siwo ŋu wofa sika ɖo la ŋu, eye nàtsɔ akɔbli awɔ zɔ atɔ̃ ɖe wo te.” ");
INSERT INTO ewe_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Tsɔ akasiati nàkpa vɔsamlekpui lae. Eƒe ta ƒe kekeme kple didime siaa nanye mita ɖeka kple desimita eve, eye wòakɔ mita ɖeka kple desimita etɔ̃. ");
INSERT INTO ewe_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Wɔ lãdzowo ɖe vɔsamlekpui la ƒe dzogoe eneawo dzi, woalé sesĩe ɖe vɔsamlekpui la ŋu. Fa akɔbli ɖe nu sia nu ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Tsɔ akɔbli wɔ vɔsamlekpui la ŋunuwo, afilɔnuwo, sofiwo, gagbɛwo, gafluwo kple dzoɖesonuwo. ");
INSERT INTO ewe_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Tsɔ akɔbli wɔ lãyiga, eye nàwɔ akɔblisigɛ ɖe dzogoe eneawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Klã lãyiga la ɖe mlekpui la titina, eye nàna wòanɔ teƒe si wodoa dzo ɖo la tame. ");
INSERT INTO ewe_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Tsɔ akasiati kpa kpo didiwo, eye nàfa akɔbli ɖe wo ŋu hena vɔsamlekpui la kɔkɔ. ");
INSERT INTO ewe_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Na woatsɔ ati didiawo aƒo ɖe asigɛawo me le vɔsamlekpui la ƒe axawo dzi hena vɔsamlekpui la kɔkɔ. ");
INSERT INTO ewe_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Tsɔ ʋuƒo wɔ vɔsamlekpui la, do nanɔ eme abe ale si meɖee fia wò le to la dzi ene pɛpɛpɛ.” ");
INSERT INTO ewe_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Tɔ kpɔ ɖe agbadɔ la ŋu. Agbadɔ la ƒe dziehe gome nadidi mita blaene-vɔ-ene. Tsɔ avɔ si wolɔ̃ kple ɖeti ɣi dada la tɔ kpɔ siae, ");
INSERT INTO ewe_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","eye nàtu kpɔti blaeve siwo ƒe afɔtiwo woatu kple akɔbliga, eye woatsɔ klosaloga atu gatagbadzɛ siwo woatsɔ avɔawo akui la ɖe kpɔtiawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Woawɔ avɔ la nenema ke le anyiehe gome hã. Woaku avɔ mita blaene-vɔ-ene ɖe klosalogatagbadzɛawo ŋu, ɖe gakawo ŋu le kpɔtiawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ɣetoɖoƒe gome nadidi mita blaeve-vɔ-eve. Kpɔti ewo siwo te afɔti ewo le la nanɔ afi ma. ");
INSERT INTO ewe_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ɣedzeƒe gome afi si ɣe dzena tsona hã nadidi mita blaeve-vɔ-eve. ");
INSERT INTO ewe_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Avɔ si didi mita ade kple afã la nanɔ akpa ɖeka na mɔnu la. Woatsi avɔ la ɖe kpɔti etɔ̃ siwo te afɔti etɔ̃ le la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Avɔ didime ma tɔgbi ke nanɔ agbadɔ la ƒe akpa evelia, eye woatsi eya hã ɖe kpɔti etɔ̃ siwo te afɔti etɔ̃ le la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Avɔ si keke mita asiekɛ la, nanɔ kpɔtɔtɔ la ƒe mɔnu. Avɔ la nanye esi avɔlɔ̃la la lɔ̃ kple ka blɔtɔ, dzĩtɔ kple hẽtɔ, eye woatsii ɖe kpɔti ene siwo te afɔti le ɖekaɖeka la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Woatsɔ klosalogatagbadzɛwo aklã klosalogakawo ɖe kpɔti siwo katã wotsɔ tɔ kpɔ lae la ŋu be woalé kpɔtiawo ɖekae. Akɔblifɔ sesẽwo nanɔ kpɔtiawo te ɖekaɖekae. ");
INSERT INTO ewe_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ale kpɔtɔtɔ la nadidi mita blaene-vɔ-ene, akeke mita blaeve-vɔ-eve. Kpɔtɔtɔ la ƒe avɔ akɔ abe mita eve ene, eye woalɔ̃e kple ɖeti nyuitɔwo. ");
INSERT INTO ewe_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","“Na woatsɔ akɔbli awɔ nu sia nu si woatsɔ ga awɔe le agbadɔ la ŋu: woatsɔ akɔbli awɔ gatagbadzɛawo kple tsyotiawo hã. ");
INSERT INTO ewe_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Gblɔ na Israelviwo be woana amiti ƒe ami nyuitɔ wò nàde akaɖiawo me le agbadɔ la me, ale be akaɖiawo nanɔ bibim ɣe sia ɣi. ");
INSERT INTO ewe_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ele be Aron kple viawo nakɔ akaɖi sia, si womana wòatsi akpɔ o la ada ɖe agbadɔ la me, le xɔmetsovɔ, si xe nublaɖaka ŋkume la ŋgɔ. Woana wòanɔ bibim zã kple keli le Yehowa ŋkume. Esia nye se mavɔ na Israelviwo tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Na woakplɔ nɔviwò ŋutsu Aron vɛ na wò tso Israelviwo dome kpe ɖe via ŋutsuwo Nadab, Abihu, Eleaza kple Itamar ŋu ale be woawɔ dɔ nam abe nunɔlawo ene. ");
INSERT INTO ewe_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Tɔ awu kɔkɔewo na nɔviwò ŋutsu Aron be woade kɔkɔ kple bubu eŋu. ");
INSERT INTO ewe_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Gblɔ na aɖaŋudɔwɔla siwo katã mena nunya le nya siawo tɔgbi me la be woatɔ awuwo na Aron hena eɖoɖo nunɔlae, ale be wòate ŋu awɔ nunɔlawo ƒe dɔ nam. ");
INSERT INTO ewe_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Awu siwo woatɔ la woe nye: akɔtaɖonu, dziwui ʋlaya si ŋu abɔ mele o, eye wòdidi tso abɔta va se ɖe klo te, dziwui, tablanu kple alidziblanu. Woatɔ awu kɔkɔewo na Aron kple via ŋutsuwo be woawɔ nunɔlawo ƒe dɔ nam. ");
INSERT INTO ewe_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","“Na woatsɔ sika, aɖabɛka blɔtɔ, dzĩtɔ kple hɛ̃tɔ kple ɖetika ɣitɔ alɔ̃ awu siawoe. ");
INSERT INTO ewe_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Aɖaŋuvɔlɔ̃la xɔŋkɔwo natsɔ sika, aɖabɛka blɔtɔ, dzĩtɔ kple hẽtɔ kple kadada nyuitɔ alɔ̃ kɔmewu lae. ");
INSERT INTO ewe_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Woatɔe awu evee: ŋgɔgbetɔ kple megbetɔ, eye woakpe wo ɖe abɔta. ");
INSERT INTO ewe_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Woatsɔ avɔ ma tɔgbi ke, aɖabɛka blɔtɔ kple dzĩtɔ kple hẽtɔ kple kadada nyuitɔ ƒe avɔ awɔ alidziblanu la hãe. ");
INSERT INTO ewe_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Emegbe tsɔ onikskpe eve, eye nàŋlɔ Israelviwo ƒe towo ƒe ŋkɔwo ɖe wo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Ŋkɔ ade nanɔ kpe ɖeka dzi, eye woaɖo ŋkɔawo ɖe woƒe tsitsi nu. ");
INSERT INTO ewe_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Tsɔ ŋkɔsigɛ̃wɔnu ŋlɔ Israel ƒe vi wuieveawo ƒe ŋkɔwo ɖe kpe eveawo dzi. Wɔe abe ale si kpe xɔasi nuŋlɔla ŋlɔa nui ɖe ŋkɔsigɛ dzi la ene. Emegbe, nàtsɔ sika afa ɖe towo na kpeawo. ");
INSERT INTO ewe_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Tsɔ kpe eveawo eye tɔ wo ɖe kɔmewu la ƒe abɔtawo hena ŋkuɖoɖo Israelviwo dzi. Na Aron nakpla woƒe ŋkɔwo ɖe abɔta le Yehowa ŋkume abe ŋkuɖodzi ene. ");
INSERT INTO ewe_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Na woatsɔ sika nyuitɔ awɔ sikakawo ");
INSERT INTO ewe_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","kple sikakɔsɔkɔsɔ eve siwo adidi abe ka ene, eye woatsɔ wo aku sikasigɛ siwo le kɔmewu la ƒe abɔtawo. ");
INSERT INTO ewe_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Na aɖaŋuvɔlɔ̃lawo nawɔ akɔtaɖonu si anye nyametsonu; nenɔ abe kɔmewu la tɔgbi ene, eye woawɔe kple sikaka blɔtɔ, ka dzĩ kple ka hẽ kple kadada ɣi. ");
INSERT INTO ewe_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Wɔe ɖe dzogoe ene me, eƒe didime nanye sentimita blaeve-vɔ-eve, eye eƒe kekeme hã nanɔ nenema. Emegbe woaŋee ɖe eve. ");
INSERT INTO ewe_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Tsɔ kpe xɔasiwo ɖo agbaka ene me ɖe eŋu. Kanelian, krisolit kple beril nanɔ fli gbãtɔ me; ");
INSERT INTO ewe_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","tɔkuɔs lapis lazuli kple emerald nanɔ fli evelia me. ");
INSERT INTO ewe_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Yasint, agate kple ametist nanɔ fli etɔ̃lia me. ");
INSERT INTO ewe_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Topaz, oniks kple yaspa nanɔ fli enelia me. Tsɔ sika gbi kae fa ɖe wo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kpeawo katã nanɔ wuieve, ɖe sia ɖe ɖe Israel ƒe viŋutsuwo ƒe ŋkɔ nu. Woaɖe Israelviwo ƒe to wuieveawo ƒe ŋkɔwo ɖe kpeawo dzi ɖekaɖeka abe ŋkɔsigɛ ene. ");
INSERT INTO ewe_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Tsɔ ka si wotsɔ sika nyuitɔ gbie la ɖo akɔtawu la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Wɔ sikagagodo eve nɛ, eye nàtsɔ wo asa ɖe akɔtaɖonu la ƒe dzogoe eve dzi. ");
INSERT INTO ewe_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Tsɔ sikakɔsɔkɔsɔ eve sa ɖe gagodo siwo le akɔtaɖonu la ƒe dzogoe eveawo ŋu la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Na woatɔ sikakɔsɔkɔsɔawo ƒe nu eveliawo ɖe onikskpe eveawo ŋu le akɔtawu la ƒe ŋgɔgbe. ");
INSERT INTO ewe_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Emegbe la, gawɔ sikasigɛ bubu eve, eye nàtsɔ wo aku akɔtawu la te le eme gome. ");
INSERT INTO ewe_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Gawɔ sikasigɛ bubu eve na dziwui ʋlaya la te le eŋgɔ, le alidziblanu la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Azɔ la, tɔ ka blɔtɔwo ɖe akɔtawu la te, eye nàtsɔ kawo atsi ɖe sikasigɛ siwo le dziwui ʋlaya la te la ŋu. Esia ana be akɔtawu la nalé ɖe dziwui la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ale Aron atsɔ Israelviwo ƒe towo ƒe ŋkɔ siwo le akɔtawu la dzi aɖo eƒe dzi gbɔ abe Mawu ƒe nyametsonu ene, ne eyi Teƒe Kɔkɔe la. Nu sia anɔ ŋku ɖom Israelviwo dzi na Yehowa edziedzi.” ");
INSERT INTO ewe_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Tsɔ Urim kple Tumim siwo nye kpe siwo wotsɔna biaa nu Mawu la de akɔtawu la ƒe kotoku me be woanɔ Aron ƒe dzi dzi ne edo ɖe Yehowa ŋkume. Ale Aron atsɔ Israelviwo ƒe nyametsonu la ɖe eƒe dzi dzi ne edo ɖe Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Tsɔ avɔ blɔtɔ tɔ awu ʋlaya si le kɔmewu la te, ");
INSERT INTO ewe_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","eye woaɖe teƒe si Aron ƒe ta nato la ɖi. Woatɔ avɔ aƒo xlã teƒe sia, abe ale si wowɔna na akpoxɔnuwo ene, ale be mavuvu o. ");
INSERT INTO ewe_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Woatsɔ aɖabɛka blɔtɔ kple dzĩtɔ kple ka dzĩ alɔ̃ yevuboɖawo ɖe awu ʋlaya la to le awu la te eye sikanyawowoewo nanɔ yevuboɖawo dome. ");
INSERT INTO ewe_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Yevuboɖawo kple sikanyawowoeawo naɖɔli wo nɔewo ale be sikanyawowoe ɖeka nanɔ yevuboɖa ɖeka yome. ");
INSERT INTO ewe_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Na Aron nado dziwui ʋlaya la ɣe sia ɣi si wòayi be yeawɔ subɔsubɔdɔ na Yehowa, eye sikanyawowoeawo nanɔ ɖiɖim kliŋkliŋkliŋ le Yehowa ŋkume le Kɔkɔeƒe la kple ne edzo le eŋkume ale be maku o. ");
INSERT INTO ewe_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Hekpe ɖe esia ŋu la, tsɔ sika nyuitɔ wɔ ganuvi kɔkɔe si anɔ tablanu la ƒe ŋgonu, eye nàŋlɔ nu ɖe edzi be, wokɔ eŋuti na Yehowa, abe ale si nàŋlɔ nu ɖe nutrenu la dzi ene. ");
INSERT INTO ewe_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Woatsɔ ka blɔtɔ atsi sikanu sia ɖe tablanu la ƒe ŋgonu. ");
INSERT INTO ewe_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ale wòanɔ Aron ƒe ŋgonu, eye Aron atsɔ vodada siwo anɔ Israelviwo ƒe nunanawo ŋu la aƒu akɔ. Ele be wòakplae ɣe sia ɣi si wòado ɖe Yehowa ŋkume ale be, Mawu nakpɔ ŋudzedze le nunanawo ŋu, eye wòatsɔ nu vɔ̃wo ake. ");
INSERT INTO ewe_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Na woalɔ̃ Aron ƒe dziwui ʋlaya la kple ɖeti ɣi, eye woana wòanɔ ŋɔŋɔe. Woatsɔ avɔ ma ke alɔ̃ tablanu la hã, eye woalɔ̃ nu ɖe alidziblanu la hã me. ");
INSERT INTO ewe_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","“Wɔ awu ʋlayawo, alidziblanuwo kple tablanuwo na Aron ƒe viŋutsuwo be woade bubu wo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Do awu siawo na Aron ƒe viŋutsuawo. Si ami ɖe ta na wo, eye nàto esia me akɔ wo ŋu, aɖo wo nunɔlawo be woasubɔm. ");
INSERT INTO ewe_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Tsɔ ɖeti ɣi lɔ̃ avɔ si woatsɔ atɔ atakpui na wo woado ɖe awuawo te. Atakpuiawo natso alime va se ɖe klonu. ");
INSERT INTO ewe_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ele be Aron kple via ŋutsuwo nado awu siawo ɣe sia ɣi si woayi agbadɔ la me alo woayi vɔsamlekpui la gbɔ le Kɔkɔeƒe la. Ne womewɔ nu siawo o la, woaɖi fɔ, eye woaku. Esia nye se matrɔmatrɔ na Aron kple via ŋutsuwo.” ");
INSERT INTO ewe_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Wɔ nu siawo hena Aron kple via ŋutsuwo ŋuti kɔkɔ kple wo ɖoɖo nunɔlawoe. Lé nyitsu fɛ̃ ɖeka kple agbo eve siwo ŋu naneke megblẽ le o, ");
INSERT INTO ewe_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","eye nàtsɔ abolo si wowɔ kple amɔ maʋamaʋã, abolo vivi si woblu kple ami kple akpɔnɔ siwo dzi wokɔ ami ɖo. Woatsɔ wɔ memi awɔ aboloawo kple akpɔnɔawo. ");
INSERT INTO ewe_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Tsɔ wo de kusi aɖe me, eye nàtsɔ kusi la, nyi la kple agbo aveawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Le tsi na Aron kple via ŋutsuwo le agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Do Aron ƒe dziwui, kɔmewu ʋlaya, kɔmewu la ŋutɔ kple akɔtatsyɔnu la nɛ, tsɔ alidziblanu si wolɔ̃ aɖaŋutɔe la bla ali dzi nɛ, ");
INSERT INTO ewe_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","eye nàtsɔ tablanu la kple sikaŋgoblanu kɔkɔe la ɖo ta nɛ. ");
INSERT INTO ewe_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Tsɔ ami kɔkɔe la, eye nàsi ami ɖe ta nɛ. ");
INSERT INTO ewe_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Yɔ via ŋutsuwo vɛ, eye nàtsɔ woƒe dziwuiwo ado na wo. ");
INSERT INTO ewe_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Bla ta na wo kple woƒe tablanuwo, tsɔ alidziblanu tso gae ɖe woƒe akɔta, ahablae ɖe axame na Aron kple via ŋutsuwo, ale be nunɔladɔ nanye wo tɔ tegbee. Aleae nàɖo Aron kple viawo nunɔlawoe. ");
INSERT INTO ewe_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Emegbe la, he nyitsu la va agbadɔ la ŋgɔ, eye nàna Aron kple via ŋutsuwo nada asi ɖe nyitsu la ƒe ta dzi. ");
INSERT INTO ewe_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Wui le Yehowa ŋkume le agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Tsɔ wò asibidɛ de eƒe ʋu me, sisi ʋu la ɖe vɔsamlekpui la ƒe lãdzowo ŋu, eye nàkɔ ʋu mamlɛa katã ɖe vɔsamlekpui la te. ");
INSERT INTO ewe_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Emegbe nàɖe ami si le nyitsu la ƒe dɔmenuwo ŋu. Ɖe aklã kple ayiku eveawo kple ami si le wo ŋu, eye nàtɔ dzo wo le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Esia megbe la, nàtɔ dzo lã blibo la kple eƒe ayi kple afɔdzi si le dɔ me nɛ la le asaɖa la godo abe nuvɔ̃ŋutivɔsa ene. ");
INSERT INTO ewe_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Emegbe la, Aron kple via ŋutsuwo nada asi ɖe agboawo dometɔ ɖeka ƒe ta dzi, ");
INSERT INTO ewe_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","eye nàwui. Woaɖe eya hã ƒe ʋu ahlẽ ɖe vɔsamlekpui la ŋu kpe ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Fli agbo la, kpala lã la, eƒe dɔmenuwo kple eƒe afɔwo, eye nàtsɔ wo da ɖe eƒe ta kple lãkɔ bubuawo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Tɔ dzo lã blibo la ɖe vɔsamlekpui la dzi. Numevɔsae wònye na Yehowa, eye wòdzea eŋu ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Azɔ la, he agbo evelia vɛ. Na Aron kple via ŋutsuwo nada asi ɖe eya hã ƒe ta dzi. ");
INSERT INTO ewe_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Wui eye nàɖe ʋu la asi ɖe Aron kple via ŋutsuwo ƒe nuɖusitowo, woƒe degblefetsu ɖusitɔwo kple woƒe nuɖusi ƒe afɔbidɛ gãtɔwo ŋu. Hlẽ ʋu mamlɛa ɖe vɔsamlekpui la ŋu kpe ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Emegbe la, nàha ʋu la ƒe ɖe le vɔsamlekpui la ŋu, nàtsakae kple amisisi la, eye nàhlẽe ɖe Aron kple via ŋutsuawo ƒe awuwo ŋu. Ekema woawo ŋutɔwo kple woƒe awuwo ŋu akɔ na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Azɔ ɖe agbo la ƒe ami kpe ɖe asike dami la, ami si le eƒe dɔmenuwo ŋu, nàɖe eƒe aklã kple ayiku eveawo kple ami si le wo ŋu kpe ɖe agbo la ƒe ɖusimeta ŋu. (Esiae nye agbo na Aron kple via ŋutsuwo ɖoɖo nunɔlawoe.) ");
INSERT INTO ewe_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Tsɔ nu siawo kpe ɖe abolo bɔbɔe ɖeka kple abolo vivi ɖeka kple akpɔnɔ ɖeka ŋu tso kusi si me abolo si wowɔ kple amɔ maʋamaʋã si woda ɖe Yehowa ŋkume la me. ");
INSERT INTO ewe_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Tsɔ nu siawo de asi na Aron kple viawo. Na woanye wo le yame abe vɔsa na Yehowa ƒe dzesi ene. ");
INSERT INTO ewe_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Le esia yome la, xɔ nu siawo le wo si, eye nàtɔ dzo wo ɖe vɔsamlekpui la dzi abe numeme si ʋẽna lĩlĩlĩ ɖe Yehowa ene. ");
INSERT INTO ewe_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ɖe agbo si wòwu hena Aron ɖoɖo nunɔlae la ƒe akɔ. Nyee le yame le Yehowa ŋkume abe vɔsa ƒe dzesi ene. Akɔ sia nazu tɔwò. ");
INSERT INTO ewe_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Tsɔ agbo si wowu hena Aron kple via ŋutsuwo ŋuti kɔkɔ la ƒe akɔta kple atawo na Aron kple via ŋutsuwo. ");
INSERT INTO ewe_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ele be Israelviwo nadzɔ woƒe vɔsalãwo ƒe akpa siawo ɣe sia ɣi, nenye ŋutifafavɔsa loo alo akpedavɔsa abe woƒe vɔsa na Yehowa ene. ");
INSERT INTO ewe_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Ele be woadzra eƒe awu kɔkɔeawo ɖo hena Via ŋutsu si ava xɔ ɖe eteƒe la ŋuti kɔkɔ ne wole eŋuti kɔm tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ame sia ame si ava nye nunɔlagã le Aron megbe la ado awu siawo ŋkeke adre hafi ade asi subɔsubɔdɔwo wɔwɔ me le agbadɔ la me kple Kɔkɔeƒe la siaa. ");
INSERT INTO ewe_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Tsɔ agbo si ŋu dɔ wowɔ le nunɔlawo ɖoɖo me, eye nàɖa eƒe lã le teƒe kɔkɔe aɖe. ");
INSERT INTO ewe_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Na Aron kple via ŋutsuwo naɖu lã la kple abolo si le kusi la me le agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ale woaɖu nu si wotsɔ ɖe woƒe nu vɔ̃wo ɖae hafi ɖo wo nunɔlawoe hekɔ wo ŋuti. Ame bubu aɖeke mekpɔ mɔ aɖu wo o, elabena nu kɔkɔewo wonye. ");
INSERT INTO ewe_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Nenye be agbo si wotsɔ ɖo wo nunɔlawoe la ƒe lã aɖe susɔ alo abolo la ƒe ɖe susɔ ŋu ke ɖe edzi la, tɔ dzoe. Mele be woaɖui o, elabena ele kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Ale nàɖo Aron kple via ŋutsuwo nunɔlawo le mɔ sia nu. Wo ɖoɖo nanɔ edzi ŋkeke adre. ");
INSERT INTO ewe_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ele be nàtsɔ nyitsu ɖeka awɔ nuvɔ̃ŋutivɔsa gbe sia gbe. Emegbe la, nàkɔ vɔsa la ŋu to nu vɔ̃ ɖeɖe ɖa le eŋu me. Kɔ ami ɖe edzi be eŋu nakɔ. ");
INSERT INTO ewe_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Me avulénuwo le vɔsamlekpui la dzi gbe sia gbe ŋkeke adre be nàkɔ vɔsamlekpui la ŋu na Mawu. Le esia megbe la, vɔsamlekpui la azu kɔkɔe, nu sia nu si aka eŋu la hã azu kɔkɔe, eye ame siwo le kɔkɔe la koe aka asi eŋu.” ");
INSERT INTO ewe_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Tsɔ alẽ eve sa vɔe ɖe vɔsamlekpui la dzi gbe sia gbe, ");
INSERT INTO ewe_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ɖeka le ŋdi me, eye evelia le fiẽ me. ");
INSERT INTO ewe_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Tsɔ wɔ memi kilogram ɖeka, ami lita ɖeka kple wain lita ɖeka kpe ɖe alẽ ɖeka ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Tsɔ alẽ evelia kple wɔ memi la kple wain sa vɔe le fiẽ me abe ale si nèwɔ le ŋdi me ene, wòanye vɔsa si ʋẽna lĩlĩlĩ na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Esiae nye numevɔsa si miawo kple miaƒe dzidzimeviwo miawɔ gbe sia gbe na Yehowa le agbadɔ la ƒe mɔnu. Mado go wò le afi ma, eye maƒo nu kpli wò. ");
INSERT INTO ewe_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Mado go Israelviwo le afi ma, eye nye ŋutikɔkɔe akɔ agbadɔ la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ɛ̃, makɔ agbadɔ la, vɔsamlekpui la, Aron kple via ŋutsuwo, ame siwo nye subɔlawo kple nunɔlawo la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Manɔ Israelviwo dome, manye woƒe Mawu, ");
INSERT INTO ewe_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","eye woanya be, nyee nye Yehowa, woƒe Mawu la. Mekplɔ wo tso Egipte ale be mate ŋu anɔ wo dome. Nyee nye Yehowa, woƒe Mawu la.” ");
INSERT INTO ewe_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Tsɔ akasiati wɔ vɔsamlekpui aɖe si dzi woado dzudzɔ ʋeʋĩ ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Na eƒe didime kple kekeme siaa nanɔ sentimita blaene-vɔ-atɔ̃, eye wòakɔ sentimita blaasiekɛ. Tsɔ akasiati ke kpa lãdzowo ɖe vɔsamlekpui la ŋu woanye nu ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Fa sika nyuitɔ ɖe vɔsamlekpui la tame kple eƒe axadziwo kple lãdzoawo ŋu, eye nàgatsɔ sika nyuitɔ aɖo atsyɔ̃ na vɔsamlekpui la ƒe towo katã. ");
INSERT INTO ewe_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Wɔ sikagagɔdɔ̃e eve ɖe atsyɔ̃ɖonu la te, ɖe eƒe axa eveawo, be woatsɔ vɔsamlekpui la kɔtiwo aƒo ɖe wo me. ");
INSERT INTO ewe_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Woawɔ vɔsamlekpui la kɔtiwo kple akasiati, eye woafa sika ɖe wo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Tsɔ vɔsamlekpui la da ɖe xɔmetsovɔ la ŋgɔ, wòate ɖe amenuveve ƒe nutsyɔnu si nye nubablaɖaka si me Se Ewoawo le la kasa, afi si mado go wò le. ");
INSERT INTO ewe_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Ŋdi sia ŋdi la, Aron ado dzudzɔ kple atike ʋeʋĩ le vɔsamlekpui la dzi, ne ebɔbɔ akaɖigbɛawo ɖe eme. ");
INSERT INTO ewe_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Fiẽ sia fiẽ la, Aron agado dzudzɔ kple lifi le Yehowa ŋkume, ne esi akaɖiawo. Nu sia ayi edzi tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Mègawɔ dzudzɔdovɔsa, numevɔsa, nuɖuvɔsa alo nunovɔsa bubu aɖeke si ŋu nyemeɖe mɔ le o. ");
INSERT INTO ewe_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“Zi ɖeka le ƒe ɖe sia ɖe me la, Aron awɔ avulévɔsa na eƒe lãdzoawo. Woawɔ ƒe sia ƒe ƒe avulévɔsa kple nu vɔ̃ ƒe avulévɔsalã ƒe ʋu le dzidzimewo katã me. Enye nu kɔkɔetɔ kekeake na Yehowa.” ");
INSERT INTO ewe_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Ɣe sia ɣi si nàxlẽ Israelviwo la, ele be ame sia ame si woaxlẽ la, naxe fe na Yehowa ɖe eƒe agbe ta, ale be dɔvɔ̃ manɔ ameawo dome ne èle wo xlẽm o. ");
INSERT INTO ewe_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Ga si ame sia ame si woxlẽ naxe la nye klosalo gram ade. Ke nu si woaxe la aku ɖe kɔkɔeƒe ga home si woabia tso wo si le ƒe ma me la ŋu. Woadzɔ nu sia na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ame sia ame si wotia, eye wòxɔ ƒe blaeve alo wu nenema la nadzɔ nu na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Hotsuitɔwo maxe fe sia wòawu home si meyɔ o, eye ame dahewo hã mana nu wòanɔ sue wu o, elabena vɔsae wònye na Yehowa hena miaƒe nu vɔ̃wo ƒe tsɔtsɔke. ");
INSERT INTO ewe_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","“Wɔ ga sia ŋu dɔ hena agbadɔ la dzadzraɖo. Eyae aɖo ŋku Israelviwo dzi na Yehowa, eye wòanye avulénu ɖe mia ta.” ");
INSERT INTO ewe_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Eye Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Tsɔ akɔbli wɔ gagbɛ aɖe kple eƒe zɔ hena ŋutikɔklɔ. Tsɔe da ɖe agbadɔ la kple vɔsamlekpui la dome, eye nàkɔ tsi ɖe eme. ");
INSERT INTO ewe_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Na Aron kple via ŋutsuwo naklɔ asi kple afɔ le afi sia, ");
INSERT INTO ewe_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","ne woyina agbadɔ la me be woado ɖe Yehowa ŋkume alo hafi woate ɖe vɔsamlekpui la ŋu be woasa vɔ na Yehowa. Ele be woaklɔ asi kple afɔ hafi awɔ nu siawo, ne menye nenema o la, woaku. ");
INSERT INTO ewe_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Esiawoe nye ɖoɖowo na Aron kple via ŋutsuwo tso dzidzime yi dzidzime.” ");
INSERT INTO ewe_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Ƒo atike ʋeʋĩ nyuitɔwo nu ƒu ale: ‘Mira’ nyuitɔ kilogram ade, ‘sinamon’ kilogram etɔ̃, atike ʋeʋĩ kilogram etɔ̃, ");
INSERT INTO ewe_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","‘akasea’ kilogram ade kple ami lita ene le kɔkɔeƒe la ƒe dzidzenu nu. ");
INSERT INTO ewe_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Yehowa gblɔ na amiʋeʋĩwɔla xɔŋkɔwo be woatsɔ atike siawo awɔ amisisi kɔkɔe lae. Anye dzudzɔdonu kɔkɔe abe ale si amiʋeʋĩwɔla nyuitɔwo wɔnɛ ene.” ");
INSERT INTO ewe_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Yehowa gblɔ be, “Si ami sia na agbadɔ la, nubablaɖaka la, ");
INSERT INTO ewe_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","kplɔ̃ la kple eŋunuwo, akaɖiti la kple eŋunuwo, dzudzɔdovɔsamlekpui la, ");
INSERT INTO ewe_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","numevɔsamlekpui la kple eŋunuwo kple asiklɔgagbɛ la kple eƒe afɔ. ");
INSERT INTO ewe_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Kɔ wo ŋu woazu kɔkɔe; nu sia nu si aka wo ŋu la azu kɔkɔe na Mawu. ");
INSERT INTO ewe_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Tsɔe si ami na Aron kple via ŋutsuwo, eye nàkɔ wo ŋu hena subɔsubɔdɔwo wɔwɔ nam abe nunɔlawo ene. ");
INSERT INTO ewe_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Gblɔ na Israelviwo be, ‘Ami sia anye ami kɔkɔe si miasi na amewo ɣe sia ɣi. ");
INSERT INTO ewe_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Womakɔe ɖe ame dzodzro aɖeke dzi o, eye ame aɖeke mawɔ etɔgbi na eɖokui o, elabena ami kɔkɔe wònye, eye ele be ame sia ame nabui ami kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ele be woaɖe ame sia ame si awɔ etɔgbi alo atsɔe asi na ame aɖe si menye nunɔla o la le ha me.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yehowa gblɔ na Mose be, “Tsɔ atike ʋeʋĩwo, lifi lãhe, onitsa, galbanum kple lifi nyuitɔ kpekpeme ma ke na ɖe sia ɖe, ");
INSERT INTO ewe_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","eye nàtsɔ wo awɔ dzudzɔdonu abe ale si dzudzɔdonuwɔlawo wɔnɛ ɣe sia ɣi ene pɛpɛpɛ. De dze sue aɖe eme, eye wòanye dzudzɔdonu kɔkɔe si dza. ");
INSERT INTO ewe_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Tu eƒe ɖe memie eye nàtsɔ eƒe ɖe da ɖe nubablaɖaka la ŋgɔ, afi si medoa go wò le, le agbadɔ la me. Dzudzɔdonu sia le kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Migawɔ etɔgbi na mia ɖokuiwo gbeɖegbeɖe o, elabena enye nu kɔkɔe na Yehowa ɖeɖe ko. ");
INSERT INTO ewe_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ame si awɔ esia tɔgbi be eƒe ʋeʋẽ lĩlĩlĩ nado dzidzɔ nɛ la, ele be woaɖee ɖa le eƒe dukɔ la dome.” ");
INSERT INTO ewe_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Kpɔ ɖa, metia Bezalel, Uri ƒe viŋutsu kple Hur ƒe tɔgbuiyɔvi tso Yuda ƒe to la me. ");
INSERT INTO ewe_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Mena Mawu ƒe Gbɔgbɔ yɔ eme, eye wòna nunya deto kple ŋutete kple aɖaŋu tɔxɛe hena agbadɔ la tutu kple nu sia nu si le eme la wɔwɔ. ");
INSERT INTO ewe_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ŋutete blibo le eŋu hena nuwo wɔwɔ kple sika, klosalo kple akɔbli. ");
INSERT INTO ewe_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Enya ale si woatsɔ kpe xɔasiwo awɔ nuwo, eye woatsɔ atiwo akpa nuwoe. ");
INSERT INTO ewe_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Metia Oholiab, Ahisamak ƒe vi tso Dan ƒe to la me be wòanye eƒe kpeɖeŋutɔ. “Gawu la, megatsɔ aɖaŋu tɔxɛwo na ame siwo katã mienya be wonye aɖaŋutɔwo ale be woate ŋu awɔ nu siwo mebe nàwɔ la katã: ");
INSERT INTO ewe_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“agbadɔ la, Nubablaɖaka la kple eƒe nutuvi, kple nu siwo katã le agbadɔ la me, ");
INSERT INTO ewe_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","vɔsamlekpui la kple eŋunuwo, sikakaɖiti la kple eŋunuwo, dzudzɔdovɔsamlekpui la, ");
INSERT INTO ewe_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","numevɔsamlekpui la kple eŋunuwo, tsileganu la kple eƒe zɔ, ");
INSERT INTO ewe_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Nunɔla Aron ƒe awu nyui kɔkɔewo kple Aron ƒe viŋutsuwo ƒe awuwo, ale be woate ŋu awɔ dɔ nam abe nunɔlawo ene, ");
INSERT INTO ewe_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Teƒe Kɔkɔe la ƒe amisisi la kple dzudzɔdonu ʋeʋĩwo. “Ele be woawɔ nu siawo katã ɖe ale si meɖo na wò la nu.” ");
INSERT INTO ewe_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yehowa yi edzi gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Gblɔ na Israelviwo be, ‘Ele be miaɖo ŋku nye Dzudzɔgbe la dzi, elabena Dzudzɔgbe la nye ŋkuɖoɖo nubabla si le nye kple miawo dome la dzi tegbetegbe. Esia awɔe be miaɖo ŋku edzi be nyee nye Yehowa, ame si wɔ mi kɔkɔe.’ ");
INSERT INTO ewe_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Ele be miadzudzɔ le Dzudzɔgbe la dzi, elabena enye ŋkeke kɔkɔe na mi. Ele be woawu ame sia ame si ada le se sia dzi la, eye woaɖe ame sia ame si awɔ dɔ le ŋkeke sia dzi la ƒe agbe ɖa le etɔwo dome. ");
INSERT INTO ewe_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Ŋkeke ade woawɔ dɔ, ke ŋkeke adrelia nye Dzudzɔgbe; ŋkeke kɔkɔe wònye na Yehowa. Ame sia ame si awɔ dɔ le ŋkeke sia dzi la, ele be woawui. ");
INSERT INTO ewe_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Miwɔ dɔ ŋkeke ade ko, elabena ŋkeke adrelia nye ŋkeke tɔxɛ hena dzudzɔ, eye wòle kɔkɔe na nye Yehowa. Se sia nye nubabla mavɔ, eye wòle be Israelviwo nawɔ edzi. ");
INSERT INTO ewe_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Enye nubabla si le nye kple Israelviwo dome la ƒe dzesi mavɔ, elabena ŋkeke adee nye, Yehowa metsɔ wɔ dziƒo kple anyigba, eye medzudzɔ le ŋkeke adrea gbe.” ");
INSERT INTO ewe_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Esi Yehowa wu eƒe nuƒoƒo kple Mose nu le Sinai to la dzi la, etsɔ kpe eve siwo dzi eya ŋutɔ tsɔ eƒe asibidɛ ŋlɔ Se Ewoawo ɖo la na Mose. ");
INSERT INTO ewe_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Esi Mose megbɔ tso to la dzi kaba o ta la, Israelviwo gblɔ na Aron be, “Kpɔ ɖa, wɔ mawu aɖe si akplɔ mí la na mí, elabena Mose, ame si kplɔ mí tso Egipte la, bu ɖe mí. Nane anya wɔe.” ");
INSERT INTO ewe_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aron ɖo eŋu na wo be, “Miɖe sikatogɛ siwo mia srɔ̃wo, mia viŋutsuwo kple mia vinyɔnuwo de la eye miatsɔ wo vɛ nam.” ");
INSERT INTO ewe_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Ale wo katã woɖe woƒe sikatogɛwo tsɔ vɛ na Aron. ");
INSERT INTO ewe_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aron lolõ sika la, eye wòtsɔe wɔ nyivi aɖe ƒe nɔnɔme. Ameawo do ɣli be, “O, Israel, esiae nye mawu si kplɔ wò do goe le Egipte!” ");
INSERT INTO ewe_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Esi Aron kpɔ ale si ameawo kpɔ dzidzɔe le nyivilegba la ŋu la, etu vɔsamlekpui aɖe ɖe nyivilegba la ŋgɔ, eye wòɖe gbeƒã be, “Etsɔ la, míasa vɔ aɖe na Yehowa!” ");
INSERT INTO ewe_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Esi ŋu ke la, wofɔ kaba, eye wode asi numevɔsawo kple ŋutifafavɔsawo wɔwɔ me na nyivilegba la. Emegbe la, wonɔ anyi ɖu nu, eye wono nu nyuie, eye wotsi tsitre, eye woɖu ɣe. ");
INSERT INTO ewe_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Tete Yehowa gblɔ na Mose be, “Ɖi kaba, elabena wò ame siwo nèkplɔ tso Egipte la dze nu vɔ̃ me, ");
INSERT INTO ewe_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","eye woɖe asi le nye seawo katã ŋu enumake. Wowɔ sikanyivilegba aɖe na wo ɖokuiwo. Wole esubɔm, le vɔ sam nɛ, eye wole gbɔgblɔm be, ‘O Israel, esiae nye wò mawu si kplɔ wò tso Egipte.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Yehowa yi edzi be, “Mekpɔ be dukɔ sia me tɔwo nye kɔlialiatɔwo kple aglãdzelawo. ");
INSERT INTO ewe_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Gblẽm ɖi azɔ, eye nye dɔmedzoe nabi ɖe wo ŋu. Matsrɔ̃ wo katã, eye mawɔ wò, Mose nàzu dukɔ gã aɖe ɖe wo teƒe.” ");
INSERT INTO ewe_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Ke Mose ɖe kuku na Yehowa, eƒe Mawu la be megawɔ nenema o. Eɖe kuku be, “Yehowa, nu ka ta nèdo dɔmedzoe helĩhelĩ ale ɖe wò ŋutɔ wò dukɔ si nèkplɔ tso Egiptenyigba dzi kple ŋusẽ gã kple nukunu triakɔ mawo tɔgbi la ŋu? ");
INSERT INTO ewe_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Ɖe nèdi be Egiptetɔwo nagblɔ be, ‘Mawu ble wo be woava toawo dzi ale be yeate ŋu awu wo, atsrɔ̃ wo ɖa le anyigba dzi keŋkeŋ’ mahã? Ɖe asi le wò dɔmedzoe sesẽ la ŋu. Trɔ wò susu, eye mègahe dzɔgbevɔ̃e va wò amewo dzi o. ");
INSERT INTO ewe_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ɖo ŋku wò ŋutɔ wò ŋugbe si nèdo na wò dɔlawo, Abraham, Isak kple Israel la dzi, elabena ètsɔ wò ŋutɔ wò ŋkɔ ka atam be, ‘Mana miaƒe dzidzimeviwo nasɔ gbɔ abe dziƒoɣletiviwo ene, eye matsɔ anyigba sia katã si ŋugbe medo la ana miaƒe dzidzimeviwo tegbetegbe.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Ale Yehowa trɔ eƒe tameɖoɖo la, eye wòkpɔ nublanui na wo. ");
INSERT INTO ewe_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mose ɖi tso to la dzi. Elé kpe eve siwo ƒe akpa eveawo dzi woŋlɔ Se Ewoawo ɖo la ɖe asi. ");
INSERT INTO ewe_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Mawu ŋutɔe kpa kpeawo, eye wòŋlɔ Seawo ɖe kpeawo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Esi Yosua se ɣli si ameawo katã nɔ dodom le toa te la, egblɔ na Mose be, “Ewɔ abe ɖe wole dzadzram ɖo na aʋawɔwɔ ene!” ");
INSERT INTO ewe_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ke Mose ɖo eŋu be, “Ao, menye dziɖuɣli alo aʋasiɣlie o, ke boŋ hadzidzie.” ");
INSERT INTO ewe_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Esi wote ɖe asaɖa la ŋu la, Mose kpɔ sikanyivilegba la kple ameawo wonɔ ɣe ɖum. Edo dɔmedzoe ale gbegbe be wòtsɔ kpe siwo dzi Mawu ŋlɔ Seawo ɖo la ƒu anyi wogbã le to la te. ");
INSERT INTO ewe_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Etsɔ sikanyivilegba la, eye wòdee dzo me wòlolo. Esi sika la fa la, etui memie wòzu wɔ. Etsɔ wɔ la kɔ ɖe tsi me hena Israelviwo wono. ");
INSERT INTO ewe_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mose bia Aron be, “Nu ka tututu ameawo wɔ wò be nèhe nu vɔ̃ triakɔ sia va wo dzi?” ");
INSERT INTO ewe_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aron ɖo eŋu nɛ be, “Nye aƒetɔ, mègado dɔmedzoe helĩhelĩ nenema o. Ènya ame siawo nyuie, eye ènya ameha vɔ̃ɖi si wonye. ");
INSERT INTO ewe_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Woawoe gblɔ nam be, ‘Wɔ mawu aɖe na mí, wòakplɔ mí, elabena nane wɔ Mose, ame si kplɔ mí do goe le Egipte.’ ");
INSERT INTO ewe_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Megblɔ na wo be, ‘Mitsɔ miaƒe sikatogɛwo vɛ.’ Ale wotsɔ wo vɛ. Metsɔ wo de dzo me, eye nyivi siae do go tso eme!” ");
INSERT INTO ewe_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Esi Mose kpɔ be ameawo lé woƒe mɔ tsɔ to Aron ƒe ŋusẽdoame me, eye yewoƒe futɔwo nɔ dzidzɔ kpɔm le nu sia ŋu la, ");
INSERT INTO ewe_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","etsi tsitre ɖe asaɖa la ƒe mɔnu, eye wòdo ɣli be, “Mi ame siwo katã le Yehowa dzi la, miva afi sia miawɔ ɖeka kplim.” Tete Levitɔwo katã do go va egbɔ. ");
INSERT INTO ewe_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Egblɔ na wo be, “Yehowa, Israel ƒe Mawu la gblɔ be, ‘Mitsɔ miaƒe yiwo, eye miatsa le asaɖa la me, tso asaɖa la ƒe seƒe ɖeka yi ekemɛ, eye miawu mia ŋutɔwo mia nɔviwo, xɔlɔ̃wo kple ame nyanyɛwo gɔ̃ hã.’ ” ");
INSERT INTO ewe_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Levitɔwo wɔ abe ale si Mose gblɔ na wo ene, eye ame abe akpe etɔ̃ ene ku gbe ma gbe. ");
INSERT INTO ewe_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mose gblɔ na Levitɔwo be, “Egbe la, mieɖo mia ɖokuiwo hena dɔwɔwɔ na Yehowa, elabena mieɖo toe, togbɔ be toɖoɖoe na be miewu mia ŋutɔwo mia viwo kple mia nɔviwo hã. Azɔ la, Yehowa akɔ yayra geɖe ɖe mia dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Esi ŋu ke la, Mose gblɔ na Israelviwo be, “Miewɔ nu vɔ̃ gã aɖe, ke magbugbɔ ayi Yehowa gbɔ le to la dzi. Ɖewohĩ mate ŋu ana wòatsɔ miaƒe nu vɔ̃wo ake mi.” ");
INSERT INTO ewe_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Ale Mose trɔ yi Yehowa gbɔ, eye wògblɔ nɛ be, “O, ame siawo wɔ nu vɔ̃ gã aɖe: wotsɔ sika wɔ mawuwo na wo ɖokuiwo. ");
INSERT INTO ewe_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Meɖe kuku, tsɔ woƒe nu vɔ̃wo ke wo. Ke ne màte ŋui o la, ekema na nye boŋ maku ɖe wo teƒe, eye nàtutu nye ŋkɔ ɖa le wò agbalẽ la me.” ");
INSERT INTO ewe_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yehowa ɖo eŋu na Mose be, “Ame sia ame si wɔ nu vɔ̃ ɖe ŋunye la, eya ƒe ŋkɔe matutu ɖa le nye agbalẽ la me. ");
INSERT INTO ewe_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Azɔ la, yi eye nàkplɔ nye ameawo ayi teƒe si ƒe nya megblɔ na wò. Meka ɖe edzi na wò be nye Dɔla anɔ ŋgɔ na mi. Ke ne meva be makpɔ ameawo ɖa la, mahe to na wo le woƒe nu vɔ̃wo ta.” ");
INSERT INTO ewe_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Tete Yehowa na dɔvɔ̃ dze ameawo dzi, elabena wosubɔ Aron ƒe sikanyivilegba la. ");
INSERT INTO ewe_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yehowa gblɔ na Mose be, “Kplɔ ame siwo nèkplɔ tso Egipte la, yi anyigba si ŋugbe medo na Abraham, Isak kple Yakob la dzi, elabena megblɔ be, ‘Matsɔ anyigba sia ana miaƒe dzidzimeviwo.’ ");
INSERT INTO ewe_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Madɔ Mawudɔla aɖe ɖa wòakplɔ mi, eye manya Kanaantɔwo, Amoritɔwo, Hititɔwo, Perizitɔwo, Hivitɔwo kple Yebusitɔwo ɖa le anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Enye anyigba aɖe si dzi ‘notsi kple anyitsi bɔ ɖo.’ Ke nyemazɔ kpli mi o, elabena mienye dukɔ kɔlialiatɔwo kple setemanɔlawo, eye mava di be matsrɔ̃ mi le mɔa dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Esi ameawo se ŋɔdzinya siawo la, wode asi konyifafa me, eye woɖe woƒe sikanuwo kple atsyɔ̃ɖonuwo da ɖi. ");
INSERT INTO ewe_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yehowa gblɔ na Mose be wòagblɔ na Israelviawo be, “Mienye aglãdzelawo kple kɔlialiatɔwo. Ne menɔ mia dome aɖabaƒoƒo ɖeka pɛ gɔ̃ hã la, matsrɔ̃ mi. Miɖe miaƒe sikanuwo kple atsyɔ̃ɖonuwo da ɖi va se ɖe esime maɖo kpe nu si mawɔ kpli mi la dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ale le nu sia megbe la, Israelviwo megado sikanu aɖeke le Horeb. ");
INSERT INTO ewe_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mose tua agbadɔ la ɣe sia ɣi ɖe adzɔge ʋĩi tso asaɖa la gbɔ. Ena ŋkɔe be, “Agbadɔ Hena Gododo Mawu.” Ame sia ame si di be yeaƒo nu kple Yehowa la yia afi ma. ");
INSERT INTO ewe_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ne Mose yina agbadɔ la gbɔ la, ameawo katã tsia tsitre ɖe woƒe agbadɔwo nu, eye wonɔa Mose kpɔm va se ɖe esime wòaɖo agbadɔ la nu. ");
INSERT INTO ewe_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ne ege ɖe agbadɔ la me la, lilikpo dodo aɖe ɖiɖina va nɔa agbadɔ la nu le esime Mawu ƒoa nu kple Mose. ");
INSERT INTO ewe_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ekema ameawo katã doa gbe ɖa eye wodea ta agu na lilikpo la le woƒe agbadɔwo nu. ");
INSERT INTO ewe_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yehowa ƒoa nu kple Mose ŋkume kple ŋkume le Mawu ƒe agbadɔ la me abe ale si xɔlɔ̃ ƒoa nu kple xɔlɔ̃ ene. Le esia megbe la, Mose trɔna vaa asaɖa la me, ke Yosua, Nun ƒe viŋutsu, ɖekakpui si kpena ɖe eŋu la, nɔa agbadɔ la me. ");
INSERT INTO ewe_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mose gblɔ na Yehowa le agbadɔ la me be, “Ègblɔna nam be, ‘Kplɔ dukɔ sia yi Ŋugbedodonyigba la dzi.’ Ke mègblɔ ame si nàɖo ɖa kplim la nam o. Ègblɔ be yenyam kple nye ŋkɔ, eye yeƒe amenuveve la li kplim. ");
INSERT INTO ewe_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ne esia le eme alea pɛpɛpɛ la, ekema meɖe kuku, fia wò mɔwom ale be mase wò ɖoɖowo gɔme, eye mawɔ nu si adze ŋuwò. Ɖo ŋku edzi be yeƒe dukɔe nye dukɔ sia.” ");
INSERT INTO ewe_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Yehowa ɖo eŋu be, “Nye ŋutɔ mayi kpli mi, eye mana nu sia nu nadze edzi na mi.” ");
INSERT INTO ewe_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mose xɔ edzi be, “Ne mèle yiyi ge kpli mí o la, ekema mègana míaɖe afɔ ɖeka tso afi sia o. ");
INSERT INTO ewe_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ne mèyi kpli mí o la, ame kae akpɔ be wò amenuveve li kplim kple nye amewo? Ame kae akpɔ be míeto vovo tso dukɔ bubu ɖe sia ɖe si le anyigba dzi la gbɔ?” ");
INSERT INTO ewe_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yehowa ɖo eŋu na Mose be, “Ɛ̃, mawɔ nu si nèbia la na wò, elabena vavã, nye amenuveve le dziwò, eye menya wò kple wò ŋkɔ.” ");
INSERT INTO ewe_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mose bia Mawu be wòana yeakpɔ eƒe ŋutikɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yehowa ɖo eŋu be, “Mana nye ŋutikɔkɔe nato wò ŋkume ayi. Maɖe gbeƒã nye ŋkɔ Yehowa kple eƒe gɔmesese le ŋgɔwò. Mevea ame si nu medi be mave la nu, eye mekpɔa nublanui na ame si medi be makpɔ nublanui na. ");
INSERT INTO ewe_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ke màkpɔ nye ŋkume ya o, elabena ame aɖeke makpɔ nye ŋkume, eye wòaganɔ agbe o. ");
INSERT INTO ewe_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Tsi tsitre ɖe agakpe sia dzi le gbɔnye. ");
INSERT INTO ewe_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ne nye ŋutikɔkɔe tso eme va yina la, matsɔ wò ade agakpe la tome. Matsɔ nye asi atsyɔ dziwò va se ɖe esime matso eme. ");
INSERT INTO ewe_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ekema maɖe nye asi ɖa, eye nàkpɔ yonyeme. Màkpɔ nye ŋkume ya o.” ");
INSERT INTO ewe_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yehowa gblɔ na Mose be, “Kpa kpe gbadzɛ eve abe gbãtɔwo ene, eye maŋlɔ Se siwo nɔ kpe siwo nègba la dzi la ɖe wo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Dzra ɖo etsɔ ŋdi nàva kpɔm le Sinai to la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Mègana ame aɖeke nava kpli wò o, eye ame aɖeke manɔ teƒe aɖeke le to sia dzi hã o. Mègana miaƒe alẽwo kple nyiwo naɖu gbe le teƒe si te ɖe to la ŋu o.” ");
INSERT INTO ewe_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ale Mose tsɔ kpe kpakpɛ eveawo abe gbãtɔwo ene, eye wòlia Sinai to la ŋdi kanya, abe ale si Yehowa ɖo nɛ be wòawɔ ene. ");
INSERT INTO ewe_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yehowa ɖi ɖe to la dzi le lilikpo dodo aɖe me, eye wòtsi tsitre ɖe egbɔ le afi ma ɖe gbeƒã eƒe ŋkɔ Yehowa nɛ. ");
INSERT INTO ewe_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Yehowa to Mose ŋkume, eye wòɖe gbeƒã eƒe ŋkɔ be, “Yehowa, Yehowa, Mawu nublanuikpɔla kple amenuvela, ame si gbɔa dzi ɖi blewu, eye eƒe lɔlɔ̃ kple nuteƒewɔwɔ nu metsina o; ");
INSERT INTO ewe_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ame si ɖea lɔlɔ̃ fiaa ame akpe nanewo, eye wòtsɔa ame vɔ̃ɖiwo kple aglãdzelawo ƒe nu vɔ̃wo kea wo, ke megbea tohehe na vodalawo o, eye wòhea to na ɖeviwo ɖe wo fofowo ƒe vodadawo ta tso dzidzime etɔ̃lia va se ɖe enelia dzi.” ");
INSERT INTO ewe_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mose tsyɔ mo anyi enumake ɖe Yehowa ŋkume, eye wòsubɔe. ");
INSERT INTO ewe_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Egblɔ be, “Nenye nyateƒe be nève nunye la, ekema O Yehowa, meɖe kuku kplɔ mí yi Ŋugbedodonyigba la dzi. Eme kɔ ƒãa be míenye dukɔ dzeaglã kple kɔlialiatɔwo, gake meɖe kuku, tsɔ míaƒe vodadawo kple nu vɔ̃wo ke mí, eye nàgaxɔ mí abe wò ŋutɔ tɔwòwo ene.” ");
INSERT INTO ewe_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Yehowa ɖo eŋu be, “Enyo. Esiae nye nubabla si mawɔ kple wò. Mawɔ nukunu siwo tɔgbi ame aɖeke mewɔ le xexea me blibo la ƒe akpa aɖeke kpɔ o. Israelviwo katã akpɔ Yehowa ƒe ŋusẽ. Woakpɔ ŋusẽ triakɔ si maɖe afia to dziwò.” ");
INSERT INTO ewe_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Nu si nàwɔ le nubabla sia me lae nye be nàlé nye seawo katã me ɖe asi. Ekema manya Amoritɔwo, Kanaantɔwo, Hititɔwo, Perizitɔwo, Hivitɔwo kple Yebusitɔwo katã le ŋgɔwò le anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Kpɔ nyuie be màbla nu kple ame siwo le anyigba si dzi yim miele la gbeɖegbeɖe o, elabena ne miebla nu kpli wo la, miade asi woƒe nu vɔ̃ɖiwo wɔwɔ me kaba. ");
INSERT INTO ewe_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ke boŋ migbã woƒe vɔsamlekpuiwo kple woƒe legbawo eye miho woƒe aƒeliwo ƒu anyi, ");
INSERT INTO ewe_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","elabena mele be miasubɔ mawu bubu aɖeke o, ke boŋ Yehowa ko, elabena Yehowa nye Mawu si dina be woasubɔ ye ɖeka ko. ");
INSERT INTO ewe_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Miɖɔ ŋu ɖo be miagawɔ nubabla aɖeke tɔgbi kple ame siwo le anyigba la dzi o. Mawu geɖewo subɔlawo wonye, eya ta ne miewɔ ɖeka kpli wo la, woakpe mi ayi woƒe legbawo subɔƒe, eye míaɖu woƒe vɔsanuwo. ");
INSERT INTO ewe_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Eye ne míeɖe wo vinyɔnuwo na mia viŋutsuwo la, wo srɔ̃wo akplɔ wo ayi woƒe legbawo subɔƒewo, eye mia viŋutsuawo hã ada vo ɖe ŋunye to wo srɔ̃wo ƒe mawuawo subɔsubɔ me. ");
INSERT INTO ewe_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Mele be miawɔ legba aɖeke na mia ɖokuiwo o. ");
INSERT INTO ewe_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Ɖo ŋku edzi miaɖu Abolo Maʋamaʋã Ŋkekenyui ŋkeke adre abe ale si megblɔe na wò ene le ŋkeke ɖoɖoawo dzi, le Tedoxe me ƒe sia ƒe. Ɣleti sia mee miedzo le Egipte. ");
INSERT INTO ewe_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Nyitsu, agbo kple gbɔ̃tsu ɖe sia ɖe si ʋu dɔ nu na dadaa la nye tɔnye. ");
INSERT INTO ewe_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Àte ŋu atsɔ alẽvi aɖɔli tedzi ƒe ŋgɔgbevi. Ne mèdi be yeaɖɔlii o la, ekema ele be nàŋe kɔe. Ke ele be miaƒle miaƒe ŋgɔgbevi ŋutsuwo katã ta. Ame aɖeke megava nye ŋkume asi gbɔlo o. ");
INSERT INTO ewe_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Le nuƒãɣi kple nuŋeɣi gɔ̃ hã la, miawɔ dɔ ŋkeke ade ko, eye miadzudzɔ le ŋkeke adrea gbe. ");
INSERT INTO ewe_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Ɖo ŋku edzi miaɖu Kɔsiɖawo ƒe Ŋkekenyui, si nye lu gbãtɔwo ŋeŋe ƒe ŋkekenyuie la; emegbe la miaɖu Avaɖoɖo ƒe Ŋkekenyui le ƒea ƒe nuwuwu. ");
INSERT INTO ewe_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Le ŋkekenyui siawo dometɔ ɖe sia ɖe dzi la, ele be Israel ŋutsuwo kple ŋutsuviwo katã nado ɖe Aƒetɔ Yehowa, Israel ƒe Mawu ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Futɔ aɖeke madze miaƒe anyigba dzi, aɖu mia dzi ne mieyi toa dzi be miado ɖe Yehowa, miaƒe Mawu la ŋkume le azã etɔ̃ mawo dzi ƒe sia ƒe o, elabena manya dukɔawo ɖa le mia ŋgɔ, eye makeke miaƒe liƒowo ɖe enu. ");
INSERT INTO ewe_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Megakpe nye vɔsalãwo ƒe ʋu ɖe abolo si woƒo kple amɔ ʋaʋã la ŋu o. Mele be Ŋutitotoŋkekenyui ƒe vɔsalã lã ƒe akpa aɖeke natsi anyi ŋu nake ɖe edzi o. ");
INSERT INTO ewe_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Ne èxa wò agblemenukuwo la, ele be nàtsɔ wò ŋkeke gbãtɔ ƒe nuku nyuitɔwo ƒe ɖe va Yehowa, wò Mawu ƒe aƒe me. “Mègaɖa gbɔ̃vi le dadaa ƒe notsi me o.” ");
INSERT INTO ewe_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Yehowa yi edzi gblɔ na Mose be, “Ŋlɔ se siwo mede na wò egbe la da ɖi, elabena woawoe nye ɖoɖo siwo ku ɖe nye nubabla si mewɔ kple wò kple Israel la ŋu.” ");
INSERT INTO ewe_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mose yi ɖanɔ toa dzi kple Yehowa ŋkeke blaene kple zã blaene. Meɖu naneke alo no naneke le ŋkeke siawo me o. Le ɣeyiɣi sia me la, Mawu ŋlɔ nubabla la me nya siwo nye Se Ewoawo la ɖe kpe kpakpɛ eveawo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Esi Mose ɖi tso Sinai toa dzi gbɔna kple kpe kpakpɛawo la, menya be yeƒe mo nɔ keklẽm le yeƒe Mawu gbɔ nɔnɔ ta o. ");
INSERT INTO ewe_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Le keklẽ si nɔ mo nɛ ta la, Aron kple Israelviwo vɔ̃ be yewoate ɖe eŋu. ");
INSERT INTO ewe_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Ke Mose yɔ wo. Aron kple ameha la ƒe kplɔlawo te ɖe eŋu, eye woƒo nu kplii. ");
INSERT INTO ewe_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Le esia megbe la, Israelviwo katã va egbɔ, eye wòtsɔ se siwo Yehowa tsɔ nɛ le Sinai toa dzi la na wo. ");
INSERT INTO ewe_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Esime Mose wu eƒe nuƒoa nu la, etsɔ motsyɔvɔ tsyɔ ŋkume. ");
INSERT INTO ewe_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ne eyina agbadɔ la me be yeaƒo nu kple Yehowa la, eɖea motsyɔvɔ la ɖa va se ɖe esime wòado go. Ekema agblɔ se siwo katã Mawu de nɛ la na Israelviwo, ");
INSERT INTO ewe_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","eye woakpɔ eƒe mo wòanɔ keklẽm. Le esia megbe la, egatsɔa motsyɔvɔ la tsyɔa mo va se ɖe esime wòagatrɔ ayi be yeaƒo nu kple Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mose ƒo Israelviawo katã nu ƒu, eye wògblɔ na wo be, “Esiawoe nye Yehowa ƒe se siwo dzi wòle be miawɔ. ");
INSERT INTO ewe_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“Miwɔ dɔ ŋkeke ade ko. Ŋkeke adrelia nye dzudzɔgbe kple ŋkeke kɔkɔe si ŋu dɔ miawɔ asubɔ Yehowa. Ele na ame sia ame si awɔ dɔ le ŋkeke ma dzi la be wòaku. ");
INSERT INTO ewe_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Migado dzo gɔ̃ hã le miaƒe aƒewo me o.” ");
INSERT INTO ewe_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mose gblɔ na dukɔ blibo la be, “Yehowa gblɔ be, ");
INSERT INTO ewe_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Mi ame siwo katã lɔ̃ faa kple ame siwo katã ƒe dɔ me nyo la, mina nu siawo Yehowa: “sika, klosalo kple akɔbli, ");
INSERT INTO ewe_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","avɔ si wolɔ̃ kple aɖabɛ blɔtɔ kple hɛ̃tɔ, dzĩtɔ kple avɔ si wolɔ̃ kple ɖetika ɣi alo gbɔ̃fu, ");
INSERT INTO ewe_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","agbo kple nyigbalẽ siwo ƒe agbalẽ wode ama dzĩ, akasiati, ");
INSERT INTO ewe_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","akaɖimemi, atike ʋeʋĩwo hena ami sisi kple dzudzɔdodo, ");
INSERT INTO ewe_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","onikskpe kple kpe siwo ŋu dɔ woawɔ na kɔmewu kple akɔtaɖonu la. ");
INSERT INTO ewe_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Mi ame siwo katã nye aɖaŋudɔwɔlawo, eye ŋutete tɔxɛwo le mia si la, miva, eye miawɔ nu siwo Yehowa ɖo na mi be miawɔ: ");
INSERT INTO ewe_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“agbadɔ la, etamegbanuwo, eŋu ganuviwo kple ʋuƒowo, gametiwo, sɔtiwo kple woƒe afɔwo, ");
INSERT INTO ewe_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","nubablaɖaka la kple ati siwo woatsɔ akɔe, nubablaɖaka la ƒe nutuvi, Xɔmetsovɔ si ƒo xlã Kɔkɔeƒe la, ");
INSERT INTO ewe_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","kplɔ̃ la, ekɔtiwo kple eŋunuwo katã, Ŋkumeɖobolo la, ");
INSERT INTO ewe_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Akaɖiti la kple akaɖigbɛawo wo ŋunuwo kple ami, ");
INSERT INTO ewe_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","dzudzɔdovɔsamlekpui la kple ekɔtiawo, ami sisi la kple dzudzɔdotikeʋeʋĩwo, agbadɔ la ƒe xɔmemɔnuvɔ, ");
INSERT INTO ewe_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Numevɔsamlekpui la, akɔblidzrala la; atiawo kple wo ŋunuwo katã; tsileze la kple eƒe zɔ ");
INSERT INTO ewe_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","kplɔ̃ŋutivɔawo, sɔtiawo kple woƒe afɔtiwo, agbonuvɔ la, ");
INSERT INTO ewe_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","agbadɔ la ƒe tsyoti kple woƒe kawo, ");
INSERT INTO ewe_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","nunɔlawo ƒe awu nyui siwo wotɔ be woado hena subɔsubɔdɔwo wɔwɔ, nunɔla Aron kple via ŋutsuwo ƒe awu kɔkɔewo hena subɔsubɔwo wɔwɔ le Kɔkɔeƒe la.” ");
INSERT INTO ewe_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Israelviwo ƒe ha blibo la dzo le Mose gbɔ. ");
INSERT INTO ewe_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Ame siwo ƒe dzi Mawu ƒe Gbɔgbɔ ʋã la, tsɔ nunanawo vɛ na Yehowa hena agbadɔ la, eŋunuwo kple awu kɔkɔeawo. ");
INSERT INTO ewe_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Nyɔnuwo kple ŋutsuwo siaa, ame sia ame si lɔ̃ tso dzi me faa la va. Wotsɔ sika, togɛwo, asigɛwo, kɔgawo kple sikanu ƒomevi ɖe sia ɖe vɛ na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ame bubuwo tsɔ aɖabɛ blɔtɔ kple dzĩtɔ ƒe ka, ka dzĩ, ɖeti ɣi ƒe ka alo gbɔ̃fu kple agbogbalẽ si wode ama dzĩ kple gbɔ̃gbalẽ si ŋu wotrɔ asi le la vɛ. ");
INSERT INTO ewe_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ame bubuwo tsɔ klosalo kple akɔbli vɛ abe woƒe nunana na Yehowa ene. Ame aɖewo tsɔ akasiati vɛ hena agbadɔ la tutu. ");
INSERT INTO ewe_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Nyɔnu siwo nya nutɔtɔ kple ɖetitetre nyuie la tsɔ aɖabɛ blɔtɔ kple dzĩtɔ lɔ̃ avɔ, wotre ɖeti ɣi ƒe ka, eye wotsɔ wo vɛ. ");
INSERT INTO ewe_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Nyɔnu aɖewo wɔ aɖaŋu tɔxɛ tsɔ gbɔ̃fuwo lɔ̃ avɔe. ");
INSERT INTO ewe_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Amegãwo tsɔ onikskpe la vɛ be woatsɔ ɖo kɔmewu la kple akɔtaɖonu la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Wotsɔ atike ʋeʋĩwo kple ami vɛ na akaɖigbɛawo kple ami sisi kple dzudzɔdonuwo wɔwɔ. ");
INSERT INTO ewe_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ale Israelviwo, ŋutsu sia ŋutsu kple nyɔnu sia nyɔnu si lɔ̃ kple dzi faa be yeana kpekpeɖeŋu le dɔ si Yehowa de asi na Mose wɔwɔ me la tsɔ nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mose gblɔ na wo be, “Mikpɔ ɖa, Yehowa tia Bezalel, Uri ƒe viŋutsu kple Hur ƒe tɔgbuiyɔvi tso Yuda ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","eye wòtsɔ Mawu ƒe gbɔgbɔ si fiaa nunya, nugɔmesese, sidzedze la nɛ. ");
INSERT INTO ewe_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ate ŋu atsɔ sika, klosalo kple akɔbli awɔ nu siwo nya kpɔ lae. ");
INSERT INTO ewe_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Enya ale si woatsɔ kpe awɔ nuwo, eye woatsɔ atiwo akpa nuwoe. ");
INSERT INTO ewe_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Mawu na ŋutete tɔxɛ Bezalel kple Oholiab, ame siwo nye Ahisamak ƒe viŋutsuwo tso Dan ƒe to la me be woafia woƒe aɖaŋuwo ame bubuwo. ");
INSERT INTO ewe_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Mawu na aɖaŋu tɔxɛ ame eve siawo be woate ŋu awɔ sikanuwo, atsɔ ati akpa nuwo, eye woatsɔ ka vovovowo alɔ̃ nuwo ɖe avɔwo me. Wodze le ame sia ame ŋu le aɖaŋunu siwo katã míehiã na dɔ la wɔwɔ me. ");
INSERT INTO ewe_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Dɔwɔla siwo si aɖaŋu kple ŋutete tɔxɛwo le la nakpe ɖe Bezalel kple Oholiab ŋu le agbadɔ la tutu kple eŋunuwo wɔwɔ me abe ale si Yehowa gblɔe ene.” ");
INSERT INTO ewe_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Ale Mose yɔ Bezalel kple Oholiab kple ame bubu siwo katã Yehowa na ŋutetee, eye wolɔ̃ be yewoawɔ dɔ la be woadze dɔ la gɔme. ");
INSERT INTO ewe_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Mose tsɔ nu siwo Israelviwo dzɔ la na wo bena woatsɔ awɔ kɔkɔeƒe la ŋu dɔwoe. Nudzɔdzɔ bubuwo gavana ŋdi sia ŋdi. ");
INSERT INTO ewe_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Mlɔeba la, dɔa wɔlawo katã gblẽ woƒe dɔdeasiwo ɖi. ");
INSERT INTO ewe_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Woyi ɖado go Mose, eye wogblɔ nɛ be, “Nu siwo nètsɔ na mí be míatsɔ awɔ dɔ si Yehowa gblɔ be woawɔ la sɔ gbɔ wu esiwo míehiã na dɔa nu wuwu!” ");
INSERT INTO ewe_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Ale Mose ɖe gbeƒã na amewo katã le asaɖa la me be nudzɔdzɔ aɖeke megahiã o. Ale ameawo dzudzɔ nunanawo tsɔtsɔ vɛ, ");
INSERT INTO ewe_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","elabena nu siwo wotsɔ vɛ do ŋgɔ la su na dɔ la. ");
INSERT INTO ewe_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Aɖaŋuvɔlɔ̃lawo katã tsɔ avɔ blɔtɔ kple avɔ dzĩ ƒomevi eve wɔ avɔkpo ewo, eye wolɔ̃ Kerubiwo aɖaŋutɔe ɖe wo me hetsɔ wo wɔ Mawu ƒe dɔ lae. ");
INSERT INTO ewe_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Avɔawo katã sɔ; woƒe didime nye mita wuietɔ̃, wokeke mita eve. ");
INSERT INTO ewe_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Wotɔ avɔkpo atɔ̃ ɖe wo nɔewo nu, le didime nu, eye wogatɔ avɔkpo atɔ̃ mamlɛa hã nenema ke. Ale wokpɔ xɔgbãvɔ didi eve. ");
INSERT INTO ewe_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Wotɔ aɖabɛka blɔtɔ kpuikpuikpui blaatɔ̃ ɖe xɔgbãvɔ ɖe sia ɖe ƒe axa ɖeka ƒe didime, ale be gbãtɔ ƒe kawo sɔ ɖe evelia tɔwo nu. ");
INSERT INTO ewe_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Ale wotɔ ka kpuikpuikpui blaatɔ̃ hã ɖe xɔgbãvɔ la to le go kemɛ hã me, eye ɖe sia ɖe sɔ ɖe esi dze ŋgɔe la nu. ");
INSERT INTO ewe_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Emegbe la, wotsɔ sika tu ganuvi blaatɔ̃. Wosa ka kpuikpuikpuiawo ɖe ganuviawo ŋu ale wowɔ xɔgbãvɔ didi eveawo ɖekae, eye wona wòzu dzisasa na agbadɔ la. ");
INSERT INTO ewe_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Emegbe la, wotsɔ avɔ titri siwo wolɔ̃ kple gbɔ̃fu la ƒe teƒe wuiɖekɛ gbã agbadɔ lae. ");
INSERT INTO ewe_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Avɔkpo ɖe sia ɖe didi mita wuietɔ̃, eye wòkeke mita eve. ");
INSERT INTO ewe_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Bezalel tɔ avɔkpo atɔ̃ ɖekae, eye wòtɔ ade mamlɛa hã ɖekae, ale wozu avɔ gã didi eve. ");
INSERT INTO ewe_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Etɔ ka kpuikpuikpui ɖe avɔ gã didi ɖe sia ɖe ƒe axa ɖeka ŋu, ");
INSERT INTO ewe_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","eye wòtu gavi blaatɔ̃ kple akɔbli na ka kpuikpuikpuiawo, ale wotsya avɔ gã didi eveawo ɖe wo nɔewo nu. ");
INSERT INTO ewe_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Wotsɔ agbogbalẽ siwo woɖa kple ama dzĩ la tsyɔ gbɔ̃fuvɔawo dzi, eye wogatsɔ gbɔ̃gbalẽwo tsyɔ alẽgbalẽawo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Wotsɔ akasiati wɔ agbadɔ la ƒe ʋuƒowo, axadzitiwo kple daɖedziwo. ");
INSERT INTO ewe_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Sɔti ɖe sia ɖe kɔ mita ene, eye wòkeke sentimita blaade-vɔ-ade. ");
INSERT INTO ewe_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Woɖe do ɖe atiawo ƒe nugbɔwo ale be woate ŋu atɔ ati eve ɖe wo nɔewo nu nyuie. ");
INSERT INTO ewe_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Ʋuƒo blaeve nɔ agbadɔ la ƒe dziehe lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Wotsɔ klosalo wɔ afɔti blaene ɖe atiawo te: afɔti eve nɔ ati ɖe sia ɖe te. ");
INSERT INTO ewe_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Sɔti blaeve nɔ agbadɔ la ƒe anyiehe lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Zɔ blaene siwo wotu kple klosaloga la nɔ sɔtiawo te, eve nɔ ɖe sia ɖe te. ");
INSERT INTO ewe_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Wotu sɔti ade ɖe agbadɔ la ƒe ɣetoɖoƒe lɔƒo. Afi siae nye agbadɔ la megbe. ");
INSERT INTO ewe_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Sɔti bubu ɖeka nɔ dzogoe ɖe sia ɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Wotsɔ sikasigɛwo lé sɔtiawo kple dzogoedzitɔwo siaa ɖekae le eƒe dzigbe kple anyigbe siaa. ");
INSERT INTO ewe_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Ale sɔti enyi nɔ agbadɔ la ƒe ɣetoɖoƒekpa dzi, eye klosalozɔ wuiade nɔ wo te: eve nɔ ɖe sia ɖe te. ");
INSERT INTO ewe_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Le esia megbe la, wodze akasiati tsɔ ɖo sɔtiawo ŋu. Atɔ̃ nɔ agbadɔ la ƒe axa ɖeka dzi, ");
INSERT INTO ewe_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","atɔ̃ ganɔ axa evelia dzi, eye atɔ̃ bubu ganɔ agbadɔ la ŋgɔ le ɣetoɖoƒe lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Woɖo daɖedzitiawo ale gbegbe be wokpe le titina, eye wodo tso go ɖeka me yi go kemɛ me. ");
INSERT INTO ewe_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Wofa sika ɖe sɔtiawo kple akasiati dzedzeawo ŋu. Wotsɔ sika nyuitɔ wɔ asigɛawo. ");
INSERT INTO ewe_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Wotsɔ aɖabɛ blɔtɔ kple dzĩtɔ kple ɖeti ɣi ƒe kawo lɔ̃ xɔmetsovɔ la, eye wolɔ̃ Kerubiwo aɖaŋutɔe ɖe eme. ");
INSERT INTO ewe_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Wotsi xɔmetsovɔ la ɖe sikagatagbadzɛ ene siwo nɔ sɔti ene ŋu la ŋu. Wofa sika ɖe sɔtiawo ŋu, eye wotu wo ɖe klosalozɔ ene dzi. ");
INSERT INTO ewe_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Etsɔ avɔ si wolɔ̃ kple aɖabɛ blɔtɔ kple dzĩtɔ ƒe ka, ka dzĩ kple ɖeti ɣi ƒe ka la wɔ xɔmemɔnuvɔ na agbadɔ la. ");
INSERT INTO ewe_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Woƒo gatagbadzɛ atɔ̃ ɖe sɔti atɔ̃ ŋu. Wofa sika ɖe sɔtiawo kple woƒe helétiawo ŋu. Wotsɔ akɔbli wɔ zɔ na sɔtiawo, eye wotsɔ xɔmetsovɔ la de sɔtiawo ƒe gatagbadzɛawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Le esia megbe la, Bezalel tsɔ akasiati wɔ nubablaɖaka la. Edidi sentimita alafa ɖeka kple ewo, ekeke sentimita blaade-vɔ-ade, eye wòkɔ sentimita blaade-vɔ-ade. ");
INSERT INTO ewe_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Wofa sika nyuitɔ ɖe eme kple egodo siaa, eye wotsɔ sika mimli do atsiã na eto kpe ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ewɔ sikagagɔdɔ̃e ene siwo anɔ abe asigɛ ene, eye wòklã wo ɖe dzogoe ene siwo le ete la ŋu; sikagagɔdɔ̃e eve nɔ aɖaka la ƒe axa ɖe sia ɖe. ");
INSERT INTO ewe_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Etsɔ akasiati kpa kpo didi eve, fa sika ɖe wo ŋu, ");
INSERT INTO ewe_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","eye wòtsɔ wo ƒo ɖe sikasigɛawo me hena nubablaɖaka la kɔkɔ. ");
INSERT INTO ewe_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Le esia megbe la, etsɔ sika nyuitɔ wɔ nubablaɖaka la ƒe nutunu. Woyɔ nutunu sia be, “Amenuveveteƒe.” Edidi sentimita alafa ɖeka kple ewo, eye wòkeke sentimita blaade-vɔ-ade. ");
INSERT INTO ewe_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Etsɔ sika tu kerubi eve, eye wòtsɔ wo da ɖe sikanutunu la ƒe nu eveawo. ");
INSERT INTO ewe_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ewɔ kerubi ɖeka kple amenuvevezikpui la, eye wòwɔ ɖeka wònɔ nutunu la ƒe didime ƒe nu ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kerubi eveawo dze ŋgɔ wo nɔewo, wokeke woƒe aʋalawo ɖe “Amenuveveteƒe” la dzi, eye wode mo to ɖe edzi. ");
INSERT INTO ewe_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Emegbe la, etsɔ akasiati kpa kplɔ̃e. Kplɔ̃ la didi sentimita blaenyi-vɔ-enyi, ekeke sentimita blaene-vɔ-ene, eye wòkɔ sentimita blaade-vɔ-ade. ");
INSERT INTO ewe_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Wofa sika nyuitɔ ɖe eŋu eye wotsɔ sika mimli ɖo atsyɔ̃ na eto kpe ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Etsɔ sika wɔ toɖonu si kɔ abe milimita blaadre-vɔ-atɔ̃ ene la ɖo to na kplɔ̃ la kpe ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Etu sikasigɛ ene klã ɖe Kplɔ̃ la ƒe afɔ eneawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Wote ɖe atsyɔ̃ɖonu mimli la ŋu. Wowɔ wo be woatsɔ ati aƒo ɖe wo me hena aɖaka la kɔkɔ. ");
INSERT INTO ewe_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Wotsɔ akasiati kpa kpo siwo woatsɔ akɔ Kplɔ̃ lae, eye wofa sika ɖe wo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Hekpe ɖe esiawo ŋuti la, wotsɔ sika nyuitɔ wɔ agbawo, nutɔgbawo, detsikugbawo kple go siwo me woaku aha ɖo hena nunovɔsasa. ");
INSERT INTO ewe_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Egatsɔ sika nyuitɔ wɔ akaɖiti lae. Akaɖiti la ƒe zɔ, ati didi la, akaɖigbɛawo ƒe nɔƒe kple seƒoƒo siwo woatsɔ aɖo atsyɔ̃ na akaɖiti la katã nye nu blibo ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Alɔ ade nɔ akaɖiti la ŋu, etɔ̃ nɔ akpa ɖeka, eye etɔ̃ nɔ akpa evelia hã. ");
INSERT INTO ewe_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Kplu etɔ̃ siwo wowɔ abe yevuzi ƒe seƒoƒo siwo do, eye woke ene la, nanɔ alɔdze ɖeka ŋu, etɔ̃ nanɔ alɔdze bubu ŋu. Nenema ke wòanɔ na alɔdze adeawo katã, siwo le akaɖiti la kɔgo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Nenema ke woɖo atsyɔ̃ na akaɖiti la kple kplu ene siwo wowɔ ɖe “almɔd” seƒoƒo ƒe nɔnɔme me. ");
INSERT INTO ewe_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Seƒoƒo ɖeka kple eƒe tamekuku nɔ alɔdze eve ƒe kpeƒe; ɖeka nanɔ alɔdze eve siwo kplɔ gbãtɔ ɖo la ƒe kpeƒe, eye ɖeka hã nanɔ etɔ̃lia ƒe kpeƒe, ale be alɔdzeawo nanye ade. ");
INSERT INTO ewe_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Wotsɔ sika nyuitɔ wɔ atsyɔ̃ɖoɖoawo kple alɔawo katã wonye nu blibo ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Emegbe la, wotsɔ sika nyuitɔ wɔ akaɖigbɛ adre ɖe alɔawo, ɖovulãnuawo kple dzowɔgagbɛawo siaa ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Wotsɔ sika nyuitɔ si ƒe kpekpeme nye kilogram blaetɔ̃-vɔ-adre la wɔ akaɖiti la kple eŋunuwoe. ");
INSERT INTO ewe_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Wotsɔ akasiati kpa dzudzɔdovɔsamlekpui lae. Eƒe tame ƒe kekeme kple didime siaa sɔ, anɔ sentimita blaene-vɔ-atɔ̃. Ekɔ sentimita blaasiekɛ. Dzo ɖekaɖeka nɔ dzogoe etɔ̃ dzi; wowɔ wo ɖe dzudzɔdovɔsamlekpui la ŋu, wònye nu ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Efa sika nyuitɔ ɖe eŋuti keŋ, eye wòɖo atsyɔ̃ na eto kple sika. ");
INSERT INTO ewe_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Ewɔ sikagagɔdɔ̃e eve ɖe atsyɔ̃ɖonu la te, eye wògawɔ bubu eve ɖe axa eveawo hã dzi be woatsɔ atiwo aƒo ɖe wo me hena dzudzɔdovɔsamlekpui la kɔkɔ. ");
INSERT INTO ewe_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Wotsɔ akasiati kpa kpo didiawo, eye wofa sika ɖe wo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Le esiawo megbe la, etsɔ atike ʋeʋĩwo wɔ ami kɔkɔe si woasi na nunɔlawo. Egawɔ dzudzɔdonu kɔkɔe abe ale si amiʋeʋĩwɔla nyuitɔwo wɔnɛ ene. ");
INSERT INTO ewe_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bezalel kpa numevɔsamlekpui la hã kple akasiati. Etame ƒe didime kple eƒe kekeme siaa nye mita eve kple desimita eve. Eƒe kɔkɔme nye mita ɖeka kple desimita etɔ̃. ");
INSERT INTO ewe_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Dzo ene nɔ dzogoe eneawo dzi; wokpa wo kpe ɖe numevɔsamlekpui la ŋu wonye nu blibo ɖeka. Wofa akɔbli ɖe numevɔsamlekpui la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Etsɔ akɔbli wɔ vɔsamlekpui la ŋunuwo, afilɔnuwo, gagbɛwo, gafluwo kple dzoɖesonuwo. ");
INSERT INTO ewe_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Emegbe la, egatsɔ akɔbli wɔ adzrala, eye wòlée ɖe vɔsamlekpui la te godoo, le titina na anyigba kple vɔsamlekpui la te, le teƒe si woado dzo ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Wotu akɔblisigɛ ene ɖe adzrala la ƒe akpa eveawo ŋu be woatsɔ atiawo aƒo ɖe wo me hena ekɔkɔ. ");
INSERT INTO ewe_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Wotsɔ akasiati wɔ ekɔtiawo hãe, eye wofa akɔbli ɖe wo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Wotsɔ atiawo ƒo ɖe asigɛawo me le vɔsamlekpui la ƒe axawo dzi. Wotsɔ ʋuƒo wɔ vɔsamlekpui lae, eye do le eme. ");
INSERT INTO ewe_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Etsɔ akɔblihuhɔ̃e wɔ tsileze la kple eƒe zɔ. Nyɔnu siwo subɔna le agbadɔ la nu lae na ahuhɔ̃eawo wotsɔ wɔ woe. ");
INSERT INTO ewe_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Le esia megbe la, ewɔ xɔxɔnu ɖe agbadɔ la ŋu. Agbadɔ la ƒe akpa si le dziehe la didi mita blaene-vɔ-ene. Woxee kple avɔ si wolɔ̃ kple ɖetika ɣi, ");
INSERT INTO ewe_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ɖe kpɔti blaeve ŋu. Ke kpɔti blaeveawo ƒe afɔtiwo nye akɔbliga, eye wotsɔ klosaloga tu gatagbadzɛ siwo wotsɔ avɔawo kui la ɖe kpɔtiawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Woawɔ avɔ la nenema ke le anyiehe gome hã. Woaku avɔ mita blaene-vɔ-ene ɖe klosalogatagbadzɛawo ŋu, ɖe gakawo ŋu le kpɔtiawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Agbadɔ la keke mita blaeve-vɔ-ene le ɣetoɖoƒe gome. Wotsi avɔ la ɖe kpɔti ewo siwo te zɔ ɖekaɖeka le kple klosalogatagbadzɛawo kple klosalohelétiawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Ɣedzeƒe gome hã keke mita blaeve-vɔ-eve. ");
INSERT INTO ewe_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Avɔ la keke mita ade, desimita ade kple afã le agbadɔ la ƒe mɔnu ƒe akpa ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Nenema ke wotsi avɔ si keke mita ade, desimita ade kple afã la ɖe mɔnu la ƒe akpa evelia si te ɖe xɔxɔnu la ŋu, ɖe kpɔti etɔ̃ siwo te zɔ ɖekaɖeka le la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Wotsɔ ɖeti ɣi lɔ̃ avɔ siwo wotsi ƒo xlã agbadɔ lae. ");
INSERT INTO ewe_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Akɔblizɔ nɔ kpɔti ɖe sia ɖe te. Wotsɔ klosalo wɔ gatagbadzɛawo kple helétiawo katã. Wofa klosalo ɖe kpɔtiawo tame. Wotsɔ klosalo wɔ heléti siwo ŋu wotsi avɔ la ɖo. ");
INSERT INTO ewe_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Wotsɔ ɖeti ɣi lɔ̃ xɔmemɔnuvɔ, eye wolɔ̃ nu ɖe eme kple aɖabɛ blɔtɔ, dzĩtɔ kple hẽtɔ ƒe ka. Xɔmemɔnuvɔ la didi mita asieke. Ekeke mita eve abe avɔ siwo wotsi ƒo xlã xɔxɔnu la dometɔ ɖeka ene. ");
INSERT INTO ewe_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Wotsii ɖe kpɔti ene ŋu. Akɔblizɔ nɔ kpɔti ɖe sia ɖe te. Wotsɔ klosalo wɔ gatagbadzɛawo kple helétiawo. Wofa klosalo ɖe kpɔtiawo tame. ");
INSERT INTO ewe_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Wotsɔ akɔbli tu tsyoti siwo katã ŋu dɔ wowɔ le agbadɔ la tutu kple xɔxɔnu la wɔwɔ me. ");
INSERT INTO ewe_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Nu siwo katã agbadɔ la tutu lɔ ɖe eme la woe nye: agbadɔ si nye nubablaɖaka la ƒe nɔƒe, esi Levi ƒe viwo lé da ɖi le Mose ƒe sedede nu, eye wowɔ esia le Aron ƒe viŋutsu, nunɔla Itamar ƒe kpɔkplɔ te. ");
INSERT INTO ewe_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Aɖaŋutɔwo ƒe tatɔwoe nye Bezalel, Uri ƒe viŋutsu kple Hur si tso Yuda ƒe to la me ƒe tɔgbuiyɔvi. Wowɔ nu sia nu pɛpɛpɛ abe ale si Yehowa de se na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Bezalel ƒe kpeɖeŋutɔe nye Oholiab, ame si nye Ahisamak, tso Dan ƒe to la me la ƒe viŋutsu. Eya hã nye aɖaŋutɔ gã aɖe, eye wòde ŋgɔ le nukpakpa kple avɔlɔlɔ̃ me hekpe ɖe nulɔlɔ̃ ɖe avɔwo me kple aɖabɛ blɔtɔ kple dzĩtɔ ƒe ka, ka dzĩ kple ɖeti ɣi dada ƒe ka ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Sika si katã ŋu dɔ wowɔ le Kɔkɔeƒe la tutu me hekpe ɖe sika si wotsɔ wɔ nunyevɔsa tɔ ŋu la le “tɔn” ɖeka, le Kɔkɔeƒe la ƒe nudanu nu. ");
INSERT INTO ewe_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Klosalo si woxɔ le amewo si la ƒe kpekpemee nye kilogram akpe etɔ̃, alafa ene blaetɔ̃, le Kɔkɔeƒe la ƒe nudanu nu. ");
INSERT INTO ewe_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Ŋutsu siwo katã woxlẽ, woxɔ ƒe blaeve alo wu nenema la dometɔ ɖe sia ɖe dzɔ gram ade si woɖo na wo le kɔkɔeƒe la ƒe nudanu nu. Ŋutsu siawo ƒe xexlẽmee nye akpe alafa ade kple etɔ̃, alafa atɔ̃ blaatɔ̃ (603,550). ");
INSERT INTO ewe_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Wotsɔ klosalo kilogram akpe etɔ̃ alafa ene (3,400) wɔ zɔwo na kɔkɔeƒe la ƒe sɔti kple kpɔti siwo ŋu wotsi xɔmetsovɔ la ɖo. Wotsɔ klosalo kilogram blaetɔ̃-vɔ-ene wɔ zɔ ɖeka. ");
INSERT INTO ewe_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Wotsɔ klosalo si susɔ la fa ɖe kpɔtiawo tame, eye wotsɔ mamlɛa tu helétiawo kple gatagbadzɛawo. ");
INSERT INTO ewe_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Akɔbli si wokpɔ tso nunyevɔsa me la le “tɔn” eve kple afã, ");
INSERT INTO ewe_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","eye wotsɔe tu zɔ na kpɔti siwo le agbadɔ la ƒe mɔnu. Wotsɔ eya ke wɔ vɔsamlekpui la, lãyiga la kple nu siwo ŋu dɔ woawɔ le vɔsamlekpui la dzi, ");
INSERT INTO ewe_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","kpɔti siwo ŋu wotsi avɔ ɖo ƒo xlã xɔxɔnu la ƒe zɔwo kple tsyoti siwo katã ŋu dɔ wowɔ le agbadɔ la tutu kple xɔxɔnu la wɔwɔ me. ");
INSERT INTO ewe_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Le esiawo megbe la, ameawo tsɔ avɔ siwo wolɔ̃ kple aɖabɛ blɔtɔ kple dzĩtɔ ƒe ka, ka dzĩ kple ɖeti ɣi ƒe ka la tɔ awu nyuiwo na nunɔlawo be woado hena woƒe subɔsubɔdɔwo wɔwɔ le Kɔkɔeƒe la. Wotsɔ avɔ sia ke tɔ Aron ƒe awu kɔkɔewo abe ale si Yehowa ɖo na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Wotsɔ avɔ sia ke si wolɔ̃ kple sika, aɖabɛka blɔtɔ, dzĩtɔ kple hẽtɔ kple ɖetika ɣitɔ tɔ kɔmewu la hã. ");
INSERT INTO ewe_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Bezalel tu sika wòzu falɛe, eye wòfe eme wòzu sikaka suesuewo. Etsɔ wo na aɖaŋuvɔlɔ̃lawo be woalɔ̃ nu ɖe avɔ si wolɔ̃ kple aɖabɛ blɔtɔ kple dzĩtɔ ƒe ka, ka dzĩ kple ɖeti ɣi ƒe ka la me. Enye aɖaŋu nyui aɖe si nya kpɔ ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Wode ka abɔta na kɔmewu la, eye woku wo ɖe kɔmewu la ƒe dzogoe eve ŋuti ale be woate ŋu asae. ");
INSERT INTO ewe_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Alidziblanu si wolɔ̃ kple aɖaŋu la sɔ kplii, wotsɔ sika, ɖetika ɣi, blɔtɔ, dzĩtɔ kple hẽtɔ lɔ̃ wo kple kɔmewu la ɖekae abe ale si Yehowa gblɔ na Mose ene la tututu. ");
INSERT INTO ewe_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Wotsɔ sika wɔ kae, eye wotsɔ sikaka la lé onikskpe eve siwo wotɔ ɖe abɔtaka si le kɔmewu la ŋu lae. Woŋlɔ Israelviwo ƒe ŋkɔwo ɖe kpeawo dzi, ");
INSERT INTO ewe_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","eye wotɔ wo ɖe Kɔmewu la ƒe abɔtawo hena ŋkuɖoɖo Israelviwo dzi, abe ale si Yehowa de se na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Akɔtawu la hã nyo abe kɔmewu la ene. Wowɔ eya hã kple sika nyuitɔ, aɖabɛ blɔtɔ kple dzĩtɔ ƒe kawo, ka dzĩ kple ɖeti ɣi ƒe kawo abe kɔmewu la ke ene. ");
INSERT INTO ewe_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Edidi sentimita blaeve-vɔ-eve, eye wòkeke nenema ke. Woŋee ɖe akpa eve ale wòzu kotoku aɖe tɔgbi. ");
INSERT INTO ewe_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Woɖo kpe xɔasiwo ɖe fli ene me ɖe edzi. Kanelian, krisolit kple beril nɔ fli gbãtɔ me. ");
INSERT INTO ewe_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Tɔkuɔs lapis lazuli kple emerald nɔ fli evelia me. ");
INSERT INTO ewe_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Yasint, agate kple ametist nɔ fli etɔ̃lia me. ");
INSERT INTO ewe_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Topaz, oniks kple yaspa nɔ fli enelia me. Wotsɔ sika gbi kae fa ɖe wo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Woŋlɔ Israelviwo ƒe to wuieveawo ƒe ŋkɔwo ɖe kpe xɔasiawo dzi. ");
INSERT INTO ewe_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Wotsɔ ka si wotsɔ sika nyuitɔ gbie la ɖo akɔtawu la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Sikaka eve tsi ɖe sikanulénu eve ŋu le abɔtawu la ƒe dzogoe eveawo tame; ");
INSERT INTO ewe_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","wosa sikaka eveawo ɖe asigɛ eveawo ŋu ");
INSERT INTO ewe_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","eye wotɔ sikakɔsɔkɔsɔawo ƒe nu eveliawo ɖe onikskpe eveawo ŋu le akɔtawu la ƒe ŋgɔgbe. ");
INSERT INTO ewe_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Wogatɔ sikasigɛ eve ɖe abɔtaka eveawo ŋu ɖe Akɔtawu la te, wote ɖe afi si wokpe alidziblanu la le la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Wogatɔ sikasigɛ eve ɖe Kɔmewu la ƒe abɔtaka la te, wote ɖe afi si wotsi kɔmewu la ɖe alidziblanu la ŋu la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Wotsi Akɔtawu la ɖe Kɔmewu la ŋu sesĩe esi wotsɔ ka blɔtɔ sa ɖe Akɔtawu la ƒe sikasigɛ kple Kɔmewu la ƒe sikasigɛ ŋu. Yehowae ɖo esiawo katã na Mose. ");
INSERT INTO ewe_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Wotsɔ avɔ blɔtɔ tɔ Kɔmewu lae. ");
INSERT INTO ewe_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Woɖe teƒe ɖe kɔmewu la titina, afi si ame ƒe ta nato. Woƒo to na teƒe sia ale be mavuvu o. ");
INSERT INTO ewe_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Wotsɔ avɔ si me wotsɔ aɖabɛ blɔtɔ kple dzĩtɔ ƒe ka kple ka dzĩ kple ɖeti ɣi ƒe ka lɔ̃ nu ɖo la wɔ yevuboɖawo ɖe awu la to le ete godoo. ");
INSERT INTO ewe_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Wotsi nyawowoe siwo wotu kple sika nyuitɔ la ɖe yevuboɖa eve ɖe sia ɖe dome le awu la to. ");
INSERT INTO ewe_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Nyawowoe ɖeka nɔ yevuboɖa eve dome; aleae wòle awu ʋlaya la to kpe ɖo. Awu siae woado hena subɔsubɔ abe ale si Yehowa ɖo na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Azɔ la, wotsɔ avɔ si wolɔ̃ kple ɖeti ɣi la tɔ awu ʋlayawo na Aron kple via ŋutsuwo. ");
INSERT INTO ewe_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Wotsɔ avɔ sia ke tɔ akɔtawuwo, tablanuwo, kukuwo kple awutewuiwo kple alidziblakawoe. ");
INSERT INTO ewe_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Ke wotsɔ aɖabɛka blɔtɔ kple dzĩtɔ kple ka dzĩ lɔ̃ nuwo ɖe alidziblanuawo me abe ale si Yehowa gblɔ na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Le esiawo katã megbe la, wotsɔ sika nyuitɔ wɔ ganuvi kɔkɔe si anɔ tablanu la ƒe ŋgonu. Woŋlɔ ɖe ganu sia dzi be, wokɔ eŋuti na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Wotsɔ ka blɔtɔ lé ganu sia ɖe tablanu la ƒe ŋgonu abe ale si Yehowa gblɔ na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Wozɔ ɖe ɖoɖo siwo katã Yehowa na Mose la nu. Ale wowu agbadɔ la nu mlɔeba. ");
INSERT INTO ewe_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Azɔ la, wokɔ agbadɔ blibo la ŋunuwo yi Mose gbɔ: xɔmenuwo, ganuviawo, ʋuƒowo, gametiwo, sɔtiwo, afɔwo; ");
INSERT INTO ewe_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","agbogbalẽ siwo wode ama dzĩi hena agbadɔ la tame kple eƒe axawo kple xɔmenuwo; ");
INSERT INTO ewe_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","nubablaɖaka la, Se Ewoawo le eme; atiawo hena nubablaɖaka la kɔkɔ, amenuveteƒe la; ");
INSERT INTO ewe_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","kplɔ̃ la kple eŋunuwo katã; ŋkumeɖobolo la; ");
INSERT INTO ewe_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","sikakaɖiti la, akaɖigbɛawo, wo ŋunuwo kple ami; ");
INSERT INTO ewe_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Sikavɔsamlekpui la, ami sisi la, Dzudzɔdonu ʋeʋĩ la, agbadɔnuvɔ la; ");
INSERT INTO ewe_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Akɔblivɔsamlekpui la, akɔblidzrala la; atiawo kple wo ŋunuwo katã; tsileze la kple eƒe zɔ; ");
INSERT INTO ewe_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Xɔxɔnu la ŋu ƒe avɔwo kple woƒe tsyotiwo, xɔxɔnu la ƒe agbonuvɔwo, kpɔtiawo; woƒe zɔwo, woƒe kawo kple gatagbadzɛawo; nu siwo katã ŋu dɔ wowɔ le agbadɔ la tutu me. ");
INSERT INTO ewe_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Emegbe la, wotsɔ awu nyui siwo wotɔ be woado hena subɔsubɔdɔwo wɔwɔ, nunɔla Aron kple via ŋutsuwo ƒe awu kɔkɔewo hena subɔsubɔwo wɔwɔ le Kɔkɔeƒe la. ");
INSERT INTO ewe_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ale Israelviwo wɔ dɔ blibo la pɛpɛpɛ abe ale si Yehowa ɖo na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mose lé ŋku ɖe dɔ blibo la ŋu. Eyra ameawo, elabena wowɔ dɔ blibo la ɖe ale si Yehowa ɖo nɛ la nu pɛpɛpɛ. ");
INSERT INTO ewe_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Azɔ la, Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Tu agbadɔ la le ɣleti gbãtɔ ƒe ŋkeke gbãtɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Tsɔ nubablaɖaka si me Se Ewoawo le la de eme, eye nàtsi xɔmetsovɔ la ale be wòaɣla nubablaɖaka la ɖe Kɔkɔeƒe ƒe Kɔkɔeƒe la. ");
INSERT INTO ewe_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Emegbe la, kɔ kplɔ̃ la da ɖe eme, nàkɔ kplɔ̃a ŋutinuwo da ɖe kplɔ̃ la dzi, nàtsɔ akaɖiti la de eme, eye nàsi akaɖiawo. ");
INSERT INTO ewe_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Kɔ sikavɔsamlekpui si dzi woado dzudzɔ ɖo la da ɖe nubablaɖaka la ŋgɔ. Tsi xɔmemɔnuvɔawo ɖe agbadɔ la ƒe mɔnu, ");
INSERT INTO ewe_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","eye nàkɔ numevɔsamlekpui la da ɖe agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kɔ tsileze la da ɖe Mawu ƒe agbadɔ la kple vɔsamlekpui la dome, eye nàku tsi ɖe eme. ");
INSERT INTO ewe_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Le esia megbe la, wɔ xɔxɔnu la ƒo xlã agbadɔ la godoo, eye nàtsi xɔmemɔnuvɔ la ɖe xɔxɔnu la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Tsɔ ami sisi la, eye nàhlẽe ɖe agbadɔ la kple nu sia nu si le eme la ŋuti, ɖe nu siwo ŋu dɔ woawɔ kple agbadɔ la ƒe akpawo kple xɔmenuawo ŋuti be nàkɔ wo ŋuti, eye wo ŋuti nakɔ. ");
INSERT INTO ewe_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Hlẽ ami sisi la ɖe numevɔsamlekpui la kple eŋunuwo ŋuti, eye nàkɔ wo ŋu; ekema vɔsamlekpui la ŋuti akɔ nyuie. ");
INSERT INTO ewe_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Si ami na tsileze la kple eƒe zɔ, eye nàwɔe kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Azɔ la, kplɔ Aron kple via ŋutsuwo va agbadɔ la ƒe mɔnu eye nàle tsi na wo. ");
INSERT INTO ewe_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Do awu kɔkɔewo na Aron eye nàsi ami nɛ, akɔ eŋu be wòasubɔm abe nunɔla ene. ");
INSERT INTO ewe_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Emegbe la, nàkplɔ via ŋutsuwo vɛ, nàdo woƒe awuwo na wo, ");
INSERT INTO ewe_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","eye nàsi ami na wo abe ale si nàsii na wo fofo ene, ale be woasubɔm abe nunɔlawo ene. Ami sisi sia atsi wo ŋu tegbetegbe, tso mavɔ me yi mavɔ me: wo viwo katã kple wo viwo ƒe viwo azu nunɔlawo nam tegbetegbe.” ");
INSERT INTO ewe_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Ale Mose de asi nu siwo katã Yehowa ɖo nɛ be wòawɔ la wɔwɔ me. ");
INSERT INTO ewe_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Le ƒe evelia ƒe ɣleti gbãtɔ ƒe ŋkeke gbãtɔ dzi la, wotu agbadɔ la. ");
INSERT INTO ewe_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mose kɔ zɔwo de sɔtiawo te, eye wòklã ʋuƒowo ɖe sɔtiawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ekeke avɔ la ɖe atixɔ la ŋu, eye wòda tamenuwo ɖe edzi abe ale si Yehowa ɖo nɛ pɛpɛpɛ la ene. ");
INSERT INTO ewe_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Etsɔ kpe siwo dzi woŋlɔ Se Ewoawo ɖo la da ɖe nubablaɖaka la me, etsi aɖakatsɔtiawo ɖe eŋu, eye wòtsɔ sikanutunu, amenuveveteƒe la tu enu. ");
INSERT INTO ewe_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Emegbe la, ekɔ nubablaɖaka la va agbadɔ la me, eye wòtsɔ xɔmetsovɔ la xe eŋkume abe ale si Yehowa ɖo nɛ pɛpɛpɛ la ene. ");
INSERT INTO ewe_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Azɔ la, ekɔ Kplɔ̃ la da ɖe Mawu ƒe agbadɔ la me le anyiehe lɔƒo, le xɔmetsovɔ la godo, ");
INSERT INTO ewe_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","eye wòtsɔ ŋkumeɖobolo la da ɖe kplɔ̃ la dzi le Yehowa ŋkume abe ale si Yehowa ɖo nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Mose kɔ akaɖiti la da ɖe kplɔ̃ la kasa le agbadɔ la me le dziehe lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Esi akaɖiawo le Yehowa ŋkume le ɖoɖoawo nu, ");
INSERT INTO ewe_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","eye wòkɔ sikavɔsamlekpui la da ɖe agbadɔ la me te ɖe xɔmetsovɔ la ŋu. ");
INSERT INTO ewe_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Etsɔ atike ʋeʋĩwo do dzudzɔ ɖe edzi abe ale si Yehowa ɖo nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Etsi xɔmemɔnuvɔ la ɖe agbadɔ la ƒe mɔnu, ");
INSERT INTO ewe_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","ekɔ numevɔsamlekpui la da ɖe gota te ɖe agbadɔ la ƒe mɔnu ŋu, eye wòme numevɔsa kple nuɖuvɔsa le vɔsamlekpui la dzi abe ale si Yehowa ɖo nɛ pɛpɛpɛ la ene. ");
INSERT INTO ewe_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Emegbe la, ekɔ tsileze la da ɖe Mawu ƒe agbadɔ la kple vɔsamlekpui la dome. Eku tsi ɖe eme wòyɔ ale be nunɔlawo ate ŋu awɔ eŋu dɔ le asikɔklɔ kple afɔkɔklɔ me. ");
INSERT INTO ewe_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mose kple Aron kple Aron ƒe viŋutsuwo klɔ woƒe asiwo kple afɔwo le afi sia. ");
INSERT INTO ewe_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Ɣe sia ɣi si woato vɔsamlekpui la ŋu be yewoage ɖe agbadɔ la me la, wotɔna, klɔa asi kple afɔ, abe ale si Yehowa ɖo na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Azɔ la, Mose tɔ kpɔ ƒo xlã nɔƒe la kple vɔsamlekpui la, eye wòtsi xɔmemɔnuvɔ ɖe nɔƒe la ƒe mɔnu. Ale Mose wu eƒe dɔ la nu mlɔeba. ");
INSERT INTO ewe_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Tete lilikpo la tsyɔ Mawu ƒe agbadɔ la dzi eye Yehowa ƒe ŋutikɔkɔe yɔ eme. ");
INSERT INTO ewe_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mose mete ŋu ge ɖe eme o, elabena lilikpo la nɔ afi ma, eye Yehowa ƒe ŋutikɔkɔe yɔ agbadɔ la me fũu. ");
INSERT INTO ewe_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ne lilikpo la ho, eye wòɖe zɔ la, Israelviwo yia mɔzɔzɔ la dzi, dzea eyome. ");
INSERT INTO ewe_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Ke ne lilikpo la tɔ la, woawo hã wotɔna va se ɖe esime lilikpo la gaɖe zɔ. ");
INSERT INTO ewe_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Yehowa ƒe lilikpo la tɔna ɖe agbadɔ la dzi le ŋkeke me. Ke le zã me la, dzo klẽna le lilikpo la me, ale be Israelviwo katã nate ŋu akpɔe. Nu sia yi edzi le woƒe mɔzɔzɔwo katã me.");
INSERT INTO ewe_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Azɔ la, Yehowa ƒo nu na Mose tso Mawu ƒe agbadɔ la me hegblɔ be, ");
INSERT INTO ewe_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Ƒo nu na Israelviwo eye nàgblɔ na wo be, ‘Ne mia dometɔ aɖe atsɔ nunana vɛ na Yehowa la, netsɔ nyi alo alẽ vɛ abe eƒe nunana ene. ");
INSERT INTO ewe_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Ne nunana la anye numevɔsa tso lãhawo dome la, ele be wòana lãtsu si ŋuti kpɔtsɔtsɔ mele o. Ele be wòanae le agbadɔ la ƒe mɔnu ale be wòadze Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Ele be wòatsɔ eƒe asi ada ɖe numevɔsa la ƒe ta dzi, eye woaxɔ numevɔsa la ɖe vɔsalã la teƒe be wòalé avu ɖe enu. ");
INSERT INTO ewe_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ekema amea awu nyitsuvi la le afi ma le Yehowa ŋkume. Aron ƒe viŋutsuwo, ame siwo nye nunɔlawo la atsɔ ʋu la ahlẽ ɖe vɔsamlekpui si le agbadɔ la ƒe mɔnu la ƒe axawo katã ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Ele nɛ be wòako numevɔsalã la eye wòaflii. ");
INSERT INTO ewe_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Aron ƒe viŋutsu siwo nye nunɔlawo la ado dzo ɖe vɔsamlekpui la dzi, eye woaɖo nake ɖe dzo la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ekema Aron ƒe viŋutsuwo, nunɔlawo, atsɔ lãkɔwo, eƒe ta kple ami ada ɖe nakeawo dzi le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Amea aklɔ eƒe dɔmenuwo kple afɔwo, nunɔla la atɔ dzo wo ɖe vɔsamlekpui la dzi, eye woazu numevɔsa kple dzovɔsa si ƒe ʋeʋẽ adze Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Ne vɔsa la nye numevɔsa tso alẽhawo alo gbɔ̃hawo dome la, ele nɛ be wòana atsua si ŋuti kpɔtsɔtsɔ mele o la. ");
INSERT INTO ewe_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ame si le vɔ la sam la awui le Yehowa ŋkume le vɔsamlekpui la ƒe anyiehe lɔƒo. Aron ƒe viŋutsuwo, ame siwo nye nunɔlawo la ahlẽ lã la ƒe ʋu ɖe vɔsamlekpui la ŋu akpe ɖo. ");
INSERT INTO ewe_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ekema amea afli lã la, eye nunɔla la atsɔ lãkɔawo, lã la ƒe ta kple eƒe ami ada ɖe nakeawo dzi le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ke amea aklɔ dɔmenuawo kple afɔawo, eye nunɔlawo atɔ dzo wo katã le vɔsamlekpui la dzi. Anye numevɔsa kple dzovɔsa si ƒe ʋeʋẽ ado dzidzɔ na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Ne nunana na Yehowa nye numevɔsa si woawɔ kple xevi la, ele be wòanye akpakpa alo ahɔnɛvi. ");
INSERT INTO ewe_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Nunɔla la atsɔ xevi la ayi vɔsamlekpui la gbɔ, atro kɔ le enu, ana eƒe ʋu naɖuɖu ɖe anyi le vɔsamlekpui la ƒe axadzi, eye woame lã la le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Nunɔla la aɖe eƒe agbonu kple emenuwo, eye wòatsɔ wo aƒu gbe ɖe vɔsamlekpui la ƒe ɣedzeƒe lɔƒo, afi si dzowɔ le la. ");
INSERT INTO ewe_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Emegbe la, alé eƒe aʋalawo, eye wòafe xevi la me, gake eƒe aʋalawo maɖe ɖa le xevi la ŋu o. Azɔ la, nunɔla la atɔ dzoe le vɔsamlekpui la dzi, eye wòanye vɔsa si adze Yehowa ŋu. Enye numevɔsa kple dzovɔsa si ƒe ʋeʋẽ adze Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Ame si di be yeasa nuɖuvɔ na Yehowa la atsɔ wɔ memee, akɔ ami kple dzudzɔdotike ɖe edzi, ");
INSERT INTO ewe_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","eye wòatsɔe ana Aron ƒe viŋutsuwo, nunɔlawo. Nunɔla la aɖe wɔ memee la kple ami la ƒe asiʋlo ɖeka akpe ɖe dzudzɔdonuawo katã ŋuti, eye wòafiae abe ŋkuɖodzinu ene le vɔsamlekpui la dzi, wòanye numevɔsa, ʋeʋĩ lĩlĩlĩ si dzea Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Woatsɔ wɔ la ƒe mamlɛa ana Aron kple via ŋutsuwo abe woƒe nuɖuɖu ene; ke woabu esiawo katã abe nuɖuvɔsa kɔkɔe na Yehowa ene. ");
INSERT INTO ewe_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Ne wotsɔ abolo si wome le kpo me vɛ abe vɔsa na Yehowa ene la, ele be woamee kple wɔ memee kple ami, gake amɔʋãtike manɔ eme o. Woate ŋu atsɔ akpɔnɔ si wome kple wɔ maʋamaʋã, eye wokɔ ami ɖe edzi hã ana abe nuɖuvɔsa ene. ");
INSERT INTO ewe_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Ne woatɔ nane kple ami atsɔ ana abe nuɖuvɔsa ene la, woatsɔ wɔ memee maʋamaʋã atɔe. ");
INSERT INTO ewe_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Woaflii kakɛkakɛ, eye woakɔ ami ɖe edzi. Esia hã nye nuɖuvɔsa aɖe. ");
INSERT INTO ewe_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Ne wò nuɖuvɔsa nye nu si woɖa la, woaɖae kple wɔ memee, eye woakɔ ami ɖe edzi. ");
INSERT INTO ewe_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ne wò nuɖuvɔsa nye nu si wome le kpo me, tɔ alo mee le dzo dzi la, ele be nàtsɔ nuɖuvɔsa la ayi na nunɔla, eye eya atsɔe ayi vɔsamlekpui la dzi, eye eya atsɔe ana Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Nunɔlaa atɔ dzo vɔsanu la ƒe akpa aɖe ko, ke Yehowa akpɔ ŋudzedze le vɔsanu blibo la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Vɔsanu mamlɛa nye Aron kple viawo tɔ, ke woabu wo katã abe numevɔsa kɔkɔe na Yehowa ene. ");
INSERT INTO ewe_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Mele be amɔʋãtike nanɔ nuɖuvɔsa siwo mietsɔna vaa Yehowa ŋkume la me o, elabena mele be miatɔ dzo nuʋãtike alo anyitsi le dzovɔsa si miewɔna na Yehowa la me o. ");
INSERT INTO ewe_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Miate ŋu atsɔ wo vɛ na Yehowa abe nukuwo ƒe ŋgɔgbetɔwo ƒe nunanawo ene, gake mele be woatɔ dzo wo le vɔsamlekpui la dzi abe nu si aʋẽ lĩlĩlĩ la ene o. ");
INSERT INTO ewe_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Mide dze miaƒe nuɖuvɔsawo katã me. Migagbe nubabla ƒe dze si nye miaƒe Mawu tɔ dede miaƒe nuɖuvɔsawo me o; mide dze miaƒe vɔsawo katã me. ");
INSERT INTO ewe_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Ne ètsɔ nane tso wò agblemenuku gbãtɔwo me, awɔ nuɖuvɔsa na Yehowa la, ele na wò be nànyɔ bli la, nàtoe alo nàtɔe hafi atsɔ vɛ. ");
INSERT INTO ewe_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kɔ ami ɖe edzi, eye nàkpe dzudzɔdonu ɖe eŋu, elabena nuɖuvɔsae. ");
INSERT INTO ewe_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Ekema nunɔla la atɔ dzo bli gbagbã la kple amia ƒe ɖe kple dzudzɔdonu la katã abe dzovɔsa ene na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Ne ame aɖe di be yeasa akpedavɔ la, ate ŋu atsɔ nyitsu alo nyinɔ asa vɔ lae, gake lã la nade blibo ne woatsɔe asa vɔe na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Ame si tsɔ lã la vɛ la ada asi ɖe lã la ƒe ta dzi, eye wòawui le agbadɔ la ƒe mɔnu. Aron ƒe viŋutsu siwo nye nunɔlawo la ahlẽ ʋu la ɖe vɔsamlekpui la ƒe axawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Tso akpedavɔsa la me la, asa numevɔ na Yehowa kple ami siwo katã le dɔmenuawo ŋu alo ku ɖe wo ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ayiku eveawo kple ami si le wo ŋu le lã la ƒe ali gbɔ kple esi le aklã la ŋu; aɖewo kple ayikuawo. ");
INSERT INTO ewe_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Nunɔlaawo atɔ dzo nu siawo katã le vɔsamlekpui la dzi hekpe ɖe numevɔsa la ŋu. Nuɖuvɔsa sia anye ʋeʋẽ lĩlĩlĩ si adze Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Ne wotsɔ gbɔ̃ alo alẽ sa akpedavɔe na Yehowa la, ele be wòade blibo; ate ŋu anye agbo alo alẽnɔ, gbɔ̃tsu alo gbɔ̃nɔ. ");
INSERT INTO ewe_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Nenye alẽvie wòatsɔ vɛ la, ele be wòatsɔe ava Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Ele be wòada eƒe asi ɖe lã la ƒe ta dzi, eye wòawui le Mawu ƒe agbadɔ la ŋkume. Ekema Aron kple via ŋutsuwo ahlẽ ʋu la ɖe vɔsamlekpui la ƒe axawo katã ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Eye woatɔ dzo eƒe ami, eƒe asike, woalã asike la ɖa tso lã la ƒe dzimeƒu ŋu, ami si le eƒe dɔmenuwo ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ayiku eveawo kple ami si le wo ŋu kple aklã. ");
INSERT INTO ewe_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Nunɔla la atɔ dzo nu siawo le vɔsamlekpui la dzi wòanye nuɖuvɔsa na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Ne ame aɖe tsɔ gbɔ̃ vɛ be yeasa vɔ na Yehowa la, ");
INSERT INTO ewe_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","atsɔ eƒe asi ada ɖe gbɔ̃ la ƒe ta dzi, eye wòawui le Agbadɔ la ƒe mɔnu. Aron viŋutsuwo ahlẽ eƒe ʋu ɖe vɔsamlekpui la ƒe axawo kple ene ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","eye wòatɔ dzo ami si le dɔ me nɛ ");
INSERT INTO ewe_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","kple ayiku eveawo kple ami si le wo ŋu te ɖe lã la ƒe ali ŋu kple ami si le lã la ƒe aklã ŋu la, esi woaɖe ɖa kple ayikuawo. ");
INSERT INTO ewe_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Nunɔla la atɔ dzo wo le vɔsamlekpui la dzi abe nuɖuɖu ene, wòanye numevɔsa, wòanye nu si le ʋeʋẽm nyuie. Ami la katã nye Yehowa tɔ. ");
INSERT INTO ewe_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Esia nye se na mi tegbetegbe le miaƒe anyigba blibo la dzi be miekpɔ mɔ aɖu ami alo ʋu o.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yehowa gade se siawo na Mose: ");
INSERT INTO ewe_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Gblɔ na Israelviwo be, ‘esiawoe nye se siwo ku ɖe ame siwo ada le Yehowa ƒe seawo dzi le ŋuɖeɖi me la ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Ne nunɔla aɖe wɔ nu vɔ̃ le ŋuɖeɖi me, eye wòto esia me he fɔɖiɖi va ameawo dzi la, ele nɛ be wòatsɔ nyitsuvi fɛ̃ si de blibo la asa nu vɔ̃ ŋuti vɔsa na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Ele be wòakplɔ nyitsuvi fɛ̃ la ava Agbadɔ la ƒe mɔnu, atsɔ eƒe asi ada ɖe nyitsu la ƒe ta dzi, eye wòawui le afi ma le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Ekema nunɔla la atsɔ nyitsu la ƒe ʋu ayi Agbadɔ la me, ");
INSERT INTO ewe_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ade eƒe asibidɛ ʋu la me, eye wòahlẽ ʋu la zi adre le Yehowa ŋkume ɖe xɔmetsovɔ si ma Kɔkɔeƒewo ƒe Kɔkɔeƒe la me la ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Emegbe la, nunɔla la asisi ʋu la ƒe ɖe ɖe dzudzɔdovɔsamlekpui la ƒe dzowo ŋu le Yehowa ŋkume le Agbadɔ la me; atsɔ ʋua mamlɛa akɔ ɖe numevɔsamlekpui la te le Agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Le esia megbe la, nunɔla la aɖe ami le nyitsua ƒe dɔmenuawo, ");
INSERT INTO ewe_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ayiku eveawo kple aklã la ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","eye wòatɔ dzo wo ɖe numevɔsamlekpui la dzi abe ale si wotsɔa nyitsu alo nyinɔ sãa akpedavɔ ene tututu. ");
INSERT INTO ewe_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ke atsɔ nyitsu la ƒe ayi kple eƒe lã katã, kpe ɖe eƒe ta kple afɔwo ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","kple nyitsu la ƒe lã mamlɛa katã ayi asaɖa la godo, teƒe si ŋuti kɔ kple afi si wotsɔa afi ƒua gbe ɖo la, eye wòatɔ dzoe le nakedzo dzi le afi si woli kɔe la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Ne Israel dukɔ blibo la wɔ nu vɔ̃ le ŋuɖeɖi me, eye wòwɔ nu si Yehowa de se na wo be womawɔ o la, ameawo katã ɖi fɔ. ");
INSERT INTO ewe_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Ne wova dze si woƒe nu vɔ̃ la, woana nyitsu fɛ̃ aɖe hena nu vɔ̃ ŋuti vɔsa. Woatsɔ nyitsu la ava Agbadɔ la ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Dukɔ la ƒe ametsitsiwo ada asi ɖe nyitsu la ƒe ta dzi, eye woawui le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Nunɔla la atsɔ nyitsu la ƒe ʋu ayi Agbadɔ la me, ");
INSERT INTO ewe_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","ade eƒe asibidɛ ʋu la me, eye wòahlẽe zi adre ɖe xɔmetsovɔ la ŋgɔ le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Emegbe la, asisi ʋu la ɖe vɔsamlekpui la ƒe dzowo ŋu le Agbadɔ la me le Yehowa ŋkume, eye wòakɔ ʋua mamlɛa katã ɖe vɔsamlekpui la te le Agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Woaɖe eƒe ami ɖe sia ɖe, eye woatɔ dzoe le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Woawɔ nu siwo katã wowɔna le nu vɔ̃ ŋuti vɔsasa me. Ale nunɔla la alé avu ɖe dukɔ la nu, eye Mawu atsɔ nu vɔ̃ la ake ame sia ame. ");
INSERT INTO ewe_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Azɔ la, nunɔla la atsɔ nyitsu la ayi asaɖa la godo, eye wòatɔ dzoe le afi ma abe ame ɖeka ƒe nu vɔ̃ ŋuti vɔsa wònye ene, evɔ la, nu vɔ̃ ŋuti vɔsa wònye ɖe dukɔ blibo la ta. ");
INSERT INTO ewe_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Ne dumegã aɖe wɔ nu vɔ̃, gake menya gbã be yewɔ nu vɔ̃, da le Yehowa, eƒe Mawu, ƒe seawo dometɔ ɖeka dzi o, ");
INSERT INTO ewe_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ne wova na wònya emegbe ko la, ele be wòatsɔ gbɔ̃tsu si de blibo la vɛ abe eƒe vɔsa ene. ");
INSERT INTO ewe_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ada eƒe asi ɖe gbɔ̃ la ƒe ta dzi, awui le afi si wowua numevɔsalãwo le, eye wòatsɔe na Yehowa. Esiae nye eƒe nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Ekema nunɔla la atsɔ nu vɔ̃ ŋuti vɔsalã sia ƒe ʋu ƒe ɖe, atsɔ eƒe asibidɛ asisi ʋu la ɖe numevɔsamlekpui la ƒe dzowo ŋu, eye wòakɔ ʋu la ƒe mamlɛa ɖe vɔsamlekpui la te. ");
INSERT INTO ewe_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Woatɔ dzo lã la ƒe ami katã ɖe vɔsamlekpui la dzi abe akpedavɔsalã ƒe amie wònye ene. Ale nunɔla la alé avu ɖe dumegã si wɔ nu vɔ̃ la nu, eye Mawu atsɔ eƒe nu vɔ̃ akee. ");
INSERT INTO ewe_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Ne dukɔmevi aɖe da le Yehowa ƒe sewo dzi, gake menya be yewɔ nu vɔ̃ o la, eɖi fɔ. ");
INSERT INTO ewe_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Ke ne eva nya teti ko la, ele nɛ be wòatsɔ gbɔ̃nɔ si de blibo la vɛ be yeatsɔe alé avui ɖe yeƒe nu vɔ̃ ta. ");
INSERT INTO ewe_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Atsɔe va afi si wowua numevɔsalãwo le, ada asi ɖe lã la ƒe ta dzi, eye wòawui. ");
INSERT INTO ewe_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Ekema nunɔla la ade asibidɛ ʋu la me asisi ɖe numevɔsamlekpui la ƒe dzowo ŋu, eye wòakɔ ʋua mamlɛa ɖe vɔsamlekpui la te. ");
INSERT INTO ewe_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Woaɖe ami siwo katã le dɔ me na lã la, abe ale si wowɔna le akpedavɔsa me ene, eye nunɔla la atɔ dzoe le vɔsamlekpui la dzi. Nu sia adze Yehowa ŋu. Ale nunɔla la alé avu ɖe amea nu, eye Mawu atsɔ eƒe nu vɔ̃ akee. ");
INSERT INTO ewe_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Ke ne edi be yeasa vɔ la kple alẽ la, ekema ele be wòanye alẽnɔ si de blibo. ");
INSERT INTO ewe_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Akplɔe va afi si wowua numevɔsalãwo le, ada asi ɖe lã la ƒe ta dzi, eye wòawui abe nu vɔ̃ ŋuti vɔsalã ene. ");
INSERT INTO ewe_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Nunɔla la ade asibidɛ vɔsaʋu la me asisi ɖe numevɔsamlekpui la ƒe dzowo ŋuti, eye woakɔ ʋua ƒe mamlɛa katã ɖe vɔsamlekpui la te. ");
INSERT INTO ewe_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Woawɔ lã la ƒe ami ŋu dɔ abe ale si wowɔa eŋu dɔ le akpedavɔsa me ene. Nunɔla la atɔ dzo lã la ƒe ami ɖe vɔsamlekpui la dzi abe ale si wowɔna kple vɔsanu bubu ɖe sia ɖe si wotɔa dzoe na Yehowa la ene. Ekema nunɔla la alé avu ɖe amea nu, eye Mawu atsɔ eƒe nu vɔ̃ akee. ");
INSERT INTO ewe_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Ne ame aɖe se be woɖe gbeƒã be woava ɖi ɖase le nu vɔ̃ si ame bubu aɖe wɔ la ŋu si wòkpɔ alo nya nu le eŋu, gake meɖi ɖase le eŋuti o la, ekema ewɔ nu vɔ̃. ");
INSERT INTO ewe_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Alo ne ame aɖe ka asi nu makɔmakɔ aɖe ŋu abe lã maɖumaɖua aɖe ƒe kukua ŋu, alo gbemelã alo aƒemelã alo nutata siwo ŋuti mekɔ o ene ŋu la, ewɔ nu vɔ̃, ne eya ŋutɔ menya be yeka asi nu makɔmakɔ ŋu o hã. ");
INSERT INTO ewe_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Alo ne ede asi ame ƒe nu makɔmakɔ aɖe, nu sia nu si ana wòagblẽ kɔ ɖo la ŋu, togbɔ be menyae hafi o hã la, ne eva nya la, aɖi fɔ. ");
INSERT INTO ewe_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Alo ne ame aɖe ka atam be yeawɔ nane evɔ mebu ta me nyuie hafi kae o, eɖanye nyui alo vɔ̃ la, le nya sia nya si me wòaka atam le tamemabumabutɔe la, togbɔ be menya nu si wɔm wòle o hã la, ne eva nya emegbe la, aɖi fɔ. ");
INSERT INTO ewe_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Le go siawo dometɔ ɖe sia ɖe me la, ele be wòaʋu eƒe nu vɔ̃ me, ");
INSERT INTO ewe_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","eye wòatsɔ alẽnɔ alo gbɔ̃nɔ asa nu vɔ̃ ŋuti vɔsa na Yehowa. Nunɔla la alé avu ɖe enu, ekema Mawu atsɔ eƒe nu vɔ̃ akee, eye mele be wòagawɔ ɖe atam si wòka la dzi o. ");
INSERT INTO ewe_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Ne amea da ahe ale gbegbe be mate ŋu akpɔ alẽ alo gbɔ̃ vɛ na Yehowa o la, ekema ana akpakpa eve alo ahɔnɛ fɛ̃ eve abe eƒe nu vɔ̃ ŋuti vɔsa ene. Xeviawo dometɔ ɖeka anye eƒe nu vɔ̃ ŋuti vɔsa, eye evelia anye eƒe numevɔsa. ");
INSERT INTO ewe_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Nunɔla la atsɔ xevi eveawo dometɔ si wotsɔ nɛ gbã la, asa nu vɔ̃ vɔsae. Atro kɔ le xevi la nu, gake mana eƒe kɔ naɖe le enu o. ");
INSERT INTO ewe_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Nunɔla la ahlẽ ʋua ƒe ɖe ɖe vɔsamlekpui la ƒe axawo dzi, eye wòakɔ ʋua mamlɛa ɖe vɔsamlekpui la te. Esiae nye nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Nunɔla la atsɔ xevi evelia awɔ numevɔsae to mɔ siwo woɖo da ɖi la dzi. Ale nunɔla la alé avu ɖe amea nu le eƒe nu vɔ̃ ta, eye Mawu atsɔe akee. ");
INSERT INTO ewe_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Ne amea da ahe ale gbegbe be mate ŋu atsɔ akpakpawo alo ahɔnɛ fɛ̃wo asa nu vɔ̃ vɔe o la, ekema ana wɔ memee kilogram ɖeka. Mele be woakɔ ami ɖe edzi loo alo atsakae kple dzudzɔdonu o, elabena nu vɔ̃ vɔsae. ");
INSERT INTO ewe_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Atsɔe vɛ na nunɔla la; nunɔla la aɖe wɔ la ƒe asiʋlo ɖeka ɖe wɔ blibo la teƒe, eye wòatɔ dzoe le vɔsamlekpui la dzi abe dzovɔsa bubu ɖe sia ɖe na Yehowa ene. Esiae anye eƒe nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Ale nunɔla la alé avu ɖe enu le nu vɔ̃ sia tɔgbi ɖe sia ɖe ta, eye Mawu atsɔe akee. Wɔ la ƒe mamlɛa azu nunɔla la tɔ abe ale si wowɔna le nuɖuvɔsa gome ene.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Ne ame aɖe gblẽ kɔ ɖo, eye wòwɔ nu vɔ̃ le manyamanya me, ku ɖe Yehowa ƒe nu kɔkɔewo dometɔ aɖe ŋu la, abe tohehe ene la, alé agbo ɖeka le lãhawo dome vɛ na Yehowa, esi ŋuti kpɔtsɔtsɔ mele o la, eye eƒe home sɔ kple klosalo si wòle be wòana le Kɔkɔeƒe la ƒe nudanu nu. Enye fɔɖivɔsa na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kpe ɖe esia ŋu la, ele nɛ be wòaɖo nu si mete ŋu wɔ o la teƒe ku ɖe nu kɔkɔeawo ŋuti, agatsɔ nu si wòle be wòana la ƒe akpa atɔ̃lia akpe ɖe nuawo ŋu, eye wòatsɔ wo katã vɛ na nunɔla la, ame si atsɔ agbo la alé avui abe fɔɖivɔsa ene. Ale woatsɔe akee. ");
INSERT INTO ewe_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Ne ame aɖe wɔ nu vɔ̃, eye wòwɔ nu si wogbe be womawɔ o le Yehowa ƒe ɖoɖowo dometɔ aɖe me, ne eya ŋutɔ menyae o gɔ̃ hã la, eɖi fɔ eye woabui nu vɔ̃e nɛ. ");
INSERT INTO ewe_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Ele be wòatsɔ agbo ɖeka si de blibo, eye asixɔxɔ si dze la le eŋu la tso eƒe alẽwo dome vɛ na nunɔla la abe eƒe fɔɖivɔsa ene. Ale nunɔla la alé avu ɖe enu ɖe nu vɔ̃ si meɖo wɔ o la ta, eye woatsɔe akee. ");
INSERT INTO ewe_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Ele be wòatsɔe ana abe fɔɖivɔsa ene, elabena eɖi fɔ le Yehowa ŋkume.” ");
INSERT INTO ewe_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Nenye be ame aɖe wɔ nu vɔ̃, eye meto nyateƒe na Yehowa o, ne eble ehavi tso nu si woda ɖe egbɔ alo be nedzra ɖo na ye alo wòfi alo wòbae ");
INSERT INTO ewe_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","alo ne efɔ nu bubu aɖe, evɔ wòda alakpa le eŋuti alo wòka atam dzodzro alo wòwɔ nu vɔ̃ siawo dometɔ ɖeka si amewo awɔ, ");
INSERT INTO ewe_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","eye ne ewɔ nu vɔ̃ siawo eye wòɖi fɔ la, ele nɛ be wòaɖe asi le nu si wòfi la alo xɔ to amebamɔ dzi alo nu si dzi wobe wòakpɔ alo nu si bu wòfɔ ");
INSERT INTO ewe_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","alo nu sia nu si ŋu wòka aʋatsotam ɖo la ŋu. Ele be wòaɖo nua teƒe wòade, wòatsɔ nua ƒe home atɔ̃lia ƒe ɖeka akpee, eye wòatsɔ wo katã na nutɔ le ŋkeke si wòtsɔ eƒe fɔɖivɔsa na la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Eƒe fɔɖivɔsanu anye agbo si de blibo, eye eƒe home nade nu sia nu si nàbia tso esi la nu. Atsɔe vɛ na nunɔla si le Yehowa teƒe, ");
INSERT INTO ewe_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ame si alé avu ɖe enu le Yehowa ŋkume, eye Mawu atsɔ eƒe nu vɔ̃ akee.” ");
INSERT INTO ewe_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Yehowa gagblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“De se siawo na Aron kple via ŋutsuwo tso numevɔsa ŋuti, ‘Woagblẽ numevɔsa la ɖe vɔsamlekpui la ƒe dzodoƒe, eye dzo nanɔ bibim le ete zã blibo la. ");
INSERT INTO ewe_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Ne ŋu ke la, nunɔla la ado eƒe awutewui kple eƒe dziwui, akplɔ numevɔsa la ƒe dzowɔ akɔ ɖe vɔsamlekpui la xa. ");
INSERT INTO ewe_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Emegbe la, aɖɔli eƒe awuwo, atsɔ dzowɔ la ayi teƒe si ŋuti kɔ le asaɖa la godo. ");
INSERT INTO ewe_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Vɔsamlekpui la ƒe dzo aganɔ bibim kokoko; mele be wòatsi o. Nunɔla la agade nake yeyewo dzo la me ŋdi sia ŋdi, eye wòatsɔ gbe sia gbe ƒe numevɔsa ada ɖe edzi, atɔ dzo gbe sia gbe ƒe ŋutifafavɔsa ƒe ami. ");
INSERT INTO ewe_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ele be dzo nanɔ bibim le vɔsamlekpui la dzi madzudzɔmadzudzɔe. Mele be wòatsi gbeɖe o.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“Se siwo le nuɖuvɔsa ŋu la woe nye: ‘Aron ƒe viŋutsuwo atsi tsitre ɖe vɔsamlekpui la ŋgɔ, eye woasa vɔ la le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Nunɔla la aɖe wɔ memee la ƒe asiʋlo ɖeka, akɔ ami kple dzudzɔdonu ɖe edzi, eye wòatɔ dzoe le vɔsamlekpui la dzi abe Yehowa tɔ ene tso nu si wotsɔ vɛ la me. Yehowa axɔe kple dzidzɔ gã. ");
INSERT INTO ewe_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Wɔ si asusɔ le asiʋlo ɖeka ɖeɖe vɔ megbe la azu nuɖuɖu na Aron kple via ŋutsuwo. Womade amɔʋãtike eme o. Woaɖui le Agbadɔ la ƒe xɔxɔnu. ");
INSERT INTO ewe_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Te gbe ɖe edzi na wo be, ne womee le abolokpo me la, amɔʋãtike manɔ eme o. Metsɔ numevɔ si wosa nam la ƒe akpa sia na nunɔlawo. Ke numevɔsa blibo la le kɔkɔe abe ale si nu vɔ̃ ŋuti vɔsa kple fɔɖivɔsa blibo la le ene. ");
INSERT INTO ewe_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Ŋutsu ɖe sia ɖe si dzɔ tso Aron me, nunɔla ɖe sia ɖe, ate ŋu aɖui tso dzidzime yi dzidzime. Ke nunɔla siwo ŋuti kɔ koe kpɔ mɔ aɖu vɔsanu siwo wome na Yehowa.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yehowa gblɔ na Mose bena, ");
INSERT INTO ewe_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Nu siae nye nu si Aron kple via ŋutsuwo ana Yehowa le gbe si gbe woasi ami nɛ: wɔ memee kilogram ɖeka abe gbe sia gbe ƒe nuɖuvɔsa ene. Woatsɔ afã vɛ ŋdi, eye afã evelia le fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Tsɔ ami tɔe le nutɔgba me wòabi nyuie ekema nàtsɔe vɛ na Yehowa wòanye vɔsa si dzea eŋu. ");
INSERT INTO ewe_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Via ŋutsu si axɔ ɖe eteƒe abe nunɔla si wosi ami na ene la atrɔ asi le eŋu. Enye Yehowa tɔ ɣe sia ɣi, eye woatɔ dzoe wòafia keŋkeŋ. ");
INSERT INTO ewe_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Woatɔ dzo nunɔlawo ƒe nuɖuvɔsa ɖe sia ɖe keŋkeŋ, eye womaɖui o.” ");
INSERT INTO ewe_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Le esia megbe la, Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Gblɔ na Aron kple via ŋutsuwo be se siwo le nu vɔ̃ ŋuti vɔsa ŋu la woe nye esiawo. “Vɔsa sia nye nu kɔkɔe. Woawu vɔsalã la le Yehowa ŋkume, afi si wowua numevɔsalãwo le. ");
INSERT INTO ewe_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Nunɔla si asa vɔ sia la aɖu vɔsalã la le Agbadɔ la ƒe kpɔ me. ");
INSERT INTO ewe_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Ame siwo ŋuti wokɔ, eye wozu nunɔlawo la koe kpɔ mɔ aka asi lã la ŋu. Ne ʋu hlẽ ɖe ame aɖe ƒe awu ŋu la, woanyae le teƒe kɔkɔe aɖe. ");
INSERT INTO ewe_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Ekema woagbã ze si me wonya awu la le. Ne enye akɔblizee la, woaklɔe nyuie. ");
INSERT INTO ewe_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Ŋutsu ɖe sia ɖe le nunɔlawo dome kpɔ mɔ aɖu vɔsalã sia. Ke woawo koe kpɔ mɔ aɖui, elabena nu kɔkɔe wònye. ");
INSERT INTO ewe_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ne wotsɔ vɔsalã la ƒe ʋu aɖe yi Agbadɔ la me, be woalé avu le Kɔkɔeƒe la la, ekema nunɔlawo mekpɔ mɔ aɖu vɔsalã la o. Woatɔ dzo lã blibo la le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“Esiawoe nye se siwo ku ɖe fɔɖivɔsa ŋu. Nu kɔkɔe ƒe nu kɔkɔe wònye. ");
INSERT INTO ewe_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","“Woawu fɔɖivɔsalã la le afi si wowua numevɔsalãwo le, eye woatsɔ eƒe ʋu ahlẽ ɖe vɔsamlekpui la ŋu godoo akpe ɖo. ");
INSERT INTO ewe_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Nunɔla la atsɔ lã la ƒe amiwo katã, eƒe asike, ami si le dɔmenuwo ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ayiku eveawo kple ami si le wo ŋu kple eƒe aklã asa vɔe ɖe vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Nunɔla la atɔ dzo nu siawo katã le vɔsamlekpui la dzi abe fɔɖivɔsa ene na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ŋutsu siwo tso nunɔlawo ƒe ƒome me la koe aɖu lã la ƒe mamlɛa. Woaɖui le teƒe kɔkɔe aɖe, elabena vɔsa kɔkɔe wònye. ");
INSERT INTO ewe_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“Se siawo kee le nu vɔ̃ ŋuti vɔsa kple fɔɖivɔsa siaa ŋu. Woatsɔ lã la ƒe mamlɛa ana nunɔla si wɔ avulévɔsa la wòanye eƒe nuɖuɖu. ");
INSERT INTO ewe_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Nenye numevɔsae la, ekema woatsɔ lã la ƒe agbalẽ hã ana nunɔla la. ");
INSERT INTO ewe_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Nunɔla si sa nuɖuvɔ la na Yehowa la axɔ nuɖuɖu si susɔ ne ewu vɔsa la nu. Woawɔ se sia dzi nenye be wome vɔsanu la le kpo me loo, tɔe le ami me loo alo mee le dzo me. ");
INSERT INTO ewe_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Nuɖuvɔsa bubuawo katã, ne wode ami wo, alo womede ami wo o hã, anye Aron ƒe viŋutsuwo katã tɔ. ");
INSERT INTO ewe_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“Esiawoe nye akpedavɔsa tɔxɛwo na Yehowa ŋu sewo: ");
INSERT INTO ewe_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“Nenye akpedada tae wole vɔ la sam ɖo la, ekema woatsɔ abolo si wowɔ kple amɔ maʋamaʋã la akpe ɖe vɔsalã la kple akaklɛ̃ si dzi wokɔ ami ɖo kple wɔ memee si woblu kple ami hetsɔ tɔ wɔkakloe la ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Ne wole akpedavɔ kple ŋutifafavɔ sam la, woawɔ abolo si wowɔ kple amɔ ʋaʋã la ŋu dɔ. ");
INSERT INTO ewe_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Woatsɔ vɔsa sia ƒe akpa aɖe aɖo Yehowa ŋkume abe vɔsa tɔxɛ ene, ekema woatsɔe ana nunɔla si hlẽa vɔsalã ƒe ʋu. ");
INSERT INTO ewe_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Le lã la tsɔtsɔ sa vɔe kple etsɔtsɔ na Yehowa abe ŋutifafavɔsa ene be woaɖe ŋudzedzekpɔkpɔ kple akpedada tɔxɛ afia vɔ megbe la, woaɖu vɔsalã la gbe ma gbe ke, eye ɖeke matsi anyi ŋu nake o. ");
INSERT INTO ewe_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“Ke ne ame aɖe tsɔ nane vɛ si menye akpedavɔsa o, ke boŋ wònye vɔsa ɖe atam si amea ka ta alo wònye lɔlɔ̃nununana la, ekema vɔsalã si womeɖu le ŋkeke si dzi wosa vɔ la le o la, woate ŋu aɖui ne ŋu ke. ");
INSERT INTO ewe_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Woatɔ dzo vɔsanu si asusɔ va se ɖe ŋkeke etɔ̃a gbe la. ");
INSERT INTO ewe_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ne woɖu akpedavɔsalã la ƒe ɖe le ŋkeke etɔ̃a gbe la, womaxɔe nɛ o, womabui na ame si sa vɔ la o, elabena eŋuti mekɔ o, eye ame si aɖui la aɖi fɔ. ");
INSERT INTO ewe_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Womaɖu lã si ƒe akpa aɖe ka nu makɔmakɔ aɖe ŋu o, ke boŋ woatɔ dzoe, eye ame si ƒe ŋuti kɔ la koe aɖu lã si wòate ŋu aɖu. ");
INSERT INTO ewe_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Woaɖe nunɔla si ŋuti mekɔ o, gake wòɖu akpedavɔsanu la le wo tɔwo dome, elabena ena nu si nye Yehowa tɔ la trɔ zu nu makɔmakɔ. ");
INSERT INTO ewe_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Woaɖe ame sia ame si aka asi nu makɔmakɔ aɖe ŋu, ne nu makɔmakɔ la tso amegbetɔ alo lã aɖe gbɔ, gake wòaɖu ŋutifafavɔsanu ƒe ɖe la le etɔwo dome, elabena eƒo ɖi nu si nye nu kɔkɔe la.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Le esia megbe la, Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“De se na Israelviwo be, ‘Miekpɔ mɔ aɖu lã ƒe ami o, eɖanye nyi, alẽ alo gbɔ̃ ƒe ami o. ");
INSERT INTO ewe_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Miate ŋu awɔ lã si lé dɔ heku alo lã si lã wɔadã aɖe wu la ƒe ami ŋu dɔ le mɔ bubuwo nu, gake mimaɖui gbeɖegbeɖe o. ");
INSERT INTO ewe_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Woaɖe ame sia ame si aɖu lã si wome na Yehowa abe vɔsa ene ƒe ami la le Mawu ƒe ha me. ");
INSERT INTO ewe_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Eye afi sia afi si miele la, mele be miaɖu xevi alo lã aɖeke ƒe ʋu o. ");
INSERT INTO ewe_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ne ame aɖe ɖu ʋu la, woaɖee ɖa le eƒe amewo dome.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yehowa gagblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Gblɔ na Israelviwo be ame si di be yeasa akpedavɔ na Yehowa la ŋutɔ natsɔ nu siwo wòatsɔ asa vɔ lae la vɛ. ");
INSERT INTO ewe_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ele be wòatsɔ vɔsalã la ƒe ami kple eƒe akɔ vɛ, eye woanye wo le yame le vɔsamlekpui la gbɔ si fia be wotsɔ wo na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Nunɔla la atɔ dzo ami la le vɔsamlekpui la dzi, ke lã la ƒe akɔ anye Aron kple via ŋutsuwo tɔ. ");
INSERT INTO ewe_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Mitsɔ miaƒe akpedavɔsalã ƒe ɖusita na nunɔla la. ");
INSERT INTO ewe_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Aron ƒe viŋutsu si atsɔ akpedavɔsalã la ƒe ʋu kple ami ana la axɔ lã la ƒe ɖusita, ");
INSERT INTO ewe_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","elabena metia lã la ƒe akɔ kple ata be woanye Israelviwo ƒe nunana na Aron. Ele be woatsɔ vɔsalãwo ƒe akpa siawo ana Aron kple via ŋutsuwo ɣe sia ɣi.” ");
INSERT INTO ewe_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Esiae nye woƒe fetu! Ele be woaɖe wo ɖa tso numevɔsa la gbɔ, eye woatsɔ wo ana ame siwo katã wotia be woasubɔ Yehowa abe nunɔlawo ene. Ame siawoe nye Aron kple via ŋutsuwo, ");
INSERT INTO ewe_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","elabena le gbe si gbe wosi ami na Aron kple via ŋutsuwo la, Yehowa de se na Israelviwo be woatsɔ vɔsalã ƒe akpa siawo na wo. Wo tɔ wonye tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Esiawoe nye se siwo ku ɖe numevɔsa, nuɖuvɔsa, nu vɔ̃ ŋuti vɔsa kple fɔɖivɔsa kple esiwo ku ɖe ameŋutikɔvɔsa kple akpedavɔsa ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Yehowa de se siawo na Mose le Sinai to dzi, be wòana Israelviwo nanya ale si woasa vɔe na Yehowa le Sinai gbedzi. ");
INSERT INTO ewe_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Kplɔ Aron kple via ŋutsuwo vɛ, nàtsɔ woƒe awuwo, ami sisi la, nu vɔ̃ ŋuti vɔsanyitsu la, agbo eveawo kple kusi si me abolo maʋamaʋã le, ");
INSERT INTO ewe_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","eye nàna ameha blibo la naƒo ƒu ɖe Mawu ƒe Agbadɔ la ƒe mɔnu.” ");
INSERT INTO ewe_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mose wɔ abe ale si Yehowa de se nɛ be ene eye ameawo katã ƒo ƒu ɖe agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Ale Mose gblɔ na ƒuƒoƒe la be, “Ale Yehowa ɖo nam be mawɔe nye esi.” ");
INSERT INTO ewe_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mose na Aron kple via ŋutsuwo te va eye wòle tsi na wo, ");
INSERT INTO ewe_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","eye wòdo awutewui tɔxɛ la, alidziblanu la, dziwui kple kɔmewu la na Aron. ");
INSERT INTO ewe_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Edo akɔtatsyɔnu la hã nɛ, eye wòtsɔ nu si wotsɔna bia gbe Mawui, “Urim” kple “Tumim,” de akɔtatsyɔnu la ƒe kotoku me. ");
INSERT INTO ewe_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Emegbe la, etsɔ tablanu la bla ta nɛ, eye wòtsi sikaŋgoblanu kɔkɔe la ɖe tablanu la ŋu le ŋgɔgbe abe ale si Yehowa de se nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Emegbe la, Mose tsɔ ami sisi la, eye wòwui ɖe Agbadɔ la kple nu sia nu si le eme la ŋu, eye wòkɔ wo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Esi wòɖo vɔsamlekpui la gbɔ la, ewu ami sisi la ɖe eŋu zi adre, eye wògawui ɖe nu siwo le vɔsamlekpui la dzi kple tsileze la kple eƒe zɔ ŋu hekɔ wo ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Emegbe la, eɖo Aron nunɔlae to amikɔkɔ ɖe ta me nɛ me, eye to esia hã me wòkɔ eŋu. ");
INSERT INTO ewe_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Le esia yome la, Mose do awu na Aron ƒe viŋutsuwo, bla alidziblanuawo na wo, eye wòɖɔ kuku la na wo abe ale si Yehowa gblɔ nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Mose lé nyitsu la hena nu vɔ̃ ŋuti vɔsa la. Aron kple via ŋutsuwo da asi ɖe nyitsu la ƒe ta dzi. ");
INSERT INTO ewe_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mose wu nyitsu la, tsɔ eƒe ʋu ƒe ɖe, eye wòtsɔ eƒe asibidɛ sisi ʋua ɖe vɔsamlekpui la ƒe dzowo katã ŋu be yeakɔ vɔsamlekpui la ŋuti. Ekɔ ʋua mamlɛa ɖe vɔsamlekpui la te. Ale wòkɔ eŋuti, eye wòwɔe wòanye avuléle nɛ. ");
INSERT INTO ewe_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mose ɖe ami siwo katã le dɔmenuawo, aklã kple ayiku eveawo ŋu, eye wòtɔ dzo wo le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Etɔ dzo nyitsu la ƒe lã mamlɛa, eƒe agbalẽ kple dɔmenuwo le asaɖa la godo abe ale si Yehowa gblɔ nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Emegbe la, etsɔ agbo la hena numevɔsasa na Yehowa. Aron kple via ŋutsuwo da woƒe asiwo ɖe agbo la ƒe ta dzi. ");
INSERT INTO ewe_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mose wui, eye wòhlẽ ʋu la ɖe vɔsamlekpui la ŋuti godoo. ");
INSERT INTO ewe_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Efli agbo la, eye wòtɔ dzo lãkɔ la, eƒe ta kple eƒe ami. ");
INSERT INTO ewe_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Le esia megbe la, etsɔ tsi klɔ agbo la ƒe dɔmenuwo kple afɔwo, eye wòtɔ dzo wo le vɔsamlekpui la dzi. Ale agbo blibo la fia le Yehowa ŋkume. Esia nye numevɔsa si dze Yehowa ŋu ŋutɔ, elabena Mose zɔ ɖe nu siwo katã Yehowa ɖo nɛ be wòawɔ la dzi pɛpɛpɛ. ");
INSERT INTO ewe_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Mose trɔ ɖe agbo evelia si nye ameŋukɔkɔ ƒe agbo la ŋu. Aron kple via ŋutsuwo da woƒe asiwo ɖe agbo la ƒe ta dzi. ");
INSERT INTO ewe_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mose wui, eye wòsisi ʋua ɖe Aron ƒe nuɖusito, eƒe asi ƒe adegblefetsu ɖusitɔ kple eƒe ɖusifɔ ƒe adegblefetsu ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Le esia yome la, esisi ʋua ɖe Aron ƒe viŋutsuwo ƒe ɖusitowo, woƒe asi adegblefetsu ɖusitɔwo kple woƒe ɖusifɔwo ƒe adegblefetsu ŋu, eye wòhlẽ ʋua mamlɛa ɖe vɔsamlekpui la ŋu godoo. ");
INSERT INTO ewe_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Mose tsɔ agbo la ƒe ami, asike la, ami si le dɔmenuwo ŋu, aklã kple ayiku eveawo kple wo ŋu miwo kpe ɖe eƒe ɖusita ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Nu siwo wòtsɔ da ɖe agbo la ƒe lã ƒe akpa siawo dzi la woe nye abolo maʋamaʋã ɖeka si tso kusi si wotsɔ ɖo Yehowa ŋkume la me, abolo si wode amii kple akpɔnɔ ɖeka. ");
INSERT INTO ewe_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Mose tsɔ nu siawo katã de asi na Aron kple via ŋutsuwo, eye wonye wo le yame abe vɔsa tɔxɛ na Yehowa ene. ");
INSERT INTO ewe_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Mose gaxɔ nu siawo le wo si, eye wòtɔ dzo wo kpe ɖe numevɔsa la ŋuti na Yehowa le vɔsamlekpui la dzi. Vɔsa sia dze Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Azɔ la, Mose tsɔ agbo la ƒe akɔ, eye wòtsɔe na Yehowa to enyenye le yame le vɔsamlekpui la ŋgɔ me. Ameŋukɔkɔ ƒe agbo la ƒe akpa siae nye Mose tɔ abe ale si Yehowa ɖoe ene. ");
INSERT INTO ewe_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mose tsɔ ami sisi la azɔ kple ʋu si wòhlẽ ɖe vɔsamlekpui la ŋu la ƒe ɖe, eye wòhlẽe ɖe Aron kple via ŋutsuwo kple woƒe awuwo ŋu. Ale wòkɔ Aron kple via ŋutsuwo kple woƒe awuwo ŋu, be Yehowa nawɔ wo ŋu dɔ. ");
INSERT INTO ewe_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Le esia megbe la, Mose gblɔ na Aron kple via ŋutsuwo be, “Miɖa lã la le Agbadɔ la ƒe mɔnu, eye miaɖui kple abolo si le ameŋukɔkɔ ƒe kusi la me abe ale si Yehowa de se na mi ene. ");
INSERT INTO ewe_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Mitɔ dzo lã la kple aboloawo ƒe mamlɛawo. ");
INSERT INTO ewe_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","“Minɔ Agbadɔ la ƒe mɔnu ŋkeke adre, eye le ŋkeke adreawo megbe la, miawu miaƒe ŋutikɔkɔ nu, elabena ŋkeke adree wòaxɔ. ");
INSERT INTO ewe_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Nu siwo katã wowɔ egbe la, Yehowae de se be woawɔ wo hena miaƒe ŋutikɔkɔ. ");
INSERT INTO ewe_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ele be mianɔ Agbadɔ la ƒe mɔnu zã kple keli ŋkeke adre, eye miawɔ nu siwo Yehowa de se na mi be miawɔ. Ne miewɔe o la, miaku. Esiawoe nye se siwo Yehowa de nam.” ");
INSERT INTO ewe_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Ale Aron kple via ŋutsuwo wɔ nu siwo katã Yehowa ɖo na Mose. ");
INSERT INTO ewe_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Le ŋutikɔkɔ ƒe ŋkeke enyia gbe la, Mose yɔ Aron kple via ŋutsuwo kple Israel ƒe ametsitsiwo, ");
INSERT INTO ewe_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","eye wògblɔ na Aron be wòalé nyitsu ɖeka tso nyiha la me hena nu vɔ̃ ŋuti vɔsa kple agbo ɖeka hena numevɔsa, eye wòasa vɔ le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Mose yi edzi be, “Gblɔ na Israelviwo be woatia gbɔ̃tsu ɖeka hena woƒe nu vɔ̃ ŋuti vɔsa kple nyivi ɖeka kple alẽvi ɖeka, lã siwo de blibo hena woƒe numevɔsa. ");
INSERT INTO ewe_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Kpe ɖe esia ŋu la, woatsɔ nyitsu ɖeka kple agbo ɖeka asa akpedavɔ, eye woatsɔ wɔ si woblu kple ami la asa nuɖuvɔ na Yehowa, elabena egbe la, Yehowa aɖe eɖokui afia wo.” ");
INSERT INTO ewe_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Ale ameawo tsɔ nu siawo katã va Agbadɔ la ƒe mɔnu, abe ale si Mose gblɔ na wo la ene, eye ameawo tsi tsitre ɖe afi ma le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mose gblɔ na ameawo be, “Ne miewɔ Yehowa ƒe ɖoɖowo dzi la, eƒe ŋutikɔkɔe aɖe eɖokui afia mi.” ");
INSERT INTO ewe_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mose gblɔ na Aron be wòate ɖe vɔsamlekpui la ŋu, eye wòasa nu vɔ̃ vɔsa kple numevɔ, alé avu gbã ɖe eɖokui ta, eye emegbe la, ɖe ame bubuawo ta abe ale si Yehowa ɖo ene. ");
INSERT INTO ewe_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Ale Aron te ɖe vɔsamlekpui la ŋu, eye wòtsɔ nyivi la wɔ nu vɔ̃ vɔsae ɖe eya ŋutɔ ƒe nu vɔ̃wo ta. ");
INSERT INTO ewe_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Via ŋutsuwo tsɔ ʋu la nɛ. Ede asi eme, sisii ɖe vɔsamlekpui la ƒe dzowo ŋu, eye wòkɔ mamlɛa ɖe vɔsamlekpui la te. ");
INSERT INTO ewe_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Emegbe la, etɔ dzo nu vɔ̃ ŋuti vɔsalã la ƒe ami, ayikuawo kple aklã la le vɔsamlekpui la dzi, abe ale si Yehowa ɖo na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Etɔ dzo lã la kple eƒe agbalẽ le asaɖa la godo. ");
INSERT INTO ewe_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Nu si kplɔ esia ɖo lae nye Aron wu numevɔsalã la. Via ŋutsuwo tsɔ ʋua nɛ, eye wòhlẽe ɖe vɔsamlekpui la ŋu godoo. ");
INSERT INTO ewe_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Wofli lã la tsɔ vɛ nɛ kpe ɖe lã la ƒe ta ŋu. Etɔ dzo wo katã le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Ekpala dɔmenuawo kple afɔawo, eye wòtɔ dzo wo ɖe vɔsamlekpui la dzi abe numevɔsa ene. ");
INSERT INTO ewe_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Emegbe la, etsɔ ameawo ƒe nunanawo sa vɔe. Ewu gbɔ̃tsu la, eye wòtsɔe sa vɔe abe ale si wòsa nu vɔ̃ vɔsa ɖe eɖokui ta ene. ");
INSERT INTO ewe_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Ale wòsa numevɔ la na Yehowa, le se siwo wòde nɛ la nu. ");
INSERT INTO ewe_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Le esia megbe la, esa nuɖuvɔ la. Eku wɔ la ƒe asiʋlo ɖeka, eye wòtɔ dzoe kpe ɖe gbe sia gbe ƒe ŋdivɔsa ŋu le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Azɔ la, ewu nyitsu la kple agbo si ameawo tsɔ vɛ la na akpedavɔsa. Aron viŋutsuwo tsɔ lãawo ƒe ʋu vɛ, eye wòhlẽe ɖe vɔsamlekpui la ŋu godoo. ");
INSERT INTO ewe_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Eɖe nyitsu la kple agbo la ƒe amiwo, ami siwo le ayikuawo ŋu kpe ɖe esiwo le woƒe dɔmenuwo ŋu la ŋuti, eye wògaɖe woƒe ayikuwo kple aklãwo hã. ");
INSERT INTO ewe_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Aron tsɔ amiawo da ɖe vɔsalãwo ƒe akɔwo dzi, eye wòtɔ dzo amiawo le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Ke Aron nye lãawo ƒe akɔwo kple ɖusitawo le yame le Yehowa ŋkume abe wo tsɔtsɔ na Mawu ƒe dzesi ene, abe ale si Mose ɖo nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Emegbe la, Aron wu eƒe asiwo dzi ɖe dukɔ la dzi, yra wo; eye esi wòsa nu vɔ̃ vɔ, numevɔ, kple akpedavɔ vɔ la, eɖi le vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mose kple Aron woyi Agbadɔ la me, eye esi wodo go la, woyra ameawo. Tete Yehowa ƒe ŋutikɔkɔe ɖe eɖokui fia ameha blibo la, ");
INSERT INTO ewe_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","eye dzo tso Yehowa gbɔ fia numevɔsa la kple amiawo le vɔsamlekpui la dzi. Esi ameawo kpɔe la, wo katã wodo dzidzɔɣli, eye wotsyɔ mo anyi le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ke Aron ƒe viŋutsu eve, Nadab kple Abihu, ɖe dzo makɔmakɔ ɖe woƒe dzudzɔdosonuwo me, ɖe dzudzɔdonu kɔ ɖe dzo la dzi, eye wodo dzudzɔ na Yehowa. Nu sia mesɔ ɖe se si Yehowa de na wo la dzi o, ");
INSERT INTO ewe_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","eya ta dzo tso Yehowa gbɔ, eye wòtsrɔ̃ wo; ale woku le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Tete Mose gblɔ na Aron be, “Esiae Yehowa gblɔ esi wògblɔ be, ‘Maɖe ɖokuinye afia ame siwo tena ɖe ŋutinye la kɔkɔe eye woade bubu ŋunye le amewo katã ŋkume.’ ” Eye Aron zi ɖoɖoe kpoo. ");
INSERT INTO ewe_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mose yɔ Misael kple Elzafan, wo tɔɖia Uziel ƒe viŋutsuwo eye wògblɔ na wo be, “Miyi miakɔ mia nɔviwo ƒe ŋutilã fiafiawo tso Agbadɔ la ŋkume yi ɖada ɖe asaɖa la godo.” ");
INSERT INTO ewe_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Woyi ɖakɔ wo; wole woƒe awutewui ʋlayawo me abe ale si Mose gblɔ na wo la ene. ");
INSERT INTO ewe_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mose gblɔ na Aron kple Via ŋutsu eve, Eleaza kple Itamar be, “Migafa ame kukuawo o, eye migagblẽ miaƒe ɖa ɖi mavumavui abe konyifafa ƒe dzesi ene o; migadze miaƒe awuwo hã o. Ne miewɔ nu siawo la, eƒe dziku abi ɖe Israel dukɔ blibo la ŋu. Ke Israelvi bubuawo ya ate ŋu afa avi na Nadab kple Abihu le dzo dziŋɔ si Yehowa ɖo ɖa la ta. ");
INSERT INTO ewe_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Ke miawo ya la, mele be miadzo le Agbadɔ la nu o. Ne miedzo la, miaku elabena Yehowa ƒe ami si wosi na mi la gale mia dzi.” Eye wowɔ se si Mose de na wo la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Yehowa gblɔ na Aron bena, ");
INSERT INTO ewe_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Wò kple viwò ŋutsuwo, migano wain alo aha muame aɖeke ne miele Mawu ƒe Agbadɔ me yi ge o. Ne mienoe la, miaku. Esia nye ɖoɖo mavɔ hena dzidzime siwo gbɔna. ");
INSERT INTO ewe_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Wò dɔdeasiwo anye be mialé avu ɖe amewo nu, miafia vovototo siwo le nu kɔkɔewo kple nu makɔmakɔwo, nu siwo dza kple nu siwo medza o la dome, ");
INSERT INTO ewe_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","eye miafia Israelviwo se siwo katã Yehowa de na mi to Mose dzi la ameawo.” ");
INSERT INTO ewe_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mose gblɔ na Aron kple Via ŋutsu eve siwo susɔ, Eleaza kple Itamar be, “Mitsɔ nuɖuvɔsa si susɔ esi woɖe wɔ asiʋlo ɖeka le eŋu na Yehowa le vɔsamlekpui la dzi; miakpɔ egbɔ be amɔʋãtike mele eme o, eye miaɖui le vɔsamlekpui la gbɔ. Vɔsa sia nye nu kɔkɔe, ");
INSERT INTO ewe_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","eya ta miaɖui le Kɔkɔeƒe la. Miawo kple mia viwo tɔe wònye tso vɔsa si wome na Yehowa la me, elabena eyae nye se si wode nam. ");
INSERT INTO ewe_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ke miate ŋu aɖu lã la ƒe akɔ kple ata si wonye le yame le Yehowa ŋkume abe nu si wotsɔ nɛ ƒe dzesi ene la, le teƒe kɔkɔe ɖe sia ɖe. Wò kple viwò ŋutsuwo kple viwò nyɔnuwo ƒe nuɖuɖue. Eyae nye mia tɔ le Israelviwo ƒe akpedavɔsawo me. ");
INSERT INTO ewe_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","“Ele be ameawo natsɔ ata si woɖe ɖe aga kple akɔ si wona esi wotɔ dzo amiawo la vɛ. Woatsɔ wo ana Yehowa to wo nyenye le yame me. Ekema woazu wò kple viwòwo tɔ, elabena esiae nye Yehowa ƒe ɖoɖo.” ");
INSERT INTO ewe_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Mose di gbɔ̃tsu si wotsɔ vɛ na nu vɔ̃ ŋuti vɔsa la le afi sia afi. Eva dze sii be wotɔ dzoe xoxo! Nu sia na wòdo dɔmedzoe vevie ɖe Eleaza kple Itamar, Aron ƒe viŋutsu eve siwo susɔ la ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Ebia wo be, “Nu ka ta mieɖu nu vɔ̃ ŋuti vɔsa la, si nye nu kɔkɔe ƒe nu kɔkɔe la le teƒe kɔkɔe la o, le esime wotsɔe na mi be miatsɔ aɖe ameawo ƒe nu vɔ̃wo kple dzidadawo ɖa, eye mialé avu le woawo kple Yehowa dome? ");
INSERT INTO ewe_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Zi ale si wometsɔ eƒe ʋu yi kɔkɔeƒe la o la, ɖe wòle be miaɖui le afi ma abe ale si meɖo na mi ene hafi.” ");
INSERT INTO ewe_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Ke Aron xɔ nya ɖe wo nu le Mose gbɔ hegblɔ be, “Wosa woƒe nu vɔ̃ vɔsa kple numevɔ le Yehowa ŋkume; ke nenye ɖe meɖu nu vɔ̃ ŋuti vɔsa la egbe la, ɖe wòadze Yehowa ŋua?” ");
INSERT INTO ewe_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Esi Mose se nya siawo la, eƒe dzi dze eme. ");
INSERT INTO ewe_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yehowa gblɔ na Mose kple Aron bena, ");
INSERT INTO ewe_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Migblɔ na Israelviwo be, ‘Le lã siwo katã nɔa anyigba dzi la, esiawoe nye esiwo miaɖu. ");
INSERT INTO ewe_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Miate ŋu aɖu lã sia lã si ƒe afɔkli me fe, eye wòdzɔa nu gaɖuna. ");
INSERT INTO ewe_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Lã aɖewo li siwo dzɔa nu gaɖuna alo woƒe afɔkli me koe fe, gake migaɖu wo o. Togbɔ be kposɔ ɖua nu, dzonɛ gaɖuna hã la, eƒe afɔkli me mefe o. Enye lã makɔmakɔ na mi. ");
INSERT INTO ewe_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Xɔfie, togbɔ be edzɔa nu gaɖuna hã la, eƒe afɔkli me mefe o. Enye la makɔmakɔ na mi. ");
INSERT INTO ewe_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Fɔmizi, togbɔ be edzɔa nu gaɖuna hã la, eƒe afɔkli me mefe o. Lã makɔmakɔ wònye na mi. ");
INSERT INTO ewe_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Ha, togbɔ be eƒe afɔkli me fe hã la, medzɔa nu gaɖuna o. Lã makɔmakɔ wònye na mi. ");
INSERT INTO ewe_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Mele be miaɖu eƒe lã loo alo aka asi eƒe kukua teti hã ŋu o. Nu makɔmakɔ wònye na mi. ");
INSERT INTO ewe_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Le tɔmelãwo katã gome la, miekpɔ mɔ aɖu ɖe sia ɖe si ŋu adza kple tsro le, ne woɖe wo tso tɔsisiwo me loo alo atsiaƒu me. ");
INSERT INTO ewe_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ke lã siwo katã le atsiaƒu me alo tɔ me esiwo ŋu adza alo tsro mele o, woɖale lã siwo katã ƒua tsi dome alo nu gbagbe bubu siwo katã le tɔ me dome o, wonye ŋunyɔnu na mi. ");
INSERT INTO ewe_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Esi wònye be wonye ŋunyɔnuwo na mi ta la, migaɖu woƒe lã o, eye woƒe kukua hã nanyɔ ŋu na mi. ");
INSERT INTO ewe_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Nu gbagbe ɖe sia ɖe si le tɔ me, esi ŋu tsro kple adza mele o la nanye ŋunyɔnu na mi. ");
INSERT INTO ewe_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Xe siawo nanyɔ ŋu na mi, eye miaɖu wo o, elabena wonye ŋunyɔnuwo: hɔ̃, akaga, akpo, ");
INSERT INTO ewe_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","aʋako dzĩtɔwo kple yibɔtɔwo, ");
INSERT INTO ewe_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","akpaviã ƒomevi vovovoawo, ");
INSERT INTO ewe_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","adzexe si to dzo ɖe ta, adzexe ŋutɔ, golo, tsalɛ̃, aʋako, ");
INSERT INTO ewe_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ʋlukuku, tsimese, kple aŋɔɣi, ");
INSERT INTO ewe_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","favieʋuto, aluge kple akaga, ");
INSERT INTO ewe_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","damixe, ako ƒomeviwo, agudzixe kple agutɔ. ");
INSERT INTO ewe_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Nudzodzoe siwo katã zɔna le afɔ ene dzi, woanye ŋunyɔnu na mi. ");
INSERT INTO ewe_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Ke nudzodzoe aɖewo li siwo zɔna le afɔ ene dzi, esiwo miate ŋu aɖu. Esiawoe nye esiwo te afɔwo le hena kpotiti le anyigba. ");
INSERT INTO ewe_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Esiwo miaɖu woe nye ʋetsuvi tɔgbiwo katã, gbagblami kple abɔ ƒomeviwo katã. ");
INSERT INTO ewe_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Miekpɔ mɔ aɖu nu bubu siwo katã dzona, eye woto afɔ ene la dometɔ aɖeke o. ");
INSERT INTO ewe_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Ame sia ame si aka asi woƒe kukua ŋu la ŋu makɔ o va se ɖe fiẽ, ");
INSERT INTO ewe_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","eye ele nɛ be wòanya eƒe awuwo enumake. Ele nɛ hã be wòaɖe eɖokui ɖe aga va se ɖe fiẽ abe ame si ŋuti mekɔ o ene. ");
INSERT INTO ewe_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Ame si ka asi lã si ƒe afɔkli me mefe tututu o, alo lã si medzɔa nu gaɖuna o ŋu la hã ŋuti mekɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Miekpɔ mɔ aɖu lã afɔene siwo ƒe afɔwo nu fetsu le o. Ame si ka asi woƒe kukua ŋu hã ŋuti mekɔ o, va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ele be ame si atsɔ eƒe kukua aƒu gbe la nanya eƒe awuwo, eye eŋuti makɔ o va se ɖe fiẽ, elabena mede se na mi tso wo ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Lã siwo zɔna le anyigba, eye wo ŋu mekɔ na mi o la woe nye, adɔ, afi kple adoglo ƒomeviwo, ");
INSERT INTO ewe_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","xɔmenyatri, ve, adoglo, atɔ kple agama. ");
INSERT INTO ewe_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ame sia ame si ka asi nu siawo ƒe kukuawo ŋu la ŋu mekɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Nu sia nu si dzi nu siawo dometɔ aɖe ƒe kukua ge dze la ŋu mekɔ o. Ne ege dze nu si wowɔ kple ati, avɔ, ɖovu alo kotoku aɖe dzi la, ele be woaklɔe kple tsi alo anyae, eye eŋuti makɔ o va se ɖe fiẽ. Le esia megbe la, woagate ŋu awɔ eŋu dɔ. ");
INSERT INTO ewe_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ne ege dze agba aɖe si wome kple tsu me la, nu sia nu si le agba la me la ŋu mekɔ o, eye ele be woagbã agba la. ");
INSERT INTO ewe_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Ne tsi si wotsɔ klɔ nu makɔmakɔ aɖe ŋu hlẽ ɖe nuɖuɖu aɖe ŋu la, nuɖuɖu la ŋu mekɔ o. Nunono si le agba makɔmakɔ aɖe me hã ŋu mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Ne lã makɔmakɔ siawo dometɔ aɖe ƒe kukua ka abolokpo aɖe ŋu la, abolokpo la hã ŋu mekɔ o, eya ta ele be woagbãe. ");
INSERT INTO ewe_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ne nu siawo ƒe kuku aɖe ge ɖe tɔʋu alo tsigago aɖe si me tsi le la me la, tsi la menye tsi makɔmakɔ o, gake ame si ɖe nu kukua le tsia me ya la ŋu mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Ne nu kukua ka nuku aɖe si ƒã ge wole ŋu la, nuku la mezu nuku makɔmakɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ke ne nukua ƒo tsi hafi nu kuku la ge ɖe edzi la, ekema nuku ƒotsi la ŋu mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Ne dɔléle wu lã aɖe si ŋu woɖe mɔ le be woaɖu la, ame si ka asi lã la ƒe kukua ŋu la ŋu mekɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Gawu la, ele be ame si ɖu eƒe lã alo tsɔe yi ɖaƒu gbe la nanya eƒe awuwo, eye eŋuti makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Nu gbagbe ɖe sia ɖe si tana le anyigba dzi la nye nu si woatsri; womaɖui o. ");
INSERT INTO ewe_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Migaɖu nu gbagbe si tana le anyigba le eƒe ƒodo dzi alo wòzɔna kple afɔ ene loo alo le afɔ geɖewo dzi la o. Enye nu si woatsri. ");
INSERT INTO ewe_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Migaƒo ɖi mia ɖokuiwo to asikaka wo ŋu me o. ");
INSERT INTO ewe_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Nyee nye Yehowa, miaƒe Mawu. Minɔ dzadzɛe le nu siawo ŋuti, eye mianɔ kɔkɔe, elabena kɔkɔetɔe menye. Eya ta migaƒo ɖi mia ɖokuiwo to asikaka nu siwo tana le anyigba la dometɔ aɖeke ŋu me o. ");
INSERT INTO ewe_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Elabena nyee nye Yehowa si kplɔ mi tso Egiptenyigba dzi be manye miaƒe Mawu. Ele na mi be mianɔ kɔkɔe, elabena kɔkɔetɔe menye. ");
INSERT INTO ewe_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Esiawoe nye se siwo ku ɖe lãwo, xewo kple nu siwo katã ƒua tsi alo tana le anyigba la ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Esiawoe nye vovototo siwo le nu siwo ŋuti kɔ, eye woaɖu wo kple nu siwo ŋuti mekɔ o, eye womaɖu wo o le nu gbagbe siwo nye lãwo le anyigba dzi la dome.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“De se siawo na Israelviwo be, ‘Ne nyɔnu aɖe dzi ŋutsuvi la, nyɔnu la ŋu mekɔ o, ŋkeke adre, eye wòawɔ se siwo dzi wòwɔna ne etsi gbɔto la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ele be woatso aʋa na ɖevia le ŋkeke enyia gbe. ");
INSERT INTO ewe_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ekema le ŋkeke blaetɔ̃-vɔ-etɔ̃ siwo akplɔe ɖo, le ale si eŋuti mekɔ haɖe o ta la, maka asi nu kɔkɔe aɖeke ŋuti o, eye made Agbadɔ me hã o. ");
INSERT INTO ewe_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ne nyɔnu aɖe dzi nyɔnuvi la, nyɔnu la ŋu mekɔ o kɔsiɖa eve, eye wòawɔ se siwo dzi wòwɔna ne etsi gbɔto la dzi. Ekema le ŋkeke blaade-vɔ-ade siwo akplɔe ɖo me la, ʋu si anɔ dodom le eŋuti la ana be eƒe ŋuti nanɔ kɔkɔm. ");
INSERT INTO ewe_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Ne nyɔnu la ƒe ŋutikɔkɔ ƒe ɣeyiɣi de la, ne via nye ŋutsuvi loo alo nyɔnuvi hã la, ele na nyɔnu la be wòana alẽvi si xɔ ƒe ɖeka hena numevɔsa, eye wòana ahɔnɛ alo akpakpa ɖeka hena nu vɔ̃ ŋuti vɔsa. Atsɔ nu siawo ayi na nunɔla la le Agbadɔ la ƒe ʋɔtru nu, ");
INSERT INTO ewe_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","nunɔla la asa vɔ na Yehowa, eye wòalé avu ɖe enu. Ekema eŋuti akɔ azɔ le ʋu si do le eŋu to vidzidzi me la megbe. “ ‘Esiawoe nye nu siwo wòle be woawɔ le vidzidzi megbe. ");
INSERT INTO ewe_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ke ne nyɔnu aɖe da ahe ale gbegbe be mate ŋu ana alẽ o la, ekema ele nɛ be wòana akpakpa eve alo ahɔnɛ eve. Woatsɔ xeviawo dometɔ ɖeka asa numevɔ, eye woatsɔ evelia asa nu vɔ̃ vɔsae. Nunɔla la atsɔ nu siawo alé avu ɖe enu ale be eŋuti nagakɔ.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yehowa gblɔ na Mose kple Aron bena, ");
INSERT INTO ewe_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Ne ame aɖe kpɔ nutete alo dzi alo teƒe aɖe si fu le eƒe ŋutilã ŋu si ate ŋu azu ŋutilã ƒe dɔxɔleameŋu la, woakplɔe ayi nunɔla Aron alo Via ŋutsu siwo nye nunɔlawo la dometɔ ɖeka gbɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Nunɔla la alé ŋku ɖe abi si le eƒe ŋutigbalẽ ŋu la ŋu. Ne ŋutifu si le teƒea fu, eye teƒea nye ɖe eme vie la, ekema anyie. Nunɔla la atso nya me be anyidzela la ŋu mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ke ne teƒe si fu kpii la menye ɖe eme vie o, eye fu si le teƒea mefu o la, ekema nunɔla la aɖee ɖe aga ŋkeke adre. ");
INSERT INTO ewe_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Le ŋkeke adrea gbe la, nunɔla la agadoe akpɔ. Ne teƒea metrɔ o, eye megakeke ɖe edzi hã o la, ekema nunɔla la aɖee ɖe aga ŋkeke adre bubu. ");
INSERT INTO ewe_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Nunɔla la agadoe akpɔ le ŋkeke adre evelia gbe. Ne dɔléle la dzi ka ɖe, eye teƒea megakeke ɖe edzi o la, ekema nunɔla la atso nya me be amea ŋuti kɔ, dzi koe ƒo ɖe eŋu. Nu si amea awɔ la koe nye wòanya eƒe awuwo, eye eƒe ŋuti akɔ, ");
INSERT INTO ewe_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","gake nenye be dzi la keke ɖe edzi le eƒe ŋutigbalẽ ŋu esi wòtsɔ eɖokui fia nunɔla la be wòagblɔ be eŋuti kɔ vɔ megbe la, ele nɛ be wòagbugbɔ ayi nunɔla la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Eye nunɔla la agadoe kpɔ. Ne teƒea keke ɖe edzi la, ekema nunɔla la atso nya me be eŋuti mekɔ o, kpodɔe wòdze. ");
INSERT INTO ewe_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Ne ame aɖe dze ŋutigbalẽdɔ si woate ŋu axɔ le ame ŋu la, woakplɔe ayi nunɔla gbɔe. ");
INSERT INTO ewe_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Nunɔla la alé ŋku ɖe eŋu eye ne nutete ɣi aɖe le eƒe ŋutilã ŋu la, ");
INSERT INTO ewe_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ekema eme kɔ ƒãa be anyie, eye nunɔla la naɖe gbeƒã be eŋu mekɔ o. Mele be woagatu amea ɖe xɔ me be woagalé ŋku ɖe eŋu o, elabena eme kɔ ƒãa be edze dɔ la. ");
INSERT INTO ewe_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Ke ne nunɔla la kpɔ be kpodɔ la xɔ ŋuti katã na amea, tso eƒe tame yi eƒe afɔ gbɔ, ");
INSERT INTO ewe_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","kple afi sia afi si wòakpɔ ɖa le la, ekema nunɔla la atso nya me be eŋuti kɔ, nenye be eŋuti katã fu kpii la, ekema eŋuti kɔ le se la nu. ");
INSERT INTO ewe_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Ke ne eƒe ŋutilã ƒe teƒe aɖe ƒlɔ la, ekema efia be edze kpodɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Nunɔla la agalé ŋku ɖe eŋu, eye ne ekpɔ be eƒe ŋutilã ƒe akpa aɖe ƒlɔ la, ekema aɖe gbeƒã be ame la dze kpodɔ. Ŋutilã ƒe ƒɔƒlɔ fia be amea le kpodɔ lém, eya ta eŋuti mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Gake ne ŋutilã ƒe akpa si ƒlɔ la ɖɔ ɖo, eye wòle abe ŋutilãa ƒe akpa bubuawo ene la, ame la atrɔ ayi ɖe nunɔla la gbɔ, ");
INSERT INTO ewe_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","eye nunɔla la agadoe akpɔ. Nenye be teƒe ƒɔƒlɔ la ɖɔ ɖo abe ŋutilãa ƒe akpa bubuwo ene la, ekema eŋuti kɔ le se la nu, eye nunɔla la aɖe gbeƒã be eŋuti kɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Ne ƒoƒoe ƒo ame aɖe ƒe ŋutigbalẽ, wòɖi tsi vɔ, ");
INSERT INTO ewe_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","eye le teƒe si ƒoƒoe la ƒo nɛ nu ƒoƒoe wuliwuli aɖewo ƒo ɖi esiwo le ɣie alo le nu dzĩ kple nu ɣi dome la, ele nɛ be wòatsɔ eɖokui afia nunɔlaa. ");
INSERT INTO ewe_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Ne nunɔla la doe kpɔ, eye wòkpɔ be dɔléle la tso keke eƒe lãme, ke eye fu si le teƒea fu kpii la, ekema nunɔla la atso nya me be, eŋuti mekɔ o, elabena edze kpodɔ to ƒoƒoe la teƒe. ");
INSERT INTO ewe_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ke ne nunɔla la kpɔ be fu ɣi aɖeke mele teƒea o, eye teƒea hã menye ɖe eme o, ke teƒea le fufu kple nyɔnyɔ dome la, ekema nunɔla la aɖee ɖe aga ŋkeke adre. ");
INSERT INTO ewe_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Ne teƒea keke ɖe edzi le ŋkeke adre mawo me la, ekema nunɔla la atso nya me be eŋuti mekɔ o, ezu kpodɔléla. ");
INSERT INTO ewe_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Ke ne teƒea mekeke ɖe edzi o la, ekema ƒoƒoe la ƒe abiteƒe koe. Nunɔla la atso nya me be eŋuti kɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Ne dzo me ame aɖe ƒe ŋutigbalẽ, eye emegbe teƒea biã loo alo le biabiã kple fufu dome alo fu kpii le teƒe si dzoa me na amea la, ");
INSERT INTO ewe_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ele be nunɔla la nalé ŋku ɖe teƒea ŋu. Ne fu si le teƒea fu, eye wòdze abe dɔléle la tso amea ƒe lãme ke ene la, ekema woanya be amea dze kpodɔ to dzobi la teƒe, eye nunɔla la aɖe gbeƒã be eŋuti mekɔ o, edze anyi. ");
INSERT INTO ewe_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Ke ne nunɔla la kpɔ be fu ɣi aɖeke mele teƒea o, teƒea ƒe biabia metso amea ƒe lãme ke o, eye eƒe amadede dzi nɔ ɖeɖem kpɔtɔ la, ekema nunɔla la atui ɖe xɔ me ŋkeke adre, ");
INSERT INTO ewe_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","eye wòagadoe kpɔ le ŋkeke adrea gbe. Ne teƒea keke ɖe edzi la, ekema nunɔla la atso nya me be eŋu mekɔ o, edze kpodɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ke ne teƒe biabiã la medze le teƒe bubu aɖeke loo alo keke ɖe edzi o, eye eƒe biabiã dzi ɖe kpɔtɔ la, ekema wòanya be dzobi la ƒe abiteƒe koe. Ekema nunɔla la atso nya me be eŋuti kɔ, dzobi la teƒe koe ɖi atse. ");
INSERT INTO ewe_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Ne ŋutsu alo nyɔnu aɖe dze abi ɖe ta alo glã la, ");
INSERT INTO ewe_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","nunɔla alé ŋku ɖe abi la ŋu. Ne abi la teƒe dze abe ɖe wòde eme wu amea ƒe ŋutilã, ɖa si le afi ma ƒe amadede le abe aŋutiɖiɖi ene, eye wòle belie la, nunɔla la aɖe gbeƒã be amea ŋuti mekɔ o; enye ta alo glã ƒe dɔléle. ");
INSERT INTO ewe_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Ke ne nunɔla la kpɔ be ŋutigbalẽ la ŋuti ko abi la dzɔ tso, eye ɖa yibɔ le abia me la, ekema atui ɖe xɔ me ŋkeke adre, ");
INSERT INTO ewe_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","eye wòagadoe kpɔ le ŋkeke adrea gbe. Ne teƒe la mekeke ɖe edzi o, ne fu si le afi ma ƒe amadede meɖi aŋuti ɖiɖi tɔ o, eye ne medze be dɔléle aɖee tso eƒe lãme ke o la, ");
INSERT INTO ewe_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ekema nunɔla la aƒlɔ ɖa, aƒo xlã teƒe la, ke menye le teƒea ŋutɔ o. Nunɔla la agatui ɖe xɔ me ŋkeke adre bubu, ");
INSERT INTO ewe_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","eye wòagadoe kpɔ le ŋkeke adrea gbe. Ne teƒe la mekeke ɖe edzi o, eye medze abe dɔléle la tso ŋutigbalẽ la te o ene la, ekema nunɔla la atso nya me be medze kpodɔ o. Ekema ne enya eƒe awuwo ko la, eŋuti kɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Ke ne teƒe la de asi keke me ɖe edzi emegbe la, ");
INSERT INTO ewe_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ekema nunɔla la agadoe kpɔ, eye magalala be yeakpɔ be ɖa ƒe amadede trɔ ɖi aŋuti ɖiɖi hafi wòatso nya me be amea dze kpodɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Gake ne edze be teƒe la megale kekem ɖe edzi o, eye ɖa yibɔ le teƒea la, ekema dɔléle la nu tso, amea menye kpodɔléla o, eya ta nunɔla la atso nya me be eƒe ŋuti kɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Ne ŋutsu aɖe alo nyɔnu aɖe ƒe ŋutilã ƒe akpa aɖewo fu kpii, ");
INSERT INTO ewe_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","eye teƒe la ƒe fufu dzi le ɖeɖem kpɔtɔ la, ekema amea medze anyi o, ke boŋ dɔléle aɖe koe ƒo ɖe eŋu. ");
INSERT INTO ewe_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Womatsɔ ame aɖeke ƒe ɖa ƒe bebe le ta nɛ abe anyidzedze ene o! ");
INSERT INTO ewe_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ne ɖa vɔ le ame aɖe ƒe ŋgonu la, ekema amea ƒe ŋgoe kpã: esia menye anyidzedze o. ");
INSERT INTO ewe_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Ke ne teƒe aɖe le biabiã kple fufu dome le ta kpakpã la teƒe la, ekema anye kpodɔ dzem wòle. ");
INSERT INTO ewe_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ekema nunɔla la adoe akpɔ. Ne teƒe la le kpokploo, mebiã tututu o, eye mefu tututu abe kpodɔ ƒe dzesi ene o hã la, ");
INSERT INTO ewe_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ekema nunɔla la atso nya me be amea dze kpodɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Ele na ame si wokpɔ be edze kpodɔ la be wòadze eƒe awuwo, ana eƒe taɖa nato ʋutuu, wòatsyɔ nu eƒe nuyi dziƒotɔ dzi, eye wòanɔ yiyim anɔ ɣli dom be, ‘Nye ŋuti mekɔ o, nye ŋuti mekɔ o!’ ");
INSERT INTO ewe_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ŋkeke ale si dɔléle la le eŋu ko la, eŋuti mekɔ o. Ele be wòanɔ asaɖa la godo.” ");
INSERT INTO ewe_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Ne nane dze le nudodo alo nutata aɖe me, eɖanye lãfu tɔ alo ɖeti tɔ, ");
INSERT INTO ewe_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","alo nu si wolɔ̃ kple ɖeti alo lãfu, ");
INSERT INTO ewe_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","eye aŋgbamu alo ama dzĩ teƒe aɖe le eme la, anye kpodɔ. Ekema woatsɔ nu la ayi na nunɔla wòadoe akpɔ. ");
INSERT INTO ewe_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Nunɔla la atsɔ nu la adzra ɖo ŋkeke adre, ");
INSERT INTO ewe_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","eye wòagalé ŋku ɖe eŋu le ŋkeke adrea gbe. Ne teƒe la keke ɖe edzi la, ekema kpodɔ si woate ŋu axɔ lae. ");
INSERT INTO ewe_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ekema ele be nunɔla la natɔ dzo awu la, avɔ la alo nu si wolɔ̃ kple lãfu, ɖeti alo lãgbalẽ la, elabena woate ŋu axɔ kpodɔ la, eya ta ele be woatɔ dzoe. ");
INSERT INTO ewe_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Ke ne nunɔla la lé ŋku ɖe eŋu le ŋkeke adrea gbe, eye wòkpɔ be teƒe la mekeke ɖe edzi o la, ");
INSERT INTO ewe_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ekema ana woanya alo aklɔ nu la, eye wòatsɔe adzra ɖo ŋkeke adre. ");
INSERT INTO ewe_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Le ŋkeke adrea megbe, ne teƒe la ƒe amadede metrɔ o, togbɔ be teƒe la mekeke ɖe edzi o hã la, efia be kpodɔe, eya ta ele be woatɔ dzoe, elabena kpodɔ le eme. ");
INSERT INTO ewe_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Ne nunɔla la kpɔ be teƒe la ƒe amadede klo le nua nyanya megbe la, ekema alã teƒe la ɖa le avɔ la, lãgbalẽnu alo nu lɔlɔ̃ la me. ");
INSERT INTO ewe_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Ke ne wogakpɔ dzesi ma le nu lɔlɔ̃a me la, ekema kpodɔe: ele be nunɔla la natɔ dzoe. ");
INSERT INTO ewe_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ke ne dzesi ma megadze le nu lɔlɔ̃a nyanya vɔ megbe o la, woaganyae, eye woagate ŋu awɔ eŋu dɔ azɔ.” ");
INSERT INTO ewe_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Esiawoe nye se siwo ku ɖe kpodɔ ƒe avɔ si wolɔ̃ kple lãfu alo ɖeti me nɔnɔ ŋuti. Wofia ale si woawɔ aka ɖe edzi be kpodɔléle la le eme loo alo mele eme o. ");
INSERT INTO ewe_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Esiawoe nye ɖoɖowo na ame si dze dɔ le ameŋukɔɣi ne wokplɔe va nunɔla gbɔe. ");
INSERT INTO ewe_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Nunɔla la atso asaɖa la me ayi aɖadoe kpɔ. Ne nunɔla la kpɔ be kpodɔléla la ƒe lãme sẽ la, ");
INSERT INTO ewe_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ana amea nana xevi eve siwo ŋu se ɖe mɔ le be woaɖu, hekpe ɖe sedati, ka dzĩ kple kakle ŋu be wòawɔ wo ŋu dɔ hena kpodɔléla si haya la ŋutikɔkɔ ƒe kɔnuwo wɔwɔ. ");
INSERT INTO ewe_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Nunɔla la ana woawu xeviawo dometɔ ɖeka ɖe ze si me tsi nyui le la me. ");
INSERT INTO ewe_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Woanyrɔ xevi evelia si le agbe la kple sedati, ka dzẽ kpakple kakle la ɖe xeviʋu la me le zea me. ");
INSERT INTO ewe_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Ekema nunɔla la ahlẽ ʋu la ɖe ame si ŋu kpodɔ la vɔ le la ŋu zi adre. Nunɔla la aɖe gbeƒã be amea ŋu kɔ azɔ, eye wòaɖe asi le xevi gbagbe la ŋu wòadzo adzo. ");
INSERT INTO ewe_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Ame si ŋu wokɔ la, anya eƒe awuwo, aƒlɔ eƒe taɖa katã ɖa, ale tsi, eye wòayi aɖanɔ asaɖa la me azɔ. Ke anɔ eƒe agbadɔ godo ŋkeke adre. ");
INSERT INTO ewe_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Le ŋkeke adrea gbe la, agaƒlɔ eƒe taɖa ƒioƒioƒio, alũ eƒe ge kple eƒe adzugo, anya eƒe awuwo, ale tsi, ekema woabui be kpodɔ la vɔ le eŋu azɔ keŋkeŋ. ");
INSERT INTO ewe_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Ne ŋu ke si anye ŋkeke enyia gbe la, amea ana alẽvi eve siwo de blibo, alẽnɔe ɖeka si xɔ ƒe ɖeka, eye wòde blibo, wɔ memee kilogram atɔ̃ si dzi wokɔ ami ɖo kple ami lita ɖeka ƒe akpa etɔ̃lia. ");
INSERT INTO ewe_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Nunɔla si doe kpɔ la atsɔ amea kple eƒe nunana aɖo Yehowa ŋkume le Agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Nunɔla la atsɔ alẽawo dometɔ ɖeka kple ami lita ɖeka ƒe akpa etɔ̃lia la, eye wòatsɔ wo ana Yehowa abe fɔɖivɔsa ene to wo nyenye le yame le vɔsamlekpui la ŋgɔ me. ");
INSERT INTO ewe_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Awu alẽ la le afi si wowua nu vɔ̃ ŋuti vɔsalãwo kple numevɔsalãwo le, le Agbadɔ la me. Woatsɔ fɔɖivɔsa sia ana nunɔla la abe eƒe nuɖuɖu ene, abe ale si wowɔna le nu vɔ̃ ŋuti vɔsa me ene. Enye vɔsa kɔkɔe ƒe vɔsa kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Nunɔla la asisi fɔɖivɔsalã la ƒe ʋu ƒe ɖe ɖe ame si ŋuti kɔm wòle la ƒe ɖusito ŋu, ɖe eƒe ɖusisi ƒe degblefetsu ŋu kple eƒe ɖusifɔ ƒe degblefetsu ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Emegbe nunɔla la akɔ ami la ɖe eya ŋutɔ ƒe miasiƒome. ");
INSERT INTO ewe_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Nunɔla la atsɔ eƒe nuɖusi ƒe asibidɛ ɖeka ade ami la me, eye wòahlẽe kple eƒe asibidɛ zi adre le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Nunɔla la asisi ami si susɔ ɖe eƒe miasiƒome la ɖe amea ƒe ɖusito kple eƒe ɖusisi ƒe adegblefetsu kple eƒe ɖusifɔ ƒe adegblefetsu ŋu, abe ale si wòwɔ kple fɔɖivɔsalã la ƒe ʋu ene. ");
INSERT INTO ewe_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Atsɔ ami si gasusɔ ɖe eƒe miasiƒome la asi ɖe ta nɛ. Ale nunɔla la alé avu ɖe enu le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Le esia megbe la, nunɔla la asa nu vɔ̃ vɔsa la, eye wòagalé avu le ame si ŋu kɔm wòle tso kpodɔ si me la nu. Nunɔla la awu numevɔsalã la, ");
INSERT INTO ewe_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","eye wòatsɔ nuɖuvɔsa akpe ɖe eŋu atsɔ sa vɔe le vɔsamlekpui la dzi, alé avu ɖe amea nu, ekema woagblɔ be amea ŋuti kɔ keŋkeŋ azɔ. ");
INSERT INTO ewe_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Ne amea da ahe ale gbegbe be mate ŋu ana alẽvi eve o la, ekema ana agbovi ɖeka ko na fɔɖivɔsa la be woatsɔ ana Yehowa hena avuléle to enyenye le yame le vɔsamlekpui la ŋgɔ me. Nu siwo agakpe ɖe esia ŋu koe nye wɔ memee kilogram ɖeka si dzi wokɔ ami ɖo hena nuɖuvɔsa la kple amitimi lita ɖeka ƒe akpa etɔ̃lia. ");
INSERT INTO ewe_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","“Ele be wòagana akpakpa eve alo ahɔnɛvi eve, wo dometɔ si wòate ŋu ana ko. Woatsɔ xeviawo dometɔ ɖeka asa nu vɔ̃ vɔsa, eye woatsɔ evelia asa numevɔ. ");
INSERT INTO ewe_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Amea atsɔ wo vɛ na nunɔla la le Agbadɔ la ƒe mɔnu le ŋkeke enyia gbe hena eŋutikɔkɔ le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Nunɔla la atsɔ alẽvi kple amitimi lita ɖeka ƒe akpa etɔ̃lia la asa fɔɖivɔ, eye wòanye wo le vɔsamlekpui la ŋgɔ abe wo tsɔtsɔ na Yehowa ƒe dzesi ene. ");
INSERT INTO ewe_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Emegbe la, awu alẽvi la na fɔɖivɔsa la, eye wòasi ʋu la ƒe ɖe ɖe ame si ŋu kɔm wòle la ƒe ɖusito ŋu kple eƒe ɖusisi ƒe degblefetsu dzi kple eƒe ɖusifɔ ƒe degblefetsu dzi. ");
INSERT INTO ewe_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Azɔ la, nunɔla la atrɔ ami la akɔ ɖe eya ŋutɔ ƒe miasiƒome, ");
INSERT INTO ewe_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","eye wòatsɔ eƒe ɖusi ƒe asibidɛ ɖeka ahlẽ ami la ƒe ɖe zi adre le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Ekema asi ami si le eƒe asiƒome la ƒe ɖe ɖe eƒe ɖusito ŋu kple eƒe ɖusisi ƒe adegblefetsu kple eƒe ɖusifɔ ƒe adegblefetsu dzi, abe ale si wòwɔ kple nu vɔ̃ ŋuti vɔsa la ƒe ʋu ene. ");
INSERT INTO ewe_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Nunɔla la atsɔ ami si susɔ ɖe eƒe asiƒome la asi na ame si ŋu kɔm wòle la ƒe ta, atsɔ alé avu ɖe enu le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Azɔ la, ana akpakpa eveawo alo ahɔnɛvi eveawo, wo dometɔ si wòate ŋui ko. ");
INSERT INTO ewe_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Woatsɔ xeviawo dometɔ ɖeka asa nu vɔ̃ vɔsa, eye woatsɔ evelia asa numevɔ kpe ɖe nuɖuvɔ ŋu. Nunɔla la alé avu ɖe amea nu le Yehowa ŋkume.” ");
INSERT INTO ewe_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Esiawoe nye se siwo ku ɖe ŋutigbalẽdɔléla siwo mate ŋu axe fe ɖe vɔsasa siwo woɖo hena wo ŋutikɔkɔ o la ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yehowa gblɔ na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Ne mieɖo Kanaanyigba, afi si mele tsɔtsɔm na mi be wòanye mia tɔ dzi, eye meda kpodɔ ɖe aƒe aɖe me le anyigba la dzi la, ");
INSERT INTO ewe_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ekema ele be aƒea tɔ nava gblɔ na nunɔla la be, ‘Edze nam abe ɖe kpodɔ le nye aƒe me ene!’ ");
INSERT INTO ewe_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Nunɔla la ana woafɔ nu sia nu ado goe le aƒea me hafi wòalé ŋku ɖe aƒea ŋu, ale be nu siwo le aƒea me la dometɔ aɖeke magazu nu makɔmakɔ ne ekpɔ be kpodɔ le aƒea me o. ");
INSERT INTO ewe_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ne ekpɔ aŋgbamu ƒe teƒe kple teƒe dzĩ aɖewo le aƒea me ƒe gliwo ŋu, eye teƒe mawo dze abe ɖe wonye ɖe eme vie ene la, ");
INSERT INTO ewe_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ele be nunɔla la natu aƒe la ŋkeke adre, ");
INSERT INTO ewe_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","eye wòatrɔ ava le ŋkeke adrea gbe be wòagalé ŋku ɖe aƒea ŋu. Ne teƒeawo keke ɖe edzi le gliawo ŋu la, ");
INSERT INTO ewe_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ekema nunɔla la ana woadza teƒe mawo ɖa le gliawo ŋu, eye woalɔ gli kakawo aɖakɔ ɖe teƒe makɔmakɔ aɖe le dua godo. ");
INSERT INTO ewe_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Le esia megbe la, ana woaka xɔa me ƒe gliwo ŋu nyuie, eye woalɔ gli kakawo aɖakɔ ɖe teƒe makɔmakɔ aɖe le dua godo. ");
INSERT INTO ewe_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Woatsɔ kpe yeyewo aɖɔli kpe xoxo siwo woho le gliawo me, eye woagbugbɔ gliawo ŋu azrɔ̃. ");
INSERT INTO ewe_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Ne aŋgbamu teƒe kple teƒe dzĩawo gadze la, ");
INSERT INTO ewe_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","nunɔla la agava alé ŋku ɖe wo ŋu, eye ne ekpɔ be wokeke ɖe edzi la, ekema atso nya me be kpodɔe, eye aƒea ŋu mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Ana woagbã xɔ la, eye woalɔ kpeawo, atiawo kple anyi la aɖakɔ ɖe teƒe makɔmakɔ aɖe le dua godo. ");
INSERT INTO ewe_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Ame sia ame si ge ɖe aƒea me le esime wotui la, ŋu mekɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Ele na ame sia ame si mlɔ aƒea me alo ɖu nu le eme la be wòanya eƒe awuwo. ");
INSERT INTO ewe_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Ke ne nunɔla la va zi evelia be yealé ŋku ɖe aƒea ŋu, eye teƒeawo megadze le gliawo ŋu zɔzrɔ̃ megbe o la, ekema atso nya me be aƒea ŋu kɔ, eye kpodɔ la megali o. ");
INSERT INTO ewe_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Atsɔ xevi eve, sedati, ka dzĩ kple kakle awɔ nuŋukɔkɔ ƒe wɔnawoe. ");
INSERT INTO ewe_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Awu xeviawo dometɔ ɖeka ɖe ze si me tsi nyui le la me. ");
INSERT INTO ewe_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ekema atsɔ sedati la, kakle la, ka dzĩ la kple xevi gbagbe la ade xevi si wowu la ƒe ʋu kple tsi nyui me, eye wòahlẽe ɖe aƒea ŋu zi adre. ");
INSERT INTO ewe_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Akɔ aƒea ŋu kple xevi la ƒe ʋu, tsi nyui la, xevi gbagbe la, sedati la kple kakle kple ka dzĩ la. ");
INSERT INTO ewe_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Aɖe asi le xevi gbagbe la ŋu wòadzo ayi gbe me le du la godo. Mɔ sia dzie wòato aɖe vɔ̃ ɖa le aƒe la ŋu, eye wòakɔ eŋuti.” ");
INSERT INTO ewe_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Esiawoe nye se siwo ku ɖe teƒe vovovo siwo kpodɔ ado ɖo la ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","le awu me loo alo le xɔ ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","le nutete teƒe, dzobi teƒe loo alo teƒe dzĩ aɖe le ame ƒe ŋutilã ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Miato mɔ sia dzi anya nenye kpodɔe loo alo menye eyae o. Nu sia tae wona se siawo ɖo. ");
INSERT INTO ewe_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yehowa gblɔ na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Migblɔ na Israelviwo be, ‘Ne ŋutsu aɖe le afu ɖɔm la, eŋuti mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ne afua le dodom alo ne enu tso hã la, ŋutsu la ŋu mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Abati si dzi wòmlɔ kple nu si dzi wònɔ hã ŋu mekɔ o, ");
INSERT INTO ewe_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","eya ta ame si ka asi ŋutsu la ƒe abati ŋu hã ŋuti mekɔ o va se ɖe fiẽ; ele nɛ be wòanya eƒe awuwo, eye wòale tsi. ");
INSERT INTO ewe_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Ame si nɔ zikpui si dzi ŋutsu si ŋu mekɔ o nɔ la hã ŋu mekɔ o va se ɖe fiẽ. Ele nɛ be wòanya eƒe awuwo, eye wòale tsi. ");
INSERT INTO ewe_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Ame si ka asi ŋutsu si le afu ɖɔm ŋuti la ŋuti mekɔ o va se ɖe fiẽ, eye ele nɛ be wòanya eƒe awuwo, ale tsi. ");
INSERT INTO ewe_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Ne ŋutsu si le afu ɖɔm ɖe ta ɖe ame si ŋuti kɔ ŋu la, ele na ame ma be wòanya eƒe awuwo, ale tsi, eye eŋuti mekɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Nu sia nu si dzi afuɖɔla la anɔ ne ele sɔ dom la, ŋuti mekɔ o, ");
INSERT INTO ewe_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","eye ame si aka asi nu siwo dzi wònɔ do sɔ la dometɔ aɖe ŋu la ŋuti mekɔ o va se ɖe fiẽ. Nenema ke ame si fɔ nuawo hã la ŋuti mekɔ o va se ɖe fie; ele nɛ be wòanya eƒe awuwo, ale tsi. ");
INSERT INTO ewe_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Ne ŋutsu si ŋu mekɔ o, meklɔ asi hafi ka asi ame aɖe ŋu o la, ele na amea hã be wòanya eƒe awuwo, ale tsi, eye eŋu makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Ele be woagbã ze si ŋu ŋutsu la ka asii, eye woaklɔ atinu si ŋu wòka asii. ");
INSERT INTO ewe_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Ne ŋutsu aɖe ŋu kɔ tso afuɖɔɖɔ me la, nexlẽ ŋkeke adre hena eƒe ŋutikɔklɔ ƒe kɔnu, nenya eƒe awuwo eye wòale tsi nyuie ekema eŋuti akɔ. ");
INSERT INTO ewe_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Le ŋkeke enyia gbe la, alé akpakpa eve alo ahɔnɛvi eve, ado ɖe Yehowa ŋkume le Agbadɔ la ƒe mɔnu, eye wòatsɔ wo ana nunɔla la. ");
INSERT INTO ewe_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Nunɔla la atsɔ akpakpawo dometɔ ɖeka asa nu vɔ̃ vɔsa, eye wòatsɔ evelia asa numevɔ. Ale nunɔla la alé avu ɖe enu le Yehowa ŋkume le afu si wòɖɔ la ta. ");
INSERT INTO ewe_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Ɣe sia ɣi si ŋutsu aɖe anye tsi la, ele nɛ be wòale tsi nyuie, eye eŋu makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ele be wòanya nudodo alo ayi si ŋu ŋutsu ƒe tsi la ka la kple tsi, eye eŋu makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ne ŋutsu aɖe dɔ nyɔnu aɖe gbɔ la, ele be wo ame eve la nale tsi, eye wo ŋu mekɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Ne nyɔnu aɖe kpɔ dzinu la, eŋu mekɔ o va se ɖe esime ŋkeke adre nava yi. Le ɣeyiɣi sia me la, ame sia ame si ka asi eŋu la ŋu mekɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Nu sia nu si dzi wòamlɔ alo anɔ le ɣe ma ɣi me la ŋuti mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Ame sia ame si ka asi eƒe abati ŋu la anya eƒe awuwo, ale tsi, eye eŋu makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Ame sia ame si ka asi eƒe nunɔdzi aɖe ŋu la, anya eƒe awuwo, ale tsi, eye eŋu makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Eɖanye abati o, eɖanye nu si dzi wònɔ o, ne ame aɖe ka asi eŋu ko la, amea ŋu makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Ŋutsu si adɔ nyɔnu sia gbɔ le eƒe asiɖoanyiɣi, eye ʋua ƒe ɖe ka eŋu la, eŋuti makɔ o hena ŋkeke adre, eye abati ɖe sia ɖe si dzi wòamlɔ la ŋu makɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Ne gbɔtotsitsi la xɔ ɣeyiɣi wu ale si wòxɔna tsã alo wòva le ɣeyiɣi trama aɖe dzi le ɣletia me la, ekema nyɔnu la ŋuti mekɔ o, zi ale si ʋu la le dodom abe ale si wònɔna ne wòɖo asi anyi ene. ");
INSERT INTO ewe_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Esia fia be nu sia nu si dzi wòamlɔ le ɣeyiɣi ma me la ŋu makɔ o, abe ale si wòanɔ le eƒe gbɔtotsitsi ŋutɔ me ene. Nenema ke nu sia nu si dzi wòanɔ hã ŋu mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Ame sia ame si ka asi eƒe abati alo nu si dzi wònɔ ŋu la ŋu mekɔ o. Ele be wòanya eƒe awuwo, ale tsi, eye eŋuti makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Ne gbɔtotsitsi sia nu tso, eye ŋkeke adre va yi la, ekema eŋuti kɔ azɔ. ");
INSERT INTO ewe_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Le ŋkeke enyia gbe la, nyɔnu la atsɔ akpakpa eve alo ahɔnɛvi eve ayi na nunɔla la le Agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Nunɔla la atsɔ ɖeka asa nu vɔ̃ vɔsa, atsɔ evelia asa numevɔ, eye wòalé avu ɖe enu le Yehowa ŋkume le ale si gbɔtotsitsi na eŋu mekɔ o la ta. ");
INSERT INTO ewe_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Ale ne Israelviwo ŋu mekɔ o la, miakɔ wo ŋuti; ne menye nenema o la, woagblẽ kɔ ɖo na nye Agbadɔ si le wo dome, eye woaku.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Eya ta esiae nye se na ŋutsu si le afu ɖɔm kple ŋutsu si nye tsi, eye eŋu mekɔ o, ");
INSERT INTO ewe_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kple se le nyɔnuwo ƒe gbɔtotsitsi ŋu kple se na ŋutsu si adɔ nyɔnu si tsi gbɔto, eye eŋu mekɔ o la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Yehowa ƒo nu na Mose le Aron ƒe viŋutsu eveawo ƒe ku megbe esime wote ɖe Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Yehowa gblɔ na Mose be, “Gblɔ na nɔviwò, Aron be megayi Kɔkɔeƒe la le xɔmetsovɔ la megbe le nutsyɔnu si le nubablaɖaka la ŋgɔ ɣe sia ɣi si dze eŋu o, ne menye nenema o la, aku, elabena medzena le lilikpo me le nutsyɔnu la tame. ");
INSERT INTO ewe_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Aron age ɖe Kɔkɔeƒe la me ale: atsɔ nyitsuvi ɖe asi hena nu vɔ̃ ŋuti vɔsa kple agbo hena numevɔsa. ");
INSERT INTO ewe_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Ado kɔmewu kɔkɔe la, eye wòado aklalawutewuiawo ɖe ete. Emegbe la, atsɔ aklalalidziblanu la abla ɖe eɖokui ŋu, eye wòatsɔ aklalatablanu la abla tae. Nu siawo nye awu kɔkɔewo, eya ta ele nɛ be wòale tsi hafi ado wo. ");
INSERT INTO ewe_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Israelviwo ana gbɔ̃tsu eve hena woƒe nu vɔ̃ ŋuti vɔsa kple agbo ɖeka hena woƒe numevɔsa. ");
INSERT INTO ewe_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Gbã la, ele be wòatsɔ nyitsuvi fɛ̃ la asa nu vɔ̃ vɔsa na Yehowa ɖe eɖokui ta, eye wòalé avu ɖe eya ŋutɔ kple eƒe ƒomea ta. ");
INSERT INTO ewe_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Emegbe la, akplɔ gbɔ̃tsu eveawo ava Yehowa ŋkume le Agbadɔ la ƒe mɔnu, ");
INSERT INTO ewe_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","eye wòadzidze nu, anya gbɔ̃tsu si nye Yehowa tɔ kple esi nye Azazel tɔ, si ŋu wòaɖe asi le. ");
INSERT INTO ewe_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aron asa nu vɔ̃ vɔsa kple gbɔ̃tsu si nye Yehowa tɔ. ");
INSERT INTO ewe_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Woatsɔ gbɔ̃tsu evelia si nye Azazel tɔ la agbagbe ava Yehowa ŋkume. Woaɖe dukɔwo ƒe nu vɔ̃wo ada ɖe edzi, eye woanyae ɖo ɖe Azazel gbɔ le gbedzi. ");
INSERT INTO ewe_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Ne Aron tsɔ nyitsu la sa nu vɔ̃ vɔsa ɖe eya ŋutɔ kple eƒe ƒometɔwo ta vɔ la, ");
INSERT INTO ewe_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","atsɔ dzoɖesonu, aɖe aka xɔxɔwo tso Yehowa ƒe vɔsamlekpui dzi ade eme, eye wòalɔ dzudzɔdonu si wotu memie la ƒe asiʋlo eve ayi xɔmetsovɔ la godo. ");
INSERT INTO ewe_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Atsɔ dzudzɔdonu la akɔ ɖe dzoka xɔxɔawo dzi le afi ma, le Yehowa ŋkume, ale be dzudzɔdonu la ƒe dzudzɔ naxɔ amenuvevezikpui la dzi le nubablaɖaka la tame, ale be magakpɔ nubablaɖaka la tame ne wòaku o. ");
INSERT INTO ewe_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Atsɔ nyitsu la ƒe ʋu ƒe ɖe ade asibidɛ eme, eye wòahlẽ ʋu la ɖe amenuvevezikpui la ƒe ɣedzeƒe lɔƒo, eye wòagahlẽe zi adre ɖe eŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Ekema ado go, eye wòasa nu vɔ̃ vɔsa kple ameawo ƒe gbɔ̃tsu la, eye wòahlẽ eƒe ʋu ɖe xɔmetsovɔ la me, ahlẽe ɖe amenuvevezikpui la dzi kple eŋgɔ abe ale si wòwɔ kple nyitsu la ƒe ʋu ene. ");
INSERT INTO ewe_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Ekema aɖe nu vɔ̃ ɖa le teƒe kɔkɔe la ŋu, elabena Israelviwo ƒe nu vɔ̃wo na wòzu nu makɔmakɔ, eye wòagaɖe nu vɔ̃ ɖa le Agbadɔ si le ameawo dome, eye woƒe nu vɔ̃wo ƒo xlãe la hã ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ame bubu aɖeke mekpɔ mɔ anɔ Agbadɔ la me ne Aron ge ɖe eme be yeaɖe nu vɔ̃ ɖa le Teƒe Kɔkɔe la ŋu o va se ɖe esime wòalé avu le eya ŋutɔ ɖokui, eƒe aƒemetɔwo kple Israelviwo katã ta, eye wòagado go. ");
INSERT INTO ewe_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Azɔ la, ado go ayi vɔsamlekpui la gbɔ le Yehowa ŋkume, eye wòaɖe nu vɔ̃ ɖa le eŋu. Ele be wòasisi nyitsu la kple gbɔ̃tsu la ƒe ʋu ɖe vɔsamlekpui la ƒe lãdzowo ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","eye wòahlẽ ʋu la ƒe ɖe ɖe vɔsamlekpui la dzi zi adre kple eƒe asibidɛ. Ale wòakɔ eŋuti tso Israelviwo ƒe nu vɔ̃wo me, eye wòawɔe kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Ne ewu nu vɔ̃wo ɖeɖe ɖa le Teƒe Kɔkɔe la, Agbadɔ blibo la kple vɔsamlekpui la ŋu ƒe wɔnawo nu la, ahe gbɔ̃ gbagbe si wotia na Azazel la vɛ. ");
INSERT INTO ewe_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Ada eƒe asi eveawo ɖe gbɔ̃tsu la ƒe ta dzi, eye wòaʋu Israelviwo ƒe nu vɔ̃wo katã me ɖe edzi. Adro woƒe nu vɔ̃wo katã ɖe gbɔ̃ la ƒe ta dzi, eye wòana ame aɖe si wotia da ɖi la nakplɔ gbɔ̃ la ayi ɖe gbedzi. ");
INSERT INTO ewe_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Ale gbɔ̃ la atsɔ ameawo ƒe nu vɔ̃wo katã ayi gbedadaƒo, eye ame la aɖe asi le gbɔ̃ la ŋu ɖe gbedadaƒo afi ma. ");
INSERT INTO ewe_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Azɔ la, Aron agayi Agbadɔ la me, eye wòaɖe aklalawu siwo wòdo esi wòyi xɔmetsovɔ la godo, eye wòagblẽ wo ɖe afi ma le Agbadɔ la me. ");
INSERT INTO ewe_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Esia megbe la, ale tsi le teƒe kɔkɔe aɖe, agado awuawo, ayi aɖasa eya ŋutɔ ƒe numevɔ kple ameawo ƒe numevɔ, eye wòalé avu ɖe eya ŋutɔ kple ameawo ta. ");
INSERT INTO ewe_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Ekema atɔ dzo nu vɔ̃ ŋuti vɔsalãwo ƒe ami ɖe vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Ame si kplɔ gbɔ̃tsu la yi na Azazel le gbedzi la, agbɔ ava nya eƒe awuwo, ale tsi, eye wòayi asaɖa la me. ");
INSERT INTO ewe_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Woatsɔ nyitsu kple gbɔ̃tsu si Aron tsɔ sa nu vɔ̃ vɔsa, eye wòtsɔ woƒe ʋu yi Teƒe Kɔkɔe la hena avuléle la ayi asaɖa la godo, eye woatɔ dzo wo kpe ɖe woƒe agbalẽ kple dɔmenuwo ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Emegbe la, ame si tɔ dzo lãawo la, anya eƒe awuwo, ale tsi, eye wòatrɔ ayi asaɖa la me. ");
INSERT INTO ewe_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Esia nanye ɖoɖo mavɔ na mi: le ɣleti adrelia ƒe ŋkeke ewolia dzi la, ele be miagbe nu le mia ɖokuiwo gbɔ, eye miawɔ dɔ aɖeke o, eɖanye dzɔleaƒea loo alo amedzro si le mia dome o, ");
INSERT INTO ewe_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","elabena le ŋkeke sia dzi woalé avu na mi, akɔ mia ŋuti. Ekema le Yehowa ŋkume la, mia ŋuti akɔ tso miaƒe nu vɔ̃wo katã me. ");
INSERT INTO ewe_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Enye dzudzɔgbe na mi, miawɔ ŋkeke la ŋu dɔ na nutsitsidɔ. Esia nye se mavɔ na mi. ");
INSERT INTO ewe_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Le dzidzime bubuwo ƒe ɣeyiɣiwo me la, nunɔlagã si wosi ami na, eye wokɔ eŋuti ɖe Tɔgbuia Aron teƒe lae awɔ ŋutikɔkɔ kɔnu sia. Eyae nye ame si ado aklalawu kɔkɔeawo, ");
INSERT INTO ewe_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","eye wòakɔ Teƒe Kɔkɔe la, Agbadɔ la, vɔsamlekpui la, nunɔlawo kple ameawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Esia anye se mavɔ na mi; woalé avu ɖe Israelviwo ta ƒe sia ƒe le woƒe nu vɔ̃wo ta.” Eye wowɔ abe ale si Yehowa de se na Mose ene. Eye miawɔ abe ale si Yehowa de se na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Ƒo nu na Aron kple via ŋutsuwo kple Israelviwo katã, eye nàgblɔ na wo be, ‘Esiae nye se si Yehowa de: ");
INSERT INTO ewe_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Israelvi ɖe sia ɖe si asa vɔ kple nyitsu, alẽvi alo gbɔ̃ le asaɖa la me alo egodo ");
INSERT INTO ewe_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","le esime wòatsɔe ava Mawu ƒe Agbadɔ la nu bena woasa vɔ na Yehowa le Yehowa ƒe Agbadɔ la ƒe ŋkume teƒe la, woabu ame ma be eɖi fɔ le ʋukɔkɔɖi me. Ekɔ ʋu ɖi, eye ele be woaɖee ɖa le eƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Se sia ƒe taɖodzinue nye wòana be Israelviwo magasa vɔ le gbedzi o, ke boŋ wòana be woatsɔ woƒe vɔsanuwo vɛ na nunɔla la le Agbadɔ la ƒe mɔnu, woatɔ dzo ami la abe ʋeʋẽ lĩlĩlĩ ene, wòanye nu si adze Yehowa ŋu, eye wòado dzidzɔ nɛ. ");
INSERT INTO ewe_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Nu sia wɔwɔ ana nunɔla la nate ŋu ahlẽ ʋu la ɖe Yehowa ƒe vɔsamlekpui la dzi, le Agbadɔ la ƒe mɔnu, eye wòatɔ dzo lãwo ƒe ami abe ʋeʋẽ lĩlĩlĩ ene na Yehowa. Nu sia adze Yehowa ŋu eye wòado dzidzɔ nɛ. ");
INSERT INTO ewe_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Woawɔ alea, ale be amewo masa vɔ na gbɔgbɔ vɔ̃wo le gbedzi o. Esia anye se na mi tegbetegbe tso dzidzime yi dzidzime.’ ");
INSERT INTO ewe_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Gblɔ na wo be, ‘Israelvi aɖe alo amedzro aɖe si le mia dome, ame si asa numevɔ alo vɔsa bubu aɖe, ");
INSERT INTO ewe_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","eye metsɔe va Mawu ƒe Agbadɔ la nu be wòasa vɔ la na Yehowa o la, woaɖe ame ma ɖa le eƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Mado dɔmedzoe ɖe ame sia ame, Israelvi loo alo amedzro si le mia dome, si aɖu lã aɖe ƒe ʋu la ŋu. Maɖee ɖa le eƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Esi lã aɖe ƒe agbe le eƒe ʋu me ta la, metsɔ lãwo ƒe ʋu na mi be miahlẽ ɖe vɔsamlekpui la dzi abe miaƒe luʋɔwo ŋuti kɔkɔ ene. Ʋue léa avu, elabena eyae nye agbe la. ");
INSERT INTO ewe_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Nu sia tae mede se na Israelviwo alo amedzro siwo le wo dome la be womekpɔ mɔ aɖu lã aɖeke ƒe ʋu o ɖo. ");
INSERT INTO ewe_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Ame sia ame, Israelvi loo alo amedzro si le mia dome, si yi adegbe, eye wòwu lã aɖe alo xevi aɖe, si ŋu se ɖe mɔ le be woaɖu la, ele nɛ be wòatsyɔ ʋu la akɔ ɖe anyigba, eye wòakplɔ ke atsyɔ edzi, ");
INSERT INTO ewe_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","elabena ʋue nye agbe la, eya tae megblɔ na Israelviwo be womaɖui gbeɖegbeɖe o, elabena xevi ɖe sia ɖe kple lã ɖe sia ɖe ƒe agbee nye eƒe ʋu, eya ta ele be woatsrɔ̃ ame sia ame si aɖu lã ƒe ʋu la. ");
INSERT INTO ewe_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Kpe ɖe esia ŋu la, ele na ame sia ame, Israelvi alo amedzro, si aɖu lã aɖe si ku le eɖokui si alo lã aɖe si lã lénu aɖe vuvu la, be wòanya eƒe awuwo, ale tsi, eye eƒe ŋuti mekɔ o va se ɖe fiẽ. Esia megbe la, eƒe ŋuti akɔ. ");
INSERT INTO ewe_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ke ne menya eƒe awuwo o, eye mele tsi hã o la, ekema eya ŋutɔ akpɔ eyomedzenu.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Mele be miawɔ nu abe ale si wowɔna le Egipte, afi si mienɔ la ene o. Nenema ke mele be miawɔ nu abe ale si wowɔna le Kanaan, afi si mele mia kplɔm le yiyim la ene o. Migawɔ woƒe wɔnawo o. ");
INSERT INTO ewe_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ele be miawɔ nye sewo dzi, eye miakpɔ egbɔ be yewozɔ ɖe nye ɖoɖowo nu. Nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Milé nye ɖoɖowo kple nye sewo me ɖe asi, elabena ame si léa wo me ɖe asi la, anɔ agbe ɖe wo nu. Nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Mia dometɔ aɖeke megadɔ kple eƒe ƒometɔ o, elabena nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Vinyɔnu mekpɔ mɔ aɖe fofoa o. Nenema ke viŋutsu mekpɔ mɔ aɖe dadaa loo ");
INSERT INTO ewe_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","alo fofoa srɔ̃ bubuawo dometɔ aɖeke o. ");
INSERT INTO ewe_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Gawu la, mekpɔ mɔ aɖe nɔvia nyɔnu, dadaa ƒe vinyɔnu alo fofoa ƒe vinyɔnu ne wodzi wo le aƒe ɖeka me loo alo le teƒe bubuwo o. ");
INSERT INTO ewe_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Mègade asi wò tɔgbuiyɔvi nyɔnu si nye viwò ŋutsu ƒe vi alo viwò nyɔnu ƒe vi la ŋu o, elabena woƒe amamae nye wò hã tɔ. ");
INSERT INTO ewe_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Mègade asi fofowò srɔ̃ ƒe vinyɔnu ŋu o. ");
INSERT INTO ewe_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Eye mègade asi fofowò nɔvinyɔnu hã ŋu o, elabena edo ƒome kplikplikpli kple fofowò. ");
INSERT INTO ewe_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Mègade asi dawò nɔvinyɔnu ŋu o, elabena edo ƒome kplikplikpli kple dawò. ");
INSERT INTO ewe_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Nenema ke, mègade asi fofowò nɔviŋutsu srɔ̃ ŋuti o, ne fofowò nɔviŋutsu ku alo le agbe o. ");
INSERT INTO ewe_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Mègade asi viwò ŋutsu srɔ̃ ŋu o; wò ŋutɔ viwò srɔ̃e; megaɖe amae o. ");
INSERT INTO ewe_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Megade asi nɔviwò ŋutsu srɔ̃ ŋu o, elabena nɔviwò ŋutsu ƒe amae. ");
INSERT INTO ewe_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Mègade asi nyɔnu aɖe kple via nyɔnu alo mamayɔvia ŋu o, elabena nuwɔna ma nye vɔ̃ɖivɔ̃ɖi manyagblɔ aɖe. ");
INSERT INTO ewe_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Mègaɖe nɔvinyɔnu eve o, ne menye nenema o la, woanɔ ŋui ɖom wo nɔewo. Gake ne srɔ̃wò ku la, àte ŋu aɖe nɔvia nyɔnu faa. ");
INSERT INTO ewe_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Mègade asi nyɔnu si tsi gbɔto la ŋu o, ");
INSERT INTO ewe_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Megade asi hawòvi srɔ̃ ŋu, ale be màgblẽ kɔ ɖo na ɖokuiwò kple nyɔnu la siaa o. ");
INSERT INTO ewe_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Mègatsɔ viwò aɖeke na Molek o; atsɔe asa vɔe le eƒe vɔsamlekpui dzi. Mègaƒo ɖi wò Mawu ƒe ŋkɔ o, elabena nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Se sesẽ tsi tsitre ɖe ŋutsu kple ŋutsu ƒe wo nɔewo gbɔ dɔdɔ ŋuti, elabena enye nu vɔ̃ triakɔ le Mawu gbɔ. ");
INSERT INTO ewe_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Ŋutsu aɖeke mekpɔ mɔ adɔ lãnɔ aɖeke gbɔ, eye wòaƒo ɖi eɖokui o. Nenema ke nyɔnu aɖeke mekpɔ mɔ alɔ̃ lãtsu aɖeke nayɔ asii o. Esia nye ŋukpenanu gã aɖe ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Migaƒo ɖi mia ɖokuiwo to mɔ siawo dometɔ aɖeke dzi o, elabena nu siawoe dukɔwo bubuwo wɔna. Esi wowɔa nu siawo ta la, manya wo ɖa le anyigba si dzi yim miele la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Woƒo ɖi anyigba blibo la kple nuwɔna siawo, eya ta mele to hem na ame siwo le afi ma, eye anyigba la atu edzinɔlawo aƒu gbe. ");
INSERT INTO ewe_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Ele be miazɔ ɖe nye sewo kple ɖoɖowo nu tututu, eye mele be miawɔ nu vɔ̃ siawo dometɔ aɖeke o. Ele be Israelvi dzɔleaƒeawo kple amedzro siwo le mia dome siaa la nalé se siawo me ɖe asi sesĩe. ");
INSERT INTO ewe_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ɛ̃, ame siwo le anyigba si dzi mele mia kplɔm le yiyim dzi la wɔa nu vɔ̃ siawo madzudzɔmadzudzɔe ale gbegbe be anyigba blibo la gblẽ. ");
INSERT INTO ewe_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Migawɔ nu siawo o. Ne miewɔ nu siawo la, anyigba la atu mi aƒu gbe abe ale si wòatu dukɔ siwo le afi ma fifia la aƒu gbe ene. ");
INSERT INTO ewe_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Ame sia ame si awɔ ŋunyɔnu siawo dometɔ aɖe la, woaɖe ame ma ɖa le eƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Milé nye ɖoɖowo me ɖe asi, migadze kɔnu nyɔŋu siwo wowɔna hafi mieva la yome o, eye migatsɔ wo do gu mia ɖokuiwo o. Nyee nye Yehowa, miaƒe Mawu.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Ƒo nu na Israel ƒe ƒuƒoƒo blibo la, eye nàgblɔ na wo be, ‘Minɔ kɔkɔe, elabena nye, Yehowa, miaƒe Mawu, mele kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Ele be mia dometɔ ɖe sia ɖe nabu fofoa kple dadaa, eye miaɖo ŋku nye Dzudzɔgbewo dzi. Nyee nye Yehowa miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Migatrɔ ɖe legbawo ŋu alo miatsɔ ga awɔ mawuwo na mia ɖokuiwo o. Nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Ne miesa akpedavɔ na Yehowa la, misae tututu ɖe sea nu ale be mate ŋu axɔe. ");
INSERT INTO ewe_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Miɖui le ŋkeke si dzi miesa vɔ la le alo ne ŋu ke. Nu si atsi anyi va se ɖe ŋkeke etɔ̃a gbe la, woatɔ dzoe, ");
INSERT INTO ewe_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","elabena esi woaɖu le ŋkeke etɔ̃a gbe la, madze ŋunye o, eye nyemate ŋu axɔe o. ");
INSERT INTO ewe_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Ne mieɖui le ŋkeke etɔ̃a gbe la, mieɖi fɔ, elabena miedo ŋunyɔ Yehowa ƒe kɔkɔenyenye, eye woaɖe mi ɖa tso Yehowa ƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Ne miexa miaƒe agblemenuwo la, migaŋe nuku siwo le agblea to o, eye migafɔ nuku siwo dudu ɖe anyigba hã o. ");
INSERT INTO ewe_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Miwɔ nenema ke le miaƒe wain tsetsewo hã gome. Migagbe kutsetseawo katã o, eye migafɔ esiwo ge ɖe anyigba hã o. Migblẽ wo ɖi na ame dahewo kple amedzro siwo le mia dome, elabena nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Migafi fi o. “ ‘Migada alakpa o. “ ‘Ame aɖeke megaba nɔvia o. ");
INSERT INTO ewe_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Migatsɔ nye ŋkɔ aka atam ɖe aʋatsonya aɖeke dzi, eye miato nu sia wɔwɔ me aƒo fi ade nye ŋkɔ o, elabena nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Migaba ame aɖeke alo ate ame aɖeke ɖe to o. “ ‘Mikpɔ egbɔ be yewoxe fe na yewoƒe agbatedɔwɔlawo kaba. Ne fe aɖe li miaxe na agbatedɔwɔlawo la, migana fe ma natsi mia ŋuti ŋu nake ɖe edzi o. ");
INSERT INTO ewe_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Migaƒo fi de tekunɔ o, eye migada nu ɖe ŋkuagbãtɔ si va yina la ƒe mɔ me o. Mivɔ̃ miaƒe Mawu. Nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Ele be ʋɔnudrɔ̃lawo nafia dzɔdzɔenyenye le woƒe nyametsotsowo me, eye womakpɔ ame aɖeke ƒe ahedada alo hotsuikpɔkpɔ dzi ɖa o. Ele be woawɔ nuteƒe ɣe sia ɣi. ");
INSERT INTO ewe_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Mèganye sakplisala anɔ yiyim le wò dukɔ me o. “ ‘Mègade nɔviwò asi be woatso kufia nɛ o, elabena nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Mègalé fu nɔviwò o. Ka mo na ame si wɔ nu vɔ̃. Ne ègbe mokaka nɛ la, wò hã èwɔ nu vɔ̃ abe eya ke ene. ");
INSERT INTO ewe_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Mègabia hlɔ̃ o. Mègalé nya ɖe dɔ me o, ke boŋ lɔ̃ nɔviwò abe ɖokuiwò ene, elabena nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Miwɔ nye seawo dzi. “ ‘Migana lã nayɔ asi lã ƒomevi bubu o. “ ‘Mègaƒã nuku ƒomevi vovovowo ɖe wò agble me o. “ ‘Mègado awu si wotɔ kple avɔ si wotsɔ lãfu tsaka ɖeti lɔ̃ la o. ");
INSERT INTO ewe_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Ne ŋutsu aɖe de asi kosi si menye ablɔɖeme o ŋu, eye wòbia eta na ɖeɖe la, woadrɔ̃ ʋɔnu wo le ʋɔnudrɔ̃ƒe, gake womawu wo o, elabena kosi la menye ablɔɖeme o. ");
INSERT INTO ewe_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Ele be ŋutsu la natsɔ eƒe fɔɖivɔsa vɛ na Yehowa le Agbadɔ la ƒe mɔnu. Nu si wòanae nye agbo. ");
INSERT INTO ewe_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Nunɔla la alé avu kple agbo la le nu vɔ̃ si ŋutsu la wɔ ta, eye woatsɔe akee. ");
INSERT INTO ewe_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Ne mieva ɖo anyigba la dzi, eye miedo kutsetseti ƒomevi vovovowo la, migaɖu ƒe gbãtɔ etɔ̃awo ƒe tsetseawo o, elabena wole abe nu siwo ŋu wogbe nu le ene. Womaɖu wo o. ");
INSERT INTO ewe_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Woatsɔ ƒe enelia ƒe kutsetsewo katã ana Yehowa abe eƒe kafukafunu ene. ");
INSERT INTO ewe_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ƒe atɔ̃lia ƒe kutsetsewoe nye mia tɔ. Nyee nye Yehowa miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Migaɖu lã si me ʋu metsyɔ le la o. “ ‘Migaka afa alo miawɔ adze o. ");
INSERT INTO ewe_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Mègalũ wò loglo o, eye mègafɔ wò ge dzi hã o. ");
INSERT INTO ewe_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Migasi mia ɖokuiwo alo miasi ame aɖe ŋuti le tsyɔ̃wɔwɔ me o. Nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Mègagblẽ viwò ɖetugbi ƒe dzadzɛnyenye me to ewɔwɔ gboloe me o. Ne menye nenema o la, anyigba la azu gbolonyigba, eye ŋukpenanuwo anɔ edzi. ");
INSERT INTO ewe_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Milé se si ku ɖe nye Dzudzɔgbe ŋuti la me ɖe asi, eye miade bubu nye Agbadɔ la ŋu, elabena nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Migaƒo ɖi mia ɖokuiwo to ŋɔliyɔlawo kple bokɔnɔwo gbɔ dede me o, elabena nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Ele be miatsɔ bubu kple sisiɖa si dze la na ame tsitsiwo le Mawuvɔvɔ̃ ta. Nyee nye Yehowa! ");
INSERT INTO ewe_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Migate amedzro siwo le miaƒe anyigba dzi la ɖe to o, eye migaba wo o. ");
INSERT INTO ewe_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ele be mialé be na wo abe mia ɖokuiwo ene, eye miaɖo ŋku edzi be miawo hã mienye amedzrowo kpɔ le Egiptenyigba dzi. Nyee nye Yehowa, miaƒe Mawu! ");
INSERT INTO ewe_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Migawɔ dzidzenu mademadewo ŋu dɔ ne miele didime, kpekpeme kple agbɔsɔsɔ dzidzem o. ");
INSERT INTO ewe_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Miwɔ nudanu kple nudakpe anukwaretɔwo, nudanu kple nudzidzenu anukwaretɔwo ŋu dɔ. Nyee nye Yehowa, miaƒe Mawu, ame si ɖe mi tso Egipte. ");
INSERT INTO ewe_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Ele be mialé nye sewo kple ɖoɖowo katã me ɖe asi, eye miawɔ wo dzi, elabena nyee nye Yehowa!’ ” ");
INSERT INTO ewe_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Gblɔ na Israelviwo be, ‘Ele be woawu Israelvi alo amedzro si le Israel, ame si atsɔ viawo dometɔ aɖe ana Molek. Teƒe ma nɔlawo naƒu kpee. ");
INSERT INTO ewe_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Emegbe nye ŋutɔ mado dɔmedzoe ɖe eŋu, eye maɖee ɖa le eƒe amewo dome, elabena etsɔ via sa vɔe na Molek, eto esia me wɔ nye Agbadɔ wòzu teƒe si medze be maganɔ o, eye wòdo vlo nye ŋkɔ kɔkɔe la. ");
INSERT INTO ewe_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ne anyigba la dzi tɔwo wɔ abe ɖe womenya naneke tso ame si tsɔ via na Molek ŋu o, eye wogbe be yewomawui o la, ");
INSERT INTO ewe_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ekema nye ŋutɔ mado dɔmedzoe ɖe amea kple eƒe ƒometɔwo ŋu, eye matsrɔ̃ ame siwo katã subɔa Molek alo mawu bubuwo. ");
INSERT INTO ewe_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Maɖe ŋku atɔ ame sia ame si adze ŋɔliyɔlawo kple bokɔnɔwo yome, eye madze nye boŋ yome o; matsrɔ̃e ɖa le eƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Eya ta mikɔ mia ɖokuiwo ŋu, eye mianɔ kɔkɔe, elabena nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Miwɔ nye seawo katã dzi, elabena nyee nye Yehowa, ame si kɔa mia ŋuti. ");
INSERT INTO ewe_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Ame sia ame si aƒo fi ade fofoa alo dadaa la, ele be woawui kokoko, elabena eƒo fi de eya ŋutɔ ƒe ŋutilã kple ʋu. ");
INSERT INTO ewe_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Ne ŋutsu aɖe wɔ ahasi kple ehavi srɔ̃ la, ele be woawu ŋutsu ahasiwɔla la kple nyɔnu ahasiwɔla la siaa. ");
INSERT INTO ewe_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Ne ŋutsu aɖe dɔ fofoa srɔ̃ gbɔ la, eɖe fofoa ƒe amama ɖe go. Ele be woawu ŋutsu la kple nyɔnu la siaa, elabena woawo ŋutɔe di ku na wo ɖokui. ");
INSERT INTO ewe_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Ne ŋutsu aɖe dɔ toyɔvia gbɔ la, woawu wo ame eve la siaa; woawo ŋutɔe di ku na wo ɖokui to ɖiƒoƒo wo nɔewo me. ");
INSERT INTO ewe_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Tohehe si woana ŋutsu eve siwo dɔ wo nɔewo gbɔe nye woawu wo ame eve la. Woawo ŋutɔe di ku na wo ɖokui. ");
INSERT INTO ewe_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Ŋutsu si dɔ nyɔnu aɖe kple nyɔnu la dada gbɔ la, wɔ nu vɔ̃ triakɔ aɖe. Woatɔ dzo wo ame etɔ̃ la katã agbagbee be wòaɖe ŋukpenanu vɔ̃ɖi sia ɖa le mia dome. ");
INSERT INTO ewe_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Ne ŋutsu aɖe de asi lãnɔ aɖe ŋu la, ele be woawu ŋutsu la kple lãnɔ la siaa, elabena woƒe ʋu anɔ woawo ŋutɔ ƒe ta dzi. ");
INSERT INTO ewe_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Ne nyɔnu aɖe na lã aɖe de asi eŋu la, ele be woawu nyɔnu la kple lã la siaa, elabena tohehe mae dze na wo. ");
INSERT INTO ewe_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Ne ŋutsu aɖe de asi nɔvia nyɔnu, eɖanye fofoa ƒe vinyɔnu alo dadaa ƒe vinyɔnu ŋu la, enye ŋukpenanu, eye ele be woatsrɔ̃ wo ame eve la ɖa tso Israelviwo dome. Fɔɖiɖi la anɔ ŋutsu la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Ne ŋutsu aɖe dɔ nyɔnu aɖe si tsi gbɔto gbɔ la, woatsrɔ̃ wo ame eve la, elabena ŋutsu la ɖe nyɔnu la ƒe makɔmakɔnyenye ɖe go. ");
INSERT INTO ewe_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Ŋutsu aɖeke made asi fofoa nɔvinyɔnu alo dadaa nɔvinyɔnu ŋu o, elabena ƒometɔ tututu wonye na wo nɔewo. Woƒe fɔɖiɖi anɔ woawo ŋutɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Ne ŋutsu aɖe de asi fofoa nɔviŋutsu srɔ̃ alo dadaa nɔviŋutsu srɔ̃ ŋu la, ekema eɖe fofoa nɔviŋutsu alo dadaa nɔviŋutsu la ƒe amama ɖe go. Woƒe tohehee nye woƒe nu vɔ̃ anɔ woƒe ta dzi, eye woatsi ko va se ɖe woƒe kugbe. ");
INSERT INTO ewe_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Ne ŋutsu aɖe de asi nɔvia ŋutsu srɔ̃ ŋuti la, ewɔ nu makɔmakɔ, elabena eɖe nɔvia ŋutsu la ƒe amama ɖe go. Woatsi ko va se ɖe woƒe kugbe. ");
INSERT INTO ewe_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Eya ta miwɔ nye seawo kple nye ɖoɖowo katã dzi, ale be anyigba si metsɔ na mi la matu mi aƒu gbe o. ");
INSERT INTO ewe_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Migawɔ dukɔ siwo manya ɖa le mia ŋgɔ la ƒe kɔnuwo o, elabena nu tovo siwo katã ŋu mede se na mi le la, woawoe wowɔna. Nu sia tae melé fu wo ɖo. ");
INSERT INTO ewe_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Medo woƒe anyigba ŋugbe na mi. Matsɔe na mi wòazu mia tɔ. Enye anyigba aɖe si dzi notsi kple anyitsi bɔ ɖo. Nyee nye Yehowa, miaƒe Mawu la, ame si de vovototo miawo kple dukɔ bubuwo ƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Eya ta ele be miade vovototo xe kple lã siwo meɖe mɔ na mi be miaɖu kple esiwo mebe migaɖu o la dome. Migaƒo ɖi mia ɖokui, eye miana magbe nu le mia gbɔ to miaƒe lã kple xe siwo mede se na mi be migaɖu o la ɖuɖu me o, togbɔ be wobɔ ɖe anyigba la dzi fũu hã. ");
INSERT INTO ewe_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ele be mianye ame kɔkɔewo nam, elabena nye Yehowa la, kɔkɔetɔe menye, eye meɖe mi ɖe aga tso dukɔ bubuwo me tɔwo katã gbɔ be mianye tɔnyewo. ");
INSERT INTO ewe_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Ele kokoko be woaƒu kpe ŋɔliyɔlawo alo bokɔwo, woɖanye ŋutsuwo alo nyɔnuwo o, woaku. Woawo ŋutɔe di ku na wo ɖokui.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yehowa gblɔ na Mose be, “Gblɔ na Aron ƒe vi nunɔlawo be, ‘Mele be nunɔla naƒo ɖi eɖokui to asikaka ame kukuwo ŋu me o, ");
INSERT INTO ewe_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","negbe eƒe ƒometɔ kekeake ko, abe dadaa alo fofoa, Via ŋutsu alo via nyɔnu, nɔvia ŋutsu, ");
INSERT INTO ewe_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","alo nɔvia nyɔnu si meɖe srɔ̃ haɖe o, eye wòle eƒe dzikpɔkpɔ te, esi srɔ̃ mele esi o ta ene. Ate ŋu agblẽ kɔ na eɖokui le nɔvia nyɔnu sia ta. ");
INSERT INTO ewe_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Ele be wòanɔ alea, elabena nunɔla nye kplɔla le ameawo dome, eye mele be wòaƒo ɖi eɖokui abe ame bubu siwo menye nunɔlawo ene o. ");
INSERT INTO ewe_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Nunɔla aɖeke mekpɔ mɔ aƒlɔ eƒe ta alo afɔ eƒe ge dzi alo asi eƒe ŋutigbalẽ o. ");
INSERT INTO ewe_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ele be woanɔ kɔkɔe na woƒe Mawu, eye womado vlo woƒe Mawu la ƒe ŋkɔ o. Esi wònye be woawoe tsɔa dzovɔsa vɛ na Yehowa, nu si nye woƒe Mawu ƒe nuɖuɖu ta la, ele na wo be woanɔ kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Mele be nunɔla naɖe gbolo alo nyɔnu si gbe atsu o, elabena nunɔlawo le kɔkɔe na woƒe Mawu la. ");
INSERT INTO ewe_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Mibu wo be wole kɔkɔe, elabena woawoe tsɔa miaƒe Mawu la ƒe Nuɖuɖunana. Mibu wo kɔkɔe, elabena nye Yehowa mele kɔkɔe, nye ame si wɔ mi miele kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ne nunɔla aɖe ƒe vinyɔnu gblẽ kɔ ɖo na eɖokui hetrɔ zu gbolo la, edo ŋukpe fofoa, ele be woatɔ dzoe agbagbe. ");
INSERT INTO ewe_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Nunɔlagã la, ame si wosi ami ɖe ta na le nɔvia ŋutsuwo dome, eye woɖoe nunɔlae be wòado nunɔlawu la, mele be wòakaka ɖa ɖe ta alo adze awu le eɖokui ŋu o. ");
INSERT INTO ewe_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Mekpɔ mɔ age ɖe teƒe si ame kuku le o. Mekpɔ mɔ hã be wòagblẽ kɔ ɖo na eɖokui, na fofoa alo dadaa gɔ̃ hã o. ");
INSERT INTO ewe_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Mekpɔ mɔ agblẽ eƒe Mawu la ƒe kɔkɔeƒe ɖi alo ado gui o, elabena wokɔ eya amea ŋuti kple eƒe Mawu la ƒe ami kɔkɔe; nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Ele be wòaɖe ɖetugbivi dzadzɛ aɖe. ");
INSERT INTO ewe_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Maɖe ahosi alo nyɔnu si gbe atsu alo nyɔnu si atsu gbe loo alo gbolo o. Ele be wòaɖe ɖetugbi dzadzɛ tso eya ŋutɔ ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","elabena mele be wòanye fofo na ɖevi siwo nyɔnu si wòɖe la kplɔ va atsuƒee o; nu sia aɖi gbɔ̃ eya ŋutɔ ƒe viwo le eƒe amewo dome, elabena nyee nye Yehowa, ame si wɔe kɔkɔe.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Gblɔ na Aron be, ‘Le dzidzime siwo gbɔna me la, nuwɔametɔ aɖeke mekpɔ mɔ ate va be yeatsɔ eƒe Mawu ƒe nuɖuɖu asa vɔ̃e o. ");
INSERT INTO ewe_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Manye le kpɔɖeŋu me, ame si nye ŋkuagbãtɔ alo xɔdrɔ̃, ame si ƒe ŋɔti gbã alo ame si to asibidɛ ade alo afɔbidɛ ade, ");
INSERT INTO ewe_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","alo wòŋe ata alo abɔ ");
INSERT INTO ewe_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","alo wòɖo kpo alo wònye ame kpui zegede alo tasi le ŋku dzi nɛ, wòdze akpa alo wòɖo vo o. ");
INSERT INTO ewe_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Ne amea nye Aron ƒe dzidzimevi hã la, womeɖe mɔ nɛ be wòawɔ dzovɔsa aɖeke na Yehowa o, le eƒe nuwɔametɔnyenye ta. Womaɖe mɔ nɛ be wòawɔ vɔsa aɖeke na Mawu o. ");
INSERT INTO ewe_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ke ekpɔ mɔ aɖu nunɔlawo ƒe nu tso vɔ siwo wosa na Mawu la me, tso vɔsa kɔkɔewo kple vɔsa kɔkɔetɔwo kekeake me, ");
INSERT INTO ewe_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","gake mekpɔ mɔ ayi xɔmetsovɔ la godo alo ate ɖe vɔsamlekpui la ŋu o, le eƒe nuwɔametɔnyenye ta, ale be magaƒo ɖi nye teƒe kɔkɔe la o, elabena Yehowae kɔ eŋuti.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Ale Mose de se siawo na Aron kple via ŋutsuwo kple Israelviwo katã. ");
INSERT INTO ewe_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yehowa gblɔ na Mose bena, ");
INSERT INTO ewe_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Gblɔ na Aron kple via ŋutsuwo be woade bubu vɔsa kɔkɔe siwo ŋu Israelviwo kɔ nam la ŋu, ale be womaƒo ɖi nye ŋkɔ kɔkɔe la o. Nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Tso azɔ dzi yi mavɔmavɔ me la, ne nunɔla aɖe si ŋu mekɔ o, tsɔ lã siwo amewo tsɔ va sa vɔe alo ka asi nu si Israelviwo tsɔ vɛ na Yehowa ŋu la, woaɖe nunɔlanyenye la le edzi, elabena nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Ne Aron viwo dometɔ aɖe nye kpodɔléla alo dze abi si le tsi tsyɔm la, mekpɔ mɔ aɖu vɔsanu kɔkɔewo o va se ɖe esime eƒe lãme nasẽ. Ne nunɔla aɖe ka asi ame kuku aɖe ŋu alo ŋutsu si nye tsi, eye eŋu mekɔ o ŋu, ");
INSERT INTO ewe_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","alo wòka asi lã tata alo lã makɔmakɔ aɖe ŋu alo wòka asi ame si ŋuti mekɔ o le nane ta la, ");
INSERT INTO ewe_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","nunɔla ma ŋu mekɔ o va se ɖe fiẽ, eye maɖu vɔsanu kɔkɔe aɖeke o va se ɖe esime wòale tsi le fiẽ hafi. ");
INSERT INTO ewe_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ne ɣe ɖo to la, ekema eŋu akɔ, eye wòate ŋu aɖu nu kɔkɔe la azɔ, elabena eya dzie wòanɔ agbe ɖo. ");
INSERT INTO ewe_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Mekpɔ mɔ aɖu lã aɖeke si ku le eɖokui si alo lã si lã wɔadã aɖe vuvu o, elabena nu sia ana wòagblẽ kɔ ɖo na eɖokui. Nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Gblɔ na nunɔlawo be woawɔ se siawo dzi nyuie, ne menye nenema o la, woaɖi fɔ, eye woaku le se siawo dzi dada ta. Nyee nye Yehowa, ame si kɔ wo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Ame si menye nunɔla o la mekpɔ mɔ aɖu vɔsanu kɔkɔe la o. Nunɔla ƒe amedzro alo agbatedɔwɔla mekpɔ mɔ aɖu nu sia o. ");
INSERT INTO ewe_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Ke ame bubu siwo ate ŋu aɖui koe nye kluvi si nunɔla aɖe ƒle kple eya ŋutɔ ƒe ga kple vi siwo kluvi la dzi le nunɔla la ƒe aƒe me. ");
INSERT INTO ewe_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Ne nunɔla aɖe ƒe vinyɔnu ɖe srɔ̃ tso to bubu me la, mekpɔ mɔ aɖu nu kɔkɔe la o. ");
INSERT INTO ewe_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Ke ne enye ahosi alo eƒe srɔ̃ɖeɖe me gblẽ, viŋutsu aɖeke mele esi akpɔ edzi o, eye wògatrɔ va fofoa ƒe aƒe me la, ekema agate ŋu akpɔ gome le fofoa ƒe nuɖuɖu me. Le ame siawo megbe la, ame siwo mele nunɔlawo ƒe ƒomewo me o la mekpɔ mɔ aɖu nu sia o. ");
INSERT INTO ewe_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Ne amedzro aɖe ɖu nu kɔkɔe la le ŋuɖeɖi me la, axe nu si wòɖu la ƒe fe na nunɔla, eye wòatsɔ home la ƒe memama atɔ̃lia ƒe ɖeka akpe ɖe eŋu, ");
INSERT INTO ewe_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","elabena ame siwo mekpɔ mɔ aɖu vɔsanu kɔkɔe la o la magblẽ kɔ ɖo na vɔsanu kɔkɔe siwo Israelviwo tsɔ vɛ la o, elabena Yehowae wotsɔ vɔsanu siawo vɛ na. ");
INSERT INTO ewe_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Ne ame aɖe da le se sia dzi la, eɖi fɔ, eye wòde eɖokui dzɔgbevɔ̃e gã aɖe me, elabena eɖu nunana kɔkɔe la, elabena nyee nye Yehowa, ame si kɔa nunanawo ŋuti.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Ƒo nu na Aron kple via ŋutsuwo kple Israelviwo katã, eye nàgblɔ na wo be, ‘Ne mia dometɔ aɖe, dzɔleaƒea alo amedzro si le Isreal sa numevɔ na Yehowa abe adzɔgbeɖefexexe ene loo alo nunana le lɔlɔ̃nu ene la, ");
INSERT INTO ewe_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Yehowa axɔe, ne enye lãtsu si de blibo, eye wònye nyitsuvi fɛ̃ alo alẽ alo gbɔ̃. ");
INSERT INTO ewe_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Mele be woana nu si ŋu kpɔtsɔtsɔ aɖeke le la o, elabena Mawu maxɔe o. ");
INSERT INTO ewe_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Ne ame aɖe be yeasa akpedavɔ na Yehowa tso eƒe lãhawo me, abe adzɔgbeɖefexexe ene loo alo abe nu si tso eƒe dzi me nana ko ene la, ele be wòana lã aɖe si de blibo. Ne mele alea o la, Yehowa maxɔ eƒe nunana la o. ");
INSERT INTO ewe_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Womatsɔ lã si nye ŋkuagbãtɔ alo lã si afi aɖe gblẽ na alo lã si dze abi alo akpa alo le ŋutigbalẽmedɔ bubu aɖe lém la vɛ na Yehowa o. Medze na numevɔsa le Yehowa ƒe vɔsamlekpui la dzi o. ");
INSERT INTO ewe_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ne nane de gbɔ edzi alo nane mede tututu o le nyitsu alo alẽ si wotsɔ vɛ ƒe ŋutilã ŋu la, woate ŋu anae abe lɔlɔ̃nununana ene, ke menye hena adzɔgbeɖefexexe o. ");
INSERT INTO ewe_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Womatsɔ lã si nuvevi wɔ voku na alo lã si wota la ana Yehowa ɣe aɖeke ɣi o. ");
INSERT INTO ewe_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Amedzro siwo le mia dome kple Israelviwo siaa woawɔ se siawo dzi le vɔsanuwo nana me, elabena Mawu maxɔ lã si ŋu nane gblẽ le la na vɔsa sia o.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Ne wodzi nyivi alo alẽvi alo gbɔ̃vi aɖe la, woana wòanɔ dadaa gbɔ ŋkeke adre. Tso ŋkeke enyilia dzi la, woaxɔe abe dzovɔsa ene na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Mègawu nyi alo alẽ kple via le ŋkeke ɖeka dzi o. ");
INSERT INTO ewe_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Ne èsa akpedavɔ na Yehowa la, sae ale be woate ŋu axɔe na wò. ");
INSERT INTO ewe_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ele be woaɖui gbe ma gbe ke; mègagblẽ eƒe ɖeke ɖi va se ɖe ŋdi o. Nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ele be mialé nye seawo me ɖe asi, eye miawɔ wo dzi. Nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Migaƒo ɖi nye ŋkɔ kɔkɔe la o. Ele be Israelviwo nabum ame kɔkɔe. Nyee nye Yehowa, ame si wɔ mi kɔkɔe, ");
INSERT INTO ewe_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","eye mekplɔ mi tso Egipte be manye miaƒe Mawu. Nyee nye Yehowa.” ");
INSERT INTO ewe_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Esiawoe nye nye ŋkekenyui ɖoɖiwo, Yehowa ƒe ŋkekenyui ɖoɖi siwo miaɖe gbeƒãe abe takpekpe kɔkɔewo ene. ");
INSERT INTO ewe_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Esiawo akpe ɖe miaƒe dzudzɔgbewo ŋuti, dzudzɔgbe siawoe nye kɔsiɖa la ƒe ŋkeke adrea gbe, eye wònye ŋkeke siwo dzi miadzudzɔ le ɣe sia ɣi le miaƒe aƒewo me; miakpe ta asubɔm, eye miadzudzɔ tso miaƒe gbe sia gbe dɔwo wɔwɔ me. ");
INSERT INTO ewe_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Esiawoe nye Yehowa ƒe ŋkeke kɔkɔe ɖoanyiawo, takpekpe kɔkɔe siwo miayɔ le ɣeyiɣi ɖoɖiawo dzi. ");
INSERT INTO ewe_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Yehowa Ƒe Ŋutitotoŋkekenyui la adze egɔme le ɣleti gbãtɔ ƒe ŋkeke wuienea gbe le fiẽ. ");
INSERT INTO ewe_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“ ‘Le ɣleti gbãtɔ ma ke ƒe ŋkeke wuiatɔ̃a gbe la, Yehowa ƒe Abolo Maʋamaʋã ƒe Ŋkekenyui adze egɔme. Hena ŋkeke adre la, miaɖu abolo si me womede amɔʋãtike o. ");
INSERT INTO ewe_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Le ŋkekenyui sia ƒe ŋkeke gbãtɔ dzi la, àƒo ameawo nu ƒu hena mawusubɔsubɔ, eye miawɔ dɔ aɖeke o. ");
INSERT INTO ewe_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Hena ŋkeke adre la, miawɔ dzovɔsa na Yehowa, eye le ŋkeke adrelia dzi la, yɔ takpekpe kɔkɔe, eye miawɔ dɔ aɖeke le ŋkeke la dzi o.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Ne mieɖo anyigba si mele mia na ge dzi, eye miexa nukuwo la, mitsɔ lu babla gbãtɔ vɛ na nunɔla la. ");
INSERT INTO ewe_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Ele be wòanye lu babla la le yame le Yehowa ŋkume, ale be wòaxɔe na mi. Nunɔla la anyee le Yehowa ŋkume le Dzudzɔgbe la ƒe ŋufɔke. ");
INSERT INTO ewe_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Gbe ma gbe ke miatsɔ alẽvi si xɔ ƒe ɖeka, eye wòle blibo la asa numevɔe na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Miatsɔ wɔ memee kilogram eve si woblu kple ami la asa numevɔ na Yehowa, eye wòanye ʋeʋẽ lĩlĩlĩ nɛ. Emegbe la, miatsɔ wain lita ɖeka asa nunovɔ. ");
INSERT INTO ewe_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Miekpɔ mɔ aɖu abolo aɖeke, bli tɔtɔe alo bli yeye aɖeke o va se ɖe ŋkeke si dzi miawɔ vɔsa sia na miaƒe Mawu la. Esia anye ɖoɖo mavɔ na mi hena dzidzime siwo ava dzɔ le afi sia afi si mianɔ la. ");
INSERT INTO ewe_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Tso Dzudzɔgbe la ƒe ŋufɔke, gbe si gbe mietsɔ lu babla gbãtɔ vɛ, eye mienyee le yame la, xlẽ kɔsiɖa blibo adre. ");
INSERT INTO ewe_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Xlẽ ŋkeke blaatɔ̃ va se ɖe ŋkeke si dze Dzudzɔgbe adrelia dzi, eye miasa vɔ kple nuŋeŋe yeyewo na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Nunana sia anye abolo eve tso miaƒe aƒewo me, eye woanye wo le yame le Yehowa ŋkume abe wo tsɔtsɔ nɛ ƒe dzesi ene. Mitsɔ wɔ memee si ʋã la kilogram eve wɔ abolo siawo. Nunana sia nye miaƒe kutsetse gbãtɔwo na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Kpe ɖe abolo kple wain ŋuti la, miatsɔ alẽvi adre siwo xɔ ƒe ɖeka, nyitsu fɛ̃ ɖeka kple agbo eve siwo de blibo la asa numevɔ na Yehowa. Wo katã nye dzovɔsawo eye wonye ʋeʋẽ lĩlĩlĩ na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Emegbe la, miatsɔ gbɔ̃tsu ɖeka asa nu vɔ̃ vɔsa, eye miatsɔ alẽvi eve siwo xɔ ƒe ɖeka la asa akpedavɔe. ");
INSERT INTO ewe_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Nunɔla la anye nunana siawo le yame le Yehowa ŋkume hekpe ɖe nu gbãtɔwo ƒe abolo ŋu, kpakple alẽvi eveawo siwo nye nu kɔkɔewo na Yehowa, eye woatsɔ wo ana nunɔlawo abe woƒe nuɖuɖu ene. ");
INSERT INTO ewe_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Woaɖe gbeƒã ŋkeke ma abe amewo katã ƒe takpekpe kɔkɔe ƒe ɣeyiɣi ene. Migawɔ dɔ aɖeke le ŋkeke ma dzi o. Esia nye se si dzi woawɔ tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Ne miexa miaƒe nukuwo la, mele be miaŋe nu sia nu va se ɖe boto ke o, eye mele be miafɔ nukui siwo dudu ɖe anyigba o. Migblẽ wo ɖi na ame dahewo kple amedzro siwo le mia dome, ame siwo si anyigba mele o. Nyee nye Yehowa, miaƒe Mawu.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Yehowa gblɔ na Mose bena, ");
INSERT INTO ewe_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Gblɔ na Israelviwo be, ‘Le ɣleti adrelia ƒe ŋkeke gbãtɔ dzi la, ele be miadzudzɔ mia ɖokui, wòanye takpekpe kɔkɔe si dzi woaɖo ŋkui kple kpẽkuku. ");
INSERT INTO ewe_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Migawɔ gbe sia gbe dɔwo o, ke boŋ misa dzovɔ na Yehowa.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Ɣleti adrelia ƒe ŋkeke gbãtɔ nye Avuléŋkekenyui la. Miwɔ takpekpe kɔkɔe, miatsi nu adɔ, eye miasa dzovɔ na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Migawɔ dɔ aɖeke gbe ma gbe o, elabena enye avuléŋkeke tɔxɛ le Yehowa, miaƒe Mawu la ŋkume. ");
INSERT INTO ewe_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Ne ame aɖe mewɔ ŋkeke sia ŋu dɔ hena dzimetɔtrɔ kple konyifafa ɖe eƒe nu vɔ̃wo ta o la, woatsrɔ̃e ɖa le eƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Matsrɔ̃ ame sia ame si awɔ dɔ aɖe gbe ma gbe la tso eƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Miawɔ dɔ aɖeke kura o. Ele be esia nanye ɖoɖo mavɔ na dzidzime siwo ava va le afi si mianɔ. ");
INSERT INTO ewe_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ŋkeke sia nye dzudzɔgbe; miabɔbɔ mia ɖokui, eye miase veve ɖe miaƒe nu vɔ̃wo ta. Avuléɣeyiɣi sia adze egɔme tso fiẽ si do ŋgɔ na Avuléŋkekenyui la, eye wòayi edzi va se ɖe ŋkekenyui la ƒe fiẽ.” ");
INSERT INTO ewe_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Yehowa gblɔ na Mose bena, ");
INSERT INTO ewe_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Gblɔ na Israelviwo be, ‘Le ɣleti adrelia ƒe ŋkeke wuiatɔ̃lia dzi la, Yehowa ƒe Agbadɔmeŋkekenyui la adze egɔme eye woaɖui ŋkeke adre. ");
INSERT INTO ewe_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Ameawo katã awɔ takpekpe kɔkɔe le ŋkeke gbãtɔ dzi. Migawɔ dɔ sesẽ aɖeke gbe ma gbe o. ");
INSERT INTO ewe_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Le ŋkekenyui la ƒe ŋkeke adreawo dometɔ ɖe sia ɖe dzi la, ele be miasa dzovɔ na Yehowa. Ameawo katã agawɔ takpekpe kɔkɔe bubu le ŋkeke enyia gbe. Woagasa dzovɔ na Yehowa gbe ma gbe. Enye dzidzɔɣeyiɣi aɖe, eye womeɖe mɔ be woawɔ dɔ sesẽ aɖeke o.’ ");
INSERT INTO ewe_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","(“ ‘Esiawoe nye ŋkekenyui siwo miaɖu atsɔ de bubu Yehowa ŋu; ameawo katã awɔ takpekpe kɔkɔewo, eye woasa dzovɔwo, numevɔ, nuɖuvɔ, akpedavɔ kple nunovɔ na Yehowa. Ŋkeke ɖe sia ɖe kple etɔ ");
INSERT INTO ewe_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Ƒe sia ƒe ƒe ŋkekenyui siawo kpe ɖe kɔsiɖa ɖe sia ɖe ƒe Dzudzɔgbe ŋu. Vɔ siwo woasa le ŋkekenyui siawo dzi la akpe ɖe miaƒe ɣe sia ɣi ƒe nunanawo kple adzɔgbeɖefewo ŋu.) ");
INSERT INTO ewe_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Anyɔnyɔ ƒe ŋkeke mamlɛtɔ sia, si le miaƒe nuŋeɣi ƒe nuwuwu lae nye ɣeyiɣi si dzi miaɖu ŋkekenyui sia ŋkeke adre le Yehowa ŋkume. Miɖo ŋku edzi be ŋkeke gbãtɔ kple mamlɛtɔ nye dzudzɔgbe kɔkɔewo. ");
INSERT INTO ewe_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Le ŋkeke gbãtɔ dzi la, mitsɔ kutsetseti ƒe alɔ siwo dzi kutsetsewo le kple deʋaya kple atilɔ siwo do abe amiti siwo le tɔʋuwo to ene; mitsɔ wo tu agbadɔwo. Mitso aseye le Yehowa miaƒe Mawu ŋkume ŋkeke adre sɔŋ. ");
INSERT INTO ewe_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Ŋkekenyui sia, si woaɖu na Yehowa ŋkeke adre, ƒe sia ƒe la, nye se tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Le ŋkeke adre mawo me la, ele be mi ame siwo katã nye Israelvi dzidziawo la, mianɔ agbadɔ siawo me. ");
INSERT INTO ewe_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Nu sia ƒe taɖodzinue nye be woaɖo ŋku edzi na Israelviwo, tso dzidzime yi dzidzime be meɖe mi tso Egiptenyigba dzi, eye mena mienɔ agbadɔwo me. Nyee nye Yehowa, miaƒe Mawu.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Ale Mose ɖe gbeƒã Yehowa ƒe ŋkekenyui siwo woaɖu ƒe sia ƒe la na Israelviwo. ");
INSERT INTO ewe_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Gblɔ na Israelviwo be woana amiti ƒe ami nyuitɔ wò nàde akaɖiawo me le agbadɔ la me, ale be akaɖiawo nanɔ bibim ɣe sia ɣi. ");
INSERT INTO ewe_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Le Mawu ƒe Agbadɔ la ƒe xɔmetsovɔ megbe la, Aron akpɔ akaɖiawo dzi woanɔ bibim zã kple keli le Yehowa ŋkume. Esia nye se mavɔ na Israelviwo tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Woakpɔ akaɖi siwo le sikakaɖiti la dzi le Yehowa ŋkume la dzi ɣeawo katã ɣi. ");
INSERT INTO ewe_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Le Dzudzɔgbe ɖe sia ɖe dzi la, nunɔlagã atsɔ abolo bɔbɔe wuieve si wotsɔ wɔ kilogram etɔ̃ me ɖe sia ɖe, ");
INSERT INTO ewe_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ada ɖe fli eve me: ade nanɔ fli ɖeka me le sikakplɔ̃ si le tsitre ɖe Yehowa ŋkume la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Woatsɔ wɔ memee kilogram wuieve ame abolo ɖe sia ɖe. Woawu lifi ɖe fli eveawo dzi. Esia anye dzovɔsa na Yehowa, ");
INSERT INTO ewe_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Woaɖoe Yehowa ƒe ŋkume ɖaa Dzudzɔgbe sia Dzudzɔgbe, eye miatsɔe aɖo ŋku Mawu ƒe nubabla mavɔ si wòwɔ kple Israelviwo la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Aron kple via ŋutsuwo aɖu abolo la le teƒe tɔxɛ si woɖo na aboloawo ɖuɖu, elabena esiawoe nye dzovɔ si wosa na Yehowa le eƒe se mavɔ la nu. Wonye nu kɔkɔewo ƒe nu kɔkɔewo.” ");
INSERT INTO ewe_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Gbe ɖeka, le asaɖa la me la, ɖekakpui aɖe si dada nye Israel nyɔnu, eye fofoa nye Egiptetɔ la wɔ avu kple Israel ŋutsu aɖe. ");
INSERT INTO ewe_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Le avu sia wɔwɔ me la, Israel nyɔnu la ƒe vi gblɔ busunya ɖe Mawu ŋu, eye wohee va Mose gbɔ be wòadrɔ̃ ʋɔnui. (Dadaa ŋkɔe nye Selomit, Dibri ƒe vinyɔnu, tso Dan ƒe to la me.) ");
INSERT INTO ewe_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Wodee gaxɔ me va se ɖe esime Yehowa aɖe nu si woawɔe la afia. ");
INSERT INTO ewe_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Kplɔ busunyagblɔla la yi asaɖa la godo. Ame siwo katã se eƒe busunyagbɔgblɔ la ada asi ɖe eƒe ta dzi, eye takpelawo katã aƒu kpee. ");
INSERT INTO ewe_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Gblɔ na Israelviwo be, ‘Ne ame aɖe ƒo fi de eƒe Mawu la, ekema eɖi fɔ; ");
INSERT INTO ewe_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","woawu ame sia ame si ado vlo Yehowa ƒe ŋkɔ. Ame sia ame si le ameha la me aƒu kpee. Eɖanye dzɔleaƒea loo alo amedzro, ne edo vlo Ŋkɔ la ko, woawui. ");
INSERT INTO ewe_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Kpe ɖe esia ŋuti la, woawu hlɔ̃dolawo katã. ");
INSERT INTO ewe_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Ne ame aɖe wu lã aɖe si menye etɔ o la, ele be wòaɖoe eteƒe. ");
INSERT INTO ewe_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","To si woahe na ame aɖe si awɔ nuvevi ame aɖe lae nye be woawɔ nuvevi ma tututu eya hã le mɔ ma ke nu: ");
INSERT INTO ewe_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ƒuŋeŋe ɖe ƒuŋeŋe teƒe, ŋku ɖe ŋku teƒe, aɖu ɖe aɖu teƒe. Nu sia nu si ame aɖe awɔ nɔvia la, woawɔ nu ma tututu eya hã. ");
INSERT INTO ewe_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","“ ‘Megale egblɔm be ne ame aɖe wu ame bubu aɖe ƒe lã la, ele be wòaɖo eteƒe, eye ne ame aɖe wu ame la, woawu eya hã. ");
INSERT INTO ewe_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Se siwo miatsɔ akplɔ amedzrowo la, woawo kee miatsɔ akplɔ Israelvi dzɔleaƒeawo hã, elabena nyee nye Yehowa, miaƒe Mawu.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Ale Mose ƒo nu na Israelviwo eye wohe ɖekakpui la yi asaɖa la godo, eye woƒu kpee va se ɖe esime wòku abe ale si Yehowa de se na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Yehowa gblɔ na Mose le Sinai to la dzi bena, ");
INSERT INTO ewe_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Ne miege ɖe anyigba si mele mia na ge dzi la, ele be anyigba la naɖu dzudzɔgbe na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Miaƒã miaƒe nukuwo, aɖe miaƒe waintiwo ŋu, eye miaxa miaƒe agblemenukuwo, ");
INSERT INTO ewe_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ke le ƒe adrelia me la, miagblẽ anyigba la ɖi le Yehowa ŋkume; miagade agble ɖe edzi o. Migaƒã nukuwo o, eye migaɖe miaƒe waintiwo ŋu le ƒe blibo la me o. ");
INSERT INTO ewe_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Migaŋe nuku siwo mie le wo ɖokuiwo si o; migagbe wain tsetsewo gɔ̃ hã na mia ɖokuiwo o, elabena ƒe adrelia nye dzudzɔƒe na anyigba la. ");
INSERT INTO ewe_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Nuɖuɖu ɖe sia ɖe si ado tso anyigba la me le dzudzɔƒe la me la, anye nuɖuɖu na mi, na wò ŋutɔ, wò ŋutsusubɔla kple wò nyɔnusubɔla kple agbatedɔwɔla kple ame si le gbɔwò le ŋkeke mawo me ko, ");
INSERT INTO ewe_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","hekpe ɖe wò aƒemelãwo kple lã wɔadã siwo le wò anyigba dzi la ŋu. Nu sia nu si anyigba la na la, woate ŋu aɖui. ");
INSERT INTO ewe_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Xlẽ dzudzɔƒe teƒe adre ale be dzudzɔƒe teƒe adreawo ƒe teƒe adre nanye ƒe blaene-vɔ-asiekɛ. ");
INSERT INTO ewe_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ekema na woaku kpẽ le afi sia afi le ɣleti adrelia ƒe ŋkeke ewoa gbe; le Avuléŋkeke la dzi la, na woaku kpẽ le wò anyigba blibo la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Kɔ ƒe blatɔ̃lia ŋuti, eye nàɖe gbeƒã ablɔɖe le anyigba blibo la dzi na edzinɔlawo. Anye Aseyetsoƒe na mi. Mia dometɔ ɖe sia ɖe atrɔ ayi eƒe ƒome ƒe nunɔamesiwo gbɔ, eye ame sia ame atrɔ ayi eƒe to si me wòtso la me. ");
INSERT INTO ewe_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Ƒe blaatɔ̃lia anye Aseyetsoƒe na mi. Migaƒã nu alo axa nuku siwo mie le woawo ŋutɔ ɖokui si alo agbe waintsetse siwo tsi gbe me o, ");
INSERT INTO ewe_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","elabena Aseyetsoƒe kɔkɔe aɖee wònye na mi. Le ƒe ma me la, miaƒe nuɖuɖu anye nuku siwo miexa tso agble me. ");
INSERT INTO ewe_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Ɛ̃, le ƒe ma me la, ame sia ame atrɔ ayi wo de, ayi nu si nye eƒe ƒomea tɔ la gbɔ; ne edzra nane la, woagbugbɔe nɛ! ");
INSERT INTO ewe_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Ne èdzra anyigba na Israelvi aɖe alo ƒlee le esi la, mègabae o. ");
INSERT INTO ewe_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Aseyetsoƒe la ŋu nàƒle nu le nɔviwo si ɖo, eye ƒe ale si sinu nàŋe nu la ŋu wòadzrae na wò ɖo. ");
INSERT INTO ewe_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ne Aseyetsoƒe la le ŋgɔ ƒe geɖe la, anyigba la ƒe home akɔ. Ke ne ƒe ʋɛ aɖewo koe susɔ la, asi la abɔbɔ, elabena nu si ŋuti wole asi dom ɖo lae nye agblemenuku siwo anyigbatɔ yeye la akpɔ le anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Migaba mia nɔewo o, ke boŋ mivɔ̃ miaƒe Mawu; nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Milé nye ɖoɖowo me ɖe asi, eye miakpɔ egbɔ be yewowɔ nye seawo dzi, ekema mianɔ dedie le anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Ne miewɔ seawo dzi la, miaƒe agblemenukuwo aʋã, eye miaɖu nu aɖi ƒo. ");
INSERT INTO ewe_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Ke miabia be, “Nu ka míaɖu le ƒe adrelia me esi womeɖe mɔ na mí be míaƒã nu alo aŋe nu le ƒe ma me o?” ");
INSERT INTO ewe_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Mayra mi le ƒe adelia me ale gbegbe be anyigba la ana nuɖuɖu si asu mia nu ƒe etɔ̃. ");
INSERT INTO ewe_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ne mieƒã nukuwo le ƒe enyilia me la, miaɖu miaƒe nu xoxowo, eye miayi wo ɖuɖu dzi va se ɖe esime ƒe asiekɛlia ƒe nuŋeɣi naɖo. ");
INSERT INTO ewe_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Miɖo ŋku edzi be tɔnyee nye anyigba la, eya ta migadzrae ɖikaa o. Gbɔnyenɔlawo kple amedzro siwo le agble dzi nam ko mienye! ");
INSERT INTO ewe_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Le anyigbadzadzra ƒe ɖoɖo ɖe sia ɖe me la, ele be woaɖo kpe edzi be anyigbadzrala la agate ŋu agbugbɔ anyigba la axɔ ɣe sia ɣi. ");
INSERT INTO ewe_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Ne hiã tu ame aɖe, eye wòdzra eƒe anyigba ƒe akpa aɖe la, ekema eƒe ƒometɔ tututuwo ate ŋu axe fe ɖe eta, axɔe. ");
INSERT INTO ewe_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ne ƒometɔ aɖeke meli si ate ŋu axɔe o, eye wòva kpɔ ga emegbe la, ");
INSERT INTO ewe_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ekema eya ŋutɔ agate ŋu aƒlee ɣe sia ɣi, eye wòaxe ga ɖe eta ɖe nuŋeɣi siwo susɔ hafi Aseyetsoƒe naɖo la nu. Ele be anyigbaƒlela la naxɔ ga la, eye wòagbugbɔ anyigba la na anyigbatɔ gbãtɔ. ");
INSERT INTO ewe_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ke ne anyigbatɔ gbãtɔ la mete ŋu gbugbɔe ƒle o la, ekema anyigba la anye eƒlela la tɔ va se ɖe Aseyetsoƒe la dzi. Ke ele be wòagbugbɔe na anyigbatɔ la le Aseyetsoƒe la me kokoko. ");
INSERT INTO ewe_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Ne ame aɖe dzra eƒe aƒe le du si woɖo gli ƒo xlãe me la, agate ŋu axɔe le ƒe ɖeka me ko. ");
INSERT INTO ewe_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ke ne mete ŋu xɔe le ƒe ɖeka ma me o la, ekema azu eƒlela kple eƒe dzidzimeviwo tɔ ɖikaa, eye magbugbɔ ayi edzrala ƒe asi me le Aseyetsoƒe la gɔ̃ hã me o. ");
INSERT INTO ewe_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Ke aƒe siwo le du siwo womeɖo gli ƒo xlã o me ya la le ko abe aƒe siwo wotso ɖe agblewo dzi ene, eya ta woate ŋu agbugbɔ wo axɔ ɣe sia ɣi, eye woagbugbɔ wo na nutɔ gbãtɔwo le Aseyetsoƒe la me kokoko. ");
INSERT INTO ewe_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Mele alea le Levitɔwo ya gome o. Levitɔwo ya ate ŋu agbugbɔ woƒe aƒewo axɔ ɣe sia ɣi, le du siwo wotsɔ na wo la me, ");
INSERT INTO ewe_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ke ne Levitɔ aɖeke mexɔe o la, ekema woaɖe asi le aƒe si wodzra le woawo ŋutɔ ƒe du me la ŋuti le Aseyetsoƒe la dzi, elabena Levitɔwo ƒe duwo nye woawo ŋutɔ tɔ le Israelviwo dome. ");
INSERT INTO ewe_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Womeɖe mɔ na Levitɔwo be woadzra lãnyiƒenyigba siwo ƒo xlã woƒe duwo o, elabena wonye wo tɔ ɖikaa, eye womagate ŋu anye ame bubu aɖeke tɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Ne hiã tu hawòvi, Israelvi, eye magate ŋu akpɔ eɖokui dzi o la, enye wò dɔdeasi be nàkpe ɖe eŋu. Na wòava nɔ gbɔwò le wò aƒe me abe amedzro si dze gbɔwò ene. ");
INSERT INTO ewe_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Mègaxɔ deme ɖe ga si nèdo nɛ la dzi o, ke boŋ vɔ̃ wò Mawu, eye nàna wòanɔ gbɔwò. ");
INSERT INTO ewe_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ɖo ŋku edzi be deme aɖeke mele eme o, eye nàna nu sia nu si hiãe la adzɔmaxɔe. Mègati viɖe yome o. ");
INSERT INTO ewe_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Esiae nye sedede tso nye, Yehowa, miaƒe Mawu la gbɔ, ame si kplɔ mi tso Egiptenyigba dzi be matsɔ Kanaanyigba ana mi, eye manye miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Ne nɔviwò Israelvi aɖe ɖo ko, eye wòdzra eɖokui na wò la, mele be nàwɔ eŋu dɔ abe kluvi bubuawo ene o, ");
INSERT INTO ewe_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","ke boŋ nàbui abe wò agbatedɔwɔla alo wò amedzro ene, eye wòasubɔ wò va se ɖe Aseyetsoƒe la me. ");
INSERT INTO ewe_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Le Aseyetsoƒe la me la, ate ŋu adzo kple viawo, eye wòatrɔ ayi eya ŋutɔ ƒe ƒometɔwo kple eƒe domenyinuwo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Esi wònye nyee kplɔ mi tso Egiptenyigba dzi, eye nye subɔlawo mienye ta la, mele be woadzra mi abe kluvi bubuawo ene loo ");
INSERT INTO ewe_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","alo awɔ fu mi o. Mivɔ̃ miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Miate ŋu aƒle kluviwo tso dukɔ bubu siwo ƒo xlã mi la me, ");
INSERT INTO ewe_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","eye miate ŋu aƒle amedzro siwo ƒo xlã mi la ƒe viwo, togbɔ be wodzi wo le miaƒe anyigba dzi hã. ");
INSERT INTO ewe_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Woanye kluviwo na mi tegbetegbe, eye miagblẽ wo ɖi na mia viwo. Ke mele be miawɔ mia nɔvi, Israelviwo ya nenema o. ");
INSERT INTO ewe_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Ne amedzro aɖe si le mia dome zu hotsuitɔ, eye ne Israelvi aɖe ɖo ko, eye wòdzra eɖokui na amedzro hotsuitɔ la alo hotsuitɔ la ƒe ƒometɔ la, ");
INSERT INTO ewe_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Israelvi la nɔviŋutsu, ");
INSERT INTO ewe_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","fofoa alo dadaa nɔviŋutsu, nɔvia ŋutsu alo nɔvia nyɔnu, viŋutsu alo ame sia ame si nye eƒe ƒometɔ tututu la ate ŋu axɔe. Eya ŋutɔ hã ate ŋu axɔ eɖokui ne ate ŋu akpɔ ga home la. ");
INSERT INTO ewe_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Fe si wòaxe ɖe eƒe ablɔɖe ta la, aku ɖe ƒe siwo susɔ hafi Aseyetsoƒe la naɖo la ŋu. Esɔ kple fe si woaxe na agbatedɔwɔlawo le ƒe mawo me. ");
INSERT INTO ewe_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ne ƒe geɖewo ava yi hafi Aseyetsoƒe la naɖo la, ekema amea axe ga si wòxɔ esime wòdzra eɖokui la ƒe akpa gãtɔ. ");
INSERT INTO ewe_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ne ƒeawo va yi, eye wòsusɔ ƒe ʋɛ aɖewo ko Aseyetsoƒe la naɖo la, ekema axe ga si wòxɔ esi wòdzra eɖokui la ƒe akpa sue aɖe ko. ");
INSERT INTO ewe_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ne edzra eɖokui na amedzro aɖe la, ele be amedzro la nalé be nɛ abe agbatedɔwɔla ene, ke mawɔ eŋu dɔ abe kluvi alo nu si nye etɔ la ene o. ");
INSERT INTO ewe_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Ne womete ŋu xɔe hafi Aseyetsoƒe la ɖo o la, ekema woana ablɔɖe eya ŋutɔ kple viawo le Aseyetsoƒe la me. ");
INSERT INTO ewe_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Elabena nye amewoe nye Israelviwo. Nyee ɖe wo tso Egiptenyigba dzi. Nyee nye Yehowa, miaƒe Mawu.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Legba aɖeke meganɔ mia si o. Migasubɔ aklamakpakpɛwo, aƒeliwo alo kpe kpakpɛwo gbeɖegbeɖe o, elabena nyee nye Yehowa, miaƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Miwɔ nye Dzudzɔgbe ƒe sewo dzi, eye miade bubu nye Agbadɔ ŋu, elabena nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Ne miewɔ nye seawo katã dzi la, ");
INSERT INTO ewe_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","mana tsi nadza na mi le tsidzaɣi, anyigba ana eƒe nuɖuɖu, eye gbemetiwo atse woƒe kutsetsewo. ");
INSERT INTO ewe_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Miaƒe luƒoƒo ayi edzi va se ɖe wainxaɣi, wainxaɣi ayi edzi va se ɖe nuƒãɣi, miaɖu nu siwo katã ahiã mi, eye mianɔ miaƒe anyigba dzi le dedinɔnɔ me, ");
INSERT INTO ewe_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","elabena mana ŋutifafa mi. Miamlɔ anyi, adɔ alɔ̃ le dziɖeɖi me. Manya lã wɔadãwo ɖa le mia ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Mianya miaƒe futɔwo ɖe du nu; woaku ɖe miaƒe yi nu. ");
INSERT INTO ewe_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Mia dometɔ atɔ̃ anya ame alafa ɖeka ɖe du nu, eye mia dometɔ alafa ɖeka anya ame akpe ewo! Miaɖu miaƒe futɔwo katã dzi. ");
INSERT INTO ewe_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Makpɔ mia dzi, mana miadzi asɔ gbɔ, eye mawɔ nu si mebla kpli mi la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Miaƒe nukuwo asɔ gbɔ na mi wu ale si miehiã ale gbegbe be miaganya nu si miawɔ kple esi atsi anyi o, eye mianya ɣeyiɣi si nuŋeɣi agaɖo o! ");
INSERT INTO ewe_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Manɔ mia dome; mianye ŋunyɔnu nam o. ");
INSERT INTO ewe_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Mazɔ le mia dome, manye miaƒe Mawu, eye miawo mianye nye amewo, ");
INSERT INTO ewe_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","elabena nyee nye Yehowa, miaƒe Mawu, ame si kplɔ mi tso Egiptenyigba dzi, ale be miaganye kluviwo azɔ o. Meɖe kɔkuti le kɔ dzi na mi, ale be miazɔ abe ablɔɖemewo kple bubumewo ene.’ ” ");
INSERT INTO ewe_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“Ke ne miaɖo tom alo awɔ nye seawo dzi o, ");
INSERT INTO ewe_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ke boŋ miagbe nye ɖoɖowo la, ");
INSERT INTO ewe_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ekema nu si mawɔ mie nye: mado ŋɔdzi na mi kple asrã sesẽtɔ. Dɔléle aɖe fu na miaƒe ŋkuwo, eye gbɔdzɔgbɔdzɔ age ɖe miaƒe agbenɔnɔ me. Dzodzroe miaƒã miaƒe nukuwo, elabena miaƒe futɔwoe aɖu wo. ");
INSERT INTO ewe_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","“Maɖe ŋku atɔ mi; miasi le miaƒe futɔwo nu. Ame siwo lé fu mi la aɖu mia dzi. Gawu la, miade asi sisi me, togbɔ be ame aɖeke manɔ mia nyam o hã! ");
INSERT INTO ewe_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“Ne miegagbe toɖoɖom kokoko la, mahe to na mi vevie zi adre ɖe miaƒe nu vɔ̃wo ta. ");
INSERT INTO ewe_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Maɖe miaƒe ŋusẽ si dzi miedana ɖo la dzi, mana dziƒo nanɔ na mi abe gayibɔ ene, eye anyigba nanɔ na mi abe akɔbli ene. ");
INSERT INTO ewe_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Miadagba dzodzro, elabena miaƒe anyigba mana miaƒe nukuwo naʋã o, eye miaƒe kutsetsetiwo matse ku o. ");
INSERT INTO ewe_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“Ne miagaɖo tom ɣe ma ɣi hã o la, mana dɔvɔ̃ bubu adre nava mia dzi ɖe miaƒe nu vɔ̃wo ta. ");
INSERT INTO ewe_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Maɖo lã wɔadãwo ɖa be woawu mia viwo, avuvu miaƒe aƒemelãwo, aɖe miaƒe xexlẽme dzi akpɔtɔ, ale be amewo avɔ le miaƒe mɔwo dzi. ");
INSERT INTO ewe_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“Eye ne nu siawo gɔ̃ hã mana miatrɔ dzi me o, ke boŋ miagayi tsitretsitsi ɖe nye didiwo ŋu dzi la, ");
INSERT INTO ewe_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ekema nye hã matsi tsitre ɖe miaƒe didiwo ŋu, eye nye ŋutɔ gɔ̃ hã mafia fu mi zi adre ɖe miaƒe nu vɔ̃wo ta. ");
INSERT INTO ewe_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Mabia hlɔ̃ mi le ale si miegbe nye nubabla dzi wɔwɔ ta, to aʋawɔwɔ hehe va mia dzi me. Miasi ayi miaƒe duwo me, eye maɖo dɔvɔ̃ ɖe mia dome le afi ma. Miaƒe futɔwo aɖu mia dzi. ");
INSERT INTO ewe_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Magblẽ miaƒe nuɖuɖu ƒe dzɔtsoƒe me, ale be abolokpo ɖeka pɛ ame abolo na ƒome ewo. Ne mieɖu nu sue si aka mia si vɔ la, dɔ agawu mi kokoko. ");
INSERT INTO ewe_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“Ne miagagbe toɖoɖom kple nye sewo dzi wɔwɔ kokoko la, ");
INSERT INTO ewe_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","ekema mana nye dɔmedzoe sesẽ la nabi ɖe mia ŋu, eye mana tohehe si dzi ŋɔ zi adre wu tsãtɔwo la nava mia dzi le miaƒe nu vɔ̃wo ta. ");
INSERT INTO ewe_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Miaɖu miawo ŋutɔ mia viŋutsuwo kple mia vinyɔnuwo, ");
INSERT INTO ewe_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","makaka vɔsamlekpui siwo le towo dzi, afi si miedea ta agu na legbawo le. Magbã miaƒe dzudzɔdovɔsamlekpuiwo, miaƒe ame kukuwo aƒaƒã ɖe miaƒe legbawo dome, eye mianyɔ ŋu nam. ");
INSERT INTO ewe_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Mana miaƒe du gãwo nazu aƒedowo, magblẽ miaƒe mawusubɔƒewo, eye miaƒe dzudzɔdovɔsamlekpuiwo magadze ŋunye o. ");
INSERT INTO ewe_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ɛ̃, mana miaƒe anyigba nazu gbegbe, miaƒe futɔwo axɔ miaƒe anyigba, eye woƒe nu aku le nu si mewɔ mi la ta. ");
INSERT INTO ewe_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","“Makaka mi ɖe dukɔwo dome, eye ne mieyina la, mana aʋa nasi mi. Miaƒe anyigba azu gbegbe, eye miaƒe du gãwo agbã. ");
INSERT INTO ewe_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Ekema anyigba la akpɔ gbɔdzɔe le ɣeyiɣi siwo katã wònye gbegbe la me, esime miele miaƒe futɔwo ƒe anyigba dzi, ekema anyigba la adzudzɔ, eye wòakpɔ eƒe gbɔdzɔe. ");
INSERT INTO ewe_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Le ɣeyiɣi siwo katã me wònye gbegbe la, anyigba la akpɔ dzudzɔ si mekpɔ le dzudzɔgbe siwo mienɔ edzi la kpɔ o. ");
INSERT INTO ewe_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“Mana woaɖe aboyo ame siwo aganɔ agbe la ayi didiƒenyigbawo dzi abe aʋaléleawo kple kluviwo ene. Woanɔ afi ma kple dzodzo nyanyanya ɣe sia ɣi. Ne ya ƒo aŋugba la, eƒe gbeɖiɖi ana woasi abe ame aɖee le wo nyam kple yi ene. Woadze anyi le esime ame aɖeke mele wo nyam o. ");
INSERT INTO ewe_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Ɛ̃, togbɔ be ame aɖeke mele wo nyam o hã la, woasi, anɔ wo nɔewo dzi dzem abe ame siwo le sisim le aʋagbedzi, eye womate ŋu anɔ te ɖe futɔwo nu o ene. ");
INSERT INTO ewe_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Miatsrɔ̃ le dukɔwo dome, eye miaƒe futɔwo awu mi. ");
INSERT INTO ewe_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Ame siwo atsi agbe la atsi asi le futɔwo ƒe anyigba dzi le woƒe nu vɔ̃wo kple nu vɔ̃ siwo wo fofowo wɔ la ta. ");
INSERT INTO ewe_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“Ke ne woaʋu woawo ŋutɔ ƒe nu vɔ̃wo kple wo fofowo ƒe nu vɔ̃wo me, woƒe tsitretsitsi ɖe ŋunye kple woƒe fulélem si ");
INSERT INTO ewe_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","na meɖo wo ɖe woƒe futɔwo ƒe anyigba dzi me la, ekema ne woƒe dzi kuatriwo bɔbɔ wo ɖokui, eye woxe fe ɖe woƒe nu vɔ̃ ta la, ");
INSERT INTO ewe_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","magaɖo ŋku ŋugbe siwo medo na Abraham, Isak kple Yakob la dzi. Maɖo ŋku anyigba la kple ale si amewo gblẽe ɖi la dzi, ");
INSERT INTO ewe_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","elabena ele be anyigba la nagbɔ ɖe eme le esime amewo dzo le edzi. Ekema, mlɔeba la, woaxɔ woƒe tohehe le nye seawo dzi mawɔmawɔ kple woƒe vlododo nye dziɖuɖu ta. ");
INSERT INTO ewe_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ke togbɔ be wowɔ nu siawo katã hã la, nyematsrɔ̃ wo kple nubabla si mewɔ kpli wo la ɖikaa o, elabena nyee nye Yehowa, woƒe Mawu. ");
INSERT INTO ewe_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Le woawo ta la, maɖo ŋku nye ŋugbedodowo na wo tɔgbuiwo dzi be manye woƒe Mawu, elabena nyee kplɔ wo tɔgbuiwo tso Egipte le esime dukɔwo katã ƒe nu ku esi wonɔ nu siwo nɔ dzɔdzɔm la kpɔm. Nyee nye Yehowa!” ");
INSERT INTO ewe_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Esiawoe nye se kple ɖoɖo siwo Yehowa na Israelviwo to Mose dzi le Sinai to la dzi. ");
INSERT INTO ewe_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Ne ame aɖe ɖe adzɔgbe tɔxɛ aɖe be yeatsɔ ame aɖewo ana Yehowa to ga home si dze be woaxe ɖe wo ta me la, ");
INSERT INTO ewe_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ekema ɖe ŋutsu si xɔ tso ƒe blaeve yi blaade nu la ana klosalo kpekpeme kilogram afã ɖe Kɔkɔeƒe la ƒe nudanu nu. ");
INSERT INTO ewe_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Nenye be nyɔnue la, ana klosalo kpekpeme kilogram ƒe mama etɔ̃lia ƒe ɖeka. ");
INSERT INTO ewe_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Ɖe ŋutsuvi si xɔ tso ƒe atɔ̃ va se ɖe blaeve nu la, ana klosalo kilogram ƒe mama atɔ̃ ƒe ɖeka, eye ɖe nyɔnuvi si xɔ tso ƒe atɔ̃ va se ɖe blaeve nu la, ana klosalo gram alafa ɖeka kple ewo. ");
INSERT INTO ewe_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Woaxe gram blaatɔ̃ vɔ atɔ̃ ɖe ŋutsuvi si xɔ tso ɣleti ɖeka va se ɖe ƒe atɔ̃ la nu, eye woaxe klosalo gram blaetɔ̃ vɔ atɔ̃ ɖe nyɔnuvi si xɔ tso ɣleti ɖeka va se ɖe ƒe atɔ̃ la nu. ");
INSERT INTO ewe_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Ŋutsu si xɔ wu ƒe blaade la axe klosalo gram blaatɔ̃ vɔ atɔ̃, eye nyɔnu si xɔ wu ƒe blaade la axe klosalo gram blaetɔ̃ vɔ atɔ̃. ");
INSERT INTO ewe_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ke ne ame si le adzɔgbe la ɖem da ahe ale gbegbe be mate ŋu axe fe si wòle be wòaxe o la, woakplɔe va nunɔla la gbɔ, eya kple nunɔla la naɖo aɖaŋu, eye wòaxe nu si nunɔla la aɖo nɛ la. ");
INSERT INTO ewe_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Ke ne nu si amea tsɔ ɖe adzɔgbee la nye lã si dzi woda asi ɖo be woatsɔ asa vɔe na Yehowa la, ne wotsɔ lã sia ɖe adzɔgbee la, ele kɔkɔe na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Mele be adzɔgbeɖela la natrɔ eƒe ta me o; matrɔ ta me le etsɔtsɔ na Yehowa ŋu loo alo atsɔ nu nyui aɖo gbegblẽa teƒe alo atsɔ gbegblẽa aɖo nyuia teƒe o. Ne etrɔ ta me la, ekema lã si wòɖɔli kple esi wòtsɔ ɖɔlii siaa le kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Ke ne lã si wòɖe adzɔgbe be yeatsɔ asa vɔe nye lã makɔmakɔ, lã si womaxɔ abe vɔsa na Yehowa ene o la, ele be wòatsɔ lã la ayi na nunɔla, ");
INSERT INTO ewe_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ame si akpɔe ne lã la nyo alo menyo o. Ga home si ƒe asi nunɔla la ado ɖe lã la ŋu la, nenema ko wòanɔ. ");
INSERT INTO ewe_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ne lã la nye lã si woate ŋu atsɔ asa vɔe, gake amea di be yeaxe fe ɖe eteƒe la, ekema axe ga home si nunɔla la agblɔ nɛ kple ga home la ƒe mama atɔ̃lia ƒe ɖeka akpe ɖe eŋu. ");
INSERT INTO ewe_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Ne ame aɖe tsɔ eƒe aƒe abe nu si ŋuti kɔ ene na Yehowa la, nunɔla la akpɔ aƒea ƒe nyonyo alo manyomanyo dzi ɖa. Ga home si ƒe asi nunɔla la ado ɖe aƒea ŋu la, nenema ko wòanɔ. ");
INSERT INTO ewe_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Ne ame si tsɔ eƒe aƒe na agaxɔe la, ele nɛ be wòatsɔ ga home la ƒe atɔ̃lia ƒe ɖeka akpe ɖe ga home la ŋu, eye aƒea agazu etɔ. ");
INSERT INTO ewe_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Ne ame aɖe tsɔ eƒe anyigba ƒe akpa aɖe na Yehowa la, do asi ɖe eŋu ɖe eƒe lolome kple nuku agbɔsɔsɔ si woate ŋu aƒã ɖe edzi la nu. Anyigba si dzi woate ŋu aƒã lu kilogram blaeve ɖo la naxɔ klosaloga ewo. ");
INSERT INTO ewe_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ne ame aɖe tsɔ eƒe anyigba na Yehowa le Aseyetsoƒe la me la, ekema nutɔ la naxe ga home la katã. ");
INSERT INTO ewe_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ke ne etsɔe na le Aseyetsoƒe la megbe la, ekema ga home si wòaxe la aku ɖe ƒe siwo susɔ hafi Aseyetsoƒe bubu nagaɖo la ŋu. ");
INSERT INTO ewe_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Ne amea di be yeagaxɔ anyigba la la, ekema ele nɛ be wòaxe ga home si nunɔla la ɖo nɛ kple ga home la ƒe mama atɔ̃lia ƒe ɖeka. Ekema anyigba la agazu etɔ. ");
INSERT INTO ewe_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","“ ‘Ke ne eɖo be yemagbugbɔ anyigba la axɔ o, alo wòdzrae na ame bubu aɖe, eye wòna anyigba la zu Yehowa tɔ le Aseyetsoƒe la me la, ekema magate ŋu axɔe o. ");
INSERT INTO ewe_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Ne woɖe asi le anyigba la ŋu le Aseyetsoƒe la me la, ekema anyigba la azu Yehowa tɔ abe anyigba si wotsɔ nɛ ene. Woatsɔe na nunɔla la. ");
INSERT INTO ewe_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Ne ame aɖe tsɔ anyigba si eya ŋutɔ ƒle, eye menye eƒe ƒome ƒe anyigba ƒe akpa aɖeke o na Yehowa la, ");
INSERT INTO ewe_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ekema nunɔla la agblɔ ga home si anyigba la axɔ va se ɖe Aseyetsoƒe si gbɔna la nɛ. Amea axe ga home ma enumake na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Ekema le Aseyetsoƒe la me la, anyigba la agazu nutɔ gbãtɔ si si wòƒlee le la tɔ. ");
INSERT INTO ewe_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Ga homeawo katã nanɔ Kɔkɔeƒe la ƒe ga me: ga siwo katã woaxe la nanye esi dzi nunɔlawo ɖo kpee da ɖi. ");
INSERT INTO ewe_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Ame aɖeke matsɔ nyitsu alo agbo si ʋu dɔnu na dadaa la ana Yehowa o, elabena Yehowa tɔe wònye xoxo. ");
INSERT INTO ewe_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Ke ne enye ŋgɔgbevi na lã si ŋu se meɖe mɔ le be woatsɔ asa vɔe na Yehowa o la, ekema amea axe ga home si nunɔla ayɔ nɛ la kple ga home la ƒe mama atɔ̃lia ƒe ɖeka. Ke ne amea medi be yeagbugbɔe axɔ o la, nunɔla la nadzrae na ame bubu ɖe sia ɖe. ");
INSERT INTO ewe_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ke nu sia nu si woatsɔ ana Yehowa, eɖanye amegbetɔ o, lã o alo anyigba si ƒe dome ame aɖe menyi o la, womadzra wo o, eye womagbugbɔ wo axɔ hã o, elabena nu kɔkɔewo ƒe nu kɔkɔewo wonye na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Ne wodo busu ame aɖe la, womaxɔe kple ga o, ke boŋ woawui. ");
INSERT INTO ewe_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Nu siwo katã anyigba wɔ, agblemenukuwo loo alo kutsetsewo ƒe mama ewolia ƒe ɖeka nye Yehowa tɔ, eye wonye nu kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Ne ame aɖe di be yeaxɔ yeƒe kutsetse la alo agblemenuku la aƒle la, ele be wòaxe ga home la kple eƒe mama atɔ̃lia ƒe ɖeka. ");
INSERT INTO ewe_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ne lãkplɔla aɖe le eƒe lãwo xlẽm ɖekeɖekae la, lã ewolia ɖe sia ɖe nye Yehowa tɔ, eɖanye nyi, alẽ alo aƒemelã bubu ɖe sia ɖe o. ");
INSERT INTO ewe_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Womatia lã ewolia si woatsɔ ana Yehowa la ɖe eƒe nyonyo alo manyomanyo ta o. Womatsɔ ɖeke aɖɔli bubu hã o. Ne woaɖɔli lã aɖe kokoko la, ekema esi woaɖɔli kple esi woatsɔ aɖɔlii la siaa nye Yehowa tɔ, eye womaxe fe ɖe wo ta o!’ ” ");
INSERT INTO ewe_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Esiawoe nye se siwo Yehowa de na Mose le Sinai to la dzi na Israelviwo.");
INSERT INTO ewe_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Le Israelviwo ƒe dzodzo le Egipte ƒe ƒe evelia ƒe ɣleti evelia ƒe ŋkeke gbãtɔ si nye Israelviwo ƒe ɣleti evelia ƒe ŋkeke gbãtɔ dzi la, Mawu nɔ agbadɔ la me le Israelviwo ƒe asaɖa me le Sinai gbedzi. Yehowa gblɔ nya siawo na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Mi kple Aron mixlẽ Israel dukɔ la katã ɖe woƒe towo kple ƒomewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Miŋlɔ Israel ŋutsu siwo katã xɔ ƒe blaeve alo wu nenema la, eye woate ŋu awɔ aʋa la ƒe ŋkɔwo. ");
INSERT INTO ewe_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Eye miɖe ŋutsu ɖekaɖeka le to sia to me, ame siwo anye kplɔlawo na toawo be woakpe ɖe ŋuwò. ");
INSERT INTO ewe_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Ŋutsu siwo akpe ɖe mia ŋu la ƒe ŋkɔwoe nye: “Elizur, Sedeur ƒe viŋutsu, tso Ruben ƒe to la me. ");
INSERT INTO ewe_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Selumiel, Zurisadai ƒe viŋutsu, tso Simeon ƒe to la me. ");
INSERT INTO ewe_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Nahson, Aminadab ƒe viŋutsu, tso Yuda ƒe to la me. ");
INSERT INTO ewe_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Netanel, Zuar ƒe viŋutsu, tso Isaka ƒe to la me. ");
INSERT INTO ewe_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Eliab, Helon ƒe viŋutsu, tso Zebulon ƒe to la me. ");
INSERT INTO ewe_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Yosef ƒe viwo tɔwoe nye: Elisama, Amihud ƒe viŋutsu, tso Efraim ƒe to la me kple Gamaliel, Pedahzur ƒe viŋutsu, tso Manase ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Abidan, Gideon ƒe viŋutsu, tso Benyamin ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Ahiezer, Amisadai ƒe viŋutsu, tso Dan ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Pagiel, Okran ƒe viŋutsu, tso Aser ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Eliasaf, Deguel ƒe viŋutsu, tso Gad ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Ahira, Enan ƒe viŋutsu, tso Naftali ƒe to la me.” ");
INSERT INTO ewe_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ame siawoe wotia tso ameawo dome be woanye kplɔlawo na Israel to vovovoawo. ");
INSERT INTO ewe_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Le gbe ma gbe ke la, Mose kple Aron kple ŋutsu wuieve siwo wotia la ");
INSERT INTO ewe_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","yɔ dukɔ blibo la ƒo ƒu le dzinu evelia ƒe ŋkeke gbãtɔ dzi, eye woŋlɔ ameawo katã ƒe ŋkɔ ɖe woƒe towo kple ƒomewo nu. Woŋlɔ ŋutsu siwo katã xɔ ƒe blaeve alo wu nenema la ƒe ŋkɔwo, eye woxlẽ wo ");
INSERT INTO ewe_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","abe ale si Yehowa de se ene. Mose wɔ ŋkɔŋɔŋlɔ sia le Sinai gbegbe. ");
INSERT INTO ewe_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Eye woxlẽ ŋutsu siwo katã xɔ ƒe blaeve alo wu nenema la, eye woate ŋu ade aʋa le Israel ƒe ŋgɔgbevi Ruben ƒe dzidzimeviwo dome la ƒe ŋkɔwo ɖekaɖeka le woƒe ƒomewo kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Ame siwo wotia, xlẽ le Ruben ƒe to la me le ame akpe blaene-vɔ-ade, alafa atɔ̃ (46,500). ");
INSERT INTO ewe_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Woxlẽ ŋutsu siwo katã xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Simeon ƒe dzidzimeviwo dome la ƒe ŋkɔwo ɖekaɖeka le woƒe ƒomewo kple woƒe aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Ame siwo wotia, xlẽ le Simeon ƒe to la me le ame akpe blaetɔ̃-vɔ-asieke, alafa etɔ̃ (59,300). ");
INSERT INTO ewe_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Eye woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Gad ƒe dzidzimeviwo dome la ƒe ŋkɔwo le woƒe ƒome kple woƒe aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Ame siwo wotia, xlẽ le Gad ƒe to la me le ame akpe blaene-vɔ-atɔ̃ (45,650), alafa ade blaatɔ̃. ");
INSERT INTO ewe_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Yuda ƒe dzidzimeviwo dome ƒe ŋkɔwo le woƒe ƒome kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Ame siwo wotia, xlẽ le Yuda ƒe to la me le ame akpe blaadre-vɔ-ene, alafa ade (74,600). ");
INSERT INTO ewe_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Eye woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Isaka ƒe dzidzimeviwo dome la ƒe ŋkɔwo le woƒe ƒome kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Ame siwo wotia, xlẽ le Isaka ƒe to la me le ame akpe blaatɔ̃-vɔ-ene, alafa ene (54,400). ");
INSERT INTO ewe_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Eye woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Zebulon ƒe dzidzimeviwo dome la ƒe ŋkɔwo le woƒe ƒome kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Ame siwo wotia, xlẽ le Zebulon ƒe to me la le ame akpa blaatɔ̃-vɔ-adre, alafa ene (57,400). ");
INSERT INTO ewe_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Yosef ƒe viwo tɔe nye esi: Woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Efraim ƒe dzidzimeviwo dome la ƒe ŋkɔwo le woƒe ƒome kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Ame siwo wotia, xlẽ le Efraim ƒe to la me le ame akpe blaene, alafa atɔ̃ (40,500). ");
INSERT INTO ewe_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Eye woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Manase ƒe dzidzimeviwo dome la ƒe ŋkɔwo le woƒe ƒome kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Ame siwo wotia, xlẽ le Manase ƒe to la me le ame akpe blaetɔ̃-vɔ-eve, alafa eve (32,200). ");
INSERT INTO ewe_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Benyamin ƒe dzidzimeviwo dome la ƒe ŋkɔwo le woƒe ƒome kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Ame siwo wotia, xlẽ le Benyamin ƒe to la me le ame akpe blaetɔ̃ vɔ atɔ̃ alafa ene (35,400). ");
INSERT INTO ewe_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Eye woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Dan ƒe dzidzimeviwo dome la ƒe ŋkɔwo le woƒe ƒome kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Ame siwo wotia, xlẽ le Dan ƒe to la me le ame akpe blaadre-vɔ-eve, alafa adre (62,700). ");
INSERT INTO ewe_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Aser ƒe dzidzimeviwo dome la ƒe ŋkɔwo le woƒe ƒome kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Ame siwo wotia, xlẽ le Aser ƒe to la me le ame akpe blaene-vɔ-ɖekɛ, alafa atɔ̃ (41,500). ");
INSERT INTO ewe_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Eye woxlẽ ame siwo xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Naftali ƒe dzidzimeviwo dome la ƒe ŋkɔwo le woƒe ƒomewo kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Ame siwo wotia, xlẽ le Naftali to la me le ame akpe blaatɔ̃-vɔ-etɔ̃ alafa ene (53,400). ");
INSERT INTO ewe_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Esiawoe nye ame siwo Mose kple Aron kple Israel ƒe towo ƒe kplɔlawo tia xlẽ. Kplɔlawo le ame wuieve: to ɖeka, kplɔla ɖeka ");
INSERT INTO ewe_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Eye wotia Israelviwo katã xlẽ le woƒe ƒomewo kple aƒewo nu, ame siwo katã xɔ ƒe blaeve alo wu nenema, eye woate ŋu ade aʋa le Israel. ");
INSERT INTO ewe_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Ame siwo katã wotia, xlẽ la le ame akpe alafa ade vɔ etɔ̃, alafa atɔ̃, blaatɔ̃ (603,550). ");
INSERT INTO ewe_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ke womexlẽ Levi ƒe viwo ƒe ƒomewo kple aƒewo kpe ɖe wo ŋuti o. ");
INSERT INTO ewe_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Elabena Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ɖe Levi ƒe viwo katã ɖa le amexexlẽ sia me, eye mègabu wo kpe ɖe Israelvi bubuwo ƒe xexlẽme ŋu o, ");
INSERT INTO ewe_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","elabena Levi ƒe viwo ƒe dɔdeasiwo ku ɖe Agbadɔ la kple ekɔkɔ tso teƒe ɖeka yi teƒe bubu ŋu. Woanɔ Agbadɔ la gbɔ, ");
INSERT INTO ewe_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","eye ɣe sia ɣi si woaho Agbadɔ la ayi teƒe bubu la, Levi ƒe viwoe akakae, eye woawoe agakpee; ne ame bubu aɖe te va la, aku. ");
INSERT INTO ewe_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israelviwo ƒe to vovovoawo aƒu asaɖa anyi ɖe teƒe vovovowo, ɖe sia ɖe kple eƒe aflaga tɔxɛ ");
INSERT INTO ewe_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Levi ƒe viwo ƒe agbadɔwo aƒo xlã Mawu ƒe Agbadɔ la, eye woanɔ eŋu dzɔm, ale be ame aɖeke mate ɖe eŋu, ana be nye dɔmedzoe nafla, eye matsrɔ̃ Israel dukɔ la o.” ");
INSERT INTO ewe_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Ale Israelviwo wɔ se siwo katã Yehowa de na Mose la dzi pɛpɛpɛ. ");
INSERT INTO ewe_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yehowa gade se bubuwo na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Ele be agbadɔtuƒe, aflagati kple aflaga tɔxɛ nanɔ Israelviwo ƒe to ɖe sia ɖe si. Mawu ƒe Agbadɔ la nanɔ to vovovoawo ƒe agbadɔtuƒewo ƒe titina.” ");
INSERT INTO ewe_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Yuda ƒe to la naƒu asaɖa anyi ɖe woƒe aflaga gbɔ le ɣedzeƒe gome. Yuda ƒe viwo ƒe kplɔlae nye Nahson, Aminadab ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ame siwo ƒe aʋawɔlawo le ame akpe blaadre-vɔ-ene, alafa ade (74,600). ");
INSERT INTO ewe_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Isaka ƒe to la naƒu asaɖa anyi ɖe wo xa. Isaka ƒe viwo ƒe kplɔlae nye Netanel, Zuar ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ame siwo ƒe aʋawɔlawo le ame akpe blaatɔ̃-vɔ-ene, alafa ene (54,400). ");
INSERT INTO ewe_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Zebulon ƒe to la naƒu asaɖa anyi ɖe Isaka ƒe viwo xa. Zebulon ƒe viwo ƒe kplɔlae nye Eliab, Helon ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ame siwo ƒe aʋawɔlawo le ame akpe blaatɔ̃-vɔ-adre, alafa ene (57,400). ");
INSERT INTO ewe_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Aʋawɔla siwo katã le Yuda ƒe asaɖa me la le ame akpe alafa ɖeka blaenyi-vɔ-ade alafa ene (186,400). Ame siawoe atre hoho, ado ŋgɔ ɣe sia ɣi si Israelviwo aho ayi aɖaƒu asaɖa anyi ɖe teƒe bubu. ");
INSERT INTO ewe_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ruben ƒe to la naƒu asaɖa anyi ɖe woƒe aflaga gbɔ le dziehe gome. Ruben ƒe viwo ƒe kplɔlae nye Elizur, Sedeur ƒe vi, ");
INSERT INTO ewe_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ame siwo ƒe aʋawɔlawo le ame akpe blaene-vɔ-ade, alafa atɔ̃ (46,500). ");
INSERT INTO ewe_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Simeon ƒe to la naƒu asaɖa anyi ɖe wo xa. Simeon ƒe viwo ƒe kplɔlae nye Selumiel, Zurisadai ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ame siwo ƒe aʋawɔlawo le ame akpe blaetɔ̃-vɔ-asieke, alafa etɔ̃ (59,300). ");
INSERT INTO ewe_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Eye Gad ƒe to la nakpe ɖe wo ŋu. Gad ƒe viwo ƒe kplɔlae nye Eliasaf, Deguel ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ame siwo ƒe aʋawɔlawo le akpe blaene-vɔ-atɔ̃, alafa ade blaatɔ̃ (45,650). ");
INSERT INTO ewe_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Aʋawɔla siwo katã le Ruben ƒe asaɖa me la le ame akpe alafa ɖeka blaatɔ̃-vɔ-ɖekɛ, alafa ene blaatɔ̃ (151,450). Woawoe anye hatsotso evelia si akplɔ gbãtɔ ɖo ne Israelviwo ho gayi woƒe mɔzɔzɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Emegbe la, Mawu ƒe Agbadɔ la kple Levi ƒe viwo ƒe asaɖa, si le asaɖa bubuawo titina la naho. Ale si woƒu asaɖa anyii la, nenema ŋu woaho ɖo; ame sia ame nanɔ eteƒe le eƒe aflaga gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Efraim ƒe to la naƒu asaɖa anyi ɖe woƒe aflaga gbɔ le ɣetoɖoƒe gome. Efraim ƒe viwo ƒe kplɔlae nye Elisama, Amihud ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ame siwo ƒe aʋawɔlawo le ame akpe blaene alafa atɔ̃ (40,500). ");
INSERT INTO ewe_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Manase ƒe to la naƒu asaɖa anyi ɖe wo xa. Manase ƒe viwo ƒe kplɔlae nye Gamaliel, Pedahzur ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ame siwo ƒe aʋawɔlawo le ame akpe blaetɔ̃-vɔ-eve, alafa eve (32,200). ");
INSERT INTO ewe_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Eye Benyamin ƒe to la nakpe ɖe wo ŋu. Benyamin ƒe viwo ƒe kplɔlae nye Abidan, Gideoni ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ame siwo ƒe aʋawɔlawo le ame akpe blaetɔ̃ vɔ atɔ̃, alafa ene (35,400). ");
INSERT INTO ewe_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Aʋawɔla, siwo katã le Efraim ƒe asaɖa me la le ame akpe alafa ɖeka kple enyi alafa ɖeka (108,100). Woawoe anye ha etɔ̃lia si aho. ");
INSERT INTO ewe_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Dan ƒe to la naƒu asaɖa anyi ɖe woƒe aflaga gbɔ le anyiehe lɔƒo. Dan ƒe viwo ƒe kplɔlae nye Ahiezer, Amisadai ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ame siwo ƒe aʋawɔlawo le ame akpe blaade-vɔ-eve, alafa adre (62,700). ");
INSERT INTO ewe_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Aser ƒe to la naƒu asaɖa anyi ɖe Dan ƒe viwo xa. Aser ƒe viwo ƒe kplɔlae nye Pagiel, Okran ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ame siwo ƒe aʋawɔlawo le ame akpe blaene-vɔ-ɖekɛ, alafa atɔ̃ (41,500). ");
INSERT INTO ewe_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Eye Naftali ƒe to la akpe ɖe Aser ƒe viwo ŋu. Naftali ƒe viwo ƒe kplɔlae nye Ahira, Enan ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ame siwo ƒe aʋawɔlawo le ame akpe blaatɔ̃-vɔ-etɔ̃, alafa ene (53,400). ");
INSERT INTO ewe_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Aʋawɔla, siwo katã le Dan ƒe asaɖa me la, le ame akpe alafa ɖeka blaatɔ̃-vɔ-adre, alafa ade (157,600). Woawoe anye hatsotso mamlɛtɔ, si aho le woƒe aflagawo nu. ");
INSERT INTO ewe_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Esiawoe nye ame siwo wotia, xlẽ le Israelviwo dome le woƒe aƒewo nu. Aʋawɔla, siwo katã le asaɖa vovovoawo me la ƒe ƒuƒoƒo le ame akpe alafa ade kple etɔ̃ alafa atɔ̃ blaatɔ̃ (603,550). ");
INSERT INTO ewe_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Ke wometia Levi ƒe viwo xlẽ kpe ɖe Israelvi bubuawo ŋu o, abe ale si Yehowa de se na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Eye Israelviwo wɔ, abe ale si Yehowa de se na Mose ene. Ale si woƒu asaɖa anyi la, nenema ŋu woho ɖo, ame sia ame kple eƒe ƒome le woƒe aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Esiawoe nye Aron kple Mose viwo, le ɣeyiɣi si me Yehowa ƒo nu na Mose le Sinai to la dzi la. ");
INSERT INTO ewe_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Viŋutsu enee nɔ Aron si. Woawoe nye Nadab, Via ŋutsu tsitsitɔ, Abihu, Eleaza kple Itamar. ");
INSERT INTO ewe_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Wosi ami na wo katã, eye woɖo wo nunɔlawoe. Woɖe wo ɖe aga be woawɔ subɔsubɔdɔwo le Agbadɔ la me. ");
INSERT INTO ewe_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ke Nadab kple Abihu ku le Yehowa ŋkume le Sinai gbedzi esi wowɔ dzo makɔmakɔ ŋu dɔ le vɔsasa na Yehowa me. Esi vi aɖeke menɔ wo si o ta la, Eleazar kple Itamar koe susɔ akpe ɖe wo fofo, Aron ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Eya ta Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Yɔ Levi ƒe viwo katã ƒo ƒu, eye nàtsɔ wo ana nunɔla Aron abe eƒe kpeɖeŋutɔwo ene. ");
INSERT INTO ewe_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Woawɔ nu siwo Aron aɖo na wo. Woawɔ dɔ kɔkɔewo le Agbadɔ la me ɖe Israelviwo katã nu, ");
INSERT INTO ewe_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Woakpɔ Agbadɔ la me nuwo kple Agbadɔ blibo la dzi ");
INSERT INTO ewe_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","elabena wotsɔ wo katã na Aron abe Israelviwo katã ƒe teƒenɔlawo ene. ");
INSERT INTO ewe_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ke Aron ƒe viŋutsuwo koe awɔ nunɔlawo ƒe dɔdeasiwo. Ame bubu ɖe sia ɖe si atɔ asi akɔ be yeawɔ nunɔlawo ƒe dɔ la, woawui.” ");
INSERT INTO ewe_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Metsɔ Levi ƒe viwo le Israelviwo dome ɖe Israel nyɔnu ɖe sia ɖe ƒe viŋutsu gbãtɔ teƒe. Levi ƒe viwo nye tɔnyewo. ");
INSERT INTO ewe_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Metsɔ wo ɖɔli viŋutsu tsitsitɔwo. Tso gbe si gbe mewu Egiptetɔwo ƒe viŋutsu ŋgɔgbetɔwo la, mexɔ Israel ƒe ŋgɔgbeviwo, amegbetɔwo tɔwo kple lãwo tɔwo siaa na ɖokuinye! Tɔnyewoe wonye; nyee nye Yehowa!” ");
INSERT INTO ewe_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yehowa gblɔ na Mose le Sinai gbegbe la be, ");
INSERT INTO ewe_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Xlẽ Levi ƒe viwo le woƒe ƒomewo kple towo nu. Xlẽ ŋutsu ɖe sia ɖe si xɔ ɣleti ɖeka alo wu nenema.” ");
INSERT INTO ewe_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Ale Mose xlẽ wo abe ale si Yehowa ƒe nya ɖo nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi ƒe viwo ƒe ŋkɔwoe nye: Gerson, Kohat kple Merari ");
INSERT INTO ewe_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gerson ƒe viwo ƒe ŋkɔwoe nye esiawo le woƒe ƒomewo nu: Libni kple Simei. ");
INSERT INTO ewe_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohat ƒe viwo nye esiawo le woƒe ƒomewo nu: Amram, Izhar, Hebron kple Uziel. ");
INSERT INTO ewe_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Eye Merari ƒe viwoe nye esiawo le woƒe ƒomewo nu: Mahli kple Musi. Esiawo nye Levi ƒe viwo ƒe ƒome le woƒe aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gerson hawo nye Libni kple Simei ƒe viwo ƒe ƒome. Woawoe nye Gerson ƒe ƒomeawo. ");
INSERT INTO ewe_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Wotia ŋutsu siwo xɔ dzinu ɖeka alo wu nenema la xlẽ le wo dome, eye woƒe xexlẽme le ame akpe adre, alafa atɔ̃ (7,500). ");
INSERT INTO ewe_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Eye Gerson ƒe ƒome la ƒu asaɖa anyi ɖe nɔƒe la megbe le ɣedzeƒe gome. ");
INSERT INTO ewe_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gerson ƒe ƒome la ƒe kplɔlae nye Eliasaf, Lael ƒe viŋutsu. ");
INSERT INTO ewe_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Gerson ƒe viwo ƒe hlɔ̃ eve siawo ƒe dɔdeasiwoe nye, woakpɔ nɔƒe kple agbadɔ la, la gbɔ, egbãnuwo, mɔnuwo kple eŋu vɔ, ");
INSERT INTO ewe_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","kpɔ si ƒo xlã nɔƒe la, vɔsamlekpui la kple ka siwo katã wotsɔ bla agbadɔ la ɖekae kple mɔnuvɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohat ƒe ƒomeawoe nye: Amram ƒe viwo, Izhar ƒe viwo, Hebron ƒe viwo kple Uziel ƒe viwo. ");
INSERT INTO ewe_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Ŋutsu siwo xɔ dzinu ɖeka alo wu nenema la ƒe xexlẽme le ame akpe enyi, alafa ade (8,600). Woawo nakpɔ kɔkɔeƒe la me nuwo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kohat ƒe ƒome la naƒu asaɖa anyi ɖe nɔƒe la ƒe axadzi le dzigbeme lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kohat ƒe ƒome la ƒe kplɔlae nye Elizafan, Uziel ƒe viŋutsu. ");
INSERT INTO ewe_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Levi ƒe viwo ƒe hlɔ̃ ene siawo ƒe dɔdeasiwoe nye, woakpɔ nubablaɖaka la, kplɔ̃ la, akaɖiti, vɔsamlekpui la ƒe nu vovovo siwo ŋu dɔ wowɔna le agbadɔ la me, xɔmetsovɔ kple nu siwo katã hiã be woadzra ɖo le nu siawo ŋu la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Eleazar, nunɔla Aron ƒe viŋutsu anye kplɔlawo katã ƒe tatɔ, eye kɔkɔeƒe la dzi kpɔkpɔ nye eƒe dɔ tɔxɛ. ");
INSERT INTO ewe_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari hawo nye: Mahli ƒe viwo ƒe ƒome kple Musi ƒe viwo ƒe ƒome. Woawoe nye Merari ƒe ƒomeawo. ");
INSERT INTO ewe_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Wo dome ŋutsu siwo xɔ dzinu ɖeka alo wu nenema la ƒe xexlẽme le ame akpe ade alafa eve (6,200). ");
INSERT INTO ewe_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Merari ƒe ƒome la ƒe kplɔlae nye Zuriel, Abihail ƒe viŋutsu; woawo naƒu asaɖa anyi ɖe agbadɔ la ƒe axadzi le anyiehe lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Levi ƒe viwo ƒe hlɔ̃ eve siawo ƒe dɔdeasie nye woakpɔ ati siwo wotsɔ tu Agbadɔ la, sɔtiwo kple woƒe zɔwo kple nu sia nu si wohiã na wo ŋu dɔ wɔwɔ la dzi, ");
INSERT INTO ewe_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","eye woagakpɔ sɔti siwo ƒo xlã xɔxɔnu la, woƒe zɔwo kple tsyotiwo kple kawo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Wotia teƒe si le agbadɔ la ƒe ɣedzeƒe la da ɖi na Mose kple Aron kple Aron ƒe viŋutsuwo ƒe agbadɔwo. Ame siawo ƒe dɔdeasie nye be woakpɔ be agbadɔ la dzi kpɔlawo wɔ woƒe dɔdeasiwo pɛpɛpɛ ɖe Israelviwo nu. Ame sia ame si menye nunɔla alo Levi ƒe vi o, gake wòge ɖe agbadɔ la me la, aku. ");
INSERT INTO ewe_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ale Levi ƒe viwo katã, siwo Mose kple Aron xlẽ abe ale si Yehowa gblɔ ene, eye woxɔ ɣleti ɖeka alo wu nenema la de ame akpe blaeve-vɔ-eve (22,000). ");
INSERT INTO ewe_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yehowa gblɔ na Mose be, “Azɔ la, xlẽ Israelviwo ƒe viŋutsu tsitsitɔwo, ame siwo xɔ ɣleti ɖeka alo wu nenema la, eye nàŋlɔ wo katã ŋkɔ. ");
INSERT INTO ewe_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Tsɔ Levi ƒe viwo nam ɖe Israelviwo ƒe ŋgɔgbeviwo katã teƒe, eye nàtsɔ Levi ƒe viwo ƒe lãhawo ƒe ŋgɔgbeviwo nam ɖe Israelviwo ƒe lãhawo ƒe ŋgɔgbeviwo katã teƒe. Nyee nye Yehowa.” ");
INSERT INTO ewe_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Ale Mose xlẽ Israelviwo ƒe viŋutsu tsitsitɔwo abe ale si Yehowa ɖo nɛ ene, ");
INSERT INTO ewe_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","eye wòkpɔ be viŋutsu tsitsitɔwo, ame siwo xɔ ɣleti ɖeka alo wu nenema la de akpe blaeve-vɔ-eve alafa eve blaadre-vɔ-etɔ̃ (22,273). ");
INSERT INTO ewe_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yehowa gagblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Tsɔ Levi ƒe viwo ɖɔli Israelviwo ƒe ŋgɔgbeviwo katã, eye nàtsɔ Levi ƒe viwo ƒe lãhawo aɖɔli Israelviwo tɔe. Levi ƒe viwo anye tɔnyewo; nyee nye Yehowa. ");
INSERT INTO ewe_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Be nàƒle Israelviwo ƒe ŋgɔgbevi alafa eve blaadre-vɔ-etɔ̃ (273), siwo sɔ gbɔ wu Levi ƒe viwo ta la, ");
INSERT INTO ewe_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ele be nàxɔ klosaloga gram blaatɔ̃ vɔ atɔ̃ ɖe wo dometɔ ɖe sia ɖe ta, ɖe kɔkɔeƒe la ƒe nudanu nu, si ƒe kpekpeme nye gram ewo. ");
INSERT INTO ewe_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Tsɔ ga si wona hena Israelvi mamlɛawo ɖeɖe la na Aron kple via ŋutsuwo.” ");
INSERT INTO ewe_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Ale Mose xɔ taƒlega ɖe Israelviwo ƒe viŋutsu tsitsitɔ alafa eve, blaadre-vɔ-etɔ̃, ame siwo wotsɔ wosɔ gbɔ wu Levi ƒe viwo ƒe xexlẽme la ta. ");
INSERT INTO ewe_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Ga si woxɔ le Israelviwo ƒe ŋgɔgbeviwo si la ƒe kpekpeme le klosalo kilogram wuiatɔ̃ kple afã (15.5) le kɔkɔeƒe la ƒe nudanu nu ");
INSERT INTO ewe_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mose tsɔ taƒlega la na Aron kple via ŋutsuwo abe ale si Yehowa ƒe nya de see nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yehowa gblɔ na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Mixlẽ Kohat ƒe viwo tso Levi ƒe viwo dome le woƒe towo kple ƒomewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Mixlẽ ŋutsu siwo xɔ tso ƒe blaetɔ̃ va se ɖe blaatɔ̃, eye woate ŋu awɔ dɔ le Agbadɔ la me. ");
INSERT INTO ewe_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Esiawoe nye Kohat ƒe viwo ƒe dɔ le agbadɔ la me: nu kɔkɔetɔwo dzi kpɔkpɔ. ");
INSERT INTO ewe_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Ne asaɖa la le hoho ge la, Aron kple via ŋutsuwo age ɖe Agbadɔ la me gbã. Woaɖe xɔmetsovɔ la, eye woatsɔe atsyɔ nubablaɖaka la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Emegbe la, woatsɔ tɔmenyigbalẽ atsyɔ xɔmetsovɔ la dzi, atsɔ aɖabɛ blɔtɔ atsyɔ tɔmenyigbalẽ la dzi, eye woatsɔ nubablaɖakakɔkpoawo aƒo ɖe eƒe gagodoeawo me. ");
INSERT INTO ewe_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Le esia megbe la, woatsɔ aɖabɛ blɔtɔ la akeke ɖe ŋkumeɖobolo la ƒe kplɔ̃ la dzi, eye woatsɔ agbawo, gatsiwo, trewo kple kpluwo kple abolo la ada ɖe avɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Woakeke avɔ dzĩtɔ ɖe nu siawo dzi, eye woatsɔ tɔmenyigbalẽ la atsyɔ aɖabɛ dzĩtɔ la dzi azɔ. Emegbe la, woatsɔ kplɔ̃kɔkpoawo ade kplɔ̃ la ƒe gagodoeawo me. ");
INSERT INTO ewe_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Nu si woagawɔ azɔe nye woatsɔ avɔ blɔtɔ atsyɔ akaɖiti la, akaɖigbɛawo, ɖovulãnuwo, nutɔgbawo kple amigoe la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ekema woatsɔ tɔmenyigbalẽ la atsyɔ nuawo katã dzi, eye woatsɔ nubabla blibo la ada ɖe agbati aɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Azɔ la, woatsɔ avɔ blɔtɔ atsyɔ sikavɔsamlekpui la dzi, atsɔ tɔmenyigbalẽ la atsyɔ eya hã dzi, eye woatsɔ kpoawo aƒo ɖe gagodoeawo me le vɔsamlekpui la ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Ekema woabla nu bubu siwo katã asusɔ ɖe agbadɔ la me la ɖe avɔ blɔtɔ aɖe me, atsɔ tɔmenyigbalẽ atsyɔ eya hã dzi, eye woada nubabla la ɖe agbati dzi. ");
INSERT INTO ewe_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Woalɔ dzowɔ le akɔblivɔsamlekpui la dzi, eye woatsɔ aɖabɛ dzĩtɔ atsyɔ na vɔsamlekpui la. ");
INSERT INTO ewe_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Woatsɔ nu siwo katã ŋu dɔ wowɔna le vɔsamlekpui la dzi la ada ɖe avɔ la dzi. Nu siawoe nye afilɔnuwo, gaflowo, sofiwo, zewo kple vɔsamlekpui la dzi nu bubuawo katã, eye woatsɔ tɔmenyigbalẽ atsyɔ wo dzi. Woatsɔ nukɔkpoawo ade woƒe gagodoeawo me. ");
INSERT INTO ewe_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Ne Aron kple via ŋutsuwo wu agbadodo kple nu kɔkɔeawo kple wo ŋunuwo katã nu vɔ, eye ameha la le klalo be yeaho adzo la, Kohat ƒe viwo ava akɔ agbawo. Ke womekpɔ mɔ aka asi nu kɔkɔeawo ŋu o, be womagaku o. Kohat ƒe viwo akɔ nu siwo katã le agbadɔ la me. ");
INSERT INTO ewe_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Nunɔla Aron ƒe viŋutsu, Eleazar, ƒe dɔdeasie nye wòakpɔ akaɖimemiwo, dzudzɔdonu ʋeʋĩwo, gbe sia gbe ƒe nuɖuvɔsa kple ami sisi la dzi. Kpuie ko la, eƒe dɔe nye wòakpɔ Agbadɔ blibo la kple nu siwo katã le eme la dzi.” ");
INSERT INTO ewe_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yehowa gblɔ na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Kpɔ egbɔ be womeɖe Kohat ƒomea ɖa le Levi ƒe viwo dome o. ");
INSERT INTO ewe_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Be woanɔ agbe, eye womaku o, ne wote ɖe nu kɔkɔewo ŋu la, miwɔ nu siawo na wo: Aron kple via ŋutsuwo ayi ɖe kɔkɔeƒe la, eye wòade dɔ si ame sia ame awɔ kple nu sia nu si wòakɔ la asi nɛ. ");
INSERT INTO ewe_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ne womekplɔ Kohat ƒe viŋutsuwo yi o la, mele be woage ɖe agbadɔ la me o; ne menye nenema o la, woakpɔ nu kɔkɔeawo le afi ma, eye woaku.” ");
INSERT INTO ewe_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Eye Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Xlẽ Gerson ƒe viŋutsuwo ɖe Levi ƒe viwo dome, ");
INSERT INTO ewe_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ame siwo xɔ tso ƒe blaetɔ̃ va se ɖe ƒe blaatɔ̃, eye wodze na dɔ kɔkɔe la wɔwɔ le agbadɔ la me. ");
INSERT INTO ewe_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Gerson viwo ƒe dɔdeasie nye be woakɔ: ");
INSERT INTO ewe_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Nɔƒe la ƒe xɔmetsovɔ, agbadɔ la ŋutɔ kple kpɔ si ƒo xlãe, gbɔ̃gbalẽ si wotsɔ gbã agbadɔ la kple avɔ si le eƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Woawoe akɔ kpɔ si ƒo xlã nɔƒe la ŋu vɔwo, agbonuvɔ si le nɔƒe si ƒo xlã vɔsamlekpui la kple agbadɔ la ƒe mɔnu ƒe vɔsamlekpui la, kawo kple wo ŋu nu bubuawo katã. Woawo ƒe dɔ wònye be woakɔ nu siawo. ");
INSERT INTO ewe_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aron alo via ŋutsuwo dometɔ ɖe sia ɖe ate ŋu ade dɔ siawo asi na Gerson ƒe viwo, ");
INSERT INTO ewe_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ke esiae nye Gerson viwo ƒe ƒome la ƒe dɔwo le agbadɔ la ŋu, eye woanɔ nunɔla Aron ƒe viŋutsu, Itamar ƒe dzikpɔkpɔ te. ");
INSERT INTO ewe_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Azɔ la, xlẽ Merari ƒe viŋutsuwo ɖe Levi ƒe viwo dome, ŋutsu siwo katã xɔ ƒe blaetɔ̃ va se ɖe blaatɔ̃, eye wodze na dɔwɔwɔ le Agbadɔ la me. ");
INSERT INTO ewe_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Xlẽ ŋutsu siwo katã xɔ tso ƒe blaetɔ̃ va se ɖe ƒe blaatɔ̃ le ame siwo va be yewoawɔ agbadɔ la ŋu dɔwo dome ");
INSERT INTO ewe_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Esiae nye woƒe dɔdeasi si woawɔ le agbadɔ la ŋuti dɔwo wɔwɔ me: woakɔ ʋuƒowo, gamedetiawo, sɔtiawo kple woƒe afɔwo, ");
INSERT INTO ewe_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","nɔƒe la ƒe kpɔ ƒe sɔtiwo kple zɔwo, tsyotiwo, kawo kple nu sia nu si ku ɖe wo ŋu dɔ wɔwɔ kple wo dzadzraɖo ŋu. De dɔ asi na ame sia ame wotɔxɛtɔxɛe. ");
INSERT INTO ewe_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Merari ƒe viwo hã awɔ dɔ le agbadɔ la ŋu le nunɔla Aron ƒe viŋutsu Itamar ƒe kpɔkplɔ te.” ");
INSERT INTO ewe_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Ale Mose kple Aron kple kplɔla bubuawo xlẽ Kohat ƒe viwo ");
INSERT INTO ewe_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","kple woƒe ŋutsu siwo xɔ tso ƒe blaetɔ̃ va se ɖe ƒe blaatɔ̃, ame siwo dze na dɔwɔwɔ le agbadɔ la me. ");
INSERT INTO ewe_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Wode ŋutsu akpe eve, alafa adre blaatɔ̃ (2,750). ");
INSERT INTO ewe_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Esiawo nye ame siwo katã Mose kple Aron tia xlẽ le Kohat viwo ƒe ƒome la me be woawɔ dɔ le agbadɔ la ŋu abe ale si Yehowa ɖo na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Eye wotia Gerson ƒe viwo xlẽ le woƒe ƒome kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Woxlẽ ame siwo katã xɔ ƒe blaetɔ̃ alo wu nenema la va se ɖe ƒe blaatɔ̃, eye woate ŋu awɔ dɔ le Mawu ƒe agbadɔ la ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Ame siwo wotia, xlẽ le woƒe ƒomewo kple aƒewo nu la le ame akpe eve alafa ade, blaetɔ̃ (2,630). ");
INSERT INTO ewe_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ame siawo nye ame siwo katã Mose kple Aron tia, xlẽ le Gerson ƒe viwo ƒe ƒome la me, eye woate ŋu awɔ dɔ le agbadɔ la ŋu abe ale si Yehowa de se ene. ");
INSERT INTO ewe_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Eye wotia amewo, xlẽ le Merari ƒe viwo ƒe ƒome la kple aƒewo nu. ");
INSERT INTO ewe_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Woxlẽ ame siwo katã xɔ ƒe blaetɔ̃ alo wu nenema la va se ɖe ƒe blaatɔ̃, eye woate ŋu awɔ dɔ le Mawu ƒe Agbadɔ la ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Ame siwo wotia, xlẽ le woƒe ƒomea nu la le ame akpe etɔ̃, alafa eve (3,200). ");
INSERT INTO ewe_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Esiawoe nye ame siwo Mose kple Aron wotia, xlẽ le Merari ƒe viwo ƒe ƒome la me abe ale si Yehowa de se na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Levi ƒe vi siwo katã Mose kple Aron kple Israel kplɔlawo wotia le woƒe ƒomewo kple aƒewo nu, ");
INSERT INTO ewe_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","eye woxɔ ƒe blaetɔ̃ alo wu nenema va se ɖe ƒe blaatɔ̃ be woasubɔ le Mawu ƒe agbadɔ la me, eye woakɔ agba la ");
INSERT INTO ewe_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ƒe xexlẽme le ame akpe enyi, alafa atɔ̃ blaenyi (8,580). ");
INSERT INTO ewe_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Mose na wofia ame sia ame ƒe dɔ kple agba si wòakɔ lae, abe ale si Yehowa de se ene. Eye wotia wo xlẽ abe ale si Yehowa de se na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Ɖe gbe na Israelviwo be woaɖe ame siwo katã nye anyidzelawo kple ame siwo katã ŋu tsi ƒomevi aɖe le dodom le kple ame siwo katã gblẽ kɔ ɖo le ame kuku aɖe ta la ɖa le asaɖa la me. ");
INSERT INTO ewe_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Woawɔ ŋutsuwo kple nyɔnuwo siaa nenema. Miɖe wo ɖa ale be womagblẽ kɔ ɖo na asaɖa la, afi si mele le mia dome la o.” ");
INSERT INTO ewe_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Ale Israelviwo wɔ Yehowa ƒe se la dzi eye woɖe ame siawo katã ɖa le asaɖa la me. ");
INSERT INTO ewe_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Gblɔ na Israelviwo be: ‘Ne ŋutsu alo nyɔnu da vo ɖe ame aɖe ŋu le mɔ aɖe nu eye wòto nu ma me meɖi anukware na Yehowa o la, ame ma ɖi fɔ. ");
INSERT INTO ewe_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Ele be wòaʋu eƒe nu vɔ̃ me eye wòaxe fe ɖe nu vɔ̃ si wòwɔ la ta. Gawu la, agbugbɔ nu la na nutɔ eye wòagatsɔ nu la ƒe home akpa atɔ̃lia ƒe ɖeka akpee na nutɔ la. ");
INSERT INTO ewe_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ke ne ame si ŋu wòwɔ nu vɔ̃ ɖo la ku eye eƒe ƒometɔ gobii aɖeke meli wòaxe fea na o la, ekema axee na Yehowa to nunɔla dzi eye wòagana alẽ ɖeka hena avuléle. ");
INSERT INTO ewe_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Nu kɔkɔe ɖe sia ɖe si Israelviwo atsɔ vɛ na nunɔla aɖe la, anye nunɔlaa tɔ. ");
INSERT INTO ewe_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Ame sia ame ƒe nu kɔkɔewo nye eya ŋutɔ tɔ, ke esi wòatsɔ na nunɔla la, anye nunɔla la tɔ.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Eye Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Ne ŋutsu aɖe srɔ̃ tra mɔ, meɖi anukware nɛ o, ");
INSERT INTO ewe_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","eye ŋutsu bubu de asi eŋu, nu sia le ɣaɣla ɖe srɔ̃a, eye womenya be egblẽ kɔ ɖo o (elabena ɖasefo aɖeke meli ɖe eŋu o, eye womelée asiasi o), ");
INSERT INTO ewe_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ne ŋutsu la le ŋu ʋãm, eye wòbu be ye srɔ̃ gblẽ kɔ ɖo, alo ne eʋã ŋu togbɔ be srɔ̃a megblẽ kɔ ɖo o hã la, ");
INSERT INTO ewe_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ele be ŋutsu la nakplɔ srɔ̃a ayi nunɔla gbɔ. Nu si wòana nunɔla ɖe srɔ̃a tae nye luwɔ lita ɖeka. Womakɔ ami kple dzudzɔdonu ɖe edzi o, elabena enye nuɖuvɔsa ɖe ŋuʋaʋã ta kple ŋkuɖodzivɔsa si ahe woƒe susu ayi ɖe fɔɖiɖi gbɔe. ");
INSERT INTO ewe_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Nunɔla la akplɔ nyɔnu la ayi Yehowa ŋkume, ");
INSERT INTO ewe_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","aku tsi kɔkɔe ɖe anyikplu aɖe me, eye wòaku agbadɔ la me ke akɔ ɖe tsi la me. ");
INSERT INTO ewe_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Ne nunɔla la na nyɔnu la tsi tsitre ɖe Yehowa ŋkume vɔ la, akaka ɖa ɖe ta na nyɔnu la, atsɔ ŋkuɖodzivɔsa kple nuɖuvɔsa na ŋuʋaʋã ade nyɔnu la ƒe asi me. Ke nunɔla la ŋutɔ alé tsi veve si hea fiƒode vaa ame dzi la ɖe asi. ");
INSERT INTO ewe_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Nunɔla la ana nyɔnu la naka atam, eye wòagblɔ nɛ be, “Ne ŋutsu bubu aɖeke medɔ kpli wò o, ne mèda afɔ, hegblẽ kɔ ɖo na ɖokuiwò esi nèle atsuƒe na srɔ̃wò o la, ekema tsi veve sia, si hea fiƒode vaa ame dzi la, megagblẽ nu le ŋutiwò o. ");
INSERT INTO ewe_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ke ne èda afɔ esime nèle srɔ̃wò gbɔ, nègblẽ kɔ ɖo, eye ŋutsu bubu, ame si menye srɔ̃wò o la de asi ŋuwò la,” ");
INSERT INTO ewe_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ekema nunɔla la aka atam agblɔ fiƒodenyawo na nyɔnu la be, “Yehowa nana wò amewo naƒo fi ade wò, eye woagbe nu le gbɔwò; nena be wò ataŋuyi naflo ɖa, eye ƒo nadzi ɖe nuwò. ");
INSERT INTO ewe_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Tsi sia si hea fiƒode vaa ame dzi la nage ɖe lãme na wò ale be wò ƒodo nate ɖe nuwò, eye wò ataŋuyi naflo ɖa.” “ ‘Ekema nyɔnu la axɔ ɖe edzi be, “Amen, neva eme nenema.” ");
INSERT INTO ewe_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Ekema nunɔla la aŋlɔ fiƒode siawo ɖe agbalẽ me, eye wòakpala nuŋɔŋlɔ la ɖe tsi veve la me. ");
INSERT INTO ewe_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Nunɔla la ana nyɔnu la nano tsi veve si hea fiƒode vaa ame dzi la, tsi sia age ɖe eƒe lãme, eye wòana fukpekpe kple vevesese nava eya amea dzi. ");
INSERT INTO ewe_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Le esia megbe la, nunɔla la axɔ nuɖuvɔsa na ŋuʋaʋã le nyɔnu la si, anyee le yame le Yehowa ŋkume, eye wòatsɔe ada ɖe vɔsamlekpui la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Nunɔla la aku nuɖuvɔsa la ƒe asiʋlo ɖeka abe ŋkuɖodzivɔsa ene, eye wòatɔ dzoe le vɔsamlekpui la dzi. Azɔ la, ana nyɔnu la nano tsi la. ");
INSERT INTO ewe_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ne nyɔnu la gblẽ kɔ ɖo, eye meto nyateƒe na srɔ̃a o, evɔ wona wòno tsi si hea fiƒode vaa ame dzi la, tsi la age ɖe eƒe lãme, eye wòase veve vevie. Eƒe ƒodo adzi ɖe enu, eƒe ataŋulã aflo ɖa, eye wòazu ɖiŋudonu le eƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ke ne nyɔnu la megblẽ kɔ ɖo o, eye wòdza la, woatso afia nɛ, eye wòagate ŋu adzi vi. ");
INSERT INTO ewe_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Esiae nye ŋuʋaʋãŋutise ne nyɔnu aɖe da afɔ, eye wògblẽ kɔ ɖo, esi wòle atsuƒe, ");
INSERT INTO ewe_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","alo ne ŋuʋaʋã xɔ ŋutsu aɖe me, elabena ebu nazã ɖe srɔ̃a ŋu. Nunɔla la ana nyɔnu la natsi tsitre ɖe Yehowa ŋkume, eye wòawɔ se sia katã me dɔ na nyɔnu la. ");
INSERT INTO ewe_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Womaɖe agɔdzedze aɖeke na srɔ̃ŋutsu la o, gake nu vɔ̃ yomedzenu anɔ nyɔnu la dzi.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Ne ŋutsu aɖe alo nyɔnu aɖe di be yeaɖe adzɔgbe tɔxɛ aɖe hekɔ eɖokui ŋu na Yehowa abe Nazaritɔ ene la, ");
INSERT INTO ewe_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","mele nɛ be wòano wain alo nu muame aɖeke alo aha sesẽ si wowɔ tso wain me alo aha si wotsɔ ɖo ƒãe o. Mano waintsetse me tsi alo aɖu waintsetse o. ");
INSERT INTO ewe_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Ŋkeke ale si wònye Nazaritɔ ko la, maɖu naneke si do tso waintsetse me o; maɖu kuawo alo tsroa gɔ̃ hã o. ");
INSERT INTO ewe_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Le ɣeyiɣi mawo katã me la, mele be wòako ta alo alũ ge gɔ̃ hã o, elabena enye ame kɔkɔe, eye wokɔ eŋuti na Yehowa. Eya ta ele nɛ be wòagblẽ eƒe ɖa ɖi wòato ʋluyaa. ");
INSERT INTO ewe_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘Le ɣeyiɣi si me wòɖe eɖokui ɖe aga na Yehowa la, mate ɖe ame kuku ŋu o. ");
INSERT INTO ewe_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Ne eya ŋutɔ fofoa alo dadaa alo nɔvia ŋutsu alo nɔvia nyɔnu gɔ̃ hã ku la, magblẽ kɔ ɖo na eɖokui le wo ta o, elabena eƒe ɖokuitsɔtsɔ na Mawu ƒe dzesi le ta dzi nɛ, ");
INSERT INTO ewe_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","eye wokɔ eŋuti na Yehowa to ɣeyiɣi la katã me. ");
INSERT INTO ewe_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Ne ame aɖe ku le exa la, ame kuku la gblẽ kɔ ɖo nɛ, ekema ako ta le ŋkeke adre megbe. Ekema eŋuti akɔ tso ale si amea nɔ egbɔ hafi ku la ta. ");
INSERT INTO ewe_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Le ŋkeke enyilia gbe la, ele be wòatsɔ akpakpa eve alo ahɔnɛvi eve ayi na nunɔla le agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Nunɔla la atsɔ xeviawo dometɔ ɖeka asa nu vɔ̃ vɔsa, eye wòatsɔ evelia asa numevɔe. Ale wòalé avu le ale si wògblẽ kɔ ɖoe la ta. Agbugbɔ eƒe adzɔgbe la aɖe gbe ma gbe, eye wòana eƒe ɖa nagade asi toto me. ");
INSERT INTO ewe_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Ŋkeke siwo wòwɔ eƒe adzɔgbeɖeɖe dzi hafi gblẽ kɔ ɖo la, megale eme o. Ele nɛ be wòagadze eƒe adzɔgbeɖeɖe la dzi wɔwɔ gɔme kple eƒe adzɔgbe yeye la, eye wòana alẽ si xɔ ƒe ɖeka hena eƒe nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Ne adzɔgbe si wòɖe be yeaɖe ye ɖokui ɖe aga na Yehowa ƒe ɣeyiɣi wu enu la, ele be wòayi agbadɔ la ƒe mɔnu, ");
INSERT INTO ewe_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","eye wòasa numevɔ na Yehowa kple alẽ si xɔ ƒe ɖeka, eye wòde blibo. Ele be wòagana alẽnɔ si xɔ ƒe ɖeka, eye wòde blibo hena nu vɔ̃ ŋuti vɔsa kple agbo ɖeka si de blibo la na ŋutifafavɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Kpe ɖe esiawo ŋu la, agana abolo si wowɔ kple amɔ maʋamaʋã kusi ɖeka, akpɔnɔ siwo wowɔ kple wɔ memee si dzi wokɔ ami ɖo, aboŋgo si wowɔ kple wɔ maʋamaʋã si dzi wokɔ ami ɖo, eye wòagatsɔ nuɖuvɔsa kple nunovɔsa akpe ɖe nu siawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Nunɔla la atsɔ nunana siawo ada ɖe Yehowa ŋkume. Atsɔ nu vɔ̃ ŋuti vɔsa la ana gbã, emegbe la, wòana numevɔsa la. ");
INSERT INTO ewe_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Le esiawo megbe la, atsɔ agbo la hena ŋutifafavɔsa na Yehowa kple abolo maʋamaʋã la ƒe kusi, eye wòawu enu kple nuɖuvɔsa la kple nunovɔsa la. ");
INSERT INTO ewe_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Azɔ la, adzɔgbeɖela la ako eƒe ɖa ʋluya la, si nye eƒe adzɔgbeɖeɖe ƒe dzesi. Awɔ nu sia le agbadɔ la ƒe mɔnu. Le esia megbe la, woatsɔ ɖa si wòko la ade dzo me le ŋutifafavɔsa la te. ");
INSERT INTO ewe_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Le takoko na adzɔgbeɖela la megbe la, nunɔla la atsɔ agbo la ƒe abɔ memee, abolo maʋamaʋãwo kple aboŋgo maʋamaʋãwo dometɔ ɖeka, eye wòatsɔ wo katã ade asi na adzɔgbeɖela la. ");
INSERT INTO ewe_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Nunɔla la anye wo katã le yame, tso afii yi afi mɛ le Yehowa ŋkume abe vɔsa ene. Wonye nunana kɔkɔe na nunɔla la kpe ɖe eƒe axa kple abɔ siwo wònye le yame le Yehowa ŋkume la ŋuti. Le esia megbe la, adzɔgbeɖela la ate ŋu ano wain azɔ, elabena evo tso eƒe adzɔgbeɖeɖe me. ");
INSERT INTO ewe_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Esiawoe nye se siwo ku ɖe ame si ɖe adzɔgbe be yeaɖe ye ɖokui ɖe aga ɣeyiɣi aɖe na Yehowa kple eƒe vɔsawo ne ɣeyiɣi la wu enu la ŋu. Hekpe ɖe vɔsa siawo ŋu la, ele be adzɔgbeɖela la nagana nu bubu siwo ŋugbe wòdo le eƒe adzɔgbeɖeɣi.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Eye Yehowa ƒo nu kple Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Gblɔ na Aron kple via ŋutsuwo be: ‘Ale miayra Israelviwo, agblɔe nye esi: ");
INSERT INTO ewe_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “Yehowa ayra wò, eye wòakpɔ dziwò! ");
INSERT INTO ewe_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yehowa akɔ ŋkume ɖe wò, eye wòave nuwò! ");
INSERT INTO ewe_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Yehowa atrɔ mo ɖe gbɔwò, eye wòana ŋutifafa wò.” ’ ");
INSERT INTO ewe_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Ale woayɔ nye ŋkɔ atɔ ɖe Israelviwo ŋu, eye mayra wo.” ");
INSERT INTO ewe_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Esi Mose wu agbadɔ la tutu nu la, esi ami nɛ, eye wòkɔ eya kple eŋunuwo katã ŋuti. Esi ami na vɔsamlekpui la hã, kɔ eŋuti kple eŋunuwo katã ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Israel ƒe kplɔlawo, ƒometatɔ, ame siwo nye kplɔlawo kple dzikpɔlawo na ame siwo woxlẽ la wɔ nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Wotsɔ woƒe nunanawo vɛ na Yehowa le tasiaɖam ade siwo dzi wotsyɔ nui la me. Nyitsu eve he tasiaɖam ɖe sia ɖe. Wotsɔ tasiaɖam ɖeka na kplɔla eve, nyitsu ɖeka na kplɔla ɖe sia ɖe, eye wotsɔ wo na Yehowa le Agbadɔ la ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Eye Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Xɔ woƒe nu siawo be woatsɔ wo awɔ agbadɔ la ŋuti dɔwoe. Tsɔ wo na Levi ƒe viwo abe ale si ame sia ame ƒe dɔ hiã lae ene.” ");
INSERT INTO ewe_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Ale Mose tsɔ tasiaɖamwo kple nyitsuawo na Levi ƒe viwo. ");
INSERT INTO ewe_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Etsɔ tasiaɖam eve kple nyitsu ene na Gerson ƒe viwo, ");
INSERT INTO ewe_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","eye wòtsɔ tasiaɖam ene kple nyitsu enyi na Merari ƒe viwo, ame siwo nɔ Itamar, nunɔla Aron ƒe viŋutsu ƒe kpɔkplɔ te. ");
INSERT INTO ewe_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Wometsɔ tasiaɖamuawo kple nyitsuawo dometɔ aɖeke na Kohat ƒe viwo o, elabena woƒe dɔdeasie nye be woakɔ agbadɔ la ƒe akpa siwo woakɔ la ɖe abɔta. ");
INSERT INTO ewe_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Kplɔlawo hã na nunanawo ɖe nuŋukɔkɔ la ta le gbe si gbe wosi ami na vɔsamlekpui la. Woda nunanawo ɖe vɔsamlekpui la ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yehowa gblɔ na Mose be, “Mina ameawo natsɔ woƒe nunanawo vɛ le ŋkeke vovovowo dzi hena vɔsamlekpui la ŋu kɔkɔ.” ");
INSERT INTO ewe_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Ale Nahson, Aminadab ƒe viŋutsu, tso Yuda ƒe to la me tsɔ eƒe nunanawo vɛ le ŋkeke gbãtɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Eƒe nunana siwo wòtsɔ vɛ la woe nye: klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka. Wotsɔ nuɖuvɔsanu, si nye wɔ memee si wobaka kple ami la de agba la kple ze la me. ");
INSERT INTO ewe_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Egatsɔ sikanutɔgba sue ɖeka si ƒe kpekpeme le gram alafa ɖeka kple ewo, si dzudzɔdonu yɔ banaa la vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi, si xɔ ƒe ɖeka la vɛ hena numevɔsa, ");
INSERT INTO ewe_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","eye wògatsɔ gbɔ̃tsu ɖeka vɛ na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Kpe ɖe nu siawo ŋuti la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃ siwo xɔ ƒe ɖeka ɖeka la vɛ na ŋutifafavɔsa. Esiae nye Aminadab ƒe vi, Nahson ƒe vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Esi ŋu ke la, Netanel, Zuar ƒe viŋutsu, Isaka ƒe to la ƒe kplɔla tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Nu siwo wòna la woe nye klosalogba ɖeka, si ƒe kpekpeme nye gram blaeve kple afã kple klosalogba ɖeka si ƒe kpekpeme nye gram alafa enyi. Wotsɔ nuɖuvɔsanu si nye wɔ memee si wobaka kple ami la de agba la kple ze la me. ");
INSERT INTO ewe_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Egatsɔ sikanutɔgba sue ɖeka si ƒe kpekpeme le gram alafa ɖeka kple ewo si yɔ banaa kple dzudzɔdonu, ");
INSERT INTO ewe_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","kple nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka, si xɔ ƒe ɖeka la vɛ hena numevɔsa, ");
INSERT INTO ewe_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","eye wògatsɔ gbɔ̃tsu ɖeka vɛ na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Kpe ɖe nu siawo ŋuti la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃, siwo xɔ ƒe ɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Netanel, Zuar ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Le ŋkeke etɔ̃a gbe la, Eliab, Helon ƒe viŋutsu, Zebulon ƒe to la kplɔla tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Nu siwo wòna la woe nye klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba ɖeka, si ƒe kpekpeme nye gram alafa enyi. Wotsɔ nuɖuɖuvɔsanu, si nye wɔ memee si wobaka kple ami la de agba la kple ze la me; ");
INSERT INTO ewe_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","sikanutɔgba sue ɖeka, si ƒe kpekpeme le gram alafa ɖeka kple ewo, si dzudzɔdonu yɔ banaa la vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka, si xɔ ƒe ɖeka hena numevɔsa, ");
INSERT INTO ewe_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","eye wògatsɔ gbɔ̃tsu ɖeka na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Kpe ɖe nu siawo ŋuti la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃ siwo xɔ ƒe ɖekaɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Eliab, Helon ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Le ŋkeke enea gbe la, Elizur, Sedeur ƒe viŋutsu, Ruben ƒe to la ƒe kplɔla tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Nu siwo wòna la woe nye klosalogba ɖeka si ƒe kpekpeme nye kilogram alafa ɖeka blaasiekɛ-vɔ-ɖekɛ kple afã kple klosalogba ɖeka si ƒe kpekpeme nye gram alafa enyi. Wotsɔ nuɖuvɔsanu si nye wɔ memee si wobaka kple ami la de agba la kple ze la me; ");
INSERT INTO ewe_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","sikanutɔgba sue ɖeka si ƒe kpekpeme le gram alafa ɖeka kple ewo, si yɔ banaa kple dzudzɔdonu; ");
INSERT INTO ewe_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka, si xɔ ƒe ɖeka la vɛ hena numevɔsa; ");
INSERT INTO ewe_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","eye wògatsɔ gbɔ̃tsu ɖeka vɛ na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Hekpe ɖe nu siawo ŋu la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃, siwo xɔ ƒe ɖeka ɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Elizur, Sedeur ƒe viŋutsu, ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Le ŋkeke atɔ̃a gbe la, Selumiel, Zurisadai ƒe viŋutsu, Simeon ƒe to la ƒe kplɔla, tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Nu siwo wòna la woe nye klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba ɖeka si ƒe kpekpeme nye gram alafa enyi. Wotsɔ nuɖuvɔsanu si nye wɔ memee si wobaka kple ami la de agba la kple ze la me. ");
INSERT INTO ewe_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Egatsɔ sikanutɔgba sue ɖeka si ƒe kpekpeme le gram alafa ɖeka kple ewo, si yɔ banaa kple dzudzɔdonu; ");
INSERT INTO ewe_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi si xɔ ƒe ɖeka la vɛ hena numevɔsa; ");
INSERT INTO ewe_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","eye wògatsɔ gbɔ̃tsu ɖeka vɛ na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Hekpe ɖe nu siawo ŋuti la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃ siwo xɔ ƒe ɖeka ɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Selumiel, Zurisadai ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Le ŋkeke adea gbe la, Eliasaf, Deguel ƒe viŋutsu, Gad ƒe to la ƒe kplɔla, tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Nu siwo wòna la woe nye klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba ɖeka si ƒe kpekpeme nye gram alafa enyi. Wotsɔ nuɖuvɔsanu si nye wɔ memee si wobaka kple ami la de agba la kple ze la me; ");
INSERT INTO ewe_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","sikanutɔgba sue ɖeka, si ƒe kpekpeme le gram alafa ɖeka kple ewo, si yɔ banaa kple dzudzɔdonu; ");
INSERT INTO ewe_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka, si xɔ ƒe ɖeka la vɛ hena numevɔsa; ");
INSERT INTO ewe_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","eye wògatsɔ gbɔ̃tsu ɖeka na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Kpe ɖe nu siawo ŋuti la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃, siwo xɔ ƒe ɖekaɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Eliasaf, Deguel ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Le ŋkeke adrea gbe la, Elisama, Amihud ƒe viŋutsu, Efraim ƒe to la kplɔla, tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Nu siwo wòna la woe nye klosalogba ɖeka, si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba ɖeka, si ƒe kpekpeme nye gram alafa enyi. Wotsɔ nuɖuvɔsanu, si nye wɔ memee si wobaka kple ami la de agba la kple ze la me. ");
INSERT INTO ewe_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Egatsɔ sikanutɔgba sue ɖeka, si ƒe kpekpeme nye gram alafa ɖeka kple ewo, si dzudzɔdonu yɔ banaa la vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka, si xɔ ƒe ɖeka la vɛ hena numevɔsa, ");
INSERT INTO ewe_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","eye wògatsɔ gbɔ̃tsu ɖeka vɛ na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Kpe ɖe nu siawo ŋuti la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃ siwo xɔ ƒe ɖeka ɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Elisama, Amihud ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Le ŋkeke enyia gbe la, Gamaliel, Pedahzur ƒe viŋutsu, Manase ƒe to la kplɔla, tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Nu siwo wòna la woe nye klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba ɖeka si ƒe kpekpeme nye gram alafa enyi. Wotsɔ nuɖuvɔsanu si nye wɔ memee si wobaka kple ami la de agba la kple ze la me; ");
INSERT INTO ewe_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","sikanutɔgba sue ɖeka si ƒe kpekpeme le gram alafa ɖeka kple ewo, si dzudzɔdonu yɔ banaa la vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka, si xɔ ƒe ɖeka la, vɛ hena numevɔsa, ");
INSERT INTO ewe_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","eye wògatsɔ gbɔ̃tsu ɖeka vɛ na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Kpe ɖe nu siawo ŋu la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃ siwo xɔ ƒe ɖekaɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Gamaliel, Pedahzur ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Le ŋkeke asiekɛa gbe la, Abidan, Gideoni ƒe viŋutsu, Benyamin ƒe to la kplɔla, tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Nu siwo wòna la woe nye klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba ɖeka si ƒe kpekpeme nye gram alafa enyi. Wotsɔ nuɖuvɔsanu si nye wɔ memee si wobaka kple ami la de agba la kple ze la me; ");
INSERT INTO ewe_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","sikanutɔgba sue ɖeka, si ƒe kpekpeme nye gram alafa ɖeka kple ewo, si yɔ banaa kple dzudzɔdonu; ");
INSERT INTO ewe_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka, si xɔ ƒe ɖeka la, vɛ hena numevɔsa, ");
INSERT INTO ewe_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","eye wògatsɔ gbɔ̃tsu ɖeka vɛ na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Kpe ɖe nu siawo ŋu la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃, siwo xɔ ƒe ɖeka ɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Abidan, Gideoni ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Le ŋkeke ewoa gbe la, Ahiezer, Amisadai ƒe viŋutsu, Dan ƒe to la ƒe kplɔla tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Nu siwo wòna la woe nye klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba ɖeka, si ƒe kpekpeme nye gram blaenyi. Wotsɔ nuɖuvɔsanu, si nye wɔ memee si wobaka kple ami la de agba la kple ze la me; ");
INSERT INTO ewe_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","sikanutɔgba sue ɖeka, si ƒe kpekpeme le gram alafa ɖeka kple ewo, si dzudzɔdonu yɔ banaa la vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka, si xɔ ƒe ɖeka la vɛ hena numevɔsa, ");
INSERT INTO ewe_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","eye wògatsɔ gbɔ̃tsu ɖeka vɛ na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Hekpe ɖe nu siawo ŋuti la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃ siwo xɔ ƒe ɖeka ɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Ahiezer, Amisadai ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Le ŋkeke wuiɖekɛa gbe la, Pagiel, Okran ƒe viŋutsu, Aser ƒe to la ƒe kplɔla tsɔ eƒe nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Nu siwo wòna la woe nye klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba ɖeka, si ƒe kpekpeme nye gram blaenyi. Wotsɔ nuɖuvɔsanu, si nye wɔ memee si wobaka kple ami la de agba la kple ze la me; ");
INSERT INTO ewe_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","sikanutɔgba sue ɖeka, si ƒe kpekpeme nye gram alafa ɖeka kple ewo, si yɔ banaa kple dzudzɔdonu; ");
INSERT INTO ewe_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka, si xɔ ƒe ɖeka la vɛ hena numevɔsa, ");
INSERT INTO ewe_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","eye wògatsɔ gbɔ̃tsu ɖeka na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Kpe ɖe nu siawo ŋuti la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃ siwo xɔ ƒe ɖekaɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Pagiel, Okran ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Le ŋkeke wuievea gbe la, Ahira, Enan ƒe viŋutsu, Naftali ƒe to la ƒe kplɔla, tsɔ nunanawo vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Nu siwo wòna la woe nye klosalogba ɖeka si ƒe kpekpeme nye kilogram ɖeka kple afã kple klosalogba si ƒe kpekpeme nye gram alafa enyi. Wotsɔ nuɖuvɔsanu, si nye wɔ memee si wobaka kple ami la de agba kple ze la me; ");
INSERT INTO ewe_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","sikanutɔgba sue ɖeka si ƒe kpekpeme nye gram alafa ɖeka kple ewo, si dzudzɔdonu yɔ banaa la vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Etsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi ɖeka si xɔ ƒe ɖeka la vɛ hena numevɔsa, ");
INSERT INTO ewe_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","eye wògatsɔ gbɔ̃tsu ɖeka vɛ na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Hekpe ɖe nu siawo ŋuti la, egatsɔ nyitsu eve, agbo atɔ̃, gbɔ̃tsu atɔ̃ kple agbovi atɔ̃, siwo xɔ ƒe ɖeka ɖeka la vɛ na ŋutifafavɔsa. Esiawoe nye Ahira, Enan ƒe viŋutsu ƒe nunanawo. ");
INSERT INTO ewe_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Nu siwo Israel ƒe towo ƒe kplɔlawo na be woatsɔ akɔ vɔsamlekpui la ŋu, esi wosi ami nɛ lae nye: klosalogba wuieve, klosalogba wuieve kple sikanutɔgba wuieve. ");
INSERT INTO ewe_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Klosalogbawo dometɔ ɖe sia ɖe ƒe kpekpemee nye kilogram ɖeka kple afã, eye klosalogbaawo dometɔ ɖe sia ɖe ƒe kpekpemee nye kilogram ɖeka kple afã; wo katã ƒe kpekpemee nye kilogram blaeve-vɔ-adre kple afã; ");
INSERT INTO ewe_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","sikanutɔgba wuieve siwo dzudzɔdonu yɔ banaa, nutɔgba ɖeka ƒe kpekpemee nye gram blaeve-vɔ-enyi, wo katã ƒe kpekpemee nye kilogram ɖeka kple afã. ");
INSERT INTO ewe_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Lã siwo katã wotsɔ vɛ hena numevɔsa la le nyi wuieve, agbo wuieve, agbovi wuieve siwo xɔ ƒe ɖekaɖeka, hekpe ɖe wo ŋu nuɖuvɔsanuwo ŋu; gbɔ̃tsu wuieve siwo woatsɔ awɔ nu vɔ̃ ŋuti vɔsae. ");
INSERT INTO ewe_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Lã siwo katã woatsɔ asa akpedavɔe la le nyitsu blaeve-vɔ-ene, agbo blaade, gbɔ̃tsu blaade kple agbovi blaade, siwo xɔ ƒe ɖekaɖeka. Ale si wokɔ vɔsamlekpui la ŋu, le esime wosi ami nɛ lae nye esi. ");
INSERT INTO ewe_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Esi Mose yi agbadɔ la me be yeaƒo nu kple Mawu la, ese Gbe la wònɔ nu ƒom nɛ tso teƒe si le nubablaɖaka la ƒe amenuvevezikpui la tame le Kerubi eveawo tame. ");
INSERT INTO ewe_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Ƒo nu na Aron, eye nàgblɔ nɛ be, ‘Ne ètsɔ akaɖi adreawo da ɖe akaɖiti la dzi la, ele be woaklẽ ɖe teƒe si le akaɖiti la ŋgɔ.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aron wɔ esia. Eɖo akaɖigbea atiawo dzi ɖe ɖoɖo siwo Yehowa na Mose nu tututu. ");
INSERT INTO ewe_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Wotsɔ sika wɔ akaɖiti la kple seƒoƒowo ɖe akaɖiti la ƒe zɔ kple alɔdzeawo ŋu. Wowɔ akaɖitiawo abe ale si Yehowa fia Mose ene. ");
INSERT INTO ewe_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Ɖe Levi ƒe viwo ɖa le Israelvi bubuawo dome, eye nàkɔ wo ŋu to mɔ sia dzi. ");
INSERT INTO ewe_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Hlẽ tsi kɔkɔe la ɖe wo ŋu, eye nàna woawo ŋutɔ nalũ woƒe ŋutifuwo katã, eye woanya woƒe awuwo, ekema woanɔ kɔkɔe. ");
INSERT INTO ewe_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Na woatsɔ nyitsuvi aɖe kple nuɖuvɔsanu si nye wɔ memee si wobaka kple ami la kple nyitsu bubu na nu vɔ̃ ŋuti vɔsa vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Ekema, nàkplɔ Levi ƒe viwo va Agbadɔ la ƒe mɔnu eye naƒo Israelviwo ƒe ha blibo la nu ƒu. ");
INSERT INTO ewe_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Le afi ma la, nana Levitɔ nava Yehowa ƒe ŋkume eye Israelviwo ada asi ɖe wo dzi, ");
INSERT INTO ewe_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","ato tsɔtsɔna ƒe dzesiwo me, atsɔ wo ana Yehowa abe nunana tso Israel dukɔ blibo la gbɔ ene. Levi ƒe viwo anɔ Israelviwo katã teƒe le Yehowa subɔsubɔ me. ");
INSERT INTO ewe_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Le esia megbe la, Levi ƒe viwo ƒe kplɔlawo ada woƒe asiwo ɖe nyitsuvi eveawo ƒe tawo dzi, eye woatsɔ wo ana le Yehowa ŋkume. Woatsɔ ɖeka asa nu vɔ̃ vɔsa, eye woatsɔ evelia asa numevɔ be woalé avu ɖe Levi ƒe viwo nu. ");
INSERT INTO ewe_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Ekema woatsɔ Levi ƒe viwo ana Aron kple via ŋutsuwo abe ale si wotsɔa nu bubu ɖe sia ɖe si wodi be woana Yehowa la naa nunɔlawo ene! ");
INSERT INTO ewe_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Eya ta nàtia Levi ƒe viwo ɖa le Israelvi bubuawo katã dome, eye Levi ƒe viwo azu tɔnye. ");
INSERT INTO ewe_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Ne èkɔ wo ŋuti, eye nètsɔ wo nam le mɔ sia nu vɔ la, woate ŋu age ɖe agbadɔ la me hena woƒe subɔsubɔdɔwo wɔwɔ. ");
INSERT INTO ewe_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Wonye tɔnyewo le Israelviwo katã dome. Mexɔ wo ɖe Israelviwo ƒe viŋutsu gbãtɔwo katã teƒe; mexɔ Levi ƒe viwo abe teƒenɔlawo ene. ");
INSERT INTO ewe_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Israelviwo ƒe viŋutsu ŋgɔgbetɔwo kple woƒe lãwo ƒe vi ŋgɔgbetɔwo katã nye tɔnyewo. Metsɔ wo na ɖokuinye le zã si me mewu Egiptetɔwo ƒe ŋgɔgbeviwo katã. ");
INSERT INTO ewe_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ɛ̃, mexɔ Levi ƒe viwo ɖe Israelviwo ƒe viŋutsu tsitsiwo katã teƒe. ");
INSERT INTO ewe_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Matsɔ Levi ƒe viwo ake Aron kple via ŋutsuwo abe nunana ene. Levi ƒe viwo awɔ dɔ kɔkɔe siwo wohiã tso Israelviwo si be woawɔ le agbadɔ la me, woatsɔ nu siwo amewo na la asa vɔwoe, eye woalé avu ɖe wo nu. Dɔvɔ̃ mato le Israelviwo dome abe ale si wòanɔ ene ne ame siwo menye Levi ƒe viwo o la ge ɖe agbadɔ la me ene o.” ");
INSERT INTO ewe_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Ale Mose kple Aron kpakple Israelviwo katã wotsɔ Levi ƒe viwo na Yehowa le se si wòde na Mose la nu. ");
INSERT INTO ewe_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levi ƒe viwo kɔ wo ɖokuiwo ŋu, eye wonya woƒe awuwo. Aron to tsɔtsɔna ƒe dzesiwo me tsɔ wo na Yehowa. Ewɔ avuléle ƒe wɔnawo ɖe wo ta hekɔ wo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Le esia megbe la, woyi agbadɔ la me abe Aron kple via ŋutsuawo ƒe kpeɖeŋutɔwo ene. Wowɔ nu sia nu pɛpɛpɛ ɖe se si Yehowa de na Mose la nu. ");
INSERT INTO ewe_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Se sia ku ɖe Levi ƒe viwo ŋu. Ŋutsu siwo xɔ ƒe blaeve vɔ atɔ̃ la ava awɔ Mawu ƒe agbadɔ la ŋuti dɔ. ");
INSERT INTO ewe_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Ke ne woxɔ ƒe blaatɔ̃ la, woaxɔ dzudzɔ tso woƒe dɔwɔwɔ me, eye womagawɔ dɔ o. ");
INSERT INTO ewe_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Woate ŋu akpe ɖe wo nɔviwo ŋu le woƒe dɔwɔwɔwo me le agbadɔ la me, gake woawo ŋutɔ magawɔ dɔ la o. Ekema esiae nye ale si nàde dɔwo asi na Levi ƒe viwoe.” ");
INSERT INTO ewe_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Yehowa de se siawo na Mose esime Mose kple Israelvi mamlɛawo nɔ Sinai gbedzi le ɣleti gbãtɔ me, le ƒe evelia me, esi wodo go tso Egipte. Yehowa gblɔ nɛ be, ");
INSERT INTO ewe_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Na Israelviwo naɖu Ŋutitotoŋkekenyui la le eƒe ɣeyiɣi la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Miɖui le eƒe ɣeyiɣi la dzi, le fiẽ, le ɣleti sia ƒe ŋkeke wuienelia gbe le eƒe sewo kple ɖoɖowo katã nu.” ");
INSERT INTO ewe_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Ale Mose gblɔ na Israelviwo be woaɖu Ŋutitotoŋkekenyui la, ");
INSERT INTO ewe_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","eye woɖui le Sinai gbegbe la le fiẽ, le ɣleti gbãtɔ ƒe ŋkeke wuienelia gbe. Israelviwo wɔ nu sia nu abe ale si Yehowa ɖo na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ke wo dometɔ aɖewo mete ŋu ɖu Ŋutitotoŋkekenyui la gbe ma gbe o, elabena wo dometɔ aɖewo gblẽ kɔ ɖo na wo ɖokuiwo le ame kuku aɖe ta. Ale wova Mose kple Aron gbɔ gbe ma gbe, ");
INSERT INTO ewe_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","eye wogblɔ na Mose be, “Míegblẽ kɔ ɖo ɖe ame kuku aɖe ta, ke nu ka ta woaxe mɔ na mí be míatsɔ Yehowa ƒe vɔsa vɛ kpe ɖe Israelvi bubuawo ŋu le ɣeyiɣi ɖoɖo la dzi o?” ");
INSERT INTO ewe_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose gblɔ na wo be yeabia nya Yehowa tso woƒe xaxa la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yehowa ƒe nyametsotsoe nye: ");
INSERT INTO ewe_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Ne Israelviwo dometɔ siwo li fifia alo siwo anɔ dzidzime siwo ava va me la gblẽ kɔ ɖo na wo ɖokuiwo le Ŋutitotoŋkekenyui la ƒe ɣeyiɣi me, to asikaka ame kuku aɖe ŋu me, alo ne wozɔ mɔ, eye womate ŋu anɔ wo nɔviwo dome o la, ele be woaɖu Yehowa ƒe Ŋutitotoŋkekenyui la kokoko. Woawo aɖui le ɣleti ɖeka megbe, ");
INSERT INTO ewe_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","le ɣleti evelia ƒe ŋkeke wuienelia gbe. Woadze ŋkekenyui la ɖuɖu gɔme tso gbe ma gbe ƒe fiẽ. Woaɖu alẽvi la ɣe ma ɣi kple abolo maʋamaʋã kple amagbe veve. ");
INSERT INTO ewe_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Mele be woagblẽ nuɖuɖu la ƒe ɖeke ɖi ŋu nake ɖe edzi o, eye womagbã alẽvi la ƒe ƒu aɖeke o. Woazɔ ɖe Ŋutitotoŋkekenyui la ɖuɖu ƒe sewo nu pɛpɛpɛ. ");
INSERT INTO ewe_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Ke ame sia ame, si megblẽ kɔ ɖo na eɖokui o, eye mezɔ mɔ hã o, gake wògbe meɖu Ŋutitotoŋkekenyui la le ɣeyiɣi ɖoɖo la dzi o la, woaɖee le Israelviwo ƒe ha me le ale si wògbe be yemasa vɔ na Yehowa le ɣeyiɣi ɖoɖo la dzi o ta. Eƒe nu vɔ̃ anɔ edzi. ");
INSERT INTO ewe_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Ne amedzro aɖe le mia dome, eye wòdi be yeaɖu Ŋutitotoŋkekenyui la na Yehowa la, ele nɛ be wòawɔ Ŋkekenyui la ɖuɖu ƒe sewo dzi pɛpɛpɛ. Se ɖeka koe li na ame sia ame.” ");
INSERT INTO ewe_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Le gbe si gbe wotu agbadɔ la la, lilikpo la tsyɔ edzi. Le gbe ma gbe ƒe fiẽ la, lilikpo la trɔ hedze abe dzo bibi ene. Enɔ nenema le zã blibo la me. ");
INSERT INTO ewe_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Aleae wònɔna azɔ: enyea lilikpo le ŋkeke me eye wòdzena abe dzo bibi ene le zã me. ");
INSERT INTO ewe_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ne lilikpo la ho la, Israelviwo dzea mɔ, ɖea zɔ va se ɖe afi si lilikpo la natɔ ɖo, eye woƒua asaɖa anyi ɖe afi ma. ");
INSERT INTO ewe_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Wozɔ mɔ alea le Yehowa ƒe kpɔkplɔ te. Wotɔna ɖe afi si Yehowa ɖo na wo be woatɔ ɖo. Wonɔa afi ma ɣeyiɣi si lilikpo la tɔ ɖe afi ma. ");
INSERT INTO ewe_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ne enɔ anyi wòdidi la, woawo hã wonɔa anyi ɣeyiɣi didi ma ke. Ke ne enɔ anyi ŋkeke ʋɛ aɖewo ko la, ekema Israelviwo hã wonɔa anyi ŋkeke ʋɛ aɖewo ko, elabena nenemae Yehowa ɖo na wo. ");
INSERT INTO ewe_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ɣe aɖewo ɣi la, lilikpo la nɔa asaɖa la tame ŋkeke ʋɛ aɖewo ko; le Yehowa ƒe gbeɖeɖe nu la, woatsi asaɖa la me, eye le eƒe gbeɖeɖe nu la, woadze mɔ. ");
INSERT INTO ewe_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ɣe aɖewo ɣi la, lilikpo la nɔa anyi tso fiẽ va se ɖe ŋdi ko, eye ne eho le ŋdi la, wodzea mɔ. Nenye le ŋkeke me alo zã me, ɣe sia ɣi si lilikpo la ho ko la, wodzea mɔ. ");
INSERT INTO ewe_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ne lilikpo la nɔ agbadɔ la tame ŋkeke eve alo ɣleti ɖeka alo ƒe ɖeka la, Israelviwo nɔa asaɖa la me, eye womedzea mɔ o. Ke ne eho la, wodzea mɔ. ");
INSERT INTO ewe_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Le Yehowa ƒe gbeɖeɖe nu la, woƒua asaɖa anyi, eye le Yehowa ƒe gbeɖeɖe nu la, wodzea mɔ. Wowɔa Yehowa ƒe gbe dzi le se si wòde to Mose dzi la nu. ");
INSERT INTO ewe_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Tsɔ klosalo wɔ kpẽ eve hena ameawo yɔyɔ be woaƒo ƒu kple gbeƒãɖeɖe be woaho. ");
INSERT INTO ewe_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ne woku kpẽ eveawo ƒo ƒui la, ameawo anya be, ele be yewoakpe ta le agbadɔ la ƒe mɔnu. ");
INSERT INTO ewe_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ke ne woku kpẽ ɖeka ko la, ekema kplɔlawo kple Israel ƒe toawo ƒe tatɔwo ava ƒo ƒu ɖe ŋkuwòme. ");
INSERT INTO ewe_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ne woku kpẽa la, ekema to siwo ƒu asaɖa anyi ɖe ɣedzeƒe la aho. ");
INSERT INTO ewe_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ne kpẽa gaɖi zi evelia tu ɖe nu la, to siwo le dziehe lɔƒo la hã adze mɔ. Kpẽa ƒe ɖiɖi nye nyanyanana be woadze mɔ. ");
INSERT INTO ewe_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ke ne wodi be dukɔ la katã nakpe ta la, woaku kpẽ la kpuie ko. ");
INSERT INTO ewe_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Aron ƒe viŋutsuwo, ame siwo nye nunɔlawo la koe kpɔ mɔ aku kpẽawo. Esia nye nuɖoanyi na mi tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ne mieyi aʋa kple miaƒe futɔwo, ame siwo le mia tem ɖe anyi le miawo ŋutɔ ƒe anyigba dzi la, ekema miku kpẽawo. Ekema Yehowa, miaƒe Mawu la aɖo ŋku mia dzi, eye wòaɖe mi tso miaƒe futɔwo ƒe asi me. ");
INSERT INTO ewe_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Miku kpẽawo le dzidzɔɣiwo hã. Miku wo le miaƒe ƒe sia ƒe Ŋkekenyuiwo dzi kple dzinu yeye ɖe sia ɖe ƒe Ŋkekenyuiwo dzi. Miku kpẽawo hã ɖe miaƒe numevɔsawo kple ŋutifafavɔsawo hã ŋu, eye woanye ŋkuɖodzi na mi le miaƒe Mawu la ŋkume. Nyee nye Yehowa, miaƒe Mawu.” ");
INSERT INTO ewe_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Lilikpo la ho le agbadɔ la tame le Israelviwo ƒe dzodzo le Egipte ƒe ƒe evelia ƒe ɣleti evelia ƒe ŋkeke blaevelia gbe. ");
INSERT INTO ewe_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Ale Israelviwo dzo le Sinai gbegbe la. Wodze lilikpo la yome va se ɖe esime wòtɔ ɖe Paran gbegbe la. ");
INSERT INTO ewe_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Esiae nye woƒe mɔzɔzɔ gbãtɔ esi woxɔ Yehowa ƒe se siwo wòde na Mose tso mɔzɔzɔ la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Yuda ƒe to la dze ŋgɔ, nɔ woƒe aflaga la yome. Woƒe kplɔlae nye Nahson, Aminadab ƒe viŋutsu. ");
INSERT INTO ewe_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Isaka ƒe to la kplɔ wo ɖo. Woƒe kplɔlae nye Netanel, Zuar ƒe viŋutsu. ");
INSERT INTO ewe_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliab, Helon ƒe viŋutsu kplɔ Zebulon ƒe to la dze wo yome. ");
INSERT INTO ewe_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Wokaka Agbadɔ la, eye Gerson kple Merari ƒe viwo tso Levi ƒe viwo dome kplɔ wo ɖo. Wokɔ Agbadɔ la ɖe abɔta. ");
INSERT INTO ewe_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Ruben ƒe to la kple woƒe aflaga dze wo yome le woƒe kplɔla Elizur, Sedeur ƒe viŋutsu ƒe kpɔkplɔ te. ");
INSERT INTO ewe_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Simeon ƒe to la kplɔ woawo hã ɖo. Wonɔ woƒe kplɔla Selumiel, Zurisadai ƒe viŋutsu ƒe kpɔkplɔ te. ");
INSERT INTO ewe_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","To si kplɔ wo ɖo lae nye Gad ƒe to la. Woƒe kplɔlae nye Eliasaf, Deguel ƒe viŋutsu. ");
INSERT INTO ewe_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Kohat ƒe viwo kplɔ Gad ƒe to la ɖo. Woawoe tsɔa nu kɔkɔeawo. Wotua agbadɔ la ɖe teƒe yeyea hafi wova ɖona. ");
INSERT INTO ewe_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Efraim ƒe to la kplɔ Kohat ƒe viwo ɖo. Wonɔ woƒe aflaga yome le Elisama, Amihud ƒe viŋutsu ƒe kpɔkplɔ te. ");
INSERT INTO ewe_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Manase ƒe to la nɔ Gamaliel, Pedahzur ƒe viŋutsu ƒe kpɔkplɔ te kplɔ wo ɖo, ");
INSERT INTO ewe_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","eye Benyamin ƒe to la nɔ woƒe kplɔla Abidan, Gideoni ƒe viŋutsu ƒe kpɔkplɔ te kplɔ wo ɖo. ");
INSERT INTO ewe_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Ame mamlɛtɔwoe nye Dan ƒe to la. Wonɔ woƒe aflaga yome le woƒe kplɔla, Ahiezer, Amisadai ƒe viŋutsu ƒe kpɔkplɔ te. ");
INSERT INTO ewe_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Aser ƒe to la, ame siwo Pagiel, Okran ƒe viŋutsu kplɔ, ");
INSERT INTO ewe_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","kple Naftali ƒe to la, ame siwo Ahira, Enan ƒe viŋutsu kplɔ la dze wo yome. ");
INSERT INTO ewe_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Ɖoɖo sia mee Israelviwo ƒe towo nɔna hezɔa mɔ. ");
INSERT INTO ewe_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Gbe ɖeka la, Mose gblɔ na srɔ̃a nɔviŋutsu, Hobab si nye Midiantɔ Reuel ƒe viŋutsu be, “Mlɔeba la, míele mɔ dzem ɖo ta Ŋugbedodonyigba la dzi. Na míayi. Míalé be na wò, elabena Yehowa do nu nyui geɖewo ŋugbe na Israel!” ");
INSERT INTO ewe_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Ke Hobab gblɔ nɛ be, “Ao, ele be matrɔ ayi mía de aɖanɔ nye amewo dome.” ");
INSERT INTO ewe_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mose ɖe kuku nɛ be, “Nɔ mía gbɔ, elabena ènya teƒe siwo míaƒu asaɖa anyi ɖo, eye ànye ŋku na mí. ");
INSERT INTO ewe_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ne èkplɔ mí ɖo la, àkpɔ gome le nu nyui siwo katã Yehowa wɔna na mí la me.” ");
INSERT INTO ewe_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Wozɔ mɔ ŋkeke etɔ̃ tso Sinai to, Yehowa ƒe to la gbɔ. Nubablaɖaka la le wo ŋgɔ be yeatia teƒe si woatɔ ɖo la na wo. ");
INSERT INTO ewe_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Wodze mɔ le ŋkeke me. Yehowa ƒe lilikpo la nɔ zɔzɔm le ŋgɔ na wo. ");
INSERT INTO ewe_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ne wokɔ nubablaɖaka la dze mɔ la, Mose doa ɣli be, “O! Yehowa, tsi tsitre, eye nàka wò futɔwo hlẽ. Na woasi le ŋgɔwò.” ");
INSERT INTO ewe_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ne wodro nubablaɖaka la ɖi la, egblɔna be, “Yehowa, trɔ gbɔ va Israelvi akpe akpeawo gbɔ.” ");
INSERT INTO ewe_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ameawo de asi liʋĩliʋĩlilĩ me le woƒe fukpekpewo katã ta. Yehowa see, eye wòdo dɔmedzoe ɖe wo ŋu le woƒe liʋĩliʋĩlilĩ ta. Ale Yehowa ƒe dzo de asi ame siwo le asaɖa la ƒe mlɔenu la tsɔtsrɔ̃ me. ");
INSERT INTO ewe_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Wodo ɣli na Mose be wòaxɔ na yewo. Esi Mose do gbe ɖa na Yehowa ɖe wo ta la, dzo la tsi. ");
INSERT INTO ewe_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Tso ɣe ma ɣi dzi la, wona ŋkɔ teƒe la be “Dzobiteƒe,” elabena dzo tso Yehowa gbɔ bi le ameawo dome le afi ma. ");
INSERT INTO ewe_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Nuɖuɖu bubuwo de asi yakame siwo le wo dome la dzodzro me, eye Israelviwo gade asi liʋĩliʋĩlilĩ me hegblɔna be, “Ne míakpɔ lã aɖu ko! ");
INSERT INTO ewe_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Míeɖo ŋku tɔmelã siwo míeɖu le Egipte femaxee kple dzamatre, aɖiba, agumetaku, sabala kple ayo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ke fifia la, míegakpɔa nu siawo o; mana ko míeɖuna gbe sia gbe!” ");
INSERT INTO ewe_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mana la le ɣie abe bliku ene gake ele gbadzɛe, eye wòvivina abe anyitsibolo ene. ");
INSERT INTO ewe_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ameawo fɔnɛ le anyigba, tonɛ le to me, ɖanɛ eye wòwɔa tatalĩ si vivina abe tatalĩ si wotɔ le ami me ene. ");
INSERT INTO ewe_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Mana gena kple zãmu ƒe dzadza le zã me. ");
INSERT INTO ewe_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ƒomewo tsia tsitre ɖe woƒe agbadɔwo nu henɔa avi fam. Mose se woƒe avifafa. Yehowa gado dɔmedzoe ɖe edzi wu, eye Mose hã mekpɔ ŋudzedze le nu sia ŋu o. ");
INSERT INTO ewe_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mose gblɔ na Yehowa be, “Nu ka ta mève nu nye eye nètiam be yeadro dukɔ sia tɔgbi ƒe agba ɖe dzinye? ");
INSERT INTO ewe_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Vinyewo wonyea? Nyee nye wo fofoa? Nu sia tae nède dɔ asi nam be makpɔ wo dzi abe vidzĩwo ene va se ɖe esime míaɖo anyigba si ŋugbe nèdo na mía tɔgbuiwo la dzia? ");
INSERT INTO ewe_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Afi ka makpɔ lã tsoe ana ame siawo katã? Wole avi fam nam le gbɔgblɔm be, ‘Na lã mí’ ");
INSERT INTO ewe_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Nye ɖeka nyemate ŋu atsɔ dukɔ sia ƒe nyawo o. Agba la kpe nam akpa! ");
INSERT INTO ewe_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Nenye aleae nàwɔm la, ekema meɖe kuku, wum fifi laa, eye wòanye nunyee nève boŋ! Ɖem tso nye xaxa dziŋɔ sia me!” ");
INSERT INTO ewe_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Tete Yehowa gblɔ na Mose be, “Na Israelviwo ƒe ametsitsi blaadre naƒo ƒu ɖe nye ŋkume. Kplɔ wo va agbadɔ la me, eye woatsi tsitre ɖe afi ma kpli wò. ");
INSERT INTO ewe_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Maɖi ava ƒo nu kpli wò le afi ma. Maɖe Gbɔgbɔ si le dziwò la ƒe ɖe le dziwò ada ɖe woawo hã dzi. Woatsɔ dukɔ la ƒe agba akpe ɖe ŋuwò ale be dɔdeasi la maganɔ wò ɖeka ko dzi o. ");
INSERT INTO ewe_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Gblɔ na ameawo be woakɔ wo ɖokuiwo ŋuti, elabena woakpɔ lã aɖu etsɔ. Gblɔ na wo be, ‘Yehowa se miaƒe liʋĩliʋĩlilĩwo tso nu siwo katã miegblẽ ɖe megbe le Egipte la ŋu, eye wòle lã na ge mi. ");
INSERT INTO ewe_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Miaɖui ŋkeke ɖeka, alo ŋkeke eve, atɔ̃, ewo alo blaeve ko o, ");
INSERT INTO ewe_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ke ɣleti blibo ɖeka, va se ɖe esime wòado to ŋɔtime na mi, eye wòati mi, elabena miegbe Yehowa, ame si le mia dome, eye miefa avi le eŋkume gblɔ be, “Nu ka ta koŋ míedzo le Egipte ɖo?” ’ ” ");
INSERT INTO ewe_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mose gblɔ be, “Ŋutsuawo ɖeɖe de akpe alafa ade, nyɔnuwo kple ɖeviwo mele eme o; le esime nèdo ŋugbe be yeana lã wo ɣleti blibo ɖeka! ");
INSERT INTO ewe_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ne míawu míaƒe lãwo katã hã la, made wo nu o! Ele be míaɖe tɔmelã ɖe sia ɖe tso atsiaƒu me hafi nàte ŋu awɔ wò ŋugbedodo dzi!” ");
INSERT INTO ewe_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yehowa gblɔ na Mose be, “Ɣe ka ɣie ŋusẽ vɔ le ŋunye? Azɔ la, miakpɔe ne nye nya nye nyateƒe loo alo alakpa!” ");
INSERT INTO ewe_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mose dzo le agbadɔ la me, eye wògblɔ Yehowa ƒe nyawo na ameawo. Eƒo ƒu ametsitsi blaadreawo nu, eye wòna woƒo xlã agbadɔ la. ");
INSERT INTO ewe_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yehowa ɖiɖi le lilikpo la me, ƒo nu kple Mose, eye woɖe gbɔgbɔ si nɔ Mose dzi la ƒe akpa aɖe da ɖe ametsitsi blaadreawo dzi. Esi gbɔgbɔ la ɖiɖi ɖe wo dzi la, wogblɔ nya ɖi ɣeyiɣi aɖe. ");
INSERT INTO ewe_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ke ametsitsi blaadreawo dometɔ eve, Eldad kple Medad, ganɔ asaɖa la me ko, eye esi gbɔgbɔ la dze ɖe wo dzi la, wogblɔ nya ɖi le afi ma. ");
INSERT INTO ewe_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Ɖekakpui aɖewo ƒu du yi ɖagblɔ nya si dzɔ la na Mose. ");
INSERT INTO ewe_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yosua, Nun ƒe viŋutsu, ame si Mose ŋutɔ tia be wòanye yeƒe kpeɖeŋutɔ la gblɔ be, “Amegã, na woadzudzɔ!” ");
INSERT INTO ewe_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ke Mose ɖo eŋu be, “Ɖe nèle ŋu ʋãm ɖe nunyea? Ɖe boŋ madi be Yehowa ƒe amewo katã nazu nyagblɔɖilawo, eye Yehowa nada eƒe gbɔgbɔ ɖe wo katã dzi hafi!” ");
INSERT INTO ewe_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Emegbe la, Mose kple Israelviwo ƒe ametsitsiawo trɔ yi asaɖa la me. ");
INSERT INTO ewe_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Azɔ ya sesẽ aɖe ƒo tso Yehowa gbɔ, eye wòkplɔ tegliwo vɛ tso atsiaƒu dzi. Ena wodze ɖe anyigba ƒo xlã asaɖa la katã. Woli kɔ ɖe wo nɔewo dzi, anɔ abe mita ɖeka ene tso anyigba, eye woƒe kekeme tso asaɖa la gbɔ anye ŋkeke ɖeka ƒe azɔli. ");
INSERT INTO ewe_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ŋkeke kple zã blibo la kpakple ŋkeke si kplɔe ɖo la, ameawo do go yi ɖalé tegliawo, eye ame aɖeke melé tegliawo wòle sue wu kilo eve kple afã o. Wosia wo ƒo xlã asaɖa blibo la kpe ɖo. ");
INSERT INTO ewe_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Esi ame sia ame de asi lã la ɖuɖu me la, Yehowa do dɔmedzoe ɖe ameawo ŋu, eye wòtsɔ dɔvɔ̃ wu ame geɖewo. ");
INSERT INTO ewe_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Eya ta wotsɔ ŋkɔ na teƒe la be Kibrot Hatava, elabena afi mae woɖi ame siwo dzro nuɖuɖu bubu la ɖo. ");
INSERT INTO ewe_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Tso Kibrot Hatava la, ameha la zɔ mɔ yi Hazerot, eye wonɔ afi ma. ");
INSERT INTO ewe_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Gbe ɖeka la, Miriam kple Aron lĩ Mose ŋu le srɔ̃a, si nye Kus nyɔnu la ta, elabena eɖe Kus nyɔnu. ");
INSERT INTO ewe_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Wogblɔ be, “Ɖe Yehowa ƒo nu to Mose ɖeɖe ko dzia? Ɖe meƒo nu to míawo hã dzi oa?” Ke Yehowa se nya sia. ");
INSERT INTO ewe_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Azɔ la, Mose nye ame si bɔbɔ eɖokui wu ame bubu ɖe sia ɖe le anyigba dzi.) ");
INSERT INTO ewe_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Enumake Yehowa gblɔ na Mose, Aron kple Miriam be, “Miva agbadɔ la me, mi ame etɔ̃ la katã.” Ale wo ame etɔ̃awo katã wodo go. ");
INSERT INTO ewe_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Yehowa ɖiɖi tso lilikpo la me, eye wòtɔ ɖe agbadɔ la ƒe mɔnu. Eɖe gbe na wo be, “Aron kple Miriam, mido va ŋgɔ,” eye wodo va ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Yehowa gblɔ na wo be, “Miɖo to nye nyawo: “Ne Yehowa ƒe nyagblɔɖila aɖe le mia dome la, meɖea ɖokuinye fianɛ le ŋutegawo me, eye meƒoa nu nɛ le drɔ̃ewo me. ");
INSERT INTO ewe_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Ke esia menye nyateƒe le nye dɔla Mose gome o; ewɔa nuteƒe le nye aƒe blibo la me. ");
INSERT INTO ewe_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Meƒoa nu kplii, ŋkume kple ŋkume. Meƒoa nu eme kɔna, eye menye le alobalowo me o; ekpɔa Yehowa ƒe dzedzeme. Ekema nu ka ta mievɔ̃ be yewoaƒo nu, atsi tsitre ɖe nye dɔla, Mose ŋu o ɖo?” ");
INSERT INTO ewe_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Yehowa do dɔmedzoe ɖe wo ŋu vevie, eye wotrɔ dzo. ");
INSERT INTO ewe_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Esi lilikpo dodo la ho tso agbadɔ la tame la, anyidɔ ƒo ɖe Miriam ŋuti, eye eƒe ŋuti katã fu kpii abe ɖetifu ene. Aron nye kɔ kpɔe, eye kpɔ ɖa, Miriam dze anyi. ");
INSERT INTO ewe_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Aron gblɔ na Mose be, “Nye aƒetɔ, meɖe kuku, mègana nu vɔ̃ si míewɔ tamemabumabutɔe la ƒe metsonu nava mía dzi o. ");
INSERT INTO ewe_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Mègana Miriam nanɔ abe vidzĩ si ku ɖe dadaa ƒe dɔ me hafi wodzii, eye eƒe ŋutilã ƒe afã ƒaƒã hafi wòdo go la ene o.” ");
INSERT INTO ewe_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Mose ƒo koko na Yehowa kple ɣli be, “Da gbe le eŋu, O! Mawu, meɖe kuku na wò!” ");
INSERT INTO ewe_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Yehowa ɖo eŋu na Mose be, “Ne fofoa nyɔ ta ɖe mo nɛ la, eŋuti makɔ o ŋkeke adre. Mina wòanɔ asaɖa la godo ŋkeke adre. Le ɣeyiɣi sia megbe la, agate ŋu ava asaɖa la me.” ");
INSERT INTO ewe_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ale woɖe Miriam ɖa le asaɖa la me ŋkeke adre. Ameawo lala, wogakplɔe gbɔe hafi wogayi mɔzɔzɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Le esia megbe la, wodzo le Hazerot, eye woƒu asaɖa anyi ɖe Paran gbedzi. ");
INSERT INTO ewe_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yehowa gblɔ na Mose azɔ be, ");
INSERT INTO ewe_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Dɔ ŋkutsalawo ɖe Kanaanyigba, anyigba si mele tsɔtsɔm na Israel la dzi. Dɔ kplɔla ɖeka ɖa tso to sia to me.” ");
INSERT INTO ewe_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Israelviwo ƒu asaɖa anyi ɖe Paran gbedzi ɣe ma ɣi. Mose wɔ ɖe se si Yehowa de nɛ la dzi, eye wòdɔ toawo ƒe kplɔla siawo ɖa: ");
INSERT INTO ewe_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Woƒe ŋkɔwoe nye: Samua, Zakur ƒe viŋutsu, tso Ruben ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Safat, Hori ƒe viŋutsu, tso Simeon ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kaleb, Yefune ƒe viŋutsu, tso Yuda ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Igal, Yosef ƒe viŋutsu, tso Isaka ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Hosea, Nun ƒe viŋutsu, tso Efraim ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Palti, Rafu ƒe viŋutsu, tso Benyamin ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Gadiel, Sodi ƒe viŋutsu, tso Zebulon ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Gadi, Susi ƒe viŋutsu, tso (Yosef ƒomea me) le Manase ƒe to la me. ");
INSERT INTO ewe_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Amiel, Gemali ƒe viŋutsu, tso Dan ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Setur, Mikael ƒe viŋutsu, tso Aser ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nahbi, Vofsi ƒe viŋutsu, tso Naftali ƒe to la me; ");
INSERT INTO ewe_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","kple Geuel, Maki ƒe viŋutsu, tso Gad ƒe to la me. ");
INSERT INTO ewe_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ame siawoe Mose dɔ be woaɖatsa anyigba la me. Ɣeyiɣi sia mee (Mose trɔ Hosea ƒe ŋkɔ wòzu Yosua) si gɔmee nye “Yehowa nye Ɖeɖe.” ");
INSERT INTO ewe_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mose dɔ wo ɖa, eye wògblɔ na wo be, “Miyi anyigba la ƒe anyigbeme lɔƒo, le Negeb ƒe tonyigba la dzi, ");
INSERT INTO ewe_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ne miakpɔ ale si anyigba la le. Mikpɔ ale si ame siwo le anyigba la dzi hã le, ne wonye ame sesẽwo alo ame benɔewo, ne wosɔ gbɔ alo womesɔ gbɔ o. ");
INSERT INTO ewe_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Milé ŋku ɖe nuwo ŋu, miakpɔ ne anyigba la nyo na agblemenukuwo loo alo menyo na wo o, ne woƒe duwo lolo loo alo wole sue, ne wotu mɔ sesẽwo ɖe wo ŋu, ");
INSERT INTO ewe_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ne anyigba la nyo alo menyo o, eye ne atiwo sɔ gbɔ le edzi loo alo womesɔ gbɔ o. Migavɔ̃ o. Mitsɔ woƒe agblemenuku, siwo miakpɔ la ƒe ɖewo vɛ.” (Wonɔ waintsetse gbãtɔwo gbem ɣe ma ɣi.) ");
INSERT INTO ewe_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Ale wotsa ŋku le anyigba la dzi tso keke Zin gbegbe la va ɖo Rehob, le Hamat gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Wotso afi ma ɖo ta dzigbeme lɔƒo; woto Negeb gbã, eye woyi Hebron. Wokpɔ Ahimanitɔwo, Sesaitɔwo kple Talmaitɔwo. Ame siawo katã nye Anak, ame dzɔatsu ƒe dzidzimeviwo. (Hebron nye du xoxo aɖe. Wotsoe ƒe adre do ŋgɔ na Tanis tsotso le Egipte.) ");
INSERT INTO ewe_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Tso afi ma la, wova afi si woyɔna egbegbe be, Eskɔl ƒe Balime. Wotso waintsetse kpo ɖeka le afi sia wòlolo ale gbegbe be ame evee tsɔ ati de eme hafi te ŋu tsɔe! Wotsɔ yevuboɖa kple gbotsetse siwo wokpɔ le afi ma hã ƒe ɖewo ɖe asi. ");
INSERT INTO ewe_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Israelviwo na ŋkɔ Balime sia be, Eskɔl, si gɔmee nye “Kpo ɖeka” le waintsetse si wokpɔ le afi ma ƒe kpo ɖeka ƒe lolo ta! ");
INSERT INTO ewe_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Le ŋkeke blaene megbe la, wotrɔ gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Wogblɔ nu si wokpɔ la na Mose, Aron kple Israelviwo katã le Paran gbedzi le Kades, eye wotsɔ kutsetse siwo wotsɔ vɛ la fia wo. ");
INSERT INTO ewe_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Wona nutsotso Mose ale, “Míede anyigba si dzi mieɖo mí ɖo be míatsa ŋku le la dzi. Enye anyigba nyui aɖe ŋutɔ, anyigba si dzi notsi kple anyitsi le tsatsam le. Míetsɔ kutsetse siawo vɛ be woaɖe nya si gblɔm míele la ƒe nyateƒenyenye afia. ");
INSERT INTO ewe_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ke afi ma tɔwo nye ŋusẽtɔwo. Woƒe duwo lolo, eye woglã wo katã. Gawu la, míekpɔ Anak ƒe dzidzimeviwo gɔ̃ hã le afi ma! ");
INSERT INTO ewe_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalekitɔwo le gbegbe le dziehe gome, ke Hititɔwo, Yebusitɔwo kple Amoritɔwo ya le togbɛwo dzi, eye Kanaantɔwo le atsiaƒu kple Yɔdan to.” ");
INSERT INTO ewe_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Tete Kaleb tsi nya ɖe ameawo nu le Mose ŋkume, eye wògblɔ be, “Mina míayi aɖaxɔ anyigba la, elabena míate ŋui xoxoxo.” ");
INSERT INTO ewe_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Ŋkutsala bubuawo gblɔ be, “Miate ŋu aɖadze wo dzi o, elabena wosesẽ wu mi.” ");
INSERT INTO ewe_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ale wokaka nutsotso gbegblẽ ɖe Israelviwo dome tso anyigba si dzi wotsa ŋku le la ŋuti. Wogblɔ na ameawo be, “Anyigba si dzi míetsa ŋku le la le edzinɔlawo mim. Ame siwo katã míekpɔ la nye ame dzɔatsuwo. ");
INSERT INTO ewe_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Míekpɔ Nefilimtɔwo hã le afi ma (Anak nye Nefilimtɔwo ƒe dzidzimeviwo). Míedze le woƒe ŋkume abe abɔwo ene, eye nenema kee woawo hã kpɔ míe.” ");
INSERT INTO ewe_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Israelviwo katã de asi avifafa me sesĩe. Wofa avi zã blibo la. ");
INSERT INTO ewe_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israelviwo katã lĩ liʋĩliʋĩ ɖe Mose kple Aron ŋu, eye ame haho la katã gblɔ na wo be, “Ɖe míeku ɖe Egipte la, anye ne enyo wu alo ɖe gbedzi afi sia la, ne enyo ŋutɔ! ");
INSERT INTO ewe_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Nu ka ŋuti Yehowa kplɔ mí va anyigba sia dzi be míatsi yi nu? Mía srɔ̃nyɔnuwo kple mía viwo azu nuhaha. Ɖe manyo wu ne míagbugbɔ ayi Egipte oa?” ");
INSERT INTO ewe_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Wogblɔ na wo nɔewo be, “Mina míatia kplɔla si akplɔ mí míatrɔ ayi Egipte!” ");
INSERT INTO ewe_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Tete Mose kple Aron wotsyɔ mo anyi ɖe Israelvi siwo katã ƒo ƒu ɖe afi ma la ƒe ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yosua, Nun ƒe vi kple Kaleb, Yefune ƒe vi, ame siwo nɔ ŋkutsalawo dome, tsa ŋku le anyigba la dzi la, dze woƒe awuwo, ");
INSERT INTO ewe_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","hegblɔ na Israel ha blibo la be, “Anyigba si dzi míeto hetsa ŋku le la nyo ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Nenye be míaƒe nu nyo Yehowa ŋu la, akplɔ mí ayi ɖe anyigba ma dzi, anyigba si dzi notsi kple anyitsi le tsatsam le, eye wòatsɔe ana mí. ");
INSERT INTO ewe_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Gake ɖekoe miagadze aglã ɖe Yehowa ŋu o, eye migavɔ̃ ame siwo le anyigba la dzi o, wo dzi ɖuɖu le bɔbɔe na mí, elabena luʋɔ dzo le wo ta, ke míawo ya la, Yehowa li kpli mí, eya ta migavɔ̃ na wo o.” ");
INSERT INTO ewe_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ke ameha blibo la ƒo nu tso kpeƒuƒu wo ŋu. Tete Yehowa ƒe ŋutikɔkɔe dze le agbadɔ la gbɔ na Israelviwo katã. ");
INSERT INTO ewe_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Yehowa gblɔ na Mose be, “Va se ɖe ɣe ka ɣie ame siawo ado vlom? Va se ɖe ɣe ka ɣie woagbe be yewomaxɔ dzinye ase o le dzesi wɔnuku siwo mewɔ la katã megbe? ");
INSERT INTO ewe_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Womaganye nye domenyilawo o. Matsrɔ̃ wo kple dɔvɔ̃. Mana dukɔ si alolo sãa, eye wòasẽ ŋu sãa wu Israel la nado tso mewò!” ");
INSERT INTO ewe_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Mose ƒo koko na Yehowa be, “Ke nu ka Egiptetɔwo abu ne wose nya sia? Wonya ŋusẽ si nèɖe fia le wò amewo ɖeɖe me la nyuie. ");
INSERT INTO ewe_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Wogblɔ nya sia na anyigba sia dzi nɔlawo, eye wonya nyuie be, wò Yehowa nèle Israel dzi, eye nèƒoa nu kplii ŋkume kple ŋkume. Wokpɔa lilikpo dodo la kple dzo bibi la wonɔa mía tame. Wonya be èkplɔa mí, eye nèkpɔa mía ta le ŋkeke me kple zã me siaa. ");
INSERT INTO ewe_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Azɔ ne èwu wò amewo la, dukɔ siwo se nu tso wò ŋkɔxɔxɔ ŋu la agblɔ be, ");
INSERT INTO ewe_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Enɔ na Yehowa be wòawu wo, elabena mete ŋu kpɔ wo ta le gbedzi o. Ŋusẽ menɔ eŋu be wòate ŋu akplɔ wo ayi anyigba si wòka atam be yeatsɔ ana wo la dzi o.’ ");
INSERT INTO ewe_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Azɔ la, wòaɖe Yehowa ƒe ŋusẽ afia abe ale si nèɖe gbeƒãe ene: ");
INSERT INTO ewe_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Yehowa le blewu le dɔmedzoedodo me, eƒe amenuveve sɔ gbɔ, eye wòtsɔa nu vɔ̃ kple aglãdzedze kena. Ke megbea tohehe na fɔɖilawo o. Ehea to na ɖeviwo ɖe wo fofowo ƒe nu vɔ̃wo ta va se ɖe dzidzime etɔ̃lia kple enelia dzi.’ ");
INSERT INTO ewe_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","O! Meɖe kuku na wò, tsɔ ameawo ƒe nu vɔ̃wo ke wo le wò lɔlɔ̃ triakɔ si metrɔna o la ta, abe ale si nètsɔ nu vɔ̃wo ke wo ɣe sia ɣi tso esime míedzo le Egipte va se ɖe fifia ene.” ");
INSERT INTO ewe_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Yehowa ɖo eŋu be, “Metsɔe ke wo abe ale si nèbia ene. ");
INSERT INTO ewe_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Gake zi ale si mele agbe, eye zi ale si Yehowa ƒe ŋutikɔkɔe yɔ anyigba blibo la dzi la, ");
INSERT INTO ewe_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","nenema tututue wòanye nyateƒe, be ame siwo kpɔ nye ŋutikɔkɔe kple nukunu siwo mewɔ le Egipte kple gbedzi siaa, eye wogbe zi ewo be yewomaka ɖe dzinye o, eye yewomaɖo tom hã o la dometɔ ɖeka pɛ gɔ̃ hã ");
INSERT INTO ewe_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","makpɔ anyigba si ŋugbe medo na ame siawo tɔgbuiwo o. ");
INSERT INTO ewe_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ke nye dɔla, Kaleb ya nye ame bubu aɖe kura, eɖo tom ale si dze. Makplɔe ayi anyigba si dzi wòde abe ŋkutsala ene la, eye eƒe dzidzimeviwo akpɔ woƒe gome dedie le eme. ");
INSERT INTO ewe_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Azɔ la, esi Israelviwo le vɔvɔ̃m nenema gbegbe na Amalekitɔwo kple Kanaantɔwo, ame siwo le baliawo me ta la, etsɔ la, ele na mi be miagatrɔ ayi gbedzi, aɖo ta Ƒu Dzĩ la gbɔ.” ");
INSERT INTO ewe_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yehowa gblɔ na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Va se ɖe ɣe ka ɣie ameha vɔ̃ɖi sia alĩ liʋĩliʋĩ ɖe ŋutinye? Mese Israelvi liʋĩliʋĩlĩla siawo ƒe liʋĩliʋĩlilĩ. ");
INSERT INTO ewe_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Migblɔ na wo be, ‘Yehowa ka atam be yeana nu si vɔ̃m miele la nava mia dzi. ");
INSERT INTO ewe_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Mi katã miaku ɖe gbedzi le afi sia! Ame ɖeka pɛ si xɔ ƒe blaeve alo wu nenema, ame si lĩ liʋĩliʋĩ le ŋutinye gɔ̃ hã la ");
INSERT INTO ewe_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","made Ŋugbedodonyigba la dzi o. Kaleb, Yefune ƒe viŋutsu kple Yosua, Nun ƒe viŋutsu, koe aɖo anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Miegblɔ be yewo viwo ava zu kluviwo na anyigba la dzi tɔwo. Le esia teƒe la, makplɔ mia viwo boŋ woaɖo anyigba la dzi dedie, eye woawo anyi nu si miawo miedo vloe la ƒe dome. ");
INSERT INTO ewe_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Ke miawo la, miaku ɖe gbe sia dzi. ");
INSERT INTO ewe_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Miatsa tsaglalã le gbedzi abe alẽnyilawo ene ƒe blaene. Ale miaxe fe ɖe miaƒe nu vɔ̃wo ta va se ɖe esime mia dometɔ mamlɛtɔ naku ɖe gbedzi. ");
INSERT INTO ewe_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ƒe blaene, ƒe ɖeka ɖe ŋkeke ɖeka ɖe sia ɖe si mietsa ŋku le anyigba la dzi nu, miakpe fu ɖe miaƒe nu vɔ̃wo ta, eye mianya nu si wònye be miana matrɔ le mia yome.’ ");
INSERT INTO ewe_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nye, Yehowa, meƒo nu, eye mawɔ nu siawo ameha vɔ̃ɖi blibo la, ameha si bla ɖe ŋunye la kokoko. Woƒe nuwuwu aɖo le gbegbe sia dzi; afi siae woaku ɖo.” ");
INSERT INTO ewe_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Ale ame siwo Mose ɖo ɖa be woatsa ŋku le anyigba la dzi, eye wogbɔ va na ameha blibo la lĩ liʋĩliʋĩ ɖe eŋu to nutsotso vɔ̃ nana tso anyigba la ŋuti me ");
INSERT INTO ewe_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","la, ame siwo na nutsotso vɔ̃ tso anyigba la ŋu la, woƒo wo ƒu anyi, eye woku le dɔvɔ̃ ta le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Yosua kple Yefune ƒe vi Kaleb koe susɔ le ŋkutsalawo dome. ");
INSERT INTO ewe_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Esi Mose gblɔ nya siwo Yehowa gblɔ nɛ la na Israelviwo la, nuxaxa gã aɖe ge ɖe asaɖa blibo la me. ");
INSERT INTO ewe_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Wofɔ ŋdi kanya, eye wodze mɔ ɖo ta Ŋugbedodonyigba la dzi. Ameawo gblɔ be, “Míedze sii be míewɔ nu vɔ̃, ke míele klalo azɔ be, míayi anyigba si ŋugbe Yehowa do na mí la dzi!” ");
INSERT INTO ewe_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ke Mose gblɔ be, “Nu ka ŋuti miele tsitre tsim ɖe Yehowa ƒe ɖoɖo la ŋu? Mele edzi dze ge o! ");
INSERT INTO ewe_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Migazɔ ɖe miaƒe ɖoɖowo nu o; ne menye nenema o la, miaƒe futɔwo aɖu mia dzi, elabena Yehowa mele mia yome o. ");
INSERT INTO ewe_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Mieɖo ŋku edzi oa? Amalekitɔwo kple Kanaantɔwo le afi ma eye miatsi yi nu! Miegbugbɔ le Yehowa yome. Azɔ la, eya hã agbugbɔ le mia yome.” ");
INSERT INTO ewe_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ke togbɔ be Yehowa ƒe nubablaɖaka la loo alo Mose medzo le asaɖa la me o hã la, ameawo dze mɔ yi toawo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Tete Amalekitɔwo kple Kanaantɔwo, ame siwo le toawo dzi la ɖiɖi ɖe wo dzi, kpe aʋa kpli wo, eye wonya wo ɖo ɖe Horma. ");
INSERT INTO ewe_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Ne miege ɖe anyigba si mele mia nam abe mia de ene dzi, ");
INSERT INTO ewe_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","eye miesa dzovɔ na Yehowa tso miaƒe lãhawo me, abe ʋeʋẽ lĩlĩlĩ si dzea Yehowa ŋu la ene, nenye numevɔsa alo vɔsa siwo ku ɖe adzɔgbeɖeɖe tɔxɛwo ŋu, lɔlɔ̃nununana alo Ŋkekenyuiwo ƒe vɔsawo ŋu la, ");
INSERT INTO ewe_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ekema ame si le vɔ la sam la atsɔ nuɖuvɔsa si nye wɔ memee kilogram ɖeka, si wobaka kple ami lita ɖeka na Yehowa, ");
INSERT INTO ewe_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","eye nunovɔsa si nye wain lita ɖeka la akpe ɖe eŋu. Wain hin ɖeka ƒe akpa enelia akpe ɖe alẽvi ɖeka ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Nenye agboe wotsɔ le vɔ la sam la, woatsɔ wɔ memee kilogram eve si woblu kple ami lita ɖeka kple afã ");
INSERT INTO ewe_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","kple wain lita ɖeka kple afã la akpe ɖe eŋu abe nunovɔsa ene. Esia anye vɔsa si ʋẽna lĩlĩlĩ, eye wòdzea Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Ne ètsɔ nyitsuvi aɖe be yeasa numevɔ, adzɔgbeɖevɔ alo akpedavɔe na Yehowa la, ");
INSERT INTO ewe_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ekema nàtsɔ nuɖuvɔsa, wɔ memee lita ade kple afã kple ami lita eve akpe ɖe nyitsuvi la ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Nunovɔsa si akpe ɖe eŋu la anye wain lita eve. Woatsɔ dzo asa vɔ sia, eye wòadze Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Woawɔ nyitsu alo agbo, alẽvi alo gbɔ̃ ɖe sia ɖe ŋu dɔ nenema. ");
INSERT INTO ewe_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Wɔ nu sia na wo dometɔ ɖe sia ɖe, ɖe woƒe agbɔsɔsɔ nu. ");
INSERT INTO ewe_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Dzɔleaƒea ɖe sia ɖe awɔ nu siawo ale, ne etsɔ numevɔsanu aɖe vɛ be wòanye ʋeʋẽ lĩlĩlĩ si adze Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Hena dzidzime siwo gbɔna la, ɣe sia ɣi si amedzro aɖe alo ame bubu aɖe, si le mia dome ana dzovɔsanu aɖe be wòanye ʋeʋẽ lĩlĩlĩ na Yehowa la, ele be wòawɔe tututu abe ale si miewɔnɛ ene. ");
INSERT INTO ewe_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Se ɖeka mawo ke nanɔ ameha la si na mi kple amedzro siwo le mia dome la siaa elabena miesɔ le Yehowa ƒe ŋkume. Esia nye ɖoɖo mavɔ na dzidzime siwo gbɔna. ");
INSERT INTO ewe_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Se kple ɖoɖo mawo ke nakplɔ mi kple amedzro siwo le mia dome.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Ne miege ɖe anyigba si dzi mele mia kplɔm yi dzi, ");
INSERT INTO ewe_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","eye mieɖu anyigba ma dzi nuɖuɖu la, mitsɔ eƒe ɖe sa vɔe na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Mitsɔ miaƒe wɔ gbãtɔwo tɔ tatalĩ, wòanye vɔsa tso miaƒe lu gbãtɔ si tso lugbɔƒe. ");
INSERT INTO ewe_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","To dzidzime siwo ava me la, ele be miasa vɔ sia na Yehowa tso miaƒe luwɔ gbãtɔwo me.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Ne miawo alo miaƒe dzidzimeviwo da vo, eye womewɔ se siwo katã Yehowa de na mi le ƒeawo me to Mose dzi la dzi o la, ");
INSERT INTO ewe_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Yehowa ƒe se siwo wode na mi to edzi tso gbe si gbe Yehowa de wo, woayi edzi to dzidzime siwo gbɔna me, ");
INSERT INTO ewe_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","eye menye nu si woɖo wɔ, eye ameha la menya nu tso eŋu o la, ameha blibo la ana nyitsu fɛ̃ aɖe hena numevɔsa hena ʋeʋẽ lĩlĩlĩ si adze Yehowa ŋu hekpe ɖe eƒe nuɖuvɔsa kple nunovɔsa si woɖo da ɖi kple gbɔ̃tsu ɖeka na nu vɔ̃ ŋuti vɔsa ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Nunɔla alé avu ɖe Israelviwo katã nu, eye woatsɔ woƒe nu vɔ̃wo ake wo, elabena vodadae, eye woɖɔ vodada sia ɖo to dzovɔsa kple nu vɔ̃ ŋuti vɔsa me le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Woatsɔ nu vɔ̃ ake ame sia ame; woatsɔe ake amedzro siwo le Israelviwo dome hã, elabena ameha blibo lae da vo, eya ta ameha blibo la akpɔ gome le tsɔtsɔke la me. ");
INSERT INTO ewe_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Nenye ame ɖekae da vo la, ekema amea ana gbɔ̃nɔe si xɔ ƒe ɖeka la na nu vɔ̃ ŋuti vɔsa. ");
INSERT INTO ewe_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Nunɔla la alé avu ɖe enu le Yehowa ŋkume, eye wòatsɔ eƒe nu vɔ̃ akee. ");
INSERT INTO ewe_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Se sia bla mi ame Israelvi dzɔleaƒeawo kple amedzro siwo le mia dome hã. ");
INSERT INTO ewe_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Ke ne ame aɖe nya nyuie hafi da vo aɖe la, nenye Israelvi alo amedzro hã la, ekema edo vlo Yehowa, eya ta ele be woaɖee ɖa le eƒe amewo dome. ");
INSERT INTO ewe_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Esi wòdo vlo Yehowa ƒe sewo abe nu ɖowɔ ene, eye wònya nyuie hafi da le eƒe se dzi la, ele be woawui, eye eƒe nu vɔ̃ anɔ eya ŋutɔ dzi.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Gbe ɖeka esime Israelviwo nɔ gbedzi la, wolé Israelvi aɖe wònɔ nake fɔm le Dzudzɔgbe la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Wokplɔe yi Mose kple Aron kple ameha la ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Wodee mɔ va se ɖe esime woanya nu si Yehowa adi be woawɔ. ");
INSERT INTO ewe_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Yehowa gblɔ na Mose be, “Ele be ŋutsu la naku. Ele be ameawo katã naƒu kpee le asaɖa la godo wòaku.” ");
INSERT INTO ewe_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Ale wohee yi asaɖa la godo, eye wowui abe ale si Yehowa ɖo na wo ene. ");
INSERT INTO ewe_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Mia kple miaƒe dzidzimeviwo miade gbo miaƒe avɔwo ƒe dzogoewo to, eye ka blɔtɔ nanɔ gbo ɖe sia ɖe ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ne miekpɔ gbo siawo la, ekema miaɖo ŋku se siwo katã Yehowa de na mi la dzi be miawɔ wo dzi, eye miagatsɔ mia ɖokuiwo adzra na ŋutilãmenuwo, miaƒe dzi ƒe nudzodzrowo kple nu siwo miaƒe ŋku kpɔna la o. ");
INSERT INTO ewe_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Ekema miaɖo ŋku edzi, awɔ nye sewo katã dzi, eye miakɔ mia ɖokuiwo ŋuti na miaƒe Mawu la. ");
INSERT INTO ewe_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Nyee nye Yehowa, miaƒe Mawu, ame si kplɔ mi do goe tso Egipte be manye miaƒe Mawu. Nyee nye Yehowa, miaƒe Mawu.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Gbe ɖeka la, Korah, Izhar ƒe viŋutsu kple Kohat ƒe tɔgbuiyɔvi, ame si nye Levi ƒe dzidzimevi la wɔ ɖoɖo kple Datan kple Abiram, ame siwo nye Eliab ƒe viŋutsuwo kple On, Pelet ƒe viŋutsu. Ame etɔ̃ siawo katã tso Ruben ƒe to la me. ");
INSERT INTO ewe_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Ɖoɖo lae nye be woana amewo nadze aglã ɖe Mose ŋu. Ame siwo lɔ̃ ɖe aglãdzedze ƒe ɖoɖo sia dzi kple Israelviwo ƒe xexlẽmee nye ame alafa eve blaatɔ̃ (250). Wonye kplɔlawo kple aɖaŋudelawo. ");
INSERT INTO ewe_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Woyi Mose kple Aron gbɔ, eye wogblɔ na wo be, “Miaƒe asitɔakɔnyawo va ti kɔ na mí azɔ. Mienyo wu ame bubu aɖeke o. Israelvi ɖe sia ɖe nye Yehowa ƒe ame tiatia, eye wòli kpli mí katã. Mɔ ka miekpɔ be miado mia ɖokuiwo ɖe dzi, agblɔ be ele be míaɖo to mi, eye mianɔ wɔwɔm abe ɖe mielolo wu Yehowa ƒe ame siawo dometɔ aɖe ene?” ");
INSERT INTO ewe_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Esi Mose se nya si gblɔm wole la, etsyɔ mo anyi. ");
INSERT INTO ewe_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Egblɔ na Korah kple ame siwo le eŋu la be, “Le ŋdi la, Yehowa afia ame siwo nye etɔwo, ame si le kɔkɔe kple ame si wòtia abe nunɔla ene la mi. ");
INSERT INTO ewe_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ele be wò, Korah kple yowòmedzelawo katã miawɔ ale: Mitsɔ dzudzɔdosonuwo, ");
INSERT INTO ewe_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","eye etsɔ la, miade dzo kple lifi wo me le Yehowa ŋkume. Ame si Yehowa atia lae anye ame si le kɔkɔe. Mi Levi ƒe viwo, mia tɔ gbɔ eme.” ");
INSERT INTO ewe_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mose gblɔ na Korah be, “Azɔ, mi Levi ƒe viwo, miɖo to. ");
INSERT INTO ewe_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Mesɔ gbɔ na mi be Israel ƒe Mawu la ɖe mi ɖa tso Israel ƒe ameha la me, kplɔ mi te ɖe eɖokui ŋu be miawɔ dɔ le Yehowa ƒe Agbadɔ la me, eye miatsi tsitre ɖe ameha la ŋkume asubɔ wo oa? ");
INSERT INTO ewe_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Ɖe ale si wòtsɔ dɔ sia de asi na mi Levi ƒe viwo ɖeɖe ko la mesɔ gbɔ na mi oa? Ke azɔ la, ɖe miele didim be yewoazu nunɔlawo hã mahã? ");
INSERT INTO ewe_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Yehowa ŋue mi kple mia yomedzelawo katã miebla ɖo. Ame kae nye Aron be mialĩ liʋĩliʋĩ le eŋu?” ");
INSERT INTO ewe_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Mose ɖo du ɖe Datan kple Abiram, Eliab ƒe viŋutsuwo, ke wogblɔ be, “Míegbɔna o!” ");
INSERT INTO ewe_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ɖeko wogblɔ be, “Ɖe nèbui be nu sue aɖe ko wònye nèwɔ be nèkplɔ mí dzoe le Egipte, tso anyigba nyui ma dzi be yeawu mí le gbegbe afi sia? Ke azɔ la, ɖe nègadi gɔ̃ hã be yeaɖu fia ɖe mía dzia? ");
INSERT INTO ewe_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Gawu la, mèkplɔ mí yi anyigba wɔnuku si ŋugbe nèdo na mí la hã dzi o, eye mèna agbledenyigba kple waingblewo mí o. Ame kawoe nèle agbagba dzem be yeabu abunɛtɔwoe? Míegbɔna o!” ");
INSERT INTO ewe_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mose do dɔmedzoe vevie, eye wògblɔ na Yehowa be, “Mègaxɔ woƒe vɔsawo o! Nyemefi woƒe tedzi gɔ̃ hã kpɔ o, eye nyemewɔ nuvevi aɖeke wo dometɔ aɖeke kpɔ hã o.” ");
INSERT INTO ewe_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mose gblɔ na Korah be, “Miva afi sia etsɔ, wò kple yowòmedzelawo katã, eye miado ɖe Yehowa ŋkume; Aron hã anɔ afi sia. ");
INSERT INTO ewe_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Ame sia ame natsɔ dzudzɔdosonu ɖe asi, akɔ dzudzɔdonu ɖe wo me. Wo katã ƒe xexlẽme nanye alafa eve blaatɔ̃ (250), eye miatsɔ wo va Yehowa ŋkume. Wò kple Aron hã, miatsɔ miaƒe dzudzɔdosunuwo ɖe asi vɛ.” ");
INSERT INTO ewe_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Ale wotsɔ woƒe dzudzɔdosonuwo vɛ, ɖe dzo ɖe wo me, kɔ dzudzɔdonuwo ɖe wo me, eye wova tsi tsitre ɖe Agbadɔ la ƒe mɔnu kple Mose kple Aron. ");
INSERT INTO ewe_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Esi Korah ƒo eyomedzelawo katã nu ƒu ɖe Agbadɔ la ƒe ŋkume be woatsi tsitre ɖe wo ŋuti la, Yehowa ƒe ŋutikɔkɔe ɖe eɖokui fia ameha blibo la. ");
INSERT INTO ewe_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Yehowa gblɔ na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Miɖe mia ɖokuiwo ɖa le ame siawo dome ale be matsrɔ̃ wo enumake.” ");
INSERT INTO ewe_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mose kple Aron wotsyɔ mo anyi le Yehowa ŋkume, eye woƒo koko nɛ gblɔ be, “O! Mawu, amegbetɔwo katã ƒe gbɔgbɔ ƒe Mawu, ɖe nàdo dɔmedzoe ɖe ameawo katã ŋuti esi wònye ame ɖeka koe wɔ nu vɔ̃a?” ");
INSERT INTO ewe_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Tete Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Gblɔ na ƒuƒoƒe la be, ‘Mite ɖa tso Korah, Datan kple Abiram ƒe agbadɔwo gbɔ.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Ale Mose ɖe abla yi Datan kple Abiram ƒe agbadɔwo gbɔ, eye Israel ƒe dumemetsitsiwo kplɔe ɖo. ");
INSERT INTO ewe_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Mose xlɔ̃ nu ameha la be, “Miɖe abla miadzo le ame vɔ̃ɖi siawo ƒe agbadɔwo gbɔ; migaka asi woƒe naneke ŋu o, ne menye nenema o la, abala míawo hã, eye Yehowa atsrɔ̃ miawo hã ɖe woƒe nu vɔ̃wo ta.” ");
INSERT INTO ewe_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Ale ameawo katã te ɖa le Korah, Datan kple Abiram ƒe agbadɔwo gbɔ. Datan kple Abiram do go tso woƒe agbadɔwo me, eye wotsi tsitre ɖe woƒe agbadɔwo ƒe mɔnu kple wo srɔ̃wo, wo viŋutsuwo kple wo vi suewo. ");
INSERT INTO ewe_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Eye Mose gblɔ be, “To nu sia me la, mianya be Yehowae dɔm ɖa be mawɔ nu siawo katã, eye menye nye ŋutɔ nye susu o. ");
INSERT INTO ewe_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Ne ŋutsu siawo aku dzɔdzɔmeku alo nu si dzɔna ɖe ŋutsu ɖe sia ɖe dzi koe dzɔ ɖe wo dzi la, ekema menye Yehowae dɔm o. ");
INSERT INTO ewe_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Gake nenye be Yehowa ana nu yeye aɖe kura nadzɔ, anyigba nake nu ami wo kple nu sia nu si nye wo tɔ, eye woayi tsiẽƒe agbagbee la, ekema mianya be ŋutsu siawo wɔ nu tovo ɖe Yehowa ŋu.” ");
INSERT INTO ewe_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Esi Mose wu nya siawo nu teti ko la, anyigba la wo le wo te zi ɖeka, ");
INSERT INTO ewe_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","eye anyigba la mi wo kple woƒe aƒemenuwo katã, eye nenema kee nye Korah yomedzelawo katã kple woƒe nunɔamesiwo katã hã. ");
INSERT INTO ewe_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Ale woyi tsiẽƒe agbagbe kple woƒe nunɔamesiwo katã, eye anyigba tu ɖe wo nu, hetsrɔ̃ wo, eye wodo ɖa le ameha la dome. ");
INSERT INTO ewe_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Esi ame siwo yi tsiẽƒe la nɔ ɣli dom la, Israelvi siwo katã ƒo xlã wo la de asi sisi me henɔ ɣli dom be, “Anyigba le míawo hã mi ge.” ");
INSERT INTO ewe_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Dzo ge tso Yehowa gbɔ va fia ame alafa eve blaatɔ̃ (250) siwo nɔ dzudzɔ dom. ");
INSERT INTO ewe_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Gblɔ na Eleazar, Aron, nunɔla la ƒe viŋutsu be wòaɖe dzudzɔdonu mawo le dzo la me, eye wòakaka akawo ɖe teƒe didi aɖe, elabena dzoɖesonuawo le kɔkɔe ");
INSERT INTO ewe_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","tso ame siwo wɔ nu vɔ̃, eye woku la ƒe dzudzɔdosonuwo gbɔ. Na wòatsɔ dzudzɔdosonuawo atu ga gbadza aɖe atsyɔ vɔsamlekpui la dzi, elabena dzudzɔdosonu siawo le kɔkɔe esi wowɔ wo ŋu dɔ le Yehowa ŋkume ta. Ale ga gbadza si tsyɔ vɔsamlekpui la dzi la azu ŋkuɖodzinu na Israelviwo.” ");
INSERT INTO ewe_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Ale nunɔla Eleazar tsɔ akɔblidzudzɔdosonu alafa eve blaatɔ̃ la tu ga ɖeka hena vɔsamlekpui la dzi tsyɔtsyɔ ");
INSERT INTO ewe_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","be wòanye ŋkuɖodzinu na Israelviwo be ame sia ame si menye Aron ƒe dzidzimevi o la mekpɔ mɔ ava Yehowa ŋkume, eye wòado dzudzɔ o; ne menye nenema o la, nu si wɔ Korah kple eyomedzelawo la awɔ eya hã. Ale wowɔ ɖe ɖoɖo siwo Yehowa na Mose la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Esi ŋu ke ŋdi la, Israelviwo katã gade asi liʋĩliʋĩlilĩ me ɖe Mose kple Aron ŋu, henɔ gbɔgblɔm be, “Miewu Yehowa ƒe amewo.” ");
INSERT INTO ewe_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Ale ameha gã aɖe ƒo ƒu; kasia woakpɔ agbadɔ la gbɔ ɖa la, wokpɔ lilikpo la kple Yehowa ƒe ŋutikɔkɔe la. ");
INSERT INTO ewe_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mose kple Aron yi agbadɔ la ŋgɔ, ");
INSERT INTO ewe_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","eye Yehowa gblɔ na Mose be. ");
INSERT INTO ewe_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Mite ɖa le ame siawo gbɔ, ale be mate ŋu atsrɔ̃ wo enumake.” Ke Mose kple Aron wotsyɔ mo anyi le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Mose gblɔ na Aron be, “Netsɔ! Tsɔ dzudzɔdosonu ɖeka, ɖe dzo tso vɔsamlekpui la me de eme, da dzudzɔdonu ɖe edzi, ɖe abla kplii yi ameawo dome, eye nàlé avu ɖe wo nu, elabena Yehowa ƒe dɔmedzoe ge ɖe wo dome, eye dɔvɔ̃ to gɔ̃ hã xoxo.” ");
INSERT INTO ewe_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aron wɔ nu si Mose ɖo nɛ. Eƒu du yi ameawo dome, elabena dɔvɔ̃ la to xoxo. Etɔ dzo dzudzɔdonu la, eye wòlé avu ɖe wo nu. ");
INSERT INTO ewe_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Etsi tsitre ɖe ame kukuawo kple agbagbeawo dome, eye dɔvɔ̃ la nu tso, ");
INSERT INTO ewe_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ke ame akpe wuiene alafa adre (14,700) ku xoxo kpe ɖe ame siwo ku kple Korah le ŋkeke si do ŋgɔ la ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aron trɔ va Mose gbɔ le agbadɔ la ƒe mɔnu. Ale dɔvɔ̃ la nu tso. ");
INSERT INTO ewe_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Emegbe la, Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Gblɔ na Israelviwo be, ‘Ele be toawo ƒe kplɔla ɖe sia ɖe natsɔ atikplɔ si dzi wòŋlɔ eƒe ŋkɔ ɖo la vɛ na wò. ");
INSERT INTO ewe_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ele be Aron ƒe ŋkɔ nanɔ Levi ƒe viwo ƒe to la tɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Tsɔ atikplɔ siawo da ɖe agbadɔ la ƒe xɔ emetɔ me, afi si medoa go wò le, le nubablaɖaka la ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Mawɔ atikplɔ siawo ŋu dɔ be made dzesi ame si metia, elabena amea ƒe atikplɔ azu ati gbagbe, eye wòadze! Ekema Israelviwo ƒe liʋĩliʋĩlilĩ ɖe mia ŋu nu atso!’ ” ");
INSERT INTO ewe_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ale Mose gblɔ nya la na Israelviwo. Kplɔlawo dometɔ ɖe sia ɖe, ame siwo dome Aron hã nɔ la, tsɔ atikplɔ ɖeka vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mose tsɔ atikplɔawo da ɖe Yehowa ŋkume le agbadɔ la ƒe xɔ emetɔ me. ");
INSERT INTO ewe_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Esi ŋu ke wòyi la, ekpɔ be Aron ƒe atikplɔ si nye Levi ƒe to la tɔ la dze, eye seƒoƒowo de asi keke me le eŋu! ");
INSERT INTO ewe_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Esi Mose kɔ atikplɔawo tso Yehowa ƒe ŋkume do goe va fia Israelviwo la, wotsi yaa kple dzimaxɔse! Ame sia ame xɔ eƒe atikplɔ negbe Aron ko. ");
INSERT INTO ewe_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yehowa gblɔ na Mose be wòatsɔ Aron ƒe atikplɔ la ada ɖe nubablaɖaka la xa, wòanɔ afi ma tegbetegbe be wòaɖo ŋku aglãdzedze sia dzi na ameawo. Ne ame aɖe galĩ liʋĩliʋĩ tso Aron ƒe nɔƒe ŋu la, ekema ele be Mose nahe atikplɔ la do goe, atsɔ afia ameawo. Nu sia ana be dzɔgbevɔ̃e bubu magava ameawo dzi o. ");
INSERT INTO ewe_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Ale Mose wɔ nu siwo Yehowa ɖo nɛ. ");
INSERT INTO ewe_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israelviwo gblɔ na Mose be, “Míaku! Míebu, mí katã míebu! ");
INSERT INTO ewe_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ame sia ame si ate ɖe Yehowa ƒe agbadɔ la ŋu la, aku. Ɖe mí katã míele kuku gea?” ");
INSERT INTO ewe_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yehowa ƒo nu na Aron azɔ gblɔ be, “Enye wò kple viwò ŋutsuwo kple wò ƒometɔwo ƒe dɔdeasi be miakpɔ egbɔ be, nu kɔkɔe aɖeke mezu nu makɔmakɔ o, eye anye miawo ƒe vodada ne kpɔtsɔtsɔ aɖe ava miaƒe nunɔladɔwo wɔwɔ ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Kplɔ nɔviwò, Levi ƒe viwo, tso Levi ƒe to la me vɛ be woakpe ɖe ŋuwò, ne wò kple viwò ŋutsuwo miele subɔsubɔm le agbadɔ la ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Woawɔ dɔ le wò kpɔkplɔ te, eye woawɔ dɔ siwo katã ku ɖe agbadɔ la ŋu, gake womate ɖe agbadɔ la me nuwo alo vɔsamlekpui la ŋu o, ne wowɔe la, woawo kple wò siaa miaku. ");
INSERT INTO ewe_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Woanɔ ŋuwò awɔ dɔ, siwo katã le Mawu ƒe agbadɔ la ŋu. Ame sia ame si menye Levi ƒe vi o la mekpɔ mɔ akpe ɖe ŋuwò le mɔ aɖeke nu o. ");
INSERT INTO ewe_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Ɖo ŋku edzi be, nunɔlawo koe awɔ dɔ kɔkɔewo le kɔkɔeƒe la kple vɔsamlekpui la dzi. Ne miewɔ se siawo dzi la, Mawu ƒe dɔmedzoe magabi ɖe Israelviwo dometɔ aɖeke ŋu le se siawo dzi dada ta gbeɖegbeɖe o. ");
INSERT INTO ewe_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Megale egblɔm be, nye ŋutɔe tia nɔviwò Levi ƒe viwo tso Israelviwo dome na Yehowa ƒe dɔ be woanye wò kpeɖeŋutɔwo le agbadɔmedɔwɔwɔ me. ");
INSERT INTO ewe_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ke wò kple viwò ŋutsuwo, nunɔlawo, miawoe awɔ dɔ kɔkɔeawo katã kple dɔ siwo le vɔsamlekpui la ŋu kple esiwo le xɔmetsovɔ la me, elabena nunɔlanyenye nye miaƒe dɔdeasi tɔxɛ. Ame bubu ɖe sia ɖe si ake atse awɔ dɔ siawo la aku.” ");
INSERT INTO ewe_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yehowa gade se siawo na Aron. “Metsɔ nunana siwo katã Israelviwo tsɔna vɛ na Yehowa la na nunɔlawo. Nunana siwo katã wotsɔna naa Yehowa to wo nyenye le vɔsamlekpui la ŋgɔ me la nye wò kple viwò ŋutsuwo tɔ le se mavɔ la nu. ");
INSERT INTO ewe_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Nuɖuvɔsawo, nu vɔ̃ ŋuti vɔsawo kple fɔɖivɔsawo nye mia tɔ. Nu siwo wotsɔ vɛ abe kpɔɖeŋu ene be woame na Yehowa le vɔsamlekpui la dzi koe menye mia tɔ o. Nu siawo katã nye nunana kɔkɔewo. ");
INSERT INTO ewe_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ŋutsuwo koe aɖu wo, eye teƒe kɔkɔe aɖe ko woaɖu wo le. ");
INSERT INTO ewe_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Nunana bubuawo katã si Israelviwo anam to wo nyenye le vɔsamlekpui la ŋgɔ me la nye wò kple wò ƒometɔwo, viwò ŋutsuwo kple viwò nyɔnuwo siaa tɔ. Wò ƒometɔwo katã aɖu nu siawo negbe wo dometɔ si ŋu mekɔ le ɣe ma ɣi me o la ko. ");
INSERT INTO ewe_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Nenema ke kutsetse gbãtɔ siwo ameawo atsɔ vɛ na Yehowa abe ami, wain kple lu nyuitɔwo ");
INSERT INTO ewe_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","kple nuɖuɖu ɖe sia ɖe ene la hã nye mia tɔ. Miaƒe ƒometɔwo aɖu esiawo negbe ɖeko wo ŋuti mekɔ le ɣe ma ɣi me o. ");
INSERT INTO ewe_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Nu sia nu si le Israel, si ŋu wokɔ, ɖe ɖe aga na Yehowa la nye tɔwò. ");
INSERT INTO ewe_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Vi gbãtɔ ɖe sia ɖe, amegbetɔ kple lã siaa si wotsɔ na Yehowa la nye tɔwò. Ke ele na wò be nàƒle viŋutsuvi gbãtɔ kple lã makɔmakɔ ɖe sia ɖe ƒe lãtsu gbãtɔ ta. ");
INSERT INTO ewe_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ne woxɔ ɣleti ɖeka la, ele na wò be nàƒle wo ta, eye wo taƒlegae nye klosalo gram blaade, le kɔkɔeƒe la ƒe nudanu nu. ");
INSERT INTO ewe_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Ke womaxe fe ɖe nyiwo, alẽwo kple gbɔ̃wo ƒe ŋgɔgbeviwo ta o; elabena wole kɔkɔe. Nàhlẽ woƒe ʋu ɖe vɔsamlekpui la dzi, eye nàtɔ dzo ami la abe dzovɔsa si ʋẽna lĩlĩlĩ la ene na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Lã siawo ƒe lã nye mia tɔ hekpe ɖe woƒe akɔ kple ɖusita, si wotsɔna naa Yehowa to wo nyenye le vɔsamlekpui la ŋgɔ me la ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ɛ̃, metsɔ nunana siwo katã Israelviwo va naa Yehowa, eye wonyena le yame la na mi. Wonye wò kple wò ƒometɔwo ƒe nuɖuɖu. Esia nye dze ƒe nubabla mavɔ le Yehowa kple wò kple wò dzidzimeviwo dome.” ");
INSERT INTO ewe_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yehowa gblɔ na Aron be, “Mianyi woƒe anyigba ƒe dome o, eye miakpɔ gome le wo dometɔ aɖeke me o, nyee nye miaƒe gome kple miaƒe domenyinu le Israelviwo dome. ");
INSERT INTO ewe_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Metsɔ Israelviwo ƒe nuwo ƒe ewolia na Levi ƒe viwo abe woƒe domenyinu ene le woƒe dɔ si wowɔna le agbadɔ me la ta. ");
INSERT INTO ewe_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Tso azɔ dzi heyina la, Israelvi siwo menye nunɔlawo kple Levi ƒe viwo o la mekpɔ mɔ age ɖe agbadɔ la me o. Ne woge ɖee la, woaɖi fɔ, eye woaku. ");
INSERT INTO ewe_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Levi ƒe viwo koe awɔ dɔ le agbadɔ la ŋu. Woaɖi fɔ ne wogbe dɔ wɔwɔ le afi ma. Esia nye se na mi tegbetegbe be nunɔamesi aɖeke manɔ Levi ƒe vi aɖeke si le Israelnyigba dzi o, ");
INSERT INTO ewe_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","elabena Israelviwo ƒe nuwo ƒe ewolia si wotsɔ na Yehowa to wo nyenye le vɔsamlekpui la ŋgɔ me la anye Levi ƒe viwo tɔ. Eya ta megblɔ na wo be, ‘Domenyinu manɔ wo si le Israelviwo dome o.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Ƒo nu na Levi ƒe viwo, eye nàgblɔ na wo be, ‘Ne miexɔ nu ewolia si metsɔ na mi abe miaƒe domenyinu ene tso Israelviwo si la, ele na mi be miatsɔ nu ewolia mawo ƒe ewolia abe vɔsa na Yehowa ene. ");
INSERT INTO ewe_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Yehowa axɔ nu sia na mi abe miaƒe lu kple waintsetse gbãtɔwo ƒe nunana ene, abe ɖe wotso miawo ŋutɔ miaƒe agblewo me ene. ");
INSERT INTO ewe_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Ale miawo hã miana nu Yehowa tso nu ewolia siwo katã miexɔ tso Israelviwo gbɔ la me. Tso nu ewolia siawo me la, miatsɔ Yehowa ƒe ɖuƒe ana Aron, nunɔla la. ");
INSERT INTO ewe_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Ele be miatsɔ nu sia nu si wona la ƒe akpa nyuitɔ kple kɔkɔetɔ ana Yehowa abe eƒe ɖuƒe ene.’ ");
INSERT INTO ewe_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Gblɔ na Levi ƒe viwo be, ‘Ne mieɖe nyuitɔwo na adzɔe la, woabui na mi abe ɖe wotso miawo ŋutɔ miaƒe lugbɔƒe alo miaƒe wainfiaƒe ene. ");
INSERT INTO ewe_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Aron kple via ŋutsuwo kple eƒe ƒometɔwo aɖui le woƒe aƒewo me alo le teƒe ɖe sia ɖe si adze wo ŋu, elabena eyae nye woƒe fetu ɖe woƒe dɔwɔwɔ le agbadɔ la me ta. ");
INSERT INTO ewe_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Mi, Levi ƒe viwo la, miada vo o, ne miexɔ ameawo ƒe nuwo ƒe akpa ewolia ƒe ɖeka na Yehowa, eye mietsɔ nu siawo ƒe nyuitɔwo ƒe akpa ewolia ƒe ɖeka na nunɔlawo. Ke mikpɔ nyuie be miabu Israelviwo ƒe nunana kɔkɔewo abe nu dzodzrowo wonye ene o. Ne miewɔ esia la, miaku.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yehowa gblɔ na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Esiae nye se si Yehowa de. Migblɔ na Israelviwo be woatsɔ nyinɔ dzĩ si ŋu kpɔtsɔtsɔ aɖeke mele o, eye womede kɔkuti kɔ nɛ kpɔ o la vɛ na mi. ");
INSERT INTO ewe_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Mitsɔe na nunɔla Eleazar, miana wòahee ayi asaɖa la godo, eye wòana ame aɖe nawui le eŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Ekema nunɔla Eleazar ade eƒe asibidɛ ʋu la me, eye wòahlẽ ʋu la zi adre ɖe Agbadɔ la ƒe mɔnu lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Le esia megbe la, wòana woatɔ dzo nyinɔ la, eƒe agbalẽ, eƒe lã, eƒe ʋu kple eƒe afɔdzi siaa le eŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Nunɔla Eleazar atsɔ sedati kple kakle ƒe alɔdze kple ka dzĩ ada ɖe dzo la me. ");
INSERT INTO ewe_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Le esia megbe la, nunɔla anya eƒe awuwo, ale tsi, atrɔ ayi asaɖa la me, eye eŋuti makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Ame si tɔ dzo lã la hã anya eƒe awuwo, ale tsi, eye eya hã ŋuti makɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Ekema ame si ŋu kɔ la, aƒo nyinɔ la ƒe afi nu ƒu, eye woadae ɖe teƒe si ŋuti kɔ le asaɖa la godo afi si woadzrae ɖo na Israelviwo abe afi si woaku tsi le ene hena nuŋukɔkɔ ƒe wɔnawo na nu vɔ̃ ɖeɖe ɖa. ");
INSERT INTO ewe_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Ame si ƒo ƒu nyinɔ la ƒe afi la anya eƒe awuwo, eye eŋuti makɔ o va se ɖe fiẽ. Esia nye se na Israelviwo kple amedzro siwo le wo dome la tegbetegbe. ");
INSERT INTO ewe_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Ame sia ame si ka asi ame kuku ŋu la ŋuti makɔ o ŋkeke adre. ");
INSERT INTO ewe_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Ele be wòakɔ eɖokui ŋuti le ŋkeke etɔ̃lia kple adrelia gbe kple tsi, si tso nyinɔ la ƒe afi me. Ekema eŋuti akɔ. Ne mewɔ esia le ŋkeke etɔ̃lia dzi o la, ekema eƒe ŋutimakɔmakɔ la ayi edzi adze le ŋkeke adrelia gɔ̃ hã ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ame sia ame si aka asi ame kuku aɖe ŋu, eye mekɔ eɖokui ŋu le mɔ sia dzi o la gblẽ kɔ ɖo na Yehowa ƒe agbadɔ la, eye woaɖee ɖa le Israelviwo dome. Womehlẽ tsi kɔkɔe la ɖe eŋu o, eya ta makɔmakɔnyenye la gale eŋu ko. ");
INSERT INTO ewe_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Se siwo dzi woawɔ ne ŋutsu aɖe ku le agbadɔ aɖe me la woe nye esiawo: Ame sia ame si ge ɖe agbadɔ la me kple ame siwo nɔ agbadɔ la me ɣe ma ɣi la ŋuti mekɔ o ŋkeke adre. ");
INSERT INTO ewe_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Nu sia nu si nu nutunu mele o la ŋuti mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Ne ame aɖe le gbedzi, eye wòka asi ame si wowu le aʋa me alo ame si ku le mɔ bubu aɖe nu ƒe kukua ŋuti alo ka asi ame kuku aɖe ƒe ƒu alo yɔdo ŋu la, eŋuti mekɔ o ŋkeke adre. ");
INSERT INTO ewe_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Hena amea ŋuti kɔkɔ la, woatsɔ dzowɔ tso nyinɔ la ƒe numevɔsa ƒe dzowɔ me ade tsi dzidzi ƒe tsi me le tsiɖonu me. ");
INSERT INTO ewe_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ekema ame si ŋuti kɔ la, atsɔ kakle ƒe alɔdzewo ade tsi la me, eye wòahlẽ tsi la ɖe agbadɔ la kple ze kple gagbɛ siwo katã nɔ agbadɔ la me kple ame si ƒe agbadɔ la me nɔnɔ alo eƒe asikaka ameƒu alo ame kuku aɖe alo yɔdo aɖe ŋu na be eŋuti mekɔ o la ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Woawɔ nu sia le ŋkeke etɔ̃lia kple adrelia gbewo. Emegbe la, amea anya eƒe awuwo, ale tsi, eye eŋuti akɔ le fiẽ. ");
INSERT INTO ewe_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“Ke ne ame aɖe ŋuti mekɔ o, gake wògbe be yemakɔ ye ɖokui ŋuti o la, woaɖee ɖa le ha me, elabena egblẽ kɔ ɖo na Yehowa ƒe kɔkɔeƒe la, eye esi womehlẽ ameŋukɔtsi la ɖe eŋu o ta la, eŋuti mekɔ o. ");
INSERT INTO ewe_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Esia nye se na mi tegbetegbe. Ele be ame si hlẽ tsi kɔkɔe la ɖe amea ŋu la nanya eƒe awuwo emegbe. Ame sia ame si ka asi tsi la ŋu la ŋu mekɔ o va se ɖe fiẽ. ");
INSERT INTO ewe_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Nu sia nu si ŋu ame si ŋuti mekɔ o la ka asii la ŋu makɔ o va se ɖe fiẽ.” ");
INSERT INTO ewe_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Israelviwo ɖo Zin gbedzi le ƒea ƒe ɣleti gbãtɔ me. Woƒu asaɖa anyi ɖe Kades. Miriam ku, eye woɖii ɖe afi ma. ");
INSERT INTO ewe_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Tsi mebɔ ɖe afi ma na nono o, ale ameawo gadze aglã ɖe Mose kple Aron ŋu. Ameha gã aɖe ɖi anyi, ");
INSERT INTO ewe_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","eye wowɔ takpekpe ɖe Mose kple Aron ŋu. Wodo ɣli ɖe Mose ta gblɔ be, “Ɖe míawo hã míaku kple mía nɔvi lɔlɔ̃a siwo Yehowa wu hafi! ");
INSERT INTO ewe_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Ɖe nèɖoe koŋ kplɔ Yehowa ƒe amewo va gbedzi le afi sia be míawo kple míaƒe lãhawo siaa natsrɔ̃! ");
INSERT INTO ewe_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Nu ka koŋkoŋkoŋ ta nèna míedzo le Egipte, eye nèkplɔ mí va teƒe sesẽ sia ɖo? Ègblɔ na mí be míayi anyigba nyui si dzi nuku wɔnukuwo abe gbotiwo, wain tsetsewo kple yevuboɖatiwo ene le. Anyigba si ƒe nya nègblɔ na mí ɖe? Tsi teti gɔ̃ hã meli ade mía nu míano le afi sia o!” ");
INSERT INTO ewe_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mose kple Aron wotrɔ le wo gbɔ yi Agbadɔ la ƒe mɔnu. Wotsyɔ mo anyi le Yehowa ŋkume. Tete Yehowa ƒe ŋutikɔkɔe ɖe eɖokui fia wo. ");
INSERT INTO ewe_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Tsɔ Aron ƒe atikplɔ la. Mi kple Aron miƒo ameawo nu ƒu. Ƒo nu le ameawo ƒe ŋkume na agakpe si le afi mɛ ɖa la be wòana tsi nado tso eme; eye nàna tsi wo tso agakpe la me wòade na ameawo kple woƒe lãwo katã.” ");
INSERT INTO ewe_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mose wɔ nu si Mawu ɖo nɛ. Etsɔ atikplɔ la tso afi si wòdzrae ɖo le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mose kple Aron woyɔ ameawo, eye wona woƒo ƒu ɖe agakpe la gbɔ. Mose gblɔ na wo be, “Miɖo to, mi aglãdzelawo! Ɖe míaɖe tsi tso agakpe sia me na mia?” ");
INSERT INTO ewe_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mose kɔ atikplɔ la dzi, eye wòƒo agakpe la zi eve. Enumake tsi do bababa tso agakpe la me ameawo kple woƒe lãwo no. ");
INSERT INTO ewe_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Ke Yehowa gblɔ na Mose kple Aron be, “Zi ale si mieɖo ŋu ɖe ŋunye o, eye miekɔ ŋutinye le Israelviwo ŋkume o ta la, miakplɔ Israelviwo ade anyigba si ŋugbe medo na wo la dzi o!” ");
INSERT INTO ewe_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Wona ŋkɔ teƒe sia be Meriba, si gɔmee nye “Dzrewɔtsi,” elabena afi siae Israelviwo tso ɖe Yehowa ŋu le eye Yehowa ɖee fia wo be yele kɔkɔe le woƒe ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Esi Mose nɔ Kades la, eɖo amewo ɖe Edom fia gbɔ be, “Míawoe nye nɔviwò Israel ƒe dzidzimeviwo. Ènya ale si míaƒe ŋutinya wɔ nublanuii, ");
INSERT INTO ewe_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ale si mía tɔgbuiwo yi Egipte, nɔ afi ma ƒe geɖewo, eye wozu kluviwo na Egiptetɔwo. ");
INSERT INTO ewe_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Ke esi míedo ɣli na Yehowa la, ese míaƒe kokoƒoƒo, eye wòɖo mawudɔla aɖe ɖa wòva kplɔ mí dzoe le Egipte. “Fifia míele Kades. Míeƒu asaɖa anyi ɖe wò liƒo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Míeɖe kuku ɖe mɔ na mí míato wò anyigba dzi. Míakpɔ nyuie be míato miaƒe agblewo kple waingblewo me o. Míano tsi tso miaƒe vudowo me hã o. Míanɔ mɔ gã la dzi ko tẽe. Míadzo le mɔ gã la dzi o va se ɖe esime míado go le wò anyigba dzi.” ");
INSERT INTO ewe_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Ke Edom fia gblɔ na wo be, “Migaɖo afɔ nye anyigba dzi o! Ne mietee kpɔ be yewoaɖo afɔ nye anyigba dzi la, nye aʋakɔ akpe aʋa kpli mi!” ");
INSERT INTO ewe_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israelviwo ƒe ame dɔdɔwo yi edzi be, “Fia bubutɔ, mɔ gã la dzi ko míanɔ. Ne míano tsi tso miaƒe vudo me gɔ̃ hã la, míaxe fe ɖe sia ɖe si nàbia la ɖe eta. Ale si míatso eme ayi ko biam míele; míegale nu bubu aɖeke biam o.” ");
INSERT INTO ewe_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Edom fia gbe gbidigbidi gblɔ na wo be, “Migage ɖe nye anyigba dzi o.” Ena aʋakɔ gã aɖe ƒu asaɖa anyi ɖe eƒe liƒo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Esi Edom gbe be womato yeƒe anyigba dzi o ta la, Israelviwo glɔ̃ mɔ to Edom ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Israelviwo ƒe ha blibo la ho, dze mɔ tso Kades, eye wova ɖo Hor to la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Le Hor to la gbɔ, teƒe si te ɖe Edom ƒe liƒo ŋu la, Yehowa gblɔ na Mose kple Aron be, ");
INSERT INTO ewe_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Azã la su be Aron naku, elabena made anyigba, si metsɔ na Israelviwo la dzi o, le esi mi ame evea mietsi tsitre ɖe nye ɖoɖowo ŋu tso tsi si le Meriba ŋu la ta. ");
INSERT INTO ewe_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Azɔ, kplɔ Aron kple via Eleazar yi Hor to la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Ɖe Aron ƒe nunɔlawuwo le eŋuti, eye nàdo wo na via, Eleazar. Aron aku ɖe afi ma.” ");
INSERT INTO ewe_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Ale Mose wɔ nu si Yehowa ɖo nɛ. Wo ame etɔ̃ la wolia Hor to la esi ameawo katã nɔ wo kpɔm. ");
INSERT INTO ewe_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Esi woɖo toa tame la, Mose ɖe nunɔlawuawo le Aron ŋu, eye wòtsɔ wo do na Aron ƒe viŋutsu Eleazar. Aron ku ɖe to la tame. Mose kple Eleazar trɔ gbɔ, ");
INSERT INTO ewe_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","eye esi ameawo se be Aron ku la, Israelviwo fae ŋkeke blaetɔ̃. ");
INSERT INTO ewe_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Arad fia, tso Kanaanyigba dzi ƒe ŋkutsalawo to mɔ ɖeka kple Israelviwo. Esi Arad fia se be Israelviwo to Atarim mɔ gbɔna la, eho aʋa ɖe Israelviwo ŋu, eye wòɖe aboyo woƒe ame aɖewo. ");
INSERT INTO ewe_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Israelviwo ɖe adzɔgbe na Yehowa be, ne ana yewoaɖu Arad fia kple eƒe amewo dzi la, yewoagbã du siwo katã le afi ma la gudugudu. ");
INSERT INTO ewe_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Yehowa se woƒe kokoƒoƒo, eye wòna woɖu Kanaantɔwo dzi. Israelviwo gbã woƒe duwo gudugudu. Wona ŋkɔ teƒe ma tso ɣe ma ɣi be, “Horma” si gɔmee nye “Afi si wogbã duwo le gudugudu.” ");
INSERT INTO ewe_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Israelviwo trɔ yi Hor to la dzi, eye woɖo ta anyigbeme lɔƒo to mɔ si ɖo ta Ƒu Dzĩ la gbɔ la dzi be yewoaƒo xlã Edomnyigba. Nu sia ɖe dzi le Israelviwo ƒo ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Wode asi liʋĩliʋĩlilĩ me ɖe Mawu kple Mose ŋu be, “Nu ka ta miekplɔ mí dzoe le Egipte be míava ku ɖe gbedzi le afi sia? Naneke mele afi sia míaɖu o, tsi meli míano o, mana sia hã va ti mí azɔ.” ");
INSERT INTO ewe_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Ale Yehowa dɔ da vɔ̃ɖiwo ɖe Israelviwo dome woɖu ame geɖewo, eye woku. ");
INSERT INTO ewe_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ameawo va Mose gbɔ hedo ɣli be, “Míewɔ nu vɔ̃, elabena míeƒo nu tsi tsitre ɖe wò kple Yehowa ŋu. Ɖe kuku na Yehowa na mí be wòaɖe dawo ɖa.” Ale Mose do gbe ɖa ɖe ameawo ta. ");
INSERT INTO ewe_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yehowa gblɔ na Mose be, “Tsɔ akɔbli nàwɔ nu si aɖi da siawo dometɔ ɖeka la da ɖe ati tutu aɖe tame. Ame sia ame si da aɖu la, ne ekpɔ akɔblida la ko la, atsi agbe!” ");
INSERT INTO ewe_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ale Mose wɔ akɔblida la, eye wòkɔe tɔ ɖe ati si wotu la nu. Ne da ɖu ame aɖe, eye wòwu mo dzi kpɔ akɔblida la ko la, etsia agbe. ");
INSERT INTO ewe_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israelviwo tso afi sia yi Obot. Woƒu asaɖa anyi ɖe afi ma. ");
INSERT INTO ewe_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Tso Obot la, woyi Iye Abarim le gbedzi afi si te ɖe Moab ƒe ɣedzeƒe ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Woƒu asaɖa anyi ɖe Zered tɔʋu la ƒe balime. ");
INSERT INTO ewe_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Wotso eme yi Arnon tɔsisi la ƒe akpa kemɛ si te ɖe Amoritɔwo ƒe liƒo ŋu. Arnon tɔsisi lae nye liƒo le Moabtɔwo kple Amoritɔwo dome. ");
INSERT INTO ewe_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Eya ta woŋlɔ ɖe Yehowa ƒe Aʋawɔwɔwo ƒe Agbalẽ la me be, Zahad le Sufa kple Arnon tɔsisi la, ");
INSERT INTO ewe_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","tɔʋu la me tsi, si ɖo ta Ar nutowo me eye wòdo liƒo na Moabtɔwo. ");
INSERT INTO ewe_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Tso afi sia la, Israelviwo zɔ mɔ yi Beer. Ŋkɔ sia gɔmee nye “Vudo.” Afi siae Yehowa gblɔ na Mose le be, “Ƒo ameawo nu ƒu, eye mana tsi wo.” ");
INSERT INTO ewe_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Israel dzi ha be, “Dzi tsi, O vudo! Midzi ha tso tsi la ŋu! ");
INSERT INTO ewe_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Esiae nye vudo si amegãwo kple dukɔ la ƒe bubumewo tsɔ woƒe atikplɔwo kple woƒe atizɔtiwo ɖee la.” Wodzo le gbegbe la, ");
INSERT INTO ewe_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","eye woto Matana, Nahaliel kple Bamot, ");
INSERT INTO ewe_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","eye woyi balime si le Moab ƒe togbɛwo te, afi si gbegbe la kple Pisga to dzena le tso adzɔge. ");
INSERT INTO ewe_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Azɔ la, Israelviwo ɖo ame dɔdɔwo ɖe Sixɔn, Amoritɔwo ƒe fia gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Woɖe kuku na fia la be, “Na míato wò anyigba dzi ayi. Míadze ato agblewo alo wainbɔwo me o, eye míele vudometsi hã no ge o. Míale mɔ gã la tẽ va se ɖe esime míatso wò anyigba me ayi.” ");
INSERT INTO ewe_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Fia Sixɔn gbe mɔɖeɖe na Israel be wòato eƒe anyigba dzi ayi o. Sixɔn ƒo eƒe aʋakɔ blibo la nu ƒu eye wòho aʋa ɖe Israel ŋu le gbedzi esi woɖo Yahaz. ");
INSERT INTO ewe_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israelviwo ɖu wo dzi, eye woxɔ woƒe anyigba tso Arnon tɔsisi la ŋu va se ɖe Yabok tɔsisi la ŋu, heyi ɖe Amonitɔwo ƒe liƒo dzi. Israelviwo megate ŋu yi ŋgɔ wu afi sia o, elabena Amoritɔwo, ame siwo nye Lot ƒe dzidzimeviwo la nye aʋawɔla sesẽwo. ");
INSERT INTO ewe_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israelviwo xɔ Amoritɔwo ƒe duwo katã, eye wonɔ wo me; Hesbon kple kɔƒe siwo ƒo xlãe la hã nɔ eme. ");
INSERT INTO ewe_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hesbon nye Sixɔn, Amoritɔwo ƒe fia ƒe du. Sixɔn wɔ aʋa kple Moabtɔwo ƒe fia xoxo la, eye wòxɔ eƒe anyigba katã yi keke Arnon. ");
INSERT INTO ewe_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Eya ta hakpala la gblɔ be, “Va Hesbon, eye nàna woagbugbɔe atu, na woagbugbɔ Sixɔn ƒe du la aɖo te. ");
INSERT INTO ewe_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Elabena dzo do tso Hesbon, dzo ƒe aɖewo tso Sixɔn ƒe du me. Fia Moab ƒe Ar, Arnon ƒe todzitɔwo, ");
INSERT INTO ewe_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","baba na wò, O Moab! Wotsrɔ̃ mi, Kemostɔwo! Ena via ŋutsuwo zu sisilawo, eye via nyɔnuwo zu aboyomewo na Sixɔn, Amoritɔwo ƒe fia. ");
INSERT INTO ewe_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Ke míawo míeɖu wo dzi wotsrɔ̃ Hesbon yi keke Dibon míegbã wo yi keke Nofa, yi kekeke Medeba.” ");
INSERT INTO ewe_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Ale Israelviwo nɔ Amoritɔwo ƒe anyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Esime Mose ɖo ŋkutsalawo ɖe Yazer megbe la, Israelviwo xɔ du sue siwo ƒo xlãe, eye wonya Amoritɔwo, ame siwo nɔ afi ma la le woƒe anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Le esia megbe la, wotrɔ ɖe Basab du la ŋu. Ke Ɔg, Basan fia, kpe aʋa kpli wo le Edrei. ");
INSERT INTO ewe_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yehowa gblɔ na Mose be, “Mègavɔ̃e o, elabena matsɔ eya ŋutɔ kple eƒe aʋakɔ blibo la kpakple eƒe anyigba la ade asi na wò; eye nawɔe abe ale si nèwɔ fia Sixɔn, Amoritɔwo ƒe fia le Hesbon ene.” ");
INSERT INTO ewe_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Eva eme nenema tututu. Israel ɖu dzi. Wowu Ɔg, Basan fia, via ŋutsuwo kple eteviwo ale gbegbe be aʋawɔlawo dometɔ ɖeka pɛ gɔ̃ hã metsi agbe o. Ale Israelviwo xɔ anyigba la. ");
INSERT INTO ewe_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Israelviwo zɔ mɔ azɔ yi Moab tagba, eye woƒu asaɖa anyi ɖe Yɔdan tɔsisi la ƒe ɣedzeƒe lɔƒo le Yeriko kasa. ");
INSERT INTO ewe_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Azɔ la, Balak, Zipɔr ƒe viŋutsu kpɔ nu si Israelviwo wɔ Amoritɔwo, ");
INSERT INTO ewe_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","eye vɔvɔ̃ ɖo Moab, elabena ameawo sɔ gbɔ ŋutɔ. Nyateƒe, dzidzi ƒo Moab le Israelviwo ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Wowɔ takpekpe kple Midiantɔwo ƒe kplɔlawo enumake. Wogblɔ be, “Ameha gã sia aɖu mí abe ale si nyitsu ɖua gbe ene.” Ale Balak, Zipɔr ƒe vi, ame si nye Moab fia ɣe ma ɣi la, ");
INSERT INTO ewe_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ɖo amewo ɖa be woayɔ Balaam, Beor ƒe viŋutsu, ame si nɔ Petor, afi si te ɖe tɔsisi la ŋu vɛ. Balak gblɔ be, “Dukɔ aɖe tso Egipte; wotsyɔ anyigba ŋkume, eye wole teƒe aɖe si te ɖe ŋunye. ");
INSERT INTO ewe_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Azɔ la, va nàƒo fi ade ame siawo, elabena wosẽ akpa na mí. Ekema, ɖewohĩ, mate ŋu aɖu wo dzi, eye manya wo dzoe le anyigba la dzi. Elabena menya be ame siwo nèyrana la kpɔa yayra, eye ame siwo nèƒoa fi dena la kpɔa fiƒode.” ");
INSERT INTO ewe_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Ame siwo wòdɔ ɖo ɖe Balaam gbɔ la woe nye, Moabtɔwo kple Midiantɔwo ƒe ametsitsiwo. Wotsɔ ga ɖe asi yi na Balaam, eye woɖe nu si Balak di be wòawɔ na ye la me nɛ nyuie. ");
INSERT INTO ewe_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaam gblɔ na wo be, “Mitsi afi sia dɔ. Etsɔ ŋdi la, magblɔ nu sia nu si Yehowa agblɔ nam be magblɔ la na mi.” Ale wotsi afi ma dɔ. ");
INSERT INTO ewe_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Le zã me la, Mawu va Balaam gbɔ, eye wòbiae be, “Ame kawoe nye ame siawo?” ");
INSERT INTO ewe_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaam ɖo eŋu na Mawu be, “Wotso Balak, Moab fia gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Fia la gblɔ be, ameha gã aɖe tso Egipte va ɖo yeƒe anyigba ƒe liƒo dzi, eye wòdi be mayi enumake aɖaƒo fi ade wo na ye, ale be yeate ŋu awɔ aʋa kpli wo, aɖu wo dzi.” ");
INSERT INTO ewe_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Mawu gblɔ na Balaam be, “Mègayi ɖaƒo fi de wo o, elabena meyra wo xoxo!” ");
INSERT INTO ewe_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Esi ŋu ke la, Balaam gblɔ na Balak ƒe ameawo be, “Mitrɔ dzo! Yehowa meɖe mɔ nam be mawɔ nu si miaƒe fia di be mawɔ o.” ");
INSERT INTO ewe_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Ale Fia Balak ƒe ame dɔdɔwo trɔ dzo, Balaam medze wo yome o. ");
INSERT INTO ewe_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Esi woka nya la ta na Balak la, egadɔ amewo ɖe Balaam. Eƒe ame dɔdɔwo sɔ gbɔ azɔ, eye wonye ame ŋkutawo wu ame dɔdɔ gbãtɔwo. ");
INSERT INTO ewe_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Woyi Balaam gbɔ, eye wogblɔ nɛ be, “Esiae nye nya si Balak, Zipɔr ƒe viŋutsu gblɔ, ‘Mègana naneke naxe mɔ na wò be màva gbɔnye o, ");
INSERT INTO ewe_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","elabena maxe fe na wò nyuie, eye mawɔ nu sia nu si nàgblɔ nam be mawɔ. Va, nàƒo fi ade ame siawo nam.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Ke Balaam ɖo eŋu be, “Ne Balak tsɔ fiasã si klosalo kple sika yɔ gɔ̃ hã anam la, nyemate ŋu awɔ naneke si atsi tsitre ɖe Yehowa, nye Mawu ƒe gbeɖeɖe ŋu o. ");
INSERT INTO ewe_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Mitsi afi sia dɔ ale be makpɔe ɖa be Yehowa agatsɔ nane akpe ɖe nya si wògblɔ nam zi gbãtɔ la ŋu mahã.” ");
INSERT INTO ewe_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Le zã me la, Mawu gblɔ na Balaam be, “Fɔ, nàyi kple ame siawo, ke kpɔ nyuie be, nàgblɔ nu si magblɔ na wò be nàgblɔ la ko.” ");
INSERT INTO ewe_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ale le ŋdi la, Balaam lia eƒe tedzi dzi, eye wòdze ameawo yome. ");
INSERT INTO ewe_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ke Mawu do dɔmedzoe ŋutɔ esi Balaam yina, eye Yehowa ƒe dɔla tsi tsitre ɖe mɔa dzi be yeatsi tsitre ɖe eŋu. Ke Balaam nɔ eƒe tedzi dzi, eye eƒe subɔla eve nɔ eŋu. ");
INSERT INTO ewe_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Esi tedzi la kpɔ Yehowa ƒe dɔla wòtsi tsitre ɖe mɔa dzi, eye yi le esi la, edzo le mɔa dzi yi gbe me. Balaam ƒoe be wòatrɔ ayi mɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Azɔ la, mawudɔla la tsi tsitre ɖe afi si mɔ la to waingble eve ƒe glikpɔwo dome le. ");
INSERT INTO ewe_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Esi tedzi la kpɔe wònɔ tsitre ɖe afi ma la, edze nɛ to glikpɔ ɖeka ŋu tututu, eye wòna Balaam ƒe afɔwo lili ɖe glikpɔ la ŋu. Ale Balaam gaƒoe. ");
INSERT INTO ewe_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Mawudɔla la gayi ɖatsi tsitre ɖe teƒe aɖe, afi si mɔa xaxa le ale gbegbe be tedzi la magate ŋu ato exa kura o. ");
INSERT INTO ewe_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Ale tedzi la tsyɔ akɔ anyi ɖe mɔ la dzi. Balaam do dɔmedzoe vevie, eye wòƒo tedzi la kple eƒe atikplɔ. ");
INSERT INTO ewe_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Tete Yehowa na be tedzi la nate ŋu aƒo nu. Tedzi la bia Balaam be, “Nu ka mewɔ si na be nàƒom zi etɔ̃?” ");
INSERT INTO ewe_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaam do ɣli ɖe tedzi la ta be, “Elabena èdo lãm! Ɖe yi aɖe anɔ asinye hafi; anye ne mawu wò.” ");
INSERT INTO ewe_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Tedzi la gabiae be, “Ɖe mewɔ nu sia tɔgbi aɖe kpɔ le nye agbenɔnɔ blibo mea?” Balaam ɖo eŋu be, “Ao.” ");
INSERT INTO ewe_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Tete Yehowa ʋu Balaam ƒe ŋkuwo. Ekpɔ mawudɔla la wòtsi tsitre ɖe mɔa dzi, eye wòlé yi ɖe asi. Enumake Balaam mlɔ anyigba le mawudɔla la ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Mawudɔla la bia Balaam be, “Nu ka ta nèƒo wò tedzi la zi etɔ̃? Meva be mana màgawɔ nu si nèdi be yeawɔ o, elabena èɖo ta tsɔtsrɔ̃ me. ");
INSERT INTO ewe_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Wò tedzi la kpɔm zi etɔ̃, eye wòte ɖa le gbɔnye zi etɔ̃. Ne menye ɖe wòdze nam o la, anye ne mewu wò xoxo, ke mana eya natsi agbe.” ");
INSERT INTO ewe_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaam ʋu eme na mawudɔla la be, “Mewɔ nu vɔ̃. Nyemenya be ènɔ afi ma o. Ne mèdi be magayi nye mɔzɔzɔ la dzi o la, matrɔ ayi aƒe.” ");
INSERT INTO ewe_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mawudɔla la gblɔ nɛ be, “Yi kple ameawo, gake nàgblɔ nu si meɖo na wò be nàgblɔ la ko.” Ale Balaam yi kple Balak ƒe ameawo. ");
INSERT INTO ewe_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Esi Fia Balak se be Balaam gbɔna la, edzo le eƒe fiadu la me, eye wòyi be yeakpee le Arnon tɔsisi la gbɔ le eƒe anyigba ƒe liƒo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balak bia Balaam be, “Nu ka ta nètsi anyi wòdidi alea hafi nèva ɖo? Medo ŋugbe na wò be made bubu gã ŋuwò. Ɖe mèxɔe se oa?” ");
INSERT INTO ewe_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaam ɖo eŋu na Balak be, “Meva, gake ŋusẽ mele asinye be magblɔ nya aɖeke o, negbe esi Mawu ɖo nam be magblɔ la ko, eye eya koe nye nya si magblɔ.” ");
INSERT INTO ewe_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaam kple Balak dze fia la yome yi Kiriat Huzot. ");
INSERT INTO ewe_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Fia Balak tsɔ nyitsuwo kple alẽwo sa vɔe le afi ma, eye wòtsɔ lãwo na ame dɔdɔwo kple Balaam hena woawo hã ƒe vɔsawo. ");
INSERT INTO ewe_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Esi ŋu ke ŋdi la, Fia Balak kplɔ Balaam yi Bamɔt Baal to la dzi, afi si Balaam ate ŋu akpɔ Israelviwo wogbagba ɖe anyigba la me le eŋkume le. ");
INSERT INTO ewe_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaam gblɔ na Fia Balak be, “Tu vɔsamlekpui adre ɖe afi sia, eye nàdi nyitsuvi adre kple agbo adre na vɔsawo.” ");
INSERT INTO ewe_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balak wɔ ɖe Balaam ƒe ɖoɖowo dzi, eye wòtsɔ nyitsuvi ɖeka kple agbo ɖeka sa vɔe ɖe vɔsamlekpuiawo dometɔ ɖe sia ɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Balaam gblɔ na Balak be, “Nɔ afi sia le wò numevɔsa gbɔ esime meɖe kpɔ. Ɖewohĩ Yehowa ava do gom. Nu sia nu si wòaɖe afiam la, magblɔe na wò.” Ale wòyi togbɛ ƒeƒle aɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Mawu do goe, eye Balaam gblɔ nɛ be, “Metu vɔsamlekpui adre, eye metsɔ nyitsu ɖeka kple agbo ɖeka sa vɔe ɖe vɔsamlekpui ɖe sia ɖe dzi.” ");
INSERT INTO ewe_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Yehowa gblɔ nya aɖe na Balaam be wòagblɔ na Fia Balak. ");
INSERT INTO ewe_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Esi Balaam trɔ gbɔ la, fia la kple Moab fiaviwo katã wonɔ tsitre ɖe numevɔsawo gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Nya siwo Balaam gblɔ la woe nye: “Fia Balak, Moabtɔwo ƒe fia, kplɔm tso Aramnyigba dzi, tso ɣedzeƒetowo dzi hegblɔ nam be. ‘Va, nàƒo fi ade Yakob nam! Eye va nàdo ɖiŋu na Israel nam. Wò dɔmedzoe nabi ɖe Israel ŋu.’ ");
INSERT INTO ewe_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ke ame siwo Mawu meƒo fi de o la, aleke nye ya maƒo fi ade woe? Ame siwo gbɔ Yehowa megbe nu le o la, aleke nye ya magbe nu le wo gbɔe? ");
INSERT INTO ewe_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Mele wo kpɔm tso agakpe tame. Melé ŋku ɖe wo ŋu tso togbɛwo dzi, wole wo ɖokui si, nye dukɔ tɔxɛ aɖe. Si mebua eɖokui kple dukɔ bubuwo o. ");
INSERT INTO ewe_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ame ka ate ŋu axlẽ Yakob ƒe ʋuʋudedi, alo axlẽ Israel ƒe akpa enelia? Na maku ame dzɔdzɔe ƒe ku, eye nye nuwuwu nanɔ abe wo tɔ ene!” ");
INSERT INTO ewe_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Fia Balak bia Balaam be, “Ao! Nu kae nye esi nèwɔm? Mebe nàƒo fi ade nye futɔwo nam, ke kpɔ ɖa, èyra wo boŋ!” ");
INSERT INTO ewe_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Balaam ɖo eŋu be, “Ɖe mate ŋu agblɔ nya aɖe ne Yehowa megblɔe nam be magblɔ oa?” ");
INSERT INTO ewe_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Balak gblɔ nɛ be, “Va míyi teƒe bubu. Le afi ma la, àkpɔ Israel dukɔ la ƒe akpa aɖe ko. Ƒo fi de ame mawo ɖeɖe ko nam!” ");
INSERT INTO ewe_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ale Fia Balak kplɔ Balaam yi Zofim gbedzi le Pisga to la tame. Etu vɔsamlekpui adre ɖe afi ma, eye wòtsɔ nyitsuvi ɖeka kple agbo ɖeka sa vɔe ɖe vɔsamlekpuiawo dometɔ ɖe sia ɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaam gblɔ na Balak be, “Tsi tsitre ɖe afi sia, ɖe wò numevɔsa la gbɔ ne mayi aɖado go Yehowa.” ");
INSERT INTO ewe_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yehowa do go Balaam, eye wòde nya asi nɛ be, “Trɔ yi Balak gbɔ nàgblɔ nya sia nɛ.” ");
INSERT INTO ewe_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaam trɔ va afi si Moab fia kple Moab fiaviŋutsuwo le tsitre ɖe woƒe numevɔsawo gbɔ le. Balak bia enumake be, “Nya ka Yehowa gblɔ?” ");
INSERT INTO ewe_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaam ɖo eŋu be, “Balak, Tsi tsitre eye nàsee: Ɖo tom, wò Zipɔr ƒe vi. ");
INSERT INTO ewe_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Mawu menye amegbetɔ, aka aʋatso o. Metrɔa eƒe tameɖoɖo. Abe amegbetɔwo ene o. Ɖe wòdo ŋugbe kpɔ gbe edziwɔwɔa? ");
INSERT INTO ewe_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Kpɔ ɖa, Mawu ɖe gbe nam be mayra Israelviwo. Mawu ŋutɔ yra wo xoxo, nyemate ŋu aklo yayra sia ɖa o! ");
INSERT INTO ewe_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Mekpɔ nu vɔ̃ le Yakob me o: mawɔ funyafunya Israel o! Yehowa, woƒe Mawu la li kpli wo. Eye dzidzɔɣli le wo nu, eyae nye woƒe fia! ");
INSERT INTO ewe_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Mawu kplɔ wo tso Egipte; Israel sẽ abe to ene. Fiƒode aɖeke mate ŋu anɔ Yakob dzi o, ");
INSERT INTO ewe_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","dzoka maɖi Yakob ŋu o. Ne wosa vɔ kɔ ɖe Israelviwo dzi hã la, maɖi wo ŋu akpɔ o, elabena woagblɔ le Israel ŋu azɔ be, ‘Mawu wɔ nu gãwo na wo! ");
INSERT INTO ewe_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ame siawo tsi tsitre abe dzatanɔ ene; womamlɔ anyi o. Va se ɖe esime woaɖu nu si wolé. Eye woano nu si wolé la ƒe ʋu!’ ” ");
INSERT INTO ewe_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Balak blu ɖe Balaam ta be, “Ne mànya ƒo fi ade wo o ko la, ekema mègayra wo hã o!” ");
INSERT INTO ewe_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaam ɖo eŋu be, “Ɖe nyemegblɔe na wò be nya sia nya si Yehowa agblɔ nam be magblɔ la ko wòle be magblɔ oa?” ");
INSERT INTO ewe_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Balak gagblɔ na Balaam le eƒe nyagblɔɖi etɔ̃lia ŋu be, “Makplɔ wò agayi teƒe bubu aɖee. Ɖewohĩ adze Mawu ŋu be wòana nàƒo fi ade wo tso afi ma azɔ.” ");
INSERT INTO ewe_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ale Fia Balak kplɔ Balaam yi Peor to la dzi le gbegbe la tame. ");
INSERT INTO ewe_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaam gagblɔ na Balak be wòatu vɔsamlekpui adre, eye wòatsɔ nyitsuvi adre kple agbo adre asa vɔe. ");
INSERT INTO ewe_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Balak wɔ nu si Balaam ɖo nɛ la, eye wòtsɔ nyitsuvi ɖeka kple agbo ɖeka sa vɔe ɖe vɔsamlekpuiawo dometɔ ɖe sia ɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaam dze sii azɔ be edze Yehowa ŋu be yeayra Israel, eya ta megayi ɖaka nu abe ale si wòwɔna tsã la ene o, ke boŋ edze ŋgɔ gbegbe la. ");
INSERT INTO ewe_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Esi Balaam kpɔ eŋgɔ la, ekpɔ Israelviwo woƒu asaɖa anyi ɖe woƒe to vovovoawo me. Tete Mawu ƒe Gbɔgbɔ ɖiɖi ɖe edzi, ");
INSERT INTO ewe_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","eye wògblɔ nya ɖi be, “Balaam, Beor ƒe viŋutsu gblɔ be: ame si kpɔa nu nyuie la ƒe nyagblɔɖi, ");
INSERT INTO ewe_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ame si sea Mawu ƒe nya la ƒe nyagblɔɖi, ame si xɔa ɖeɖefia tso Ŋusẽkatãtɔ la gbɔ, ame si tsyɔa mo anyi, eye eƒe ŋku nɔa te la ƒe nyawo. ");
INSERT INTO ewe_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“O! Yakob, wò agbadɔwo dzeani loo! O! Israel, wò nɔƒewo nyo! ");
INSERT INTO ewe_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Wokeke abe balimewo ene. Wole abe amabɔ siwo le tɔsisi to ene. Wole abe aloe si Yehowa do ene. Wole abe sedati le tɔwo to ene. ");
INSERT INTO ewe_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Tsi asi tso woƒe tɔkpowo me. Tsi anɔ woƒe kuwo me fũu. “Woƒe fia axɔ ŋkɔ wu Agag. Woado woƒe fiaɖuƒe ɖe dzi. ");
INSERT INTO ewe_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Mawu kplɔ wo do goe tso Egipte. Woƒe ŋusẽ le abe to ƒe ŋusẽ ene. Wovuvu dukɔ siwo tso ɖe wo ŋu, eye woŋe woƒe ƒuwo wuliwuli heŋɔ wo kple woƒe aŋutrɔwo. ");
INSERT INTO ewe_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Wole adeklo dzi abe dzata ene, eye abe dzatanɔ ene la, ame ka ate ŋu anyɔ wo? “Woayra ame siwo yraa wò. Eye woaƒo fi ade ame siwo ƒoa fi dea wò!” ");
INSERT INTO ewe_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Fia Balak do dɔmedzoe vevie azɔ ɖe Balaam ŋu. Eƒo asikpe hedo ɣli be, “Meyɔ wò be nàƒo fi ade nye futɔwo, ke nèyra wo boŋ zi etɔ̃. ");
INSERT INTO ewe_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Dzo le afi sia! Trɔ yi mia de! Medi be made bubu gã aɖe ŋuwò, ke Yehowa te wò ɖe megbe tso bubu gã sia gbɔ!” ");
INSERT INTO ewe_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaam ɖo eŋu na Balak be, “Ɖe nyemegblɔe na wò ame dɔdɔwo ");
INSERT INTO ewe_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","be ne Balak tsɔ klosalo kple sika de fiasã aɖe me wòyɔ kpikpikpi nam hã la, nyemate ŋu agblẽ Yehowa ƒe nyawo ɖi agblɔ nye ŋutɔ nye nyawo oa? Megblɔ be nya si Yehowa agblɔ la ko magblɔ! ");
INSERT INTO ewe_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","“Ɛ̃, matrɔ azɔ ayi nye ŋutɔ nye amewo dome. Ke gbã la, na magblɔ nu si Israelviwo awɔ wò amewo la na wò!” ");
INSERT INTO ewe_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Ale wògblɔ nyagblɔɖi siawo nɛ: “Balaam, Beor ƒe viŋutsue nye ame si ƒe ŋkuwo woʋu! ");
INSERT INTO ewe_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Esea Mawu ƒe nyawo, nunya tso Dziƒoʋĩtɔ la gbɔ le esi. Ekpɔa nu si Mawu Ŋusẽkatãtɔ la ɖena fianɛ. Etsyɔ mo anyi, eye eƒe ŋkuwo ʋu. ");
INSERT INTO ewe_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Mekpɔe le Israel ŋgɔ be, le ŋgɔgbe ʋĩi la, ɣletivi aɖe adzɔ tso Yakob me! Dziɖula sia tso Israel. Aɖu Moabtɔwo dzi; atsrɔ̃ Set ƒe viwo. ");
INSERT INTO ewe_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Israel axɔ Edom kple Seir siaa; woaɖu woƒe futɔwo dzi. Ke Israel akpɔ ŋusẽ ");
INSERT INTO ewe_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","dziɖula atso Yakob, eye wòagbã du geɖewo.” ");
INSERT INTO ewe_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Balaam kpɔ Amalektɔwo ƒe aƒewo dzi ɖa, eye wògblɔ nya ɖi be, “Amalek nye gbãtɔ le dukɔwo dome tsã Ke tsɔtsrɔ̃ koe le ŋgɔ nɛ fifia!” ");
INSERT INTO ewe_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ekpɔ Kenitɔwo dzi ɖa hegblɔ be, “Ɛ̃, èle teƒe sesẽ aɖe, èwɔ wò atɔwo ɖe agakpewo me, ");
INSERT INTO ewe_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ke woatsrɔ̃ mi, Kenitɔwo. Asiria fia ƒe aʋakɔ sesẽ la aɖe aboyo mi tso anyigba sia dzi!” ");
INSERT INTO ewe_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ewu eƒe nyagblɔɖi la nu be, “Aléle! Ame ka ate ŋu anɔ agbe ne Mawu wɔ nu sia? ");
INSERT INTO ewe_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Tɔdziʋuwo atso Kipro ƒuta woaɖu Eber kple Asiria dzi, ke woaɖu woawo hã dzi.” ");
INSERT INTO ewe_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ale Balaam kple Balak klã mɔ, eye wo dometɔ ɖe sia ɖe trɔ yi wo de. ");
INSERT INTO ewe_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Esime Israelviwo ƒu asaɖa anyi ɖe Sitim la, woƒe ɖekakpui aɖewo de asi ahasiwɔwɔ me kple Moab ɖetugbiwo. ");
INSERT INTO ewe_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Ɖetugbi siawo kplɔa wo yia woƒe mawuwo ƒe vɔsawo teƒewo. Le ɣeyiɣi kpui aɖe megbe la, ɖekakpuiawo megadea vɔsawo teƒewo ɖeɖe ko o, ke boŋ wodea ta agu na woƒe legbawo. ");
INSERT INTO ewe_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Sẽe kple sẽe ko la, Israelviwo katã de asi Moabtɔwo ƒe mawu, Baal Peor subɔsubɔ me. Yehowa ƒe dɔmedzoe bi ɖe Israelviwo ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Yehowa de se sia na Mose be, “Wu Israel ƒe towo katã ƒe kplɔlawo. Trɔ wo ɖe ati nu le Yehowa ŋkume le ŋdɔkutsu dzati nu ale be nye dɔmedzoe ɖe ameawo ŋu nu natso.” ");
INSERT INTO ewe_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Ale Mose ɖe gbe na Israel ʋɔnudrɔ̃lawo be woawu ame siwo katã subɔ Baal Peor. ");
INSERT INTO ewe_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Gbe ɖeka la, Israel ŋutsu aɖe kplɔ Midian ɖetugbi aɖe amemabumabutɔe va asaɖa la me le Mose kple ameawo katã ŋkume, esime wonɔ avi fam le Agbadɔ la ƒe ʋɔtru nu. ");
INSERT INTO ewe_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Esi Finehas, nunɔla Eleazar ƒe viŋutsu kple nunɔla Aron ƒe tɔgbuiyɔvi kpɔ nu sia la, etso zia, tsɔ akplɔ, ");
INSERT INTO ewe_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ƒu du ti Israel ŋutsu la yome yi eƒe agbadɔ me, afi si wòkplɔ ɖetugbi la yii. Etɔ akplɔ ŋutsu la wòto eƒe dɔ me do heŋɔ dɔme na ɖetugbi la hã. Ale dɔvɔ̃ la nu tso ");
INSERT INTO ewe_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","esime wòwu ame akpe blaeve-vɔ-ene (24,000) xoxo. ");
INSERT INTO ewe_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Finehas, Eleazar ƒe viŋutsu kple nunɔla Aron ƒe tɔgbuiyɔvi na nye dɔmedzoe nu tso, elabena eya hã do dɔmedzoe abe nye ke ene le nye bubu ta. Eya ta nyemagatsrɔ̃ Israel blibo la abe ale si meɖo ene o. ");
INSERT INTO ewe_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Eya ta gblɔ nɛ be, mele nye ŋutifafa ƒe nubabla wɔm kplii. ");
INSERT INTO ewe_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Eya kple eƒe dzidzimeviwo anɔ nubabla me kplim tso nunɔladɔwɔwɔ tegbetegbe ŋu, elabena etsi dzi ɖe eƒe Mawu ƒe bubu ŋu ele wòlé avu ɖe Israelviwo nu.” ");
INSERT INTO ewe_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Israelvi si wowu kple Midian ɖetugbi la ŋkɔe nye Zimri si nye Salu, ame si nye Simeon ƒe to la ƒe kplɔla aɖe la ƒe viŋutsu. ");
INSERT INTO ewe_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Ɖetugbi la ŋkɔe nye Kozbi si nye Zur, Midiantɔwo ƒe fiavi aɖe ƒe vinyɔnu. ");
INSERT INTO ewe_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Miwɔ Midiantɔwo abe miaƒe futɔwo ene, eye miawu wo, ");
INSERT INTO ewe_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","elabena wole mia tsrɔ̃m kple woƒe nu vɔ̃wo. Wona miele Baal subɔm, eye wona miele mɔ tram hele dɔvɔ̃ lém abe ale si miekpɔe fifi laa to Kozbi ƒe ku me ene.” ");
INSERT INTO ewe_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Esi dɔvɔ̃ la nu tso la, Yehowa gblɔ na Mose kple Eleazar, si nye nunɔla Aron ƒe viŋutsu be, ");
INSERT INTO ewe_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Mixlẽ Israelvi siwo katã xɔ ƒe blaeve alo wu nenema ne miakpɔ ame siwo ate ŋu ayi aʋa tso to ɖe sia ɖe kple hlɔ̃ ɖe sia ɖe me.” ");
INSERT INTO ewe_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Ale le Moab tagba, le Yɔdan gbɔ tso Yeriko, Mose kple Eleazar, nunɔla la, ƒo nu kple wo, eye wogblɔ be, ");
INSERT INTO ewe_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Mixlẽ ŋutsu siwo xɔ ƒe blaeve alo wu nenema, abe ale si Yehowa ɖo na Mose ene.” Woawoe nye Israelvi siwo ʋu tso Egiptenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ruben nye Israel ƒe ŋgɔgbevi. Ruben ƒe viwoe nye Hanok, ame si dzi Hanok hlɔ̃ la. Palu, ame si dzi Palu hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron, ame si dzi Hezron hlɔ̃ la, Karmi, ame si dzi Karmi hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Esiawoe nye Ruben ƒe hlɔ̃metɔwo; ame siwo wotia xlẽ le wo me la le ame akpe blaene-vɔ-etɔ̃, alafa adre blaetɔ̃ (43,730). ");
INSERT INTO ewe_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Palu ƒe vie nye Eliab, ");
INSERT INTO ewe_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","eye Eliab ƒe viwoe nye Nemuel, Datan kple Abiram. Ame eve siawo, Datan kple Abiram woe nye ame siwo wɔ ɖeka kple Korah ɖe Mose kple Aron ŋu, to esia me wotsi tsitre ɖe Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Eya ta anyigba ke nu mi wo, eye dzo tso Yehowa gbɔ wu ame alafa eve blaatɔ̃ (250) wòzu ŋkuɖodzinu. ");
INSERT INTO ewe_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ke hã la, Korah ƒe viwo katã metsrɔ̃ o. ");
INSERT INTO ewe_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Simeon ƒe viŋutsuwo kple hlɔ̃ siwo dzɔ tso wo me la woe nye: Nemuel, ame si dzi Nemuel hlɔ̃ la, Yamin, ame si dzi Yamin hlɔ̃ la, Yakin, ame si dzi Yakin hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zera, ame si dzi Zera hlɔ̃ la, Saul, ame si dzi Saul hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simeon ƒe hlɔ̃metɔwo ƒe xexlẽme le ame akpe blaeve-vɔ-eve, alafa eve (22,200). ");
INSERT INTO ewe_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Gad ƒe viŋutsuwo kple hlɔ̃ siwo dzɔ tso wo me la woe nye: Zefon, ame si dzi Zefon hlɔ̃ la, Hagi, ame si dzi Hagi hlɔ̃ la, Suni, ame si dzi Suni hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni, ame si dzi Ozni hlɔ̃ la, Eri, ame si dzi Eri hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Arɔd, ame si dzi Arɔd hlɔ̃ la, Areli, ame si dzi Areli hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Esiawoe nye Gad ƒe viŋutsuwo, ame siwo wotia xlẽ la ƒe xexlẽme le ame akpe blaene, alafa atɔ̃ (40,500). ");
INSERT INTO ewe_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Yuda ƒe viwoe nye Er kple Onan, ame siwo ku le Kanaanyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Yuda ƒe viŋutsuwo kple hlɔ̃ siwo dzɔ tso wo me la woe nye: Sela, ame si dzi Sela hlɔ̃ la, Perez, ame si dzi Perez hlɔ̃ la, Zera, ame si dzi Zera hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Perez ƒe viŋutsuwoe nye: Hezron, ame si dzi Hezron hlɔ̃ la; Hamul, ame si dzi Hamul hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Ame siwo wotia xlẽ le Yuda ƒe ƒome me la le ame akpe blaadre-vɔ-ade, alafa atɔ̃ (76,500). ");
INSERT INTO ewe_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Isaka ƒe viŋutsuwo kple hlɔ̃ siwo dzɔ tso wo me woe nye: Tola, ame si dzi Tola hlɔ̃ la, Puva, ame si dzi Puva hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yasub, ame si dzi Yasub hlɔ̃ la; Simrɔn, ame si dzi Simrɔn hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Ame siwo wotia xlẽ le Isaka ƒe hlɔ̃ me la le ame akpe blaade-vɔ-ene alafa etɔ̃ (64,300). ");
INSERT INTO ewe_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Zebulon ƒe viŋutsuwo le woƒe towo nue nye: Sered, ame si dzi Sered hlɔ̃ la, Elon, ame si dzi Elon hlɔ̃ la, Yahlil, ame si dzi Yahlil hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Ame siwo wotia xlẽ le Zebulon ƒe ƒome me la le ame akpe blaade, alafa atɔ̃ (60,500). ");
INSERT INTO ewe_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yosef ƒe viwoe nye Manase kple Efraim: ");
INSERT INTO ewe_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Manase ƒe viŋutsuwoe nye: Makir, ame si dzi Makir hlɔ̃ la (Makir dzi Gilead), eye Gilead hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Gilead ƒe viŋutsuwo kple woƒe hlɔ̃woe nye esiawo. Yezer, ame si dzi Yezer hlɔ̃ la, Helek, ame si dzi Helek hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asriel, ame si dzi Asriel hlɔ̃ la, Sekem, ame si dzi Sekem hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Semida, ame si dzi Semida hlɔ̃ la, Hefer, ame si dzi Hefer hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","(Zelofehad, medzi ŋutsuvi aɖeke o. Via nyɔnuviwo ƒe ŋkɔwoe nye Mahla, Noa, Hogla, Milka kple Tirza.) ");
INSERT INTO ewe_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Esiawoe nye Manase ƒe hlɔ̃metɔwo, ame siwo ƒe xexlẽme le ame akpe blaatɔ̃ vɔ eve alafa adre (52,700). ");
INSERT INTO ewe_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Efraim ƒe viŋutsuwo kple hlɔ̃ siwo dzɔ tso wo me la woe nye: Sutela, ame si dzi Sutela hlɔ̃ la, Beker, ame si dzi Beker hlɔ̃ la, Tahan, ame si dzi Tahan hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutela vi nye Eran, ame si dzi Eran hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Ame siawoe nye Efraim ƒe viŋutsuwo. Ame siwo wotia xlẽ la le ame akpe blaetɔ̃-vɔ-eve, alafa atɔ̃ (32,500). Esiawoe nye Yosef ƒe viwo le woƒe hlɔ̃wo nu. ");
INSERT INTO ewe_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Benyamin ƒe viŋutsuwo kple hlɔ̃ siwo dzɔ tso wo me la woe nye: Bela, ame si dzi Bela hlɔ̃ la, Asbel, ame si dzi Asbel hlɔ̃ la, Ahiram, ame si dzi Ahiram hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Sefufam, ame si dzi Sefufam hlɔ̃ la, Hufam, ame si dzi Hufam hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Bela viwoe nye Ard kple Naaman: Ard, ame si dzi Ard hlɔ̃ la, Naaman, ame si dzi Naaman hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Esiawoe nye Benyamin ƒe hlɔ̃metɔwo, ame siwo ƒe xexlẽme nye ame akpe blaene-vɔ-atɔ̃ alafa ade (45,600). ");
INSERT INTO ewe_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Dan viwoe nye esi le woƒe ƒome nu: Suham, ame si dzi Suham hlɔ̃ la. Esiae nye Dan ƒe hlɔ̃wo: ");
INSERT INTO ewe_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Wo katã nye Suham hlɔ̃ si ƒe xexlẽme nye ame akpe blaade-vɔ-ene, alafa ene (64,400). ");
INSERT INTO ewe_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Aser ƒe viŋutsuwo kple woƒe hlɔ̃woe nye: Imna, ame si dzi Imna hlɔ̃ la, Isvi, ame si dzi Isvi hlɔ̃ la, Beria, ame si dzi Beria hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Woma Beria hlɔ̃ la ɖe akpa eve me: Heber hlɔ̃ si dzɔ tso Beria ƒe viŋutsu Heber me, Malxiel hlɔ̃ si dzɔ tso Beria ƒe vi Malxiel me. ");
INSERT INTO ewe_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aser ƒe vinyɔnu ŋkɔe nye Sera. ");
INSERT INTO ewe_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Ame siwo wotia xlẽ le Aser ƒe viwo ƒe hlɔ̃ me la le ame akpe blaatɔ̃-vɔ-etɔ̃, alafa ene (53,400). ");
INSERT INTO ewe_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Naftali ƒe viŋutsuwo kple woƒe hlɔ̃woe nye: Yahzil, ame si dzi Yahzil hlɔ̃ la, Guni, ame si dzi Guni hlɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yezer, ame si dzi Yezer hlɔ̃ la, Silem, ame si dzi Silem hlɔ̃ la. ");
INSERT INTO ewe_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Ame siwo wotia xlẽ le Naftali ƒe hlɔ̃ me la nye ame akpe blaene-vɔ-atɔ̃, alafa ene (45,400). ");
INSERT INTO ewe_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Ale Israel ŋutsu siwo katã ate ŋu ade aʋa la de ame akpe alafa ade kple ɖeka, alafa adre blaetɔ̃ (601,730). ");
INSERT INTO ewe_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Azɔ Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Wòama anyigba la ɖe to vovovoawo dome le toawo me tɔwo ƒe agbɔsɔsɔ nu, abe ale si amexexlẽ la fia ene. ");
INSERT INTO ewe_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","To siwo me amewo sɔ gbɔ le la, woaxɔ anyigba wòalolo, eye to siwo me amewo mesɔ gbɔ le o la ƒe anyigba nanɔ sue. ");
INSERT INTO ewe_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Yehowa ɖo na Mose be, Kpɔ egbɔ be yewodzidze nu hafi ma anyigba la, eye woaxɔ domenyinu ɖe wo fofowo ƒe towo ƒe ŋkɔ nu. ");
INSERT INTO ewe_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Woama domenyinu ɖe sia ɖe to akɔdada me ɖe to gãwo kple to suewo siaa dome.” ");
INSERT INTO ewe_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Levi ƒe viwo ƒe hlɔ̃ siwo me woxlẽ ame le le amexexlẽa me la kple ame siwo me wodzɔ tso la woe nye: Gerson dzi Gerson hlɔ̃; Kohat dzi Kohat hlɔ̃; Merari dzi Merari hlɔ̃. ");
INSERT INTO ewe_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Levi ƒomea me tɔwoe nye, Libni ƒomea, Hebroni ƒomea, Mahli ƒomea, Musi ƒomea kple Korah ƒomea. (Kohat nye Amram tɔgbui. ");
INSERT INTO ewe_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amram srɔ̃ ŋkɔe nye Yohebed, Levi ƒe dzidzimevi, ame si wòdzi na Levi ƒe viwo le Egipte. ");
INSERT INTO ewe_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aron ƒe viŋutsuwoe nye Nadab, Abihu, Eleazar kple Itamar. ");
INSERT INTO ewe_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nadab kple Abihu woku esi wodo dzudzɔ makɔmakɔ na Yehowa.) ");
INSERT INTO ewe_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Levi ƒe vi siwo katã woxlẽ wonye ŋutsuwo, eye woxɔ ɣleti ɖeka alo wu nenema la de ame akpe blaeve-vɔ-etɔ̃ (23,000). Ke womebu Levi ƒe viwo de Israelviwo ƒe amexexlẽ ƒe nukpɔkpɔ blibo la me o, elabena womena anyigba Levi ƒe viwo esi woma anyigba ɖe toawo dome o. ");
INSERT INTO ewe_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Ale esiae nye Israelvi siwo Mose kple nunɔla Eleazar tia xlẽ le Moab gbegbe le Yɔdan tɔsisi la to le Yeriko kasa. ");
INSERT INTO ewe_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Wo dometɔ ɖeka gɔ̃ hã menɔ ame siwo Mose kple nunɔla Eleazar xlẽ esime woxlẽ Israelviwo le Sinai gbegbe la dome o. ");
INSERT INTO ewe_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Elabena Yehowa gblɔ na Israelvi mawo be, woaku godoo le gbegbe la; wo dometɔ aɖeke mesusɔ o, negbe Kaleb, Yefune ƒe viŋutsu kple Yosua, Nun ƒe viŋutsu. ");
INSERT INTO ewe_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Zelofehad, Hefer ƒe vi, Gilead ƒe vi, Makir ƒe vi, Manase ƒe vi, tso Manase, ame si nye Yosef ƒe vi la ƒe ƒome me. Zelofehad ƒe vinyɔnuwo ƒe ŋkɔwoe nye Mahla, Noa, Hogla, Milka kple Tirza. ");
INSERT INTO ewe_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Gbe ɖeka la, Zelofehad ƒe vinyɔnu siawo yi agbadɔ la ƒe mɔnu, eye wotsi tsitre ɖe Mose, nunɔla Eleazar, ameha blibo la ƒe kplɔlawo ŋkume, eye wogblɔ be, ");
INSERT INTO ewe_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Mía fofo ku le gbedzi. Enɔ Korah yomedzelawo dome, ame siwo bla nu, eye wotsi tsitre ɖe Yehowa ŋu, ke eku ɖe eya ŋutɔ ƒe nu vɔ̃ ta, eye megblẽ viŋutsu aɖeke ɖe megbe o. ");
INSERT INTO ewe_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Nu ka ta mía fofo ƒe ŋkɔ nabu le eƒe hlɔ̃ me, elabena viŋutsu menɔ esi o? Na domenyinui ɖe mía fofowo ƒe ƒometɔwo dome.” ");
INSERT INTO ewe_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mose tsɔ woƒe nya la da ɖe Yehowa ŋkume, ");
INSERT INTO ewe_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","eye Yehowa gblɔ nɛ be, ");
INSERT INTO ewe_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Nya si gblɔm Zelofehad ƒe vinyɔnuwo le la le eteƒe. Ele be miana domenyinu wo ɖe wo fofowo ƒe ƒometɔwo dome, eye miatsɔ wo fofowo ƒe domenyinu ana wo. ");
INSERT INTO ewe_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Gawu la, gblɔ na Israelviwo be, ‘Ne ame aɖe ku, eye viŋutsu aɖeke menɔ esi o la, ekema eƒe domenyinu ayi via nyɔnuwo ƒe asi me. ");
INSERT INTO ewe_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ne vinyɔnu aɖeke menɔ esi o hã la, ekema eƒe domenyinu ayi nɔvia ŋutsu ƒe asi me. ");
INSERT INTO ewe_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ne nɔviŋutsu aɖeke hã menɔ esi o la, ekema eƒe domenyinu ayi fofoa nɔviŋutsu gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Ke ne fofoa nɔviŋutsu aɖeke meli o la, woatsɔe ana eƒe ƒometɔ tututu aɖe. Esia nanye se kple ɖoɖo na Israelviwo, abe ale si Yehowa de se na Mose ene.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Gbe ɖeka la, Yehowa gblɔ na Mose be, “Yi Abarim to dzi, eye nàkpɔ anyigba si metsɔ na Israelviwo la ɖa to tɔsisi la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ne èkpɔe vɔ megbe la, àku abe nɔviwò Aron ene, ");
INSERT INTO ewe_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","elabena ètsi tsitre ɖe nye ɖoɖo ŋu le Zin gbedzi. Esime Israel dze aglã ɖe ŋunye la, mède bubu ŋunye le wo ŋkume to nye ɖoɖowo dzi wɔwɔ me, aɖe gbe, tsi nado to agakpe la me o.” (Yehowa nɔ nu ƒom tso nya si dzɔ le Meriba, Dzreteƒe, le Kades, le Zin gbedzi la ŋu.) ");
INSERT INTO ewe_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mose gblɔ na Yehowa be, ");
INSERT INTO ewe_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“O! Yehowa, amegbetɔƒome la katã ƒe gbɔgbɔwo ƒe Mawu, meɖe kuku, hafi madzo le xexea me la, tia kplɔla bubu na ameawo, ");
INSERT INTO ewe_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ame si akplɔ wo ayi aʋa, eye wòakpɔ wo dzi, ale be Yehowa ƒe amewo manɔ abe alẽha si nu kplɔla aɖeke mele ene o.” ");
INSERT INTO ewe_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Yehowa ɖo eŋu be, “Yi nàkplɔ Yosua, Nun ƒe viŋutsu, ame si me Gbɔgbɔ la le la, ");
INSERT INTO ewe_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","yi nunɔla Eleazar gbɔ, eye nàtsɔ ameawo kpɔkplɔ de esi le ameawo katã ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ɖe wò amekpɔkplɔ ƒe ŋusẽ da ɖe edzi ale be Israelviwo katã naɖo toe. ");
INSERT INTO ewe_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ele be wòayi nunɔla Eleazar gbɔ, eye wòaxɔ ɖoɖowo tso Yehowa gbɔ. Yehowa agblɔ nu si woawɔ la na Eleazar to akɔdada kple ‘Urim’ me, eye Eleazar agblɔ Mawu ƒe ɖoɖowo na Yosua kple Israel dukɔ la. Yehowa ayi wo kpɔkplɔ dzi le mɔ sia nu.” ");
INSERT INTO ewe_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mose zɔ ɖe Yehowa ƒe ɖoɖowo nu, eye wòkplɔ Yosua yi nunɔla Eleazar gbɔ. Le ha blibo la ŋkume la, ");
INSERT INTO ewe_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Mose da asi ɖe Yosua dzi, eye wòtsɔ eƒe dɔdeasiwo de asi nɛ abe ale si Yehowa ɖo nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“De se sia na Israelviwo, eye nàgblɔ na wo be, ‘Mikpɔ egbɔ be, le ɣeyiɣi ɖoɖo la dzi la, mietsɔ nye nuɖuɖu si nye dzovɔsa, si nye nu si ʋẽna lĩlĩlĩ, eye wòdzea ŋunye la nam.’ ");
INSERT INTO ewe_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Ne miedi be yewoasa dzovɔ nam la, miwɔ alẽvi siwo xɔ ƒe ɖeka, eye wode blibo le go ɖe sia ɖe me la ŋu dɔ. Woatsɔ alẽvi eve asa vɔe nam gbe sia gbe. ");
INSERT INTO ewe_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Woatsɔ alẽvi ɖeka asa vɔe le ŋdi me, eye woatsɔ evelia asae le fiẽ me. ");
INSERT INTO ewe_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Woatsɔ nuɖuvɔsanu, si nye wɔ memee kilogram ɖeka si wobaka kple ami lita ɖeka. ");
INSERT INTO ewe_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Esia nye dzovɔsa si meɖo na mi le Sinai to la dzi be miatsɔ wo nam le ɣeyiɣi ɖoɖoawo dzi, wòanye dzovɔ si wosa na Yehowa, eye wòʋẽna lĩlĩlĩ. ");
INSERT INTO ewe_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Woatsɔ nunovɔsanu, si nye wain sesẽ lita ɖeka la akpe ɖe alẽvi ɖe sia ɖe ŋu. Woatrɔ wain la le kɔkɔeƒe le Yehowa ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Mitsɔ alẽvi evelia sa vɔe le fiẽ me, eye miatsɔ nuɖuvɔsa kple nunovɔsa ma ke akpe ɖe eŋu. Esia hã nye dzovɔsa si ʋẽna lĩlĩlĩ la na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“Le Dzudzɔgbe la dzi la, tsɔ alẽvi eve siwo xɔ ƒe ɖeka, eye wode blibo le go ɖe sia ɖe me la sa vɔe kpe ɖe eƒe nunovɔsa kple nuɖuvɔsa ŋu. Nuɖuvɔsa la nanye wɔ memee lita ene kple afã si wobaka kple ami. ");
INSERT INTO ewe_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Esia nye Dzudzɔgbe ɖe sia ɖe ƒe numevɔsa hekpe ɖe gbe sia gbe ƒe numevɔsa kple nunovɔsa ŋu.” ");
INSERT INTO ewe_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“Hekpe ɖe esiawo ŋuti la, le ɣleti ɖe sia ɖe ƒe ŋkeke gbãtɔ dzi la, woagasa numevɔ bubu na Yehowa kpe ɖe esi wosana gbe sia gbe la ŋu. Woasa vɔ sia kple nyitsuvi eve, agbo ɖeka kple agbovi adre, siwo xɔ ƒe ɖeka. Lã siawo dometɔ ɖe sia ɖe nanye lã si de blibo le go ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Nu siwo woatsɔ akpe ɖe vɔsalã siawo ŋu lae nye: wɔ memee lita ade kple afã, si wobaka kple ami lita ene kple afã abe nuɖuvɔsa ene kpe ɖe nyitsu ɖe sia ɖe ŋu; wɔ memee kilogram eve si wobaka kple ami kilogram eve abe nuɖuvɔsa ene nazɔ kple agbo la, ");
INSERT INTO ewe_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","eye woatsɔ wɔ memee si wobaka kple ami lita eve abe nuɖuvɔsa ene la akpe ɖe alẽvi ɖe sia ɖe ŋu. Woame vɔsa sia; ado dzidzɔ na Yehowa ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Woatsɔ nunovɔsa si nye wain lita eve la akpe ɖe nyitsu la ŋu, atsɔ lita ɖeka kple afã akpe ɖe agbo la ŋu, eye woatsɔ lita ɖeka akpe ɖe agbovi ɖe sia ɖe ŋu. Esiae nye nunovɔsa si woawɔ ɣleti sia ɣleti to ƒe blibo la me. ");
INSERT INTO ewe_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","“Emegbe la, le ɣleti ɖe sia ɖe ƒe ŋkeke gbãtɔa gbe la, miana gbɔ̃tsu ɖeka hena nu vɔ̃ ŋuti vɔsa na Yehowa. Esia akpe ɖe gbe sia gbe ƒe numevɔsa kple nunovɔsa si miesana la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“Woaɖu Yehowa ƒe Ŋutitotoŋkekenyui la le ɣleti gbãtɔ ƒe ŋkeke wuienelia gbe le ƒe ɖe sia ɖe me. Miaɖu Ŋutitotoŋkekenyui la atsɔ ɖo ŋku gbe si gbe mawudɔla la dze to Israelviwo ƒe viŋutsu gbãtɔwo ŋu, eye mewu wo o la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ne ŋu ke la, ŋkeke adre ƒe dzidzɔŋkekenyui aɖe adze egɔme, ke womaɖu abolo ʋaʋã aɖeke o. ");
INSERT INTO ewe_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Le ŋkekenyui sia ƒe ŋkeke gbãtɔ gbe la, àƒo ameawo nu ƒu hena mawusubɔsubɔ, eye miawɔ dɔ aɖeke o. ");
INSERT INTO ewe_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Miatsɔ nyitsuvi eve, agbo ɖeka kple agbovi adre, siwo xɔ ƒe ɖeka ko la asa numevɔ na Yehowa. Lã siawo dometɔ ɖe sia ɖe nanye esi de blibo. ");
INSERT INTO ewe_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Misa numevɔ kple wɔ memee lita ade kple afã si wobaka kple ami la kpe ɖe nyitsu ɖe sia ɖe ŋu, miatsɔ wɔ memee lita ene kple afã si wobaka kple ami la asa vɔe kpe ɖe alẽvi la ŋu, ");
INSERT INTO ewe_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","eye miatsɔ wɔ ma lita eve akpe ɖe alẽviawo dometɔ ɖe sia ɖe ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Ele be miatsɔ gbɔ̃tsu ɖeka hã asa nu vɔ̃ ŋuti vɔe, ale be mialé avu ɖe mia ɖokuiwo ta. ");
INSERT INTO ewe_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Vɔsa siawo akpe ɖe gbe sia gbe ƒe vɔ siwo miesana la ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Miasa vɔ sia ke le Ŋkekenyui la ƒe ŋkeke adreawo ɖe sia ɖe gbe. Woadze Yehowa ŋu ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Le ŋkeke adrea gbe la, ameawo katã agawɔ takpekpe kɔkɔe aɖe. Womawɔ dɔ sesẽ aɖeke gbe ma gbe o. ");
INSERT INTO ewe_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“Le kutsetse gbãtɔwo ƒe Ŋkekenyui si woyɔna be Kɔsiɖawo ƒe Ŋkekenyui alo Pentekoste ƒe ŋkeke gbãtɔa gbe la, ameawo katã awɔ takpekpe kɔkɔe, atso aseye le nuŋeŋe yeye la ta. Gbe ma gbe la, ele be miatsɔ nuku yeye siwo mieŋe la ƒe gbãtɔ na Yehowa abe nuɖuvɔsa ene. Ame aɖeke mekpɔ mɔ awɔ dɔ aɖeke le ŋkeke ma dzi o. ");
INSERT INTO ewe_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Woasa numevɔ tɔxɛ si adze Yehowa ŋu ŋutɔ la gbe ma gbe kple nyitsuvi eve, agbo ɖeka kple agbovi adre, siwo xɔ ƒe ɖeka ko. ");
INSERT INTO ewe_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Miatsɔ nuɖuvɔsa si wowɔ kple wɔ memee si wobaka kple ami lita ade kple afã akpe ɖe nyitsu ɖe sia ɖe ŋu, miatsɔ wɔ ma lita ene kple afã, si wobaka kple ami la akpe ɖe agbo la ŋu, eye ");
INSERT INTO ewe_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","wɔ memee lita eve nakpe ɖe alẽvi adreawo dometɔ ɖe sia ɖe ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Hekpe ɖe esiawo ŋu la, miatsɔ gbɔ̃tsu ɖeka asa avulévɔ ɖe mia ɖokuiwo ta. ");
INSERT INTO ewe_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Vɔsa tɔxɛ siawo akpe ɖe numevɔ, nuɖuvɔ kple nunovɔ siwo miesana gbe sia gbe la ŋu. Mikpɔ egbɔ be miaƒe vɔsalãwo dometɔ ɖe sia ɖe de blibo.” ");
INSERT INTO ewe_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“Woaɖu Kpẽwo ƒe Ŋkekenyui le ƒe sia ƒe ƒe ɣleti adrelia ƒe ŋkeke gbãtɔa gbe. Ameawo katã awɔ takpekpe kɔkɔe aɖe gbe ma gbe, eye womawɔ dɔ aɖeke o. ");
INSERT INTO ewe_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Gbe ma gbe la, miatsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi adre, siwo xɔ ƒe ɖeka ko la awɔ numevɔsa na Yehowa. Vɔsalã siawo dometɔ ɖe sia ɖe nade blibo. Vɔsa siawo nye nu siwo dzea Yehowa ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Tsɔ nuɖuvɔsa si wowɔ kple wɔ memee lita ade kple afã si wobaka kple ami la akpe ɖe nyitsu la ŋu, nàtsɔ wɔ lita ene kple afã akpe ɖe agbo la ŋu, ");
INSERT INTO ewe_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","eye nàtsɔ wɔ memee lita eve akpe ɖe alẽvi adreawo dometɔ ɖe sia ɖe ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Hekpe ɖe esiawo ŋu la, miatsɔ gbɔ̃tsu ɖeka asa nu vɔ̃ vɔsa hena avuléle ɖe miawo ŋutɔ ta. ");
INSERT INTO ewe_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Vɔsa tɔxɛ siawo akpe ɖe ɣleti sia ɣleti ƒe numevɔ siwo miesana ɖaa la ŋuti gbe ma gbe abe ɣleti yeye ƒe numevɔsa ene. Miawɔ esia akpe ɖe gbe sia gbe ƒe numevɔsa, siwo miewɔna kple nuɖuvɔsa kple nunovɔsa ŋu abe ale si seawo xlẽe fia la ene.” ");
INSERT INTO ewe_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“Le ŋkeke ewo megbe la, ameawo katã agakpe ta. Ame sia ame abɔbɔ eɖokui le Yehowa ŋkume, eye womawɔ dɔ aɖeke ƒomevi o. ");
INSERT INTO ewe_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Gbe ma gbe la, miasa numevɔ si adze Yehowa ŋu ŋutɔ la kple nyitsuvi ɖeka, agbo ɖeka kple agbovi adre, siwo xɔ ƒe ɖeka. Lã siawo nade blibo le go ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Sa nuɖuvɔ kple wɔ memee lita ade kple afã si wobaka kple ami la kpe ɖe nyitsu la ŋu kple wɔ memee lita ene kple afã kpe ɖe agbo la ŋu, ");
INSERT INTO ewe_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","eye wɔ memee lita eve akpe ɖe alẽvi adreawo dometɔ ɖe sia ɖe ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Ele be miatsɔ gbɔ̃tsu ɖeka asa nu vɔ̃ vɔsa hã. Esia akpe ɖe avuléŋkeke la ƒe nu vɔ̃ vɔsa si miesana ƒe sia ƒe le ŋkeke ma dzi la ŋuti, hekpe ɖe miaƒe gbe sia gbe ƒe numevɔsa, nuɖuvɔsa kple nunovɔsa ŋuti.” ");
INSERT INTO ewe_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“Le ŋkeke atɔ̃ megbe la, ameawo katã agawɔ takpekpe, eye ame aɖeke mawɔ dɔ sesẽ aɖeke o. Esia nye ŋkeke adre ƒe ŋkekenyui si woaɖu le Yehowa ŋkume la ƒe gɔmedzedze. ");
INSERT INTO ewe_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Miaƒe gbe ma gbe ƒe numevɔsa tɔxɛ la ado dzidzɔ gã ŋutɔ na Yehowa. Miasa vɔ sia kple nyitsuvi wuietɔ̃, agbo eve kple agbovi wuiene siwo xɔ ƒe ɖeka. Lã siawo dometɔ ɖe sia ɖe nade blibo le go ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Miatsɔ nu siawo akpe ɖe miaƒe gbe sia gbe ƒe numevɔsa kple nuɖuvɔsa la ŋu ale: wɔ memee lita ade kple afã, si wobaka kple ami la nakpe ɖe nyitsuvi wuietɔ̃awo dometɔ ɖe sia ɖe ŋu; wɔ memee lita ene kple afã nakpe ɖe agbo eveawo dometɔ ɖe sia ɖe ŋu, ");
INSERT INTO ewe_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","eye wɔ memee lita eve nakpe ɖe alẽvi wuieneawo dometɔ ɖe sia ɖe ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Ele be miatsɔ gbɔ̃tsu ɖeka asa nu vɔ̃ vɔsa hã kpe ɖe miaƒe gbe sia gbe ƒe numevɔsa, nuɖuvɔsa kple nunovɔsa ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“Le ŋkeke adre Ŋkekenyui sia ƒe ŋkeke evelia gbe la, miatsɔ nyitsu wuieve, agbo eve kple agbovi wuiene, siwo xɔ ƒe ɖeka la asa numevɔ ");
INSERT INTO ewe_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","kpe ɖe miaƒe gbe sia gbe ƒe nuɖuvɔsa kple nunovɔsa ŋu. Vɔsalã siawo nade blibo le go ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Kpe ɖe miaƒe gbe sia gbe ƒe numevɔsa ŋu la, ele be miagatsɔ gbɔ̃tsu ɖeka asa nu vɔ̃ vɔsa akpe ɖe nuɖuvɔsa kple nunovɔsa ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“Le Ŋkekenyui sia ƒe ŋkeke etɔ̃lia gbe la, miatsɔ nyitsuvi wuiɖekɛ, agbo eve kple agbovi wuiene, siwo xɔ ƒe ɖeka la asa numevɔ. Vɔsalã siawo dometɔ ɖe sia ɖe nade blibo. ");
INSERT INTO ewe_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Miatsɔ miaƒe gbe sia gbe ƒe nuɖuvɔsa kple nunovɔsa akpe ɖe nyitsuawo, agboawo kple alẽviawo ƒe agbɔsɔsɔ me ŋu ɖe ɖoɖo la nu. ");
INSERT INTO ewe_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Kpe ɖe miaƒe gbe sia gbe ƒe numevɔsa ŋuti la, miatsɔ gbɔ̃tsu ɖeka asa nu vɔ̃ vɔsa, eye miatsɔ nuɖuvɔsa kple nunovɔsa akpe ɖe eŋu. ");
INSERT INTO ewe_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“Le Ŋkekenyui sia ƒe ŋkeke enelia dzi la, miatsɔ nyitsuvi ewo, agbo eve kple agbovi wuiene, siwo xɔ ƒe ɖeka la asa vɔe. Vɔsalã siawo nade blibo le go ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Woatsɔ nuɖuvɔsa kple nunovɔsa ɖe nyitsuawo, agboawo kple alẽviawo ƒe agbɔsɔsɔ me ŋu ɖe ɖoɖo la nu. ");
INSERT INTO ewe_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Ele be miatsɔ gbɔ̃tsu ɖeka asa nu vɔ̃ vɔsa hã kpe ɖe miaƒe gbe sia gbe ƒe numevɔsa, nuɖuvɔsa kple nunovɔsa ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“Le ŋkeke atɔ̃lia gbe la, mitsɔ nyitsu asiekɛ, agbo eve kple agbovi wuiene, ɖe sia ɖe si xɔ ƒe ɖeka, eye naneke megblẽ le eŋu o la asa vɔe. ");
INSERT INTO ewe_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Sa nyitsuawo, agboawo kple agbovi fɛ̃ ƒe nuɖuvɔsawo kple nunovɔsawo ɖe xexlẽme siwo woɖo ɖi la nu. ");
INSERT INTO ewe_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Kpe ɖe esiawo ŋuti la, mitsɔ gbɔ̃tsu ɖeka sa vɔe kpe ɖe miaƒe nuɖuvɔsa kple nunovɔsa siwo miesana ɖaa la ŋuti abe nu vɔ̃ ŋuti vɔsa ene kpe ɖe miaƒe gbe sia gbe ƒe vɔsawo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“Le Ŋkekenyui sia ƒe ŋkeke adelia gbe la, miasa vɔ kple nyitsu enyi, agbo eve kple alẽvi wuiene siwo xɔ ƒe ɖeka. Vɔsalã siawo nade blibo le go ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Mitsɔ nuɖuvɔsa kple nunovɔsa kpe ɖe nyitsuawo, agboawo kple alẽviawo ƒe agbɔsɔsɔ me ŋu ɖe ɖoɖo la nu. ");
INSERT INTO ewe_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Kpe ɖe esiawo ŋu la, mitsɔ gbɔ̃tsu ɖeka sa vɔe kpe ɖe miaƒe gbe sia gbe ƒe vɔsawo kple nuɖuvɔsawo kple nunovɔsawo ŋu abe nu vɔ̃ ŋuti vɔsa ene. ");
INSERT INTO ewe_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“Le ŋkekenyui sia ƒe ŋkeke adrelia gbe la, misa vɔ kple nyitsu adre, agbo eve kple agbovi wuiene, siwo xɔ ƒe ɖeka. Vɔsalã siawo nade blibo. ");
INSERT INTO ewe_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Mitsɔ vɔsa siawo kpe ɖe miaƒe nuɖuvɔsa kple nunovɔsa ɖe nyitsuawo, agboawo kple alẽviawo ƒe agbɔsɔsɔ me ŋu ɖe ɖoɖo la nu. ");
INSERT INTO ewe_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Migasa nu vɔ̃ ŋuti vɔ kple gbɔ̃tsu ɖeka kpe ɖe miaƒe nuɖuvɔsa kple nunovɔsa kple miaƒe gbe sia gbe ƒe vɔsawo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“Le ŋkeke enyia gbe la, ameawo agawɔ takpekpe kɔkɔe. Miawɔ dɔ aɖeke gbe ma gbe o. ");
INSERT INTO ewe_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mitsɔ nyitsuvi ɖeka, agbo ɖeka kple agbovi adre siwo xɔ ƒe ɖeka la sa numevɔ na Yehowa. Vɔsalãwo dometɔ ɖe sia ɖe nade blibo. ");
INSERT INTO ewe_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Miawɔ nuɖuvɔsa kple nunovɔsa ɖe nyitsu la, agbo la kple alẽviawo ƒe agbɔsɔsɔme ŋu ɖe ɖoɖo la nu. Vɔsa siawo dzea Yehowa ŋu ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Mitsɔ gbɔ̃tsu ɖeka sa vɔe kpe ɖe nuɖuvɔsa kple nunovɔsa ŋu abe nu vɔ̃ ŋuti vɔsa ene kpe ɖe miaƒe gbe sia gbe vɔsawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“Ele na mi be miasa vɔ siawo le miaƒe ƒe sia ƒe Ŋkekenyuiɖuɣiwo dzi kpe ɖe miaƒe adzɔgbeɖevɔsawo, lɔlɔ̃nuvɔsawo, numevɔsawo, nuɖuvɔsawo, nunovɔsawo kple ŋutifafavɔsawo ŋu.” ");
INSERT INTO ewe_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Ale Mose de se siawo katã na Israelviwo. ");
INSERT INTO ewe_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Mose gblɔ na Israelviwo ƒe towo ƒe tatɔwo be, “Se si Yehowa de lae nye esi. ");
INSERT INTO ewe_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Ne ame aɖe ɖe adzɔgbe na Yehowa alo ka atam hetsri nane na eɖokui la, mele be wòada le eƒe nya dzi o, ke boŋ ele be wòawɔ ɖe nya sia nya si wògblɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Ne nyɔnu aɖe, si nye ɖetugbi le fofoa ƒe aƒe me ɖe adzɔgbe na Yehowa be yeawɔ nane alo yemawɔ nane o, ");
INSERT INTO ewe_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","eye fofoa nya nu tso ɖetugbi la ƒe adzɔgbeɖeɖe la kple tohehe siwo ku ɖe adzɔgbeɖeɖe la ŋuti ŋu, gake megblɔ nya aɖeke o la, ekema ele be ɖetugbi la nawɔ ɖe adzɔgbeɖeɖe la dzi kokoko. ");
INSERT INTO ewe_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Ke ne fofoa melɔ̃ ɖe adzɔgbeɖeɖe la dzi o, alo wòbu be tohehe si dzi wòlɔ̃ ɖo sesẽ akpa la, ekema ɖetugbi la ƒe adzɔgbeɖeɖe la megablae o. Ne fofoa melɔ̃ ɖe adzɔgbeɖeɖe la dzi o la, ekema ele nɛ be wòaɖe gbeƒã nenema le gbe si gbe wònya nu le adzɔgbeɖeɖe la ŋu; ekema Yehowa atsɔe ake ɖetugbi la, elabena fofoa melɔ̃ ɖe adzɔgbeɖeɖe la dzi o. ");
INSERT INTO ewe_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Ne nyɔnu aɖe ɖe adzɔgbe alo do ŋugbe dzodzro aɖe hafi va ɖe srɔ̃ la, ");
INSERT INTO ewe_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ne srɔ̃ŋutsu la se nya la, eye megblɔ nya aɖeke tso eŋu le gbe si gbe wòse nu tso eŋuti dzi o la, ekema ele be nyɔnu la nawɔ ɖe eƒe adzɔgbeɖeɖe la dzi kokoko. ");
INSERT INTO ewe_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Ke ne srɔ̃ŋutsu la gbe be yemelɔ̃ ɖe adzɔgbeɖeɖe la dzi o la, ekema adzɔgbeɖeɖe la megabla nyɔnu la o, eye Yehowa atsɔe akee. ");
INSERT INTO ewe_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Ke ne nyɔnu la zu ahosi alo eya kple srɔ̃a dome klã la, ekema ele nɛ be wòawɔ ɖe eƒe adzɔgbeɖeɖe la dzi kokoko. ");
INSERT INTO ewe_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Ne srɔ̃nyɔnu aɖe le srɔ̃a ƒe aƒe me, eye wòɖe adzɔgbe, ");
INSERT INTO ewe_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ne srɔ̃ŋutsu la se nu tso srɔ̃a ƒe adzɔgbeɖeɖe la ŋu, eye megblɔ nya aɖeke o la, ekema ele be nyɔnu la nawɔ ɖe eƒe adzɔgbeɖeɖe la dzi kokoko. ");
INSERT INTO ewe_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Ke ne ŋutsu la gblɔ le ŋkeke gbãtɔ si wòse nu tso adzɔgbeɖeɖe la ŋu be yemelɔ̃ ɖe edzi o la, ekema adzɔgbeɖeɖe la megabla nyɔnu la o, eye Yehowa atsɔe akee. ");
INSERT INTO ewe_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Ale srɔ̃ŋutsu ate ŋu alɔ̃ adzɔgbeɖeɖe la nabla srɔ̃a loo alo agbe, eye adzɔgbeɖeɖe la mabla srɔ̃a o. ");
INSERT INTO ewe_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ke ne ŋutsu la megblɔ nya aɖeke o, eye ŋkeke ɖeka va yi la, ekema elɔ̃ ɖe adzɔgbeɖeɖe la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Ne srɔ̃ŋutsu la lala ŋkeke ɖeka va yi hafi wòva gbe be yemelɔ̃ ɖe ye srɔ̃ ƒe adzɔgbeɖeɖe la dzi o la, ekema tohehe ka ke dzi nyɔnu la lɔ̃ ɖo be wòava ye dzi ne yemewɔ ɖe yeƒe adzɔgbeɖeɖe la dzi o la ava ŋutsu la boŋ dzi, elabena eyae meɖe mɔ na nyɔnu la be wòawɔ ɖe eƒe adzɔgbeɖeɖe la dzi o.” ");
INSERT INTO ewe_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Esiawoe nye se siwo Yehowa de na Mose tso ale si srɔ̃ŋutsu kple srɔ̃nyɔnu dome nanɔ kple ale si fofo kple vinyɔnu dome nanɔ la ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Bia hlɔ̃ Midiantɔwo le ale si wokplɔ mi de trɔ̃subɔsubɔ me la ta. Le esia megbe la, àku.” ");
INSERT INTO ewe_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mose gblɔ na ameawo be, “Ele be mia dometɔ aɖewo naho aʋa ɖe Midiantɔwo ŋu, eye woabia hlɔ̃ Midiantɔwo na Yehowa. ");
INSERT INTO ewe_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Miɖo ŋutsu akpe ɖeka tso Israel ƒe to ɖe sia ɖe me ɖe aʋa la.” ");
INSERT INTO ewe_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Ale ŋutsu akpe wuieve (12,000) bla akpa ɖe aʋa la wɔwɔ ŋu, ŋutsu akpe ɖeka tso Israel ƒe to ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Finehas, nunɔla Eleazar ƒe viŋutsue nye woƒe aʋakplɔla. Nubablaɖaka la yi kpli wo le esime kpẽwo nɔ ɖiɖim. ");
INSERT INTO ewe_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Wowu Midian ŋutsu ɖe sia ɖe le aʋa la me. ");
INSERT INTO ewe_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Wowu Midian fia atɔ̃awo katã, Evi, Rekem, Zur, Hur kple Reba. Wowu Balaam, Beor ƒe viŋutsu la hã. ");
INSERT INTO ewe_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Israelviwo ƒe aʋakɔ la ɖe aboyo Midiantɔwo ƒe nyɔnuwo kple ɖeviwo katã, eye woha woƒe lãwo kple woƒe kesinɔnu geɖewo. ");
INSERT INTO ewe_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Wotɔ dzo Midiantɔwo ƒe duwo kple kɔƒewo katã, ");
INSERT INTO ewe_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","woɖe aboyo amewo, eye woha woƒe lãwo katã. ");
INSERT INTO ewe_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Wotsɔ aboyomeawo kple afunyinuawo katã vɛ na Mose kple nunɔla Eleazar kple Israelvi bubu siwo nɔ asaɖa la me le Moab gbedzi le Yɔdan tɔsisi la to, le Yeriko kasa. ");
INSERT INTO ewe_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mose kple nunɔla Eleazar kple ameawo ƒe kplɔla bubuawo katã do go yi ɖakpe aʋakɔ la, ");
INSERT INTO ewe_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ke Mose do dɔmedzoe ɖe aʋakplɔlawo kple aʋalɔgonunɔlawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Ebia wo be, “Nu ka ta miena nyɔnuawo katã tsi agbe? ");
INSERT INTO ewe_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Ame siawo tututue wɔ Balaam ƒe aɖaŋuɖoɖo dzi, eye wona Israelviwo subɔ legbawo le Peor to la dzi; woawoe he dɔvɔ̃ si wu mí la vɛ. ");
INSERT INTO ewe_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Miwu ŋutsuviwo katã kple nyɔnu siwo dɔ ŋutsu gbɔ kpɔ la fifi laa! ");
INSERT INTO ewe_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Mina nyɔnuvi suewo ya nanɔ agbe, eye woazu mia tɔ. ");
INSERT INTO ewe_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Azɔ la, mi ame siwo katã wu ame aɖe alo ka asi ame kuku aɖe ŋu la, minɔ asaɖa la godo ŋkeke adre. Mikɔ mia ɖokuiwo kple nyɔnuvi sueawo ŋu le ŋkeke etɔ̃lia kple adrelia gbe. ");
INSERT INTO ewe_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Miɖo ŋku edzi miakɔ miaƒe awuwo kple nu sia nu si wowɔ kple lãgbalẽ, gbɔ̃fu alo ati la hã ŋuti.” ");
INSERT INTO ewe_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Nunɔla Eleazar gblɔ na aʋadelawo katã be, “Esia nye se si Yehowa de na Mose ");
INSERT INTO ewe_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","‘Nu sia nu si ate ŋu anɔ te ɖe dzoxɔxɔ nu abe sika, klosalo, akɔbli, gaɣi alo tsumi ene la, ");
INSERT INTO ewe_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","woade wo dzo me ale be woakɔ wo ŋu. Emegbe la, woagakɔ wo ŋu kple tsi kɔkɔe. Ke woatsɔ tsi kɔkɔe ko akɔ nu siwo mate ŋu anɔ te ɖe dzoxɔxɔ nu o la ŋuti.’ ");
INSERT INTO ewe_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Le ŋkeke adrelia gbe la, mianya miaƒe awuwo, eye mia ŋuti akɔ ekema miagatrɔ ava asaɖa la me.” ");
INSERT INTO ewe_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Wò kple nunɔla Eleazar kple ƒomeawo ƒe tatɔ siwo le dukɔa me la miaxlẽ amewo kple lã siwo katã wolé le aʋa. ");
INSERT INTO ewe_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Le esia megbe la, miama afunyinuawo ɖe asrafo siwo de aʋa kple ameha mamlɛawo dome. ");
INSERT INTO ewe_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Mixɔ nu sia nu si asrafoawo xɔ la ƒe ɖeka le alafa atɔ̃ ɖe sia ɖe me abe nunana ene na Yehowa, eɖanye amegbetɔ, nyiwo, tedziwo, alẽwo loo alo gbɔ̃wo o. ");
INSERT INTO ewe_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Mixɔ nunana sia ƒe afã le wo si, eye miatsɔe na nunɔla Eleazar abe Yehowa ƒe gome ene. ");
INSERT INTO ewe_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Tso nu siwo ke Israelviwo xɔ ƒe afã me la, tia ɖeka le blaatɔ̃ ɖe sia ɖe me, eɖanye amegbetɔ, nyiwo, tedziwo, alẽwo, gbɔ̃wo loo alo lã bubuwo o. Tsɔ wo na Levi ƒe viwo, ame siwo kpɔa Yehowa ƒe Agbadɔ la ƒe nyawo gbɔ.” ");
INSERT INTO ewe_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Ale Mose kple nunɔla Eleazar wowɔ se siwo Yehowa de na wo to Mose dzi la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Aʋadelawo tsɔ sikanu kple awu siwo woha la na wo ɖokui. Nu bubu siwo woha la woe nye alẽ akpe alafa ade, blaadre-vɔ-atɔ̃ (675,000), ");
INSERT INTO ewe_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","nyi akpe blaadre-vɔ-eve (72,000), ");
INSERT INTO ewe_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","tedzi akpe blaade-vɔ-ɖekɛ (61,000) kple ");
INSERT INTO ewe_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","nyɔnuvi akpe blaetɔ̃-vɔ-eve (32,000). ");
INSERT INTO ewe_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Nu siawo ƒe afã, si wotsɔ na aʋadelawoe nye: alẽ akpe alafa etɔ̃, blaetɔ̃-vɔ-adre alafa atɔ̃ (337,500), ");
INSERT INTO ewe_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","wotsɔ wo dome alafa ade, blaadre-vɔ-atɔ̃ (675) na Yehowa; ");
INSERT INTO ewe_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","nyi akpe blaetɔ̃ vɔ ade (36,000), wotsɔ wo dome blaadre-vɔ-eve na Yehowa, ");
INSERT INTO ewe_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","tedzi akpe blaetɔ̃, alafa atɔ (30,500), wotsɔ wo dome blaade-vɔ-ɖekɛ na Yehowa; ");
INSERT INTO ewe_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","nyɔnuvi akpe wuiade (16,000), wotsɔ wo dome blaetɔ̃-vɔ-eve, siwo nye Yehowa tɔ la na Levi ƒe viwo. ");
INSERT INTO ewe_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Wotsɔ nu siwo katã nye Yehowa tɔ la na nunɔla Eleazar, abe ale si Yehowa ɖo na Mose ene. ");
INSERT INTO ewe_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Mose tsɔ nu siwo woha le aʋa me la ƒe afã na Israelviwo eye afã bubu na aʋadelawo. ");
INSERT INTO ewe_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Afã mamlɛa, si wotsɔ na Israelviwo la yi ale: alẽ akpe alafa etɔ̃, blaetɔ̃-vɔ-adre, alafa atɔ̃ (337,500), ");
INSERT INTO ewe_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","nyi akpe blaetɔ̃ vɔ ade (36,000), ");
INSERT INTO ewe_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","tedzi akpe blaetɔ̃ alafa atɔ̃ (30,500) kple ");
INSERT INTO ewe_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","nyɔnuvi akpe wuiade (16,000). ");
INSERT INTO ewe_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Le Yehowa ƒe ɖoɖowo nu la, Mose tsɔ nu siawo dometɔ ɖe sia ɖe ƒe blaatɔ̃lia ƒe ɖeka le Israelviwo tɔ ŋu hena Levi ƒe viwo, ame siwo wɔa dɔ le Yehowa ƒe agbadɔ la me. ");
INSERT INTO ewe_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Aʋakplɔla siwo le aʋalɔgowo nu, esiwo le ŋutsu akpewo nu kple esiwo le ŋutsu alafawo nu la yi Mose gbɔ, ");
INSERT INTO ewe_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","eye wogblɔ nɛ be, “Wò dɔlawo xlẽ asrafo siwo le mía te la, eye wo dometɔ ɖeka pɛ gɔ̃ hã mebu o. ");
INSERT INTO ewe_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Eya ta míetsɔ akpedavɔsa tɔxɛ vɛ na Yehowa tso nu siwo míeha la me, woawoe nye sika, alɔnugɛwo, afɔgɛwo, asigɛwo, togɛwo kple kɔsɔkɔsɔwo. Míetsɔ nu siawo hena avuléle le Yehowa ŋkume ɖe míaƒe luʋɔwo ta.” ");
INSERT INTO ewe_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mose kple nunɔla Eleazar woxɔ sika kple aɖaŋunuwɔwɔwo le wo si. ");
INSERT INTO ewe_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Sika si woxɔ tso asrafo akpewo nunɔlawo kple asrafo alafawo nunɔlawo si, eye Mose kple Eleazar tsɔ wo na Yehowa la ƒe kpekpemee nye kilogram alafa ɖeka blaasiekɛ (190). ");
INSERT INTO ewe_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Asrafoawo tsɔ nu siawo ƒe ɖe na wo ɖokuiwo xoxo. ");
INSERT INTO ewe_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mose kple nunɔla Eleaza xɔ sikawo le ame siwo woɖo ame akpewo kple ame alafawo nu la si eye wotsɔ nunana sia ɖadzra ɖo ɖe agbadɔ la me le Yehowa ŋkume abe ŋkuɖodzinu na Israelviwo ene. ");
INSERT INTO ewe_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Esi Israelviwo ɖo Yazer kple Gileadnyigbawo dzi la, Ruben kple Gad ƒe towo, ame siwo si alẽha gãwo le la kpɔ be anyigba la nyo ŋutɔ na lãnyinyi. ");
INSERT INTO ewe_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Eya ta wogblɔ na Mose kple nunɔla Eleazar kple toawo ƒe kplɔlawo be, ");
INSERT INTO ewe_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“Atarɔt, Dibon, Yazer, Nimra, Hesbon, Eleale, Sebam, Nebo kple Beon ƒe ");
INSERT INTO ewe_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","anyigba siwo Yehowa xɔ le Israelviwo ŋkume la nyo na lãnyinyi, eye lãwo le wò dɔlawo si. ");
INSERT INTO ewe_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Ne eve mía nu la ekema míeɖe kuku tsɔ anyigba sia na mí ɖe anyigba si le Yɔdan tɔsisi la ƒe akpa kemɛ teƒe.” ");
INSERT INTO ewe_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mose bia wo be, “Ɖe miedi be yewoatsi afi sia ne mia nɔviwo ya natso tɔsisi la, eye woawo ɖeɖe nayi aɖawɔ aʋa kple afi ma tɔwoa? ");
INSERT INTO ewe_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Ɖe miedi be yewoaɖe dzi le Israelviwo ƒo be womagatso tɔsisi la ayi aɖaxɔ anyigba si ƒe ŋugbe Yehowa do na wo oa? ");
INSERT INTO ewe_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Nu sia tɔgbi tututu mia tɔgbiwo wɔ kpɔ! Meɖo wo ɖa be woaɖatsa ŋku le Kades Barneanyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Esi wowu ŋkutsatsa la nu, eye wotrɔ tso Eskɔl ƒe balime gbɔ la, woɖe dzi le Israelviwo ƒo le Ŋugbedodonyigba la dzi yiyi ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Yehowa do dɔmedzoe gbe ma gbe, eye woka atam sia be, ");
INSERT INTO ewe_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘Esi miedze yonyeme kple dzi blibo o ta la, ame siwo xɔ ƒe blaeve alo wu nenema, ame siwo tso Egipte la dometɔ ɖeka pɛ hã makpɔ anyigba si ŋugbe medo kple atam na Abraham, Isak kple Yakob o. ");
INSERT INTO ewe_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Wo dometɔ siwo ko ade Ŋugbedodonyigba la dzie nye Kaleb, Yefune, Kenizitɔ la ƒe viŋutsu kple Yosua, Nun ƒe viŋutsu, elabena woawo dze Yehowa yome kple woƒe dzi blibo, eye wode dzi ƒo na ameawo be woayi Ŋugbedodonyigba la dzi.’ ");
INSERT INTO ewe_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Yehowa na míetsa tsaglalã le gbedzi ƒe blaene va se ɖe esime dzidzime vɔ̃ɖi ma tsrɔ̃ keŋkeŋ. ");
INSERT INTO ewe_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“Ke miawo hã, mi vɔ̃ wɔlawo ƒe dzidzimeviwo, miegale nu ma tututu wɔm! Miawo miesɔ gbɔ wu woawo, eya ta Yehowa ƒe dziku ɖe miawo ŋu nu asẽ ɖe miawo dzi fifia wu ɖe woawo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Ne mietrɔ ɖa tso Mawu gbɔ alea la, ana ameawo naganɔ gbea dzi ɣeyiɣi didi aɖe wu, eye miahe ku vɛ na ameawo kple dzɔgbevɔ̃e va dukɔ blibo la dzi!” ");
INSERT INTO ewe_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Woɖo eŋu be, “Míawɔ nenema o, ke boŋ míatu lãkpowo na míaƒe lãwo, eye míatso duwo na mía viwo ɖe afi sia. ");
INSERT INTO ewe_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Míawo ŋutɔ míabla akpa, adze ŋgɔ na Israelvi bubuawo va se ɖe esime míakplɔ wo, woƒe asi naka woƒe domenyinu la dedie. Ke ele be míatso duwo, aɖo gli aƒo xlã wo na mía srɔ̃wo kple mía viwo gbã, ale be afi sia tɔwo maho aʋa ɖe wo ŋu o. ");
INSERT INTO ewe_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Míatsi afi sia o, va se ɖe esime Israelviwo katã ƒe asi asu woƒe domenyinu la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Míedi anyigba si le Yɔdan tɔsisi la ƒe akpa kemɛ o; míedi esi le tɔsisi la ƒe akpa sia, le ɣedzeƒe lɔƒo.” ");
INSERT INTO ewe_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mose gblɔ na wo be, “Enyo; ne miawɔ ɖe nya si miegblɔ dzi, abla akpa hena aʋawɔwɔ na Yehowa, ");
INSERT INTO ewe_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","eye miana miaƒe aʋawɔlawo nanɔ Yɔdan tɔsisi la ƒe akpa kemɛ va se ɖe esime Yehowa nanya eƒe futɔwo ɖa la, ");
INSERT INTO ewe_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ekema ne míeɖu futɔwo dzi mlɔeba le Yehowa ŋkume la, miatrɔ ava afi sia, elabena miawu miaƒe dɔdeasiwo nu na Yehowa kple Israelvi bubuawo katã. Ekema anyigba si le tɔsisi la ƒe ɣedzeƒe lɔƒo la azu mia tɔ tso Yehowa gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“Ke ne miawɔ ɖe nya si miegblɔ dzi o la, ekema miawɔ nu vɔ̃ ɖe Yehowa ŋu. Minya be miaƒe nu vɔ̃ ƒe tohehe ava mia dzi kokoko. ");
INSERT INTO ewe_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Mitso duwo na mia srɔ̃wo kple mia viwo, mitu lãkpowo na miaƒe lãwo, eye miwɔ nu siwo katã miegblɔ be yewoawɔ.” ");
INSERT INTO ewe_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Gad ƒe viwo kple Ruben ƒe viwo gblɔ be, “Míawɔ nu siwo katã nàɖo na mí be míawɔ la tututu. ");
INSERT INTO ewe_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Mía viwo kple mía srɔ̃wo, míaƒe alẽwo kple nyiwo anɔ afi sia le Gilead du la me. ");
INSERT INTO ewe_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Ke mí aʋawɔlawo katã ya la, míatso tɔsisi la ayi aɖawɔ aʋa na Yehowa abe ale si míaƒe aƒetɔ gblɔ ene.” ");
INSERT INTO ewe_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Mose lɔ̃ ɖe edzi, eye wògblɔ na nunɔla Eleazar kple Yosua kple Israelviwo ƒe towo ƒe kplɔlawo be, ");
INSERT INTO ewe_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","“Ne ame siwo wotia tso Gad ƒe viwo kple Ruben ƒe viwo dome be woayi aɖawɔ aʋa na Yehowa dometɔ ɖe sia ɖe tso Yɔdan tɔsisi la kple mi la, ekema ne miexɔ anyigba la le futɔwo si la, miatsɔ Gileadnyigba ana wo. ");
INSERT INTO ewe_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Ke ne wogbe la, ekema woaxɔ anyigba le Kanaanyigba la dzi, le mi ame bubuawo dome.” ");
INSERT INTO ewe_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Gad ƒe viwo kple Ruben ƒe viwo gagblɔ be, “Míawɔ ɖe Yehowa ƒe ɖoɖo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Míabla akpa nyuie adze Yehowa yome ayi Kanaan, ke míawo ya ƒe anyigba anɔ Yɔdan ƒe akpa sia.” ");
INSERT INTO ewe_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Ale Mose tsɔ Amoritɔwo ƒe fia, Sixɔn kple Basantɔwo ƒe fia, Ɔg, ƒe anyigbawo kple duwo katã na Gad kple Ruben ƒe dzidzimeviwo kple Manase, Yosef ƒe viŋutsu ƒe dzidzimeviwo ƒe afã. ");
INSERT INTO ewe_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Du siwo Gad ƒe viwo tso la woe nye: Dibon, Atarɔt kple Aroer, ");
INSERT INTO ewe_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","Atrɔt Sofan, Yazer kple Yogbeha, ");
INSERT INTO ewe_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","Bet Nimra kple Bet Haran. Woɖo gli ƒo xlã du siawo katã, eye lãkpowo nɔ wo me. ");
INSERT INTO ewe_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Du siwo Ruben ƒe viwo tso la woe nye: Hesbon, Eleale kple Kiriataim, ");
INSERT INTO ewe_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","Nebo, Baal Meon kple Sibma. Emegbe la, Israelviwo trɔ ŋkɔ na du siawo dometɔ siwo woxɔ hegbugbɔ tu la. ");
INSERT INTO ewe_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Manase ƒe viŋutsu, Makir yi Gileadnyigba dzi, nya Amoritɔwo, ame siwo nɔ afi ma la ɖa, eye wòxɔe. ");
INSERT INTO ewe_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Ale Mose tsɔ Gileadnyigba na Manase ƒe vi Makir eye wonɔ afi ma. ");
INSERT INTO ewe_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Manase ƒe viŋutsu, Yair ƒe dzidzimeviwo nɔ du geɖewo me le Gileadnyigba dzi. Wotrɔ ŋkɔ na woƒe nɔƒe be, Havrɔtyair, si gɔmee nye Yair ƒe duwo. ");
INSERT INTO ewe_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Le ɣe ma ɣi me la, ŋutsu aɖe si ŋkɔe nye Noba la kplɔ aʋakɔ aɖe yi Kenat kple kɔƒe siwo ƒo xlãe la me, eye wòxɔ wo. Etsɔ eya ŋutɔ ƒe ŋkɔ na teƒe la be Noba. ");
INSERT INTO ewe_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Esiawoe nye Israelviwo ƒe toƒewo tso esime Mose kple Aron wokplɔ wo dzoe le Egiptenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Mose ŋlɔ nu tso woƒe toƒewo ŋu abe ale si Yehowa ɖo nɛ ene. ");
INSERT INTO ewe_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Israelviwo dze mɔ le Rameses le ɣleti atɔ̃lia ƒe ŋkeke wuiatɔ̃lia gbe si nye Ŋutitotoŋkekenyui la ƒe ŋkeke evelia. Wozɔ dzideƒotɔe dzo le Egiptetɔwo ƒe nukpɔkpɔ nu, ");
INSERT INTO ewe_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","le esime Egiptetɔwo nɔ woƒe ŋgɔgbeviwo katã, ame siwo Yehowa ƒo ƒu anyi le wo dome la ɖim, elabena Yehowa he ʋɔnudɔdrɔ̃ va woƒe mawuwo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Israelviwo dzo le Rameses, eye woƒu asaɖa anyi ɖe Sukɔt. ");
INSERT INTO ewe_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Wodzo le Sukɔt, eye woƒu asaɖa anyi ɖe Etam, le gbegbe la to. ");
INSERT INTO ewe_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Esi wodzo le Etam la, wogbugbɔ yi Pi Hahirɔt, le Baal Zefon ƒe ɣedzeƒe, eye woƒu asaɖa anyi ɖe Migdol gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Tso afi sia la, woto Ƒu Dzĩ la titina. Le ŋkeke etɔ̃ megbe la, woɖo Etam gbedzi, eye woƒu asaɖa anyi ɖe Mara. ");
INSERT INTO ewe_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Tso Mara la, wova Elim, afi si vudo wuieve kple deti blaadre le. Wonɔ afi sia eteƒe didi vie. ");
INSERT INTO ewe_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Esi wodzo le Elim la, woƒu asaɖa anyi ɖe Ƒu Dzĩ la to, ");
INSERT INTO ewe_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","eye woho yi Sin gbedzi. ");
INSERT INTO ewe_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Emegbe la, woyi Dofka. ");
INSERT INTO ewe_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Esi wodzo le Dofka la, woyi Alus, ");
INSERT INTO ewe_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","hetso eme yi Refidim, afi si tsi menɔ na ameawo woano o. ");
INSERT INTO ewe_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Tso Refidim la, woyi Sinai gbedzi, ");
INSERT INTO ewe_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","eye tso afi ma la, woyi Kibrot Hatava. ");
INSERT INTO ewe_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Tso Kibrot Hatava la, woyi Hazerot. ");
INSERT INTO ewe_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Tso Hazerot la, woyi Ritmax. ");
INSERT INTO ewe_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Tso Ritmax la, woyi Rimonparez. ");
INSERT INTO ewe_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Tso Rimonparez la, woyi Libna. ");
INSERT INTO ewe_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Tso Libna la, woyi Risa. ");
INSERT INTO ewe_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Tso Risa la, woyi Kehelata. ");
INSERT INTO ewe_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Tso Kehelata la, woyi Sefer to la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Tso Sefer to la gbɔ la, woyi Harada. ");
INSERT INTO ewe_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Tso Harada la, woyi Makhelot. ");
INSERT INTO ewe_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Tso Makhelot la, woyi Tahat. ");
INSERT INTO ewe_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Tso Tahat la, woyi Tera. ");
INSERT INTO ewe_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Tso Tera la, woyi Mitka. ");
INSERT INTO ewe_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Tso Mitka la, woyi Hasmona. ");
INSERT INTO ewe_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Tso Hasmona la, woyi Moserɔt. ");
INSERT INTO ewe_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Tso Moserɔt la, woyi Bene Yakan. ");
INSERT INTO ewe_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Tso Bene Yakan la, woyi Hor Hagidgad. ");
INSERT INTO ewe_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Tso Hor Hagidgad la, woyi Yotbata. ");
INSERT INTO ewe_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Tso Yotbata la, woyi Abrona. ");
INSERT INTO ewe_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Tso Abrona la, woyi Ezion Geber. ");
INSERT INTO ewe_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Tso Ezion Geber la, woyi Kades le Zin gbedzi. ");
INSERT INTO ewe_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Tso Kades la, woyi Hor to la gbɔ le Edomnyigba la to. ");
INSERT INTO ewe_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Le Yehowa ƒe gbeɖeɖe nu la, Nunɔla Aron yi Hor to la dzi, afi si wòku ɖo le ɣleti atɔ̃lia ƒe ŋkeke gbãtɔa gbe le ƒe blaenelia, esi Israelviwo ʋu tso Egipte la me. ");
INSERT INTO ewe_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Aron xɔ ƒe alafa ɖeka, blaeve-vɔ-etɔ̃ esi wòku ɖe Hor to la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Ɣe ma ɣie Kanaantɔwo ƒe fia, Arad fia, ame si nɔ Negeb, le Kanaanyigba dzi la se be Israelviwo gbɔna yeƒe anyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Wowɔ aʋa kplii, eye wotso Hor to la gbɔ heƒu asaɖa anyi ɖe Zalmona. ");
INSERT INTO ewe_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Tso Zalmona la, woyi Punon. ");
INSERT INTO ewe_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Woho tso Punon heva ƒu asaɖa anyi ɖe Obot, ");
INSERT INTO ewe_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","eye woho tso Obot heva ƒu asaɖa anyi ɖe Iye Abarim le Moabtɔwo ƒe liƒo dzi. ");
INSERT INTO ewe_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Tso afi sia la, woƒo asaɖa ɖe Dibon Gad ");
INSERT INTO ewe_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","woyi Dibon Gad heyi Almɔn Diblataim, ");
INSERT INTO ewe_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Abarim towo gbɔ le Nebo to la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Wotso le Abarim towo gbɔ, eye mlɔeba la, wova ɖo Moab gbegbe la le Yɔdan tɔsisi la to le Yeriko kasa. ");
INSERT INTO ewe_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Woƒu asaɖa anyi ɖe teƒe vovovowo le Yɔdan tɔsisi la to tso Bet Yesimot va se ɖe Abel Sitim le Moab tagba. ");
INSERT INTO ewe_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Le Moab tagba, le Yɔdan nu le Yeriko kasa la, Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“Gblɔ na Israelviwo be, ‘Ne mietso Yɔdan, eye miege ɖe Kanaanyigba dzi la, ");
INSERT INTO ewe_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ele be mianya ame siwo katã le anyigba ma dzi, eye miagbã woƒe legbawo; esiawoe nye woƒe kpe kpakpawo, legba siwo wololo ga tsɔ wɔe kple woƒe mawusubɔƒe siwo wotu ɖe toawo dzi, afi si wosubɔa woƒe legbawo le. ");
INSERT INTO ewe_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Metsɔ anyigba la na mi. Mixɔe eye mianɔ edzi. ");
INSERT INTO ewe_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Mima anyigba la ɖe miaƒe towo dome ɖe toawo ƒe lolome nu. Midzidze nu ɖe afi si anyigba la lolo le la dzi, amae ɖe to siwo me amewo sɔ gbɔ le la dome, eye miatsɔ teƒe siwo melolo o la ana to suewo. ");
INSERT INTO ewe_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘Ke ne mienya ame siwo le afi ma o la, wo dometɔ siwo asusɔ ɖe afi ma la, azu dzowɔ aɖo ŋkume na mi kple ŋu anɔ miaƒe axadame. ");
INSERT INTO ewe_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Ekema matsrɔ̃ mi abe ale si meɖo be matsrɔ̃ woe la ene.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“Ɖe gbe na Israelviwo, eye nàgblɔ na wo be, ‘Ne mieɖo Kanaan la, anyigba si woana mi abe domenyinu ene la ƒe liƒowo ayi ale: ");
INSERT INTO ewe_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘Miaƒe anyigba la ƒe anyigbeme ƒe liƒo anye Zin gbegbe la, ato Edom ƒe liƒo dzi. Miaƒe anyigba ƒe dzieheliƒo anye Dzeƒu la, ");
INSERT INTO ewe_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ato afi ma aɖo ta dziehe, ato Akrabim to dzi mɔ le Zin lɔƒo. Eƒe seƒe le dziehe anye Kades Barnea, afi si wòatso aɖo ta Hazar Adar, ayi Azmon. ");
INSERT INTO ewe_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Tso Azmon la, liƒo la azɔ Egipte tɔʋu la ŋu ayi aɖatɔ Dzeƒu la. ");
INSERT INTO ewe_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Miaƒe ɣetoɖoƒeliƒo anye Domeƒu la ƒe ƒuta. ");
INSERT INTO ewe_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Miaƒe dzigbemeliƒo adze egɔme tso Domeƒu la ŋu, aɖo ta ɣedzeƒe, ayi Hor to la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Tso Hor to la gbɔ ayi Lebo Hamat, ato Zedad ");
INSERT INTO ewe_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","kple Zifron, ayi Hazar Enan. Esia anye miaƒe anyieheliƒo la. ");
INSERT INTO ewe_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Miaƒe ɣedzeƒeliƒo atso Hazar Enan aɖo ta anyigbeme ayi Sefam ");
INSERT INTO ewe_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","kple Ribla le Ain ƒe ɣedzeƒe lɔƒo. Tso afi ma la, aɖiɖi aƒo xlã gbã, aɖo ta anyigbeme gome, atrɔ aɖo ta ɣetoɖoƒe lɔƒo va se ɖe esime wòaɖo Galilea ƒu la ƒe anyigbeme nu tututu. ");
INSERT INTO ewe_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Tso afi ma la, azɔ Yɔdan tɔsisi la ŋu ahawu nu ɖe Dzeƒu la nu. “ ‘Esiae nye miaƒe anyigba kple eƒe liƒo si ƒo xlãe.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Mose gblɔ na Israelviwo be, “Anyigba sia dzie miadzidze nu ɖo hena emama ɖe mia dome. Mimae ɖe to asiekɛ kple afã dome, ");
INSERT INTO ewe_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","elabena Ruben ƒe viwo ƒe to la kple Gad ƒe viwo ƒe to la kple Manase ƒe viwo ƒe to la ƒe afã xɔ woƒe domenyinu xoxo. ");
INSERT INTO ewe_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","To eve kple afã siawo xɔ woƒe domenyinu le Yɔdan tɔsisi la ƒe ɣedzeƒe le Yeriko kasa.” ");
INSERT INTO ewe_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“Ame siwo metia be woakpɔ anyigba la mama dzi la ƒe ŋkɔwoe nye: nunɔla Eleazar, Yosua, Nun ƒe viŋutsu, ");
INSERT INTO ewe_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","eye nàtia kplɔla tso to ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“Ame siawoe nye: “Kaleb, Yefune ƒe viŋutsu, tso Yuda ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Samuel, Amihud ƒe viŋutsu, tso Simeon ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Elidad, Kislon ƒe viŋutsu, tso Benyamin ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Buki, Yogli viŋutsu, tso Dan ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Yosef ƒe dzidzimevi siwo anye tatɔwo lae nye esiwo: Haniel, Efɔd ƒe viŋutsu, tso Manase ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Kemuel, Siftan ƒe viŋutsu, tso Efraim ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Elizafan, Parnax viŋutsu, tso Zebulon ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Paltiel, Azan ƒe viŋutsu, tso Isaka ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Ahihud, Selomi ƒe viŋutsu, tso Aser ƒe to la me, ");
INSERT INTO ewe_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Pedahel, Amihud ƒe viŋutsu, tso Naftali ƒe to la me.” ");
INSERT INTO ewe_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Esiawoe nye ame siwo metia be woakpɔ anyigba la mama ɖe Israelviwo dome dzi la ƒe ŋkɔwo. ");
INSERT INTO ewe_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Esi Israelviwo ƒu asaɖa anyi ɖe Yɔdan tɔsisi la to, le Moab gbedzi, le Yeriko kasa la, Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“Na Israelviwo natsɔ du tɔxɛ aɖewo kple lãnyiƒe siwo ƒo xlã wo la ana Levi ƒe viwo abe woƒe domenyinu ene. ");
INSERT INTO ewe_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Woƒe aƒewo anɔ du siawo me, eye anyigba siwo ƒo xlã wo la azu lãnyiƒewo na woƒe nyiwo, alẽwo kple lã bubuawo. ");
INSERT INTO ewe_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“Mina woƒe lãnyiƒewo nakeke mita alafa ene blaatɔ̃ tso duawo ƒe gliwo gbɔ do ɖe afi sia afi. ");
INSERT INTO ewe_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Ale miadzidze du la ƒe ɣedzeƒe gome wòakeke mita alafa asiekɛ, dziehe gome mita alafa asiekɛ, ɣetoɖoƒe gome mita alafa asiekɛ kple anyiehe gome mita alafa asiekɛ, eye du la nanɔ titina. Esia anye lãnyiƒe na wo anɔ duawo ŋu. ");
INSERT INTO ewe_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“Mitsɔ Sitsoƒedu adeawo na Levi ƒe viwo. Ne ame aɖe wu ame le nu maɖowɔ me, eye wòƒu du ge ɖe Sitsoƒedu ade siawo kple du blaene-vɔ-eve bubu me la, anɔ dedie. ");
INSERT INTO ewe_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Woatsɔ du blaene-vɔ-enyi siawo kple lãnyiƒe siwo ƒo xlã wo la ana Levi ƒe viwo. ");
INSERT INTO ewe_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Du siawo anɔ anyigba la ƒe akpa vovovowo. To siwo lolo, eye du geɖewo le wo si la, woana duawo Levi ƒe viwo wòasɔ gbɔ, ke to suewo ana du ʋɛ aɖewo Levi ƒe viwo.” ");
INSERT INTO ewe_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Yehowa gblɔ na Mose be, ");
INSERT INTO ewe_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“Ƒo nu na Israelviwo, eye nàgblɔ na wo be, ‘Ne mietso Yɔdan, eye mieɖo Kanaanyigba dzi la, ");
INSERT INTO ewe_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","mitia Sitsoƒeduwo da ɖi, ale be ne ame aɖe do hlɔ̃ le nu maɖowɔ me la, wòasi ayi wo dometɔ ɖeka me. ");
INSERT INTO ewe_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Du siawo anye xɔnameteƒewo tso ame kuku la ƒe ƒometɔ siwo adi be yewoabia hlɔ̃ la ƒe asi me. Womawu hlɔ̃dola la o va se ɖe esime woadrɔ̃ ʋɔnui, akpɔe be eɖi fɔ. ");
INSERT INTO ewe_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Du ade siawo si miena la anye miaƒe Sitsoƒeduwo. ");
INSERT INTO ewe_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Mina du etɔ̃ nanɔ Yɔdan ƒe akpa sia, eye etɔ̃ nanɔ Kanaan abe Sitsoƒeduwo ene. ");
INSERT INTO ewe_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Du siawo manye sitsoƒewo na Israelviwo ɖeɖe ko o, ke boŋ na amedzrowo kple mɔzɔlawo hã. ");
INSERT INTO ewe_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘Ke ne ame aɖe axlã gakpo aɖe ɖe nɔvia wòaku la, woatsɔe abe hlɔ̃dodo ene, eye woawu hlɔ̃dola la. ");
INSERT INTO ewe_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Ne woƒu kpe gã aɖe ame aɖe wòku la, hlɔ̃dodoe; woawu hlɔ̃dola la hã. ");
INSERT INTO ewe_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Nenema kee woawɔ ame si atsɔ nu si wowɔ kple ati la aƒo nɔvia wòaku. ");
INSERT INTO ewe_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Hlɔ̃biala la nawu hlɔ̃dola la ne edo goe. ");
INSERT INTO ewe_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Ale ne ame aɖe le fuléle ta, wòtsɔ nane ƒu nɔvia alo tso mɔ nɛ, ");
INSERT INTO ewe_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","alo tu kɔe kple dɔmedzoe wòku la, edo hlɔ̃. Hlɔ̃biala nawu hlɔ̃dola la. ");
INSERT INTO ewe_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘Gake ne fuléle mele amea me o, ko kasia wòlɔ ame aɖe ƒu anyi alo da nane tamemaɖomaɖotɔe wòdze ame aɖe, ");
INSERT INTO ewe_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","alo ne mekpɔe o, eye wòƒu kpe si ate ŋu awui, eye wòku la, ekema zi ale si menye futɔ na amea o, eye meɖo be yeawɔ nuvevie o hafi ta la, ");
INSERT INTO ewe_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","woadrɔ̃ ʋɔnui, akpɔ be nyadzɔɖeamedzi koe loo alo ɖe yewoaɖe asi le hlɔ̃dola la ŋu na ame kuku la ƒe hlɔ̃biala mahã. ");
INSERT INTO ewe_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Ne wotso nya me be nyadzɔɖeamedzi koe la, ekema ʋɔnudrɔ̃lawo axɔ na hlɔ̃dola la tso hlɔ̃biala la ƒe asi me. Woaɖe mɔ na hlɔ̃dola la wòanɔ Sitsoƒedu la me, eye wòanɔ afi ma va se ɖe esime nunɔlagã la naku. ");
INSERT INTO ewe_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘Ne hlɔ̃dola la do go le sitsoƒedu la me, ");
INSERT INTO ewe_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","eye hlɔ̃biala la kpɔe le du la godo hewui la, ekema hlɔ̃biala la medo hlɔ̃ o, ");
INSERT INTO ewe_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","elabena ɖe wòle be hlɔ̃dola la nanɔ sitsoƒedu la me va se ɖe esime nunɔlagã la naku hafi. Ke le nunɔlagã la ƒe ku megbe la, hlɔ̃dola la ate ŋu atrɔ ayi wo de. ");
INSERT INTO ewe_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘Esiawoe nye se siwo dzi Israelviwo katã nawɔ tso dzidzime yi dzidzime. ");
INSERT INTO ewe_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘Ele be woawu hlɔ̃dolawo katã, gake ele be ɖasefowo nasɔ gbɔ wu ɖeka. Womawu hlɔ̃dola aɖeke si ŋu ɖasefo ɖeka pɛ ko ɖi ɖase le o. ");
INSERT INTO ewe_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘Ne wodrɔ̃ ʋɔnu ame aɖe, tso nya me be ewu ame la, ekema ele be woawui kokoko. Womaxe alo axɔ naneke ɖe eƒe agbe ta o. ");
INSERT INTO ewe_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘Nenema ke womaxɔ naneke le hlɔ̃dola si yi sitsoƒedu aɖe me la si, aɖe mɔ nɛ be wòatrɔ ayi wo de hafi nunɔlagã la naku o. ");
INSERT INTO ewe_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘Ale womagblẽ kɔ ɖo na anyigba la o, elabena hlɔ̃dodo gblẽa kɔ ɖo na anyigba la. Gawu la, nu si woate ŋu atsɔ alé avu ɖe hlɔ̃dodo ta koe nye hlɔ̃dola la wuwu. ");
INSERT INTO ewe_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Migado ŋunyɔ anyigba si dzi nɔ ge miala la o, elabena nye, Yehowa, mele afi ma nɔ ge.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Gilead, Makir ƒe viŋutsu, ame si nye Manase ƒe viŋutsu, tso Yosef ƒe ƒome la me ƒe amegãwo tso hlɔ̃ la me va ƒo nu le Mose kple kplɔlawo, Israelviwo ƒe ƒometatɔwo ŋkume. ");
INSERT INTO ewe_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Wogblɔ be, “Esime Yehowa ɖe gbe na nye aƒetɔ be wòadzidze nu, ama anyigba la na Israelviwo abe woƒe domenyinu ene la, egblɔ na wò be, nàtsɔ mía nɔvi Zelofehad ƒe domenyinu ana via nyɔnuwo. ");
INSERT INTO ewe_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Ke ne woɖe srɔ̃ tso to bubu aɖe me la, woatsɔ woƒe anyigba la ayi wo srɔ̃ŋutsuwo ƒe towo me. Le mɔ sia nu la, anyigba si woama na mí la dzi aɖe, ");
INSERT INTO ewe_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","eye womatrɔe na mí le Aseyetsoƒe la me o.” ");
INSERT INTO ewe_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Tete Mose ɖe gbeƒã Yehowa ƒe ɖoɖo siawo le Israelviwo ƒe ŋkume be, “Yosef ƒe viwo ƒe nya la le eteƒe. ");
INSERT INTO ewe_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Nu si Yehowa gagblɔ tso Zelofehad ƒe vinyɔnuwo ŋue nye, ‘Mina woaɖe ŋutsu ɖe sia ɖe si dze wo ŋu, ne ŋutsu la nya tso woawo ŋutɔ ƒe to la me ko. ");
INSERT INTO ewe_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Le mɔ sia nu la, to la ƒe Israelnyigba ƒe akpa aɖeke mage ɖe to bubu me tɔwo ƒe asi me o, elabena ele be to sia to ƒe domenyinu nanɔ anyi tegbetegbe, abe ale si wònɔ esi womae gbã na wo la ene. ");
INSERT INTO ewe_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Israelviwo ƒe toawo ƒe nyɔnuwo naɖe srɔ̃ le woawo ŋutɔ ƒe towo me, ale be woƒe anyigba madzo le to la me o. ");
INSERT INTO ewe_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Ale domenyinu aɖeke madzo le to aɖeke me ayi to bubu me o.’ ” ");
INSERT INTO ewe_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Zelofehad ƒe vinyɔnuwo wɔ ɖe nu si Yehowa ɖo na Mose la dzi. ");
INSERT INTO ewe_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Zelofehad ƒe vinyɔnu siawo, Mahla, Tirza, Hogla, Milka kple Noa ɖe wo fofo nɔviŋutsuwo ƒe viŋutsuwo. ");
INSERT INTO ewe_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Woɖe srɔ̃ le Manase, Yosef ƒe viŋutsu ƒe dzidzimeviwo dome, ale woƒe domenyinu la tsi wo fofo ƒe ƒome kple hlɔ̃ la me. ");
INSERT INTO ewe_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Esiawoe nye se siwo Yehowa de na Israelviwo to Mose dzi, le esime woƒu asaɖa anyi ɖe Moab gbedzi le Yɔdan tɔsisi la to le Yeriko kasa.");
INSERT INTO ewe_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Nya siawo Mose gblɔ na Israelviwo katã le Yɔdan tɔsisi la ƒe go kemɛ dzi le gbedzi, le Araba balime, le Suf gbɔ le Paran kple Tofel kple Laban kple Hazerot kple Dizahab dome. ");
INSERT INTO ewe_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","Mɔzɔzɔ tso Horeb to Seir to la ŋu yi Kades Barnea la nye ŋkeke wuiɖekɛ ko ƒe azɔli. ");
INSERT INTO ewe_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Le ɣleti wuiɖekɛlia ƒe ŋkeke gbãtɔ gbe le Israelviwo ƒe mɔzɔzɔ ƒe blaenelia me la, Mose ƒo nu na Israelviwo tso se siwo katã Yehowa miaƒe Mawu de nɛ la ŋu. ");
INSERT INTO ewe_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Esia va eme esi Israel ɖu Sixɔn, Amoritɔwo ƒe fia, ame si nɔ Hesbon kple Ɔg, Basan fia, ame si nɔ Astarot la dzi le Edrei vɔ megbe. ");
INSERT INTO ewe_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Mose de asi se siawo gbɔgblɔ me na Israelviwo le Yɔdan tɔsisi la ƒe go kemɛ dzi, le Moabnyigba dzi. Egblɔ na wo be: ");
INSERT INTO ewe_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Ƒe blaene nye esi va yi, esi Yehowa, míaƒe Mawu la gblɔ na mí le Horeb to la gbɔ be, “Mienɔ afi sia wòdidi. ");
INSERT INTO ewe_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Fifia miyi mianɔ Amoritɔwo ƒe tonyigba dzi kple Araba ƒe balime kple Negeb kple Kanaan kple Lebanon ƒe anyigbawo dzi. Anyigba sia tso Domeƒu la ŋu va se ɖe Frat tɔsisi la ŋu. ");
INSERT INTO ewe_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Metsɔ anyigba sia katã na mi! Miyi edzi, eye miaxɔe, elabena eyae nye anyigba si ŋugbe Yehowa miaƒe Mawu do na mia tɔgbuiwo, Abraham, Isak kple Yakob kple woƒe dzidzimeviwo katã.” ");
INSERT INTO ewe_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Le ɣe ma ɣi me la, megblɔ na ameawo be, “Mehiã kpeɖeŋutɔ! Mienye agba gã aɖe nam be nye ɖeka matsɔ, ");
INSERT INTO ewe_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","elabena Yehowa miaƒe Mawu na miedzi sɔ gbɔ abe ɣletiviwo ene! ");
INSERT INTO ewe_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Mawu nagana miadzi ɖe edzi zi akpeakpewo wu, eye wòayra mi abe ale si wòdo ŋugbee ene. ");
INSERT INTO ewe_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Ke nu ka ame ɖeka ate ŋu awɔ le miaƒe dzrenyawo dɔdrɔ̃ kple nukpekeamewo ŋuti? ");
INSERT INTO ewe_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Eya ta mitia ŋutsu aɖewo tso to sia to me, ame siwo nye nunyalawo, nugɔmeselawo kple nuteƒekpɔlawo, eye maɖo wo miaƒe kplɔlawo.” ");
INSERT INTO ewe_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Ke mieɖo eŋu nam be, “Nya si nègblɔ la nyo be woawɔ ɖe edzi.” ");
INSERT INTO ewe_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Metsɔ amegã siwo wotia tso to ɖe sia ɖe me eye wonye ŋutsu siwo nye bubumewo, eye tagbɔ li na wo la ɖo dzikpɔlawo ɖe mia nu, ɖe ame akpewo, alafawo, blaatɔ̃wo kple ewowo nu be woadrɔ̃ nyawo, eye woakpe ɖe wo ŋu le mɔ sia mɔ nu. ");
INSERT INTO ewe_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Mede se na miaƒe ʋɔnudrɔ̃lawo le ɣe ma ɣi be, “Midrɔ̃ ʋɔnu dzɔdzɔe na ame sia ame kple nɔvia kpakple amedzrowo gɔ̃ hã. ");
INSERT INTO ewe_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Megblɔ na wo be, ‘Le miaƒe nyametsotsowo me la, migade ame aɖeke dzi le eƒe hotsuitɔnyenye ta o. Miwɔ nu dzɔdzɔe ɖe amegãwo kple ame gblɔewo siaa ŋu sɔsɔe. Migavɔ̃ na woƒe dzikudodo ɖe mia ŋu o, elabena Mawu teƒee miele ʋɔnu drɔ̃m ɖo. Mitsɔ nya siwo sesẽ akpa na mi la vɛ nam, eye mawɔ wo ŋu dɔ.’ ");
INSERT INTO ewe_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Le ɣe ma ɣi me la, megblɔ nu siwo katã wòle be miawɔ la na mi.” ");
INSERT INTO ewe_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Míedzo le Horeb to la gbɔ, eye míezɔ mɔ to gbegbe gã dziŋɔ la dzi. Mlɔeba la, míeva ɖo Amoritɔwo ƒe towo gbɔ, afi si Yehowa, míaƒe Mawu la ɖo na mí be míayi. Míeɖo Kades Barnea le Ŋugbedodonyigba la ƒe liƒo dzi. ");
INSERT INTO ewe_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Megblɔ na ameawo be, “Yehowa, mía Mawu la tsɔ Amoritɔwo ƒe tonyigba sia na mí. ");
INSERT INTO ewe_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Miyi miaxɔe abe ale si wògblɔ na mí ene. Migavɔ̃ o. Migake ɖi gɔ̃ hã o.” ");
INSERT INTO ewe_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Wogblɔ be, “Gbã la, mina míaɖo ŋkutsalawo ɖa ne woanya mɔ nyuitɔ si dzi míato age ɖe anyigba la dzi kple du gbãtɔ si míaxɔ.” ");
INSERT INTO ewe_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Esia nye susu nyui aɖe, eya ta meɖo ŋkutsala wuieve ɖa, ɖeka tso to ɖe sia ɖe me. ");
INSERT INTO ewe_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Woto toawo dzi heyi Eskɔl ƒe balime. ");
INSERT INTO ewe_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Wotsɔ afi ma ƒe kutsetse aɖewo gbɔe. Wotsɔ wo vɛ na mí eye wogblɔ be, “Míedze sii enumake be anyigba nyui aɖe ŋutɔe Yehowa, míaƒe Mawu la na mí.” ");
INSERT INTO ewe_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Ke ameawo gbe be yewomayi anyigba la dzi o, eya ta wotsi tsitre ɖe Yehowa miaƒe Mawu ƒe ɖoɖo ŋuti. ");
INSERT INTO ewe_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Wolĩ liʋĩliʋĩ le woƒe agbadɔwo me hegblɔ be, “Yehowa melɔ̃ mí o; ekplɔ mí tso Egipte be Amoritɔwo nawu mí. ");
INSERT INTO ewe_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Nu kae le míawɔ ge? Mía nɔvi ŋkutsalawo ƒe ɖaseɖiɖi do ŋɔdzi na mí. Wobe, ‘Anyigba la dzi tɔwo nye ame dzɔatsu sesẽwo, eye gli siwo woɖo ƒo xlã woƒe duwo la kɔ yi ɖatɔ dziŋgɔli! Wokpɔ ame dzɔatsu siwo nye Anak ƒe dzidzimeviwo gɔ̃ hã le afi ma.’ ” ");
INSERT INTO ewe_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Ke megblɔ na wo be, “Migavɔ̃ o! ");
INSERT INTO ewe_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Yehowa Mawue nye míaƒe kplɔla eye wòawɔ aʋa na mí kple eƒe nukumɔ triakɔwo abe ale si wòwɔ miekpɔ le Egipte ene. ");
INSERT INTO ewe_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Miawo ŋutɔ mienya ale si wòlé be na mí ɣe sia ɣi le gbedzi le afi sia, abe ale si fofo léa be na via ene!” ");
INSERT INTO ewe_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Ke nya siwo megblɔ la mewɔ dɔ aɖeke ɖe mia dzi o. Miegbe eye miexɔ Yehowa, miaƒe Mawu la dzi se o, ");
INSERT INTO ewe_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","evɔ wònye eyae kplɔ mi le mɔzɔzɔ blibo la me, tia teƒe nyuitɔwo na mi be miaƒu asaɖa anyi ɖo. Ekplɔ mi kple dzo bibi le zã me kple lilikpo dodo le ŋkeke me. ");
INSERT INTO ewe_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Yehowa se woƒe liʋĩliʋĩlilĩ, eye wòdo dɔmedzoe ŋutɔŋutɔ. Eka atam be, ");
INSERT INTO ewe_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“Ame ɖeka pɛ gɔ̃ hã matso dzidzime vɔ̃ɖi ma me, anɔ agbe akpɔ anyigba si ŋugbe yedo na wo fofowo o, ");
INSERT INTO ewe_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","negbe Kaleb, Yefune ƒe viŋutsu ko, elabena Kaleb ya dze Yehowa yome, eya ta axɔ anyigba si dzi wòzɔ la ƒe akpa aɖe abe eƒe domenyinu ene.” ");
INSERT INTO ewe_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Yehowa do dɔmedzoe ɖe nye gɔ̃ hã ŋu le woawo ta, eye wògblɔ nam be, “Màde Ŋugbedodonyigba la dzi o! ");
INSERT INTO ewe_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Wò kpeɖeŋutɔ, Yosua, Nun ƒe viŋutsu akplɔ Israelviwo ɖe tewòƒe woade afi ma. De dzi ƒo nɛ esi wòle dzadzram ɖo hena ameawo kpɔkplɔ. ");
INSERT INTO ewe_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Matsɔ anyigba la ana wo vi siwo woawo ŋutɔ wogblɔ be woaku le gbedzi. ");
INSERT INTO ewe_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Ke mi dzidzime xoxo ma me viwo ya la, mitrɔ fifi laa, miagbugbɔ aɖo ta Ƒu Dzĩ la gbɔ.” ");
INSERT INTO ewe_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Tete mieʋu eme be, “Míewɔ nu vɔ̃ ɖe Yehowa ŋu. Míayi anyigba la dzi, awɔ aʋa ɖe eta abe ale si Yehowa, míaƒe Mawu la ɖo na mí be míawɔ ene.” Ale wokpla woƒe aʋawɔnuwo hebu be yewoaɖu anyigba blibo la dzi tɔwo dzi bɔbɔe. ");
INSERT INTO ewe_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Ke Yehowa gblɔ nam be, “Gblɔ na wo bena, ‘Miekpɔ ayi awɔ aʋa o, elabena nyemanɔ kpli mi o. Miaƒe futɔwo aɖu mia dzi.’ ” ");
INSERT INTO ewe_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Megblɔe na wo, gake womeɖo tom o, ke boŋ wogatsi tsitre ɖe Yehowa ƒe ɖoɖo ŋuti heyi tonyigba la dzi hena aʋawɔwɔ. ");
INSERT INTO ewe_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Ke Amoritɔwo, ame siwo nɔ afi ma la kpe aʋa kpli wo, nya wo ɖe du nu abe anyiwo ene, eye wowu wo tso Seir va se ɖe keke Horma. ");
INSERT INTO ewe_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Wotrɔ gbɔ, eye wofa avi le Yehowa ŋkume, gake meɖo to wo o. ");
INSERT INTO ewe_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Ale wonɔ afi ma, Kades, ɣeyiɣi didi aɖe. ");
INSERT INTO ewe_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Míetrɔ, gbugbɔ to gbegbe la heɖo ta Ƒu Dzĩ la gbɔ, elabena nenemae Yehowa ɖo nam. Míetsa tsaglalã le Seir to la gbɔ ƒe geɖewo. ");
INSERT INTO ewe_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Mlɔeba la, Yehowa gblɔ nam be, ");
INSERT INTO ewe_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“Mienɔ to sia ŋu wòdidi. Mitrɔ ɖo ta anyiehe lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Gblɔ na ameawo be wole wo nɔviwo, Edomtɔwo ƒe anyigba dzi to ge. Ame siawoe nye Esau ƒe dzidzimevi siwo le Seir. Dzidzi aƒo Edomtɔwo, eya ta mikpɔ nyuie. ");
INSERT INTO ewe_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Migaho aʋa ɖe wo ŋu o, elabena metsɔ Seir to la ƒe tonyigbawo katã na wo tegbetegbe, eye nyematsɔ woƒe anyigba ƒe kakɛ aɖeke ana mi o. ");
INSERT INTO ewe_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Mixe fe na wo ɖe woƒe nu si miaɖu kple woƒe tsi si ŋu dɔ miawɔ la ta.” ");
INSERT INTO ewe_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Yehowa, míaƒe Mawu la kpɔ mía ta, eye wòyra míaƒe afɔɖeɖe ɖe sia ɖe le míaƒe mɔzɔzɔ me le ƒe blaene siawo katã me, esime míetsa tsaglalã le gbegbe gã la. Naneke mehiã mí le ɣeyiɣi ma katã me o! ");
INSERT INTO ewe_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Ale míeto Edom, afi si mía nɔviwo Esau viwo nɔ le Seir. Míeto Araba mɔ si to anyigbeme yi Elat kple Ezion Geber, eye míeto dzigbeme ɖo ta Moab gbegbe la. ");
INSERT INTO ewe_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Yehowa míaƒe Mawu de se na mí be, “Migaho aʋa ɖe Moabtɔwo hã ŋu o, elabena nyematsɔ woƒe anyigba ƒe akpa aɖeke na mi o. Metsɔe na Lot ƒe dzidzimeviwo!” ");
INSERT INTO ewe_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","“Emitɔwo nɔ afi ma tsã. Wonye dukɔ gã aɖe, eye wodzɔ atsu abe Anak ƒe viwo ene. ");
INSERT INTO ewe_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Woyɔa Emitɔwo kple Anaktɔwo be Refaimtɔwo, ke Moabtɔwo yɔa wo be Emitɔwo. ");
INSERT INTO ewe_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Horitɔwoe nɔ Seir tsã, ke Edomtɔwo, Esau ƒe dzidzimeviwo nya wo hexɔ wo teƒe abe ale si Israelviwo ava xɔ Kanaantɔwo, ame siwo ƒe anyigba Yehowa tsɔ na Israelviwo la teƒe ene. ");
INSERT INTO ewe_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","“Yehowa gblɔ be, ‘Mitso Zered tɔʋu la azɔ,’ eye míetsoe. ");
INSERT INTO ewe_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","“Ale míezɔ mɔ ƒe blaetɔ̃-vɔ-enyi hafi te ŋu to Zered mlɔeba, heɖo Kades, elabena Yehowa ka atam be míaɖo Kades o, va se ɖe esime ame siwo katã tsi ate ŋu ayi aʋa le ƒe blaetɔ̃-vɔ-enyi si va yi me la katã ku hafi. ");
INSERT INTO ewe_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Ɛ̃, Yehowa ƒe asi tsi tsitre ɖe wo ŋu va se ɖe esime wo katã woku. ");
INSERT INTO ewe_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","“Le esia megbe la, ");
INSERT INTO ewe_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","Yehowa gblɔ nam be, ");
INSERT INTO ewe_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","‘Egbe la, Israelviwo ato Moab nyigba ƒe liƒo dzi le Ar, ");
INSERT INTO ewe_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","age ɖe Amonitɔwo ƒe anyigba dzi. Ke migaho aʋa ɖe wo ŋu o, elabena nyematsɔ woƒe anyigba ƒe akpa aɖeke na mi o. Metsɔe na Lot ƒe dzidzimeviwo.’ ");
INSERT INTO ewe_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","“Refaimtɔwo nɔ afi ma hã kpɔ. Amonitɔwo yɔ wo be Zanzumitɔwo. ");
INSERT INTO ewe_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Wonye dukɔ gã sesẽ aɖe, eye wokɔ abe Anaktɔwo ene. Ke Yehowa tsrɔ̃ wo esime Amoritɔwo va anyigba la dzi, eye woxɔ wo teƒe. ");
INSERT INTO ewe_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Nenema ke Yehowa kpe ɖe Esau ƒe dzidzimeviwo ŋu le Seir to la gbɔ, eye wotsrɔ̃ Horitɔwo, ame siwo nɔ afi ma do ŋgɔ na wo. ");
INSERT INTO ewe_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Nenema kee Kaftoritɔwo dze Avitɔwo, ame siwo nɔ du siwo kaka ɖe afi ma va se ɖe keke Gaza ke la dzi.” ");
INSERT INTO ewe_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“Azɔ Yehowa gblɔ nam be, Mitso Arnon tɔsisi la, miage ɖe Sixɔn, Amoritɔwo ƒe fia, ame si le Hesbon la ƒe anyigba dzi. Miwɔ aʋa kpli wo, eye miade asi anyigba la xɔxɔ me. ");
INSERT INTO ewe_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Tso gbe ma gbe dzi la, mana anyigbadzitɔwo katã nade asi dzodzo me nyanyanya le mia vɔvɔ̃ kple miaƒe afi ma ɖoɖo ta.” ");
INSERT INTO ewe_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","“Tso Kedemot gbegbe la, meɖo ame dɔdɔwo ɖe Fia Sixɔn le Hesbon be míawɔ ŋutifafa kple eƒe amewo. ");
INSERT INTO ewe_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Míebia be, ‘Na míato wò anyigba dzi ayi. Míanɔ mɔ gã la dzi ko; míage ɖe miaƒe agblewo me le ɖusime loo alo miame o. ");
INSERT INTO ewe_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Míafi miaƒe nuɖuɖu ne míele eme tsom o, ke boŋ míaxe fe ɖe miaƒe nu si míaɖu kple miaƒe tsi si míano la ta. Nu si biam míele koe nye be míato wò anyigba dzi ayi.’ ");
INSERT INTO ewe_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Edomtɔwo ɖe mɔ na mí le Seir míeto woƒe anyigba dzi. Moabtɔwo hã wɔ nenema ke na mi le Ar. Míele mɔ dzi be míatso Yɔdan, ayi anyigba si Yehowa míaƒe Mawu tsɔ na mí la dzi.” ");
INSERT INTO ewe_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ke Hesbon fia Sixɔn melɔ̃ be mía egbɔ ayi o, elabena Yehowa, miaƒe Mawu la na wòsẽ dzi me, ale be wòate ŋu aɖe asi le Sixɔn ŋu na mi abe ale si wòwɔe fifia ene. ");
INSERT INTO ewe_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Azɔ la, Yehowa gblɔ nam be, “Medze Fia Sixɔn ƒe anyigba tsɔtsɔ na mi gɔme. Ne miexɔe la, azu Israelviwo tɔ tegbetegbe.” ");
INSERT INTO ewe_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Eye Sixɔn kple eƒe aʋakɔ blibo la ho aʋa va kpe mí le Yahaz. ");
INSERT INTO ewe_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Ke Yehowa, míaƒe Mawu la na míeɖu wo dzi, xɔ woƒe duwo katã. ");
INSERT INTO ewe_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Míetsrɔ̃ woƒe nu sia nu kple woƒe nyɔnuwo kple woƒe vidzĩwo katã. Míena naneke tsi agbe o, ");
INSERT INTO ewe_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","negbe woƒe nyiwo ko. Míetsɔ woƒe nyiwo abe míaƒe fetu ene kpe ɖe afunyinu siwo míelɔ tso woƒe du siwo míexɔ me la ŋu. ");
INSERT INTO ewe_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Míexɔ teƒe ɖe sia ɖe tso Aroer yi Gilead, tso Arnon tɔsisi la ƒe balime ƒe liƒo dzi kple du siwo katã le bali la me. Woƒe du aɖeke mesẽ wu mí o elabena Yehowa, mía Mawu la tsɔ wo katã de asi na mí. ");
INSERT INTO ewe_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Ke míegblẽ Amonitɔwo kple Yabok tɔsisi la kple du siwo le tonyigba la dzi kple teƒe siwo me Yehowa, míaƒe Mawu, de se na mí be míagage ɖo o la ɖi. ");
INSERT INTO ewe_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Azɔ míetrɔ ɖo ta Ɔg, Basan fia ƒe anyigba dzi. Ɔg ƒo eƒe aʋakɔ nu ƒu enumake eye wokpe aʋa kpli mí le Edrei. ");
INSERT INTO ewe_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Ke Yehowa gblɔ nam be, “Mègavɔ̃e o, elabena matsɔ eya ŋutɔ kple eƒe aʋakɔ blibo la kpakple eƒe anyigba blibo la ade asi na wò; eye nawɔe abe ale si nèwɔ Fia Sixɔn, Amoritɔwo ƒe fia, le Hesbon ene.” ");
INSERT INTO ewe_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Ale Yehowa miaƒe Mawu tsɔ Ɔg, Basan fia hã kple eƒe dukɔ blibo la de asi na mi, eye míewu wo katã, ale be ame aɖeke metsi agbe ahayi sisi ge o. ");
INSERT INTO ewe_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Míexɔ eƒe du blaadeawo katã kple Basan ƒe to si woyɔna be Argob. ");
INSERT INTO ewe_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Woɖo gli kɔkɔwo ƒo xlã du siawo, eye wode gakpogbowo wo nu. Míexɔ du siwo katã womeɖo gli ƒo xlãe o la hã. ");
INSERT INTO ewe_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Míetsrɔ̃ Basan fiaɖuƒe la keŋkeŋ abe ale si míetsrɔ̃ Fia Sixɔn ƒe fiaɖuƒe le Hesbon ene, eye míewu ameawo katã, ŋutsuwo, nyɔnuwo kple ɖeviwo siaa. ");
INSERT INTO ewe_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Ke mieha woƒe nyiwo kple afunyinuwo na mía ɖokuiwo. ");
INSERT INTO ewe_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Azɔ la, Amoritɔwo ƒe fia eveawo ƒe anyigba si le Yɔdan tɔsisi la ƒe go kemɛ dzi la zu mía tɔ. Anyigba sia tso Arnon ƒe balime yi Hermon to la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Sidontɔwo yɔa Hermon to la be Sirion le esime Amoritɔwo yɔe be Senir.) ");
INSERT INTO ewe_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Míexɔ du siwo katã le tonyigba la dzi kple esiwo le Gilead kple Basan azɔ va se ɖe keke Saleka kple Edrei. ");
INSERT INTO ewe_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","(Ɔg, Basan fiae nye ame dzɔtsu, Refaimtɔwo ƒe mamlɛtɔ. Wotsɔ eƒe gabati dzra ɖo ɖe nuwo dzraɖoƒe le Raba, si nye Amonitɔwo ƒe duwo dometɔ ɖeka me. Gabati sia didi afɔ wuietɔ̃ kple afã, eye wòkeke afɔ ade.) ");
INSERT INTO ewe_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Míetsɔ anyigba si míexɔ la na Ruben ƒe viwo kple Gad ƒe viwo kple Manase ƒe to afã la ƒe viwo. Metsɔ anyiehenyigba si tso Areor le Arnon tɔsisi la gbɔ kple Gilead to la ƒe afã kple eƒe duwo na Ruben ƒe viwo kple Gad ƒe viwo. ");
INSERT INTO ewe_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Manase ƒe viwo xɔ Gilead ƒe akpa mamlɛtɔ kple teƒe si Fia Ɔg ƒe fiaɖuƒe nɔ le Argob nuto me. Woyɔa Basan ɣe aɖewo ɣi be, “Refaim ƒe Anyigba.” ");
INSERT INTO ewe_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Manase ƒe hlɔ̃ si woyɔna be Yair la xɔ Argob nuto me blibo la, si nye Basan va se ɖe Gesuritɔwo kple Makatitɔwo ƒe liƒowo dzi. Wotsɔ woawo ŋutɔwo ƒe ŋkɔ na anyigba la be Havɔt Yair si gɔmee nye “Yair ƒe Kɔƒewo” abe ale si wogayɔa wo egbegbe ene. ");
INSERT INTO ewe_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Metsɔ Gilead na Makir ƒe hlɔ̃. ");
INSERT INTO ewe_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Ruben kple Gad ƒe towo xɔ anyigba tso Yabok tɔsisi la ŋu le Gilead, afi si Amonitɔwo ƒe anyigba dze egɔme tso va se ɖe Arnon tɔsisi la ƒe balime ƒe titina. ");
INSERT INTO ewe_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Woxɔ Araba gbegbe si Yɔdan tɔsisi la do liƒo na le ɣetoɖoƒe, tso Kineret va se ɖe Pisga kple Dzeƒu la, si wogayɔna be Araba ƒu la ŋu. ");
INSERT INTO ewe_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Mede se na mi be, “Yehowa, miaƒe Mawu, tsɔ anyigba sia na mi, ne woanye mia tɔ. Mi kalẽtɔwo katã mibla akpa dze mia nɔvi Israelviwo ŋgɔ. ");
INSERT INTO ewe_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Ke mia srɔ̃wo kple mia viwo ya ate ŋu anɔ afi sia le du siwo metsɔ na mi la me; woanɔ miaƒe nyiwo dzi kpɔm ");
INSERT INTO ewe_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","va se ɖe esime miatrɔ agbɔ, eye mana to bubuawo hã naɖu woƒe futɔwo dzi. Ne woxɔ anyigba si Yehowa, míaƒe Mawu la tsɔ na wo le Yɔdan tɔsisi la godo la, ekema miate ŋu atrɔ va afi sia, si nye miawo ŋutɔ ƒe anyigba la dzi.” ");
INSERT INTO ewe_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Megblɔ na Yosua be, “Wò ŋutɔ èkpɔ nu si Yehowa miaƒe Mawu wɔ fia eve mawo. Miwɔ nu ma tɔgbi ke fiaɖuƒe siwo le Yɔdan tɔsisi la godo. ");
INSERT INTO ewe_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Mègavɔ̃ dukɔ siwo le afi ma la o, elabena Yehowa, wò Mawu la awɔ aʋa na wò.” ");
INSERT INTO ewe_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Meƒo koko sia na Yehowa le ɣe ma ɣi be, ");
INSERT INTO ewe_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“Aƒetɔ Yehowa, wò ŋutɔ ède asi wò gãnyenye kple wò abɔ sesẽ la ɖeɖe fia wò subɔla me xoxo, elabena Mawu kae le dziƒo alo anyigba dzi si ate ŋu awɔ wò nuwɔna siawo tɔgbi? ");
INSERT INTO ewe_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Meɖe kuku na wò, na made anyigba nyui si le Yɔdan tɔsisi la godo la dzi dzro, be makpɔ to nyui ma kple Lebanon.” ");
INSERT INTO ewe_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Ke Yehowa do dɔmedzoe ɖe ŋunye le miawo ta, eye meɖe mɔ nam be matso tɔsisi la o. Eɖe gbe nam be, “Esɔ gbɔ, mègaƒo nu tso nya sia ŋu azɔ o, ");
INSERT INTO ewe_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","ke boŋ yi Pisga to la tame, afi si nàte ŋu ɣetoɖoƒe kple anyiehe, dziehe kple ɣedzeƒe gome ɖa; àkpɔ anyigba la le didiƒe tso afi ma. Ke màtso Yɔdan tɔsisi la o. ");
INSERT INTO ewe_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Na Yosua naxɔ ɖe tewòƒe. De dzi ƒo nɛ, elabena eyae akplɔ ameawo atso tɔsisi la be woaxɔ anyigba si nàkpɔ tso to la tame.” ");
INSERT INTO ewe_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Míetsi bali la me le Bet Peor kasa. ");
INSERT INTO ewe_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","“O! Israel, azɔ la, se se kple ɖoɖo siwo mele fia wò ge, lé wo me ɖe asi ale be nànɔ agbe ayi aɖaxɔ anyigba si Yehowa, mia fofowo ƒe Mawu la le mia nam. ");
INSERT INTO ewe_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Mègatsɔ naneke kpe se siwo mede na wò, eye mègaɖe naneke le wo me o, ke boŋ lé Yehowa, miaƒe Mawu la ƒe se siwo mele mia nam la me ɖe asi. ");
INSERT INTO ewe_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Miawo ŋutɔ miekpɔ nu si Yehowa wɔ le Baal Peor kple miaƒe ŋkuwo. Yehowa, miaƒe Mawu la tsrɔ̃ ame siwo katã dze Baal Poer yome la le mia dome. ");
INSERT INTO ewe_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Ke mi ame siwo katã ku ɖe Yehowa, miaƒe Mawu la ŋuti la, miegale agbe va se ɖe egbe. ");
INSERT INTO ewe_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","“Kpɔ ɖa, mefia se kple ɖoɖo siwo Yehowa, nye Mawu de nam la mi ale be mialé wo me ɖe asi le anyigba si dzi mieyina be yewoaxɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Milé ŋku ɖe wo ŋu nyuie, elabena esiae aɖe miaƒe nunya kple nugɔmesese afia dukɔ siwo ase se siawo, eye woagblɔ be, ‘Vavãe, dukɔ xɔŋkɔ sia me tɔwo nye nunyalawo kple nugɔmeselawo.’ ");
INSERT INTO ewe_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Dukɔ bubu kae li, si xɔ ŋkɔ ale gbegbe be woƒe mawuwo tsɔ ɖe wo gbɔ abe ale si Yehowa, míaƒe Mawu la tsɔ ɖe mia gbɔ ne míedo gbe ɖa nɛ ene? ");
INSERT INTO ewe_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Eye dukɔ bubu kae gali si de ŋgɔ ale gbegbe be, se kple ɖoɖo dzɔdzɔe siawo tɔgbi le wo si abe se siwo metsɔ le mia ŋkume ɖom egbea ene? ");
INSERT INTO ewe_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Ke ɖeko miakpɔ nyuie, akpɔ mia ɖokuiwo dzi nyuie, ale be miagaŋlɔ nu siwo miaƒe ŋkuwo kpɔ alo ana woado le miaƒe dzi me zi ale si miele agbe o. Mifia wo mia viwo kple wo vi siwo ava ɖe wo yome. ");
INSERT INTO ewe_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","“Miɖo ŋku ŋkeke si dzi mietsi tsitre ɖe Yehowa, miaƒe Mawu la ŋkume le Horeb to la gbɔ, esi wògblɔ nam be, ‘Ƒo ameha la nu ƒu ɖe nye ŋkume be, woase nye nyawo ale be woasrɔ̃ ale si woade bubu ŋunye zi ale si wole agbe le anyigba la dzi, eye woawo hã woafia wo viwo.’ ");
INSERT INTO ewe_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Mietsi tsitre ɖe to la te, dzo ƒe aɖewo do tso to la me yi keke dziŋgɔli me ke, eye lilikpo yibɔwo kple viviti tsiɖitsiɖi ƒo xlã to la. ");
INSERT INTO ewe_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Tete Yehowa ƒo nu na mi to dzo bibi la me. Miese eƒe nyawo, gake miekpɔ eya ŋutɔ o. Eƒe gbe ko mise. ");
INSERT INTO ewe_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Eɖe gbeƒã eƒe nubabla, eƒe Se Ewoawo, siwo wòde na mi be mialé wo me ɖe asi, eye woŋlɔ wo ɖe kpe kpakpa eve dzi na mi. ");
INSERT INTO ewe_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Ɣe ma ɣie Yehowa gblɔ nam be mafia ɖoɖo kple se siwo me mialé ɖe asi le anyigba si miele Yɔdan tɔsisi la tsom be miaxɔ la dzi.” ");
INSERT INTO ewe_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","“Miekpɔ nɔnɔme aɖeke tɔgbi gbe si gbe Yehowa ƒo nu na mi le Horeb tso dzo la me o, eya ta mikpɔ mia ɖokuiwo dzi nyuie, ");
INSERT INTO ewe_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ale be miadze nu vɔ̃ me, eye miawɔ legba aɖeke na mia ɖokuiwo ɖe nɔnɔme aɖeke me o; ne wowɔe wòɖi ŋutsu alo nyɔnu o, ");
INSERT INTO ewe_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","alo wòɖi lã aɖe le anyigba dzi alo xevi dzodzoe aɖeke loo alo ");
INSERT INTO ewe_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","lã sue si ƒua du le anyigba alo tɔmelã o. ");
INSERT INTO ewe_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Kpe ɖe esia ŋu la, migawu mo dzi be yewoasubɔ ɣe, ɣleti alo ɣletiviwo o. Yehowa miaƒe Mawu akpɔ nublanui na dukɔ bubu siwo awɔ nu sia, gake makpɔ nublanui na miawo ya o. ");
INSERT INTO ewe_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Yehowa ɖe mi tso kluvinyenye me le Egipte be mianye yeƒe dukɔ tɔxɛ kple eya ŋutɔ ƒe domenyilawo, eye woawoe nye nu siwo mienye egbe. ");
INSERT INTO ewe_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ke edo dɔmedzoe ɖe ŋunye ɖe miawo ta. Eka atam be nyematso Yɔdan tɔsisi la age ɖe anyigba nyui si Yehowa miaƒe Mawu tsɔ na mi abe miaƒe domenyinu ene la dzi o. ");
INSERT INTO ewe_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Ele be maku le afi sia, le Yɔdan tɔsisi la ƒe akpa sia dzi. ");
INSERT INTO ewe_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Mikpɔ nyuie be miagagblẽ nubabla si Yehowa, miaƒe Mawu wɔ kpli mi la me o! Miagblẽ nubabla sia me ne miewɔ legbawo, elabena Yehowa, miaƒe Mawu la de se sesẽ ɖe nu sia nu. ");
INSERT INTO ewe_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Yehowa miaƒe Mawu la nye dzo si fiaa nu kple Mawu si ʋãa ŋu. ");
INSERT INTO ewe_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","“Ne mieva nɔ anyigba la dzi eteƒe didi, ne miedzi mia viwo kple tɔgbuiyɔviwo, eye miegblẽ kɔ ɖo na mia ɖokuiwo to legbawo wɔwɔ me, eye Yehowa miaƒe Mawu la do dɔmedzoe ɖe mia ŋu kaɖikaɖi le miaƒe nu vɔ̃wo ta la, ");
INSERT INTO ewe_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","ekema dziƒo kple anyigba anye ɖasefowo be woatsrɔ̃ mi kaba le anyigba la dzi. Fifia, esusɔ vie miatso Yɔdan tɔsisi la, eye miaxɔ anyigba ma. Ke miaƒe ŋkekewo le afi ma anɔ kpuie, elabena woatsrɔ̃ mi keŋkeŋ. ");
INSERT INTO ewe_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Yehowa akaka mi ɖe dukɔwo dome, eye miagasɔ gbɔ o. ");
INSERT INTO ewe_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Le didiƒenyigbawo dzi la, miasubɔ legba siwo wowɔ kple ati kple kpe, legba siwo mekpɔa nu, sea nu, ɖua nu alo sea nu ƒe ʋeʋẽ o. ");
INSERT INTO ewe_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","“Ke miagade asi Yehowa, miaƒe Mawu la didi me. Miakpɔe ne miedii kple miaƒe dzi kple luʋɔ blibo. ");
INSERT INTO ewe_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ne vevesese ƒe ŋkeke mawo va tu mi emegbe la, miatrɔ ava Yehowa, miaƒe Mawu la gbɔ mlɔeba, eye miaɖo to eƒe nyawo azɔ, ");
INSERT INTO ewe_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","elabena Yehowa miaƒe Mawu kpɔa nublanui na ame. Magblẽ mi ɖi o, matsrɔ̃ mi o, eye maŋlɔ ŋugbe siwo wòdo na mia fofowo la be o.” ");
INSERT INTO ewe_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","“Mida ŋku ɖe xexea me ƒe ŋutinya me tso keke esime Mawu wɔ amegbetɔ ɖe anyigba dzi. Midii tso dziƒo ƒe akpa ɖeka yi akpa bubu ne miakpɔe ɖa be nya sia tɔgbi dzɔ kpɔ mahã. ");
INSERT INTO ewe_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Dukɔ blibo se Mawu ƒe gbe wòƒo nu nɛ tso dzo bibi me, abe ale si miawo miese ene, eye dukɔ la gali! ");
INSERT INTO ewe_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Teƒe bubu kae miagate ŋu akpɔ ale si Mawu ɖe dukɔ aɖe tso kluvinyenye me, eye wòɖo dɔvɔ̃ dziŋɔwo ɖa, wɔ nukunu triakɔwo, eye wòhe aʋawɔwɔ kple ŋɔdzi vɛ la ƒe kpɔɖeŋu le? Nu sia tututue Yehowa, miaƒe Mawu la wɔ na mi le Egipte le miawo ŋutɔ mia ŋkume. ");
INSERT INTO ewe_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Ewɔ nu siawo ale be miadze sii, be Yehowae nye Mawu, eye mawu bubu aɖeke megali abe eya ene o. ");
INSERT INTO ewe_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Ena miese eƒe gbe wònɔ nu fiam mi tso dziƒo. Ena miekpɔ eƒe dzo bibi gã la le anyigba dzi. Miese eƒe gbe gɔ̃ hã tso dzo bibi la titina. ");
INSERT INTO ewe_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","“Esi wòlɔ̃ mia tɔgbuiwo, eye wòdi be yeayra woƒe dzidzimeviwo tae eya ŋutɔ kplɔ mi tso Egipte kple eƒe ŋusẽ gã la ɖeɖe fia. ");
INSERT INTO ewe_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","Enya dukɔ siwo sesẽ wu mi sãa la ɖa, eye wòtsɔ woƒe anyigbawo na mi abe domenyinu ene, abe ale si wòle egbe ene. ");
INSERT INTO ewe_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Esiae nye nu si ŋuti miabu egbe: Yehowae nye Mawu le dziƒo kple anyigba afi sia; le eya megbe la, Mawu bubu aɖeke megali o! ");
INSERT INTO ewe_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ele be miawɔ se siwo made na mi egbe la dzi, ale be nu sia nu nanyo na mi kple mia viwo, eye mianɔ anyigba si Yehowa, miaƒe Mawu la le mia nam la dzi tegbetegbe.” ");
INSERT INTO ewe_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Le esia megbe la, Mose ɖoe na Israelviwo be woatia du etɔ̃ le Yɔdan tɔsisi la ƒe ɣedzeƒe lɔƒo, ");
INSERT INTO ewe_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ale be ne ame aɖe wu ame to nu maɖowɔ me la, wòate ŋu asi ayi du siawo me, eye wòanɔ dedie. ");
INSERT INTO ewe_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Du siawo dometɔ ɖekae nye Bezer, le gbegbe la ƒe tonyigba dzi. Du sia li na Ruben ƒe viwo. Du eveliae nye, Ramot le Gilead. Eya li na Gad ƒe viwo. Du etɔ̃liae nye Golan, le Basan, eye wòli na Manase ƒe viwo. ");
INSERT INTO ewe_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Se siwo gbɔna la nye se siwo Mose de na Israelviwo, ");
INSERT INTO ewe_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","esi wodzo le Egipte, eye woƒu asaɖa anyi ɖe ");
INSERT INTO ewe_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Yɔdan tɔsisi la ƒe go kemɛ dzi le Bet Peor kasa. Anyigba sia dzie Amoritɔwo nɔ tsã le woƒe Fia Sixɔn te, eye woƒe fiadu nye Hesbon. Mose kple Israelviwo tsrɔ̃ Fia Sixɔn kple eƒe amewo. ");
INSERT INTO ewe_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Israel xɔ Fia Sixɔn kple Basan fia Ɔg ƒe anyigba. Sixɔn kple Ɔg wonye Amoritɔwo ƒe fia eveawo, ame siwo nɔ Yɔdan tɔsisi la ƒe ɣedzeƒe lɔƒo. ");
INSERT INTO ewe_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Israelviwo xɔ anyigba la katã tso Aroer si le Arnon tɔsisi la ƒe balime ƒe liƒo dzi va se ɖe Sirion to (si wogayɔna be Hermon to) la gbɔ ");
INSERT INTO ewe_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","kple Arabanyigba la katã, le Yɔdan tɔsisi la ƒe ɣedzeƒe yi Dzeƒu la nu, le Pisga to la te. ");
INSERT INTO ewe_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mose gaƒo nu na Israelviwo gblɔ be, Miɖo to nyuie miase se siwo katã Yehowa de na mi. Misrɔ̃ wo, eye miakpɔ egbɔ be yewowɔ wo dzi! ");
INSERT INTO ewe_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Yehowa mía Mawu la bla nu kpli mi le Horeb to la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Mebla nu kple mia tɔgbuiwo o, ke boŋ kple mi ame siwo le agbe, le afi sia fifia ");
INSERT INTO ewe_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Eƒo nu kpli mi ŋkume kple ŋkume tso dzo bibi la titina le afi ma, le to la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Menɔ miawo kple Yehowa dome, elabena mienɔ vɔvɔ̃m, eye mieyi egbɔ le to la dzi o. Eƒo nu nam, eye metsɔ eƒe seawo na mi. Nya siwo wògblɔ la woe nye: ");
INSERT INTO ewe_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“Nyee nye Yehowa, wò Mawu, si kplɔ wò tso kluvinyenye me le Egiptenyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“Mègasubɔ mawu bubu aɖeke kpe ɖe ŋunye o. ");
INSERT INTO ewe_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Mègawɔ legba aɖeke na ɖokuiwò o, eɖanye nu siwo le dziƒo alo anyigba dzi afii loo, alo tɔ me la ƒe nɔnɔme o. ");
INSERT INTO ewe_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Mègade ta agu na wo o, eye mègasubɔ wo le mɔ aɖeke nu o, elabena nye Yehowa, wò Mawu la, Mawu ʋãŋue menye. Mehea to na ɖevi siwo léa fum la ɖe wo fofowo ƒe vodadawo teƒe va se ɖe dzidzime etɔ̃lia kple enelia dzi. ");
INSERT INTO ewe_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Ke meɖea nye lɔlɔ̃ fiaa dzidzime akpe nane siwo lɔ̃am, eye wowɔa nye seawo dzi. ");
INSERT INTO ewe_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Mègayɔ Yehowa, wò Mawu la ƒe ŋkɔ dzodzro o, elabena Yehowa magbe tohehe na ame si yɔ eƒe ŋkɔ dzodzro la o. ");
INSERT INTO ewe_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Wɔ ɖe Dzudzɔgbe la dzi, eye nàwɔe kɔkɔe abe ale si Yehowa, wò Mawu la de se na wòe ene. ");
INSERT INTO ewe_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Wɔ wò dɔwo katã le ŋkeke ade me, ");
INSERT INTO ewe_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ke ŋkeke adrelia nye Yehowa, wò Mawu la ƒe Dzudzɔgbe. Mègawɔ dɔ aɖeke le edzi o. Wò aƒemetɔ aɖeke hã mekpɔ mɔ awɔ dɔ aɖeke gbe ma gbe o, eɖanye viwò ŋutsuwo, viwò nyɔnuwo, wò dɔlaŋutsu, wò dɔlanyɔnu, wò nyiwo, wò tedziwo alo wò lãwo katã o. Ele be amedzro siwo le mia dome gɔ̃ hã nawɔ se sia dzi. Ele be ame sia ame nadzudzɔ abe ale si wò ŋutɔ nàwɔ ene. ");
INSERT INTO ewe_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Ɖo ŋku edzi be, ènye kluvi le Egipte kpɔ, eye Yehowa, wò Mawu la kplɔ wò do goe tso teƒe ma kple asi sesẽ kple abɔ si wòdo ɖe dzi. Le esia ta Yehowa, wò Mawu la de se na wò be nàɖo ŋku Dzudzɔgbe la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Bu fofowò kple dawò. Ɖo ŋku edzi be esiae nye Yehowa, wò Mawu la ƒe se. Ne èwɔ ɖe edzi la, ànɔ agbe didi, eye wòadze edzi na wò le anyigba si Yehowa, wò Mawu la le nawòm la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Mègawu ame o. ");
INSERT INTO ewe_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Mègawɔ ahasi o. ");
INSERT INTO ewe_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Mègafi fi o. ");
INSERT INTO ewe_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Mègaɖi aʋatsoɖase le hawòvi ŋuti o. ");
INSERT INTO ewe_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Mègabia ŋu hawòvi ɖe srɔ̃a ta alo ɖe eƒe aƒe, anyigba, dɔlaŋutsu, dɔlanyɔnu, nyiwo, tedziwo loo, alo nu sia nu si nye etɔ la ta o.” ");
INSERT INTO ewe_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Yehowa de se siawo na mia dometɔ ɖe sia ɖe tso dzo bibi la titina esime lilikpo la kple viviti tsiɖitsiɖi ƒo xlã Sinai to la, se mawo ko wòde na mi ɣe ma ɣi, eye megatsɔ bubu aɖeke kpee o. Eŋlɔ wo ɖe kpe kpakpa eve dzi hetsɔ nam. ");
INSERT INTO ewe_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Ke esi miese gbe sesẽ la tso viviti la me, eye miekpɔ dzo bibi dziŋɔ la le to la tame la, miaƒe toawo ƒe kplɔlawo katã va gbɔnye, ");
INSERT INTO ewe_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","eye woɖe kuku be, “Egbe la, Yehowa, míaƒe Mawu la ɖe eƒe ŋutikɔkɔe kple gãnyenye fia mí. Míese eƒe gbe gɔ̃ hã tso dzo bibi la titina. Azɔ la, míenya be ame ate ŋu aƒo nu kple Mawu, eye maku o. ");
INSERT INTO ewe_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Ke míeka ɖe edzi be míaku ne Yehowa míaƒe Mawu gaƒo nu na mí azɔ. Dzo bibi dziŋɔ sia atsrɔ̃ mí. ");
INSERT INTO ewe_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Ame kae ate ŋu ase Mawu gbagbe la ƒe gbe tso dzo bibi la titina abe ale si míawo míesee ene, eye wòatsi agbe? ");
INSERT INTO ewe_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Yi nàɖo to nya siwo katã Yehowa, míaƒe Mawu la le gbɔgblɔm, eye nàva gblɔe na mí, ekema míaɖo to, eye miawɔ ɖe wo dzi.” ");
INSERT INTO ewe_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Yehowa lɔ̃ ɖe miaƒe biabia la dzi, eye wògblɔ nam be, “Mese nya si wò ameawo gblɔ na wò; melɔ̃ ɖe edzi. ");
INSERT INTO ewe_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","O! Ne dzi sia tɔgbi anɔ wo me ɣe sia ɣi, eye woadi be yewoawɔ nye seawo dzi la, ekema nu sia nu anyo na wo le ŋgɔgbea, eye wòanyo na wo viwo to dzidzimeawo katã me! ");
INSERT INTO ewe_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“Yi, nàgblɔ na wo be, woatrɔ ayi woƒe agbadɔwo me. ");
INSERT INTO ewe_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Emegbe la, wò ŋutɔ nàtrɔ va, atsi tsitre ɖe axanye le afi sia, matsɔ nye seawo katã na wò, nàfia seawo ameawo ne woawɔ wo dzi le anyigba si mele wo na ge la dzi.” ");
INSERT INTO ewe_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Ale Mose gblɔ na ameawo be, “Ele be miawɔ ɖe Yehowa, miaƒe Mawu la ƒe seawo dzi, miazɔ ɖe eƒe ɖoɖo ɖe sia ɖe nu tututu, eye miazɔ le mɔ si wòta na mi la dzi pɛpɛpɛ. ");
INSERT INTO ewe_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Ne miewɔ esia la, eya ko hafi mianɔ agbe didi, eye wòadze edzi na mi le anyigba si xɔ ge miala la dzi.” ");
INSERT INTO ewe_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Yehowa, miaƒe Mawu la gblɔ nam be matsɔ se siawo katã na mi, miawɔ ɖe wo dzi le anyigba si dzi yi ge miala fifia, eye mianɔ la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Se siawo ƒe taɖodzinue nye woana miawo, mia viwo kple mia tɔgbuiyɔviwo miavɔ̃ Yehowa, miaƒe Mawu la to eƒe ɖoɖowo katã dzi wɔwɔ me le miaƒe agbemeŋkekewo katã me. Ne miete ŋu wɔe la, ƒe geɖe siwo me nunyoname geɖewo le la anɔ mia ŋgɔ, ");
INSERT INTO ewe_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","eya ta O! Israel, ɖo to se ɖe sia ɖe, eye nàkpɔ egbɔ be yewɔ ɖe wo dzi ale be nàkpɔ dzidzedze le nu sia nu me, eye nàdzi sɔ gbɔ. Ne èwɔ ɖe se siawo katã dzi la, àzu dukɔ gã aɖe le anyigba nyui la dzi afi si “notsi kple anyitsi bɔ ɖo” abe ale si fofowòwo ƒe Mawu la do ŋugbe na wò ene. ");
INSERT INTO ewe_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","O! Israel, ɖo to: Yehowa míaƒe Mawu la, Yehowa ɖeka koe. ");
INSERT INTO ewe_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Ele be nàlɔ̃ Yehowa, wò Mawu la kple wò dzi blibo, wò luʋɔ blibo kple wò ŋusẽ blibo. ");
INSERT INTO ewe_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Hekpe ɖe esia ŋuti la, ele be nàbu se siwo mele nawòm egbe la ŋu ɣe sia ɣi. ");
INSERT INTO ewe_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Ele be nàkui ɖe to me na viwòwo, eye nàƒo nu na wo tso wo ŋu ne miele aƒe me alo ne miele tsa ɖim, le anyimlɔɣi kple fɔfɔɣi abe nu gbãtɔ ene le ŋdi me. ");
INSERT INTO ewe_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Tsi wo ɖe wò asibidɛ ŋu abe dzesi ene, bla wo ɖe wò ŋgonu, ");
INSERT INTO ewe_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","eye nàŋlɔ wo ɖe ʋɔtrutiwo ŋu le wò aƒe me! ");
INSERT INTO ewe_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Ne Yehowa, wò Mawu la kplɔ wò va ɖo anyigba si ŋugbe wòdo na fofowòwo, Abraham, Isak kple Yakob dzi, eye ne etsɔ du gã siwo me nu nyuiwo le na wò, ");
INSERT INTO ewe_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","du siwo mètso o, vudo siwo mèɖe o, waingble siwo mède o kple amiti siwo mèdo o, eye ne èɖu nu ɖi ƒo la, ");
INSERT INTO ewe_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","ekema kpɔ nyuie be, màŋlɔ Yehowa si kplɔ wò tso Egiptenyigba dzi, tso kluvinyenye me la be o. ");
INSERT INTO ewe_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Ne èɖi ƒo la, mègaŋlɔ Yehowa, wò Mawu la vɔvɔ̃ kple esubɔsubɔ be o. Wɔ eya ko ƒe ŋkɔ ŋu dɔ le atamkaka me. ");
INSERT INTO ewe_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Mele be nàsubɔ dukɔ siwo ƒo xlã wò la ƒe mawuwo o, ");
INSERT INTO ewe_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","elabena Yehowa, wò Mawu la, ame si le mia dome la nye Mawu ʋãŋu; ate ŋu ado dɔmedzoe ɖe ŋuwò, eye wòatsrɔ̃ wò ɖa le anyigba la ŋkume. ");
INSERT INTO ewe_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Mele be nàte Yehowa wò Mawu la kpɔ abe ale si nètee kpɔ le Masa ene o. ");
INSERT INTO ewe_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Ele be nàwɔ eƒe sewo katã dzi. ");
INSERT INTO ewe_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Eya ko hafi nàwɔ nu si dze, eye wònyo le Yehowa ŋkume. Ne èwɔ ɖe eƒe sewo dzi la, nu sia nu adze edzi na wò, eye nàte ŋu ayi aɖaxɔ anyigba nyui si ŋugbe Yehowa do na tɔgbuiwòwo. ");
INSERT INTO ewe_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","Hekpe ɖe esia ŋu la, ànya ame siwo le anyigba la dzi ɖa abe ale si Yehowa do ŋugbe be yeakpe ɖe ŋuwò nàwɔ ene. ");
INSERT INTO ewe_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Ne viwò va bia wò gbe aɖe gbe be, “Nu ka see nye esi Yehowa miaƒe Mawu de na mi?” hã la, ");
INSERT INTO ewe_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","ele be nàgblɔ nɛ be, “Míenye Farao ƒe kluviwo kpɔ le Egipte. Yehowa ɖe mí tso Egipte to eƒe ŋusẽ gã la ");
INSERT INTO ewe_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","kple nukunu gãwo wɔwɔ kple fufiafia Egipte, Farao kple eƒe amewo katã me. Míekpɔ nu siawo katã kple míaƒe ŋkuwo. ");
INSERT INTO ewe_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Yehowa kplɔ mí tso Egipte be yeate ŋu atsɔ anyigba sia, si ŋugbe wòdo na mía tɔgbuiwo la na mí. ");
INSERT INTO ewe_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Ebia tso mía si be míawɔ se siawo katã dzi, eye míade bubu ye ŋu ale be yeate ŋu alé agbe ɖe te na mí abe ale si wòwɔ va se ɖe fifia ene, ");
INSERT INTO ewe_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","elabena ɣe sia ɣi si míewɔ ɖe Yehowa miaƒe Mawu ƒe seawo katã dzi la, nu sia nu dzea edzi na mí nyuie.” ");
INSERT INTO ewe_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Ne Yehowa miaƒe Mawu kplɔ wò yi Ŋugbedodonyigba la dzi, abe ale si wòle wɔwɔ ge kpuie ene la, atsrɔ̃ dukɔ adre siwo dometɔ ɖe sia ɖe lolo, eye wòsẽ wu wò. Dukɔ siawoe nye: Hititɔwo, Girgasitɔwo, Amoritɔwo, Kanaantɔwo, Perizitɔwo, Hivitɔwo kple Yebusitɔwo. ");
INSERT INTO ewe_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Ne Yehowa, wò Mawu la tsɔ wo de asi na wò be nàtsrɔ̃ wo la, ele be nàtsrɔ̃ wo keŋkeŋ. Mègawɔ nubabla kpli wo alo nàkpɔ nublanui na wo o. Tsrɔ̃ wo keŋkeŋ. ");
INSERT INTO ewe_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Mègaɖe srɔ̃ tso wo dome o, eye mègaɖe mɔ viwò ŋutsuwo kple viwò nyɔnuwo naɖe wo vinyɔnuwo kple wo viŋutsuwo o. ");
INSERT INTO ewe_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Ne viwòwo ɖe wo viwo la, viwòwo asubɔ woƒe mawuwo godoo. Ekema Yehowa ƒe dɔmedzoe abi ɖe ŋuwò, eye Yehowa atsrɔ̃ wò kokoko. ");
INSERT INTO ewe_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ele be nàmu woƒe vɔsamlekpuiwo, agbã woƒe legbawo, aho woƒe aƒeliwo aƒu anyi, eye nàtɔ dzo woƒe aklamakpakpɛwo, ");
INSERT INTO ewe_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","elabena wò la, dukɔ kɔkɔe nènye, eye wotsɔ wò na Yehowa, wò Mawu la. Etia wò tso xexemedukɔwo katã dome be nànye yeƒe dukɔ tiatia. ");
INSERT INTO ewe_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Etia wò, eye wòkɔ eƒe lɔlɔ̃ ɖe dziwò duu, menye esi nènye dukɔ si lolo wu bubuawo ta o, elabena wòe nye suetɔ kekeake le dukɔwo dome! ");
INSERT INTO ewe_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Esi wòlɔ̃ wò kple ale si wòwɔ atam si wòka na tɔgbuiwòwo dzi ta koe. Eya ta wòɖe wò tso kluvinyenye me le Egiptenyigba dzi to eƒe ŋusẽ gã ɖeɖe fia kple nukunu triakɔwo wɔwɔ me. ");
INSERT INTO ewe_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Eya ta nyae bena Yehowa, wò Mawu la nye Mawu nuteƒewɔla. Ewɔa eƒe ŋugbedodowo dzi na dzidzime akpewo, eye wòtsɔa lɔlɔ̃ mavɔ lɔ̃a ame siwo lɔ̃nɛ, eye wowɔa eƒe seawo dzi. ");
INSERT INTO ewe_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Ke ame siwo léa fui la, woahe to na wo le dukɔwo ŋkume, eye woatsrɔ̃ wo. Eya ŋutɔ ahe to na wo. ");
INSERT INTO ewe_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Eya ta wɔ ɖe se siwo katã mele tsɔtsɔm na wò egbea la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Le wò seawo dzi wɔwɔ ta la, Yehowa, wò Mawu la awɔ ɖe eƒe nubabla si wòtsɔ lɔ̃ wò kple fofowòwo la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Kpe ɖe esia ŋu la, alɔ̃ wò, ayra wò, eye wòawɔ wò nàzu dukɔ gã aɖe. Ana nàdzi asɔ gbɔ, wò anyigba nanyo nukuwo, eye wò lãwo hã nadzi asɔ gbɔ, ale be wò bli, wain, ami, nyiwo, alẽwo kple gbɔ̃wo asɔ gbɔ ne mieva ɖo anyigba si ŋugbe wòdo na fofowòwo be yeatsɔ na wo la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Yehowa ayra wò wu dukɔ bubu ɖe sia ɖe le xexea me. Wò ŋutsuwo kple nyɔnuwo siaa dometɔ aɖeke matsi ko o. Woƒe lãwo gɔ̃ hã matsi ko o. ");
INSERT INTO ewe_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Gawu la, Yehowa aɖe miaƒe dɔlélewo katã ɖa, eye mana Egiptetɔwo ƒe dɔléle siwo dzi nèɖo ŋkui nyuie la dometɔ aɖeke naɖe fu na wò o. Atsɔ dɔléle siawo katã ada ɖe wò futɔwo dzi! ");
INSERT INTO ewe_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Ele be nàtsrɔ̃ dukɔ siwo katã Yehowa, wò Mawu la tsɔ de asi na wò. Mègakpɔ nublanui na wo o, eye mègasubɔ woƒe mawuwo o. Ne ègbe toɖoɖo, eye nèwɔ nu siawo la, dzɔgbevɔ̃e ava dziwò. ");
INSERT INTO ewe_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Ɖewohĩ miabia mia ɖokuiwo be, “Dukɔ siawo sesẽ wu mí, aleke míate ŋu awɔ anya wo ɖa?” ");
INSERT INTO ewe_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Ke migavɔ̃ wo o! Miɖo ŋku nu si Yehowa, miaƒe Mawu la wɔ Farao kple Egiptenyigba blibo la ");
INSERT INTO ewe_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","miekpɔ kple miawo ŋutɔ miaƒe ŋkuwo, xaxa sesẽwo, nukunuwo kple dzesi gãwo, asi sesẽ kple abɔ si wòdo ɖe dzi si Yehowa, wò Mawu la tsɔ kplɔ wò do goe la dzi la dzi nyuie. Yehowa, wò Mawu la awɔ nenema ke na ame siwo vɔ̃m nèle fifia. ");
INSERT INTO ewe_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Gawu la, Yehowa wò Mawu la aɖo nudzodzoe teamewo ɖe wo dome va se ɖe esime ame siwo tsi agbe, eye woɣla wo ɖokuiwo la hã nàtsrɔ̃. ");
INSERT INTO ewe_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","“Mègavɔ̃ dukɔ mawo o, elabena Yehowa, wò Mawu la le mia dome; Mawu ŋusẽtɔ kple ŋɔdzitɔ wònye. ");
INSERT INTO ewe_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Yehowa, wò Mawu la maɖe mɔ be miaɖe wo katã ɖa zi ɖeka o, ne menye nenema o la, lã wɔadãwo adzi asɔ gbɔ aɖe to ɖe wò. ");
INSERT INTO ewe_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Ke Yehowa, wò Mawu la atsɔ wo ade asi na wò, ana woatɔtɔ va se ɖe esime woatsrɔ̃. ");
INSERT INTO ewe_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Mawu atsɔ woƒe fiawo ade asi na wò, eye nàtutu woƒe ŋkɔwo ɖa le anyigba la ŋkume. Wo dometɔ aɖeke mate ŋu atsi tsitre ɖe ŋuwò o. Ke boŋ àtsrɔ̃ wo. ");
INSERT INTO ewe_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Tɔ dzo woƒe legbawo, eye wo ŋu klosalo alo sika megabiã ŋu na wò o, eye mègatsɔ wo na ɖokuiwò o, elabena ŋunyɔnue wonye na Yehowa, wò Mawu la. ");
INSERT INTO ewe_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Mègatsɔ ŋunyɔnu aɖeke va aƒewò me o, ne menye nenema o la, wò hã àzu busunu si woɖo anyi na tsɔtsrɔ̃. Tsri wo vevie, eye woanyɔ ŋu na wò elabena busunuwoe wonye. ");
INSERT INTO ewe_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","“Ele be miawɔ ɖe se siwo katã mede na mi egbe la dzi. Ne miewɔ wo dzi la, miatsi agbe ɖeɖe ko o, ke boŋ miadzi sɔ gbɔ, eye miayi aɖaxɔ anyigba si ŋugbe Yehowa do na mia fofowo. ");
INSERT INTO ewe_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Mieɖo ŋku ale si Yehowa miaƒe Mawu kplɔ mi to gbedzi le ƒe blaene siawo sɔŋ me, bɔbɔ mi ɖe anyi, eye wòdo mi kpɔ be yeanya nu si miawɔ kple nenye be mialé yeƒe sewo me ɖe asi loo alo mialé wo me ɖe asi o la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Ɛ̃, ebɔbɔ mi ɖe anyi esi wòna dɔ wu mi, eye wòna mana mi be miaɖu. Miawo ŋutɔ kple mia tɔgbuiwo miekpɔ mana sia kpɔ o. Ewɔe be yeana mianya be menye nuɖuɖu koe nye nu sia nu o, eye mianyae be agbe ŋutɔ le Yehowa ƒe se ɖe sia ɖe dzi wɔwɔ me. ");
INSERT INTO ewe_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","To ƒe blaene siawo katã me la, miaƒe awuwo mevuvu o, eye miaƒe afɔwo meɖo loholoho alo te o. ");
INSERT INTO ewe_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Eya ta ele be miadze sii be Yehowa miaƒe Mawu hea to na mi be yeakpe ɖe mia ŋu abe ale si fofo hea to na via ene. ");
INSERT INTO ewe_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","“Miwɔ ɖe Yehowa, miaƒe Mawu la ƒe seawo dzi. Mizɔ ɖe eƒe ɖoɖowo nu, eye miavɔ̃e, ");
INSERT INTO ewe_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","elabena Yehowa, miaƒe Mawu la le mia kplɔm yina anyigba nyui la dzi, afi si tɔʋuwo, tawo, tsi dzidziwo, balimewo kple towo le. ");
INSERT INTO ewe_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Lu, mɔlu, wainkawo, amitiwo, yevuboɖatiwo le anyigba sia dzi. ");
INSERT INTO ewe_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Nuɖuɖu bɔ ɖe anyigba sia dzi. Naneke mehiãa ame le afi ma o. Gayibɔ bɔ ɖe afi ma abe kpe ene, eye akɔbli sɔ gbɔ ɖe towo me. ");
INSERT INTO ewe_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Ne mieɖu nu ɖi ƒo la, mikafu Yehowa, mia Mawu la le anyigba nyui si wòna mi la ta. ");
INSERT INTO ewe_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","“Ke ɣe ma ɣi tututu wòle be miaɖɔ ŋu ɖo! Mikpɔ nyuie be le ɣeyiɣi si nuɖuɖu bɔ ɖe mia si la, miagaŋlɔ Yehowa, miaƒe Mawu la be, eye miade asi aglãdzedze ɖe eŋu me o. ");
INSERT INTO ewe_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","Ne mieɖu nu ɖi ƒo, nuwo dze edzi na mi, mietu xɔ nyuiwo, ");
INSERT INTO ewe_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","miaƒe lãwo dzi, eye miaƒe klosalo kple sika sɔ gbɔ ɖe edzi la, ");
INSERT INTO ewe_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","ɣe ma ɣi tututue wòle be miaɖɔ ŋu ɖo be miagaŋlɔ Yehowa, míaƒe Mawu, si kplɔ mi tso miaƒe kluvinyenye me le Egiptenyigba dzi la be o. ");
INSERT INTO ewe_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","Mikpɔ nyuie be, miagaŋlɔ Mawu, ame si kplɔ mi to gbedzi dziŋɔ la dzi, afi si da aɖivɔ̃wo kple ahɔ̃wo bɔ ɖo, teƒe si xɔ dzo heƒu la be o. Ena tsi mi tso Agakpe la me! ");
INSERT INTO ewe_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Ena mana mi mieɖu le gbedzi. Mana nye abolo aɖe si tɔgbi ame aɖeke mekpɔ kpɔ do ŋgɔ o. Mawu wɔ esia be miabɔbɔ mia ɖokui ale be miaƒe ŋuɖoɖo ɖe ye ŋu nadzi ɖe edzi, eye yeawɔ nyui na mi. ");
INSERT INTO ewe_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Ewɔ esia, ale be miabu ɣe aɖeke ɣi be miawo ŋutɔ miaƒe ŋusẽ mee mieto zu hotsuitɔwo o. ");
INSERT INTO ewe_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Miɖo ŋku edzi ɣe sia ɣi be Yehowa, miaƒe Mawu la na ŋutete mi be miazu hotsuitɔwo. Ena miezu hotsuitɔwo be yeawɔ ɖe ŋugbe si yedo na mia fofowo la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Ke ne mieŋlɔ Yehowa, miaƒe Mawu la be, hesubɔ mawu bubuwo ɖe eteƒe, eye miedze nu vɔ̃ mɔwo dzi la, miatsrɔ̃ godoo, ");
INSERT INTO ewe_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","abe ale si Yehowa na dukɔ bubuwo tsrɔ̃ va yi la ene. Miawo hã miatsrɔ̃ nenema ke, ne miewɔ ɖe Yehowa, míaƒe Mawu la ƒe seawo dzi o.” ");
INSERT INTO ewe_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","“O! Israel, see. Èle Yɔdan tɔsisi la tso ge egbe, eye nàde asi dukɔ siwo le tɔsisi la godo la nyanya me. Dukɔ mawo tri akɔ, eye wosẽ wu wò! Woɖo gli kɔkɔwo ƒo xlã woƒe duwo. ");
INSERT INTO ewe_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Anak ƒe viwo, ame siwo nye ame dzɔatsuwo, eye dukɔ aɖeke mate ŋu anɔ te ɖe wo nu o la le wo dome. ");
INSERT INTO ewe_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Ke Yehowa, wò Mawu la anɔ ŋgɔ na wò abe dzo si fiaa nu ene be yeatsrɔ̃ wo ale be nàte ŋu aɖu wo dzi kaba, eye nànya wo ɖa le anyigba la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","“Ne Yehowa miaƒe Mawu wɔ esia na wò la, mègagblɔ na ɖokuiwò be, ‘Yehowae ve nunye, elabena menye ame dzɔdzɔe o.’ Mele nenema o. Dukɔ kemɛwo ƒe vɔ̃ɖivɔ̃ɖi tae Yehowa le esia wɔ ge ɖo. ");
INSERT INTO ewe_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Menye esi mienye ame nyui dzɔdzɔewo tae Yehowa anya wo ɖa le mia ŋgɔ ɖo o! Megale egblɔm na mi be, dukɔ kemɛwo ƒe vɔ̃ɖivɔ̃ɖi tae hekpe ɖe Yehowa miaƒe Mawu ƒe ŋugbe si wòdo na mia fofowo, Abraham, Isak kple Yakob ŋu ta koe. ");
INSERT INTO ewe_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Megale egblɔm ake be, Yehowa, miaƒe Mawu la mele anyigba nyui sia tsɔm na mi le miaƒe nyonyo ta o, elabena mienyo o. Mienye dukɔ vɔ̃ɖi kple kɔlialiatɔwo.” ");
INSERT INTO ewe_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Migaŋlɔ be o, ke boŋ miɖo ŋku ale si miedo dɔmedzoe na Yehowa, miaƒe Mawu la enuenu le gbedzi, tso gbe si gbe miedzo le Egipte va se ɖe fifia dzi. Miedze aglã ɖe eŋu le ɣeyiɣi siawo katã me. ");
INSERT INTO ewe_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Mieɖo ŋku ale si miedo dɔmedzoe nɛ le Horeb to la gbɔ dzi oa? Enɔ klalo be yeatsrɔ̃ mi. ");
INSERT INTO ewe_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Menɔ toa dzi ɣe ma ɣi, eye menɔ nubabla si Yehowa wɔ kpli mi, si nye kpe siwo dzi wòŋlɔ seawo ɖo la xɔm. Menɔ afi ma ŋkeke blaene kple zã blaene. Nyemeɖu naneke le ɣeyiɣi ma katã me o. Nyemeno tsi gɔ̃ hã o. ");
INSERT INTO ewe_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Yehowa tsɔ kpe kpakpa eve siwo dzi Mawu tsɔ eƒe asibidɛ ŋlɔ nu ɖo la nam. Se siwo katã Yehowa de na mí le toa dzi to dzo me le miaƒe takpegbe la le wo dzi. ");
INSERT INTO ewe_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Le ŋkeke blaeneawo kple zã blaeneawo ƒe nuwuwu la, Yehowa tsɔ kpe kpakpa eveawo, nubabla ƒe kpe kpakpawo nam. ");
INSERT INTO ewe_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Egblɔ nam be maɖi yi anyigba kaba, elabena dukɔ si mekplɔ tso Egipte la gblẽ kɔ ɖo na eɖokui; eɖe asi le Mawu ƒe seawo ŋu kaba, eye wòlolõ ga hetsɔ wɔ legbae. ");
INSERT INTO ewe_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Tete Yehowa gblɔ nam be, “Mekpɔe be dukɔ sia nye ame kɔlialiatɔwo sɔŋ. ");
INSERT INTO ewe_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Ɖe asi le ŋunye matsrɔ̃ wo, matutu woƒe ŋkɔwo ɖa le dziƒoa te, eye mawɔ wò boŋ wò dzidzimeviwo woazu dukɔ si akpɔ ŋusẽ, eye wòalolo wu Israel.” ");
INSERT INTO ewe_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Metrɔ gbɔ tso to bibi la dzi le esime melé kpe eve siwo dzi Mawu ŋlɔ eƒe seawo ɖo la ɖe asi. ");
INSERT INTO ewe_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Le toa te la, mekpɔ nyivi si miewɔ le miaƒe nu vɔ̃ si miewɔ ɖe Yehowa miaƒe Mawu ŋu me. Miegbugbɔ le Yehowa yome kaba ŋutɔ! ");
INSERT INTO ewe_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Esia ta metsɔ kpe eveawo do ɖe dzi, eye mexlã wo ɖe anyi sesĩe! Megbã wo le mia ŋkume! ");
INSERT INTO ewe_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Le esia megbe la, meganɔ Yehowa ŋkume ŋkeke blaene kple zã blaene numaɖumaɖu, tsimanomano, elabena miewɔ nu si Yehowa lé fui wu nu sia nu, eye miena wòdo dɔmedzoe vevie ŋutɔ. ");
INSERT INTO ewe_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Mevɔ̃ ɖe mia nu ŋutɔŋutɔ, elabena Yehowa ɖo vevie be yeatsrɔ̃ mi. Ke egaɖo tom ɣe ma ɣi hã. ");
INSERT INTO ewe_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Aron ɖo xaxa gã aɖe me, elabena Yehowa do dɔmedzoe ɖe eŋu ŋutɔ. Ke medo gbe ɖa, eye Yehowa kpɔ nublanui nɛ. ");
INSERT INTO ewe_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Metsɔ miaƒe nu vɔ̃ si nye nyivi si miewɔ la, medee dzo me, tui memie wòzu ʋuʋudedi, eye metsɔ ʋuʋudedi la kɔ ɖe tɔʋu si dzɔ tso toa dzi la me. ");
INSERT INTO ewe_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Miegado dɔmedzoe na Yehowa le Tabera, emegbe le Masa, eyome le Kibrot Hatava. ");
INSERT INTO ewe_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Le Kades Barnea la, esi Yehowa gblɔ na mi be miage ɖe anyigba si wòtsɔ na mi dzi la, miedze aglã ɖe eŋuti, eye miexɔe se be akpe ɖe mia ŋu o. Miegbe toɖoɖoe. ");
INSERT INTO ewe_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Ɛ̃, mienɔ aglã dzem ɖe Yehowa ŋu tso gbe si gbe ke menya mi, ");
INSERT INTO ewe_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","eya ta metsyɔ mo anyi ɖe Yehowa ŋkume ŋkeke blaene kple zã blaene mawo me esime Yehowa di be yeatsrɔ̃ mi. ");
INSERT INTO ewe_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","“Medo gbe ɖa na Yehowa be, Aƒetɔ Yehowa, mègatsrɔ̃ wò ŋutɔ wò amewo o. Wò ŋutɔ wò domenyinu si nèɖe kple wò ŋusẽ triakɔ, eye nèɖe wo tso Egipte kple asi sesẽ. ");
INSERT INTO ewe_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Ɖo ŋku wò dɔlawo, Abraham, Isak kple Yakob dzi. Mègaɖo ŋku ame siawo ƒe kɔlialia kple woƒe vɔ̃ɖivɔ̃ɖi kple woƒe nu vɔ̃wo dzi o. ");
INSERT INTO ewe_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Ne menye nenema o la, dukɔ si me nèkplɔ mí do go tso la agblɔ be, ‘Esi Yehowa mete ŋu kplɔ wo yi anyigba si ƒe ŋugbe wòdo na wo dzi o, eye esi wòlé fu wo ta la, ekplɔ wo do goe be yeawu wo le gbedzi.’ ");
INSERT INTO ewe_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","Wò amewo kple wò domenyilawo wonye, ame siwo nètsɔ wò ŋusẽ triakɔ kple abɔ sesẽ la kplɔ tso Egipte.” ");
INSERT INTO ewe_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","“Yehowa gblɔ nam ɣe ma ɣi be makpa kpe eve bubu abe gbãtɔwo ene, matsɔ ati akpa aɖaka aɖe si me woatsɔ kpe eveawo adzra ɖo la, eye matrɔ ava ye, Mawu gbɔ le toa dzi. ");
INSERT INTO ewe_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","Egblɔ nam be yeagbugbɔ se siwo tututu yeŋlɔ ɖe kpe siwo megbã dzi la aŋlɔ ɖe kpe yeyeawo dzi, eye matsɔ wo ade Aɖaka la me. ");
INSERT INTO ewe_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Ale metsɔ akasiati wɔ Aɖaka la. Mekpa kpe eve abe gbãtɔwo ene hetsɔ wo yi na Yehowa le to la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Egaŋlɔ Se Ewoawo ɖe wo dzi tsɔ nam. Wonye se siwo tututu wònam tso dzo bibi la ƒe titina le toa dzi le mi katã ŋkume le to la te. ");
INSERT INTO ewe_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Meɖi eye metsɔ kpe eveawo de Aɖaka si mekpa la me. Wole afi ma va se ɖe egbe abe ale si Yehowa ɖo nam ene. ");
INSERT INTO ewe_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","“Le esia megbe la, Israelviwo zɔ mɔ tso Bene Yaakan yi Mosera afi si Aron ku, eye woɖii ɖo. Aron ƒe viŋutsu Eleaza zu nunɔla ɖe eteƒe. ");
INSERT INTO ewe_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","“Wozɔ mɔ yi Gudgoda heyi Yotbata, afi si tsi bɔ ɖo. ");
INSERT INTO ewe_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Afi mae Yehowa ɖe Levi ƒe viwo ɖe aga le be woakɔ nubablaɖaka si me Yehowa ƒe Se Ewoawo le, eye woanɔ tsitre ɖe Yehowa ŋkume awɔ Yehowa ƒe dɔ, ade bubu eƒe ŋkɔ ŋu abe ale si wowɔna egbe ene. ");
INSERT INTO ewe_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Eya ta womena anyigba Levitɔwo le Ŋugbedodonyigba la dzi abe ale si wona wo nɔvi to bubu me tɔwo ene o, elabena Yehowa, miaƒe Mawu gblɔ na wo be ye ŋutɔe nye woƒe domenyinu. ");
INSERT INTO ewe_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Abe ale si megblɔ do ŋgɔe ene la, menɔ to la dzi le Yehowa ŋkume zi evelia ŋkeke blaene kple zã blaene, abe ale si mewɔ zi gbãtɔ ene. Yehowa ɖo to nye kokoƒoƒo, eye metsrɔ̃ mi o. ");
INSERT INTO ewe_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","“Ke egblɔ nam be, ‘Tso, nàkplɔ ameawo yi anyigba si ŋugbe medo na wo fofowo la dzi. Ɣeyiɣi la de be woayi aɖaxɔe!’ ” ");
INSERT INTO ewe_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","“Azɔ, Israel, nu ka Yehowa, wò Mawu la di tso asiwò wu be nàvɔ̃ Yehowa, wò Mawu la, nàzɔ le eƒe mɔwo katã dzi, nàlɔ̃e, eye nàsubɔe kple wò dzi blibo kple wò luʋɔ blibo, ");
INSERT INTO ewe_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","eye nàwɔ ɖe Yehowa ƒe sewo kple ɖoɖo siwo katã mena mi egbe la dzi ale be wòanyo na wò? ");
INSERT INTO ewe_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Kpɔ ɖa, anyigba kple dziƒo ƒe kɔkɔƒe kekeake nye Yehowa, wò Mawu la tɔ. ");
INSERT INTO ewe_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Ke mia fofowo ƒe nu nyo eŋu, eye wòlɔ̃ wo ale gbegbe be wòtia mi, wo viwo, be miaƒo dukɔwo katã ta abe ale si wòle dzedzem egbe ene, ");
INSERT INTO ewe_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","eya ta mikɔ miaƒe nu vɔ̃ dziwo ŋu, eye miadzudzɔ kɔlialiatɔwo ƒe agbenɔnɔ. ");
INSERT INTO ewe_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","“Yehowa, miaƒe Mawu lae nye mawuwo dzi Mawu gã, ŋusẽtɔ la, Mawu si ŋu ŋɔdzi le, ame si medea ame aɖeke dzi o, eye mexɔa zãnu hã o. ");
INSERT INTO ewe_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Ewɔa nu dzɔdzɔe na tsyɔ̃eviwo kple ahosiwo. Elɔ̃a amedzrowo, eye wònaa nuɖuɖu kple nutata wo. ");
INSERT INTO ewe_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Ele be miawo hã mialɔ̃ amedzrowo, elabena miawo hã mienye amedzrowo le Egiptenyigba dzi kpɔ. ");
INSERT INTO ewe_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Ele be miavɔ̃ Yehowa, miaƒe Mawu la, miasubɔe anukwaretɔe, mialé ɖe eŋu, eye miaka atam ɖe eya ɖeɖe ko ƒe ŋkɔ dzi. ");
INSERT INTO ewe_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Eyae nye wò kafukafu, eye wòganye wò Mawu, ame si wɔ nukunu gã siwo teƒe miawo ŋutɔ miekpɔ. ");
INSERT INTO ewe_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Mia fofowo dometɔ ame blaadre koe yi Egipte, gake azɔ la, Yehowa, miaƒe Mawu la wɔ mi miedzi sɔ gbɔ abe ɣletiviwo le dziŋgɔli me ene!” ");
INSERT INTO ewe_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","“Ele be nàlɔ̃ Yehowa, wò Mawu la, eye nàwɔ eƒe sewo katã dzi. ");
INSERT INTO ewe_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Miɖo to! Nyemele nu ƒom fifia na mia viwo, ame siwo mekpɔ eƒe tohehe na Egiptetɔwo alo eƒe gãnyenye kple ŋusẽ teƒe kpɔ o. ");
INSERT INTO ewe_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","Womenɔ afi ma kpɔ nukunu siwo wòwɔ le Egipte ɖe Farao kple eƒe anyigba blibo la ŋu o. ");
INSERT INTO ewe_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","Womekpɔ nu si Mawu wɔ Egiptetɔwo ƒe aʋakɔwo, woƒe sɔwo kple tasiaɖamwo, ale si wònyrɔ wo ɖe Ƒu Dzĩ la me esi wodze mia yome kple ale si Yehowa na woƒe ŋusẽ ɖe mia ŋu nu ku va se ɖe egbeŋkeke sia dzi o! ");
INSERT INTO ewe_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Womekpɔ ale si Yehowa kpɔ mia dzi ɣe sia ɣi le ƒe siwo katã me mienɔ tsaglalã tsam le gbedzi va se ɖe esime mieɖo afi sia o. ");
INSERT INTO ewe_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","Womenɔ afi ma esime Datan kple Abiram, Eliab ƒe viŋutsuwo kple Ruben ƒe dzidzimeviwo wɔ nu vɔ̃, eye anyigba ke nu mi wo, woƒe aƒemetɔwo, agbadɔwo kple woƒe nuwo katã le Israelviwo katã ŋkume o! ");
INSERT INTO ewe_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","“Ke miawo la, miekpɔ Yehowa ƒe nukunu gã siawo teƒe, ");
INSERT INTO ewe_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","eya ta wòle be miawɔ se siwo mele mia nam egbe la dzi pɛpɛpɛ ale be miate ŋu akpɔ ŋusẽ be miayi anyigba si dzi miele gege ge ɖo fifia, eye miaxɔe. ");
INSERT INTO ewe_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","Ne miewɔ seawo dzi la, mianɔ agbe didi, eye wòadze edzi na mi le anyigba si ŋugbe Yehowa do na mia fofowo kple miawo kple miaƒe dzidzimeviwo la dzi. Anyigba la nye anyigba wɔnuku aɖe si dzi ‘notsi kple anyitsi bɔ ɖo!’ ");
INSERT INTO ewe_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Anyigba si dzi miage ɖo, eye miaxɔ la, mele abe Egiptenyigba, afi si mietso, afi si wòhiã le be miadze tɔʋu suewo ɖe miaƒe agblewo me, ana tsi nato wo me hena miaƒe agblemenukuwo ƒe wɔwɔ ene o. ");
INSERT INTO ewe_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Anyigba nyui aɖe si dzi towo kple balimewo le, eye tsi dzana le nyuie la wònye, ");
INSERT INTO ewe_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","anyigba si Yehowa, miaƒe Mawu la ŋutɔ léa be na, eye eƒe ŋku le anyigba la ŋu ɣe sia ɣi tso ŋkeke yi ŋkeke le ƒe blibo la me! ");
INSERT INTO ewe_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","“Ne miawɔ ɖe Yehowa ƒe se siwo katã mele mia na ge egbe la dzi pɛpɛpɛ, eye ne mialɔ̃ Yehowa, miaƒe Mawu la kple miaƒe dzi blibo kple miaƒe luʋɔ blibo, eye miasubɔe la, ");
INSERT INTO ewe_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","ekema agana adametsi kple kelemetsi nadza na mi ale be miate ŋu akpɔ bli fũu kple waintsetse geɖewo kple ami sɔ gbɔ. ");
INSERT INTO ewe_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Ana lãnyiƒe damawo mi hena miaƒe lãwo, eye miawo ŋutɔ miakpɔ nu aɖu, aɖi ƒo nyuie. ");
INSERT INTO ewe_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","“Ke mikpɔ nyuie be miaƒe dzi nagatrɔ le Yehowa yome be miasubɔ mawu bubuwo o. ");
INSERT INTO ewe_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Ne miesubɔ mawu bubuwo la, Yehowa ƒe dɔmedzoe abi ɖe mia ŋu, eye wòatu dziƒo nu ale be tsi magadza o, eye agblemenukuwo mawɔ o. Ekema miatsrɔ̃ enumake le anyigba nyui si Yehowa na mi la dzi, ");
INSERT INTO ewe_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","eya ta milé se siawo ɖe ta me. Mibla wo ɖe miaƒe asiwo ŋu ale be woanɔ ŋku dzi na mi, eye miawɔ wo dzi. Mibla wo ɖe miaƒe ŋgonu le miaƒe ŋkuwo dome. ");
INSERT INTO ewe_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Mifia wo mia viwo; miƒo nu na wo tso wo ŋu ne miele aƒe me, ne miele tsa ɖim, le anyimlɔɣi kple do ŋgɔ na ŋdinuɖuɖu! ");
INSERT INTO ewe_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Miŋlɔ wo ɖe miaƒe ʋɔtrutiwo ŋu le miaƒe aƒewo me kple miaƒe agbowo ŋu, ");
INSERT INTO ewe_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ale be zi ale si dziŋgɔli anɔ anyi le mia tame ko la, mi kple mia viwo miakpɔ gome le agbe vivi si le mia lalam le anyigba si ŋugbe Yehowa do na mia fofowo la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","“Ne miewɔ ɖe se siwo katã mede na mi dzi pɛpɛpɛ, ne mielɔ̃ Yehowa, miaƒe Mawu la, ne miezɔ ɖe eƒe ɖoɖowo katã dzi, eye mielé ɖe eŋu la, ");
INSERT INTO ewe_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ekema Yehowa anya dukɔwo katã ɖa le mia ŋgɔ, aleke gbegbe woasɔ gbɔ wu mi, eye woasẽ wu mi hã! ");
INSERT INTO ewe_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Afi sia afi si miaɖo afɔe la, anyigba la anye mia tɔ. Miaƒe liƒowo akeke tso Negeb ƒe anyigbeme ayi Lebanon, agatso Frat tɔsisi la ŋu, ayi Domeƒu la ŋu. ");
INSERT INTO ewe_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Ame aɖeke mate ŋu anɔ te ɖe mia nu o, elabena Yehowa, miaƒe Mawu la ade vɔvɔ̃ ameawo me ɖe mia ŋu do ŋgɔ na mi, afi sia afi si miayi abe ale si wòdo ŋugbe na mi ene tututu. ");
INSERT INTO ewe_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","“Kpɔ ɖa, metsɔ yayra kple fiƒode le mia ŋkume ɖom egbea be miatia. ");
INSERT INTO ewe_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Miaxɔ yayra ne miewɔ Yehowa, miaƒe Mawu la ƒe se siwo metsɔ le mia nam egbe la dzi, ");
INSERT INTO ewe_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","ke fiƒode ava mia dzi ne miegbe seawo dzi wɔwɔ, eye miesubɔ dukɔ bubu siawo ƒe mawuwo. ");
INSERT INTO ewe_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Ne Yehowa, miaƒe Mawu la kplɔ mi yi anyigba la dzi be miaxɔe la, ekema woaɖe gbeƒã yayra le Gerizim to dzi, eye woaɖe gbeƒã fiƒode le Ebal to dzi! ");
INSERT INTO ewe_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Gerizim kple Ebal wonye towo le Yɔdan tɔsisi la ƒe ɣetoɖoƒe lɔƒo, afi si Kanaantɔwo le, le gbegbe si te ɖe Gilgal ŋu, afi si More ƒe ati gãwo le. ");
INSERT INTO ewe_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Mitso Yɔdan tɔsisi la, eye mianɔ anyigba si Yehowa, miaƒe Mawu le mia nam la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Ke ele na mi be miawɔ ɖe se siwo katã mele mia nam egbea la dzi.” ");
INSERT INTO ewe_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","“Esiawoe nye se siwo dzi wòle be miawɔ tegbetegbe ne mieva ɖo anyigba si Yehowa, mia fofowo ƒe Mawu la na mi la dzi. ");
INSERT INTO ewe_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","“Ele be miagbã trɔ̃wo ƒe vɔsamlekpuiwo le afi sia afi si miakpɔ wo le, le towo dzi loo, le togbɛwo tame loo, alo le ati damawo te. ");
INSERT INTO ewe_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Migbã woƒe vɔsamlekpuiwo kple woƒe legbawo. Mitɔ dzo woƒe aƒeliwo. Mimu woƒe legba siwo wotsɔ ga tu la ƒu anyi. Migagblẽ naneke si aɖo ŋku woƒe trɔ̃wo dzi na mi la ɖi o. ");
INSERT INTO ewe_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Miekpɔ mɔ asa vɔ na Yehowa, miaƒe Mawu la le afi sia afi ko abe ale si trɔ̃subɔlawo sãa vɔe na woƒe mawuwo ene o, ");
INSERT INTO ewe_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","ke boŋ mitu kɔkɔeƒe aɖe ɖe afi si Yehowa, miaƒe Mawu ŋutɔ afia asii na mi abe eƒe aƒe ene le miawo ŋutɔ mia dome. ");
INSERT INTO ewe_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Afi mae miatsɔ miaƒe numevɔsawo kple vɔsa bubuawo, miaƒe nukpɔkpɔ ƒe akpa ewolia, miaƒe vɔsa siwo woatsɔ ana Mawu to wo nyenye le yame le vɔsamlekpui la ŋgɔ me, miaƒe adzɔgbeɖefewo, lɔlɔ̃nununanawo kple miaƒe lãwo ƒe ŋgɔgbeviwo ayi. ");
INSERT INTO ewe_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Afi mae miawo kple miaƒe ƒometɔwo miaɖo kplɔ̃ ɖo le Yehowa, miaƒe Mawu la ŋkume, eye miatso aseye le nu siwo katã wòwɔ na mi la ta. ");
INSERT INTO ewe_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","“Azɔ la, migalé miaƒe mɔwo atsɔ abe ale si miele wɔwɔm fifia ene, eye ame sia ame le nu si wòbu be enyo la wɔm o, ");
INSERT INTO ewe_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","elabena se siawo mebla mi haɖe o va se ɖe esime miaɖo dzudzɔƒe si Yehowa miaƒe Mawu ana mi. ");
INSERT INTO ewe_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Ke ne mietso Yɔdan tɔsisi la heɖo ŋugbedodonyigba la dzi, eye Yehowa, miaƒe Mawu na dzudzɔ mi, eye wòna mievo tso miaƒe futɔwo katã ƒe asi me la, ");
INSERT INTO ewe_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","ekema ele be miatsɔ miaƒe numevɔsawo kple vɔsa bubuawo katã ayi kɔkɔeƒe la, afi si eya ŋutɔ atia abe eƒe nɔƒe ene. ");
INSERT INTO ewe_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Miawo kple mia viŋutsuwo kple mia vinyɔnuwo kple miaƒe dɔlaŋutsuwo kple dɔlanyɔnuwo miatso aseye le afi ma le Yehowa, miaƒe Mawu ŋkume. Miɖo ŋku edzi miakpe Levitɔwo be woaɖu nu kpli mi, elabena anyigba aɖeke mele woawo ya si o. ");
INSERT INTO ewe_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","“Mele be miasa miaƒe numevɔwo le afi sia afi ko o; ");
INSERT INTO ewe_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","misa wo le teƒe si Yehowa ŋutɔ atia ko. Atia teƒe aɖe tso afi si woma na toawo dometɔ ɖeka la me. Afi ma ko miasa vɔ le, eye miatsɔ miaƒe nunanawo ayi. ");
INSERT INTO ewe_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Aleke wòle hã la, miate ŋu awu lãwo le miaƒe du ɖe sia ɖe me, aɖu lã si sinu mielɔ̃, abe ahlɔ̃e alo zi ene, le yayra si Yehowa, miaƒe Mawu la na mi la nu. Ame siwo ŋuti kɔ kple ame siwo ŋuti mekɔ o la siaa ate ŋu aɖui faa. ");
INSERT INTO ewe_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Ʋu la koe miaɖu o; mina wòatsyɔ ɖe anyigba abe tsi ene. ");
INSERT INTO ewe_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","“Migaɖu miaƒe bli, ano wain yeye, alo ami ƒe ewolia o, miaƒe alẽha alo nyiha ƒe ŋgɔgbeviwo kple nu sia nu si mieɖe adzɔgbe be miana, lɔlɔ̃nununana loo alo nunana tɔxɛwo le mia ŋutɔwo ƒe du me o. ");
INSERT INTO ewe_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Woatsɔ nu siawo katã va vɔsamlekpui la gbɔ, afi si miawo, mia viŋutsuwo kple vinyɔnuwo, miaƒe dɔlaŋutsuwo kple dɔlanyɔnuwo kple Levitɔwo tso miaƒe duwo me, miaɖu wo le, le Yehowa, miaƒe Mawu la ŋkume. Yehowa agblɔ afi si vɔsamlekpui la anɔ la na mi. Mitso aseye le Yehowa, miaƒe Mawu la ŋkume le nu sia nu si miawɔ la me. ");
INSERT INTO ewe_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","Mikpɔ nyuie be miagaŋlɔ Levitɔwo be o, zi ale si mienɔ miaƒe anyigba dzi. ");
INSERT INTO ewe_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","“Ne Yehowa, miaƒe Mawu la keke miaƒe liƒowo ɖe edzi abe ale si wòdo ŋugbee ene la, miate ŋu aɖu lã ɣe sia ɣi si mielɔ̃. ");
INSERT INTO ewe_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Ne teƒe si miesubɔa Mawu le didi akpa la, ekema ɣe sia ɣi si mielɔ̃ la, miate ŋu awu nyi alo alẽ si Yehowa tsɔ na mi, eye miaɖu lã la le aƒe me abe ale si mede se na mi la ene. ");
INSERT INTO ewe_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Ame si ŋuti kɔ kple ame si ŋuti mekɔ o hã ate ŋu aɖu lã ma abe ale si wòaɖu zi alo ahlɔ̃e ƒe lã ene, ");
INSERT INTO ewe_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","gake migaɖu lã si me ʋu le la o, elabena lã ƒe agbe le eƒe ʋu me, eye mele be miaɖu agbe la kple lã la o. ");
INSERT INTO ewe_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","Migawɔ lã ƒe ʋu ŋu dɔ abe nuɖuɖu ene o, ke boŋ mitsyɔe ɖe anyigba abe tsi ene. ");
INSERT INTO ewe_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Ne miewɔ se sia dzi la, miadze Yehowa ŋu, eye nu sia nu adze edzi na mi kple miaƒe dzidzimeviwo siaa. ");
INSERT INTO ewe_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Mitsɔ miaƒe vɔsawo kple nu siwo ŋugbe miedo na Yehowa la yi ɖe Mawusubɔƒe ɖeka ma. ");
INSERT INTO ewe_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Mitsɔ vɔsa siwo woame, woafia keŋkeŋ la da ɖe Yehowa miaƒe Mawu ƒe vɔsamlekpui dzi. Mitsɔ vɔsa siwo ƒe lã miaɖu, eye miakɔ ʋu la ɖe vɔsamlekpui la dzi la hã yi afi ma ke. ");
INSERT INTO ewe_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","Miwɔ se siwo katã mede na mi la dzi pɛpɛpɛ anukwaretɔe ekema nu sia nu adze edzi na mi kple miaƒe dzidzimeviwo nyuie tegbetegbe, elabena mianɔ nu si dzɔ, eye wòdzea Yehowa ŋu la wɔm. ");
INSERT INTO ewe_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","“Yehowa, miaƒe Mawu la atsrɔ̃ dukɔwo ne miege ɖe woƒe anyigbawo dzi. Miaxɔ woƒe anyigba, eye mianɔ edzi. ");
INSERT INTO ewe_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","Ne Yehowa tsrɔ̃ dukɔ mawo vɔ la, mikpɔ nyuie be miewɔ ɖe woƒe mawusubɔsubɔ ƒe kɔnyinyiwo dzi o, elabena wo dzi wɔwɔ ahe ku vɛ na mi. Migadze agbagba be yewoanya ale si wosubɔa woƒe mawuwo, ale be yewo hã yewoasubɔ le mɔ ma dzi o. ");
INSERT INTO ewe_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","Migasubɔ Yehowa, miaƒe Mawu la le mɔ si dzi wosubɔa woƒe mawuwo le la o, elabena le woƒe mawusubɔsubɔ me la, wowɔa nu dziŋɔ siwo Yehowa lé fue. Wotsɔa wo viwo gɔ̃ hã sãa vɔe le dzo si le woƒe vɔsamlekpui dzi la me. ");
INSERT INTO ewe_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","“Miwɔ se ɖe sia ɖe si mede na mi la dzi. Migakpe naneke ɖe wo ŋu o, eye migaɖe naneke le wo me hã o.” ");
INSERT INTO ewe_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","“Ne nyagblɔɖila aɖe le mia dome alo ame si gblɔna be yeate ŋu anya nu si le dzɔdzɔ ge to drɔ̃ekuku me, ");
INSERT INTO ewe_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","ne eƒe nyagblɔɖiwo vaa eme, gake wògblɔna be, ‘Miva, mina míasubɔ dukɔ bubuawo ƒe mawuwo’ la, ");
INSERT INTO ewe_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","migaɖo to eƒe nya o. Yehowa miaƒe Mawu le mia dome be yeanya ne mielɔ̃ ye le nyateƒe me kple miaƒe dzi blibo kple luʋɔ blibo loo alo mielɔ̃e o. ");
INSERT INTO ewe_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","Migasubɔ mawu bubu aɖeke gbeɖegbeɖe o. Misubɔ Yehowa miaƒe Mawu ko. Miwɔ ɖe eya ko ƒe sewo dzi, eye mialé ɖe eŋu. ");
INSERT INTO ewe_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","“Ele be woawu nyagblɔɖila alo drɔ̃ekula si dina be yeakplɔ mi atrae, elabena edina be yeana miadze aglã ɖe Yehowa, miaƒe Mawu, ame si kplɔ mi tso kluvinyenye me le Egiptenyigba dzi la ŋu. Ne miewui la, miaɖe nu vɔ̃ ɖa le mia dome. ");
INSERT INTO ewe_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","Ne nɔviwò ŋutsu, viwò ŋutsu, viwò nyɔnu, srɔ̃wò lɔlɔ̃a, alo xɔwò vevitɔ kekeake si le abe wò ŋutɔ wò luʋɔ ene agblɔ na wò le adzame be, ‘Na míayi aɖasubɔ mawu bubuwo (mawu siwo miawo ŋutɔ kple mia fofowo mienya o, ");
INSERT INTO ewe_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","dukɔ siwo ƒo xlã mi ƒe mawuwo, mawu siwo te ɖe mia ŋu alo le adzɔge ʋĩi, tso anyigba ƒe seƒe ɖeka yi eƒe seƒe bubu’ la), ");
INSERT INTO ewe_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","migalɔ̃ o, eye migakpɔ nublanui nɛ hã o. Migaɖee tso to si woahe nɛ la me o, eye migaɣla nya vɔ̃ɖi si wògblɔ na mi la hã o. ");
INSERT INTO ewe_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","Miwui! Nànye ame gbãtɔ si atso ɖe ewuwu ŋu, eye ame bubuawo katã ƒe asi akpe ɖe ŋuwò. ");
INSERT INTO ewe_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Miƒu kpee wòaku, elabena edze agbagba be yeahe mi ɖa tso Yehowa, mia Mawu, ame si kplɔ mi tso kluvinyenye me le Egipte la gbɔ. ");
INSERT INTO ewe_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","Ekema Israel katã asee, eye woavɔ̃, eye ame aɖeke maganɔ mia dome si awɔ nu vɔ̃ɖi sia tɔgbi ake o. ");
INSERT INTO ewe_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","“Ne miele du siwo Yehowa miaƒe Mawu na mi me, eye miese ");
INSERT INTO ewe_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","be yakame aɖewo tso miaƒe dukɔ me kplɔ miaƒe dumetɔ aɖewo trae be, ‘Woasubɔ mawu siwo miesubɔ kpɔ o’ la, ");
INSERT INTO ewe_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","miku nya la gɔme nyuie. Ne enye nyateƒe be nu vɔ̃ɖi sia va eme la, ");
INSERT INTO ewe_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","ekema ele be miaho aʋa ɖe du ma ŋu. Miwu dua me tɔwo kple lãwo katã 